# Copyright 2018 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

include(CMakeFindDependencyMacro)
find_dependency(google_cloud_cpp_common)
find_dependency(absl)
find_dependency(CURL)
find_dependency(Crc32c)
find_dependency(nlohmann_json)
find_dependency(OpenSSL)
find_dependency(ZLIB)

# Some versions of FindCURL do not define CURL::libcurl, so we define it ourselves.
if (NOT TARGET CURL::libcurl)
    add_library(CURL::libcurl UNKNOWN IMPORTED)
    set_property(TARGET CURL::libcurl
                 APPEND
                 PROPERTY INTERFACE_INCLUDE_DIRECTORIES "${CURL_INCLUDE_DIR}")
    set_property(TARGET CURL::libcurl
                 APPEND
                 PROPERTY IMPORTED_LOCATION "${CURL_LIBRARY}")
endif ()

include("${CMAKE_CURRENT_LIST_DIR}/storage-targets.cmake")
