# Copyright 2019 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

include(CMakeFindDependencyMacro)
# google_cloud_cpp_googleapis finds both gRPC and Protobuf, no need to load them here.
find_dependency(google_cloud_cpp_googleapis)
find_dependency(google_cloud_cpp_common)
find_dependency(absl)
# TODO(#5726) - this is needed to preserve backwards compatibility
find_dependency(googleapis)

include("${CMAKE_CURRENT_LIST_DIR}/grpc_utils-targets.cmake")

if (NOT TARGET google_cloud_cpp_grpc_utils)
    add_library(google_cloud_cpp_grpc_utils IMPORTED INTERFACE)
    set_target_properties(google_cloud_cpp_grpc_utils PROPERTIES
        INTERFACE_LINK_LIBRARIES google-cloud-cpp::grpc_utils)
    if (CMAKE_VERSION VERSION_GREATER 3.17)
        set_target_properties(google_cloud_cpp_grpc_utils PROPERTIES
        DEPRECATION "This target will be removed on or about 2022-02-15, please use google-cloud-cpp::grpc_utils instead")
    endif ()
endif ()
