// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/cloud/dialogflow/v2/agent.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fcloud_2fdialogflow_2fv2_2fagent_2eproto__INCLUDED
#define GRPC_google_2fcloud_2fdialogflow_2fv2_2fagent_2eproto__INCLUDED

#include "google/cloud/dialogflow/v2/agent.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace cloud {
namespace dialogflow {
namespace v2 {

// Service for managing [Agents][google.cloud.dialogflow.v2.Agent].
class Agents final {
 public:
  static constexpr char const* service_full_name() {
    return "google.cloud.dialogflow.v2.Agents";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Retrieves the specified agent.
    virtual ::grpc::Status GetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::google::cloud::dialogflow::v2::Agent* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>> AsyncGetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>>(AsyncGetAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>> PrepareAsyncGetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>>(PrepareAsyncGetAgentRaw(context, request, cq));
    }
    // Creates/updates the specified agent.
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status SetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::google::cloud::dialogflow::v2::Agent* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>> AsyncSetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>>(AsyncSetAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>> PrepareAsyncSetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>>(PrepareAsyncSetAgentRaw(context, request, cq));
    }
    // Deletes the specified agent.
    virtual ::grpc::Status DeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteAgentRaw(context, request, cq));
    }
    // Returns the list of agents.
    //
    // Since there is at most one conversational agent per project, this method is
    // useful primarily for listing all agents across projects the caller has
    // access to. One can achieve that with a wildcard project collection id "-".
    // Refer to [List
    // Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
    virtual ::grpc::Status SearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::SearchAgentsResponse>> AsyncSearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::SearchAgentsResponse>>(AsyncSearchAgentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::SearchAgentsResponse>> PrepareAsyncSearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::SearchAgentsResponse>>(PrepareAsyncSearchAgentsRaw(context, request, cq));
    }
    // Trains the specified agent.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status TrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncTrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncTrainAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncTrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncTrainAgentRaw(context, request, cq));
    }
    // Exports the specified agent to a ZIP file.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: [ExportAgentResponse][google.cloud.dialogflow.v2.ExportAgentResponse]
    virtual ::grpc::Status ExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncExportAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncExportAgentRaw(context, request, cq));
    }
    // Imports the specified agent from a ZIP file.
    //
    // Uploads new intents and entity types without deleting the existing ones.
    // Intents and entity types with the same name are replaced with the new
    // versions from [ImportAgentRequest][google.cloud.dialogflow.v2.ImportAgentRequest]. After the import, the imported draft
    // agent will be trained automatically (unless disabled in agent settings).
    // However, once the import is done, training may not be completed yet. Please
    // call [TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent] and wait for the operation it returns in order to train
    // explicitly.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    //
    // The operation only tracks when importing is complete, not when it is done
    // training.
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status ImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncImportAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncImportAgentRaw(context, request, cq));
    }
    // Restores the specified agent from a ZIP file.
    //
    // Replaces the current agent version with a new one. All the intents and
    // entity types in the older version are deleted. After the restore, the
    // restored draft agent will be trained automatically (unless disabled in
    // agent settings). However, once the restore is done, training may not be
    // completed yet. Please call [TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent] and wait for the operation it
    // returns in order to train explicitly.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    //
    // The operation only tracks when restoring is complete, not when it is done
    // training.
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status RestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncRestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncRestoreAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncRestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncRestoreAgentRaw(context, request, cq));
    }
    // Gets agent validation result. Agent validation is performed during
    // training time and is updated automatically when training is completed.
    virtual ::grpc::Status GetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::google::cloud::dialogflow::v2::ValidationResult* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ValidationResult>> AsyncGetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ValidationResult>>(AsyncGetValidationResultRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ValidationResult>> PrepareAsyncGetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ValidationResult>>(PrepareAsyncGetValidationResultRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Retrieves the specified agent.
      virtual void GetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates/updates the specified agent.
      //
      // Note: You should always train an agent prior to sending it queries. See the
      // [training
      // documentation](https://cloud.google.com/dialogflow/es/docs/training).
      virtual void SetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes the specified agent.
      virtual void DeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns the list of agents.
      //
      // Since there is at most one conversational agent per project, this method is
      // useful primarily for listing all agents across projects the caller has
      // access to. One can achieve that with a wildcard project collection id "-".
      // Refer to [List
      // Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
      virtual void SearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Trains the specified agent.
      //
      // This method is a [long-running
      // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
      // The returned `Operation` type has the following method-specific fields:
      //
      // - `metadata`: An empty [Struct
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
      // - `response`: An [Empty
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
      //
      // Note: You should always train an agent prior to sending it queries. See the
      // [training
      // documentation](https://cloud.google.com/dialogflow/es/docs/training).
      virtual void TrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void TrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Exports the specified agent to a ZIP file.
      //
      // This method is a [long-running
      // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
      // The returned `Operation` type has the following method-specific fields:
      //
      // - `metadata`: An empty [Struct
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
      // - `response`: [ExportAgentResponse][google.cloud.dialogflow.v2.ExportAgentResponse]
      virtual void ExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Imports the specified agent from a ZIP file.
      //
      // Uploads new intents and entity types without deleting the existing ones.
      // Intents and entity types with the same name are replaced with the new
      // versions from [ImportAgentRequest][google.cloud.dialogflow.v2.ImportAgentRequest]. After the import, the imported draft
      // agent will be trained automatically (unless disabled in agent settings).
      // However, once the import is done, training may not be completed yet. Please
      // call [TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent] and wait for the operation it returns in order to train
      // explicitly.
      //
      // This method is a [long-running
      // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
      // The returned `Operation` type has the following method-specific fields:
      //
      // - `metadata`: An empty [Struct
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
      // - `response`: An [Empty
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
      //
      // The operation only tracks when importing is complete, not when it is done
      // training.
      //
      // Note: You should always train an agent prior to sending it queries. See the
      // [training
      // documentation](https://cloud.google.com/dialogflow/es/docs/training).
      virtual void ImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Restores the specified agent from a ZIP file.
      //
      // Replaces the current agent version with a new one. All the intents and
      // entity types in the older version are deleted. After the restore, the
      // restored draft agent will be trained automatically (unless disabled in
      // agent settings). However, once the restore is done, training may not be
      // completed yet. Please call [TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent] and wait for the operation it
      // returns in order to train explicitly.
      //
      // This method is a [long-running
      // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
      // The returned `Operation` type has the following method-specific fields:
      //
      // - `metadata`: An empty [Struct
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
      // - `response`: An [Empty
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
      //
      // The operation only tracks when restoring is complete, not when it is done
      // training.
      //
      // Note: You should always train an agent prior to sending it queries. See the
      // [training
      // documentation](https://cloud.google.com/dialogflow/es/docs/training).
      virtual void RestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void RestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets agent validation result. Agent validation is performed during
      // training time and is updated automatically when training is completed.
      virtual void GetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* request, ::google::cloud::dialogflow::v2::ValidationResult* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* request, ::google::cloud::dialogflow::v2::ValidationResult* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>* AsyncGetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>* PrepareAsyncGetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>* AsyncSetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Agent>* PrepareAsyncSetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::SearchAgentsResponse>* AsyncSearchAgentsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::SearchAgentsResponse>* PrepareAsyncSearchAgentsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncTrainAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncTrainAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncExportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncExportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncImportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncImportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncRestoreAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncRestoreAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ValidationResult>* AsyncGetValidationResultRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ValidationResult>* PrepareAsyncGetValidationResultRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status GetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::google::cloud::dialogflow::v2::Agent* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>> AsyncGetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>>(AsyncGetAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>> PrepareAsyncGetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>>(PrepareAsyncGetAgentRaw(context, request, cq));
    }
    ::grpc::Status SetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::google::cloud::dialogflow::v2::Agent* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>> AsyncSetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>>(AsyncSetAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>> PrepareAsyncSetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>>(PrepareAsyncSetAgentRaw(context, request, cq));
    }
    ::grpc::Status DeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteAgentRaw(context, request, cq));
    }
    ::grpc::Status SearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::SearchAgentsResponse>> AsyncSearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::SearchAgentsResponse>>(AsyncSearchAgentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::SearchAgentsResponse>> PrepareAsyncSearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::SearchAgentsResponse>>(PrepareAsyncSearchAgentsRaw(context, request, cq));
    }
    ::grpc::Status TrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncTrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncTrainAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncTrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncTrainAgentRaw(context, request, cq));
    }
    ::grpc::Status ExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncExportAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncExportAgentRaw(context, request, cq));
    }
    ::grpc::Status ImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncImportAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncImportAgentRaw(context, request, cq));
    }
    ::grpc::Status RestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncRestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncRestoreAgentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncRestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncRestoreAgentRaw(context, request, cq));
    }
    ::grpc::Status GetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::google::cloud::dialogflow::v2::ValidationResult* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ValidationResult>> AsyncGetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ValidationResult>>(AsyncGetValidationResultRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ValidationResult>> PrepareAsyncGetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ValidationResult>>(PrepareAsyncGetValidationResultRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void GetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, std::function<void(::grpc::Status)>) override;
      void GetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, std::function<void(::grpc::Status)>) override;
      void SetAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response, std::function<void(::grpc::Status)>) override;
      void SearchAgents(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void TrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void TrainAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void ExportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void ImportAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void RestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void RestoreAgent(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* request, ::google::cloud::dialogflow::v2::ValidationResult* response, std::function<void(::grpc::Status)>) override;
      void GetValidationResult(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* request, ::google::cloud::dialogflow::v2::ValidationResult* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>* AsyncGetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>* PrepareAsyncGetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>* AsyncSetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Agent>* PrepareAsyncSetAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::SearchAgentsResponse>* AsyncSearchAgentsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::SearchAgentsResponse>* PrepareAsyncSearchAgentsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncTrainAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncTrainAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncExportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncExportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncImportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncImportAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncRestoreAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncRestoreAgentRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ValidationResult>* AsyncGetValidationResultRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ValidationResult>* PrepareAsyncGetValidationResultRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_GetAgent_;
    const ::grpc::internal::RpcMethod rpcmethod_SetAgent_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteAgent_;
    const ::grpc::internal::RpcMethod rpcmethod_SearchAgents_;
    const ::grpc::internal::RpcMethod rpcmethod_TrainAgent_;
    const ::grpc::internal::RpcMethod rpcmethod_ExportAgent_;
    const ::grpc::internal::RpcMethod rpcmethod_ImportAgent_;
    const ::grpc::internal::RpcMethod rpcmethod_RestoreAgent_;
    const ::grpc::internal::RpcMethod rpcmethod_GetValidationResult_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Retrieves the specified agent.
    virtual ::grpc::Status GetAgent(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response);
    // Creates/updates the specified agent.
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status SetAgent(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response);
    // Deletes the specified agent.
    virtual ::grpc::Status DeleteAgent(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* request, ::google::protobuf::Empty* response);
    // Returns the list of agents.
    //
    // Since there is at most one conversational agent per project, this method is
    // useful primarily for listing all agents across projects the caller has
    // access to. One can achieve that with a wildcard project collection id "-".
    // Refer to [List
    // Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
    virtual ::grpc::Status SearchAgents(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response);
    // Trains the specified agent.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status TrainAgent(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest* request, ::google::longrunning::Operation* response);
    // Exports the specified agent to a ZIP file.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: [ExportAgentResponse][google.cloud.dialogflow.v2.ExportAgentResponse]
    virtual ::grpc::Status ExportAgent(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest* request, ::google::longrunning::Operation* response);
    // Imports the specified agent from a ZIP file.
    //
    // Uploads new intents and entity types without deleting the existing ones.
    // Intents and entity types with the same name are replaced with the new
    // versions from [ImportAgentRequest][google.cloud.dialogflow.v2.ImportAgentRequest]. After the import, the imported draft
    // agent will be trained automatically (unless disabled in agent settings).
    // However, once the import is done, training may not be completed yet. Please
    // call [TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent] and wait for the operation it returns in order to train
    // explicitly.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    //
    // The operation only tracks when importing is complete, not when it is done
    // training.
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status ImportAgent(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest* request, ::google::longrunning::Operation* response);
    // Restores the specified agent from a ZIP file.
    //
    // Replaces the current agent version with a new one. All the intents and
    // entity types in the older version are deleted. After the restore, the
    // restored draft agent will be trained automatically (unless disabled in
    // agent settings). However, once the restore is done, training may not be
    // completed yet. Please call [TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent] and wait for the operation it
    // returns in order to train explicitly.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: An empty [Struct
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    //
    // The operation only tracks when restoring is complete, not when it is done
    // training.
    //
    // Note: You should always train an agent prior to sending it queries. See the
    // [training
    // documentation](https://cloud.google.com/dialogflow/es/docs/training).
    virtual ::grpc::Status RestoreAgent(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* request, ::google::longrunning::Operation* response);
    // Gets agent validation result. Agent validation is performed during
    // training time and is updated automatically when training is completed.
    virtual ::grpc::Status GetValidationResult(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* request, ::google::cloud::dialogflow::v2::ValidationResult* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_GetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetAgent() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_GetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetAgent(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::GetAgentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::Agent>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SetAgent() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_SetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetAgent(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::SetAgentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::Agent>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteAgent() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_DeleteAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteAgent(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::DeleteAgentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SearchAgents : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SearchAgents() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_SearchAgents() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAgents(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* /*request*/, ::google::cloud::dialogflow::v2::SearchAgentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSearchAgents(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::SearchAgentsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::SearchAgentsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_TrainAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_TrainAgent() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_TrainAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TrainAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::TrainAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTrainAgent(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::TrainAgentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ExportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ExportAgent() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_ExportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ExportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExportAgent(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::ExportAgentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ImportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ImportAgent() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_ImportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestImportAgent(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::ImportAgentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_RestoreAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_RestoreAgent() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_RestoreAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRestoreAgent(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::RestoreAgentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetValidationResult : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetValidationResult() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_GetValidationResult() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetValidationResult(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* /*request*/, ::google::cloud::dialogflow::v2::ValidationResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetValidationResult(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::GetValidationResultRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::ValidationResult>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_GetAgent<WithAsyncMethod_SetAgent<WithAsyncMethod_DeleteAgent<WithAsyncMethod_SearchAgents<WithAsyncMethod_TrainAgent<WithAsyncMethod_ExportAgent<WithAsyncMethod_ImportAgent<WithAsyncMethod_RestoreAgent<WithAsyncMethod_GetValidationResult<Service > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_GetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetAgent() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetAgentRequest, ::google::cloud::dialogflow::v2::Agent>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::GetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response) { return this->GetAgent(context, request, response); }));}
    void SetMessageAllocatorFor_GetAgent(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::GetAgentRequest, ::google::cloud::dialogflow::v2::Agent>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetAgentRequest, ::google::cloud::dialogflow::v2::Agent>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SetAgent() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::SetAgentRequest, ::google::cloud::dialogflow::v2::Agent>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::SetAgentRequest* request, ::google::cloud::dialogflow::v2::Agent* response) { return this->SetAgent(context, request, response); }));}
    void SetMessageAllocatorFor_SetAgent(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::SetAgentRequest, ::google::cloud::dialogflow::v2::Agent>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::SetAgentRequest, ::google::cloud::dialogflow::v2::Agent>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteAgent() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::DeleteAgentRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* request, ::google::protobuf::Empty* response) { return this->DeleteAgent(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteAgent(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::DeleteAgentRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::DeleteAgentRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SearchAgents : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SearchAgents() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::SearchAgentsRequest, ::google::cloud::dialogflow::v2::SearchAgentsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* request, ::google::cloud::dialogflow::v2::SearchAgentsResponse* response) { return this->SearchAgents(context, request, response); }));}
    void SetMessageAllocatorFor_SearchAgents(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::SearchAgentsRequest, ::google::cloud::dialogflow::v2::SearchAgentsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::SearchAgentsRequest, ::google::cloud::dialogflow::v2::SearchAgentsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SearchAgents() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAgents(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* /*request*/, ::google::cloud::dialogflow::v2::SearchAgentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SearchAgents(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* /*request*/, ::google::cloud::dialogflow::v2::SearchAgentsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_TrainAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_TrainAgent() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::TrainAgentRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::TrainAgentRequest* request, ::google::longrunning::Operation* response) { return this->TrainAgent(context, request, response); }));}
    void SetMessageAllocatorFor_TrainAgent(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::TrainAgentRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::TrainAgentRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_TrainAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TrainAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::TrainAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TrainAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::TrainAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ExportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ExportAgent() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ExportAgentRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::ExportAgentRequest* request, ::google::longrunning::Operation* response) { return this->ExportAgent(context, request, response); }));}
    void SetMessageAllocatorFor_ExportAgent(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::ExportAgentRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ExportAgentRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ExportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ExportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExportAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ExportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ImportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ImportAgent() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ImportAgentRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::ImportAgentRequest* request, ::google::longrunning::Operation* response) { return this->ImportAgent(context, request, response); }));}
    void SetMessageAllocatorFor_ImportAgent(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::ImportAgentRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ImportAgentRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ImportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ImportAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_RestoreAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_RestoreAgent() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::RestoreAgentRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* request, ::google::longrunning::Operation* response) { return this->RestoreAgent(context, request, response); }));}
    void SetMessageAllocatorFor_RestoreAgent(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::RestoreAgentRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::RestoreAgentRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_RestoreAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RestoreAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetValidationResult : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetValidationResult() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetValidationResultRequest, ::google::cloud::dialogflow::v2::ValidationResult>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* request, ::google::cloud::dialogflow::v2::ValidationResult* response) { return this->GetValidationResult(context, request, response); }));}
    void SetMessageAllocatorFor_GetValidationResult(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::GetValidationResultRequest, ::google::cloud::dialogflow::v2::ValidationResult>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetValidationResultRequest, ::google::cloud::dialogflow::v2::ValidationResult>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetValidationResult() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetValidationResult(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* /*request*/, ::google::cloud::dialogflow::v2::ValidationResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetValidationResult(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* /*request*/, ::google::cloud::dialogflow::v2::ValidationResult* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_GetAgent<WithCallbackMethod_SetAgent<WithCallbackMethod_DeleteAgent<WithCallbackMethod_SearchAgents<WithCallbackMethod_TrainAgent<WithCallbackMethod_ExportAgent<WithCallbackMethod_ImportAgent<WithCallbackMethod_RestoreAgent<WithCallbackMethod_GetValidationResult<Service > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_GetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetAgent() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_GetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SetAgent() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_SetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteAgent() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_DeleteAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SearchAgents : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SearchAgents() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_SearchAgents() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAgents(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* /*request*/, ::google::cloud::dialogflow::v2::SearchAgentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_TrainAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_TrainAgent() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_TrainAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TrainAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::TrainAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ExportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ExportAgent() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_ExportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ExportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ImportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ImportAgent() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_ImportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_RestoreAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_RestoreAgent() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_RestoreAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetValidationResult : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetValidationResult() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_GetValidationResult() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetValidationResult(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* /*request*/, ::google::cloud::dialogflow::v2::ValidationResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetAgent() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_GetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetAgent(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SetAgent() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_SetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetAgent(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteAgent() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_DeleteAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteAgent(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SearchAgents : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SearchAgents() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_SearchAgents() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAgents(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* /*request*/, ::google::cloud::dialogflow::v2::SearchAgentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSearchAgents(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_TrainAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_TrainAgent() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_TrainAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TrainAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::TrainAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTrainAgent(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ExportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ExportAgent() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_ExportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ExportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExportAgent(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ImportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ImportAgent() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_ImportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestImportAgent(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_RestoreAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_RestoreAgent() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_RestoreAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRestoreAgent(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetValidationResult : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetValidationResult() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_GetValidationResult() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetValidationResult(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* /*request*/, ::google::cloud::dialogflow::v2::ValidationResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetValidationResult(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetAgent() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetAgent(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SetAgent() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SetAgent(context, request, response); }));
    }
    ~WithRawCallbackMethod_SetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteAgent() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteAgent(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SearchAgents : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SearchAgents() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SearchAgents(context, request, response); }));
    }
    ~WithRawCallbackMethod_SearchAgents() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAgents(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* /*request*/, ::google::cloud::dialogflow::v2::SearchAgentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SearchAgents(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_TrainAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_TrainAgent() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->TrainAgent(context, request, response); }));
    }
    ~WithRawCallbackMethod_TrainAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TrainAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::TrainAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TrainAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ExportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ExportAgent() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ExportAgent(context, request, response); }));
    }
    ~WithRawCallbackMethod_ExportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ExportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExportAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ImportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ImportAgent() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ImportAgent(context, request, response); }));
    }
    ~WithRawCallbackMethod_ImportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ImportAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_RestoreAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_RestoreAgent() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->RestoreAgent(context, request, response); }));
    }
    ~WithRawCallbackMethod_RestoreAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RestoreAgent(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetValidationResult : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetValidationResult() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetValidationResult(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetValidationResult() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetValidationResult(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* /*request*/, ::google::cloud::dialogflow::v2::ValidationResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetValidationResult(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetAgent() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::GetAgentRequest, ::google::cloud::dialogflow::v2::Agent>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::GetAgentRequest, ::google::cloud::dialogflow::v2::Agent>* streamer) {
                       return this->StreamedGetAgent(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetAgent(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::GetAgentRequest,::google::cloud::dialogflow::v2::Agent>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SetAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SetAgent() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::SetAgentRequest, ::google::cloud::dialogflow::v2::Agent>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::SetAgentRequest, ::google::cloud::dialogflow::v2::Agent>* streamer) {
                       return this->StreamedSetAgent(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SetAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SetAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SetAgentRequest* /*request*/, ::google::cloud::dialogflow::v2::Agent* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSetAgent(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::SetAgentRequest,::google::cloud::dialogflow::v2::Agent>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteAgent() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::DeleteAgentRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::DeleteAgentRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteAgent(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteAgentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteAgent(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::DeleteAgentRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SearchAgents : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SearchAgents() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::SearchAgentsRequest, ::google::cloud::dialogflow::v2::SearchAgentsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::SearchAgentsRequest, ::google::cloud::dialogflow::v2::SearchAgentsResponse>* streamer) {
                       return this->StreamedSearchAgents(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SearchAgents() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SearchAgents(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::SearchAgentsRequest* /*request*/, ::google::cloud::dialogflow::v2::SearchAgentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSearchAgents(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::SearchAgentsRequest,::google::cloud::dialogflow::v2::SearchAgentsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_TrainAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_TrainAgent() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::TrainAgentRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::TrainAgentRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedTrainAgent(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_TrainAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status TrainAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::TrainAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedTrainAgent(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::TrainAgentRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ExportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ExportAgent() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::ExportAgentRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::ExportAgentRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedExportAgent(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ExportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ExportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ExportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedExportAgent(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::ExportAgentRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ImportAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ImportAgent() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::ImportAgentRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::ImportAgentRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedImportAgent(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ImportAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ImportAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedImportAgent(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::ImportAgentRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_RestoreAgent : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_RestoreAgent() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::RestoreAgentRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::RestoreAgentRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedRestoreAgent(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_RestoreAgent() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status RestoreAgent(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::RestoreAgentRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedRestoreAgent(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::RestoreAgentRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetValidationResult : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetValidationResult() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::GetValidationResultRequest, ::google::cloud::dialogflow::v2::ValidationResult>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::GetValidationResultRequest, ::google::cloud::dialogflow::v2::ValidationResult>* streamer) {
                       return this->StreamedGetValidationResult(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetValidationResult() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetValidationResult(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetValidationResultRequest* /*request*/, ::google::cloud::dialogflow::v2::ValidationResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetValidationResult(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::GetValidationResultRequest,::google::cloud::dialogflow::v2::ValidationResult>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_GetAgent<WithStreamedUnaryMethod_SetAgent<WithStreamedUnaryMethod_DeleteAgent<WithStreamedUnaryMethod_SearchAgents<WithStreamedUnaryMethod_TrainAgent<WithStreamedUnaryMethod_ExportAgent<WithStreamedUnaryMethod_ImportAgent<WithStreamedUnaryMethod_RestoreAgent<WithStreamedUnaryMethod_GetValidationResult<Service > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_GetAgent<WithStreamedUnaryMethod_SetAgent<WithStreamedUnaryMethod_DeleteAgent<WithStreamedUnaryMethod_SearchAgents<WithStreamedUnaryMethod_TrainAgent<WithStreamedUnaryMethod_ExportAgent<WithStreamedUnaryMethod_ImportAgent<WithStreamedUnaryMethod_RestoreAgent<WithStreamedUnaryMethod_GetValidationResult<Service > > > > > > > > > StreamedService;
};

}  // namespace v2
}  // namespace dialogflow
}  // namespace cloud
}  // namespace google


#endif  // GRPC_google_2fcloud_2fdialogflow_2fv2_2fagent_2eproto__INCLUDED
