// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/logging/v2/logging.proto
// Original file comments:
// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2flogging_2fv2_2flogging_2eproto__INCLUDED
#define GRPC_google_2flogging_2fv2_2flogging_2eproto__INCLUDED

#include "google/logging/v2/logging.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace logging {
namespace v2 {

// Service for ingesting and querying logs.
class LoggingServiceV2 final {
 public:
  static constexpr char const* service_full_name() {
    return "google.logging.v2.LoggingServiceV2";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Deletes all the log entries in a log. The log reappears if it receives new
    // entries. Log entries written shortly before the delete operation might not
    // be deleted. Entries received after the delete operation with a timestamp
    // before the operation will be deleted.
    virtual ::grpc::Status DeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteLogRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteLogRaw(context, request, cq));
    }
    // Writes log entries to Logging. This API method is the
    // only way to send log entries to Logging. This method
    // is used, directly or indirectly, by the Logging agent
    // (fluentd) and all logging libraries configured to use Logging.
    // A single request may contain log entries for a maximum of 1000
    // different resources (projects, organizations, billing accounts or
    // folders)
    virtual ::grpc::Status WriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::google::logging::v2::WriteLogEntriesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::WriteLogEntriesResponse>> AsyncWriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::WriteLogEntriesResponse>>(AsyncWriteLogEntriesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::WriteLogEntriesResponse>> PrepareAsyncWriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::WriteLogEntriesResponse>>(PrepareAsyncWriteLogEntriesRaw(context, request, cq));
    }
    // Lists log entries.  Use this method to retrieve log entries that originated
    // from a project/folder/organization/billing account.  For ways to export log
    // entries, see [Exporting
    // Logs](https://cloud.google.com/logging/docs/export).
    virtual ::grpc::Status ListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::google::logging::v2::ListLogEntriesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogEntriesResponse>> AsyncListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogEntriesResponse>>(AsyncListLogEntriesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogEntriesResponse>> PrepareAsyncListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogEntriesResponse>>(PrepareAsyncListLogEntriesRaw(context, request, cq));
    }
    // Lists the descriptors for monitored resource types used by Logging.
    virtual ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>> AsyncListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>>(AsyncListMonitoredResourceDescriptorsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>> PrepareAsyncListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>>(PrepareAsyncListMonitoredResourceDescriptorsRaw(context, request, cq));
    }
    // Lists the logs in projects, organizations, folders, or billing accounts.
    // Only logs that have entries are listed.
    virtual ::grpc::Status ListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::google::logging::v2::ListLogsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogsResponse>> AsyncListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogsResponse>>(AsyncListLogsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogsResponse>> PrepareAsyncListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogsResponse>>(PrepareAsyncListLogsRaw(context, request, cq));
    }
    // Streaming read of log entries as they are ingested. Until the stream is
    // terminated, it will continue reading logs.
    std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>> TailLogEntries(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>>(TailLogEntriesRaw(context));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>> AsyncTailLogEntries(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>>(AsyncTailLogEntriesRaw(context, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>> PrepareAsyncTailLogEntries(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>>(PrepareAsyncTailLogEntriesRaw(context, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Deletes all the log entries in a log. The log reappears if it receives new
      // entries. Log entries written shortly before the delete operation might not
      // be deleted. Entries received after the delete operation with a timestamp
      // before the operation will be deleted.
      virtual void DeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Writes log entries to Logging. This API method is the
      // only way to send log entries to Logging. This method
      // is used, directly or indirectly, by the Logging agent
      // (fluentd) and all logging libraries configured to use Logging.
      // A single request may contain log entries for a maximum of 1000
      // different resources (projects, organizations, billing accounts or
      // folders)
      virtual void WriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest* request, ::google::logging::v2::WriteLogEntriesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void WriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest* request, ::google::logging::v2::WriteLogEntriesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists log entries.  Use this method to retrieve log entries that originated
      // from a project/folder/organization/billing account.  For ways to export log
      // entries, see [Exporting
      // Logs](https://cloud.google.com/logging/docs/export).
      virtual void ListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest* request, ::google::logging::v2::ListLogEntriesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest* request, ::google::logging::v2::ListLogEntriesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists the descriptors for monitored resource types used by Logging.
      virtual void ListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists the logs in projects, organizations, folders, or billing accounts.
      // Only logs that have entries are listed.
      virtual void ListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest* request, ::google::logging::v2::ListLogsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest* request, ::google::logging::v2::ListLogsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Streaming read of log entries as they are ingested. Until the stream is
      // terminated, it will continue reading logs.
      virtual void TailLogEntries(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::google::logging::v2::TailLogEntriesRequest,::google::logging::v2::TailLogEntriesResponse>* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteLogRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteLogRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::WriteLogEntriesResponse>* AsyncWriteLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::WriteLogEntriesResponse>* PrepareAsyncWriteLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogEntriesResponse>* AsyncListLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogEntriesResponse>* PrepareAsyncListLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* AsyncListMonitoredResourceDescriptorsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* PrepareAsyncListMonitoredResourceDescriptorsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogsResponse>* AsyncListLogsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListLogsResponse>* PrepareAsyncListLogsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>* TailLogEntriesRaw(::grpc::ClientContext* context) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>* AsyncTailLogEntriesRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>* PrepareAsyncTailLogEntriesRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status DeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteLogRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteLogRaw(context, request, cq));
    }
    ::grpc::Status WriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::google::logging::v2::WriteLogEntriesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::WriteLogEntriesResponse>> AsyncWriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::WriteLogEntriesResponse>>(AsyncWriteLogEntriesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::WriteLogEntriesResponse>> PrepareAsyncWriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::WriteLogEntriesResponse>>(PrepareAsyncWriteLogEntriesRaw(context, request, cq));
    }
    ::grpc::Status ListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::google::logging::v2::ListLogEntriesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogEntriesResponse>> AsyncListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogEntriesResponse>>(AsyncListLogEntriesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogEntriesResponse>> PrepareAsyncListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogEntriesResponse>>(PrepareAsyncListLogEntriesRaw(context, request, cq));
    }
    ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>> AsyncListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>>(AsyncListMonitoredResourceDescriptorsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>> PrepareAsyncListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>>(PrepareAsyncListMonitoredResourceDescriptorsRaw(context, request, cq));
    }
    ::grpc::Status ListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::google::logging::v2::ListLogsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogsResponse>> AsyncListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogsResponse>>(AsyncListLogsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogsResponse>> PrepareAsyncListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogsResponse>>(PrepareAsyncListLogsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>> TailLogEntries(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>>(TailLogEntriesRaw(context));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>> AsyncTailLogEntries(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>>(AsyncTailLogEntriesRaw(context, cq, tag));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>> PrepareAsyncTailLogEntries(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>>(PrepareAsyncTailLogEntriesRaw(context, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void DeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteLog(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void WriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest* request, ::google::logging::v2::WriteLogEntriesResponse* response, std::function<void(::grpc::Status)>) override;
      void WriteLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest* request, ::google::logging::v2::WriteLogEntriesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest* request, ::google::logging::v2::ListLogEntriesResponse* response, std::function<void(::grpc::Status)>) override;
      void ListLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest* request, ::google::logging::v2::ListLogEntriesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListMonitoredResourceDescriptors(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest* request, ::google::logging::v2::ListLogsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListLogs(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest* request, ::google::logging::v2::ListLogsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void TailLogEntries(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::google::logging::v2::TailLogEntriesRequest,::google::logging::v2::TailLogEntriesResponse>* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteLogRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteLogRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteLogRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::WriteLogEntriesResponse>* AsyncWriteLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::WriteLogEntriesResponse>* PrepareAsyncWriteLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::WriteLogEntriesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogEntriesResponse>* AsyncListLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogEntriesResponse>* PrepareAsyncListLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogEntriesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* AsyncListMonitoredResourceDescriptorsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* PrepareAsyncListMonitoredResourceDescriptorsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogsResponse>* AsyncListLogsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListLogsResponse>* PrepareAsyncListLogsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListLogsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>* TailLogEntriesRaw(::grpc::ClientContext* context) override;
    ::grpc::ClientAsyncReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>* AsyncTailLogEntriesRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReaderWriter< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>* PrepareAsyncTailLogEntriesRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteLog_;
    const ::grpc::internal::RpcMethod rpcmethod_WriteLogEntries_;
    const ::grpc::internal::RpcMethod rpcmethod_ListLogEntries_;
    const ::grpc::internal::RpcMethod rpcmethod_ListMonitoredResourceDescriptors_;
    const ::grpc::internal::RpcMethod rpcmethod_ListLogs_;
    const ::grpc::internal::RpcMethod rpcmethod_TailLogEntries_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Deletes all the log entries in a log. The log reappears if it receives new
    // entries. Log entries written shortly before the delete operation might not
    // be deleted. Entries received after the delete operation with a timestamp
    // before the operation will be deleted.
    virtual ::grpc::Status DeleteLog(::grpc::ServerContext* context, const ::google::logging::v2::DeleteLogRequest* request, ::google::protobuf::Empty* response);
    // Writes log entries to Logging. This API method is the
    // only way to send log entries to Logging. This method
    // is used, directly or indirectly, by the Logging agent
    // (fluentd) and all logging libraries configured to use Logging.
    // A single request may contain log entries for a maximum of 1000
    // different resources (projects, organizations, billing accounts or
    // folders)
    virtual ::grpc::Status WriteLogEntries(::grpc::ServerContext* context, const ::google::logging::v2::WriteLogEntriesRequest* request, ::google::logging::v2::WriteLogEntriesResponse* response);
    // Lists log entries.  Use this method to retrieve log entries that originated
    // from a project/folder/organization/billing account.  For ways to export log
    // entries, see [Exporting
    // Logs](https://cloud.google.com/logging/docs/export).
    virtual ::grpc::Status ListLogEntries(::grpc::ServerContext* context, const ::google::logging::v2::ListLogEntriesRequest* request, ::google::logging::v2::ListLogEntriesResponse* response);
    // Lists the descriptors for monitored resource types used by Logging.
    virtual ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ServerContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response);
    // Lists the logs in projects, organizations, folders, or billing accounts.
    // Only logs that have entries are listed.
    virtual ::grpc::Status ListLogs(::grpc::ServerContext* context, const ::google::logging::v2::ListLogsRequest* request, ::google::logging::v2::ListLogsResponse* response);
    // Streaming read of log entries as they are ingested. Until the stream is
    // terminated, it will continue reading logs.
    virtual ::grpc::Status TailLogEntries(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::google::logging::v2::TailLogEntriesResponse, ::google::logging::v2::TailLogEntriesRequest>* stream);
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteLog : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteLog() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_DeleteLog() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteLog(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteLogRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteLog(::grpc::ServerContext* context, ::google::logging::v2::DeleteLogRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_WriteLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_WriteLogEntries() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_WriteLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::WriteLogEntriesRequest* /*request*/, ::google::logging::v2::WriteLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWriteLogEntries(::grpc::ServerContext* context, ::google::logging::v2::WriteLogEntriesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::WriteLogEntriesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListLogEntries() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_ListLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogEntriesRequest* /*request*/, ::google::logging::v2::ListLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListLogEntries(::grpc::ServerContext* context, ::google::logging::v2::ListLogEntriesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::ListLogEntriesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListMonitoredResourceDescriptors : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListMonitoredResourceDescriptors() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_ListMonitoredResourceDescriptors() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* /*request*/, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListMonitoredResourceDescriptors(::grpc::ServerContext* context, ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListLogs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListLogs() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_ListLogs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogs(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogsRequest* /*request*/, ::google::logging::v2::ListLogsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListLogs(::grpc::ServerContext* context, ::google::logging::v2::ListLogsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::ListLogsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_TailLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_TailLogEntries() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_TailLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TailLogEntries(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::logging::v2::TailLogEntriesResponse, ::google::logging::v2::TailLogEntriesRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTailLogEntries(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::google::logging::v2::TailLogEntriesResponse, ::google::logging::v2::TailLogEntriesRequest>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(5, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_DeleteLog<WithAsyncMethod_WriteLogEntries<WithAsyncMethod_ListLogEntries<WithAsyncMethod_ListMonitoredResourceDescriptors<WithAsyncMethod_ListLogs<WithAsyncMethod_TailLogEntries<Service > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_DeleteLog : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteLog() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteLogRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::DeleteLogRequest* request, ::google::protobuf::Empty* response) { return this->DeleteLog(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteLog(
        ::grpc::MessageAllocator< ::google::logging::v2::DeleteLogRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteLogRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteLog() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteLog(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteLogRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteLog(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::DeleteLogRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_WriteLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_WriteLogEntries() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::WriteLogEntriesRequest, ::google::logging::v2::WriteLogEntriesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::WriteLogEntriesRequest* request, ::google::logging::v2::WriteLogEntriesResponse* response) { return this->WriteLogEntries(context, request, response); }));}
    void SetMessageAllocatorFor_WriteLogEntries(
        ::grpc::MessageAllocator< ::google::logging::v2::WriteLogEntriesRequest, ::google::logging::v2::WriteLogEntriesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::WriteLogEntriesRequest, ::google::logging::v2::WriteLogEntriesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_WriteLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::WriteLogEntriesRequest* /*request*/, ::google::logging::v2::WriteLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* WriteLogEntries(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::WriteLogEntriesRequest* /*request*/, ::google::logging::v2::WriteLogEntriesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListLogEntries() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListLogEntriesRequest, ::google::logging::v2::ListLogEntriesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::ListLogEntriesRequest* request, ::google::logging::v2::ListLogEntriesResponse* response) { return this->ListLogEntries(context, request, response); }));}
    void SetMessageAllocatorFor_ListLogEntries(
        ::grpc::MessageAllocator< ::google::logging::v2::ListLogEntriesRequest, ::google::logging::v2::ListLogEntriesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListLogEntriesRequest, ::google::logging::v2::ListLogEntriesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogEntriesRequest* /*request*/, ::google::logging::v2::ListLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListLogEntries(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::ListLogEntriesRequest* /*request*/, ::google::logging::v2::ListLogEntriesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListMonitoredResourceDescriptors : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListMonitoredResourceDescriptors() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListMonitoredResourceDescriptorsRequest, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* request, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* response) { return this->ListMonitoredResourceDescriptors(context, request, response); }));}
    void SetMessageAllocatorFor_ListMonitoredResourceDescriptors(
        ::grpc::MessageAllocator< ::google::logging::v2::ListMonitoredResourceDescriptorsRequest, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListMonitoredResourceDescriptorsRequest, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListMonitoredResourceDescriptors() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* /*request*/, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListMonitoredResourceDescriptors(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* /*request*/, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListLogs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListLogs() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListLogsRequest, ::google::logging::v2::ListLogsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::ListLogsRequest* request, ::google::logging::v2::ListLogsResponse* response) { return this->ListLogs(context, request, response); }));}
    void SetMessageAllocatorFor_ListLogs(
        ::grpc::MessageAllocator< ::google::logging::v2::ListLogsRequest, ::google::logging::v2::ListLogsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListLogsRequest, ::google::logging::v2::ListLogsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListLogs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogs(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogsRequest* /*request*/, ::google::logging::v2::ListLogsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListLogs(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::ListLogsRequest* /*request*/, ::google::logging::v2::ListLogsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_TailLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_TailLogEntries() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackBidiHandler< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->TailLogEntries(context); }));
    }
    ~WithCallbackMethod_TailLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TailLogEntries(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::logging::v2::TailLogEntriesResponse, ::google::logging::v2::TailLogEntriesRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::google::logging::v2::TailLogEntriesRequest, ::google::logging::v2::TailLogEntriesResponse>* TailLogEntries(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  typedef WithCallbackMethod_DeleteLog<WithCallbackMethod_WriteLogEntries<WithCallbackMethod_ListLogEntries<WithCallbackMethod_ListMonitoredResourceDescriptors<WithCallbackMethod_ListLogs<WithCallbackMethod_TailLogEntries<Service > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_DeleteLog : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteLog() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_DeleteLog() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteLog(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteLogRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_WriteLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_WriteLogEntries() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_WriteLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::WriteLogEntriesRequest* /*request*/, ::google::logging::v2::WriteLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListLogEntries() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_ListLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogEntriesRequest* /*request*/, ::google::logging::v2::ListLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListMonitoredResourceDescriptors : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListMonitoredResourceDescriptors() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_ListMonitoredResourceDescriptors() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* /*request*/, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListLogs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListLogs() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_ListLogs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogs(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogsRequest* /*request*/, ::google::logging::v2::ListLogsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_TailLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_TailLogEntries() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_TailLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TailLogEntries(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::logging::v2::TailLogEntriesResponse, ::google::logging::v2::TailLogEntriesRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteLog : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteLog() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_DeleteLog() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteLog(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteLogRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteLog(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_WriteLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_WriteLogEntries() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_WriteLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::WriteLogEntriesRequest* /*request*/, ::google::logging::v2::WriteLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWriteLogEntries(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListLogEntries() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_ListLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogEntriesRequest* /*request*/, ::google::logging::v2::ListLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListLogEntries(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListMonitoredResourceDescriptors : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListMonitoredResourceDescriptors() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_ListMonitoredResourceDescriptors() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* /*request*/, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListMonitoredResourceDescriptors(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListLogs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListLogs() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_ListLogs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogs(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogsRequest* /*request*/, ::google::logging::v2::ListLogsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListLogs(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_TailLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_TailLogEntries() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_TailLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TailLogEntries(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::logging::v2::TailLogEntriesResponse, ::google::logging::v2::TailLogEntriesRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTailLogEntries(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(5, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteLog : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteLog() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteLog(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteLog() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteLog(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteLogRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteLog(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_WriteLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_WriteLogEntries() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->WriteLogEntries(context, request, response); }));
    }
    ~WithRawCallbackMethod_WriteLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::WriteLogEntriesRequest* /*request*/, ::google::logging::v2::WriteLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* WriteLogEntries(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListLogEntries() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListLogEntries(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogEntriesRequest* /*request*/, ::google::logging::v2::ListLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListLogEntries(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListMonitoredResourceDescriptors : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListMonitoredResourceDescriptors() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListMonitoredResourceDescriptors(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListMonitoredResourceDescriptors() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* /*request*/, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListMonitoredResourceDescriptors(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListLogs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListLogs() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListLogs(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListLogs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListLogs(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogsRequest* /*request*/, ::google::logging::v2::ListLogsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListLogs(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_TailLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_TailLogEntries() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackBidiHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->TailLogEntries(context); }));
    }
    ~WithRawCallbackMethod_TailLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TailLogEntries(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::logging::v2::TailLogEntriesResponse, ::google::logging::v2::TailLogEntriesRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* TailLogEntries(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteLog : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteLog() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::DeleteLogRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::DeleteLogRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteLog(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteLog() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteLog(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteLogRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteLog(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::DeleteLogRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_WriteLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_WriteLogEntries() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::WriteLogEntriesRequest, ::google::logging::v2::WriteLogEntriesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::WriteLogEntriesRequest, ::google::logging::v2::WriteLogEntriesResponse>* streamer) {
                       return this->StreamedWriteLogEntries(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_WriteLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status WriteLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::WriteLogEntriesRequest* /*request*/, ::google::logging::v2::WriteLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedWriteLogEntries(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::WriteLogEntriesRequest,::google::logging::v2::WriteLogEntriesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListLogEntries() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::ListLogEntriesRequest, ::google::logging::v2::ListLogEntriesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::ListLogEntriesRequest, ::google::logging::v2::ListLogEntriesResponse>* streamer) {
                       return this->StreamedListLogEntries(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogEntriesRequest* /*request*/, ::google::logging::v2::ListLogEntriesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListLogEntries(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::ListLogEntriesRequest,::google::logging::v2::ListLogEntriesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListMonitoredResourceDescriptors : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListMonitoredResourceDescriptors() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::ListMonitoredResourceDescriptorsRequest, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::ListMonitoredResourceDescriptorsRequest, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* streamer) {
                       return this->StreamedListMonitoredResourceDescriptors(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListMonitoredResourceDescriptors() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListMonitoredResourceDescriptors(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListMonitoredResourceDescriptorsRequest* /*request*/, ::google::logging::v2::ListMonitoredResourceDescriptorsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListMonitoredResourceDescriptors(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::ListMonitoredResourceDescriptorsRequest,::google::logging::v2::ListMonitoredResourceDescriptorsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListLogs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListLogs() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::ListLogsRequest, ::google::logging::v2::ListLogsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::ListLogsRequest, ::google::logging::v2::ListLogsResponse>* streamer) {
                       return this->StreamedListLogs(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListLogs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListLogs(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListLogsRequest* /*request*/, ::google::logging::v2::ListLogsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListLogs(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::ListLogsRequest,::google::logging::v2::ListLogsResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_DeleteLog<WithStreamedUnaryMethod_WriteLogEntries<WithStreamedUnaryMethod_ListLogEntries<WithStreamedUnaryMethod_ListMonitoredResourceDescriptors<WithStreamedUnaryMethod_ListLogs<Service > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_DeleteLog<WithStreamedUnaryMethod_WriteLogEntries<WithStreamedUnaryMethod_ListLogEntries<WithStreamedUnaryMethod_ListMonitoredResourceDescriptors<WithStreamedUnaryMethod_ListLogs<Service > > > > > StreamedService;
};

}  // namespace v2
}  // namespace logging
}  // namespace google


#endif  // GRPC_google_2flogging_2fv2_2flogging_2eproto__INCLUDED
