// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/cloud/dialogflow/v2/conversation.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fcloud_2fdialogflow_2fv2_2fconversation_2eproto__INCLUDED
#define GRPC_google_2fcloud_2fdialogflow_2fv2_2fconversation_2eproto__INCLUDED

#include "google/cloud/dialogflow/v2/conversation.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace cloud {
namespace dialogflow {
namespace v2 {

// Service for managing [Conversations][google.cloud.dialogflow.v2.Conversation].
class Conversations final {
 public:
  static constexpr char const* service_full_name() {
    return "google.cloud.dialogflow.v2.Conversations";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a new conversation. Conversations are auto-completed after 24
    // hours.
    //
    // Conversation Lifecycle:
    // There are two stages during a conversation: Automated Agent Stage and
    // Assist Stage.
    //
    // For Automated Agent Stage, there will be a dialogflow agent responding to
    // user queries.
    //
    // For Assist Stage, there's no dialogflow agent responding to user queries.
    // But we will provide suggestions which are generated from conversation.
    //
    // If [Conversation.conversation_profile][google.cloud.dialogflow.v2.Conversation.conversation_profile] is configured for a dialogflow
    // agent, conversation will start from `Automated Agent Stage`, otherwise, it
    // will start from `Assist Stage`. And during `Automated Agent Stage`, once an
    // [Intent][google.cloud.dialogflow.v2.Intent] with [Intent.live_agent_handoff][google.cloud.dialogflow.v2.Intent.live_agent_handoff] is triggered, conversation
    // will transfer to Assist Stage.
    virtual ::grpc::Status CreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::google::cloud::dialogflow::v2::Conversation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>> AsyncCreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>>(AsyncCreateConversationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>> PrepareAsyncCreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>>(PrepareAsyncCreateConversationRaw(context, request, cq));
    }
    // Returns the list of all conversations in the specified project.
    virtual ::grpc::Status ListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationsResponse>> AsyncListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationsResponse>>(AsyncListConversationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationsResponse>> PrepareAsyncListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationsResponse>>(PrepareAsyncListConversationsRaw(context, request, cq));
    }
    // Retrieves the specific conversation.
    virtual ::grpc::Status GetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::google::cloud::dialogflow::v2::Conversation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>> AsyncGetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>>(AsyncGetConversationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>> PrepareAsyncGetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>>(PrepareAsyncGetConversationRaw(context, request, cq));
    }
    // Completes the specified conversation. Finished conversations are purged
    // from the database after 30 days.
    virtual ::grpc::Status CompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::google::cloud::dialogflow::v2::Conversation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>> AsyncCompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>>(AsyncCompleteConversationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>> PrepareAsyncCompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>>(PrepareAsyncCompleteConversationRaw(context, request, cq));
    }
    // Lists messages that belong to a given conversation.
    // `messages` are ordered by `create_time` in descending order. To fetch
    // updates without duplication, send request with filter
    // `create_time_epoch_microseconds >
    // [first item's create_time of previous request]` and empty page_token.
    virtual ::grpc::Status ListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListMessagesResponse>> AsyncListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListMessagesResponse>>(AsyncListMessagesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListMessagesResponse>> PrepareAsyncListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListMessagesResponse>>(PrepareAsyncListMessagesRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a new conversation. Conversations are auto-completed after 24
      // hours.
      //
      // Conversation Lifecycle:
      // There are two stages during a conversation: Automated Agent Stage and
      // Assist Stage.
      //
      // For Automated Agent Stage, there will be a dialogflow agent responding to
      // user queries.
      //
      // For Assist Stage, there's no dialogflow agent responding to user queries.
      // But we will provide suggestions which are generated from conversation.
      //
      // If [Conversation.conversation_profile][google.cloud.dialogflow.v2.Conversation.conversation_profile] is configured for a dialogflow
      // agent, conversation will start from `Automated Agent Stage`, otherwise, it
      // will start from `Assist Stage`. And during `Automated Agent Stage`, once an
      // [Intent][google.cloud.dialogflow.v2.Intent] with [Intent.live_agent_handoff][google.cloud.dialogflow.v2.Intent.live_agent_handoff] is triggered, conversation
      // will transfer to Assist Stage.
      virtual void CreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns the list of all conversations in the specified project.
      virtual void ListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest* request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest* request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Retrieves the specific conversation.
      virtual void GetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Completes the specified conversation. Finished conversations are purged
      // from the database after 30 days.
      virtual void CompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists messages that belong to a given conversation.
      // `messages` are ordered by `create_time` in descending order. To fetch
      // updates without duplication, send request with filter
      // `create_time_epoch_microseconds >
      // [first item's create_time of previous request]` and empty page_token.
      virtual void ListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest* request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest* request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>* AsyncCreateConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>* PrepareAsyncCreateConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationsResponse>* AsyncListConversationsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationsResponse>* PrepareAsyncListConversationsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>* AsyncGetConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>* PrepareAsyncGetConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>* AsyncCompleteConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::Conversation>* PrepareAsyncCompleteConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListMessagesResponse>* AsyncListMessagesRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListMessagesResponse>* PrepareAsyncListMessagesRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::google::cloud::dialogflow::v2::Conversation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>> AsyncCreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>>(AsyncCreateConversationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>> PrepareAsyncCreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>>(PrepareAsyncCreateConversationRaw(context, request, cq));
    }
    ::grpc::Status ListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationsResponse>> AsyncListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationsResponse>>(AsyncListConversationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationsResponse>> PrepareAsyncListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationsResponse>>(PrepareAsyncListConversationsRaw(context, request, cq));
    }
    ::grpc::Status GetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::google::cloud::dialogflow::v2::Conversation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>> AsyncGetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>>(AsyncGetConversationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>> PrepareAsyncGetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>>(PrepareAsyncGetConversationRaw(context, request, cq));
    }
    ::grpc::Status CompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::google::cloud::dialogflow::v2::Conversation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>> AsyncCompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>>(AsyncCompleteConversationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>> PrepareAsyncCompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>>(PrepareAsyncCompleteConversationRaw(context, request, cq));
    }
    ::grpc::Status ListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListMessagesResponse>> AsyncListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListMessagesResponse>>(AsyncListMessagesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListMessagesResponse>> PrepareAsyncListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListMessagesResponse>>(PrepareAsyncListMessagesRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, std::function<void(::grpc::Status)>) override;
      void CreateConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest* request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListConversations(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest* request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, std::function<void(::grpc::Status)>) override;
      void GetConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, std::function<void(::grpc::Status)>) override;
      void CompleteConversation(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest* request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response, std::function<void(::grpc::Status)>) override;
      void ListMessages(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest* request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>* AsyncCreateConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>* PrepareAsyncCreateConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationsResponse>* AsyncListConversationsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationsResponse>* PrepareAsyncListConversationsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>* AsyncGetConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>* PrepareAsyncGetConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>* AsyncCompleteConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::Conversation>* PrepareAsyncCompleteConversationRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListMessagesResponse>* AsyncListMessagesRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListMessagesResponse>* PrepareAsyncListMessagesRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateConversation_;
    const ::grpc::internal::RpcMethod rpcmethod_ListConversations_;
    const ::grpc::internal::RpcMethod rpcmethod_GetConversation_;
    const ::grpc::internal::RpcMethod rpcmethod_CompleteConversation_;
    const ::grpc::internal::RpcMethod rpcmethod_ListMessages_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a new conversation. Conversations are auto-completed after 24
    // hours.
    //
    // Conversation Lifecycle:
    // There are two stages during a conversation: Automated Agent Stage and
    // Assist Stage.
    //
    // For Automated Agent Stage, there will be a dialogflow agent responding to
    // user queries.
    //
    // For Assist Stage, there's no dialogflow agent responding to user queries.
    // But we will provide suggestions which are generated from conversation.
    //
    // If [Conversation.conversation_profile][google.cloud.dialogflow.v2.Conversation.conversation_profile] is configured for a dialogflow
    // agent, conversation will start from `Automated Agent Stage`, otherwise, it
    // will start from `Assist Stage`. And during `Automated Agent Stage`, once an
    // [Intent][google.cloud.dialogflow.v2.Intent] with [Intent.live_agent_handoff][google.cloud.dialogflow.v2.Intent.live_agent_handoff] is triggered, conversation
    // will transfer to Assist Stage.
    virtual ::grpc::Status CreateConversation(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response);
    // Returns the list of all conversations in the specified project.
    virtual ::grpc::Status ListConversations(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest* request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response);
    // Retrieves the specific conversation.
    virtual ::grpc::Status GetConversation(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response);
    // Completes the specified conversation. Finished conversations are purged
    // from the database after 30 days.
    virtual ::grpc::Status CompleteConversation(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response);
    // Lists messages that belong to a given conversation.
    // `messages` are ordered by `create_time` in descending order. To fetch
    // updates without duplication, send request with filter
    // `create_time_epoch_microseconds >
    // [first item's create_time of previous request]` and empty page_token.
    virtual ::grpc::Status ListMessages(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest* request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateConversation() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateConversation(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::CreateConversationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::Conversation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListConversations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListConversations() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_ListConversations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversations(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListConversations(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::ListConversationsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::ListConversationsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetConversation() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_GetConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetConversation(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::GetConversationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::Conversation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CompleteConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CompleteConversation() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_CompleteConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CompleteConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCompleteConversation(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::CompleteConversationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::Conversation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListMessages : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListMessages() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_ListMessages() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMessages(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListMessagesRequest* /*request*/, ::google::cloud::dialogflow::v2::ListMessagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListMessages(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::ListMessagesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::ListMessagesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateConversation<WithAsyncMethod_ListConversations<WithAsyncMethod_GetConversation<WithAsyncMethod_CompleteConversation<WithAsyncMethod_ListMessages<Service > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateConversation() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::CreateConversationRequest, ::google::cloud::dialogflow::v2::Conversation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::CreateConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response) { return this->CreateConversation(context, request, response); }));}
    void SetMessageAllocatorFor_CreateConversation(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::CreateConversationRequest, ::google::cloud::dialogflow::v2::Conversation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::CreateConversationRequest, ::google::cloud::dialogflow::v2::Conversation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateConversation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListConversations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListConversations() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ListConversationsRequest, ::google::cloud::dialogflow::v2::ListConversationsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::ListConversationsRequest* request, ::google::cloud::dialogflow::v2::ListConversationsResponse* response) { return this->ListConversations(context, request, response); }));}
    void SetMessageAllocatorFor_ListConversations(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::ListConversationsRequest, ::google::cloud::dialogflow::v2::ListConversationsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ListConversationsRequest, ::google::cloud::dialogflow::v2::ListConversationsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListConversations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversations(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListConversations(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetConversation() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetConversationRequest, ::google::cloud::dialogflow::v2::Conversation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::GetConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response) { return this->GetConversation(context, request, response); }));}
    void SetMessageAllocatorFor_GetConversation(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::GetConversationRequest, ::google::cloud::dialogflow::v2::Conversation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetConversationRequest, ::google::cloud::dialogflow::v2::Conversation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetConversation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CompleteConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CompleteConversation() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::CompleteConversationRequest, ::google::cloud::dialogflow::v2::Conversation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* request, ::google::cloud::dialogflow::v2::Conversation* response) { return this->CompleteConversation(context, request, response); }));}
    void SetMessageAllocatorFor_CompleteConversation(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::CompleteConversationRequest, ::google::cloud::dialogflow::v2::Conversation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::CompleteConversationRequest, ::google::cloud::dialogflow::v2::Conversation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CompleteConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CompleteConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CompleteConversation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListMessages : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListMessages() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ListMessagesRequest, ::google::cloud::dialogflow::v2::ListMessagesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::ListMessagesRequest* request, ::google::cloud::dialogflow::v2::ListMessagesResponse* response) { return this->ListMessages(context, request, response); }));}
    void SetMessageAllocatorFor_ListMessages(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::ListMessagesRequest, ::google::cloud::dialogflow::v2::ListMessagesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ListMessagesRequest, ::google::cloud::dialogflow::v2::ListMessagesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListMessages() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMessages(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListMessagesRequest* /*request*/, ::google::cloud::dialogflow::v2::ListMessagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListMessages(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListMessagesRequest* /*request*/, ::google::cloud::dialogflow::v2::ListMessagesResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateConversation<WithCallbackMethod_ListConversations<WithCallbackMethod_GetConversation<WithCallbackMethod_CompleteConversation<WithCallbackMethod_ListMessages<Service > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateConversation() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListConversations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListConversations() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_ListConversations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversations(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetConversation() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_GetConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CompleteConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CompleteConversation() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_CompleteConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CompleteConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListMessages : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListMessages() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_ListMessages() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMessages(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListMessagesRequest* /*request*/, ::google::cloud::dialogflow::v2::ListMessagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateConversation() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateConversation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListConversations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListConversations() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_ListConversations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversations(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListConversations(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetConversation() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_GetConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetConversation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CompleteConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CompleteConversation() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_CompleteConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CompleteConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCompleteConversation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListMessages : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListMessages() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_ListMessages() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMessages(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListMessagesRequest* /*request*/, ::google::cloud::dialogflow::v2::ListMessagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListMessages(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateConversation() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateConversation(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateConversation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListConversations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListConversations() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListConversations(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListConversations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversations(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListConversations(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetConversation() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetConversation(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetConversation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CompleteConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CompleteConversation() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CompleteConversation(context, request, response); }));
    }
    ~WithRawCallbackMethod_CompleteConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CompleteConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CompleteConversation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListMessages : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListMessages() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListMessages(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListMessages() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListMessages(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListMessagesRequest* /*request*/, ::google::cloud::dialogflow::v2::ListMessagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListMessages(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateConversation() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::CreateConversationRequest, ::google::cloud::dialogflow::v2::Conversation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::CreateConversationRequest, ::google::cloud::dialogflow::v2::Conversation>* streamer) {
                       return this->StreamedCreateConversation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateConversation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::CreateConversationRequest,::google::cloud::dialogflow::v2::Conversation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListConversations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListConversations() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::ListConversationsRequest, ::google::cloud::dialogflow::v2::ListConversationsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::ListConversationsRequest, ::google::cloud::dialogflow::v2::ListConversationsResponse>* streamer) {
                       return this->StreamedListConversations(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListConversations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListConversations(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListConversations(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::ListConversationsRequest,::google::cloud::dialogflow::v2::ListConversationsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetConversation() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::GetConversationRequest, ::google::cloud::dialogflow::v2::Conversation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::GetConversationRequest, ::google::cloud::dialogflow::v2::Conversation>* streamer) {
                       return this->StreamedGetConversation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetConversation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::GetConversationRequest,::google::cloud::dialogflow::v2::Conversation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CompleteConversation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CompleteConversation() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::CompleteConversationRequest, ::google::cloud::dialogflow::v2::Conversation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::CompleteConversationRequest, ::google::cloud::dialogflow::v2::Conversation>* streamer) {
                       return this->StreamedCompleteConversation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CompleteConversation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CompleteConversation(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CompleteConversationRequest* /*request*/, ::google::cloud::dialogflow::v2::Conversation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCompleteConversation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::CompleteConversationRequest,::google::cloud::dialogflow::v2::Conversation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListMessages : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListMessages() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::ListMessagesRequest, ::google::cloud::dialogflow::v2::ListMessagesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::ListMessagesRequest, ::google::cloud::dialogflow::v2::ListMessagesResponse>* streamer) {
                       return this->StreamedListMessages(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListMessages() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListMessages(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListMessagesRequest* /*request*/, ::google::cloud::dialogflow::v2::ListMessagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListMessages(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::ListMessagesRequest,::google::cloud::dialogflow::v2::ListMessagesResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateConversation<WithStreamedUnaryMethod_ListConversations<WithStreamedUnaryMethod_GetConversation<WithStreamedUnaryMethod_CompleteConversation<WithStreamedUnaryMethod_ListMessages<Service > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateConversation<WithStreamedUnaryMethod_ListConversations<WithStreamedUnaryMethod_GetConversation<WithStreamedUnaryMethod_CompleteConversation<WithStreamedUnaryMethod_ListMessages<Service > > > > > StreamedService;
};

}  // namespace v2
}  // namespace dialogflow
}  // namespace cloud
}  // namespace google


#endif  // GRPC_google_2fcloud_2fdialogflow_2fv2_2fconversation_2eproto__INCLUDED
