// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_TABLE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_TABLE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/bigtable/admin/v2/bigtable_table_admin.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BigtableTableAdminConnectionIdempotencyPolicy {
 public:
  virtual ~BigtableTableAdminConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<BigtableTableAdminConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::internal::Idempotency CreateTable(
      google::bigtable::admin::v2::CreateTableRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency ListTables(
      google::bigtable::admin::v2::ListTablesRequest request) = 0;

  virtual google::cloud::internal::Idempotency GetTable(
      google::bigtable::admin::v2::GetTableRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency DeleteTable(
      google::bigtable::admin::v2::DeleteTableRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency ModifyColumnFamilies(
      google::bigtable::admin::v2::ModifyColumnFamiliesRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency DropRowRange(
      google::bigtable::admin::v2::DropRowRangeRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency GenerateConsistencyToken(
      google::bigtable::admin::v2::GenerateConsistencyTokenRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency CheckConsistency(
      google::bigtable::admin::v2::CheckConsistencyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency CreateBackup(
      google::bigtable::admin::v2::CreateBackupRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency GetBackup(
      google::bigtable::admin::v2::GetBackupRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency UpdateBackup(
      google::bigtable::admin::v2::UpdateBackupRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency DeleteBackup(
      google::bigtable::admin::v2::DeleteBackupRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency ListBackups(
      google::bigtable::admin::v2::ListBackupsRequest request) = 0;

  virtual google::cloud::internal::Idempotency RestoreTable(
      google::bigtable::admin::v2::RestoreTableRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;
};

std::unique_ptr<BigtableTableAdminConnectionIdempotencyPolicy>
MakeDefaultBigtableTableAdminConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_TABLE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
