// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPANNER_ADMIN_INSTANCE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPANNER_ADMIN_INSTANCE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/spanner/admin/instance/v1/spanner_instance_admin.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace spanner_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class InstanceAdminConnectionIdempotencyPolicy {
 public:
  virtual ~InstanceAdminConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<InstanceAdminConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::internal::Idempotency ListInstanceConfigs(
      google::spanner::admin::instance::v1::ListInstanceConfigsRequest
          request) = 0;

  virtual google::cloud::internal::Idempotency GetInstanceConfig(
      google::spanner::admin::instance::v1::GetInstanceConfigRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency ListInstances(
      google::spanner::admin::instance::v1::ListInstancesRequest request) = 0;

  virtual google::cloud::internal::Idempotency GetInstance(
      google::spanner::admin::instance::v1::GetInstanceRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency CreateInstance(
      google::spanner::admin::instance::v1::CreateInstanceRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency UpdateInstance(
      google::spanner::admin::instance::v1::UpdateInstanceRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency DeleteInstance(
      google::spanner::admin::instance::v1::DeleteInstanceRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;
};

std::unique_ptr<InstanceAdminConnectionIdempotencyPolicy>
MakeDefaultInstanceAdminConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
namespace gcpcxxV1 = GOOGLE_CLOUD_CPP_NS;  // NOLINT(misc-unused-alias-decls)
}  // namespace spanner_admin
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPANNER_ADMIN_INSTANCE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
