// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/admin/v1/iam.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_IAM_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_IAM_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/iam/admin/v1/iam.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace iam {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class IAMConnectionIdempotencyPolicy {
 public:
  virtual ~IAMConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<IAMConnectionIdempotencyPolicy> clone() const = 0;

  virtual google::cloud::internal::Idempotency ListServiceAccounts(
      google::iam::admin::v1::ListServiceAccountsRequest request) = 0;

  virtual google::cloud::internal::Idempotency GetServiceAccount(
      google::iam::admin::v1::GetServiceAccountRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency CreateServiceAccount(
      google::iam::admin::v1::CreateServiceAccountRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency PatchServiceAccount(
      google::iam::admin::v1::PatchServiceAccountRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency DeleteServiceAccount(
      google::iam::admin::v1::DeleteServiceAccountRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency UndeleteServiceAccount(
      google::iam::admin::v1::UndeleteServiceAccountRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency EnableServiceAccount(
      google::iam::admin::v1::EnableServiceAccountRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency DisableServiceAccount(
      google::iam::admin::v1::DisableServiceAccountRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency ListServiceAccountKeys(
      google::iam::admin::v1::ListServiceAccountKeysRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency GetServiceAccountKey(
      google::iam::admin::v1::GetServiceAccountKeyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency CreateServiceAccountKey(
      google::iam::admin::v1::CreateServiceAccountKeyRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency UploadServiceAccountKey(
      google::iam::admin::v1::UploadServiceAccountKeyRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency DeleteServiceAccountKey(
      google::iam::admin::v1::DeleteServiceAccountKeyRequest const&
          request) = 0;

  virtual google::cloud::internal::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency QueryGrantableRoles(
      google::iam::admin::v1::QueryGrantableRolesRequest request) = 0;

  virtual google::cloud::internal::Idempotency ListRoles(
      google::iam::admin::v1::ListRolesRequest request) = 0;

  virtual google::cloud::internal::Idempotency GetRole(
      google::iam::admin::v1::GetRoleRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency CreateRole(
      google::iam::admin::v1::CreateRoleRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency UpdateRole(
      google::iam::admin::v1::UpdateRoleRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency DeleteRole(
      google::iam::admin::v1::DeleteRoleRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency UndeleteRole(
      google::iam::admin::v1::UndeleteRoleRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency QueryTestablePermissions(
      google::iam::admin::v1::QueryTestablePermissionsRequest request) = 0;

  virtual google::cloud::internal::Idempotency QueryAuditableServices(
      google::iam::admin::v1::QueryAuditableServicesRequest const& request) = 0;

  virtual google::cloud::internal::Idempotency LintPolicy(
      google::iam::admin::v1::LintPolicyRequest const& request) = 0;
};

std::unique_ptr<IAMConnectionIdempotencyPolicy>
MakeDefaultIAMConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
namespace gcpcxxV1 = GOOGLE_CLOUD_CPP_NS;  // NOLINT(misc-unused-alias-decls)
}  // namespace iam
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_IAM_CONNECTION_IDEMPOTENCY_POLICY_H
