// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/storage/v2/storage.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fstorage_2fv2_2fstorage_2eproto__INCLUDED
#define GRPC_google_2fstorage_2fv2_2fstorage_2eproto__INCLUDED

#include "google/storage/v2/storage.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace storage {
namespace v2 {

// ## API Overview and Naming Syntax
//
// The GCS gRPC API allows applications to read and write data through the
// abstractions of buckets and objects. For a description of these abstractions
// please see https://cloud.google.com/storage/docs.
//
// Resources are named as follows:
//   - Projects are referred to as they are defined by the Resource Manager API,
//     using strings like `projects/123456` or `projects/my-string-id`.
//   - Buckets are named using string names of the form:
//     `projects/{project}/buckets/{bucket}`
//     For globally unique buckets, `_` may be substituted for the project.
//   - Objects are uniquely identified by their name along with the name of the
//     bucket they belong to, as separate strings in this API. For example:
//
//       ReadObjectRequest {
//         bucket: 'projects/_/buckets/my-bucket'
//         object: 'my-object'
//       }
//     Note that object names can contain `/` characters, which are treated as
//     any other character (no special directory semantics).
class Storage final {
 public:
  static constexpr char const* service_full_name() {
    return "google.storage.v2.Storage";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Reads an object's data.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::google::storage::v2::ReadObjectResponse>> ReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::google::storage::v2::ReadObjectResponse>>(ReadObjectRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::storage::v2::ReadObjectResponse>> AsyncReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::storage::v2::ReadObjectResponse>>(AsyncReadObjectRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::storage::v2::ReadObjectResponse>> PrepareAsyncReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::storage::v2::ReadObjectResponse>>(PrepareAsyncReadObjectRaw(context, request, cq));
    }
    // Stores a new object and metadata.
    //
    // An object can be written either in a single message stream or in a
    // resumable sequence of message streams. To write using a single stream,
    // the client should include in the first message of the stream an
    // `WriteObjectSpec` describing the destination bucket, object, and any
    // preconditions. Additionally, the final message must set 'finish_write' to
    // true, or else it is an error.
    //
    // For a resumable write, the client should instead call
    // `StartResumableWrite()` and provide that method an `WriteObjectSpec.`
    // They should then attach the returned `upload_id` to the first message of
    // each following call to `Create`. If there is an error or the connection is
    // broken during the resumable `Create()`, the client should check the status
    // of the `Create()` by calling `QueryWriteStatus()` and continue writing from
    // the returned `persisted_size`. This may be less than the amount of data the
    // client previously sent.
    //
    // The service will not view the object as complete until the client has
    // sent a `WriteObjectRequest` with `finish_write` set to `true`. Sending any
    // requests on a stream after sending a request with `finish_write` set to
    // `true` will cause an error. The client **should** check the response it
    // receives to determine how much data the service was able to commit and
    // whether the service views the object as complete.
    std::unique_ptr< ::grpc::ClientWriterInterface< ::google::storage::v2::WriteObjectRequest>> WriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response) {
      return std::unique_ptr< ::grpc::ClientWriterInterface< ::google::storage::v2::WriteObjectRequest>>(WriteObjectRaw(context, response));
    }
    std::unique_ptr< ::grpc::ClientAsyncWriterInterface< ::google::storage::v2::WriteObjectRequest>> AsyncWriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncWriterInterface< ::google::storage::v2::WriteObjectRequest>>(AsyncWriteObjectRaw(context, response, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncWriterInterface< ::google::storage::v2::WriteObjectRequest>> PrepareAsyncWriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncWriterInterface< ::google::storage::v2::WriteObjectRequest>>(PrepareAsyncWriteObjectRaw(context, response, cq));
    }
    // Starts a resumable write. How long the write operation remains valid, and
    // what happens when the write operation becomes invalid, are
    // service-dependent.
    virtual ::grpc::Status StartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::google::storage::v2::StartResumableWriteResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::StartResumableWriteResponse>> AsyncStartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::StartResumableWriteResponse>>(AsyncStartResumableWriteRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::StartResumableWriteResponse>> PrepareAsyncStartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::StartResumableWriteResponse>>(PrepareAsyncStartResumableWriteRaw(context, request, cq));
    }
    // Determines the `persisted_size` for an object that is being written, which
    // can then be used as the `write_offset` for the next `Write()` call.
    //
    // If the object does not exist (i.e., the object has been deleted, or the
    // first `Write()` has not yet reached the service), this method returns the
    // error `NOT_FOUND`.
    //
    // The client **may** call `QueryWriteStatus()` at any time to determine how
    // much data has been processed for this object. This is useful if the
    // client is buffering data and needs to know which data can be safely
    // evicted. For any sequence of `QueryWriteStatus()` calls for a given
    // object name, the sequence of returned `persisted_size` values will be
    // non-decreasing.
    virtual ::grpc::Status QueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::google::storage::v2::QueryWriteStatusResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::QueryWriteStatusResponse>> AsyncQueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::QueryWriteStatusResponse>>(AsyncQueryWriteStatusRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::QueryWriteStatusResponse>> PrepareAsyncQueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::QueryWriteStatusResponse>>(PrepareAsyncQueryWriteStatusRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Reads an object's data.
      virtual void ReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest* request, ::grpc::ClientReadReactor< ::google::storage::v2::ReadObjectResponse>* reactor) = 0;
      // Stores a new object and metadata.
      //
      // An object can be written either in a single message stream or in a
      // resumable sequence of message streams. To write using a single stream,
      // the client should include in the first message of the stream an
      // `WriteObjectSpec` describing the destination bucket, object, and any
      // preconditions. Additionally, the final message must set 'finish_write' to
      // true, or else it is an error.
      //
      // For a resumable write, the client should instead call
      // `StartResumableWrite()` and provide that method an `WriteObjectSpec.`
      // They should then attach the returned `upload_id` to the first message of
      // each following call to `Create`. If there is an error or the connection is
      // broken during the resumable `Create()`, the client should check the status
      // of the `Create()` by calling `QueryWriteStatus()` and continue writing from
      // the returned `persisted_size`. This may be less than the amount of data the
      // client previously sent.
      //
      // The service will not view the object as complete until the client has
      // sent a `WriteObjectRequest` with `finish_write` set to `true`. Sending any
      // requests on a stream after sending a request with `finish_write` set to
      // `true` will cause an error. The client **should** check the response it
      // receives to determine how much data the service was able to commit and
      // whether the service views the object as complete.
      virtual void WriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::ClientWriteReactor< ::google::storage::v2::WriteObjectRequest>* reactor) = 0;
      // Starts a resumable write. How long the write operation remains valid, and
      // what happens when the write operation becomes invalid, are
      // service-dependent.
      virtual void StartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest* request, ::google::storage::v2::StartResumableWriteResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void StartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest* request, ::google::storage::v2::StartResumableWriteResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Determines the `persisted_size` for an object that is being written, which
      // can then be used as the `write_offset` for the next `Write()` call.
      //
      // If the object does not exist (i.e., the object has been deleted, or the
      // first `Write()` has not yet reached the service), this method returns the
      // error `NOT_FOUND`.
      //
      // The client **may** call `QueryWriteStatus()` at any time to determine how
      // much data has been processed for this object. This is useful if the
      // client is buffering data and needs to know which data can be safely
      // evicted. For any sequence of `QueryWriteStatus()` calls for a given
      // object name, the sequence of returned `persisted_size` values will be
      // non-decreasing.
      virtual void QueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest* request, ::google::storage::v2::QueryWriteStatusResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void QueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest* request, ::google::storage::v2::QueryWriteStatusResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientReaderInterface< ::google::storage::v2::ReadObjectResponse>* ReadObjectRaw(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::storage::v2::ReadObjectResponse>* AsyncReadObjectRaw(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::storage::v2::ReadObjectResponse>* PrepareAsyncReadObjectRaw(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientWriterInterface< ::google::storage::v2::WriteObjectRequest>* WriteObjectRaw(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response) = 0;
    virtual ::grpc::ClientAsyncWriterInterface< ::google::storage::v2::WriteObjectRequest>* AsyncWriteObjectRaw(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncWriterInterface< ::google::storage::v2::WriteObjectRequest>* PrepareAsyncWriteObjectRaw(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::StartResumableWriteResponse>* AsyncStartResumableWriteRaw(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::StartResumableWriteResponse>* PrepareAsyncStartResumableWriteRaw(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::QueryWriteStatusResponse>* AsyncQueryWriteStatusRaw(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::storage::v2::QueryWriteStatusResponse>* PrepareAsyncQueryWriteStatusRaw(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    std::unique_ptr< ::grpc::ClientReader< ::google::storage::v2::ReadObjectResponse>> ReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::google::storage::v2::ReadObjectResponse>>(ReadObjectRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::storage::v2::ReadObjectResponse>> AsyncReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::storage::v2::ReadObjectResponse>>(AsyncReadObjectRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::storage::v2::ReadObjectResponse>> PrepareAsyncReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::storage::v2::ReadObjectResponse>>(PrepareAsyncReadObjectRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientWriter< ::google::storage::v2::WriteObjectRequest>> WriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response) {
      return std::unique_ptr< ::grpc::ClientWriter< ::google::storage::v2::WriteObjectRequest>>(WriteObjectRaw(context, response));
    }
    std::unique_ptr< ::grpc::ClientAsyncWriter< ::google::storage::v2::WriteObjectRequest>> AsyncWriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncWriter< ::google::storage::v2::WriteObjectRequest>>(AsyncWriteObjectRaw(context, response, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncWriter< ::google::storage::v2::WriteObjectRequest>> PrepareAsyncWriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncWriter< ::google::storage::v2::WriteObjectRequest>>(PrepareAsyncWriteObjectRaw(context, response, cq));
    }
    ::grpc::Status StartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::google::storage::v2::StartResumableWriteResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::StartResumableWriteResponse>> AsyncStartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::StartResumableWriteResponse>>(AsyncStartResumableWriteRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::StartResumableWriteResponse>> PrepareAsyncStartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::StartResumableWriteResponse>>(PrepareAsyncStartResumableWriteRaw(context, request, cq));
    }
    ::grpc::Status QueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::google::storage::v2::QueryWriteStatusResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::QueryWriteStatusResponse>> AsyncQueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::QueryWriteStatusResponse>>(AsyncQueryWriteStatusRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::QueryWriteStatusResponse>> PrepareAsyncQueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::storage::v2::QueryWriteStatusResponse>>(PrepareAsyncQueryWriteStatusRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void ReadObject(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest* request, ::grpc::ClientReadReactor< ::google::storage::v2::ReadObjectResponse>* reactor) override;
      void WriteObject(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::ClientWriteReactor< ::google::storage::v2::WriteObjectRequest>* reactor) override;
      void StartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest* request, ::google::storage::v2::StartResumableWriteResponse* response, std::function<void(::grpc::Status)>) override;
      void StartResumableWrite(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest* request, ::google::storage::v2::StartResumableWriteResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void QueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest* request, ::google::storage::v2::QueryWriteStatusResponse* response, std::function<void(::grpc::Status)>) override;
      void QueryWriteStatus(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest* request, ::google::storage::v2::QueryWriteStatusResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientReader< ::google::storage::v2::ReadObjectResponse>* ReadObjectRaw(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request) override;
    ::grpc::ClientAsyncReader< ::google::storage::v2::ReadObjectResponse>* AsyncReadObjectRaw(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::google::storage::v2::ReadObjectResponse>* PrepareAsyncReadObjectRaw(::grpc::ClientContext* context, const ::google::storage::v2::ReadObjectRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientWriter< ::google::storage::v2::WriteObjectRequest>* WriteObjectRaw(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response) override;
    ::grpc::ClientAsyncWriter< ::google::storage::v2::WriteObjectRequest>* AsyncWriteObjectRaw(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncWriter< ::google::storage::v2::WriteObjectRequest>* PrepareAsyncWriteObjectRaw(::grpc::ClientContext* context, ::google::storage::v2::WriteObjectResponse* response, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::storage::v2::StartResumableWriteResponse>* AsyncStartResumableWriteRaw(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::storage::v2::StartResumableWriteResponse>* PrepareAsyncStartResumableWriteRaw(::grpc::ClientContext* context, const ::google::storage::v2::StartResumableWriteRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::storage::v2::QueryWriteStatusResponse>* AsyncQueryWriteStatusRaw(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::storage::v2::QueryWriteStatusResponse>* PrepareAsyncQueryWriteStatusRaw(::grpc::ClientContext* context, const ::google::storage::v2::QueryWriteStatusRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_ReadObject_;
    const ::grpc::internal::RpcMethod rpcmethod_WriteObject_;
    const ::grpc::internal::RpcMethod rpcmethod_StartResumableWrite_;
    const ::grpc::internal::RpcMethod rpcmethod_QueryWriteStatus_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Reads an object's data.
    virtual ::grpc::Status ReadObject(::grpc::ServerContext* context, const ::google::storage::v2::ReadObjectRequest* request, ::grpc::ServerWriter< ::google::storage::v2::ReadObjectResponse>* writer);
    // Stores a new object and metadata.
    //
    // An object can be written either in a single message stream or in a
    // resumable sequence of message streams. To write using a single stream,
    // the client should include in the first message of the stream an
    // `WriteObjectSpec` describing the destination bucket, object, and any
    // preconditions. Additionally, the final message must set 'finish_write' to
    // true, or else it is an error.
    //
    // For a resumable write, the client should instead call
    // `StartResumableWrite()` and provide that method an `WriteObjectSpec.`
    // They should then attach the returned `upload_id` to the first message of
    // each following call to `Create`. If there is an error or the connection is
    // broken during the resumable `Create()`, the client should check the status
    // of the `Create()` by calling `QueryWriteStatus()` and continue writing from
    // the returned `persisted_size`. This may be less than the amount of data the
    // client previously sent.
    //
    // The service will not view the object as complete until the client has
    // sent a `WriteObjectRequest` with `finish_write` set to `true`. Sending any
    // requests on a stream after sending a request with `finish_write` set to
    // `true` will cause an error. The client **should** check the response it
    // receives to determine how much data the service was able to commit and
    // whether the service views the object as complete.
    virtual ::grpc::Status WriteObject(::grpc::ServerContext* context, ::grpc::ServerReader< ::google::storage::v2::WriteObjectRequest>* reader, ::google::storage::v2::WriteObjectResponse* response);
    // Starts a resumable write. How long the write operation remains valid, and
    // what happens when the write operation becomes invalid, are
    // service-dependent.
    virtual ::grpc::Status StartResumableWrite(::grpc::ServerContext* context, const ::google::storage::v2::StartResumableWriteRequest* request, ::google::storage::v2::StartResumableWriteResponse* response);
    // Determines the `persisted_size` for an object that is being written, which
    // can then be used as the `write_offset` for the next `Write()` call.
    //
    // If the object does not exist (i.e., the object has been deleted, or the
    // first `Write()` has not yet reached the service), this method returns the
    // error `NOT_FOUND`.
    //
    // The client **may** call `QueryWriteStatus()` at any time to determine how
    // much data has been processed for this object. This is useful if the
    // client is buffering data and needs to know which data can be safely
    // evicted. For any sequence of `QueryWriteStatus()` calls for a given
    // object name, the sequence of returned `persisted_size` values will be
    // non-decreasing.
    virtual ::grpc::Status QueryWriteStatus(::grpc::ServerContext* context, const ::google::storage::v2::QueryWriteStatusRequest* request, ::google::storage::v2::QueryWriteStatusResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_ReadObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ReadObject() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_ReadObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadObject(::grpc::ServerContext* /*context*/, const ::google::storage::v2::ReadObjectRequest* /*request*/, ::grpc::ServerWriter< ::google::storage::v2::ReadObjectResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestReadObject(::grpc::ServerContext* context, ::google::storage::v2::ReadObjectRequest* request, ::grpc::ServerAsyncWriter< ::google::storage::v2::ReadObjectResponse>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(0, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_WriteObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_WriteObject() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_WriteObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteObject(::grpc::ServerContext* /*context*/, ::grpc::ServerReader< ::google::storage::v2::WriteObjectRequest>* /*reader*/, ::google::storage::v2::WriteObjectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWriteObject(::grpc::ServerContext* context, ::grpc::ServerAsyncReader< ::google::storage::v2::WriteObjectResponse, ::google::storage::v2::WriteObjectRequest>* reader, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncClientStreaming(1, context, reader, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_StartResumableWrite : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_StartResumableWrite() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_StartResumableWrite() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StartResumableWrite(::grpc::ServerContext* /*context*/, const ::google::storage::v2::StartResumableWriteRequest* /*request*/, ::google::storage::v2::StartResumableWriteResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStartResumableWrite(::grpc::ServerContext* context, ::google::storage::v2::StartResumableWriteRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::storage::v2::StartResumableWriteResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_QueryWriteStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_QueryWriteStatus() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_QueryWriteStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryWriteStatus(::grpc::ServerContext* /*context*/, const ::google::storage::v2::QueryWriteStatusRequest* /*request*/, ::google::storage::v2::QueryWriteStatusResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryWriteStatus(::grpc::ServerContext* context, ::google::storage::v2::QueryWriteStatusRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::storage::v2::QueryWriteStatusResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_ReadObject<WithAsyncMethod_WriteObject<WithAsyncMethod_StartResumableWrite<WithAsyncMethod_QueryWriteStatus<Service > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_ReadObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ReadObject() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackServerStreamingHandler< ::google::storage::v2::ReadObjectRequest, ::google::storage::v2::ReadObjectResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::storage::v2::ReadObjectRequest* request) { return this->ReadObject(context, request); }));
    }
    ~WithCallbackMethod_ReadObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadObject(::grpc::ServerContext* /*context*/, const ::google::storage::v2::ReadObjectRequest* /*request*/, ::grpc::ServerWriter< ::google::storage::v2::ReadObjectResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::google::storage::v2::ReadObjectResponse>* ReadObject(
      ::grpc::CallbackServerContext* /*context*/, const ::google::storage::v2::ReadObjectRequest* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_WriteObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_WriteObject() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackClientStreamingHandler< ::google::storage::v2::WriteObjectRequest, ::google::storage::v2::WriteObjectResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, ::google::storage::v2::WriteObjectResponse* response) { return this->WriteObject(context, response); }));
    }
    ~WithCallbackMethod_WriteObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteObject(::grpc::ServerContext* /*context*/, ::grpc::ServerReader< ::google::storage::v2::WriteObjectRequest>* /*reader*/, ::google::storage::v2::WriteObjectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerReadReactor< ::google::storage::v2::WriteObjectRequest>* WriteObject(
      ::grpc::CallbackServerContext* /*context*/, ::google::storage::v2::WriteObjectResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_StartResumableWrite : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_StartResumableWrite() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::storage::v2::StartResumableWriteRequest, ::google::storage::v2::StartResumableWriteResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::storage::v2::StartResumableWriteRequest* request, ::google::storage::v2::StartResumableWriteResponse* response) { return this->StartResumableWrite(context, request, response); }));}
    void SetMessageAllocatorFor_StartResumableWrite(
        ::grpc::MessageAllocator< ::google::storage::v2::StartResumableWriteRequest, ::google::storage::v2::StartResumableWriteResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::storage::v2::StartResumableWriteRequest, ::google::storage::v2::StartResumableWriteResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_StartResumableWrite() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StartResumableWrite(::grpc::ServerContext* /*context*/, const ::google::storage::v2::StartResumableWriteRequest* /*request*/, ::google::storage::v2::StartResumableWriteResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* StartResumableWrite(
      ::grpc::CallbackServerContext* /*context*/, const ::google::storage::v2::StartResumableWriteRequest* /*request*/, ::google::storage::v2::StartResumableWriteResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_QueryWriteStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_QueryWriteStatus() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::storage::v2::QueryWriteStatusRequest, ::google::storage::v2::QueryWriteStatusResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::storage::v2::QueryWriteStatusRequest* request, ::google::storage::v2::QueryWriteStatusResponse* response) { return this->QueryWriteStatus(context, request, response); }));}
    void SetMessageAllocatorFor_QueryWriteStatus(
        ::grpc::MessageAllocator< ::google::storage::v2::QueryWriteStatusRequest, ::google::storage::v2::QueryWriteStatusResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::storage::v2::QueryWriteStatusRequest, ::google::storage::v2::QueryWriteStatusResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_QueryWriteStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryWriteStatus(::grpc::ServerContext* /*context*/, const ::google::storage::v2::QueryWriteStatusRequest* /*request*/, ::google::storage::v2::QueryWriteStatusResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryWriteStatus(
      ::grpc::CallbackServerContext* /*context*/, const ::google::storage::v2::QueryWriteStatusRequest* /*request*/, ::google::storage::v2::QueryWriteStatusResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_ReadObject<WithCallbackMethod_WriteObject<WithCallbackMethod_StartResumableWrite<WithCallbackMethod_QueryWriteStatus<Service > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_ReadObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ReadObject() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_ReadObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadObject(::grpc::ServerContext* /*context*/, const ::google::storage::v2::ReadObjectRequest* /*request*/, ::grpc::ServerWriter< ::google::storage::v2::ReadObjectResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_WriteObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_WriteObject() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_WriteObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteObject(::grpc::ServerContext* /*context*/, ::grpc::ServerReader< ::google::storage::v2::WriteObjectRequest>* /*reader*/, ::google::storage::v2::WriteObjectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_StartResumableWrite : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_StartResumableWrite() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_StartResumableWrite() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StartResumableWrite(::grpc::ServerContext* /*context*/, const ::google::storage::v2::StartResumableWriteRequest* /*request*/, ::google::storage::v2::StartResumableWriteResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_QueryWriteStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_QueryWriteStatus() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_QueryWriteStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryWriteStatus(::grpc::ServerContext* /*context*/, const ::google::storage::v2::QueryWriteStatusRequest* /*request*/, ::google::storage::v2::QueryWriteStatusResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_ReadObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ReadObject() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_ReadObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadObject(::grpc::ServerContext* /*context*/, const ::google::storage::v2::ReadObjectRequest* /*request*/, ::grpc::ServerWriter< ::google::storage::v2::ReadObjectResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestReadObject(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(0, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_WriteObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_WriteObject() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_WriteObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteObject(::grpc::ServerContext* /*context*/, ::grpc::ServerReader< ::google::storage::v2::WriteObjectRequest>* /*reader*/, ::google::storage::v2::WriteObjectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWriteObject(::grpc::ServerContext* context, ::grpc::ServerAsyncReader< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* reader, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncClientStreaming(1, context, reader, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_StartResumableWrite : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_StartResumableWrite() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_StartResumableWrite() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StartResumableWrite(::grpc::ServerContext* /*context*/, const ::google::storage::v2::StartResumableWriteRequest* /*request*/, ::google::storage::v2::StartResumableWriteResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStartResumableWrite(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_QueryWriteStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_QueryWriteStatus() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_QueryWriteStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryWriteStatus(::grpc::ServerContext* /*context*/, const ::google::storage::v2::QueryWriteStatusRequest* /*request*/, ::google::storage::v2::QueryWriteStatusResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryWriteStatus(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ReadObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ReadObject() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->ReadObject(context, request); }));
    }
    ~WithRawCallbackMethod_ReadObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ReadObject(::grpc::ServerContext* /*context*/, const ::google::storage::v2::ReadObjectRequest* /*request*/, ::grpc::ServerWriter< ::google::storage::v2::ReadObjectResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* ReadObject(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_WriteObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_WriteObject() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackClientStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, ::grpc::ByteBuffer* response) { return this->WriteObject(context, response); }));
    }
    ~WithRawCallbackMethod_WriteObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WriteObject(::grpc::ServerContext* /*context*/, ::grpc::ServerReader< ::google::storage::v2::WriteObjectRequest>* /*reader*/, ::google::storage::v2::WriteObjectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerReadReactor< ::grpc::ByteBuffer>* WriteObject(
      ::grpc::CallbackServerContext* /*context*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_StartResumableWrite : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_StartResumableWrite() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->StartResumableWrite(context, request, response); }));
    }
    ~WithRawCallbackMethod_StartResumableWrite() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StartResumableWrite(::grpc::ServerContext* /*context*/, const ::google::storage::v2::StartResumableWriteRequest* /*request*/, ::google::storage::v2::StartResumableWriteResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* StartResumableWrite(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_QueryWriteStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_QueryWriteStatus() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->QueryWriteStatus(context, request, response); }));
    }
    ~WithRawCallbackMethod_QueryWriteStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryWriteStatus(::grpc::ServerContext* /*context*/, const ::google::storage::v2::QueryWriteStatusRequest* /*request*/, ::google::storage::v2::QueryWriteStatusResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryWriteStatus(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_StartResumableWrite : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_StartResumableWrite() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::storage::v2::StartResumableWriteRequest, ::google::storage::v2::StartResumableWriteResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::storage::v2::StartResumableWriteRequest, ::google::storage::v2::StartResumableWriteResponse>* streamer) {
                       return this->StreamedStartResumableWrite(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_StartResumableWrite() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status StartResumableWrite(::grpc::ServerContext* /*context*/, const ::google::storage::v2::StartResumableWriteRequest* /*request*/, ::google::storage::v2::StartResumableWriteResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedStartResumableWrite(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::storage::v2::StartResumableWriteRequest,::google::storage::v2::StartResumableWriteResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_QueryWriteStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_QueryWriteStatus() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::storage::v2::QueryWriteStatusRequest, ::google::storage::v2::QueryWriteStatusResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::storage::v2::QueryWriteStatusRequest, ::google::storage::v2::QueryWriteStatusResponse>* streamer) {
                       return this->StreamedQueryWriteStatus(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_QueryWriteStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status QueryWriteStatus(::grpc::ServerContext* /*context*/, const ::google::storage::v2::QueryWriteStatusRequest* /*request*/, ::google::storage::v2::QueryWriteStatusResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedQueryWriteStatus(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::storage::v2::QueryWriteStatusRequest,::google::storage::v2::QueryWriteStatusResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_StartResumableWrite<WithStreamedUnaryMethod_QueryWriteStatus<Service > > StreamedUnaryService;
  template <class BaseClass>
  class WithSplitStreamingMethod_ReadObject : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_ReadObject() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::google::storage::v2::ReadObjectRequest, ::google::storage::v2::ReadObjectResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::google::storage::v2::ReadObjectRequest, ::google::storage::v2::ReadObjectResponse>* streamer) {
                       return this->StreamedReadObject(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_ReadObject() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ReadObject(::grpc::ServerContext* /*context*/, const ::google::storage::v2::ReadObjectRequest* /*request*/, ::grpc::ServerWriter< ::google::storage::v2::ReadObjectResponse>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedReadObject(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::google::storage::v2::ReadObjectRequest,::google::storage::v2::ReadObjectResponse>* server_split_streamer) = 0;
  };
  typedef WithSplitStreamingMethod_ReadObject<Service > SplitStreamedService;
  typedef WithSplitStreamingMethod_ReadObject<WithStreamedUnaryMethod_StartResumableWrite<WithStreamedUnaryMethod_QueryWriteStatus<Service > > > StreamedService;
};

}  // namespace v2
}  // namespace storage
}  // namespace google


#endif  // GRPC_google_2fstorage_2fv2_2fstorage_2eproto__INCLUDED
