# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from google.cloud.bigquery_storage_v1.proto import (
    storage_pb2 as google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2,
)
from google.cloud.bigquery_storage_v1.proto import (
    stream_pb2 as google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_stream__pb2,
)


class BigQueryReadStub(object):
    """BigQuery Read API.

    The Read API can be used to read data from BigQuery.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CreateReadSession = channel.unary_unary(
            "/google.cloud.bigquery.storage.v1.BigQueryRead/CreateReadSession",
            request_serializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.CreateReadSessionRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_stream__pb2.ReadSession.FromString,
        )
        self.ReadRows = channel.unary_stream(
            "/google.cloud.bigquery.storage.v1.BigQueryRead/ReadRows",
            request_serializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.ReadRowsRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.ReadRowsResponse.FromString,
        )
        self.SplitReadStream = channel.unary_unary(
            "/google.cloud.bigquery.storage.v1.BigQueryRead/SplitReadStream",
            request_serializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.SplitReadStreamRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.SplitReadStreamResponse.FromString,
        )


class BigQueryReadServicer(object):
    """BigQuery Read API.

    The Read API can be used to read data from BigQuery.
    """

    def CreateReadSession(self, request, context):
        """Creates a new read session. A read session divides the contents of a
        BigQuery table into one or more streams, which can then be used to read
        data from the table. The read session also specifies properties of the
        data to be read, such as a list of columns or a push-down filter describing
        the rows to be returned.

        A particular row can be read by at most one stream. When the caller has
        reached the end of each stream in the session, then all the data in the
        table has been read.

        Data is assigned to each stream such that roughly the same number of
        rows can be read from each stream. Because the server-side unit for
        assigning data is collections of rows, the API does not guarantee that
        each stream will return the same number or rows. Additionally, the
        limits are enforced based on the number of pre-filtered rows, so some
        filters can lead to lopsided assignments.

        Read sessions automatically expire 24 hours after they are created and do
        not require manual clean-up by the caller.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ReadRows(self, request, context):
        """Reads rows from the stream in the format prescribed by the ReadSession.
        Each response contains one or more table rows, up to a maximum of 100 MiB
        per response; read requests which attempt to read individual rows larger
        than 100 MiB will fail.

        Each request also returns a set of stream statistics reflecting the current
        state of the stream.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def SplitReadStream(self, request, context):
        """Splits a given `ReadStream` into two `ReadStream` objects. These
        `ReadStream` objects are referred to as the primary and the residual
        streams of the split. The original `ReadStream` can still be read from in
        the same manner as before. Both of the returned `ReadStream` objects can
        also be read from, and the rows returned by both child streams will be
        the same as the rows read from the original stream.

        Moreover, the two child streams will be allocated back-to-back in the
        original `ReadStream`. Concretely, it is guaranteed that for streams
        original, primary, and residual, that original[0-j] = primary[0-j] and
        original[j-n] = residual[0-m] once the streams have been read to
        completion.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_BigQueryReadServicer_to_server(servicer, server):
    rpc_method_handlers = {
        "CreateReadSession": grpc.unary_unary_rpc_method_handler(
            servicer.CreateReadSession,
            request_deserializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.CreateReadSessionRequest.FromString,
            response_serializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_stream__pb2.ReadSession.SerializeToString,
        ),
        "ReadRows": grpc.unary_stream_rpc_method_handler(
            servicer.ReadRows,
            request_deserializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.ReadRowsRequest.FromString,
            response_serializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.ReadRowsResponse.SerializeToString,
        ),
        "SplitReadStream": grpc.unary_unary_rpc_method_handler(
            servicer.SplitReadStream,
            request_deserializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.SplitReadStreamRequest.FromString,
            response_serializer=google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.SplitReadStreamResponse.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "google.cloud.bigquery.storage.v1.BigQueryRead", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))


# This class is part of an EXPERIMENTAL API.
class BigQueryRead(object):
    """BigQuery Read API.

    The Read API can be used to read data from BigQuery.
    """

    @staticmethod
    def CreateReadSession(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/google.cloud.bigquery.storage.v1.BigQueryRead/CreateReadSession",
            google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.CreateReadSessionRequest.SerializeToString,
            google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_stream__pb2.ReadSession.FromString,
            options,
            channel_credentials,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ReadRows(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_stream(
            request,
            target,
            "/google.cloud.bigquery.storage.v1.BigQueryRead/ReadRows",
            google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.ReadRowsRequest.SerializeToString,
            google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.ReadRowsResponse.FromString,
            options,
            channel_credentials,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def SplitReadStream(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/google.cloud.bigquery.storage.v1.BigQueryRead/SplitReadStream",
            google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.SplitReadStreamRequest.SerializeToString,
            google_dot_cloud_dot_bigquery__storage__v1_dot_proto_dot_storage__pb2.SplitReadStreamResponse.FromString,
            options,
            channel_credentials,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )
