#!D:\bld\gnuradio_1623414371239\_h_env\python.exe
#
# Copyright 2015 Free Software Foundation, Inc.
#
# This file is part of GNU Radio
#
# SPDX-License-Identifier: GPL-3.0-or-later
#
#
""" A tool for POLAR code channel construction."""

from argparse import ArgumentParser
import gnuradio.fec.polar as cc


def setup_parser():
    """Init the argument parser. If derived classes need to add options,
    override this and call the parent function. """
    parser = ArgumentParser()
    parser.add_argument("-c", "--channel", choices=('BEC', 'AWGN'),
                      help="specify channel, currently BEC or AWGN (default='BEC')",
                      default='BEC')
    parser.add_argument("-b", "--blocksize", type=int, dest="block_size",
                      help="specify block size of polar code (default=16)", default=16)
    parser.add_argument("-s", "--design-snr", type=float, dest="design_snr",
                      help="specify design SNR of polar code (default=0.0)", default=0.0)
    parser.add_argument("-k", "--mu", type=int,
                      help="specify block size of polar code (default=2)", default=2)

    return parser


def main():
    """ Here we go. Parse command, choose class and run. """
    print 'POLAR code channel constructor commandline tool'
    parser = setup_parser()
    args = parser.parse_args()

    z_params = cc.get_z_params(False, args.channel, args.block_size,
            args.design_snr, args.mu)
    print z_params


if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
