c
c  Gmsh - Copyright (C) 1997-2022 C. Geuzaine, J.-F. Remacle
c
c  See the LICENSE.txt file in the Gmsh root directory for license information.
c  Please report all issues on https://gitlab.onelab.info/gmsh/gmsh/issues.
c

!DEC$ IF DEFINED (GMSHF_H)
!DEC$ ELSE
!DEC$ DEFINE GMSHF_H

c
c  This file defines the Gmsh Fortran API (v4.9.4).
c
c  Do not edit this file directly: it is automatically generated by `api/gen.py'.
c
c  By design, the Gmsh Fortran API is purely functional, and only uses elementary
c  Fortran types. See `tutorials/fortran' and `examples/api' for tutorials and
c  examples.
c

!DEC$ DEFINE GMSH_API_VERSION_MAJOR = 4
!DEC$ DEFINE GMSH_API_VERSION_MINOR = 9
!DEC$ DEFINE GMSH_API_VERSION_PATCH = 4

      module gmsh_fortran

        use, intrinsic :: iso_c_binding

        character(len = 5), parameter :: GMSH_API_VERSION = "4.9.4"
        real(c_double), parameter::M_PI = 3.14159265358979323846d0

        interface

!  Initialize the Gmsh API. This must be called before any call to the other
!  functions in the API. If `argc' and `argv' (or just `argv' in Python or
!  Julia) are provided, they will be handled in the same way as the command
!  line arguments in the Gmsh app. If `readConfigFiles' is set, read system
!  Gmsh configuration files (gmshrc and gmsh-options). If `run' is set, run in
!  the same way as the Gmsh app, either interactively or in batch mode
!  depending on the command line arguments. If `run' is not set, initializing
!  the API sets the options "General.AbortOnError" to 2 and "General.Terminal"
!  to 1. If compiled with OpenMP support, it also sets the number of threads
!  to "General.NumThreads".
        subroutine gmshInitialize(
     &      argc,
     &      argv,
     &      readConfigFiles,
     &      run,
     &      ierr)
     &    bind(C, name = "gmshInitialize")
          use, intrinsic :: iso_c_binding
            integer (C_INT), value :: argc
            type (C_PTR)::argv(*)
            integer(c_int), value::readConfigFiles
            integer(c_int), value::run
            integer(c_int)::ierr
          end subroutine gmshInitialize

!  Return 1 if the Gmsh API is initialized, and 0 if not.
        function gmshIsInitialized(
     &      ierr)
     &    bind(C, name = "gmshIsInitialized")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshIsInitialized
            integer(c_int)::ierr
          end function gmshIsInitialized

!  Finalize the Gmsh API. This must be called when you are done using the Gmsh
!  API.
        subroutine gmshFinalize(
     &      ierr)
     &    bind(C, name = "gmshFinalize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshFinalize

!  Open a file. Equivalent to the `File->Open' menu in the Gmsh app. Handling
!  of the file depends on its extension and/or its contents: opening a file
!  with model data will create a new model.
        subroutine gmshOpen(
     &      fileName,
     &      ierr)
     &    bind(C, name = "gmshOpen")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::fileName(*)
            integer(c_int)::ierr
          end subroutine gmshOpen

!  Merge a file. Equivalent to the `File->Merge' menu in the Gmsh app.
!  Handling of the file depends on its extension and/or its contents. Merging
!  a file with model data will add the data to the current model.
        subroutine gmshMerge(
     &      fileName,
     &      ierr)
     &    bind(C, name = "gmshMerge")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::fileName(*)
            integer(c_int)::ierr
          end subroutine gmshMerge

!  Write a file. The export format is determined by the file extension.
        subroutine gmshWrite(
     &      fileName,
     &      ierr)
     &    bind(C, name = "gmshWrite")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::fileName(*)
            integer(c_int)::ierr
          end subroutine gmshWrite

!  Clear all loaded models and post-processing data, and add a new empty
!  model.
        subroutine gmshClear(
     &      ierr)
     &    bind(C, name = "gmshClear")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshClear

!  Set a numerical option to `value'. `name' is of the form "Category.Option"
!  or "Category[num].Option". Available categories and options are listed in
!  the Gmsh reference manual.
        subroutine gmshOptionSetNumber(
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshOptionSetNumber")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            real(c_double), value::value
            integer(c_int)::ierr
          end subroutine gmshOptionSetNumber

!  Get the `value' of a numerical option. `name' is of the form
!  "Category.Option" or "Category[num].Option". Available categories and
!  options are listed in the Gmsh reference manual.
        subroutine gmshOptionGetNumber(
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshOptionGetNumber")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            real(c_double)::value
            integer(c_int)::ierr
          end subroutine gmshOptionGetNumber

!  Set a string option to `value'. `name' is of the form "Category.Option" or
!  "Category[num].Option". Available categories and options are listed in the
!  Gmsh reference manual.
        subroutine gmshOptionSetString(
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshOptionSetString")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            character(len = 1, kind = c_char)::value(*)
            integer(c_int)::ierr
          end subroutine gmshOptionSetString

!  Get the `value' of a string option. `name' is of the form "Category.Option"
!  or "Category[num].Option". Available categories and options are listed in
!  the Gmsh reference manual.
        subroutine gmshOptionGetString(
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshOptionGetString")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr)::value(*)
            integer(c_int)::ierr
          end subroutine gmshOptionGetString

!  Set a color option to the RGBA value (`r', `g', `b', `a'), where where `r',
!  `g', `b' and `a' should be integers between 0 and 255. `name' is of the
!  form "Category.Color.Option" or "Category[num].Color.Option". Available
!  categories and options are listed in the Gmsh reference manual. For
!  conciseness "Color." can be ommitted in `name'.
        subroutine gmshOptionSetColor(
     &      name,
     &      r,
     &      g,
     &      b,
     &      a,
     &      ierr)
     &    bind(C, name = "gmshOptionSetColor")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int), value::r
            integer(c_int), value::g
            integer(c_int), value::b
            integer(c_int), value::a
            integer(c_int)::ierr
          end subroutine gmshOptionSetColor

!  Get the `r', `g', `b', `a' value of a color option. `name' is of the form
!  "Category.Color.Option" or "Category[num].Color.Option". Available
!  categories and options are listed in the Gmsh reference manual. For
!  conciseness "Color." can be ommitted in `name'.
        subroutine gmshOptionGetColor(
     &      name,
     &      r,
     &      g,
     &      b,
     &      a,
     &      ierr)
     &    bind(C, name = "gmshOptionGetColor")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::r
            integer(c_int)::g
            integer(c_int)::b
            integer(c_int)::a
            integer(c_int)::ierr
          end subroutine gmshOptionGetColor

!  Add a new model, with name `name', and set it as the current model.
        subroutine gmshModelAdd(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelAdd")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelAdd

!  Remove the current model.
        subroutine gmshModelRemove(
     &      ierr)
     &    bind(C, name = "gmshModelRemove")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelRemove

!  List the names of all models.
        subroutine gmshModelList(
     &      names,
     &      names_n,
     &      ierr)
     &    bind(C, name = "gmshModelList")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::names
            integer(c_size_t) :: names_n
            integer(c_int)::ierr
          end subroutine gmshModelList

!  Get the name of the current model.
        subroutine gmshModelGetCurrent(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelGetCurrent")
          use, intrinsic :: iso_c_binding
            type(c_ptr)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelGetCurrent

!  Set the current model to the model with name `name'. If several models have
!  the same name, select the one that was added first.
        subroutine gmshModelSetCurrent(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelSetCurrent")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelSetCurrent

!  Get the file name (if any) associated with the current model. A file name
!  is associated when a model is read from a file on disk.
        subroutine gmshModelGetFileName(
     &      fileName,
     &      ierr)
     &    bind(C, name = "gmshModelGetFileName")
          use, intrinsic :: iso_c_binding
            type(c_ptr)::fileName(*)
            integer(c_int)::ierr
          end subroutine gmshModelGetFileName

!  Set the file name associated with the current model.
        subroutine gmshModelSetFileName(
     &      fileName,
     &      ierr)
     &    bind(C, name = "gmshModelSetFileName")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::fileName(*)
            integer(c_int)::ierr
          end subroutine gmshModelSetFileName

!  Get all the entities in the current model. If `dim' is >= 0, return only
!  the entities of the specified dimension (e.g. points if `dim' == 0). The
!  entities are returned as a vector of (dim, tag) integer pairs.
        subroutine gmshModelGetEntities(
     &      dimTags,
     &      dimTags_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelGetEntities")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::dimTags
            integer(c_size_t) :: dimTags_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshModelGetEntities

!  Set the name of the entity of dimension `dim' and tag `tag'.
        subroutine gmshModelSetEntityName(
     &      dim,
     &      tag,
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelSetEntityName")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelSetEntityName

!  Get the name of the entity of dimension `dim' and tag `tag'.
        subroutine gmshModelGetEntityName(
     &      dim,
     &      tag,
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelGetEntityName")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelGetEntityName

!  Get all the physical groups in the current model. If `dim' is >= 0, return
!  only the entities of the specified dimension (e.g. physical points if `dim'
!  == 0). The entities are returned as a vector of (dim, tag) integer pairs.
        subroutine gmshModelGetPhysicalGroups(
     &      dimTags,
     &      dimTags_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelGetPhysicalGroups")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::dimTags
            integer(c_size_t) :: dimTags_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshModelGetPhysicalGroups

!  Get the tags of the model entities making up the physical group of
!  dimension `dim' and tag `tag'.
        subroutine gmshModelGetEntitiesForPhysicalGroup(
     &      dim,
     &      tag,
     &      tags,
     &      tags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetEntitiesForPhysicalGroup")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int)::ierr
          end subroutine gmshModelGetEntitiesForPhysicalGroup

!  Get the tags of the physical groups (if any) to which the model entity of
!  dimension `dim' and tag `tag' belongs.
        subroutine gmshModelGetPhysicalGroupsForEntity(
     &      dim,
     &      tag,
     &      physicalTags,
     &      physicalTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetPhysicalGroupsForEntity")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::physicalTags
            integer(c_size_t) :: physicalTags_n
            integer(c_int)::ierr
          end subroutine gmshModelGetPhysicalGroupsForEntity

!  Add a physical group of dimension `dim', grouping the model entities with
!  tags `tags'. Return the tag of the physical group, equal to `tag' if `tag'
!  is positive, or a new tag if `tag' < 0.
        function gmshModelAddPhysicalGroup(
     &      dim,
     &      tags,
     &      tags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelAddPhysicalGroup")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelAddPhysicalGroup
            integer(c_int), value::dim
            integer(c_int)::tags(*)
            integer(c_size_t), value :: tags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelAddPhysicalGroup

!  Remove the physical groups `dimTags' from the current model. If `dimTags'
!  is empty, remove all groups.
        subroutine gmshModelRemovePhysicalGroups(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelRemovePhysicalGroups")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelRemovePhysicalGroups

!  Set the name of the physical group of dimension `dim' and tag `tag'.
        subroutine gmshModelSetPhysicalName(
     &      dim,
     &      tag,
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelSetPhysicalName")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelSetPhysicalName

!  Remove the physical name `name' from the current model.
        subroutine gmshModelRemovePhysicalName(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelRemovePhysicalName")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelRemovePhysicalName

!  Get the name of the physical group of dimension `dim' and tag `tag'.
        subroutine gmshModelGetPhysicalName(
     &      dim,
     &      tag,
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelGetPhysicalName")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelGetPhysicalName

!  Set the tag of the entity of dimension `dim' and tag `tag' to the new value
!  `newTag'.
        subroutine gmshModelSetTag(
     &      dim,
     &      tag,
     &      newTag,
     &      ierr)
     &    bind(C, name = "gmshModelSetTag")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::newTag
            integer(c_int)::ierr
          end subroutine gmshModelSetTag

!  Get the boundary of the model entities `dimTags'. Return in `outDimTags'
!  the boundary of the individual entities (if `combined' is false) or the
!  boundary of the combined geometrical shape formed by all input entities (if
!  `combined' is true). Return tags multiplied by the sign of the boundary
!  entity if `oriented' is true. Apply the boundary operator recursively down
!  to dimension 0 (i.e. to points) if `recursive' is true.
        subroutine gmshModelGetBoundary(
     &      dimTags,
     &      dimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      combined,
     &      oriented,
     &      recursive,
     &      ierr)
     &    bind(C, name = "gmshModelGetBoundary")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int), value::combined
            integer(c_int), value::oriented
            integer(c_int), value::recursive
            integer(c_int)::ierr
          end subroutine gmshModelGetBoundary

!  Get the upward and downward adjacencies of the model entity of dimension
!  `dim' and tag `tag'. The `upward' vector returns the adjacent entities of
!  dimension `dim' + 1; the `downward' vector returns the adjacent entities of
!  dimension `dim' - 1.
        subroutine gmshModelGetAdjacencies(
     &      dim,
     &      tag,
     &      upward,
     &      upward_n,
     &      downward,
     &      downward_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetAdjacencies")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::upward
            integer(c_size_t) :: upward_n
            type(c_ptr), intent(out)::downward
            integer(c_size_t) :: downward_n
            integer(c_int)::ierr
          end subroutine gmshModelGetAdjacencies

!  Get the model entities in the bounding box defined by the two points
!  (`xmin', `ymin', `zmin') and (`xmax', `ymax', `zmax'). If `dim' is >= 0,
!  return only the entities of the specified dimension (e.g. points if `dim'
!  == 0).
        subroutine gmshModelGetEntitiesInBoundingBox(
     &      xmin,
     &      ymin,
     &      zmin,
     &      xmax,
     &      ymax,
     &      zmax,
     &      tags,
     &      tags_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelGetEntitiesInBoundingBox")
          use, intrinsic :: iso_c_binding
            real(c_double), value::xmin
            real(c_double), value::ymin
            real(c_double), value::zmin
            real(c_double), value::xmax
            real(c_double), value::ymax
            real(c_double), value::zmax
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshModelGetEntitiesInBoundingBox

!  Get the bounding box (`xmin', `ymin', `zmin'), (`xmax', `ymax', `zmax') of
!  the model entity of dimension `dim' and tag `tag'. If `dim' and `tag' are
!  negative, get the bounding box of the whole model.
        subroutine gmshModelGetBoundingBox(
     &      dim,
     &      tag,
     &      xmin,
     &      ymin,
     &      zmin,
     &      xmax,
     &      ymax,
     &      zmax,
     &      ierr)
     &    bind(C, name = "gmshModelGetBoundingBox")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::xmin
            real(c_double)::ymin
            real(c_double)::zmin
            real(c_double)::xmax
            real(c_double)::ymax
            real(c_double)::zmax
            integer(c_int)::ierr
          end subroutine gmshModelGetBoundingBox

!  Return the geometrical dimension of the current model.
        function gmshModelGetDimension(
     &      ierr)
     &    bind(C, name = "gmshModelGetDimension")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGetDimension
            integer(c_int)::ierr
          end function gmshModelGetDimension

!  Add a discrete model entity (defined by a mesh) of dimension `dim' in the
!  current model. Return the tag of the new discrete entity, equal to `tag' if
!  `tag' is positive, or a new tag if `tag' < 0. `boundary' specifies the tags
!  of the entities on the boundary of the discrete entity, if any. Specifying
!  `boundary' allows Gmsh to construct the topology of the overall model.
        function gmshModelAddDiscreteEntity(
     &      dim,
     &      tag,
     &      boundary,
     &      boundary_n,
     &      ierr)
     &    bind(C, name = "gmshModelAddDiscreteEntity")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelAddDiscreteEntity
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::boundary(*)
            integer(c_size_t), value :: boundary_n
            integer(c_int)::ierr
          end function gmshModelAddDiscreteEntity

!  Remove the entities `dimTags' of the current model, provided that they are
!  not on the boundary of (or embedded in) higher-dimensional entities. If
!  `recursive' is true, remove all the entities on their boundaries, down to
!  dimension 0.
        subroutine gmshModelRemoveEntities(
     &      dimTags,
     &      dimTags_n,
     &      recursive,
     &      ierr)
     &    bind(C, name = "gmshModelRemoveEntities")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int), value::recursive
            integer(c_int)::ierr
          end subroutine gmshModelRemoveEntities

!  Remove the entity name `name' from the current model.
        subroutine gmshModelRemoveEntityName(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshModelRemoveEntityName")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshModelRemoveEntityName

!  Get the type of the entity of dimension `dim' and tag `tag'.
        subroutine gmshModelGetType(
     &      dim,
     &      tag,
     &      entityType,
     &      ierr)
     &    bind(C, name = "gmshModelGetType")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr)::entityType(*)
            integer(c_int)::ierr
          end subroutine gmshModelGetType

!  In a partitioned model, get the parent of the entity of dimension `dim' and
!  tag `tag', i.e. from which the entity is a part of, if any. `parentDim' and
!  `parentTag' are set to -1 if the entity has no parent.
        subroutine gmshModelGetParent(
     &      dim,
     &      tag,
     &      parentDim,
     &      parentTag,
     &      ierr)
     &    bind(C, name = "gmshModelGetParent")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::parentDim
            integer(c_int)::parentTag
            integer(c_int)::ierr
          end subroutine gmshModelGetParent

!  Return the number of partitions in the model.
        function gmshModelGetNumberOfPartitions(
     &      ierr)
     &    bind(C, name = "gmshModelGetNumberOfPartitions")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGetNumberOfPartitions
            integer(c_int)::ierr
          end function gmshModelGetNumberOfPartitions

!  In a partitioned model, return the tags of the partition(s) to which the
!  entity belongs.
        subroutine gmshModelGetPartitions(
     &      dim,
     &      tag,
     &      partitions,
     &      partitions_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetPartitions")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::partitions
            integer(c_size_t) :: partitions_n
            integer(c_int)::ierr
          end subroutine gmshModelGetPartitions

!  Evaluate the parametrization of the entity of dimension `dim' and tag `tag'
!  at the parametric coordinates `parametricCoord'. Only valid for `dim' equal
!  to 0 (with empty `parametricCoord'), 1 (with `parametricCoord' containing
!  parametric coordinates on the curve) or 2 (with `parametricCoord'
!  containing pairs of u, v parametric coordinates on the surface,
!  concatenated: [p1u, p1v, p2u, ...]). Return triplets of x, y, z coordinates
!  in `coord', concatenated: [p1x, p1y, p1z, p2x, ...].
        subroutine gmshModelGetValue(
     &      dim,
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      coord,
     &      coord_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetValue")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            integer(c_int)::ierr
          end subroutine gmshModelGetValue

!  Evaluate the derivative of the parametrization of the entity of dimension
!  `dim' and tag `tag' at the parametric coordinates `parametricCoord'. Only
!  valid for `dim' equal to 1 (with `parametricCoord' containing parametric
!  coordinates on the curve) or 2 (with `parametricCoord' containing pairs of
!  u, v parametric coordinates on the surface, concatenated: [p1u, p1v, p2u,
!  ...]). For `dim' equal to 1 return the x, y, z components of the derivative
!  with respect to u [d1ux, d1uy, d1uz, d2ux, ...]; for `dim' equal to 2
!  return the x, y, z components of the derivative with respect to u and v:
!  [d1ux, d1uy, d1uz, d1vx, d1vy, d1vz, d2ux, ...].
        subroutine gmshModelGetDerivative(
     &      dim,
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      derivatives,
     &      derivatives_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetDerivative")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            type(c_ptr), intent(out)::derivatives
            integer(c_size_t) :: derivatives_n
            integer(c_int)::ierr
          end subroutine gmshModelGetDerivative

!  Evaluate the second derivative of the parametrization of the entity of
!  dimension `dim' and tag `tag' at the parametric coordinates
!  `parametricCoord'. Only valid for `dim' equal to 1 (with `parametricCoord'
!  containing parametric coordinates on the curve) or 2 (with
!  `parametricCoord' containing pairs of u, v parametric coordinates on the
!  surface, concatenated: [p1u, p1v, p2u, ...]). For `dim' equal to 1 return
!  the x, y, z components of the second derivative with respect to u [d1uux,
!  d1uuy, d1uuz, d2uux, ...]; for `dim' equal to 2 return the x, y, z
!  components of the second derivative with respect to u and v, and the mixed
!  derivative with respect to u and v: [d1uux, d1uuy, d1uuz, d1vvx, d1vvy,
!  d1vvz, d1uvx, d1uvy, d1uvz, d2uux, ...].
        subroutine gmshModelGetSecondDerivative(
     &      dim,
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      derivatives,
     &      derivatives_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetSecondDerivative")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            type(c_ptr), intent(out)::derivatives
            integer(c_size_t) :: derivatives_n
            integer(c_int)::ierr
          end subroutine gmshModelGetSecondDerivative

!  Evaluate the (maximum) curvature of the entity of dimension `dim' and tag
!  `tag' at the parametric coordinates `parametricCoord'. Only valid for `dim'
!  equal to 1 (with `parametricCoord' containing parametric coordinates on the
!  curve) or 2 (with `parametricCoord' containing pairs of u, v parametric
!  coordinates on the surface, concatenated: [p1u, p1v, p2u, ...]).
        subroutine gmshModelGetCurvature(
     &      dim,
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      curvatures,
     &      curvatures_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetCurvature")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            type(c_ptr), intent(out)::curvatures
            integer(c_size_t) :: curvatures_n
            integer(c_int)::ierr
          end subroutine gmshModelGetCurvature

!  Evaluate the principal curvatures of the surface with tag `tag' at the
!  parametric coordinates `parametricCoord', as well as their respective
!  directions. `parametricCoord' are given by pair of u and v coordinates,
!  concatenated: [p1u, p1v, p2u, ...].
        subroutine gmshModelGetPrincipalCurvatures(
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      curvatureMax,
     &      curvatureMax_n,
     &      curvatureMin,
     &      curvatureMin_n,
     &      directionMax,
     &      directionMax_n,
     &      directionMin,
     &      directionMin_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetPrincipalCurvatures")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            type(c_ptr), intent(out)::curvatureMax
            integer(c_size_t) :: curvatureMax_n
            type(c_ptr), intent(out)::curvatureMin
            integer(c_size_t) :: curvatureMin_n
            type(c_ptr), intent(out)::directionMax
            integer(c_size_t) :: directionMax_n
            type(c_ptr), intent(out)::directionMin
            integer(c_size_t) :: directionMin_n
            integer(c_int)::ierr
          end subroutine gmshModelGetPrincipalCurvatures

!  Get the normal to the surface with tag `tag' at the parametric coordinates
!  `parametricCoord'. `parametricCoord' are given by pairs of u and v
!  coordinates, concatenated: [p1u, p1v, p2u, ...]. `normals' are returned as
!  triplets of x, y, z components, concatenated: [n1x, n1y, n1z, n2x, ...].
        subroutine gmshModelGetNormal(
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      normals,
     &      normals_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetNormal")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            type(c_ptr), intent(out)::normals
            integer(c_size_t) :: normals_n
            integer(c_int)::ierr
          end subroutine gmshModelGetNormal

!  Get the parametric coordinates `parametricCoord' for the points `coord' on
!  the entity of dimension `dim' and tag `tag'. `coord' are given as triplets
!  of x, y, z coordinates, concatenated: [p1x, p1y, p1z, p2x, ...].
!  `parametricCoord' returns the parametric coordinates t on the curve (if
!  `dim' = 1) or pairs of u and v coordinates concatenated on the surface (if
!  `dim' = 2), i.e. [p1t, p2t, ...] or [p1u, p1v, p2u, ...].
        subroutine gmshModelGetParametrization(
     &      dim,
     &      tag,
     &      coord,
     &      coord_n,
     &      parametricCoord,
     &      parametricCoord_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetParametrization")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            type(c_ptr), intent(out)::parametricCoord
            integer(c_size_t) :: parametricCoord_n
            integer(c_int)::ierr
          end subroutine gmshModelGetParametrization

!  Get the `min' and `max' bounds of the parametric coordinates for the entity
!  of dimension `dim' and tag `tag'.
        subroutine gmshModelGetParametrizationBounds(
     &      dim,
     &      tag,
     &      min,
     &      min_n,
     &      max,
     &      max_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetParametrizationBounds")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::min
            integer(c_size_t) :: min_n
            type(c_ptr), intent(out)::max
            integer(c_size_t) :: max_n
            integer(c_int)::ierr
          end subroutine gmshModelGetParametrizationBounds

!  Check if the coordinates (or the parametric coordinates if `parametric' is
!  set) provided in `coord' correspond to points inside the entity of
!  dimension `dim' and tag `tag', and return the number of points inside. This
!  feature is only available for a subset of entities, depending on the
!  underyling geometrical representation.
        function gmshModelIsInside(
     &      dim,
     &      tag,
     &      coord,
     &      coord_n,
     &      parametric,
     &      ierr)
     &    bind(C, name = "gmshModelIsInside")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelIsInside
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            integer(c_int), value::parametric
            integer(c_int)::ierr
          end function gmshModelIsInside

!  Get the points `closestCoord' on the entity of dimension `dim' and tag
!  `tag' to the points `coord', by orthogonal projection. `coord' and
!  `closestCoord' are given as triplets of x, y, z coordinates, concatenated:
!  [p1x, p1y, p1z, p2x, ...]. `parametricCoord' returns the parametric
!  coordinates t on the curve (if `dim' = 1) or pairs of u and v coordinates
!  concatenated on the surface (if `dim' = 2), i.e. [p1t, p2t, ...] or [p1u,
!  p1v, p2u, ...].
        subroutine gmshModelGetClosestPoint(
     &      dim,
     &      tag,
     &      coord,
     &      coord_n,
     &      closestCoord,
     &      closestCoord_n,
     &      parametricCoord,
     &      parametricCoord_n,
     &      ierr)
     &    bind(C, name = "gmshModelGetClosestPoint")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            type(c_ptr), intent(out)::closestCoord
            integer(c_size_t) :: closestCoord_n
            type(c_ptr), intent(out)::parametricCoord
            integer(c_size_t) :: parametricCoord_n
            integer(c_int)::ierr
          end subroutine gmshModelGetClosestPoint

!  Reparametrize the boundary entity (point or curve, i.e. with `dim' == 0 or
!  `dim' == 1) of tag `tag' on the surface `surfaceTag'. If `dim' == 1,
!  reparametrize all the points corresponding to the parametric coordinates
!  `parametricCoord'. Multiple matches in case of periodic surfaces can be
!  selected with `which'. This feature is only available for a subset of
!  entities, depending on the underyling geometrical representation.
        subroutine gmshModelReparametrizeOnSurface(
     &      dim,
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      surfaceTag,
     &      surfaceParametricCoord,
     &      surfaceParametricCoord_n,
     &      which,
     &      ierr)
     &    bind(C, name = "gmshModelReparametrizeOnSurface")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            integer(c_int), value::surfaceTag
            type(c_ptr), intent(out)::surfaceParametricCoord
            integer(c_size_t) :: surfaceParametricCoord_n
            integer(c_int), value::which
            integer(c_int)::ierr
          end subroutine gmshModelReparametrizeOnSurface

!  Set the visibility of the model entities `dimTags' to `value'. Apply the
!  visibility setting recursively if `recursive' is true.
        subroutine gmshModelSetVisibility(
     &      dimTags,
     &      dimTags_n,
     &      value,
     &      recursive,
     &      ierr)
     &    bind(C, name = "gmshModelSetVisibility")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int), value::value
            integer(c_int), value::recursive
            integer(c_int)::ierr
          end subroutine gmshModelSetVisibility

!  Get the visibility of the model entity of dimension `dim' and tag `tag'.
        subroutine gmshModelGetVisibility(
     &      dim,
     &      tag,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshModelGetVisibility")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::value
            integer(c_int)::ierr
          end subroutine gmshModelGetVisibility

!  Set the global visibility of the model per window to `value', where
!  `windowIndex' identifies the window in the window list.
        subroutine gmshModelSetVisibilityPerWindow(
     &      value,
     &      windowIndex,
     &      ierr)
     &    bind(C, name = "gmshModelSetVisibilityPerWindow")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::value
            integer(c_int), value::windowIndex
            integer(c_int)::ierr
          end subroutine gmshModelSetVisibilityPerWindow

!  Set the color of the model entities `dimTags' to the RGBA value (`r', `g',
!  `b', `a'), where `r', `g', `b' and `a' should be integers between 0 and
!  255. Apply the color setting recursively if `recursive' is true.
        subroutine gmshModelSetColor(
     &      dimTags,
     &      dimTags_n,
     &      r,
     &      g,
     &      b,
     &      a,
     &      recursive,
     &      ierr)
     &    bind(C, name = "gmshModelSetColor")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int), value::r
            integer(c_int), value::g
            integer(c_int), value::b
            integer(c_int), value::a
            integer(c_int), value::recursive
            integer(c_int)::ierr
          end subroutine gmshModelSetColor

!  Get the color of the model entity of dimension `dim' and tag `tag'.
        subroutine gmshModelGetColor(
     &      dim,
     &      tag,
     &      r,
     &      g,
     &      b,
     &      a,
     &      ierr)
     &    bind(C, name = "gmshModelGetColor")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::r
            integer(c_int)::g
            integer(c_int)::b
            integer(c_int)::a
            integer(c_int)::ierr
          end subroutine gmshModelGetColor

!  Set the `x', `y', `z' coordinates of a geometrical point.
        subroutine gmshModelSetCoordinates(
     &      tag,
     &      x,
     &      y,
     &      z,
     &      ierr)
     &    bind(C, name = "gmshModelSetCoordinates")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            integer(c_int)::ierr
          end subroutine gmshModelSetCoordinates

!  Generate a mesh of the current model, up to dimension `dim' (0, 1, 2 or 3).
        subroutine gmshModelMeshGenerate(
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGenerate")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshModelMeshGenerate

!  Partition the mesh of the current model into `numPart' partitions.
!  Optionally, `elementTags' and `partitions' can be provided to specify the
!  partition of each element explicitly.
        subroutine gmshModelMeshPartition(
     &      numPart,
     &      elementTags,
     &      elementTags_n,
     &      partitions,
     &      partitions_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshPartition")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::numPart
            integer(c_size_t)::elementTags(*)
            integer(c_size_t), value :: elementTags_n
            integer(c_int)::partitions(*)
            integer(c_size_t), value :: partitions_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshPartition

!  Unpartition the mesh of the current model.
        subroutine gmshModelMeshUnpartition(
     &      ierr)
     &    bind(C, name = "gmshModelMeshUnpartition")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshUnpartition

!  Optimize the mesh of the current model using `method' (empty for default
!  tetrahedral mesh optimizer, "Netgen" for Netgen optimizer, "HighOrder" for
!  direct high-order mesh optimizer, "HighOrderElastic" for high-order elastic
!  smoother, "HighOrderFastCurving" for fast curving algorithm, "Laplace2D"
!  for Laplace smoothing, "Relocate2D" and "Relocate3D" for node relocation).
!  If `force' is set apply the optimization also to discrete entities. If
!  `dimTags' is given, only apply the optimizer to the given entities.
        subroutine gmshModelMeshOptimize(
     &      method,
     &      force,
     &      niter,
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshOptimize")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::method(*)
            integer(c_int), value::force
            integer(c_int), value::niter
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshOptimize

!  Recombine the mesh of the current model.
        subroutine gmshModelMeshRecombine(
     &      ierr)
     &    bind(C, name = "gmshModelMeshRecombine")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshRecombine

!  Refine the mesh of the current model by uniformly splitting the elements.
        subroutine gmshModelMeshRefine(
     &      ierr)
     &    bind(C, name = "gmshModelMeshRefine")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshRefine

!  Set the order of the elements in the mesh of the current model to `order'.
        subroutine gmshModelMeshSetOrder(
     &      order,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetOrder")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::order
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetOrder

!  Get the last entities (if any) where a meshing error occurred. Currently
!  only populated by the new 3D meshing algorithms.
        subroutine gmshModelMeshGetLastEntityError(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetLastEntityError")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::dimTags
            integer(c_size_t) :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetLastEntityError

!  Get the last nodes (if any) where a meshing error occurred. Currently only
!  populated by the new 3D meshing algorithms.
        subroutine gmshModelMeshGetLastNodeError(
     &      nodeTags,
     &      nodeTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetLastNodeError")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetLastNodeError

!  Clear the mesh, i.e. delete all the nodes and elements, for the entities
!  `dimTags'. If `dimTags' is empty, clear the whole mesh. Note that the mesh
!  of an entity can only be cleared if this entity is not on the boundary of
!  another entity with a non-empty mesh.
        subroutine gmshModelMeshClear(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshClear")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshClear

!  Reverse the orientation of the elements in the entities `dimTags'. If
!  `dimTags' is empty, reverse the orientation of the elements in the whole
!  mesh.
        subroutine gmshModelMeshReverse(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshReverse")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshReverse

!  Apply the affine transformation `affineTransform' (16 entries of a 4x4
!  matrix, by row; only the 12 first can be provided for convenience) to the
!  coordinates of the nodes classified on the entities `dimTags'. If `dimTags'
!  is empty, transform all the nodes in the mesh.
        subroutine gmshModelMeshAffineTransform(
     &      affineTransform,
     &      affineTransform_n,
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshAffineTransform")
          use, intrinsic :: iso_c_binding
            real(c_double)::affineTransform(*)
            integer(c_size_t), value :: affineTransform_n
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshAffineTransform

!  Get the nodes classified on the entity of dimension `dim' and tag `tag'. If
!  `tag' < 0, get the nodes for all entities of dimension `dim'. If `dim' and
!  `tag' are negative, get all the nodes in the mesh. `nodeTags' contains the
!  node tags (their unique, strictly positive identification numbers). `coord'
!  is a vector of length 3 times the length of `nodeTags' that contains the x,
!  y, z coordinates of the nodes, concatenated: [n1x, n1y, n1z, n2x, ...]. If
!  `dim' >= 0 and `returnParamtricCoord' is set, `parametricCoord' contains
!  the parametric coordinates ([u1, u2, ...] or [u1, v1, u2, ...]) of the
!  nodes, if available. The length of `parametricCoord' can be 0 or `dim'
!  times the length of `nodeTags'. If `includeBoundary' is set, also return
!  the nodes classified on the boundary of the entity (which will be
!  reparametrized on the entity if `dim' >= 0 in order to compute their
!  parametric coordinates).
        subroutine gmshModelMeshGetNodes(
     &      nodeTags,
     &      nodeTags_n,
     &      coord,
     &      coord_n,
     &      parametricCoord,
     &      parametricCoord_n,
     &      dim,
     &      tag,
     &      includeBoundary,
     &      returnParametricCoord,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetNodes")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            type(c_ptr), intent(out)::parametricCoord
            integer(c_size_t) :: parametricCoord_n
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::includeBoundary
            integer(c_int), value::returnParametricCoord
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetNodes

!  Get the nodes classified on the entity of tag `tag', for all the elements
!  of type `elementType'. The other arguments are treated as in `getNodes'.
        subroutine gmshModelMeshGetNodesByElementType(
     &      elementType,
     &      nodeTags,
     &      nodeTags_n,
     &      coord,
     &      coord_n,
     &      parametricCoord,
     &      parametricCoord_n,
     &      tag,
     &      returnParametricCoord,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetNodesByElementType")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            type(c_ptr), intent(out)::parametricCoord
            integer(c_size_t) :: parametricCoord_n
            integer(c_int), value::tag
            integer(c_int), value::returnParametricCoord
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetNodesByElementType

!  Get the coordinates and the parametric coordinates (if any) of the node
!  with tag `tag', as well as the dimension `dim' and tag `tag' of the entity
!  on which the node is classified. This function relies on an internal cache
!  (a vector in case of dense node numbering, a map otherwise); for large
!  meshes accessing nodes in bulk is often preferable.
        subroutine gmshModelMeshGetNode(
     &      nodeTag,
     &      coord,
     &      coord_n,
     &      parametricCoord,
     &      parametricCoord_n,
     &      dim,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetNode")
          use, intrinsic :: iso_c_binding
            integer(c_size_t), value::nodeTag
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            type(c_ptr), intent(out)::parametricCoord
            integer(c_size_t) :: parametricCoord_n
            integer(c_int)::dim
            integer(c_int)::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetNode

!  Set the coordinates and the parametric coordinates (if any) of the node
!  with tag `tag'. This function relies on an internal cache (a vector in case
!  of dense node numbering, a map otherwise); for large meshes accessing nodes
!  in bulk is often preferable.
        subroutine gmshModelMeshSetNode(
     &      nodeTag,
     &      coord,
     &      coord_n,
     &      parametricCoord,
     &      parametricCoord_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetNode")
          use, intrinsic :: iso_c_binding
            integer(c_size_t), value::nodeTag
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetNode

!  Rebuild the node cache.
        subroutine gmshModelMeshRebuildNodeCache(
     &      onlyIfNecessary,
     &      ierr)
     &    bind(C, name = "gmshModelMeshRebuildNodeCache")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::onlyIfNecessary
            integer(c_int)::ierr
          end subroutine gmshModelMeshRebuildNodeCache

!  Rebuild the element cache.
        subroutine gmshModelMeshRebuildElementCache(
     &      onlyIfNecessary,
     &      ierr)
     &    bind(C, name = "gmshModelMeshRebuildElementCache")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::onlyIfNecessary
            integer(c_int)::ierr
          end subroutine gmshModelMeshRebuildElementCache

!  Get the nodes from all the elements belonging to the physical group of
!  dimension `dim' and tag `tag'. `nodeTags' contains the node tags; `coord'
!  is a vector of length 3 times the length of `nodeTags' that contains the x,
!  y, z coordinates of the nodes, concatenated: [n1x, n1y, n1z, n2x, ...].
        subroutine gmshModelMeshGetNodesForPhysicalGroup(
     &      dim,
     &      tag,
     &      nodeTags,
     &      nodeTags_n,
     &      coord,
     &      coord_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetNodesForPhysicalGroup")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetNodesForPhysicalGroup

!  Get the maximum tag `maxTag' of a node in the mesh.
        subroutine gmshModelMeshGetMaxNodeTag(
     &      maxTag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetMaxNodeTag")
          use, intrinsic :: iso_c_binding
            integer(c_size_t)::maxTag
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetMaxNodeTag

!  Add nodes classified on the model entity of dimension `dim' and tag `tag'.
!  `nodeTags' contains the node tags (their unique, strictly positive
!  identification numbers). `coord' is a vector of length 3 times the length
!  of `nodeTags' that contains the x, y, z coordinates of the nodes,
!  concatenated: [n1x, n1y, n1z, n2x, ...]. The optional `parametricCoord'
!  vector contains the parametric coordinates of the nodes, if any. The length
!  of `parametricCoord' can be 0 or `dim' times the length of `nodeTags'. If
!  the `nodeTags' vector is empty, new tags are automatically assigned to the
!  nodes.
        subroutine gmshModelMeshAddNodes(
     &      dim,
     &      tag,
     &      nodeTags,
     &      nodeTags_n,
     &      coord,
     &      coord_n,
     &      parametricCoord,
     &      parametricCoord_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshAddNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_size_t)::nodeTags(*)
            integer(c_size_t), value :: nodeTags_n
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshAddNodes

!  Reclassify all nodes on their associated model entity, based on the
!  elements. Can be used when importing nodes in bulk (e.g. by associating
!  them all to a single volume), to reclassify them correctly on model
!  surfaces, curves, etc. after the elements have been set.
        subroutine gmshModelMeshReclassifyNodes(
     &      ierr)
     &    bind(C, name = "gmshModelMeshReclassifyNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshReclassifyNodes

!  Relocate the nodes classified on the entity of dimension `dim' and tag
!  `tag' using their parametric coordinates. If `tag' < 0, relocate the nodes
!  for all entities of dimension `dim'. If `dim' and `tag' are negative,
!  relocate all the nodes in the mesh.
        subroutine gmshModelMeshRelocateNodes(
     &      dim,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshRelocateNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshRelocateNodes

!  Get the elements classified on the entity of dimension `dim' and tag `tag'.
!  If `tag' < 0, get the elements for all entities of dimension `dim'. If
!  `dim' and `tag' are negative, get all the elements in the mesh.
!  `elementTypes' contains the MSH types of the elements (e.g. `2' for 3-node
!  triangles: see `getElementProperties' to obtain the properties for a given
!  element type). `elementTags' is a vector of the same length as
!  `elementTypes'; each entry is a vector containing the tags (unique,
!  strictly positive identifiers) of the elements of the corresponding type.
!  `nodeTags' is also a vector of the same length as `elementTypes'; each
!  entry is a vector of length equal to the number of elements of the given
!  type times the number N of nodes for this type of element, that contains
!  the node tags of all the elements of the given type, concatenated: [e1n1,
!  e1n2, ..., e1nN, e2n1, ...].
        subroutine gmshModelMeshGetElements(
     &      elementTypes,
     &      elementTypes_n,
     &      elementTags,
     &      elementTags_n,
     &      elementTags_nn,
     &      nodeTags,
     &      nodeTags_n,
     &      nodeTags_nn,
     &      dim,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElements")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::elementTypes
            integer(c_size_t) :: elementTypes_n
            type (c_ptr), intent(out)::elementTags
            type(c_ptr), intent(out) :: elementTags_n
            integer(c_size_t) :: elementTags_nn
            type (c_ptr), intent(out)::nodeTags
            type(c_ptr), intent(out) :: nodeTags_n
            integer(c_size_t) :: nodeTags_nn
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElements

!  Get the type and node tags of the element with tag `tag', as well as the
!  dimension `dim' and tag `tag' of the entity on which the element is
!  classified. This function relies on an internal cache (a vector in case of
!  dense element numbering, a map otherwise); for large meshes accessing
!  elements in bulk is often preferable.
        subroutine gmshModelMeshGetElement(
     &      elementTag,
     &      elementType,
     &      nodeTags,
     &      nodeTags_n,
     &      dim,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElement")
          use, intrinsic :: iso_c_binding
            integer(c_size_t), value::elementTag
            integer(c_int)::elementType
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            integer(c_int)::dim
            integer(c_int)::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElement

!  Search the mesh for an element located at coordinates (`x', `y', `z'). This
!  function performs a search in a spatial octree. If an element is found,
!  return its tag, type and node tags, as well as the local coordinates (`u',
!  `v', `w') within the reference element corresponding to search location. If
!  `dim' is >= 0, only search for elements of the given dimension. If `strict'
!  is not set, use a tolerance to find elements near the search location.
        subroutine gmshModelMeshGetElementByCoordinates(
     &      x,
     &      y,
     &      z,
     &      elementTag,
     &      elementType,
     &      nodeTags,
     &      nodeTags_n,
     &      u,
     &      v,
     &      w,
     &      dim,
     &      strict,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementByCoordinates")
          use, intrinsic :: iso_c_binding
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            integer(c_size_t)::elementTag
            integer(c_int)::elementType
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            real(c_double)::u
            real(c_double)::v
            real(c_double)::w
            integer(c_int), value::dim
            integer(c_int), value::strict
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElementByCoordinates

!  Search the mesh for element(s) located at coordinates (`x', `y', `z'). This
!  function performs a search in a spatial octree. Return the tags of all
!  found elements in `elementTags'. Additional information about the elements
!  can be accessed through `getElement' and `getLocalCoordinatesInElement'. If
!  `dim' is >= 0, only search for elements of the given dimension. If `strict'
!  is not set, use a tolerance to find elements near the search location.
        subroutine gmshModelMeshGetElementsByCoordinates(
     &      x,
     &      y,
     &      z,
     &      elementTags,
     &      elementTags_n,
     &      dim,
     &      strict,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementsByCoordinates")
          use, intrinsic :: iso_c_binding
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            type(c_ptr), intent(out)::elementTags
            integer(c_size_t) :: elementTags_n
            integer(c_int), value::dim
            integer(c_int), value::strict
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElementsByCoordinates

!  Return the local coordinates (`u', `v', `w') within the element
!  `elementTag' corresponding to the model coordinates (`x', `y', `z'). This
!  function relies on an internal cache (a vector in case of dense element
!  numbering, a map otherwise); for large meshes accessing elements in bulk is
!  often preferable.
        subroutine gmshModelMeshGetLocalCoordinatesInElement(
     &      elementTag,
     &      x,
     &      y,
     &      z,
     &      u,
     &      v,
     &      w,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetLocalCoordinatesInElement")
          use, intrinsic :: iso_c_binding
            integer(c_size_t), value::elementTag
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double)::u
            real(c_double)::v
            real(c_double)::w
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetLocalCoordinatesInElement

!  Get the types of elements in the entity of dimension `dim' and tag `tag'.
!  If `tag' < 0, get the types for all entities of dimension `dim'. If `dim'
!  and `tag' are negative, get all the types in the mesh.
        subroutine gmshModelMeshGetElementTypes(
     &      elementTypes,
     &      elementTypes_n,
     &      dim,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementTypes")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::elementTypes
            integer(c_size_t) :: elementTypes_n
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElementTypes

!  Return an element type given its family name `familyName' ("Point", "Line",
!  "Triangle", "Quadrangle", "Tetrahedron", "Pyramid", "Prism", "Hexahedron")
!  and polynomial order `order'. If `serendip' is true, return the
!  corresponding serendip element type (element without interior nodes).
        function gmshModelMeshGetElementType(
     &      familyName,
     &      order,
     &      serendip,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementType")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelMeshGetElementType
            character(len = 1, kind = c_char)::familyName(*)
            integer(c_int), value::order
            integer(c_int), value::serendip
            integer(c_int)::ierr
          end function gmshModelMeshGetElementType

!  Get the properties of an element of type `elementType': its name
!  (`elementName'), dimension (`dim'), order (`order'), number of nodes
!  (`numNodes'), local coordinates of the nodes in the reference element
!  (`localNodeCoord' vector, of length `dim' times `numNodes') and number of
!  primary (first order) nodes (`numPrimaryNodes').
        subroutine gmshModelMeshGetElementProperties(
     &      elementType,
     &      elementName,
     &      dim,
     &      order,
     &      numNodes,
     &      localNodeCoord,
     &      localNodeCoord_n,
     &      numPrimaryNodes,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementProperties")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            type(c_ptr)::elementName(*)
            integer(c_int)::dim
            integer(c_int)::order
            integer(c_int)::numNodes
            type(c_ptr), intent(out)::localNodeCoord
            integer(c_size_t) :: localNodeCoord_n
            integer(c_int)::numPrimaryNodes
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElementProperties

!  Get the elements of type `elementType' classified on the entity of tag
!  `tag'. If `tag' < 0, get the elements for all entities. `elementTags' is a
!  vector containing the tags (unique, strictly positive identifiers) of the
!  elements of the corresponding type. `nodeTags' is a vector of length equal
!  to the number of elements of the given type times the number N of nodes for
!  this type of element, that contains the node tags of all the elements of
!  the given type, concatenated: [e1n1, e1n2, ..., e1nN, e2n1, ...]. If
!  `numTasks' > 1, only compute and return the part of the data indexed by
!  `task'.
        subroutine gmshModelMeshGetElementsByType(
     &      elementType,
     &      elementTags,
     &      elementTags_n,
     &      nodeTags,
     &      nodeTags_n,
     &      tag,
     &      task,
     &      numTasks,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementsByType")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            type(c_ptr), intent(out)::elementTags
            integer(c_size_t) :: elementTags_n
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            integer(c_int), value::tag
            integer(c_size_t), value::task
            integer(c_size_t), value::numTasks
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElementsByType

!  Get the maximum tag `maxTag' of an element in the mesh.
        subroutine gmshModelMeshGetMaxElementTag(
     &      maxTag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetMaxElementTag")
          use, intrinsic :: iso_c_binding
            integer(c_size_t)::maxTag
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetMaxElementTag

!  Preallocate data before calling `getElementsByType' with `numTasks' > 1.
!  For C and C++ only.
        subroutine gmshModelMeshPreallocateElementsByType(
     &      elementType,
     &      elementTag,
     &      nodeTag,
     &      elementTags,
     &      elementTags_n,
     &      nodeTags,
     &      nodeTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshPreallocateElementsByType")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            integer(c_int), value::elementTag
            integer(c_int), value::nodeTag
            type(c_ptr), intent(out)::elementTags
            integer(c_size_t) :: elementTags_n
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshPreallocateElementsByType

!  Add elements classified on the entity of dimension `dim' and tag `tag'.
!  `types' contains the MSH types of the elements (e.g. `2' for 3-node
!  triangles: see the Gmsh reference manual). `elementTags' is a vector of the
!  same length as `types'; each entry is a vector containing the tags (unique,
!  strictly positive identifiers) of the elements of the corresponding type.
!  `nodeTags' is also a vector of the same length as `types'; each entry is a
!  vector of length equal to the number of elements of the given type times
!  the number N of nodes per element, that contains the node tags of all the
!  elements of the given type, concatenated: [e1n1, e1n2, ..., e1nN, e2n1,
!  ...].
        subroutine gmshModelMeshAddElements(
     &      dim,
     &      tag,
     &      elementTypes,
     &      elementTypes_n,
     &      elementTags,
     &      elementTags_n,
     &      elementTags_nn,
     &      nodeTags,
     &      nodeTags_n,
     &      nodeTags_nn,
     &      ierr)
     &    bind(C, name = "gmshModelMeshAddElements")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::elementTypes(*)
            integer(c_size_t), value :: elementTypes_n
            type(c_ptr), intent(out)::elementTags
            type(c_ptr), intent(out) :: elementTags_n
            integer(c_size_t) :: elementTags_nn
            type(c_ptr), intent(out)::nodeTags
            type(c_ptr), intent(out) :: nodeTags_n
            integer(c_size_t) :: nodeTags_nn
            integer(c_int)::ierr
          end subroutine gmshModelMeshAddElements

!  Add elements of type `elementType' classified on the entity of tag `tag'.
!  `elementTags' contains the tags (unique, strictly positive identifiers) of
!  the elements of the corresponding type. `nodeTags' is a vector of length
!  equal to the number of elements times the number N of nodes per element,
!  that contains the node tags of all the elements, concatenated: [e1n1, e1n2,
!  ..., e1nN, e2n1, ...]. If the `elementTag' vector is empty, new tags are
!  automatically assigned to the elements.
        subroutine gmshModelMeshAddElementsByType(
     &      tag,
     &      elementType,
     &      elementTags,
     &      elementTags_n,
     &      nodeTags,
     &      nodeTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshAddElementsByType")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::elementType
            integer(c_size_t)::elementTags(*)
            integer(c_size_t), value :: elementTags_n
            integer(c_size_t)::nodeTags(*)
            integer(c_size_t), value :: nodeTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshAddElementsByType

!  Get the numerical quadrature information for the given element type
!  `elementType' and integration rule `integrationType', where
!  `integrationType' concatenates the integration rule family name with the
!  desired order (e.g. "Gauss4" for a quadrature suited for integrating 4th
!  order polynomials). The "CompositeGauss" family uses tensor-product rules
!  based the 1D Gauss-Legendre rule; the "Gauss" family uses an economic
!  scheme when available (i.e. with a minimal number of points), and falls
!  back to "CompositeGauss" otherwise. Note that integration points for the
!  "Gauss" family can fall outside of the reference element for high-order
!  rules. `localCoord' contains the u, v, w coordinates of the G integration
!  points in the reference element: [g1u, g1v, g1w, ..., gGu, gGv, gGw].
!  `weights' contains the associated weights: [g1q, ..., gGq].
        subroutine gmshModelMeshGetIntegrationPoints(
     &      elementType,
     &      integrationType,
     &      localCoord,
     &      localCoord_n,
     &      weights,
     &      weights_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetIntegrationPoints")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            character(len = 1, kind = c_char)::integrationType(*)
            type(c_ptr), intent(out)::localCoord
            integer(c_size_t) :: localCoord_n
            type(c_ptr), intent(out)::weights
            integer(c_size_t) :: weights_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetIntegrationPoints

!  Get the Jacobians of all the elements of type `elementType' classified on
!  the entity of tag `tag', at the G evaluation points `localCoord' given as
!  concatenated triplets of coordinates in the reference element [g1u, g1v,
!  g1w, ..., gGu, gGv, gGw]. Data is returned by element, with elements in the
!  same order as in `getElements' and `getElementsByType'. `jacobians'
!  contains for each element the 9 entries of the 3x3 Jacobian matrix at each
!  evaluation point. The matrix is returned by column: [e1g1Jxu, e1g1Jyu,
!  e1g1Jzu, e1g1Jxv, ..., e1g1Jzw, e1g2Jxu, ..., e1gGJzw, e2g1Jxu, ...], with
!  Jxu=dx/du, Jyu=dy/du, etc. `determinants' contains for each element the
!  determinant of the Jacobian matrix at each evaluation point: [e1g1, e1g2,
!  ... e1gG, e2g1, ...]. `coord' contains for each element the x, y, z
!  coordinates of the evaluation points. If `tag' < 0, get the Jacobian data
!  for all entities. If `numTasks' > 1, only compute and return the part of
!  the data indexed by `task'.
        subroutine gmshModelMeshGetJacobians(
     &      elementType,
     &      localCoord,
     &      localCoord_n,
     &      jacobians,
     &      jacobians_n,
     &      determinants,
     &      determinants_n,
     &      coord,
     &      coord_n,
     &      tag,
     &      task,
     &      numTasks,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetJacobians")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            real(c_double)::localCoord(*)
            integer(c_size_t), value :: localCoord_n
            type(c_ptr), intent(out)::jacobians
            integer(c_size_t) :: jacobians_n
            type(c_ptr), intent(out)::determinants
            integer(c_size_t) :: determinants_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            integer(c_int), value::tag
            integer(c_size_t), value::task
            integer(c_size_t), value::numTasks
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetJacobians

!  Preallocate data before calling `getJacobians' with `numTasks' > 1. For C
!  and C++ only.
        subroutine gmshModelMeshPreallocateJacobians(
     &      elementType,
     &      numEvaluationPoints,
     &      allocateJacobians,
     &      allocateDeterminants,
     &      allocateCoord,
     &      jacobians,
     &      jacobians_n,
     &      determinants,
     &      determinants_n,
     &      coord,
     &      coord_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshPreallocateJacobians")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            integer(c_int), value::numEvaluationPoints
            integer(c_int), value::allocateJacobians
            integer(c_int), value::allocateDeterminants
            integer(c_int), value::allocateCoord
            type(c_ptr), intent(out)::jacobians
            integer(c_size_t) :: jacobians_n
            type(c_ptr), intent(out)::determinants
            integer(c_size_t) :: determinants_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshPreallocateJacobians

!  Get the Jacobian for a single element `elementTag', at the G evaluation
!  points `localCoord' given as concatenated triplets of coordinates in the
!  reference element [g1u, g1v, g1w, ..., gGu, gGv, gGw]. `jacobians' contains
!  the 9 entries of the 3x3 Jacobian matrix at each evaluation point. The
!  matrix is returned by column: [e1g1Jxu, e1g1Jyu, e1g1Jzu, e1g1Jxv, ...,
!  e1g1Jzw, e1g2Jxu, ..., e1gGJzw, e2g1Jxu, ...], with Jxu=dx/du, Jyu=dy/du,
!  etc. `determinants' contains the determinant of the Jacobian matrix at each
!  evaluation point. `coord' contains the x, y, z coordinates of the
!  evaluation points. This function relies on an internal cache (a vector in
!  case of dense element numbering, a map otherwise); for large meshes
!  accessing Jacobians in bulk is often preferable.
        subroutine gmshModelMeshGetJacobian(
     &      elementTag,
     &      localCoord,
     &      localCoord_n,
     &      jacobians,
     &      jacobians_n,
     &      determinants,
     &      determinants_n,
     &      coord,
     &      coord_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetJacobian")
          use, intrinsic :: iso_c_binding
            integer(c_size_t), value::elementTag
            real(c_double)::localCoord(*)
            integer(c_size_t), value :: localCoord_n
            type(c_ptr), intent(out)::jacobians
            integer(c_size_t) :: jacobians_n
            type(c_ptr), intent(out)::determinants
            integer(c_size_t) :: determinants_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetJacobian

!  Get the basis functions of the element of type `elementType' at the
!  evaluation points `localCoord' (given as concatenated triplets of
!  coordinates in the reference element [g1u, g1v, g1w, ..., gGu, gGv, gGw]),
!  for the function space `functionSpaceType'. Currently supported function
!  spaces include "Lagrange" and "GradLagrange" for isoparametric Lagrange
!  basis functions and their gradient in the u, v, w coordinates of the
!  reference element; "LagrangeN" and "GradLagrangeN", with N = 1, 2, ..., for
!  N-th order Lagrange basis functions; "H1LegendreN" and "GradH1LegendreN",
!  with N = 1, 2, ..., for N-th order hierarchical H1 Legendre functions;
!  "HcurlLegendreN" and "CurlHcurlLegendreN", with N = 1, 2, ..., for N-th
!  order curl-conforming basis functions. `numComponents' returns the number C
!  of components of a basis function (e.g. 1 for scalar functions and 3 for
!  vector functions). `basisFunctions' returns the value of the N basis
!  functions at the evaluation points, i.e. [g1f1, g1f2, ..., g1fN, g2f1, ...]
!  when C == 1 or [g1f1u, g1f1v, g1f1w, g1f2u, ..., g1fNw, g2f1u, ...] when C
!  == 3. For basis functions that depend on the orientation of the elements,
!  all values for the first orientation are returned first, followed by values
!  for the second, etc. `numOrientations' returns the overall number of
!  orientations. If `wantedOrientations' is not empty, only return the values
!  for the desired orientation indices.
        subroutine gmshModelMeshGetBasisFunctions(
     &      elementType,
     &      localCoord,
     &      localCoord_n,
     &      functionSpaceType,
     &      numComponents,
     &      basisFunctions,
     &      basisFunctions_n,
     &      numOrientations,
     &      wantedOrientations,
     &      wantedOrientations_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetBasisFunctions")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            real(c_double)::localCoord(*)
            integer(c_size_t), value :: localCoord_n
            character(len = 1, kind = c_char)::functionSpaceType(*)
            integer(c_int)::numComponents
            type(c_ptr), intent(out)::basisFunctions
            integer(c_size_t) :: basisFunctions_n
            integer(c_int)::numOrientations
            integer(c_int)::wantedOrientations(*)
            integer(c_size_t), value :: wantedOrientations_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetBasisFunctions

!  Get the orientation index of the elements of type `elementType' in the
!  entity of tag `tag'. The arguments have the same meaning as in
!  `getBasisFunctions'. `basisFunctionsOrientation' is a vector giving for
!  each element the orientation index in the values returned by
!  `getBasisFunctions'. For Lagrange basis functions the call is superfluous
!  as it will return a vector of zeros.
        subroutine gmshModelMeshGetBasisFunctionsOrientation(
     &      elementType,
     &      functionSpaceType,
     &      basisFunctionsOrientation,
     &      basisFunctionsOrientation_n,
     &      tag,
     &      task,
     &      numTasks,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetBasisFunctionsOrientation")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            character(len = 1, kind = c_char)::functionSpaceType(*)
            type(c_ptr), intent(out)::basisFunctionsOrientation
            integer(c_size_t) :: basisFunctionsOrientation_n
            integer(c_int), value::tag
            integer(c_size_t), value::task
            integer(c_size_t), value::numTasks
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetBasisFunctionsOrientation

!  Get the orientation of a single element `elementTag'.

!  Get the number of possible orientations for elements of type `elementType'
!  and function space named `functionSpaceType'.
        function gmshModelMeshGetNumberOfOrientations(
     &      elementType,
     &      functionSpaceType,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetNumberOfOrientations")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelMeshGetNumberOfOrientations
            integer(c_int), value::elementType
            character(len = 1, kind = c_char)::functionSpaceType(*)
            integer(c_int)::ierr
          end function gmshModelMeshGetNumberOfOrientations

!  Preallocate data before calling `getBasisFunctionsOrientation' with
!  `numTasks' > 1. For C and C++ only.

!  Get the global unique mesh edge identifiers `edgeTags' and orientations
!  `edgeOrientation' for an input list of node tag pairs defining these edges,
!  concatenated in the vector `nodeTags'. Mesh edges are created e.g. by
!  `createEdges()', `getKeys()' or `addEdges()'. The reference positive
!  orientation is n1 < n2, where n1 and n2 are the tags of the two edge nodes,
!  which corresponds to the local orientation of edge-based basis functions as
!  well.
        subroutine gmshModelMeshGetEdges(
     &      nodeTags,
     &      nodeTags_n,
     &      edgeTags,
     &      edgeTags_n,
     &      edgeOrientations,
     &      edgeOrientations_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetEdges")
          use, intrinsic :: iso_c_binding
            integer(c_size_t)::nodeTags(*)
            integer(c_size_t), value :: nodeTags_n
            type(c_ptr), intent(out)::edgeTags
            integer(c_size_t) :: edgeTags_n
            type(c_ptr), intent(out)::edgeOrientations
            integer(c_size_t) :: edgeOrientations_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetEdges

!  Get the global unique mesh face identifiers `faceTags' and orientations
!  `faceOrientations' for an input list of node tag triplets (if `faceType' ==
!  3) or quadruplets (if `faceType' == 4) defining these faces, concatenated
!  in the vector `nodeTags'. Mesh faces are created e.g. by `createFaces()',
!  `getKeys()' or `addFaces()'.
        subroutine gmshModelMeshGetFaces(
     &      faceType,
     &      nodeTags,
     &      nodeTags_n,
     &      faceTags,
     &      faceTags_n,
     &      faceOrientations,
     &      faceOrientations_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetFaces")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::faceType
            integer(c_size_t)::nodeTags(*)
            integer(c_size_t), value :: nodeTags_n
            type(c_ptr), intent(out)::faceTags
            integer(c_size_t) :: faceTags_n
            type(c_ptr), intent(out)::faceOrientations
            integer(c_size_t) :: faceOrientations_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetFaces

!  Create unique mesh edges for the entities `dimTags'.
        subroutine gmshModelMeshCreateEdges(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshCreateEdges")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshCreateEdges

!  Create unique mesh faces for the entities `dimTags'.
        subroutine gmshModelMeshCreateFaces(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshCreateFaces")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshCreateFaces

!  Get the global unique identifiers `edgeTags' and the nodes `edgeNodes' of
!  the edges in the mesh. Mesh edges are created e.g. by `createEdges()',
!  `getKeys()' or addEdges().
        subroutine gmshModelMeshGetAllEdges(
     &      edgeTags,
     &      edgeTags_n,
     &      edgeNodes,
     &      edgeNodes_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetAllEdges")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::edgeTags
            integer(c_size_t) :: edgeTags_n
            type(c_ptr), intent(out)::edgeNodes
            integer(c_size_t) :: edgeNodes_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetAllEdges

!  Get the global unique identifiers `faceTags' and the nodes `faceNodes' of
!  the faces of type `faceType' in the mesh. Mesh faces are created e.g. by
!  `createFaces()', `getKeys()' or addFaces().
        subroutine gmshModelMeshGetAllFaces(
     &      faceType,
     &      faceTags,
     &      faceTags_n,
     &      faceNodes,
     &      faceNodes_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetAllFaces")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::faceType
            type(c_ptr), intent(out)::faceTags
            integer(c_size_t) :: faceTags_n
            type(c_ptr), intent(out)::faceNodes
            integer(c_size_t) :: faceNodes_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetAllFaces

!  Add mesh edges defined by their global unique identifiers `edgeTags' and
!  their nodes `edgeNodes'.
        subroutine gmshModelMeshAddEdges(
     &      edgeTags,
     &      edgeTags_n,
     &      edgeNodes,
     &      edgeNodes_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshAddEdges")
          use, intrinsic :: iso_c_binding
            integer(c_size_t)::edgeTags(*)
            integer(c_size_t), value :: edgeTags_n
            integer(c_size_t)::edgeNodes(*)
            integer(c_size_t), value :: edgeNodes_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshAddEdges

!  Add mesh faces of type `faceType' defined by their global unique
!  identifiers `faceTags' and their nodes `faceNodes'.
        subroutine gmshModelMeshAddFaces(
     &      faceType,
     &      faceTags,
     &      faceTags_n,
     &      faceNodes,
     &      faceNodes_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshAddFaces")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::faceType
            integer(c_size_t)::faceTags(*)
            integer(c_size_t), value :: faceTags_n
            integer(c_size_t)::faceNodes(*)
            integer(c_size_t), value :: faceNodes_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshAddFaces

!  Generate the pair of keys for the elements of type `elementType' in the
!  entity of tag `tag', for the `functionSpaceType' function space. Each pair
!  (`typeKey', `entityKey') uniquely identifies a basis function in the
!  function space. If `returnCoord' is set, the `coord' vector contains the x,
!  y, z coordinates locating basis functions for sorting purposes. Warning:
!  this is an experimental feature and will probably change in a future
!  release.
        subroutine gmshModelMeshGetKeys(
     &      elementType,
     &      functionSpaceType,
     &      typeKeys,
     &      typeKeys_n,
     &      entityKeys,
     &      entityKeys_n,
     &      coord,
     &      coord_n,
     &      tag,
     &      returnCoord,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetKeys")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            character(len = 1, kind = c_char)::functionSpaceType(*)
            type(c_ptr), intent(out)::typeKeys
            integer(c_size_t) :: typeKeys_n
            type(c_ptr), intent(out)::entityKeys
            integer(c_size_t) :: entityKeys_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            integer(c_int), value::tag
            integer(c_int), value::returnCoord
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetKeys

!  Get the pair of keys for a single element `elementTag'.
        subroutine gmshModelMeshGetKeysForElement(
     &      elementTag,
     &      functionSpaceType,
     &      typeKeys,
     &      typeKeys_n,
     &      entityKeys,
     &      entityKeys_n,
     &      coord,
     &      coord_n,
     &      returnCoord,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetKeysForElement")
          use, intrinsic :: iso_c_binding
            integer(c_size_t), value::elementTag
            character(len = 1, kind = c_char)::functionSpaceType(*)
            type(c_ptr), intent(out)::typeKeys
            integer(c_size_t) :: typeKeys_n
            type(c_ptr), intent(out)::entityKeys
            integer(c_size_t) :: entityKeys_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            integer(c_int), value::returnCoord
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetKeysForElement

!  Get the number of keys by elements of type `elementType' for function space
!  named `functionSpaceType'.
        function gmshModelMeshGetNumberOfKeys(
     &      elementType,
     &      functionSpaceType,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetNumberOfKeys")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelMeshGetNumberOfKeys
            integer(c_int), value::elementType
            character(len = 1, kind = c_char)::functionSpaceType(*)
            integer(c_int)::ierr
          end function gmshModelMeshGetNumberOfKeys

!  Get information about the pair of `keys'. `infoKeys' returns information
!  about the functions associated with the pairs (`typeKeys', `entityKey').
!  `infoKeys[0].first' describes the type of function (0 for  vertex function,
!  1 for edge function, 2 for face function and 3 for bubble function).
!  `infoKeys[0].second' gives the order of the function associated with the
!  key. Warning: this is an experimental feature and will probably change in a
!  future release.
        subroutine gmshModelMeshGetKeysInformation(
     &      typeKeys,
     &      typeKeys_n,
     &      entityKeys,
     &      entityKeys_n,
     &      elementType,
     &      functionSpaceType,
     &      infoKeys,
     &      infoKeys_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetKeysInformation")
          use, intrinsic :: iso_c_binding
            integer(c_int)::typeKeys(*)
            integer(c_size_t), value :: typeKeys_n
            integer(c_size_t)::entityKeys(*)
            integer(c_size_t), value :: entityKeys_n
            integer(c_int), value::elementType
            character(len = 1, kind = c_char)::functionSpaceType(*)
            type(c_ptr), intent(out)::infoKeys
            integer(c_size_t) :: infoKeys_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetKeysInformation

!  Get the barycenters of all elements of type `elementType' classified on the
!  entity of tag `tag'. If `primary' is set, only the primary nodes of the
!  elements are taken into account for the barycenter calculation. If `fast'
!  is set, the function returns the sum of the primary node coordinates
!  (without normalizing by the number of nodes). If `tag' < 0, get the
!  barycenters for all entities. If `numTasks' > 1, only compute and return
!  the part of the data indexed by `task'.
        subroutine gmshModelMeshGetBarycenters(
     &      elementType,
     &      tag,
     &      fast,
     &      primary,
     &      barycenters,
     &      barycenters_n,
     &      task,
     &      numTasks,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetBarycenters")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            integer(c_int), value::tag
            integer(c_int), value::fast
            integer(c_int), value::primary
            type(c_ptr), intent(out)::barycenters
            integer(c_size_t) :: barycenters_n
            integer(c_size_t), value::task
            integer(c_size_t), value::numTasks
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetBarycenters

!  Preallocate data before calling `getBarycenters' with `numTasks' > 1. For C
!  and C++ only.
        subroutine gmshModelMeshPreallocateBarycenters(
     &      elementType,
     &      barycenters,
     &      barycenters_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshPreallocateBarycenters")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            type(c_ptr), intent(out)::barycenters
            integer(c_size_t) :: barycenters_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshPreallocateBarycenters

!  Get the nodes on the edges of all elements of type `elementType' classified
!  on the entity of tag `tag'. `nodeTags' contains the node tags of the edges
!  for all the elements: [e1a1n1, e1a1n2, e1a2n1, ...]. Data is returned by
!  element, with elements in the same order as in `getElements' and
!  `getElementsByType'. If `primary' is set, only the primary (begin/end)
!  nodes of the edges are returned. If `tag' < 0, get the edge nodes for all
!  entities. If `numTasks' > 1, only compute and return the part of the data
!  indexed by `task'.
        subroutine gmshModelMeshGetElementEdgeNodes(
     &      elementType,
     &      nodeTags,
     &      nodeTags_n,
     &      tag,
     &      primary,
     &      task,
     &      numTasks,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementEdgeNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            integer(c_int), value::tag
            integer(c_int), value::primary
            integer(c_size_t), value::task
            integer(c_size_t), value::numTasks
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElementEdgeNodes

!  Get the nodes on the faces of type `faceType' (3 for triangular faces, 4
!  for quadrangular faces) of all elements of type `elementType' classified on
!  the entity of tag `tag'. `nodeTags' contains the node tags of the faces for
!  all elements: [e1f1n1, ..., e1f1nFaceType, e1f2n1, ...]. Data is returned
!  by element, with elements in the same order as in `getElements' and
!  `getElementsByType'. If `primary' is set, only the primary (corner) nodes
!  of the faces are returned. If `tag' < 0, get the face nodes for all
!  entities. If `numTasks' > 1, only compute and return the part of the data
!  indexed by `task'.
        subroutine gmshModelMeshGetElementFaceNodes(
     &      elementType,
     &      faceType,
     &      nodeTags,
     &      nodeTags_n,
     &      tag,
     &      primary,
     &      task,
     &      numTasks,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetElementFaceNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            integer(c_int), value::faceType
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            integer(c_int), value::tag
            integer(c_int), value::primary
            integer(c_size_t), value::task
            integer(c_size_t), value::numTasks
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetElementFaceNodes

!  Get the ghost elements `elementTags' and their associated `partitions'
!  stored in the ghost entity of dimension `dim' and tag `tag'.
        subroutine gmshModelMeshGetGhostElements(
     &      dim,
     &      tag,
     &      elementTags,
     &      elementTags_n,
     &      partitions,
     &      partitions_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetGhostElements")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::elementTags
            integer(c_size_t) :: elementTags_n
            type(c_ptr), intent(out)::partitions
            integer(c_size_t) :: partitions_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetGhostElements

!  Set a mesh size constraint on the model entities `dimTags'. Currently only
!  entities of dimension 0 (points) are handled.
        subroutine gmshModelMeshSetSize(
     &      dimTags,
     &      dimTags_n,
     &      size,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetSize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::size
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetSize

!  Get the mesh size constraints (if any) associated with the model entities
!  `dimTags'. A zero entry in the output `sizes' vector indicates that no size
!  constraint is specified on the corresponding entity.
        subroutine gmshModelMeshGetSizes(
     &      dimTags,
     &      dimTags_n,
     &      sizes,
     &      sizes_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetSizes")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            type(c_ptr), intent(out)::sizes
            integer(c_size_t) :: sizes_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetSizes

!  Set mesh size constraints at the given parametric points `parametricCoord'
!  on the model entity of dimension `dim' and tag `tag'. Currently only
!  entities of dimension 1 (lines) are handled.
        subroutine gmshModelMeshSetSizeAtParametricPoints(
     &      dim,
     &      tag,
     &      parametricCoord,
     &      parametricCoord_n,
     &      sizes,
     &      sizes_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetSizeAtParametricPoints")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::parametricCoord(*)
            integer(c_size_t), value :: parametricCoord_n
            real(c_double)::sizes(*)
            integer(c_size_t), value :: sizes_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetSizeAtParametricPoints

!  Set a mesh size callback for the current model. The callback function
!  should take six arguments as input (`dim', `tag', `x', `y', `z' and `lc').
!  The first two integer arguments correspond to the dimension `dim' and tag
!  `tag' of the entity being meshed. The next four double precision arguments
!  correspond to the coordinates `x', `y' and `z' around which to prescribe
!  the mesh size and to the mesh size `lc' that would be prescribed if the
!  callback had not been called. The callback function should return a double
!  precision number specifying the desired mesh size; returning `lc' is
!  equivalent to a no-op.
        subroutine gmshModelMeshSetSizeCallback(
     &      callback,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetSizeCallback")
          use, intrinsic :: iso_c_binding
            type (C_FUNPTR)::callback ! to do 
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetSizeCallback

!  Remove the mesh size callback from the current model.
        subroutine gmshModelMeshRemoveSizeCallback(
     &      ierr)
     &    bind(C, name = "gmshModelMeshRemoveSizeCallback")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshRemoveSizeCallback

!  Set a transfinite meshing constraint on the curve `tag', with `numNodes'
!  nodes distributed according to `meshType' and `coef'. Currently supported
!  types are "Progression" (geometrical progression with power `coef'), "Bump"
!  (refinement toward both extremities of the curve) and "Beta" (beta law).
        subroutine gmshModelMeshSetTransfiniteCurve(
     &      tag,
     &      numNodes,
     &      meshType,
     &      coef,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetTransfiniteCurve")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::numNodes
            character(len = 1, kind = c_char)::meshType(*)
            real(c_double), value::coef
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetTransfiniteCurve

!  Set a transfinite meshing constraint on the surface `tag'. `arrangement'
!  describes the arrangement of the triangles when the surface is not flagged
!  as recombined: currently supported values are "Left", "Right",
!  "AlternateLeft" and "AlternateRight". `cornerTags' can be used to specify
!  the (3 or 4) corners of the transfinite interpolation explicitly;
!  specifying the corners explicitly is mandatory if the surface has more that
!  3 or 4 points on its boundary.
        subroutine gmshModelMeshSetTransfiniteSurface(
     &      tag,
     &      arrangement,
     &      cornerTags,
     &      cornerTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetTransfiniteSurface")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::arrangement(*)
            integer(c_int)::cornerTags(*)
            integer(c_size_t), value :: cornerTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetTransfiniteSurface

!  Set a transfinite meshing constraint on the surface `tag'. `cornerTags' can
!  be used to specify the (6 or 8) corners of the transfinite interpolation
!  explicitly.
        subroutine gmshModelMeshSetTransfiniteVolume(
     &      tag,
     &      cornerTags,
     &      cornerTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetTransfiniteVolume")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::cornerTags(*)
            integer(c_size_t), value :: cornerTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetTransfiniteVolume

!  Set transfinite meshing constraints on the model entities in `dimTag'.
!  Transfinite meshing constraints are added to the curves of the quadrangular
!  surfaces and to the faces of 6-sided volumes. Quadragular faces with a
!  corner angle superior to `cornerAngle' (in radians) are ignored. The number
!  of points is automatically determined from the sizing constraints. If
!  `dimTag' is empty, the constraints are applied to all entities in the
!  model. If `recombine' is true, the recombine flag is automatically set on
!  the transfinite surfaces.
        subroutine gmshModelMeshSetTransfiniteAutomatic(
     &      dimTags,
     &      dimTags_n,
     &      cornerAngle,
     &      recombine,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetTransfiniteAutomatic")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::cornerAngle
            integer(c_int), value::recombine
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetTransfiniteAutomatic

!  Set a recombination meshing constraint on the model entity of dimension
!  `dim' and tag `tag'. Currently only entities of dimension 2 (to recombine
!  triangles into quadrangles) are supported.
        subroutine gmshModelMeshSetRecombine(
     &      dim,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetRecombine")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetRecombine

!  Set a smoothing meshing constraint on the model entity of dimension `dim'
!  and tag `tag'. `val' iterations of a Laplace smoother are applied.
        subroutine gmshModelMeshSetSmoothing(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetSmoothing")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetSmoothing

!  Set a reverse meshing constraint on the model entity of dimension `dim' and
!  tag `tag'. If `val' is true, the mesh orientation will be reversed with
!  respect to the natural mesh orientation (i.e. the orientation consistent
!  with the orientation of the geometry). If `val' is false, the mesh is left
!  as-is.
        subroutine gmshModelMeshSetReverse(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetReverse")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetReverse

!  Set the meshing algorithm on the model entity of dimension `dim' and tag
!  `tag'. Currently only supported for `dim' == 2.
        subroutine gmshModelMeshSetAlgorithm(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetAlgorithm")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetAlgorithm

!  Force the mesh size to be extended from the boundary, or not, for the model
!  entity of dimension `dim' and tag `tag'. Currently only supported for `dim'
!  == 2.
        subroutine gmshModelMeshSetSizeFromBoundary(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetSizeFromBoundary")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetSizeFromBoundary

!  Set a compound meshing constraint on the model entities of dimension `dim'
!  and tags `tags'. During meshing, compound entities are treated as a single
!  discrete entity, which is automatically reparametrized.
        subroutine gmshModelMeshSetCompound(
     &      dim,
     &      tags,
     &      tags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetCompound")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int)::tags(*)
            integer(c_size_t), value :: tags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetCompound

!  Set meshing constraints on the bounding surfaces of the volume of tag `tag'
!  so that all surfaces are oriented with outward pointing normals; and if a
!  mesh already exists, reorient it. Currently only available with the
!  OpenCASCADE kernel, as it relies on the STL triangulation.
        subroutine gmshModelMeshSetOutwardOrientation(
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetOutwardOrientation")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetOutwardOrientation

!  Remove all meshing constraints from the model entities `dimTags'. If
!  `dimTags' is empty, remove all constraings.
        subroutine gmshModelMeshRemoveConstraints(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshRemoveConstraints")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshRemoveConstraints

!  Embed the model entities of dimension `dim' and tags `tags' in the
!  (`inDim', `inTag') model entity. The dimension `dim' can 0, 1 or 2 and must
!  be strictly smaller than `inDim', which must be either 2 or 3. The embedded
!  entities should not intersect each other or be part of the boundary of the
!  entity `inTag', whose mesh will conform to the mesh of the embedded
!  entities. With the OpenCASCADE kernel, if the `fragment' operation is
!  applied to entities of different dimensions, the lower dimensional entities
!  will be automatically embedded in the higher dimensional entities if they
!  are not on their boundary.
        subroutine gmshModelMeshEmbed(
     &      dim,
     &      tags,
     &      tags_n,
     &      inDim,
     &      inTag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshEmbed")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int)::tags(*)
            integer(c_size_t), value :: tags_n
            integer(c_int), value::inDim
            integer(c_int), value::inTag
            integer(c_int)::ierr
          end subroutine gmshModelMeshEmbed

!  Remove embedded entities from the model entities `dimTags'. if `dim' is >=
!  0, only remove embedded entities of the given dimension (e.g. embedded
!  points if `dim' == 0).
        subroutine gmshModelMeshRemoveEmbedded(
     &      dimTags,
     &      dimTags_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelMeshRemoveEmbedded")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshModelMeshRemoveEmbedded

!  Get the entities (if any) embedded in the model entity of dimension `dim'
!  and tag `tag'.
        subroutine gmshModelMeshGetEmbedded(
     &      dim,
     &      tag,
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetEmbedded")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::dimTags
            integer(c_size_t) :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetEmbedded

!  Reorder the elements of type `elementType' classified on the entity of tag
!  `tag' according to `ordering'.
        subroutine gmshModelMeshReorderElements(
     &      elementType,
     &      tag,
     &      ordering,
     &      ordering_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshReorderElements")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            integer(c_int), value::tag
            integer(c_size_t)::ordering(*)
            integer(c_size_t), value :: ordering_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshReorderElements

!  Renumber the node tags in a continuous sequence.
        subroutine gmshModelMeshRenumberNodes(
     &      ierr)
     &    bind(C, name = "gmshModelMeshRenumberNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshRenumberNodes

!  Renumber the element tags in a continuous sequence.
        subroutine gmshModelMeshRenumberElements(
     &      ierr)
     &    bind(C, name = "gmshModelMeshRenumberElements")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshRenumberElements

!  Set the meshes of the entities of dimension `dim' and tag `tags' as
!  periodic copies of the meshes of entities `tagsMaster', using the affine
!  transformation specified in `affineTransformation' (16 entries of a 4x4
!  matrix, by row). If used after meshing, generate the periodic node
!  correspondence information assuming the meshes of entities `tags'
!  effectively match the meshes of entities `tagsMaster' (useful for
!  structured and extruded meshes). Currently only available for @code{dim} ==
!  1 and @code{dim} == 2.
        subroutine gmshModelMeshSetPeriodic(
     &      dim,
     &      tags,
     &      tags_n,
     &      tagsMaster,
     &      tagsMaster_n,
     &      affineTransform,
     &      affineTransform_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSetPeriodic")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int)::tags(*)
            integer(c_size_t), value :: tags_n
            integer(c_int)::tagsMaster(*)
            integer(c_size_t), value :: tagsMaster_n
            real(c_double)::affineTransform(*)
            integer(c_size_t), value :: affineTransform_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshSetPeriodic

!  Get master entities `tagsMaster' for the entities of dimension `dim' and
!  tags `tags'.
        subroutine gmshModelMeshGetPeriodic(
     &      dim,
     &      tags,
     &      tags_n,
     &      tagMaster,
     &      tagMaster_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetPeriodic")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int)::tags(*)
            integer(c_size_t), value :: tags_n
            type(c_ptr), intent(out)::tagMaster
            integer(c_size_t) :: tagMaster_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetPeriodic

!  Get the master entity `tagMaster', the node tags `nodeTags' and their
!  corresponding master node tags `nodeTagsMaster', and the affine transform
!  `affineTransform' for the entity of dimension `dim' and tag `tag'. If
!  `includeHighOrderNodes' is set, include high-order nodes in the returned
!  data.
        subroutine gmshModelMeshGetPeriodicNodes(
     &      dim,
     &      tag,
     &      tagMaster,
     &      nodeTags,
     &      nodeTags_n,
     &      nodeTagsMaster,
     &      nodeTagsMaster_n,
     &      affineTransform,
     &      affineTransform_n,
     &      includeHighOrderNodes,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetPeriodicNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::tagMaster
            type(c_ptr), intent(out)::nodeTags
            integer(c_size_t) :: nodeTags_n
            type(c_ptr), intent(out)::nodeTagsMaster
            integer(c_size_t) :: nodeTagsMaster_n
            type(c_ptr), intent(out)::affineTransform
            integer(c_size_t) :: affineTransform_n
            integer(c_int), value::includeHighOrderNodes
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetPeriodicNodes

!  Get the master entity `tagMaster' and the key pairs (`typeKeyMaster',
!  `entityKeyMaster') corresponding to the entity `tag' and the key pairs
!  (`typeKey', `entityKey') for the elements of type `elementType' and
!  function space type `functionSpaceType'. If `returnCoord' is set, the
!  `coord' and `coordMaster' vectors contain the x, y, z coordinates locating
!  basis functions for sorting purposes.
        subroutine gmshModelMeshGetPeriodicKeys(
     &      elementType,
     &      functionSpaceType,
     &      tag,
     &      tagMaster,
     &      typeKeys,
     &      typeKeys_n,
     &      typeKeysMaster,
     &      typeKeysMaster_n,
     &      entityKeys,
     &      entityKeys_n,
     &      entityKeysMaster,
     &      entityKeysMaster_n,
     &      coord,
     &      coord_n,
     &      coordMaster,
     &      coordMaster_n,
     &      returnCoord,
     &      ierr)
     &    bind(C, name = "gmshModelMeshGetPeriodicKeys")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::elementType
            character(len = 1, kind = c_char)::functionSpaceType(*)
            integer(c_int), value::tag
            integer(c_int)::tagMaster
            type(c_ptr), intent(out)::typeKeys
            integer(c_size_t) :: typeKeys_n
            type(c_ptr), intent(out)::typeKeysMaster
            integer(c_size_t) :: typeKeysMaster_n
            type(c_ptr), intent(out)::entityKeys
            integer(c_size_t) :: entityKeys_n
            type(c_ptr), intent(out)::entityKeysMaster
            integer(c_size_t) :: entityKeysMaster_n
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            type(c_ptr), intent(out)::coordMaster
            integer(c_size_t) :: coordMaster_n
            integer(c_int), value::returnCoord
            integer(c_int)::ierr
          end subroutine gmshModelMeshGetPeriodicKeys

!  Import the model STL representation (if available) as the current mesh.
        subroutine gmshModelMeshImportStl(
     &      ierr)
     &    bind(C, name = "gmshModelMeshImportStl")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshImportStl

!  Remove duplicate nodes in the mesh of the current model.
        subroutine gmshModelMeshRemoveDuplicateNodes(
     &      ierr)
     &    bind(C, name = "gmshModelMeshRemoveDuplicateNodes")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelMeshRemoveDuplicateNodes

!  Split (into two triangles) all quadrangles in surface `tag' whose quality
!  is lower than `quality'. If `tag' < 0, split quadrangles in all surfaces.
        subroutine gmshModelMeshSplitQuadrangles(
     &      quality,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshSplitQuadrangles")
          use, intrinsic :: iso_c_binding
            real(c_double), value::quality
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshSplitQuadrangles

!  Classify ("color") the surface mesh based on the angle threshold `angle'
!  (in radians), and create new discrete surfaces, curves and points
!  accordingly. If `boundary' is set, also create discrete curves on the
!  boundary if the surface is open. If `forReparametrization' is set, create
!  curves and surfaces that can be reparametrized using a single map. If
!  `curveAngle' is less than Pi, also force curves to be split according to
!  `curveAngle'. If `exportDiscrete' is set, clear any built-in CAD kernel
!  entities and export the discrete entities in the built-in CAD kernel.
        subroutine gmshModelMeshClassifySurfaces(
     &      angle,
     &      boundary,
     &      forReparametrization,
     &      curveAngle,
     &      exportDiscrete,
     &      ierr)
     &    bind(C, name = "gmshModelMeshClassifySurfaces")
          use, intrinsic :: iso_c_binding
            real(c_double), value::angle
            integer(c_int), value::boundary
            integer(c_int), value::forReparametrization
            real(c_double), value::curveAngle
            integer(c_int), value::exportDiscrete
            integer(c_int)::ierr
          end subroutine gmshModelMeshClassifySurfaces

!  Create a geometry for the discrete entities `dimTags' (represented solely
!  by a mesh, without an underlying CAD description), i.e. create a
!  parametrization for discrete curves and surfaces, assuming that each can be
!  parametrized with a single map. If `dimTags' is empty, create a geometry
!  for all the discrete entities.
        subroutine gmshModelMeshCreateGeometry(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshCreateGeometry")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshCreateGeometry

!  Create a boundary representation from the mesh if the model does not have
!  one (e.g. when imported from mesh file formats with no BRep representation
!  of the underlying model). If `makeSimplyConnected' is set, enforce simply
!  connected discrete surfaces and volumes. If `exportDiscrete' is set, clear
!  any built-in CAD kernel entities and export the discrete entities in the
!  built-in CAD kernel.
        subroutine gmshModelMeshCreateTopology(
     &      makeSimplyConnected,
     &      exportDiscrete,
     &      ierr)
     &    bind(C, name = "gmshModelMeshCreateTopology")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::makeSimplyConnected
            integer(c_int), value::exportDiscrete
            integer(c_int)::ierr
          end subroutine gmshModelMeshCreateTopology

!  Compute a basis representation for homology spaces after a mesh has been
!  generated. The computation domain is given in a list of physical group tags
!  `domainTags'; if empty, the whole mesh is the domain. The computation
!  subdomain for relative homology computation is given in a list of physical
!  group tags `subdomainTags'; if empty, absolute homology is computed. The
!  dimensions homology bases to be computed are given in the list `dim'; if
!  empty, all bases are computed. Resulting basis representation chains are
!  stored as physical groups in the mesh.
        subroutine gmshModelMeshComputeHomology(
     &      domainTags,
     &      domainTags_n,
     &      subdomainTags,
     &      subdomainTags_n,
     &      dims,
     &      dims_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshComputeHomology")
          use, intrinsic :: iso_c_binding
            integer(c_int)::domainTags(*)
            integer(c_size_t), value :: domainTags_n
            integer(c_int)::subdomainTags(*)
            integer(c_size_t), value :: subdomainTags_n
            integer(c_int)::dims(*)
            integer(c_size_t), value :: dims_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshComputeHomology

!  Compute a basis representation for cohomology spaces after a mesh has been
!  generated. The computation domain is given in a list of physical group tags
!  `domainTags'; if empty, the whole mesh is the domain. The computation
!  subdomain for relative cohomology computation is given in a list of
!  physical group tags `subdomainTags'; if empty, absolute cohomology is
!  computed. The dimensions homology bases to be computed are given in the
!  list `dim'; if empty, all bases are computed. Resulting basis
!  representation cochains are stored as physical groups in the mesh.
        subroutine gmshModelMeshComputeCohomology(
     &      domainTags,
     &      domainTags_n,
     &      subdomainTags,
     &      subdomainTags_n,
     &      dims,
     &      dims_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshComputeCohomology")
          use, intrinsic :: iso_c_binding
            integer(c_int)::domainTags(*)
            integer(c_size_t), value :: domainTags_n
            integer(c_int)::subdomainTags(*)
            integer(c_size_t), value :: subdomainTags_n
            integer(c_int)::dims(*)
            integer(c_size_t), value :: dims_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshComputeCohomology

!  Compute a cross field for the current mesh. The function creates 3 views:
!  the H function, the Theta function and cross directions. Return the tags of
!  the views.
        subroutine gmshModelMeshComputeCrossField(
     &      viewTags,
     &      viewTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshComputeCrossField")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::viewTags
            integer(c_size_t) :: viewTags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshComputeCrossField

!  Triangulate the points given in the `coord' vector as pairs of u, v
!  coordinates, and return the node tags (with numbering starting at 1) of the
!  resulting triangles in `tri'.
        subroutine gmshModelMeshTriangulate(
     &      coord,
     &      coord_n,
     &      tri,
     &      tri_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshTriangulate")
          use, intrinsic :: iso_c_binding
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            type(c_ptr), intent(out)::tri
            integer(c_size_t) :: tri_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshTriangulate

!  Tetrahedralize the points given in the `coord' vector as triplets of x, y,
!  z coordinates, and return the node tags (with numbering starting at 1) of
!  the resulting tetrahedra in `tetra'.
        subroutine gmshModelMeshTetrahedralize(
     &      coord,
     &      coord_n,
     &      tetra,
     &      tetra_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshTetrahedralize")
          use, intrinsic :: iso_c_binding
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            type(c_ptr), intent(out)::tetra
            integer(c_size_t) :: tetra_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshTetrahedralize

!  Add a new mesh size field of type `fieldType'. If `tag' is positive, assign
!  the tag explicitly; otherwise a new tag is assigned automatically. Return
!  the field tag.
        function gmshModelMeshFieldAdd(
     &      fieldType,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldAdd")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelMeshFieldAdd
            character(len = 1, kind = c_char)::fieldType(*)
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelMeshFieldAdd

!  Remove the field with tag `tag'.
        subroutine gmshModelMeshFieldRemove(
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldRemove")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldRemove

!  Get the list of all fields.
        subroutine gmshModelMeshFieldList(
     &      tags,
     &      tags_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldList")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldList

!  Get the type `fieldType' of the field with tag `tag'.
        subroutine gmshModelMeshFieldGetType(
     &      tag,
     &      fileType,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldGetType")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            type(c_ptr)::fileType(*)
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldGetType

!  Set the numerical option `option' to value `value' for field `tag'.
        subroutine gmshModelMeshFieldSetNumber(
     &      tag,
     &      option,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldSetNumber")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::option(*)
            real(c_double), value::value
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldSetNumber

!  Get the value of the numerical option `option' for field `tag'.
        subroutine gmshModelMeshFieldGetNumber(
     &      tag,
     &      option,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldGetNumber")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::option(*)
            real(c_double)::value
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldGetNumber

!  Set the string option `option' to value `value' for field `tag'.
        subroutine gmshModelMeshFieldSetString(
     &      tag,
     &      option,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldSetString")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::option(*)
            character(len = 1, kind = c_char)::value(*)
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldSetString

!  Get the value of the string option `option' for field `tag'.
        subroutine gmshModelMeshFieldGetString(
     &      tag,
     &      option,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldGetString")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::option(*)
            type(c_ptr)::value(*)
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldGetString

!  Set the numerical list option `option' to value `value' for field `tag'.
        subroutine gmshModelMeshFieldSetNumbers(
     &      tag,
     &      option,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldSetNumbers")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::option(*)
            real(c_double)::value(*)
            integer(c_size_t), value :: value_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldSetNumbers

!  Get the value of the numerical list option `option' for field `tag'.
        subroutine gmshModelMeshFieldGetNumbers(
     &      tag,
     &      option,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldGetNumbers")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::option(*)
            type(c_ptr), intent(out)::value
            integer(c_size_t) :: value_n
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldGetNumbers

!  Set the field `tag' as the background mesh size field.
        subroutine gmshModelMeshFieldSetAsBackgroundMesh(
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldSetAsBackgroundMesh")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldSetAsBackgroundMesh

!  Set the field `tag' as a boundary layer size field.
        subroutine gmshModelMeshFieldSetAsBoundaryLayer(
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelMeshFieldSetAsBoundaryLayer")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelMeshFieldSetAsBoundaryLayer

!  Add a geometrical point in the built-in CAD representation, at coordinates
!  (`x', `y', `z'). If `meshSize' is > 0, add a meshing constraint at that
!  point. If `tag' is positive, set the tag explicitly; otherwise a new tag is
!  selected automatically. Return the tag of the point. (Note that the point
!  will be added in the current model only after `synchronize' is called. This
!  behavior holds for all the entities added in the geo module.)
        function gmshModelGeoAddPoint(
     &      x,
     &      y,
     &      z,
     &      meshSize,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddPoint")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddPoint
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::meshSize
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddPoint

!  Add a straight line segment in the built-in CAD representation, between the
!  two points with tags `startTag' and `endTag'. If `tag' is positive, set the
!  tag explicitly; otherwise a new tag is selected automatically. Return the
!  tag of the line.
        function gmshModelGeoAddLine(
     &      startTag,
     &      endTag,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddLine")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddLine
            integer(c_int), value::startTag
            integer(c_int), value::endTag
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddLine

!  Add a circle arc (strictly smaller than Pi) in the built-in CAD
!  representation, between the two points with tags `startTag' and `endTag',
!  and with center `centerTag'. If `tag' is positive, set the tag explicitly;
!  otherwise a new tag is selected automatically. If (`nx', `ny', `nz') != (0,
!  0, 0), explicitly set the plane of the circle arc. Return the tag of the
!  circle arc.
        function gmshModelGeoAddCircleArc(
     &      startTag,
     &      centerTag,
     &      endTag,
     &      tag,
     &      nx,
     &      ny,
     &      nz,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddCircleArc")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddCircleArc
            integer(c_int), value::startTag
            integer(c_int), value::centerTag
            integer(c_int), value::endTag
            integer(c_int), value::tag
            real(c_double), value::nx
            real(c_double), value::ny
            real(c_double), value::nz
            integer(c_int)::ierr
          end function gmshModelGeoAddCircleArc

!  Add an ellipse arc (strictly smaller than Pi) in the built-in CAD
!  representation, between the two points `startTag' and `endTag', and with
!  center `centerTag' and major axis point `majorTag'. If `tag' is positive,
!  set the tag explicitly; otherwise a new tag is selected automatically. If
!  (`nx', `ny', `nz') != (0, 0, 0), explicitly set the plane of the circle
!  arc. Return the tag of the ellipse arc.
        function gmshModelGeoAddEllipseArc(
     &      startTag,
     &      centerTag,
     &      majorTag,
     &      endTag,
     &      tag,
     &      nx,
     &      ny,
     &      nz,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddEllipseArc")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddEllipseArc
            integer(c_int), value::startTag
            integer(c_int), value::centerTag
            integer(c_int), value::majorTag
            integer(c_int), value::endTag
            integer(c_int), value::tag
            real(c_double), value::nx
            real(c_double), value::ny
            real(c_double), value::nz
            integer(c_int)::ierr
          end function gmshModelGeoAddEllipseArc

!  Add a spline (Catmull-Rom) curve in the built-in CAD representation, going
!  through the points `pointTags'. If `tag' is positive, set the tag
!  explicitly; otherwise a new tag is selected automatically. Create a
!  periodic curve if the first and last points are the same. Return the tag of
!  the spline curve.
        function gmshModelGeoAddSpline(
     &      pointTags,
     &      pointTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddSpline")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddSpline
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddSpline

!  Add a cubic b-spline curve in the built-in CAD representation, with
!  `pointTags' control points. If `tag' is positive, set the tag explicitly;
!  otherwise a new tag is selected automatically. Creates a periodic curve if
!  the first and last points are the same. Return the tag of the b-spline
!  curve.
        function gmshModelGeoAddBSpline(
     &      pointTags,
     &      pointTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddBSpline")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddBSpline
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddBSpline

!  Add a Bezier curve in the built-in CAD representation, with `pointTags'
!  control points. If `tag' is positive, set the tag explicitly; otherwise a
!  new tag is selected automatically.  Return the tag of the Bezier curve.
        function gmshModelGeoAddBezier(
     &      pointTags,
     &      pointTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddBezier")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddBezier
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddBezier

!  Add a polyline curve in the built-in CAD representation, going through the
!  points `pointTags'. If `tag' is positive, set the tag explicitly; otherwise
!  a new tag is selected automatically. Create a periodic curve if the first
!  and last points are the same. Return the tag of the polyline curve.
        function gmshModelGeoAddPolyline(
     &      pointTags,
     &      pointTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddPolyline")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddPolyline
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddPolyline

!  Add a spline (Catmull-Rom) curve in the built-in CAD representation, going
!  through points sampling the curves in `curveTags'. The density of sampling
!  points on each curve is governed by `numIntervals'. If `tag' is positive,
!  set the tag explicitly; otherwise a new tag is selected automatically.
!  Return the tag of the spline.
        function gmshModelGeoAddCompoundSpline(
     &      curveTags,
     &      curveTags_n,
     &      numIntervals,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddCompoundSpline")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddCompoundSpline
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            integer(c_int), value::numIntervals
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddCompoundSpline

!  Add a b-spline curve in the built-in CAD representation, with control
!  points sampling the curves in `curveTags'. The density of sampling points
!  on each curve is governed by `numIntervals'. If `tag' is positive, set the
!  tag explicitly; otherwise a new tag is selected automatically. Return the
!  tag of the b-spline.
        function gmshModelGeoAddCompoundBSpline(
     &      curveTags,
     &      curveTags_n,
     &      numIntervals,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddCompoundBSpline")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddCompoundBSpline
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            integer(c_int), value::numIntervals
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddCompoundBSpline

!  Add a curve loop (a closed wire) in the built-in CAD representation, formed
!  by the curves `curveTags'. `curveTags' should contain (signed) tags of
!  model entities of dimension 1 forming a closed loop: a negative tag
!  signifies that the underlying curve is considered with reversed
!  orientation. If `tag' is positive, set the tag explicitly; otherwise a new
!  tag is selected automatically. If `reorient' is set, automatically reorient
!  the curves if necessary. Return the tag of the curve loop.
        function gmshModelGeoAddCurveLoop(
     &      curveTags,
     &      curveTags_n,
     &      tag,
     &      reorient,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddCurveLoop")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddCurveLoop
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            integer(c_int), value::tag
            integer(c_int), value::reorient
            integer(c_int)::ierr
          end function gmshModelGeoAddCurveLoop

!  Add curve loops in the built-in CAD representation based on the curves
!  `curveTags'. Return the `tags' of found curve loops, if any.
        subroutine gmshModelGeoAddCurveLoops(
     &      curveTags,
     &      curveTags_n,
     &      tags,
     &      tags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddCurveLoops")
          use, intrinsic :: iso_c_binding
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int)::ierr
          end subroutine gmshModelGeoAddCurveLoops

!  Add a plane surface in the built-in CAD representation, defined by one or
!  more curve loops `wireTags'. The first curve loop defines the exterior
!  contour; additional curve loop define holes. If `tag' is positive, set the
!  tag explicitly; otherwise a new tag is selected automatically. Return the
!  tag of the surface.
        function gmshModelGeoAddPlaneSurface(
     &      wireTags,
     &      wireTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddPlaneSurface")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddPlaneSurface
            integer(c_int)::wireTags(*)
            integer(c_size_t), value :: wireTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddPlaneSurface

!  Add a surface in the built-in CAD representation, filling the curve loops
!  in `wireTags' using transfinite interpolation. Currently only a single
!  curve loop is supported; this curve loop should be composed by 3 or 4
!  curves only. If `tag' is positive, set the tag explicitly; otherwise a new
!  tag is selected automatically. Return the tag of the surface.
        function gmshModelGeoAddSurfaceFilling(
     &      wireTags,
     &      wireTags_n,
     &      tag,
     &      sphereCenterTag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddSurfaceFilling")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddSurfaceFilling
            integer(c_int)::wireTags(*)
            integer(c_size_t), value :: wireTags_n
            integer(c_int), value::tag
            integer(c_int), value::sphereCenterTag
            integer(c_int)::ierr
          end function gmshModelGeoAddSurfaceFilling

!  Add a surface loop (a closed shell) formed by `surfaceTags' in the built-in
!  CAD representation.  If `tag' is positive, set the tag explicitly;
!  otherwise a new tag is selected automatically. Return the tag of the shell.
        function gmshModelGeoAddSurfaceLoop(
     &      surfaceTags,
     &      surfaceTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddSurfaceLoop")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddSurfaceLoop
            integer(c_int)::surfaceTags(*)
            integer(c_size_t), value :: surfaceTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddSurfaceLoop

!  Add a volume (a region) in the built-in CAD representation, defined by one
!  or more shells `shellTags'. The first surface loop defines the exterior
!  boundary; additional surface loop define holes. If `tag' is positive, set
!  the tag explicitly; otherwise a new tag is selected automatically. Return
!  the tag of the volume.
        function gmshModelGeoAddVolume(
     &      shellTags,
     &      shellTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddVolume")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddVolume
            integer(c_int)::shellTags(*)
            integer(c_size_t), value :: shellTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddVolume

!  Extrude the entities `dimTags' in the built-in CAD representation, using a
!  translation along (`dx', `dy', `dz'). Return extruded entities in
!  `outDimTags'. If `numElements' is not empty, also extrude the mesh: the
!  entries in `numElements' give the number of elements in each layer. If
!  `height' is not empty, it provides the (cumulative) height of the different
!  layers, normalized to 1. If `recombine' is set, recombine the mesh in the
!  layers.
        subroutine gmshModelGeoExtrude(
     &      dimTags,
     &      dimTags_n,
     &      dx,
     &      dy,
     &      dz,
     &      outDimTags,
     &      outDimTags_n,
     &      numElements,
     &      numElements_n,
     &      heights,
     &      heights_n,
     &      recombine,
     &      ierr)
     &    bind(C, name = "gmshModelGeoExtrude")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::numElements(*)
            integer(c_size_t), value :: numElements_n
            real(c_double)::heights(*)
            integer(c_size_t), value :: heights_n
            integer(c_int), value::recombine
            integer(c_int)::ierr
          end subroutine gmshModelGeoExtrude

!  Extrude the entities `dimTags' in the built-in CAD representation, using a
!  rotation of `angle' radians around the axis of revolution defined by the
!  point (`x', `y', `z') and the direction (`ax', `ay', `az'). The angle
!  should be strictly smaller than Pi. Return extruded entities in
!  `outDimTags'. If `numElements' is not empty, also extrude the mesh: the
!  entries in `numElements' give the number of elements in each layer. If
!  `height' is not empty, it provides the (cumulative) height of the different
!  layers, normalized to 1. If `recombine' is set, recombine the mesh in the
!  layers.
        subroutine gmshModelGeoRevolve(
     &      dimTags,
     &      dimTags_n,
     &      x,
     &      y,
     &      z,
     &      ax,
     &      ay,
     &      az,
     &      angle,
     &      outDimTags,
     &      outDimTags_n,
     &      numElements,
     &      numElements_n,
     &      heights,
     &      heights_n,
     &      recombine,
     &      ierr)
     &    bind(C, name = "gmshModelGeoRevolve")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::ax
            real(c_double), value::ay
            real(c_double), value::az
            real(c_double), value::angle
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::numElements(*)
            integer(c_size_t), value :: numElements_n
            real(c_double)::heights(*)
            integer(c_size_t), value :: heights_n
            integer(c_int), value::recombine
            integer(c_int)::ierr
          end subroutine gmshModelGeoRevolve

!  Extrude the entities `dimTags' in the built-in CAD representation, using a
!  combined translation and rotation of `angle' radians, along (`dx', `dy',
!  `dz') and around the axis of revolution defined by the point (`x', `y',
!  `z') and the direction (`ax', `ay', `az'). The angle should be strictly
!  smaller than Pi. Return extruded entities in `outDimTags'. If `numElements'
!  is not empty, also extrude the mesh: the entries in `numElements' give the
!  number of elements in each layer. If `height' is not empty, it provides the
!  (cumulative) height of the different layers, normalized to 1. If
!  `recombine' is set, recombine the mesh in the layers.
        subroutine gmshModelGeoTwist(
     &      dimTags,
     &      dimTags_n,
     &      x,
     &      y,
     &      z,
     &      dx,
     &      dy,
     &      dz,
     &      ax,
     &      ay,
     &      az,
     &      angle,
     &      outDimTags,
     &      outDimTags_n,
     &      numElements,
     &      numElements_n,
     &      heights,
     &      heights_n,
     &      recombine,
     &      ierr)
     &    bind(C, name = "gmshModelGeoTwist")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            real(c_double), value::ax
            real(c_double), value::ay
            real(c_double), value::az
            real(c_double), value::angle
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::numElements(*)
            integer(c_size_t), value :: numElements_n
            real(c_double)::heights(*)
            integer(c_size_t), value :: heights_n
            integer(c_int), value::recombine
            integer(c_int)::ierr
          end subroutine gmshModelGeoTwist

!  Extrude the entities `dimTags' in the built-in CAD representation along the
!  normals of the mesh, creating discrete boundary layer entities. Return
!  extruded entities in `outDimTags'. The entries in `numElements' give the
!  number of elements in each layer. If `height' is not empty, it provides the
!  height of the different layers. If `recombine' is set, recombine the mesh
!  in the layers. A second boundary layer can be created from the same
!  entities if `second' is set. If `viewIndex' is >= 0, use the corresponding
!  view to either specify the normals (if the view contains a vector field) or
!  scale the normals (if the view is scalar).
        subroutine gmshModelGeoExtrudeBoundaryLayer(
     &      dimTags,
     &      dimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      numElements,
     &      numElements_n,
     &      heights,
     &      heights_n,
     &      recombine,
     &      second,
     &      viewIndex,
     &      ierr)
     &    bind(C, name = "gmshModelGeoExtrudeBoundaryLayer")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::numElements(*)
            integer(c_size_t), value :: numElements_n
            real(c_double)::heights(*)
            integer(c_size_t), value :: heights_n
            integer(c_int), value::recombine
            integer(c_int), value::second
            integer(c_int), value::viewIndex
            integer(c_int)::ierr
          end subroutine gmshModelGeoExtrudeBoundaryLayer

!  Translate the entities `dimTags' in the built-in CAD representation along
!  (`dx', `dy', `dz').
        subroutine gmshModelGeoTranslate(
     &      dimTags,
     &      dimTags_n,
     &      dx,
     &      dy,
     &      dz,
     &      ierr)
     &    bind(C, name = "gmshModelGeoTranslate")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            integer(c_int)::ierr
          end subroutine gmshModelGeoTranslate

!  Rotate the entities `dimTags' in the built-in CAD representation by `angle'
!  radians around the axis of revolution defined by the point (`x', `y', `z')
!  and the direction (`ax', `ay', `az').
        subroutine gmshModelGeoRotate(
     &      dimTags,
     &      dimTags_n,
     &      x,
     &      y,
     &      z,
     &      ax,
     &      ay,
     &      az,
     &      angle,
     &      ierr)
     &    bind(C, name = "gmshModelGeoRotate")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::ax
            real(c_double), value::ay
            real(c_double), value::az
            real(c_double), value::angle
            integer(c_int)::ierr
          end subroutine gmshModelGeoRotate

!  Scale the entities `dimTag' in the built-in CAD representation by factors
!  `a', `b' and `c' along the three coordinate axes; use (`x', `y', `z') as
!  the center of the homothetic transformation.
        subroutine gmshModelGeoDilate(
     &      dimTags,
     &      dimTags_n,
     &      x,
     &      y,
     &      z,
     &      a,
     &      b,
     &      c,
     &      ierr)
     &    bind(C, name = "gmshModelGeoDilate")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::a
            real(c_double), value::b
            real(c_double), value::c
            integer(c_int)::ierr
          end subroutine gmshModelGeoDilate

!  Mirror the entities `dimTag' in the built-in CAD representation, with
!  respect to the plane of equation `a' * x + `b' * y + `c' * z + `d' = 0.
        subroutine gmshModelGeoMirror(
     &      dimTags,
     &      dimTags_n,
     &      a,
     &      b,
     &      c,
     &      d,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMirror")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::a
            real(c_double), value::b
            real(c_double), value::c
            real(c_double), value::d
            integer(c_int)::ierr
          end subroutine gmshModelGeoMirror

!  Mirror the entities `dimTag' in the built-in CAD representation, with
!  respect to the plane of equation `a' * x + `b' * y + `c' * z + `d' = 0.
!  (This is a synonym for `mirror', which will be deprecated in a future
!  release.)
        subroutine gmshModelGeoSymmetrize(
     &      dimTags,
     &      dimTags_n,
     &      a,
     &      b,
     &      c,
     &      d,
     &      ierr)
     &    bind(C, name = "gmshModelGeoSymmetrize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::a
            real(c_double), value::b
            real(c_double), value::c
            real(c_double), value::d
            integer(c_int)::ierr
          end subroutine gmshModelGeoSymmetrize

!  Copy the entities `dimTags' in the built-in CAD representation; the new
!  entities are returned in `outDimTags'.
        subroutine gmshModelGeoCopy(
     &      dimTags,
     &      dimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGeoCopy")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelGeoCopy

!  Remove the entities `dimTags' in the built-in CAD representation, provided
!  that they are not on the boundary of higher-dimensional entities. If
!  `recursive' is true, remove all the entities on their boundaries, down to
!  dimension 0.
        subroutine gmshModelGeoRemove(
     &      dimTags,
     &      dimTags_n,
     &      recursive,
     &      ierr)
     &    bind(C, name = "gmshModelGeoRemove")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int), value::recursive
            integer(c_int)::ierr
          end subroutine gmshModelGeoRemove

!  Remove all duplicate entities in the built-in CAD representation (different
!  entities at the same geometrical location).
        subroutine gmshModelGeoRemoveAllDuplicates(
     &      ierr)
     &    bind(C, name = "gmshModelGeoRemoveAllDuplicates")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelGeoRemoveAllDuplicates

!  Split the curve of tag `tag' in the built-in CAD representation, on the
!  specified control points `pointTags'. This feature is only available for
!  lines, splines and b-splines. Return the tag(s) `curveTags' of the newly
!  created curve(s).
        subroutine gmshModelGeoSplitCurve(
     &      tag,
     &      pointTags,
     &      pointTags_n,
     &      curveTags,
     &      curveTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGeoSplitCurve")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            type(c_ptr), intent(out)::curveTags
            integer(c_size_t) :: curveTags_n
            integer(c_int)::ierr
          end subroutine gmshModelGeoSplitCurve

!  Get the maximum tag of entities of dimension `dim' in the built-in CAD
!  representation.
        function gmshModelGeoGetMaxTag(
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelGeoGetMaxTag")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoGetMaxTag
            integer(c_int), value::dim
            integer(c_int)::ierr
          end function gmshModelGeoGetMaxTag

!  Set the maximum tag `maxTag' for entities of dimension `dim' in the built-
!  in CAD representation.
        subroutine gmshModelGeoSetMaxTag(
     &      dim,
     &      maxTag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoSetMaxTag")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::maxTag
            integer(c_int)::ierr
          end subroutine gmshModelGeoSetMaxTag

!  Add a physical group of dimension `dim', grouping the entities with tags
!  `tags' in the built-in CAD representation. Return the tag of the physical
!  group, equal to `tag' if `tag' is positive, or a new tag if `tag' < 0.
        function gmshModelGeoAddPhysicalGroup(
     &      dim,
     &      tags,
     &      tags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelGeoAddPhysicalGroup")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelGeoAddPhysicalGroup
            integer(c_int), value::dim
            integer(c_int)::tags(*)
            integer(c_size_t), value :: tags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelGeoAddPhysicalGroup

!  Remove the physical groups `dimTags' from the built-in CAD representation.
!  If `dimTags' is empty, remove all groups.
        subroutine gmshModelGeoRemovePhysicalGroups(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGeoRemovePhysicalGroups")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelGeoRemovePhysicalGroups

!  Synchronize the built-in CAD representation with the current Gmsh model.
!  This can be called at any time, but since it involves a non trivial amount
!  of processing, the number of synchronization points should normally be
!  minimized. Without synchronization the entities in the built-in CAD
!  representation are not available to any function outside of the built-in
!  CAD kernel functions.
        subroutine gmshModelGeoSynchronize(
     &      ierr)
     &    bind(C, name = "gmshModelGeoSynchronize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelGeoSynchronize

!  Set a mesh size constraint on the entities `dimTags' in the built-in CAD
!  kernel representation. Currently only entities of dimension 0 (points) are
!  handled.
        subroutine gmshModelGeoMeshSetSize(
     &      dimTags,
     &      dimTags_n,
     &      size,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetSize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::size
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetSize

!  Set a transfinite meshing constraint on the curve `tag' in the built-in CAD
!  kernel representation, with `numNodes' nodes distributed according to
!  `meshType' and `coef'. Currently supported types are "Progression"
!  (geometrical progression with power `coef') and "Bump" (refinement toward
!  both extremities of the curve).
        subroutine gmshModelGeoMeshSetTransfiniteCurve(
     &      tag,
     &      nPoints,
     &      meshType,
     &      coef,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetTransfiniteCurve")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::nPoints
            character(len = 1, kind = c_char)::meshType(*)
            real(c_double), value::coef
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetTransfiniteCurve

!  Set a transfinite meshing constraint on the surface `tag' in the built-in
!  CAD kernel representation. `arrangement' describes the arrangement of the
!  triangles when the surface is not flagged as recombined: currently
!  supported values are "Left", "Right", "AlternateLeft" and "AlternateRight".
!  `cornerTags' can be used to specify the (3 or 4) corners of the transfinite
!  interpolation explicitly; specifying the corners explicitly is mandatory if
!  the surface has more that 3 or 4 points on its boundary.
        subroutine gmshModelGeoMeshSetTransfiniteSurface(
     &      tag,
     &      arrangement,
     &      cornerTags,
     &      cornerTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetTransfiniteSurface")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::arrangement(*)
            integer(c_int)::cornerTags(*)
            integer(c_size_t), value :: cornerTags_n
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetTransfiniteSurface

!  Set a transfinite meshing constraint on the surface `tag' in the built-in
!  CAD kernel representation. `cornerTags' can be used to specify the (6 or 8)
!  corners of the transfinite interpolation explicitly.
        subroutine gmshModelGeoMeshSetTransfiniteVolume(
     &      tag,
     &      cornerTags,
     &      cornerTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetTransfiniteVolume")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::cornerTags(*)
            integer(c_size_t), value :: cornerTags_n
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetTransfiniteVolume

!  Set a recombination meshing constraint on the entity of dimension `dim' and
!  tag `tag' in the built-in CAD kernel representation. Currently only
!  entities of dimension 2 (to recombine triangles into quadrangles) are
!  supported.
        subroutine gmshModelGeoMeshSetRecombine(
     &      dim,
     &      tag,
     &      angle,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetRecombine")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double), value::angle
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetRecombine

!  Set a smoothing meshing constraint on the entity of dimension `dim' and tag
!  `tag' in the built-in CAD kernel representation. `val' iterations of a
!  Laplace smoother are applied.
        subroutine gmshModelGeoMeshSetSmoothing(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetSmoothing")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetSmoothing

!  Set a reverse meshing constraint on the entity of dimension `dim' and tag
!  `tag' in the built-in CAD kernel representation. If `val' is true, the mesh
!  orientation will be reversed with respect to the natural mesh orientation
!  (i.e. the orientation consistent with the orientation of the geometry). If
!  `val' is false, the mesh is left as-is.
        subroutine gmshModelGeoMeshSetReverse(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetReverse")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetReverse

!  Set the meshing algorithm on the entity of dimension `dim' and tag `tag' in
!  the built-in CAD kernel representation. Currently only supported for `dim'
!  == 2.
        subroutine gmshModelGeoMeshSetAlgorithm(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetAlgorithm")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetAlgorithm

!  Force the mesh size to be extended from the boundary, or not, for the
!  entity of dimension `dim' and tag `tag' in the built-in CAD kernel
!  representation. Currently only supported for `dim' == 2.
        subroutine gmshModelGeoMeshSetSizeFromBoundary(
     &      dim,
     &      tag,
     &      val,
     &      ierr)
     &    bind(C, name = "gmshModelGeoMeshSetSizeFromBoundary")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int), value::val
            integer(c_int)::ierr
          end subroutine gmshModelGeoMeshSetSizeFromBoundary

!  Add a geometrical point in the OpenCASCADE CAD representation, at
!  coordinates (`x', `y', `z'). If `meshSize' is > 0, add a meshing constraint
!  at that point. If `tag' is positive, set the tag explicitly; otherwise a
!  new tag is selected automatically. Return the tag of the point. (Note that
!  the point will be added in the current model only after `synchronize' is
!  called. This behavior holds for all the entities added in the occ module.)
        function gmshModelOccAddPoint(
     &      x,
     &      y,
     &      z,
     &      meshSize,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddPoint")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddPoint
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::meshSize
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddPoint

!  Add a straight line segment in the OpenCASCADE CAD representation, between
!  the two points with tags `startTag' and `endTag'. If `tag' is positive, set
!  the tag explicitly; otherwise a new tag is selected automatically. Return
!  the tag of the line.
        function gmshModelOccAddLine(
     &      startTag,
     &      endTag,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddLine")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddLine
            integer(c_int), value::startTag
            integer(c_int), value::endTag
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddLine

!  Add a circle arc in the OpenCASCADE CAD representation, between the two
!  points with tags `startTag' and `endTag', with center `centerTag'. If `tag'
!  is positive, set the tag explicitly; otherwise a new tag is selected
!  automatically. Return the tag of the circle arc.
        function gmshModelOccAddCircleArc(
     &      startTag,
     &      centerTag,
     &      endTag,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddCircleArc")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddCircleArc
            integer(c_int), value::startTag
            integer(c_int), value::centerTag
            integer(c_int), value::endTag
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddCircleArc

!  Add a circle of center (`x', `y', `z') and radius `r' in the OpenCASCADE
!  CAD representation. If `tag' is positive, set the tag explicitly; otherwise
!  a new tag is selected automatically. If `angle1' and `angle2' are
!  specified, create a circle arc between the two angles. Return the tag of
!  the circle.
        function gmshModelOccAddCircle(
     &      x,
     &      y,
     &      z,
     &      r,
     &      tag,
     &      angle1,
     &      angle2,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddCircle")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddCircle
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::r
            integer(c_int), value::tag
            real(c_double), value::angle1
            real(c_double), value::angle2
            integer(c_int)::ierr
          end function gmshModelOccAddCircle

!  Add an ellipse arc in the OpenCASCADE CAD representation, between the two
!  points `startTag' and `endTag', and with center `centerTag' and major axis
!  point `majorTag'. If `tag' is positive, set the tag explicitly; otherwise a
!  new tag is selected automatically. Return the tag of the ellipse arc. Note
!  that OpenCASCADE does not allow creating ellipse arcs with the major radius
!  smaller than the minor radius.
        function gmshModelOccAddEllipseArc(
     &      startTag,
     &      centerTag,
     &      majorTag,
     &      endTag,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddEllipseArc")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddEllipseArc
            integer(c_int), value::startTag
            integer(c_int), value::centerTag
            integer(c_int), value::majorTag
            integer(c_int), value::endTag
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddEllipseArc

!  Add an ellipse of center (`x', `y', `z') and radii `r1' and `r2' along the
!  x- and y-axes, respectively, in the OpenCASCADE CAD representation. If
!  `tag' is positive, set the tag explicitly; otherwise a new tag is selected
!  automatically. If `angle1' and `angle2' are specified, create an ellipse
!  arc between the two angles. Return the tag of the ellipse. Note that
!  OpenCASCADE does not allow creating ellipses with the major radius (along
!  the x-axis) smaller than or equal to the minor radius (along the y-axis):
!  rotate the shape or use `addCircle' in such cases.
        function gmshModelOccAddEllipse(
     &      x,
     &      y,
     &      z,
     &      r1,
     &      r2,
     &      tag,
     &      angle1,
     &      angle2,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddEllipse")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddEllipse
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::r1
            real(c_double), value::r2
            integer(c_int), value::tag
            real(c_double), value::angle1
            real(c_double), value::angle2
            integer(c_int)::ierr
          end function gmshModelOccAddEllipse

!  Add a spline (C2 b-spline) curve in the OpenCASCADE CAD representation,
!  going through the points `pointTags'. If `tag' is positive, set the tag
!  explicitly; otherwise a new tag is selected automatically. Create a
!  periodic curve if the first and last points are the same. Return the tag of
!  the spline curve.
        function gmshModelOccAddSpline(
     &      pointTags,
     &      pointTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddSpline")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddSpline
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddSpline

!  Add a b-spline curve of degree `degree' in the OpenCASCADE CAD
!  representation, with `pointTags' control points. If `weights', `knots' or
!  `multiplicities' are not provided, default parameters are computed
!  automatically. If `tag' is positive, set the tag explicitly; otherwise a
!  new tag is selected automatically. Create a periodic curve if the first and
!  last points are the same. Return the tag of the b-spline curve.
        function gmshModelOccAddBSpline(
     &      pointTags,
     &      pointTags_n,
     &      tag,
     &      degree,
     &      weights,
     &      weights_n,
     &      knots,
     &      knots_n,
     &      multiplicities,
     &      multiplicities_n,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddBSpline")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddBSpline
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::tag
            integer(c_int), value::degree
            real(c_double)::weights(*)
            integer(c_size_t), value :: weights_n
            real(c_double)::knots(*)
            integer(c_size_t), value :: knots_n
            integer(c_int)::multiplicities(*)
            integer(c_size_t), value :: multiplicities_n
            integer(c_int)::ierr
          end function gmshModelOccAddBSpline

!  Add a Bezier curve in the OpenCASCADE CAD representation, with `pointTags'
!  control points. If `tag' is positive, set the tag explicitly; otherwise a
!  new tag is selected automatically. Return the tag of the Bezier curve.
        function gmshModelOccAddBezier(
     &      pointTags,
     &      pointTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddBezier")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddBezier
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddBezier

!  Add a wire (open or closed) in the OpenCASCADE CAD representation, formed
!  by the curves `curveTags'. Note that an OpenCASCADE wire can be made of
!  curves that share geometrically identical (but topologically different)
!  points. If `tag' is positive, set the tag explicitly; otherwise a new tag
!  is selected automatically. Return the tag of the wire.
        function gmshModelOccAddWire(
     &      curveTags,
     &      curveTags_n,
     &      tag,
     &      checkClosed,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddWire")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddWire
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            integer(c_int), value::tag
            integer(c_int), value::checkClosed
            integer(c_int)::ierr
          end function gmshModelOccAddWire

!  Add a curve loop (a closed wire) in the OpenCASCADE CAD representation,
!  formed by the curves `curveTags'. `curveTags' should contain tags of curves
!  forming a closed loop. Negative tags can be specified for compatibility
!  with the built-in kernel, but are simply ignored: the wire is oriented
!  according to the orientation of its first curve. Note that an OpenCASCADE
!  curve loop can be made of curves that share geometrically identical (but
!  topologically different) points. If `tag' is positive, set the tag
!  explicitly; otherwise a new tag is selected automatically. Return the tag
!  of the curve loop.
        function gmshModelOccAddCurveLoop(
     &      curveTags,
     &      curveTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddCurveLoop")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddCurveLoop
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddCurveLoop

!  Add a rectangle in the OpenCASCADE CAD representation, with lower left
!  corner at (`x', `y', `z') and upper right corner at (`x' + `dx', `y' +
!  `dy', `z'). If `tag' is positive, set the tag explicitly; otherwise a new
!  tag is selected automatically. Round the corners if `roundedRadius' is
!  nonzero. Return the tag of the rectangle.
        function gmshModelOccAddRectangle(
     &      x,
     &      y,
     &      z,
     &      dx,
     &      dy,
     &      tag,
     &      roundedRadius,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddRectangle")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddRectangle
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::dx
            real(c_double), value::dy
            integer(c_int), value::tag
            real(c_double), value::roundedRadius
            integer(c_int)::ierr
          end function gmshModelOccAddRectangle

!  Add a disk in the OpenCASCADE CAD representation, with center (`xc', `yc',
!  `zc') and radius `rx' along the x-axis and `ry' along the y-axis. If `tag'
!  is positive, set the tag explicitly; otherwise a new tag is selected
!  automatically. Return the tag of the disk.
        function gmshModelOccAddDisk(
     &      xc,
     &      yc,
     &      zc,
     &      rx,
     &      ry,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddDisk")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddDisk
            real(c_double), value::xc
            real(c_double), value::yc
            real(c_double), value::zc
            real(c_double), value::rx
            real(c_double), value::ry
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddDisk

!  Add a plane surface in the OpenCASCADE CAD representation, defined by one
!  or more curve loops (or closed wires) `wireTags'. The first curve loop
!  defines the exterior contour; additional curve loop define holes. If `tag'
!  is positive, set the tag explicitly; otherwise a new tag is selected
!  automatically. Return the tag of the surface.
        function gmshModelOccAddPlaneSurface(
     &      wireTags,
     &      wireTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddPlaneSurface")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddPlaneSurface
            integer(c_int)::wireTags(*)
            integer(c_size_t), value :: wireTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddPlaneSurface

!  Add a surface in the OpenCASCADE CAD representation, filling the curve loop
!  `wireTag'. If `tag' is positive, set the tag explicitly; otherwise a new
!  tag is selected automatically. Return the tag of the surface. If
!  `pointTags' are provided, force the surface to pass through the given
!  points. The other optional arguments are `degree' (the degree of the energy
!  criterion to minimize for computing the deformation of the surface),
!  `numPointsOnCurves' (the average number of points for discretisation of the
!  bounding curves), `numIter' (the maximum number of iterations of the
!  optimization process), `anisotropic' (improve performance when the ratio of
!  the length along the two parametric coordinates of the surface is high),
!  `tol2d' (tolerance to the constraints in the parametric plane of the
!  surface), `tol3d' (the maximum distance allowed between the support surface
!  and the constraints), `tolAng' (the maximum angle allowed between the
!  normal of the surface and the constraints), `tolCurv' (the maximum
!  difference of curvature allowed between the surface and the constraint),
!  `maxDegree' (the highest degree which the polynomial defining the filling
!  surface can have) and, `maxSegments' (the largest number of segments which
!  the filling surface can have).
        function gmshModelOccAddSurfaceFilling(
     &      wireTag,
     &      tag,
     &      pointTags,
     &      pointTags_n,
     &      degree,
     &      numPointsOnCurves,
     &      numIter,
     &      anisotropic,
     &      tol2d,
     &      tol3d,
     &      tolAng,
     &      tolCurv,
     &      maxDegree,
     &      maxSegments,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddSurfaceFilling")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddSurfaceFilling
            integer(c_int), value::wireTag
            integer(c_int), value::tag
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::degree
            integer(c_int), value::numPointsOnCurves
            integer(c_int), value::numIter
            integer(c_int), value::anisotropic
            real(c_double), value::tol2d
            real(c_double), value::tol3d
            real(c_double), value::tolAng
            real(c_double), value::tolCurv
            integer(c_int), value::maxDegree
            integer(c_int), value::maxSegments
            integer(c_int)::ierr
          end function gmshModelOccAddSurfaceFilling

!  Add a BSpline surface in the OpenCASCADE CAD representation, filling the
!  curve loop `wireTag'. The curve loop should be made of 2, 3 or 4 curves.
!  The optional `type' argument specifies the type of filling: "Stretch"
!  creates the flattest patch, "Curved" (the default) creates the most rounded
!  patch, and "Coons" creates a rounded patch with less depth than "Curved".
!  If `tag' is positive, set the tag explicitly; otherwise a new tag is
!  selected automatically. Return the tag of the surface.
        function gmshModelOccAddBSplineFilling(
     &      wireTag,
     &      tag,
     &      type,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddBSplineFilling")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddBSplineFilling
            integer(c_int), value::wireTag
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::type(*)
            integer(c_int)::ierr
          end function gmshModelOccAddBSplineFilling

!  Add a Bezier surface in the OpenCASCADE CAD representation, filling the
!  curve loop `wireTag'. The curve loop should be made of 2, 3 or 4 Bezier
!  curves. The optional `type' argument specifies the type of filling:
!  "Stretch" creates the flattest patch, "Curved" (the default) creates the
!  most rounded patch, and "Coons" creates a rounded patch with less depth
!  than "Curved". If `tag' is positive, set the tag explicitly; otherwise a
!  new tag is selected automatically. Return the tag of the surface.
        function gmshModelOccAddBezierFilling(
     &      wireTag,
     &      tag,
     &      type,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddBezierFilling")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddBezierFilling
            integer(c_int), value::wireTag
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::type(*)
            integer(c_int)::ierr
          end function gmshModelOccAddBezierFilling

!  Add a b-spline surface of degree `degreeU' x `degreeV' in the OpenCASCADE
!  CAD representation, with `pointTags' control points given as a single
!  vector [Pu1v1, ... Pu`numPointsU'v1, Pu1v2, ...]. If `weights', `knotsU',
!  `knotsV', `multiplicitiesU' or `multiplicitiesV' are not provided, default
!  parameters are computed automatically. If `tag' is positive, set the tag
!  explicitly; otherwise a new tag is selected automatically. If `wireTags' is
!  provided, trim the b-spline patch using the provided wires: the first wire
!  defines the external contour, the others define holes. If `wire3D' is set,
!  consider wire curves as 3D curves and project them on the b-spline surface;
!  otherwise consider the wire curves as defined in the parametric space of
!  the surface. Return the tag of the b-spline surface.
        function gmshModelOccAddBSplineSurface(
     &      pointTags,
     &      pointTags_n,
     &      numPointsU,
     &      tag,
     &      degreeU,
     &      degreeV,
     &      weights,
     &      weights_n,
     &      knotsU,
     &      knotsU_n,
     &      knotsV,
     &      knotsV_n,
     &      multiplicitiesU,
     &      multiplicitiesU_n,
     &      multiplicitiesV,
     &      multiplicitiesV_n,
     &      wireTags,
     &      wireTags_n,
     &      wire3D,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddBSplineSurface")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddBSplineSurface
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::numPointsU
            integer(c_int), value::tag
            integer(c_int), value::degreeU
            integer(c_int), value::degreeV
            real(c_double)::weights(*)
            integer(c_size_t), value :: weights_n
            real(c_double)::knotsU(*)
            integer(c_size_t), value :: knotsU_n
            real(c_double)::knotsV(*)
            integer(c_size_t), value :: knotsV_n
            integer(c_int)::multiplicitiesU(*)
            integer(c_size_t), value :: multiplicitiesU_n
            integer(c_int)::multiplicitiesV(*)
            integer(c_size_t), value :: multiplicitiesV_n
            integer(c_int)::wireTags(*)
            integer(c_size_t), value :: wireTags_n
            integer(c_int), value::wire3D
            integer(c_int)::ierr
          end function gmshModelOccAddBSplineSurface

!  Add a Bezier surface in the OpenCASCADE CAD representation, with
!  `pointTags' control points given as a single vector [Pu1v1, ...
!  Pu`numPointsU'v1, Pu1v2, ...]. If `tag' is positive, set the tag
!  explicitly; otherwise a new tag is selected automatically. If `wireTags' is
!  provided, trim the Bezier patch using the provided wires: the first wire
!  defines the external contour, the others define holes. If `wire3D' is set,
!  consider wire curves as 3D curves and project them on the Bezier surface;
!  otherwise consider the wire curves as defined in the parametric space of
!  the surface. Return the tag of the Bezier surface.
        function gmshModelOccAddBezierSurface(
     &      pointTags,
     &      pointTags_n,
     &      numPointsU,
     &      tag,
     &      wireTags,
     &      wireTags_n,
     &      wire3D,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddBezierSurface")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddBezierSurface
            integer(c_int)::pointTags(*)
            integer(c_size_t), value :: pointTags_n
            integer(c_int), value::numPointsU
            integer(c_int), value::tag
            integer(c_int)::wireTags(*)
            integer(c_size_t), value :: wireTags_n
            integer(c_int), value::wire3D
            integer(c_int)::ierr
          end function gmshModelOccAddBezierSurface

!  Trim the surface `surfaceTag' with the wires `wireTags', replacing any
!  existing trimming curves. The first wire defines the external contour, the
!  others define holes. If `wire3D' is set, consider wire curves as 3D curves
!  and project them on the surface; otherwise consider the wire curves as
!  defined in the parametric space of the surface. If `tag' is positive, set
!  the tag explicitly; otherwise a new tag is selected automatically. Return
!  the tag of the trimmed surface.
        function gmshModelOccAddTrimmedSurface(
     &      surfaceTag,
     &      wireTags,
     &      wireTags_n,
     &      wire3D,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddTrimmedSurface")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddTrimmedSurface
            integer(c_int), value::surfaceTag
            integer(c_int)::wireTags(*)
            integer(c_size_t), value :: wireTags_n
            integer(c_int), value::wire3D
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddTrimmedSurface

!  Add a surface loop (a closed shell) in the OpenCASCADE CAD representation,
!  formed by `surfaceTags'.  If `tag' is positive, set the tag explicitly;
!  otherwise a new tag is selected automatically. Return the tag of the
!  surface loop. Setting `sewing' allows one to build a shell made of surfaces
!  that share geometrically identical (but topologically different) curves.
        function gmshModelOccAddSurfaceLoop(
     &      surfaceTags,
     &      surfaceTags_n,
     &      tag,
     &      sewing,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddSurfaceLoop")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddSurfaceLoop
            integer(c_int)::surfaceTags(*)
            integer(c_size_t), value :: surfaceTags_n
            integer(c_int), value::tag
            integer(c_int), value::sewing
            integer(c_int)::ierr
          end function gmshModelOccAddSurfaceLoop

!  Add a volume (a region) in the OpenCASCADE CAD representation, defined by
!  one or more surface loops `shellTags'. The first surface loop defines the
!  exterior boundary; additional surface loop define holes. If `tag' is
!  positive, set the tag explicitly; otherwise a new tag is selected
!  automatically. Return the tag of the volume.
        function gmshModelOccAddVolume(
     &      shellTags,
     &      shellTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddVolume")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddVolume
            integer(c_int)::shellTags(*)
            integer(c_size_t), value :: shellTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddVolume

!  Add a sphere of center (`xc', `yc', `zc') and radius `r' in the OpenCASCADE
!  CAD representation. The optional `angle1' and `angle2' arguments define the
!  polar angle opening (from -Pi/2 to Pi/2). The optional `angle3' argument
!  defines the azimuthal opening (from 0 to 2*Pi). If `tag' is positive, set
!  the tag explicitly; otherwise a new tag is selected automatically. Return
!  the tag of the sphere.
        function gmshModelOccAddSphere(
     &      xc,
     &      yc,
     &      zc,
     &      radius,
     &      tag,
     &      angle1,
     &      angle2,
     &      angle3,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddSphere")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddSphere
            real(c_double), value::xc
            real(c_double), value::yc
            real(c_double), value::zc
            real(c_double), value::radius
            integer(c_int), value::tag
            real(c_double), value::angle1
            real(c_double), value::angle2
            real(c_double), value::angle3
            integer(c_int)::ierr
          end function gmshModelOccAddSphere

!  Add a parallelepipedic box in the OpenCASCADE CAD representation, defined
!  by a point (`x', `y', `z') and the extents along the x-, y- and z-axes. If
!  `tag' is positive, set the tag explicitly; otherwise a new tag is selected
!  automatically. Return the tag of the box.
        function gmshModelOccAddBox(
     &      x,
     &      y,
     &      z,
     &      dx,
     &      dy,
     &      dz,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddBox")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddBox
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshModelOccAddBox

!  Add a cylinder in the OpenCASCADE CAD representation, defined by the center
!  (`x', `y', `z') of its first circular face, the 3 components (`dx', `dy',
!  `dz') of the vector defining its axis and its radius `r'. The optional
!  `angle' argument defines the angular opening (from 0 to 2*Pi). If `tag' is
!  positive, set the tag explicitly; otherwise a new tag is selected
!  automatically. Return the tag of the cylinder.
        function gmshModelOccAddCylinder(
     &      x,
     &      y,
     &      z,
     &      dx,
     &      dy,
     &      dz,
     &      r,
     &      tag,
     &      angle,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddCylinder")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddCylinder
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            real(c_double), value::r
            integer(c_int), value::tag
            real(c_double), value::angle
            integer(c_int)::ierr
          end function gmshModelOccAddCylinder

!  Add a cone in the OpenCASCADE CAD representation, defined by the center
!  (`x', `y', `z') of its first circular face, the 3 components of the vector
!  (`dx', `dy', `dz') defining its axis and the two radii `r1' and `r2' of the
!  faces (these radii can be zero). If `tag' is positive, set the tag
!  explicitly; otherwise a new tag is selected automatically. `angle' defines
!  the optional angular opening (from 0 to 2*Pi). Return the tag of the cone.
        function gmshModelOccAddCone(
     &      x,
     &      y,
     &      z,
     &      dx,
     &      dy,
     &      dz,
     &      r1,
     &      r2,
     &      tag,
     &      angle,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddCone")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddCone
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            real(c_double), value::r1
            real(c_double), value::r2
            integer(c_int), value::tag
            real(c_double), value::angle
            integer(c_int)::ierr
          end function gmshModelOccAddCone

!  Add a right angular wedge in the OpenCASCADE CAD representation, defined by
!  the right-angle point (`x', `y', `z') and the 3 extends along the x-, y-
!  and z-axes (`dx', `dy', `dz'). If `tag' is positive, set the tag
!  explicitly; otherwise a new tag is selected automatically. The optional
!  argument `ltx' defines the top extent along the x-axis. Return the tag of
!  the wedge.
        function gmshModelOccAddWedge(
     &      x,
     &      y,
     &      z,
     &      dx,
     &      dy,
     &      dz,
     &      tag,
     &      ltx,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddWedge")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddWedge
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            integer(c_int), value::tag
            real(c_double), value::ltx
            integer(c_int)::ierr
          end function gmshModelOccAddWedge

!  Add a torus in the OpenCASCADE CAD representation, defined by its center
!  (`x', `y', `z') and its 2 radii `r' and `r2'. If `tag' is positive, set the
!  tag explicitly; otherwise a new tag is selected automatically. The optional
!  argument `angle' defines the angular opening (from 0 to 2*Pi). Return the
!  tag of the wedge.
        function gmshModelOccAddTorus(
     &      x,
     &      y,
     &      z,
     &      r1,
     &      r2,
     &      tag,
     &      angle,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddTorus")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccAddTorus
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::r1
            real(c_double), value::r2
            integer(c_int), value::tag
            real(c_double), value::angle
            integer(c_int)::ierr
          end function gmshModelOccAddTorus

!  Add a volume (if the optional argument `makeSolid' is set) or surfaces in
!  the OpenCASCADE CAD representation, defined through the open or closed
!  wires `wireTags'. If `tag' is positive, set the tag explicitly; otherwise a
!  new tag is selected automatically. The new entities are returned in
!  `outDimTags'. If the optional argument `makeRuled' is set, the surfaces
!  created on the boundary are forced to be ruled surfaces. If `maxDegree' is
!  positive, set the maximal degree of resulting surface.
        subroutine gmshModelOccAddThruSections(
     &      wireTags,
     &      wireTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      tag,
     &      makeSolid,
     &      makeRuled,
     &      maxDegree,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddThruSections")
          use, intrinsic :: iso_c_binding
            integer(c_int)::wireTags(*)
            integer(c_size_t), value :: wireTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int), value::tag
            integer(c_int), value::makeSolid
            integer(c_int), value::makeRuled
            integer(c_int), value::maxDegree
            integer(c_int)::ierr
          end subroutine gmshModelOccAddThruSections

!  Add a hollowed volume in the OpenCASCADE CAD representation, built from an
!  initial volume `volumeTag' and a set of faces from this volume
!  `excludeSurfaceTags', which are to be removed. The remaining faces of the
!  volume become the walls of the hollowed solid, with thickness `offset'. If
!  `tag' is positive, set the tag explicitly; otherwise a new tag is selected
!  automatically.
        subroutine gmshModelOccAddThickSolid(
     &      volumeTag,
     &      excludeSurfaceTags,
     &      excludeSurfaceTags_n,
     &      offset,
     &      outDimTags,
     &      outDimTags_n,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddThickSolid")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::volumeTag
            integer(c_int)::excludeSurfaceTags(*)
            integer(c_size_t), value :: excludeSurfaceTags_n
            real(c_double), value::offset
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshModelOccAddThickSolid

!  Extrude the entities `dimTags' in the OpenCASCADE CAD representation, using
!  a translation along (`dx', `dy', `dz'). Return extruded entities in
!  `outDimTags'. If `numElements' is not empty, also extrude the mesh: the
!  entries in `numElements' give the number of elements in each layer. If
!  `height' is not empty, it provides the (cumulative) height of the different
!  layers, normalized to 1. If `recombine' is set, recombine the mesh in the
!  layers.
        subroutine gmshModelOccExtrude(
     &      dimTags,
     &      dimTags_n,
     &      dx,
     &      dy,
     &      dz,
     &      outDimTags,
     &      outDimTags_n,
     &      numElements,
     &      numElements_n,
     &      heights,
     &      heights_n,
     &      recombine,
     &      ierr)
     &    bind(C, name = "gmshModelOccExtrude")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::numElements(*)
            integer(c_size_t), value :: numElements_n
            real(c_double)::heights(*)
            integer(c_size_t), value :: heights_n
            integer(c_int), value::recombine
            integer(c_int)::ierr
          end subroutine gmshModelOccExtrude

!  Extrude the entities `dimTags' in the OpenCASCADE CAD representation, using
!  a rotation of `angle' radians around the axis of revolution defined by the
!  point (`x', `y', `z') and the direction (`ax', `ay', `az'). Return extruded
!  entities in `outDimTags'. If `numElements' is not empty, also extrude the
!  mesh: the entries in `numElements' give the number of elements in each
!  layer. If `height' is not empty, it provides the (cumulative) height of the
!  different layers, normalized to 1. When the mesh is extruded the angle
!  should be strictly smaller than 2*Pi. If `recombine' is set, recombine the
!  mesh in the layers.
        subroutine gmshModelOccRevolve(
     &      dimTags,
     &      dimTags_n,
     &      x,
     &      y,
     &      z,
     &      ax,
     &      ay,
     &      az,
     &      angle,
     &      outDimTags,
     &      outDimTags_n,
     &      numElements,
     &      numElements_n,
     &      heights,
     &      heights_n,
     &      recombine,
     &      ierr)
     &    bind(C, name = "gmshModelOccRevolve")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::ax
            real(c_double), value::ay
            real(c_double), value::az
            real(c_double), value::angle
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::numElements(*)
            integer(c_size_t), value :: numElements_n
            real(c_double)::heights(*)
            integer(c_size_t), value :: heights_n
            integer(c_int), value::recombine
            integer(c_int)::ierr
          end subroutine gmshModelOccRevolve

!  Add a pipe in the OpenCASCADE CAD representation, by extruding the entities
!  `dimTags' along the wire `wireTag'. The type of sweep can be specified with
!  `trihedron' (possible values: "DiscreteTrihedron", "CorrectedFrenet",
!  "Fixed", "Frenet", "ConstantNormal", "Darboux", "GuideAC", "GuidePlan",
!  "GuideACWithContact", "GuidePlanWithContact"). If `trihedron' is not
!  provided, "DiscreteTrihedron" is assumed. Return the pipe in `outDimTags'.
        subroutine gmshModelOccAddPipe(
     &      dimTags,
     &      dimTags_n,
     &      wireTag,
     &      outDimTags,
     &      outDimTags_n,
     &      trihedron,
     &      ierr)
     &    bind(C, name = "gmshModelOccAddPipe")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int), value::wireTag
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            character(len = 1, kind = c_char)::trihedron(*)
            integer(c_int)::ierr
          end subroutine gmshModelOccAddPipe

!  Fillet the volumes `volumeTags' on the curves `curveTags' with radii
!  `radii'. The `radii' vector can either contain a single radius, as many
!  radii as `curveTags', or twice as many as `curveTags' (in which case
!  different radii are provided for the begin and end points of the curves).
!  Return the filleted entities in `outDimTags'. Remove the original volume if
!  `removeVolume' is set.
        subroutine gmshModelOccFillet(
     &      volumeTags,
     &      volumeTags_n,
     &      curveTags,
     &      curveTags_n,
     &      radii,
     &      radii_n,
     &      outDimTags,
     &      outDimTags_n,
     &      removeVolume,
     &      ierr)
     &    bind(C, name = "gmshModelOccFillet")
          use, intrinsic :: iso_c_binding
            integer(c_int)::volumeTags(*)
            integer(c_size_t), value :: volumeTags_n
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            real(c_double)::radii(*)
            integer(c_size_t), value :: radii_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int), value::removeVolume
            integer(c_int)::ierr
          end subroutine gmshModelOccFillet

!  Chamfer the volumes `volumeTags' on the curves `curveTags' with distances
!  `distances' measured on surfaces `surfaceTags'. The `distances' vector can
!  either contain a single distance, as many distances as `curveTags' and
!  `surfaceTags', or twice as many as `curveTags' and `surfaceTags' (in which
!  case the first in each pair is measured on the corresponding surface in
!  `surfaceTags', the other on the other adjacent surface). Return the
!  chamfered entities in `outDimTags'. Remove the original volume if
!  `removeVolume' is set.
        subroutine gmshModelOccChamfer(
     &      volumeTags,
     &      volumeTags_n,
     &      curveTags,
     &      curveTags_n,
     &      surfaceTags,
     &      surfaceTags_n,
     &      distances,
     &      distances_n,
     &      outDimTags,
     &      outDimTags_n,
     &      removeVolume,
     &      ierr)
     &    bind(C, name = "gmshModelOccChamfer")
          use, intrinsic :: iso_c_binding
            integer(c_int)::volumeTags(*)
            integer(c_size_t), value :: volumeTags_n
            integer(c_int)::curveTags(*)
            integer(c_size_t), value :: curveTags_n
            integer(c_int)::surfaceTags(*)
            integer(c_size_t), value :: surfaceTags_n
            real(c_double)::distances(*)
            integer(c_size_t), value :: distances_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int), value::removeVolume
            integer(c_int)::ierr
          end subroutine gmshModelOccChamfer

!  Compute the boolean union (the fusion) of the entities `objectDimTags' and
!  `toolDimTags' in the OpenCASCADE CAD representation. Return the resulting
!  entities in `outDimTags'. If `tag' is positive, try to set the tag
!  explicitly (only valid if the boolean operation results in a single
!  entity). Remove the object if `removeObject' is set. Remove the tool if
!  `removeTool' is set.
        subroutine gmshModelOccFuse(
     &      objectDimTags,
     &      objectDimTags_n,
     &      toolDimTags,
     &      toolDimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      outDimTagsMap,
     &      outDimTagsMap_n,
     &      outDimTagsMap_nn,
     &      tag,
     &      removeObject,
     &      removeTool,
     &      ierr)
     &    bind(C, name = "gmshModelOccFuse")
          use, intrinsic :: iso_c_binding
            integer(c_int)::objectDimTags(*)
            integer(c_size_t), value :: objectDimTags_n
            integer(c_int)::toolDimTags(*)
            integer(c_size_t), value :: toolDimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            type (C_PTR), intent(out)::outDimTagsMap
            type(c_ptr), intent(out) :: outDimTagsMap_n
            integer (C_SIZE_T) ::outDimTagsMap_nn
            integer(c_int), value::tag
            integer(c_int), value::removeObject
            integer(c_int), value::removeTool
            integer(c_int)::ierr
          end subroutine gmshModelOccFuse

!  Compute the boolean intersection (the common parts) of the entities
!  `objectDimTags' and `toolDimTags' in the OpenCASCADE CAD representation.
!  Return the resulting entities in `outDimTags'. If `tag' is positive, try to
!  set the tag explicitly (only valid if the boolean operation results in a
!  single entity). Remove the object if `removeObject' is set. Remove the tool
!  if `removeTool' is set.
        subroutine gmshModelOccIntersect(
     &      objectDimTags,
     &      objectDimTags_n,
     &      toolDimTags,
     &      toolDimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      outDimTagsMap,
     &      outDimTagsMap_n,
     &      outDimTagsMap_nn,
     &      tag,
     &      removeObject,
     &      removeTool,
     &      ierr)
     &    bind(C, name = "gmshModelOccIntersect")
          use, intrinsic :: iso_c_binding
            integer(c_int)::objectDimTags(*)
            integer(c_size_t), value :: objectDimTags_n
            integer(c_int)::toolDimTags(*)
            integer(c_size_t), value :: toolDimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            type (C_PTR), intent(out)::outDimTagsMap
            type(c_ptr), intent(out) :: outDimTagsMap_n
            integer (C_SIZE_T) ::outDimTagsMap_nn
            integer(c_int), value::tag
            integer(c_int), value::removeObject
            integer(c_int), value::removeTool
            integer(c_int)::ierr
          end subroutine gmshModelOccIntersect

!  Compute the boolean difference between the entities `objectDimTags' and
!  `toolDimTags' in the OpenCASCADE CAD representation. Return the resulting
!  entities in `outDimTags'. If `tag' is positive, try to set the tag
!  explicitly (only valid if the boolean operation results in a single
!  entity). Remove the object if `removeObject' is set. Remove the tool if
!  `removeTool' is set.
        subroutine gmshModelOccCut(
     &      objectDimTags,
     &      objectDimTags_n,
     &      toolDimTags,
     &      toolDimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      outDimTagsMap,
     &      outDimTagsMap_n,
     &      outDimTagsMap_nn,
     &      tag,
     &      removeObject,
     &      removeTool,
     &      ierr)
     &    bind(C, name = "gmshModelOccCut")
          use, intrinsic :: iso_c_binding
            integer(c_int)::objectDimTags(*)
            integer(c_size_t), value :: objectDimTags_n
            integer(c_int)::toolDimTags(*)
            integer(c_size_t), value :: toolDimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            type (C_PTR), intent(out)::outDimTagsMap
            type(c_ptr), intent(out) :: outDimTagsMap_n
            integer (C_SIZE_T) ::outDimTagsMap_nn
            integer(c_int), value::tag
            integer(c_int), value::removeObject
            integer(c_int), value::removeTool
            integer(c_int)::ierr
          end subroutine gmshModelOccCut

!  Compute the boolean fragments (general fuse) resulting from the
!  intersection of the entities `objectDimTags' and `toolDimTags' in the
!  OpenCASCADE CAD representation, making all iterfaces conformal. When
!  applied to entities of different dimensions, the lower dimensional entities
!  will be automatically embedded in the higher dimensional entities if they
!  are not on their boundary. Return the resulting entities in `outDimTags'.
!  If `tag' is positive, try to set the tag explicitly (only valid if the
!  boolean operation results in a single entity). Remove the object if
!  `removeObject' is set. Remove the tool if `removeTool' is set.
        subroutine gmshModelOccFragment(
     &      objectDimTags,
     &      objectDimTags_n,
     &      toolDimTags,
     &      toolDimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      outDimTagsMap,
     &      outDimTagsMap_n,
     &      outDimTagsMap_nn,
     &      tag,
     &      removeObject,
     &      removeTool,
     &      ierr)
     &    bind(C, name = "gmshModelOccFragment")
          use, intrinsic :: iso_c_binding
            integer(c_int)::objectDimTags(*)
            integer(c_size_t), value :: objectDimTags_n
            integer(c_int)::toolDimTags(*)
            integer(c_size_t), value :: toolDimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            type (C_PTR), intent(out)::outDimTagsMap
            type(c_ptr), intent(out) :: outDimTagsMap_n
            integer (C_SIZE_T) ::outDimTagsMap_nn
            integer(c_int), value::tag
            integer(c_int), value::removeObject
            integer(c_int), value::removeTool
            integer(c_int)::ierr
          end subroutine gmshModelOccFragment

!  Translate the entities `dimTags' in the OpenCASCADE CAD representation
!  along (`dx', `dy', `dz').
        subroutine gmshModelOccTranslate(
     &      dimTags,
     &      dimTags_n,
     &      dx,
     &      dy,
     &      dz,
     &      ierr)
     &    bind(C, name = "gmshModelOccTranslate")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::dx
            real(c_double), value::dy
            real(c_double), value::dz
            integer(c_int)::ierr
          end subroutine gmshModelOccTranslate

!  Rotate the entities `dimTags' in the OpenCASCADE CAD representation by
!  `angle' radians around the axis of revolution defined by the point (`x',
!  `y', `z') and the direction (`ax', `ay', `az').
        subroutine gmshModelOccRotate(
     &      dimTags,
     &      dimTags_n,
     &      x,
     &      y,
     &      z,
     &      ax,
     &      ay,
     &      az,
     &      angle,
     &      ierr)
     &    bind(C, name = "gmshModelOccRotate")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::ax
            real(c_double), value::ay
            real(c_double), value::az
            real(c_double), value::angle
            integer(c_int)::ierr
          end subroutine gmshModelOccRotate

!  Scale the entities `dimTags' in the OpenCASCADE CAD representation by
!  factors `a', `b' and `c' along the three coordinate axes; use (`x', `y',
!  `z') as the center of the homothetic transformation.
        subroutine gmshModelOccDilate(
     &      dimTags,
     &      dimTags_n,
     &      x,
     &      y,
     &      z,
     &      a,
     &      b,
     &      c,
     &      ierr)
     &    bind(C, name = "gmshModelOccDilate")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            real(c_double), value::a
            real(c_double), value::b
            real(c_double), value::c
            integer(c_int)::ierr
          end subroutine gmshModelOccDilate

!  Mirror the entities `dimTags' in the OpenCASCADE CAD representation, with
!  respect to the plane of equation `a' * x + `b' * y + `c' * z + `d' = 0.
        subroutine gmshModelOccMirror(
     &      dimTags,
     &      dimTags_n,
     &      a,
     &      b,
     &      c,
     &      d,
     &      ierr)
     &    bind(C, name = "gmshModelOccMirror")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::a
            real(c_double), value::b
            real(c_double), value::c
            real(c_double), value::d
            integer(c_int)::ierr
          end subroutine gmshModelOccMirror

!  Mirror the entities `dimTags' in the OpenCASCADE CAD representation, with
!  respect to the plane of equation `a' * x + `b' * y + `c' * z + `d' = 0.
!  (This is a deprecated synonym for `mirror'.)
        subroutine gmshModelOccSymmetrize(
     &      dimTags,
     &      dimTags_n,
     &      a,
     &      b,
     &      c,
     &      d,
     &      ierr)
     &    bind(C, name = "gmshModelOccSymmetrize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::a
            real(c_double), value::b
            real(c_double), value::c
            real(c_double), value::d
            integer(c_int)::ierr
          end subroutine gmshModelOccSymmetrize

!  Apply a general affine transformation matrix `affineTransform' (16 entries
!  of a 4x4 matrix, by row; only the 12 first can be provided for convenience)
!  to the entities `dimTags' in the OpenCASCADE CAD representation.
        subroutine gmshModelOccAffineTransform(
     &      dimTags,
     &      dimTags_n,
     &      affineTransform,
     &      affineTransform_n,
     &      ierr)
     &    bind(C, name = "gmshModelOccAffineTransform")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double)::affineTransform(*)
            integer(c_size_t), value :: affineTransform_n
            integer(c_int)::ierr
          end subroutine gmshModelOccAffineTransform

!  Copy the entities `dimTags' in the OpenCASCADE CAD representation; the new
!  entities are returned in `outDimTags'.
        subroutine gmshModelOccCopy(
     &      dimTags,
     &      dimTags_n,
     &      outDimTags,
     &      outDimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelOccCopy")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelOccCopy

!  Remove the entities `dimTags' in the OpenCASCADE CAD representation,
!  provided that they are not on the boundary of higher-dimensional entities.
!  If `recursive' is true, remove all the entities on their boundaries, down
!  to dimension 0.
        subroutine gmshModelOccRemove(
     &      dimTags,
     &      dimTags_n,
     &      recursive,
     &      ierr)
     &    bind(C, name = "gmshModelOccRemove")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int), value::recursive
            integer(c_int)::ierr
          end subroutine gmshModelOccRemove

!  Remove all duplicate entities in the OpenCASCADE CAD representation
!  (different entities at the same geometrical location) after intersecting
!  (using boolean fragments) all highest dimensional entities.
        subroutine gmshModelOccRemoveAllDuplicates(
     &      ierr)
     &    bind(C, name = "gmshModelOccRemoveAllDuplicates")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelOccRemoveAllDuplicates

!  Apply various healing procedures to the entities `dimTags' (or to all the
!  entities in the model if `dimTags' is empty) in the OpenCASCADE CAD
!  representation. Return the healed entities in `outDimTags'. Available
!  healing options are listed in the Gmsh reference manual.
        subroutine gmshModelOccHealShapes(
     &      outDimTags,
     &      outDimTags_n,
     &      dimTags,
     &      dimTags_n,
     &      tolerance,
     &      fixDegenerated,
     &      fixSmallEdges,
     &      fixSmallFaces,
     &      sewFaces,
     &      makeSolids,
     &      ierr)
     &    bind(C, name = "gmshModelOccHealShapes")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::tolerance
            integer(c_int), value::fixDegenerated
            integer(c_int), value::fixSmallEdges
            integer(c_int), value::fixSmallFaces
            integer(c_int), value::sewFaces
            integer(c_int), value::makeSolids
            integer(c_int)::ierr
          end subroutine gmshModelOccHealShapes

!  Convert the entities `dimTags' to NURBS.
        subroutine gmshModelOccConvertToNURBS(
     &      dimTags,
     &      dimTags_n,
     &      ierr)
     &    bind(C, name = "gmshModelOccConvertToNURBS")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            integer(c_int)::ierr
          end subroutine gmshModelOccConvertToNURBS

!  Import BREP, STEP or IGES shapes from the file `fileName' in the
!  OpenCASCADE CAD representation. The imported entities are returned in
!  `outDimTags'. If the optional argument `highestDimOnly' is set, only import
!  the highest dimensional entities in the file. The optional argument
!  `format' can be used to force the format of the file (currently "brep",
!  "step" or "iges").
        subroutine gmshModelOccImportShapes(
     &      fileName,
     &      outDimTags,
     &      outDimTags_n,
     &      highestDimOnly,
     &      format,
     &      ierr)
     &    bind(C, name = "gmshModelOccImportShapes")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::fileName(*)
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int), value::highestDimOnly
            character(len = 1, kind = c_char)::format(*)
            integer(c_int)::ierr
          end subroutine gmshModelOccImportShapes

!  Imports an OpenCASCADE `shape' by providing a pointer to a native
!  OpenCASCADE `TopoDS_Shape' object (passed as a pointer to void). The
!  imported entities are returned in `outDimTags'. If the optional argument
!  `highestDimOnly' is set, only import the highest dimensional entities in
!  `shape'. In Python, this function can be used for integration with
!  PythonOCC, in which the SwigPyObject pointer of `TopoDS_Shape' must be
!  passed as an int to `shape', i.e., `shape = int(pythonocc_shape.this)'.
!  Warning: this function is unsafe, as providing an invalid pointer will lead
!  to undefined behavior.
        subroutine gmshModelOccImportShapesNativePointer(
     &      shape,
     &      outDimTags,
     &      outDimTags_n,
     &      highestDimOnly,
     &      ierr)
     &    bind(C, name = "gmshModelOccImportShapesNativePointer")
          use, intrinsic :: iso_c_binding
            integer(c_int)::shape(*)
            type(c_ptr), intent(out)::outDimTags
            integer(c_size_t) :: outDimTags_n
            integer(c_int), value::highestDimOnly
            integer(c_int)::ierr
          end subroutine gmshModelOccImportShapesNativePointer

!  Get all the OpenCASCADE entities. If `dim' is >= 0, return only the
!  entities of the specified dimension (e.g. points if `dim' == 0). The
!  entities are returned as a vector of (dim, tag) integer pairs.
        subroutine gmshModelOccGetEntities(
     &      dimTags,
     &      dimTags_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetEntities")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::dimTags
            integer(c_size_t) :: dimTags_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshModelOccGetEntities

!  Get the OpenCASCADE entities in the bounding box defined by the two points
!  (`xmin', `ymin', `zmin') and (`xmax', `ymax', `zmax'). If `dim' is >= 0,
!  return only the entities of the specified dimension (e.g. points if `dim'
!  == 0).
        subroutine gmshModelOccGetEntitiesInBoundingBox(
     &      xmin,
     &      ymin,
     &      zmin,
     &      xmax,
     &      ymax,
     &      zmax,
     &      tags,
     &      tags_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetEntitiesInBoundingBox")
          use, intrinsic :: iso_c_binding
            real(c_double), value::xmin
            real(c_double), value::ymin
            real(c_double), value::zmin
            real(c_double), value::xmax
            real(c_double), value::ymax
            real(c_double), value::zmax
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshModelOccGetEntitiesInBoundingBox

!  Get the bounding box (`xmin', `ymin', `zmin'), (`xmax', `ymax', `zmax') of
!  the OpenCASCADE entity of dimension `dim' and tag `tag'.
        subroutine gmshModelOccGetBoundingBox(
     &      dim,
     &      tag,
     &      xmin,
     &      ymin,
     &      zmin,
     &      xmax,
     &      ymax,
     &      zmax,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetBoundingBox")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::xmin
            real(c_double)::ymin
            real(c_double)::zmin
            real(c_double)::xmax
            real(c_double)::ymax
            real(c_double)::zmax
            integer(c_int)::ierr
          end subroutine gmshModelOccGetBoundingBox

!  Get the `tags' of the curve loops making up the surface of tag
!  `surfaceTag'.
        subroutine gmshModelOccGetCurveLoops(
     &      surfaceTag,
     &      tags,
     &      tags_n,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetCurveLoops")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::surfaceTag
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int)::ierr
          end subroutine gmshModelOccGetCurveLoops

!  Get the `tags' of the surface loops making up the volume of tag
!  `volumeTag'.
        subroutine gmshModelOccGetSurfaceLoops(
     &      volumeTag,
     &      tags,
     &      tags_n,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetSurfaceLoops")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::volumeTag
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int)::ierr
          end subroutine gmshModelOccGetSurfaceLoops

!  Get the mass of the OpenCASCADE entity of dimension `dim' and tag `tag'.
        subroutine gmshModelOccGetMass(
     &      dim,
     &      tag,
     &      mass,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetMass")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::mass
            integer(c_int)::ierr
          end subroutine gmshModelOccGetMass

!  Get the center of mass of the OpenCASCADE entity of dimension `dim' and tag
!  `tag'.
        subroutine gmshModelOccGetCenterOfMass(
     &      dim,
     &      tag,
     &      x,
     &      y,
     &      z,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetCenterOfMass")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            real(c_double)::x
            real(c_double)::y
            real(c_double)::z
            integer(c_int)::ierr
          end subroutine gmshModelOccGetCenterOfMass

!  Get the matrix of inertia (by row) of the OpenCASCADE entity of dimension
!  `dim' and tag `tag'.
        subroutine gmshModelOccGetMatrixOfInertia(
     &      dim,
     &      tag,
     &      mat,
     &      mat_n,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetMatrixOfInertia")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            type(c_ptr), intent(out)::mat
            integer(c_size_t) :: mat_n
            integer(c_int)::ierr
          end subroutine gmshModelOccGetMatrixOfInertia

!  Get the maximum tag of entities of dimension `dim' in the OpenCASCADE CAD
!  representation.
        function gmshModelOccGetMaxTag(
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshModelOccGetMaxTag")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshModelOccGetMaxTag
            integer(c_int), value::dim
            integer(c_int)::ierr
          end function gmshModelOccGetMaxTag

!  Set the maximum tag `maxTag' for entities of dimension `dim' in the
!  OpenCASCADE CAD representation.
        subroutine gmshModelOccSetMaxTag(
     &      dim,
     &      maxTag,
     &      ierr)
     &    bind(C, name = "gmshModelOccSetMaxTag")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::maxTag
            integer(c_int)::ierr
          end subroutine gmshModelOccSetMaxTag

!  Synchronize the OpenCASCADE CAD representation with the current Gmsh model.
!  This can be called at any time, but since it involves a non trivial amount
!  of processing, the number of synchronization points should normally be
!  minimized. Without synchronization the entities in the OpenCASCADE CAD
!  representation are not available to any function outside of the OpenCASCADE
!  CAD kernel functions.
        subroutine gmshModelOccSynchronize(
     &      ierr)
     &    bind(C, name = "gmshModelOccSynchronize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshModelOccSynchronize

!  Set a mesh size constraint on the entities `dimTags' in the OpenCASCADE CAD
!  representation. Currently only entities of dimension 0 (points) are
!  handled.
        subroutine gmshModelOccMeshSetSize(
     &      dimTags,
     &      dimTags_n,
     &      size,
     &      ierr)
     &    bind(C, name = "gmshModelOccMeshSetSize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::dimTags(*)
            integer(c_size_t), value :: dimTags_n
            real(c_double), value::size
            integer(c_int)::ierr
          end subroutine gmshModelOccMeshSetSize

!  Add a new post-processing view, with name `name'. If `tag' is positive use
!  it (and remove the view with that tag if it already exists), otherwise
!  associate a new tag. Return the view tag.
        function gmshViewAdd(
     &      name,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshViewAdd")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshViewAdd
            character(len = 1, kind = c_char)::name(*)
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshViewAdd

!  Remove the view with tag `tag'.
        subroutine gmshViewRemove(
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshViewRemove")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshViewRemove

!  Get the index of the view with tag `tag' in the list of currently loaded
!  views. This dynamic index (it can change when views are removed) is used to
!  access view options.
        function gmshViewGetIndex(
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshViewGetIndex")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshViewGetIndex
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshViewGetIndex

!  Get the tags of all views.
        subroutine gmshViewGetTags(
     &      tags,
     &      tags_n,
     &      ierr)
     &    bind(C, name = "gmshViewGetTags")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            integer(c_int)::ierr
          end subroutine gmshViewGetTags

!  Add model-based post-processing data to the view with tag `tag'.
!  `modelName' identifies the model the data is attached to. `dataType'
!  specifies the type of data, currently either "NodeData", "ElementData" or
!  "ElementNodeData". `step' specifies the identifier (>= 0) of the data in a
!  sequence. `tags' gives the tags of the nodes or elements in the mesh to
!  which the data is associated. `data' is a vector of the same length as
!  `tags': each entry is the vector of double precision numbers representing
!  the data associated with the corresponding tag. The optional `time'
!  argument associate a time value with the data. `numComponents' gives the
!  number of data components (1 for scalar data, 3 for vector data, etc.) per
!  entity; if negative, it is automatically inferred (when possible) from the
!  input data. `partition' allows one to specify data in several sub-sets.
        subroutine gmshViewAddModelData(
     &      tag,
     &      step,
     &      modelName,
     &      dataType,
     &      tags,
     &      tags_n,
     &      data,
     &      data_n,
     &      data_nn,
     &      time,
     &      numComponents,
     &      partition,
     &      ierr)
     &    bind(C, name = "gmshViewAddModelData")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::step
            character(len = 1, kind = c_char)::modelName(*)
            character(len = 1, kind = c_char)::dataType(*)
            integer(c_size_t)::tags(*)
            integer(c_size_t), value :: tags_n
            type(c_ptr), intent(out)::data
            type(c_ptr), intent(out) :: data_n
            integer(c_size_t) :: data_nn
            real(c_double), value::time
            integer(c_int), value::numComponents
            integer(c_int), value::partition
            integer(c_int)::ierr
          end subroutine gmshViewAddModelData

!  Add homogeneous model-based post-processing data to the view with tag
!  `tag'. The arguments have the same meaning as in `addModelData', except
!  that `data' is supposed to be homogeneous and is thus flattened in a single
!  vector. For data types that can lead to different data sizes per tag (like
!  "ElementNodeData"), the data should be padded.
        subroutine gmshViewAddHomogeneousModelData(
     &      tag,
     &      step,
     &      modelName,
     &      dataType,
     &      tags,
     &      tags_n,
     &      data,
     &      data_n,
     &      time,
     &      numComponents,
     &      partition,
     &      ierr)
     &    bind(C, name = "gmshViewAddHomogeneousModelData")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::step
            character(len = 1, kind = c_char)::modelName(*)
            character(len = 1, kind = c_char)::dataType(*)
            integer(c_size_t)::tags(*)
            integer(c_size_t), value :: tags_n
            real(c_double)::data(*)
            integer(c_size_t), value :: data_n
            real(c_double), value::time
            integer(c_int), value::numComponents
            integer(c_int), value::partition
            integer(c_int)::ierr
          end subroutine gmshViewAddHomogeneousModelData

!  Get model-based post-processing data from the view with tag `tag' at step
!  `step'. Return the `data' associated to the nodes or the elements with tags
!  `tags', as well as the `dataType' and the number of components
!  `numComponents'.
        subroutine gmshViewGetModelData(
     &      tag,
     &      step,
     &      dataType,
     &      tags,
     &      tags_n,
     &      data,
     &      data_n,
     &      data_nn,
     &      time,
     &      numComponents,
     &      ierr)
     &    bind(C, name = "gmshViewGetModelData")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::step
            type(c_ptr)::dataType(*)
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            type (c_ptr), intent(out)::data
            type(c_ptr), intent(out) :: data_n
            integer (c_size_t) :: data_nn
            real(c_double)::time
            integer(c_int)::numComponents
            integer(c_int)::ierr
          end subroutine gmshViewGetModelData

!  Get homogeneous model-based post-processing data from the view with tag
!  `tag' at step `step'. The arguments have the same meaning as in
!  `getModelData', except that `data' is returned flattened in a single
!  vector, with the appropriate padding if necessary.
        subroutine gmshViewGetHomogeneousModelData(
     &      tag,
     &      step,
     &      dataType,
     &      tags,
     &      tags_n,
     &      data,
     &      data_n,
     &      time,
     &      numComponents,
     &      ierr)
     &    bind(C, name = "gmshViewGetHomogeneousModelData")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::step
            type(c_ptr)::dataType(*)
            type(c_ptr), intent(out)::tags
            integer(c_size_t) :: tags_n
            type(c_ptr), intent(out)::data
            integer(c_size_t) :: data_n
            real(c_double)::time
            integer(c_int)::numComponents
            integer(c_int)::ierr
          end subroutine gmshViewGetHomogeneousModelData

!  Add list-based post-processing data to the view with tag `tag'. List-based
!  datasets are independent from any model and any mesh. `dataType' identifies
!  the data by concatenating the field type ("S" for scalar, "V" for vector,
!  "T" for tensor) and the element type ("P" for point, "L" for line, "T" for
!  triangle, "S" for tetrahedron, "I" for prism, "H" for hexaHedron, "Y" for
!  pyramid). For example `dataType' should be "ST" for a scalar field on
!  triangles. `numEle' gives the number of elements in the data. `data'
!  contains the data for the `numEle' elements, concatenated, with node
!  coordinates followed by values per node, repeated for each step: [e1x1,
!  ..., e1xn, e1y1, ..., e1yn, e1z1, ..., e1zn, e1v1..., e1vN, e2x1, ...].
        subroutine gmshViewAddListData(
     &      tag,
     &      dataType,
     &      numEle,
     &      data,
     &      data_n,
     &      ierr)
     &    bind(C, name = "gmshViewAddListData")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::dataType(*)
            integer(c_int), value::numEle
            real(c_double)::data(*)
            integer(c_size_t), value :: data_n
            integer(c_int)::ierr
          end subroutine gmshViewAddListData

!  Get list-based post-processing data from the view with tag `tag'. Return
!  the types `dataTypes', the number of elements `numElements' for each data
!  type and the `data' for each data type.
        subroutine gmshViewGetListData(
     &      tag,
     &      dataType,
     &      dataType_n,
     &      numElements,
     &      numElements_n,
     &      data,
     &      data_n,
     &      data_nn,
     &      ierr)
     &    bind(C, name = "gmshViewGetListData")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            type(c_ptr), intent(out)::dataType
            integer(c_size_t) :: dataType_n
            type(c_ptr), intent(out)::numElements
            integer(c_size_t) :: numElements_n
            type (c_ptr), intent(out)::data
            type(c_ptr), intent(out) :: data_n
            integer (c_size_t) :: data_nn
            integer(c_int)::ierr
          end subroutine gmshViewGetListData

!  Add a string to a list-based post-processing view with tag `tag'. If
!  `coord' contains 3 coordinates the string is positioned in the 3D model
!  space ("3D string"); if it contains 2 coordinates it is positioned in the
!  2D graphics viewport ("2D string"). `data' contains one or more (for
!  multistep views) strings. `style' contains key-value pairs of styling
!  parameters, concatenated. Available keys are "Font" (possible values:
!  "Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic",
!  "Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-
!  BoldOblique", "Courier", "Courier-Bold", "Courier-Oblique", "Courier-
!  BoldOblique", "Symbol", "ZapfDingbats", "Screen"), "FontSize" and "Align"
!  (possible values: "Left" or "BottomLeft", "Center" or "BottomCenter",
!  "Right" or "BottomRight", "TopLeft", "TopCenter", "TopRight", "CenterLeft",
!  "CenterCenter", "CenterRight").
        subroutine gmshViewAddListDataString(
     &      tag,
     &      coord,
     &      coord_n,
     &      data,
     &      data_n,
     &      style,
     &      style_n,
     &      ierr)
     &    bind(C, name = "gmshViewAddListDataString")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            real(c_double)::coord(*)
            integer(c_size_t), value :: coord_n
            type(c_ptr)::data(*)
            integer(c_size_t), value :: data_n
            type(c_ptr)::style(*)
            integer(c_size_t), value :: style_n
            integer(c_int)::ierr
          end subroutine gmshViewAddListDataString

!  Get list-based post-processing data strings (2D strings if `dim' = 2, 3D
!  strings if `dim' = 3) from the view with tag `tag'. Return the coordinates
!  in `coord', the strings in `data' and the styles in `style'.
        subroutine gmshViewGetListDataStrings(
     &      tag,
     &      dim,
     &      coord,
     &      coord_n,
     &      data,
     &      data_n,
     &      style,
     &      style_n,
     &      ierr)
     &    bind(C, name = "gmshViewGetListDataStrings")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::dim
            type(c_ptr), intent(out)::coord
            integer(c_size_t) :: coord_n
            type(c_ptr), intent(out)::data
            integer(c_size_t) :: data_n
            type(c_ptr), intent(out)::style
            integer(c_size_t) :: style_n
            integer(c_int)::ierr
          end subroutine gmshViewGetListDataStrings

!  Set interpolation matrices for the element family `type' ("Line",
!  "Triangle", "Quadrangle", "Tetrahedron", "Hexahedron", "Prism", "Pyramid")
!  in the view `tag'. The approximation of the values over an element is
!  written as a linear combination of `d' basis functions f_i(u, v, w) =
!  sum_(j = 0, ..., `d' - 1) `coef'[i][j] u^`exp'[j][0] v^`exp'[j][1]
!  w^`exp'[j][2], i = 0, ..., `d'-1, with u, v, w the coordinates in the
!  reference element. The `coef' matrix (of size `d' x `d') and the `exp'
!  matrix (of size `d' x 3) are stored as vectors, by row. If `dGeo' is
!  positive, use `coefGeo' and `expGeo' to define the interpolation of the x,
!  y, z coordinates of the element in terms of the u, v, w coordinates, in
!  exactly the same way. If `d' < 0, remove the interpolation matrices.
        subroutine gmshViewSetInterpolationMatrices(
     &      tag,
     &      type,
     &      d,
     &      coef,
     &      coef_n,
     &      exp,
     &      exp_n,
     &      dGeo,
     &      coefGeo,
     &      coefGeo_n,
     &      expGeo,
     &      expGeo_n,
     &      ierr)
     &    bind(C, name = "gmshViewSetInterpolationMatrices")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::type(*)
            integer(c_int), value::d
            real(c_double)::coef(*)
            integer(c_size_t), value :: coef_n
            real(c_double)::exp(*)
            integer(c_size_t), value :: exp_n
            integer(c_int), value::dGeo
            real(c_double)::coefGeo(*)
            integer(c_size_t), value :: coefGeo_n
            real(c_double)::expGeo(*)
            integer(c_size_t), value :: expGeo_n
            integer(c_int)::ierr
          end subroutine gmshViewSetInterpolationMatrices

!  Add a post-processing view as an `alias' of the reference view with tag
!  `refTag'. If `copyOptions' is set, copy the options of the reference view.
!  If `tag' is positive use it (and remove the view with that tag if it
!  already exists), otherwise associate a new tag. Return the view tag.
        function gmshViewAddAlias(
     &      refTag,
     &      copyOptions,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshViewAddAlias")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshViewAddAlias
            integer(c_int), value::refTag
            integer(c_int), value::copyOptions
            integer(c_int), value::tag
            integer(c_int)::ierr
          end function gmshViewAddAlias

!  Combine elements (if `what' == "elements") or steps (if `what' == "steps")
!  of all views (`how' == "all"), all visible views (`how' == "visible") or
!  all views having the same name (`how' == "name"). Remove original views if
!  `remove' is set.
        subroutine gmshViewCombine(
     &      what,
     &      how,
     &      remove,
     &      copyOptions,
     &      ierr)
     &    bind(C, name = "gmshViewCombine")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::what(*)
            character(len = 1, kind = c_char)::how(*)
            integer(c_int), value::remove
            integer(c_int), value::copyOptions
            integer(c_int)::ierr
          end subroutine gmshViewCombine

!  Probe the view `tag' for its `value' at point (`x', `y', `z'). If no match
!  is found, `value' is returned empty. Return only the value at step `step'
!  is `step' is positive. Return only values with `numComp' if `numComp' is
!  positive. Return the gradient of the `value' if `gradient' is set. If
!  `distanceMax' is zero, only return a result if an exact match inside an
!  element in the view is found; if `distanceMax' is positive and an exact
!  match is not found, return the value at the closest node if it is closer
!  than `distanceMax'; if `distanceMax' is negative and an exact match is not
!  found, always return the value at the closest node. The distance to the
!  match is returned in `distance'. Return the result from the element
!  described by its coordinates if `xElementCoord', `yElementCoord' and
!  `zElementCoord' are provided. If `dim' is >= 0, return only matches from
!  elements of the specified dimension.
        subroutine gmshViewProbe(
     &      tag,
     &      x,
     &      y,
     &      z,
     &      value,
     &      value_n,
     &      distance,
     &      step,
     &      numComp,
     &      gradient,
     &      distanceMax,
     &      xElemCoord,
     &      xElemCoord_n,
     &      yElemCoord,
     &      yElemCoord_n,
     &      zElemCoord,
     &      zElemCoord_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshViewProbe")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            real(c_double), value::x
            real(c_double), value::y
            real(c_double), value::z
            type(c_ptr), intent(out)::value
            integer(c_size_t) :: value_n
            real(c_double)::distance
            integer(c_int), value::step
            integer(c_int), value::numComp
            integer(c_int), value::gradient
            real(c_double), value::distanceMax
            real(c_double)::xElemCoord(*)
            integer(c_size_t), value :: xElemCoord_n
            real(c_double)::yElemCoord(*)
            integer(c_size_t), value :: yElemCoord_n
            real(c_double)::zElemCoord(*)
            integer(c_size_t), value :: zElemCoord_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end subroutine gmshViewProbe

!  Write the view to a file `fileName'. The export format is determined by the
!  file extension. Append to the file if `append' is set.
        subroutine gmshViewWrite(
     &      tag,
     &      fileName,
     &      append,
     &      ierr)
     &    bind(C, name = "gmshViewWrite")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::fileName(*)
            integer(c_int), value::append
            integer(c_int)::ierr
          end subroutine gmshViewWrite

!  Set the global visibility of the view `tag' per window to `value', where
!  `windowIndex' identifies the window in the window list.
        subroutine gmshViewSetVisibilityPerWindow(
     &      tag,
     &      value,
     &      windowIndex,
     &      ierr)
     &    bind(C, name = "gmshViewSetVisibilityPerWindow")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            integer(c_int), value::value
            integer(c_int), value::windowIndex
            integer(c_int)::ierr
          end subroutine gmshViewSetVisibilityPerWindow

!  Set the numerical option `name' to value `value' for the view with tag
!  `tag'.
        subroutine gmshViewOptionSetNumber(
     &      tag,
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshViewOptionSetNumber")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            real(c_double), value::value
            integer(c_int)::ierr
          end subroutine gmshViewOptionSetNumber

!  Get the `value' of the numerical option `name' for the view with tag `tag'.
        subroutine gmshViewOptionGetNumber(
     &      tag,
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshViewOptionGetNumber")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            real(c_double)::value
            integer(c_int)::ierr
          end subroutine gmshViewOptionGetNumber

!  Set the string option `name' to value `value' for the view with tag `tag'.
        subroutine gmshViewOptionSetString(
     &      tag,
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshViewOptionSetString")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            character(len = 1, kind = c_char)::value(*)
            integer(c_int)::ierr
          end subroutine gmshViewOptionSetString

!  Get the `value' of the string option `name' for the view with tag `tag'.
        subroutine gmshViewOptionGetString(
     &      tag,
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshViewOptionGetString")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr)::value(*)
            integer(c_int)::ierr
          end subroutine gmshViewOptionGetString

!  Set the color option `name' to the RGBA value (`r', `g', `b', `a') for the
!  view with tag `tag', where where `r', `g', `b' and `a' should be integers
!  between 0 and 255.
        subroutine gmshViewOptionSetColor(
     &      tag,
     &      name,
     &      r,
     &      g,
     &      b,
     &      a,
     &      ierr)
     &    bind(C, name = "gmshViewOptionSetColor")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            integer(c_int), value::r
            integer(c_int), value::g
            integer(c_int), value::b
            integer(c_int), value::a
            integer(c_int)::ierr
          end subroutine gmshViewOptionSetColor

!  Get the `r', `g', `b', `a' value of the color option `name' for the view
!  with tag `tag'.
        subroutine gmshViewOptionGetColor(
     &      tag,
     &      name,
     &      r,
     &      g,
     &      b,
     &      a,
     &      ierr)
     &    bind(C, name = "gmshViewOptionGetColor")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::tag
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::r
            integer(c_int)::g
            integer(c_int)::b
            integer(c_int)::a
            integer(c_int)::ierr
          end subroutine gmshViewOptionGetColor

!  Copy the options from the view with tag `refTag' to the view with tag
!  `tag'.
        subroutine gmshViewOptionCopy(
     &      refTag,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshViewOptionCopy")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::refTag
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshViewOptionCopy

!  Set the numerical option `option' to the value `value' for plugin `name'.
        subroutine gmshPluginSetNumber(
     &      name,
     &      option,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshPluginSetNumber")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            character(len = 1, kind = c_char)::option(*)
            real(c_double), value::value
            integer(c_int)::ierr
          end subroutine gmshPluginSetNumber

!  Set the string option `option' to the value `value' for plugin `name'.
        subroutine gmshPluginSetString(
     &      name,
     &      option,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshPluginSetString")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            character(len = 1, kind = c_char)::option(*)
            character(len = 1, kind = c_char)::value(*)
            integer(c_int)::ierr
          end subroutine gmshPluginSetString

!  Run the plugin `name'. Return the tag of the created view (if any).
        function gmshPluginRun(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshPluginRun")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshPluginRun
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end function gmshPluginRun

!  Draw all the OpenGL scenes.
        subroutine gmshGraphicsDraw(
     &      ierr)
     &    bind(C, name = "gmshGraphicsDraw")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshGraphicsDraw

!  Create the FLTK graphical user interface. Can only be called in the main
!  thread.
        subroutine gmshFltkInitialize(
     &      ierr)
     &    bind(C, name = "gmshFltkInitialize")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshFltkInitialize

!  Wait at most `time' seconds for user interface events and return. If `time'
!  < 0, wait indefinitely. First automatically create the user interface if it
!  has not yet been initialized. Can only be called in the main thread.
        subroutine gmshFltkWait(
     &      time,
     &      ierr)
     &    bind(C, name = "gmshFltkWait")
          use, intrinsic :: iso_c_binding
            real(c_double), value::time
            integer(c_int)::ierr
          end subroutine gmshFltkWait

!  Update the user interface (potentially creating new widgets and windows).
!  First automatically create the user interface if it has not yet been
!  initialized. Can only be called in the main thread: use `awake("update")'
!  to trigger an update of the user interface from another thread.
        subroutine gmshFltkUpdate(
     &      ierr)
     &    bind(C, name = "gmshFltkUpdate")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshFltkUpdate

!  Awake the main user interface thread and process pending events, and
!  optionally perform an action (currently the only `action' allowed is
!  "update").
        subroutine gmshFltkAwake(
     &      action,
     &      ierr)
     &    bind(C, name = "gmshFltkAwake")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::action(*)
            integer(c_int)::ierr
          end subroutine gmshFltkAwake

!  Block the current thread until it can safely modify the user interface.
        subroutine gmshFltkLock(
     &      ierr)
     &    bind(C, name = "gmshFltkLock")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshFltkLock

!  Release the lock that was set using lock.
        subroutine gmshFltkUnlock(
     &      ierr)
     &    bind(C, name = "gmshFltkUnlock")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshFltkUnlock

!  Run the event loop of the graphical user interface, i.e. repeatedly call
!  `wait()'. First automatically create the user interface if it has not yet
!  been initialized. Can only be called in the main thread.
        subroutine gmshFltkRun(
     &      ierr)
     &    bind(C, name = "gmshFltkRun")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshFltkRun

!  Check if the user interface is available (e.g. to detect if it has been
!  closed).
        function gmshFltkIsAvailable(
     &      ierr)
     &    bind(C, name = "gmshFltkIsAvailable")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshFltkIsAvailable
            integer(c_int)::ierr
          end function gmshFltkIsAvailable

!  Select entities in the user interface. If `dim' is >= 0, return only the
!  entities of the specified dimension (e.g. points if `dim' == 0).
        function gmshFltkSelectEntities(
     &      dimTags,
     &      dimTags_n,
     &      dim,
     &      ierr)
     &    bind(C, name = "gmshFltkSelectEntities")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshFltkSelectEntities
            type(c_ptr), intent(out)::dimTags
            integer(c_size_t) :: dimTags_n
            integer(c_int), value::dim
            integer(c_int)::ierr
          end function gmshFltkSelectEntities

!  Select elements in the user interface.
        function gmshFltkSelectElements(
     &      elementTags,
     &      elementTags_n,
     &      ierr)
     &    bind(C, name = "gmshFltkSelectElements")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshFltkSelectElements
            type(c_ptr), intent(out)::elementTags
            integer(c_size_t) :: elementTags_n
            integer(c_int)::ierr
          end function gmshFltkSelectElements

!  Select views in the user interface.
        function gmshFltkSelectViews(
     &      viewTags,
     &      viewTags_n,
     &      ierr)
     &    bind(C, name = "gmshFltkSelectViews")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshFltkSelectViews
            type(c_ptr), intent(out)::viewTags
            integer(c_size_t) :: viewTags_n
            integer(c_int)::ierr
          end function gmshFltkSelectViews

!  Split the current window horizontally (if `how' = "h") or vertically (if
!  `how' = "v"), using ratio `ratio'. If `how' = "u", restore a single window.
        subroutine gmshFltkSplitCurrentWindow(
     &      how,
     &      ratio,
     &      ierr)
     &    bind(C, name = "gmshFltkSplitCurrentWindow")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::how(*)
            real(c_double), value::ratio
            integer(c_int)::ierr
          end subroutine gmshFltkSplitCurrentWindow

!  Set the current window by speficying its index (starting at 0) in the list
!  of all windows. When new windows are created by splits, new windows are
!  appended at the end of the list.
        subroutine gmshFltkSetCurrentWindow(
     &      windowIndex,
     &      ierr)
     &    bind(C, name = "gmshFltkSetCurrentWindow")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::windowIndex
            integer(c_int)::ierr
          end subroutine gmshFltkSetCurrentWindow

!  Set a status message in the current window. If `graphics' is set, display
!  the message inside the graphic window instead of the status bar.
        subroutine gmshFltkSetStatusMessage(
     &      message,
     &      graphics,
     &      ierr)
     &    bind(C, name = "gmshFltkSetStatusMessage")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::message(*)
            integer(c_int), value::graphics
            integer(c_int)::ierr
          end subroutine gmshFltkSetStatusMessage

!  Show context window for the entity of dimension `dim' and tag `tag'.
        subroutine gmshFltkShowContextWindow(
     &      dim,
     &      tag,
     &      ierr)
     &    bind(C, name = "gmshFltkShowContextWindow")
          use, intrinsic :: iso_c_binding
            integer(c_int), value::dim
            integer(c_int), value::tag
            integer(c_int)::ierr
          end subroutine gmshFltkShowContextWindow

!  Open the `name' item in the menu tree.
        subroutine gmshFltkOpenTreeItem(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshFltkOpenTreeItem")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshFltkOpenTreeItem

!  Close the `name' item in the menu tree.
        subroutine gmshFltkCloseTreeItem(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshFltkCloseTreeItem")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshFltkCloseTreeItem

!  Get the names of the variables in the Gmsh parser matching the `search'
!  regular expression. If `search' is empty, return all the names.
        subroutine gmshParserGetNames(
     &      names,
     &      names_n,
     &      search,
     &      ierr)
     &    bind(C, name = "gmshParserGetNames")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::names
            integer(c_size_t) :: names_n
            character(len = 1, kind = c_char)::search(*)
            integer(c_int)::ierr
          end subroutine gmshParserGetNames

!  Set the value of the number variable `name' in the Gmsh parser. Create the
!  variable if it does not exist; update the value if the variable exists.
        subroutine gmshParserSetNumber(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshParserSetNumber")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            real(c_double)::value(*)
            integer(c_size_t), value :: value_n
            integer(c_int)::ierr
          end subroutine gmshParserSetNumber

!  Set the value of the string variable `name' in the Gmsh parser. Create the
!  variable if it does not exist; update the value if the variable exists.
        subroutine gmshParserSetString(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshParserSetString")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr)::value(*)
            integer(c_size_t), value :: value_n
            integer(c_int)::ierr
          end subroutine gmshParserSetString

!  Get the value of the number variable `name' from the Gmsh parser. Return an
!  empty vector if the variable does not exist.
        subroutine gmshParserGetNumber(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshParserGetNumber")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr), intent(out)::value
            integer(c_size_t) :: value_n
            integer(c_int)::ierr
          end subroutine gmshParserGetNumber

!  Get the value of the string variable `name' from the Gmsh parser. Return an
!  empty vector if the variable does not exist.
        subroutine gmshParserGetString(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshParserGetString")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr), intent(out)::value
            integer(c_size_t) :: value_n
            integer(c_int)::ierr
          end subroutine gmshParserGetString

!  Clear all the Gmsh parser variables, or remove a single variable if `name'
!  is given.
        subroutine gmshParserClear(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshParserClear")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshParserClear

!  Parse the file `fileName' with the Gmsh parser.
        subroutine gmshParserParse(
     &      fileName,
     &      ierr)
     &    bind(C, name = "gmshParserParse")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::fileName(*)
            integer(c_int)::ierr
          end subroutine gmshParserParse

!  Set one or more parameters in the ONELAB database, encoded in `format'.
        subroutine gmshOnelabSet(
     &      data,
     &      format,
     &      ierr)
     &    bind(C, name = "gmshOnelabSet")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::data(*)
            character(len = 1, kind = c_char)::format(*)
            integer(c_int)::ierr
          end subroutine gmshOnelabSet

!  Get all the parameters (or a single one if `name' is specified) from the
!  ONELAB database, encoded in `format'.
        subroutine gmshOnelabGet(
     &      data,
     &      name,
     &      format,
     &      ierr)
     &    bind(C, name = "gmshOnelabGet")
          use, intrinsic :: iso_c_binding
            type(c_ptr)::data(*)
            character(len = 1, kind = c_char)::name(*)
            character(len = 1, kind = c_char)::format(*)
            integer(c_int)::ierr
          end subroutine gmshOnelabGet

!  Get the names of the parameters in the ONELAB database matching the
!  `search' regular expression. If `search' is empty, return all the names.
        subroutine gmshOnelabGetNames(
     &      names,
     &      names_n,
     &      search,
     &      ierr)
     &    bind(C, name = "gmshOnelabGetNames")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::names
            integer(c_size_t) :: names_n
            character(len = 1, kind = c_char)::search(*)
            integer(c_int)::ierr
          end subroutine gmshOnelabGetNames

!  Set the value of the number parameter `name' in the ONELAB database. Create
!  the parameter if it does not exist; update the value if the parameter
!  exists.
        subroutine gmshOnelabSetNumber(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshOnelabSetNumber")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            real(c_double)::value(*)
            integer(c_size_t), value :: value_n
            integer(c_int)::ierr
          end subroutine gmshOnelabSetNumber

!  Set the value of the string parameter `name' in the ONELAB database. Create
!  the parameter if it does not exist; update the value if the parameter
!  exists.
        subroutine gmshOnelabSetString(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshOnelabSetString")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr)::value(*)
            integer(c_size_t), value :: value_n
            integer(c_int)::ierr
          end subroutine gmshOnelabSetString

!  Get the value of the number parameter `name' from the ONELAB database.
!  Return an empty vector if the parameter does not exist.
        subroutine gmshOnelabGetNumber(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshOnelabGetNumber")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr), intent(out)::value
            integer(c_size_t) :: value_n
            integer(c_int)::ierr
          end subroutine gmshOnelabGetNumber

!  Get the value of the string parameter `name' from the ONELAB database.
!  Return an empty vector if the parameter does not exist.
        subroutine gmshOnelabGetString(
     &      name,
     &      value,
     &      value_n,
     &      ierr)
     &    bind(C, name = "gmshOnelabGetString")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            type(c_ptr), intent(out)::value
            integer(c_size_t) :: value_n
            integer(c_int)::ierr
          end subroutine gmshOnelabGetString

!  Check if any parameters in the ONELAB database used by the client `name'
!  have been changed.
        function gmshOnelabGetChanged(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshOnelabGetChanged")
          use, intrinsic :: iso_c_binding
          integer(c_int)::gmshOnelabGetChanged
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end function gmshOnelabGetChanged

!  Set the changed flag to value `value' for all the parameters in the ONELAB
!  database used by the client `name'.
        subroutine gmshOnelabSetChanged(
     &      name,
     &      value,
     &      ierr)
     &    bind(C, name = "gmshOnelabSetChanged")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int), value::value
            integer(c_int)::ierr
          end subroutine gmshOnelabSetChanged

!  Clear the ONELAB database, or remove a single parameter if `name' is given.
        subroutine gmshOnelabClear(
     &      name,
     &      ierr)
     &    bind(C, name = "gmshOnelabClear")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            integer(c_int)::ierr
          end subroutine gmshOnelabClear

!  Run a ONELAB client. If `name' is provided, create a new ONELAB client with
!  name `name' and executes `command'. If not, try to run a client that might
!  be linked to the processed input files.
        subroutine gmshOnelabRun(
     &      name,
     &      command,
     &      ierr)
     &    bind(C, name = "gmshOnelabRun")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::name(*)
            character(len = 1, kind = c_char)::command(*)
            integer(c_int)::ierr
          end subroutine gmshOnelabRun

!  Write a `message'. `level' can be "info", "warning" or "error".
        subroutine gmshLoggerWrite(
     &      message,
     &      level,
     &      ierr)
     &    bind(C, name = "gmshLoggerWrite")
          use, intrinsic :: iso_c_binding
            character(len = 1, kind = c_char)::message(*)
            character(len = 1, kind = c_char)::level(*)
            integer(c_int)::ierr
          end subroutine gmshLoggerWrite

!  Start logging messages.
        subroutine gmshLoggerStart(
     &      ierr)
     &    bind(C, name = "gmshLoggerStart")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshLoggerStart

!  Get logged messages.
        subroutine gmshLoggerGet(
     &      log,
     &      log_n,
     &      ierr)
     &    bind(C, name = "gmshLoggerGet")
          use, intrinsic :: iso_c_binding
            type(c_ptr), intent(out)::log
            integer(c_size_t) :: log_n
            integer(c_int)::ierr
          end subroutine gmshLoggerGet

!  Stop logging messages.
        subroutine gmshLoggerStop(
     &      ierr)
     &    bind(C, name = "gmshLoggerStop")
          use, intrinsic :: iso_c_binding
            integer(c_int)::ierr
          end subroutine gmshLoggerStop

!  Return wall clock time.
        function gmshLoggerGetWallTime(
     &      ierr)
     &    bind(C, name = "gmshLoggerGetWallTime")
          use, intrinsic :: iso_c_binding
          real(c_double)::gmshLoggerGetWallTime
            integer(c_int)::ierr
          end function gmshLoggerGetWallTime

!  Return CPU time.
        function gmshLoggerGetCpuTime(
     &      ierr)
     &    bind(C, name = "gmshLoggerGetCpuTime")
          use, intrinsic :: iso_c_binding
          real(c_double)::gmshLoggerGetCpuTime
            integer(c_int)::ierr
          end function gmshLoggerGetCpuTime

!  Return last error message, if any.
        subroutine gmshLoggerGetLastError(
     &      error,
     &      ierr)
     &    bind(C, name = "gmshLoggerGetLastError")
          use, intrinsic :: iso_c_binding
            type(c_ptr)::error(*)
            integer(c_int)::ierr
          end subroutine gmshLoggerGetLastError

        end interface
      end module gmsh_fortran

!DEC$ ENDIF
