/**********************************************************************
 *
 * platform.h - generated by CMake from platform.h.cmake
 *
 * GEOS - Geometry Engine Open Source
 * http://geos.osgeo.org
 *
 * Copyright (C) 2018 Vicky Vergara
 * Copyright (C) 2009 Mateusz Loskot
 * Copyright (C) 2005-2009 Refractions Research Inc.
 * Copyright (C) 2001-2009 Vivid Solutions Inc.
 *
 * This is free software; you can redistribute and/or modify it under
 * the terms of the GNU Lesser General Public Licence as published
 * by the Free Software Foundation.
 * See the COPYING file for more information.
 *
 *********************************************************************/

#ifndef GEOS_PLATFORM_H_INCLUDED
#define GEOS_PLATFORM_H_INCLUDED

#ifdef _MSC_VER
#ifndef NOMINMAX
#define NOMINMAX 1
#endif
#endif

/* Disable inclusion of platform.h not generated by CMake */
#define GEOS_PLATFORM_H 1

/* Set to 1 if you have ieeefp.h */
/* #undef HAVE_IEEEFP_H */

#ifdef _MSC_VER
#  define _USE_MATH_DEFINES
#endif
#include <cmath>
#include <limits>
#include <cinttypes>



#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

typedef int64_t int64;


#if defined(_MSC_VER) && _MSC_VER >= 1200 // VC++ 6.0 and above
#  include <float.h>
#  ifndef FINITE
#    define FINITE(x) _finite(x)
#  endif
#  ifndef ISNAN
#    define ISNAN(x) _isnan(x)
#  endif
#elif !defined(HAVE_IEEEFP_H)
#  include <cmath>
#  ifndef FINITE
#    define FINITE(x) std::isfinite(x)
#  endif
#  ifndef ISNAN
#    define ISNAN(x) std::isnan(x)
#  endif
#else
#  include <ieeefp.h>
#  ifndef FINITE
#    define FINITE(x) finite(x)
#  endif
#  ifndef ISNAN
#    define ISNAN(x) isnan(x)
#  endif
#endif


// Some handy constants
constexpr double DoubleNotANumber = std::numeric_limits<double>::quiet_NaN();
constexpr double DoubleMax = (std::numeric_limits<double>::max)();
constexpr double DoubleInfinity = (std::numeric_limits<double>::infinity)();
constexpr double DoubleNegInfinity = (-(std::numeric_limits<double>::infinity)());



#endif // GEOS_PLATFORM_H_INCLUDED
