import numpy as np

from ..triangulation import Triangulation2D

"""
    15  28----------29----------30----------31
         |\         /|\         /|\         /|
         | \  33   / | \  36   / | \  39   / |
    14   |  \     /  |  \     /  |  \     /  |
         |32 \   / 34|35 \   / 37|38 \   / 40|
         |    \ /    |    \ /    |    \ /    |
    13  21----22----23----24----25----26----27
         |28 / |29 / |           | \ 30| \ 31|
         | / 12| / 13|           | 14\ | 15\ |
    12  14----15----16----17----18----19----20
         |22 / |23 / |24 / | \ 25| \ 26| \ 27|
         | / 6 | / 7 | / 8 |9  \ |10 \ |11 \ |
    11   7-----8-----9----10----11----12----13
         |16 / |17 / |18 / | \ 19| \ 20| \ 21|
         | / 0 | / 1 | / 2 |3  \ |4  \ |5  \ |
    10   0-----1-----2-----3-----4-----5-----6

         0     1     2     3     4     5     6
"""

NV = 32
NT = 41

NB = 23
NI = 50
NE = 73

x = np.array([
    0, 1, 2, 3, 4, 5, 6,  # Vertices  0 to  6
    0, 1, 2, 3, 4, 5, 6,  # Vertices  7 to 13
    0, 1, 2, 3, 4, 5, 6,  # Vertices 14 to 20
    0, 1, 2, 3, 4, 5, 6,  # Vertices 21 to 27
    0, 2, 4, 6,           # Vertices 28 to 31
], dtype='d')

y = np.array([
   10, 10, 10, 10, 10, 10, 10,  # Vertices  0 to  6
   11, 11, 11, 11, 11, 11, 11,  # Vertices  7 to 13
   12, 12, 12, 12, 12, 12, 12,  # Vertices 14 to 20
   13, 13, 13, 13, 13, 13, 13,  # Vertices 21 to 27
   15, 15, 15, 15,              # Vertices 28 to 31
], dtype='d')

trivtx = np.array([
    [ 0,  1,  8], [ 1,  2,  9], [ 2,  3, 10],  # Triangles  0 to  2
    [ 3,  4, 10], [ 4,  5, 11], [ 5,  6 ,12],  # Triangles  3 to  5
    [ 7,  8, 15], [ 8,  9, 16], [ 9, 10, 17],  # Triangles  6 to  8
    [10, 11, 17], [11, 12, 18], [12, 13, 19],  # Triangles  9 to 11
    [14, 15, 22], [15, 16, 23],                # Triangles 12 to 13
    [18, 19, 25], [19, 20, 26],                # Triangles 14 to 15
    [ 0,  8,  7], [ 1,  9,  8], [ 2, 10,  9],  # Triangles 16 to 18
    [ 4, 11, 10], [ 5, 12, 11], [ 6, 13, 12],  # Triangles 19 to 21
    [ 7, 15, 14], [ 8, 16, 15], [ 9, 17, 16],  # Triangles 22 to 24
    [11, 18, 17], [12, 19, 18], [13, 20, 19],  # Triangles 25 to 27
    [14, 22, 21], [15, 23, 22],                # Triangles 28 to 29
    [19, 26, 25], [20, 27, 26],                # Triangles 30 to 31
    [21, 22, 28], [22, 29, 28], [22, 23, 29],  # Triangles 32 to 34
    [23, 24, 29], [24, 30, 29], [24, 25, 30],  # Triangles 35 to 37
    [25, 26, 30], [26, 31, 30], [26, 27, 31],  # Triangles 38 to 40
], dtype='int32')

triangulation = Triangulation2D(x, y, trivtx)

boundary_edge_label = np.array([
    [0, 1, 1], [1, 2, 1], [2, 3, 1], [3, 4, 1],
    [4, 5, 1], [5, 6, 1],                              # bottom : label=1
    [6, 13, 2], [13, 20, 2], [20, 27, 2], [27, 31, 2], # right  : label=2
    [31, 30, 3], [30, 29, 3], [29, 28, 3],             # top    : label=3
    [28, 21, 2], [21, 14, 2], [14, 7, 2], [7, 0, 2],   # left   : label=2
    [16, 17, 4], [17, 18, 4], [18, 25, 4],
    [25, 24, 4], [24, 23, 3], [23, 16, 4]              # hole   : label=4
], dtype='int32')
