# Copyright (c) 2009 Chris Moyer http://coredumped.org/
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish, dis-
# tribute, sublicense, and/or sell copies of the Software, and to permit
# persons to whom the Software is furnished to do so, subject to the fol-
# lowing conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABIL-
# ITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT
# SHALL THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS

#
# Task/Job Administration utility
#
VERSION="0.1"
__version__ = VERSION
usage = """%prog [options] [command]
Commands:
    list|ls                                List all Tasks in SDB
    delete      <id>                       Delete Task with id <id>
    get         <name>                     Get Task <name>
    create|mk   <name> <hour> <command>    Create a new Task <name> with command <command> running every <hour>
"""

def list():
    """List all Tasks in SDB"""
    from boto.manage.task import Task
    print "%-8s %-40s %s" %  ("Hour", "Name", "Command")
    print "-"*100
    for t in Task.all():
        print "%-8s %-40s %s" % (t.hour, t.name, t.command)

def get(name):
    """Get a task
    :param name: The name of the task to fetch
    :type name: str
    """
    from boto.manage.task import Task
    q = Task.find()
    q.filter("name like", "%s%%" % name)
    for t in q:
        print "="*80
        print "|               ", t.id
        print "|%s" %  ("-"*79)
        print "| Name:         ", t.name
        print "| Hour:         ", t.hour
        print "| Command:      ", t.command
        if t.last_executed:
            print "| Last Run:     ", t.last_executed.ctime()
            print "| Last Status:  ", t.last_status
            print "| Last Run Log: ", t.last_output
        print "="*80

def delete(id):
    from boto.manage.task import Task
    t = Task.get_by_id(id)
    print "Deleting task: %s" % t.name
    if raw_input("Are you sure? ").lower() in ["y", "yes"]:
        t.delete()
        print "Deleted"
    else:
        print "Canceled"

def create(name, hour, command):
    """Create a new task
    :param name: Name of the task to create
    :type name: str
    :param hour: What hour to run it at, "*" for every hour
    :type hour: str
    :param command: The command to execute
    :type command: str
    """
    from boto.manage.task import Task
    t = Task()
    t.name = name
    t.hour = hour
    t.command = command
    t.put()
    print "Created task: %s" % t.id

if __name__ == "__main__":
    try:
        import readline
    except ImportError:
        pass
    import boto
    import sys
    from optparse import OptionParser
    from boto.mashups.iobject import IObject
    parser = OptionParser(version=__version__, usage=usage)

    (options, args) = parser.parse_args()

    if len(args) < 1:
        parser.print_help()
        sys.exit(1)

    command = args[0].lower()
    if command in ("ls", "list"):
        list()
    elif command == "get":
        get(args[1])
    elif command == "create":
        create(args[1], args[2], args[3])
    elif command == "delete":
        delete(args[1])
