
import sys
from optparse import OptionParser

import boto
from boto.ec2 import regions



def kill_instance(region, ids):
    """Kill an instances given it's instance IDs"""
    # Connect the region
    ec2 = boto.connect_ec2(region=region)
    for instance_id in ids:
        print("Stopping instance: %s" % instance_id)
        ec2.terminate_instances([instance_id])


if __name__ == "__main__":
    parser = OptionParser(usage="kill_instance [-r] id [id ...]")
    parser.add_option("-r", "--region", help="Region (default us-east-1)", dest="region", default="us-east-1")
    (options, args) = parser.parse_args()
    if not args:
        parser.print_help()
        sys.exit(1)
    for r in regions():
        if r.name == options.region:
            region = r
            break
    else:
        print("Region %s not found." % options.region)
        sys.exit(1)

    kill_instance(region, args)
