#!/bin/bash

mkdir build
cd build

BUILD_CONFIG=Release

cmake .. -G "Ninja" \
    -Wno-dev \
    -DCMAKE_BUILD_TYPE=$BUILD_CONFIG \
    -DCMAKE_PREFIX_PATH=${PREFIX} \
    -DCMAKE_INSTALL_PREFIX:PATH="$PREFIX" \
    -DCMAKE_INSTALL_RPATH:PATH="$PREFIX/lib" \
    -DGDCM_BUILD_SHARED_LIBS:BOOL=ON \
    -DGDCM_BUILD_APPLICATIONS:BOOL=ON \
    -DGDCM_BUILD_TESTING:BOOL=OFF \
    -DGDCM_BUILD_EXAMPLES:BOOL=OFF \
    -DGDCM_BUILD_APPLICATIONS=OFF \
    -DGDCM_USE_VTK:BOOL=OFF \
    -DGDCM_WRAP_PYTHON:BOOL=ON \
    -DGDCM_DOCUMENTATION:BOOL=OFF \
    -DGDCM_BUILD_DOCBOOK_MANPAGES:BOOL=OFF \
    -DSWIG_EXECUTABLE:FILEPATH=$PREFIX/bin/swig \
    -DGDCM_INSTALL_PYTHONMODULE_DIR:PATH=$SP_DIR \
    -DGDCM_INSTALL_NO_DOCUMENTATION:BOOL=ON \
    -DGDCM_INSTALL_NO_DEVELOPMENT:BOOL=ON

ninja install
