# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_gdal')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_gdal')
    _gdal = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_gdal', [dirname(__file__)])
        except ImportError:
            import _gdal
            return _gdal
        try:
            _mod = imp.load_module('_gdal', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _gdal = swig_import_helper()
    del swig_import_helper
else:
    import _gdal
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0




have_warned = 0
def deprecation_warn(module, sub_package=None, new_module=None):
    global have_warned

    if have_warned == 1:
        return

    have_warned = 1
    if sub_package is None or sub_package == 'utils':
        sub_package = 'osgeo_utils'
    if new_module is None:
        new_module = module
    new_module = '{}.{}'.format(sub_package, new_module)

    from warnings import warn
    warn('{}.py was placed in a namespace, it is now available as {}' .format(module, new_module),
       DeprecationWarning)


from osgeo.gdalconst import *
from osgeo import gdalconst


import sys
byteorders = {"little": "<",
              "big": ">"}
array_modes = { gdalconst.GDT_Int16:    ("%si2" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt16:   ("%su2" % byteorders[sys.byteorder]),
                gdalconst.GDT_Int32:    ("%si4" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt32:   ("%su4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float32:  ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float64:  ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat32: ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat64: ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_Byte:     ("%st8" % byteorders[sys.byteorder]),
}

def RGBFile2PCTFile( src_filename, dst_filename ):
  src_ds = Open(src_filename)
  if src_ds is None or src_ds == 'NULL':
      return 1

  ct = ColorTable()
  err = ComputeMedianCutPCT(src_ds.GetRasterBand(1),
                            src_ds.GetRasterBand(2),
                            src_ds.GetRasterBand(3),
                            256, ct)
  if err != 0:
      return err

  gtiff_driver = GetDriverByName('GTiff')
  if gtiff_driver is None:
      return 1

  dst_ds = gtiff_driver.Create(dst_filename,
                               src_ds.RasterXSize, src_ds.RasterYSize)
  dst_ds.GetRasterBand(1).SetRasterColorTable(ct)

  err = DitherRGB2PCT(src_ds.GetRasterBand(1),
                      src_ds.GetRasterBand(2),
                      src_ds.GetRasterBand(3),
                      dst_ds.GetRasterBand(1),
                      ct)
  dst_ds = None
  src_ds = None

  return 0

def listdir(path, recursionLevel = -1, options = []):
  """ Iterate over a directory.

      recursionLevel = -1 means unlimited level of recursion.
  """
  dir = OpenDir(path, recursionLevel, options)
  if not dir:
      raise OSError(path + ' does not exist')
  try:
      while True:
          entry = GetNextDirEntry(dir)
          if not entry:
              break
          yield entry
  finally:
      CloseDir(dir)


def GetUseExceptions(*args):
    """GetUseExceptions() -> int"""
    return _gdal.GetUseExceptions(*args)

def UseExceptions(*args):
    """UseExceptions()"""
    return _gdal.UseExceptions(*args)

def DontUseExceptions(*args):
    """DontUseExceptions()"""
    return _gdal.DontUseExceptions(*args)

def VSIFReadL(*args):
    """VSIFReadL(unsigned int nMembSize, unsigned int nMembCount, VSILFILE fp) -> unsigned int"""
    return _gdal.VSIFReadL(*args)

def VSIGetMemFileBuffer_unsafe(*args):
    """VSIGetMemFileBuffer_unsafe(char const * utf8_path)"""
    return _gdal.VSIGetMemFileBuffer_unsafe(*args)


def InfoOptions(options=None, format='text', deserialize=True,
         computeMinMax=False, reportHistograms=False, reportProj4=False,
         stats=False, approxStats=False, computeChecksum=False,
         showGCPs=True, showMetadata=True, showRAT=True, showColorTable=True,
         listMDD=False, showFileList=True, allMetadata=False,
         extraMDDomains=None, wktFormat=None):
    """ Create a InfoOptions() object that can be passed to gdal.Info()
        options can be be an array of strings, a string or let empty and filled from other keywords."""

    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
        format = 'text'
        if '-json' in new_options:
            format = 'json'
    else:
        new_options = options
        if format == 'json':
            new_options += ['-json']
        if '-json' in new_options:
            format = 'json'
        if computeMinMax:
            new_options += ['-mm']
        if reportHistograms:
            new_options += ['-hist']
        if reportProj4:
            new_options += ['-proj4']
        if stats:
            new_options += ['-stats']
        if approxStats:
            new_options += ['-approx_stats']
        if computeChecksum:
            new_options += ['-checksum']
        if not showGCPs:
            new_options += ['-nogcp']
        if not showMetadata:
            new_options += ['-nomd']
        if not showRAT:
            new_options += ['-norat']
        if not showColorTable:
            new_options += ['-noct']
        if listMDD:
            new_options += ['-listmdd']
        if not showFileList:
            new_options += ['-nofl']
        if allMetadata:
            new_options += ['-mdd', 'all']
        if wktFormat:
            new_options += ['-wkt_format', wktFormat]
        if extraMDDomains is not None:
            for mdd in extraMDDomains:
                new_options += ['-mdd', mdd]

    return (GDALInfoOptions(new_options), format, deserialize)

def Info(ds, **kwargs):
    """ Return information on a dataset.
        Arguments are :
          ds --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.InfoOptions(), string or array of strings
          other keywords arguments of gdal.InfoOptions()
        If options is provided as a gdal.InfoOptions() object, other keywords are ignored. """
    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, format, deserialize) = InfoOptions(**kwargs)
    else:
        (opts, format, deserialize) = kwargs['options']
    if isinstance(ds, str):
        ds = Open(ds)
    ret = InfoInternal(ds, opts)
    if format == 'json' and deserialize:
        import json
        ret = json.loads(ret)
    return ret


def MultiDimInfoOptions(options=None, detailed=False, array=None, arrayoptions=None, limit=None, as_text=False):
    """ Create a MultiDimInfoOptions() object that can be passed to gdal.MultiDimInfo()
        options can be be an array of strings, a string or let empty and filled from other keywords."""

    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if detailed:
            new_options += ['-detailed']
        if array:
            new_options += ['-array', array]
        if limit:
            new_options += ['-limit', str(limit)]
        if arrayoptions:
            for option in arrayoptions:
                new_options += ['-arrayoption', option]

    return GDALMultiDimInfoOptions(new_options), as_text

def MultiDimInfo(ds, **kwargs):
    """ Return information on a dataset.
        Arguments are :
          ds --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.MultiDimInfoOptions(), string or array of strings
          other keywords arguments of gdal.MultiDimInfoOptions()
        If options is provided as a gdal.MultiDimInfoOptions() object, other keywords are ignored. """
    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        opts, as_text = MultiDimInfoOptions(**kwargs)
    else:
        opts = kwargs['options']
        as_text = True
    if isinstance(ds, str):
        ds = OpenEx(ds, OF_VERBOSE_ERROR | OF_MULTIDIM_RASTER)
    ret = MultiDimInfoInternal(ds, opts)
    if not as_text:
        import json
        ret = json.loads(ret)
    return ret


def _strHighPrec(x):
    return x if isinstance(x, str) else '%.18g' % x

def TranslateOptions(options=None, format=None,
              outputType = gdalconst.GDT_Unknown, bandList=None, maskBand=None,
              width = 0, height = 0, widthPct = 0.0, heightPct = 0.0,
              xRes = 0.0, yRes = 0.0,
              creationOptions=None, srcWin=None, projWin=None, projWinSRS=None, strict = False,
              unscale = False, scaleParams=None, exponents=None,
              outputBounds=None, metadataOptions=None,
              outputSRS=None, nogcp=False, GCPs=None,
              noData=None, rgbExpand=None,
              stats = False, rat = True, resampleAlg=None,
              callback=None, callback_data=None):
    """ Create a TranslateOptions() object that can be passed to gdal.Translate()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputType --- output type (gdalconst.GDT_Byte, etc...)
          bandList --- array of band numbers (index start at 1)
          maskBand --- mask band to generate or not ("none", "auto", "mask", 1, ...)
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          widthPct --- width of the output raster in percentage (100 = original width)
          heightPct --- height of the output raster in percentage (100 = original height)
          xRes --- output horizontal resolution
          yRes --- output vertical resolution
          creationOptions --- list of creation options
          srcWin --- subwindow in pixels to extract: [left_x, top_y, width, height]
          projWin --- subwindow in projected coordinates to extract: [ulx, uly, lrx, lry]
          projWinSRS --- SRS in which projWin is expressed
          strict --- strict mode
          unscale --- unscale values with scale and offset metadata
          scaleParams --- list of scale parameters, each of the form [src_min,src_max] or [src_min,src_max,dst_min,dst_max]
          exponents --- list of exponentiation parameters
          outputBounds --- assigned output bounds: [ulx, uly, lrx, lry]
          metadataOptions --- list of metadata options
          outputSRS --- assigned output SRS
          nogcp --- ignore GCP in the raster
          GCPs --- list of GCPs
          noData --- nodata value (or "none" to unset it)
          rgbExpand --- Color palette expansion mode: "gray", "rgb", "rgba"
          stats --- whether to calculate statistics
          rat --- whether to write source RAT
          resampleAlg --- resampling mode
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if maskBand != None:
            new_options += ['-mask', str(maskBand)]
        if bandList != None:
            for b in bandList:
                new_options += ['-b', str(b)]
        if width != 0 or height != 0:
            new_options += ['-outsize', str(width), str(height)]
        elif widthPct != 0 and heightPct != 0:
            new_options += ['-outsize', str(widthPct) + '%%', str(heightPct) + '%%']
        if creationOptions is not None:
            if isinstance(creationOptions, str):
                new_options += ['-co', creationOptions]
            else:
                for opt in creationOptions:
                    new_options += ['-co', opt]
        if srcWin is not None:
            new_options += ['-srcwin', _strHighPrec(srcWin[0]), _strHighPrec(srcWin[1]), _strHighPrec(srcWin[2]), _strHighPrec(srcWin[3])]
        if strict:
            new_options += ['-strict']
        if unscale:
            new_options += ['-unscale']
        if scaleParams:
            for scaleParam in scaleParams:
                new_options += ['-scale']
                for v in scaleParam:
                    new_options += [str(v)]
        if exponents:
            for exponent in exponents:
                new_options += ['-exponent', _strHighPrec(exponent)]
        if outputBounds is not None:
            new_options += ['-a_ullr', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if metadataOptions is not None:
            if isinstance(metadataOptions, str):
                new_options += ['-mo', metadataOptions]
            else:
                for opt in metadataOptions:
                    new_options += ['-mo', opt]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if nogcp:
            new_options += ['-nogcp']
        if GCPs is not None:
            for gcp in GCPs:
                new_options += ['-gcp', _strHighPrec(gcp.GCPPixel), _strHighPrec(gcp.GCPLine), _strHighPrec(gcp.GCPX), str(gcp.GCPY), _strHighPrec(gcp.GCPZ)]
        if projWin is not None:
            new_options += ['-projwin', _strHighPrec(projWin[0]), _strHighPrec(projWin[1]), _strHighPrec(projWin[2]), _strHighPrec(projWin[3])]
        if projWinSRS is not None:
            new_options += ['-projwin_srs', str(projWinSRS)]
        if noData is not None:
            new_options += ['-a_nodata', _strHighPrec(noData)]
        if rgbExpand is not None:
            new_options += ['-expand', str(rgbExpand)]
        if stats:
            new_options += ['-stats']
        if not rat:
            new_options += ['-norat']
        if resampleAlg is not None:
            if resampleAlg == gdalconst.GRA_NearestNeighbour:
                new_options += ['-r', 'near']
            elif resampleAlg == gdalconst.GRA_Bilinear:
                new_options += ['-r', 'bilinear']
            elif resampleAlg == gdalconst.GRA_Cubic:
                new_options += ['-r', 'cubic']
            elif resampleAlg == gdalconst.GRA_CubicSpline:
                new_options += ['-r', 'cubicspline']
            elif resampleAlg == gdalconst.GRA_Lanczos:
                new_options += ['-r', 'lanczos']
            elif resampleAlg == gdalconst.GRA_Average:
                new_options += ['-r', 'average']
            elif resampleAlg == gdalconst.GRA_RMS:
                new_options += ['-r', 'rms']
            elif resampleAlg == gdalconst.GRA_Mode:
                new_options += ['-r', 'mode']
            else:
                new_options += ['-r', str(resampleAlg)]
        if xRes != 0 and yRes != 0:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]

    return (GDALTranslateOptions(new_options), callback, callback_data)

def Translate(destName, srcDS, **kwargs):
    """ Convert a dataset.
        Arguments are :
          destName --- Output dataset name
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.TranslateOptions(), string or array of strings
          other keywords arguments of gdal.TranslateOptions()
        If options is provided as a gdal.TranslateOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = TranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDS, str):
        srcDS = Open(srcDS)

    return TranslateInternal(destName, srcDS, opts, callback, callback_data)

def WarpOptions(options=None, format=None,
         outputBounds=None,
         outputBoundsSRS=None,
         xRes=None, yRes=None, targetAlignedPixels = False,
         width = 0, height = 0,
         srcSRS=None, dstSRS=None,
         coordinateOperation=None,
         srcAlpha = False, dstAlpha = False,
         warpOptions=None, errorThreshold=None,
         warpMemoryLimit=None, creationOptions=None, outputType = gdalconst.GDT_Unknown,
         workingType = gdalconst.GDT_Unknown, resampleAlg=None,
         srcNodata=None, dstNodata=None, multithread = False,
         tps = False, rpc = False, geoloc = False, polynomialOrder=None,
         transformerOptions=None, cutlineDSName=None,
         cutlineLayer=None, cutlineWhere=None, cutlineSQL=None, cutlineBlend=None, cropToCutline = False,
         copyMetadata = True, metadataConflictValue=None,
         setColorInterpretation = False,
         overviewLevel = 'AUTO',
         callback=None, callback_data=None):
    """ Create a WarpOptions() object that can be passed to gdal.Warp()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputBounds --- output bounds as (minX, minY, maxX, maxY) in target SRS
          outputBoundsSRS --- SRS in which output bounds are expressed, in the case they are not expressed in dstSRS
          xRes, yRes --- output resolution in target SRS
          targetAlignedPixels --- whether to force output bounds to be multiple of output resolution
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          srcSRS --- source SRS
          dstSRS --- output SRS
          coordinateOperation -- coordinate operation as a PROJ string or WKT string
          srcAlpha --- whether to force the last band of the input dataset to be considered as an alpha band
          dstAlpha --- whether to force the creation of an output alpha band
          outputType --- output type (gdalconst.GDT_Byte, etc...)
          workingType --- working type (gdalconst.GDT_Byte, etc...)
          warpOptions --- list of warping options
          errorThreshold --- error threshold for approximation transformer (in pixels)
          warpMemoryLimit --- size of working buffer in MB
          resampleAlg --- resampling mode
          creationOptions --- list of creation options
          srcNodata --- source nodata value(s)
          dstNodata --- output nodata value(s)
          multithread --- whether to multithread computation and I/O operations
          tps --- whether to use Thin Plate Spline GCP transformer
          rpc --- whether to use RPC transformer
          geoloc --- whether to use GeoLocation array transformer
          polynomialOrder --- order of polynomial GCP interpolation
          transformerOptions --- list of transformer options
          cutlineDSName --- cutline dataset name
          cutlineLayer --- cutline layer name
          cutlineWhere --- cutline WHERE clause
          cutlineSQL --- cutline SQL statement
          cutlineBlend --- cutline blend distance in pixels
          cropToCutline --- whether to use cutline extent for output bounds
          copyMetadata --- whether to copy source metadata
          metadataConflictValue --- metadata data conflict value
          setColorInterpretation --- whether to force color interpretation of input bands to output bands
          overviewLevel --- To specify which overview level of source files must be used
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if workingType != gdalconst.GDT_Unknown:
            new_options += ['-wt', GetDataTypeName(workingType)]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if outputBoundsSRS is not None:
            new_options += ['-te_srs', str(outputBoundsSRS)]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if width != 0 or height != 0:
            new_options += ['-ts', str(width), str(height)]
        if srcSRS is not None:
            new_options += ['-s_srs', str(srcSRS)]
        if dstSRS is not None:
            new_options += ['-t_srs', str(dstSRS)]
        if coordinateOperation is not None:
            new_options += ['-ct', coordinateOperation]
        if targetAlignedPixels:
            new_options += ['-tap']
        if srcAlpha:
            new_options += ['-srcalpha']
        if dstAlpha:
            new_options += ['-dstalpha']
        if warpOptions is not None:
            for opt in warpOptions:
                new_options += ['-wo', str(opt)]
        if errorThreshold is not None:
            new_options += ['-et', _strHighPrec(errorThreshold)]
        if resampleAlg is not None:
            if resampleAlg == gdalconst.GRIORA_NearestNeighbour:
                new_options += ['-r', 'near']
            elif resampleAlg == gdalconst.GRIORA_Bilinear:
                new_options += ['-rb']
            elif resampleAlg == gdalconst.GRIORA_Cubic:
                new_options += ['-rc']
            elif resampleAlg == gdalconst.GRIORA_CubicSpline:
                new_options += ['-rcs']
            elif resampleAlg == gdalconst.GRIORA_Lanczos:
                new_options += ['-r', 'lanczos']
            elif resampleAlg == gdalconst.GRIORA_Average:
                new_options += ['-r', 'average']
            elif resampleAlg == gdalconst.GRIORA_RMS:
                new_options += ['-r', 'rms']
            elif resampleAlg == gdalconst.GRIORA_Mode:
                new_options += ['-r', 'mode']
            elif resampleAlg == gdalconst.GRIORA_Gauss:
                new_options += ['-r', 'gauss']
            else:
                new_options += ['-r', str(resampleAlg)]
        if warpMemoryLimit is not None:
            new_options += ['-wm', str(warpMemoryLimit)]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt]
        if srcNodata is not None:
            new_options += ['-srcnodata', str(srcNodata)]
        if dstNodata is not None:
            new_options += ['-dstnodata', str(dstNodata)]
        if multithread:
            new_options += ['-multi']
        if tps:
            new_options += ['-tps']
        if rpc:
            new_options += ['-rpc']
        if geoloc:
            new_options += ['-geoloc']
        if polynomialOrder is not None:
            new_options += ['-order', str(polynomialOrder)]
        if transformerOptions is not None:
            for opt in transformerOptions:
                new_options += ['-to', opt]
        if cutlineDSName is not None:
            new_options += ['-cutline', str(cutlineDSName)]
        if cutlineLayer is not None:
            new_options += ['-cl', str(cutlineLayer)]
        if cutlineWhere is not None:
            new_options += ['-cwhere', str(cutlineWhere)]
        if cutlineSQL is not None:
            new_options += ['-csql', str(cutlineSQL)]
        if cutlineBlend is not None:
            new_options += ['-cblend', str(cutlineBlend)]
        if cropToCutline:
            new_options += ['-crop_to_cutline']
        if not copyMetadata:
            new_options += ['-nomd']
        if metadataConflictValue:
            new_options += ['-cvmd', str(metadataConflictValue)]
        if setColorInterpretation:
            new_options += ['-setci']

        if overviewLevel is None or isinstance(overviewLevel, str):
            pass
        elif isinstance(overviewLevel, int):
            if overviewLevel < 0:
                overviewLevel = 'AUTO' + str(overviewLevel)
            else:
                overviewLevel = str(overviewLevel)
        else:
            overviewLevel = None

        if overviewLevel:
            new_options += ['-ovr', overviewLevel]

    return (GDALWarpAppOptions(new_options), callback, callback_data)

def Warp(destNameOrDestDS, srcDSOrSrcDSTab, **kwargs):
    """ Warp one or several datasets.
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDSOrSrcDSTab --- an array of Dataset objects or filenames, or a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.WarpOptions(), string or array of strings
          other keywords arguments of gdal.WarpOptions()
        If options is provided as a gdal.WarpOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = WarpOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDSOrSrcDSTab, str):
        srcDSTab = [Open(srcDSOrSrcDSTab)]
    elif isinstance(srcDSOrSrcDSTab, list):
        srcDSTab = []
        for elt in srcDSOrSrcDSTab:
            if isinstance(elt, str):
                srcDSTab.append(Open(elt))
            else:
                srcDSTab.append(elt)
    else:
        srcDSTab = [srcDSOrSrcDSTab]

    if isinstance(destNameOrDestDS, str):
        return wrapper_GDALWarpDestName(destNameOrDestDS, srcDSTab, opts, callback, callback_data)
    else:
        return wrapper_GDALWarpDestDS(destNameOrDestDS, srcDSTab, opts, callback, callback_data)


def VectorTranslateOptions(options=None, format=None,
         accessMode=None,
         srcSRS=None, dstSRS=None, reproject=True,
         coordinateOperation=None,
         SQLStatement=None, SQLDialect=None, where=None, selectFields=None,
         addFields=False,
         forceNullable=False,
         emptyStrAsNull=False,
         spatFilter=None, spatSRS=None,
         datasetCreationOptions=None,
         layerCreationOptions=None,
         layers=None,
         layerName=None,
         geometryType=None,
         dim=None,
         segmentizeMaxDist= None,
         makeValid=False,
         zField=None,
         resolveDomains=False,
         skipFailures=False,
         limit=None,
         callback=None, callback_data=None):
    """ Create a VectorTranslateOptions() object that can be passed to gdal.VectorTranslate()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("ESRI Shapefile", etc...)
          accessMode --- None for creation, 'update', 'append', 'overwrite'
          srcSRS --- source SRS
          dstSRS --- output SRS (with reprojection if reproject = True)
          coordinateOperation -- coordinate operation as a PROJ string or WKT string
          reproject --- whether to do reprojection
          SQLStatement --- SQL statement to apply to the source dataset
          SQLDialect --- SQL dialect ('OGRSQL', 'SQLITE', ...)
          where --- WHERE clause to apply to source layer(s)
          selectFields --- list of fields to select
          addFields --- whether to add new fields found in source layers (to be used with accessMode == 'append')
          forceNullable --- whether to drop NOT NULL constraints on newly created fields
          emptyStrAsNull --- whether to treat empty string values as NULL
          spatFilter --- spatial filter as (minX, minY, maxX, maxY) bounding box
          spatSRS --- SRS in which the spatFilter is expressed. If not specified, it is assumed to be the one of the layer(s)
          datasetCreationOptions --- list of dataset creation options
          layerCreationOptions --- list of layer creation options
          layers --- list of layers to convert
          layerName --- output layer name
          geometryType --- output layer geometry type ('POINT', ....)
          dim --- output dimension ('XY', 'XYZ', 'XYM', 'XYZM', 'layer_dim')
          segmentizeMaxDist --- maximum distance between consecutive nodes of a line geometry
          makeValid --- run MakeValid() on geometries
          zField --- name of field to use to set the Z component of geometries
          resolveDomains --- whether to create an additional field for each field associated with a coded field domain.
          skipFailures --- whether to skip failures
          limit -- maximum number of features to read per layer
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-f', format]
        if srcSRS is not None:
            new_options += ['-s_srs', str(srcSRS)]
        if dstSRS is not None:
            if reproject:
                new_options += ['-t_srs', str(dstSRS)]
            else:
                new_options += ['-a_srs', str(dstSRS)]
        if coordinateOperation is not None:
            new_options += ['-ct', coordinateOperation]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement)]
        if SQLDialect is not None:
            new_options += ['-dialect', str(SQLDialect)]
        if where is not None:
            new_options += ['-where', str(where)]
        if accessMode is not None:
            if accessMode == 'update':
                new_options += ['-update']
            elif accessMode == 'append':
                new_options += ['-append']
            elif accessMode == 'overwrite':
                new_options += ['-overwrite']
            else:
                raise Exception('unhandled accessMode')
        if addFields:
            new_options += ['-addfields']
        if forceNullable:
            new_options += ['-forceNullable']
        if emptyStrAsNull:
            new_options += ['-emptyStrAsNull']
        if selectFields is not None:
            val = ''
            for item in selectFields:
                if val:
                    val += ','
                val += item
            new_options += ['-select', val]
        if datasetCreationOptions is not None:
            for opt in datasetCreationOptions:
                new_options += ['-dsco', opt]
        if layerCreationOptions is not None:
            for opt in layerCreationOptions:
                new_options += ['-lco', opt]
        if layers is not None:
            if isinstance(layers, str):
                new_options += [layers]
            else:
                for lyr in layers:
                    new_options += [lyr]
        if segmentizeMaxDist is not None:
            new_options += ['-segmentize', str(segmentizeMaxDist)]
        if makeValid:
            new_options += ['-makevalid']
        if spatFilter is not None:
            new_options += ['-spat', str(spatFilter[0]), str(spatFilter[1]), str(spatFilter[2]), str(spatFilter[3])]
        if spatSRS is not None:
            new_options += ['-spat_srs', str(spatSRS)]
        if layerName is not None:
            new_options += ['-nln', layerName]
        if geometryType is not None:
            if isinstance(geometryType, str):
                new_options += ['-nlt', geometryType]
            else:
                for opt in geometryType:
                    new_options += ['-nlt', opt]
        if dim is not None:
            new_options += ['-dim', dim]
        if zField is not None:
            new_options += ['-zfield', zField]
        if resolveDomains:
            new_options += ['-resolveDomains']
        if skipFailures:
            new_options += ['-skip']
        if limit is not None:
            new_options += ['-limit', str(limit)]
    if callback is not None:
        new_options += ['-progress']

    return (GDALVectorTranslateOptions(new_options), callback, callback_data)

def VectorTranslate(destNameOrDestDS, srcDS, **kwargs):
    """ Convert one vector dataset
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.VectorTranslateOptions(), string or array of strings
          other keywords arguments of gdal.VectorTranslateOptions()
        If options is provided as a gdal.VectorTranslateOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = VectorTranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDS, str):
        srcDS = OpenEx(srcDS, gdalconst.OF_VECTOR)

    if isinstance(destNameOrDestDS, str):
        return wrapper_GDALVectorTranslateDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALVectorTranslateDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)

def DEMProcessingOptions(options=None, colorFilename=None, format=None,
              creationOptions=None, computeEdges=False, alg=None, band=1,
              zFactor=None, scale=None, azimuth=None, altitude=None,
              combined=False, multiDirectional=False, igor=False,
              slopeFormat=None, trigonometric=False, zeroForFlat=False,
              addAlpha=None, colorSelection=None,
              callback=None, callback_data=None):
    """ Create a DEMProcessingOptions() object that can be passed to gdal.DEMProcessing()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          colorFilename --- (mandatory for "color-relief") name of file that contains palette definition for the "color-relief" processing.
          format --- output format ("GTiff", etc...)
          creationOptions --- list of creation options
          computeEdges --- whether to compute values at raster edges.
          alg --- 'Horn' (default) or 'ZevenbergenThorne' for hillshade, slope or aspect. 'Wilson' (default) or 'Riley' for TRI
          band --- source band number to use
          zFactor --- (hillshade only) vertical exaggeration used to pre-multiply the elevations.
          scale --- ratio of vertical units to horizontal.
          azimuth --- (hillshade only) azimuth of the light, in degrees. 0 if it comes from the top of the raster, 90 from the east, ... The default value, 315, should rarely be changed as it is the value generally used to generate shaded maps.
          altitude ---(hillshade only) altitude of the light, in degrees. 90 if the light comes from above the DEM, 0 if it is raking light.
          combined --- (hillshade only) whether to compute combined shading, a combination of slope and oblique shading. Only one of combined, multiDirectional and igor can be specified.
          multiDirectional --- (hillshade only) whether to compute multi-directional shading. Only one of combined, multiDirectional and igor can be specified.
          igor --- (hillshade only) whether to use Igor's hillshading from Maperitive.  Only one of combined, multiDirectional and igor can be specified.
          slopeformat --- (slope only) "degree" or "percent".
          trigonometric --- (aspect only) whether to return trigonometric angle instead of azimuth. Thus 0deg means East, 90deg North, 180deg West, 270deg South.
          zeroForFlat --- (aspect only) whether to return 0 for flat areas with slope=0, instead of -9999.
          addAlpha --- adds an alpha band to the output file (only for processing = 'color-relief')
          colorSelection --- (color-relief only) Determines how color entries are selected from an input value. Can be "nearest_color_entry", "exact_color_entry" or "linear_interpolation". Defaults to "linear_interpolation"
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt]
        if computeEdges:
            new_options += ['-compute_edges']
        if alg:
            new_options += ['-alg', alg]
        new_options += ['-b', str(band)]
        if zFactor is not None:
            new_options += ['-z', str(zFactor)]
        if scale is not None:
            new_options += ['-s', str(scale)]
        if azimuth is not None:
            new_options += ['-az', str(azimuth)]
        if altitude is not None:
            new_options += ['-alt', str(altitude)]
        if combined:
            new_options += ['-combined']
        if multiDirectional:
            new_options += ['-multidirectional']
        if igor:
            new_options += ['-igor']
        if slopeFormat == 'percent':
            new_options += ['-p']
        if trigonometric:
            new_options += ['-trigonometric']
        if zeroForFlat:
            new_options += ['-zero_for_flat']
        if colorSelection is not None:
            if colorSelection == 'nearest_color_entry':
                new_options += ['-nearest_color_entry']
            elif colorSelection == 'exact_color_entry':
                new_options += ['-exact_color_entry']
            elif colorSelection == 'linear_interpolation':
                pass
            else:
                raise ValueError("Unsupported value for colorSelection")
        if addAlpha:
            new_options += ['-alpha']

    return (GDALDEMProcessingOptions(new_options), colorFilename, callback, callback_data)

def DEMProcessing(destName, srcDS, processing, **kwargs):
    """ Apply a DEM processing.
        Arguments are :
          destName --- Output dataset name
          srcDS --- a Dataset object or a filename
          processing --- one of "hillshade", "slope", "aspect", "color-relief", "TRI", "TPI", "Roughness"
        Keyword arguments are :
          options --- return of gdal.DEMProcessingOptions(), string or array of strings
          other keywords arguments of gdal.DEMProcessingOptions()
        If options is provided as a gdal.DEMProcessingOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, colorFilename, callback, callback_data) = DEMProcessingOptions(**kwargs)
    else:
        (opts, colorFilename, callback, callback_data) = kwargs['options']
    if isinstance(srcDS, str):
        srcDS = Open(srcDS)

    return DEMProcessingInternal(destName, srcDS, processing, colorFilename, opts, callback, callback_data)


def NearblackOptions(options=None, format=None,
         creationOptions=None, white = False, colors=None,
         maxNonBlack=None, nearDist=None, setAlpha = False, setMask = False,
         callback=None, callback_data=None):
    """ Create a NearblackOptions() object that can be passed to gdal.Nearblack()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          creationOptions --- list of creation options
          white --- whether to search for nearly white (255) pixels instead of nearly black pixels.
          colors --- list of colors  to search for, e.g. ((0,0,0),(255,255,255)). The pixels that are considered as the collar are set to 0
          maxNonBlack --- number of non-black (or other searched colors specified with white / colors) pixels that can be encountered before the giving up search inwards. Defaults to 2.
          nearDist --- select how far from black, white or custom colors the pixel values can be and still considered near black, white or custom color.  Defaults to 15.
          setAlpha --- adds an alpha band to the output file.
          setMask --- adds a mask band to the output file.
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt]
        if white:
            new_options += ['-white']
        if colors is not None:
            for color in colors:
                color_str = ''
                for cpt in color:
                    if color_str != '':
                        color_str += ','
                    color_str += str(cpt)
                new_options += ['-color', color_str]
        if maxNonBlack is not None:
            new_options += ['-nb', str(maxNonBlack)]
        if nearDist is not None:
            new_options += ['-near', str(nearDist)]
        if setAlpha:
            new_options += ['-setalpha']
        if setMask:
            new_options += ['-setmask']

    return (GDALNearblackOptions(new_options), callback, callback_data)

def Nearblack(destNameOrDestDS, srcDS, **kwargs):
    """ Convert nearly black/white borders to exact value.
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.NearblackOptions(), string or array of strings
          other keywords arguments of gdal.NearblackOptions()
        If options is provided as a gdal.NearblackOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = NearblackOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDS, str):
        srcDS = OpenEx(srcDS)

    if isinstance(destNameOrDestDS, str):
        return wrapper_GDALNearblackDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALNearblackDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)


def GridOptions(options=None, format=None,
              outputType=gdalconst.GDT_Unknown,
              width=0, height=0,
              creationOptions=None,
              outputBounds=None,
              outputSRS=None,
              noData=None,
              algorithm=None,
              layers=None,
              SQLStatement=None,
              where=None,
              spatFilter=None,
              zfield=None,
              z_increase=None,
              z_multiply=None,
              callback=None, callback_data=None):
    """ Create a GridOptions() object that can be passed to gdal.Grid()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputType --- output type (gdalconst.GDT_Byte, etc...)
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          creationOptions --- list of creation options
          outputBounds --- assigned output bounds: [ulx, uly, lrx, lry]
          outputSRS --- assigned output SRS
          noData --- nodata value
          algorithm --- e.g "invdist:power=2.0:smoothing=0.0:radius1=0.0:radius2=0.0:angle=0.0:max_points=0:min_points=0:nodata=0.0"
          layers --- list of layers to convert
          SQLStatement --- SQL statement to apply to the source dataset
          where --- WHERE clause to apply to source layer(s)
          spatFilter --- spatial filter as (minX, minY, maxX, maxY) bounding box
          zfield --- Identifies an attribute field on the features to be used to get a Z value from. This value overrides Z value read from feature geometry record.
          z_increase --- Addition to the attribute field on the features to be used to get a Z value from. The addition should be the same unit as Z value. The result value will be Z value + Z increase value. The default value is 0.
          z_multiply - Multiplication ratio for Z field. This can be used for shift from e.g. foot to meters or from  elevation to deep. The result value will be (Z value + Z increase value) * Z multiply value.  The default value is 1.
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if width != 0 or height != 0:
            new_options += ['-outsize', str(width), str(height)]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt]
        if outputBounds is not None:
            new_options += ['-txe', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[2]), '-tye', _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[3])]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if algorithm is not None:
            new_options += ['-a', algorithm]
        if layers is not None:
            if isinstance(layers, (tuple, list)):
                for layer in layers:
                    new_options += ['-l', layer]
            else:
                new_options += ['-l', layers]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement)]
        if where is not None:
            new_options += ['-where', str(where)]
        if zfield is not None:
            new_options += ['-zfield', zfield]
        if z_increase is not None:
            new_options += ['-z_increase', str(z_increase)]
        if z_multiply is not None:
            new_options += ['-z_multiply', str(z_multiply)]
        if spatFilter is not None:
            new_options += ['-spat', str(spatFilter[0]), str(spatFilter[1]), str(spatFilter[2]), str(spatFilter[3])]

    return (GDALGridOptions(new_options), callback, callback_data)

def Grid(destName, srcDS, **kwargs):
    """ Create raster from the scattered data.
        Arguments are :
          destName --- Output dataset name
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.GridOptions(), string or array of strings
          other keywords arguments of gdal.GridOptions()
        If options is provided as a gdal.GridOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = GridOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDS, str):
        srcDS = OpenEx(srcDS, gdalconst.OF_VECTOR)

    return GridInternal(destName, srcDS, opts, callback, callback_data)

def RasterizeOptions(options=None, format=None,
         outputType=gdalconst.GDT_Unknown,
         creationOptions=None, noData=None, initValues=None,
         outputBounds=None, outputSRS=None,
         transformerOptions=None,
         width=None, height=None,
         xRes=None, yRes=None, targetAlignedPixels=False,
         bands=None, inverse=False, allTouched=False,
         burnValues=None, attribute=None, useZ=False, layers=None,
         SQLStatement=None, SQLDialect=None, where=None, optim=None,
         add=None,
         callback=None, callback_data=None):
    """ Create a RasterizeOptions() object that can be passed to gdal.Rasterize()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputType --- output type (gdalconst.GDT_Byte, etc...)
          creationOptions --- list of creation options
          outputBounds --- assigned output bounds: [minx, miny, maxx, maxy]
          outputSRS --- assigned output SRS
          transformerOptions --- list of transformer options
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          xRes, yRes --- output resolution in target SRS
          targetAlignedPixels --- whether to force output bounds to be multiple of output resolution
          noData --- nodata value
          initValues --- Value or list of values to pre-initialize the output image bands with.  However, it is not marked as the nodata value in the output file.  If only one value is given, the same value is used in all the bands.
          bands --- list of output bands to burn values into
          inverse --- whether to invert rasterization, i.e. burn the fixed burn value, or the burn value associated  with the first feature into all parts of the image not inside the provided a polygon.
          allTouched -- whether to enable the ALL_TOUCHED rasterization option so that all pixels touched by lines or polygons will be updated, not just those on the line render path, or whose center point is within the polygon.
          burnValues -- list of fixed values to burn into each band for all objects. Excusive with attribute.
          attribute --- identifies an attribute field on the features to be used for a burn-in value. The value will be burned into all output bands. Excusive with burnValues.
          useZ --- whether to indicate that a burn value should be extracted from the "Z" values of the feature. These values are added to the burn value given by burnValues or attribute if provided. As of now, only points and lines are drawn in 3D.
          layers --- list of layers from the datasource that will be used for input features.
          SQLStatement --- SQL statement to apply to the source dataset
          SQLDialect --- SQL dialect ('OGRSQL', 'SQLITE', ...)
          where --- WHERE clause to apply to source layer(s)
          optim --- optimization mode ('RASTER', 'VECTOR')
          add --- set to True to use additive mode instead of replace when burning values
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if outputType != gdalconst.GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType)]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt]
        if bands is not None:
            for b in bands:
                new_options += ['-b', str(b)]
        if noData is not None:
            new_options += ['-a_nodata', str(noData)]
        if initValues is not None:
            if isinstance(initValues, (tuple, list)):
                for val in initValues:
                    new_options += ['-init', str(val)]
            else:
                new_options += ['-init', str(initValues)]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if transformerOptions is not None:
            for opt in transformerOptions:
                new_options += ['-to', opt]
        if width is not None and height is not None:
            new_options += ['-ts', str(width), str(height)]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if targetAlignedPixels:
            new_options += ['-tap']
        if inverse:
            new_options += ['-i']
        if allTouched:
            new_options += ['-at']
        if burnValues is not None:
            if attribute is not None:
                raise Exception('burnValues and attribute option are exclusive.')
            if isinstance(burnValues, (tuple, list)):
                for val in burnValues:
                    new_options += ['-burn', str(val)]
            else:
                new_options += ['-burn', str(burnValues)]
        if attribute is not None:
            new_options += ['-a', attribute]
        if useZ:
            new_options += ['-3d']
        if layers is not None:
            if isinstance(layers, ((tuple, list))):
                for layer in layers:
                    new_options += ['-l', layer]
            else:
                new_options += ['-l', layers]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement)]
        if SQLDialect is not None:
            new_options += ['-dialect', str(SQLDialect)]
        if where is not None:
            new_options += ['-where', str(where)]
        if optim is not None:
            new_options += ['-optim', str(optim)]
        if add:
            new_options += ['-add']

    return (GDALRasterizeOptions(new_options), callback, callback_data)

def Rasterize(destNameOrDestDS, srcDS, **kwargs):
    """ Burns vector geometries into a raster
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.RasterizeOptions(), string or array of strings
          other keywords arguments of gdal.RasterizeOptions()
        If options is provided as a gdal.RasterizeOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = RasterizeOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDS, str):
        srcDS = OpenEx(srcDS, gdalconst.OF_VECTOR)

    if isinstance(destNameOrDestDS, str):
        return wrapper_GDALRasterizeDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALRasterizeDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)


def BuildVRTOptions(options=None,
                    resolution=None,
                    outputBounds=None,
                    xRes=None, yRes=None,
                    targetAlignedPixels=None,
                    separate=None,
                    bandList=None,
                    addAlpha=None,
                    resampleAlg=None,
                    outputSRS=None,
                    allowProjectionDifference=None,
                    srcNodata=None,
                    VRTNodata=None,
                    hideNodata=None,
                    callback=None, callback_data=None):
    """ Create a BuildVRTOptions() object that can be passed to gdal.BuildVRT()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords..
          resolution --- 'highest', 'lowest', 'average', 'user'.
          outputBounds --- output bounds as (minX, minY, maxX, maxY) in target SRS.
          xRes, yRes --- output resolution in target SRS.
          targetAlignedPixels --- whether to force output bounds to be multiple of output resolution.
          separate --- whether each source file goes into a separate stacked band in the VRT band.
          bandList --- array of band numbers (index start at 1).
          addAlpha --- whether to add an alpha mask band to the VRT when the source raster have none.
          resampleAlg --- resampling mode.
          outputSRS --- assigned output SRS.
          allowProjectionDifference --- whether to accept input datasets have not the same projection. Note: they will *not* be reprojected.
          srcNodata --- source nodata value(s).
          VRTNodata --- nodata values at the VRT band level.
          hideNodata --- whether to make the VRT band not report the NoData value.
          callback --- callback method.
          callback_data --- user data for callback.
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if resolution is not None:
            new_options += ['-resolution', str(resolution)]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if targetAlignedPixels:
            new_options += ['-tap']
        if separate:
            new_options += ['-separate']
        if bandList != None:
            for b in bandList:
                new_options += ['-b', str(b)]
        if addAlpha:
            new_options += ['-addalpha']
        if resampleAlg is not None:
            if resampleAlg == gdalconst.GRIORA_NearestNeighbour:
                new_options += ['-r', 'near']
            elif resampleAlg == gdalconst.GRIORA_Bilinear:
                new_options += ['-rb']
            elif resampleAlg == gdalconst.GRIORA_Cubic:
                new_options += ['-rc']
            elif resampleAlg == gdalconst.GRIORA_CubicSpline:
                new_options += ['-rcs']
            elif resampleAlg == gdalconst.GRIORA_Lanczos:
                new_options += ['-r', 'lanczos']
            elif resampleAlg == gdalconst.GRIORA_Average:
                new_options += ['-r', 'average']
            elif resampleAlg == gdalconst.GRIORA_RMS:
                new_options += ['-r', 'rms']
            elif resampleAlg == gdalconst.GRIORA_Mode:
                new_options += ['-r', 'mode']
            elif resampleAlg == gdalconst.GRIORA_Gauss:
                new_options += ['-r', 'gauss']
            else:
                new_options += ['-r', str(resampleAlg)]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS)]
        if allowProjectionDifference:
            new_options += ['-allow_projection_difference']
        if srcNodata is not None:
            new_options += ['-srcnodata', str(srcNodata)]
        if VRTNodata is not None:
            new_options += ['-vrtnodata', str(VRTNodata)]
        if hideNodata:
            new_options += ['-hidenodata']

    return (GDALBuildVRTOptions(new_options), callback, callback_data)

def BuildVRT(destName, srcDSOrSrcDSTab, **kwargs):
    """ Build a VRT from a list of datasets.
        Arguments are :
          destName --- Output dataset name
          srcDSOrSrcDSTab --- an array of Dataset objects or filenames, or a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.BuildVRTOptions(), string or array of strings
          other keywords arguments of gdal.BuildVRTOptions()
        If options is provided as a gdal.BuildVRTOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = BuildVRTOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    srcDSTab = []
    srcDSNamesTab = []
    if isinstance(srcDSOrSrcDSTab, str):
        srcDSNamesTab = [srcDSOrSrcDSTab]
    elif isinstance(srcDSOrSrcDSTab, list):
        for elt in srcDSOrSrcDSTab:
            if isinstance(elt, str):
                srcDSNamesTab.append(elt)
            else:
                srcDSTab.append(elt)
        if srcDSTab and srcDSNamesTab:
            raise Exception('Mix of names and dataset objects not supported')
    else:
        srcDSTab = [srcDSOrSrcDSTab]

    if srcDSTab:
        return BuildVRTInternalObjects(destName, srcDSTab, opts, callback, callback_data)
    else:
        return BuildVRTInternalNames(destName, srcDSNamesTab, opts, callback, callback_data)


def MultiDimTranslateOptions(options=None, format=None, creationOptions=None,
         arraySpecs=None, groupSpecs=None, subsetSpecs=None, scaleAxesSpecs=None,
         callback=None, callback_data=None):
    """ Create a MultiDimTranslateOptions() object that can be passed to gdal.MultiDimTranslate()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          creationOptions --- list of creation options
          arraySpecs -- list of array specifications, each of them being an array name or "name={src_array_name},dstname={dst_name},transpose=[1,0],view=[:,::-1]"
          groupSpecs -- list of group specifications, each of them being a group name or "name={src_array_name},dstname={dst_name},recursive=no"
          subsetSpecs -- list of subset specifications, each of them being like "{dim_name}({min_val},{max_val})" or "{dim_name}({slice_va})"
          scaleAxesSpecs -- list of dimension scaling specifications, each of them being like "{dim_name}({scale_factor})"
          callback --- callback method
          callback_data --- user data for callback
    """
    options = [] if options is None else options

    if isinstance(options, str):
        new_options = ParseCommandLine(options)
    else:
        new_options = options
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt]
        if arraySpecs is not None:
            for s in arraySpecs:
                new_options += ['-array', s]
        if groupSpecs is not None:
            for s in groupSpecs:
                new_options += ['-group', s]
        if subsetSpecs is not None:
            for s in subsetSpecs:
                new_options += ['-subset', s]
        if scaleAxesSpecs is not None:
            for s in scaleAxesSpecs:
                new_options += ['-scaleaxes', s]

    return (GDALMultiDimTranslateOptions(new_options), callback, callback_data)

def MultiDimTranslate(destName, srcDSOrSrcDSTab, **kwargs):
    """ MultiDimTranslate one or several datasets.
        Arguments are :
          destName --- Output dataset name
          srcDSOrSrcDSTab --- an array of Dataset objects or filenames, or a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.MultiDimTranslateOptions(), string or array of strings
          other keywords arguments of gdal.MultiDimTranslateOptions()
        If options is provided as a gdal.MultiDimTranslateOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or isinstance(kwargs['options'], (list, str)):
        (opts, callback, callback_data) = MultiDimTranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if isinstance(srcDSOrSrcDSTab, str):
        srcDSTab = [OpenEx(srcDSOrSrcDSTab, OF_VERBOSE_ERROR | OF_RASTER | OF_MULTIDIM_RASTER)]
    elif isinstance(srcDSOrSrcDSTab, list):
        srcDSTab = []
        for elt in srcDSOrSrcDSTab:
            if isinstance(elt, str):
                srcDSTab.append(OpenEx(elt, OF_VERBOSE_ERROR | OF_RASTER | OF_MULTIDIM_RASTER))
            else:
                srcDSTab.append(elt)
    else:
        srcDSTab = [srcDSOrSrcDSTab]

    return wrapper_GDALMultiDimTranslateDestName(destName, srcDSTab, opts, callback, callback_data)

# Logging Helpers
def _pylog_handler(err_level, err_no, err_msg):
    if err_no != gdalconst.CPLE_None:
        typ = _pylog_handler.errcode_map.get(err_no, str(err_no))
        message = "%s: %s" % (typ, err_msg)
    else:
        message = err_msg

    level = _pylog_handler.level_map.get(err_level, 20)  # default level is INFO
    _pylog_handler.logger.log(level, message)

def ConfigurePythonLogging(logger_name='gdal', enable_debug=False):
    """ Configure GDAL to use Python's logging framework """
    import logging

    _pylog_handler.logger = logging.getLogger(logger_name)

# map CPLE_* constants to names
    _pylog_handler.errcode_map = {_num: _name[5:] for _name, _num in gdalconst.__dict__.items() if _name.startswith('CPLE_')}

# Map GDAL log levels to Python's
    _pylog_handler.level_map = {
        CE_None: logging.INFO,
        CE_Debug: logging.DEBUG,
        CE_Warning: logging.WARN,
        CE_Failure: logging.ERROR,
        CE_Fatal: logging.CRITICAL,
    }

# Set CPL_DEBUG so debug messages are passed through the logger
    if enable_debug:
        SetConfigOption("CPL_DEBUG", "ON")

# Install as the default GDAL log handler
    SetErrorHandler(_pylog_handler)



def Debug(*args):
    """Debug(char const * msg_class, char const * message)"""
    return _gdal.Debug(*args)

def SetErrorHandler(*args):
    """SetErrorHandler(CPLErrorHandler pfnErrorHandler=0) -> CPLErr"""
    return _gdal.SetErrorHandler(*args)

def SetCurrentErrorHandlerCatchDebug(*args):
    """SetCurrentErrorHandlerCatchDebug(int bCatchDebug)"""
    return _gdal.SetCurrentErrorHandlerCatchDebug(*args)

def PushErrorHandler(*args):
    """PushErrorHandler(CPLErrorHandler pfnErrorHandler=0) -> CPLErr"""
    return _gdal.PushErrorHandler(*args)

def PopErrorHandler(*args):
    """PopErrorHandler()"""
    return _gdal.PopErrorHandler(*args)

def Error(*args):
    """Error(CPLErr msg_class, int err_code=0, char const * msg)"""
    return _gdal.Error(*args)

def GOA2GetAuthorizationURL(*args):
    """GOA2GetAuthorizationURL(char const * pszScope) -> retStringAndCPLFree *"""
    return _gdal.GOA2GetAuthorizationURL(*args)

def GOA2GetRefreshToken(*args):
    """GOA2GetRefreshToken(char const * pszAuthToken, char const * pszScope) -> retStringAndCPLFree *"""
    return _gdal.GOA2GetRefreshToken(*args)

def GOA2GetAccessToken(*args):
    """GOA2GetAccessToken(char const * pszRefreshToken, char const * pszScope) -> retStringAndCPLFree *"""
    return _gdal.GOA2GetAccessToken(*args)

def ErrorReset(*args):
    """ErrorReset()"""
    return _gdal.ErrorReset(*args)

def EscapeString(*args, **kwargs):
    """EscapeString(int len, int scheme) -> retStringAndCPLFree *"""
    return _gdal.EscapeString(*args, **kwargs)

def GetLastErrorNo(*args):
    """GetLastErrorNo() -> int"""
    return _gdal.GetLastErrorNo(*args)

def GetLastErrorType(*args):
    """GetLastErrorType() -> int"""
    return _gdal.GetLastErrorType(*args)

def GetLastErrorMsg(*args):
    """GetLastErrorMsg() -> char const *"""
    return _gdal.GetLastErrorMsg(*args)

def GetErrorCounter(*args):
    """GetErrorCounter() -> unsigned int"""
    return _gdal.GetErrorCounter(*args)

def VSIGetLastErrorNo(*args):
    """VSIGetLastErrorNo() -> int"""
    return _gdal.VSIGetLastErrorNo(*args)

def VSIGetLastErrorMsg(*args):
    """VSIGetLastErrorMsg() -> char const *"""
    return _gdal.VSIGetLastErrorMsg(*args)

def VSIErrorReset(*args):
    """VSIErrorReset()"""
    return _gdal.VSIErrorReset(*args)

def PushFinderLocation(*args):
    """PushFinderLocation(char const * utf8_path)"""
    return _gdal.PushFinderLocation(*args)

def PopFinderLocation(*args):
    """PopFinderLocation()"""
    return _gdal.PopFinderLocation(*args)

def FinderClean(*args):
    """FinderClean()"""
    return _gdal.FinderClean(*args)

def FindFile(*args):
    """FindFile(char const * pszClass, char const * utf8_path) -> char const *"""
    return _gdal.FindFile(*args)

def ReadDir(*args):
    """ReadDir(char const * utf8_path, int nMaxFiles=0) -> char **"""
    return _gdal.ReadDir(*args)

def ReadDirRecursive(*args):
    """ReadDirRecursive(char const * utf8_path) -> char **"""
    return _gdal.ReadDirRecursive(*args)

def OpenDir(*args):
    """OpenDir(char const * utf8_path, int nRecurseDepth=-1, char ** options=None) -> VSIDIR *"""
    return _gdal.OpenDir(*args)
class DirEntry(_object):
    """Proxy of C++ DirEntry class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirEntry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirEntry, name)
    __repr__ = _swig_repr
    __swig_getmethods__["name"] = _gdal.DirEntry_name_get
    if _newclass:
        name = _swig_property(_gdal.DirEntry_name_get)
    __swig_getmethods__["mode"] = _gdal.DirEntry_mode_get
    if _newclass:
        mode = _swig_property(_gdal.DirEntry_mode_get)
    __swig_getmethods__["size"] = _gdal.DirEntry_size_get
    if _newclass:
        size = _swig_property(_gdal.DirEntry_size_get)
    __swig_getmethods__["mtime"] = _gdal.DirEntry_mtime_get
    if _newclass:
        mtime = _swig_property(_gdal.DirEntry_mtime_get)
    __swig_getmethods__["modeKnown"] = _gdal.DirEntry_modeKnown_get
    if _newclass:
        modeKnown = _swig_property(_gdal.DirEntry_modeKnown_get)
    __swig_getmethods__["sizeKnown"] = _gdal.DirEntry_sizeKnown_get
    if _newclass:
        sizeKnown = _swig_property(_gdal.DirEntry_sizeKnown_get)
    __swig_getmethods__["mtimeKnown"] = _gdal.DirEntry_mtimeKnown_get
    if _newclass:
        mtimeKnown = _swig_property(_gdal.DirEntry_mtimeKnown_get)
    __swig_getmethods__["extra"] = _gdal.DirEntry_extra_get
    if _newclass:
        extra = _swig_property(_gdal.DirEntry_extra_get)

    def __init__(self, *args):
        """__init__(DirEntry self, DirEntry entryIn) -> DirEntry"""
        this = _gdal.new_DirEntry(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_DirEntry
    __del__ = lambda self: None

    def IsDirectory(self, *args):
        """IsDirectory(DirEntry self) -> bool"""
        return _gdal.DirEntry_IsDirectory(self, *args)

DirEntry_swigregister = _gdal.DirEntry_swigregister
DirEntry_swigregister(DirEntry)


def GetNextDirEntry(*args):
    """GetNextDirEntry(VSIDIR * dir) -> DirEntry"""
    return _gdal.GetNextDirEntry(*args)

def CloseDir(*args):
    """CloseDir(VSIDIR * dir)"""
    return _gdal.CloseDir(*args)

def SetConfigOption(*args):
    """SetConfigOption(char const * pszKey, char const * pszValue)"""
    return _gdal.SetConfigOption(*args)

def GetConfigOption(*args):
    """GetConfigOption(char const * pszKey, char const * pszDefault=None) -> char const *"""
    return _gdal.GetConfigOption(*args)

def CPLBinaryToHex(*args):
    """CPLBinaryToHex(int nBytes) -> retStringAndCPLFree *"""
    return _gdal.CPLBinaryToHex(*args)

def CPLHexToBinary(*args):
    """CPLHexToBinary(char const * pszHex, int * pnBytes) -> GByte *"""
    return _gdal.CPLHexToBinary(*args)

def FileFromMemBuffer(*args):
    """FileFromMemBuffer(char const * utf8_path, GIntBig nBytes)"""
    return _gdal.FileFromMemBuffer(*args)

def Unlink(*args):
    """Unlink(char const * utf8_path) -> VSI_RETVAL"""
    return _gdal.Unlink(*args)

def UnlinkBatch(*args):
    """UnlinkBatch(char ** files) -> bool"""
    return _gdal.UnlinkBatch(*args)

def HasThreadSupport(*args):
    """HasThreadSupport() -> int"""
    return _gdal.HasThreadSupport(*args)

def Mkdir(*args):
    """Mkdir(char const * utf8_path, int mode) -> VSI_RETVAL"""
    return _gdal.Mkdir(*args)

def Rmdir(*args):
    """Rmdir(char const * utf8_path) -> VSI_RETVAL"""
    return _gdal.Rmdir(*args)

def MkdirRecursive(*args):
    """MkdirRecursive(char const * utf8_path, int mode) -> VSI_RETVAL"""
    return _gdal.MkdirRecursive(*args)

def RmdirRecursive(*args):
    """RmdirRecursive(char const * utf8_path) -> VSI_RETVAL"""
    return _gdal.RmdirRecursive(*args)

def Rename(*args):
    """Rename(char const * pszOld, char const * pszNew) -> VSI_RETVAL"""
    return _gdal.Rename(*args)

def Sync(*args, **kwargs):
    """Sync(char const * pszSource, char const * pszTarget, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> bool"""
    return _gdal.Sync(*args, **kwargs)

def GetActualURL(*args):
    """GetActualURL(char const * utf8_path) -> char const *"""
    return _gdal.GetActualURL(*args)

def GetSignedURL(*args):
    """GetSignedURL(char const * utf8_path, char ** options=None) -> retStringAndCPLFree *"""
    return _gdal.GetSignedURL(*args)

def GetFileSystemsPrefixes(*args):
    """GetFileSystemsPrefixes() -> char **"""
    return _gdal.GetFileSystemsPrefixes(*args)

def GetFileSystemOptions(*args):
    """GetFileSystemOptions(char const * utf8_path) -> char const *"""
    return _gdal.GetFileSystemOptions(*args)
class VSILFILE(_object):
    """Proxy of C++ VSILFILE class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VSILFILE, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VSILFILE, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
VSILFILE_swigregister = _gdal.VSILFILE_swigregister
VSILFILE_swigregister(VSILFILE)

VSI_STAT_EXISTS_FLAG = _gdal.VSI_STAT_EXISTS_FLAG
VSI_STAT_NATURE_FLAG = _gdal.VSI_STAT_NATURE_FLAG
VSI_STAT_SIZE_FLAG = _gdal.VSI_STAT_SIZE_FLAG
class StatBuf(_object):
    """Proxy of C++ StatBuf class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatBuf, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StatBuf, name)
    __repr__ = _swig_repr
    __swig_getmethods__["mode"] = _gdal.StatBuf_mode_get
    if _newclass:
        mode = _swig_property(_gdal.StatBuf_mode_get)
    __swig_getmethods__["size"] = _gdal.StatBuf_size_get
    if _newclass:
        size = _swig_property(_gdal.StatBuf_size_get)
    __swig_getmethods__["mtime"] = _gdal.StatBuf_mtime_get
    if _newclass:
        mtime = _swig_property(_gdal.StatBuf_mtime_get)

    def __init__(self, *args):
        """__init__(StatBuf self, StatBuf psStatBuf) -> StatBuf"""
        this = _gdal.new_StatBuf(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_StatBuf
    __del__ = lambda self: None

    def IsDirectory(self, *args):
        """IsDirectory(StatBuf self) -> int"""
        return _gdal.StatBuf_IsDirectory(self, *args)

StatBuf_swigregister = _gdal.StatBuf_swigregister
StatBuf_swigregister(StatBuf)


def VSIStatL(*args):
    """VSIStatL(char const * utf8_path, int nFlags=0) -> int"""
    return _gdal.VSIStatL(*args)

def GetFileMetadata(*args):
    """GetFileMetadata(char const * utf8_path, char const * domain, char ** options=None) -> char **"""
    return _gdal.GetFileMetadata(*args)

def SetFileMetadata(*args):
    """SetFileMetadata(char const * utf8_path, char ** metadata, char const * domain, char ** options=None) -> bool"""
    return _gdal.SetFileMetadata(*args)

def VSIFOpenL(*args):
    """VSIFOpenL(char const * utf8_path, char const * pszMode) -> VSILFILE"""
    return _gdal.VSIFOpenL(*args)

def VSIFOpenExL(*args):
    """VSIFOpenExL(char const * utf8_path, char const * pszMode, int bSetError=False, char ** options=None) -> VSILFILE"""
    return _gdal.VSIFOpenExL(*args)

def VSIFEofL(*args):
    """VSIFEofL(VSILFILE fp) -> int"""
    return _gdal.VSIFEofL(*args)

def VSIFFlushL(*args):
    """VSIFFlushL(VSILFILE fp) -> int"""
    return _gdal.VSIFFlushL(*args)

def VSIFCloseL(*args):
    """VSIFCloseL(VSILFILE fp) -> VSI_RETVAL"""
    return _gdal.VSIFCloseL(*args)

def VSIFSeekL(*args):
    """VSIFSeekL(VSILFILE fp, GIntBig offset, int whence) -> int"""
    return _gdal.VSIFSeekL(*args)

def VSIFTellL(*args):
    """VSIFTellL(VSILFILE fp) -> GIntBig"""
    return _gdal.VSIFTellL(*args)

def VSIFTruncateL(*args):
    """VSIFTruncateL(VSILFILE fp, GIntBig length) -> int"""
    return _gdal.VSIFTruncateL(*args)

def VSISupportsSparseFiles(*args):
    """VSISupportsSparseFiles(char const * utf8_path) -> int"""
    return _gdal.VSISupportsSparseFiles(*args)
VSI_RANGE_STATUS_UNKNOWN = _gdal.VSI_RANGE_STATUS_UNKNOWN
VSI_RANGE_STATUS_DATA = _gdal.VSI_RANGE_STATUS_DATA
VSI_RANGE_STATUS_HOLE = _gdal.VSI_RANGE_STATUS_HOLE

def VSIFGetRangeStatusL(*args):
    """VSIFGetRangeStatusL(VSILFILE fp, GIntBig offset, GIntBig length) -> int"""
    return _gdal.VSIFGetRangeStatusL(*args)

def VSIFWriteL(*args):
    """VSIFWriteL(int nLen, int size, int memb, VSILFILE fp) -> int"""
    return _gdal.VSIFWriteL(*args)

def VSICurlClearCache(*args):
    """VSICurlClearCache()"""
    return _gdal.VSICurlClearCache(*args)

def VSICurlPartialClearCache(*args):
    """VSICurlPartialClearCache(char const * utf8_path)"""
    return _gdal.VSICurlPartialClearCache(*args)

def NetworkStatsReset(*args):
    """NetworkStatsReset()"""
    return _gdal.NetworkStatsReset(*args)

def NetworkStatsGetAsSerializedJSON(*args):
    """NetworkStatsGetAsSerializedJSON(char ** options=None) -> retStringAndCPLFree *"""
    return _gdal.NetworkStatsGetAsSerializedJSON(*args)

def ParseCommandLine(*args):
    """ParseCommandLine(char const * utf8_path) -> char **"""
    return _gdal.ParseCommandLine(*args)
class MajorObject(_object):
    """Proxy of C++ GDALMajorObjectShadow class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MajorObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MajorObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetDescription(self, *args):
        """GetDescription(MajorObject self) -> char const *"""
        return _gdal.MajorObject_GetDescription(self, *args)


    def SetDescription(self, *args):
        """SetDescription(MajorObject self, char const * pszNewDesc)"""
        return _gdal.MajorObject_SetDescription(self, *args)


    def GetMetadataDomainList(self, *args):
        """GetMetadataDomainList(MajorObject self) -> char **"""
        return _gdal.MajorObject_GetMetadataDomainList(self, *args)


    def GetMetadata_Dict(self, *args):
        """GetMetadata_Dict(MajorObject self, char const * pszDomain) -> char **"""
        return _gdal.MajorObject_GetMetadata_Dict(self, *args)


    def GetMetadata_List(self, *args):
        """GetMetadata_List(MajorObject self, char const * pszDomain) -> char **"""
        return _gdal.MajorObject_GetMetadata_List(self, *args)


    def SetMetadata(self, *args):
        """
        SetMetadata(MajorObject self, char ** papszMetadata, char const * pszDomain) -> CPLErr
        SetMetadata(MajorObject self, char * pszMetadataString, char const * pszDomain) -> CPLErr
        """
        return _gdal.MajorObject_SetMetadata(self, *args)


    def GetMetadataItem(self, *args):
        """GetMetadataItem(MajorObject self, char const * pszName, char const * pszDomain) -> char const *"""
        return _gdal.MajorObject_GetMetadataItem(self, *args)


    def SetMetadataItem(self, *args):
        """SetMetadataItem(MajorObject self, char const * pszName, char const * pszValue, char const * pszDomain) -> CPLErr"""
        return _gdal.MajorObject_SetMetadataItem(self, *args)


    def GetMetadata(self, domain=''):
      if domain[:4] == 'xml:':
        return self.GetMetadata_List(domain)
      return self.GetMetadata_Dict(domain)

MajorObject_swigregister = _gdal.MajorObject_swigregister
MajorObject_swigregister(MajorObject)

class Driver(MajorObject):
    """Proxy of C++ GDALDriverShadow class."""

    __swig_setmethods__ = {}
    for _s in [MajorObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Driver, name, value)
    __swig_getmethods__ = {}
    for _s in [MajorObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Driver, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["ShortName"] = _gdal.Driver_ShortName_get
    if _newclass:
        ShortName = _swig_property(_gdal.Driver_ShortName_get)
    __swig_getmethods__["LongName"] = _gdal.Driver_LongName_get
    if _newclass:
        LongName = _swig_property(_gdal.Driver_LongName_get)
    __swig_getmethods__["HelpTopic"] = _gdal.Driver_HelpTopic_get
    if _newclass:
        HelpTopic = _swig_property(_gdal.Driver_HelpTopic_get)

    def Create(self, *args, **kwargs):
        """Create(Driver self, char const * utf8_path, int xsize, int ysize, int bands=1, GDALDataType eType, char ** options=None) -> Dataset"""
        return _gdal.Driver_Create(self, *args, **kwargs)


    def CreateMultiDimensional(self, *args, **kwargs):
        """CreateMultiDimensional(Driver self, char const * utf8_path, char ** root_group_options=None, char ** options=None) -> Dataset"""
        return _gdal.Driver_CreateMultiDimensional(self, *args, **kwargs)


    def CreateCopy(self, *args, **kwargs):
        """CreateCopy(Driver self, char const * utf8_path, Dataset src, int strict=1, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
        return _gdal.Driver_CreateCopy(self, *args, **kwargs)


    def Delete(self, *args):
        """Delete(Driver self, char const * utf8_path) -> CPLErr"""
        return _gdal.Driver_Delete(self, *args)


    def Rename(self, *args):
        """Rename(Driver self, char const * newName, char const * oldName) -> CPLErr"""
        return _gdal.Driver_Rename(self, *args)


    def CopyFiles(self, *args):
        """CopyFiles(Driver self, char const * newName, char const * oldName) -> CPLErr"""
        return _gdal.Driver_CopyFiles(self, *args)


    def Register(self, *args):
        """Register(Driver self) -> int"""
        return _gdal.Driver_Register(self, *args)


    def Deregister(self, *args):
        """Deregister(Driver self)"""
        return _gdal.Driver_Deregister(self, *args)

Driver_swigregister = _gdal.Driver_swigregister
Driver_swigregister(Driver)

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import ogr
else:
    import ogr
del _swig_python_version_info
from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    from . import osr
else:
    import osr
del _swig_python_version_info
class ColorEntry(_object):
    """Proxy of C++ GDALColorEntry class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorEntry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColorEntry, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_setmethods__["c1"] = _gdal.ColorEntry_c1_set
    __swig_getmethods__["c1"] = _gdal.ColorEntry_c1_get
    if _newclass:
        c1 = _swig_property(_gdal.ColorEntry_c1_get, _gdal.ColorEntry_c1_set)
    __swig_setmethods__["c2"] = _gdal.ColorEntry_c2_set
    __swig_getmethods__["c2"] = _gdal.ColorEntry_c2_get
    if _newclass:
        c2 = _swig_property(_gdal.ColorEntry_c2_get, _gdal.ColorEntry_c2_set)
    __swig_setmethods__["c3"] = _gdal.ColorEntry_c3_set
    __swig_getmethods__["c3"] = _gdal.ColorEntry_c3_get
    if _newclass:
        c3 = _swig_property(_gdal.ColorEntry_c3_get, _gdal.ColorEntry_c3_set)
    __swig_setmethods__["c4"] = _gdal.ColorEntry_c4_set
    __swig_getmethods__["c4"] = _gdal.ColorEntry_c4_get
    if _newclass:
        c4 = _swig_property(_gdal.ColorEntry_c4_get, _gdal.ColorEntry_c4_set)
ColorEntry_swigregister = _gdal.ColorEntry_swigregister
ColorEntry_swigregister(ColorEntry)

class GCP(_object):
    """Proxy of C++ GDAL_GCP class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GCP, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GCP, name)
    __repr__ = _swig_repr
    __swig_setmethods__["GCPX"] = _gdal.GCP_GCPX_set
    __swig_getmethods__["GCPX"] = _gdal.GCP_GCPX_get
    if _newclass:
        GCPX = _swig_property(_gdal.GCP_GCPX_get, _gdal.GCP_GCPX_set)
    __swig_setmethods__["GCPY"] = _gdal.GCP_GCPY_set
    __swig_getmethods__["GCPY"] = _gdal.GCP_GCPY_get
    if _newclass:
        GCPY = _swig_property(_gdal.GCP_GCPY_get, _gdal.GCP_GCPY_set)
    __swig_setmethods__["GCPZ"] = _gdal.GCP_GCPZ_set
    __swig_getmethods__["GCPZ"] = _gdal.GCP_GCPZ_get
    if _newclass:
        GCPZ = _swig_property(_gdal.GCP_GCPZ_get, _gdal.GCP_GCPZ_set)
    __swig_setmethods__["GCPPixel"] = _gdal.GCP_GCPPixel_set
    __swig_getmethods__["GCPPixel"] = _gdal.GCP_GCPPixel_get
    if _newclass:
        GCPPixel = _swig_property(_gdal.GCP_GCPPixel_get, _gdal.GCP_GCPPixel_set)
    __swig_setmethods__["GCPLine"] = _gdal.GCP_GCPLine_set
    __swig_getmethods__["GCPLine"] = _gdal.GCP_GCPLine_get
    if _newclass:
        GCPLine = _swig_property(_gdal.GCP_GCPLine_get, _gdal.GCP_GCPLine_set)
    __swig_setmethods__["Info"] = _gdal.GCP_Info_set
    __swig_getmethods__["Info"] = _gdal.GCP_Info_get
    if _newclass:
        Info = _swig_property(_gdal.GCP_Info_get, _gdal.GCP_Info_set)
    __swig_setmethods__["Id"] = _gdal.GCP_Id_set
    __swig_getmethods__["Id"] = _gdal.GCP_Id_get
    if _newclass:
        Id = _swig_property(_gdal.GCP_Id_get, _gdal.GCP_Id_set)

    def __init__(self, *args):
        """__init__(GDAL_GCP self, double x=0.0, double y=0.0, double z=0.0, double pixel=0.0, double line=0.0, char const * info, char const * id) -> GCP"""
        this = _gdal.new_GCP(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GCP
    __del__ = lambda self: None

    def __str__(self):
      str = '%s (%.2fP,%.2fL) -> (%.7fE,%.7fN,%.2f) %s '\
            % (self.Id, self.GCPPixel, self.GCPLine,
               self.GCPX, self.GCPY, self.GCPZ, self.Info )
      return str

    def serialize(self, with_Z=0):
      base = [gdalconst.CXT_Element,'GCP']
      base.append([gdalconst.CXT_Attribute,'Id',[gdalconst.CXT_Text,self.Id]])
      pixval = '%0.15E' % self.GCPPixel
      lineval = '%0.15E' % self.GCPLine
      xval = '%0.15E' % self.GCPX
      yval = '%0.15E' % self.GCPY
      zval = '%0.15E' % self.GCPZ
      base.append([gdalconst.CXT_Attribute,'Pixel',[gdalconst.CXT_Text,pixval]])
      base.append([gdalconst.CXT_Attribute,'Line',[gdalconst.CXT_Text,lineval]])
      base.append([gdalconst.CXT_Attribute,'X',[gdalconst.CXT_Text,xval]])
      base.append([gdalconst.CXT_Attribute,'Y',[gdalconst.CXT_Text,yval]])
      if with_Z:
          base.append([gdalconst.CXT_Attribute,'Z',[gdalconst.CXT_Text,zval]])
      return base

GCP_swigregister = _gdal.GCP_swigregister
GCP_swigregister(GCP)


def GDAL_GCP_GCPX_get(*args):
    """GDAL_GCP_GCPX_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPX_get(*args)

def GDAL_GCP_GCPX_set(*args):
    """GDAL_GCP_GCPX_set(GCP gcp, double dfGCPX)"""
    return _gdal.GDAL_GCP_GCPX_set(*args)

def GDAL_GCP_GCPY_get(*args):
    """GDAL_GCP_GCPY_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPY_get(*args)

def GDAL_GCP_GCPY_set(*args):
    """GDAL_GCP_GCPY_set(GCP gcp, double dfGCPY)"""
    return _gdal.GDAL_GCP_GCPY_set(*args)

def GDAL_GCP_GCPZ_get(*args):
    """GDAL_GCP_GCPZ_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPZ_get(*args)

def GDAL_GCP_GCPZ_set(*args):
    """GDAL_GCP_GCPZ_set(GCP gcp, double dfGCPZ)"""
    return _gdal.GDAL_GCP_GCPZ_set(*args)

def GDAL_GCP_GCPPixel_get(*args):
    """GDAL_GCP_GCPPixel_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPPixel_get(*args)

def GDAL_GCP_GCPPixel_set(*args):
    """GDAL_GCP_GCPPixel_set(GCP gcp, double dfGCPPixel)"""
    return _gdal.GDAL_GCP_GCPPixel_set(*args)

def GDAL_GCP_GCPLine_get(*args):
    """GDAL_GCP_GCPLine_get(GCP gcp) -> double"""
    return _gdal.GDAL_GCP_GCPLine_get(*args)

def GDAL_GCP_GCPLine_set(*args):
    """GDAL_GCP_GCPLine_set(GCP gcp, double dfGCPLine)"""
    return _gdal.GDAL_GCP_GCPLine_set(*args)

def GDAL_GCP_Info_get(*args):
    """GDAL_GCP_Info_get(GCP gcp) -> char const *"""
    return _gdal.GDAL_GCP_Info_get(*args)

def GDAL_GCP_Info_set(*args):
    """GDAL_GCP_Info_set(GCP gcp, char const * pszInfo)"""
    return _gdal.GDAL_GCP_Info_set(*args)

def GDAL_GCP_Id_get(*args):
    """GDAL_GCP_Id_get(GCP gcp) -> char const *"""
    return _gdal.GDAL_GCP_Id_get(*args)

def GDAL_GCP_Id_set(*args):
    """GDAL_GCP_Id_set(GCP gcp, char const * pszId)"""
    return _gdal.GDAL_GCP_Id_set(*args)

def GCPsToGeoTransform(*args):
    """GCPsToGeoTransform(int nGCPs, int bApproxOK=1) -> RETURN_NONE"""
    return _gdal.GCPsToGeoTransform(*args)
class VirtualMem(_object):
    """Proxy of C++ CPLVirtualMemShadow class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VirtualMem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VirtualMem, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_VirtualMem
    __del__ = lambda self: None

    def GetAddr(self, *args):
        """GetAddr(VirtualMem self)"""
        return _gdal.VirtualMem_GetAddr(self, *args)


    def Pin(self, *args):
        """Pin(VirtualMem self, size_t start_offset=0, size_t nsize=0, int bWriteOp=0)"""
        return _gdal.VirtualMem_Pin(self, *args)

VirtualMem_swigregister = _gdal.VirtualMem_swigregister
VirtualMem_swigregister(VirtualMem)

class AsyncReader(_object):
    """Proxy of C++ GDALAsyncReaderShadow class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AsyncReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AsyncReader, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_AsyncReader
    __del__ = lambda self: None

    def GetNextUpdatedRegion(self, *args):
        """GetNextUpdatedRegion(AsyncReader self, double timeout) -> GDALAsyncStatusType"""
        return _gdal.AsyncReader_GetNextUpdatedRegion(self, *args)


    def GetBuffer(self, *args):
        """GetBuffer(AsyncReader self)"""
        return _gdal.AsyncReader_GetBuffer(self, *args)


    def LockBuffer(self, *args):
        """LockBuffer(AsyncReader self, double timeout) -> int"""
        return _gdal.AsyncReader_LockBuffer(self, *args)


    def UnlockBuffer(self, *args):
        """UnlockBuffer(AsyncReader self)"""
        return _gdal.AsyncReader_UnlockBuffer(self, *args)

AsyncReader_swigregister = _gdal.AsyncReader_swigregister
AsyncReader_swigregister(AsyncReader)

class Dataset(MajorObject):
    """Proxy of C++ GDALDatasetShadow class."""

    __swig_setmethods__ = {}
    for _s in [MajorObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Dataset, name, value)
    __swig_getmethods__ = {}
    for _s in [MajorObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Dataset, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["RasterXSize"] = _gdal.Dataset_RasterXSize_get
    if _newclass:
        RasterXSize = _swig_property(_gdal.Dataset_RasterXSize_get)
    __swig_getmethods__["RasterYSize"] = _gdal.Dataset_RasterYSize_get
    if _newclass:
        RasterYSize = _swig_property(_gdal.Dataset_RasterYSize_get)
    __swig_getmethods__["RasterCount"] = _gdal.Dataset_RasterCount_get
    if _newclass:
        RasterCount = _swig_property(_gdal.Dataset_RasterCount_get)
    __swig_destroy__ = _gdal.delete_Dataset
    __del__ = lambda self: None

    def GetDriver(self, *args):
        """GetDriver(Dataset self) -> Driver"""
        return _gdal.Dataset_GetDriver(self, *args)


    def GetRasterBand(self, *args):
        """GetRasterBand(Dataset self, int nBand) -> Band"""
        return _gdal.Dataset_GetRasterBand(self, *args)


    def GetRootGroup(self, *args):
        """GetRootGroup(Dataset self) -> Group"""
        return _gdal.Dataset_GetRootGroup(self, *args)


    def GetProjection(self, *args):
        """GetProjection(Dataset self) -> char const *"""
        return _gdal.Dataset_GetProjection(self, *args)


    def GetProjectionRef(self, *args):
        """GetProjectionRef(Dataset self) -> char const *"""
        return _gdal.Dataset_GetProjectionRef(self, *args)


    def GetSpatialRef(self, *args):
        """GetSpatialRef(Dataset self) -> SpatialReference"""
        return _gdal.Dataset_GetSpatialRef(self, *args)


    def SetProjection(self, *args):
        """SetProjection(Dataset self, char const * prj) -> CPLErr"""
        return _gdal.Dataset_SetProjection(self, *args)


    def SetSpatialRef(self, *args):
        """SetSpatialRef(Dataset self, SpatialReference srs) -> CPLErr"""
        return _gdal.Dataset_SetSpatialRef(self, *args)


    def GetGeoTransform(self, *args, **kwargs):
        """GetGeoTransform(Dataset self, int * can_return_null=None)"""
        return _gdal.Dataset_GetGeoTransform(self, *args, **kwargs)


    def SetGeoTransform(self, *args):
        """SetGeoTransform(Dataset self, double [6] argin) -> CPLErr"""
        return _gdal.Dataset_SetGeoTransform(self, *args)


    def BuildOverviews(self, *args, **kwargs):
        """BuildOverviews(Dataset self, char const * resampling, int overviewlist=0, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
        return _gdal.Dataset_BuildOverviews(self, *args, **kwargs)


    def GetGCPCount(self, *args):
        """GetGCPCount(Dataset self) -> int"""
        return _gdal.Dataset_GetGCPCount(self, *args)


    def GetGCPProjection(self, *args):
        """GetGCPProjection(Dataset self) -> char const *"""
        return _gdal.Dataset_GetGCPProjection(self, *args)


    def GetGCPSpatialRef(self, *args):
        """GetGCPSpatialRef(Dataset self) -> SpatialReference"""
        return _gdal.Dataset_GetGCPSpatialRef(self, *args)


    def GetGCPs(self, *args):
        """GetGCPs(Dataset self)"""
        return _gdal.Dataset_GetGCPs(self, *args)


    def _SetGCPs(self, *args):
        """_SetGCPs(Dataset self, int nGCPs, char const * pszGCPProjection) -> CPLErr"""
        return _gdal.Dataset__SetGCPs(self, *args)


    def _SetGCPs2(self, *args):
        """_SetGCPs2(Dataset self, int nGCPs, SpatialReference hSRS) -> CPLErr"""
        return _gdal.Dataset__SetGCPs2(self, *args)


    def FlushCache(self, *args):
        """FlushCache(Dataset self)"""
        return _gdal.Dataset_FlushCache(self, *args)


    def AddBand(self, *args, **kwargs):
        """AddBand(Dataset self, GDALDataType datatype, char ** options=None) -> CPLErr"""
        return _gdal.Dataset_AddBand(self, *args, **kwargs)


    def CreateMaskBand(self, *args):
        """CreateMaskBand(Dataset self, int nFlags) -> CPLErr"""
        return _gdal.Dataset_CreateMaskBand(self, *args)


    def GetFileList(self, *args):
        """GetFileList(Dataset self) -> char **"""
        return _gdal.Dataset_GetFileList(self, *args)


    def WriteRaster(self, *args, **kwargs):
        """WriteRaster(Dataset self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, int band_list=0, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None, GIntBig * buf_band_space=None) -> CPLErr"""
        return _gdal.Dataset_WriteRaster(self, *args, **kwargs)


    def AdviseRead(self, *args):
        """AdviseRead(Dataset self, int xoff, int yoff, int xsize, int ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, int band_list=0, char ** options=None) -> CPLErr"""
        return _gdal.Dataset_AdviseRead(self, *args)


    def BeginAsyncReader(self, *args, **kwargs):
        """BeginAsyncReader(Dataset self, int xOff, int yOff, int xSize, int ySize, int buf_len, int buf_xsize, int buf_ysize, GDALDataType bufType, int band_list=0, int nPixelSpace=0, int nLineSpace=0, int nBandSpace=0, char ** options=None) -> AsyncReader"""
        return _gdal.Dataset_BeginAsyncReader(self, *args, **kwargs)


    def EndAsyncReader(self, *args):
        """EndAsyncReader(Dataset self, AsyncReader ario)"""
        return _gdal.Dataset_EndAsyncReader(self, *args)


    def GetVirtualMem(self, *args, **kwargs):
        """GetVirtualMem(Dataset self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nBufXSize, int nBufYSize, GDALDataType eBufType, int band_list, int bIsBandSequential, size_t nCacheSize, size_t nPageSizeHint, char ** options=None) -> VirtualMem"""
        return _gdal.Dataset_GetVirtualMem(self, *args, **kwargs)


    def GetTiledVirtualMem(self, *args, **kwargs):
        """GetTiledVirtualMem(Dataset self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nTileXSize, int nTileYSize, GDALDataType eBufType, int band_list, GDALTileOrganization eTileOrganization, size_t nCacheSize, char ** options=None) -> VirtualMem"""
        return _gdal.Dataset_GetTiledVirtualMem(self, *args, **kwargs)


    def CreateLayer(self, *args, **kwargs):
        """CreateLayer(Dataset self, char const * name, SpatialReference srs=None, OGRwkbGeometryType geom_type, char ** options=None) -> Layer"""
        return _gdal.Dataset_CreateLayer(self, *args, **kwargs)


    def CopyLayer(self, *args, **kwargs):
        """CopyLayer(Dataset self, Layer src_layer, char const * new_name, char ** options=None) -> Layer"""
        return _gdal.Dataset_CopyLayer(self, *args, **kwargs)


    def DeleteLayer(self, *args):
        """DeleteLayer(Dataset self, int index) -> OGRErr"""
        return _gdal.Dataset_DeleteLayer(self, *args)


    def GetLayerCount(self, *args):
        """GetLayerCount(Dataset self) -> int"""
        return _gdal.Dataset_GetLayerCount(self, *args)


    def GetLayerByIndex(self, *args):
        """GetLayerByIndex(Dataset self, int index=0) -> Layer"""
        return _gdal.Dataset_GetLayerByIndex(self, *args)


    def GetLayerByName(self, *args):
        """GetLayerByName(Dataset self, char const * layer_name) -> Layer"""
        return _gdal.Dataset_GetLayerByName(self, *args)


    def ResetReading(self, *args):
        """ResetReading(Dataset self)"""
        return _gdal.Dataset_ResetReading(self, *args)


    def GetNextFeature(self, *args, **kwargs):
        """GetNextFeature(Dataset self, bool include_layer=True, bool include_pct=False, GDALProgressFunc callback=0, void * callback_data=None) -> Feature"""
        return _gdal.Dataset_GetNextFeature(self, *args, **kwargs)


    def TestCapability(self, *args):
        """TestCapability(Dataset self, char const * cap) -> bool"""
        return _gdal.Dataset_TestCapability(self, *args)


    def ExecuteSQL(self, *args, **kwargs):
        """ExecuteSQL(Dataset self, char const * statement, Geometry spatialFilter=None, char const * dialect) -> Layer"""
        return _gdal.Dataset_ExecuteSQL(self, *args, **kwargs)


    def ReleaseResultSet(self, *args):
        """ReleaseResultSet(Dataset self, Layer layer)"""
        return _gdal.Dataset_ReleaseResultSet(self, *args)


    def GetStyleTable(self, *args):
        """GetStyleTable(Dataset self) -> StyleTable"""
        return _gdal.Dataset_GetStyleTable(self, *args)


    def SetStyleTable(self, *args):
        """SetStyleTable(Dataset self, StyleTable table)"""
        return _gdal.Dataset_SetStyleTable(self, *args)


    def AbortSQL(self, *args):
        """AbortSQL(Dataset self) -> OGRErr"""
        return _gdal.Dataset_AbortSQL(self, *args)


    def StartTransaction(self, *args, **kwargs):
        """StartTransaction(Dataset self, int force=False) -> OGRErr"""
        return _gdal.Dataset_StartTransaction(self, *args, **kwargs)


    def CommitTransaction(self, *args):
        """CommitTransaction(Dataset self) -> OGRErr"""
        return _gdal.Dataset_CommitTransaction(self, *args)


    def RollbackTransaction(self, *args):
        """RollbackTransaction(Dataset self) -> OGRErr"""
        return _gdal.Dataset_RollbackTransaction(self, *args)


    def ClearStatistics(self, *args):
        """ClearStatistics(Dataset self)"""
        return _gdal.Dataset_ClearStatistics(self, *args)


    def GetFieldDomain(self, *args):
        """GetFieldDomain(Dataset self, char const * name) -> FieldDomain"""
        return _gdal.Dataset_GetFieldDomain(self, *args)


    def AddFieldDomain(self, *args):
        """AddFieldDomain(Dataset self, FieldDomain fieldDomain) -> bool"""
        return _gdal.Dataset_AddFieldDomain(self, *args)


    def ReadRaster1(self, *args, **kwargs):
        """ReadRaster1(Dataset self, double xoff, double yoff, double xsize, double ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, int band_list=0, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None, GIntBig * buf_band_space=None, GDALRIOResampleAlg resample_alg, GDALProgressFunc callback=0, void * callback_data=None, void * inputOutputBuf=None) -> CPLErr"""
        return _gdal.Dataset_ReadRaster1(self, *args, **kwargs)



    def ReadAsArray(self, xoff=0, yoff=0, xsize=None, ysize=None, buf_obj=None,
                    buf_xsize=None, buf_ysize=None, buf_type=None,
                    resample_alg=gdalconst.GRIORA_NearestNeighbour,
                    callback=None,
                    callback_data=None,
                    interleave='band',
                    band_list=None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        from osgeo import gdal_array
        return gdal_array.DatasetReadAsArray(self, xoff, yoff, xsize, ysize, buf_obj,
                                              buf_xsize, buf_ysize, buf_type,
                                              resample_alg=resample_alg,
                                              callback=callback,
                                              callback_data=callback_data,
                                              interleave=interleave,
                                              band_list=band_list)

    def WriteArray(self, array, xoff=0, yoff=0,
                   band_list=None,
                   interleave='band',
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None):
        from osgeo import gdal_array

        return gdal_array.DatasetWriteArray(self, array, xoff, yoff,
                                            band_list=band_list,
                                            interleave=interleave,
                                            resample_alg=resample_alg,
                                            callback=callback,
                                            callback_data=callback_data)

    def WriteRaster(self, xoff, yoff, xsize, ysize,
                    buf_string,
                    buf_xsize=None, buf_ysize=None, buf_type=None,
                    band_list=None,
                    buf_pixel_space=None, buf_line_space=None, buf_band_space=None ):

        if buf_xsize is None:
            buf_xsize = xsize
        if buf_ysize is None:
            buf_ysize = ysize
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))

    # Redirect to numpy-friendly WriteArray() if buf_string is a numpy array
    # and other arguments are compatible
        if type(buf_string).__name__ == 'ndarray' and \
           buf_xsize == xsize and buf_ysize == ysize and buf_type is None and \
           buf_pixel_space is None and buf_line_space is None and buf_band_space is None:
            return self.WriteArray(buf_string, xoff=xoff, yoff=yoff,
                                   band_list=band_list)
        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType

        return _gdal.Dataset_WriteRaster(self,
                 xoff, yoff, xsize, ysize,
                buf_string, buf_xsize, buf_ysize, buf_type, band_list,
                buf_pixel_space, buf_line_space, buf_band_space )

    def ReadRaster(self, xoff=0, yoff=0, xsize=None, ysize=None,
                   buf_xsize=None, buf_ysize=None, buf_type=None,
                   band_list=None,
                   buf_pixel_space=None, buf_line_space=None, buf_band_space=None,
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None,
                   buf_obj=None):

        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if buf_xsize is None:
            buf_xsize = xsize
        if buf_ysize is None:
            buf_ysize = ysize

        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType;

        return _gdal.Dataset_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                            buf_xsize, buf_ysize, buf_type,
                                            band_list, buf_pixel_space, buf_line_space, buf_band_space,
                                          resample_alg, callback, callback_data, buf_obj )

    def GetVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype=None, band_list=None, band_sequential = True,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options=None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping.
           If there are several bands and band_sequential = True, an element is
           accessed with array[band][y][x].
           If there are several bands and band_sequential = False, an element is
           accessed with array[y][x][band].
           If there is only one band, an element is accessed with array[y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        from osgeo import gdal_array
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if bufxsize is None:
            bufxsize = self.RasterXSize
        if bufysize is None:
            bufysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if options is None:
            virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, band_list, band_sequential, cache_size, page_size_hint)
        else:
            virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, band_list, band_sequential, cache_size, page_size_hint,  options)
        return gdal_array.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, tilexsize=256, tileysize=256,
                           datatype=None, band_list=None, tile_organization=gdalconst.GTO_BSQ,
                           cache_size = 10 * 1024 * 1024, options=None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping with
           a tile organization.
           If there are several bands and tile_organization = gdal.GTO_TIP, an element is
           accessed with array[tiley][tilex][y][x][band].
           If there are several bands and tile_organization = gdal.GTO_BIT, an element is
           accessed with array[tiley][tilex][band][y][x].
           If there are several bands and tile_organization = gdal.GTO_BSQ, an element is
           accessed with array[band][tiley][tilex][y][x].
           If there is only one band, an element is accessed with array[tiley][tilex][y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        from osgeo import gdal_array
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if options is None:
            virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,band_list,tile_organization,cache_size)
        else:
            virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,band_list,tile_organization,cache_size, options)
        return gdal_array.VirtualMemGetArray( virtualmem )

    def GetSubDatasets(self):
        sd_list = []

        sd = self.GetMetadata('SUBDATASETS')
        if sd is None:
            return sd_list

        i = 1
        while 'SUBDATASET_'+str(i)+'_NAME' in sd:
            sd_list.append((sd['SUBDATASET_'+str(i)+'_NAME'],
                            sd['SUBDATASET_'+str(i)+'_DESC']))
            i = i + 1
        return sd_list

    def BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj=None, buf_xsize=None, buf_ysize=None, buf_type=None, band_list=None, options=None):
        if band_list is None:
            band_list = list(range(1, self.RasterCount + 1))
        if buf_xsize is None:
            buf_xsize = 0;
        if buf_ysize is None:
            buf_ysize = 0;
        if buf_type is None:
            buf_type = gdalconst.GDT_Byte

        if buf_xsize <= 0:
            buf_xsize = xsize
        if buf_ysize <= 0:
            buf_ysize = ysize
        options = [] if options is None else options

        if buf_obj is None:
            from sys import version_info
            nRequiredSize = int(buf_xsize * buf_ysize * len(band_list) * (_gdal.GetDataTypeSize(buf_type) / 8))
            if version_info >= (3, 0, 0):
                buf_obj_ar = [None]
                exec("buf_obj_ar[0] = b' ' * nRequiredSize")
                buf_obj = buf_obj_ar[0]
            else:
                buf_obj = ' ' * nRequiredSize
        return _gdal.Dataset_BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj, buf_xsize, buf_ysize, buf_type, band_list,  0, 0, 0, options)

    def GetLayer(self, iLayer=0):
        """Return the layer given an index or a name"""
        if isinstance(iLayer, str):
            return self.GetLayerByName(str(iLayer))
        elif isinstance(iLayer, int):
            return self.GetLayerByIndex(iLayer)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(iLayer))

    def DeleteLayer(self, value):
        """Deletes the layer given an index or layer name"""
        if isinstance(value, str):
            for i in range(self.GetLayerCount()):
                name = self.GetLayer(i).GetName()
                if name == value:
                    return _gdal.Dataset_DeleteLayer(self, i)
            raise ValueError("Layer %s not found to delete" % value)
        elif isinstance(value, int):
            return _gdal.Dataset_DeleteLayer(self, value)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(value))

    def SetGCPs(self, gcps, wkt_or_spatial_ref):
        if isinstance(wkt_or_spatial_ref, str):
            return self._SetGCPs(gcps, wkt_or_spatial_ref)
        else:
            return self._SetGCPs2(gcps, wkt_or_spatial_ref)

Dataset_swigregister = _gdal.Dataset_swigregister
Dataset_swigregister(Dataset)

class Group(_object):
    """Proxy of C++ GDALGroupHS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Group, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Group, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_Group
    __del__ = lambda self: None

    def GetName(self, *args):
        """GetName(Group self) -> char const *"""
        return _gdal.Group_GetName(self, *args)


    def GetFullName(self, *args):
        """GetFullName(Group self) -> char const *"""
        return _gdal.Group_GetFullName(self, *args)


    def GetMDArrayNames(self, *args):
        """GetMDArrayNames(Group self, char ** options=None) -> char **"""
        return _gdal.Group_GetMDArrayNames(self, *args)


    def OpenMDArray(self, *args):
        """OpenMDArray(Group self, char const * name, char ** options=None) -> MDArray"""
        return _gdal.Group_OpenMDArray(self, *args)


    def OpenMDArrayFromFullname(self, *args):
        """OpenMDArrayFromFullname(Group self, char const * name, char ** options=None) -> MDArray"""
        return _gdal.Group_OpenMDArrayFromFullname(self, *args)


    def ResolveMDArray(self, *args):
        """ResolveMDArray(Group self, char const * name, char const * starting_point, char ** options=None) -> MDArray"""
        return _gdal.Group_ResolveMDArray(self, *args)


    def GetGroupNames(self, *args):
        """GetGroupNames(Group self, char ** options=None) -> char **"""
        return _gdal.Group_GetGroupNames(self, *args)


    def OpenGroup(self, *args):
        """OpenGroup(Group self, char const * name, char ** options=None) -> Group"""
        return _gdal.Group_OpenGroup(self, *args)


    def OpenGroupFromFullname(self, *args):
        """OpenGroupFromFullname(Group self, char const * name, char ** options=None) -> Group"""
        return _gdal.Group_OpenGroupFromFullname(self, *args)


    def GetDimensions(self, *args):
        """GetDimensions(Group self, char ** options=None)"""
        return _gdal.Group_GetDimensions(self, *args)


    def GetAttribute(self, *args):
        """GetAttribute(Group self, char const * name) -> Attribute"""
        return _gdal.Group_GetAttribute(self, *args)


    def GetAttributes(self, *args):
        """GetAttributes(Group self, char ** options=None)"""
        return _gdal.Group_GetAttributes(self, *args)


    def GetStructuralInfo(self, *args):
        """GetStructuralInfo(Group self) -> char **"""
        return _gdal.Group_GetStructuralInfo(self, *args)


    def CreateGroup(self, *args):
        """CreateGroup(Group self, char const * name, char ** options=None) -> Group"""
        return _gdal.Group_CreateGroup(self, *args)


    def CreateDimension(self, *args):
        """CreateDimension(Group self, char const * name, char const * type, char const * direction, unsigned long long size, char ** options=None) -> Dimension"""
        return _gdal.Group_CreateDimension(self, *args)


    def CreateMDArray(self, *args):
        """CreateMDArray(Group self, char const * name, int nDimensions, ExtendedDataType data_type, char ** options=None) -> MDArray"""
        return _gdal.Group_CreateMDArray(self, *args)


    def CreateAttribute(self, *args):
        """CreateAttribute(Group self, char const * name, int nDimensions, ExtendedDataType data_type, char ** options=None) -> Attribute"""
        return _gdal.Group_CreateAttribute(self, *args)

Group_swigregister = _gdal.Group_swigregister
Group_swigregister(Group)

class Statistics(_object):
    """Proxy of C++ Statistics class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Statistics, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Statistics, name)
    __repr__ = _swig_repr
    __swig_getmethods__["min"] = _gdal.Statistics_min_get
    if _newclass:
        min = _swig_property(_gdal.Statistics_min_get)
    __swig_getmethods__["max"] = _gdal.Statistics_max_get
    if _newclass:
        max = _swig_property(_gdal.Statistics_max_get)
    __swig_getmethods__["mean"] = _gdal.Statistics_mean_get
    if _newclass:
        mean = _swig_property(_gdal.Statistics_mean_get)
    __swig_getmethods__["std_dev"] = _gdal.Statistics_std_dev_get
    if _newclass:
        std_dev = _swig_property(_gdal.Statistics_std_dev_get)
    __swig_getmethods__["valid_count"] = _gdal.Statistics_valid_count_get
    if _newclass:
        valid_count = _swig_property(_gdal.Statistics_valid_count_get)
    __swig_destroy__ = _gdal.delete_Statistics
    __del__ = lambda self: None

    def __init__(self, *args):
        """__init__(Statistics self) -> Statistics"""
        this = _gdal.new_Statistics(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
Statistics_swigregister = _gdal.Statistics_swigregister
Statistics_swigregister(Statistics)

class MDArray(_object):
    """Proxy of C++ GDALMDArrayHS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MDArray, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MDArray, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_MDArray
    __del__ = lambda self: None

    def GetName(self, *args):
        """GetName(MDArray self) -> char const *"""
        return _gdal.MDArray_GetName(self, *args)


    def GetFullName(self, *args):
        """GetFullName(MDArray self) -> char const *"""
        return _gdal.MDArray_GetFullName(self, *args)


    def GetTotalElementsCount(self, *args):
        """GetTotalElementsCount(MDArray self) -> unsigned long long"""
        return _gdal.MDArray_GetTotalElementsCount(self, *args)


    def GetDimensionCount(self, *args):
        """GetDimensionCount(MDArray self) -> size_t"""
        return _gdal.MDArray_GetDimensionCount(self, *args)


    def GetDimensions(self, *args):
        """GetDimensions(MDArray self)"""
        return _gdal.MDArray_GetDimensions(self, *args)


    def GetBlockSize(self, *args):
        """GetBlockSize(MDArray self)"""
        return _gdal.MDArray_GetBlockSize(self, *args)


    def GetProcessingChunkSize(self, *args):
        """GetProcessingChunkSize(MDArray self, size_t nMaxChunkMemory)"""
        return _gdal.MDArray_GetProcessingChunkSize(self, *args)


    def GetDataType(self, *args):
        """GetDataType(MDArray self) -> ExtendedDataType"""
        return _gdal.MDArray_GetDataType(self, *args)


    def GetStructuralInfo(self, *args):
        """GetStructuralInfo(MDArray self) -> char **"""
        return _gdal.MDArray_GetStructuralInfo(self, *args)


    def Read(self, *args):
        """Read(MDArray self, int nDims1, int nDims2, int nDims3, int nDims4, ExtendedDataType buffer_datatype) -> CPLErr"""
        return _gdal.MDArray_Read(self, *args)


    def WriteStringArray(self, *args):
        """WriteStringArray(MDArray self, int nDims1, int nDims2, int nDims3, ExtendedDataType buffer_datatype, char ** options) -> CPLErr"""
        return _gdal.MDArray_WriteStringArray(self, *args)


    def Write(self, *args):
        """Write(MDArray self, int nDims1, int nDims2, int nDims3, int nDims4, ExtendedDataType buffer_datatype, GIntBig buf_len) -> CPLErr"""
        return _gdal.MDArray_Write(self, *args)


    def AdviseRead(self, *args):
        """AdviseRead(MDArray self, int nDims1, int nDims2) -> CPLErr"""
        return _gdal.MDArray_AdviseRead(self, *args)


    def GetAttribute(self, *args):
        """GetAttribute(MDArray self, char const * name) -> Attribute"""
        return _gdal.MDArray_GetAttribute(self, *args)


    def GetAttributes(self, *args):
        """GetAttributes(MDArray self, char ** options=None)"""
        return _gdal.MDArray_GetAttributes(self, *args)


    def CreateAttribute(self, *args):
        """CreateAttribute(MDArray self, char const * name, int nDimensions, ExtendedDataType data_type, char ** options=None) -> Attribute"""
        return _gdal.MDArray_CreateAttribute(self, *args)


    def GetNoDataValueAsRaw(self, *args):
        """GetNoDataValueAsRaw(MDArray self) -> CPLErr"""
        return _gdal.MDArray_GetNoDataValueAsRaw(self, *args)


    def GetNoDataValueAsDouble(self, *args):
        """GetNoDataValueAsDouble(MDArray self)"""
        return _gdal.MDArray_GetNoDataValueAsDouble(self, *args)


    def SetNoDataValueDouble(self, *args):
        """SetNoDataValueDouble(MDArray self, double d) -> CPLErr"""
        return _gdal.MDArray_SetNoDataValueDouble(self, *args)


    def SetNoDataValueRaw(self, *args):
        """SetNoDataValueRaw(MDArray self, GIntBig nLen) -> CPLErr"""
        return _gdal.MDArray_SetNoDataValueRaw(self, *args)


    def DeleteNoDataValue(self, *args):
        """DeleteNoDataValue(MDArray self) -> CPLErr"""
        return _gdal.MDArray_DeleteNoDataValue(self, *args)


    def GetOffset(self, *args):
        """GetOffset(MDArray self)"""
        return _gdal.MDArray_GetOffset(self, *args)


    def GetOffsetStorageType(self, *args):
        """GetOffsetStorageType(MDArray self) -> GDALDataType"""
        return _gdal.MDArray_GetOffsetStorageType(self, *args)


    def GetScale(self, *args):
        """GetScale(MDArray self)"""
        return _gdal.MDArray_GetScale(self, *args)


    def GetScaleStorageType(self, *args):
        """GetScaleStorageType(MDArray self) -> GDALDataType"""
        return _gdal.MDArray_GetScaleStorageType(self, *args)


    def SetOffset(self, *args, **kwargs):
        """SetOffset(MDArray self, double val, GDALDataType storageType) -> CPLErr"""
        return _gdal.MDArray_SetOffset(self, *args, **kwargs)


    def SetScale(self, *args, **kwargs):
        """SetScale(MDArray self, double val, GDALDataType storageType) -> CPLErr"""
        return _gdal.MDArray_SetScale(self, *args, **kwargs)


    def SetUnit(self, *args):
        """SetUnit(MDArray self, char const * unit) -> CPLErr"""
        return _gdal.MDArray_SetUnit(self, *args)


    def GetUnit(self, *args):
        """GetUnit(MDArray self) -> char const *"""
        return _gdal.MDArray_GetUnit(self, *args)


    def SetSpatialRef(self, *args):
        """SetSpatialRef(MDArray self, SpatialReference srs) -> OGRErr"""
        return _gdal.MDArray_SetSpatialRef(self, *args)


    def GetSpatialRef(self, *args):
        """GetSpatialRef(MDArray self) -> SpatialReference"""
        return _gdal.MDArray_GetSpatialRef(self, *args)


    def GetView(self, *args):
        """GetView(MDArray self, char const * viewExpr) -> MDArray"""
        return _gdal.MDArray_GetView(self, *args)


    def Transpose(self, *args):
        """Transpose(MDArray self, int nList) -> MDArray"""
        return _gdal.MDArray_Transpose(self, *args)


    def GetUnscaled(self, *args):
        """GetUnscaled(MDArray self) -> MDArray"""
        return _gdal.MDArray_GetUnscaled(self, *args)


    def GetMask(self, *args):
        """GetMask(MDArray self, char ** options=None) -> MDArray"""
        return _gdal.MDArray_GetMask(self, *args)


    def AsClassicDataset(self, *args):
        """AsClassicDataset(MDArray self, size_t iXDim, size_t iYDim) -> Dataset"""
        return _gdal.MDArray_AsClassicDataset(self, *args)


    def GetStatistics(self, *args, **kwargs):
        """GetStatistics(MDArray self, Dataset ds=None, bool approx_ok=False, bool force=True, GDALProgressFunc callback=0, void * callback_data=None) -> Statistics"""
        return _gdal.MDArray_GetStatistics(self, *args, **kwargs)


    def ComputeStatistics(self, *args, **kwargs):
        """ComputeStatistics(MDArray self, Dataset ds=None, bool approx_ok=False, GDALProgressFunc callback=0, void * callback_data=None) -> Statistics"""
        return _gdal.MDArray_ComputeStatistics(self, *args, **kwargs)


    def Read(self,
             array_start_idx = None,
             count = None,
             array_step = None,
             buffer_stride = None,
             buffer_datatype = None):
        if not array_start_idx:
          array_start_idx = [0] * self.GetDimensionCount()
        if not count:
          count = [ dim.GetSize() for dim in self.GetDimensions() ]
        if not array_step:
          array_step = [1] * self.GetDimensionCount()
        if not buffer_stride:
          stride = 1
          buffer_stride = []
    # To compute strides we must proceed from the fastest varying dimension
    # (the last one), and then reverse the result
          for cnt in reversed(count):
              buffer_stride.append(stride)
              stride *= cnt
          buffer_stride.reverse()
        if not buffer_datatype:
          buffer_datatype = self.GetDataType()
        return _gdal.MDArray_Read(self, array_start_idx, count, array_step, buffer_stride, buffer_datatype)

    def ReadAsArray(self,
                    array_start_idx = None,
                    count = None,
                    array_step = None,
                    buffer_datatype = None,
                    buf_obj = None):

        from osgeo import gdal_array
        return gdal_array.MDArrayReadAsArray(self, array_start_idx, count, array_step, buffer_datatype, buf_obj)

    def AdviseRead(self, array_start_idx = None, count = None):
        if not array_start_idx:
          array_start_idx = [0] * self.GetDimensionCount()
        if not count:
          count = [ (self.GetDimensions()[i].GetSize() - array_start_idx[i]) for i in range (self.GetDimensionCount()) ]
        return _gdal.MDArray_AdviseRead(self, array_start_idx, count)

    def __getitem__(self, item):

          def stringify(v):
              if v == Ellipsis:
                  return '...'
              if isinstance(v, slice):
                  return ':'.join([str(x) if x is not None else '' for x in (v.start, v.stop, v.step)])
              if isinstance(v, str):
                  return v
              if isinstance(v, (int, type(12345678901234))):
                  return str(v)
              try:
                  import numpy as np
                  if v == np.newaxis:
                      return 'newaxis'
              except:
                  pass

              return str(v)

          if isinstance(item, str):
              return self.GetView('["' + item.replace('\\', '\\\\').replace('"', '\\"') + '"]')
          elif isinstance(item, slice):
              return self.GetView('[' + stringify(item) + ']')
          elif isinstance(item, tuple):
              return self.GetView('[' + ','.join([stringify(x) for x in item]) + ']')
          else:
              return self.GetView('[' + stringify(item) + ']')

    def Write(self,
             buffer,
             array_start_idx = None,
             count = None,
             array_step = None,
             buffer_stride = None,
             buffer_datatype = None):

        dimCount = self.GetDimensionCount()

    # Redirect to numpy-friendly WriteArray() if buffer is a numpy array
    # and other arguments are compatible
        if type(buffer).__name__ == 'ndarray' and \
           count is None and buffer_stride is None and buffer_datatype is None:
            return self.WriteArray(buffer, array_start_idx=array_start_idx, array_step=array_step)

    # Special case for buffer of type array and 1D arrays
        if dimCount == 1 and type(buffer).__name__ == 'array' and \
           count is None and buffer_stride is None and buffer_datatype is None:
            map_typecode_itemsize_to_gdal = {
               ('B',1): GDT_Byte,
               ('h',2): GDT_Int16,
               ('H',2): GDT_UInt16,
               ('i',4): GDT_Int32,
               ('I',4): GDT_UInt32,
               ('l',4): GDT_Int32,
    # ('l',8): GDT_Int64,
    # ('q',8): GDT_Int64,
    # ('Q',8): GDT_UInt64,
               ('f', 4): GDT_Float32,
               ('d', 8): GDT_Float64
            }
            key = (buffer.typecode, buffer.itemsize)
            if key not in map_typecode_itemsize_to_gdal:
                raise Exception("unhandled type for buffer of type array")
            buffer_datatype = ExtendedDataType.Create(map_typecode_itemsize_to_gdal[key])

    # Special case for a list of numeric values and 1D arrays
        elif dimCount == 1 and type(buffer) == type([]) and len(buffer) != 0 \
             and self.GetDataType().GetClass() != GEDTC_STRING:
            buffer_datatype = GDT_Int32
            for v in buffer:
                if isinstance(v, int):
                    if v >= (1 << 31) or v < -(1 << 31):
                        buffer_datatype = GDT_Float64
                elif isinstance(v, float):
                    buffer_datatype = GDT_Float64
                else:
                    raise ValueError('Only lists with integer or float elements are supported')
            import array
            buffer = array.array('d' if buffer_datatype == GDT_Float64 else 'i', buffer)
            buffer_datatype = ExtendedDataType.Create(buffer_datatype)

        if not buffer_datatype:
          buffer_datatype = self.GetDataType()

        is_1d_string = self.GetDataType().GetClass() == GEDTC_STRING and buffer_datatype.GetClass() == GEDTC_STRING and dimCount == 1

        if not array_start_idx:
          array_start_idx = [0] * dimCount

        if not count:
          if is_1d_string:
              assert type(buffer) == type([])
              count = [ len(buffer) ]
          else:
              count = [ dim.GetSize() for dim in self.GetDimensions() ]

        if not array_step:
          array_step = [1] * dimCount

        if not buffer_stride:
          stride = 1
          buffer_stride = []
    # To compute strides we must proceed from the fastest varying dimension
    # (the last one), and then reverse the result
          for cnt in reversed(count):
              buffer_stride.append(stride)
              stride *= cnt
          buffer_stride.reverse()

        if is_1d_string:
            return _gdal.MDArray_WriteStringArray(self, array_start_idx, count, array_step, buffer_datatype, buffer)

        return _gdal.MDArray_Write(self, array_start_idx, count, array_step, buffer_stride, buffer_datatype, buffer)

    def WriteArray(self, array,
                    array_start_idx = None,
                    array_step = None):

        from osgeo import gdal_array
        return gdal_array.MDArrayWriteArray(self, array, array_start_idx, array_step)

    def ReadAsMaskedArray(self,
                    array_start_idx = None,
                    count = None,
                    array_step = None):
        """ Return a numpy masked array of ReadAsArray() with GetMask() """
        import numpy
        mask = self.GetMask()
        if mask is not None:
            array = self.ReadAsArray(array_start_idx, count, array_step)
            mask_array = mask.ReadAsArray(array_start_idx, count, array_step)
            bool_array = ~mask_array.astype(bool)
            return numpy.ma.array(array, mask=bool_array)
        else:
            return numpy.ma.array(self.ReadAsArray(array_start_idx, count, array_step), mask=None)

    def GetShape(self):
      """ Return the shape of the array """
      if not self.GetDimensionCount():
        return None
      shp = ()
      for dim in self.GetDimensions():
        shp += (dim.GetSize(),)
      return shp

    shape = property(fget=GetShape, doc='Returns the shape of the array.')


MDArray_swigregister = _gdal.MDArray_swigregister
MDArray_swigregister(MDArray)

class Attribute(_object):
    """Proxy of C++ GDALAttributeHS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Attribute, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Attribute, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_Attribute
    __del__ = lambda self: None

    def GetName(self, *args):
        """GetName(Attribute self) -> char const *"""
        return _gdal.Attribute_GetName(self, *args)


    def GetFullName(self, *args):
        """GetFullName(Attribute self) -> char const *"""
        return _gdal.Attribute_GetFullName(self, *args)


    def GetTotalElementsCount(self, *args):
        """GetTotalElementsCount(Attribute self) -> unsigned long long"""
        return _gdal.Attribute_GetTotalElementsCount(self, *args)


    def GetDimensionCount(self, *args):
        """GetDimensionCount(Attribute self) -> size_t"""
        return _gdal.Attribute_GetDimensionCount(self, *args)


    def GetDimensionsSize(self, *args):
        """GetDimensionsSize(Attribute self)"""
        return _gdal.Attribute_GetDimensionsSize(self, *args)


    def GetDataType(self, *args):
        """GetDataType(Attribute self) -> ExtendedDataType"""
        return _gdal.Attribute_GetDataType(self, *args)


    def ReadAsRaw(self, *args):
        """ReadAsRaw(Attribute self) -> CPLErr"""
        return _gdal.Attribute_ReadAsRaw(self, *args)


    def ReadAsString(self, *args):
        """ReadAsString(Attribute self) -> char const *"""
        return _gdal.Attribute_ReadAsString(self, *args)


    def ReadAsInt(self, *args):
        """ReadAsInt(Attribute self) -> int"""
        return _gdal.Attribute_ReadAsInt(self, *args)


    def ReadAsDouble(self, *args):
        """ReadAsDouble(Attribute self) -> double"""
        return _gdal.Attribute_ReadAsDouble(self, *args)


    def ReadAsStringArray(self, *args):
        """ReadAsStringArray(Attribute self) -> char **"""
        return _gdal.Attribute_ReadAsStringArray(self, *args)


    def ReadAsIntArray(self, *args):
        """ReadAsIntArray(Attribute self)"""
        return _gdal.Attribute_ReadAsIntArray(self, *args)


    def ReadAsDoubleArray(self, *args):
        """ReadAsDoubleArray(Attribute self)"""
        return _gdal.Attribute_ReadAsDoubleArray(self, *args)


    def WriteRaw(self, *args):
        """WriteRaw(Attribute self, GIntBig nLen) -> CPLErr"""
        return _gdal.Attribute_WriteRaw(self, *args)


    def WriteString(self, *args):
        """WriteString(Attribute self, char const * val) -> CPLErr"""
        return _gdal.Attribute_WriteString(self, *args)


    def WriteStringArray(self, *args):
        """WriteStringArray(Attribute self, char ** vals) -> CPLErr"""
        return _gdal.Attribute_WriteStringArray(self, *args)


    def WriteInt(self, *args):
        """WriteInt(Attribute self, int val) -> CPLErr"""
        return _gdal.Attribute_WriteInt(self, *args)


    def WriteDouble(self, *args):
        """WriteDouble(Attribute self, double val) -> CPLErr"""
        return _gdal.Attribute_WriteDouble(self, *args)


    def WriteDoubleArray(self, *args):
        """WriteDoubleArray(Attribute self, int nList) -> CPLErr"""
        return _gdal.Attribute_WriteDoubleArray(self, *args)



    def Read(self):
      """ Read an attribute and return it with the most appropriate type """
      dt_class = self.GetDataType().GetClass()
      if dt_class == GEDTC_STRING:
          if self.GetTotalElementsCount() == 1:
              return self.ReadAsString()
          return self.ReadAsStringArray()
      if dt_class == GEDTC_NUMERIC:
          if self.GetDataType().GetNumericDataType() in (GDT_Byte, GDT_Int16, GDT_UInt16, GDT_Int32):
              if self.GetTotalElementsCount() == 1:
                  return self.ReadAsInt()
              else:
                  return self.ReadAsIntArray()
          else:
              if self.GetTotalElementsCount() == 1:
                  return self.ReadAsDouble()
              else:
                  return self.ReadAsDoubleArray()
      return self.ReadAsRaw()

    def Write(self, val):
      if isinstance(val, (int, type(12345678901234))):
          if val >= -0x80000000 and val <= 0x7FFFFFFF:
              return self.WriteInt(val)
          else:
              return self.WriteDouble(val)
      if isinstance(val, float):
        return self.WriteDouble(val)
      if isinstance(val, str) and self.GetDataType().GetClass() != GEDTC_COMPOUND:
        return self.WriteString(val)
      if isinstance(val, list):
        if len(val) == 0:
          if self.GetDataType().GetClass() == GEDTC_STRING:
              return self.WriteStringArray(val)
          else:
              return self.WriteDoubleArray(val)
        if isinstance(val[0], (int, type(12345678901234), float)):
          return self.WriteDoubleArray(val)
        if isinstance(val[0], str):
          return self.WriteStringArray(val)
      return self.WriteRaw(val)


Attribute_swigregister = _gdal.Attribute_swigregister
Attribute_swigregister(Attribute)

class Dimension(_object):
    """Proxy of C++ GDALDimensionHS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Dimension, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Dimension, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_Dimension
    __del__ = lambda self: None

    def GetName(self, *args):
        """GetName(Dimension self) -> char const *"""
        return _gdal.Dimension_GetName(self, *args)


    def GetFullName(self, *args):
        """GetFullName(Dimension self) -> char const *"""
        return _gdal.Dimension_GetFullName(self, *args)


    def GetType(self, *args):
        """GetType(Dimension self) -> char const *"""
        return _gdal.Dimension_GetType(self, *args)


    def GetDirection(self, *args):
        """GetDirection(Dimension self) -> char const *"""
        return _gdal.Dimension_GetDirection(self, *args)


    def GetSize(self, *args):
        """GetSize(Dimension self) -> unsigned long long"""
        return _gdal.Dimension_GetSize(self, *args)


    def GetIndexingVariable(self, *args):
        """GetIndexingVariable(Dimension self) -> MDArray"""
        return _gdal.Dimension_GetIndexingVariable(self, *args)


    def SetIndexingVariable(self, *args):
        """SetIndexingVariable(Dimension self, MDArray array) -> bool"""
        return _gdal.Dimension_SetIndexingVariable(self, *args)

Dimension_swigregister = _gdal.Dimension_swigregister
Dimension_swigregister(Dimension)

GEDTC_NUMERIC = _gdal.GEDTC_NUMERIC
GEDTC_STRING = _gdal.GEDTC_STRING
GEDTC_COMPOUND = _gdal.GEDTC_COMPOUND
class ExtendedDataType(_object):
    """Proxy of C++ GDALExtendedDataTypeHS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedDataType, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedDataType, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_ExtendedDataType
    __del__ = lambda self: None

    def Create(*args):
        """Create(GDALDataType dt) -> ExtendedDataType"""
        return _gdal.ExtendedDataType_Create(*args)

    Create = staticmethod(Create)

    def CreateString(*args):
        """CreateString(size_t nMaxStringLength=0) -> ExtendedDataType"""
        return _gdal.ExtendedDataType_CreateString(*args)

    CreateString = staticmethod(CreateString)

    def CreateCompound(*args):
        """CreateCompound(char const * name, size_t nTotalSize, int nComps) -> ExtendedDataType"""
        return _gdal.ExtendedDataType_CreateCompound(*args)

    CreateCompound = staticmethod(CreateCompound)

    def GetName(self, *args):
        """GetName(ExtendedDataType self) -> char const *"""
        return _gdal.ExtendedDataType_GetName(self, *args)


    def GetClass(self, *args):
        """GetClass(ExtendedDataType self) -> GDALExtendedDataTypeClass"""
        return _gdal.ExtendedDataType_GetClass(self, *args)


    def GetNumericDataType(self, *args):
        """GetNumericDataType(ExtendedDataType self) -> GDALDataType"""
        return _gdal.ExtendedDataType_GetNumericDataType(self, *args)


    def GetSize(self, *args):
        """GetSize(ExtendedDataType self) -> size_t"""
        return _gdal.ExtendedDataType_GetSize(self, *args)


    def GetMaxStringLength(self, *args):
        """GetMaxStringLength(ExtendedDataType self) -> size_t"""
        return _gdal.ExtendedDataType_GetMaxStringLength(self, *args)


    def GetComponents(self, *args):
        """GetComponents(ExtendedDataType self)"""
        return _gdal.ExtendedDataType_GetComponents(self, *args)


    def CanConvertTo(self, *args):
        """CanConvertTo(ExtendedDataType self, ExtendedDataType other) -> bool"""
        return _gdal.ExtendedDataType_CanConvertTo(self, *args)


    def Equals(self, *args):
        """Equals(ExtendedDataType self, ExtendedDataType other) -> bool"""
        return _gdal.ExtendedDataType_Equals(self, *args)



    def __eq__(self, other):
      return self.Equals(other)

    def __ne__(self, other):
      return not self.__eq__(other)

ExtendedDataType_swigregister = _gdal.ExtendedDataType_swigregister
ExtendedDataType_swigregister(ExtendedDataType)

def ExtendedDataType_Create(*args):
    """ExtendedDataType_Create(GDALDataType dt) -> ExtendedDataType"""
    return _gdal.ExtendedDataType_Create(*args)

def ExtendedDataType_CreateString(*args):
    """ExtendedDataType_CreateString(size_t nMaxStringLength=0) -> ExtendedDataType"""
    return _gdal.ExtendedDataType_CreateString(*args)

def ExtendedDataType_CreateCompound(*args):
    """ExtendedDataType_CreateCompound(char const * name, size_t nTotalSize, int nComps) -> ExtendedDataType"""
    return _gdal.ExtendedDataType_CreateCompound(*args)

class EDTComponent(_object):
    """Proxy of C++ GDALEDTComponentHS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EDTComponent, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EDTComponent, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_EDTComponent
    __del__ = lambda self: None

    def Create(*args):
        """Create(char const * name, size_t offset, ExtendedDataType type) -> EDTComponent"""
        return _gdal.EDTComponent_Create(*args)

    Create = staticmethod(Create)

    def GetName(self, *args):
        """GetName(EDTComponent self) -> char const *"""
        return _gdal.EDTComponent_GetName(self, *args)


    def GetOffset(self, *args):
        """GetOffset(EDTComponent self) -> size_t"""
        return _gdal.EDTComponent_GetOffset(self, *args)


    def GetType(self, *args):
        """GetType(EDTComponent self) -> ExtendedDataType"""
        return _gdal.EDTComponent_GetType(self, *args)

EDTComponent_swigregister = _gdal.EDTComponent_swigregister
EDTComponent_swigregister(EDTComponent)

def EDTComponent_Create(*args):
    """EDTComponent_Create(char const * name, size_t offset, ExtendedDataType type) -> EDTComponent"""
    return _gdal.EDTComponent_Create(*args)

class Band(MajorObject):
    """Proxy of C++ GDALRasterBandShadow class."""

    __swig_setmethods__ = {}
    for _s in [MajorObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Band, name, value)
    __swig_getmethods__ = {}
    for _s in [MajorObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Band, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["XSize"] = _gdal.Band_XSize_get
    if _newclass:
        XSize = _swig_property(_gdal.Band_XSize_get)
    __swig_getmethods__["YSize"] = _gdal.Band_YSize_get
    if _newclass:
        YSize = _swig_property(_gdal.Band_YSize_get)
    __swig_getmethods__["DataType"] = _gdal.Band_DataType_get
    if _newclass:
        DataType = _swig_property(_gdal.Band_DataType_get)

    def GetDataset(self, *args):
        """GetDataset(Band self) -> Dataset"""
        return _gdal.Band_GetDataset(self, *args)


    def GetBand(self, *args):
        """GetBand(Band self) -> int"""
        return _gdal.Band_GetBand(self, *args)


    def GetBlockSize(self, *args):
        """GetBlockSize(Band self)"""
        return _gdal.Band_GetBlockSize(self, *args)


    def GetActualBlockSize(self, *args):
        """GetActualBlockSize(Band self, int nXBlockOff, int nYBlockOff)"""
        return _gdal.Band_GetActualBlockSize(self, *args)


    def GetColorInterpretation(self, *args):
        """GetColorInterpretation(Band self) -> GDALColorInterp"""
        return _gdal.Band_GetColorInterpretation(self, *args)


    def GetRasterColorInterpretation(self, *args):
        """GetRasterColorInterpretation(Band self) -> GDALColorInterp"""
        return _gdal.Band_GetRasterColorInterpretation(self, *args)


    def SetColorInterpretation(self, *args):
        """SetColorInterpretation(Band self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetColorInterpretation(self, *args)


    def SetRasterColorInterpretation(self, *args):
        """SetRasterColorInterpretation(Band self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetRasterColorInterpretation(self, *args)


    def GetNoDataValue(self, *args):
        """GetNoDataValue(Band self)"""
        return _gdal.Band_GetNoDataValue(self, *args)


    def SetNoDataValue(self, *args):
        """SetNoDataValue(Band self, double d) -> CPLErr"""
        return _gdal.Band_SetNoDataValue(self, *args)


    def DeleteNoDataValue(self, *args):
        """DeleteNoDataValue(Band self) -> CPLErr"""
        return _gdal.Band_DeleteNoDataValue(self, *args)


    def GetUnitType(self, *args):
        """GetUnitType(Band self) -> char const *"""
        return _gdal.Band_GetUnitType(self, *args)


    def SetUnitType(self, *args):
        """SetUnitType(Band self, char const * val) -> CPLErr"""
        return _gdal.Band_SetUnitType(self, *args)


    def GetRasterCategoryNames(self, *args):
        """GetRasterCategoryNames(Band self) -> char **"""
        return _gdal.Band_GetRasterCategoryNames(self, *args)


    def SetRasterCategoryNames(self, *args):
        """SetRasterCategoryNames(Band self, char ** names) -> CPLErr"""
        return _gdal.Band_SetRasterCategoryNames(self, *args)


    def GetMinimum(self, *args):
        """GetMinimum(Band self)"""
        return _gdal.Band_GetMinimum(self, *args)


    def GetMaximum(self, *args):
        """GetMaximum(Band self)"""
        return _gdal.Band_GetMaximum(self, *args)


    def GetOffset(self, *args):
        """GetOffset(Band self)"""
        return _gdal.Band_GetOffset(self, *args)


    def GetScale(self, *args):
        """GetScale(Band self)"""
        return _gdal.Band_GetScale(self, *args)


    def SetOffset(self, *args):
        """SetOffset(Band self, double val) -> CPLErr"""
        return _gdal.Band_SetOffset(self, *args)


    def SetScale(self, *args):
        """SetScale(Band self, double val) -> CPLErr"""
        return _gdal.Band_SetScale(self, *args)


    def GetStatistics(self, *args):
        """GetStatistics(Band self, int approx_ok, int force) -> CPLErr"""
        return _gdal.Band_GetStatistics(self, *args)


    def ComputeStatistics(self, *args):
        """ComputeStatistics(Band self, bool approx_ok, GDALProgressFunc callback=0, void * callback_data=None) -> CPLErr"""
        return _gdal.Band_ComputeStatistics(self, *args)


    def SetStatistics(self, *args):
        """SetStatistics(Band self, double min, double max, double mean, double stddev) -> CPLErr"""
        return _gdal.Band_SetStatistics(self, *args)


    def GetOverviewCount(self, *args):
        """GetOverviewCount(Band self) -> int"""
        return _gdal.Band_GetOverviewCount(self, *args)


    def GetOverview(self, *args):
        """GetOverview(Band self, int i) -> Band"""
        return _gdal.Band_GetOverview(self, *args)


    def Checksum(self, *args, **kwargs):
        """Checksum(Band self, int xoff=0, int yoff=0, int * xsize=None, int * ysize=None) -> int"""
        return _gdal.Band_Checksum(self, *args, **kwargs)


    def ComputeRasterMinMax(self, *args):
        """ComputeRasterMinMax(Band self, int approx_ok=0)"""
        return _gdal.Band_ComputeRasterMinMax(self, *args)


    def ComputeBandStats(self, *args):
        """ComputeBandStats(Band self, int samplestep=1)"""
        return _gdal.Band_ComputeBandStats(self, *args)


    def Fill(self, *args):
        """Fill(Band self, double real_fill, double imag_fill=0.0) -> CPLErr"""
        return _gdal.Band_Fill(self, *args)


    def WriteRaster(self, *args, **kwargs):
        """WriteRaster(Band self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None) -> CPLErr"""
        return _gdal.Band_WriteRaster(self, *args, **kwargs)


    def FlushCache(self, *args):
        """FlushCache(Band self)"""
        return _gdal.Band_FlushCache(self, *args)


    def GetRasterColorTable(self, *args):
        """GetRasterColorTable(Band self) -> ColorTable"""
        return _gdal.Band_GetRasterColorTable(self, *args)


    def GetColorTable(self, *args):
        """GetColorTable(Band self) -> ColorTable"""
        return _gdal.Band_GetColorTable(self, *args)


    def SetRasterColorTable(self, *args):
        """SetRasterColorTable(Band self, ColorTable arg) -> int"""
        return _gdal.Band_SetRasterColorTable(self, *args)


    def SetColorTable(self, *args):
        """SetColorTable(Band self, ColorTable arg) -> int"""
        return _gdal.Band_SetColorTable(self, *args)


    def GetDefaultRAT(self, *args):
        """GetDefaultRAT(Band self) -> RasterAttributeTable"""
        return _gdal.Band_GetDefaultRAT(self, *args)


    def SetDefaultRAT(self, *args):
        """SetDefaultRAT(Band self, RasterAttributeTable table) -> int"""
        return _gdal.Band_SetDefaultRAT(self, *args)


    def GetMaskBand(self, *args):
        """GetMaskBand(Band self) -> Band"""
        return _gdal.Band_GetMaskBand(self, *args)


    def GetMaskFlags(self, *args):
        """GetMaskFlags(Band self) -> int"""
        return _gdal.Band_GetMaskFlags(self, *args)


    def CreateMaskBand(self, *args):
        """CreateMaskBand(Band self, int nFlags) -> CPLErr"""
        return _gdal.Band_CreateMaskBand(self, *args)


    def GetHistogram(self, *args, **kwargs):
        """GetHistogram(Band self, double min=-0.5, double max=255.5, int buckets=256, int include_out_of_range=0, int approx_ok=1, GDALProgressFunc callback=0, void * callback_data=None) -> CPLErr"""
        return _gdal.Band_GetHistogram(self, *args, **kwargs)


    def GetDefaultHistogram(self, *args, **kwargs):
        """GetDefaultHistogram(Band self, double * min_ret=None, double * max_ret=None, int * buckets_ret=None, GUIntBig ** ppanHistogram=None, int force=1, GDALProgressFunc callback=0, void * callback_data=None) -> CPLErr"""
        return _gdal.Band_GetDefaultHistogram(self, *args, **kwargs)


    def SetDefaultHistogram(self, *args):
        """SetDefaultHistogram(Band self, double min, double max, int buckets_in) -> CPLErr"""
        return _gdal.Band_SetDefaultHistogram(self, *args)


    def HasArbitraryOverviews(self, *args):
        """HasArbitraryOverviews(Band self) -> bool"""
        return _gdal.Band_HasArbitraryOverviews(self, *args)


    def GetCategoryNames(self, *args):
        """GetCategoryNames(Band self) -> char **"""
        return _gdal.Band_GetCategoryNames(self, *args)


    def SetCategoryNames(self, *args):
        """SetCategoryNames(Band self, char ** papszCategoryNames) -> CPLErr"""
        return _gdal.Band_SetCategoryNames(self, *args)


    def GetVirtualMem(self, *args, **kwargs):
        """GetVirtualMem(Band self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nBufXSize, int nBufYSize, GDALDataType eBufType, size_t nCacheSize, size_t nPageSizeHint, char ** options=None) -> VirtualMem"""
        return _gdal.Band_GetVirtualMem(self, *args, **kwargs)


    def GetVirtualMemAuto(self, *args, **kwargs):
        """GetVirtualMemAuto(Band self, GDALRWFlag eRWFlag, char ** options=None) -> VirtualMem"""
        return _gdal.Band_GetVirtualMemAuto(self, *args, **kwargs)


    def GetTiledVirtualMem(self, *args, **kwargs):
        """GetTiledVirtualMem(Band self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, int nYSize, int nTileXSize, int nTileYSize, GDALDataType eBufType, size_t nCacheSize, char ** options=None) -> VirtualMem"""
        return _gdal.Band_GetTiledVirtualMem(self, *args, **kwargs)


    def GetDataCoverageStatus(self, *args):
        """GetDataCoverageStatus(Band self, int nXOff, int nYOff, int nXSize, int nYSize, int nMaskFlagStop=0) -> int"""
        return _gdal.Band_GetDataCoverageStatus(self, *args)


    def AdviseRead(self, *args):
        """AdviseRead(Band self, int xoff, int yoff, int xsize, int ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, char ** options=None) -> CPLErr"""
        return _gdal.Band_AdviseRead(self, *args)


    def AsMDArray(self, *args):
        """AsMDArray(Band self) -> MDArray"""
        return _gdal.Band_AsMDArray(self, *args)


    def ReadRaster1(self, *args, **kwargs):
        """ReadRaster1(Band self, double xoff, double yoff, double xsize, double ysize, int * buf_xsize=None, int * buf_ysize=None, GDALDataType * buf_type=None, GIntBig * buf_pixel_space=None, GIntBig * buf_line_space=None, GDALRIOResampleAlg resample_alg, GDALProgressFunc callback=0, void * callback_data=None, void * inputOutputBuf=None) -> CPLErr"""
        return _gdal.Band_ReadRaster1(self, *args, **kwargs)


    def ReadBlock(self, *args, **kwargs):
        """ReadBlock(Band self, int xoff, int yoff, void * buf_obj=None) -> CPLErr"""
        return _gdal.Band_ReadBlock(self, *args, **kwargs)



    def ComputeStatistics(self, *args):
      """ComputeStatistics(Band self, bool approx_ok, GDALProgressFunc callback=0, void * callback_data=None) -> CPLErr"""

    # For backward compatibility. New SWIG has stricter typing and really
    # enforces bool
      approx_ok = args[0]
      if approx_ok == 0:
          approx_ok = False
      elif approx_ok == 1:
          approx_ok = True
      new_args = [approx_ok]
      for arg in args[1:]:
          new_args.append( arg )

      return _gdal.Band_ComputeStatistics(self, *new_args)


    def ReadRaster(self, xoff=0, yoff=0, xsize=None, ysize=None,
                   buf_xsize=None, buf_ysize=None, buf_type=None,
                   buf_pixel_space=None, buf_line_space=None,
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None,
                   buf_obj=None):

        if xsize is None:
            xsize = self.XSize
        if ysize is None:
            ysize = self.YSize

        return _gdal.Band_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                      buf_xsize, buf_ysize, buf_type,
                                      buf_pixel_space, buf_line_space,
                                      resample_alg, callback, callback_data,
                                      buf_obj)

    def WriteRaster(self, xoff, yoff, xsize, ysize,
                    buf_string,
                    buf_xsize=None, buf_ysize=None, buf_type=None,
                    buf_pixel_space=None, buf_line_space=None ):

        if buf_xsize is None:
            buf_xsize = xsize
        if buf_ysize is None:
            buf_ysize = ysize

    # Redirect to numpy-friendly WriteArray() if buf_string is a numpy array
    # and other arguments are compatible
        if type(buf_string).__name__ == 'ndarray' and \
           buf_xsize == xsize and buf_ysize == ysize and buf_type is None and \
           buf_pixel_space is None and buf_line_space is None:
            return self.WriteArray(buf_string, xoff=xoff, yoff=yoff)

        if buf_type is None:
            buf_type = self.DataType

        return _gdal.Band_WriteRaster(self,
                 xoff, yoff, xsize, ysize,
                buf_string, buf_xsize, buf_ysize, buf_type,
                buf_pixel_space, buf_line_space )

    def ReadAsArray(self, xoff=0, yoff=0, win_xsize=None, win_ysize=None,
                    buf_xsize=None, buf_ysize=None, buf_type=None, buf_obj=None,
                    resample_alg=gdalconst.GRIORA_NearestNeighbour,
                    callback=None,
                    callback_data=None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        from osgeo import gdal_array

        return gdal_array.BandReadAsArray(self, xoff, yoff,
                                           win_xsize, win_ysize,
                                           buf_xsize, buf_ysize, buf_type, buf_obj,
                                           resample_alg=resample_alg,
                                           callback=callback,
                                           callback_data=callback_data)

    def WriteArray(self, array, xoff=0, yoff=0,
                   resample_alg=gdalconst.GRIORA_NearestNeighbour,
                   callback=None,
                   callback_data=None):
        from osgeo import gdal_array

        return gdal_array.BandWriteArray(self, array, xoff, yoff,
                                          resample_alg=resample_alg,
                                          callback=callback,
                                          callback_data=callback_data)

    def GetVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype=None,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options=None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          from osgeo import gdal_array
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if bufxsize is None:
              bufxsize = self.XSize
          if bufysize is None:
              bufysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, cache_size, page_size_hint)
          else:
              virtualmem = self.GetVirtualMem(eAccess, xoff, yoff, xsize, ysize, bufxsize, bufysize, datatype, cache_size, page_size_hint, options)
          return gdal_array.VirtualMemGetArray(virtualmem)

    def GetVirtualMemAutoArray(self, eAccess=gdalconst.GF_Read, options=None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          from osgeo import gdal_array
          if options is None:
              virtualmem = self.GetVirtualMemAuto(eAccess)
          else:
              virtualmem = self.GetVirtualMemAuto(eAccess,options)
          return gdal_array.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess=gdalconst.GF_Read, xoff=0, yoff=0,
                             xsize=None, ysize=None, tilexsize=256, tileysize=256,
                             datatype=None,
                             cache_size = 10 * 1024 * 1024, options=None):
          """Return a NumPy array for the band, seen as a virtual memory mapping with
             a tile organization.
             An element is accessed with array[tiley][tilex][y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          from osgeo import gdal_array
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,cache_size)
          else:
              virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,cache_size,options)
          return gdal_array.VirtualMemGetArray( virtualmem )

Band_swigregister = _gdal.Band_swigregister
Band_swigregister(Band)

class ColorTable(_object):
    """Proxy of C++ GDALColorTableShadow class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorTable, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColorTable, name)
    __repr__ = _swig_repr

    def __init__(self, *args, **kwargs):
        """__init__(GDALColorTableShadow self, GDALPaletteInterp palette) -> ColorTable"""
        this = _gdal.new_ColorTable(*args, **kwargs)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_ColorTable
    __del__ = lambda self: None

    def Clone(self, *args):
        """Clone(ColorTable self) -> ColorTable"""
        return _gdal.ColorTable_Clone(self, *args)


    def GetPaletteInterpretation(self, *args):
        """GetPaletteInterpretation(ColorTable self) -> GDALPaletteInterp"""
        return _gdal.ColorTable_GetPaletteInterpretation(self, *args)


    def GetCount(self, *args):
        """GetCount(ColorTable self) -> int"""
        return _gdal.ColorTable_GetCount(self, *args)


    def GetColorEntry(self, *args):
        """GetColorEntry(ColorTable self, int entry) -> ColorEntry"""
        return _gdal.ColorTable_GetColorEntry(self, *args)


    def GetColorEntryAsRGB(self, *args):
        """GetColorEntryAsRGB(ColorTable self, int entry, ColorEntry centry) -> int"""
        return _gdal.ColorTable_GetColorEntryAsRGB(self, *args)


    def SetColorEntry(self, *args):
        """SetColorEntry(ColorTable self, int entry, ColorEntry centry)"""
        return _gdal.ColorTable_SetColorEntry(self, *args)


    def CreateColorRamp(self, *args):
        """CreateColorRamp(ColorTable self, int nStartIndex, ColorEntry startcolor, int nEndIndex, ColorEntry endcolor)"""
        return _gdal.ColorTable_CreateColorRamp(self, *args)

ColorTable_swigregister = _gdal.ColorTable_swigregister
ColorTable_swigregister(ColorTable)

class RasterAttributeTable(_object):
    """Proxy of C++ GDALRasterAttributeTableShadow class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RasterAttributeTable, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RasterAttributeTable, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALRasterAttributeTableShadow self) -> RasterAttributeTable"""
        this = _gdal.new_RasterAttributeTable(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_RasterAttributeTable
    __del__ = lambda self: None

    def Clone(self, *args):
        """Clone(RasterAttributeTable self) -> RasterAttributeTable"""
        return _gdal.RasterAttributeTable_Clone(self, *args)


    def GetColumnCount(self, *args):
        """GetColumnCount(RasterAttributeTable self) -> int"""
        return _gdal.RasterAttributeTable_GetColumnCount(self, *args)


    def GetNameOfCol(self, *args):
        """GetNameOfCol(RasterAttributeTable self, int iCol) -> char const *"""
        return _gdal.RasterAttributeTable_GetNameOfCol(self, *args)


    def GetUsageOfCol(self, *args):
        """GetUsageOfCol(RasterAttributeTable self, int iCol) -> GDALRATFieldUsage"""
        return _gdal.RasterAttributeTable_GetUsageOfCol(self, *args)


    def GetTypeOfCol(self, *args):
        """GetTypeOfCol(RasterAttributeTable self, int iCol) -> GDALRATFieldType"""
        return _gdal.RasterAttributeTable_GetTypeOfCol(self, *args)


    def GetColOfUsage(self, *args):
        """GetColOfUsage(RasterAttributeTable self, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_GetColOfUsage(self, *args)


    def GetRowCount(self, *args):
        """GetRowCount(RasterAttributeTable self) -> int"""
        return _gdal.RasterAttributeTable_GetRowCount(self, *args)


    def GetValueAsString(self, *args):
        """GetValueAsString(RasterAttributeTable self, int iRow, int iCol) -> char const *"""
        return _gdal.RasterAttributeTable_GetValueAsString(self, *args)


    def GetValueAsInt(self, *args):
        """GetValueAsInt(RasterAttributeTable self, int iRow, int iCol) -> int"""
        return _gdal.RasterAttributeTable_GetValueAsInt(self, *args)


    def GetValueAsDouble(self, *args):
        """GetValueAsDouble(RasterAttributeTable self, int iRow, int iCol) -> double"""
        return _gdal.RasterAttributeTable_GetValueAsDouble(self, *args)


    def SetValueAsString(self, *args):
        """SetValueAsString(RasterAttributeTable self, int iRow, int iCol, char const * pszValue)"""
        return _gdal.RasterAttributeTable_SetValueAsString(self, *args)


    def SetValueAsInt(self, *args):
        """SetValueAsInt(RasterAttributeTable self, int iRow, int iCol, int nValue)"""
        return _gdal.RasterAttributeTable_SetValueAsInt(self, *args)


    def SetValueAsDouble(self, *args):
        """SetValueAsDouble(RasterAttributeTable self, int iRow, int iCol, double dfValue)"""
        return _gdal.RasterAttributeTable_SetValueAsDouble(self, *args)


    def SetRowCount(self, *args):
        """SetRowCount(RasterAttributeTable self, int nCount)"""
        return _gdal.RasterAttributeTable_SetRowCount(self, *args)


    def CreateColumn(self, *args):
        """CreateColumn(RasterAttributeTable self, char const * pszName, GDALRATFieldType eType, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_CreateColumn(self, *args)


    def GetLinearBinning(self, *args):
        """GetLinearBinning(RasterAttributeTable self) -> bool"""
        return _gdal.RasterAttributeTable_GetLinearBinning(self, *args)


    def SetLinearBinning(self, *args):
        """SetLinearBinning(RasterAttributeTable self, double dfRow0Min, double dfBinSize) -> int"""
        return _gdal.RasterAttributeTable_SetLinearBinning(self, *args)


    def GetRowOfValue(self, *args):
        """GetRowOfValue(RasterAttributeTable self, double dfValue) -> int"""
        return _gdal.RasterAttributeTable_GetRowOfValue(self, *args)


    def ChangesAreWrittenToFile(self, *args):
        """ChangesAreWrittenToFile(RasterAttributeTable self) -> int"""
        return _gdal.RasterAttributeTable_ChangesAreWrittenToFile(self, *args)


    def DumpReadable(self, *args):
        """DumpReadable(RasterAttributeTable self)"""
        return _gdal.RasterAttributeTable_DumpReadable(self, *args)


    def SetTableType(self, *args):
        """SetTableType(RasterAttributeTable self, GDALRATTableType eTableType)"""
        return _gdal.RasterAttributeTable_SetTableType(self, *args)


    def GetTableType(self, *args):
        """GetTableType(RasterAttributeTable self) -> GDALRATTableType"""
        return _gdal.RasterAttributeTable_GetTableType(self, *args)


    def WriteArray(self, array, field, start=0):
        from osgeo import gdal_array

        return gdal_array.RATWriteArray(self, array, field, start)

    def ReadAsArray(self, field, start=0, length=None):
        from osgeo import gdal_array

        return gdal_array.RATReadArray(self, field, start, length)

RasterAttributeTable_swigregister = _gdal.RasterAttributeTable_swigregister
RasterAttributeTable_swigregister(RasterAttributeTable)


def TermProgress_nocb(*args, **kwargs):
    """TermProgress_nocb(double dfProgress, char const * pszMessage=None, void * pData=None) -> int"""
    return _gdal.TermProgress_nocb(*args, **kwargs)
TermProgress = _gdal.TermProgress

def ComputeMedianCutPCT(*args, **kwargs):
    """ComputeMedianCutPCT(Band red, Band green, Band blue, int num_colors, ColorTable colors, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ComputeMedianCutPCT(*args, **kwargs)

def DitherRGB2PCT(*args, **kwargs):
    """DitherRGB2PCT(Band red, Band green, Band blue, Band target, ColorTable colors, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.DitherRGB2PCT(*args, **kwargs)

def ReprojectImage(*args, **kwargs):
    """ReprojectImage(Dataset src_ds, Dataset dst_ds, char const * src_wkt=None, char const * dst_wkt=None, GDALResampleAlg eResampleAlg, double WarpMemoryLimit=0.0, double maxerror=0.0, GDALProgressFunc callback=0, void * callback_data=None, char ** options=None) -> CPLErr"""
    return _gdal.ReprojectImage(*args, **kwargs)

def ComputeProximity(*args, **kwargs):
    """ComputeProximity(Band srcBand, Band proximityBand, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ComputeProximity(*args, **kwargs)

def RasterizeLayer(*args, **kwargs):
    """RasterizeLayer(Dataset dataset, int bands, Layer layer, void * pfnTransformer=None, void * pTransformArg=None, int burn_values=0, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.RasterizeLayer(*args, **kwargs)

def Polygonize(*args, **kwargs):
    """Polygonize(Band srcBand, Band maskBand, Layer outLayer, int iPixValField, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.Polygonize(*args, **kwargs)

def FPolygonize(*args, **kwargs):
    """FPolygonize(Band srcBand, Band maskBand, Layer outLayer, int iPixValField, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.FPolygonize(*args, **kwargs)

def FillNodata(*args, **kwargs):
    """FillNodata(Band targetBand, Band maskBand, double maxSearchDist, int smoothingIterations, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.FillNodata(*args, **kwargs)

def SieveFilter(*args, **kwargs):
    """SieveFilter(Band srcBand, Band maskBand, Band dstBand, int threshold, int connectedness=4, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.SieveFilter(*args, **kwargs)

def RegenerateOverviews(*args, **kwargs):
    """RegenerateOverviews(Band srcBand, int overviewBandCount, char const * resampling, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.RegenerateOverviews(*args, **kwargs)

def RegenerateOverview(*args, **kwargs):
    """RegenerateOverview(Band srcBand, Band overviewBand, char const * resampling, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.RegenerateOverview(*args, **kwargs)

def ContourGenerate(*args, **kwargs):
    """ContourGenerate(Band srcBand, double contourInterval, double contourBase, int fixedLevelCount, int useNoData, double noDataValue, Layer dstLayer, int idField, int elevField, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ContourGenerate(*args, **kwargs)

def ContourGenerateEx(*args, **kwargs):
    """ContourGenerateEx(Band srcBand, Layer dstLayer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.ContourGenerateEx(*args, **kwargs)
GVM_Diagonal = _gdal.GVM_Diagonal
GVM_Edge = _gdal.GVM_Edge
GVM_Max = _gdal.GVM_Max
GVM_Min = _gdal.GVM_Min
GVOT_NORMAL = _gdal.GVOT_NORMAL
GVOT_MIN_TARGET_HEIGHT_FROM_DEM = _gdal.GVOT_MIN_TARGET_HEIGHT_FROM_DEM
GVOT_MIN_TARGET_HEIGHT_FROM_GROUND = _gdal.GVOT_MIN_TARGET_HEIGHT_FROM_GROUND

def ViewshedGenerate(*args, **kwargs):
    """ViewshedGenerate(Band srcBand, char const * driverName, char const * targetRasterName, char ** creationOptions, double observerX, double observerY, double observerHeight, double targetHeight, double visibleVal, double invisibleVal, double outOfRangeVal, double noDataVal, double dfCurvCoeff, GDALViewshedMode mode, double maxDistance, GDALProgressFunc callback=0, void * callback_data=None, GDALViewshedOutputType heightMode=GVOT_NORMAL, char ** papszOptions=None) -> Dataset"""
    return _gdal.ViewshedGenerate(*args, **kwargs)

def AutoCreateWarpedVRT(*args):
    """AutoCreateWarpedVRT(Dataset src_ds, char const * src_wkt=None, char const * dst_wkt=None, GDALResampleAlg eResampleAlg, double maxerror=0.0) -> Dataset"""
    return _gdal.AutoCreateWarpedVRT(*args)

def CreatePansharpenedVRT(*args):
    """CreatePansharpenedVRT(char const * pszXML, Band panchroBand, int nInputSpectralBands) -> Dataset"""
    return _gdal.CreatePansharpenedVRT(*args)
class GDALTransformerInfoShadow(_object):
    """Proxy of C++ GDALTransformerInfoShadow class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALTransformerInfoShadow, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALTransformerInfoShadow, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_GDALTransformerInfoShadow
    __del__ = lambda self: None

    def TransformPoint(self, *args):
        """
        TransformPoint(GDALTransformerInfoShadow self, int bDstToSrc, double [3] inout) -> int
        TransformPoint(GDALTransformerInfoShadow self, int bDstToSrc, double x, double y, double z=0.0) -> int
        """
        return _gdal.GDALTransformerInfoShadow_TransformPoint(self, *args)


    def TransformPoints(self, *args):
        """TransformPoints(GDALTransformerInfoShadow self, int bDstToSrc, int nCount) -> int"""
        return _gdal.GDALTransformerInfoShadow_TransformPoints(self, *args)


    def TransformGeolocations(self, *args, **kwargs):
        """TransformGeolocations(GDALTransformerInfoShadow self, Band xBand, Band yBand, Band zBand, GDALProgressFunc callback=0, void * callback_data=None, char ** options=None) -> int"""
        return _gdal.GDALTransformerInfoShadow_TransformGeolocations(self, *args, **kwargs)

GDALTransformerInfoShadow_swigregister = _gdal.GDALTransformerInfoShadow_swigregister
GDALTransformerInfoShadow_swigregister(GDALTransformerInfoShadow)


def Transformer(*args):
    """Transformer(Dataset src, Dataset dst, char ** options) -> GDALTransformerInfoShadow"""
    return _gdal.Transformer(*args)

def ApplyVerticalShiftGrid(*args, **kwargs):
    """ApplyVerticalShiftGrid(Dataset src_ds, Dataset grid_ds, bool inverse=False, double srcUnitToMeter=1.0, double dstUnitToMeter=1.0, char ** options=None) -> Dataset"""
    return _gdal.ApplyVerticalShiftGrid(*args, **kwargs)

def ApplyGeoTransform(*args):
    """ApplyGeoTransform(double [6] padfGeoTransform, double dfPixel, double dfLine)"""
    return _gdal.ApplyGeoTransform(*args)

def InvGeoTransform(*args):
    """InvGeoTransform(double [6] gt_in) -> RETURN_NONE"""
    return _gdal.InvGeoTransform(*args)

def VersionInfo(*args):
    """VersionInfo(char const * request) -> char const *"""
    return _gdal.VersionInfo(*args)

def AllRegister(*args):
    """AllRegister()"""
    return _gdal.AllRegister(*args)

def GDALDestroyDriverManager(*args):
    """GDALDestroyDriverManager()"""
    return _gdal.GDALDestroyDriverManager(*args)

def GetCacheMax(*args):
    """GetCacheMax() -> GIntBig"""
    return _gdal.GetCacheMax(*args)

def GetCacheUsed(*args):
    """GetCacheUsed() -> GIntBig"""
    return _gdal.GetCacheUsed(*args)

def SetCacheMax(*args):
    """SetCacheMax(GIntBig nBytes)"""
    return _gdal.SetCacheMax(*args)

def GetDataTypeSize(*args):
    """GetDataTypeSize(GDALDataType eDataType) -> int"""
    return _gdal.GetDataTypeSize(*args)

def DataTypeIsComplex(*args):
    """DataTypeIsComplex(GDALDataType eDataType) -> int"""
    return _gdal.DataTypeIsComplex(*args)

def GetDataTypeName(*args):
    """GetDataTypeName(GDALDataType eDataType) -> char const *"""
    return _gdal.GetDataTypeName(*args)

def GetDataTypeByName(*args):
    """GetDataTypeByName(char const * pszDataTypeName) -> GDALDataType"""
    return _gdal.GetDataTypeByName(*args)

def GetColorInterpretationName(*args):
    """GetColorInterpretationName(GDALColorInterp eColorInterp) -> char const *"""
    return _gdal.GetColorInterpretationName(*args)

def GetPaletteInterpretationName(*args):
    """GetPaletteInterpretationName(GDALPaletteInterp ePaletteInterp) -> char const *"""
    return _gdal.GetPaletteInterpretationName(*args)

def DecToDMS(*args):
    """DecToDMS(double arg1, char const * arg2, int arg3=2) -> char const *"""
    return _gdal.DecToDMS(*args)

def PackedDMSToDec(*args):
    """PackedDMSToDec(double dfPacked) -> double"""
    return _gdal.PackedDMSToDec(*args)

def DecToPackedDMS(*args):
    """DecToPackedDMS(double dfDec) -> double"""
    return _gdal.DecToPackedDMS(*args)

def ParseXMLString(*args):
    """ParseXMLString(char * pszXMLString) -> CPLXMLNode *"""
    return _gdal.ParseXMLString(*args)

def SerializeXMLTree(*args):
    """SerializeXMLTree(CPLXMLNode * xmlnode) -> retStringAndCPLFree *"""
    return _gdal.SerializeXMLTree(*args)

def GetJPEG2000Structure(*args):
    """GetJPEG2000Structure(char const * pszFilename, char ** options=None) -> CPLXMLNode *"""
    return _gdal.GetJPEG2000Structure(*args)

def GetJPEG2000StructureAsString(*args):
    """GetJPEG2000StructureAsString(char const * pszFilename, char ** options=None) -> retStringAndCPLFree *"""
    return _gdal.GetJPEG2000StructureAsString(*args)

def GetDriverCount(*args):
    """GetDriverCount() -> int"""
    return _gdal.GetDriverCount(*args)

def GetDriverByName(*args):
    """GetDriverByName(char const * name) -> Driver"""
    return _gdal.GetDriverByName(*args)

def GetDriver(*args):
    """GetDriver(int i) -> Driver"""
    return _gdal.GetDriver(*args)

def Open(*args):
    """Open(char const * utf8_path, GDALAccess eAccess) -> Dataset"""
    return _gdal.Open(*args)

def OpenEx(*args, **kwargs):
    """OpenEx(char const * utf8_path, unsigned int nOpenFlags=0, char ** allowed_drivers=None, char ** open_options=None, char ** sibling_files=None) -> Dataset"""
    return _gdal.OpenEx(*args, **kwargs)

def OpenShared(*args):
    """OpenShared(char const * utf8_path, GDALAccess eAccess) -> Dataset"""
    return _gdal.OpenShared(*args)

def IdentifyDriver(*args):
    """IdentifyDriver(char const * utf8_path, char ** papszSiblings=None) -> Driver"""
    return _gdal.IdentifyDriver(*args)

def IdentifyDriverEx(*args, **kwargs):
    """IdentifyDriverEx(char const * utf8_path, unsigned int nIdentifyFlags=0, char ** allowed_drivers=None, char ** sibling_files=None) -> Driver"""
    return _gdal.IdentifyDriverEx(*args, **kwargs)

def GeneralCmdLineProcessor(*args):
    """GeneralCmdLineProcessor(char ** papszArgv, int nOptions=0) -> char **"""
    return _gdal.GeneralCmdLineProcessor(*args)

__version__ = _gdal.VersionInfo("RELEASE_NAME")

class GDALInfoOptions(_object):
    """Proxy of C++ GDALInfoOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALInfoOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALInfoOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALInfoOptions self, char ** options) -> GDALInfoOptions"""
        this = _gdal.new_GDALInfoOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALInfoOptions
    __del__ = lambda self: None
GDALInfoOptions_swigregister = _gdal.GDALInfoOptions_swigregister
GDALInfoOptions_swigregister(GDALInfoOptions)


def InfoInternal(*args):
    """InfoInternal(Dataset hDataset, GDALInfoOptions infoOptions) -> retStringAndCPLFree *"""
    return _gdal.InfoInternal(*args)
class GDALMultiDimInfoOptions(_object):
    """Proxy of C++ GDALMultiDimInfoOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALMultiDimInfoOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALMultiDimInfoOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALMultiDimInfoOptions self, char ** options) -> GDALMultiDimInfoOptions"""
        this = _gdal.new_GDALMultiDimInfoOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALMultiDimInfoOptions
    __del__ = lambda self: None
GDALMultiDimInfoOptions_swigregister = _gdal.GDALMultiDimInfoOptions_swigregister
GDALMultiDimInfoOptions_swigregister(GDALMultiDimInfoOptions)


def MultiDimInfoInternal(*args):
    """MultiDimInfoInternal(Dataset hDataset, GDALMultiDimInfoOptions infoOptions) -> retStringAndCPLFree *"""
    return _gdal.MultiDimInfoInternal(*args)
class GDALTranslateOptions(_object):
    """Proxy of C++ GDALTranslateOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALTranslateOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALTranslateOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALTranslateOptions self, char ** options) -> GDALTranslateOptions"""
        this = _gdal.new_GDALTranslateOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALTranslateOptions
    __del__ = lambda self: None
GDALTranslateOptions_swigregister = _gdal.GDALTranslateOptions_swigregister
GDALTranslateOptions_swigregister(GDALTranslateOptions)


def TranslateInternal(*args):
    """TranslateInternal(char const * dest, Dataset dataset, GDALTranslateOptions translateOptions, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.TranslateInternal(*args)
class GDALWarpAppOptions(_object):
    """Proxy of C++ GDALWarpAppOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALWarpAppOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALWarpAppOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALWarpAppOptions self, char ** options) -> GDALWarpAppOptions"""
        this = _gdal.new_GDALWarpAppOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALWarpAppOptions
    __del__ = lambda self: None
GDALWarpAppOptions_swigregister = _gdal.GDALWarpAppOptions_swigregister
GDALWarpAppOptions_swigregister(GDALWarpAppOptions)


def wrapper_GDALWarpDestDS(*args):
    """wrapper_GDALWarpDestDS(Dataset dstDS, int object_list_count, GDALWarpAppOptions warpAppOptions, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALWarpDestDS(*args)

def wrapper_GDALWarpDestName(*args):
    """wrapper_GDALWarpDestName(char const * dest, int object_list_count, GDALWarpAppOptions warpAppOptions, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALWarpDestName(*args)
class GDALVectorTranslateOptions(_object):
    """Proxy of C++ GDALVectorTranslateOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALVectorTranslateOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALVectorTranslateOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALVectorTranslateOptions self, char ** options) -> GDALVectorTranslateOptions"""
        this = _gdal.new_GDALVectorTranslateOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALVectorTranslateOptions
    __del__ = lambda self: None
GDALVectorTranslateOptions_swigregister = _gdal.GDALVectorTranslateOptions_swigregister
GDALVectorTranslateOptions_swigregister(GDALVectorTranslateOptions)


def wrapper_GDALVectorTranslateDestDS(*args):
    """wrapper_GDALVectorTranslateDestDS(Dataset dstDS, Dataset srcDS, GDALVectorTranslateOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALVectorTranslateDestDS(*args)

def wrapper_GDALVectorTranslateDestName(*args):
    """wrapper_GDALVectorTranslateDestName(char const * dest, Dataset srcDS, GDALVectorTranslateOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALVectorTranslateDestName(*args)
class GDALDEMProcessingOptions(_object):
    """Proxy of C++ GDALDEMProcessingOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALDEMProcessingOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALDEMProcessingOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALDEMProcessingOptions self, char ** options) -> GDALDEMProcessingOptions"""
        this = _gdal.new_GDALDEMProcessingOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALDEMProcessingOptions
    __del__ = lambda self: None
GDALDEMProcessingOptions_swigregister = _gdal.GDALDEMProcessingOptions_swigregister
GDALDEMProcessingOptions_swigregister(GDALDEMProcessingOptions)


def DEMProcessingInternal(*args):
    """DEMProcessingInternal(char const * dest, Dataset dataset, char const * pszProcessing, char const * pszColorFilename, GDALDEMProcessingOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.DEMProcessingInternal(*args)
class GDALNearblackOptions(_object):
    """Proxy of C++ GDALNearblackOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALNearblackOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALNearblackOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALNearblackOptions self, char ** options) -> GDALNearblackOptions"""
        this = _gdal.new_GDALNearblackOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALNearblackOptions
    __del__ = lambda self: None
GDALNearblackOptions_swigregister = _gdal.GDALNearblackOptions_swigregister
GDALNearblackOptions_swigregister(GDALNearblackOptions)


def wrapper_GDALNearblackDestDS(*args):
    """wrapper_GDALNearblackDestDS(Dataset dstDS, Dataset srcDS, GDALNearblackOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALNearblackDestDS(*args)

def wrapper_GDALNearblackDestName(*args):
    """wrapper_GDALNearblackDestName(char const * dest, Dataset srcDS, GDALNearblackOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALNearblackDestName(*args)
class GDALGridOptions(_object):
    """Proxy of C++ GDALGridOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALGridOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALGridOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALGridOptions self, char ** options) -> GDALGridOptions"""
        this = _gdal.new_GDALGridOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALGridOptions
    __del__ = lambda self: None
GDALGridOptions_swigregister = _gdal.GDALGridOptions_swigregister
GDALGridOptions_swigregister(GDALGridOptions)


def GridInternal(*args):
    """GridInternal(char const * dest, Dataset dataset, GDALGridOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.GridInternal(*args)
class GDALRasterizeOptions(_object):
    """Proxy of C++ GDALRasterizeOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALRasterizeOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALRasterizeOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALRasterizeOptions self, char ** options) -> GDALRasterizeOptions"""
        this = _gdal.new_GDALRasterizeOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALRasterizeOptions
    __del__ = lambda self: None
GDALRasterizeOptions_swigregister = _gdal.GDALRasterizeOptions_swigregister
GDALRasterizeOptions_swigregister(GDALRasterizeOptions)


def wrapper_GDALRasterizeDestDS(*args):
    """wrapper_GDALRasterizeDestDS(Dataset dstDS, Dataset srcDS, GDALRasterizeOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> int"""
    return _gdal.wrapper_GDALRasterizeDestDS(*args)

def wrapper_GDALRasterizeDestName(*args):
    """wrapper_GDALRasterizeDestName(char const * dest, Dataset srcDS, GDALRasterizeOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALRasterizeDestName(*args)
class GDALBuildVRTOptions(_object):
    """Proxy of C++ GDALBuildVRTOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALBuildVRTOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALBuildVRTOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALBuildVRTOptions self, char ** options) -> GDALBuildVRTOptions"""
        this = _gdal.new_GDALBuildVRTOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALBuildVRTOptions
    __del__ = lambda self: None
GDALBuildVRTOptions_swigregister = _gdal.GDALBuildVRTOptions_swigregister
GDALBuildVRTOptions_swigregister(GDALBuildVRTOptions)


def BuildVRTInternalObjects(*args):
    """BuildVRTInternalObjects(char const * dest, int object_list_count, GDALBuildVRTOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.BuildVRTInternalObjects(*args)

def BuildVRTInternalNames(*args):
    """BuildVRTInternalNames(char const * dest, char ** source_filenames, GDALBuildVRTOptions options, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.BuildVRTInternalNames(*args)
class GDALMultiDimTranslateOptions(_object):
    """Proxy of C++ GDALMultiDimTranslateOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GDALMultiDimTranslateOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GDALMultiDimTranslateOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(GDALMultiDimTranslateOptions self, char ** options) -> GDALMultiDimTranslateOptions"""
        this = _gdal.new_GDALMultiDimTranslateOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gdal.delete_GDALMultiDimTranslateOptions
    __del__ = lambda self: None
GDALMultiDimTranslateOptions_swigregister = _gdal.GDALMultiDimTranslateOptions_swigregister
GDALMultiDimTranslateOptions_swigregister(GDALMultiDimTranslateOptions)


def wrapper_GDALMultiDimTranslateDestName(*args):
    """wrapper_GDALMultiDimTranslateDestName(char const * dest, int object_list_count, GDALMultiDimTranslateOptions multiDimTranslateOptions, GDALProgressFunc callback=0, void * callback_data=None) -> Dataset"""
    return _gdal.wrapper_GDALMultiDimTranslateDestName(*args)
# This file is compatible with both classic and new-style classes.


