// This file was autogenerated using foonathan/compatibility.
// See https://github.com/foonathan/compatibility for further information.
// Do not edit manually!

#ifndef COMP_FOONATHAN_CLZ_HPP_INCLUDED
#define COMP_FOONATHAN_CLZ_HPP_INCLUDED

#include <cstddef>

#define FOONATHAN_HAS_CLZ 0


#include "constexpr.hpp"


#include <climits>
#include <cstdint>
#include <type_traits>

// a function clz() that returns the number of leading zeros in an integer
// overloaded for each of the fixed-sized integers, undefined for input value 0!
// * if builtin available: uses the smallest integer version that is fitting
// * otherwise: binary search implementation w/ lookup table for last 4 bits
namespace foonathan_comp
{
#if FOONATHAN_HAS_CLZ
    namespace detail
    {
        // prioritized tag dispatching to choose smallest integer that fits
        struct clzll_tag {};
        struct clzl_tag : clzll_tag {};
        struct clz_tag : clzl_tag {};

        // also subtracts the number of addtional 0s that occur because the target type is smaller
        template <typename T,
                  typename = typename std::enable_if<sizeof(T) <= sizeof(unsigned int)>::type>
        FOONATHAN_CONSTEXPR_FNC unsigned clz(clz_tag, T x)
        {
            return __builtin_clz(x) - (sizeof(unsigned int) * CHAR_BIT - sizeof(T) * CHAR_BIT);
        }

        template <typename T,
                  typename = typename std::enable_if<sizeof(T) <= sizeof(unsigned long)>::type>
        FOONATHAN_CONSTEXPR_FNC unsigned clz(clzl_tag, T x)
        {
            return __builtin_clzl(x) - (sizeof(unsigned long) * CHAR_BIT - sizeof(T) * CHAR_BIT);
        }

        template <typename T,
                  typename = typename std::enable_if<sizeof(T) <= sizeof(unsigned long long)>::type>
        FOONATHAN_CONSTEXPR_FNC unsigned clz(clzll_tag, T x)
        {
            return __builtin_clzll(x) - (sizeof(unsigned long long) * CHAR_BIT - sizeof(T) * CHAR_BIT);
        }
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint8_t x)
    {
        return detail::clz(detail::clz_tag{}, x);
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint16_t x)
    {
        return detail::clz(detail::clz_tag{}, x);;
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint32_t x)
    {
        return detail::clz(detail::clz_tag{}, x);
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint64_t x)
    {
        return detail::clz(detail::clz_tag{}, x);
    }
#else
    namespace detail
    {
        FOONATHAN_CONSTEXPR std::uint8_t clz_lookup[16] = { 4, 3, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };

        FOONATHAN_CONSTEXPR_FNC unsigned clz_base(std::uint8_t higher, std::uint8_t lower)
        {
            return higher ? clz_lookup[higher] : 4 + clz_lookup[lower];
        }
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint8_t x)
    {
        return detail::clz_base(x >> 4, x & 0x0Fu);
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint16_t x)
    {
        return x >> 8 ? clz(std::uint8_t(x >> 8)) : 8 + clz(std::uint8_t(x & 0xFFu));
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint32_t x)
    {
        return x >> 16 ? clz(std::uint16_t(x >> 16)) : 16 + clz(std::uint16_t(x & 0xFFFFu));
    }

    FOONATHAN_CONSTEXPR_FNC unsigned clz(std::uint64_t x)
    {
        return x >> 32 ? clz(std::uint32_t(x >> 32)) : 32 + clz(std::uint32_t(x & 0xFFFFFFFFul));
    }
#endif
}

#endif
