import copy

__all__ = ["AggregationAMGPreconditioner",
           "ClassicalAMGPreconditioner",
           "CGPreconditioner",
           "BiCGStabPreconditioner",
           "FGMRESPreconditioner",
           "BlockJacobiPreconditioner",
           "MultiColorDILUPreconditioner",
           "PolynomialPreconditioner",
           "MultiColorGSPreconditioner"]

class Preconditioner:
    def __init__(self, preconditioner_type, **kwargs):
        self.config_dict = {
            "solver": preconditioner_type,
            "max_iters": 1
        }
        self.config_dict.update(kwargs)
    def __call__(self, **kwargs):
        """
        :Parameters:
            - kwargs: Keyword arguments specifying AMGX solver options.
        """
        self.config_dict.update(kwargs)
        return copy.copy(self.config_dict)

AggregationAMGPreconditioner = Preconditioner("AMG", algorithm="AGGREGATION", selector="SIZE_2")
ClassicalAMGPreconditioner = Preconditioner("AMG")
CGPreconditioner = Preconditioner("PCG")
BiCGStabPreconditioner = Preconditioner("PCIBCGSTAB")
FGMRESPreconditioner = Preconditioner("FGMRES")
BlockJacobiPreconditioner = Preconditioner("BLOCK_JACOBI")
MultiColorDILUPreconditioner = Preconditioner("MULTICOLOR_DILU")
PolynomialPreconditioner = Preconditioner("POLYNOMIAL")
MultiColorGSPreconditioner = Preconditioner("MULTICOLOR_GS")
