__docformat__ = 'restructuredtext'

from PyTrilinos import AztecOO

from fipy.solvers.trilinos.trilinosAztecOOSolver import TrilinosAztecOOSolver
from fipy.solvers.trilinos.preconditioners.multilevelDDPreconditioner import MultilevelDDPreconditioner

__all__ = ["LinearPCGSolver"]

class LinearPCGSolver(TrilinosAztecOOSolver):

    """
    The `LinearPCGSolver` is an interface to the cg solver in Trilinos, using
    the `MultilevelSGSPreconditioner` by default.

    """

    def __init__(self, tolerance=1e-10, iterations=1000, precon=MultilevelDDPreconditioner()):
        """
        :Parameters:
          - `tolerance`: The required error tolerance.
          - `iterations`: The maximum number of iterative steps to perform.
          - `precon`: Preconditioner to use.

        """
        TrilinosAztecOOSolver.__init__(self, tolerance=tolerance,
                                       iterations=iterations, precon=precon)
        self.solver = AztecOO.AZ_cg

    def _canSolveAsymmetric(self):
        return False
