"""
Simple detuned cavity testing end mirror shaking
"""

import pytest
from finesse import Model
import numpy as np
from finesse.analysis.actions import X2axis


@pytest.fixture(scope="module")
def detuned_model_out():
    kat = Model()
    kat.parse(
        """
        l L0 P=1

        s s0 L0.p1 EOM1.p1
        mod EOM1 f=100M midx=0.1 order=1 mod_type=pm

        s s1 EOM1.p2 ITM.p1 L=1

        m ITM R=0.99 T=0.01
        s sCAV ITM.p2 ETM.p1 L=1
        m ETM R=0.99 T=0.01 phi=123

        pd1 REFL_I ITM.p1.o 100M 0
        """
    )

    return kat.run(X2axis("REFL_I.phase", "lin", -180, 180, 5, kat.ETM.phi, "lin", -10, 10, 5))


def test_output(detuned_model_out):
    ref = np.array(
        [
            [
                (1.489704869548768e-03,),
                (2.429824531005459e-03,),
                (7.087084712767861e-03,),
                (-7.087084710409157e-03,),
                (-2.429824525739567e-03,),
                (-1.489704858187217e-03,),
            ],
            [
                (2.888410448350853e-03,),
                (4.712660751100861e-03,),
                (1.374748512022170e-02,),
                (-1.374748512008426e-02,),
                (-4.712660745631939e-03,),
                (-2.888410431552590e-03,),
            ],
            [
                (2.954309609923820e-04,),
                (4.827599906224818e-04,),
                (1.409328351362588e-03,),
                (-1.409328353636344e-03,),
                (-4.827599925083938e-04,),
                (-2.954309619720354e-04,),
            ],
            [
                (-2.705824073128516e-03,),
                (-4.414298668487587e-03,),
                (-1.287647229777077e-02,),
                (1.287647229622806e-02,),
                (4.414298661853108e-03,),
                (2.705824055724794e-03,),
            ],
            [
                (-1.967722205763486e-03,),
                (-3.210946604241215e-03,),
                (-9.367425886581382e-03,),
                (9.367425887901692e-03,),
                (3.210946602026794e-03,),
                (1.967722195987048e-03,),
            ],
            [
                (1.489704869548768e-03,),
                (2.429824531005458e-03,),
                (7.087084712767857e-03,),
                (-7.087084710409154e-03,),
                (-2.429824525739567e-03,),
                (-1.489704858187217e-03,),
            ],
        ],
        dtype=[("REFL_I", "<f8")],
    )

    assert np.allclose(detuned_model_out["REFL_I"], ref["REFL_I"], rtol=1e-10)
