\      pystan.model	StanModel)}(
model_cppname+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2
model_name+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2
model_codeXy  functions {
  real[ , ] get_changepoint_matrix(real[] t, real[] t_change, int T, int S) {
    // Assumes t and t_change are sorted.
    real A[T, S];
    real a_row[S];
    int cp_idx;

    // Start with an empty matrix.
    A = rep_array(0, T, S);
    a_row = rep_array(0, S);
    cp_idx = 1;

    // Fill in each row of A.
    for (i in 1:T) {
      while ((cp_idx <= S) && (t[i] >= t_change[cp_idx])) {
        a_row[cp_idx] = 1;
        cp_idx = cp_idx + 1;
      }
      A[i] = a_row;
    }
    return A;
  }

  // Logistic trend functions

  real[] logistic_gamma(real k, real m, real[] delta, real[] t_change, int S) {
    real gamma[S];  // adjusted offsets, for piecewise continuity
    real k_s[S + 1];  // actual rate in each segment
    real m_pr;

    // Compute the rate in each segment
    k_s[1] = k;
    for (i in 1:S) {
      k_s[i + 1] = k_s[i] + delta[i];
    }

    // Piecewise offsets
    m_pr = m; // The offset in the previous segment
    for (i in 1:S) {
      gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
      m_pr = m_pr + gamma[i];  // update for the next segment
    }
    return gamma;
  }
  
  real[] logistic_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[] cap,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    gamma = logistic_gamma(k, m, delta, t_change, S);
    for (i in 1:T) {
      Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta))
        * (t[i] - (m + dot_product(A[i], gamma)))));
    }
    return Y;
  }

  // Linear trend function

  real[] linear_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    for (i in 1:S) {
      gamma[i] = -t_change[i] * delta[i];
    }
    for (i in 1:T) {
      Y[i] = (k + dot_product(A[i], delta)) * t[i] + (
        m + dot_product(A[i], gamma));
    }
    return Y;
  }
}

data {
  int T;                // Number of time periods
  int<lower=1> K;       // Number of regressors
  real t[T];            // Time
  real cap[T];          // Capacities for logistic trend
  real y[T];            // Time series
  int S;                // Number of changepoints
  real t_change[S];     // Times of trend changepoints
  real X[T,K];         // Regressors
  vector[K] sigmas;     // Scale on seasonality prior
  real<lower=0> tau;    // Scale on changepoints prior
  int trend_indicator;  // 0 for linear, 1 for logistic
  real s_a[K];          // Indicator of additive features
  real s_m[K];          // Indicator of multiplicative features
}

transformed data {
  real A[T, S];
  A = get_changepoint_matrix(t, t_change, T, S);
}

parameters {
  real k;                   // Base trend growth rate
  real m;                   // Trend offset
  real delta[S];            // Trend rate adjustments
  real<lower=0> sigma_obs;  // Observation noise
  real beta[K];             // Regressor coefficients
}

transformed parameters {
  real trend[T];
  real Y[T];
  real beta_m[K];
  real beta_a[K];

  if (trend_indicator == 0) {
    trend = linear_trend(k, m, delta, t, A, t_change, S, T);
  } else if (trend_indicator == 1) {
    trend = logistic_trend(k, m, delta, t, cap, A, t_change, S, T);
  }

  for (i in 1:K) {
    beta_m[i] = beta[i] * s_m[i];
    beta_a[i] = beta[i] * s_a[i];
  }

  for (i in 1:T) {
    Y[i] = (
      trend[i] * (1 + dot_product(X[i], beta_m)) + dot_product(X[i], beta_a)
    );
  }
}

model {
  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  y ~ normal(Y, sigma_obs);
}

model_cppcodeXH  // Code generated by Stan version 2.17.1

#include <stan/model/model_header.hpp>

namespace anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unknown file name");
    reader.add_event(157, 157, "end", "unknown file name");
    return reader;
}

template <typename T0__, typename T1__>
std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
get_changepoint_matrix(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        vector<vector<local_scalar_t__> > A(T, (vector<local_scalar_t__>(S)));
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        current_statement_begin__ = 5;
        validate_non_negative_index("a_row", "S", S);
        vector<local_scalar_t__> a_row(S);
        stan::math::initialize(a_row, DUMMY_VAR__);
        stan::math::fill(a_row,DUMMY_VAR__);
        current_statement_begin__ = 6;
        int cp_idx(0);
        (void) cp_idx;  // dummy to suppress unused var warning

        stan::math::fill(cp_idx, std::numeric_limits<int>::min());


        current_statement_begin__ = 9;
        stan::math::assign(A, rep_array(0,T,S));
        current_statement_begin__ = 10;
        stan::math::assign(a_row, rep_array(0,S));
        current_statement_begin__ = 11;
        stan::math::assign(cp_idx, 1);
        current_statement_begin__ = 14;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 15;
            while (as_bool((primitive_value(logical_lte(cp_idx,S)) && primitive_value(logical_gte(get_base1(t,i,"t",1),get_base1(t_change,cp_idx,"t_change",1)))))) {

                current_statement_begin__ = 16;
                stan::math::assign(get_base1_lhs(a_row,cp_idx,"a_row",1), 1);
                current_statement_begin__ = 17;
                stan::math::assign(cp_idx, (cp_idx + 1));
            }
            current_statement_begin__ = 19;
            stan::math::assign(get_base1_lhs(A,i,"A",1), a_row);
        }
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(A);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct get_changepoint_matrix_functor__ {
    template <typename T0__, typename T1__>
        std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
    operator()(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) const {
        return get_changepoint_matrix(t, t_change, T, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
logistic_gamma(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 28;
        validate_non_negative_index("k_s", "(S + 1)", (S + 1));
        vector<local_scalar_t__> k_s((S + 1));
        stan::math::initialize(k_s, DUMMY_VAR__);
        stan::math::fill(k_s,DUMMY_VAR__);
        current_statement_begin__ = 29;
        local_scalar_t__ m_pr;
        (void) m_pr;  // dummy to suppress unused var warning

        stan::math::initialize(m_pr, DUMMY_VAR__);
        stan::math::fill(m_pr,DUMMY_VAR__);


        current_statement_begin__ = 32;
        stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
        current_statement_begin__ = 33;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 34;
            stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 38;
        stan::math::assign(m_pr, m);
        current_statement_begin__ = 39;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 40;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
            current_statement_begin__ = 41;
            stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
        }
        current_statement_begin__ = 43;
        return stan::math::promote_scalar<fun_return_scalar_t__>(gamma);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_gamma_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) const {
        return logistic_gamma(k, m, delta, t_change, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
logistic_trend(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 57;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 58;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 60;
        stan::math::assign(gamma, logistic_gamma(k,m,delta,t_change,S, pstream__));
        current_statement_begin__ = 61;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 62;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (get_base1(cap,i,"cap",1) / (1 + stan::math::exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))));
        }
        current_statement_begin__ = 65;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) const {
        return logistic_trend(k, m, delta, t, cap, A, t_change, S, T, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
linear_trend(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 80;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 81;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 83;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 84;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 86;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 87;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (((k + dot_product(get_base1(A,i,"A",1),delta)) * get_base1(t,i,"t",1)) + (m + dot_product(get_base1(A,i,"A",1),gamma))));
        }
        current_statement_begin__ = 90;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linear_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
    operator()(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) const {
        return linear_trend(k, m, delta, t, A, t_change, S, T, pstream__);
    }
};

class anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
    int trend_indicator;
    vector<double> s_a;
    vector<double> s_m;
    vector<vector<double> > A;
public:
    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 96;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 97;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 98;
            validate_non_negative_index("cap", "T", T);
            context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
            validate_non_negative_index("cap", "T", T);
            cap = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("cap");
            pos__ = 0;
            size_t cap_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
                cap[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 99;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 101;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 102;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 103;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "trend_indicator", "int", context__.to_vec());
            trend_indicator = int(0);
            vals_i__ = context__.vals_i("trend_indicator");
            pos__ = 0;
            trend_indicator = vals_i__[pos__++];
            current_statement_begin__ = 106;
            validate_non_negative_index("s_a", "K", K);
            context__.validate_dims("data initialization", "s_a", "double", context__.to_vec(K));
            validate_non_negative_index("s_a", "K", K);
            s_a = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_a");
            pos__ = 0;
            size_t s_a_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_a_limit_0__; ++i_0__) {
                s_a[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 107;
            validate_non_negative_index("s_m", "K", K);
            context__.validate_dims("data initialization", "s_m", "double", context__.to_vec(K));
            validate_non_negative_index("s_m", "K", K);
            s_m = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_m");
            pos__ = 0;
            size_t s_m_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_m_limit_0__; ++i_0__) {
                s_m[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 95;
            current_statement_begin__ = 96;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 97;
            current_statement_begin__ = 98;
            current_statement_begin__ = 99;
            current_statement_begin__ = 100;
            current_statement_begin__ = 101;
            current_statement_begin__ = 102;
            current_statement_begin__ = 103;
            current_statement_begin__ = 104;
            check_greater_or_equal(function__,"tau",tau,0);
            current_statement_begin__ = 105;
            current_statement_begin__ = 106;
            current_statement_begin__ = 107;
            // initialize data variables
            current_statement_begin__ = 111;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            stan::math::fill(A,DUMMY_VAR__);

            current_statement_begin__ = 112;
            stan::math::assign(A, get_changepoint_matrix(t,t_change,T,S, pstream__));

            // validate transformed data
            current_statement_begin__ = 111;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 116;
            ++num_params_r__;
            current_statement_begin__ = 117;
            ++num_params_r__;
            current_statement_begin__ = 118;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 119;
            ++num_params_r__;
            current_statement_begin__ = 120;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_db8febf10f23d7fa27a62fbcfd7f17b2() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            local_scalar_t__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<local_scalar_t__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            local_scalar_t__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<local_scalar_t__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(trend[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: trend" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(Y[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Y" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_m[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_m" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_a[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_a" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // model body

            current_statement_begin__ = 149;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 150;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 151;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 152;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
            current_statement_begin__ = 153;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 156;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("trend");
        names__.push_back("Y");
        names__.push_back("beta_m");
        names__.push_back("beta_a");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(trend[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(Y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_m[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_a[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 stan_model;

module_nameGstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087module_filenameZstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.cp37-win_amd64.pydmodule_bytesB  MZ                @                                       	!L!This program cannot be run in DOS mode.

$       ^0࣢0࣢0ڣୢ01ᡢ03ᥢ04ᨢ01᧢05ᰢ091ᠢ0࣢1У0	9ᢢ0	0ᢢ0	ࢢ0	2ᢢ0Rich0        PE  d	 0^         "     "                                    @         `                                    l    l            $o           0 h  Ж
                    
 (   
              
                          .text   W                        `.rdata                     @  @.data   0                     @  .pdata  $o     p   @             @  @.gfids  <                      @  @.tls    	                       @  _RDATA                        @  @.rsrc                          @  @.reloc  h   0                  @  B                                                                                                                                                H(H
EC  A   HGC    H| H-C     H
C C   H
 H( H(H
B 耾 A   HB    H< HmB     H
VB OB  z H
3 H(R H(H
A   A   HA    H HA     H
A A   H
s H( H(|x
 8 A H(H(x
 8 @ H(@x
 ^@ @ H(Lx
 U8 @ H(H(w
 58 g@ H(X@ Wa
 iA H(tx
 
8 7 W3
 A H(`@ X @ @ H(H
5A 谼 A   H7A    HT HA     H
A @   H
 H( H(H
u@ P A   Hw@    H H]@     H
F@ ?@  J H
 H(" H(H
E?  A   HG?    H H-?     H
? ?   H
# H( H(H
=] 萻 WH:]     H
K ] H( H(H
5_ P WH2_     H
 _ H(B H( WH)_     H
2 
_ H(	 H(G2  H
  H( H(H
\  WH\     H
{ k\ H( H(H
}\ 耺 WHz\     H
 [\ H(r H(H
] @ WH]     H
[ ] H(2 H( H
  H( H( H
 H( H('  _t
  T~
 f/v
 v  "     pu
  T~
 f/u
 v  "   H(H(Y H(H(W H(體  鋓 H(X H(`s
 s Ps
 3 H(<s
  H(H(s
 O H(H
  @SH HHHSH
 H3H
HJHH HH [HQ HHH%+ HQH HHEH\$WH H HHH t
   H HH\$0H _3HAH HAH HH  H(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH(R @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ H HHH0[@SH HHHSH
 H3H
HJHH H HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0 HT$0   HC   HsH{rHH  Hy @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" HA HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HHL$pH3L L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtH H. uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIH:. uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H- HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v H7 @H$   H3 L$   I[0Ik8IA^_^́aHI    H! H@USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtHU +   H~  HIHP   Hp  i HIHPH
M Hn HEH  + HH }+ HI/ HH c+ HI/ HH I+ HHn/ Hp  Hp  K HHxrHH_ HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 Hm HD$ HF HL$  HIHP   Hp  ^ Hv H  * HH  * HI. HH q* HI. HH W* HH|. Hp  Hp  Y HHxrHHm HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H{ HD$ HE HL$  HMHT$HHPHT$PLL$HI+HLHGI+HH;  HL$pH H HM) HH
 x) HI- HH ^) HI- HH1 D) (HMY+ 3ۋHGH+HHt9D  Ht,HM0+ HHHM HHGH+HH;r̲)HM+ H HM( (HM* HD$PHL$HH+HHt<Ht,HM* HL$HHHM= HHD$PHL$HH+HH;rĲ)HM* Hp  HL$px HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ HC HL$  3ۋH   IM+     HI9uHHH;r  HMpm H H   ' HH/ ' HI+ HH ' HI+ HH f' HH
 HH8 K' (H   ]) HHGH+HHt:Ht,H   7) HHH    HHGH+HH;rƲ)H   ) H H   & (H   ( HD$PHL$HH+HHtBHt,H   ( HL$HHH   2 HHD$PHL$HH+HH;r)H   {( Hp  HMpk HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8̿ H HD$ HA HL$  MtLD$XM+II H  H3 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H讪 HHHH\$@H0_H\$Ht$WH0HD$        IHf HHHH\$@HpHHt$HH0_@SH H HHt
   V HH [@SH H   H HH [H% HL$UVWAVAWH0HD$ H\$pILHH HHqHt$hE3L>L~$ HH_H\$hL;L{# HL(L0L8L@LHLPLXL`LhI;t8HHRH! HH@HH HH@L~DD$`IH˛ H;t9HHRH' HH@HH HH@L{DD$`HHޚ HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP HW yI^I;^u3HIN͙ HI;FtHP H( yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H辫 yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP HH tHHH;t-IM轘 HH;tHP H yHHS@   IM萘 HI}H;tHP H tHH;   HIMY HH;tHP H赪 tHHS@HL$H͎ H|$PH\$HH+HHHL$0讦 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH\ IU(I莥 IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP H裩 yHHH;t*IO HH;tHP Hw yHHSX?IO IHH;tHP HI yHH;tHIO IWXH蓤 H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP H质 yI_I;_t/HIO* HI;GtHP H腨 yI_HS@IW@H蛌 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI處 HI;GtHP H yI_I;_t/HIOj HI;GtHP Hŧ yI_HSXIWXH H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3聛 HGHH;tiD  HS Hd { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3њ HGHH;tiD  HS H贙 { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   Hb HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+I H_@H_HH_PHW(HtLG8L+IN H_(H_0H_8LGHT$0MHOM J HO LGHT$0MHOM  HO H\$8H HH _@SH LHT$0MHM  HH [7 @SH LHT$0MHM  HH [ H	 H@SH H HHt
    HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH H; HHt
    HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH H; HHt
    HH [@SH HS HHt
    HH [H(HIc HHy H(H% @SHPHD$ HRo H3HD$HHHHT$(H HHK HH  HD$@HrQHHL$(H=   r<t HAH;rӳ H+Hsó H'v H HL$HH3X HP[H(HIs HH H(H% @SHPHD$ Hbn H3HD$HHHHT$(H HHK HH(  HD$@HrQHHL$(H=   r<t HAH;r H+HsӲ H'vƲ H HL$HH3h HP[H(HI HH H(H% @SHPHD$ Hrm H3HD$HHHHT$(H HHK" HH8  HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vֱ H HL$HH3x HP[H(HI  HH H(H% @SHPHD$ Hl H3HD$HHHHT$(H/ HHK 2 HHH  HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3 HP[H(HI( HH H(H%& @SHPHD$ Hk H3HD$HHHHT$(H? HHK(B HHX ʭ HD$@HrQHHL$(H=   r<t# HAH;r H+Hs H'v H HL$HH3 HP[@SH Hs HHt
0    HH [HI HH H\$WH Hw HHHM t
(   H HH\$0H _@SH HHHSH
! H3H
HJHH H HHH [Hѣ H@SH H HHt
    HH [@SH H HHH贝 Hu HH [ K H(HQHI? HHU H(H%« @SH HHQHI
 HH HH H [H% H\$WH H? HHH H Ht
0   H HH\$0H _23HHBHBH@SH HHRH;c HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+Ib HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iѹ WD$0Hl$@@tHT$HHtLD$XL+I袹 HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iq WD$0Hl$@@tHT$HHtLD$XL+IB HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Ia WD$0Hl$@@tHT$HHtLD$XL+I2 HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWH% HL$8Ht HT$@] LD$HHT$8L+I: H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWH腞 HL$8Ht HT$@0] LD$HHT$8L+I H\$`HP_@SH H HHt
   6 HH [H\$Ht$WH HJ HH3HIPH*Ht:HSX_ HK`HH+KPHHLI?LHSP H{PH{XH{`HS8HtLCHL+I H{8H{@H{HHK Ht:HS(n_ HK0HH+K HHLI?LHS 虲 H{ H{(H{0HKHt)HS[ HSLCL+IW H{H{H{Ht$8HW HH\$0H _@SH HYLHIHN H;H [Hl$Ht$AVH0HHHQE3HIDt$ UN H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHHt Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ M H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQH遇 @SH0HD$     HQ8H賍 HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI~ D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0L I?HHD$0H;t?HHtLGL+I L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H HHHIVI+H*HHHH?HH;s(  { t m IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   HR HH\$0H _@SH  HD$HH\ H3H$p   HH      HL$P' HW HL$`e HH	 HH  H$P  HL$PW HxrH H
m HL$ 3HL$(HL$0HD$8D$@HT$(HL$8 H{ HD$ H! HL$  H$p  H3 HĀ  [HL$WH@Lo- HH
=- IL
C- LL+!- ILF- M;s$K9<sIHH+, HL"- L;rH\$XHt$hM;~  H, HpHH;HBHHt$`hH, HHD$PHD$PH;sNH
, HD$PH;w=H\$PH+HH;, uH
r, = Hn, Ht;HZ, HH
$H;Z, uH
A,  H=, Ht
HH., HH#, Hz    H
), HD$`L
, H;sLHD$`L;wBH\$`I+HH;
, u   H
+ 8 H
+ L
+ HtGIH0H;
+ u   H
+  H
+ L
+ HtH1H
+ L
+ L+ HH
|+ HU+ Ht$hH\$XJH8H
|+ KHHf+ H@_3H HD$0HL$ H HD$(HҦ HD$ . HT$HL$WH@HD$ H\$hHD$X   H=* H|$`   dHD$PWf* 3H* LD$P H* Wf* LD$XH
*  H* H^* H
HL$XH
* HH* H* Wf* f* H* H* f* H9u13HD$8H HD$0Hƥ HD$(H HL$( HH\$hH@_H\$WH H) 3H
) HH+HHt7D  HHtHf H) H
) HHH+HH;rH) HH   H) H+HH;v H    H=   r<tל HBH;rǜ H+Hs H'v HH H
( WfT) H=E) H&) H   H&) H+HH;v\ H    H=   r<t@ HBH;r0 H+Hs  H'v HH/ H
H( Wf( H=( Hw( H   Hw( H+HH;vś H    H=   r<t HBH;r H+Hs H'v| HH H
' Wf' H=' H' H   H' H+HH;v. H    H=   r<t HBH;r H+Hs H'v HH H
' Wf/' H= ' Ht}H' H+HH;v H    H=   r<t HAH;rv H+Hsf H'vY Hx WH=& f& H\$0H _L& L9& u0HY& H~&     HH\& H}& H HHh& I@IHH
q& H
& HH?& HH
m& H
~& HH3& HH!& H
b& @SH HHHSH
 H3H
HJHH H| HHH [@SH H IHHHA    HD$0H$ HL$0H;sdH$ HL$0H;wSH|$8H|$0H+HH;$ u   H
$ n H$ Hx$ HtHHHm$ H|$80H;g$ u   H
I$ , HE$ Ht
HH6$ HHH($ H [H H@SH Hȃ HHـu
   HH [@SH@HD$ )t$0(HH$ HHH$ H;$ r
   HHL$PHt
(3HH(t$0H@[HH3H HD$0HL$ H HD$(H HD$  H\$ WH HR H3HD$3LnA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HAO  ATO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3g H\$HH _M  N  N  +N  7N  CN  ON  N  N  [N  gN  sN  N  N  N  N  N  N  N  N  N  N  N  N  N  O   	
	
	
 	


	

@SH@eH%X   H)t$0(1
    )|$ (=??
 Hȋ
9    f]5T@
 f_5,E
 fYfX=>
 ffT=\>
 f\(|$ ((fY
;
 fY
>
 f\ff\fI (frfYfpc((fY%;
 fY
r;
 fX%<
 fX
;
 fYfYfX%=
 fX
:=
 fY(t$0fYfX
>
 f\f^fY%>
 fX%=
 fYf_H@[H
 / = fo:
 H
 f 覴 @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH H{ HHـu
(   HH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH2 HH(H$ H; r
(   HHt$@Ht*H?HOXKHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^Ho HH(Ha H;R r
(   HH|$`Ht&H(XKHNH_w HF HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(HWf.z
uI H^H HH(H H; r
(   HH|$XHt&H(XKHH_w H HH>HH\$PHt$`(t$0H@_HIHII      AD$HD$I#I;w]HB HL$HD$I#I;wAB^XAAHJ HBAHYJY^A\AI      LAHB L@HA IYI@Y^@\@AVH0HD$ H\$HHt$PH|$XIHLHB HH(H4 H;% r
(   HHt$@Ht*H?HK^OHH^H~ H} HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$XHt$`)t$0I(HH HH(H H;u r
(   HH|$PHt&H(^KHqwH_ Ha HH>HH\$XHt$`(t$0H@_AID$I      HD$I#I;w,HQ BD$HD$I#I;wB\ABHA H      HH@WH@HD$ H\$XHt$`)t$0I(HH HH(Ht H;e r
(   HH|$PHt&H(\KHawH_ H HH>HH\$XHt$`(t$0H@_HIHII      AD$HD$I#I;wHHB @D$HD$I#I;w,YBXAAHBHJ @YBXAAI      LAHB L@HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH HH(H H; r
(   !HHt$@Ht*H?HOYKHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHf.,
 z
uHH^H HH(H  H; r
(   ]HH|$`Ht&H(YKHH_w H HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(Hf.
9,
 z
uI H^HN HH(H@ H;1 r
(   HH|$XHt&H(YKH-H_w H% HH>HH\$PHt$`(t$0H@_HQIBD$HD$I#I      I;vH      HBB\AB@SH HXr HHـu
    +HH [@WH0HD$ H\$HHt$PHHH* HH H H;
 r
    yHH|$@Ht%HKW
5
 HH_H HH>HH\$HHt$PH0_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH HXq HHـu
0   +HH [@SH HHHSH
 H3H
HJHH H} HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3[ H+` HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$H4 HHoHH$   Hp_^]H	H% @USVWAVHl$H  HD$PHu? H3HEpMA؋H   D$     Hp HD$`HM D$    E3E3HT$hHL$`R HD$`HcHHr HD`HD$`HcHxT\   HL$h" H HL$` HH q HHק b Hȋ HH H HH~ 9 HȺ    HHY  Hȋр HI HH HUPHL$`M HxrH H
# HL$(3HL$0HL$8HD$@D$HHT$0HL$@p Hv HD$(H} HL$(Y @SH H   H HH [H%̀ @SH HHHSH
 H3H
HJHH Hv HHH [E   Hx  HD$8HX= H3H$`  DL$0HL$@ H~ HL$P HH  H$@  HL$@} H$@  H$X  HC$@  HD$ L
L LD$0Hh H
 T HWHp  HD$0HXHpH< H3H$`  AAH$  A|A@;|iHL$@~ H HL$P
 Hȋ$  ~ H$@  HL$@} L$@  H$X  LC$@  Ht$ DË~H$`  H3譠 L$p  I[IsI_E  SVWH  HD$HH; H3H$p  AHHHL$P} H HL$`= HHk . HH# HH1  HH	 HH  Hȋ} H$P  HL$P{ H$P  H$h  HC$P  H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8P~ H{ HD$ H HL$ 9 @SH HHHSH
 H3H
HJHH~ H{ HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu((u (
~ D$T$f (fYfYfYfXf fX
n fYfYfXn fX
v fYfYfXv fX
~ fYfYfX~ fX
 fYfYfX fX
 fYfYfX fX(f^((s (
s D$T$f (fYfYfYfXs fX
s fYfYfXs fX
s fYfYfXs fX
s fYfYfXs fX
&s fYfYfX&s fX
.s fYfYfX.s fX(f^(H8W)t$ f/(vbWD,
 
 
#
 f/D$@   f.z$u"| $
 X "   (t$ H8{ X(t$ H8
 
#
 f/D$@wHf.z u| #
  "   (t$ H8(t$ H8H%{ LD$@H q LD$@H wq HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3{ HV HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHMۯ IwHu@HH^H^uHtFHHHH;t_LLMt32z IV HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHM I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM7 HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMH豭 H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHX?
 LqWMHHEIHEI~Ht3w HS HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHML LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHMB L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;t\IHHt3/v HQ HELuH}LE7HUHM LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHM`B HMnu HMcu L$   I[(Is0I{8IA_A^]LWH   H
^
 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tHt Ht
HXP HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0{ H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3[s H+O HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHM; I~H}@HH_uHt3r HN HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHM訧 I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHMu H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHX
 LqWMHHEIHEI~Ht3p HpL HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHM; LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM.= HMn L$   I[(Is0I{8IA_A^]LWH   H

 f/   HA\I[3IsHq ICD$hH9rt"H
en Ht
H0J HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0k H$   HĀ   _@SH HHHSH
qv H3H
HJHHl Hs HHH [AYAHAX@@@WH0HD$ H\$HHt$PHHH HH H| H;m r
    HH|$@Ht&HC
 (HdH_Hib HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HHd HHGH+HH    HJ HHH= H;. rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDHh HH(HZ H;K r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHM HMHM 8F HELELEHM HMLHUNL+t	H
 HMF LHEHMHMHULL+t	H
 WD$PH}LHt3i HE HHD$PH}HL$PLt$X3L;t-i HtHE HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$`f =F
    HEH   L   LD$PHH     H9V~EH
 
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3ph HtH;D HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$` HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HU HD$@HD$`H|$HHFH;t'H;tHPg Ht
HC HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM) HL$@f HL$Pf If HMf HMf HMf HMf L$`  I[0A(sA({IA_A^_^]@SH HHI(Ef HK;f HH [H%,f H\$Ht$WH@HY)t$0Hi H\$PHHHJ()|$ H(A HLGLCHLGIL+LtHe
 H\$XH~(|$ v Ht$`(t$0H@_Hh HHIH%e @WHPHD$ H\$hHt$pHH! H3HD$HHHD$@   3Ht$8@t$(DFH HL$(+ HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVH HH;HKHtdHA   HqHyrHHH<H;Cu
   H賅 HKHt(HA   HqHyrHHHT$(  R HC HD$@HrQHHL$(H=   r<t/e HAH;re H+Hse H've H! HD$@   Ht$8D$( A
   H HL$( HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H HH;HKHtdHA   HqHyrHHH<H;Cu
   H} HKHt(HA   HqHyrHHHT$(   HC HL$(-S HL$HH3 H\$hHt$pHP_H\$WH Hf HHHIb t
(   H HH\$0H _HqZ H@SH H[Z HHt
   覊 HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHHCe H\$0HHHJ= HLFLCHVLFIL+LtH
 HFH\$8HGHF Ht$@HG HH _Ha HHt H\$WH Ha HHH^t t
(   H蔉 HH\$0H _@SHPHD$ HB H3HD$HHHD$@   HD$8    D$( A   HӇ HL$(! HHHT$(PHD$@HrQHHL$(H=   r<ta HAH;ra H+Hsa H'va H赈 HL$HH38 HP[HWH@H@HXHhHpIHHW@3HpVHHA LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
 ] IPL+IIHL+IM;HCH;HCHL$(茨 LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
2 \ IPL+IIHL+IM;HCH;HCHL$( LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+I7 H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xHZ H3Hp  I((Hǅh     Hǅ`      ƅP   A   H HP  ) HHPH0  S\ HP  H@   H(+\ HH t H0  H0  Z LHHAPHH  HrSHH0  H=   r<tp^ HAH;r`^ H+HsP^ H'vC^ Hb HM0[ HǅH     Hǅ@      ƅ0   A H`  H0   H0  HM@ H(@[ HH  HH  HrSHH0  H=   r<t] HAH;r] H+Hs] H'vy] H蘄 H0  HM08Y LHHAPHH  HrSHH0  H=   r<t'] HAH;r] H+Hs] H'v\ H HL$0OZ HǅH     Hǅ@      ƅ0   A H`  H0  軆 XH0  HL$@ H(Y HH : HH  HrSHH0  H=   r<tW\ HAH;rG\ H+Hs7\ H'v*\ HI H0  HL$0W LHHAPHH  HrSHH0  H=   r<t[ HAH;r[ H+Hs[ H'v[ Hɂ HHPHMW HMY H   W H   Y H  eW H  hY Hh  HrSHHP  H=   r<t%[ HAH;r[ H+Hs[ H'vZ H Hp  H3z L$  I[A(sA({I]HUSWHHH  HD$ )p)xH H3Hp  ((HHǅh     3H`  @P  DGH; HP  o HǅH     H@  @0  E3H9| H0  ? HKHH0  P HH  HrSHH0  H=   r<tY HAH;rY H+HsY H'vY H̀ H0   W HP  H@  l H(V HHf ! HKHH0  PHM0V HǅH     H@  ƅ0   A H`  H0  ' H0  HM@ H(bV HH 諽 HH  HrSHH0  H=   r<tX HAH;rX H+HsX H'vX H HKHHU0PHL$0U HǅH     H@  ƅ0   A H`  H0  R XH0  HL$@ H(U HHF~ Ѽ HH  HrSHH0  H=   r<tW HAH;rW H+HsW H'vW H~ HKHHT$0PHǅH     H@  ƅ0   E3Hy H0  袂 HKHH0  P HH  HrTHH0  H=   r<t=W HAH;r-W H+HsW H'vW H/~ HMS HMU H   R H   T H  R H  T Hh  HrSHHP  H=   r<tV HAH;rV H+HstV H'vgV H} Hp  H3v ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHH\F HHqHt$`3H.HnHcڅt3 U H0 HH^HwHt$`H.HnHt3T H0 HH^Ho(Hw0Ht$`H.HnHt3T Ht0 HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHHE HHrHyH|$hE3L'LgHt3 T H/ HHwLu HsHt$hL&LfMt3S I/ HLvHE(HC(L}8Ls0Lt$hM&MfMt3S I/ IM~HUH% HUH HU0I
 HH\$pHl$xH0A_A^A\_^H\$WH HHHH HC(HSHOHG( HS0HO0 H\$0HH _@UVWATAUAVAWHpHD$ H$   H H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHn4 HcH;U|H
Z 4P EL9e#  IIf     HD$@   Ld$8D$( A   Hdy HL$(F~ IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH萦 HwHtoHF   LfH~rHH  H{sLCItHH4P 	HHL#HCHFHCHFHC   H{LcrH HG HL$H@ HL$(@ AIcH;]}/H
f M H
X M H
* N AH9u   I HD$@   Ld$8D$( A   HHw HL$(&| IIFH+HH;vJHLHT$(HL$H HH5 HL$H? HL$(? HcH;]zH
 [M HL$hH3=p H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHH: HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;ICw HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;IC HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC7 HSHt
HHH
HB   H
 nJ H
 `J LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC蚕 HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
Q I H
C I HL$VWATAVAWH0HD$ H\$hHl$xHcLH/N II~@H|$pE3L'LgLgIHtIHHH;tHHHt3K H' HH_H_LHMI;~NL    
 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHJ Mt
It& HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@Y H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx H H3HE`LHE3ADt$ HEX   LuP@}@EF Hp HM@u IE HU@IPHEXHrPHHM@H=   r<t$J HAH;rJ H+HsJ H'vI Hq Aމ\$$H9^H  ML=C HJ H
]N HL$@HT$PHM	H |$ E3HT$XHL$@G HD$@HcHHMH HD@HD$@HcHhT<HD$XHD$0HL$X0E L|$XLuDuHF@BHL$PF A   EL9vP~S@ ff     H~@H^HIIHno HL$P谭 HJF AIIcH;FP|Ë\$$|$ HU@HL$@D ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   Ho HD$@HcHHG HD@HD$@HcHhT<L=B L|$XHL$XP~ HL$X-F HL$`jE HM F É\$$IHcH;FH}$E3G G G G HM`H3~g L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0F HKF HKH [H%F @SH HH   D H   HLcBADuluHT$0D H [D H   HLcBADuLt2H [H\$WH HH   HT$0O L   I HcHBDuT$0@:tI>D 2H\$8H _ðH\$8H _@SH HHT$0H    L   I HcPBDt2H [L$0F tT$0HK H|$84 H   HT$0C HHcQDu@fD  L$0F u8L$0vF u)T$0_t$.tH   ^C H|$8H [T$0HK +4 H   HT$0AC HHcQDtH|$8H [@SH HHT$0H   ֶ H   HHcPD
uT$0"tFB H   HT$0蠶 H   HHcPD
uT$0't2B HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33D l$HD ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @A Hv_H~HHfff     I   hA HHu2Hv&H~HHfI   8A HHu2j@SH   HD$@H H3H$   HHL$0HA    HyrHH  H   HT$ @ HHcQDuAL$ C uL$ C T$ tHo1 H   H   q@ HqHX H$   H3wb HĠ   [@SH HyHHA    rHH  HT$0H   @ HHcQDufL$0B uL$0B T$0t6H0 H   HT$0? HHcQDtH*   H [H   ? H   H [H   HD$0H H3H$   HL$ d H$   H3ca HĘ   @SH   HD$0)$   H H3H$   HHL$ ' (Wf.zu	HѸ (H$   H3` ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5h DH@ H   HUHP HHcJD   UH:7   HD847uAHh HEt
5 5 HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKXa HS`HtHCXHH
HB  H   = HvSHHHH   = HvHu.Hv(HHHD  H   X= HvHuE3Hg Ht HKXHUHEH*   @2LsH{rHHD0HU@H   < HHcQDugH
     M@? U@uB<:w2Hs,@H- H   HU@< HHcQDt
H   < @u<HC`H+CXHu,HEtHK@EHHUH$ HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKX` HS`HtHCXHH
HB%H;Chu   HKX_ HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5 BH;Chu   HKXm_ HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0; HLcBAD u!L$0= uT$0H   : H   HT$8蝮 L   I HcHBDuT$8-tDI: H   HT$8@2` H   HHcPD
uT$8+tS: @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(t9 2H0A^H\$HHT$@Ht$XH|$(语 I   HHcPD
uT$@)   9 IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@\ IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINp\ IVxHt:IFpHH
IFx   I;   u   INp\ IFxHtH0IFxkI;FPu	IN@\ IFHHt0IFHHHl$PI   HT$@' I   HHcPD
uT$@)t#8 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INp[ IVxHt7IFpHH
IFxI;   u   INp[ IFxHtL8IFxU@UH0HHT$@H   6 H   HHcPD
uT$@(t)7 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   6 HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMXZ HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMp)Z HUxHt:HEpHH
HEx   H;   u   HMpY HExHtL0HExtH;Ehu   HMXY HE`HtL0HHE`HHt$PH   HT$@U H   HHcPD
uT$@)t"H5 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMpY HUxHt7HEpHH
HExH;   u   HMpX HExHtL8HExV@SH HHT$0H   f H   HHcPD
uT$0(tY4 2H [HT$0H|$@* H   HHcPD
uT$0)   4 Ht$8HH   HT$0 H   HHcHDuT$0,tH   3 Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKpW HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp-W HSxHt@HCpHH|$@H
HCxH [H;   u   HKpV HCxHtH8HCxH|$@H [H;   u   HKpV HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH   3 H   HHcPD
uU(t'2 2H([]Ht$HHj\ AH|$PHH˄t
   AH/X H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@ MM;~fHUHK@ EȉE;}HCpHUHCxH   / H   HHcPD
uU,t#1 Ht$H2H|$PH([]ò.H~tAHX[ Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8 ,Ht'HrHUHEHKp ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp HMHHMH;v)Hh뒐HUHKps HEHHEH;s)H9`@UH0HHT$@H   v H   HHcPD
uT$@ct)i/ AHY HḦ́tH0]HH0]AHwU Ḧ́t
H0]AHwY Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@Q HUHHt%HE@
H;EPu	HM@Q HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@YQ HUHHt%HE@
H;EPu	HM@6Q HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@ Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+I5O H{pH{xH   HSXHtLChL+I
O H{XH{`H{hHS@HtLCPL+I8> H{@H{HH{PHK C HH\$0H _1 @SH0H3HQ D$ IE3HHC   HC@[ HH0[@SH0HD$     HQpH HH0[@SH0HD$     HQ@H  HH0[@SH0HD$     HQXH HH0[@SH   HD$@H? H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H   E L   I HcHBD   T$ <tI0+    -H   Hi   HǄ$      HǄ$       D$pA   HXU HL$pnX HD$pH$   HCD$pH
*5 HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   n+ H( HD$PA;  HT HL$P 2H$   H3tL H   [HUATAUAVAWHl$H  HEHXHpHx H H3HEpHLHMH= HLiLl$03I} I}躐 IE M|$L|$0I?I蠐 II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIg HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	艏
 uH;s3H;t.LuLEI LH HD$ LHT$0I] H\$0HK@HT$8: HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  HKQ HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  HP HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  H]P HT$hHtLD$xL+I8 WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$ HHT$8 HM HT$PHtLD$`L+IH HT$8HtLD$HL+IG HT$hHtLD$xL+IG WD$hH|$xHUHQLEL+IG <' ' ' ' ' ' ' ' ' ' ' ' ' ' HMIHMpH3/G L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+IF H{H{ H{(HHtLCL+I5 H;H{H{H\$0H _H\$WH HQ3HHtLA(L+IXF H{H{ H{(HHtLCL+I4F H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0# HN HL$@؊ Ht3HwHN HL$@辊 H;sHfL HL$@訊 HH;rHaN HL$@菊 HH3# HH9N t HT$0HHD$0HcHHf$ HD0HD$0HcHhT,HW HD$HHL$H[ HL$Hu# HL$P" H$   d# HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tHHHt3# H LHD$(Lt$(H\$0H\$8HH~AL    M
 HIH;u(WHHH;|HMH;|HL$P! HL HL$` Ht3HnAHL$`r! H;sHrJ HL$`贈 HH;rHmL HL$`蛈 HH?! HH9J 耈 HH$! HH*L e HT$PIHD$PHcHHW" HDPHD$PHcHhTLHH HD$hHL$hY HL$hf! HL$p  H$   U! IS" IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   H H3H$  ILHH$   LL$83ۉ\$0HHYMt3! H HH~D$0   HǄ$      H$   Ƅ$    A   EHJ H$   M HǄ$      H$   Ƅ$    EGHJ H$   NM HǄ$      H$   Ƅ$    EGHJ H$   M HHL$`aHD$ L$   L$   H$   IZHT$`HtLD$pL+IIA WD$`H\$pH$   HrTHH$   H=   r<tg! HAH;rW! H+HsG! H'v:! HYH HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t  HAH;r  H+Hs  H'v  HG HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<tk  HAH;r[  H+HsK  H'v>  H]G HǄ$      H$   Ƅ$    A
   HH H$   'K IL$   HT$xIPH$   HrTHH$   H=   r<t HAH;r H+Hs H'v HF HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;v H    H=   r<t HAH;r H+Hs H'v~ HE HH$  H3> H  A_A^_^[LSVWAVH  IǃXH7 H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFHF IpH HǄ$      L$   D$   EF
H9F H$   H HǄ$      L$   D$   EFHF H$   H LHHL$H\HD$ L$   L$   H$   HxUHT$HHtLD$XL+I< WD$HLt$XH$   HrTHH$   H=   r<t HAH;r H+Hs H'v HC HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<tL HAH;r< H+Hs, H'v H>C HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t HAH;r H+Hs H'v HB HǄ$      L$   Ƅ$    A
   HD H$   F HL$   HT$xHPH$   HrTHH$   H=   r<t HAH;r H+Hs H'v HB HǄ$      L$   Ƅ$    DDHT$xHL$H迒 HHHHHHJHCHBHKHJHCHBHKHL$H HT$xHtL$   L+I: HH$  H3: H  A^_^[H   HD$`H1 H3H$   LHT$03DI          M;HsBIIcD$@HD$@I#I;uHeT HD$(HaB H
:C  IWD  I;Ps8IHcf/w"H
T HD$(LHB H
C g HH$   H39 HĨ   H   HD$HHA H3HD$xHT$ L褒 HL$xH38 HĈ   AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ D AXA((yXA@^A(]\A(\YYAX(qS}
 K8W
y Ys ^C0\(!}
 D\YDYCDX(DC|
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hH H3HD$0HHHT$(Hv HHHA   3HqHyrHH@0IE3C Hs(Hs0s8s@C<Hf HHL$0H36 H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH H3Hp  DHH  f  LAH@ HP  蜉 L@ HH0  E LHHAP HH  HrSHH0  H=   r<tT HAH;rD H+Hs4 H'v' HF= HǅH     3H@  @0  Hh  HrSHHP  H=   r<t HAH;r H+Hs H'v H< HǅH     H@  ƅ0   A&   H? H0  @ HH0  HP HH  HrSHH0  H=   r<t5 HAH;r% H+Hs H'v H'< HǅH     H@  ƅ0   E3H6 H0  ? HH0  HP HH  Hy  HH0  H=   r<t HAH;r H+Hsp H'vc H; !  C  3A;  HǅH     H@  @0  DG9HJ> H0  6? HH0  HP HH  HrSHH0  H=   r<t HAH;r H+Hs H'v H: HǅH     H@  ƅ0   A   H= H0  > L0  H= HP   LHHAP Hh  HrSHHP  H=   r<t HAH;r H+Hs H'v H: Hǅh     H`  ƅP   HH  HrSHH0  H=   r<t HAH;r H+Hs} H'vp H9 Dv(WI*(Y H,ȉN,Y
ȵ H,F0D+D+Dv4Hǅh     H`  ƅP   A9   H< HP  $= HHP  HP HP    Hǅh     H`  ƅP   A/   H< HP  < HHP  HP HP    H0   H< H@  &v HȋV, HH0  HPHM0 H< HM@u HȋV4 HHU0HPHL$0} Hu< HL$@u HȋV0g HHT$0HPHǅh     H`  ƅP   E3H2 HP  ; HHP  HP HP    HM HM H    H    H  i H  l Dv(DF,DN0N4~8N@AAF<Hp  H3/ L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   HR; HH: HT$(HH HHOHfHH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHI<K8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKHޘ,CHE3L% fnHGLH(X^^Y%ʱ L9G~    MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKHѓC8L|$ Lt$PHl$@H(_[ÍAC82H(_[H  @SH A H- HHH HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLH IIv@H$   3H>H~Ht30 H  HH^Y D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$H@ IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tHP Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx Hi H3HEPLLHEH   HE@    E0 A)   H6 HM0J6 IHU0IPHEHHrPHHM0H=   r<t
 HAH;r
 H+Hs
 H'v
 H1 HL$0 IF@HL$@    I9vH~:~D  I^@H0 HL$@+o H HHcI;FH|HU0HL$0  MHIAPHEHHrQHHM0H=   r<t
 HAH;r
 H+Hs	 H'v	 H1 HD$0HcHH HD0HD$0HcHhT,H HD$HHL$H? HL$H HL$P HM HMPH3,) L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   H. HH)4 HT$(HH HHOHVHH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHI視K8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKH蟘,CHLOLH|$H> %v fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^YӪ L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0k HKH#C8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A HW( HHH HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pHV H3HEHHE   3H}@}DG<H1 HM>1 HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H, HE   H}E A   H1 HM0 HHUHP HEHrPHHMH=   r<tT HAH;rD H+Hs4 H'v' HF, HE   H}E AC   H)1 HM 0 HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H+ HE   H}E A/   H0 HM/ HHUHP HEHrPHHMH=   r<t6 HAH;r& H+Hs H'v	 H(+ HE   H}E A<   H/ HM/ HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'vz H* HE   H}E E3Hm% HMv. HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H
* HE   H}E E3H$ HM- HHUHP HM  HMH3V" H\$hH|$pHP]LEK ECL$UVWHP  HD$0I[AAم+H< HD$ L
< MCH / H
.  ̅/H< HD$ L
t< L$  H. H
.  ̅/Hm< HD$ L
A< L$  H. H
k. ^ fnf
 f
 ,;tCt
Ù-  HL$P  H$  HL$`bj H{. HL$`!f HcHL$8
 HL$`HcQHL$`HHPHL$`
 HHA. e Hȋ
    HL$8}
 HH. HL$`e HHu3
H HcHHHUU kdHC
 HH- te H- HL$`ce H$  HL$`i H$  HHT$PPH$     H$   
 H$x  HP  _^]H\$WH0ME3M@HMtHMHH      @ f     IcAD$PHD$PH#H;w)IM;r܋A(L
- HˉD$ z H\$@H0_H$: MH, HD$(H蝼 H\$Hl$Ht$ WH@I@H-, MHIHHD$0LHl$(HH LH${ HGL
, DC(H, HHD$ 1} HOE3HOHtCHII      f     IcD$PHD$PI#I;wIL;rH\$XHl$`Ht$hH@_LHHZ HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt3u
 HE HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHMY2 LvLu@II^I^uHtFHHHH;teLLMt3
 I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHM1 ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+tYa
 II^H\$XH    HC    HC    HtFHHHH;tdHHHt3X
 H( HH{H{LHSE3L9C~JL    
e 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH@HD$0H\$pMHHHJs HHHGHFHHGLL+t`
 H^H\$hININ8 HHIFHCIFHCIIFIFLL+t_
 HWV(E3LGMtlHII      @ f     IcD$hHD$hI#I;w
IM;r#H5 HD$(LH' H
f( 艷 ̉T$ L
' H
N( Qu MH?( HHH\$pH@A^_^H\$Ht$WH`HLH$( HHHs3HD$ HGH;t'H;tH
 Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@v H\$xH$   H`_H\$Hl$VWAVH`HLHQ' HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH
 Ht
H HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@u L\$`I[(Ik0IA^_^N`H\$UVWHHpHcy(3H)t$`WuH9yt"H	
 Ht
H HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM+ Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tH
 Mt
I HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHM* H$   Hp_^]s^HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t]LLMt3
 I HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHM+ WEIHEIHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHM5+ LEHUIHMq
 HMf
 IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t[LLMt3
 Ih HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHM+ WEIHEIHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHMx* LEHUIHMT
 HMI
 IL$   I[8Is@IA_A^A\_]H\$UVWATAWHHpB(L
S  DA(LHD$ HV  H
  _ I3IHEHFH;t'H;tH
 Ht
H HHH~LHEHEHHELELNHEHE0HEIHHuH+HHHH~!D  HE(A)HH;}LEMHMn MgH~IGHOM HELeI;uL9tqMt"MtHHIL;   HGL$   MMHL;tH
 Mt
I HHL$   LgLHGHUHHEHUHUHUHU0HUHMLGLH}IHH+HHHH~"    HE()HH;}HMHMm H$   HHpA_A\_^]0XH\$Ht$H|$ UHHpB(L
/ DA(HHD$ H2 H
C ] LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHM1 HFHOLFHUL	HEHAHEHUHUHUHULELMLQLHUIHMHH+HHH~*    A(fAXA)HH;}
LELMMHMH螺 L\$pHI[Is I{(I]H\$UVWHHpB(L
 DA(HHD$ H H
 V\ H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM HOHM(LFLEHFHEL	LMHAHEHELQLQHEHEHEHE HEHE(HEIHH+HHH~1@ ff     A(fA^A)HH;}
LELMMHMH^ H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMHh HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM螵 HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHM HH\$xH`]H\$Ht$WHPeH%X   HU    )t$@HЋ9Hw    HcF(3HfnY5t ~nHFHl$`Hn)|$0= H4   D)D$ EWf     HH(TfA.zt	N
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
v / =v DNW H
wv X Y 't 
 HHPUWAVHhH   HEHXHp MHH3}׋A(D$ L
 M@H
 c DINHthIII      fff     IcEgHEgI#I;w
IL;r#H" HD$(MH H
p k HFHELuEEHuH;H{LvMt3b
 I2 HLsHUHMN HHE7HvHCH;t'H;tH$
 Ht
H HH;HsLLEHEHEHEHEHEgHEH]LKIHH+HHHH~+fD  HE7HM(fXA)HH;}LEMHM HM'
 HL$   I[0Is8IA^_]@SH HHIU
 HH [H%F
 HT$WH0HD$(H\$@HHD$     IHHH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHGHFHHGLL+t-K
 H^H\$HHOHO I HHHGHCHG HCHWHGHG LL+tJ
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHHHK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IrHHHOt
 Hk
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IbHHGHO
 H
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3
 I~ HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHM HwHu@HH^uMt3
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHM Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ) HHIFHFIIFLL+tG
 InH~H$   3HH_WD$(Ht3
 Hν HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$H IFF HHpA^_^][HL$VWAVH@HD$0H\$pILHHJ HHIFHCIIFLL+tF
 H{H|$hHNͼ HHHFHGHHFLL+tvF
 INK HCHD$ L
 DH@ H
 _ E3AHSII      HtULfD  HcAD$hHD$hI#I;w
HH;r&H HD$(LLHI H
J  HOHtSH     IcD$hHD$hI#I;w
IL;r#H4 HD$(LH= H
 詝 HH\$pH@A^_^H\$Ht$H|$ AVHpA L

 LBHH
 D$ L7[ I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHD$0HFH;t'H;tH
 Ht
H׺ HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~  HD$0()HH;}HL$@HL$P\ L\$pI[Is I{(IA^H MHa HD$(H
   H\$Ht$H|$ AVHpA L
9 LBHH
 D$ LY I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHHD$0HFH;t'H;tH
 Ht
HS HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~HD$0()HH;}HL$@HL$PX[ L\$pI[Is I{(IA^H* MH HD$(H
l
 蟚 H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	|
 Ht
HG HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHMK Hcw HuH9wt"H
 Ht
H袷 HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHM (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H誶 HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHM WEHHE'H~Ht3)
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHME LEHUI4HM
 HMv
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3

 Hڴ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHM WEHHE'H~Ht3\
 H, HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM LEHUIwHM
 HM
 IL$   I[(Is0IA^_]H\$Ht$UWAVHHpB L
 DA LHD$ H H
- PF I3I~HEHFH;t'H;tH4
 Ht
H HHH~LHEHEHHELELNHEHE HEIHHuH+HHHH~ HE(A)HH;}LEMHMU IFH~MvHEHGI;t'L;tH
 Mt
IT HHLwHHEHEHEHEHE HEHMLGIH}HH+HHHH~&fff     HE()HH;}HMHM\T L\$pHI[(Is0IA^_]H\$Ht$H|$ UHHpB L
 DA HHD$ H H
 D LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHM LOLGHNHEHEHEHEHEHEHMLMLEM@IHH+HHH~,ff     (fAXA)HH;}
HMLMHHM蒡 L\$pHI[Is I{(I]H\$UVWHHpB L
 DA HHD$ H H
 FC H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM HGHE(HUHNHUHUHUHU HML HUHU(LELHIHUHH+HHH~% A(f^A)HH;}
HMLEMHMHo H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHM苡 HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM辜 HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM; HH\$xH`]HHPVWAVH   HD$hHXHh )pMHH3|$0I@HD$ L
 DA H H
 CO DIVHteIII      Ic$   H$   I#I;w
IL;r#HN HD$(MH H
P Í H;H{HnHt3
 H被 HHkIH$   HFH$   HH$   HvH;t'H;tH
 Ht
HU HH;HsHHD$8HD$8HD$HH$   HD$PH$   HD$XH\$`HkHHH+HHHH~MH$   (4H$   ()D$pHL$p';H$   (fYfXHD$8)4HH;|LHHL$H	 HL$   I[0Ik8A(sIA^_^HT$WH0HD$(H\$@HHD$     IHHH$   HKa
 HX
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+t3
 H_H\$HHN辩 HHHFHCHVHFLL+tf3
 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHH$HKa
 HX
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHO
 H
 HH\$@H0_HG  @SH0HD$     HQHs  HH0[H\$WH HHQHtLAL+I  3HCHCHCH H@t
    H HH\$0H _@SH HQHHt.LAL+I>  3HCHCHCHa HH [HQ HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXH
 D$(HD$0HT$83HL$ HD$8HD$@H HD$ U
 H HP HD$0HL$0> H\$WH HHQ HtLA0L+I8  3HC HC(HC0H[ H@t
8   H HH\$0H _@SH HQ HHt.LA0L+I  3HC HC(HC0H HH [H HH [@SH HHHSH
 H3H
HJHHC
 H HHH [HAHH`HAHH`H\$WH H HHAH荹  HN HGHt
8   H HH\$0H _@SH H HHAH3  H HCHH [@SUVWATAUAVAWHxHD$(H H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HH HHHL$ H HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ Hl
 HIFHAIFHAIFHAH IV   H$ HHNط  L- L.H IGIO躷  MoM/H  I  IV HtMF0L+I  3IF IF(IF0M.HHL$`H3 HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+I  H{pH{xH   HK8]  HS HtLC0L+I  H{ H{(H{0H	 HH\$0H _H\$WH H,   t
  H" HH\$0H _H\$Ht$WH H  HHt*L  L+IO  3H  H  H  H5i H   H  HKpH= HKPH{@q  Hs@HKHs8H{\  HsH3H\$0Ht$8H _HL$SH0HD$ HH HLALD$HHP I HBI@HIHHA   HA    HyrHH  IE3  HH0[HL$WH0HD$ H\$PHHHK HHBHAHBHAHBHAH H 蓭  HO8HL$HH HHC@HAHCHHAHCPHAHSXH   HSpHOpL  HH\$PH0_@SH HHI HtCHS(| LC0H*L+C IHLI?LHS   3HC HC(HC0H| HH [H\$WH Ht
   H HH\$0H _H\$WH H<t
8   HR HH\$0H _H\$Ht$WH HHHH
 ' HH ' HH
 ~' HHW+ HH- *
 H
 HS' HH D' HH
 5' WPH
 HHn- 
 H
 H	' HHK & HH
 & H
 HH&- 
 H
 H& HH & HH
 & WHO
 HH, O
 O|tttt3   H
 HW& HH H& HHj
 9& Hȋ
 HHt, 
 O|  [  	  H
 H% HHW % HHD
 %    H
 HH
, |
 HI
 H% HH % HH
 %    H8
 HH+ 0
 H
 HY% HH J% HH
 ;%    H
 HHr+ 
 H
 H
% HH $ HH
 $    H
 HH&+ 
 H
 H$ HHc $ HH
 $    H:
 HH* J
 H
 Hs$ HH d$ HH^
 U$    H
 HH* 
    tB  H
 H$ HH $ HH
 # H   H
 H# HH # HH
 # Hs W  L   H> Ht
 H# HH # HH
 r#    H
 HH) 
           H H"# HH # HH # HHr " HH;) 
 L   H> L   H> L   HH !> L   H2? L   HHA <= L   Hm? L   HH < #  Hw
 HS" HH D" HHv
 5" HHS &" HHl( ޺
 L   H= L   H(> L   HH/ R= L   Hc> L   HHr m< L   H> j  H
 H! HH` ! HH}
 |! H   HE
 Ha! HHC R! HH
 C!    H
 HHz' 
 H9
 H! HH ! HH
      Hg
 HH-' 
 H$
 H  HH   HH
      H[
 HH& S
 L   H; H	
 Hm  HH{ ^  HH
 O    H
 HH& 
 Hc
 H  HH=   HH
     H
 HH6& 
 H
 H HH  HH4
     H#
 HH% [
 H
 H HH u HHo
 f    H
 HH% 
 Hb
 H6 HH ' HH!
     H
 HHM% 
 H
 H HHF  HH
     Ha
 HH$ q
 H6
 H HH  HH
 |    H
 HH$ #
          tB  H

 H& HH  HH
  H   H
 H HH  HHp
  H l  H@
 H HHR  HH
  HHd  HH# ?
 L   HHF 8   Ha
 HM HH > HH
 /   H
 HHf# ص
    tzt?   H|
 H HH  HHK
  H jH
 H HHP  HH
  HE 4H
 H| HH m HH
 ^ H HO H" H
 y tIH	 H* HH  HHE  HHWX0  HHF" 
     tLH4
 H HHn  HH	  HH    HH! c
 H(
 H HH2 } HH	 n WxH
 HH! 
 H
 HB HH! H\$0Ht$8H _H%
 H%A
 @WHPHD$ H\$hHMq H3HD$HHHD$@   3H|$8@|$(E3H) HL$(1  HT$(H胲  HD$@HrQHHL$(H=   r<tԵ
 HAH;rĵ
 H+Hs
 H'v
 H H   H   H  HHL$HH31 H\$hHP_@UVWATAUAVAWHl$H   HEH$   HIp H3HEA؉]HLHUE    A}NH
 HE3HEHEHy HEEHUHM[
 H HEHi5 HMF H    HB    HB    E   HE   HE    E A   H8 HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtH 
 u
HJ  H{rHHA   I;LBMtH s
 u
H  H{rHHA   I;LBMtHW 8
 uDHu>LFIH+HgfffffffHHHH?H  IHT  HF   H{H{rHH?A   I;LBMtH H
    Hs	3Hu{A^HE   HE    EIE3HUHM  ]HUH~  HM財  3IV(HEH;tIE3HM  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHMB  DmHUH2~  HM  HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v~
 H HNHi
 HE3HEHEH< HEEHUHM
 Hw HEH1 HM HMH3 H$   Hİ   A_A^A]A\_^]  @SH HH(  HKH [  @UVWATAUAVAWH$@H  HD$8H$  Hk H3H   MHHL$@  HHPHHu HL$P HH }Hd HL$P n  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<H> HL$P HHS HH y HHD$ T'
 HL$(Lt$ I+IHHLI?LAxcIcH<HLfK4H HL$P HH@ HH  HBT7 
 Md$HAxLt$ H HL$P HH 
 HL$ Ht2HT$(f HL$0H+L$ IHHLI?LHT$   HU`HL$@葪  H0 tSHEX   HEP    E@ A	   H HM@  LE@HU`H   Ex  H. H    H0 tSHEX   HEP    E@ A   H HM@K  LE@HU`H   Fv  H/& H   y Hz0 tSHEX   HEP    E@ A
   He HM@  LE@HU`H   Gt  H0' H    H[0 tSHEX   HEP    E@ A
   H HM@  LE@HU`H   Hr  H0 H    H<0 tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ l
 H= HE@H2 HM@W H0 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H+ HM@ H/ tXHE`H}xHCE`H
S
 HM@3HMHHMPHD$ D$(HUHHL$ 
 HE HE@H0 HM@ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ @
 Hi HE@HN' HM@+ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ ܩ
 H HE@H"* HM@ H/ tXHE`H}xHCE`H
'
 HM@3HMHHMPHD$ D$(HUHHL$ x
 H1 HE@H* HM@c Hd/ tXHE`H}xHCE`H
ò
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H] HE@Hb& HM@ H@/ tXHE`H}xHCE`H
_
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@HF' HM@ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ L
 H
 HE@HZ* HM@7 HEX   HEP    E@ A   HO HM@  LE@HU`H   l  Hb( H    HL$WH0HD$ H\$HHHH3
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE30  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 H!
 HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHKq
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_@SH HHHSH
 H3H
HJHH
 H̪ HHH [HL$WH0HD$ H\$HHHHC
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE3@  HH\$HH0_@SH HHHSH
 H3H
HJHH#
 H HHH [@SH HHHSH
 H3H
HJHH
 H HHH [@SH HHHSH
A
 H3H
HJHH
 H HHH [@SH HHHSH

 H3H
HJHHc
 H HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 HI HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH H HHH>  H
 HOH
 t
8   H0 HH\$0H _H\$WH Hw
 HHHޓ  H
 HOH
 t
8   H HH\$0H _H\$WH H HHH~  H_
 HOH:
 t
8   Hp HH\$0H _H\$WH H HHH  H
 HOHڢ
 t
8   H HH\$0H _H\$WH Ho HHH辒  H
 HOHz
 t
8   H HH\$0H _@SH0HD$ HHw HHE
 HA(H0
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HH HHު
 HA(H0
 H9 HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH? HHe
 HA(H0?
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HHؐ HH
 HA(H0ؠ
 HY HHKHtHP tHC    @t
@   H HH\$@H0_H\$WH HH HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   W L   H988L  M+IHLI?LI  3H   H   H  H   ؜  H   H [H%՞
 HL$SH0HD$ HH۟ HE3LAHH@ HLC0LC8LC@LCHLCPLCXLC`LChLCpL   L   L   L   L   L   L   L   L   L   L   L   L   L   L   L  L  H   HH0[LWATAUAVAWH@  Iǃ8I[Is A)sHZ H3H$   HHT$HHHL$PWD$p3ID$XHt$hE $    _   Iǃp   Ih@$  DFH: IX:  HǄ$     H$  @$  DFH H$    HǄ$     H$  @$   DFH H$     HL$0HD$ L$  L$  H$   HHT$0HtLD$@L+I  WD$0Ht$@H$  HrTHH$   H=   r<t!
 HAH;r
 H+Hs
 H'v
 H HǄ$     H$  Ƅ$    H$  HrTHH$  H=   r<t
 HAH;r
 H+Hs
 H'vv
 H HǄ$     H$  Ƅ$   H$  HrTHH$  H=   r<t%
 HAH;r
 H+Hs
 H'v
 H Lc(A4$HǄ$     H$  Ƅ$   A   HZ H$    HL$  HT$0HP(HHD$pH;t*HH\$pHJHL$xHBH$   H2HrHrH\$pHT$0HtLD$@L+I;  WD$0Ht$@H$  @  A$ `   HǄ$     H$  Ƅ$   A   H H$  
  HǄ$     H$  Ƅ$    A   H H$     HǄ$     H$  Ƅ$   A   H H$    HL$0qHD$ L$  L$   H$  HHT$0HtLD$@L+IϺ  WD$0Ht$@H$  $  H$     H$    H\$Ps,HǄ$     H$  Ƅ$   A   H H$    HL$  HT$0HP(HHL$p6  HT$0HtLD$@L+Ik  WD$0Ht$@H$  p  HD$pK, a   E$Hտ H
 UHǄ$     H$  Ƅ$   A   Hܽ H$    HǄ$     H$  Ƅ$    A   H% H$     HǄ$     H$  Ƅ$   A   H H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Ht$@H$  5  H$   '  H$    E$H H
G W$  Ic$WD$0Ht$@L$  HL$0һ  L{0L$   HT$0I詄  HT$0HtLD$@L+I.  HǄ$     H$  Ƅ$   A   H H$  x  HL$  HT$0HPHHL$X4  HT$0HtLD$@L+I蹷  WD$0Ht$@H$    LMc$LHt$XA   IrmIHHPLL+AH+MSIIN4    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sIJHJIHIM;r b   E$Hּ H
 VHǄ$     E3L$  D$  EFHܺ H$    HǄ$     L$  D$   EFH+ H$     HǄ$     L$  D$  EFH H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  9  H$   +  H$    E$H H
O $  Ic$WD$0Lt$@L$  HL$0ٸ  HsHHT$0H踁  HT$0HtLD$@L+I=  HǄ$     L$  Ƅ$   A   H H$    HL$  HT$0HPHHL$XC  HT$0HtLD$@L+Iȴ  WD$0Lt$@H$    MMc$MLt$XIrrHHHPML+IH+MSIIN<    M@      IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r	 c   E$H H
Ϲ fHǄ$     E3L$  D$  EFH H$  /  HǄ$     L$  D$   EFHk H$     HǄ$     L$  D$  EFH H$  ž  Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  I  H$   ;  H$  -  E$H H
 &$  Ic$WD$0Lt$@L$  HL$0  Hs`HT$0H~  HT$0HtLD$@L+IM  L$  L$  E33H$    A   H H$  葽  HL$  HT$0HPHHL$XM~  HT$0HtLD$@L+Iұ  WD$0Lt$@H$  '  MMc$MLt$XIrlHHHPML+IH+MSIIN<    MfD  IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r d   E3L$  L$  E33H$  踵  EFHQ H$  P  L$  L$  E33H$   }  EFHZ H$     L$  L$  E33H$  B  EFH H$  ڻ  HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I
  WD$0Lt$@H$  b  H$   T  H$  F  DsxL$  L$  E33H$  耴  A   H[ H$    HL$  HT$0HP(HHL$prv  HT$0HtLD$@L+I觞  WD$0Lt$@H$  ~  HD$pD DCx e   H H
 L$  L$  E33H$    A   H H$  W  L$  L$  E33H$   脳  A   Hg H$     L$  L$  E33H$  G  A   H H$  ݹ  HcSxHL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  a}  H$   S}  H$  E}  DCxH H
 >
$  HcSxWD$0Lt$@L$  HL$0  L   L$   HT$0Iy  HT$0HtLD$@L+IZ  L$  L$  E33H$    A   H H$  螸  HL$  HT$0HPHHL$XZy  HT$0HtLD$@L+I߬  WD$0Lt$@H$  4|  Lc[xE3Ht$XIrlIHHPLL+IH+MSIIN4    MfD  IDHBIHIDHBHIDHHR IuH|$HH\$PM;sIJHJIHIM;r f   E$H H
 DC,H H
 oE3L$  L$  E33H$  蚰  EGH H$  2  L$  L$  E33H$   _  EGHP H$     L$  L$  E33H$  $  EGH H$  輶  LcC,Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0L|$@H$  <z  H$   .z  H$   z  E$H H
j 
DC,H: H
S 
$  HcS,WD$0L|$@L$  HL$0ŭ  Ic$W$  L$  LD$0H$  蚞  L   H$  Ic  H$  &c  HT$0HtLD$@L+I  L$  L$  E33H$  蘮  A   H H$  .  HL$  HT$0HPHHL$Xu  HT$0HtLD$@L+Io  WD$0L|$@H$  x  MLck,MM   Lt$X@      LcC(IIr{I$LHP0M^O˾   H+IXHHH<    LfHJICJHJICJH
IJI7HICJM[ HR`HuH\$PE3I;s(M$HHL+IKJIHRIuIM;?H|$H0 g   Lk,EE H H
 L$  L$  E33H$    A   H H$  艳  L$  L$  E33H$   趬  A   H H$   L  L$  L$  E33H$  y  A   H4 H$    IcU HL$0 HD$ L$  L$   H$  H
HT$0HtLD$@L+I>  WD$0L|$@H$  v  H$   v  H$  wv  EE H H
ż pIcU W$  H$  C\  H$  H   H   H$  H   
 L$  L$  E33H$  U  A   HH H$    HL$  HT$0HPHHL$Xr  HT$0HtLD$@L+I,  WD$0L|$@H$  u  MMc] MHt$XIrvH   HHPLL+Ȼ   H+MSIIN4    Mff     IDHBIHIDHBH;IDHHR IuH|$HH\$PM;sH   JHJIHIM;r) h   L$  L$  E33H$    A   HZ H$  蝰  L$  L$  E33H$   ʩ  A   Hź H$   `  L$  L$  E33H$  荩  A   HH H$  #  HL$0HD$ L$  L$   H$  H"HT$0HtLD$@L+IV  WD$0L|$@H$  s  H$   s  H$  s  L   M<$L$  L$  E33H$  ¨  A   H H$  X  HL$  HT$0HPHHL$Xp  HT$0HtLD$@L+I虣  WD$0L|$@H$  r  HD$XHI$8 i   L$  L$  E33H$    A   H H$  謮  L$  L$  E33H$   ٧  A   Hܸ H$   o  L$  L$  E33H$  蜧  A   HW H$  2  HL$0HD$ L$  L$   H$  H1HT$0HtLD$@L+Ie  WD$0L|$@H$  q  H$   q  H$  q  D   L$  L$  E33H$  զ  A   Hط H$  k  HL$  HT$0HP(HHL$ph  HT$0HtLD$@L+I  WD$0L|$@H$  q  HD$p   J j   EE H H
X  L$  L$  E33H$    A   Hd H$  觬  L$  L$  E33H$   ԥ  A   H H$   j  L$  L$  E33H$  藥  HX H$    IcU HL$0$HD$ L$  L$   H$  H.HL$0SV  H$  o  H$   o  H$  o  EE H H
' $  IcU L$  HL$0l  H   HHal  HL$0U  H H$  p  HL$  HT$0HPHHL$Xl  HL$0U  H$  o  Mc] E3Lt$XIroHHHPML+Ȼ   H+MSIIN<    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sLKHKIHIM;r k   EE H H
ߴ fH H$  o  H H$   }o  HM H$  ho  IcU HL$0HD$ L$  L$   H$  H#HL$0HT  H$  m  H$   m  H$  m  EE H߳ H
  $  IcU L$  HL$0j  H   HHVj  HL$0S  Hٳ H$  n  HL$HHL$  HT$0PHHL$Xj  HL$0S  H$  
m  E3Mc] E3Ht$XIrjHHHPLL+A   L+MSIIN4    MfD  JD
HBJ
HJD
HBHJD
J9HR IuH\$PM;sHJHJIHIM;r `   D$H   LL$HM}  h   D$H    LL$HMn  o   H{(DH H
 HsxDHD H
  $  HcL$  H$   ?i  HcLHL$0>W  H   HHU  HL$0RU  H$   R  H$   H  p   Ht$ LL$   H$   H$  U HH H$  T  H\$PHC    HCHCHCw v   DHU H
 HcHHCM x   EE H H
k IcE HCHL$X4Q  HL$pYM  H$   H3I L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH Hh HH3H   H*HtNH  @4 L   HH  I+HHLI?LIc  H   H  H  H   Ht(L   L+Io  H   H   H   H   Ht(L   L+I;  H   H   H   H   y
 H   HtNH   q3 L   HH   I+HHLI?LI蔆  H   H   H   H   Ht(L   L+I蠙  H   H   H   HS`HtLCpL+Ir  H{`H{hH{pHSHHtLCXL+IM  H{HH{PH{XHS0HtLC@L+I(  H{0H{8H{@Hx HKHH\$0Ht$8H _:  @SVWATAUAVAWH  HǄ$  )$  H*4 H3H$p  LL$8MLHIHL$`,b  IHL$xJ   $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGH H$0  董  IH$0  IPH$H  HrTHH$0  H=   r<t&x
 HAH;rx
 H+Hsx
 H'vw
 H tiH
 H$   3H$   H$   Ht HD$8D$@H$   HL$8v
 Hu H$   H)
 H$    HǄ$     H$   Ƅ$   A   H H$  u  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+I脖  W$0  H$@  H$  HrTHH$  H=   r<tv
 HAH;rv
 H+Hs|v
 H'vov
 H莝 HǄ$     H$  Ƅ$   A   H H$  X  HǄ$h     H$`  Ƅ$P   A   H H$P  !  HǄ$     H$   Ƅ$   A   H H$    H$0  輴HD$ L$  L$P  H$  IH$0  Ht(L$@  L+I  W$0  H$@  H$  cd  H$P  Ud  H$  Gd  D$0HT$0HL$`_  HǄ$     H$  Ƅ$   A   H H$    IH$  IPH$  c  tiH|
 H$   3H$   H$   H HD$8D$@H$   HL$8r
 Hr H$   H
 H$   ͦ HǄ$     H$  Ƅ$   A   H H$  @  IL$  H$0  IPHHL$H_  H$0  Ht(L$@  L+Ix  W$0  H$@  H$  b  HǄ$     H$   Ƅ$   A   H^ H$  衞  HǄ$h     H$`  Ƅ$P   A   H H$P  j  HǄ$     H$  Ƅ$   A   H H$  3  H$0  HD$ L$  L$P  H$  I/H$0  Ht(L$@  L+I]  W$0  H$@  H$  a  H$P  a  H$  a  HD$H D$0HT$0HL$`\  HǄ$     H$  Ƅ$   A   HЧ H$  K  IH$  IPH$  a  tiHy
 H$   3H$   H$   H HD$8D$@H$   HL$8.p
 Ho H$   H8
 H$    HǄ$     H$  Ƅ$   A   H	 H$  脜  IL$  H$0  IPHHL$H=]  H$0  Ht(L$@  L+I輐  W$0  H$@  H$  `  HDFxHE H
~ HǄ$     H$   $  A   H H$  ̛  HǄ$h     H$`  Ƅ$P   A   H H$P  蕛  HǄ$     H$  Ƅ$   A   H H$  ^  HcVxH$0  LHD$ L$  L$P  H$  IVH$0  Ht(L$@  L+I脏  W$0  H$@  H$  ^  H$P  ^  H$  ^  Wt$0HcVxW$0  H$@  LD$0H$0  脒  L$0  9Vx~*ILD$H@      IH[HHI;Vx|;^x}HcIHL$`Y  HǄ$     H$  Ƅ$   A	   H\ H$    IH$  IPH$  ]  tiHv
 H$   3H$   H$   H HD$8D$@H$   HL$8l
 Hl H$   H
 H$   ͠ HǄ$     H$  Ƅ$   A	   H H$  @  IL$  H$  IPHHL$HY  H$  Ht(L$   L+Ix  W$  H$   H$  \  H$   H$(  E33H$    A   HX H$  蛘  H$`  H$h  E33H$P  ȑ  A	   H H$P  ^  H$  H$  E33H$  苑  A   H΢ H$  !  H$  HD$ L$  L$P  H$  IH$  Ht(L$   L+IK  W$  H$   H$  [  H$P  [  H$  ~[  HD$H D$0LD$0(HL$`
.  H$   H$(  E33H$  蚐  A   H H$  0  IH$  IPH$  Z  tiHs
 H$   3H$   H$  H HD$8D$@H$   HL$8j
 Hi H$   H
 H$    H$   H$(  E33H$  ͏  A   H H$  c  IL$  H$  IPHHL$HW  H$  Ht(L$   L+I蛊  W$  H$   H$  Y  HDF,H H
e H$`  H$h  E33H$P    A   Ha H$P  褕  H$  H$  E33H$  ю  A   H H$  g  H$   H$(  E33H$  蔎  A   Hן H$  *  HcV,H$  HD$ L$P  L$  H$  I"H$  Ht(L$   L+IP  W$  H$   H$  X  H$  X  H$P  X  t$0HcV,W$  H$   LD$0H$  S  L$  L|$H9V,~$Ifff     IH[HHI;V,|;^,}HcIHL$`bS  HT$`HL$8P  HT$xI19  MtL$   M+IIT  MtL$@  M+II7  H$@  HtH+HLjw  MtLD$XM+II   HL$`*  H$p  H3 ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xH# H3HEH3HI  HE   3Hu@uDFHX HMߒ  HCHMH;sTHHUH;wHH}H+H;CuVH譇  HH;HKHtcHA   HqHyrHHH;H;Cu
   Hj  HKHt'HA   HqHyrHHHU  
  HC HEHrPHHMH=   r<tf
 HAH;rf
 H+Hsf
 H'vf
 Hۍ HE   HuE A   H* HM赑  HCHMH;sVHHUH;wJH}H+H;Cu
   H聆  HH;HKHtcHA   HqHyrHHH;H;Cu
   H>  HKHt'HA   HqHyrHHHU  ޖ  HC HMT  HE   HuE A   H[ HMڐ  HUHI  HMT  HE   HuE A	   H HM蝐  HUHI  HMvT  HE   HuE A   H HM`  HUHI  HM9T  HE   HuE A   H HM#  HUHFI  HMS  HE   HuE A   Hg HM  HUH	I  HMS  HE   HuE A   H HM詏  HUHH  HMS  HE   HuE A   Ha HMl  HUHH  HMES  HMH3ك H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLH?  WEE3L}HMvK  HUH>  HMaK  HUH>  HMLK  Ic~xH} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
* _
 HQM+IIHHH+IMI;LCL;ICHM  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
 ^
 HQM+IIHHH+IMI;LCL;ICHMZ  HMHtH9HHMHUHz=  HMI  HUHe=  HMI  Ic~,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
 ^
 HQM+IIHHH+IMI;LCL;ICHMy  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
, ]
 HQM+IIHHH+IMI;LCL;ICHM  HMHtH9HHMHUH<  HMxH  Ic~(H} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
` \
 HQM+IIHH+II;LCL;ICHM+  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
 <\
 HQM+IIHH+II;LCL;ICHM譧  HMHtH9HHMHUH:  HM4G  Ic^(H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HMɀ  HMHtHHHMHUH9:  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM_  HMHEHt)HH H;Mu   HM5  HMHtHHHMHUH9  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HM  HMHtHHHMHUH9  HUHtLEL+IW}  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HE HXHpHx Hc H3H   EELHHL$ Z  HL$8N  E3LmH HL$0  HU(HL$ X  HILA  HE@HrQHHM(H=   r<t\
 HAH;r\
 H+Hs\
 H'v\
 H HL$8趒  LmH HL$01  HU(HL$ CX  HI@  HE@HrPHHM(H=   r<t:\
 HAH;r*\
 H+Hs\
 H'v
\
 H,    9sx   HL$8  LmH HL$0  HȲ.  Hȋ8Y
 HU(HL$ W  HI?  HE@Hr4HHM(H=   r uAHAH;s1H+Hr!H'wH菂 ;{x!gU[
 N[
 G[
 @[
 HL$8]  LmH HL$0ؿ  HU(HL$ V  HI^?  HM(J  9s,   f     HE@   Lm8E( HL$8  LmHM(I  Hb HL$0h  HȲ.~  HȋX
 HU(HL$ eV  HI>  HM(I  ;{,~E  9s(|   @ HE@   Lm8E( HL$8f  LmHM(II  H. HL$0ؾ  HȲ.  HȋW
 HU(HL$ U  HII>  HM(H  ;{(~9s(|yHE@   Lm8E( HL$8  LmHM(H  HJ HL$0X  HȲ.n  HȋW
 HU(HL$ UU  HI=  HM(H  ;{(~9s,|yHE@   Lm8E( HL$8f  LmHM(IH  H6 HL$0ؽ  HȲ.  HȋV
 HU(HL$ T  HII=  HM(G  ;{,~{,|zfHE@   Lm8E( HL$8  LmHM(G  H HL$0X  HȲ.n  HȋV
 HU(HL$ UT  HI<  HM(G  ;s,~HM_T  HMeV
 H   H3w L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx H H3H   LHHL$04U  HL$H  E3L}HK} HL$@a  HU0HL$0sS  HI;  HEHHrQHHM0H=   r<tjW
 HAH;rZW
 H+HsJW
 H'v=W
 H\~ HL$HQ  L}H| HL$@̻  HU0HL$0R  HIR;  HEHHrPHHM0H=   r<tV
 HAH;rV
 H+HsV
 H'vV
 H}    9_x       HL$H覌  L}H HL$@!  HȲ.7  HȋS
 HU0HL$0R  HI:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH#} ;_x!gU
 U
 U
 U
 HL$H  L}H. HL$@l  HU0HL$0~Q  HI9  HM0D  ,   @ ff     HEH   L}@E0 HL$H膋  L}HM0iD  H HL$@  HȲ.  HȋR
 HU0HL$0P  HIi9  HM0D  ;w,~     HMP  HMR
 H   H3t L$  I[ Is0I{8IA_A^]H\$WH H<t
  H{ HH\$0H _H\$Ht$WH H3H  Ht;H  $
 H  L   L+Iq  H  H  H   H  H*HtNH  
 L  HH  I+HHLI?LI6`  H  H  H  H  B  H  Ht(L  L+I6s  H  H  H  HKp   HKXHt)HS`6	 HSXLChL+Ip  H{XH{`H{hHK@Ht:HSHD HKPHH+K@HHLI?LHS@o_  H{@H{HH{PHS HtLC0L+Ir  H{ H{(H{0HSHtLCL+Ier  H{H{H{H\$0Ht$8H _H\$WH HHA  HOXA  LG8HT$0MHO8M )p  HO8y LG(HT$0MHO(M p  HO(_y HOH\$8H _<A  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hsl  HH_8H\$HH3HsT  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"   H  Hw HH [H\$Ht$WH H3H0  Ht;H8   H0  L@  L+Ijm  H0  H8  H@  H  Ht(L   L+I^  H  H  H   H  Ht(L  L+IRo  H  H   H  H  H*HtNH  ; L  HH  I+HHLI?LI[  H  H  H  H  Ht;H   H  L  L+IWl  H  H  H  H  HtNH   L  HH  I+HHLI?LI
[  H  H  H  H  Ht;H  P H  L  L+Ik  H  H  H  HKpHH\$0Ht$8H _HT$SH0HD$(H3D$ HHBHBD$    H  H  L  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H2  HH0[@SH0HD$     H  H2  HH0[H   HD$0LH0  L  HQpHD$ I  tWHT
 HD$P3HD$XHD$`H HD$@D$HHT$XHL$@ K
 HJ HD$PH-
 HL$P	 3HĈ   @USVWATAVAWH$ H  HEH_ H3H   EIHHHUH]E3Dd$4IHL$PS5  Lt$XL+t$PIL;vx   HMaI  H^xHE HM蜰  HI@I
 HH 聰  HH%I
 HH f  H   HMvG  HxrH H
S
 HL$h3HL$pHL$xHEEHT$pHMI
 HP HD$hHa
 HL$h} Dd$0H   H+   HWD$8Ld$HLD$0HL$8*  L'LgLgD$4   HNpLLD$8HT$PEt;    HT$8HtLD$HL+IY  WD$8Ld$HHT$PHtLD$`L+I?j  HHtLCL+I&j  L#LcLcHH   H3j H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH) H3H   EEHHHUHL$H+3  Ht$PH+t$HHH;wx   HM9G  H_xH HMt  HHG
 HH Y  HHF
 HH׀ >  H   HMNE  HxrH H
dQ
 HL$h3HL$pHL$xHEEHT$pHMG
 HN HD$hH9
 HL$h{ 3t$`H   H+   HWD$0Ht$@LD$`HL$0  EuLHOpLD$0HT$HEt2  (HT$0H   LD$@L+IW  WL$0| WD$hHt$xHOpLL$hLD$0HT$HEt  
  (HT$hHtLD$xL+Ig  HT$0HtLD$@L+I#W  WD$0Ht$@HT$HHtLD$XL+Ig  HHtLCL+Ig  H3HsHs(H   H3g H$   ($  H  A_A^_^]@SVWH  HD$pH H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   D  HxH^H+HHz~ H$   ͫ  HHqD
 HHO~ 貫  HHVD
 HH0~ 藫  H$  H$   B  HxrH H
N
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`E
 HK HD$HH
 HL$Hx H   H+   HHL$H  HOpD$0D$(H\$ L HT$HHtLD$XL+IU  HH$  H3e Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E32HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK2WD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`HT$8HtLD$HL+IS  HL$`裌HL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xH~HHMp衣3D
 L   A   AA+iA+AD̉    AA+iD+EDD  H   HUpH  Q 3DL  L  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;r  H  H  (  H  H  4Q  H  H;H{H{H  H  H     (  H0  H8  H@  H|$ (     f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   H&d  HKHHt(HHH;Cu
   Hc  HCHtH8HCHH|$ (  H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hc  HHKHt,HH#H;Cu
   Hic  HCHtH HCH  H   L0  H  H    HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H/
 H3HEHLHUHMm&  H]HLuI9 E3H;  HE   LeDeED$H}f HMk  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
ix <
 HSM+IIHL+IIM;HCH;HCHM豔  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
w <
 HSM+IIHL+IIM;HCH;HCHM  H]Ht*HC   LcH{rHHHU  H>p  H H]HEHrPHHMH=   r<t?
 HAH;r
?
 H+Hs>
 H'v>
 Hf HUIE  M0  I  I  f  H]Ht HUH LEL+IH[  HHt'HV[ HLFL+I[  L&LfLfHMH3^ L\$pI[@IsHIA_A^A\_]H\$L$WH0f.
H IH)t$ z	uA0LL$H \D$Hߢ	 (HCHL$Ht$HH;sEHHT$HH;w8H|$HH+HH;Cu
   Hf_  HSHt
HHH
HB$H;Cu
   H:_  HCHt0H(t$ HCH\$@H0_H\$WH HQ3HHtLA(L+I(L  H{H{ H{(HHtLCL+I\  H;H{H{H\$0H _Hy0HArH @SH H+ HHH+  HD
 HKHH [H%;
 H\$ WHpH
 H3HD$`3HHAIHAH + HHL$@胰  HHL$ Ls  HHOLs   HD$8HrQHL$ HH=   r<t<
 HAH;r<
 H+Hs;
 H'v;
 Hc HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t;
 HAH;r;
 H+Hs;
 H'vr;
 Hb HHL$`H3[ H$   Hp_@SH H: HHHD*  H%C
 HKHH [H%9
 H\$ WHpH
 H3HD$`3HHAIH\ HAH9 HHL$@  HHL$ Lܫ  HHOLFr Y  HD$8HrQHL$ HH=   r<t{:
 HAH;rk:
 H+Hs[:
 H'vN:
 Hma HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t:
 HAH;r9
 H+Hs9
 H'v9
 H` HHL$`H3zY H$   Hp_@SH H8 HHH(  HA
 HKHH [H%Z8
 H\$ WHpHg
 H3HD$`3HHAIH[ HAHA8 HHL$@L  HHL$ L<  HHOLp 蹭  HD$8HrQHL$ HH=   r<t8
 HAH;r8
 H+Hs8
 H'v8
 H_ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<th8
 HAH;rX8
 H+HsH8
 H'v;8
 HZ_ HHL$`H3W H$   Hp_@SH H@
 HHH'  H?
 HKHH [H%6
 H\$ WHpH
 H3HD$`3HHAIHY HAH1@
 HHL$@謫  HHL$ L蜨  HHOLo   HD$8HrQHL$ HH=   r<t;7
 HAH;r+7
 H+Hs7
 H'v7
 H-^ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t6
 HAH;r6
 H+Hs6
 H'v6
 H] HHL$`H3:V H$   Hp_@SH H. HHHd%  HE>
 HKHH [H%5
 H\$ WHpH'
 H3HD$`3HHAIHW HAHy. HHL$@  HHL$ L  HHOLfm y  HD$8HrQHL$ HH=   r<t5
 HAH;r5
 H+Hs{5
 H'vn5
 H\ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t(5
 HAH;r5
 H+Hs5
 H'v4
 H\ HHL$`H3T H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuH6?  HKHL$@HHHHL$HHt胶 *H;KuH?  HKHL$@HL$HHt	HW HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LHr  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH>  HwHtlHHHF   HF     HHHd  C F ;H;OuH>  H_Ht$HC   HHC    H c  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	F HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf	 HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI LGHVHH pMt/HWIU HOH+IHHLI?LH=  HNH+IHHHH?HH>  tLHVH܋ HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LH,=  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   H3=  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   H<  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H-
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+Q-
 H[HI~H+LH7-
 Ht$0H;H|$8IFIH\$@H A^HtH=  HSIH+H>  t!HH[I>H+LH,
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I=  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
e *
 HH|$0Xr  HHFHHHNI~IHH+LH+
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
e r)
 q  HH    HGLH3HHOHV_ H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXH\4
 D$(HD$0HT$83HL$ HD$8HD$@H\ HD$ *
 HC H
 HD$0HL$0^ H4
 D$(HD$0HT$83HL$ HD$8HD$@HM HD$ K*
 Ht H]
 HD$0HL$04^ HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`HD3
 D$(HD$0HT$83HL$ HD$8HD$@H[ HD$ )
 H+ Hԯ
 HD$0HL$0s] H\$WH HHH;Qt>H	)
 HtH HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH HHHtLAL+II  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
b b&
 o  HL    HCHHIHKH LCHH\$0H _@SH L
 HL II+HH;sH+IH H [H;   L H+II+HH;s\IIH+H;sH
Ha %
 HM+I3IHL+IM;HCH;HCFo  L
 L ILI+3HIL+IZ[ H
 HH+ٶ HH+HH϶ H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
I` $
 HM+I3IHL+IM;HCH;HCH4o  HOLH3H+HL+IeZ HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH:  HSHt7HHH
HCH\$0H _H;CuHy:  HKHtHHHCH\$0H _@SH HH	Ht@HS6 LCH*L+IHLI?LH\3  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LH2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
] ""
 HIh  HHCHHHHKLHVH蔀 HCHH\$XHt$`H@_@SH 3HHHAHAe9  HH [H\$WH 3HHHHAHAHtNH
H;vH
] b!
 g  HHHCHHL    IHKH4 LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   H!9  HKHL$@HHHHL$HHtn
  /H;Ku
   H8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR蕂  HH@HH HH@HC    DD$@HHH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+IVA  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@Hx| LHD$ HT$@HLH / HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHRu  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+IW?  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I?  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HJ  VH;Cu
   H>  HKHL$@HL$HHt03HA   HAHyrHH  IE3HJ  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
U 
 HM+I3IHL+IM;HCH;HCHq  HOHHH+HH+ HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LI9  HSHm HGH+HH   HCH+HL;w'HILHI  LCHWHE~ LHtI HLCL+I9  HWH+HH<  tLHWH} HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+I9  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H;  HKHt@HH;H;Cu
   Ht;  HKHtHA   HHA      L  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I08  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
?R 
 Hd  HHCHH;H{LHVH{ HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH:  HSHt3H
HCH\$0H _H;CuH:  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+I(  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   HU:  HSHt<HHH
HCH\$0H _H;Cu
   H:  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H#
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+
 H[HI~H+LH
 Ht$0H;H|$8IFIH\$@H A^HtH6  HSIH+HN9  t!HH[I>H+LHY
 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
|N 
 HH|$0\  HHFHHHNI~IHH+LH
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
M 2
 |[  HH    HGLH3HHOHH H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   H7  HSHt
HHH
HBHCH\$0H _H;Cu
   H6  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
yL 
 HM+I3IHL+IM;HCH;HCHD\  HOLH3H+HL+IF HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+Il3  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH 3HHHAHAu6  HH [@SH0HE3HQ(DD$ HC   LCDD8tI IB< uH.>  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH=  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	v	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ =  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
rI 
 H;sLHH`g  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<t
 HAH;r
 H+Hs
 H'v
 H7 HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t
 HAH;r
 H+Hs
 H'v
 H7 HC   HC    H{rHH  HH@  HH\$@H0_@SH E3HA   LAHDD8tIIB< u:  HH [@SH HA   IHA    E3 H;  HH [H\$WH HH  HH?
 tHCh    H\$0H _HH{hH\$0H _H%

 @SH H    Ht'  tH   
 y	H [3H [@SH HMH   Ht9HuMuEAE3
 uH   D@HhB  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|?  tsH   HT$0
 u]HtH   D@H
 u@H   HT$0
 u*IFHHGt
?  HOtHD$0HCH    HKH1

 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb>  tYHutH   DH
 u8H   HT$0
 u"H!>  HKtHD$0HGH    HOHH	
 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH/
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   
 tl  d  HE/   E3Lu'DuH   
   HU'HHH  HZH  LM/L;sLHHM8a  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOh
    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+3Z3  HUH}/r'HHu#E	

     	
 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   	
 H~LEHU]#H
A 
 H
A 
 HUHE/HrPHH=   r=EtJ	
 HBH;r:	
 H+Hs*	
 H'v	
 HH90 HM7H3( L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@5
 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp H
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   
 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKhV
       HELELM/IICH}H+t.HMIICL   LǺ   /
 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHM-3  3u#MH   
 ;ELM/LELM/LEIrQIAH=   r=EtK
 I@I;r;
 L+Is+
 I'v
 LI:, HM7H3$ L$   I[0Is8IA^_]H   HtH%
 H   HtH%
 @SH0HD$ HH
 HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H9  HH0[H%E
 @SH0HD$     HV;  HH0[H\$WH HhHHcPH H
hHhHcPH
 DhD
dHAH9  HO
 HOH\$0H _H% 
 DL$ HL$SVWH0HD$ HHD$h    H HHo HAH   
 D$h   H^E3HHJ
 HHcHH H1HHcHhT1H\$XH	 H
 HLGHrH?HCh    Cp    MtHHP^  HH0_^[DD$HL$WH0HD$ H\$HHD$P    H HH HAH    
 D$P   E3HWHm 
 HHcPH  H:HHcPDhDD:   HOI;  HH\$HH0_@SH0HD$     H9  HH0[H\$WH HxHHcPH
 H
xHxHcPHW
 DxD
tHAH7  HOi	 HOH\$0H _H%	 DD$HL$WH0HD$ H\$HHD$P    H9 HH   Q	 D$P   E3E3HWH	 HHcPH
 H:HHcPDxDD:   HO9  HH\$HH0_@SMPHMLLA@I Ht
H9AhsHAhH<	 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   H
	 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjHV	 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
H	 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIH`	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI=5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH H
 HHHI	 HO 	 HO(	 H	 t
0   H! HH\$0H _H\$WH Ht
   H! HH\$0H _H\$Ht$WH H'H.	 @t   Hh/! Ht$8HhH\$0H _H\$Ht$WH HH	 @t   Hx  Ht$8HxH\$0H _H\$WH H_
 HH/  H	 t
x   H  HH\$0H _H8HD$ HHHcHHLHHt+HHPH1H;uH   Ht	 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLH  H\$ HSH HHCI  H$   HVHM HHFI  HHGWD$8HD$H    I  Hl$(HT$8H  ILl$8I;^F  M  @ HI5  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtHd i\	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  HV  HGH+HA(  MtwHD$HI+HH?H;v	 H    H=   r=At	 IEI;ry	 L+Isi	 I'v\	 LIx HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
, $	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
+ T	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [H(H
L;v	 K@HH=   r<tc	 HBH;rS	 H+HsC	 H'v6	 HHH(N @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
* 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _n5  H _H\$WH 3HHHHAHAHt:H
H;vH
* r	 4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
h) 	 H3  HHCHHHHKLHVHK HCHH\$XHt$`H@_H(H?L;v	 J    H=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(LQLLAII+HH;s_H	I?L+III+H;sH
L( 	 L+II3IHL+IM;HCH;HCIH(C5  H(H\$WH 3HHHHAHAHt6H?H;vH
' "	 l4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHH
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
' b	 IHO uM  H    HHWHL$(HHO E7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wH HH;_s%[	 T	 M	 F	 ?	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;v	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
<% 	 L+II3IHL+IM;HCH;HCIH(#4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
$ 	 L+HI3IHL+IM;HCH;HCIH(q4  H(@SH0WHx        fx I1  LHmx HHkx HHH
hx H谤 HIH
Mx H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
# 	 ".  HHCHL4    HIHKHMHH I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
" &	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _4  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uH&  AE3'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AD  3ҋm%  AD$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH`   AE3S!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEu   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ=  AD`  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v	 II   r<tv	 HBH;rf	 H+HsV	 H'vI	 HHH(a	 LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRB  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRWC  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@HS0  LD$PL;D$XuLHH\$HH0_H(HL;v?	 J    H=   r<t#	 HBH;r	 H+Hs	 H'v	 HHH( H(LQLLAII+HH;s_H	IL+III+H;sH
 	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
 r	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
 	 L+HI3IHL+IM;HCH;HCIH(#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
 f	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
 	 ,#  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH讕 HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
 
	 T"  HLHCHHHHKLIa MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHAH;uH   Ht
	 ҐH8@SH0HD$ H	 u
H	 HHHcHHLHHt+HHPL
 I;uH   Ht	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtH@	 HCHH=   r=@t=	 HGH;r-	 H+Hs	 H'v	 HH, HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALH	 HHt8Ht!LIH>	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1It[>	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHH=	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ :0  H\$hH0A_A\^HKI;sH
 %	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
K 	 L+H|$XH;s;HCHrHHHrHHMtHMJ HHL	 LCIH+HHu	H   HvH
 	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HH	 H{rHHHtJ LI;	 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH
 m	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JL	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH

 4	 HvH

  	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L H{H{rHH8 Ht$8HH\$0H _̀: uE3   IIB< u    H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH
t 	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLH8	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
 9	 I+H;HGH;u9I8H9AsH
 	 HAHyrH	 3He   HvH
; }	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6Lw7	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH
h
 	 H|$0I<H   HvH
B
 	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
	 M	 H|$0I<0H   HvH
 '	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLH)5	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
' 	 LAH+H;HGIHH;wH
 2	 H|$0I<0H   HvH
 	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.L4	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBItQ	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpH3
 H3HEHHyh   yq   du2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H
 	 H
t 	 ̳IrNIAH=   r=Et-	 HAH;r	 H+Hs
	 H'v 	 H HMH3 L\$pI[(Is0IA^_]@SVWH AAq HHA|	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXHBX HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHDQ	 HEHC| Cq 	 H
W HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   I	 HtyA   HHHT$(H(	 HG  HH{	 t
HCh    H{hH 	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t	 HAH;ru	 H+Hse	 H'vX	 Hw HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPH
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r	 H+Hs	 H'   	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(|   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t
	 HAH;r	 H+Hs	 H'v	 H HHL$HH3| H\$pHP_@WH0HD$ H\$HHq	 Hi
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;w	  HH'HHAHH(H HH(H(I   r<t	 HBH;r	 H+Hs	 H'v	 HHH( Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;v	 KHH=   r<t	 HBH;r	 H+Hs	 H'vv	 HHH( H(H88L;v?	 KHH=   r<t#	 HBH;r	 H+Hs	 H'v	 HHH( H(Hu	3ɋH(H88H;vq	 HHH   r,HA'H;wP	 H HH'HHAHH(~ HH(H\$Hl$Ht$H|$ AVH0LH[HSLHHy" HH988LKHML+IHHLI?IHt+I~u HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;v	 HHH   r&HA'H;w	 H; HX'HHC( HHVLHHl$@Lt$H" HHgfffffffLNHML+ILIMI?MHt+Iu HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;v	 HRHH   r,HA'H;w	 H' HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH)" HH*LKHML+IHHLI?IHt+I>p HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt莍/H;Ku
   HhHKHL$@HL$HHt	H]HCH\$PH0_H(Hu	3ɋH(H?H;v	 H    H   r,HA'H;w	 H HH'HHAHH( HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;v	 H    H   r,HA'H;w	 H HH'HHAHH( HH(H\$WH HHu3UHH;v]	 H    H   r&HA'H;w<	 H HX'HHCp HH^G HL\G L+Ht$0	 H?G H5@G H+HHtL5G L+IHHG HG HHt$0H\$8HF H _H\$Ht$WH HHHu3UHH;ve	 H    H   r&HA'H;wD	 H HX'HHCx HHHLGL+Hl$0	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+3	 HH{H+HHtLCL+IHHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;v	 HRHH   r&HA'H;wԲ	 H HX'HHC HHVLHHl$@Lt$HT HH*LNHML+ILIMI?MHt+In HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;v	 HH   r)HJ'H;wı	  HH'HHAHH(H HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;vW	 H    H=   r<t;	 HAH;r+	 H+Hs	 H'v	 H- HoXHo`HohHO@Ht~HGPH?H+HH;vа	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H Ho@HoHHoPHO 聟H HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;v	 H    H=   r<t	 HAH;r{	 H+Hsk	 H'v^	 H} HoXHo`HohHO@HttHGPH+HI;v*	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H  Ho@HoHHoPHO ۚH HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHH HHWHH+Hta HLGL+IuHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
 
	 THLHCHHHHKLId MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPL1
 I;uH   Ht
	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;w	 HM Hp'HHF: HH\$`Lt$pH|$hHt$xMtH{rHHMtMH
	 HCHrOHHH=   r<tʨ	 HAH;r	 H+Hs	 H'v	 H HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH
R
 	 IALd$XLd$pI;sH
1
 ä	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH
 	 Ll$`L+L,9M;sBIvH
 	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HHZ	 H~rH6H{rHHH6  J&LJ0|	 !  H;suHCHrHHHrHHHtJ!LJ0	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HHh	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0z	 HCHrHHHrHHMtJ1MJ0HH>	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   Iv	 H|$0H   r#IH'H;wȠ	  Hx'HHGH HLHH	 CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH
 4	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHH HH*LKHML+IHHLI?IHt+IZ HKHH+HHLI?LHKHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  Ha 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH e  HxH\$0Hl$8Ht$@H _	 	 	  	 	 	 	 	 ݝ	 ֝	 ϝ	 ȝ	 	 	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H1 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   HX 3HC   H{HSrHH 5  HxH\$0Hl$8Ht$@H _	 ޛ	 כ	 Л	 ɛ	 	 	 	 	 	 	 	 	 	 H(p   芾 HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL-֍
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t{	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1HP	 tVHڅuVHHcHMIHL1HZ	 I;u0D  H~/HHcHT1XHL1H	 u
Hջ   \$xHHcHHD1(    L-Ì
 Ht$p\$xLd$(HHcHHE3	 I	 u
Id	 I$HcHJL!HHt#HHPI;uH   HtK	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1H@	 ADމ$   HHHcHAHL1H	 ADމ$   u(H~#HHcHT1XHL1H	 ADHL%Ċ
 Ht$p$   L|$(HHcHHD1(    HHcHHE3	 7	 u
IR	 IHcHJL9HHt#HHPI;uH   Ht:	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t`	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1H4	 u   \$x7Hυu.I~rM6HHcHMIHL1H)	 I;t   +Ht*HHcHT1XHL1Hё	 uHՉ\$xHHcHHD1(    L-
 Ht$p\$xL|$(HHcHHE3z	 	 u
I6	 IHcHJL9HHt#HHPI;uH   Ht	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHH	 H	 H	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHH
 %H H;uIVHNH;HHQÑ	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HM*	 HH
 sHH[H;uIFHMH	 HH	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PHPN
 H3HEpMMHHH   D$     HG
 HD$`HM`	 D$    E3E3HT$hHL$`)	 HD$`HcHH
 HD`HD$`HcHDxDD\   HL$hHHL$`YHH
 JHH?HHź
 0HI%HAُ	 HHHUPHL$``HxrH H
6	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 H
 HD$(HH
 HL$(l @SUVWHh  HD$8HL
 H3H$P  IHHDD$0$  D;   HL$@aHm
 HL$@?HH4HHJ
 %Hȋڎ	 HH
 H$0  HL$@YH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3豰 Hh  _^][H\$WH 	HHf/v\XH\$0H _\(~XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3,	 Hj  HLsHsHuH{H|$hL?LHt3	 Hj  HHwHuH~H   H{(H|$hL?LHt3	 Hj  HHwC< HHҙ  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H	K	 t
Hj  HH    Hk~LFHHI H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3臾HC   HHC    H 艿HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHsH;uH   Ht$	 Ґ3H	 D$0t/HHcHHLHJ	 u   |$`	H\$P|$`HHcHHE3؉	 HHcHHLHHt*HHPHH;uH   Ht	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$h@ uB3HD$8H>
 HD$0Hj
 HD$(H
 HD$@H
 HD$HHL$(P HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHH$x  ? t
HHÀ< uLHHIE3HH2HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLH}  HC   HHC    H ۼHH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
w  IE3HHGA
   H

 HHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHI蕹HC   HHC    H HH0[@WH   HD$ H$  AHHH$   P  HX(H
4
 HH0x8HH$   MN HHL$(_N H
 HL$( @SH   HD$PHOE
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$( ȋD$ -ut=   w2t=w2ɄuB3HD$8H
 HD$0H
 HD$(H.
 HD$@HZ
 HD$HHL$(L HL$pH3 HĀ   [@SH   H8D
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`rP u-HT$PHL$Xo t9C,+<:wH     HrD$PH$   H3K HĐ   [荗  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(  HL$UVWAVAWH   HD$8H$   IcIcHL3l$0HBH+HDDHD$   HLHI/IoIoMtBHt4HHHL;t̅tHHHL;tIHt3Z	 H*b  IMwIH\$PLt$`IHL$@Lt$HHD$@HD$hHD$PHD$pH$   HD$xL$   IHHH+HHH~%     )HH;}H\$PHL$@LHHL$h IH$   HĐ   A_A^_^]HT$HL$SH   HD$0I譖  DKH{uH f/( wgD HHL$89  HT$PH{|  HL$8'	 $       $      HL$`H$   LT$XL$   H$   H$   I;HMHE3L\$PW3H~N   If/sQHIH;|II|LH
 H
;
 j  H$   w	 HL$pl	 HL$Pa	 rC HĠ   [@SVWH`  HD$8H@
 H3H$P  IHLD$0Hc$  L;   HL$@褃H
 HL$@HHwHH
 hHȋ	 HH[
 NH$0  HL$@蜂H$0  H$H  HC$0  HD$ LD$0H
 H舙  H$P  H3 H`  _^[HUWATAVAWHl$H  HD$8HXHpH	?
 H3HEpML3ۉ\$0A   MPM;  EWD  HE~2MNfHcI;}$IIIHf.z uHI;|AIIcI;U  H	
 HD$PH
 HD$`HM	 D$0   E3HT$hHL$Pr	 HD$PHcHH
 HDPHD$PHcHhTLHD$hHD$@HL$h~	 H|
 HD$hH]Љ]H
 HL$`HH
 HH>
 qHH3
 bHȍV	 HHܺ
 GHAW	 HHD
 +HUPHL$P=~LMPH}hLCMPMMcMFHcLOHP
 HD$ H
 IN< HMpH3ѡ L$  I[8Is@IA_A^A\_]@SUVWHh  HD$8H<
 H3H$P  IHHDD$0H$  D;   HL$@pH|
 HL$@NHHCHHY
 4HH}	 HH&
 H$0  HL$@gH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3迠 Hh  _^][H\$WH HIH5	 HHHH	 zH/~	 HHH\$0H _H%~	 H\$WH HIH]	 4HH)HH#	 H}	 HHSH\$0H _H%}	 @SH H/	 IHH
 HH	 Hr}	 HHH [H%d}	 H\$WH HIH
	 tHHiHH˝	 ZH|	 HHH\$0H _H%|	 @SH H	 IHHA
 HHָ	 H|	 HH6H [H%|	 @SH H	 IHH
 HH^	 H8|	 HHH [H%B|	 @SH H	 I[HH
 LHH	 =H{	 HHvH [H%{	 @SH H	 IHHY
 HH&	 Hx{	 HHH [H%{	 HHHD$0D$    L
,
 L
 3 2HHHHHD$0D$    L

 LM
 3F 2HHHHHD$0D$    L

 L

 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L
<
 L
 3 2HHHHHD$0D$    L

 LM
 3F 2HHHHHD$0D$    L
4
 L

 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L
$
 LM
 3F 2HHHHHD$0D$    L

 L

 3 2HHHHHD$0D$    L
̶
 L
 3 2HHHHHD$0D$    L

 L
 3 2HH{^  \  H\$H|$L	LLAH*M+HIE3HHHH?HtfE3K3KDH+HHt%f     IHHKDK+HH;rHKHH+IHIHHH?HL;rH\$H|$@SVWATAUAVAWH  HǄ$   H4
 H3H$   IL$   L$   H$   HL$hL$p  E3Dt$DD$@   EH	 H
"	 EE H*	 H
;	 zIcU H$  9cHcWD$pL$   LHL$p7H$  Ht(L$  L+I襘W$  L$  MHL$xLd$pI+I*IHHHHH?HH      tGIԐILHBI+HHt!ff     IHHBH+HH;rIHL;rMHtHIfILHBI+HHt!ff     IHHBH+HH;rIHL;rD$@   EE H	 H
	 IcU HL$PaILD$XIHT$PH+HHt#LIHLD$XIHT$PH+HH;rIL+IMtHHHD$XH+D$PHH;rD$@	   Dt$HEM DHT$HH$  谖  HHHH+IHHHH?HHT$0L=
 L|$(LL
 H
(
 p  IH;sH[HHI迗  HH$  e  D$@
   Dt$HEE HT$HH$    HH@H+HLL$XL+L$PIHD$0L|$(L
 H
 ap  IHD$XHL$PH+HHt4LLffAn AHM@HD$XHL$PH+HH;rH$  HtL$  L+IHL$PA   EH*L0	 I      ?H$   D;8  D$@   E;u ,  IcH$   L HxI+H  G;  IcH$   HHxH+H  G;|  3DfA/D  D$@   H|$XH+H|!G;}LLD$@   AHL$PHHy
 H$   H:v
 H$   H$H  Ls	 D$D   E3H$   H$   
s	 H$   HcHHs
 H   H$   HcHh   H$   HD$hH$   Zp	 HRn
 H$   3H$0  $8  H
 H$      Hq	 H$  H$   pL$  H$  LC$  H	 HD$ DËqHx
 H$  Hu
 H$  H$H  $r	 D$D   E3H$  H$  q	 H$  HcHH^r
 H  H$  HcHh  H$  HD$hH$  2o	 H*m
 H$  3H$0  $8  Hҗ
 H$     Hp	 H$  H$  nL$  H$  LC$  H	 HD$ DƋIHaw
 H$  Hs
 H$  H$H  p	 D$D   E3H$  H$  p	 H$  HcHH6q
 H  H$  HcHh  H$  HD$hH$  
n	 Hl
 H$  HǄ$0      Ǆ$8      H
 H$     Hao	 H$  H$  mL$  H$  LC$  Hb	 HD$ DËD$@   IcHL$xI+H*HHHLI?LLT$(D$    DH[HD$XH+D$PHMLM+LIHD$0H= 
 H|$(L$
 H
-
 j  3ITIDH+HHt&LD$P IHHIDI+DHH;rAHL$PD$@   HT$pH|$hH軒  HT$PHt#LD$`L+I?WD$PHD$`    H\$pHt4HT$xH) H$   H+HHHLI?LH|HH$   H3 H  A_A^A]A\_^[Hl$Ht$H|$ AVH0LHT$ LH  LGH*L+HI3HHH?HtLH\$@     IHHH  HOHH+HHHHHH?HH;rH\$@Hl$HHt$PH|$XH0A^HWATAUAVAWHPH@HXHhHpMLHIPI$ I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8w  Hl$@LH\$8LIT$Ie  HtZHHy$ HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HHz HII HFH+HH;s(:,n	 %n	 n	 n	 n	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@H(
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`Hiu	 H  3H  H  HC	 HEpExH  HMpk	 Hkk
 H  H H  菟 Hm
 HE@Hi	 HEHHEPHEXHi	 HE`HEhHt
 HEH   Y  H  Y  H  j
   ~y   A   ~x DEHVXHzrHH   ҡE3HH   HcHH   uHAPch	 H3Nh	 F|uHc	 H   Hd	 auHR	 H   Hk	 @uHi	 H   Hr	 u2H`	 H   Hq	 HqHH)i	 H   U H   H膨      H   HzrHA   H  趠E3HH  HcHH  uHAPGg	 H32g	 F|uHG	 H  H	 auH6	 H  H	 @uHM	 H  H	 u2HD	 H  dH	 HUHH
h	 H  9 H  HjHǅ     E3L  D   EFH	 H   gHd
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  GH  HrSHH   H=   r<ti	 HAH;ri	 H+Hsi	 H'vi	 H趐 L   HNHYHyrH	HA   I;LBMtH	  u1Hu+KlR H   LF8HV(HCHH      % HHf
 HH   WELuAEHUIZHi
 HEWELuAN   D.DvDu~HH
]
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHI  DGHUHMHD$ IH  F  HOH*TH  Ht)L  L+I談W  Hǅ      HUHtLEL+I|Hh
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHIԐ  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHI  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHI{  DHUH   XHM1HQH}LL+d	 HH}H}8HO HUbMw8HUHtLEL+IH  HtL  L+IH}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMFHǅ     Hǅ      ƅ   A   H½	 H  蒏LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H    LH  SH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHI芶  D    PHMmEA
   H	 LuI蔎IN A   H	 ~IN@A   H	 hIN`A   H	 RI   A   H	 9Hǅ     Hǅ      ƅ   A   HC	 H  LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   ` LH  Q    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI%  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIy  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI蒺  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E?  Dq  d  PHM?A
   H	 LuIIN A
   H	 IN@A   H	 ͈Hǅ     Hǅ      ƅp   A   H	 Hp  藈LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H    LHp  L          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIW  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ 1  D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ o  DLupEWA(WEHE    DEHUH+UHLEHM_B  HMH+M HLM L+MILɋ   ~gfn
 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@?  G HOpH/7  H   HM?HD$ IH  蚀  HOH~CH  Ht)L  L+IvW  Hǅ      H   HtL0  L+IvH  HU>  H   H  RHǅ     Hǅ      ƅ   A   E3H	 H   {HEHtTA   LH	 H   {LEI+LH  H   DHH  FH  wED   D   A   E3Hm	 H   Y{H  HHEL@A   HN	 H   *{HLLEH  H   DHH  ]RH  DH   H  Q	 A   LHȱ	 H   zHL@A   H	 H   zLLGH   H   CHH  FH   YDH   H  mQ	 Hx  (QHx  +S	 H}8H  H  H;tIE3H  AIP  HW  Hǅ      MX  H  轗 HU H W   Hǅ0      LEH   N LM LEH(  H   K  H  H  <  H  H   ,7HOXHUp7MtI   IH   Ht&H(  H	 L0  L+IHKqH  Ht=H  H H  H+H*HHLI?LH`H  BH   BHUHtLEL+IsH}Ht HU H8	 LE(L+IHpH} HtHUH	 LEL+IH|pH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H	 Hp  }H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H    HHEpHp  )AH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    u   I  DW   E3L0  L   H   H   W H(  H   H+I*IHHHH?HHH  ;EL  L  M+IMt ff     HHKIHM;rH}8H  H   8  H  HU3H  H  8HOpH0  HU HM'HD$ IHMy  HOHi<HUHtLEL+IoWELuHU HtLEL+IoHMpHtH   H  HtL  L+IoH   Ht:H(  H H0  H+IHHLI?LH\E3H}HtH   HHUHtLEL+I!oWELuH5FD
 HuH]HtHH& LEL+IHlHI
 H@  HP  8>H@  Hx  KHx  M	 H  .  H   -  AH  H3n L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHH+$3fD  H;_s^I4H
 HHH
 H;
 r
   HH$   Ht
(貴HHHD$8HHMLD$8H$   H  H$   pH      ?HHH=b
 H
{
 H9
l
 t	H>
 $HH+2
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HIf8HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;vL	 H    H=   r<tL	 HAH;rL	 H+HsL	 H'vL	 Hs m (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH!3fD  H;_s^I4H{
 HHHm
 H;^
 r
   ʪHH$   Ht
(bHHHD$8HHMLD$8H$   H  H$   pH      ?HHH=
 H
+
 H9

 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI6HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;vJ	 H    H=   r<tqJ	 HAH;raJ	 H+HsQJ	 H'vDJ	 Hcq  (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
 	F	 HL$8:  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   @HHL$@LD$8H$   Ht(H˯HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$89  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8-9  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH

 D	 H

 D	 MLD$8H$   I  H pi HL$8Ht{HD$HH+HH;v_G	 H    H=   r<tCG	 HAH;r3G	 H+Hs#G	 H'vG	 H5n WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
~
 B	 HL$87  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   HHL$@LD$8H$   Ht(H蛬HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8{6  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$85  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
|
 @	 H
|
 @	 MLD$8H$   I  H p9 HL$8Ht{HD$HH+HH;v/D	 H    H=   r<tD	 HAH;rD	 H+HsC	 H'vC	 Hk WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH L@HPHHSVWATAUAVAWH  Hǀh)p)xD)@D)HMH3H$   Hf.IU IEH+HHuZH3K	 HD$`3HD$hHD$pH{~
 HD$xƄ$   HT$hHL$xvA	 H7A
 HD$`H~
 HL$`i DD$  IEH+HHwZHJ	 HD$`3HD$hHD$pH~
 HD$xƄ$   HT$hHL$x@	 H@
 HD$`H}
 HL$` A   DJD$  W$   E3EL$   HFxHD$xLcL$   EL$   M_  IH$   @ IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   H$  H+HI;   IH+HH   H+HIH+H9  HL+IIHIH+IMI;LCL;ICH$   /L$   H$   IH$   L$   L$   H   HH   I;   IH+HHsxH+HIH+H   HL+IIHIH+IMI;LCL;ICH$   聈L$   H$   IL$   L$   Ht2HH$   IL$   M;s{-H
&x
 <	 H
x
 r<	 HH	 HD$`3HD$hHD$pHJ{
 HD$xƄ$   HT$hHL$xE>	 H>
 HD$`Hz
 HL$`8 IEI+E HL;rZHG	 HD$`3HD$hHD$pHz
 HD$xƄ$   HT$hHL$x=	 H=
 HD$`Hwz
 HL$` IIIE  (WX$   $   L$   L$   LcF,L$  E3AH$   H$   Mj  IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   L$  L+II;   IH+HH   H+HIIH+HO  HSL+IIHIH+IMI;LCL;ICH$   L$   L$   H$   H$   E3H$   L$  HtJHL$     I;   IH+HH   H+HIIH+H   HSL+IIHIH+IMI;LCL;ICH$   BL$   L$   H$   E3H$   L$  Ht3HH$   HH$   I;s{
H
t
 @9	 H
t
 29	 HD	 HD$`3HD$hHD$pH
x
 HD$xƄ$   HT$hHL$x;	 H:
 HD$`Hw
 HL$` H$  H;G   LH$  L;   L$  M+IHGH9Gu{H+GHHsmHOI+HIIH+HsH
t
 \8	 HWI+HHLGM+IIHL+IIM;HCH;HCH轃HOHHt.JH%HGH9Gu
   HA]HGHtD HGH$  H;GsKHH$  H;w;L$  L+IHGH9Gu
   H\HOHHt.JH%HGH9Gu
   H\HGHtDHGE3ED9nx~7H$   Ld$xfIcHHA%AE;<$|H$  L$   H$   H;GsKHH$   H;w;L$   L+IHGH9Gu
   H$\HOHHt-JH$HGH9Gu
   H[HGHt8HGED9n,L$   ~$D  IcH    IHz$AD;~,|W$  HǄ$       O
 |   DF(Hh_
 H
p
 HcV(HL$`#E3ALL$hIHT$`H+HI      Ht0L@ f     M<HLL$hIHT$`H+HH;rIL+IMtL<HHD$hH+D$`HH;r
 }   DF(H^
 H
^
 5HcV(H$   "E3AL$   IH$   H+HHt4Lfff     M<HL$   IH$   H+HH;rIL+IMt+fff     L<HH$   H+$   HH;r֭
 ~   DF,Hm
 H
Xo
 oHcV,H$   ."3ɋL$   IL$   I+HHt0M    M<HL$   IL$   I+HH;rM+IMt.@ ff     M<HH$   H+$   HH;r
    DF,Hl
 H
n
 诶HcV,HL$xq!3DL$   IHT$xH+HHt N<IL$   IH+D$xHL;rHT$xL+IMt+@ ff     L<HH$   H+D$xHH;r㋆   uv_
    H   H   HV0LN(LL$@LNxLL$8HD$0HL$(HT$ L$   L$  H$  H$(    HHL$`W        
    H   H   HVHLF0LN(LL$HLNxLL$@HD$8HL$0HT$(LD$ L$   L$  H$  H$(    HHL$`aW  H$(  HtL$8  L+IUL$      H
kk
 $  ;F,q  !
    LcHI+HH$  HL$(D$    EDĳL   L+   IH
j
 HL$(D$    E薳H   BtCYtL$   L+$   IH
*l
 HL$(D$    EQH$   Bth
    Hj
 HD$(D$    ED$  L   L+   IH
Kj
 HL$(D$    EH   BtCYtL$   L+D$xIH
k
 HL$(D$    E褲HD$xBt$  xA   =
 D;~(  
    IcLD$hL+D$`IH
k
 HL$(D$    D;HD$`H$  H   LLi
 H  HH$  H$   H+$   HLIL+	IHD$0HX
 HD$(LX
 H
X
 Z-  H$  LAL+IH$   H	(Lh
 HH     HH$  H$   H+D$xHLIL+	IHD$0HKX
 HD$(LCX
 H
@X
 ,  H$  LAL+IHT$xH	cXH$  YtXL$   L+$   IH
JX
 HL$(D$    DݰH$   tAK
    E3D8$     A;^(}HcHD$`HHA;^(}HcH$   HHAfD  ;^,}HcH$   HHtA;^,}HcHD$xHHTHT$x$   P  Ht%L$   L+ITQWD$xL$   H$   Ht(L$   L+I"QW$   L$   H$   Ht(L$   L+IPW$   L$   HT$`HtLD$pL+IPWD$`L|$pH$  Ht#ML+IPW$  L$   Mt&M+IMIiPW$   L$   H$   Ht&L+IMH6PW$   L$     Ht%L$   L+IPWD$xL$   H$   Ht(L$   L+IOW$   L$   H$   Ht(L$   L+IOW$   L$   HT$`HtLD$pL+InOH$  HtL+IMQOMtM+IMI9OH$   HtL+IMHOL$  A(sA({E(CE(KIA_A^A]A\_^[LWH`ICI[IsH) H3HD$XHIK3t$ H1HqHqD$    HHD$P   Ht$H@t$8DFH'	 HL$8YHD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHNHH;HKHthHA   HqHyrHHH@HCH9Cu
   HlNHKHt(HA   HqHyrHHHT$8  _HC HD$PHrQHHL$8H=   r<t-	 HAH;r-	 H+Hs-	 H'v-	 HT HHL$XH3ZM H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUH:L?LLE   HuHI?LuI;   HHM>HHMu HHFHMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHS HI;{,	 ,	 ,	 x,	 q,	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   H8HOHMPH[HHHMXHt2HGH9Gu
   H8HOHMPHMXHt
HUHGHMHtiHEH+HI;v+	 H    H=   r<ty+	 HAH;ri+	 H+HsY+	 H'vL+	 HkR H   IHF  HMH+IHHHH?HH
H;v*	 HRHH=   r=@t*	 HFH;r*	 H+Hs*	 H'v*	 HHQ HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHHo  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   H9HSHt(H
H;Cu
   Hy9HCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H8HSHt(H
H;Cu
   H8HCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_H\$Ht$WH IHHH;t HHHHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HHTH H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`r$	 H5
 Ht$hH
.&	 $	 HHEH;xsHHHH   3ۀx$ t:$	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8HTI
 HD$0H
 HD$(H HL$(Y H\$hHU
 HHRH8F HL$`#	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$P_#	 H
 HD$XH
;#	 #	 HHFH;xsHHHH   3ۀx$ t'#	 H;xs
H@HHumH\$XHucHHL$XD#	 Hu13HD$8H@H
 HD$0H
 HD$(H HL$(X H\$XH9
 HHPH$E HL$P"	 HH\$`Ht$hH@_H\$WHPH H3HD$@HHD$8   HL$ HD$0    ID$  E3QHLD$ HWHh HHD$8H+HHrQHL$ HH=   r<t`%	 HAH;rP%	 H+Hs@%	 H'v3%	 HRL HHL$@H3D H\$`HP_H(Hu3H(HH;w*H\$ H    H#	 HuHuH\$ H(@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0 t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHRu  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHRe  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H	  H
 HCPH [HL$SH0HD$ HD$P    EtHn
 HA@H
 HAPD$P   J   H"
 HHC
 HCHC@HcHH~#
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH)	 HHQ3HHBHK, 	 H
 HH{3HHDH^H\$HH$
 HHOHKHtHPHGHCHGHCG C H
 HH%
 HHH\$PHt$XH0_Hi
 HH@SH HHI05 	 HK + 	 HH [H% 	 HQ
 H@SH HH   H`HcPH
 HHHHHcPDHDDHh	 HH [H%	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3LHo(Hs(H;t<HHRH]HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3KGxCxGyCyG|C|H   H   H;tIE3K                                                  HH\$HHl$PHt$XH0_H\$WH H  H
 HGPt
X   HE HH\$0H _@WH0HD$ H\$@HHx
 HH!
 HAHI HtHP tHC     H&	 HHK	 @t
@   H(E HH\$@H0_H	HtH   H k  HUHl$H  HD$8HXHxH H3HEpIID$0    3A fAn	 f/rHHr   H!
 HD$PHq
 HD$`HM	 D$0   E3HT$hHL$PN	 HD$PHcHH
 HDPHD$PHcHhTLHD$hHD$@HL$h	 H
 HD$hHE    E    HV
 HL$`cHL$`	 HUPHL$PhHEPH}hHCEPHD$ L
V
 LHQ
 H
<Q
   HMpH3
< L$  I[I{I]HUHl$H  HD$8HXHxH  H3HEpIID$0    3A	A;|HHr   Hr 
 HD$PH
 HD$`HM	 D$0   E3HT$hHL$P	 HD$PHcHHZ
 HDPHD$PHcHhTLHD$hHD$@HL$h=	 H5
 HD$hHE    E    HzU
 HL$`HL$`	 HUPHL$PHEPH}hHCEPHD$ L
bU
 LHLP
 H
O
   HMpH3: L$  I[I{I]H8MPE3MPMtYMH\$@HH|$0H      ff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8  @SH0HD$ HH7
 HH
 HAHI HtHP tHC     H!	 HHKH0[H%	 LH   ICAC    HQH
 ICH
 ICAC   IKH
 HD$(H ;
 HD$@HD$hHcHH
 HDhHD$hHcHDd    H HL$(K @SH0HD$ HٹX   << HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH_
 HHE:
 HAHA@HcPH"
 HD
@HA@HcPDBDD
<H
 HH
 HAHI HtHP tHC     Hu 	 HHKH0[H%J	 @SH0HD$ HHo
 HH
 HAHI HtHP tHC     H 	 HHKH0[H%	 HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIv  HWH*  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHq pMt/HWI  HOH+IHHLI?LH"HNH+IHHHH?HH#tLHVH<q HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+HV7HH+HH4H+H;7HOHHLH+HH+O  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   8 HH$   LCMu	H6
 
IP(HuIP0HL$(	 HǄ$      3H	 H
 HHH  H>HL$(	    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
TL
 	 H;s/LHjHtH{HsrH3 H\$0Ht$8H _HsH;LƲLBZ8HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    H
 HHx 
 HAH   	 D$H   H_E3HH	 HHcHHD
 H9HHcHHT9H\$PH	 H!
 HC| Cq H	 Hǃ       H
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH	 HH
 HAHI HtHP tHC     H	 HHKc	 @t
@   H9 HH\$@H0_H\$WH HHHUt
  H[9 HH\$0H _@SH HH	&	 HKH [H%	 LHXICLI@I+ HHQH;rQH	 IC3ICICHM
 ICD$0ISIK	 H
 HD$8HL
 HL$8  HBHAI HX@SH HH	H   HS  HH*HSH+HHHH?HH
H;v 	 HRHH=   r<t	 HAH;r	 H+Hs	 H'v	 H7 3HHCHCH [DD$HL$WH0HD$ H\$HHt$XHH3t$PHs	 HA@H
 HAPD$P   OH
 HHOH1
 HHG@HcPH
 HD:@HG@HcPDBDD:<HSHHDaYHH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H		 HtHHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
G
 t	 L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HHaTHSLHHO HH{H+HHtLCL+I.HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
E
 
	 H|$@K<H   HvH
E
 		 H9{s#HHcH   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0	 H{rHHHtLHq H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%	 HWAVAWH   HD$(HXHp H H3H$   LLHL$ Hj		 HT$0IT		 3IFIF IF(HT$`I8		 H
G.
 $  IFI/		 HHHHǀ<8 uHǺ   H#	 HHu	 HHtHRHvHuIN I	 HHÀ< uHú   H
	 HHuZ	 HHtff     HIHHuIV(fAF.,H$   H3+ L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
?C
 	 LAI+H|$8H|$PH;HGIHH;wH
B
 @	 Ht$0I48H  HvH
B
 	 H9qs H`H   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8	 I;u>HKI?MIDHrHHHrHHHt8HLp	 *I~rM6H{rHHHtK>Ln H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HH4 HH0[@SH HHHSH
Q	 H3H
HJHH	 3HC HC(HC0HV	 C8HH
 HCHH [@SH0HD$     *5 HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH
q@
 	 I4L+IIHH+I3I;HCH;HCHt$@HRLHD$8HD$0LHT$xHm HD$0LH$   H$   i HD$0LHWHL$xm HWHHH+HHHt藽  HLGL+I%HIHwHIH_L7%IH~i HHWLHL$x( H_H\$pHPA^_^@SUVWHx  HD$8HL H3H$`  IIHHI@I+ HL;   HL$@oHWC
 HL$PkHHQ	 HHB
 kHHB
 kHHiB
 tkHH*B
 ekH$@  HL$@sHCH+HHD$0H$@  H$X  HC$@  HD$ L
B
 LD$0HH| H$`  H3% Hx  _^][@UVWHp  HD$8H$  H H3H$`  IHLL$0H$  H$  L;  HL$@HT>
 HL$@rjHHgjH$@  HL$@H$0  WHc>
 H$0  2jHH >
 #jHHjHH.>
 	jHH	 HH=
 iH$   H$0  9H$   H$8  HC$   H$@  H$X  HC$@  HD$ L
\8
 LD$0H H$`  H3z$ H$  Hp  _^]Hx)t$`()|$PD)D$@D
 D)L$0D
Y
 fD/D)T$ EWA(r`A(\(<i (\f/

 vAXfA.zu7	 
  !      =
 Y(i ^fA.ztf/5
 r
(豺 O
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(л X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PHP H3HEpMMHHH   D$     HG
 HD$`HM`	 D$    E3E3HT$hHL$`)	 HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h;HHL$`YgHH$
 JgHH?gHH*
 0gHI%gHA HHgHUPHL$`` HxrH H
6
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@ 	 HT
 HD$(H HL$(l4 @SH`W)t$Pf/D)D$0D(   u+DW
 3A(Wݰ
 (t$PD(D$0H`[d
 fA/DW
 A(v(

 \((t$PD(D$0H`[3bX
 (t$PD(D$0H`[5
 fA/)|$@D)L$ D
p
 !  
 fA/vTfD.z  4l
 eH%X      HЋ9
   %O
 AYDY1
 AX  k
 eH%X      HЋ9>
 
  A(AY(Y((Y%ʇ
 (Y

 Y
 X%
 X

 X
 YYY
 X%g
 X

 YX
 XYX^X%k
 AY  3t

 !
 fA/  k
 eH%X   =@
 fA/   HЋ   9
   A(A(\AYW
 (Y@d ((Y8}
 (Y%}
 (Y
Bx
 X
}
 X|
 A^X
x
 YYYX|
 X
w
 YYX(Yw
 X
w
 X|
 Xw
 YXw
 YX^Xj
 Y  q
 fA/   9h
 '  A(A(\AYW
 (YHc ((YHx
 (Y5x
 (Y

 Xx
 X
x
 A^X
e
 YYYXw
 X
9
 YYX(Y:
 Xw
 X
 YXX

 ^X
 Y  ͢
 fA/   9
   A(A(\5~
 AY(W
 YXb ((Y{
 (Yz
 (Y

 Xz
 Xz
 A^X
U
 YYYXz
 X
)
 YYX(Y*
 Xzz
 X

 YXX
~
 ^XƠ
 Y   9
 Z  A(A(A^AY(YW٫
 ~a ((Y6
 (Y#
 (Y

 X
 X
 A^X
k
 YYYX
 X
 X
7
 YYYX
 X

 X(Y$
 X
 YX
 YX^Xܟ
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
v
 U =j
 
 H
U
 

  H
$
  =
 ({
 H

 (
ݪ
 
 ޡ
 
 (o
 z
 
 
i
 (
 z
 
z
 J qH

  =
 V(9
 H

 (
ˣ
 |x
 (
 x
 (
 
px
 (
q
 zs
 J
 
[s
 (
Ԣ
 |s
 
es
  H
4
  =(
 (
 H

 (
͢
 s
 (ߡ
 
s
 (
 s
 (
 
,
 (
%
 .
 
7
 > [H

  =ڄ
 .(-
 H
Ƅ
 (
 0w
 (A
 
2w
 (
C
 4w
 (
 
{
 (
W
 {
 
{
  H

  =
 (ϡ
 H

 (
 |
 (
 |
 
 |
 (
 
|
 (
'
 |
 (
 
|
 (
j
 |
 
|
 " @UVWHp  HD$8H$  H H3H$`  IHLL$0H$  H$  L;   HL$@4H1
 HL$@]HH]H$@  HL$@UH$0  H1
 H$0  \HH`1
 \HH\HH0
 \HH HH0
 \H$   H$0  H$   H$8  HC$   H$@  H$X  HC$@  HD$ LD$0H  H$`  H3! H$  Hp  _^]@USVWAVHl$H  HD$PH5 H3HEpIHHL   D$     H/	 HD$`HMH D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h/HHL$`A[HH
 2[HH'[HH
 [HH0
 	[HHuH

 HZIH IHZHUPHL$`)HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@L H	 HD$(H{ HL$(5( DD$USVWAUAWHl$H   LjLy3HHM;otI Mt
I[II7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH Mt
IHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMq HIH HHGHGHtH<    
Hg
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM' w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH Mt
IHH7LEwH_HUoLwHj H}HEHHMLwH]LuHEVw W(f.z
u5
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]Lu IUHO(QLG(IH HW(H|$ Iѱ G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM, ($   L$   HL$   fG<Hĸ   A_A]_^[]YYY@SH HHHSH
A H3H
HJHH 3HC HC(HC0H	 C8HHe HCHH [LHXIC3ICH
 ICH	 ICH~A
 ICH
 ICIK6 @SH`  HD$8H H3H$P  DD$0H$  D;   HL$@,H8)
 HL$@
UHH
 THH)
 THH HH(
 TH$0  HL$@H$0  H$H  HC$0  HD$ L
\#
 LD$0HL
 H

 `\H$P  H3o H`  [HUATAUAVAWHHH  HD$PHXHpHx H H3H  M3t$@I@HD$0H
 HD$(MHLH

 oML$I  DM  
<
 
 @ M]MM;}UI$N    IIIHIIIL@      A \Tf/rIHMM;|MM;x  H=	 H|$`HM D$@   E3E3HT$hHL$` HD$`HcHHc	 HD`HD$`HcHxT\HD$hHD$HHL$h H	 H\$hHuE   H'
 HL$`RHH
 RHHh'
 RHIU HH&
 {RHIW HH|"
 _RH`  HL$`H}PH    D$@   E3E3HUXHMP HEPHcHHg	 HD
PHEPHcHxT
LHEXHD$HHMX H]XHǅ       ǅ      I<$I\$IIH&
 HMPQHH
 QHH^&
 QHIW HH%
 qQHIU HHr!
 UQH H@  HMPL@  HX  LC@  L`  Hx  LC`  M$ID$IIMLT$ H
 H

 L  H  H3 L$  I[0Is8I{HIA_A^A]A\]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;tSIHHt3 HTHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVHl$H  HD$PH H3HEpMHHH   D$     H	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHHP	 HD`HD$`HcHDxDD\   HL$h_#HHL$`NHH
 NHHNHH-
 NHHR
 NHI HHrNHUPHL$`HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@ Hh	 HD$(Hh HL$( HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH

 HEL%	 LeH%	 HEH	 HEL5	 LuD$    L-$	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH} HE3HEHEHUHM H	 HD$0H	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP Hs	 HD$@Hrr	 HD$HE   
R
 eH%X   A   HȾ   A9.r
 Z  H
!r
  =r
 A  NW/
 LHEwH!	 IF@H>	 IFPD$    HT$0I  H	 IH|	 IF(IF@HcHH1	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw< HUHHMHH]wHt=C;u2HHP{;u LI@H
0H;HuAАMIHM)1Er
 fsfH~HtBHM0H
' 

 H
p
 A L5	 r
 r
 fsfH~HtpH	 HD$0HQ	 HEHEHcHH	 HD
HEHcHQT
Ld$0H~ H]HMX Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR Hr
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH{
 HEL%h	 LeH	 HEH	 HEL5	 LuD$    L-	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH- HE3HEHEHUHM H
 HD$0H	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP Ho	 HD$@HBo	 HD$HE   
dN
 eH%X   A   HȾ   A9"o
 Z  H
o
  =	o
 A  NW LHEwH	 IF@H	 IFPD$    HT$0I%  H
 IH	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMwL HUHHMHH]wHt=C;u2HHP{;u LI@H
:,H;HuAАMIHM,Eo
 fsfH~HtBHM>,H
  H
m
  L5	 o
 o
 fsfH~HtpH}
 HD$0Hy	 HEHEHcHHV	 HD
HEHcHQT
Ld$0H. H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR HZn
 H$H  H   A_A^A]A\_^]LEK ECWH`ICI[IsIcLH3t$0y*H
 ICL

 MCH
 H
Y
 Ey/H
 HD$ L

 L$   H8
 H
%
 IcWD$@Ht$PHL$@5HH3HsHsLD$@Hi HT$@HtLD$PL+IHH\$pHt$xH`_DD$SH@HH3ɉL$0Ex"HHKHKHIcL4HH@[H
 L

 HD$ LD$`H
 H
M
 H\$WH@LIL#
 L+	HHBH
"
 H+HHHD$0H
 IHD$(L3HCI+HHt(HfnHRAHHCH+HH;rH\$PH@_H\$WH@LIL
 L+	HHBH

 H+HHHD$0HL
 IHD$(&L3HCI+HHt,H@ ff     HIHHCH+HH;rH\$PH@_@SH0HD$       HH0[HHHD$pI*HHH+IHILIIH?LIHI+L
 HLL$0H

 HHH?HHb
 LHD$(=HH@UVWATAUAVAWH$pH  HD$HH$  H5 H3H   MHHHL$(3Dt$ IPIВ  IIFHCH+HsHI[  WD$0Ht$@HHM`貮HT$0H赠 L|$0ILd$8M;  H	 H
!	 HL$`HT$pHM ADl$ E3HT$xHL$` HD$`HcHH	 HD`HD$`HcHhT\HD$xHD$PHL$x H	 HD$xHuuHHL$pDHH8	 @HsH+3H3Ht(HHL$p. HH8	 o@HH;rHHL$p HH8	 G@HU`HL$`YHIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICI/HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICI
/IvHtrHF   3HNH~rHHƈHsLGItHH 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM HI;t(H|$(39H

 + H

  Mt6IIl  HL$@I+H*HHLI?LIH   H3" H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H) H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHMHHMWE3H]Ll$8H|$0\$(L$ LMMHHMw HE   H]]DCH<e	 HM#HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H L|$8H|$0Lt$(EwD$ ]oLEHUH HUHt LEL+IWEHE    HUHtLEL+IHMH3 H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   HHT$PHtLD$`L+IhHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xH' H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`HHL$dW$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$xf H$  hL$   HT$xIB (D$@IH$  IPH$x  H$x   E3|$@L$   L$   Ld$pH|$hH$  Ha	 H$  $9H( IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   Hb	 H$  3H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH

  HQM+IIHL+IIM;HCH;HCHL$H'HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH

 C HQM+IIHL+IIM;HCH;HCHL$H0'HL$PHt0HA   LqHyrHHH$    kHL$PH HL$PH$  pAEHT$HItI$H
1	 H;tHT$HIP A$     D
7
 Dt
 $     W$  L$  H$  ?D$0D$(H$  HD$ LD$xI
H$   H$  uHXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  ] I$L@H
5	 H$  H;uIL$IAАH$x  H$x   H$  HtL$  L+I|$@HHH%H;tHD(L$   HT$xI (D$@H$      H$    HH_	 H$   !5HHuI
H HcHHHW
   H$    HƋH HH-	 4HH_	 4HHuI
H HcHHHW(A\(H: HH^	 4H( HHY-	 h4IH$   IPATH$x  H$x   fD/s;$  H|$haW$  L$  H$  D$0D$(H$  HD$ LD$xIyH$   H$  HXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  sZ I$L@H
	 H$  H;uIL$}IAАH$x  H$x   H$  HtL$  L+IHL$HHt.HT$P  LD$XHT$HL+I|WD$HLt$XH$x  H$x   HT$xHt%L$   L+IWD$xL$   H$   HtL$   L+I3H$   H3P L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xHA H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$x	HHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`蟖 H  H  H  ^L H  HUH   H  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#3 H襦HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  k H`      	    	    	    	     	    Hc(	  H  8  =y
 Wt$XH  HY	 H  P/H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   HY	 H  dH  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH

 + HQM+IIHL+IIM;HCH;HCHL$@HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH

 w HQM+IIHL+IIM;HCH;HCHL$@dHL$HHt/HA   LiHyrHHH    HL$HH HL$HH  覷AEHT$@HjIH
h	 H;tHT$@IP 0	  @   WELmH  D$0D$(HEHD$ LD$`HoH  H  HXH  HtIH  IPHD$XHD$ A   LEHUHMvS IL@H
	 HUH;uIO膯IAАH(  H(   HUHtLEL+I
H
Lc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HCV	 H  IH  IP H  ٵH  =  D8  Wt$XH  HL$`許3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HMu HH/$	 H   *HHu3
H HcHHHWHH/ HH#	 p*   HM HH$	 H   K*HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HH#	 )H(  l (YH     HMz HH#	 H   )HHu3
H HcHHHW   HM) LHu3
HHcHHIPA(H  HH
#	 I)   HM( HH#	 H   $)HHu3
H HcHHHW   HM8 LHu3
HHcHHIPAH  k (Hl HH"	 (
   HMH^ HH`'	 H   (HHu3
H HcHHHW   HMX
 LHu3
HHcHHIPAP  H HH&	 ((
   HMhѿ HH'	 H   (HHu3
H HcHHHW   HMx LHu3
HHcHHIPAX  HR HHt&	 'HP     HM= HH'	 H   o'HHu3
H HcHHHWHH HH&	 8'H)	 H   %'HHh  F+HH`)	 'IH   IPH(  :H(  = 0	  HuH  H  ߽HXH  H   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  H  v@  W  H  H  蟾D$0D$(H  HD$ LD$`Hk}H  H  ؼHXH  HtIH  IPHD$XHD$ A   L  HUH  lL IL@H
	 H  H;uIOyIAАH(  脼H(   H  HtL  L+IEH
@
  W  3H  H  ~D$0D$(H  HD$ LD$`HJ|H  H  跻HXH  HtIH  IPHD$XHD$ A   L  HUH  KK IL@H
}	 H  H;uIOXIAАH(  cH(  f H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   HN	 IH  IP H  5A$   HN	 IH  IP H  蹭F   EH    LHN&	 H  >2MHIAP H  sH  fHL$@Ht.HT$Ht  LD$PHT$@L+I{WD$@H|$PH(  H(   H  w  H    H(  ޹H(   HT$`HtLD$pL+IUWD$`H|$pHUHtLEL+I~H`  H3- L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xH!x H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$` H  肹H  H  4 H  HUH   H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3 H腖HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  [ H@ Hc	  H  2  	    (	    0	    8	    @	    H	    HcP	  H  8  =i
 Wt$XH  HyJ	 H  H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   HAJ	 H  1H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@
HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
	 D HQM+IIHL+IIM;HCH;HCHL$@1
HL$HHt/HA   LiHyrHHH    mHL$HH HL$HH  sAEHT$@HZIH
5	 H;tHT$@IP X	  @   WELmH  mD$0D$(HEHD$ LD$`H<tH  H  詳HXH  ٦HtIH  IPHD$XHD$ A   LEHUHMCC IL@H
u	 HUH;uIOSIAАH(  ^H(  a HUHtLEL+IH
Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HF	 H  IH  IP H  詥H    D8  Wt$XH  HL$`x3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   TH`     HME HH	 H   wHHu3
H HcHHHWHH HH	 @   HM HH3	 H   HHu3
H HcHHHW   HM LHu3
HHcHHIPA(Ho HH	 H(  \\ (YH     HMJ HH	 H   |HHu3
H HcHHHW   HM LHu3
HHcHHIPA(Hб HHR	    HM(° HH	 H   HHu3
H HcHHHW   HM8q LHu3
HHcHHIPAH  P[ (H< HH	 
   HMH. HH	 H   `HHu3
H HcHHHW   HMXݯ LHu3
HHcHHIPAP  H HH	 
   HMh HHS	 H   HHu3
H HcHHHW   HMxP LHu3
HHcHHIPAX  H" HH	 kHp     HM
 HH	 H   ?HHu3
H HcHHHWHHǯ HH	 H%	 H   HHh  HH	 IH   IPH(  
H(  
 X	  HuH  H  语HXH  ߠH   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  H  F@  W  H  H  oD$0D$(H  HD$ LD$`H;mH  H  訬HXH  ؟HtIH  IPHD$XHD$ A   L  HUH  << IL@H
n	 H  H;uIOIIAАH(  TH(  W H  HtL  L+IEH
m@
  W  3H  H  ND$0D$(H  HD$ LD$`HlH  H  臫HXH  跞HtIH  IPHD$XHD$ A   L  HUH  ; IL@H
M	 H  H;uIO(IAАH(  3H(  6 H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H`?	 IH  IP H  轝5A$   HT?	 IH  IP H  艝F   EH    LH>	 H  "MHIAP H  CH  6HL$@Ht.HT$Hc  LD$PHT$@L+IKWD$@H|$PH(  H(   H  G  H  ˍ  H(  让H(   HT$`HtLD$pL+I%WD$`H|$pHUHtLEL+INH  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pHHL$tWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHMxv Hp	 H   H   HuH   HEL}HEHHUH+HWEHt!3 HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%	 LeHaHEH]LL+tHH WED$xHE    HL$xDHT$xH   H   PAEHT$xI|MHHT$xHP HL$xHt|HU`  HEHL$xH+HHH;v HH=   r<t HAH;r H+Hs H'vx H Ld$xHMYHEHMHMHULL+tH EEfEML   HT$xHM.  L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H    J +fn^5O
 LM(WJLM(WJ(WHMNLeHM| Hr H	 H   HMHtsHEH+HHH;v H    H=   r<t HAH;r H+Hsި H'vѨ H 3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHH5H$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH萨 H$   aL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH> H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH谯 H$   qL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH}H$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH> H$   L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   dHH   uWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$pk H#	 HEWHMKKH	 HEHa	 HEH}H	 HEH   HEH   HE(YJ
 )E (
~H
 )ME        G
 E(E0    E4 WE8H	 HE   f/vM   f/v"E
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM' H	 HEHd	 HEHM> HM4 HM* HӖ	 HEHT$pHtLEL+I荿3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   fHH  wW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$ph H	 HEWHMGHH	 HEH]	 HEH}H	 HEH   HEH   HE(UG
 )E (
zE
 )ME        
D
 E(E0    E4 Wu8EH H	 HEPA
 Ex(
G
 )   XC
    uXW)E`Hݡ	 HEH5J	 Hu@P  f/vE=A
 X  f/vf/vM`  OȉM$Y9 Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM9 Hu@H]	 HEH	 HEHM| HMr HMh H	 HEHT$pHtLEL+I˻3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHvH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH謸 H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHUuH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHj H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHerH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHܿ H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH%qH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHz H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   ĮHH   ժWEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$pC_ H	 HEWHM>H	 HEH	 HEH}HZ	 HEH   HEH   HE(=
 )E (
;
 )M8
 ] WM0E(
   Hׄ	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM舨 H	 HEHł	 HEHM HM HM H4	 HEHT$pHtLEL+I3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   ǫHH  اW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$p@\ H	 HEWHM;H	 HEH	 HEH}HW	 HEH   HEH   HE(:
 )E (
8
 )M=5
 } Wu0E(
   E@ Hx~	 HEH(%:
 )Ep(
<
 )   W)EPu`H	 HEH5
	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
X6
 ( Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM Hu8H	 HEH	 HEHM HM HM؎ H	 HEHT$pHtLEL+I;3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pHHJ H3HE AALL   L   H   L  H  HEI荈   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pHHL$t!WE3H}Ht$8Ll$0D$(t$ LL$pMIHMX WD$XH|$hHE   H}@} DGH	 HM GHE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
		 c HQM+IIHL+IHM;HCH;HCHL$XPHL$`Ht,HA   HyHyrHHHU   菽HL$`H HL$`HEHrPHHM H=   r<te HAH;rU H+HsE H'v8 HW AEHT$XI.IHT$XIP H}H]H+HWD$xHt3 HfHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMv  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMNw  HL$x HL$XHt2HT$`@  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I3HM H3 H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHE H3HE AALL   L   H   L  H  HEI]   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pޢHHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHMzS WD$XH|$hHE   H}@} DGH	 HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
ٿ	 3 HQM+IIHL+IHM;HCH;HCHL$X HL$`Ht,HA   HyHyrHHHU   _HL$`H HL$`HEHrPHHM H=   r<t5 HAH;r% H+Hs H'v H' AEHT$XIc)IHT$XIP H}H]H+HWD$xHt3؅ HaHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMiq  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMg  HL$x HL$XHt2HT$`];  LD$hHT$XL+IǢWD$XHD$h    HUHtLEL+I3HM H3 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH@  Hǀ`HXHp )pH? H3H$   MMH$`  HH<
 HHH.
 H;
 r   HH
 H$8  Ht
*
 HE3H
 E3AHHH
 H;
 r
   1HH$8  WHt
(HIW$H  L$X  L$   L$   L$   L$   L$(  HT$`H$      HD$`H$(  L$0  HT$`H$     HD$`H$0  W$   L$   HcFxHD$pIHt'I;v
H
d	  HH$   ~tHD$pMfD  H$   L;  HT$`u  HD$`H$   L$   H;   HD$`L;   L|$`M+IL$   I;uxIH+HHshI+HIH+Hs
H
	  HQM+IIHIH+IMI;LCL;ICH$   sH$   L$   H   K   L$   I;upIH+HHs`I+HIH+Hs
H
	 y~ HQM+IIHIH+IMI;LCL;ICH$   sH$   HtHD$`HH$   HH$   IHD$pkL$@  HT$h  HHD$`H

 LH(H

 H;

 r(   YLHL$`L$8  Mt*L)AMXOIIMo Hr	 IML$8  HT$`HL$p(HHL$`HD$`H$@  WD$xL$   Lcn,MtM;v
H
͸	 '} IHL$xqM    M;  HT$`H$     HD$`H$   H;   HD$`LD$xL;   H|$`I+HL$   I;urIH+HHsbI+HIH+Hs
H
)	 | HQM+IIHIH+IMI;LCL;ICHL$xqH$   LD$xHt7I&H;$   uHL$xbpH$   HtHD$`HH$   HH$   I |   H~(DH
	 H
n	 HcH$   UIL$   IH$   H+HHt0ff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r3 }   DHM	 H
J	 HcH$  ]TIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;rs ~   DF,HD	 L%	 I	HcV,H$   SIL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r    DF,H	 H
=	 LHcV,H$   RIL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$    HH$   T       k    HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$   n HH$   ͼ H$   HtL$   L+IH$      L=	 H	 ;~,      HcL   L+   IHT$(D$    DSL   L$   L+D$xIL|$(D$    D&HD$xL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID    L   L+   IH
	 HL$(D$    DL   L$   L+D$xIH
د	 HL$(D$    DcHD$xL$L$   L+$   IH
	 HL$(D$    D*L$   ATIT$HL$`H IDH$   L%	 P       5
 L-	 I*;~(      HcH   H+   IHHLI?LLl$(D$    DyH[H   L$H   H+IHHLI?LLl$(D$    D7H[H   L,L$   L+$   IH
ɯ	 HL$(D$    DH$   HHHD$`L$  L+$  IH
 	 HL$(D$    DL$  L$   IT$HL$ht LL$   IUHL$p[ L(H$  LHT$`H$  MHH$    H IDH$   RAH$   ;^(   HcH<    H$  uHʴ	 H$   U[HkH u ]HVH$   H$  AsHHxrHHU H$h  3H$p  H$x  H$   Ƅ$   H$p  H$   u HNu	 H$h  H H$h  p AH$      ;^(   HcH<    H$  tH	 H$   W[HmHt ]HXH$   H$  CrHHxrHHW~ H$  3H$  H$  H$   Ƅ$   H$  H$   t HPt	 H$  H H$  r AH$   ;^,   HcH<    H$  %sH%	 H$   `[HvHs ]HaH$   H$  LqHHxrHH`} H$  3H$  H$  H$   Ƅ$   H$  H$   s HYs	 H$  H H$  { A;^,   HcH<    H$  6rH^	 H$   q[HHr ]HrH$   H$  ]pHHxrHHq| H$  3H$  H$  H$   Ƅ$   H$  H$   r Hjr	 H$  H H$  茦 t    D$p   Dt$`LL$pLD$`H$(  HL$h; HT$hH$H  i: /    D$`   Dt$pLL$`LD$pH$0  HL$h HT$hH$H  $:     Dt$`L   LD$`H$   HL$h HT$hH$H  9     
 D$hDt$`LL$hLD$`H$@  HL$p| HT$pH$H  9 `    Dt$`L   LD$`HT$xHL$h HT$hH$H  ^9 $    HV`L$@  L$  HL$h HT$hH$H  $9 H$   Ht(L$   L+IW$   L$   H$   Ht(L$  L+I͑W$   L$  H$  Ht(L$   L+I蘑W$  L$   H$   Ht(L$   L+IcW$   L$   HT$xHt%L$   L+I1WD$xL$   H$   HtL$   L+IH$8  H$H  7 H$H  H$`  HH$H  HtL$X  L+I诐HH$   H3謐 L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWH@  Hǀ`HXHp )pH+ H3H$   IMH$`  HH HHH H; r   KHH H$@  Ht

 HE3H E3AHHH H; r
   HH$@  WHt
(IH$@  W$H  L$X  L$   H$   L$   L$   L$(  HT$`H$   ۞  HD$`H$(  L$0  HT$`H$   贞  HD$`H$0  W$   L$   LcoxIMt"M;v
H
$	 ~k IH$   >`MH$   M;  HT$`@  HD$`H$   L$   H;   HD$`L;   Ht$`I+HL$   I;x   IH+HHshI+HIH+Hs
H
}	 j HQM+IIHIH+IMI;LCL;ICH$   o_H$   L$   H   I   L$   I;upIH+HHs`I+HIH+Hs
H
	 @j HQM+IIHIH+IMI;LCL;ICH$   ^H$   HtHD$`HH$   HH$   IlL$8  HT$h赜  HH$   %(HHL$`HD$`H$8  WD$pL$   Lcg,MtM;v
H
	 li IHL$p/^MM;   HT$`H$   1  HD$`HL$xH;sDHT$`HD$pH;w5Ht$`H+HH;$   uHL$pC]HL$xHD$pHt1H#H;$   uHL$p]HL$xHt
HD$`HHL$xHHL$xIV |   Hw(DHΑ	 H
/	 NHcH$   AIL$   IH$   H+HHt1fff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r }   DH
	 H
	 HcH$  AIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;r3 ~   DG,H	 L%	 IHcW,H$   X@IL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;rs    DG,HD	 H
	 HcW,H$   ?IL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu    HGxH   H   LG0Ht$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$   赟 HH$          +    HGxH   H   LGHLO0Ht$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$   . HH$   荩 H$   HtL$   L+IˇH$      L=	 H	 ;w,  m    HcL   L+   IHT$(D$    DL   LD$xL+D$pIL|$(D$    DHD$pL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID    L   L+   IH
	 HL$(D$    DZL   LD$xL+D$pIH
	 HL$(D$    D)HD$pL$L$   L+$   IH
ѝ	 HL$(D$    DL$   ATIT$HL$`H IDH$   L%}	 V       5

 L-	 I*;w(      HcH   H+   IHHLI?LLl$(D$    D?H[H   L$H   H+IHHLI?LLl$(D$    DH[H   L,L$   L+$   IH
	 HL$(D$    DH$   HHHD$`L$  L+$  IH
	 HL$(D$    DyL$  L$   IT$HL$h: LL$   IUH$    L(H$  kLHT$`H$  VMHH$   H IDH$   OAH$   ;_(   HcH<    H$  aH	 H$   [H-Ha ]HH$   H$  `HHxrHHl H$h  3H$p  H$x  H$   Ƅ$   H$p  H$   Ob Hb	 H$h  HY H$h  2 AH$  ;_(   HcH<    H$  `H	 H$    [H6H` ]H!H$   H$  _HHxrHH k H$  3H$  H$  H$   Ƅ$   H$  H$   Xa Ha	 H$  Hb H$  ; AH$   f;_,   HcH<    H$  _H	 H$   '[H=H_ ]H(H$   H$  ^HHxrHH'j H$  3H$  H$  H$   Ƅ$   H$  H$   _` H `	 H$  Hi H$  B Aސ;_,   HcH<    H$  ^H$	 H$   7[HMH^ ]H8H$   H$  #]HHxrHH7i H$  3H$  H$  H$   Ƅ$   H$  H$   o_ H0_	 H$  Hy H$  R :    Ǆ$      Dt$`L$   LD$`H$(  HL$h HT$hH$H  )'     D$`   D$   LL$`L$   H$0  HL$h谯 HT$hH$H  &     Dt$`L   LD$`H$   HL$h HT$hH$H  & e    
 D$hDt$`LL$hLD$`H$8  H$   3 H$   H$H  N&     Dt$`L   LD$`HT$pHL$hD HT$hH$H  &     HW`L$8  L$  HL$h蚶 HT$hH$H  % H$   Ht(L$   L+I~W$   L$   H$   Ht(L$  L+I~W$   L$  H$  Ht(L$   L+IL~W$  L$   H$   Ht(L$   L+I~W$   L$   HT$pHt%L$   L+I}WD$pL$   H$   HtL$   L+I}H$@  H$H  $ H$H  H$`  HH$H  HtL$X  L+Ic}HH$   H3`} L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWHP  Hǀ(HXHp)p)xHS H3H$   ML$   H$   HL$HH$  H$   L$  L$  L$  H$  H$   D$D    D$@P   EH H
 IcHL$PF3LD$XIHT$PH+HH      Ht'L@ IHLD$XIHT$PH+HH;r3L+IMtfHHHD$XH+D$PHH;rD$@Q   DH0 H
 HHcHL$hF3LD$pIHT$hH+HHt/L@      IHLD$pIHT$hH+HH;r3L+IMtfHHHD$pH+D$hHH;r   =

 H
 A;?   D$@T   HcMFM+IHL$(D$    DI6MD$M+$IH
k HL$(D$    DrI$tYtWLD$XL+D$PIH
 HL$(D$    D5HD$PtJ   L	 H*H$   ;0M  D$@W   HcMu IMI+HHHHHH?H  G;  H<[ID$I+$HMLM+LIHD$0LD$(L	 H
}	 TILMDL+II$(H$   L8HxI+HD  G;9  Mu IMI+H*HHHHH?H  G;  H<[HD$XH+D$PHMLM+LIHD$0H~	 HD$(L~	 H
~	 HSILMDL+IHT$PH$   X0AYtH$   X XH|$pHL$hH+H|G;}
t2H]	 H$   H"Z	 H$   H$H  4W D$D   E3H$   H$   V H$   HcHHnW	 H   H$   HcHh   H$   HD$HH$   BT H:R	 H$   3H$0  $8  H|	 H$      HU H$  H$   SL$  H$  LC$  H HD$ DËYHq\	 H$  HX	 H$  H$H  V D$D   E3H$  H$  U H$  HcHHFV	 H  H$  HcHh  H$  HD$HH$  S HQ	 H$  3H$0  $8  H{	 H$  Ż   HwT H$  H$  RL$  H$  LC$  H HD$ DË1HI[	 H$  HW	 H$  H$H  T D$D   E3H$  H$  T H$  HcHHU	 H  H$  HcHh  H$  HD$HH$  Q HO	 H$  3H$0  $8  Hz	 H$  蝺   HOS H$  H$  QL$  H$  LC$  H HD$ DË	H!Z	 H$  HV	 H$  H$H  S D$D   E3H$  H$  zS H$  HcHHS	 H  H$  HcHh  H$  HD$HH$  P HN	 H$  3H$0  $8  Hjy	 H$  u   H'R H$   H$  rPL$   H$  LC$   HL HD$ DËD$@Z   HT$hH\$HHF HL$hH   HD$xH+HHH;vT H    H=   r<tT HAH;rS H+HsS H'vS Hz WD$h3HD$xHT$PHtLD$`L+IIsHH$   H3Fs L$P  I[8Is@A(sA({IA_A^A]A\_HLH L@HPHHSVWATAUAVAWH  HD$x)p)xD)@D)HMILD$p    Ǆ$  9   H$p  DH H
 HcHL$@<3LD$HIHT$@H+HH      Ht#LIHLD$HIHT$@H+HH;r3L+IMtfHHHD$HH+D$@HH;rǄ$  :   L$x  E$HT H
 \Ic$HL$X<3LD$`IHT$XH+HHt#LIHLD$`IHT$XH+HH;r3L+IMtHHHD$`H+D$XHH;rǄ$  <   H|$(H$h  HD$ MLIH$   裚 HHHH+HLL$HL+L$@IHL$0HS	 HD$(LW	 H
`	 #K3HD$HHT$@H+HHt)L     IHHHD$HH+D$@HH;rH$   HtL$   L+Ip   H$`  D
 
 D*	 L H*A;<$+  Ǆ$  >   HcHNH+HHHH?HLD$(D$    DDL4[L>IEI+E HOLO+LIHD$0H|u	 HD$(Ltu	 H
qu	 JKLODL+IIU (L$P  MFM+IH
A HL$(D$    D(M.HNH+H*HHLI?LH0 HD$(D$    DL4[L>HD$HH+D$@HOLO+LIHD$0Ht	 HD$(Lt	 H
t	 0IKLODL+IHT$@H$@  X At\L$8  AX?YAWL$X  MFM+IH
ÿ HL$(D$    D*(輳 IAXt^LD$`L+D$XIH
 HL$(D$    DHD$XtL$H  Ǆ$  A   HT$XL$0  I\ HL$XHHt{HD$hH+HH;v8N H    H=   r<tN HAH;rN H+HsM H'vM Hu WD$XHD$h    HL$@HtiHD$PH+HH;vM H    H=   r<tM HAH;rM H+HswM H'vjM Ht IL$  A(sA({E(CE(KIA_A^A]A\_^[H\$WH0LIHL+	H*ILD$(DHHHD$    H?HD&HH[H\$@HHH0_Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hr H3HsHsHH;uHl$0Ht$8H\$@H _K K ~K wK pK DL$ LD$HT$HL$SVWH0HD$(HH9z ucH ǭ HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH 臭 HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHp H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _I I {I tI H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   H"p H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weHo HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _OH HH AH :H 3H ,H %H H H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHn H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _yG rG kG dG HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHH>0HHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hm H3HsHsHH;uHl$0Ht$8H\$@H _<F 5F .F 'F  F HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PH  H3HEpMMHHH   D$     HF	 HD$`HMC D$    E3E3HT$hHL$`C HD$`HcHHX3	 HD`HD$`HcHDxDD\   HL$hg~HHL$`ɩHHg	 躩HH诩HH5m	 蠩HI蕩HA/B HH|HUPHL$`BHxrH H
L HL$(3HL$0HL$8HD$@D$HHT$0HL$@B HI	 HD$(Hv HL$(v @SUVWAVH`  HD$8HJ H3H$P  IIHLD$0    HDE	 HD$@H$   YB D$0   E3E3HT$HHL$@"B HD$@HcHH1	 HD@HD$@HcHDxDD<   HL$H|HHL$@RHH}	 CHHU@ HH{	 'H$0  HL$@uAHHcD$0H$0  H$H  HC$0  H}	 HD$ L
~}	 LD$0I9@UVWAVAWH`  HD$8H$  H H3H$P  MIHLH$  D$0    HC	 HD$@H$   @ D$0   E3E3HT$HHL$@@ HD$@HcHH0	 HD@HD$@HcHDxDD<   HL$H{HHL$@HH{	 HIV? HHy	 ƦH$0  HL$@@HIcD$0H$0  H$H  HC$0  Hl$ L
$|	 LD$0IH\$Ht$WH IHHH;t HHe)HHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(HIf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IHHA(IWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   HX(H
b	 HH0@8   HH$   ԍ HHL$(HG HL$(Y H\$WH HHHÀ< uHú   H& HHu# Ht!HH+fff     9HHuHH\$0H _@SH HO  H!	 HCPH [HL$SH0HD$ HD$P    EtH^	 HA@H{!	 HAPD$P   J   H	 HHi	 HCHC@HcHHN	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH- HHQ3HHBHK$ H!	 HH{3HHDH^H\$HH(	 HHOHKHtHPHGHCHGHCG C HR	 HH- HHH\$PHt$XH0_@SH HL  HK 	 HCPH [HL$SH0HD$ HD$P    EtH	 HA@H 	 HAPD$P   z  H	 HHQ	 HC(HC@HcHH	 HD@HC@HcHD<    HH0[@SH HBJ  H	 HCPH [HL$SH0HD$ HD$P    EtH>	 HA@H[	 HAPD$P     HE	 HH 	 HC(HC@HcHH	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH HC	 HHH	 HAPHI8`" HK V" HKL" H	 HH [@SH H+D	 HHH6	 HAPHI8" HK " HK! H	 HH [H\$WH HK  H	 HGPt
X   HI HH\$0H _H\$WH H,J  H	 HGPt
X   HI HH\$0H _H\$WH HH%	 HHHJHKHtHPHGHS0HCHO0HGHCG C H) HC(3HHB[  H#	 HH$	 HC(HH\$0H _H\$WH H|G  H	 HGPt
X   HH HH\$0H _H\$WH HH$	 HHHJHKHtHPHGHS0HCHO0HGHCG C H&) HC(3HHB H	 HHB	 HC(HH\$0H _@SH HH    H   HKX HKH HK8 HK( HK HKH [H% H\$WH HQ@3HHtLAPL+I?H{@H{HH{PHS(HtLC8L+I?H{(H{0H{8HSHtLCL+I.H{H{H{H\$0H _H\$WH HH   w  L   HgfffffffL+   IHLI?LH   貾  H   HOX HOH HO8 HO( HO| HOH\$0H _H%g HUHl$H  HD$8HXHxH  H3HEpIID$0    3A A	    f/rHHr   He#	 HD$PH	 HD$`HM
 D$0   E3HT$hHL$P HD$PHcHHM	 HDPHD$PHcHhTLHD$hHD$@HL$h0 H(	 HD$hHE    E    HmX	 HL$`HL$`| HUPHL$PHEPH}hHCEPHD$ L
SX	 LHX	 H
X	 HMpH3= L$  I[I{I]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHZ	 H  IHHL@H
j	 H;u.HSHKHH  مHHa H  HAАH  HrSHH  H=   r<t HAH;r H+Hs H'vz HC HWHL$x9@  MEHT$xH[  (Hǅ     L  ƅ   A   HY	 H  9GIH  IPH  HrSHH  H=   r<t HAH;r H+Hs H'v HB H   HY	 H   7H( H  H   8ILAHIAАH  HrTHH  H=   r<t$ HAH;r H+Hs H'v HB HH  HH   H\$0Lt$(x  D$ p  (HT$xHJ  H_HD$xH  HuHCH;t'H;tH Ht
HhHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  Q HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
aQ	 ; W  L  D$@Ll$PH	 HEHs	 HEHMH D$\   E3HUHMS HEHcHH	 HD
HEHcHhT
HEH  HM H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMrHXH  Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
8P	  IPL+IIHL+IIM;HCH;HCHL$@_LD$HMtM(LD$HILD$HIPHL$@H;t
I;tlB IHT$@IPHǅ     L  ƅ   E3H9	 H  BIH  IP H  H  HU	 H  |HȋW$ HH;U	 {IH  IPAD9o$Y  f     LGHWHL$x^m EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  
D$0D$(HD$@HD$ LD$`HH  H  EHXH  uHtIH  IPLD$HL;D$Pu   HL$@7LD$HMtM(LD$HILD$HIPHL$@H;t
I;t@ IHT$@IPHH  HH   ;w$}H
M	  Hǅ     L  ƅ   A
   HS	 H  @IH  IP H  HH  cHH  f HMHLHMHR HT$@HtLD$PL+I4WD$@Ll$PH  HtL  L+I#HT$`HtLD$pL+I}4HM HL$x 3H  H3f4 H$`  ($   H  A_A^A]A\_^]H8D$`AD$hAD$pLALA$A D$xA HLIy ~y ~By  ~g    HH8HN	 LAHD$ H
R	 L
xN	 HR	 HN	 LAHD$ H
TR	 L
MN	 HR	 yHYN	 LA HD$ H
)R	 L
"N	 HR	 NH.N	 L
N	 HD$ HR	 H
Q	 'HUVWATAUAVAWHH  HEHX)pHe H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHP	 H  >HL@H
:
	 H;u.HSHK{HH  {HH}1 H  HAАH  HrSHH  H=   r<tw HAH;rg H+HsW H'vJ Hi9 HWHL$xK@  MEHT$xH^n  (Hǅ     L  ƅ   A   HO	 H  	=IH  IPH  HrSHH  H=   r<t HAH;r H+Hs H'vx H8 H   H[O	 H   vH( H  H   
ILAHIAАH  HrTHH  H=   r<t HAH;r H+Hs H'v H7 HH  HH   H\$0Lt$(x  D$ p  (HT$xH@]  H_HD$xH  HuHCH;t'H;tHm Ht
H8HL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  ! HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
1G	  W  L  D$@Ll$PH	 HEHC	 HEHMH]
 D$\   E3HUHM#
 HEHcHH
	 HD
HEHcHhT
HEH  HM
 H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMB
HXH  rHt
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
F	 b
 IPL+IIHL+IIM;HCH;HCHL$@ULD$HMtM(LD$HILD$HIPHL$@H;t
I;t<8 IHT$@IPHǅ     L  ƅ   E3Hy/	 H  8IH  IP H  QH  
HUK	 H  qHȋW$
 HHK	 qIH  IPAD9o$Y  f     LGHWHL$xc EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  	D$0D$(HD$@HD$ LD$`HH  H  HXH  EHtIH  IPLD$HL;D$Pu   HL$@-LD$HMtM(LD$HILD$HIPHL$@H;t
I;tr6 IHT$@IPHH  HH  	 ;w$}H
wC	 Q Hǅ     L  ƅ   A
   HI	 H  ~6IH  IP H  PHH  3HH  6	 HMHHMH"	 HT$@HtLD$PL+I*WD$@Ll$PH  HtL  L+IHT$`HtLD$pL+IM*HM	 HL$x	 3H  H36* H$`  ($   H  A_A^A]A\_^]@SH A(HA #o CH [Ht$WH0HD$     H      t@W H   HVxH\$@       ^FxH\$@,;L   HHt$HH0_@SH H HH   H*	 HH HAPHI8 HK  HK~ H' 	 HH [Wf/v%      ^Ix,;L   H\$WH HHH   HqH   HbH   HH\$0H _I@UHHPHEH\$`Ht$pH|$xH H3HEHHE   3Hu@uDF
HG	 HM3HKHEH;sTHHUH;wHH}H+H;KuVHg(HH;HKHtcHA   HqHyrHHH;H;Ku
   H$(HKHt'HA   HqHyrHHHU  8HC HEHrPHHMH=   r<t HAH;r H+Hs H'vv H. HE   HuE A
   HF	 HMo2HCHMH;sVHHUH;wJH}H+H;Cu
   H;'HH;HKHtcHA   HqHyrHHH;H;Cu
   H&HKHt'HA   HqHyrHHHU  7HC HMHE   HuE A   HE	 HM1HUHHMmHMH3& H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3uq  HSHq  H_HGPLG`HHOPP8MHHOPo  HHMAHCHEEWH9puA(H HD$8HEHEHL$0~ (Y5+	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0	 Y	 XC(EoHHEoH#H      H;v	 \(i (5 	 f/vIHOhm  f/v:HEH;t1HKHUuEC(HKHUuHK0HUt]HCHEHx tH HD$8HEHEHL$0< D(DY	 DXC(D   0H$	 I$I\$H]oHOHHHGHCHWHGLL+th W=	 A|$At$ HM HM HM IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA #h CH [H\$WH0HD$     H      tS HWxH   %HH\$@H0_@SH H{	 HH   H HH HAPHI8 HK  HK HW HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=		 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@lf HL$0)  ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@f HL$0= L$   HHH$   ($   HĠ   _i  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Hu HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     OHHK8HOHS0LC8IL+LtHc HH\$@H0_H\$WH0IH IHD$     HHK HOHSLC IL+LtHc HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3 HgHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$Pb2 HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P (Y%M	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$    (X\(HĐ   [B(HhHBHD$(Hx uWY	 HhH HL$8HD$@HD$ HD$P Y	 HhWf/v	 f/v   Wf/vIxHAHH H\$WH HHki  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs܇ Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$X訇 f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HRHSHt
HHH
HJ$H;Cu
   H&HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HWHSHt
HHH
HB&H;Cu
   H+HKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xH! H3HEHHE   3Hu@uDF
H8	 HM	$HCHMH;sTHHUH;wHH}H+H;CuVHHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  4)HC HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   HuE A   H7	 HM"HCHMH;sVHHUH;wJH}H+H;Cu
   HHH;HKHtcHA   HqHyrHHH;H;Cu
   HhHKHt'HA   HqHyrHHHU  (HC HMHE   HuE A   HM6	 HM"HUH'HMHE   HuE A   H 6	 HM!HUHHMHE   HuE A   H5	 HM!HUHHMcHMH3 H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    ka  HSHa  H~HFPLF`HHNPP8MHHNP_  HHMHUH   
HUHM0HUH   HFPLHUHNPP(HM!HE HMHM(HULL+tHY HMHEHMHMHULL+t	HY HN(HD$xH^(H]HV LL+tHvY H]EWA(HGH  Hx uE(H HEH   HEHM D(D6	 EYDXO(D$`    DEǆ       Ɔ          DN	 D%}	 D-	 @      WD$hHt3 HHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM' D]HNhr\  fA/  HEH;  LcuIL;wt%HO+ EtHHGHG    H_E~LEN    HUHOW EG(Lcu IL;w t%HO EtHHGHG    H_ E~LE N    HUHO4W LcuIL;w8t%HO0y EtHDHG0HG0    H_8E~LEN    HUHO0V Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      H_  HEH;  HWHMLbG(EHWHM5bHM   H   H;t=HOH   b   G(HOH   aHO0H   aLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      H_  H   H;t=HWH   iaG(   HWH   LaH   HW0<a     uf/w(\QU (HNhY  f/v=H   HM8`   EXH   HMH`H   HM``f/v\(rX(\(r(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM] HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  z fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  z fA/v"HL$h    9   }H]HL$h D$`   fnu^HE0H;t1HOHU8^EXG(HOHUH^HO0HU`^HY     V0WK	 HV(IHL$x HM
 HM  HM H    H    H    HM` HMH HM8 H    H    H    HM} HMs HMi IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5А	 EW=̐	 E   I$HEI|$HFH;t'H;tHW Ht
H"HL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$`D& H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMw    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMv EHSxHExHD$(H  HD$ L   L   HMB YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(HD t0Eu"A   EEH)	 H   vA  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HMc HtH.HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHbHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I?  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Ae  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`I Y   SxE3[e  H   HCxMHH`  Kp\KhT
ѕ	    f/vA      8  f/vA   y  f/vA
   cH  H9   rA(   KH_  (  5	 Yf/vA   !H_  @  Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   H IcH  $  HA   H%	 vAO   H(%	 gAO   Hi%	 XA6   H%	 IAD   H%	 :AC   H&	 +A9   HU&	 AQ   H&	 
A   H&	 HC   HLKDHH0[  |         HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H;	 H   EotEH   0LcHsHH{Lsp5P	 EW=L	 E   I$HEI|$HFH;t'H;tH Ht
H袾HL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$` H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMn    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMBn EHSxHExHD$(H   HD$ L   L   HM: YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H; t0Eu"A   EEH!	 H   A  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtH讻HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$`K M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I迆  (HEHEL9}t HEHD$hHEHD$xHL$`B D(A(WfQH   LEHUHE   A<b  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`@ Y   SxE3a  H   HCxMHHb`  Kp\KhT
Q	    f/vA        f/vA   y   f/vA
   cH   H9   rA(   KH_    5$	 Yf/vA   !HB_     Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]HHHWATAUAVAWHPH@HXHhHp LLE3D`LBL+H*HIHHH?H衷D$    AINI+HHHHH?H!  AI     IHHL$0p  HIHH;tDHHtLCL+I
L#LcLcHHHGHCHGHCL'LgLgHL$0HtJHD$@H+HI;   H    H=   r uhHAH;sXH+HrHH'w;H
 HHINI+H*HHHH?HH;s(     IL\$PI[8Ik@IsHIA_A^A]A\_LSH   ICHAC    HS ICHp ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$XF H HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    HqU HL$( @SH0HD$ HٹX   l HD$@HSH#b  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HA(HA@HcPH HD
@HA@HcPDBDD
<H HH HA(H0 H& HHKHtHP tHC    H0[LSH   ICHAC    Hs ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$Xf H HD$(H{ HD$PHD$hHcHH. HDhHD$hHcHDd    HyQ HL$( @SH0HD$ HٹX    HD$@HSH`  HHtH@@HcHHB@HH0[@SH0HD$ HHW HH HA(HA@HcPHz HD
@HA@HcPDBDD
<H HH HA(H0 HF HHKHtHP tHC    H0[LH   ICAC    HQH ICH ICAC   IK{H HD$(H HD$@HD$hHcHH{ HDhHD$hHcHDd    H^P HL$(	 @SH0HD$ HٹX    HD$@HSH`  HHtH@@HcHHB@HH0[@SH0HD$ HH7 HH HAHA@HcPH HD
@HA@HcPDBDD
<Hm HH HAHI HtHP tHC     H5 HHKH0[H%
 @SHpH H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8e_ @-H$   u	HHHtHL$`H3+ Hp[2HL$`H3 Hp[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_H	a H\$WH H HH   H HH HAPHI8 HO  HO Hq Ht
   H HH\$0H _H\$WH H HHH HAPHI8j HO ` HOV H Ht
   HJ HH\$0H _H\$WH H HH   H HH HAPHI8 HO  HO H Ht
  H HH\$0H _H\$WH H_ HHH HAPHI8z HO p HOf H Ht
   HZ HH\$0H _H\$Ht$WH0H3HRH\$ H+HHHGH+HHtHHHHHGH+HH;rH\$@HHt$HH0_LHXICLL	IAI+HHIH;rQHx IC3ICICH	 ICD$0ISIK H HD$8HA	 HL$8跨HAI@IHH
HHXHUSVWATAUAVAWHH  HE@)p)xD)@D)xD)hD)XD)HD)8D)(D)H H3H`  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,H		 HD$ L
		 LD$@H	 H
	 GfE/w,H		 HD$ L
d		 LD$HH	 H
Q	 ̋  .HZ		 HD$ L
.		 L  H	 H
	 LHHPHMIHPHME(D=u	 ,s	 T$@fn=q	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGH HE3HEHE H	 HEEHUHMg H HEHMJ HuIHHD$XHHL$`HD$pHD$hHǅ(     L   ƅ   A!   Hr	 H  HH  HP H(  HrSHH  H=   r<tB HAH;r2 H+Hs" H'v H4 Hǅ(     L   ƅ   AC   H	 H  HH  HP H(  HrSHH  H=   r<t HAH;r H+Hs~ H'vq H  EAA   D5u{	 D-p	 @      G D$ L
J	 DEH_	 H
	 +:IGHHHL$ L
W	 DG H	 H
	 IHt$0IGHD$(AGD$ MOMHUH+ HMAu3H8  HHMHH   H8     H8  HD$@HUHeL(HMHHMJH8  HMH@  HULL+t	H/ HMHH  HMHP  HULL+tH/ E؉X  L8  
o	 HMpLHH  ?HHMBH    H   HM( HM fEnEA(}/ ^H8  HD$@HUpHM"L
n	 H  HHM/H8  HMH@  HULL+t	H. HMHH  HMHP  HULL+tH. EX  L8  (HMHLHHM,HHHM( HM H    H   AƙA ;  A(LHI>Z  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(uHtX9HI;IDH;tHuWI*MyXn	 ^HT$XV  D(H H   HR H   H8  f L$PE3H   H   ) H   HcHH H
   H   HcHh
   H   HD$HH   } Hu H   3H   (  PH   HHY H   ,HHu3
H HcHHHW   H   HAH HH +HHu3
H HcHHHW   H  G HHH$ HHu3
H HcHHHW   H   HA(H HHx ?+HHu3
H HcHHHW   H   HHwH HHu3
H HcHHHW   H   H(Hi HH *HHu3
H HcHHHW   H   , HHH	 HHu3
H HcHHHWA(H * +Efn^5wk	 t$H3H  H   H  WH  H  HtD	H  HH  HT$HH  H;sLHT$HH;wBH\$HH+HH;   u   H  H  H  HtHHH1H;   u   H  iH  H  Ht1H  H  HH  HT$@H;sLHT$@H;wBH\$@H+HH;   u   H  H  H  Ht;HH+H;   u   H  H  HtDH  HH  IE L@H
7 H  H;Iu/AfD/vH	 H   d(E2fE/vH	 H   G(E2AG D;~!fE/wfA/vH	 H   (HH   HPE   A(A\A^ATf/f	    HǅP     HH  D8  Aa   H	 H8  HH8  HP H8  HǅP     HH  D8  AH   H	 H8  HH8  HP H8  蜱H  Ht%L   L+IW  H   H8  NH8  Q =e	 H}D;     HǅP     3HH  8  DCiH	 H8  HH8  HP H8  HǅP     HH  8  DCBH	 H8  HH8  HP H8  蜰E2AEu8LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtHM; HM1 HM& HM H`  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH`  Hǀ)p)xHy{ H3H$0  ILL$hEHHT$pLH$   H$   DD$XL$   E3ADt$HE,H HD$ L
h LD$XHd	 H
5	 舼HǄ$     L$  @$  A   HN	 H$  HH$  HP H$  HrTHH$  H=   r<tz HAH;rj H+HsZ H'vM Hl (j	 $  (
vh	 $   ^b	 $  
-f	 $   LHIO  $   I$HPH$    I$HPH$   c	 $  
b	 $  b	 $   WL$xD$@AΉL$D|$@ 
  Hc  $  $   A   D|$`E;  AAHǄ$     L$  Ƅ$   E3H" H$  'HǄ$     L$  Ƅ$   E3H H$  F    EHt$8H$  HD$0H$  HD$(E͋H$  HrTHH$  H=   r<ti HAH;rY H+HsI H'v< H[ HǄ$     L$  Ƅ$   H$  HrUHH$  H=   r<t HAH;rۼ H+Hs˼ H'v H HL$pY $   D$P;  ML$Iq\$P;u4Ht$hHt$0ID$HD$(AD$D$ M$H$   "   H} H$P  H$   |$HE3E3H$X  H$P  S H$P  HcHH HP  H$P  HcHxL  H$X  HD$hH$X   H H$X  L$  Ǆ$     Hu H$P  D H	 H5 HN H& HH H H H$  H$P  VH$  H$  HC$  HD$ L
 LD$PH+	 H
	 'H' H$P  H$  9 |$HE3E3H$X  H$P   H$P  HcHH HP  H$P  HcHxL  H$X  HD$hH$X  E H= H$X  L$  Ǆ$     H H$P  HO	 HH HH H HH$  H$P  H$  H$  HC$  HD$ L
> LD$PH 	 H
 	 B&E3$   D|$`L$   |$HH$   HD$pDl$XH$   Ht$hH$   Au:H$  JHH$   yH$  R H$  7  H$  HD$PH$H  L$   H$   *HH$   ړH$  H$   H$  H$   LL+t	Hu H$   蛓H$  H$   H$  H$   LL+tH6 $   $  L$  $  H$p  ~LHH$  HH$   H$  3 H$  % H$0   H$    fAn (^H$  HD$PH$p  H$   yL$  H$  pHH$   耒H$  H$   H$  H$   LL+t	H H$   AH$  H$   H$  H$   LL+tH $   $  L$  (H$H  *LHH$   WHH\$pHH$0  ߵ H$   ѵ H$  µ H$   AǋL$D?LHIbG  7E3$   L$   |$HH$   H\$pDl$XH$   Ht$h$   f/
  f/$      H$  yHY H$  HH" HL$x> HHt D|$DH$  AH |H6 aHH$  HPHǄ$     L$  Ƅ$   E3H H$  HH$  HP H$  ]D$@ H$8  ;H$8  =   D|$DA}$      f/$   :  H$  SH3 H$  HH HL$x HH& aHH$  HPHǄ$     L$  Ƅ$   E3H H$  HH$  HP H$  ]D$@ H$8  ;H$8  = H$   $  D$xAD|$DIT$H$   HHkH$0   H$    AFL
O H0 n  H$    H$    H$    H$    D$xH$0  H3 ($P  ($@  H`  A_A^A]A\_^[HUSVWATAUAVAWHxHH  HE()p)xD)@D)xD)hD)XD)HD)8D)(D)Hm H3H  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,H HD$ L
 LD$@H H
 wlfE/w,H HD$ L
 LD$HH H
 Dl̋  .H HD$ L
^ L  H H
I |HHPHM+IHPHME(D=X	 \V	 T$@fn=U	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGHJ HE 3HEHEH HEE HUHM H8 HE HM - HuIHHD$XHHL$`HD$pHD$hHǅH     L@  ƅ0   A!   H H0  HH0  HP HH  HrSHH0  H=   r<tr HAH;rb H+HsR H'vE Hd HǅH     L@  ƅ0   AC   H. H0  2HH0  HP HH  HrSHH0  H=   r<tί HAH;r H+Hs H'v H 2 EAA   D5^	 D-DS	 @      G(D$ L
z DEH H
@ [IGHHHL$ L
 DG(HD H
  -Ht$0IGHD$(AGD$ MOMHUHw HMAu3H`  衸HHMHp  ޭ H`    H`  HD$@H`  bL(HM0SHHMwH`  HMHh  HULL+t	H HMHMAHp  LELx  HMH  LHUNL+tH E艅  L`  
3R	 H  LHH0  HHMȻH@   H0  լ HM@ʬ HM0 fEnEA( ^H`  HD$@H  HMUL
Q	 H0  HHMBH`  HMHh  HULL+t	H HMHMHp  LELx  HMH  LHUNL+tH E  L`  (H`  LHHM0HH輼HM@ HM0 H@   H0   AƙA   A(LHIA  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(u)Ht$fff     X9HI;IDH;tHuWI*MyXQ	 ^HT$X9  D(H HE`HF HEpH   ] L$PE3HUxHM`& HE`HcHH HD
`HE`HcHhT
\HExHD$HHMx H HEx3H      PH   HHk HMp.HHu3
H HcHHHW   H   HAH HH HHu3
H HcHHHW   H  \ HHH9 HHu3
H HcHHHW   H  + HA(H HH THHu3
H HcHHHW   H   Υ HHH HHu3
H HcHHHW   H   H(H~ HH  
HHu3
H HcHHHW   H   A HHH HHu3
H HcHHHWA(H ? +Efn^5N	 t$H3H0  H@  H8  WH0  H8  HtD	H8  HH8  HT$HH0  H;sLHT$HH;wBH\$HH+HH;@  u   H0  H8  H0  HtHHH1H;@  u   H0  ~H8  H0  Ht1H8  H0  HH8  HT$@H;sLHT$@H;wBH\$@H+HH;@  u   H0  H8  H0  Ht;HH+H;@  u   H0  H8  HtDH8  HH8  IE L@H
L H0  H;IuAfD/vH- HMp|E2fE/vH+ HMpbE2AG D;~fE/wfA/vH HMp3HHU`HPE   A(A\A^ATf/I	    Hǅx     Hp  D`  Aa   H H`  ;HH`  HP H`  
Hǅx     Hp  D`  AH   H H`  HH`  HP H`  轔H0  Ht%L@  L+I-W0  H@  H   oH   r =H	 H}D;     Hǅx     3Hp  `  DCiH H`  8HH`  HP H`  
Hǅx     Hp  `  DCBH H`  HH`  HP H`  轓E2AEu)LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtHM\ HMR HMG HM= H  H3 L$H  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH  Hǀ)p)xH^ H3H$`  MLL$`EHHT$pLH$   H$   DD$XL$   3t$HE,H HD$ L
 LD$XH H
X 諟HǄ$     H$   @$  A   Hq H$  IH$  IP H$  HrTHH$  H=   r<t HAH;r H+Hs} H'vp H (M	 $   (
K	 $0  E	 $@  
PI	 $   MHI7  $   IHPH$   TIHPH$   ?>F	 $   
F	 $   DE	 $   WL$xD$@ΉL$D    |$@ R
  Hc   $   $   A   Dd$hE;D  AAHǄ$     H$  Ƅ$   E3HB H$  GHǄ$     H$   Ƅ$   E3H H$  F    ELt$8H$  HD$0H$  HD$(E͋.H$  HrTHH$  H=   r<t HAH;ry H+Hsi H'v\ H{ HǄ$     H$   Ƅ$   H$  HrUHH$  H=   r<t HAH;r H+Hs H'vޟ H HL$pY($(  D$P;  MOMq\$PA;u1Lt$`Lt$0IGHD$(AGD$ MH$      H H$`  H$   |$HE3E3H$h  H$`  v H$`  HcHH2 H`  H$`  HcHx\  H$h  HD$`H$h   H H$h  H$  Ǆ$     H H$`  gH  HXHq HIIH H> H.H$  H$`  yH$  H$  HC$  HD$ L
 LD$PHN H
 
HJ H$`  H$  \ |$HE3E3H$h  H$`    H$`  HcHH܋ H`  H$`  HcHx\  H$h  HD$`H$h  h H` H$h  H$  Ǆ$     HB H$`  Hr HH HH H HH$  H$`  $H$  H$  HC$  HD$ L
a LD$PH H
 e	3$   Dd$hL$   |$HH$   HD$pDl$XL$   Lt$`H$   Au:H$  >HH$   }H$  v H$  T  H$  HD$PH$X  L$   H$0  ޶HH$   vH$  H$   H$  H$   LL+t	H  H$   H$   vH$  L$   L$  H$   H$  LH$   NL+tH=  $   $  L$  $   H$  LHH$  "HH$   !H$   : H$  , H$@   H$0   fAn (^H$  H$   警L$   H$  HH$   H$X  ܳL(H$  ILHH$0  vHH\$pHuH$@  n H$0  ` H$  Q H$  C AċL$DMHIq/  63$   L$   |$HH$   H\$pDl$XL$   Lt$`$   f/
  f/$      H$  	H H$  DHH 5HL$xΖ HH Dd$DH$  AH |Hƾ IH$  IPHǄ$     H$  Ƅ$   E3H H$  IH$  IP H$  D$@ H$X  ˔H$X  ͖   Dd$DA}$      f/$   9  H$  H H$  HH HL$x HH IH$  IPHǄ$     H$  Ƅ$   E3H H$  IH$  IP H$  D$@ H$X  ˓H$X  ͕ H$   蠟$   D$xADd$DIWH$0  蘚HHlH$@   H$0  w AL
 H tR  H$   M H$   ? H$  0 H$   " D$xH$`  H3褶 ($  ($p  HĐ  A_A^A]A\_^[H\$
;	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI;  C(WD	 C(H$   H$   H0HHD$XHHCH;t/H;t"H Ht
HTpH3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
+D	 fff     HD$X(WA)HH;}LD$@MHL$hb HĐ   _^[@SH`HBHHD$(Hx uWYT8	 XB(H`[H HL$8HD$@HD$ HD$Pu Y%8	 XC(H`[@SH    Wf.HAxHH   zt9HhPY8	 \h8	 Y   XX8	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
HnHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pHM H3H$P  HHHL$0"sxH HL$@[H( H$0  HL$0]LHHAPH$H  HrUHH$0  H=   r<tJ HAH;r: H+Hs* H'v H< H$   H$    H$P  H3蠱 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHM#} (Y
4	 XK(MHEHH#H      H;v
67	 (  \f/   vƇ   \H(  f/v(\eH(  X \(LXH(   f/vH0   X4	 ($ H0  X  H;t/HSHN HC(HF(HSHN HS0HN0 LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$h[ HMHLHT$hP(HH   HHHHPHKHHHSHL$hZ HHEHsH   HCH;t'H;tH1 Ht
HiHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h H       D  HY(WEHt3t HDiHEH] =d5	 } H  H[WEHt37 HiHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM07}H  L@LEWEMt3׋ HMgHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHM H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(l(Xu \Y(XuuHUH(  HyEf/w"\+ (H   Hhnf/vHE0H;tHU0H6WEH]HHt3 HeLHEH]LEHuHEHEHEHEH;t-I HtHeLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHMU LML   H   H   1HM HM HM`v HMHl HM8b HMW HML L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   HB(  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0$%  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0N LLHH&  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK    ~ HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_QhH0  ap(5	 HL$ (T\f/L$TTHGf/s(^(@SHpahHAHT%Z5	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h 0  f/s(^W
5	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HMoHHEH[IG3H;t'H;tI Ht
HM`II?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
94	 f     HE(WA)HH;}LEMHMu HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHMPM H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHMG Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM6 H(H;~uH>H;~IDHHMtLE'M+IILL$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHM D(=S%	 EtCH]H{ uA(HHEHEHEHMl (A^H]  HG     (A^}gH]H{ uA(HHEHEHEHMl D^DG0DMWEWMHUH@  HM] HMS HEgHEH]HuHOH;uHOMgIHHUF (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   QhH  ap(-	 HL$ (T\f/L$TTHGf/s(^(@SHpahHAHT%j-	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h	   f/s(^W-	 Hp[HWH   H@HXHpHHHHL@@@HPHHq HsHG3H;t'H;tH| Ht
HgXHHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
K,	 fff     HD$`(W)HH;}HL$(HL$8膷 HL$p{ L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$H D(5v 	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;tHHHt3z HVHD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0 E   LuI~ tIHD$PHD$xHD$`HL$Hf (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"Hy Ht
HJUHH    H_H_LEHT$xHJ   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;tHHHt3x HTHD$HH\$PH\$XLEHT$xHL$HG H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;t{IIHGHH;t"HEx Ht
HTHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$Hw ID$HEDMLeLeLEHT$xHħ HL$0w (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    He HA@H#s HAPD$P   bVH HHs HG(HG@HcHHk HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    HVd HA@Hsr HAPD$P   THJk HHe HG(HG@HcHHme HD9@HG@HcHQT9<HHNHH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHc HA@Hq HAPD$P   PHf HHOHl HHG@HcPHn HD:@HG@HcPDBDD:<HSHHD葿HH\$HHt$XH0_HL$AVH@HD$0H\$XHt$`H|$hMHH_  tH7MHH H[HHOH\$XHt$`H|$hH@A^HL$HH	 LL$P)t$0LD$X3)|$ s5$	 =	 Tf/vUu  "   	 LL$PLD$X3FsTf/v'u  "   	 LL$PLD$X3sTf/vt  "   	 LL$PLD$X3rTf/vt  "   	 LL$PLD$X3rTf/vt  "   	 LL$PLD$X3rTf/vot  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
۫ 5p 3Ld$xM+L$3IIHH+II;HCI;LCIPH$   HH+LL$   HHZ-HIL$   L+q LGH3H$   IL+q HHGH+HHHtLGL+IKLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$p.q HOLD$pHH+$   HH+H,H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0p H$   ILkHGL+LI+Hbp H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(BHt$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
 Ul H
 Gl LD$0H|$(IH+HHHDL$pHH 3HthH+HI;vo H    H=   r=@tzo HGH;rjo H+HsZo H'vMo HHi (L\$PI[(Ik0Is8(t$@IA_A^_HSVWATAUAVAWH   HǀH)p)xD)@D)HH) H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ Ht3m HuIHD$@H\$HDd$8A܉\$4D	 fD  A;]  MuAA  ~1ID  H\$@MA(( ;HA;w |ۋ|$0LD$@H$   IbHHL$@HHT$@HPHL$HHHHT$HH$   l HZr H$   Hn H$   H$H  k |$0E3H$   H$   k H$   HcHH0l H   H$   HcHh   H$   HD$hH$   i L5f L$   L$0  D$8  HT$@IM V  (D$hH$  H$   hHXH$  HrTHH$  H=   r<tl HAH;rl H+Hsl H'vl H袓 HtHt$`HH$   HPt$pHD$pH      H#H;u+HӦ HD$ L
 LD$hHó H
 ?&DXDL$P\$4É\$4H$   HcHHj H   H$   HcHh   L$   H$   H$   i H$   h H$H  i 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^IOHy t#HH$   H$   H$   ŕ(fAnw Y5	 
 AXYXAXHL$@j (H$  H3舊 L$   A(sA({E(CE(KIA_A^A]A\_^[HSVWATAUAVAWH  Hǀ@)p)xD)@D)HHo% H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ(Ht3%i HDHD$@H\$HDd$8A܉\$4D>	 fD  A;]  MuAA( ~1ID  H\$@MA((l ;HA;w(|ۋ|$0LD$@H$   IBHHL$@HHT$@HPHL$HHHHT$HH$   jh Hm H$   Hcj H$   H$8  ug |$0E3H$   H$   4g H$   HcHHg H   H$   HcHh   H$   HD$hH$   d L5|b L$   L$   D$(  HT$@IM   (D$hH$  H$   8dHXH$  HrTHH$  H=   r<t0h HAH;r h H+Hsh H'vh H" HtHt$`HH$   HPt$pHD$pH      H#H;u+HS HD$ L
 LD$hHC H
 !DXDL$P\$4É\$4H$   HcHH6f H   H$   HcHh   L$   H$   `H$   :e H$   td H$8  &e 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^IX|(AXHL$@e (H$  H3R L$  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pHY! H3HEIHHE   3Hu@uDFnHw HM>HHUHP@HEHrPHHMH=   r<te HAH;re H+Hse H've HՌ HHPHE   HuE 8 uLIIB<  uHHM蘐HHUHP@HEHrPHHMH=   r<t=e HAH;r-e H+Hse H've H/ HE   HuE A   H HM	HHUHP@HEHrPHHMH=   r<td HAH;rd H+Hsd H'vd H蠋 HE   HuE Ah   H HMzHHUHP@HEHrPHHMH=   r<td HAH;rd H+Hsc H'vc H HE   HuE E3H HMHHUHP@HEHrPHHMH=   r<tc HAH;rc H+Hssc H'vfc H腊 HMH3	 H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ IK  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HOJ` HO@` HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;v` KHH=   r<t` HBH;r` H+Hs` H'v` HHH(陇 H(LHXICHfffffffH;vJHCh IC3ICICH ICD$0ISIK^ H0R HD$8HL$8  Hu3KH;v\ HHH   r&HA'H;w\ H҂ HH'HHA迂 HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"Hx^ Ht
HC:HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHMH HLFhLNH     HFH^HHEH~HCH;t+H;t"H] Ht
Hy9HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
b
	 fHE(WA)HH;}LEMHM襘 H   Hǆ       H E3L\$pI[Is I{(I]He EHEHU3HMHEHEHw HE
\ H[ H
 HEHM @SH 3HHHAHAHt~H
H;vH
O Y HRH|$0H<    H   r#HO'H;wY ! HH'HHAH HHHKHHH|$0HKH [LALIIHQ I+HH;|
IH+HH+IHHAHtL+I<|H\$WH HK HHAPHI8[ HO z[ HOp[ HS Ht
   Hd HH\$0H _@SH HHI%[ HKH [H%[ @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(FE3EL9{~HN(HJJIL;S|HFXLFLN@HV(Hc5		 WAE H^HH+^@HI;^tIY Ht
Hz5IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtH 褾HH\W    cAE $   H$   H#H;t3@HN Ht+H UHHӣ FHHV       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [HhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$PqD WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;tIHHt3V H2HLsHkHnH{ H|$hH|$hL?LHt3V Hc7 HHoHnH{0H|$hL?LHt3V HS2HHoC@   CD HHH HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	聻 uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
G R HH|$0HT$8HHFHHH\$@HNH+H>LHmT H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     HV HD$`HMS D$    E3E3HT$hHL$`S HD$`HcHHXC HD`HD$`HcHDxDD\   HL$hgHHL$`ɹHHw 躹HH诹HH5} 蠹HI蕹HI9R HH~HUPHL$`RHxrH H
\ HL$(3HL$0HL$8HD$@D$HHT$0HL$@R HtP HD$(H
 HL$(܆ @SH`W)t$Pf/D)D$0D(   u+DW_	 3A(WM	 (t$PD(D$0H`[ fA/DW'	 A(v(
 \((t$PD(D$0H`[3bX (t$PD(D$0H`[5i fA/)|$@D)L$ D
 !   fA/vTfD.z   eH%X      HЋ9   %_ AYDY AX  ] eH%X      HЋ9^ 
  A(AY(Y((Y%z (Y
 Y_ X%O X
 X7 YYY X% X
 YX XYX^X% AY  3t
  fA/  w eH%X   = fA/   HЋ   9H   A(A(\AYW	 (Y谶 ((Yp (Y] (Y
J XB X2 A^X
 YYYX	 X
 YYX(Y X
 X X YX YX^X Y   fA/   9 '  A(A(\AYW 	 (Y踵 ((Yh (YU (Y
Z X: X* A^X
- YYYX X
 YYX(Y X X YXX
 ^X Y  = fA/   9   A(A(\5 AY(W' Yȴ ((Y (Y (Y
 X Xz A^X
 YYYXQ X
 YYX(Y X" Xj YXX
J ^X6 Y   9W Z  A(A(A^AY(YWI  ((Y (Ys (Y
 XX XH A^X
{ YYYX X X
G YYYX X
 X(Y4 X YX  YX^XL Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
 o = , H
  <o H
D o =8 ( H
$ (
M 6 N F (  h 
 (
"  
 n qH
 	o = V( H
 (
;  (
  ( 
 (
   
c (
D  
m ,n H
T {n =H ({ H
4 (
=  (O 
 (
Q  ( 
 (
  
 m [H
 m = .( H
 (
  ( 
 (
  ( 
 (
  
 0m H
 m = (? H
 (
  (  t  ( 
 (
   
 (
 
 
 l H\$D$WH`)t$PI)|$@H(D)D$0 f/   (ݯ f.zuJ O  !   t  (E (Wf/ WvW 蓯 D(E3(LHXD\(q D\  ! f/vfWf.zo| (
 Tf/v) D(DWg     ^\ T D(    f/v$((\ \
A (E D(of/= r! f/v(+K 蜮 D(DHL$p臮 D((X \R k \ \== YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
q )t$P)|$@   HD)D$0D)L$ D(ȋ
9    DX
 5B D(A(AYD^A(A(AY謭 & EX
 YYA^X X
 D(L$ X(t$PYYX X
 YY(|$@X AYXXw AYD(D$0\HhH
 i = ( H
 (
 ). ( )
0 (
) )2 )
; "i H8eH%X   
 A   )t$ (HB9    (\5 \- (\- Y\- ((Y%S (Y (Y
u X%% X] Y X
E YX YX% YX YX
 YYY(t$ XX X% X^YY- X(H8H
 Xh =  H
 (
  (z K (| e (^ 
 (
 i  
" (
 [ 
4 kg HH   )xD)@D(DT D)HD(DT
  D)PE(D)XD! fE/D)`D(EYrA(A(A( (    fA/A()$   rL (A(L =   M (A(M (XY=
 YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW= (($   HĨ   @WH  HD$PH$  H
 H3H$p  IHD$     HE HD$`H$   B D$    E3E3HT$hHL$`B HD$`HcHHT2 HD`HD$`HcHDxDD\   HL$hc}HS HL$`HHf 貨HH觨HH-l 蘨HH荨HHe ~HHe oH$P  HL$`AHxrH H
K HL$(3HL$0HL$8HD$@D$HHT$0HL$@A HH HD$(He
 HL$(u H@Hx)p()xD)@D D)HD
 fD/D)PEWA(rPA(\(pԧ (\f/
 vAXfA.z   = Y( ^fA.z   f/54 r
(ZX
8 f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   H H
 D$   . L$   H H
  H  HD$PH
 H3H$p  D$     HB HD$`H$   ? D$    E3E3HT$hHL$`? HD$`HcHHd/ HD`HD$`HcHxT\   HL$huzHj HL$`ӥHH)c ĥHHi 赥HH;i 覥HHb 藥HHz 舥HHb yH$P  HL$`>HxrH H
H HL$(3HL$0HL$8HD$@D$HHT$0HL$@> HE HD$(Ho
 HL$(r HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p5 )xWD)@D' D)HD
A H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4CF H;}&HEHM(HE)HH;|LHMH HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ p E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   `K HHL$(rK H
 HL$(n @SH0HD$     :HH0[@SH0HD$       HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH 3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+I>Je  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHM聂LeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHMLeHEH}IHtHHHEIM;w!H
q 6 H
q 6 H]3MtyIrTIƃIH+foI f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHMHUHFH?HMHthHEH+HH;v8 H    H=   r<t8 HAH;r8 H+Hs8 H'v{8 H_ A   L}XI;      HVHHM?
E3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HDHNHMKHHHMHt		H]L}X1L;Fu
   HjDHNHMXHMHt
HU`	H]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH0^ IL}XL;}s(6 6 6 6 6 HtsL+IHL;v6 J    H=   r=@t6 HGH;r6 H+Hsu6 H'vh6 HH] IM H   IEH+HH?H;v.6 H    H=   r<t6 HAH;r6 H+Hs5 H'v5 H] 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){H
 H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0 f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   C V  H$  H$   !HL;   IM Ht~IEH+HHH;v3 H    H=   r<th3 HAH;rX3 H+HsH3 H'v;3 HZZ Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;v2 H    H=   r<t2 HAH;r2 H+Hs2 H'v2 HY   HQ8 H$  L$  H$   H$  H6 H$   Hk3 H$0  H$  }0 AD|$4E3H$8  H$   :0 H$   HcHH0 H   H$   HcHh  H$8  HD$XH$8  - H+ H$8  H$  $  ML$   H$  HL$P.H$  H$   8-HXH$  HrTHH$  H=   r<t01 HAH;r 1 H+Hs1 H'v1 H"X HtHH$   HPH$   HcHH/ H   H$   HcHh  H* H$8  H$8  fH$8  . H$@  - H$  . H4 H$   H1 H$0  H$  . AD|$4E3H$8  H$   Q. H$   HcHH. H   H$   HcHh  H$8  HD$XH$8  + H) H$8  H$  $  L$   IHL$PE (H$  H$   U+HXH$  HrTHH$  H=   r<tM/ HAH;r=/ H+Hs-/ H'v / H?V HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   H H$  YHH$  HP H$  HǄ$     H$  Ƅ$   A>   H H$  YHH$  HP H$  UHǄ$     H$  Ƅ$   A4   H4 H$  /YHH$  HP H$  H$  )H$  + H$   ņ  H$  +W$  H$  A-. L$  L$   IHL$P. +fn^5U H$  H$  )HXH$  GHtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   H H$  WHH$  HP H$  HǄ$     H$  Ƅ$   A8   H H$  bWHH$  HP H$  2HǄ$     H$  Ƅ$   A4   H H$  WHH$  HP H$  E2HI;EulMtL$  M+II<KH$(  'H$(  ) H$  r'H$  t) H$   VLd$`4  $   J  HǄ$     H$  Ƅ$   E3Hw4 H$  +VHH$  HP H$  H$  >(HV H$  yH(( HH# ^HH$  HPH$  'Y5 HP H$  #HH HH H(' HH HH$  HPHǄ$     H$  Ƅ$   A%   H H$  UHH$  HP H$  HǄ$     H$  Ƅ$   E3H3 H$  THH$  HP H$  HǄ$     H$  Ƅ$   E3H2 H$  mTHH$  HP H$  =H$(  %H$(  !' H$(  %H$(  ' MtL$  M+IIxHH$(  $H$(  & H$  $H$  & H$   蒁D$HL$@T$2   H$  s$H$  u& H$   W3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3H21 H$  RHH$  HP H$  H$  $H H$  H($ HH/ H($ HH@ ۋHH ̋HȋT$@$ HH 谋HH$  HPHǄ$     H$  Ƅ$   Ae   H H$  QHH$  HP H$  H$(  "H$(  $ Hn. H$   3H$   H$   H H$   Ƅ$   H$   H$   $ Hp+ H$   H!
 H$   X HL$pHIPH\$xHt(H$   HL$   L+IHCH$   HtL$   L+I4IH$  H3FE ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH@
 H3H   (MLHT$`HL  L  H  3ۉ\$DH   V"WD$HH\$XLL$HMIH$(H  H    HXH  HrSHH  H=   r<t$ HAH;rx$ H+Hsh$ H'v[$ HzK H   IH   IPH  H   HLAH H;t
HHAАH  HrSHH  H=   r<t# HAH;r# H+Hs# H'v# HJ W  Hǅ      t$(H  HD$ MMIHJ H  H   4HXH  HrSHH  H=   r<t.# HAH;r# H+Hs# H'v# H J H   IH   IPH  H   HLAH H;t
HHAАH  Hr\HH  H=   r<t" HAH;rt" H+Hsd" H'vW" HvI H% E3EDd$@H  H H  ҆H(n HH;tHPH  H  HLAH;t
HHAАH  HrSHH  H=   r<t! HAH;r! H+Hs! H'v! HH HH;tHPHǅ     L  ƅ   E3H* H  aLIH  IP H  HrSHH  H=   r<t  HAH;r  H+Hs  H'v  HG IH  IPHǅ     L  ƅ   E3H-* H  KIH  IP H  HrSHH  H=   r<tL  HAH;r<  H+Hs,  H'v  H>G H  r
   HL$hi H  HcQH  HHP   H   < HH H  nHHuI
H HcHHHW   HM HH H0HHuI
H HcHHHW   HM HH HHHuI
H HcHHHW   HM~ HH H贃HHuI
H HcHHHWHD H舃H  H  HLAH H;t
HHAАH  HrSHH  H=   r<tu HAH;re H+HsU H'vH HgE IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
8  =
 H HEH( HEHMH L$DE3HUHM HEHcHHf HD
HEHcHhT
HEH   HMJ HB HE3HE0E8IHHH   
   HM HMHcQHMHHP   HM LIHMr HHu3
H HcHHIWA   HMN LH   H' HHu3
H HcHHIWA   H    LB+H HHu3
H HcHHIWA   H   LH HHu3
H HcHHIWAB+\Hw H   HMHLAH H;t
HHAАH   
IHUIPB+\Tf/vD$@HMHHMH IHL|$`IGI+HL;H|$hH
6Dl$@H  H\$HHX  eHX  h HX  KHX  N HtL  L+IH:HtLD$XL+IH:HX  HX   AH   H3: L$P  I[XA(sA({IA_A^A]A\_^]HWATAUAVAWH  HǀHXHp)p)xD)@LH5 EWWHHǀX    H`LhHǀp    Hǀx    H
HBH+HHucH" HD$p3HD$xH$   HTU H$   Ƅ$   HT$xH$   I H
 HD$pHT HL$p<HǄ$H     $   HBH+HHwcH! HD$p3HD$xH$   HT H$   Ƅ$   HT$xH$    H} HD$pHYT HL$p   H$H  AD$hW$   E3L$   LcnxIMt*M;v
H
P : IH$   `L$   E3H$   L$   M;  IFI+HH;rcH  HD$p3HD$xH$   HS H$   Ƅ$   HT$xH$    H HD$pH^S HL$pHHH$H  I<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
O  HM+IIHIH+IE3I;LCL;ICH$   _L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
'O  HM+IIHIH+IE3I;LCL;ICH$   ^L$   H$   L$   Ht:HH$   IH$8  }{ AX$   WD$pE3L$   Lcf,MtM;v
H
lN  IHL$pY^MH\$xLt$pM;   H$8  F(D$`HD$`H;sGHD$`L;w=H|$`I+HH;$   u   HL$p7H\$xLt$pHt5IH,H;$   u   HL$ps7H\$xLt$pHt;HH\$xIS |   H~(DH; H
|L 蛔HcH$   [IL$   IH$   H+HHt0LD  A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rE }   DH_: H
\: ߓHcH$  IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;r ~   DF,HfI H
K .HcV,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rՈ    DF,HH H
_J nHcV,H$   -IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rߋ   uo    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  ʴHH$   3       HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  iHH$   3H$8  HtL$H  L+I61A   H)G D;f,`      IcLM+IHD$(D$    DE萏L   L+   IH
F HL$(D$    DbH   tAYtL$   L+$   IH
G HL$(D$    DH$   t6    H_F HD$(D$    DEL   L+   IH
F HL$(D$    D蹎H   tAYtL$   L+$   IH
VG HL$(D$    DuH$   tA   =j f;~(  m    HcL$   L+$   IH
F HL$(D$    D
L$   L'E HH   |LH$   H+$   HMNM+IHD$0H4 HD$(L4 H
4 6	MFM+IH$   Iˏ(LD HH   LH$   H+$   HMNM+IHD$0H44 HD$(L,4 H
)4 MFM+IH$   IQXAYtXL$  L+$  IH
?4 HL$(D$    DҌH$  tmAŋN(    ;}AD  ;}AŋN,f;}AD  ;}    Ǆ$      Dl$`L$   HT$`H$   d $   H$   H$   VL    D$`   D$   LD$`H$   HL$h D$hHT$hH$   
    Dl$`L   HT$`H$   % D$hHT$hH$   Â     D$hDl$`LD$hHT$`H$    D$hHT$hH$   w    Dl$`L   HT$`HL$p D$hHT$hH$   D:    HN`L$   H$   $   H$   H$   H$   Ht(L$   L+I,W$   L$   H$   Ht(L$   L+I+W$   L$   H$  Ht(L$  L+I+W$  L$  H$   Ht(L$   L+Ir+W$   L$   HT$pHtL$   L+I@+H$   HtL$   L+I+D$   H$   H$   H$   q (H$   HtL$0  L+I*(L$  I[8Is@A(sA({E(CIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@2 D($h  H^H+HWL$XLt$hHtHHHH;tXrHHHt3+	 HHD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3 HHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$X謝HVH+HHL$p5ƭ De D$   =  fD/i  Y5 $   fD/  HL$pHHtmH$   H+HH;v H    H=   r<t HAH;rw H+Hsg H'vZ Hy/ HL$0e HL$XY HtqH$   H+HH;v H    H=   r=@t HGH;r H+Hs H'v HH. HtlHD$PH+HH;v H    H=   r<t HCH;rz H+Hsj H'v] HHy. A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI茺(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;v$ H    H=   r<t HAH;r H+Hs H'v H, HL$0 HL$X HtqH$   H+HH;v H    H=   r=@t} HGH;rm H+Hs] H'vP HHl, HtlHD$PH+HH;v' H    H=   r<t HCH;r H+Hs H'v HH+ (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(HHT$(HPAEHT$(H谦HHHT$(P HL$(Ht HT$0LD$8HT$(L+IW!H\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHHNHHT$(HPWD$@Hl$PHT$@HeHLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$HLD$PHT$@L+I WD$@Hl$PHL$(Ht.HT$0LD$8HT$(L+IP WD$(Hl$8H IIN L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
4LP  L8  L0  D  = HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn(f f ,H
H HD$@H( HD$PHM H  E3HT$XHL$@ HD$@HcHH:  HD@HD$@HcHhT<HD$XHD$0HL$X H HD$X3HEEH HL$PeHcHMh HL$PHcQHL$PHHPAHL$Pd HHV{ eHȋ  F    HMx/ HD$0HO| HL$PaeHHu3
H HcHHHD$0HPfAnY^,H HH{ eHD (   H& HEHL$PdHX  HHT$@PHD$@HcHH HD@HD$@HcHhT<H HD$XHL$X6HL$X HL$`) HM HX  L0  HLMHU@HPHIR  H HE@HMH     t5Ǚ  u(H@  HD$ LMI* LIIΝ;   D  D   H
1L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  HH$  W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  BHL8HL$pHHLxHL$xHHLxH$   H$  t HHL$pH' H$   WH$   H@ H$   H$  H! H$  H$  H$  H$  H$   q $(  (
 )$0  W$@  D$H  Ǆ$L      $P  D$X  Ƅ$\   $`  HY H$   HT$pH$   O$8  f/v	$0  $@  f/v f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H^ H$   H H$  H$   y H$   k H$   ] H$   O H H$   HL$p5 H$   HtL$   L+I33HL$p H$   HtL$   L+IiN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHy
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pHHL$tW$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   WD$xH$   LLGIH$   HHHL$xHHHXH$   HHHXH$   H$    HHL$xtH H$   WH$   tH H$P  H$`  H H$X  HD$pH$h  HD$pH$p   $x  (
| )$  W$  $  Ǆ$      $  $  Ƅ$   $  H H$   WH$  L5 L$   L=h L$  HT$xH$   螫$X  f/v	$  $`  =ݛ f/vf/v	$  $  $h  Oȉ$  Y
ޜ (,\ $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   $ L$   L$  H$p  + H$`   H$  H H$   H H$X  H$8   H$(   H$   H$    Hc H$   HL$x H$   HtL$   L+I33HL$xn H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  
HH$  	W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   WD$pLLGHH$h  zHL8HL$pHHLxHL$xH$h  | HHL$pH7 H$   WH$   H H$   H$  Hi H$   H$  H$  H$  H$  (
 )$   (
+ )$0  D$@  Ǆ$D      $H  D$P  Ƅ$T   W$X  H H$   HT$pH$   $(  f/v	$(  $0  f/v f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     Hq H$   H H$   H$    H$   ~ H$   p H$   b H H$   HL$pH H$   HtL$   L+I33HL$p H$   HtL$   L+I|N   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p	HHL$tW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   蓹WD$xLLFIH$   HHHL$xHHHXH$   H$    HHL$xH H$   VH$   \H H$8  H$H  H H$@  HD$pH$P  HD$pH$X  ( )$`  (
ƕ )$p  $  Ǆ$     L $  $  Ƅ$   W$  HY H$   VH$  !L5 L$   L= L$  HT$xH$   q$8  f/v	$h  $@  = f/vf/v	$x  $  $H  Oȉ$  Y
 (_R $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   5  L$   L$  H$X  ^ H$H  P H$   ;H H$   H H$@  H$(   H$  	 H$    H$    H H$   HL$x H$   HtL$   L+I933HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3 HHHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHMyg H! H]HL$xHEHL$xHMHT$pLL+t
HN HT$pWEH WEHE    HMBHHUHPAEHUIIE HUIP HMHtHU1LEHUL+IH]HM0HEHMHMHULL+tHM EEfEMLHUHM
 D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H    +fDnED^V HMH   HIP  H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H    r +fn^5 LM(A(8LM(A(((A(HM،H HEHM L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CH'
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HyI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  [c II耥  L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   Zb H H$   H$   轿H$   H$   H$   HT$xLL+t
H[I HT$xW$   H H$   LMH$   H$   H$   LMHH$   P D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I R +fDnED^ Aƅ    A   iH AExH$   ,H$   IlPIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4 +fn^5Ԉ L$   (A(HL$   (A(4(A(H$   H H$   H$     H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   =WD$pL$   LLFIH$  tHL HL$pHHL`HL$xHHL`H$   H$   HHL$p1HY H$   VH$   1Hr H$   H$  HS H$  H$  H$  H$  H$    $(  (
3 )$0  W$@  =? $H  $X  Ǆ$P  
   H H$   HT$pH$   虓$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H] H$   H H$  H$    H$    H$    H$    H7 H$   HL$pt H$   HtL$   L+I33HL$pB H$   HtL$   L+IN   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t*W$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   触WD$xH$   MLFIH$   ޽HHHL$xHHHXH$   HHHXH$   H$   
 IHL$xH H$   VH$  蘎H H$`  H$p  H H$h  HD$pH$x  HD$pH$  ~ $  (
 )$  W$  = $  $  Ǆ$  
   H H$   VH$  (L= L$   L% L$  HT$xH$  ؎$X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y

 ([? $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   9 L$   L$  H$x  R H$h  D H$   /H H$   H! H$h  H$H   H$8   H$    H$   H H$   HL$x H$   HtL$   L+I-33HL$x H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   !WD$pLLFIH$h  蠳HH     HL$pHHH@    HL$xH$h   HHL$p5HU H$   VH$   H H$   H$  H H$   H$  H$  H$  H$  (( )$   (
I} )$0  =Az $@  W$P  Ǆ$H  
   H H$   HT$pH$   8$8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H$ H$   H= H$   H$    H$    H$    H$    H6 H$   HL$ps H$   HtL$   L+I33HL$pA H$   HtL$   L+IN   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t*W$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   觜WD$xLMFIH$   &HHHL$xHHHXH$   H$   % HHL$xH H$   AVH$   oH( H$H  L$X  H H$P  HD$pH$`  HD$pH$h  (z )$p  (
x )$  =u $  W$  Ǆ$  
   H H$   AVH$  IL= L$   L% L$  HT$xH$   $8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
.v (|5 $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   H$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$   j
 L$   L$  H$`  s H$P  e H$  PH H$   H H$P  H$8  , H$(   H$   H$    H H$   HL$x H$   HtL$   L+IN33HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HiI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KJ IIp  L$   H$   H$   L$   WD$xHt3 H聧HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JI H H$   H$   警H$   H$   H$   HT$xLL+t
HK0 HT$xW$   H H$   LMH$   H$   H$   hLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IB +fDnED^p Aƅ    A   Y/ AExH$   hH$   I\7IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$v +fn^5o L$   (A(8jL$   (A($j(A(H$   nH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[HWATAUAVAWH  HǀHXHp)pH
 H3H$p  MLL$xL$   H$   HL$@H$  H$   H$  H$   L$  L$  H$   H$   D$0    HU HHHT H;T r
   W'HHL$8Ht
n .H3D$8P   E$HC H
(D GGIc$HL$`ٝ3LD$hIHL$`H+HHt-@ f     HHLD$hIHL$`H+HH;r3L+IMtfHHHD$hHL$`H+HH;rD$8Q   DHC H
nE FHcHL$H83HD$PH|$HH+HHtHHHD$PH|$HH+HH;r3HD$PH+HHtHHHD$PH|$HH+HH;r   55v H
F A;4$   D$8T   HcMFM+IHL$(D$    D	EIL<MEM+E IH
g HL$(D$    DDMu LD$hL+D$`IH
G HL$(D$    DDH|$`ALWMGH$   <>H HDH|$HLt$x.A   Ll$xH*H$   D;8  D$8W   IcH$   L HHI+HHHHHH?H  F;  HCH@IH$   L LpM+I-  AF;!    F;  H[M4Ht$PH+H   F;   LD$`H$   `
  LH$   HL$xK5HMIVH$   4
  LH$   H$   5ATHH$   <LHH$   4H HDAH|$HHF H$   H H$   H$x   D$0   E3H$   H$    H$   HcHH H   H$   HcHh   H$   HD$@H$    H H$   3H$`  $h  H H$   (   HL H$  H$   藿L$  H$  LC$  HC HD$ DË?H H$  H H$  H$x   D$0   E3H$  H$  w H$  HcHH H  H$  HcHh  H$  HD$@H$  Ǿ H H$  3H$`  $h  Hg H$  r'   H$ H$  H$  oL$  H$(  LC$  HA HD$ DË=H H$  H H$  H$x   D$0   E3H$  H$  O H$  HcHH H  H$  HcHh  H$  HD$@H$   H H$  3H$`  $h  H? H$  J&   H H$0  H$  GL$0  H$H  LC$0  Hy@ HD$ DA<H H$  HV H$  H$x  h D$0   E3H$  H$  & H$  HcHH H  H$  HcHh  H$  HD$@H$  v Hn H$  3H$`  $h  H H$  !%   Hӽ H$P  H$  L$P  H$h  LC$P  H> HD$ DË;D$8Z   HT$HH|$@Hb HL$HHHtyHD$XH+HH;vο H    H=   r<t HAH;r H+Hs H'v H WD$H3HD$XHL$`HtiHD$pH+HH;vK H    H=   r<t/ HAH;r H+Hs H'v H! HH$p  H3 L$  I[8Is@A(sIA_A^A]A\_H\$WH@LIL L+	HHBH
 H+HHHD$0Hl IHD$(FHK3H+HHt%@ HHHHHHKH+HH;rH\$PH@_HLH L@HPHHSVWATAUAVAWH   Hǀ()pMMLD$p    HdJ HHHVJ H;GJ r
   HH$  Ht
d F$H3Ǆ$  9   H$  DH= H
/> <HcHL$@)3LD$HIHL$@H+HHt-@ f     HHLD$HIHL$@H+HH;r3L+IMtfHHHD$HHL$@H+HH;rǄ$  :   H$  DHr< H
< ;HcHL$X}3LD$`IHL$XH+HHt!HHLD$`IHL$XH+HH;r3L+IMtfHHHD$`HL$XH+HH;rǄ$  <   H|$(H$  HD$ MMIH$     HHHH+HLL$HL+L$@IHL$0H HD$(L H
 谵3HD$HHT$@H+HHt,     HHHHHD$HHT$@H+HH;rH$   HtL$   L+I   L$  5_ L=< Ll; I*;>  Ǆ$  >   HcIMI+M IHHHH?HLD$(D$    DDD9H[IE H4L$  MFM+IL|$(D$    D9M>IMI+M IHHLI?LHf; HD$(D$    D8H[IE L4L$  MD$M+$IH
; HL$(D$    D8I$HD$xLD$`L+D$XIH
; HL$(D$    De8Ld$XLD$@HVH$   *  LH$p  H$   *LALH$   .HL$x  IVH$     LH$h  H$   )HH$   2LHH$   0HH$   DKL(H$   *LHD$xLH$   -H IDH$  Ǆ$  A   HT$XL$`  Io  HL$XHHt{HD$hH+HH;v۸ H    H=   r<t HAH;r H+Hs H'v H WD$XHD$h    HL$@HtiHD$PH+HH;vV H    H=   r<t: HAH;r* H+Hs H'v
 H, I($  H   A_A^A]A\_^[@WHPHD$@H\$hHt$pIHHI@I+ HLJL+
IHD$0H HD$(L H
 THC HH0HC H;C r
0   LHHL$`HtHLOL+ILE  3HHH\$hHt$pHP_@SH0HD$     HH0[HWATAUAVAWH  HD$pHXHp)pHq
 H3H$  MMHHL$8L$`  L$h  D$4    D$0   EH"8 H
8 5IcHL$XU3LD$`IHT$XH+HH      Ht/L@      IHLD$`IHT$XH+HH;r3L+IMtfHHHD$`H+D$XHH;rD$0   EAHW H
7 4AHcHL$@裟E3HL$HHHT$@H+HHt&L KIHL$HHHT$@H+HL;rE3HH+HHt.Lfff     KIHL$HHHT$@H+HL;rD$0    H+HHf7 HD$(D$    A   D?3HHD$@H   H
|7 A;   D$0"   HcLD$HL+D$@IHL$(D$    D2Ht$@MFM+IH
n7 HL$(D$    D2ItXtHcLD$HL+D$@IH
 7 HL$(D$    D2HD$@tHAU    A9  Lt$`HT$X%iX D$0(   HcI|$I+<$Hm  G;b  M$H|$HLD$@I+H  G;  Hc  G;  ADA^D(\AL\YL+Is  AF;g  \D$0)   Lt$`IHT$XH+H|G;}XTA;  H H$   H2 H$   H$  D D$4    E3H$   H$    H$   HcHH~ H   H$   HcHhT|H$   HD$8H$   U HM H$   3H$   $  H H$       H H$  H$   L$  H$  LC$  Hg5 HD$ DËl-H H$  H
 H$  H$   D$4   E3H$  H$  ݯ H$  HcHHY H  H$  HcHh|  H$  HD$8H$  - H% H$  3H$   $  H H$     H H$  H$  լL$  H$  LC$  H3 HD$ DAC,H[ H$  H H$  H$   D$4   E3H$  H$   H$  HcHH0 H  H$  HcHh|  H$  HD$8H$   H H$  3H$   $  H H$     Ha H$  H$  謫L$  H$  LC$  H2 HD$ DƋ+H3 H$  H H$  H$  έ D$4   E3H$  H$   H$  HcHH H  H$  HcHh|  H$  HD$8H$  ܪ HԨ H$  3H$   $  H| H$     H9 H$  H$  脪L$  H$  LC$  HV1 HD$ DË)H H$  H H$  H$   D$4   E3H$  H$  d H$  HcHH H  H$  HcHh|  H$  HD$8H$   H H$  3H$   $  HT H$  _   H H$  H$  \L$  H$  LC$  H*O HD$ DË(D$0+   HT$XHt$8H0HT$@Ht!LD$PL+IWD$@3HD$PHT$XHtLD$hL+IHH$  H3 L$  I[8Is@A(sIA_A^A]A\_H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtH  % uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$ WATAWH eH%X   HD
I Iع   HNB	9 8   HHH9LH-7 HLL%7 IL=7 L;HLH0  HELt$@H?L   IIL;LLM;~8IHIHHuI H   IH+HHHIHH+HLLH>IHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLLt$@II;~/HIHHtIH   H+HHHL+L   M;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+LH\$HHl$PHt$XH A_A\_H
5  =5 H

5 pH
5   Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05M f     IM(W Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05M f     IM(WO Hv;}(|(t$0Ht$hH\$`MHT$ H IHHIINHPHHHL$ IVQ Hl$pH@A_A^_H   "A)(YUM ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YYHM Y=L \A(YL ^X^^A(\AX(YY\e H$   (D#L XDK (\D H$   A(YA(^WGV (YA^A^XX^YWV AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM1  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHKHH@  HEHCHEHLL+t	 E3EH  D=S D5uH @ f     H   H HEuIHEI^HGH;t'H;tH Ht
HNHL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHM LMHH   H}HtAXAY
HuLuI~ uA("HHEIHEHEHEHMF/  (A$A(H   YH(  X	f/   fA/r	E   (T
OR A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHF D(Y5XH A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(mD H\$    LMHH	 DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(Hi\
 H3H$X  MMHHH$  H\$ HL$0蓞H$0  HD$@H$8  MMHH$0   H$0  HL$0ĜHxH$H  HrTHH$0  H=   r<t HAH;r H+Hs H'v H HtHHT$0HPH$   mH$   o H$X  H3 H`  A_A^_^[HL@SVWATAUAVAWH  Hǀp)p)xH[
 H3H$  IH$(  LH$0  H$  H$X  H$   H$`  H|$PA D$ L
 DB H H
 
HCHD$ L
 EE H H
 {Ic] W$   Ht3v HFzHH$   H$   H$   W($   HL$XHD$XH$   H$   H$   HD$0H$   H$   H$   HHH+HHHE3AH~!f)HH;}$   HL$XLH$    Ic] WD$8Ht3 HkyHHD$8HL$8H\$@(|$XH$   H$   H$   HD$XH$   HD$0H$   HD$8H$   HHH+HHHIH~'fD  f)HH;}D$XH$   LH$   ? Ic] W$   Ht3ɜ HxHH$   H$   H$   (|$XH$   H$   H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$   _ Ic] W$  Ht3 HwHH$  H$  H$  (|$XH$   H$   H$   HD$XH$   HD$0H$   H$  H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$    Ic] W$   Ht3	 HvHH$   H$   H$   (|$XH$h  H$h  H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$h  LH$    EDt$4D$   5n? I      @      $P  D;  AA}  ~LIL$   fff     H$  M((z HA;u |I      H|$PL$  H$   IHH$   HH$   HPH$   HHH$   H$   ^ H$  蘗H$@  H$x  H$  H$  L$   L$   H$   H$x   H$  H$  譕HXH$  ܈HtHH$  HPIL$   L$    I;sQHcA$   H$   I#I;u*H HD$(LL$   H H
t ?VHL$  H$   H$   H$   H$   H$  H$   HD$HH$   H$   H$   L$   IHH+HHHIH~-@ A(fX)HH;}L$  H$   MH$   d LD$8L$   L$   L$@  L$  L$P  HL$8HL$hHD$hH$  H$8  H$  HD$1H$  H$   H$  LT$@IHH+HHHIH~?     A(fAY(fX)HH;}L$P  L$@  HL$hMH$  ) ADd$4H$8  褓H$8   H|$PE3Dd$4WL$0  H$  H$(  H|$P@fn(T$hH$   H$   H$   H$  HD$hH$  HD$1H$  H$   H$  L$   IHH+HHHIH~.f(f(f^)HH;}D$hH$   H$   T$hHL$8H$   H$   H$  HD$hH$  HD$1H$  HD$8H$  LD$@IHH+HHHIH~,(f(f^)HH;}T$hH$   H$  & HD$8HD$PHL$8H$@  IMH$X  IUH9T$@tA   HL$PH HD$PHHL$hHL$hH$  H$8  H$  HL$1H$  HL$PH$  HpHHH+HHHIH~J    H$X  ()$   H$    H$@  (fYHD$h)HH;|LHH$  C HD$8H$  t$hHL$8H$   H$   H$  HD$hH$  HD$1H$  H$  H$  LD$@IHH+HHH~6     (fB(fXB)IL;}t$hH$   HH$  b H$   H$(  蝳HT$8H$(  H$   4 H$  % H$    HL$8
 H$    H$  H3胳 ($  ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
Q  HMALM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMLMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHM&LMHMLEHtHHLMLEHMHHMHHcI;F}!H
 : H
 , WEHE    LEHUI  (HMH   HEH+HH?H;vs H    H=   r<tW HAH;rG H+Hs7 H'v* HI WEHE    HMHthHEH+HI;v H    H=   r<t֐ HAH;rƐ H+Hs H'v Hȷ (L\$pI[ Is(I{0Mc8(t$`IA_A^]HL@SVWATAUAVAWH  Hǀp)p)xHUK
 H3H$h  IH$   LH$   H$   H$  H$   H$   H$   A(D$ L
 DB(H# H
D HCHD$ L
 EG(H H
 
Ic_(W$   Ht3 HjHH$   H$   H$   W($@  H$   H$   HD$8H$@  HD$@HD$0HD$HH$   HD$PHHH+HHHE3AH~&ff)HH;}$@  H$   LHL$8O Ic_(WD$XLt$hHt?HHHHH;tHtHHHH;tHHHt3 H\iHHD$XHL$XH\$`H\$h($   H$@  H$H  H$@  HD$8H$   HD$@HD$0HD$HHD$XHD$PHHH+HHHIH~$f)HH;}$   H$@  LHL$8/ Ic_(WD$pHt3 HhHHD$pHL$pH\$x($   H$@  H$@  HD$8H$   HD$@HD$0HD$HHD$pHD$PHHH+HHHIH~1@ f     f)HH;}$   H$@  LHL$8_ Ic_(W$   Ht3 HgHH$   H$   H$   ($   H$@  H$@  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$@  LHL$8 Ic_(W$   Ht3	 HfHH$   H$   H$   ($   H$  H$  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$  LHL$8蟿 EDt$4D$   5n/ I      @      $  D;  AA( ~GIL$   fff     H$   M((z  HA;w(|I      L$   HT$8IJHH$   HH$   HPH$   HHH$   HL$8i H$@  裇H$  H$(  H$P  H$0  LL$pL$@  H$   H$(   H$@  H$@  軅HXH$@  xHtH$   HH$@  HPILL$xLD$pI;sNHcA$@  H$@  I#I;u'H HD$(LLD$pH H
 QFHL$  H$   H$   H$   H$@  H$  H$H  HD$1H$P  H$   H$X  L$   IHH+HHHIH~/fD  (fAX)HH;}L$  H$   MH$@  T AA( c  MfD  MM?  MYICH   A   IHT$`IHL$XHD$pBH$   BYXIRHT$`IHL$XHD$pBH$   BYDXIHT$`IHL$XH$   BDHD$pBYXIRHT$`IHL$XHD$pBH$   BYDXIIM;M;<IHT$`IHL$XH$   BHD$pBYXIM;~IA;_(ADl$4H$  !H$  # 
E3Dl$4WL$   H$   H$   fn($   H$   H$  H$  HD$8H$   HD$@HD$1HD$HH$   HD$PL$   IHH+HHHIH~/(f(f^)HH;}$   H$  HL$8V $   HL$XH$   HD$`H$   H$   HT$8H$   HT$@HT$1HT$HHT$XHT$PLD$hLIHH+HHHIH~2 (f(f^)HH;}$   H$   HL$8 IIwHT$XL\$`HD$hH$   L$   H$   L$   I;IMLL$@  I   I@H$   LfIMkIL6OLHMIHHH$   fD  (A^XKIII(^DXDDKK(^DXDDJ6I(^DK3IXDDIJ    LH    LIML;$   H$   XL$@  M;}BN   H4   IIHHIHM+(^X  HIIuH$   H$   蔉HT$XH$   rH$   ۂ H$   ̂ HL$p HL$X H$    H$h  H3- ($  ($p  HĐ  A_A^A]A\_^[H   HD$ HH$     HHL$(  H
 HL$(臵 @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@q  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQH g HC(HCH;CuHHCHC H0[@SH H@  HK} HC`H [HL$SH0HD$ HD$P    EtH> HAPH} HA`D$P   J   HK HH HC(HCPHcHHw HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHHN HHQ3HHBHO H]} HHGHFHG HF H^(H\$HHz HHO0HKHtHPHG8HCHG@HCGHC H_l HHq HHH\$PHt$XH0_H\$WH HH HHQ3HHHKHB~ H| HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tH& Ht
HZHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@  IFL\$`I[(HEIF HE HIk0IA^_^@SH Hn HHHNm HAhHIH@~ HK86~ HK ,~ HK"~ Hu HH [@SH Hy HHH^x HA`HIH} HK8} HK } HK} Hku HH [@SH Hj HHHl HAhHIH} HK8v} HK l} HKb} Hu HH [@SH H HHHw HA`HIH } HK8} HK } HK} Ht HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3©HW(HK(HA   HA    HyrHH  IE3苩HH\$HH0_@SH H  H;x HCPH [HL$SH0HD$ HD$P    EtHi HA@Hw HAPD$P   J   H+l HHq HCHC@HcHHp HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH> HHQ3HHBHKz H=n HH{3HHDH^H\$HHm HHOHKHtHPHGHCHGHCG C Hzk HHh HHH\$PHt$XH0_H\$WH H<:  Hv HG`t
h   H觢 HH\$0H _@WH0HD$ H\$@HHf HH~ HA(HI0HtHP tHC0    H HHKy @t
P   H( HH\$@H0_H\$WH H  Hv HGPt
X   H HH\$0H _@WH0HD$ H\$@HH8j HH} HAHI HtHP tHC     HX HHK3y @t
@   Hh HH\$@H0_LH   ICAC    HQHg ICH0u ICAC   IK{H\i HD$(H~ HD$@HD$hHcHHCm HDhHD$hHcHDd    H6	 HL$( @SH0HD$ HٹX   | HD$@HSHC  HHtH@@HcHHB@HH0[@SH0HD$ HHh HH} HAHA@HcPHl HD
@HA@HcPDBDD
<Hh HHK| HAHI HtHP tHC     H HHKH0[H%w @SH0HD$ HH/h HH{ HAHI HtHP tHC     HO HHKH0[H%$w HVWAVH`H@HXHhH&3
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHKqt HD$(nt HHL$ 9tHB    HL$ OHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
d H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHB  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HA  HL$8eHL$(HtHPHtL    HA2HL$XH3 L\$`I[(Ik0IA^_^HVWAVH`H@HXHhH&1
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK lr HD$(ir HHL$ 4tHA    HL$ MHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
b H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHA  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2H@  HL$8cHL$(HtHPHtL    HA2HL$XH3  L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH>  (HH@_ HH_(H    H
 HHH
 H;
 rHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HH]
 HHHP
 H;A
 rHHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   DW   ^   ,A;ALǉ   LCHSHH  gtUHH?        ^,A;ALǉ   Y3     H   H   HH\$PHl$`Ht$hH0A_A^_@SH Hl HHHc H   Hp  Jn H`  =n H  )^Hr HHh HC`HKHn HK8n HK m HKm He HH [Wf/v(      ^   ,;L   H\$WH HHH   HXH   HXH   HH\$0H _XHHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J=  HSHH_HG`LGpHHO`P8LHHO`HHL$@Ls(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;vy \( (=Z f/vNHOx#f/v?HD$@H;t5HKHT$HuD$hC(HKHT$X\HK0HT$pN]s(HHO`Y  X   w0Hn I$I\$H$   HOWGHHHGHCHWHGLL+t W5l At$A|$ HL$p;k HL$X0k HL$H%k IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   R   ^   ,A;ALǉ   LCHSHH  [tUHH@I        ^,A;ALǉ   Y     H   H   HH\$PHl$`Ht$hH0A_A^_@SH HS HHHfp H   Hx  i Hh  i H   YH
V HHX HChHKHri HK8hi HK ^i HKTi H` HH [Wf/v(      ^   ,;L   H\$WH HHH   H1TH   H"TH   HH\$0H _	THUSVWATAUAVAWHhH(  HE)p)xD)@Hb$
 H3HEMILH3t$8F  HSHPH_HGhLGxHHOhP8MHHOhHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PDd DD$XLD$`HL$pLD$xHEHEHT$@HM   HE XC(D$0HHD$0H#H      H;v \( (=u f/vLH   ;f/v:HEH;t1HKHUEC(HKHUxHK0HUk]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM:  HE XC(   w0Hi IE I]H\$0HOCBHHHGHCHWHGLL+t W5X AuA} HM*f HM f HMf IHMH3蟆 L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   MLGHWHH  }]t8HH6     Y     H   H   HH\$PHl$`H0A^_^@SH H\ HHHa H   Hx  d Hh  d H   THz` HH _ HC`HKHd HK8d HK d HKd H-\ HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(c(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_bH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@@ HL$0b L$   HHH$   ($   HĠ   _Hl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]XV ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3a H=HHkHF@HD$hHFHD$xHv H;t'H;tHa Ht
Hw=HH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@ HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Y H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWY H   H	H H$   HD$@H$   H$   H$   H$   < Y| H   Wf/v f/v   Wf/v   H\$WH HH4  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHwJfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HkHSHt
HHH
HB$H;Cu
   H?HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HJ$H;Cu
   H趀HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HVHSHt
HHH
HB$H;Ku
   H*HCHt0HH   HCH;s;HH;w3H+HH;Cu
   HHSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    ,  HSIkI^IF`MFpHIN`P8MHIN`&HHMHUH   HUHM0HUH   IF`LHUIN`P(HM7HE HMHM(HULL+tHh HM7HEHMHMHULL+t	H> IN(h7HD$xIN(HMIV LL+t	H EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      D D D%A  D- H}WD$hHt3Z H6HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM蒏 DUINxBfA/  HEH;   HcuH;st$HKY tH5HCHC    Hs~LEN    HUHKg EC(Hcu H;s t$HKY tHq5HCHC    Hs ~LE N    HUHK HcuHH;s8t$HK0SY tH5HC0HC0    Hs8~LEN    HUHK0輾 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I.  HEH;  HSHM'C(EHSHMHM   H   H;t=HKH      C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I-  H   H;t=HSH   CC(   HSH   &H   HS0@  A   uf/w(\) (INxsf/v=H   HM8   EXH   HMHH   HM`f/v\(X(\((XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHM=# HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$hU A   A9   HL$hU Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0W IV(HHL$xT HMT HM T HMT H   T H   T H   T HM`T HMHT HM8zT H   lT H   _T H   RT HMGT HM=T HM3T HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   ;LGHWHH   Dt8HH^2     Y     H   H   HH\$PHl$`H0A^_^@SH HX HHHX H   H  R Hp  R H(  BHB HHA HChHKHR HK8R HK R HKR H=J HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(&Q(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_PH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@P HL$0
Q L$   HHH$   ($   HĠ   _ʻHWH   H@HXHhHp )pIHHz W@Ht3P Hf,HD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrB  H$   H$   HD$8HD$(HD$@HMHT$8T HL$HP HL$(P L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3O Hb+HHoIvHH;t'H;tHlO Ht
H7+HHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   " HIFHD$pHD$x   INHIF@H$   H$    D$0HT$ LL$pL$   IVP HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   Yx H$   \(t$pHĀ   _   LH   H	
 H3H$   HB LB< IKICH@D$@ICISISMCMCIC  HD$h H$   H3m HĘ   Wf/vg f/v   Wf/v   H\$WH HH+0  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HH7fn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HnHSHt
HHH
HB$H;Cu
   HnHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HbnHSHt
HHH
HJ$H;Cu
   H6nHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HmHSHt
HHH
HB$H;Ku
   HmHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HgmHSHt
HHH
HB&H;Cu
   H;mHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w(  HSII^IFhMFxHINhP8MHINh覴HHM:HUH   )HUHM0HUH   
IFhLHUINhP(HM=%HE HMHM(HULL+tH HM%HEHMHMHULL+t	H辮 IN($HD$xIN(HMIV LL+t	H蒮 EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      D D: D% D-8 H}WD$hHt3^H H.$HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM} DUI   迱fA/  HEH;   HcuH;st$HK{G tHG#HCHC    Hs~LEN    HUHK EC(Hcu H;s t$HK"G tH"HCHC    Hs ~LE N    HUHK苬 HcuHH;s8t$HK0F tH"HC0HC0    Hs8~LEN    HUHK09 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I*  HEH;  HSHM褷C(EHSHM荷HM   H   H;t=HKH   h   C(HKH   KHK0H   ;Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I)  H   H;t=HSH   C(   HSH   裶H   HS0蓶@  A   uf/w!(\親 (I   f/v=H   HM8G   EXH   HMH*H   HM`f/v\(8X(\(#(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$h$C A   A9   HL$hC Hx  D$`A   fn}^HE0H;t1HKHU8REXC(HKHUH;HK0HU`.s(HINhXA   AV0W IV(HDHL$x`B HMUB HM JB HM?B H   1B H   $B H   B HM`B HMHB HM8A H   A H   A H   A HMA HMA HMA HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQHG ICHP= ICAC   IKHb HD$(H(D HD$PHD$xHcHH7 HDxHD$xHcHDt    H&	 HL$(2t @SH0HD$ Hٹh   d HD$@HSH-  HHtH@PHcHHBPHH0[@SH0HD$ HHa HHmC HA(HAPHcPH"7 HD
PHAPHcPDBDD
LH, HHkD HA(HI0HtHP tHC0    HH HHKH0[H%? @SH0HD$ HH', HHD HA(HI0HtHP tHC0    HoH HHKH0[H%D? HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  D fA/  HGPLG`HHOPP8MHHOP赩H(HGHLd$ _xLGPHHOHHתEPHHEPH#H      D H;vA(\i * D(ȃ   f/GLcD D  HD$pH;t2HKHT$x訯EC(HKHU葯HK0HU脯HGPLG`HHOPP8MHHOPèHsHt$8H~ u(HHD$PHD$0HD$`HL$H* (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$HM* AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$x:EC(HKHU#HK0HU   HbE HD$03HD$8HD$@H HD$HD$PHT$8HL$H; Hi; HD$0H	 HL$0o HE HD$03HD$8HD$@H HD$HD$PHT$8HL$HQ; H; HD$0H^	 HL$0:o HM; HM; HL$x; L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PH3) HA@HP7 HAPD$P   H+ HHOH92 HHG@HcPH4 HD:@HG@HcPDBDD:<HSHHD!HH\$HHt$XH0_H($ ?T f/ w*F !T f/ w H
 H(HՅ H
&t a2 H H
t M2 H(
L t T  f/P w2
  T f/* wH
 H(HE x3  H8 k3  HL$H(W LD$0HT$8@T f/ vi:  "    LD$0HT$8Te f/ v5:  "    LD$0HT$8T1 f/a v:  "   H
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H8H_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH)HSHt7HHH
HCH\$0H _H;CuH)HKHtHHHCH\$0H _H\$WH H\t
  H_ HH\$0H _H\$WH HW HHH1 HA`HIHz7 HO8p7 HO f7 HO\7 H/ Ht
   HP_ HH\$0H _H\$WH H<t
  H_ HH\$0H _H\$WH HW# HHH% HAhHIH6 HO86 HO 6 HO6 HE. Ht
   H^ HH\$0H _H\$WH HLt
  HR^ HH\$0H _H\$WH H1 HHHx0 HA`HIH5 HO85 HO 5 HO5 H- Ht
   H] HH\$0H _H\$WH H|t
  H] HH\$0H _H\$WH H% HHHH$ HAhHIH:5 HO805 HO &5 HO5 H, Ht
   H] HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PH" HA@H0 HAPD$P   H$ HHOH1: HHG@HcPH( HD:@HG@HcPDBDD:<HSHHD~HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt31 H[
HEH]WEHt3f1 H6
HEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軼(HM/ HM/ (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9Hx蝙Y
 \ Y   X Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`f   EWfA.z  D
 fA/  HG`LGpHHO`P8MHHO`ws(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      Dc H;vA(\ ϓ D(   f/GHcD% HD$`H;t3HKHT$hREC(HKHT$x:HK0HU-HG`LGpHHO`P8MHHO`ls(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$h(EC(HKHT$xHK0HU   HO5 HD$H3HD$PHD$XHx HD$8D$@HT$PHL$8+ HV+ HD$HH	 HL$H~_ H4 HD$H3HD$PHD$XHxx HD$8D$@HT$PHL$8>+ H* HD$HHK	 HL$H'_ HM+ HL$x+ HL$h+ L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pH%	 H3H$P  HHHL$0b)   Hr HL$@蘐H(4) H$0  HL$0'LHHAPH$H  HrUHH$0  H=   r<t+ HAH;rw+ H+Hsg+ H'vZ+ HyR H$   K'H$   M) H$P  H3J H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\άH(  X \(赬XH(   Wf/vH0   X (芎 H0  X  H;t/HSHN/HC(HF(HSHNHS0HN0
LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h' HHEHsH   HCH;t'H;tH' Ht
H\HH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h[  H       D  HY(WEHt3& HHEH] = } H  H[WEHt3& HgHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hW[    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt37% HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMY H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(̧(Xu \蹧(XuuHUH(  HٓEf/w"\苉 (H   Hx΍f/vHE0H;tHU0H3WEH]HHt3# HOLHEH]LEHuHEHEHEHEH;t-ID# HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHMK LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   &HM! HM! HM`! HMH! HM8! HM! HM! L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9H]Y \u Y   Xe Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH	 H3HELHHyHHL$@#   EWfA.z\  D
 fA/H  HFhLFxHHNhP8MHHNh4w(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      D H;vA(D\ 臅 (   fD/GLcDJ fHD$@H;t5HOHT$HD$hG(HOHT$XHO0HT$pHFhLFxHHNhP8MHHNh LGI@H_@HEDELEH]LEHEHEHUHM虞  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM;  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H{D$hG(HOHT$XbHO0HT$pT   H& HE3HEHEHSj HD$0D$8HUHL$0 H HEH	 HMP HO& HE3HEHEHi HD$0D$8HUHL$0 HZ HEH	 HMP HL$p HL$X HL$H HMH3= L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pH	 H3H$P  HHHL$0   H2d HL$@H( H$0  HL$0LHHAPH$H  HrUHH$0  H=   r<t HAH;r H+Hs H'v HC H$   H$    H$P  H3=< H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\.H(  X \(XH(   Wf/vH0   Xr ( H0  X  H;t/HSHN菋HC(HF(HSHNzHS0HN0mLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hB  HMHLHT$hP(HH   HHHHPHKHHHSHL$h HHEHsH   HCH;t'H;tH Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h軖  H       D  HY(WEHt34 HHEH] =$ } H  H[WEHt3 HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hL    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0I}H  L@LEWEMt3 HMfHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMWK H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(,(Xu \(XuuHUH(  H9Ef/w"\z (H   H.f/vHE0H;tHU0HWEH]HHt3 HLHEH]LEHuHEHEHEHEH;t-I HtHoLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM諤 LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM_  LML   H   H   HML HMA HM`6 HMH, HM8" HM HM L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH HAPH HA`D$P   H3 HHO(H HHGPHcPH?	 HD:PHGPHcPDBDD:LHS(HHD\HH\$HHt$XH0_HL$HHg LL$P)t$0LD$X3)|$ t5 = Tf/   O LL$PLD$X3>Tf/   	 LL$PLD$X3Tf/    LL$PLD$X3Tf/   E LL$PLD$X3̽Tf/   7 LL$PLD$X3覽Tf/ws(t$0(|$ HHHo\ H
J  H[\ H
J  HG\ H
J  H3\ H
J  H\ H
J  H\ H
|J  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	H Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@  IVHO   L\$`HI[Is I{(IA^H\$WH H	 HHA`HIHt HO8j HO ` HOV H Ht
   HJ7 HH\$0H _H\$WH H HHAhHIH HO8 HO  HO H Ht
   H6 HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	 Ht
HLHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@I  H\$xHH$   H`_@SH0HD$     HHd  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH
 Ht
HHL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ Պ  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8"z (fo IHFHMEHEUHMHME0HuMH] E H](M@fo
b fEPU`Mp  Xf/FvFHHI;L$8  IHN 踔  ID~DHN0LN@HLF0A   HV 
  H$@  FDHAD~HH   A_A^_^]sH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _
 HH
 HH}
 H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMH HHEHE   HE    E A   HB HM5HE0   HE(    E ; uE3IIB< uHHMI5HEP   HEH    E8 A   H HM853fff     H}H;   H+H   HHuH}HCuHH   LǺ%   H& HH   :
} uH:
r uH:
g u3tH+HHHsHEH}HCEH+Ht+HD$    L
- A   HHM"0H)IE3HUHM88A   H HM8o7IHMXө  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H HH    :u uC:j uC:_ u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM.IIE3HUHM87HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H H HD$0HT$0HM% HHL$`w H 	 HL$`9 HUAVAWHhH@  HD$XHXHpHx H	 H3HE8L= HLEHE   E3LuDuEF"HC HM1HE0   Lu(DuEFH HM1A@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH    : uC: uC: uAtH+HHHsHEH}HCEH+Ht+HD$    L
) A   HHM,H(IE3HUHM5A   H HM4A? tI@ IC<7 uMIHM3HEH}0HCEH
Z
 HL$03HL$8HL$@HD$HD$PHT$8HL$H H`
 HD$0HT$0HM] HHL$` H@	 HL$`t7 @SH0W)t$ f/Ȼ   (vW5 (i  (,t
Xʃ\
(\(f/
[ v\(Y
Z (ri fnY(t$ YH0[Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v(h W;   fD.z  f.zv  D)T$ D fA/L  D
 fA/r4D ff     AX(h fA/XsD(E\n
 eH%X      HЋ9R
   X5 A(AYAY((Y
 (Y
 Y
Y
 X
 X
 X
1
 YYYX
 X
 X
 AYYYX
 X
Ѐ
 X(Y
 AYX̀
 YX
 YXX
 ^YY5  X  D֦ fD/v(Ug E(\D(AXm
 eH%X   צ f/ƹ   HЋ   9
 h  A(A(AYAY((Y
 (Y
 Y
"
 X
 X
 X
 YYYX
 X
 X
Ɗ
 AYYYXY
 X
 X(Y
 X
 YX~
 AYX^YY%= X   9b
 )  EYDWk A(AY((Y\
 (YI
 Y
y
 X1
 X!
 X
y
 YYYX
 X
uy
 AYYX(Yuy
 X
Ey
 XŅ
 XMy
 YX1y
 AYX^AYDY
> AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
6
 ! =*
 (٨ H

 (
 ̃
 (m ރ
  ރ
 ( 
 (
 )}
 (# )
}
 (
 )}
 )
}
 ! UH
 ]! =
 (} H
~
 (
 @
 (Q R
 " R
 (C 
$
 (
 ^
 ^ 
?
 (
( `
 
I
 p  H
,
   = 
 (O H

 (
ѧ 
 ( 
 (Ů 
 (
' Xw
 8 
9w
 (
 Zw
 
Cw
  IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
 A(.   c f.zu2   !      f/   (LW0 Hh((Y(T
 fD/vlY
(  f/vVfA.zu3(H       $   H$      E fn "   Yѣ S  L ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ a f.(   u~ f/vpH      $   H$   H#H;  fA/s(a (f/   
 f/  ,H( Y<Z   f/v: f/vZ =  "   D^D\
> AY  H$   W}D D(DX
i YE\A(` 
ߡ Yf/   AYf/wBAYA(\5m (` (A(` 	 (^^Yf/vvfA.zu3*H       $   H$      EË_ fn "   Y (A\A(((` (A(` ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   HE H
7 s L$   HjE H
G s H\$D$WH`)t$PI)|$@H(D)D$0 f/ro(Q_ f.z  (m(Wf/{ WvW _ D(E3(LHqD\(^ D\   f/vfWf.z0   (
 Tf/v^ D(DW     ^\ T^ D(   . f/v$((\" \
ʝ (
  D(of/=, r!
 f/v(d  %^ D(DHL$p/{^ D((Xs \ۜ ] \^ \=Ɯ YDXH\$xA(D(D$0(t$P(|$@H`_LD$pHr H
K   LD$pHɦ H
2   H(Y LL$0LD$83#(T
 f/
ɞ w
Y/ H(HB H
T1 o  H(YD LL$0LD$8ã(T
9 f/
i w
Yϛ H(HB H
1   H\$D$WH`)t$PI)|$@HD)D$0(D D)L$ A(EWfD/   p\ f.zZ  l f/ru(LW H((fY(T
h fD/vY
 	 f/   ^fA.    A(  fD/v ff     ^AXfD/wt$p([ f.(   u~{ f/vpH      $   H$   H#H;  fA/s(M[ (f/   
n f/x  ,H Y<    f/v*o f/Z  D^D\ AY   HL$p3wD
 D(DXE YE\A(Z 
 Yf/vVAYf/  AYA(\5I (Z (A(oZ  (^^Yf/v&   A\A((TZ (A(0Z ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pH H
O R  Hb H
;   LD$pH? H
1 m LD$pHx? H
!A m HL1 H
   Hh H
   H H
͢   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3S H#HD$(Hl$0HT$(H茝  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"H Ht
HHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H Ht
HHH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;tYHtHHHH;tYHHHHGH;t"Hy Ht
HDHH    H_H_HHL$8 HL$(? H$   H`A_A^A]A\_^]@SH Hby  HH [@SH0HD$     zx  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIM7MwMwLuIHHWD$@HD$P    E3E3HT$@HJL\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uHHHF)L;t$HV! HHVHҧH~H$`  H$P  HHHI$I$H;uIT$H;uHWI$ID$'H;t"LIT$! HIT$H*I\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W- 3MtlA(Y5 (Y=t D(D\D
 D9 HfE/v((+ AYA((XI IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  bLLD$XHT$pHHH
L;   IH   IWMIOI+H*HHHH?HH;v HRHH=   r=At I@I;rp L+Is` I'vS LIo I?IIHIHCIGHCIGH;H{H{HL$pH   HT$xH$   LD$pI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'v LI H$   HtwH$   H+HH?H;vE H    H=   r<t) HAH;r H+Hs	 H'v H HL$XHttHD$hH+HHH;v H    H=   r<t HAH;r H+Hs H'v~ H H   HT$HH6HD$PH+HHH;v= HH=   r=@t$ HEH;r H+Hs H'v HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWATAUAVAWH  HǀpHXHp)p)xD)@D)HHL5ҏ EWE(W8HǀH    HPLXHǀ`    Hǀh    H
HBH+HHucH HD$p3HD$xH$   HK$ H$   Ƅ$   HT$xH$   @ H HD$pH# HL$p3HǄ$H     $   HBH+HHwcHy HD$p3HD$xH$   H# H$   Ƅ$   HT$xH$    Ht HD$pHP# HL$p   H$H  AD$hW$   E3L$   McgxIMt*M;v
H
 1 IH$   /L$   E3H$   L$   fD  M;  HFH+HH;rcHx HD$p3HD$xH$   H" H$   Ƅ$   HT$xH$    Hs HD$pHO" HL$p西HHH$H  H<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
  HM+IIHIH+IE3I;LCL;ICH$   t.L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
 r HM+IIHIH+IE3I;LCL;ICH$   -L$   H$   L$   Ht:HH$   IH$8  DXiJ AX$   WD$pE3AL$   IcG,H$   Ht/I;v
H
M  HHL$p:-H$   H$   MH\$xHt$pL;  H$8  (D$`HD$`H;   HD$`H;   Lt$`L+IH;uwHH+HHsgH+HIH+Hs
H
  HSH+HHHIH+HE3H;LCL;ICHL$pl,H$   H\$xHt$pHt8JH/H;u!   HL$pH$   H\$xHt$pHt;HH\$xIH$   jY
 |   I(DH	 H
  cHcH$   E3AL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rX
 }   DH H
 ?bHcH$  IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;rW
 ~   EG,H H
w aIcW,H$   MIL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r5W
    EG,H H
 `IcW,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rA   uojV
    IGxI   I   MG0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  )HH$      U
    IGxI   I   MGHMO0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  ȌHH$   wH$8  HtL$H  L+IA   L-      E;g,W  <U
    IcLL+ILl$(D$    DE]M   M+   IH
" HL$(D$    D]I   tYtL$   L+$   IH
O HL$(D$    Dv]H$   tT
    Ll$(D$    DEF]M   M+   IH
} HL$(D$    D]I   tYtL$   L+$   IH
 HL$(D$    D\H$   tA   L- =Â A;(|  S
    HcL$   L+$   IH
5 HL$(D$    Dd\L$   L HI   ֐HH$   H+$   HLNL+IHD$0Ll$(L H
 LFL+IH$   H,^(L HI   cHH$   H+$   HLNL+IHD$0Ll$(L H
 $LFL+IH$   H]XAYtXL$  L+$  IH
 HL$(D$    D:[H$  tzE3AAO(;}A;}AAO,;}AD  ;}R
    Ǆ$      Dt$`L$   HT$`H$   ԍ  $   H$   H$   Q
    D$`   D$   LD$`H$   HL$h腍  D$hHT$hH$   }sQ
    Dt$`M   HT$`H$   蕎  D$hHT$hH$   =3Q
     D$hDt$`LD$hHT$`H$   i  D$hHT$hH$   P
    Dt$`M   HT$`HL$p茑  D$hHT$hH$   P
    IO`L$   H$  a  $   H$   H$   sH$   Ht(L$   L+IW$   L$   H$   Ht(L$   L+ILW$   L$   H$  Ht(L$  L+IW$  L$  H$   Ht(L$   L+IW$   L$   HT$pHtL$   L+IH$   HtL$   L+ID$   H$   H$   >H$   W  (H$   HtL$0  L+I=(L$  I[8Is@A(sA({E(CE(KIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHFHVH+HL$   I
3HFH+HH   $   D(DXL%HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;v H    H=   r<t HAH;r H+Hs H'v H L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHL(W$   LKL+IL$   IIGMH$   HD$ MH$   IbHSH+HHL$PWD$8HD$H    LCHHL$8,3HKH+HHT$8H  L5qy HIL43 HBX LL$PMHT$8I3HCH+HHl$PHtvMH3 YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8LH -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;vV H    H=   r<t: HBH;r* H+Hs H'v
 HH) HtmHD$`H+HH;v H    H=   r=@t HEH;r H+Hs H'v HH (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  H@	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
{  HQM+IIHL+IHM;HCH;HCHL$@BHL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
 B HQM+IIHL+IHM;HCH;HCHL$@HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   LFLL$`I{`  H$  H$   HXH$  DHtINHH$   PHt$hH\$`H~&Hfff     HHL$@bHcH;|IHHT$@PH$  H$   H!H$  H$   HL$` HT$@HtLD$PL+IH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HiI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KM  IIL$   H$   H$   L$   WD$xHt3 H聪HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JL  H H$   H$   譩H$   H$   H$   HT$xLL+t
HK3 HT$xW$   H H$   LMH$   H$   H$   kLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IB +fDnED^s Aƅ    A   Y2 A   H$   kH$   I蹯IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI!s +fn^5r L$   (A(5mL$   (A(!m(A(H$   qH H$   H$     H$P  H3
 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HYI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  ;H  II萚L$   H$   H$   L$   WD$xHt3 HqHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   :G  H H$   H$   蝤H$   H$   H$   HT$xLL+t
H;. HT$xW$   H~ H$   LMH$   H$   H$   eLMHH$   0 D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^}n Aƅ    A   I- A   H$   	fH$   I	IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIc +fn^5m L$   (A(%hL$   (A(h(A(H$   lH H$   H$   w  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I~ Ht
HII3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  +C  IIL$   H$   H$   L$   WD$xHt3 HaHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   *B  H H$   H$   荟H$   H$   H$   HT$xLL+t
H+) HT$xW$   Hn H$   LMH$   蛿H$   H$   `LMHH$     D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I" +fDnED^mi Aƅ    A   9( A   H$   `H$   I虥IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIS +fn^5h L$   (A(cL$   (A(c(A(H$   gH H$   H$   g  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH|	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"In Ht
H9I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  >  IIpL$   H$   H$   L$   WD$xHt3 HQHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   =  H H$   H$   }H$   H$   H$   HT$xLL+t
H$ HT$xW$   H^ H$   LMH$   苺H$   H$   [LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^]d Aƅ    A   )# A   H$   [H$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIC +fn^5c L$   (A(^L$   (A(](A(H$   bHu H$   H$   W  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
  HHHCHHHHKLHT$`HL$X[  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
 C HHHGHHH_LHT$`HL$X  HGH\$hH@_@SH0HD$     ?  HH0[HWATAUAVAWHp  HǀHXHp)pHWv	 H3H$P  MLD$XHH$   H$  H$   L$  D$0    HG
 HHH|G
 H;mG
 r
   HHL$8Ht
<a o!H3D$8   EE H? H
J@ 9IcU HL$h[3LD$pIHL$hH+HHt HHLD$pIHL$hH+HH;r3L+IMtHHHD$pHL$hH+HH;rD$8   EE AH]j H
? 19AE HcHL$@辏E3HT$HHHL$@H+HHt!JIHT$HHHL$@H+HL;rE3HH+HHt.@ ff     JIHT$HHHL$@H+HL;rD$8    H+HH> HD$(D$    A   D7HHD$@H   H5> H
%? A;]    D$8"   HcMD$M+$IHL$(D$    D:7I$L<LD$HL+D$@IHt$(D$    D7HD$@L4HcLD$HL+IH*> HD$(D$    D6H|$@MGIVH$   (H HD3HD$X   5\ H HD$XA;M   D$8(   DyIcH|$HHT$@H+H  G;  HLHcكw  G;l  HHL$   I6I~H+H  G;  H|$pLt$hI+H  G;  H$   *L(H$   U,HLD$XLH$   :,LHH$   -H IDD$8)   H|$pHL$hH+H|&G;}LAMHT$XHL$`3'AH H$   H H$   H$X  / D$0    E3H$   H$    H$   HcHHi H   H$   HcHh   H$   H$   H$   : H2 H$   3H$@  $H  H H$      H H$  H$   L$  H$  LC$  H< HD$ DËQ1Hi H$  H H$  H$X   D$0   E3H$  H$  ³ H$  HcHH> H  H$  HcHh  H$  HD$`H$   H
 H$  3H$@  $H  H H$     Ho H$  H$  躰L$  H$  LC$  H: HD$ DË)0HA H$  Hʵ H$  H$X  ܲ D$0   E3H$  H$   H$  HcHH H  H$  HcHh  H$  HD$`H$   H H$  3H$@  $H  H H$     HG H$  H$  蒯L$  H$  LC$  Hc HD$ DË/H H$  H H$  H$X   D$0   E3H$  H$  r H$  HcHH H  H$  HcHh  H$  HD$`H$  ® H H$  3H$@  $H  Hb H$  m   H H$  H$  jL$  H$(  LC$  Ht8 HD$ DË-H H$  Hz H$  H$X   D$0   E3H$  H$  J H$  HcHHư H  H$  HcHh  H$  HD$`H$   H H$  3H$@  $H  H: H$  E   H H$0  H$  BL$0  H$H  LC$0  H6 HD$ DË,D$8+   HT$hH$   HHT$@Ht!LD$PL+IWD$@3HD$PHT$hHtLD$xL+I|HH$P  H3y L$p  I[8Is@A(sIA_A^A]A\_@SH`HD$XMHH
AD$0HD$0II#I      I;v#H HD$ LH` H
` fAnT$0HD$0I#I;u'H HD$ L
b H` H
` 臬A*H` HD$ L
4 MH` H
S` VWd$8LD$8LD$@HT$HfnS ^I\Y(YYES (\Y\d$8HHL$8k2  HH`[@SUVWATAVAWH   HD$8)$   )|$pIMHLLBH
IH+H  W(3DHI      HtZ    J@D$0HD$0I#I;tIIH+HL;r#H9 HD$(LH_ H
_   fAnD$0HD$0I#H
w_ I;u#H HD$ L
 MH}_ تE f/w#H HD$ L
 LHg_ :hD$0HD$0I#I;u#H HD$ L
K LH1_ hLLHV_ qHwH+7HA   I;IFHHL$@(Q ^] HHt~LA%\     HcIQfAn\(T(Y\f.zuAf/AGfnYHL$@\HH;r(IHL$@x.  HL$@ GHs9
 HHHe9
 H;V9
 r
   HHL$0Ht
W]H3II($   (|$pHĐ   A_A^A\_^][@SH`HD$XMHH
AD$0HD$0II#I      I;v#H HD$ LH] H
] ڴfAnT$0HD$0I#I;u'H HD$ L
R H] H
|] wAWf/w*HI HD$ L
 MH] H
D] ed$8HD$8HD$@HT$HO ^I\Y(YY9O (\Y\d$8HHL$8_.  HH`[HVWATAVAWH   HD$@HXHh)pIMLLHBH+H  Iy   WL  fAn$$   H      H$   H#H;u*HB HD$ L
 MH\ H
\  3DHOHt>HIcf/v
IL;r#H HD$(LH\ H
Y\ 4gH|$0Me  IHL$`$InI+.H   H;HFHWH;HFHL$HHHt$HH9_v&H
:N fHc(^HH;OrHtcIM     HcHIfAn$\Y(YY\YHD$`\HH;r(IHL$`*  HtLD$XL+IHHL$`A JH5
 HHH5
 H;5
 r
   HH$   Ht
WH3IIL$   I[0Ik@A(sIA_A^A\_^HSUVWATAUAVAWH   HD$H)p)xMMLHLZHML+I  IXILL+Ir  W3DIH      MtdIff     BD$0HD$0I#H;wIIH+HL;r#HL HD$(MH}Z H
fZ   LIMtW@ J@D$0HD$0H#H;tIHH+HL;r#H HD$(MH*Z H
Z   I$@f/w#H HD$ MHZ H
Y H|$@LD$0LT$8HD$0HL$8M;HCHLMHZ H
Y 蟟LMHY H
{Y 膟IHL$XI!t$xHD$xH$   L$   I/I_H+HM>IFI+HH;HFظ   H;HFI$@=J ^[ (Htr%-J D  HcT I\PY(Y\(Y\(YHD$XX(Y\H$   XHH;r(HHL$P%  HL$X GHV2
 HHHH2
 H;92
 r
   HHL$@Ht
W@H3H>H($   ($   H   A_A^A]A\_^][LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHwHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHHH|$`HHH0_^[H\$Ht$WH I-  HHX f@  Ht4HH3HC   Hs@3KHs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	A_  IB  H1H;>u=IP I腑  H$   HD$(LAII_  I  H;uAH^HK I?  H$   HD$(LE3IIf_  I  IP I   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I臐tCHCIIπx H$   HD$(tLE3^  I   LA^  I   IHO 1   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS It=HGIIπx H$   HD$(tLE3]  I6LA]  I&H$   HD$ MHT$8I`  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I*  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3HKHs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aaa  IB  H1H;>u=IP I%  H$   HD$(LAIIa  I  H;uAH^HK Iߍ  H$   HD$(LE3II`  I  IP I袍   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I'tCHCIIπx H$   HD$(tLE3`  I   LA`  I   IHO ь   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS Iat=HGIIπx H$   HD$(tLE3R_  I6LAB_  I&H$   HD$ MHT$8Ia  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HHH H|$`H HH\$XH0A^_^@WH0HD$ H\$XH&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@WH0HD$ H\$XHd&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS= HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSHg HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH7 HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     JwHH0[L$D$HXH      )t$@D$x(HD$xH#)|$0(H;t`D$xHHD$xH#H;woWf/   L$`HD$`H#H;   I
  Y(t$@X(|$0HXH, L
 HD$ LD$`H H
 RH L
 HD$ LD$`H H
i lRH L
 HD$ LD$hHl H
= @RHx L
i HD$ LD$hH@ H
 RHHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(DF A\D)xD)hD)XD)H(D)8ATD   f/  L   WD: D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXYx; ^A(\AY(Y\ fE/(vWE (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y5U9 A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"H Ht
HpHH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@/  H   MMH9?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"H Ht
HRoHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@  H   MMHk8L|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HE:(H   A] (YH   Xf/wXfA/sQH   (AT WNB f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$ WATAWH eH%X   HD
Y	 Iع   HNB	9
   HHH9LH-+
 HLL%(
 IL=&
 L;HLH0  HELt$@HDL   IIL;LLM;~8IHIHHuI H   IH+HHHIHH+HLLH>IHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLLt$@II;~/HIHHtIH   H+HHHL+L   M;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+LH\$HHl$PHt$XH A_A\_H

 蕱 =
 H

 H

  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-D)@HD. Ip     D)HI   D
, D)PD, D)XEWD)d$@D%- D)l$0D-R9 D)t$ D5, )pغ   H  W4   H*AYff        H  WHH*X(AYH5rԺ   HW  WH*LcXEFLcAYB@ BY@ f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zBp B@ fA/Bp (\\YXr*((B\@ Y\YYX\(((B\@ Y\YYX\fD/&fD/w(YAYAW f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=, H%  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLLZ I^WD$(Ht3' HaLHD$(L|$(H\$03HcI;^}UI4HW
 HHHI
 H;:
 r
   HH$   Ht
(>HILD$(H$   IM   H$   HCH$   HI~I;|$t!I$g HtH2aI$I4$I|$H      ?HCH=
 H

 H9

 t	H
  HH+
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|I # L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH 3H$   HH$   HH$   Hp H$   HLCL+H$   7q A   E3H$   HL$0 HD$0HcHHD$0HȺ    HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQDuHL$0 u2HL$0p H$   Q HL$0Q H$   2 2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H  HD$(H;wH
H\$ H;vHH+HH=   HH  H\$@Ht$HH0_@SH HHHSH
Q H3H
HJHH 3HC HC(HC0Hr C8HHp HCHH [@SH0HD$     	  HH0[LL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHTHHH|$PH0_^[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$XY  HL$8( 3($   H   [HIH% H%~ H\$WH Hs~ t
h   H聧 HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    Hk
 LHH^
 H
O
 H;rHLH@
 H
1
 HHH,
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH
 HH0H
 H;p
 r
0   HH\$`Ht!(HtHMm HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    H

 LHH

 H;

 rHLH

 HHH

 H;{

 rHHHo

 3LCIHI+HHt2f     I HIHLCI@I+ HH;rH'

 3H9S~-L3ff     JH9HIHcH;C|H	
 HH0H	
 H;	
 r
0   AHH\$`Ht!(HHk HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHH=	
 LHH/	
 H 	
 H;r   LH	
 H 	
 HHH
 H;r
   [HHKHIHHH

 HH0H

 H;

 r
0    HH\$PHt%(HHj HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$Ht$WH0H3HRH\$ H+HeQHGH+HHt&D  HHHHHHGH+HH;rH\$@HHt$HH0_H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfo* (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   ) II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %( ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PHe HA@H t HAPD$P   OH/h HHOHq} HHG@HcPHl HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHs} HAPH@s HA`D$P   H HHO(Hz HHGPHcPHm HD:PHGPHcPDBDD:LHS(HHDHH\$HHt$XH0_H\$WH HHt HHQ3HHHKHBu Hs HHCHGHC H\$0HG 3HG0HG8HG@Hb GHHHZg HG(HH _H\$WH HHH;Qt>H	u HtHV  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   腙 LHtHHHtHHIHHtHHIH [HL$H( LD$0HT$8p{T9% f/i wU LD$0HT$8H{T% f/A wAw LD$0HT$8 {T$ f/ w-H(H; H
D l  H' H
0 l  H H
 l  LVWATAWHh  Ha0	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  :7E3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XAA
X		AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ 5L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3詑 Hh  A_A\_^HWH   H@HXHhHpIIHIPHH[3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`H-Hl$PH\$HH+HH;ntH0p Ht
HKHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;vp H    H=   r<tp HAH;rtp H+Hsdp H'vWp Hv HHtmHD$XH+HH;v'p H    H=   r<tp HCH;ro H+Hso H'vo HH HL$`HtiHD$pH+HH;vo H    H=   r<to HAH;ro H+Hsto H'vgo H膖 L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHt3m HIHHkHsC  IH!h  HH\$`Hl$hH0A^_^@USVWATAWH$H  Hi)	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  = WDa f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HEH  HE H  IH B<L;~  HH+HNHfo T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
 foLu@MH  EhL  E   M  E  fo
S f      h  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&i  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfo IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   #  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  )2 LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@9  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3΃ H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     b  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  H	 H3HExMH HHEH HHEHE   HE    E 8 uE3IIB<  uHHMVHE0   HE(    E ; uE3I IB< uHHMHEP   HEH    E8 A   Hp HM83@      H}H;   H+H   HHuH}HCuHH   LǺ%   H_ HH   :
- uH:
" uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
܄ A   HHMH)IE3HUHM8襐A   H HM8?IHMX`  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H^ HH    := uC:2 uC:' u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM謆IIE3HUHM8_HE8H}PHCE8H
rg HL$03HL$8HL$@HD$HD$PHT$8HL$H] Hd HD$0HT$0HM_  HHL$`G`  H HL$`茑 @WH@  HD$(H$P  HHD$     HL$@>\   HL$0%[ LD$PMcHHL$PIHPHL$P[ HHL$@jZH$   ZH$   \ HH$P  H@  _Hx)t$`(  f/)|$PWD)D$@D(D)L$0D(v( WK
   fD.z  f.zv  D)T$ D fA/L  D
 fA/r4D ff     AX( fA/XsD(E\	 eH%X      HЋ9	   X5 A(AYAY((Y	 (Y	 Y
	 X	 X	 X
	 YYYXU	 XU	 X
M	 AYYYX(	 X
 	 X(Y9	 AYX	 YX 	 YXX
	 ^YY50  X  D  fD/v(e E(\D(AX	 eH%X     f/ƹ   HЋ   9O	 h  A(A(AYAY((Y	 (Y	 Y
z	 X	 X	 X
R	 YYYX	 X	 X
	 AYYYXa	 X
	 X(Y
	 X	 YX	 AYX^YY%M X   9>	 )  EYDW{
 A(AY((Y	 (Yq	 Y
	 XY	 XI	 X
i	 YYYX%	 X
=	 AYYX(Y=	 X

	 X	 X	 YX	 AYX^AYDY
N AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
	 	| =	 ( H
	 (
 l	 (}	 ~	   ~	 ( 
P	 (
 ):	 (3	 )
	 (
 )>	 )
'	 { UH
	 m{ =	 (	 H
	 (
	 H	 (a	 Z	 2  Z	 (S 
,	 (
 	 n 
	 (
8 	 
	 z H
	 z =	 (_ H
	 (
 "	 (  4	 ( 
	 (
7	  	 H 
	 (
 "	 
	 y IHHh  HD$X)p)x((Wf.zu(. Y   f.z  f.
 z0u.(Wm _((_YY5 (L  f/
i rT=( (_.  (Z  HrDJ J ȃw_HL H(+[     (~\     ((螰     (]     ($     (^     Hc_ HD$03HD$8HD$@H۩ HD$HD$PHT$8HL$HU HO HD$0HT$0H$   諲  H
 HH(H
x HH0@8B  HH$   m  HHL$`  H HL$`D ($P  ($@  Hh  Ð= J W g t  HUVATAUAVAWHxHX  Li3ILLDM   
" HXH      ?HxI)p)x= D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E   S  IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C莇  H;}&f        HE(f)HH;|LHMHT  LM@L  HH  HM` MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL     MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@覷  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMHa  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  xr  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH       9r @   @   H
M HHxHHH\$PH0_HT$WH0HD$ H\$PHHH       q @   @   H
<C HHxHHH\$PH0_HxHD$8)t$`)|$PD)D$@9|$0HD$0II#I      I;v*H HD$ L
 LHs	 H
	 OfDnEDD$0HD$0I#I;u*H HD$ L
U LH;	 H
	 wJA 'HP HD$ L
$ H	 H
v	 IJfn5  ^腲 A\Y	 WX\YY=? \((t$`(|$PD(D$@Hx@SUVWAVH`HD$8)t$P)|$@ILHHHIH+HH  W3DI      HtQfff     BD$0HD$0I#I;t
IL;r#HV HD$(LH H
 諈  fAnD$0HD$0I#I;u*H HD$ L
ӆ MH H
z Hf/w*Hˆ HD$ L
 LH H
F QD$0HD$0I#I;u*H HD$ L
b LHP H
	 LLHn H
 zDH/HH+H   H;HF= ^葰 (HtQfAnҹ	 % ff     (X(\HcL \TY\HH;r(W(t$P(|$@H`A^_^][HH   H@)p)xD)@D)H9xH@II#I      I;v*H< HD$ L
( LHn H
W fDn
EDL$0HD$0I#I;u*H$ HD$ L
 LH6 H
 GA EWfA/w'H҄ HD$ L
 H H
 [5 ^ A\Y
	 AX\YY= \((t$p(|$`D(D$PD(L$@HĈ   HHPHHUVWATAUAVAWH   HD$@HX)p)xMLLLYLII+H  M@M  W3DHH      HtlH@      C$   H$   H#H;wIII+HL;r#Hf HD$(MH H
   fAn$$   H$   H#H;u*HP HD$ L
 MH H
 .ELMt@IfIcf/v
IM;r#H HD$(MH H
s FLt$0MHm  I_I+H   H;HFIVH;HFH$   HL$h2IVHL$P1HLl$hHl$PI9vvZM>HML+=5 Hc(A^AA覬 HH[I;~rH$   L$   L$   HtjMfAn$HIH+	 %4 @      HcA\YY(X(\1Y\HHH;rHtLD$`L+IHfMtLD$xM+IIf(WL$   I[PA(sA({IA_A^A]A\_^]@SUVWATAVAWH`HD$8)t$P)|$@MLLHHyH+HH  MINI+HH  W3DI      HtVIfD  BD$0HD$0I#I;w
IL;r#Hv HD$(MH H
   LHtHfCD$0HD$0I#I;t
IL;r#HV HD$(MHo H
H 諁  A$f/w*H HD$ L
 MHQ H
 H;HBLMHh H
 =LMH7 H
 =I7IH+HI.IFH+HH;HF   H;HFA$=V ^۩ (HtQu	  @ f     Hc\L Y(X(\YY\HH;r(W(t$P(|$@H`A_A^A\_^][H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
@ HDH H H;HBL<LHa LH
 H\$@H0_pi  @SH HALHH$I$IHH;r6H|$0H|$XHO@nHO 2Hj H
  @ H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtJ uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK Ij-t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN f.Hnf I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@HO -He H
މ 0; H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtz uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I(t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN )Ha I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	58 Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@IVHOKb  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ HE H+H=[ H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/L L+L
 L+A:tA:	uHr:IuL L+L
 L+    B:tB:	uHr@-tH      < @-tH       y D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;t豖HIHKH;tH~- Ht
HI	HL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMA  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHMq*    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5_      HG(Hx tL   LHH%\  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H- H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vّHHE HHuxL4    I   w2IFHHH;wHHHՇ H+HD$`HHHE 1IN( HE HuMtcHILuXE3L9?LDL  Lx  H  H    H=     I;vHGHEHu`H    H   w2HCHHH;wHHH H+HD$`HHHEH' HEHuHt蟐3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX= 57 MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  IHUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  H@HHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  L  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} H#HHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  _HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t    t	I H  H3@ H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    H HuHuH\$ H(@SH Hr	  H HCPH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   J   H HH) HCHC@HcHH~ HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH& HHQ3HHBHKL H$ HH{3HHDH^H\$HH" HHOHKHtHPHGHCHGHCG C H HH` HHH\$PHt$XH0_@SH H  H{ HCPH [HL$SH0HD$ HD$P    EtH HA@H; HAPD$P   J   H; HHY HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH~% HHQ3HHBHK H" HH{3HHDH^H\$HH  HHOHKHtHPHGHCHGHCG C H HH HHH\$PHt$XH0_HIH% H\$WH H|  H HGPt
X   HC HH\$0H _@WH0HD$ H\$@HH  HH HAHI HtHP tHC     HH$ HHK# @t
@   HXC HH\$@H0_H\$WH H  H5 HGPt
X   HC HH\$0H _@WH0HD$ H\$@HHx HH HAHI HtHP tHC     H# HHKc @t
@   HB HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ$HHHFHGHHFLL+t H_H\$HHNHHHFHCHVHFLL+t HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$HT$H8IE3IPH+HHtHII      @ f     H@D$HHD$HI#I;wIHL;rH8HS H HD$(H
z V  3HIHtH   H LH   ICAC    HQH ICH0 ICAC   IK;H, HD$(HH HD$@HD$hHcHH
 HDhHD$hHcHDd    Hޒ HL$(K @SH0HD$ HٹX   |; HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHo HH HAHA@HcPH
 HD
@HA@HcPDBDD
<H HHK HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HH? HH HAHI HtHP tHC     HO HHKH0[H%$ LH   ICAC    HQH# ICH@ ICAC   IKH| HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    Hf HL$("I @SH0HD$ HٹX   9 HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPHR HD
@HA@HcPDBDD
<H} HH[ HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HH HH HAHI HtHP tHC     H_ HHKH0[H%4 HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A    H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH H HHt
   9 HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H HHOH	 HHG@HcPHo HD:@HG@HcPDBDD:<HSHHDZHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   HO HHOH HHG@HcPH	 HD:@HG@HcPDBDD:<HSHHDYHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H" H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vwHHMHHumJ    H   w2HCHHH;wHHHm H+HL$`HHHM*H8 HHEHuHtJwH3H9HDHEXH   L   J    H=      M;vwLnMu_J    H   w.HCHHH;wHHHm H+Ll$`IIH
 LHuHtvHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`H3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIK  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H@     t
HMX, H   H3+ H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3
 HsHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xU?  HIHD$hHD$p   INIHD$xH$   
 D$0HT$ LL$hLD$xIV  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v% HA    (|$@D(L$ H`[n HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    v' A    A   A((TŸ T f/vOA^)t$P5ޭ (YXtn fE/
 vW^3YWs(t$PJD^A(AYX ,n fD/Q vW
 ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H H3HE8H HHEL= HLEHE   E3LuDuD80uE
IIF84 uHHM{3HE0   Lu(E A   H HMT3IH}H;   H+H   HHuH}HCuHH   LǺ%   Hf HH    :u uC:j uC:_ uAtH+HHHsHEH}HCEH+Ht+HD$    L
K+ A   HHMa.H(IE3HUHM7A   HK HM5A? tI@ IC<7 uMIHM5HEH}0HCEH
 HL$03HL$8HL$@HD$HD$PHT$8HL$H7 H HD$0HT$0HM  HHL$`?  HЀ HL$`9 @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH	 Mt
IHL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH Mt
IrHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ cLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8q  (foG IHCHMEHEUHMHME0H]MH} E H}(M@fo
 fEPU`Mp;Xf/CvCHIH;HC  l  H$0  HL$H  HADc$L$@  H   A_A]^[]UkOk@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4C  H;}. HD$8HHD$ (HD$ )HH;|LHL$PHՏ  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1HG&HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@   HL$0 LD$PMcHHL$PIHPHL$P HHL$@JH$   lH$   n HH$P  H@  _@SH HHHSH
! H3H
HJHH 3HC HC(HC0H~ C8HH HCHH [@SH0HD$     O  HH0[@SH HHHSH
 H3H
HJHH 3HC HC(HC0H6 C8HH HCHH [@SH0HD$     JN  HH0[H(((T
O f/
 v6f/
 rWf/   ޤ H(b \L H(O f/v(H((Y((Y% (Y
y (Y X% Y X
֠ X YX YX%N YX
* YYY\\\% X YY- ^X(H(H9 H
Ի 73L(DIDAf     A
 f/sffA;uDA  f/sffA;uDAHkAHAR@ HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DY A(a D
 (E(A(Y= A(»   EY(D(T
  f/
P    A(AY` (A(Y%m YXf;vM-h (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_HE H
3 QHHXWH   )pA)xfD)@(D)H(D)PD(DH fD)X   D(D)`DYD((DYYE^Y DW
 _ Y= L$   L$   3D(DY(DY$ ((T
 f/
    Y WA^(Xf;v.ffnYA(EY\AYXf;rDY٠ A(^ Y L$   I[(|$pE(CE(KE(SE([E(cYA(sI_HAD H
2 H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
 EYW=~ (A\AYY ^ YWA(Y (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PY L@D)XD((D(T f/    DY )|$`D)D$PD A(A\EX(A(\ E\Wf.EYD(DYқ zt1AYAYY=Ğ A^(\ AYYr D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxH0B H
0 H   eH%X   
b	 )t$pWA   D)T$0D(HB9t	   fA/vDWo fD.zu (t$pD(T$0HĈ    fA/rfA(L$   AYHn	 H
}	 $   /v  %	 (Y% A(	 AX\\
߃	 Y  D)\$ D fE/rz L$   A(Hq	 AYH
9r	 Y
 \$   ot  %o	 (Y%l A((	 AX\\
?	 Y(  %f E^)|$`A(D)D$PAYD)L$@f/   D((DY
w	 Y~	 DX
w	 X~	 DYYDX
rw	 Xz~	 DYYDX
Pw	 XX~	 DYYDX
.w	 X6~	 DYYDX
w	 X~	 D^   v	 (^D((DYfDXv	 DYDXfDYDXv	 DYDXfDYDX}	 YfX}	 YXfYX}	 YXfYXD^f/   D((DY!~	 Yy	 DX~	 Xhy	 DYYDX}	 XFy	 DYYDX}	 X$y	 DYYDX}	 Xy	 DYYDX}	 Xx	 D^   g}	 ^D((DYfDXW}	 DYDXfDYDXH}	 DYDXfDYDXqx	 YfXnx	 YXfYXcx	 YXfYXD^A(9X (A(	X (A('X - (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
~	 n =~	 g(Π H
~	 (
@ Qy	 (R cy	 K 
Dy	 (
 Uy	 ( 
j	 (
 !j	 (: 
#j	 (
 )n	 ( )
n	 (
Н )	n	 ( )
n	 (
 )l	 (Ɲ )
l	 (
x )l	 ( )
l	 (
 us	 ( 
ws	 (
p ys	 ( 
[z	 (
ě ]z	 (6 
_z	 (
 z	 ( 
z	 (
ܝ z	 (~ 
'v	 (
` )v	  
*v	 
b {	  
|	 
 |	  
~	 
ғ }	 5h	 
~	  rH   eH%X   
[	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D%ϔ B9y}	   fE.E(DTv zu	A(  A fA/)|$prnA(L$   AYHo	 H
l	 $   Xo  %}	 (Y%% A(A(Xz	 \AY\
|	 YY9  D)T$@D@ fE/rnA(L$   AYHv	 H
w	 $   m  %<}	 (Y% A(A(X|	 \AY\
}	 YY   E^)$   A(AY$   A(T (A(S (L$   H=l	 H
q	 An  (L$   (AYHt	 XH
h	 Yn  \YXA(S YF ($   D^AYD(T$@fE/vY=W ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
\{	  =P{	 ( H
<{	 (
y 
k	 ( k	 ̔ 
j	 (
. k	 (/ 
m	 (
Q m	 ( 
m	 (
% )u	 (G )
u	 (
 )u	 ( )
u	 (
ݛ )t	 (ߚ )
t	 (
 )t	 ( )
t	 (
u f	 (' 
f	 (
y f	 (; 
<s	 (
 >s	 (ߙ 
@s	 (
 o	 ( 
o	 (
U o	 ( 
j	 (
٘ j	  
j	 
 w	  
y	 
3 +z	  
y	 
 #z	 D2l	 De	 D%r	 D?o	 D%i	 
y	 u
 D$H   eH%X   
HW	 )|$`=O A   HD)T$0D(B9yy	   WfA/	  fD.z(	   fA/)t$pD)D$P  A(E(^v	 EYfP (A(fA/X(Y^%4    A(A(Y~d	 YFu	 Xfd	 X.u	 AYAYXDd	 Xu	 AYAYX"d	 Xt	 AYAYX d	 Xt	 AYAYXc	 Xt	 ^   c	 A^((YfXc	 YXfYXc	 YXfYXBt	 YfX?t	 YXfYX4t	 YXfYX^lw	 A(Y8 \du	 AX\u	 YYX   fA/   A(AY$   A(^
w	 N (A((XL$   Ho	 H
/f	 Y^-K h  %^w	 (Y% A(v	 AX\\
v	 YYX  D)\$ D fE/   A(AY$   A(^
u	 M (A(T(XL$   Hi	 H
s	 Y^- f  %u	 (Y%Ӌ A(t	 AX\\
t	 YYX  E^D)L$@A(AYf/   D((DY
o	 Yj	 DX
o	 X~j	 DYYDX
o	 X\j	 DYYDX
o	 X:j	 DYYDX
`o	 Xj	 DYYDX
>o	 Xi	 D^   %o	 (^D((DYfDXo	 DYDXfDYDXo	 DYDXfDYDXi	 YfXi	 YXfYXvi	 YXfYXD^f/   D((DYk	 Yf	 DXk	 Xe	 DYYDXk	 Xe	 DYYDX^k	 Xe	 DYYDX<k	 Xe	 DYYDXk	 Xje	 D^   k	 ^D((DYfDXj	 DYDXfDYDXj	 DYDXfDYDXd	 YfXd	 YXfYXd	 YXfYXD^A(J (A({J (A(J  (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
r	  =r	 R( (
G  ^	 ( 2^	 ( n	 ( 
^	 (
ߒ a	 (ѕ 
n	 (
 a	 \ 
n	 (
 ~a	 (W 
Pa	 (
 j	 (; 
i	 (
m )n	 ( 
i	 (
 )n	 (# )
n	 (
 )^e	 (W )
n	 (
Y )be	 ( )
De	 (
M fk	 ( )
He	 (
! jk	 (# 
Lk	 (
 e	 (g 
e	 (
ٍ Bh	 (K 
e	 (
- Fh	 ( 
(h	 (
 rb	  
Sb	 (
t n	  
Ub	 
- Eo	 E 
}p	 
݈ 
o	  
Up	 
 p	 =h	 
p	 
 H
np	  
o	 n	  L$   H= H
~ H H
j D$HxeH%X   
M	 )t$`W)|$P(A   HD)T$ D B9@o	 >  f/~   f/D)D$@   (Y$   (^o	 F (((XL$   HS]	 H
a	 Y^- `  %l	 D(Y% (n	 X\\
|l	 Y^DYDX^  D)L$0D
ֆ fD/   (Y$   (^l	 	F ((X(XL$   HR\	 H
Z	 Y^-ǅ ]  %l	 D(Y% (k	 X\\
3l	 Y^DYDX   D^A(AY$   (}E ((NE (L$   Hc	 H
j	 _  D(L$   (EYHqd	 \H
`	 DY|_  XYD\(E Y D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
l	  =l	 (` H
l	 (
 _	 ( _	  _	 (6 
_	 (
 [	 ( 
Z	 (
L )UY	 ( 
Z	 (
0 )YY	 1 )
:Y	 (
 [Y	 (č )
=Y	 (
 )_Z	 ( )
AZ	 (
 )cZ	 ( )
EZ	 (
 _	 (  
y_	 (
 b	 (t 
}_	 (
 b	 ( 
b	 (
J i	 (܋ 
h	 (
 a	 (` 
i	 (
R a	  
da	 
L Tk	  
h	 
 h	  
h	 
l i	 DY	 DZY	 5^	 Db	 5yh	 D a	 
i	   xL$   HϺ H
 zHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H'  HH   [A(f.- LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((Y Y
~ (\f/w vY H(((H(6  H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
ؗ HDH= H H;HBLCLH LH
 H\$@H0_    @SUVWHx  HD$8Hl H3H$`  IIHHM;H   HL$@H HL$P>HH{ HH) >HH >HH >HHT >H$@  HL$@HCHD$0H$@  H$X  HC$@  HD$ L

 LD$0HH譃H$`  H3,  Hx  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
 l HM2LM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEHtHHLMLEHEHHEHHcI;N}!H
  H
  WEHE    LMLEIIURHMH   HEH+HH?H;v/ H    H=   r<t HAH;r H+Hs H'v H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;r H+Hsr H've H  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	 Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@RH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHH4  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHH 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3a H1HD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM获  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HMQ5  L;}:@      HMHEBEffYfBXB)IL;|LHHM5  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIK!H$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLGA  HL$hg HL$p\ L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH,  HC   HkH{rHH  HHH H H;t    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AI{* AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  (pt I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@SUVWAVAWHh  HD$8H~ H3H$P  IMHLH$  D$0    H HD$@H$    D$0   E3E3HT$HHL$@ HD$@HcHHw HD@HD$@HcHDxDD<   HL$HHHL$@'HH 'HHU| HH 'H$0  HL$@ID$0H$0  H$H  HC$0  Ht$ L
 LD$0I|@SUVWAVAWHh  HD$8H} H3H$P  IMHLH$  D$0    H HD$@H$    D$0   E3E3HT$HHL$@h HD$@HcHH' HD@HD$@HcHDxDD<   HL$H6HHL$@&HHZ &HHU, HHZ m&H$0  HL$@軿IHHT$0H$0  H$H  HC$0  Ht$ LD$0I"LD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H  H HCPH [HL$SH0HD$ HD$P    EtH HA@H˷ HAPD$P   J   H HH1 HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHKl HE HH{3HHDH^H\$HH= HHOHKHtHPHGHCHGHCG C H* HH` HHH\$PHt$XH0_@SH HHHSH
a H3H
HJHHù H HHH [H\$WH H,
  HU HGPt
X   H7  HH\$0H _@WH0HD$ H\$@HHh HH> HAHI HtHP tHC     H HHK @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HH HH HAHI HtHP tHC     H HHKH0[H%԰ LH   ICAC    HQHӞ ICH ICAC   IKkH̞ HD$(HP HD$@HD$hHcHH HDhHD$hHcHDd    H- HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPH
 HD
@HA@HcPDBDD
<H5 HH HAHI HtHP tHC     Hu HHKH0[H%J @SH0HD$ HHϢ HH HAHI HtHP tHC     H HHKH0[H% DD$HL$WH0HD$ H\$HHt$XHH3t$PHӜ HA@H HAPD$P   H HHOH	 HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H0 HAPD$P   ϏHo HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_@WH0HD$ H\$@HHЧ HH HAHI HtHP tHC     H( HHK @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHӚ HA@H HAPD$P   oHϚ HHOHQ HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upHh H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3 H臇HH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HM{AwI_ HSHH;vHHumH    H=   w9H   HHH;w
HHH
 H+HL$@HH$L<    I HHuMtHCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
I HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
K f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CTH;}D$`HD$Hf)HH;|LHL$ H#	  (YX
 f/ArWW AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
a H3H
HJHHå 3HC HC(HC0Hƙ C8HH HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
)K D)PD(D)XD(DYD)`E(D)l$ D((DYYE^Y^M c Y=J L$   L$   3D(DY(DYJ Q((T
hU f/
L    YI H    J WA^(Y5[J X    AYHDXA\EYAY(YXHuDYL A(
 Y`I L$   A({E(CE(KE(SE([E(cD(l$ YA(sIH  H
q 茜HHXHpWH   )pH5B)x3D)@WD)HD(D)PD(EY{
D)XD(D`I DYDYK ff     A(Y3p AX(AY	 Y3` H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
Q H3H
HJHH 3HC HC(HC0H C8HHU HCHH [%@J (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-ZD)@HDD Ip     D)HI   D
D D)PDqF D)XD)d$PEWD)l$@E(D-wG D)t$0D5Q D)|$ D=D )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcBP XY5E YP f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/z` P B` BP (\YX(\\Y\fD/v\(YX\fD/w(AW f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5}= MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  H HCPH [HL$SH0HD$ HD$P    EtH HA@Hۏ HAPD$P   J   H HHQ HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK| H] HH{3HHDH^H\$HHM HHOHKHtHPHGHCHGHCG C H" HH HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3葿H~ H|$HHS HeHS8HOM|HH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3H~ H|$HHS H{HS8HO{HH\$PHt$XH0_H\$WH H,  H HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfoA TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %x@ II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   ? ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQH} ICH  ICAC   IKH̮ HD$(H| HD$@HD$hHcHHS HDhHD$hHcHDd    H> HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH HH{ HAHA@HcPH HD
@HA@HcPDBDD
<HM HH; HAHI HtHP tHC     H HHKH0[H%z H\$Hl$VHA3= HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PHz HA@H  HAPD$P   Hy HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHCy HA@H` HAPD$P   H HHOHx HHG@HcPH} HD:@HG@HcPDBDD:<HSHHD1HH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   HrF H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vHHMHHumJ    H   w2HCHHH;wHHH H+HL$`HHHM*H HHEHuHtH3H9HDHEXH   L   J    H=      M;vULnMu_J    H   w.HCHHH;wHHH^ H+Ll$`IIHۈ LHuHtHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HgG3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpIHHP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   !KHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMX| H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  HB H3HExMHe HHEHf HHEHE   HE    E 8 uE3IIB<  uHHMƱHE0   HE(    E ; uE3I IB< uHHM花HEP   HEH    E8 A   He HM8_3@      H}H;   H+H   HHuH}HCuHH   LǺ%   Hf HH   :
} uH:
r uH:
g u3tH+HHHsHEH}HCEH+Ht+HD$    L
L A   HHMbH)IE3HUHM8A   H HM8诳IHMX3LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H6 HH    : uC: uC:w u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8ϳHE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H/ Ho HD$0HT$0HM%HHL$`wH  HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[A' f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^A+& f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A$ f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0H: H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHHw H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	I} HM H3.  H]`HuhH}p(u0He@A_A^]Hc} HHXHOoiHLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3| HXHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$ 1{ L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3z HpVHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$ x L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D%,  HxEW@      IL$LkM4$Hfo  HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D=R HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  ( C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;tRHIHt3%k HFHLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  H% H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   DL   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;v IHU`HtLmH4    H   w.HFHHH;wIHH H+Ll$`II*Hwh LHuHtHU`IHuX3HIDH   H  H  H    H=     M;v=HUhHtL_J    H   w.HCHHH;wIHHA H+Ld$`II Hg LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   Ir(3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   I&LEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   E*HIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HdHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
Ie    tH   se HM`he HMh^e H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKWLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH:HL$@Rd HL$HL$   I[Is A(sI_H%-d H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	a Ht
HP=HHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;t/a Ht
H<HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"H_ Ht
H;HH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^DD$HL$WH0HD$ H\$HHt$XHH3t$PH#M HA@H@[ HAPD$P   H~ HHOHL HHG@HcPHwQ HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     Av AfYD HH;|Ld$PH;}3IGHp HhIL0 @ YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"HK Ht
H'HH    H|$0HsH\$8H ^LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0H H3HE MLHAp AY1LIIM;v踝H9HHuzJ    H=   w2J   HHH;wHHH赓 H+H|$0HH8J    H*4 HHuHt@HIHFE3EL96LDL}HEH    H=   @@uIM0I;vMM(MufH    H=   w2H   HHH;wHHH H+LL$0II$H    Hi3 LHuHtIE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
I3 @t	I3 HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;t聙IIHOH;tHN0 Ht
HHH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}fo UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HM/    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$8c    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht3- H	HD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%- @UHPHl$ HE H]@HuHH}PH H3HE HHLBHL;v腖L
MumJ    H=   w9J   HHH;w
HHH腌 H+LL$ II$J<    H, LHuHtHC3H9;IDH    H=   LFHHN1   t	H, HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5 MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDXA(YL
X(YDXX

A(YL
YDX(YLXA(YD
XXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+(A(YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YXA(AYL X(YDXXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;tHtHtIHHH;tԈLLMt#3 IwLHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;t\HII;t$I. HtHHEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHMosHMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM2 HM( HM H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$I HtHIE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4COI;} D$XHEf)HI;|LHL$ IOIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CNI;}D$XHEf)HI;|LHL$ IuNMIIII+L;  L@MtHHIL;  IMIH	HWE3LL9G~L
 L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]Y@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH  ( L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   fo f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G/5H;}%ff     EHD$@f)HH;|MHL$XH4HEPLMͤ LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHNEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI   LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5~ )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4G.H;}EHEf)HH;|MHL$PH. L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;tZ\HHHt3- HHHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3N HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$ > L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3 HzHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%H Ht
HnHL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfo. IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI Hfo IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMEI~      RL   L   IH!   H  A_A^[]PLWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK;H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLC1HL$h HL$p L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H0 H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	Hl H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHHUD H+HL$@HH	H HHHMMAVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+HcAH+2HcAH+hHcAH+LHcAH+HPHcAH+2HcAH+D	HcAH+Ho(HHcAH+diHcAH+HPHcAH+8HcAH+SHcAH+pHwHcAH+HPdH;(HcAH+ܠHSHcAH+HcAH+HcAH+l	HcAH+HP|PHHcAH+$HhH(OgHcAH+H7PH4HHcAH+hHcAH+H`fH(׿HcAH+HPH(;?HcAH+RHcAH+HPHcAH+HP,gH3HcAH+
HcAH+HcAH+<H(3fH(HHcAH+\HcAH+HPl&HcAH+HPHsHfH(K?HWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtHE HHXHE H [% % % % %v %h %Z %L %> %0 %" % % % ff     H;
Q uHfuHS  H\$Ht$WH E3H
SE   m  H
J 4 HH   HQ H  Ha HH
 Hn HH HHtnHtiHtdH%E  H
  H
D H @   ?+HH3HH3H=D HD H
O   ^  H\$03Ht$8H _E3E33AQb HD Hu     ̹   {  H(H
AD  H
dD Ht H(@SH HH
D  # H
D  H [   @SH HH
C ^  H
C I  eH%X   A   LЋh Cf H [h   @SH HH
C  ; u4d      ;teH%X   
XI A   Hȋ AH
9C H [H% @SH H
OC Hu0Hۘ H3JC ?HH  H
C HH [H H

C H [H% H\$Ht$WH 3H9=B u8Hu H3B ?HH>  DHB H
B Ӆ3H
uB 7 H
B E3E H
VB  H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
 B u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
A H(%  u#  H(H(3%  H(  @SH A ɻ   DÈ@ 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
l@ u
  t2zH
p@ a
  gH I¹@   ?+ȰIL3LELEELEM@ LELEELE
	@ M@ 

@ H\$PH@]ù     HLMZ  f9!uyHcTHH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuH
? H [@SH =/?  tu(  !  H [@SH HC HًH3> ?HHu
H  HH
>   3ɅHDHH [H(HH(]  @SH H HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@==  t
   r  =    tg	  H
	  5	  H
>	  P	  H H
 
  u)0t Hu H
N ]
  =    @2@N	  HH8 t$H2tHH?  Lƺ   I=    H\$0Ht$8H|$HH A^H\$Ht$WH @< 3ۅ3Pȉ< =@D$8=s< t
   K  J\< o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9D< 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH Hi IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH% @SH H3g HV ` HȺ	 H [H%T HL$H8   	  t   )H
';    HD$8H< HD$8HH; H; Hh: HD$@Hl; B: 	 <:    F:       Hk H
>: H      Hk H
> HL    HkH
1 HL H
  H8@SVWH@H? H   3E3HT$`H- Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$  ǃ|H@_^[H\$UH$@H  ٹ     t)%>  HM3A    HM H   H  HE3 Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 3F H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T   " HD$PHD$@HEHD$H3 HL$@ u
!= H$  H  ]@SH HHH
1 HHS3H
HJHHl  HA HHH [3HAH7 HAH HHH HH  H\$WH H HHH  t
   HHH\$0H _HHHL$ HWO HL$   HHHL$ ZHH HL$   H\$H|$UHH e 33L    D9    cAMDDDAentiAineIAntelEDD;< AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
ы A%?D; = t(=` t!=p t wH     HsAD; Eu  ` rAD;    UDM;|$3E]MU]	sAD]; Asn        AsSAsL3H HHUHE$<u2 ׊    E ъ t      H\$83H|$@H ]̸   39 H\$ UHH He H2-+  H] H;uoHM HEHE H1E HM H1E E HMH H3E H3EH3H  H#H3-+  H;HDH H\$HHH H ]H(uH=  uc    H(H
9 H%R H
9   H9 H9 H(HHH(H\ H\$Ht$WH Hz H5s H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH H> H57 H;Ht
HHH;rH\$0Ht$8H _%: % % %  %* %4 %6 %8 %: %< %> % %z %| %N %@ %2 %$ % % % % % % 33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D%z D)xEWY5io fA.zuT=z D\   D)$P  (Tz (T
z D(f/D)$0  D)$  EYv
D(^^D((fE.D~o zuA('YAX(	0 L   (H   AYfE.D($  z.u,fA/w	Dq (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0舿L(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3̅tH= H H3 H+ H H! H(H H9A   LAIHH3H+H.MtAHIHEH(3HIHEH(IIw;HgB, HAIHHH(ËAIHHHH(H(H% H\$0% HHuHH\$0H(HH|$  H+Hu
HSHR0H\$0HH|$ H(         @SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
v H9Ht6H HH [<    HuH
 HB H	 HH [@SH0HAH      t-H
p LB LH   H	g u/HH0[H
 LH@LHZC HD$ H	 H+u
HCHP03H0[E3H;
 AAH;
V H;
 AAuH%" H\$WH HHHIH H;t6" u,LHT$0H HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _@SH H=     Hų D  C
HKt1{ t 0HSLCHMtE3 5 
HSH HKHHCHHtu HtH(H{ u3H [ÃH [H(  H~ H3H$  A   D$    L&  HL$4AQ#  LJ    LHL$0 D$08D$4u%D$28D$6u3H$  H3H(  HD$0   HD$(LL$4H? L@ HD$ HL$@ A   HT$@3N H$  H3H(  H(H H
9 H7 H Hq [ HuH7. H(HH
u @  H. HuH(3H(H(=K     H
0<  Hu13
 H
v H/< A   H	h y/H(H   J    HHtH(uH@P0H
n<   Ht$HK   HtH(uHPHR03H(1 3H(   H\$WH0H HH   Lz Hs9 HR    L, Hl9 H3    LHi9 H xoL7 HV9 H xTLHD$     LH
{9     Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0H\ H
 H8 A   H	 yH/u
HGHP03HH\$@H0_@SH HQHLIMtIHD$XA| 3ɉKxHKHHKPHK HK(HK0HK8HK@HtH HC`HD$PHtH HCXHD$`HtH HKpHHCh HH [H\$Hl$Ht$H|$ AVH@H
+ IH56 HH-4 L53  HtHt$0LHl$(HHLt$ H\$PHl$XHt$`H|$hH@A^H(LHt4HB      t$HI`HIP`Ht
H)uHAP03H(H
 H6 H	 H(HA`HHD H H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
9 H5 H		 H(HAXHHD! H @SH yx H   Hl$0Ht$8H|$@Lt$Hs HHhXHp`Lph3HGXHG`HGh9CxuHt3H  HHu^ HtHP 
H(uH@P0MLHHHL  Lt$HH|$@Ht$8Hl$0H [@SH H H{@ t	H {x |H H9 u Ht H$   HH [H%; H [H\$WH H3HIHtH{H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HK j  HKpHtH{pH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu3HKHHt	Hօu!HKPHt	HօuHK LH#   H\$0Ht$8H _H\$Ht$WH HIH	HHt	Iօu&HKHt	HօuHKHt	Hօu3H\$0Ht$8H _LI[WHP3HIC H  ICA   ICHICHIC ICEAICIC u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0y| HHYPHt!H
ȼ Ha1 H	 3H0_][Ht$PHI  H HHH  L$xtetaHH  H+u
HSHR0HOPHtHGP    H)uHAP0   3H  HHt$PH0_][^  G|HCH;$ u+HD$pHLL$hLD$`L$(HHD$ H*  L   HHq* MtAY HH   H+u
HCHP0H
ֻ H	 uHt$PG|3H0_][Q HOPHtHGP    H)uHAP0G| LD$hHHT$`U@  3H  HHu'- H9XXuH
 E3E3HHHLG  HHt$PH0_][HT$pHHt9 LL$hHLD$`HD$      H.Hu
HFHP0G| H+u
HCHP0Hu7HW  HHu' H9hXuH
 E3E3HHHF  HHt$PH0_][H\$WH y| HHYPt$H
2 H. H	R 3H\$8H _HtIHHHt$0  HOPHtHGP    H)uHQR0H+u
HCHP0Ht$0uH
ػ H	w 3H}  Ht4H(u
HPHR0H
 H. H	 3H\$8H _ Ht*Lҷ HHp M H=	  # H H\$8H H H _@SH HHIP{| tH
 H- H	 3H [HtGC|HAH;! uH;Z u
3    C| Hu!HH [B  H HH [>  H [H\$Hl$Ht$ AVH H$! 3HLH9BuHHH      A|HHBHN% H|$0L   MtA HHu%H
 H	* u	H  '3Hb H/Hu
HGHP0HDH|$0AF| HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIP{| tH
6 H+ H	V 3H [H   C|HAH; u\H; u3H;[ HD >H; u3H;= HD  H;* u   LHf$ 5  C| HuDHP   HV  HHu'x H9XXuH
۴ E3E3HHHB  HH [H\$WH 3HHIPHD$0HtHGPH)uHAP0 HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu' H9XXuH
 E3E3HHHA  HH [HAHt#HPHJHtHB    H)uHAH`0H\$VH AxHHu2Ht-H;} t$H
T H) H	$ 3H\$@H ^Ãu"HtH
F H	 3H\$@H ^Hl$0H|$8 H~  H~ Ht!HGHtHHHEHtH HEHAH   LHGHH   HF|VF| HHO3H   HWHl$0HGH|$8HtHRHJHtHBH)uHAP0HH\$@H ^HtH
d H	H% H
) H( H	H% H
 HR( H	H%س H\$WH H3HyHYHHAHAHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWHH LYX3HY`HLQhHL] H]0LU8HAXHA`HAhMuQMtI*u
IBIP0H]0HtH+u
HCHP0H H H H3H\$HH _^]H HL;   HuH H Hֲ LU8L] cHKH;u	H[@H-      t<H{|	H[HH H H HM0H)uHAP0LU8L] 	  udHt_MtI*u
IBIP0L] I+   ICI   I-  u$LM8HLE0HU =  H\$HH _^]LE8HU0HM ˲ HE0HHH HH;t
 tHM8Ht
H)uHAP0HM H)uHAP0HE0HX@HHM0H)uHAP0H3H\$HH _^]H\$Ht$WH HHHQHHï HHttL@A      u	H$ HG H9C t-H% H
 LGH	t H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
 H	 t H, xHWLH xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _   uHHp uH\$0H _ø   H\$0H _LH;u   HA    }<      @t0HB   yA      @t3'  sI   IH% @SHZE3LH~HBL;   IHL;|E3H|$H   H=ޱ LZff     IHA    }r      @tfL;tzIX  Ht-L@3M~JH@ H9tVHHI;|/   [I H   H;t
HuH;   uIIL;n3H|$[ø   H|$[E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
 AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL;H AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H; ø   Htfff     H   H;tHu3H; ø   H(HA      tiHQHHtVHtHHt0Hy H
ȫ H H	x HH(H(H% AIHHH(ËAH(3H(H\$0HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,H< H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(.< .< .< < < &< .< .< .< H(HA      tEHAHHw,Hh= H3H(ËAH(ËAH(H(H% H\$0=HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(= = = < < = = = = H(HA      tEHAHHw,H7H> H3H(ËAH(ËAH(H(H%Ǩ H\$0]HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(= = = = = = = = = H(HA      tEHAHHw,HW(? H3H(ËAH(ËAH(H(H% H\$0}HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(> > > > > > > > > H(HA      tEHAHHw,Hw@ H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(î? ? ? ? ? ? ? ? ? H(HA      tTHQHHtAHt3HHyH
 H H	: H(H(H% AH(3H(H\$0HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,H׾A H3H(ËAH(ËAH(H(H%g H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(NA NA NA <A 5A FA NA NA NA H( H(H(f H(H(F H(H(& H(H( H(H( H(H( H(H( H(Ht$H|$ ATAVAWH L%m AL LtHv  tDADH\$@Hl$HEt8H-? Ht,, H  ; }HHD9Du
H\ H,MDƋI   HHthtHЋ  L E3HIL HHtHȉplФ HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH|$XH A_A^A\H\$Hl$Ht$WH   HAIɋp HHtVtDLb HH
 : 	H? HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_H E3H
 E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$     0 H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H= HڋHuH    H  hHHH  @       H\$@Hl$HH _Ht$0Dŋ5 HϋLt$83  LcD;}'IH9luHHH)   HAP0}j ;u.p@HHcHߣ HHtX5E 5; H< HcMI;~#HHHI+@ AHIAHuMƉ5
 BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H=
 Ht/
 H9   ;
 }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@UVH(HH
m	 Hu	H(^]H\$@H|$HLd$PLfhLt$XLvXL|$ L~`HF`    HFX    HFh     HHtJH H
b H9HuH%    H HLB HHr% HHHH
$ [H
 H HAL   MtA HHtRH0 H HE H/u
HGHP0Ht)H; tH; t4H t'3# Lr 3H H
*  MMIH*  L|$ Lt$XLd$PH|$HH\$@H(^]H\$WH HAHL   MtAО HHu.H
a H	x tH
 H LH	 HH\$0H _H\$Hl$VWAWH0333HLHu3 HH   HH
 Lt$P LHt~& HHtp.   H

 l Ht<LD$    LII HHu7H
 H	 t# LD$     LII HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^@SUVWH(  H%U H3H$  HIIIx HH   HH      uH
 H
 LLH	7 ~H@ H;s)H
E H
 HD$(LLH|$ H	 L$p  upH;vkHD$0L H|$(HL$@LHt$    ˞ E3HT$@3{ y.H+u
HCHP03H$  H3ոH(  _^][HLI[IkVWAVH0HAX3ICIHA`MCICLHAhISHihHHiXIHi`IKIC H9kX   HD$PHt(HL$ HǙ    HD$PHtH HD$PHL$(Ht
HHL$(HD$PHT$ HtHHL$(HT$ HD$PHHH   ILHzHZH
HD$ HBHD$PHBMtI(u
I@IP0HtH/u
HGHP0HtH+u
HCHP03QHL$(I.H.H/Ht
H)uHAP0HL$ Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIXH;u   Hu3HB          H\$UH HjE3HH~HB H;   IHL;|Ht$0H|$83H   HrfHH;   HC             @   HB   yy      @tmHX  Ht4L@3M~HH9tFHHI;|3V   H\$@H ]HfD  H   H;tHuH;     s
Hn	H; u'HHH;3Ht$0H|$8H\$@H ]ø   H\$WH H   HHxHXHL@LHHt
H)uHAP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _L   H
" fIHtH;uIBHtLIBI
I IBIH
HtHI HtH IHtH H   H fHHtH;uHHHtHH\$WH   H3HH9HHDG< u#Hl  H;HC8HC0Hk HC@H{FDK$AtPH
 H( A   H	y H9;tHMk H9C@uH{@H H$   HĐ   _H$   HL$@  HS(HL$@  HtLCH
q L;t^HH H HGL
 HD$0HԤ Hq IHL$(H
 LOH HD$ H	 :H9{@uHj HC@3H$   HĐ   _3HHAH  HA8HA0HAj HA@H9 tH#j H9A@uHA@    H% H\$HT$UVWH HHLfHH}  AV 3AU IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <94HÍv4p<0}H\$Hu,H
 H DH	 t*L0HcHG(H H
 H	͒ 3H\$@H _^]H
 H AZ   H	Q 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]H% cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]f.U R tU ET T R R S R S S SS U eT  






































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtH H
 H	ܐ 3    t   LA       )   эB<       A<	  CDA0H<0|f<9CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGH+ DHHH
 D@XH	~    HGHcHLH
 MDH H	P gH
g H DH	3 JH
J H# DH	 3+; uH eHCGGHG(   IHw H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
a LMH H	+ Ld$XH(A^[D8cGu+DAXH H
# H	 Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
, H LH	 H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH LICHD$(IM HD$ GHuL
z L H Lי HL	AHDAP@  HD$(H LT$ MH
D H	 H8H(DA@4wVL
HA] A\ IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
 H H	 2H( \ \ \ \ \ \ \       H(DA@4wEHH] ] H   H(ø   H(ø   H(ø   H(H
 H H	É 3H(n] x] ] ] ]       H(DA@4wEHءH^ ^ H   H(ø   H(ø   H(ø   H(H
# H< H	 3H(>^ H^ R^ \^ f^       H(DA@4wqL
HA_ A_ I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
' H@ H	 3H(_ _ $_ ._ N_ 8_ b_       H(DA@4   L
HA` A` I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
# H H	C 3H(H
 H H	Ն 3H(f` ` (` 2` R` <` f` `       Hs   LA Pb Aa IH H H H H H H H H H H H ÅH
 H HEÅH
 H HEÅH
 H HEH H H H H H  a *a Ba Ra ba ra a a a a :a 2a a a a Ja Za ja a za a  	

DH H
 H	H% @SH HDA@<	w<BHA؃0<0|<9H[X<0}HtH [ÃHH H
+ D H	 H [HDA@<	w7BHEA0<0|<9GHE@F@<0}HAÃE3H^ LJL+_ HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=@_ Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJH& HHHL$ H
 H	 3H8fD  H   H;tHuH; t   H8H\$Ht$WH LAHIxpHt[H tTH MtI	HL- HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
? H M@H	 H\$03Ht$8H _H(H H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H(: y,H(LH /   HHtH(uH@P03H(H\$WH IHD$H    LD$HH   tHLH\$HH&  "H\$HHu
3H\$0H _HH  H+Hu
HSHR0HH\$0H _H\$WH H  H+Hu
HSHR0HH\$0H _H\$Hl$Ht$ WATAUAVAWH LqE3H6 MLDd$PHI9   t$I   Ht
H    H   M9  uI~ :  II HHt9H H@H;7 t!H; tL  MtH   t
oD$P   H HtMH0HtEHIMEH} HHtH H.u
HFHP0Ht>,H.u
HVHR0|$P uTMt^LEHHAHH+u
HCHP0Ht4H~ H9Gu'H9ou!H_HH/u
HGHP0I   /I?(HtIH
~ H MFMH	w~ 3H\$XHl$`Ht$hH A_A^A]A\_LH;uH H H HAH;} u_HAHH} H H} At%Hu3A?E9AA9QtHuA?D9AuH;} uAfAnf.zu^A   H%} H\$Ht$WH H2| 3HH΋H9CH9G5  C u
H~ xG u H~ yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM @ƋH\$8Ht$@H _L| I;uUI;@ƅuJA   HH{ HHHH+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HH|{ t/HD$8HH      tJE3LD$8HT$HHM{ uLL$8MtLH
| L H H	{ 3H [H
z| L{ H H	z 3H [ø   H [H\$Hl$Ht$ WH H3H
@{ IHL;u3H;Lt$0HMHDߋ      Ht:HO   MtH~| I9@tH
{ H H	z h  HHHH} Ht(G{ HHhH;tHHphHt
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHIy t   IMMHC      tHHӹ   z 3y HHtuE3HH{ H+Hu
HSHR0HtNLOHA      @H
z H LH	x HI H
Zz H	1y Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4IS}x   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@%y HLL$pH8G `<`uHH@Iy( uIx LL$pAA `<`uIAIA@H;u-HIH	u yx H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$ v q3H\$`H0A_A^_^]HY@%
x HLL$pHC `<`uH[H[@Iy( uIw LL$pAA @t
 tIAIA@H;u)HIH	t ؅yw HuqLL$pt@HI;H H
w L$   H	v H\$`H0A_A^_^]H H
Zw H3 L$   H	u H\$`H0A_A^_^]LLH
w H H	H%u HHLT$pH( M;LT$0MLH
v MML
 IML
 H{ H	LDIH HDH HD$(L\$ u HHH\$Hl$Ht$H|$ ATAVAWH Hu HL`XLp`Lxh3HEXHE`HEhMtI$MtIMtIMMIH      7w Hv HMXHHu`H}hLeXLu`L}hHt
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
t ]t HRt H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAXHHA`I HAhI3HAXHA`HAhH\$WH LQXHy`HYhHQXLA`LIhMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
#s H A   H	r H(H(   H\$UH s HHXXH   H
9q LI;tqHK    }F      @t:I@   yA      @t3Hcs
IHPIHu uH\$@H ]3Ht$0Hu`H|$8H}hHEhHEXHE`H+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HH0x LL
O H
q H LDH	H%q H
q H A   H	H%Rq @SH Hp 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H  ËH [LBq I;AuI;AuA   vp HHu	H [HH|$0萨H+u
HSHR0H|$0H [@SH Iq Hunq Ht3H [HH H [Hl$Ht$WAVAWH E3IILHL9quL9qu  y3   H\$@L9wtAG t;   .p HHtsHE HHhIHHp G tE3W=W8   o HHt8IE3LxHHE Hh HHp(HO
  LH+u
HCHP0H\$@IHl$HHt$PH A_A^_H8LQLMtFA LD$ LL$(=   uD@IHT$ AH8=   uE3D@HT$ IAH8H8Hl$Ht$H|$ AVH 3ILHH9iuH9iu?  y3   H\$0H9ot9G t3   n HHtcHHHpIG tE3W5W0   n HHt0IE3LpHHHp HO	  HH+u
HCHP0H\$0HHl$8Ht$@H|$HH A^LD$H(LQLMtOA uIIAH(=   uD@IHT$@AH(=   uE3HT$@IEAAH(H(@SH HAHH	HHAL   MtAm LHu	H [LKIAHo H;tcHX  Ht1LA3M~eHfH9tAHHI;|3H [    H   H;tHuH;o    tIA(HHHKIA(HᏉK 3H [@SH Hm Hutnm HuaHCH      t>   m HHt;H
m HH	n H+u"HSHR03H [H
m H	n 3H [H H [H\$Hl$Ht$ AVH0HA3H;&n ILHuHT$ HT$ LD$(DF     H;Wn uHHQJ=   u5Lt$ Hl$(HB uHsA   HT$ AHtE3gc   H|$@}k HHtCIE3LpHHE HHh H}  H/Hu
HGHP0H+u
HCHP0H|$@HH\$HHl$PHt$XH0A^H\$Ht$WH IHLAHHH
 h L

 MQLHHtH H\$0Ht$8H _mk Ht3H\$0Ht$8H _HH\$0Ht$8H _7	  HH;}HH33H%j LL$8E3HMtIH%h HAH@pHtH@HtH   Ht$WH0LAHHI@hH   Hx    HH\$@HHuYpj HtNHh HHk t%g LGHS H
j M@H	h 3H\$@Ht$HH0_A   HHD   H\$@Ht$HH0_H
j H M@H	h Ht$H3H0_H\$Hl$Ht$WH Hq3H;5f HH   H;5,h u8LI?AEDtHHAHH;A   HD   HvhH   H9nt{EtCHy>HHt6HxHHHV   H
^g H	=g u3yf HHVhHH?EtHHOHH;Or5Hh HHtHHe H+Hu
HSHR0HHGHH H\$0Hl$8Ht$@H _@SH HHu3H [H|$0we H+Hu
HSHR0HH|$0H [HT$H(HAH;di uA   HT$8J  H(H;i uLLAA@t
K  H(Äy2MP t3HIHT$8A   tE3AH(AH(   H(H\$Ht$WH HH   f HHuH\$0Ht$8H _HE3HHxH  H+Hu
HSHR0H\$0HHt$8H _HADHLPA t3HIAtE3IIHAH;-h u
E33  H;zh uHA@t3   Hp E3   H\$Ht$WH HAH@ Hpt3HY
h @ H Hg ;~#H
 e t3H\$0Ht$8H _HHH
g H؋   ~z<Rg H 9x }
g @$ Hu"e HuH
f H H	d Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Huf    
g @ H Hf ;~H
 d t3lLHHH
f H   ~ZRf H 9X }
f @$ Hu"d HuH
e Hd H	c HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyILqLHY H%f @ DH Hf D;~H
 %c t3    u\ CuVHuHcGH;uMLIH      Hu-Ht(LCHcGI;uHSMH   ]ff     HU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ ub HH3e    ~YI e H 9X }
e @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHHb E3LHHL?d HHtZH 3HH~ fD  HHvHHNHHH;|3Hc AF HH+u
HSHR0AN HH\$0Hl$8Ht$@H|$HH A^LHf H
b H	H%a HB      tHAL   MtIH%~a H\$WH HH
 HHAL   MtAFa HHuH
a H LH	l` HH\$0H _HAL   MtIH%` H\$WH HO 3HHt7H;u
3H\$0H _H
a H H	<` H\$0H _y   Hg H =     \  H=    H=Y  tD H
  H
 H  H)H       HAP0  H_ HH HH
 3_ H@ Hu'Hf H
     U \  M3H
ue =] H Hu'Hf H M     \  3H
4e +a H4 Hu'Hhf H      \  y'H8f HY      \  HHHk ] H Hu'He H     [ \  SH H
t H ] H, Hu'He H K     \  	H H
> \ HA Hu'Hee H      \  L H H
 H _^ y'He H=      \  }  y'Hd H
     U \  M9=j tFL H> H
 _ y'Hd H A     \  0\ HHu'Hid H      \  H" HZ HuBL Hv H\ y'Hd H3     {  ]  s  f  Y  L6  ?y'Hc H Q     ]  yq  u'H}c H   #    ]  H
~ 3追HHu'H@c Ha  &    %]  HA LH
 Z y &   u ']     H+u
HCHP0H
e 3>HHu'Hb H b '   ( 1]   H( LH
~ Y y. '    3]  
  H+u
HCHP0H
, 3轼HHu'H>b H_  (    =]  H LH
 X y (   s ?]  	  H+u
HCHP0H
 3<HHu'Ha H ` *   & I]  H LH
| ~X y, *    K]  }	  H+u
HCHP0H
 3軻HHu'H<a H]  ,    U]  H LH
 W y ,   q W]    H+u
HCHP0H
Y 3:HHu'H` H ^ -   $ a]  H LH
z |W y* -    c]  {  H+u
HCHP0   W HHu'H=` H^  .    m]  H HH HKH HHK H HKH= HAH
 MHHu'H
_ H
 q .   7 u]    H+u
HCHP0Ho HHHu'H_ H # .    x]    H1 LH
? AV y .    z]  @  H+u
HCHP0He HHHu'H^ H  .   g |]    H' LH
 U ym .   3 ~]    H+u
HCHP0H/u
HGHP0   U HHu'Hp^ H  /   ٿ ]  HY HH HOHH HHv H HOHh HAH H HOHw HAHl H HOH^ HAH+ H HOH HA H
Z 5HHu'H] H Y /    ]    H/u
HGHP0H HgHHu /   ߾ ]  j  H_ LH
5 7T y /    ]  6  H/u
HGHP0HS HHHu /   k ]    H# LH
 S yq /   7 ]    H/u
HGHP0H HHHu1 /    ]    H LH
M OS y /   ý ]  N  H/u
HGHP0H HHHu /    ]    Hc LH
 R y 0   O ]    H/u
HGHP0H H藵HHuI /    ]    H LH
e gR y 0   ۼ ]  f  H/u
HGHP0H+u
HCHP0H HHH9
 u!H HtH H dH
 SH= H
 HLGQ HH HHH
u H HtH.T Ht3HHHu'HZ H 9 2    ]  HCHH  L   MtA9S HHu 2    ]  D  H+u
HCHP0Hi E3HHHu'HY H   2   h ]    H/u
HGHP0H LH
 3P y\ 2   " ]    H+u
HCHP0Lz H
$ 3Q HHu'HdY H  o  ͺ ]  H LH
# %P yӻ o   ]  $  H+u
HCHP0L H
, 3
Q HHu'HX H ~ r  D ]  <H LH
 O yJ r   ]     H+u
HCHP0aO HHu'HbX H     ˹ ]  L HHY #O y ]  %H LH
 N yTz ]      HW H H+u
HCHP0HFH/<HGHP0-H+u.HCHP0"Q HuH
Q H H	O HѸ H\$0HH _@VH H  t3H ^H Ht	H H ^H\$0Hݯ Hl$8HH|$@Lt$H5N HH   HN H/Hu
HWHR0HtdHwN HHtCH] HM HHtWLH H<O H/Du
HWHR0EyFH+u
HCHP03H|$@Hl$8H\$0Lt$HH ^H
N H	M t^M H] H^M HHt1LH HN H/Du
HWHR0EsH
nN H	M YL H] HL HHt1LH HLN H/Du
HWHR0EH
N H	M L Ha HL 3HHt7H;N tLH+ HM H/u
HWHR0y#H
M H	L !L HH\$Hl$Ht$WH HIIK 3HHt49|$Pu	H;fM tLHH=M H+u(HSHR0!H
 M H	L t
K H\$0Hl$8Ht$@H _H(^O HH$M HH:] Hu3H
+] HH(H;tH
M Hr H	iL H(3H(H
i H%RJ 33H\$WH   HD H3H$  H
 LM HHu*HmS Hv  	    \    H$0  HH5 HOJ HH   HH    |&H
L L LH H	
K    H@ H=`  s1H
K L HD$(H LHD$ `  H	J GvWHD$0L
 HD$(`  L    Ht$ HL$@M E3HT$@3HM yH/u
HGHP03H$0  H=s Hu H?R Ѵ 	    '\    H+u
HCHP0H
d K HHu*HQ H     H )\    Hd HH HH   HH    |'H
/K L
d Le H: H	I =H@ H`sEH
I L
[d HD$(Ld HD HD$ `   H	bI H/u
HGHP03H=I Hu     ,\    AH
  D$    L HHd gH Huu    ; .\  N  A0  D$    L HHf H/ Hu,     0\    HJ HG HH   HH    |'H
I L
 Lor H H	KH =H@ HPsEH
XH L
 HD$(L9r H HD$ P   H	H H/u
HGHP03H= Huh    . 2\  DA   D$    L~ HH~ H Hu7"    4\  HeO H~ H+u
HCHP0H+u
HCHP03H$  H3dH$8  H   _H\$WH H=) H&F y E   R [  G  3H9* H) uH * H;	H HDH H
* H LH
 I y) E    [    H= H=h HE y    [    H9[ Hl uH H;tG HDlG H H޵ LH
T 6I y   Z [  O  H=B H=% HD y` f   & [    H9& H% uH% H;F HDF H% H= H= HD y i   Ů [     H9 H uH% H;~F HDvF H H= H=! H8D y   d \  \H9  H( uHw H; F HDF Ha H=* H=c. HC y0@    
\  H{L H H\$0H _H9?/ HP. uH. H;E HDE H. H\$03H=S H _333H(HC H6 |y? [  .  6 8D HA Hu [     D H` Hu [     4 C HG HuĬ [     K C H Hu [     
 C H- Hur [  d3D H HuR [  D   C Hڵ Hu/ [  !   C H Hu* [  HJ H $    H(3H(H   Hj    C H Huլ |   [  z  H    C HY Hu ~  d [  C  H,    C H Hug   - [    H
]B LH@ H Hu/ f   '[    H    L
 L: H HD$(H7 HD$ B H
 Huҫ y   2[  w  H@    B H& Hu-HH H    S =[  HĘ   H    jB H+ Hu-HH H B    H[  HĘ   HZ    B H  Hu-H\H Hu  2   S[  HĘ   Hǰ    A Hu Hu-HH H*  X  r ^[  HĘ   HT    A H Hu-HG H߰ a p  ' i[  HĘ   Ha    >A HW Hu-H{G H    ܨ t[  HĘ   H    @ H| Hu-H0G HI ˩    [  HĘ   H    @ H9 Hu 2   T [  3  H    q@ H HHuT o   [    H E3Hв HT$pD$ho  HD$`H HD$XH HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    -= H Huè o   [  h  HA    L
= L H H$   Hб HD$xHt HD$pHȱ HD$hHd HD$`H  HD$XH$ HD$PHX HD$HH HD$@H HD$8Ht HD$0H  HD$(HD HD$ > HZ HHu [     H| E3Hb HT$pD$hr  HD$`EAH5 HD$XH1 HD$PHD$HHL$@HD$8HD$0HT$(3D$    J; H Hu-& [  L r  HD H HĘ   3HĘ   H(H
5 H Hu*H=D H^      Z  H(H
# ~Hש Hu*HC H  |  d Z  H(H
) <H Hu*HC Hڬ \ W  " Z  H(H
ׯ H Hu*HwC H  _   Z  H(H
 H Hu*H5C HV إ =   Z  H(H
 vH Hu   j Z  ZH
ծ HHѬ Huv X  < Z  ,H
o H Hu*H    Z  HB H H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H; HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
J Hz  @ǅtH0 H
$ H\$0H _HH\$0H _H@  @SH 3LHy  
أ t=Hå Hc
 H3HHCHCLCH   7 HH [3IA0  HHuH [@SH Hs9 HHIHCHa9 H Ht
H)uHAP0HE9 HKHCH69 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H9 HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH  H
 H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   p5 HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH He7 HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
B Hz  @ǅtH@ H
 H\$0H _HH\$0H _H@  @SH 3LHy  
П t=Hӣ Hc
 H3HHCHCLCH   3 HH [3IA0  HHuH [@SH H5 HHIHCH5 H Ht
H)uHAP0H5 HKHCH5 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HU5 HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
6 Hz  @ǅtHУ H
 H\$0H _HH\$0H _H@  @SH 3LHy  
ĝ t=Hc Hc
 H3HHCHCLCH   1 HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _H3 H HIhH)uHAP0Hd3 HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _H2 H HI`H)uHAP0H2 HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H?2 H HIXH)uHAP0H$2 HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H1 H HIPH)uHAP0H1 HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _H0 H HIHH)uHAP0H0 HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H_0 H HI@H)uHAP0HD0 HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _H/ H HI8H)uHAP0H/ HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H/ H HI0H)uHAP0H/ HC03H\$0H _HA0H HA0@SH HHt
H [P  H. H HI(H)uHAP0H. HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _H. H HI H)uHAP0H- HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _Ho- H HIH)uHAP0HT- HC3H\$0H _HAH HA+z  H\$WH HH- HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H, HHIHCHq, H Ht
H)uHAP0HU, HK HC HF, H Ht
H)uHAP0H*, HK(HC(H, H Ht
H)uHAP0H+ HK0HC0H+ H Ht
H)uHAP0H+ HK8HC8H+ H Ht
H)uHAP0H+ HK@HC@H+ H Ht
H)uHAP0H~+ HKHHCHHo+ H Ht
H)uHAP0HS+ HKPHCPHD+ H Ht
H)uHAP0H(+ HKXHCXH+ H Ht
H)uHAP0H* HK`HC`H* H Ht
H)uHAP0H* HKhHChH* H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu'   HH|$H) LD$0HT$8HL$@	( HH{HtHH  H@MLD$0HT$8HL$@H( HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  H* E3H 8  HH	  Hk' LHCHHZ' HH HM' HC HB' H H8' HC(H-' H H#' HC0H' H H' HC8H' H H& HC@H& H H& HCHH& H H& HCPH& H H& HCXH& H H& HC`H& H H& HChH& H k y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [H H& H HI`H)uHAP0H% HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H% H HIXH)uHAP0Hd% HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H$ H HIPH)uHAP0H$ HCP3H\$0H _HAPH HAPH(Ht	H(~J H
" H`z H	$ H(H(AH$ Hu;He+ H  X   Ό     H
K AX   ~3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H# H HI@H)uHAP0H# HC@3H\$0H _HA@H HA@@SH HHt
H [xL H!# H HI8H)uHAP0H# HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H" H HI0H)uHAP0Ht" HC03H\$0H _HA0H HA0H(Ht	H(M H
 Hx H	! H(H(A(! Hu;H) H6  T   ~ 5  5  H
G AT   |3H(@SH HHt
H [O Hq! H HI H)uHAP0HV! HC 3H [HA H HA @SH HHt
H [8P H! H HIH)uHAP0H  HC3H [HAH HAH(Ht	H(P H
O Hv H	G  H({Q H(Ht	H(Q H
 Ht H	 H(H(IL$0  Hu;HC' Hd  P    
  
  H
B AP   z3H(H\$WH HHZ  HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH HC HHIHCH1 H Ht
H)uHAP0H HK HC H H Ht
H)uHAP0H HK0HC0H H Ht
H)uHAP0H HK8HC8H H Ht
H)uHAP0H HK@HC@H H Ht
H)uHAP0Hi HKPHCPHZ H Ht
H)uHAP0H> HKXHCXH/ H Ht
H)uHAP0H HK`HC`H H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu @  HH|$H6 LD$0HT$8HL$@ HH{hHtH%  H@LD$0HT$8HL$@H HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  H E3H 8  HHuH(HK HAH@ H H6 HA H+ H H! HA0H H H HA8H H H HA@H H H HAPH H H HAXH H H HA`H H HH(H\$Hl$Ht$WAVAWH L3 HHu'H! H A =    T     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHH1 u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_O T  
C T  H  Hى [ =   H/u
HGHP0HtH+u
HSHR0D/ H
n  	t3tH\$Hl$VWAVH L3 HHu'H4  HE ǂ =    T     In3I+.HHtafIL$H HHtiHGH9G ~HHOHHHHOHH u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^ T  
 T  Hn H  =   H/u
HGHP0HtH+u
HSHR0DՁ H
rk  r3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H;= tgH; t^IH HHu/Hn H A/   D T   H]  H@L   MuST  2  HLL Mu8H H9GuL;we  HGJL;wQ  J\HIHAHHJ  ILHt
H)uHQR0HHM  HHEH;t?HUHtLEL+I("HH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPH9d Hu`HUHMHHMHUHLEL+I_!\ U N G @ A0   9T      LH   H
 LI;   HH    }F      @t:I@   yA      @t3IDfs
II1eII uZ)T  A/   H]H H D~ I} HtH/uHGHP0D]~ '} H
i 7o& H/u
HGHP0HUIcH]MtIm uIEIP0HtlHEH+HH;v H    H=   r<t HCH;r H+Hs H'v HH7H]H   HUHNHMH+H*HHHH?HH
H;vO HRHH=   r<t3 HCH;r# H+Hs H'v HH"7IL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;] toH; tfIH LHu/H H A/   D| S  z Hu  H@H   HEPHuS  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HiEHu HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMRL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMjRL}H]HuHt;HH]HEP7A0   S  H}@H?   H
D K	 H
D =	  LH   H

 LI;   HH    }F      @t:I@   yA      @t3I`s
II_II udS  H}@H?A/   H H Dy w MtI.uIFIP0Dx w H
c i8R
 I.u
IFIP0HUH}@H*L}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@te HFH;rU H+HsE H'v8 HHT2HH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH; twH; tnIH!
 HHu3H H} A/   DBw .S  v H]L}g  H@H   HEHu0S  H]L}  HLHHMH]L}Hu8H
 H9FuL;f$  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  HO0HE   HE    E HHM9HEHrDHHMH=   r0  HAH;  H+H  H'  H/r H  HE   3H}@}IE3HUHM4HEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHM\LuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHM[LuH]L}Ht*HC   H{H{rHHHU  H8H H]HMHE        H
>  H
>  A0   [S  H}   L
 HH   H L I;   HA    }@      @t4I@   yA      @t	3Zs
IY	Ig uZKS  H}A/   HU Hfy Dr q HtH.uHFHP0Dr q H
] c2# H.u
HFHP0HUH}H{LuH]L}MtIm uIEIP0HMMtHI.M+IMI"HHMH3$H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H;{ 8  H$ HHuVq    p R    H@L   HEo    HAHHt[HEo   HAHHtEHAH^yH
S H
dw o R  UH+9  HCHP0*  H+u
HCHP03`u	HMosH
 H
w _o R  p    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   H$k H
 H	 2Mx-H	 L
+ ILDHh H
 H	X o    n R    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+ID Htn R  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I! Ht@m R  n    H H(u Dn wm H
<Y _   HUHMHHUHMuHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I HUHtLEL+IHUHtLEL+IWELmHUHtLEL+Ie MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I! HUHtLEL+IWIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;  toH; tfIHm LHu/H	 Hs A/   Dl HR  Sk Hu  H@H   HEPHuJR  Hu  HLHHMPH]HuHu8H;  I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HZEHu HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMjCL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMBL}H]HuHt;HH]HEP7A0   uR  H}@H?   H
a5  H
S5    LH   H
3 LI;   HH    }F      @t:I@   yA      @t3IYQs
IIFPII udeR  H}@H?A/   H Hp Di Th MtI.uIFIP0Dhi 2h H
R BZ8 I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hs H'v HH"HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
S H;E  H; 8  H HHug    f Q    H@L   HEo    HAHHt[HEo   HAHHtEHAHΉyH
 H
m &f Q  UH+9  HCHP0*  H+u
HCHP03Љu	HMoHl H}m e Q  f    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Ha H
% H	 2Mx-Hy L
	 ILDH@_ H
 H	 Bf    e Q    H;u
Hz HrHrH~H6HHE3LLHHM(  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+Idv Htsd R  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I Ht@d R  2e    H Hk De c H
N U   HUHM5HHUHM%HHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I,HUHtLEL+IHUHtLEL+IWELmHUHtLEL+IMtI/u
IGIP0MtI.uIFIP0HUHtLEL+IHUHtLEL+IwIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH;= toH; tfIH LHu/Hn  Hi A/   Db bQ  a Hu  H@H   HEPHudQ  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HQKHHEHHu HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHM<L}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHM<L}H]HuHtH;HH]HEP1A0   Q  H}@H   H
+ % H
+  h LH   H
 LI;   HH    }F      @t:I@   yA      @t3IGs
IIFIIz udQ  H}@HA/   H^ Hof D_ ^ MtI.uIFIP0D_ ^ H
I P8, I.u
IFIP0HUH}@HL}HuHMtIm uIEIP0HthL+IL;v\ J    H=   r=@t? HFH;r/ H+Hs H'v HH.HH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH;g toH; tfIH HHu/H Hd A/   D(^ P  \ LuE  H@H   HEPHuP  Lu  HLHHMP= H]LuHu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0H H9GuwuHHx (EHf.zu HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHM7L}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHM7L}H]LuHt3HH]HEPA0    Q  H}@H   H
& ( H
&  k LH   H
 LI;   HH    }F      @t:I@   yA      @t3IBs
IIAII} udQ  H}@HA/   Ha Hra DZ Y HtH.uHFHP0DZ Y H
<C K8/ H.u
HFHP0HUH}@HL}LuHMtIm uIEIP0MthM+IL;v_ J    H=   r=AtB IFI;r2 L+Is" I'v LI1HH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is Hɧ H3HD$hHHIK3t$ HA   HqHyrHH@0D$    Ht$(HJHS H;t- u#LD$(HT$0HY x,HT$0LD$(LGLD$(MtHW(H. Hu>Hj H{_ X    W P  P  A   H
A I   HD$`   Ht$XD$H HL$HHT$HHYHD$`HrQHHL$HH=   r<t HAH;r{ H+Hsk H'v^ H}HHL$hH3
L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3 HHu'HN H_^ W =   V sP     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_U {P  
U yP  Hh Hy] V =   H/u
HGHP0HtH+u
HSHR0DV H
t? U G3tH(HyHQrH	X Hu;H H\ oV 2   5U P  P  H
E> A2   :G3H(H\$Hl$Ht$H|$ AVH L3 HHu'H\ Hm\ U =   T KO     In3I+.HHtgff     I HHtqHGH9G ~HHOHHHHOHH u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^T SO  
T QO  H H[ U =   H/u
HGHP0HtH+u
HSHR0DT H
; S E3r@SUVWAUAVAWH 3H\$`DH\$hH\$p5 L LH   @ HHtI;uHQHtHL9HqHyMtIHtHHtHMB   H A  AM  HZ DT D
R Hm IMXHH;t;H   HB      tO9   DS D
R AH
,7 DLL$pILD$hHT$`MyS 
  TR M  [H] E3H
-] 蘄HHu*R N  'E33HmH+u
HCHP0R N  'S   Ht H\$`Lt$hHl$pH~Y LLIIUPHtH+u
HCHP0MtI.u
IFIP0HtHm u
HEHP0DR H
9 uQ CH A_A^A]_^][MtI/u
IGIP0HtH.u
HFHP0HtH/u
HGHP0H A_A^A]_^][@SH H3 HH HIhH)uHAP0H HCh3H [@SH H HH HIhH)uHAP0H HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH H HH HI`H)uHAP0H HC`3H [@SH H HH HI`H)uHAP0H HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH H HH HIXH)uHAP0H HCX3H [@SH Hs HH HIXH)uHAP0HU HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH Hs HH HIPH)uHAP0HU HCP3H [@SH H3 HH HIPH)uHAP0H HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH H3 HH HIHH)uHAP0H HCH3H [@SH H HH HIHH)uHAP0H HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH H HH HI@H)uHAP0H HC@3H [@SH H HH HI@H)uHAP0H HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H HH HI8H)uHAP0H HC83H [@SH Hs HH HI8H)uHAP0HU HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH Hs HH HI0H)uHAP0HU HC03H [@SH H3 HH HI0H)uHAP0H HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH H3 HH HI(H)uHAP0H HC(3H [@SH H HH HI(H)uHAP0H HC(3H [H\$WH LJHL;
 HtrH; tiH
s L  MIH, H	 H HM TG   F B  B  H
, A  8H\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH H HH HI H)uHAP0H HC 3H [@SH Hc HH HI H)uHAP0HE HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH Hc HH HIH)uHAP0HE HC3H [@SH H# HH HIH)uHAP0H HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HA@SVWAVAWH`H% H3HD$PL3H
9I LHAH9{S u!HrO HtH HcO ]H
jJ LH=aJ HLG HHH HHH
/S H(O HtHP Ht3H7xHH$   Hu'H HI SC l  B WA    Hq 33H9Cu+H{Ht"HCHHHH H)uHAP0   HCH;! uHIGHT$(HD$(DEHHH+H|$ Lt$0tHH   A hA    H;0    HKQ=      IGLT$@HD$@DEHL+H|$8Lt$HHA t3HKItE3HHuA pA     H  H/  HGHP0   M
 HHuH
C H
dH @ vA  VHtHx3IGE3HH IGHDEIHLtrHHuyl@ A  H HH A l  H+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0DCA H
& @ 23#H.u
HVHR0H+u
HSHR0HH$   HL$PH3H`A_A^_^[H\$WH0L
7 E3H; HHRHA3I;At   KMuH
 Hh> H	G +HBL~ H
S H\> MIHD$ H	 3u/H
 H
F 0@ k  > ;A  3H\$@H0_HHH\$@H0_HUATAUAVAWHhH   HEHXHpHx H֍ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI֌HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+I{3 HHu'HT HuE > h  = @  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH) HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p< A  
< A  H? = h  HVD H.u
HFHP0HtH/u
HGHP03D= ~< H
" .LHH.uHFHP0HEHrPHHMH=   r<ti HAH;rY H+HsI H'v< H[HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzII聅M+IHL;v II   r=Ats IFI;rc L+IsS I'vF LIbIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx HƉ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIvHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+Ik3 HHu'HD HeA : c  9 @  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p8 @  
8 @  H/ 9 c  HF@ H.u
HFHP0HtH/u
HGHP03D9 n8 H
 ~*LHH.uHFHP0HEHrPHHMH=   r<tY HAH;rI H+Hs9 H'v, HKHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIqM+IHL;v} II   r=Atc IFI;rS L+IsC I'v6 LIRIHM/H3L$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHI|HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`~HL$hH+L$XHHHLI?LHT$XHT$(HL$@PHL$@膲Hu;HJ Hk= 6 _  5 Q@  Q@  A_  H
] 'HH|$@Ht2HT$HH|}HL$PH+HHHLI?LHH|$(Ht1HT$0H@}HL$8H+HHHLI?LHHL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHID{HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`g|HL$hH+L$XHHHLI?LHT$XHT$(HL$@蠕HL$@ְHu;H H; =5 Z  4 @  @  AZ  H
- &HH|$@Ht2HT$HH{HL$PH+HHHLI?LHHH|$(Ht1HT$0H{HL$8H+HHHLI?LHHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx HV H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIyHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU|LEHUL+I3; HHu'H H9 w3 T  =2 ?  -  IM;<       HEH;tIE3HHMH IE3HUHM|HE   H}E IE3HUHMXH HD$(HMs
 HHt[HNH9N ~H HFH<HAHFHH  u H/u
HGHP0I;ܿ    >pV1 ?  
J1 ?  H i2 T  H8 H.u
HFHP0HtH/u
HGHP03D42 0 H
 #LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t HAH;ro H+Hs_ H'vR HqHE'   H}E MtzIIzM+IHL;v
 II   r=At IFI;r L+Is I'v LIIHM/H3cL$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx HF~ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHItHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUxLEHUL+I3+ HHu'H H5 g/ O  -. 7?  -  IM;<       HEH;tIE3HHMH IE3HUHMlHE   H}E IE3HUHMHH HD$(HMc HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pF- A?  
:- ??  H Y. O  H4 H.u
HFHP0HtH/u
HGHP03D$. , H
C LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<to HAH;r_ H+HsO H'vB HaHE'   H}E MtzIIuM+IHL;v II   r=At IFI;rӿ L+Isÿ I'v LIIHM/H3SL$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H6z H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIqHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUotLEHUL+I3 HHu'H H1 W+ J  * >  -  IM;<       HEH;tIE3HHMtH IE3HUHM\HE   H}E IE3HUHM8H HD$(HMS HHt[HNH9N ~H HFH<HAHFHH  u H/u
HGHP0I;ܿ    >p6) >  
*) >  H I* J  H0 H.u
HFHP0HtH/u
HGHP03D* ( H
 LHH.uHFHP0HEHrPHHMH=   r<tɼ HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t_ HAH;rO H+Hs? H'v2 HQHE'   H}E MtzIIqM+IHL;v II   r=Atӻ IFI;rû L+Is I'v LIIHM/H3CL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHpHEH$   L3DHuXWEHuDދEHu3 LHu' C  & '>    IFH;Ż tPH; tGIIe LHug& ->  m  H@H   HEPHuYD& />  J  ILHHEPHu8HZ I9FuM;~  IFJM;~  K\HIIHHV  ILHt
H)uHAP0HIEL   H. IMtA HH   H H9Gu:HwHt1H_HHHHH)uHAP0L. HH_PHn. HUHHtH.u
HFHP0HtwH/u
HGHP03IL$I9L$ ~HID$HHAID$HI~ u!H+HEPHCHP0HEP$ c>     $ `>  3   $ R>     | LH   H
 LI;   HH    }F      @t:I@   yA      @t3Is
IIII    # J>  HHj % C  H+ I,$uID$IP0MtI.u
IFIP0HtH+u
HCHP0HtH/u
HGHP0L}X  ! I.u
IFIP0MIHM芬HMH;t$HH]HHHMHHHMH0HpHpH]HMHtHU'mLEHUL+I Ht$Hq H* $ D  " q>  aHUHMHUHMZHHM@HIuȉMPN HuA# F  " >  H H* H]D# j" H
 zHH]MtI/u
IGIP0MtIm uIEIP0HHttHUHlHEH+HH;v, HH=   r<t HCH;r H+Hs H'v HHH]HtsHUHkHEH+HH;v HH=   r<t HCH;r H+Hsw H'vj HHHH$   HpA_A^A]A\_^]H\$Hl$Ht$H|$ AVH Ho* LHIH3DE9HHu! :    [=  |  3H; @3H; 3H; uH y! :  R  ]=  X  H+u
HCHP0e  H' H H-' Ha) HHEL   MtAc HHu! =   r=    H; 3H9Gu7HwHt.H_HHHHH)uHAP0MF0HHJIV0HhOHHtH.u
HFHP0Hu  =  [ =    H/u
HGHP0H
$ HOHHuU  =   =  !  H+u
HCHP0E33H:H/u
HGHP0  =   =    H) A   INH7HHu >   =  u  H]؅y >  w =    H/u
HGHP0   IN(L I;u7H
G L H H	ش R >   =    H ( sDHHu% >   =    3H;
 H(uH@P0  H& H H-& H& HHEL   MtA HHu} =  J  Hճ 3H9Cu7HsHt.H{HHHHH)uHAP0MF0HH@HIV0HMHHtH.u
HFHP0HuD/ @   =  Hj H$ H   H+   HCHP0   H+u
HCHP0H
j" HLHHu9 @   =  H H $ HtaH/u[HGHP0OH/u
HGHP0E33H$8H+u
HCHP0. =  T @  H H# D? H
  HtHm u
HUHR03
H H H\$0Hl$8Ht$@H|$HH A^HUATAUAVAWHhH   HEHXHpHx Hj H3HE'HHMWE3HEDHEDDEHEEHEHE   HEE3 LHu'H H" . 3   <    Hs8HFH; tlH;c tcIH HHu 3   <  L}^  H@H   HEHuh 3  { <  L}-  HE33HEfHu8H H9FuL;~Z  HFJ<L;~F  J|HIHHH  ILHt
H)uHAP03ID$L   H# IMtA: LH  3H% I9Fu:I^Ht1I~HHILH)uHAP0L" HHDH" INIHHtH+u
HCHP0H   I.u
IFIP0E3IMI9M ~HIEH<HAIEHI u(H/HEHGHP0HE3  
 3   <  M   3   <  L}i   3   <  LM   LH   H
 LI;   HH    }F      @t:I@   yA      @t3I s
IIII u0 3   <  E3E   H.u
HFHP0MIHMHMH;t0HH]HHHMHHHMH     H@    H@    H]HMHtHUaLEHUL+IQ Ht'H͵ H p 4  6 <  N  HUHR@HM蜖HMH;t0H0HuHHHMHHHMH     H@    H@    HuHMHt5HU^HMH+MH*HHLI?LHUA Ht'H H0  4  x <    LEHUHM>;3. LHu'HǴ H j 5  0 <  D  H]H;]\  HEH;tIE3HHMH HMH}HCMHU LHB  ILHt
H)uHQR03IFL   H  IMtA HE3H   H H9Gu:LwMt1HwIHHHH)uHAP0Lu IHR@Ha HEHMtI.u
IFIP0E3HtfH/u
HGHP03IMI9M ~HIEH4HAIEHIt uH.HFHP0 =  ` =  T =  HH H-  2   u P  P  A2   H
 z3R <  E3u 5  H H Im u
IEIP0HtH.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0H]HuD  H
 E3H]HuMtI/u
IGIP0MtI,$uID$IP0HEHrPHHMH=   r<t HAH;r H+Hs| H'vo HHE   HE    E H   HUH[HMH+H*HHHH?HH
H;v HRHH=   r=@t HFH;r٦ H+Hsɦ H'v HHHt~HUHv\HEH+HHH;v~ HH=   r<tf HCH;rV H+HsF H'v9 HHUH]HtHUH[LEL+IH\IHM'H3L$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`H1 HAL   MtA~ Hu;H H - &   $<  $<  H
s A&  3H({HAPH HAPHAPH HAPH\$WH0HIXE33>HHu?Hɮ H
r A   H ;  D] ' >3H\$@H0_H HH` H9Cue: HHu\H^ A   ;  Ht D  H+uHCHP0D  H
 3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHH   HEH$   LWEE3L}EL}PL}L}HEL}L}HEEH
Q HAH9v& u!H} HtH Hn ^H
= MH=4 LGH HH HHH
*& H3 HtHk HtIHQDHHu'HҬ H u   ; :  T  HCL   H HMtAu HHu/   
 :    H+u
HCHP0HFL   H: HMtA HHu'H( HI    
 :    H.u
HFHP0IH֣ H9Cu6HsHt-H{HHHHH)uHAP0MHHD8IH=HHtH.u
HFHP0IHu1    :    H+u
HCHP0HGHc H;   H;    H LHu ;     H/u
HGHP0IFH   MIHHtRA   IHHt?IH/yx
   > %;  
  M)&   IFI   I.u
IFIP0M/uI0&
    -;    HOHtc~A   H H
 H	j 
Hx0 ;  H    H4 H/  HGH  H;u
Hw H_H_HsHHHH/u
HGHP0LHuPHHM
 HHEH;tJHUHRHMHMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHMLHEH@HEH HEH@L}H}HHHMY HHEH;tJHUHRHMHMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUXHM,   DBoHMLMLEHUHM@HIXHHM5HUHtLEL+I輽WEL}H9 HHH9
# u&H$ HtH H5$ +H
 ?L$ H# H
 5HHu'H H 
   V	 X;  o  HFL   H HMtA HHu*H H <
   	 Z;  M   H.u
HFHP0HMݳHHu ];  M   IH! H9Cu6H{Ht-LsHIHIH)uHAP0LHI3HHR8LHtH/u
HGHP0MH.u
HFHP0IMu|9 l;  _	   H H HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0D	  H
j H+u
HCHP0MMtIm u
IEIP0HMPHtH)uHAP0LEMM HUPHMl   DBoHMLEMM HUPHM2   DBoHMHUHtLEL+IIH$   HĀ   A_A^A]A\_^]HWATAUAVAWH  H@HXHp HHWP3H`D$XHt$hD$@Ht$PHpHhH; tOHtJHD$pHD$0H$   L%q u]HǤ H
 j   0 i:    H$   H$   Hp H$   H$   L%q L$   HHL$pDHL$XH;t%HHL$XHHHL$`HHHL$hH0HpHpHT$pHtL$   L+Iw Ht'H H&
    n t:    LD$XHT$pHOQHL$@H;t%HHL$@HHHL$HHHHL$PH0HpHpHT$pHtL$   L+IHT$@H$   H
[ HAH9 u!H' HtH H ^H
 MH= LGH HH HHH
 H HtHu HtHH[:HHu'Hܢ H    E :    HCL   H HMtA HHu'H H +    :  D  H+u
HCHP0H$   ˮLHu'H< H]     :  
  HH H9Gu6H_Ht-LHIHIH)uHAP0MHIh.IH+3LHtH+u
HCHP0I.u
IFIP0Mu$H H
 :     :  kH/u
HGHP0H$    2  H$   I;HDH$   H$   ƛ   3L%8n ދHtH+u
HCHP0HtH/u
HGHP0D HLxXLh`H@hH$H  HsXHs`HshH$    t-H$   I;HDH$   H$   1 H$H  HKXLs`H{hL{XLk`HChHt
H)uHAP0MtI.u
IFIP0HtH/u
HGHP0D  H
 LHT$@HtLD$PL+InHT$XHtLD$hL+IRH$   HtL$   L+I0IL$  I[0IsHIA_A^A]A\_H\$WH0LRHH  HL;u   ^HuH
 H H	ݗ >Ist   -H
 L IBLJH HD$ H	M 3u/H
 H
1    y  J:  3H\$@H0_HHH\$@H0_sHL$AUHpHAE3H H\$hAHt$XL   H|$PALd$HEL|$8LLl$ L$   L$   L$   MtA6 Hl$`HLt$@Hu*H5 LHS      8    HFIH; u4HnHt+LvHHE IIH)uHAP0HI0/IH; uE33H21H; uHF@t3H0H E3He1LHtHm u
HEHP0IMu     8  
  H.u
HFHP0I.u
IFIP0IGIH% L   MtA Hu*H LH    ` 	9  
  H
 HD$ HAH9( u!Hg HtH H5X ^H
'	 MH-	 HLEa HHo HHH
 H5 HtHՕ HtIH3HHu*H< LHZ  	   9  
  HFHHk L   MtAܔ HHu 	  \ 9  \  H.u
HFHP03 HHu'H H O 	   9  8  IO(H;
A u0H
 H H	  	   9    H 3'HHu 	    9    H@IH;ˑ t_H; tVHMl HHu 	  d &9  d  H@L   Mu%u 	  ; (9  ;  HHMMH/uHGHP0fD  Mu>H< H9CuL;s   HCJ<HI)L;s   J|HIHAHH  H$   H$   Ht
H)uHAP0H: HH@ H9Gu% HH   HNH9N ~H HFH<HAHF!HHې 
] 	  # N9  #
  IH+u
HCHP0Hh IH9E   H]H   LuHHIIH)uHAP0LHI%m 	   L9  	   HzHʏ HHt Y 	  ` D9  `	  HH,*LHtH+u
HCHP0H.Iu
HFHP0Mu'H H 8 	   _9  !	  Hm u
HEHP0H
M  ML$   HAH9 u!H HtH H- _H
 NH5 HLF HH HHH
 H-d HtHE [ HtIHA/HHu*H LH  b 
  ( l9    HEHH L   MtAb HHu'Hk H   
   n9    Hm u
HEHP03 HHu 
   q9    H$   HI(H;
 u0H
 H H	e  
  U u9  U  H= "HHub 
  ( w9  (  H@H;L t\H; tSH HHu" 
   }9    H@L   Mu% 
   9    HHMMH+u
HCHP0Mu>Hƌ H9GuL;g   HGJHI)L;g   J\HIHAHH  H$   H$   Ht
H)uHAP0Hč HH
 H9Cuw!' HH   HMH9M ~H HEHHAHE'HHe  
   9    IH/u
HGHP0H IH9F   H~H   LvHHIIH)uHAP0LHIU!mm 
  3 9  3   HzHT HHIt Y$ 
   9    HH%LHtH/u
HGHP0Hm Iu
HEHP0IMu 
   9    H.u
HFHP0H
 ML$   HAH9\ u!Hk HtH H5\ ^H
C  MH-:  HLE} HH HHH
 H5! HtH HtIH*HHu'HX Hy     9  4  HFHHB  L   MtA HHu   { 9  {  H.u
HFHP0HÊ IH9Eu6HuHt-LuHHIIH)uHAP0MHI.IH#LHtH.u
HFHP0Mu'Hm H     9    Hm u
HEHP0IL$   MH)uHAP0H 98   HL$  HHu'H H    ` 9    IV Hu'H H d   * 9    H;t7H
ŋ H	 H H (    9  a  H
N HAH9K u!Hz HtH H-k _H
 NH5 HLF HH HHH
 H-0 HtHE g HtIHM(HHu'Hΐ H q 
  7 9    HEHH L   MtAq HHu'Hz H  
   9    Hm u
HEHP0    HHu 9     IH@L0I$HEL`H H9Fu6H~Ht-LvHHIIH)uHAP0LHI`HH#!LHtH/u
HGHP0Hm Iu
HEHP0IM    
:  + 
  Hp H HtH.u
HFHP0HtHm u
HEHP0HtH/u
HGHP0HtH+u
HCHP0L$   L$   D H
 t H.u
HFHP0IMHL$ Lt$@H|$PHt$XHl$`H\$hHt
H)uHAP0MtI/u
IGIP0L|$8MtI,$uID$IP0Ld$HMtIm u
IEIP0H$   HtH(u
HPHR0IHpA][HHPHHATH   E3HXHhAHxALhELpELxEL` HAH Ld$PLd$xL   Ld$pLd$XMtA H$   HHu'H H $     7  Y  HGIH;; u6HwHt-HGHHHH H)u
HAP0HHH}IH; uE33H!1H;4 uHG@t3HH% E3H HD$`HtH.u
HFHP0Ht$`L$   Hu'H H B    .7    H/u
HGHP0H.Iu
HFHP03 HHu'HE Hf     :7    H$   HI(H;
҄ u0H
 Hj H	y    i >7  
  HQ HHuv   < @7  
  H@H;` toH; tfHHD$` H$   Hu(    F7  ^
  H@H   HL$hHu3    H7  0
  HLH$   H\$`Ld$hH\$`HL$   H/u
HGHP0HuHH I9FuI;^w  IFH<HHH\$`-I;^X  I|HHH\$`IHH  HL$XHH|$XHt
H)uHAP0H
i IHAH9 u!H HtH L- _H
r NHi HLC LH HHH
 L- MtIE  HtMHe!LM  IEIH[ L   MtA HH  Im u
IEIP0Hȁ HH H9Eu{+ LH,  H
` HAH9U u&Ht HtH L5e rH
  aH- HLE LH HHH
 L5% Mt
IHl$X%p Ht
Hl$XMHQ Hl$XLMl  IFIH" L   MtA LH"  I.u
IFIP0H HH H9Euc LH  H@ L$   I9GuBIoH$   Ht1IGIHE LH H)u
HAP0IMHHII]H$   HHt
H)uHAP0I.u
IFIP0MH  I/u
IGIP0   a LH  H
6 E3LhHMHh `HH  I/u
IGIP0HE MH9Cu6L{Mt-H{HIHHH)uHAP0LIHHHsHMtI/u
IGIP0Hm Mu
HEHP0IH   H+u
HCHP0HNIH9N ~HHFH<HAHFHH}    H/H\$`Hl$hL$   |HGHP0mII.u
IFIP0H$   HH\$P蒶  H3 HT     7  
      7       j 7       Q 7    r   8 7    Y    7    @    x7  s  '    u7  Z      s7  >      q7  "      n7  	     I l7    o~ HH{ HHt{ fw   I: d7    tH(  H$   HH(H;
T} u>H
+~ H H	| Ht H     7  L  H 8HHu'H9 HZ     7       | H$   Hu{ 7  I  HE3H
 HHXHp HHuD 7  I  H$   H)uHAP0HFH;Pz tbH;{ tYHI{ H$   LHu 7  IA  H@H   H$   Hu. 7  I  HLH$   MIL$   H.u
HFHP0IINH$   LfD  Hu<Hy I9FuM;~=  HJ4HI'M;~$  J4HIIHH  HFHz H;   H;;y tHz HHZ  H.u
HFHP0HEHMH   HH  HA   HH  HH)z  L)u uGHEH;HNH  H;u
H^ H~H~H_H?HHH.u
HFHP0IH|$xLHt
H)uHAP0H$   IH$   H$   Ht
H)uHAP0IEIH;$x tKH;sy tBIHy HHX  H@L   Mu(    L8    IE IIMfMu>Hw H9FuH;n   H^HHH)H;n   H\HHHAHH   HL$pH\$pHt
H)uHAP0IEHHpHtHAHt
HIHI4HH  L$   H8HH  H+u
HCHP0HT$pLII`z I  H/HGHP0I+ty Ht Hv HHH  v H.u
HFHP0H$   IH$   L$   H$   H$   H MH M-   M /8    Hm u
HEHP0IuIH; MHY M   M 78  .     M '8  MM      ` J8  +     G |8  Ck   1 y8  -U    w8  ?    g8  IHw~ MH MH$   MH$   IY~H
v H A   H	cv 
Hx 8     MMMIH ~ H! HtH.u
HFHP0HI  H/?  HGHP00  4w Ht Hpt HHe   t I.u
IFIP0H\$PHLL$   L$   L$   H$   H$   H$   HtH+u
HCHP0HL$xH$   Ht
H)uHAP0H$   Ht
H)uHAP0HL$pHt
H)uHAP0HD$XHtH(u
HPHR0IH   A\: 8  `   H| MH MMIH$   Ht
H)uHAP0MtIm u
IEIP0HtH+u
HCHP0HtHm u
HEHP0MtI.u
IFIP0MtI/u
IGIP0H\$PD H
* x nH\$Hl$VWAVH@Hu IHzLH\$pHM   HtH   HZH\$pH+t HHu-H  H HLB>r HtHHD$pHH   H~ HHD$(LL$pHb H|$ y
6     H\$p   H   H   Hy H|$0HH H?L
 HL! HHDHHD$(H HL$ LIH
Jt H H	r 6  Hz H  +   A  H
 3HZHIBH\$`Hl$hH@A^_^HHPHHATH   HU E3HXAHhAHpAHxLhEHALd$hLd$pLd$PL   L$   MtAr L$   HL$   Hu'Hy H D   
 5  
  HGH;^q u4HoHt+LwHHE IIH)uHAP0HI
IH;t uE33H
1H;Yt uHG@t3HHJ E3HLHtHm u
HEHP0MMu   HC 5  	  H/u
HGHP0I.Iu
IFIP03o LHu*Hx HH      5  	  H$   HI(H;
q u&H
q HR H	p  5    H HHu 5  ^  H@HH;n Hl$XtMH;o tDHGp LHuI 5    H@H   HL$`Hu% 5    HLILd$`H/u
HGHP0HD$`Hu>H%n I9GuI;o\  IGH<HH(I;oB  I|HHIHH   HL$hH|$hHt
H)uHAP0H*o HH H9Gum HH   Hn HH H9Gu]m HHtgH/u
HGHP0INII9N ~HIFHHAIFHIm uH+HCH 6      6      6     o HtHl HH˾tY)m I/u
IGIP0H$   IL$   )ydHu H q   7 #6  "  ( 6  IHu H =   I.u
IFIP0Ha  tIMv  3l LHu'HMu Hn     (6    H$   HH(H;
m uAH
n H H	m Ht IH    ` ,6    H  HHu'Ht H _   % .6       Im HHu'Ht H %    06  g  IE3H
 HLpHX %HHu 86    H/u
HGHP0HCH;j thH;l t_Hol HHu'Hs H    Y ?6    H@H   Hl$`Hu'5 A6  I  HHLd$XILd$`HH+u
HCHP0HuHH,j H9GuH;w^  HGHHHHt$X-H;w?  H\HHHt$XHHH  HCH'k H;%  H;i   Hhk HH  H+u
HSHR0HNIMH   HH$   MHz  HA   LHc  HH?  L)6u
HFHP0Hl$`HL$pH$   H\$pHt
H)uHAP0HL$PL$   L$   Ht
H)uHAP0L$   HMHHQ  IOI9O ~eH IGHHAIGdHKHc  H;u
Lk HCHCLhH H$   H IE H+6HCHP0'HIh    H+tH$   Ht$XHD$PHCHP0H$   Ht$XHD$P 6    H.u
HFHP0IuI 6     ~6    Hp IH$   H H$   HD$Pz   @ 6    Hp IH$   H H$   HD$P;    6  h  ~,H
h H  A   H	h  i6    Hx i6     i Ht Hf HHԸ   .g H/u
HGHP0H$   ML$   L$   L$   H$   H$   H$   HtHm u
HEHP0HL$hH$   Ht
H)uHAP0HL$pHt
H)uHAP0HD$PHtH(u
HPHR0IH   A\ ]6  IL$   MH$      Ho H8 HtH/u
HGHP0MtI/u
IGIP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtH.u
HFHP0D9 H
N  H\$Hl$VWAVH@HOh IHzLH\$pHM   HtH   HZH\$pHf HHu-H  H HLBd HtHHD$pHH   H HHD$(LL$pHv H|$ y
5     H\$p   H   H   H9l H|$0HHks H?L
D HLQ HHDHHD$(H2 HL$ LIH
f H+ H	Je 5  Hm H/     A  H
* 3HZHIH\$`Hl$hH@A^_^ATAWH(HAE3H EH\$@Hl$HHL   MtA[e Ht$PHH|$XLt$ Hu'HUl Hv     4    HCIH;d u3H{Ht*HsHHHHH)uHAP0HHTIH;f uE33H 1H;g uHC@t3HH E3HHHtH/u
HGHP0IHu'Hk H %    4    H+u
HCHP0H.Iu
HFHP03b HHu'H(k HI     	5    HM(H;
c u&H
d H H	dc ^ 
5    HF HHu; 5    H@H;_a tLH;b tCHHb HHu 5    H@L   Mu 5    HHIMH+u
HCHP0Mu>H` H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0Ha HHG H9CuT` HHtEHNH9N ~H HFHHAHF5HH` ! =5      ;5     b HtH_ HHtfQ` H/u
HGHP0HLH.u
HFHP0Lt$ H|$XHt$PHl$HH\$@MtI/u
IWIR0IH(A_A\C 35  Hh H [   H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D H
  LHWATAUAVAWH   H@HXHpMLLW@E3LxD$`L|$pD$HL|$XD$0L|$@H
 HAH9r u!H HtH Hz ^H
) MH=  LGHc^ HHq HHH
& H? HtH` HtIHHHu'H>g H_     b4     HCL   H, HMtA_ HHu'Hf H    S d4    H+u
HCHP0IH^ H9Fu6H^Ht-H~HHHHH)uHAP0MHHIHHHtH+u
HCHP0IHu'HBf Hc     s4    H.u
HFHP0HGL   H HMtA^ HHu'He H    G v4  a  H/u
HGHP0HH$   ~iHHL$HQGH$   HtL$   L+Iz^ Ht'H^e H     y4    H.u
HFHP0IHT$HHL$xBIdÀu2|^ Ht'Hd H    a 4    HT$xH$   CDLH$   IM
HHL$0aFH$   HtL$   L+IyHT$0HL$`BH
Y HAH9 u!H HtH H= ^H
 MH LCHZ HH
 HHH
 H=s HtHs] HtIHYHHu'Hc H }   C 4    HGL   H HMtA}\ HHu'Hc H )    4  	  H/u
HGHP0HL$`oLHu'H=c H^     4     IHZ H9Cu6H{Ht-HsHHHHH)uHAP0MHHiIH,HHtH/u
HGHP0I.u
IFIP0Hu$Hb H ;    4  3H+usHCHP0gE3AAAHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0D  H
* 襵IHT$0HtLD$@L+IGwHT$HHtLD$XL+I+wHT$`HtLD$pL+IwHT$xHtL$   L+IvHL$   I[0Is8IA_A^A]A\_H\$Hl$Ht$WATAUAVAWHPHE[ E3Ld$@MH\$HHLAM   LzIMt"HtH   HZ H\$HHzH|$@IY HIMtHt*UH2 ILBW HD$@HH   HH,  H ILBdW HtHHD$HHH   H IHD$(LL$@Hj L|$ y
04     H\$HH|$@   HBH   H   HNH^ HHL$0Hf HLL
۽ AHD$(IHؽ HLd$ H
pY L LMHƽ H	W @4  H_ H   F   A  H
5  3HZ HzLHI6L\$PI[0Ik8Is@IA_A^A]A\_HHHATAUAWH   H@HXHpHx MMLW@H@    @H@    H
 HAH9 u!H HtH H= ]H
G LH> LCHU HH HHH
\ H= HtHW Ht3HHHu'H]^ H~     ƿ 3  /  HGL   HK HMtA W HHu'H	^ H*    r 3    H/u
HGHP03HU H9Cu6H{Ht-HsHHHHH)uHAP0MHH&IHHHtH/u
HGHP03Hu'Hc] H    ̾ 3     H+u
HCHP0HFL   H	 HMtAU HHu'H\ H     h 3    H.u
HFHP0H|$ HHL$h`HHL$8p>HT$hHtLD$xL+IqV Ht'H\ H &    3  @  H+u
HCHP0HT$8HL$P9I茌@@u2U Ht'H\ H?     3     IFÀu2^U Ht'H[ H }   C 3     HT$PHL$h:DDHH$   HIT HH   Hu[ H    ޼ 3  JHt$ HHHtH.u
HFHP0HtH/u
HGHP0HtH+u
HCHP0D  H
J 蕮3HT$8HtLD$HL+I8pHT$PHtLD$`L+IpHL$   I[(Is0I{8IA_A]A\H\$ UVWATAUAVAWH`H= H3HD$XH-nT E3H5dR MLt$@HHl$HLHt$PM4  LbIMt1Ht"HtH4  Hr(Ht$PHj Hl$HLrLt$@IR HIMtHt3HtZ   H: ILBP HD$@LH   HHw  H ILBlP HtHHD$HHHJ  H ILB?P HtHHD$PHH  H IHD$(LL$@H3
 Ld$ y
3     Ht$PHl$HLt$@   HBH   H   H   HSHW HHT$0A   H
^ HLL
 HL$(   H
HR H;AML HHD$ H	H MML4 P 3  HjX H     A  H
6 3Hr(Hj LrLLIIHL$XH3mH$   H`A_A^A]A\_^]@SVWATAVAWHxH H3HD$`L3H
 MLHAH9 u!H HtH H= ]H
 LH HLCWN HHe HHH
b H= HtHP Ht3HHHl$pHu'H.W HO ѹ     3    HGHHP L   MtAO HHu[ 3  "  H/u
HGHP0HCHH L   MtAO HHu'HV H 1    3    H+u
HCHP0H?N 33H9Gu+H_Ht"HGHHHH H)uHAP0   HGH;P uIHT$(HDEH+H\$ HLt$(L|$0Ld$8HH   U 3    H;P    HOQ=      LT$HHDEL+H\$@Lt$HL|$PLd$XHA t3HOItE3HHuҶ 3     H  H+  HCHP0   MM HHuH
U H
0  %3  ZHtHX3IE3HHLtEIL|EI$LdHHuy4 33  HT Hʽ L   H/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0D H
 ε 3#H.u
HVHR0H/u
HWHR0HHl$pHL$`H3|iHxA_A^A\_^[H\$Hl$Ht$WAVAWHPHL MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@IL HHHtHt/ZHR  H˴ ILB&J HtHHD$@HH%  HN ILBI HtHHD$HHH   H IHD$(LL$@H[ Hl$ Sy
2     H|$HH\$@   H   H   H   H
 Hl$0HL
{ H?L HH HHLIH
oX HL$(H
K HD$ H	J 2  HER Hf     A  H
 輥3Hz HZLHIH\$pHl$xH$   HPA_A^_H\$Hl$Ht$WAVAWH HMH
 MHHAH9 u!H HtH H ]H
 LH= HLGKH HHY HHH
 HO HtHJ Ht3HHHu'H'Q HH ʳ    v2    HCHHI L   MtAI HHuT x2  D  H+u
HCHP0HGHHm L   MtA~I HHu'HP H *    {2    H/u
HGHP0AG HHuñ ~2     H LHG y 2     H} LHF yw 2  jH
 MHF yT 2  GHO MHF y1 2  $H LHyHHud 2  HO H #   H+u
HCHP0HtH/u
HWHR0D H
|  Ѣ3#H+u
HSHR0H/u
HWHR0HH\$@Hl$HHt$PH A_A^_@SUVWATAVAWH`H H3HD$XH={G MH- LH5 LrH|$@IHl$HHt$PM2  Mt1Ht"HtH>  Hr(Ht$PHj Hl$HHzH|$@IF HIMtHt8Ht_   H  H ILBD HtHHD$@HHt  H ILBD HtHHD$HHHG  HK ILBD HtHHD$PHH  H IHD$(LL$@HV Lt$ y
E2     Ht$PHl$HH|$@   M   H   H   H   HK Lt$0IHS H?L
 HL HHHDMHD$(H HL$ LIH
xF H٪ H	D Y2  HL Hݵ 3 Y y  Ay  H
h 33Hr(Hj HzLLHIHL$XH3aH`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   H MtAD H|$PHHu v  n 1  k  B HHuQ 1        uD HHuH
K H
ϴ ! 1  lILLxHH yB y 1  4H+u
HCHP0H LH/HHuf 1  H6K HW ٭ v  H.u
HFHP0HtH/u
HGHP0H   H+   HCHP0uH.u
HFHP0H/u
HGHP0HCHHHpHtHAHt
IHIHSHu=8 w   1  HsJ H D H
 ܫ LL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAHO L   MtAB Ht$0HHu?HI H
 As  Hز 1  DX " 93Ht$0H [HCH|$83H;bA u3H{Ht*HsHHHHH)uHAP0HHIH;D uE33H1H;^D uHC@t3H HO E3HHHtH/u
HGHP0H|$8HuaHH As  1  H Dn 8 HtH+uHSHR0DL  H
{ &3Ht$0H [H+u
HSHR0HHt$0H [K@UAVH(H\$@3H|$PDL|$ LH
 HAH9 u!H HtH H ^H
 MH= HLG> HH HHH
; H HtH$A HtHH
HHt$HHu'HG H ) o   1  d  HCHH L   MtA)@ HHu o   
1    H+u
HCHP0HGHH¯ L   MtA? HHu o  S 
1    H/u
HGHP0H> HH9Cu6H{Ht-HsHHHHH)uHAP0MHHIHHHtH/u
HGHP0Hu o   1     H+u
HCHP0H
 LHAH9 u!H5 HtH H& ^H
Ů MH= HLG< HH HHH
j H HtH#? HtHH	HHu'HE H - p   *1  h  HuyA p  ̦ ,1  HAE Hb H/  H+%  HCH  H+u
HCHP0.  HFHH L   MtA= HHu'HD H r p  8 /1     H< HH9Gu:H_Ht1HwHHHHH)uHAP0L" HHH HHHtH+u
HCHP0HuR p   =1  HD H? HtH/u
HGHP0D H
{ r 艗H/uHGHP0HHL|$ H|$PHt$HH\$@MtI.u
IVIR0HH(A^]KH\$Hl$WH HH
W HAH9 u!H HtH H ]H
C LH=: HLG9 HH HHH
H HY HtHq< Ht3HXHHt$0Hu'HB H w l  = 0  h  HCHH L   MtAw; HHu 0     H+u
HCHP0HGHH L   MtA+; HHu;H/H0B HQ Ӥ l   0     HGHP0   H/u
HGHP0H9 3H9Cu6H{Ht-HsHHHHH)uHAP0LHH=HH HHtH/u
HGHP0HuT 0  HrA H  l  HtH+u
HSHR0D H
Nx  Ӕ3H+u
HSHR0HHt$0H\$8Hl$@H _{@USVWATAUAVAWH$H8  H H3H(  E3LEMHT$PLLL$XH  AHT$xMHL$@EI AHHAH LuLuL   LuH\$8LuLuLuLuLuLuLuLuLuLuLuLt$pLt$HLt$0MtA9 HHu'H@ H-  1  u {*  F  HGH;7 u3H_Ht*LwHHIIH)uHAP0HIIH;}: uE33Hf1H;: uHG@t3HgH E3HCLHtH+u
HCHP03Mu*H=? DH[ ݡ 1   *  -E  H/u
HGHP0I.u
IFIP0H
8 E3L;  L;A  H
 HAH9 u!H3 HtH H=$ ^H
3 MH* HLCe5 HHs HHH
Ȱ H= HtH7 HtIHHHu*H@> HH^  3   *  D  HGHH/ L   MtA6 HHu*H= LH  3  O *  C  H/u
HGHP0H5 IH9Cu:H{Ht1LsHHIIH)uHAP0L HIH HLHtH/u
HGHP0Mu*H9= LHW ٟ 3   *  >C  H+u
HCHP0I.u
IFIP0E3H
5 H9L$x  L;=4 A  H
 HAH9 u!H	 HtH H aH
) PH=  HLG[3 HHi HHH
Ʈ H HtH5 HtE3AHHE3Hu*H0< HHN О 5   *  B  HCHH L   MtA4 HHu*H; LH y 5  ? *  A  H+u
HCHP0H3 IH9Gu:H_Ht1LwHHIIH)uHAP0LѦ HIH HLHtH+u
HCHP0IMu*H&; LHD Ɲ 5   *  A  H/u
HGHP0I.u
IFIP0H
3 E3H|$PH;   Lt$@IF(H;uAH
T4 HUn H	$3 H: HH = 8   +  A  HÜ H[Hu*H_: HH}  8  ś +  @  H/HHD$Pi  HGP0]  H
 HAH9L u!H۰ HtH L5̰ ^H
; MH2 HLC0 LH HHH
  L5 MtI!3 HtMHLMu*H9 HH ( 9   .+  ?  IH)0 ؃u 9  I 0+  A  I.u
IFIP0t\   o0 HHu*H9 HH&  :  n <+  ?  HHH@HT$PH8H/uHGP0Lt$@H
 HAH9 u!H6 HtH H=' ^H
 MH HLCP/ HH^ HHH
ê H= HtH1 HtIHHHu*H+8 HHI ˚ ;   U+  >  HGHHJ L   MtA0 HHu*H7 LH t ;  : W+  =  H/u
HGHP0HCHH# L   MtAd0 HHu*Hm7 LH 
 ;  Ә Z+  r=  H+u
HCHP0IN(IH;
/ uAH
0 HLk H	/ H7 LH*  ;  r _+  <  H2 HHu*H6 LH n ;  4 a+  <  IN(H;
`/ uAH
70 Hj H	/ H6 LH   ;   e+  p<  H ALHu*H
B6 LH
`  ;   g+  2<  H . MEL|$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;0    HD$PHU`HE`EFAHHH+LmXH]hLepeLHu* x+  H|5 LH  ;  v;  MtIm u
IEIP0H+L|$Hu
HCHP0I,$i  ID$IY  H;Q0    HWJ=   utHD$PL   H   EFAHL+LmxH   IL   LZ uHGIHtE3AALH8 +  	AN:- LHu*H
s4 LH
  ;  ٕ +  c:  HD$HHt	IEL|$HHL$PE3AIHILAFI\HAFIMdMLHu*H3 MH  ;  ^ +  9  Im u
IEIP0H/u
HGHP0HL$PIMLt$PH)uHAP0H\$xH;K, uMs* Hu-Hw3 MH H =  ڔ +  9  H+HHD$xuHCP0Ll$@IM(H;
+ uDH
, Hg H	+ H3 MH* H ?  o +  ?9  H/ ʾLHu-H2 MH Hh ?  . +  8  IM(H;
Z+ u0H
1, H2g H	+ + ?   +  -:  H) LHHu ?  ē +   :  HI* HD$0HHu̔ ?   +  9  I.u
IFIP0H/u
HGHP0H
ҙ MH]L|$0HAH9 u!H2 HtH H=# ^H
 MH HLCl( HHz HHH
g H= HtH* HtIHHHu*HG1 HHe  @   +  }7  HGHHf L   MtA) LHu0H0 IH L @  MP +  6  H/u
HGHP0IFIH L   MtAz) HHu4 @   +  ;8  I.u
IFIP0HB( MAH9Gu+LwMt"HGHIHH H)uHAP0   HGH;* uSHEHU HE DCHHH+LuLeHD$0HH    @  L +  7  H;*    HOQ=      HELUHEDCHL+LuLe HAI uHOItE3HD$0HHu @    ,  7  MtI.u
IFIP0M   K' LHu @  y ,  6  MtLpMHME3HT$PHILCHHITIHD$0HHuU @   ,  _6  I,$uID$IP0H/u
HGHP0H+u
HCHP0H
I L|$0HAH9y u!H` HtH H=Q ^H
0 MH' HLC$ HH HHH
- H= HtH^' HtIHDHHuv B  < ,  }5  HGHH L   MtAv& LHu0 B   !,  :5  H/u
HGHP0ID$IH& L   MtA& HHuُ B   $,  4  I,$uID$IP0IM(MH;
% u0H
& Ha H	]%  B  M ),  4  H
 訸LHuZ B    +,  d4  IM(H;
L% u0H
#& Hta H	$  C   7,  '4  H >LHu-H?, IH] L܎ C   9,  ,2  IM(H;
$ u0H
% Ha H	u$  D  e E,  3  H HHur D  8 G,  3  H# ML|$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;5&   HD$PH   H   EGAHHH+L   L   L   H   HD$0Hu B  x `,  2  MtIm u
IEIP0E3I,$L|$HuID$IP0I.u
IFIP0H+u
HCHP0Lt$0H/u
HGHP03Lu! HD$0LH  Hf* IH\$8H  G  ǋ ,  0  H;o%    HOQ=      HD$PL  H   EGAE3HL+L   L  L  H  HAA uHOItE3HD$0HuY B   k,  f1  MIm IEIP0AO!" HHu'H
Z) H
{  B  Ê t,  1  MtLh3HD$HLl$PE3AHHLdAGLtAGH\AGIE E3ELlAǼLHu'H( H { B  A ,  .  H.HFHP0H\$@HK(H;
O! uFH
&" H] H	  Ho( IH\$8H 
 G  Љ ,  .  Hؑ +HHu/H,( IH\$8HE Ǌ G   ,  ].  HK(H;
  uGH
! HY] H	`  H' IH Mv G  I9 ,  -  HY 蔳HHu-H' IH M2 G   ,  -       HHu*HU' MHs  G   ,  E-  H
˒ E3HHxHp HHu*H	' MH'  G  o ,  -  H+u
HCHP0HFH;    H;    HI HHu,H& H\$8H : G    ,  ,  H@H   H|$hHu;H[& MHy  G   ,  `,  HHML|$hIH.uHFHP0    Hu>H H9CuL;k  HCJ4HI(L;k  JtHIHHH.  HFH H;   H;Y    H HD$`LH#  H.u
HFHP0ID$IHL$`E3EL   AHH  HL$`EfALH  Ld$`IAH-T  I,$uHID$I;HNH  H;u
Lv H~H~LwH?HIH.u
HFHP0HMH}Ht
H)uHAP0HMIHEHtH)u
HAP0IHHP Lt$0HHb  INI9N ~H IFH4HAIFHId   H.A    H|$hHFHP0IH+u
HCHP0HMLuMET  H# H\$8H  I  J -  *  k G  1 ,  x+  HL$`H)uHAP0HD$`    uILd$`! G    -  .+  HW# Hx  G   ,  _)  H0# E3HN Ѕ G   	-  5)  H# E3H$  G  l -  )  ~H
* H A   H	 
Hx8H" MHϋ Q G   ,  (    HjH8 HH-kt IHW" MHu  G   ,  \(    H
 HAH9| u!H HtH H| ^H
# MH= HLG HHˉ HHH
0 HA HtH1 HtIHHHu,H! H\$8H 6 J   !-  '  HCHH L   MtA6 HHu*H?! MH] ߃ J   #-  D'  H+u
HCHP0H IH9Fu3H^Ht*H~HHHHH)uHAP0HH+HaLHtH+u
HCHP0Mu,H  H\$8H ; J   2-  &  H.u
HFHP0Ll$PIIH\$8IEH;    H;P    HIH|$` HD$0LHu'H  H5  K  } C-  M&  H@H   HD$XHuCH H { K  A E-  &  IE IHD$XMLl$0IL|$`LmM H\$8HuHH7 I9FuI;~  IFH4HHH|$`-I;~  ItHHH|$`IHH  IHuLHt
H)uHAP03a HHB  LEI@HHpHtHAHt
IIII莭HH  H@H;o tSH; tJHI LH  H@H   H|$hHu-( M  I -  2&  HLML|$hIH+uHCHP0Hu>H I9FuM;n  IFJHI(M;n  K\HIIHHs  HL$pH\$pHt
H)uHAP0H
 IHAH9s u&Hҏ HtH H=Ï lH
 [L= IMGW HHe HHH
" H= HtHE3! HtE3AI諴E3HH,  HGHHn L   MtA LH  H/u
HGHP0ID$IH L   MtA HH  I,$uID$IP0H MAH9Gu/LgMt&HGHI$HH H)uHAP0   DHGH;2 uaHD$pDAHE0HU0HD$@Le(H@(HE8HHH+HHj
  MtI,$uID$IP0E3E  H;(    HWDBA=   u|HD$pLUHHEHDYHD$@E3Le@H@(HEPAHL+HBA uHOAIMtE3HH  MtI,$uID$IP0M| HD$HHH  MtL`E3HD$pE3HT$@H JDHB(H HB(HJD HHH  HL$HH)uHAP0E3L|$HH/u
HGHP0HNIH9N ~HHFHHAHFHH   H+H|$hHHCHP09 Ht H' HHcm  v I.u
IFIP0HMLHuHt
H)uHAP0H
 IHAH9ܙ u!H; HtH L5, ^H
s MHj HLC LH HHH
 L5 MtI! HtMHLM}  IFIH L   MtAN HH0  I.u
IFIP0H+ IH9Cu6H{Ht-HsHHHHH)uHAP0MHH薥IHYHHtH/u
HGHP0H  H+u
HCHP0HMLHuHt
H)uHAP0H|$xIH<~ HHGL   MtAf HH  HS IH9Cu3H{Ht*HsHHHHH)uHAP0HH葩HǪHHtH/u
HGHP0HX  H+u
HCHP0LmHI ؅xA؅  H.u
HFHP0I  IFIH| L   MtAu HH
  H|$xHGHHpHtHAHt
IHIHLH	  H& IH9Cu6H{Ht-HsHHHHH)uHAP0MHH董IHTHHtH/u
HGHP0I.u
IFIP0H  H+u
HCHP0HMLHuH)uHAP0
 HH  MIHr
 @  HMLHuHt
H)uHAP0HL$8IH~ HAL   MtA HH
  H  IH9Cu6H{Ht-HsHHHHH)uHAP0MHHkIH.HHtH/u
HGHP0H#
  H+u
HCHP0H.u
HFHP0H|$@IHO(H;
:   Hw XHHc  H@HH~ L   MtA LH  H+u
HCHP0H II9Fu;I^Ht2I~IHLHH)uHAP0MHHgH|$@II%HHtH+u
HCHP0IH`  I.u
IFIP0HMHH]Ht
H)uHAP0HO(IH;
&
 
  H~ DHH
  H@HHpHtHAHt
HHHHݢHH5
  H.u
HFHP0HMLH]Ht
H)uHAP034 HH	  A   HI HH~	  H.u
HFHP0HIC-	  H+u
HSHR0t'   
 H  H~~ HHHHIII.IHHEuIFP0HUH
"{ 腤LH     f
 HHZ  H@HHL0W HH  H+u
HSHR0HMH}Ht
H)uHAP0H\$8HCHHpHtHAHt
IHIHILH}  H@IHw L   MtA@ HH0  I.u
IFIP0   
 LH  HHx	 HH  L{ HHsz  m  LIH迥HH:  H+u
HCHP0I.Iu
IFIP0H.u
HFHP0HL$8LII   H/u
HGHP0LuI Hq  HA@ǅtpE3IAQHHk  HL| A   HHH#  H/u
HGHP0HJA  H.u
HVHR0Lt$0H|$`HD$X9H
x HAH9~ u!Hn HtH H=_ ^H
} MH5} HLFX HHfx HHH
~ H=$ HtH	 HtIH貧HH   HGHH0y L   MtA LH  H/u
HGHP0LD$8I@HHpHtHAHt
IIII腞HH]  H I9Fu6I^Ht-IvIHLHH)uHAP0LHHHIˠHHtH+u
HCHP0H/Iu
HGHP0IH  I.u
IFIP0H\$8LHIH	 Lt$0g  H.H|$`HD$XdHFHP0HD$XPH Lt$0Hw rq M  8p -    Yq L  p -  f  @q L  p -  M  'q L  o -  4  q L  o -    p L  o -    p L  o -    p L  o -    p L  po -    p M  ITo -    H
 Lt$0Hv bp P  (o E.    H
 Lt$0Hv 6p P  n 6.    Hl
 Lt$0Hv 
p P  n 4.    H@
 Lt$0H\v o V  n .  X  H
 Lt$0H0v o [  xn /  ,  H H	v o [  Qn /    H Lt$0Hu _o [  %n 
/    H Hu 8o \  m 3/    o \  m 0/  ,  o \  Im !/    H9 IHWu n \  m /  $  H IH-u n \  um /  )  H Lt$0Hu n [  Im /    H Ht \n Y  "m .    Cn Y  	m .  P  *n Y  Il .  4  n Y  Il .    HA Lt$0H]t m Y  l .  D  m Y  Il .    H
 Lt$0Ht m Y  ]l .    H
 Lt$0Hs km W  1l .    Rm W  Il .  \  H
 Lt$0Hs #m W  k .    HY
 Lt$0Hus l V  k .  \  H-
 Lt$0HIs l V  k .  E  H
 Lt$0Hs l V  ek .    H	 Lt$0Hr sl T  9k .    H	 Lt$0Hr Gl T  
k .    H
 H6? H	 Hf	 Lt$0Hr l T  j .  ~  k S  Ij .    H	 Lt$0H:r k S  j .  !  H Lt$0Hr k S  Vj .  
  H
f HW> H	6 H Lt$0Hq Mk S  j .    H Lt$0Hq !k R  i v.    HW Lt$0Hsq j R  i h.  o  H+ Lt$0HGq j Q  i ].  C  H Lt$0Hq j Q  ci [.    H Lt$0Hp qj O  7i (.  
  H Lt$0Hp Ej O  i %.  
  H{ Lt$0Hp j O  h .  
  HO Lt$0Hkp i N  h 
.  R
  i N  Ih -    H Lt$0H#p i N  kh -  
  H Ho ~i M  Dh z-    H Ho Wi L  h p-      HtHB HH7Ot I.  IFI  HP Hqo h K  g `-  r  3 LHu,H H\$8H5o h ^  }g [/  M  H\$@MHD$8HK(H;
 uCH
s H; H	C H H\$8Hn Zh _   g i/    HXn {LHu,H| H\$8Hn h _  f k/    I LHu,H> H\$8HZn g _  f m/  r  I.u
IFIP0MIMZ
  ff     H
l HAH9z u&Hw HtH H5w rH
q (aHq HLCz HHl HHH
]z H5vw Ht
HH\$@% Ht
H\$@IHʛH\$@HHy  HFHHi L   MtA LH  H.u
HFHP0IFIHi L   MtA HH  I.u
IFIP0I. LH3  H IAH9Fu.H~Ht%HFHHHH H)uHAP0   DHFH;>   HC(DAH   H   HD$XH   HHH+H   L   HD$0HH/  HtH/u
HGHP0E3I.Iu
IFIP0Lt$XH.u
HFHP0HMIH]Ht
H)uHAP0HD$@HH(H;
a }	  H,l HD$0HH9	  E33H!HHK  H+u
HCHP0HMHH]Ht
H)uHAP0II}2     HD$@HH(H;
   Hj HH  E33H蔑LHm  H.u
HFHP0IH HH  I.u
IFIP0H+HHuuHCP0H
ui HAH9} `  HՀ HG  H L5   H;    LFAP=      HC(L   H   DYHD$XE3H   AHL+H   L   I@ uHNMItE3HD$0HH  HH/HGHP0L HH  HtHx3HL$@E3NtHLt$XHA(H HA(HJD INt((HD$0Hc  H+u
HCHP0H\$0E3?H
l MHl HLC LHg HHH
3| L5L MtIL HtMH2LMB  IFIHh L   MtAy HH  I.u
IFIP0HV MH9Cu7LsMt.HsHIHHH)uHAP0LEIHHUH肐HMtI.u
IFIP0MH3  H+u
HCHP0HFHH8h L   MtA HH  H.u
HFHP0HMIH]Ht
H)uHAP0H
yf HAH9{ u&Ht HtH Ht lH
j ȕ[L5j IMF HH(f HHH
{ Ht HtHL! HtILInLHH  HCHHac L   MtA HHu  H+u
HCHP0   [ HH$  H
c H       HHH@HuLEHs(I@HHpHtHAHt
HIHIHH  H+u
HCHP0HL$8HIsA  H.u
HFHP0IIM;I  H\$@H He 3Dv_ `  :^ /    [_ `  !^ /  b  H MHe I._ d  ] /  ~  Hd MHe I_ d  ] /  Q  H7 IHUe L^ d  M] /  !  H
 Hh2 H	w H IHe M^ d  LP] /    H MHd `^ f  &] 10    H MHd 6^ f  \ .0    Hl MHd ^ f  \ #0  \  HB MH`d ] f  \  0  2  H MH6d ] f  ~\ 0    H MHd ] e  T\ 0     H MHc d] e  *\ 0     H IHc M7] e  [ /     Hm IHc M
] e  I[ /  ZH@ IH^c L\ c  M[ /  -H H4c \ b  |[ /  MILt$0HtH/u
HGHP0HtH+u
HCHP0H\$8MtI,$uID$IP0HL$HHt
H)uHAP0MtI.u
IFIP0HtH.u
HFHP0E3D\ H
0 Z L  H> H_b [ b  Z /  &H
 H8/ H	 H  IHb M[ b  L`Z /  H E3Ha p[ `  6Z /  H Ha 3DHD$0?[ `  Z /  ]Hx MHa I[ `  MY /  bZ `  Y /  L|$0MIH) HJa M'I.IFIP0H MHa IZ `  MYY |/  H MH` IfZ `  M)Y z/  H
_ HAH9&r u!Hq HtH Hq ^H
c ML5c IMF/ HH=_ HHH
q Hq HtH HtII艎HHu-H
 MH(` MY g  mX <0  HCHH] L   MtA LHu*H MH_ PY g  X >0  H+u
HCHP0H^ II9Fu;I^Ht2IvIHLHH)uHAP0Ll$8HMHĂLl$8II肇HHtH+u
HCHP0IHu*H MH_ X g  aW M0  I.u
IFIP0Im IHuIEP0HLHMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HtH+u
HCHP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$pHt
H)uHAP0HL$PHt
H)uHAP0HD$xHtH(u
HPHR0IH(  H3{	H8  A_A^A]A\_^[]H\$ UVWATAUAVAWHpH H3HD$`H= MH5 HL5 LLzH|$@IHt$HLt$PH|$XM}  Mt@Ht1Ht"HtH  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@I HIMtHtBHtiH      H  HwT ILB HtHHD$@HH  HrU ILB HtHHD$HHHx  HMT ILBx HtLHD$PHHK  HT ILBK HtHHD$XHH  H$ IHD$(LL$@H L|$ qy
&*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
O L|$0IL
O H?L\% HHO HMLIH
 HL$(H
3 HD$ H	 =*  Hy HZ R T   A  H
%% D3&Hj0Lr(Hr HzMHl$ LHI6HL$`H3H$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMHU L   MtA H|$0HHu'H HY @S   R )        * HHuQ )  sHE Hh@ HHuH
A H
bY Q )  QHQ MH yQ )   LHH݃HHuyoQ )  H HY R   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0DFR H
" 	Q  C33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@IN HHHtHt/ZHR  HO ILBV HtHHD$@HH%  HO ILB) HtHHD$HHH   H  IHD$(LL$@H- Hl$ my
)     H|$HH\$@   H   H   H   H
K Hl$0HL
K H?L  HHK HHLIH
 HL$(H
/ HD$ H	 )  Hu HV N P   A  H
1  @3Hz HZLHIBH\$pHl$xH$   HPA_A^_LATAVH   HÝ H3H$   HE3H; LI[ AIkIsAI{AMkEM{ELD$8LHT$ HL$0Ld$(  3 HHu'H HU (O   M >(  }  IN(H;
 u0H
 Hb H	 N   M B(  (  HqN xHHu'H

 H
.U N   vM D(    H@H; tsH; tjHI: HHu'H
 H
T ^N   $M J(    H@H   HL$@Hu'0N   L L(  m  HHMLd$@H/u
HGHP0HD$@Hu>H H9CuL;s  HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0HS IL;tIgexVnHMH9M ~IE HEL,HAHEKIH 70M   K r(  m  M   K p(  T   HtH HH2t6U H+u
HCHP0HD$ HHl$ H(  H@  L   mK h(     H
Q HAH9R^ u!HW HtH H-W dH
U NL5T IMFs HHQ HHH
^ H-W HtHE  HtIÌHLD$ Hu'HH HiR K   J (  @	  HI Du<K   J (  H HR Hm   HEHP0  Hm u
HEHP0Et[    HHu'H HQ KK   J (    HL$ HT$ HH@HH)uHAP0H
PP HAH9d u!H4b HtH H%b ^H
<U MH=3U HLG HHP HHH
Yd Ha HtHj HtIHPHHu'H HP tJ   :I (    HCHHL L   MtAt HHu.J   H (    H+u
HCHP0HGHHR L   MtA HHuH' HHP H (    H/u
HGHP0Hl$0HM(H;
 u0H
 H H	X I   HH (  s  HI rHHuUI   H (  F  HM(H;
G u4H
 H H	 Hg HO G (  5  HP 5rLHuG (    H MALd$(H9Cu0LsLt$(Mt"HCHIHH H)uHAP0   HCH;    HD$ HT$PHD$PDEHHH+Lt$HH|$XL|$`rzHHuH HN G (  a  MtI.u
IFIP0H/Ld$(u
HGHP0I/u
IGIP0Lt$ H+u
HCHP0IHl$ LH)uHAP0H
L HAH9S   H?W Hv  H H,W   H;    HSJ=   uzHD$ LT$pHD$pDEHL+Lt$hH|$xIL$   LZ uHCIHtE3AAHHHX HyM E (  )M HHuDE (  H
# H
DM F   H  H/  HGHP0  Mt	LpLd$(Lt$ E3HHILtEH|EL|MwHHuTF   E (  E  H.IHFHP0:H
yP MH=pP HLG3 HHAK HHH
R HU HtH HtIHzHHu*H IH,L E    tD )    HCHHI L   MtA HHu8D )  MV  H+u
HCHP0HFHHG L   MtA_ HHu'Hh HK E    C 	)  4  H.u
HFHP0H IAH9Cu+HsHt"HCHHHH H)uHAP0   HCH;    HD$0H$   H$   DGHD$8HH$   HH+H$   H$   rvHHuC )  M2  H  H.  HFH  H;    HKQ=   u{HD$0L$   H$   DGHD$8H$   HL+H$   H$   HAI uHKItE3HHUWB #)  MxO} LHu7B ))  [HtHpIHL$0E3HT$8HILGHE HIlGHITILtHH   A 7)   C    HE HfI HtH+u
HCHP0MtI/u
IGIP0HL$(Ht
H)uHAP0HtH.u
HFHP0DB H
: XA o3Lt$ #I/u
IGIP0H+u
HCHP0LL$   H$   H$   H$   H$(  MtIm u
IEIP0L$   MtI.u
IVIR0IH$   H3H   A^A\H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@IN HHHtHt/ZHR  H? ILBV HtHHD$@HH%  H? ILB) HtHHD$HHH   H IHD$(LL$@H Hl$ ]y
'     H|$HH\$@   H   H   H   H
; Hl$0HL
; H?L\ HH; HHLIH
 HL$(H
/ HD$ H	 
(  Hu HF > @   A  H
! 03Hz HZLHI"H\$pHl$xH$   HPA_A^_AVAWH(HH E3H\$@H|$XLl$ LH H
D L=G HAH9V u!HS HtH HS ^H
C MH=~C HLGq HHD HHH
V H]S HtH HtIHsHHl$HHt$PHu'HB HcE >   = i'    HCHHdI L   MtA HHu'H HE >   W= k'  &  H+u
HCHP0H IH9Gu6H_Ht-HwHHHHH)uHAP0MHH
hIHlHHtH+u
HCHP0Hu'HI HjD =   < z'    H/u
HGHP0H.Iu
HFHP0    HHu'H H
D =   U< '  N  IEIH IEHEIE H IE HE IEH@ L   MtAq HHu; '     HS IH9Cu3HsHt*H{HHHHH)uHAP0HHkHlHHtH.u
HFHP0Hu; '  -H+u
HCHP0    HHuxU; '  H HB m<   Hm u
HEHP0HtH+u
HCHP0HtH/u
HGHP0D+< H
 : -CH; LH HCHk H{(H H H HC0H H H HC8Ll$ H|$XHt$PHl$HH\$@MtI/u
IWIR0IH(A_A^@UAWH8HBE3H;r AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH; t[HH HHu'Hi HA ;   9 &    H@L   Mu^9 &    HIIMMu>H H9GuH;w  HGHHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHIFfHHtFLHI tH+BHCHP039   8 '     9   8 '      LH   H
 LI;   HHD9   }F      @t:I@   yA      @t3I s
IIII ug8 '  79   H| H? HtH/u
HGHP0HtH+u
HCHP0D8 H
 7 ) R H/u
HGHP0L= ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Ht$ AVH H; E3H\$0E3HHl$8H
8 H|$@:HHu1H5+ Hd H> 8   H6 e&    HXHH
@ H4< HAL   MtA HHu'H H#> 7   k6 t&     H IH9Cu4H{Ht+HkHHHHE H)uHAP0HH fH6gHHtH/u
HGHP0Hu-Hr H= 7   5 &  H   zH+u
HCHP0HHn  HHu$H! HB= 6   5 &  BHLHHuMH H= 6   V5 &  H+u
HCHP0Do6 H
 25 I'&H+u
HCHP0HLH/u
HWHR0H.H|$@Hl$8H\$0u
HVHR0IHt$HH A^@SVWAUAVH Lq333L9Yxt3H A^A]_^[Hl$PLd$XL|$`Mu*H E3H< 5   _4 &     LHu'H H; d5   *4 &    IFHHHu-H
= L> H. H	 3 &  &  HAH; tWH;c tNH HHuH
8 H
Y; 3 
&    H@L   Mu]3 &    H3E3HMu>H H9FuH;nQ  H^HHH)H;n7  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA) HHtNH+u
HSHR0IVLI3 uH/HGHP0t2 7&     e2 4&     H
 L HG- H	 82 1&  o$ HtH` HHUtD H.u
HFHP0IAExK	Ld$XIL|$`Hl$PH A^A]_^[1 '&  3H: H[9 2   I/u
IGIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D2 H
 G1 ^#>H\$Hl$Ht$H|$ AVH H5 HH
1 E3-HHuH. %  H   H
0 HxHH5D< L5M: H-n9 x HHt~HH_HG3HG| GxHGHHGPHG HG(HG0HG8HG@MtILw`HtHE HoXHtHHHwhHGpO H+u
HCHP0HG%  H H7 0 C1   A  H
R "H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtHysH  HH [H [@SH HYHtH9sH  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@MG  LbIMt4HtH2  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@Id HIMtHt*LHb. ILBu HD$@HH   HHJ. ILBM HD$HHHtNHH  H IHD$(LL$@H1 Ld$ Ky
>%     H\$HH|$@   H
 H HD$0   L
) HD$(L  H) HD$    H	 :%  OHzt}HFL
) H
W L HD$0H) H HD$(H	HD$     K%  Hz H4 .   , A  H
 :HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HD$xHE3L|$0L|$8$HD$0L|$ L|$($HD$ EEL$   AL$   EHCHu'He H3 -   + 8$  Y  Hn  LkL$   Lc Ld$PIE I$Ll$XLd$`IH
1 HAH98 u&H@ HtH H@ lH
6 Ia[H56 LFH HH1 HHH
68 H_@ HtHI! HtIIH`IHHu*Hm H2 ,   * c$  M^  HCL   H. HMtA
 HHu'H H72 +   * e$    H+u
HCHP0HFL   H4 HMtA HHu'H H1 U+   * h$  l  H.u
HFHP0IH` H9Cu6HsHt-H{HHHHH)uHAP0MHHTIHYHHtH.u
HFHP0IHu'H
 H+1 *   s) w$    H+u
HCHP0HGH߿ H;>  H;w 1  H  LHu'H H0 D*   
) $  F  H/u
HGHP0IIFL   MIAHHtrA   IAHHt^IAH@Ly4H% HF0 )   ( $  L$   Ld$P  M).   IFIP0   I.u
IFIP0M(LuI<MH H/ X)   ( $  L$   Ld$P8  HOHtR~A   H'$ H
 H	 
HxLHL Hm/ (   ' $    H;u
Hw H_H_HsHHHH/uHGHP0
Ld$PL$   LH$   L|$PH$   HHL$@&  HHD$0H;tTHT$0HRHL$0HD$0H@HD$0H HD$0H@L|$8HL$0HHD$0HHL$8HCHD$8HKH|$@HWHL$@THD$@H@HD$@H HD$@H@L|$HH|$@HHHL$@[  HHD$ H;tTHT$ HRHL$ HD$ H@HD$ H HD$ H@L|$(HL$ HHD$ HHL$(HCHD$(HKLD$@MM H$   HL$@   DBoHL$@Iu2 Ht'Hk H- '   % $  _  H  	H$   LD$ HT$0HGuH$   HAHG  E3H_0 H
) WHHu'H H
- &   U% $     E33HAH+u
HCHP0H H, K&   % $     Ll$XLd$`H$   H$   H$   H$   H\$PHHLHtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0MtI.u
IFIP0L$   H$   D% c$ H
 sAMMtIm u
IEIP0MtI,$uID$IP0MtI.u
IFIP0HtH.uHFHP0LD$ MM H$   HL$    DBoHL$ bLD$0MM H$   HL$0   DBoHL$01AHĀ   A_A^A]A\_^[H\$Ht$WH IHHMt-Ij H~HM>uH\$0Ht$8H _HHHH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH   H@LE3L|$pL|$xL$   L$   L|$PL|$X8HD$PL|$@L|$H$HD$@L$   L|$hL$   AW$   L$   H
( HAH9. u!H2 HtH H52 ^H
- MH- LCHR HH`( HHH
. H52 HtHƹ HtIHWHHu*H- HN) " x  ! !  M8  HFL   HH% HMtA͸ HHu'Hֿ H( y" x  ?! !    H.u
HFHP0HCL   H+ HMtAi HHu'Hr H( " x    !  Q  H+u
HCHP0IH  H9Fu6H^Ht-LvHIHIH)uHAP0MHIKIHQPLHtH+u
HCHP0IMu'Hʾ H' m! x  3  !    H.u
HFHP0IIFH H;  H;4   Iݶ HHu'H
^ H
' ! x   !    I.u
IFIP0HGL   MHAHHtbA   HAHHtNHAH Cy'H H'   x  N !    L)'   HGH   H/u
HGHP0IBuIDH H& (  x   !  O  INHtR~A   H H
 H	l 
HxCH) HJ&  x   !    H;u
I^ IvIvH^H6HHI.u
IFIP0Ht$pH$   IH\$xH$     zHH$   3A  HH/`HH$   (  BHHD$03A(  HH`H$   H   E3H& H
" PHHu*H$ HE%  |   6"  M/  E33HT9H+u
HCHP0Hݻ H$  |  F :"  M
  H   E3H& H
p! {OHHu*H H$ / ~   V"  M
  E33H8H+u
HCHP0HE Hf$  ~   Z"  MP
  HC H$P  H& HH9GuF Hu*H H$    S l"  M  H$   H
" HAH97 u!HD2 HtH L552 ^H
D$ MH;$ LCHN LH\" HHH
6 L51 MtI³ HtMHQLMu*H) HJ#     x"  M4  IFL   H# IMtAɲ HHu'Hҹ H" u   ; z"    I.u
IFIP0HCH;O    H; t~HHD$ LH LHu*Hd H"     "  I@  H@L   Mu<H* HK"     "  
  LHMMHD$ H+uHCHP0D  Mu<H L|$(I9FuM;f   IFJM;f}wK\HI	  IAHHD$(H   HtEH6 HH+t 'HX Hy!     "  
  I.u
IFIP0LOL;
E tUH;=԰ tLMIL H( H
 H	  H H
!    R "  M	  HL$   I!  HT$pHL$0  HHD$PH;tTHT$PHRHL$PHL$PHIHL$PH	HD$PH@L|$XHL$PHHD$PHHL$XHCHD$XHKH|$0HWHL$00HD$0H@HD$0H HD$0H@L|$8H|$0HHT$xHL$05  HHD$@H;tTHT$@HRHL$@HL$@HIHL$@H	HD$@H@L|$HHL$@HHD$@HHL$HHCHD$HHKLD$0MM H$@  HL$0   DBoHL$0H  !H$@  LD$@HT$PH_gLHD$0H   E3H|" H
 IHHu*H	 H*    r #  M  E33H93H+u
HCHP0Hµ H e   + #  M  IL$@  H$X  H;=E 4  3Ϭ LHu*Hh H     )#  Ms  HGH; txH;A toH HHu'H H8     /#    H@L   Mu:H H    I 1#    HHIHL$ MHMu=HU H9CuH;KV  HCH4H;KB  HtHHHL$ HAHH$@  H  H$   LH$   Ht
H)uHAP0IIEL   H IMtA HH  MHҫ H9Gu;LoMt2HwIE HHHH)uHAP0L^ IH;@HJ HDHMtIm u
IEIP0Ht|H/u
HGHP0IHI>  u3H.HL$ HFHP0HL$ IL$@     H  HA     e#    H H    b b#    HҲ H u   ; T#    $ HtEH` HHUt 'H H %    L#  4  H+u
HCHP0L|$(ML$   MvIu*H1 HR     s#  M<  H$   Ll$0I9ZHxHH$   赋H+HL;   IH$   uHH$   UH$   x Ht*H H 9    ~#  M  H$   H$   ~HIeL$   H$   LIIYH  Hu*H H@     #  M*  LHD$hI}  HHu'Hݰ H    F #    IL$8H)uHAP0I\$8MtIS(  ItMtIU$@   LHu'Ha H     #  o      HHu'H' HH     #    LpI$L` @  E3H$   HL$pL$   Ll$xL|$hEH$@  H\$(  E3H$   HL$pL$   Ll$xH\$(_  H$   LH$   HtH)u
HAP0LIIAL   H IMtA0 HIHu'H6 HW     "     H H9Fu3H~Ht*H^HHHHH)uHAP0HH8@HnAHHtH/u
HGHP0IHu$H H J    "  _H.u
HFHP0H+H$P  HCHP0yH$   HT$pE3H$   AHT$xL|$hMIIMtI.u
IFIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Ld$hD I H
 YIHL$pHt
H)uHAP0HL$xHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0MtI,$uID$IP0H$   HtH)uHAP0H$   Ht(H$   H{XL$   L+IHLD$@MM H$@  HL$@6   DBoHL$@LD$PMM H$@  HL$P   DBoHL$PHH   A_A^A]A\_^[H\$UVWAVAWH`H] H3HD$XH5 WHt$PMHD$@Mq  LzIMt3Ht"HtHg  Hr(Ht$PHB HD$HHjHl$@Hl$@I` HIMtHt0HtKvHX
 ILBk HD$@HH   HHP
 ILBC HD$HHt{HHv  H
 ILB HtHHD$PHHI  H IHD$(LL$@H L|$ s*y
v!     Ht$PHl$@  H
 Hܰ HD$0   L
 HD$(L\ H HD$    H	Ӣ l!  xHBH   H   HCHq 3HD$0HL
O L  HHHR HD$(HL$ LMH
٣ H: H	Y !  H H>  r   Ar  H
 3!Hr(HB HjHD$HLD$HLHoHL$XH32H$   H`A_A^_^]H\$Ht$WH H
z HHAH9 u!HS# HtH H=D# ]H
 LH5 HLF HH+ HHH
h H=	# HtH Ht3Hx@HHu'H H  p  b
 !     H H9CuHHf HHuH
 H
 "
  !  .E3HHn<HHurH H 	 "!   p  H/u
HGHP0HtH+u
HSHR0D
 H
a 	 3H\$0Ht$8H _H/u
HWHR0H+u
HSHR0HH\$0Ht$8H _+@UVWATAUAVAWHl$H0  HEH$  HYX H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@HD$8ELd$HL#LcwHD$P   AAAWEWMEHE   LeDeIEH; tsH;
 tjILd$XIV LHD$`Hu'HҦ H u	 i  ; l     H@H   HD$hHuo n     MLl$`IE Ld$X3HD$hfD  Hu=H I9FuM;f  IFJ<M;f  K|HILd$XIHHz  ILH}Ht
H)uHAP03Hȟ 98uIG      7  IEHHpHtHAHt
IIIIu4HH  H@L   H HMtAl HH  H/u
HGHP0HCL   H> HMtA+ HHA  H+u
HCHP0IEHHpHtHAHt
IIII3HH  H@L   H HMtA HH  H+u
HCHP0   \ HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHMHHMwHUHtLE L+I蚹WEH] HUHtLEL+IŨ H  IHMڬHHMNHM赈W Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8MLH HD$ LHUHL$8sH]HUHK@hHKXHUeLt$`L}Ld$XLmHD$h9H
 H
˜ H	 < j      33v   l      ]   l      D   k      +   k         k      3    k  f    3    k  K    3   j k  0    33    LH
  H
J LI;   HH    }F      @t:I@   yA      @t3Ips
II]II'        33 i  H H
 MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
f #H\$pc I.u
IFIP0HD$8H\$pH;t>HHRH&HH@HH HH@HC    DD$0HT$8HqMtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r~ H+Hsn H'va H耼HE   HE    E HUHtLEL+IӴHUHtLEL+I
LD$8MM HUHL$8   DBoHL$8MHHM(H3莴H$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  HO H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@HD$8ELd$HL#LcHD$P   AAAWEWMEHE   LeDeIEH; tsH;: tjILd$XI LHD$`Hu'H H#   W  k     H@H   HD$hHuoG     MLl$`IE Ld$X3HD$hfD  Hu=HL I9FuM;f  IFJ<M;f  K|HILd$XIHHz  ILH}Ht
H)uHAP03H 98uIG      7  IEHHpHtHAHt
IIII+HH  H@L   H HMtA HH  H/u
HGHP0HCL   Hn HMtA[ HHA  H+u
HCHP0IEHHpHtHAHt
IIII*HH  H@L   H& HMtA HH  H+u
HCHP0    HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHMϕHHMSqHUHtLE L+IʰWEH] HUHtLEL+I襰 H  IHM
HHM~HM Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
!  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8}LH HD$ LHUHL$8H]HUHK@wHKXHUwLt$`L}Ld$XLmHD$h9H: H
 H	Ҕ l X  2   33v  O Z      ]  6 Z      D   Y      +   Y         Y      3    Y     3    Y  {   3    Y  `   33   E LH
  H
z LI;   HH    }F      @t:I@   yA      @t3Is
IIIIW       33 W  H( HI MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
6 H\$pc܎ I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8HiMtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+Hs H'v H谳HE   HE    E HUHtLEL+IHUHtLEL+ILD$8MM HUHL$8   DBoHL$8}HHM(H3辫H$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH   HEHX)p)xHF H3HELL3H}H} HEH}H}HEH}DH|$0HE   H}Dm׋ߋDL;=Q uELT H H
 H	 Hj H 
 	   j  ma  L-S H I3 HHu: HuI*H H5  	  } l  La  HHDu$P Ht} 	  C n  O  H/u
HGHP0E,$L;=_ uAH H
/ H	 H H " 
   {  L`  He I= HHu*H> H_  
   }  L>`  HDu$} Ht 
  p   O  H/u
HGHP0El$L;= uAHz H
[ H	2 H H N      L_  Hy IiHHu*Hj H 
      Lj_  HHMHHMxHMw Ht      7N  H/u
HGHP0IL$HEH;tIE3HUL;= uAH H
] H	4 H H P      L^  H{ IkHHu*Hl H       Ll^  HZ H;uA   (HDy      BM  H/u
HGHP0E  H HHH9
" u&H HtH H +H
 ,)Lk H H
 PHHu*H H 4 
     L]  HCL   H HMtA1 HHu 
     \  H+u
HCHP0HFL   H HMtAۉ HHu'H H  
  M   \  H.u
HFHP03L;=k u0Hz H
; H	 < 
     J\  H IZHHu 
     \  H* H9Cu6LsMt-H{IHHHH)uHAP0LIHHH[!HMtI.u
IFIP0E3H.u
HFHP03Hus 
  9   [  H+u
HCHP03HGH H;   H;;    H LHu'H
e H
  
     J  H/u
HGHP0IFH   E3IHHtRA   IHHt?IH
y 
  f   Z  M).   IFI   I.u
IFIP0E3uI$N 
     \Z  HOHtD~A   H* H
 H	 
Hx  
     rI  H;u
Hw H_H_HsHHHH/u
HGHP0H]LHt$0HHMHHMbLEMM HT$8HMA   DBoHMߵHHMHHM7`LEMM HT$8HM   DBoHM蝵IL$(HUbIL$8HUq`LL;= u>Hԭ H
 H	 H5 HV     3  8Y  HN IHHu'H H    ` 5  X  HȄ H9GuwH (=G) f.z-u+ Ht F    7  3E33G  H/u
HGHP0At$HL;= u>Hm H
 H	ń H> H_     D  AX  H IHHu'H  H!    i F  X  HHM贔HHM(qHMp1 Ht ^   $ H  3E33F  H/u
HGHP0IL$XHEH;tIE3HUvL;= u>H H
 H	ƃ H? H`     U  BW  H I HHu'H H"    j W  W  H)Àu+A Ht n   4 Y  3E33E  H/u
HGHP0A\$xL;=H u>Hw H
 H	 Hh H     f  kV  Hq I)HHu'H* HK     h  -V  HRÀu+j Ht    ] j  3E33E  H/u
HGHP0A\$yL;=q u>HX H
A H	 H H 4    w  U  HZ IRHHu'HS Ht     y  VU  H@L   H HMtA HHu   v {  3D  H/u
HGHP0HC Ht*H H b   ( ~  E3T  H.u
HFHP0A\$|L;=@ u>HO H
 H	 H` H       cT  H I!HHu'H" HC       %T  HHM֐HHMJmHMlS Ht*Hχ H r   8   E3S  H.u
HFHP0I$   HEH;tIE3HU苩L;=4 u>Hk H
 H	 HT Hu       WS  H IHHu'H H7       S  H>Àu5V Ht*H҆ H u   ;   E3R  H.u
HFHP0A$   L;=P u>H H
  H	~ Hp H       sR  H9 I1HHu'H2 HS       5R  H HHH9
` u&H HtH H= +H
' JL H* H
 nHHu*H H R      E3Q  HGL   H" HMtAO~ HHu	      x@  H/u
HGHP0A   HH<} HHu      P  H.u
HFHP03H+u
HCHP03H'Dyz   @   ?  H/u
HGHP0E%  L;=W} u>Hި H
'~ H	| Hw H       zP  H I8HHu'H9 HZ       <P  H:| H HH9Guz HHu   ]   ?  H/u
HGHP0H{ H HH9CuHz HHuB      MO  H+u
HCHP03H%Du$| Ht      k>  H/u
HGHP0E$   L;={ u>H H
| H	{ H H    c   N  H IHHu'H H _   %   N  Hz H6 HH9Gup y HHu      =  H/u
HGHP0Hhz H HH9Cux HHu      M  H+u
HCHP03HDu$R{ Ht   E   <  H/u
HGHP0E$   L;=]z u>H4 H
-{ H	z H} H        M  H I>
HHu'H? H`       BM  H@y H HH9Guw HHu   c   <  H/u
HGHP0Hx HD HH9CuNw HHuH      SL  H+u
HCHP0HGL   H HMtA8y HHu      a;  H/u
HGHP0HWy Ht   z   K  H+u
HCHP0A$   L;=x u>H H
by H	9x H H U      K  H IsHHu'Ht H       wK  Huw H HH9Cu(u HHu      J  H+u
HCHP0H w H HH9Gu
u HHu}   C   9  H/u
HGHP0Hbu$
x Ht:       EJ  H+u
HCHP0A$   L;=w u>H? H
w H	v H8~ HY     %  ;J  HQ I	HHu'H} H    c '  I  Hu Ht HH9Cu	^t HHuX    )  cI  H+u
HCHP0Hu Hw HH9GuY		t HHu    ,  r8  H/u
HGHP0Hu$v Ht    /  H  H+u
HCHP0A$   L;=u u>H H
nv H	Eu H| H a   ' <  H  H IHHu'H| H #    >  H  Ht H HH9Cu4r HHu    @  G  H+u
HCHP0H,t HU HH9Gur HHu   O C  6  H/u
HGHP0H@@u$u HtA    F  LG  H+u
HCHP0A$   L;=t u>H H
t H	s H?{ H`      S  BG  HX I HHu'H{ H"     j U  G  Hs H{ HH9Cueq HHu_    % W  jF  H+u
HCHP0Hr H& HH9Gu`q HHu
     Z  y5  H/u
HGHP0Hu$s Ht     ]  E  H+u
HCHP0A$   L;=r u>HD H
us H	Lr Hy H h !  . j  E  H IHHu'Hy H * !   l  E  Hq H HH9Cu;o HHu !   n  D  H+u
HCHP0H3q Hl HH9Guo HHu !  V q  3  H/u
HGHP0Huu$ r HtM !   t  XD  H+u
HCHP0A$   L;=+q u>H H
q H	p HKx Hl  "     ND  Hd IHHu'H
x H.  "  v   D  Hp H HH9Cuqn HHuk "  1   vC  H+u
HCHP0Ho H HH9Guln HHu "     2  H/u
HGHP0H苧@@u$p Ht "     B  H+u
HCHP0A$   L;=o u>H H
|p H	So Hv H o #  5   B  H IHHu'Hv H 1 #     B  Hn H HH9CuBl HHu #     A  H+u
HCHP0H:n H HH9Gul HHu #  ]   1  H/u
HGHP0Hm H9CusHn (f.z&u$o Ht; #     FA  H+u
HCHP0A$   L;=n u>H. H
n H	m H7u HX  $     :A  HP I HHu'Ht H  $  b   @  Hl Hs HH9Cu ]k HHuW $     b@  H+u
HCHP0Hl H HH9GuX k HHu $     q/  H/u
HGHP0H l H9CusHl (f.z&u$ym Ht $  l   ?  H+u
HCHP0A$   L;=l u>H H
Rm H	)l Hs H E %     ?  H IcHHu'Hds H  %     g?  Hek H HH9Cui HHu %     >  H+u
HCHP0Hk H9 HH9Gusi HHum %  3   -  H/u
HGHP0Hj H9CusH]k (f.z&u$k Ht %     >  H+u
HCHP0A$   L;=j u>HT H
k H	j H
r H.  &  v   >  H& IHHu'Hq H r &  8   =  Hi HI HH9Cu3h HHu- &     8=  H+u
HCHP0H{i H HH9Gu.g HHu &     G,  H/u
HGHP0Hu$hj Ht &  [   <  H+u
HCHP0A$   L;=si u>H H
Cj H	i Hp H 6 '     <  H ITHHu'HUp Hv  '     X<  HVh H HH9Cu	f HHu '  y   ;  H+u
HCHP0Hh H HH9Gudf HHu^ '  $   *  H/u
HGHP0Hu$h Ht '     &;  H+u
HCHP0A$   L;=g u>H H
h H	g Ho H:  (     ;  H2 IHHu'Hn H ~ (  D 
  :  Hf HU HH9Cu?e HHu9 (     D:  H+u
HCHP0Hf H HH9Gu:d HHu (     S)  H/u
HGHP0H	u$tg Ht (  g   9  H+u
HCHP0A$   L;=f u>H^ H
Og H	&f Hm H B )   "  9  H I`HHu'Ham H  )   $  d9  Hbe H HH9Cuc HHu )   &  8  H+u
HCHP0H
e H HH9Gupc HHuj )  0 )  '  H/u
HGHP0Hd H9CusHZe (f.z&u$e Ht )   ,  8  H+u
HCHP0A$   L;=d u>H H
e H	d H
l H+  *  s 9  
8  H# IHHu'Hk H o *  5 ;  7  Hc HF HH9Cu0b HHu* *   =  57  H+u
HCHP0Hxc H! HH9Gu+a HHu *   @  D&  H/u
HGHP0HCL   HP HMtAc HHu *  E C  6  H+u
HCHP03HDd Ht> *   F  %  H/u
HGHP0E$   L;=c u>HK H
c H	b H<j H]  +   S  ?6  HU IHHu'Hi H  +  g U  6  Ha Hx HH9Gub` HHu\ +  " W  $  H/u
HGHP0Ha H[ HH9Cu]
` HHu +   Z  5  H+u
HCHP03H#a H9GuwHa (f.z&u$|b Ht +  o ]  $  H/u
HGHP0A$  L;=a u>H܏ H
Ub H	,a Hh H H ,   j  4  H IfHHu'Hgh H 
 ,   l  j4  Hh` H HH9Gu^ HHu ,   n  4#  H/u
HGHP0H` H HH9Cuv^ HHup ,  6 q  {3  H+u
HCHP03H_ H9GuwH^` (f.z&u$` Ht ,   t  "  H/u
HGHP0A$  L;=_ u>Hm H
` H	_ Hg H/  -  w   3  H' IHHu'Hf H s -  9   2  H^ HJ HH9Gu4] HHu. -     !  H/u
HGHP0H|^ H HH9Cu/\ HHu -     1  H+u
HCHP0H HHH9
 u&H HtH H +H
 >Lu Hn H
 bHHuT -        HCL   H' HMtAT^ HHu -     }   H+u
HCHP0A   HHA] HHu -     :   H/u
HGHP0H.u
HFHP03H.y -  H   0  H+u
HCHP0  L;=`] u>H H
0^ H	] Hd H # .     0  H IAHHu'HBd Hc  .     E0  HC\ H HH9CuZ HHu .  f   /  H+u
HCHP0H[ H HH9FuQZ HHu*Hc H = .     E3k/  H.u
HFHP03Hu$\ Ht .      /  H+u
HCHP0A$  ^/  L;=[ u>H H
\ H	u[ Hb H  /  W   .  H IHHu'Hb H S /     .  HZ H* HH9CudY HHu /     .  H+u
HCHP0H\Z H HH9FuX HHu*Hb H)  /  q   E3-  H.u
HFHP0H HHH9
+ u&H HtH H5{ +H
 
Ld H H
 1HHu# /     .-  HFL   H HMtA#Z HHu /     ,  H.u
HFHP0A   HHY HHu /  `   	  H+u
HCHP03H/u
HGHP0Hy*H` H C /  	   E3q,  H.u
HFHP0,  L;=Y u>H H
Y H	X H>` H_  0     A,  HW IHHu'H ` H!  0  i   ,  HX Hz HH9FudV HHu*H_ H P 0     E3~+  H.u
HFHP0HW H HH9GuNU HHu 0     g  H/u
HGHP0HW H9FuvHW (f.z7u5oX Ht*H^ H  0  T   E3*  H.u
HFHP0A$   *  L;=bW u>H H
2X H		W H^ H % 1     *  HK ICHHu'HD^ He  1   
  G*  H
 HHH9
 u&HA HtH H=2 +H
9 \L H H
 HHu*H] H d 1  *   E3)  HGL   H\ HMtAaV HHu 1       H/u
HGHP0A   HHNU HHuؿ 1     (  H.u
HFHP03H+u
HCHP03H9Dy 1  R     H/u
HGHP0EA  L;=iU u>H H
9V H	U H\ H , 2   $  (  H IJHHu'HK\ Hl  2   &  N(  HLT H HH9GuR HHu 2  o (    H/u
HGHP0HS H HH9CuZR HHuT 2   +  _'  H+u
HCHP03H7Du$T Ht 2  Լ .  }  H/u
HGHP0E$   L;=S u>H[ H
T H	S H[ H-  3  u ;  '  H% IHHu'HZ H q 3  7 =  &  HR Hp HH9Gu2Q HHu, 3   ?    H/u
HGHP0HzR H HH9Cu-P HHu׼ 3   B  %  H+u
HCHP03H身Du$dS Ht 3  W E     H/u
HGHP0E$   L;=oR u>H H
?S H	R HY H 2 4   R  %  H IPHHu'HQY Hr  4   T  T%  HRQ H HH9GuO HHu 4  u V    H/u
HGHP0HP HV HH9Cu`O HHuZ 4    Y  e$  H+u
HCHP0HGL   H HMtAJQ HHu 4  ʹ \  s  H/u
HGHP0H詥Q Htƺ 4   _  #  H+u
HCHP0A$   L;=P u>Hc H
tQ H	KP HW H g 5  - l  #  H IHHu'HW H ) 5   n  #  HO H( HH9Cu:M HHu 5   p  "  H+u
HCHP0H2O H HH9GuM HHu 5  U s    H/u
HGHP0H@@u$P HtG 5  
 v  R"  H+u
HCHP0A$   L;=%O u>H H
O H	N HEV Hf  6     H"  H^ IHHu'HV H(  6  p   
"  HN H HH9CukL HHue 6  +   p!  H+u
HCHP0HM H< HH9GufL HHu 6  ֶ     H/u
HGHP0H.M H9CusH N (f.z&u$N Ht 6  z      H+u
HCHP0A$   L;=M u>H} H
`N H	7M HT Hѽ S 7        Hɿ IqHHu'HrT H  7  ۵   u   HsL H HH9Cu&J HHuж 7       H+u
HCHP0HL H' HH9GuJ HHu{ 7  A     H/u
HGHP0HK H9CusHkL (f.z&u$L Ht 7     *  H+u
HCHP0A$   L;=K u>H2| H
L H	K HS H<  8       H4 IHHu'HR H  8  F     HJ H HH9CuAI HHu; 8     F  H+u
HCHP0HJ H" HH9Gu<H HHu 8     U
  H/u
HGHP0HJ H9CusHJ (f.z&u$]K Ht 8  P     H+u
HCHP0A$   L;=fJ u>Hz H
6K H	
J HQ H ) 9       H IGHHu'HHQ Hi  9     K  HII H HH9CuG HHu 9  l     H+u
HCHP0HH H
 HH9GuWG HHuQ 9       H/u
HGHP0HoH H9CusHAI (f.z&u$I Ht 9        H+u
HCHP0A$   L;=H u>HXy H
I H	xH HO H  :  Z     H
 IHHu'HO HԸ V :       HG HU HH9CugF HHu :  װ     H+u
HCHP0H_G H HH9GuE HHu :     +
  H/u
HGHP0HF H9CusHG (f.z&u$3H Ht` :  &   k  H+u
HCHP0A$   L;=<G u>Hw H
H H	F H\N H}  ;  ů   _  Hu IHHu'HN H?  ;     !  HF H HH9CuD HHu| ;  B     H+u
HCHP0HE H HH9Gu}-D HHu' ;       H/u
HGHP0HEE H9CusHF (f.z&u$F Ht˯ ;        H+u
HCHP0A$   L;=E u>H~v H
wF H	NE HL H j <  0 
    H IHHu'HL H , <       HD H+ HH9Cu=B HHu <       H+u
HCHP0H5D H^ HH9GuB HHu <  X     H/u
HGHP0Hwu$"E HtO <     Z  H+u
HCHP0A$     L;=(D u>H'u H
D H	C HHK Hi  =   .  K  H I	HHu'H
K H+  =  s 0  
  HӲ HHH9
H u&H HtH H= +H
 "L H H
 FHHu8 =   2  C  HGL   Hc HMtA8C HHu =   4  a  H/u
HGHP0A   HH%B HHu =  u 7    H+u
HCHP03H.u
HFHP03HzDyc =  ) :    H/u
HGHP0EU  L;=@B u>Hgs H
C H	A H`I H  >  ɪ G  c  Hy I!HHu'H"I HC ū >   I  %  H#A HT HH9Gu? HHu >  F K    H/u
HGHP0H@ H HH9Fu1? HHu*HzH H  >   N  E3K  H.u
HFHP03H6@ H9GuwHA (f.z&u$A Ht >   Q  +  H/u
HGHP0A$   L;=@ u>Hq H
hA H	?@ HG Hٰ [ ?  ! ^    HѲ IyHHu'HzG H  ?   `  }  H{? H HH9Gu.= HHuة ?   b  G  H/u
HGHP0H&? H_ HH9Fu= HHu*HF H u ?  ; e  E3  H.u
HFHP03H> H9GuwH`? (f.z&u$? Ht ?  ڧ h    H/u
HGHP0A$   {  L;=> u>Hbp H
? H	> HF H,  @  t     HԮ IHHu'HE H p @  6     H HHH9
{ u&H2 HtH H5# +H
¬ L HE H
 	HHu˦   mHFL   H HMtA> HHu   4H.u
HFHP0A   HH= HHuG\    @  E3HD H H  H/  HGHP0z  H/u
HGHP0H+u
HCHP0Ht؅y*HfD H 	 @  ϥ   E37  H.u
HFHP0t  L;=< u>Hn H
= H	< HD H%  A  m     H IHHu'HC H i A  /     H; Hx HH9Fuz*: HHu*HsC H  A  ܤ   E3D  H.u
HFHP0Ha; H HH9Cu9 HHu A       H+u
HCHP0HFL   H9 HMtA; HHu*HB Hث Z A      E3  H.u
HFHP03H; Ht A  ݣ   "  H+u
HCHP0A$   L;=: u>Hl H
; H	: HB H6  B  ~     H. IHHu'HA H z B  @   
  H9 H HH9Cu;8 HHu5 B     @
  H+u
HCHP0H9 H4 HH9Fu67 HHu*H/A HP ң B     E3 
  H.u
HFHP03H貒u$]: Ht B  P     H+u
HCHP0A$   L;=h9 u>HWk H
8: H	9 H@ H + C       H IIHHu'HJ@ Hk  C     M  HK8 H HH9Cu6 HHu C  n     H+u
HCHP0H7 H HH9FuY6 HHu*H? Hè E C     E3s  H.u
HFHP03H%u$8 Ht C  à     H+u
HCHP0A$   L;=7 u>Hi H
8 H	7 H> H  D  d   
  H IHHu'H> Hާ ` D  &   
  H6 Ho HH9Cuq!5 HHu D     &
  H+u
HCHP0Hi6 H" HH9Fu4 HHu*H> H6  D  ~   E3	  H.u
HFHP03H蘏u$C7 Htp D  6   {	  H+u
HCHP0A$   L;=N6 u>Hh H
7 H	5 Hn= H  E  מ   q	  H I/HHu'H0= HQ ӟ E     3	  H15 H HH9Cu3 HHu E  T     H+u
HCHP0H4 HŢ HH9Fu?3 HHu*H< H + E     E3Y  H.u
HFHP03Hu$5 Ht E       H+u
HCHP0A$   L;=4 u>H(g H
5 H	h4 H; H  F  J     H IHHu'H; HĤ F F       H3 HU HH9CuW2 HHu F  ǜ     H+u
HCHP0HO3 H HH9Fu1 HHu*H: H  F  d   E3  H.u
HFHP03H~u$)4 HtV F     a  H+u
HCHP0A$   L;=43 u>He H
4 H	2 HT: Hu  G   %  W  Hm IHHu'H: H7  G   '    H2 Hȟ HH9Cuz0 HHut G  : )    H+u
HCHP0H1 H HH9Fuu%0 HHu*Hn9 H  G  ך ,  E3?  H.u
HFHP03H*1 H9CusH1 (f.z&u$2 Ht G  v /    H+u
HCHP0A$   L;=1 u>HCd H
\2 H	31 H8 H͡ O H   <    Hţ ImHHu'Hn8 H  H  י >  q  Ho0 H  HH9Cu". HHu̚ H   @    H+u
HCHP0H0 H HH9Fu}. HHu*H7 H i H  / C  E3  H.u
HFHP03Hg@@u$0 Ht H   F  '  H+u
HCHP0A$   L;=/ u>Hb H
0 H	/ H7 H;  I   S    H3 IHHu'H6 H  I  E U    H. H HH9Cu@- HHu: I    W  E  H+u
HCHP0H. H HH9Fu;, HHu*H46 HU ט I   Z  E3  H.u
HFHP03H- H9CusH. (f.z&u$I/ Htv I  < ]    H+u
HCHP0A$   L;=R. u>HYa H
"/ H	- Hr5 H  J  ۖ j  u  H I3HHu'H45 HU ח J   l  7  H5- H HH9Cu+ HHub n     H+u
HCHP0H, H HH9FuM+ HHu'H4 H 9 J   q  E3jH.u
HFHP03H   - Htw t   J  E3H(4 HI HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0Ll$0H
_ H+u
HCHP0A$   HMHt
H)uHAP0MtIm uIEIP0HMQLEMM HT$8HMF   DBoHMv[LEMM HT$8HMG   DBoHMK[HMH3HL$   I[PA(sA({IA_A^A]A\_^]HATH   HXE3HhHpHxLhELpLLxELd$hLd$ Ld$p) Hu*H2 AH ;         L_) Hu*Hc2 IH     ɓ     AL艌$   =, HHu*H2 IH<        <  H
( HLHHu    T   ?  H+u
HCHP0H| LI( yN       =  H/u
HGHP0AN$   z+ HHu*H[1 IHy        y  HA LI( y˓       G=  H/u
HGHP0IN<HHu*H0 IH     F     H LI' yP       <  H/u
HGHP0AFH) HHu*Hb0 IH     ȑ     Hx LI$' yҒ       N<  H/u
HGHP0ANP]HHu*H/ IH     L     H LI& yV       ;  H/u
HGHP0ANx9]HHu*Hj/ IH 
    А     H8 LI,& yڑ       V;  H/u
HGHP0E8fyt{INX;HHu*H. IH     O     H? LI% yY       :  H/u
HGHP0E8   t~I   :HHu*Hb. IH     ȏ 6    H LI$% yҐ     8  N:  H/u
HGHP0H
 HAH9E u!H HtH H ^H
 MH= HLG$ HH HHH
 Hʥ HtH' HtIHHHu*Hi- IH 	    ώ K    AN|$   e& HIHuԏ     M  F;  H$ H9Cu7H{Ht.HkHHHHE H)uHAP0LHH_HH"HHtH/u
HGHP0H.u
HFHP0Hu?     \  :  H+u
HCHP0H
U Hl$hHAH9- u!H, HtH H= ^H
| MHs HLC" HH HHH
 H= HtHj% HtIHPHHu*H+ IH q    7 i    HGHHH L   MtAq$ HHu+     k  7  H/u
HGHP0A   HH^# HHu     n  W9  H+u
HCHP0H][؅y    w p  -7  H/u
HGHP0  HEHH` L   MtA# HHu*H* IH B     {    Hh LId! y    ؋ }  6  H/u
HGHP0A   $   [# HHu*H* IH:        :  HҐ LI  y    R   6  H/u
HGHP0A   L$0" HHu*H) IH 9         H_ LI[  y	    ϊ   5  H/u
HGHP0A   L$8U" HHu*H) IH4     |   4  H LI y    L   5  H/u
HGHP0A   L$@! HHu*H( IH 3         H) LIU y    ɉ   4  H/u
HGHP0L1  IH  y*H( IH,     t   ,  A   UHHu*H' IH o    5     H LI y?       3  H/u
HGHP0A    HHu*HN' IHl        l  H LI y       :3  H/u
HGHP0A   l HHu*H& IH m    3     H LI y=       2  H/u
HGHP0A    HHu*HL& IHj        j  Hz LI y       82  H/u
HGHP0A   L$H HHu*H% IH i    /     H7 LI y9       1  H/u
HGHP0A   L$Pe HHu*HF% IHd        d  H܋ LI y    |   21  H/u
HGHP0A   L$X HHu*H$ IH c    )   
  H1 LI y3     
  0  H/u
HGHP0A    HHu*HB$ IH`        `
  H LI y    x   .0  H/u
HGHP0A  ` HHu*H# IHߌ a    '      Hw LI y1     "  /  H/u
HGHP0A   HHu*H@# IH^      ,  ^  H LI y    v .  ,/  H/u
HGHP0H
Ɗ HAH9ˑ u!H2 HtH H# ^H
 MH= HLGl HHz HHH
 H HtH HtIHƹHHu*HG" IHe      8  e  A   L$(C HHu    { :  $0  H IH9Cu6HsHt-H{HHHHH)uHAP0LHH>HHHHtH.u
HFHP0Hm u
HEHP0Hu     I  /  H+u
HCHP0HGHHԈ L   MtA
 HHuǃ     L  C-  H/u
HGHP0H} LI y    M O  .  HHH\$ HHu
HCHP0H
 HAH9 u!H HtH H ^H
 MH={ HLG6 HHD HHH
 H HtH HtIH萷HHu*H  HH/     w [  /	  HCHH L   MtA HHuk    H. ]  -  H+u
HCHP0A   HH HHu%     `  +  H/u
HGHP0HOy    H b  ]-  H+u
HCHP0tzA  L$(3 HHu*H HH     Z m    H LI   `    H# o  ,  H
 HAH9h u!H HtH H ^H
w MH=n HLG) HH7 HHH
 Hm HtH HtIH胵HHu*H HH"     j   "  HCHH+ L   MtA HHu^    H!   +  H+u
HCHP0A   HH HHu    ~   )  H/u
HGHP0HMy    H~   P+  H+u
HCHP0txA    HHu*H HH     O~     H LI   U    H~   *  H
x HAH9 u!H HtH H ^H
l MH=c HLG HH, HHH
 HZ HtH HtIHxHHu*H HH ~    _}     HCHH L   MtA HHuS~    H}   )  H+u
HCHP0A   HH HHu
~    |   '  H/u
HGHP0HKy}    H|   G)  H+u
HCHP0H
 HAH9 u!H HtH H ^H
߄ MH=ք HLG HH HHH
l HU HtH HtIHHHu*Hl HH }    {     HCHH+ L   MtA HHu|    H{   5(  H+u
HCHP0A   HH HHu|    F{   %  H/u
HGHP0HIyI|    H{   '  H+u
HCHP0	  H
T HAH9! u!H HtH H= ^H
 MH HLC HH HHH
Տ H= HtHn HtIHTHHu*H HH u{    ;z     A   L$` HHuC{    	z   $  Ha IH9Gu6HwHt-H_HHHHH)uHAP0LHH̤HH菩HHtH.u
HFHP0Hm u
HEHP0Huz    qy   '$  H/u
HGHP0HCHHb L   MtA HHuH|$ Pz    y   %  H+u
HCHP0H
f HH|$pHAH9{ u!Hb HtH H=S ^H
 MH HLC HH HHH
/ H= HtHx HtIH^HHuEH H  y    Hx   H|$ Dly H
9 /x Fj`%  HGHHs L   MtAd HHuy    w   "  H/u
HGHP0A   HHQ HHuH|$ x    w   H$  H+u
HCHP0HKF؅yx    ew   "  H/u
HGHP0   L IH  y'H H~ Ex    w   H{ IcHHu'Hd H~ x    v   He H
 HHuw    v   R!  H/u
HGHP0Hz LI K  H|$ w    Sv   "  H
| HAH9 u!Ho HtH H` ^H
~ MH=} HLGY HHg| HHH
l H% HtH
 HtIH賫HHu'H4 HU} v    u 1  PHCHH~ L   MtA HHuH|$ v    Ru 3  !  H+u
HCHP0A   HH HHuIv    u 6    H/u
HGHP0HCyH|$ 
v    t 8  !  H+u
HCHP0  L IH| 
 y'H H1| u    yt C  ,Hyx IўHHu'H H{ uu    ;t L  H;w H
 HHuH|$ ?u    t N     H+u
HCHP0Hw LIQ	 yt    s Q  {  H/  HGH  H
z HAH9 u!HӇ HtH H=ć ^H
c{ MHZ{ HLC HHy HHH
H H= HtH) HtIHHHu'H Hz 3t    r e  HGHHv L   MtA3
 HHus    r g  i  H/u
HGHP0A   HH 	 HHuH|$ s    kr j    H+u
HCHP0HA؅yns    4r l    H/u
HGHP0  L} IHZz t y'Hq Hy s    q w  Hu I2HHu'H3 HTy r    q   OHv Hk HHur    kq   !  H/u
HGHP0H[u LI yH|$ `r    &q     H+u
HCHP0H&v MIr H|$ &  Hf Hx 	r    p   H
/w HAH9< u!Hˈ HtH H ^H
[v MH=Rv HLG HHv HHH
~ H HtHI HtIH/HHu*H IHw Pq    p   HCHHGt L   MtAP HHu
q    o   y  H+u
HCHP0A   HH= HHup    o   C  H/u
HGHP0H<>yp    Vo     H+u
HCHP0`  HEHH?u L   MtAx HHu*H
 IHv !p    n   HGv LIC yo    n   `  H+u
HCHP0A   $   : HHu*H IHv o    an   Hs LI yko    1n     H+u
HCHP0A   L$` HHu*Hx IHu o    m   HFv LI: yn    m   W  H+u
HCHP0A   L$X4 HHu*H IHu n    [m   Hu LI yen    +m     H+u
HCHP0A   L$P HHu*Hr IHt n    l   H`q LI4 ym    l   Q  H+u
HCHP0A   L$H. HHu*H
 IH
t m    Ul   
HEr LI y_m    %l     H+u
HCHP0A   
 HHu*Hn
 IHs m    k   Hlw LI0 yl    k   M  H+u
HCHP0A   7HHu*H	 IH
s l    Uk   
Hn LI  y_l    %k     H+u
HCHP0A   L$@ HHu*Hl	 IHr l    j '  Hs LI.  yk    j )  K  H+u
HCHP0A    HHu*H IH	r k    Qj 3  	HQu LI  y[k    !j 5    H+u
HCHP0H
qp HAH9Fz u!Hx HtH H=vx ^H
p MHp HLC  HH%p HHH
y H=;x HtH HtIHqHHu*H IHq j    Xi ?  A   L$(  HHu`j    &i A    H~  IH9Gu7H_Ht.HoHHHHE H)uHAP0LHHHH諘HHtH+u
HCHP0H.u
HFHP0Hui    h P  D  H/u
HGHP0HEHHn HL   MtA  HHu'H Ho ai    'h ]  Hk LI  y1i    g _    H+  HCHP0  H
>n HAH9 u!HZv HtH HKv ^H
jm MH=am HLG  HHm HHH
υ Hv HtHX  HtIH>HHu*H IHn _h    %g s  HCHH^p L   MtA_  HHuh    f u    H+u
HCHP0A   HHL  HHug    f x  R  H/u
HGHP0HK5yg    ef z    H+u
HCHP0  HEHHNl L   MtA  HHu*H IHm 0g    e   HVm LIR  y g    e   o  H+u
HCHP0A   L$8L  HHu*H
 IH+m f    se   +Hj LI  y}f    Ce     H+u
HCHP0A   L$0  HHu*H IHl *f    d   H i LIL  ye    d   i  H+u
HCHP0A   0HHu*H IH)l e    qd   )Hi LI  y{e    Ad     H+u
HCHP0H
j HAH9 u!Hz HtH H=z ^H
g MHg HLC7  HHEj HHH
 H=cz HtH  HtIH葙HHu*H IH0k d    xc   0A   $     HHu}d    Cc   
  H  IH9Gu7H_Ht.HoHHHHE H)uHAP0LHHHHȒHHtH+u
HCHP0H.u
HFHP0Huc    b   a
  H/u
HGHP0HEHHh Hl$ L   MtA  HHu*H  HHi yc    ?b   H7e LI  yIc    Hb     H+u
HCHP0H
\h HAH9x u!H HtH H ^H
e MH=e HLG  HHh HHH
x H^ HtHv  HtIH\HHu*H  HHh }b    Ca   HCHHl L   MtA}  HHu7b    H`   
  H+u
HCHP0A   HHg  HHua    `   m  H/u
HGHP0Hf/ya    H}`   )
  H+u
HCHP0	  H
f HAH9Bl u!Hn HtH Hn ^H
c MH=c HLGk  HHyf HHH
k Hn HtH  HtIHŕHHu*HF  HHdg `    _   dHCHHi L   MtA  HHu`    Hc_     H+u
HCHP0A   HH  HHuZ`     _   	  H/u
HGHP0H-y#`    H^     H+u
HCHP0  A     HHu*H'  HHEf _    ^   EHc LI  y_    HZ^     H+u
HCHP0A   B  HHu*H  HHe C_    	^   He LIe  y_    H]   
  H+u
HCHP0A     HHu*H  HH=e ^    ]   =H-c LI  y^    HR]   	  H+u
HCHP0A   :  HHu*H  HHd ;^    ] )  H9h LI]  y^    H\ +  z	  H+u
HCHP0A     HHu*H  HH5d ]    }\ 5  5H}g LI  y]    HJ\ 7    H+u
HCHP0A   2  HHu*H  HHc 3]    [ A  Hg LIU  y]    H[ C  r  H+u
HCHP0A     HHu*H  HH-c \    u[ M  -H5d LI    {\    H>[ O    H
a HAH9g u!Hi HtH Hi ^H
^ MH=^ HLGD  HHRa HHH
g Hi HtH  HtIH螐HHu*H  HH=b [    Z c  =HCHHe L   MtA  HHuy[    H<Z e    H+u
HCHP0A   HH  HHu3[    Y h    H/u
HGHP0H(yZ    HY j  k  H+u
HCHP0  A     HHu*H   HHa Z    fY u  H^ LI  ypZ    H3Y w    H+u
HCHP0A     HHu*H|  HH` Z    X   H` LI>  yY    HX   [  H+u
HCHP0A     HHu*H  HH` Y    ^X   H^ LI  yhY    H+X     H+u
HCHP0A     HHu*Ht  HH_ Y    W   Hc LI6  yX    HW   S  H+u
HCHP0A     HHu*H  HH_ X    VW   HVb LI  y`X    H#W     H+u
HCHP0A     HHu*Hl  HH^ X    V   Hb LI.  yW    HV   K  H+u
HCHP0H  H
\ HAH9s u!Hl HtH Hl ^H
\ MH=
\ HLG  HH\ HHH
Xs HQl HtH  HtIHHHu*Hh  IH] W    U   HCHH7[ L   MtA  HHuV    U   1  H+u
HCHP0A   HH  HHuDV    EU   H  H\ HH/HGHP0H/u
HGHP0H#yV    T     H+u
HCHP0  L` IH!\ #  y*H   IH>\ U    T   >L  IHL`   y*H  IH[ {U    AT   A   9  HHu*H  IH[ :U     T   H`_ LI\  y
U    S   |H+u
HCHP0A     HHu*H  IH:[ T    S   :HZ\ LI  yGT    RS   IH  HZ HH+HCHP0H+u
HCHP0H$X MIp  Iy*Hj  HZ 
T    R 
  IIML$   H$   H$   H$   MtI/u
IGIP0L$   MtIm u
IEIP0HL$hL$   Ht
H)uHAP0HtH/u
HGHP0HL$pH$   Ht
H)uHQR0IHİ   A\HUATAUAVAWHhH   HEHXHpHx H H3HEL3DHL$XDHL$`HE   HMMHE   HMM؋DH
Q HAH;  uE33+H;   uHA@t	3łE3HV 褃HHu'H  HX XR y   Q )  	  LLyhAAAGAIOHHu'Hh  HX R }   P R    LHL;
  t;MIL8 Hy H
  H	I  Q }   P T  6  IMH)uHAP0IuIO bHHu'H  HW vQ ~   <P b  1  LHL;
`  t;MIL H H
-  H	  .Q ~   O d    IM H)uHAP0Iu AG8AE(3  HHu'H3  HTW P    O |    H|$XI_@I;_H"  E3HCH+HHHD$hHLL$@D$8  DL$0HD$(LL$ A   LD$hAQHFP HH  H   ILHt
H)uHAP0LGHG HE3AL;AL9G tI$HGN$I@HGIHd  tE3HI;_H1NH%  HFV O    N     H  HV O    gN   \  3.  HHu'H  HU jO    0N   %  I_XI;_`   HEH;tIE3HHMH IE3HUHMuHE   LuDt$pIE3HUHL$pOH  HD$(HL$pi&  HHtdHVH9V ~H HNHHJHNHH  uH/u
HGHP0I;_`?2N    FM     gN    -M     Ht$`H
S HAH9-a u!Hh HtH H=h ]H
U LHU LCH.  HH<S HHH
` H=bh HtH  Ht3H艂HHu'H
  H+T M    sL   h  HGL   HXV HMtA  LHu'H  HS YM    L     H/u
HGHP0   3  HHu'Hl  HS M    K     HHpHD$XH HG E3HH
U ~HHu'H  H9S L    K   L  H/u
HGHP03H  I9Fu6I^Ht-I~HHILH)uHAP0LHH5vHIzHD$PHtH+u
HCHP03H.u
HFHP0H\$PHu'H[  H|R K    J     I.u
IFIP0IM0H)uHAP0I]0I  HHu'H  HR K    dJ   Y  IM@H)uHAP0I]@A  AEHI  HMH
  HL$(H"  HHu'H  HQ 'K    I 4    IMPH)uHAP0I]PI  HHu'H4  HUQ J    I C    IMXH)uHAP0I]X3O  HHu'H  H	Q J    QI R  F  I  I;  O  @ HEH;tIE3HHM	H IE3HUHM	HE   H}@}IE3HUHMh	H  HD$(HM!  LHt]HNH9N ~H HFL4HAHFIH0  u"I.u
IFIP0I;  ?   dH ]  
XH [  ~I    H  HO H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0D/I G H
 	:3IM`H)uHAP0Iu`IE IMtIm u
IEIP0HL$XHt
H)uHAP0MtI,$uID$IP0HL$`HtH)uHAP0HEHrPHHMH=   r<t  HAH;rq  H+Hsa  H'vT  HsHE   HE    E HMFHHMH3L$   I[8Is@I{HIA_A^A]A\]@SH H  HH HI`H)uHAP0H  HC`3H [@SH H  HH HI`H)uHAP0H  HC`3H [H\$WH LJHL;
`  HtrH;\  tiH
3  L$ MIH H	  Hq  HM G [   E     H
 A[   7H\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH Hc  HH HIXH)uHAP0HE  HCX3H [@SH H#  HH HIXH)uHAP0H  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H#  HH HIPH)uHAP0H  HCP3H [@SH H  HH HIPH)uHAP0H  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0H  H)t$ H9BurH  (f.5} zTuRh  HtGH  HJ C X   MB     H
 AX   R4(t$ H0[sH3(t$ H0[KH(AH  Hu;HU  HvI B X   A     H
  AX   33H(H(AH  Hu;H  HI B X   ^A     H
~  AX   c33H(@SH Hc  HH HI@H)uHAP0HE  HC@3H [@SH H#  HH HI@H)uHAP0H  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H#  HH HI8H)uHAP0H  HC83H [@SH H  HH HI8H)uHAP0H  HC83H [H\$WH LJHL;
   HtrH;  tiH
c  L  MIHI  H	  H  HF D@ V   
?     H
z  AV   1H\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H  HH HI0H)uHAP0Hu  HC03H [@SH HS  HH HI0H)uHAP0H5  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H  H)t$ H9BurHU  (f.5x zTuR  HtGHT  HuD = T   < X  X  H
  AT   .(t$ H0[s(3(t$ H0[KH(A(a  Hu;H  HC h= T   .< 5  5  H
~  AT   3.3H(H(A(  Hu;He  HC = T   ; 5  5  H
  AT   -3H(@SH H  HH HI H)uHAP0H  HC 3H [@SH H  HH HI H)uHAP0Hu  HC 3H [H\$WH LJHL;
@  HtrH;<  tiH
  L  MIHI  H	  HQ  HrB ; S   :     H
Z  AS   ,H\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH HC  HH HIH)uHAP0H%  HC3H [@SH H  HH HIH)uHAP0H  HC3H [H\$WH LJHL;
  HtrH;  tiH
  L  MIH	  H	  H  H@ d: R   *9     H
  AR   /+H\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;  AE3H;  A3H;  DEuHb  DEEtR  HtGH  H? =9 Q   8 :  :  H
  AQ   *H\$0H _È_3H\$0H _;H(y tH'  H H  H  H H
  Hu;H  H? 8 Q   _7     H
o  AQ   d)3H({H\$WH HHK'؃uO  HtDHr  H> 8 P   6 
  
  DCQH
w  (H\$0H _É_3H\$0H _kH(IL$0  Hu;H  H> 7 P   L6 
  
  H
|  AP   Q(3H(H(IL$0  Hu;H  H= &7 P   5 
  
  H
  AP   '3H(H\$Hl$VH H3H
5  HAH;  uE33h+H;=  uHA@t	3fH1: E3gHHu'H  H< u6 q   ;5 r
  =  HCHH9 L   MtAu  HHu4 t
     HW  H|$03H9Cu3H{Ht*HsHHHHH)uHAP0HHdHeHHtH/u
HGHP0H|$0Hu4 
  1H+u
HCHP0     HH   L4 
  H  H; d5 q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HSHR0D"5 H
  3 %3H\$8Hl$@H ^H
3 HHHHh Hp(H
  HH
  HH0H
  HH
  HH8H\$8Hl$@H ^@UAWH8HBE3H;  AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH;  t[HH  HHu'Hy  H: 4 m   2     H@L   Mu^2     HIIMMu>H  H9GuH;w  HGHHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHIV_HHtFLHI  tH+BHCHP033 n   1 (
     2 n   1 &
       LH   H
  LI;   HHD9   }F      @t:I@   yA      @t3Is
IIII  ug!1 
  G2 m   H  H8 HtH/u
HGHP0HtH+u
HCHP0D2 H
  0 " b  H/u
HGHP0L=  ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Ht$ AVH H4 E3H\$0E3HHl$8H
/ H|$@HHu1H5;  Ht  H7 1 f   H/ x    HXHH
; HD5 HAL   MtA	  HHu'H  H37 0 h   {/      H  IH9Cu4H{Ht+HkHHHHE H)uHAP0HH_HF`HHtH/u
HGHP0Hu-H  H6 %0 h   .   H   zH+u
HCHP0HHn  HHu$H1  HR6 / i   .   BH\HHuMH  H6 / i   f.   H+u
HCHP0D/ H
$  B. Y &H+u
HCHP0HLH/u
HWHR0H.H|$@Hl$8H\$0u
HVHR0IHt$HH A^@SVWAUAVH Lq333L9Yxt3H A^A]_^[Hl$PLd$XL|$`Mu*H	  E3H'5 . i   o-       LHu'H  H4 t. i   :-     IFHHHu-H
M  Ln  H( H	   -   &  HAH;$  tWH;s  tNH  HHuH
H  H
i4 ,     H@L   Mu],     H3E3HMu>H  H9FuH;nQ  H^HHH)H;n7  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA9  HHtNH+u
HSHR0IVLI3  uH/HGHP0+ J     u+ G     H
  Lb  HW& H	  H+ D  o4  HtHp  HHetD  H.u
HFHP0IAEx[Ld$XIL|$`Hl$PH A^A]_^[* :  3HJ  Hk2 + i   I/u
IGIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D+ H
  W* n>H\$Hl$Ht$H|$ AVH H. HH

* E3HHuH>    H   H
) HxHH5T5 L5]3 H-~2   HHt~HH_HG3HG| GxHGHHGPHG HG(HG0HG8HG@MtILw`HtHE HoXHtHHHwhHGp_  H+u
HCHP0HG  H  H0 -) S* i   Ai   H
  -H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtHih  HH [H [@SH HYhHtH)h  HH [H [H(HB      tHAL   MtAy  Hu;H  H/ () `   '     H
  A`   3H({H   HD$   Ht
33@HĈ   H(HHH  ȅx3H(@WH@HD$ H\$XHmv H3HD$0HHL$(LL$xHAHyrH	HH;}HH33  E3MtA\  HHHHL$0H3H\$XH@_LAL9A ~HHAJI@HA3H%  LYE3HA EHL;AL9Y AEtHHAJICHA3H%λ    3H;HUHhH   HEHXHpHx Hu H3HEGHHM3uE   HE   Hu@uDFHD  HMHE   Hu@uDFH  HMHuHE   Hu@uIE3HUHMHE7   Hu/@uIE3HUHMHUH   HMUHMLHEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  HHE   HuE HEHrPHHMH=   r<t  HAH;r  H+Hs  H'vx  HHE   HuE A   H  HMqHE   HuE A   Hg  HMJE   E   HE   HuE IE3HUHMGHE7   Hu/E IE3HUHM"HUH   HMǦHM辦HM账HM誦HHMGH3;L$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+H׉HCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;v  H    H=   r<t  HAH;r  H+Hs  H'vx  HH3HsHsHH\$@Ht$PH0_@SH H	 HHHQ  HH	 HHc$ HH!v  Hs	 HHH  HH:	 HH# HH *  H'	 HSHH  DHH 5HH" VHHl H [H%ز  H(HY  HH6 H(H%  @UVWATAUAVAWH$H@  Hǅx  H$  Ho H3H8  LD$pHT$PHMH  L  ML  MLt$hHMڝWD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8DH|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
 [  H
 M  3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM萜3H]Mt`IrAfoY IHfHnflfHAfHnflfLHH;rI;s     HHI;rL%} L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH  3Hã H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  H: H   L   L  L   L   HUH   wL   H   H   H   H   E3AL}H   H   HMI+HL   H;vdM9s
HH;rbHǸ  HD$x3HEHEHi HD$XD$`HUHL$X  H9 HD$xH, HL$xH
[ 5  H- HE Lu(Le0HEH+HHE8HUHM@uLE0HU8HMXHU8H   ILuHU8H   HMI+HLE(H;vdM9s
HH;rbHڷ  HD$x3HEHEH| HD$XD$`HUHL$X#  HL HD$xH0+ HL$xH
n H  L%  LeHT$hHULmH  HEWD$PWM LmLD$PHM Q  >HHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  Hs H  HE(H  HE0H  HE8H  HU@H  諗H  HD$XL% L  HE`H   HEhH  HEpH  HUxH  H   H0  KHӛ HH  H   HP  H   HX  H   H`  H   Hh  H  HD$XL  H   H  H   H  H   H  H  H  >H   H  蚖HJ H@  HH  HD$XL% LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX  PLd$xH  HEHE   LmE IE3H  HMH  HD$(H  HD$ LH  L@  HT$xHHHU HtLEL+IH   Ht%L   L+IWf   L   HMX=HU@HtLEPL+IWfE@LmPL% Le H   Ht%L0  L+IWf   L0  H   H   Ht%L   L+IQWf   L   L   L- L  H  莚L  L  L  H  mL  MtLEM+IIHtH+HLHMtLEM+IIHH8  H3H$  H@  A_A^A]A\_^]@SH Hc6 HD$0H+O6 H
p6 HH\$0H;sSHS6 HT$0H;wBH\$0H+HH;
F6 u   H
(6 H
$6 H6 Ht9HH)H;
6 u   H
5 H
5 Ht
HH
5 H7 HD$0H+7 HHH
5 H
5 H\$0H;sSH5 HT$0H;wBH\$0H+HH;
5 u   H
5 eH
5 H5 Ht9HH)H;
5 u   H
l5 /H
h5 Ht
HH
Y5 Hj7 HD$0H+V7 HHH
75 H
6 H\$0H;sSH6 HT$0H;wBH\$0H+HH;
6 u   H
t6 H
p6 Ha6 Ht9HH)H;
\6 u   H
>6 yH
:6 Ht
HH
+6 HH5 H
6 H
"5 赏H5 H
'5 貀H4 H
,5 H [隀HXH4 H94    HRH
3 H\$PsH4 H
5 H-3 HRTH-3 L
6 H
v5 IH5 H+HHYH;s>@ HHtH   L5 H5 IHH+HH;rH
5 HQ}H-
5 H\$PHXW
Hx  D$(HD$0HT$83HL$ HD$8HD$@H  HD$   H H& HD$0HL$0HXH2 H92    H2 L5 H4 H2 H4 H4 IH+H\$PH3Ht;     HHtH   L4 H4 IHH+HH;rH2 H\$PH4 H2     HH2 H2 H HH2 HXH=  D$(HD$0HT$83HL$ HD$8HD$@H^  HD$   Hd H$ HD$0HL$0lH\$WH H      ?HAH
1 H9
r1 HS1 u	H=B1 HIHH+21 HHkHH<H;sfD  HKHHPH;wH\$0H _H0 H+0 H
0 HH+AH0 H90 @WH H
    HHu H
  H  H	  H _H  H\$0H(  H/Hu
HWHR0Hu%H
Y  Hz  H	A  H\$0H _H<  H9Ct9H
  H`  H	  H+  HCHP0H\$0H _3H  H+H uHCHP0H Hu%H
  H!  H	  H\$0H _=	  H tA	  H  %  
Hy s4  A
   H4  H
  DH	  H\$0H _  u	HR  t%Ht  H
զ  H	  H\$0H _3H\$0H _3H%  H(Hu           H(HtIw  3H(3HtIv   "     "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[HHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHH&H\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=A\      Hh)|$@)t$Pf( f( fYf(% f(
 f\v ff(fXf~Ё  fYf@  fY8 fff\L      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfX fX| fYfYfYfXfXT ffXfY(t$P(|$@Hhf     ??f\f(^ fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0L f(5 f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(: ffM ff(5! ff5$ fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5m ff5P  A~0  fA0  fff(5 ffffYf(t$P(|$@Hh     HH)|$ )t$0f( f( fYff(% f(
 fXf:	 f(f~Ё  fYf@  fYJ fff\L      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfX fX fYfYfYfXfXf ffXfY(t$0(|$ HHfff     ??f\f(n fsA~$ L f(5A f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(j ff} ff(5Q ff5T fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$0(|$ HH     %"  %  %  %x  %  %t  %v  %x  %z  %|  %~  %  %  %  %&  ff     @UH HE t
e HMPH ]@UH HE t
e HMp萉H ]@UH HE t
e HMPjH ]Hp  $Hp  HHp  Hp  0HH   oHp   Hp  Hp  Hp  H`   H`   HH`   HH`   H($oH`   H@DkH`   HXoHH   $kH@   uHH   uH(   T@UH HE t
e HMHnH ]@UH HE t
e HMHjH ]H8   |@UH HE te H   mqH ]HP   tHP  阇H`   mH`   HmH`   HHmH`   H`mH`   HxmHP   tH@   dH`   THX   DH   D@UH HE te HM`H   ȕ  H ]H`   HH%   H`   HP  阆H@   TH@  xH   H   HH   H   HH0   tH0   hHP   \H    DH@   THH   H   t/H   H   HP   HP   H@   H@   H(   dH(   XH(   kHP  4H0  H0  H0  H0  H0  H0   H0  H0  ԄHP  ĄH0  鸄H0  |H0  pH0  锄H0   XH0  |H0  pH`   HP   HH`   HP   HH`   |Hh   dH`   HTHh   HH`   H8Hh   ,H`   H0H(   鴃HH   騃H(   霃HH   鐃H`   LHp   H`   H@H@  T@UH HE te HM@H   ,  H ]H@   H H%T  H0   H%  H@   H@  HT$UH HLE0H@ HMHL HHMhKHMH衂HEhH   HCEhH
q  HMH3HMPHMXHE0E8HUPHM0ő  HF HEHA   H- HMHTHH   7Hh   +HH   HT$UH HLE Hp HM8L HHMX{HM8сHEXH}pHCEXH
  HM83HM@HMHHE E(HU@HM   Hy HE8A  H HM8H8   jHX   ^H8   HT$UH HLE H HM8L HHMXHM8HEXH}pHCEXH
  HM83HM@HMHHE E(HU@HM 8  H HE8A  HH HM8H8   骀HX   鞀H8   "Hp   鄀HP   HT$SUH(HHMHHHPHH;uHAH HHEHLE0I H_ H   LG HHMPLHHMpHMPH   HEpH   HCEpH
  HMP3HMXHM`H   ƅ   HUXH     H HEPA@  H HMPH   qHP   eHp   YHP   H   dH   HH   HH   H(teH   H@aH   HXTeH   `H   <eHh   `aH8   ThH   ~H   eHh    eH8   hH   x~H0   4H(   
H(   
HP   H   t
@UH HE0te0H   Q
H ]H   }H   }H   }H`   ;dH   }HT$SUH8HHǅ      Hǅ       ƅ    A4   H7 H   苹H]8HH   HP@H   Y}Hǅ      Hǅ       ƅ    A   H H   3HH   HP@H   }H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   ĸHH   HP@H   |Hw  HEH3HEPHEXHz HE8E@HUPHM8ċ  H HEHHJ HMH诿H   <|H   0|H   $|@UH HE0te0H   MH ]H   {H   {H   {HH   7bH   {Hx   bHT$SUH8HHǅ      Hǅ       ƅ    A*   H H   {H]8HH   HP@H   I{Hǅ      Hǅ       ƅ    A   H H   #HH   HP@H   zH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   贶HH   HP@H   zHg  HE`3HEhHEpHj HE8E@HUhHM8  H HE`H: HM`蟽H   ,zH    zH   zHT$UH0HHǅ      HEx    Eh A/   Hg HMhHM0HHUhP@HMhyH  HEH3HEPHEXH HE0E8HUPHM0  H HEHHq HMHּHh   cyHT$UH HHEh   HE`    EP A/   H HMP9HM HHUPP@HMPyH  HE03HE8HE@H HE E(HU8HM >  H HE0H HM0)HP   xH(   xHP  xH0  xH0  |xH0  pxH0  dxH0  XxHP  LxHP  @xHP  4xH0  H0  H0   HP  xH`   zH   4AH   (H   H@H0  wH0   xH0  wH(   wH(   xwH(   lwH(   `wH(   TwH(   HwH(   <wHP   H   dH   XH   LHP   4HX   (H`   H`   HH@   H@   H    H    H   Hx   hjHH   H@   HP   ԟH   tH   hH0   TH0   HH    <H    0H  $HH   dH@   H8   HX   PHP   H0   xH    lH0   HH0   H8H0   Hp霿H0   H   鉿H    H@   HH   H@   H@   H T[HH   H@   H8@UH HE$t
e$HMPQH ]H   tHX   rHX   fH@   4H    8QH`  LtH@  @tH@  4tH@  (tH@  tH@  tH@   锶H@   $"H@   H0TZH@   HHDZH@   H`4ZH@   H   !ZH@   H   N]H@   H   H@   H   YH@   H   YH@   H   ]Hp   UHX   YH  ,sH   sH   sH0   xYH  rH  rH   rH  rH0   <YH  rH  rH   rH  rH0    YH  rH  xrH   lrH  `rH0   XH  HrH  <rH   0rH  $rH0   XH  rH   rH   qH  qH0   LXH  qH  qH   qH  qH0   XH  qH  qH   |qH  pqH0   WH0   WH  LqH  @qH   4qH  (qH0   WH  `H  qH  pH   pH  pH0   DWH  pH  pH   pH  pH0   WH  pH  pH   tpH  hpH0   VH  PpH  DpH   8pH  ,pH0   VH  pH   xVH  YHT$UH0HH   L9 H   H   `H`   $VH`   8CHH   VH@  0RH0  oH  xoH  loHP  `oH  ToH0  UHT$UH0HHǅ(     Hǅ       ƅ   A   Hѵ H  H8  HPLH  H  HH  葲HJ  H  $H  nH  nH  nH  nH  nHP  unH  inH0  THT$UH0HHǅ(     Hǅ       ƅ   A   H H  *H0  HPLH  H  HH  覱H_ H  9H  mH  mH  mH  mH  mHP  mH  ~mH0  SH0  SHT$UH0HHǅ(     Hǅ       ƅ   A#   H_ H  3H  HPLH  H  HHX  诰Hh HX  BH  lH  lH  lH  lH  lHP  lH  lH  RHT$UH0HHǅ       Hǅ(      E33H  觡A'   H³ H  >H(  HPLH  H  HH  躯Hs H  MH  kH  kH  kH  kHP  kH  kH  kH  QH  QHT$UH0HHǅ       Hǅ(      E33H  覠A"   H H  =H   HPLH  H  HHp  蹮Hr Hp  LH  jH  jH(   jH(   jH(   jH(   jH(   jH(   xjH(   ljH(   `jH(   TjH    HH  8jH(  ,jHh   jH(  jH  jH(  iH  iH(  iH(  iH(  iH(  iH(  iH(  iH(  iH(  iH(  iH(  xiH(  liH0   $HP  HiH0  <iHp  0iH0  $iH  iH0  iH   iH0  hH0  hH0  hH@   H0OH@   H  OH@   H@PRH@   HX]H@   HhH@   H( @UH HE t
e HMHP]H ]HT$UH0HHM8HPH
  HMh3HMpHMxHE@EHHUpHM@^w  Hw HEhHl HMhIH   DNHP   8NH   錸H  gH8   DJ@UH HE4te4H   MH ]H   MHH   MH   H  @gH0   IHh   M@UH HE@t
e@HMxpMH ]H   龷H  fHH   vIH`   锿H8   XI@UH HE0te0H   MH ]H`   DH`   HpH`   H  Q[H`   H  FH`   H  +[H`   H  EH`   H  uLH`   H  HH`   H0  ZH@   ZH    ZHH   e@UH HHU@HMHʨH ]@UH HHU@HMH讨H ]HT$SUH8HH]PHHtJHS)HKH+H*HHLI?LHcH    HC    HC    33YHT$SUH8HH]PHHtJHS.HKH+H*HHLI?LHH    HC    HC    33HT$SUH8HH]PHHt3HS+HLCL+I芒H    HC    HC    33萧HT$SUH8HH]PHHt3HS*HLCL+I*H    HC    HC    330H`   c@UH HEhtehHMPH   r  H ]HP   H H%q  HX   H%Zr  @UH HEPtePHM@H   8r  H ]H@   H H%`q  @UH HEPtePHM@H   q  H ]H@   HH%Pq  H8   tEHT$SUH8HH]PHHtJHS]'HKH+H*HHLI?LHH    HC    HC    33ɥHP   DHP   H KH(   HHT$SUH8HH]`HHtJHS
,HKH+H*HHLI?LH3H    HC    HC    33)H@   aH(   H@   H%p  HT$UH HHUhHUhH#HExH+H ]HT$SUH(HH]`HCHr\HHHvr  H=   r<tr  HAH;rq  H+Hsq  H'vq  HHC   HC    H{rH 33)H(   DH(   阕HT$UH HHUpHHcHHA   wm  HH ]H(   H(   HHT$UH HHUpHHcHHA   'm  HLH ]H(   H(   HT$UH HHUpHHcHHA   l  H+H ]H@   H0  _Hh   H`   Hh   H`   HHh   H`   H(H(   H(   vHT$UH HHUPHHcHHA   l  HH ]H(   锡@UH HE t
e HM@^H ]H   dUH   XUH   H8   HP   HN@UH HE0te0HMPH   Xm  H ]HP   H H%l  H@   H%*m  HP   HP  ^HT$UH0HHH0]HT$UH0HH:H0]HT$UH0HHZH0]HT$UH0HHzH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH:H0]HT$UH0HHZH0]HT$UH0HHzH0]HT$UH0HHH0]H  BHp   FHP   BH  `OH  >@UH HEDteDH  H   	k  H ]H  H H%1j  Hh   H%j  H  駬H  [@UH HEDteDH  H   j  H ]H  H H%i  Hh   H%rj  H  >H  b[@UH HEDteDH   H   7j  H ]H   H H%_i  Hh   H%	j  H   իH  ZHT$UH@HH  萱LU@H   H  `H  H   JH  JH  JH0  THP  xZH  \H  鐼H  TM@UH Hp   H  RH ]H8  (OH  LH    H   t@HP  (H   \@HP  NHh  NH   YH   YH  YH   @Hp  @HP  YH  YH0  tYH0  8Hp  \YH0   CHp  DNH  8YHp  BH0  ?HP  ?H8   t?H   8HT$UH0H33CH8   4?H   HT$UH0Hv33H8   >H   鸛HT$UH0H633ÛH8   >H   xHT$UH0H33胛H`   锚H`   鈚H   \>H`   pH`   dH   8>H`   LH   >H`   >H   >H   =Hx   =H(  =H(  =HT$UH`HHP  L HH  YHP  @UH HE t
e HM0 LH ]H8   VHH   @@UH HE te H   6H ]H0   ?9H0   39@UH HH   H   跙H ]@UH HH   H   蕙H ]H`   H%c  HP   H%c  @UH HEPtePHM@HPH ]@UH Hꋅ   t   HM(HP֯H ]@UH HX   HM@H ]HT$SUH8HH]PHHtJHS}HKH+H*HHLI?LHrH    HC    HC    33虘@UH H0   H   .H ]@UH Hꋅ   t   HM(b  H ]H   H%b  @UH HEHteHHM@H   c  H ]H@   H H%b  HP   H%zc  H8   @UH HEPtePHM@HP\H ]H@   LHT$SUH(HH] HKd  HK d  HK(d  33]HT$SUH8HHU0HM8LE@HU833%H@   H@  SH0  H   S@UH HE@te@HM`H   Xb  H ]H`   HH%a  HH   H%*b  H`   6H`  S@UH HE@te@HP  H   a  H ]HP  HH%Ga  HH   H%a  HP  H@  RHP   H   @UH HE te HM0HP耬H ]H0   ޿H8  ?H0  ?H0   =H
 :@UH HX   H@  ,H ]@UH HE te H@  HPH ]H   HAH   $@UH HE te HM0HP谫H ]H0   H8  ?H0  >H0   =H
w j@UH HX   H@  \H ]@UH HE te H@  HP'H ]H   HqH@   3H0   0@UH HE te HM`H   _  H ]H`   H H%^  HP   H%_  H`   ZH`  ~PH`   3HH   6H   LPHP   2@UH HE@te@H   6H ]H   2Hx   X6H  鬠HT$SUHHHHǅ     Hǅ      ƅ   E3Hi  H  請H   HH  HP H  vOHǅ     Hǅ      ƅ   An   H  H  PHH  HP H  "OH   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  HH  HP H  NHǅ     Hǅ      ƅ   A   HY  H  荊HH  HP H  _NHǅ     Hǅ      ƅ   Ah   H  H  9HH  HP H  N E@H.HH][H  MH  MH  MH  MH  MH  wHH   BH  MH  3H  GH   ;H  3H  #H   /H`   3H  H   =H  H(  }=H   QH  :H  鹝H@   AH  LH   53H  鉝H  LH  qH  LH  2H  MH  2H  5H  YLH  MLH  ALH  5LH   .H`   2H  ܜH   =H  HH  ]<H   1H  %9H  陜H@   @H  KH   2H  iH  KH  QH  uKH  1H  -H  1H  H  9KH  -KH  !KH  KH  -H   h1H  ,H   0H   $H   8Hx   ?H   tH   dHP  $-Hp   0H   H   7H  ,Hp   0H   |H   @XHP  ,Hp   0H   LH   7H  ,Hp   X0H   H   QH   d,H   (0HX   >H   IHx   Hx   H8  鴌H8  騌HH  /H   /H8  鄌Hx   /H   /H  /H   /H   x/H   l/H   `/H  鴙H   HH  霙H   HH  鄙H   HH  lH   HHT$UH`HH  'L H  聨H  H@  鄋H@  xHH  .H   .Hp   .H   x.H  l.H   `.H   T.H   H.H   <.H  鐘H   GH  xH   GH  `H   GH  HH   lGHT$UH`HH  L H  ]H  жHP   -Hh   -@UH HEDteDH  H   U  H ]H  H H%U  HH   H%U  H  鋗H   F@UH HEDteDH  H   U  H ]H  H H%T  HH   H%VU  H  "H  FF@UH HEDteDH  H   U  H ]H  H H%CT  HH   H%T  H  鹖H  E@UH HEDteDH   H   T  H ]H   H H%S  HH   H%T  H   PH  tEHT$UH@HH  LU@H   hH  ۴H@   +HX   +H   |+HT$UH@HH   裛L  H   H   pHT$UH HHU HMP趵33HT$UH HHU HMP趷33@UH HHUPHMX蚇H ]HT$UH HHUPHMh:33藇@UH HE0te0HM@H   S  H ]H@   HH%`R  H@   H0  CH   T<H   H<H  CHx   8mH  CH  PH  tCH`   )H  %H@   )@UH HE\te\H   H   %R  H ]H   H H%MQ  H  H%Q  H   ÓH  BH  髓H  韓H  BH(   BH(   BH(   BHp   H   H(   dBH(   XBH(   LBH(   @BH(   4BH   tH  hH0  \H  PH   DH   8H   ,Hx    Hh   Hh   H   H   @UH HE te H   +H ]H   jH   jH   ̃HX   @H  $AH  AH8  jH  jH@   DH  jH  |jH@    H  dj@UH HEPtePH  H   O  H ]H  H H%N  HH   H%kO  H  7H  &H8  O@H8  C@H8  7@H8  +@H  @HT$UH@HL
Ж H H   iH   {iH  ?H  ?@UH HEHteHHP  H   N  H ]HP  HH%M  Hh   H%jN  HP  vH  Z?@UH HEHteHHP  H   /N  H ]HP  HH%M  Hh   H%N  HP  
H  >HT$UH@HH   (rHH@]H  ]hH   QhHP   H  9hH  -hHP   H   hHT$UH@Hh    HH@]H  H  2>H  H  >H   gH   gH   gH   lHX   H0  =H0  =H`  LgH0  @gH@   H0  (gH0  gH@   H0  g@UH HEPtePH`  H   9L  H ]H`  H H%aK  HH   H%L  H`  ׍H0  k#H`  <H`  <H`  <H`  <H  <HT$UH@HL
p H) H   'fH   fH  o<H  c<@UH HEHteHH`  H   8K  H ]H`  HH%J  H`   H%
K  H`  H  ;@UH HEHteHH`  H   J  H ]H`  HH%'J  H`   H%J  H`  H  ;HT$UH@HH   XTHH@]H  dH0  dHP   H  dH  dH0  dHT$UH@H    H߱H@]H  麋H  :H  颋H  :H0  ZdHT$UH0HL   HU8H      H   HH(HH0]H0   4H0  X:H  H  H  |H  pH0  dH   XH   LH   @HT$UH HL   H   33-}H@   H H@   HH@   H(H@   H8H@   HHH@   HXH@   H   M9H   HH   HX   -H0   THH   HHH   <@UH HEPtePHM@HP̒H ]H@   
@UH HEPtePHM@HP茒H ]H@   @UH HEPtePHM@HPLH ]H@   .HT$UH0HHMP733g{H@   DH@   8@UH HE0te0H   H   F  H ]H   H H%E  Hh   H%F  H   [HT$UH0HM8M8LEXIA;|'HR HD$ L
 H H
 DHH0]H@   tH@   h@UH HE0te0H   H   E  H ]H   H H%E  Hh   H%E  H   鋇HT$UH0HM8M8LEXIA;|'H HD$ L
F H H
؎ CHKH0]HT$SUH8HH   H{  t'HM8HPHHK ΫHHD  HH8][Hh   DH`   8Hh   ,H`   H Hh   H`   H0 H   H   4H@   HX   HX   @UH HHU0HM8xH ]@UH HH   HM8{xH ]@UH HE4te4H   }H ]H   Hx   )H   ӞH  ~@UH HE4te4H   H   C  H ]H   H H%B  HX   H%~C  H   JHT$SUH8HH  H   AHx H  E4H]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  oHH  HP H  333wH  3@UH HE4te4H   H   xB  H ]H   H H%A  HX   H%JB  H   HT$SUH8HH  H   ?Hx H  3H]8tHH   HPHǅ     Hǅ      ƅ   A   H  H  nHH  HP H  2Hǅ     Hǅ      ƅ   A<   Hs  H  nHH  HP H  Q2H  HHPHtH;uHAHd HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  mHH  HP H  1H$H8][H  1H  1H  1HT$SUH8HH  H   '>Hx H  S1H]8tHH   HPHǅ     Hǅ      ƅ   AH   H  H  mHH  HP H  0H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  lHH  HP H  x033sH  b0H  V0H  J0H  >0H  20H  H  HT$SUH8HH  H  <Hx H  /H]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  kHH  HP H  Y/33rH  C/H  7/H  +/H  /H  /H  H  H  .H  .H  .H  .H  H  .H  tHH   H  .H  H  t.H  8H  \.H  P.H  D.H  H  ,.@UH HEDteDH   H   =  H ]H   H H%)<  H   H%<  H   ~H   -H   $Hp   8pHp   ,pH    Hp   pHp   H   H  H   H   H8  H8  HT$UH`HHh  ǃLm H`  !Hh  锜H@   TH   HHX   HX   H0   H0   Hp   HT$UH0H    H6H0]H(   d!H   H(   H!H@   <!@UH HꋅH  tH  HM@H   ;  H ]H@   H H%*:  H0   H%:  H@   |H@  4Hx  TH   Hp   HT$UHpHHAHp]H   H   	H   
H   Hx   錷HT$UHpHHFHp]H   UH   驼H   Hx  
H   HHp   HT$UHpHHJHp]H   H   陼H   $
H   Hx   鼶HT$UHpHHOHp]H   H   9H   -Hp   dHp   XH   lH   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  eH   HH0  HP H0  )H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  FeHH0  HP H0  )HWHx][H0  (H0  (Hx   4Hx   (H   <Hh  TH   Hp   HT$UHpHHC[Hp]H   H   ɺH   
H   Hx   錴HT$UHpHH`Hp]H   UH   iH   -Hx  
H   HHp   HT$UHpHHtdHp]H   H   YH   $
H   
Hx   鼳HT$UHpHHiHp]H   H   H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  bH   HH0  HP H0  &H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  vbHH0  HP H0  H&HmHx][H0  ,&H0   &Hx   dHx   XH   lH8   $iH`   HHH   <@UH HE0te0H  H   4  H ]H  H H%3  H@   H%s4  H  ?vHP  c%@UH HE0te0H  H   84  H ]H  H H%`3  H@   H%
4  H  uH0  $@UH HE0te0H  H   3  H ]H  H H%2  H@   H%3  H  muH  $@UH HE0te0H   H   f3  H ]H   H H%2  H@   H%83  H   uH  ($HT$UH0HH  zLU8H   H  鏓H  gH@   8
HX   ,
H    
HT$UH@HH   GzL  H   衃H   HX   	H@   	@UH HE4te4H  H   -2  H ]H  H H%U1  H8   H%1  H  sH  "@UH HE4te4H  H   1  H ]H  H H%0  H8   H%1  H  bsH  "@UH HE4te4H  H   [1  H ]H  H H%0  H8   H%-1  H  rH  "@UH HE4te4H  H   0  H ]H  H H%0  H8   H%0  H  rH  !@UH HE4 te4H   H   0  H ]H   H H%/  H8   H%[0  H   'rH  K!HT$UH0HH  wLU0HMxBH  鵐H   TH0   qHT$SUH(HH0  HM0-HXH0   HtHM HHU0P33dH   H   جH8   ̬H8   H   鴬H   騬H  霬H  鐬H   鄬H   xH  pHT$UH0Hꋍ      P  ;|.U4Hx HD$ L
x LE4Hix H
{ E-H"H0]H(   H@   8H   ԫH   ȫHX   鼫HX   鰫Hp   餫Hp   阫H   錫H   逫H   tH   hH@  oHT$UH0Hꋍ        ;|.U4Hw HD$ L
w LE4HYw H
{ 5,HH0]H   @UH HHEXD HUPHM(aH ]@UH HEPtePHM@H`LxH ]H@   H H    tbH8   @UH HE t
e HMXPH ]H@   H   H   H(   H(   ةHH   ̩H   鴩@UH Hꋅ   t   HM(H`FwH ]@UH Hh   HM@1UH ]@UH HEPtePHM@HPvH ]H@   *H8   H8   H(   H`   H  ԨH  ȨH  鼨H  鰨H0  H   阨H   錨H   逨@UH HEPtePHM@H`vH ]H@   *H   H  H8  HX  H0   D^H   H   H  H0   ^H   H(   鴧H(   騧HP  tdHP  H4HP  H HP  H8HP  HPH@   HX   \H   H   DHp   X]Hp   L]H    Hp   4]Hp   H    H   H    H    H8   H8   HT$UH`HHh  pL H`  AzHh  鴉HP   t H8   h H@   T H`   (H   jHT$SUHHHH  H   k&Hx H  H]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  7UHKHH  P H  H8XHH][H  HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H8  H0  TH   HH0  HP H0  wH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  6THH0  HP H0  H\Hx][H0  H0  Hx   $Hx   H   ,HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H0  H0  |SH   HH0  HP H0  GH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  SHH0  HP H0  Hc`Hx][H0  H0  Hx   Hx   H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H(  H0  LRH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  QHH0  HP H0  HCdHx][H0  H0  Hx   ġHx   鸡H   ̿HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H   H0  QH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  PHH0  HP H0  xH#hHx][H0  \H0  PHx   锠Hx   鈠H   霾HT$SUH8HH]PHHtJHSHKH+H*HHLI?LH#1H    HC    HC    33WHT$SUH8HH]PHHt3HSMHLCL+IAH    HC    HC    33VH8   VHh   H@   @UH HE0te0H  H   "  H ]H  H H%)!  H`   H%!  H  cH0  @UH HE0te0H  H   !  H ]H  H H%   H`   H%j!  H  6cH  Z@UH HE0te0H  H   /!  H ]H  H H%W   H`   H%!  H  bH  @UH HE0te0H  H      H ]H  H H%  H`   H%   H  dbH  @UH HE0 te0H   H   ]   H ]H   H H%  H   H%/   H   aH  HT$UH0HH  gLU8H   qH  醀H0   TH@   H   SH`   HH   H@   SHP   Ƞ@UH HHU`HMPSH ]HT$UH HHU`HMh33S@UH HHU`HMPZSH ]HT$UH HHU`HMh33WSHT$SUWH0HH   HO@qHO HG33S@UH HHUXHMPRH ]HT$UH HHMhG33RHT$SUWH0HH   HO@aHO HHPG33R@UH HHU`HMPZRH ]HT$UH HHU`HMh33WR@UH HHUHHMPRH ]HT$UH HHM@F33R@UH HHUHHMPQH ]HT$UH HHM@F33QH(   鴚H(   騚H   QHT$UH Hv33QH   鄞H0   H%  HT$UH HHH ]@UH HHUPHMXQH ]HT$UH HHUPHMhj33QH`   HH   Hx   ,HX   ęHP   鸙H@   $^H0   OH   kH   kHT$UH HHMHHt
H   33]PHT$UH HHMHHt
H   33-PHh   $HP   HT$SUWH0HH   HO@!HO xHD33OHT$SUWH0HH   HO@QHO 8H@D33O@UH HHE(D HUxHM0BOH ]HT$SUWH HH]pH   H;t-Hf     HK  H  H[(HCH;u33
OH  @UH HEPtePHM@HP|eH ]H@   @UH HEPtePHM@HP<eH ]H@   ZH   $H   DH   H4H8   DHP   hHh   	@UH HEPtePHM@HPdH ]H@   
kHH   鴖H   H餖H@   D
HH   H@   $
HH   @UH HEPtePHM@HPcH ]H@   zhH   	H  	H8  	HX  	H0   $LH   jH   DHh  
H@   $H8   d
H   鄕H(   D
Hh   dHh   XH   @UHH3Ɂ8  ]@UH HM@H ]&@@UH HO>M8H ]
@@UH0HHHL$(T$ L
@LEpUhHM`=H0]HH   D@UH HE te H   !H ]H0   H`   H0   @UH HE te H   H ]H    @UH HE8t
e8HMXH ]H`   H   @UH HE te H   !H ]HX   H@   H   H0   @UH HE te H   H ]@UH HE te H   H ]HX   ]H@   QH   EH0   9@UH HE te H   H ]H0   @UH HE te H   H ]@UH HE t
e HM@KH ]HP   9H   -Hx   !HP   H   	Hx   H(   H@   H(   H@   HP   H   Hx   HP   H   Hx   HP   yH   mHx   aH@   UH(   IHx   =H@   1H(   H   H`   }H8   ^H(   ^H   YHX   MH@   AHT$UH@HYH  H	    Q y:  H~H@]Hx   H`   HH   H0   HT$UH HMYHv  H    ߀ 4  HH ]HP   H8   uHT$UH HXH  H=     3  HH ]H0   g]H    ]@UH HH  H   ;H ]HT$UH HyXH  HÇ E    $  HZH ]HP   \H@   ]H   %@UH H  H   #;H ]HT$UH HWH  H=  y   "  HoH ]@UH H(  HM0:H ]HT$UH HWH  Hކ ` z  & !"  HBoH ]@UH HH  H@  b:H ]HT$UH H2WH[  H|    ~ "  HzmH ]HT$UH HVH  H:    ~ #  HmH ]H8   [@UH HEPtePH   q[H ]H   H   sH8   [@UH HEPtePH   ZH ]H   BH   &HP   ZH@   ZH   H    H    HT$UH HHM(HPHH
  H	p  HUH ]HT$UH HHM0HPHH
`  H	7  HUH ]HT$UH HHM8HPHH
'  H	  HmUH ]HT$UH HHM@HHPHBH;uHAH2 HHEHH
{  H	  HUH ]HT$UH HHMHHHPHtBH;uHAH\2 HHEHH
  H	F  HTH ]HT$UH HHMPHPHH
  H	
  H|TH ]HT$UH HHMXHHPL I;uHAH1 HHEHH
*  H	  H TH ]HT$UH HHM`HHPHAH;uHAHk1 HHEHH
  H	U  HSH ]HT$UH HHMhHHPL'  I;uHAH1 HHEHH
R  H	  HhSH ]HT$UH HHMpHHPL
 I;uHAH0 HHEHH
  H	  HSH ]HT$UH HHMxHPHH
5  H	d  HRH ]HT$UH HH)1  H
  H	1  HRH ]H(   f@UH HE t
e HM0lH ]HX   4H8   (H   HH   ]H8    HX   H   HH   \HH   <H   0H8   $H   H  ^H  ^H  t^Hp   h^H  CH  P^H  H H  H80IH  HpH  tFH   ^H   H xH   H8HH   HpXH   ,FH   ]H   dA@UH H꺸  HMP3H ]Hp   ]Hp   /AH   s]H   H HX   W]H   H8GHH   EHh   /]Hh   H HX   ]Hh   H8HHh   WEH0   \HX   \H0   AH  \H(H=z r_H
y =Hz HH=   r<t  HAH;rq  H+Hsa  H'vT  Hs2Hy    Hy     y  H(}=H(H=y r_H
x V=Hy HH=   r<t
  HAH;r
  H+Hs
  H'v
  H1Hx    Hx     x  H(<H(H=x r_H
w <Hw HH=   r<tA
  HAH;r1
  H+Hs!
  H'v
  H31Hw    Hw     vw  H(=<H(H=\x r_H
;x <HGx HH=   r<t	  HAH;r	  H+Hs	  H'vt	  H0Hw    Hw     w  H(;H(H=\w r_H
;w v;HGw HH=   r<t	  HAH;r  H+Hs  H'v  H/Hv    Hv     v  H(:H(H=u r_H
u :Hu HH=   r<ta  HAH;rQ  H+HsA  H'v4  HS/Hu    Hmu     Vu  H(]:H
 tRH
 dRH(H=D  t:::LA H* L+IN'WH       H(H(H=l  t:99Li HR L+I&WHH     0 H(H(H=  t:}9x9L HҒ L+I&WHȒ      H([iH(H=Ԕ  t:99Lє H L+IN&WH      H(H(H=T  t:88LQ H: L+I%WH0      H(H(H=̑  t:}8x8Lɑ H L+I%WH      H(H
ٓ dPH
 TPH(H   Hj B$H
j HuH(                                                                                                                                                                         $     J     b     z                         И                    $     @     ^     r                    Й                    2     2                  ފ     *     j          .     z          `     $          P          ʈ          &                    n     F          H     b     ~                    >     `     z                    ։          ڗ               Z     4                         x     L     &               f     $               T          Γ          L               p     (               \          А          J     
     Ώ          \               H     ܍     p     .                       p     z                         Ě     ښ                "     8               x     V             ؛                            (     r                                                ʞ     О     ؞     ޞ                            t     j     \     D     (               М               d                   j     D          0          
     X                                 :          N                  |                       d     H     4           
               ȁ                    |     `     <     *          
               ̀                         v     f     P     B     4                                             t     Z     F     ,               ~     ~     ~     ~     ~     ~     ~     z~     j~     R~     ̂     ,~     ~     ~          }     }     }     }     }     z}     b}     P}     8}     "}     }     }     |     |     |     |     |     |     l|     X|     D|     4|     |     {     {     {     {     {     {     {     p{     `{     J{     ,{     {     z     z     z     z     z     z          xz                         Tz     &     B     T     h     <z     x                    }     *z          ԃ                     (     z     y     <     R     h     ~                    ̄     ܄               "     y          :~     y     y     y     y     y     jy     Ly     :y     (y     y     x     x     x     x     x     x             P     J           H         `             @    `                        0            P                      `                                                           0                                                                               "   (&            '            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        
   0           J   pK   
           h
           (
   (       bad array new length    @
      X
   @   P    P       P    
   @              warning OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np  @            ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  ImportError 1   __getstate__.<locals>.genexpr   reshape num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info misc    __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  1   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    pystan._compat  iter_save_wo_warmup     Stan model {} is of mode 'test_grad';
sampling is not conducted.    upar        data sim model_name model_pars par_dims mode inits stan_args stanmodel date get adapt_window       init_alpha  get stan_args_method_t  b   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  B   warmup2 PyStanHolder    __str__ traceplot   shape   UNIT_E  h   int_time    range   method  H   pystan.plots    _summary    NUTS    lp__    array   fitptr  i   (dense_e)   append  I   stansummary l   AttributeError  gradient    order   pystan  L   sampling_algo_t pars    data_args   DIAG_E  q   ndarray is not C contiguous Q   adapt_t0    error   unit_e  f   pars_oi_bytes   epsilon adapt_iter  d   handler tol_rel_obj user    probs   vars_i  g   warnings    index   chains  Zf  __import__  Zd  collections Zg  stepsize    split   metric  O   extract (diag_e)    OPTIM   holder  par grad_samples    _get_kept_samples   dstack  sim _pars_total_indexes s   chain_id    utf-8   format  s   ndarray is not Fortran contiguous   double  end model_code  end StanFit4Model   TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   chains  '   Couldn't allocate space for StanHolder. _verify_has_samples name    LBFGS   loader  s   Metropolis  s   output_samples  dims_oi samples pystan.constants    throw   origin  %s  _check_pars int string_types    _remove_empty_pars  =   _call_sampler_star  #   adapt_kappa keys    send    flush   parent  =   row_stack   'bool'  #   SAMPLING    start   'char'  =   MemoryError #   squeeze seed    init_list   'long'  =   variational #   save_iterations `inc_warmup` ignored when `permuted` is True.   data    
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          =   tol_rel_grad    BFGS    init_radius #   __test__    tuple   =   `dtypes` ignored when `permuted` is False.  #   sampling        C:\Users\VSSADM~1\AppData\Local\Temp\tmpjiyvx26g\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.pyx    adjust_transform    inits   =   _split_data #   RuntimeError    __getstate__    VARIATIONAL =   genexpr Format string allocated too short, see comment in numpy.pxd #   elbo_samples    variational_algo_t  =   tol_param   thin    value   #   DENSE_E refresh adapt_term_buffer       newaxis Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. =   flatnames   flat    inits   #   getLogger   =   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    Couldn't allocate space for stan_fit.   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087 init    sampler_params  pystan.misc warn    numpy   #   digits_summary  numpy.core.multiarray failed to import  column_stack    __name__    dtype   =   adapt_delta #   stepsize_jitter fnames_oi   =   sampler_t   #   control random_seed =   numpy.core.umath failed to import   #   handlers    numpy   =   (unit_e)    numpy   #   logging adapt_init_buffer   =   Non-native byte order not supported #   diagnostic_file argsptr adapt_engaged   adapt_gamma =   history_size    _call_sampler   numpy.core.multiarray   numpy.core.multiarray failed to import  _ARRAY_API  #   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  =   _ARRAY_API is NULL pointer      module compiled against ABI version 0x%x but this version of numpy is 0x%x      module compiled against API version 0x%x but this version of numpy is 0x%x  #   FATAL: module compiled as unknown endian        FATAL: module compiled as little endian, but detected different endianness at runtime   numpy.core.umath    numpy   =   numpy.core.umath failed to import   #   _UFUNC_API  =   _UFUNC_API not found    _UFUNC_API is not PyCapsule object  #   _UFUNC_API is NULL pointer  =   SSE, SSE2   #   empty_nested() must be true before calling recover_memory()     empty_nested() must be false before calling recover_memory_nested() self        empty_nested() must be false before calling set_zero_all_adjoints_nested()  =   stan_version_major  #   stan_version_minor  =   stan_version_patch  #   unknown file name   =   unknown file name       __init__.pxd    Unknown exception       C:\Users\VSSADM~1\AppData\Local\Temp\tmpjiyvx26g\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.cpp    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.pyx #   stringsource    type.pxd        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.__getitem__        attr_names      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.__getstate__.genexpr       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.__getstate__   list        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.__setstate__       Expected %.16s, got %.200s  list        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.__reduce__ stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.num_failed.__get__ dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.num_failed.__set__ list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.test_grad.__get__  list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.test_grad.__set__  list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.inits.__set__  =   Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.par.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.value.__get__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.value.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.args.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.mean_lp__.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.mean_lp__.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder.sampler_param_names.__set__    numpy   #   Expected %.16s, got %.200s  =   Expected %.16s, got %.200s      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._pystanholder_from_stanholder   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._dict_from_stanargs #   'NoneType' object has no attribute '%.30s'  =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  _call_sampler_star      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._set_stanargs_from_dict stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._dict_to_vars_r dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._dict_to_vars_i self    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._call_sampler_star  #   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._call_sampler   Expected %.16s, got %.200s      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087._call_sampler   __cinit__       attr_names  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__cinit__ __init__    ufunc   =   __init__    numpy   #   __init__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__init__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__getstate__.genexpr      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__getstate__  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__setstate__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__reduce__        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.plot  =   'NoneType' object is not subscriptable  extract stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.plot  #   traceplot   =   traceplot       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.traceplot stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.traceplot extract 'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.extract   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.extract   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__unicode__       stansummary upar        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__str__   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__repr__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.__getitem__   #   stansummary args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.stansummary       summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.stansummary       grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.summary   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.summary   log_prob    'int'   =   log_prob        grad_log_prob   get_logposterior        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.log_prob  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.log_prob  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.grad_log_prob dict        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.grad_log_prob args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_adaptation_info   #   get_logposterior        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_logposterior  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_logposterior  get_sampler_params  =   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_sampler_params    throw   #   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_sampler_params    throw   =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_posterior_mean        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.constrain_pars    PyObject_GetBuffer: view==NULL argument is obsolete     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.unconstrain_pars  'NoneType' object is not iterable       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_seed  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.get_stancode      numpy.ndarray.__getbuffer__ plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.flatnames.__get__ 'NoneType' object has no attribute '%.30s'      numpy.PyArray_MultiIterNew1 data        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._verify_has_samples       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._update_param_oi  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._get_param_names  numpy._util_dtypestring stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._get_param_fnames_oi      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._get_param_names_oi       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._get_param_dims   numpy.import_array      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._get_param_dims_oi        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.constrained_param_names   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.unconstrained_param_names stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model._call_sampler #   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew2 mode        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model.sim.__set__   =   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 =   numpy.PyArray_MultiIterNew5 #   Expected %.16s, got %.200s  =   numpy.import_array  #   numpy.import_umath  T   numpy.import_umath  A   numpy.import_ufunc  S   numpy.import_ufunc  A   vector.to_py.__pyx_convert_vector_to_py_double  string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    close   S   string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   t   string.from_py.__pyx_convert_string_from_py_std__in_string  A   vector.from_py.__pyx_convert_vector_from_py_size_t      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ date        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  #   num_failed  #   test_grad   #   mean_pars   #   mean_lp__   # 
 adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.PyStanHolder    extract Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  #   traceplot   #   __unicode__ 1.0 stansummary 1.0 summary log_prob    %d.%d   1.0 grad_log_prob   get_adaptation_info 1.0 get_logposterior    a_row   1.0 get_sampler_params  [   get_posterior_mean  ,   constrain_pars  unconstrain_pars    a_row   ]   get_seed    #   get_inits   #   get_stancode    get_stanmodel   _verify_has_samples #   _update_param_oi    #   _get_param_names    .   _get_param_fnames_oi    _get_param_names_oi .   _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.StanFit4Model   type    Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.__pyx_scope_struct____getstate__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.__pyx_scope_struct_1_genexpr    ndarray stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.__pyx_scope_struct_2___getstate__       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.__pyx_scope_struct_3_genexpr    name    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087 builtins        builtins        flatiter        broadcast       __loader__      __package__ send        Interpreter change detected - this module can only be loaded into one interpreter per process.  __file__        __path__        submodule_search_locations      Module 'stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087' has already been imported. Re-initialisation is not supported. builtins        cython_runtime  __builtins__    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087 '%.200s' object is not subscriptable    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087 need more than %zd value%.1s to unpack  init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087    init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087    name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope       while calling a Python object   while calling a Python object  NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      cannot fit '%.200s' into an index-sized integer too many values to unpack (expected %zd)        at least        at most exactly %.200s() takes %.8s %zd positional argument%.1s (%zd given)     %s() got multiple values for keyword argument '%U'      %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        calling %R should have returned an instance of BaseException, not %R    raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    '%.50s' object has no attribute '%U'    '%.200s' object is unsliceable  Missing type object     Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'  S   Expected a dimension of size %zu, got %zu   T   Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected Y   Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d    gamma   A   Expected a comma in format string, got '%c' t   Expected %d dimension(s), got %d    delta   A   Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler   Y   Big-endian buffer not supported on little-endian compiler   S   Buffer acquisition: Expected '{' after 'T'  T   Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)   Y   'NoneType' object is not iterable   cap Missing type object A   Cannot convert %.200s to %.200s %.200s.%.200s is not a type object      cannot import name %S   %.200s.%.200s size changed, may indicate binary incompatibility. Expected %zd from C header, got %zd from PyObject      value too large to convert to int       %.200s.%.200s size changed, may indicate binary incompatibility. Expected %zd from C header, got %zd from PyObject      can't convert negative value to int     %s.%s size changed, may indicate binary incompatibility. Expected %zd from C header, got %zd from PyObject      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087 %s (%s:%d)  t   value too large to convert to unsigned int  A   can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    gamma   Y   can't convert negative value to pystan::stan_args_method_t  1.0 value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   1.0 value too large to convert to pystan::optim_algo_t  1.0 can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    gamma   1.0 can't convert negative value to pystan::variational_algo_t  1.0 value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  1.0 can't convert negative value to long    _cython_0_29_14 Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing     can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object     _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections.abc collections ,   Cython module failed to register with collections.abc module    Cython module failed to register with collections module    error    /  backports_abc   send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    model   %]  close() -> raise GeneratorExit inside generator.    value    [  gi_running  S   gi_yieldfrom    object being iterated by 'yield from', or None  gi_code __name__    gamma   T   name of the generator   __qualname__    qualified name of the generator generator       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087 an integer is required  compiletime version %s of module '%.100s' does not match runtime version %s     __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    Y   boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      k (internal counter)    The binomial coefficient is undefined for k > n, but got k = %1%.   A   grad_2F1        exceeded        Argument n out of range: got %1%         iterations, hypergeometric function gradient did not converge. grad_2F1    delta   t   boost::math::prime<%1%> is not converging   A   grad_reg_inc_gamma  Y   is not converging   S   grad_reg_inc_gamma  T    iterations, gamma function gradient did not converge.  exceeded    Y   k (internal counter)    grad_reg_inc_gamma  A   grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    gamma   t   t_change    gamma   A   *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    Must use algorithm="Fixed_param" for model that has no parameters.  cap Output generated by Stan (test_grad)    Point Estimate Generated by Stan    Y   Sample generated by Stan    S   Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    gamma   k_s Sample generated by Stan    k_s Sample generated by Stan (Variational Bayes)    user    stepsize__  k_s treedepth__ k_s n_leapfrog__    divergent__ k_s energy__    delta   k_s stepsize__  %1% int_time__  :   energy__    gamma   %1% # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    gamma   %1% boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    :   boost::math::cbrt<%1%>(%1%) %1% 0.003379167095512573896158903121545171688   :   0.0834305892146531832907    0.1e1   %1% -0.338165134459360935041    0.1e1   :   -0.0509990735146777432841   %1% -0.00772758345802133288487  S   -0.000322780120964605683831 k_s 0.455004033050794024546 0.0875222600142252549554    0.1e1   k_s 0.00858571925074406212772   k_s 0.000370900071787748000569  k_s -0.098090592216281240205    gamma   k_s 0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    delta   k_s 0.0195049001251218801359    gamma   nan 0.00180424538297014223957   NAN 1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017    gamma   %1% 0.337511472483094676155e-5  :   -0.0243500476207698441272   %1% 0.0386540375035707201728    %1% 0.04394818964209516296  0.0175679436311802092299    :   0.00323962406290842133584   %1% 0.000235839115596880717416  %1% 1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373    0.1e1   :   0.00410369723978904575884   1.0 0.00295276716530971662634   0.0 0.0137384425896355332126    0.1e1   1.0 0.00840807615555585383007   1.0 0.00212825620914618649141   1.0 0.000250269961544794627958  1.0 0.113212406648847561139e-4  0.0 1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444    0.1e1   1.0 0.0105982906484876531489    0.0 0.000479411269521714493907  1.0 0.00628057170626964891937   0.0 0.0175389834052493308818    1.0 -0.212652252872804219852    1.0 -0.687717681153649930619    1.0 -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  D:\bld\fbprophet_1580258775586\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       D:\bld\fbprophet_1580258775586\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   TEST GRADIENT MODE      Initial log joint probability =         Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  lp__    but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.    1.0 . Improved by    Log joint probability =    1.0 Iteration   1.0 Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  1.0 Optimization terminated normally:   1.0 Optimization terminated with error:     Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  0.0 Optimization terminated normally:   1.0 Optimization terminated with error:     lp__    lp__    t_change    0.0 *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    0.003379167095512573896158903121545171688   1.0 0.0834305892146531832907    %1% -0.338165134459360935041    :   -0.0509990735146777432841   %1% -0.00772758345802133288487  %1% -0.000322780120964605683831 :   0.455004033050794024546 0.0875222600142252549554    %1% 0.00858571925074406212772       0.000370900071787748000569      -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)     0.9016312093258695918615325266959189453125e-19  0.25479851061131551     Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      -0.32555031186804491    Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      The argument a to the incomplete beta function must be greater than zero (got a=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Adjust your expectations accordingly!   Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Initialization failed.  Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.      Log probability evaluates to log(0), i.e. negative infinity.   Log probability=       Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:        Rejecting initial value:          Gradient evaluated at the initial value is not finite.         seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps         attempts.      ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       Exception initializing step size.       t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)  The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%)  Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Result of tgamma is denormalized.       The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.  Evaluation of tgamma at a negative integer %1%. Unknown function operating on type %1%  The argument a to the incomplete beta function must be greater than zero (got a=%1%).   Error in function       The argument b to the incomplete beta function must be greater than zero (got b=%1%).   Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Cause unknown: error caused by bad argument with value %1%      Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)    Random variable Location parameter      Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       -3.7595974497819597599e+11      7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "   7            7 (          "   P8            `8 (          "   8            8 P          "   t9            9           "   9            : (          "   X:            x:           "   :            : (          "   @;            P; (          "   ;            ; 8          "    >            > h          "   |>            > h          "   >            >            "   4?            D?            "   ?            ? h          "   @            ,@ h          "   @            @ h          "    A            A            "   |A         	   A           "   B         
   HB            "   B    B    $C           "   E    F    4F           "   F    G 
   <G           "   @K    K    K x          "   xL     M     M           "   LO         
   tO           "   O         
   P           "   P            P h          "   Q            Q           "   T    T    U            "   lW            tW            "	   W            W (          "   X            X (          "%   X         '   Z x                               
   p   v   0   v      p   @   @v   `         ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx
           
         0      
       
           
   L    P    
   i   `5    
   0   p{   0    {       p   @   z      
   d   L   R   X   ^   d   j   p   v   |      @             
   $    R   R   R   R   R   R   R   R   
   @   
   P   Mb`MbPMbP?Mb`?       @
   ,       
        
   )        
                   P          
           `
            p    
   p!   P    P    P   P    
    _     s   
   D   `
   R   R   R   R   R   R   R   R   
   <      T   
    _    ^    
          ȷ
   0A      
   B   ȵ
            P       p   @             x
   R   R   R   R   R   R   R   R   
   j       8
   0       
   Pj       8
           
   ,    0&     '    (    &    )    *    @+    +    
          P
   8   
            P    
         0         p   @      @   
   0   p{   0    {       p   @   z      h
   `   P         @   @      @   ح
   !   P    P    0   P    
   T    S    
                    UUUUUU?UUUUUUUUUUUU?UUUUUU
   `   @   P   P    P    
           
      0      Є      p   @      `      
    *       8
   @0    P    P    P    P    P    P    P    P    P    P    
      0      `      d         v   |            0      
   t   `      
            
           
           `
           (
   0       l   
   p   `
   ,    0&     '    (    &    )    *    @+    +    
         0/          
    ^    v    
      
   6    P    P    P    P    
             E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        X
                                   
      
                @         P   
   P/    R   0/    R   R   
   `    R   P    P    P    P    P    
      @~      Є      p   @      `      P
   B     ?    P?    ?    P7    `7    `7    P@    7    
           
   T    x    @
   p         `      p   @   `   @      p
             
           Ы
   d   
   ?      H
   p   R   P    P       p   @   `   @   (
      R   P    P       p   @      `   
            
   P    0    
   6       
   R   R   R   R   R   R   R   R   
   `   L   R      p   d      p   v   |   p   `            
    7    6    6    6    p6    h
   `            
   
                 
    ^    ]    X
      0      Є      p   @      `      
   R   R   0.    
   `        P    P    P    P    P    
      
   T    W    
           0
      @
           
           
           
   p5    `5                                     
 
                     	               	               
                                              Ȼ
   |       
   0   t   0   v      p   @   @v   `   
            0   @            Й
   $    P7    `7    `7    P7    `7    `7    7    7    h
           
         @      H
         0/          
           
   |   
   @       
   T   `
   8   д
   p@      8
   T    pZ    P
   `    
                  _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?h
       `
   T    `Y    
                 
   p         `      p   @   `   @      
   P       
    5    0    p0    1    `1    2    P2    p3    @3    `4    04    
      P    P       P    h
   A          
            0    
            ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?
        
      X
          
          0         p   @      @      ?   =
?   @33?   =
?      ?   ?    ?p
            P       p   @             ȟ
   \          x
           x
   R   $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?(
      R   P    P        p   @          
            `      p   @   `   @      h
   h          @
           
   H   
   p   ؠ
   p   0      P       p   @             
           
              p
            0      8
       
   T    T    У
           
   =     8    P8    p:    7    `9    ;    <    0=    
            P    gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@ظ
   R       
   T    0W    0
            
   $       D   
   p   v   0   v      p   @   @v   `           '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        
   Pi   `5    H
       y   0    {       p   @   z      
           @
   @   
         0         p   @      @   8
   ,   P
            P
   .   0    p
   T    [    Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context             bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product     to_matrix(array)        vector size     rows * columns  .   y   n   m   k   T   Y   A   variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   D:\bld\fbprophet_1580258775586\_h_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =     anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2      data initialization K   t   cap S       t_change    X   sigmas  tau     trend_indicator s_a s_m delta   beta    variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   trend   beta_m  beta_a      Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        right-hand side left-hand side  assign  Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!   , but must be >= 0!     D:\bld\fbprophet_1580258775586\_h_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      rep_array   cols    []  Undefined transformed parameter: trend  Undefined transformed parameter: Y      Undefined transformed parameter: beta_m Undefined transformed parameter: beta_a iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed       Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.                 iter             ELBO   delta_ELBO_mean   delta_ELBO_med   notes         MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   D:\bld\fbprophet_1580258775586\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "               P' `          "               &           "               x&           "   q             &            "   #            $ `          "   #            #            "               "            "   "            "           "   8"            @" 0          "                           "   H            P x          "                          "   d                        "                          "               X           "                X          "               X          "                           "   p                        "   (&            X            "   `j            0            "   0j                        "                           "                           "   4%            P            "   8h                         "                          "   p                        "   (&            @            "   @                        "                           "   (&                        "   (&            x            "   `j            P            "   0j            (            "   (&                         "   (&                        "   4%            X            "   8h            (            "               x 8          "               0 8          "   (&                        "                `          "               P           "                0          "   |
            H 8          "                (          "               
 X          "                
 @          "                         "   @            P            "                           "   (&                        "   (&            p            "   `j            H            "   0j                         "   (&            
            "   (&            
            "   `j            
            "   0j            
            "               P
            "   (&             
            "   (&            	            "   4%            	            "   8h            	            "   4%            h	            "   8h            8	            "                         "   t                      "                       "   x:    8    ` 8          "   x:         8          "                @          "   x:    4    `            "   x:                    "                 X          "                (          "   ,            8 X          "   l                        "                 @          "               p             "               8             "   0
                         "   
                        "   
                        "                       "       ( 	   P            "   <    d 
               "                       "   4    L    x            "                       "   x:        @ 0          "   p                    "   x:          0          "   D    \                "                       "   H            h H          "                @          "   P             8          "        (              "   x:         H 0          "   x:         0          "                      "                      "   `                   "   H                   "   ,    \     p          "                0          "                           "   \    ,    ` X         "   t         
              "                           "                X          "   ,            h X          "                           "   |              p         "                           "   4            p           "   |             p         "               (            "                0          "   T            p            "                           "                           "               `           "   (&                        "   (&                        "                           "                           "
                p         "   H            X H          "                           "                (          "
                p         "   d            p (          "                (          "                          "               x (          "   4            @ 8          "                (          "                           "               ` 0          "                0          "   (&                        "   (&            h            "   `j            @            "   0j                        "   (&                        "   (&                        "   4%                        "   8h            `            "   ,            8            "   4%                         "                           "                           "   h            x            "
       \     8         "                           "
       x              "   `    x     (          "                         "   l    \ &    p          "   
            ( @          "   4    l               "        "              "           @           "                      "            `         "   d                   "   P         `         "   ,    l               "                         "   t                   "   T         `         "   4    t               "       L     p         "                8          "                            "   ȿ            п            "	   d                   "   @        @ X         "                 x          "+        Y              "   Ĵ              (          "   |                        "    
            س P          "    
             P          "    
            X P          "   T                        "   x:        а 0          "   Xl                         "   0            p            "   d        Ю           "   D                   "                           "   x:        0 0          "               ȫ            "   l                        "   $            8            "   Ȫ                       "   p            x            "   8            @            "                          "   ,         	   p            "   x:                    "               0 p         "                           "   x:         0          "    l    l ;    P         "   4         *    (         "!   l    t =    @         "   <         *    @         "   Xl            ؚ            "   l                        "   (&            @            "   `j                        "   0j                        "   (&            ș            "   `j                        "   0j            x            "   (&            P            "   `j            (            "   0j                         "   Ԙ             (          "                          "               0           "
               P x         "   0            `            "                (          "                          "                           "               @           "                           "   T            8 8          "   8h                         "   8h            ؐ            "   4%                        "   8h                        "   8            X            "               ( 8          "               ؎ 8          "    
            p P          "           ȍ            "   x:    D    p (          "   x:    Ћ     (          "        
    x          "   x    @     p           "       ̆ '              "       d )             "   \                        "   \                       "   ȁ                      "   @            ` @         "   ~                       "   `~            Ѐ           "   ~                       "   `~            `           "                          "   P            p @         "   ~                       "   `~            ~           "   ~            ~           "   `~            h~           "   }            }          "   H{         -    |           "   x         -   y           "   v    Xw %   w           "   `v            pv H          "    v            v x          "   Lu            u H          "   t            t 8          "   s            t           "   r            r           "    
            q P          "   q            q (          "
   p            q P          "   P            pp 8          "   R            Hp            "    
            o P          "   Pn            o 8          "    
            n P          "   Pn            pn 8          "   |
            n 8          "   x:    m    m H          "   x:    l     m (          "   l            l            "   Xl            `l            "   (&            0l            "   k            k            "   pk            k            "   x:    j    k 0          "   (&            j            "   (&            j            "   `j            hj            "   0j            8j            "   (&            j            "   T            xi 8          "   T             i 8          "   (&            h            "   (&            h            "   4%            ph            "   8h            @h            "   hg            pg            "   0g            8g            "   Df            f (          "   e            f (          "   c    hd '   d @         "   c    4c    `c 0          "   Lb    lb    b 0          "   |a    a 	   a 0          "   `    ` 	    a 0          "$   p]         ?   ^          "   
            (] 0          "   Z    [    [           "   x:    PZ    xZ 0          "   x:    Y    Z 0          "   x:    Y    Y 0          "   x:    Y    @Y 0          "   x:    X    X 0          "   x:    HX    pX 0          "   x:    W    X 0          "   x:    xW    W 0          "   x:    W    8W 0          "   x:    V    V 0          "   x:    @V    hV 0          "   x:    U     V 0          "   x:    pU    U 0          "   P            @U 8          "   T            T 8          "   P            xT 8          "   T            (T 0          "   S            S 8          "   R            S P          "   8S            XS            "   R            S (          "   R            R (          "   R            R            "   Q     R 
   0R            "   DQ            Q            "   P            Q 8          "    
            P P          "   O    O    O            "   N    N    O            "   M     N    0N            "    L     L    pL            "                   K            "   >            @K            "   J            J            "   J            J            "   @J            HJ 8          "   (&            I            "                   hI            "   (&            @I            "   (&            I            "   x:    ,H    XH 0          "   G            G            "   x:    HG    pG 0          "   G            G 0          "   (&            F            "   E            F            "   E            E            "   \E            xE            "                   @E            "   D            E X          "   D            D X          "                   PD            "   x:    0C    XC 0          "   x:    B    B 0          "   >            PB            "   (&             B            "   (&            A            "   (&            A            "   (&            pA            "                   PA            "   >            @            "   x:    l@    @ 0          "   x:    L?    x? 0          "   >            ?            "   l>            > 8          "	   =            = (          "   4=            P= P          "   P:            = (          "   P:            < (          "   |<            < p          "   ;            ;           "   ;            @;           "   x:    :    : 0          "   P:            X: (          "   :             :            "   9            9            "   H8            8            "   L6         &   6           "               6            "	    5            P5            "8   /    0 f   1          "J   '    *    @*           "
   &            0'            "   (&            &            "   (&            &            "   (&            `&            "   (&            0&            "   4%             &            "   4%            %            "   4%            %            "   4%            p%            "   4%            @%            "   h$            $ 8          "   #         
   # H          "   \
            #            "   #            @#            "   "            "            "   !         
   `" (          "   T            ! (          "   T            ! (          "               P! (          "                !            "                 (          "                  h          "               H            "                          "   (            ` 0          "                            "   l                        "   T             (          "   T            ` (          "               ( (          "                           "                (          "   d            x p          "               h           "                          "   (            8 0          "                           "   l                        "                 0          "   @                        "   \                        "   p                        "                           "   \            h            "
               p            "                           "           8 H          "   X    p     `          "
       P               "   p                    "                 @          "                (          "   @                       "
        p     @          "       <    p 0          "   D
    t
    
 0          "   	    	    	 @          "                (          "                           "   $            P            "                           "               8            "   ,            p            "	               p            "                           "   \
                        "   <            P            "   X         
    0         "                           "                           "   
                        "               (           "   \
                         "   
                         "   \
            
            "   @
            
 H          "   |
            
 0          "   |
            
 8          "    
            @
 P          "   
            
            "   
            
            "   $
            
            "   
            H
            "   
            
            "   0
            
            "   0
            
            "   
            h
            "   $
            0
            "   
            
            "   
            
            "   0
            8
            "   
            
            "   @
            P
 H          "   
            
 (          "   
            
 0          "   
            
 0          "   \
            H
 (          "   \
             
 (          "   
            
 (          "   \
            h
 (          "   \
            (
            "   \
            
            "   \
            
            "   \
            
            "   \
            h
            "                   @
            "   
            
            "   H
            P
 (          "   X
            
            "	   h
            
 `          "   
             
 (          "   
            
 (          "                   
                          Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                         ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    0^    
   p  
 
                                                                                                                                                     DP            0             ؗ
 
                            
          
                          @   ؗ
                         P
 (
                            h
         
 
 
                                 @   P
                        
                	   
         0            @   X
                      ` H
 
                             @   8
                `      p 
 X
                            A H
 
                             8
 
                            p$ X
 Й
                 @
                         @   в
                        x
 0
                            
                    
                     @   
                        6  
 
                             @   
             8
 (
 h
 
 
 
 
 
 
 
                                                            H
         (:            @   
                        
                   F 8
 
                 p             @   0
             =            @   
             
            @   X
                (       * x
 P
                            
 X
 x
                            B  
 
                 `
 
                             7 X
 
                  )            @   0
             
 
 
                     
 
 
                                8A 
 p
                            H
                    h
         `            @   
             
 
 
 x
 
 
 
                                                 @   
             p     (       @   0
                        , 
 
                            x 8
 
                 A             @   H
             
            @   
             x
 
                            `
                    
         &            @   
                       x
         
 
 @
                               6  
 ȟ
                           H
                   
                   
                    `# H
 8
                 
  
 
 
 
                             
 (
 
                        (       @2 خ
 
                             ) 0
 ؠ
                 #            @   
             P>            @   б
             XF            @   
              
 ؚ
 
                                
            P       x
 
                 
 
 
                               
                    p `
 
                            (: 
 8
                 0            @   p
                        0
                      (
 
                 /            @    
             
 
                 `&            @   
                          @   `
                           @   (
                        H h
 
                            
 
 
                           /  
 У
                 0
 
 
 
                                    
                     @   
                         @   (
             
 
 @
                     p         P      P   `
             
 О
                 
 
 
 
 
                                        (D 
 
                 x             @   8
                         
 h
                 
  
                 8
 @
                            
 
                           
                    
                      @   (
                       p: 
 @
                            0
         @
 
 @
                                
                      
 
                 
 @
                 
            @   
             H            @   
             ,            @   
                        
                     
         h
 H
 @
                     h*             @   
                         
 
                 2            @   
                       = 
 8
                 `-            @   H
                         
         
 
                 @
             8
 x
 
 
                         p:            @   
                          `
 
                 H
 
                    (       0
 
 X
                 
 
 @
                                
                    ء
         
 x
 
 
                         `
 
                            h
         p
 H
 @
                               
                    
         
 h
                 @             @   
                         0
 
                 X            @   
             
 
 
 x
 
 
 
                                                X
                    
                     @   
             @
 8
 
                     
                         (
 Ы
                 8
 
                 
 
 @
                               
         
 `
                 @            @   
             ؽ
 
 
 
                                    
         @4            @   p
             p             @   0
                P      = 
 
                            @8 X
 @
                            8
                     
                
    
         	            @   
                        @	 h
 ح
                 
  
 
                                H
          
 
 x
 
 
 
                                 F            @   8
                       
                        @   
                       h
          	           @   0
              
 
 
                      	           @   
                        @ 
 `
                 ؛
                        P> б
 
                 B             @    
                P        (
 
                            
                     @   0
                         
         P             @   @
             h
             @   
                        `, 
 
                  
 P
 
                                8
         H            @   
             p            @   
                         @   
             P
 
                              
 
                            
         0
 @
                 '             @   
                        $ P
 (
                 p             @   `
                         @   
             (
 
                            h
                    
         0
 (
  
 ؚ
 
 
 
                                                p
                   @4 p
 @
                 0
 
                 Ȣ
 8
 x
 
 
 8
 
                                                
         0
             h
 
 
 
                                      @   h
             
 x
 
                                0< H
 X
                             @   0
                        P P
 
                              
 д
                 X
                        @   h
             
 О
                 
 
                            XF 
 `
                 -            @   0
                        
                    D 
 ȵ
                              @   
                        
                    
                     
 H
                           x
                    
                     @    
                        
                    
         P            @   P
                         @   `
             h6             @   
                        (
                     @   
             
 
                            ` 
 ȷ
                  7            @   X
              
 @
                            
                    
                      @   h
                        # 
 
                 H.           @   X
                        F 8
 ظ
                 @8            @   X
             P
 
 @
                                - 0
 H
                 8A            @   
                         X
 
                 x
 
 
                                 h
 
                 `            @   H
             /            @   
             
 
  
 ؚ
 
  
 `
                                     
 x
 
                                0F 
 
                 
 
 
 
                                    H
                    x
                    p 
 8
                  
 
                 Ȭ
 
 
 
 
 
 
                                     
                (        
 Ȼ
                             @   @
             @
 
 
 
                                    ) 0
 @
                 
 
 x
 
 
                                        H
                    
                    
         H
 @
                            6 
 
                           
 
  
                 B            @   
              G            @   
             @            @   
             
 0
                 6            @    
                         0
  
                             @   X
             x
 
                           P P
 h
                 H
                       X
                    @4 p
 
                            P
         
    (       @   X
             6            @   
             
  
 ؚ
 
                                     1  
 p
                 -            @   
             
                        
                    p 
 
                             G 
 
                            
                    H. X
 P
                 
 
 
                                  
 
                 -            @   
                         @   x
             @!            @   
             E            @   p
                         + 8
 `
                             p
 
                            h
         9            @   P
                        
                      
 
                 p$            @   X
                        4  
 X
                            @
                    
                     `
 
                            X 
 
                            0 x
  
                            2 
 (
                           Щ
         
 `
                            @
         4            @    
             
 
                            p п
 
                 
                       
                   
         PG            @    
                        P
         5            @   8
                       p
                   B 
 
                    P       
 
                            - 
 
                            
                    
                    0 p
 h
                             
 
                             (
 
                 0
 
                            
                     @    
                         
         
 X
                            
                     
 
                 
 
 
 
                                    pA 
 
                  >             @   P
                       `# H
  
                            /  
 H
                             @   h
                       # 
 
                 G            @   p
                          @    
                       0 x
 
                           h
                     @   x
                        ?  
 x
                 P
 0
                 0<            @   H
             p         @      P   `
                         
 
                 "            @   
                        H
                    
         9           @   
             @2            @   خ
                         
 
                              @   `
                         @   
                          h
 P
                 
            @   
                       
         0            @   (
                        0 
 
                            h6 
 
                 @
 О
                 86            @   ȶ
             H
 
 
 
 
 
 
                                     X            @   `
             D            @   
                        
         0F            @   
                         
 @
                            
         
            @   ȼ
                        
                    
                     
 
                            
                    ` 
 
                 9            @   
             
              
 
 
 
 
 
 
                                                  
 
                  
                         
 
                            
 
                 :             @   
                        
 
 h
                 (
 ؛
 x
 8
                                    0 X
 
                 (
 @
                 p            @    
                       
         p            @   п
             0
  
 
                                 
 
                    P      F 8
 
                 p
 О
                 `
 H
                            PD 
  
                 
             p
 
                             > P
 P
                 H    (       @   
             h
 
 
  
                         (
 
  
                     P
                        G p
 
                            @   h
             
 
 
                                
         
 
                 0            @   x
              
 О
                            P/ @
 
                 h
                          @   
                         
 8
                            
                   h
                    
                   
                    
                     @    
                        
                      @   
                        (
                    
                   X
                     @   P
                         
 
                            P
                    ` 
 
                               
 
                 .            @   
             @
 h
                 
 @
                            
 ȼ
 
                 (
 h
 
 
 
 
 
 
 
                                                        `
         0
            @   
                        
                    H 
 h
                 
 @
                         
 (
 h
 
 
 
 
 
 
 
                                                             @   
                        / 
 0
                 
 
 x
 
 
                             P/             @   @
                        p: 
 
                           `
                    H
                    H 
 
                            0
                     @   
                          @   `
                        (
         p            @   
                        # 
 
                 
 x
 
                     
 (
 ؛
 x
 8
 
                                            
                    X
 p
 p
                  	            @   P
                        h
                     
 
                 ؚ
 
                            
                    
                    Ȝ
                   G p
 `
                 @            @   
             `
                         	 P
 
                 
                          
 
                 "            @   
             8
 8
 
                                Ȩ
                    (
         p            @   0
                         x
 
                           0
 
                            * x
 
                 H            @   h
                        
                    p 0
 x
                 
 
 X
                                  @   
                        
                      @   
                        
         @	            @   h
             
 h
 ؛
 
 8
 
                                 0            @   
                          
 
                            x
         ȝ
 
                 @            @   `
             
 
 
 
 
                             pA            @   
                        PG  
 
                  
 
  
 
 
 
 
                                                . 
 
                 
                          @   
             p
 ؽ
 
 
 
 
                                           
                    `- H
 
                 
 О
                    (       p 
 
                            P 
  
                 
 @
 h
                     H
  
 @
                     @            @   
             x
 
                 ,               P   
                        B 
 
                    P      # 
 
                            @2 خ
 @
                 `            @   
                         
                      
 
                 `,             @   
             $            @   P
             
 @
                 B     (       @    
                        
                   X
                      @   
             
                        
         
 
 
  
 
 X
 
                                                
                     @   h
                        0- 
 `
                            	 
 
                 X
            @   p
             H.           @   X
             (D             @   
             
            @   Ș
                        0
         P            @   
                          @   
                         P
 
                             @
 
                 p
             О
                         
         
 `
                            
            P      `# H
 p
                           8
         
 
                            
         
 x
 
                     @
 h
                            9 P
 
                             
                    x
         `
 H
 @
                     
 
 
 
 
 
 
                                     x
 
                  
 ؚ
 
                     H.            @   X
                    
   
                    
         @            @   
             *            @   x
                         @   h
             (
  
 ؚ
 
                         
             
 0
 
 
 
 
 `
                                     `            @   
                        
            (        
 
                 0               @   (
                        
          +             @   8
             
 
                 ,            @   
                       
 `
                 .            @   
                        " 
 
                 
             h
 ؛
 
 8
                         /           @   
             /           @   
                          @   p
                         
            P        
 
                            
                    
         
             
 
  
                     8
 
                             @   
                        E p
 h
                            
                    
                    
         0-            @   
             `#            @   H
                P      @2 خ
 (
                            
 
 P
                           
                    = 
 
                             
                      
 
                            
         ?             @    
                        X `
 8
                            س
         PD            @   
              
                        " 
 
                               @   
                        Ф
                     h
 
                            
         
 
  
 
 X
                                        
                    p  0
 
                             x
 
                            @! 
 
                 p
 О
                            
         8
 
 @
                                0
 
 h
                 #            @   
             
 
 
                                
         (
 
                 @            @   
              1            @    
             
 @
 
 
 
                                        
         
 
 
                 GCTL   `  .text$di    `  3 .text$mn    J     .text$mn$00 0J   .text$x @   .text$yd      
  .idata$5        .00cfg      .CRT$XCA        .CRT$XCL       .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ         .CRT$XPA        .CRT$XPZ        .CRT$XTA        .CRT$XTZ      h .rdata  
 (   .rdata$T    
 X  .rdata$r    
 t  .rdata$zzzdbg   0
    .rtc$IAA    8
    .rtc$IZZ    @
    .rtc$TAA    H
    .rtc$TZZ    P
 @i .xdata  \   .xdata$x     l    .edata  l    .idata$2    m    .idata$3    m 
  .idata$4    x b&  .idata$6      Y  .data    P  .data$r 0J  )  .bss      $o  .pdata    <   .gfids$y          .tls         .tls$        .tls$ZZZ         _RDATA     `   .rsrc$01    `     .rsrc$02                                         20
 
4 
2p B   R0
 b  ^ 
     p  * d 4 pB 
 r   0J               Q         2P1	 T 4  p`  B Ȇ
    `J     J             &     
        2  	p`0PB 
   J     J J    J J    J    J    K    K P                    z                  [!     !     !     h#     #  
 
4 
Rp d	 4 Rp 4 R
p`P^ x
  K     ,K    <K    LK    \K    lK    X    X         %  7%      \%     t%     %     %     %     %     %     %     &     &   d T 4 2 T 4 2`% %t !d T 4 
	^ P
 K  '  $(      {(  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 Rp^ (
 K     K     X X     `.  .      .     .     .      /     /   4 Rp^  
     /   0B ؅
 J   K     0  0      0   0B 
 J       1  1      1   0B 
 J       2  2      2   0B `
 J       p3  3      3   0B 8
 J       `4  4      4   d T 4 p^ 
 K     P8  8      8  8      9   d T 4 p^ 
 K     `9  9      9  9      -:   d T 4 p^ 
     p:  :      :  :      =;   d T 4 p^ 
     ;  ;      ;  ;      M<   4 p^ p
  L     <  <      <   4 p^ H
     0=  f=      =   d	 T R( (d $T  4 
p^  
 0L     @  @      $ 	0 0  B 
 r  `L     lL B  :C      zC     C  m md
 h4 
rp 4
 rp^ Ѓ
 L     L    L    L    L     PF  F      F     
G     G     +G     aG  ! t K  K  P
 !   K  K  P
  h r0^ 
 L L  
M      M      
4	 
2pXB    * *x h r0 Rp`P0 t d
 4	 R^ 
 L  U  wU      U   h d 4
 rp^ X
 L     U  :V      eV   h d 4
 rp^ 0
  M     V  V      W   t d
 4	 R^ 
     X  gX      X   h d 4 rp^ 
     X  Y      BY   h d 4 rp^ 
     Y  'Z      RZ   t d
 4	 R^ 
     [  [      \   h d 4
 rp^ h
     0\  \      \   h d 4
 rp^ @
     \  []      ]   d
 4	 Rp^ 
 0^  ^      ^   4 
p	`P^ 
 M p_  _      =`  * 0 p`0P  B ȁ
 r   M     NM `M    lM p`  `      `     a     a     + / B 
 b  M     M     b  b      b     =c  . d1 40 . p  B x
 b  @c  c      c     c  . 0 p`
0  B P
 r       d  bd      d     >e   h b  +
 +h &4 
p`P^ (
 M M    M    M     h  i      i     i     ij     rj   t 4 P' 't# #d" 4!  P  ^  
 M M    M     k  )l      l     m     n     n    p  !  
T 4 n  o  0  ! d o  jo  <  !   o  jo  <  !   n  o  0  !     T  4 n  o  0  " "h 	p`0P^ ؀
     pp  p      6q     Eq     q     q  ' 't #d 4  P  ^ 
 N     s  Ys      t   p! 4 `u  u  @ ! d u  u  H !   u  u  H !   `u  u  @  d
 4	 Rp^ 
 v  w      Jw   4	 
Rp^ `
  N     w  x      x   4 Rp^ 8
 0N     x  Ay      Ry  *
 *x &h "42 , 
p`P  ^ 
 @N     LN    XN    dN    pN    |N           N         py  y      y     z     z     A{     {     |     H}     T}     `}     j}      u}  6
 6x h d 4 rp( d 4
 pB 
 J   N N     ~  ~        *     ـ   d 4 2p 0B 
 J                   d T 4
 rp^ 
 N             N  8	 'x8 #h9 4v t P  B p
 r  N     N    N    N     O    O    O    $O    0O                          P     ^     Ȇ          (                    F     w               a     u             6	 %x8 !h9 t p0P  B H
 r  @O     LO     XO    dO    pO    |O    O    O     @                   a          ڋ                                                    :   4 Rp`P^  
 O O    O    O    O Ў  	      '     7     S     g       $
 $T 4 R
	p`^ ~
 O O    P    P    (P    4P                   7     S     o       0
 !4 
p`PB ~
 j   PP     \P hP    tP                ۑ           m      x                    &     2     =  X     f  R
 R T
 4	 2p`$
 $T 4
 R
	p`^ ~
 P     P     P З        #     q     ͘   4 p`P!    R  8 !     R  8 ;
 -t7 )d6 %44 . 
P  B ~
 b  P P    P    P 
Q    Q         0          H     c               4     C       
     &  ! t p    P
 !   t p    P
 
 d T
 4 2p$ 	 0  B X~
               Q    Q    Q    Q               	 	   9    0Q 8   p         )  0Q     =Q    RQ    fQ    Q    
 
2P^ X~
 "  B 0~
               R    R    R    R               
 	   9 x    R 8         7      =   R     
R    "R    6R    R    
 
2P^ 0~
 , h	 	 0  B ~
               ZS    fS    fS    rS               P 	   9 x   R 8               `          R     R    R    R    CS    
 
2P^ ~
 
 h 4 R
p`P
 
4 
2p R! t d 4	 `     !" "T
       !        !     T
      !         !     t  d  4	 `      RP!  t 4	    g  | !# #d
  g     !   g     !     d
 g     !    g     !       t  4	    g  | ! t   <  P
 ! d <  o  
 !   <  o  
 !   t   <  P
 !   t  d   <  P
 
 
B0P  ! t
 d	    j  x
 !9 9  t
  d	    j  x
 !     t
  d	    j  x
 ! 4	     | !  t 	d
  4	     | $ 	 0  B }
            S    S        T    T    T    T    T    T        	       	   6 H   S H             o                &  S     S    S    T    T     T    |T 	    BP0  ^ }
 :
 ,t9 (d8 $47 0 
P  B }
 r  T     T    T    T    U    U    ,U    8U    DU    PU 	   \U    hU    tU    U 
   U         P             Ӹ                     B     u          ι  	   ޹  
     	        Ļ               	     S  
   a     z  
                    	   "     h     r   	  d* T) 4( & p  ^ }
 U   Ǿ      J  $ $d0  T/ 4. * p  ^ h}
 U U    U     п        g          Y       - " p`0  B @}
   U     U            V    !V    -V    9V    EV            W    W    W              	   B    QV X             &      @     \      d                         <     e          a                     _V    V 	   V    V 
   V    ]W    nW     bP0  ^ @}
 , # p`0B }
   W            X    %X    1X    =X    IX    UX    UX         	   Y 	   Y 	   Y             d 	   B    aX X                        8     m                                             |           oX 	   X 
   X 	   X    Y 	   mY    ~Y 	    bP0  ^ }
 "  B |
               Z                	   X     Z H              Z     
Z    ;Z    JZ    
 
RP^ |
   B |
 {              N[                 	   X p   Z 8                 Z     Z    Z    Z    
 
2P^ |
 *
 * x h 
4 
p( d
 4 rpB |
 2   `[        S        7	 &dv "4u p pP  B x|
 r  p[     |[ [ [ [ [    [ [ [ [ 	   [ 
   [     \               U      l     z               )     :                        1         M     ^  w  	     
        ?     P     ]  
   q  	      4
 p^ P|
 \       E      [   Bp0  !  

 T p     ! d	   S   !     S   !   p      4 
	p`^ (|
  \     ,\     8\                       |   d 4 p6 (t3 $d2  40 , P  B  |
 R  P\ \\    h\ p          J                  4
 p^ {
               
 
4 
 p  ! d 0     !   0     ) t 4
 	PB {
 J   \ \ \ \ \ \ \                   r                          -         7     E  & &4/ * p`P  ^ {
 \     p  l      s   d
 T 4 rp+
 +h &4 
p`P^ `{
 \ \    ]     P             +            ! !d
 4 R
p^ 8{
  ]     ,]       d           -      5   4 
r	p`^ {
 @]     L] P                T 4 p` 4 p`P! h     l !       l !       !        & &d "4  	pP  ^ z
 `] l]    x]    ]                                & &d "4  	pP  ^ z
              
                       4 
p`P!    *   !     *    t d 4 P
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T      !        &	 &d "4  	pP  ^ z
 ]     ]                           4 
Rp^ pz
 ]                d 4
 
Rp^ Hz
 ] @           4 
Rp^  z
        &      =   4 
Rp^ y
 ]     `           4 
Rp^ y
               " "h 	p`0P^ y
        U                y    }  	p`P0^ y
 ]     ]                  4 
r	p`^ Xy
       G    H  t d 4 %
 %h t d 4 P"	 "d 4  pP  ^ 0y
  ^ ^    ^    $^      %	     	    	    |
    
    
 "	 "d 4  pP  ^ y
 
 
             9    J    U  d 4 pP' 'h
 #T# 4"  	p`  ^ x
 0^ ` 5     P  4 
Rp^ x
     p        d 4
 
Rp^ x
        \  4 
Rp^ hx
     p        4 
Rp^ @x
           
  4 
Rp^ x
     0 V     j    )	 
	p`P0  B w
 b   @^     L^    X^    d^    p^    |^    ^    ^    ^    ^ 	   ^ 
   ^               c    v             	    
       %    B    ]    f     o  
R0^ w
 ^     ^           B   4
 
Rp^ w
 _     _    ,_    8_     P  n                       # 4
 pB xw
 J   . .     . 6 (4   
p`P  B Pw
    P_     v_    _    _         / /     z0    H2    U2    3    3    )3     3    3     = ,4C 8 
p`P  B (w
   _     _     _    _    _    _    _    _         04 4     4    5     @6    w6    6    6    6    57    ]7    7    7    k;     4	 
Rp^  w
  `     ; ;     !<  4	 
Rp^ v
     0< p<     <  4	 
Rp^ v
     <  =     A=  4	 
Rp^ v
     = =     >  4	 
Rp^ `v
      ? `?     ?  R0^ 8v
 X A A     A  4 Rp^ v
     A 2B     MB  R0^ u
 pB B     B  4 Rp^ u
     B C     -C  
R0^ u
 `     `    ,`    <`    L`    _`    r`    `    `    ` @D qD     D    D    D    D    D    D    D    E    E 	   E =
 +h# &dQ "4P H 
p  B pu
 #  `     `           `    `    `    `    a    a     a 	   ,a 
   8a    Da    Pa 
   \a    ha    ta    a    a    a    a    a    a    a    a    a    a    a    b    b    b    (b    4b    @b !   Lb "   Xb #   db    pb    |b &   b '   b (   b    b    b    b ,   b -   b .   b    b     c    c 2   c 3   $c 4   0c    <c    Hc 7   Tc 8   `c 9   lc    xc    c <   c =   c >   c    c    c A   c B   c C   c    c    c    d        H   Dd    G   I       * 	   B    d H               0E E     E    E    E    F    QF    \F    F    F    )G    G    HH    H    I    NI 	   I 
   I    I 
   I 	   I    I    GJ    J    K 
   9K    pK    K    K    K    K 
   K    L    L    N    7N    lN    {N    N    N    N    N    O    O    P    'Q    \Q    kQ    Q    Q    Q    Q    R    R    S    T    GT    RT    xT    T    T    T    U     WU    U !   V "   DV #   SV $   yV #   V "   V !   V    W %   W    X &   *Y '   eY (   xY )   Y (   Y '   Y &   Y    LZ *   Z    Z +   ?[    \ ,   \ -   ] .   !] /   G] .   p] -   ~] ,   ]    ] 0   ]    6^ 1   ^    _ 2   _ 3   _ 4   	` 5   /` 4   X` 3   f` 2   t`    ` 6   a    ua 7   a 8   a 9   a :    b 9   Ib 8   Wb 7   eb    b ;   c    zc <   c =   c >   c ?   #d >   .d =   <d <   Jd    d @   d    e A   e B   e C   f D   .f C   9f B   Gf A   Uf    f E   f    Bh F   oh    h G   h    Bi     Mi d     !d H   .d I   
 
RP^ pu
 9 'h( R 
p`0  B Hu
 s  Pd \d    hd    td    d    d    d    d    d    d                  Se    _e    ke    we    e    e    e    e                  >f    Jf    Vf    bf    nf    zf    f    f    f                   5g !   Ag    Mg    Yg    eg %   qg &   }g '   g               *   *h +   6h    Bh    Nh    Zh /   fh 0   rh 1   ~h    h 3       3       5   +i 6   7i 
   
   
      41             H1       "      \1 )   )   ,      p1 4   4   7      1 	   B 8  d H   	   B 0  e H   	   B   f H   	   B (  g H   	   B    h H           k l     :l    Jl    [l    l    l    m    0n    n     o    7o    Eo 	   ko    o    o    o    o 
   o    p    0p    p    <q    q    q    q    q    "r    Wr    er    sr    r    r    r    r    s    s    Ut    t    t    t    t    0u    >u    Lu    u    u    u    v #   0v    v $   <w    w %   w &    x '   x (   4x '   ix &   wx %   x    x )   x    x -   y    y .   z    }z /   z 0   z 1   	{ 2   /{ 1   d{ 0   r{ /   {    { 3   { 4   | 3   0|    M|    j|    |    | d     d    e    0e 
   e     e    e    f    f     f     f !   g "   g     g *   g +   h ,   h     h 5   h 6   i 7   
 
RP^ Hu
 .  t d 4 	PB  u
 J   Pi \i hi ti i i i i i         | B}     } l~     G    T                ;    H x          $
 $t d 4
 
rP^ t
  1     0 ?
 .tC *dB &4@ : 
P  B t
   i     i     i     i     i     i     j     j      j     ,j     8j     Dj     Pj     \j     hj     tj     j     j     j             p ȇ    ه              `    n                       G    S         ǉ                	   .     l 
   x                       0 
   >     |                           0    >     |          < +tC 'dB #4@ < P  B t
   j     j     j     j     j     j     j     k     k     k     (k                                                                  -    >     ^    j     ō    Ӎ              p    ~              %    3     S    _      	        ܏ 
           4	 
Rp^ t
 @k     Pk    `k    pk      	         !    -      d 4
 
Rp^ Xt
 k     k           \  
R0^ 0t
 k Ж        ^ t
                       : 	   B 8   k H          k     k    
 
RP^ t
 3	 < 	p`0P  B s
   ll     0l    <l    Hl    Tl    `l           И    ޘ         [                F    b     9 (h $4D < 
p`P  B s
   l     l    l    l    l    l           (        ڛ        0    Z    o            ۜ      & 6 p`0  B s
   l     m    "m     .m     P          /                   
R0^ hs
         
R0^ @s
 P f        d 4  p  ^ s
 Xm     @m    Lm      ɟ     ߟ            3     * *d %T  4
 R
p^ r
 m     m    m    m    m    m    m    n    n     `                   ١                5     0
 "d 4 	pPB r
 j   @n     Ln    Xn               9        ;     d # #h 4 Rp 
4 
pXB `    4
 Rp^ r
 pn n 0       ̰    ڰ # #t
 d 4 r^ xr
               `? @           n X       0      ȳ n     n     bP0  ^ xr
  4 2! d t `  ? !   t `  ? !   `  ?  d 4 2! t  N ? !    N ? ! d   8 
 !     8 
  d 4 
rp^ Pr
               @ @            o X        ]     p  o     .o     bP0  ^ Pr
  4
 Rp^ (r
 @             2p! 4  I A !    I A  R0^  r
       4 Rp^ q
             4	 Rp^ q
     P o       d T 4 2p d
 4	 Rp 4 Rp^ q
   ?     h  4	 Rp^ `q
             4
 Rp^ 8q
      6     k       d 4 
rp^ q
               B @           o X          o     o     bP0  ^ q
 ! d   
 !     
  d 4 
rp^ p
               DC @           o X   `       o     o     bP0  ^ p
 ! d   
 !     
 ! d t  q ? !   t  q ? !    q ? ! t 0  ? !   0  ? ! d    
 !      
  4 Rp^ p
   t	 d 4 2 d	 T 4 2p0	 "d 4  pP  B p
    Pp            ! t  > P
 !   t  > P
 0	 "d 4  pP  B pp
        ` r       R0^ Hp
 P  R
p`0^  p
 `p     p    p                   Q  4	 Rp^ o
 p     p     `            4	 Rp^ o
 p     q                P  0  ! t `  0F !   `  0F + +d 4 p   BP0  ! t	  V lF !  

 d  t	  V lF !   
  t	  V lF 
 b  ^ o
            #	 p
`P0  ^ o
 0q       ,  d 4 
rp^ Xo
               \G @           @q X           @q     Nq     bP0  ^ Xo
 " "d
 T 4 
rp^ 0o
 q     q    q p          /    <     ! !d 4
 r
p^ o
               @H @           q X              q     q     bP0  ^ o
  T 4
 2
`! 	 t  T H !    T H ! 	 t p 4 H !   p 4 H  4	 Rp^ n
             4	 Rp^ n
            
 b  ^ n
   R0^ hn
  	 '	     f	 >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pPB @n
 b   Pr  2       2p`0 4
 rp^ n
 `r X P            
4 
pXB H    4	 Rp^ m
 pr @ `      
 t d
 T	 4 R
 	 T d 4
 Rp 4
 Rp^ m
     ( X)     c) )    )  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b  ^ m
     : ! bp`0  ^ xm
                                     HL             \L @           r 8   @           r H    ; ;     ; r     r    r    r     r    
 
2P^ xm
  BP0  ^ xm
 
  ` St
 6 
B`P0   T 4 2`! t @ @ L !   @ @ L  4  d T 2p! 4 E 2E 0M !   E 2E 0M !   4 E 2E 0M ! 4 @G bG 0M !   @G bG 0M !   4 @G bG 0M $
 $d  4 r
p^ Pm
 Ps \s               X    X             N @           hs 8           I RJ     J    J    4K    aK    uK    K hs     us    s     
 
2P^ Pm
 $
 $d  4 r
p^ (m
 s s               X    X             N @           s 8   K FL     |L    L    3M    sM    M    M s     s    s     
 
2P^ (m
 $
 $d  4 r
p^  m
 s s               X    X             O @           t 8   M mN     N    N    bO    O    O    O t     t    2t     
 
2P^  m
  T	 4 2! t d P P XP !   P P XP / 1 	p`0PB l
 r  Q Q     R    JR    R    ' - p`P0B l
 R  @t     Lt     S `S     S    S  4 R
p`P^ l
 `t lt    xt    t    t    t             pT T     T    U    /U    SU    oU    U  d
 4 
rp^ `l
 t t               X             R @           t 8           pV V     V    V    W    1W    lW t     t    t     
 
2P^ `l
 
   ^ 8l
  u W W     W " "d T
 4	 
Rp^ l
 u     W X      4	 
Rp^ k
      Y >Y      4" 	  p  ^ k
 @u     Lu              Z QZ     tZ    ! 	0B k
 r       Z [     [  	 0  XB    $	 $4  
p`P  ^ pk
 `u      ] f]     ^^   0  ^ Hk
 pu     |u |u     ^ ^     ^    _ _    _ & , p`0  B  k
 R      _ `     u`    ` 6 (d8 $47 0 	pP  B j
 r  u     u    u u    u ` a     a    a    b    b    b ' - p`P0B j
 R       c Qc     c    c 
   ^ j
               U @            v H    g 
g     .g 0g     
 
RP^ j
 
   ^ j
               U @            v H   @g Mg     ng pg     
 
RP^ j
 
   ^ Xj
               TV @           @v H   g g     g g     
 
RP^ Xj
 
   ^ 0j
               V @           `v H   g g     g g     
 
RP^ 0j
 
   ^ j
               $W @           v H    h 
h     .h 0h     
 
RP^ j
 
   ^ i
               W @           v H   @h Mh     nh ph     
 
RP^ i
 
   ^ i
               W @           v H   h h     h h     
 
RP^ i
 
   ^ i
               \X @           v H   h h     h h     
 
RP^ i
 
   ^ hi
               X @            w H    i 
i     .i 0i     
 
RP^ hi
 
   ^ @i
               ,Y @            w H   @i Mi     ni pi     
 
RP^ @i
 
   ^ i
               Y @           @w H   i i     i i     
 
RP^ i
 
   ^ h
               Y @           `w H   i i     i i     
 
RP^ h
 
   ^ h
               dZ @           w H    j 
j     .j 0j     
 
RP^ h
 
 
t 4 1	  
p`0  B h
           w    w     w    w    w    w    w    
x    x    -x 
   9x    Ex    vx 
   x    x    x    x    x    x    x    y        Dy              [ 	   B    y X   k qk     k    k    m    m    n    9n    n    p    'p    wp    p    p     q    -q    Oq 
   q    q    q    (r    Ur    wr    r 	   r 
   %s    Vs    Ft    st     $y    1y    
 
rP^ h
  t d
 T	 R! 4 t 1u \ !   t 1u \ $ $d  T 4 
p^ xh
     u v     Gv F 5u 0xv ,hw  
	p`0PB Ph
 B  Py     \y    hy    ty    y    y    y    y    y    y 	   y 	   y    y    y 
    z    z    z    $z    0z    <z    Hz    Tz    `z    lz    xz    z    z    z    z    z    z    z    z    z !   z "   z w x      x    -x    :x    Gx    z    
{    q{ 	   { 
   { 	   |    -|    _| 
   |    } 
   %}    U}    I                                                b                    $            ̏    D    s    Ԑ        O    \    i                 ے     !    "   z #    "    !   	    f     	       ߕ             % %h !t d 4 
	^ (h
          {    {                  ` 	   B P   { H               P                       n {     %{    
 
RP^ (h
 % %h !t d 4 
	^  h
         @{    L{                  a 	   B P   X{ H                ј         1    F    E      X{     e{    
 
RP^  h
 ) )h %t !d 4 
	^ g
 {     {                             b    B P   { H                2     ś         R    x {     {    
 
RP^ g
 ) )h %t !d 4 
	^ g
 {     {                             Hc    B P   { H         b                   {     {    
 
RP^ g
 B B& =' 8x( 4h) %T p`0  ^ g
  | | |    $|    0|    <|    H|    T|           `| 	   l| 
   x|    |    |    |           |             |d 	   B H  | x   P            ¢    7    I                w            G 	    
   ì        j 
   x                  ] 
    	   ǳ             K      
    	       3    P    h |     |    |    
 
P^ g
 ' d 4 pB `g
 Z   |     }           8         ! 
	p`0P^ 8g
 <}     0}    e}    q}    }}    }             p                               0    ?    D          d 4
 2
p! T	 p : f !   p : f  4 rp`P^ g
 }       ݽ  d
 4 rp^ f
 }   *       
4 
pXB @   ! 4   d
 !     d
 !   4   d
 	 	2`0! 
 t	 T P i g !   P i g !   
  t	  T P i g  
R0^ f
 } p        d 4
 
Rp^ f
   N       d T
 4	 Rp^ pf
                 H  4 Rp^ Hf
            / !t3 42 0 P  B  f
 r  @          !    <    i     / !t3 42 0 P  B e
 r   :     V                
  b  ! t 4 0 H i !   0 H i !   t  4 0 H i  R0^ e
         
 ^ e
  ~  D       R0^ e
 P~         R0^ Xe
   a     |  R0^ 0e
        # #t
 d 4 r^ e
                k @           p~ X       0       p~     ~~     bP0  ^ e
  d 4  p  ^ d
 ~          -         0    G    ]    `  4 R
p^ d
 @     n         @                4 Rp^ d
       N     i    ^ hd
   u      " "d 4	 Rp^ @d
       `             t T
 4	 R`2	  d 4  p  B d
                  m @            H   P                 BP0  ^ d
 f
 fd <t 	 4 2% %4 p`^ c
               m @             X                    .     bP0  ^ c
 ' / p`P0B c
 b        ^     . 4S N p`P  B c
 b  `     l    x      -     \    j        & : : &  x 	h   / 1 	p`0PB xc
 r                J          h 0!  x   o !      o !     x   o . 4S N p`P  B Pc
 b      0              8     * 0 p`0P  B (c
 r   	     (    b        ] ] U  
	p`0P! h
 P  o !   P  o    ^  c
   A     $ 	, 0  B b
 R  P          1 @
 /t[ +dY '4X R 
P  B b
            Ѐ ހ            '    9    G    S     P v                 c    u                z 	    &
 &d
 !T 4 R
p^ b
 `  W      * 0 p`0P  B `b
 r  0              M    , ,4)  
p`P  ^ 8b
 p     |                X    X     ʁ    ց     	       /    X     X X                   5                         \    k         	    
   A    X    r                4      
              , ,4)  
p`P  ^ b
 @     L    v            X    X              	   ҂        X     X X                o                )    =    S    p            !    0 	   F 
                       O          
             '    d 4 p^ a
  P       
 
r0
 
4
 
rp= ,4= 2 
p`P  B a
         ,    Z    l     z          2                     z	    
          (    D 6 (4   
p`P  B a
                            
    
     
  
0^ pa
 ܃     Ѓ  &     :    m     L :c 2d -e (xf $hg  
p`0  B Ha
 #                  (           !    -    9    E    Q    ] 
   i    u     
                      	      lw 	   B    4 h                 )    E    x 
                
   "     
       e    ]            l         
            - 4     B    v        ф        @    Q             	             P0  ^ Ha
 A 0x ,h (4<2
p`P  B  a
 b	       ̆    ؆                        '    3    ? 
   K    W    c    o    {                        Ç    χ                                   "            M         	   ^     
       c 
   }        +     
   "    K#    #    #    #    p$    $    $    $    %    %    &    &    :&    K&    l&    &    &    &    &    &    &    '    0'     Y' A 0x ,h (4@6
p`P  B `
 	                       #    /    ;    G    S    _ 
   k    w                            ˈ    ׈         ' (     (    (    (    =)    B)    )    )    *    *    * 	   ,    , 
   ,    - 
   -    J.    [.    
/ 
   2    {3    3    3    3    4    4    5    5    5    5    66    G6    j6    {6    6    6    6    6    6    7    -7    F7    `7     7 / /h +/ 't. #d- 4, ( P  ^ `
               $    0    <    H     7 8     8    8    9    I9    9    9    :    ;    ;    ;    ;     1< "	 "d( T' 4& $ p  ^ `
 ` `< <     r= "	 "d. T- 4, * p  ^ `
 p = =     $? "	 "d( T' 4& $ p  ^ X`
 P? ?     b@ "	 "d. T- 4, * p  ^ 0`
 @ @     B #	 #t3 d2 41 . P  ^ `
               @B +C     nC    C    
D    D    D     E 1
 1x -h )tC %dB !4A > P  ^ _
          ȉ    ԉ         0E /F     rF    F    bG    xH    H     H "	 "d( T' 4& $ p  ^ _
  I <I     J "	 "d. T- 4, * p  ^ _
 @J |J     K "	 "d( T' 4& $ p  ^ h_
 K ,L     M "	 "d. T- 4, * p  ^ @_
 0M lM     N #	 #d4 43 . pP  ^ _
               N O     P    vP    P    YQ    Q     Q 0
 0x ,h (dB $4A < pP  ^ ^
          (    4         Q R     S    yS    S    U    KU     fU 7
 )h %42 ( 
p`P  B ^
 "  @     L    X    d    p    |     U }V     V    V    V    oX    Y    Y    #Z    /Z    kZ     Z 7
 )h %42 ( 
p`P  B ^
 "      Z [     [    [    
\    ]    3^    ^    S_    __    _     _ <
 *hs &d "4  
p  B x^
 #                       ̊    ؊         	    
    
    
     
   , 
   8    D 
   P    \ 
   h    t                        x 	   B    x       _ w`     ` `    ` `    xa    c    c    d    e    df    )g 	   g 
   h    h 
   ci    ti 
   Gm 
   m    n 
   En    n    o 
   <o    o    o 
   +p    vp    p 
   }r 	   r    r    s    Qs    s    s    s              
 
P^ x^
 <
 *hs &d "4  
p  B P^
 #   ̋ ؋                                   	     
   , 
   8 
   D 
   P 
   \    h 
   t     
                  Ԍ              	   B    x               0t t     t 
u    u ;u    u    w    x    y    iz 	   &{ 
   |    -| 
   |    | 
    
   Ѐ    E 
   |    ǁ    < 
   u        5 
   e        % 
   Ʌ 	       3    h        ̆                      
 
P^ P^
 @ .xc *hd &d "4  
p  B (^
 #                      )    ;    I    U    a     	               ʍ 
       
        '    3    d    v                Ɏ              T 	   B     X                 D            ?                    E 
   g        ׍        @    m     	   ߎ 
       7    h                '    _            <             
 
rP^ (^
 @ @ ; 6x 2h %> p`0  ^  ^
                         4               	   B     X                 (    Ӓ    p            $             
 
rP^  ^
  4 2p!
 
d T  Ә p !    Ә p !   d  T  Ә p $ Rp`0^ ]
                @           @ 8         # @     M    
 
2P^ ]
 $ Rp`0^ ]
               X @           p 8       0      Ú p     }    
 
2P^ ]
  2
p!
 
d 4 К ޚ  !   К ޚ  !   d  4 К ޚ  !
 
d 4    !      !   d  4    !
 
d 4    !      !   d  4     R
p`0^ ]
                            @            8        ؝                    ɏ    
 
2P^ ]
 !
 
d T  # p !    # p !   d  T  # p / 1 	p`0PB `]
 r             ڟ    C    ) , p`P0  B 8]
 R             ,           Q        2	  44 , p`P  B ]
 R       Y     x            	 t d T 4    d 4 
p  !
 
 T   h !     h     zx dh &% p`P0!  
 0 Ш  !  	 	
 Ш  Џ !   Ш  Џ !   0 Ш   	  0  ^ \
 @     L                   ͽ     
R0^ \
         d 4
 
Rp^ \
  ^       
R0^ p\
  )     o  
R0^ H\
        / !t3 42 0 P  B  \
 r   G     c                 =
 ,hP (4  
p`P  B [
   ` l    x                             	               ) 
   5 
   A     @      '             f                2                 	    
   -    r         
   W    
 
   s     
                       $ =
 ,hP (4  
p`P  B [
       p      W         )                ;    b                 	   J 
   ]             
       = 
        
                   8    T 
 
d	 
Rp! 4   0 !     0 .  t d 4 	PB [
 J   P \ h 0      1     ]      < < 7x
 3h /t' +d& '4$  
P  ^ [
       `     K , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t  - h !    - h  d 4 p^ X[
  @ t      	 	 0      d 4 p h d
 4	 Rp.  t d 4 	PB 0[
 J      đ Б                B         * Z    g      ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P  ^ [
                          (    4    @    L                                   J         	   G                    "    J    i      / / *x &h % 
	p`0P^ Z
 `     l       :     ?          / / *x &h % 
	p`0P^ Z
                  w      ( (d $T  4 
p^ Z
             0^ hZ
 	 	     h
  R0^ @Z
 
 
     
  R0^ Z
 
 E     `  0^ Y
 p      H  R0^ Y
 `        R0^ Y
  %
     @
  
 ^ xY
 P
 
     
  R0^ PY
 
         R0^ (Y
 @        0XB `   ! t   X !     X " "d 4	 Rp^  Y
     0 t             ^ X
 P       { j7 b8 Z9 R: J; B< := 2> -x? )h@  
	p`0PB X
 b           Ȓ    Ԓ                            ( 
   4 
   @    L 
   }                        ͓    ٓ      V     g            H    {            0    P    ]                2 	   ?    Z     
       " 
   E    Q 
   f     
       T    q        "    "    W"    h"    u"    "    
#    #    W#    h#    #    #     # :
 (xT $hU  
p`0  B X
 3               )    5    A           M    ~ 	                
                          G    S    _    k    w                          ƕ    ҕ    ޕ                                  Ğ             ؞ 	   X    X   	   X     X   	   X (   X       `$ @%     R% %    & !&    7&    &    .'    c'    '    D(    (    (    ( 
   (    6)    X)    )    )    *    <* 	   * 
   *    +    O+    +    +    	,    H,    ,    ,    ,    ,    c-    -    -    .    +.    H.    p.    .    .    /    /    /    0    0    0    0    
1     1    N1    k1      	         ,    9              
 
rP^ X
 { j: b; Z< R= J> B? :@ 2A -xB )hC  
	p`0PB `X
            (    4    @    L    X    d    p    |     
    
        
   ݖ            	        !    -    9             1 &3     73    3    3    4    K4    \4    4     5     6    -6    p6    6    6    7 	   )7    D7    7 
   7    #8 
   I8    U8 
   j8    9 
   :    E:    _:    <    >    >    6?    G?    T?    ?    ?    ?    6@    G@    g@    @     @ :
 (xW $hX  
p`0  B 8X
 c  P         }                           ޗ 	           
     
   G    Y    g    s                       ˘    ט                          &    2    >    J                                       Ф 	   X H  \ X   	   X P   X   	   X X   X               @A B     /B B    B B    C    C    D    CD    D    $E    |E    E    E 
   E    F    5F    F    F    F    G 	   iG 
   G    G    ,H    H    H    H    $I    I    I    I    I    OJ    J    J    J    J    J    XK    L    L    (L    ~L    M    M    (M    yM    M    M    M \     i                           
 
rP^ 8X
   
p`0  ^ X
                	   B 8   ` H    O  O     VO `     m         
 
RP^ X
  0. h 42 . p  B W
 R         R ?R     tR    R     R = = 8 3x /h +4> 8 p`P  ^ W
  ̙    ؙ                                 0S V     V    V    zW    X    4X    X    Y    Z    [    [    [    [  p`0^ W
               Ȩ @             8        \ g\     \       -    
 
2P^ W
  4
 
Rp^ pW
 P     `    p                             ] (]     0]    8]    @]    H]    P]    p]    A^  0+
 +t# 'd" #4!  
P  ^ HW
 К 0_ r_     <c 4 4 /	 *x
 &h "d 4  pP  ^  W
  c d     d  d 4 p^ V
   g _g     h > > 9 4x 0h ,5 (t4 $d3  42 . P  ^ V
             @h h     k    ok    Yl     l  4	 Rp^ V
 0     Z     l m     m    cm  4	 Rp^ V
 p          m m     m    n " "d 4	 Rp^ XV
      ڛ 0n tn     n    n # #t
 d 4 r^ 0V
                @            H       n %o     Bo          
 
RP^ 0V
 ' 'x h 	   4 r
p`P!  p .q x !   p .q x ! h q r  !   q r  ( (h $d  T 4 
p^ V
 `s s     Ju D 2 - (x  $h! D 
p`0  B U
               (    Y    k    y                     	   X    H       u bv     v    /w    \w    }w    w    w    x    ky    
z          Μ     
 
RP^ U
 D 2 - (x $h  B 
p`0  B U
                   )    ;    I                     	   X   U H       `z z     {    {    {    {    M|    l|    w}    }    @~ U     b         
 
RP^ U
 & 4 p`PB U
 J       ~ ~     ~          &      3    A 
 t	 d T 4 2
 
4 
2`! t    !         ^ hU
        ! t   P
 !     P
 ! t  % P
 !    % P
 ( (h $d  4 
p^ @U
                	   B 8    X        )     N                bP0  ^ @U
 ! t  ȋ P
 !    ȋ P
  4 R
p`P^ U
      (    4    D    P                   ?    X    t             	 	2P0! 
 t	 d Ѝ  б !   Ѝ  б  4	 2`! t p Î  !   p Î  / 1 	p`0PB T
 r             ڏ    A    !  x  d o !     d o !     x  d o )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '       ! h	  v  !    v  !       , 42 	0 p  B T
 r  0          ޠ    T    = = *  x h   " 1 B T
 r  0 u         ̣    J    % %4) %  p`P  !& & 
 x h      !        !     
  x  h        ^ xT
 `               0 0h ,4  p
`P^ PT
 p     |                               6           Ʃ                O    ]                %      <
 *x %h 
p`0  B (T
        	        !    -    9    j    |                   
   a    m     
                         d    p    |                ƣ    ң    ޣ                          ͤ    ٤             #   	 $    $   ! $   -    9    E )   Q 	   	         8             L             t 	   B     X      X   ʠ X      B     X   	   B    X           P      #    ;    "        Բ        G    e 	                    
   0    N        F    X                        .    @    N    b    m        i    {         Ѹ     !   '    H    e                 "       # #   q $    %     $   a &   s $    '   ƻ $   Ի #           )    E    a            ^ (   p     )   H *   Z )   h        6      
   :    K 
   ʠ     ؠ    N    _            7    H    U                 {                          bP0  ^ (T
 B 1xS -hT )4  
p`P  B  T
 "  `     l    x                            ̥ 	   إ 	           ' 	   5    A                       f    -    J            "            q         	   < 
   Y 	   4    K     
               ? 	                     3 3( .x) *h* &d^ "4] V 
p  ^ S
 P                   \           h    t                	    
            
   Ȧ 
   Ԧ 
              
              
              
                                      $ 	   B `   x           P     3    E                         	    
   R         
        
   8    I 
   n         
   
 	   B    a                       
 
P^ S
 @ @
 ; 6x 2h ## p`0^ S
       ,    8    D    P    \    h                               B    t H                j     y            Y    x        '                 6                 '    3    ?      t              
 
RP^ S
  d 4
 rp^ S
  `        T 4 	p`^ `S
          ȧ      ;     I    n              D Dx @h <4> /6 !p`P  ^ 8S
          & 4 @     @ [     v             S    _ $ $h d> 4= 8 p  ^ S
 P     \    h                                   ` 	   X   t                       F    W        C        s              
         8 t     
 
P^ S
 :
 (x* $h+ X 
p`0  B R
            Ȩ                                        	   X   Ԩ        `              =            @        m    y                Ԩ     
 
P^ R
 $ $h d< 4; 6 p  ^ R
       ,    8                  _    k              	   X   D                      V    _        -    |    `                       % D     
 
P^ R
 :
 (x( $h) T 
p`0  B R
 {                                 ˩    ש              	   X p          P                          
        :    F     h l    x           
 
P^ R
 : : 5h 142 %( p`P  ^ pR
                 [         <    U        i <
 * %h 0 
p`0  B HR
 S                    ,    8 8                	   B (                    A     ! J         q     a       .    e    }    ۪              P0  ^ HR
 . .x )h $t?  d> 4= 8 	  ^  R
 P     \    h                                    	   X   t              %            E    4                        t     
 
P^  R
 :
 (x* $h+ X 
p`0  B Q
            ȫ                                        	   X   ԫ        0 |             	    	    	    
        F    R     t x          ԫ     
 
P^ Q
 )
 )x $h d> 4= 8 p  ^ Q
       ,    8                  _    k              	   X   D             
     0    9            F    5                        D     
 
P^ Q
 :
 (x( $h) T 
p`0  B Q
 {                                 ˬ    ׬              	   X p          0 |                                 %    1     S W    c           
 
P^ Q
 <
 * %h 0 
p`0  B Q
 S             ح                            	   B (                   Q     1 Z    '        q          5    M            ɭ      P0  ^ Q
 <
 *hh &d "4  
p  B XQ
 s           ,    8    D    u                 	   ޮ 
           
        G    Y    g    s            ¯    Я    ܯ                      	   B     H                             p               !    :!    k!    !    !    
"    *"    b"    "    " 	   " 
   2#    R#    # 
   #    #    $    [$    {$    $    $    $    %                 
 
RP^ XQ
 4 4h! %D p`0  ^ 0Q
 0        <    H    T                      	   B    ` X               & H'     a'    '    D(    (    d)    +    ,    `     m    z    
 
rP^ 0Q
  d 4
 p^ Q
  - -     - :
 (hp $d  4  
p  B P
                               	        !    R 	   d    r    ~     
       ͱ    ۱            $    6    D    P    \                                      p 	   B x   Ų H               . p.     .    N/    
2    /2    |2    2    2    3    23    T3    3    3    3    .4    [4 
   }4    4    4    %5    V5    5    5 	   5 
   6    M6    ~6    6    6    7    =7    u7    7    7    7     Ҳ    ߲    
 
RP^ P
 ! t @8 U8  !   @8 U8  
 d T
 4	 2p!  8 W9  !   8 W9   T r
p! h 
d
 4 `; ~; 0 !   `; ~; 0 ! h 
d
 4  < >< 0 !    < >< 0 Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P  ^ P
       X     > 4@     A    A     C * , p`0  B P
 [                                   B P   H   C C    C     D      *     BP0  ^ P
 >
 ,x- (h. ^ 
p	`0  B hP
   p |                        ĳ    г    ܳ 	       
    	       
             	   B    H   D E     cF    pF    2G    BG    H    "H    H    I    I 	   J 
   J    OM 
   kM 	   P    P    P    Q    Q          L     
 
RP^ hP
 + +h ' #t d 4 P^ @P
 `     l PQ Q     ES    XS     S >
 ,x' (h( R 
p	`0  B P
 k                       ȴ    Դ         	       
    	       
            p 	   B `   H               T XU     "V    4V    BW    OW    X    "X    X    Y    Y 	   Z 
   Z    ] 
   ] 	   /a    >a    Ma    Ya    ea          \     
 
RP^ P
   ^ O
 p     a a      R0^ O
  a b     b  
R0^ O
  b )c     oc  d 4
 
Rp^ xO
 c c     .d  4	 
Rp^ PO
      0g g     g  
R0^ (O
  h 9h     h  d 4
 
Rp^  O
 h h     ;i  4 Rp^ N
     i i     i  4 Rp^ N
     Pj ~j     j  
 ^ N
 j k     Sk  R0^ `N
 pk k     k  R0^ 8N
 k !l     <l  R0^ N
 `l l     l * T 4 p`B M
 Z   X                          l 'm     4m    vm    hn    sn     n * T 4 p`B M
 Z   n ,o     9o    {o    mp    xp     p # #t d
 4	 R^ M
     `s s     et &
 &d
 !T 4
 R
p^ pM
  t t     / /x +h	 'T #4  
	p`  ^ HM
 @     v Uw     x &
 &d
 !T 4
 R
p^  M
  y Oy     = / *x &h % 
	p`0PB L
    P p{ |     }    T 4
 
R	p`^ L
     @~ i~      d
 T r! x h 
t 4
 P n  !   P n     4  p`P  ^ L
 `      #     	  h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  ^ L
             0                  *    X            -    ߉ 	   g    +    7    B    M    X             Ǐ    T 4
 
R	p`^ XL
     0 Y     #
 #h d T 4 p^ 0L
 p |     @ u         ϓ        	 "	 "T 4  	p`  ^ L
          @ u       
 XB    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  ^ K
              g     x                ؚ        +        _ 	               ġ    ϡ    ڡ        !     I  
 ^ K
        3  R0^ K
  P q       R0^ hK
         R0^ @K
 @ g      J J B
 = 8 3x /h +t- 'd, #4+ $ 
P  ^ K
       = " "d 4	 Rp^ J
           @ 	 	B  ! 4   Y A !     Y A " "d 4	 Rp^ J
       *     0 t         Я / /h
 + 't #d 4  P  ^ J
 @ L    X     @              ²    # S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P  ^ xJ
 p     д ;     P . h 42 . p  B PJ
 R        7    E      = = 8 3x /h +4> 8 p`P  ^ (J
                      ȷ    Է      7     T    t            Ծ    z        v    -    8    W    b V H @ 8 3 .x *h &44 * 
p`P  B  J
     ~      . h 42 . p  B I
 R  `               H = = 8 3x /h +4> 8 p`P  ^ I
                       X    t        %                     " "d 4	 Rp^ I
      
 @            t d 4 	 4H @ 
p`P  ! G p   !   p   3	 %46 0 p`P  B `I
 z        ,    8    D    P    \            0                          6 (t/ $d.  4, ( P  B 8I
 :  p     |                 ,     Q             h R00	 0 & x 	h   !    $ !     $ !      $ / / & x h 4 p!  p  t !   p  t !    p  t 8 8 & x h 4 p"
 "4 
p	`P^ I
                  R R J B
 = 8x 4h 04- !" p`P  ^ H
      ̸    ܸ                    $             @                                               8 8( 3) .x* *h+ &d` "4_ X 
p  ^ H
 0            <           H           T    `           l 	   x 
            
    
    
              
              
              
                                      @ 	   B `   x               P     <    N            
             	   1 
           d 
   X    i 
        
   	    3
    h
 
   
 	   
    
         B      ͹    ڹ    
 
P^ H
 2 2 -x )h %t !d T 4 
	^ H
        0 0x ,h (d $T  4  
p  ^ pH
        
 !     E    |      3	 !4= 6 	p`  B HH
         ,    8                               p 	   B x   D h                                 '    C     H    d     p D     R            	      P0  ^ HH
 <
 * %h 0 
p`0  B  H
 S                 $ 0 <    H H                	   B (  0     Q     1 Z    '        t 0     >    u                	      P0  ^  H
 <
 * %h 0 
p`0  B G
 S             H    T ` l    x x                	   B (  `             a     A j    7         `     n                ,    9      P0  ^ G
 <
 * %h 0 
p`0  B G
 S             x                           	   B (               q     Q z    G          "          ս        K    \    i      P0  ^ G
 <
 * %h 0 
p`0  B G
 S                   ̿    ؿ ؿ                	   B (              " #     a$ $    W%    %    '      ξ            {              P0  ^ G
 " "4
 rp^ G
                @            X    ( (     (           bP0  ^ G
 " "4
 rp^ XG
               4 @           ` X   ( 8)     N) `     n     bP0  ^ XG
 <
 *hv &d "4  
p  B 0G
 S                          '    5    A    M 	   ~ 
                                       P    b    p    |                                          	   B     H   ) *     8*    f*    +    ".    D.    .    .    .     /    M/    o/    /    /    0    H0    u0    0    0    1    ?1    p1    1 	   1 
   2    /2    g2 
   2    2    2    73    W3    3    3    3    	4                 
 
RP^ 0G
  0(
 (x #h  	p`P0  ^ G
 0                       < 5 U7    7 68     J8 '
 'h	 #T 4  	p`  ^ F
 P \    h 9 :    ;    ;    ; <      < ' 'x
 #h  
	p`P0^ F
              P< B>    ? S?     g?  R
p`0^ F
                            @            8       ? ?     ?    ?     ?          
 
2P^ F
  R
p`0^ hF
                           p @            8        @ (@     2@    C@     R@      	    
 
2P^ hF
 % % !t d 4 
	^ @F
                @             X       @ A     CC iC     /     RpP0^ @F
  R
p`0^ F
         `                   @           | 8   C C     C    D |         
 
2P^ F
 % % !t d 4 
	^ E
               ( @            X       0D aD     F F          RpP0^ E
    4 Rp`^ E
                            @            8       F G     +G    aG     pG      	    
 
2P^ E
  4 Rp^ E
                            ` @           < 8       G G     G    G <     I    
 
2P^ E
  4 Rp^ xE
         `                   @           | 8       G H     (H    6H |         
 
2P^ xE
  T 2`! 	 t 4 PH jH P !   PH jH P  d 2p! T 4 I I  !   I I  ! T 4 J J  !   J J  5 5x h   ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P  !  R GS  !   R GS   T 4 p`!   PU U ` !   PU U ` 
 d T 4 p!   X PX  !    X PX   h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
p^ PE
                                    x 	   B      8       ] ]     ]    
^    U^    g^    n_     x_          
 
2P^ PE
  4& $ p  ^ (E
                                 < 	   (      8   _ _     .`    K`    `     ` `     `      
 
2P^ (E
  d	 4 Rp R
p`0^  E
                             @           < 8       b 8b     Bb    Sb     ab <     I    
 
2P^  E
 Y Yh  0  ' 'h "d T 4
 
rp^ D
     d f     Bf ' 'h "d T 4
 
rp^ D
     pf g     g #
 #h t
 d 4 r^ D
 h h     i " "d 4	 Rp^ `D
 k 4l     Bl    l " "d 4	 Rp^ 8D
 l l     m    Pm " - 	p`XB @  !C
 Ch 8, &4 T3 42 o o   !   o o   	 d T 4  p  ^ D
 `     l    x      s Vs     s    s    *t    t     'u    T
 4 
R	p`^ C
       u  v     Pv    `v )  	p`0PXB   !/
 /< &x= h> ~ Ԉ v +w  !   v +w  ! 
  <  x=  h>  ~  Ԉ v +w  3	 %49 0 p`P  B C
 z  @ ˂         2    N        ̅     4* 	( p  ^ C
   #     g !    $ !     $ !      $  x h 
- ^ pC
                          ` ;     = Ӎ             3 L      k 
	`P!*
 *2 x3 h4 tj 4s p  ` !   p  `  4
 
Rp^ HC
                @            8        ŕ               
 
2P^ HC
  4
 
Rp^  C
               H @             8         %     N       -    
 
2P^  C
   x h   
 x h p`P0$
 $  x h 
 2 2x .h	 *4  p
`P  ^ B
 P     \ 0          ؝      " "x h 	p`P0! t  / P
 !    / P
 $
 $d  4 r
p^ B
                @           p X    
          RpP0^ B
 ! t   P
 !     P
 $
 $d  4 r
p^ B
               L @            X    ݨ          RpP0^ B
  
p`0  ^ B
                            @            H             A    Z           #     2pP0^ B
  `  ! T   4 ! t 4  T   4 !   t  T  4   4    ! 4  @ T  !   @ T  ! 4   Ѯ  !    Ѯ  !
 
t d   ( 0F !     ( 0F !
 
t  4 `   !   `   !
 
t d @ h 0F !   @ h 0F . .4= 4 
p`P  ^ XB
        5      UeDx  =h! 6tL /dK (4J cD 
PB 0B
   p           t ! 4   d
 !     d
 !   4   d
  
R0^ B
 P        d 4
 
Rp^ A
  .       
R0^ A
       ?  d 4
 
Rp^ A
 P        4 Rp^ hA
     `        4 Rp^ @A
       N     i  d 4
 
Rp^ A
       ' 	 	b   
 ^ @
       S  R0^ @
 p        R0^ @
  !     <  R0^ x@
 `        
 ^ P@
       C  R0^ (@
 `        R0^  @
       ,  R0^ ?
 P w      s st 
 ! 4  J  !    J  " "d 4	 Rp^ ?
         d     r     " "d 4	 Rp^ ?
        $     2     Pe?h 841 &c!& p`PB `?
          !      ' 'd #T 4  
p  ^ 8?
                h         j } }  x 0! h  m  
 !    m  
 3	 %40 ( p`P  B ?
 :                 E    T     @ `0P  ! I H tF   
 !     
 !   I  H  tF   
  "p0  !    d T
  &  !    &   d 4 p! t d 4   d
 !     d
  4* 	( p  ^ >
  C      = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x P  $ !   P  $ * * h  !  p Z ` !   x Z  p !   Z  p !   p Z ` @
 @ , "   ! x @   !   9  ! h 9   !   9   !    9  !   @   9 9 !x 
 !  h  U D !  U  T !    l !     l !   U  T !    U D 9 9 &x h 
  !     !     !      !        0  ' / p`P0B >
 b  
 
     4    t ' 't #d 4 
P^ >
 0     <           
    
     +  d Rp! T	 p   ! h 
 4    !      !   p   /
 /t" +d! '4   
P  ^ p>
     P      S )
 )h
 $t  d T 4    ^ H>
 P  E      ! T   x !     x  d
 T	 4 Rp^  >
        -     I !" "t  d 
T 4   G  !     G  ! t  
d 4    !      !" "t  d 
T 4 `   !   `    Bp
`  !$
 $  
 
T	 4     !       ! t  
d 4    !      + - 	p`P0B =
 R   ! b!     !    !    "    + - 	p`P0B =
 R  P" "     "    #    V#     2pP!
     
d 4	 # #  !   # #    P!   t d 4 p&  '  !   p&  '   
R0^ =
 0( i(     (  d 4
 
Rp^ =
 ( )     k)  4 Rp^ X=
      * .*     I*  @ 
	`P  ! > t? 4F / &0  !   / &0   " P   R0^ 0=
     2 2     2  
 ^ =
 3 D3     3  R0^ <
 3 3     3  R0^ <
  4 a4     |4  R0^ <
 4 4     4 " "d 4	 Rp^ h<
  5 D5     R5    5 " "d 4	 Rp^ @<
 5 6     6    `6  4 Rp^ <
     6 6     6 " "d 4	 Rp^ ;
 `       7 D7     R7    7 IE;h 7t! 0d  )4 C 
PB ;
      7 ,8     p8    9 W
 Wx 8h  4J B 
p	`P  ! I @: :   !   @: :   U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4  PE uE  !   PE uE  !  t d G G 0F !   G G 0F !  t d H I 0F !   H I 0F  p  ! 4 0L DL T !' '  d DL aL \ !   DL aL \ !   0L DL T  . `P  !p ph :* /+ $, t- 44 M M  !   h  *  +  ,  t-  44 M M   
R0^ ;
      P YP     P  d 4
 
Rp^ x;
 P P     [Q  d 4
 
Rp^ P;
       pQ Q     Q    Q  d 4
 
Rp^ (;
        R PR     fR    tR  
 ^  ;
 T U     cU  R0^ :
 U U     U  R0^ :
 U 1V     LV  T 4 `  ! t pV V p !   pV V p " "d 4	 Rp^ :
     W X     "X    pX " "d 4	 Rp^ `:
       * X X     X    0Y Pe?h 841 &c!& p`PB 8:
       PY Z     ] 3	 %49 0 p`P  B :
 z  @     L    X    d    p    |            ] [^     ^    ^    _    Ma    \a    0
E"h t d 4 C
P  XB `   /
 /t" +d! '4   
P  ^ 9
 f g     g /
 /t" +d! '4   
P  ^ 9
 i Qi     j O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4 t t  !   t t  ! t  d 
T 4 `v v  !   `v v  " "4 
p	`P^ 9
 Px x     y Ne=h 6t< /d; (4: c4 
PB p9
         y z     {    ~     ~  	  h d 4  p  ^ H9
           t d 4  t T 4 ! d   | !     | " "d 4	 Rp^  9
               P 
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h p   !   p   	 	2p0!  
d	 T   P  ! 
   \  !     \  !     P  !" "t  d 
T 4 Д   !   Д    T `  !
 
t 4 p    !   p    ! t З   !   З   9 9 "% p`P0!{ {	 m
 X I =
 1   x h `  4! !   `  4! !   	  
      
      x  h `  4! 
 
0!,
 ,  ( t d T  ʫ ! !    ʫ ! <5.h *t #d 4 3
P  B 8
 R     4         ) )d: %49 2 	pP  ^ 8
       d       d 4
 rp^ 8
       .    ? -	%t d
 4 #P  B 8
 B        ` ?     P , ,1 pP!I Ih :+ ', #- . 
d/ 40   (# !     (# L L 7 " p`P0!| | g C 9 	 x
 h   p# !     p# 1
 1h -4# ! p
`P  ^ X8
                      z         p
 ph hd+   
p0P  !  t d   0F !     0F !d d	 [
 O B 9
 0 $ x h   4 4! !     4 4! !   	  
      
      x  h   4 4! ! !dK !4J !B pP  ! h  I  ' % !   h   ' % !    ' % '
 'tK 'dJ '4I 'B P  !* * ! x h  0  \% !   0  \% !  t d  < 0F !    < 0F      T 4 
R	p`^ 08
     `        T p  !
 
d 4 ` } & !   ` } & /
 /t0 +d/ '4. ( 
P  ^ 8
     `      y /
 /t0 +d/ '4. ( 
P  ^ 7
   >       9 
0P! 5 6 t7 d8   & !     & !   6  t7  d8   &  	  h
 d 4  p  ^ 7
            p BE1h *+ #* d) 4( C	& PXB      ! t d 4 `  ' !   `  '  d
 T	 4 Rp^             	 "  j    
 ^  ^  P  
 
4
 
rP t	 d 4 2j     t
 ,      d 4 2pj     , C     	 4 rp`j     ; _ ;  rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!   K ( !. . 	 K y ) !	 	 y   ) !   y   ) !   K y ) != =2 *3 4 4=   ) !    K (  B  ! 4 0  ) ! t  4 0  ) !   0  )  20 R0
 
4 
2p 20 % XB    B   B  
 
4 
Rp 20
 t
 d T 4
 r B   B   20! 	 t 
d T & ' `* !   & ' `*  20
 
4 
2p d 4 2p d 4 2p 4 p R
pP0! d
 * * * !   d
 * * * !   d
 * * * !   d
 * * * 
 
4 
2p! d @- - 4+ !   @- - 4+  20 d	 T 4 2! t 0/ / l+ !   0/ / l+  20
 
4 
2p 20
 
4 
2`!
 
t T `2 2 + !   `2 2 + 
 
4 
2p 4	 2p`P d 4 2p
 
4 
2p 0  ! t p8 8 ,, !   p8 8 ,, !   t p8 8 ,, !   t p8 8 ,,  B  ! 4  ; }; , ! t  4  ; }; ,  B  ! 4 ; 9< , ! t  4 ; 9< , !   ; 9< ,  B  ! 4 < = , ! t  4 < = , !   < = ,  B  ! 4 = = <- ! t  4 = = <- !   = = <-  B  ! 4 > > - ! t  4 > > - !   > > -  B  ! 4 `? ? - ! t  4 `? ? - !   `? ? -  B  ! 4 @@ @ . ! t  4 @@ @ .  B  ! 4  A YA <. ! t  4  A YA <. !    A YA <.  B   B   B   B   B   B   B   B  U UT	 P4 t d
 2 d T 4 p T	 4 2p!  d PE E . !   PE E .  2p 4 B
 B 9 0
 +t	 &4 B`P  
 
4 
2p T 4 Rp`! 
 I I d/ !   I I d/  % p`P0XB    T 4 R
p`
 
4 
2P!
 
t d M %N / !   M %N / !   t  d M %N / !   t  d M %N / 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !  X X p0 !    X X p0 !H
 HT : 5t
 0d	   X X p0  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p
 
4 
2p d
 T 4 2p d 4 2p! T i j T1 !   i j T1 
 
20 d	 T 4 2p!  l l 1 !   l l 1 !    l l 1 !   l l 1  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d t Bu 82 !   t t Bu 82 !   t Bu 82  t 20 20 d
 T	 2
p! 4 pw w 2 !   pw w 2  b   t	 d T 2! 4 x y 2 !   x y 2 	 	B   20 20 d T
 4	 R! t { p| $3 !   { p| $3  d 4 2p
 
d	 
Rp! 4  ~ /~ l3 !   4  ~ /~ l3 !    ~ /~ l3  d T 4 2p t 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p
 
4 
2p 2`! 	 t T 4   T4 !   	  t  T  4   T4  d T 4 2p B   
4' 
$ p  XB   ! d&   4 !     4 
 
4 
2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	 p  \6 !   p  \6  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	  ' D7 !    ' D7  B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
P^                @ t             g    t        Y      2P'
 '4 
p`P^ 0       0 ]     q    _      2P6 (4   
p`P  B X    .     "    T    X    `  0     H    l    z        v                6    R              2P, ,4"  
p`P  ^  l                    Y    b    n    "    f          2P'
 '4 
p`P^                        2P, ,4"  
p`P  ^           #    /                                 2P'
 '4 
p`P^  G     ; P }               2P- -x )h %4 
p	`P^   |     p   S     g          2P' d 4 pB H j      M      2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p T p`0XB P   
 
4 
Rp9
 +t! 'd  #4  
P  B p               	 J	     ]	    m	    k	    	     ?	 9
 +t! 'd  #4  
P  B               	 Z	     m	    }	    {	    	     O	  d 4 p^         	 F	     O	    -	     i	  d 4 p^  +     7 	 	     	    	     	 9
 +t! 'd  #4  
P  B     C     O    [ 	 	     	    	    	    U 	      	 9
 +t! 'd  #4  
P  B 8    g     s     !	 !	     !	    !	    #	    e$	     $	 9
 +t! 'd  #4  
P  B `              %	 %	     %	    
&	    (	    u(	     (	 '
 '4 
p`P^        )	 )	     )	    .	     /	 
 t	 d T 4 29
 +t# 'd" #4!  
P  B                    5	 n5	     5	    5	    5	    8=	    =	    I>	     >	  B  
 
4 
Rp*
 *4 
p`P^               X    X    X pA	 A	     A	    A	    E	    E	    E	    F	    3F	    _F	    =I	    gI	     I	 # #d+ 4( " 
p  ^        '    3                           C @           ? X   I	 J	     (J	    3J	    [K	    K	    O	    3O	     OO	 ?     L    s     
 
rP^   
 
4 
Rp !f f ^T ) !	 t
 
d 4
 P	 P	 C !     	 P	 P	 C !   	 P	 P	 C !   P	 P	 C   
  ! 4 0a	 Ga	 D !e ed     t T Ga	 Ka	 D !   Ga	 Ka	 D !   0a	 Ga	 D !         t  d  T  4 0a	 Ga	 D  T
 4 rp`  
  !e e Z  t d T 4 u	 .u	 D !   T u	 .u	 D !   u	 .u	 D !         t  d  T  4 u	 .u	 D  T
 4 rp` B  !6
 6 1t )d
 
T	 4 	 	 TE !   	 	 TE ! 
    t  d
  T	  4 	 	 TE # #d! 4   
p  ^ (                                          F @            8   	 K	     V	    a	    l	    h	    	    >	    Z	    v	     	               
 
2P^ (  d T 4 p( (t $d  4  
	  ^ P                                 (G @            8    	 A	     N	    	    	    M	     i	          ?     
 
2P^ P #
 4 
p`PXB X   	 T 
p`0  XB `   
 d T 4 p
 d
 T	 4 2p 	p`P0XB X    BP  !; ;t
  
d	 4 	 	 (H !   	 	 (H - -d 20! t @	 	 dH !   @	 	 dH  BP  ! d	  t
 4  	 	 H !    	 	 H  d T 4 2p-
 G 
	p`0PXB (  #
 4 
p`PXB `   D
 Dt d	 T 4 2
 d T 4 p   XB    !$ $  t d T 4% 0
 `
 TI !    0
 `
 TI !   0
 `
 TI 
 d T 4 p B  !
 d
 T	  
t 4 0
 B
 I !   0
 B
 I  bP  !$ $   t 
d 4
 p
 
 J !   p
 
 J  d	 2! t T 4 
 
 PJ !   
 
 PJ  2p`0!  
 T
  
 ,
 J !       T
  
 ,
 J 
 t	 d T 4 2 20 20 d 4 2p t d T 4   
p`0^ x M     Y    X    X    X           e                    K @            8   `$
 $
     $
    )
    )
    )
    *
    2*
    d*
    *
    +
    +
    ,
     ,
                2P
 
2P^ x  d 4 2p)	 !  p`0  ^                                        M           X    X    X                                             PM             dM    
         xM             M @            8   @           j 8   @            8   @            8   -
 =.
     Q.
    }.
    2
    2
    2
    2
    2
    7
 	   7
    8
 
   /8
    X8
    8
    8
    8
 
   	9
    =
    
>
    8B
    mB
     B
          ?     w                       B      2P
 
2P^   2P
 
2P^   2P
 
2P^  
 
2P^   4 
p`PXB X    d 4 2p6 (40 & 
p`P  B  *  \     P            X G
 G
     G
    "H
    2H
    N
    O
    FO
    O
    O
      2P6 (40 & 
p`P  B  *                   X PP
 P
     P
    P
    Q
    W
    W
    X
    X
    X
      2P; -x )h
 %4&  
p`P  B                Y
 tY
     Y
    Y
    
    
     
     !% %   t d T 4 P
 \
 P !       t P
 \
 P !     t P
 \
 P !   t P
 \
 P !   P
 \
 P 9
 +t- 'd, #4+ $ 
P  B @         
 
     ,
    S	     	  20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   T 4 2`! t    `S !      `S  bP  !$ $   t 
d 4
 ` y S !   ` y S  d	 2! t T 4     S !       S  2p`0!  
 T
 " # T !       T
 " # T 
 t	 d T 4 2 20 20 B    ^ h                       T 	   H (   & 8   	   H 0   _ 8   	   ` 8    8   	   X @    8   	   6 H   - 8   	   ( P    8   	   - X    8   	   . `    8   	   X h   z 8   	     p    8   	   B x   2 8   @           k 8   )  )     7) &     3    Q     l                           :    {                       +    l                  $     ?    ]     x         
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h 
 
2P^ h  B  # 4 rpB  2    ) )     ) 1	 #t! d  4  P  B                                       , * *     .+    S+    |+    +    +    +    /,     ,    ,    
-    /-    @-    S-    ]-      2P d
 4 
Rp^  8 - -     .  20 B  ? .4  
p`P  B  :  D     P    \    h    t                     	    
            
               (    4    @    L    i    u                                             	 !        ! #   - / W0     g0    a2    2    3    83    3    3 	   3 
   3    4 
   4    4    4    y5    5    5    
6    F6    6    6    6    6    27    >7    7    7 !   7 "   8 $   98    o8    8    8    h9    9    9    9     9  2P 20   ! 4
 < < `[ !   < < `[    ! 4
 = (> [ !   = (> [ 
 
4 
2p 2p! 4  @ B@ [ !   4  @ B@ [ !   4  @ B@ [ !   4  @ B@ [ !   4  @ B@ [ !   4  @ B@ [  B  
 t	 d T 4 2        h 	x    h 	x            \                    \ `b ^                                                           8   0<                      a                    _ h` ]  f ^ pj Pa                                    H (          `K                   P     j                     п     k                     9         (   Pd                 B            `                  `     h                                 )                 P     a                    b e ^                     
 (          P=                @2         X                   p         h   b                      (`                    g  i e ^ hg (i                                 
            P=                           @                         a                               8   <                He d e e ^ hg (i                                     *         P   c                       (e                     g (k ^                           ^                     0
         @                   \  f ^                    `b ^                 p     P                          (     i                              X   0(                 ` _ ^                    ^ xi 8h ^ h (i                                       h                     6            @e                 H            `K                  X            >                F         X    P                       8a                     #         8   ;                 6         @   P                i ^                #         X    h                `c k  g (k ^ hg (i                                           g                           Hc                    (f (k ^                     P     X_                           f                              @   (                 0         @   P                 `             >                         X                          Pj                    f (k ^                              X                         (g                           j                                 0                  .            `>                 H            5                  X            pv                          X   P                           8   =                8b (k ^                     f ^                 -            Pb                                               b `b ^                           f                     p        (   PC                 g     c                     0     Pk                    (k ^                =         X   p                 B (          `                  p         (   PC                 b     @]                          j                    Pi e ^                    (j _ 8b (k ^ hg (i                                     P         @                     p     @                                       >                          @                    `         8    ?                       `                    a hd X^ e ^ hg (i                                    `#         X                   e e ^                     p (       (   PC                xf d ^                    e ^                b  c (k ^ hg (i                                       d                     0            0_                 Pf k (f (k ^ hg (i                                    d ` 8h ] h (i                                 
         @                    p:         @   h                         0^    Rl          Hl Ll Pl p l   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087.cp37-win_amd64.pyd PyInit_stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1720277117026287087 s         :  n           m         H   Xq         X h  s           q           s         Ν  `s          p  r          0 r         0  q         R                          $     J     b     z                         И                    $     @     ^     r                    Й                    2     2                  ފ     *     j          .     z          `     $          P          ʈ          &                    n     F          H     b     ~                    >     `     z                    ։          ڗ               Z     4                         x     L     &               f     $               T          Γ          L               p     (               \          А          J     
     Ώ          \               H     ܍     p     .                       p     z                         Ě     ښ                "     8               x     V             ؛                            (     r                                                ʞ     О     ؞     ޞ                            t     j     \     D     (               М               d                   j     D          0          
     X                                 :          N                  |                       d     H     4           
               ȁ                    |     `     <     *          
               ̀                         v     f     P     B     4                                             t     Z     F     ,               ~     ~     ~     ~     ~     ~     ~     z~     j~     R~     ̂     ,~     ~     ~          }     }     }     }     }     z}     b}     P}     8}     "}     }     }     |     |     |     |     |     |     l|     X|     D|     4|     |     {     {     {     {     {     {     {     p{     `{     J{     ,{     {     z     z     z     z     z     z          xz                         Tz     &     B     T     h     <z     x                    }     *z          ԃ                     (     z     y     <     R     h     ~                    ̄     ܄               "     y          :~     y     y     y     y     y     jy     Ly     :y     (y     y     x     x     x     x     x     x              PyBaseObject_Type PyObject_SetAttr  PyUnicode_InternFromString  ? PyCFunction_Type  CPyOS_snprintf PyThreadState_Get _Py_CheckRecursionLimit PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches _PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  $PyExc_RuntimeWarning   PyErr_PrintEx gPyFunction_Type VPyFrame_New PyLong_AsSsize_t  PyExc_DeprecationWarning  PyExc_KeyError  PyImport_ImportModule PyImport_ImportModuleLevelObject   PyErr_NormalizeException  iPyUnicode_AsUnicode ~PyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  PyUnicode_DecodeUTF8  bPyObject_GenericGetAttr !PyTraceBack_Here  4_PyThreadState_UncheckedGet #PyExc_RuntimeError  PyExc_IOError PyObject_SetAttrString  PyLong_FromLong aPyObject_GC_UnTrack PyUnicode_FromUnicode nPyObject_Hash  PyErr_SetNone PyExc_MemoryError  PyDict_GetItemWithError PyInterpreterState_GetID  Py_GetVersion gPyObject_GetAttr  EPyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags * PyBytes_AsStringAndSize _Py_NoneStruct  +PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size WPyFrame_Type  HPyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable kPyObject_GetIter  
PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx 5PyExc_ValueError  _Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError |PyObject_RichCompare  /PyTuple_Type  _Py_FalseStruct  PyCoro_Type MPyFloat_Type  PyModule_NewObject  PyMethod_Type PyLong_Type 7PyType_IsSubtype  *PyNumber_Subtract  PyErr_Restore PyExc_OverflowError PyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  F PyCapsule_GetPointer  _PyObject_GC_Del  PyErr_Fetch RPyObject_CallFunctionObjArgs  PyLong_AsLong XPyObject_ClearWeakRefs  xPyObject_Not  PyUnicode_FromFormat  iPyObject_GetBuffer  PyList_New  PySlice_New uPyImport_AddModule  9PyType_Ready  hPyObject_GetAttrString  _PyGen_Send  PyErr_Clear PyList_Append 6 PyBytes_Type  wPyUnicode_Decode  W PyCode_New  >PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  PPyObject_CallFinalizerFromDealloc ]_PyDict_GetItem_KnownHash rPyObject_IsInstance PyNumber_Index  &PyExc_StopIteration PyList_Type  PyDict_GetItemString  jPyObject_GetItem  UPyObject_CallObject  PyErr_CheckSignals  PyModuleDef_Init  `PyObject_GC_Track 3 PyBytes_FromStringAndSize PyExc_NotImplementedError qPyUnicode_Compare sPyObject_IsSubclass -PyExc_TypeError PyMem_Realloc > PyCFunction_NewEx N PyCapsule_Type  tPyObject_IsTrue PyExc_NameError ,PyTuple_Pack  1_PyByteArray_empty_string Py_OptimizeFlag _PyUnicode_Ready  PyMem_Malloc  PyExc_IndexError  
PyExc_ImportError rPyGen_Type  _Py_TrueStruct  
 PyArg_UnpackTuple )PyExc_SystemError  PyExc_AssertionError  PyObject_SetItem  _PyObject_GC_New  #PyTraceBack_Type  PyMethodDescr_Type  PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  \_PyType_Lookup  PyObject_Size  PyBuffer_Release  NPyObject_Call ' PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python37.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 5EnterCriticalSection  LeaveCriticalSection  DeleteCriticalSection $SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  ~GetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  {SetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  IsProcessorFeaturePresent IsDebuggerPresent PQueryPerformanceCounter GetCurrentProcessId "GetCurrentThreadId  GetSystemTimeAsFileTime "DisableThreadLibraryCalls lInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                                                                                                                                                                                                                                                                  2-+  ] f      /                              P   P   P           Transform parameters from defined support to unconstrained space                Q                           Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

                )                                  0G                   P                                                                                                                    @                                                                                                                                                                                                                       >   '                  >   p                   (>   P                                                                          @                                                           0	                            @                           `          |                      `          P              `   `          p                                                                                     F                                                                                                                                       @                                                                                                                                                                                                                           8>                         H>      P                      0                            p                                                  0                   +                         X>                          h>                         x>   `                      >      @                   >                                                                          Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
           Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
           H   @0          _   .    *          _   9   .          X`                                   Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                  
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
                                     C   p               p                                   	           P                      	                            D     D   `   p                                                                                          !
           @                                                                                                                          H                   Q   أ                                                                                                               8   pG
                                         Pa                  '                                                                                                                   @             )                   @               .         p                                                                                                                                           &   
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              `   &   `&   a            a   @&   %   0a                                                      B
          Р           l                                                                                      R                   @C                              2   к   P                   PC   0                            @                   `C                          pC                          C      `                   t7   @                                                 C                          C   `                      =      @                                                                   
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
                                PF                                                                                                                                        @                0                                                                                                                                                                                                      Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                                            >   p                                                                  p   H                                                    D     ?                                                     @                                                           p                                                                                   Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               Transform parameters from unconstrained space to defined support                @    !
                   A   
                  A   `
                  1    
          Ъ    A     
          P   ?   P	          `   0A   @	                  @A   `	          `   PA   P	                  XA   	             pA   	             A    	             A   	             A   `s	             A    a	             A   O	             A   I	          `   B   `A	                  (B   0@	                  8B    @	                  HB   `?	                  XB   5	                  pB   /	                  B   )	                  B   %	                  B   !	                  B   p	                  B   	                  B   	                  C    	                  0C    	                                                                         G                   @                                                                                                                    @                                                                                                                                                                                                                           Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       T   `                        [                           \   `   }                      hZ      (                      @T      &                      T   H   &                      xT                           0Z                           X                           W   H   <                      S      #                      \                            [                           Z   <                        PT   `                        0U   P                        [                           P\                           (Z       $                      Z                           Z                           X   $                        XZ                              V      
                     8[      
                     T   @   	                      W                           hV      %                      Y      (                      XX   p   A                      Z                           X                           @V                            X                           U   0                        Z                           \                             V   P                        HT   `                        T   p                        Y                           Y                           Z                           V      	                      V                           S      
                     Y   x                        P                           S   x   
                     X   D                        8U   `                        Q   @                        pV   X                        W   $                        `X   8                        Y                           T   |                        X                           [                           PZ   (   	                     T   l                        H[                           W                           T   D                        hY                           X\   (   
                     U                           Z   `                        P                           hU      
                     [                           8Z                           Z      L                      [   0                        @\                           HU   8   
                      (\                           S      	                       Y   H                        U                           P                           xY   p                        U                           P                           Z       +                      (Y      
                     [                            Y   ,                        0\                           Y                           h\   L                        XU      
                     S                           Y                           W   ,                        (X                            HY       
                     X                           X   p   
                     Z   <                        pY   @                        Q                           Z       
                     hT                           @U   P   
                     (U       
                     HZ                           8Y      
                     P   p   	                     X   (                        X      	                     U      
                     @[                           PX   (   
                     Y   x                        P                           `[      .                      X   d                        8V                           U   (                        X[      
                     W                           U      	                      V   @                        W      
                     W   X                        T                           X                           X                            8X                           xX      	                     `\   x                        T   p   
                     x[      
                     0X                           Y                           T                           Y   x                        W                           X   4                        V   4                        W   8   	                     x\                            (W   H   "                      T                           [   <                         \       x                      Y                           [       '                      Y      "                      V                           T   0   
                     W   |                        V   `                        P                           Q                           P[                            U                           Q   8   	                     (T                           U                           `Q   D                        H\                           @Z   H                        Y                           V                           V      
                     Q                           [                            U                           Z                           T                           [                           `U   (   
                     X                           p[                           V                           V                           T      
                     Z   x                        Z   P   	                     PY                           X                           XV                           V                            Z   x                        PU                           XY                           HV                           0[                            HX   p                        V   8                        8\   p   H                      X   P                         \      	                     (V   `                        [                           Z      
                     W                           xU      	                     W      	                     \      
                     @X                           0V                           \      	                     Y                           xV   h                        X      
                     \      
                     [   0                        `T      
                     \                           h[      	                      S   P   %                      P                           xZ                           XT   <                         T   4                         X                            U                           W                           Z   L                        T                           X                            0T   p                        W                           \                           `Y                           V   X   	                      T                                                                           P   `Q           P           P           P   Q   P   P                   P   `Q   P           P   Q   Q           P   P                   P   P                   P   Q                   P   P                   u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                         .?AU?$located_exception@Vexception@std@@@lang@stan@@               .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                         .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AUPyErr_CheckSignals_Functor@?A0x3661d0ed@pystan@@                       .?AV?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVlogger@callbacks@stan@@                        .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@               .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                 .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AVlength_error@std@@                     .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVdomain_error@std@@             .?AVcovar_adaptation@mcmc@stan@@                           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .?AVdivide_vv_vari@?A0x3661d0ed@math@stan@@                .H                 .?AVdivide_dv_vari@?A0x3661d0ed@math@stan@@                .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AVanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@                    .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                 .?AVmultiply_vd_vari@?A0x3661d0ed@math@stan@@              .?AVbad_exception@std@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                           .?AV?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                .?AVneg_vari@?A0x3661d0ed@math@stan@@              .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@              .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@                     .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVadd_vv_vari@?A0x3661d0ed@math@stan@@                   .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVbad_typeid@std@@               .?AVop_dv_vari@math@stan@@                 .?AVps_point@mcmc@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@             .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AUbad_exception_@exception_detail@boost@@                .?AV?$adapt_unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$numpunct@D@std@@             .?AVvari@math@stan@@               .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x3661d0ed@math@stan@@                  .?AVdump@io@stan@@                 .?AV?$unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@                      .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@             .?AVrounding_error@math@boost@@            .?AV?$diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVexp_vari@?A0x3661d0ed@math@stan@@              .?AVunderflow_error@std@@                          .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@               .?AVsum_v_vari@math@stan@@                         .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVempty_var_context@io@stan@@            .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                          .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AV?$adapt_dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AVchained_var_context@io@stan@@                  .?AVfacet@locale@std@@             .?AVdiag_e_point@mcmc@stan@@               .?AVfixed_param_sampler@mcmc@stan@@                .?AVout_of_range@std@@             .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                   .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVbase_mcmc@mcmc@stan@@                  .?AV?$adapt_dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             .?AVdense_e_point@mcmc@stan@@                      .?AV?$dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                         .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVsum_values@pystan@@            .?AV?$adapt_diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@               .?AVmultiply_vv_vari@?A0x3661d0ed@math@stan@@                      .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@                     .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AVprob_grad@model@stan@@                 .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AV?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVexception@std@@                        .?AV?$adapt_diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                        .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AVwindowed_adaptation@mcmc@stan@@                .?AVvalue@pystan@@                 .?AVsubtract_dv_vari@?A0x3661d0ed@math@stan@@                      .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AVadd_vd_vari@?A0x3661d0ed@math@stan@@                   .?AV?$adapt_unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   V  d
 `    d
     d
    >  d
 @  ^  d
     d
     d
   
  d
 0    d
     d
   F  d
 P    d
     d
     d
      d
    V  d
 `    d
     d
     d
      d
      d
     d
     d
     d
   &  d
 0  F  d
 `    P
   #  X
 `    d
   %  l
 0  p  P
 p    t
   y  
     
 P  #  H
  $  V$   
 `$  $  ,
 $  $  P
 $  %  P
 %  '&  <
 0&  &   
 &  '  
  '  (  $
 (  )  h
 )  s*  
 *  3+  
 @+  +  
 +  ,  
 ,  ,  X
 ,  -  
 -  -  P
 -  .  P
 0.  [.  P
 `.  &/  
 P/  {/  P
 /  /  (
 0  ;0  P
 @0  k0  P
 p0  0  d
 0  ^1  H
 `1  1  d
 1  N2  
 P2  r2  d
 2  >3  
 @3  b3  d
 p3  .4  
 04  R4  d
 `4  5  
  5  K5  P
 p5  5  X
 5   6  P
 6  ;6  P
 @6  l6  P
 6  6  d
 6  6  P
  7  L7  X
 7  7  P
 7  7  X
  8  G8  X
 P8  Y9  @
 `9  i:  
 p:  y;  
 ;  <  (
 <  !=  p
 0=  =  
 =  =  P
  >  ?  
  ?  E?  P
 P?  ?  
 ?  P@  
 `@  @  l
 @  B  
 B  B  X
 B  C  (
 C  IF  p
 PF  oG  
 pG  J  X
 `K  K  P
 K  K  P
 K  :L  
 :L  ~L  
 L  L  P
 L  ,M  
 0M  eM  P
 pM  @P  X
 @P  Q  l
 Q  S  |
 T  T  P
  U  U  
 U  V  
 V  0W  
 X  X  H
 X  ]Y  
 Y  mZ  
 [  "\  
 0\  \  (
 \  ]  `
  ^  .^  P
 0^  ^  
  _  ._  P
 0_  p_  P
 p_  X`  
 p`  b   
  b  Db  P
 Pb  b  P
 b  >c  h
 @c  d  
  d  ?e  
 @e  e  P
 g  h  0
 h  j  <
 j  k  
 k  n  
 n  o  0  o  jo  <  jo  o  X  o  ]p  l  ]p  fp  |  fp  lp    pp  q    q  s  
 s  Yu    `u  u  @ u  u  H u   v  \  v  ]v  p ]v  fv   pv  v  P
 v  `w   w  x   x  cy   py  }  0 }  }  P
 }  ~~   ~          C  X
 `    P
     l
   ;  x `    X
   ~     ~     3   @  Ď   Ў         p     X
          ė   З       R  8 R    H   -  \ 0  S  l `    P
     P
    d  
 p    P
   7  0	 7  r  D	   9  P
 @  a  X	 p  B  p	 P    P
   U  0
 `  ԣ  
   n   p  Q   `            z   z  
    
  8  0 8  u  H u          \    g  | g       A   A  Ӭ   Ӭ  
   
  G   G  \   \       <  P
 <  o  
 o  =  (
 =    <
   ޯ  L
 ޯ    `
    j  x
 j  x  
 x  G  
 G  Ѳ  
     |     
   @  
 @  ߵ  X
     l
    F  l
 P  v  l
     l
   E   P         X
      X
   ȿ   п         P          D      0                  i  H p       S   S                   P
        j  8 p    H   )   0                    P
   j  $ p       T   
 `  G  8 P    L   L   P         8     X     l     |        2   2              @   *   *  p   p       {       l    I   P            Y   Y    4     D     P
   >   @        ^   `    @     x          Y H `    R  `    
  
 z (   ,   0     l  &  0 S  ` p   p     o ! p  8!  + h! 0  !   l
  1 X
 @  P
  9 ! @  X
    P
   @ P
 `  X
   P
    !  " X
 0  X
   X
  Z P
 `  X
   X
    
  K  " P    #  ! e! P
 p! ! X
 ! ! X
 ! . 
 . / p# / 3 # 4 04 P
 04 ; @$ ; /<  % 0< < X% < O= % P= = P
 = > %  > `> P
 `> > P
 > > P
 >  ? P
  ? ? % ? @ X
 @ f@ X
 p@ @ X
 @ &A X
 0A A X
 A A & A nB H& pB B x& B NC & PC C X
 C ;D P
 @D (E & 0E i ' i k 
 k | . |  4  b 5 p ی  6  ?  8 @ t X
  W 
 ` Ԓ 
   9  o 9 p  P
  ϖ 
 Ж  @:   I l
 P y l
   l
  ٗ l
  x h:   :  K ; P  `<   H < P  <  V = `  =   H>   >   X
   V P
 `  >   P
  D > P  P
   >  & P
 0  >  Ʈ P
 Ю $ > 0  >  G P
 P / 
 0  0?  G P
 P ] X
 `  ?  R ? R  ?   ?   P
  N ? N  @    @  , X
 0 C ! P  !  s X
   P
  : X
 @ ? P
 @ , X
 0  X
   P
   8 
 8  0@   D@   T@   P
  > X
 @  @  I A I  A   ,A   <A  B XA P  A   A   A    A   B   A   8B   X
   xB  P P
 P  X
   
  Q B Q _ C `  C   X
   
   C   C    X
  q ? q  C   C  + C 0  ?   C   D  l X
 p  X
   X
    
  e D e s ,D   P
   l
   K l
 P  l
  * X
 0 a l
 p  
   P
  Y <D `  P
   P
  0 X
 0 r P
   P
   XD   lD  
 D  > P
 > \ D \ s D  ^ X
 `  D P  0E   l
   t X
  \ HE `  E  3 l
 @  X
  ^ E `  0F  T 8F T j LF p  \F  V lF V  xF   F   F    X
   X
   
  ` 
 `  X
   F   F   P
  Z P
 `  d
   A   X
    0G  b d
 p  d
   c X
 p  G  v P
   d
   d
   l
   H   A  T H T J H J a H p 4 H 4 * H * A H P  d
   H   (I   d
    d
   X
    d
  2 d
 @  X
    
   ,
   XI  	 l	 pI p	 
 
  
  I   
   ! I 0  X
    
   M 
 P u I   I   I   J  q X
  )  J 0  `J  O 
 P  lJ    P
  6 X
 @ ? J @  J   d
   u d
  $ $ d
 $ % d
  % % d
 % k& J p& ' K ' ( d
 ( ( J ( ) (K ) "* d
 0* * A * "+ d
 0+ , hK  , , xK  - - A - . X
 . / K / 0 d
  0 4 K 4 q9 K 9 	: K : : ,
 : : K  ;  ; l
  ; < K < @ L @ @ L @ A M A A M A (B (M 0B B (M B zC P
 C KD J E 2E 0M 2E F @M F F TM F ?G dM @G bG 0M bG H xM H 
I M 
I oI M pI I d
 I K M K M N M O xO  P 9P P
 @P P I P P XP P vQ hP vQ Q P Q S P S T P T aT X
 pT U (Q U V A  V pV l
 pV W Q W W R W X R X Y l
  Y Y R Y Z l
  Z Z  S Z [ pS [ t\ S \ \ d
  ] x^ S ^ _ S _ ` XT ` b T  c c  U  d \d X
 `d d X
 d e P
  e ~e X
 e e P
 e 6f P
 @f f P
 f f P
  g 6g `U @g vg U g g 0V g g V  h 6h  W @h vh hW h h W h h 8X  i 6i X @i vi Y i i pY i i Y  j 6j @Z `j k Z k t Z t 1u \ 1u }u \ }u u \ u w  ] w L @] P  `   Xa    (b   P b P  c  j e p f (f p : f : ) f ) = g @  
   
   g    Pg   g   d
  9 g 9 ? g ? E g P i g i  g   g   h   
  K 
 P o P
 p  (h    Xh   P
  u P
  I h P  X
   h @   i  . Xi 0 H i H  i   i   i   i    j   Pj    j   j 0  j    K   Tk  = 
 @  k    l   X
   P
   Hl  ] P
 `  xl    A  $ d
 0  K  ( l P  l  Y \m `  l
   P
   l
   tm   m  I 0n P  n   n   o  ( o ( K 0o K / Do 0  \o  B o P  o  \ p \  (p    P
   K 8p P J Xp P  p  / pq 0  q   q    I hs P G t P  u  R u `  u    l
    P
   $u   u   Pv   v  ' x ' 7 { 7 Y< h} `< = @~ = L? ~ P? @ ~ @ <B ~ @B /E 0 0E H   I >J @ @J K x K .M  0M N  N Q   Q U  U Z 0 Z _  _ &t  0t r    H  Ɨ  З 4  
  Ә p Ә e | e f  f    .  0 Κ 0 К ޚ  ޚ h  h i Ȍ i  ،           ۜ      x 0 x y H y  X  	 p  # p #     (  ٞ 8    P     B   P  
  t P   h  ? | ? -  0 Ш  Ш  Џ     g  g t    $  ^ X
 `  P
   p  ο  п  P
  x Ȑ   P
  (  0 R P
 `  P
   P
  , P
 0 o X
 p  X
  8 X
 @  X
   X
  t P
  	 X
   X
  =  @ m p p j i p     P
   0  6 < 6 D P P  P
  ' X
 0  `   Д   P
    
   z P
   (    D    T  - h - n x n ~     
  6  
 @ $  0  ؕ  =    X
  V  `           6  @ r  l
    X  	  	 z
  
 
  
 f @ p Z h `    F
  P
 
  
 :  @  0   X  i h i  |  - (M 0     z X
   X
  j X
 p  X
  O ,
 P  Ț  ^$  `$ 1 @ 1 =A  @A /N @ 0N N (M  O IP ئ PP P X P Q P
  Q Q 8  R )S ` 0S [   \ \   ] O^  ^ )_  0_ uc  c (e  f g   g ;h X @h l  l qm  m !n X 0n n  n Xo  `o p h p .q x .q q  q r  r =s  =s ^s Ĭ `s u Ԭ u Sz  `z ~ 0 ~  P    
   ȯ             d
  T  `     P
   8   L p ҈ X
   P
  % P
 %  \   p     ȋ P
 ȋ .  . U ( `    ύ 8 Ѝ  б  d ܱ d p  p Î  Î     (    8  d o d    ۖ  ۖ     Ĳ  / ܲ 0        v  v  0  
 D 
 ' T 0  d  /  0  ĳ            <  [ L [ y <   l  ߨ l
   l
   J  P  x  I l P    R 8 ` 	   7  @  X   [  `    H 0 P  H   p      & $ 0  8  " ` 0  x     5&  @& & u & -   - -  - . l
 . =8 @ @8 U8  U8 8  8 8  8 W9  W9 .:  .: Q;   `; ~; 0 ~; ; @ ; < \  < >< 0 >< < l < <  < >  > wC  C D @ D PQ  PQ ~T h T a  a a X a b  b b P
 b xc  c Ad  Pd d X
 d e X e f P
 f ff P
 pf f P
 f &g P
 0g g  g g P
  h h P h Ni x Pi i X
 i j  j Oj X
 Pj j  j ek  pk k 0 k Vl X `l l  l n  n p @ p s Z `s ~t  t u  u 4v P
 v v X
 v y   y 7z X @z z P
  { g{ X
 p{ 8~  @~     P
  ? ( @ F T P n  n ԁ  ԁ  8   H      T   ΄ X
 Є !  0 +  0      P
  / ( 0 6 T @ 2  @  (  J  ` ܖ p   N X
 P       E p P    6  @        S x ` ԩ d
  V d
 `     Y A Y       & X
 0 d X
 p  X
  $ X
 0  X
   X
  f X
 p  X
  & X
 0     (M @ V ( ` ɴ P
 д        P  	 P
  Y 0 `    6  @  p    h  ~    X
  \ X
 ` = 8 @ e l
 p    <  <    . 
 0           $   <   P  o ` p  t        C  P \ Ĳ `  d
   d
   q        P
   ? l
 @ O 8 P  (  s
 X 
           4  " T " ' t  ( (  ( Y)  `) ) l
 ) Z4  `4 5   5 o8 ( p8 9   9 G<  P< ?   ? ?   @ ]@ 0 `@ @ 
 @ C  C (D \ 0D F  F G | G G   G DH  PH jH P jH I \ I I x I I  I `J  `J nJ  J J  J K  K K  K K l
 K 
M  M R  R GS  GS T < T AU P PU U ` U 'W t 'W X   X PX  PX `Y  `Y PZ  PZ ]  ] _  _ `  ` a  a a P
 a b l
 b ib  c Zd X d d X
 d ff h pf h  h #i  0i i ,
 i k (M k l    l cm X  pm m X
  n cn X
 pn n P
 n o  o o   o r   r s    s u   u vv P v +w  +w Ӏ  Ӏ    7  @     p   $  y  y    _  ` d  p  `   t         \   `    ˙  Й "  0 8  @  @    
  / P
 / e \ e ף p  ۥ    P
  5  5              4  ̬ < ̬ J P J  l @ T  T       Ѯ  Ѯ i  i     ( 0F (    [  `    V   V   @ h 0F h  (   @   P      d
      	  % 	 0 O P
 P  (	   P	   P
  H 	 P  	   _ X
 `  	   X
    
  : 8
 @  (M   h
  e p
 p  
  V 
 `  
  U  `  8  F ` P    J  J        (M   P
       (   p      m  
 m  4
   H
   s X
   
   
   
   
  &  &    N 4 P - D   d
   T   p       P
   ? l
 @  P
   l
   d
 p    T  ` K  P  $  Q 8 Q e P p Z ` Z  p        @  @    9  9    l   l r  r  $   4  U D U  T   l                                4   	 	 d
  
 
  
 
  ,   h   8  A (M P k I p       6  6 E  E F  P  $   h   x  _  _ r   a  p  (M   G  G     8     u H u  d `    E t E                  S   S       ! H"  P" # X # #  # %  % e&  p&  '   ' '  ' (  ( /( P
 0( (  ( ~) @ ) ) P
 ) ) X
  * ~* p * - P - / Z / &0  &0 1  1 1  1 2  2 3  3 3  3 3 @  4 4 h 4 4   5 5  5 s6  6 6 (  7 7 X 7 7:  @: :   : ;   ; |= 4 = = P
 = = l
  > ? D ? @ l @ @ P
 A }B Z B FE  PE uE  uE JF  JF G  G G 0F G H  H H  H I 0F I 
J ( 
J HJ D 0L DL T DL aL \ aL HM p HM M  M M  M M  M O  O O   P P P
  P P  P nQ 8 pQ Q h  R R  R R X
 R T (M T uU  U U   U fV H pV V p V W  W W  W X  X CY  PY ] ( ] {a p a a l
 a a l
 `e f  f i 0 i =k p @k n   o s  t t  t u , u `v L `v v  v Xw \ Xw Ax | Px y  y ~     (  L Z P  h   |  U  U    c  p         @    P    \   v x  v     Ɣ   Д        p   p     ė   ė ˗  ! З    K ! K Q $! `  4!   P!  # ! #  !  { !  ʫ ! ʫ  !   !    (M  7 " @  X"  ׵ `"  Z " ` { "   (#   4#   `#   p#  < # <  #   #    @$   0F   `$   |$   4 4! 4  $   $  " $ "  $  ' % ' H  % H 0 8% 0 - L% 0  \%   |%   %  < 0F <  %  ) %     ] % ` Z % ` } & } P $& P W <& `  L&    &   &   &  m  ' m s '   ,'  \ h' `  '  3  ' 3  g  ' p    Z   '  L P
   '   
   d
  L P
 L  P
   P
  o P
 p  
  D P
 D } d
   d
   d
   d
  		 d
 	 m	 A p	 	 d
 	 	 d
 	 	 P
  
 
 $( 
 e ' h  P
   P
   P
   d
 0 [ P
 \  d
  
 0( 
 Z \( \ Q ( T  A   
  $ P
 $  h
  i ( l  (   P
 ( j X
 l  P
   P
  r (  4 ( 4 W d
   d
   
  > 
  K ( K y ) y   )   8)  t L) t  \)   l)   ) 0  )   )  , ) , P ) `  )    )  U  ) `  ! ) ! ! *  " k" * " ># * `# $ $* $ 7% 0* @% % 8* % /& P* `& & X* & ' `* ' ' h* ' ' * ' ( *  ( ( * ) }) * ) ) *  * * * * * * * r+ * r+ , * , , + , 8-  + @- - 4+ - - @+ - m. T+ . (/ d+ 0/ / l+ / 	0 + 	0 10 + @0 B1 + P1 1 + 1 2 + `2 2 + 2 \3 + \3 3 + 3 \4 + p4 6  , 6 t7 , 7 7  , p8 8 ,, 8 9 4, 9 9 H, 9 [9 X, [9 g9 l,  ; }; , }; ; , ; ; , ; 9< , 9< X< , X< < , < < , < = , = 8=  - 8= h= - h= = ,- = = <- = > D- > H> X- H> l> p- > > - > > - > (? - (? L? - `? ? - ? ? - ? @ - @ ,@ - @@ @ . @ @ . @ @ $.  A YA <. YA xA D. xA A X. A A p. A A .  B B .  B /B . @B OB . `B oB . B B . B B . B B . B D .  D CE . PE E . E F  / F F / F  G (/ G G 0/ G I 8/ 0I I X/ I I d/ I J x/ J J / J K /  L M / M %N / %N N / N N / N 8O / 8O ?O 0 PO O ,0 P Q 80 PR V H0 V X X0 X X p0 X UY |0 UY Y 0 Y [ 0 [ Z\ 0 `\ 9] 0 @] ] 0 ^ ^ 0 ^ _ 0 _ ` 0  c zc 0 pd e  1  e e 1 e ]f 1 pf f  1  g 3g ,1 @g i 81 i j T1 j j d1 j k x1 k l 1 l l 1 l l 1 l ,m 1 ,m n 1 n n 1 n q 1 q fr  2 pr s 2 s <t $2 Pt t 02 t Bu 82 Bu u D2 u u \2 u u p2 0v w 2 0w cw 2 pw w 2 w Mx 2 Mx ax 2 px x 2 x y 2 y y 2 y y 2 y >z 3 Pz '{ 3 0{ { 3 { p| $3 p| | 83 | | L3 | y} \3  ~ /~ l3 /~ ~ x3 ~ ~ 3 ~ ~ 3 ~ A 3 P  3  * 3 0  3 0  3    3  w 4  > $4   <4 @  H4   T4   \4  O |4 `  4   f 4   4   4  2 4 @  4 ` ߤ  5  ˪ 5  Ӭ 5  . 5 @ ۭ (5  k 45   <5  > D5 P  T5   { `5  ް h5   x5   5 0  5   5    5  + 5 @  5  M 5   5    5  - 5 ` ͷ 5   m  6  
 6 @  6    6 P  ,6   \ 86 p Z D6 ` ` L6 p  \6  2 d6 2 8 x6 @  6   6 @  6  M 6   6   6    6   6 0  6   6  d 6 p  6  &  7 P  7   7  6 7 @   7   ,7    47  ' D7 ' d L7 d j `7 p ^ p7 p  x7  8 7 @ # 7 0  08   8   P9  x 9  H 4: P  :    ;    x;  > ; P  ;   ; 0  ;    <   	 7 	 < @ 	 u 	 <  	  	 <  	 7	 (< @	 w	 0< 	 	 8< 	 	 D< @	 w	 P< 	 	 X< 	 	 `<  	 5	 l< 	 	 x< 	 	 <  	 5	 < @	 u	 < 	 	 <  	 7	 < @	 u	 < 	 	 <  	 7	 < @	 w	 < 	 	 < 	 	 < @	 w	 < 	 	 < 	 	  =  	 5	 = 	 	 = 	 	  =  		 5		 (= @		 u		 4= 		 		 @=  
	 7
	 H= @
	 
	 P= P	 	 \= 	 	 d= 	 	 l= 	 E	 x= 	 	 = 	 
	 = 
	 E
	 = P
	 
	 = 
	 	 =  	 	 =  	 	 = 	 	 P>  	 	 > 	 i	 ? 	 n!	 l? !	 ~%	 ? %	 )	 d@ )	 /	 @ /	 5	 8A  5	 $?	 PA ?	 ?	 A P@	 UA	 A pA	 I	 A I	 O	 B O	 mP	 C P	 P	 C P	 `	 C `	 `	 C `	 `	 C `	 a	  D 0a	 Ga	 D Ga	 Ka	 D Ka	 q	 0D q	 r	 XD r	 r	 hD r	 Vs	 xD `s	 u	 D u	 .u	 D .u	 	 D 	 	 D 	 	 E 	 Ҁ	 E 	 	 @E 	 	 TE 	 [	 `E [	 w	 E w	 	 E 	 Ѝ	 E 	 	 F  	 	 F 	 E	 G P	 B	 G P	 Z	 G `	 O	 G `	 	 H 	 	 (H 	 	 4H 	 '	 TH @	 	 dH 	 f	 pH f	 	 H  	 	 H 	 	 H 	 	 H 	 9	 H P	 I	 H P	 ?	 I P	  
 $I   
 *
 <I 0
 `
 TI `
 
 hI 
 
 I 
 
 I  
 *
 I 0
 B
 I B
 >
 I >
 Z
 I p
 
 J 
 S
 J S
 o
 @J 
 
 PJ 
 
 \J 
 
 xJ  
 ,
 J ,
 
 J 
 
 J 
  
 J !
 ?!
 J P!
 !
 J !
 !
 J !
 M$
 K `$
 E-
 $K P-
 -
 HL -
 B
 XL B
 E
 N E
 _G
 O G
 >P
 $O PP
 Y
 O  Y
 F
 tP P
 \
 P \
 $
  Q $
 A
 ,Q A
 d
 HQ d
 
 `Q 
 
 tQ 
 	 Q  
 7
 Q @
 w
 Q 
 4 Q   R   R  E R P   R  
 ,R 
 G
 4R P
 
 <R 
 
 HR   TR  $ `R 0  hR   pR   xR  E R P  R   R  G R P  R `  R   R   R   U R  > R `  R   R   W R `   S  T S   S  ' S 0  $S @  0S   <S   DS @  PS   XS    `S  ; pS ; F S ` y S y C  S C  _  S     S   " S " "  T " # T # %  T % w& <T & ' XT  ( /( pT @( o( xT ( ( T ) ?) T P) v) LW ) * TW * - W - . X . / X / / X /  : X 0: < X[ < < `[ < y= h[ y= = |[ = (> [ (> > [ > ? [  ? ? [  @ B@ [ B@ @ [ @ @ [ @ &A [ &A A \ A A \ A A 0\ A WB D\ XB uB d
 xB B 0F B SC L\ pC C h\ C F p\ F I \  J "J ( 0J VJ 
 `J J 
 J J 
 K K 
 K L 
 0L YL 
  M NM 
 P P 
 0Q Q  
  R R 
 R ZS  S T   U V 
 QV W  W X 
 aX Y 0  Z Z  Z N[ p P_ v_ 
 d Dd . d Se 4 e >f 4 f 5g 4 g *h 4 h +i 4 k k 
 k .l : ll l 
 l m 
 Xm m 
 pn n 
 n n 
 n o ?  o o @ o o B o Gp C `p p 
 p p 
 p q 
 @q q G q Nr H r r L r Ns L hs s N s s hO t @t HP t  u R u 6u 
 u u 
  v v U  v ;v  V @v [v V `v {v V v v XW v v W v v (X v v X  w w X  w ;w `Y @w [w Y `w {w 0Z w w Z w 
x 
 Ex vx 
 x x 
 y Dy \ y y 
 { 4{ Ha X{ t{ b { { b { { c | | e | } 
 <} e} 
 }} } 
 } } 
 } ~ 
  ~ P~ 
 P~ m~ 
 p~ ~ @k ~   
   - 
 @ n 
   
   Hm   R m   
  ' 
 |  
   
  / 
 L v 
  ҂ 
 ҂  
 , Z 
 ܃  
 4 ! x   ؅  Ԍ 8  ) 
 a  
 ʍ  
 3 d 
  Ɏ p  4 ` @ d   p     
       
   
   
 L } 
   ؠ M ~ 
   
  G ؠ  ƕ ؠ  ݖ 
 \ } Ȧ  ޗ 
  G 
   Ȧ   Ȧ `  H   J  0 Z 
 p  
  ڛ 
   X ( Y 
  ܜ    ) 
 U  @       
  ۞ 
  	 
 9 j 
  a X m  
 ʠ d X   X   X   
   ( t     
 t   Ԩ    D _ 8   `     t  ( ԫ  P D _ h     ح  D u 
  ޮ 
  G 
   
     `      
 ! R 
   
  $ 
 \  
 Ų    g   Z X  j H   
  ڵ 
  6 
   
   
   * 
  
 
   H D   0    ` H @  x `     ^  `  p   
 M ~ 
   
  P 
   
      
       
       Z H ` | 
 |     h   
       < 
 < \  ` | 
 |  @         < 
 < ` H      J  p     x   
  j     
   
 `  
   * 
  , ( , C 
 C _ 
 _  |   (8  " 8 . T H9 l  9   ,:   : G p ; |  p;   ; ?  C   F  M G e  0L   8L   N  M N M j N j  N   N   N  P N \  O   lP & _ V _  V   V  - V -  V   V   V  z V z  W  2 W 2 k ,W k  <W   xX L i P[ @  d
  s d
   d
    d
  S d
 `  d
   m d
 p  d
  
 d
   m d
 p  d
  
 d
 , W d
                                                                                                                                                                                                                             1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `                     <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                    ȪЪت  (08@HPX`hpxȫȬЬ  (0PX`hpx@HPX              PX`hpx        (08@HPX`hpxȠРؠ  (08@HPX`hpxȡ  (08@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPX`hpxȤФؤ  (08@HPX`hpxȥХإ  (08@HPX`hpx  (08@HPX`hpxȧЧا  (08@HPX`hpxȨШب  (08@HPX`hpxȩЩة  8@HPX`hpxȫЫث  (08@HPX`hpxȬЬج  (08@HPX`hpxȭЭح  (08@HPX`hpxȮЮخ  (08@HPX`hpxȯЯد    $    (08@HPX`hpxȠРؠ  (008@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPȤФؤ  (08@HPX`hpxȥХإ  08@HPX`h (08@HPX`hpxا  (08HPX`hب  (08@HPX`hpxȩЩة  (08@HP`hpxȪЪت  (08  
      (08@HPX`hpxȥХإ  (08@HPX`hpx 
    H`h       @HPPx 08ȣ8X`Ȥh@HPhpxȦ08@X`hЧا   (8    @   hب 8Hx (hتxH       px Уأ  (0HPXpxȤФ 8@H8PاX8PЪتX  (@H`hxȭ  (8@HX`hxȮخ  (@H`hȯ  \    (@H`hȠ08 (HPpxȤ8@`hإ (0PXxȦЦ @Hhp08X`Шب  (HPpxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد     (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp08X`Чا  (HPpxȨ8@`hة (0PXxȪЪ @Hhp08X`Ьج  (HPpxȭ8@`hخ (0PXxȯЯ  $   @Hhp08X`Сء  (HPpxȢ8@`hأ (0PXxȤФ @Hhp08X`Цئ  (HPpxȧ@H`pШب08PXЩ(` PЫ  Hp    X    pТ@0XХ X@p @X0p0h`    H    `@pФPx0P 0` HpЭ     H   p@آ`p` h `Ь0`HP 0 8   Ƞ @@8h @(pЪ0 P @ (   8p(P0X P                                                                                                                                                                                                                                                                                                                                                                                                                               ub.