e     pystan.model	StanModel)}(
model_cppname+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2
model_name+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2
model_codeXy  functions {
  real[ , ] get_changepoint_matrix(real[] t, real[] t_change, int T, int S) {
    // Assumes t and t_change are sorted.
    real A[T, S];
    real a_row[S];
    int cp_idx;

    // Start with an empty matrix.
    A = rep_array(0, T, S);
    a_row = rep_array(0, S);
    cp_idx = 1;

    // Fill in each row of A.
    for (i in 1:T) {
      while ((cp_idx <= S) && (t[i] >= t_change[cp_idx])) {
        a_row[cp_idx] = 1;
        cp_idx = cp_idx + 1;
      }
      A[i] = a_row;
    }
    return A;
  }

  // Logistic trend functions

  real[] logistic_gamma(real k, real m, real[] delta, real[] t_change, int S) {
    real gamma[S];  // adjusted offsets, for piecewise continuity
    real k_s[S + 1];  // actual rate in each segment
    real m_pr;

    // Compute the rate in each segment
    k_s[1] = k;
    for (i in 1:S) {
      k_s[i + 1] = k_s[i] + delta[i];
    }

    // Piecewise offsets
    m_pr = m; // The offset in the previous segment
    for (i in 1:S) {
      gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
      m_pr = m_pr + gamma[i];  // update for the next segment
    }
    return gamma;
  }
  
  real[] logistic_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[] cap,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    gamma = logistic_gamma(k, m, delta, t_change, S);
    for (i in 1:T) {
      Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta))
        * (t[i] - (m + dot_product(A[i], gamma)))));
    }
    return Y;
  }

  // Linear trend function

  real[] linear_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    for (i in 1:S) {
      gamma[i] = -t_change[i] * delta[i];
    }
    for (i in 1:T) {
      Y[i] = (k + dot_product(A[i], delta)) * t[i] + (
        m + dot_product(A[i], gamma));
    }
    return Y;
  }
}

data {
  int T;                // Number of time periods
  int<lower=1> K;       // Number of regressors
  real t[T];            // Time
  real cap[T];          // Capacities for logistic trend
  real y[T];            // Time series
  int S;                // Number of changepoints
  real t_change[S];     // Times of trend changepoints
  real X[T,K];         // Regressors
  vector[K] sigmas;     // Scale on seasonality prior
  real<lower=0> tau;    // Scale on changepoints prior
  int trend_indicator;  // 0 for linear, 1 for logistic
  real s_a[K];          // Indicator of additive features
  real s_m[K];          // Indicator of multiplicative features
}

transformed data {
  real A[T, S];
  A = get_changepoint_matrix(t, t_change, T, S);
}

parameters {
  real k;                   // Base trend growth rate
  real m;                   // Trend offset
  real delta[S];            // Trend rate adjustments
  real<lower=0> sigma_obs;  // Observation noise
  real beta[K];             // Regressor coefficients
}

transformed parameters {
  real trend[T];
  real Y[T];
  real beta_m[K];
  real beta_a[K];

  if (trend_indicator == 0) {
    trend = linear_trend(k, m, delta, t, A, t_change, S, T);
  } else if (trend_indicator == 1) {
    trend = logistic_trend(k, m, delta, t, cap, A, t_change, S, T);
  }

  for (i in 1:K) {
    beta_m[i] = beta[i] * s_m[i];
    beta_a[i] = beta[i] * s_a[i];
  }

  for (i in 1:T) {
    Y[i] = (
      trend[i] * (1 + dot_product(X[i], beta_m)) + dot_product(X[i], beta_a)
    );
  }
}

model {
  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  y ~ normal(Y, sigma_obs);
}

model_cppcodeXH  // Code generated by Stan version 2.17.1

#include <stan/model/model_header.hpp>

namespace anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unknown file name");
    reader.add_event(157, 157, "end", "unknown file name");
    return reader;
}

template <typename T0__, typename T1__>
std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
get_changepoint_matrix(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        vector<vector<local_scalar_t__> > A(T, (vector<local_scalar_t__>(S)));
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        current_statement_begin__ = 5;
        validate_non_negative_index("a_row", "S", S);
        vector<local_scalar_t__> a_row(S);
        stan::math::initialize(a_row, DUMMY_VAR__);
        stan::math::fill(a_row,DUMMY_VAR__);
        current_statement_begin__ = 6;
        int cp_idx(0);
        (void) cp_idx;  // dummy to suppress unused var warning

        stan::math::fill(cp_idx, std::numeric_limits<int>::min());


        current_statement_begin__ = 9;
        stan::math::assign(A, rep_array(0,T,S));
        current_statement_begin__ = 10;
        stan::math::assign(a_row, rep_array(0,S));
        current_statement_begin__ = 11;
        stan::math::assign(cp_idx, 1);
        current_statement_begin__ = 14;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 15;
            while (as_bool((primitive_value(logical_lte(cp_idx,S)) && primitive_value(logical_gte(get_base1(t,i,"t",1),get_base1(t_change,cp_idx,"t_change",1)))))) {

                current_statement_begin__ = 16;
                stan::math::assign(get_base1_lhs(a_row,cp_idx,"a_row",1), 1);
                current_statement_begin__ = 17;
                stan::math::assign(cp_idx, (cp_idx + 1));
            }
            current_statement_begin__ = 19;
            stan::math::assign(get_base1_lhs(A,i,"A",1), a_row);
        }
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(A);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct get_changepoint_matrix_functor__ {
    template <typename T0__, typename T1__>
        std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
    operator()(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) const {
        return get_changepoint_matrix(t, t_change, T, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
logistic_gamma(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 28;
        validate_non_negative_index("k_s", "(S + 1)", (S + 1));
        vector<local_scalar_t__> k_s((S + 1));
        stan::math::initialize(k_s, DUMMY_VAR__);
        stan::math::fill(k_s,DUMMY_VAR__);
        current_statement_begin__ = 29;
        local_scalar_t__ m_pr;
        (void) m_pr;  // dummy to suppress unused var warning

        stan::math::initialize(m_pr, DUMMY_VAR__);
        stan::math::fill(m_pr,DUMMY_VAR__);


        current_statement_begin__ = 32;
        stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
        current_statement_begin__ = 33;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 34;
            stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 38;
        stan::math::assign(m_pr, m);
        current_statement_begin__ = 39;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 40;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
            current_statement_begin__ = 41;
            stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
        }
        current_statement_begin__ = 43;
        return stan::math::promote_scalar<fun_return_scalar_t__>(gamma);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_gamma_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) const {
        return logistic_gamma(k, m, delta, t_change, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
logistic_trend(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 57;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 58;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 60;
        stan::math::assign(gamma, logistic_gamma(k,m,delta,t_change,S, pstream__));
        current_statement_begin__ = 61;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 62;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (get_base1(cap,i,"cap",1) / (1 + stan::math::exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))));
        }
        current_statement_begin__ = 65;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) const {
        return logistic_trend(k, m, delta, t, cap, A, t_change, S, T, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
linear_trend(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 80;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 81;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 83;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 84;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 86;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 87;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (((k + dot_product(get_base1(A,i,"A",1),delta)) * get_base1(t,i,"t",1)) + (m + dot_product(get_base1(A,i,"A",1),gamma))));
        }
        current_statement_begin__ = 90;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linear_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
    operator()(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) const {
        return linear_trend(k, m, delta, t, A, t_change, S, T, pstream__);
    }
};

class anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
    int trend_indicator;
    vector<double> s_a;
    vector<double> s_m;
    vector<vector<double> > A;
public:
    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 96;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 97;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 98;
            validate_non_negative_index("cap", "T", T);
            context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
            validate_non_negative_index("cap", "T", T);
            cap = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("cap");
            pos__ = 0;
            size_t cap_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
                cap[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 99;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 101;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 102;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 103;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "trend_indicator", "int", context__.to_vec());
            trend_indicator = int(0);
            vals_i__ = context__.vals_i("trend_indicator");
            pos__ = 0;
            trend_indicator = vals_i__[pos__++];
            current_statement_begin__ = 106;
            validate_non_negative_index("s_a", "K", K);
            context__.validate_dims("data initialization", "s_a", "double", context__.to_vec(K));
            validate_non_negative_index("s_a", "K", K);
            s_a = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_a");
            pos__ = 0;
            size_t s_a_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_a_limit_0__; ++i_0__) {
                s_a[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 107;
            validate_non_negative_index("s_m", "K", K);
            context__.validate_dims("data initialization", "s_m", "double", context__.to_vec(K));
            validate_non_negative_index("s_m", "K", K);
            s_m = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_m");
            pos__ = 0;
            size_t s_m_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_m_limit_0__; ++i_0__) {
                s_m[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 95;
            current_statement_begin__ = 96;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 97;
            current_statement_begin__ = 98;
            current_statement_begin__ = 99;
            current_statement_begin__ = 100;
            current_statement_begin__ = 101;
            current_statement_begin__ = 102;
            current_statement_begin__ = 103;
            current_statement_begin__ = 104;
            check_greater_or_equal(function__,"tau",tau,0);
            current_statement_begin__ = 105;
            current_statement_begin__ = 106;
            current_statement_begin__ = 107;
            // initialize data variables
            current_statement_begin__ = 111;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            stan::math::fill(A,DUMMY_VAR__);

            current_statement_begin__ = 112;
            stan::math::assign(A, get_changepoint_matrix(t,t_change,T,S, pstream__));

            // validate transformed data
            current_statement_begin__ = 111;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 116;
            ++num_params_r__;
            current_statement_begin__ = 117;
            ++num_params_r__;
            current_statement_begin__ = 118;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 119;
            ++num_params_r__;
            current_statement_begin__ = 120;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_db8febf10f23d7fa27a62fbcfd7f17b2() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            local_scalar_t__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<local_scalar_t__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            local_scalar_t__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<local_scalar_t__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(trend[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: trend" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(Y[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Y" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_m[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_m" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_a[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_a" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // model body

            current_statement_begin__ = 149;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 150;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 151;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 152;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
            current_statement_begin__ = 153;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 156;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("trend");
        names__.push_back("Y");
        names__.push_back("beta_m");
        names__.push_back("beta_a");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(trend[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(Y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_m[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_a[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 stan_model;

module_nameGstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581module_filenameZstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.cp36-win_amd64.pydmodule_bytesB  MZ                @                                      	!L!This program cannot be run in DOS mode.

$       5F^q'0q'0q'0x_'0z1s'0Jy3w'0Jy4z'0Jy1u'0Jy5b'0y1r'0q'1&0y9p'0y0p'0yp'0y2p'0Richq'0                PE  d	 L\         "     "                                    P         `                                   p|    L}     0      Ho           @ h  
                    
 (   
              
                          .text                           `.rdata                     @  @.data   `                     @  .pdata  Ho     p   B             @  @.gfids  <                       @  @.tls    	                      @  _RDATA                         @  @.rsrc       0                  @  @.reloc  h   @                  @  B                                                                                                                                        H(H
eS  A   HgS    H| HMS     H
6S /S   H
C H( H(H
R 耾 A   HR    H< HR     H
vR oR  z H
 H(R H(H
Q   A   HQ    H HQ     H
Q Q   H
 H( H(
 : Q H(H(
 9 P H(`
 ^P P H(l
 9 P H(H(
 9 P H(xP W
 Q H(
 ]9 @9 WS
 Q H(P X P P H(H
UQ 谼 A   HWQ    HT H=Q     H
&Q Q   H
 H( H(H
P P A   HP    H H}P     H
fP _P  J H
3 H(" H(H
eO  A   HgO    H HMO     H
6O /O   H
s H( H(H
mm 萻 WHjm     H
 Km H( H(H
eo P WHbo     H
 Co H(B H( WHYo     H
 :o H(	 H(G2  H
P H( H(H
l  WHl     H
 l H( H(H
l 耺 WHl     H
; l H(r H(H
m @ WHm     H
 m H(2 H( H
p H( H( H
@ H( H('  
  T
 f/3
 v  "     
  TԎ
 f/
 v  "   H(H(Y H(H(W H(體  鋓 H(X H(
 s p
 3 H(\
  H(H(<
 O H(H
-  @SH HHHSH
 H3H
HJHH HH [HQ HHH%+ HQH
 
 HHEH\$WH H HHH t
   H HH\$0H _3HAH HAH HH  H(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH(R @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ H HHH0[@SH HHHSH
 H3H
HJHH H4 HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0 HT$0   HC   HsH{rHH  Hy @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" HA HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HHL$pH3L L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtH' H/ uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIH/ uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H- HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v H7 @H$   H3 L$   I[0Ik8IA^_^́aHI    Ha H@USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtHu B-   H~  HIHP   Hp  i HIHPH
m H HEH  + HH2 }+ HI/ HH  c+ HI/ HH I+ HHn/ Hp  Hp  K HHxrHH_ HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ H	W HL$  HIHP   Hp  ^ H H  * HH@ * HI. HH q* HI. HH W* HH|. Hp  Hp  Y HHxrHHm HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ HV HL$  HMHT$HHPHT$PLL$HI+HLHGI+HH;  HL$pH H HM) HH- x) HI- HH ^) HI- HHQ D) (HMY+ 3ۋHGH+HHt9D  Ht,HM0+ HHHM HHGH+HH;r̲)HM+ H: HM( (HM* HD$PHL$HH+HHt<Ht,HM* HL$HHHM= HHD$PHL$HH+HH;rĲ)HM* Hp  HL$px HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ H6T HL$  3ۋH   IM+     HI9uHHH;r  HMpm H5 H   ' HHO ' HI+ HH ' HI+ HH f' HH
 HHX K' (H   ]) HHGH+HHt:Ht,H   7) HHH    HHGH+HH;rƲ)H   ) H; H   & (H   ( HD$PHL$HH+HHtBHt,H   ( HL$HHH   2 HHD$PHL$HH+HH;r)H   {( Hp  HMpk HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ H)R HL$  MtLD$XM+II H  H3 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H讪 HHHH\$@H0_H\$Ht$WH0HD$        IHf HHHH\$@HpHHt$HH0_@SH H HHt
   V HH [@SH H   H HH [H% HL$UVWAVAWH0HD$ H\$pILHH HHqHt$hE3L>L~$ HH_H\$hL;L{# HL(L0L8L@LHLPLXL`LhI;t8HHRH! HH@HH HH@L~DD$`IH˛ H;t9HHRH' HH@HH HH@L{DD$`HHޚ HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP HW yI^I;^u3HIN͙ HI;FtHP H( yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H辫 yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP HH tHHH;t-IM轘 HH;tHP H yHHS@   IM萘 HI}H;tHP H tHH;   HIMY HH;tHP H赪 tHHS@HL$H͎ H|$PH\$HH+HHHL$0讦 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH\ IU(I莥 IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP H裩 yHHH;t*IO HH;tHP Hw yHHSX?IO IHH;tHP HI yHH;tHIO IWXH蓤 H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP H质 yI_I;_t/HIO* HI;GtHP H腨 yI_HS@IW@H蛌 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI處 HI;GtHP H yI_I;_t/HIOj HI;GtHP Hŧ yI_HSXIWXH H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3聛 HGHH;tiD  HS Hd { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3њ HGHH;tiD  HS H贙 { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   Hb HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+I H_@H_HH_PHW(HtLG8L+IN H_(H_0H_8LGHT$0MHOM J HO LGHT$0MHOM  HO H\$8H HH _@SH LHT$0MHM  HH [7 @SH LHT$0MHM  HH [ H H@SH Hs HHt
    HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH H HHt
    HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH HӾ HHt
    HH [@SH H˷ HHt
    HH [H(HIc HHy H(H% @SHPHD$ HR H3HD$HHHHT$(H HHK HH  HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3X HP[H(HIs HH H(H% @SHPHD$ Hb~ H3HD$HHHHT$(H HHK HH(  HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3h HP[H(HI HH H(H% @SHPHD$ Hr} H3HD$HHHHT$(H HHK" HH8  HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3x HP[H(HI  HH H(H% @SHPHD$ H| H3HD$HHHHT$(H/ HHK 2 HHH  HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3 HP[H(HI( HH H(H%& @SHPHD$ H{ H3HD$HHHHT$(H? HHK(B HHX ʽ HD$@HrQHHL$(H=   r<t# HAH;r H+Hs H'v H HL$HH3 HP[@SH H HHt
0    HH [H HH	 H\$WH Hw HHHM t
(   H HH\$0H _@SH HHHSH
! H3H
HJHH H< HHH [HI H@SH H3 HHt
    HH [@SH H HHH贝 H HH [ K H(HQHI? HHU H(H%» @SH HHQHI
 HH HH H [H% H\$WH H׸ HHH H' Ht
0   H HH\$0H _23HHBHBH@SH HHRH;c HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+Ib HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iѹ WD$0Hl$@@tHT$HHtLD$XL+I袹 HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iq WD$0Hl$@@tHT$HHtLD$XL+IB HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Ia WD$0Hl$@@tHT$HHtLD$XL+I2 HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWH% HL$8Ht HT$@] LD$HHT$8L+I: H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWH腞 HL$8Ht HT$@0] LD$HHT$8L+I H\$`HP_@SH Hˣ HHt
   6 HH [H\$Ht$WH Hʮ HH3HIPH*Ht:HSX_ HK`HH+KPHHLI?LHSP H{PH{XH{`HS8HtLCHL+I H{8H{@H{HHK Ht:HS(n_ HK0HH+K HHLI?LHS 虲 H{ H{(H{0HKHt)HS[ HSLCL+IW H{H{H{Ht$8H HH\$0H _@SH HYLHIHN H;H [Hl$Ht$AVH0HHHQE3HIDt$ UN H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHHt Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ M H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQH遇 @SH0HD$     HQ8H賍 HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI~ D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0L I?HHD$0H;t?HHtLGL+I L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H HHHIVI+H*HHHH?HH;s(  { t m IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   HR HH\$0H _@SH  HD$HHl H3H$p   HH      HL$P' Hw HL$`e HH	 HH  H$P  HL$PW HxrH H
m HL$ 3HL$(HL$0HD$8D$@HT$(HL$8 Hۯ HD$ H2 HL$  H$p  H3 HĀ  [HL$WH@L= HH
m= IL
s= LL+Q= ILv= M;s$K9<sIHH+-= HLR= L;rH\$XHt$hM;~  H#= HpHH;HBHHt$`hH< HHD$PHD$PH;sNH
< HD$PH;w=H\$PH+HH;< uH
< = H< Ht;H< HH
$H;< uH
q<  Hm< Ht
HH^< HHS< Hz    H
Y< HD$`L
E< H;sLHD$`L;wBH\$`I+HH;
3< u   H
< 8 H
< L
< HtGIH0H;
; u   H
;  H
; L
; HtH1H
; L
; L; HH
; H; Ht$hH\$XJH8H
; KHH; H@_3H- HD$0HL$ H HD$(HҶ HD$ . HT$HL$WH@HD$ H\$hHD$X   H=: H|$`   dHD$PWf: 3H: LD$P H: Wf: LD$XH
:  H: H: H
HL$XH
: HH: H: Wf: f: H: H: f: H9u13HD$8H HD$0HƵ HD$(H+ HL$( HH\$hH@_H\$WH H9 3H
9 HH+HHt7D  HHtHf H9 H
9 HHH+HH;rH: HH   H: H+HH;v H    H=   r<t׬ HBH;rǬ H+Hs H'v HH H
9 Wf9 H=u9 HV9 H   HV9 H+HH;v\ H    H=   r<t@ HBH;r0 H+Hs  H'v HH/ H
x8 Wf8 H=8 H8 H   H8 H+HH;vū H    H=   r<t HBH;r H+Hs H'v| HH H
7 Wf&8 H=8 H7 H   H7 H+HH;v. H    H=   r<t HBH;r H+Hs H'v HH H
J7 Wf_7 H=P7 Ht}H<7 H+HH;v H    H=   r<t HAH;rv H+Hsf H'vY Hx WH=6 f6 H\$0H _L6 L96 u0H6 H6     HH6 H6 H HH6 I@IHH
6 H
6 HHo6 HH
6 H
6 HHc6 HHQ6 H
6 @SH HHHSH
 H3H
HJHH H| HHH [@SH H۔ IHHHA    HD$0H5 HL$0H;sdH4 HL$0H;wSH|$8H|$0H+HH;4 u   H
4 n H4 H4 HtHHH4 H|$80H;4 u   H
y4 , Hu4 Ht
HHf4 HHHX4 H [H H@SH H HHـu
   HH [@SH@HD$ )t$0(HH4 HHH4 H;4 r
   HHL$PHt
(3HH(t$0H@[HH3H% HD$0HL$ H HD$(H HD$  H\$ WH Hb H3HD$3LnA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HAO  ATO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3g H\$HH _M  N  N  +N  7N  CN  ON  N  N  [N  gN  sN  N  N  N  N  N  N  N  N  N  N  N  N  N  O   	
	
	
 	


	

@SH@eH%X   H)t$0(1
    )|$ (=_O
 Hȋ
9/    f]5tP
 f_5LU
 fYfX=0N
 ffT=|N
 f\(|$ ((fY
K
 fY-N
 f\ff\fy/ (frfYfpc((fY%K
 fY
K
 fX%L
 fX
L
 fYfYfX%N
 fX
ZM
 fY(t$0fYfX
N
 f\f^fY%N
 fX%M
 fYf_H@[H
. / =. foJ
 H
. f. 覴 @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH H HHـu
(   HH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLHb, HH(HT, H;E, r
(   HHt$@Ht*H?HOXKHH^H~ H% HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^H+ HH(H+ H;+ r
(   HH|$`Ht&H(XKHNH_w Hތ HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(HWf.z
uI H^H* HH(H* H;* r
(   HH|$XHt&H(XKHH_w H. HH>HH\$PHt$`(t$0H@_HIHII      AD$HD$I#I;w]HB HL$HD$I#I;wAB^XAAHJ HBAHYJY^A\AI      LAHB L@HA IYI@Y^@\@AVH0HD$ H\$HHt$PH|$XIHLHr) HH(Hd) H;U) r
(   HHt$@Ht*H?HK^OHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$XHt$`)t$0I(HH( HH(H( H;( r
(   HH|$PHt&H(^KHqwH_ HA HH>HH\$XHt$`(t$0H@_AID$I      HD$I#I;w,HQ BD$HD$I#I;wB\ABHA H      HH@WH@HD$ H\$XHt$`)t$0I(HH' HH(H' H;' r
(   HH|$PHt&H(\KHawH_ HA HH>HH\$XHt$`(t$0H@_HIHII      AD$HD$I#I;wHHB @D$HD$I#I;w,YBXAAHBHJ @YBXAAI      LAHB L@HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH& HH(H% H;% r
(   !HHt$@Ht*H?HOYKHH^H~ HE HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHf.=
 z
uHH^H>% HH(H0% H;!% r
(   ]HH|$`Ht&H(YKHH_w H HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(Hf.
Y<
 z
uI H^H~$ HH(Hp$ H;a$ r
(   HH|$XHt&H(YKH-H_w H5 HH>HH\$PHt$`(t$0H@_HQIBD$HD$I#I      I;vH      HBB\AB@SH Hx HHـu
    +HH [@WH0HD$ H\$HHt$PHHHZ# HH HL# H;=# r
    yHH|$@Ht%HKW
E
 HH_Hr HH>HH\$HHt$PH0_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH Hx HHـu
0   +HH [@SH HHHSH
 H3H
HJHH H HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3[ H+` HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$H4 HHoHH$   Hp_^]H	H% @USVWAVHl$H  HD$PHuO H3HEpMA؋H   D$     H HD$`HM D$    E3E3HT$hHL$`R HD$`HcHHa HD`HD$`HcHxT\   HL$h" H HL$` HH q HH b Hȋ HHͷ H HH 9 HȺ    HHy  Hȋѐ HI HH HUPHL$`M HxrH H
# HL$(3HL$0HL$8HD$@D$HHT$0HL$@p H) HD$(H HL$(Y @SH H   H HH [H%̐ @SH HHHSH
 H3H
HJHH H HHH [E   Hx  HD$8HXM H3H$`  DL$0HL$@ H HL$P HH  H$@  HL$@} H$@  H$X  HC$@  HD$ L
l LD$0H H
 T HWHp  HD$0HXHpHL H3H$`  AAH$  A|A@;|iHL$@~ H HL$P
 Hȋ$   H$@  HL$@} L$@  H$X  LC$@  Ht$ DË~H$`  H3譠 L$p  I[IsI_E  SVWH  HD$HHK H3H$p  AHHHL$P} H HL$`= HH . HH# HHQ  HH	 HH  Hȋ H$P  HL$P{ H$P  H$h  HC$P  H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8P H9 HD$ He HL$ 9 @SH HHHSH
 H3H
HJHH H HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu(( (
 D$T$f (fYfYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX(f^(( (
 D$T$f (fYfYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX(f^(H8W)t$ f/(vbWd<
 9
 
3
 f/D$@   f.z$u" !4
 X "   (t$ H8 X(t$ H8
 
3
 f/D$@wHf.z u 3
  "   (t$ H8(t$ H8H% LD$@H q LD$@H wq HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3 HV HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHMۯ IwHu@HH^H^uHtFHHHH;t_LLMt32 IV HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHM I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM7 HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMH豭 H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHX_-
 LqWMHHEIHEI~Ht3Ї HS HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHML LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHMB L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;t\IHHt3/ HQ HELuH}LE7HUHM LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHM`B HMn HMc L$   I[(Is0I{8IA_A^]LWH   H
~*
 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tH Ht
HXP HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0{ H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3[ H+O HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHM; I~H}@HH_uHt3 HN HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHM訧 I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHMu H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHX/&
 LqWMHHEIHEI~Ht3 HpL HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHM; LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM.= HM~ L$   I[(Is0I{8IA_A^]LWH   H
#
 f/   HA\I[3IsHq ICD$hH9rt"H
e~ Ht
H0J HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0k H$   HĀ   _@SH HHHSH
q H3H
HJHH| H HHH [AYAHAX@@@WH0HD$ H\$HHt$PHHH
 HH H
 H;
 r
    HH|$@Ht&HC
 (HdH_Hi HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HH/u HHGH+HH    Hz	 HHHm	 H;^	 rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDH HH(H H;{ r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHM HMHM 8F HELELEHM HMLHUNL+t	H'
 HMF LHEHMHMHULL+t	H
 WD$PH}LHt3y HE HHD$PH}HL$PLt$X3L;t-y HtHE HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$`f =f
    HEH   L   LD$PHH     H9V~EH(
 (
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3px HtH;D HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$` HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HU HD$@HD$`H|$HHFH;t'H;tHPw Ht
HC HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM) HL$@v HL$Pv Iv HMv HMv HMv HMv L$`  I[0A(sA({IA_A^_^]@SH HHI(Ev HK;v HH [H%,v H\$Ht$WH@HY)t$0Hay H\$PHHHJ()|$ H(A HLGLCHLGIL+LtH
 H\$XH~(|$ v Ht$`(t$0H@_Hx HHIH%u @WHPHD$ H\$hHt$pHH1 H3HD$HHHD$@   3Ht$8@t$(DFH HL$(+ HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVH HH;HKHtdHA   HqHyrHHH<H;Cu
   H賅 HKHt(HA   HqHyrHHHT$(  R HC HD$@HrQHHL$(H=   r<t/u HAH;ru H+Hsu H'vu H! HD$@   Ht$8D$( A
   H HL$( HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H HH;HKHtdHA   HqHyrHHH<H;Cu
   H} HKHt(HA   HqHyrHHHT$(   HC HL$(-S HL$HH3 H\$hHt$pHP_H\$WH H_v HHHIr t
(   H HH\$0H _Hj H@SH Hj HHt
   覊 HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHHu H\$0HHHJ= HLFLCHVLFIL+LtH
 HFH\$8HGHF Ht$@HG HH _HQr HHt H\$WH H'r HHH^t t
(   H蔉 HH\$0H _@SHPHD$ HB- H3HD$HHHD$@   HD$8    D$( A   H HL$(! HHHT$(PHD$@HrQHHL$(H=   r<tq HAH;rq H+Hsq H'vq H赈 HL$HH38 HP[HWH@H@HXHhHpIHHW@3HpVHHA LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
 m IPL+IIHL+IM;HCH;HCHL$(茨 LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
R l IPL+IIHL+IM;HCH;HCHL$( LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+I7 H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xHZ* H3Hp  I((Hǅh     Hǅ`      ƅP   A   H HP  ) HHPH0  S\ HP  H@   H(+l HHٔ t H0  H0  Z LHHAPHH  HrSHH0  H=   r<tpn HAH;r`n H+HsPn H'vCn Hb HM0[ HǅH     Hǅ@      ƅ0   A H`  H0   H0  HM@ H(@k HH  HH  HrSHH0  H=   r<tm HAH;rm H+Hsm H'vym H蘄 H0  HM08Y LHHAPHH  HrSHH0  H=   r<t'm HAH;rm H+Hsm H'vl H HL$0OZ HǅH     Hǅ@      ƅ0   A H`  H0  軆 XH0  HL$@ H(i HHϒ : HH  HrSHH0  H=   r<tWl HAH;rGl H+Hs7l H'v*l HI H0  HL$0W LHHAPHH  HrSHH0  H=   r<tk HAH;rk H+Hsk H'vk Hɂ HHPHMW HMi H   W H   i H  eW H  hi Hh  HrSHHP  H=   r<t%k HAH;rk H+Hsk H'vj H Hp  H3z L$  I[A(sA({I]HUSWHHH  HD$ )p)xH% H3Hp  ((HHǅh     3H`  @P  DGH[ HP  o HǅH     H@  @0  E3HY H0  ? HKHH0  P HH  HrSHH0  H=   r<ti HAH;ri H+Hsi H'vi H̀ H0   W HP  H@  l H(f HH ! HKHH0  PHM0V HǅH     H@  ƅ0   A H`  H0  ' H0  HM@ H(bf HH( 諽 HH  HrSHH0  H=   r<th HAH;rh H+Hsh H'vh H HKHHU0PHL$0U HǅH     H@  ƅ0   A H`  H0  R XH0  HL$@ H(e HHf Ѽ HH  HrSHH0  H=   r<tg HAH;rg H+Hsg H'vg H~ HKHHT$0PHǅH     H@  ƅ0   E3H H0  袂 HKHH0  P HH  HrTHH0  H=   r<t=g HAH;r-g H+Hsg H'vg H/~ HMS HMe H   R H   d H  R H  d Hh  HrSHHP  H=   r<tf HAH;rf H+Hstf H'vgf H} Hp  H3v ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHHV HHqHt$`3H.HnHcڅt3 e H0 HH^HwHt$`H.HnHt3d H0 HH^Ho(Hw0Ht$`H.HnHt3d Ht0 HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHHU HHrHyH|$hE3L'LgHt3 d H/ HHwLu HsHt$hL&LfMt3c I/ HLvHE(HC(L}8Ls0Lt$hM&MfMt3c I/ IM~HUH% HUH HU0I
 HH\$pHl$xH0A_A^A\_^H\$WH HHHH HC(HSHOHG( HS0HO0 H\$0HH _@UVWATAUAVAWHpHD$ H$   H H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHn4 HcH;U|H
z ,` EL9e#  IIf     HD$@   Ld$8D$( A   H HL$(F~ IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH萦 HwHtoHF   LfH~rHH  H{sLCItHH4` 	HHL#HCHFHCHFHC   H{LcrH HG HL$H@ HL$(@ AIcH;]}/H
 ] H
x ] H
J ] AH9u   I HD$@   Ld$8D$( A   Hh HL$(&| IIFH+HH;vJHLHT$(HL$H HH5 HL$H? HL$(? HcH;]zH
 S] HL$hH3=p H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHH: HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;ICw HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;IC HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC7 HSHt
HHH
HB   H
4 nZ H
& `Z LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC蚕 HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
q Y H
c Y HL$VWATAVAWH0HD$ H\$hHl$xHcLHw^ II~@H|$pE3L'LgLgIHtIHHH;tHHHt3[ H' HH_H_LHMI;~NL    
 
 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHZ Mt
It& HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@Y H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx H H3HE`LHE3ADt$ HEX   LuP@}@EF Hɀ HM@u IE HU@IPHEXHrPHHM@H=   r<t$Z HAH;rZ H+HsZ H'vY Hq Aމ\$$H9^H  ML=CT HD[ H
^ HL$@HT$PHM	X |$ E3HT$XHL$@W HD$@HcHHX HD@HD$@HcHhT<HD$XHD$0HL$X0U L|$XLuDuHF@BHL$PV A   EL9vP~S@ ff     H~@H^HIIH HL$P谭 HJV AIIcH;FP|Ë\$$|$ HU@HL$@D ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   Ho HD$@HcHH~W HD@HD$@HcHhT<L=R L|$XHL$XP~ HL$X-V HL$`jU HM V É\$$IHcH;FH}$E3W W W W HM`H3~g L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0V HKV HKH [H%V @SH HH   T H   HLcBADuluHT$0T H [T H   HLcBADuLt2H [H\$WH HH   HT$0O L   I HcHBDuT$0@:tI>T 2H\$8H _ðH\$8H _@SH HHT$0H    L   I HcPBDt2H [L$0V tT$0HK H|$84 H   HT$0S HHcQDu@fD  L$0V u8L$0vV u)T$0_t$.tH   ^S H|$8H [T$0HK +4 H   HT$0AS HHcQDtH|$8H [@SH HHT$0H   ֶ H   HHcPD
uT$0"tFR H   HT$0蠶 H   HHcPD
uT$0't2R HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33T l$HT ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @Q Hv_H~HHfff     I   hQ HHu2Hv&H~HHfI   8Q HHu2j@SH   HD$@H H3H$   HHL$0HA    HyrHH  H   HT$ P HHcQDuAL$ S uL$ S T$ tHo1 H   H   qP HqHX H$   H3wb HĠ   [@SH HyHHA    rHH  HT$0H   P HHcQDufL$0R uL$0R T$0t6H0 H   HT$0O HHcQDtH*   H [H   O H   H [H   HD$0H H3H$   HL$ d H$   H3ca HĘ   @SH   HD$0)$   H H3H$   HHL$ ' (Wf.zu	HѸ (H$   H3` ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5x DH@ H   HUHP HHcJD   UH:7   HD847uAHx HEt
5 5 HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKXa HS`HtHCXHH
HB  H   M HvSHHHH   M HvHu.Hv(HHHD  H   XM HvHuE3Hw Ht0 HKXHUHEH*   @2LsH{rHHD0HU@H   L HHcQDugH
     M@O U@uB<:w2Hs,@H- H   HU@L HHcQDt
H   L @u<HC`H+CXHu,HEtHK@EHHUH$ HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKX` HS`HtHCXHH
HB%H;Chu   HKX_ HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5& BH;Chu   HKXm_ HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0K HLcBAD u!L$0M uT$0H   J H   HT$8蝮 L   I HcHBDuT$8-tDIJ H   HT$8@2` H   HHcPD
uT$8+tSJ @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(tI 2H0A^H\$HHT$@Ht$XH|$(语 I   HHcPD
uT$@)   I IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@\ IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINp\ IVxHt:IFpHH
IFx   I;   u   INp\ IFxHtH0IFxkI;FPu	IN@\ IFHHt0IFHHHl$PI   HT$@' I   HHcPD
uT$@)t#H 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INp[ IVxHt7IFpHH
IFxI;   u   INp[ IFxHtL8IFxU@UH0HHT$@H   6 H   HHcPD
uT$@(t)G 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   F HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMXZ HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMp)Z HUxHt:HEpHH
HEx   H;   u   HMpY HExHtL0HExtH;Ehu   HMXY HE`HtL0HHE`HHt$PH   HT$@U H   HHcPD
uT$@)t"HE 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMpY HUxHt7HEpHH
HExH;   u   HMpX HExHtL8HExV@SH HHT$0H   f H   HHcPD
uT$0(tYD 2H [HT$0H|$@* H   HHcPD
uT$0)   D Ht$8HH   HT$0 H   HHcHDuT$0,tH   C Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKpW HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp-W HSxHt@HCpHH|$@H
HCxH [H;   u   HKpV HCxHtH8HCxH|$@H [H;   u   HKpV HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH   3 H   HHcPD
uU(t'B 2H([]Ht$HHl AH|$PHH˄t
   AHOh H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@ MM;~fHUHK@ EȉE;}HCpHUHCxH   / H   HHcPD
uU,t#A Ht$H2H|$PH([]ò.H~tAHxk Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8 ,Ht'HrHUHEHKp ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp HMHHMH;v)Hh뒐HUHKps HEHHEH;s)H9`@UH0HHT$@H   v H   HHcPD
uT$@ct)i? AHi HḦ́tH0]HH0]AHe Ḧ́t
H0]AHi Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@Q HUHHt%HE@
H;EPu	HM@Q HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@YQ HUHHt%HE@
H;EPu	HM@6Q HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@ Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+I5O H{pH{xH   HSXHtLChL+I
O H{XH{`H{hHS@HtLCPL+I8> H{@H{HH{PHK C HH\$0H _1 @SH0H3HQ D$ IE3HHC   HC@[ HH0[@SH0HD$     HQpH HH0[@SH0HD$     HQ@H  HH0[@SH0HD$     HQXH HH0[@SH   HD$@H? H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H   E L   I HcHBD   T$ <tI0;    -H   Hi   HǄ$      HǄ$       D$pA   Hxe HL$pnX HD$pH$   HCD$pH
*E HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   n; HW9 HD$PA;  He HL$P 2H$   H3tL H   [HUATAUAVAWHl$H  HEHXHpHx H H3HEpHLHMH, HLiLl$03I} I}躐 IE M|$L|$0I?I蠐 II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIg HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	ِ
 uH;s3H;t.LuLEI LH HD$ LHT$0I] H\$0HK@HT$8: HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  HKQ HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  HP HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  H]P HT$hHtLD$xL+I8 WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$ HHT$8 HM HT$PHtLD$`L+IH HT$8HtLD$HL+IG HT$hHtLD$xL+IG WD$hH|$xHUHQLEL+IG <7 7 7 7 7 7 7 7 7 7 7 7 7 7 HMIHMpH3/G L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+IF H{H{ H{(HHtLCL+I5 H;H{H{H\$0H _H\$WH HQ3HHtLA(L+IXF H{H{ H{(HHtLCL+I4F H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0# H^ HL$@؊ Ht3HwH^ HL$@辊 H;sH\ HL$@訊 HH;rH^ HL$@菊 HH33 HHY^ t HT$0HHD$0HcHH4 HD0HD$0HcHhT,H/ HD$HHL$H[ HL$Hu3 HL$P2 H$   d3 HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tHHHt33 H LHD$(Lt$(H\$0H\$8HH~AL    M
 HIH;u(WHHH;|HMH;|HL$P! H\ HL$` Ht3HnAHL$`r1 H;sHZ HL$`贈 HH;rH\ HL$`蛈 HH?1 HHYZ 耈 HH$1 HHJ\ e HT$PIHD$PHcHH2 HDPHD$PHcHhTLH- HD$hHL$hY HL$hf1 HL$p0 H$   U1 IS2 IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   H H3H$  ILHH$   LL$83ۉ\$0HHYMt31 H HH~D$0   HǄ$      H$   Ƅ$    A   EH[ H$   M HǄ$      H$   Ƅ$    EGHZ H$   NM HǄ$      H$   Ƅ$    EGHZ H$   M HHL$`aHD$ L$   L$   H$   IZHT$`HtLD$pL+IIA WD$`H\$pH$   HrTHH$   H=   r<tg1 HAH;rW1 H+HsG1 H'v:1 HYH HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t0 HAH;r0 H+Hs0 H'v0 HG HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<tk0 HAH;r[0 H+HsK0 H'v>0 H]G HǄ$      H$   Ƅ$    A
   HX H$   'K IL$   HT$xIPH$   HrTHH$   H=   r<t/ HAH;r/ H+Hs/ H'v/ HF HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;v. H    H=   r<t. HAH;r. H+Hs. H'v~. HE HH$  H3> H  A_A^_^[LSVWAVH  IǃXH7 H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFHW IpH HǄ$      L$   D$   EF
HYV H$   H HǄ$      L$   D$   EFHV H$   H LHHL$H\HD$ L$   L$   H$   HxUHT$HHtLD$XL+I< WD$HLt$XH$   HrTHH$   H=   r<t, HAH;r, H+Hs, H'v, HC HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<tL, HAH;r<, H+Hs,, H'v, H>C HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t+ HAH;r+ H+Hs+ H'v+ HB HǄ$      L$   Ƅ$    A
   H/T H$   F HL$   HT$xHPH$   HrTHH$   H=   r<t+ HAH;r+ H+Hs* H'v* HB HǄ$      L$   Ƅ$    DDHT$xHL$H迒 HHHHHHJHCHBHKHJHCHBHKHL$H) HT$xHtL$   L+I: HH$  H3: H  A^_^[H   HD$`H1 H3H$   LHT$03DI          M;HsBIIcD$@HD$@I#I;uHd HD$(HR H
ZS  IWD  I;Ps8IHcf/w"H*d HD$(LH;R H
$S g HH$   H39 HĨ   H   HD$HHA H3HD$xHT$ L褒 HL$xH38 HĈ   AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ D AXA((yXA@^A(]\A(\YYAX(q~
 K8W
 Ys ^C0\(q~
 D\YDYCDX(DC7~
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hH H3HD$0HHHT$(H' HHHA   3HqHyrHH@0IE3C Hs(Hs0s8s@C<Hf HHL$0H36 H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH H3Hp  DHH  f  LAHP HP  蜉 LP HH0  E LHHAP HH  HrSHH0  H=   r<tT& HAH;rD& H+Hs4& H'v'& HF= HǅH     3H@  @0  Hh  HrSHHP  H=   r<t% HAH;r% H+Hs% H'v% H< HǅH     H@  ƅ0   A&   HO H0  @ HH0  HP HH  HrSHH0  H=   r<t5% HAH;r%% H+Hs% H'v% H'< HǅH     H@  ƅ0   E3HG H0  ? HH0  HP HH  Hy  HH0  H=   r<t$ HAH;r$ H+Hsp$ H'vc$ H; !  C  3A;  HǅH     H@  @0  DG9HjN H0  6? HH0  HP HH  HrSHH0  H=   r<t# HAH;r# H+Hs# H'v# H: HǅH     H@  ƅ0   A   HN H0  > L0  HM HP   LHHAP Hh  HrSHHP  H=   r<t# HAH;r# H+Hs" H'v" H: Hǅh     H`  ƅP   HH  HrSHH0  H=   r<t" HAH;r" H+Hs}" H'vp" H9 Dv(WI*(Y  H,ȉN,Y
 H,F0D+D+Dv4Hǅh     H`  ƅP   A9   HL HP  $= HHP  HP HP    Hǅh     H`  ƅP   A/   HL HP  < HHP  HP HP    H0   HL H@  &v HȋV, HH0  HPHM0 HL HM@u HȋV4 HHU0HPHL$0} HL HL$@u HȋV0g HHT$0HPHǅh     H`  ƅP   E3HB HP  ; HHP  HP HP    HM HM H    H    H  i H  l Dv(DF,DN0N4~8N@AAF<Hp  H3/ L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   HrK HH: HT$(HH HHOHfHH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHI<K8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKHޘ,CHE3L%# fnHGLH(X^^Y% L9G~   ( MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKHѓC8L|$ Lt$PHl$@H(_[ÍAC82H(_[H  @SH A H/= HHH" HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLH- IIv@H$   3H>H~Ht30 H  HH^y D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$H@ IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tHP Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx Hi H3HEPLLHEH   HE@    E0 A)   HF HM0J6 IHU0IPHEHHrPHHM0H=   r<t HAH;r H+Hs H'v H1 HL$0 IF@HL$@    I9vH~:~D  I^@H	A HL$@+o H HHcI;FH|HU0HL$0  MHIAPHEHHrQHHM0H=   r<t HAH;r H+Hs H'v H1 HD$0HcHH HD0HD$0HcHhT,H HD$HHL$H? HL$H HL$P HM HMPH3,) L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   H> HH)4 HT$(HH HHOHVHH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHI視K8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKH蟘,CHLOLH|$H^ % fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^Y L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0k HKH#C8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A Hw8 HHH" HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pHV H3HEHHE   3H}@}DG<HB HM>1 HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H, HE   H}E A   HA HM0 HHUHP HEHrPHHMH=   r<tT HAH;rD H+Hs4 H'v' HF, HE   H}E AC   HIA HM 0 HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H+ HE   H}E A/   HA HM/ HHUHP HEHrPHHMH=   r<t6 HAH;r& H+Hs H'v	 H(+ HE   H}E A<   H? HM/ HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'vz H* HE   H}E E3H5 HMv. HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H
* HE   H}E E3H5 HM- HHUHP HM  HMH3V" H\$hH|$pHP]LEK ECL$UVWHP  HD$0I[AAم+HL HD$ L
L MCH ? H
>  ̅/HL HD$ L
L L$  H
? H
>  ̅/HL HD$ L
aL L$  H> H
> ^ fng
 g
 ,;tCt
Ù-  HL$P  H$  HL$`bj H> HL$`!f HcHL$8
 HL$`HcQHL$`HHPHL$` HHa> e Hȋ    HL$8}
 HH?> HL$`e HHu3
H HcHHHUU kdHC HH= te H= HL$`ce H$  HL$`i H$  HHT$PPH$     H$    H$x  HP  _^]H\$WH0ME3M@HMtHMHH      @ f     IcAD$PHD$PH#H;w)IM;r܋A(L
:= HˉD$ z H\$@H0_HDJ MH= HD$(H蝼 H\$Hl$Ht$ WH@I@H-= MHIHHD$0LHl$(HH LH${ HGL
< DC(H= HHD$ 1} HOE3HOHtCHII      f     IcD$PHD$PI#I;wIL;rH\$XHl$`Ht$hH@_LHHZ HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt3u
 HE HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHMY2 LvLu@II^I^uHtFHHHH;teLLMt3 I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHM1 ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+tb
 II^H\$XH    HC    HC    HtFHHHH;tdHHHt3X H( HH{H{LHSE3L9C~JL    
 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH@HD$0H\$pMHHHJs HHHGHFHHGLL+tla
 H^H\$hININ8 HHIFHCIFHCIIFIFLL+t$a
 HWV(E3LGMtlHII      @ f     IcD$hHD$hI#I;w
IM;r#H4E HD$(LH7 H
8 艷 ̉T$ L
7 H
n8 Qu MH_8 HHH\$pH@A^_^H\$Ht$WH`HLHD8 HHHs3HD$ HGH;t'H;tH	 Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@v H\$xH$   H`_H\$Hl$VWAVH`HLHq7 HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH Ht
H HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@u L\$`I[(Ik0IA^_^N`H\$UVWHHpHcy(3H)t$`WuH9yt"H	 Ht
H HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM+ Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tH Mt
I HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHM* H$   Hp_^]s^HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t]LLMt3 I HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHM+ WEIHEIHt3 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHM5+ LEHUIHMq HMf IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t[LLMt3 Ih HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHM+ WEIHEIHt3 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHMx* LEHUIHMT HMI IL$   I[8Is@IA_A^A\_]H\$UVWATAWHHpB(L
s0 DA(LHD$ Hv0 H
'0 _ I3IHEHFH;t'H;tH  Ht
H HHH~LHEHEHHELELNHEHE0HEIHHuH+HHHH~!D  HE(A)HH;}LEMHMn MgH~IGHOM HELeI;uL9tqMt"MtHHIL;   HGL$   MMHL;tH
 Mt
I HHL$   LgLHGHUHHEHUHUHUHU0HUHMLGLH}IHH+HHHH~"    HE()HH;}HMHMm H$   HHpA_A\_^]0XH\$Ht$H|$ UHHpB(L
O. DA(HHD$ HR. H
c. ] LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHM1 HFHOLFHUL	HEHAHEHUHUHUHULELMLQLHUIHMHH+HHH~*    A(fAXA)HH;}
LELMMHMH螺 L\$pHI[Is I{(I]H\$UVWHHpB(L
, DA(HHD$ H, H
+- V\ H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM HOHM(LFLEHFHEL	LMHAHEHELQLQHEHEHEHE HEHE(HEIHH+HHH~1@ ff     A(fA^A)HH;}
LELMMHMH^ H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMHh HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM螵 HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHM HH\$xH`]H\$Ht$WHPeH%X   He    )t$@HЋ9x    HcF(3HfnY5 ~nHFHl$`Hn)|$0=; H4   D)D$ EWf     HH(TfA.zt	O
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
Ȇ / = Dng H
 Xם Y? O 
 HHPUWAVHhH   HEHXHp MHH3}׋A(D$ L
& M@H
( c DINHthIII      fff     IcEgHEgI#I;w
IL;r#H3 HD$(MH' H
' k HFHELuEEHuH;H{LvMt3b
 I2 HLsHUHMN HHE7HvHCH;t'H;tH$
 Ht
H HH;HsLLEHEHEHEHEHEgHEH]LKIHH+HHHH~+fD  HE7HM(fXA)HH;}LEMHM HM'
 HL$   I[0Is8IA^_]@SH HHIU
 HH [H%F
 HT$WH0HD$(H\$@HHD$     IHHH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHGHFHHGLL+t}L
 H^H\$HHOHO I HHHGHCHG HCHWHGHG LL+t4L
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHHHK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IrHHHOt
 Hk
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IbHHGHO
 H
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3
 I~ HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHM HwHu@HH^uMt3
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHM Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ) HHIFHFIIFLL+t"I
 InH~H$   3HH_WD$(Ht3
 Hν HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$H IFF HHpA^_^][HL$VWAVH@HD$0H\$pILHHJ HHIFHCIIFLL+tG
 H{H|$hHNͼ HHHFHGHHFLL+tG
 INK HCHD$ L
! DH` H
  _ E3AHSII      HtULfD  HcAD$hHD$hI#I;w
HH;r&H+ HD$(LLHi H
j   HOHtSH     IcD$hHD$hI#I;w
IL;r#HT+ HD$(LH]  H
  詝 HH\$pH@A^_^H\$Ht$H|$ AVHpA L
 LBHH
  D$ L7[ I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHD$0HFH;t'H;tH
 Ht
H׺ HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~  HD$0()HH;}HL$@HL$P\ L\$pI[Is I{(IA^H) MH HD$(H
   H\$Ht$H|$ AVHpA L
Y LBHH
 D$ LY I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHHD$0HFH;t'H;tH
 Ht
HS HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~HD$0()HH;}HL$@HL$PX[ L\$pI[Is I{(IA^HJ( MH  HD$(H
 蟚 H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	|
 Ht
HG HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHMK Hcw HuH9wt"H
 Ht
H袷 HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHM (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H誶 HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHM WEHHE'H~Ht3)
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHME LEHUI4HM
 HMv
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3

 Hڴ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHM WEHHE'H~Ht3\
 H, HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM LEHUIwHM
 HM
 IL$   I[(Is0IA^_]H\$Ht$UWAVHHpB L
 DA LHD$ H H
M PF I3I~HEHFH;t'H;tH4
 Ht
H HHH~LHEHEHHELELNHEHE HEIHHuH+HHHH~ HE(A)HH;}LEMHMU IFH~MvHEHGI;t'L;tH
 Mt
IT HHLwHHEHEHEHEHE HEHMLGIH}HH+HHHH~&fff     HE()HH;}HMHM\T L\$pHI[(Is0IA^_]H\$Ht$H|$ UHHpB L
/ DA HHD$ H2 H
 D LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHM LOLGHNHEHEHEHEHEHEHMLMLEM@IHH+HHH~,ff     (fAXA)HH;}
HMLMHHM蒡 L\$pHI[Is I{(I]H\$UVWHHpB L
 DA HHD$ H H
 FC H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM HGHE(HUHNHUHUHUHU HML HUHU(LELHIHUHH+HHH~% A(f^A)HH;}
HMLEMHMHo H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHM苡 HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM辜 HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM; HH\$xH`]HHPVWAVH   HD$hHXHh )pMHH3|$0I@HD$ L
 DA H H
 CO DIVHteIII      Ic$   H$   I#I;w
IL;r#Hn HD$(MH H
p Í H;H{HnHt3
 H被 HHkIH$   HFH$   HH$   HvH;t'H;tH
 Ht
HU HH;HsHHD$8HD$8HD$HH$   HD$PH$   HD$XH\$`HkHHH+HHHH~MH$   (4H$   ()D$pHL$p';H$   (fYfXHD$8)4HH;|LHHL$H	 HL$   I[0Ik8A(sIA^_^HT$WH0HD$(H\$@HHD$     IHHH$   HKa
 HX
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+t4
 H_H\$HHN辩 HHHFHCHVHFLL+t4
 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHH$HKa
 HX
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHO
 H
 HH\$@H0_HG  @SH0HD$     HQHs  HH0[H\$WH HHQHtLAL+I  3HCHCHCHC H@t
    H HH\$0H _@SH HQHHt.LAL+I>  3HCHCHCH HH [H HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXH
 D$(HD$0HT$83HL$ HD$8HD$@H HD$ U
 Hn H` HD$0HL$0> H\$WH HHQ HtLA0L+I8  3HC HC(HC0H H@t
8   H HH\$0H _@SH HQ HHt.LA0L+I  3HC HC(HC0Hi HH [HY HH [@SH HHHSH
 H3H
HJHHC
 H\ HHH [HAHH`HAHH`H\$WH Hw HHAH荹  H HGHt
8   H HH\$0H _@SH H HHAH3  Hl HCHH [@SUVWATAUAVAWHxHD$(H H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HHN HHHL$ Hk HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ Hl
 HIFHAIFHAIFHAH IV   H HHNط  L- L.H IGIO躷  MoM/H  I  IV HtMF0L+I  3IF IF(IF0M.HHL$`H3 HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+I  H{pH{xH   HK8]  HS HtLC0L+I  H{ H{(H{0H HH\$0H _H\$WH H,   t
  H" HH\$0H _H\$Ht$WH H  HHt*L  L+IO  3H  H  H  H5 H   H  HKpH=V HKPH{@q  Hs@HKHs8H{\  HsH3H\$0Ht$8H _HL$SH0HD$ HHs HLALD$HH I HBI@HIHHA   HA    HyrHH  IE3  HH0[HL$WH0HD$ H\$PHHH HHBHAHBHAHBHAH H 蓭  HO8HL$HH* HHC@HAHCHHAHCPHAHSXH   HSpHOpL  HH\$PH0_@SH HHI HtCHS(| LC0H*L+C IHLI?LHS   3HC HC(HC0H HH [H\$WH Ht
   H HH\$0H _H\$WH H<t
8   HR HH\$0H _H\$Ht$WH HHHH
 ' HH ' HH
 ~' HHW+ HH- *
 H
 HS' HH D' HH
 5' WPH
 HHn- 
 H
 H	' HHk & HH
 & H
 HH&- 
 H
 H& HH/ & HH
 & WHO
 HH, O
 O|tttt3   H
 HW& HH H& HHj
 9& Hȋ
 HHt, 
 O|  [  	  H
 H% HHw % HHD
 %    H
 HH
, |
 HI
 H% HH; % HH
 %    H8
 HH+ 0
 H5
 HY% HH J% HH
 ;%    H
 HHr+ 
 H)
 H
% HH $ HH
 $    H
 HH&+ 
 HM
 H$ HH $ HH
 $    H:
 HH* J
 H
 Hs$ HH9 d$ HH
 U$    H
 HH* 
    tB  H=
 H$ HH  $ HH
 # H    H
 H# HH  # HHk
 # H  W  L   H> Ht
 H# HH # HH
 r#    H
 HH) 
           H H"# HH  # HH # HH " HH;) 
 L   H> L   H> L   HH !> L   H2? L   HHa <= L   Hm? L   HH < #  Hw HS" HH9 D" HHv
 5" HHs  &" HHl( 
 L   H= L   H(> L   HHO  R= L   Hc> L   HH m< L   H> j  H
 H! HH ! HH}
 |! H   H
 Ha! HHc R! HH|
 C!    H
 HHz' 
 H
 H! HH# ! HH`
      Hg
 HH-' 
 H$
 H  HH   HH
      H[
 HH& S
 L   H; Hi
 Hm  HH ^  HH(
 O    H
 HH& 
 H
 H  HH]   HH"
     H
 HH6& 
 H]
 H HH  HH
     H#
 HH% [
 H
 H HH u HH
 f    H
 HH% 
 H
 H6 HH ' HH
     H
 HHM% 
 Ht
 H HHf  HHs
     Ha
 HH$ q
 H
 H HH(  HHU
 |    H
 HH$ #
          tB  H

 H& HH  HH
  H!   H
 H HH  HHp
  H l  H@
 H HHr  HH
  HH  HH# ?
 L   HHf 8   Ha
 HM HH > HH
 /   H
 HHf# 
    tzt?   H|
 H HH  HHK
  H jH
 H HHp  HH
  He 4H
 H| HH: m HH
 ^ H HO H" H
 y tIH H* HH  HHE  HHWX0  HHF" 
     tLH4 H HH  HH  HH    HH! c
 H( H HHR } HH n WxH
 HH! 
 H
 HB HH! H\$0Ht$8H _H%
 H%A
 @WHPHD$ H\$hHM H3HD$HHHD$@   3H|$8@|$(E3HI HL$(1  HT$(H胲  HD$@HrQHHL$(H=   r<t
 HAH;r
 H+Hs
 H'v
 H H   H   H  HHL$HH31 H\$hHP_@UVWATAUAVAWHl$H   HEH$   HI H3HEA؉]HLHUE    A}NH
 HE3HEHEH HEEHUHM[
 H| HEHE HMF H    HB    HB    E   HE   HE    E A   HX HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtH 
 u
HJ  H{rHHA   I;LBMtH 
 u
H  H{rHHA   I;LBMtHw 
 uDHu>LFIH+HgfffffffHHHH?H  IHT  HF   H{H{rHH?A   I;LBMtH H
    Hs	3Hu{A^HE   HE    EIE3HUHM  ]HUH~  HM財  3IV(HEH;tIE3HM  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHMB  DmHUH2~  HM  HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v~
 H HNHi
 HE3HEHEH\ HEEHUHM
 H׿ HEHB HM HMH3 H$   Hİ   A_A^A]A\_^]  @SH HH(  HKH [  @UVWATAUAVAWH$@H  HD$8H$  H{ H3H   MHHL$@  HHPHH HL$P HH }H HL$P n  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<H^ HL$P HHS HH. y HHD$ T'
 HL$(Lt$ I+IHHLI?LAxcIcH<HLfK4H HL$P HH@ HH  HBT7 
 Md$HAxLt$ H HL$P HH 
 HL$ Ht2HT$(f HL$0H+L$ IHHLI?LHT$   HU`HL$@葪  H0 tSHEX   HEP    E@ A	   H# HM@  LE@HU`H   Ex  H.? H    H0 tSHEX   HEP    E@ A   H HM@K  LE@HU`H   Fv  H6 H   y Hz0 tSHEX   HEP    E@ A
   H HM@  LE@HU`H   Gt  H7 H    H[0 tSHEX   HEP    E@ A
   H6 HM@  LE@HU`H   Hr  H!A H    H<0 tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ l
 H HE@HBC HM@W H0 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H< HM@ H/ tXHE`H}xHCE`H
S
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H:A HM@ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ @
 H HE@H7 HM@+ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ ܹ
 HU HE@Hr: HM@ H/ tXHE`H}xHCE`H
'
 HM@3HMHHMPHD$ D$(HUHHL$ x
 H HE@HN; HM@c Hd/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 Hݪ HE@H6 HM@ H@/ tXHE`H}xHCE`H
_
 HM@3HMHHMPHD$ D$(HUHHL$ 
 HY HE@H7 HM@ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ L
 Hm HE@H: HM@7 HEX   HEP    E@ A   Ho HM@  LE@HU`H   l  H8 H    HL$WH0HD$ H\$HHHH3
 HHQ3HHBHK
 H1 HHSHOHA   HA    HyrHH  IE30  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 H!
 HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHKq
 Ha HHSHOHA   HA    HyrHH  IE3  HH\$HH0_@SH HHHSH
 H3H
HJHH
 H HHH [HL$WH0HD$ H\$HHHHC
 HHQ3HHBHK
 HY HHSHOHA   HA    HyrHH  IE3@  HH\$HH0_@SH HHHSH
 H3H
HJHH#
 H HHH [@SH HHHSH
 H3H
HJHH
 H HHH [@SH HHHSH
A
 H3H
HJHH
 Hl HHH [@SH HHHSH

 H3H
HJHHc
 H HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH HW HHH>  H
 HOH
 t
8   H0 HH\$0H _H\$WH Hw
 HHHޓ  H
 HOH
 t
8   H HH\$0H _H\$WH H HHH~  H_
 HOH:
 t
8   Hp HH\$0H _H\$WH HO HHH  H
 HOHڲ
 t
8   H HH\$0H _H\$WH H HHH辒  H
 HOHz
 t
8   H HH\$0H _@SH0HD$ HH HHE
 HA(H0
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HHX HH޺
 HA(H0
 H HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH HHe
 HA(H0?
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HHX HH
 HA(H0ذ
 H HHKHtHP tHC    @t
@   H HH\$@H0_H\$WH HHT HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   W L   H988L  M+IHLI?LI  3H   H   H  H   ؜  H   H [H%ծ
 HL$SH0HD$ HH; HE3LAHH HLC0LC8LC@LCHLCPLCXLC`LChLCpL   L   L   L   L   L   L   L   L   L   L   L   L   L   L   L  L  H   HH0[LWATAUAVAWH@  Iǃ8I[Is A)sHj H3H$   HHT$HHHL$PWD$p3ID$XHt$hU $   $ _   Iǃp   Ih@$  DFHZ IX:  HǄ$     H$  @$  DFH H$    HǄ$     H$  @$   DFH H$     HL$0HD$ L$  L$  H$   HHT$0HtLD$@L+I  WD$0Ht$@H$  HrTHH$   H=   r<t!
 HAH;r
 H+Hs
 H'v
 H HǄ$     H$  Ƅ$    H$  HrTHH$  H=   r<t
 HAH;r
 H+Hs
 H'vv
 H HǄ$     H$  Ƅ$   H$  HrTHH$  H=   r<t%
 HAH;r
 H+Hs
 H'v
 H Lc(A4$HǄ$     H$  Ƅ$   A   Hz H$    HL$  HT$0HP(HHD$pH;t*HH\$pHJHL$xHBH$   H2HrHrH\$pHT$0HtLD$@L+I;  WD$0Ht$@H$  @  A$! `   HǄ$     H$  Ƅ$   A   H+ H$  
  HǄ$     H$  Ƅ$    A   H, H$     HǄ$     H$  Ƅ$   A   H H$    HL$0qHD$ L$  L$   H$  HHT$0HtLD$@L+IϺ  WD$0Ht$@H$  $  H$     H$    H\$Ps,HǄ$     H$  Ƅ$   A   H3 H$    HL$  HT$0HP(HHL$p6  HT$0HtLD$@L+Ik  WD$0Ht$@H$  p  HD$pK, a   E$H H
 UHǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$    A   HE H$     HǄ$     H$  Ƅ$   A   H H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Ht$@H$  5  H$   '  H$    E$H H
g W$  Ic$WD$0Ht$@L$  HL$0һ  L{0L$   HT$0I詄  HT$0HtLD$@L+I.  HǄ$     H$  Ƅ$   A   H H$  x  HL$  HT$0HPHHL$X4  HT$0HtLD$@L+I蹷  WD$0Ht$@H$    LMc$LHt$XA   IrmIHHPLL+AH+MSIIN4    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sIJHJIHIM;r b   E$H H
 VHǄ$     E3L$  D$  EFH H$    HǄ$     L$  D$   EFHK H$     HǄ$     L$  D$  EFH H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  9  H$   +  H$    E$H H
o $  Ic$WD$0Lt$@L$  HL$0ٸ  HsHHT$0H踁  HT$0HtLD$@L+I=  HǄ$     L$  Ƅ$   A   H H$    HL$  HT$0HPHHL$XC  HT$0HtLD$@L+Iȴ  WD$0Lt$@H$    MMc$MLt$XIrrHHHPML+IH+MSIIN<    M@      IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r c   E$H H
 fHǄ$     E3L$  D$  EFH H$  /  HǄ$     L$  D$   EFH H$     HǄ$     L$  D$  EFH
 H$  ž  Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  I  H$   ;  H$  -  E$H H
 &$  Ic$WD$0Lt$@L$  HL$0  Hs`HT$0H~  HT$0HtLD$@L+IM  L$  L$  E33H$    A   H" H$  葽  HL$  HT$0HPHHL$XM~  HT$0HtLD$@L+Iұ  WD$0Lt$@H$  '  MMc$MLt$XIrlHHHPML+IH+MSIIN<    MfD  IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r d   E3L$  L$  E33H$  踵  EFHq H$  P  L$  L$  E33H$   }  EFHz H$     L$  L$  E33H$  B  EFH H$  ڻ  HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I
  WD$0Lt$@H$  b  H$   T  H$  F  DsxL$  L$  E33H$  耴  A   H{ H$    HL$  HT$0HP(HHL$prv  HT$0HtLD$@L+I觞  WD$0Lt$@H$  ~  HD$pD DCx e   H H
 L$  L$  E33H$    A   H4 H$  W  L$  L$  E33H$   脳  A   H H$     L$  L$  E33H$  G  A   H" H$  ݹ  HcSxHL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  a}  H$   S}  H$  E}  DCxH H
 >
$  HcSxWD$0Lt$@L$  HL$0  L   L$   HT$0Iy  HT$0HtLD$@L+IZ  L$  L$  E33H$    A   H H$  螸  HL$  HT$0HPHHL$XZy  HT$0HtLD$@L+I߬  WD$0Lt$@H$  4|  Lc[xE3Ht$XIrlIHHPLL+IH+MSIIN4    MfD  IDHBIHIDHBHIDHHR IuH|$HH\$PM;sIJHJIHIM;r f   E$H& H
 DC,H H
 oE3L$  L$  E33H$  蚰  EGH H$  2  L$  L$  E33H$   _  EGHp H$     L$  L$  E33H$  $  EGH H$  輶  LcC,Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0L|$@H$  <z  H$   .z  H$   z  E$H H
 
DC,HZ H
s 
$  HcS,WD$0L|$@L$  HL$0ŭ  Ic$W$  L$  LD$0H$  蚞  L   H$  Ic  H$  &c  HT$0HtLD$@L+I  L$  L$  E33H$  蘮  A   H H$  .  HL$  HT$0HPHHL$Xu  HT$0HtLD$@L+Io  WD$0L|$@H$  x  MLck,MM   Lt$X@      LcC(IIr{I$LHP0M^O˾   H+IXHHH<    LfHJICJHJICJH
IJI7HICJM[ HR`HuH\$PE3I;s(M$HHL+IKJIHRIuIM;?H|$HX g   Lk,EE H H
: L$  L$  E33H$    A   H H$  艳  L$  L$  E33H$   趬  A   H H$   L  L$  L$  E33H$  y  A   HT H$    IcU HL$0 HD$ L$  L$   H$  H
HT$0HtLD$@L+I>  WD$0L|$@H$  v  H$   v  H$  wv  EE H H
 pIcU W$  H$  C\  H$  H   H   H$  H   
 L$  L$  E33H$  U  A   Hh H$    HL$  HT$0HPHHL$Xr  HT$0HtLD$@L+I,  WD$0L|$@H$  u  MMc] MHt$XIrvH   HHPLL+Ȼ   H+MSIIN4    Mff     IDHBIHIDHBH;IDHHR IuH|$HH\$PM;sH   JHJIHIM;rQ h   L$  L$  E33H$    A   Hz H$  蝰  L$  L$  E33H$   ʩ  A   H H$   `  L$  L$  E33H$  荩  A   Hh H$  #  HL$0HD$ L$  L$   H$  H"HT$0HtLD$@L+IV  WD$0L|$@H$  s  H$   s  H$  s  L   M<$L$  L$  E33H$  ¨  A   H H$  X  HL$  HT$0HPHHL$Xp  HT$0HtLD$@L+I虣  WD$0L|$@H$  r  HD$XHI$`	 i   L$  L$  E33H$    A   H͵ H$  謮  L$  L$  E33H$   ٧  A   H H$   o  L$  L$  E33H$  蜧  A   Hw H$  2  HL$0HD$ L$  L$   H$  H1HT$0HtLD$@L+Ie  WD$0L|$@H$  q  H$   q  H$  q  D   L$  L$  E33H$  զ  A   H H$  k  HL$  HT$0HP(HHL$ph  HT$0HtLD$@L+I  WD$0L|$@H$  q  HD$p   r j   EE H; H
x  L$  L$  E33H$    A   H H$  觬  L$  L$  E33H$   ԥ  A   H H$   j  L$  L$  E33H$  藥  Hx H$    IcU HL$0$HD$ L$  L$   H$  H.HL$0SV  H$  o  H$   o  H$  o  EE H
 H
G $  IcU L$  HL$0l  H   HHal  HL$0U  H  H$  p  HL$  HT$0HPHHL$Xl  HL$0U  H$  o  Mc] E3Lt$XIroHHHPML+Ȼ   H+MSIIN<    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sLKHKIHIM;r k   EE H H
 fH/ H$  o  H H$   }o  Hm H$  ho  IcU HL$0HD$ L$  L$   H$  H#HL$0HT  H$  m  H$   m  H$  m  EE H H
@ $  IcU L$  HL$0j  H   HHVj  HL$0S  H H$  n  HL$HHL$  HT$0PHHL$Xj  HL$0S  H$  
m  E3Mc] E3Ht$XIrjHHHPLL+A   L+MSIIN4    MfD  JD
HBJ
HJD
HBHJD
J9HR IuH\$PM;sHJHJIHIM;r `   D$H   LL$HM}  h   D$H    LL$HMn  o   H{(DH H
 HsxDHd H
  $  HcL$  H$   ?i  HcLHL$0>W  H   HHU  HL$0RU  H$   R  H$   H  p   Ht$ LL$   H$   H$  U HH H$  T  H\$PHC    HCHCHC v   DHu H
 HcHHCu x   EE H> H
 IcE HCHL$X4Q  HL$pYM  H$   H3I L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH HRx HH3H   H*HtNH  @4 L   HH  I+HHLI?LIc  H   H  H  H   Ht(L   L+Io  H   H   H   H   Ht(L   L+I;  H   H   H   H   
 H   HtNH   q3 L   HH   I+HHLI?LI蔆  H   H   H   H   Ht(L   L+I蠙  H   H   H   HS`HtLCpL+Ir  H{`H{hH{pHSHHtLCXL+IM  H{HH{PH{XHS0HtLC@L+I(  H{0H{8H{@H
 HKHH\$0Ht$8H _:  @SVWATAUAVAWH  HǄ$  )$  H*D H3H$p  LL$8MLHIHL$`,b  IHL$xJ  + $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGH. H$0  董  IH$0  IPH$H  HrTHH$0  H=   r<t&
 HAH;r
 H+Hs
 H'v
 H tiH
 H$   3H$   H$   H HD$8D$@H$   HL$8
 H@ H$   Hy H$    HǄ$     H$   Ƅ$   A   H H$  u  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+I脖  W$0  H$@  H$  HrTHH$  H=   r<t
 HAH;r
 H+Hs|
 H'vo
 H莝 HǄ$     H$  Ƅ$   A   H5 H$  X  HǄ$h     H$`  Ƅ$P   A   H H$P  !  HǄ$     H$   Ƅ$   A   H H$    H$0  輴HD$ L$  L$P  H$  IH$0  Ht(L$@  L+I  W$0  H$@  H$  cd  H$P  Ud  H$  Gd  D$0HT$0HL$`_  HǄ$     H$  Ƅ$   A   H H$    IH$  IPH$  c  tiH
 H$   3H$   H$   H HD$8D$@H$   HL$8
 H H$   HD H$   ͦ HǄ$     H$  Ƅ$   A   H٩ H$  @  IL$  H$0  IPHHL$H_  H$0  Ht(L$@  L+Ix  W$0  H$@  H$  b  HǄ$     H$   Ƅ$   A   H~ H$  衞  HǄ$h     H$`  Ƅ$P   A   H H$P  j  HǄ$     H$  Ƅ$   A   H  H$  3  H$0  HD$ L$  L$P  H$  I/H$0  Ht(L$@  L+I]  W$0  H$@  H$  a  H$P  a  H$  a  HD$H D$0HT$0HL$`\  HǄ$     H$  Ƅ$   A   H H$  K  IH$  IPH$  a  tiH
 H$   3H$   H$   H# HD$8D$@H$   HL$8.
 HO H$   H H$    HǄ$     H$  Ƅ$   A   H) H$  脜  IL$  H$0  IPHHL$H=]  H$0  Ht(L$@  L+I輐  W$0  H$@  H$  `  HDFxHe H
 HǄ$     H$   $  A   H H$  ̛  HǄ$h     H$`  Ƅ$P   A   H: H$P  蕛  HǄ$     H$  Ƅ$   A   H+ H$  ^  HcVxH$0  LHD$ L$  L$P  H$  IVH$0  Ht(L$@  L+I脏  W$0  H$@  H$  ^  H$P  ^  H$  ^  Wt$0HcVxW$0  H$@  LD$0H$0  脒  L$0  9Vx~*ILD$H@      IH[HHI;Vx|;^x}HcIHL$`Y  HǄ$     H$  Ƅ$   A	   H| H$    IH$  IPH$  ]  tiH
 H$   3H$   H$   H/ HD$8D$@H$   HL$8|
 H} H$   HD
 H$   ͠ HǄ$     H$  Ƅ$   A	   H H$  @  IL$  H$  IPHHL$HY  H$  Ht(L$   L+Ix  W$  H$   H$  \  H$   H$(  E33H$    A   Hx H$  蛘  H$`  H$h  E33H$P  ȑ  A	   Hӳ H$P  ^  H$  H$  E33H$  苑  A   H H$  !  H$  HD$ L$  L$P  H$  IH$  Ht(L$   L+IK  W$  H$   H$  [  H$P  [  H$  ~[  HD$H D$0LD$0(HL$`
.  H$   H$(  E33H$  蚐  A   Hݱ H$  0  IH$  IPH$  Z  tiHك
 H$   3H$   H$  H HD$8D$@H$   HL$8z
 H4z H$   Hm
 H$    H$   H$(  E33H$  ͏  A   H H$  c  IL$  H$  IPHHL$HW  H$  Ht(L$   L+I蛊  W$  H$   H$  Y  HDF,H8 H
 H$`  H$h  E33H$P    A   H H$P  褕  H$  H$  E33H$  ю  A   H H$  g  H$   H$(  E33H$  蔎  A   H H$  *  HcV,H$  HD$ L$P  L$  H$  I"H$  Ht(L$   L+IP  W$  H$   H$  X  H$  X  H$P  X  t$0HcV,W$  H$   LD$0H$  S  L$  L|$H9V,~$Ifff     IH[HHI;V,|;^,}HcIHL$`bS  HT$`HL$8P  HT$xI19  MtL$   M+IIT  MtL$@  M+II7  H$@  HtH+HLjw  MtLD$XM+II   HL$`*  H$p  H3 ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xH3 H3HEH3HI  HE   3Hu@uDFHx HMߒ  HCHMH;sTHHUH;wHH}H+H;CuVH譇  HH;HKHtcHA   HqHyrHHH;H;Cu
   Hj  HKHt'HA   HqHyrHHHU  
  HC HEHrPHHMH=   r<tv
 HAH;rv
 H+Hsv
 H'vv
 Hۍ HE   HuE A   HJ HM赑  HCHMH;sVHHUH;wJH}H+H;Cu
   H聆  HH;HKHtcHA   HqHyrHHH;H;Cu
   H>  HKHt'HA   HqHyrHHHU  ޖ  HC HMT  HE   HuE A   H{ HMڐ  HUHI  HMT  HE   HuE A	   H HM蝐  HUHI  HMvT  HE   HuE A   H	 HM`  HUHI  HM9T  HE   HuE A   H( HM#  HUHFI  HMS  HE   HuE A   H HM  HUH	I  HMS  HE   HuE A   H HM詏  HUHH  HMS  HE   HuE A   H HMl  HUHH  HMES  HMH3ك H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLH?  WEE3L}HMvK  HUH>  HMaK  HUH>  HMLK  Ic~xH} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
J o
 HQM+IIHHH+IMI;LCL;ICHM  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
 n
 HQM+IIHHH+IMI;LCL;ICHMZ  HMHtH9HHMHUHz=  HMI  HUHe=  HMI  Ic~,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
ԩ n
 HQM+IIHHH+IMI;LCL;ICHMy  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
L m
 HQM+IIHHH+IMI;LCL;ICHM  HMHtH9HHMHUH<  HMxH  Ic~(H} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
 l
 HQM+IIHH+II;LCL;ICHM+  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
 <l
 HQM+IIHH+II;LCL;ICHM譧  HMHtH9HHMHUH:  HM4G  Ic^(H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HMɀ  HMHtHHHMHUH9:  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM_  HMHEHt)HH H;Mu   HM5  HMHtHHHMHUH9  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HM  HMHtHHHMHUH9  HUHtLEL+IW}  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HE HXHpHx Hc( H3H   EELHHL$ Z  HL$8N  E3LmHВ HL$0  HU(HL$ X  HILA  HE@HrQHHM(H=   r<tl
 HAH;rl
 H+Hsl
 H'vl
 H HL$8趒  LmH7 HL$01  HU(HL$ CX  HI@  HE@HrPHHM(H=   r<t:l
 HAH;r*l
 H+Hsl
 H'v
l
 H,    9sx   HL$8  LmH HL$0  HȲ.  Hȋ8i
 HU(HL$ W  HI?  HE@Hr4HHM(H=   r uAHAH;s1H+Hr!H'wH菂 ;{x!gUk
 Nk
 Gk
 @k
 HL$8]  LmH HL$0ؿ  HU(HL$ V  HI^?  HM(J  9s,   f     HE@   Lm8E( HL$8  LmHM(I  H HL$0h  HȲ.~  Hȋh
 HU(HL$ eV  HI>  HM(I  ;{,~E  9s(|   @ HE@   Lm8E( HL$8f  LmHM(II  HN HL$0ؾ  HȲ.  Hȋg
 HU(HL$ U  HII>  HM(H  ;{(~9s(|yHE@   Lm8E( HL$8  LmHM(H  Hj HL$0X  HȲ.n  Hȋg
 HU(HL$ UU  HI=  HM(H  ;{(~9s,|yHE@   Lm8E( HL$8f  LmHM(IH  HV HL$0ؽ  HȲ.  Hȋf
 HU(HL$ T  HII=  HM(G  ;{,~{,|zfHE@   Lm8E( HL$8  LmHM(G  Hޟ HL$0X  HȲ.n  Hȋf
 HU(HL$ UT  HI<  HM(G  ;s,~HM_T  HMef
 H   H3w L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx H" H3H   LHHL$04U  HL$H  E3L}Hk HL$@a  HU0HL$0sS  HI;  HEHHrQHHM0H=   r<tjg
 HAH;rZg
 H+HsJg
 H'v=g
 H\~ HL$HQ  L}HҌ HL$@̻  HU0HL$0R  HIR;  HEHHrPHHM0H=   r<tf
 HAH;rf
 H+Hsf
 H'vf
 H}    9_x       HL$H覌  L}H3 HL$@!  HȲ.7  Hȋc
 HU0HL$0R  HI:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH#} ;_x!ge
 e
 e
 e
 HL$H  L}HN HL$@l  HU0HL$0~Q  HI9  HM0D  ,   @ ff     HEH   L}@E0 HL$H膋  L}HM0iD  H HL$@  HȲ.  Hȋb
 HU0HL$0P  HIi9  HM0D  ;w,~     HMP  HMb
 H   H3t L$  I[ Is0I{8IA_A^]H\$WH H<t
  H{ HH\$0H _H\$Ht$WH H3H  Ht;H  $
 H  L   L+Iq  H  H  H   H  H*HtNH  
 L  HH  I+HHLI?LI6`  H  H  H  H  B  H  Ht(L  L+I6s  H  H  H  HKp   HKXHt)HS`6	 HSXLChL+Ip  H{XH{`H{hHK@Ht:HSHD HKPHH+K@HHLI?LHS@o_  H{@H{HH{PHS HtLC0L+Ir  H{ H{(H{0HSHtLCL+Ier  H{H{H{H\$0Ht$8H _H\$WH HHA  HOXA  LG8HT$0MHO8M )p  HO8y LG(HT$0MHO(M p  HO(_y HOH\$8H _<A  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hsl  HH_8H\$HH3HsT  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"   H  Hw HH [H\$Ht$WH H3H0  Ht;H8   H0  L@  L+Ijm  H0  H8  H@  H  Ht(L   L+I^  H  H  H   H  Ht(L  L+IRo  H  H   H  H  H*HtNH  ; L  HH  I+HHLI?LI[  H  H  H  H  Ht;H   H  L  L+IWl  H  H  H  H  HtNH   L  HH  I+HHLI?LI
[  H  H  H  H  Ht;H  P H  L  L+Ik  H  H  H  HKpHH\$0Ht$8H _HT$SH0HD$(H3D$ HHBHBD$    H  H  L  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H2  HH0[@SH0HD$     H  H2  HH0[H   HD$0LH0  L  HQpHD$ I  tWHd
 HD$P3HD$XHD$`H HD$@D$HHT$XHL$@ [
 HA[ HD$PH}
 HL$P	 3HĈ   @USVWATAVAWH$ H  HEH_ H3H   EIHHHUH]E3Dd$4IHL$PS5  Lt$XL+t$PIL;vx   HMaI  H^xHe HM蜰  HI@Y
 HH> 聰  HH%Y
 HH f  H   HMvG  HxrH H
c
 HL$h3HL$pHL$xHEEHT$pHMY
 H` HD$hH
 HL$h} Dd$0H   H+   HWD$8Ld$HLD$0HL$8*  L'LgLgD$4   HNpLLD$8HT$PEt;    HT$8HtLD$HL+IY  WD$8Ld$HHT$PHtLD$`L+I?j  HHtLCL+I&j  L#LcLcHH   H3j H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH) H3H   EEHHHUHL$H+3  Ht$PH+t$HHH;wx   HM9G  H_xH= HMt  HHW
 HH Y  HHV
 HH >  H   HMNE  HxrH H
da
 HL$h3HL$pHL$xHEEHT$pHMW
 H^ HD$hH
 HL$h{ 3t$`H   H+   HWD$0Ht$@LD$`HL$0  EuLHOpLD$0HT$HEt2  (HT$0H   LD$@L+IW  WL$0| WD$hHt$xHOpLL$hLD$0HT$HEt  
  (HT$hHtLD$xL+Ig  HT$0HtLD$@L+I#W  WD$0Ht$@HT$HHtLD$XL+Ig  HHtLCL+Ig  H3HsHs(H   H3g H$   ($  H  A_A^_^]@SVWH  HD$pH H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   D  HxH^H+HH H$   ͫ  HHqT
 HHo 貫  HHVT
 HHP 藫  H$  H$   B  HxrH H
^
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`U
 H&\ HD$HH
 HL$Hx H   H+   HHL$H  HOpD$0D$(H\$ L HT$HHtLD$XL+IU  HH$  H3e Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E32HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK2WD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`HT$8HtLD$HL+IS  HL$`裌HL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xH~HHMp衣3T
 L   A   AA+iA+AD̉    AA+iD+EDD  H   HUpH  Q 3DL  L  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;r  H  H  (  H  H  4Q  H  H;H{H{H  H  H     (  H0  H8  H@  H|$ (     f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   H&d  HKHHt(HHH;Cu
   Hc  HCHtH8HCHH|$ (  H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hc  HHKHt,HH#H;Cu
   Hic  HCHtH HCH  H   L0  H  H    HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H/ H3HEHLHUHMm&  H]HLuI9 E3H;  HE   LeDeED$Hv HMk  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
 L
 HSM+IIHL+IIM;HCH;HCHM豔  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
ه L
 HSM+IIHL+IIM;HCH;HCHM  H]Ht*HC   LcH{rHHHU  H>p  H H]HEHrPHHMH=   r<tO
 HAH;r
O
 H+HsN
 H'vN
 Hf HUIE  M0  I  I  f  H]Ht HUH LEL+IH[  HHt'HV[ HLFL+I[  L&LfLfHMH3^ L\$pI[@IsHIA_A^A\_]H\$L$WH0f.
h IH)t$ z	uA0LL$H \D$H/	 (HCHL$Ht$HH;sEHHT$HH;w8H|$HH+HH;Cu
   Hf_  HSHt
HHH
HB$H;Cu
   H:_  HCHt0H(t$ HCH\$@H0_H\$WH HQ3HHtLA(L+I(L  H{H{ H{(HHtLCL+I\  H;H{H{H\$0H _Hy0HArH @SH H; HHH+  HT
 HKHH [H%K
 H\$ WHpH H3HD$`3HHAIHAHp; HHL$@胰  HHL$ Ls  HHOL   HD$8HrQHL$ HH=   r<tL
 HAH;rL
 H+HsK
 H'vK
 Hc HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tK
 HAH;rK
 H+HsK
 H'vrK
 Hb HHL$`H3[ H$   Hp_@SH HsJ HHHD*  H%S
 HKHH [H%I
 H\$ WHpH H3HD$`3HHAIHm HAH	J HHL$@  HHL$ Lܫ  HHOLf Y  HD$8HrQHL$ HH=   r<t{J
 HAH;rkJ
 H+Hs[J
 H'vNJ
 Hma HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tJ
 HAH;rI
 H+HsI
 H'vI
 H` HHL$`H3zY H$   Hp_@SH HI HHH(  HQ
 HKHH [H%ZH
 H\$ WHpHg H3HD$`3HHAIH4k HAHH HHL$@L  HHL$ L<  HHOLƀ 蹭  HD$8HrQHL$ HH=   r<tH
 HAH;rH
 H+HsH
 H'vH
 H_ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<thH
 HAH;rXH
 H+HsHH
 H'v;H
 HZ_ HHL$`H3W H$   Hp_@SH HP
 HHH'  HO
 HKHH [H%F
 H\$ WHpH H3HD$`3HHAIHi HAH1P
 HHL$@謫  HHL$ L蜨  HHOL&   HD$8HrQHL$ HH=   r<t;G
 HAH;r+G
 H+HsG
 H'vG
 H-^ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tF
 HAH;rF
 H+HsF
 H'vF
 H] HHL$`H3:V H$   Hp_@SH H{? HHHd%  HEN
 HKHH [H%E
 H\$ WHpH' H3HD$`3HHAIHh HAH? HHL$@  HHL$ L  HHOL} y  HD$8HrQHL$ HH=   r<tE
 HAH;rE
 H+Hs{E
 H'vnE
 H\ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t(E
 HAH;rE
 H+HsE
 H'vD
 H\ HHL$`H3T H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuH6?  HKHL$@HHHHL$HHt胶 *H;KuH?  HKHL$@HL$HHt	HW HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LHr  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH>  HwHtlHHHF   HF     HHHd  C F ;H;OuH>  H_Ht$HC   HHC    H c  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	F HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf	 HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI LGHVHH pMt/HWIU HOH+IHHLI?LH=  HNH+IHHHH?HH>  tLHVH܋ HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LH,=  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   H3=  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   H<  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H=
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+Q=
 H[HI~H+LH7=
 Ht$0H;H|$8IFIH\$@H A^HtH=  HSIH+H>  t!HH[I>H+LH<
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I=  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
u :
 HH|$0Xr  HHFHHHNI~IHH+LH;
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
8u r9
 q  HH    HGLH3HHOHV_ H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXH\D
 D$(HD$0HT$83HL$ HD$8HD$@Hm HD$ :
 H. H<
 HD$0HL$0^ HD
 D$(HD$0HT$83HL$ HD$8HD$@H^ HD$ K:
 H0 H
 HD$0HL$04^ HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`HDC
 D$(HD$0HT$83HL$ HD$8HD$@Hk HD$ 9
 H- H$
 HD$0HL$0s] H\$WH HHH;Qt>H	9
 HtH HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH HHHtLAL+II  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
(r b6
 o  HL    HCHHIHKH LCHH\$0H _@SH L
 HL II+HH;sH+IH H [H;   L H+II+HH;s\IIH+H;sH
hq 5
 HM+I3IHL+IM;HCH;HCFo  L
G L8 ILI+3HIL+IZ[ H
 HH+	 HH+HH H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
ip 4
 HM+I3IHL+IM;HCH;HCH4o  HOLH3H+HL+IeZ HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH:  HSHt7HHH
HCH\$0H _H;CuHy:  HKHtHHHCH\$0H _@SH HH	Ht@HS6 LCH*L+IHLI?LH\3  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LH2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
m "2
 HIh  HHCHHHHKLHVH蔀 HCHH\$XHt$`H@_@SH 3HHHAHAe9  HH [H\$WH 3HHHHAHAHtNH
H;vH
(m b1
 g  HHHCHHL    IHKH4 LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   H!9  HKHL$@HHHHL$HHtn
  /H;Ku
   H8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR蕂  HH@HH HH@HC    DD$@HHH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+IVA  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@Hx| LHD$ HT$@HLH / HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHRu  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+IW?  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I?  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HJ  VH;Cu
   H>  HKHL$@HL$HHt03HA   HAHyrHH  IE3HJ  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
e )
 HM+I3IHL+IM;HCH;HCHq  HOHHH+HH+ HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LI9  HSHm HGH+HH   HCH+HL;w'HILHI  LCHWHE~ LHtI HLCL+I9  HWH+HH<  tLHWH} HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+I9  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H;  HKHt@HH;H;Cu
   Ht;  HKHtHA   HHA      L  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I08  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
_b &
 Hd  HHCHH;H{LHVH{ HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH:  HSHt3H
HCH\$0H _H;CuH:  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+I(  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   HU:  HSHt<HHH
HCH\$0H _H;Cu
   H:  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H#&
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+%
 H[HI~H+LH%
 Ht$0H;H|$8IFIH\$@H A^HtH6  HSIH+HN9  t!HH[I>H+LHY%
 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
^ "
 HH|$0\  HHFHHHNI~IHH+LH$
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
] 2"
 |[  HH    HGLH3HHOHH H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   H7  HSHt
HHH
HBHCH\$0H _H;Cu
   H6  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
\  
 HM+I3IHL+IM;HCH;HCHD\  HOLH3H+HL+IF HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+Il3  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH 3HHHAHAu6  HH [@SH0HE3HQ(DD$ HC   LCDD8tI IB< uH.>  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH=  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	x	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ =  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
Y 
 H;sLHH`g  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<t 
 HAH;r 
 H+Hs 
 H'v 
 H7 HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t 
 HAH;r 
 H+Hs
 H'v
 H7 HC   HC    H{rHH  HH@  HH\$@H0_@SH E3HA   LAHDD8tIIB< u:  HH [@SH HA   IHA    E3 H;  HH [H\$WH HH  HH?
 tHCh    H\$0H _HH{hH\$0H _H%
 @SH H    Ht'  tH   
 y	H [3H [@SH HMH   Ht9HuMuEAE3
 uH   D@HhB  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|?  tsH   HT$0
 u]HtH   D@H
 u@H   HT$0
 u*IFHHGt
?  HOtHD$0HCH    HKH)
 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb>  tYHutH   DH
 u8H   HT$0
 u"H!>  HKtHD$0HGH    HOH@
 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH/
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   
 tl  d  HE/   E3Lu'DuH   
   HU'HHH  HZH  LM/L;sLHHM8a  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOh
    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+3Z3  HUH}/r'HHu#E	
     
 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   
 H~LEHU]#H
Q 
 H
Q 
 HUHE/HrPHH=   r=EtJ
 HBH;r:
 H+Hs*
 H'v
 HH90 HM7H3( L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@5
 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp H
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   
 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKhV
       HELELM/IICH}H+t.HMIICL   LǺ   /
 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHM-3  3u#MH   
 ;ELM/LELM/LEIrQIAH=   r=EtK
 I@I;r;
 L+Is+
 I'v
 LI:, HM7H3$ L$   I[0Is8IA^_]H   HtH%
 H   HtH%
 @SH0HD$ HH' HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H9  HH0[H%E
 @SH0HD$     HV;  HH0[H\$WH HhHHcPH H
hHhHcPH/ DhD
dHAH9  HO
 HOH\$0H _H%
 DL$ HL$SVWH0HD$ HHD$h    H1 HH HAH   
 D$h   H^E3HHJ
 HHcHH+ H1HHcHhT1H\$XH
 HH
 HLGHrH?HCh    Cp    MtHHP^  HH0_^[DD$HL$WH0HD$ H\$HHD$P    HQ HH HAH   
 D$P   E3HWHm
 HHcPHN H:HHcPDhDD:   HOI;  HH\$HH0_@SH0HD$     H9  HH0[H\$WH HxHHcPH
 H
xHxHcPH DxD
tHAH7  HOi
 HOH\$0H _H%
 DD$HL$WH0HD$ H\$HHD$P    H HH   Q
 D$P   E3E3HWH
 HHcPH.
 H:HHcPDxDD:   HO9  HH\$HH0_@SMPHMLLA@I Ht
H9AhsHAhH4
 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   H
 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjHN
 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
H

 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIHb	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI=5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH H_
 HHHI	
 HO 	
 HO(	
 H
 t
0   H! HH\$0H _H\$WH Ht
   H! HH\$0H _H\$Ht$WH H'H.
 @t   Hh/! Ht$8HhH\$0H _H\$Ht$WH HH
 @t   Hx  Ht$8HxH\$0H _H\$WH H HH/  H
 t
x   H  HH\$0H _H8HD$ HHHcHHLHHt+HHPH1H;uH   Ht
 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLH  H\$ HSH HHCI  H$   HVHM HHFI  HHGWD$8HD$H    I  Hl$(HT$8H  ILl$8I;^F  M  @ HI5  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtH- ]	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  HV  HGH+HA(  MtwHD$HI+HH?H;v
 H    H=   r=At
 IEI;ry
 L+Isi
 I'v\
 LIx HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
< $
 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
< T 
 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [H(H
L;v
 K@HH=   r<tc
 HBH;rS
 H+HsC
 H'v6
 HHH(N @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
: 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _n5  H _H\$WH 3HHHHAHAHt:H
H;vH
8: r	 4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
9 	 H3  HHCHHHHKLHVHK HCHH\$XHt$`H@_H(H?L;v 
 J    H=   r<t 
 HBH;r 
 H+Hs 
 H'v 
 HHH( H(LQLLAII+HH;s_H	I?L+III+H;sH
l8 	 L+II3IHL+IM;HCH;HCIH(C5  H(H\$WH 3HHHHAHAHt6H?H;vH
7 "	 l4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHH<
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
(7 b	 IHO uM  H    HHWHL$(HHO E7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wH HH;_s%[	 T	 M	 F	 ?	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;v	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
\5 	 L+II3IHL+IM;HCH;HCIH(#4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
4 	 L+HI3IHL+IM;HCH;HCIH(q4  H(@SH0WH̈        f I1  LH HH HHH
 H谤 HIH
} H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
3 	 ".  HHCHL4    HIHKHMHH I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
2 &	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _4  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uH&  AE3'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AD  3ҋm%  AD$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH`   AE3S!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEu   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ=  AD`  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v	 II   r<tv	 HBH;rf	 H+HsV	 H'vI	 HHH(a	 LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRB  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRWC  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@HS0  LD$PL;D$XuLHH\$HH0_H(HL;v?	 J    H=   r<t#	 HBH;r	 H+Hs	 H'v	 HHH( H(LQLLAII+HH;s_H	IL+III+H;sH
' 	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
8' r	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
& 	 L+HI3IHL+IM;HCH;HCIH(#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
,& f	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
% 	 ,#  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH讕 HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
$ 
	 T"  HLHCHHHHKLIa MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHAH;uH   Ht
	 ҐH8@SH0HD$ H	 u
H	 HHHcHHLHHt+HHPLG
 I;uH   Ht	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtHlA	 HCHH=   r=@t=	 HGH;r-	 H+Hs	 H'v	 HH, HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALH	 HHt8Ht!LIHF@	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1It?	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHH+?	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ :0  H\$hH0A_A\^HKI;sH
  	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
k  	 L+H|$XH;s;HCHrHHHrHHMtHMJ HHL	 LCIH+HHu	H   HvH
 	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HH	 H{rHHHtJ LI#=	 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH
 e	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JL	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH
 4	 HvH
  	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L H{H{rHH8 Ht$8HH\$0H _̀: uE3   IIB< u    H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH
 	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLH9	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
 1	 I+H;HGH;u9I8H9AsH
 
	 HAHyrH	 3He   HvH
[ }	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6L8	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH
 	 H|$0I<H   HvH
b 	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
+ M	 H|$0I<0H   HvH
 '	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLHy6	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
G 	 LAH+H;HGIHH;wH
 2	 H|$0I<0H   HvH
 	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.LV5	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBItQ	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpH3
 H3HEHHyh   yq   du2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H
 	 H
 	 ̳IrNIAH=   r=Et-	 HAH;r	 H+Hs
	 H'v 	 H HMH3 L\$pI[(Is0IA^_]@SVWH AAq HHA|	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXHrh HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHDQ	 HEHC| Cq 	 H
g HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   I	 HtyA   HHHT$(H(	 HG  HH{	 t
HCh    H{hH 	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t	 HAH;ru	 H+Hse	 H'vX	 Hw HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPH
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r	 H+Hs	 H'   	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(|   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t
	 HAH;r	 H+Hs	 H'v	 H HHL$HH3| H\$pHP_@WH0HD$ H\$HHq	 H
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;w	  HH'HHAHH(H HH(H(I   r<t	 HBH;r	 H+Hs	 H'v	 HHH( Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;v	 KHH=   r<t	 HBH;r	 H+Hs	 H'vv	 HHH( H(H88L;v?	 KHH=   r<t#	 HBH;r	 H+Hs	 H'v	 HHH( H(Hu	3ɋH(H88H;vi	 HHH   r,HA'H;wH	 H HH'HHAHH(~ HH(H\$Hl$Ht$H|$ AVH0LH[HSLHHy" HH988LKHML+IHHLI?IHt+I~u HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;v
	 HHH   r&HA'H;w	 H; HX'HHC( HHVLHHl$@Lt$H" HHgfffffffLNHML+ILIMI?MHt+Iu HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;v	 HRHH   r,HA'H;w	 H' HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH)" HH*LKHML+IHHLI?IHt+I>p HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt莍/H;Ku
   HhHKHL$@HL$HHt	H]HCH\$PH0_H(Hu	3ɋH(H?H;v	 H    H   r,HA'H;w	 H HH'HHAHH( HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;v	 H    H   r,HA'H;w	 H HH'HHAHH( HH(H\$WH HHu3UHH;vU	 H    H   r&HA'H;w4	 H HX'HHCp HHW HLW L+Ht$0	 HoW H5pW H+HHtLeW L+IHH>W HGW HHt$0H\$8H*W H _H\$Ht$WH HHHu3UHH;v]	 H    H   r&HA'H;w<	 H HX'HHCx HHHLGL+Hl$0	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+3	 HH{H+HHtLCL+IHHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;v	 HRHH   r&HA'H;w	 H HX'HHC HHVLHHl$@Lt$HT HH*LNHML+ILIMI?MHt+In HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;v	 HH   r)HJ'H;w	  HH'HHAHH(H HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;vW	 H    H=   r<t;	 HAH;r+	 H+Hs	 H'v	 H- HoXHo`HohHO@Ht~HGPH?H+HH;v	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H Ho@HoHHoPHO 聟H HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;v	 H    H=   r<t	 HAH;r{	 H+Hsk	 H'v^	 H} HoXHo`HohHO@HttHGPH+HI;v*	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H  Ho@HoHHoPHO ۚH HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHH HHWHH+Hta HLGL+IuHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
 
	 THLHCHHHHKLId MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPL
 I;uH   Ht
	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;w	 HM Hp'HHF: HH\$`Lt$pH|$hHt$xMtH{rHHMtMH	 HCHrOHHH=   r<tʸ	 HAH;r	 H+Hs	 H'v	 H HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH
r
 ܴ	 IALd$XLd$pI;sH
Q
 	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH
 	 Ll$`L+L,9M;sBIvH
 	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HHZ	 H~rH6H{rHHH6  J&LJ0	 !  H;suHCHrHHHrHHHtJ!LJ0	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HHh	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0z	 HCHrHHHrHHMtJ1MJ0HH>	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   Ivް	 H|$0H   r#IH'H;w	  Hx'HHGH HLHH		 CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH
 4	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHH HH*LKHML+IHHLI?IHt+IZ HKHH+HHLI?LHKHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  Ha 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH e  HxH\$0Hl$8Ht$@H _	 	 	  	 	 	 	 	 ݭ	 ֭	 ϭ	 ȭ	 	 	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H1 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   HX 3HC   H{HSrHH 5  HxH\$0Hl$8Ht$@H _	 ޫ	 ׫	 Ы	 ɫ	 «	 	 	 	 	 	 	 	 	 H(p   芾 HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL-f
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t{	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1HP	 tVHڅuVHHcHMIHL1HZ	 I;u0D  H~/HHcHT1XHL1H	 u
Hջ   \$xHHcHHD1(    L-S
 Ht$p\$xLd$(HHcHHE3	 A	 u
Id	 I$HcHJL!HHt#HHPI;uH   HtK	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%r
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1H@	 ADމ$   HHHcHAHL1H	 ADމ$   u(H~#HHcHT1XHL1H	 ADHL%T
 Ht$p$   L|$(HHcHHD1(    HHcHHE3	 /	 u
IR	 IHcHJL9HHt#HHPI;uH   Ht:	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-K
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t`	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1H4	 u   \$x7Hυu.I~rM6HHcHMIHL1H)	 I;t   +Ht*HHcHT1XHL1Hѡ	 uHՉ\$xHHcHHD1(    L-%
 Ht$p\$xL|$(HHcHHE3z	 	 u
I6	 IHcHJL9HHt#HHPI;uH   Ht	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHH	 H	 H	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHH
 %H H;uIVHNH;HHQá	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HM*	 HH(
 sHH[H;uIFHMH	 HH	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PHP^
 H3HEpMMHHH   D$     H
 HD$`HM`	 D$    E3E3HT$hHL$`)	 HD$`HcHH8
 HD`HD$`HcHDxDD\   HL$hHHL$`YHH
 JHH?HH
 0HI%HAٟ	 HHHUPHL$``HxrH H
6	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 Hl
 HD$(H!
 HL$(l @SUVWHh  HD$8H\
 H3H$P  IHHDD$0$  D;   HL$@aH
 HL$@?HH4HHj
 %Hȋڞ	 HH8
 H$0  HL$@YH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3豰 Hh  _^][H\$WH 	HHf/v\XH\$0H _\(~XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3,	 Hj  HLsHsHuH{H|$hL?LHt3	 Hj  HHwHuH~H   H{(H|$hL?LHt3	 Hj  HHwC< HHҙ  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H	K	 t
Hj  HH    Hk~LFHHI H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3臾HC   HHC    H 艿HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHsH;uH   Ht$	 Ґ3H	 D$0t/HHcHHLHJ	 u   |$`	H\$P|$`HHcHHE3ؙ	 HHcHHLHHt*HHPHH;uH   Ht	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$h@ uB3HD$8H^
 HD$0Hҙ
 HD$(H
 HD$@H
 HD$HHL$(P HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHH$x  ? t
HHÀ< uLHHIE3HH2HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLH}  HC   HHC    H ۼHH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
w  IE3HHGA
   H*
 HHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHI蕹HC   HHC    H HH0[@WH   HD$ H$  AHHH$   P  HX(H
T
 HH0x8HH$   MN HHL$(_N H 
 HL$( @SH   HD$PHOU
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$( ȋD$ -ut=   w2t=w2ɄuB3HD$8H
 HD$0H
 HD$(H
 HD$@H

 HD$HHL$(L HL$pH3 HĀ   [@SH   H8T
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`rP u-HT$PHL$Xo t9C,+<:wH     HrD$PH$   H3K HĐ   [荗  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(  HL$UVWAVAWH   HD$8H$   IcIcHL3l$0HBH+HDDHD$   HLHI/IoIoMtBHt4HHHL;t̅tHHHL;tIHt3Z	 H*b  IMwIH\$PLt$`IHL$@Lt$HHD$@HD$hHD$PHD$pH$   HD$xL$   IHHH+HHH~%     )HH;}H\$PHL$@LHHL$h IH$   HĐ   A_A^_^]HT$HL$SH   HD$0I譖  DKH{uH f/8 wgD HHL$89  HT$PH{|  HL$8'	 $       $      HL$`H$   LT$XL$   H$   H$   I;HMHE3L\$PW3H~N   If/sQHIH;|II|LH2
 H
[
 j  H$   w	 HL$pl	 HL$Pa	 rC HĠ   [@SVWH`  HD$8HP
 H3H$P  IHLD$0Hc$  L;   HL$@褃H
 HL$@HHwHH
 hHȋ	 HH{
 NH$0  HL$@蜂H$0  H$H  HC$0  HD$ LD$0H
 H舙  H$P  H3 H`  _^[HUWATAVAWHl$H  HD$8HXHpH	O
 H3HEpML3ۉ\$0A   MPM;  EWD  HE~2MNfHcI;}$IIIHf.z uHI;|AIIcI;U  HY
 HD$PHݔ
 HD$`HM	 D$0   E3HT$hHL$Pr	 HD$PHcHHQ
 HDPHD$PHcHhTLHD$hHD$@HL$hԎ	 Hd
 HD$hH]Љ]H
 HL$`HH5
 HH^
 qHHS
 bHȍV	 HH
 GHAW	 HHd
 +HUPHL$P=~LMPH}hLCMPMMcMFHcLOHp
 HD$ Hο
 IN< HMpH3ѡ L$  I[8Is@IA_A^A\_]@SUVWHh  HD$8HL
 H3H$P  IHHDD$0H$  D;   HL$@pH
 HL$@NHHCHHy
 4HH	 HHF
 H$0  HL$@gH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3迠 Hh  _^][H\$WH HIH5	 HHHH	 zH/	 HHH\$0H _H%	 H\$WH HIH	 4HH)HHê	 H	 HHSH\$0H _H%	 @SH H	 IHH
 HHf	 Hr	 HHH [H%d	 H\$WH HIHm	 tHHiHH3	 ZH	 HHH\$0H _H%	 @SH H	 IHHa
 HH	 H	 HH6H [H%	 @SH H	 IHH
 HH^	 H8	 HHH [H%B	 @SH H	 I[HH
 LHH	 =H؋	 HHvH [H%	 @SH H	 IHHy
 HH&	 Hx	 HHH [H%	 HHHD$0D$    L
<
 L
 3 2HHHHHD$0D$    L
\
 L
 3 2HHHHHD$0D$    L
,
 L}
 3V 2HHHHHD$0D$    L
D
 L=
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L
\
 L
 3 2HHHHHD$0D$    L

 L}
 3V 2HHHHHD$0D$    L
,
 L=
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L
,
 L}
 3V 2HHHHHD$0D$    L

 L=
 3 2HHHHHD$0D$    L

 L
 3 2HH{^  \  H\$H|$L	LLAH*M+HIE3HHHH?HtfE3K3KDH+HHt%f     IHHKDK+HH;rHKHH+IHIHHH?HL;rH\$H|$@SVWATAUAVAWH  HǄ$   HD
 H3H$   IL$   L$   H$   HL$hL$p  E3Dt$DD$@   EH	 H
"	 EE H*	 H
;	 zIcU H$  9cHcWD$pL$   LHL$p7H$  Ht(L$  L+I襘W$  L$  MHL$xLd$pI+I*IHHHHH?HH      tGIԐILHBI+HHt!ff     IHHBH+HH;rIHL;rMHtHIfILHBI+HHt!ff     IHHBH+HH;rIHL;rD$@   EE H	 H
g	 IcU HL$PaILD$XIHT$PH+HHt#LIHLD$XIHT$PH+HH;rIL+IMtHHHD$XH+D$PHH;rD$@	   Dt$HEM DHT$HH$  谖  HHHH+IHHHH?HHT$0L=>
 L|$(LL?
 H
H
 p  IH;sH[HHI迗  HH$  e  D$@
   Dt$HEE HT$HH$    HH@H+HLL$XL+L$PIHD$0L|$(L
 H
 ap  IHD$XHL$PH+HHt4LLffAn AHM@HD$XHL$PH+HH;rH$  HtL$  L+IHL$PA   EH*L0	 I      ?H$   D;8  D$@   E;u ,  IcH$   L HxI+H  G;  IcH$   HHxH+H  G;|  3DfA/D  D$@   H|$XH+H|!G;}LLD$@   AHL$PHH
 H$   H
 H$   H$H  L	 D$D   E3H$   H$   
	 H$   HcHH
 H   H$   HcHh   H$   HD$hH$   Z	 H~
 H$   3H$0  $8  H
 H$      H	 H$  H$   pL$  H$  LC$  H	 HD$ DËqHو
 H$  HZ
 H$  H$H  $	 D$D   E3H$  H$  	 H$  HcHH
 H  H$  HcHh  H$  HD$hH$  2	 H}
 H$  3H$0  $8  H
 H$     H	 H$  H$  nL$  H$  LC$  H	 HD$ DƋIH
 H$  H2
 H$  H$H  	 D$D   E3H$  H$  	 H$  HcHH
 H  H$  HcHh  H$  HD$hH$  
~	 H|
 H$  HǄ$0      Ǆ$8      HĦ
 H$     Ha	 H$  H$  mL$  H$  LC$  H
 HD$ DËD$@   IcHL$xI+H*HHHLI?LLT$(D$    DH[HD$XH+D$PHMLM+LIHD$0H=@
 H|$(LD
 H
M
 j  3ITIDH+HHt&LD$P IHHIDI+DHH;rAHL$PD$@   HT$pH|$hH軒  HT$PHt#LD$`L+I?WD$PHD$`    H\$pHt4HT$xH) H$   H+HHHLI?LH|HH$   H3 H  A_A^A]A\_^[Hl$Ht$H|$ AVH0LHT$ LH  LGH*L+HI3HHH?HtLH\$@     IHHH  HOHH+HHHHHH?HH;rH\$@Hl$HHt$PH|$XH0A^HWATAUAVAWHPH@HXHhHpMLHIPI$ I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8w  Hl$@LH\$8LIT$Ie  HtZHHy$ HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HHz HII HFH+HH;s(:,~	 %~	 ~	 ~	 ~	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@H8
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`Hi	 H  3H  H  Hc	 HEpExH  HMp{	 H{
 H  H H  菟 H}
 HE@Hy	 HEHHEPHEXHy	 HE`HEhH\j
 HEH   Y  H  Y  H  j
   ~y   A   ~x DEHVXHzrHH   ҡE3HH   HcHH   uHAPcx	 H3Nx	 F|uH[	 H   H	 auHJ	 H   H	 @uHa	 H   H	 u2HX	 H   H	 HqHH)y	 H   襶 H   H膨      H   HzrHA   H  趠E3HH  HcHH  uHAPGw	 H32w	 F|uH?	 H  H	 auH.	 H  H	 @uHE	 H  H	 u2H<	 H  dH	 HUHH
x	 H  艵 H  HjHǅ     E3L  D   EFH	 H   gH'u
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  GH  HrSHH   H=   r<ty	 HAH;ry	 H+Hsy	 H'vy	 H趐 L   HNHYHyrH	HA   I;LBMtHE	 b u1Hu+KlR H   LF8HV(HCHH      % HH[w
 HH   WELuAEHUIZHz
 HEWELuAN   D.DvDu~HH
n
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHI  DGHUHMHD$ IH  F  HOH*TH  Ht)L  L+I談W  Hǅ      HUHtLEL+I|Hy
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHIԐ  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHI  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHI{  DHUH   XHM1HQH}LL+t	 HH}H}8HO HUbMw8HUHtLEL+IH  HtL  L+IH}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMFHǅ     Hǅ      ƅ   A   H	 H  蒏LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   ? LH  SH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHI芶  D    PHMmEA
   H 	 LuI蔎IN A   H	 ~IN@A   H
	 hIN`A   H	 RI   A   H	 9Hǅ     Hǅ      ƅ   A   HC	 H  LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   谮 LH  Q    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI%  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIy  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI蒺  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E?  Dq  d  PHM?A
   H	 LuIIN A
   H	 IN@A   H	 ͈Hǅ     Hǅ      ƅp   A   H	 Hp  藈LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H   D LHp  L          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIW  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ 1  D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ o  DLupEWA(WEHE    DEHUH+UHLEHM_B  HMH+M HLM L+MILɋ   ~gfn
 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@?  G HOpH/7  H   HM?HD$ IH  蚀  HOH~CH  Ht)L  L+IvW  Hǅ      H   HtL0  L+IvH  HU>  H   H  RHǅ     Hǅ      ƅ   A   E3H	 H   {HEHtTA   LH	 H   {LEI+LH  H   DHH  FH  wED   D   A   E3H	 H   Y{H  HHEL@A   Hf	 H   *{HLLEH  H   DHH  ]RH  DH   H  a	 A   LH	 H   zHL@A   H	 H   zLLGH   H   CHH  FH   YDH   H  ma	 Hx  (QHx  +c	 H}8H  H  H;tIE3H  AIP  HW  Hǅ      MX  H  轗 HU H W   Hǅ0      LEH   N LM LEH(  H   K  H  H  <  H  H   ,7HOXHUp7MtI   IH   Ht&H(  H	 L0  L+IHKqH  Ht=H  H H  H+H*HHLI?LH`H  BH   BHUHtLEL+IsH}Ht HU H8	 LE(L+IHpH} HtHUH	 LEL+IH|pH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H	 Hp  }H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H   \ HHEpHp  )AH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    u   I  DW   E3L0  L   H   H   W H(  H   H+I*IHHHH?HHH  ;EL  L  M+IMt ff     HHKIHM;rH}8H  H   8  H  HU3H  H  8HOpH0  HU HM'HD$ IHMy  HOHi<HUHtLEL+IoWELuHU HtLEL+IoHMpHtH   H  HtL  L+IoH   Ht:H(  H H0  H+IHHLI?LH\E3H}HtH   HHUHtLEL+I!oWELuH5T
 HuH]HtHH& LEL+IHlH#Z
 H@  HP  8>H@  Hx  KHx  ]	 H  .  H   -  AH  H3n L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHH+$3fD  H;_s^I4H
 HHH
 H;
 r
   HH$   Ht
(貴HHHD$8HHMLD$8H$   H  H$   pH      ?HHH=
 H

 H9

 t	Hn
 $HH+b
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HIf8HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v\	 H    H=   r<t\	 HAH;r\	 H+Hs\	 H'v\	 Hs 车 (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH!3fD  H;_s^I4H
 HHH
 H;
 r
   ʪHH$   Ht
(bHHHD$8HHMLD$8H$   H  H$   pH      ?HHH=B
 H
[
 H9
L
 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI6HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;vZ	 H    H=   r<tqZ	 HAH;raZ	 H+HsQZ	 H'vDZ	 Hcq m (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
ϑ
 	V	 HL$8:  3I9~  HL$@LD$8     I4H!
 HHH
 H;
 r   @HHL$@LD$8H$   Ht(H˯HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$89  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8-9  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
 T	 H
Տ
 T	 MLD$8H$   I  H p蹡 HL$8Ht{HD$HH+HH;v_W	 H    H=   r<tCW	 HAH;r3W	 H+Hs#W	 H'vW	 H5n WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
 R	 HL$87  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   HHL$@LD$8H$   Ht(H蛬HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8{6  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$85  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
 P	 H
 P	 MLD$8H$   I  H p艞 HL$8Ht{HD$HH+HH;v/T	 H    H=   r<tT	 HAH;rT	 H+HsS	 H'vS	 Hk WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH L@HPHHSVWATAUAVAWH  Hǀh)p)xD)@D)HMH3H$   Hf.IU IEH+HHuZH3[	 HD$`3HD$hHD$pH
 HD$xƄ$   HT$hHL$xvQ	 HQ
 HD$`H3
 HL$`i DD$  IEH+HHwZHZ	 HD$`3HD$hHD$pH!
 HD$xƄ$   HT$hHL$xP	 HQ
 HD$`H
 HL$` A   DJD$  W$   E3EL$   HFxHD$xLcL$   EL$   M_  IH$   @ IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   H$  H+HI;   IH+HH   H+HIH+H9  HL+IIHIH+IMI;LCL;ICH$   /L$   H$   IH$   L$   L$   H   HH   I;   IH+HHsxH+HIH+H   HL+IIHIH+IMI;LCL;ICH$   聈L$   H$   IL$   L$   Ht2HH$   IL$   M;s{-H
F
 L	 H
8
 rL	 HX	 HD$`3HD$hHD$pHj
 HD$xƄ$   HT$hHL$xEN	 HfN
 HD$`H
 HL$`8 IEI+E HL;rZHW	 HD$`3HD$hHD$pH
 HD$xƄ$   HT$hHL$xM	 HM
 HD$`H
 HL$` IIIE b (WX$   $   L$   L$   LcF,L$  E3AH$   H$   Mj  IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   L$  L+II;   IH+HH   H+HIIH+HO  HSL+IIHIH+IMI;LCL;ICH$   L$   L$   H$   H$   E3H$   L$  HtJHL$     I;   IH+HH   H+HIIH+H   HSL+IIHIH+IMI;LCL;ICH$   BL$   L$   H$   E3H$   L$  Ht3HH$   HH$   I;s{
H

 @I	 H
 2I	 HT	 HD$`3HD$hHD$pH*
 HD$xƄ$   HT$hHL$xK	 H&K
 HD$`H
 HL$` H$  H;G   LH$  L;   L$  M+IHGH9Gu{H+GHHsmHOI+HIIH+HsH
"
 \H	 HWI+HHLGM+IIHL+IIM;HCH;HCH轃HOHHt.JH%HGH9Gu
   HA]HGHtD HGH$  H;GsKHH$  H;w;L$  L+IHGH9Gu
   H\HOHHt.JH%HGH9Gu
   H\HGHtDHGE3ED9nx~7H$   Ld$xfIcHHA%AE;<$|H$  L$   H$   H;GsKHH$   H;w;L$   L+IHGH9Gu
   H$\HOHHt-JH$HGH9Gu
   H[HGHt8HGED9n,L$   ~$D  IcH    IHz$AD;~,|W$  HǄ$       w
 |   DF(Ho
 H
 HcV(HL$`#E3ALL$hIHT$`H+HI      Ht0L@ f     M<HLL$hIHT$`H+HH;rIL+IMtL<HHD$hH+D$`HH;rľ
 }   DF(Hn
 H
n
 5HcV(H$   "E3AL$   IH$   H+HHt4Lfff     M<HL$   IH$   H+HH;rIL+IMt+fff     L<HH$   H+$   HH;r
 ~   DF,H}
 H
x
 oHcV,H$   ."3ɋL$   IL$   I+HHt0M    M<HL$   IL$   I+HH;rM+IMt.@ ff     M<HH$   H+$   HH;r>
    DF,H}
 H
~
 诶HcV,HL$xq!3DL$   IHT$xH+HHt N<IL$   IH+D$xHL;rHT$xL+IMt+@ ff     L<HH$   H+D$xHH;r㋆   uv
    H   H   HV0LN(LL$@LNxLL$8HD$0HL$(HT$ L$   L$  H$  H$(    HHL$`W        
    H   H   HVHLF0LN(LL$HLNxLL$@HD$8HL$0HT$(LD$ L$   L$  H$  H$(    HHL$`aW  H$(  HtL$8  L+IUL$      H
{
 $  ;F,q  I
    LcHI+HH$  HL$(D$    EDĳL   L+   IH
{
 HL$(D$    E薳H   BtCYtL$   L+$   IH
J|
 HL$(D$    EQH$   Bt
    Hz
 HD$(D$    ED$  L   L+   IH
kz
 HL$(D$    EH   BtCYtL$   L+D$xIH
{
 HL$(D$    E褲HD$xBt$  xA   =
 D;~(  
    IcLD$hL+D$`IH
,{
 HL$(D$    D;HD$`H$  H   Lly
 H  HH$  H$   H+$   HLIL+	IHD$0Hh
 HD$(Lh
 H
h
 Z-  H$  LAL+IH$   H	(Lx
 HH     HH$  H$   H+D$xHLIL+	IHD$0Hkh
 HD$(Lch
 H
`h
 ,  H$  LAL+IHT$xH	cXH$  YtXL$   L+$   IH
jh
 HL$(D$    DݰH$   tAK
    E3D8$     A;^(}HcHD$`HHA;^(}HcH$   HHAfD  ;^,}HcH$   HHtA;^,}HcHD$xHHTHT$x$   P  Ht%L$   L+ITQWD$xL$   H$   Ht(L$   L+I"QW$   L$   H$   Ht(L$   L+IPW$   L$   HT$`HtLD$pL+IPWD$`L|$pH$  Ht#ML+IPW$  L$   Mt&M+IMIiPW$   L$   H$   Ht&L+IMH6PW$   L$     Ht%L$   L+IPWD$xL$   H$   Ht(L$   L+IOW$   L$   H$   Ht(L$   L+IOW$   L$   HT$`HtLD$pL+InOH$  HtL+IMQOMtM+IMI9OH$   HtL+IMHOL$  A(sA({E(CE(KIA_A^A]A\_^[LWH`ICI[IsH) H3HD$XHIK3t$ H1HqHqD$    HHD$P   Ht$H@t$8DFH?	 HL$8YHD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHNHH;HKHthHA   HqHyrHHH@HCH9Cu
   HlNHKHt(HA   HqHyrHHHT$8  _HC HD$PHrQHHL$8H=   r<t=	 HAH;r=	 H+Hs=	 H'v=	 HT HHL$XH3ZM H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUH:L?LLE   HuHI?LuI;   HHM>HHMv HHFHMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHS HI;{<	 <	 <	 x<	 q<	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   H8HOHMPH[HHHMXHt2HGH9Gu
   H8HOHMPHMXHt
HUHGHMHtiHEH+HI;v;	 H    H=   r<ty;	 HAH;ri;	 H+HsY;	 H'vL;	 HkR H   IHF  HMH+IHHHH?HH
H;v:	 HRHH=   r=@t:	 HFH;r:	 H+Hs:	 H'v:	 HHQ HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHHo  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   H9HSHt(H
H;Cu
   Hy9HCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H8HSHt(H
H;Cu
   H8HCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_H\$Ht$WH IHHH;t HHHHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HHTH H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`j4	 H5*
 Ht$hH
4	 4	 HHEH;xsHHHH   3ۀx$ t24	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8HtY
 HD$0H/
 HD$(H HL$(Y H\$hH}
 HHRH8F HL$`3	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$PW3	 H
 HD$XH
5	 3	 HHFH;xsHHHH   3ۀx$ t3	 H;xs
H@HHumH\$XHucHHL$XD3	 Hu13HD$8H`X
 HD$0Ht.
 HD$(Hи HL$(X H\$XHa
 HHPH$E HL$P|2	 HH\$`Ht$hH@_H\$WHPH H3HD$@HHD$8   HL$ HD$0    ID$  E3QHLD$ HWHh HHD$8H+HHrQHL$ HH=   r<t`5	 HAH;rP5	 H+Hs@5	 H'v35	 HRL HHL$@H3D H\$`HP_H(Hu3H(HH;w*H\$ H    H3	 HuHuH\$ H(@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0O t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHRu  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHRe  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H	  HK.
 HCPH [HL$SH0HD$ HD$P    EtH
 HA@H.
 HAPD$P   J   H3
 HHS
 HCHC@HcHH3
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH9	 HHQ3HHBHK,0	 HM0
 HH{3HHDH^H\$HHM5
 HHOHKHtHPHGHCHGHCG C H
"
 HH06
 HHH\$PHt$XH0_H,
 HH@SH HHI050	 HK +0	 HH [H%0	 H*
 H@SH HH   H`HcPH&0
 HHHHHcPDHDDHh-	 HH [H%.	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3LHo(Hs(H;t<HHRH]HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3KGxCxGyCyG|C|H   H   H;tIE3K                                                  HH\$HHl$PHt$XH0_H\$WH H  HE*
 HGPt
X   HE HH\$0H _@WH0HD$ H\$@HH
 HH1
 HAHI HtHP tHC     H6	 HHK,	 @t
@   H(E HH\$@H0_H	HtH   H k  HUHl$H  HD$8HXHxH H3HEpIID$0    3A fAn	 f/rHHr   H52
 HD$PH.
 HD$`HM+	 D$0   E3HT$hHL$PN+	 HD$PHcHH-,
 HDPHD$PHcHhTLHD$hHD$@HL$h(	 H@'
 HD$hHE    E    H
g
 HL$`cHL$`*	 HUPHL$PhHEPH}hHCEPHD$ L
f
 LHb
 H
\a
   HMpH3
< L$  I[I{I]HUHl$H  HD$8HXHxH  H3HEpIID$0    3A	A;|HHr   H0
 HD$PHF-
 HD$`HM*	 D$0   E3HT$hHL$P)	 HD$PHcHH*
 HDPHD$PHcHhTLHD$hHD$@HL$h='	 H%
 HD$hHE    E    He
 HL$`HL$`(	 HUPHL$PHEPH}hHCEPHD$ L
e
 LHl`
 H
_
   HMpH3: L$  I[I{I]H8MPE3MPMtYMH\$@HH|$0H      ff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8  @SH0HD$ HHW
 HH-
 HAHI HtHP tHC     H1	 HHKH0[H%(	 LH   ICAC    HQHc
 ICHp%
 ICAC   IKHd*
 HD$(H K
 HD$@HD$hHcHH#+
 HDhHD$hHcHDd    Hި HL$(K @SH0HD$ HٹX   << HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH)
 HHeJ
 HAHA@HcPHj*
 HD
@HA@HcPDBDD
<HU
 HH[,
 HAHI HtHP tHC     Hu0	 HHKH0[H%J'	 @SH0HD$ HH
 HH+
 HAHI HtHP tHC     H0	 HHKH0[H%&	 HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIv  HWH*  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHq pMt/HWI  HOH+IHHLI?LH"HNH+IHHHH?HH#tLHVH<q HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+HV7HH+HH4H+H;7HOHHLH+HH+O  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   8 HH$   LCMu	HG
 
IP(HuIP0HL$(!	 HǄ$      3H!	 HB
 HHH  H>HL$(!	    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
t\
  	 H;s/LHjHtH{HsrH3 H\$0Ht$8H _HsH;LƲLBZ8HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    H"'
 HH
 HAH   !	 D$H   H_E3HH!	 HHcHH"
 H9HHcHHT9H\$PH	 H
 HC| Cq H	 Hǃ       H
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH
 HHn&
 HAHI HtHP tHC     H*	 HHKc!	 @t
@   H9 HH\$@H0_H\$WH HHHUt
  H[9 HH\$0H _@SH HH	&!	 HKH [H%!	 LHXICLI@I+ HHQH;rQH)	 IC3ICICH&]
 ICD$0ISIK 	 H( 
 HD$8H\
 HL$8  HBHAI HX@SH HH	H   HS  HH*HSH+HHHH?HH
H;v !	 HRHH=   r<t 	 HAH;r 	 H+Hs 	 H'v 	 H7 3HHCHCH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH
 HA@H
 HAPD$P   OH!
 HHOHA
 HHG@HcPH!
 HD:@HG@HcPDBDD:<HSHHDaYHH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H		 HtHHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
:W
 t	 L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HHaTHSLHHO HH{H+HHtLCL+I.HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
U
 	 H|$@K<H   HvH
U
 	 H9{s#HHcH   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0	 H{rHHHtLHs H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%	 HWAVAWH   HD$(HXHp H H3H$   LLHL$ Hj	 HT$0IT	 3IFIF IF(HT$`I8	 H
g>
 $  IFI/	 HHHHǀ<8 uHǺ   H#	 HHu	 HHtHRHvHuIN I	 HHÀ< uHú   H	 HHuR	 HHtff     HIHHuIV(fAF.,H$   H3+ L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
_S
 	 LAI+H|$8H|$PH;HGIHH;wH
S
 @	 Ht$0I48H  HvH
R
 	 H9qs H`H   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8	 I;u>HKI?MIDHrHHHrHHHt8HLp	 *I~rM6H{rHHHtK>Lo H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HH4 HH0[@SH HHHSH
Q!	 H3H
HJHH	 3HC HC(HC0H	
 C8HH
 HCHH [@SH0HD$     *5 HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH
P
 	 I4L+IIHH+I3I;HCH;HCHt$@HRLHD$8HD$0LHT$xHm HD$0LH$   H$   i HD$0LHWHL$xm HWHHH+HHHt藽  HLGL+I%HIHwHIH_L7%IH~i HHWLHL$x( H_H\$pHPA^_^@SUVWHx  HD$8HL H3H$`  IIHHI@I+ HL;   HL$@oHwS
 HL$PkHHQ	 HHS
 kHHR
 kHHR
 tkHHJR
 ekH$@  HL$@sHCH+HHD$0H$@  H$X  HC$@  HD$ L
R
 LD$0HH| H$`  H3% Hx  _^][@UVWHp  HD$8H$  H H3H$`  IHLL$0H$  H$  L;  HL$@HtN
 HL$@rjHHgjH$@  HL$@H$0  WHN
 H$0  2jHH N
 #jHHjHHNN
 	jHH	 HHN
 iH$   H$0  9H$   H$8  HC$   H$@  H$X  HC$@  HD$ L
|H
 LD$0H H$`  H3z$ H$  Hp  _^]Hx)t$`()|$PD)D$@D
 D)L$0D
y
 fD/D)T$ EWA(r`A(\(j (\f/
5
 vAXfA.zu7	 
  !      =
 Y(dj ^fA.ztf/5
 r
(豺 O
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(л X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PHP H3HEpMMHHH   D$     H
 HD$`HM`	 D$    E3E3HT$hHL$`)	 HD$`HcHH8
 HD`HD$`HcHDxDD\   HL$h;HHL$`YgHH4
 JgHH?gHH:
 0gHI%gHA	 HHgHUPHL$`` HxrH H
6	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 H
 HD$(HX HL$(l4 @SH`W)t$Pf/D)D$0D(   u+DW
 3A(W
 (t$PD(D$0H`[
 fA/DW
 A(v(
9
 \((t$PD(D$0H`[3bXµ
 (t$PD(D$0H`[5
 fA/)|$@D)L$ D
 !  
 fA/vTfD.z  T|
 eH%X      HЋ9͞
   %
 AYDYQ
 AX  
|
 eH%X      HЋ9n
 
  A(AY(Y((Y%
 (Y
W
 Y
 X%ח
 X
/
 X
 YYY
 X%
 X

 YX
 XYX^X%
 AY  3t

 A
 fA/  '{
 eH%X   =`
 fA/   HЋ   9Ț
   A(A(\AYW¾
 (Ye ((Yx
 (Ye
 (Y

 XJ
 X:
 A^X

 YYYX
 X
Y
 YYX(YZ
 X
*
 Xڌ
 X2
 YX
 YX^X
 Y  
 fA/   9
 '  A(A(\AYWʽ
 (Yd ((YȈ
 (Y
 (Y

 X
 X
 A^X

 YYYXa
 X
Y
 YYX(YZ
 X2
 X:
 YXX

 ^X
 Y  
 fA/   9Ԙ
   A(A(\5
 AY(W׼
 Yc ((YP
 (Y=
 (Y

 X"
 X
 A^X

 YYYX
 X
Y
 YYX(YZ
 X
 X:
 YXX

 ^X
 Y   9K
 Z  A(A(A^AY(YW
 b ((YV
 (YC
 (Y
Ȑ
 X(
 X
 A^X

 YYYX
 X
 X
g
 YYYX
 X
;
 X(YT
 X<
 YX 
 YX^X
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H

 U =
 ܮ
 H

 =
  H
T
  =H
 (
 H
4
 (
 
 
 Β
 (
 
 
 

 (
Ҵ
 
 
ۊ
 J qH
*
  =
 V(Y
 H

 (
 
 (
 Έ
 (
 

 (
 
 j
 
˃
 (
 
 
Ճ
  H
d
  =X
 (+
 H
D
 (
 v
 (
 
x
 (

 z
 (
 
L
 (
E
 N
 
W
 > [H

  =
 .(M
 H

 (
ϱ
 p
 (a
 
r
 (
c
 t
 (Ų
 

 (
w
 
 
ɋ
  H

  =ؖ
 (
 H
Ė
 (
 ʌ
 (ù
 ܌
 $
 ܌
 (Ŵ
 

 (
G
 (
 H
 
	
 (
 *
 

 " @UVWHp  HD$8H$  H H3H$`  IHLL$0H$  H$  L;   HL$@4HA
 HL$@]HH]H$@  HL$@UH$0  H#A
 H$0  \HHA
 \HH\HH@
 \HH	 HH@
 \H$   H$0  H$   H$8  HC$   H$@  H$X  HC$@  HD$ LD$0H  H$`  H3! H$  Hp  _^]@USVWAVHl$H  HD$PH5 H3HEpIHHL   D$     Hw
 HD$`HMH	 D$    E3E3HT$hHL$`	 HD$`HcHH 	 HD`HD$`HcHDxDD\   HL$h/HHL$`A[HH(
 2[HH'[HH.
 [HH@
 	[HHuH**
 HZIH	 IHZHUPHL$`)HxrH H

	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@L	 Hm
 HD$(H! HL$(5( DD$USVWAUAWHl$H   LjLy3HHM;otI	 Mt
I[II7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH	 Mt
IHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMq HIH HHGHGHtH<	    
H
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM' w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH	 Mt
IHH7LEwH_HUoLwHj H}HEHHMLwH]LuHEVw W(f.z
u5
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]Lu IUHO(QLG(IH HW(H|$ Iѱ G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM, ($   L$   HL$   fG<Hĸ   A_A]_^[]YYY@SH HHHSH
A		 H3H
HJHH 3HC HC(HC0H>	 C8HHe		 HCHH [LHXIC3ICH"
 ICHi	 ICH.R
 ICH
 ICIK6 @SH`  HD$8H H3H$P  DD$0H$  D;   HL$@,HX9
 HL$@
UHH%
 THH19
 THH HH8
 TH$0  HL$@H$0  H$H  HC$0  HD$ L
|3
 LD$0Hl%
 H
=%
 `\H$P  H3o H`  [HUATAUAVAWHHH  HD$PHXHpHx H H3H  M3t$@I@HD$0H(
 HD$(MHLH
,)
 oML$I  DM  
\
 ԡ
 @ M]MM;}UI$N    IIIHIIIL@      A \Tf/rIHMM;|MM;x  H=
 
 H|$`HM D$@   E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHxT\HD$hHD$HHL$h H	 H\$hHuE   H7
 HL$`RHH&
 RHH7
 RHIU HH06
 {RHIW HH2
 _RH`  HL$`H}PH    D$@   E3E3HUXHMP HEPHcHH	 HD
PHEPHcHxT
LHEXHD$HHMX H]XHǅ       ǅ      I<$I\$IIH6
 HMPQHH%
 QHH~6
 QHIW HH&5
 qQHIU HH1
 UQH H@  HMPL@  HX  LC@  L`  Hx  LC`  M$ID$IIMLT$ H$
 H
&
 L  H  H3 L$  I[0Is8I{HIA_A^A]A\]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;tSIHHt3 HTHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVHl$H  HD$PH H3HEpMHHH   D$     H	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h_#HHL$`NHH7
 NHHNHHM"
 NHHr-
 NHI HHrNHUPHL$`HxrH H
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H	 HD$(Hx HL$( HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH
 HEL%X	 LeHu	 HEHr	 HEL5	 LuD$    L-t	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH} 	 HE3HEHEHUHM H	 HD$0H=	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP H.	 HD$@H	 HD$HE   
b
 eH%X   A   HȾ   A9V
 Z  H
I
  ==
 A  NW/
 LHEwH	 IF@H	 IFPD$    HT$0I  H	 IH	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw< HUHHMHH]wHt=C;u2HHP{;u LI@H
0H;HuAАMIHM)1E-
 fsfH~HtBHM0H
w 

 H

 A L5	 
 
 fsfH~HtpHu	 HD$0H	 HEHEHcHHV	 HD
HEHcHQT
Ld$0H~ H]HMX Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR HJ
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH
 HEL%	 LeH-	 HEH"	 HEL5/	 LuD$    L-$	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH- HE3HEHEHUHM H9
 HD$0H}	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP H	 HD$@Hb	 HD$HE   
^
 eH%X   A   HȾ   A9R
 Z  H
E
  =9
 A  NW LHEwHa	 IF@Hn	 IFPD$    HT$0I%  H
 IH	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMwL HUHHMHH]wHt=C;u2HHP{;u LI@H
:,H;HuAАMIHM,E
 fsfH~HtBHM>,H
  H
}
  L5N	 
 H
 fsfH~HtpH
 HD$0H	 HEHEHcHH	 HD
HEHcHQT
Ld$0H. H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR H~
 H$H  H   A_A^A]A\_^]LEK ECWH`ICI[IsIcLH3t$0y*H>+
 ICL
*
 MCH*
 H
y-
 Ey/H+
 HD$ L
*
 L$   HX-
 H
E-
 IcWD$@Ht$PHL$@5HH3HsHsLD$@Hi HT$@HtLD$PL+IHH\$pHt$xH`_DD$SH@HH3ɉL$0Ex"HHKHKHIcL4HH@[H4*
 L
)
 HD$ LD$`H
 H
m,
 H\$WH@LILC)
 L+	HHBH
B)
 H+HHHD$0H)
 IHD$(L3HCI+HHt(HfnHRAHHCH+HH;rH\$PH@_H\$WH@LIL(
 L+	HHBH
(
 H+HHHD$0Hl(
 IHD$(&L3HCI+HHt,H@ ff     HIHHCH+HH;rH\$PH@_@SH0HD$       HH0[HHHD$pI*HHH+IHILIIH?LIHI+L'
 HLL$0H
'
 HHH?HH'
 LHD$(=HH@UVWATAUAVAWH$pH  HD$HH$  H5 H3H   MHHHL$(3Dt$ IPIВ  IIFHCH+HsHI[  WD$0Ht$@HHM`貮HT$0H赠 L|$0ILd$8M;  H	 H
q	 HL$`HT$pHM ADl$ E3HT$xHL$` HD$`HcHHo	 HD`HD$`HcHhT\HD$xHD$PHL$x H	 HD$xHuuHHL$pDHHH	 @HsH+3H3Ht(HHL$p. HHH	 o@HH;rHHL$p HHH	 G@HU`HL$`YHIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICI/HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICI
/IvHtrHF   3HNH~rHHƈHsLGItHH 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM HI;t(H|$(39H
!
 + H
!
  Mt6IIl  HL$@I+H*HHLI?LIH   H3" H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H) H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHMHHMWE3H]Ll$8H|$0\$(L$ LMMHHMw HE   H]]DCH\u	 HM#HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H L|$8H|$0Lt$(EwD$ ]oLEHUH HUHt LEL+IWEHE    HUHtLEL+IHMH3 H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   HHT$PHtLD$`L+IhHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xH' H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`HHL$dW$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$xf H$  hL$   HT$xIB (D$@IH$  IPH$x  H$x   E3|$@L$   L$   Ld$pH|$hH$  Hq	 H$  $9H( IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   Hr	 H$  3H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH

  HQM+IIHL+IIM;HCH;HCHL$H'HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH
	
 C HQM+IIHL+IIM;HCH;HCHL$H0'HL$PHt0HA   LqHyrHHH$    kHL$PH HL$PH$  pAEHT$HItI$H
y	 H;tHT$HIP A$     D
W
 D΄
 $     W$  L$  H$  ?D$0D$(H$  HD$ LD$xI
H$   H$  uHXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  ] I$L@H
}	 H$  H;uIL$IAАH$x  H$x   H$  HtL$  L+I|$@HHH%H;tHD(L$   HT$xI (D$@H$      H$    HHo	 H$   !5HHuI
H HcHHHW
   H$    HƋH HH=	 4HH(o	 4HHuI
H HcHHHW(A\(H: HHn	 4H( HHQ=	 h4IH$   IPATH$x  H$x   fD/s;$  H|$haW$  L$  H$  D$0D$(H$  HD$ LD$xIyH$   H$  HXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  sZ I$L@H
	 H$  H;uIL$}IAАH$x  H$x   H$  HtL$  L+IHL$HHt.HT$P  LD$XHT$HL+I|WD$HLt$XH$x  H$x   HT$xHt%L$   L+IWD$xL$   H$   HtL$   L+I3H$   H3P L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xHA H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$x	HHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`蟖 H  H  H  ^L H  HUH   H  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#3 H襦HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  k H`      	    	    	    	     	    Hc(	  H  8  =
 Wt$XH  Hi	 H  P/H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   Hi	 H  dH  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH

 + HQM+IIHL+IIM;HCH;HCHL$@HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
=
 w HQM+IIHL+IIM;HCH;HCHL$@dHL$HHt/HA   LiHyrHHH    HL$HH HL$HH  覷AEHT$@HjIH
	 H;tHT$@IP 0	  @   WELmH  D$0D$(HEHD$ LD$`HoH  H  HXH  HtIH  IPHD$XHD$ A   LEHUHMvS IL@H
	 HUH;uIO膯IAАH(  H(   HUHtLEL+I
H
Lc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   Hcf	 H  IH  IP H  ٵH  =  D8  Wt$XH  HL$`許3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HMu HH'4	 H   *HHu3
H HcHHHWHH/ HH3	 p*   HM HH3	 H   K*HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HH3	 )H(  l (YH     HMz HH|3	 H   )HHu3
H HcHHHW   HM) LHu3
HHcHHIPA(H  HH3	 I)   HM( HH3	 H   $)HHu3
H HcHHHW   HM8 LHu3
HHcHHIPAH  k (Hl HH2	 (
   HMH^ HH7	 H   (HHu3
H HcHHHW   HMX
 LHu3
HHcHHIPAP  H HH7	 ((
   HMh HH7	 H   (HHu3
H HcHHHW   HMx LHu3
HHcHHIPAX  HR HH6	 'HP     HM= HH7	 H   o'HHu3
H HcHHHWHH HH6	 8'H9	 H   %'HHh  F+HH`9	 'IH   IPH(  :H(  = 0	  HuH  H  ߽HXH  H   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  H  v@  W  H  H  蟾D$0D$(H  HD$ LD$`Hk}H  H  ؼHXH  HtIH  IPHD$XHD$ A   L  HUH  lL IL@H
	 H  H;uIOyIAАH(  脼H(   H  HtL  L+IEH
@
  W  3H  H  ~D$0D$(H  HD$ LD$`HJ|H  H  跻HXH  HtIH  IPHD$XHD$ A   L  HUH  KK IL@H
	 H  H;uIOXIAАH(  cH(  f H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H^	 IH  IP H  5A$   H^	 IH  IP H  蹭F   EH    LHN6	 H  >2MHIAP H  sH  fHL$@Ht.HT$Ht  LD$PHT$@L+I{WD$@H|$PH(  H(   H  w  H    H(  ޹H(   HT$`HtLD$pL+IUWD$`H|$pHUHtLEL+I~H`  H3- L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xH! H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$` H  肹H  H  4 H  HUH   H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3 H腖HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  [ H@ Hc	  H  2  	    (	    0	    8	    @	    H	    HcP	  H  8  =y
 Wt$XH  HZ	 H  H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   HaZ	 H  1H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH

  HQM+IIHL+IIM;HCH;HCHL$@
HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH

 D HQM+IIHL+IIM;HCH;HCHL$@1
HL$HHt/HA   LiHyrHHH    mHL$HH HL$HH  sAEHT$@HZIH
}	 H;tHT$@IP X	  @   WELmH  mD$0D$(HEHD$ LD$`H<tH  H  詳HXH  ٦HtIH  IPHD$XHD$ A   LEHUHMCC IL@H
	 HUH;uIOSIAАH(  ^H(  a HUHtLEL+IH
Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HW	 H  IH  IP H  詥H    D8  Wt$XH  HL$`x3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   TH`     HME HH.	 H   wHHu3
H HcHHHWHH HH-	 @   HM HH+.	 H   HHu3
H HcHHHW   HM LHu3
HHcHHIPA(Ho HH-	 H(  \\ (YH     HMJ HH.	 H   |HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HHJ-	    HM( HH,0	 H   HHu3
H HcHHHW   HM8q LHu3
HHcHHIPAH  P[ (H< HH/	 
   HMH. HH/	 H   `HHu3
H HcHHHW   HMXݿ LHu3
HHcHHIPAP  H HHA/	 
   HMh HH/	 H   HHu3
H HcHHHW   HMxP LHu3
HHcHHIPAX  H" HH,/	 kHp     HM
 HHo/	 H   ?HHu3
H HcHHHWHHǿ HH/	 H0	 H   HHh  HH/	 IH   IPH(  
H(  
 X	  HuH  H  语HXH  ߠH   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  H  F@  W  H  H  oD$0D$(H  HD$ LD$`H;mH  H  訬HXH  ؟HtIH  IPHD$XHD$ A   L  HUH  << IL@H
	 H  H;uIOIIAАH(  TH(  W H  HtL  L+IEH
m@
  W  3H  H  ND$0D$(H  HD$ LD$`HlH  H  臫HXH  跞HtIH  IPHD$XHD$ A   L  HUH  ; IL@H
	 H  H;uIO(IAАH(  3H(  6 H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   HO	 IH  IP H  轝5A$   HtO	 IH  IP H  艝F   EH    LHV,	 H  "MHIAP H  CH  6HL$@Ht.HT$Hc  LD$PHT$@L+IKWD$@H|$PH(  H(   H  G  H  ˍ  H(  让H(   HT$`HtLD$pL+I%WD$`H|$pHUHtLEL+INH  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pHHL$tWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHMxv H	 H   H   HuH   HEL}HEHHUH+HWEHt!3 HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%	 LeHaHEH]LL+tHHa WED$xHE    HL$xDHT$xH   H   PAEHT$xI|MHHT$xHP HL$xHt|HU`  HEHL$xH+HHH;v HH=   r<t HAH;r H+Hs H'vx H Ld$xHMYHEHMHMHULL+tHT EEfEML   HT$xHM.  L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H    J +fn^5_
 LM(WJLM(WJ(WHMNLeHM| Hr H	 H   HMHtsHEH+HHH;v H    H=   r<t HAH;r H+Hs޸ H'vѸ H 3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHH5H$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH萨 H$   aL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH> H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH谯 H$   qL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH}H$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH> H$   L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   dHH   uWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$pk H	 HEWHMKKHԷ	 HEH	 HEH}HZ	 HEH   HEH   HE(yZ
 )E (
X
 )ME        .W
 E(E0    E4 WE8H_	 HE   f/vM   f/vBU
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM' H	 HEH	 HEHM> HM4 HM* HS	 HEHT$pHtLEL+I荿3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   fHH  wW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$ph H	 HEWHMGHHд	 HEH	 HEH}HV	 HEH   HEH   HE(uW
 )E (
U
 )ME        *T
 E(E0    E4 Wu8EH H?	 HEPQ
 Ex(
W
 )   xS
    uXW)E`H-	 HEH5	 Hu@P  f/vE=Q
 X  f/vf/vM`  OȉM$Y Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM9 Hu@Hݤ	 HEH"	 HEHM| HMr HMh H	 HEHT$pHtLEL+I˻3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHvH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH謸 H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHUuH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHj H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHerH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHܿ H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH%qH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHz H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   ĮHH   ժWEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$pC_ H	 HEWHM>H4	 HEH		 HEH}H	 HEH   HEH   HE(M
 )E (
K
 )MH
 ] WM0E(
   HW	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM舨 H	 HEHE	 HEHM HM HM H	 HEHT$pHtLEL+I3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   ǫHH  اW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$p@\ H	 HEWHM;H1	 HEH	 HEH}H	 HEH   HEH   HE(J
 )E (
H
 )M=E
 } Wu0E(
   E@ H	 HEH(EJ
 )Ep(
L
 )   W)EPu`Hأ	 HEH5	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
xF
 ( Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM Hu8H%	 HEH	 HEHM HM HM؞ H	 HEHT$pHtLEL+I;3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pHHZ H3HE AALL   L   H   L  H  HEI荈   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pHHL$t!WE3H}Ht$8Ll$0D$(t$ LL$pMIHMX WD$XH|$hHE   H}@} DGH0/	 HM GHE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
)	 c HQM+IIHL+IHM;HCH;HCHL$XPHL$`Ht,HA   HyHyrHHHU   菽HL$`H HL$`HEHrPHHM H=   r<te HAH;rU H+HsE H'v8 HW AEHT$XI.IHT$XIP H}H]H+HWD$xHt3 HfHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMv  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMNw  HL$x HL$XHt2HT$`@  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I3HM H3 H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHU H3HE AALL   L   H   L  H  HEI]   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pޢHHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHMzS WD$XH|$hHE   H}@} DGH*	 HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
	 3 HQM+IIHL+IHM;HCH;HCHL$X HL$`Ht,HA   HyHyrHHHU   _HL$`H HL$`HEHrPHHM H=   r<t5 HAH;r% H+Hs H'v H' AEHT$XIc)IHT$XIP H}H]H+HWD$xHt3ؕ HaHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMiq  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMg  HL$x HL$XHt2HT$`];  LD$hHT$XL+IǢWD$XHD$h    HUHtLEL+I3HM H3 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH@  Hǀ`HXHp )pHO H3H$   MMH$`  HHl!
 HHH^!
 H;O!
 r   HHA!
 H$8  Ht
;
 HE3H!
 E3AHHH!
 H; 
 r
   1HH$8  WHt
(HIW$H  L$X  L$   L$   L$   L$   L$(  HT$`H$      HD$`H$(  L$0  HT$`H$     HD$`H$0  W$   L$   HcFxHD$pIHt'I;v
H
	  HH$   ~tHD$pMfD  H$   L;  HT$`u  HD$`H$   L$   H;   HD$`L;   L|$`M+IL$   I;uxIH+HHshI+HIH+Hs
H
	  HQM+IIHIH+IMI;LCL;ICH$   sH$   L$   H   K   L$   I;upIH+HHs`I+HIH+Hs
H
?	 y HQM+IIHIH+IMI;LCL;ICH$   sH$   HtHD$`HH$   HH$   IHD$pkL$@  HT$h  HHD$`H:
 LH(H,
 H;
 r(   YLHL$`L$8  Mt*L)AMXOIIMo H	 IML$8  HT$`HL$p(HHL$`HD$`H$@  WD$xL$   Lcn,MtM;v
H
	 ' IHL$xqM    M;  HT$`H$     HD$`H$   H;   HD$`LD$xL;   H|$`I+HL$   I;urIH+HHsbI+HIH+Hs
H
I	  HQM+IIHIH+IMI;LCL;ICHL$xqH$   LD$xHt7I&H;$   uHL$xbpH$   HtHD$`HH$   HH$   I
 |   H~(DH-	 H
	 HcH$   UIL$   IH$   H+HHt0ff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r[
 }   DHm	 H
j	 HcH$  ]TIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;r
 ~   DF,Hd	 L%	 I	HcV,H$   SIL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r
    DF,H	 H
]	 LHcV,H$   RIL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu
    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$    HH$   T       
    HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$   n HH$   ͼ H$   HtL$   L+IH$      L=	 H	 ;~,   
    HcL   L+   IHT$(D$    DSL   L$   L+D$xIL|$(D$    D&HD$xL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID 
    L   L+   IH
	 HL$(D$    DL   L$   L+D$xIH
	 HL$(D$    DcHD$xL$L$   L+$   IH
+	 HL$(D$    D*L$   ATIT$HL$`H IDH$   L%	 P<       5.
 L-	 I*;~(      HcH   H+   IHHLI?LLl$(D$    DyH[H   L$H   H+IHHLI?LLl$(D$    D7H[H   L,L$   L+$   IH
	 HL$(D$    DH$   HHHD$`L$  L+$  IH
@	 HL$(D$    DL$  L$   IT$HL$ht LL$   IUHL$p[ L(H$  LHT$`H$  MHH$    H IDH$   RAH$   ;^(   HcH<    H$  uH	 H$   U[HkH  ]HVH$   H$  AsHHxrHHU H$h  3H$p  H$x  H$   Ƅ$   H$p  H$    H	 H$h  H H$h  p AH$      ;^(   HcH<    H$  tH	 H$   W[HmH ]HXH$   H$  CrHHxrHHW H$  3H$  H$  H$   Ƅ$   H$  H$    H	 H$  H H$  r AH$   ;^,   HcH<    H$  %sHE	 H$   `[HvH ]HaH$   H$  LqHHxrHH` H$  3H$  H$  H$   Ƅ$   H$  H$    H	 H$  H H$  { A;^,   HcH<    H$  6rH~	 H$   q[HH ]HrH$   H$  ]pHHxrHHq H$  3H$  H$  H$   Ƅ$   H$  H$    Hʂ	 H$  H H$  茦     D$p   Dt$`LL$pLD$`H$(  HL$h; HT$hH$H  i: W    D$`   Dt$pLL$`LD$pH$0  HL$h HT$hH$H  $:     Dt$`L   LD$`H$   HL$h HT$hH$H  9     '
 D$hDt$`LL$hLD$`H$@  HL$p| HT$pH$H  9     Dt$`L   LD$`HT$xHL$h HT$hH$H  ^9 L    HV`L$@  L$  HL$h HT$hH$H  $9 H$   Ht(L$   L+IW$   L$   H$   Ht(L$  L+I͑W$   L$  H$  Ht(L$   L+I蘑W$  L$   H$   Ht(L$   L+IcW$   L$   HT$xHt%L$   L+I1WD$xL$   H$   HtL$   L+IH$8  H$H  7 H$H  H$`  HH$H  HtL$X  L+I诐HH$   H3謐 L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWH@  Hǀ`HXHp )pH; H3H$   IMH$`  HH,

 HHH

 H;

 r   KHH

 H$@  Ht
&
 HE3H
 E3AHHH
 H;
 r
   HH$@  WHt
(IH$@  W$H  L$X  L$   H$   L$   L$   L$(  HT$`H$   ۞  HD$`H$(  L$0  HT$`H$   贞  HD$`H$0  W$   L$   LcoxIMt"M;v
H
D	 ~{ IH$   >`MH$   M;  HT$`@  HD$`H$   L$   H;   HD$`L;   Ht$`I+HL$   I;x   IH+HHshI+HIH+Hs
H
	 z HQM+IIHIH+IMI;LCL;ICH$   o_H$   L$   H   I   L$   I;upIH+HHs`I+HIH+Hs
H
	 @z HQM+IIHIH+IMI;LCL;ICH$   ^H$   HtHD$`HH$   HH$   IlL$8  HT$h赜  HH$   %(HHL$`HD$`H$8  WD$pL$   Lcg,MtM;v
H
2	 ly IHL$p/^MM;   HT$`H$   1  HD$`HL$xH;sDHT$`HD$pH;w5Ht$`H+HH;$   uHL$pC]HL$xHD$pHt1H#H;$   uHL$p]HL$xHt
HD$`HHL$xHHL$xIV |   Hw(DH	 H
O	 NHcH$   AIL$   IH$   H+HHt1fff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r }   DH-	 H
*	 HcH$  AIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;r[ ~   DG,H$	 L%ձ	 IHcW,H$   X@IL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r    DG,Hd	 H
	 HcW,H$   ?IL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu    HGxH   H   LG0Ht$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$   赟 HH$          S    HGxH   H   LGHLO0Ht$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$   . HH$   荩 H$   HtL$   L+IˇH$      L=׭	 Hĭ	 ;w,      HcL   L+   IHT$(D$    DL   LD$xL+D$pIL|$(D$    DHD$pL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID    L   L+   IH
߬	 HL$(D$    DZL   LD$xL+D$pIH
	 HL$(D$    D)HD$pL$L$   L+$   IH
	 HL$(D$    DL$   ATIT$HL$`H IDH$   L%	 V       5
 L-	 I*;w(      HcH   H+   IHHLI?LLl$(D$    D?H[H   L$H   H+IHHLI?LLl$(D$    DH[H   L,L$   L+$   IH
	 HL$(D$    DH$   HHHD$`L$  L+$  IH
	 HL$(D$    DyL$  L$   IT$HL$h: LL$   IUH$    L(H$  kLHT$`H$  VMHH$   H IDH$   OAH$   ;_(   HcH<    H$  aH	 H$   [H-Hq ]HH$   H$  `HHxrHH| H$h  3H$p  H$x  H$   Ƅ$   H$p  H$   Or Hpr	 H$h  H H$h  2 AH$  ;_(   HcH<    H$  `Hݰ	 H$    [H6Hp ]H!H$   H$  _HHxrHH { H$  3H$  H$  H$   Ƅ$   H$  H$   Xq Hyq	 H$  H H$  ; AH$   f;_,   HcH<    H$  _H	 H$   '[H=Ho ]H(H$   H$  ^HHxrHH'z H$  3H$  H$  H$   Ƅ$   H$  H$   _p Hp	 H$  H H$  B Aސ;_,   HcH<    H$  ^HD	 H$   7[HMHn ]H8H$   H$  #]HHxrHH7y H$  3H$  H$  H$   Ƅ$   H$  H$   oo Ho	 H$  H H$  R b    Ǆ$      Dt$`L$   LD$`H$(  HL$h HT$hH$H  )'     D$`   D$   LL$`L$   H$0  HL$h谯 HT$hH$H  &     Dt$`L   LD$`H$   HL$h HT$hH$H  &     
 D$hDt$`LL$hLD$`H$8  H$   3 H$   H$H  N& <    Dt$`L   LD$`HT$pHL$hD HT$hH$H  &      HW`L$8  L$  HL$h蚶 HT$hH$H  % H$   Ht(L$   L+I~W$   L$   H$   Ht(L$  L+I~W$   L$  H$  Ht(L$   L+IL~W$  L$   H$   Ht(L$   L+I~W$   L$   HT$pHt%L$   L+I}WD$pL$   H$   HtL$   L+I}H$@  H$H  $ H$H  H$`  HH$H  HtL$X  L+Ic}HH$   H3`} L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWHP  Hǀ(HXHp)p)xHS( H3H$   ML$   H$   HL$HH$  H$   L$  L$  L$  H$  H$   D$D    D$@P   EH: H
 IcHL$PF3LD$XIHT$PH+HH      Ht'L@ IHLD$XIHT$PH+HH;r3L+IMtfHHHD$XH+D$PHH;rD$@Q   DH  H
) HHcHL$hF3LD$pIHT$hH+HHt/L@      IHLD$pIHT$hH+HH;r3L+IMtfHHHD$pH+D$hHH;r   =
 H
 A;?   D$@T   HcMFM+IHL$(D$    DI6MD$M+$IH
k HL$(D$    DrI$tYtWLD$XL+D$PIH
 HL$(D$    D5HD$PtJ   L'	 H*H$   ;0M  D$@W   HcMu IMI+HHHHHH?H  G;  H<[ID$I+$HMLM+LIHD$0LD$(L	 H
	 TILMDL+II$(H$   L8HxI+HD  G;9  Mu IMI+H*HHHHH?H  G;  H<[HD$XH+D$PHMLM+LIHD$0H	 HD$(L؎	 H
Վ	 HSILMDL+IHT$PH$   X0AYtH$   X XH|$pHL$hH+H|G;}
t2Hm	 H$   Hjj	 H$   H$H  4g D$D   E3H$   H$   f H$   HcHHg	 H   H$   HcHh   H$   HD$HH$   Bd Hb	 H$   3H$0  $8  H	 H$      He H$  H$   SL$  H$  LC$  H HD$ DËYHl	 H$  HBi	 H$  H$H  f D$D   E3H$  H$  e H$  HcHHf	 H  H$  HcHh  H$  HD$HH$  c Ha	 H$  3H$0  $8  Hڋ	 H$  Ż   Hwd H$  H$  RL$  H$  LC$  H HD$ DË1Hk	 H$  Hh	 H$  H$H  d D$D   E3H$  H$  d H$  HcHH~e	 H  H$  HcHh  H$  HD$HH$  a H`	 H$  3H$0  $8  H	 H$  蝺   HOc H$  H$  QL$  H$  LC$  HD HD$ DË	Hqj	 H$  Hf	 H$  H$H  c D$D   E3H$  H$  zc H$  HcHHVd	 H  H$  HcHh  H$  HD$HH$  ` HZ_	 H$  3H$0  $8  H	 H$  u   H'b H$   H$  rPL$   H$  LC$   H HD$ DËD$@Z   HT$hH\$HHF HL$hH   HD$xH+HHH;vd H    H=   r<td HAH;rc H+Hsc H'vc Hz WD$h3HD$xHT$PHtLD$`L+IIsHH$   H3Fs L$P  I[8Is@A(sA({IA_A^A]A\_HLH L@HPHHSVWATAUAVAWH  HD$x)p)xD)@D)HMILD$p    Ǆ$  9   H$p  DH H
 HcHL$@<3LD$HIHT$@H+HH      Ht#LIHLD$HIHT$@H+HH;r3L+IMtfHHHD$HH+D$@HH;rǄ$  :   L$x  E$H H
 \Ic$HL$X<3LD$`IHT$XH+HHt#LIHLD$`IHT$XH+HH;r3L+IMtHHHD$`H+D$XHH;rǄ$  <   H|$(H$h  HD$ MLIH$   裚 HHHH+HLL$HL+L$@IHL$0Hs	 HD$(Lw	 H
	 #K3HD$HHT$@H+HHt)L     IHHHD$HH+D$@HH;rH$   HtL$   L+Ip   H$`  D
+
 DJ
 L7 H*A;<$+  Ǆ$  >   HcHNH+HHHH?HLD$(D$    DDL4[L>IEI+E HOLO+LIHD$0H	 HD$(L	 H
	 JKLODL+IIU (L$P  MFM+IH
 HL$(D$    D(M.HNH+H*HHLI?LH HD$(D$    DL4[L>HD$HH+D$@HOLO+LIHD$0HȄ	 HD$(L	 H
	 0IKLODL+IHT$@H$@  X At\L$8  AX?YAWL$X  MFM+IH
C HL$(D$    D*( IAXt^LD$`L+D$XIH
 HL$(D$    DHD$XtL$H  Ǆ$  A   HT$XL$0  I\ HL$XHHt{HD$hH+HH;v8^ H    H=   r<t^ HAH;r^ H+Hs] H'v] Hu WD$XHD$h    HL$@HtiHD$PH+HH;v] H    H=   r<t] HAH;r] H+Hsw] H'vj] Ht IL$  A(sA({E(CE(KIA_A^A]A\_^[H\$WH0LIHL+	H*ILD$(DHHHD$    H?HD&HH[H\$@HHH0_Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hr H3HsHsHH;uHl$0Ht$8H\$@H _[ [ ~[ w[ p[ DL$ LD$HT$HL$SVWH0HD$(HH9z ucH ǭ HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH 臭 HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHp H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _Y Y {Y tY H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   H"p H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weHo HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _OX HX AX :X 3X ,X %X X H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHn H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _yW rW kW dW HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHH>0HHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hm H3HsHsHH;uHl$0Ht$8H\$@H _<V 5V .V 'V  V HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     HV	 HD$`HMS D$    E3E3HT$hHL$`S HD$`HcHHC	 HD`HD$`HcHDxDD\   HL$hg~HHL$`ɩHH?w	 躩HH诩HHU}	 蠩HI蕩HA/R HH|HUPHL$`BHxrH H
\ HL$(3HL$0HL$8HD$@D$HHT$0HL$@R HZ	 HD$(H HL$(v @SUVWAVH`  HD$8HJ H3H$P  IIHLD$0    HU	 HD$@H$   YR D$0   E3E3HT$HHL$@"R HD$@HcHH1B	 HD@HD$@HcHDxDD<   HL$H|HHL$@RHH4	 CHHUP HH4	 'H$0  HL$@uAHHcD$0H$0  H$H  HC$0  H	 HD$ L
	 LD$0I9@UVWAVAWH`  HD$8H$  H
 H3H$P  MIHLH$  D$0    H+T	 HD$@H$   P D$0   E3E3HT$HHL$@P HD$@HcHH@	 HD@HD$@HcHDxDD<   HL$H{HHL$@HHӋ	 HIVO HHӉ	 ƦH$0  HL$@@HIcD$0H$0  H$H  HC$0  Hl$ L
D	 LD$0IH\$Ht$WH IHHH;t HHe)HHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(HIf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IHHA(IWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   HX(H
/r	 HH0@8   HH$   ԍ HHL$(H HL$(Y H\$WH HHHÀ< uHú   H6 HHu3 Ht!HH+fff     9HHuHH\$0H _@SH HO  H;2	 HCPH [HL$SH0HD$ HD$P    EtH!	 HA@H1	 HAPD$P   J   HC&	 HH,	 HCHC@HcHH.	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH= HHQ3HHBHK4 H2	 HH{3HHDH^H\$HH=9	 HHOHKHtHPHGHCHGHCG C Hr 	 HH= HHH\$PHt$XH0_@SH HL  H0	 HCPH [HL$SH0HD$ HD$P    EtH~ 	 HA@H0	 HAPD$P   z  Hs)	 HH#	 HC(HC@HcHHV#	 HD@HC@HcHD<    HH0[@SH HBJ  H0	 HCPH [HL$SH0HD$ HD$P    EtH	 HA@H/	 HAPD$P     H;U	 HH0	 HC(HC@HcHH(	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH H+	 HHH#	 HAPHI8`2 HK V2 HKL2 Hu*	 HH [@SH HKT	 HHH"	 HAPHI82 HK 2 HK1 H%*	 HH [H\$WH HK  He.	 HGPt
X   HI HH\$0H _H\$WH H,J  H%.	 HGPt
X   HI HH\$0H _H\$WH HH5	 HHHJHKHtHPHGHS0HCHO0HGHCG C H9 HC(3HHB[0 HL3	 HHj4	 HC(HH\$0H _H\$WH H|G  HU-	 HGPt
X   HH HH\$0H _H\$WH HH$5	 HHHJHKHtHPHGHS0HCHO0HGHCG C H&9 HC(3HHB/ H\ 	 HH.	 HC(HH\$0H _@SH HH   / H   HKX/ HKH/ HK8/ HK(/ HK/ HKH [H%/ H\$WH HQ@3HHtLAPL+I?H{@H{HH{PHS(HtLC8L+I?H{(H{0H{8HSHtLCL+I.H{H{H{H\$0H _H\$WH HH   w  L   HgfffffffL+   IHLI?LH   貾  H   HOX. HOH. HO8. HO(. HO|. HOH\$0H _H%g. HUHl$H  HD$8HXHxH  H3HEpIID$0    3A A	    f/rHHr   H3	 HD$PH90	 HD$`HM
- D$0   E3HT$hHL$P, HD$PHcHH-	 HDPHD$PHcHhTLHD$hHD$@HL$h0* H(	 HD$hHE    E    Hh	 HL$`HL$`|+ HUPHL$PHEPH}hHCEPHD$ L
sh	 LH!h	 H
2h	 HMpH3= L$  I[I{I]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEH
k	 H  IHHL@H
(	 H;u.HSHKHH  مHHa* H  HAАH  HrSHH  H=   r<t, HAH;r, H+Hs, H'vz, HC HWHL$x9@  MEHT$xH[  (Hǅ     L  ƅ   A   Hj	 H  9GIH  IPH  HrSHH  H=   r<t+ HAH;r+ H+Hs+ H'v+ HB H   Hi	 H   7H(( H  H   8ILAHIAАH  HrTHH  H=   r<t$+ HAH;r+ H+Hs+ H'v* HB HH  HH  ( H\$0Lt$(x  D$ p  (HT$xHJ  H_HD$xH  HuHCH;t'H;tH) Ht
HhHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  Q HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
a	 3& W  L  D$@Ll$PH6.	 HEH*	 HEHMH' D$\   E3HUHMS' HEHcHH3(	 HD
HEHcHhT
HEH  HM$ HG#	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMrHXH  Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
X`	 $ IPL+IIHL+IIM;HCH;HCHL$@_LD$HMtM(LD$HILD$HIPHL$@H;t
I;tlB IHT$@IPHǅ     L  ƅ   E3HI	 H  BIH  IP H  H  He	 H  |HȋW$$ HH[e	 {IH  IPAD9o$Y  f     LGHWHL$x^m EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  
D$0D$(HD$@HD$ LD$`HH  H  EHXH  uHtIH  IPLD$HL;D$Pu   HL$@7LD$HMtM(LD$HILD$HIPHL$@H;t
I;t@ IHT$@IPHH  HH  # ;w$}H
]	 y" Hǅ     L  ƅ   A
   Hd	 H  @IH  IP H  HH  cHH  f# HMHLHMHR# HT$@HtLD$PL+I4WD$@Ll$PH  HtL  L+I#HT$`HtLD$pL+I}4HM# HL$x# 3H  H3f4 H$`  ($   H  A_A^A]A\_^]H8D$`AD$hAD$pLALA$A D$xA HLIy ~y ~By  ~g    HH8H^	 LAHD$ H
b	 L
^	 Hb	 H^	 LAHD$ H
tb	 L
m^	 Hb	 yHy^	 LA HD$ H
Ib	 L
B^	 Hb	 NHN^	 L
'^	 HD$ Hb	 H
b	 'HUVWATAUAVAWHH  HEHX)pHe H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEH`	 H  >HL@H
	 H;u.HSHK{HH  {HH}1  H  HAАH  HrSHH  H=   r<tw" HAH;rg" H+HsW" H'vJ" Hi9 HWHL$xK@  MEHT$xH^n  (Hǅ     L  ƅ   A   H_	 H  	=IH  IPH  HrSHH  H=   r<t! HAH;r! H+Hs! H'vx! H8 H   H{_	 H   vH( H  H   
ILAHIAАH  HrTHH  H=   r<t  HAH;r  H+Hs  H'v  H7 HH  HH   H\$0Lt$(x  D$ p  (HT$xH@]  H_HD$xH  HuHCH;t'H;tHm Ht
H8HL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  ! HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
QW	  W  L  D$@Ll$PH$	 HEH 	 HEHMH] D$\   E3HUHM# HEHcHH	 HD
HEHcHhT
HEH  HM H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMB
HXH  rHt
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
(V	 b IPL+IIHL+IIM;HCH;HCHL$@ULD$HMtM(LD$HILD$HIPHL$@H;t
I;t<8 IHT$@IPHǅ     L  ƅ   E3H?	 H  8IH  IP H  QH  
Hu[	 H  qHȋW$ HH+[	 qIH  IPAD9o$Y  f     LGHWHL$xc EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  	D$0D$(HD$@HD$ LD$`HH  H  HXH  EHtIH  IPLD$HL;D$Pu   HL$@-LD$HMtM(LD$HILD$HIPHL$@H;t
I;tr6 IHT$@IPHH  HH   ;w$}H
S	 I Hǅ     L  ƅ   A
   HY	 H  ~6IH  IP H  PHH  3HH  6 HMHHMH" HT$@HtLD$PL+I*WD$@Ll$PH  HtL  L+IHT$`HtLD$pL+IM*HM HL$x 3H  H36* H$`  ($   H  A_A^A]A\_^]@SH A(HA sp CH [Ht$WH0HD$     H      t@W H   HVxH\$@       ^FxH\$@,;L   HHt$HH0_@SH H	 HH   H:	 HH8		 HAPHI8 HK  HK~ H	 HH [Wf/v%      ^Ix,;L   H\$WH HHH   HqH   HbH   HH\$0H _I@UHHPHEH\$`Ht$pH|$xH H3HEHHE   3Hu@uDF
HW	 HM3HKHEH;sTHHUH;wHH}H+H;KuVHg(HH;HKHtcHA   HqHyrHHH;H;Ku
   H$(HKHt'HA   HqHyrHHHU  8HC HEHrPHHMH=   r<t HAH;r H+Hs H'vv H. HE   HuE A
   HV	 HMo2HCHMH;sVHHUH;wJH}H+H;Cu
   H;'HH;HKHtcHA   HqHyrHHH;H;Cu
   H&HKHt'HA   HqHyrHHHU  7HC HMHE   HuE A   HU	 HM1HUHHMmHMH3& H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3uq  HSHq  H_HGPLG`HHOPP8MHHOPo  HHMAHCHEEWH9puA(H HD$8HEHEHL$0~ (Y5K	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0	 Yٸ	 XC(EoHHEoH#H      H;v?	 \(j (5 	 f/vIHOhm  f/v:HEH;t1HKHUuEC(HKHUuHK0HUt]HCHEHx tH HD$8HEHEHL$0< D(DY	 DXC(D   0Ht	 I$I\$H]oHOHHHGHCHWHGLL+ti W=	 A|$At$ HM HM HM IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA si CH [H\$WH0HD$     H      tS HWxH   %HH\$@H0_@SH H	 HH   H"	 HHh	 HAPHI8 HK  HK H		 HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=)	 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@lf HL$0) ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@f HL$0= L$   HHH$   ($   HĠ   _i  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Hu HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     OHHK8HOHS0LC8IL+LtHDe HH\$@H0_H\$WH0IH IHD$     HHK HOHSLC IL+LtHd HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3
 HgHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$Pb2 HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P (Y%m	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$    (X\(HĐ   [B(HhHBHD$(Hx uWYٰ	 HhH HL$8HD$@HD$ HD$P Y	 HhWf/v'	 f/v   Wf/vIxHAHH H\$WH HHki  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs܇ Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$X訇 f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HRHSHt
HHH
HJ$H;Cu
   H&HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HWHSHt
HHH
HB&H;Cu
   H+HKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xH! H3HEHHE   3Hu@uDF
H2H	 HM	$HCHMH;sTHHUH;wHH}H+H;CuVHHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  4)HC HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   HuE A   H8G	 HM"HCHMH;sVHHUH;wJH}H+H;Cu
   HHH;HKHtcHA   HqHyrHHH;H;Cu
   HhHKHt'HA   HqHyrHHHU  (HC HMHE   HuE A   HmF	 HM"HUH'HMHE   HuE A   H@F	 HM!HUHHMHE   HuE A   HE	 HM!HUHHMcHMH3 H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    ka  HSHa  H~HFPLF`HHNPP8MHHNP_  HHMHUH   
HUHM0HUH   HFPLHUHNPP(HM!HE HMHM(HULL+tH[ HMHEHMHMHULL+t	HZ HN(HD$xH^(H]HV LL+tHZ H]EWA(HGH  Hx uE(H HEH   HEHM D(DV	 EYDXO(D$`    DEǆ       Ɔ          Dn	 D%	 D-	 @      WD$hHt3 HHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM' D]HNhr\  fA/  HEH;  LcuIL;wt%HO+ EtHHGHG    H_E~LEN    HUHOX EG(Lcu IL;w t%HO EtHHGHG    H_ E~LE N    HUHOX LcuIL;w8t%HO0y EtHDHG0HG0    H_8E~LEN    HUHO00X Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      H_  HEH;  HWHMLbG(EHWHM5bHM   H   H;t=HOH   b   G(HOH   aHO0H   aLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      H_  H   H;t=HWH   iaG(   HWH   LaH   HW0<a     uf/w(\V (HNhY  f/v=H   HM8`   EXH   HMH`H   HM``f/v\(rX(\(r(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM] HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  z fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  z fA/v"HL$h    9   }H]HL$h D$`   fnu^HE0H;t1HOHU8^EXG(HOHUH^HO0HU`^HY     V0Wk	 HV(IHL$x HM
 HM  HM H    H    H    HM` HMH HM8 H    H    H    HM} HMs HMi IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5	 EW=	 E   I$HEI|$HFH;t'H;tHW Ht
H"HL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
*	 ff     HE(WA)HH;}LEMHL$`D& H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMw    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMv EHSxHExHD$(H  HD$ L   L   HMB YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(HD t0Eu"A   EEH9	 H   vA  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HMc HtH.HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHbHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I?  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Ae  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`I Y   SxE3[e  H   HCxMHH`  Kp\KhT
	    f/vA      8  f/vA   y  f/vA
   cH  H9   rA(   KH_  (  5Ę	 Yf/vA   !H_  @  Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   H IcH  $  HA   H75	 vAO   HH5	 gAO   H5	 XA6   H5	 IAD   H5	 :AC   H<6	 +A9   Hu6	 AQ   H6	 
A   H6	 HC   HLKDHH0[  |         HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H[	 H   EotEH   0LcHsHH{Lsp5p	 EW=l	 E   I$HEI|$HFH;t'H;tH Ht
H袾HL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$` H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMn    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMBn EHSxHExHD$(H   HD$ L   L   HM: YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H; t0Eu"A   EEH"1	 H   A  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtH讻HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$`K M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I迆  (HEHEL9}t HEHD$hHEHD$xHL$`B D(A(WfQH   LEHUHE   A<b  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`@ Y   SxE3a  H   HCxMHHb`  Kp\KhT
q	    f/vA        f/vA   y   f/vA
   cH   H9   rA(   KH_    5D	 Yf/vA   !HB_     Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]HHHWATAUAVAWHPH@HXHhHp LLE3D`LBL+H*HIHHH?H衷D$    AINI+HHHHH?H!  AI     IHHL$0p  HIHH;tDHHtLCL+I
L#LcLcHHHGHCHGHCL'LgLgHL$0HtJHD$@H+HI;   H    H=   r uhHAH;sXH+HrHH'w;H
 HHINI+H*HHHH?HH;s(     IL\$PI[8Ik@IsHIA_A^A]A\_LSH   ICHAC    H ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$XF H	 HD$(H; HD$PHD$hHcHH> HDhHD$hHcHDd    He HL$( @SH0HD$ HٹX   l HD$@HSH#b  HHtH@@HcHHB@HH0[@SH0HD$ HH?	 HH HA(HA@HcPH HD
@HA@HcPDBDD
<H% HH HA(H0 Hv HHKHtHP tHC    H0[LSH   ICHAC    H ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$Xf H HD$(H HD$PHD$hHcHH~ HDhHD$hHcHDd    Ha HL$( @SH0HD$ HٹX    HD$@HSH`  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HA(HA@HcPH HD
@HA@HcPDBDD
<He HH HA(H0 H HHKHtHP tHC    H0[LH   ICAC    HQH# ICH0 ICAC   IK{Ht HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H` HL$(	 @SH0HD$ HٹX    HD$@HSH`  HHtH@@HcHHB@HH0[@SH0HD$ HH HH] HAHA@HcPHZ HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     H5 HHKH0[H%
 @SHpH H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8e_ @-H$   u	HHHtHL$`H3+ Hp[2HL$`H3 Hp[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PH3 HA@H@ HAPD$P   H7 HHOH	 HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_H9q H\$WH Hg HH   H	 HH HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH H	 HHH HAPHI8j HO ` HOV H Ht
   HJ HH\$0H _H\$WH H HH   HL HH HAPHI8 HO  HO H Ht
  H HH\$0H _H\$WH H HHH  HAPHI8z HO p HOf H Ht
   HZ HH\$0H _H\$Ht$WH0H3HRH\$ H+HHHGH+HHtHHHHHGH+HH;rH\$@HHt$HH0_LHXICLL	IAI+HHIH;rQHx IC3ICICH	 ICD$0ISIK H HD$8Ha"	 HL$8跨HAI@IHH
HHXHUSVWATAUAVAWHH  HE@)p)xD)@D)xD)hD)XD)HD)8D)(D)H H3H`  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,H	 HD$ L
	 LD$@H!	 H
!	 GfE/w,H	 HD$ L
	 LD$HH!	 H
q!	 ̋  .Hz	 HD$ L
N	 L  H!	 H
9!	 LHHPHMIHPHME(D=ą	 L	 T$@fn=	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGH HE3HEHE H'	 HEEHUHMg H HEHMJ HuIHHD$XHHL$`HD$pHD$hHǅ(     L   ƅ   A!   H 	 H  HH  HP H(  HrSHH  H=   r<tB HAH;r2 H+Hs" H'v H4 Hǅ(     L   ƅ   AC   H 	 H  HH  HP H(  HrSHH  H=   r<t HAH;r H+Hs~ H'vq H  EAA   D5	 D-4	 @      G D$ L
j#	 DEH#	 H
0#	 +:IGHHHL$ L
w#	 DG H4#	 H
#	 IHt$0IGHD$(AGD$ MOMHUH+ HMAu3H8  HHMHH   H8     H8  HD$@HUHeL(HMHHMJH8  HMH@  HULL+t	H?1 HMHH  HMHP  HULL+tH1 E؉X  L8  
:	 HMpLHH  ?HHMBH    H   HM( HM fEnEA(0 ^H8  HD$@HUpHM"L
~	 H  HHM/H8  HMH@  HULL+t	H$0 HMHH  HMHP  HULL+tH/ EX  L8  (HMHLHHM,HHHM( HM H    H   AƙA ;  A(LHI>Z  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(uHtX9HI;IDH;tHuWI*MyX~	 ^HT$XV  D(H H   H H   H8  f L$PE3H   H   ) H   HcHH H
   H   HcHh
   H   HD$HH   } H
 H   3H   (  PH   HHy H   ,HHu3
H HcHHHW   H   HAH HH& +HHu3
H HcHHHW   H  G HHH$ HHu3
H HcHHHW   H   HA(H HH ?+HHu3
H HcHHHW   H   HHwH HHu3
H HcHHHW   H   H(Hi HH *HHu3
H HcHHHW   H   , HHH	 HHu3
H HcHHHWA(H * +Efn^5{	 t$H3H  H   H  WH  H  HtD	H  HH  HT$HH  H;sLHT$HH;wBH\$HH+HH;   u   H  H  H  HtHHH1H;   u   H  iH  H  Ht1H  H  HH  HT$@H;sLHT$@H;wBH\$@H+HH;   u   H  H  H  Ht;HH+H;   u   H  H  HtDH  HH  IE L@H
 H  H;Iu/AfD/vH8	 H   d(E2fE/vH3	 H   G(E2AG D;~!fE/wfA/vH!	 H   (HH   HPE   A(A\A^ATf/v	    HǅP     HH  D8  Aa   H	 H8  HH8  HP H8  HǅP     HH  D8  AH   H	 H8  HH8  HP H8  蜱H  Ht%L   L+IW  H   H8  NH8  Q =u	 H}D;     HǅP     3HH  8  DCiH	 H8  HH8  HP H8  HǅP     HH  8  DCBH	 H8  HH8  HP H8  蜰E2AEu8LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtHM; HM1 HM& HM H`  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH`  Hǀ)p)xHy H3H$0  ILL$hEHHT$pLH$   H$   DD$XL$   E3ADt$HE,H
	 HD$ L
	 LD$XH	 H
U	 舼HǄ$     L$  @$  A   Hn	 H$  HH$  HP H$  HrTHH$  H=   r<tz HAH;rj H+HsZ H'vM Hl (z	 $  (
x	 $   ~r	 $  
Mv	 $   LHIO  $   I$HPH$    I$HPH$   9s	 $  
 s	 $  ?r	 $   WL$xD$@AΉL$D|$@ 
  Hc  $  $   A   D|$`E;  AAHǄ$     L$  Ƅ$   E3HB H$  'HǄ$     L$  Ƅ$   E3H H$  F    EHt$8H$  HD$0H$  HD$(E͋H$  HrTHH$  H=   r<ti HAH;rY H+HsI H'v< H[ HǄ$     L$  Ƅ$   H$  HrUHH$  H=   r<t HAH;r H+Hs H'v H HL$pY $   D$P;  ML$Iq\$P;u4Ht$hHt$0ID$HD$(AD$D$ M$H$   "   H H$P  H$   |$HE3E3H$X  H$P  S H$P  HcHH_ HP  H$P  HcHxL  H$X  HD$hH$X   H+ H$X  L$  Ǆ$     H	 H$P  D H	 H5 Hn	 H& HH H;	 H H$  H$P  VH$  H$  HC$  HD$ L
 LD$PHK	 H
	 'Ho H$P  H$  9 |$HE3E3H$X  H$P   H$P  HcHH	 HP  H$P  HcHxL  H$X  HD$hH$X  E H H$X  L$  Ǆ$     H?	 H$P  Ho	 HH	 HH H	 HH$  H$P  H$  H$  HC$  HD$ L
^ LD$PH	 H
	 B&E3$   D|$`L$   |$HH$   HD$pDl$XH$   Ht$hH$   Au:H$  JHH$   yH$  R H$  7  H$  HD$PH$H  L$   H$   *HH$   ړH$  H$   H$  H$   LL+t	H H$   蛓H$  H$   H$  H$   LL+tH $   $  L$  $  H$p  ~LHH$  HH$   H$  3 H$  % H$0   H$    fAn0 (^H$  HD$PH$p  H$   yL$  H$  pHH$   耒H$  H$   H$  H$   LL+t	Hk H$   AH$  H$   H$  H$   LL+tH, $   $  L$  (H$H  *LHH$   WHH\$pHH$0   H$    H$   H$   AǋL$D?LHIbG  7E3$   L$   |$HH$   H\$pDl$XH$   Ht$h$   f/
  f/$      H$  yHy	 H$  HHB	 HL$x> HH D|$DH$  AH7	 |HV aHH$  HPHǄ$     L$  Ƅ$   E3H H$  HH$  HP H$  ]D$@ H$8  ;H$8  =   D|$DA}$      f/$   :  H$  SHS	 H$  HH	 HL$x HHF	 aHH$  HPHǄ$     L$  Ƅ$   E3H H$  HH$  HP H$  ]D$@ H$8  ;H$8  = H$   $  D$xAD|$DIT$H$   HHkH$0   H$    AFL
o
	 HP
	 n  H$    H$    H$    H$    D$xH$0  H3 ($P  ($@  H`  A_A^A]A\_^[HUSVWATAUAVAWHxHH  HE()p)xD)@D)xD)hD)XD)HD)8D)(D)H} H3H  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,H HD$ L
 LD$@H	 H
	 wlfE/w,H HD$ L
 LD$HH	 H
	 Dl̋  .H HD$ L
~ L  H	 H
i	 |HHPHM+IHPHME(D=h	 |f	 T$@fn=>e	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGHJ HE 3HEHEH	 HEE HUHM H HE HM - HuIHHD$XHHL$`HD$pHD$hHǅH     L@  ƅ0   A!   H	 H0  HH0  HP HH  HrSHH0  H=   r<tr HAH;rb H+HsR H'vE Hd HǅH     L@  ƅ0   AC   HN	 H0  2HH0  HP HH  HrSHH0  H=   r<tο HAH;r H+Hs H'v H 2 EAA   D5n	 D-dc	 @      G(D$ L
	 DEH	 H
`	 [IGHHHL$ L
	 DG(Hd	 H
5	  -Ht$0IGHD$(AGD$ MOMHUHw HMAu3H`  衸HHMHp  ޽ H`    H`  HD$@H`  bL(HM0SHHMwH`  HMHh  HULL+t	Hl HMHMAHp  LELx  HMH  LHUNL+tH' E艅  L`  
Sb	 H  LHH0  HHMȻH@   H0  ռ HM@ʼ HM0 fEnEA( ^H`  HD$@H  HMUL
a	 H0  HHMBH`  HMHh  HULL+t	H7 HMHMHp  LELx  HMH  LHUNL+tH E  L`  (H`  LHHM0HH輼HM@ HM0 H@   H0   AƙA   A(LHIA  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(u)Ht$fff     X9HI;IDH;tHuWI*MyXa	 ^HT$X9  D(H	 HE`H HEpH   ] L$PE3HUxHM`& HE`HcHH HD
`HE`HcHhT
\HExHD$HHMx H HEx3H      PH   HH HMp.HHu3
H HcHHHW   H   HAH HH; HHu3
H HcHHHW   H  \ HHH9 HHu3
H HcHHHW   H  + HA(H HH THHu3
H HcHHHW   H   ε HHH HHu3
H HcHHHW   H   H(H~ HH  
HHu3
H HcHHHW   H   A HHH HHu3
H HcHHHWA(H ? +Efn^5^	 t$H3H0  H@  H8  WH0  H8  HtD	H8  HH8  HT$HH0  H;sLHT$HH;wBH\$HH+HH;@  u   H0  H8  H0  HtHHH1H;@  u   H0  ~H8  H0  Ht1H8  H0  HH8  HT$@H;sLHT$@H;wBH\$@H+HH;@  u   H0  H8  H0  Ht;HH+H;@  u   H0  H8  HtDH8  HH8  IE L@H
 H0  H;IuAfD/vHM HMp|E2fE/vHK HMpbE2AG D;~fE/wfA/vH< HMp3HHU`HPE   A(A\A^ATf/Y	    Hǅx     Hp  D`  Aa   H H`  ;HH`  HP H`  
Hǅx     Hp  D`  AH   H' H`  HH`  HP H`  轔H0  Ht%L@  L+I-W0  H@  H   oH   r =X	 H}D;     Hǅx     3Hp  `  DCiH H`  8HH`  HP H`  
Hǅx     Hp  `  DCBH H`  HH`  HP H`  轓E2AEu)LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtHM\ HMR HMG HM= H  H3 L$H  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH  Hǀ)p)xHn H3H$`  MLL$`EHHT$pLH$   H$   DD$XL$   3t$HE,H HD$ L
 LD$XH H
x 諟HǄ$     H$   @$  A   H H$  IH$  IP H$  HrTHH$  H=   r<t HAH;r H+Hs} H'vp H (]	 $   (
[	 $0  U	 $@  
pY	 $   MHI7  $   IHPH$   TIHPH$   ?^V	 $   
%V	 $   dU	 $   WL$xD$@ΉL$D    |$@ R
  Hc   $   $   A   Dd$hE;D  AAHǄ$     H$  Ƅ$   E3Hb H$  GHǄ$     H$   Ƅ$   E3H. H$  F    ELt$8H$  HD$0H$  HD$(E͋.H$  HrTHH$  H=   r<t HAH;ry H+Hsi H'v\ H{ HǄ$     H$   Ƅ$   H$  HrUHH$  H=   r<t HAH;r H+Hs H'vޯ H HL$pY($(  D$P;  MOMq\$PA;u1Lt$`Lt$0IGHD$(AGD$ MH$      H H$`  H$   |$HE3E3H$h  H$`  v H$`  HcHH H`  H$`  HcHx\  H$h  HD$`H$h   HN H$h  H$  Ǆ$     H H$`  gH  HXH HIIH H^ H.H$  H$`  yH$  H$  HC$  HD$ L
 LD$PHn H
? 
H H$`  H$  \ |$HE3E3H$h  H$`    H$`  HcHH, H`  H$`  HcHx\  H$h  HD$`H$h  h H H$h  H$  Ǆ$     Hb H$`  H HH; HH H	 HH$  H$`  $H$  H$  HC$  HD$ L
 LD$PH9 H
 e	3$   Dd$hL$   |$HH$   HD$pDl$XL$   Lt$`H$   Au:H$  >HH$   }H$  v H$  T  H$  HD$PH$X  L$   H$0  ޶HH$   vH$  H$   H$  H$   LL+t	H H$   H$   vH$  L$   L$  H$   H$  LH$   NL+tH $   $  L$  $   H$  LHH$  "HH$   !H$   : H$  , H$@   H$0   fAn7 (^H$  H$   警L$   H$  HH$   H$X  ܳL(H$  ILHH$0  vHH\$pHuH$@  n H$0  ` H$  Q H$  C AċL$DMHIq/  63$   L$   |$HH$   H\$pDl$XL$   Lt$`$   f/
  f/$      H$  	H	 H$  DHH 5HL$xΦ HH$ Dd$DH$  AH |H IH$  IPHǄ$     H$  Ƅ$   E3H8 H$  IH$  IP H$  D$@ H$X  ˔H$X  ͦ   Dd$DA}$      f/$   9  H$  H H$  HH HL$x HH IH$  IPHǄ$     H$  Ƅ$   E3H8 H$  IH$  IP H$  D$@ H$X  ˓H$X  ͥ H$   蠟$   D$xADd$DIWH$0  蘚HHlH$@   H$0  w AL
  H tR  H$   M H$   ? H$  0 H$   " D$xH$`  H3褶 ($  ($p  HĐ  A_A^A]A\_^[H\$
;K	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI;  C(WT	 C(H$   H$   H0HHD$XHHCH;t/H;t"H Ht
HTpH3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
KT	 fff     HD$X(WA)HH;}LD$@MHL$hb HĐ   _^[@SH`HBHHD$(Hx uWYtH	 XB(H`[H HL$8HD$@HD$ HD$Pu YEH	 XC(H`[@SH    Wf.HAxHH   zt9HhPYH	 \H	 Y   XxH	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
HnHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pH] H3H$P  HHHL$0"sxH HL$@[H( H$0  HL$0]LHHAPH$H  HrUHH$0  H=   r<tJ HAH;r: H+Hs* H'v H< H$   H$    H$P  H3蠱 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHM#} (Y
D	 XK(MHEHH#H      H;v
VG	 (  \f/   vƇ   \H(  f/v(\eH(  X \(LXH(   f/vH0   XD	 (t H0  X  H;t/HSHN HC(HF(HSHN HS0HN0 LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$h[ HMHLHT$hP(HH   HHHHPHKHHHSHL$hZ HHEHsH   HCH;t'H;tH1 Ht
HiHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h H       D  HY(WEHt3t HDiHEH] =E	 } H  H[WEHt37 HiHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM07}H  L@LEWEMt3כ HMgHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHM H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(l(Xu \Y(XuuHUH(  HyEf/w"\{ (H   Hhnf/vHE0H;tHU0H6WEH]HHt3 HeLHEH]LEHuHEHEHEHEH;t-I HtHeLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHMU LML   H   H   1HM HM HM`v HMHl HM8b HMW HML L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   HB(  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0$%  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0N LLHH&  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK    ~ HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_QhH0  ap(E	 HL$ (T\f/L$TTHGf/s(^(@SHpahHAHT%zE	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h 0  f/s(^W-E	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HMoHHEH[IG3H;t'H;tI Ht
HM`II?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
YD	 f     HE(WA)HH;}LEMHMu HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHMPM H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHMG Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM6 H(H;~uH>H;~IDHHMtLE'M+IILL$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHM D(=s5	 EtCH]H{ uA(HHEHEHEHMl (A^H]  HG     (A^}gH]H{ uA(HHEHEHEHMl D^DG0DMWEWMHUH@  HM] HMS HEgHEH]HuHOH;uHOMgIHHUF (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   QhH  ap(=	 HL$ (T\f/L$TTHGf/s(^(@SHpahHAHT%=	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h	   f/s(^W==	 Hp[HWH   H@HXHpHHHHL@@@HPHHq HsHG3H;t'H;tH Ht
HgXHHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
k<	 fff     HD$`(W)HH;}HL$(HL$8膷 HL$p L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$H D(50	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;tHHHt3 HVHD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0 E   LuI~ tIHD$PHD$xHD$`HL$Hf (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"H Ht
HJUHH    H_H_LEHT$xHJ   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;tHHHt3Ԉ HTHD$HH\$PH\$XLEHT$xHL$HG H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;t{IIHGHH;t"HE Ht
HTHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$H ID$HEDMLeLeLEHT$xHħ HL$0 (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    Hs HA@H HAPD$P   bVH HHH HG(HG@HcHHM| HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    Hr HA@H HAPD$P   TH{ HHv HG(HG@HcHHu HD9@HG@HcHQT9<HHNHH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH3r HA@H@ HAPD$P   PHv HHOH)} HHG@HcPH' HD:@HG@HcPDBDD:<HSHHD葿HH\$HHt$XH0_HL$AVH@HD$0H\$XHt$`H|$hMHH_  tH7MHH H[HHOH\$XHt$`H|$hH@A^HL$HH'(	 LL$P)t$0LD$X3)|$ s54	 =+	 Tf/vU  "   )	 LL$PLD$X3FsTf/v'  "   )	 LL$PLD$X3sTf/v  "   )	 LL$PLD$X3rTf/v˄  "   )	 LL$PLD$X3rTf/v  "   )	 LL$PLD$X3rTf/vo  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
 5 3Ld$xM+L$3IIHH+II;HCI;LCIPH$   HH+LL$   HHZ-HIL$   L+ˁ LGH3H$   IL+ HHGH+HHHtLGL+IKLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$p. HOLD$pHH+$   HH+H,H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0 H$   ILkHGL+LI+Hb H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(BHt$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
 U| H

 G| LD$0H|$(IH+HHHDL$pHH 3HthH+HI;v H    H=   r=@tz HGH;rj H+HsZ H'vM HHi (L\$PI[(Ik0Is8(t$@IA_A^_HSVWATAUAVAWH   HǀH)p)xD)@D)HH9 H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ Ht3} HuIHD$@H\$HDd$8A܉\$4D"	 fD  A;]  MuAA  ~1ID  H\$@MA(( ;HA;w |ۋ|$0LD$@H$   IbHHL$@HHT$@HPHL$HHHHT$HH$   | H H$   H+ H$   H$H  { |$0E3H$   H$   { H$   HcHH| H   H$   HcHh   H$   HD$hH$   y L5w L$   L$0  D$8  HT$@IM V  (D$hH$  H$   hHXH$  HrTHH$  H=   r<t| HAH;r| H+Hs| H'v| H袓 HtHt$`HH$   HPt$pHD$pH      H#H;u+H HD$ L
 LD$hH H
 ?&DXDL$P\$4É\$4H$   HcHH{ H   H$   HcHh   L$   H$   H$   y H$   x H$H  y 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^IOHy t#HH$   H$   H$   ŕ(fAnw Y5	 
 AXYXAXHL$@z (H$  H3舊 L$   A(sA({E(CE(KIA_A^A]A\_^[HSVWATAUAVAWH  Hǀ@)p)xD)@D)HHo5 H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ(Ht3%y HDHD$@H\$HDd$8A܉\$4D^	 fD  A;]  MuAA( ~1ID  H\$@MA((l ;HA;w(|ۋ|$0LD$@H$   IBHHL$@HHT$@HPHL$HHHHT$HH$   jx H*~ H$   Hz H$   H$8  uw |$0E3H$   H$   4w H$   HcHHx H   H$   HcHh   H$   HD$hH$   t L5s L$   L$   D$(  HT$@IM   (D$hH$  H$   8dHXH$  HrTHH$  H=   r<t0x HAH;r x H+Hsx H'vx H" HtHt$`HH$   HPt$pHD$pH      H#H;u+Hs HD$ L
/ LD$hHc H
4 !DXDL$P\$4É\$4H$   HcHHv H   H$   HcHh   L$   H$   `H$   :u H$   tt H$8  &u 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^IX|(AXHL$@u (H$  H3R L$  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pHY1 H3HEIHHE   3Hu@uDFnH HM>HHUHP@HEHrPHHMH=   r<tu HAH;ru H+Hsu H'vu HՌ HHPHE   HuE 8 uLIIB<  uHHM蘐HHUHP@HEHrPHHMH=   r<t=u HAH;r-u H+Hsu H'vu H/ HE   HuE A   Hҽ HM	HHUHP@HEHrPHHMH=   r<tt HAH;rt H+Hst H'vt H蠋 HE   HuE Ah   Hӽ HMzHHUHP@HEHrPHHMH=   r<tt HAH;rt H+Hss H'vs H HE   HuE E3H HMHHUHP@HEHrPHHMH=   r<ts HAH;rs H+Hsss H'vfs H腊 HMH3	 H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ IK  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HOJp HO@p HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;vp KHH=   r<tp HBH;rp H+Hsp H'vp HHH(陇 H(LHXICHfffffffH;vJHCx IC3ICICH ICD$0ISIKn Hb HD$8HL$8  Hu3KH;vl HHH   r&HA'H;wl H҂ HH'HHA迂 HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"Hxn Ht
HC:HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHMH HLFhLNH     HFH^HHEH~HCH;t+H;t"Hm Ht
Hy9HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
	 fHE(WA)HH;}LEMHM襘 H   Hǆ       H E3L\$pI[Is I{(I]Hu EHEHU3HMHEHEH HE
l H.l Ho
 HEHM @SH 3HHHAHAHt~H
H;vH
o i HRH|$0H<    H   r#HO'H;wi ! HH'HHAH HHHKHHH|$0HKH [LALIIHQ I+HH;|
IH+HH+IHHAHtL+I<|H\$WH H/\ HHAPHI8k HO zk HOpk Hc Ht
   Hd HH\$0H _@SH HHI%k HKH [H%k @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(FE3EL9{~HN(HJJIL;S|HFXLFLN@HV(Hc5	 WAE H^HH+^@HI;^tIi Ht
Hz5IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtH 褾HH\g    cAE $   H$   H#H;t3@HN Ht+H" UHH FHHf       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [HhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$PqD WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;tIHHt3f H2HLsHkHnH{ H|$hH|$hL?LHt3f Hc7 HHoHnH{0H|$hL?LHt3f HS2HHoC@   CD HHH HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	Ѽ uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
g b HH|$0HT$8HHFHHH\$@HNH+H>LHmd H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PH  H3HEpMMHHH   D$     Hf HD$`HMc D$    E3E3HT$hHL$`c HD$`HcHHS HD`HD$`HcHDxDD\   HL$hgHHL$`ɹHH? 躹HH诹HHU 蠹HI蕹HI9b HH~HUPHL$`RHxrH H
l HL$(3HL$0HL$8HD$@D$HHT$0HL$@b H` HD$(H
 HL$(܆ @SH`W)t$Pf/D)D$0D(   u+DW	 3A(Wm	 (t$PD(D$0H`[
	 fA/DWG	 A(v(
	 \((t$PD(D$0H`[3bX2	 (t$PD(D$0H`[5	 fA/)|$@D)L$ D
 	 !  	 fA/vTfD.z   eH%X      HЋ9)   % AYDY	 AX  } eH%X      HЋ9 
  A(AY(Y((Y% (Y
g Y X% X
? X YYY/ X% X
 YX XYX^X%	 AY  3t
#	 	 fA/   eH%X   =	 fA/   HЋ   9x   A(A(\AYW2	 (Y  ((Y (Y (Y
 Xr Xb A^X
e YYYX9 X
9 YYX(Y: X
 X X YX YX^X	 Y  	 fA/   9 '  A(A(\AYW:	 (Y ((Y (Y (Y
 Xz Xj A^X
U YYYXA X
) YYX(Y* X X
 YXX
 ^X.	 Y  ]	 fA/   9   A(A(\5	 AY(WG	 Y ((Y (Y (Y
: X X A^X

 YYYXy X
 YYX(Y XJ X YXX
 ^XV	 Y   9 Z  A(A(A^AY(YWi	 > ((Y (Y (Y
 Xp X` A^X
 YYYX/ X/ X
 YYYX X
[ X(Yt X\ YX@ YX^Xl	 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
 o = L	 H
 E <o H
t o =h (	 H
T (
m
	  n	  (	    	 
 (
B	  
 n qH
 	o = V(	 H
 (
[	  (-	  (	 
 (
	   
 (
d	  
 ,n H
 {n =x (	 H
d (
]	 V (o	 
X (
q	 Z (#	 
 (
	  
' m [H
 m = .(	 H
 (
?	   (	 
 (
	  (5	 
F (
	 H 
Q 0m H
  m = (_	 H
  (
!	  (3	 $ 	 $ (5	 
 (
	 H  	 
) (
	 J 
3 l H\$D$WH`)t$PI)|$@H(D)D$0	 f/   (- f.zuZ o	  !   t  (E (Wf/
	 WvW  D(E3(LHXD\( D\  A f/vfWf.zo		 (
 Tf/vy D(DW		     ^\> TL D(    f/v$((\ \
a (E D(of/= r! f/v(+K  D(DHL$pׯ D((X
 \r 軯 \ \=] YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
 )t$P)|$@   HD)D$0D)L$ D(ȋ
9    DX
 5b D(A(AYD^A(A(AY f EX
Q YYA^X4 X
$ D(L$ X(t$PYYX X
 YY(|$@X AYXX AYD(D$0\HhH
 i = (	 H
 (
	 )n (	 )
p (
I	 )r )
{ "i H8eH%X   
! A   )t$ (HB9    (\5 \-0 (\-% Y\- ((Y% (Y (Y
 X%e Xu Y] X
] YX9 YX%% YX1 YX
 YYY(t$ XX X% X^YY-, X(H8H
 Xh =  H
 (
	 ! (	  (	 } (~ 
_ (
	   
b (
 s 
L kg HH   )xD)@D(DT1	 D)HD(DT
 	 D)PE(D)XDA fE/D)`D(EYrA(A(A( (    fA/A()$   rL (A(L ='   M (A(M (XY=- YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW=<	 (($   HĨ   @WH  HD$PH$  H H3H$p  IHD$     HU HD$`H$   R D$    E3E3HT$hHL$`R HD$`HcHHB HD`HD$`HcHDxDD\   HL$hc}Hs HL$`HH7v 貨HH觨HHM| 蘨HH荨HHv ~HHu oH$P  HL$`AHxrH H
[ HL$(3HL$0HL$8HD$@D$HHT$0HL$@Q HY HD$(H
 HL$(u H@Hx)p()xD)@D D)HD
 fD/D)PEWA(rPA(\(p$ (\f/
 vAXfA.z   = Y( ^fA.z   f/5T r
(ZX
X f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   H H
 D$   . L$   Hޜ H
  H  HD$PH H3H$p  D$     HS HD$`H$   O D$    E3E3HT$hHL$`O HD$`HcHH? HD`HD$`HcHxT\   HL$huzH{ HL$`ӥHHIs ĥHHy 赥HH[y 覥HHs 藥HH 舥HHr yH$P  HL$`>HxrH H
X HL$(3HL$0HL$8HD$@D$HHT$0HL$@N HV HD$(H
 HL$(r HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p54 )xWD)@DG D)HD
a H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4CF H;}&HEHM(HE)HH;|LHMH HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ p E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   `K HHL$(rK H
 HL$(n @SH0HD$     :HH0[@SH0HD$       HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH 3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+I>Je  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHM聂LeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHMLeHEH}IHtHHHEIM;w!H
 F H
Ձ F H]3MtyIrTIƃIH+foi f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHMHUHFH?HMHthHEH+HH;vH H    H=   r<tH HAH;rH H+HsH H'v{H H_ A   L}XI;      HVHHM?
E3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HDHNHMKHHHMHt		H]L}X1L;Fu
   HjDHNHMXHMHt
HU`	H]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH0^ IL}XL;}s(F F F F F HtsL+IHL;vF J    H=   r=@tF HGH;rF H+HsuF H'vhF HH] IM H   IEH+HH?H;v.F H    H=   r<tF HAH;rF H+HsE H'vE H] 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){H  H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0 f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   C V  H$  H$   !HL;   IM Ht~IEH+HHH;vC H    H=   r<thC HAH;rXC H+HsHC H'v;C HZZ Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;vB H    H=   r<tB HAH;rB H+HsB H'vB HY   HH H$  L$  H$   H$  H2G H$   HC H$0  H$  }@ AD|$4E3H$8  H$   :@ H$   HcHHA H   H$   HcHh  H$8  HD$XH$8  = H< H$8  H$  $  ML$   H$  HL$P.H$  H$   8-HXH$  HrTHH$  H=   r<t0A HAH;r A H+HsA H'vA H"X HtHH$   HPH$   HcHH? H   H$   HcHh  H; H$8  H$8  fH$8  > H$@  = H$  > HIE H$   HA H$0  H$  > AD|$4E3H$8  H$   Q> H$   HcHH-? H   H$   HcHh  H$8  HD$XH$8  ; H1: H$8  H$  $  L$   IHL$PE (H$  H$   U+HXH$  HrTHH$  H=   r<tM? HAH;r=? H+Hs-? H'v ? H?V HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   H H$  YHH$  HP H$  HǄ$     H$  Ƅ$   A>   H H$  YHH$  HP H$  UHǄ$     H$  Ƅ$   A4   HT H$  /YHH$  HP H$  H$  )H$  ; H$   ņ  H$  +W$  H$  A-> L$  L$   IHL$P> +fn^5u H$  H$  )HXH$  GHtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   H H$  WHH$  HP H$  HǄ$     H$  Ƅ$   A8   H H$  bWHH$  HP H$  2HǄ$     H$  Ƅ$   A4   H H$  WHH$  HP H$  E2HI;EulMtL$  M+II<KH$(  'H$(  9 H$  r'H$  t9 H$   VLd$`4  $   J  HǄ$     H$  Ƅ$   E3HwD H$  +VHH$  HP H$  H$  >(Hv H$  yH(8 HHC ^HH$  HPH$  'Y5 Hp H$  #HH9 HH~ H(7 HH HH$  HPHǄ$     H$  Ƅ$   A%   H H$  UHH$  HP H$  HǄ$     H$  Ƅ$   E3HC H$  THH$  HP H$  HǄ$     H$  Ƅ$   E3HB H$  mTHH$  HP H$  =H$(  %H$(  !7 H$(  %H$(  7 MtL$  M+IIxHH$(  $H$(  6 H$  $H$  6 H$   蒁D$HL$@T$2   H$  s$H$  u6 H$   W3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3H2A H$  RHH$  HP H$  H$  $H H$  H(4 HH H(4 HH` ۋHHe ̋HȋT$@4 HH% 谋HH$  HPHǄ$     H$  Ƅ$   Ae   H& H$  QHH$  HP H$  H$(  "H$(  4 Hn> H$   3H$   H$   H H$   Ƅ$   H$   H$   4 H; H$   Hq
 H$   X HL$pHIPH\$xHt(H$   HL$   L+IHCH$   HtL$   L+I4IH$  H3FE ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH@
 H3H   (MLHT$`HL  L  H  3ۉ\$DH   V"WD$HH\$XLL$HMIH$(H  H    HXH  HrSHH  H=   r<t4 HAH;rx4 H+Hsh4 H'v[4 HzK H   IH   IPH  H   HLAHo) H;t
HHAАH  HrSHH  H=   r<t3 HAH;r3 H+Hs3 H'v3 HJ W  Hǅ      t$(H  HD$ MMIHJ H  H   4HXH  HrSHH  H=   r<t.3 HAH;r3 H+Hs3 H'v3 H J H   IH   IPH  H   HLAH( H;t
HHAАH  Hr\HH  H=   r<t2 HAH;rt2 H+Hsd2 H'vW2 HvI H' E3EDd$@H  H H  ҆H(n/ HH;tHPH  H  HLAH;t
HHAАH  HrSHH  H=   r<t1 HAH;r1 H+Hs1 H'v1 HH HH;tHPHǅ     L  ƅ   E3H: H  aLIH  IP H  HrSHH  H=   r<t0 HAH;r0 H+Hs0 H'v0 HG IH  IPHǅ     L  ƅ   E3H-: H  KIH  IP H  HrSHH  H=   r<tL0 HAH;r<0 H+Hs,0 H'v0 H>G H  r
   HL$hi, H  HcQH  HHP   H   <, HH H  nHHuI
H HcHHHW   HM+ HH H0HHuI
H HcHHHW   HM+ HH^ HHHuI
H HcHHHW   HM~+ HH H贃HHuI
H HcHHHWH H舃H  H  HLAH$ H;t
HHAАH  HrSHH  H=   r<tu. HAH;re. H+HsU. H'vH. HgE IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
8  =- H HEHp HEHMH, L$DE3HUHM+ HEHcHH, HD
HEHcHhT
HEH   HMJ) H' HE3HE0E8IHHH   
   HM) HMHcQHMHHP   HM) LIHMr* HHu3
H HcHHIWA   HMN) LH   H'* HHu3
H HcHHIWA   H   ) LB+H) HHu3
H HcHHIWA   H  ( LH) HHu3
H HcHHIWAB+\Hw) H   HMHLAHP! H;t
HHAАH   
IHUIPB+\Tf/vD$@HMHHMH) IHL|$`IGI+HL;H|$hH
6Dl$@H  H\$HHX  eHX  h) HX  KHX  N) HtL  L+IH:HtLD$XL+IH:HX  HX  ( AH   H3: L$P  I[XA(sA({IA_A^A]A\_^]HWATAUAVAWH  HǀHXHp)p)xD)@LH5 EWWHHǀX    H`LhHǀp    Hǀx    H
HBH+HHucH2 HD$p3HD$xH$   Hte H$   Ƅ$   HT$xH$   I( Hj( HD$pHe HL$p<HǄ$H     $   HBH+HHwcH1 HD$p3HD$xH$   Hd H$   Ƅ$   HT$xH$   ' H' HD$pHyd HL$p   H$H  AD$hW$   E3L$   LcnxIMt*M;v
H
 a :% IH$   `L$   E3H$   L$   M;  IFI+HH;rcH0 HD$p3HD$xH$   Hc H$   Ƅ$   HT$xH$   & H& HD$pH~c HL$pHHH$H  I<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
_ $ HM+IIHIH+IE3I;LCL;ICH$   _L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
G_ # HM+IIHIH+IE3I;LCL;ICH$   ^L$   H$   L$   Ht:HH$   IH$8  | AX$   WD$pE3L$   Lcf,MtM;v
H
^ " IHL$pY^MH\$xLt$pM;   H$8  F(D$`HD$`H;sGHD$`L;w=H|$`I+HH;$   u   HL$p7H\$xLt$pHt5IH,H;$   u   HL$ps7H\$xLt$pHt;HH\$xIS- |   H~(DH;K H
\ 蛔HcH$   [IL$   IH$   H+HHt0LD  A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rm }   DHJ H
|J ߓHcH$  IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;r ~   DF,HY H
7[ .HcV,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r    DF,HX H
Z nHcV,H$   -IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rߋ   uo3    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  ʴHH$   3       HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  iHH$   3H$8  HtL$H  L+I61A   HIW D;f,`  
    IcLM+IHD$(D$    DE萏L   L+   IH
V HL$(D$    DbH   tAYtL$   L+$   IH
X HL$(D$    DH$   t^    HV HD$(D$    DEL   L+   IH
>V HL$(D$    D蹎H   tAYtL$   L+$   IH
vW HL$(D$    DuH$   tA   = f;~(      HcL$   L+$   IH
V HL$(D$    D
L$   LGU HH   |LH$   H+$   HMNM+IHD$0HD HD$(LD H
D 6	MFM+IH$   Iˏ(LT HH   LH$   H+$   HMNM+IHD$0HTD HD$(LLD H
ID MFM+IH$   IQXAYtXL$  L+$  IH
_D HL$(D$    DҌH$  tmAŋN(    ;}AD  ;}AŋN,f;}AD  ;}Ɠ    Ǆ$      Dl$`L$   HT$`H$   d $   H$   H$   Vt    D$`   D$   LD$`H$   HL$h D$hHT$hH$   
+    Dl$`L   HT$`H$   % D$hHT$hH$       3 D$hDl$`LD$hHT$`H$    D$hHT$hH$       Dl$`L   HT$`HL$p D$hHT$hH$   Db    HN`L$   H$   $   H$   H$   H$   Ht(L$   L+I,W$   L$   H$   Ht(L$   L+I+W$   L$   H$  Ht(L$  L+I+W$  L$  H$   Ht(L$   L+Ir+W$   L$   HT$pHtL$   L+I@+H$   HtL$   L+I+D$   H$   H$   H$   q (H$   HtL$0  L+I*(L$  I[8Is@A(sA({E(CIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@2 D($h  H^H+HWL$XLt$hHtHHHH;tXrHHHt3+ HHD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3 HHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$X謝HVH+HHL$p5 D D$   =3  fD/i  Y5ռ $   fD/  HL$pHHtmH$   H+HH;v H    H=   r<t HAH;rw H+Hsg H'vZ Hy/ HL$0e HL$XY HtqH$   H+HH;v H    H=   r=@t HGH;r H+Hs H'v HH. HtlHD$PH+HH;v H    H=   r<t HCH;rz H+Hsj H'v] HHy. A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI茺(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;v$ H    H=   r<t HAH;r H+Hs H'v H, HL$0 HL$X HtqH$   H+HH;v H    H=   r=@t} HGH;rm H+Hs] H'vP HHl, HtlHD$PH+HH;v' H    H=   r<t HCH;r H+Hs H'v HH+ (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(HHT$(HPAEHT$(H谦HHHT$(P HL$(Ht HT$0LD$8HT$(L+IW!H\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHHNHHT$(HPWD$@Hl$PHT$@HeHLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$HLD$PHT$@L+I WD$@Hl$PHL$(Ht.HT$0LD$8HT$(L+IP WD$(Hl$8H[ IIN L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
4LP  L8  L0  D  = HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn(h g ,H
H HD$@Hp HD$PHM H  E3HT$XHL$@ HD$@HcHH HD@HD$@HcHhT<HD$XHD$0HL$X
 H HD$X3HEEH HL$PeHcHMh
 HL$PHcQHL$PHHPAHL$Pd HHΌ eHȋ  F    HMx/
 HD$0H׌ HL$PaeHHu3
H HcHHHD$0HPfAnY^,H
 HH\ eHd (   HF HEHL$PdHX  HHT$@PHD$@HcHH= HD@HD$@HcHhT<Hf
 HD$XHL$X6HL$X
 HL$`)
 HM
 HX  L0  HLMHU@HPHIR  H
 HE@HMH     t5Ǚ  u(H@  HD$ LMI* LIIΝ;   D  D   H
1L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  HH$  W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  BHL8HL$pHHLxHL$xHHLxH$   H$  t HHL$pHw H$   WH$   H` H$   H$  H H$  H$  H$  H$  H$    $(  (
! )$0  W$@  D$H  Ǆ$L      $P  D$X  Ƅ$\   $`  H H$   HT$pH$   O$8  f/v	$0  $@  f/v f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H H$   H H$  H$   y
 H$   k
 H$   ]
 H$   O
 Hx H$   HL$p5
 H$   HtL$   L+I33HL$p
 H$   HtL$   L+IiN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHy
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pHHL$tW$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   WD$xH$   LLGIH$   HHHL$xHHHXH$   HHHXH$   H$    HHL$xtH H$   WH$   tH H$P  H$`  H H$X  HD$pH$h  HD$pH$p   $x  (
 )$  W$  $  Ǆ$     6 $  $  Ƅ$   $  H& H$   WH$  L5 L$   L= L$  HT$xH$   螫$X  f/v	$  $`  = f/vf/v	$  $  $h  Oȉ$  Y
 (|] $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   $ L$   L$  H$p  + H$`   H$  HI H$   HJ H$X  H$8   H$(   H$   H$    H H$   HL$x H$   HtL$   L+I33HL$xn H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  
HH$  	W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   WD$pLLGHH$h  zHL8HL$pHHLxHL$xH$h  | HHL$pH H$   WH$   H H$   H$  H H$   H$  H$  H$  H$  (* )$   (
K )$0  D$@  Ǆ$D     Ш $H  D$P  Ƅ$T   W$X  H4 H$   HT$pH$   $(  f/v	$(  $0  f/v f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     H H$   H H$   H$     H$   ~  H$   p  H$   b  H H$   HL$pH  H$   HtL$   L+I33HL$p  H$   HtL$   L+I|N   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p	HHL$tW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   蓹WD$xLLFIH$   HHHL$xHHHXH$   H$    HHL$xHd H$   VH$   \Hu H$8  H$H  H~ H$@  HD$pH$P  HD$pH$X  (ŧ )$`  (
 )$p  $  Ǆ$     l $  $  Ƅ$   W$  H H$   VH$  !L5 L$   L=C L$  HT$xH$   q$8  f/v	$h  $@  =0 f/vf/v	$x  $  $H  Oȉ$  Y
1 (S $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   5  L$   L$  H$X  ^ H$H  P H$   ;H| H$   H5 H$@  H$(   H$  	 H$    H$    H H$   HL$x H$   HtL$   L+I933HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3 HHHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHMyg Hq H]HL$xHEHL$xHMHT$pLL+t
HO HT$pWEH WEHE    HMBHHUHPAEHUIIE HUIP HMHtHU1LEHUL+IH]HM0HEHMHMHULL+tH+O EEfEMLHUHM
 D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H    +fDnED^v HMH   HIP  H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H    r +fn^5 LM(A(8LM(A(((A(HM،H  HEHM L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CH'
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HyI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  [c II耥  L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   Zb HR H$   H$   轿H$   H$   H$   HT$xLL+t
HJ HT$xW$   H H$   LMH$   H$   H$   LMHH$   P D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I R +fDnED^ Aƅ    A   I AExH$   ,H$   IlPIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4 +fn^5 L$   (A(HL$   (A(4(A(H$   H H$   H$     H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   =WD$pL$   LLFIH$  tHL HL$pHHL`HL$xHHL`H$   H$   HHL$p1H H$   VH$   1H H$   H$  H H$  H$  H$  H$  H$   Ò $(  (
S )$0  W$@  =_ $H  $X  Ǆ$P  
   H H$   HT$pH$   虓$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H H$   H H$  H$    H$    H$    H$    H H$   HL$pt H$   HtL$   L+I33HL$pB H$   HtL$   L+IN   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t*W$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   触WD$xH$   MLFIH$   ޽HHHL$xHHHXH$   HHHXH$   H$   
 IHL$xH H$   VH$  蘎H H$`  H$p  H: H$h  HD$pH$x  HD$pH$  0 $  (
 )$  W$  =̏ $  $  Ǆ$  
   Hp H$   VH$  (L= L$   L% L$  HT$xH$  ؎$X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y
- (@ $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   9 L$   L$  H$x  R H$h  D H$   /H H$   Hq H$h  H$H   H$8   H$    H$   H
 H$   HL$x H$   HtL$   L+I-33HL$x H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   !WD$pLLFIH$h  蠳HH     HL$pHHH@    HL$xH$h   HHL$p5H H$   VH$   H H$   H$  H H$   H$  H$  H$  H$  (H )$   (
i )$0  =a $@  W$P  Ǆ$H  
   H: H$   HT$pH$   8$8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   HL H$   H H$   H$    H$    H$    H$    H H$   HL$ps H$   HtL$   L+I33HL$pA H$   HtL$   L+IN   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t*W$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   觜WD$xLMFIH$   &HHHL$xHHHXH$   H$   % HHL$xHx H$   AVH$   oH H$H  L$X  H H$P  HD$pH$`  HD$pH$h  (؊ )$p  (
 )$  = $  W$  Ǆ$  
   H H$   AVH$  IL= L$   L% L$  HT$xH$   $8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
N (6 $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   H$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$   j
 L$   L$  H$`  s H$P  e H$  PH H$   HJ H$P  H$8  , H$(   H$   H$    H+ H$   HL$x H$   HtL$   L+IN33HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HiI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KJ IIp  L$   H$   H$   L$   WD$xHt3 H聧HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JI HB H$   H$   警H$   H$   H$   HT$xLL+t
H1 HT$xW$   H H$   LMH$   H$   H$   hLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IB +fDnED^ Aƅ    A   0 AExH$   hH$   I\7IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$v +fn^5 L$   (A(8jL$   (A($j(A(H$   nH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[HWATAUAVAWH  HǀHXHp)pH
 H3H$p  MLL$xL$   H$   HL$@H$  H$   H$  H$   L$  L$  H$   H$   D$0    H8e HHH*e H;e r
   W'HHL$8Ht
~ .H3D$8P   E$HOV H
hW GGIc$HL$`ٝ3LD$hIHL$`H+HHt-@ f     HHLD$hIHL$`H+HH;r3L+IMtfHHHD$hHL$`H+HH;rD$8Q   DH5V H
V FHcHL$H83HD$PH|$HH+HHtHHHD$PH|$HH+HH;r3HD$PH+HHtHHHD$PH|$HH+HH;r   5U H
W A;4$   D$8T   HcMFM+IHL$(D$    D	EIL<MEM+E IH
x HL$(D$    DDMu LD$hL+D$`IH
UW HL$(D$    DDH|$`ALWMGH$   <>H HDH|$HLt$x.A   Ll$xH*H$   D;8  D$8W   IcH$   L HHI+HHHHHH?H  F;  HCH@IH$   L LpM+I-  AF;!    F;  H[M4Ht$PH+H   F;   LD$`H$   `
  LH$   HL$xK5HMIVH$   4
  LH$   H$   5ATHH$   <LHH$   4H HDAH|$HH H$   H H$   H$x   D$0   E3H$   H$    H$   HcHH{ H   H$   HcHh   H$   HD$@H$    H H$   3H$`  $h  H H$   (   HL H$  H$   藿L$  H$  LC$  HaS HD$ DË?Hn H$  H H$  H$x   D$0   E3H$  H$  w H$  HcHHS H  H$  HcHh  H$  HD$@H$   HW H$  3H$`  $h  H H$  r'   H$ H$  H$  oL$  H$(  LC$  H!R HD$ DË=HF H$  H H$  H$x   D$0   E3H$  H$  O H$  HcHH+ H  H$  HcHh  H$  HD$@H$   H/ H$  3H$`  $h  H_ H$  J&   H H$0  H$  GL$0  H$H  LC$0  HP HD$ DA<H H$  H H$  H$x  h D$0   E3H$  H$  & H$  HcHH H  H$  HcHh  H$  HD$@H$  v H H$  3H$`  $h  H6 H$  !%   H H$P  H$  L$P  H$h  LC$P  HO HD$ DË;D$8Z   HT$HH|$@Hb HL$HHHtyHD$XH+HH;v H    H=   r<t HAH;r H+Hs H'v H WD$H3HD$XHL$`HtiHD$pH+HH;vK H    H=   r<t/ HAH;r H+Hs H'v H! HH$p  H3 L$  I[8Is@A(sIA_A^A]A\_H\$WH@LIL L+	HHBH
 H+HHHD$0H IHD$(FHK3H+HHt%@ HHHHHHKH+HH;rH\$PH@_HLH L@HPHHSVWATAUAVAWH   Hǀ()pMMLD$p    HZ HHHZ H;wZ r
   HH$  Ht
3t F$H3Ǆ$  9   H$  DHM H
O <HcHL$@)3LD$HIHL$@H+HHt-@ f     HHLD$HIHL$@H+HH;r3L+IMtfHHHD$HHL$@H+HH;rǄ$  :   H$  DH
M H
M ;HcHL$X}3LD$`IHL$XH+HHt!HHLD$`IHL$XH+HH;r3L+IMtfHHHD$`HL$XH+HH;rǄ$  <   H|$(H$  HD$ MMIH$     HHHH+HLL$HL+L$@IHL$0H  HD$(L H

 谵3HD$HHT$@H+HHt,     HHHHHD$HHT$@H+HH;rH$   HtL$   L+I   L$  5o L=L L4L I*;>  Ǆ$  >   HcIMI+M IHHHH?HLD$(D$    DDD9H[IE H4L$  MFM+IL|$(D$    D9M>IMI+M IHHLI?LHVL HD$(D$    D8H[IE L4L$  MD$M+$IH
9L HL$(D$    D8I$HD$xLD$`L+D$XIH
L HL$(D$    De8Ld$XLD$@HVH$   *  LH$p  H$   *LALH$   .HL$x  IVH$     LH$h  H$   )HH$   2LHH$   0HH$   DKL(H$   *LHD$xLH$   -H IDH$  Ǆ$  A   HT$XL$`  Io  HL$XHHt{HD$hH+HH;v H    H=   r<t HAH;r H+Hs H'v H WD$XHD$h    HL$@HtiHD$PH+HH;vV H    H=   r<t: HAH;r* H+Hs H'v
 H, I($  H   A_A^A]A\_^[@WHPHD$@H\$hHt$pIHHI@I+ HLJL+
IHD$0H HD$(L H
 TH-T HH0HT H;T r
0   LHHL$`HtHLOL+ILE  3HHH\$hHt$pHP_@SH0HD$     HH0[HWATAUAVAWH  HD$pHXHp)pHɁ
 H3H$  MMHHL$8L$`  L$h  D$4    D$0   EHH H
cI 5IcHL$XU3LD$`IHT$XH+HH      Ht/L@      IHLD$`IHT$XH+HH;r3L+IMtfHHHD$`H+D$XHH;rD$0   EAHg H
vH 4AHcHL$@裟E3HL$HHHT$@H+HHt&L KIHL$HHHT$@H+HL;rE3HH+HHt.Lfff     KIHL$HHHT$@H+HL;rD$0    H+HHG HD$(D$    A   D?3HHD$@H   H
G A;   D$0"   HcLD$HL+D$@IHL$(D$    D2Ht$@MFM+IH
G HL$(D$    D2ItXtHcLD$HL+D$@IH
PG HL$(D$    D2HD$@tHAU    A9  Lt$`HT$X%h D$0(   HcI|$I+<$Hm  G;b  M$H|$HLD$@I+H  G;  Hc  G;  ADA^D(\AL\YL+Is  AF;g  \D$0)   Lt$`IHT$XH+H|G;}XTA;  H H$   Hz H$   H$  D D$4    E3H$   H$    H$   HcHH H   H$   HcHhT|H$   HD$8H$   U H H$   3H$   $  H H$       H H$  H$   L$  H$  LC$  HF HD$ DËl-H H$  HU H$  H$   D$4   E3H$  H$  ݿ H$  HcHH H  H$  HcHh|  H$  HD$8H$  - H H$  3H$   $  H H$     H H$  H$  լL$  H$  LC$  HWD HD$ DAC,H H$  H, H$  H$   D$4   E3H$  H$   H$  HcHH H  H$  HcHh|  H$  HD$8H$   H H$  3H$   $  H H$     Ha H$  H$  謫L$  H$  LC$  HB HD$ DƋ+H H$  H H$  H$  ν D$4   E3H$  H$   H$  HcHHh H  H$  HcHh|  H$  HD$8H$  ܺ Hl H$  3H$   $  H H$     H9 H$  H$  脪L$  H$  LC$  HA HD$ DË)H[ H$  Hܿ H$  H$   D$4   E3H$  H$  d H$  HcHH@ H  H$  HcHh|  H$  HD$8H$   HD H$  3H$   $  Ht H$  _   H H$  H$  \L$  H$  LC$  HJ_ HD$ DË(D$0+   HT$XHt$8H0HT$@Ht!LD$PL+IWD$@3HD$PHT$XHtLD$hL+IHH$  H3 L$  I[8Is@A(sIA_A^A]A\_H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtH@ u uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$ WATAWH eH%X   HD
i' Iع   HNB	90H   HHH9LH-KG HLL%HG IL=FG L;HLH0  HELt$@H?L   IIL;LLM;~8IHIHHuI H   IH+HHHIHH+HLLH>IHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLLt$@II;~/HIHHtIH   H+HHHL+L   M;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+LH\$HHl$PHt$XH A_A\_H
"F  =F H
=E pH
E   Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05] f     IM(W Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05!] f     IM(WO Hv;}(|(t$0Ht$hH\$`MHT$ H IHHIINHPHHHL$ IVQ Hl$pH@A_A^_H   "A)(Yu] ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YYh] Y=] \A(Y\ ^X^^A(\AX(YY\
 H$   (DC\ XD.[ (\D H$   A(YA(^Wgf (YA^A^XX^YW?f AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM1  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHKHH@  HEHCHEHLL+t
 E3EH  D=d D5X @ f     H   H HEuIHEI^HGH;t'H;tH Ht
HNHL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHM LMHH   H}HtAXAY
HuLuI~ uA("HHEIHEHEHEHMF/  (A$A(H   YH(  X	f/   fA/r	E   (T
ob A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHF D(Y5xX A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(T H\$    LMHH	 DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(Hil
 H3H$X  MMHHH$  H\$ HL$0蓞H$0  HD$@H$8  MMHH$0   H$0  HL$0ĜHxH$H  HrTHH$0  H=   r<t HAH;r H+Hs H'v H HtHHT$0HPH$   mH$   o H$X  H3 H`  A_A^_^[HL@SVWATAUAVAWH  Hǀp)p)xHk
 H3H$  IH$(  LH$0  H$  H$X  H$   H$`  H|$PA D$ L
 DB H H
 
HCHD$ L
 EE H H
 {Ic] W$   Ht3v HFzHH$   H$   H$   W($   HL$XHD$XH$   H$   H$   HD$0H$   H$   H$   HHH+HHHE3AH~!f)HH;}$   HL$XLH$    Ic] WD$8Ht3 HkyHHD$8HL$8H\$@(|$XH$   H$   H$   HD$XH$   HD$0H$   HD$8H$   HHH+HHHIH~'fD  f)HH;}D$XH$   LH$   ? Ic] W$   Ht3ɬ HxHH$   H$   H$   (|$XH$   H$   H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$   _ Ic] W$  Ht3 HwHH$  H$  H$  (|$XH$   H$   H$   HD$XH$   HD$0H$   H$  H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$    Ic] W$   Ht3	 HvHH$   H$   H$   (|$XH$h  H$h  H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$h  LH$    EDt$4D$   5O I      @      $P  D;  AA}  ~LIL$   fff     H$  M((z HA;u |I      H|$PL$  H$   IHH$   HH$   HPH$   HHH$   H$   ^ H$  蘗H$@  H$x  H$  H$  L$   L$   H$   H$x   H$  H$  譕HXH$  ܈HtHH$  HPIL$   L$    I;sQHcA$   H$   I#I;u*H" HD$(LL$   H H
 ?VHL$  H$   H$   H$   H$   H$  H$   HD$HH$   H$   H$   L$   IHH+HHHIH~-@ A(fX)HH;}L$  H$   MH$   d LD$8L$   L$   L$@  L$  L$P  HL$8HL$hHD$hH$  H$8  H$  HD$1H$  H$   H$  LT$@IHH+HHHIH~?     A(fAY(fX)HH;}L$P  L$@  HL$hMH$  ) ADd$4H$8  褓H$8   H|$PE3Dd$4WL$0  H$  H$(  H|$P@fn(T$hH$   H$   H$   H$  HD$hH$  HD$1H$  H$   H$  L$   IHH+HHHIH~.f(f(f^)HH;}D$hH$   H$   T$hHL$8H$   H$   H$  HD$hH$  HD$1H$  HD$8H$  LD$@IHH+HHHIH~,(f(f^)HH;}T$hH$   H$  & HD$8HD$PHL$8H$@  IMH$X  IUH9T$@tA   HL$PH HD$PHHL$hHL$hH$  H$8  H$  HL$1H$  HL$PH$  HpHHH+HHHIH~J    H$X  ()$   H$    H$@  (fYHD$h)HH;|LHH$  C HD$8H$  t$hHL$8H$   H$   H$  HD$hH$  HD$1H$  H$  H$  LD$@IHH+HHH~6     (fB(fXB)IL;}t$hH$   HH$  b H$   H$(  蝳HT$8H$(  H$   4 H$  % H$    HL$8
 H$    H$  H3胳 ($  ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
q  HMALM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMLMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHM&LMHMLEHtHHLMLEHMHHMHHcI;F}!H
  : H
 , WEHE    LEHUI  (HMH   HEH+HH?H;vs H    H=   r<tW HAH;rG H+Hs7 H'v* HI WEHE    HMHthHEH+HI;v H    H=   r<t֠ HAH;rƠ H+Hs H'v Hȷ (L\$pI[ Is(I{0Mc8(t$`IA_A^]HL@SVWATAUAVAWH  Hǀp)p)xHU[
 H3H$h  IH$   LH$   H$   H$  H$   H$   H$   A(D$ L
. DB(HC H
d HCHD$ L
? EG(H H
= 
Ic_(W$   Ht3 HjHH$   H$   H$   W($@  H$   H$   HD$8H$@  HD$@HD$0HD$HH$   HD$PHHH+HHHE3AH~&ff)HH;}$@  H$   LHL$8O Ic_(WD$XLt$hHt?HHHHH;tHtHHHH;tHHHt3 H\iHHD$XHL$XH\$`H\$h($   H$@  H$H  H$@  HD$8H$   HD$@HD$0HD$HHD$XHD$PHHH+HHHIH~$f)HH;}$   H$@  LHL$8/ Ic_(WD$pHt3 HhHHD$pHL$pH\$x($   H$@  H$@  HD$8H$   HD$@HD$0HD$HHD$pHD$PHHH+HHHIH~1@ f     f)HH;}$   H$@  LHL$8_ Ic_(W$   Ht3 HgHH$   H$   H$   ($   H$@  H$@  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$@  LHL$8 Ic_(W$   Ht3	 HfHH$   H$   H$   ($   H$  H$  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$  LHL$8蟿 EDt$4D$   5? I      @      $  D;  AA( ~GIL$   fff     H$   M((z  HA;w(|I      L$   HT$8IJHH$   HH$   HPH$   HHH$   HL$8i H$@  裇H$  H$(  H$P  H$0  LL$pL$@  H$   H$(   H$@  H$@  軅HXH$@  xHtH$   HH$@  HPILL$xLD$pI;sNHcA$@  H$@  I#I;u'H1 HD$(LLD$pH H
 QFHL$  H$   H$   H$   H$@  H$  H$H  HD$1H$P  H$   H$X  L$   IHH+HHHIH~/fD  (fAX)HH;}L$  H$   MH$@  T AA( c  MfD  MM?  MYICH   A   IHT$`IHL$XHD$pBH$   BYXIRHT$`IHL$XHD$pBH$   BYDXIHT$`IHL$XH$   BDHD$pBYXIRHT$`IHL$XHD$pBH$   BYDXIIM;M;<IHT$`IHL$XH$   BHD$pBYXIM;~IA;_(ADl$4H$  !H$  # 
E3Dl$4WL$   H$   H$   fn($   H$   H$  H$  HD$8H$   HD$@HD$1HD$HH$   HD$PL$   IHH+HHHIH~/(f(f^)HH;}$   H$  HL$8V $   HL$XH$   HD$`H$   H$   HT$8H$   HT$@HT$1HT$HHT$XHT$PLD$hLIHH+HHHIH~2 (f(f^)HH;}$   H$   HL$8 IIwHT$XL\$`HD$hH$   L$   H$   L$   I;IMLL$@  I   I@H$   LfIMkIL6OLHMIHHH$   fD  (A^XKIII(^DXDDKK(^DXDDJ6I(^DK3IXDDIJ    LH    LIML;$   H$   XL$@  M;}BN   H4   IIHHIHM+(^X  HIIuH$   H$   蔉HT$XH$   rH$   ے H$   ̒ HL$p HL$X H$    H$h  H3- ($  ($p  HĐ  A_A^A]A\_^[H   HD$ HH$     HHL$(  H
 HL$(臵 @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@q  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQH g HC(HCH;CuHHCHC H0[@SH H@  Hˍ HC`H [HL$SH0HD$ HD$P    EtH HAPH HA`D$P   J   Hk HH9 HC(HCPHcHH HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHHN HHQ3HHBHO Hō HHGHFHG HF H^(H\$HHʔ HHO0HKHtHPHG8HCHG@HCGHC H| HH HHH\$PHt$XH0_H\$WH HH HHQ3HHHKHB H HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tH& Ht
HZHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@  IFL\$`I[(HEIF HE HIk0IA^_^@SH H~ HHH} HAhHIH@ HK86 HK , HK" HK HH [@SH H; HHH HA`HIH HK8֍ HK ̍ HK H HH [@SH HCz HHH| HAhHIH HK8v HK l HKb H HH [@SH H HHH6 HA`HIH  HK8 HK  HK H+ HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3©HW(HK(HA   HA    HyrHH  IE3苩HH\$HH0_@SH H  H HCPH [HL$SH0HD$ HD$P    EtHnx HA@H{ HAPD$P   J   H| HH HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH> HHQ3HHBHK H~ HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H{ HHy HHH\$PHt$XH0_H\$WH H<:  HE HG`t
h   H觢 HH\$0H _@WH0HD$ H\$@HHv HH HA(HI0HtHP tHC0    H HHK @t
P   H( HH\$@H0_H\$WH H  H HGPt
X   H HH\$0H _@WH0HD$ H\$@HHz HH> HAHI HtHP tHC     HX HHK3 @t
@   Hh HH\$@H0_LH   ICAC    HQHu ICH ICAC   IK{Hy HD$(H HD$@HD$hHcHH} HDhHD$hHcHDd    H
 HL$( @SH0HD$ HٹX   | HD$@HSHC  HHtH@@HcHHB@HH0[@SH0HD$ HHy HH5 HAHA@HcPH} HD
@HA@HcPDBDD
<Hy HH HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HHx HH5 HAHI HtHP tHC     HO HHKH0[H%$ HVWAVH`H@HXHhH&C
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHKi HD$(f HHL$ 9tHB    HL$ OHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
t H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHB  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HA  HL$8eHL$(HtHPHtL    HA2HL$XH3 L\$`I[(Ik0IA^_^HVWAVH`H@HXHhH&A
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK d HD$(a HHL$ 4tHA    HL$ MHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
r H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHA  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2H@  HL$8cHL$(HtHPHtL    HA2HL$XH3  L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH>  (HHp HH_(H    H
 HHH
 H;
 rHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HH
 HHH
 H;q
 rHHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   DW   ^   ,A;ALǉ   LCHSHH  gtUHH?        ^,A;ALǉ   YS%     H   H   HH\$PHl$`Ht$hH0A_A^_@SH H} HHHs H   Hp  J~ H`  =~ H  )^H HH(y HC`HKH~ HK8~ HK } HK} Hv HH [Wf/v(      ^   ,;L   H\$WH HHH   HXH   HXH   HH\$0H _XHHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J=  HSHH_HG`LGpHHO`P8LHHO`HHL$@Ls(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;v# \(7 (=z! f/vNHOx#f/v?HD$@H;t5HKHT$HuD$hC(HKHT$X\HK0HT$pN]s(HHO`Y  X   w0H~ I$I\$H$   HOWGHHHGHCHWHGLL+tO W5+ At$A|$ HL$p;{ HL$X0{ HL$H%{ IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   R   ^   ,A;ALǉ   LCHSHH  [tUHH@I        ^,A;ALǉ   Y  4    H   H   HH\$PHl$`Ht$hH0A_A^_@SH Hs HHH H   Hx  y Hh  y H   YH2f HHh HChHKHry HK8hy HK ^y HKTy H}q HH [Wf/v(      ^   ,;L   H\$WH HHH   H1TH   H"TH   HH\$0H _	THUSVWATAUAVAWHhH(  HE)p)xD)@Hb4
 H3HEMILH3t$8F  HSHPH_HGhLGxHHOhP8MHHOhHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PD DD$XLD$`HL$pLD$xHEHEHT$@HM   HE XC(D$0HHD$0H#H      H;v \(R (= f/vLH   ;f/v:HEH;t1HKHUEC(HKHUxHK0HUk]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM:  HE XC(   w0Hy IE I]H\$0HOCBHHHGHCHWHGLL+t; W5x& AuA} HM*v HM v HMv IHMH3蟆 L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   MLGHWHH  }]t8HH6     Y _    H   H   HH\$PHl$`H0A^_^@SH Hkm HHHr H   Hx  t Hh  t H   THp HHo HC`HKHt HK8t HK t HKt Hl HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(c(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_bH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@@ HL$0r L$   HHH$   ($   HĠ   _Hl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]X ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3q H=HHkHF@HD$hHFHD$xHv H;t'H;tHq Ht
Hw=HH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@ HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Y8 H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWY H   H	H H$   HD$@H$   H$   H$   H$   < Y H   Wf/v f/v   Wf/v   H\$WH HH4  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHwJfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HkHSHt
HHH
HB$H;Cu
   H?HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HJ$H;Cu
   H趀HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HVHSHt
HHH
HB$H;Ku
   H*HCHt0HH   HCH;s;HH;w3H+HH;Cu
   HHSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    ,  HSIkI^IF`MFpHIN`P8MHIN`&HHMHUH   HUHM0HUH   IF`LHUIN`P(HM7HE HMHM(HULL+tH HM7HEHMHMHULL+t	H IN(h7HD$xIN(HMIV LL+t	Hb EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      D; D D%a D- H}WD$hHt3j H6HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM蒏 DUINxBfA/  HEH;   HcuH;st$HKi tH5HCHC    Hs~LEN    HUHK EC(Hcu H;s t$HKi tHq5HCHC    Hs ~LE N    HUHK^ HcuHH;s8t$HK0Si tH5HC0HC0    Hs8~LEN    HUHK0 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I.  HEH;  HSHM'C(EHSHMHM   H   H;t=HKH      C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I-  H   H;t=HSH   CC(   HSH   &H   HS0@  A   uf/w(\y (INxsf/v=H   HM8   EXH   HMHH   HM`f/v\(X(\((XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHM=# HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$he A   A9   HL$he Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0W5 IV(HHL$xd HMd HM d HMd H   d H   d H   d HM`d HMHd HM8zd H   ld H   _d H   Rd HMGd HM=d HM3d HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   ;LGHWHH   Dt8HH^2     Y	 o    H   H   HH\$PHl$`H0A^_^@SH Hi HHHh H   H  b Hp  b H(  BH
S HHR HChHKHb HK8b HK b HKb HZ HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=	 H(&Q(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_PH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@P HL$0
a L$   HHH$   ($   HĠ   _ʻHWH   H@HXHhHp )pIHHz W@Ht3` Hf,HD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrB  H$   H$   HD$8HD$(HD$@HMHT$8T HL$H` HL$(` L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3_ Hb+HHoIvHH;t'H;tHl_ Ht
H7+HHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   " HIFHD$pHD$x   INHIF@H$   H$    D$0HT$ LL$pL$   IVP HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   Y H$   \(t$pHĀ   _   LH   H
 H3H$   HB LB\ IKICH@D$@ICISISMCMCIC  HD$h H$   H3m HĘ   Wf/v f/v   Wf/v   H\$WH HH+0  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HH7fn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HnHSHt
HHH
HB$H;Cu
   HnHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HbnHSHt
HHH
HJ$H;Cu
   H6nHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HmHSHt
HHH
HB$H;Ku
   HmHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HgmHSHt
HHH
HB&H;Cu
   H;mHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w(  HSII^IFhMFxHINhP8MHINh覴HHM:HUH   )HUHM0HUH   
IFhLHUINhP(HM=%HE HMHM(HULL+tH8 HM%HEHMHMHULL+t	H IN($HD$xIN(HMIV LL+t	H EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      D  DZ D% D-X  H}WD$hHt3^X H.$HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM} DUI   迱fA/  HEH;   HcuH;st$HK{W tHG#HCHC    Hs~LEN    HUHK4 EC(Hcu H;s t$HK"W tH"HCHC    Hs ~LE N    HUHKۭ HcuHH;s8t$HK0V tH"HC0HC0    Hs8~LEN    HUHK0艭 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I*  HEH;  HSHM褷C(EHSHM荷HM   H   H;t=HKH   h   C(HKH   KHK0H   ;Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I)  H   H;t=HSH   C(   HSH   裶H   HS0蓶@  A   uf/w!(\ (I   f/v=H   HM8G   EXH   HMH*H   HM`f/v\(8X(\(#(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$h$S A   A9   HL$hS Hx  D$`A   fn}^HE0H;t1HKHU8REXC(HKHUH;HK0HU`.s(HINhXA   AV0W IV(HDHL$x`R HMUR HM JR HM?R H   1R H   $R H   R HM`R HMHR HM8Q H   Q H   Q H   Q HMQ HMQ HMQ HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQHW ICHM ICAC   IKHr HD$(HxT HD$PHD$xHcHH[H HDxHD$xHcHDt    Hv	 HL$(2t @SH0HD$ Hٹh   d HD$@HSH-  HHtH@PHcHHBPHH0[@SH0HD$ HHq HHS HA(HAPHcPHG HD
PHAPHcPDBDD
LH< HHT HA(HI0HtHP tHC0    HX HHKH0[H%O @SH0HD$ HHO< HHUT HA(HI0HtHP tHC0    HoX HHKH0[H%DO HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  D1 fA/  HGPLG`HHOPP8MHHOP赩H(HGHLd$ _xLGPHHOHHתEPHHEPH#H      D H;vA(\ z D(ȃ   f/GLcD
 D  HD$pH;t2HKHT$x訯EC(HKHU葯HK0HU脯HGPLG`HHOPP8MHHOPèHsHt$8H~ u(HHD$PHD$0HD$`HL$H* (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$HM* AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$x:EC(HKHU#HK0HU   HbU HD$03HD$8HD$@H2 HD$HD$PHT$8HL$HK HK HD$0H	 HL$0o HU HD$03HD$8HD$@H HD$HD$PHT$8HL$HQK HrK HD$0H	 HL$0:o HMK HMK HL$xK L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PH7 HA@HG HAPD$P   H< HHOHB HHG@HcPHD HD:@HG@HcPDBDD:<HSHHD!HH\$HHt$XH0_H(D ?T f/ w*f !T f/ w H
 H(H H
F a2 H H
2 M2 H(
l  T@ f/p w2
  T f/J wH
 H(He x3  HX k3  HL$H(w LD$0HT$8@T f/ viJ  "    LD$0HT$8T f/ v5J  "    LD$0HT$8TQ f/ vJ  "   H=
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H8H_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH)HSHt7HHH
HCH\$0H _H;CuH)HKHtHHHCH\$0H _H\$WH H\t
  H_ HH\$0H _H\$WH Hh HHHB HA`HIHzG HO8pG HO fG HO\G H? Ht
   HP_ HH\$0H _H\$WH H<t
  H_ HH\$0H _H\$WH H3 HHH6 HAhHIHF HO8F HO F HOF H> Ht
   H^ HH\$0H _H\$WH HLt
  HR^ HH\$0H _H\$WH HWB HHHA HA`HIHE HO8E HO E HOE H> Ht
   H] HH\$0H _H\$WH H|t
  H] HH\$0H _H\$WH H5 HHH4 HAhHIH:E HO80E HO &E HOE HE= Ht
   H] HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PH31 HA@H@A HAPD$P   Ho5 HHOHJ HHG@HcPHg9 HD:@HG@HcPDBDD:<HSHHD~HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt3A H[
HEH]WEHt3fA H6
HEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軼(HM? HM? (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9Hx蝙Y- \ Y   X Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`f   EWfA.z  D
 fA/  HG`LGpHHO`P8MHHO`ws(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      D H;vA(\.  D(   f/GHcD% HD$`H;t3HKHT$hREC(HKHT$x:HK0HU-HG`LGpHHO`P8MHHO`ls(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$h(EC(HKHT$xHK0HU   HOE HD$H3HD$PHD$XH HD$8D$@HT$PHL$8; H; HD$HH	 HL$H~_ HD HD$H3HD$PHD$XH HD$8D$@HT$PHL$8>; H_; HD$HH	 HL$H'_ HM; HL$x; HL$h; L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pH%	 H3H$P  HHHL$0b)   H HL$@蘐H(49 H$0  HL$0'LHHAPH$H  HrUHH$0  H=   r<t; HAH;rw; H+Hsg; H'vZ; HyR H$   K'H$   M9 H$P  H3J H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\άH(  X \(赬XH(   Wf/vH0   X2 (ڏ H0  X  H;t/HSHN/HC(HF(HSHNHS0HN0
LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h7 HHEHsH   HCH;t'H;tH7 Ht
H\HH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h[  H       D  HY(WEHt36 HHEH] = } H  H[WEHt36 HgHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hW[    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt375 HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMY H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(̧(Xu \蹧(XuuHUH(  HٓEf/w"\ۊ (H   Hx΍f/vHE0H;tHU0H3WEH]HHt33 HOLHEH]LEHuHEHEHEHEH;t-ID3 HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHMK LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   &HM1 HM1 HM`1 HMH1 HM81 HM1 HM1 L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9H]Y \ Y   X Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH	 H3HELHHyHHL$@#   EWfA.z\  D
 fA/H  HFhLFxHHNhP8MHHNh4w(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      D< H;vA(D\ ׆ (   fD/GLcDj fHD$@H;t5HOHT$HD$hG(HOHT$XHO0HT$pHFhLFxHHNhP8MHHNh LGI@H_@HEDELEH]LEHEHEHUHM虞  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM;  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H{D$hG(HOHT$XbHO0HT$pT   H6 HE3HEHEHsz HD$0D$8HUHL$0, H- HEHH	 HMP HO6 HE3HEHEHy HD$0D$8HUHL$0, H, HEH	 HMP HL$p- HL$X- HL$H- HMH3= L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pH	 H3H$P  HHHL$0   HRt HL$@H(* H$0  HL$0LHHAPH$H  HrUHH$0  H=   r<t, HAH;r, H+Hs, H'v, HC H$   H$   * H$P  H3=< H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\.H(  X \(XH(   Wf/vH0   X (: H0  X  H;t/HSHN菋HC(HF(HSHNzHS0HN0mLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hB  HMHLHT$hP(HH   HHHHPHKHHHSHL$h) HHEHsH   HCH;t'H;tH( Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h軖  H       D  HY(WEHt34( HHEH] =D } H  H[WEHt3' HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hL    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0I}H  L@LEWEMt3& HMfHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMWK H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(,(Xu \(XuuHUH(  H9Ef/w"\;| (H   H.f/vHE0H;tHU0HWEH]HHt3$ HLHEH]LEHuHEHEHEHEH;t-I$ HtHoLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM諤 LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM_  LML   H   H   HML# HMA# HM`6# HMH,# HM8"# HM# HM# L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH3) HAPH0 HA`D$P   HD HHO(H% HHGPHcPH HD:PHGPHcPDBDD:LHS(HHD\HH\$HHt$XH0_HL$HH LL$P)t$0LD$X3)|$ t5 =< Tf/   o LL$PLD$X3>Tf/   ) LL$PLD$X3Tf/   ; LL$PLD$X3Tf/   e LL$PLD$X3̽Tf/   W LL$PLD$X3覽Tf/ws(t$0(|$ HHHl H
 [  H{l H
Z  Hgl H
Z  HSl H
Z  H?l H
Z  H+l H
Z  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	H  Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@  IVHO   L\$`HI[Is I{(IA^H\$WH H HHA`HIHt HO8j HO ` HOV H Ht
   HJ7 HH\$0H _H\$WH Hg HHAhHIH HO8 HO  HO H Ht
   H6 HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	 Ht
HLHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@I  H\$xHH$   H`_@SH0HD$     HHd  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH Ht
HHL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ Պ  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8"z (fo IHFHMEHEUHMHME0HuMH] E H](M@fo
 fEPU`Mp  Xf/FvFHHI;L$8  IHN 踔  ID~DHN0LN@HLF0A   HV 
  H$@  FDHAD~HH   A_A^_^]sH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _
 HH
 HH}
 H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMH+ HHEHE   HE    E A   HS HM5HE0   HE(    E ; uE3IIB< uHHMI5HEP   HEH    E8 A   H߼ HM853fff     H}H;   H+H   HHuH}HCuHH   LǺ%   H& HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
$= A   HHM"0H)IE3HUHM88A   Ht HM8o7IHMXө  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H HH    :} uC:r uC:g u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM.IIE3HUHM87HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H H HD$0HT$0HM% HHL$`w HP	 HL$`9 HUAVAWHhH@  HD$XHXHpHx H	 H3HE8L= HLEHE   E3LuDuEF"HS HM1HE0   Lu(DuEFH HM1A@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH    :} uC:r uC:g uAtH+HHHsHEH}HCEH+Ht+HD$    L
9 A   HHM,H(IE3HUHM5A   H HM4A? tI@ IC<7 uMIHM3HEH}0HCEH
Z HL$03HL$8HL$@HD$HD$PHT$8HL$H H HD$0HT$0HM] HHL$` H	 HL$`t7 @SH0W)t$ f/Ȼ   (vW5 (j 5 (,t
Xʃ\
(\(f/
{ v\(Y
z (j fnY(t$ YH0[Hx)t$`(Ķ f/)|$PWD)D$@D(D)L$0D(v(Hj W[   fD.z  f.zv  D)T$ D fA/L  D
 fA/r4D ff     AX(i fA/XsD(E\~
 eH%X      HЋ9z
   X5ط A(AYAY((Y<
 (Y9
 Y
 X
 X
 X
q
 YYYXݖ
 Xݖ
 X
=
 AYYYX
 X

 X(Y)
 AYX
 YX
 YXX
А
 ^YY5@ X  D fD/v(h E(\D(AX}
 eH%X    f/ƹ   HЋ   9C
 h  A(A(AYAY((Y
 (Y
 Y
J
 Xʗ
 Xʗ
 X
"
 YYYX
 X
 X
 AYYYXi
 X
 X(Yښ
 X
 YX
 AYX^YY%] X   9
 )  EYDW A(AY((Y\
 (YI
 Y
9
 X1
 X!
 X

 YYYX
 X
 AYYX(Y
 X
 Xŕ
 X
 YX
 AYX^AYDY
^ AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
^
 ! =R
 ( H
>
 (
 
 ( 
  
 (߹ 
ؓ
 (
 )*
 (C )

 (
% ).
 )

 ! UH
Μ
 ]! =
 ( H
 (
߿ P
 (q b
 B b
 (c 
4
 (
 
 ~ 
g
 (
H 
 
q
 p  H
T
   =H
 (o H
4
 (
 
 (ö 
 ( 
 (
G ȇ
 X 
 (
* ʇ
 
  IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
ǲ A(.  pd f.zu2   !     ' f/   (LWP Hh((Y(T
 fD/vlY
H  f/vVfA.zu3(H       $   H$      E
 fn "   Y S  l ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ 9c f.(   u~Ҳ f/vpH      $   H$   H#H;  fA/s(b (f/   
ų f/  ,HH Y<Z  < f/v:Ʈ f/vZ =Ҳ  "   D^D\
^ AY  H$   W}D D(DX
 YE\A(5b 
 Yf/   AYf/wBAYA(\5 (b (A(a ) (^^Yf/vvfA.zu3*H       $   H$      EË_ fn "   Yɱ (A\A((xa (A(Ta ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   HU H
G s L$   HU H
3W s H\$D$WH`)t$PI)|$@H(D)D$0 f/ro(` f.z  (m(Wf/ WvW3 l` D(E3(LHqD\(J` D\  ʬ f/vfWf.z0  % (
: Tf/v` D(DW    + ^\ǭ T_ D(   N f/v$((\B \
 (
  D(of/=L r!* f/v(d  u_ D(DHL$p/{`_ D((X \ D_ \~ \= YDXH\$xA(D(D$0(t$P(|$@H`_LD$pH H
k   LD$pH H
R   H(YĬ LL$0LD$83#(T
 f/
 w
YO H(HS H
tA o  H(Yd LL$0LD$8ã(T
Y f/
 w
Y H(HR H
4A   H\$D$WH`)t$PI)|$@HD)D$0(D& D)L$ A(EWfD/   ] f.zZ   f/ru(LW H((fY(T
 fD/vY
 ) f/  ' ^fA.    A(  fD/v ff     ^AXfD/wt$p(] f.(   u~ f/vpH      $   H$   H#H;  fA/s(\ (f/Ԭ   
 f/x  ,H Y<    f/v* f/Z  D^D\7 AY   HL$p3wD
 D(DXe YE\A(\ 
۫ Yf/vVAYf/  AYA(\5i ([ (A([  (^^Yf/v&   A\A(([ (A([ ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pH6 H
o R  H H
[   LD$pHO H
A m LD$pHO H
AQ m HlA H
   H H
   H H
   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3S H#HD$(Hl$0HT$(H茝  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"H Ht
HHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H Ht
HHH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;tYHtHHHH;tYHHHHGH;t"Hy  Ht
HDHH    H_H_HHL$8 HL$(?  H$   H`A_A^A]A\_^]@SH Hby  HH [@SH0HD$     zx  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH9 HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIM7MwMwLuIHHWD$@HD$P    E3E3HT$@HJL\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uHHHF)L;t$HV! HHVHҧH~H$`  H$P  HHHI$I$H;uIT$H;uHWI$ID$'H;t"LIT$! HIT$H*I\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W- 3MtlA(Y5 (Y= D(D\D
 DY HfE/v((+ AYA((XI IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  bLLD$XHT$pHHH
L;   IH   IWMIOI+H*HHHH?HH;v HRHH=   r=At I@I;rp L+Is` I'vS LIo I?IIHIHCIGHCIGH;H{H{HL$pH   HT$xH$   LD$pI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'v LI H$   HtwH$   H+HH?H;vE H    H=   r<t) HAH;r H+Hs	 H'v H HL$XHttHD$hH+HHH;v H    H=   r<t HAH;r H+Hs H'v~ H H   HT$HH6HD$PH+HHH;v= HH=   r=@t$ HEH;r H+Hs H'v HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWATAUAVAWH  HǀpHXHp)p)xD)@D)HHL5 EWE(W8HǀH    HPLXHǀ`    Hǀh    H
HBH+HHucH HD$p3HD$xH$   Hk4 H$   Ƅ$   HT$xH$   @ Ha HD$pH3 HL$p3HǄ$H     $   HBH+HHwcHy  HD$p3HD$xH$   H3 H$   Ƅ$   HT$xH$    H HD$pHp3 HL$p   H$H  AD$hW$   E3L$   McgxIMt*M;v
H
/ 1 IH$   /L$   E3H$   L$   fD  M;  HFH+HH;rcHx HD$p3HD$xH$   H2 H$   Ƅ$   HT$xH$    H HD$pHo2 HL$p西HHH$H  H<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
.  HM+IIHIH+IE3I;LCL;ICH$   t.L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
8. r HM+IIHIH+IE3I;LCL;ICH$   -L$   H$   L$   Ht:HH$   IH$8  DXK AX$   WD$pE3AL$   IcG,H$   Ht/I;v
H
m-  HHL$p:-H$   H$   MH\$xHt$pL;  H$8  (D$`HD$`H;   HD$`H;   Lt$`L+IH;uwHH+HHsgH+HIH+Hs
H
,  HSH+HHHIH+HE3H;LCL;ICHL$pl,H$   H\$xHt$pHt8JH/H;u!   HL$pH$   H\$xHt$pHt;HH\$xIH$   i
 |   I(DH H
+  cHcH$   E3AL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rh
 }   DH H
 ?bHcH$  IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;rh
 ~   EG,H' H
) aIcW,H$   MIL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r]g
    EG,H&' H
( `IcW,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rA   uof
    IGxI   I   MG0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  )HH$      f
    IGxI   I   MGHMO0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  ȌHH$   wH$8  HtL$H  L+IA   L-%      E;g,W  de
    IcLL+ILl$(D$    DE]M   M+   IH
B% HL$(D$    D]I   tYtL$   L+$   IH
o& HL$(D$    Dv]H$   td
    Ll$(D$    DEF]M   M+   IH
$ HL$(D$    D]I   tYtL$   L+$   IH
% HL$(D$    D\H$   tA   L- = A;(|  c
    HcL$   L+$   IH
U% HL$(D$    Dd\L$   L# HI   ֐HH$   H+$   HLNL+IHD$0Ll$(L' H
$ LFL+IH$   H,^(L.# HI   cHH$   H+$   HLNL+IHD$0Ll$(L H
 $LFL+IH$   H]XAYtXL$  L+$  IH
 HL$(D$    D:[H$  tzE3AAO(;}A;}AAO,;}AD  ;}6b
    Ǆ$      Dt$`L$   HT$`H$   ԍ  $   H$   H$   a
    D$`   D$   LD$`H$   HL$h腍  D$hHT$hH$   }a
    Dt$`M   HT$`H$   蕎  D$hHT$hH$   =[a
     D$hDt$`LD$hHT$`H$   i  D$hHT$hH$   a
    Dt$`M   HT$`HL$p茑  D$hHT$hH$   `
    IO`L$   H$  a  $   H$   H$   sH$   Ht(L$   L+IW$   L$   H$   Ht(L$   L+ILW$   L$   H$  Ht(L$  L+IW$  L$  H$   Ht(L$   L+IW$   L$   HT$pHtL$   L+IH$   HtL$   L+ID$   H$   H$   >H$   W  (H$   HtL$0  L+I=(L$  I[8Is@A(sA({E(CE(KIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHFHVH+HL$   I
3HFH+HH   $   D(DXL%HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;v H    H=   r<t HAH;r H+Hs H'v H L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHL(W$   LKL+IL$   IIGMH$   HD$ MH$   IbHSH+HHL$PWD$8HD$H    LCHHL$8,3HKH+HHT$8H  L5 HIL43 HBX LL$PMHT$8I3HCH+HHl$PHtvMH3  YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8LH -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;vV H    H=   r<t: HBH;r* H+Hs H'v
 HH) HtmHD$`H+HH;v H    H=   r=@t HEH;r H+Hs H'v HH (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  H@	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
  HQM+IIHL+IHM;HCH;HCHL$@BHL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
 B HQM+IIHL+IHM;HCH;HCHL$@HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   LFLL$`I{`  H$  H$   HXH$  DHtINHH$   PHt$hH\$`H~&Hfff     HHL$@bHcH;|IHHT$@PH$  H$   H!H$  H$   HL$` HT$@HtLD$PL+IH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HiI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KM  IIL$   H$   H$   L$   WD$xHt3 H聪HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JL  HB H$   H$   譩H$   H$   H$   HT$xLL+t
H4 HT$xW$   H H$   LMH$   H$   H$   kLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IB +fDnED^ Aƅ    A   3 A   H$   kH$   I蹯IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI!s +fn^5 L$   (A(5mL$   (A(!m(A(H$   qH H$   H$     H$P  H3
 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HYI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  ;H  II萚L$   H$   H$   L$   WD$xHt3 HqHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   :G  H2 H$   H$   蝤H$   H$   H$   HT$xLL+t
H/ HT$xW$   H~ H$   LMH$   H$   H$   eLMHH$   0 D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^~ Aƅ    A   . A   H$   	fH$   I	IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIc +fn^5} L$   (A(%hL$   (A(h(A(H$   lH H$   H$   w  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I~ Ht
HII3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  +C  IIL$   H$   H$   L$   WD$xHt3 HaHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   *B  H" H$   H$   荟H$   H$   H$   HT$xLL+t
H{* HT$xW$   Hn H$   LMH$   蛿H$   H$   `LMHH$     D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I" +fDnED^y Aƅ    A   ) A   H$   `H$   I虥IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIS +fn^5x L$   (A(cL$   (A(c(A(H$   gH H$   H$   g  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"In Ht
H9I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  >  IIpL$   H$   H$   L$   WD$xHt3 HQHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   =  H H$   H$   }H$   H$   H$   HT$xLL+t
Hk% HT$xW$   H^ H$   LMH$   苺H$   H$   [LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^}t Aƅ    A   y$ A   H$   [H$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIC +fn^5s L$   (A(^L$   (A(](A(H$   bH H$   H$   W  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
  HHHCHHHHKLHT$`HL$X[  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
	 C HHHGHHH_LHT$`HL$X  HGH\$hH@_@SH0HD$     ?  HH0[HWATAUAVAWHp  HǀHXHp)pHW	 H3H$P  MLD$XHH$   H$  H$   L$  D$0    HW
 HHHW
 H;W
 r
   HHL$8Ht
\q o!H3D$8   EE HP H
jP 9IcU HL$h[3LD$pIHL$hH+HHt HHLD$pIHL$hH+HH;r3L+IMtHHHD$pHL$hH+HH;rD$8   EE AH}z H
O 19AE HcHL$@辏E3HT$HHHL$@H+HHt!JIHT$HHHL$@H+HL;rE3HH+HHt.@ ff     JIHT$HHHL$@H+HL;rD$8    H+HHO HD$(D$    A   D7HHD$@H   H5N H
EO A;]    D$8"   HcMD$M+$IHL$(D$    D:7I$L<LD$HL+D$@IHt$(D$    D7HD$@L4HcLD$HL+IHN HD$(D$    D6H|$@MGIVH$   (H HD3HD$X   5l H HD$XA;M   D$8(   DyIcH|$HHT$@H+H  G;  HLHcكw  G;l  HHL$   I6I~H+H  G;  H|$pLt$hI+H  G;  H$   *L(H$   U,HLD$XLH$   :,LHH$   -H IDD$8)   H|$pHL$hH+H|&G;}LAMHT$XHL$`3'AH H$   He H$   H$X  / D$0    E3H$   H$    H$   HcHH H   H$   HcHh   H$   H$   H$   : H H$   3H$@  $H  H H$      H H$  H$   L$  H$  LC$  H4M HD$ DËQ1H H$  H: H$  H$X   D$0   E3H$  H$   H$  HcHH H  H$  HcHh  H$  HD$`H$   H H$  3H$@  $H  H H$     Ho H$  H$  躰L$  H$  LC$  HK HD$ DË)0H H$  H H$  H$X   D$0   E3H$  H$   H$  HcHHv H  H$  HcHh  H$  HD$`H$   Hz H$  3H$@  $H  H H$     HG H$  H$  蒯L$  H$  LC$  Ht HD$ DË/Hi H$  H H$  H$X   D$0   E3H$  H$  r H$  HcHHN H  H$  HcHh  H$  HD$`H$  ¾ HR H$  3H$@  $H  H H$  m   H H$  H$  jL$  H$(  LC$  HH HD$ DË-HA H$  H H$  H$X   D$0   E3H$  H$  J H$  HcHH& H  H$  HcHh  H$  HD$`H$   H* H$  3H$@  $H  HZ H$  E   H H$0  H$  BL$0  H$H  LC$0  HG HD$ DË,D$8+   HT$hH$   HHT$@Ht!LD$PL+IWD$@3HD$PHT$hHtLD$xL+I|HH$P  H3y L$p  I[8Is@A(sIA_A^A]A\_@SH`HD$XMHH
AD$0HD$0II#I      I;v#H HD$ LHp H
p fAnT$0HD$0I#I;u'H HD$ L
 Hp H
p 臬A*H HD$ L
T MHp H
sp VWd$8LD$8LD$@HT$Hfnd ^I\Y(YYec (\Y\d$8HHL$8k2  HH`[@SUVWATAVAWH   HD$8)$   )|$pIMHLLBH
IH+H  W(3DHI      HtZ    J@D$0HD$0I#I;tIIH+HL;r#HY HD$(LHo H
o   fAnD$0HD$0I#H
o I;u#H HD$ L
 MHo تE f/w#H HD$ L
 LHo :hD$0HD$0I#I;u#H HD$ L
k LHQo hLLHvo qHwH+7HA   I;IFHHL$@(b ^] HHt~LA%l     HcIQfAn\(T(Y\f.zuAf/AGfnYHL$@\HH;r(IHL$@x.  HL$@ GHI
 HHHI
 H;I
 r
   HHL$0Ht
W]H3II($   (|$pHĐ   A_A^A\_^][@SH`HD$XMHH
AD$0HD$0II#I      I;v#H HD$ LHm H
m ڴfAnT$0HD$0I#I;u'H HD$ L
r Hm H
m wAWf/w*Hi HD$ L
= MHm H
dm ed$8HD$8HD$@HT$H	` ^I\Y(YYY_ (\Y\d$8HHL$8_.  HH`[HVWATAVAWH   HD$@HXHh)pIMLLHBH+H  Iy   WL  fAn$$   H      H$   H#H;u*Hb HD$ L
 MHl H
l  3DHOHt>HIcf/v
IL;r#H HD$(LHl H
yl 4gH|$0Me  IHL$`$InI+.H   H;HFHWH;HFHL$HHHt$HH9_v&H
Z^ fHc(^HH;OrHtcI]     HcHIfAn$\Y(YY\YHD$`\HH;r(IHL$`*  HtLD$XL+IHHL$`A JHE
 HHHE
 H;E
 r
   HH$   Ht
WH3IIL$   I[0Ik@A(sIA_A^A\_^HSUVWATAUAVAWH   HD$H)p)xMMLHLZHML+I  IXILL+Ir  W3DIH      MtdIff     BD$0HD$0I#H;wIIH+HL;r#Hl HD$(MHj H
j   LIMtW@ J@D$0HD$0H#H;tIHH+HL;r#H9 HD$(MHJj H
#j   I$@f/w#H HD$ MH0j H
i H|$@LD$0LT$8HD$0HL$8M;HCHLMH+j H
i 蟟LMHi H
i 膟IHL$XI!t$xHD$xH$   L$   I/I_H+HM>IFI+HH;HFظ   H;HFI$@=Z ^ (Htr%MZ D  HcT I\PY(Y\(Y\(YHD$XX(Y\H$   XHH;r(HHL$P%  HL$X GHB
 HHHxB
 H;iB
 r
   HHL$@Ht
W@H3H>H($   ($   H   A_A^A]A\_^][LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHwHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHHH|$`HHH0_^[H\$Ht$WH I-  HHX f@  Ht4HH3HC   Hs@3KHs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	A_  IB  H1H;>u=IP I腑  H$   HD$(LAII_  I  H;uAH^HK I?  H$   HD$(LE3IIf_  I  IP I   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I臐tCHCIIπx H$   HD$(tLE3^  I   LA^  I   IHO 1   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS It=HGIIπx H$   HD$(tLE3]  I6LA]  I&H$   HD$ MHT$8I`  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I*  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3HKHs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aaa  IB  H1H;>u=IP I%  H$   HD$(LAIIa  I  H;uAH^HK Iߍ  H$   HD$(LE3II`  I  IP I袍   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I'tCHCIIπx H$   HD$(tLE3`  I   LA`  I   IHO ь   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS Iat=HGIIπx H$   HD$(tLE3R_  I6LAB_  I&H$   HD$ MHT$8Ia  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HHH H|$`H HH\$XH0A^_^@WH0HD$ H\$XH&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@WH0HD$ H\$XHd&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS= HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSHg HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH7 HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     JwHH0[L$D$HXH      )t$@D$x(HD$xH#)|$0(H;t`D$xHHD$xH#H;woWf/   L$`HD$`H#H;   I
  Y(t$@X(|$0HXHL L

 HD$ LD$`H H
 RH L
 HD$ LD$`H H
 lRH L
 HD$ LD$hH H
] @RH L
 HD$ LD$hH` H
1 RHHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(DV A\D)xD)hD)XD)H(D)8ATD   f/  L   WDK D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXYK ^A(\AY(Y\ fE/(vWU (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y5uI A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"H Ht
HpHH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@/  H   MMH9?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"H Ht
HRoHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@  H   MMHk8L|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HE:(H   A] (YH   Xf/wXfA/sQH   (AT WnR f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$ WATAWH eH%X   HD
y
 Iع   HNB	9@.
   HHH9LH-[-
 HLL%X-
 IL=V-
 L;HLH0  HELt$@HDL   IIL;LLM;~8IHIHHuI H   IH+HHHIHH+HLLH>IHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLLt$@II;~/HIHHtIH   H+HHHL+L   M;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+LH\$HHl$PHt$XH A_A\_H
2,
 蕱 =&,
 H
M+
 H

,
  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-D)@HD> Ip     D)HI   D
= D)PD< D)XEWD)d$@D%> D)l$0D-rI D)t$ D5< )pغ   H  W4   H*AYff        H  WHH*X(AYH5rԺ   HW  WH*LcXEFLcAYB̀ BYՀ f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zBհ
 BՀ fA/BͰ
 (\\YXr*((B\̀ Y\YYX\(((B\̀ Y\YYX\fD/&fD/w(YAYAWC f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=< H%  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLL I^WD$(Ht3' HaLHD$(L|$(H\$03HcI;^}UI4H#
 HHHy#
 H;j#
 r
   HH$   Ht
(>HILD$(H$   IM   H$   HCH$   HI~I;|$t!I$g HtH2aI$I4$I|$H      ?HCH=!
 H
"
 H9
!
 t	H!
  HH+!
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|I s L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH 3H$   HH$   HH$   H H$   HLCL+H$   _ A   E3H$   HL$0 HD$0HcHHD$0HȺ    HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQDuHL$0 u2HL$0p H$   Q HL$0Q H$   2 2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H  HD$(H;wH
H\$ H;vHH+HH=   HH  H\$@Ht$HH0_@SH HHHSH
Q H3H
HJHH 3HC HC(HC0HV C8HH] HCHH [@SH0HD$     	  HH0[LL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHTHHH|$PH0_^[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$XY  HL$8(ӏ 3($   H   [HIH% H% H\$WH Hs t
h   H聧 HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    H
 LHH
 H

 H;rHLHp
 H
a
 HHH\
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH
 HH0H
 H;
 r
0   HH\$`Ht!(HtH} HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    H
 LHH
 H;
 rHLH
 HHH
 H;
 rHHH
 3LCIHI+HHt2f     I HIHLCI@I+ HH;rHW
 3H9S~-L3ff     JH9HIHcH;C|H"
 HH0H
 H;
 r
0   AHH\$`Ht!(HH| HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHHm
 LHH_
 HP
 H;r   LH?
 H0
 HHH*
 H;r
   [HHKHIHHH

 HH0H

 H;

 r
0    HH\$PHt%(HHz HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$Ht$WH0H3HRH\$ H+HeQHGH+HHt&D  HHHHHHGH+HH;rH\$@HHt$HH0_H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfo:: (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   9 II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %8 ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PHst HA@H HAPD$P   OHx HHOH HHG@HcPH| HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHÍ HAPH HA`D$P   H HHO(Hi HHGPHcPHO~ HD:PHGPHcPDBDD:LHS(HHDHH\$HHt$XH0_H\$WH HHt HHQ3HHHKHBυ H HHCHGHC H\$0HG 3HG0HG8HG@Hr GHHHw HG(HH _H\$WH HHH;Qt>H	 HtHV  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   腙 LHtHHHtHHIHHtHHIH [HL$H(+ LD$0HT$8p{TY5 f/, wU* LD$0HT$8H{T15 f/a, wA* LD$0HT$8 {T	5 f/9, w-H(H[ H
d l  HG H
P l  H3 H
< l  LVWATAWHh  Ha@	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  :7E3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XAA
X		AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ 5L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3詑 Hh  A_A\_^HWH   H@HXHhHpIIHIPHH[3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`H-Hl$PH\$HH+HH;ntH0 Ht
HKHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;v H    H=   r<t HAH;rt H+Hsd H'vW Hv HHtmHD$XH+HH;v' H    H=   r<t HCH;r H+Hs H'v HH HL$`HtiHD$pH+HH;v H    H=   r<t HAH;r H+Hst H'vg H膖 L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHt3} HIHHkHsC  IH!h  HH\$`Hl$hH0A^_^@USVWATAWH$H  Hi9	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  =, WD$ f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HEH  HE H  IH B<L;~  HH+HNHfo%$ T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
# foLu@MH  EhL  E   M  E  fo
s# f      h  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&i  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfo  IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   #  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  )2 LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@9  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3΃ H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     b  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  H-	 H3HExMH% HHEH% HHEHE   HE    E 8 uE3IIB<  uHHMVHE0   HE(    E ; uE3I IB< uHHMHEP   HEH    E8 A   H% HM83@      H}H;   H+H   HHuH}HCuHH   LǺ%   Ho HH   :
 uH:
z uH:
o u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHMH)IE3HUHM8襐A   H HM8?IHMX`  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   Hn HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM謆IIE3HUHM8_HE8H}PHCE8H
rw HL$03HL$8HL$@HD$HD$PHT$8HL$Hm Ht HD$0HT$0HM_  HHL$`G`  H  HL$`茑 @WH@  HD$(H$P  HHD$     HL$@>\   HL$0%k LD$PMcHHL$PIHPHL$Pk HHL$@jZH$   ZH$   l HH$P  H@  _Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v(X Wk   fD.z  f.zv  D)T$ D fA/L  D
 fA/r4D ff     AX( fA/XsD(E\	 eH%X      HЋ9	   X5 A(AYAY((Y	 (Y	 Y
	 X	 X	 X
	 YYYX	 X	 X
	 AYYYX`	 X
`	 X(Yy	 AYX\	 YX@	 YXX
 	 ^YY5P X  D fD/v( E(\D(AX	 eH%X    f/ƹ   HЋ   9	 h  A(A(AYAY((Y	 (Y	 Y
z	 X	 X	 X
R	 YYYX	 X	 X
	 AYYYX	 X
	 X(Y
	 X	 YX	 AYX^YY%m X   9n	 )  EYDW A(AY((Y	 (Y	 Y
	 X	 X	 X
	 YYYX	 X
e	 AYYX(Ye	 X
5	 Xe	 X=	 YX!	 AYX^AYDY
n AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
	 	| =	 (	 H
	 (
 	 ( 	  	 ( 
	 (
 )z	 (S )
\	 (
5 )~	 )
g	 { UH
	 m{ =	 ( H
	 (
 x	 ( 	 R 	 (s 
\	 (
 	  
	 (
X 	 
	 z H
8	 z =,	 ( H
	 (
 	 ( 	 ( 
	 (
W H	 h 
)	 (
: J	 
3	 y IHHh  HD$X)p)x((Wf.zu(~ Y   f.z  f.
 z0u.(W _((_YY5	 (L  f/
 rT=H (_.  (Z  HrDJ( J ȃw_HL H(+[     (~\     ((螰     (]     ($     (^     Hco HD$03HD$8HD$@H HD$HD$PHT$8HL$He H"` HD$0HT$0H$   諲  H
3 HH(H
 HH0@8B  HH$   m  HHL$`  H HL$`D ($P  ($@  Hh  Ð= J W g t  HUVATAUAVAWHxHX  Li3ILLDM  
 
B
 HXH      ?HxI)p)x=
 D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E   S  IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C莇  H;}&f        HE(f)HH;|LHMHT  LM@L  HH  HM` MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL     MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@覷  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMHa  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  xr  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH       9r @   @   H
] HHxHHH\$PH0_HT$WH0HD$ H\$PHHH       q @   @   H
S HHxHHH\$PH0_HxHD$8)t$`)|$PD)D$@9|$0HD$0II#I      I;v*Hј HD$ L
 LH H
 OfDnEDD$0HD$0I#I;u*H HD$ L
u LH[ H
 wJA 'Hp HD$ L
D H H
 IJfn5  ^ճ A\Y>	 WX\YY=_ \((t$`(|$PD(D$@Hx@SUVWAVH`HD$8)t$P)|$@ILHHHIH+HH  W3DI      HtQfff     BD$0HD$0I#I;t
IL;r#Hv HD$(LH H
 諈  fAnD$0HD$0I#I;u*H7 HD$ L
 MH H
 Hf/w*H HD$ L
 LH H
f QD$0HD$0I#I;u*HƖ HD$ L
 LHp H
) LLH H
 zDH/HH+H   H;HF=,  ^ (HtQfAn	 %
 ff     (X(\HcL \TY\HH;r(W(t$P(|$@H`A^_^][HH   H@)p)xD)@D)H9xH@II#I      I;v*H\ HD$ L
H LH H
w fDn
EDL$0HD$0I#I;u*HD HD$ L
  LHV H
/ GA EWfA/w'H HD$ L
Ɣ H7 H
 [5 ^_ A\Y
	 AX\YY= \((t$p(|$`D(D$PD(L$@HĈ   HHPHHUVWATAUAVAWH   HD$@HX)p)xMLLLYLII+H  M@M  W3DHH      HtlH@      C$   H$   H#H;wIII+HL;r#H HD$(MH? H
(   fAn$$   H$   H#H;u*Hp HD$ L
, MH H
 .ELMt@IfIcf/v
IM;r#H	 HD$(MH H
 FLt$0MHm  I_I+H   H;HFIVH;HFH$   HL$h2IVHL$P1HLl$hHl$PI9vvZM>HML+=U Hc(A^AA HH[I;~rH$   L$   L$   HtjMfAn$HIH+$	 %T @      HcA\YY(X(\1Y\HHH;rHtLD$`L+IHfMtLD$xM+IIf(WL$   I[PA(sA({IA_A^A]A\_^]@SUVWATAVAWH`HD$8)t$P)|$@MLLHHyH+HH  MINI+HH  W3DI      HtVIfD  BD$0HD$0I#I;w
IL;r#H HD$(MH H
   LHtHfCD$0HD$0I#I;t
IL;r#Hv HD$(MH H
h 諁  A$f/w*H/ HD$ L
 MHq H
2 H;HBLMH H
 =LMHW H
 =I7IH+HI.IFH+HH;HF   H;HFA$=v ^+ (HtQ	  @ f     Hc\L Y(X(\YY\HH;r(W(t$P(|$@H`A_A^A\_^][H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
` HDH H H;HBL<LH LH
/ H\$@H0_pi  @SH HALHH$I$IHH;r6H|$0H|$XHO@nHO 2Hj H
Ξ  P H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMt蚦 uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK Ij-t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN f.Hnf I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@HO -He H
 0K H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtʡ uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I(t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN )Ha I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	5H Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@IVHOKb  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ H H+H= H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/L L+L
 L+A:tA:	uHr:IuL L+L
 L+    B:tB:	uHr@-tH      < @-tH        D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;t豖HIHKH;tH~= Ht
HI	HL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMA  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHMq:    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5_  5    HG(Hx tL   LHH%\  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H- H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vّHHE HHuxL4    I   w2IFHHH;wHHH% H+HD$`HHHE 1IN8 HE HuMtcHILuXE3L9?LDL  Lx  H  H    H=     I;vHGHEHu`H    H   w2HCHHH;wHHHa H+HD$`HHHEH7 HEHuHt蟐3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX= 5W MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  IHUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  H@HHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  L  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} H#HHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  _HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t/    t	I/ H  H3@ H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    H/ HuHuH\$ H(@SH Hr	  Hk+ HCPH [HL$SH0HD$ HD$P    EtH HA@H++ HAPD$P   J   H; HH+ HCHC@HcHH) HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH6 HHQ3HHBHKL- Hm4 HH{3HHDH^H\$HHm2 HHOHKHtHPHGHCHGHCG C H) HH- HHH\$PHt$XH0_@SH H  H) HCPH [HL$SH0HD$ HD$P    EtH HA@H) HAPD$P   J   H- HH& HCHC@HcHHV# HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH~5 HHQ3HHBHK+ H2 HH{3HHDH^H\$HH0 HHOHKHtHPHGHCHGHCG C HZ! HH) HHH\$PHt$XH0_HIH%+ H\$WH H|  Hu( HGPt
X   HC HH\$0H _@WH0HD$ H\$@HH' HH.0 HAHI HtHP tHC     HH4 HHK#+ @t
@   HXC HH\$@H0_H\$WH H  H' HGPt
X   HC HH\$0H _@WH0HD$ H\$@HH  HHn/ HAHI HtHP tHC     H3 HHKc* @t
@   HB HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ$HHHFHGHHFLL+t H_H\$HHNHHHFHCHVHFLL+t HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$HT$H8IE3IPH+HHtHII      @ f     H@D$HHD$HI#I;wIHL;rH8Hc H HD$(H
 V  3HIHtH   H LH   ICAC    HQH ICH$ ICAC   IK;H( HD$(H! HD$@HD$hHcHHC HDhHD$hHcHDd    H. HL$(K @SH0HD$ HٹX   |; HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH' HH%! HAHA@HcPH HD
@HA@HcPDBDD
<H5 HH+ HAHI HtHP tHC     H/ HHKH0[H%& @SH0HD$ HH HH5+ HAHI HtHP tHC     HO/ HHKH0[H%$& LH   ICAC    HQH ICH" ICAC   IKH HD$(H # HD$@HD$hHcHH  HDhHD$hHcHDd    H HL$("I @SH0HD$ HٹX   9 HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HH HHe" HAHA@HcPH HD
@HA@HcPDBDD
<H! HH) HAHI HtHP tHC     H- HHKH0[H%$ @SH0HD$ HH  HHE) HAHI HtHP tHC     H_- HHKH0[H%4$ HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A   % H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH H HHt
   9 HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PHC
 HA@HP HAPD$P   H/! HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDZHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H HHOH HHG@HcPHw HD:@HG@HcPDBDD:<HSHHDYHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H" H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vwHHMHHumJ    H   w2HCHHH;wHHHo H+HL$`HHHM*H8 HHEHuHtJwH3H9HDHEXH   L   J    H=      M;vwLnMu_J    H   w.HCHHH;wHHH^n H+Ll$`IIH LHuHtvHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`H3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIK  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H@     t
HMX, H   H3+ H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3 HsHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xU?  HIHD$hHD$p   INIHD$xH$   - D$0HT$ LL$hLD$xIV  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v%3 HA    (|$@D(L$ H`[ HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    vG A    A   A((T T f/vOA^)t$P5 (YXo fE/
 vW^3YWs(t$PJD^A(AYX |o fD/q vW
 ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H H3HE8H HHEL= HLEHE   E3LuDuD80uE
IIF84 uHHM{3HE0   Lu(E A   H HMT3IH}H;   H+H   HHuH}HCuHH   LǺ%   Hf HH    : uC: uC: uAtH+HHHsHEH}HCEH+Ht+HD$    L
k; A   HHMa.H(IE3HUHM7A   H HM5A? tI@ IC<7 uMIHM5HEH}0HCEH
 HL$03HL$8HL$@HD$HD$PHT$8HL$H7 H@ HD$0HT$0HM  HHL$`?  H  HL$`9 @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH	 Mt
IHL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH Mt
IrHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ cLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8q  (fog IHCHMEHEUHMHME0H]MH} E H}(M@fo
" fEPU`Mp;Xf/CvCHIH;HC  l  H$0  HL$H  HADc$L$@  H   A_A]^[]UkOk@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4C  H;}. HD$8HHD$ (HD$ )HH;|LHL$PHՏ  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1HG&HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@   HL$0 LD$PMcHHL$PIHPHL$P HHL$@JH$   lH$   n
 HH$P  H@  _@SH HHHSH
! H3H
HJHH
 3HC HC(HC0H
 C8HH5 HCHH [@SH0HD$     O  HH0[@SH HHHSH
 H3H
HJHH
 3HC HC(HC0H C8HH}
 HCHH [@SH0HD$     JN  HH0[H(((T
o f/
 v6f/
% rWf/    H(&d \l H(o f/v(H((Y((Y% (Y
 (Yư X% Y X
 X& YX YX%n YX
J YYY\\\%ΰ X YY-± ^X(H(HI H
 73L(DIDAf     A
 f/sffA;uDA f/sffA;uDAHkAHAR HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DY6 A(gb D
 (E(A(Y=ٯ A(»   EY(D(T
@ f/
p    A(AYa (A(Y% YXf;vM- (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_HU H
C QHHXWH   )pA)xfD)@(D)H(D)PD(Dh fD)X   D(D)`DYD((DYYE^Y DW
  ` Y=Ӯ L$   L$   3D(DY(DYD ((T
 f/
ڰ    Y< WA^(Xf;v.ffnYA(EY\AYXf;rDY A(*` Y L$   I[(|$pE(CE(KE(SE([E(cYA(sI_HaT H
B H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
ҭ EYW= (A\AYY! ^_ YWA(Y٬ (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PY L@D)XD((D(T f/ݮ    DY> )|$`D)D$PD A(A\EX(A(@^ E\Wf.EYD(DY zt1AYAYY= A^(^ AYY D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxHPR H
@ H   eH%X   
r	 )t$pWA   D)T$0D(HB9	   fA/vDW fD.zu (t$pD(T$0HĈ   3 fA/rfA(L$   AYH~	 H
	 $   /v  %ߒ	 (Y% A(	 AX\\
	 Y  D)\$ D? fE/rz  L$   A(Hu	 AYH
	 Y
ѩ \$   ot  %	 (Y% A(P	 AX\\
o	 Y(  % E^)|$`A(D)D$PAYD)L$@f/   D((DY
݇	 Y	 DX
ć	 X̎	 DYYDX
	 X	 DYYDX
	 X	 DYYDX
^	 Xf	 DYYDX
<	 XD	 D^   #	 (^D((DYfDX	 DYDXfDYDX	 DYDXfDYDXҍ	 YfXύ	 YXfYXč	 YXfYXD^f/   D((DYI	 Yi	 DX0	 XP	 DYYDX	 X.	 DYYDX	 X	 DYYDXʍ	 X	 DYYDX	 XȈ	 D^   	 ^D((DYfDX	 DYDXfDYDXp	 DYDXfDYDXY	 YfXV	 YXfYXK	 YXfYXD^A(Y (A(YY (A(wY -9 (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
	 n =	 g( H
	 (
` Q	 (r c	 k 
D	 (
 U	 ( 
?z	 (
ج Az	 (Z 
Cz	 (
̮ )~	 ( )
~	 (
 )~	 (2 )
~	 (
Į )|	 ( )
|	 (
 )}	 ( )
}	 (
, 	 (ޫ 
	 (
 	 ( 
	 (
 	 (V 
	 (
8 	 (: 
	 (
 	 ( 
	 (
 	  
	 
 	  
*	 
ڧ 	 " 
J	 
 2	 5x	 
	  rH   eH%X   
l	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D% B9	   fE.E(DT zu	A(  a fA/)|$prnA(L$   AYH%	 H
N}	 $   Xo  %؍	 (Y%E A(A(X%	 \AY\
$	 YY9  D)T$@D` fE/rnA(L$   AYHɆ	 H
	 $   m  %l	 (Y% A(A(X	 \AY\
8	 YY   E^)$   A(AY$   A(cU (A(3U (L$   H}|	 H
	 An  (L$   (AYH	 XH
x	 Yn  \YXA(T Yf ($   D^AYD(T$@fE/vY=w ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
	  =	 (7 H
l	 (
 Z{	 ( l{	  
M{	 (
N ^{	 (O 
}	 (
q }	 (ì 
}	 (
E )ޅ	 (g )
	 (
	 )	 ( )
	 (
 )	 ( )
	 (
 )	 (Ӯ )
	 (
 w	 (G 
w	 (
 w	 ([ 
D	 (

 F	 ( 
H	 (
 	 ( 
	 (
u 	 ( 
Pz	 (
 Rz	 ʡ 
Sz	 
; 	  
+	 
S [	  
É	 
# S	 D|	 DAv	 D%	 D_	 D%y	 
	 u
 D$H   eH%X   
hg	 )|$`=o A   HD)T$0D(B9	   WfA/	  fD.z(	   fA/)t$pD)D$P  A(E(^"	 EYQ (A(fA/X(Y^%T    A(A(Yt	 Yn	 Xt	 XV	 AYAYXt	 X4	 AYAYXt	 X	 AYAYXxt	 X	 AYAYXVt	 X΄	 ^   >t	 A^((YfX0t	 YXfYX%t	 YXfYXj	 YfXg	 YXfYX\	 YXfYX^	 A(YX \	 AX\	 YYX  . fA/   A(AY$   A(^=	 O (A((XL$   H	 H
v	 Y^-k h  %	 (Y% A(߆	 AX\\
	 YYX  D)\$ Dƞ fE/   A(AY$   A(^=	 &O (A(T(XL$   Hz	 H
7	 Y^- f  %	 (Y% A(߄	 AX\\
	 YYX  E^D)L$@A(AYf/   D((DY
	 Yz	 DX
	 Xz	 DYYDX
	 Xz	 DYYDX
	 Xjz	 DYYDX
	 XHz	 DYYDX
n	 X&z	 D^   U	 (^D((DYfDXB	 DYDXfDYDX3	 DYDXfDYDXy	 YfXy	 YXfYXy	 YXfYXD^f/   D((DY{	 YKv	 DX{	 X2v	 DYYDXh{	 Xv	 DYYDXF{	 Xu	 DYYDX${	 Xu	 DYYDX{	 Xu	 D^   z	 ^D((DYfDXz	 DYDXfDYDXz	 DYDXfDYDX;u	 YfX8u	 YXfYX-u	 YXfYXD^A(K (A(K (A(K  (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
	  =	 R( (
g n	 ( n	 ( 	 ( 
~n	 (
 q	 ( 
~	 (
# q	 | 
~	 (
6 q	 (w 
q	 (
9 z	 ([ 
y	 (
 )~	 (ߥ 
 z	 (
 )~	 (C )
~	 (
դ )~u	 (w )
~	 (
y )u	 (۠ )
du	 (
m {	 ( )
hu	 (
A {	 (C 
|{	 (
 .v	 ( 
v	 (
 *x	 (k 
v	 (
M .x	 (ϟ 
x	 (
 r	  
r	 (
 ~	 ܘ 
r	 
M u	 e 
	 
 =	 % 
	 
 	 =x	 
	 
 H
	  
.	 	  L$   H] H
 H1/ H
 D$HxeH%X   
]	 )t$`W)|$P(A   HD)T$ D B9p	 >  f/~  , f/D)D$@   (Y$   (^I	 H (((XL$   Hm	 H
$r	 Y^- `  %|	 D(Y%ߔ (~	 X\\
|	 Y^DYDX^  D)L$0D
 fD/   (Y$   (^8|	 YG ((X(XL$   Hl	 H
kk	 Y^- ]  %}	 D(Y%& ({	 X\\
c|	 Y^DYDX   D^A(AY$   (F ((F (L$   Hs	 H
!{	 _  D(L$   (EYHt	 \H
6q	 DY|_  XYD\(eF Yϔ D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
%}	  =}	 ( H
}	 (
 p	 ( -p	  -p	 (V 
o	 (
 yk	 (: 
[k	 (
l )i	 (ޝ 
_k	 (
P )i	 Q )
i	 (
Ü i	 ( )
i	 (
6 )j	 (8 )
j	 (
ڜ )j	 ( )
j	 (
> o	 (  
o	 (
 r	 ( 
o	 (
Ɵ r	 (8 
r	 (
j Cy	 ( 
%y	 (
 q	 ( 
)y	 (
r q	  
q	 
l {	  
y	 
4 y	  
y	 
 z	 Di	 Di	 5n	 D9r	 5x	 D(q	 
Hy	   xL$   H H
( zHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H'  HH   [A(f.-+ LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((Y& Y
 (\f/ vY H(((H(6  H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
 HDH] H H;HBLCLH LH
ǧ H\$@H0_    @SUVWHx  HD$8Hl H3H$`  IIHHM;H   HL$@H& HL$P>HH{ HHI& >HH% >HH% >HHt% >H$@  HL$@HCHD$0H$@  H$X  HC$@  HD$ L
-& LD$0HH譃H$`  H3,  Hx  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
2! l HM2LM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEHtHHLMLEHEHHEHHcI;N}!H
  H
  WEHE    LMLEIIURHMH   HEH+HH?H;v/ H    H=   r<t HAH;r H+Hs H'v H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;r H+Hsr H've H  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	 Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@RH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHH4  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHH 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3a H1HD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM获  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HMQ5  L;}:@      HMHEBEffYfBXB)IL;|LHHM5  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIK!H$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLGA  HL$hg HL$p\ L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH,  HC   HkH{rHH  HHH H H;t    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AI+ AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  ( I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@SUVWAVAWHh  HD$8H H3H$P  IMHLH$  D$0    H" HD$@H$    D$0   E3E3HT$HHL$@ HD$@HcHH HD@HD$@HcHDxDD<   HL$HHHL$@'HH 'HHU| HH
 'H$0  HL$@ID$0H$0  H$H  HC$0  Ht$ L
>
 LD$0I|@SUVWAVAWHh  HD$8H H3H$P  IMHLH$  D$0    H HD$@H$    D$0   E3E3HT$HHL$@h HD$@HcHHw HD@HD$@HcHDxDD<   HL$H6HHL$@&HHz &HHU, HHz	 m&H$0  HL$@軿IHHT$0H$0  H$H  HC$0  Ht$ LD$0I"LD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H  H HCPH [HL$SH0HD$ HD$P    EtH> HA@HK HAPD$P   J   H HH HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHKl He HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H HH HHH\$PHt$XH0_@SH HHHSH
a H3H
HJHH H HHH [H\$WH H,
  H HGPt
X   H7  HH\$0H _@WH0HD$ H\$@HH HH HAHI HtHP tHC     H HHK @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HH? HH HAHI HtHP tHC     H HHKH0[H% LH   ICAC    HQHc ICHp ICAC   IKkH HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H.> HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HHG HH HAHA@HcPH2 HD
@HA@HcPDBDD
<H HH[ HAHI HtHP tHC     Hu HHKH0[H%J @SH0HD$ HHG HH HAHI HtHP tHC     H HHKH0[H% DD$HL$WH0HD$ H\$HHt$XHH3t$PHc HA@Hp HAPD$P   HO HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   ϏH HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_@WH0HD$ H\$@HHh HH HAHI HtHP tHC     H( HHK @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHc HA@Hp HAPD$P   oH HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upHx H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3 H臇HH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HM{AwI_ HSHH;vHHumH    H=   w9H   HHH;w
HHHi H+HL$@HH$L<    I HHuMtHCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
I HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
[ f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CTH;}D$`HD$Hf)HH;|LHL$ H#	  (YX f/ArWg AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
a H3H
HJHHõ 3HC HC(HC0H> C8HHm HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
I[ D)PD(D)XD(DYD)`E(D)l$ D((DYYE^Y~]  Y=Z L$   L$   3D(DY(DY"Z Q((T
e f/
\    YZ H    Z WA^(Y5{Z X    AYHDXA\EYAY(YXHuDY\ A( YY L$   A({E(CE(KE(SE([E(cD(l$ YA(sIH   H
 茜HHXHpWH   )pH5B)x3D)@WD)HD(D)PD(EY{
D)XD(DY DYDY[ ff     A(Y3 AX(AY
 Y3 H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
Q H3H
HJHH 3HC HC(HC0H6 C8HH HCHH [%`Z (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-ZD)@HDU Ip     D)HI   D
T D)PDV D)XD)d$PEWD)l$@E(D-W D)t$0D58a D)|$ D=T )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcBՐ XY5(U Y f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/z
  Bՠ
 BՐ (\YX(\\Y\fD/v\(YX\fD/w(AWJ f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5M MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  H HCPH [HL$SH0HD$ HD$P    EtHN HA@H[ HAPD$P   J   H HH HCHC@HcHH~ HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK| H HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H HH0 HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3葿H~ H|$HHS HeHS8HOM|HH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3H~ H|$HHS H{HS8HO{HH\$PHt$XH0_H\$WH H,  H HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfo#Q TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %P II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   O ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQH ICH ICAC   IKH HD$(HЌ HD$@HD$hHcHH HDhHD$hHcHDd    H HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHO HH HAHA@HcPH HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     H HHKH0[H%z H\$Hl$VHA3M HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H7 HHOHѡ HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHӇ HA@H HAPD$P   HO HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHD1HH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   HrV H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vHHMHHumJ    H   w2HCHHH;wHHH_ H+HL$`HHHM*H HHEHuHtH3H9HDHEXH   L   J    H=      M;vULnMu_J    H   w.HCHHH;wHHH H+Ll$`IIHۘ LHuHtHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HgG3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpIHHP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   !KHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMX| H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  HR H3HExMHv HHEH5v HHEHE   HE    E 8 uE3IIB<  uHHMƱHE0   HE(    E ; uE3I IB< uHHM花HEP   HEH    E8 A   Hu HM8_3@      H}H;   H+H   HHuH}HCuHH   LǺ%   Hf HH   :
' uH:
' uH:
' u3tH+HHHsHEH}HCEH+Ht+HD$    L
l A   HHMbH)IE3HUHM8A   Hd' HM8诳IHMX3LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H6 HH    :& uC:& uC:& u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8ϳHE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H/ H( HD$0HT$0HM%HHL$`wHX HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[A7 f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^AK6 f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A5 f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0HJ H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHH H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	I HM H3.  H]`HuhH}p(u0He@A_A^]Hc HHXHOoiHLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3 HXHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$ 1 L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3 HpVHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$  L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D%L0 HxEW@      IL$LkM4$Hfo0 HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D=r, HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  (f C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;tRHIHt3%{ HFHLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  H5 H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   DL   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;v IHU`HtLmH4    H   w.HFHHH;wIHHJ H+Ll$`II*Hwx LHuHtHU`IHuX3HIDH   H  H  H    H=     M;v=HUhHtL_J    H   w.HCHHH;wIHH H+Ld$`II Hw LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   Ir(3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   I&LEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   E*HIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HdHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
Iu    tH   su HM`hu HMh^u H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKWLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH:HL$@Rt HL$HL$   I[Is A(sI_H%-t H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	q Ht
HP=HHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;t/q Ht
H<HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"Ho Ht
H;HH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^DD$HL$WH0HD$ H\$HHt$XHH3t$PH[ HA@Hk HAPD$P   H/ HHOH\ HHG@HcPHa HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     Aư AfYD HH;|Ld$PH;}3IGHp HhIL0 萶 YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"H[ Ht
H'HH    H|$0HsH\$8H ^LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0H  H3HE MLHAp AY1LIIM;v踝H9HHuzJ    H=   w2J   HHH;wHHH H+H|$0HH8J    H*D HHuHt@HIHFE3EL96LDL}HEH    H=   @@uIM0I;vMM(MufH    H=   w2H   HHH;wHHHD H+LL$0II$H    HiC LHuHtIE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
IC @t	IC HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;t聙IIHOH;tHN@ Ht
HHH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}fo UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HM?    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$8c    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht3= H	HD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%= @UHPHl$ HE H]@HuHH}PH H3HE HHLBHL;v腖L
MumJ    H=   w9J   HHH;w
HHHՍ H+LL$ II$J<    H< LHuHtHC3H9;IDH    H=   LFHHN1   t	H< HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5 MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDXA(YL
X(YDXX

A(YL
YDX(YLXA(YD
XXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+(A(YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YXA(AYL X(YDXXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;tHtHtIHHH;tԈLLMt#3/ IwLHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;t\HII;t$I./ HtHHEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHMosHMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM2. HM(. HM. H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$I- HtHIE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4COI;} D$XHEf)HI;|LHL$ IOIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CNI;}D$XHEf)HI;|LHL$ IuNMIIII+L;  L@MtHHIL;  IMIH	HWE3LL9G~L
 L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]Y@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH  H L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   fo f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G/5H;}%ff     EHD$@f)HH;|MHL$XH4HEPLM LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHNEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI   LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5 )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4G.H;}EHEf)HH;|MHL$PH.Ʈ L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;tZ\HHHt3- HHHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3N HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$ > L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3 HzHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%H Ht
HnHL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfoN IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI Hfo IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMEI~ @    RL   L   IH!   H  A_A^[]PLWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK;H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLC1HL$h HL$p L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H0 H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	Hl H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHHE H+HL$@HH	H HHHMMAVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+HcAH+2HcAH+hHcAH+LHcAH+HPHcAH+2HcAH+D	HcAH+Ho(HHcAH+diHcAH+HPHcAH+8HcAH+SHcAH+pHwHcAH+HPdH;(HcAH+ܠHSHcAH+HcAH+HcAH+l	HcAH+HP|PHHcAH+$HhH(OgHcAH+H7PH4HHcAH+hHcAH+H`fH(׿HcAH+HPH(;?HcAH+RHcAH+HPHcAH+HP,gH3HcAH+
HcAH+HcAH+<H(3fH(HHcAH+\HcAH+HPl&HcAH+HPHsHfH(K?HWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtHV HHXH
V H [% % % % %v %h %Z %L %> %0 %" % % % ff     H;
Q uHfuHS  H\$Ht$WH E3H
sU   m  H
J 4 HH   HQ H  Ha HH
 Hn HH HHtnHtiHtdH%0U  H
  H
U H @   ?+HH3HH3H=U HU H
O   ^  H\$03Ht$8H _E3E33AQb HT Hu     ̹   {  H(H
aT  H
T Ht H(@SH HH
4T  # H
$T  H [   @SH HH
T ^  H
S Y  eH%X   A   LЋh Cf H [h   @SH HH
S  ; u4d      ;teH%X   
xY A   Hȋ AH
YS H [H% @SH H
oS Hu0Hۨ H3jS ?HH  H
=S HH [H H
-S H [H% H\$Ht$WH 3H9=S u8Hu H3R ?HH>  DHR H
R Ӆ3H
R 7 H
R E3E H
vR  H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
@R u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
4Q H(%  u#  H(H(3%  H(  @SH 'Q ɻ   DÈQ 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
P u
  t2zH
P a
  gH I¹@   ?+ȰIL3LELEELEM1P LELEELE
)P M%P 
-P H\$PH@]ù     HLMZ  f9!uyHcTHH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuH*O H [@SH =OO  tu(  !  H [@SH HC HًH3N ?HHu
H  HH
N   3ɅHDHH [H(HH(]  @SH H HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@=M  t
   r  M    tg	  H
	  5	  H
>	  P	  H H
 
  u)0t Hm H
F ]
  7M    @2@N	  HH8 t$H2tHH?  Lƺ   I0M    H\$0Ht$8H|$HH A^H\$Ht$WH @L 3ۅ3PȉL =@D$8=L t
   K  J|L o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9dL 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH Hi IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH% @SH H3g HV ` HȺ	 H [H%T HL$H8   	  t   )H
GK    HD$8H.L HD$8HHK HL HJ HD$@HK bJ 	 \J    fJ       Hk H
^J H      Hk H
> HL    HkH
1 HL H
  H8@SVWH@H? H   3E3HT$`H- Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$  ǃ|H@_^[H\$UH$@H  ٹ     t)%N  HM3A    HM H   H  HE3 Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 3F H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T   " HD$PHD$@HEHD$H3 HL$@ u
!M H$  H  ]@SH HHH
1 HHS3H
HJHHl  HA HHH [3HAH7 HAH HHH HH  H\$WH H HHH  t
   HHH\$0H _HHHL$ H_ HL$   HHHL$ ZH?Y HL$   H\$H|$UHH e 33L    D9    cAMDDDAentiAineIAntelEDD[L AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
ћ A%?D	L = t(=` t!=p t wH     HsADK Eu  ` rADK    UDM;|$3E]MU]	sAD}K Asn        AsSAsL3H HHUHE$<u2 ך    E њ t      H\$83H|$@H ]̸   39 H\$ UHH He H2-+  H] H;uoHM HEHE H1E HM H1E E HMH H3E H3EH3H  H#H3-+  H;HDH H\$HHH H ]H(uH=  uc    H(H
J H%R H
J   HJ HJ H(HHH(Hl H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH H^ H5W H;Ht
HHH;rH\$0Ht$8H _%: % % %  %* %4 %6 %8 %: %< %> % %z %| %N %@ %2 %$ % % % % % % 33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D% D)xEWY5 fA.zuT=ъ D\   D)$P  (T (T
 D(f/D)$0  D)$  EYv
D(^^D((fE.D zuA('YAX(Y1 L   (H   AYfE.D($  z.u,fA/w	Dˁ (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0舿L(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3̅tH5 H H+ H+ H H! H(H H9A   LAIHH3H+H.MtAHIHEH(3HIHEH(IIw;HgB, HAIHHH(ËAIHHHH(H(H% H\$0% HHuHH\$0H(HH|$  H+Hu
HSHR0H\$0HH|$ H(         @SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
v H9Ht6H HH [<    HuH
 HR H	 HH [@SH0HAH      t-H
h LS LH   H	g u/HH0[H
 LH@LHS HD$ H	 H+u
HCHP03H0[E3H;
 AAH;
V H;
 AAuH% H\$WH HHHIH H;t6" u,LHT$0H HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _@SH H=     H D  C
HKt1{ t 0HSLCHMtE3 - 
HSH HKHHCHHtm HtH(H{ u3H [ÃH [H(  H H3H$  A   D$    LV( HL$4AQ  LJ    LHL$0 D$08D$4u%D$28D$6u3H$  H3H(  HD$0   HD$(LL$4HO L1P HD$ HL$@ A   HT$@3F H$  H3H(  H(HE*  H~ H
I H H [ HuHW> H(HH
 p  H9> HuH(3H(H(=U[     H
K  Hu13
 H
n HL A   H	` y/H(H   Z    HHtH(uH@P0H
L  Ht$HK   HtH(uHPHR03H(1 3H(   H\$WH0H HH   Lz HI HR    L< HI H3    LHI H xoLH H~I H xTLHD$     LH
I     Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0H\ H
 HI A   H	 yH/u
HGHP03HH\$@H0_@SH HQHLIMtIHD$XAt 3ɉKpHK@HKHHK HK(HK0HK8HtH HCXHD$PHtH HCPHD$`HtH HKhHHC` HH [H\$Hl$Ht$H|$ AVH@H
/; IH5F HH-D L5D  HtHt$0LHl$(HHLt$ H\$PHl$XHt$`H|$hH@A^H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
 HF H	 H(HAXHHD H H(LHt4HB      t$HIPHIPPHt
H)uHAP03H(H
1 H"F H		 H(HAPHHD! H @SH yp H   Hl$0Ht$8H|$@Lt$Hk HHhPHpXLp`3HGPHGXHG`9CpuHt3H  HHuV HtHP 
H(uH@P0MLHHM  Lt$HH|$@Ht$8Hl$0H [@SH H H{8 t	H {p |H H9 u Hl H$   HH [H% H [H\$WH H3HIHtH{H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HK Z  HKhHtH{hH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu3HK@Ht	Hօu!HKHHt	HօuHK LH#   H\$0Ht$8H _H\$Ht$WH HIH	HHt	Iօu&HKHt	HօuHKHt	Hօu3H\$0Ht$8H _LI[WHP3HIC H ICA   ICHICHIC ICEAICIC
 u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0yt HHYHHt!H
 HA H	 3H0_][Ht$PHI  H HHH+
  L$xtetaHH  H+u
HSHR0HOHHtHGH    H)uHAP0   3H  HHt$PH0_][^  GtHCH;5 u+HD$pHLL$hLD$`L$(HHD$ H*  L   HH: MtAY HH   H+u
HCHP0H
 H	 uHt$PGt3H0_][Q HOHHtHGH    H)uHAP0Gt LD$hHHT$`A  3H  HHu'% H9XPuH
 E3E3HHHH  HHt$PH0_][HT$pHHt9 LL$hHLD$`HD$      H.Hu
HFHP0Gt H+u
HCHP0Hu7HW  HHu' H9hPuH
 E3E3HHHhG  HHt$PH0_][H\$WH yt HHYHt$H
2 H> H	R 3H\$8H _HtIHHHt$0  HOHHtHGH    H)uHQR0H+u
HCHP0Ht$0uH
 H	o 3H=  Ht4H(u
HPHR0H
 H> H	 3H\$8H _ Ht*L HHh M Hm	  # H H\$8H H H _@SH HHIH{t tH
 H= H	 3H [HtGCtHAH;1 uH;R u
3    Ct Hu!HH [B  H HH [  H [H\$Hl$Ht$ AVH HD1 3HLH9BuHHH      AtHHBHn5 H|$0L   MtA HHu%H
 H	* u	H  '3HZ H/Hu
HGHP0HDH|$0AFt HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIH{t tH
6 H; H	V 3H [H   CtHAH;0 u\H; u3H;[ HD >H; u3H;= HD  H;* u   LH4 A6  Ct HuDHP   H  HHu'p H9XPuH
 E3E3HHHWC  HH [H\$WH 3HHIHHD$0HtHGHH)uHAP0 HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu' H9XPuH
 E3E3HHHB  HH [Hl$VH ApHHu2Ht-H; t$H
 H%: H	d 3Hl$@H ^Ãu"HtH
 H	 3Hl$@H ^H\$0H|$8 H~  HtXHF0HtHHHGHtH HGHAHF Ht.LGhHWpHOxHGhHF(HGpHF0HGxLF HV(HN0EHN    HGhHF HGpHF(HGxHF0HF HtH HF(HtH HF0HtH LFtHHVH|$8H\$0Hl$@Ft H ^HtH
t H	H% H
1 H8 H	H% H
 H8 H	H% H\$WH H3HyHYHHAHAHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWHH LYP3HYXHLQ`HL] H]0LU8HAPHAXHA`MuQMtI*u
IBIP0H]0HtH+u
HCHP0H+ H H! H3H\$HH _^]H HL;   HuH H H LU8L] cHKH;u	H[@H-      t<H{|	H[HH H H HM0H)uHAP0LU8L] 	
  udHt_MtI*u
IBIP0L] I+   ICI   Im  u$LM8HLE0HU >  H\$HH _^]LE8HU0HM  HE0HHH HH;t
 tHM8Ht
H)uHAP0HM H)uHAP0HE0HX@HHM0H)uHAP0H3H\$HH _^]H\$HHYhLYpLQxHAhI HApIHAxHH\$MMH\$Ht$WH HHHQHH HHttL@A      u	H4 HG H9C t-H 5 H
 LGH	D H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
` H	w t H xHWLH xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _  H uHH8 uH\$0H _ø   H\$0H _LH;u   HA    }<      @t0HB   yA      @t3'  sI   IH% @SHZE3LH~HBL;   IHL;|E3H|$H   H= LZff     IHA    }r      @tfL;tzIX  Ht-L@3M~JH@ H9tVHHI;|/   [I H   H;t
HuH;   uIIL;n3H|$[ø   H|$[E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
p AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL; AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H; ø   Htfff     H   H;tHu3H;n ø   H(HA      tiHQHHtVHtHHt0Hy H
 H/ H	H HH(H(H% AIHHH(ËAH(3H(H\$0HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,H< H3H(ËAH(ËAH(H(H%W H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(^< ^< ^< L< E< V< ^< ^< ^< H(HA      tEHAHHw,H= H3H(ËAH(ËAH(H(H%w H\$0
HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(>= >= >= ,= %= 6= >= >= >= H(HA      tEHAHHw,Hx> H3H(ËAH(ËAH(H(H% H\$0-HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(> > > > > > > > > H(HA      tEHAHHw,H'X? H3H(ËAH(ËAH(H(H% H\$0MHHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(> > > > > > > > > H(HA      tEHAHHw,HG8@ H3H(ËAH(ËAH(H(H%׶ H\$0mHHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(? ? ? ? ? ? ? ? ? H(HA      tTHQHHtAHt3HHyH
Z H' H	
 H(H(H%g AH(3H(H\$0~HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,HA H3H(ËAH(ËAH(H(H%7 H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(~A ~A ~A lA eA vA ~A ~A ~A H(N H(H(. H(H( H(H( H(H(ε H(H( H(H(n H(H(n H(Ht$H|$ ATAVAWH L%]% ALO LtHv  tDADH\$@Hl$HEt8H-/ Ht, H  ; }HHD9Du
H\ H,MDƋI   HHthtHЋ  L# E3HI HHtHȉp| HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH|$XH A_A^A\H\$Hl$Ht$WH   HAIɋ8 HHtVtDL2 HH
# 
 	H HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_H  E3H
% E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$       H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H= HڋHuH   e H  hHHH  @       H\$@Hl$HH _Ht$0Dŋ5 HϋLt$83  LcD;}'IH9luHHH)   HAP0}Z ;u.p@HHcH HHtX55 5+ H, HcMI;~#HHHI+@ AHIAHuMƉ5 BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H= Ht/ H9   ; }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@UVH(HH
] Hu	H(^]H\$@H|$HLd$PLf`Lt$XLvPL|$ L~XHFX    HFP    HF`    ̱ HHtJH H
z% H9HuH5    H HLB HH5 HHHH
<% [H
 Ht HAL   MtA HHtRH  H HE H/u
HGHP0Ht)H;k tH;Z t4H t'3#i LB 3H H
 d MMIHc+  L|$ Lt$XLd$PH|$HH\$@H(^]H\$WH HAHL   MtA HHu.H
1 H	H tH
 H LH	 HH\$0H _H\$Hl$VWAWH0333HLHu3 HH   HH
 Lt$PĬ LHt~ HHtp.   H
 < Ht<LD$    LII HHu7H
 H	] t#ӫ LD$     LIII HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^@SUVWH(  Hd H3H$  HIIIH HH   HH      uH
 H LLH	 ~H@ H;s)H
 H HD$(LLH|$ H	ի L$p  upH;vkHD$0L H|$(HL$@LHt$     E3HT$@3C y.H+u
HCHP03H$  H3襸H(  _^][HHAH    tH%S    Hl$Ht$WH HBHHiH      uHl$8Ht$@H _H%	 HH\$0 HHu"H
 HM LELH	 3:H H@L  Mt$LHHAH+Hu
HSHR0HHH\$0Hl$8Ht$@H _H(LALH
 H H	. 3H(LI[IkVWAVH0HAP3ICIHAXMCICLHA`ISHi`HHiPIHiXIKIC) H9nP   HD$PHt(HL$(Hw    HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHVhLH~pHH^xIHNhLFpHFxHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP03QHL$ I.H/H+Ht
H)uHAP0HL$(Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIPH;u   Hu3HB         H\$UH HjE3HH~HB H;   IHL;|Ht$0H|$83H   HrfHH;   HC             @   HB   yy      @tmHX  Ht4L@3M~HH9tFHHI;|3V   H\$@H ]HfD  H   H;tHuH;`     s
H^	H u'HHH;3Ht$0H|$8H\$@H ]ø   H\$WH LQhHypHYxHQhLApLIxMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _HAhHHApI HAxIHHtH I HtH IHtH H\$WH   H3HH9HHDG<( u#H H;HC8HC0HJv HC@H{FDK$AtPH
ߥ HX A   H	 H9;tH
v H9C@uH{@H H$   HĐ   _H$   HL$@  HS(HL$@  HtLCH
&~ L;t^HH H HGL
 HD$0H H} IHL$(H
! LOH HD$ H	 :H9{@uHFu HC@3H$   HĐ   _3HHAHp HA8HA0Hu HA@H9 tHt H9A@uHA@    H% H\$HT$UVWH HHL¬fHH}  AV 3AV IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <94HÍv4p<0}H\$Hu,H
 H
 DH	ܡ t*L`HcHG(H- H
֡ H	 3H\$@H _^]H
 H
 AZ   H	 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]HU cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]fU hS DV U T rS S T S `T T #T PV 5U  







































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtH H
 H	 3    t   LA       )   эB<       A<	  CDA0H<0|f<9CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGH[ DHHH
۞ D@XH	    HGHcHLH
 MDH
 H	 gH
 H
 DH	c JH
z HS DH	F 3+; uH
 eHCGGHG(   IH H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
 LMH H	[ Ld$XH(A^[D8cGu+DAXH H
S H	* Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
\ H LH	) H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH LICHD$(IM HD$ GHuL
 LL H L HL	AHDAP@  HD$(H LT$ MH
t H	K H8H(DA@1wVL
HA] A] IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
 H H	 2H( n] ] ] g] `] u] ]      H(DA@4wEHءH^ ^ H   H(ø   H(ø   H(ø   H(H
# H< H	 3H(>^ H^ R^ \^ f^       H(DA@4wEHHh_ T_ H   H(ø   H(ø   H(ø   H(H
S Hl H	# 3H(_ _ "_ ,_ 6_       H(DA@1wqL
8HAl` AP` I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
W Hp  H	' 3H(_ _ _ _ ` ` 2`      H(DA@4   L
4HAa Ata I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
S H  H	s 3H(H
5 HN H	 3H(f` ` ` a "a a 6a Ta       Hs   LA c Ab IH3 H? HG HO H Hk H H H H H ÅH
 H HEÅH
 H HEÅH
 H HEH H H  H( H H(  b 
b b *b :b b b Jb b b a gb Rb |b b "b 2b b Bb b  	

DH H
 H	H%ē @SH HDA@<	w<BHA؃0<0|<9H[X<0}HtH [ÃHHR H
k D H	> H [HDA@<	w7BHEA0<0|<9GHE@F@<0}HAÃE3H LJLk HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=k Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJHf HHHL$ H
> H	͑ 3H8fD  H   H;tHuH; t   H8H\$Ht$WH LAHIxpHt[H tTH MtI	HLm HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
w HH M@H	 H\$03Ht$8H _H(H] H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H(z y,H(LH /   HHtH(uH@P03H(H\$WH IHD$H    LD$HH   tHLH\$HH  "H\$HHu
3H\$0H _HH  H+Hu
HSHR0HH\$0H _H\$WH H>  H+Hu
HSHR0HH\$0H _H\$Hl$Ht$ WATAUAVAWH LqE3Hn MLDd$PHI9   t$I   Ht
H   ˏ H   M9  uI	 :  II- HHt9H H@H;o t!H; tL  MtH   t
oD$P   H HtMH0HtEHIMEH# HHtH H.u
HFHP0Ht>,H.u
HVHR0|$P uTMt^LEHHAHH+u
HCHP0Ht4Hɍ H9Gu'H9ou!H_HH/u
HGHP0I   /I?(HtIH
& H MFMH	 3H\$XHl$`Ht$hH A_A^A]A\_LH;uHQ H HG HAH; u_HAHH1 H H' At%Hu3A?E9AA9QtHuA?D9AuH;ˌ uAfAnf.zu^A   H% H\$Ht$WH Hr 3HH΋H9CH9G5  C u
H) xG u H yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM @ƋH\$8Ht$@H _L I;uUI;@ƅuJA   HH HHH?H+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HH t/HD$8HH      tJE3LD$8HT$HH uLL$8MtLH
؋ L HJ H	Y 3H [H
 L H H	3 3H [ø   H [H\$Hl$Ht$ WH H3H
 IHL;u3H;Lt$0HMHDߋ      Ht:H   MtH I9@tH
 H2 H	ى h  HHHHJ Ht( HH`H;tHHp`Ht
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHI t   IMMHC      tHHӹ   ( 3& HHtuE3HH H+Hu
HSHR0HtNLOHA      @H
 H LH	= H9 H
 H	q Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4IS   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@%S HLL$pH8G `<`uHH@Iy( uI$ LL$pAA `<`uIAIA@H;u-HIH	 yڇ H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$ ! q3H\$`H0A_A^_^]HY@%B HLL$pHC `<`uH[H[@Iy( uI LL$pAA @t
 tIAIA@H;u)HIH	ԃ ؅yȆ HuqLL$pt@HI;H H
ǆ L$   H	N H\$`H0A_A^_^]HC H
 Hk L$   H	 H\$`H0A_A^_^]LLH
K H H	H%҄ HHLT$pHh M;LT$0MLH
 MML
 IML
M H H	LDIH> HDH/ HD$(L\$ O HHH\$Hl$Ht$H|$ ATAVAWH H1 HL`PLpXLx`3HEPHEXHE`MtI$MtIMtIMMIH      o H HMPHHuXH}`LePLuXL}`Ht
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
  H H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAPHHAXI HA`I3HAPHAXHA`H\$WH LQPHyXHY`HQPLAXLI`MtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
c H A   H	- H(H(   H\$UH  HHXPH   H
y LI;tqHK    }F      @t:I@   yA      @t3Hs
IHIHR uH\$@H ]3Ht$0HuXH|$8H}`HE`HEPHEXH+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HHp LL
 H
 H LDH	H% H
ɀ H* A   H	H% @SH H[ 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H  ËH [L I;AuI;AuA    HHu	H [HH|$0ЧH+u
HSHR0H|$0H [@SH I9 Hu Ht3H [HH H [Hl$Ht$WAVAWH E3IILHL9quL9qum  y3   H\$@L9wtAG t;   n HHtsHE HHhIHHp G tE3W=W8   3 HHt8IE3LxHHE Hh HHp(HO
  LH+u
HCHP0H\$@IHl$HHt$PH A_A^_H8HALHt)y    LD$ LL$(uE3HT$ IEAH8H8Hl$Ht$H|$ AVH 3ILHH9iuH9iu  y3   H\$0H9ot9G t3    ~ HHtcHHHpIG tE3W5W0   } HHt0IE3LpHHHp HO`	  HH+u
HCHP0H\$0HHl$8Ht$@H|$HH A^LD$H(LQLMt4A uIIAH(=   uE3D@HT$@IAH(H(@SH HAHH	HHAL   MtA*} LHu	H [LKIAHz~ H;tcHX  Ht1LA3M~eHfH9tAHHI;|3H [    H   H;tHuH;    tIA(HHHKIA(HᏉK 3H [@SH Hy| Hut| HuaHCH      t>   } HHt;H
T} HH	@~ H+u"HSHR03H [H
)} H	~ 3H [H H [H\$Hl$Ht$ AVH0HA3H;} ILHuHT$ HT$ LD$(DF     H;} u=HIQ=   u*Lt$ Hl$(HA uHsE3HT$ HEAc   H|$@{ HHtCIE3LpHHE HHh Hx  H/Hu
HGHP0H+u
HCHP0H|$@HH\$HHl$PHt$XH0A^H\$Ht$WH IHLAHHH
 x L
 MQLHHtH H\$0Ht$8H _z Ht3H\$0Ht$8H _HH\$0Ht$8H _'	  HH;}HH33H%Fz LL$8E3HMtIH%$x HAH@pHtH@HtH   Ht$WH0LAHHI@hH   Hx    HH\$@臞HHuYy HtNH<x HHp{ t%w LGH H
<z M@H	wx 3H\$@Ht$HH0_A   HHD   H\$@Ht$HH0_H
y H M@H	)x Ht$H3H0_H\$Hl$Ht$WH Hq3H;5wv HH   H;5w u8LI?AEDtHHAHH;A   HD   HvhH   H9nt{EtCHy>HHt6HxHHHV   H
v H	v u3y?v HHVhHH?EtHHOHH;Or5HCx HHtHHou H+Hu
HSHR0HHGHH H\$0Hl$8Ht$@H _@SH HHu3H [H|$0u H+Hu
HSHR0HH|$0H [HT$H(HAH;x uA   HT$8J  H(H;.y u>LAA@t
K  H(Äy$MP t3HIE3HT$8EAAH(   H(H\$Ht$WH HH   8v HHuH\$0Ht$8H _HE3HHxH  H+Hu
HSHR0H\$0HHt$8H _HA@ LPt3E3IHIE3IHAH;w u
E33  H;x uHA@t3   H` E3   H\$Ht$WH HAH@ Hpt3HYw @ H H}w ;~#H
 t t3H\$0Ht$8H _HHH
Gw H؋   ~z<R1w H 9x }
#w @$ Hu"du HuH
v H9 H	Xt Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Hu
v    v @ H H}v ;~H
B s t3lLHHH
Rv H   ~ZR<v H 9X }
.v @$ Hu"ot HuH
u H H	cs HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyLLqHHY Icu @ DH Hu D;~H
; r t3    uL CuFHu9wuLMIH   |u%Ht LCHcGI;uHSMH   UfHU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ r HHt    ~YIt H 9X }
t @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHH|r E3LHHLs HHtZH 3HH~ fD  HHvHHNHHH;|3HCs AF HH+u
HSHR0AN HH\$0Hl$8Ht$@H|$HH A^LH H
'r H	H%p HB      tHAL   MtIH%q H\$WH HH
 HHAL   MtAp HHuH
q HH LH	p HH\$0H _HAL   MtIH%p H\$WH H 3HHt7H;u
3H\$0H _H
p H H	o H\$0H _   H:w H{      e\  H=    H=Y  tD H
 [ 辺H
_ H  H)HG       HAP0  HNo HH HH
_ 3Wo H@ Hu'Hv H O     i\  M3H
u l H Hu'HJv H 
     j\  3H
t p H Hu'Hv HI     U k\  裘y'Hu H     % v\  HHH# Um H Hu'Hu H U     \  SH H
D H l H Hu'HHu H      \  	H H
 `l H Hu'Hu HF     R \  L~ H H
H H m y'Ht H     	 \  }w  y'Ht H O     \  M9= tFL H H
 o y'H>t H      \  k HHu'H	t HJ     V \  H Hj HuBLE H6 Hel y'Hs H u     \  s  y'Hs H E     \  C  y'HRs H      \    P  Sy'Hs HI     U \  q  u'Hr H  #   $ \  H
 3IHHu'Hr H ] &    \  [H LH
 [i y) &    \     H+u
HCHP0H
 3ȼHHu'Hr HZ  '   f \  H LH
8 h y '   2 \  
  H+u
HCHP0H
 3GHHu'Hq H [ (    \  YHi LH
 Yh y' (    \  	  H+u
HCHP0H
 3ƻHHu'Hq HX  *   d \  H LH
6 g y *   0 \  }	  H+u
HCHP0H
 3EHHu'Hp H Y ,    \  WH LH
 Wg y% ,    \    H+u
HCHP0H
S 3ĺHHu'Hp HV  -   b ]  H LH
4 f y -   . ]  {  H+u
HCHP0   f HHu'Ho H Z .    ]  XHh HH HKHW HH H HKH HAH
d ׹HHu'H
(o H
i  .   u ]    H+u
HCHP0H H	HHu'Hn H  .   ' ]    H LH
 e yi .    ]  @  H+u
HCHP0H H臸HHu'HXn H  .     ]    H LH
w e y .   q "]    H+u
HCHP0H/u
HGHP0   1e HHu'Hm H  /    -]  H HH HOH HH H HOH HAH H HOH HAH H HOH HAH% H HOH HA H
 迷HHu'Hm HQ  /   ] >]    H/u
HGHP0H	 HHHu /    A]  j  H LH
 c y_ /    C]  6  H/u
HGHP0H H}HHu /    E]    H LH
{ c y /   u G]    H/u
HGHP0H H	HHu /   5 I]    HQ LH
 b yw /    K]  N  H/u
HGHP0H
 H蕵HHu7 /    M]    H LH
 5b y 0    O]    H/u
HGHP0H H!HHu /   M Q]    H LH
 a y 0    S]  f  H/u
HGHP0H+u
HCHP0H HHH9
" u!H HtH H dH
	 SH=  H
 HLGa HH HHH
 H HtHc Ht3HHHu'Hi H1  2   = ^]  HCHH L   MtAb HHum 2    `]  D  H+u
HCHP0H E3HHHu'HYi H  2    c]    H/u
HGHP0H LH
h 3` y 2   ` f]    H+u
HCHP0L H
 3` HHu'Hh H  o   p]  H LH
 _ yM o   r]  $  H+u
HCHP0Ls H
J 3d` HHu'H5h Hv  r   |]  H~ LH
T ^ y r  N ~]     H+u
HCHP0^ HHu'Hg H     	 ]  }L- HHS }^ y ]  %HF LH
 V^ yT ]      H?g H H+u
HCHP0H H/HGHP0H+u.HCHP0"^` HuH
` H H	R_ HC H\$0HH _@VH Ha HPH HuH H Ht-H H ^H;tH
Y` H H	^ 3H ^H\$0H- Hl$8HH|$@Lt$He] HH   H^ H/Hu
HWHR0HtdH] HHtCHl H] HHtWLHU Hl^ H/Du
HWHR0EyFH+u
HCHP03H|$@Hl$8H\$0Lt$HH ^H
^ H	] t\ Hl H\ HHt1LHT H] H/Du
HWHR0EsH
] H	\ Y'\ Hl H'\ HHt1LHu H|] H/Du
HWHR0EH
7] H	N\ [ H H[ 3HHt7H;7] tLH H
] H/u
HWHR0y#H
\ H	[ Q[ HH\$Hl$Ht$WH HII%[ 3HHt49|$Pu	H;\ tLHHm\ H+u(HSHR0!H
0\ H	G[ t
Z H\$0Hl$8Ht$@H _H(^ HHHs HuH
g 3H(H;tH
,] H H	[ H(H
	$ H%Y 33H\$WH   H H3H$  H
 \ HHu*Hb H U 	    [    H$0  HH5Ķ HY HH   HH    |&H
[ L LH H	MZ    H@ H=`  s1H
UZ LV HD$(H LHD$ `  H	
Z GvWHD$0L
% HD$(`  L    Ht$ HL$@\ E3HT$@3\ yH/u
HGHP03H$0  H= Hu Ha 1 	    [    H+u
HCHP0H
Cq [ HHu*H*a Hc     l [    Hr H'X HH   HH    |'H
gZ L
q Lr H H	X =H@ H`sEH
X L
q HD$(Lr H HD$ `   H	X H/u
HGHP03H= Hu     [    AH
  D$    L HHr ׫H Hu    _ [  N  A0  D$    LU HHr 莫H Hu     [    Hj HV HH   HH    |'H
Y L
: Lr HL H	W =H@ HPsEH
W L
	 HD$(Lqr H> HD$ P   H	LW H/u
HGHP03H=k Hu    R [  DA   D$    L HH 脪H Hu7    [  H^ H H+u
HCHP0H+u
HCHP03H$  H3cH$8  H   _H\$Ht$WH H=8 HaU y E   q [  A  3H5H99 H8 uH$9 H;5W HDH9 H LH
9 X y E    [    H=' H=6 HT yM   ׿ [    H97 H6 uH7 H;V HDH6 Hz LH
 jX y   z [  J  H5 H=o H6T y f   F [    H9 H=۩H uH H;V HDH H5: H5, HS yX i    [     H9, H, uH^, H;U HDHL, H5 H5& HuS y    [  XH9' H%& uHt& H;UU HDHb& H5 H5 HS y5   + [  H[ H H\$0Ht$8H _H9 H uH H;T HDH H\$03H5 Ht$8H _333H(H=S H6 )|yc ^[  .   xS H Hu: _[    E OS H Hu `[      &S H Hu a[      R HN Hu b[     j R H Hu c[  d3LS H Huv d[  D   )S HB HuS e[  !   S Hg Hu*0 f[  HY H     H(3H(H   H    'S H Hu5 |   Z  z  Hk    R H Hu ~   Z  C  H    R H Huǻ   Q Z    H
Q LH!P HZ Hu f   Z    H    L
Y L Hs HD$(H HD$ $R Hu Hu2 y   Z  w  H    Q H Hu-H2X Hk    w Z  HĘ   HE    Q H Hu-HW H     , Z  HĘ   H    WQ Hh Hu-HW H W 2   [  HĘ   H'    Q HU Hu-HQW H  X   [  HĘ   H    P H Hu-HW H?  p  K [  HĘ   H    vP H Hu-HV H v     $[  HĘ   Hv    +P H Hu-HpV H +    /[  HĘ   Hk    O H Hu 2   x :[  3  HL    O HB HHu o  > E[    HR E3H8 HT$pD$ho  HD$`H HD$XHC HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    mL H^ Hu# o   H[  h  H    L
 L H H$   H8 HD$xH HD$pH0 HD$hH HD$`H` HD$XH HD$PH HD$HH HD$@H HD$8HԽ HD$0H HD$(H HD$ 1N H: HHuж Q[     H E3H½ HT$pD$hr  HD$`EAH HD$XHѺ HD$PHD$HHL$@HD$8HD$0HT$(3D$    J K H Hu-J T[   r  HS H HĘ   3HĘ   H(H
 `HQ Hu*H}S H @    ʵ Z  H(H
 H7 Hu*H;S H|  |   Z  H(H
 H] Hu*HR H:  W  F Z  H(H
? Hk Hu*HR H z _   Z  H(H
 XHa Hu*HuR H 8 =  ´ Z  H(H
K H Hu    Z  ZH
= H1 Huִ X  ` Z  ,H
׽ H{ Hu*   2 Z  HQ H H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HMJ HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
V Hz  @ǅtH H
0 H\$0H _HH\$0H _H@  @SH 3LHy  
 t=Hs Hc
Ʋ H3HHCHCLCH   F HH [3IA0  HHuH [@SH HH HHIHCHH H Ht
H)uHAP0HH HKHCHvH H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H=H HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH` H
x H\$0H _HH\$0H _H@  @SH 3LHy  
, t=H Hc
 H3HHCHCLCH   D HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HF HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtHp H
ԯ H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
j H3HHCHCLCH   C HH [3IA0  HHuH [@SH HE HHIHCHD H Ht
H)uHAP0HD HKHCHD H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HD HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
ެ Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
l t=H# Hc
N H3HHCHCLCH    A HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _HB H HIhH)uHAP0HB HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _HB H HI`H)uHAP0HB HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _HA H HIXH)uHAP0HdA HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H@ H HIPH)uHAP0H@ HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _H?@ H HIHH)uHAP0H$@ HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H? H HI@H)uHAP0H? HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _H> H HI8H)uHAP0H> HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H_> H HI0H)uHAP0HD> HC03H\$0H _HA0H HA0@SH HHt
H [P  H= H HI(H)uHAP0H= HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _HO= H HI H)uHAP0H4= HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _H< H HIH)uHAP0H< HC3H\$0H _HAH HAy  H\$WH HH< HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H; HHIHCH; H Ht
H)uHAP0H; HK HC H; H Ht
H)uHAP0Hj; HK(HC(H[; H Ht
H)uHAP0H?; HK0HC0H0; H Ht
H)uHAP0H; HK8HC8H; H Ht
H)uHAP0H: HK@HC@H: H Ht
H)uHAP0H: HKHHCHH: H Ht
H)uHAP0H: HKPHCPH: H Ht
H)uHAP0Hh: HKXHCXHY: H Ht
H)uHAP0H=: HK`HC`H.: H Ht
H)uHAP0H: HKhHChH: H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu6   HH|$H8 LD$0HT$8HL$@I7 HH{HtHH  HLLD$0HT$8HL$@HH7 HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  HV9 E3H 8  HH	  H6 LHCHH6 HH H6 HC H6 H Hx6 HC(Hm6 H Hc6 HC0HX6 H HN6 HC8HC6 H H96 HC@H.6 H H$6 HCHH6 H H6 HCPH6 H H5 HCXH5 H H5 HC`H5 H H5 HChH5 H k y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [H HQ5 H HI`H)uHAP0H65 HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H4 H HIXH)uHAP0H4 HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H4 H HIPH)uHAP0H4 HCP3H\$0H _HAPH HAPH(Ht	H(nJ H
_1 H H	W3 H(H(AHA3 Hu;H: H h X        H
.[ AX   C~3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H2 H HI@H)uHAP0H2 HC@3H\$0H _HA@H HA@@SH HHt
H [hL Ha2 H HI8H)uHAP0HF2 HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H1 H HI0H)uHAP0H1 HC03H\$0H _HA0H HA0H(Ht	H(M H
/ HH H	1 H(H(A(0 Hu;HU8 H  T    0  0  H
W AT   {3H(@SH HHt
H [O H0 H HI H)uHAP0H0 HC 3H [HA H HA @SH HHt
H [(P HA0 H HIH)uHAP0H&0 HC3H [HAH HAH(Ht	H(P H
- H H	/ H(kQ H(Ht	H(Q H
?- H H	7/ H(H(IL$0/ Hu;H6 Hğ F P   И 
  
  H
R AP   !z3H(H\$WH HH/ HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H. HHIHCHq. H Ht
H)uHAP0HU. HK HC HF. H Ht
H)uHAP0H*. HK0HC0H. H Ht
H)uHAP0H- HK8HC8H- H Ht
H)uHAP0H- HK@HC@H- H Ht
H)uHAP0H- HKPHCPH- H Ht
H)uHAP0H~- HKXHCXHo- H Ht
H)uHAP0HS- HK`HC`HD- H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAuD* @  HH|$Hn, LD$0HT$8HL$@* HH{hHtHe  H @LD$0HT$8HL$@H* HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  H7- E3H 8  HHuH(H* HAH* H Hv* HA Hk* H Ha* HA0HV* H HL* HA8HA* H H7* HA@H,* H H"* HAPH* H H
* HAXH* H H) HA`H) H HH(H\$Hl$Ht$WAVAWH L3E( HHu'H0 H  =   + T     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHHq' u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_s T  
g T  H0 H9  =   H/u
HGHP0HtH+u
HSHR0D H
~  ys3tH\$Hl$VWAVH L3& HHu'Ht/ H ' =    qT     In3I+.HHtafIL$H() HHtiHGH9G ~HHOHHHHOHH
& u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^ yT  

 wT  H. Hߗ a =   H/u
HGHP0HtH+u
HSHR0D5 H
z  r3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H;}$ tgH;% t^IH& HHu/H- Hߖ A/   D^ S   H]  H@L   MuS T  2  HLL Mu8H# H9GuL;we  HGJL;wQ  J\HIHAHHJ  ILHt
H)uHQR0HHM  HHEH;t?HUHtLEL+Ih!HH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPH9% Hu`HUHMHHMHUHLEL+I ! ! ! ! ! A0   +T     !% LH   H
^" LI;   HH    }F      @t:I@   yA      @t3Ies
IIdII3& uZT  A/   H]H)+ HZ Dߍ m HtH/uHGHP0D K H
x n&! H/u
HGHP0HUIH]MtIm uIEIP0HtlHEH+HH;v5  H    H=   r<t  HCH;r	  H+Hs H'v HH7H]H   HUHHMH+H*HHHH?HH
H;v HRHH=   r<ts HCH;rc H+HsS H'vF HHb6IL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H; toH;  tfIH=! LHu/H( H A/   D~ S   Hu  H@H   HEPHuS  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H!iEHuQ! HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHM:RL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMQL}H]HuHt;HH]HEP7A0   S  H}@H?   H
QT  H
CT }  LH   H
 LI;   HH    }F      @t:I@   yA      @t3IY`s
IIF_II  udS  H}@H?A/   H% H Dz  MtI.uIFIP0DX  H
7s Bi8 I.u
IFIP0HUH}@HjL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hs H'vx HH1HH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H) H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH; twH; tnIHa HHu3H# H# A/   D  S  + H]L}g  H@H   HEHu"S  H]L}  HLHHMH]L}Hu8H' H9FuL;f$  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  H/HE   HE    E HHM?9HEHrDHHMH=   r0  HAH;  H+H  H'  H / H  HE   3H}@}IE3HUHM4HEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHM[LuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHM[LuH]L}Ht*HC   H{H{rHHHU  HL7H H]HM[HE4 - &    
  H
#N ] H
N O A0   MS  H}    HH   H L I;   HA    }@      @t4I@   yA      @t	3Zs
I
Y	I uZ=S  H}A/   H Hƈ DK ف HtH.uHFHP0D)  H
Pl c2c H.u
HFHP0HUH}HLuH]L}MtIm uIEIP0HMMtHInM+IMI!HHMH3-$H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
# H;E  H; 8  Hd HHu    @ R    H@L   HEo    HAHHt[HEo   HAHHtEHAH^yH
 H
Ć  R  UH+9  HCHP0*  H+u
HCHP03`u	HMosH< Hm  R      HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hdz H
 H	 2Mx-HI L
k" ILDHw H
 H	 2    ~ R    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I> Ht'~ R  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I  Ht@} R  "~    HW H D
~ } H
|h ^   HUHMHHUHMHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUI5HUHtLEL+IHUHtLEL+I3HUHtLEL+IWELmHUHtLEL+IMtI/u
IGIP0MtI.uIFIP0HUHtLEL+IaHUHtLEL+IIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;
 toH;\ tfIH LHu/H> Ho A/   D{ :R  w{ Hu  H@H   HEPHu<R  Hu  HLHHMPH]HuHu8H{ I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HQZEHu HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMBL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMBL}H]HuHt;HH]HEP7A0   gR  H}@H?   H
D  H
D  6 LH   H
s
 LI;   HH    }F      @t:I@   yA      @t3IPs
IIOIIH udWR  H}@H?A/   H4 He Dx xx MtI.uIFIP0Dx Vx H
b Y8
 I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v2 J    H=   r=@t HFH;r H+Hs
 H'v
 HH"HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H;+ 8  H HHu&w    v Q    H@L   HEo    HAHHt[HEo   HAHHtEHAHΉyH
 H
4} Jv Q  UH+9  HCHP0*  H+u
HCHP03Љu	HMoH H| u Q  Uv    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hp H
e H	< 2Mx-H L
 ILDH0n H
1 H	 u    ,u Q    H;u
Hz HrHrH~H6HHE3LLHHM(  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I Htt  R  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I=G Ht@0t R  t    H Hz D}t t H
,^ gU   HUHMuHHUHMeHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+IlHUHtLEL+ISHUHtLEL+I:WELmHUHtLEL+IMtI/u
IGIP0MtI.uIFIP0HUHtLEL+IHUHtLEL+IIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH;} toH; tfIH LHu/H Hx A/   D^r TQ  q Hu  H@H   HEPHuVQ  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HJHHEHHu. HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHM;L}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHMU;L}H]HuHtH;HH]HEP1A0   Q  H}@H   H
+; e H
; W  LH   H
 LI;   HH    }F      @t:I@   yA      @t3I3Gs
II FII udqQ  H}@HA/   H Hu DTo n MtI.uIFIP0D2o n H
AX P8l I.u
IFIP0HUH}@HL}HuHMtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;ro H+Hs_ H'vR HHnHH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH; toH; tfIHG HHu/H
 H	t A/   Dm P  m LuE  H@H   HEPHuP  Lu  HLHHMP=! H]LuHu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0H H9GuwuHH (EHf.zu2 HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHM6L}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHMY6L}H]LuHt3HH]HEPA0   Q  H}@H   H
.6 h H
 6 Z  LH   H
 LI;   HH    }F      @t:I@   yA      @t3I6Bs
II#AII udQ  H}@HA/   H Hp DWj i HtH.uHFHP0D5j i H
|R K8o H.u
HFHP0HUH}@HL}LuHMtIm uIEIP0MthM+IL;v J    H=   r=At IFI;rr L+Isb I'vU LIqHH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is H	 H3HD$hHHIK3t$ HA   HqHyrHH@0D$    HJH  H;t- u#LD$(HT$0H x,HT$0LD$(LGLD$(MtHW(Hk Hu>H Hn bh    g P  P  A   H
"Q =I   HD$`   Ht$XD$H HL$H+HT$HHHD$`HrQHHL$HH=   r<t HAH;r H+Hs H'v HHHL$hH3B
L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3 HHu'H Hm Ag =   f nP     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_f vP  
f tP  H Hl [f =   H/u
HGHP0HtH+u
HSHR0D/f H
N e G3tH(HyHQrH	 Hu;H HMl e 2   Ye P  P  H
M A2   F3H(H\$Hl$Ht$H|$ AVH L3 HHu'H Hk Oe =   d FO     In3I+.HHtgff     I HHtqHGH9G ~HHOHHHHOHH/ u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^3d NO  
'd LO  H Hj {d =   H/u
HGHP0HtH+u
HSHR0DOd H
K c 9E3r@SUVWAUAVAWH 3H\$`H\$hH\$pn LLxhLppHhxMtIMtIHtHE 	C   H  A  AM  Hj Dc D
0c H IMPHH;t;H   HB      tP9   DUc D
b AH
F ;DLL$pILD$hHT$`dNyc 
  b M  [H3m E3H
l tHHuzb M  'E33H#nH+u
HCHP0Qb N  b   H H\$`Ht$hH|$pH
i LMIIQHtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D?b H
H a )CH A_A^A]_^][MtI/u
IGIP0MtI.u
IFIP0HtHm u
HEHP0H A_A^A]_^][@SH H HH HIhH)uHAP0H HCh3H [@SH Hc HH HIhH)uHAP0HE HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH Hc HH HI`H)uHAP0HE HC`3H [@SH H# HH HI`H)uHAP0H HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH H# HH HIXH)uHAP0H HCX3H [@SH H HH HIXH)uHAP0H HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H HH HIPH)uHAP0H HCP3H [@SH H HH HIPH)uHAP0H HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH H HH HIHH)uHAP0H HCH3H [@SH Hc HH HIHH)uHAP0HE HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH Hc HH HI@H)uHAP0HE HC@3H [@SH H# HH HI@H)uHAP0H HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H# HH HI8H)uHAP0H HC83H [@SH H HH HI8H)uHAP0H HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH H HH HI0H)uHAP0H HC03H [@SH H HH HI0H)uHAP0H HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH H HH HI(H)uHAP0H HC(3H [@SH Hc HH HI(H)uHAP0HE HC(3H [H\$WH LJHL;
 HtrH; tiH
 LP0 MIH)< H	X H! Hb] V   nV B  B  H
:< A  7H\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH H HH HI H)uHAP0H HC 3H [@SH H HH HI H)uHAP0H HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH H HH HIH)uHAP0H HC3H [@SH H HH HIH)uHAP0Hu HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HA@SVWAVAWH`H H3HD$PL3H
	Y LHAH9kf u!H` HtH Hs` ]H
Y LH=Y HLGL HHX HHH
f H8` HtH Ht3HxHH$   Hu'H  HaY R l  mR RA    H 33H9Cu+H{Ht"HCHHHH H)uHAP0   HCH; uHIGHT$(HD$(DEHHH+H|$ Lt$0tHH   Q cA  
  H;    HKQ=   uwIGLT$@HD$@DEHL+H|$8Lt$HHA t3HKE3IHHugQ kA     H  H/  HGHP0   M HHuH
 H
X Q qA  VHtHx3IGE3HH IGHDEIHLtrHHuyP |A  H^ HW !Q l  H+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0DP H
5 gP 13#H.u
HVHR0H+u
HSHR0HH$   HL$PH3.H`A_A^_^[H\$WH0L
 E3H;E HHRHA3I;At   KMuH
w HM H	 +HBL% H
 HM MIHD$ H	J 3u/H

 H
NV O k  ZO 6A  3H\$@H0_HHH\$@H0_HUATAUAVAWHhH   HEHXHpHx HV H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIVHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU菇LEHUL+I3; HHu'H HU N h  !N @  -  IM;<       HEH;tIE3HHMH IE3HUHM|HE   H}E IE3HUHMXH HD$(HM HHt[HNH9N ~H HFH<HAHFHH  u H/u
HGHP0I;ܿ    >p:M A  
.M  A  H M h  HS H.u
HFHP0HtH/u
HGHP03DTM L H
1 >.LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t HAH;ro H+Hs_ H'vR HqHE'   H}E MtzIIM+IHL;v
 II   r=At IFI;r L+Is I'v LIIHM/H3cL$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx HF H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+I3+ HHu'H HQ J c  J @  -  IM;<       HEH;tIE3HHMH IE3HUHMlHE   H}E IE3HUHMHH HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p*I @  
I @  H yI c  HO H.u
HFHP0HtH/u
HGHP03DDI H H
- .*LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<to HAH;r_ H+HsO H'vB HaHE'   H}E MtzIIM+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3SL$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHID|HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`}HL$hH+L$XHHHLI?LHT$XHT$(HL$@ЖHL$@ƲHu;H HM F _  F L@  L@  A_  H
) h'HH|$@Ht2HT$HH|HL$PH+HHHLI?LHxH|$(Ht1HT$0H|HL$8H+HHHLI?LH<HL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHIzHL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`{HL$hH+L$XHHHLI?LHT$X_HT$(HL$@ HL$@Hu;H H[K D Z  gD ?  ?  AZ  H
' %HH|$@Ht2HT$HHL{HL$PH+HHHLI?LHH|$(Ht1HT$0H{HL$8H+HHHLI?LHHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx H֑ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIyHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU|LEHUL+I{3 HHu'HT HI C T  B ?  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH! HD$(HMC HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pA ?  
A ?  H? 	B T  HvH H.u
HFHP0HtH/u
HGHP03DA bA H
C$ "LHH.uHFHP0HEHrPHHMH=   r<ti HAH;rY H+HsI H'v< H[HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIyM+IHL;v II   r=Ats IFI;rc L+IsS I'vF LIbIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx Hƍ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIFtHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUwLEHUL+Ik3 HHu'HD HE ? O  > 2?  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM3 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p= <?  
= :?  H/ = O  HfD H.u
HFHP0HtH/u
HGHP03D= R= H
 LHH.uHFHP0HEHrPHHMH=   r<tY HAH;rI H+Hs9 H'v, HKHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIquM+IHL;v} II   r=Atc IFI;rS L+IsC I'v6 LIRIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIqHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUsLEHUL+I[3 HHu'H4 HuA : J  : >  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM# HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p9 >  
9 >  H 9 J  HV@ H.u
HFHP0HtH/u
HGHP03D9 B9 H
3 LHH.uHFHP0HEHrPHHMH=   r<tI HAH;r9 H+Hs) H'v H;HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIaqM+IHL;vm II   r=AtS IFI;rC L+Is3 I'v& LIBIHM/H3L$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHpHEH$   L3DHuXWEHuDދEHu3 LHu{7 C  7 ">    IFH;E tPH; tGII LHu6 (>  m  H@H   HEPHuY6 *>  J  ILHHEPHu8H I9FuM;~  IFJM;~  K\HIIHHV  ILHt
H)uHAP0HIEL   H> IMtA HH   Hu H9Gu:HwHt1H_HHHHH)uHAP0L*> HH_PH> HUHHtH.u
HFHP0HtwH/u
HGHP03IL$I9L$ ~HID$HHAID$HI u!H+HEPHCHP0HEP5 ^>     5 [>  3   4 M>      LH   H
1 LI;   HH    }F      @t:I@   yA      @t3Is
IItII    \4 E>  HH 4 C  H!; I,$uID$IP0MtI.u
IFIP0HtH+u
HCHP0HtH/u
HGHP0L}X   I.u
IFIP0MIHMʬHMH;t$HH]HHHMHHHMH0HpHpH]HMHtHUlLEHUL+Im Ht$H H2: 3 D  >3 l>  aHUHMgHUHMڛHHM@HIuȉMP HuAc3 F  2 >  H~ H9 H]D@3 2 H
/ *HH]MtI/u
IGIP0MtIm uIEIP0HHttHUHkHEH+HH;v HH=   r<t HCH;r H+Hst H'vg HHH]HtsHUHkHEH+HH;v/ HH=   r<t HCH;r H+Hs H'v HHHH$   HpA_A^A]A\_^]H\$Hl$Ht$H|$ AVH H: LHIH3DE]9HHu1 :  	1 V=  |  3H; @3H; 3H;: uH y,1 :  0 X=  X  H+u
HCHP0e  Hb7 H H-X7 H	9 HHEL   MtA HHu0 =  G0 m=    H 3H9Gu7HwHt.H_HHHHH)uHAP0MF0HHJIV0HXOHHtH.u
HFHP0Hu50 =  / {=    H/u
HGHP0H
5 HOHHu/ =  / ~=  !  H+u
HCHP0E33H;H/u
HGHP0/ =  9/ =    HU9 A   INHV7HHux/ >  / =  u  H؅yQ/ >  . =    H/u
HGHP0   IN(L I;u7H
 L, H9 H	X . >  |. =    H7 DHHu. >  O. =    3H;
 H(uH@P0  HZ6 H H-P6 H6 HHEL   MtAs HHu- =  J  HU 3H9Cu7HsHt.H{HHHHH)uHAP0MF0HH@HIV0HLHHtH.u
HFHP0HuD- @  Y- =  H H+4 H   H+   HCHP0   H+u
HCHP0H
2 HrLHHu9d- @  , =  H H3 HtaH/u[HGHP0OH/u
HGHP0E33Hd8H+u
HCHP0, =  , @  H HZ3 D, H
d
 f, 
HtHm u
HUHR03
H H H\$0Hl$8Ht$@H|$HH A^HUATAUAVAWHhH   HEHXHpHx H6z H3HE'HHMWE3HEDHEDDEHEEHEHE   HEE3r LHu'H HL2 + 3  X+ <    Hs8HFH; tlH; tcIH4 HHu+ 3  + <  L}^  H@H   HEHuhU+ 3  * <  L}-  HE33HEfHu8H H9FuL;~Z  HFJ<L;~F  J|HIHHH  ILHt
H)uHAP03ID$L   H2 IMtA LH  3H I9Fu:I^Ht1I~HHILH)uHAP0LZ2 HHDHF2 I>IHHtH+u
HCHP0H   I.u
IFIP0E3IMI9M ~HIEH<HAIEHI/ u(H/HEHGHP0HE3  ) 3  7) <  M  ) 3  ) <  L}i  t) 3  ( <  LM   LH   H
5 LI;   HH    }F      @t:I@   yA      @t3I s
IIxII
 u( 3  Z( <  E3E  	 H.u
HFHP0MIHM2HMH;t0HH]HHHMHHHMH     H@    H@    H]HMHtHUaLEHUL+Ioɾ Ht'HM H. ( 4  ' <  N  HUHR@HMܖHMH;t0H0HuHHHMHHHMH     H@    H@    HuHMHt5HUM^HMH+MH*HHLI?LHU Ht'H H- R' 4  & <    LEHUHM:3 LHu'HG H- 
' 5  & <  D  H]H;]\  HEH;tIE3HHM
H HMH}HCMHUa LHB  ILHt
H)uHQR03IFL   Hq0 IMtA~ HE3H   Hh H9Gu:LwMt1HwIHHHH)uHAP0L. IHR@H	. HEHMtI.u
IFIP0E3HtfH/u
HGHP03IMI9M ~HIEH4HAIEHI uH.HFHP0% =  `	% =  T$ <  HH H+ O% 2   $ P  P  A2   H
 *3$ <  E3% 5  H: H{+ Im u
IEIP0HtH.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0H]HuD$ 6$ H
g E3H]HuMtI/u
IGIP0MtI,$uID$IP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   HE    E H   HUHZHMH+H*HHHH?HH
H;v HRHH=   r=@ti HFH;rY H+HsI H'v< HHXHt~HUH[HEH+HHH;v HH=   r<t HCH;rֵ H+HsƵ H'v HHH]HtHUHo[LEL+IHIHM'H3-L$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`H) HAL   MtA Hu;H
 HK( ! &  W! <  <  H
  A&  3H({HAPH HAPHAPH HAPH\$WH0HIXE33x>HHu?HI H
 A   H}' ;  D    3H\$@H0_H2 HH) H9Cue: HHu\H޽ A   ;  H' D  '  H+uHCHP0D|  
  H
K f3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHH   HEH$   LWEE3L}EL}PL}L}0HEL}L}HEEH
1% HAH9>3 u!H/ HtH H/ ^H
) MH=) LGHw HH$ HHH
2 H/ HtH HtIH1DHHu'HR H%     :  T  HCL   H! HMtA HHu   Y :    H+u
HCHP0HFL   H' HMtA HHu'H H$ k    :    H.u
HFHP0IHV H9Cu6HsHt-H{HHHHH)uHAP0MHHD8IH<HHtH.u
HFHP0IHu   [ :    H+u
HCHP0HGH H;   H;{    H$ LHu
 ;     H/u
HGHP0IFH   MIHHtRA   IHHt?IH"0y     ;  
  M)&   IFI   I.u
IFIP0M(0uI<1   P (;    HOHtc~A   H H
 H	 
Hx0 ;  H g   H" H/  HGH  H;u
Hw H_H_HsHHHH/u
HGHP0LHuPHHM
 HHEH;tJHUHRHMHMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHM HEH@HEH HEH@L}H}HHHM HHEH;tJHUHRHMLHMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUXHM謻   DBoHM:LMLEHUHM@HIaXHHM赉HUHtLEL+I<WEL}H  HHH9
& u&H%, HtH H5, +H
M$ h?L+ H& H
1$ 5HHu'Hm H  0    S;  o  HFL   H{  HMtA HHu*H HZ     f U;  M   H.u
HFHP0HMHHu3 X;  M   IH H9Cu6H{Ht-LsHIHIH)uHAP0LHI3HHB8LHtH/u
HGHP0MH.u
HFHP0IMu| g;     H$ He HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0D 9 H
 H+u
HCHP0MMtIm u
IEIP0HMPHtH)uHAP0LEMM HUPHM   DBoHMzLEMM HUPHM貹   DBoHMPHUHtLEL+IvIH$   HĀ   A_A^A]A\_^]HWATAUAVAWH  H@HXHp HHWP3H`D$XHt$hD$@Ht$PHpHhH;8 tOHtJHD$pHD$0H$   jL%| u]HG H 
    d:    H$   H$   H H$   H$   L%| L$   HHL$p脨HL$XH;t%HHL$XHHHL$`HHHL$hH0HpHpHT$pHtL$   L+I Ht'H H H    o:    LD$XHT$pHObQHL$@H;t%HHL$@HHHL$HHHHL$PH0HpHpHT$pHtL$   L+IeHT$@H$   蒀H
; HAH9+ u!H/ HtH Hx/ ^H
o MH=f LGH HH HHH
|+ H=/ HtH HtHH;:HHu'H\ H     :    HCL   Hj HMtA HHu'H HI    U :  D  H+u
HCHP0H$   LHu'H H    	 :  
  HHz H9Gu6H_Ht-LHIHIH)uHAP0MHIh.IH3LHtH+u
HCHP0I.u
IFIP0Mu$H HX    d :  kH/u
HGHP0H$    2  H$   I;HDH$   H$   >   3L%Hy ދHtH+u
HCHP0HtH/u
HGHP0 HLxPLhXH@`H$H  HsPHsXHs`H$    t-H$   I;HDH$   H$    H$H  HKPLsXH{`L{PLkXHC`Ht
H)uHAP0MtI.u
IFIP0HtH/u
HGHP0D   H
1 |LHT$@HtLD$PL+IHT$XHtLD$hL+IҴH$   HtL$   L+I谴IL$  I[0IsHIA_A^A]A\_H\$WH0LRHHp HL;u   ^HuH

 Hv H	] >I#t   -H
Y L> IBLJH[ HD$ H	ͦ 3u/H
 H
 S    E:  3H\$@H0_HHH\$@H0_sHL$AUHpHAE3H H\$hAHt$XL   H|$PALd$HEL|$8LLl$ L$   L$   L$   MtA Hl$`HLt$@Hu*H LH u    8    HFIH;l u4HnHt+LvHHE IIH)uHAP0HI /IH; uE33Hx21H;_ uHF@t3Hy0H E3HU1LHtHm u
HEHP0IMu   8 8  
  H.u
HFHP0I.u
IFIP0IGIH L   MtAn Hu*Hz LH :    9  
  H
 HD$ HAH9 u!H" HtH H5" ^H
 MH- HLE HHO HHH
 H5" HtHM HtIH3HHu*H LH | 	   9  
  HFHH L   MtA\ HHu6 	  
 9  \  H.u
HFHP03 HHu'H, Hm 
 	  y
 9  8  IO(H;
 u0H
 H H	h 
 	  <
 9    Hh 3'HHu
 	  
 9    H@IH;K t_H; tVHM HHu>
 	   !9  d  H@L   Mu%
 	   #9  ;  HHMMH/uHGHP0fD  Mu>H H9CuL;s   HCJ<HI)L;s   J|HIHAHH  H$   H$   Ht
H)uHAP0H HH H9Gu% HH   HNH9N ~H HFH<HAHF!HH[ 
 	   I9  #
  IH+u
HCHP0H IH9E   H]H   LuHHIIH)uHAP0LHI%m 	  
 G9  	  
 HzHJ HHot Y: 	  
 ?9  `	  HH*LHtH+u
HCHP0H.Iu
HFHP0Mu'H HV 
 	  b
 Z9  !	  Hm u
HEHP0H
- ML$   HAH9$ u!H HtH H- _H
V NH5M HLFh HH HHH
$ H- HtHE Ӡ HtIH!/HHu*HB LH 
 
  	 g9    HEHH L   MtA HHu'H H, 	 
  8	 i9    Hm u
HEHP03
 HHut	 
   l9    H$   HI(H;
> u0H

 H> H	 /	 
   p9  U  H "HHu	 
   r9  (  H@H;̜ t\H; tSHp HHu 
  L x9    H@L   Mu% 
  # z9    HHMMH+u
HCHP0Mu>HF H9GuL;g   HGJHI)L;g   J\HIHAHH  H$   H$   Ht
H)uHAP0HD HH
 H9Cuw! HH   HMH9M ~H HEHHAHE'HH  
   9    IH/u
HGHP0Hr IH9F   H~H   LvHHIIH)uHAP0LHIU!m
 
   9  3   HzHԚ HHt' Y 
  N 9    HH%LHtH/u
HGHP0Hm Iu
HEHP0IMul 
   9    H.u
HFHP0H
 ML$   HAH9\ u!HK HtH H5< ^H
 MH- HLE HHk HHH
 H5 HtHi HtIH*HHu'Hآ H    % 9  4  HFHH L   MtA{ HHuU    9  {  H.u
HFHP0HC IH9Eu6HuHt-LuHHIIH)uHAP0MHI.IH#LHtH.u
HFHP0Mu'H H.    : 9    Hm u
HEHP0IL$   MH)uHAP0Hb 98   HL$  HHu'Hw H
 :    9    IΛ Hu'HA H
     9    H;t7H
= H	 H HF
    R 9  a  H
.	 HAH9[ u!Hb HtH H-S _H
b
 NH5Y
 HLFt HH HHH
 H- HtHE ߙ HtIH-(HHu'HN H	  
   9    HEHH` L   MtA HHu'H H;	  
  G 9    Hm u
HEHP0    HHu 9     IH@L0I$HEL`Hr H9Fu6H~Ht-LvHHIIH)uHAP0LHI`HH!LHtH/u
HGHP0Hm Iu
HEHP0IM   i :   
  H H1 HtH.u
HFHP0HtHm u
HEHP0HtH/u
HGHP0HtH+u
HCHP0L$   L$   DQ H
   ;H.u
HFHP0IMHL$ Lt$@H|$PHt$XHl$`H\$hHt
H)uHAP0MtI/u
IGIP0L|$8MtI,$uID$IP0Ld$HMtIm u
IEIP0H$   HtH(u
HPHR0IHpA][HHPHHATH   E3HXHhAHxALhELpELxEL` HAH Ld$PLd$xL   Ld$pLd$XMtA  H$   HHu'H HB    N 7  Y  HGIH; u6HwHt-HGHHHH H)u
HAP0HHHmIH;d uE33H!1H; uHG@t3HH E3H HD$`HtH.u
HFHP0Ht$`L$   Hu'H H`    l )7    H/u
HGHP0H.Iu
HFHP03, HHu'Hś H     57    H$   HI(H;
R u0H
! H H	 C    97  
  H HHu    ;7  
  H@H; toH;/ tfHHD$`{ H$   Hu   R A7  ^
  H@H   HL$hHu3   $ C7  0
  HLH$   H\$`Ld$hH\$`HL$   H/u
HGHP0HuHH) I9FuI;^w  IFH<HHH\$`-I;^X  I|HHH\$`IHH  HL$XHH|$XHt
H)uHAP0H
I IHAH9
 u!Hb
 HtH L-S
 _H
 NH	 HLC LH HHH
O
 L-
 MtIE  HtMHE!LM  IEIH L   MtA, HH  Im u
IEIP0HH HH. H9Eu{ LH,  H
@ HAH9 u&H HtH L5} rH
t  aH-f HLE LH  HHH
 L5= Mt
IHl$X% Ht
Hl$XMH1 Hl$XLMl  IFIH  L   MtA LH"  I.u
IFIP0H0 HH  H9Euc LH  H L$   I9GuBIoH$   Ht1IGIHE LH H)u
HAP0IMHHIIMH$   HHt
H)uHAP0I.u
IFIP0MH  I/u
IGIP0    LH  H
 E3LhHMHh PHH  I/u
IGIP0HŎ MH9Cu6L{Mt-H{HIHHH)uHAP0LIHHHcHMtI/u
IGIP0Hm Mu
HEHP0IH   H+u
HCHP0HNIH9N ~HHFH<HAHFHH=    H/H\$`Hl$hL$   |HGHP0mII.u
IFIP0H$   HH\$P  H H v     7  
  ]    7    D    7    +    7        7        7       j s7  s     Q p7  Z     8 n7  >      l7  "  |    i7  	  c   I g7     HH' HHLtz f   I _7    tH(  H$   HH(H;
Ԍ u>H
 H H	{ H H5    A 7  L  H 8HHu'H H |    7       F H$   Hu 7  I  HE3H
* HHXHp HHu 7  I  H$   H)uHAP0HFH;Љ tbH; tYHIp H$   LHuN 7  IA  H@H   H$   Hu.$ 7  I  HLH$   MIL$   H.u
HFHP0IINH$   LfD  Hu<H I9FuM;~=  HJ4HI'M;~$  J4HIIHH  HFH# H;   H; tHh HHZ  H.u
HFHP0HEHMH   HH  HA   HH  HHiz  L)u uGHEH;HNH  H;u
H^ H~H~H_H?HHH.u
HFHP0IH|$xLHt
H)uHAP0H$   IH$   H$   Ht
H)uHAP0IEIH; tKH; tBIHD HHX  H@L   Mu(    G8    IE IIMfMu>H< H9FuH;n   H^HHH)H;n   H\HHHAHH   HL$pH\$pHt
H)uHAP0IEHHpHtHAHt
HIHI$HH  L$   HxHH  H+u
HCHP0HT$pLII؉ I  H/HGHP0I+ Ht H0 HHUH   H.u
HFHP0H$   IH$   L$   H$   H$   H MHN M   MT *8    Hm u
HEHP0IuIH MH Mx   M 28  .  \   M "8  MM   :    E8  +  !    w8  C    t8  -    r8     i b8  IH MH5 MH$   MH$   IY~H
 Hz A   H	 
Hx 
8  g   MMMIH H HtH.u
HFHP0HI  H/?  HGHP00   Ht H HH   ? I.u
IFIP0H\$PHLL$   L$   L$   H$   H$   H$   HtH+u
HCHP0HL$xH$   Ht
H)uHAP0H$   Ht
H)uHAP0HL$pHt
H)uHAP0HD$XHtH(u
HPHR0IH   A\ 8      H% MHc MMIH$   Ht
H)uHAP0MtIm u
IEIP0HtH+u
HCHP0HtHm u
HEHP0MtI.u
IFIP0MtI/u
IGIP0H\$PDU H
  ?nH\$Hl$VWAVH@HG IHzLH\$pHM   HtH   HZH\$pH HHu-H  H HLB HtHHD$pHH   H HHD$(LL$pH" H|$ y
6     H\$p   H   H   H9 H|$0HHk H?L
D HL HHDHHD$(H HL$ LIH
 H# H	J 6  H HO i    A  H
z 3HZHIBH\$`Hl$hH@A^_^HHPHHATH   H E3HXAHhAHpAHxLhEHALd$hLd$pLd$PL   L$   MtA( L$   HL$   Hu'H! Hb    n 5  
  HGH;ހ u4HoHt+LwHHE IIH)uHAP0HI
IH; uE33H
1H;у uHG@t3HH* E3HLHtHm u
HEHP0MMu    H 5  	  H/u
HGHP0I.Iu
IFIP03g LHu*H  HH>    J 5  	  H$   HI(H;
 u&H
Y H H	1  5    H; HHu 5  ^  H@HH;(~ Hl$XtMH;r tDH LHu 5    H@H   HL$`Hu 5    HLILd$`H/u
HGHP0HD$`Hu>H} I9GuI;o\  IGH<HH(I;oB  I|HHIHH   HL$hH|$hHt
H)uHAP0H~ HHP H9Gu
} HH   Hz~ HH` H9Gu| HHtgH/u
HGHP0INII9N ~HIFHHAIFHI} uH+HCH3 6     $ 6      
6      HtHV| HH{tY| I/u
IGIP0H$   IL$   詥ydHN H     6  "   6  IH H[    I.u
IFIP0Ha  tIMv  34| LHu'H̈́ H     #6    H$   HH(H;
Z} uAH
)~ H2 H	} Hz IH :    '6    H   HHu'H< H}     )6       | HHu'H HC    O +6  g  IE3H
 HLpHX HHu 36    H/u
HGHP0HCH;Kz thH;{ t_H{ HHu'Hp H 3    :6    H@H   Hl$`Hu' <6  I  HHLd$XILd$`HH+u
HCHP0HuHHy H9GuH;w^  HGHHHHt$X-H;w?  H\HHHt$XHHH  HCHz H;%  H;?y   Hz HH  H+u
HSHR0HNIMH   HH$   MHz  HA   LHc  HH?  L)6u
HFHP0Hl$`HL$pH$   H\$pHt
H)uHAP0HL$PL$   L$   Ht
H)uHAP0L$   HM4HHQ  IOI9O ~eH IGHHAIGdHKHc  H;u
Lk HCHCLhH H$   H IE H+6HCHP0'HI-x    H+tH$   Ht$XHD$PHCHP0H$   Ht$XHD$P% 6    H.u
HFHP0IuI 6     y6    Ho IH$   H H$   HD$P    6    H0 IH$   Hf H$   HD$P   e 6  h  ~,H
?x H A   H		x 7 d6    Hx  d6     y Ht H_v HH脸   v H/u
HGHP0H$   ML$   L$   L$   H$   H$   H$   HtHm u
HEHP0HL$hH$   Ht
H)uHAP0HL$pHt
H)uHAP0HD$PHtH(u
HPHR0IH   A\& X6  IL$   MH$   r   H~ H HtH/u
HGHP0MtI/u
IGIP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtH.u
HFHP0D H
λ ` H\$Hl$VWAVH@Hw IHzLH\$pHM   HtH   HZH\$pH+v HHu-H  H3 HLB>t HtHHD$pHH   H HHD$(LL$pH H|$ Xy
5     H\$p   H   H   H{ H|$0HH H?L
 HLѹ HHDHHD$(Hr HL$ LIH
Bv H H	t 5  H| H  K   A  H
 53HZHIH\$`Hl$hH@A^_^ATAWH(HAE3Hz EH\$@Hl$HHL   MtAt Ht$PHH|$XLt$ Hu'H{ H    " 4    HCIH;s u3H{Ht*HsHHHHH)uHAP0HHDIH;;v uE33H 1H;v uHC@t3HH E3HyHHtH/u
HGHP0IHu'H{ HC    O 4    H+u
HCHP0H.Iu
HFHP03r HHu'Hz H k    5    HM(H;
=s u&H
t H% H	r  5    H HHu 
5    H@H;p tLH;.r tCHHr HHue 5    H@L   MuF 5    HHIMH+u
HCHP0Mu>Hip H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0Hqq HH H9Cuo HHtEHNH9N ~H HFHHAHF5HHp !L 85     = 65     :r HtH~o HH裱tfo H/u
HGHP0HLH.u
HFHP0Lt$ H|$XHt$PHl$HH\$@MtI/u
IWIR0IH(A_A\ .5  H8x Hy    H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D H
o A 褻LHWATAUAVAWH   H@HXHpMLLW@E3LxD$`L|$pD$HL|$XD$0L|$@H
 HAH9 u!H) HtH H ^H
 MH= LGHm HHQ HHH
 H HtHOp HtIHHHu'Hv H     ]4     HCL   H HMtAao HHu'Hjv H -    _4    H+u
HCHP0IHn H9Fu6H^Ht-H~HHHHH)uHAP0MHHIHHHtH+u
HCHP0IHu'Hu H     n4    H.u
HFHP0HGL   H HMtAUn HHu'H^u H !    q4  a  H/u
HGHP0HH$   iHHL$HFH$   HtL$   L+IPzZn Ht'Ht H    + t4    H.u
HFHP0IHT$HHL$x<BIÀu2m Ht'Hxt H ;    4    HT$xH$   6CDLH$   IMn
HHL$0EH$   HtL$   L+I`yHT$0HL$`AH
9 HAH9n u!H HtH H= ^H
m MHd LCHj HH HHH
" H=s HtHl HtIH9HHu'HZs H     4    HGL   Hh HMtAk HHu'Hs HG    S 4  	  H/u
HGHP0HL$`pLHu'Hr H    
 4     IH{j H9Cu6H{Ht-HsHHHHH)uHAP0MHHiIHHHtH/u
HGHP0I.u
IFIP0Hu$Hr HY    e 4  3H+usHCHP0gE3AAAHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0Dk  H
 UIHT$0HtLD$@L+IvHT$HHtLD$XL+IvHT$`HtLD$pL+IvHT$xHtL$   L+IpvHL$   I[0Is8IA_A^A]A\_H\$Hl$Ht$WATAUAVAWHPHj E3Ld$@MH\$HHLAM   LzIMt"HtH   HZ H\$HHzH|$@Ii HIMtHt*UH ILBg HD$@HH   HH,  H ILBf HtHHD$HHH   H IHD$(LL$@Hy L|$ y
+4     H\$HH|$@   HBH   H   HNHQn HHL$0Hu HLL
[ AHD$(IH HLd$ H
h L LMH> H	eg ;4  H)o Hj     A  H
 в3HZ HzLHI6L\$PI[0Ik8Is@IA_A^A]A\_HHHATAUAWH   H@HXHpHx MMLW@H@    @H@    H
 HAH9 u!H HtH H= ]H
 LH LCHe HHo HHH
 H= HtHmg Ht3HHHu'Hm H    * 3  /  HGL   H HMtAf HHu'Hm H L    3    H/u
HGHP03H8e H9Cu6H{Ht-HsHHHHH)uHAP0MHH&IHHHtH/u
HGHP03Hu'Hl H$    0 3     H+u
HCHP0HFL   H HMtAve HHu'Hl H B    3    H.u
HFHP0H|$ HHL$h`HHL$8=HT$hHtLD$xL+Iuqe Ht'Hl HD    P 3  @  H+u
HCHP0HT$8HL$Pd9I@@u2e Ht'Hk H a    3     IƋÀu2d Ht'HZk H     3     HT$PHL$h:DDHH$   HIc HH   Hj H6    B 3  JHt$ HHHtH.u
HFHP0HtH/u
HGHP0HtH+u
HCHP0D[  H
ʥ E3HT$8HtLD$HL+IoHT$PHtLD$`L+IoHL$   I[(Is0I{8IA_A]A\H\$ UVWATAUAVAWH`H H3HD$XH-c E3H5a MLt$@HHl$HLHt$PM4  LbIMt1Ht"HtH4  Hr(Ht$PHj Hl$HLrLt$@Ib HIMtHt3HtZ   H ILB` HD$@LH   HHw  H ILB_ HtHHD$HHHJ  H ILB_ HtHHD$PHH  Hg IHD$(LL$@Hq Ld$ y
3     Ht$PHl$HLt$@   HBH   H   H   HSHg HHT$0A   H
Hn HLL
! HL$(   H
a H;AML HHD$ H	H MML &` 3  Hg H+ E    A  H
 葫3Hr(Hj LrLLIIHL$XH3mH$   H`A_A^A]A\_^]@SVWATAVAWHxH# H3HD$`L3H
 MLHAH9 u!H HtH H=v ]H
E LH< HLC] HHE HHH
 H=; HtHC` Ht3HHHl$pHu'Hf H q    2    HGHH L   MtAQ_ HHu 2    H/u
HGHP0HCHH L   MtA_ HHu'Hf HO    [  3    H+u
HCHP0H] 33H9Gu+H_Ht"HGHHHH H)uHAP0   HGH;g` uIHT$(HDEH+H\$ HLt$(L|$0Ld$8HH    3    H;u`    HOQ=   uxLT$HHDEL+H\$@Lt$HL|$PLd$XHA t3HOE3IHHuC 3     H  H+  HCHP0   Mc] HHuH
d H
   3  ZHtHX3IE3HHLtEIL|EI$LdHHuy .3  H6d Hw    H/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0D H
 ? 袧3#H.u
HVHR0H/u
HWHR0HHl$pHL$`H3	iHxA_A^A\_^[H\$Hl$Ht$WAVAWHPH!\ MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I[ HHHtHt/ZHR  Hs ILBY HtHHD$@HH%  H ILBY HtHHD$HHH   H9 IHD$(LL$@H}l Hl$ y
2     H|$HH\$@   H   H   H   H
 Hl$0HL
 H?LP HH
 HHLIH
g HL$(H
[ HD$ H	Z 2  Ha H 0    A  H
 |3Hz HZLHI"H\$pHl$xH$   HPA_A^_H\$Hl$Ht$WAVAWH HMH
 MHHAH9 u!HY HtH HJ ]H
I LH=@ HLGW HHI HHH
~ H HtHGZ Ht3HHHu'H` H z    q2    HCHH L   MtAZY HHu s2  D  H+u
HCHP0HGHH L   MtAY HHu'H` HX    d v2    H/u
HGHP0V HHu7 y2     H[ LHV y {2     H% LHV y |2  jH MHfV y }2  GH MHCV y ~2  $H LHyHHud 2  H_ HQ    H+u
HCHP0HtH/u
HWHR0D H
 . 葢3#H+u
HSHR0H/u
HWHR0HH\$@Hl$HHt$PH A_A^_@SUVWATAVAWH`H" H3HD$XH=W MH-I LH5 LrH|$@IHl$HHt$PM2  Mt1Ht"HtH>  Hr(Ht$PHj Hl$HHzH|$@IyV HIMtHt8Ht_   H  H5 ILBxT HtHHD$@HHt  H ILBKT HtHHD$HHHG  H ILBT HtHHD$PHH  H IHD$(LL$@HBf Lt$ 8y
@2     Ht$PHl$HH|$@   M   H   H   H   H{[ Lt$0IHb H?L
 HLK HHHDMHD$(H0 HL$ LIH
 V Ha H	T T2  HL\ H  	 y  Ay  H
 3Hr(Hj HzLLHIHL$XH3eaH`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   H MtAT H|$PHHuX v   1  k  _R HHuŽ 1        T HHuH
>[ H
  1  lILLxHH 	R yk 1  4H+u
HCHP0H LH/HHuf5 1  HZ H  v  H.u
HFHP0HtH/u
HGHP0H   H+   HCHP0uH.u
HFHP0H/u
HGHP0HCHHHpHtHAHt
IHIHSHu= w  r 1  HZ HD Dɼ H
> P 賝LL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAH L   MtAPR Ht$0HHu?HTY H
= As  H 1  D  3Ht$0H [HCH|$83H;P u3H{Ht*HsHHHHH)uHAP0HHIH;S uE33H1H;S uHC@t3H H? E3HHHtH/u
HGHP0H|$8HuaHcX As  1  H D  HtH+uHSHR0D  H
 3Ht$0H [H+u
HSHR0HHt$0H [K@UAVH(H\$@3H|$PDL|$ LH
 HAH9 u!HV HtH HG ^H
 MH= HLG@N HH HHH
 H HtHP HtHHHHt$HHu'HW HW ٹ o  c 1  d  HCHHX L   MtAO HHu o   1    H+u
HCHP0HGHHr L   MtAcO HHu= o  Ǹ 1    H/u
HGHP0H+N HH9Cu6H{Ht-HsHHHHH)uHAP0MHHIHHHtH/u
HGHP0Hu o  0 1     H+u
HCHP0H
 LHAH9 u!H} HtH Hn ^H
u MH=l HLG?L HH HHH
 H3 HtHN HtHHHHu'HU H[ ݷ p  g %1  h  HBuyA p  @ '1  HT H H/  H+%  HCH  H+u
HCHP0.  HFHH] L   MtAVM HHu'H_T H " p   *1     H L HH9Gu:H_Ht1HwHHHHH)uHAP0Lҹ HHH HHHtH+u
HCHP0HuR p   81  HS H HtH/u
HGHP0D_ H
  IH/uHGHP0HHL|$ H|$PHt$HH\$@MtI.u
IVIR0HH(A^]KH\$Hl$WH HH
G HAH9 u!H; HtH H, ]H
 LH= HLGI HH HHH
 H HtHK Ht3HHHHt$0Hu'HdR H ' l   0  h  HCHH L   MtAK HHuu 0     H+u
HCHP0HGHHʺ L   MtAJ HHu;H/HQ H  l  
 0     HGHP0   H/u
HGHP0HaI 3H9Cu6H{Ht-HsHHHHH)uHAP0LHHMHH HHtH/u
HGHP0HuTq 0  HQ HC ų l  HtH+u
HSHR0D H
އ 0 蓔3H+u
HSHR0HHt$0H\$8Hl$@H _{@USVWATAUAVAWH$H8  H% H3H(  E3LEMHT$PLLL$XH  AHT$xEHL$@AI HHAHq LmLmL   LmH\$8LmLmLmLmLmLmLmLmLmLmLmLl$pLl$HLl$0MtAH HHu'HO H b 1   v*  LF  HGH;\G u3H_Ht*LwHHIIH)uHAP0HIIH;J uE33Hi1H;PJ uHG@t3HjH E3HFLHtH+u
HCHP0IMu*HN LH
  1   *  D  H/u
HGHP0I.u
IFIP0H
H H9L$X  L;A  H
 HAH9W u!H HtH H= ^H
 MHݷ HLCD HHf HHH
 H= HtHdG HtIHHHu*HM HH  3   *  }D  HGHH L   MtAsF HHu*H|M LH < 3  Ư *  C  H/u
HGHP0H*E IH9Cu:H{Ht1LsHHIIH)uHAP0LT HIH@ HLHtH/u
HGHP0Mu*HL LH
  3   *  C  H+u
HCHP0I.u
IFIP0H
BE H9L$x  L;=xD A  H
 HAH9 u!H HtH H aH
ߵ PH=ֵ HLGB HH_ HHH
 Hu HtH]E HtE3AHHE3Hu*HK HH  5   *  pB  HCHHյ L   MtAfD HHu*HoK LH / 5   *  A  H+u
HCHP0HC IH9Gu:H_Ht1LwHHIIH)uHAP0L HIH{ HLHtH+u
HCHP0IMu*HJ LH | 5   *  @  H/u
HGHP0I.u
IFIP0H
2C E3H|$PH;   Lt$@IF(H;uAH
C H} H	B H3J HHq  8  } +  @  H HqHu*HI HH3  8  ? +  @  H/HHD$Pi  HGP0]  H
 HAH9: u!HY HtH L5J ^H
 MH HLCC@ LH HHH
 L5 MtIB HtMHLMu*HI HH\ ޫ 9  h )+  ?  IH? ؃u 9  I9 ++  @  I.u
IFIP0t\   @ HHu*HH HHܱ ^ :   7+  H?  HHH@HT$PH8H/uHGP0Lt$@H
 HAH9= u!H HtH H=ݺ ^H
T MHK HLC> HHT HHH
 H= HtHRA HtIHHHu*HG HH  ;   P+  k>  HGHH  L   MtAa@ HHu*HjG LH * ;   R+  =  H/u
HGHP0HCHH L   MtA? HHu*HG LHA é ;  M U+  8=  H+u
HCHP0IN(IH;
? uAH
Q@ Hz H	)? HF LH b ;   Z+  <  H HHu*HdF LH $ ;   \+  <  IN(H;
> uAH
? H~z H	> HF LHT ֨ ;  ` `+  6<  HD WLHu*H
E LH
  ;  " b+  ;  H= MEL|$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;0@    HD$PHU`HE`EFAHHH+LmXH]hLepkLHu* s+  HE LHP ҧ ;  <;  MtIm u
IEIP0H+L|$Hu
HCHP0I,$W  ID$IG  H;? uyHOQ=   ufHD$PL   H   EFAHL+LmxH   L   HAI uHOE3ILHJ }+  AN< LHu*H
D LH
Y ۦ ;  e +  ;:  HD$HHt	IEL|$HHL$PE3AIHILAFI\HAFIMdMLHu*HC MHެ ` ;   +  9  Im u
IEIP0H/u
HGHP0HL$PIMLt$PH)uHAP0H\$xH;; uM: Hu-HC MH] Hܥ =  f +  9  H+HHD$xuHCP0Ll$@IM(H;
; uDH
c< HDw H	;; HB MH Hq ?   +  9  H LHu-HsB MH H0 ?   +  8  IM(H;
; u0H
; Hv H	:  ?  } +  :  H tHHuƤ ?  P +  9  HI?: HD$0HHu ?   +  9  I.u
IFIP0H/u
HGHP0H
ک MH]L|$0HAH93 u!H HtH H= ^H
 MHy HLC8 HH HHH
 H=ȷ HtH: HtIHHHu*H@ HH-  @  9 +  U7  HGHH. L   MtA9 LHu0H@ IH֩ LU @  Mܢ +  6  H/u
HGHP0IFIH L   MtA"9 HHu @   +  8  I.u
IFIP0H7 MAH9Gu+LwMt"HGHIHH H)uHAP0   HGH;: uSHEHU HE DCHHH+LuLeHD$0HH   N @  ء +  e7  H;:    HOQ=   u|HELUHEDCHL+LuLe HAI uHOE3IHD$0HHuϡ @  Y +  6  MtI.u
IFIP0M   K~7 LHu @   ,  6  MtLpMHME3HT$PHILCHHITIHD$0HHu* @   ,  D6  I,$uID$IP0H/u
HGHP0H+u
HCHP0H
^ L|$0HAH9 u!H HtH H=v ^H

 MH HLC4 HH
 HHH
 H=; HtH7 HtIHYHHuK B  ՟ ,  b5  HGHHʢ L   MtA+6 LHu B   ,  5  H/u
HGHP0ID$IH L   MtA5 HHu B  8 ,  4  I,$uID$IP0IM(MH;
k5 u0H
:6 Hkq H	5 \ B   $,  v4  H ݸLHu/ B   &,  I4  IM(H;
5 u0H
5 H)q H	4  C  | 2,  4  H` sLHu-H; IH2 L C  ; 4,  2  IM(H;
4 u0H
R5 Hp H	*4 t D   @,  3  Hr HHuG D  ѝ B,  d3  HE3 ML|$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;5   HD$PH   H   EGAHHH+L   L   L   H   HD$0Hu B   [,  2  MtIm u
IEIP0E3I,$L|$HuID$IP0I.u
IFIP0H+u
HCHP0Lt$0H/u
HGHP03Lu1 HD$0LH  H: IH\$8HT ֜ G  ` ,  |0  H;5    HOQ=      HD$PL  H   EGAE3HL+L   L  L  H  HAA uHOE3IHD$0Hu7 B   f,  T1  MIm IEIP0AO1 HHu'H
9 H
Y ۛ B  e o,  1  MtLh3HD$HLl$PE3AHHLdAGLtAGH\AGIE E3ELlALHu'H8 Hס Y B   ,  .  H.HFHP0H\$@HK(H;

1 uFH
1 Hm H	0 H-8 IH\$8Hf  G  r ,  .  H iHHu/H7 IH\$8H#  G  / ,  K.  HK(H;
w0 uGH
F1 Hm H	0 H7 IHՠ MT G  Iۙ ,  -  H7 ҳHHu-HS7 IH M G   ,  p-     / HHu*H7 MHQ ә G  ] ,  3-  H
 E3HHxHp &HHu*H6 MH  G   ,  ,  H+u
HCHP0HFH;A-    H;.    HI. HHu,HZ6 H\$8H  G   ,  ,  H@H   H|$hHu;H6 MHW ٘ G  c ,  N,  HHML|$hIH.uHFHP0D  Hu>H|, H9CuL;k  HCJ4HI(L;k  JtHIHHH.  HFH- H;   H;,    H- HD$`LH#  H.u
HFHP0ID$IHL$`E3EL   AHH  HL$`EfALH  Ld$`IAH譪T  I,$uHID$I;HNH  H;u
Lv H~H~LwH?HIH.u
HFHP0HMH}Ht
H)uHAP0HMIHEHtH)u
HAP0IHH, Lt$0HHb  INI9N ~H IFH4HAIFHI$+   H.A    H|$hHFHP0IH+u
HCHP0HMLuMT  H3 H\$8H d I   -  
*  K G  Օ ,  h+  HL$`H)uHAP0HD$`    huI|Ld$` G   ,  +  H3 HX ڕ G  d ,  O)  H2 E3H.  G  : -  %)  H2 E3H  G   -  (  ~H
* HK A   H	* 
Hx踩Hq2 MH 1 G   ,  (  + HjH( HHktK) IH2 MHU ה G  a ,  L(    H
7 HAH94 u!H HtH H ^H
 MH= HLG}( HH HHH
 Ha HtH* HtIH7HHu,HX1 H\$8H  J   -  '  HCHH͜ L   MtA) HHu*H0 MH=  J  I -  4'  H+u
HCHP0H( IH9Fu3H^Ht*H~HHHHH)uHAP0HH[H葳LHtH+u
HCHP0Mu,H]0 H\$8H  J   --  &  H.u
HFHP0Ll$PIIH\$8IEH;&    H;(    HIH|$`X( HD$0LHu'H/ H  K  ! >-  =&  H@H   HD$XHuCH/ H٘ [ K   @-  &  IE IHD$XMLl$0IL|$`LmM H\$8HuHH% I9FuI;~  IFH4HHH|$`-I;~  ItHHH|$`IHH  IHuLHt
H)uHAP03!& HH8  LEI@HHpHtHAHt
IIII辭HH  H@H;/% tSH;~& tJHI& LH  H@H   H|$hHu- M  I }-  "&  HLML|$hIH+uHCHP0Hu>H$ I9FuM;n  IFJHI(M;n  K\HIIHHi  HL$pH\$pHt
H)uHAP0H
ٕ IHAH9 u&HJ HtH H=; lH
 %[L=| IMG$ HH HHH
 H= HtHE3!& HtE3AI˴E3HH"  HGHHN L   MtA% LH  H/u
HGHP0ID$IH L   MtAm% HH}  I,$uID$IP0HH$ MAH9Gu/LgMt&HGHI$HH H)uHAP0   DHGH;& uaHD$pDAHE0HU0HD$@Le(H@(HE8HHH+%HH`
  MtI,$uID$IP0E3E  H;&    HWDBA=   urHD$pLUHHEHDYHD$@E3Le@H@(HEPAHL+HBA uHOE3MIHH  MtI,$uID$IP0M|# HD$HHH  MtL`E3HD$pE3HT$@H JDHB(H HB(HJD HHH  HL$HH)uHAP0E3L|$HH/u
HGHP0HNIH9N ~HHFHHAHFHH!   H+H|$hRHCHP0C# Ht H  HHcm  @! I.u
IFIP0HMLHuHt
H)uHAP0H
4 IHAH9 u!H HtH L5v ^H
e MH\ HLCw  LH HHH
 L5; MtI" HtMH1LM}  IFIH L   MtA" HH0  I.u
IFIP0H  IH9Cu6H{Ht-HsHHHHH)uHAP0MHHIH蓪HHtH/u
HGHP0H  H+u
HCHP0HMLHuHt
H)uHAP0H|$xIH& HHGL   MtA0! HH  H  IH9Cu3H{Ht*HsHHHHH)uHAP0HH˩HHHtH/u
HGHP0HX  H+u
HCHP0LmHI`  ؅xA؅  H.u
HFHP0I  IFIHΌ L   MtA?  HH
  H|$xHGHHpHtHAHt
IHIHKLH	  H IH9Cu6H{Ht-HsHHHHH)uHAP0MHHۣIH莨HHtH/u
HGHP0I.u
IFIP0H  H+u
HCHP0HMLHuH)uHAP0O HH  MIH< @  HMLHuHt
H)uHAP0HL$8IHp HAL   MtA HH
  H IH9Cu6H{Ht-HsHHHHH)uHAP0MHH赢IHhHHtH/u
HGHP0H#
  H+u
HCHP0H.u
HFHP0H|$@IHO(H;
   H 袡HHc  H@HH L   MtA LH  H+u
HCHP0H II9Fu;I^Ht2I~IHLHH)uHAP0MHH象H|$@II_HHtH+u
HCHP0IH`  I.u
IFIP0HMHH]Ht
H)uHAP0HO(IH;
 
  H{ 莠HH
  H@HHpHtHAHt
HHHHHH5
  H.u
HFHP0HMLH]Ht
H)uHAP03 HH	  A   HI HH~	  H.u
HFHP0HIC-	  H+u
HSHR0t'    H  Hp HHHHIII.IHHEuIFP0HUH
L 迤LH     0 HHZ  H@HHL0! HH  H+u
HSHR0HMH}Ht
H)uHAP0H\$8HCHHpHtHAHt
IHIH胡LH}  H@IH L   MtA
 HH0  I.u
IFIP0    LH  HHx HH  Lw HH]  m  LIHHH:  H+u
HCHP0I.Iu
IFIP0H.u
HFHP0HL$8LII   H/u
HGHP0LuI Hq  HA@ǅtpE3IAQ)HHk  H> A   H舋HH#  H/u
HGHP0HA  H.u
HVHR0Lt$0H|$`HD$XCH
܈ HAH9 u!H HtH H=	 ^H
 MH5 HLF" HH HHH
Ŏ H=Θ HtH HtIHܧHH   HGHH L   MtA LH  H/u
HGHP0LD$8I@HHpHtHAHt
IIII连HH]  Hd I9Fu6I^Ht-IvIHLHH)uHAP0LHHRHIHHtH+u
HCHP0H/Iu
HGHP0IH  I.u
IFIP0H\$8LHI
 Lt$0g  H.H|$`HD$XnHFHP0HD$XZH Lt$0Hڇ \ M   {-    C L  ̀ -  `  * L   -  G   L   -  .   L   -    ߀ L  i -    ƀ L  P -     L  7 -     L   -    { M  I -    H Lt$0Hʆ L P   @.    Hb Lt$0H   P   1.    H6 Lt$0Hr  P  ~ /.  ~  H
 Lt$0HF  V  R .  R  H Lt$0H  [  & 
/  &  H H u [  ~ /    H Lt$0Hǅ I [  ~ /    H_ H " \  ~ ./    	 \  ~ +/  &  ~ \  Iw~ /  
  H IHA ~ \  M~ /    H IH ~ \  #~ /  #  H Lt$0H m~ [  } .    H HĄ F~ Y  } .    -~ Y  } .  J  ~ Y  I} .  .  } Y  I} .    H Lt$0HG } Y  S} .  >  } Y  I7} .    H Lt$0H } Y  } .    H Lt$0HӃ U} W  | .    <} W  I| .  V  HO Lt$0H 
} W  | .    H# Lt$0H_ | V  k| .  V  H Lt$0H3 | V  ?| .  ?  H Lt$0H | V  | .    H Lt$0Hۂ ]| T  { .    Hs Lt$0H 1| T  { .    H
 H O H	 H0 Lt$0Hl { T  x{ .  x  { S  I\{ .    H Lt$0H$ { S  0{ .    H Lt$0H z{ S  { .    H
( H!N H	  Hy Lt$0H 7{ S  z .    HM Lt$0H { R  z q.    H! Lt$0H] z R  iz c.  i  H Lt$0H1 z Q  =z X.  =  H Lt$0H z Q  z V.    H Lt$0Hـ [z O  y #.  
  Hq Lt$0H /z O  y  .  
  HE Lt$0H z O  y .  
  H Lt$0HU y N  ay .  L
  y N  IEy -    H Lt$0H
 y N  y -  
  H H hy M  x u-    H~ H Ay L  x k-     HtH
 HH1Ot_
 I.  IFI  H H[ x K  gx [-  l  3J
 LHu,H H\$8H x ^  +x V/  G  H\$@MHD$8HK(H;
f uCH
5 HK H	
 H H\$8H~ Dx _  w d/    HB~ őLHu,HF H\$8H~ x _  w f/    I LHu,H H\$8HD~ w _  Pw h/  l  I.u
IFIP0MIMT
  @ H
	} HAH9Ɗ u&HŊ HtH H5 rH
 XaH HLCJ HH| HHH
u H5v Ht
HH\$@%
 Ht
H\$@IHH\$@HHy  HFHH{y L   MtA LH  H.u
HFHP0IFIHy L   MtA HH  I.u
IFIP0I LH3  Hc IAH9Fu.H~Ht%HFHHHH H)uHAP0   DHFH;   HC(DAH   H   HD$XH   HHH+H   L   /HD$0HH/  HtH/u
HGHP0E3I.Iu
IFIP0Lt$XH.u
HFHP0HMIH]Ht
H)uHAP0HD$@HH(H;
1 }	  H| ώHD$0HH9	  E33HaHHK  H+u
HCHP0HMHH]Ht
H)uHAP0IIM2     HD$@HH(H;
   Hz =HH  E33HԑLHm  H.u
HFHP0IH\	 HH  I.u
IFIP0H+HHuuHCP0H
y HAH9 Y  H H@  H L5   H;N    HVDBA=      HC(L   H   DYHD$XE3H   AHL+H   L   HBA uHNE3MIHD$0HH  HH/HGHP0#	 HH  HtHx3HL$@E3NtHLt$XHA(H HA(HJD INt(oHD$0Hj  H+u
HCHP0H\$0E3FH
| MH| HLC LHx HHH
z L53 MtI	 HtMHiLMI  IFIHw L   MtAP HH  I.u
IFIP0H- MH9Cu7LsMt.HsHIHHH)uHAP0LEIHHUHɐHMtI.u
IFIP0MH:  H+u
HCHP0HFHH/x L   MtA HH  H.u
HFHP0HMIH]Ht
H)uHAP0H
v HAH9% u&H{ HtH H{ lH
z [L5z IMF HH_v HHH
Ԋ H{ HtHL!Z HtILI襕LHH  HCHHXs L   MtA HH|  H+u
HCHP0   2 HH+  H
s H   @ ff     HHH@HuLEHs(I@HHpHtHAHt
HIHI=HH  H+u
HCHP0HL$8HI1tA  H.u
HFHP0IIM;I  H\$@H Hu 3Dfo `  n /    Ko `  n /  b  Ha MHu Io d  n /  ~  H4 MHru In d  {n /  Q  H IHEu Ln d  MKn /  !  H
o H8B H	G H IHt M}n d  Ln /    H MHt Pn f  m ,0    Hf MHt &n f  m )0    H< MHzt m f  m 0  \  H MHPt m f  \m 0  2  H
 MH&t m f  2m 0    H
 MHs ~m e  m 0     H
 MHs Tm e  l 	0     Hj
 IHs M'm e  l /     H=
 IH{s Ml e  Il /  ZH
 IHNs Ll c  MTl /  -H	 H$s l b  0l /  MILt$0HtH/u
HGHP0HtH+u
HCHP0H\$8MtI,$uID$IP0HL$HHt
H)uHAP0MtI.u
IFIP0HtH.u
HFHP0E3D l H
? k L  H	 HOr k b  [k /  &H
 H? H	W H IHr Mk b  Lk /  H E3Hq `k `  j /  Hv Hq 3DHD$0/k `  j /  ]HH MHq Ik `  Mj }/  bj `  sj z/  L|$0MIH H:q M'I.IFIP0H MHq Ij `  M
j w/  H MHp IVj `  Mi u/  H
o HAH9~ u!HU} HtH HF} ^H
s ML5s IMF HHmo HHH
2 H} HtHk  HtII蹎HHu-H MHp Mi g  !i 70  HCHHFm L   MtAw LHu*H MHo @i g  h 90  H+u
HCHP0H. II9Fu;I^Ht2IvIHLHH)uHAP0Ll$8HMHLl$8IIHHtH+u
HCHP0IHu*H MH	o h g  h H0  I.u
IFIP0Im IHuIEP0HLHMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HtH+u
HCHP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$pHt
H)uHAP0HL$PHt
H)uHAP0HD$xHtH(u
HPHR0IH(  H3K	H8  A_A^A]A\_^[]H\$ UVWATAUAVAWHpHm H3HD$`H=V MH5 HL5 LLzH|$@IHt$HLt$PH|$XM}  Mt@Ht1Ht"HtH  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@I HIMtHtBHtiH      H  H_d ILB HtHHD$@HH  HZe ILBu HtHHD$HHHx  H=d ILBH HtLHD$PHHK  Hc ILB HtHHD$XHH  H{4 IHD$(LL$@H L|$ 5ry
!*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
^] L|$0IL
_ H?L,5 HH_ HMLIH
s HL$(H
 HD$ H	 8*  HI Hj c d   A  H
4 D3&Hj0Lr(Hr HzMHl$ LHIvHL$`H3YH$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMHe L   MtAi H|$0HHu'Hm  Hi 0c   b )         HHub )  sHE Hh HHuH
  H
Ri hb )  QHa MH yEb )   LHHHHuy#b )  H Hh wb   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0D6b H
2 a  C33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt/ZHR  H_ ILB& HtHHD$@HH%  H_ ILB HtHHD$HHH   H0 IHD$(LL$@H Hl$ ny
)     H|$HH\$@   H   H   H   H
ZY Hl$0HL
{[ H?LX0 HH}[ HHLIH
o HL$(H
 HD$ H	 )  HE Hf _ `   A  H
0 @3Hz HZLHIBH\$pHl$xH$   HPA_A^_LATAVH   H H3H$   HE3H;s LI[ AIkIsAI{AMkEM{ELD$8LHT$ HL$0Ld$(  3 HHu'HU He _   ^ 9(  b  IN(H;
 u0H
 H2- H	 ^   e^ =(  (  Hi^ \xHHu'H
 H
e ^   *^ ?(    H@H;j tsH; tjHI
 HHu'H
 H
d N^   ] E(    H@H   HL$@Hu' ^   ] G(  m  HHMLd$@H/u
HGHP0HD$@Hu>H H9CuL;s  HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0Hc IL;tIexVnHMH9M ~IE HEL,HAHEKIH~ 7 ]   \ m(  m  ]   \ k(  T   HtH HH2t6% H+u
HCHP0HD$ HHl$ H(  H@  \   !\ c(     H
a HAH9q u!Hg HtH H-g dH
d NL5d IMFC HHa HHH
p H-g HtHE  HtIIHLD$ Hu'H HYb [   e[ (  %	  HI Du<[   8[ (  H H
b Hm   HEHP0  Hm u
HEHP0Et[    HHu'Hx Ha ;[   Z (    HL$ HT$ HH@HH)uHAP0H
` HAH9%s u!Hj HtH Hj ^H
4e MH=+e HLG HH4` HHH
r Hbj HtH2 HtIHHHu'H H` dZ   Y (    HCHH\ L   MtAD HHuZ   Y (    H+u
HCHP0HGHHb L   MtA HHuH H8` NY (    H/u
HGHP0Hl$0HM(H;
 u0H
P HY( H	( rY   X (  X  H Y rHHuEY   X (  +  HM(H;
 u4H
 Hw( H	 H7 Hx_ X (  #  Hr` rLHukX (    H MALd$(H9Cu0LsLt$(Mt"HCHIHH H)uHAP0   HCH;{    HD$ HT$PHD$PDEHHH+Lt$HH|$XL|$`zHHuHc H^ W (  O  MtI.u
IFIP0H/Ld$(u
HGHP0I/u
IGIP0Lt$ H+u
HCHP0IHl$ LH)uHAP0H
/] HAH9p }  H'f Hd  H Hf   H; uHKQ=   ulHD$ LT$pHD$pDEHL+Lt$hH|$xL$   HAI uHKE3IHHH: H{] V (  )M HHuDtV (  H
 H
F] V   H  H/  HGHP0  Mt	LpLd$(Lt$ E3HHILtEH|EL|MwHHuVV   U (  <  H.[HFHP0LH
` MH=z` HLG HH[ HHH
 o Hd HtH HtIHzHHu*H IH.\ U    :U (    HCHHY L   MtA HHuT )  MM  H+u
HCHP0HFHHW L   MtAA HHu'HJ H[ 
U    T )  +  H.u
HFHP0H IAH9Cu+HsHt"HCHHHH H)uHAP0   HCH;    HD$0H$   H$   DGHD$8HH$   HH+H$   H$   vHHuS )  M)  H  H.  HFH  H;t    HKQ=   urHD$0L$   H$   DGHD$8H$   HL+H$   H$   HAI uHKE3IHH^&S )  MxOh LHuS $)  [HtHpIHL$0E3HT$8HILGHE HIlGHITItHH   R 2)  S    H0 HqY HtH+u
HCHP0MtI/u
IGIP0HL$(Ht
H)uHAP0HtH.u
HFHP0DR H
%" 'R 3Lt$ #I/u
IGIP0H+u
HCHP0LL$   H$   H$   H$   H$(  MtIm u
IEIP0L$   MtI.u
IVIR0IH$   H3H   A^A\H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I> HHHtHt/ZHR  HP ILBF HtHHD$@HH%  HO ILB HtHHD$HHH   H IHD$(LL$@H Hl$ 3^y
'     H|$HH\$@   H   H   H   H
zI Hl$0HL
K H?LL HHK HHLIH
 HL$(H
 HD$ H	 (  He HV O "P   A  H
 13Hz HZLHIBH\$pHl$xH$   HPA_A^_AVAWH(H1X E3H\$@H|$XLl$ LH H
"U L=X HAH98m u!HO_ HtH H@_ ^H
S MH=S HLGa HHT HHH
l H_ HtH HtIHtHHl$HHt$PHu'H2 HsU N   N d'    HCHHtY L   MtA HHu'H HU N   +N f'  &  H+u
HCHP0H IH9Gu6H_Ht-HwHHHHH)uHAP0MHHzhIH-mHHtH+u
HCHP0Hu'H9 HzT M   M u'    H/u
HGHP0H.Iu
HFHP0    HHu'H HT M   )M '  N  IEIH IEHEIE H IE HE IEHP L   MtAa HHuL '     HC IH9Cu3HsHt*H{HHHHH)uHAP0HHkH'mHHtH.u
HFHP0HuXL '  -H+u
HCHP0    HHux)L '  H HR }L   Hm u
HEHP0HtH+u
HCHP0HtH/u
HGHP0D;L H
 K %-CHK LH HCHk H{(H H H HC0H H H HC8Ll$ H|$XHt$PHl$HH\$@MtI/u
IWIR0IH(A_A^@UAWH8HBE3H;b AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH; t[HH HHu'HY HQ K   J &    H@L   Mu^J &    HIIMMu>H H9GuH;w  HGHHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHIfHHtFLHI tH+BHCHP03J   I '     I   |I '     y LH   H
 LI;   HHD9   }F      @t:I@   yA      @t3I!s
IIII ugH &  GI   Hl HO HtH/u
HGHP0HtH+u
HCHP0DI H
 H ) B H/u
HGHP0L= ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Ht$ AVH H6L E3H\$0E3HHl$8H
<H H|$@HHu1H5 HT HN H   HG `&    HXHH
P HL HAL   MtA HHu'H H3N G   ?G o&     H IH9Cu4H{Ht+HkHHHHE H)uHAP0HH`fHgHHtH/u
HGHP0Hu-Hb HM %G   F }&  H   zH+u
HCHP0HHn   HHu$H HRM F   ^F &  BH<HHuMH HM F   *F &  H+u
HCHP0DF H
 F i'&H+u
HCHP0HLH/u
HWHR0H.H|$@Hl$8H\$0u
HVHR0IHt$HH A^HT$SVWATAVH Lq333L9Ypt3H A^A\_^[Hl$PLl$`L|$hMu*H E3H#L E   /E %     LHu'H HK pE   D %  Z  IFHHHu-H
! L* H> H	 D  &    HAH;  tWH;O tNH HHuH
$ H
eK {D &  ~  H@L   Mua\D &  Q  H3E3H@ Mu>H H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA HHtNH+u
HSHR0IVLI3 uH/HGHP0@C 2&  5  1C /&  &  H
e L
 H/= H	 C ,&      Ht HE HHj    H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$pILl$`H A^A\_^[B "&  3H HH ZB   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D B H
m
 A "H\$Hl$Ht$H|$ AVH HE HH
A E3=HHuH~ %  H   H
? HxHH5K L5I H-H  HHtzHIH_HG3HGt GpHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`HGh H+u
HCHP0HG%  H H;G U@ @   A  H

 !H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtHrH  HH [?H [@SH HYHtHrH  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@MG  LbIMt4HtH2  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@I HIMtHt*LH= ILB HD$@HH   HH= ILB HD$HHHtNHH  H
 IHD$(LL$@H Ld$ Ky
9%     H\$HH|$@   H
 H` HD$0   L
D9 HD$(Lp
 H99 HD$    H	W 5%  OHzt}HFL
9 H
 L`
 HD$0H8 H HD$(H	HD$     F%  H HD =   = A  H

 q:HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HD$xHE3L|$0L|$8+$HD$0L|$ L|$($HD$ EEL$   AL$   EHCHu'H HB x<   < 3$  Y  Hn  LkL$   Lc Ld$PIE I$Ll$XLd$`IH
A HAH9G u&HG HtH HG lH
^F `[H5PF LFH HHYA HHH
G HG HtHI!T HtIIH`IHHu*H HA ;   
; ^$  M^  HCL   H= HMtA] HHu'Hf HA );   : `$    H+u
HCHP0HFL   H<D HMtA HHu'H HCA :   O: c$  l  H.u
HFHP0IH H9Cu6HsHt-H{HHHHH)uHAP0MHHTIHQYHHtH.u
HFHP0IHu'HZ H@ :   9 r$    H+u
HCHP0HGH/ H;>  H; 1  Hp LHu'H H2@ 9   >9 $  F  H/u
HGHP0IIFL   MIAHHtrA   IAHHt^IAHPLy4Hu H? 89   8 $  L$   Ld$P  M).   IFIP0   I.u
IFIP0M8LuILMH HF? 8   R8 $  L$   Ld$P8  HOHtR~A   Hw3 H
 H	 
HxLH H> _8   7 {$    H;u
Hw H_H_HsHHHH/uHGHP0
Ld$PL$   LH$   L|$PH$   HHL$@&  HHD$0H;tTHT$0HRHL$0HD$0H@HD$0H HD$0H@L|$8HL$0HHD$0HHL$8HCHD$8HKH|$@HWHL$@HD$@H@HD$@H HD$@H@L|$HH|$@HXHHL$@[  HHD$ H;tTHT$ HRHL$ HD$ H@HD$ H HD$ H@L|$(HL$ HHD$ HHL$(HCHD$(HKLD$@MM H$   HL$@m   DBoHL$@Iu27 Ht'H H< ~6   6 $  _  H  YH$   LD$ HT$0HtH$   HAHG  E3H? H
@9 WHHu'H< H}< 5   5 $     E33H/AH+u
HCHP0H H9< 5   E5 $     Ll$XLd$`H$   H$   H$   H$   H\$PHHLHtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0MtI.u
IFIP0L$   H$   D	5 4 H
  AMMtIm u
IEIP0MtI,$uID$IP0MtI.u
IFIP0HtH.uHFHP0LD$ MM H$   HL$ %   DBoHL$ LD$0MM H$   HL$0   DBoHL$0AHĀ   A_A^A]A\_^[H\$Ht$WH IHHMt-I H~H]>uH\$0Ht$8H _HHHH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH   H@LE3L|$pL|$xL$   L$   L|$PL|$XHD$PL|$@L|$HtHD$@L$   L|$hL$   AW$   L$   H
\8 HAH9K u!H@I HtH H51I ^H
= MH= LCH HH8 HHH
K H5H HtH HtIH\WHHu*H} H8 @2 x  1 !  M8  HFL   H4 HMtA HHu'H& Hg8 1 x  s1 !    H.u
HFHP0HCL   H: HMtA HHu'H H8 1 x  1 !  Q  H+u
HCHP0IHp H9Fu6H^Ht-LvHIHIH)uHAP0MHI^KIHPLHtH+u
HCHP0IMu'H H[7 0 x  g0 !    H.u
HFHP0IIFH H;  H;   I- HHu'H
 H
6 q0 x  / !    I.u
IFIP0HGL   MHAHHtbA   HAHHtNHAHCy'H5 Hv6 / x  / !    L)'   HGH   H/u
HGHP0ICuIDH H6 / x  "/ !  O  INHtR~A   HT* H
 H	 
HxCHy H5 </ x  . !    H;u
I^ IvIvH^H6HHI.u
IFIP0Ht$pH$   IH\$xH$     HH$   3A  HH_HH$   (  HHD$03A(  HH`H$   H   E3H6 H
x1 OHHu*Ht H4 7. |  - 1"  M/  E33Hd9H+u
HCHP0H- Hn4 - |  z- 5"  M
  H   E3H5 H
0 ;OHHu*H H4 - ~  )- Q"  M
  E33H8H+u
HCHP0H H3 X- ~  , U"  MP
  H H$P  H5 HH9GuF Hu*H: H{3 ,   , g"  M  H$   H
X2 HAH9}8 u!Hl9 HtH L5]9 ^H
3 MH3 LCH LH2 HHH
18 L5"9 MtI
 HtMHXQLMu*Hy H2 <,   + s"  M4  IFL   H3 IMtA HHu'H" Hc2 +   o+ u"    I.u
IFIP0HCH;    H; t~HHD$ LH3 LHu*H H1 w+   + |"  I@  H@L   Mu<Hz H1 =+   * ~"  
  LHMMHD$ H+uHCHP0D  Mu<Hܾ L|$(I9FuM;f   IFJM;f}wK\HI	  IAHHD$(H  B HtEH HH tپ 'H H0 k*   ) "  
  I.u
IFIP0LOL;
 tUH;=$ tLMIL Hx H
 H	p H9 Hz0 )   ) "  M	  HL$   I!  HT$pHL$0  HHD$PH;tTHT$PHRHL$PHL$PHIHL$PH	HD$PH@L|$XHL$PHHD$PHHL$XHCHD$XHKH|$0HWHL$0HD$0H@HD$0H HD$0H@L|$8H|$0H4HT$xHL$05  HHD$@H;tTHT$@HRHL$@HL$@HIHL$@H	HD$@H@L|$HHL$@HHD$@HHL$HHCHD$HHKLD$0MM H$@  HL$0G   DBoHL$0H  qH$@  LD$@HT$PHfLHD$0H   E3H1 H
]+ IHHu*HY H. (   ' #  M  E33HI3H+u
HCHP0H HS. '   _' #  M  IL$@  H$X  H;= 4  3 LHu*H H- {'   ' $#  Ms  HGH;B txH; toH HHu'Hg H- *'   & *#    H@L   Mu:H0 Hq- &   }& ,#    HHIHL$ MHMu=H H9CuH;KV  HCH4H;KB  HtHHHL$ HAHH$@  H  H$   LH$   Ht
H)uHAP0IIEL   H;. IMtA8 HH  MH" H9Gu;LoMt2HwIE HHHH)uHAP0L- IH@H- HDHMtIm u
IEIP0Ht|H/u
HGHP0IHI  u3H.HL$ HFHP0HL$ IL$@     Hp H+ 3%   $ `#    HI H+ %   $ ]#    H" Hc+ $   o$ O#    l HtEH HHt 'H H+ $   $ G#  4  H+u
HCHP0L|$(ML$   MvIu*H H* D$   # n#  M<  H$   Ll$0IYHxHH$   H+HL;   IH$   腜HH$   襋H$   Ȋb Ht*H H'* #   3# y#  M  H$   H$   ΋HIeL$   H$   LII%YH  Hu*Ho H) 2#   " #  M*  LHD$hI}  HHu'H- Hn) "   z" #    IL$8H)uHAP0I\$8MtI	S(  IMtIT$@   LHu'H H( t"   ! #  o     > HHu'Hw H( :"   ! #    LpI$L` @  E3H$   HL$pL$   Ll$xL|$hEH$@  H\$(  E3H$   HL$pL$   Ll$xH\$(_  H$   LH$   HtH)u
HAP0LIIAL   H3( IMtA HIHu'H H' I!     "     HG H9Fu3H~Ht*H^HHHHH)uHAP0HH?H.AHHtH/u
HGHP0IHu$H H8'     D  "  _H.u
HFHP0H+H$P  HCHP0yH$   HT$pE3H$   AHT$xL|$hMIIMtI.u
IFIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Ld$hD } H
^  IHL$pHt
H)uHAP0HL$xHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0MtI,$uID$IP0H$   HtH)uHAP0H$   Ht(H$   HWL$   L+IH4LD$@MM H$@  HL$@膿   DBoHL$@LD$PMM H$@  HL$PE   DBoHL$PHH   A_A^A]A\_^[H\$UVWAVAWH`HQl H3HD$XH5: WHt$PMHD$@Mq  LzIMt3Ht"HtHg  Hr(Ht$PHB HD$HHjHl$@Hl$@I HIMtHt0HtKvH ILB HD$@HH   HH ILB HD$HHt{HHv  H ILBi HtHHD$PHHI  H! IHD$(LL$@H} L|$ *y
q!     Ht$PHl$@  H
ǳ H, HD$0   L
  HD$(L H HD$    H	# g!  xHBH   H   HCH 3HD$0HL
 Lp HHH HD$(HL$ LMH
! H H	 !  Hm H" 0 r   Ar  H
 3!Hr(HB HjHD$HLD$HLHoHL$XH3肾H$   H`A_A^_^]H\$Ht$WH H
*! HHAH9' u!H& HtH H=& ]H
" LH5" HLFm HH  HHH
& H=& HtHٱ Ht3H(@HHu'HI H!  p   !     H2 H9CuHH HHuH
 H
@! V !  .E3HH.<HHurHϷ H! & !   p  H/u
HGHP0HtH+u
HSHR0D\ H
  F3H\$0Ht$8H _H/u
HWHR0H+u
HSHR0HH\$0Ht$8H _+@UVWATAUAVAWHl$H0  HEH$  Hg H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@ HD$8ELd$HL#Lc HD$P   AAAWEWMEHE   LeDeIEH; tsH;Z tjILd$XI LHD$`Hu'H" Hc  i  o g     H@H   HD$hHuoK i     MLl$`IE Ld$X3HD$hfD  Hu=Hl I9FuM;f  IFJ<M;f  K|HILd$XIHHz  ILH}Ht
H)uHAP03H 98uIG      7  IEHHpHtHAHt
IIII54HH  H@L   H_ HMtA HH  H/u
HGHP0HCL   H HMtA{ HHA  H+u
HCHP0IEHHpHtHAHt
IIII|3HH  H@L   Hf HMtA HH  H+u
HCHP0    HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHMHHM#wHUHtLE L+IWEH] HUHtLEL+IϬ H  IHMHHM螈HM Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
8  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8H]HUHK@BhHKXHULt$`L}Ld$XLmHD$h9Hz H
 H	  j  6    33v   l      ]  v l       D  ] k      +  D k        + k      3    k      3    k      3    k  d    33   ] LH
  H
 LI;   HH    }F      @t:I@   yA      @t3Is
IIIIo        33# i  HH H MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
 #H\$pc I.u
IFIP0HD$8H\$pH;t>HHRHvHH@HH HH@HC    DD$0HT$8H'qMtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<tޤ HAH;rΤ H+Hs H'v HлHE   HE    E HUHtLEL+I#HUHtLEL+IZLD$8MM HUHL$8   DBoHL$8HHM(H3޳H$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  H^ H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@HD$8ELd$HL#LcHD$P   AAAWEWMEHE   LeDeIEH;; tsH; tjILd$XI֥ LHD$`Hu'HR H  W       H@H   HD$hHuo{     MLl$`IE Ld$X3HD$hfD  Hu=H I9FuM;f  IFJ<M;f  K|HILd$XIHHz  ILH}Ht
H)uHAP03H@ 98uIG      7  IEHHpHtHAHt
IIIIe+HH  H@L   H HMtA HH  H/u
HGHP0HCL   H HMtA HHA  H+u
HCHP0IEHHpHtHAHt
IIII*HH  H@L   H HMtA3 HH  H+u
HCHP0   ܣ HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHMߕHHMpHUHtLE L+IWEH] HUHtLEL+I H  IHMHHMHM5ϣ Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
h  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8SH]HUHK@vHKXHUvLt$`L}Ld$XLmHD$h9H H
C H	  X  f   33v   Z  I    ]   Z  0    D   Y      +  t Y  
     [ Y  
   3   @ Y  
   3   % Y  
   3   
 Y  
   33    LH
  H
ʞ LI;   HH    }F      @t:I@   yA      @t3I s
II
II    	   33S
 W  Hx H MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
 H\$pc, I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8HiMtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   HE    E HUHtLEL+ISHUHtLEL+I:LD$8MM HUHL$80   DBoHL$8ͽHHM(H3H$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH   HEHX)p)xHV H3HELL3H}H}PHEH}H}?HEH}DH|$0HE   H}Dm׋ߋDL;= uEL HQ H
R H	 H H
 } 	   e  ma  L- Ht I{ HHu: HuI*Hd H
 ' 	   g  La  HHfDu$ Ht 	  w i  O  H/u
HGHP0E,$L;= uAH H
w H	V Hϣ H
  
   v  L`  H I
 HHu*H H Q 
   x  L>`  HDu$Ŝ Ht 
   z  O  H/u
HGHP0El$L;=ۛ uAH H
 H	 H H<    H   L_  H)
 I9HHu*H H }      Lj_  HHM+HHMwHMFw Ht5      7N  H/u
HGHP0IL$HEH;tIE3HU4L;=ݚ uAH\ H
 H	 H H>    J   L^  H+	 I;HHu*H H
    	   Ll^  H H;uA   (H-Dy@      BM  H/u
HGHP0E  H	 HHH9
 u&H HtH H +H
A (L H H
% HHu*H H"
  
  .   L]  HCL   H HMtA HHu[ 
     \  H+u
HCHP0HFL   Hn HMtA+ HHu'H4 Hu	  
     \  H.u
HFHP03L;= u0Hʿ H
 H	b  
  6   J\  H I*HHu| 
     \  Hz H9Cu6LsMt-H{IHHHH)uHAP0LIHhHH!HMtI.u
IFIP0E3H.u
HFHP03Hu 
  m   [  H+u
HCHP03HGH H;   H;    H4 LHu'H
 H
 x 
     J  H/u
HGHP0IFH   E3IHHtRA   IHHt?IHy 
      Z  M).   IFI   I.u
IFIP0E3 uI4  
  H    \Z  HOHtD~A   Hz H
 H	 
Hxp  
     rI  H;u
Hw H_H_HsHHHH/u
HGHP0H]LHt$0HHMHHMbLEMM HT$8HM葡   DBoHM/HHMHHM_LEMM HT$8HM_   DBoHMIL$(HUbIL$8HU_LL;=e u>H$ H
- H	 H H H    .  8Y  H IHHu'HG H 
    0  X  H H9GuwH (=8 f.z-u+a Ht    @ 2  3E33G  H/u
HGHP0At$HL;=n u>H H
6 H	 H H Q    ?  AX  H IHHu'HP H     A  X  HHMĔHHMxpHMoy Ht    X C  3E33F  H/u
HGHP0IL$XHEH;tIE3HUƬL;=o u>HN H
7 H	 H H R    P  BW  H  IHHu'HQ H     R  W  HyÀu+ Ht    h T  3E33E  H/u
HGHP0A\$xL;= u>HǼ H
` H	? H H {    a  kV  H IHHu'Hz H =    c  -V  H袹Àu+ Ht     e  3E33E  H/u
HGHP0A\$yL;= u>H H
 H	h H H"    . r  U  H I"HHu'H H f    t  VU  H@L   H HMtAF HHu     v  3D  H/u
HGHP0Hs Ht*H HP    \ y  E3T  H.u
HFHP0A\$|L;= u>H H
X H	7 H H  s      cT  H IHHu'Hr H  5      %T  HHMHHMlHMl Ht*H H`     l   E3S  H.u
HFHP0I$   HEH;tIE3HUۨL;= u>H H
L H	+ H H g      WS  HE IHHu'Hf H )      S  H莶Àu5 Ht*H" Hc    o   E3R  H.u
HFHP0A$   L;= u>H H
h H	G H H    
   sR  H IHHu'H H E      5R  H HHH9

 u&H HtH H=x +H
 La Hr
 H
 .HHu*H H@    L   E3Q  HGL   H HMtA HHuy      x@  H/u
HGHP0A   HH HHu6      P  H.u
HFHP03H+u
HCHP03HwDy   t   ?  H/u
HGHP0E%  L;= u>H. H
o H	N HǓ H       zP  H IHHu'H H L      <P  H H+ HH9Gu HHu      ?  H/u
HGHP0H5 H HH9Cuh HHu   <   MO  H+u
HCHP03HDu$ Htl      k>  H/u
HGHP0E$   L;=* u>Hٶ H
 H	ъ HJ H 
      N  H IHHu'H HM    Y   N  H
 H HH9Gu@p HHu      =  H/u
HGHP0H Hi HH9Cu
 HHu5      M  H+u
HCHP03H(Du$ Ht   y   <  H/u
HGHP0E$   L;= u>H H
u H	T H͐ H       M  H I
HHu'H H R      BM  H H1 HH9Gu HHu
      <  H/u
HGHP0H; H HH9Cun HHu   B   SL  H+u
HCHP0HGL   H3 HMtA HHub      a;  H/u
HGHP0Hψ Ht$      K  H+u
HCHP0A$   L;= u>H H
 H	 H HC    O 	  K  HC ICHHu'HĎ H       wK  Hņ Hf HH9Cu
( HHuB    
  J  H+u
HCHP0Hp HQ HH9Gu
ӄ HHu   w   9  H/u
HGHP0Hu$U Ht   4   EJ  H+u
HCHP0A$   L;=h u>H H
0 H	 H H K       ;J  H I	HHu'HJ H 
    "  I  HK H HH9Cu~	 HHu   R $  cI  H+u
HCHP0H H HH9Gu)	Y HHus    '  r8  H/u
HGHP0Hhu$ۅ Ht0    *  H  H+u
HCHP0A$   L;= u>H= H
 H	 H HO    [ 7  H  HO IOHHu'HЋ H     9  H  Hу Hr HH9Cu4 HHuN    ;  G  H+u
HCHP0H| HE HH9Gu߁ HHu    >  6  H/u
HGHP0HN@@u$\ Ht   ; A  LG  H+u
HCHP0A$   L;=o u>H H
7 H	 H H R     N  BG  H IHHu'HQ H      P  G  HR H HH9Cu HHu    Y R  jF  H+u
HCHP0H H HH9Gu0` HHuz     U  y5  H/u
HGHP0Hou$ Ht7     X  E  H+u
HCHP0A$   L;= u>H H
 H	 H HV  !  b e  E  HV IVHHu'H׈ H  !  $ g  E  H؀ Hy HH9Cu; HHuU !   i  D  H+u
HCHP0H H HH9Gu~ HHu  !   l  3  H/u
HGHP0Hu$h Ht !  G o  XD  H+u
HCHP0A$   L;={ u>HB H
C H	" H H ^ "   |  ND  H IHHu'H] H   "   ~  D  H^ H HH9Cu} HHu "  e   vC  H+u
HCHP0H	 H HH9Gu<l} HHu "     2  H/u
HGHP0Hۦ@@u$ Ht> "     B  H+u
HCHP0A$   L;=~ u>H H
 H	~ H H]  #  i   B  H] I]HHu'Hޅ H  #  +   B  H} H HH9CuB| HHu\ #     A  H+u
HCHP0H} H HH9Gu{ HHu #     1  H/u
HGHP0H} H9CusH} (f.z&u$V~ Ht #  5   FA  H+u
HCHP0A$   L;=g} u>H~ H
/~ H	} H H J $     :A  H I HHu'HI H  $     @  HJ| H HH9Cu} z HHu $  Q   b@  H+u
HCHP0H{ H HH9Gu( Xz HHur $     q/  H/u
HGHP0Hp{ H9CusHB| (f.z&u$| Ht $     ?  H+u
HCHP0A$   L;={ u>H H
| H	y{ H H3  %  ?   ?  H3 I3HHu'H H w %     g?  Hz HV HH9Cuy HHu2 %     >  H+u
HCHP0H`z H HH9Gux HHu %  g   -  H/u
HGHP0Hy H9CusHz (f.z&u$,{ Ht %     >  H+u
HCHP0A$   L;==z u>H H
{ H	y H] H   &     >  H IHHu'H H`  &  l   =  H y H HH9CuSw HHu &  '   8=  H+u
HCHP0Hx H\ HH9Gu.w HHuH &     G,  H/u
HGHP0H}u$y Ht &     <  H+u
HCHP0A$   L;=x u>HR H
y H	jx H H$  '  0   <  H$ I$HHu'H H h '     X<  Hw HG HH9Cu	v HHu# '     ;  H+u
HCHP0HQw H HH9Guu HHu '  X   *  H/u
HGHP0Hu$6x Ht '     &;  H+u
HCHP0A$   L;=Iw u>H  H
x H	v Hi~ H , (     ;  H IHHu'H+~ Hl  (  x   :  H,v H HH9Cu_t HHu (  3 
  D:  H+u
HCHP0Hu H HH9Gu
:t HHuT (   
  S)  H/u
HGHP0H艾u$v Ht (     9  H+u
HCHP0A$   L;=u u>H H
v H	vu H| H0  )  <   9  H0 I0HHu'H| H t )     d9  Ht HS HH9Cus HHu/ )   !  8  H+u
HCHP0H]t H HH9Gur HHu )  d $  '  H/u
HGHP0Hs H9CusHt (f.z&u$)u Ht~ )   '  8  H+u
HCHP0A$   L;=:t u>HA H
u H	s HZ{ H  *   4  
8  H IHHu'H{ H]  *  i 6  7  Hs H HH9CuPq HHu *  $ 8  57  H+u
HCHP0Hr H HH9Gu+q HHuE *   ;  D&  H/u
HGHP0HCL   H HMtAs HHu *  y >  6  H+u
HCHP03H肸DYs Ht *  8 A  %  H/u
HGHP0E$   L;=lr u>H H
4s H	r Hy H O +   N  ?6  H IHHu'HNy H  +   P  6  HOq H HH9Guo HHu +  V R  $  H/u
HGHP0Hp H HH9Cu-]o HHuw +   U  5  H+u
HCHP03Hsp H9GuwHEq (f.z&u$q Ht +   X  $  H/u
HGHP0A$  L;=p u>H, H
q H	|p Hw H6  ,  B e  4  H6 I6HHu'Hw H z ,   g  j4  Ho HY HH9Gun HHu5 ,   i  4#  H/u
HGHP0Hco H< HH9Cum HHu ,  j l  {3  H+u
HCHP03Hn H9GuwHo (f.z&u$-p Ht ,   o  "  H/u
HGHP0A$  L;=>o u>H H
p H	n H^v H ! -   |  3  H IHHu'H v Ha  -  m ~  2  H!n H HH9GuTl HHu -  (   !  H/u
HGHP0Hm H HH9Cu/l HHuI -     1  H+u
HCHP0H HHH9
 u&H HtH H +H
S L Hv H
7 "HHu -  N      HCL   H HMtAm HHu~ -     }   H+u
HCHP0A   HHl HHu; -     :   H/u
HGHP0H.u
HFHP03H~y -  |   0  H+u
HCHP0  L;=l u>HW H
xm H	Wl Hs H  .     0  H IHHu'Hs H U .     E0  Hk H4 HH9Cui HHu .     /  H+u
HCHP0H>k HW HH9Fuqi HHu*Hr H+  .  7   E3k/  H.u
HFHP03H蝴u$l Hte .      /  H+u
HCHP0A$  ^/  L;=k u>H H
k H	j H>r H  /     .  H IHHu'H r HA  /  M   .  Hj H HH9Cu4dh HHu~ /     .  H+u
HCHP0Hi He HH9Fuh HHu*HXq H  /     E3-  H.u
HFHP0Hn HHH9
 u&H HtH H5 +H
" L H H
 HHu /     .-  HFL   H HMtAsi HHuM /     ,  H.u
HFHP0A   HH`h HHu
 /     	  H+u
HCHP03H/u
HGHP0HMy*Ho H1  /  =   E3q,  H.u
HFHP0,  L;=nh u>He H
6i H	h Ho H Q 0     A,  H IHHu'HPo H  0     ,  HQg H HH9Fue HHu*Hn H>  0  J   E3~+  H.u
HFHP0Hf Hl HH9GuNe HHuh 0     g  H/u
HGHP0Hff H9FuvH8g (f.z7u5g Ht*H;n H|  0     E3*  H.u
HFHP0A$   *  L;=f u>Hѕ H
zg H	Yf Hm H  1     *  H IHHu'Hm H W 1     G*  H HHH9
 u&H HtH H= +H
) L H H

 @HHu*Hm HR  1  ^ 
  E3)  HGL   H HMtAe HHu 1       H/u
HGHP0A   HHd HHuH 1     (  H.u
HFHP03H+u
HCHP03H艌Dy 1       H/u
HGHP0EA  L;=d u>H  H
e H	`d Hk H  2  &   (  H IHHu'Hk H ^ 2   !  N(  Hc H] HH9Gua HHu 2   #    H/u
HGHP0HGc H HH9Cuza HHu 2  N &  _'  H+u
HCHP03H跬Du$)d Ht~ 2   )  }  H/u
HGHP0E$   L;=<c u>H H
d H	b H\j H  3   6  '  H IHHu'Hj H_  3  k 8  &  Hb H HH9GuR` HHu 3  & :    H/u
HGHP0Ha H{ HH9Cu-` HHuG 3   =  %  H+u
HCHP03H:Du$b Ht 3   @     H/u
HGHP0E$   L;=a u>HV H
b H	fa Hh H   4  , M  %  H  I HHu'Hh H d 4   O  T%  H` Hc HH9Gu_ HHu 4   Q    H/u
HGHP0HM` H HH9Cu^ HHu 4  T T  e$  H+u
HCHP0HGL   HE HMtA` HHut 4   W  s  H/u
HGHP0H)` Ht6 4   Z  #  H+u
HCHP0A$   L;=_ u>H H
` H	_ Hg HU  5  a g  #  HU IUHHu'Hf H  5  # i  #  H^ H HH9Cu
:] HHuT 5   k  "  H+u
HCHP0H^ H HH9Gu\ HHu 5   n    H/u
HGHP0HT@@u$b_ Ht 5  A q  R"  H+u
HCHP0A$   L;=u^ u>H\ H
=_ H	^ He H X 6   ~  H"  H IHHu'HWe H  6     
"  HX] H HH9Cu[ HHu 6  _   p!  H+u
HCHP0H] H HH9Gu6f[ HHu 6  
     H/u
HGHP0H~\ H9CusHP] (f.z&u$] Ht$ 6        H+u
HCHP0A$   L;=\ u>H H
] H	\ H d HA  7  M      HA IAHHu'Hc H  7     u   H[ H HH9Cu&Z HHu@ 7       H+u
HCHP0Hn[ H HH9GuY HHu 7  u     H/u
HGHP0HZ H9CusH[ (f.z&u$:\ Ht 7     *  H+u
HCHP0A$   L;=K[ u>H H
\ H	Z Hkb H . 8       H IHHu'H-b Hn  8  z     H.Z H HH9CuaX HHu 8  5   F  H+u
HCHP0HY H HH9Gu<X HHuV 8     U
  H/u
HGHP0HTY H9CusH&Z (f.z&u$Z Ht 8       H+u
HCHP0A$   L;=Y u>H H
~Z H	]Y H` H  9  #     H IHHu'H` H [ 9     K  HX HZ HH9CuV HHu 9       H+u
HCHP0HDX H} HH9GuwV HHu 9  K     H/u
HGHP0HW H9CusHX (f.z&u$Y Hte 9        H+u
HCHP0A$   L;=!X u>H H
X H	W HA_ H  :       H IHHu'H_ HD  :  P     HW H HH9Cu7gU HHu :       H+u
HCHP0HV H8 HH9GuU HHu, :     +
  H/u
HGHP0H*V H9CusHV (f.z&u${W Ht :  Z   k  H+u
HCHP0A$   L;=V u>H; H
TW H	3V H] H o ;     _  H IHHu'Hn] H 1 ;     !  HoU H0 HH9CuS HHu ;  v     H+u
HCHP0HU HS HH9GuM}S HHu ;  !     H/u
HGHP0HT H9CusHgU (f.z&u$U Ht; ;  ž     H+u
HCHP0A$   L;=T u>H΅ H
U H	T H\ HX ھ <  d     HX IXHHu'H[ H  <  & 
    HS H HH9Cu
=R HHuW <       H+u
HCHP0HS H HH9GuQ HHu <       H/u
HGHP0Hu$jT Ht <  I   Z  H+u
HCHP0A$     L;=xS u>Hw H
@T H	S HZ H [ =   )  K  H IHHu'HZZ H  =   +  
  H HHH9
 u&HW HtH H=H +H
 L1 Hz H
 HHu =  2 -  C  HGL   H HMtAR HHub =   /  a  H/u
HGHP0A   HHuQ HHu =   2    H+u
HCHP03H.u
HFHP03H`yDyӻ =  ] 5    H/u
HGHP0EU  L;=Q u>H H
XR H	7Q HX H s >   B  c  H IHHu'HrX H 5 >   D  %  HsP H HH9GuN HHu >  z F    H/u
HGHP0HP H HH9FuQN HHu*HW H  >   I  E3K  H.u
HFHP03HO H9GuwHXP (f.z&u$P Ht, >   L  +  H/u
HGHP0A$   L;=O u>H7 H
P H	O HW HI ˹ ?  U Y    HI IIHHu'HV H  ?   [  }  HN H HH9Gu.M HHuH ?  Ҹ ]  G  H/u
HGHP0HvN H HH9FuL HHu*H"V Hc  ?  o `  E3  H.u
HFHP03HM H9GuwHN (f.z&u$/O Ht ?   c    H/u
HGHP0A$   {  L;=;N u>H H
O H	M H[U H  @   z    HD IHHu'HU H^  @  j |    HF HHH9
 u&H" HtH H5 +H
 L H H
 HHu ~  mHFL   Hk HMtAXM HHuƶ   4H.u
HFHP0A   HHRL HHuG    @  E3HT HU H  H/  HGHP0z  H/u
HGHP0H+u
HCHP0Ht؅y*HS H y @     E37  H.u
HFHP0t  L;=4L u>H} H
L H	K HTS H  A       H IHHu'HS HW ٵ A  c     HK H HH9FuJzI HHu*HR H  A     E3D  H.u
HFHP0HJ Hj HH9CuI HHu. A       H+u
HCHP0HFL   H HMtAJ HHu*HR HH ʴ A  T   E3  H.u
HFHP03H蚎2K Ht A     "  H+u
HCHP0A$   L;=EJ u>H| H

K H	I HeQ H ( B       H IHHu'H'Q Hh  B  t   
  H(I H HH9Cu[G HHu B  /   @
  H+u
HCHP0HH H HH9Fu6G HHu*HP H B B  ̲   E3 
  H.u
HFHP03H2u$I Ht B       H+u
HCHP0A$   L;=H u>Hz H
I H	_H HO H  C  %     H IHHu'HO H۸ ] C     M  HG Hl HH9CuE HHu C       H+u
HCHP0HFG H/ HH9FuyE HHu*HN H3  C  ?   E3s  H.u
HFHP03H襐u$H Htm C       H+u
HCHP0A$   L;=+G u>HBy H
G H	F HKN H  D     
  H IHHu'H
N HN а D  Z   
  HF H߳ HH9CuAqD HHu D     &
  H+u
HCHP0HE H HH9FuD HHu*HeM H ( D     E3	  H.u
HFHP03Hu$F Ht D  j   {	  H+u
HCHP0A$   L;=E u>Hw H
fF H	EE HL H  E     q	  H IHHu'HL H C E  ͮ   3	  HD HR HH9CuB HHu E       H+u
HCHP0H,D H5 HH9Fu_B HHu*HK H  E  %   E3Y  H.u
HFHP03H苍u$D HtS E  ݭ     H+u
HCHP0A$   L;=D u>Hxv H
D H	C H1K Hr  F  ~ 	    Hr IrHHu'HJ H4  F  @     HB HŰ HH9Cu'WA HHuq F   
    H+u
HCHP0HB H HH9FuA HHu*HKJ H  F     E3  H.u
HFHP03Hu$qC HtƬ F  P   a  H+u
HCHP0A$   L;=B u>Hu H
LC H	+B HI H g G      W  H IHHu'HfI H ) G   "    HgA H8 HH9Cu? HHu G  n $    H+u
HCHP0HA H3 HH9FuEu? HHu*HH H  G   '  E3?  H.u
HFHP03Hz@ H9CusHLA (f.z&u$A Ht  G   *    H+u
HCHP0A$   L;=@ u>Hs H
A H	@ HG H=  H  I 7    H= I=HHu'HG H  H   9  q  H? H HH9Cu"> HHu< H  Ʃ ;    H+u
HCHP0Hj? Hc HH9Fu= HHu*HG HW ٩ H  c >  E3  H.u
HFHP03H)g@@u$7@ Ht H   A  '  H+u
HCHP0A$   L;=J? u>H)r H
@ H	> HjF H - I   N    H IHHu'H,F Hm  I  y P    H-> H HH9Cu`< HHu I  4 R  E  H+u
HCHP0H= Ha HH9Fu;< HHu*HE HŮ G I  ѧ U  E3  H.u
HFHP03H@= H9CusH> (f.z&u$> Ht I  p X    H+u
HCHP0A$   L;== u>Hp H
j> H	I= HD H  J   e  u  H IHHu'HD Hŭ G J  Ѧ g  7  H< HV HH9Cu: HHu i     H+u
HCHP0H:< Hs HH9Fum: HHu'HC H'  J  3 l  E3jH.u
HFHP03H蜅   = Htw o  V J  E3HxC H HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0Ll$0H
6o H+u
HCHP0A$   HMHt
H)uHAP0MtIm uIEIP0HMLEMM HT$8HM8F   DBoHMZLEMM HT$8HMF   DBoHMZHMH3GL$   I[PA(sA({IA_A^A]A\_^]HATH   HXE3HhHpHxLhELpLLxELd$hLd$ Ld$p8 Hu*HA AH)     5     L8 Hu*HA IH s         AL艌$   ; HHu*HnA IH .       <  H
,8 HHHu       ?  H+u
HCHP0H LI7 y    H   =  H/u
HGHP0AN$   : HHu*H@ IH k       y  H LIm7 y;    Ţ   G=  H/u
HGHP0IN=HHu*H0@ IHn     z     H^ LI6 y    J   <  H/u
HGHP0AFHQ8 HHu*H? IH r         H LIt6 yB    ̡   N<  H/u
HGHP0ANP]HHu*H6? IHt          Ht LI5 yơ    P   ;  H/u
HGHP0ANx\HHu*H> IH z         H LI|5 yJ    Ԡ   V;  H/u
HGHP0E8fyt{INX;HHu*H9> IHw          H LI4 yɠ    S   :  H/u
HGHP0E8   t~I   :HHu*H= IH r     1    H LIt4 yB    ̟ 3  N:  H/u
HGHP0H
 HAH9M u!H HtH H ^H
 MH= HLG3 HHL HHH
 HR HtHJ6 HtIHHHu*H< IH y     F    AN|$   5 HIHuD    Ξ H  F;  HB4 H9Cu7H{Ht.HkHHHHE H)uHAP0LHH/HHHHtH/u
HGHP0H.u
HFHP0Hu    9 W  :  H+u
HCHP0H
 Hl$hHAH9M u!H< HtH H=- ^H
l MHc HLCF2 HH HHH
 H= HtH4 HtIH HHu*H!; IH_     k d    HGHH L   MtA3 HHu    % f  7  H/u
HGHP0A   HH2 HHuX     i  W9  H+u
HCHP0HZ؅y!     k  -7  H/u
HGHP0  HEHHP L   MtA2 HHu*H9 IH0     < v    Hآ LI0 y     x  6  H/u
HGHP0A   $   2 HHu*Hl9 IH ,       :  HB LI.0 y       6  H/u
HGHP0A   L$0 2 HHu*H8 IH'     3     Hϝ LI/ yy       5  H/u
HGHP0A   L$81 HHu*Hf8 IH &       4  H\ LI(/ y       5  H/u
HGHP0A   L$@1 HHu*H7 IH!     -     H LI. ys       4  H/u
HGHP0L/ IH a. y*H^7 IH        ,  A   THHu*H7 IH] ߙ    i     H LI- y    9   3  H/u
HGHP0A   =/ HHu*H6 IHܟ ^       l  H LI`- y.       :3  H/u
HGHP0A   . HHu*H6 IH[ ݘ    g     H LI, y    7   2  H/u
HGHP0A   ;. HHu*H5 IHڞ \       j  H LI^, y,       82  H/u
HGHP0A   L$H0/ HHu*H5 IHW ٗ    c     H LI+ y    3   1  H/u
HGHP0A   L$P. HHu*H4 IHԝ V       d  HL LIX+ y&       21  H/u
HGHP0A   L$X*. HHu*H4 IHQ Ӗ    ]   
  H LI* y    -   0  H/u
HGHP0A   1, HHu*H3 IHМ R    ܕ   `
  HP LIT* y"       .0  H/u
HGHP0A  + HHu*H3 IHO ѕ    [     H LI) y    +   /  H/u
HGHP0A  /+ HHu*H2 IHΛ P    ڔ '  ^  Hn LIR) y      )  ,/  H/u
HGHP0H
v HAH9 u!H HtH H ^H
* MH=! HLG( HH* HHH
G HH HtH(+ HtIHvHHu*H1 IH՚ W     3  e  A   L$(* HHu%     5  $0  H#) IH9Cu6HsHt-H{HHHHH)uHAP0LHHHHHHtH.u
HFHP0Hm u
HEHP0Hu     D  /  H+u
HCHP0HGHHĘ L   MtA]) HHu7     G  C-  H/u
HGHP0H LI)' y     J  .  HHH\$ HHu
HCHP0H
@ HAH9 u!H\ HtH HM ^H
 MH= HLG& HH HHH
a H HtH( HtIH@HHu*Ha/ HH !     V  /	  HCHH  L   MtA( HHuۑ    Hb X  -  H+u
HCHP0A   HH& HHu     [  +  H/u
HGHP0HNy^    H ]  ]-  H+u
HCHP0tzA  L$({' HHu*HD. HH      h    Hb LI%   А    HW j  ,  H
3 HAH9 u!H HtH H ^H
 MH=ޗ HLGy$ HH HHH
ě H HtH& HtIH3HHu*HT- HH      ~  "  HCHH L   MtA% HHuΏ    HU   +  H+u
HCHP0A   HH$ HHu       )  H/u
HGHP0HLyQ    H؎   P+  H+u
HCHP0txA   $ HHu*H9, HHw          H LI"   Ŏ    HL   *  H
( HAH9M u!H| HtH Hm ^H
ܕ MH=ӕ HLGn" HHܓ HHH
 H2 HtH$ HtIH(HHu*HI+ HH 	         HCHH( L   MtA# HHuÍ    HJ   )  H+u
HCHP0A   HH" HHu}       '  H/u
HGHP0HJyH    Hό   G)  H+u
HCHP0H
 HAH9 u!H HtH H ^H
O MH=F HLG  HHO HHH
T He HtHM# HtIH蛱HHu*H) HH |         HCHH L   MtA\" HHu6    H   5(  H+u
HCHP0A   HHF! HHu    z   %  H/u
HGHP0HEIy    H@   '  H+u
HCHP0	  H
 HAH9 u!H HtH H= ^H
 MH HLCJ HH HHH
= H= HtH! HtIHHHu*H%( HHc     o     A   L$`! HHu    =   $  H IH9Gu6HwHt-H_HHHHH)uHAP0LHH蜤HHOHHtH.u
HFHP0Hm u
HEHP0Hu       '$  H/u
HGHP0HCHHR L   MtA HHuH|$     J   %  H+u
HCHP0H
 HH|$pHAH9 u!H HtH H= ^H
" MH HLCT HH HHH
Ϣ H=P HtH HtIHHHuEH/& Hp     |   H|$ D܈ H
!I c i`%  HGHH L   MtA HHu       "  H/u
HGHP0A   HH HHuH|$ F    Ї   H$  H+u
HCHP0HE؅y       "  H/u
HGHP0   L IH  y'H$ H3     ? 
  H{ I3HHu'H$ H w       Hݐ H HHuF    І   R!  H/u
HGHP0H LI8 K  H|$        "  H
c HAH9П u!Hϝ HtH H ^H
w MH=n HLG HH HHH
 H HtH HtIHcHHu'H# HŌ G    х ,  PHCHHn L   MtA' HHuH|$      .  !  H+u
HCHP0A   HH HHu    C 1    H/u
HGHP0HCyH|$ }     3  !  H+u
HCHP0  L IHi c y'H`" H #     >  ,H I衞HHu'H"" Hc     o G  H HZ HHuH|$     9 I     H+u
HCHP0He LI yo     L  {  H/  HGH  H
 HAH9 u!H HtH H= ^H
ӊ MHʊ HLC HHs HHH
 H=a HtHq HtIH迨HHu'H  H!     - `  HGHH
 L   MtA HHu]     b  i  H/u
HGHP0A   HHp HHuH|$      e    H+u
HCHP0Hj@؅yނ    h g    H/u
HGHP0  L IHʉ  y'H H      r  HJ IHHu'H HĈ F    Ё {  OH H HHu     }  !  H/u
HGHP0H˄ LI yH|$ Ё    Z     H+u
HCHP0H MI H|$ &  H H y       H
߆ HAH9 u!Hs HtH Hd ^H
K MH=B HLG% HH HHH
 H) HtH HtIHߥHHu*H  IH>     J   HCHH L   MtA HHuz       y  H+u
HCHP0A   HH HHu7       C  H/u
HGHP0H=y          H+u
HCHP0`  HEHH/ L   MtA HHu*H IH        H LI ya    ~   `  H+u
HCHP0A   $    HHu*HK IH     ~   H! LI
 y~    e~     H+u
HCHP0A   L$` HHu*H IH ~    ~   H LI yX~    }   W  H+u
HCHP0A   L$X| HHu*HE IH ~    }   H# LI y}    _}     H+u
HCHP0A   L$P HHu*H IH  }    }   HЀ LI yR}    |   Q  H+u
HCHP0A   L$Hv HHu*H? IH} |    |   
H5 LI y|    Y|      H+u
HCHP0A   ] HHu*H IH ~|    | 
  H LI yN|    {   M  H+u
HCHP0A   7HHu*H? IH} {    {   
H=~ LI y{    Y{     H+u
HCHP0A   L$@ HHu*H IH |{    { "  H LI~ yL{    z $  K  H+u
HCHP0A    HHu*H; IHy z    z .  	HɄ LI yz    Uz 0    H+u
HCHP0H
! HAH9 u!Hō HtH H= ^H
5 MH, HLCg HH HHH
ʏ H={ HtH HtIH!HHu*HB IH z    y :  A   L$(6 HHuy    Zy <    H IH9Gu7H_Ht.HoHHHHE H)uHAP0LHH踓HHkHHtH+u
HCHP0H.u
HFHP0Hu8y    x K  D  H/u
HGHP0HEHHo~ HL   MtA HHu'H HO x    [x X  Hz LI yx    +x Z    H+  HCHP0  H
} HAH9 u!H: HtH H+ ^H
Z} MH=Q} HLG4 HH} HHH
 H HtH HtIHHHu*H IHM~ w    Yw n  HCHH L   MtA
 HHuw    w p    H+u
HCHP0A   HH HHuFw    v s  R  H/u
HGHP0H4yw    v u    H+u
HCHP0  HEHH>| L   MtA HHu*H IH} v    *v   H| LI
 ypv    u   o  H+u
HCHP0A   L$8 HHu*H] IH| v    u   +H3z LI
 yu    wu     H+u
HCHP0A   L$0 HHu*H IH| u    $u   Hx LI	 yju    t   i  H+u
HCHP0A   *0HHu*H[ IH{ u    t   )Hy LI	 yt    ut     H+u
HCHP0H
Az HAH9 u!HE HtH H=6 ^H
-w MH$w HLC HHy HHH
 H= HtH
 HtIHAHHu*Hb IHz "t    s   0A   $   S
 HHus    ws   
  H IH9Gu7H_Ht.HoHHHHE H)uHAP0LHHՍHH舒HHtH+u
HCHP0H.u
HFHP0HuUs    r   a
  H/u
HGHP0HEHHx Hl$ L   MtA 	 HHu*H) HHgy r    sr   Ht LI yr    H@r     H+u
HCHP0H
x HAH9q u!Hȍ HtH H ^H
t MH=t HLGR HHw HHH
% H~ HtH HtIHHHu*H- HHkx q    wq   HCHH4| L   MtA HHuq    H.q   
  H+u
HCHP0A   HH HHuaq    p   m  H/u
HGHP0H.y*q    Hp   )
  H+u
HCHP0	  H
uv HAH9
 u!H HtH H ^H
as MH=Xs HLG HH)v HHH
 H HtH' HtIHuHHu*H
 HHv Vp    o   dHCHH=y L   MtA6 HHup    Ho     H+u
HCHP0A   HH  HHuo    To   	  H/u
HGHP0H-yo    Ho     H+u
HCHP0  A    HHu*Hw HHu 7o    n    EH%s LI9 yo    Hn     H+u
HCHP0A    HHu*H HH1u n    =n   H1u LI yn    H
n   
  H+u
HCHP0A    HHu*Ho HHt /n    m   =Hs LI1 ym    Hm   	  H+u
HCHP0A    HHu*H
 HH)t m    5m $  Hw LI y{m    Hm &  z	  H+u
HCHP0A    HHu*Hg
 HHs 'm    l 0  5Hv LI) yl    H~l 2    H+u
HCHP0A    HHu*H	 HH!s l    -l <  H!w LI  ysl    Hk >  r  H+u
HCHP0A    HHu*H_	 HHr l    k H  -Hs LI!    k    Hrk J    H
Nq HAH9Sw u!H҅ HtH HÅ ^H
:n MH=1n HLG  HHq HHH
w H HtH  HtIHNHHu*Ho HHq /k    j ^  =HCHHt L   MtA HHuj    Hpj `    H+u
HCHP0A   HH  HHuj    -j c    H/u
HGHP0H'ylj    Hi e  k  H+u
HCHP0  A     HHu*HP HHp j    i p  Hm LI  yi    Hgi r    H+u
HCHP0A   k  HHu*H HH
p i    i |  H
p LI  y\i    Hh ~  [  H+u
HCHP0A     HHu*HH HHo i    h   Hm LI
  yh    H_h     H+u
HCHP0A   c  HHu*H HHo h    h   Hr LI  yTh    Hg   S  H+u
HCHP0A     HHu*H@ HH~n  h    g   Hq LI  yg    HWg     H+u
HCHP0A   [  HHu*H HHm |g    g   Hq LI~  yLg    Hf   K  H+u
HCHP0H  H
l HAH9r u!H[r HtH HLr ^H
l MH=k HLG  HHKl HHH
r Hr HtHI  HtIH藋HHu*H IHl xf    f   HCHHj L   MtAX  HHu2f    e   1  H+u
HCHP0A   HHE  HHuDe    ye   H
 HKl HH/HGHP0H/u
HGHP0H#ye    e     H+u
HCHP0  Lp IHk s  y*Hp IHk 0e    d   >LF  IHo .  y*H+ IHik d    ud   A     HHu*H IH(k d    4d   Hn LI  yzd    d   |H+u
HCHP0A     HHu*Hl IHj ,d    c   :Hk LI.  yGc    c   IH HUj HH+HCHP0H+u
HCHP0Hg MI  Iy*H  Hi }c    c   IIML$   H$   H$   H$   MtI/u
IGIP0L$   MtIm u
IEIP0HL$hL$   Ht
H)uHAP0HtH/u
HGHP0HL$pH$   Ht
H)uHQR0IHİ   A\HUATAUAVAWHhH   HEHXHpHx Hf H3HEL3DHL$XDHL$`HE   HMMHE   HMM؋DH
` HAH;  uE33聄+H;h  uHA@t	3腂E3He dHHu'H  HFh a y   Ra $  	  LLyhAAAGAIOHHu'H  Hg {a }   a M    LHL;
E  t;MIL H  H
  H	  3a }   ` O  6  IMH)uHAP0IuIO rHHu'H#  Hdg ` ~   p` ]  1  LHL;
  t;MILc HT  H
u  H	  ` ~   (` _    IM H)uHAP0Iu AG8AE(3  HHu'H  Hf F`    _ w    H|$XI_@I;_H"  E3HCH+HHHD$hHLL$@D$8  DL$0HD$(LL$ A   LD$hAQH_ HH  H   ILHt
H)uHAP0LGHG HE3AL;AL9G tI$HGN$I@HGIH  tE3HI;_H1NHu  He 8_    ^     HN  He _    ^   \  3~  HHu'H  HXe ^    d^   %  I_XI;_`   HEH;tIE3HHM
H IE3HUHM
HE   LuDt$pIE3HUHL$p
H  HD$(HL$p	'  HHtdHVH9V ~H HNHHJHNHHf  uH/u
HGHP0I;_`?2]    z]     ]    a]     Ht$`H
8c HAH9p u!Hj HtH H=j ]H
e LHd LCH~  HHb HHH
p H=zj HtH  Ht3H9HHu'HZ  Hc ]    \   h  HGL   He HMtA  LHu'H  HGc \    S\     H/u
HGHP0     HHu'H  Hb \    	\     HHpHD$XH HG E3HH
De }HHu'Hh  Hb +\    [   L  H/u
HGHP03H  I9Fu6I^Ht-I~HHILH)uHAP0LHHvHIzHD$PHtH+u
HCHP03H.u
HFHP0H\$PHu'H  Ha n[    Z     I.u
IFIP0IM0H)uHAP0I]0I  HHu'HK  Ha [    Z   Y  IM@H)uHAP0I]@A  AEHI  HMWH
P  HL$(Hs#  HHu'H  Ha Z    !Z /    IMPH)uHAP0I]PI  HHu'H  H` GZ    Y >    IMXH)uHAP0I]X3  HHu'H8  Hy` Y    Y M  F  I  I;  O  @ HEH;tIE3HHMH IE3HUHMHE   H}@}IE3HUHMH  HD$(HM#"  LHt]HNH9N ~H HFL4HAHFIH  u"I.u
IFIP0I;  ?   X X  
X V  X    H  HT_ H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0DX -X H
N 93IM`H)uHAP0Iu`IE IMtIm u
IEIP0HL$XHt
H)uHAP0MtI,$uID$IP0HL$`HtH)uHAP0HEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  HHE   HE    E HMHHMH3'L$   I[8Is@I{HIA_A^A]A\]@SH HC  HH HI`H)uHAP0H%  HC`3H [@SH H  HH HI`H)uHAP0H  HC`3H [H\$WH LJHL;
  HtrH;  tiH
{  Lt MIH9 H	  H  H] V [   V     H
j A[   _7H\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH H  HH HIXH)uHAP0H  HCX3H [@SH Hs  HH HIXH)uHAP0HU  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH Hs  HH HIPH)uHAP0HU  HCP3H [@SH H3  HH HIPH)uHAP0H  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0Hk  H)t$ H9BurH5  (f.5 zTuR  HtGH4  HuY R X   R     H
M AX   3(t$ H0[sH3(t$ H0[KH(AHA  Hu;H  HX hR X   Q     H
. AX   C33H(H(AH  Hu;HE  HX R X   Q     H
 AX   23H(@SH H  HH HI@H)uHAP0H  HC@3H [@SH Hs  HH HI@H)uHAP0HU  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH Hs  HH HI8H)uHAP0HU  HC83H [@SH H3  HH HI8H)uHAP0H  HC83H [H\$WH LJHL;
P  HtrH;  tiH
  L4	 MIH H	(  H  H2V O V   >O     H
 AV   0H\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H  HH HI0H)uHAP0H  HC03H [@SH H  HH HI0H)uHAP0H  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H  H)t$ H9BurH  (f.5r zTuR   HtGH  HS gM T   L S  S  H
	 AT   B.(t$ H0[s(3(t$ H0[KH(A(  Hu;H  HVS L T   bL 0  0  H
 AT   -3H(H(A(Q  Hu;H  HR xL T   L 0  0  H
n AT   S-3H(@SH H#  HH HI H)uHAP0H  HC 3H [@SH H  HH HI H)uHAP0H  HC 3H [H\$WH LJHL;
  HtrH;  tiH
[  L MIH H	  H  HQ dK S   J     H
 AS   ?,H\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH H  HH HIH)uHAP0Hu  HC3H [@SH HS  HH HIH)uHAP0H5  HC3H [H\$WH LJHL;
   HtrH;  tiH
  L MIHY H	H  H  HRP I R   ^I z  z  H
j AR   *H\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;9  AE3H;  A3H;&  DEuH  DEEtRf  HtGH  H+O H Q   7H 5  5  H
 AQ   )H\$0H _È_3H\$0H _;H(y tHo  H He  Hd  H HZ  Hu;HF  HN 	H Q   G     H
 AQ   (3H({H\$WH HH&؃uO>  HtDH  HN G P   G 
  
  DCQH
  b(H\$0H _É_3H\$0H _kH(IL$0g  Hu;H3  HtM F P   F 
  
  H
  AP   '3H(H(IL$0  Hu;H  HM F P    F 
  
  H
l  AP   q'3H(H\$Hl$VH H3H
  HAH;:  uE33h+H;  uHA@t	3fHI E3gHHu'H"  HcL E q   oE m
  =  HCHHH L   MtA  HHu3E o
     H  H|$03H9Cu3H{Ht*HsHHHHH)uHAP0HHQdHeHHtH/u
HGHP0H|$0HuD }
  1H+u
HCHP0     HH   D 
  H  HRK D q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HSHR0DD H
  D |%3H\$8Hl$@H ^H
#C HHHHh Hp(H
=  HH
3  HH0H
(  HH
  HH8H\$8Hl$@H ^@UAWH8HBE3H;  AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH;  t[HHH  HHu'H  H
J C m   C     H@L   Mu^B     HIIMMu>H*  H9GuH;w  HGHHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHI_HHtFLHI  tH+BHCHP03{B n   B #
     bB n   A !
       LH   H
&  LI;   HHD9   }F      @t:I@   yA      @t3I|s
IIiII  ugUA 
  A m   H  HH HtH/u
HGHP0HtH+u
HCHP0DxA H
m  @ b"   H/u
HGHP0L=3  ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Ht$ AVH HD E3H\$0E3HHl$8H
|? H|$@
HHu1H5  H  HG @ f   H@ s    HXHH
{J HD HAL   MtAY  HHu'Hb  HF %@ h   ?      H#  IH9Cu4H{Ht+HkHHHHE H)uHAP0HH^H`HHtH/u
HGHP0Hu-H  HF ? h   ?   H   zH+u
HCHP0HHn   HHu$H  HE D? i   >   BHHHuMHM  HE ? i   >   H+u
HCHP0D> H
t  v> &H+u
HCHP0HLH/u
HWHR0H.H|$@Hl$8H\$0u
HVHR0IHt$HH A^HT$SVWATAVH Lq333L9Ypt3H A^A\_^[Hl$PLl$`L|$hMu*HU  E3HD > i   =       LHu'H  H^D = i   j=   Z  IFHHHu-H
  L  H[7 H	  0=     HAH;p  tWH;  tNH  HHuH
  H
C <   ~  H@L   Mua<   Q  H3E3H@ Mu>H  H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA  HHtNH+u
HSHR0IVLI3g  uH/HGHP0; E  5  ; B  &  H
  L  H5 H	F  t; ?     q  Ht H  HH     H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$pILl$`H A^A\_^[x: 5  3H  HHA : i   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Dp: H
}  9 ZH\$Hl$Ht$H|$ AVH H= HH
9 E3]HHuH    H   H
j8 HxHH5,D L55B H-NA 0  HHtzHIH_HG3HGt GpHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`HGh  H+u
HCHP0HG  Hj  H? 8 '9 i   Ai   H
6  H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtHg  HH [H [@SH HYhHtHf  HH [oH [H(HB      tHAL   MtA)  Hu;H5  Hv> 7 `   7 z  z  H
~  A`   3H({H   HD$ :  Ht
33HĈ   H(HHH=  ȅx3H(@WH@HD$ H\$XH H3HD$0HHL$(LL$xHAHyrH	HH;}HH33)  E3MtA  HHHHL$0H3QH\$XH@_LAL9A ~HHAJI@HA3H%  LYE3HA EHL;AL9Y AEtHHAJICHA3H%~    3H;HUHhH   HEHXHpHx H΃ H3HEGHHM3uNE   HE   Hu@uDFH  HMHE   Hu@uDFH  HM~HuHE   Hu@uIE3HUHMHE7   Hu/@uIE3HUHM`HUH   /HMHMHEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  HHE   HuE HEHrPHHMH=   r<tU  HAH;rE  H+Hs5  H'v(  HGHE   HuE A   H  HM!HE   HuE A   H  HME   E   HE   HuE IE3HUHMHE7   Hu/E IE3HUHMHUH   衁HMwHMnHMdHMZHHMGH3L$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+H臈HCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;vq  H    H=   r<tU  HAH;rE  H+Hs5  H'v(  HGH3HsHsHH\$@Ht$PH0_@SH Ho HHH  HH6 }HH33 HH&  H# HOHH  @HH 1HH2 RHHh  H HHH  HH HH1 HHH [H%  H(H	  HHH(H%S  @UVWATAUAVAWH$H@  Hǅx  H$  H~ H3H8  LD$pHT$PHMH  L  ML  MLt$hHM芜WD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8}H|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
   H
   3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM@3H]Mt`IrAfoh IHfHnflfHAfHnflfLHH;rI;s     HHI;rL%Ż L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH  H H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  H: H   L   L  L   L   HUH   'L   H   H   LH   H   踙E3AL}H   H   HMI+HL   H;vdM9s
HH;rbHw  HD$x3HEHEH9 HD$XD$`HUHL$X  Hy HD$xH; HL$xH
+ ݻ  H- HE Lu(Le0HEH+HHE8HUHM@%LE0HU8HMXSHU8H   ILuHU8H   HMI+HLE(H;vdM9s
HH;rbH  HD$x3HEHEHL HD$XD$`HUHL$XӼ  H HD$xH0: HL$xH
>   L%  LeHT$hHULmH  HEWD$PWM LmLD$PHM   HHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  蛖Hs H  HE(H  HE0H  HE8H  HU@H  [H  HD$XL% L  HE`H   HEhH  HEpH  HUxH  蟆H   H0  HӪ HH  H   HP  H   HX  H   H`  H   Hh  试H  HD$XL  H   H  H   H  H   H  H  H  H   H  JHr H@  HH  HD$XL% LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX   Ld$xH  HEHE   LmE IE3H  HMH  HD$(H  HD$ LH  L@  HT$xHDHHU HtLEL+IH   Ht%L   L+IWf   L   HMXHU@HtLEPL+ItWfE@LmPL% Le H   Ht%L0  L+I>Wf   L0  H   H   Ht%L   L+IWf   L   L   L-) L  H  >L  L  L  H  L  MtLEM+IIHtH+HLHvMtLEM+II]HH8  H3[H$  H@  A_A^A]A\_^]@SH HCE HD$0H+/E H
PE HH\$0H;sSH3E HT$0H;wBH\$0H+HH;
&E u   H
E H
E HD Ht9HH)H;
D u   H
D H
D Ht
HH
D HF HD$0H+F HHH
D H
D H\$0H;sSHD HT$0H;wBH\$0H+HH;
D u   H
D H
~D HoD Ht9HH)H;
jD u   H
LD H
HD Ht
HH
9D HJF HD$0H+6F HHH
D H
E H\$0H;sSHE HT$0H;wBH\$0H+HH;
rE u   H
TE _H
PE HAE Ht9HH)H;
<E u   H
E )H
E Ht
HH
E HHC H
D H
D eHC H
D bHC H
D H [JHXHB H9B    HRH
B H\$P#~HB H
D H-B HR~H-B LD H
VD IHD H+HHYH;s>@ HHtH   LD HD IHH+HH;rH
C HQ|H-C H\$PHXH(  D$(HD$0HT$83HL$ HD$8HD$@H  HD$ n  H H5 HD$0HL$0WHXHA H9A    HyA LC HC HlA HC HC IH+H\$PH3Ht;     HHtH   LC HC IHH+HH;rHA H\$PHbC HA     HHA HA H HHA HXH  D$(HD$0HT$83HL$ HD$8HD$@H  HD$ 3  H H3 HD$0HL$0H\$WH H      ?HAH
a@ H9
R@ H3@ u	H="@ HIHH+@ HHkHH<H;sfD  HKHHPH;wH\$0H _H? H+? H
? HH+AH? H9? @WH H
    HHu H
  HG  H	>  H _HV  H\$0Hش  H/Hu
HWHR0Hu%H
	  H2  H	  H\$0H _H  H9Ct9H
  H  H	  H+  HCHP0H\$0H _3H  H+H uHCHP0H Hu%H
(  H  H	X  H\$0H _=	  Hd tA	  H  %  
HA s4  A
   H  H
  DH	  H\$0H _  u	H"  t%HD  H
}  H	d  H\$0H _3H\$0H _3H%g  H(Hu           H(HtIw  3H(3HtIvo   "   S  "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[HHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHHH\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=j      Hh)|$@)t$Pf(z f(B fYf(%V f(
> f\& ff(fXf~Ё  fYf@  fY fff\LD      ??f\f( fsA~$@     f(w f(fYfs4fA$fYfYfXD fX, fYfYfYfXfX ffXfY(t$P(|$@Hhf     ??f\f( fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0LY f(5 f(fYfs4fA$fYfYfX5 fXv fYfYfYfXfX5N ffXfYf( ff ff(5 ff5 fffffff\ fsA~   fA   ffs4ffYA~  fA  fYff(=N ff=1 fA~   fA   ff(5 ff5   A~0  fA0  fff(5< ffffYf(t$P(|$@Hh     HH)|$ )t$0f( f(r fYff(%Q f(
9 fXf:	 f(f~Ё  fYf@  fY fff\LV      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfXV fX> fYfYfYfXfX ffXfY(t$0(|$ HHfff     ??f\f( fsA~$ L f(5 f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5~ ffXfYf( ff- ff(5 ff5 fffffff| fsA~   fA   ffs4ffYA~  fA  fYff(=~ ff=a fA~   fA   ff(5M ff50  A~0  fA0  fff(5l ffffYf(t$0(|$ HH     %Ҩ  %Ĩ  %  %(  %r  %$  %&  %(  %*  %,  %.  %0  %2  %4  %֨  ff     @UH HE t
e HMPpH ]@UH HE t
e HMp@H ]@UH HE t
e HMPH ]Hp  Hp  Hp  Hp  HH   DnHp   Hp  鼇Hp  Hp  餇H`   H`   H4H`   HTH`   H(mH`   H@iH`   HXmHH   iH@   tHH   tH(   @UH HE t
e HMHPmH ]@UH HE t
e HMHPiH ]H8   {@UH HE te H   pH ]HP   $HP  HH`   lH`   HlH`   HHlH`   H`tlH`   HxdlHP   $H@   H`   HX   H   @UH HE te HM`H   x  H ]H`   HH%У  H`   dHP  HH@   H@  (H   dH   HTH   HH   H8H0   $H0   HP   H    H@   HH   H   $.H   H   HP   HP   H@   H@   |H(   H(   H(   djHP  H0  H0  ̃H0  H0  鴃H0  騃H0   lH0  鐃H0  鄃HP  tH0  hH0  ,H0   H0  DH0   H0  ,H0   H`   dHP   HTH`   HHP   H8H`   ,Hh   H`   HHh   H`   HHh   H`   H0H(   dHH   XH(   LHH   @H`   KHp   xH`   H@hH@  @UH HE te HM@H   ܠ  H ]H@   H H%  H0   H%  H@   zH@  鞁HT$UH HLE0H HMHOL HHMhHMHQHEhH   HCEhH
!  HMH3HMPHMXHE0E8HUPHM0u  H^ HEHA   H HMHHH   Hh   ۀHH   _HT$UH HLE H@ HM8L HHMX+HM8聀HEXH}pHCEXH
T  HM83HM@HMHHE E(HU@HM   H HE8A  H HM87H8   HX   H8   HT$UH HLE H HM8Lg HHMXkHM8HEXH}pHCEXH
  HM83HM@HMHHE E(HU@HM   Hќ HE8A  H HM8wH8   ZHX   NH8   Hp   4HP   HT$SUH(HHMHHHPHH;uHAH HHEHLE0I H/ H   L HHMP[LHHMpKHMP~H   ~HEpH   HCEpH
d  HMP3HMXHM`H   ƅ   HUXH     H HEPA@  HW HMP>H   !~HP   ~Hp   	~HP   H   H   HH   HH   H($dH   H@D`H   HXdH   ^H   cHh   `H8   gH   X}H   cHh   cH8   DgH   (}H0   H(   T	H(   H	HP   H   $	@UH HE0te0H   	H ]H   |H   |H   |H`   bH   o|HT$SUH8HHǅ      Hǅ       ƅ    A4   H H   ;H]8HH   HP@H   	|Hǅ      Hǅ       ƅ    A   H H   HH   HP@H   {H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   tHH   HP@H   F{H'  HEH3HEPHEXHJ HE8E@HUPHM8t  H HEHHJ" HMH_H   zH   zH   z@UH HE0te0H   H ]H   zH   zH   zHH   `H   kzHx   `HT$SUH8HHǅ      Hǅ       ƅ    A*   H H   +H]8HH   HP@H   yHǅ      Hǅ       ƅ    A   H H   ӵHH   HP@H   yH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   dHH   HP@H   6yH  HE`3HEhHEpH: HE8E@HUhHM8d  H HE`H:  HM`OH   xH   xH   xHT$UH0HHǅ      HEx    Eh A/   H7 HMh薴HM0HHUhP@HMhmxHN  HEH3HEPHEXHq HE0E8HUPHM0  H HEHHq HMH膻Hh   xHT$UH HHEh   HE`    EP A/   H HMPHM HHUPP@HMPwH  HE03HE8HE@H HE E(HU8HM   H HE0H HM0ٺHP   fwH(   TwHP  DwH0  8wH0  ,wH0   wH0  wH0  wHP  vHP  vHP  vH0  H0  H0   HP  vH`   yH   ?H   H   H@H0  dvH0   (H0  LvH(   4vH(   (vH(   vH(   vH(   vH(   uH(   uHP   H   H   H   HP   HX   H`   H`   HH@   H@   H    H    H   tHx   iHH   餞H@   DHP   鄞H   $H   H0   H0    H     H     H   HH   H@   鸾H8   鬾HX    HP   tH0   (H    H0   HLH0   H8鼺H0   HpLH0   H   9H    H@   HH   H@   H@   H ZHH   xH@   H8h@UH HE$t
e$HMP0PH ]H   >sHX   "HX   H@   H    OH`  rH@  rH@  rH@  rH@  rH@  rH@   DH@    H@   H0YH@   HHXH@   H`XH@   H   XH@   H   [H@   H   H@   H   XH@   H   XH@   H   [Hp   THX   XXH  qH  qH   qH0   (XH  qH  qH   qH  qH0   WH  pqH  dqH   XqH  LqH0   WH  4qH  (qH   qH  qH0   tWH  pH  pH   pH  pH0   8WH  pH  pH   pH  pH0   VH  pH  tpH   hpH  \pH0   VH  DpH  8pH   ,pH   pH0   VH0   xVH  oH  oH   oH  oH0   <VH  H  oH  oH   oH  oH0   UH  xoH  loH   `oH  ToH0   UH  <oH  0oH   $oH  oH0   |UH   oH  nH   nH  nH0   @UH  nH   (UH  \XHT$UH0HH   L H   H   H`   TH`   AHH   TH@  PH0  4nH  (nH  nHP  nH  nH0  hTHT$UH0HHǅ(     Hǅ       ƅ   A   H H  ũH8  HPLH  H  1HH  AHJ H  ԰H  amH  UmH  ImH  =mH  1mHP  %mH  mH0  }SHT$UH0HHǅ(     Hǅ       ƅ   A   H H  ڨH0  HPLH  H  FHH  VH_ H  H  vlH  jlH  ^lH  RlH  FlHP  :lH  .lH0  RH0  RHT$UH0HHǅ(     Hǅ       ƅ   A#   H/ H  H  HPLH  H  OHHX  _Hh
 HX  H  kH  skH  gkH  [kH  OkHP  CkH  7kH  QHT$UH0HHǅ       Hǅ(      E33H  WA'   H H  H(  HPLH  H  ZHH  jHs H  H  jH  ~jH  rjH  fjHP  ZjH  NjH  BjH  PH  PHT$UH0HHǅ       Hǅ(      E33H  VA"   H H  H   HPLH  H  YHHp  iHr Hp  H  iH  }iH(   diH(   XiH(   LiH(   @iH(   4iH(   (iH(   iH(   iH(   iH    ĹHH  hH(  hHh  hH(  hH  hH(  hH  hH(  hH(  hH(  |hH(  phH(  dhH(  XhH(  LhH(  @hH(  4hH(  (hH(  hH0   ԸHP  gH0  gHp  gH0  gH  gH0  gH  gH0  gH0  gH0  gH@   HMH@   H MH@   H@ QH@   HX@\H@   H0gH@   H(@UH HE t
e HMH \H ]HT$UH0HHM8HPH
  HMh3HMpHMxHE@EHHUpHM@  H/ HEhHl HMhH   LHP   LH   <H  `fH8   H@UH HE4te4H   LH ]H   LHH   xLH   ̶H  eH0   HHh   HL@UH HE@t
e@HMx LH ]H   nH  eHH   &HH`   DH8   H@UH HE0te0H   KH ]H`   H`   HpH`   H  ZH`   H  DH`   H  YH`   H  DH`   H  %KH`   H  BGH`   H0  YH@   tYH    hYHH   \d@UH HHU@HMHzH ]@UH HHU@HMH^H ]HT$SUH8HH]PHHtJHS(HKH+H*HHLI?LHH    HC    HC    33	HT$SUH8HH]PHHtJHS}-HKH+H*HHLI?LH裀H    HC    HC    33虦HT$SUH8HH]PHHt3HS)HLCL+I:H    HC    HC    33@HT$SUH8HH]PHHt3HSm)HLCL+IڐH    HC    HC    33H`   db@UH HEhtehHMPH   8  H ]HP   H H%`  HX   H%
  @UH HEPtePHM@H     H ]H@   H H%  @UH HEPtePHM@H     H ]H@   HH%   H8   $DHT$SUH8HH]PHHtJHS
&HKH+H*HHLI?LH~H    HC    HC    33yHP   HP   H JH(   XGHT$SUH8HH]`HHtJHS*HKH+H*HHLI?LH}H    HC    HC    33٣H@   d`H(   鴤H@   H%:  HT$UH HHUhHUhHӪHExHH ]HT$SUH(HH]`HCHr\HHHvˀ  H=   r<t  HAH;r  H+Hs  H'v  H詗HC   HC    H{rH 33٢H(   H(   HHT$UH HHUpHHcHHA   '|  HMH ]H(   H(   HT$UH HHUpHHcHHA   {  HH ]H(   TH(   験HT$UH HHUpHHcHHA   {  HH ]H@   H0  h^Hh   H`   Hh   H`   H|Hh   pH`   H(`H(   锒H(   uHT$UH HHUPHHcHHA   z  HH ]H(   D@UH HE t
e HM@]H ]H   TH   TH   H8   HP   L@UH HE0te0HMPH   |  H ]HP   H H%0{  H@   H%{  HP   馭HP  \HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH
H0]HT$UH0HH*H0]HT$UH0HHJH0]HT$UH0HHjH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH
H0]HT$UH0HH*H0]HT$UH0HHJH0]H  AHp   DHP   lAH  NH  =@UH HEDteDH  H   y  H ]H  H H%x  Hh   H%y  H  WH  {Z@UH HEDteDH  H   Py  H ]H  H H%xx  Hh   H%"y  H  H  Z@UH HEDteDH   H   x  H ]H   H H%x  Hh   H%x  H   酪H  YHT$UH@HH  萱LU@H   蝹H  H  餺H   HIH  LIH  @IH0  HP  (YH  H  @H  L@UH Hp   H  H ]H8  MH  H   鰺H   $?HP  ؜H   ?HP  MHh  MH   xXH   lXH  `XH   >Hp  >HP  <XH  0XH0  $XH0  Hp  XH0  AHp  LH  WHp  AH0  @>HP  4>H8   $>H   HT$UH0H33H8   =H   騚HT$UH0Hv33賚H8   =H   hHT$UH0H633sH8   d=H   (HT$UH0H333H`   DH`   8H   =H`    H`   H   <H`   H  <H`   <H   <H   <Hx   <H(  <H(  <HT$UH`HHP  L} HH  	HP  |@UH HE t
e HM0JH ]H8   UHH   4?@UH HE te H   A5H ]H0   7H0   7@UH HH   H   gH ]@UH HH   H   EH ]H`   H%Jr  HP   H%:r  @UH HEPtePHM@HP輮H ]@UH Hꋅ   t   HM(HP膮H ]@UH HX   HM@qH ]HT$SUH8HH]PHHtJHS-HKH+H*HHLI?LHSqH    HC    HC    33I@UH H0   H   ދH ]@UH Hꋅ   t   HM(yq  H ]H   H%q  @UH HEHteHHM@H   Xr  H ]H@   H H%q  HP   H%*r  H8   鴕@UH HEPtePHM@HPH ]H@   zKHT$SUH(HH] HKr  HK r  HK(r  33
HT$SUH8HHU0HM8ELE@HU8踀33ՕH@   dH@  HRH0  LH   0R@UH HE@te@HM`H   q  H ]H`   HH%`p  HH   H%p  H`   H`  Q@UH HE@te@HP  H   p  H ]HP  HH%o  HH   H%qp  HP  }H@  aQHP   H   ľ@UH HE te HM0HP0H ]H0   鎾H8  >H0  v>H0   <H
 @UH HX   H@  ܈H ]@UH HE te H@  HP觪H ]H   HH   Ծ@UH HE te HM0HP`H ]H0   鞾H8  =H0  =H0   <H
W @UH HX   H@  H ]@UH HE te H@  HPשH ]H   H!H@   D2H0   t/@UH HE te HM`H   ln  H ]H`   H H%m  HP   H%>n  H`   
H`  .OH`   1HH   x5H   NHP   1@UH HE@te@H   15H ]H   D1Hx   5H  \HT$SUHHHHǅ     Hǅ      ƅ   E3Hx  H  [H   HH  HP H  &NHǅ     Hǅ      ƅ   An   H|  H   HH  HP H  MH   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  葉HH  HP H  cMHǅ     Hǅ      ƅ   A   H)  H  =HH  HP H  MHǅ     Hǅ      ƅ   Ah   He  H  HH  HP H  L E@HވHH][H  LH  LH  {LH  oLH  cLH  'HH   KAH  ?LH  2H  H   H  2H  ӜH   .H`   X2H  鬜H  ;H  H(  -<H   H  8H  iH@   @H  KH   1H  9H  ]KH  !H  EKH  1H  H  1H  H  	KH  JH  JH  JH   t-H`   81H  錛H  ;H  HH  
;H   H  7H  IH@   m?H  aJH   0H  H  =JH  H  %JH  0H  ݚH  q0H  ŚH  IH  IH  IH  IH  T,H   0H  H   H   H   Hx   l>H   $H   HP  +Hp   /H   \H   6H  +Hp   h/H   ,H   VHP  t+Hp   8/H   H   6H  D+Hp   /H   H   OH   +H   .HX   \=H   PHHx   Hx   H8  dH8  XHH  |.H   p.H8  4Hx   X.H   L.H  @.H   4.H   (.H   .H   .H  dH   GH  LH   pGH  4H   XGH  H   @GHT$UH`HH  'L H  1H  餶H@  4H@  (HH  L-H   @-Hp   4-H   (-H  -H   -H   -H   ,H   ,H  @H   dFH  (H   LFH  H   4FH  H   FHT$UH`HH  L H  
H  逵HP   D,Hh   8,@UH HEDteDH  H   d  H ]H  H H%c  HH   H%od  H  ;H   _E@UH HEDteDH  H   4d  H ]H  H H%\c  HH   H%d  H  ҕH  D@UH HEDteDH  H   c  H ]H  H H%b  HH   H%c  H  iH  D@UH HEDteDH   H   bc  H ]H   H H%b  HH   H%4c  H    H  $DHT$UH@HH  LU@H   H  鋳H@   D*HX   8*H   ,*HT$UH@HH   裛L  H   譣H    HT$UH HHU HMPf33ÆHT$UH HHU HMPf33蓆@UH HHUPHMXJH ]HT$UH HHUPHMh33G@UH HE0te0HM@H   a  H ]H@   HH%a  H@   H0  BH   ;H   :H  TBHx   kH  <BH   H  $BH`   (H  $H@   p(@UH HE\te\H   H   `  H ]H   H H%_  H  H%`  H   sH  AH  [H  OH  sAH(   dAH(   XAH(   LAHp   
H   tH(   AH(   AH(   @H(   @H(   @H   $
H  
H0  
H   
H   H   H   Hx   Hh   Hh   H   H   @UH HE te H   )H ]H   iH   iH   |HX   H  ?H  ?H8  \iH  PiH@   H  8iH  ,iH@   H  i@UH HEPtePH  H   I^  H ]H  H H%q]  HH   H%^  H  H  {%H8  >H8  >H8  >H8  >H  >HT$UH@HL
 HY 
H   7hH   +hH  >H  s>@UH HEHteHHP  H   H]  H ]HP  HH%\  Hh   H%]  HP  &H  
>@UH HEHteHHP  H   \  H ]HP  HH%7\  Hh   H%\  HP  H  =HT$UH@HH   pHH@]H  
gH   gHP   H  fH  fHP   H   fHT$UH@H8    HrH@]H  龍H  <H  馍H  <H   ^fH   DfH   8fH   HX   H0  t<H0  h<H`  eH0  eH@   H0  eH0  eH@   pH0  e@UH HEPtePH`  H   Z  H ]H`  H H%Z  HH   H%Z  H`  里H0  "H`  ;H`  ;H`  ;H`  {;H  d;HT$UH@HL
@ H dH   dH   dH  ;H  ;@UH HEHteHH`  H   Y  H ]H`  HH%@Y  H`   H%Y  H`  H  :@UH HEHteHH`  H   Y  H ]H`  HH%X  H`   H%QY  H`  ]H  A:HT$UH@HH   SH<H@]H  cH0  cHP   EH  cH  }cH0  qcHT$UH@H    HH@]H  jH  9H  RH  v9H0  
cHT$UH0HL   HU8H      H   HH(HoH0]H0   H0  9H  DH  8H  ,H   H0  H   H   H   HT$UH HL   H   33{H@   HH@   HH@   H(H@   H8H@   HHpH@   HX`H@   H   7H   THH   HX   +H0   HH   HH   @UH HEPtePHM@HP|H ]H@   麥@UH HEPtePHM@HP<H ]H@   隤@UH HEPtePHM@HPH ]H@   z-HT$UH0HHMPJ633zH@   H@   @UH HE0te0H   H   mU  H ]H   H H%T  Hh   H%?U  H   HT$UH0HM8M8LEXIA;|'H" HD$ L
 H H
x sCHKH0]H@   $H@   @UH HE0te0H   H   T  H ]H   H H%S  Hh   H%oT  H   ;HT$UH0HM8M8LEXIA;|'HR HD$ L
 H H
 BHH0]HT$SUH8HH   H{  t'HM8HPHHK ~HHİ6S  H7H8][Hh   H`   Hh   H`   H Hh   H`   H0H   H   H@   HX   HX   @UH HHU0HM8JwH ]@UH HH   HM8+wH ]@UH HE4te4H   -H ]H   KHx   (H   郝H  |@UH HE4te4H   H   \R  H ]H   H H%Q  HX   H%.R  H   HT$SUH8HH  H   ?Hx H  2H]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  nHH  HP H  i233uH  S2@UH HE4te4H   H   (Q  H ]H   H H%PP  HX   H%P  H   ƂHT$SUH8HH  H   >Hx H  1H]8tHH   HPHǅ     Hǅ      ƅ   A   Hw  H  mHH  HP H  U1Hǅ     Hǅ      ƅ   A<   HC  H  /mHH  HP H  1H  HHPHsH;uHAHs HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  lHH  HP H  l0HH8][H  P0H  D0H  80HT$SUH8HH  H   <Hx H  0H]8tHH   HPHǅ     Hǅ      ƅ   AH   Hq  H  kHH  HP H  /H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  VkHH  HP H  (/33rH  /H  /H  .H  .H  .H  H  :HT$SUH8HH  H  i;Hx H  .H]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  7jHH  HP H  	.33fqH  -H  -H  -H  -H  -H  ~H  {~H  -H  -H  -H  {-H  ?~H  c-H  $~HH   H  <-H  H  $-H  }H  -H   -H  ,H  }H  ,@UH HEDteDH   H   K  H ]H   H H%J  H   H%K  H   O}H   s,H   Hp   nHp   nH   Hp   nHp   H   H  H   tH   hH8  \H8  PHT$UH`HHh  ǃLE H`  ыHh  DH@   H   HX   ̷HX   H0   鴷H0   騷Hp   HT$UH0HW    H95H0]H(    H   tH(   H@   @UH HꋅH  tH  HM@H   I  H ]H@   H H%H  H0   H%I  H@   P{H@  Hx  
H   Hp   霶HT$UHpHH2@Hp]H   eH   鹻H   H   hHx   <HT$UHpHHgEHp]H   H   YH   Hx  4H   Hp   ̵HT$UHpHHOIHp]H   H   IH   H   Hx   lHT$UHpHHdNHp]H   5H   H   Hp   Hp   H   H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   Hp  H0  ldH   HH0  HP H0  7(H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  cHH0  HP H0  'H0VHx][H0  'H0  'Hx   Hx   سH   Hh  
H   
Hp   霳HT$UHpHHYHp]H   eH   yH   	H   h
Hx   <HT$UHpHH@_Hp]H   H   H   Hx  4	H   Hp   ̲HT$UHpHH$cHp]H   H   	H   H   Hx   lHT$UHpHHOhHp]H   5H   驸H   mHT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  aH   HH0  HP H0  g%H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  &aHH0  HP H0  $HplHx][H0  $H0  $Hx   Hx   H   H8   gH`   
HH   
@UH HE0te0H  H   QC  H ]H  H H%yB  H@   H%#C  H  tHP  $@UH HE0te0H  H   B  H ]H  H H%B  H@   H%B  H  tH0  #@UH HE0te0H  H   B  H ]H  H H%A  H@   H%QB  H  tH  A#@UH HE0te0H   H   B  H ]H   H H%>A  H@   H%A  H   sH  "HT$UH0HH  zLU8H   ̂H  ?H  eH@   HX   H   HT$UH@HH   GzL  H   QH   đHX   H@   x@UH HE4te4H  H   @  H ]H  H H%@  H8   H%@  H  {rH  !@UH HE4te4H  H   t@  H ]H  H H%?  H8   H%F@  H  rH  6!@UH HE4te4H  H   @  H ]H  H H%3?  H8   H%?  H  qH   @UH HE4te4H  H   ?  H ]H  H H%>  H8   H%t?  H  @qH  d @UH HE4 te4H   H   9?  H ]H   H H%a>  H8   H%?  H   pH  HT$UH0HH  wLU0HMxH  eH   H0   tpHT$SUH(HH0  HM0F,HXH0  vHtHM HHU0P33bH   锫H   鈫H8   |H8   pH   dH   XH  LH  @H   4H   (H  oHT$UH0Hꋍ      P  ;|.U4H HD$ L
l LE4H9 H
 +HҗH0]H(   H@    H   鄪H   xHX   lHX   `Hp   THp   HH   <H   0H   $H   H@  nHT$UH0Hꋍ        ;|.U4H HD$ L
\ LE4H) H
ډ *H@H0]H   锵@UH HHEXD HUPHM(b`H ]@UH HEPtePHM@H`vH ]H@   HH    $aH8   @UH HE t
e HMX H ]H@   H   H   館H(   锨H(   鈨HH   |H   d@UH Hꋅ   t   HM(H`uH ]@UH Hh   HM@SH ]@UH HEPtePHM@HPuH ]H@   ڳH8   ħH8   鸧H(   鬧H`   H  鄧H  xH  lH  `H0  TH   HH   <H   0@UH HEPtePHM@H`tH ]H@   H   H  H8  |HX  pH0   \H   H   DH  8H0   \H   pH(   dH(   XHP  $cHP  HHP  H HP  H84 HP  HPdH@   HX    H   0H   Hp   \Hp   [H   Hp   [Hp   H   H  H   H   H8  |H8  pHT$UH`HHh  pLe H`  xHh  dHP   $H8   H@   H`   ؤH   LiHT$SUHHHH  H   %Hx H  GH]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  SHKHH  P H  HVHH][H  HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  \SH   HH0  HP H0  'H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  RHH0  HP H0  H3[Hx][H0  H0  Hx   ԢHx   ȢH   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H   H0  ,RH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  QHH0  HP H0  H_Hx][H0  lH0  `Hx   餡Hx   阡H   鬿HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  PH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  PHH0  HP H0  XHbHx][H0  <H0  0Hx   tHx   hH   |HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  OH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  VOHH0  HP H0  (HfHx][H0  H0   Hx   DHx   8H   LHT$SUH8HH]PHHtJHSHKH+H*HHLI?LH/H    HC    HC    33UHT$SUH8HH]PHHt3HSHLCL+Ij@H    HC    HC    33pUH8   4UHh   XH@   L@UH HE0te0H  H   0  H ]H  H H%/  H`   H%0  H  ObH0  s@UH HE0te0H  H   H0  H ]H  H H%p/  H`   H%0  H  aH  
@UH HE0te0H  H   /  H ]H  H H%/  H`   H%/  H  }aH  @UH HE0te0H  H   v/  H ]H  H H%.  H`   H%H/  H  aH  8@UH HE0 te0H   H   
/  H ]H   H H%5.  H   H%.  H   `H  HT$UH0HH  gLU8H   oH  6H0   RH@   țH   RH`   騛HH   H@   tRHP   x@UH HHU`HMPJRH ]HT$UH HHU`HMh33GR@UH HHU`HMP
RH ]HT$UH HHU`HMh33RHT$SUWH0HH   HO@!HO xHF33Q@UH HHUXHMPQH ]HT$UH HHMh>F33QHT$SUWH0HH   HO@HO 
H F33MQ@UH HHU`HMP
QH ]HT$UH HHU`HMhj33Q@UH HHUHHMPPH ]HT$UH HHM@~E33P@UH HHUHHMPPH ]HT$UH HHM@>E33PH(   dH(   XH   <PHT$UH Hv33GPH   4H0   H%+  HT$UH HH^H ]@UH HHUPHMXOH ]HT$UH HHUPHMh33OH`   HH   Hx   HX   tHP   hH@   \H0   NH   jH   |jHT$UH HHMHHt
H   33
OHT$UH HHMHHt
H   33NHh   HP   HT$SUWH0HH   HO@HO (H0C33}NHT$SUWH0HH   HO@HO 
HB33=N@UH HHE(D HUxHM0MH ]HT$SUWH HH]pH   H;t-Hf     HK~*  Hu*  H[(HCH;u33MH  d@UH HEPtePHM@HP,dH ]H@   Z@UH HEPtePHM@HPcH ]H@   
H   
H   H   HH8   HP   Hh   4@UH HEPtePHM@HPLcH ]H@   iHH   dH   HTH@   HH   H@   HH   8@UH HEPtePHM@HPbH ]H@   *gH   tH  hH8  \HX  PH0   JH   hH   Hh  8H@   H8   H   4H(   Hh   Hh   H   |@UHH3Ɂ8  ]@UH HM@H ]>@UH H<M8H ]>@UH0HHHL$(T$ L
?LEpUhHM`/<H0]HH   @UH HE te H   H ]H0   H`   sH0   g@UH HE te H   DH ]H    @UH HE8t
e8HMXrH ]H`   `H   T@UH HE te H   H ]HX   H@   H   wH0   @UH HE te H   xH ]@UH HE te H   H ]HX   
H@   H   H0   @UH HE te H   H ]H0   @UH HE te H   H ]@UH HE t
e HM@H ]HP   H   Hx   HP   H   Hx   H(   H@   uH(   iH@   ]HP   qH   eHx   YHP   MH   AHx   5HP   )H   Hx   H@   H(   Hx   H@   H(   H   H`   -H8   a]H(   ]H   	HX   H@   HT$UH@HYH.  Hٗ [    t:  H}H@]Hx   H`   HH   H0   HT$UH HMYH&.  Hg    s 4  HH ]HP   1H8   %HT$UH HXH-  H
     3  HH ]H0   \H    ;\@UH HH  H   Y:H ]HT$UH HyXHR-  H     $  HXZH ]HP   [H@   [H   @UH H  H   9H ]HT$UH HWH,  H
  y   
"  HoH ]@UH H(  HM0t9H ]HT$UH HWHm,  H 0 z   "  HnH ]@UH HH  H@  9H ]HT$UH H2WH,  HL Ύ   X "  HlH ]HT$UH HVH+  H
     #  HalH ]H8   DZ@UH HEPtePH   !ZH ]H   H   # H8   Y@UH HEPtePH   YH ]H   H   HP   zYH@   YH   H   H   HT$UH HHM(HPHH
#  H	 #  HUH ]HT$UH HHM0HPHH
$  H	"  HUH ]HT$UH HHM8HPHH
#  H	"  HmUH ]HT$UH HHM@HHPHAH;uHAHA HHEHH
+"  H	R"  HUH ]HT$UH HHMHHHPH$AH;uHAH,A HHEHH
!  H	!  HTH ]HT$UH HHMPHPHH
~"  H	!  H|TH ]HT$UH HHMXHHPL I;uHAH@ HHEHH
"  H	a!  H TH ]HT$UH HHM`HHPH3@H;uHAH;@ HHEHH
N   H	!  HSH ]HT$UH HHMhHHPLW I;uHAH? HHEHH
"  H	   HhSH ]HT$UH HHMpHHPL I;uHAH? HHEHH
"  H	M   HSH ]HT$UH HHMxHPHH
   H	   HRH ]HT$UH HH?  H
   H	  HRH ]H(   @UH HE t
e HM0kH ]HX   H8   H   HH   [H8   HX   H   HH   [HH   H   H8   H   H  <]H  p]H  $]Hp   ]H  AH   ]H  H pH  H8GH  HpPH  $EH   \H   H (H   H8GH   HpH   DH   p\H   @@UH H꺸  HMPu2H ]Hp   ;\Hp   ?H   #\H   H HX   \H   H8FH   KDHh   [Hh   H OHX   [Hh   H8FHh   DH0   [HX   [H0   C@H  w[H(H= r_H
ˈ <H׈ HH=   r<t1  HAH;r!  H+Hs  H'v  H#1H    Hm     V  H(-<H(H= r_H
ˇ <Hׇ HH=   r<t  HAH;r  H+Hsq  H'vd  H0H    Hm     V  H(;H(H=܆ r_H
 f;Hǆ HH=   r<t  HAH;r  H+Hs  H'v  H/Hp    H]     F  H(:H(H=, r_H
 :H HH=   r<tQ  HAH;rA  H+Hs1  H'v$  HC/H    H       H(M:H(H=, r_H
 &:H HH=   r<t  HAH;r  H+Hs  H'v  H.H    H       H(9H(H= r_H
 9H HH=   r<t  HAH;r  H+Hs  H'v  H.HP    H=     &  H(
9H
i $QH
ɣ QH(H=$  t:88L! H
 L+I%WH       H(H(H=L  t:}8x8LI H2 L+I%WH(      H(H(H=̡  t:-8(8Lɡ H L+I^%WH      H(hH(H=  t:77L H L+I$WH     x H(H(H=4  t:}7x7L1 H L+I$WH      H(H(H=  t:-7(7L H L+I^$WH     p H(H
 OH
 OH(H   Hy "H
y HuH(                                                                                                                                                                                                                                                                                                                                                         P     v                         ب                    "     <     P     l                    Ω                    (     B     ^     ^             Κ     
     V               Z                    P          |     :               R                         r     t                         F     j               Ȗ     ޖ          ؛          "          ڧ               `     B               Ħ          x     R          ԥ          P                    8               x     *               T          ̡          B               v     6          ğ          4          t               Z     $     @                            ʪ     Ԫ                    ,     D     N     d                                                   Ԭ     ެ     T                       Ϋ     ʮ     ڮ                                   
          Ү                                 p     T     8                              ,                  p          \     @     6          "               ī             f          z     ֫                  J                       t     `     L     6                          Б                    h     V     H     6                         ؐ     ʐ                    |     n     `     J     2     "               ؏     ʏ                    r     X     B     2          
               ֎     Ǝ                    ~          X     H     :                    ލ     ʍ                    |     d     N     >     0                         Ȍ                    p     `     F     2     "                    ҋ                    t     `     F     .                    ܊               ֒          0     B          R     n                              ̓     ړ           r                     ,     @     T     V     B     h     ~                    Ԕ                         0     N     4          f     "                    ҉                    p     V     B     2                     ؈             P    pK           H         `             @    `                        0            P                      `                                                           0                                                                                       "   H6             8            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        Ч
   0           Z   [   
           
           H
   (       bad array new length    
      P
   @   P    P       P    
   @              warning OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np  @            ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  ImportError 1   __getstate__.<locals>.genexpr   reshape num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info misc    __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  1   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    pystan._compat  iter_save_wo_warmup     Stan model {} is of mode 'test_grad';
sampling is not conducted.    upar        data sim model_name model_pars par_dims mode inits stan_args stanmodel date get adapt_window       init_alpha  get stan_args_method_t  b   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  B   warmup2 PyStanHolder    __str__ traceplot   shape   UNIT_E  h   int_time    range   method  H   pystan.plots    _summary    NUTS    lp__    array   fitptr  i   (dense_e)   append  I   stansummary l   AttributeError  gradient    order   pystan  L   sampling_algo_t pars    data_args   DIAG_E  q   ndarray is not C contiguous Q   adapt_t0    error   unit_e  f   pars_oi_bytes   epsilon adapt_iter  d   handler tol_rel_obj user    probs   vars_i  g   warnings    index   chains  Zf  __import__  Zd  collections Zg  stepsize    split   metric  O   extract (diag_e)    OPTIM   holder  par grad_samples    _get_kept_samples   dstack  sim _pars_total_indexes s   chain_id    utf-8   format  s   ndarray is not Fortran contiguous   double  end model_code  end StanFit4Model   TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   chains  '   Couldn't allocate space for StanHolder. _verify_has_samples name    LBFGS   loader  s   Metropolis  s   output_samples  dims_oi samples pystan.constants    throw   origin  %s  _check_pars int string_types    _remove_empty_pars  =   _call_sampler_star  #   adapt_kappa keys    send    flush   parent  =   row_stack   'char'  #   SAMPLING    start   'long'  =   MemoryError #   squeeze seed    variational =   init_list   #   save_iterations `inc_warmup` ignored when `permuted` is True.   
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          data    tuple   =   tol_rel_grad    BFGS    init_radius #   __test__    inits   =   `dtypes` ignored when `permuted` is False.  #   sampling    value   =   adjust_transform    inits   #   _split_data =   RuntimeError    __getstate__    VARIATIONAL #   genexpr Format string allocated too short, see comment in numpy.pxd =   elbo_samples    variational_algo_t  #   tol_param   thin    numpy   =   DENSE_E refresh adapt_term_buffer       Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. #   newaxis flatnames   flat    dtype   =   getLogger   #   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581 Couldn't allocate space for stan_fit.   init    sampler_params  pystan.misc warn    numpy   =   digits_summary  numpy.core.multiarray failed to import  column_stack    __name__    numpy   #   adapt_delta =   stepsize_jitter fnames_oi   #   sampler_t   =   control random_seed #   numpy.core.umath failed to import   =   handlers    numpy   #   (unit_e)    numpy   =   logging adapt_init_buffer   #   Non-native byte order not supported =   diagnostic_file argsptr adapt_engaged   numpy.core.multiarray   C:\Users\appveyor\AppData\Local\Temp\1\tmpd0nz_j4u\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.pyx  adapt_gamma #   history_size    _call_sampler   numpy.core.multiarray failed to import  _ARRAY_API  =   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  #   _ARRAY_API is NULL pointer      numpy.core.umath        module compiled against ABI version 0x%x but this version of numpy is 0x%x      module compiled against API version 0x%x but this version of numpy is 0x%x  =   FATAL: module compiled as unknown endian        FATAL: module compiled as little endian, but detected different endianness at runtime   numpy.core.umath failed to import   #   _UFUNC_API  =   _UFUNC_API not found    _UFUNC_API is not PyCapsule object  #   _UFUNC_API is NULL pointer  =   SSE, SSE2   #   empty_nested() must be true before calling recover_memory()     empty_nested() must be false before calling recover_memory_nested() self        empty_nested() must be false before calling set_zero_all_adjoints_nested()  =   stan_version_major  #   stan_version_minor  =   stan_version_patch  #   unknown file name   =   unknown file name       __init__.pxd    Unknown exception       C:\Users\appveyor\AppData\Local\Temp\1\tmpd0nz_j4u\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.cpp  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.pyx #   stringsource    type.pxd        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.__getitem__        attr_names      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.__getstate__.genexpr       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.__getstate__   list        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.__setstate__       Expected %.16s, got %.200s  list        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.__reduce__ stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.num_failed.__get__ dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.num_failed.__set__ list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.test_grad.__get__  list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.test_grad.__set__  list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.inits.__set__  =   Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.par.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.value.__get__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.value.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.args.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.mean_lp__.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.mean_lp__.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder.sampler_param_names.__set__    ufunc   #   Expected %.16s, got %.200s  =   Expected %.16s, got %.200s      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._pystanholder_from_stanholder   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._dict_from_stanargs #   'NoneType' object has no attribute '%.30s'  =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  _call_sampler_star      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._set_stanargs_from_dict stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._dict_to_vars_r dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._dict_to_vars_i self    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._call_sampler_star  #   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._call_sampler   Expected %.16s, got %.200s      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581._call_sampler   __cinit__       attr_names  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__cinit__ __init__    numpy   =   __init__    'int'   #   __init__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__init__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__getstate__.genexpr      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__getstate__  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__setstate__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__reduce__        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.plot  =   'NoneType' object is not subscriptable  extract stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.plot  #   traceplot   =   traceplot       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.traceplot stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.traceplot extract 'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.extract   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.extract   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__unicode__       stansummary upar        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__str__   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__repr__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.__getitem__   #   stansummary args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.stansummary       summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.stansummary       grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.summary   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.summary   log_prob    throw   =   log_prob        grad_log_prob   get_logposterior        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.log_prob  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.log_prob  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.grad_log_prob dict        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.grad_log_prob args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_adaptation_info   #   get_logposterior        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_logposterior  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_logposterior  get_sampler_params  =   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_sampler_params    throw   #   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_sampler_params    close   =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_posterior_mean        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.constrain_pars    PyObject_GetBuffer: view==NULL argument is obsolete     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.unconstrain_pars  'NoneType' object is not iterable       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_seed  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.get_stancode      numpy.ndarray.__getbuffer__ plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.flatnames.__get__ 'NoneType' object has no attribute '%.30s'      numpy.PyArray_MultiIterNew1 data        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._verify_has_samples       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._update_param_oi  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._get_param_names  numpy._util_dtypestring stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._get_param_fnames_oi      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._get_param_names_oi       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._get_param_dims   numpy.import_array      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._get_param_dims_oi        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.constrained_param_names   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.unconstrained_param_names stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model._call_sampler #   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew2 mode        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model.sim.__set__   =   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 =   numpy.PyArray_MultiIterNew5 #   Expected %.16s, got %.200s  =   numpy.import_array  #   numpy.import_umath  T   numpy.import_umath  A   numpy.import_ufunc  S   numpy.import_ufunc  A   vector.to_py.__pyx_convert_vector_to_py_double  string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    %d.%d   S   string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   t   string.from_py.__pyx_convert_string_from_py_std__in_string  A   vector.from_py.__pyx_convert_vector_from_py_size_t      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ date        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  #   num_failed  #   test_grad   #   mean_pars   #   mean_lp__   # 
 adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.PyStanHolder    extract Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  #   traceplot   #   __unicode__ 1.0 stansummary 1.0 summary log_prob    a_row   1.0 grad_log_prob   get_adaptation_info 1.0 get_logposterior    a_row   1.0 get_sampler_params  [   get_posterior_mean  ,   constrain_pars  unconstrain_pars    ]   get_seed    #   get_inits   #   get_stancode    get_stanmodel   _verify_has_samples #   _update_param_oi    #   _get_param_names    .   _get_param_fnames_oi    _get_param_names_oi .   _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel   type        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.StanFit4Model   ndarray Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.__pyx_scope_struct____getstate__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.__pyx_scope_struct_1_genexpr    name    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.__pyx_scope_struct_2___getstate__       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.__pyx_scope_struct_3_genexpr    cython_runtime  '%.200s' object is not subscriptable    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581 builtins        builtins        flatiter        broadcast       __loader__      __package__ send        Interpreter change detected - this module can only be loaded into one interpreter per process.  __file__        __path__        submodule_search_locations      Module 'stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581' has already been imported. Re-initialisation is not supported. builtins        __builtins__    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581 need more than %zd value%.1s to unpack  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581 at most init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581    init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581    name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope       while calling a Python object   while calling a Python object  NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      cannot fit '%.200s' into an index-sized integer too many values to unpack (expected %zd)        at least        exactly %.200s() takes %.8s %zd positional argument%.1s (%zd given)     %s() got multiple values for keyword argument '%U'      %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       calling %R should have returned an instance of BaseException, not %R    %s() got an unexpected keyword argument '%U'    '%.50s' object has no attribute '%U'    '%.200s' object is unsliceable  Missing type object user        Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'      Expected a dimension of size %zu, got %zu       Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected S   Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d    gamma   T   Expected a comma in format string, got '%c' Y   Expected %d dimension(s), got %d    delta   A   Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler   t   Big-endian buffer not supported on little-endian compiler   A   Buffer acquisition: Expected '{' after 'T'  Y   Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)   S   'NoneType' object is not iterable   T   Missing type object Y   Cannot convert %.200s to %.200s '%.50s' object has no attribute '%U'    %.200s.%.200s is not a type object      %.200s.%.200s size changed, may indicate binary incompatibility. Expected %zd from C header, got %zd from PyObject      cannot import name %S   %.200s.%.200s size changed, may indicate binary incompatibility. Expected %zd from C header, got %zd from PyObject      value too large to convert to int       %s.%s size changed, may indicate binary incompatibility. Expected %zd from C header, got %zd from PyObject      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581 %s (%s:%d)  cap can't convert negative value to int A   value too large to convert to unsigned int  t   can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    gamma   A   can't convert negative value to pystan::stan_args_method_t  Y   value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   1.0 value too large to convert to pystan::optim_algo_t  1.0 can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    gamma   1.0 can't convert negative value to pystan::variational_algo_t  1.0 value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  1.0 can't convert negative value to long    _cython_0_29_7  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing 1.0 can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object     _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   collections.abc close() -> raise GeneratorExit inside generator.        if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections     Cython module failed to register with collections.abc module    Cython module failed to register with collections module    ,   backports_abc   object being iterated by 'yield from', or None  gi_code send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    error    /  gi_running  %]  gi_yieldfrom    __name__    model    [  name of the generator   __qualname__    qualified name of the generator generator       an integer is required  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581 k (internal counter)    compiletime version %s of module '%.100s' does not match runtime version %s     __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    value   S   boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.   T   grad_2F1        exceeded        Argument n out of range: got %1%         iterations, hypergeometric function gradient did not converge. grad_2F1    gamma   Y   boost::math::prime<%1%> is not converging   A   grad_reg_inc_gamma  t   is not converging   A   grad_reg_inc_gamma  Y    iterations, gamma function gradient did not converge.  exceeded    S   k (internal counter)    grad_reg_inc_gamma  T   grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    delta   Y   t_change    gamma   A   *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    Must use algorithm="Fixed_param" for model that has no parameters.  t   Output generated by Stan (test_grad)    Point Estimate Generated by Stan    gamma   A   Sample generated by Stan    cap Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    Y   Sample generated by Stan    S   Sample generated by Stan (Variational Bayes)    stepsize__  k_s treedepth__ k_s n_leapfrog__    divergent__ k_s energy__    gamma   k_s stepsize__  k_s int_time__  k_s energy__    delta   %1% # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    gamma   :   boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    gamma   %1% boost::math::cbrt<%1%>(%1%) %1% 0.003379167095512573896158903121545171688   :   0.0834305892146531832907    0.1e1   %1% -0.338165134459360935041    0.1e1   :   -0.0509990735146777432841   %1% -0.00772758345802133288487  :   -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    0.1e1   S   0.00858571925074406212772   k_s 0.000370900071787748000569  k_s -0.098090592216281240205    gamma   k_s 0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    delta   k_s 0.0195049001251218801359    k_s 0.00180424538297014223957   k_s 1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017    gamma   nan 0.337511472483094676155e-5  NAN -0.0243500476207698441272   %1% 0.0386540375035707201728    gamma   :   0.04394818964209516296  0.0175679436311802092299    %1% 0.00323962406290842133584   %1% 0.000235839115596880717416  :   1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373    %1% 0.00410369723978904575884   %1% 0.00295276716530971662634   :   0.0137384425896355332126    0.1e1   1.0 0.00840807615555585383007   0.0 0.00212825620914618649141   1.0 0.000250269961544794627958  1.0 0.113212406648847561139e-4  1.0 1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444    0.1e1   1.0 0.0105982906484876531489    0.1e1   0.0 0.000479411269521714493907  1.0 0.00628057170626964891937   0.0 0.0175389834052493308818    1.0 -0.212652252872804219852    0.0 -0.687717681153649930619    1.0 -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  C:\bld\fbprophet_1557940982590\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1557940982590\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   TEST GRADIENT MODE      Initial log joint probability =         Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  lp__    but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.    1.0 . Improved by    Log joint probability =    1.0 Iteration   1.0 Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  1.0 Optimization terminated normally:   1.0 Optimization terminated with error:     Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  1.0 Optimization terminated normally:   1.0 Optimization terminated with error:     lp__    lp__    t_change    0.0 *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    0.003379167095512573896158903121545171688   1.0 0.0834305892146531832907    0.0 -0.338165134459360935041    1.0 -0.0509990735146777432841   %1% -0.00772758345802133288487  :   -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    %1% 0.00858571925074406212772   :   0.000370900071787748000569  %1% -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)     0.9016312093258695918615325266959189453125e-19  0.25479851061131551     Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      -0.32555031186804491    Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      The argument a to the incomplete beta function must be greater than zero (got a=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Adjust your expectations accordingly!   Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Initialization failed.  Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.      Log probability evaluates to log(0), i.e. negative infinity.   Log probability=       Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:        Rejecting initial value:          Gradient evaluated at the initial value is not finite.         seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps         attempts.      ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       Exception initializing step size.       t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)  The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%)  Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Result of tgamma is denormalized.       The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.  Evaluation of tgamma at a negative integer %1%. Unknown function operating on type %1%  The argument a to the incomplete beta function must be greater than zero (got a=%1%).   Error in function       The argument b to the incomplete beta function must be greater than zero (got b=%1%).   Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Cause unknown: error caused by bad argument with value %1%      Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)    Random variable Location parameter      Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       -3.7595974497819597599e+11      7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "   G            H (          "   xH            H (          "   H             I P          "   I            I           "   $J            4J (          "   J            J           "   K            K (          "   hK            xK (          "   K            K 8          "   (N            @N h          "   N            N h          "   O            O            "   \O            lO            "   O            O h          "   <P            TP h          "   P            P h          "   (Q            8Q            "   Q         	   Q           "   @R         
   pR            "   R    $S    LS           "   V    4V    \V           "   W    <W 
   dW           "   |[    [    [ x          "   \    <]     ]           "   _         
   _           "   0`         
   X`           "   `            ` h          "   a            a           "   d    d    e            "   g            g            "	    h            Hh (          "   h            h (          "%   @i         '   hj x                               
   p   v   0   v      p   @   @v   `         ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx@
           
         0      
       
           `
   L    P       
   i   `5    p
   0   p{   0    {       p   @   z      
   d   L   R   X   ^   d   j   p   v   |      @             
   T    `Y    
   $    R   R   R   R   R   R   R   R   p
   @    
   P   Mb`MbPMbP?Mb`?       ȶ
   ,   H
        
   )       ؽ
   .   0     
                   P          
           H
            p    
   p!   P    P    P   P    H
   T    T    (
   D   
   R   R   R   R   R   R   R   R   
   <      T   P
    _    ^    
          (
   0A      
    ^    ]    ȹ
    _     s   
   B   @
            P       p   @             h
   R   R   R   R   R   R   R   R   0
   j       ذ
   0        
   Pj       p
           
   ,    0&     '    (    &    )    *    @+    +    H
          
   8   0
            P    X
         0         p   @      @   
   0   p{   0    {       p   @   z      
   `   P         @   @      @   (
   !   P    P    0   P    
            UUUUUU?UUUUUUUUUUUU?UUUUUU
   T    pZ    h
   `   @   P   P    P    
            
      0      Є      p   @      `      
    *       
   @0    P    P    P    P    P    P    P    P    P    P    p
   T    0W    X
      0      `      d         v   |            0      
   t   `      @
            
           
           h
           `
   0       l   
   p   
   ,    0&     '    (    &    )    *    @+    +    
         0/          H
      
   6    P    P    P    P    8
                     E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        
                                  
      
                @         P   
   P/    R   0/    R   R    
   `    R   P    P    P    P    P    
      @~      Є      p   @      `      
   B     ?    P?    ?    P7    `7    `7    P@    7    x
           
   T    x    h
   p         `      p   @   `   @      
   T    [    `
             0
           X
   d   
   ?      
   p   R   P    P       p   @   `   @   
      R   P    P       p   @      `   (
            
   P    0    
   6       
   R   R   R   R   R   R   R   R   
   `   L   R      p   d      p   v   |   p   `            @
    7    6    6    6    p6    
   `            
   
                 
      0      Є      p   @      `      
   R   R   0.    
   `        P    P    P    P    P     
       
           h
      
           0
           P
           
   p5    `5                             
 
                     	               	               
                                               
   |       
   0   t   0   v      p   @   @v   `   
            0   @            
   $    P7    `7    `7    P7    `7    `7    7    7    
           
         @      `
         0/          
           
   |   H
   @      X
   T   
   8   p
   p@      x
   T    W    
   `    
                  _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?
       x
                X
   p         `      p   @   `   @      
   P       
    5    0    p0    1    `1    2    P2    p3    @3    `4    04    
      P    P       P    `
   A          
            0    @
                    ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?
        
      
          @
          0         p   @      @      ?   =
?   @33?   =
?      ?   ?    ?
            P       p   @             h
   \          Ȭ
           @
   R   $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?H
      R   P    P        p   @          
            `      p   @   `   @      
   h          x
           
   H   
   p   x
   p   0      P       p   @             
           
              
            0      P
       X
           8
   =     8    P8    p:    7    `9    ;    <    0=    0
            P            gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@
   R       
            
   $       D   
   p   v   0   v      p   @   @v   `   '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        @
   Pi   `5    8
       y   0    {       p   @   z      `
            
   @   
         0         p   @      @   h
   ,   
             
    ^    v    
   T    S    Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context             bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product     to_matrix(array)        vector size     rows * columns  .   y   n   m   k   T   Y   A   variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   C:\bld\fbprophet_1557940982590\_h_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =     anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2      data initialization K   t   cap S       t_change    X   sigmas  tau     trend_indicator s_a s_m delta   beta    variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   trend   beta_m  beta_a      Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        right-hand side left-hand side  assign  Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!   , but must be >= 0!     C:\bld\fbprophet_1557940982590\_h_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      rep_array   cols    []  Undefined transformed parameter: trend  Undefined transformed parameter: Y      Undefined transformed parameter: beta_m Undefined transformed parameter: beta_a iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed       Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.                 iter             ELBO   delta_ELBO_mean   delta_ELBO_med   notes         MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   C:\bld\fbprophet_1557940982590\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "   "            p7 `          "   <            6           "   <            6           "                6            "   4            04 `          "   $3            03            "   $            2            "   2            2           "   X2            `2 0          "   ,            /            "   h/            p/ x          "   /             /          "               .            "   <            -           "   <            x-           "   ,            , X          "               x,          "   ,            (,            "   '            +            "   H6            x+            "   z            P+            "   Pz            (+            "   *            *            "   *            *            "   T5            p*            "   Xx            @*            "   '             (           "   '            '            "   H6            `'            "   `            ('            "               &            "   H6            &            "   H6            &            "   z            p&            "   Pz            H&            "   H6             &            "   H6            %            "   T5            x%            "   Xx            H%            "   ؞            $ 8          "   ؞            P$ 8          "   H6            #            "   "            " `          "   <            p"           "   !            ! 0          "               h! 8          "                (          "                X          "                 @          "                         "   `            p            "               (            "   H6                        "   H6                        "   z            h            "   Pz            @            "   H6                        "   H6                        "   z                        "   Pz                        "   .            p            "   H6            @            "   H6                        "   T5                        "   Xx                        "   T5                        "   Xx            X            "                         "                         "                       "   J    X     8          "   J         8          "   (            8 @          "   J    T                "   J                    "               @ X          "                (          "   L            X X          "                           "               8 @          "                           "               X            "   P            (            "                           "                           "           0            "   (    H 	   p            "   \
    
 
   
            "   
        0            "   T
    l
    
            "   	    	    	            "   J    4	    `	 0          "                       "   J        @ 0          "   d    |                "                       "   h             H          "                @          "   p             8          "        (              "   J    @    h 0          "   J         0          "             0           "                       "                      "   h                   "   L    |     p          "                 0          "                           "   |    L     X         "            
              "   $            8            "                X          "   L             X          "                           "                 p         "                           "   T                       "                p         "               H            "                0          "   t                        "               (            "   ػ                        "   $                       "   H6            (            "   H6                         "                           "                           "
                p         "   h            x H          "                            "                (          "
                p         "                (          "                (          "                          "                (          "   T            ` 8          "                (          "                           "                0          "               ( 0          "   H6                        "   H6                        "   z            `            "   Pz            8            "   H6                        "   H6                        "   T5                        "   Xx                        "   L            X            "   T5                         "                           "                           "                           "
       |     8         "                           "
   0                  "            (          "   $            8          "       | &    p          "               H @          "   T                   "        "              "       ,    `           "           0           "            `         "                      "   p         `         "   L                   "                         "                       "   t         `         "   T                   "   4    l     p         "                8          "   $            @            "                           "	                       "   `    0    ` X         "               @ x          "+        Y              "                 (          "                           "   @             P          "   @             P          "   @            x P          "   t                        "   J         0          "   x|            @            "   P                        "       ľ               "   d        н           "                           "   J    $    P 0          "   ػ                        "                           "   D            X            "                           "                           "   X            `            "                          "   L         	               "   J    Ը                 "               P p         "                           "   J        8 0          "         ;    P         "   T         *    (         "!        =    @         "   \         *    @         "   x|                        "   |            Ȫ            "   H6            `            "   z            8            "   Pz                        "   H6                        "   z                        "   Pz                        "   H6            p            "   z            H            "   Pz                         "                 (          "   <                       "   <            P           "
               p x         "   P                        "   إ             (          "   $            0           "                           "               `           "               @           "   d            X 8          "   Xx                         "   Xx                        "   T5            Р            "   Xx                        "   X            x            "   ؞            H 8          "   ؞             8          "   @             P          "                       "   J    d     (          "   J         (          "   К      
   0 x          "       `                "   4     '              "   ̓     )             "   |            @           "   |                       "                         "   `             @         "               (           "                          "                          "                          "                          "   p             @         "               8           "                           "               Ȏ           "                          "                         "   h         -               "            -   Љ           "       x %              "                H          "                8 x          "   l             H          "                8          "               0           "   <                       "   @             P          "                (          "
   ܀            0 P          "   a             8          "   b            h            "   @             P          "   p~             8          "   @              P          "   p~            ~ 8          "               0~ 8          "   J    }    } H          "   J    }    @} (          "   |            |            "   x|            |            "   H6            P|            "   {            |            "   {            {            "   J    {    8{ 0          "   H6            z            "   H6            z            "   z            z            "   Pz            Xz            "   H6            (z            "   d            y 8          "   d            @y 8          "   H6            y            "   H6            x            "   T5            x            "   Xx            `x            "   w            w            "   Pw            Xw            "   dv            v (          "   v            (v (          "    t    t '   t @         "   4s    Ts    s 0          "   lr    r    r 0          "   q    q 	   q 0          "   p    p 	    q 0          "$   m         ?   n          "   	            Hm 0          "   j    k    k           "   J    pj    j 0          "   J    j    0j 0          "   J    i    i 0          "   J    8i    `i 0          "   J    h    h 0          "   J    hh    h 0          "   J     h    (h 0          "   J    g    g 0          "   J    0g    Xg 0          "   J    f    f 0          "   J    `f    f 0          "   J    e     f 0          "   J    e    e 0          "   a            `e 8          "   d            e 8          "   a            d 8          "   ,d            Hd 0          "   c             d 8          "   b            c P          "   Xc            xc            "   b            0c (          "   b            c (          "   b            b            "   a     b 
   Pb            "   da            a            "   a            (a 8          "   @            ` P          "   _    _    `            "   ^    _    0_            "   ]     ^    P^            "    \    @\    \            "                    \            "   O            `[            "   Z             [            "   Z            Z            "   `Z            hZ 8          "   H6            Y            "                   Y            "   H6            `Y            "   H6            0Y            "   J    LX    xX 0          "   W             X            "   J    hW    W 0          "   0W            8W 0          "   H6            V            "   V            0V            "   U            U            "   |U            U            "                   `U            "   T            8U X          "   T            T X          "                   pT            "   J    PS    xS 0          "   J    R    R 0          "   O            pR            "   H6            @R            "   H6            R            "   H6            Q            "   H6            Q            "                   pQ            "   O            Q            "   J    P    P 0          "   J    lO    O 0          "   O            (O            "   N            N 8          "	   M            N (          "   TM            pM P          "   pJ            (M (          "   pJ            M (          "   L            L p          "   K            L           "   ,K            `K           "   J    J    J 0          "   pJ            xJ (          "   0J            @J            "   I            I            "   hH             I            "   lF         &   G           "               (F            "	    E            pE            "8   0?    @ f   A          "J   7    ,:    `:           "
    7            P7            "   H6            6            "   H6            6            "   H6            6            "   H6            P6            "   T5             6            "   T5            5            "   T5            5            "   T5            5            "   T5            `5            "   4            4 8          "   3         
   4 H          "   |            3            "   <3            `3            "   2            3            "   2         
   2 (          "   t.            1 (          "   t.            1 (          "   -            p1 (          "   .            @1            "   -            1 (          "   0            0 h          "   /            h0           "   /            0           "   H+            / 0          "   0/            @/            "   *            .            "   t.            . (          "   t.            . (          "   -            H. (          "   .            .            "   -            - (          "   -            - p          "   ,            ,           "   ,            (,           "   H+            X+ 0          "   *            +            "   *            *            "   4*            @* 0          "   `)            )            "   |'            (            "   (            (            "   (            0(            "   |'            '            "
   &            &            "   %            %            "   %    ,%    X% H          "   x$    $    $ `          "
   #    p#    #           "   !    !     "           "   $!            @! @          "                  (          "   `                       "
   @         @          "   ,    \     0          "   d         0          "             @          "                (          "               0            "   D            p            "                           "   0            X            "   L                        "	   <                        "                            "   |                        "   \            p            "   x         
    0         "   ,            8            "                            "                           "   <            H           "   |                        "                           "   |                        "   `
            0 H          "                0          "                8          "   @            ` P          "                            "               
            "   D            
            "               h
            "               0
            "   P                        "   P                        "                           "   D            P            "                           "                           "   P            X            "   
            
            "   `
            p
 H          "   ,
            8
 (          "   	            	 0          "   	            	 0          "   |            h	 (          "   |             	 (          "                (          "   |             (          "   |            H            "   |                        "   |                        "   |                        "   |                        "                   `            "                           "   h            p (          "   x                        "	                `          "   ,            @ (          "                (          "                                             Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                         ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    L\    
   p  
 
                                                                                                                                                   d`            0            	 
 Ч
                            
          
             	             @   
                        	 p
 H
                            
         
 h
 
                     	            @   p
                        h
                	   0
         *            @   H
                      * л
 (
                            
                     @   
                `       h
 
                            xQ 
 
                             
 
                            4 
 
                 
             H#            @   h
                        
 h
                            
                    
         *            @   
                        PG 
 
                            H
         P,            @   ط
             
 
 
 
 
  
 
 
 
  
                                                 D            @    
                        
                   x
                    W (
  
                 @             @   8
             N            @   
                         @   H
                (       : P
 
                             H
 Ȭ
                             S 
 
                 @            @   
             
 
                            G Ы
 X
                 P9            @   
             
 @
 
                     
  
 
                                Q  
 
                            
                    
         p
            @   `
             
 
 
  
 
 `
 
                                     %            @   p
                        
         @     (       @   8
                        D  
 
                             = 
 8
                            8' 
 `
                 xQ             @   
                         @   x
             
 
                            
         @6            @   Ш
                       
         
 @
 ȵ
                               PG 
 h
                           (
                   
                    
                    3 к
 ذ
                 
 x
  
 
 `
                             P
 x
 
                        (       B (
 P
                            P9 
 x
                  4            @   0
             N            @   @
             8
 (
 
                                
            P       
 (
                 h
  
 
                               
         
 ȵ
                            ` 
 
                 `            @   
                        
                    + `
 
                 ?            @   
             
 
                 6            @   8
             
             @   
             !             @   
             
 
 ȵ
                                 Y H
 
                             x
 0
                           ? 
 X
                 P
 
 @
 
                                    
         p            @    
             
 
 ȵ
                     P            @   
             `         P      P   
             
 
                  
 
  
 
 `
                                        T 
 
                 8'             @   
                         
 
                 X
 p
                  
 ȵ
                           0+ 
 H
                           
                    
         +            @   `
                       J H
 ȶ
                            
                    0
                    0 
  
                 
 ȵ
                             @   
             -            @   
              =            @   
                        
         :             @   @
                        % p
 
                  C            @   
                       N 
 h
                 =            @   P
                        X
         h
 
                 ȵ
              
 
 @
 
                         J            @   H
                        
 (
 H
                            
         
 
                    (       ( p
 
                            P 
 ȹ
                            x
                    h
                    P
                     @   
             X
  
 
 `
                         Ȳ
 
                             
                    
                   
                    0
          
 
                 0             @   (
                        h 
 @
                             @    
             h
 x
  
  
 
 `
 
                                                x
                    
                     @   
             
 
 
                     H
                       + `
 X
                 
 h
                           
         h
 
                 0            @   (
             0
  
 
 `
                         D            @   
                P      N 
 @
                            H p
 h
                            
                    @
                
   P
                    
 P
 ؽ
                              @   
                         
 (
                 p
 
 
                                (
         P
 X
  
 
 `
 
                                  W            @   (
                       
         #               @   
                       0
         	 	           @   (
             x
  
 
                      	           @   
                         $ 
 
                 (
                        N @
 
                  S             @   
                P      + `
 8
                            
         (            @   
                        P
         )             @   0
             `             @   
                        < X
 
                 
 H
 
                                
         X
            @   
             -            @   0
             %            @   
             
 
 ȵ
                     H
 
                            0 
 
                            
          
 ȵ
                 7             @   p
                        4 
 
                 `             @   
                         @   
             
 
                            
         `=            @   
                        
         
 x
 8
 (
 
 
 h
                                               D 
 
                 H
 
                 0
  
 
 @
 
 X
 (
                                                
         
             
 
 
  
                         p*            @   X
              
  
 
                                L @
 
                 @
 
 ȵ
                     h            @   
                        ` p
 H
                             
 p
                 
                        @   
              
 
                  
 
                 0>            @   
                        
                     U 
 @
                 0            @   
                        
                    
                    P, ط
 
                           
                    (
                     @   p
                        
         `            @   p
             #            @   
                        @ 
 
                 G             @   
                        `
         
 
                            p
 `
 (
                 G            @   Ы
              
 
                            
                    
                    @3 
 
                 >           @   
                         W (
 
                 H            @   p
                        0> 
 `
                 Q            @    
                        P( 
 
                 
 @
 
                                 
 
                 *            @   л
             ?            @   
             
 P
 
 (
 
 h
 X
                                     x
  
 
                                V 
 
                 
 
 
 
                                    (
                     
                    - 0
 P
                 
 
                 
 
 
 
 
 
 (
                                     
 @
 ȵ
                     
                (       % 
  
                 @.            @   x
             
 
 
  
                                   P9 
 x
                 
 
  
 
 `
                                        @
                    
                    
         
 ȵ
                            F 
 0
                            
 X
                 PS            @   
             W            @    
             H
 
 ȵ
                     0            @   (
              
 
                 PG            @   
                        ( 
 X
                 P(            @   
             @
 
                           ` p
 
                 
                       
                    D 
 
                            @
             (       @   H
             F            @   
             P
 
 (
 
                                    pA 
 
                 >            @   `
             
                        
                     h
 @
                            W  
 h
                            
                     
 
                            > 
 
                 
 h
 
                                 @   Ю
                        1 H
 @
                 8=            @   
                         @   
             p1            @   
             hV            @   
                        0; (
 
                            x# `
 0
                            H
         J            @   
                        
                    . P
 
                 H            @   
                        V p
  
                 4            @   
                        D 8
 P
                            0
                    X
                     @   
                        
 
 
                              
 
                            ' 
  
                             C 
 H
                           `
         
 
                            
         D            @   8
             @
 
                            
                    
 (
 
                 
                       p
                   h
         
 
 ȵ
                                ȭ
         0F            @   h
                       8
                   PS 
 
                    P      * 
 
                            > `
 @
                            H
                    h
                    ` 
 
                            0+ 
 
                 (
 
                 .            @   P
                        8
         p
 
                             
                     
 p
                 (
 0
 
 
                                    Q 
 
                 N             @   
                       3 к
 
                            ? 
 8
                             @   
                        4 0
 
                 W            @   
             p            @   
                       ' 
  
                            
         `'            @   p
                         P p
 h
                 @
 
                 L            @   @
             `         @      P   
                        * 
 
                 3            @   
                        
                    
                    0 
 x
                 `J           @   
             B            @   (
                       0 
 
                 
            @   (
                          @   H
                       
                     @   
                        8A 
 
                            G 
 
                 
 
                 F            @   @
             
 (
 0
 
 
 
 
                                                 @   8
              U            @   
                        
         V            @   
                       1 H
 
                             @    
                        
                    
                    p  
 
                            
         `J            @   
             
 
                 h
             
  
 
  
 
 `
 
                                                 h
 X
                 
                       % p
 
                 @K             @   
                         
 
                 
 (
 
 
                                    * H
 0
                 0$            @   
                       
         
            @   (
             h
 
 
                                `  X
 
                    P       W (
 
                 
 
                            T 
 H
                 
             `
 
                            N 
 
                 X
    (       @   
             (
 h
 
 
                         ȱ
 X
 p
                     
                        W 
 @
                            @   
             
  
 
                                0
          
 
                 '            @   
              
 
                            ? 
  
                 
             #             @   
                        h (
 
                            x
                   
                     
                   @
                    
                     @   8
                        `= 
 H
                            H
         1            @   H
                        p
                     Ю
 
                            
                   p
         /            @   
                        
                     # 
 `
                            p 
 
                  ?            @   (
             
 
                 @
 ȵ
                              
 
                 
 
 
 
  
 
 
 
  
                                                        x
         (            @   p
                        X
                    X
 
 
                 
 ȵ
                         @
 
 
 
 
  
 
 
 
  
                                                 0+            @   
                        ? 
 
                 x
  
  
 
 `
                             ?             @   
                        J H
  
                            
                    
                    - 
 x
                            
         `             @   X
             #             @   
                         @   h
                         4 0
 0
                 
  
 
                     
 
 (
 
 
 
                                            
                    
                    % 
 
                 (
 
                            0
                    ؿ
                    @
                   W 
 h
                  $            @   
             
             
                         8
 
                 2            @   
             
 
 
                                
         @            @   8
                         
 
                          	 (
 
                            : P
 
                  Y            @   H
                        0
                    @ 8
 @
                  
 p
 
                     0            @   
                        и
                      @   
                        
                     @   
             
 
 (
 P
 
 
                                 8A            @   
                          
 
                            
         @
 
                            
                     @   
             `
 h
  
 
 `
                             Q            @   
             8
 
 x
  
 
 `
 
                                                > 
 
                 
                         @   h
             
 0
  
 
 `
 
                                           
                     
 p
                            = P
 
                 
 
                    (        h
 
                            ' X
  
                 
 
 
                     
  
 
                     0            @   (
              
 
                 <               P   
                        PS 
 
                    P       4 0
 
                            B (
  
                 8
 
 ȵ
                                
                      
 
                 <             @   X
             4            @   
             
 x
                  S     (       @   
                        
                   
         h             @   (
             
                        P
         
 
 p
 
 
 
 0
                                     0            @   
             ,            @   
                        = 
 H
                              
 p
                 >           @   
             T             @   
                         @   
                        
         '            @   X
                         @   
                        / 
 x
                            @. x
 
                 
             
                        
                    
                    
         
 
                            
            P      3 к
 `
                           
         
 H
                            0
         
  
 
                     
 
                            J 
 
                            H
         V            @   p
                        
         
 `
 h
  
 
 `
 
                                     X
 
                 
 (
 
                     >            @   
                    
    
                    
         0            @   (
             :            @   P
                         @   
             x
 8
 (
 
                         X
             
 P
 
 @
 
 0
 ȼ
                                      #            @   
                        
            (       * 
 
                                @   
                        0
         0;             @   (
             
            @   P
              
 
                 <            @   
                       
 
                 >            @   
                        3 
 
                 
             
 (
 P
 
                         ?           @   
             ?           @   
             x#             @   `
                        
            P      0 
 
                            H
                    
                    
         
             h
 
 
                     
 
                 #            @   
                        hV 
 
                            
                    
                    
         =            @   
             3            @   к
                P      B (
 `
                              H
 
                           
                    N 
 
                            د
                     p
 
                            (
          P             @   p
                         8
 p
                            X
         T            @   
             p
                        2 
 
                              @    
                        X
                    , 
 P
                            
         
 p
 
 
 
                                        
                    `' p
 
                            p1 
  
                 
 
                 X
 
 x
                                ( p
 `
                 @3            @   
             
 
 
                                
                    H 
 
                 x
 
                 0            @   (
             pA            @   
              
 
 
 
  
                                        
         0
 
 
                 GCTL   `  .text$di    `   5 .text$mn    `K     .text$mn$00 K   .text$x    .text$yd      
  .idata$5        .00cfg      .CRT$XCA        .CRT$XCL       .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ        .CRT$XPA         .CRT$XPZ        .CRT$XTA        .CRT$XTZ       .rdata  
 (   .rdata$T    Ч
 X  .rdata$r    
 t  .rdata$zzzdbg   P    .rtc$IAA    X    .rtc$IZZ    `    .rtc$TAA    h    .rtc$TZZ    p pi .xdata  l   .xdata$x    p|    .edata  L}    .idata$2    (~    .idata$3    @~ 
  .idata$4    ؈ F&  .idata$6      Y  .data   	 P  .data$r PZ )  .bss      Ho  .pdata     <   .gfids$y         .tls        .tls$       .tls$ZZZ          _RDATA   0 `   .rsrc$01    `0    .rsrc$02                                         20
 
4 
2p B   R0
 b  ^ 8
     p  * d 4 p$D 
 r   K               Q         2P1	 T 4  p`  $D 
    K     K             &     
        2  	p`0P$D 
    L     L L    $L 0L    <L    HL    TL    `L P                    z                  [!     !     !     h#     #  
 
4 
Rp d	 4 Rp 4 R
p`P^ 
 pL     |L    L    L    L    L    X    X         %  7%      \%     t%     %     %     %     %     %     %     &     &   d T 4 2 T 4 2`% %t !d T 4 
	^ p
 L  '  $(      {(  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 Rp^ H
 L     L     X X     `.  .      .     .     .      /     /   4 Rp^  
     /   0$D 
 J    M     0  0      0   0$D Е
 J       1  1      1   0$D 
 J       2  2      2   0$D 
 J       p3  3      3   0$D X
 J       `4  4      4   d T 4 p^ 0
 M     P8  8      8  8      9   d T 4 p^ 
 @M     `9  9      9  9      -:   d T 4 p^ 
     p:  :      :  :      =;   d T 4 p^ 
     ;  ;      ;  ;      M<   4 p^ 
 pM     <  <      <   4 p^ h
     0=  f=      =   d	 T R( (d $T  4 
p^ @
 M     @  @      $ 	0 0  $D 
 r  M     M B  :C      zC     C  m md
 h4 
rp 4
 rp^ 
 M     M    M    M    N     PF  F      F     
G     G     +G     aG  ! t K  K  p !   K  K  p  h r0^ ȓ
  N L  
M      M      
4	 
2pC    * *x h r0 Rp`P0 t d
 4	 R^ 
 0N  U  wU      U   h d 4
 rp^ x
 @N     U  :V      eV   h d 4
 rp^ P
 PN     V  V      W   t d
 4	 R^ (
     X  gX      X   h d 4 rp^  
     X  Y      BY   h d 4 rp^ ؒ
     Y  'Z      RZ   t d
 4	 R^ 
     [  [      \   h d 4
 rp^ 
     0\  \      \   h d 4
 rp^ `
     \  []      ]   d
 4	 Rp^ 8
 0^  ^      ^   4 
p	`P^ 
 `N p_  _      =`  * 0 p`0P  $D 
 r  pN     N N    N p`  `      `     a     a     + / $D 
 b  N     N     b  b      b     =c  . d1 40 . p  $D 
 b  @c  c      c     c  . 0 p`
0  $D p
 r       d  bd      d     >e   h b  +
 +h &4 
p`P^ H
 N N    O    O     h  i      i     i     ij     rj   t 4 P' 't# #d" 4!  P  ^  
 0O <O    HO     k  )l      l     m     n     n    p  !  
T 4 n  o  P ! d o  jo  \ !   o  jo  \ !   n  o  P !     T  4 n  o  P " "h 	p`0P^ 
     pp  p      6q     Eq     q     q  ' 't #d 4  P  ^ А
 `O     s  Ys      t   p! 4 `u  u  ` ! d u  u  h !   u  u  h !   `u  u  `  d
 4	 Rp^ 
 v  w      Jw   4	 
Rp^ 
 pO     w  x      x   4 Rp^ X
 O     x  Ay      Ry  *
 *x &h "42 , 
p`P  ^ 0
 O     O    O    O    O    O           O         py  y      y     z     z     A{     {     |     H}     T}     `}     j}      u}  6
 6x h d 4 rp( d 4
 p$D 
 J   O O     ~  ~        *     ـ   d 4 2p 0$D 
 J                   d T 4
 rp^ 
 P             N  8	 'x8 #h9 4v t P  $D 
 r   P     ,P    8P    DP    PP    \P    hP    tP    P                          P     ^     Ȇ          (                    F     w               a     u             6	 %x8 !h9 t p0P  $D h
 r  P     P     P    P    P    P    P    P     @                   a          ڋ                                                    :   4 Rp`P^ @
 P P    Q    Q    (Q Ў  	      '     7     S     g       $
 $T 4 R
	p`^ 
 @Q LQ    \Q    hQ    xQ    Q                   7     S     o       0
 !4 
p`P$D 
 j   Q     Q Q    Q                ۑ           m      x                    &     2     =  X     f  R
 R T
 4	 2p`$
 $T 4
 R
	p`^ Ȏ
 Q     Q     Q З        #     q     ͘   4 p`P!    R  X !     R  X ;
 -t7 )d6 %44 . 
P  $D 
 b   R R    :R    LR ZR    fR         0          H     c               4     C       
     &  ! t p    p !   t p    p 
 d T
 4 2p$ 	 0  $D x
               S    )S    )S    5S                	   J    R 8   p         )  R     R    R    R    S    
 
2P^ x
 "  $D P
               S    S    S    T                	   J x   PS 8         7      =  PS     ]S    rS    S    S    
 
2P^ P
 , h	 	 0  $D (
               T    T    T    T               p 	   J x   T 8               `          T     T    2T    FT    T    
 
2P^ (
 
 h 4 R
p`P
 
4 
2p R! t d 4	 `     !" "T
       !        !     T
      !         !     t  d  4	 `      RP!  t 4	    g   !# #d
  g     !   g     !     d
 g     !    g     !       t  4	    g   ! t   <  p ! d <  o  4 !   <  o  4 !   t   <  p !   t  d   <  p 
 
B0P  ! t
 d	    j   !9 9  t
  d	    j   !     t
  d	    j   ! 4	      !  t 	d
  4	      $ 	 0  $D  
            T    T        U    U    U    U    U    V        	       	   F H   T H             o                &  T     T    BU    VU    fU    pU    U 	    BP0  ^  
 :
 ,t9 (d8 $47 0 
P  $D ؍
 r   V     ,V    <V    LV    \V    lV    |V    V    V    V 	   V    V    V    V 
   V         P             Ӹ                     B     u          ι  	   ޹  
     	        Ļ               	     S  
   a     z  
                    	   "     h     r   	  d* T) 4( & p  ^ 
 V   Ǿ      J  $ $d0  T/ 4. * p  ^ 
  W W    W     п        g          Y       - " p`0  $D `
   <W     0W            eW    qW    }W    W    W            Y    $Y    0Y             " 	    S    W X             &      @     \      d                         <     e          a                     W    W 	   W    >X 
   OX    X    X     bP0  ^ `
 , # p`0$D 8
   @Y            iY    uY    Y    Y    Y    Y    Y         	   ([ 	   4[ 	   @[             # 	    S    Y X                        8     m                                             |           Y 	   Y 
   Z 	   NZ    _Z 	   Z    Z 	    bP0  ^ 8
 "  $D 
               [               $ 	       P[ H             P[     ][    [    [    
 
RP^ 
   $D 
 {              \               @% 	    p    \ 8                  \     
\    8\    G\    
 
2P^ 
 *
 * x h 
4 
p( d
 4 rp$D 
 2   \        S        7	 &dv "4u p pP  $D 
 r  \     \ \ \ \ \    ] ]  ] ,] 	   8] 
   D]    P]               U      l     z               )     :                        1         M     ^  w  	     
        ?     P     ]  
   q  	      4
 p^ p
 `]       E      [   Bp0  !  

 T p    ' ! d	   S  ' !     S  ' !   p    '  4 
	p`^ H
 p]     |]     ]                       |   d 4 p6 (t3 $d2  40 , P  $D  
 R  ] ]    ] p          J                  4
 p^ 
               
 
4 
 p  ! d 0    ) !   0    ) ) t 4
 	P$D Ћ
 J   ] ] ] ]  ^ ^ ^                   r                          -         7     E  & &4/ * p`P  ^ 
 0^     p  l      s   d
 T 4 rp+
 +h &4 
p`P^ 
 @^ L^    X^     P             +            ! !d
 4 R
p^ X
 p^     |^       d           -      5   4 
r	p`^ 0
 ^     ^ P                T 4 p` 4 p`P! h     + !       + !      + !       + & &d "4  	pP  ^ 
 ^ ^    ^    ^                                & &d "4  	pP  ^ 
              
                       4 
p`P!    *  , !     *  ,  t d 4 P
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T     $- !       $- &	 &d "4  	pP  ^ 
 ^     ^                           4 
Rp^ 
  _                d 4
 
Rp^ h
 _ @           4 
Rp^ @
        &      =   4 
Rp^ 
  _     `           4 
Rp^ 
               " "h 	p`0P^ ȉ
        U                y    }  	p`P0^ 
 0_     <_                  4 
r	p`^ x
       G    H  t d 4 %
 %h t d 4 P"	 "d 4  pP  ^ P
 P_ \_    h_    t_      %	     	    	    |
    
    
 "	 "d 4  pP  ^ (
 
 
             9    J    U  d 4 pP' 'h
 #T# 4"  	p`  ^  
 _ ` 5     P  4 
Rp^ ؈
     p        d 4
 
Rp^ 
        \  4 
Rp^ 
     p        4 
Rp^ `
           
  4 
Rp^ 8
     0 V     j    )	 
	p`P0  $D 
 b   _     _    _    _    _    _    _    _    _    ` 	   ` 
   '`               c    v             	    
       %    B    ]    f     o  
R0^ 
 @`     L`           B   4
 
Rp^ 
 ``     l`    |`    `     P  n                       # 4
 p$D 
 J   . .     . 6 (4   
p`P  $D p
    `     `    `    `         / /     z0    H2    U2    3    3    )3     3    3     = ,4C 8 
p`P  $D H
   `     `     a    a     a    ,a    8a    Da         04 4     4    5     @6    w6    6    6    6    57    ]7    7    7    k;     4	 
Rp^  
 Pa     ; ;     !<  4	 
Rp^ 
     0< p<     <  4	 
Rp^ І
     <  =     A=  4	 
Rp^ 
     = =     >  4	 
Rp^ 
      ? `?     ?  R0^ X
 X A A     A  4 Rp^ 0
     A 2B     MB  R0^ 
 pB B     B  4 Rp^ 
     B C     -C  
R0^ 
 `a     la    |a    a    a    a    a    a    a    a @D qD     D    D    D    D    D    D    D    E    E 	   E =
 +h# &dQ "4P H 
p  $D 
 #  b     b           (b    4b    @b    Lb    Xb    db    pb 	   |b 
   b    b    b 
   b    b    b    b    b    b    b     c    c    c    $c    0c    <c    Hc    Tc    `c    lc    xc    c    c !   c "   c #   c    c    c &   c '   c (   c    c    d    d ,    d -   ,d .   8d    Dd    Pd    \d 2   hd 3   td 4   d    d    d 7   d 8   d 9   d    d    d <   d =   d >   d    e    e A   e B   (e C   4e    @e    Le    Xe        H   e    G   I      @: 	    S    de H               0E E     E    E    E    F    QF    \F    F    F    )G    G    HH    H    I    NI 	   I 
   I    I 
   I 	   I    I    GJ    J    K 
   9K    pK    K    K    K    K 
   K    L    L    N    7N    lN    {N    N    N    N    N    O    O    P    'Q    \Q    kQ    Q    Q    Q    Q    R    R    S    T    GT    RT    xT    T    T    T    U     WU    U !   V "   DV #   SV $   yV #   V "   V !   V    W %   W    X &   *Y '   eY (   xY )   Y (   Y '   Y &   Y    LZ *   Z    Z +   ?[    \ ,   \ -   ] .   !] /   G] .   p] -   ~] ,   ]    ] 0   ]    6^ 1   ^    _ 2   _ 3   _ 4   	` 5   /` 4   X` 3   f` 2   t`    ` 6   a    ua 7   a 8   a 9   a :    b 9   Ib 8   Wb 7   eb    b ;   c    zc <   c =   c >   c ?   #d >   .d =   <d <   Jd    d @   d    e A   e B   e C   f D   .f C   9f B   Gf A   Uf    f E   f    Bh F   oh    h G   h    Bi     Mi de     qe H   ~e I   
 
RP^ 
 9 'h( R 
p`0  $D h
 s  e e    e    e    e    e    e    e     f    f                  f    f    f    f    f    f    f    f                  g    g    g    g    g    g    g    g    g                   h !   h    h    h    h %   h &   h '   h               *   zi +   i    i    i    i /   i 0   i 1   i    i 3       3       5   {j 6   j 
   
   
      TA             hA       "      |A )   )   ,      A 4   4   7      A 	    S 8  f H   	    S 0  g H   	    S   g H   	    S (  h H   	    S    i H           k l     :l    Jl    [l    l    l    m    0n    n     o    7o    Eo 	   ko    o    o    o    o 
   o    p    0p    p    <q    q    q    q    q    "r    Wr    er    sr    r    r    r    r    s    s    Ut    t    t    t    t    0u    >u    Lu    u    u    u    v #   0v    v $   <w    w %   w &    x '   x (   4x '   ix &   wx %   x    x )   x    x -   y    y .   z    }z /   z 0   z 1   	{ 2   /{ 1   d{ 0   r{ /   {    { 3   { 4   | 3   0|    M|    j|    |    | f     %f    \f    f 
   g     g    Gg    kg    g     h     >h !   bh "   h     h *   3i +   Wi ,   i     i 5   4j 6   Xj 7   
 
RP^ h
 .  t d 4 	P$D @
 J   j j j j j j j j  k         | B}     } l~     G    T                ;    H x          $
 $t d 4
 
rP^ 
  1     0 ?
 .tC *dB &4@ : 
P  $D 
   k     k     (k     4k     @k     Lk     Xk     dk     pk     |k     k     k     k     k     k     k     k     k     k             p ȇ    ه              `    n                       G    S         ǉ                	   .     l 
   x                       0 
   >     |                           0    >     |          < +tC 'dB #4@ < P  $D Ȅ
    l     l     l     $l     0l     <l     Hl     Tl     `l     ll     xl                                                                  -    >     ^    j     ō    Ӎ              p    ~              %    3     S    _      	        ܏ 
           4	 
Rp^ 
 l     l    l    l      	         !    -      d 4
 
Rp^ x
 l     l           \  
R0^ P
 l Ж        ^ (
                       J 	    S 8    m H           m     -m    
 
RP^ (
 3	 < 	p`0P  $D  
   m     m    m    m    m    m           И    ޘ         [                F    b     9 (h $4D < 
p`P  $D ؃
   m     m    n    n     n    ,n           (        ڛ        0    Z    o            ۜ      & 6 p`0  $D 
   @n     fn    rn     ~n     P          /                   
R0^ 
         
R0^ `
 P f        d 4  p  ^ 8
 n     n    n      ɟ     ߟ            3     * *d %T  4
 R
p^ 
 n     n    n    o    "o    5o    Ho    [o    no     `                   ١                5     0
 "d 4 	pP$D 
 j   o     o    o               9        ;     d # #h 4 Rp 
4 
pC `    4
 Rp^ 
 o o 0       ̰    ڰ # #t
 d 4 r^ 
               O @            p X       0      ȳ  p     p     bP0  ^ 
  4 2! d t `  O !   t `  O !   `  O  d 4 2! t  N P !    N P ! d   8  !     8   d 4 
rp^ p
               P @           pp X        ]     p pp     ~p     bP0  ^ p
  4
 Rp^ H
 @             2p! 4  I 0Q !    I 0Q  R0^  
       4 Rp^ 
             4	 Rp^ Ё
     P o       d T 4 2p d
 4	 Rp 4 Rp^ 
   ?     h  4	 Rp^ 
             4
 Rp^ X
      6     k       d 4 
rp^ 0
               R @           p X          p     p     bP0  ^ 0
 ! d    !       d 4 
rp^ 
               dS @           @q X   `       @q     Nq     bP0  ^ 
 ! d    !      ! d t  q O !   t  q O !    q O ! t 0  P !   0  P ! d     !        4 Rp^ 
   t	 d 4 2 d	 T 4 2p0	 "d 4  pP  $D 
    q            ! t  > p !   t  > p 0	 "d 4  pP  $D 
        ` r       R0^ h
 P  R
p`0^ @
 q     q    q                   Q  4	 Rp^ 
  r     .r     `            4	 Rp^ 
 @r     nr                P  0  ! t `  PV !   `  PV + +d 4 p   BP0  ! t	  V V !  

 d  t	  V V !   
  t	  V V 
 b  ^ 
            #	 p
`P0  ^ 
 r       ,  d 4 
rp^ x
               |W @           r X           r     r     bP0  ^ x
 " "d
 T 4 
rp^ P
  s     s    s p          /    <     ! !d 4
 r
p^ (
               `X @           0s X              0s     >s     bP0  ^ (
  T 4
 2
`! 	 t  T X !    T X ! 	 t p 4 X !   p 4 X  4	 Rp^  
             4	 Rp^ ~
            
 b  ^ ~
   R0^ ~
  	 '	     f	 >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pP$D `~
 b   s  2       2p`0 4
 rp^ 8~
 s X P            
4 
pC H    4	 Rp^ ~
 s @ `      
 t d
 T	 4 R
 	 T d 4
 Rp 4
 Rp^ }
     ( X)     c) )    )  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b  ^ }
     : ! bp`0  ^ }
                                     h\             |\ @           s 8   @           s H    ; ;     ; s     s    s    s     
t    
 
2P^ }
  BP0  ^ }
 
  ` St
 6 
B`P0   T 4 2`! t @ @ ] !   @ @ ]  4  d T 2p! 4 E 2E P] !   E 2E P] !   4 E 2E P] ! 4 @G bG P] !   @G bG P] !   4 @G bG P] $
 $d  4 r
p^ p}
 t t               X    X             4^ @           t 8           I RJ     J    J    4K    aK    uK    K t     t    t     
 
2P^ p}
 $
 $d  4 r
p^ H}
 t t               X    X             _ @           u 8   K FL     |L    L    3M    sM    M    M u     u    2u     
 
2P^ H}
 $
 $d  4 r
p^  }
 @u Lu               X    X             _ @           Xu 8   M mN     N    N    bO    O    O    O Xu     eu    u     
 
2P^  }
  T	 4 2! t d P P x` !   P P x` / 1 	p`0P$D |
 r  Q Q     R    JR    R    ' - p`P0$D |
 R  u     u     S `S     S    S  4 R
p`P^ |
 u u    u    u    u    u             pT T     T    U    /U    SU    oU    U  d
 4 
rp^ |
  v v               X             4b @           v 8           pV V     V    V    W    1W    lW v     %v    Bv     
 
2P^ |
 
   ^ X|
 Pv W W     W " "d T
 4	 
Rp^ 0|
 `v     W X      4	 
Rp^ |
      Y >Y      4" 	  p  ^ {
 v     v              Z QZ     tZ    ! 	0$D {
 r       Z [     [  	 0  C    $	 $4  
p`P  ^ {
 v      ] f]     ^^   0  ^ h{
 v     v v     ^ ^     ^    _ _    _ & , p`0  $D @{
 R      _ `     u`    ` 6 (d8 $47 0 	pP  $D {
 r  v     w     w .w    :w ` a     a    a    b    b    b ' - p`P0$D z
 R       c Qc     c    c 
   ^ z
               e @           Pw H    g 
g     .g 0g     
 
RP^ z
 
   ^ z
               f @           pw H   @g Mg     ng pg     
 
RP^ z
 
   ^ xz
               tf @           w H   g g     g g     
 
RP^ xz
 
   ^ Pz
               f @           w H   g g     g g     
 
RP^ Pz
 
   ^ (z
               Dg @           w H    h 
h     .h 0h     
 
RP^ (z
 
   ^  z
               g @           w H   @h Mh     nh ph     
 
RP^  z
 
   ^ y
               h @           x H   h h     h h     
 
RP^ y
 
   ^ y
               |h @           0x H   h h     h h     
 
RP^ y
 
   ^ y
               h @           Px H    i 
i     .i 0i     
 
RP^ y
 
   ^ `y
               Li @           px H   @i Mi     ni pi     
 
RP^ `y
 
   ^ 8y
               i @           x H   i i     i i     
 
RP^ 8y
 
   ^ y
               j @           x H   i i     i i     
 
RP^ y
 
   ^ x
               j @           x H    j 
j     .j 0j     
 
RP^ x
 
 
t 4 1	  
p`0  $D x
           x    x     x    y    y     y    ,y    ]y    oy    }y 
   y    y    y 
   y    y    y    y    /z    Az    Oz    [z        z              k 	    S    gz X   k qk     k    k    m    m    n    9n    n    p    'p    wp    p    p     q    -q    Oq 
   q    q    q    (r    Ur    wr    r 	   r 
   %s    Vs    Ft    st     tz    z    
 
rP^ x
  t d
 T	 R! 4 t 1u l !   t 1u l $ $d  T 4 
p^ x
     u v     Gv F 5u 0xv ,hw  
	p`0P$D px
 B  z     z    z    z    z    z    z    z    z     { 	   { 	   ,{    8{    D{ 
   P{    \{    h{    t{    {    {    {    {    {    {    {    {    {    {    {    {    |    |    |    (| !   4| "   @| w x      x    -x    :x    Gx    z    
{    q{ 	   { 
   { 	   |    -|    _| 
   |    } 
   %}    U}    I                                                b                    $            ̏    D    s    Ԑ        O    \    i                 ے     !    "   z #    "    !   	    f     	       ߕ             % %h !t d 4 
	^ Hx
         P|    \|                   q 	    S P   h| H               P                       n h|     u|    
 
RP^ Hx
 % %h !t d 4 
	^  x
         |    |                  q 	    S P   | H                ј         1    F    E      |     |    
 
RP^  x
 ) )h %t !d 4 
	^ w
 |     |                             r     S P   | H                2     ś         R    x |     |    
 
RP^ w
 ) )h %t !d 4 
	^ w
 }     }                             hs     S P   (} H         b                   (}     5}    
 
RP^ w
 B B& =' 8x( 4h) %T p`0  ^ w
 P} \} h}    t}    }    }    }    }           } 	   } 
   }    }    }    }           (~             t 	    S H  } x   P            ¢    7    I                w            G 	    
   ì        j 
   x                  ] 
    	   ǳ             K      
    	       3    P    h }     ~    ~    
 
P^ w
 ' d 4 p$D w
 Z   @~     f~           8         ! 
	p`0P^ Xw
 ~     ~    ~    ~    ~    ~             p                               0    ?    D          d 4
 2
p! T	 p :  w !   p :  w  4 rp`P^ 0w
         ݽ  d
 4 rp^ w
 0   *       
4 
pC @   ! 4    !      !   4    	 	2`0! 
 t	 T P i w !   P i w !   
  t	  T P i w  
R0^ v
 @ p        d 4
 
Rp^ v
   N       d T
 4	 Rp^ v
                 H  4 Rp^ hv
            / !t3 42 0 P  $D @v
 r  @          !    <    i     / !t3 42 0 P  $D v
 r   :     V                
  b  ! t 4 0 H y !   0 H y !   t  4 0 H y  R0^ u
         
 ^ u
 p  D       R0^ u
          R0^ xu
   a     |  R0^ Pu
        # #t
 d 4 r^ (u
                { @            X       0                 bP0  ^ (u
  d 4  p  ^  u
 0     P    } P       0    G    ]    `  4 R
p^ t
          Ѐ     @                4 Rp^ t
       N     i    ^ t
   u      " "d 4	 Rp^ `t
       `             t T
 4	 R`2	  d 4  p  $D 8t
                  ,} @           0 H   P       0     >     BP0  ^ 8t
 f
 fd <t 	 4 2% %4 p`^ t
               } @           p X              p     ~     bP0  ^ t
 ' / p`P0$D s
 b        ^     . 4S N p`P  $D s
 b           ȁ    ԁ  -     \    j        & : : &  x 	h   / 1 	p`0P$D s
 r                J          h 0!  x   ( !      ( !     x   ( . 4S N p`P  $D ps
 b      0              8     * 0 p`0P  $D Hs
 r   	     (    b        ] ] U  
	p`0P! h
 P   !   P      ^  s
   A     $ 	, 0  $D r
 R  P          1 @
 /t[ +dY '4X R 
P  $D r
              .    :    F    w                 P v                 c    u                z 	    &
 &d
 !T 4 R
p^ r
   W      * 0 p`0P  $D r
 r  0              M    , ,4)  
p`P  ^ Xr
      ̂                X    X         &    2 	   R        X     X X                   5                         \    k         	    
   A    X    r                4      
              , ,4)  
p`P  ^ 0r
          ƃ    ҃    ރ    X    X              	   "    O    X     X X                o                )    =    S    p            !    0 	   F 
                       O          
             '    d 4 p^ r
 ` P       
 
r0
 
4
 
rp= ,4= 2 
p`P  $D q
   p     |             ʄ    ք      2                     z	    
          (    D 6 (4   
p`P  $D q
                            
    
     
  
0^ q
 ,        &     :    m     L :c 2d -e (xf $hg  
p`0  $D hq
 #  `     l           x           q    }                 
       Ň    ч 
   ݇                   	       	    S     h                 )    E    x 
                
   "     
       e    ]            l         
            -          ƅ    ޅ    !    2                    8 	   I    b      P0  ^ hq
 A 0x ,h (4<2
p`P  $D @q
 b	           (    4    @    S    _    k    w         
                   ˈ    ׈                                                           "            M         	   ^     
       c 
   }        +     
   "    K#    #    #    #    p$    $    $    $    %    %    &    &    :&    K&    l&    &    &    &    &    &    &    '    0'     Y' A 0x ,h (4@6
p`P  $D q
 	  0     <    H    T    `    s                     
       ǉ    Ӊ    ߉                        '    3    ? ' (     (    (    (    =)    B)    )    )    *    *    * 	   ,    , 
   ,    - 
   -    J.    [.    
/ 
   2    {3    3    3    3    4    4    5    5    5    5    66    G6    j6    {6    6    6    6    6    6    7    -7    F7    `7     7 / /h +/ 't. #d- 4, ( P  ^ p
 P     \    h    t                 7 8     8    8    9    I9    9    9    :    ;    ;    ;    ;     1< "	 "d( T' 4& $ p  ^ p
  `< <     r= "	 "d. T- 4, * p  ^ p
  = =     $? "	 "d( T' 4& $ p  ^ xp
 P? ?     b@ "	 "d. T- 4, * p  ^ Pp
 @ @     B #	 #t3 d2 41 . P  ^ (p
 Њ     ܊         @B +C     nC    C    
D    D    D     E 1
 1x -h )tC %dB !4A > P  ^  p
               $         0E /F     rF    F    bG    xH    H     H "	 "d( T' 4& $ p  ^ o
  I <I     J "	 "d. T- 4, * p  ^ o
 @J |J     K "	 "d( T' 4& $ p  ^ o
 K ,L     M "	 "d. T- 4, * p  ^ `o
 0M lM     N #	 #d4 43 . pP  ^ 8o
 0     <    H    T N O     P    vP    P    YQ    Q     Q 0
 0x ,h (dB $4A < pP  ^ o
 `     l    x             Q R     S    yS    S    U    KU     fU 7
 )h %42 ( 
p`P  $D n
 "                       ̋     U }V     V    V    V    oX    Y    Y    #Z    /Z    kZ     Z 7
 )h %42 ( 
p`P  $D n
 "      Z [     [    [    
\    ]    3^    ^    S_    __    _     _ <
 *hs &d "4  
p  $D n
 #                           (    4    @ 	   L 
   X 
   d 
   p 
   | 
        
        
       Č                          	    S   Ќ x       _ w`     ` `    ` `    xa    c    c    d    e    df    )g 	   g 
   h    h 
   ci    ti 
   Gm 
   m    n 
   En    n    o 
   <o    o    o 
   +p    vp    p 
   }r 	   r    r    s    Qs    s    s    s Ќ     ݌        
 
P^ n
 <
 *hs &d "4  
p  $D pn
 #    (           4           @    L    X    d 	   p 
   | 
    
    
    
        
   č    Ѝ 
   ܍               $               	    S    x               0t t     t 
u    u ;u    u    w    x    y    iz 	   &{ 
   |    -| 
   |    | 
    
   Ѐ    E 
   |    ǁ    < 
   u        5 
   e        % 
   Ʌ 	       3    h        ̆                      
 
P^ pn
 @ .xc *hd &d "4  
p  $D Hn
 #          0    <    H    y                     	                
   K    ]    k    w            Ə    ԏ                          t 	    S     X                 D            ?                    E 
   g        ׍        @    m     	   ߎ 
       7    h                '    _            <             
 
rP^ Hn
 @ @ ; 6x 2h %> p`0  ^  n
         0    <    H                       	    S    T X                 (    Ӓ    p            $     a    n    
 
rP^  n
  4 2p!
 
d T  Ә  !    Ә  !   d  T  Ә  $ Rp`0^ m
                @            8         #          
 
2P^ m
 $ Rp`0^ m
               x @            8       0      Ú      ͐    
 
2P^ m
  2
p!
 
d 4 К ޚ Ȝ !   К ޚ Ȝ !   d  4 К ޚ Ȝ !
 
d 4   Ȝ !     Ȝ !   d  4   Ȝ !
 
d 4   Ȝ !     Ȝ !   d  4   Ȝ  R
p`0^ m
                           Н @            8        ؝                        
 
2P^ m
 !
 
d T  #  !    #  !   d  T  #  / 1 	p`0P$D m
 r             ڟ    C    ) , p`P0  $D Xm
 R  0     ^ p    |           Q        2	  44 , p`P  $D 0m
 R       Y     x            	 t d T 4    d 4 
p  !
 
 T    !          zx dh &% p`P0!  
 0 Ш ğ !  	 	
 Ш   !   Ш   !   0 Ш ğ  	  0  ^ m
                         ͽ     
R0^ l
         d 4
 
Rp^ l
  ^       
R0^ l
  )     o  
R0^ hl
        / !t3 42 0 P  $D @l
 r   G     c                 =
 ,hP (4  
p`P  $D l
        ȑ    ԑ                        A 	   S    a    m    y 
    
        @      '             f                2                 	    
   -    r         
   W    
 
   s     
                       $ =
 ,hP (4  
p`P  $D k
       p      W         )                ;    b                 	   J 
   ]             
       = 
        
                   8    T 
 
d	 
Rp! 4   P !     P .  t d 4 	P$D k
 J      0      1     ]      < < 7x
 3h /t' +d& '4$  
P  ^ k
 В      `     K , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t  -  !    -   d 4 p^ xk
  @ t      	 	 0      d 4 p h d
 4	 Rp.  t d 4 	P$D Pk
 J                        B         * Z    g      ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P  ^ (k
 0     <    H    T    `    l    x                                               J         	   G                    "    J    i      / / *x &h % 
	p`0P^  k
             :     ?          / / *x &h % 
	p`0P^ j
                  w      ( (d $T  4 
p^ j
 Г            0^ j
 	 	     h
  R0^ `j
 
 
     
  R0^ 8j
 
 E     `  0^ j
 p      H  R0^ i
 `        R0^ i
  %
     @
  
 ^ i
 P
 
     
  R0^ pi
 
         R0^ Hi
 @        0C `   ! t   x !     x " "d 4	 Rp^  i
     0 t             ^ h
 P       { j7 b8 Z9 R: J; B< := 2> -x? )h@  
	p`0P$D h
 b                $    0    <    H    T    `    l    x 
    
        
   ͔    ߔ                        )      V     g            H    {            0    P    ]                2 	   ?    Z     
       " 
   E    Q 
   f     
       T    q        "    "    W"    h"    u"    "    
#    #    W#    h#    #    #     # :
 (xT $hU  
p`0  $D h
 3  @         m    y                       Ε 	                
   7    I    W    c                           ǖ    Ӗ    ߖ                      "    .    :    F             Ю                           	      L X   	       o X   	    (   X       `$ @%     R% %    & !&    7&    &    .'    c'    '    D(    (    (    ( 
   (    6)    X)    )    )    *    <* 	   * 
   *    +    O+    +    +    	,    H,    ,    ,    ,    ,    c-    -    -    .    +.    H.    p.    .    .    /    /    /    0    0    0    0    
1     1    N1    k1 L     Y    o     |                  
 
rP^ h
 { j: b; Z< R= J> B? :@ 2A -xB )hC  
	p`0P$D h
   `     l    x                            ̗    ؗ 
    
        
   -    ?    M    Y    e    q    }                 1 &3     73    3    3    4    K4    \4    4     5     6    -6    p6    6    6    7 	   )7    D7    7 
   7    #8 
   I8    U8 
   j8    9 
   :    E:    _:    <    >    >    6?    G?    T?    ?    ?    ?    6@    G@    g@    @     @ :
 (xW $hX  
p`0  $D Xh
 c           ͘    ٘                       . 	   @    N    Z    f 
               Ù                           '    3                  j    v                         ȴ             ܴ              	    H   X   	    P  ϙ X   	    X  ? X               @A B     /B B    B B    C    C    D    CD    D    $E    |E    E    E 
   E    F    5F    F    F    F    G 	   iG 
   G    G    ,H    H    H    H    $I    I    I    I    I    OJ    J    J    J    J    J    XK    L    L    (L    ~L    M    M    (M    yM    M    M    M          ϙ     ܙ         L    \     
 
rP^ Xh
   
p`0  ^ 0h
               $ 	    S 8    H    O  O     VO               
 
RP^ 0h
  0. h 42 . p  $D h
 R         R ?R     tR    R     R = = 8 3x /h +4> 8 p`P  ^ g
      (    4    @    L    X    d             0S V     V    V    zW    X    4X    X    Y    Z    [    [    [    [  p`0^ g
                @           p 8        \ g\     \ p     }    
 
2P^ g
  4
 
Rp^ g
              Л                          ] (]     0]    8]    @]    H]    P]    p]    A^  0+
 +t# 'd" #4!  
P  ^ hg
   0_ r_     <c 4 4 /	 *x
 &h "d 4  pP  ^ @g
 0 c d     d  d 4 p^ g
 @  g _g     h > > 9 4x 0h ,5 (t4 $d3  42 . P  ^ f
 P     \     h @h h     k    ok    Yl     l  4	 Rp^ f
           l m     m    cm  4	 Rp^ f
           m m     m    n " "d 4	 Rp^ xf
       * 0n tn     n    n # #t
 d 4 r^ Pf
               8 @           @ H       n %o     Bo @     M    
 
RP^ Pf
 ' 'x h 	   4 r
p`P!  p .q  !   p .q  ! h q r  !   q r  ( (h $d  T 4 
p^ (f
 `s s     Ju D 2 - (x  $h! D 
p`0  $D  f
   ` l           x            ɝ                     	      ՝ H       u bv     v    /w    \w    }w    w    w    x    ky    
z ՝              
 
RP^  f
 D 2 - (x $h  B 
p`0  $D e
   0 <           H    y                            ؾ 	       H       `z z     {    {    {    {    M|    l|    w}    }    @~               
 
RP^ e
 & 4 p`P$D e
 J       ~ ~     ~          &      3    A 
 t	 d T 4 2
 
4 
2`! t     !          ^ e
        ! t   p !     p ! t  % p !    % p ( (h $d  4 
p^ `e
                	    S 8     X        )     N           C      bP0  ^ `e
 ! t  ȋ p !    ȋ p  4 R
p`P^ 8e
 ` l    x                               ?    X    t             	 	2P0! 
 t	 d Ѝ   !   Ѝ    4	 2`! t p Î ( !   p Î ( / 1 	p`0P$D e
 r             ڏ    A    !  x  d ( !     d ( !     x  d ( )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '       ! h	  v , !    v , !       , 42 	0 p  $D d
 r  0          ޠ    T    = = *  x h   " 1 $D d
 r  0 u         ̣    J    % %4) %  p`P  !& & 
 x h      !        !     
  x  h        ^ d
                0 0h ,4  p
`P^ pd
      ̟    ؟                           6           Ʃ                O    ]                %      <
 *x %h 
p`0  $D Hd
   0     Y    e    q    }            ̠    ڠ               
            
                                  ̣            
        "    .    :                          )    5    A    M #   Y $   e $   q $   }         )    	   	         X             l              	    S     X          X       S    أ X   	    S   F X           P      #    ;    "        Բ        G    e 	                    
   0    N        F    X                        .    @    N    b    m        i    {         Ѹ     !   '    H    e                 "       # #   q $    %     $   a &   s $    '   ƻ $   Ի #           )    E    a            ^ (   p     )   H *   Z )   h        6      
        
        (                                     \    m    ˤ    ܤ    F     T             bP0  ^ Hd
 B 1xS -hT )4  
p`P  $D  d
 "           Ȧ    Ԧ                         	   ( 	   4    e    w 	                              f    -    J            "            q         	   < 
   Y 	   4    K     
               ? 	                     3 3( .x) *h* &d^ "4] V 
p  ^ c
                                   ħ           Ч    ܧ 	    
             
    
   $ 
              
              
              
                         `             D 	    S `  0 x           P     3    E                         	    
   R         
        
   8    I 
   n         
   
 	   B    a          0     =    J    
 
P^ c
 @ @
 ; 6x 2h ## p`0^ c
 p     |                                                    S    Ĩ H                j     y            Y    x        '                 6                 '    3    ?      Ĩ     Ѩ         
 
RP^ c
  d 4
 rp^ c
  `        T 4 	p`^ c
                 ;     I    n              D Dx @h <4> /6 !p`P  ^ Xc
 0     d    v       @ [     v             S    _ $ $h d> 4= 8 p  ^ 0c
                            ߩ                  	      ĩ                       F    W        C        s              
         8 ĩ     
 
P^ 0c
 :
 (x* $h+ X 
p`0  $D c
                               ?    K    W              	      $        `              =            @        m    y                $     
 
P^ c
 $ $h d< 4; 6 p  ^ b
 p     |                                        	                            V    _        -    |    `                       %      
 
P^ b
 :
 (x( $h) T 
p`0  $D b
 {  Ъ     ܪ                              '              	    p          P                          
        :    F     h l    x           
 
P^ b
 : : 5h 142 %( p`P  ^ b
 @ L    X X    d      [         <    U        i <
 * %h 0 
p`0  $D hb
 S             X    d p |                     	    S (  p                 A     ! J         q     a p     ~        ͫ    +    <    I      P0  ^ hb
 . .x )h $t?  d> 4= 8 	  ^ @b
                            ߬                  	      Ĭ              %            E    4                        Ĭ     
 
P^ @b
 :
 (x* $h+ X 
p`0  $D b
                               ?    K    W              	      $        0 |             	    	    	    
        F    R     t x          $     
 
P^ b
 )
 )x $h d> 4= 8 p  ^ a
 p     |                                        	                   
     0    9            F    5                             
 
P^ a
 :
 (x( $h) T 
p`0  $D a
 {  Э     ܭ                              '              	    p          0 |                                 %    1     S W    c           
 
P^ a
 <
 * %h 0 
p`0  $D a
 S             (    4 @ L    X X               @ 	    S (  @                 Q     1 Z    '        q @     N                          P0  ^ a
 <
 *hh &d "4  
p  $D xa
 s  p        |            ů    ׯ             	   . 
   @    N    Z    f                ð    ϰ                  ,        e              	    S    8 H                             p               !    :!    k!    !    !    
"    *"    b"    "    " 	   " 
   2#    R#    # 
   #    #    $    [$    {$    $    $    $    %    8     E    R    
 
RP^ xa
 4 4h! %D p`0  ^ Pa
                                       	    S     X               & H'     a'    '    D(    (    d)    +    ,             ʱ    
 
rP^ Pa
  d 4
 p^ (a
  - -     - :
 (hp $d  4  
p  $D  a
                       9    K    Y    e    q     	       ²    β    ڲ 
           +    7    C    t                    ݳ            	        ?               	    S x    H               . p.     .    N/    
2    /2    |2    2    2    3    23    T3    3    3    3    .4    [4 
   }4    4    4    %5    V5    5    5 	   5 
   6    M6    ~6    6    6    7    =7    u7    7    7    7     "    /    
 
RP^  a
 ! t @8 U8   !   @8 U8   
 d T
 4	 2p!  8 W9  !   8 W9   T r
p! h 
d
 4 `; ~; P !   `; ~; P ! h 
d
 4  < >< P !    < >< P Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P  ^ `
 P     X     > 4@     A    A     C * , p`0  $D `
 [  `                                  S P  l H   C C    C     D l     z     BP0  ^ `
 >
 ,x- (h. ^ 
p	`0  $D `
    ̴    ش                             , 	       
   8 	       
             	    S   D H   D E     cF    pF    2G    BG    H    "H    H    I    I 	   J 
   J    OM 
   kM 	   P    P    P    Q    Q D     Q         
 
RP^ `
 + +h ' #t d 4 P^ ``
       PQ Q     ES    XS     S >
 ,x' (h( R 
p	`0  $D 8`
 k  е ܵ                         $    0    < 	       
   H 	       
             	    S `  T H               T XU     "V    4V    BW    OW    X    "X    X    Y    Y 	   Z 
   Z    ] 
   ] 	   /a    >a    Ma    Ya    ea T     a         
 
RP^ 8`
   ^ `
      a a      R0^ _
 ж a b     b  
R0^ _
   b )c     oc  d 4
 
Rp^ _
 c c     .d  4	 
Rp^ p_
 0     0g g     g  
R0^ H_
  h 9h     h  d 4
 
Rp^  _
 h h     ;i  4 Rp^ ^
     i i     i  4 Rp^ ^
     Pj ~j     j  
 ^ ^
 j k     Sk  R0^ ^
 pk k     k  R0^ X^
 k !l     <l  R0^ 0^
 `l l     l * T 4 p`$D ^
 Z   X @        L                 l 'm     4m    vm    hn    sn     n * T 4 p`$D ]
 Z   n ,o     9o    {o    mp    xp     p # #t d
 4	 R^ ]
     `s s     et &
 &d
 !T 4
 R
p^ ]
 ` t t     / /x +h	 'T #4  
	p`  ^ h]
      v Uw     x &
 &d
 !T 4
 R
p^ @]
  y Oy     = / *x &h % 
	p`0P$D ]
     p{ |     }    T 4
 
R	p`^ \
     @~ i~      d
 T r! x h 
t 4
 P n ( !   P n (    4  p`P  ^ \
       #     	  h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  ^ \
             0                  *    X            -    ߉ 	   g    +    7    B    M    X             Ǐ    T 4
 
R	p`^ x\
     0 Y     #
 #h d T 4 p^ P\
  ̷    ط @ u         ϓ        	 "	 "T 4  	p`  ^ (\
          @ u       
 C    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  ^  \
              g     x                ؚ        +        _ 	               ġ    ϡ    ڡ        !     I  
 ^ [
         3  R0^ [
 0 P q       R0^ [
         R0^ `[
 @ g      J J B
 = 8 3x /h +t- 'd, #4+ $ 
P  ^ 8[
       = " "d 4	 Rp^ [
           @ 	 	B  ! 4   Y 0Q !     Y 0Q " "d 4	 Rp^ Z
 P     z     0 t         Я / /h
 + 't #d 4  P  ^ Z
           @              ²    # S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P  ^ Z
      д ;     P . h 42 . p  $D pZ
 R        7    E      = = 8 3x /h +4> 8 p`P  ^ HZ
 и ܸ                         $      7     T    t            Ծ    z        v    -    8    W    b V H @ 8 3 .x *h &44 * 
p`P  $D  Z
     ~      . h 42 . p  $D Y
 R  `               H = = 8 3x /h +4> 8 p`P  ^ Y
                       X    t        %                     " "d 4	 Rp^ Y
 0     Z @            t d 4 	 4H @ 
p`P  ! G p   !   p   3	 %46 0 p`P  $D Y
 z  p     |                            0                          6 (t/ $d.  4, ( P  $D XY
 :       ̹    ع             ,     Q             h R00	 0 & x 	h   !    D !     D !      D / / & x h 4 p!  p   !   p   !    p   8 8 & x h 4 p"
 "4 
p	`P^ 0Y
                  R R J B
 = 8x 4h 04- !" p`P  ^ Y
          ,    <    L    \    h    t             @                                               8 8( 3) .x* *h+ &d` "4_ X 
p  ^ X
                                                   	   Ⱥ 
   Ժ         
    
    
              
              
              
                         @             ` 	    S `   x               P     <    N            
             	   1 
           d 
   X    i 
        
   	    3
    h
 
   
 	   
    
         B          *    
 
P^ X
 2 2 -x )h %t !d T 4 
	^ X
        0 0x ,h (d $T  4  
p  ^ X
 P     \ 
 !     E    |      3	 !4= 6 	p`  $D hX
   p     |                      h              	    S x    h                                 '    C     H    d     p          :    L    Y      P0  ^ hX
 <
 * %h 0 
p`0  $D @X
 S             h    t                       	    S (       Q     1 Z    '        t          ż    ݼ    ;    L    Y      P0  ^ @X
 <
 * %h 0 
p`0  $D X
 S                       Ⱦ Ⱦ                	    S (               a     A j    7                      
    k    |          P0  ^ X
 <
 * %h 0 
p`0  $D W
 S             ȿ    Կ                       	    S (               q     Q z    G          "          %    =                  P0  ^ W
 <
 * %h 0 
p`0  $D W
 S                       ( (                	    S (              " #     a$ $    W%    %    '          U    m                  P0  ^ W
 " "4
 rp^ W
                @           @ X    ( (     ( @     N     bP0  ^ W
 " "4
 rp^ xW
               T @            X   ( 8)     N)           bP0  ^ xW
 <
 *hv &d "4  
p  $D PW
 S              (    4    e    w             	    
                   7    I    W    c    o                        	        )    5        n              	    S    A H   ) *     8*    f*    +    ".    D.    .    .    .     /    M/    o/    /    /    0    H0    u0    0    0    1    ?1    p1    1 	   1 
   2    /2    g2 
   2    2    2    73    W3    3    3    3    	4    A     N    [    
 
RP^ PW
  0(
 (x #h  	p`P0  ^ (W
                         5 U7    7 68     J8 '
 'h	 #T 4  	p`  ^  W
       9 :    ;    ;    ; <      < ' 'x
 #h  
	p`P0^ V
              P< B>    ? S?     g?  R
p`0^ V
                            @            8       ? ?     ?    ?     ?          
 
2P^ V
  R
p`0^ V
         0                   @           L 8        @ (@     2@    C@     R@ L     Y    
 
2P^ V
 % % !t d 4 
	^ `V
               ( @           p X       @ A     CC iC          RpP0^ `V
  R
p`0^ 8V
                            @            8   C C     C    D          
 
2P^ 8V
 % % !t d 4 
	^ V
               H	 @            X       0D aD     F F          RpP0^ V
    4 Rp`^ U
         0                  	 @           L 8       F G     +G    aG     pG L     Y    
 
2P^ U
  4 Rp^ U
         p                  
 @            8       G G     G    G          
 
2P^ U
  4 Rp^ U
                            @            8       G H     (H    6H          
 
2P^ U
  T 2`! 	 t 4 PH jH p !   PH jH p  d 2p! T 4 I I  !   I I  ! T 4 J J  !   J J  5 5x h   ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P  !  R GS  !   R GS   T 4 p`!   PU U  !   PU U  
 d T 4 p!   X PX  !    X PX   h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
p^ pU
                                    
 	    S      8       ] ]     ]    
^    U^    g^    n_     x_      !    
 
2P^ pU
  4& $ p  ^ HU
 0     <                           \ 	   8
     J 8   _ _     .`    K`    `     ` `     ` J     
 
2P^ HU
  d	 4 Rp R
p`0^  U
         p                   @            8       b 8b     Bb    Sb     ab          
 
2P^  U
 Y Yh  0  ' 'h "d T 4
 
rp^ T
     d f     Bf ' 'h "d T 4
 
rp^ T
     pf g     g #
 #h t
 d 4 r^ T
 h h     i " "d 4	 Rp^ T
 k 4l     Bl    l " "d 4	 Rp^ XT
 l l     m    Pm " - 	p`C @  !C
 Ch 8, &4 T3 42 o o  !   o o  	 d T 4  p  ^ 0T
                s Vs     s    s    *t    t     'u    T
 4 
R	p`^ T
       u  v     Pv    `v )  	p`0PC   !/
 /< &x= h> ~ Ԉ v +w  !   v +w  ! 
  <  x=  h>  ~  Ԉ v +w  3	 %49 0 p`P  $D S
 z  @ ˂         2    N        ̅     4* 	( p  ^ S
    #     g !    D !     D !      D  x h 
- ^ S
          (                ` ;     = Ӎ             3 L      k 
	`P!*
 *2 x3 h4 tj 4s p   !   p    4
 
Rp^ hS
                @           @ 8        ŕ      @     M    
 
2P^ hS
  4
 
Rp^ @S
               h @           p 8         %     N p     }    
 
2P^ @S
   x h   
 x h p`P0$
 $  x h 
 2 2x .h	 *4  p
`P  ^ S
       0          ؝      " "x h 	p`P0! t  / p !    / p $
 $d  4 r
p^ R
                @            X    
          RpP0^ R
 ! t   p !     p $
 $d  4 r
p^ R
               l @             X    ݨ          RpP0^ R
  
p`0  ^ R
         @                   @           d H             A    Z      d     s     2pP0^ R
  `  ! T   T ! t 4  T   T !   t  T  4   T    ! 4  @ T  !   @ T  ! 4   Ѯ  !    Ѯ  !
 
t d   ( PV !     ( PV !
 
t  4 `   !   `   !
 
t d @ h PV !   @ h PV . .4= 4 
p`P  ^ xR
 P      5      UeDx  =h! 6tL /dK (4J cD 
P$D PR
              t ! 4    !      !   4     
R0^ (R
 P        d 4
 
Rp^  R
  .       
R0^ Q
       ?  d 4
 
Rp^ Q
 P        4 Rp^ Q
     `        4 Rp^ `Q
       N     i  d 4
 
Rp^ 8Q
       ' 	 	b   
 ^ Q
       S  R0^ P
 p        R0^ P
  !     <  R0^ P
 `        
 ^ pP
       C  R0^ HP
 `        R0^  P
       ,  R0^ O
 P w      s st 
 ! 4  J  !    J  " "d 4	 Rp^ O
         d     r     " "d 4	 Rp^ O
      :  $     2     Pe?h 841 &c!& p`P$D O
   P      !      ' 'd #T 4  
p  ^ XO
 ` l              h         j } }  x 0! h  m @ !    m @ 3	 %40 ( p`P  $D 0O
 :                 E    T     @ `0P  ! I H tF    !      !   I  H  tF     "p0  !    d T
  & $ !    & $  d 4 p! t d 4    !       4* 	( p  ^ O
  C      = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x P  D !   P  D * * h  !  p Z  !   x Z   !   Z   !   p Z  @
 @ , "   ! x @   !   9  ! h 9    !   9    !    9  !   @   9 9 !x 
 !  h  U d  !  U  t  !      !       !   U  t  !    U d  9 9 &x h 
  !      !      !       !         0  ' / p`P0$D N
 b  
 
     4    t ' 't #d 4 
P^ N
                 
    
     +  d Rp! T	 p  ! ! h 
 4   ! !     ! !   p  ! /
 /t" +d! '4   
P  ^ N
     P      S )
 )h
 $t  d T 4    ^ hN
   E      ! T    !       d
 T	 4 Rp^ @N
        -     I !" "t  d 
T 4   G  !     G  ! t  
d 4    !      !" "t  d 
T 4 `   !   `    Bp
`  !$
 $  
 
T	 4    # !      # ! t  
d 4    !      + - 	p`P0$D N
 R   ! b!     !    !    "    + - 	p`P0$D M
 R  P" "     "    #    V#     2pP!
     
d 4	 # # $ !   # # $   P!   t d 4 p&  '  % !   p&  '  %  
R0^ M
 0( i(     (  d 4
 
Rp^ M
 ( )     k)  4 Rp^ xM
      * .*     I*  @ 
	`P  ! > t? 4F / &0 % !   / &0 %  " P   R0^ PM
     2 2     2  
 ^ (M
 3 D3     3  R0^  M
 3 3     3  R0^ L
  4 a4     |4  R0^ L
 4 4     4 " "d 4	 Rp^ L
  5 D5     R5    5 " "d 4	 Rp^ `L
 5 6     6    `6  4 Rp^ 8L
     6 6     6 " "d 4	 Rp^ L
        7 D7     R7    7 IE;h 7t! 0d  )4 C 
P$D K
      7 ,8     p8    9 W
 Wx 8h  4J B 
p	`P  ! I @: :  ( !   @: :  ( U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4  PE uE  !   PE uE  !  t d G G PV !   G G PV !  t d H I PV !   H I PV  p  ! 4 0L DL t) !' '  d DL aL |) !   DL aL |) !   0L DL t)  . `P  !p ph :* /+ $, t- 44 M M ) !   h  *  +  ,  t-  44 M M )  
R0^ K
      P YP     P  d 4
 
Rp^ K
 P P     [Q  d 4
 
Rp^ pK
       pQ Q     Q    Q  d 4
 
Rp^ HK
 0     <  R PR     fR    tR  
 ^  K
 T U     cU  R0^ J
 U U     U  R0^ J
 U 1V     LV  T 4 `  ! t pV V + !   pV V + " "d 4	 Rp^ J
     W X     "X    pX " "d 4	 Rp^ J
 P     z X X     X    0Y Pe?h 841 &c!& p`P$D XJ
       PY Z     ] 3	 %49 0 p`P  $D 0J
 z                                   ] [^     ^    ^    _    Ma    \a    0
E"h t d 4 C
P  C `   /
 /t" +d! '4   
P  ^ J
 f g     g /
 /t" +d! '4   
P  ^ I
 i Qi     j O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4 t t  !   t t  ! t  d 
T 4 `v v  !   `v v  " "4 
p	`P^ I
 Px x     y Ne=h 6t< /d; (4: c4 
P$D I
         y z     {    ~     ~  	  h d 4  p  ^ hI
            t d 4  t T 4 ! d   / !     / " "d 4	 Rp^ @I
               P 
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h p  0 !   p  0 	 	2p0!  
d	 T   p0 ! 
   |0 !     |0 !     p0 !" "t  d 
T 4 Д   !   Д    T `  !
 
t 4 p  0 !   p  0 ! t З    !   З    9 9 "% p`P0!{ {	 m
 X I =
 1   x h `  T1 !   `  T1 !   	  
      
      x  h `  T1 
 
0!,
 ,  ( t d T  ʫ 1 !    ʫ 1 <5.h *t #d 4 3
P  $D I
 R     4         ) )d: %49 2 	pP  ^ H
        d       d 4
 rp^ H
       .    ? -	%t d
 4 #P  $D H
 B   0     ` ?     P , ,1 pP!I Ih :+ ', #- . 
d/ 40   H3 !     H3 L L 7 " p`P0!| | g C 9 	 x
 h   3 !     3 1
 1h -4# ! p
`P  ^ xH
 @ L    X                z         p
 ph hd+   
p0P  !  t d   PV !     PV !d d	 [
 O B 9
 0 $ x h   4 T1 !     4 T1 !   	  
      
      x  h   4 T1 ! !dK !4J !B pP  ! h  I  ' $5 !   h   ' $5 !    ' $5 '
 'tK 'dJ '4I 'B P  !* * ! x h  0  |5 !   0  |5 !  t d  < PV !    < PV      T 4 
R	p`^ PH
     `        T p  !
 
d 4 ` } 86 !   ` } 86 /
 /t0 +d/ '4. ( 
P  ^ (H
     `      y /
 /t0 +d/ '4. ( 
P  ^  H
   >       9 
0P! 5 6 t7 d8   6 !     6 !   6  t7  d8   6  	  h
 d 4  p  ^ G
            p BE1h *+ #* d) 4( C	& PC      ! t d 4 `  7 !   `  7  d
 T	 4 Rp^             	 "  j    
 ^ d ^  P  
 
4
 
rP t	 d 4 2j     t
 |      d 4 2pj     ,      	 4 rp`j     ;  ;  rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!   K 9 !. . 	 K y ,9 !	 	 y  @9 !   y  @9 !   K y ,9 != =2 *3 4 4=   9 !    K 9  B  ! 4 0  9 ! t  4 0  9 !   0  9  20 R0
 
4 
2p 20 % C    B   B  
 
4 
Rp 20
 t
 d T 4
 r B   B   20! 	 t 
d T & ' : !   & ' :  20
 
4 
2p d 4 2p d 4 2p 4 p R
pP0! d
 * * : !   d
 * * : !   d
 * * : !   d
 * * : 
 
4 
2p! d @- - T; !   @- - T;  20 d	 T 4 2! t 0/ / ; !   0/ / ;  20
 
4 
2p 20z zt u4 
T 
2`
 
4 
2p 4	 2p`P 4  d 4 2p
 
4 
2p 0  ! t 8 8 4< !   8 8 4< !   t 8 8 4< !   t 8 8 4<  B  ! 4 0; ; < ! t  4 0; ; <  B  ! 4 < i< < ! t  4 < i< < !   < i< <  B  ! 4 < I=  = ! t  4 < I=  = !   < I=  =  B  ! 4 = )> D= ! t  4 = )> D= !   = )> D=  B  ! 4 > 	? = ! t  4 > 	? = !   > 	? =  B  ! 4 ? ? = ! t  4 ? ? = !   ? ? =  B  ! 4 p@ @ > ! t  4 p@ @ >  B  ! 4 0A A D> ! t  4 0A A D> !   0A A D>  B   B   B   B   B   B   B   B  U UT	 P4 t d
 2 d T 4 p T	 4 2p!  d E E > !   E E >  2p 4 B
 B 9 0
 +t	 &4 B`P  
 
4 
2p T 4 Rp`! 
 I !J l? !   I !J l?  % p`P0C   G G4 d T 2p B   T 4 R
p`
 
4 
2P!
 
t d 0O eO ? !   0O eO ? !   t  d 0O eO ? !   t  d 0O eO ? 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !  Y Y @ !    Y Y @ !H
 HT : 5t
 0d	   Y Y @  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p
 
4 
2p d
 T 4 2p d 4 2p! T j ^k xA !   j ^k xA 
 
20 d	 T 4 2p!  `m m A !   `m m A !    `m m A !   `m m A  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d `u v \B !   t `u v \B !   `u v \B  t 20 20 d
 T	 2
p! 4 0x nx B !   0x nx B  b   t	 d T 2! 4 y y B !   y y B 	 	B   20 20 d T
 4	 R! t P| | HC !   P| | HC  d 4 2p
 
d	 
Rp! 4 p~ ~ C !   4 p~ ~ C !   p~ ~ C  d T 4 2p t 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p
 
4 
2p 2`! 	 t T 4   xD !   	  t  T  4   xD  d T 4 2p B   
4' 
$ p  C   ! d& p Μ D !   p Μ D  d 4 2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	 0 g F !   0 g F  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	   lG !     lG  B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
P^ (          %    1   4     E    f    '    4              2P'
 '4 
p`P^ P I     =       1          2P6 (4   
p`P  $D x    ~     r        X               ,    :        6                        H    R      2P, ,4"  
p`P  ^                          "    .        &    @      2P'
 '4 
p`P^       	                 2P, ,4"  
p`P  ^  >     g    s     @ o                 r              2P'
 '4 
p`P^         =     Q    E      2P- -x )h %4 
p	`P^ @             '    B      2P' d 4 p$D h j     
      2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p T p`0C P   
 
4 
Rp9
 +t! 'd  #4  
P  $D          '    3 	 	     	    	    	    U	     	 9
 +t! 'd  #4  
P  $D     ?     K    W 	 	     	    	    	    e	     	  d 4 p^  c     o 	 	     	    	     	  d 4 p^  {      P	 v	     	    ]	     	 9
 +t! 'd  #4  
P  $D 0               	 J	     ]	    m	    k 	     	     ?!	 9
 +t! 'd  #4  
P  $D X              "	 Z"	     m"	    }"	    {$	    $	     O%	 9
 +t! 'd  #4  
P  $D                &	 j&	     }&	    &	    (	    (	     _)	 '
 '4 
p`P^        0*	 o*	     *	    /	     /	 
 t	 d T 4 29
 +t# 'd" #4!  
P  $D          #    /    ; 5	 5	     6	    6	    6	    =	    &>	    >	     L?	  B  
 
4 
Rp*
 *4 
p`P^  G     S    _    X    X    X A	 ,B	     DB	    UB	    F	    EF	    gF	    F	    F	    F	    I	    I	     J	 # #d+ 4( " 
p  ^   k     w                               8S @            X   `J	 J	     J	    J	    K	    <L	    O	    O	     O	               
 
rP^   
 
4 
Rp !f f ^T ) !	 t
 
d 4
  Q	 Q	 S !     	  Q	 Q	 S !   	  Q	 Q	 S !    Q	 Q	 S   
  ! 4 a	 a	 8T !e ed     t T a	 a	 DT !   a	 a	 DT !   a	 a	 8T !         t  d  T  4 a	 a	 8T  T
 4 rp`  
  !e e Z  t d T 4 u	 u	 T !   T u	 u	 T !   u	 u	 T !         t  d  T  4 u	 u	 T  T
 4 rp` B  !6
 6 1t )d
 
T	 4 	 )	 |U !   	 )	 |U ! 
    t  d
  T	  4 	 )	 |U # #d! 4   
p  ^ H                                         HV @            8   	 ˇ	     և	    	    	    	    A	    	    ڍ	    	     	          5     
 
2P^ H  d T 4 p( (t $d  4  
	  ^ p C     O                           PW @           [ 8   	 	     ΐ	    	    2	    ͔	     	 [     h         
 
2P^ p #
 4 
p`PC X   	 T 
p`0  C `   
 d T 4 p
 d
 T	 4 2p 	p`P0C X    BP  !; ;t
  
d	 4 `	 o	 PX !   `	 o	 PX - -d 20! t 	 (	 X !   	 (	 X  BP  ! d	  t
 4 p	 x	 X !   p	 x	 X  d T 4 2p-
 G 
	p`0PC (  #
 4 
p`PC `   D
 Dt d	 T 4 2
 d T 4 p   C    !$ $  t d T 4% `
 
 |Y !    `
 
 |Y !   `
 
 |Y 
 d T 4 p B  !
 d
 T	  
t 4 @
 R
 Y !   @
 R
 Y  bP  !$ $   t 
d 4
 
 
 4Z !   
 
 4Z  d	 2! t T 4 
 
 xZ !   
 
 xZ  2
p`0! 
 
 T
 
 @
 Z !    
 @
 Z !   
    T
 
 @
 Z 
 t	 d T 4 2 20 20 d 4 2p t d T 4   
p`0^           X    X    X                               [ @            8   %
 J%
     ^%
    5*
    g*
    *
    *
    *
    +
    +
    +
    +
    ~-
     -
          	      2P
 
2P^   d 4 2p)	 !  p`0  ^       #    /           ;                             X    X    X                                             ]             ]    
         ]             ] @           [ 8   @            8   @            8   @           ^ 8   .
 .
     /
    -/
    43
    I3
    l3
    ~3
    3
    Y8
 	   8
    8
 
   8
    9
    :9
    9
    9
 
   9
    >
    >
    B
    C
     NC
 [     h                  )    P     k          2P
 
2P^   2P
 
2P^   2P
 
2P^  
 
2P^   4 
p`PC X    d 4 2p6 (40 & 
p`P  $D  *                   X 0H
 uH
     H
    H
    H
    O
    O
    O
    dP
    P
      2P6 (40 & 
p`P  $D  *           "    .    X  Q
 EQ
     eQ
    Q
    Q
    [X
    X
    X
    4Y
    gY
      2P; -x )h
 %4&  
p`P  $D 8    :     F    R Y
 $Z
     5Z
    QZ
    f
    p
     
     !% %   t d T 4  
 
 0a !       t  
 
 0a !     t  
 
 0a !   t  
 
 0a !    
 
 0a 9
 +t- 'd, #4+ $ 
P  $D `   ^     j p
 
     
    
     q
  20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   T 4 2`! t   c !     c  bP  !$ $   t 
d 4
  ) c !    ) c  d	 2! t T 4 0! E! d !   0! E! d  2
p`0! 
 
 T
 # # Ld !    # # Ld !   
    T
 # # Ld 
 t	 d T 4 2 20 20 B    ^                        e 	   X
 (   v 8   	   - 0    8   	    # 8    8   	    @   ! 8   	   F H   } 8   	   8
 P    8   	   > X    8   	   > `   n 8   	    h    8   	   0 p   & 8   	    S x    8   @            8   `* p*     * v                                .    o                           `     {                  3    t                       
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^  
 
2P^   B  # 4 rp$D  2    *  +     G+ 1	 #t! d  4  P  $D               ,    8    H     T    `    l    | , D,     ~,    ,    ,    ,    -    -    -      .    '.    Z.    .    .    .    .      2P d
 4 
Rp^    . /     _/  20 B  ? .4  
p`P  $D ( :                                         	    
        0    < 
   H    X    h    x                                        	        !    1    =    M     Y !   e     q #   } 01 1     1    3    4    n4    4    4    
5 	   %5 
   95    5 
   6    6    /6    6    7    "7    ]7    7    7    7    "8    68    8    8    8    8 !   9 "   Q9 $   9    9    9    C:    :    :    :    ;     +;  2P 20   ! 4
 = > k !   = > k    ! 4
 0? x? k !   0? x? k 
 
4 
2p 2p! 4 PA A l !   4 PA A l !   4 PA A l !   4 PA A l !   4 PA A l !   4 PA A l  B  
 t	 d T 4 2        h 	x    h 	x             m                     m r `n                     	                                      8   0<                      hq                    `o p 8n Pv `n z q                                    X
 (          `K                   P      {                     п     {                     J         (   Pd                  S            `                  `     y                     .            )                 P     r                    r  v `n                      (          P=                B         X                            h   b                      xp                    8x Py  v `n w xy                                             P=                 1         @                         0r                              8   <                u t (v  v `n w xy                                     :         P   c                       xu                    Pw x{ `n                           n                     (         @                   Hm Pv `n                    r `n                 `     P                          (     8z                    0         X   0(                Pp o `n                    8o y x o `x xy                                       x                     F            @e                 X
            `K                              >                 W         X    P                       q                     @3         8   ;                 PG         @   P                y `n                 4         X    h                s @| Pw x{ `n w xy                                            x                           s                    xv x{ `n                     P     o                           v                     0+         @   (                 '         @   P                  #             >                *         X                          z                    (w x{ `n                    +         X                         xw                           {                                 0                  >            `>                 -            5                              pv                          X   P                 
         8   =                r x{ `n                    Pv `n                 >            Pb                                               Hs r `n                           w                     @        (   PC                 g     s                     0     {                    x{ `n                N         X   p                  S (          `                  @         (   PC                 b     m                          z                    y  v `n                    xz p r x{ `n w xy                                     `         @                     `     @                          0            >                 %         @                    p
         8    ?                        q                    q t n  v `n w xy                                    3         X                   (v  v `n                     @ (       (   PC                v u `n                     v `n                 s ps x{ `n w xy                                       Xt                     *            0_                 v | xv x{ `n w xy                                    0u @q x m `x xy                                          @                    J         @   h                         L\    |          | | | 0 |   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581.cp36-win_amd64.pyd PyInit_stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_2353643874290201581          f           B  @~         t             h P           H         ڭ  ؃                     p p         < 0          \  0         ~                          P     v                         ب                    "     <     P     l                    Ω                    (     B     ^     ^             Κ     
     V               Z                    P          |     :               R                         r     t                         F     j               Ȗ     ޖ          ؛          "          ڧ               `     B               Ħ          x     R          ԥ          P                    8               x     *               T          ̡          B               v     6          ğ          4          t               Z     $     @                            ʪ     Ԫ                    ,     D     N     d                                                   Ԭ     ެ     T                       Ϋ     ʮ     ڮ                                   
          Ү                                 p     T     8                              ,                  p          \     @     6          "               ī             f          z     ֫                  J                       t     `     L     6                          Б                    h     V     H     6                         ؐ     ʐ                    |     n     `     J     2     "               ؏     ʏ                    r     X     B     2          
               ֎     Ǝ                    ~          X     H     :                    ލ     ʍ                    |     d     N     >     0                         Ȍ                    p     `     F     2     "                    ҋ                    t     `     F     .                    ܊               ֒          0     B          R     n                              ̓     ړ           r                     ,     @     T     V     B     h     ~                    Ԕ                         0     N     4          f     "                    ҉                    p     V     B     2                     ؈              PyBaseObject_Type qPyObject_SetAttr  PyUnicode_InternFromString  ? PyCFunction_Type  4PyOS_snprintf PyThreadState_Get V_Py_CheckRecursionLimit  PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches _PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  PyExc_RuntimeWarning   PyErr_PrintEx [PyFunction_Type JPyFrame_New PyLong_AsSsize_t   PyExc_DeprecationWarning  PyExc_KeyError  zPyImport_ImportModule |PyImport_ImportModuleLevelObject   PyErr_NormalizeException  QPyUnicode_AsUnicode oPyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  qPyUnicode_DecodeUTF8  SPyObject_GenericGetAttr PyTraceBack_Here  _PyThreadState_UncheckedGet PyExc_RuntimeError   PyExc_IOError rPyObject_SetAttrString  PyLong_FromLong RPyObject_GC_UnTrack PyUnicode_FromUnicode _PyObject_Hash  PyErr_SetNone 
PyExc_MemoryError  PyDict_GetItemWithError Py_GetVersion XPyObject_GetAttr  9PyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags * PyBytes_AsStringAndSize m_Py_NoneStruct  PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size KPyFrame_Type  <PyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable \PyObject_GetIter  PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx )PyExc_ValueError  W_Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError mPyObject_RichCompare  PyTuple_Type  b_Py_FalseStruct u PyCoro_Type APyFloat_Type  PyModule_NewObject  PyMethod_Type PyLong_Type PyType_IsSubtype  PyNumber_Subtract  PyErr_Restore PyExc_OverflowError vPyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  F PyCapsule_GetPointer  PPyObject_GC_Del  PyErr_Fetch CPyObject_CallFunctionObjArgs  PyLong_AsLong IPyObject_ClearWeakRefs  iPyObject_Not  PyUnicode_FromFormat  ZPyObject_GetBuffer  PyList_New  PySlice_New iPyImport_AddModule  !PyType_Ready  YPyObject_GetAttrString  q_PyGen_Send  PyErr_Clear PyList_Append 6 PyBytes_Type  _PyUnicode_Decode  W PyCode_New  2PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  APyObject_CallFinalizerFromDealloc ;_PyDict_GetItem_KnownHash cPyObject_IsInstance PyNumber_Index  PyExc_StopIteration PyList_Type  PyDict_GetItemString  [PyObject_GetItem  FPyObject_CallObject  PyErr_CheckSignals  PyModuleDef_Init  QPyObject_GC_Track 3 PyBytes_FromStringAndSize PyExc_NotImplementedError YPyUnicode_Compare dPyObject_IsSubclass !PyExc_TypeError PyMem_Realloc > PyCFunction_NewEx N PyCapsule_Type  ePyObject_IsTrue PyExc_NameError PyTuple_Pack  _PyByteArray_empty_string Py_OptimizeFlag ?_PyUnicode_Ready  PyMem_Malloc  PyExc_IndexError  PyExc_ImportError fPyGen_Type  t_Py_TrueStruct  
 PyArg_UnpackTuple PyExc_SystemError  PyExc_AssertionError  sPyObject_SetItem  _PyObject_GC_New  
PyTraceBack_Type  PyMethodDescr_Type   PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  _PyType_Lookup  tPyObject_Size  PyBuffer_Release  ?PyObject_Call ' PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python36.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 1EnterCriticalSection  LeaveCriticalSection  
DeleteCriticalSection SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  vGetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  iSetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  ~IsProcessorFeaturePresent wIsDebuggerPresent AQueryPerformanceCounter GetCurrentProcessId GetCurrentThreadId  GetSystemTimeAsFileTime DisableThreadLibraryCalls aInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                                                                                                                                                                                                                      2-+  ] f      /                              Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                     Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              a                                   P*                   Transform parameters from defined support to unconstrained space                                                                                                    	                                                       p          t                      p          H              o   p          h                                                              8+    H
                  Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                                              PV                                                                                                                                       @             `                                                                                                                      p                                                                                   8N      `                   HN   P                                                     0                   \                            p                      ;                         XN   `                      hN      @                   xN                          N                          N                                                                         X   @0          p   <>    *          pp   >   .          m                                                          W                                                                                                                                        @                                                                                                                                                                                                                           Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
                                                  @X                   a   h                                                                                                                                     hq   x               '                                                                                                                   @             )                   8               .                                                                                                                                                    &   Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                  Transform parameters from unconstrained space to defined support                Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

               q   &   `&    q           8q   @&   %   Hq                                                                                  0W                                                                                                                                       @                @                                                                                                                                                                                                      P   !
                   Q   
                  Q   p
                  A   0
          0    Q   P 
             O   	             0Q   	                  @Q   Р	          p   PQ   	                  XQ   0	             pQ   `	             Q   	             Q   `	             Q   s	          `   Q   a	          @   Q    P	             Q   PJ	             R   A	                   R   @	                  0R   @	                  @R   ?	                  PR   5	                  hR   @0	                  R    *	                  R   &	                  R    "	                  R   	                  R   @	                  R   	                  S   	                  (S   	                                                                         V                                                                                                                                       @             P                                                                                                                           `                                                                                   l                                                                                      R                   Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
           
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
                                     S   p               0                                   `	              P                    	                            D     T       0                                                                                          "
                                                                                                                      N   p                                                                                                                          D     O      p                                   `                                                                      0                                                                                   
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              N   @)                  N    !                  (N                                                      ,   C
              8S                              B                         HS      p                      P                       XS      `                   hS   @                      xS                          tG                          |   `                      S      @                   S                          M                                                                          d   `                         l   
                        i                            j      (                      `d      &                      d      &                      d   X                        Xj                           h                            h      <                      c      #                      l                           (k                           k   <                        pd   `                        Pe   P                        l                           xl                            Pj      $                      8j                           j                           8h   $                        j                            0g      
                     `k      
                     e   @   	                     g                           g      %                      i      (                      xh   p   A                      j                           h                           f                           @h                           (e                           @j                           l   p                         Hg                           hd                           d                            j                           i                           j                           (f      	                      f   h                        8d      
                     i   x                         `   h                        (d   x   
                     i   D                        Xe   `                        8a                           g                           g   $                        h   8                        j                           d   |                        h                           k                           xj   (   	                     e   l                        pk                           g                           d   D                        i                           l      
                      f                           j   `                        a   
                        e      
                     0k                           `j                           j      L                      l   0                        hl                           he   8   
                      Pl                           0d      	                      @i                           f                            `   x                        i   p                        e                           `                           j       +                      Hi      
                     k                            j   ,                        Xl                           i                           l   L                        xe      
                      d                           i                           g   ,                        Hh   L                        hi   @   
                     h                           (h      
                     0j   <                        i                           a                            k   `   
                     d                           `e   P   
                     He      
                     pj                           Xi      
                     `   p   	                     0h   (                        i   X   	                     e      
                     hk                           ph   (   
                     (i   x                         a                           k      .                      h   d                        f   @                        f   (                        k      
                     g   
                        e      	                     @f   @                        h       
                     g   X                         e                           i                           h                           Xh                           h       	                     l   x                        d   p   
                     k      
                     Ph                           8i                           d                            i   x                        g                           h   4                        xg   4                        g      	                     l                            g   H   "                      d   8                        k   <                        (l        x                      i                           8k      '                      0i   0   "                      0f                           d      
                     g   |                        `g   `                        `                           a                            xk                            8e                           a   8   	                     Hd                           f                           a   D                        pl                           hj   H                        i                           pg   X                        hg      
                     (a                            k                            e   `                        j                           d                           l                           e   (   
                     h                           k                           Xg                            Pg   H                        d      
                     j   x                        k   P   	                     pi                           h                           f                           8g                           Hj   x                        pe                           xi                           f                           Xk                           hh   p                        (g   8                        `l      H                      h   P                        Hl      	                     Hf                           k                           j      
                     g                           e      	                     h      	                     l      
                     `h   D                        f                           0l      	                     i                           g   h                        h   8   
                     l   
   
                     k   0                        d      
                     8l                           k   p   	                      c   P   %                      `                           j                           xd   <                         e   4                         h                            @e                           g                             k   L                        d                            h                            Pd   p                        h                           l   d                        i                           8f   X   	                     @d                                                                           `   `                   `   `   `           `   a   `           a   (a                    a            a           `   a    a   `                   `   `                   `   `                   `   a                   a   8a   a           u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                         .?AU?$located_exception@Vexception@std@@@lang@stan@@               .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                         .?AUPyErr_CheckSignals_Functor@?A0x36474e4c@pystan@@               .?AVmultiply_vd_vari@?A0x36474e4c@math@stan@@              .?AVadd_vv_vari@?A0x36474e4c@math@stan@@                           .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVneg_vari@?A0x36474e4c@math@stan@@                      .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVlogger@callbacks@stan@@                        .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AVdivide_vv_vari@?A0x36474e4c@math@stan@@                .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x36474e4c@math@stan@@                          .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@               .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                 .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AVsubtract_dv_vari@?A0x36474e4c@math@stan@@              .?AVlength_error@std@@                     .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVdomain_error@std@@             .?AVdivide_dv_vari@?A0x36474e4c@math@stan@@                .?AVcovar_adaptation@mcmc@stan@@                           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .H                 .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AVanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@                    .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                 .?AVbad_exception@std@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                           .?AV?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@                      .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@                     .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVbad_typeid@std@@               .?AVop_dv_vari@math@stan@@                 .?AVps_point@mcmc@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@             .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AUbad_exception_@exception_detail@boost@@                .?AV?$adapt_unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$numpunct@D@std@@             .?AVvari@math@stan@@               .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AVdump@io@stan@@                         .?AV?$unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@                      .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@             .?AVrounding_error@math@boost@@            .?AV?$diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVunderflow_error@std@@                  .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@               .?AVsum_v_vari@math@stan@@                         .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVempty_var_context@io@stan@@            .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                          .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AV?$adapt_dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AVchained_var_context@io@stan@@                  .?AVfacet@locale@std@@             .?AVadd_vd_vari@?A0x36474e4c@math@stan@@                   .?AVdiag_e_point@mcmc@stan@@               .?AVfixed_param_sampler@mcmc@stan@@                .?AVout_of_range@std@@             .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                   .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVbase_mcmc@mcmc@stan@@                  .?AV?$adapt_dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             .?AVdense_e_point@mcmc@stan@@                      .?AV?$dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                         .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVsum_values@pystan@@            .?AVmultiply_vv_vari@?A0x36474e4c@math@stan@@              .?AV?$adapt_diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@                       .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@                     .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AVprob_grad@model@stan@@                 .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AV?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVexception@std@@                        .?AV?$adapt_diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                        .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AVwindowed_adaptation@mcmc@stan@@                .?AVvalue@pystan@@                 .?AVexp_vari@?A0x36474e4c@math@stan@@              .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AV?$adapt_unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                                                                                                                                                                                                                                                                                                                                                                                                                                                   V   `             >   @  ^               
   0            F   P                        V   `                                            &   0  F   `    p   #  x `       %   0  p  p p       y        P  #  h  $  V$  @ `$  $  L $  $  p $  %  p %  '&  \ 0&  &    &  '  4  '  (  D (  )   )  s*   *  3+   @+  +   +  ,   ,  ,  x ,  -   -  -  p -  .  p 0.  [.  p `.  &/   P/  {/  p /  /  H 0  ;0  p @0  k0  p p0  0   0  ^1  h `1  1   1  N2   P2  r2   2  >3   @3  b3   p3  .4    04  R4   `4  5  0  5  K5  p p5  5  x 5   6  p 6  ;6  p @6  l6  p 6  6   6  6  p  7  L7  x 7  7  p 7  7  x  8  G8  x P8  Y9  ` `9  i:   p:  y;   	 ;  <  H	 <  !=  	 0=  =  	 =  =  p  >  ?    ?  E?  p P?  ?  	 ?  P@  	 `@  @   @  B  
 B  B  x B  C  H
 C  IF  
 PF  oG  
 pG  J  x `K  K  p K  K  p K  :L   :L  ~L  , L  L  p L  ,M  < 0M  eM  p pM  @P  x @P  Q   Q  S   T  T  p  U  U   U  V   V  0W  ( X  X  h X  ]Y   Y  mZ   [  "\  
 0\  \  H
 \  ]  
  ^  .^  p 0^  ^  
  _  ._  p 0_  p_  p p_  X`  
 p`  b     b  Db  p Pb  b  p b  >c   @c  d    d  ?e   @e  e  p g  h  P h  j  \ j  k   k  n   n  o  P o  jo  \ jo  o  x o  ]p   ]p  fp   fp  lp   pp  q   q  s   s  Yu   `u  u  ` u  u  h u   v  |  v  ]v   ]v  fv   pv  v  p v  `w   w  x   x  cy   py  }  P }  }  p }  ~~  ( ~     @    C  x `    p        ;   `    x   ~     ~     3   @  Ď  ( Ў              x          ė   З       R  X R    h   -  | 0  S   `    p     p    d   p    p   7  P 7  r  d   9  p @  a  x p  B   P    p   U  P `  ԣ     n   p  Q   `            z  ( z  
  @ 
  8  P 8  u  h u    @     |    g   g       A   A  Ӭ   Ӭ  
   
  G    G  \   \       <  p <  o  4 o  =  H =    \   ޯ  l ޯ        j   j  x   x  G   G  Ѳ               @   @  ߵ  x         F   P  v          E  ( P    4     x      x   ȿ    п     !     p!     "     d$      % 0    %      %     %   i  h' p    '   S  ' S    '     '     '     p     '   j  X( p    h(   )  ( 0    )      )     4)     p   j  D) p    *   T  @ `  G  X* P    l*   L  * P    0+     X(     x+     +     +     +   2  + 2    +     +     `,   *  , *  p  , p    ,   {  ,     +    I  - P    -     $-   Y  8- Y    T-     d-     p   >  - @    -    ^  0. `    `.     .     .   /  Y h/ `  /  R / `  /  
 / 
 z H0  , 0 0  ,   +  & - 0 S - ` p 0 p  0  o (1 p  X1  + 1 0  1     1 x @  p  9 1 @  x    p   @ p `  x   p    1  " x 0  x   x  Z p `  x   x      K  2 P    (3  ! e! p p! ! x ! ! x ! .  . / 3 / 3 3 4 04 p 04 ; `4 ; /< @5 0< < x5 < O= 5 P= = p = > 5  > `> p `> > p > > p >  ? p  ? ? 6 ? @ x @ f@ x p@ @ x @ &A x 0A A x A A 86 A nB h6 pB B 6 B NC 6 PC C x C ;D p @D (E 6 0E i 7 i k  k | ? |   E  b F p ی @F  ? @H @ t x  W  ` Ԓ    I  o J p  p  ϖ  Ж  `J   I  P y      ٗ   x J   K  K K P  L   H L P  M  V 8M `  M   hN   N   x   V p `  N   p  D N P  p   N  & p 0  N  Ʈ p Ю $ N 0  O  G p P /  0  PO  G p P ] x `  O  R O R  O   P   p  N P N  ,P   @P  , x 0 C 1 P  1  s x   p  : x @ ? p @ , x 0  x   p   8  8  PP   dP   tP   p  > x @  P  I 0Q I  8Q   LQ   \Q  B xQ P  Q   Q   Q    Q   (R   Q   XR   x   R  P p P  x     Q S Q _ (S `  8S   x      S   S    x  q O q  S   S  + T 0  P   T   (T  l x p  x   x      e 8T e s LT   p      K  P    * x 0 a  p     p  Y \T `  p   p  0 x 0 r p   p   xT   T  
 T  > p > \ T \ s T  ^ x `  U P  PU      t x  \ hU `  U  3  @  x  ^ V `  PV  T XV T j lV p  |V  V V V  V   V   V    x   x     `  `  x   V   W   p  Z p `     0Q   x    PW  b  p     c x p  W  v p            0X   0Q  T X T J X J a X p 4 X 4 * X * A Y P     Y   HY          x      2  @  x   @   L   xY  	 l	 Y p	 
   
  Y      ! Y 0  x       M  P u Y    Z   Z   (Z  q x  ) @Z 0  Z  O  P  Z    p  6 x @ ? Z @  Z      u   $ $  $ %   % %  % k& [ p& ' 0[ ' (  ( ( [ ( ) H[ ) "*  0* * Q * "+  0+ , [  , , [  - - Q - . x . / 0[ / 0   0 4 [ 4 q9 [ 9 	: [ : : L : : [  ;  ;   ; < \ < @ \ @ @ ] @ A $] A A 8] A (B H] 0B B H] B zC p C KD [ E 2E P] 2E F `] F F t] F ?G ] @G bG P] bG H ] H 
I ] 
I oI ] pI I  I K ] K M ^ M O _  P 9P p @P P Y P P x` P vQ ` vQ Q ` Q S ` S T ` T aT x pT U Ha U V Q  V pV  pV W a W W b W X b X Y   Y Y c Y Z   Z Z @c Z [ c [ t\ c \ \   ] x^ c ^ _ d _ ` xd ` b d  c c @e  d \d x `d d x d e p  e ~e x e e p e 6f p @f f p f f p  g 6g e @g vg e g g Pf g g f  h 6h  g @h vh g h h g h h Xh  i 6i h @i vi (i i i i i i i  j 6j `j `j k j k t j t 1u l 1u }u l }u u m u w  m w L `m P  p   xq    Hr   P s P  s  j u p f Hv p :  w : ) w ) = (w @        8w    pw   w     9 w 9 ? w ? E w P i w i   x   x   ,x     K  P o p p  Hx    xx   p  u p  I x P  x   x @   y  . xy 0 H y H  y   y    z   z   @z   pz    z   z 0  z    [   t{  =  @  {    8|   x   p   h|  ] p `  |    Q  $  0  [  ( | P  |  Y |} `     p      }   ~  I P~ P  ~   ~   (  ( 8 ( K P K / d 0  |  B  P    \ 4 \  H    p   K X P J x P    /  0  Ё       I  P G  P  0  R 8 `  8        p   D      p     ' ܈ ' 7 8 7 Y<  `< = ` = L?  P? @  @ <B  @B /E P 0E H Џ  I >J ` @J K  K .M А 0M N  N Q @ Q U  U Z P Z _  _ &t  0t r    h  Ɨ  З 4 @  Ә  Ә e  e f  f  ě  . ܛ 0 Κ P К ޚ Ȝ ޚ h М h i  i     Ȝ      (  ۜ 8   Ȝ  x P x y h y  x  	   #  #  0   H  ٞ X    p     B   P    t p     ?  ? -  0 Ш ğ Ш       g $ g t 4   D  ^ x `  p     ο  п  p  x    p  (  0 R p `  p   p  , p 0 o x p  x  8 x @  x   x  t p  	 x   x  = 8 @ m  p j y p  0   p   P  6 \ 6 D p P  p  ' x 0        p   @   z p   H    d    t  -  - n  n ~    @  6 @ @ $  0    =    x  V  `     0   ئ   6  @ r      x  	 Ш 	 z
  
 
 8 
 f ` p Z  `    F
 ة P
 
   
 : ( @  P   x  i  i    - H] 0     z x   x  j x p  x  O L P    ^$  `$ 1 ` 1 =A  @A /N ` 0N N H]  O IP  PP P x P Q p  Q Q X(  R )S  0S [ ط  \ \   ] O^ 8 ^ )_ ع 0_ uc  c (e ( f g ع  g ;h x @h l  l qm 0 m !n x 0n n  n Xo  `o p  p .q  .q q  q r  r =s м =s ^s  `s u  u Sz 0 `z ~ P ~  p   @                   T 0 `  ,   p   X   l p ҈ x   p  % p %  |        ȋ p ȋ . 4 . U H `    ύ X Ѝ    d  d p  p Î ( Î  4   H    X  d ( d    ۖ  ۖ       /  0        v , v  P  
 d 
 ' t 0    /  0           <   \  [ l [ y \     ߨ       J  P    I  P  0  R X ` 	   7  @  x   [  `  (  H P P  h         & D 0  X  "  0       5&  @& & 8 & - 0  - - 0 - .  . =8 ` @8 U8   U8 8  8 8  8 W9  W9 .: , .: Q; @ `; ~; P ~; ; ` ; < |  < >< P >< <  < <  < >  > wC  C D ` D PQ  PQ ~T  T a  a a x a b  b b p b xc  c Ad  Pd d x d e x+ e f p f ff p pf f p f &g p 0g g 8 g g p  h h p h Ni  Pi i x i j  j Oj x Pj j  j ek ( pk k P k Vl x `l l  l n  n p ` p s j `s ~t  t u  u 4v p v v x v y (  y 7z x @z z p  { g{ x p{ 8~  @~     p  ? H @ F t P n ( n ԁ 8 ԁ  X   h      T   ΄ x Є !  0 +  0      p  / H 0 6 t @ 2  @  H  J  ` ܖ    N x P       E  P    6  @     @  S  ` ԩ   V  `     Y 0Q Y       & x 0 d x p  x  $ x 0  x   x  f x p  x  & x 0     H] @ V H ` ɴ p д     (   p  	 p  Y P `    6  @        ~    x  \ x ` = X( @ e  p    <  <    .  0  (      8   D   \   p  o  p          C  P \  `        q        p   ?  @ O X P  H  s
 x 
     (   <   T  " t " '    ( (  ( Y) , `) )  ) Z4  `4 5 @ 5 o8 H p8 9 @ 9 G<  P< ? @ ? ?   @ ]@ P `@ @  @ C  C (D | 0D F 	 F G 	 G G @
 G DH 
 PH jH p jH I | I I  I I  I `J  `J nJ  J J  J K  K K  K K  K 
M  M R  R GS  GS T \ T AU p PU U  U 'W  'W X   X PX  PX `Y  `Y PZ  PZ ]  ] _ 8
 _ `  ` a  a a p a b  b ib  c Zd x d d x d ff  pf h  h #i  0i i L i k H] k l @ l cm x pm m x  n cn x pn n p n o  o o  o r  r s   s u  u vv p v +w  +w Ӏ  Ӏ     7  @  4      D  y  y    _  ` d   p              \ @ `    ˙  Й "  0 8  @  `   @  / p / e | e ף   ۥ    p  5  5  (   8         T  ̬ \ ̬ J p J   @ T  T       Ѯ  Ѯ i  i     ( PV (    [  `    V   V  8 @ h PV h  H   `   p            $  % 4 0 O p P  H   p   p  H  P     _ x `     x    (  : X @  H]     e  p    V  `    U 0 `  X  F  P    J  J        H]   p        H         m @ m  T   h   s x              & $ &  4  N T P - d      t          p   ?  @  p       p    T  ` K ( P  D  Q X Q e p p Z  Z          @  @    9  9     l    l r 4  r  D    T   U d  U  t                                !     !    0!  4 @! 	 	   
 
 @ 
  L!   !   X(  A H] P k Y p  !   !  6 " 6 E $" E F 4" P  D"   "     _ " _ r "  a " p  H]   G  G  8#   X#     u h# u  # `    E # E   #    #   #   #     S  $ S     $  ! H" 0$ P" # x$ # # $ # % $ % e& $ p&  '  %  ' ' % ' ( (% ( /( p 0( ( 8% ( ~) `% ) ) p ) ) x  * ~* % * - p - / j / &0 % &0 1 % 1 1 % 1 2  & 2 3 & 3 3 8& 3 3 `&  4 4 & 4 4 &  5 5 & 5 s6 ' 6 6 H'  7 7 x' 7 7: ' @: :  ( : ; @( ; |= T( = = p = =   > ? d( ? @ ( @ @ p A }B j B FE ( PE uE  uE JF ( JF G ) G G PV G H ) H H 8) H I PV I 
J H) 
J HJ d) 0L DL t) DL aL |) aL HM ) HM M ) M M ) M M ) M O ) O O *  P P p  P P ,* P nQ X* pQ Q *  R R * R R x R T H] T uU + U U @+ U fV h+ pV V + V W + W W + W X + X CY  , PY ] H, ] {a , a a  a a  `e f (- f i P- i =k - @k n -  o s . t t  t u L. u `v l. `v v  v Xw |. Xw Ax . Px y . y ~ .    H/  L j P  /   /  U / U  /  c / p  0   (0   `0   p0   |0  v 0 v  0  Ɣ 0 Д     0  p 0 p  0  ė 1 ė ˗  1 З     K 01 K Q D1 `  T1   p1  # 1 #  1  { 1  ʫ 1 ʫ  1   2    H]  7 (2 @  x2  ׵ 2  Z 2 ` {  3   H3   T3   3   3  < 3 <  3   3    `4   PV   4   4   4 T1 4  4   4  " 4 "  4  ' $5 ' H @5 H 0 X5 0 - l5 0  |5   5   5  < PV <  5  ) 5     ] 5 ` Z  6 ` } 86 } P D6 P W \6 `  l6    6   6    7  m  7 m s 07   L7  \ 7 `  7  3  7 3  g  7 p    j   7  L p   8        L p L  p   p  o p p    D p D }            		  	 m	 Q p	 	  	 	  	 	 p  
 
 D8 
 e 8 h  p   p   p    0 [ p \    
 P8 
 Z |8 \ Q 8 T  Q     $ p $    i 8 l  8   p ( j x l  p   p  r 8  4 8 4 W         >   K 9 K y ,9 y  @9   X9  t l9 t  |9   9   9 0  9   9  , 9 , P 9 `   :    :  U  : `  ! : ! ! $:  " k" 4: " ># <: `# $ D: $ 3% P: @% % X: % /& p: `& & x: & ' : ' ' : ' ' : ' ( :  ( ( : ) }) : ) ) :  * * : * * : * r+ ; r+ , ; , , ,; , 8- @; @- - T; - - `; - m. t; . (/ ; 0/ / ; / 	0 ; 	0 10 ; @0 B1 ; P1 1 ; 1 2 ;  2 p3 ; 3 L4 ; `4 s6  < 6 6 < 6 7 < 7 '8 (< 8 8 4< 8 C9 << C9 J9 P< J9 9 `< 9 9 t< 0; ; < ; ; < ; ; < < i< < i< < < < < < < < < < I=  = I= h= = h= = = = = 4= = )> D= )> H> L= H> x> `= x> > x= > 	? = 	? (? = (? X? = X? |? = ? ? = ? @ = @ 8@ = 8@ \@  > p@ @ > @ @ > @ 'A ,> 0A A D> A A L> A A `> A A x> B B > 0B ?B > PB _B > pB B > B B > B B > B B > B B > C AD > PD sE > E E > E F ? F F  ? F 0G 0? @G G 8? G OI @? `I I `? I !J l? !J J ? J J ?  K L ? PL M ?  M IM ? PM N ? 0O eO ? eO O ? O P @ P xP  @ xP P 8@ P P P@ PQ R \@  S RW l@ `W tY |@ Y Y @ Y %Z @ %Z VZ @ VZ u\ @ \ *] @ 0] ^ @ ^ ^ @ ^ _ A _ ` A ` a A c :d A 0e e $A e f ,A f g <A 0g g DA g g PA  h i \A j ^k xA ^k k A k l A l Pm A `m m A m m A m m A m To A To io  B po rr B r &s $B 0s Ut ,B t t HB u Tu TB `u v \B v Ov hB Ov dv B dv qv B v w B w #x B 0x nx B nx 
y B 
y !y B 0y ry B y y B y Kz C Kz az  C pz z 0C z { 8C { A| @C P| | HC | C} \C C} Y} pC `} } C p~ ~ C ~  C  , C , T C `  C   C   C   C  { D  u D  ׅ 0D   HD  r `D   lD   xD   D   D 0 Ǜ D Л  D p Μ D Μ ҝ D ҝ  E    E    (E   0E   8E   @E    PE  + \E @  dE   lE   |E  ; E P  E  K E ` ۲ E  W E `  E  [ E p  E   m E  
 E @  E  M F   F    F  - (F ` ͹ 4F   F @F p ݺ HF  } TF   `F 0  lF     tF 0 g F g  F   F   | F   F   m F  
 F @ q F   F  M F   F  ] G   G  $ G 0 v  G   (G  A 0G `  8G   @G   \ HG p  TG   \G   lG  $ tG $ * G 0  G 0  G   G    G   XH   H  x xI  8 J @  \J   J   @K   K   K  m K   K  J 	 L P 	  	 (L  	  	 0L  	 	 8L 	 E	 DL 	 	 PL 	 	 XL 	 E	 `L P	 	 lL 	 	 xL 	 G	 L P	 	 L 	 	 L 	 G	 L P	 	 L 	 	 L 	 	 L P	 	 L 	 	 L 	 	 L 	 E	 L 	 	 L 	 	 L 	 E	  M P	 	 M 	 	 M 	 G	  M P	 	 (M 	 	 4M 		 G		 @M P		 		 HM 		 		 PM 		 
	 \M P
	 
	 hM 
	 
	 pM 
	 	 xM 	 	 M  	 W	 M `	 	 M 	 	 M  
	 W
	 M `
	 
	 M 
	 
	 M 
	 	 M `	 	 M 	 p	 M 	 n	 M 	 ~	 xN 	 9	 N P	 	 DO  	 !	 O "	 %	 P  &	 *	 P 0*	 50	 Q P0	 5	 `Q 5	 ?	 xQ  @	 o@	 R @	 A	 R A	 HJ	  R `J	 P	 R  P	 P	 S  Q	 Q	 S Q	 a	 S a	 <a	 S <a	 Xa	 T Xa	 a	 (T a	 a	 8T a	 a	 DT a	 yr	 XT yr	 r	 T r	  s	 T  s	 s	 T s	 u	 T u	 u	 T u	 
	 T 
	 -	 U -	 x	 ,U x	 R	 <U `	 	 hU 	 )	 |U )	 ۆ	 U ۆ	 	 U 	 q	 U 	 P	 U `	 x	 V 	 %	 V 0	 ŗ	 W З	 	 W 	 ʝ	 X Н	 	 X Р	 Z	 4X `	 o	 PX o	 {	 \X {	 	 |X 	 (	 X (	 ֦	 X ֦	 U	 X p	 x	 X x	 	 X 	 	 X 0	 	 X 	 y	 Y 	 o	 ,Y 	 B 
 LY P 
 Z
 dY `
 
 |Y 
 
 Y 
 
 Y 
 *
 Y 0
 :
 Y @
 R
 Y R
 N
  Z N
 j
 $Z 
 
 4Z 
 c
 @Z c
 
 hZ 
 
 xZ 
 
 Z 
 
 Z 
 @
 Z @
 
 Z 
 
 Z 
 + 
 Z @ 
 !
 [ !
 !
 $[  "
 /"
 ,[ @"
 "
 4[ "
 $
 D[ %
 -
 `[  .
 |.
 \ .
 C
 \ C
 BF
 4_ PF
 H
 P_ 0H
 P
 `_  Q
 Y
 ` Y
 
 `  
 
 0a 
 
 <a 
 
 ha 
 
 a 
 H
 a H
 b
 a p
 
 a 
 
 $b 
 ' ,b 0  4b @ w @b   Hb   Pb  
 5
 \b 
 
 hb 
 
 pb   5 xb @ u b  ^ b   b  4 b @ w b   b   b   5 b   b   b    b  G b P  b    c   c P  c  d $c p  ,c   4c  G <c P  Dc `  Pc   Xc   `c   lc  3 xc P  c  F c P  c   c   c   c  ) c )   c   ! d 0! E! d E! t#  d t# # <d # # Ld # & \d & &' xd &' ' d ' ,) d P) ) d ) ) d ) D* d `* * d * * g * j+ g , . g . / h  0 0 i  1 %1 i 01 p; i ; = k = > k > > k >  ? k 0? x? k x? @ k @ [@ k p@ @ l PA A l A A l A #B 0l #B vB Dl vB B Xl B C ll C 'C l @C C l C C  C !D PV $D D l D E l @E 0H l 0H  K l pK rK 9 K K   K K   K K   M 6M   @M fM   M M   pN N   R :R   R S @ PS S   T T  T U   <W eW   W Y " @Y iY   Y ([ P$ P[ [ $  \ \ % ` `   de e > f f D g g D g h D h zi D i {j D l m    m ~m J m m   @n fn   n n   o o   o o    p np O pp p P p 7q  S @q q S q q    r .r   @r nr   r r W 0s s X s s \ s t \ t t ^ u @u _ Xu u h` v Pv b `v v   v w   Pw kw e pw w @f w w f w w g w w xg w x g x +x Hh 0x Kx h Px kx i px x i x x i x x Pj x x j ,y ]y   y y   y /z   gz z l { ,{   h| | hq | | 8r | }  s (} D} s } (~ u @~ f~   ~ ~   ~ ~   ~    @ j   p         . `{ 0 P   P }           0 j h} p   ~     F w   ̂    2 R   R     ƃ    "   " O   |    , U    q Ȉ Ќ     $ X H y        K          T     @         0   0 ^    A   Г     ͔   L m   Ε    7   o       -    ͘   .   f    ϙ   ? j    h p  (           *   @ ` x x    ՝ , @ H y     `   R        +   0 Y         x       x أ  x F  x 4 e   0 ` H Ĩ   0 d   ĩ ߩ  $ ? @   X    p X 0 Ĭ ߬ H $ ? p       @ (   ů    .   f    ϰ     8 e        9   q    ڲ    C t    ݳ    ?  l   D  x T  h ж      *   `      0   0 M   P z   0 Z    @ h  h (  h @   `  ȿ      @      4 e        7   o     	   A n 0      0 @ 0 L   L p  p  h        	  * 	 0 L   L p 0
 p      
       `  0   J e  p      h @ j 0 p         :  @ d   d  @      :       P z   d | <8 |            % PH I r H ~  pI   I  > TJ > g J   8K   K   K   S  C V [  W   l\   t\ ; [ ^ [  ^   ^   ^   _  ^ _ ^  $_    `  " ` v  f   f  ! f ! } g }  g   ,g  n <g n  Lg  & \g &  lg   |g   g    h   k  #  0    c  p       C  p    
   ]  p    
   ]  |                                                                                                                                                                                           1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `0                    <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                    ȪЪت  (08@HPX`hpxثȬЬ  (0PX`hpx@HPX              px     (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء 8@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPX`hpxȤФؤ  (08@HPX`hpxȥХإ  (08@HPX`hpxȦЦئ @HPX`hpxȧЧا  (08@HPX`hpxȨШب  (08@HPX`hpxȩЩة  (08@HPX`hpxpxȫЫث  (08@HPX`hpxȬЬج  (08@HPX`hpxȭЭح  (08@HPX`hpxȮЮخ  (08@HPX`hpxȯЯد    (    PX`hpxȠРؠ  (08@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPX`hpx(08@HPX`hpxȥХإ  (08@HPX`hxhpxȧЧا(08@HPX`hpx(08@HPX`hpxȩЩة  (08@HPX`hpxȪЪت  (08@HPX`hp 
    08@HPX`hpxȤȥХإ  (08@HPX`hpxȦЦ   
    h       pXpȣ@H (Чا  (0HPXpxȨШ 8@HȩЩة(@ȪH     hȠ0ȨШب8PةXЪت(08HPXhpxЫث(08HPXhpxȬЬج08PXpxЭح08PXpxȮh    8   @xȨШ HX X`ت(    `h (08PX`xȢТآ  (@HPhpxȣ8@`hؤ (0PXxȥХ @Hhp08X`Чا  (HPpxȨ8@`hة (0PXxȪЪ @Hhp08X`Ьج  (HPpxȭ8@`hخ (0PXxȯЯ     @Hhp08X`Сء  (HPpxȢ8@`hأ (0PXxȤФ @Hhp08X`Цئ  (HPpxȧ8@`hب (0PXxȩЩ @Hhp08X`Ыث  (HPpxȬ8@`hح (0PXxȮЮ @Hhp   0  08X`Рؠ  (HPpxȡ8@`hآ (0PXxȣУ @Hhp08X`Хإ  (HPpxȦ8@`hا08PX`pxШب  (@H`hp8p`0XH    T    p@hPhȦ@0p0` ȫ `(`   H   ` Hxأ 0Х8`PpЪ0P@   0 H   p@ Ф@PЪ0 8`Э0  @ 8   8p 0`P`@   P (    x P hȦ                                                                                                                                                                                                                                                                                                                                                                                                                          ub.