e     pystan.model	StanModel)}(
model_cppname+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2
model_name+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2
model_codeXy  functions {
  real[ , ] get_changepoint_matrix(real[] t, real[] t_change, int T, int S) {
    // Assumes t and t_change are sorted.
    real A[T, S];
    real a_row[S];
    int cp_idx;

    // Start with an empty matrix.
    A = rep_array(0, T, S);
    a_row = rep_array(0, S);
    cp_idx = 1;

    // Fill in each row of A.
    for (i in 1:T) {
      while ((cp_idx <= S) && (t[i] >= t_change[cp_idx])) {
        a_row[cp_idx] = 1;
        cp_idx = cp_idx + 1;
      }
      A[i] = a_row;
    }
    return A;
  }

  // Logistic trend functions

  real[] logistic_gamma(real k, real m, real[] delta, real[] t_change, int S) {
    real gamma[S];  // adjusted offsets, for piecewise continuity
    real k_s[S + 1];  // actual rate in each segment
    real m_pr;

    // Compute the rate in each segment
    k_s[1] = k;
    for (i in 1:S) {
      k_s[i + 1] = k_s[i] + delta[i];
    }

    // Piecewise offsets
    m_pr = m; // The offset in the previous segment
    for (i in 1:S) {
      gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
      m_pr = m_pr + gamma[i];  // update for the next segment
    }
    return gamma;
  }
  
  real[] logistic_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[] cap,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    gamma = logistic_gamma(k, m, delta, t_change, S);
    for (i in 1:T) {
      Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta))
        * (t[i] - (m + dot_product(A[i], gamma)))));
    }
    return Y;
  }

  // Linear trend function

  real[] linear_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    for (i in 1:S) {
      gamma[i] = -t_change[i] * delta[i];
    }
    for (i in 1:T) {
      Y[i] = (k + dot_product(A[i], delta)) * t[i] + (
        m + dot_product(A[i], gamma));
    }
    return Y;
  }
}

data {
  int T;                // Number of time periods
  int<lower=1> K;       // Number of regressors
  real t[T];            // Time
  real cap[T];          // Capacities for logistic trend
  real y[T];            // Time series
  int S;                // Number of changepoints
  real t_change[S];     // Times of trend changepoints
  real X[T,K];         // Regressors
  vector[K] sigmas;     // Scale on seasonality prior
  real<lower=0> tau;    // Scale on changepoints prior
  int trend_indicator;  // 0 for linear, 1 for logistic
  real s_a[K];          // Indicator of additive features
  real s_m[K];          // Indicator of multiplicative features
}

transformed data {
  real A[T, S];
  A = get_changepoint_matrix(t, t_change, T, S);
}

parameters {
  real k;                   // Base trend growth rate
  real m;                   // Trend offset
  real delta[S];            // Trend rate adjustments
  real<lower=0> sigma_obs;  // Observation noise
  real beta[K];             // Regressor coefficients
}

transformed parameters {
  real trend[T];
  real Y[T];
  real beta_m[K];
  real beta_a[K];

  if (trend_indicator == 0) {
    trend = linear_trend(k, m, delta, t, A, t_change, S, T);
  } else if (trend_indicator == 1) {
    trend = logistic_trend(k, m, delta, t, cap, A, t_change, S, T);
  }

  for (i in 1:K) {
    beta_m[i] = beta[i] * s_m[i];
    beta_a[i] = beta[i] * s_a[i];
  }

  for (i in 1:T) {
    Y[i] = (
      trend[i] * (1 + dot_product(X[i], beta_m)) + dot_product(X[i], beta_a)
    );
  }
}

model {
  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  y ~ normal(Y, sigma_obs);
}

model_cppcodeXH  // Code generated by Stan version 2.17.1

#include <stan/model/model_header.hpp>

namespace anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unknown file name");
    reader.add_event(157, 157, "end", "unknown file name");
    return reader;
}

template <typename T0__, typename T1__>
std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
get_changepoint_matrix(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        vector<vector<local_scalar_t__> > A(T, (vector<local_scalar_t__>(S)));
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        current_statement_begin__ = 5;
        validate_non_negative_index("a_row", "S", S);
        vector<local_scalar_t__> a_row(S);
        stan::math::initialize(a_row, DUMMY_VAR__);
        stan::math::fill(a_row,DUMMY_VAR__);
        current_statement_begin__ = 6;
        int cp_idx(0);
        (void) cp_idx;  // dummy to suppress unused var warning

        stan::math::fill(cp_idx, std::numeric_limits<int>::min());


        current_statement_begin__ = 9;
        stan::math::assign(A, rep_array(0,T,S));
        current_statement_begin__ = 10;
        stan::math::assign(a_row, rep_array(0,S));
        current_statement_begin__ = 11;
        stan::math::assign(cp_idx, 1);
        current_statement_begin__ = 14;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 15;
            while (as_bool((primitive_value(logical_lte(cp_idx,S)) && primitive_value(logical_gte(get_base1(t,i,"t",1),get_base1(t_change,cp_idx,"t_change",1)))))) {

                current_statement_begin__ = 16;
                stan::math::assign(get_base1_lhs(a_row,cp_idx,"a_row",1), 1);
                current_statement_begin__ = 17;
                stan::math::assign(cp_idx, (cp_idx + 1));
            }
            current_statement_begin__ = 19;
            stan::math::assign(get_base1_lhs(A,i,"A",1), a_row);
        }
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(A);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct get_changepoint_matrix_functor__ {
    template <typename T0__, typename T1__>
        std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
    operator()(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) const {
        return get_changepoint_matrix(t, t_change, T, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
logistic_gamma(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 28;
        validate_non_negative_index("k_s", "(S + 1)", (S + 1));
        vector<local_scalar_t__> k_s((S + 1));
        stan::math::initialize(k_s, DUMMY_VAR__);
        stan::math::fill(k_s,DUMMY_VAR__);
        current_statement_begin__ = 29;
        local_scalar_t__ m_pr;
        (void) m_pr;  // dummy to suppress unused var warning

        stan::math::initialize(m_pr, DUMMY_VAR__);
        stan::math::fill(m_pr,DUMMY_VAR__);


        current_statement_begin__ = 32;
        stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
        current_statement_begin__ = 33;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 34;
            stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 38;
        stan::math::assign(m_pr, m);
        current_statement_begin__ = 39;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 40;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
            current_statement_begin__ = 41;
            stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
        }
        current_statement_begin__ = 43;
        return stan::math::promote_scalar<fun_return_scalar_t__>(gamma);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_gamma_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) const {
        return logistic_gamma(k, m, delta, t_change, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
logistic_trend(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 57;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 58;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 60;
        stan::math::assign(gamma, logistic_gamma(k,m,delta,t_change,S, pstream__));
        current_statement_begin__ = 61;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 62;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (get_base1(cap,i,"cap",1) / (1 + stan::math::exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))));
        }
        current_statement_begin__ = 65;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) const {
        return logistic_trend(k, m, delta, t, cap, A, t_change, S, T, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
linear_trend(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 80;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 81;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 83;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 84;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 86;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 87;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (((k + dot_product(get_base1(A,i,"A",1),delta)) * get_base1(t,i,"t",1)) + (m + dot_product(get_base1(A,i,"A",1),gamma))));
        }
        current_statement_begin__ = 90;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linear_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
    operator()(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) const {
        return linear_trend(k, m, delta, t, A, t_change, S, T, pstream__);
    }
};

class anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
    int trend_indicator;
    vector<double> s_a;
    vector<double> s_m;
    vector<vector<double> > A;
public:
    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 96;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 97;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 98;
            validate_non_negative_index("cap", "T", T);
            context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
            validate_non_negative_index("cap", "T", T);
            cap = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("cap");
            pos__ = 0;
            size_t cap_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
                cap[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 99;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 101;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 102;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 103;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "trend_indicator", "int", context__.to_vec());
            trend_indicator = int(0);
            vals_i__ = context__.vals_i("trend_indicator");
            pos__ = 0;
            trend_indicator = vals_i__[pos__++];
            current_statement_begin__ = 106;
            validate_non_negative_index("s_a", "K", K);
            context__.validate_dims("data initialization", "s_a", "double", context__.to_vec(K));
            validate_non_negative_index("s_a", "K", K);
            s_a = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_a");
            pos__ = 0;
            size_t s_a_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_a_limit_0__; ++i_0__) {
                s_a[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 107;
            validate_non_negative_index("s_m", "K", K);
            context__.validate_dims("data initialization", "s_m", "double", context__.to_vec(K));
            validate_non_negative_index("s_m", "K", K);
            s_m = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_m");
            pos__ = 0;
            size_t s_m_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_m_limit_0__; ++i_0__) {
                s_m[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 95;
            current_statement_begin__ = 96;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 97;
            current_statement_begin__ = 98;
            current_statement_begin__ = 99;
            current_statement_begin__ = 100;
            current_statement_begin__ = 101;
            current_statement_begin__ = 102;
            current_statement_begin__ = 103;
            current_statement_begin__ = 104;
            check_greater_or_equal(function__,"tau",tau,0);
            current_statement_begin__ = 105;
            current_statement_begin__ = 106;
            current_statement_begin__ = 107;
            // initialize data variables
            current_statement_begin__ = 111;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            stan::math::fill(A,DUMMY_VAR__);

            current_statement_begin__ = 112;
            stan::math::assign(A, get_changepoint_matrix(t,t_change,T,S, pstream__));

            // validate transformed data
            current_statement_begin__ = 111;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 116;
            ++num_params_r__;
            current_statement_begin__ = 117;
            ++num_params_r__;
            current_statement_begin__ = 118;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 119;
            ++num_params_r__;
            current_statement_begin__ = 120;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_db8febf10f23d7fa27a62fbcfd7f17b2() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            local_scalar_t__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<local_scalar_t__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            local_scalar_t__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<local_scalar_t__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(trend[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: trend" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(Y[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Y" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_m[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_m" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_a[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_a" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // model body

            current_statement_begin__ = 149;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 150;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 151;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 152;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
            current_statement_begin__ = 153;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 156;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("trend");
        names__.push_back("Y");
        names__.push_back("beta_m");
        names__.push_back("beta_a");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(trend[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(Y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_m[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_a[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 stan_model;

module_nameGstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330module_filenameZstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.cp36-win_amd64.pydmodule_bytesB  MZ                @                                      	!L!This program cannot be run in DOS mode.

$       GG^&0&0&0
^
&0n{1&08x3&08x4&08x1&08x5&0x1 &0&1r'0x9&0x0&0x&0x2&0Rich&0                        PE  d	 y:#[         "                                         @         `                                   x    \y            @n           0 \  p
                    (
 (   
              
                          .text   W                        `.rdata                     @  @.data                        @  .pdata  @n     p   B             @  @.gfids  <                      @  @.tls    	                       @  _RDATA                        @  @.rsrc                          @  @.reloc  \   0                  @  B                                                                                                                                H(H
R 0 A   HR    H| HR     H
vR oR  *  H
 H( H(H
Q о A   HQ    H< HQ     H
Q Q   H
3 H(b H(H
%Q p A   H'Q    H H
Q     H
P P  j H
s H( H(
 ? WQ H(H(,
 ? ?P H(
 ^(P P H(
 U? GP H(H(
 5? O H(O W
 P H(
 
? > Wӏ
 P H(O XhO  P H(H
P   A   HP    HT H}P     H
fP _P   H
 H( H(H
O 蠼 A   HO    H HO     H
O O   H
 H(2 H(H
N @ A   HN    H HN     H
vN oN  : H
# H( H(H
h  WHh     H
K {h H( H(H
j 蠻 WHj     H
 sj H(R H( WHj     H
2 jj H( H(2  H
  H( H(H
g  WHg     H
{ g H( H(H
g к WHg     H
 g H( H(H
%i 萺 WH"i     H
[ i H(B H( H
  H( H(G H
 H( H('  
 j T
 f/
 v  "     
 ; TT
 f/
 v  "   H(H(Y H(H(g H(黔 + 雓 H(X H( 
  
 C H(܀
  H(H(
 _ H(H
  @SH HHHSH
q H3H
HJHH HH [HA HHH%+ HQH HHEH\$WH H HHH t
   H# HH\$0H _3HAHC HAH HH  H(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH(b @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ H HHH0[@SH HHHSH
 H3H
HJHH H HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0) HT$0   HC   HsH{rHH  H @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" HQ HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HHL$pH3\ L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtH H5 uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIH:5 uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H= HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v HG @H$   H3 L$   I[0Ik8IA^_^́aHI    H HH\$Hl$Ht$WAVAWH HrE3HLH(IDIH. HGAH+HHt6@ Ht
,Hq. HHH HGHH+HH;rM)IDHH\$@Hl$HHt$PH A_A^_%. @USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtHE B2   H  HIHP   Hp  	 HIHPH
= H^ HEH  ,+ HH + HIB/ HH + HI(/ HH * HH/ Hp  Hp   HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ HqR HL$  HIHP   Hp   Hf H  :* HH +* HIP. HH * HI6. HH ) HH. Hp  Hp   HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8
 H HD$ HQ HL$  HMHT$HHPHT$PLL$HI+HLHFI+HH;  HL$p H HM') HH ) HI=- HH ( HI#- HH! ( (HM* 3ۋHFH+HHt9D  Ht,HM* HHHM HHFH+HH;r̲)HM* H
 HMq( (HM* HD$PHL$HH+HHt<Ht,HM`* HL$HHHM HHD$PHL$HH+HH;rĲ)HM)* Hp  HL$p HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8) H HD$ HO HL$ " 3ۋH  IM+     HI9uHHH;r{  HMp
 H H   I' HH :' HI_+ HH  ' HIE+ HH ' HHZ HH( & LHUp/Hh H   & (H   ( HD$PHL$HH+HHtBHt,H   ( HL$HHH    HHD$PHL$HH+HH;r)H   x( Hp  HMph HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8y H HD$ HM HL$ r MtLD$XM+II H  H3 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H讪 HHHH\$@H0_H\$Ht$WH0HD$        IHf HHHH\$@HpHHt$HH0_@SH H HHt
    HH [@SH H   H HH [H% HL$UVWAVAWH0HD$ H\$pILHH HHqHt$hE3L>L~$ HH_H\$hL;L{# HL(L0L8L@LHLPLXL`LhI;t8HHRH! HH@HH HH@L~DD$`IH˛ H;t9HHRH' HH@HH HH@L{DD$`HHޚ HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP HW yI^I;^u3HIN͙ HI;FtHP H( yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H辫 yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP HH tHHH;t-IM轘 HH;tHP H yHHS@   IM萘 HI}H;tHP H tHH;   HIMY HH;tHP H赪 tHHS@HL$H͎ H|$PH\$HH+HHHL$0讦 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH\ IU(I莥 IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP H裩 yHHH;t*IO HH;tHP Hw yHHSX?IO IHH;tHP HI yHH;tHIO IWXH蓤 H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP H质 yI_I;_t/HIO* HI;GtHP H腨 yI_HS@IW@H蛌 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI處 HI;GtHP H yI_I;_t/HIOj HI;GtHP Hŧ yI_HSXIWXH H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3聛 HGHH;tiD  HS Hd { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3њ HGHH;tiD  HS H贙 { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   H" HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+I H_@H_HH_PHW(HtLG8L+IN H_(H_0H_8LGHT$0MHOM J HOa LGHT$0MHOM  HO@ H\$8H HH _@SH LHT$0MHM  HH [ @SH LHT$0MHM  HH [ H H@SH Hk HHt
    HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH H˹ HHt
   v HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH H˻ HHt
    HH [@SH H HHt
    HH [H(HIc HHy H(H% @SHPHD$ H H3HD$HHHHT$(H HHK HH : HD$@HrQHHL$(H=   r<t HAH;r H+Hss H'vf H HL$HH3 HP[H(HIs HH H(H% @SHPHD$ H~ H3HD$HHHHT$(H HHK HH( J HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vv H HL$HH3( HP[H(HI HH H(H% @SHPHD$ H"} H3HD$HHHHT$(H HHK" HH8 Z HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH38 HP[H(HI  HH H(H%ƾ @SHPHD$ H2| H3HD$HHHHT$(H/ HHK 2 HHH j HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3H HP[H(HI( HH H(H%ֽ @SHPHD$ HB{ H3HD$HHHHT$(H? HHK(B HHX z HD$@HrQHHL$(H=   r<tӿ HAH;rÿ H+Hs H'v H HL$HH3X HP[@SH Hۯ HHt
0    HH [H HH9 H\$WH H HHH t
(   HC HH\$0H _@SH HHHSH
 H3H
HJHH3 HL HHH [HY H@SH HC HHt
    HH [@SH H HHH贝 H HH [ K H(HQHI? HHU H(H%r @SH HHQHI
 HH HH H [H%1 H\$WH Hϵ HHH H7 Ht
0   H HH\$0H _23HHBHBH@SH HHRH;c HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+Ib HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iѹ WD$0Hl$@@tHT$HHtLD$XL+I袹 HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iq WD$0Hl$@@tHT$HHtLD$XL+IB HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Ia WD$0Hl$@@tHT$HHtLD$XL+I2 HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWH% HL$8Ht HT$@] LD$HHT$8L+I: H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWH腞 HL$8Ht HT$@0] LD$HHT$8L+I H\$`HP_@SH H HHt
    HH [H\$Ht$WH Hګ HH3HIPH*Ht:HSX_ HK`HH+KPHHLI?LHSP H{PH{XH{`HS8HtLCHL+I H{8H{@H{HHK Ht:HS(n_ HK0HH+K HHLI?LHS 虲 H{ H{(H{0HKHt)HS[ HSLCL+IW H{H{H{Ht$8H HH\$0H _@SH HYLHIHWN H;H [Hl$Ht$AVH0HHHQE3HIDt$ N H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHHt Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ M H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQH遇 @SH0HD$     HQ8H賍 HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI~ D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0L I?HHD$0H;t?HHtLGL+I L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H HHHIVI+H*HHHH?HH;s(9 2 + $  IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   H HH\$0H _@SH  HD$HHl H3H$p   HH      HL$P' H HL$`e HH HH  H$P  HL$PW HxrH H

 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8j H HD$ H- HL$ c H$p  H3 HĀ  [HL$WH@L8 HH
M8 IL
S8 LL+18 ILV8 M;s$K9<sIHH+
8 HL28 L;rH\$XHt$hM;~  H8 HpHH;HBHHt$`hH7 HHD$PHD$PH;sNH
7 HD$PH;w=H\$PH+HH;7 uH
7 = H~7 Ht;Hj7 HH
$H;j7 uH
Q7  HM7 Ht
HH>7 HH37 Hz    H
97 HD$`L
%7 H;sLHD$`L;wBH\$`I+HH;
7 u   H
6 8 H
6 L
6 HtGIH0H;
6 u   H
6  H
6 L
6 HtH1H
6 L
6 L6 HH
6 He6 Ht$hH\$XJH8H
6 KHHv6 H@_3H( HD$0HL$ H HD$(Hr HD$  HT$HL$WH@HD$ H\$hHD$X   H=5 H|$`   dHD$PWf5 3H5 LD$P H5 Wf5 LD$XH
5  H5 Hn5 H
HL$XH
5 HH5 H5 Wf5 f5 H5 H5 f5 H9u13HD$8H HD$0Hf HD$(H' HL$( HH\$hH@_H\$WH H4 3H
4 HH+HHt7D  HHtH H4 H
4 HHH+HH;rH4 HH   H4 H+HH;v H    H=   r<t HBH;rw H+Hsg H'vZ HH H
3 Wfd4 H=U4 H64 H   H64 H+HH;v H    H=   r<t HBH;r H+HsЫ H'vë HH H
X3 Wf3 H=3 H3 H   H3 H+HH;vu H    H=   r<tY HBH;rI H+Hs9 H'v, HHX H
2 Wf3 H=2 H2 H   H2 H+HH;vު H    H=   r<tª HBH;r H+Hs H'v HH H
*2 Wf?2 H=02 Ht}H2 H+HH;vR H    H=   r<t6 HAH;r& H+Hs H'v	 H8 WH=1 f1 H\$0H _L1 L91 u0Hi1 H1     HHl1 H1 H HHx1 I@IHH
1 H
1 HHO1 HH
}1 H
1 HHC1 HH11 H
r1 @SH HHHSH
! H3H
HJHH H HHH [@SH H IHHHA    HD$0H/ HL$0H;sdH/ HL$0H;wSH|$8H|$0H+HH;/ u   H
/ n H/ H/ HtHHH}/ H|$80H;w/ u   H
Y/ , HU/ Ht
HHF/ HHH8/ H [HA H@SH H( HHـu
   KHH [@SH@HD$ )t$0(HH/ HHH/ H;/ r
   HHL$PHt
(3HH(t$0H@[HH3H! HD$0HL$ H HD$(HV HD$  H\$ WH H7b H3HD$3LA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HAP  AO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3' H\$HH _KN  WN  cN  {N  N  N  N  !O  oN  N  N  N  N  N  N  N  N  N  O  
O  *O  3O  <O  EO  NO  UO   	
	
	
 	


	

@SH@eH%X   H)t$0(1
    )|$ (=L
 Hȋ
9*    f]5M
 f_5|R
 fYfX=`K
 ffT=K
 f\(|$ ((fY
H
 fY]K
 f\ff\fY* (frfYfpc((fY%H
 fY
H
 fX%I
 fX
BI
 fYfYfX%2K
 fX
J
 fY(t$0fYfX
L
 f\f^fY%K
 fX%J
 fYf_H@[H
)  =) foG
 H
) f) f @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH H8 HHـu
(   [HH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLHB' HH(H4' H;%' r
(   HHt$@Ht*H?HOXKHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^H& HH(Hq& H;b& r
(   HH|$`Ht&H(XKHNH_w H HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(HWf.z
uI H^H% HH(H% H;% r
(   HH|$XHt&H(XKHH_w H> HH>HH\$PHt$`(t$0H@_HIHII      AD$HD$I#I;w]HB HL$HD$I#I;wAB^XAAHJ HBAHYJY^A\AI      LAHB L@HA IYI@Y^@\@AVH0HD$ H\$HHt$PH|$XIHLHR$ HH(HD$ H;5$ r
(   HHt$@Ht*H?HK^OHH^H~ H] HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$XHt$`)t$0I(HH# HH(H# H;# r
(   HH|$PHt&H(^KHqwH_ H	 HH>HH\$XHt$`(t$0H@_AID$I      HD$I#I;w,HQ BD$HD$I#I;wB\ABHA H      HH@WH@HD$ H\$XHt$`)t$0I(HH" HH(H" H;u" r
(   HH|$PHt&H(\KHawH_ H HH>HH\$XHt$`(t$0H@_HIHII      AD$HD$I#I;wHHB @D$HD$I#I;w,YBXAAHBHJ @YBXAAI      LAHB L@HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH  HH(H  H;  r
(   !HHt$@Ht*H?HOYKHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHf.I:
 z
uHH^H  HH(H  H;  r
(   ]HH|$`Ht&H(YKHH_w Hu HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(Hf.
9
 z
uI H^H^ HH(HP H;A r
(   HH|$XHt&H(YKH-H_w H HH>HH\$PHt$`(t$0H@_HQIBD$HD$I#I      I;vH      HBB\AB@SH H HHـu
    ۸HH [@WH0HD$ H\$HHt$PHHH: HH H, H; r
    yHH|$@Ht%HKW
B
 HH_Hr HH>HH\$HHt$PH0_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH H~ HHـu
0   ۷HH [@SH HHHSH
Q H3H
HJHHÓ H HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3 H+` HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$H HHoHH$   Hp_^]H	H%^ @USVWAVHl$H  HD$PH%O H3HEpMA؋H   D$     H` HD$`HM9 D$    E3E3HT$hHL$` HD$`HcHHQ HD`HD$`HcHxT\   HL$h" H> HL$` HH> q HH' b Hȋǐ HH H HHδ 9 HȺ    HH  Hȋ HI HH HUPHL$`M HxrH H
Ú HL$(3HL$0HL$8HD$@D$HHT$0HL$@  H HD$(H
 HL$( @SH H   H HH [H%| @SH HHHSH
1 H3H
HJHH H HHH [E   Hx  HD$8HM H3H$`  DL$0HL$@ Hγ HL$P HH  H$@  HL$@} H$@  H$X  HC$@  HD$ L
 LD$0H H
 T HWHp  HD$0HXHpHUL H3H$`  AAH$  A|A@;|iHL$@~ HL HL$P
 Hȋ$  j H$@  HL$@} L$@  H$X  LC$@  Ht$ DË~H$`  H3m L$p  I[IsI_E  SVWH  HD$HHuK H3H$p  AHHHL$P} H߲ HL$`= HH . HH# HH  HH	 HHO  Hȋ_ H$P  HL$P{ H$P  H$h  HC$P  H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8  H1 HD$ H- HL$  @SH HHHSH
A H3H
HJHH H HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu((ի (
ޫ D$T$f (fYfYfYfXƫ fX
Ϋ fYfYfXΫ fX
֫ fYfYfX֫ fX
ޫ fYfYfXޫ fX
 fYfYfX fX
 fYfYfX fX(f^(( (
 D$T$f (fYfYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX(f^(H8W)t$ f/(vbW9
 
 
/1
 f/D$@   f.z$u" Q1
 X "   (t$ H8 X(t$ H8>
 
0
 f/D$@wHf.z uB 0
  "   (t$ H8(t$ H8H%J LD$@H Iq LD$@H 7q HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3 HV HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHM蛯 IwHu@HH^H^uHtFHHHH;t_LLMt3 IV HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHMȮ I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMHq H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHX*
 LqWMHHEIHEI~Ht3 HS HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHMsB L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;t\IHHt3߅ HQ HELuH}LE7HUHM LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHM B HM HM L$   I[(Is0I{8IA_A^]LWH   H
'
 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tH= Ht
HXP HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0; H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3 H+O HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHM I~H}@HH_uHt3q HN HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHMh I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM触 HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHM5 H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHX_#
 LqWMHHEIHEI~Ht3P HpL HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHMܥ LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHMC; LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM< HM~ L$   I[(Is0I{8IA_A^]LWH   H
.!
 f/   HA\I[3IsHq ICD$hH9rt"H
~ Ht
H0J HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0+ H$   HĀ   _@SH HHHSH
 H3H
HJHH| H4 HHH [AYAHAX@@@WH0HD$ H\$HHt$PHHH HH H H;} r
    HH|$@Ht&HCY
 (HdH_HAz HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HH?r HHGH+HH    HZ HHHM H;> rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDHx HH(Hj H;[ r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHM HMHM 8F HELELEHM HMLHUNL+t	H
 HMF LHEHMHMHULL+t	HY
 WD$PH}LHt3y HE HHD$PH}HL$PLt$X3L;t-jy HtHE HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$`& =
    HEH   L   LD$PHH    H9V~EH,&
 &
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3 x HtH;D HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$`Ԝ HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HU HD$@HD$`H|$HHFH;t'H;tH w Ht
HC HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM HL$@uv HL$Piv I_v HMTv HMIv HM?v HM5v L$`  I[0A(sA({IA_A^_^]@SH HHI(u HKu HH [H%u H\$Ht$WH@HY)t$0Hv H\$PHHHJ()|$ H(A HLGLCHLGIL+LtH
 H\$XH~(|$ v Ht$`(t$0H@_H	v HHIH%3u @WHPHD$ H\$hHt$pH0 H3HD$HHHD$@   3Ht$8@t$(DFH HL$(+ HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVH HH;HKHtdHA   HqHyrHHH<H;Cu
   H賅 HKHt(HA   HqHyrHHHT$(  R HC HD$@HrQHHL$(H=   r<tt HAH;rt H+Hst H'vt H HD$@   Ht$8D$( A
   H HL$( HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H HH;HKHtdHA   HqHyrHHH<H;Cu
   H} HKHt(HA   HqHyrHHHT$(   HC HL$(-S HL$HH3考 H\$hHt$pHP_H\$WH Hs HHHIr t
(   H賊 HH\$0H _Hh H@SH Hg HHt
   f HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHHr H\$0HHHJ= HLFLCHVLFIL+LtHT
 HFH\$8HGHF Ht$@HG HH _Ho HHt H\$WH HWo HHH^t t
(   HT HH\$0H _@SHPHD$ H, H3HD$HHHD$@   HD$8    D$( A   H# HL$(! HHHT$(PHD$@HrQHHL$(H=   r<tsq HAH;rcq H+HsSq H'vFq Hu HL$HH3 HP[HWH@H@HXHhHpIHHW@3HpVHHA LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
 l IPL+IIHL+IM;HCH;HCHL$(茨 LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
 <l IPL+IIHL+IM;HCH;HCHL$( LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+I7 H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xH
* H3Hp  I((Hǅh     Hǅ`      ƅP   A   HE HP  ) HHPH0  S\ HP  H@   H(k HH	 t H0  H0  Z LHHAPHH  HrSHH0  H=   r<t n HAH;rn H+Hs n H'vm H" HM0[ HǅH     Hǅ@      ƅ0   A H`  H0   H0  HM@ H(j HH6  HH  HrSHH0  H=   r<tVm HAH;rFm H+Hs6m H'v)m HX H0  HM08Y LHHAPHH  HrSHH0  H=   r<tl HAH;rl H+Hsl H'vl Hك HL$0OZ HǅH     Hǅ@      ƅ0   A H`  H0  軆 XH0  HL$@ H(i HH : HH  HrSHH0  H=   r<tl HAH;rk H+Hsk H'vk H	 H0  HL$0W LHHAPHH  HrSHH0  H=   r<tk HAH;rwk H+Hsgk H'vZk H艂 HHPHMW HMLi H   W H   2i H  eW H  i Hh  HrSHHP  H=   r<tj HAH;rj H+Hsj H'vj Hׁ Hp  H3Xz L$  I[A(sA({I]HUSWHHH  HD$ )p)xHL% H3Hp  ((HHǅh     3H`  @P  DGH HP  o HǅH     H@  @0  E3H H0  ? HKHH0  P HH  HrSHH0  H=   r<ti HAH;rzi H+Hsji H'v]i H茀 H0   W HP  H@  l H(f HH ! HKHH0  PHM0V HǅH     H@  ƅ0   A H`  H0  ' H0  HM@ H(f HHX 諽 HH  HrSHH0  H=   r<txh HAH;rhh H+HsXh H'vKh Hz HKHHU0PHL$0U HǅH     H@  ƅ0   A H`  H0  R XH0  HL$@ H(8e HH Ѽ HH  HrSHH0  H=   r<tg HAH;rg H+Hs~g H'vqg H~ HKHHT$0PHǅH     H@  ƅ0   E3H H0  袂 HKHH0  P HH  HrTHH0  H=   r<tf HAH;rf H+Hsf H'vf H} HMS HMd H   R H   d H  R H  d Hh  HrSHHP  H=   r<tDf HAH;r4f H+Hs$f H'vf HF} Hp  H3u ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHHS HHqHt$`3H.HnHcڅt3d H0 HH^HwHt$`H.HnHt3d H0 HH^Ho(Hw0Ht$`H.HnHt3Td Ht0 HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHHR HHrHyH|$hE3L'LgHt3c H/ HHwLu HsHt$hL&LfMt3c I/ HLvHE(HC(L}8Ls0Lt$hM&MfMt3hc I/ IM~HUH% HUH HU0I
 HH\$pHl$xH0A_A^A\_^H\$WH HHHH HC(HSHOHG( HS0HO0 H\$0HH _@UVWATAUAVAWHpHD$ H$   H H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHn4 HcH;U|H
 _ EL9e#  IIf     HD$@   Ld$8D$( A   H HL$(F~ IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH萦 HwHtoHF   LfH~rHH  H{sLCItHH_ 	HHL#HCHFHCHFHC   H{LcrH HG HL$H@ HL$(@ AIcH;]}/H
 p] H
 b] H
z ] AH9u   I HD$@   Ld$8D$( A   H HL$(&| IIFH+HH;vJHLHT$(HL$H HH5 HL$H? HL$(? HcH;]zH
ѕ \ HL$hH3o H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHH: HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;ICw HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;IC HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC7 HSHt
HHH
HB   H
d Z H
V Z LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC蚕 HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
 [Y H
 MY HL$VWATAVAWH0HD$ H\$hHl$xHcLH[ II~@H|$pE3L'LgLgIHtIHHH;tHHHt3j[ H' HH_H_LHMI;~NL    
 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHYZ Mt
It& HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx HT H3HE`LHE3ADt$ HEX   LuP@}@EF H} HM@u IE HU@IPHEXHrPHHM@H=   r<tY HAH;rY H+HsY H'vY Hp Aމ\$$H9^H  ML=;Q HJ H
[ HL$@HT$PHMW |$ E3HT$XHL$@~W HD$@HcHHU HD@HD$@HcHhT<HD$XHD$0HL$XT L|$XLuDuHF@BHL$PEV A   EL9vP~S@ ff     H~@H^HIIH| HL$P谭 HU AIIcH;FP|Ë\$$|$ HU@HL$@D ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   HOo HD$@HcHHT HD@HD$@HcHhT<L=O L|$XHL$XP~ HL$XU HL$`U HMU É\$$IHcH;FH}$E3W W W W HM`H3>g L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0UV HKKV HKH [H%;V @SH HH   T H   HLcBADuluHT$0|T H [fT H   HLcBADuLt2H [H\$WH HH   HT$0O L   I HcHBDuT$0@:tIS 2H\$8H _ðH\$8H _@SH HHT$0H    L   I HcPBDt2H [L$0V tT$0HK H|$84 H   HT$0lS HHcQDu@fD  L$0=V u8L$0&V u)T$0_t$.tH   S H|$8H [T$0HK +4 H   HT$0R HHcQDtH|$8H [@SH HHT$0H   ֶ H   HHcPD
uT$0"tFyR H   HT$0蠶 H   HHcPD
uT$0't2CR HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33{T l$HlT ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @CQ Hv_H~HHfff     I   Q HHu2Hv&H~HHfI   P HHu2j@SH   HD$@H/ H3H$   HHL$0HA    HyrHH  H   HT$ P HHcQDuAL$ ?S uL$ @S T$ tHo1 H   H   !P HqHX H$   H37b HĠ   [@SH HyHHA    rHH  HT$0H   O HHcQDufL$0R uL$0R T$0t6H0 H   HT$0xO HHcQDtH*   H [H   ?O H   H [H   HD$0H H3H$   HL$ d H$   H3#a HĘ   @SH   HD$0)$   H7 H3H$   HHL$ ' (Wf.zu	HѸ (H$   H3` ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5v DH@ H   HUHP HHcJD   UH:7   HD847uAHu HEt
5	 5? HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKXa HS`HtHCXHH
HB  H   WM HvSHHHH   8M HvHu.Hv(HHHD  H   M HvHuE3Ht Ht` HKXHUHEH*   @2LsH{rHHD0HU@H   L HHcQDugH
     M@uO U@uB<:w2Hs,@H- H   HU@\L HHcQDt
H   /L @u<HC`H+CXHu,HEtHK@EHHUH$ HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKX` HS`HtHCXHH
HB%H;Chu   HKX_ HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5V BH;Chu   HKXm_ HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0J HLcBAD u!L$0tM uT$0H   vJ H   HT$8蝮 L   I HcHBDuT$8-tDI<J H   HT$8@2` H   HHcPD
uT$8+tJ @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(tI 2H0A^H\$HHT$@Ht$XH|$(语 I   HHcPD
uT$@)   NI IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@\ IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINp\ IVxHt:IFpHH
IFx   I;   u   INp\ IFxHtH0IFxkI;FPu	IN@\ IFHHt0IFHHHl$PI   HT$@' I   HHcPD
uT$@)t#G 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INp[ IVxHt7IFpHH
IFxI;   u   INp[ IFxHtL8IFxU@UH0HHT$@H   6 H   HHcPD
uT$@(tF 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   F HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMXZ HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMp)Z HUxHt:HEpHH
HEx   H;   u   HMpY HExHtL0HExtH;Ehu   HMXY HE`HtL0HHE`HHt$PH   HT$@U H   HHcPD
uT$@)t"D 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMpY HUxHt7HEpHH
HExH;   u   HMpX HExHtL8HExV@SH HHT$0H   f H   HHcPD
uT$0(t	D 2H [HT$0H|$@* H   HHcPD
uT$0)   C Ht$8HH   HT$0 H   HHcHDuT$0,tH   C Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKpW HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp-W HSxHt@HCpHH|$@H
HCxH [H;   u   HKpV HCxHtH8HCxH|$@H [H;   u   HKpV HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH   3 H   HHcPD
uU(tA 2H([]Ht$HHi AH|$PHH˄t
   AHe H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@ MM;~fHUHK@ EȉE;}HCpHUHCxH   / H   HHcPD
uU,t@ Ht$H2H|$PH([]ò.H~tAHh Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8 ,Ht'HrHUHEHKp ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp HMHHMH;v)Hh뒐HUHKps HEHHEH;s)H9`@UH0HHT$@H   v H   HHcPD
uT$@ct)? AHg HḦ́tH0]HH0]AHb Ḧ́t
H0]AHf Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@Q HUHHt%HE@
H;EPu	HM@Q HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@YQ HUHHt%HE@
H;EPu	HM@6Q HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@ Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+I5O H{pH{xH   HSXHtLChL+I
O H{XH{`H{hHS@HtLCPL+I8> H{@H{HH{PHK C HH\$0H _1 @SH0H3HQ D$ IE3HHC   HC@[ HH0[@SH0HD$     HQpH HH0[@SH0HD$     HQ@H  HH0[@SH0HD$     HQXH HH0[@SH   HD$@H H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H   E L   I HcHBD   T$ <tI:    -H   Hi   HǄ$      HǄ$       D$pA   Hb HL$pnX HD$pH$   HCD$pH
D HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   ; HO6 HD$PA;  HEb HL$P 2H$   H34L H   [HUATAUAVAWHl$H  HEHXHpHx H5 H3HEpHLHMH) HLiLl$03I} I}躐 IE M|$L|$0I?I蠐 II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIg HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	9
 uH;s3H;t.LuLEIƅ LH HD$ LHT$0I H\$0HK@HT$8: HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  HQ HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  HP HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  HP HT$hHtLD$xL+I8 WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$ HHT$8 HM HT$PHtLD$`L+IH HT$8HtLD$HL+IG HT$hHtLD$xL+IG WD$hH|$xHUHQLEL+IG <7 7 7 7 7 y7 r7 k7 d7 ]7 V7 O7 H7 A7 HMIHMpH3F L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+IF H{H{ H{(HHtLCL+I5 H;H{H{H\$0H _H\$WH HQ3HHtLA(L+IXF H{H{ H{(HHtLCL+I4F H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0# H[ HL$@؊ Ht3HwH[ HL$@辊 H;sHY HL$@訊 HH;rH[ HL$@菊 HH2 HH[ t HT$0HHD$0HcHH1 HD0HD$0HcHhT,H, HD$HHL$H[ HL$H%3 HL$Pb2 H$   3 HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tHHHt33 H LHD$(Lt$(H\$0H\$8HH~AL    M
& HIH;u(WHHH;|HMH;|HL$P! HY HL$` Ht3HnAHL$`"1 H;sHW HL$`贈 HH;rHY HL$`蛈 HH0 HHW 耈 HH0 HHzY e HT$PIHD$PHcHH/ HDPHD$PHcHhTLH* HD$hHL$hY HL$h1 HL$pS0 H$   1 I2 IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   H H3H$  ILHH$   LL$83ۉ\$0HHYMt3{1 H HH~D$0   HǄ$      H$   Ƅ$    A   EHHX H$   M HǄ$      H$   Ƅ$    EGH#X H$   NM HǄ$      H$   Ƅ$    EGHW H$   M HHL$`aHD$ L$   L$   H$   IuZHT$`HtLD$pL+IIA WD$`H\$pH$   HrTHH$   H=   r<t1 HAH;r1 H+Hs0 H'v0 HH HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t0 HAH;r0 H+Hsy0 H'vl0 HG HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t0 HAH;r0 H+Hs/ H'v/ HG HǄ$      H$   Ƅ$    A
   HU H$   'K IL$   HT$xIPH$   HrTHH$   H=   r<tk/ HAH;r[/ H+HsK/ H'v>/ HmF HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;vw. H    H=   r<t[. HAH;rK. H+Hs;. H'v.. H]E HH$  H3= H  A_A^_^[LSVWAVH  IǃXH H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFHMT IpH HǄ$      L$   D$   EF
HS H$   H HǄ$      L$   D$   EFHS H$   H LHHL$H\HD$ L$   L$   H$   HUHT$HHtLD$XL+I< WD$HLt$XH$   HrTHH$   H=   r<tz, HAH;rj, H+HsZ, H'vM, H|C HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t+ HAH;r+ H+Hs+ H'v+ HB HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t~+ HAH;rn+ H+Hs^+ H'vQ+ HB HǄ$      L$   Ƅ$    A
   H_Q H$   F HL$   HT$xHPH$   HrTHH$   H=   r<t* HAH;r* H+Hs* H'v* HA HǄ$      L$   Ƅ$    DDHT$xHL$H迒 HHHHHHJHCHBHKHJHCHBHKHL$HM) HT$xHtL$   L+I: HH$  H39 H  A^_^[H   HD$`H H3H$   LHT$03DI          M;HsBIIcD$@HD$@I#I;uHa HD$(HO H
P  IWD  I;Ps8IHcf/w"HZa HD$(LHkO H
TP g HH$   H38 HĨ   H   HD$HH H3HD$xHT$ L褒 HL$xH38 HĈ   AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ DE AXA((yXA@^A(]\A(\YYAX(q
 K8W
 Ys ^C0\(у
 D\YDYCDX(DC藃
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hHx H3HD$0HHHT$(H% HHHA   3HqHyrHH@0IE3C Hs(Hs0s8s@C<Hf HHL$0H36 H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH H3Hp  DHH  f  LAHM HP  蜉 LM HH0  E LHHAP HH  HrSHH0  H=   r<t& HAH;r% H+Hs% H'v% H= HǅH     3H@  @0  Hh  HrSHHP  H=   r<t% HAH;ry% H+Hsi% H'v\% H< HǅH     H@  ƅ0   A&   HL H0  @ HH0  HP HH  HrSHH0  H=   r<t$ HAH;r$ H+Hs$ H'v$ H; HǅH     H@  ƅ0   E3HBD H0  ? HH0  HP HH  Hy  HH0  H=   r<t@$ HAH;r0$ H+Hs $ H'v$ HB; !  C  3A;  HǅH     H@  @0  DG9HK H0  6? HH0  HP HH  HrSHH0  H=   r<t# HAH;rr# H+Hsb# H'vU# H: HǅH     H@  ƅ0   A   H6K H0  > L0  H+K HP   LHHAP Hh  HrSHHP  H=   r<t" HAH;r" H+Hs" H'v" H9 Hǅh     H`  ƅP   HH  HrSHH0  H=   r<tM" HAH;r=" H+Hs-" H'v " HO9 Dv(WI*(Y0 H,ȉN,Y
 H,F0D+D+Dv4Hǅh     H`  ƅP   A9   HJ HP  $= HHP  HP HP    Hǅh     H`  ƅP   A/   H J HP  < HHP  HP HP    H0   HI H@  &v HȋV, HH0  HPHM0 HI HM@u HȋV4L HHU0HPHL$0} HI HL$@u HȋV0 HHT$0HPHǅh     H`  ƅP   E3H,@ HP  ; HHP  HP HP    HM HMP H    H   6 H  i H   Dv(DF,DN0N4~8N@AAF<Hp  H3/ L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   HH HH: HT$(HHT HHOHfHH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHI<K8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKHޘ,CHE3L%S fnHGLH(X^^Y% L9G~   X MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKHѓC8L|$ Lt$PHl$@H(_[ÍAC82H(_[H  @SH A Ho: HHHB HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLH5 IIv@H$   3H>H~Ht3 H  HH^ D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$H@ IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tH  Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@و H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx H H3HEPLLHEH   HE@    E0 A)   HD HM0J6 IHU0IPHEHHrPHHM0H=   r<t HAH;r H+Hs H'vr H1 HL$0 IF@HL$@    I9vH~:~D  I^@H9> HL$@+o Hu HHcI;FH|HU0HL$0  MHIAPHEHHrQHHM0H=   r<t HAH;r H+Hs H'v H0 HD$0HcHH HD0HD$0HcHhT,H HD$HHL$H? HL$HU HL$P HMH HMPH3( L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   H< HH)4 HT$(HH HHOHVHH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHI視K8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKH蟘,CHLOLH|$H %ƹ fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^Y# L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0j HKH#C8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A H5 HHHB HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pH H3HEHHE   3H}@}DG<H7? HM>1 HHUHP HEHrPHHMH=   r<t HAH;r H+Hss H'vf H, HE   H}E A   H> HM0 HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H, HE   H}E AC   Hy> HM 0 HHUHP HEHrPHHMH=   r<tu HAH;re H+HsU H'vH Hw+ HE   H}E A/   H2> HM/ HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H* HE   H}E A<   H< HM/ HHUHP HEHrPHHMH=   r<tW HAH;rG H+Hs7 H'v* HY* HE   H}E E3H2 HMv. HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H) HE   H}E E3H12 HM- HHUHP HM  HMH3" H\$hH|$pHP]LEK ECL$UVWHP  HD$0I[AAم+HJ HD$ L
I MCHP< H
!<  ̅/HI HD$ L
I L$  H=< H
;  ̅/HI HD$ L
I L$  H< H
; ^ fn\m
 9m
 ,;tCt
Ù-  HL$P  H$  HL$`bj H; HL$`!f HcHL$8{
 HL$`HcQHL$`HHPHL$`_ HH; e HȋE    HL$8-
 HHo; HL$`e HHu3
H HcHHHUU kdH
 HH); te H%; HL$`ce H$  HL$`i H$  HHT$PPH$     H$   2 H$x  HP  _^]H\$WH0ME3M@HMtHMHH      @ f     IcAD$PHD$PH#H;w)IM;r܋A(L
j: HˉD$ z H\$@H0_HtG MH2: HD$(H蝼 H\$Hl$Ht$ WH@I@H-I: MHIHHD$0LHl$(HH LH${ HGL
!: DC(H6: HHD$ 1} HOE3HOHtCHII      f     IcD$PHD$PI#I;wIL;rH\$XHl$`Ht$hH@_LHHZ HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt3%
 HE HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHM2 LvLu@II^I^uHtFHHHH;teLLMt3` I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHMG1 ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+t	h
 II^H\$XH    HC    HC    HtFHHHH;tdHHHt3 H( HH{H{LHSE3L9C~JL    
 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH@HD$0H\$pMHHHJs HHHGHFHHGLL+tf
 H^H\$hININ8 HHIFHCIFHCIIFIFLL+tf
 HWV(E3LGMtlHII      @ f     IcD$hHD$hI#I;w
IM;r#HdB HD$(LH5 H
5 艷 ̉T$ L
5 H
5 Qu MH5 HHH\$pH@A^_^H\$Ht$WH`HLHt5 HHHs3HD$ HGH;t'H;tH Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@v H\$xH$   H`_H\$Hl$VWAVH`HLH4 HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH Ht
H HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@hu L\$`I[(Ik0IA^_^N`H\$UVWHHpHcy(3H)t$`WuH9yt"H	 Ht
H HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM+ Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tH Mt
I HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHM* H$   Hp_^]s^HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t]LLMt3h I HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHM+ WEIHEIHt3 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHM* LEHUIHM! HM IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t[LLMt3H Ih HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHM* WEIHEIHt3 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHM8* LEHUIHM HM  IL$   I[8Is@IA_A^A\_]H\$UVWATAWHHpB(L
- DA(LHD$ H- H
W- _ I3IHEHFH;t'H;tHv  Ht
H HHH~LHEHEHHELELNHEHE0HEIHHuH+HHHH~!D  HE(A)HH;}LEMHMXn MgH~IGHOM HELeI;uL9tqMt"MtHHIL;   HGL$   MMHL;tH}
 Mt
I HHL$   LgLHGHUHHEHUHUHUHU0HUHMLGLH}IHH+HHHH~"    HE()HH;}HMHMLm H$   HHpA_A\_^]0XH\$Ht$H|$ UHHpB(L
+ DA(HHD$ H+ H
+ ] LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHM HFHOLFHUL	HEHAHEHUHUHUHULELMLQLHUIHMHH+HHH~*    A(fAXA)HH;}
LELMMHMH^ L\$pHI[Is I{(I]H\$UVWHHpB(L
* DA(HHD$ H* H
[* V\ H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM HOHM(LFLEHFHEL	LMHAHEHELQLQHEHEHEHE HEHE(HEIHH+HHH~1@ ff     A(fA^A)HH;}
LELMMHMH H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM辺 LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMH( HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM^ HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHM˴ HH\$xH`]H\$Ht$WHPeH%X   Hd    )t$@HЋ9X    HcF(3HfnY5 ~nHFHl$`Hn)|$0=k H4   D)D$ EWf     HH(TfA.zt	YU
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
 
 = Dff H
 X Yo / V
 HHPUWAVHhH   HEHXHp MHH3}׋A(D$ L
# M@H
3% c DINHthIII      fff     IcEgHEgI#I;w
IL;r#HF0 HD$(MH$ H
$ k HFHELuEEHuH;H{LvMt3
 I2 HLsHUHM HHE7HvHCH;t'H;tH
 Ht
H HH;HsLLEHEHEHEHEHEgHEH]LKIHH+HHHH~+fD  HE7HM(fXA)HH;}LEMHM HM'<
 HL$   I[0Is8IA^_]@SH HHI
 HH [H%
 HT$WH0HD$(H\$@HHD$     IHHH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHGHFHHGLL+tQ
 H^H\$HHOHO I HHHGHCHG HCHWHGHG LL+tQ
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHHHK
 Hx
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IrHHHO$
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IbHHGHO
 H
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3^
 I~ HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHMK HwHu@HH^uMt3
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHM Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ) HHIFHFIIFLL+tN
 InH~H$   3HH_WD$(Ht3
 Hν HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$H IFF HHpA^_^][HL$VWAVH@HD$0H\$pILHHJ HHIFHCIIFLL+t\M
 H{H|$hHNͼ HHHFHGHHFLL+t&M
 INK HCHD$ L
J DH H
 _ E3AHSII      HtULfD  HcAD$hHD$hI#I;w
HH;r&H( HD$(LLH H
  HOHtSH     IcD$hHD$hI#I;w
IL;r#H( HD$(LH H
> 詝 HH\$pH@A^_^H\$Ht$H|$ AVHpA L
	 LBHH
K D$ L7[ I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHD$0HFH;t'H;tH
 Ht
H׺ HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~  HD$0()HH;}HL$@HL$P\ L\$pI[Is I{(IA^H& MH HD$(H

   H\$Ht$H|$ AVHpA L
 LBHH
 D$ LY I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHHD$0HFH;t'H;tH8
 Ht
HS HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~HD$0()HH;}HL$@HL$P[ L\$pI[Is I{(IA^Hz% MH0 HD$(H
 蟚 H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	,
 Ht
HG HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHM Hcw HuH9wt"H
 Ht
H袷 HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHMh (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H誶 HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHM WEHHE'H~Ht3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHM LEHUI4HM1
 HM&
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 Hڴ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHME WEHHE'H~Ht3
 H, HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM LEHUIwHMt
 HMi
 IL$   I[(Is0IA^_]H\$Ht$UWAVHHpB L
 DA LHD$ H H
} PF I3I~HEHFH;t'H;tH
 Ht
H HHH~LHEHEHHELELNHEHE HEIHHuH+HHHH~ HE(A)HH;}LEMHMT IFH~MvHEHGI;t'L;tH9
 Mt
IT HHLwHHEHEHEHEHE HEHMLGIH}HH+HHHH~&fff     HE()HH;}HMHMT L\$pHI[(Is0IA^_]H\$Ht$H|$ UHHpB L
_ DA HHD$ Hb H
 D LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHMѡ LOLGHNHEHEHEHEHEHEHMLMLEM@IHH+HHH~,ff     (fAXA)HH;}
HMLMHHMR L\$pHI[Is I{(I]H\$UVWHHpB L
 DA HHD$ H
 H
 FC H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM豣 HGHE(HUHNHUHUHUHU HML HUHU(LELHIHUHH+HHH~% A(f^A)HH;}
HMLEMHMH/ H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHMΡ LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHMK HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM~ HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM HH\$xH`]HHPVWAVH   HD$hHXHh )pMHH3|$0I@HD$ L
 DA HG H
 CO DIVHteIII      Ic$   H$   I#I;w
IL;r#H HD$(MHO
 H
 Í H;H{HnHt3
 H被 HHkIH$   HFH$   HH$   HvH;t'H;tH:
 Ht
HU HH;HsHHD$8HD$8HD$HH$   HD$PH$   HD$XH\$`HkHHH+HHHH~MH$   (4H$   ()D$pHL$p';H$   (fYfXHD$8)4HH;|LHHL$Hq	 HL$   I[0Ik8A(sIA^_^HT$WH0HD$(H\$@HHD$     IHHH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+tM:
 H_H\$HHN辩 HHHFHCHVHFLL+t:
 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHH$HK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHOT
 HK
 HH\$@H0_HG  @SH0HD$     HQHs  HH0[H\$WH HHQHtLAL+I  3HCHCHCHS H@t
    H HH\$0H _@SH HQHHt.LAL+I>  3HCHCHCH HH [H HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXH
 D$(HD$0HT$83HL$ HD$8HD$@H	 HD$ 
 H^ H\ HD$0HL$0 H\$WH HHQ HtLA0L+I8  3HC HC(HC0H H@t
8   HU HH\$0H _@SH HQ HHt.LA0L+I  3HC HC(HC0Hy HH [Hi HH [@SH HHHSH
 H3H
HJHH
 HL HHH [HAHH`HAHH`H\$WH Ho HHAH荹  H HGHt
8   HE HH\$0H _@SH H HHAH3  H| HCHH [@SUVWATAUAVAWHxHD$(H H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HH HHHL$ Hc HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ H
 HIFHAIFHAIFHAH IV   H HHNط  L-! L.H IGIO躷  MoM/H  I  IV HtMF0L+I  3IF IF(IF0M.HHL$`H3 HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+I  H{pH{xH   HK8]  HS HtLC0L+I  H{ H{(H{0H HH\$0H _H\$WH H,   t
  H HH\$0H _H\$Ht$WH H  HHt*L  L+IO  3H  H  H  H5 H   H  HKpH=N HKPH{@q  Hs@HKHs8H{\  HsH3H\$0Ht$8H _HL$SH0HD$ HHc HLALD$HH I HBI@HIHHA   HA    HyrHH  IE3  HH0[HL$WH0HD$ H\$PHHH HHBHAHBHAHBHAH H 蓭  HO8HL$HH HHC@HAHCHHAHCPHAHSXH   HSpHOpL  HH\$PH0_@SH HHI HtCHS(| LC0H*L+C IHLI?LHS   3HC HC(HC0H HH [H\$WH Ht
   HR HH\$0H _H\$WH H<t
8   H HH\$0H _H\$Ht$WH HHHHu
 ' HH ' HH?
 ~' HHW+ HH- 
 Hg
 HS' HH  D' HH6
 5' WPHX
 HHn- 
 HE
 H	' HH  & HH
 & HH
 HH&- H
 H-
 H& HH_  & HH
 & WH
 HH, 
 O|tttt3   H#
 HW& HH  H& HH
 9& Hȋ
 HHt, 
 O|  [  	  H
 H% HH % HH
 %    H4
 HH
, ,
 H
 H% HHk % HHh
 %    H
 HH+ 
 H
 HY% HH/ J% HHd
 ;%    H
 HHr+ 
 H
 H
% HH $ HHH
 $    HP
 HH&+ H
 H
 H$ HH $ HHt
 $    H
 HH* 
 Ho
 Hs$ HHi d$ HHn
 U$    H
 HH* 
    tB  H
 H$ HH' $ HH,
 # H   H
 H# HH # HH
 # H W  L   H> H
 H# HH # HHK
 r#    H
 HH) 
           H H"# HH8 # HHE # HH " HH;) ]
 L   H> L   H> L   HHN !> L   H2? L   HH <= L   Hm? L   HH< < #  H HS" HHi D" HH
 5" HH &" HHl( 
 L   H= L   H(> L   HH R= L   Hc> L   HH m< L   H> j  H
 H! HH ! HH
 |! H   H%
 Ha! HH R! HH
 C!    H
 HHz' 
 H
 H! HHS ! HH
      H
 HH-' O
 H
 H  HH   HHK
      H
 HH& 
 L   H; H
 Hm  HH ^  HH
 O    H
 HH& 
 H
 H  HH   HH2
     HH
 HH6& X
 Hu
 H HHO  HH
     H
 HH% 
 H
 H HH u HH
 f    H
 HH% 
 H2
 H6 HH ' HH1
     H_
 HHM% o
 H
 H HH  HH
     H
 HH$ !
 H
 H HHX  HH
 |    H
 HH$ 
          tB  Hj
 H& HH  HH9
  HQ   H	
 H HH  HH
  H l  H
 H HH  HHg
  HH  HH# 
 L   HH 8   H
 HM HH > HHx
 /   H
 HHf# 
    tzt?   H
 H HH  HH
  H jHv
 H HH  HH
  H 4H@
 H| HHj m HH
 ^ H? HO H" H
 y tIH H* HH   HH  HHWX0  HHF" h
     tLH H HH  HHS  HH    HH! 
 H H HH } HHG n WxH
 HH! 
 H^
 HB HH! H\$0Ht$8H _H%
 H%
 @WHPHD$ H\$hH H3HD$HHHD$@   3H|$8@|$(E3Hy HL$(1  HT$(H胲  HD$@HrQHHL$(H=   r<t
 HAH;rt
 H+Hsd
 H'vW
 H H   H   H  HHL$HH3 H\$hHP_@UVWATAUAVAWHl$H   HEH$   H H3HEA؉]HLHUE    A}NH
 HE3HEHEH HEEHUHM
 H HEHA HM H    HB    HB    E   HE   HE    E A   H HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtH
 ^
 u
HJ  H{rHHA   I;LBMtH #
 u
H  H{rHHA   I;LBMtH 
 uDHu>LFIH+HgfffffffHHHH?H  IHT  HF   H{H{rHH?A   I;LBMtH8 Hn
    Hs	3Hu{A^HE   HE    EIE3HUHM  ]HUH~  HM財  3IV(HEH;tIE3HM  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHMB  DmHUH2~  HM  HEHrPHHMH=   r<t[
 HAH;rK
 H+Hs;
 H'v.
 H] HNH	
 HE3HEHEH HEEHUHMf
 H HEH= HMa HMH3 H$   Hİ   A_A^A]A\_^]  @SH HH(  HKH [  @UVWATAUAVAWH$@H  HD$8H$  HU{ H3H   MHHL$@  HHPHH HL$P HH }H HL$P n  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<H HL$P HHS HH^ y HHD$ T׼
 HL$(Lt$ I+IHHLI?LAxcIcH<HLfK4H HL$P HH@ HH  HBT7 c
 Md$HAxLt$ H HL$P HH 4
 HL$ Ht2HT$(f HL$0H+L$ IHHLI?LHT$   HU`HL$@葪  H0 tSHEX   HEP    E@ A	   HS HM@  LE@HU`H   Ex  H: H    H0 tSHEX   HEP    E@ A   H HM@K  LE@HU`H   Fv  HG2 H   9 Hz0 tSHEX   HEP    E@ A
   H HM@  LE@HU`H   Gt  HH3 H    H[0 tSHEX   HEP    E@ A
   Hf HM@  LE@HU`H   Hr  H< H   { H<0 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 HͿ HE@H
? HM@ H0 tXHE`H}xHCE`H
W
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H7 HM@ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ T
 H HE@H= HM@O H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 HѬ HE@Hf3 HM@ H/ tXHE`H}xHCE`H
+
 HM@3HMHHMPHD$ D$(HUHHL$ 
 HM HE@H:6 HM@ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ (
 H HE@H7 HM@# Hd/ tXHE`H}xHCE`H
c
 HM@3HMHHMPHD$ D$(HUHHL$ ĸ
 Hͧ HE@Hz2 HM@ H@/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ `
 HQ HE@H^3 HM@[ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@Hr6 HM@ HEX   HEP    E@ A   H HM@  LE@HU`H   l  Hz4 H    HL$WH0HD$ H\$HHHH
 HHQ3HHBHKA
 H) HHSHOHA   HA    HyrHH  IE30  HH\$HH0_HL$WH0HD$ H\$HHHHC
 HHQ3HHBHK
 H
 HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHK!
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_@SH HHHSH
1
 H3H
HJHH
 HT HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHKQ
 Hq HHSHOHA   HA    HyrHH  IE3@  HH\$HH0_@SH HHHSH
a
 H3H
HJHHӴ
 H HHH [@SH HHHSH
!
 H3H
HJHH
 H, HHH [@SH HHHSH
 H3H
HJHHS
 H\ HHH [@SH HHHSH
 H3H
HJHH
 H HHH [HL$WH0HD$ H\$HHHHS
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH HO HHH>  H
 HOH
 t
8   H HH\$0H _H\$WH H
 HHHޓ  H_
 HOHJ
 t
8   H HH\$0H _H\$WH H/ HHH~  H
 HOH
 t
8   H0 HH\$0H _H\$WH Hg HHH  H
 HOH
 t
8   H HH\$0H _H\$WH Hǟ HHH辒  H?
 HOH*
 t
8   Hp HH\$0H _@SH0HD$ HH HH
 HA(H0ϱ
 H( HHKHtHP tHC    H0[@WH0HD$ H\$@HH HH~
 HA(H0h
 H HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH HH
 HA(H0
 HH HHKHtHP tHC    H0[@WH0HD$ H\$@HH0 HH
 HA(H0
 H HHKHtHP tHC    @t
@   H HH\$@H0_H\$WH HH HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   W L   H988L  M+IHLI?LI  3H   H   H  H   ؜  H   H [H%
 HL$SH0HD$ HHk HE3LAHH HLC0LC8LC@LCHLCPLCXLC`LChLCpL   L   L   L   L   L   L   L   L   L   L   L   L   L   L   L  L  H   HH0[LWATAUAVAWH@  Iǃ8I[Is A)sHVj H3H$   HHT$HHHL$PWD$p3ID$XHt$hS $   # _   Iǃp   Ih@$  DFH IX:  HǄ$     H$  @$  DFH H$    HǄ$     H$  @$   DFHE H$     HL$0HD$ L$  L$  H$   H/HT$0HtLD$@L+I  WD$0Ht$@H$  HrTHH$   H=   r<tѭ
 HAH;r
 H+Hs
 H'v
 H HǄ$     H$  Ƅ$    H$  HrTHH$  H=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 HU HǄ$     H$  Ƅ$   H$  HrTHH$  H=   r<tլ
 HAH;rŬ
 H+Hs
 H'v
 H Lc(A4$HǄ$     H$  Ƅ$   A   H H$    HL$  HT$0HP(HHD$pH;t*HH\$pHJHL$xHBH$   H2HrHrH\$pHT$0HtLD$@L+I;  WD$0Ht$@H$  @  A$  `   HǄ$     H$  Ƅ$   A   H[ H$  
  HǄ$     H$  Ƅ$    A   H\ H$     HǄ$     H$  Ƅ$   A   H H$    HL$0qHD$ L$  L$   H$  HHT$0HtLD$@L+IϺ  WD$0Ht$@H$  $  H$     H$    H\$Ps,HǄ$     H$  Ƅ$   A   Hc H$    HL$  HT$0HP(HHL$p6  HT$0HtLD$@L+Ik  WD$0Ht$@H$  p  HD$pK, a   E$H% H
 UHǄ$     H$  Ƅ$   A   H, H$    HǄ$     H$  Ƅ$    A   Hu H$     HǄ$     H$  Ƅ$   A   H& H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Ht$@H$  5  H$   '  H$    E$H H
 W$  Ic$WD$0Ht$@L$  HL$0һ  L{0L$   HT$0I詄  HT$0HtLD$@L+I.  HǄ$     H$  Ƅ$   A   H H$  x  HL$  HT$0HPHHL$X4  HT$0HtLD$@L+I蹷  WD$0Ht$@H$    LMc$LHt$XA   IrmIHHPLL+AH+MSIIN4    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sIJHJIHIM;r b   E$H& H
 VHǄ$     E3L$  D$  EFH, H$    HǄ$     L$  D$   EFH{ H$     HǄ$     L$  D$  EFH* H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  9  H$   +  H$    E$H H
 $  Ic$WD$0Lt$@L$  HL$0ٸ  HsHHT$0H踁  HT$0HtLD$@L+I=  HǄ$     L$  Ƅ$   A   H H$    HL$  HT$0HPHHL$XC  HT$0HtLD$@L+Iȴ  WD$0Lt$@H$    MMc$MLt$XIrrHHHPML+IH+MSIIN<    M@      IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r c   E$H6 H
 fHǄ$     E3L$  D$  EFH< H$  /  HǄ$     L$  D$   EFH H$     HǄ$     L$  D$  EFH: H$  ž  Ic$HL$0HD$ L$  L$   H$  H HT$0HtLD$@L+I  WD$0Lt$@H$  I  H$   ;  H$  -  E$H H
 &$  Ic$WD$0Lt$@L$  HL$0  Hs`HT$0H~  HT$0HtLD$@L+IM  L$  L$  E33H$    A   HR H$  葽  HL$  HT$0HPHHL$XM~  HT$0HtLD$@L+Iұ  WD$0Lt$@H$  '  MMc$MLt$XIrlHHHPML+IH+MSIIN<    MfD  IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r d   E3L$  L$  E33H$  踵  EFH H$  P  L$  L$  E33H$   }  EFH H$     L$  L$  E33H$  B  EFHO H$  ڻ  HL$0HD$ L$  L$   H$  H9HT$0HtLD$@L+I
  WD$0Lt$@H$  b  H$   T  H$  F  DsxL$  L$  E33H$  耴  A   H H$    HL$  HT$0HP(HHL$prv  HT$0HtLD$@L+I觞  WD$0Lt$@H$  ~  HD$pD DCx e   H' H
( L$  L$  E33H$    A   Hd H$  W  L$  L$  E33H$   脳  A   H H$     L$  L$  E33H$  G  A   HR H$  ݹ  HcSxHL$0HD$ L$  L$   H$  H8HT$0HtLD$@L+I  WD$0Lt$@H$  a}  H$   S}  H$  E}  DCxH H
 >
$  HcSxWD$0Lt$@L$  HL$0  L   L$   HT$0Iy  HT$0HtLD$@L+IZ  L$  L$  E33H$    A   H; H$  螸  HL$  HT$0HPHHL$XZy  HT$0HtLD$@L+I߬  WD$0Lt$@H$  4|  Lc[xE3Ht$XIrlIHHPLL+IH+MSIIN4    MfD  IDHBIHIDHBHIDHHR IuH|$HH\$PM;sIJHJIHIM;r f   E$HV H
' DC,H H
 oE3L$  L$  E33H$  蚰  EGH? H$  2  L$  L$  E33H$   _  EGH H$     L$  L$  E33H$  $  EGH1 H$  輶  LcC,Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0L|$@H$  <z  H$   .z  H$   z  E$H H
 
DC,H H
 
$  HcS,WD$0L|$@L$  HL$0ŭ  Ic$W$  L$  LD$0H$  蚞  L   H$  Ic  H$  &c  HT$0HtLD$@L+I  L$  L$  E33H$  蘮  A   H H$  .  HL$  HT$0HPHHL$Xu  HT$0HtLD$@L+Io  WD$0L|$@H$  x  MLck,MM   Lt$X@      LcC(IIr{I$LHP0M^O˾   H+IXHHH<    LfHJICJHJICJH
IJI7HICJM[ HR`HuH\$PE3I;s(M$HHL+IKJIHRIuIM;?H|$H8
 g   Lk,EE HM H
j L$  L$  E33H$    A   HN H$  艳  L$  L$  E33H$   趬  A   H H$   L  L$  L$  E33H$  y  A   H H$    IcU HL$0 HD$ L$  L$   H$  HjHT$0HtLD$@L+I>  WD$0L|$@H$  v  H$   v  H$  wv  EE H H
 pIcU W$  H$  C\  H$  H   H   H$  H   ϕ
 L$  L$  E33H$  U  A   H H$    HL$  HT$0HPHHL$Xr  HT$0HtLD$@L+I,  WD$0L|$@H$  u  MMc] MHt$XIrvH   HHPLL+Ȼ   H+MSIIN4    Mff     IDHBIHIDHBH;IDHHR IuH|$HH\$PM;sH   JHJIHIM;r1
 h   L$  L$  E33H$    A   H H$  蝰  L$  L$  E33H$   ʩ  A   H H$   `  L$  L$  E33H$  荩  A   H H$  #  HL$0HD$ L$  L$   H$  H肽HT$0HtLD$@L+IV  WD$0L|$@H$  s  H$   s  H$  s  L   M<$L$  L$  E33H$  ¨  A   H
 H$  X  HL$  HT$0HPHHL$Xp  HT$0HtLD$@L+I虣  WD$0L|$@H$  r  HD$XHI$@ i   L$  L$  E33H$    A   H H$  謮  L$  L$  E33H$   ٧  A   H, H$   o  L$  L$  E33H$  蜧  A   H H$  2  HL$0HD$ L$  L$   H$  H葻HT$0HtLD$@L+Ie  WD$0L|$@H$  q  H$   q  H$  q  D   L$  L$  E33H$  զ  A   H( H$  k  HL$  HT$0HP(HHL$ph  HT$0HtLD$@L+I  WD$0L|$@H$  q  HD$p   R j   EE Hk H
  L$  L$  E33H$    A   H H$  觬  L$  L$  E33H$   ԥ  A   H7 H$   j  L$  L$  E33H$  藥  H H$    IcU HL$0$HD$ L$  L$   H$  H莹HL$0SV  H$  o  H$   o  H$  o  EE H: H
w $  IcU L$  HL$0l  H   HHal  HL$0U  H0 H$  p  HL$  HT$0HPHHL$Xl  HL$0U  H$  o  Mc] E3Lt$XIroHHHPML+Ȼ   H+MSIIN<    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sLKHKIHIM;r k   EE H H
/ fH_ H$  o  H H$   }o  H H$  ho  IcU HL$0HD$ L$  L$   H$  H胷HL$0HT  H$  m  H$   m  H$  m  EE H/ H
p $  IcU L$  HL$0j  H   HHVj  HL$0S  H) H$  n  HL$HHL$  HT$0PHHL$Xj  HL$0S  H$  
m  E3Mc] E3Ht$XIrjHHHPLL+A   L+MSIIN4    MfD  JD
HBJ
HJD
HBHJD
J9HR IuH\$PM;sHJHJIHIM;r `   D$H   LL$HM}  h   D$H    LL$HMn  o   H{(DH H
 HsxDH H
ѯ  $  HcL$  H$   ?i  HcLHL$0>W  H   HHU  HL$0RU  H$   R  H$   H   p   Ht$ LL$   H$   H$  U HH H$  T  H\$PHC    HCHCHC  v   DH H
޾ HcHHCU  x   EE Hn H
 IcE HCHL$X4Q  HL$pYM  H$   H3	 L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH Hru HH3H   H*HtNH  @4 L   HH  I+HHLI?LIc  H   H  H  H   Ht(L   L+Io  H   H   H   H   Ht(L   L+I;  H   H   H   H   A
 H   HtNH   q3 L   HH   I+HHLI?LI蔆  H   H   H   H   Ht(L   L+I蠙  H   H   H   HS`HtLCpL+Ir  H{`H{hH{pHSHHtLCXL+IM  H{HH{PH{XHS0HtLC@L+I(  H{0H{8H{@H= HKHH\$0Ht$8H _:  @SVWATAUAVAWH  HǄ$  )$  HC H3H$p  LL$8MLHIHL$`,b  IHL$xJ  ( $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGH^ H$0  董  IH$0  IPH$H  HrTHH$0  H=   r<tև
 HAH;rƇ
 H+Hs
 H'v
 H؞ tiH
 H$   3H$   H$   Hĺ HD$8D$@H$   HL$8υ
 HX H$   HA H$   © HǄ$     H$   Ƅ$   A   HB H$  u  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+I脖  W$0  H$@  H$  HrTHH$  H=   r<tL
 HAH;r<
 H+Hs,
 H'v
 HN HǄ$     H$  Ƅ$   A   He H$  X  HǄ$h     H$`  Ƅ$P   A   H H$P  !  HǄ$     H$   Ƅ$   A   H H$    H$0  輴HD$ L$  L$P  H$  IFH$0  Ht(L$@  L+I  W$0  H$@  H$  cd  H$P  Ud  H$  Gd  D$0HT$0HL$`_  HǄ$     H$  Ƅ$   A   HЧ H$    IH$  IPH$  c  tiHP
 H$   3H$   H$   H׷ HD$8D$@H$   HL$8
 H# H$   H H$   荦 HǄ$     H$  Ƅ$   A   H	 H$  @  IL$  H$0  IPHHL$H_  H$0  Ht(L$@  L+Ix  W$0  H$@  H$  b  HǄ$     H$   Ƅ$   A   H H$  衞  HǄ$h     H$`  Ƅ$P   A   H3 H$P  j  HǄ$     H$  Ƅ$   A   H0 H$  3  H$0  HD$ L$  L$P  H$  I菫H$0  Ht(L$@  L+I]  W$0  H$@  H$  a  H$P  a  H$  a  HD$H D$0HT$0HL$`\  HǄ$     H$  Ƅ$   A   H  H$  K  IH$  IPH$  a  tiH
 H$   3H$   H$   HS HD$8D$@H$   HL$8
 Hg} H$   HP
 H$   ѣ HǄ$     H$  Ƅ$   A   HY H$  脜  IL$  H$0  IPHHL$H=]  H$0  Ht(L$@  L+I輐  W$0  H$@  H$  `  HDFxH H
γ HǄ$     H$   $  A   H١ H$  ̛  HǄ$h     H$`  Ƅ$P   A   Hj H$P  蕛  HǄ$     H$  Ƅ$   A   H[ H$  ^  HcVxH$0  LHD$ L$  L$P  H$  I趨H$0  Ht(L$@  L+I脏  W$0  H$@  H$  ^  H$P  ^  H$  ^  Wt$0HcVxW$0  H$@  LD$0H$0  脒  L$0  9Vx~*ILD$H@      IH[HHI;Vx|;^x}HcIHL$`Y  HǄ$     H$  Ƅ$   A	   H H$    IH$  IPH$  ]  tiHP
 H$   3H$   H$   H_ HD$8D$@H$   HL$8|
 H#z H$   H
 H$   荠 HǄ$     H$  Ƅ$   A	   H H$  @  IL$  H$  IPHHL$HY  H$  Ht(L$   L+Ix  W$  H$   H$  \  H$   H$(  E33H$    A   H H$  蛘  H$`  H$h  E33H$P  ȑ  A	   H H$P  ^  H$  H$  E33H$  苑  A   H H$  !  H$  HD$ L$  L$P  H$  I}H$  Ht(L$   L+IK  W$  H$   H$  [  H$P  [  H$  ~[  HD$H D$0LD$0(HL$`
.  H$   H$(  E33H$  蚐  A   H
 H$  0  IH$  IPH$  Z  tiHy
 H$   3H$   H$  HЯ HD$8D$@H$   HL$8y
 HLw H$   H5
 H$   趝 H$   H$(  E33H$  ͏  A   H@ H$  c  IL$  H$  IPHHL$HW  H$  Ht(L$   L+I蛊  W$  H$   H$  Y  HDF,Hh H
 H$`  H$h  E33H$P    A   H H$P  褕  H$  H$  E33H$  ю  A   HD H$  g  H$   H$(  E33H$  蔎  A   H' H$  *  HcV,H$  HD$ L$P  L$  H$  I肢H$  Ht(L$   L+IP  W$  H$   H$  X  H$  X  H$P  X  t$0HcV,W$  H$   LD$0H$  S  L$  L|$H9V,~$Ifff     IH[HHI;V,|;^,}HcIHL$`bS  HT$`HL$8P  HT$xI19  MtL$   M+IIT  MtL$@  M+II7  H$@  HtH+HLjw  MtLD$XM+II   HL$`*  H$p  H3赇 ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xH2 H3HEH3HI  HE   3Hu@uDFH HMߒ  HCHMH;sTHHUH;wHH}H+H;CuVH譇  HH;HKHtcHA   HqHyrHHH;H;Cu
   Hj  HKHt'HA   HqHyrHHHU  
  HC HEHrPHHMH=   r<tv
 HAH;rv
 H+Hsyv
 H'vlv
 H蛍 HE   HuE A   Hz HM赑  HCHMH;sVHHUH;wJH}H+H;Cu
   H聆  HH;HKHtcHA   HqHyrHHH;H;Cu
   H>  HKHt'HA   HqHyrHHHU  ޖ  HC HMT  HE   HuE A   H HMڐ  HUHI  HMT  HE   HuE A	   H> HM蝐  HUHI  HMvT  HE   HuE A   H9 HM`  HUHI  HM9T  HE   HuE A   HX HM#  HUHFI  HMS  HE   HuE A   H HM  HUH	I  HMS  HE   HuE A   H HM詏  HUHH  HMS  HE   HuE A   H HMl  HUHH  HMES  HMH3虃 H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLH?  WEE3L}HMvK  HUH>  HMaK  HUH>  HMLK  Ic~xH} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
z 4o
 HQM+IIHHH+IMI;LCL;ICHM  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
 n
 HQM+IIHHH+IMI;LCL;ICHMZ  HMHtH9HHMHUHz=  HMI  HUHe=  HMI  Ic~,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
 m
 HQM+IIHHH+IMI;LCL;ICHMy  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
| 6m
 HQM+IIHHH+IMI;LCL;ICHM  HMHtH9HHMHUH<  HMxH  Ic~(H} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
 jl
 HQM+IIHH+II;LCL;ICHM+  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
2 k
 HQM+IIHH+II;LCL;ICHM譧  HMHtH9HHMHUH:  HM4G  Ic^(H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HMɀ  HMHtHHHMHUH9:  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM_  HMHEHt)HH H;Mu   HM5  HMHtHHHMHUH9  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HM  HMHtHHHMHUH9  HUHtLEL+IW}  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HE HXHpHx H( H3H   EELHHL$ Z  HL$8N  E3LmH  HL$0  HU(HL$ X  HILA  HE@HrQHHM(H=   r<tl
 HAH;rol
 H+Hs_l
 H'vRl
 H聃 HL$8趒  LmHg HL$01  HU(HL$ CX  HI@  HE@HrPHHM(H=   r<tk
 HAH;rk
 H+Hsk
 H'vk
 H    9sx   HL$8  LmHϞ HL$0  HȲ.  Hȋh
 HU(HL$ W  HI?  HE@Hr4HHM(H=   r uAHAH;s1H+Hr!H'wHO ;{x!gk
 j
 j
 j
 HL$8]  LmH HL$0ؿ  HU(HL$ V  HI^?  HM(J  9s,   f     HE@   Lm8E( HL$8  LmHM(I  H HL$0h  HȲ.~  Hȋg
 HU(HL$ eV  HI>  HM(I  ;{,~E  9s(|   @ HE@   Lm8E( HL$8f  LmHM(II  H~ HL$0ؾ  HȲ.  Hȋ3g
 HU(HL$ U  HII>  HM(H  ;{(~9s(|yHE@   Lm8E( HL$8  LmHM(H  H HL$0X  HȲ.n  Hȋf
 HU(HL$ UU  HI=  HM(H  ;{(~9s,|yHE@   Lm8E( HL$8f  LmHM(IH  H HL$0ؽ  HȲ.  Hȋ3f
 HU(HL$ T  HII=  HM(G  ;{,~{,|zfHE@   Lm8E( HL$8  LmHM(G  H HL$0X  HȲ.n  Hȋe
 HU(HL$ UT  HI<  HM(G  ;s,~HM_T  HMf
 H   H3w L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx H" H3H   LHHL$04U  HL$H  E3L}H HL$@a  HU0HL$0sS  HI;  HEHHrQHHM0H=   r<tg
 HAH;r
g
 H+Hsf
 H'vf
 H~ HL$HQ  L}H HL$@̻  HU0HL$0R  HIR;  HEHHrPHHM0H=   r<tf
 HAH;ruf
 H+Hsef
 H'vXf
 H}    9_x       HL$H覌  L}Hc HL$@!  HȲ.7  Hȋ|c
 HU0HL$0R  HI:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH| ;_x!ge
 e
 e
 e
 HL$H  L}H~ HL$@l  HU0HL$0~Q  HI9  HM0D  ,   @ ff     HEH   L}@E0 HL$H膋  L}HM0iD  HB HL$@  HȲ.  HȋSb
 HU0HL$0P  HIi9  HM0D  ;w,~     HMP  HMb
 H   H3Nt L$  I[ Is0I{8IA_A^]H\$WH H<t
  H{ HH\$0H _H\$Ht$WH H3H  Ht;H  $
 H  L   L+Iq  H  H  H   H  H*HtNH  
 L  HH  I+HHLI?LI6`  H  H  H  H  B  H  Ht(L  L+I6s  H  H  H  HKp   HKXHt)HS`6	 HSXLChL+Ip  H{XH{`H{hHK@Ht:HSHD HKPHH+K@HHLI?LHS@o_  H{@H{HH{PHS HtLC0L+Ir  H{ H{(H{0HSHtLCL+Ier  H{H{H{H\$0Ht$8H _H\$WH HHA  HOXA  LG8HT$0MHO8M )p  HO8@y LG(HT$0MHO(M p  HO(y HOH\$8H _<A  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hsl  HH_8H\$HH3HsT  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"   H  H]w HH [H\$Ht$WH H3H0  Ht;H8   H0  L@  L+Ijm  H0  H8  H@  H  Ht(L   L+I^  H  H  H   H  Ht(L  L+IRo  H  H   H  H  H*HtNH  ; L  HH  I+HHLI?LI[  H  H  H  H  Ht;H   H  L  L+IWl  H  H  H  H  HtNH   L  HH  I+HHLI?LI
[  H  H  H  H  Ht;H  P H  L  L+Ik  H  H  H  HKpHH\$0Ht$8H _HT$SH0HD$(H3D$ HHBHBD$    H  H  L  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H2  HH0[@SH0HD$     H  H2  HH0[H   HD$0LH0  L  HQpHD$ I  tWHzd
 HD$P3HD$XHD$`H2 HD$@D$HHT$XHL$@Z
 HYX HD$PHE
 HL$P~ 3HĈ   @USVWATAVAWH$ H  HEH H3H   EIHHHUH]E3Dd$4IHL$PS5  Lt$XL+t$PIL;vx   HMaI  H^xH HM蜰  HIX
 HHn 聰  HHX
 HHO f  H   HMvG  HxrH H
,c
 HL$h3HL$pHL$xHEEHT$pHMY
 H=^ HD$hHy
 HL$h} Dd$0H   H+   HWD$8Ld$HLD$0HL$8*  L'LgLgD$4   HNpLLD$8HT$PEt;    HT$8HtLD$HL+IY  WD$8Ld$HHT$PHtLD$`L+I?j  HHtLCL+I&j  L#LcLcHH   H3i H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH H3H   EEHHHUHL$H+3  Ht$PH+t$HHH;wx   HM9G  H_xHm HMt  HHV
 HHF Y  HHV
 HH' >  H   HMNE  HxrH H
a
 HL$h3HL$pHL$xHEEHT$pHMdW
 H\ HD$hHQ
 HL$h]{ 3t$`H   H+   HWD$0Ht$@LD$`HL$0  EuLHOpLD$0HT$HEt2  (HT$0H   LD$@L+IW  WL$0| WD$hHt$xHOpLL$hLD$0HT$HEt  
  (HT$hHtLD$xL+Ig  HT$0HtLD$@L+I#W  WD$0Ht$@HT$HHtLD$XL+Ig  HHtLCL+Ig  H3HsHs(H   H3Dg H$   ($  H  A_A^_^]@SVWH  HD$pHM H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   D  HxH^H+HHʋ H$   ͫ  HH!T
 HH 貫  HHT
 HH 藫  H$  H$   B  HxrH H
X^
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`T
 HfY HD$HH
 HL$Hx H   H+   HHL$H  HOpD$0D$(H\$ L HT$HHtLD$XL+IU  HH$  H3e Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E32HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK2WD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`HT$8HtLD$HL+IS  HL$`裌HL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xH~HHMp衣3T
 L   A   AA+iA+AD̉    AA+iD+EDD  H   HUpH  Q 3DL  L  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;r  H  H  (  H  H  4Q  H  H;H{H{H  H  H     (  H0  H8  H@  H|$ (     f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   H&d  HKHHt(HHH;Cu
   Hc  HCHtH8HCHH|$ (  H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hc  HHKHt,HH#H;Cu
   Hic  HCHtH HCH  H   L0  H  H    HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H H3HEHLHUHMm&  H]HLuI E3H;  HE   LeDeED$Hs HMk  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
 sL
 HSM+IIHL+IIM;HCH;HCHM豔  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
	 K
 HSM+IIHL+IIM;HCH;HCHM  H]Ht*HC   LcH{rHHHU  H>p  H H]HEHrPHHMH=   r<tN
 HAH;rN
 H+HsN
 H'vN
 He HUIE  M0  I  I  f  H]Ht HUH LEL+IH[  HHt'HV[ HLFL+I[  L&LfLfHMH3] L\$pI[@IsHIA_A^A\_]H\$L$WH0f.
 IH)t$ z	uA0LL$H \D$H菩	 (HCHL$Ht$HH;sEHHT$HH;w8H|$HH+HH;Cu
   Hf_  HSHt
HHH
HB$H;Cu
   H:_  HCHt0H(t$ HCH\$@H0_H\$WH HQ3HHtLA(L+I(L  H{H{ H{(HHtLCL+I\  H;H{H{H\$0H _Hy0HArH @SH H8 HHH+  HUT
 HKHH [H%:K
 H\$ WHpHG H3HD$`3HHAIHAHx8 HHL$@胰  HHL$ Ls  HHOL-   HD$8HrQHL$ HH=   r<tK
 HAH;rK
 H+HsK
 H'vK
 Hb HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tOK
 HAH;r?K
 H+Hs/K
 H'v"K
 HQb HHL$`H3Z H$   Hp_@SH HG HHHD*  HR
 HKHH [H%I
 H\$ WHpH H3HD$`3HHAIH4j HAH!G HHL$@  HHL$ Lܫ  HHOL Y  HD$8HrQHL$ HH=   r<t+J
 HAH;rJ
 H+HsJ
 H'vI
 H-a HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tI
 HAH;rI
 H+HsI
 H'vI
 H` HHL$`H3:Y H$   Hp_@SH HSF HHH(  H%Q
 HKHH [H%
H
 H\$ WHpH H3HD$`3HHAIHdh HAHE HHL$@L  HHL$ L<  HHOL} 蹭  HD$8HrQHL$ HH=   r<tH
 HAH;r{H
 H+HskH
 H'v^H
 H_ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tH
 HAH;rH
 H+HsG
 H'vG
 H_ HHL$`H3W H$   Hp_@SH H;P
 HHH'  HO
 HKHH [H%jF
 H\$ WHpHw H3HD$`3HHAIHf HAHO
 HHL$@謫  HHL$ L蜨  HHOLV|   HD$8HrQHL$ HH=   r<tF
 HAH;rF
 H+HsF
 H'vF
 H] HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<txF
 HAH;rhF
 H+HsXF
 H'vKF
 Hz] HHL$`H3U H$   Hp_@SH Hs< HHHd%  HM
 HKHH [H%D
 H\$ WHpH  H3HD$`3HHAIH4e HAH	< HHL$@  HHL$ L  HHOLz y  HD$8HrQHL$ HH=   r<tKE
 HAH;r;E
 H+Hs+E
 H'vE
 HM\ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tD
 HAH;rD
 H+HsD
 H'vD
 H[ HHL$`H3ZT H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuH6?  HKHL$@HHHHL$HHtC *H;KuH?  HKHL$@HL$HHt	H HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LHr  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH>  HwHtlHHHF   HF     HHHd  C F ;H;OuH>  H_Ht$HC   HHC    H c  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	F HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf	 HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI LGHVH pMt/HWIU HOH+IHHLI?LH=  HNH+IHHHH?HH>  tLHVH蜋 HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LH,=  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   H3=  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   H<  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+HS=
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+=
 H[HI~H+LH<
 Ht$0H;H|$8IFIH\$@H A^HtH=  HSIH+H>  t!HH[I>H+LH<
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I=  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
s 9
 HH|$0Xr  HHFHHHNI~IHH+LH;
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
hr "9
 q  HH    HGLH3HHOH_ H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXHC
 D$(HD$0HT$83HL$ HD$8HD$@H5j HD$ R:
 H+ H
 HD$0HL$0K^ HC
 D$(HD$0HT$83HL$ HD$8HD$@HD[ HD$ 9
 H, Hu
 HD$0HL$0] HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`HB
 D$(HD$0HT$83HL$ HD$8HD$@Hi HD$ :9
 H* H
 HD$0HL$03] H\$WH HHH;Qt>H	9
 HtH HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH HHHtLAL+II  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
Xo 6
 o  HL    HCHHIHKH LCHH\$0H _@SH L
 HL II+HH;sH+IH H [H;   L H+II+HH;s\IIH+H;sH
n R5
 HM+I3IHL+IM;HCH;HCFo  L
' L ILI+3HIL+I[ H
 HH+ HH+HH H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
m S4
 HM+I3IHL+IM;HCH;HCH4o  HOLH3H+HL+I%Z HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH:  HSHt7HHH
HCH\$0H _H;CuHy:  HKHtHHHCH\$0H _@SH HH	Ht@HS6 LCH*L+IHLI?LH\3  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LH2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
k 1
 HIh  HHCHHHHKLHVHT HCHH\$XHt$`H@_@SH 3HHHAHAe9  HH [H\$WH 3HHHHAHAHtNH
H;vH
Xj 1
 g  HHHCHHL    IHKH4 LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   H!9  HKHL$@HHHHL$HHtn
  /H;Ku
   H8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR蕂  HH@HH HH@HC    DD$@HHH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+IVA  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@H8| LHD$ HT$@HLH  HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHRu  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+IW?  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I?  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HJ  VH;Cu
   H>  HKHL$@HL$HHt03HA   HAHyrHH  IE3HJ  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
b )
 HM+I3IHL+IM;HCH;HCHq  HOHHH+HH+ HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LI9  HSHm HGH+HH   HCH+HL;w'HILHI  LCHWH~ LHtI HLCL+I9  HWH+HH<  tLHWH} HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+I9  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H;  HKHt@HH;H;Cu
   Ht;  HKHtHA   HHA      L  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I08  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
_ I&
 Hd  HHCHH;H{LHVH{ HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH:  HSHt3H
HCH\$0H _H;CuH:  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+I(  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   HU:  HSHt<HHH
HCH\$0H _H;Cu
   H:  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H%
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+%
 H[HI~H+LHg%
 Ht$0H;H|$8IFIH\$@H A^HtH6  HSIH+HN9  t!HH[I>H+LH	%
 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
[ "
 HH|$0\  HHFHHHNI~IHH+LHU$
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
([ !
 |[  HH    HGLH3HHOHG H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   H7  HSHt
HHH
HBHCH\$0H _H;Cu
   H6  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
Y  
 HM+I3IHL+IM;HCH;HCHD\  HOLH3H+HL+IUF HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+Il3  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH 3HHHAHAu6  HH [@SH0HE3HQ(DD$ HC   LCDD8tI IB< uH.>  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH=  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	f}	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ =  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
V d
 H;sLHH`g  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<tl 
 HAH;r\ 
 H+HsL 
 H'v? 
 Hn7 HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t
 HAH;r
 H+Hs
 H'v
 H6 HC   HC    H{rHH  HH@  HH\$@H0_@SH E3HA   LAHDD8tIIB< u:  HH [@SH HA   IHA    E3 H;  HH [H\$WH HH  HH
 tHCh    H\$0H _HH{hH\$0H _H%`
 @SH H    Ht'  tH   s
 y	H [3H [@SH HMH   Ht9HuMuEAE3/
 uH   D@HhB  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|?  tsH   HT$0
 u]HtH   D@H
 u@H   HT$0
 u*IFHHGt
?  HOtHD$0HCH    HKH
 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb>  tYHutH   DH
 u8H   HT$0
 u"H!>  HKtHD$0HGH    HOH
 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   
 tl  d  HE/   E3Lu'DuH   e
   HU'HHH  HZH  LM/L;sLHHM8a  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOhN
    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+3Z3  HUH}/r'HHu#E
     
 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   
 H~LEHU]#H
N 
 H
N 
 HUHE/HrPHH=   r=Et
 HBH;r
 H+Hs
 H'v
 HH/ HM7H3{( L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@
 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp H/
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   
 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKh
       HELELM/IICH}H+t.HMIICL   LǺ   
 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHM-3  3u#MH   N
 ;ELM/LELM/LEIrQIAH=   r=Et
 I@I;r
 L+Is
 I'v
 LI+ HM7H3|$ L$   I[0Is8IA^_]H   HtH%}
 H   HtH%e
 @SH0HD$ HH HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H9  HH0[H%
 @SH0HD$     HV;  HH0[H\$WH HhHHcPH H
hHhHcPH' DhD
dHAH9  HOY
 HOH\$0H _H%
 DL$ HL$SVWH0HD$ HHD$h    Hq HH_ HAH   6
 D$h   H^E3HH
 HHcHHC H1HHcHhT1H\$XHh
 H@
 HLGHrH?HCh    Cp    MtHHP^  HH0_^[DD$HL$WH0HD$ H\$HHD$P    H HH HAH   V
 D$P   E3HWH
 HHcPHf H:HHcPDhDD:   HOI;  HH\$HH0_@SH0HD$     H9  HH0[H\$WH HxHHcPH
 H
xHxHcPH DxD
tHAH7  HO
 HOH\$0H _H%|
 DD$HL$WH0HD$ H\$HHD$P    H) HH   
 D$P   E3E3HWH
 HHcPH
 H:HHcPDxDD:   HO9  HH\$HH0_@SMPHMLLA@I Ht
H9AhsHAhH
 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   H
 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjH

 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
H

 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIH~g	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI=5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH Hg
 HHHI	
 HO {	
 HO(q	
 H
 t
0   Hv! HH\$0H _H\$WH Ht
   HB! HH\$0H _H\$Ht$WH H'H
 @t   Hh  Ht$8HhH\$0H _H\$Ht$WH HH
 @t   Hx  Ht$8HxH\$0H _H\$WH H  HH/  H1
 t
x   HO  HH\$0H _H8HD$ HHHcHHLHHt+HHPH1H;uH   Ht
 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLH  H\$ HSH HHCI  H$   HVHM HHFI  HHGWD$8HD$H    I  Hl$(HT$8H  ILl$8I;^F  M  @ HI5  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtH* c	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  HV  HGH+HA(  MtwHD$HI+HH?H;vV
 H    H=   r=At9
 IEI;r)
 L+Is
 I'v
 LI8 HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
:  
 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
J9  
 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [H(H
L;v/
 K@HH=   r<t
 HBH;r
 H+Hs
 H'v
 HHH( @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
7 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _n5  H _H\$WH 3HHHHAHAHt:H
H;vH
h7 "	 4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
6 r	 H3  HHCHHHHKLHVHK HCHH\$XHt$`H@_H(H?L;v 
 J    H=   r<t 
 HBH;rs 
 H+Hsc 
 H'vV 
 HHH(~ H(LQLLAII+HH;s_H	I?L+III+H;sH
5 V	 L+II3IHL+IM;HCH;HCIH(C5  H(H\$WH 3HHHHAHAHt6H?H;vH
5 	 l4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHH,
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
X4 	 IHO uM  H    HHWHL$(HHO E7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wHT HH;_s%	 	 	 	 	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;v	 H    H=   r<t{	 HAH;rk	 H+Hs[	 H'vN	 H} 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
2 F	 L+II3IHL+IM;HCH;HCIH(#4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
1 	 L+HI3IHL+IM;HCH;HCIH(q4  H(@SH0WH        f I1  LH} HH{ HHH
x H谤 HIH
] H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
0 	 ".  HHCHL4    HIHKHMHH I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
0 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _4  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uH&  AE3'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AD  3ҋm%  AD$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH`   AE3S!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEu   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ=  AD`  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v?	 II   r<t&	 HBH;r	 H+Hs	 H'v	 HHH(!	 LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRB  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRWC  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@HS0  LD$PL;D$XuLHH\$HH0_H(HL;v	 J    H=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(LQLLAII+HH;s_H	IL+III+H;sH
$ 	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
h$ "	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
# 	 L+HI3IHL+IM;HCH;HCIH(#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
\# 	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
" 	 ,#  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH讕 HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
 " 	 T"  HLHCHHHHKLIa MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHAH;uH   Ht	 ҐH8@SH0HD$ H8	 u
Hb	 HHHcHHLHHt+HHPL
 I;uH   Ht@	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtHF	 HCHH=   r=@t	 HGH;r	 H+Hs	 H'v	 HH HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALH	 HHt8Ht!LIHE	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1ItE	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHHD	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ :0  H\$hH0A_A\^HKI;sH
 	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
 =	 L+H|$XH;s;HCHrHHHrHHMtHMJ HH	 LCIH+HHu	H   HvH
$ 	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HHR	 H{rHHHtJ LIB	 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH
+ 
	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JLW	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH
B 	 HvH
. 	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L` H{H{rHH8 Ht$8HH\$0H _̀: uE3   IIB< u    H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH
 f	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLHI?	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
 	 I+H;HGH;u9I8H9AsH
 	 HAHyrH	 3He   HvH
 -	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6L'>	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH
 Z	 H|$0I<H   HvH
 4	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
[ 	 H|$0I<0H   HvH
5 	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLH;	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
w Y	 LAH+H;HGIHH;wH
@ 	 H|$0I<0H   HvH
 	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.L:	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBIt	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpH
 H3HEHHyh   yq   du2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh6	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H2	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H
 t	 H
 f	 ̳IrNIAH=   r=Et	 HAH;r	 H+Hs	 H'v	 H HMH3\ L\$pI[(Is0IA^_]@SVWH AAq HHA|>	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXHRc HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHD	 HEHC| Cq j	 H
b HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   I|	 HtyA   HHHT$(H	 HG  HH+	 t
HCh    H{hH	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t5	 HAH;r%	 H+Hs	 H'v	 H7 HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPHg
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r	 H+Hs	 H'   }	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(|   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t	 HAH;r	 H+Hs	 H'v	 H HHL$HH3< H\$pHP_@WH0HD$ H\$HH!	 H
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;wn	  HH'HHAHH(H HH(H(I   r<tp	 HBH;r`	 H+HsP	 H'vC	 HHH(k Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;vo	 KHH=   r<tS	 HBH;rC	 H+Hs3	 H'v&	 HHH(N H(H88L;v	 KHH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(Hu	3ɋH(H88H;v	 HHH   r,HA'H;w	 HW HH'HHAHH(> HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH9" HH988LKHML+IHHLI?IHt+I~u HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;v	 HHH   r&HA'H;w	 H HX'HHC HHVLHHl$@Lt$Hd" HHgfffffffLNHML+ILIMI?MHt+Iu HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;v	 HRHH   r,HA'H;w	 H HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH! HH*LKHML+IHHLI?IHt+I>p HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt莍/H;Ku
   HhHKHL$@HL$HHt	H]HCH\$PH0_H(Hu	3ɋH(H?H;v	 H    H   r,HA'H;w`	 H HH'HHAHH( HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;v	 H    H   r,HA'H;w`	 H HH'HHAHH( HH(H\$WH HHu3UHH;v	 H    H   r&HA'H;w	 HC HX'HHC0 HHnR HLlR L+Ht$0^	 HOR H5PR H+HHtLER L+IHHR H'R HHt$0H\$8H
R H _H\$Ht$WH HHHu3UHH;v	 H    H   r&HA'H;w	 HK HX'HHC8 HHHLGL+Hl$0m	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+	 HH{H+HHtLCL+IHHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;v	 HRHH   r&HA'H;wt	 H HX'HHC HHVLHHl$@Lt$H HH*LNHML+ILIMI?MHt+In HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;v	 HH   r)HJ'H;wd	  HH'HHAHH(H HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;v	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H HoXHo`HohHO@Ht~HGPH?H+HH;v	 H    H=   r<td	 HAH;rT	 H+HsD	 H'v7	 Hf Ho@HoHHoPHO 聟HI HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;vW	 H    H=   r<t;	 HAH;r+	 H+Hs	 H'v	 H= HoXHo`HohHO@HttHGPH+HI;vڻ	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H Ho@HoHHoPHO ۚH HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHH HHWHH+Hta HLGL+IuHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
 
 	 THLHCHHHHKLId MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPL
 I;uH   Ht	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;w	 H
 Hp'HHF HH\$`Lt$pH|$hHt$xMtH{rHHMtMHa	 HCHrOHHH=   r<tz	 HAH;rj	 H+HsZ	 H'vM	 H| HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH
 	 IALd$XLd$pI;sH
 c	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH
,
 γ	 Ll$`L+L,9M;sBIvH

 	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HH
	 H~rH6H{rHHH6  J&LJ0,	 !  H;suHCHrHHHrHHHtJ!LJ0	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0*	 HCHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   Iv	 H|$0H   r#IH'H;wh	  Hx'HHGH HLHHO	 CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH
*
 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHHy HH*LKHML+IHHLI?IHt+IZ HKHH+HHLI?LHKHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H! 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   HH 3HC   H{HSrHH %  HxH\$0Hl$8Ht$@H _ŭ	 	 	 	 	 	 	 	 	 	 	 x	 q	 j	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   Hs 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH   HxH\$0Hl$8Ht$@H _	 	 	 	 y	 r	 k	 d	 ]	 V	 O	 H	 A	 :	 H(p   J HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL->
 Ht#HHPI;uH   Ht[	 ҐHHcH|1 uHL1PHtH;t+	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1H 	 tVHڅuVHHcHMIHL1H
	 I;u0D  H~/HHcHT1XHL1H	 u
Hջ   \$xHHcHHD1(    L-+
 Ht$p\$xLd$(HHcHHE3X	 	 u
I	 I$HcHJL!HHt#HHPI;uH   Ht	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%J
 Ht#HHPI;uH   Htg	 ҐHHcH|1 uHL1PHtH;t7	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1H	 ADމ$   HHHcHAHL1Hǣ	 ADމ$   u(H~#HHcHT1XHL1H	 ADHL%,
 Ht$p$   L|$(HHcHHD1(    HHcHHE3F	 ף	 u
I	 IHcHJL9HHt#HHPI;uH   Ht	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-#
 Ht#HHPI;uH   Ht@	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1H	 u   \$x7Hυu.I~rM6HHcHMIHL1H١	 I;t   +Ht*HHcHT1XHL1H	 uHՉ\$xHHcHHD1(    L-
 Ht$p\$xL|$(HHcHHE3*	 	 u
I	 IHcHJL9HHt#HHPI;uH   HtΣ	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHHu	 H	 Hp	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHH

 %H H;uIVHNH;HHQs	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HMڠ	 HHX
 sHH[H;uIFHMH	 HH	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PH ^
 H3HEpMMHHH   D$     H7
 HD$`HM	 D$    E3E3HT$hHL$`٠	 HD$`HcHH(
 HD`HD$`HcHDxDD\   HL$hHHL$`YHH
 JHH?HH
 0HI%HA	 HHHUPHL$``HxrH H
֩	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@3	 Hd
 HD$(H`
 HL$(, @SUVWHh  HD$8H\
 H3H$P  IHHDD$0$  D;   HL$@aH
 HL$@?HH4HH
 %Hȋ	 HHh
 H$0  HL$@YH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3q Hh  _^][H\$WH 	HHf/v\XH\$0H _\(~XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3ܞ	 Hj  HLsHsHuH{H|$hL?LHt3	 Hj  HHwHuH~H   H{(H|$hL?LHt3h	 Hj  HHwC< HHҙ  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H		 t
Hj  HH    Hk~LFHHIl H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3臾HC   HHC    H 艿HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHsH;uH   HtԜ	 Ґ3H	 D$0t/HHcHHLH	 u   |$`	H\$P|$`HHcHHE3	 HHcHHLHHt*HHPHH;uH   Ht9	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$h uB3HD$8H
 HD$0Hʖ
 HD$(H
 HD$@Hʼ
 HD$HHL$([P HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHH$x  ? t
HHÀ< uLHHIE3HH2HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLH}  HC   HHC    H ۼHH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
w  IE3HHGA
   HZ
 HHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHI蕹HC   HHC    H HH0[@WH   HD$ H$  AHHH$   P  HX(H
 HH0x8HH$   
N HHL$(N H
 HL$(褼 @SH   HD$PHT
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$(Z ȋD$ -ut=   w2t=w2ɄuB3HD$8Hָ
 HD$0H
 HD$(HN
 HD$@Hr
 HD$HHL$(L HL$pH3Ũ HĀ   [@SH   HS
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`2P u-HT$PHL$X/ t9C,+<:wH     HrD$PH$   H3 HĐ   [荗  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(  HL$UVWAVAWH   HD$8H$   IcIcHL3l$0HBH+HDDHD$   HLHI/IoIoMtBHt4HHHL;t̅tHHHL;tIHt3
	 H*b  IMwIH\$PLt$`IHL$@Lt$HHD$@HD$hHD$PHD$pH$   HD$xL$   IHHH+HHH~%     )HH;}H\$PHL$@LHHL$h IH$   HĐ   A_A^_^]HT$HL$SH   HD$0I譖  DKH{uH f/.6 w'D HHL$89  HT$PH{|  HL$8ה	 $       $      HL$`H$   LT$XL$   H$   H$   I;HMHE3L\$PW3H~N   If/sQHIH;|II|LHb
 H
 j  H$   '	 HL$p	 HL$P	 2C HĠ   [@SVWH`  HD$8HO
 H3H$P  IHLD$0Hc$  L;   HL$@褃H 
 HL$@HHwHH
 hHȋ͑	 HH
 NH$0  HL$@蜂H$0  H$H  HC$0  HD$ LD$0H
 H舙  H$P  H3跣 H`  _^[HUWATAVAWHl$H  HD$8HXHpHN
 H3HEpML3ۉ\$0A   MPM;  EWD  HE~2MNfHcI;}$IIIHf.z uHI;|AIIcI;U  H
 HD$PH
 HD$`HM^	 D$0   E3HT$hHL$P"	 HD$PHcHHi
 HDPHD$PHcHhTLHD$hHD$@HL$h	 H\
 HD$hH]Љ]H
 HL$`HHe
 HH
 qHH
 bHȍVƏ	 HH,
 GHAW	 HH
 +HUPHL$P=~LMPH}hLCMPMMcMFHcLOH
 HD$ H
 IN< HMpH3葡 L$  I[8Is@IA_A^A\_]@SUVWHh  HD$8HL
 H3H$P  IHHDD$0H$  D;   HL$@pH
 HL$@NHHCHH
 4HHP	 HHv
 H$0  HL$@gH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3 Hh  _^][H\$WH HIH	 HHHH[	 zHߍ	 HHH\$0H _H%̍	 H\$WH HIH-	 4HH)HH3	 He	 HHSH\$0H _H%j	 @SH H	 IHH1
 HH֬	 H"	 HHH [H%	 H\$WH HIH	 tHHiHH	 ZH	 HHH\$0H _H%	 @SH Ho	 IHH
 HH6	 HH	 HH6H [H%R	 @SH Ho	 IHHA
 HH	 H	 HHH [H%	 @SH H	 I[HH
 LHH	 =H	 HHvH [H%	 @SH H	 IHH
 HH	 H(	 HHH [H%2	 HHHD$0D$    L
<
 L
 36 2HHHHHD$0D$    L

 Lm
 3 2HHHHHD$0D$    L

 L-
 3 2HHHHHD$0D$    L

 L
 3v 2HHHHHD$0D$    L
\
 L
 36 2HHHHHD$0D$    L

 Lm
 3 2HHHHHD$0D$    L
T
 L-
 3 2HHHHHD$0D$    L
l
 L
 3v 2HHHHHD$0D$    L
4
 L
 36 2HHHHHD$0D$    L

 Lm
 3 2HHHHHD$0D$    L
ܪ
 L-
 3 2HHHHHD$0D$    L

 L
 3v 2HHHHHD$0D$    L

 L
 36 2HH{^  \  H\$H|$L	LLAH*M+HIE3HHHH?HtfE3K3KDH+HHt%f     IHHKDK+HH;rHKHH+IHIHHH?HL;rH\$H|$@SVWATAUAVAWH  HǄ$   HD
 H3H$   IL$   L$   H$   HL$hL$p  E3Dt$DD$@   EHq	 H
	 EE H	 H
	 zIcU H$  9cHcWD$pL$   LHL$p7H$  Ht(L$  L+I襘W$  L$  MHL$xLd$pI+I*IHHHHH?HH      tGIԐILHBI+HHt!ff     IHHBH+HH;rIHL;rMHtHIfILHBI+HHt!ff     IHHBH+HH;rIHL;rD$@   EE H	 H
	 IcU HL$PaILD$XIHT$PH+HHt#LIHLD$XIHT$PH+HH;rIL+IMtHHHD$XH+D$PHH;rD$@	   Dt$HEM DHT$HH$  谖  HHHH+IHHHH?HHT$0L=n
 L|$(LLo
 H
x
 p  IH;sH[HHI迗  HH$  e  D$@
   Dt$HEE HT$HH$    HH@H+HLL$XL+L$PIHD$0L|$(L
 H
 ap  IHD$XHL$PH+HHt4LLffAn AHM@HD$XHL$PH+HH;rH$  HtL$  L+IHL$PA   EH*L	 I      ?H$   D;8  D$@   E;u ,  IcH$   L HxI+H  G;  IcH$   HHxH+H  G;|  3DfA/D  D$@   H|$XH+H|!G;}LLD$@   AHL$PHHA
 H$   H*v
 H$   H$H  	 D$D   E3H$   H$   	 H$   HcHH
 H   H$   HcHh   H$   HD$hH$   
	 H{
 H$   3H$0  $8  HJ
 H$      Hg	 H$  H$   pL$  H$  LC$  H	 HD$ DËqH
 H$  Hu
 H$  H$H  ԁ	 D$D   E3H$  H$  	 H$  HcHH
 H  H$  HcHh  H$  HD$hH$  ~	 Hz
 H$  3H$0  $8  H"
 H$     H?	 H$  H$  nL$  H$  LC$  H4	 HD$ DƋIH
 H$  Hs
 H$  H$H  	 D$D   E3H$  H$  j	 H$  HcHH~
 H  H$  HcHh  H$  HD$hH$  }	 Hy
 H$  HǄ$0      Ǆ$8      H
 H$     H	 H$  H$  mL$  H$  LC$  H	 HD$ DËD$@   IcHL$xI+H*HHHLI?LLT$(D$    DH[HD$XH+D$PHMLM+LIHD$0H=p
 H|$(Lt
 H
}
 j  3ITIDH+HHt&LD$P IHHIDI+DHH;rAHL$PD$@   HT$pH|$hH軒  HT$PHt#LD$`L+I?WD$PHD$`    H\$pHt4HT$xH) H$   H+HHHLI?LH|HH$   H3謏 H  A_A^A]A\_^[Hl$Ht$H|$ AVH0LHT$ LH  LGH*L+HI3HHH?HtLH\$@     IHHH  HOHH+HHHHHH?HH;rH\$@Hl$HHt$PH|$XH0A^HWATAUAVAWHPH@HXHhHpMLHIPI$ I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8w  Hl$@LH\$8LIT$Ie  HtZHHy$ HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HH: HII HFH+HH;s(:}	 }	 }	 }	 }	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@Hl8
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`H		 H  3H  H  H	 HEpExH  HMpZ{	 Hx
 H  H H  O H{
 HE@H6y	 HEHHEPHEXHcy	 HE`HEhH<n
 HEH   Y  H  Y  H  j
   ~y   A   ~x DEHVXHzrHH   ҡE3HH   HcHH   uHAPx	 H3w	 F|uH	 H   H	 auH	 H   H	 @uH	 H   H	 u2H	 H   H	 HqHHx	 H    H   H膨      H   HzrHA   H  趠E3HH  HcHH  uHAPv	 H3v	 F|uH	 H  HH	 auH	 H  HO	 @uH	 H  HV	 u2H	 H  dHU	 HUHHw	 H   H  HjHǅ     E3L  D   EFH	 H   gHr
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  GH  HrSHH   H=   r<tty	 HAH;rdy	 H+HsTy	 H'vGy	 Hv L   HNHYHyrH	HA   I;LBMtH9	  u1Hu+Kl H   LF8HV(HCHH       HHst
 HH   WELuAEHUIZHKw
 HEWELuAN   D.DvDu~HH
k
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHI  DGHUHMHD$ IH  F  HOH*TH  Ht)L  L+I談W  Hǅ      HUHtLEL+I|H<v
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHIԐ  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHI  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHI{  DHUH   XHM1HQH}LL+s	 HH}H}8HO HUbMw8HUHtLEL+IH  HtL  L+IH}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMFHǅ     Hǅ      ƅ   A   H"	 H  蒏LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   蟵 LH  SH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHI芶  D    PHMmEA
   H`	 LuI蔎IN A   HS	 ~IN@A   HM	 hIN`A   HG	 RI   A   H>	 9Hǅ     Hǅ      ƅ   A   H	 H  LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H    LH  Q    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI%  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIy  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI蒺  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E?  Dq  d  PHM?A
   H	 LuIIN A
   H	 IN@A   H
	 ͈Hǅ     Hǅ      ƅp   A   HG	 Hp  藈LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H   褮 LHp  L          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIW  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ 1  D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ o  DLupEWA(WEHE    DEHUH+UHLEHM_B  HMH+M HLM L+MILɋ   ~gfn
	 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@?  G HOpH/7  H   HM?HD$ IH  蚀  HOH~CH  Ht)L  L+IvW  Hǅ      H   HtL0  L+IvH  HU>  H   H  RHǅ     Hǅ      ƅ   A   E3HA	 H   {HEHtTA   LH	 H   {LEI+LH  H   DHH  FH  wED   D   A   E3H	 H   Y{H  HHEL@A   H	 H   *{HLLEH  H   DHH  ]RH  DH   H  a	 A   LH(	 H   zHL@A   H$	 H   zLLGH   H   CHH  FH   YDH   H  a	 Hx  (QHx  b	 H}8H  H  H;tIE3H  AIP  HW  Hǅ      MX  H  } HU H W   Hǅ0      LEH    LM LEH(  H   K  H  H  <  H  H   ,7HOXHUp7MtI   IH   Ht&H(  H	 L0  L+IHKqH  Ht=H  H H  H+H*HHLI?LH`H  BH   BHUHtLEL+IsH}Ht HU H8	 LE(L+IHpH} HtHUH	 LEL+IH|pH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H	 Hp  }H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H   輣 HHEpHp  )AH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    u   I  DW   E3L0  L   H   H    H(  H   H+I*IHHHH?HHH  ;EL  L  M+IMt ff     HHKIHM;rH}8H  H   8  H  HU3H  H  8HOpH0  HU HM'HD$ IHMy  HOHi<HUHtLEL+IoWELuHU HtLEL+IoHMpHtH   H  HtL  L+IoH   Ht:H(  H H0  H+IHHLI?LH\E3H}HtH   HHUHtLEL+I!oWELuH5Q
 HuH]HtHH& LEL+IHlHW
 H@  HP  8>H@  Hx  KHx  \	 H  .  H   -  AH  H3Kn L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHH+$3fD  H;_s^I4H
 HHH
 H;
 r
   HH$   Ht
(貴HHHD$8HHMLD$8H$   H  H$   pH      ?HHH=r
 H

 H9
|
 t	HN
 $HH+B
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HIf8HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v\	 H    H=   r<tq\	 HAH;ra\	 H+HsQ\	 H'vD\	 Hss  (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH!3fD  H;_s^I4H
 HHH}
 H;n
 r
   ʪHH$   Ht
(bHHHD$8HHMLD$8H$   H  H$   pH      ?HHH="
 H
;
 H9
,
 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI6HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v=Z	 H    H=   r<t!Z	 HAH;rZ	 H+HsZ	 H'vY	 H#q ͩ (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
 U	 HL$8:  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   @HHL$@LD$8H$   Ht(H˯HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$89  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8-9  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH

 S	 H

 S	 MLD$8H$   I  H p HL$8Ht{HD$HH+HH;vW	 H    H=   r<tV	 HAH;rV	 H+HsV	 H'vV	 Hm WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
ϋ
 R	 HL$87  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   HHL$@LD$8H$   Ht(H蛬HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8{6  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$85  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
 P	 H
Չ
 P	 MLD$8H$   I  H p HL$8Ht{HD$HH+HH;vS	 H    H=   r<tS	 HAH;rS	 H+HsS	 H'vS	 Hj WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH L@HPHHSVWATAUAVAWH  Hǀh)p)xD)@D)HMH3H$   Hf.IU IEH+HHuZHZ	 HD$`3HD$hHD$pHˋ
 HD$xƄ$   HT$hHL$x&Q	 HN
 HD$`Hc
 HL$`i DD$  IEH+HHwZHYZ	 HD$`3HD$hHD$pHQ
 HD$xƄ$   HT$hHL$xP	 H5N
 HD$`H
 HL$` A   DJD$  W$   E3EL$   HFxHD$xLcL$   EL$   M_  IH$   @ IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   H$  H+HI;   IH+HH   H+HIH+H9  HL+IIHIH+IMI;LCL;ICH$   /L$   H$   IH$   L$   L$   H   HH   I;   IH+HHsxH+HIH+H   HL+IIHIH+IMI;LCL;ICH$   聈L$   H$   IL$   L$   Ht2HH$   IL$   M;s{-H
v
 0L	 H
h
 "L	 HW	 HD$`3HD$hHD$pH
 HD$xƄ$   HT$hHL$xM	 H~K
 HD$`H2
 HL$`8 IEI+E HL;rZH7W	 HD$`3HD$hHD$pH/
 HD$xƄ$   HT$hHL$xM	 HK
 HD$`HǇ
 HL$` IIIE ª (WX$   $   L$   L$   LcF,L$  E3AH$   H$   Mj  IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   L$  L+II;   IH+HH   H+HIIH+HO  HSL+IIHIH+IMI;LCL;ICH$   L$   L$   H$   H$   E3H$   L$  HtJHL$     I;   IH+HH   H+HIIH+H   HSL+IIHIH+IMI;LCL;ICH$   BL$   L$   H$   E3H$   L$  Ht3HH$   HH$   I;s{
H
6
 H	 H
(
 H	 HbT	 HD$`3HD$hHD$pHZ
 HD$xƄ$   HT$hHL$xJ	 H>H
 HD$`H
 HL$` H$  H;G   LH$  L;   L$  M+IHGH9Gu{H+GHHsmHOI+HIIH+HsH
R
 H	 HWI+HHLGM+IIHL+IIM;HCH;HCH轃HOHHt.JH%HGH9Gu
   HA]HGHtD HGH$  H;GsKHH$  H;w;L$  L+IHGH9Gu
   H\HOHHt.JH%HGH9Gu
   H\HGHtDHGE3ED9nx~7H$   Ld$xfIcHHA%AE;<$|H$  L$   H$   H;GsKHH$   H;w;L$   L+IHGH9Gu
   H$\HOHHt-JH$HGH9Gu
   H[HGHt8HGED9n,L$   ~$D  IcH    IHz$AD;~,|W$  HǄ$       W
 |   DF(Hl
 H
~
 HcV(HL$`#E3ALL$hIHT$`H+HI      Ht0L@ f     M<HLL$hIHT$`H+HH;rIL+IMtL<HHD$hH+D$`HH;r
 }   DF(Hl
 H
l
 5HcV(H$   "E3AL$   IH$   H+HHt4Lfff     M<HL$   IH$   H+HH;rIL+IMt+fff     L<HH$   H+$   HH;r޼
 ~   DF,Hz
 H
|
 oHcV,H$   ."3ɋL$   IL$   I+HHt0M    M<HL$   IL$   I+HH;rM+IMt.@ ff     M<HH$   H+$   HH;r
    DF,H7z
 H
{
 诶HcV,HL$xq!3DL$   IHT$xH+HHt N<IL$   IH+D$xHL;rHT$xL+IMt+@ ff     L<HH$   H+D$xHH;r㋆   uvg
    H   H   HV0LN(LL$@LNxLL$8HD$0HL$(HT$ L$   L$  H$  H$(    HHL$`W        
    H   H   HVHLF0LN(LL$HLNxLL$@HD$8HL$0HT$(LD$ L$   L$  H$  H$(    HHL$`aW  H$(  HtL$8  L+IUL$      H
x
 $  ;F,q  )
    LcHI+HH$  HL$(D$    EDĳL   L+   IH
Ox
 HL$(D$    E薳H   BtCYtL$   L+$   IH
zy
 HL$(D$    EQH$   Btp
    Hw
 HD$(D$    ED$  L   L+   IH
w
 HL$(D$    EH   BtCYtL$   L+D$xIH
x
 HL$(D$    E褲HD$xBt$  xA   =
 D;~(  
    IcLD$hL+D$`IH
\x
 HL$(D$    D;HD$`H$  H   Lv
 H  HH$  H$   H+$   HLIL+	IHD$0H"f
 HD$(Lf
 H
f
 Z-  H$  LAL+IH$   H	(Lv
 HH     HH$  H$   H+D$xHLIL+	IHD$0He
 HD$(Le
 H
e
 ,  H$  LAL+IHT$xH	cXH$  YtXL$   L+$   IH
e
 HL$(D$    DݰH$   tAK
    E3D8$     A;^(}HcHD$`HHA;^(}HcH$   HHAfD  ;^,}HcH$   HHtA;^,}HcHD$xHHTHT$x$   P  Ht%L$   L+ITQWD$xL$   H$   Ht(L$   L+I"QW$   L$   H$   Ht(L$   L+IPW$   L$   HT$`HtLD$pL+IPWD$`L|$pH$  Ht#ML+IPW$  L$   Mt&M+IMIiPW$   L$   H$   Ht&L+IMH6PW$   L$     Ht%L$   L+IPWD$xL$   H$   Ht(L$   L+IOW$   L$   H$   Ht(L$   L+IOW$   L$   HT$`HtLD$pL+InOH$  HtL+IMQOMtM+IMI9OH$   HtL+IMHOL$  A(sA({E(CE(KIA_A^A]A\_^[LWH`ICI[IsH H3HD$XHIK3t$ H1HqHqD$    HHD$P   Ht$H@t$8DFH	 HL$8YHD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHNHH;HKHthHA   HqHyrHHH@HCH9Cu
   HlNHKHt(HA   HqHyrHHHT$8  _HC HD$PHrQHHL$8H=   r<t=	 HAH;r=	 H+Hsx=	 H'vk=	 HT HHL$XH3M H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUH:L?LLE   HuHI?LuI;   HHM>HHMR| HHFHMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHS HI;{=<	 6<	 /<	 (<	 !<	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   H8HOHMPH[HHHMXHt2HGH9Gu
   H8HOHMPHMXHt
HUHGHMHtiHEH+HI;vE;	 H    H=   r<t);	 HAH;r;	 H+Hs	;	 H'v:	 H+R H   IHF  HMH+IHHHH?HH
H;v:	 HRHH=   r=@t:	 HFH;r:	 H+Hsq:	 H'vd:	 HHQ HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHHo  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   H9HSHt(H
H;Cu
   Hy9HCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H8HSHt(H
H;Cu
   H8HCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_H\$Ht$WH IHHH;t HHHHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HHTH H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`4	 H5R
 Ht$hH
N4	 4	 HHEH;xsHHHH   3ۀx$ t3	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8HV
 HD$0H,
 HD$(H HL$(xY H\$hH
 HHRHE HL$`83	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$P2	 H7
 HD$XH
C3	 3	 HHFH;xsHHHH   3ۀx$ t2	 H;xs
H@HHumH\$XHucHHL$X,2	 Hu13HD$8HU
 HD$0H+
 HD$(H HL$(dX H\$XH
 HHPHD HL$P$2	 HH\$`Ht$hH@_H\$WHPH H3HD$@HHD$8   HL$ HD$0    ID$  E3QHLD$ HWH( HHD$8H+HHrQHL$ HH=   r<t5	 HAH;r 5	 H+Hs4	 H'v4	 HL HHL$@H3D H\$`HP_H(Hu3H(HH;w*H\$ H    H3	 HuHuH\$ H(@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0诏 t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHRu  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHRe  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H	  HC+
 HCPH [HL$SH0HD$ HD$P    EtHfQ
 HA@H+
 HAPD$P   J   H30
 HHQ
 HCHC@HcHH0
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHHn9	 HHQ3HHBHK/	 He-
 HH{3HHDH^H\$HH2
 HHOHKHtHPHGHCHGHCG C H
 HHp3
 HHH\$PHt$XH0_H)
 HH@SH HHI0/	 HK /	 HH [H%/	 H'
 H@SH HH   H`HcPHn-
 HHHHHcPDHDDHh-	 HH [H%K.	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3LHo(Hs(H;t<HHRH]HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3KGxCxGyCyG|C|H   H   H;tIE3K                                                  HH\$HHl$PHt$XH0_H\$WH H  H='
 HGPt
X   HgE HH\$0H _@WH0HD$ H\$@HH
 HH6/
 HAHI HtHP tHC     H5	 HHK,	 @t
@   HD HH\$@H0_H	HtH   H k  HUHl$H  HD$8HXHxHP H3HEpIID$0    3A fAn	 f/rHHr   Hu/
 HD$PHa
 HD$`HM:+	 D$0   E3HT$hHL$P*	 HD$PHcHHE)
 HDPHD$PHcHhTLHD$hHD$@HL$h`(	 H8$
 HD$hHE    E    H=d
 HL$`cHL$`)	 HUPHL$PhHEPH}hHCEPHD$ L
%d
 LH;_
 H
^
   HMpH3; L$  I[I{I]HUHl$H  HD$8HXHxH H3HEpIID$0    3A	A;|HHr   H.
 HD$PH
 HD$`HM)	 D$0   E3HT$hHL$P)	 HD$PHcHH'
 HDPHD$PHcHhTLHD$hHD$@HL$h&	 H"
 HD$hHE    E    Hb
 HL$`HL$`S(	 HUPHL$PHEPH}hHCEPHD$ L
b
 LH]
 H
]
   HMpH3W: L$  I[I{I]H8MPE3MPMtYMH\$@HH|$0H      ff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8  @SH0HD$ HH
 HH+
 HAHI HtHP tHC     H1	 HHKH0[H%(	 LH   ICAC    HQHH
 ICHh"
 ICAC   IKH'
 HD$(HxH
 HD$@HD$hHcHHK(
 HDhHD$hHcHDd    H HL$(K @SH0HD$ HٹX   ; HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH&
 HHG
 HAHA@HcPH'
 HD
@HA@HcPDBDD
<HE
 HH)
 HAHI HtHP tHC     H0	 HHKH0[H%&	 @SH0HD$ HH
 HH-)
 HAHI HtHP tHC     H/	 HHKH0[H%&	 HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIv  HWH*  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHhq pMt/HWI  HOH+IHHLI?LH"HNH+IHHHH?HH#tLHVHp HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+HV7HH+HH4H+H;7HOHHLH+HH+O  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   7 HH$   LCMu	HKD
 
IP(HuIP0HL$(k!	 HǄ$      3H!	 HJ
 HHH  H>HL$(5!	    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
Y
 F 	 H;s/LHjHtH{HsrH3 H\$0Ht$8H _HsH;LƲLBZ8HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    HB$
 HH
 HAH   w!	 D$H   H_E3HH;!	 HHcHH
 H9HHcHHT9H\$PH	 H
 HC| Cq H	 Hǃ       H
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH 
 HH#
 HAHI HtHP tHC     H(*	 HHK!	 @t
@   HX9 HH\$@H0_H\$WH HHHUt
  H9 HH\$0H _@SH HH	 	 HKH [H% 	 LHXICLI@I+ HHQH;rQH[)	 IC3ICICHVZ
 ICD$0ISIK	 H@
 HD$8HY
 HL$8  HBHAI HX@SH HH	H   HS  HH*HSH+HHHH?HH
H;v 	 HRHH=   r<t 	 HAH;r 	 H+Hst 	 H'vg 	 H7 3HHCHCH [DD$HL$WH0HD$ H\$HHt$XHH3t$PHk?
 HA@H
 HAPD$P   OH7
 HHOH?
 HHG@HcPH
 HD:@HG@HcPDBDD:<HSHHDaYHH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H	q	 HtHHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
jT
 $	 L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HHaTHSLHH HH{H+HHtLCL+I.HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
(S
 	 H|$@K<H   HvH
S
 	 H9{s#HHcH   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0>	 H{rHHHtLHsx H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%	 HWAVAWH   HD$(HXHp HA H3H$   LLHL$ H	 HT$0I	 3IFIF IF(HT$`I	 H
;
 $  IFI	 HHHHǀ<8 uHǺ   H	 HHuM	 HHtHRHvHuIN I	 HHÀ< uHú   H	 HHu	 HHtff     HIHHuIV(fAF.,H$   H3* L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
P
 q	 LAI+H|$8H|$PH;HGIHH;wH
NP
 	 Ht$0I48H  HvH
(P
 	 H9qs H`H   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8a	 I;u>HKI?MIDHrHHHrHHHt8HL 	 *I~rM6H{rHHHtK>LHu H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HH HH0[@SH HHHSH
 	 H3H
HJHHc	 3HC HC(HC0H
 C8HH5
 HCHH [@SH0HD$     5 HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH
M
 {	 I4L+IIHH+I3I;HCH;HCHt$@HRLHD$8HD$0LHT$xHm HD$0LH$   H$   i HD$0LHWHL$xvm HWHHH+HHHt藽  HLGL+I%HIHwHIH_L7%IH>i HHWLHL$x H_H\$pHPA^_^@SUVWHx  HD$8H H3H$`  IIHHI@I+ HL;   HL$@oHP
 HL$PkHH	 HHOP
 kHH P
 kHHO
 tkHHzO
 ekH$@  HL$@sHCH+HHD$0H$@  H$X  HC$@  HD$ L
,P
 LD$0HH< H$`  H3% Hx  _^][@UVWHp  HD$8H$  H H3H$`  IHLL$0H$  H$  L;  HL$@HK
 HL$@rjHHgjH$@  HL$@H$0  WHK
 H$0  2jHHPK
 #jHHjHH~K
 	jHH]	 HHKK
 iH$   H$0  9H$   H$8  HC$   H$@  H$X  HC$@  HD$ L
E
 LD$0H軮 H$`  H3:$ H$  Hp  _^]Hx)t$`()|$PD)D$@D8
 D)L$0D
 fD/D)T$ EWA(r`A(\(o (\f/
e
 vAXfA.zu	 
  !      =D
 Y(o ^fA.ztf/5۶
 r
(q O
ߵ
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(萻 X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PH  H3HEpMMHHH   D$     H7
 HD$`HM	 D$    E3E3HT$hHL$`	 HD$`HcHH(	 HD`HD$`HcHDxDD\   HL$h;HHL$`YgHH1
 JgHH?gHH8
 0gHI%gHA	 HHgHUPHL$`` HxrH H
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@3	 H
 HD$(H  HL$(,4 @SH`W)t$Pf/D)D$0D(   u+DW?
 3A(W-
 (t$PD(D$0H`[
 fA/DW
 A(v(
i
 \((t$PD(D$0H`[3bX
 (t$PD(D$0H`[5I
 fA/)|$@D)L$ D
 !  ڰ
 fA/vTfD.z  T{
 eH%X      HЋ9
   %_
 AYDY
 AX  
{
 eH%X      HЋ9N
 
  A(AY(Y((Y%:
 (Y
o
 Y
 X%
 X
G
 X
 YYY7
 X%ג
 X

 YX
 XYX^X%
 AY  3t

 q
 fA/  'z
 eH%X   =
 fA/   HЋ   9
   A(A(\AYW
 (Yj ((Y
 (YՊ
 (Y
"
 X
 X
 A^X

 YYYX
 X
Ɇ
 YYX(Yʆ
 X

 XJ
 X
 YX
 YX^X
 Y  
 fA/   9x
 '  A(A(\AYW
 (Yi ((Y 
 (Y
 (Y

 X҆
 X
 A^X
m
 YYYX
 X
A
 YYX(YB
 Xj
 X"
 YXX

 ^X
 Y  
 fA/   9
   A(A(\5ί
 AY(W
 Yi ((YЈ
 (Y
 (Y
"
 X
 X
 A^X

 YYYXi
 X
ɋ
 YYX(Yʋ
 X:
 X
 YXX

 ^X
 Y   9+
 Z  A(A(A^AY(YW)
 .h ((Yv
 (Yc
 (Y
Ќ
 XH
 X8
 A^X

 YYYX
 X
 X
o
 YYYXۋ
 X
C
 X(Y\
 XD
 YX(
 YX^X,
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H

  =z
 
 H
e
 
  H
4
  =(
 (˸
 H

 (
-
 
 .
 
 (
 (
 H
 
ٍ
 (

 
 

 
 qH

 Y =
 V(
 H

 (

 ,
 (
 >
 (ϱ
 
 
 (
 Z
 
 
;
 (
$
 \
 
E
 | H
D
  =8
 ([
 H
$
 (

 
 (/
 

 (
1
 
 (
 
4
 (
u
 6
 
?
  [H

 M =
 .(}
 H
Ώ
 (
 
 (
 

 (
 
 (
 
.
 (
 0
 
9
  H
đ
  =
 (
 H

 (
 
 (
 
 T
 
 (
 
Έ
 (
w
 0
 x
 

 (
 2
 

  @UVWHp  HD$8H$  He H3H$`  IHLL$0H$  H$  L;   HL$@4H?
 HL$@]HH]H$@  HL$@UH$0  HS>
 H$0  \HH>
 \HH\HH>
 \HH	 HH=
 \H$   H$0  H$   H$8  HC$   H$@  H$X  HC$@  HD$ LD$0H  H$`  H3 H$  Hp  _^]@USVWAVHl$H  HD$PH H3HEpIHHL   D$     H	 HD$`HM	 D$    E3E3HT$hHL$`	 HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h/HHL$`A[HH%
 2[HH'[HH+
 [HH>
 	[HHuHZ'
 HZIH:	 IHZHUPHL$`)HxrH H

	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 H
 HD$(H HL$(' DD$USVWAUAWHl$H   LjLy3HHM;otI@	 Mt
I[II7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH	 Mt
IHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMxq HIH HHGHGHtH	    
H
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM' w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH	 Mt
IHH7LEwH_HUoLwH* H}HEHHMLwH]LuHEw W(f.z
u58
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]LuN IUHO(QLG(IHr HW(H|$ I葱 G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM ($   L$   HL$   fG<Hĸ   A_A]_^[]YYY@SH HHHSH
	 H3H
HJHHS 3HC HC(HC0H~	 C8HH		 HCHH [LHXIC3ICH$ 
 ICHa	 ICHP
 ICH
 ICIK @SH`  HD$8HO H3H$P  DD$0H$  D;   HL$@,H6
 HL$@
UHH #
 THHa6
 THH@ HH.6
 TH$0  HL$@H$0  H$H  HC$0  HD$ L
0
 LD$0H"
 H
m"
 `\H$P  H3/ H`  [HUATAUAVAWHHH  HD$PHXHpHx H2 H3H  M3t$@I@HD$0H?%
 HD$(MHLH
\&
 oML$I  DM  
 
 @ M]MM;}UI$N    IIIHIIIL@      A \Tf/rIHMM;|MM;x  H=	 H|$`HM D$@   E3E3HT$hHL$`T HD$`HcHH	 HD`HD$`HcHxT\HD$hHD$HHL$h H	 H\$hHuE   H4
 HL$`RHH#
 RHH4
 RHIU HH`3
 {RHIW HH/
 _RH`  HL$`H}PH    D$@   E3E3HUXHMPW HEPHcHH	 HD
PHEPHcHxT
LHEXHD$HHMX H]XHǅ       ǅ      I<$I\$IIH3
 HMPQHH"
 QHH3
 QHIW HHV2
 qQHIU HH.
 UQH H@  HMPL@  HX  LC@  L`  Hx  LC`  M$ID$IIMLT$ H "
 H
I#
 L  H  H3 L$  I[0Is8I{HIA_A^A]A\]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;tSIHHt34 HTHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVHl$H  HD$PHe H3HEpMHHH   D$     H	 HD$`HMx D$    E3E3HT$hHL$`A HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h_#HHL$`NHHg
 NHHNHH}
 NHH*
 NHI HHrNHUPHL$`HxrH H
:	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H	 HD$(Ht HL$( HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH+
 HEL%	 LeH	 HEH
 HEL5w	 LuD$    L-	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH 	 HE3HEHEHUHM H		 HD$0H-	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP Hn	 HD$@H	 HD$HE   
a
 eH%X   A   HȾ   A96}
 Z  H
)}
  =}
 A  NW	 LHEwH
 IF@H	 IFPD$    HT$0I  H	 IH	 IF(IF@HcHHq	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw HUHHMHH]wHt=C;u2HHP{;u LI@H
0H;HuAАMIHM)1E
~
 fsfH~HtBHM0H
  H
{
  L5	 }
 }
 fsfH~HtpHm	 HD$0H	 HEHEHcHHF	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR H*}
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH
 HEL%	 LeH-	 HEH
 HEL5'	 LuD$    L-\	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH HE3HEHEHUHM9 H
 HD$0Hu	 HEHEHcHHz	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP H>}	 HD$@H|	 HD$HE   
]
 eH%X   A   HȾ   A92z
 Z  H
%z
 X =z
 A  NW LHEwH
 IF@Hf	 IFPD$    HT$0I%  H
 IH	 IF(IF@HcHH		 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw HUHHMHH]wHt=C;u2HHP{;u LI@H
:,H;HuAАMIHM,Ez
 fsfH~HtBHM>,H
w z H
x
  L5F	 z
 (z
 fsfH~HtpH
 HD$0H	 HEHEHcHH	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM} LmHMHtHR Hjy
 H$H  H   A_A^A]A\_^]LEK ECWH`ICI[IsIcLH3t$0y*Hn(
 ICL
(
 MCHL'
 H
*
 Ey/H?(
 HD$ L
'
 L$   H*
 H
u*
 IcWD$@Ht$PHL$@5HH3HsHsLD$@Hi HT$@HtLD$PL+IHH\$pHt$xH`_DD$SH@HH3ɉL$0Ex"HHKHKHIcL4HH@[Hd'
 L

'
 HD$ LD$`H,
 H
)
 H\$WH@LILs&
 L+	HHBH
r&
 H+HHHD$0H<&
 IHD$(L3HCI+HHt(HfnHRAHHCH+HH;rH\$PH@_H\$WH@LIL%
 L+	HHBH
%
 H+HHHD$0H%
 IHD$(&L3HCI+HHt,H@ ff     HIHHCH+HH;rH\$PH@_@SH0HD$     * HH0[HHHD$pI*HHH+IHILIIH?LIHI+L$
 HLL$0H
$
 HHH?HH$
 LHD$(=HH@UVWATAUAVAWH$pH  HD$HH$  H H3H   MHHHL$(3Dt$ IPIВ  IIFHCH+HsHI[  WD$0Ht$@HHM`貮HT$0Hu L|$0ILd$8M;  H	 H
	 HL$`HT$pHM} ADl$ E3HT$xHL$`@ HD$`HcHH	 HD`HD$`HcHhT\HD$xHD$PHL$x Hz	 HD$xHuuHHL$pDHH#H	 @HsH+3H3Ht(HHL$p HHH	 o@HH;rHHL$p HHH	 G@HU`HL$`YHIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICI/HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICI
/IvHtrHF   3HNH~rHHƈHsLGItHH] 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM HI;t(H|$(39H
!
  H

  Mt6IIl  HL$@I+H*HHLI?LIH   H3 H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H٣ H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHMHHMWE3H]Ll$8H|$0\$(L$ LMMHHM7 HE   H]]DCHr	 HM#HHUHP HEHrPHHMH=   r<tx HAH;rh H+HsX H'vK Hz L|$8H|$0Lt$(EwD$ ]oLEHUH軱 HUHt LEL+IWEHE    HUHtLEL+IHMH3 H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   HHT$PHtLD$`L+IhHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xHנ H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`HHL$dW$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$x& H$  hL$   HT$xI (D$@IH$  IPH$x  H$x  | E3|$@L$   L$   Ld$pH|$hH$  H)o	 H$  $9H(p IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   Ho	 H$  3H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH

  HQM+IIHL+IIM;HCH;HCHL$H'HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH
9
  HQM+IIHL+IIM;HCH;HCHL$H0'HL$PHt0HA   LqHyrHHH$    kHL$PH HL$PH$  pAEHT$HItI$H
	 H;tHT$HIP A$     D
 D
 $     W$  L$  H$  ?D$0D$(H$  HD$ LD$xI
H$   H$  uHXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  \ I$L@H
	 H$  H;uIL$IAАH$x  H$x   H$  HtL$  L+I|$@HHHH;tHD(L$   HT$xI (D$@H$      H$    HHl	 H$   !5HHuI
H HcHHHW
   H$   Y HƋHQ HHK=	 4HHhl	 4HHuI
H HcHHHW(A\(H HHl	 4H( HH<	 h4IH$   IPATH$x  H$x  H fD/s;$  H|$haW$  L$  H$  D$0D$(H$  HD$ LD$xIyH$   H$  HXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  3Z I$L@H
	 H$  H;uIL$}IAАH$x  H$x  9 H$  HtL$  L+IHL$HHt.HT$P  LD$XHT$HL+I|WD$HLt$XH$x  H$x   HT$xHt%L$   L+IWD$xL$   H$   HtL$   L+I3H$   H3 L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xH H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$x	HHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`_ H  H  H  ~L H  HUH   H  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#3 H襦HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  rk H      	    	    	    	     	    Hc(	  H  8  =I
 Wt$XH  H,g	 H  P/H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   Hf	 H  dH  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
!
  HQM+IIHL+IIM;HCH;HCHL$@HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
m
 ' HQM+IIHL+IIM;HCH;HCHL$@dHL$HHt/HA   LiHyrHHH    HL$HH HL$HH  覷AEHT$@HjIH
	 H;tHT$@IP 0	  @   WELmH  D$0D$(HEHD$ LD$`HoH  H  HXH  HtIH  IPHD$XHD$ A   LEHUHM6S IL@H
 	 HUH;uIO膯IAАH(  H(  D HUHtLEL+I
H
cLc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   Hc	 H  IH  IP H  ٵH  }  D8  Wt$XH  HL$`許3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HM% HH3	 H   *HHu3
H HcHHHWHH HH3	 p*   HM HH[3	 H   K*HHu3
H HcHHHW   HMx LHu3
HHcHHIPA(HO HH2	 )H(  Ll (YH     HM* HH2	 H   )HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HHb2	 I)   HM( HHt2	 H   $)HHu3
H HcHHHW   HM8Q LHu3
HHcHHIPAH  @k (H HH1	 (
   HMH HH7	 H   (HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H HH7	 ((
   HMh HH7	 H   (HHu3
H HcHHHW   HMx0 LHu3
HHcHHIPAX  H HH6	 'HP     HM HH8	 H   o'HHu3
H HcHHHWHH HHa8	 8'H9	 H   %'HHh  F+HH8	 'IH   IPH(  :H(   0	  HuH  H  ߽HXH  H   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  H  v@  W  H  H  蟾D$0D$(H  HD$ LD$`Hk}H  H  ؼHXH  HtIH  IPHD$XHD$ A   L  HUH  ,L IL@H
	 H  H;uIOyIAАH(  脼H(  7 H  HtL  L+IEH
M@
  W  3H  H  ~D$0D$(H  HD$ LD$`HJ|H  H  跻HXH  HtIH  IPHD$XHD$ A   L  HUH  K IL@H
	 H  H;uIOXIAАH(  cH(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H\	 IH  IP H  5A$   H\	 IH  IP H  蹭F   EH    LH5	 H  >2MHIAP H  sH  fHL$@Ht.HT$Ht  LD$PHT$@L+I{WD$@H|$PH(  H(   H  w  H    H(  ޹H(   HT$`HtLD$pL+IUWD$`H|$pHUHtLEL+I~H`  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xHч H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`? H  肹H  H  4 H  HUH   H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3e H腖HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  R[ H Hc	  H  2  	    (	    0	    8	    @	    H	    HcP	  H  8  =w
 Wt$XH  HW	 H  H(i IH  IPWD$@Ll$PHǅ     L  ƅ   A   HW	 H  1H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@
HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
:	  HQM+IIHL+IIM;HCH;HCHL$@1
HL$HHt/HA   LiHyrHHH    mHL$HH HL$HH  sAEHT$@HZIH
	 H;tHT$@IP X	  @   WELmH  mD$0D$(HEHD$ LD$`H<tH  H  詳HXH  ٦HtIH  IPHD$XHD$ A   LEHUHMC IL@H
	 HUH;uIOSIAАH(  ^H(   HUHtLEL+IH
0Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HST	 H  IH  IP H  詥H    D8  Wt$XH  HL$`x3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   TH`     HM HH,	 H   wHHu3
H HcHHHWHH HHi,	 @   HM HH.	 H   HHu3
H HcHHHW   HMH LHu3
HHcHHIPA(H HHi,	 H(  \ (YH     HM HH.	 H   |HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HH:.	    HM(r HH.	 H   HHu3
H HcHHHW   HM8! LHu3
HHcHHIPAH  [ (H HH-	 
   HMH޿ HH`.	 H   `HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H_ HH-	 
   HMhQ HH.	 H   HHu3
H HcHHHW   HMx  LHu3
HHcHHIPAX  Hҿ HH-	 kHp     HM HH.	 H   ?HHu3
H HcHHHWHHw HH.	 H/	 H   HHh  HH.	 IH   IPH(  
H(   X	  HuH  H  语HXH  ߠH   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  H  F@  W  H  H  oD$0D$(H  HD$ LD$`H;mH  H  訬HXH  ؟HtIH  IPHD$XHD$ A   L  HUH  ; IL@H
	 H  H;uIOIIAАH(  TH(   H  HtL  L+IEH
@
  W  3H  H  ND$0D$(H  HD$ LD$`HlH  H  臫HXH  跞HtIH  IPHD$XHD$ A   L  HUH  : IL@H
Ž	 H  H;uIO(IAАH(  3H(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   HL	 IH  IP H  轝5A$   HL	 IH  IP H  艝F   EH    LH>+	 H  "MHIAP H  CH  6HL$@Ht.HT$Hc  LD$PHT$@L+IKWD$@H|$PH(  H(   H  G  H  ˍ  H(  让H(  a HT$`HtLD$pL+I%WD$`H|$pHUHtLEL+INH  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pHHL$tWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHM8v H	 H   H   HuH   HEL}HEHHUH+HWEHt!3 HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%
	 LeHaHEH]LL+tHH WED$xHE    HL$xDHT$xH   H   PAEHT$xI|MHHT$xHP HL$xHt|HU`  HEHL$xH+HHH;vm HH=   r<tU HAH;rE H+Hs5 H'v( HW Ld$xHMYHEHMHMHULL+tH EEfEML   HT$xHM ` L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H   踦  +fn^5\
 LM(WJLM(WJ(WHMNLeHM, H" H	 H   HMHtsHEH+HHH;vʸ H    H=   r<t HAH;r H+Hs H'v H 3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHH5H$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHP H$   aL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHp H$   qL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH}H$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   dHH   uWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$pk H	 HEWHMKKH	 HEHٮ	 HEH}HZ	 HEH   HEH   HE(W
 )E (
U
 )ME        ^T
 E(E0    E4 WE8H	 HE   f/vM   f/vrR
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM H	 HEH	 HEHM HM HMڮ Hc	 HEHT$pHtLEL+I荿3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   fHH  wW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$ph H	 HEWHMGHH	 HEHի	 HEH}HV	 HEH   HEH   HE(T
 )E (
R
 )ME        ZQ
 E(E0    E4 Wu8EH H_	 HEPN
 Ex(
U
 )   P
    uXW)E`Hm	 HEH5©	 Hu@P  f/vE=+O
 X  f/vf/vM`  OȉM$Y Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM Hu@H	 HEH	 HEHM, HM" HM H	 HEHT$pHtLEL+I˻3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHvH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHl H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHUuH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH* H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHerH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH蜿 H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH%qH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH: H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   ĮHH   ժWEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$p_ H	 HEWHM>Ht	 HEH9	 HEH}H	 HEH   HEH   HE(	K
 )E (
.I
 )M*F
 ] WM0E(
   HG	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHMH H0	 HEH	 HEHMO HME HM; Hė	 HEHT$pHtLEL+I3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   ǫHH  اW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$p \ H	 HEWHM;Hq	 HEH6	 HEH}H	 HEH   HEH   HE(H
 )E (
+F
 )M='C
 } Wu0E(
   E@ HЋ	 HEH(uG
 )Ep(
I
 )   W)EPu`H	 HEH5	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
C
 (V Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMy Hu8H}	 HEHj	 HEHM HM HM H	 HEHT$pHtLEL+I;3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pHY H3HE AALL   L   H   L  H  HEI荈   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pHHL$t!WE3H}Ht$8Ll$0D$(t$ LL$pMIHMjX WD$XH|$hHE   H}@} DGHp,	 HM GHE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH

	 Ǚ HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
Y	  HQM+IIHL+IHM;HCH;HCHL$XPHL$`Ht,HA   HyHyrHHHU   菽HL$`H HL$`HEHrPHHM H=   r<t HAH;r H+Hs H'v H AEHT$XI.IHT$XIP H}H]H+HWD$xHt3 HfHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMv  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMNw  HL$x HL$XHt2HT$`@  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I3HM H3ݩ H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHT H3HE AALL   L   H   L  H  HEI]   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pޢHHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHM:S WD$XH|$hHE   H}@} DGHH'	 HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
)	  HQM+IIHL+IHM;HCH;HCHL$X HL$`Ht,HA   HyHyrHHHU   _HL$`H HL$`HEHrPHHM H=   r<t HAH;rՖ H+HsŖ H'v H AEHT$XIc)IHT$XIP H}H]H+HWD$xHt3 HaHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHMh    D$8   D$0   D$(   D$ LL$pLD$xIHMiq  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMg  HL$xj HL$XHt2HT$`];  LD$hHT$XL+IǢWD$XHD$h    HUHtLEL+I3HM H3譤 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH@  Hǀ`HXHp )pHO H3H$   MMH$`  HHL
 HHH>
 H;/
 r   HH!
 H$8  Ht
48
 HE3H
 E3AHHH
 H;
 r
   1HH$8  WHt
(HIW$H  L$X  L$   L$   L$   L$   L$(  HT$`H$   蠳  HD$`H$(  L$0  HT$`H$   y  HD$`H$0  W$   L$   HcFxHD$pIHt'I;v
H
	 n HH$   ~tHD$pMfD  H$   L;  HT$`  HD$`H$   L$   H;   HD$`L;   L|$`M+IL$   I;uxIH+HHshI+HIH+Hs
H
	  HQM+IIHIH+IMI;LCL;ICH$   sH$   L$   H   K   L$   I;upIH+HHs`I+HIH+Hs
H
o	 ) HQM+IIHIH+IMI;LCL;ICH$   sH$   HtHD$`HH$   HH$   IHD$pkL$@  HT$hi  HHD$`H
 LH(H
 H;
 r(   YLHL$`L$8  Mt*L)AMXOIIMo H	 IML$8  HT$`HL$p(HHL$`HD$`H$@  WD$xL$   Lcn,MtM;v
H
	 ׌ IHL$xqM    M;  HT$`H$   e  HD$`H$   H;   HD$`LD$xL;   H|$`I+HL$   I;urIH+HHsbI+HIH+Hs
H
y	 3 HQM+IIHIH+IMI;LCL;ICHL$xqH$   LD$xHt7I&H;$   uHL$xbpH$   HtHD$`HH$   HH$   I
 |   H~(DH]	 H
	 HcH$   UIL$   IH$   H+HHt0ff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r;
 }   DH	 H
	 HcH$  ]TIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;r{
 ~   DF,H	 L%E	 I	HcV,H$   SIL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r
    DF,HԿ	 H
	 LHcV,H$   RIL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu 
    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$   赲 HH$          s 
    HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$   . HH$   荼 H$   HtL$   L+IH$      L=G	 H4	 ;~,      HcL   L+   IHT$(D$    DSL   L$   L+D$xIL|$(D$    D&HD$xL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID    L   L+   IH
L	 HL$(D$    DL   L$   L+D$xIH
(	 HL$(D$    DcHD$xL$L$   L+$   IH
[	 HL$(D$    D*L$   ATIT$HL$`H IDH$   L%	 P       5?+
 L-L	 I*;~(      HcH   H+   IHHLI?LLl$(D$    DyH[H   L$H   H+IHHLI?LLl$(D$    D7H[H   L,L$   L+$   IH
	 HL$(D$    DH$   HHHD$`L$  L+$  IH
p	 HL$(D$    DL$  L$   IT$HL$h4 LL$   IUHL$p L(H$  LHT$`H$  MHH$    H IDH$   RAH$   ;^(   HcH<    H$  uH	 H$   U[HkH ]HVH$   H$  AsHHxrHH H$h  3H$p  H$x  H$   Ƅ$   H$p  H$   = HƂ	 H$h  H H$h  0 AH$      ;^(   HcH<    H$  tHD	 H$   W[HmH ]HXH$   H$  CrHHxrHH H$  3H$  H$  H$   Ƅ$   H$  H$   ? Hȁ	 H$  H H$  2 AH$   ;^,   HcH<    H$  %sHu	 H$   `[HvH ]HaH$   H$  LqHHxrHH  H$  3H$  H$  H$   Ƅ$   H$  H$   H Hр	 H$  H H$  ; A;^,   HcH<    H$  6rH	 H$   q[HH́ ]HrH$   H$  ]pHHxrHH H$  3H$  H$  H$   Ƅ$   H$  H$   Y H	 H$  H  H$  L |    D$p   Dt$`LL$pLD$`H$(  HL$h HT$hH$H  ): 7    D$`   Dt$pLL$`LD$pH$0  HL$h HT$hH$H  9     Dt$`L   LD$`H$   HL$h HT$hH$H  9     K$
 D$hDt$`LL$hLD$`H$@  HL$p< HT$pH$H  Z9 h    Dt$`L   LD$`HT$xHL$hP HT$hH$H  9 ,    HV`L$@  L$  HL$h HT$hH$H  8 H$   Ht(L$   L+IW$   L$   H$   Ht(L$  L+I͑W$   L$  H$  Ht(L$   L+I蘑W$  L$   H$   Ht(L$   L+IcW$   L$   HT$xHt%L$   L+I1WD$xL$   H$   HtL$   L+IH$8  H$H  7 H$H  H$`  HH$H  HtL$X  L+I诐HH$   H3l L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWH@  Hǀ`HXHp )pHW; H3H$   IMH$`  HH
 HHH
 H;
 r   KHH
 H$@  Ht
#
 HE3H
 E3AHHH
 H;
 r
   HH$@  WHt
(IH$@  W$H  L$X  L$   H$   L$   L$   L$(  HT$`H$   [  HD$`H$(  L$0  HT$`H$   4  HD$`H$0  W$   L$   LcoxIMt"M;v
H
t	 .{ IH$   >`MH$   M;  HT$`  HD$`H$   L$   H;   HD$`L;   Ht$`I+HL$   I;x   IH+HHshI+HIH+Hs
H
ͳ	 z HQM+IIHIH+IMI;LCL;ICH$   o_H$   L$   H   I   L$   I;upIH+HHs`I+HIH+Hs
H
6	 y HQM+IIHIH+IMI;LCL;ICH$   ^H$   HtHD$`HH$   HH$   IlL$8  HT$h5  HH$   %(HHL$`HD$`H$8  WD$pL$   Lcg,MtM;v
H
b	 y IHL$p/^MM;   HT$`H$   豜  HD$`HL$xH;sDHT$`HD$pH;w5Ht$`H+HH;$   uHL$pC]HL$xHD$pHt1H#H;$   uHL$p]HL$xHt
HD$`HHL$xHHL$xIV |   Hw(DH	 H
	 NHcH$   AIL$   IH$   H+HHt1fff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r }   DH]	 H
Z	 HcH$  AIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;r; ~   DG,HT	 L%	 IHcW,H$   X@IL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r{    DG,H	 H
M	 HcW,H$   ?IL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu    HGxH   H   LG0Ht$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$   u HH$   ԩ       3    HGxH   H   LGHLO0Ht$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$    HH$   M H$   HtL$   L+IˇH$      L=	 H	 ;w,  u    HcL   L+   IHT$(D$    DL   LD$xL+D$pIL|$(D$    DHD$pL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID    L   L+   IH
	 HL$(D$    DZL   LD$xL+D$pIH
	 HL$(D$    D)HD$pL$L$   L+$   IH
!	 HL$(D$    DL$   ATIT$HL$`H IDH$   L%ͪ	 V       5
 L-	 I*;w(      HcH   H+   IHHLI?LLl$(D$    D?H[H   L$H   H+IHHLI?LLl$(D$    DH[H   L,L$   L+$   IH
ߩ	 HL$(D$    DH$   HHHD$`L$  L+$  IH
6	 HL$(D$    DyL$  L$   IT$HL$h LL$   IUH$   ެ L(H$  kLHT$`H$  VMHH$   H IDH$   OAH$   ;_(   HcH<    H$  aHܮ	 H$   [H-Hrq ]HH$   H$  `HHxrHH{ H$h  3H$p  H$x  H$   Ƅ$   H$p  H$   q Ho	 H$h  Hq H$h   AH$  ;_(   HcH<    H$  `H
	 H$    [H6H{p ]H!H$   H$  _HHxrHHz H$  3H$  H$  H$   Ƅ$   H$  H$   q Hn	 H$  Hz H$   AH$   f;_,   HcH<    H$  _H<	 H$   '[H=Ho ]H(H$   H$  ^HHxrHHy H$  3H$  H$  H$   Ƅ$   H$  H$   p Hm	 H$  H H$   Aސ;_,   HcH<    H$  ^Ht	 H$   7[HMHn ]H8H$   H$  #]HHxrHHx H$  3H$  H$  H$   Ƅ$   H$  H$   o Hl	 H$  H H$   B    Ǆ$      Dt$`L$   LD$`H$(  HL$h軯 HT$hH$H  &     D$`   D$   LL$`L$   H$0  HL$hp HT$hH$H  &     Dt$`L   LD$`H$   HL$h聰 HT$hH$H  _& m    
 D$hDt$`LL$hLD$`H$8  H$    H$   H$H  &     Dt$`L   LD$`HT$pHL$h HT$hH$H  %     HW`L$8  L$  HL$hZ HT$hH$H  % H$   Ht(L$   L+I~W$   L$   H$   Ht(L$  L+I~W$   L$  H$  Ht(L$   L+IL~W$  L$   H$   Ht(L$   L+I~W$   L$   HT$pHt%L$   L+I}WD$pL$   H$   HtL$   L+I}H$@  H$H  ]$ H$H  H$`  HH$H  HtL$X  L+Ic}HH$   H3 } L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWHP  Hǀ(HXHp)p)xH( H3H$   ML$   H$   HL$HH$  H$   L$  L$  L$  H$  H$   D$D    D$@P   EH H
3 IcHL$PF3LD$XIHT$PH+HH      Ht'L@ IHLD$XIHT$PH+HH;r3L+IMtfHHHD$XH+D$PHH;rD$@Q   DH H
 HHcHL$hF3LD$pIHT$hH+HHt/L@      IHLD$pIHT$hH+HH;r3L+IMtfHHHD$pH+D$hHH;r   =
 H
 A;?   D$@T   HcMFM+IHL$(D$    DI6MD$M+$IH
 HL$(D$    DrI$tYtWLD$XL+D$PIH
 HL$(D$    D5HD$PtJ   LW	 H*H$   ;0M  D$@W   HcMu IMI+HHHHHH?H  G;  H<[ID$I+$HMLM+LIHD$0LD$(LЌ	 H
͌	 TILMDL+II$(H$   L8HxI+HD  G;9  Mu IMI+H*HHHHH?H  G;  H<[HD$XH+D$PHMLM+LIHD$0H	 HD$(L	 H
	 HSILMDL+IHT$PH$   X0AYtH$   X XH|$pHL$hH+H|G;}
t2H)k	 H$   HZ	 H$   H$H  f D$D   E3H$   H$   f H$   HcHHd	 H   H$   HcHh   H$   HD$HH$   c H_	 H$   3H$0  $8  H2	 H$      HOe H$  H$   SL$  H$  LC$  H HD$ DËYHj	 H$  HX	 H$  H$H  e D$D   E3H$  H$  ze H$  HcHHc	 H  H$  HcHh  H$  HD$HH$  b H^	 H$  3H$0  $8  H
	 H$  Ż   H'd H$  H$  RL$  H$  LC$  Ht HD$ DË1Hh	 H$  HW	 H$  H$H  d D$D   E3H$  H$  Rd H$  HcHHb	 H  H$  HcHh  H$  HD$HH$  a Hz]	 H$  3H$0  $8  H	 H$  蝺   Hb H$  H$  QL$  H$  LC$  H$ HD$ DË	Hg	 H$  HV	 H$  H$H  lc D$D   E3H$  H$  *c H$  HcHHna	 H  H$  HcHh  H$  HD$HH$  z` HR\	 H$  3H$0  $8  H	 H$  u   Ha H$   H$  rPL$   H$  LC$   Hl HD$ DËD$@Z   HT$hH\$HH HL$hH   HD$xH+HHH;vc H    H=   r<tc HAH;rc H+Hsc H'vc Hz WD$h3HD$xHT$PHtLD$`L+IIsHH$   H3s L$P  I[8Is@A(sA({IA_A^A]A\_HLH L@HPHHSVWATAUAVAWH  HD$x)p)xD)@D)HMILD$p    Ǆ$  9   H$p  DHf H
 HcHL$@<3LD$HIHT$@H+HH      Ht#LIHLD$HIHT$@H+HH;r3L+IMtfHHHD$HH+D$@HH;rǄ$  :   L$x  E$H H
 \Ic$HL$X<3LD$`IHT$XH+HHt#LIHLD$`IHT$XH+HH;r3L+IMtHHHD$`H+D$XHH;rǄ$  <   H|$(H$h  HD$ MLIH$   c HHHH+HLL$HL+L$@IHL$0H	 HD$(L	 H
	 #K3HD$HHT$@H+HHt)L     IHHHD$HH+D$@HH;rH$   HtL$   L+Ip   H$`  D
[
 Dz
 L7 H*A;<$+  Ǆ$  >   HcHNH+HHHH?HLD$(D$    DDL4[L>IEI+E HOLO+LIHD$0H̂	 HD$(LĂ	 H
	 JKLODL+IIU (L$P  MFM+IH
 HL$(D$    D(M.HNH+H*HHLI?LHP HD$(D$    DL4[L>HD$HH+D$@HOLO+LIHD$0H	 HD$(L	 H
	 0IKLODL+IHT$@H$@  X At\L$8  AX?YAWL$X  MFM+IH
 HL$(D$    D*(l IAXt^LD$`L+D$XIH
 HL$(D$    DHD$XtL$H  Ǆ$  A   HT$XL$0  I HL$XHHt{HD$hH+HH;v] H    H=   r<t] HAH;r] H+Hs] H'v] Ht WD$XHD$h    HL$@HtiHD$PH+HH;vc] H    H=   r<tG] HAH;r7] H+Hs'] H'v] HIt IL$  A(sA({E(CE(KIA_A^A]A\_^[H\$WH0LIHL+	H*ILD$(DHHHD$    H?HD&HH[H\$@HHH0_Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hr H3HsHsHH;uHl$0Ht$8H\$@H _<[ 5[ .[ '[  [ DL$ LD$HT$HL$SVWH0HD$(HH9z ucH 臭 HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH G HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHp H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _9Y 2Y +Y $Y H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   Ho H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weH~o HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _W W W W W W W W H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHn H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _)W "W W W HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHH>0HHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1HSm H3HsHsHH;uHl$0Ht$8H\$@H _U U U U U HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PHp H3HEpMMHHH   D$     HF	 HD$`HMS D$    E3E3HT$hHL$`IS HD$`HcHH@	 HD`HD$`HcHDxDD\   HL$hg~HHL$`ɩHHot	 躩HH诩HHz	 蠩HI蕩HAQ HH|HUPHL$`BHxrH H
D\ HL$(3HL$0HL$8HD$@D$HHT$0HL$@R HRW	 HD$(H HL$(v @SUVWAVH`  HD$8H H3H$P  IIHLD$0    H4E	 HD$@H$   	R D$0   E3E3HT$HHL$@Q HD$@HcHH!?	 HD@HD$@HcHDxDD<   HL$H|HHL$@RHHd	 CHHUP HHd	 'H$0  HL$@uAHHcD$0H$0  H$H  HC$0  H	 HD$ L
Ί	 LD$0I9@UVWAVAWH`  HD$8H$  H
 H3H$P  MIHLH$  D$0    HC	 HD$@H$   P D$0   E3E3HT$HHL$@qP HD$@HcHH=	 HD@HD$@HcHDxDD<   HL$H{HHL$@HH	 HIV5O HH	 ƦH$0  HL$@@HIcD$0H$0  H$H  HC$0  Hl$ L
t	 LD$0IH\$Ht$WH IHHH;t HHe)HHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(IHf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IIHA(HWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   HX(H
_o	 HH0@8   HH$   蔍 HHL$(H_ HL$(KY H\$WH HHHÀ< uHú   H5 HHu/3 Ht!HH+fff     9HHuHH\$0H _@SH HRP  H3/	 HCPH [HL$SH0HD$ HD$P    EtHVU	 HA@H.	 HAPD$P   J   H#	 HH)	 HCHC@HcHH+	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH^= HHQ3HHBHK3 H.	 HH{3HHDH^H\$HHu6	 HHOHKHtHPHGHCHGHCG C H	 HH@= HHH\$PHt$XH0_@SH HRM  H-	 HCPH [HL$SH0HD$ HD$P    EtHS	 HA@H-	 HAPD$P   z  Hk&	 HH 	 HC(HC@HcHHF 	 HD@HC@HcHD<    HH0[@SH HJ  H-	 HCPH [HL$SH0HD$ HD$P    EtH6S	 HA@H,	 HAPD$P     HR	 HHy-	 HC(HC@HcHH~%	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH H(	 HHH	 HAPHI82 HK 2 HK1 H'	 HH [@SH HQ	 HHH	 HAPHI81 HK 1 HK1 H5'	 HH [H\$WH H|L  H]+	 HGPt
X   HI HH\$0H _H\$WH HJ  H+	 HGPt
X   HGI HH\$0H _H\$WH HH,3	 HHHJHKHtHPHGHS0HCHO0HGHCG C H9 HC(3HHB0 H|0	 HH1	 HC(HH\$0H _H\$WH HG  HM*	 HGPt
X   HwH HH\$0H _H\$WH HH\2	 HHHJHKHtHPHGHS0HCHO0HGHCG C H8 HC(3HHB;/ H4	 HH+	 HC(HH\$0H _@SH HH   / H   HKX/ HKH/ HK8x/ HK(n/ HKd/ HKH [H%T/ H\$WH HQ@3HHtLAPL+I?H{@H{HH{PHS(HtLC8L+I?H{(H{0H{8HSHtLCL+I.H{H{H{H\$0H _H\$WH HH   7  L   HgfffffffL+   IHLI?LH   r  H   HOXT. HOHJ. HO8@. HO(6. HO,. HOH\$0H _H%. HUHl$H  HD$8HXHxH H3HEpIID$0    3A A	    f/rHHr   H0	 HD$PH	 HD$`HM, D$0   E3HT$hHL$P~, HD$PHcHH*	 HDPHD$PHcHhTLHD$hHD$@HL$h) H%	 HD$hHE    E    He	 HL$`HL$`,+ HUPHL$PHEPH}hHCEPHD$ L
e	 LHQe	 H
be	 HMpH3H= L$  I[I{I]HUVWATAUAVAWHH  HEHX)pHE H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEH=h	 H  IHHL@H
$	 H;u.HSHKHH  مHH* H  HAАH  HrSHH  H=   r<tW, HAH;rG, H+Hs7, H'v*, HYC HWHL$x9@  MEHT$xH.\  (Hǅ     L  ƅ   A   HMg	 H  9GIH  IPH  HrSHH  H=   r<t+ HAH;ru+ H+Hse+ H'vX+ HB H   Hf	 H   7H(( H  H   8ILAHIAАH  HrTHH  H=   r<t* HAH;r* H+Hs* H'v* HA HH  HH  ( H\$0Lt$(x  D$ p  (HT$xH K  H_HD$xH  HuHCH;t'H;tHM) Ht
HhHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH   HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
^	 % W  L  D$@Ll$PHv+	 HEHc	 HEHMH=' D$\   E3HUHM' HEHcHHK%	 HD
HEHcHhT
HEH  HMg$ H? 	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMrHXH  Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
]	 B$ IPL+IIHL+IIM;HCH;HCHL$@_LD$HMtM(LD$HILD$HIPHL$@H;t
I;t,B IHT$@IPHǅ     L  ƅ   E3HF	 H  BIH  IP H  H  Hb	 H  |HȋW$e$ HHb	 {IH  IPAD9o$Y  f     LGHWHL$xm EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  
D$0D$(HD$@HD$ LD$`HH  H  EHXH  uHtIH  IPLD$HL;D$Pu   HL$@7LD$HMtM(LD$HILD$HIPHL$@H;t
I;tb@ IHT$@IPHH  HH  # ;w$}H
Z	 !" Hǅ     L  ƅ   A
   H2a	 H  @IH  IP H  HH  cHH  # HMHLHMH# HT$@HtLD$PL+I4WD$@Ll$PH  HtL  L+I#HT$`HtLD$pL+I}4HM# HL$x# 3H  H3&4 H$`  ($   H  A_A^A]A\_^]H8D$`AD$hAD$pLALA$A D$xA HLIy ~y ~By  ~g    HH8H[	 LAHD$ H
_	 L
[	 H_	 H[	 LAHD$ H
_	 L
[	 H_	 yH[	 LA HD$ H
y_	 L
r[	 H_	 NH~[	 L
W[	 HD$ H_	 H
D_	 'HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEH
^	 H  >HL@H
	 H;u.HSHK{HH  {HH} H  HAАH  HrSHH  H=   r<t'" HAH;r" H+Hs" H'v! H)9 HWHL$xK@  MEHT$xHn  (Hǅ     L  ƅ   A   H]	 H  	=IH  IPH  HrSHH  H=   r<tU! HAH;rE! H+Hs5! H'v(! HW8 H   H\	 H   vH(S H  H   
ILAHIAАH  HrTHH  H=   r<t  HAH;r  H+Hs  H'vw  H7 HH  HH  l H\$0Lt$(x  D$ p  (HT$xH]  H_HD$xH  HuHCH;t'H;tH Ht
H8HL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH   HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
T	  W  L  D$@Ll$PHF!	 HEH3	 HEHMH
 D$\   E3HUHM HEHcHH	 HD
HEHcHhT
HEH  HM7 H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMB
HXH  rHt
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
XS	  IPL+IIHL+IIM;HCH;HCHL$@ULD$HMtM(LD$HILD$HIPHL$@H;t
I;t7 IHT$@IPHǅ     L  ƅ   E3H<	 H  8IH  IP H  QH  
HX	 H  qHȋW$5 HH[X	 qIH  IPAD9o$Y  f     LGHWHL$xc EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  	D$0D$(HD$@HD$ LD$`HH  H  HXH  EHtIH  IPLD$HL;D$Pu   HL$@-LD$HMtM(LD$HILD$HIPHL$@H;t
I;t26 IHT$@IPHH  HH  j ;w$}H
P	  Hǅ     L  ƅ   A
   HW	 H  ~6IH  IP H  PHH  3HH   HMHHMH HT$@HtLD$PL+I*WD$@Ll$PH  HtL  L+IHT$`HtLD$pL+IM*HMj HL$x_ 3H  H3) H$`  ($   H  A_A^A]A\_^]@SH A(HA u CH [Ht$WH0HD$     H      t@W H   HVxH\$@       ^FxH\$@,;L   HHt$HH0_@SH H	 HH   H"8	 HH	 HAPHI8B HK 8 HK. H
	 HH [Wf/v%      ^Ix,;L   H\$WH HHH   HqH   HbH   HH\$0H _I@UHHPHEH\$`Ht$pH|$xHa H3HEHHE   3Hu@uDF
HT	 HM3HKHEH;sTHHUH;wHH}H+H;KuVHg(HH;HKHtcHA   HqHyrHHH;H;Ku
   H$(HKHt'HA   HqHyrHHHU  8HC HEHrPHHMH=   r<tS HAH;rC H+Hs3 H'v& HU. HE   HuE A
   HS	 HMo2HCHMH;sVHHUH;wJH}H+H;Cu
   H;'HH;HKHtcHA   HqHyrHHH;H;Cu
   H&HKHt'HA   HqHyrHHHU  7HC HMHE   HuE A   H
S	 HM1HUHHMmHMH3% H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3ur  HSHrr  H_HGPLG`HHOPP8MHHOP-p  HHMAHCHEEWH9puA(H HD$8HEHEHL$0> (Y5{	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0 Y		 XC(EoHHEoH#H      H;vo	 \(=p (5P	 f/vIHOhIn  f/v:HEH;t1HKHUuEC(HKHUuHK0HUt]HCHEHx tH HD$8HEHEHL$0 D(DY7	 DXC(D   0H	 I$I\$H]oHOHHHGHCHWHGLL+t6o W=C	 A|$At$ HMs HMi HM_ IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA n CH [H\$WH0HD$     H      tS HWxH   %HH\$@H0_@SH H	 HH   H2	 HH@ HAPHI8r HK h HK^ H	 HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=Y	 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@,f HL$0 ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@@f HL$0 L$   HHH$   ($   HĠ   _zj  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Ht HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     OHHK8HOHS0LC8IL+LtHj HH\$@H0_H\$WH0IH IHD$     HHK HOHSLC IL+LtHDj HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3G
 HgHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$P"2 HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P` (Y%	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$   Ո (X\(HĐ   [B(HhHBHD$(Hx uWY		 HhH HL$8HD$@HD$ HD$P Y	 HhWf/vW	 f/v   Wf/vIxHAHH H\$WH HHi  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs蜇 Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$Xh f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HRHSHt
HHH
HJ$H;Cu
   H&HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HWHSHt
HHH
HB&H;Cu
   H+HKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xH H3HEHHE   3Hu@uDF
HbE	 HM	$HCHMH;sTHHUH;wHH}H+H;CuVHHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  4)HC HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   HuE A   HhD	 HM"HCHMH;sVHHUH;wJH}H+H;Cu
   HHH;HKHtcHA   HqHyrHHH;H;Cu
   HhHKHt'HA   HqHyrHHHU  (HC HMHE   HuE A   HC	 HM"HUH'HMHE   HuE A   HpC	 HM!HUHHMHE   HuE A   HC	 HM!HUHHMcHMH3 H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    a  HSHOb  H~HFPLF`HHNPP8MHHNP
`  HHMHUH   
HUHM0HUH   HFPLHUHNPP(HM!HE HMHM(HULL+tH|` HMHEHMHMHULL+t	HR` HN(HD$xH^(H]HV LL+tH&` H]EWA(HGH  Hx uE(H HEH   HEHMK D(D	 EYDXO(D$`    DEǆ       Ɔ          D	 D%ͥ	 D-D	 @      WD$hHt3 HHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM' D]HNh\  fA/  HEH;  LcuIL;wt%HO EtHHGHG    H_E~LEN    HUHOB^ EG(Lcu IL;w t%HO} EtHHGHG    H_ E~LE N    HUHO] LcuIL;w8t%HO0) EtHDHG0HG0    H_8E~LEN    HUHO0] Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      Hy`  HEH;  HWHMLbG(EHWHM5bHM   H   H;t=HOH   b   G(HOH   aHO0H   aLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      H_  H   H;t=HWH   iaG(   HWH   LaH   HW0<a     uf/w(\\ (HNhZ  f/v=H   HM8`   EXH   HMH`H   HM``f/v\(rX(\(r(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  z fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  Pz fA/v"HL$hv    9   }H]HL$hT D$`   fnu^HE0H;t1HOHU8^EXG(HOHUH^HO0HU`^HY     V0W	 HV(IHL$x HM HM  HM H    H    H    HM`t HMHj HM8` H   R H   E H   8 HM- HM# HM IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5 	 EW=	 E   I$HEI|$HFH;t'H;tH Ht
H"HL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
Z	 ff     HE(WA)HH;}LEMHL$`& H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMv    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMv EHSxHExHD$(H  HD$ L   L   HM]B YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(HC t0Eu"A   EEH6	 H   vA#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtH.HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HMG HtHbHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Af  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`H Y   SxE3{e  H   HCxMHHa  [pSh(\%	 T   f/vA      8  f/vA        f/vA
      H  H9   rA(   ~TUpT]xH0  HMp f/HGHExf/HG^(  5	 Yf/vA   !H_  @  Y   f/DGHM HMx AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   H Ic    HA   H'2	 vAO   H82	 gAO   Hy2	 XA6   H2	 IAD   H2	 :AC   H,3	 +A9   He3	 AQ   H3	 
A   H3	 HC   HLKDHH0[ u    W    *  9  H  f     HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3HK	 H   EotEH   LcHsHH{Lsp5`	 EW=\	 E   I$HEI|$HFH;t'H;tHG Ht
HbHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$`D H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMn    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMm EHSxHExHD$(H   HD$ L   L   HM9 YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H; t0Eu"A   EEH.	 H   A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HMS HtHnHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtH袺HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I?  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Aa  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`@ Y   SxE3a  H   HCxMHH_  [pSh(\%Y	 T   f/vA        f/vA         f/vA
      H   H9   rA(   ~TUpT]xH  HMp f/HGHExf/HG^  5	 Yf/vA   !H~^     Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]HHHWATAUAVAWHPH@HXHhHp LLE3D`LBL+H*HIHHH?H!D$    AINI+HHHHH?H!  AI     IHHL$0p  HIHH;tDHHtLCL+IL#LcLcHHHGHCHGHCL'LgLgHL$0HtJHD$@H+HI;   H    H=   r uhHAH;sXH+HrHH'w;HJ HHINI+H*HHHH?HH;s(     IL\$PI[8Ik@IsHIA_A^A]A\_LSH   ICHAC    H		 ICHh ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$Xv H	 HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    H	a HL$(= @SH0HD$ HٹX    HD$@HSHca  HHtH@@HcHHB@HH0[@SH0HD$ HH	 HH HA(HA@HcPH HD
@HA@HcPDBDD
<H} HH HA(H0 H. HHKHtHP tHC    H0[LSH   ICHAC    H	 ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH. HD$P3HD$XHD$`HKHT$X H HD$(H; HD$PHD$hHcHH HDhHD$hHcHDd    H] HL$(]
 @SH0HD$ HٹX    HD$@HSH3`  HHtH@@HcHHB@HH0[@SH0HD$ HH_ HH HA(HA@HcPH: HD
@HA@HcPDBDD
<H HH HA(H0 HN HHKHtHP tHC    H0[LH   ICAC    HQH	 ICH ICAC   IKH HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H[ HL$( @SH0HD$ HٹX   < HD$@HSHS_  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPH HD
@HA@HcPDBDD
<HM HH HAHI HtHP tHC     HU HHKH0[H%: @SHpHK H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8^ @-H$   u	HHHtHL$`H3k Hp[2HL$`H3V Hp[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PH	 HA@H HAPD$P   H HHOH	 HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_Hk H\$WH H HH   H 	 HH HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH H 	 HHHh HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH H HH   H HH HAPHI8 HO  HO H Ht
  H HH\$0H _H\$WH Ho HHHx HAPHI8 HO  HO H Ht
   H HH\$0H _H\$Ht$WH0H3HRH\$ H+HeHHGH+HHtHHHHHGH+HH;rH\$@HHt$HH0_LHXICLL	IAI+HHIH;rQH IC3ICICH	 ICD$0ISIK H} HD$8H	 HL$87HAI@IHH
HHXHUSVWATAUAVAWHH  HE@)p)xD)@D)xD)hD)XD)HD)8D)(D)Hי H3H`  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,H	 HD$ L
g	 LD$@H	 H
T	 ǈfE/w,H`	 HD$ L
4	 LD$HHp	 H
!	 蔈̋  .H*	 HD$ L
	 L  H`	 H
	 HHPHMKIHPHM:E(D=t	 	 T$@fn=~	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGH: HE3HEHE H$	 HEEHUHM H HEHMI HuIH HD$XHHL$`HD$pHD$hHǅ(     L   ƅ   A!   HB	 H  &HH  HP H(  HrSHH  H=   r<tr HAH;rb H+HsR H'vE Ht Hǅ(     L   ƅ   AC   H	 H  HH  HP H(  HrSHH  H=   r<t HAH;r H+Hs H'v H 2 EAA   D5E	 D-|	 @      G D$ L
 	 DEH/ 	 H
	 9IGHHHL$ L
' 	 DG H	 H
	 pIHt$0IGHD$(AGD$ MOMHUH* HMAu3H8  !HHMTHH   H8     H8  HD$@HUHL(HMHHMʥH8  HMH@  HULL+t	H6 HM虥HH  HMHP  HULL+tH5 E؉X  L8  
{	 HMpLHH  HHMH    H   HM( HM fEnEA(5 ^H8  HD$@HUpHML
{	 H  HHM诤H8  HMH@  HULL+t	H5 HM~HH  HMHP  HULL+tH4 EX  L8  (HMH{LHHMHH`HM( HM H    H   AƙA ;  A(LHI~Y  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(uHtX9HI;IDH;tHuWI*MyXi{	 ^HT$XU  D(H H   H H   H8   L$PE3H   H   Y H   HcHH H
   H   HcHh
   H   HD$HH    H H   3H   (  PH   HH) H   +HHu3
H HcHHHW   H   HAH HH M+HHu3
H HcHHHW   H  w HH5HT HHu3
H HcHHHW   H  F HA(H& HHH *HHu3
H HcHHHW   H   HHH HHu3
H HcHHHW   H   H(H HH 2*HHu3
H HcHHHW   H   \ HHH9 HHu3
H HcHHHWA(H  Z +Efn^5Gx	 t$H3H  H   H  WH  H  HtD	H  HH  HT$HH  H;sLHT$HH;wBH\$HH+HH;   u   H  H  H  HtHHH1H;   u   H  H  H  Ht1H  H  HH  HT$@H;sLHT$@H;wBH\$@H+HH;   u   H  H  H  Ht;HH+H;   u   H  IH  HtDH  HH  IE L@H
G H  H;Iu#/AfD/vH	 H   'E2fE/vH	 H   'E2AG D;~!fE/wfA/vH	 H   'HH   HPE   A(A\A^ATf/js	    HǅP     HH  D8  Aa   H	 H8  HH8  HP H8  lHǅP     HH  D8  AH   H	 H8  JHH8  HP H8  H  Ht%L   L+IW  H   H8  νH8   =r	 H}D;     HǅP     3HH  8  DCiHS	 H8  HH8  HP H8  iHǅP     HH  8  DCBHv	 H8  JHH8  HP H8  E2AEu8LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtNHMk HMa HMV HML H`  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH`  Hǀ)p)xH H3H$0  ILL$hEHHT$pLH$   H$   DD$XL$   E3ADt$HE,Hd	 HD$ L
8	 LD$XH4	 H
	 HǄ$     L$  @$  A   H	 H$  aHH$  HP H$  HrTHH$  H=   r<t HAH;r H+Hs H'v} H (uw	 $  (
Fu	 $   .o	 $  
r	 $   LHIO  $   I$HPH$   I$HPH$   jo	 $  
o	 $  n	 $   WL$xD$@AΉL$D|$@ 
  Hc  $  $   A   D|$`E;  AAHǄ$     L$  Ƅ$   E3H H$  HǄ$     L$  Ƅ$   E3H H$  sF    EHt$8H$  HD$0H$  HD$(E͋莺H$  HrTHH$  H=   r<t HAH;r H+Hsy H'vl H HǄ$     L$  Ƅ$   H$  HrUHH$  H=   r<t HAH;r H+Hs H'v H HL$pY $   D$P;  ML$Iq\$P;u4Ht$hHt$0ID$HD$(AD$D$ M$H$   b   H H$P  H$   |$HE3E3H$X  H$P   H$P  HcHH϶ HP  H$P  HcHxL  H$X  HD$hH$X   H H$X  L$  Ǆ$     HE	 H$P  H	 HH	 HHH H 	 HH$  H$P  ָH$  H$  HC$  HD$ L
c LD$PH	 H
	 'H H$P  H$  i |$HE3E3H$X  H$P  - H$P  HcHHy HP  H$P  HcHxL  H$X  HD$hH$X  u HM H$X  L$  Ǆ$     H H$P  nH	 H_H HPH H H6H$  H$P  職H$  H$  HC$  HD$ L
 LD$PH
	 H
w
	 %E3$   D|$`L$   |$HH$   HD$pDl$XH$   Ht$hH$   Au:H$  HH$   H$   H$  7  H$  HD$PH$H  L$   H$   HH$   ZH$  H$   H$  H$   LL+t	H# H$   H$  H$   H$  H$   LL+tHf# $   $  L$  $  H$p  LHH$  +HH$   *H$  c H$  U H$0  F H$   8 fAn# (^H$  HD$PH$p  H$   L$  H$  HH$    H$  H$   H$  H$   LL+t	HK" H$   H$  H$   H$  H$   LL+tH" $   $  L$  (H$H  LHH$   HH\$pHH$0   H$    H$   H$   AǋL$D?LHIF  7E3$   L$   |$HH$   H\$pDl$XH$   Ht$h$   f/
  f/$      H$  H)		 H$  4HH	 %HL$xn HHD D|$DH$  AH	 |H HH$  HPHǄ$     L$  Ƅ$   E3HX H$  
HH$  HP H$  ݣD$@ H$8  軰H$8  m   D|$DA}$      f/$   :  H$  ӱH	 H$  HH	 HL$xH HH	 HH$  HPHǄ$     L$  Ƅ$   E3HX H$  
HH$  HP H$  ݢD$@ H$8  軯H$8  m H$    $  D$xAD|$DIT$H$   HHH$0  $ H$    AFL
	 H 	 #n  H$    H$    H$    H$    D$xH$0  H3S ($P  ($@  H`  A_A^A]A\_^[HUSVWATAUAVAWHxHH  HE()p)xD)@D)xD)hD)XD)HD)8D)(D)H} H3H  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,H HD$ L
 LD$@H	 H
	 kfE/w,H HD$ L
d LD$HH	 H
Q	 k̋  .HZ HD$ L
. L  H	 H
	 HHPHM諲IHPHM蚲E(D=e	 ,c	 T$@fn=a	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGHj HE 3HEHEH	 HEE HUHMǾ H  HE HM - HuIH0HD$XHHL$`HD$pHD$hHǅH     L@  ƅ0   A!   Hr 	 H0  VHH0  HP HH  HrSHH0  H=   r<t HAH;r H+Hs H'vu H HǅH     L@  ƅ0   AC   H H0  HH0  HP HH  HrSHH0  H=   r<t HAH;r H+Hs޾ H'vѾ H  b EAA   D5uk	 D-`	 @      G(D$ L
J	 DEH_	 H
	 IGHHHL$ L
W	 DG(H	 H
	 ,Ht$0IGHD$(AGD$ MOMHUH HMAu3H`  !HHMdHp   H`    H`  HD$@H`  L(HM0HHMH`  HMHh  HULL+t	HL HMHMHp  LELx  HMH  LHUNL+tH E艅  L`  
_	 H  7LHH0  EHHMHH@   H0   HM@ HM0 fEnEA( ^H`  HD$@H  HMոL
^	 H0  >HHMH`  HMHh  HULL+t	H HMHM茇Hp  LELx  HMH  LHUNL+tH E  L`  (H`  LHHM08HH<HM@ HM0ߺ H@  Ѻ H0  ĺ AƙA   A(LHI@  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(u)Ht$fff     X9HI;IDH;tHuWI*MyXZ^	 ^HT$X8  D(Hɼ HE`H HEpH    L$PE3HUxHM`V HE`HcHH HD
`HE`HcHhT
\HExHD$HHMx H HEx3H      PH  ) HH; HMpHHu3
H HcHHHW   H   HAH HH bHHu3
H HcHHHW   H   HHJHi HHu3
H HcHHHW   H  [ HA(H; HH] 
HHu3
H HcHHHW   H    HHH۴ HHu3
H HcHHHW   H  ʹ H(H HH G
HHu3
H HcHHHW   H   q HH/HN HHu3
H HcHHHWA(H5 o +Efn^5\[	 t$H3H0  H@  H8  WH0  H8  HtD	H8  HH8  HT$HH0  H;sLHT$HH;wBH\$HH+HH;@  u   H0  4H8  H0  HtHHH1H;@  u   H0  H8  H0  Ht1H8  H0  HH8  HT$@H;sLHT$@H;wBH\$@H+HH;@  u   H0  H8  H0  Ht;HH+H;@  u   H0  ^H8  HtDH8  HH8  IE L@H
\ H0  H;Iu8AfD/vH HMp
E2fE/vH HMp
E2AG D;~fE/wfA/vH HMp
HHU`HPE   A(A\A^ATf/V	    Hǅx     Hp  D`  Aa   H H`  HH`  HP H`  荔Hǅx     Hp  D`  AH   H H`  kHH`  HP H`  =H0  Ht%L@  L+IW0  H@  H   H    =U	 H}D;     Hǅx     3Hp  `  DCiHt H`  HH`  HP H`  芓Hǅx     Hp  `  DCBH H`  kHH`  HP H`  =E2AEu)LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtoHM HM HMw HMm H  H3 L$H  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH  Hǀ)p)xHm H3H$`  MLL$`EHHT$pLH$   H$   DD$XL$   3t$HE,H HD$ L
[ LD$XHW H
( +HǄ$     H$   @$  A   HA H$  IH$  IP H$  HrTHH$  H=   r<tͱ HAH;r H+Hs H'v H (Z	 $   (
iX	 $0  QR	 $@  
 V	 $   MHI6  $   IHPH$   ԢIHPH$   迢S	 $   
R	 $   R	 $   WL$xD$@ΉL$D    |$@ R
  Hc   $   $   A   Dd$hE;D  AAHǄ$     H$  Ƅ$   E3H H$  HǄ$     H$   Ƅ$   E3H H$  F    ELt$8H$  HD$0H$  HD$(E͋讝H$  HrTHH$  H=   r<t HAH;r H+Hs H'v H HǄ$     H$   Ƅ$   H$  HrUHH$  H=   r<t; HAH;r+ H+Hs H'v H= HL$pY($(  D$P;  MOMq\$PA;u1Lt$`Lt$0IGHD$(AGD$ MH$   E   H H$`  H$   |$HE3E3H$h  H$`   H$`  HcHH H`  H$`  HcHx\  H$h  HD$`H$h   Hƥ H$h  H$  Ǆ$     Hh H$`  H HHA HIH H HH$  H$`  H$  H$  HC$  HD$ L
 LD$PH H
 :
H H$`  H$   |$HE3E3H$h  H$`  P H$`  HcHH H`  H$`  HcHx\  H$h  HD$`H$h   Hp H$h  H$  Ǆ$     H H$`  HB HH HsHة H HYH$  H$`  褚H$  H$  HC$  HD$ L
1 LD$PH H
 3$   Dd$hL$   |$HH$   HD$pDl$XL$   Lt$`H$   Au:H$  辥HH$   H$   H$  T  H$  HD$PH$X  wL$   H$0  ^HH$   ~vH$  H$   H$  H$   LL+t	H H$   H$   6vH$  L$   L$  H$   H$  LH$   NL+tHm $   $  L$  $   H$  蕵LHH$  袳HH$   表H$   j H$  \ H$@  M H$0  ? fAn (^H$  H$   -L$   H$  蔴HH$   H$X  \L(H$  ɴLHH$0  HH\$pHH$@   H$0   H$   H$  s AċL$DMHI.  63$   L$   |$HH$   H\$pDl$XL$   Lt$`$   f/
  f/$      H$  艖H H$  HH HL$x HH Dd$DH$  AHw |H qIH$  IPHǄ$     H$  Ƅ$   E3H H$  IH$  IP H$  mD$@ H$X  KH$X     Dd$DA}$      f/$   9  H$  cH H$  HH\ HL$xؤ HH qIH$  IPHǄ$     H$  Ƅ$   E3H H$  IH$  IP H$  mD$@ H$X  KH$X   H$    $   D$xADd$DIWH$0  HHH$@   H$0   AL
 H Q  H$   } H$   o H$  ` H$   R D$xH$`  H3 ($  ($p  HĐ  A_A^A]A\_^[H\$
G	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI{  C(WQ	 C(H$   H$   H0HHD$XHHCH;t/H;t"H Ht
HoH3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
P	 fff     HD$X(WA)HH;}LD$@MHL$h HĐ   _^[@SH`HBHHD$(Hx uWY$E	 XB(H`[H HL$8HD$@HD$ HD$P YD	 XC(H`[@SH    Wf.HAxHH   zt9HhPYE	 \8E	 Y   X(E	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
HnHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pH] H3H$P  HHHL$0袏sxHe HL$@H(' H$0  HL$0ݍLHHAPH$H  HrUHH$0  H=   r<tz HAH;rj H+HsZ H'vM H| H$   莍H$   @ H$P  H3 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHMc| (Y
A	 XK(MHEHH#H      H;v
D	 (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   f/vH0   X|A	 (T H0  X  H;t/HSHNI HC(HF(HSHN4 HS0HN0' LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$hZ HMHLHT$hP(HH   HHHHPHKHHHSHL$h HHEHsH   HCH;t'H;tHa Ht
H|iHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h; H       D  HY(WEHt3 HhHEH] =4B	 } H  H[WEHt3g HhHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h7    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM0	7}H  L@LEWEMt3 HM&gHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHM׿ H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(
(Xu \
(XuuHUH(  HEf/w"\[ (H   Hhnf/vHE0H;tHU0HS6WEH]HHt3O HoeLHEH]LEHuHEHEHEHEH;t-I HtH/eLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM+ LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHMT LML   H   H   豌HM HM HM` HMH HM8 HM HM| L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   H'  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0d$  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0XM LLHHG%  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK    辩 HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_@SHpahHAHT%B	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$hi f/0  s0  ^W<B	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HM_oHHEH[IG3H;t'H;tI Ht
H-`II?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
iA	 f     HE(WA)HH;}LEMHM HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM{ (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM` Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHML H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHM
 Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM H(H;~uH>H;~IDHHMtLE'M+II,L$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHMw D(=2	 EtCH]H{ uA(HHEHEHEHM}l (A^H  HG     (A^}gH]H{ uA(HHEHEHEHM-l D^DG0DMWEWMHUH  HM HM HEgHEH]HuHOH;uHOMgIHHUGF (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   @SHpahHAHT%:	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h	 f/  s  ^W:	 Hp[HWH   H@HXHpHHHHL@@@HPHHq HsHG3H;t'H;tH Ht
HXHHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
9	 fff     HD$`(W)HH;}HL$(HL$8膷 HL$p L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$H D(5.	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;t'HHHt3 HVHD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0 E   LuI~ tIHD$PHD$xHD$`HL$Hf (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"Ho Ht
HUHH    H_H_LEHT$xHJ   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;tAHHHt3Ĉ HTHD$HH\$PH\$XLEHT$xHL$HG H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;tIIHGHH;t"H5 Ht
HPTHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$H ID$HEDMLeLeLEHT$xHħ HL$0p (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    H> HA@Hۀ HAPD$P   VH HH HG(HG@HcHHy HD9@HG@HcHQT9<HH>HH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    H HA@H+ HAPD$P   "UHy HH8s HG(HG@HcHHr HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHۥ HA@Hx HAPD$P   PHs HHOHyz HHG@HcPH_| HD:@HG@HcPDBDD:<HSHHDѿHH\$HHt$XH0_HL$AVH@HD$0H\$XHt$`H|$hMHH_  tH7MHH H[HHOH\$XHt$`H|$hH@A^HL$HH%	 LL$P)t$0LD$X3)|$ s52	 =L)	 Tf/vE  "   w&	 LL$PLD$X3sTf/v  "   )'	 LL$PLD$X3XsTf/v  "   3'	 LL$PLD$X3*sTf/v  "   U'	 LL$PLD$X3rTf/v  "   ?'	 LL$PLD$X3rTf/v_  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
k % 3Ld$xM+L$3IIHH+II;HCI;LCI萹H$   HH+LL$   HH-HIL$   L+ LGH3H$   IL+ HHGH+HHHtLGL+I KLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$p HOLD$pHH+$   HH+H,H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0x H$   ILkHGL+LI+HR H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(肸Ht$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
 E| H
} 7| LD$0H|$(IH+HHHDL$pHH 3HthH+HI;v H    H=   r=@tj HGH;rZ H+HsJ H'v= HHi (L\$PI[(Ik0Is8(t$@IA_A^_HSVWATAUAVAWH   HǀH)p)xD)@D)HH9 H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ Ht3} HIHD$@H\$HDd$8A܉\$4DN 	 fD  A;]  MuAA  ~1ID  H\$@MA(( ;HA;w |ۋ|$0LD$@H$   I袜HHL$@HHT$@HPHL$HHHHT$HH$   | H* H$   Ho H$   H$H  { |$0E3H$   H$   { H$   HcHHy H   H$   HcHh   H$   HD$hH$   x L5t L$   L$0  D$8  HT$@IM V  (D$hH$  H$   hHXH$  HrTHH$  H=   r<t| HAH;r| H+Hs| H'vs| H袓 HtHt$`HH$   HPt$pHD$pH      H#H;u+Hc HD$ L
 LD$hHS H
$ &DXDL$P\$4É\$4H$   HcHHnx H   H$   HcHh   L$   H$    H$   y H$   x H$H  y 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^IOHy t#HH$   H$   H$   腖(fAnw Y5h	 
@ AXYXAXHL$@y (H$  H3舊 L$   A(sA({E(CE(KIA_A^A]A\_^[HSVWATAUAVAWH  Hǀ@)p)xD)@D)HH_5 H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ(Ht3y H5EHD$@H\$HDd$8A܉\$4D	 fD  A;]  MuAA( ~1ID  H\$@MA((l ;HA;w(|ۋ|$0LD$@H$   I肀HHL$@HHT$@HPHL$HHHHT$HH$   Zx H{ H$   Hj H$   H$8  ew |$0E3H$   H$   $w H$   HcHHhu H   H$   HcHh   H$   HD$hH$   tt L5Lp L$   L$   D$(  HT$@IM   (D$hH$  H$   xdHXH$  HrTHH$  H=   r<t x HAH;rx H+Hs x H'vw H" HtHt$`HH$   HPt$pHD$pH      H#H;u+H HD$ L
 LD$hHӼ H
 !DXDL$P\$4É\$4H$   HcHHs H   H$   HcHh   L$   H$   蠝H$   *u H$   dt H$8  u 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^I|(AXHL$@u (H$  H3R L$  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pHI1 H3HEIHHE   3Hu@uDFnH HM~HHUHP@HEHrPHHMH=   r<tu HAH;ru H+Hsu H'vu HՌ HHPHE   HuE 8 uLIIB<  uHHMؐHHUHP@HEHrPHHMH=   r<t-u HAH;ru H+Hs
u H'v u H/ HE   HuE A   HB HMIHHUHP@HEHrPHHMH=   r<tt HAH;rt H+Hs~t H'vqt H蠋 HE   HuE Ah   HC HM躏HHUHP@HEHrPHHMH=   r<tt HAH;rs H+Hss H'vs H HE   HuE E3Hu HM.HHUHP@HEHrPHHMH=   r<ts HAH;rss H+Hscs H'vVs H腊 HMH3	 H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ IK  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HO:p HO0p HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;vp KHH=   r<tp HBH;rp H+Hs~p H'vqp HHH(陇 H(LHXICHfffffffH;vJH#x IC3ICICH ICD$0ISIKn H_ HD$8HL$8  Hu3KH;vl HHH   r&HA'H;wkl H҂ HH'HHA迂 HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"Hhn Ht
H:HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHMH HLFhLNH     HFH^HHEH~HCH;t+H;t"Hm Ht
H9HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
	 fHE(WA)HH;}LEMHM襘 H   Hǆ       H E3L\$pI[Is I{(I]/Hu EHEHU3HMHEHEH HEk Hi Hw
 HEHM @SH 3HHHAHAHt~H
H;vH
ߢ i HRH|$0H<    H   r#HO'H;wi ! HH'HHAH HHHKHHH|$0HKH [LALIIHQ I+HH;|
IH+HH+IHHAHtL+I||H\$WH HGY HHAPHI8tk HO jk HO`k H` Ht
   Hd HH\$0H _@SH HHIk HKH [H%k @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(OFE3EL9{~HN(HJJIL;S|HFXLFLN@HV(H5{	 WAE H^HH+^@HI;^tIi Ht
H5IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtH HH*Lg    cAE $   H$   H#H;t3@HN Ht+H 蕾HHc 膾HHf       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [HhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$PqD WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3f H2HLsHkHnH{ H|$hH|$hL?LHt3f Hc7 HHoHnH{0H|$hL?LHt3sf H2HHoC@   CD HHH HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	q uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
כ b HH|$0#HT$8HHFHHH\$@HNH+H>LH]d H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PH  H3HEpMMHHH   D$     HV HD$`HMc D$    E3E3HT$hHL$`c HD$`HcHHP HD`HD$`HcHDxDD\   HL$h觎HHL$`	HH HHHHŊ HIչHI)b HH边HUPHL$`SHxrH H
l HL$(3HL$0HL$8HD$@D$HHT$0HL$@b H^ HD$(H
 HL$(܆ @SH`W)t$Pf/D)D$0D(   u+DW	 3A(W	 (t$PD(D$0H`[d	 fA/DW	 A(v(
	 \((t$PD(D$0H`[3bX	 (t$PD(D$0H`[5	 fA/)|$@D)L$ D
p	 !  	 fA/vTfD.z   eH%X      HЋ9I   % AYDY1	 AX   eH%X      HЋ9 
  A(AY(Y((Y% (Y
 Yo X%_ X
w XG YYYg X%' X
? YX; XYX^X%k	 AY  3t
	 !	 fA/   eH%X   =@	 fA/   HЋ   9   A(A(\AYW	 (Y蠽 ((Yp (Y] (Y
 XB X2 A^X
} YYYX	 X
Q YYX(YR X
" X X* YX YX^Xj	 Y  q	 fA/   9 '  A(A(\AYW
	 (Y証 ((Y (Y (Y
" X X A^X
 YYYX X
 YYX(Y Xb X YXX
 ^X	 Y  	 fA/   9    A(A(\5~	 AY(W	 Y踻 ((Y (Y (Y
r X X A^X
E YYYX X
 YYX(Y Xz X YXX
 ^X 	 Y   9 Z  A(A(A^AY(YW	 ޺ ((Yv (Yc (Y
x XH X8 A^X
K YYYX X X
 YYYX X
 X(Y X YX YX^X Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
" o =  H
 e <o H
 o = ({	 H
t (
	 F 	 V (o	 X  
) (
	 J 
# n qH
 	o = V(9	 H
 (
	  (	  (	 
 (
q	  J 
 (
	  
 ,n H
 {n = (	 H
 (
	  (	 
 (
	  (	 
 (
%	  
 m [H
: m =. .(-	 H
 (
	 0 (A	 
2 (
C	 4 (	 
~ (
W	  
 0m H
@ m =4 (	 H
  (
		  (		   	  (	 
 (
'	  ( 
 (
j	  
 l H\$D$WH`)t$PI)|$@H(D)D$0 f/   (Ͷ f.zuZ   !   t  (E (Wf/	 WvW 胶 D(E3(LHXD\(a D\   f/vfWf.zo	 (
! Tf/v D(DW	     ^\ T D(   5 f/v$((\) \
 (E D(of/=3 r! f/v(+K 茵 D(DHL$pw D((Xz \ [ \e \= YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
 )t$P)|$@   HD)D$0D)L$ D(ȋ
9    DX
Z 5 D(A(AYD^A(A(AY蜴  EX
 YYA^X X
t D(L$ X(t$PYYXM X
= YY(|$@X  AYXX AYD(D$0\HhH
 i =  (C	 H
 (
	 ) (G	 )
 (
	 ) )
 "i H8eH%X   
a A   )t$ (HB9    (\5x \- (\- Y\-1 ((Y% (Y (Y
 X% X Y X
 YX YX% YX YX
 YYY(t$ XX` X%h X^YY- X(H8H
 Xh =  H
 (
)	 A (
	  (  ( 
 (
P	  I 
 (
S  
 kg HH   )xD)@D(DT	 D)HD(DT
	 D)PE(D)XD fE/D)`D(EYrA(A(A( (   + fA/A()$   rL (A(L =   M (A(M (XY= YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW=	 (($   HĨ   @WH  HD$PH$  H H3H$p  IHD$     HE HD$`H$   R D$    E3E3HT$hHL$`R HD$`HcHH? HD`HD$`HcHDxDD\   HL$h}H HL$`HHs HHHHy بHHͨHHqs 辨HHbs 诨H$P  HL$`AHxrH H
s[ HL$(3HL$0HL$8HD$@D$HHT$0HL$@Q HV HD$(H
 HL$(u H@Hx)p()xD)@D D)HD
 fD/D)PEWA(rPA(\(pĮ (\f/
= vAXfA.z   =1 Y(豮 ^fA.z   f/5 r
(ZX
 f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   Ht H
E D$   . L$   HN H
?  H  HD$PH H3H$p  D$     HB HD$`H$   O D$    E3E3HT$hHL$`O HD$`HcHH< HD`HD$`HcHxT\   HL$hzHx HL$`HHp HH2w HHv HHp ץHH ȥHHlp 蹥H$P  HL$`?HxrH H
}X HL$(3HL$0HL$8HD$@D$HHT$0HL$@N HS HD$(H
 HL$(r HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p5 )xWD)@D D)HD
 H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4CF H;}&HEHM(HE)HH;|LHMH HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ p E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   `K HHL$(rK H
 HL$(n @SH0HD$     zHH0[@SH0HD$       HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH 3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+I~Je  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHMLeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHM=LeHEH}IHtHHHEIM;w!H
S 
F H
E E H]3MtyIrTIƃIH+fo f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHMSHUHH?HMHthHEH+HH;vH H    H=   r<tH HAH;rH H+HsxH H'vkH H_ A   L}XI;      HVHHM
E3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HDHNHMKHHHMHt		H]L}X1L;Fu
   HDHNHMXHMHt
HU	H]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH0^ IL}XL;}s(F F F F F HtsL+IHL;vF J    H=   r=@tF HGH;ruF H+HseF H'vXF HH] IM H   IEH+HH?H;vF H    H=   r<tF HAH;rE H+HsE H'vE H] 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){Hw  H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0 f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   C V  H$  H$   aHL;   IM Ht~IEH+HHH;vtC H    H=   r<tXC HAH;rHC H+Hs8C H'v+C HZZ Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;vB H    H=   r<tB HAH;rB H+HsB H'vvB HY   H	F H$  L$  H$   H$  HD H$   H3 H$0  H$  m@ AD|$4E3H$8  H$   *@ H$   HcHHn> H   H$   HcHh  H$8  HD$XH$8  z= HR9 H$8  H$  $  ML$   H$  HL$PnH$  H$   x-HXH$  HrTHH$  H=   r<t A HAH;rA H+Hs A H'v@ H"X HtHH$   HPH$   HcHHP= H   H$   HcHh  HP8 H$8  H$8  fH$8  > H$@  = H$  q> HB H$   H1 H$0  H$  > AD|$4E3H$8  H$   A> H$   HcHH< H   H$   HcHh  H$8  HD$XH$8  ; Hi7 H$8  H$  $  L$   IHL$PE (H$  H$   +HXH$  HrTHH$  H=   r<t=? HAH;r-? H+Hs? H'v? H?V HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   HX H$  ZHH$  HP H$  HǄ$     H$  Ƅ$   A>   HZ H$  YHH$  HP H$  HǄ$     H$  Ƅ$   A4   H H$  oYHH$  HP H$  ?H$  !*H$  ; H$     H$  S+W$  H$  A> L$  L$   IHL$P= +fn^5 H$  H$  X)HXH$  HtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   HU H$  WHH$  HP H$  HǄ$     H$  Ƅ$   A8   H H$  WHH$  HP H$  rHǄ$     H$  Ƅ$   A4   Hq H$  LWHH$  HP H$  E2HI;EulMtL$  M+II|KH$(  'H$(  9 H$  'H$  d9 H$   薄Ld$`4  $   J  HǄ$     H$  Ƅ$   E3HgD H$  kVHH$  HP H$  ;H$  ~(H H$  蹏H(8 HH 螏HH$  HPH$  0(Y5? H H$  cHH THH EH(7 HH *HH$  HPHǄ$     H$  Ƅ$   A%   H8 H$  SUHH$  HP H$  #HǄ$     H$  Ƅ$   E3HC H$   UHH$  HP H$  HǄ$     H$  Ƅ$   E3HB H$  THH$  HP H$  }H$(  _%H$(  7 H$(  C%H$(  6 MtL$  M+IIHH$(  
%H$(  6 H$  $H$  6 H$   ҁD$HL$@T$2   H$  $H$  e6 H$   藁3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3H"A H$  SHH$  HP H$  H$  %H. H$  QH(4 HH 6H(4 HH HHu HȋT$@o4 HH HH$  HPHǄ$     H$  Ƅ$   Ae   H H$  RHH$  HP H$  H$(  "H$(  }4 HN> H$   3H$   H$   H= H$   Ƅ$   H$   H$   4 H@9 H$   Hy
 H$   X HL$pHIPH\$xHt(H$   HL$   L+IH[CH$   HtL$   L+I4IH$  H3FE ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH0
 H3H   (MLHT$`HL  L  H  3ۉ\$DH   "WD$HH\$XLL$HMIHd(H  H    HXH  HrSHH  H=   r<tx4 HAH;rh4 H+HsX4 H'vK4 HzK H   IH   IPH  H   > HLAH& H;t
HHAАH  HrSHH  H=   r<t3 HAH;r3 H+Hs3 H'v3 HJ W  Hǅ      t$(H  HD$ MMIHJ H  H   tHXH  HrSHH  H=   r<t3 HAH;r3 H+Hs2 H'v2 H J H   IH   IPH  H   HLAHe% H;t
HHAАH  Hr\HH  H=   r<tt2 HAH;rd2 H+HsT2 H'vG2 HvI H$ E3EDd$@H  HV H  H(^/ HH;tHPH  H  HLAH;t
HHAАH  HrSHH  H=   r<t1 HAH;r1 H+Hs|1 H'vo1 HH HH;tHPHǅ     L  ƅ   E3H: H  LIH  IP H  HrSHH  H=   r<t0 HAH;r0 H+Hs0 H'v0 HG IH  IPHǅ     L  ƅ   E3H: H  KIH  IP H  HrSHH  H=   r<t<0 HAH;r,0 H+Hs0 H'v0 H>G H  
   HL$hY, H  HcQH  HHP   H   ,, HH" H  讄HHuI
H HcHHHW   HM+ HH4 HpHHuI
H HcHHHW   HM+ HH H2HHuI
H HcHHHW   HMn+ HHT HHHuI
H HcHHHWH HȃH  H  HLAHV! H;t
HHAАH  HrSHH  H=   r<te. HAH;rU. H+HsE. H'v8. HgE IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
8  = Hp HEHh HEHMH
, L$DE3HUHM+ HEHcHH* HD
HEHcHhT
HEH   HM:) H% HE3HE0E8IHHH   
   HM) HMHcQHMHHP   HMz) LIHMb* HHu3
H HcHHIWA   HM>) LH   H* HHu3
H HcHHIWA   H   ( LB+H) HHu3
H HcHHIWA   H  ( LH) HHu3
H HcHHIWAB+\Hg) H   HMHLAH H;t
HHAАH   5IHUIPB+\Tf/vD$@HMHHMH) IHL|$`IGI+HL;H|$hH
x6Dl$@H  H\$HHX  HX  X) HX  HX  >) HtL  L+IH;HtLD$XL+IH:HX  ;HX  ( AH   H3: L$P  I[XA(sA({IA_A^A]A\_^]HWATAUAVAWH  HǀHXHp)p)xD)@LH5g EWWHHǀX    H`LhHǀp    Hǀx    H
HBH+HHucH1 HD$p3HD$xH$   Hb H$   Ƅ$   HT$xH$   9( H% HD$pHvb HL$p|HǄ$H     $   HBH+HHwcHb1 HD$p3HD$xH$   HWb H$   Ƅ$   HT$xH$   ' H5% HD$pHa HL$p   H$H  AD$hW$   E3L$   LcnxIMt*M;v
H
p^ *% IH$   
aL$   E3H$   L$   M;  IFI+HH;rcHg0 HD$p3HD$xH$   H\a H$   Ƅ$   HT$xH$   & H:$ HD$pH` HL$pHHH$H  I<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
P] 
$ HM+IIHIH+IE3I;LCL;ICH$   _L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
\ q# HM+IIHIH+IE3I;LCL;ICH$   *_L$   H$   L$   Ht:HH$   IH$8  m AX$   WD$pE3L$   Lcf,MtM;v
H
[ " IHL$p^MH\$xLt$pM;   H$8  (D$`HD$`H;sGHD$`L;w=H|$`I+HH;$   u   HL$p7H\$xLt$pHt5IH,H;$   u   HL$p7H\$xLt$pHt;HH\$xISM |   H~(DHH H
Z ۔HcH$   IL$   IH$   H+HHt0LD  A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r }   DHG H
G HcH$  IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;rݘ ~   DF,HV H
X nHcV,H$   -IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r    DF,H6V H
W 讒HcV,H$   mIL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rߋ   uoS    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  
HH$   3   ۖ    HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  詾HH$   X3H$8  HtL$H  L+Iv1A   HT D;f,`  -    IcLM+IHD$(D$    DEЏL   L+   IH
[T HL$(D$    D袏H   tAYtL$   L+$   IH
U HL$(D$    D^H$   t~    HS HD$(D$    DE'L   L+   IH
S HL$(D$    DH   tAYtL$   L+$   IH
T HL$(D$    D赎H$   tA   = f;~(      HcL$   L+$   IH
kT HL$(D$    DJL$   LR HH   LH$   H+$   HMNM+IHD$0H>B HD$(L6B H
3B v	MFM+IH$   I(L=R HH   BLH$   H+$   HMNM+IHD$0HA HD$(LA H
A MFM+IH$   I葏XAYtXL$  L+$  IH
A HL$(D$    DH$  tmAŋN(    ;}AD  ;}AŋN,f;}AD  ;}    Ǆ$      Dl$`L$   HT$`H$   d $   H$   H$       D$`   D$   LD$`H$   HL$h D$hHT$hH$   MK    Dl$`L   HT$`H$   % D$hHT$hH$   
     D$hDl$`LD$hHT$`H$    D$hHT$hH$       Dl$`L   HT$`HL$p D$hHT$hH$       HN`L$   H$   $   H$   H$   CH$   Ht(L$   L+IQ,W$   L$   H$   Ht(L$   L+I,W$   L$   H$  Ht(L$  L+I+W$  L$  H$   Ht(L$   L+I+W$   L$   HT$pHtL$   L+I+H$   HtL$   L+I^+D$   H$   H$   H$   q (H$   HtL$0  L+I
+(L$  I[8Is@A(sA({E(CIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@2 D($h  H^H+HWL$XLt$hHtHHHH;trHHHt3 H;HD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3 HHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$XHVH+HHL$pW5V D D$   =  fD/i  Y5E $   fD/  HL$pHHtmH$   H+HH;v H    H=   r<tw HAH;rg H+HsW H'vJ Hy/ HL$0U HL$XI HtqH$   H+HH;v	 H    H=   r=@t HGH;r H+Hs H'v HH. HtlHD$PH+HH;v H    H=   r<tz HCH;rj H+HsZ H'vM HHy. A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI̺(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;v H    H=   r<t HAH;r H+Hs H'v H, HL$0 HL$X HtqH$   H+HH;v H    H=   r=@tm HGH;r] H+HsM H'v@ HHl, HtlHD$PH+HH;v H    H=   r<t HCH;r H+Hs H'v HH+ (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(BHHT$(HPAEHT$(HHHHT$(P HL$(Ht HT$0-LD$8HT$(L+I!H\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHH莝HHT$(HPWD$@Hl$PHT$@H襫HLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$H^LD$PHT$@L+I WD$@Hl$PHL$(Ht.HT$0&LD$8HT$(L+I WD$(Hl$8H IIN L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
4LP  L8  L0  D  = HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn(m m ,H
Hp HD$@Hh HD$PHM H  E3HT$XHL$@ HD$@HcHH
 HD@HD$@HcHhT<HD$XHD$0HL$X

 H HD$X3HEEH HL$PfHcHMhq
 HL$PHcQHL$PHHPAHL$PT HH eHȋ  6    HMx
 HD$0Hό HL$PeHHu3
H HcHHHD$0HPfAnY^,H
 HHċ SeH (   HƮ HEHL$P0eHX  HHT$@PHD$@HcHH HD@HD$@HcHhT<H HD$XHL$XO6HL$X
 HL$`
 HM
 HX  L0  HLMHU@HPHIR  Hj HE@HMH     t5Ǚ  u(H@  HD$ LMI* LII;   D  D   H
q1L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  HH$  W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  HL8HL$pHHLxHL$xHHLxH$   H$  d HHL$p?H H$   WH$   ?H H$   H$  H H$  H$  H$  H$  H$    $(  (
 )$0  W$@  D$H  Ǆ$L     * $P  D$X  Ƅ$\   $`  H	
 H$   HT$pH$   菰$8  f/v	$0  $@  f/v f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H H$   H H$  H$   i
 H$   [
 H$   M
 H$   ?
 H H$   HL$p%
 H$   HtL$   L+I33HL$p	 H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHi
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p3HHL$tFW$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   WD$xH$   LLGIH$   HHHL$xHHHXH$   HHHXH$   H$    HHL$xHl
 H$   WH$   贫HU H$P  H$`  HF H$X  HD$pH$h  HD$pH$p  | $x  (
 )$  W$  $  Ǆ$      $  $  Ƅ$   $  H H$   WH$  .L5
 L$   L=8
 L$  HT$xH$   ޫ$X  f/v	$  $`  =m f/vf/v	$  $  $h  Oȉ$  Y
n (c $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   $ L$   L$  H$p   H$`  
 H$  HHa H$   Hz H$X  H$8   H$(   H$   H$    H3 H$   HL$x H$   HtL$   L+IF33HL$x^ H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  
HH$  	W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   WD$pLLGHH$h  HL8HL$pHHLxHL$xH$h  l HHL$pWH H$   WH$   H8 H$   H$  H9 H$   H$  H$  H$  H$  ( )$   (
 )$0  D$@  Ǆ$D     @ $H  D$P  Ƅ$T   W$X  Hd H$   HT$pH$   B$(  f/v	$(  $0  f/v+ f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     H) H$   H H$   H$   |  H$   n  H$   `  H$   R  H H$   HL$p8  H$   HtL$   L+I33HL$p  H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHy
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pC	HHL$tVW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   蓹WD$xLLFIH$   RHHHL$xHHHXH$   H$    HHL$xH H$   VH$   H H$8  H$H  H H$@  HD$pH$P  HD$pH$X  (5 )$`  (
V )$p  $  Ǆ$     ܡ $  $  Ƅ$   W$  H H$   VH$  aL5 L$   L={ L$  HT$xH$   $8  f/v	$h  $@  = f/vf/v	$x  $  $H  Oȉ$  Y
 (OY $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   5  L$   L$  H$X  N H$H  @ H$   {H H$   Hm H$@  H$(   H$   H$    H$    Hf H$   HL$x H$   HtL$   L+Iy33HL$x H$   HtL$   L+IGN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3 HHHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHMyg H H]HL$x#HEHL$xHMHT$pLL+t
H|U HT$pWEH WEHE    HM肃HHUHPAEHUI2IE HUIP HMHtHUqLEHUL+IH]HMpHEHMHMHULL+tHT EEfEMLHUHM
| D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H    +fDnED^ HMEH   HIP  H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H    b +fn^5P LM(A(xLM(A(h(A(HMH` HEHM L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  [c II耥  L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   Zb H H$   H$   H$   H$   H$   HT$xLL+t
HKP HT$xW$   H H$   LMH$   H$   H$   VLMHH$   P D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I B +fDnED^- Aƅ    A   YO AExH$   lH$   I,QIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4v +fn^5d L$   (A(舃L$   (A(t(A(H$    Hh H$   H$     H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  
HH$  W$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   =WD$pL$   LLFIH$  HL HL$pHHL`HL$xHHL`H$   H$   HHL$pqH) H$   VH$   qH H$   H$  H H$  H$  H$  H$  H$   3 $(  (
Ö )$0  W$@  =ϑ $H  $X  Ǆ$P  
   H3 H$   HT$pH$   ٓ$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H H$   HN H$  H$    H$    H$    H$   ~ H H$   HL$pd H$   HtL$   L+I33HL$p2 H$   HtL$   L+IN   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pWHHL$tjW$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   触WD$xH$   MLFIH$   HHHL$xHHHXH$   HHHXH$   H$    IHL$xH H$   VH$  ؎Hy H$`  H$p  Hj H$h  HD$pH$x  HD$pH$   $  (
0 )$  W$  =< $  $  Ǆ$  
   H H$   VH$  hL=i	 L$   L%z L$  HT$xH$  $X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y
 (KF $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   9 L$   L$  H$x  B H$h  4 H$   oHP H$   H H$h  H$H   H$8   H$    H$   HZ H$   HL$x H$   HtL$   L+Im33HL$x H$   HtL$   L+I;N   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   !WD$pLLFIH$h  HH     HL$pHHH@    HL$xH$h   HHL$puH% H$   VH$   %HV H$   H$  HW H$   H$  H$  H$  H$  ( )$   (
ي )$0  =ч $@  W$P  Ǆ$H  
   H H$   HT$pH$   x$8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H H$   H
 H$   H$    H$    H$    H$   } H H$   HL$pc H$   HtL$   L+I33HL$p1 H$   HtL$   L+IN   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pWHHL$tjW$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   觜WD$xLMFIH$   fHHHL$xHHHXH$   H$    HHL$x H H$   AVH$   H H$H  L$X  H H$P  HD$pH$`  HD$pH$h  (H )$p  (
i )$  =a $  W$  Ǆ$  
   HJ H$   AVH$  L=" L$   L% L$  HT$xH$   $8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
 (l< $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   #H$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$   j
 L$   L$  H$`  c H$P  U H$  萾HA H$   H H$P  H$8   H$(   H$    H$    H{ H$   HL$x H$   HtL$   L+I33HL$x H$   HtL$   L+I\N   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H詨I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KJ IIp  L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JI H H$   H$   H$   H$   H$   HT$xLL+t
H;7 HT$xW$   H~ H$   LMH$   H$   H$   FhLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^~ Aƅ    A   I6 AExH$   \hH$   I8IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$f +fn^5T} L$   (A(xjL$   (A(dj(A(H$   oHX H$   H$   z  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[HWATAUAVAWH  HǀHXHp)pH
 H3H$p  MLL$xL$   H$   HL$@H$  H$   H$  H$   L$  L$  H$   H$   D$0    HX` HHHJ` H;;` r
   'HHL$8Ht
J| -/H3D$8P   E$HT H
XV GIc$HL$`3LD$hIHL$`H+HHt-@ f     HHLD$hIHL$`H+HH;r3L+IMtfHHHD$hHL$`H+HH;rD$8Q   DHuT H
T FHcHL$Hx3HD$PH|$HH+HHtHHHD$PH|$HH+HH;r3HD$PH+HHtHHHD$PH|$HH+HH;r   5Ń H
BU A;4$   D$8T   HcMFM+IHL$(D$    DIEIL<MEM+E IH
u HL$(D$    DEMu LD$hL+D$`IH
U HL$(D$    DDH|$`ALWMGH$   |>H HDH|$HLt$x.A   Ll$xH*H$   D;8  D$8W   IcH$   L HHI+HHHHHH?H  F;  HCH@IH$   L LpM+I-  AF;!    F;  H[M4Ht$PH+H   F;   LD$`H$   `
  LH$   HL$x5HMIVH$   4
  LH$   H$   \5ATHH$   U<LHH$   25H HDAH|$HH H$   H H$   H$x   D$0   E3H$   H$    H$   HcHH H   H$   HcHh   H$   HD$@H$    H H$   3H$`  $h  H H$   (   H< H$  H$   ׿L$  H$  LC$  HIQ HD$ DËF?H H$  H H$  H$x   D$0   E3H$  H$  g H$  HcHH H  H$  HcHh  H$  HD$@H$   H H$  3H$`  $h  H H$  '   H H$  H$  课L$  H$(  LC$  HO HD$ DË>H H$  H H$  H$x   D$0   E3H$  H$  ? H$  HcHH H  H$  HcHh  H$  HD$@H$   Hg H$  3H$`  $h  H H$  &   H H$0  H$  臽L$0  H$H  LC$0  HN HD$ DA<H H$  H H$  H$x  X D$0   E3H$  H$   H$  HcHHZ H  H$  HcHh  H$  HD$@H$  f H> H$  3H$`  $h  H H$  a%   H H$P  H$  ^L$P  H$h  LC$P  H@M HD$ DË;D$8Z   HT$HH|$@Hb HL$HHHtyHD$XH+HH;v H    H=   r<t HAH;r H+Hs H'vu H WD$H3HD$XHL$`HtiHD$pH+HH;v; H    H=   r<t HAH;r H+Hs H'v H! HH$p  H3 L$  I[8Is@A(sIA_A^A]A\_H\$WH@LIL3 L+	HHBH
2 H+HHHD$0H IHD$(膸HK3H+HHt%@ HHHHHHKH+HH;rH\$PH@_HLH L@HPHHSVWATAUAVAWH   Hǀ()pMMLD$p    HU HHHU H;U r
   HH$  Ht
q $H3Ǆ$  9   H$  DHK H
L <HcHL$@i3LD$HIHL$@H+HHt-@ f     HHLD$HIHL$@H+HH;r3L+IMtfHHHD$HHL$@H+HH;rǄ$  :   H$  DH"K H
K *<HcHL$X轒3LD$`IHL$XH+HHt!HHLD$`IHL$XH+HH;r3L+IMtfHHHD$`HL$XH+HH;rǄ$  <   H|$(H$  HD$ MMIH$     HHHH+HLL$HL+L$@IHL$0Hp HD$(Lt H
} 3HD$HHT$@H+HHt,     HHHHHD$HHT$@H+HH;rH$   HtL$   L+I[   L$  5Nm L=J LtJ I*;>  Ǆ$  >   HcIMI+M IHHHH?HLD$(D$    DD9H[IE H4L$  MFM+IL|$(D$    DP9M>IMI+M IHHLI?LHnJ HD$(D$    D9H[IE L4L$  MD$M+$IH
QJ HL$(D$    D8I$HD$xLD$`L+D$XIH
fJ HL$(D$    D8Ld$XLD$@HVH$   *  LH$p  H$   R*LALH$   .HL$x  IVH$     LH$h  H$   *HH$   3LHH$   D0HH$   KL(H$   !+LHD$xLH$   F-H IDH$  Ǆ$  A   HT$XL$`  Io  HL$XHHt{HD$hH+HH;v H    H=   r<t HAH;r H+Hs H'v H WD$XHD$h    HL$@HtiHD$PH+HH;vF H    H=   r<t* HAH;r H+Hs
 H'v H, I($  H   A_A^A]A\_^[@WHPHD$@H\$hHt$pIHHI@I+ HLJL+
IHD$0H\ HD$(LT H
Q 蔱HMO HH0H?O H;0O r
0   HHL$`HtHLOL+ILE  3HHH\$hHt$pHP_@SH0HD$     HH0[HWATAUAVAWH  HD$pHXHp)pH
 H3H$  MMHHL$8L$`  L$h  D$4    D$0   EHF H
F 5IcHL$X蕠3LD$`IHT$XH+HH      Ht/L@      IHLD$`IHT$XH+HH;r3L+IMtfHHHD$`H+D$XHH;rD$0   EAH)e H
&F %5AHcHL$@E3HL$HHHT$@H+HHt&L KIHL$HHHT$@H+HL;rE3HH+HHt.Lfff     KIHL$HHHT$@H+HL;rD$0    H+HHE HD$(D$    A   D3HHD$@H   H
lE A;   D$0"   HcLD$HL+D$@IHL$(D$    D13Ht$@MFM+IH
>E HL$(D$    D3ItXtHcLD$HL+D$@IH
D HL$(D$    D2HD$@tHAU    A9  Lt$`HT$X%e D$0(   HcI|$I+<$Hm  G;b  M$H|$HLD$@I+H  G;  Hc  G;  ADA^D(\AL\YL+Is  AF;g  \D$0)   Lt$`IHT$XH+H|G;}XTA;  Hy H$   Hb H$   H$  4 D$4    E3H$   H$    H$   HcHH6 H   H$   HcHhT|H$   HD$8H$   E H H$   3H$   $  H H$   @   H H$  H$   =L$  H$  LC$  HD HD$ DË-HT H$  H= H$  H$   D$4   E3H$  H$  Ϳ H$  HcHH H  H$  HcHh|  H$  HD$8H$   H H$  3H$   $  H] H$     Hz H$  H$  L$  H$  LC$  HoB HD$ DA,H+ H$  H H$  H$   D$4   E3H$  H$   H$  HcHH H  H$  HcHh|  H$  HD$8H$   H̷ H$  3H$   $  H4 H$     HQ H$  H$  L$  H$  LC$  H@ HD$ DƋ[+H H$  H H$  H$   D$4   E3H$  H$  | H$  HcHH H  H$  HcHh|  H$  HD$8H$  ̺ H H$  3H$   $  H H$     H) H$  H$  ĪL$  H$  LC$  H>? HD$ DË3*H H$  Hį H$  H$   D$4   E3H$  H$  T H$  HcHH H  H$  HcHh|  H$  HD$8H$   H| H$  3H$   $  H H$     H H$  H$  蜩L$  H$  LC$  H\ HD$ DË)D$0+   HT$XHt$8H0HT$@Ht!LD$PL+IWD$@3HD$PHT$XHtLD$hL+IHH$  H3 L$  I[8Is@A(sIA_A^A]A\_H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtH  uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
& I   LNB	9JC   HII9H3H-eB HLL%bB HL=`B H;1HLH0  HEH?L   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
@A  =4A H
[@ H
A  Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05Q[ f     IM(W Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05Z f     IM(WO Hv;}(|(t$0Ht$hH\$`MHT$ H`IHHIINHPHHHL$ IVA Hl$pH@A_A^_H   "A)(YZ ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YYZ Y=Z \A(Y(Z ^X^^A(\AX(YY\U H$   (DY XDX (\D H$   A(YA(^Wc (YA^A^XX^YWc AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM1  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHK$HH@  HEHCHEHLL+ty E3EH  D=va D5V @ f     H   H HEuIHEI^HGH;t'H;tHs Ht
HHL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHM LMHH   H}HtAXAY
HuLuI~ uA("HHEIHEHEHEHMF/  (A$A(H   YH(  X	f/   fA/r	E   (T
_ A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHFܱ D(Y5U A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(Q H\$    LMHH	 DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(HYl
 H3H$X  MMHHH$  H\$ HL$0ӞH$0  HD$@H$8  MMHH$0   H$0  HL$0HxH$H  HrTHH$0  H=   r<t HAH;r H+Hs H'v H HtHHT$0HPH$   譜H$   _ H$X  H3 H`  A_A^_^[HL@SVWATAUAVAWH  Hǀp)p)xHk
 H3H$  IH$(  LH$0  H$  H$X  H$   H$`  H|$PA D$ L
a DB Hv H
W 
HCHD$ L
r EE H/ H
0 Ic] W$   Ht3f HzHH$   H$   H$   W($   HL$XHD$XH$   H$   H$   HD$0H$   H$   H$   HHH+HHHE3AH~!f)HH;}$   HL$XLH$    Ic] WD$8Ht3 HyHHD$8HL$8H\$@(|$XH$   H$   H$   HD$XH$   HD$0H$   HD$8H$   HHH+HHHIH~'fD  f)HH;}D$XH$   LH$   ? Ic] W$   Ht3 HxHH$   H$   H$   (|$XH$   H$   H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$   _ Ic] W$  Ht3٫ HwHH$  H$  H$  (|$XH$   H$   H$   HD$XH$   HD$0H$   H$  H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$    Ic] W$   Ht3 HwHH$   H$   H$   (|$XH$h  H$h  H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$h  LH$    EDt$4D$   5L I      @      $P  D;  AA}  ~LIL$   fff     H$  M((z HA;u |I      H|$PL$  H$   I"HH$   HH$   HPH$   HHH$   H$   N H$  ؗH$@  H$x  H$  H$  L$   L$   H$   H$x   H$  H$  HXH$  HtHH$  HPIL$   L$    I;sQHcA$   H$   I#I;u*H HD$(LL$   H; H
 VHL$  H$   H$   H$   H$   H$  H$   HD$HH$   H$   H$   L$   IHH+HHHIH~-@ A(fX)HH;}L$  H$   MH$   d LD$8L$   L$   L$@  L$  L$P  HL$8HL$hHD$hH$  H$8  H$  HD$1H$  H$   H$  LT$@IHH+HHHIH~?     A(fAY(fX)HH;}L$P  L$@  HL$hMH$  ) ADd$4H$8  H$8   H|$PE3Dd$4WL$0  H$  H$(  H|$P@fn(T$hH$   H$   H$   H$  HD$hH$  HD$1H$  H$   H$  L$   IHH+HHHIH~.f(f(f^)HH;}D$hH$   H$   T$hHL$8H$   H$   H$  HD$hH$  HD$1H$  HD$8H$  LD$@IHH+HHHIH~,(f(f^)HH;}T$hH$   H$  & HD$8HD$PHL$8H$@  IMH$X  IUH9T$@tA   HL$PH HD$PHHL$hHL$hH$  H$8  H$  HL$1H$  HL$PH$  HpHHH+HHHIH~J    H$X  ()$   H$    H$@  (fYHD$h)HH;|LHH$  C HD$8H$  t$hHL$8H$   H$   H$  HD$hH$  HD$1H$  H$  H$  LD$@IHH+HHH~6     (fB(fXB)IL;}t$hH$   HH$  b H$   H$(  ݳHT$8H$(  KH$   $ H$   H$    HL$8 H$    H$  H3胳 ($  ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
  HMLM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMLMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMfLMHMLEHtHHLMLEHMHHMHHcI;F}!H
p * H
b  WEHE    LEHUI  (HMH   HEH+HH?H;vc H    H=   r<tG HAH;r7 H+Hs' H'v HI WEHE    HMHthHEH+HI;v H    H=   r<tƠ HAH;r H+Hs H'v Hȷ (L\$pI[ Is(I{0Mc8(t$`IA_A^]HL@SVWATAUAVAWH  Hǀp)p)xHE[
 H3H$h  IH$   LH$   H$   H$  H$   H$   H$   A(D$ L
 DB(H H
 /HCHD$ L
 EG(Hl H
 
Ic_(W$   Ht3 HjHH$   H$   H$   W($@  H$   H$   HD$8H$@  HD$@HD$0HD$HH$   HD$PHHH+HHHE3AH~&ff)HH;}$@  H$   LHL$8O Ic_(WD$XLt$hHt?HHHHH;tHtHHHH;tHHHt3| HiHHD$XHL$XH\$`H\$h($   H$@  H$H  H$@  HD$8H$   HD$@HD$0HD$HHD$XHD$PHHH+HHHIH~$f)HH;}$   H$@  LHL$8/ Ic_(WD$pHt3 HhHHD$pHL$pH\$x($   H$@  H$@  HD$8H$   HD$@HD$0HD$HHD$pHD$PHHH+HHHIH~1@ f     f)HH;}$   H$@  LHL$8_ Ic_(W$   Ht3ٛ HgHH$   H$   H$   ($   H$@  H$@  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$@  LHL$8 Ic_(W$   Ht3 HgHH$   H$   H$   ($   H$  H$  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$  LHL$8蟿 EDt$4D$   5< I      @      $  D;  AA( ~GIL$   fff     H$   M((z  HA;w(|I      L$   HT$8I芡HH$   HH$   HPH$   HHH$   HL$8Y H$@  H$  H$(  H$P  H$0  LL$pL$@  H$   H$(   H$@  H$@  HXH$@  *yHtH$   HH$@  HPILL$xLD$pI;sNHcA$@  H$@  I#I;u'H HD$(LLD$pHM H
V FHL$  H$   H$   H$   H$@  H$  H$H  HD$1H$P  H$   H$X  L$   IHH+HHHIH~/fD  (fAX)HH;}L$  H$   MH$@  T AA( c  MfD  MM?  MYICH   A   IHT$`IHL$XHD$pBH$   BYXIRHT$`IHL$XHD$pBH$   BYDXIHT$`IHL$XH$   BDHD$pBYXIRHT$`IHL$XHD$pBH$   BYDXIIM;M;<IHT$`IHL$XH$   BHD$pBYXIM;~IA;_(ADl$4H$  aH$   
E3Dl$4WL$   H$   H$   fn($   H$   H$  H$  HD$8H$   HD$@HD$1HD$HH$   HD$PL$   IHH+HHHIH~/(f(f^)HH;}$   H$  HL$8V $   HL$XH$   HD$`H$   H$   HT$8H$   HT$@HT$1HT$HHT$XHT$PLD$hLIHH+HHHIH~2 (f(f^)HH;}$   H$   HL$8 IIwHT$XL\$`HD$hH$   L$   H$   L$   I;IMLL$@  I   I@H$   LfIMkIL6OLHMIHHH$   fD  (A^XKIII(^DXDDKK(^DXDDJ6I(^DK3IXDDIJ    LH    LIML;$   H$   XL$@  M;}BN   H4   IIHHIHM+(^X  HIIuH$   H$   ԉHT$XH$   貊H$   ˒ H$    HL$p HL$X H$    H$h  H3- ($  ($p  HĐ  A_A^A]A\_^[H   HD$ HH$     HHL$(  H
 HL$(臵 @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@q  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQH g HC(HCH;CuHHCHC H0[@SH H@  H HC`H [HL$SH0HD$ HD$P    EtH HAPHÊ HA`D$P   J   H HH HC(HCPHcHHn HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHH. HHQ3HHBHO H HHGHFHG HF H^(H\$HHB HHO0HKHtHPHG8HCHG@HCGHC Hy HH~ HHH\$PHt$XH0_H\$WH HHt HHQ3HHHKHBߎ H@ HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tH Ht
H1[HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@  IFL\$`I[(HEIF HE HIk0IA^_^@SH H{ HHHz HAhHIH0 HK8& HK  HK H HH [@SH Hs HHH. HA`HIHЍ HK8ƍ HK  HK H; HH [@SH Hw HHHz HAhHIHp HK8f HK \ HKR Hۂ HH [@SH H+ HHHn HA`HIH HK8 HK  HK H{ HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3HW(HK(HA   HA    HyrHH  IE3˩HH\$HH0_@SH H  H HCPH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   J   Hy HHA HCHC@HcHH} HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK H{ HH{3HHDH^H\$HH5 HHOHKHtHPHGHCHGHCG C Hy HHhv HHH\$PHt$XH0_H\$WH H<:  H} HG`t
h   H觢 HH\$0H _@WH0HD$ H\$@HHpt HHv HA(HI0HtHP tHC0    H HHK @t
P   H( HH\$@H0_H\$WH H  H HGPt
X   H HH\$0H _@WH0HD$ H\$@HHw HH HAHI HtHP tHC     H8 HHK# @t
@   Hh HH\$@H0_LH   ICAC    HQHK ICH ICAC   IK{Hv HD$(Hp HD$@HD$hHcHHz HDhHD$hHcHDd    H
 HL$( @SH0HD$ HٹX   | HD$@HSHC  HHtH@@HcHHB@HH0[@SH0HD$ HH7v HH HAHA@HcPH2z HD
@HA@HcPDBDD
<H-v HH HAHI HtHP tHC     H HHKH0[H%z @SH0HD$ HHu HH HAHI HtHP tHC     H/ HHKH0[H% HVWAVH`H@HXHhHC
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHKQ HD$(N HHL$ )tHB    HL$ OHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
'r H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHB  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HA  HL$8eHL$(HtHPHtL    HA2HL$XH3 L\$`I[(Ik0IA^_^HVWAVH`H@HXHhHA
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK L HD$(I HHL$ $tHA    HL$ MHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
"p H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHA  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2H@  HL$8cHL$(HtHPHtL    HA2HL$XH3  L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH>  (H8H} HH_(H    H
	 HHH H; rOHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HH HHH H; rHHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   W   ^   ,A;ALǉ   LCHSHH  OgtUHH?        ^,A;ALǉ   Y" t    H   H   HH\$PHl$`Ht$hH0A_A^_@SH HCz HHHp H   Hp  :~ H`  -~ H  i^H HH`v HC`HKH~ HK8} HK } HK} Hms HH [Wf/v(      ^   ,;L   H\$WH HHH   HYH   HYH   HH\$0H _XHHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J=  HSHH_HG`LGpHHO`P8LHHO`yHHL$@s(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;v	! \( (= f/vNHOxf/v?HD$@H;t5HKHT$HD$hC(HKHT$XHK0HT$p]s(HHO`Y  X   w0HQ| I$I\$H$   HOGHHHGHCHWHGLL+t W5( At$A|$ HL$p+{ HL$X { HL$H{ IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   R   ^   ,A;ALǉ   LCHSHH  [tUHH@I        ^,A;ALǉ   Y#     H   H   HH\$PHl$`Ht$hH0A_A^_@SH H HHH~ H   Hx  y Hh  y H   YHc HH f HChHKHby HK8Xy HK Ny HKDy Hn HH [Wf/v(      ^   ,;L   H\$WH HHH   HqTH   HbTH   HH\$0H _ITHUSVWATAUAVAWHhH(  HE)p)xD)@HR4
 H3HEMILH3t$8F  HSHH_HGhLGxHHOhP8MHHOhHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PD DD$XLD$`HL$pLD$xHEHEHT$@HM   HE XC(D$0HHD$0H#H      H;v$ \( (= f/vLH   f/v:HEH;t1HKHUEC(HKHUHK0HU]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM:  HE XC(   w0H9w IE I]H\$0HOBHHHGHCHWHGLL+t W5# AuA} HMv HMv HMv IHMH3蟆 L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   MLGHWHH  ]t8HH6     YN     H   H   HH\$PHl$`H0A^_^@SH Hj HHHVo H   Hx  t Hh  t H   TH2n HHl HC`HKHt HK8t HK ~t HKtt Hi HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=i H(Vc(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_cH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@@ HL$0r L$   HHH$   ($   HĠ   _zHl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]XF ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3q H=HHkHF@HD$hHFHD$xHv H;t'H;tHq Ht
H=HH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@ HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Y H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWYT H   H	H H$   HD$@H$   H$   H$   H$   < Y H   Wf/vw f/v   Wf/v   H\$WH HH4  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHJfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H諁HSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   H"HSHt
HHH
HJ$H;Cu
   HHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H薀HSHt
HHH
HB$H;Ku
   HjHCHt0HH   HCH;s;HH;w3H+HH;Cu
   H'HSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    ,  HSI+I^IF`MFpHIN`P8MHIN`HHMHUH   HUHM0HUH   IF`LHUIN`P(HM7HE HMHM(HULL+tHX HM7HEHMHMHULL+t	H. IN(7HD$xIN(HMIV LL+t	H EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      D DJ
 D%
 D-H H}WD$hHt3j H6HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM蒏 DUINxfA/  HEH;   HcuH;st$HKi tH
6HCHC    Hs~LEN    HUHKW EC(Hcu H;s t$HKi tH5HCHC    Hs ~LE N    HUHK HcuHH;s8t$HK0Ci tH_5HC0HC0    Hs8~LEN    HUHK0 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I.  HEH;  HSHMgC(EHSHMPHM   H   H;t=HKH   +   C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I-  H   H;t=HSH   C(   HSH   fH   HS0V@  A   uf/w(\ (INx3f/v=H   HM8
   EXH   HMHH   HM`f/v\(X(\((XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHM=# HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$he A   A9   HL$hue Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0W IV(HHL$xd HMd HM d HMd H   d H   d H   d HM`~d HMHtd HM8jd H   \d H   Od H   Bd HM7d HM-d HM#d HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   ;LGHWHH   
Et8HH^2     Y^     H   H   HH\$PHl$`H0A^_^@SH Hf HHHVf H   H  b Hp  b H(  	CH"P HH@O HChHKHb HK8b HK b HKb H
X HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=y H(fQ(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_!QH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@P HL$0` L$   HHH$   ($   HĠ   _銼HWH   H@HXHhHp )pIHHz W@Ht3` H,HD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrB  H$   H$   HD$8HD$(HD$@HMHT$8T HL$H ` HL$(_ L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3_ H+HHoIvHH;t'H;tH\_ Ht
Hw+HHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   " HIFHD$pHD$x   INHIF@H$   H$   e D$0HT$ LL$pL$   IVP HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   Y H$   \(t$pHĀ   _   LH   H
 H3H$   HB LB IKICH@D$@ICISISMCMCIC  HD$h H$   H3m HĘ   Wf/v f/v   Wf/v   H\$WH HH+0  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HH78fn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H+oHSHt
HHH
HB$H;Cu
   HnHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HnHSHt
HHH
HJ$H;Cu
   HvnHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HnHSHt
HHH
HB$H;Ku
   HmHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HmHSHt
HHH
HB&H;Cu
   H{mHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w(  HSI諷I^IFhMFxHINhP8MHINhfHHMzHUH   iHUHM0[HUH   JIFhLHUINhP(HM}%HE HMHM(HULL+tHص HMS%HEHMHMHULL+t	H讵 IN((%HD$xIN(HMIV LL+t	H肵 EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      D+ D D%Q D- H}WD$hHt3NX Hn$HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM} DUI   fA/  HEH;   HcuH;st$HKkW tH#HCHC    Hs~LEN    HUHKԳ EC(Hcu H;s t$HKW tH.#HCHC    Hs ~LE N    HUHK{ HcuHH;s8t$HK0V tH"HC0HC0    Hs8~LEN    HUHK0) Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I*  HEH;  HSHMC(EHSHMͷHM   H   H;t=HKH   訷   C(HKH   苷HK0H   {Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I)  H   H;t=HSH    C(   HSH   H   HS0Ӷ@  A   uf/w!(\薱 (I   譯f/v=H   HM8臶   EXH   HMHjH   HM`Zf/v\(xX(\(c(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$hS A   A9   HL$hR Hx  D$`A   fn}^HE0H;t1HKHU8蒴EXC(HKHUH{HK0HU`ns(HINhXA   AV0W#  IV(HHL$xPR HMER HM :R HM/R H   !R H   R H   R HM`Q HMHQ HM8Q H   Q H   Q H   Q HMQ HMQ HMQ HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQHSU ICHK ICAC   IKH,p HD$(HQ HD$PHD$xHcHHE HDxHD$xHcHDt    H~	 HL$(2t @SH0HD$ Hٹh   d HD$@HSH-  HHtH@PHcHHBPHH0[@SH0HD$ HHoo HHQ HA(HAPHcPHD HD
PHAPHcPDBDD
LH-: HH3R HA(HI0HtHP tHC0    HX HHKH0[H%O @SH0HD$ HH9 HHQ HA(HI0HtHP tHC0    HOX HHKH0[H%4O HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  D fA/  HGPLG`HHOPP8MHHOPuH轫(HGHLd$ _xLGPHHOHH藫EPHHEPH#H      DN H;vA(\  D(ȃ   f/GLcD} D  HD$pH;t2HKHT$xEC(HKHUѯHK0HUįHGPLG`HHOPP8MHHOP胩HsHt$8H~ u(HHD$PHD$0HD$`HL$H* (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$HM* AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$xzEC(HKHUcHK0HUV   HBU HD$03HD$8HD$@H HD$HD$PHT$8HL$HK H!I HD$0H
	 HL$0o HT HD$03HD$8HD$@H HD$HD$PHT$8HL$HAK HH HD$0H	 HL$0:o HMK HMK HL$xK L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PHkk HA@HE HAPD$P   _H/9 HHOH	@ HHG@HcPHA HD:@HG@HcPDBDD:<HSHHDaHH\$HHt$XH0_H( ?T8 f/h w* !T f/J w H
 H(He H
 a2 HQ H
 M2 H(
  T f/ w2
F  T f/ wH
 H(HՒ x3  HȒ k3  HL$H( LD$0HT$8@T) f/Y vYJ  "   k LD$0HT$8T f/% v%J  "   O LD$0HT$8T f/ vI  "   H]
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+HxH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH
*HSHt7HHH
HCH\$0H _H;CuH)HKHtHHHCH\$0H _H\$WH H\t
  H_ HH\$0H _H\$WH He HHH? HA`HIHjG HO8`G HO VG HOLG H< Ht
   HP_ HH\$0H _H\$WH H<t
  H_ HH\$0H _H\$WH H0 HHHH3 HAhHIHF HO8F HO F HOF H< Ht
   H^ HH\$0H _H\$WH HLt
  HR^ HH\$0H _H\$WH H? HHHH> HA`HIHE HO8E HO E HOE HU; Ht
   H] HH\$0H _H\$WH H|t
  H] HH\$0H _H\$WH H2 HHH1 HAhHIH*E HO8 E HO E HOE H: Ht
   H] HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PHd HA@Hx> HAPD$P   H2 HHOHH HHG@HcPH6 HD:@HG@HcPDBDD:<HSHHD~HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt3{A H
HEH]WEHt3VA Hv
HEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軼(HM? HM? (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9Hx]Y \E Y   X5 Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`   EWfA.z  D
c fA/  HG`LGpHHO`P8MHHO`7s(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      D H;vA(\ 迚 D(   f/GHcD%" HD$`H;t3HKHT$h蒟EC(HKHT$xzHK0HUmHG`LGpHHO`P8MHHO`,s(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$hhEC(HKHT$xPHK0HUC   H/E HD$H3HD$PHD$XH HD$8D$@HT$PHL$8; H9 HD$HH	 HL$H~_ HD HD$H3HD$PHD$XH HD$8D$@HT$PHL$8.; H8 HD$HH	 HL$H'_ HM; HL$x; HL$h; L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pH	 H3H$P  HHHL$0)   Hb HL$@ؐH($9 H$0  HL$0'LHHAPH$H  HrUHH$0  H=   r<tw; HAH;rg; H+HsW; H'vJ; HyR H$   'H$   =9 H$P  H3J H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
/ (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   Wf/vH0   X (z H0  X  H;t/HSHNoHC(HF(HSHNZHS0HN0MLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h7 HHEHsH   HCH;t'H;tH7 Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h[  H       D  HY(WEHt36 HHEH] =T } H  H[WEHt36 HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hW[    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0)}H  L@LEWEMt3'5 HMFHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMY H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\((Xu \(XuuHUH(  HEf/w"\{ (H   Hx莎f/vHE0H;tHU0HsWEH]HHt3o3 HLHEH]LEHuHEHEHEHEH;t-I43 HtHOLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHMK LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   &HM1 HM1 HM`1 HMH1 HM81 HM1 HM1 L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9HY] \ Y   X Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH	 H3HELHHyHHL$@c   EWfA.z\  D
  fA/H  HFhLFxHHNhP8MHHNhw(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      D H;vA(D\V w (   fD/GLcD fHD$@H;t5HOHT$HHD$hG(HOHT$X/HO0HT$p!HFhLFxHHNhP8MHHNhLGI@H_@HEDELEH]LEHEHEHUHM虞  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM;  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H軏D$hG(HOHT$X袏HO0HT$p蔏   H6 HE3HEHEHw HD$0D$8HUHL$0, Hc* HEHP	 HMP H/6 HE3HEHEHbw HD$0D$8HUHL$0, H* HEH	 HMP HL$p
- HL$X, HL$H, HMH3= L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pHu	 H3H$P  HHHL$0   Hq HL$@8H(* H$0  HL$0:LHHAPH$H  HrUHH$0  H=   r<t, HAH;r, H+Hs, H'v, HC H$   H$   * H$P  H3=< H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\nH(  X \(UXH(   Wf/vH0   X (چ H0  X  H;t/HSHNϋHC(HF(HSHN躋HS0HN0譋LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hB  HMHLHT$hP(HH   HHHHPHKHHHSHL$h
) HHEHsH   HCH;t'H;tH( Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h軖  H       D  HY(WEHt3$( HDHEH] = } H  H[WEHt3' HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hL    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt3& HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMWK H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(l(Xu \Y(XuuHUH(  HyEf/w"\ہ (H   Hf/vHE0H;tHU0HWEH]HHt3$ HLHEH]LEHuHEHEHEHEH;t-I$ HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM諤 LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM_  LML   H   H   1HM<# HM1# HM`&# HMH# HM8# HM# HM" L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH& HAPHh HA`D$P   HA HHO(H9# HHGPHcPH HD:PHGPHcPDBDD:LHS(HHD\HH\$HHt$XH0_HL$HH LL$P)t$0LD$X3)|$ t5| = Tf/    LL$PLD$X3>Tf/    LL$PLD$X3Tf/    LL$PLD$X3Tf/    LL$PLD$X3̽Tf/    LL$PLD$X3覽Tf/ws(t$0(|$ HHHi H
pX  Hi H
\X  Hi H
HX  Hi H
4X  Hi H
 X  Hi H
X  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	8  Ht
HSHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@  IVHO   L\$`HI[Is I{(IA^H\$WH H HHA`HIHd HO8Z HO P HOF H Ht
   HJ7 HH\$0H _H\$WH H HHAhHIH HO8 HO  HO H_ Ht
   H6 HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	q Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@I  H\$xHH$   H`_@SH0HD$     HHd  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH Ht
H*HL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ Պ  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8"z (fo7 IHFHMEHEUHMHME0HuMH] E H](M@fo
 fEPU`Mp  Xf/FvFHHI;L$8  IHN 踔  ID~DHN0LN@HLF0A   HV 
  H$@  FDHAD~HH   A_A^_^]sH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _
 HH
 HH}
 H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMH HHEHE   HE    E A   HsP HM5HE0   HE(    E ; uE3IIB< uHHM5HEP   HEH    E8 A   H_ HM8^53fff     H}H;   H+H   HHuH}HCuHH   LǺ%   H HH   :
% uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
: A   HHMb0H)IE3HUHM89A   H HM87IHMXө  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H HH    :E uC:: uC:/ u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM/IIE3HUHM87HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H H HD$0HT$0HM% HHL$`w HX	 HL$`9 HUAVAWHhH@  HD$XHXHpHx H		 H3HE8L= HLEHE   E3LuDuEF"HFQ HM52HE0   Lu(DuEFHa HM2A@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH    :M uC:B uC:7 uAtH+HHHsHEH}HCEH+Ht+HD$    L
C7 A   HHM-H(IE3HUHM5A   Hӗ HM^4A? tI@ IC<7 uMIHM74HEH}0HCEH
: HL$03HL$8HL$@HD$HD$PHT$8HL$H H0 HD$0HT$0HM] HHL$` H	 HL$`t7 @SH0W)t$ f/Ȼ   (vW5 (p  (,t
Xʃ\
(\(f/
 v\(Y
 (bp fnY(t$ YH0[Hx)t$`(4 f/)|$PWD)D$@D(D)L$0D(v(o W   fD.z  f.zv  D)T$ D fA/L  D
* fA/r4D" ff     AX(yo fA/XsD(E\-~
 eH%X      HЋ9
   X5H A(AYAY((Y
 (Y
 Y
I
 Xi
 Xi
 X
!
 YYYX5
 X5
 X
 AYYYX
 X
 X(Yَ
 AYX
 YX
 YXX
 ^YY5 X  Df fD/v(En E(\D(AX|
 eH%X   g f/ƹ   HЋ   9c
 h  A(A(AYAY((Y
 (Y
 Y
 Xғ
 Xғ
 X
b
 YYYX
 X
 X
.
 AYYYXq
 X

 X(Y
 X
 YX
 AYX^YY%Ͳ X   9
 )  EYDW A(AY((Y|
 (Yi
 Y
 XQ
 XA
 X
ш
 YYYX
 X
 AYYX(Y
 X
u
 X
 X}
 YXa
 AYX^AYDY
α AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
~
 ! =r
 (i H
^
 (
+ L
 ( ^
 . ^
 (O 
0
 (
q )ڋ
 ( )
 (
 )ދ
 )
ǋ
 ! UH
 ]! =
 (
 H
Η
 (
O X
 ( j
  j
 (ӷ 
<
 (
 Ɠ
  
 (
 ȓ
 
 p  H
t
   =h
 (ߵ H
T
 (
a 
 (3 ,
 (U 

 (
 
 Ȳ 
i
 (
 
 
s
  IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
7 A(.  j f.zu" "  !      f/   (LW Hh((Y(T
 fD/vlY
 0 f/vVfA.zu3(H       $   H$      Ew
 fn "   Ya S  ܱ ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ h f.(   u~B f/vpH      $   H$   H#H;  fA/s(th (f/{   
5 f/  ,H Y<Z   f/v:6 f/vJ =B  "   D^D\
έ AY  H$   }Dv D(DX
 YE\A(g 
o Yf/   AYf/wBAYA(\5 (g (A(g  (^^Yf/vvfA.zu3*H       $   H$      EËO fn "   Y9 (A\A((g (A(f ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   HS H
'E s L$   HR H
T s H\$D$WH`)t$PI)|$@H(D)D$0 f/ro(Af f.z  (m(Wf/ WvW f D(E3(LHqD\(e D\  : f/vfWf.z0   (
 Tf/ve D(DW     ^\7 Tue D(    f/v$((\ \
Z (
  D(of/= r! f/v(d  e D(DHL$po{ e D((X \k d \ \=V YDXH\$xA(D(D$0(t$P(|$@H`_LD$pH H
   LD$pHi H
ұ   H(Y4 LL$0LD$83#(T
) f/
Y w
Y H(HsP H
> o  H(Yԩ LL$0LD$8ã(T
ɴ f/
 w
Y_ H(HP H
>   H\$D$WH`)t$PI)|$@HD)D$0(D D)L$ A(EWfD/   `c f.zZ   f/ru(LW) H((fY(T
 fD/vY
!  f/   ^fA.    A(  fD/v ff     ^AXfD/wt$p(b f.(   u~ f/vpH      $   H$   H#H;  fA/s(=b (f/D   
 f/x  ,H Y<   u f/v* f/Z  D^D\ AY   HL$pswD
R D(DXը YE\A(a 
K Yf/vVAYf/  AYA(\5٦ (a (A(_a u (^^Yf/v&   A\A((Da (A( a ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pH H
 R  H H
۰   LD$pH!M H
2? m LD$pHM H
N m H> H
   H H
   H$ H
m   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3C HcHD$(Hl$0HT$(H茝  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"H Ht
HHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H Ht
HHH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;tZHtHHHH;tYHHHHGH;t"Hi  Ht
HHH    H_H_HHL$8 HL$(/  H$   H`A_A^A]A\_^]@SH Hby  HH [@SH0HD$     zx  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIRM7MwMwLuI*HH/WD$@HD$P    E3E3HT$@H芒L\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uH8HHF)L;t$HV! HHVHH~H$`  H$P  HHHI$I$H;uIT$H;uH藤I$ID$'H;t"LIT$! HIT$HjI\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W- 3MtlA(Y5 (Y= D(D\D
z Dɟ HfE/v((+ AYA((XI IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  袩LLD$XHT$pHHH
L;   IH   IW%MIOI+H*HHHH?HH;v HRHH=   r=Atp I@I;r` L+IsP I'vC LIo I?IIHIHCIGHCIGH;H{H{HL$pH   HT$x[H$   LD$pI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'vs LI H$   HtwH$   H+HH?H;v5 H    H=   r<t HAH;r	 H+Hs H'v H HL$XHttHD$hH+HHH;v H    H=   r<t HAH;r H+Hs{ H'vn H H   HT$HHvHD$PH+HHH;v- HH=   r=@t HEH;r H+Hs H'v HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWATAUAVAWH  HǀpHXHp)p)xD)@D)HHL5b EWE(W8HǀH    HPLXHǀ`    Hǀh    H
HBH+HHucH  HD$p3HD$xH$   H1 H$   Ƅ$   HT$xH$   0 H HD$pHm1 HL$psHǄ$H     $   HBH+HHwcHY  HD$p3HD$xH$   HN1 H$   Ƅ$   HT$xH$    H, HD$pH0 HL$p   H$H  AD$hW$   E3L$   McgxIMt*M;v
H
g- ! IH$   0L$   E3H$   L$   fD  M;  HFH+HH;rcHX HD$p3HD$xH$   HM0 H$   Ƅ$   HT$xH$    H+ HD$pH/ HL$pHHH$H  H<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
A,  HM+IIHIH+IE3I;LCL;ICH$   .L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
+ b HM+IIHIH+IE3I;LCL;ICH$   .L$   H$   L$   Ht:HH$   IH$8  DXYQ AX$   WD$pE3AL$   IcG,H$   Ht/I;v
H
*  HHL$pz-H$   H$   MH\$xHt$pL;  H$8  W(D$`HD$`H;   HD$`H;   Lt$`L+IH;uwHH+HHsgH+HIH+Hs
H
7*  HSH+HHHIH+HE3H;LCL;ICHL$p,H$   H\$xHt$pHt8JH/H;u!   HL$p(H$   H\$xHt$pHt;HH\$xIH$   h
 |   I(DH H
q( @cHcH$    E3AL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rg
 }   DHO H
L bHcH$  ?IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;r=g
 ~   EG,HV% H
' aIcW,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r}f
    EG,H$ H
O& aIcW,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rA   uoe
    IGxI   I   MG0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  iHH$   8   :e
    IGxI   I   MGHMO0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  HH$   H$8  HtL$H  L+IA   L-#      E;g,W  d
    IcLL+ILl$(D$    DE'^M   M+   IH
" HL$(D$    D]I   tYtL$   L+$   IH
# HL$(D$    D]H$   tc
    Ll$(D$    DE]M   M+   IH

" HL$(D$    DX]I   tYtL$   L+$   IH
F# HL$(D$    D]H$   tA   L-3 =S A;(|  c
    HcL$   L+$   IH
" HL$(D$    D\L$   L! HI   HH$   H+$   HLNL+IHD$0Ll$(L H
 LFL+IH$   Hl^(L  HI   裐HH$   H+$   HLNL+IHD$0Ll$(L$ H
! dLFL+IH$   H]XAYtXL$  L+$  IH
7 HL$(D$    Dz[H$  tzE3AAO(;}A;}AAO,;}AD  ;}Va
    Ǆ$      Dt$`L$   HT$`H$   ԍ  $   H$   H$   a
    D$`   D$   LD$`H$   HL$h腍  D$hHT$hH$   `
    Dt$`M   HT$`H$   蕎  D$hHT$hH$   }{`
     D$hDt$`LD$hHT$`H$   i  D$hHT$hH$   1/`
    Dt$`M   HT$`HL$p茑  D$hHT$hH$   _
    IO`L$   H$  a  $   H$   H$   H$   Ht(L$   L+IW$   L$   H$   Ht(L$   L+IW$   L$   H$  Ht(L$  L+IWW$  L$  H$   Ht(L$   L+I"W$   L$   HT$pHtL$   L+IH$   HtL$   L+ID$   H$   H$   ~H$   W  (H$   HtL$0  L+I}(L$  I[8Is@A(sA({E(CE(KIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHHVH+HL$   IJ3HFH+HH   $   D(DXL%HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;v H    H=   r<t HAH;r H+Hs H'v H L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHL"(W$   LKL+IL$   IIGMH$   HD$ MH$   IbHSH+HHL$PWD$8HD$H    LCHHL$8,3HKH+HHT$8H  L5 HIL43 HBX LL$PMHT$8I43HCH+HHl$PHtvMH#` YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8LH -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;vF H    H=   r<t* HBH;r H+Hs
 H'v HH) HtmHD$`H+HH;v H    H=   r=@t HEH;r H+Hs H'v HH (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  H0	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@:HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
  HQM+IIHL+IHM;HCH;HCHL$@HL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
x 2 HQM+IIHL+IHM;HCH;HCHL$@HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   
LFLL$`I{`  H$  H$   UHXH$  HtINHH$   PHt$hH\$`H~&Hfff     HHL$@袼HcH;|IHHT$@PH$  H$   H!H$  H$   HL$` HT$@HtLD$PL+IUH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H詫I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KM  IIL$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JL  H H$   H$   H$   H$   H$   HT$xLL+t
H;: HT$xW$   H~ H$   LMH$   H$   H$   FkLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^ Aƅ    A   I9 A   H$   YkH$   I蹯IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI!c +fn^5Q L$   (A(umL$   (A(am(A(H$   
rHU H$   H$   w  H$P  H3
 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I~ Ht
H虦I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  ;H  II萚L$   H$   H$   L$   WD$xHt3 H豥HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   :G  H H$   H$   ݤH$   H$   H$   HT$xLL+t
H+5 HT$xW$   Hn H$   LMH$   H$   H$   6fLMHH$   0 D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I" +fDnED^
| Aƅ    A   94 A   H$   IfH$   I	IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIS +fn^5A{ L$   (A(ehL$   (A(Qh(A(H$   lHE H$   H$   g  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"In Ht
H艡I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  +C  IIL$   H$   H$   L$   WD$xHt3 H衠HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   *B  H H$   H$   ͟H$   H$   H$   HT$xLL+t
H0 HT$xW$   H^ H$   LMH$   蛿H$   H$   &aLMHH$     D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^v Aƅ    A   )/ A   H$   9aH$   I虥IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIC +fn^51v L$   (A(UcL$   (A(Ac(A(H$   gH5 H$   H$   W  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH׌	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I^ Ht
HyI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  >  IIpL$   H$   H$   L$   WD$xHt3q H葛HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   =  Hr H$   H$   轚H$   H$   H$   HT$xLL+t
H+ HT$xW$   HN H$   LMH$   苺H$   H$   \LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^q Aƅ    A   * A   H$   )\H$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI3 +fn^5!q L$   (A(E^L$   (A(1^(A(H$   bH% H$   H$   G  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
"  HSHHCHHHHKLHT$`HL$X[  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
y 3 HHHGHHH_LHT$`HL$X  HGH\$hH@_@SH0HD$     ?  HH0[HWATAUAVAWHp  HǀHXHp)pHG	 H3H$P  MLD$XHH$   H$  H$   L$  D$0    HR
 HHHR
 H;R
 r
   HHL$8Ht
n !H3D$8   EE HM H
ZN 	:IcU HL$h蛐3LD$pIHL$hH+HHt HHLD$pIHL$hH+HH;r3L+IMtHHHD$pHL$hH+HH;rD$8   EE AHw H
JM q9AE HcHL$@E3HT$HHHL$@H+HHt!JIHT$HHHL$@H+HL;rE3HH+HHt.@ ff     JIHT$HHHL$@H+HL;rD$8    H+HHL HD$(D$    A   D7HHD$@H   H5L H
M A;]    D$8"   HcMD$M+$IHL$(D$    Dz7I$L<LD$HL+D$@IHt$(D$    DO7HD$@L4HcLD$HL+IHL HD$(D$    D7H|$@MGIVH$   (H HD3HD$X   5Hj H HD$XA;M   D$8(   DyIcH|$HHT$@H+H  G;  HLHcكw  G;l  HHL$   I6I~H+H  G;  H|$pLt$hI+H  G;  H$   *L(H$   ,HLD$XLH$   z,LHH$   .H IDD$8)   H|$pHL$hH+H|&G;}LAMHT$XHL$`s'AHd H$   HM H$   H$X   D$0    E3H$   H$    H$   HcHH! H   H$   HcHh   H$   H$   H$   * H H$   3H$@  $H  Hj H$   %   H H$  H$   "L$  H$  LC$  HJ HD$ DË1H9 H$  H" H$  H$X   D$0   E3H$  H$   H$  HcHH H  H$  HcHh  H$  HD$`H$   Hڼ H$  3H$@  $H  HB H$     H_ H$  H$  L$  H$  LC$  HI HD$ DËi0H H$  H H$  H$X   D$0   E3H$  H$   H$  HcHH H  H$  HcHh  H$  HD$`H$  ڿ H H$  3H$@  $H  H H$     H7 H$  H$  үL$  H$  LC$  Hq HD$ DËA/H H$  HҴ H$  H$X   D$0   E3H$  H$  b H$  HcHH H  H$  HcHh  H$  HD$`H$   H H$  3H$@  $H  H H$     H H$  H$  誮L$  H$(  LC$  HF HD$ DË.H H$  H H$  H$X  | D$0   E3H$  H$  : H$  HcHH~ H  H$  HcHh  H$  HD$`H$   Hb H$  3H$@  $H  H H$     H H$0  H$  肭L$0  H$H  LC$0  HE HD$ DË,D$8+   HT$hH$   HHT$@Ht!LD$PL+IWD$@3HD$PHT$hHtLD$xL+IHH$P  H3y L$p  I[8Is@A(sIA_A^A]A\_@SH`HD$XMHH
AD$0HD$0II#I      I;v#HE HD$ LH~n H
gn *fAnT$0HD$0I#I;u'H6 HD$ L
 HKn H
$n ǬA*H HD$ L
 MH2n H
m 薬Wd$8LD$8LD$@HT$Hfna ^I\Y(YY` (\Y\d$8HHL$8k2  HH`[@SUVWATAVAWH   HD$8)$   )|$pIIHLLBH
IH+H  W(3DHI      HtZ    J@D$0HD$0I#I;tIIH+HL;r#H HD$(LHZm H
;m   fnE D$0HD$0I#H
m I;u#H HD$ L
? LHm f/w#H> HD$ L
 LHm {hD$0HD$0I#I;u#H  HD$ L
 LHl EhLLHl 貦HGH+HA   I;IFEI;LGHHL$@S(_ ^HMtwLA%/j HcIQfnE \(T(Y\f.zuAf/AGfnYHL$@\HI;r(IHL$@w.  HL$@ GHD
 HHHD
 H;D
 r
   HHL$0Ht
WH3II($   (|$pHĐ   A_A^A\_^][@SH`HD$XMHH
AD$0HD$0II#I      I;v#H5 HD$ LHvk H
_k fAnT$0HD$0I#I;u'H& HD$ L
 HCk H
k 跨AWf/w*H HD$ L
 MH#k H
j fd$8HD$8HD$@HT$Hy] ^I\Y(YY\ (\Y\d$8HHL$8_.  HH`[HVWATAVAWH   HD$@HXHh)pIMLLHBH+H  Iy   WL  fAn$$   H      H$   H#H;u*H HD$ L
 MHlj H
Ej `3DHOHt>HIcf/v
IL;r#Hg HD$(LH8j H
i tgH|$0Me  IHL$`$InI+.H   H;HFHWH;HFHL$H,HHt$HH9_v&H
[ fHc(^HH;OrHtcI[     HcHIfAn$\Y(YY\YHD$`\HH;r(IHL$`*  HtLD$XL+IHHL$`1 JH@
 HHH@
 H;@
 r
   /HH$   Ht
WH3IIL$   I[0Ik@A(sIA_A^A\_^HSUVWATAUAVAWH   HD$H)p)xMMLHLZHML+I  IXILL+Ir  W3DIH      MtdIff     BD$0HD$0I#H;wIIH+HL;r#H HD$(MHh H
h   LIMtW@ J@D$0HD$0H#H;tIHH+HL;r#H HD$(MHg H
g   I$@f/w#H_ HD$ MHg H
qg ,H|$@LD$0LT$8HD$0HL$8M;HCHLMHg H
4g ߟLMHzg H
g ƟIHL$X!t$xHD$xH$   L$   I/I_H+HM>IFI+HH;HFظ   H;HFI$@=fX ^K (Htr%W D  HcT I\PY(Y\(Y\(YHD$XX(Y\H$   XHH;r(HHL$P%  HL$X GH=
 HHH=
 H;=
 r
   HHL$@Ht
WH3H>H($   ($   H   A_A^A]A\_^][LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHNwHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHH.HH|$`HHH0_^[H\$Ht$WH I-  HHX f@  Ht4HH3HC   Hs@3Hs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	A_  IB  H1H;>u=IP Iő  H$   HD$(LAII_  I  H;uAH^HK I  H$   HD$(LE3IIf_  I  IP IB   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK IǐtCHCIIπx H$   HD$(tLE3^  I   LA^  I   IHO q   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS It=HGIIπx H$   HD$(tLE3]  I6LA]  I&H$   HD$ MHT$8I`  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I*  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3HHs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aaa  IB  H1H;>u=IP Ie  H$   HD$(LAIIa  I  H;uAH^HK I  H$   HD$(LE3II`  I  IP I   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK IgtCHCIIπx H$   HD$(tLE3`  I   LA`  I   IHO    H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS I行t=HGIIπx H$   HD$(tLE3R_  I6LAB_  I&H$   HD$ MHT$8Ia  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HH0H H|$`H HH\$XH0A^_^@WH0HD$ H\$XH&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@WH0HD$ H\$XHd&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS- HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSHW HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH' HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     wHH0[L$D$HXH      )t$@D$x(HD$xH#)|$0(H;t`D$xHHD$xH#H;woWf/   L$`HD$`H#H;   I
  Y(t$@X(|$0HXH L
} HD$ LD$`H< H
% RH` L
Q HD$ LD$`H H
 RHL L
% HD$ LD$hH H
 RH L
 HD$ LD$hH H
 TRHHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(D(T A\D)xD)hD)XD)H(D)8ATD   f/  L   WDxH D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXYI ^A(\AY(Y\u fE/(vW6S (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y5F A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"H Ht
HpHH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@/  H   MMH9?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"Hw Ht
HoHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@  H   MMHk8L|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HE:(H   A] (YH   Xf/wXfA/sQH   (AT WO f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$H|$ ATAVAWH eH%X   HD

 I   LNB	9Z)
   HII9H3H-u(
 HLL%r(
 HL=p(
 H;1HLH0  HEHDL   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
P'
 蓱 =D'
 H
k&
 H
+'
  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-zD)@HDa< Ip     D)HI   D
: D)PDi: D)XEWD)d$@D%; D)l$0D-F D)t$ D5S: )pغ   H  W4   H*AYff        H  WHH*X(AYH5rԺ   HW  WH*LcXEFLcAYB BY f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zB@

 B fA/B@

 (\\YXr*((B\ Y\YYX\(((B\ Y\YYX\fD/&fD/w(YAYAW f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=: H%  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLLJ I^WD$(Ht3 H7bLHD$(L|$(H\$03HcI;^}UI4H
 HHH
 H;
 r
   HH$   Ht
(~HILD$(H$   IM   H$   HCH$   HI~I;|$t!I$W HtHraI$I4$I|$H      ?HCH=
 H
'
 H9

 t	H
  HH+
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|I  L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH 3H$   HH$   HH$   H~ H$   HLCL+H$   ~ A   E3H$   HL$0 HD$0HcHHD$0HȺ    HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQDuHL$0 u2HL$0` H$   A HL$0A H$   " 2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H  HD$(H;wH
H\$ H;vHH+HH=   HH  H\$@Ht$HH0_@SH HHHSH
1 H3H
HJHH 3HC HC(HC0Hn C8HH} HCHH [@SH0HD$     	  HH0[LL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHTHHH|$PH0_^[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$XY  HL$8(Ï 3($   H   [HIH% H% H\$WH Hc t
h   H聧 HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    H
 LHH
 H

 H;rHLH
 H

 HHH|
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH
 HH0H
 H;
 r
0   HH\$`Ht!(HHz HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    H
 LHH
 H;
 rHQLH
 HHH
 H;
 rH)HH
 3LCIHI+HHt2f     I HIHLCI@I+ HH;rHw
 3H9S~-L3ff     JH9HIHcH;C|HB
 HH0H4
 H;%
 r
0   HH\$`Ht!(HH2y HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHH
 LHH
 Hp
 H;r   LH_
 HP
 HHHJ
 H;r
   HHKHIHHH
!
 HH0H

 H;

 r
0   `HH\$PHt%(HHx HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$Ht$WH0H3HRH\$ H+HQHGH+HHt&D  HHHHHHGH+HH;rH\$@HHt$HH0_H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfo7 (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   7 II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %f6 ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   OHu HHOHA HHG@HcPHy HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHC HAPH HA`D$P   H HHO(Hɇ HHGPHcPH{ HD:PHGPHcPDBDD:LHS(HHDQHH\$HHt$XH0_H\$WH HHT HHQ3HHHKHB H  HHCHGHC H\$0HG 3HG0HG8HG@HKp GHHH
u HG(HH _H\$WH HHH;Qt>H	 HtHV  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   腙 LHtHHHtHHIHHtHHIH [HL$H(( LD$0HT$8p{T2 f/) wU( LD$0HT$8H{T2 f/) wA( LD$0HT$8 {Ty2 f/) w-H(H H
Կ l  H H
 l  H H
 l  LVWATAWHh  HQ@	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  z7E3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XA	AX
	AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ 5L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3詑 Hh  A_A\_^HWH   H@HXHhHpIIHIPHH[3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`H-Hl$PH\$HH+HH;ntH  Ht
H;LHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;v H    H=   r<tt HAH;rd H+HsT H'vG Hv HHtmHD$XH+HH;v H    H=   r<t HCH;r H+Hs H'v HH HL$`HtiHD$pH+HH;v H    H=   r<t HAH;rt H+Hsd H'vW H膖 L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHHt3} HIHHkHsC  IH!h  HH\$`Hl$hH0A^_^@USVWATAWH$H  HY9	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  =E* WD! f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HEH  HE H  IH B<L;~  HH+HNHfo! T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
,! foLu@MH  EhL  E   M  E  fo
  f      h  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&i  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfo IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   #  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  )2 LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@9  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3΃ H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     b  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  H-	 H3HExMHS# HHEHm# HHEHE   HE    E 8 uE3IIB<  uHHM薍HE0   HE(    E ; uE3I IB< uHHMZHEP   HEH    E8 A   H# HM8/3@      H}H;   H+H   HHuH}HCuHH   LǺ%   Ho HH   :
e uH:
Z uH:
O u3tH+HHHsHEH}HCEH+Ht+HD$    L
l A   HHM2H)IE3HUHM8A   H HM8IHMX`  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   Hn HH    :u uC:j uC:_ u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8蟏HE8H}PHCE8H
Rw HL$03HL$8HL$@HD$HD$PHT$8HL$Hm H`r HD$0HT$0HM_  HHL$`G`  H( HL$`茑 @WH@  HD$(H$P  HHD$     HL$@~\   HL$0k LD$PMcHHL$PIHPHL$Pk HHL$@ZH$   ZH$   ~l HH$P  H@  _Hx)t$`(D f/)|$PWD)D$@D(D)L$0D(v( W   fD.z  f.zv  D)T$ D& fA/L  D
: fA/r4D2 ff     AX( fA/XsD(E\=	 eH%X      HЋ9"	   X5X A(AYAY((Y	 (Y	 Y
i	 Xq	 Xq	 X
A	 YYYX=	 X=	 X

	 AYYYX	 X
	 X(Y	 AYX	 YX	 YXX
	 ^YY5
 X  Dv fD/v(U E(\D(AX	 eH%X   w f/ƹ   HЋ   9	 h  A(A(AYAY((Y	 (Y	 Y
	 XZ	 XZ	 X
j	 YYYX&	 X&	 X
6	 AYYYX	 X
		 X(Y"	 X
	 YX	 AYX^YY% X   9	 )  EYDW A(AY((Y	 (Y	 Y
	 X	 X	 X
	 YYYX	 X
	 AYYX(Y	 X
m	 Xe	 Xu	 YXY	 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
	 	| =	 (y H
	 (
; T	 (
 f	 > f	 (_ 
8	 (
 )	 ( )
	 (
 )	 )
	 { UH
*	 m{ =	 ( H
	 (
_ 	 ( 	 
 	 ( 
	 (
% 	 	 
	 (
 	 
	 z H
X	 z =L	 ( H
8	 (
q 	 (C 	 (e 
	 (
 	  
a	 (
 	 
k	 y IHHh  HD$X)p)x((Wf.zu( Y	   f.z  f.
3
 z0u.(W _((_YY5y	 (L  f/
 rT= (_.  (Z  HrDJp J ȃw_H\ H(+[     (~\     ((螰     (]     ($     (^     HCo HD$03HD$8HD$@Hk HD$HD$PHT$8HL$He HZ] HD$0HT$0H$   諲  H
 HH(H
 HH0@8B  HH$   m  HHL$`  H HL$`D ($P  ($@  Hh  ÐM Z g w   HUVATAUAVAWHxHX  Li3ILLDM  : 
 HXH      ?HxI)p)x=
 D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E   S  IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C莇  H;}&f        HE(f)HH;|LHMHT  LM@L  HH  HM` MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL     MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@覷  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMHa  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  xr  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH       9r @   @   H
L[ HHxHHH\$PH0_HT$WH0HD$ H\$PHHH       q @   @   H
Q HHxHHH\$PH0_HxHD$8)t$`)|$PD)D$@9|$0HD$0II#I      I;v*HA HD$ L
- LH H
 fDnEDD$0HD$0I#I;u*H) HD$ L
 LH H
D JA 'H HD$ L
 H- H
 Jfn5 ^u A\Yv	 WX\YY= \((t$`(|$PD(D$@Hx@SUVWAVH`HD$8)t$P)|$@ILHHHIH+HH  W3DI      HtQfff     BD$0HD$0I#I;t
IL;r#H HD$(LH H
` 諈  fAnD$0HD$0I#I;u*H HD$ L
c MHI H
 5If/w*H[ HD$ L
/ LH- H
 D$0HD$0I#I;u*H6 HD$ L
 LH H
 TLLH H
 DH/HGH+H   H;HFH;HG= ^z (HtJfAn#	 %3  (X(\HcL \TY\HH;r(W(t$P(|$@H`A^_^][HH   H@)p)xD)@D)H9xH@II#I      I;v*H̒ HD$ L
 LH H
 fDn
EDL$0HD$0I#I;u*H HD$ L
p LH H
 BGA EWfA/w'Hb HD$ L
6 H H
x 5 ^ A\Y
 	 AX\YY=[ \((t$p(|$`D(D$PD(L$@HĈ   HHPHHUVWATAUAVAWH   HD$@HX)p)xMLLLYLII+H  M@M  W3DHH      HtlH@      C$   H$   H#H;wIII+HL;r#H HD$(MH H
   fAn$$   H$   H#H;u*H HD$ L
 MH H
[ nELMt@IfIcf/v
IM;r#Hy HD$(MHR H
 Lt$0MHm  I_I+H   H;HFIVH;HFH$   HL$hD2IVHL$P52HLl$hHl$PI9vvZM>HML+= Hc(A^AA薳 HH[I;~rH$   L$   L$   HtjMfAn$HIH+\	 % @      HcA\YY(X(\1Y\HHH;rHtLD$`L+IHfMtLD$xM+IIf(WL$   I[PA(sA({IA_A^A]A\_^]@SUVWATAVAWH`HD$8)t$P)|$@MLLHHyH+HH  MINI+HH  W3DI      HtVIfD  BD$0HD$0I#I;w
IL;r#H HD$(MHO H
8   LHtHfCD$0HD$0I#I;t
IL;r#H HD$(MH H
 諁  A$f/w*H HD$ L
s MH H
 H;HBLMH H
 4>LMH H
x >I7IH+HI.IFH+HH;HF   H;HFA$= ^˰ (HtQ	 5 @ f     Hc\L Y(X(\YY\HH;r(W(t$P(|$@H`A_A^A\_^][H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
 HDHE H;HBL<LH LH
 H\$@H0_si  @SH HALHH$I$IHH;r6H|$0H|$XHO@HO 3Hj H
> O H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMt: uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I-t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@OHN .Hnf I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@NHO 5.He H
n  K H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtj uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I(t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN )Ha I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	%H Ht
H@HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@IVHOKb  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ H H+H= H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/LY L+L
_ L+A:tA:	uHr:IuL$ L+L
* L+    B:tB:	uHr@-tH      < @-tH       	 D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;tHIHKH;tHn= Ht
H	HL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}fou UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMA  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHMa:    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5_      HG(Hx tL   LHH%\  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vHHE HHuxL4    I   w2IFHHH;wHHHŎ H+HD$`HHHE 1I>8 HE HuMt裑HILuXE3L9?LDL  Lx  H  H    H=     I;vLHGHEHu`H    H   w2HCHHH;wHHH H+HD$`HHHEHz7 HEHuHtߐ3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX=O 5 MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  I.HUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  H@HHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  L  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} H#HHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t/    t	I/ H  H3@ H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    H. HuHuH\$ H(RL@SH Hr	  H( HCPH [HL$SH0HD$ HD$P    EtHN HA@Hc( HAPD$P   J   H HH( HCHC@HcHHN& HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH6 HHQ3HHBHK<- H1 HH{3HHDH^H\$HH/ HHOHKHtHPHGHCHGHCG C H& HH0+ HHH\$PHt$XH0_@SH H  H3' HCPH [HL$SH0HD$ HD$P    EtHVM HA@H& HAPD$P   J   H+ HH)$ HCHC@HcHH  HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH^5 HHQ3HHBHK+ He0 HH{3HHDH^H\$HHu. HHOHKHtHPHGHCHGHCG C Hz HHP& HHH\$PHt$XH0_HIH%+ H\$WH H|  H% HGPt
X   HC HH\$0H _@WH0HD$ H\$@HH$ HH- HAHI HtHP tHC     H(4 HHK+ @t
@   HXC HH\$@H0_H\$WH H  H$ HGPt
X   HC HH\$0H _@WH0HD$ H\$@HH( HH, HAHI HtHP tHC     Hh3 HHKS* @t
@   HB HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJdHHHFHGHHFLL+t轆 H_H\$HHN.HHHFHCHVHFLL+t膆 HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$HT$H8IE3IPH+HHtHII      @ f     H@D$HHD$HI#I;wIHL;rH8Hma H6 HD$(H
 V  3HIHtH   H LH   ICAC    HQHKH ICH! ICAC   IK;H% HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H6 HL$(K @SH0HD$ HٹX   |; HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH?% HH] HAHA@HcPH HD
@HA@HcPDBDD
<HU HH) HAHI HtHP tHC     H/ HHKH0[H%z& @SH0HD$ HH HH( HAHI HtHP tHC     H// HHKH0[H%& LH   ICAC    HQH[F ICH ICAC   IKH HD$(HX  HD$@HD$hHcHH HDhHD$hHcHDd    H HL$("I @SH0HD$ HٹX   9 HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HHW HH HAHA@HcPH" HD
@HA@HcPDBDD
<HM HH#' HAHI HtHP tHC     H- HHKH0[H%$ @SH0HD$ HH HH& HAHI HtHP tHC     H?- HHKH0[H%$$ HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A    H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH Hk HHt
   9 HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH@ HA@H HAPD$P   H HHOH HHG@HcPH7 HD:@HG@HcPDBDD:<HSHHDZHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH+@ HA@H HAPD$P   H HHOH) HHG@HcPH HD:@HG@HcPDBDD:<HSHHD!ZHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vxHHMHHumJ    H   w2HCHHH;wHHHt H+HL$`HHHM*H( HHEHuHtwH3H9HDHEXH   L   J    H=      M;vEwLnMu_J    H   w.HCHHH;wHHHs H+Ll$`IIH{ LHuHtvHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HW3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIK  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H0     t
HMX H   H3+ H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3 HHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xU?  HIHD$hHD$p   INIHD$xH$    D$0HT$ LL$hLD$xIV  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v% HA    (|$@D(L$ H`[ HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    v A   % A   A((TU TN f/vOA^)t$P5n (YXdu fE/
) vW^3YWs(t$PJD^A(AYX u fD/ vW
| ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H H3HE8H^ HHEL=x HLEHE   E3LuDuD80uE
IIF84 uHHM3HE0   Lu(E A   H- HM3IH}H;   H+H   HHuH}HCuHH   LǺ%   HV HH    : uC:ڝ uC:ϝ uAtH+HHHsHEH}HCEH+Ht+HD$    L
8 A   HHM.H(IE3HUHMT7A   Hk HM5A? tI@ IC<7 uMIHM5HEH}0HCEH
 HL$03HL$8HL$@HD$HD$PHT$8HL$H' H HD$0HT$0HM  HHL$`?  H( HL$`9 @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH		 Mt
I$HL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH Mt
IHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ cLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8q  (fo׸ IHCHMEHEUHMHME0H]MH} E H}(M@fo
 fEPU`Mp;Xf/CvCHIH;HC  l  H$0  HL$H  HADc$L$@  H   A_A]^[]kk@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4C  H;}. HD$8HHD$ (HD$ )HH;|LHL$PHՏ  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1H&HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@^   HL$0 LD$PMcHHL$PIHPHL$P HHL$@H$   H$   ^
 HH$P  H@  _@SH HHHSH
 H3H
HJHHs
 3HC HC(HC0HN C8HH HCHH [@SH0HD$     O  HH0[@SH HHHSH
 H3H
HJHH 3HC HC(HC0H C8HH HCHH [@SH0HD$     JN  HH0[H(((T
ߺ f/
 v6f/
 rWf/   n H(i \ܯ H(߭ f/v(H((Y((Y% (Y
	 (Y6 X%~ Y X
f X YX YX%ޮ YX
 YYY\\\%> X. YY-2 ^X(H(H;G H
t 73L(DIDAf     AP
 f/sffA;uDA` f/sffA;uDAHkAHAR HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DY A(h D
 (E(A(Y=I A(»   EY(D(T
 f/
    A(AYg (A(Y% YXf;vM- (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_HUS H
^A QHHXWH   )pA)xfD)@(D)H(D)PD(Dج fD)X   D(D)`DYD((DYYE^Y DW
p uf Y=C L$   L$   3D(DY(DY ((T
 f/
J    Y WA^(Xf;v.ffnYA(EY\AYXf;rDYi A(e Y0 L$   I[(|$pE(CE(KE(SE([E(cYA(sI_HQ H
B@ H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
B EYW= (A\AYY d YWA(YI (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PY/ L@D)XD((D(T f/M    DY )|$`D)D$PD* A(A\EX(A(c E\Wf.EYD(DYb zt1AYAYY=T A^(c AYY D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxHO H
Q> H   eH%X   
r	 )t$pWA   D)T$0D(HB9Ď	   fA/vDW fD.zu (t$pD(T$0HĈ    fA/rfA(L$   AYH<~	 H
e	 $   /v  %	 (Y% A(،	 AX\\
/	 Y  D)\$ D fE/rzp L$   A(H	 AYH
ɀ	 Y
A \$   ot  %	 (Y% A(p	 AX\\
	 Y(  % E^)|$`A(D)D$PAYD)L$@f/   D((DY
	 Y-	 DX
	 X	 DYYDX
r	 X	 DYYDX
P	 XЉ	 DYYDX
.	 X	 DYYDX
	 X	 D^   	 (^D((DYfDX	 DYDXfDYDXу	 DYDXfDYDX	 YfX	 YXfYX	 YXfYXD^f/   D((DY	 Y	 DXh	 X	 DYYDXF	 Xf	 DYYDX$	 XD	 DYYDX	 X"	 DYYDX	 X 	 D^   ǈ	 ^D((DYfDX	 DYDXfDYDX	 DYDXfDYDX	 YfX	 YXfYX	 YXfYXD^A()_ (A(^ (A(_ - (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
7	 n =+	 g(^ H
	 (
Э 	 ( #	 ۦ 
	 (
 	 ( 
y	 (
H y	 (ʰ 
y	 (
< )|	 ( )
|	 (
` )|	 ( )
|	 (
4 )={	 (V )
?{	 (
 )A{	 ( )
C{	 (
 u	 (N 
w	 (
  y	 ( 
Ӆ	 (
T Յ	 (Ư 
ׅ	 (
 I	 ( 
K	 (
l M	 ( 
G	 (
 I	  
J	 
 2	  
J	 
J "	  
j	 
b R	 5Jx	 
:	  rH   eH%X   
Nk	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D%_ B9Ɉ	   fE.E(DT zu	A(  Ѣ fA/)|$prnA(L$   AYHu}	 H
{	 $   Xo  %	 (Y% A(A(XE	 \AY\
D	 YY9  D)T$@DТ fE/rnA(L$   AYHI	 H
	 $   m  %	 (Y%1 A(A(X	 \AY\
X	 YY   E^)$   A(AY$   A([ (A(Z (L$   H=z	 H
f~	 An  (L$   (AYH߀	 XH
$w	 Yn  \YXA(Z Y֠ ($   D^AYD(T$@fE/vY= ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
	  =	 ( H
	 (
	 *y	 ( <y	 \ 
y	 (
 .y	 ( 
@{	 (
 B{	 (3 
D{	 (
 )>	 (ר )
@	 (
y )B	 (+ )
D	 (
m )6	 (o )
8	 (
 ):	 (C )
<	 (
 u	 ( 
u	 (
	 u	 (˫ 
,	 (
} .	 (o 
0	 (
! j|	 (# 
l|	 (
 n|	 (w 
x	 (
i x	 : 
x	 
 	  
K	 
à {	 # 
	 
 s	 Dy	 Dt	 D%~	 D{	 D%w	 
6	 u
 D$H   eH%X   
f	 )|$`=ߝ A   HD)T$0D(B9Ʉ	   WfA/	  fD.z(	   fA/)t$pD)D$P  A(E(^B	 EYVW (A(fA/X(Y^%ĝ    A(A(Ys	 Y	 X~s	 X	 AYAYX\s	 Xd	 AYAYX:s	 XB	 AYAYXs	 X 	 AYAYXr	 X	 ^   r	 A^((YfXr	 YXfYXr	 YXfYX	 YfX	 YXfYX	 YXfYX^	 A(YȚ \	 AX\?	 YYX   fA/   A(AY$   A(^]	 ~U (A((XL$   H{	 H
Ot	 Y^-ۛ h  %	 (Y% A(	 AX\\
&	 YYX  D)\$ D6 fE/   A(AY$   A(^]	 T (A(T(XL$   Hw	 H
g~	 Y^-# f  %>	 (Y%c A(	 AX\\
	 YYX  E^D)L$@A(AYf/   D((DY
{	 Yww	 DX
n{	 X^w	 DYYDX
L{	 X<w	 DYYDX
*{	 Xw	 DYYDX
{	 Xv	 DYYDX
z	 Xv	 D^   z	 (^D((DYfDXz	 DYDXfDYDXz	 DYDXfDYDXdv	 YfXav	 YXfYXVv	 YXfYXD^f/   D((DYw	 Ys	 DXw	 Xs	 DYYDXw	 Xs	 DYYDXw	 Xvs	 DYYDXlw	 XTs	 DYYDXJw	 X2s	 D^   1w	 ^D((DYfDX!w	 DYDXfDYDXw	 DYDXfDYDXr	 YfXr	 YXfYXr	 YXfYXD^A(Q (A(kQ (A(Q  (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
'~	  =~	 R(. (
ף 8m	 () Jm	 ({ <z	 ( 
m	 (
o o	 (a 
z	 (
 o	  
z	 (
 o	 ( 
po	 (
 *v	 (ˠ 
v	 (
 )z	 (O 
v	 (
q )
z	 ( )
y	 (
E )nr	 ( )
y	 (
 )rr	 (K )
Tr	 (
ݛ w	 ( )
Xr	 (
 w	 ( 
v	 (
 r	 ( 
r	 (
i rt	 (۠ 
r	 (
 vt	 (? 
Xt	 (
 :p	  
p	 (
 z	 L 
p	 
 z	 Փ 
{	 
m ]z	  
{	 
 {	 =t	 
%|	 
 H
{	 & 
N{	 6z	  L$   H H
 H, H
 D$HxeH%X   
\	 )t$`W)|$P(A   HD)T$ D B9z	 >  f/~   f/D)D$@   (Y$   (^iz	 M (((XL$   Hk	 H
Do	 Y^- `  %w	 D(Y%O (z	 X\\
w	 Y^DYDX^  D)L$0D
f fD/   (Y$   (^Xw	 L ((X(XL$   Hj	 H
i	 Y^-W ]  %:x	 D(Y% (v	 X\\
w	 Y^DYDX   D^A(AY$   (mL ((>L (L$   H p	 H
Av	 _  D(L$   (EYHp	 \H
6n	 DY|_  XYD\(L Y? D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
Ex	  =9x	 ( H
%x	 (
2 ;m	 ( Mm	  Mm	 (ƚ 
m	 (
 i	 ( 
i	 (
ܘ )Eh	 (N 
i	 (
 )Ih	  )
*h	 (
3 Kh	 (T )
-h	 (
 )h	 ( )
h	 (
J )h	 ( )
h	 (
 l	 ( 
l	 (
" Co	 ( 
l	 (
6 Go	 ( 
)o	 (
ژ ct	 (l 
Et	 (
 n	 ( 
It	 (
 n	 s 
m	 
ܐ v	 | 
<t	 
 4t	  
<t	 
 4u	 D+h	 Dg	 5k	 Dn	 5s	 Dm	 
ht	   xL$   Ho H
 zHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H'  HH   [A(f.- LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((Y Y
 (\f/ vYP H(((H(6  H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
x HDHݥ H;HBLLH LH
J H\$@H0_   @SUVWHx  HD$8H\ H3H$`  IIHHM;H   HL$@H$ HL$P?HHk HH# >HHj# >HH## >HH" >H$@  HL$@HCHD$0H$@  H$X  HC$@  HD$ L
# LD$0HH譃H$`  H3,  Hx  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
 \ HMrLM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMSLMHELEHtHHLMLEHEHHEHHcI;N}!H
-  H
  WEHE    LMLEIIRHMH   HEH+HH?H;v H    H=   r<t HAH;r H+Hs H'v H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;rr H+Hsb H'vU H  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	 Ht
H)HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@RH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHH4  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHHr 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3Q HqHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM获  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HMQ5  L;}:@      HMHEBEffYfBXB)IL;|LHHM5  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIK!H$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLGA  HL$hW HL$pL L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH,  HC   HkH{rHH  HHH H H;t    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AIk1 AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  (  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@SUVWAVAWHh  HD$8H؎ H3H$P  IMHLH$  D$0    H
 HD$@H$    D$0   E3E3HT$HHL$@ HD$@HcHH HD@HD$@HcHDxDD<   HL$HHHL$@((HH:
 (HHUl HH: 'H$0  HL$@KID$0H$0  H$H  HC$0  Ht$ L
 LD$0I}@SUVWAVAWHh  HD$8H H3H$P  IMHLH$  D$0    H HD$@H$    D$0   E3E3HT$HHL$@X HD$@HcHH HD@HD$@HcHDxDD<   HL$HvHHL$@&HH &HHU HH &H$0  HL$@IHHT$0H$0  H$H  HC$0  Ht$ LD$0IbLD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H  H HCPH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   J   HC HH HCHC@HcHHN HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK\ H HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C Hһ HH( HHH\$PHt$XH0_@SH HHHSH
A H3H
HJHH H< HHH [H\$WH H,
  H
 HGPt
X   H7  HH\$0H _@WH0HD$ H\$@HH HH HAHI HtHP tHC     H HHKs @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HHw HH] HAHI HtHP tHC     H HHKH0[H% LH   ICAC    HQH ICH ICAC   IKkHd HD$(H  HD$@HD$hHcHHk HDhHD$hHcHDd    H6: HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HH HHe HAHA@HcPH HD
@HA@HcPDBDD
<Hݰ HH HAHI HtHP tHC     HU HHKH0[H%: @SH0HD$ HHw HHm HAHI HtHP tHC     H HHKH0[H%Ծ DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H HHOHٵ HHG@HcPHW HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHK HA@H HAPD$P   ϏH HHOHI HHG@HcPHϵ HD:@HG@HcPDBDD:<HSHHDAHH\$HHt$XH0_@WH0HD$ H\$@HH HH HAHI HtHP tHC     H HHK @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   oHg HHOH! HHG@HcPHo HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upHw H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3 HǇHH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HM{AwI_ HSHH;vYHHumH    H=   w9H   HHH;w
HHH	 H+HL$@HH$L<    I~ HHuMtHCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
I HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
]Y f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CTH;}D$`HD$Hf)HH;|LHL$ H#	  (YX f/ArWLe AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
A H3H
HJHH 3HC HC(HC0Hn C8HH HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
X D)PD(D)XD(DYD)`E(D)l$ D((DYYE^YZ S Y=!X L$   L$   3D(DY(DYW Q((T
b f/
(Z    YW HK    VX WA^(Y5W X    AYHDXA\EYAY(YXHuDY)Z A( YV L$   A({E(CE(KE(SE([E(cD(l$ YA(sIH H
 茜HHXHpWH   )pH52)x3D)@WD)HD(D)PD(EY{
D)XD(DV DYDYZY ff     A(Y3P AX(AY Y3@ H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
1 H3H
HJHH 3HC HC(HC0Hn C8HH HCHH [%W (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-JD)@HDqR Ip     D)HI   D
GR D)PDT D)XD)d$PEWD)l$@E(D-U D)t$0D5^ D)|$ D=R )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcB  XY5R Y  f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/z0
   B0
 B  (\YX(\\Y\fD/v\(YX\fD/w(AW f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5
K MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  Hӝ HCPH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   J   HK HH HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHKl H- HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H HH HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3ѿH~ H|$HHS H[eHS8HO|HH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3AH~ H|$HHS H|HS8HO{HH\$PHt$XH0_H\$WH H,  H= HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfoN TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %N II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   hM ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQH; ICHؘ ICAC   IKH HD$(H0 HD$@HD$hHcHH HDhHD$hHcHDd    H HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHϻ HHu HAHA@HcPH2 HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     H HHKH0[H%j H\$Hl$VHA3'K HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PH; HA@Hؕ HAPD$P   H HHOHQ HHG@HcPH HD:@HG@HcPDBDD:<HSHHD1HH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH{ HA@H HAPD$P   Hϸ HHOHq HHG@HcPH/ HD:@HG@HcPDBDD:<HSHHDqHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   HbV H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vSHHMHHumJ    H   w2HCHHH;wHHH H+HL$`HHHM*Hx HHEHuHtH3H9HDHEXH   L   J    H=      M;vLnMu_J    H   w.HCHHH;wHHHN H+Ll$`IIH˘ LHuHt1HM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HG3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpIIHP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   aKHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMXl H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  HQ H3HExMHs HHEHs HHEHE   HE    E 8 uE3IIB<  uHHMHE0   HE(    E ; uE3I IB< uHHMʱHEP   HEH    E8 A   HXs HM8蟱3@      H}H;   H+H   HHuH}HCuHH   LǺ%   HV HH   :
% uH:
% uH:
% u3tH+HHHsHEH}HCEH+Ht+HD$    L
ܶ A   HHM袬H)IE3HUHM8UA   H<% HM8IHMX3LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H& HH    :$ uC:$ uC:$ u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM\IIE3HUHM8HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H H| HD$0HT$0HM%HHL$`wH` HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[A5 f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^A3 f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A2 f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0HoJ H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHHg H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	I HM H3.  H]`HuhH}p(u0He@A_A^]HS HHXHOHLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3ь HXHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$ ! L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3 HVHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$  L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D%- HxEW@      IL$LkM4$Hfo. HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D=) HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  ( C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;tHIHt3{ H5GHLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  H5 H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   DL   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;v@IHU`HtLmH4    H   w.HFHHH;wIHH H+Ll$`II*Hgx LHuHtHU`IHuX3HIDH   H  H  H    H=     M;v}HUhHtL_J    H   w.HCHHH;wIHH1 H+Ld$`II Hw LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   I(3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   IO&LEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   *HIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HdHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
Izu    tH   cu HM`Xu HMhNu H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKWLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH:HL$@Bt HL$HL$   I[Is A(sI_H%t H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	uq Ht
H=HHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;tq Ht
H:=HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"Ho Ht
H;HH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^DD$HL$WH0HD$ H\$HHt$XHH3t$PH[ HA@Hh HAPD$P   H HHOHQZ HHG@HcPH_ HD:@HG@HcPDBDD:<HSHHDQHH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     Af AfYD HH;|Ld$PH;}3IGHp HhIL0 0 YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"H[ Ht
H(HH    H|$0HsH\$8H ^ LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0H  H3HE MLHAp AY1LIIM;vH9HHuzJ    H=   w2J   HHH;wHHH襚 H+H|$0HH8J    HD HHuHt耝HIHFE3EL96LDL}HEH    H=   @@uIM0I;v.MM(MufH    H=   w2H   HHH;wHHH H+LL$0II$H    HYC LHuHt远IE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
I
C @t	IB HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;tIIHOH;tH>@ Ht
HYHH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}fo UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HM
?    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$8cU    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht3= H
HD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%= @UHPHl$ HE H]@HuHH}PHr H3HE HHLBHL;vŖL
MumJ    H=   w9J   HHH;w
HHHu H+LL$ II$J<    H< LHuHtPHC3H9;IDH    H=   LFHHN1   t	H< HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5f MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDX(YLXA(YD
XX

A(YL
YDXA(YL
X(YDXXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+A((YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YX(YLXA(AYD XXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;t6HtHtIHHH;tLLMt#3/ ILHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;t蜈HII;t$I/ HtH9HEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHMosHMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM". HM. HM
. H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$I- HtHIE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4COI;} D$XHEf)HI;|LHL$ IOIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CNI;}D$XHEf)HI;|LHL$ IuNMIIII+L;  L@MtHHIL;  IMIH
HWE3LL9G~L
 L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]虀@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH   L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   fo f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G/5H;}%ff     EHD$@f)HH;|MHL$XH4HEPLM] LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHNEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI  r LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5 )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4G.H;}EHEf)HH;|MHL$PH.6 L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;t\HHHt3 H=HHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3> H^HD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$ . L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3 HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%H Ht
HHL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfo IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI Hfo IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMEI~     RL   L   IH!   H  A_A^[]PLWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK;H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLC1HL$h HL$p L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H  H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	H\ H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHHEK H+HL$@HH	H HHHNNAVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+`	HcAH+2HcAH+hHcAH+LHcAH+HPLHcAH+2HcAH+
HcAH+Ho(HHcAH+diHcAH+HPHcAH+xHcAH+SHcAH+HwHcAH+HPdH;(HcAH+ܠHHcAH+HcAH+HcAH+,
HcAH+HP|PHHcAH+HhH(OgHcAH+ H7PH4H_HcAH+hHcAH+H`fH(HcAH+HPH({?HcAH+RHcAH+HPHcAH+HP,gHsHcAH+HcAH+HcAH+<H(3fH(WH[HcAH+HcAH+HPl&HcAH+HPLHsHfH(?HWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtHXU HHXHJU H [% % % %t %f %X %J %< %. %  % % %~ %p ff     H;
A uHfuHS  H\$Ht$WH E3H
T   m  H
* $ HH   H1 H HA HH HN HH HHtnHtiHtdH%pT  H
  H
YT H @   ?+HH3HH3H=AT HBT H
O   ^  H\$03Ht$8H _E3E33AQR HS Hu     ̹   {  H(H
S  H
S Ht H(@SH HH
tS ~ # H
dS  H [   @SH HH
DS N  H
1S /Y s eH%X   A   LЋX CV H [h   @SH HH
R  ; u4d      ;teH%X   
X A   Hȋ AH
R H [H% @SH H
R Hu0H˨ H3R ?HH  H
}R HH [H H
mR H [H% H\$Ht$WH 3H9=FR u8He H3<R ?HH>  DHQ H

R Ӆ3H
Q ' H
Q E35 H
Q  H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
Q u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
tP H(%  u#  H(H(3%  H(  @SH gP ɻ   DÈWP 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
O u
  t2zH
O a
  gH I¹@   ?+ȰIL3LELEELEMqO LELEELE
iO MeO 
mO H\$PH@]ù     HLMZ  f9uyHcDHH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuHjN H [@SH =N  tu(  !  H [@SH H3 HًH3'N ?HHu
H  HH
N   3ɅHDHH [H(HH(]  @SH Hs HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@=L  t
   r  L    tg	  H
	  5	  H
>	  P	  H H
v 
  u)0t HU H
. ]
  wL    @2@N	  HH8 t$H2tHH?  Lƺ   IpL    H\$0Ht$8H|$HH A^H\$Ht$WH @<L 3ۅ3Pȉ*L =@D$8=K t
   K  JK o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9K 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH HI IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH% @SH H3W HF P HȺ	 H [H%D HL$H8   	  t   )H
J    HD$8HnK HD$8HHJ HWK HI HD$@HJ I 	 I    I       Hk H
I H      Hk H
. HL    HkH
! HL H
  H8@SVWH@H/ H   3E3HT$`H Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$  ǃ|H@_^[H\$UH$@H  ٹ     t)%N  HM3A    HM H   H  HE3o Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 36 H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T    HD$PHD$@HEHD$H3 HL$@ u
! M H$  H  ]@SH HHH
 HHS3H
HJHHl  H! HHH [3HAH HAH HHH HH  H\$WH H HHH  t
   HHH\$0H _HHHL$ H[ HL$   HHHL$ ZHGU HL$   H\$H|$UHH e 33<    D)    cAMDDDAentiAineIAntelEDDK AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
 A%?DIK = t(=` t!=p t wH     HsADK Eu  ` rADJ    UDM;|$3E]MU]	sADJ Asn        AsSAsL3H HHUHE$<u2ؚ ǚ    E  t      H\$83H|$@H ]̸   39 H\$ UHH He H2-+  HM H;uoHM HEHE H1E HM H1E E HMH H3E H3EH3H  H#H3-+  H;HDHٙ H\$HHHҙ H ]H(uH=s  uS    H(H
QI H%B H
AI   HEI HEI H(HHH(Hg H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _%* % % % % %$ %& %( %* %, %. % %j %l %> %0 %" % % % % % % % 33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D%u D)xEWY5| fA.zuT=A D\   D)$P  (T$ (T
 D(f/D)$0  D)$  EYv
D(^^D((fE.D} zuA('YAX(6 L   (H   AYfE.D($  z.u,fA/w	D; (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0舿L(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3̅tH H H H H H H(H H9A   LAIHH3H+H.MtAHIHEH(3HIHEH(IIw;HWB< HAIHHH(ËAIHHHH(H(H% H\$0 HHuHH\$0H(HH|$ q H+Hu
HSHR0H\$0HH|$ H(         @SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
n H9Ht6H HH [<    HuH
 HQ H	 HH [@SH0HAH      t-H
P LYP LH   H	W u/HH0[H
s LH@LHP HD$ H	 H+u
HCHP03H0[E3H;
 AAH;
> H;
 AAuH% H\$WH HHHIH H;t6 u,LHT$0H HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _@SH H=     H D  C
HKt1{ t 0HSLCHMtE3  
HSH HKHHCHHtU HtH(H{ u3H [ÃH [H\$ UVWAVAWH   HΎ H3H$  ILLT HH1  HW H/Hu
HWHR0H  I HH   HHz H.Hu
HVHR0H+u
HSHR0H   HG    |H
 HL MMH	t tHG H;vBHl$0LL HD$(HL$@MLt$    0 E3HT$@3 x.HJtH
> HL Hl$(MMHD$ H	 H/uHGH
H+u
HCHP03H$  H3H$h  H   A_A^_^]@SH  HHuH [HH|$0 H+Hu
HSHR0HH|$0H [H(  H H3H$  A   D$    L& HL$4AQ  L*    LHL$0 D$08D$4u%D$28D$6u3H$  H3+H(  HD$0   HD$(LL$4HxJ LJ HD$ HL$@ A   HT$@3> H$  H3H(  H(H'  H H
gD H HQ [ HuH; H(HH
U   H; HuH(3H(H(=T     H
 G z Hu13
 H
f HF A   H	X y/H(H   ZT    HHtH(uH@P0H
>G  Ht$HK   HtH(uHPHR03H(1 3H(   H\$WH0H HH   Lr HCD HJ    L;: H<D H+    LH9D H xoL}E H&D H xTLHD$     LH
KD    Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0H\ H
 HC A   H	 yH/u
HGHP03HH\$@H0_@SH HQHLIMtIHD$XAt 3ɉKpHK@HKHHK HK(HK0HK8HtH HCXHD$PHtH HCPHD$`HtH HKhHHC` HH [H\$Hl$Ht$H|$ AVH@H
8 IH5}D HH-+B L5LA  HtHt$0LHl$(HHLt$ H\$PHl$XHt$`H|$hH@A^H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
 HA H	 H(HAXHHD H H(LHt4HB      t$HIPHIPPHt
H)uHAP03H(H
) H@ H		 H(HAPHHD H @SH yp H   Hl$0Ht$8H|$@Lt$Hc HHhPHpXLp`3HGPHGXHG`9CpuHt3H  HHuN HtHP 
H(uH@P0MLHHI  Lt$HH|$@Ht$8Hl$0H [@SH H H{8 t	H {p |H H9 u Hd H$   HH [H% H [H\$WH H3HIHtH{H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HKhHtH{hH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _LI[WHP3HIC H
 ICA   ICHICHIC ICEAICIC u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0yt HHYHHt!H
 HA< H	 3H0_][Ht$PHt  HH t$xL I;t5HB    }      @t3H
  IH tetaHH  H+u
HSHR0HOHHtHGH    H)uHAP0   3H  HHt$PH0_][P  GtHHCH;>2 u(HD$pHLL$hLD$`t$(HD$ H'  L   H7 MtA6 HH   H+u
HCHP0H
 H	 uHt$PGt3H0_][6 HOHHtHGH    H)uHAP0Gt LD$hHHT$`=  3H  HHu' H9XPuH
u E3E3HHHD  HHt$PH0_][HT$pHHt LL$hHLD$`HD$      H.Hu
HFHP0Gt H+u
HCHP0Hu7HL  HHu'^ H9hPuH
 E3E3HHHC  HHt$PH0_][H\$WH yt HHYHt$H
 H{9 H	2 3H\$8H _HtIHHHt$0  HOHHtHGH    H)uHQR0H+u
HCHP0Ht$0uH
 H	G 3H-  Ht4H(u
HPHR0H
Y H29 H	 3H\$8H _f Ht*L HH@ M H	  # H H\$8H Hq H _@SH HHIH{t tH
 H?8 H	 3H [HtGCtHAH;. uH;: u
3p    Ct Hu!HH [B  H HH [  H [H\$Hl$Ht$ AVH H. 3HLH9BuHHH      AtHHBH2 H|$0L   MtAj HHu%H
 H	" u	H  '3HB H/Hu
HGHP0HDH|$0AFt HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIH{t tH
& H6 H	F 3H [H   CtHAH;F- u\H; u3H;C HD >H;x u3H;% HD  H; u   LH1 3  Ct HuDHP   H  HHu'X H9XPuH
 E3E3HHH?  HH [H\$WH 3HHIHHD$0HtHGHH)uHAP0 HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu' H9XPuH
 E3E3HHH?  HH [H\$VH ApHHمu2Ht-H; t$H
t H4 H	T 3H\$8H ^Ãu"HtH
v H	 3H\$8H ^H|$0 H{  HtSHC0HtHHHGHtH HGHAHC LGhHWpHOxHGhHC(HGpHC0HGxLC HS(HK0DH   HGhHC HGpHC(HGxHC0HC HtH HC(HtH HC0HtH LCtHHSH|$0Ct H\$8H ^HtH
t H	H% H
) Hr3 H	H% H
 H23 H	H% H\$WH HQ 3Hy(HY0HA HA(HA0HtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWAVAWHH HqP3HYXLHy`LHu0H]@H}HHAPHAXHA`HuGHtH/u
HGHP0H]@HtH+u
HCHP0H H H I  H L I;   HuH H H H}HHu0jHKI;u	H[@H-      t<H{|	H[HH H H HM@H)uHAP0H}HHu0I@     H   HtH/u
HGHP0Hu0H.  HFH  HF    }      @t3H  IHG H}HH]@Hu0u%LLHI;  H\$XH A_A^_^]LEHHU@HM0 HE@HHH HH;t2˾ u(LMHILE@HU0:  H\$XH A_A^_^]HMHHt
H)uHAP0HM0H)uHAP0HE@HX@HHM@H)uHAP0I3H\$XH A_A^_^]H\$HHYhLYpLQxHAhI HApIHAxHH\$MMH\$Ht$WH HHHQHH3 HHttL@A      u	H+/ HG H9C t-HH/ H
Q LGH	 H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
  H	 t H xHWLHp xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _~    uHHп uH\$0H _ø   H\$0H _LH;u   HA    }      @t3   H%s E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
8 AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL;ؾ AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H;r ø   Htfff     H   H;tHu3H;6 ø   H(HA      tiHQHHtVHtHHt0Hy H
p Hi+ H	 HH(H(H%T AIHHH(ËAH(3H(H\$0HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,H= H3H(ËAH(ËAH(H(H%/ H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(Î= = = |= u= = = = = H(HA      tEHAHHw,H> H3H(ËAH(ËAH(H(H%O H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(n> n> n> \> U> f> n> n> n> H(HA      tEHAHHw,H? H3H(ËAH(ËAH(H(H%o H\$0
HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(N? N? N? <? 5? F? N? N? N? H(HA      tEHAHHw,H@ H3H(ËAH(ËAH(H(H% H\$0-HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(.@ .@ .@ @ @ &@ .@ .@ .@ H(HA      tEHAHHw,HhA H3H(ËAH(ËAH(H(H% H\$0MHHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(A A A @ @ A A A A H(HA      tTHQHHtAHt3HHyH
2 Hk# H	ڵ H(H(H%/ AH(3H(H\$0^HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,HwC H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(îB B B B B B B B B H( H(H( H(H(ִ H(H( H(H( H(H(v H(H(v H(H(6 H(Ht$H|$ ATAVAWH L%M# AL LtHv  tDADH\$@Hl$HEt8H-_ Ht,L H  ;> }HHD9Du
H\ H,MDƋI   HHthtHЋ  Ls! E3HIܴ HHtHȉp|` HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH|$XH A_A^A\H\$Hl$Ht$WH   HAIɋ  HHtVtDL HH
  	Hϳ HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_H E3H
# E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$     Я H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H=2 HڋHuH   - H  hHHH  @       H\$@Hl$HH _Ht$0Dŋ5 HϋLt$83  LcD;}'IH9luHHH)   HAP0} ;u.p@HHcHo HHtX5e 5[ H\ HcMI;~#HHHI+@ AHIAHuMƉ5 BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H= Ht/ H9   ; }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@VWH8HH
} H  H\$PHl$XLd$`Lf`Ll$0E3Lt$(LvPL|$ L~XLnXLnPLn` H HtLBH HTH
 HAL   MtA HHt@H H- HE- H+u
HCHP0HtH AE$ Lh AH. H
  MMIH)  L|$ Lt$(Ll$0Ld$`Hl$XH\$PH8_^H\$WH HAHL   MtA HHu.H
Q H	p tH
 H LH	Ҭ HH\$0H _H\$Hl$VWAWH0333HLHu3 HH   HH
 Lt$P LHt~ HHtp.   H
B \ Ht<LD$    LII HHu7H
ƭ H	 t# LD$     LIIa HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^HAH    tH%    Hl$Ht$WH HBHHiH      uHl$8Ht$@H _H%Q HH\$0c HHu"H
l H LELH	 3:H H@L  Mt$LHHAH+Hu
HSHR0HHH\$0Hl$8Ht$@H _H(LALH
 HG H	~ 3H(LI[IkVWAVH0HAP3ICIHAXMCICLHA`ISHi`HHiPIHiXIKICq H9nP   HD$PHt(HL$(HǨ    HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHVhLH~pHH^xIHNhLFpHFxHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP03QHL$ I.H/H+Ht
H)uHAP0HL$(Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIPLH;u   Hu3HB      2   HA    }      @t3H%C H\$UH HjE3HH~HB H;|   IHL;|Ht$0H|$83H   HrfHH;   HC    }{      @toHX  Ht4L@3M~HH9tHHHI;|3H   H\$@H ]H     H   H;tHuH;    	HK u'HHH;O3Ht$0H|$8H\$@H ]ø   H\$WH LQhHypHYxHQhLApLIxMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _HAhHHApI HAxIHHtH I HtH IHtH H\$WH   H3HH9HHDG< u#Hl H;HC8HC0Hz~ HC@H{FDK$AtPH
? H A   H		 H9;tH=~ H9C@uH{@H: H$   HĐ   _H$   HL$@  HS(HL$@  HtCH
g H;tbLCHS HHJ L
D HGIHD$0H= H LOHL$(Hj H
s HD$ H	E 7H9{@uHs} HC@3H$   HĐ   _3HHAH  HA8HA0H1} HA@H9 tH} H9A@uHA@    H% H\$HT$UVWH HHL"fHH}  AtV 3A<V IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLOH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <9}4HÍv4p<0}H\$Hu,H
p H	 DH	< t*LHcHG(H
 H
6 H	] 3H\$@H _^]H
 Hp	 AZ   H	 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]H cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]fU S U T T S  S  T -S  T PT S U T  







































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtHd
 H
E H	l 3    t   LA       )   эB<       A<	  CDA0H<0|f<9}CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGH	 DHHH
; D@XH	    HGHcHLH
 MDHQ	 H	 gH
 Hh	 DH	Þ JH
ڞ H DH	 3+; uH	 eHCGGHG(   IH H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
 LMHd H	 Ld$XH(A^[D8cGu+DAXHj H
 H	 Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
 H LH	 H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH{ LICHD$(IM HD$ GHuL
 L H LG HL	AHDAP@  HD$(H LT$ MH
Ԛ H	 H8H(DA@1wVL
HAt] AX] IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
R H H	" 2H( ] )] 0] ]  ] ] 7]      H(DA@4wEH8H8^ $^ H   H(ø   H(ø   H(ø   H(H
 H  H	S 3H(] ] ] ] ^       H(DA@4wEHhH_ ^ H   H(ø   H(ø   H(ø   H(H
 H  H	 3H(î^ ^ ^ ^ ^       H(DA@1wqL
HA` A_ I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
 H H	 3H(À_ _ _ _ _ _ _      H(DA@4   L
HA4a Aa I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
 H H	Ӗ 3H(H
 H H	e 3H(f` ` ` ` ` ` ` `       Hs   L|A b Adb IH H H H H_ H{ Hg H Hg Ho Hw ÅH
 H HEÅH
 H HEÅH
 H HEH H H H H H  Qb a a a a 9b Ab a 1b a a b a b a a a Ib a Yb  	

DH H
N H	H%$ @SH HDA@<	w<BHA؃0<0|<9}H[X<0}HtH [ÃHH H
˓ D H	 H [HDA@<	w7BHEA0<0|<9}GHE@F@<0}HAÃE3H> LJLm HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=m Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJH HHHL$ H
 H	- 3H8fD  H   H;tHuH; t   H8H\$Ht$WH LAHIxpHt[H tTHK MtI	HL͐ HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
ϒ H M@H	[ H\$03Ht$8H _H(H H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H(ڏ y,H(LH /   HHtH(uH@P03H(H\$WH HAIL   MtA( HHuH\$0H _HH*   H+Hu
HSHR0HH\$0H _LI[IkIsI{ AVH0HЏ 3LH9A   HiH   HYHCH;} uISDGISIkH     H; u=HKQ=   u*Hl$ Lt$(HA uH{E3HT$ HEA]    HHtMHE E3HhHIHLp HM  H.Hu
HVHR0H+uHSHR0#  HH\$@HH|$XHl$HHt$PH0A^EH;uH H H HAH; uCLAIHH3H+HMtQ3ҋIEA;tHi H H_ H;G uAfAnf.zuzA   H% H\$Ht$WH H 3HH΋H9CH9G5  C u
H xG u H~ yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM1 @ƋH\$8Ht$@H _LT I;uUI;@ƅuJA   HH3 HHH迴H+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HH t/HD$8HH      tJE3LD$8HT$HHō uLL$8MtLH
@ L H* H	ɋ 3H [H
 L H H	 3H [ø   H [H\$Hl$Ht$ WH H3H
 IHL;u3H;Lt$0HMHDߋ      Ht:Hg   MtH I9@tH
i H H	I h  HHHH Ht( HH`H;tHHp`Ht
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHI\ t   IMMHC      tHHӹ    3 HHtuE3HHO H+Hu
HSHR0HtNLOHA      @H
  H LH	 H H
 H	 Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4IS   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@% HLL$pH8G `<`uHH@Iy( uI LL$pAA `<`uIAIA@H;u-HIH	V yB H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$ Y q3H\$`H0A_A^_^]HY@% HLL$pHC `<`uH[H[@Iy( uI{ LL$pAA @t
 tIAIA@H;u)HIH	D ؅y0 HuqLL$pt@HI;H H
/ L$   H	 H\$`H0A_A^_^]H H
 HK L$   H	 H\$`H0A_A^_^]LLH
 H H	H%B HHLT$pH M;LT$0MLH
k MML
 IML
 H H	LDIH HDHG HD$(L\$  HHH\$Hl$Ht$H|$ ATAVAWH H HL`PLpXLx`3HEPHEXHE`MtI$MtIMtIMMIH      ׇ Hf HMPHHuXH}`LePLuXL}`Ht
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
S 
 H H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAPHHAXI HA`I3HAPHAXHA`H\$WH LQPHyXHY`HQPLAXLI`MtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
Ӄ H A   H	 H(H(   H\$UH  HHXPH   H
 LI;tCHK    }      @t3HIH uH\$@H ]3Ht$0HuXH|$8H}`HE`HEPHEXH+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HH LL
 H
 HU LDH	H%_ H
i Hz A   H	H%2 @SH H 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H  ËH [L I;AuI;AuA    HHu	H [HH|$0耩H+u
HSHR0H|$0H [@SH Iс Hu> Ht3H [HH H [Hl$Ht$WAVAWH E3IILHL9quL9qum  y3   H\$@L9wtAG t;    HHtsHE HHhIHHp G tE3W=W8   ˀ HHt8IE3LxHHE Hh HHp(HO	  LH+u
HCHP0H\$@IHl$HHt$PH A_A^_H8HALHt)y    LD$ LL$(uE3HT$ IEAH8H8Hl$Ht$H|$ AVH 3ILHH9iuH9iu  y3   H\$0H9ot9G t3    HHtcHHHpIG tE3W5W0    HHt0IE3LpHHHp HO  HH+u
HCHP0H\$0HHl$8Ht$@H|$HH A^LD$H(LQLMt4A uIIAH(=   uE3D@HT$@IAH(H(@SH HAHH	HHAL   MtA~ LHu	H [LKIAH H;tcHX  Ht1LA3M~eHfH9tAHHI;|3H [    H   H;tHuH;    tIA(HHHKIA(HᏉK 3H [@SH H~ HuJ~~ Hu7HӍH~ HHt#H
~ HH	 H+u
HSHR03H [H H [@SH LAHHH
 {{ Ht	H H [} Ht3H [HH [U	  HH;}HH33H%N} LL$8E3HMtIH%4{ HAH@pHtH@HtH   Ht$WH0LAHHI@hH   Hx    HH\$@觡HHuY } HtNHT{ HHx~ t%z LGHS H
D} M@H	{ 3H\$@Ht$HH0_A   HHD   H\$@Ht$HH0_H
| H M@H	9{ Ht$H3H0_H\$Ht$H|$AVH Lq3L;5y HH   L;5z uDLI?AEDuHQHH;WHH?   HD   MvhM   I9v   EtGHyBIHt:HxHHHAV   H
y H	y u3   :y HHAVtHH?EuHWHH;WHH?u5H){ HHtHH]x H+Hu
HSHR0HHGHH H\$0Ht$8H|$@H A^@SH HHu3H [H|$0w H+Hu
HSHR0HH|$0H [HAH;{ u
E33)  H;*| uHA@t3/  H E3  HT$H(HAH;{ uA   HT$8  H(H;{ u>LAA@t
   H(Äy$MP t3HIE3HT$8EAAH(   H(H\$Ht$WH HH   x HHuH\$0Ht$8H _HE3HHxH#  H+Hu
HSHR0H\$0HHt$8H _H\$Ht$WH HAH@ Hpt3HYz @ H Hz ;~#H
 w t3H\$0Ht$8H _HHH
_z H؋   ~z<RIz H 9x }
;z @$ Hu"|x HuH
 y H9 H	xw Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Hu%y    y @ H Hy ;~H
b v t3lLHHH
jy H   ~ZRTy H 9X }
Fy @$ Hu"w HuH
+x H H	v HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyLLqHHY Icx @ DH Hx D;~H
[ u t3    uL CuFHu9wuLMIH   |u%Ht LCHcGI;uHSMH   UfHU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ 5u HHw    ~YIw H 9X }
w @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHHu E3LHHLv HHt\H~.Hx  fff     HHIH[H HCHAHu3HYv AF HH/u
HWHR0AN HH\$0Hl$8Ht$@H|$HH A^HA@ LPt3E3IHIE3ILH H
u H	H%s HB      tHAL   MtIH%t H\$WH HH
$ HHAL   MtAs HHuH
t HX LH	r HH\$0H _HAL   MtIH%vs @WH Hc 3Ht	H H _H\$09   HZz H e     `  H
 H  H=_  tD: H
 3H
 H)uHAP0H\$0H     H H _3r H Hu'Hy H%     q `  e3H
Mx p HF Hu'Hy H     / 
`  #3H
x s HT Hu'H@y H K     `  ۝y'Hy Hq      `    H
> 6p H HuVHx H,     x 2`  r HuH
r H H	q Hg H\$0H _H+p H Hu'H`x H k    
 4`  Hq H
 H qo H: Hu'Hx Hw !     6`  H
 1o H" Hu'Hw H7      7`  wL Hp H
 p y'Hw H     = ;`  1;  y'H`w H k    
 =`  9= tFL H H
 Ep y'Hw Hs      B`  n HHu'Hv H>      F`  ~H H]m HuBL H H1o y'Hv H     3 H`  '1  y'HVv H a     M`    y'H&v H 1     O`  
    'y'Hu H=      Z`  }k  u'Hu H  #   X d`  LH
 3HHu'Hnu H y &    m`  H LH
u /l yE &    o`  
  H+u
HCHP0H
 3|HHu'Ht HN  '    y`  H LH
 k y '   f {`  	  H+u
HCHP0H
 3HHu'Hlt H w (    `  
HU LH
s -k yC (    `  }	  H+u
HCHP0H
 3zHHu'Hs HL  *    `  H LH
 j y *   d `    H+u
HCHP0H
 3HHu'Hjs H u ,    `  H LH
q +j yA ,    `  {  H+u
HCHP0H
 3xHHu'Hr HJ  -    `  Hz LH
 i y -   b `    H+u
HCHP0   i HHu'Hkr H v .    `  H\ HH HKHK HH H HKH HAH
h 苽HHu'H
q H
]  .    `  O  H+u
HCHP0H H轼HHu'Hq H  .   [ `    H LH
 oh y .   ' `    H+u
HCHP0H H;HHu'H,q H 7 .    `    H LH
3 g y .    `  =  H+u
HCHP0H/u
HGHP0   
h HHu'Hp H  /   K `  ?H HH HOH HH H HOH HAH H HOH HAH H HOH HAH H HOH HA H
 sHHu'Ho HE  /    `  G  H/u
HGHP0H H襺HHu /   Q `    H LH
 ef y{ /    `    H/u
HGHP0H H1HHu; /    `  u  H LH
7 e y /    `  A  H/u
HGHP0H} H轹HHu /   i `    HM LH
 }e y /   5 `    H/u
HGHP0H HIHHuS /    `    H LH
O 	e y 0    `  Y  H/u
HGHP0He HոHHu /    `    H5 LH
 d y 0   M `    H/u
HGHP0H+u
HCHP0H
) HHu'HEm H P 2    a  H@HH L   MtAe HHu
 2    a  D  H+u
HCHP0H E3HHHu'Hl H  2   [ a    H/u
HGHP0Ho LH
 3]c ys 2    
a    H+u
HCHP0L H
R= 3:d HHu'Hl Ht  o   a  H LH
 b y o   a  $  H+u
HCHP0LP H
J 3c HHu'Hk H  r  7  a  +H LH
 Kb ya r   "a     H+u
HCHP0b HHu'Hk Hr      *a  L HHH a y ,a  %H LH
 a yTm -a      Hj H H+u
HCHP0H5H/+HGHP0H+HCHP0H  H\$0H _33H(A`  H' H
p ËH Hu*Hi H1  	   } _  H(A`   Htz H
{ tH5 Hu    < _     AH
  H H
'| 6H Hu\     _     A0  H H
| H1 Hu     _  tAP   H H
~ 轊H Hu     _  9A   H H
 肊HK Hu* h  J _  Hh H H(3H(H\$Ht$WH H= Hq_ y? E    Z_  A  3H5H9  H uH H;=a HDH H
 H L` y E   { __    H=o H= B H^ y   G a_    H9B HB uHSB H;` HDHAB H
* Hk Lb` yH    f_  J  H50 H= HF^ y f    h_    H90 H=H/ uHK0 H;` HDH90 H5 H57 H] y i   R n_     H98 H7 uHN8 H;_ HDH<8 H5 H5H H] yS    t_  XH9I HH uHI H;]_ HDHI H5 H5D H+] y5    z_  He H- H\$0Ht$8H _H9 H, uH{ H;^ HDHi H\$03H5 Ht$8H _333H(HM] H> Iy (_  .  & ] H Hu )_     _] H Hu *_     $ 6] H HuX +_     ; 
] H Hu/ ,_      \ H- Hu -_  d3T] Hu Hu ._  D   1] H Hu /_  !   ] H Hu* 0_  Hc H2     H(3H(H   H    /] H8 Hu |  / ^     H    \ H	 HuV ~   ^    H    \ H Hu    '^    H    \ H Hu    2^  [  H~    S\ H Hu   S =^  $  H    \ H
 Huz 3   H^    H    [ H HuC 5   S^    H
Z LHUY H Hu f   ^^  ~  H
Z LHY H Hu f  u a^  F  H    >[ H Hu p  > l^    HJ    L
> L Hh HD$(H HD$ Z H Hu? y   w^    H
    Z H Hu 3   ^  {  H    sZ H Hu 5  s ^  D  H    <Z H Hu C  < ^  
  HP    Z Hn Hu-HR` H U     ^  HĘ   HE    Y Hk Hu-H` H` 
     ^  HĘ   H    oY H Hu-H_ H    a ^  HĘ   Hg    $Y H Hu-Hq_ H t *   ^  HĘ   H|    X H* Hu-H&_ H ) .   ^  HĘ   H    X H Hu-H^ H4  B   ^  HĘ   H    CX H Hu-H^ H    5 ^  HĘ   Hs    W H Hu-HE^ H H    ^  HĘ   H(    W H Hu-H] HS     ^  HĘ   H}    bW H Hu 2   b _  3  H.    +W H HHu o  ( _    H E3H2 HT$pD$ho  HD$`H HD$XH HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    S Hh Hu o   _  h  H    L
 L Hѽ H$   H HD$xH HD$pH HD$hH HD$`H: HD$XH. HD$PHb HD$HH HD$@H HD$8H~ HD$0HJ HD$(Hf HD$ U Ht HHu _     H E3Hl HT$pD$hr  HD$`EAHg HD$XHk HD$PHD$HHL$@HD$8HD$0HT$(3D$    JR H Hu-4 _  ~ r  H[[ H HĘ   3HĘ   H(H
m  H Hu*H
[ Hn      ]  H(H
[ H Hu*HZ H, ּ |  x ]  H(H
 |H Hu*HZ H  W  6 ]  H(H
? :H{ Hu*HGZ H R _   ]  H(H
 H Hu*HZ Hf  =   ]  H(H
 H Huܻ    ~ ]  ZH
 H Hu *  P ]  ,H
 ZH Hu*   "  ^  H[Y H H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HQ HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
z Hz  @ǅtH@ H
T H\$0H _HH\$0H _H@  @SH 3LHy  
 t=Hӻ Hc
 H3HHCHCLCH   XN HH [3IA0  HHuH [@SH H;P HHIHCH)P H Ht
H)uHAP0H
P HKHCHO H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HO HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
n Hz  @ǅtH H
H H\$0H _HH\$0H _H@  @SH 3LHy  
 t=Hs Hc
޶ H3HHCHCLCH   HL HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H%N HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH  H
 H\$0H _HH\$0H _H@  @SH 3LHy  
4 t=H Hc
 H3HHCHCLCH   J HH [3IA0  HHuH [@SH HL HHIHCHyL H Ht
H)uHAP0H]L HKHCHNL H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HL HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH` H
l H\$0H _HH\$0H _H@  @SH 3LHy  
  t=H Hc
 H3HHCHCLCH   H HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _HGJ H HIhH)uHAP0H,J HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _HI H HI`H)uHAP0HI HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _HI H HIXH)uHAP0HH HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _HgH H HIPH)uHAP0HLH HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _HG H HIHH)uHAP0HG HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H'G H HI@H)uHAP0HG HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _HF H HI8H)uHAP0HlF HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _HE H HI0H)uHAP0HE HC03H\$0H _HA0H HA0@SH HHt
H [O  HiE H HI(H)uHAP0HNE HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _HD H HI H)uHAP0HD HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _H7D H HIH)uHAP0HD HC3H\$0H _HAH HA{  H\$WH HHZD HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH HKC HHIHCH9C H Ht
H)uHAP0HC HK HC HC H Ht
H)uHAP0HB HK(HC(HB H Ht
H)uHAP0HB HK0HC0HB H Ht
H)uHAP0HB HK8HC8HB H Ht
H)uHAP0HqB HK@HC@HbB H Ht
H)uHAP0HFB HKHHCHH7B H Ht
H)uHAP0HB HKPHCPHB H Ht
H)uHAP0HA HKXHCXHA H Ht
H)uHAP0HA HK`HC`HA H Ht
H)uHAP0HA HKhHChHA H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAuT>   HH|$Hv@ LD$0HT$8HL$@> HH{HtHH  H TLD$0HT$8HL$@H> HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  H@ E3HL 8  HH	  H3> LHCHH"> HH H> HC H
> H H > HC(H= H H= HC0H= H H= HC8H= H H= HC@H= H H= HCHH= H H= HCPH= H H= HCXHw= H Hm= HC`Hb= H HX= HChHM= H 
} y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [U H< H HI`H)uHAP0H< HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _HG< H HIXH)uHAP0H,< HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H; H HIPH)uHAP0H; HCP3H\$0H _HAPH HAPH(Ht	H(W H
8 H H	: H(H(AH: Hu;H5B H @ X    G  G  H
nb AX   3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _Hg: H HI@H)uHAP0HL: HC@3H\$0H _HA@H HA@@SH HHt
H [Y H9 H HI8H)uHAP0H9 HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _HW9 H HI0H)uHAP0H<9 HC03H\$0H _HA0H HA0H(Ht	H(Z H
6 H H	8 H(H(A(8 Hu;H? HF  T        H
N^ AT   賄3H(@SH HHt
H [8\ H98 H HI H)uHAP0H8 HC 3H [HA H HA @SH HHt
H [X] H7 H HIH)uHAP0H7 HC3H [HAH HAH(Ht	H(] H
5 H  H	7 H(^ H(Ht	H(_ H
4 HH H	6 H(H(IL$0?7 Hu;H> Ht  P    j
  j
  H
\Y AP   3H(H\$WH HH7 HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H6 HHIHCH5 H Ht
H)uHAP0H5 HK HC H5 H Ht
H)uHAP0H5 HK0HC0H5 H Ht
H)uHAP0H5 HK8HC8Hx5 H Ht
H)uHAP0H\5 HK@HC@HM5 H Ht
H)uHAP0H15 HKPHCPH"5 H Ht
H)uHAP0H5 HKXHCXH4 H Ht
H)uHAP0H4 HK`HC`H4 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu1 @  HH|$H3 LD$0HT$8HL$@a2 HH{hHtHE  HGLD$0HT$8HL$@H`2 HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  H4 E3H- 8  HHuH(H2 HAH2 H H1 HA H1 H H1 HA0H1 H H1 HA8H1 H H1 HA@H1 H H1 HAPH1 H H1 HAXH1 H H1 HA`Hu1 H HH(H\$Hl$Ht$WAVAWH L3/ HHu'H~8 HϠ y =    X     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHH/ u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_c X  
W X  H7 H  =   H/u
HGHP0HtH+u
HSHR0Dg H
T  9|3tH\$Hl$VWAVH L3c. HHu'H7 HU  =    W     In3I+.HHtafIL$H. HHtiHGH9G ~HHOHHHHOHH- u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^	 W  
 W  H>6 H 9 =   H/u
HGHP0HtH+u
HSHR0D
 H
  z3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H;
, tgH;\- t^IH- HHu/H>5 H A/   D6 eW  ז H]_  H@L   MuSgW    HLL Mu8H+ H9GuL;w1  HGJL;w  J\HIHAHHG  ILHt
H)uHQR0HHM]  HHEH;t?HUHtLEL+IH)HH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPH@$- Hu`HUHMHHMHUHLEL+I(,) %) ) ) ) A0   W  f, H   H
) LI;   HH    }      @t3HnIH- uZW  A/   H]H2 H> D  HtH/uHGHP0Dɔ o H
P w&) H/u
HGHP0HUIH]MtIm uIEIP0HtlHEH+HH;v' H    H=   r<t' HCH;r' H+Hs' H'v' HH>H]H   HUHHMH+H*HHHH?HH
H;vS' HRHH=   r<t7' HCH;r'' H+Hs' H'v
' HH6>IL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;]' toH;( tfIH( LHu/H0 Hߘ A/   D V  ' Hu  H@H   HEPHuV  Hu  HLHHMPH]HuHu8H& I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HrEHu	) HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMJZL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMYL}H]HuHt;HH]HEP7A0   #W  H}@H?   H
Y K  H
Y =  ~' H   H
$ LI;   HH    }      @t3HgiIH( udW  H}@H?A/   H- H D Y MtI.uIFIP0D 7 H
z cr8$ I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v" J    H=   r=@t" HFH;r" H+Hsv" H'vi" HH9HH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH;" twH; $ tnIHQ$ HHu3H+ H3 A/   Dڍ V  { H]L}9  H@H   HEHuV  H]L}  HLHHMH]L}Hu8H" H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  H7HE   HE    E HHMAHEHrDHHMH=   r0  HAH;  H+H  H'  H 7# H  HE   3H}@}IE3HUHM[<HEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHMdLuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHMWcLuH]L}Ht*HC   H{H{rHHHU  H?H H]HMHE$        H
S M H
S ? A0   V  H}co! HH   H L I;   HA    }      @t	3Xc	I" uZV  H}A/   H' H D W HtH.uHFHP0D 5 H
t al2 H.u
HFHP0HUH}H)LuH]L}MtIm uIEIP0HM-MtHIM+IMIJ*HHMH3[,H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
C H;E  H; 8  H HHu     /V    H@L   HEo    HAHHt[HEo   HAHHtEHAHyH
% H
 Z 6V  UH+9  HCHP0*  H+u
HCHP03u	HMoH\% H  >V  M    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   H4 H
 H	 2Mx-Hi# L
{* ILDH} H
 H	     < V    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+IV Ht MV  eHHMQ  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I=) Ht@@ NV      Hw# Hȋ Du  H
Lp Gh   HUHMuHHUHM%HHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+Il(HUHtLEL+IHUHtLEL+IWELmHUHtLEL+I(MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I'HUHtLEL+IIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;- toH;| tfIH LHu/H^! H A/   DV U   Hu  H@H   HEPHuU  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HcEHu HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMKL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMJL}H]HuHt;HH]HEP7A0   U  H}@H?   H
aJ  H
SJ 
 N H   H
 LI;   HH    }      @t3H7ZIH udU  H}@H?A/   H Hֆ D ) MtI.uIFIP0Da  H
j 3c8S I.u
IFIP0HUH}@H{L}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@tf HFH;rV H+HsF H'v9 HHe*HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H;{ 8  H$ HHu~    `~ IU    H@L   HEo    HAHHt[HEo   HAHHtEHAH讐yH
S H
 } PU  UH+9  HCHP0*  H+u
HCHP03谐u	HMo蓑H HM } XU  }    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hw H
 H	 2Mx-H	 L
! ILDHPt H
 H	X :}    | 5U    H;u
Hz HrHrH~H6HHE3LLHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+ID  HtG| gU  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I Ht@{ hU  *|    H Hh D| { H
,f ^   HUHMHHUHMHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+IHUHtLEL+IHUHtLEL+IWELmHUHtLEL+IMtI/u
IGIP0MtI.uIFIP0HUHtLEL+IqHUHtLEL+IWIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH; toH; tfIHm LHu/H HO A/   Dy T  y Hu  H@H   HEPHuT  Hu  HLHHMPH]HuHu8H; I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HATHHEHHuv HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHMDL}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHMCL}H]HuHtH;HH]HEP1A0   T  H}@H   H
@  H
@   H   H
0 LI;   HH    }      @t3HPIH+ udT  H}@HA/   H Hp} Dw v MtI.uIFIP0Dv v H
r` Y8 I.u
IFIP0HUH}@HL}HuHMtIm uIEIP0HthL+IL;v
 J    H=   r=@t 
 HFH;r	 H+Hs	 H'v	 HH HH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH;'
 toH;v tfIH HHu/HX H{ A/   DPu LT  t Lu  H@H   HEPHuNT  Lu  HLHHMP=! H]LuHu8H	 H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0Hk
 H9GuwuHH0 (EHf.zu HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHM?L}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHM)?L}H]LuHt3HH]HEPA0   yT  H}@H   H
.<  H
 <  
 H   H
c LI;   HH    }      @t3HLIH^ udiT  H}@HA/   HR Hx DPr q HtH.uHFHP0D.r q H
Z  U8  H.u
HFHP0HUH}@HL}LuHMtIm uIEIP0MthM+IL;vP J    H=   r=At3 IFI;r# L+Is I'v LI2HH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is H H3HD$hHHIK3t$ HA   HqHyrHH@0D$    HJH8	 H;t-} u#LD$(HT$0HF x,HT$0LD$(LGLD$(MtHW(H Hu>H_ Hv Zp    o T  T  A   H
Y S   HD$`   Ht$XD$H HL$H+HT$HHHD$`HrQHHL$HH=   r<t HAH;rp H+Hs` H'vS HHHL$hH3L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3 HHu'H>
 Hu 9o =   n S     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_#n S  
n S  HX Ht Sn =   H/u
HGHP0HtH+u
HSHR0D'n H
W m P3tH(HyHQrH	P Hu;H Ht m 2   im sS  sS  H
U A2   P3H(H\$Hl$Ht$H|$ AVH L3 HHu'HL Hs Gm =   l R     In3I+.HHtgff     I HHtqHGH9G ~HHOHHHHOHH u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^Cl R  
7l R  Hx
 Hr sl =   H/u
HGHP0HtH+u
HSHR0DGl H
tS k O3r@SUVWAUAVAWH 3H\$`H\$hH\$p LLxhLppHhxMtIMtIHtHE iQ   H	 Hq k   Fk >Q  H IMPL I;tUH  I@      t
I
Y*HA9   }      @t	3D	I    D+k H
N j MLL$pILD$hHT$`Vyj   j XQ  [Hq E3H
t HHulj dQ  'E33HEuH+u
HCHP0Cj hQ  j   Hr H\$`Ht$hH|$pHp LMII3YHtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0Dj H
P i LH A_A^A]_^][MtI/u
IGIP0MtI.u
IFIP0HtHm u
HEHP0H A_A^A]_^][@SH H+  HH HIhH)uHAP0H
  HCh3H [@SH H HH HIhH)uHAP0H HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH H HH HI`H)uHAP0H HC`3H [@SH H HH HI`H)uHAP0H HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH H HH HIXH)uHAP0H HCX3H [@SH Hk HH HIXH)uHAP0HM HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH Hk HH HIPH)uHAP0HM HCP3H [@SH H+ HH HIPH)uHAP0H
 HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH H+ HH HIHH)uHAP0H
 HCH3H [@SH H HH HIHH)uHAP0H HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH H HH HI@H)uHAP0H HC@3H [@SH H HH HI@H)uHAP0H HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H HH HI8H)uHAP0H HC83H [@SH Hk HH HI8H)uHAP0HM HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH Hk HH HI0H)uHAP0HM HC03H [@SH H+ HH HI0H)uHAP0H
 HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH H+ HH HI(H)uHAP0H
 HC(3H [@SH H HH HI(H)uHAP0H HC(3H [H\$WH LJHL;
 HtrH; tiH
c L8 MIHiD H	 H He ^   ^^ E  E  H
zD A  AH\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH H HH HI H)uHAP0H} HC 3H [@SH H[ HH HI H)uHAP0H= HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH H[ HH HIH)uHAP0H= HC3H [@SH H HH HIH)uHAP0H HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HAH\$UVWAVAWH`H! H3HD$PH=a LLHH
r` 33LG HHtH ' Ht3Z D    H}HHHuZ D    H 3H9Au%HYHtHyHHH)uHAP0   HGH;j uHIGHT$(HD$(DEHHH+H\$ Lt$0zHH   %Z D  
  H;y    HOQ=   uwIGLT$@HD$@DEHL+H\$8Lt$HHA t3HOE3IHHuY D     H  H+  HCHP0   Mh HHuH
 H
` `Y D  VHtHX3IGE3HH IGHDEIHLtxHHu~Y D  HG H_ RY l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0DY H
)> X ;3#H.u
HVHR0H/u
HWHR0HHL$PH3*H$   H`A_A^_^]H\$WH0L
 E3H;- HHRHA3I;At   KMuH
_ HU H	 +HBL. H
 HU MIHD$ H	: 3u/H
 H
^^ X k  W qD  3H\$@H0_HHH\$@H0_PHUATAUAVAWHhH   HEHXHpHx HF H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI薕HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUϐLEHUL+I;33 HHu'H H%] V h  qV 3D  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HMs% HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pU =D  
~U ;D  H U h  H\ H.u
HFHP0HtH/u
HGHP03DU 2U H
3: ^8LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<to HAH;r_ H+HsO H'vB HqHE'   H}E MtzIIAM+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3cL$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H6 H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI6HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU迌LEHUL+I+3# HHu'H HY R c  aR C  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMHy HD$(HMc! HHt[HNH9N ~H HFH<HAHFHH  u H/u
HGHP0I;ܿ    >pzQ C  
nQ C  H Q c  HW H.u
HFHP0HtH/u
HGHP03D|Q "Q H
5 N4LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t_ HAH;rO H+Hs? H'v2 HaHE'   H}E MtzII1M+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3SL$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHI脅HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`׆HL$hH+L$XHHHLI?LHT$XOHT$(HL$@HL$@&Hu;H HU N _  gN C  C  A_  H
}2 1HH|$@Ht2HT$HH<HL$PH+HHHLI?LHH|$(Ht1HT$0H HL$8H+HHHLI?LH|HL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHIHL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`'HL$hH+L$XHHHLI?LHT$XHT$(HL$@`HL$@vHu;H
 HkS M Z  L 7C  7C  AZ  H
M0 /HH|$@Ht2HT$HH茄HL$PH+HHHLI?LHH|$(Ht1HT$0HPHL$8H+HHHLI?LHHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx Hƚ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIFHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUOLEHUL+I3 HHu'HD HQ OK T  J B  -  IM;<       HEH;tIE3HHMTH IE3HUHM<HE   H}E IE3HUHMH	 HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p
J B  
I B  H/ AJ T  HP H.u
HFHP0HtH/u
HGHP03DJ I H
, ,LHH.uHFHP0HEHrPHHMH=   r<tY HAH;rI H+Hs9 H'v, H[HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIM+IHL;v} II   r=Atc IFI;rS L+IsC I'v6 LIbIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI}HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU?LEHUL+I3 HHu'H4 HM ?G O  F mB  -  IM;<       HEH;tIE3HHMDH IE3HUHM,HE   H}E IE3HUHMH HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pE wB  
E uB  H 1F O  HvL H.u
HFHP0HtH/u
HGHP03DE E H
c( (LHH.uHFHP0HEHrPHHMH=   r<tI HAH;r9 H+Hs) H'v HKHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzII~M+IHL;vm II   r=AtS IFI;rC L+Is3 I'v& LIRIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIVzHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU/}LEHUL+I3 HHu'H$ HI /C J  B B  -  IM;<       HEH;tIE3HHM4H IE3HUHMHE   H}E IE3HUHMH HD$(HM HHt[HNH9N ~H HFH<HAHFHHp u H/u
HGHP0I;ܿ    >pA B  
A B  H !B J  HfH H.u
HFHP0HtH/u
HGHP03DA A H
# $LHH.uHFHP0HEHrPHHMH=   r<t9 HAH;r) H+Hs H'v H;HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIzM+IHL;v] II   r=AtC IFI;r3 L+Is# I'v LIBIHM/H3L$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHH   HEH$   HE3ELeWELeLeXAAELe3 LHu? C  N? jA  c  HFH;. tLH;} tCIH HHu? pA    H@L   MuU> rA    HMMMu8H H9FuL;v  HFJL;v  J\HIHAHH   HMXH]XHt
H)uHQR0HCL   HF HMtAq HH   E3HD H]HHtgH+u
HSHR0IIOI9O ~HIGH<HAIGHIM uH/ HGHP0= A  |= A  p= A  aN H   H
 LI;   HH    }      @t3H7IH u}S= A  IH = C  HC I/u
IGIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Lu  : H.u
HFHP0MIHMsHMH;t$HH]HHHMHHHML L`L`H]HMHtHUvLEHUL+I Ht$H HB < D  7< A  aHUHMPHUHMåHHM@HIȉMPW HuAD< F  ; A  H HxB H]D!< ; H
x LH]MtI.u
IFIP0HMXHtH)uHAP0HHttHUHuHEH+HH;vE HH=   r<t- HCH;r H+Hs
 H'v  HH,H]HtsHUHuHEH+HH;v HH=   r<t HCH;r H+Hs H'v HHIH$   HĀ   A_A^A]A\_^]H\$Hl$Ht$H|$ ATAVAWH`HB LHIHE333EFAHHu'H5 H@ @: :  9 f@    3H; @3H; 3H; uHy y9 :  9 h@    H+u
HCHP0  H? H L5? HA IIFL   MtAT HHu'He H? p9 =  9 }@    H. LgI9$  HoH  H_HHE HHH)uHAP0HCLcH; uFIG0HT$ A   HD$(HHl$ XHH   8 =  {8 @    H;    HKQ=      IG0HD$8Hl$0HA t3HKE3HT$0EAHHug8 =  	8 @  T  Hm u
HEHP03H/u
I$HP0H
< H:UHH   8 =  37 @        HHu'H
 H
*> 7 =  v7 @    HhE3IG0HH3H IG0HF VHHu7 =  27 @  }  H.2HFHP0#IW0HpTHHF7 =  6 @  3  H+u
HCHP0E33HAH/u
HGHP0H 3HF= 6 =  6 @     H@ A   IOH=HHu'H H= 6 >  M6 @    H؅y6 >  &6 @  q  H/u
HGHP0   IO(L I;uEH
 L H H	C H Hm< 6 >  5 @  w  H> JHHu'H H2< 5 >  ~5 @  <  3H;
` H(uH@P0M  Ha= H L5W= H= IIFL   MtA: HHu'HK H; V5 @  4 @    H LcI9$  HsH  H{HHHHH)uHAP0HGLgH; u8IG0HT$@A   HD$HHHt$@THHuwp4 @    H;    HOQ=      IG0HD$XHt$PHA t3HOE3HT$PEAHHu4 A  +  H.u
HFHP03H+u
I$HP0H
8 H:QHH%  4 @  33 A  H HB: HtH/u
HGHP0H2  Hm '  HEHP0     G HHuM3 	A  sHpE3IG0HH3H IG0HE RHHu3 A  <Hm HEHP0	IW0HVPHH2 @  "3 @  H H`9 H*H+ HCHH/u
HGHP0E33Hl=H+u
HCHP0H H9 2 @  R2 A  HtH.u
HFHP0D2 H
w )2 \MtI.u
IVIR03
H H L\$`I[ Ik(Is0I{8IA_A^A\HUATAUAVAWHhH   HEHXHpHx H H3HE/HHMWEE3LeELeEAAELeELeHE'   LeDe3 LHu'Hh H7 s1 3  1 ?    Ls8IFH; t`H;@ tWHI LHu+1 3  0 ?  Z  H@L   Mu]1 3  0 ?  1  IIܐMu8H| I9FuI;^   IFH4I;^   ItHHIAHH   ILHt
H)uHQR0HFL   H_8 HMtA$ HH   E3H8 HVOHH   H.u
HVHR03IOI9O ~HIGH<HAIGHI u$H/HGHP0E3A   / 3  i/ ?  E3  / 3  M/ ?  E3  / 3  1/ ?  E3   HtfH
 LI;tQHH    }      @t3HIH u$/ 3  . ?  E3M   E3I.u
IFIP0ML}IHMJHMH;t$HH]HHHMHHHML L`L`H]HMHtHUghLEHUL+I Ht'Ha H4 l. 4  . @     HUHR@HM`HMH;t$H8H}HHHMHHHML L`L`H}HMHt5HUeHMH+MH*HHLI?LHU1# Ht'H H4 - 4  \- @  R  LEHUHM.B3 LHu'Hg H3 r- 5  - @    H]H;]  HEH;tIE3HHM}H HMH}'HCMHU HH   ILHt
H)uHQR0HGL   H7 HMtA LH   E3H1 HKHHtwI.u
IFIP0MIOI9O ~HIGH<HAIGHIt uH/u
HGHP0H;]  C, 5  + @  u-, 5  + @  _+ @  FH HS2 + 2   + sS  sS  A2   H
 M{+ @  + 5  IH H 2 I/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0HtH/u
HGHP0LuH]H}DR+ * H
y $MLuH]H}MtI.u
IFIP0MtIm uIEIP0HE'HrPHHMH=   r<t{ HAH;rk H+Hs[ H'vN H}HE'   LeE H   HUH8bHMH+H*HHHH?HH
H;v HRHH=   r=@t̽ HGH;r H+Hs H'v HHHt~HUHcHEH+HHH;va HH=   r<tI HCH;r9 H+Hs) H'v HHHH]HtHUH"cLEL+IHIHM/H3L$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`Hq0 HAL   MtAV Hu;Hj H. u( &  ( H?  H?  H
 A&  83H({HAPH HAPHAPH HAPH\$WH0HIXE33BHHu?H H
 A   H- >  D' K' ~
3H\$@H0_H HH/ H9Cu%@ HHu\H> A   >  H- DA' & H+uHCHP0D$' & H
[ 	3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHl$H   HEH$   LWEE3L}L}L}L}L}HEL}L}HEAEL}wH=0 LGHH
a+  HHtH x HtIHHHHu&   % =    HCL   H( HMtA HHu%   d% =    H+u
HCHP0HFL   H. HMtAB HHu'HS H+ ^%    % =  p  H.u
HFHP0ILcH I9$z  HsHm  H{HHHHH)uHAP0LgI$H; u;HuLmA   HUHDHHu{$   b$ =    H; uqHOQ=   u^HuLmHA IuHOE3EAHUHHu^$    $ =  M  H.u
HFHP0I       LHu'H
 H
b* $   # =  	  HpIIE Lh E3IHBHHu#   p# >    I.u8IFIP0,IH@HHu#   2# =    H+u
I$HP0HGHZ H;   H;    H HHu" ">     H/u
HGHP0HFH   MHHMHtTA   HLHtAHH&5y"   v" *>    L)&u
HFHP0I   H.u
HFHP0I*5uI6"   "" 2>  o  HOHtf~A   H H
 H	\ 
Hx5! 
>  H M"   Hc( H/.  HGH  H;u
Lw H_H_LsHHIH/u
HGHP0H]LuHHMQ HHEH;tJHUHRHMHMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHMHEH@HEH HEH@L}H}HIHM' HHEH;tJHUHRHM
HMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUHMj   DBoHMLMLEHUHMgHI_HHMsHUHtLEL+IH
s* ~9LHu'H/ H& :     ]>  L  H@L   H]& IMtAʶ HHu'H۽ H<&     _>    I.u
IFIP0HM2LHuX b>    ILcHm I9$b  HsHU  H{HHHHH)uHAP0LgI$H; uJHuLuA   HUH>?HHu v>    H.  HFHP0  H; uOHOQ=   u<HuLuHA IuHOE3EAHUHHuc >        ; LHEwHu'H
x H
$    % >     HpILp ME3IHl=HHu >  8Im    IEI   IH6;HH    o>     H߻ H@$ HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0HMwHt
H)uHAP0D > H
? j #I.u
IFIP0H+u
I$HP0LHMHt
H)uHAP0HMHtH)uHAP0LEMM HUwHMѾ   DBoHMLEMM HUwHM藿   DBoHMHUHtLEL+I[IH$   Hİ   A_A^A]A\_^]HSVWATAUAVAWH   H@HLW@3HPD$hHt$xD$PHt$`DDH`HXH; tJHtEH(HD$0H$   u]Hڹ H;"     2=  (  H$   H$   H H$   H$   L% L$   HH$   蔥HL$hH;t%HHL$hHHHL$pHHHL$xH0HpHpH$   HtL$   L+IԾ Ht'H Hs!     ==  `  LD$hH$   IM<WHL$PH;t%HHL$PHHHL$XHHHL$`H0HpHpH$   HtL$   L+I<HT$PH$   iL-$ MEIH
 6 HHtH  HtHI=HHu'H* H  5    N=  $  HCL   HX  HMtAŰ LHu'Hַ H7      P=    H+u
HCHP0H$   )HHu'H H    7 S=    HMnHL I9E   I~H  MnHIE IMH)uHAP0IEH$h  H H;ٱ u[H|$@H\$HA   HT$@I9LHu'H HD     g=    H/_  P  H;ձ ujIMQ=   uWH|$@H\$HHA HuIME3EAHT$@LHuHa H l    p=  [      LHu'H
' H
 2    w=  !  HxHHX E3II7LHu'Hߵ H@     }=     I/uoIGIcHI4LHu'H H    C `=     H+u.HCHP0"HGHP0H+u
HCHP0L$h  I.u
IE IP0H$    Y  H$   H
 H;HDH$   H$   w (  3DDHtH+u
HCHP0MtI.u
IFIP0HtH/u
HGHP0MtI/u
IGIP0H= ŭ HLxPL`XLh`HpPHpXHp`H$    t%H$   H;HDH$   H$    HKPLsXH{`L{PLcXLk`Ht
H)uHAP0MtI.u
IFIP0HtH/u
HGHP0D  H
 LHT$PHtLD$`L+I_HT$hHtLD$xL+ICH$   HtL$   L+I!IH   A_A^A]A\_^[H\$WH0LRHH HL;u   ^HuH
5 H H	 >It   -H
 L IBLJH HD$ H	 3u/H
 H
!    m =  3H\$@H0_HHH\$@H0_HL$USVWATAUAVAWHl$H   HAE3H LLmALmoAL   LmLmwMtA HHu'H Hg     >;    HCMH;ȩ    LsM   L{HIIIH)uHAP0II0LHu   I K;    I.u
IFIP0MH+u
HCHP0I/u
IGIP0ID$IH L   MtsAtH; uE33H331H;2 uHC@t3H41H E3H2LHk    N;  8   Hu'H H
    V [;  )  H
 HE+HHu'Hj H u 	   g;    H@HH L   MtA LHu/ 	   i;    H+u
HCHP03L HHu'Hݯ H>  	   l;  ]  IL$(H;
i u0H
8 H H	  	  L p;    HH C*HHu} 	   r;    H@H; t`H;N tWHI HHu9 	   x;    H@L   Mu% 	   z;  b  HHMMH/u
HGHP0Mu>Hu H9FuL;~   HFJ<HI)L;~   J|HIHAHHW  HMwH}wHt
H)uHAP0H{ HH H9Gu)ޤ HH   HKH9K ~H HCH<HAHC/HH  	   ;  X  IH.u
HFHP0H MfII9$B  IvH5  M~IHMIH)uHAP0IGMgH;?   A   HuHUH]Iw/LHu{a 	   ;  
  H 	   ;  
   H6Hǣ HHLt  	   ;  Q
  H.u
HFHP0IH+u
HCHP0I.u
I$IP0H
 L}o'LHG  H~ H  
  + ;  (
  H; u]IOQ=   uJHuH]HAI uIOE3HUEALH=# 	  
 ;  u      HHu
 	  
 ;  I  HpE3HHX II,LHu'H H 
 	  Q
 ;  $  H/HGHHI*LHi
 	  
 ;    H@IH L   MtA HHu'H
 Hk 
 
   ;    I.u
IFIP032 LHu'Hê H$  
  p ;  X  HMgHI(H;
L u>H
 H H	 Ht H  
  ! ;  
  H %HHu'H9 H D 
   ;  
  H@H;Ơ t\H; tSHj HHu 
   ;  V
  H@L   Mu' 
  } ;  -
  HHMMIH+u
HCHP0Mu>H: H9FuL;f   HFJHI)L;f  J\HIHAHH   HMwH]wHt
H)uHAP0H@ HH
 H9Cu# HHtOINI9N ~H IFHHAIF3HI 
 
  q
 <  !	  H H 
 
  J
 <  	  ߡ Ht H+ HH   z H.u
HFHP0H+ LgII9$&  HwH  LHHIIH)uHAP0IGMgH;    A   HuHULuI)LHuNH§ H# 	 
  o	 +<  B  H H 	 
  H	 <    H.u
HFHP0II.u
IFIP0H/u
I$HP0H
q L}x"HHf  H% H 0	    Q<    H;& ukIOQ=   uXHuLuHAI uIOE3HUEALH=H H  
  ^ 4<  1     6 HHu'Hw H  
  $ ;<    HpE3Lp HIIMk'LHuE 
   A<    H+HCHIH)%LHH HG  
   $<  f  H@HH L   MtA HHu'H H
    ? S<  '  H/u
HGHP0HK LcII9$  H{H  L{HHIIH)uHAP0IGMgH;ٟ uFLuoHUA   LuIH}'LH      M g<  F  H;    IOQ=      LuoLuH}HAI uIOE3HUEALHu   M% o<    H/u
HGHP0IH+u
I$HP0I.IL}ouIFP0Hڝ D9(m  HM HH   H HT     <       x LHu   t u<  $  HxE3HEoIIIH IF $LHu   3 {<    I.u
IFIP0LuoLuoHIn"LHD   M a<    I Hu'H  Ha     <    H;t7H
 H	˛ HĢ H%    q <  Y  H
 HHu'H H
  
  6 <    H@HH L   MtA$ LHu <    H+u
HCHP0   r HHu'H Hd
  
   <    IMfH@IHML8HHCHHH I9$  I~H  M~IHMIH)uHAP0IGMgH;A    A   H}HUH]Iy#LHu <    H/u
HGHP0H+u
HCHP0I.u
I$IP0IMHMHt
H)uHAP0HMoHt
H)uHAP0HMHt
H)uHAP0MtIm u
IEIP0HEwHtH(u
HPHR0IHĸ   A_A^A]A\_^[]H; uSIOQ=   u@H}H]HAI uIOE3HUEALH <        ͘ HHu <  |HxE3HHX II !LHu$H HB  
   <  dH.HFHHILHeU <   
  H| H HtH+u
HCHP0MtI.u
IFIP0HtH/u
HGHP0HtH.u
HFHP0D6 H
   {HHPHHAVH   HE E3HXAHpAHxL`ELhELxEHAL$   Lt$hLt$XL   Lt$xL$   L$@  Lt$PMtA4 H$  HHu'H= H H     /9    HGH; L$H     HOH$H  H   HoHHHHE H)uHAP0H$H  HHHu'H H    _ <9     H$H  H)uHAP0L$H  H/u
HGHP0Hm Iu
HEHP03 HH   O    L9    H; uE33H.1H;- uHG@t3H/H E3HHHZHȜ H)    u ?9  6  H$0  HI(H;
M u0H
 H H	    0 P9    H, 'HHua    R9    H@H; toH;2 tfHHD$`~ H$H  Hu    X9  R  H@H   HL$pHu3    Z9  $  HLH$H  H\$`Lt$pH\$`HL$H  H/u
HGHP0HuHH, I9GuI;_  IGH<HHH\$`-I;_  I|HHH\$`IHH  H$   LH$   Ht
H)uHAP0H
v I.LH`  HHH H   IHt HH  I/u
IGIP0HÒ IH9 I9D$uU% LH  H
 HH  HHH H   HHt H$@  LH5  H.u
HFHP0H2 IH  I9D$u HH  Hɑ MeLt$PI9$  MELD$PMn  MmH$@  I HL$@  IE H(uH@P0LD$PIEMeH;= L$   uQL$   H$   A   H$   IeLH  HD$PH(u
HPHR0Lt$P   H;; uiIMQ=   uVL$   H$   HAI uIME3H$   EALH  HL$PH)uHAP0Lt$Py   M LH  HT$PE3HPIHp HLt$PILH]  I,$uID$IP0L$   'HIkLH  H.u
HFHP0H$@  H)uI$P0    H$@  HH  H
 E3LxHMLh LHo  H.u
HFHP0H LcL$@  I9$h  LCL$@  MS  HsHI HHH)uHAP0L$@  HFLfH; uTL$   H$   A   L$   HDHHH  H$@  H)uHAP0L$@     H; ueHNQ=   uRL$   L$   HAI uHNE3H$   EAHHu   U 9  	     - LH  H$@  E3Mo IHIGL$@  MxHH  I/u1IGI%IHRHH  Im u
IEIP0H+u
I$HP0HMIH9M ~HHEH<HAHEHH :  H/H\$`Ht$pL$H  #HGHP0II/u
IGIP0H$8  LH$   ɵG  HZ MH b    :  
  I    9    0    9  l      9  V     M 9  :      9       k 9       R 9       9 9    ~     9    e    9    L    9    3    9  o     M 9  S     M 9  7     M 9       h 9       O 9       I3 ~9    Ȍ HH HHtc H   I v9  x  t	HE   H$0  HH(H;
 uAH
 H H	c Hܒ MH:     #:    H }
HHu*H MH    H %:         H$H  HHu ':  I  IE3H
9 HLxHh aHHu /:  I  H+u
HCHP0HEH; tZH; tQHIT H$H  HHu 6:  I  H@L   Mu'p 8:  I  HE HH$H  MMHm u
HEHP0HNIH$   Mu>H H9FuL;f*  HJ,HE I)L;f  J,HE IHAHH  HEH H;   H; t~H` LHO  Hm u
HEHP0IGIIH   HH  IϽ   HH  IHp  I)/uHIGI<HMH  H;u
H] H}H}H_H?HHHm u
HEHP0HL$hLH|$hHt
H)uHAP0HL$XIH\$XH$0  Ht
H)uHAP0IGIH; tKH; tBIH@ HHH  H@L   Mu%   h :    IIMIMu>H; H9EuH;u   HEHHH)H;u   H\HHHAHH   HL$xH\$xHt
H)uHAP0LD$hI@HHpHtHAHt
HIHIHH  L$0  HHHy  H+u
HCHP0HT$xLHL$hIȈ 5  H/HGHP0I+܇ Ht H( HH4  w Hm u
HEHP0H$0  IH$H  H$   HD$XH MHp I   M }:  w  I/u
IGIP0MuHeH MH I   Mb :  #     I u:        0 :  ,  u    :  C_    :  -I    :  3    :  IH MHa IH$0  MHD$XMY~H
( H9 A   H	 
HxVt `:     MMIMH H HtHm u
HEHP0HL  H/B  HGHP03   Ht H HH   M H.u
HFHP0L$   IML$   L$   H$   H$  H$  H$  MtI/u
IGIP0HL$hL$   Ht
H)uHAP0HL$XHt
H)uHAP0HL$xHt
H)uHAP0H$   HtH(u
HPHR0IH   A^	 T:  S   MIMMH$ H H$H  Ht
H)uHAP0MtI/u
IGIP0HtH+u
HCHP0MtIm u
IEIP0HtH.u
HFHP0H$@  Ht
H)uHAP0HL$PHt
H)uHAP0MtI,$uID$IP0D{ H
8  ML$   9H\$Hl$VWAVH@H IHzLH\$pHM   HtH   HZH\$pHs HHu-H  H HLB HtHHD$pHH   H~ HHD$(LL$pH H|$ 8y
8     H\$p   H   H   H	 H|$0HH+ H?L
 HL! HHDHHD$(H HL$ LIH
 H H	 9  Hވ H?     A  H
 3HZHIH\$`Hl$hH@A^_^HHPHHATH   H E3HXAHpAHxLhELpEHALd$XLd$hLd$pL   L$   L$   MtA H$   HL$   Hu'H HJ     7    HGIH;    HoH   LwHHE IIH)uHAP0HILHu   + 7  
  Hm u
HEHP0IH/u
HGHP0I.Iu
IFIP03~ LH   H Hm     7  	  H; uE33H1H; uHG@t3HHf E3HLHM   K 7  :	  H$   HI(H;
# u&H
 H# H	~  7    H HHu 7  \  H@IH;| Lt$PtMH;~ tDHh~ HHu 7    H@H   HL$`Hu 7    HHMLd$`H/u
HGHP0HD$`Hu>HF| H9EuL;u\  HEJ<HI(L;uB  J|HIHHH   HL$hH|$hHt
H)uHAP0HK} HHI H9Gu{ HH   H} HH! H9Gu~{ HHtgH/u
HGHP0IOII9O ~HIGHHAIGHI{ uH+HCH4 "8     % 8      8     } HtHz HH|tWJ{ Hm u
HEHP0H$   ML|$X\yeH HR     18  %   8  IH H    I/l  IGIP0]  tIIx  3z HHu'Ho H z    68    H$   HH(H;
{ uAH
| H H	{ H IHz $    :8    H HHu'Hނ H?     <8       c{ HHu'H H    Q >8  c  IE3H
o HLxHX HHu F8    H/u
HGHP0HCH;x teH;<z t\Hz HHu'H Hs     M8    H@L   Lt$`Mu$ O8    HHLd$PMLd$`HH+uHCHP0D  MuHHLx H9GuH;wa  HGHHHHt$P.H;wB  H\HHHt$PHAHH  HCHFy H;+  H;w   Hy HH  H+u
HSHR0HNIML   HAH$   MH  HA   ALHm  HAH
H  L)>u
HFHP0Lt$`HL$pL$   L|$pHt
H)uHAP0H$   L$   L$   Ht
H)uHAP0L$   IMmHHR  HMH9M ~eH HEHHAHEdHKH_  H;u
Lk HCHCLhH H$   H IE H+3HCHP0$HHv    H+tL$   Ht$PL$   HCHP0L$   Ht$PL$    8    H.u
HFHP0IuI 8     8    H IH` H$   H$       8    H~ IH& H$   H$      b 8  _  ~,H
v H A   H	v 4 w8    Hx w8     w Ht Ht HH聹   Ku H/u
HGHP0Lt$XLL$   L$   H$   H$   H$   H$   MtI.u
IFIP0HL$hL$   Ht
H)uHAP0HL$pHt
H)uHAP0H$   HtH(u
HPHR0IH   A\$ k8  IL$   M`   H=} H HtH/u
HGHP0HtHm u
HEHP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtH.u
HFHP0Lt$XD H
 ` H\$Hl$VWAVH@H_v IHzLH\$pHM   HtH   HZH\$pHt HHu-H  H+ HLBr HtHHD$pHH   Hn HHD$(LL$pH H|$ y
7     H\$p   H   H   HYz H|$0HH{ H?L
 HL! HHDHHD$(Hb HL$ LIH
t H H	js 7  H.{ H  3   A  H
 3HZHIrH\$`Hl$hH@A^_^ATAWH(HAE3H: EH\$@Hl$HHL   MtAss Ht$PHH|$XLt$ Hu'Huz H    " 6    HCIH;7r    H{H   HsHHHHH)uHAP0HH<HHu'Hy H^     7  c  H/u
HGHP0IH+u
HCHP0H.Iu
HFHP03p HH   Hy H    9 7    H;-t uE33Hv1H;ut uHC@t3HwH E3HSHHMHy Hq     7  v  HM(H;
q u&H
lr H= H	Lq  7    H HHug 7    H@H;Go tLH;p tCHHp HHu-  7    H@L   Mu "7    HHIMH+uHCHP0D  Mu>Hn H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0Ho HH H9Cug7n HHtEHNH9N ~H HFHHAHF0HHyn  H7       F7     p HtHm HHftf4n H/u
HGHP0HLH.u
HFHP0Lt$ H|$XHt$PHl$HH\$@MtI/u
IWIR0IH(A_A\j >7  Hv H    H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0De H
  7LKHL@HPHHSVWATAUAVAWH   H@HWhE3LxPL`AED$pLHD$XL|$hEL% MD$IH
 [l HHtH n HtII>HHu'HOu H Z    /6    HCL   H} HMtAm HHu'Ht H\     16  h  H+u
HCHP0IH$X  LfHl I9$  H^H$X  H  H~HHHHH)uHAP0LgI$H;2o uaH$   H$H  H$   A   H$   HZHH   H't H 2    E6    H;(o    HOQ=      H$   H$H  H$   HA IuHOE3EAH$   HHu'Hs H    H M6    H+u
HCHP0IH$X         l LHu'H
As H
 L    S6    HXIH$X  H$H  H IF E3IH%HHu'Hr HG     Y6  h  I.uFIFIP0:HHHHu'Hr H    G ?6    H.u
I$HP0HGL   H HMtA%k HHu'H6r H A    _6    H/u
HGHP0HHL$ ^HHL$pCHT$ HtLD$0L+Iw3k Ht*Hq H     l b6  M)  H.u
HFHP0IHT$pH$   g?H$P  ʑ@@u5j Ht*HLq H W    m6  M  H$   H$   T@DLHT$ H$@  HI
HHL$XBHT$ HtLD$0L+IvHT$XH$   >H
 HHu*Hp H    N ~6  M  H@L   H HMtA9i LHu'HJp H U    6    H/u
HGHP0H$   dHHu'Ho H_ 	    6  k  IMfHg I9$  I^H  MfHI$IMH)uHAP0ID$H$X  HH;
Lj u[H\$8H|$@A   HT$8IHHu'HVo H a    6    H+\  M  H;
Hj ulIL$Q=   uXH\$ H|$(HA IuIL$E3EAHT$ HHuHn H3     6  *     Wg LHu'H
n H
    E 6     HXHx E3IIHHu'HSn H ^     6     Im ulIEI`HIHHHu$H	n Hj     6  dH/u.HGHP0"HCHP0H/u
HGHP0L$X  I.   I$IP0   E3AH$X  AEMHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0MtIm u
IEIP0D3  H
ڨ IHT$XHtLD$hL+IrHT$pHtL$   L+IxrH$   HtL$   L+IVrH$   HtL$   L+I4rHH   A_A^A]A\_^[H\$Hl$Ht$WATAUAVAWHPH5f E3Ld$@MH\$HHLAM   LzIMt"HtH   HZ H\$HHzH|$@I|d HIMtHt*UH ILBb HD$@HH   HH,  Hi ILBdb HtHHD$HHH   HĤ IHD$(LL$@Ht L|$ y
5     H\$HH|$@   HBH   H   HNHi HHL$0Hp HLL
 AHD$(IH HLd$ H
`d LA LMHf H	b 6  Hj H
 d    A  H
 耯3HZ HzLHIVL\$PI[0Ik8Is@IA_A^A]A\_HLH L@HHVWATAUAVH   H@HXLW@H@    33D$@Ht$PL5 MFIH
 ` HHtH .c Ht3IHHu'Hi H    S l5    HCL   H HMtAAb HHu'HRi H ]    n5  g  H+u
HCHP03H\$ LgH a I9$  H_H\$ H  LwHIHIH)uHAP0MfI$H;c uYH$   L$   A   H$   ILH   Hh H    : 5    H;c    INQ=   u}H$   L$   HA t3INE3EAH$   LHu'Hh Hm     5  !  H+u
HCHP03H\$       u` HHu'H
g H
    c 5    HX3H\$ IE Lh E3HILHu'Hfg H q    5    H.uFHFHP0:IHYLHu'Hg H{ %    |5  /  H/u
I$HP0IFL   H  IMtA_ HHu)Hf H    c 5  3  I.u
IFIP0HD$0    HHL$pRHHL$@q8HT$pHtL$   L+Ik_ Ht)H1f H <    5  3D  H/u
HGHP03HT$@HL$X3H$   AAAu47_ Ht)He H$    p 5  3   H$   @@u4^ Ht)Hve H    # 5  3   HT$XHL$p4DEHH$   HI ] HH   He Hp     5  3%Lt$0H\$ IIMtI.u
IFIP0HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D G H
x s3HT$@HtLD$PL+IjHT$XHtLD$hL+IiHH$   Hİ   A^A]A\_^H\$ UVWATAUAVAWH`H H3HD$XH-] E3H5[ MLt$@HHl$HLHt$PM4  LbIMt1Ht"HtH4  Hr(Ht$PHj Hl$HLrLt$@I
\ HIMtHt3HtZ   H: ILBZ HD$@LH   HHw  H ILBY HtHHD$HHHJ  H ILBY HtHHD$PHH  H IHD$(LL$@H#l Ld$ iy
75     Ht$PHl$HLt$@   HBH   H   H   HSHa HHT$0A   H
8h HLL
Ѿ HL$(   H
[ H;AML" HHD$ H	H MMLd &Z J5  Ha HK     A  H
f 3Hr(Hj LrLLII`HL$XH3gH$   H`A_A^A]A\_^]@SUVWATAVAWHpH" H3HD$`H- MLLH
s H33LEX HHtH 'Z Ht3 4  p  HHHu 4  Q  HGHH L   MtAY HHus 4    H/u
HGHP0HCHH0 L   MtAQY HHu'Hb` H m    4    H+u
HCHP0HX 33H9Gu+H_Ht"HGHHHH H)uHAP0   HGH;Z uIHT$(HDEH+H\$ HLt$(L|$0Ld$8HH   m 4    H;Z    HOQ=   uxLT$HHDEL+H\$@Lt$HL|$PLd$XHA t3HOE3IHHu 4     H  H+
  HCHP0   MW HHuH
^ H
Q  4  ZHtHX3IE3HHLtEIL|EI$LdHHu~Y 4  H^ H    HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0DO H
  !3#H.u
HVHR0H/u
HWHR0HHL$`H3mcHpA_A^A\_^][H\$Hl$Ht$WAVAWHPHiV MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@IU HHHtHt/ZHR  H+ ILBT HtHHD$@HH%  H ILBS HtHHD$HHH   H9 IHD$(LL$@He Hl$ y
~4     H|$HH\$@   H   H   H   H
 Hl$0HL
 H?LP HH HHLIH
?b HL$(H
U HD$ H	aT 4  H%\ H  *   A  H
 3Hz HZLHIrH\$pHl$xH$   HPA_A^_H\$Hl$Ht$H|$ ATAVAWH H5S MLHH
 HM3LFQR HHtH 'T Ht3 $4    H(HHu $4    HGHH L   MtAS HHu¼ &4  D  H/u
HGHP0HCHH L   MtAS HHu'HZ H    ^ )4  
  H+u
HCHP0kQ HHu1 ,4     H- LHIQ y .4     H' MH#Q y /4  jH MH Q y» 04  GH MHP y 14  $H LHHHuiy 24  HY H    HtH/u
HGHP0HtH+u
HSHR0D H
Q # V3#H/u
HWHR0H+u
HSHR0HH\$@Hl$HHt$PH|$XH A_A^A\@SUVWATAVAWH`H	 H3HD$XH=Q MH-Y LH5 LrH|$@IHl$HHt$PM2  Mt1Ht"HtH>  Hr(Ht$PHj Hl$HHzH|$@IQ HIMtHt8Ht_   H  H- ILBO HtHHD$@HHt  H ILBN HtHHD$HHHG  H۸ ILBN HtHHD$PHH  Hގ IHD$(LL$@H` Lt$ Xy
3     Ht$PHl$HH|$@   M   H   H   H   HV Lt$0IH-] H?L
Ƴ HL HHHDMHD$(H HL$ LIH
P H H	O 4  HV H=   y  Ay  H
8 賛3Hr(Hj HzLLHIHL$XH3\H`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   Hc MtAO H|$PHHu0 v  ҷ 3  k  L HHu 3        N HHuH
U H
/  3  lILLxHH L y[ 3  4H+u
HCHP0H2 LHHHuf% 3  HVU H a v  H.u
HFHP0HtH/u
HGHP0H   H+   HCHP0uH.u
HFHP0H/u
HGHP0HCHHHpHtHAHt
IHIHHu= w  b 3  HT H D H
~ @ sLL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAH L   MtAL Ht$0HH|$8Hu'HS H@  s   13  '  HC3H;K u{H{HtrHsHHHHH)uHAP0HHHHu5 >3     H/u
HGHP0H+u
HSHR0HH|$8Ht$0H [H;M uE33H?1H;>N uHC@t3H@H E3HHHu A3  HR H4 ޴ s  HtH+u
HCHP0HtH/u
HWHR0D H
* L H|$83Ht$0H [;HAVAWHXHXE3HhEH- HpHHxAL`ALELhLH
A H HHtH XK HtIHHHu o   2    HCHHo L   MtAxJ HHu o  D 2  Z  H+u
HCHP0HGHHY L   MtA"J HHu'H3Q H > o   2    H/u
HGHP0HH LcII9$  H{H  HkHHHHE H)uHAP0HELeH;yK uBA   H|$ HT$ Ll$(HHH    o  : 2  P  H;K    HMQ=      H|$0Ll$8HAI uHME3HT$0EAHHu+ o  ͱ 2    H/u
HGHP0IH+u
I$HP0H
 LHH   HO IH ñ p  e 2       =H HHu'H
~O H
߷  o  + 2  O  HxE3IE HHLh IqHHuK o   2    H.)HFHP0IH,HH o   2     H/oy 2  I   H+u
HCHP0   HEHH L   MtAZG HHu'HkN IHɶ s p   2  QH E3HiHHu| 2  9 p  HN Hw HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D H
  跒H+u
HCHP0HHE LLl$@Ld$HH|$PH$   Hl$xH\$pMtI/u
IWIR0IHXA_A^H\$Hl$Ht$WAVAWH@H-ٹ LH
O H33LEC HHtH '[F Ht3 /2    HHHu /2  d  HGHHp L   MtAyE HHuO 12  (  H/u
HGHP0HCHHd L   MtA-E HHu'H>L H I l   42    H+u
HCHP0HC Lw3I9}  H_Hp  HoHHHHE H)uHAP0HELuH;F u4A   H\$ HT$ L|$(HHHuoU H2  .  H;F    HMQ=   u{H\$0L|$8HA t3HME3HT$0EAHHu P2     H+u
HCHP0H/u	IHR0HH\$`Hl$hHt$pH@A_A^_ù   C HHuH
J H
4  V2  tHXE3IHHLx 3HHu[ \2  7H.oHFH`IHHHL" B2  HSJ H ^ l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0D H
  3LUATIH(  Hm H3H  E3IsI{AMkEMsELEHT$XM{MLLMH`  HUHL$`I HHAHǱ LeLeL   LeLd$HLd$PLeLd$xLd$pLeLeLeLeLeLe LeLeLd$8Ld$@MtAA H$   HHu'HH H, ֪ 1  x ?+  *L  HGIH;@    H_H   LwHHIIH)uHAP0HILHu'HSH H ^ 1    L+  'K  H+u
HCHP0IH/u
HGHP0I.u
IFIP0H
A H9M  L;Ar  H
 LH   HG H  ʩ 3  l p+  J  H;`B uE33H1H;B uHG@t3HH E3HLH*HCG H N 1   O+  J  H@IH L   MtA? HHu 3   r+  I  I.u
IFIP0Hf E3HLHu'HF H
  3  Y u+  I  H/u
HGHP0I.u
IFIP0H
? H9M  L;=\> A   H
 zLHu'H+F H 6 5  ا +  I  H@IHu L   MtA> HHu 5   +  H  I.u
IFIP0Hv E3HLHu'HE H  5  A +  hH  H/u
HGHP0I.u
IFIP0H
> L|$XL;   Lt$`IF(H;u>H
> H{x H	= HE Ht  8   +  G  H H贿Hu'HD H9  8   +  G  I/IHD$X   IGP0   H
; οLHu'HD H  9  , +  hG  II#; u^ 9  I +  G  I.u
IFIP0tY   q; HHu'HD Hc 
 :   +  F  IIH@HT$XL8I/uIGP0Lt$`H
o HHu'HC H  ;  P ,  F  H@HH5 L   MtA>< HHu'HOC H Z ;   ,  #F  H/u
HGHP0HCHH L   MtA; HHu'HB HL  ;   	,  E  H+u
HCHP0IN(IH;
e; u>H
4< H}v H	; HB H  ;  : ,  aE  H6 1HHu'HRB H ] ;   ,  &E  IN(H;
: u>H
; Hv H	: HB Hh  ;   ,  D  Hp 諼LHu'H
A H
- ף ;  y ,  D  H9 MELd$8H9Gu1LL|$8Mt#HGHIHH H)uHAP0A   HGH; <    HD$XH   H   EFAHHH+L  H(  L0  4LHu'ʢ ',  H@ H\  ;  C  MtI/u
IGIP0H+Ld$8u
HCHP0Im T  IEIE  H;; u|HOQ=   uiHD$XL@  H@  EFAHL+L8  HH  LP  HAI uHOE3ILHI 1,  AN8 HD$@Hu'H
@ H
e  ;   9,  B  Mt	LxLd$8L|$@E3HL$XIAHILAFI\HAFIMlMLHu'H? H  ;  9 G,  `B  I/u
IGIP0H/u
HGHP0HL$XIMLt$XH)uHAP0H]H;7 uL6 Hu-H? MHn L =   a,  (B  H+HHEuHCP0H\$`HK(H;
~7 uDH
M8 Hr H	-7 H> MH L ?  M x,  A  HI DLHu-He> MHæ Lj ?   z,  }A  HK(H;
6 u8H
7 H|r H	6 - ?  I̟ ~,  Ld$@@  H 辸HHu! ?  I ,  Ld$@@  HI!6 HD$@LHu ?  I] ,  ^@  I.u
IFIP0H/u
HGHP0H
! L}MLd$@蘸HHu*HI= LH Q @   ,  d@  H@HHء L   MtA5 LHu-H< MHP I @   ,  ?  H/u
HGHP0IFIH L   MtAw5 HHu @  I@ ,  A?  I.u
IFIP0HL4 MAH9Gu+LwMt"HGHIHH H)uHAP0   HGH;6 ubHEH   H   DCHHH+L   L   HD$@LH    @  I ,  >  H;6    HOQ=      HEL   H   DCHL+L   L   HAI uHOE3IHD$@LHuR @  I ,  =  MtI.u
IFIP0M   K3 LHu @  I ,  =  MtLpMHME3HT$XHILCHHITIһHD$@LHu @  IF ,  J=  Im u
IEIP0H/u
HGHP0I/u
IGIP0H
 Ld$@wHHuA B  I ,  <  H@HHŞ L   MtA2 LHu B  I ,  <  H/u
HGHP0IEIH L   MtAu2 HHu B  I> ,  B<  Im u
IEIP0H\$`MHK(H;
2 u3H
2 Hm H	1 F B  I ,  ;  H ܳLHu B  I ,  ;  HK(H;
1 u3H
d2 Hum H	D1 ֚ C  Iu ,  y;  H1 lHD$0LHu*H8 IH  C  2 ,  Y;  HK(H;
1 u3H
1 Hm H	0 S D  I ,  :  H& HHu# D  ř ,  :  H/ MELd$8H9Gu1LL|$8Mt#HGHIHH H)uHAP0A   HGH;l2   HD$XH  H  EFL  HL|$0AHH+L  L  H  tHD$@Hu -  MO B  9  HL$8Ht
H)uHAP0Im Ld$8u
IEIP0I/u
IGIP0H+u
HCHP0L|$@H/u
HGHP03L} . HD$@LH  H6 IH M G  O C-  9  H;1    HOQ=      HD$XL  H  EFL  L|$0AHL+L  L  H  HAI uHOE3IHD$@H -  M B  8  AN. HHu,H
5 Lt$0H
 Ǘ B  i #-  {8  Mt	LxLd$8HT$XANAE3LlMHD$0HDAFHH\AFHIHTHzHD$@LHu'H65 H A B   4-  
8  H.0HFHP0!H\$`HK(H;
- uDH
t. Hi H	T- H4 IH+ MҖ G  t G-  7  Hx kHHu-H4 IH M G  3 I-  7  HK(H;
- uGH
- Hki H	, H;4 IH M@ G  Iߕ M-  7  H ֮HHu-H3 IHU M G   O-  6     v, HHu*H3 MH  G  a Q-  6  H
 E3HHxHp 誴HHu*Hk3 MHɛ s G   Y-  Q6  H+u
HCHP0HFH;)    H;0+    HI}+ HHu-H2 E3H\ E G   `-  6  H@H   H}Hu9H2 E3H E G  d b-  5  HH3H}H.u
HFHP0Hu>H') H9CuL;c  HCJ4HI(L;c  JtHIHHH  HFH,* H;  H;(   Hm* LH  H.u
HFHP0IEI3E3L   AHt$0HH_  ID~AHD$0HG  IAH  M)} u
IEIP0L|$@Lt$0HL$pH|$pHt
H)uHAP0HMIHEHtH)u
HAP0IHH) HH`  IOI9O ~\H IGH4HAIG[HNH`  H;u
Lv H~H~LwH?HIH.UHFHP0FHI'    H.H}HFHP0E3Am  Lt$0E3 G  ( -  ,3  Im u
IEIP0E3EuIӥLt$0@ G   -  2  H0 E3Hl  G   -  2  H/ E3HB E G   -  2  H/ E3H E G  ^ -  2  ~H
' H A   H	' 
HxH_/ E3H Ed G   -  B2  ( HtH% HHljtY:& E3H+u
HCHP0HML}MLd$@JOyTH. H@  I   -  1  H. E3H E G  _ ~-  1  "  H
 HHu'Hq. HҖ | J   -  1  H@HH L   MtA' HHu*H. MH{ % J  Ǐ -  1  H+u
HCHP0H% IH9F  H^H   H~HHHHH)uHAP0HHѬHD$@LHu*H- MH  J  7 -  s0  H+u
HCHP0IH.u
HFHP0Lt$XIL|$HIFH;#    H;2%    HIH}{% HD$@LHumH, MHU  K   -  /  H謫HD$@LHdH, MH  J  ^ -  /  H@H   HEHuCHv, MHԔ ~ K    -  \/  IIHEMLt$@ILeMM@ HuFH" I9GuI;  IGH4HHH},I;  ItHHH}IHH  HL$PLHt$PHt
H)uHAP03
# HH`  LEI@HHpHtHAHt
IIII蒧HH	  H@H;" tWH;b# tNHI# HD$0LH  H@H   H}Hu10 M  Iό 4.  -  HLH\$0MILeH+u
HCHP0Hu>H! I9FuM;~X  IFJHI(M;~>  K\HIIHH  HMH]Ht
H)uHAP0H
  I蠥HH&  H@HH L   MtA# LH  H/u
HGHP0IEIH L   MtA" HH  Im u
IEIP0H! MAMH9Gu/LoMt&HGHIE HH H)uHAP0   DHGH;I$ upHEDAH   H   HD$`L   H@(H   HHH+aHH?  M   Im    IEIP0M  H;0$    HWDBA=   uyHEL  H  DYHD$`L   H@(H  IHL+HBA uHOE3MIHH  MtIm u
IEIP0Mx! HD$8LH  MtLhMHEE3HL$`IH KDHA(H HA(HKD OHHw  HL$8H)uHAP0Ld$8H/u
HGHP0HNIH9N ~HHFHHAHFHH   H+Lt$0H}HCHP0  Ht HB HHbZ   I.u
IFIP0HMHHuHt
H)uHAP0H
e ImLH  H@IHۓ L   MtA HHP  I.u
IFIP0H L{MLd$0I9V  LsLt$0MD  LsHH|$0IHIH)uHAP0IFM~H;I! uGHEHUA   HE IH}聨HH\  H/uxHGHP0MLd$0   H;Y! ubINQ=   uOHEHE0H}(HAI uINE3HU(EAHH  H/u
HGHP0MLd$0v   r HH&  HD$0E3HGHHEILd$0H HG 迦HH  H/u
HGHP0MHH蓤HH  H+u	IHP0HL$xHt$xHt
H)uHAP0HMIH. HAL   MtA HIH  H H9CuRH{HtIHsHHHHH)uHAP0HHHH8  H/u
HGHP0IHmHH  H+u
HCHP0L|$PHII Dx
AADE4  H.u
HFHP0IE8  HL$xHȈ HAL   MtA HH2  LEI@HHpHtHAHt
IIIIHH  H L{MLd$0I9T  LsLt$0MB  LsHLD$0II IH)uHAP0LD$0IFM~H; uBLE8HU8A   H}@IVHH
  HL$0H)uHAP0Ld$0   H;/ u^INQ=   uKLEHH}PHAI uINE3HUHEAHHuLt$0҄ P  t $/  x%     L HD$8LHw
  HD$0E3IIAILd$0Iy 蛣HH$
  HL$8H)uHAP0Ld$8'HHkHH9
  H/u
HGHP0H+u	IHP0HL$xHH\$xIH)uHAP0L|$PH\$x HH  LIH p  HL$pLHt$pHt
H)uHAP0L|$HIH  IIGL   MtAR HH  LxLd$8HF I9U  LCLD$8MC  LsHI IIH)uHAP0LD$8IFM~H; uEHD$pHUXLEXIA   HE`	HHupLt$0 R   j/  #  H; ubINQ=   uOHD$pHEpLEhHAI uINE3HUhEAHH  HL$8H)uHAP0Ld$8w    HH  HL$8E3HHHHD$pILd$8H HG IHH  H/u
HGHP0IIHHHW  H+u	IHP0H.Iu
HFHP0Lt$`IIN(H;
d   Ho jHH  H@HH8 L   MtAI HHb  H+u
HCHP0H6 LII9i  H_H\  LwHHIIH)uHAP0IFM~H; uOHD$PHUxA   H   IH]xHH
  H+   HCHP0Lt$`I   H; uoINQ=   u\HD$PH   H   HAI uINE3H   EAHH(
  H+u
HCHP0Lt$`I       HD$8LH+
  HXE3HD$PIIIH IA 'HH	  HL$8H)uHAP0Lt$`Ld$8HT$PHHH
  H/u	IHP0HMIHuLHt
H)uHAP0IN(IH;
/ #
  H 5HH  H@HHpHtHAHt
IHIHNHH  H.u
HFHP0HMLH}Ht
H)uHAP03IJ HH6  A   HI HD$8LH  H.uHFHP0LL$8II<D  HD$8H(u
HPHR0Et/    HD$8LH  H
ˆ HH@HIMILMMH)uHAP0HUH
_ JHH     c HD$8LH
  H@IIH8G HH
  HL$8H)uHAP0HMLLd$8H}Ht
H)uHAP0L|$HIGHHpHtHAHtHT$PI
HT$PI苗HH	  H@HH) L   MtA HD$8LH	  H/u
HGHP0    HHe	  ILp HH.	  L HH    L|$8LIHHH  I/u
IGIP0H/Ld$8u
HGHP0H.Iu
HFHP0L|$PLHL$HII =  H+u
HCHP0II H  HEAE  HME3AQHH  Hm A   H'HHH  H+u
HCHP0HI :D  H.u
HVHR0Ee  H
Ņ ДHH0  H@HH L   MtA? HH  H+u
HCHP0LD$HI@HHpHtHAHt
IIII3HHq  H LwLd$8I9S  LL|$8MA  HwHIHHH)uHAP0HFLvH;x uIA   L   H   H   H諚HH(  I/u
IGIP0Ld$8   H; udHNQ=   uQL   H   HAI uHNE3H   EAHH  I/uIGIP0Ld$8t    LH  HL$8E3HHHHX HLd$8IHH  I/u
IGIP0Ld$0'HHHH  H+u
HCHP0H/u	IHP0HT$PLHL$HIw r  H.u
HFHP0Lt$0IL|$@H}HEH Hw !y M  x 2.    Lt$0y L  x w.    Lt$0x L  x .    Lt$0x L  ix .  m  Lt$0x L  Kx .  O  Lt$0x L  -x .  1  rx L  x e.    Yx L  w b.    @x L  w `.    'x M  Iw P.    Lt$0Ix N  w .    Lt$0Iw N  w .    H H~ w N  ]w .    Lt$0w N  ?w .  C  w O  &w .  *  Lt$0fw P  w /    H4 H} ?w P  v 1/    Lt$0!w P  v +/    w P  v /    Lt$0v P  v /    Lt$0v P  nv /  r  Lt$0v R  Pv r/  T  Lt$0v R  2v ~/  6  Lt$0rv R  v x/    Lt$0Tv S  u /    Lt$06v S  u /    Lt$0v S  u /    Lt$0u S  u /    Lt$0u V  ~u /    Lt$0u [  `u 60  d  Lt$0u [  Bu 30  F  Lt$0u [  $u 10  (  Lt$0du \  u \0  
  Lt$0Fu \  t e0    -u \  Mt r0    H IHV{  u \  t l0    Lt$0It \  t x0    Lt$0t \  ct U0  g  Lt$0It \  Bt H0  F  Lt$0It \  !t E0  %  Lt$0I^t \   t C0    Lt$0@t [  s *0    Lt$0"t Y  s  0    Lt$0t Y  s 0    Lt$0s Y  s 0    Lt$0s Y  js 0  n  Lt$0s Y  Ls 0  P  Lt$0s Y  .s 0  2  Lt$0ns Y  s 0    Lt$0Ps W  r 0    Lt$02s W  r /    Lt$0s W  r /  Ld$8  Lt$0r V  r /    Lt$0r V  ur /  y  Lt$0r V  Wr /  [  Lt$0r T  9r /  =  Lt$0yr T  r /    H
	 HE H	 Lt$0Dr T  q /    Lt$0&r S  q /    Lt$0r S  q /    Lt$0q S  q /    H
H	 HD H	( Lt$0q S  Wq /  [  Lt$0q R  9q d/  =  Lt$0yq R  q W/    Lt$0IXq Q  p L/    Lt$0I7q Q  p J/    Lt$0q O  p .     q O  p .    p O  p .    p N  Imp .  q  p N  IQp .  U  H} Hv p N  *p .  {  op M  Ip ,.    Sp L  Io ".     Ht H HHXI   " I/u
IGIP0Lt$HIMHML$  L$  H$  H$  H$   Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0MtI.u
IFIP0HL$PL$   Ht
H)uHAP0HMHt
H)uHAP0HL$xHt
H)uHAP0HL$pHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HM Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$XHt
H)uHAP0HEHtH(u
HPHR0IH  H3H(  A\]n K  Im .    3< LHu'H H.t m ^  zm 0    H\$`LHD$HMHK(H;
J u>H
 H2A H	 Hr Hs }m _  m 0    HSs LHu'H7 Hs Bm _  l 0  U  I LHu'H
 H_s 	m _  l 0    I/u
IGIP0Ld$@MLd$0MM)  D  H
aw HH
  H@HHJo L   MtAS HH
  H.u
HFHP0HGHHo L   MtA HHC
  H/u
HGHP0Im HH
  H AMLd$0H9Fu3HVHT$0Ht%HFHHHH H)uHAP0   DHFH;s uoHC(DALt$0H`  H]Hh  HHH+LX  H`  Hp  脋HD$@H   hk `  Ik 0    H;[    HVDBA=      HC(L  Lt$0DYH]H  IHL+Lx  H  H  HBA uHNE3MIHD$@H  MtI.u
IFIP0H/MLd$0   HGHP0    HHE  HD$0Ht	HCLd$0HL$`E3J|HIHA(H HA(HJD HEH JD(HHD$@H  H+u
HCHP0H]Lt$0H.u
HFHP0HMIHD$@HEHt
H)uHAP0HD$`Ld$@HH(H;
b  3  Hup hHD$@HH  E33H芄HH  H/u
HGHP0HMHLd$@HuHt
H)uHAP0HI'[     HD$`HH(H;
 `  Hn сHH)  E33HHD$@HH  H.u
HFHP0HH HH  H+u
HCHP0H/HHuuHGP0H
r 迁HD$@HH~  H@HHm L   MtA) HH.  H/u
HGHP0H LsLd$@I9H  H{H|$@H6  HsHHHHH)uHAP0HFLvH;  uDHEHUA   HEHH}ևHH3  H/uuHGHP0Ld$@   H;  u_HNQ=   uLHEHEH}HAI uHNE3HUEAHH  H/u
HGHP0Ld$@t    HH  HD$@E3HGHHEHLd$@H HG HH  H/u$HGHP0HUHHH  H+u	IHP0HFHH/m L   MtA` HH#  H.u
HFHP0HM IH] HHt
H)uHAP0H
mp xHH  H@HHi L   MtA HHh  H+u
HCHP0    HH   Ho H HCHi H HC Hs(HGH@pHtH@Ht
HHHHHH  H+u
HCHP0HL$HHIMj^  H.u
HFHP0Lt$0IIM;  H\$`v8e `  Id 0    e d  Id ,1  I  d d  Id )1  I  d d  I}d '1  I{  H
6 H8 H	 d d  IGd %1  IE  Lt$0Id e  #d X1  $  Lt$0I`d e  d `1    Lt$0Bd e  c l1    Lt$0I!d e  c f1    Lt$0I d f  c 1    Lt$0Ic f  c 1    Lt$0Ic f  `c 1  a  Lt$0Ic f  ?c 1  @  Lt$0I|c f  c 1    Lt$0I[c e  b r1    Lt$0I:c e  b R1    !c e  Ib D1  I  c e  Ib B1  II  b c  Ib 1  I}  b b  I`b 1  I^  b b  IAb 	1  I?  H
 H;6 H	 lb b  Ib 1  I	  Lt$0Hb `  a 0    Lt$0*b `  a 0    b `  Ia 0    a `  Ia 0    a `  Ixa 0  y  a `  I\a 0  IZ  H
k zHHu6a 1  I*  H@HHe L   MtA! HHu` 1    H+u
HCHP0H LII9  H_H  LwHHIIH)uHAP0IFM~H; u?Ll$HHUA   LmIH]ɀHH   Lt$0V` 1  M  H;    INQ=      Ll$HLl$hH\$`HAI uINE3HT$`EAHHuLt$0_ 1     H+u
HCHP0H/u	IHP0Im ILIEP0    HD$@LHuLt$0_ 1  {HXE3HD$HIIIH IE ~HHuLt$0G_ 1  AIm u
IEIP0Ll$HVLl$HHI|HH:_ 1  N_ g  MH( He MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0MtIm u
IEIP0L|$@Lt$HHL$8Ht
H)uHAP0MtI/u
IGIP0HtH.u
HFHP0D^ H
2 5^ hAH\$ UVWATAUAVAWHpH H3HD$`H= MH5 HL5 LLzH|$@IHt$HLt$PH|$XM}  Mt@Ht1Ht"HtH  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@I5 HIMtHtBHtiH      H  HW\ ILB2 HtHHD$@HH  HJ] ILB HtHHD$HHHx  H%\ ILB HtLHD$PHHK  H[ ILB HtHHD$XHH  H, IHD$(LL$@H L|$ Uiy
*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
>T L|$0IL
V H?Ll- HHV HMLIH
 HL$(H
 HD$ H	 +  H H:b [ [   A  H
5- >3&Hj0Lr(Hr HzMHl$ LHIƯHL$`H3H$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMHx] L   MtA H|$0HHu'H H^a [   Z }*         HHuZ *  sHE Hh HHuH
 H
a XZ *  QHY MHs y5Z *   LHHyHHuyZ *  HD H` OZ   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0DZ H
* Y <33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt/ZHR  HW ILB HtHHD$@HH%  HW ILB HtHHD$HHH   H) IHD$(LL$@H} Hl$ 3ey
N*     H|$HH\$@   H   H   H   H
:P Hl$0HL
R H?L( HHR HHLIH
 HL$(H
 HD$ H	 _*  H H6^ W W   A  H
A( :3Hz HZLHIBH\$pHl$xH$   HPA_A^_LATAVH   H# H3H$   HE3H; LI[ AIkIsAI{AMkEM{ELD$8HT$ HL$0Ld$(  3W HHu'H HI] V   V )  m  HD$0HH(H;
p u0H
? Hp% H	 V   SV )    HOV JoHHu'H
k H
\ vV   V )    H@H; tsH;G tjHI HHu'H
 H
z\ $V   U )  <  H@H   HL$@Hu'U   U )     HHMLd$@H/u
HGHP0HD$@Hu>HT H9CuL;s  HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0Hm[ IL;tI]xVnHMH9M ~IE HEL,HAHEKIH 7T   T 6)     T   T 4)      HtH` HH-t% H+u
HCHP0HL$ Hl$ ;  ~T    T ,)     L5\ H
}Y IMF HHtH % HtIS N)  <IvHHuS N)   HL$ H DuES P)  S   H H%Z H4  Hm )  HEHP0  Hm u
HEHP0Et`    HHu,Hj Lt$ HY pS   S \)     HL$ HT$ HH@HH)uHAP0H=] H
NX HLG HHtH ^ HtIHuHH   H H2Y R   ~R u)  Lt$ HtH+u
HCHP0MtI/u
IGIP0HL$(Ht
H)uHAP0HtH.u
HFHP0DpR H
]" R B5  HCHHT L   MtA HHu'H	 HjX R   Q w)  3H+u
HCHP0HGHHZ L   MtA HHuH HX \Q z)    H/u
HGHP0Hl$0HM(H;
' u>H
 H  H	 HO HW ZQ   P )  yHP iHHu'H HuW Q   P )  >HM(H;
 u4H
p H  H	P H H*W P )  )  H<X wiLHu]P )    Hy MALd$(H9Cu0LsLt$(Mt"HCHIHH H)uHAP0   HCH;    HD$ HT$PHD$PDEHHH+Lt$HH|$XL|$`$pHHuH HVV O )  U  MtI.u
IFIP0H/Ld$(u
HGHP0I/u
IGIP0Lt$ H+u
HCHP0ILH)uHAP0H
.Z hHH  H^ IHU fO    O )  H;\ uHKQ=   ulHD$ LT$pHD$pDEHL+Lt$hH|$xL$   HAI uHKE3IHHH H'U }N )  )MZ HHuD`N )  H
 H
T N   HH/HGHP0Mt	LpLd$(Lt$ E3HHILtEH|EL|MPmHHu'H HrT N   M )  @H.GHFHP08H@HHQ L   MtA HHu*H MHT M    NM )  H+u
HCHP0HFHHO L   MtA, HHu'H= HS HM    L )  H.u
HFHP0H IAH9Cu+HsHt"HCHHHH H)uHAP0   HCH;    HD$0H$   H$   DGHD$8HH$   HH+H$   H$   lHHu*Hh MHR pL    L )  H  H.y  HFHj  H;G    HKQ=      HD$0L$   H$   DGHD$8H$   HL+H$   H$   HAI uHKE3IHHZH MHQ K    BK )  O LHu'H] HQ hK    
K )  HtHpIHL$0E3HT$8HILGHE HIlGHITI(jHHu'H HJQ J    J )  I/u
IGIP0H+u
HCHP0LL$   H$   H$   H$   H$(  MtIm u
IEIP0L$   MtI.u
IVIR0IH$   H3H   A^A\H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@IF HHHtHt/ZHR  H{H ILBV HtHHD$@HH%  HfH ILB) HtHHD$HHH   H IHD$(LL$@H Hl$ Uy
(     H|$HH\$@   H   H   H   H
@ Hl$0HL
[C H?L HHUC HHLIH
 HL$(H
 HD$ H	 (  Hu HN 0H zH   A  H
 L+3Hz HZLHIH\$pHl$xH$   HPA_A^_HUAWHXHX3HpHxL`LhLH
M LpHGP H L5K L=6P IMF HHtH  HtHItjHHu'H HM G   2G (    HCHHOR L   MtA  HHu'H1 HM <G   F (    H+u
HCHP0H LfHI9$  H^H  LvHHIIH)uHAP0IFMfH;x uPA   H\$ HT$ L|$(IfLH   H~ HL F   +F $(    H;    INQ=      H\$0L|$8HAH uINE3HT$0EALHu'H HdL F   E ,(  v  H+u
HCHP0HH.u
I$HP0I.Hu
IFIP0   R LH  H HHK E   9E H(        HHu'H
R H
K ]E   D 2(    HXE3IHILx HFdLHu'H HhK E   D 8(    H/
HGHP0IHaLHH HK D   ]D (  #  IEIH IEIFIE H IE IF IEHG L   MtA- HHuD P(     H HH9G  H_H  HwHHHHH)uHAP0HHaHHuC ](  DH+u
HCHP0HH/u
HGHP0   [ HH   ]C d(  H HI C   I.u
IFIP0HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0DCC H
 B &fH_HH9B `(  [HB HH HGLw Hw(H H H~ HG0Hs H Hi HG8Lt$@Ll$HLd$PH$   Ht$xH\$pMtI/u
IWIR0HHXA_]K@UAWH8HBE3H; AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH; t[HHh HHu'H HJH A   A '    H@L   Mu^wA '  i  HIIMMu>HJ H9GuH;w  H_HHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHI&[HHtFLHI' tH+BHCHP03@   @ '     @   l@ '  k H   H
L LI;   HHD9   }      @t3HIHG ug	@ '  S@   H0 HF HtH/u
HGHP0HtH+u
HCHP0D@ H
Q ? "  H/u
HGHP0L= ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Hl$ AVH HC E3H\$0E3HHt$8H
= H|$@HHu2H- H HuE ?   HE > '    HXHH
G HC HAL   MtA HHu'H HE >   ^> '  H  Hz IH9C   H{H   HsHHHHH)uHAP0HHx[HHu= #'  uH/u
HGHP0IH+u
HCHP0HHue  HHu]H HWD >   = 5'  {HZHHu= &'  H HD =   HtD2HHHubH HC =   6= 7'  H+u
HCHP0HtH/u
HGHP0D^= H
+ < 0 &H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Ypt3H A^A\_^[Hl$PLl$`L|$hMu*H E3HB <   /< &    L LHu'HM HB X<   ; &  Z  IFHHHu-H
 Lz H5 H	2 ; &    HAH; tWH; tNHC HHuH
 H
%B {; &  ~  H@L   Mua\; &  Q  H3E3H@ Mu>H, H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA HHtNH+u
HSHR0IVLI3 uH/HGHP0@: &  5  1: &  &  H
 L. H3 H	v : &      Ht H HHj   4 H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$p>ILl$`H A^A\_^[9 &  3H7 H? B9   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D8 H
 8 H\$Hl$Ht$H|$ AVH H7< HH

8 E3M~HHuH |&  H   H
6 HxHH5B L5@ H-? X HHtzHIH_HG3HGt GpHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`HGhK H+u
HCHP0HG&  H H= U7 7   A  H
 qH+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtHjH  HH [H [@SH HYHtHyjH  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@MG  LbIMt4HtH2  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@IL HIMtHt*LH4 ILBe HD$@HH   HH4 ILB= HD$HHHtNHH  H= IHD$(LL$@H Ld$ Ay
%     H\$HH|$@   H
 H HD$0   L
D- HD$(L H/ HD$    H	 %  OHzt}HFL
- H
7 L HD$0H</ H HD$(H	HD$     %  Hj H: u4   4 A  H
f A:HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HǄ$   HE3Lt$0Lt$8HD$0Lt$ Lt$(HD$ EEALt$PAL$  EHCHu'HR H9 ]3   2 $    H  L{L$  Lc Ld$XII$L|$hLd$pIH
= 3LHHu'H HE9 2   2 $  F  H@L   Hr5 HMtA HHu'H H8 2   =2 $    H+u
HCHP0HFL   H; HMtA HHu'H, H8 72   1 $  V  H.u
HFHP0IL$  LcH I9$  HsH$  H  L{HIHIH)uHAP0MgI$H;c uaH$   H$  H$   A   H$   IQHH   HX H7 c1   1 %  K  H;Y    IOQ=      H$   H$  H$   HA IuIOE3EAH$   HHu'H H-7 0   y0 %    H.u
HFHP0IL$        1 LHu'Hr H6 }0   0 %  e  HpIL$  H$  H IE E3IIVOHHu'H Hx6 "0   / %  
  Im uFIEIP0:IH	MHHu'H H+6 /   w/ $    H+u
I$HP0HGH H;1  H;7 $  H HHu*Ha H5 l/   / 9%  Mf  H/u
HGHP0IHFL   MHAHMHtlA   HALHtXHAHJAy'H H@5 .   . A%    L)&u
HFHP0IL$     H.u
HFHP0I8AuIBHu H4 .   ". I%  h  HOHtU~A   H( H
 H	\ 
HxAH Hz4 $.   - $%  M  H;u
Lo H_H_LkHHIE H/u
HGHP0H\$PH\$xL$   L$  L$   MHHL$@C'  HHD$0H;tTHT$0HRHL$0HD$0H@HD$0H HD$0H@Lt$8HL$0HHD$0HHL$8HCHD$8HKH|$@HWHL$@oHD$@H@HD$@H HD$@H@Lt$HH|$@HH$  HHL$@  HHD$ H;tTHT$ HRHL$ HD$ H@HD$ H HD$ H@Lt$(HL$ HHD$ HHL$(HCHD$(HKLD$@MM H$  HL$@0   DBoHL$@mLd$XIu2 Ht'H) H2 4,   + j%  S  H  H$  LD$ HT$0HUkH$   HAH   E3H4 H
/ JHHu'H H2 +   W+ %     E33H-6H+u
HCHP0Hf H1 q+   + %     L$  Ht$P   HD$hH$  HL$pHL$XH\$xH\$PL$   L$  H$   HH$  LHtH+u
HCHP0HtH/u
HGHP0H$  Ld$XHtH.u
HFHP0MtIm u
IEIP0Ht$PL$  D* 9* H
 e
AMtI/u
IGIP0MtI,$uID$IP0HtH.u
HFHP0HtH/uHGHP0LD$ MM H$  HL$    DBoHL$ LD$0MM H$  HL$0|   DBoHL$0AH   A_A^A]A\_^[H\$Ht$WH IHHMt-I H~H-3uH\$0Ht$8H _HHHXH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH   H@LE3L|$`L|$hL$   L$   L|$HL|$PHD$HL|$8L|$@HD$8L$   L|$(L$   EAW$   L$   H3 LCHH
s- 
 HHtH  HtIHJHHu'H Hb. ( x  ' 3"    HGL   H* HMtA LHu'H H. ' x  Z' 5"    H/u
HGHP0IFL   H0 IMtA8 HHu'HI H- T' x  & 8"  U  I.u
IFIP0ML$`  LgH I9$  LwL$`  M  H_IHHHH)uHAP0LcI$H; uYL$   L$   A   H$   HFHH   H} H, & x  *& L"  t  H;~    HKQ=      L$   L$  HA IuHKE3EAH$   HHu'H HZ, & x  % T"    I.u
IFIP0ML$`        ^ HHu'H H , % x  L% Z"    LpML$`  IE Lh E3HHDHHu'HK H+ V% x  $ `"  B  H.uFHFHP0:IH>BHHu'H H`+ 
% x  $ F"    H/u
I$HP0IHCHѺ H;(  H;i   H LHu'H H* $ x  @$ "  r  H+u
HCHP0IFH   MIHIHtjA   IHHtWIH6y'H H{* %$ x  # "    M)&u
IFIP0ML$`     I.u
IFIP0Ms6uIW7H H* # x  ]# "    HKHtR~A   H H
 H	 
Hx6HT H) _# x  # l"  3  H;u
Hs H{H{HwH?HHH+u
HCHP0HHD$`H$   IHt$hH$   I  HH$   3A  HHTLH$   (  wHH$   3A(  HH<UH$   M   E3H* H
% AHHu'HF H( Q" |  ! "  R
  E33H,H+u
HCHP0H Hc( 
" |  ! "  
  H   E3H) H
% @HHu'H H( ! ~  a! "    E33H7,H+u
HCHP0Hp H' {! ~  ! "  |  Hq H$p  H) H9Au9ϵ Hu'H H|' &!     "  '  H$   H
' ':HHu'Hؾ H9'       
#    H@L   H' HMtAs HHu'H H&     1  #  f  H+u
HCHP0HFH;    H;L t~HH$   LH HHu'H Ht&      #    H@L   Mu?Hܽ H=&     #  
  HHMMHǄ$   H.uHFHP0@ Mu?H< IL|$0H9CuL;c   HCJ4L;c}zJtHI  HAHHD$0H   HtHH HHht6 *H Hf%     1#  I	  H+u
HCHP0H$p  LHL;
 tRH;n tIMIL! Hz H
+ H	´ H H$    8 h#  	  HH$      HT$`HL$p  HHD$HH;tTHT$HHRHL$H|HL$HHIHL$HH	HD$HH@L|$PHL$HHHD$HHHL$PHCHD$PHKH|$pHWHL$p(HD$pH@HD$pH HD$pH@L|$xH|$pHHT$hHL$p  HHD$8H;tTHT$8HRHL$8HL$8HIHL$8H	HD$8H@L|$@HL$8HHD$8HHL$@HCHD$@HKLD$pMM HT$ HL$p   DBoHL$p/H  HD$ LD$8HT$HH]\LM   E3H& H
  ;HHu'H H#    i #    E33H?'H+u
HCHP0Hx H"    % #    IL|$ L$x  L;%   3 HHu'H$ H" /    #  0  ID$H; t~H; tuIT HHu*Hչ H6"     #  I  H@L   MuAH H!    H #  Iz  II$IH$   MHMu@H	 H9FuH;N   HFH<H;N   H|HHH$   HAHHD$ H9  H$   H$   Ht
H)uHAP0HGL   H" HMtA HH   E3H! H9LHt~H/u
HGHP0IIHf  u5I.u
IFIP0ML$`  H$   IL|$    H6 H  A    #    H Hp      #    H HI      #    * HtEHv HHtɮ 'H H    E #  z  H.u
HFHP0IL|$0H$   LcIu'HG H R    #  S  HT$pIOHXH+HHL$p%L;t|H$   HL$pnHH$   ΁HL$p6 Ht'H¶ H#    o $    H$   HL$p HIE[L$   H$   HIYODH$   	  Hu'HM H X    2$  Y  HD$(H|  HHu'H Hr     >$    HD$(HH8H)uHAP0HD$(HX8H$   HtH-I(  HMtI#KD$`  A HHu'H H    0 `$        HHu'HI H T    b$  +  HXH\$(HHX   E3H$   HL$`L$   Ld$hL|$(AH|$ L$`  Ht$0  E3H$   HL$`L$   Ld$hL|$(AAL$`  Ht$0  H$   LH$   HtH)u
HAP0LIIAL   H	 IMtA. HHu'H? H J    A#  !  ML$`  H H9G   LwL$`  MttHwIHHHH)uHAP0IH2HHu'H H    h N#     I.u
IFIP0ML$`  4HV2HHu$Hg H r    Q#  LH/HGHP0H$   HT$`E3H$   L$`  AAL|$(HT$hIHtH+u
HCHP0HtH/u
HGHP0MtI.u
IFIP0HtH.u
HFHP0D e H
 IH\$(HL$`Ht
H)uHAP0HL$hHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0HtH+u
HCHP0H$   HtH)uHAP0H$   Ht(H$   HML$   L+IH	LD$8MM H$`  HL$8[   DBoHL$8LD$HMM H$`  HL$H   DBoHL$HgHH   A_A^A]A\_^[H\$UVWAVAWH`Ha H3HD$XH5 WHt$PMHD$@Mq  LzIMt3Ht"HtHg  Hr(Ht$PHB HD$HHjHl$@Hl$@I( HIMtHt0HtKvH ILB; HD$@HH   HH ILB HD$HHt{HHv  H ILB HtHHD$PHHI  HQ IHD$(LL$@Hm L|$ y
!     Ht$PHl$@  H
? H HD$0   L
0 HD$(L H- HD$    H	 !  xHBH   H   HCHQ	 3HD$0HL
 L HHH HD$(HL$ LMH
 H H	) !  H HN  r   Ar  H
I 3!Hr(HB HjHD$HLD$HLHHL$XH3H$   H`A_A^_^]H\$Ht$WH H5 HH
 HLF HHtH  H   H2HH   H H9CuHH HHuH
 H
J  !  .E3HH.HHuIH H p !   p  H/u
HGHP0HtgH+uaHCHP0UH/u
HWHR0H+u
HSHR0HH\$0Ht$8H _H= H H p   !  D7 H
  	3H\$0Ht$8H _{@UVWATAUAVAWHl$H0  HEH$  Hy] H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@ HD$8ELd$HL#LcHD$P   AAAWEWMEHE   LeDeIEH;ۢ tsH;* tjILd$XIv LHD$`Hu'H HS 
 i  
      H@H   HD$hHuo{
    Q  MLl$`IE Ld$X3HD$hfD  Hu=H< I9FuM;f  IFJ<M;f  K|HILd$XIHHw  ILH}Ht
H)uHAP03Hؤ 98uIG      7  IEHHpHtHAHt
IIII&HH  H@L   HO HMtA HH  H/u
HGHP0HCL   H HMtAC HHA  H+u
HCHP0IEHHpHtHAHt
IIII<&HH  H@L   Hn HMtAˢ HH  H+u
HCHP0   t HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHMςHHMCmHUHtLE L+I
WEH] HUHtLEL+I5 H  IHM
HHM~HM%~g Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8}LH HD$ LHUHL$8H]HUHK@b^HKXHUuLt$`L}Ld$XLmHD$h9H H
ۡ H	 	 j  f	 !  33B  	 l  I	 A!  )  	 l  0	 @!    u	 k  	 .!     \	 k   +!     C	 k   )!  3   (	 k   &!  3   
	 k   #!  3    k   !!  33s( H   H
p LI;   HH    }      @t3HIHk    )  !  33o i  HL H MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
j eH\$pc  I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8H{gMtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;rҚ H+Hs H'v HHE   HE    E HUHtLEL+IwHUHtLEL+I讙LD$8MM HUHL$8d   DBoHL$8衼HHM(H3H$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  HT H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@pHD$8ELd$HL#LcWHD$P   AAAWEWMEHE   LeDeIEH;K tsH; tjILd$XI LHD$`Hu'Hb H m W   3     H@H   HD$hHuo 5   Q  MLl$`IE Ld$X3HD$hfD  Hu=H I9FuM;f  IFJ<M;f  K|HILd$XIHHw  ILH}Ht
H)uHAP03HH 98uIG      7  IEHHpHtHAHt
IIIIeHH  H@L   H
 HMtA HH  H/u
HGHP0HCL   H
 HMtA HHA  H+u
HCHP0IEHHpHtHAHt
IIIIHH  H@L   H
 HMtA; HH  H+u
HCHP0    HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM蟃HHMgHUHtLE L+IzWEH] HUHtLEL+IU H  IHMzHHM.vHMuי Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
(  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8sH]HUHK@RmHKXHUEmLt$`L}Ld$XLmHD$h9HB H
K H	" 4 X    e   33B   Z       )    Z           Y    ~        Y  n  {        Y  U  y   3     Y  :  v   3   }  Y    s   3   b  Y    q   33s H   H
 LI;   HH    }      @t3HIHۘ     P   33 W  H H MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
z H\$pcp I.u
IFIP0HD$8H\$pH;t>HHRHjHH@HH HH@HC    DD$0HT$8H_MtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<tR HAH;rB H+Hs2 H'v% HTHE   HE    E HUHtLEL+IHUHtLEL+IΡLD$8MM HUHL$8Ġ   DBoHL$8HHM(H3bH$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH  HEHX)p)xHTL H3HELL3H|$PH|$XHD$PH|$@H|$HHD$@H|$`H|$hHE   H}@}DH|$0L;= uEL HH H
 H	8 H Hb  	     P`  L%" H I HHu7$ HuI'H H  	  X   _  HHDu$ړ Ht 	  !   N  H/u
HGHP0Ee L;= u>H H
 H	 H Hz $ 
     h_  HZ IHHu'Hۙ H<  
     *_  HDu$
 Ht 
  T   N  H/u
HGHP0EeL;=$ u>H˷ H
 H	ӑ HL H W      ^  HU IHHu'H Ho       ]^  HHM҉HHMnHMm/ Ht   v   <M  H/u
HGHP0IMHEH;tIE3HUܪL;=- u>Hd H
 H	ܐ HU H  `      ]  H^ IHHu'H Hx  "      f]  Hx H;uA   (H
Dy      NL  H/u
HGHP0E  H
S HHu'H H  
  4   \  H@L   H HMtA" LHuL 
     ,\  H+u
HCHP0IFL   HG IMtA̏ HHu'Hݖ H>  
   	  [  I.u
IFIP0E3L;=[ u0H" H
# H	
  
  >   |[  H I2LHul 
     L[  3HL$0LcH I9$  LCLD$0M  H{I HHHH)uHAP0LD$0LgI$H; u\LD$pLt$xA   HT$pHHHu 
  o $  Z  HL$0H)uHAP03HL$0  H; uZHOQ=   uGLELuHA t3HOE3EAHUHHuL 
   -  ,Z     ƍ HHu'H
 H
h  
   4   Z  HL$0HH3HL$0Lp E3E3HHHHu 
  n :  Y  H.uEHFH9IHHHu 
  3   qY  I.u
IFIP0H+u
I$HP03HGHI H;   H;    H LHu$ 
   [  3H  H/u
HGHP0IFH   E3IH3HtPDfIHHt?IHy 
  \ c  X  M)&   IFI   I.u
IFIP0E3uIh 
  
 k  HX  HOHtF~A   H H
m H	D 
Hx 
   F  3}G  H;u
Hw H_H_HsHHHH/u
HGHP0H\$`Ht$hHHMWHHL$PWLEMM HT$8HMB   DBoHM萪HHMHHL$@7ULEMM HT$8HM   DBoHMMIM(HT$PWIM8HT$@qUL;= u@H9 H
 H	q H HK       3W  H	 IHHu)H H    W   3V  Hy H9GuwHC (=+ f.z*u( Ht_      33E  H/u
HGHP0AuHL;=ˉ u@Hұ H
 H	z H HT       3V  H IHHu)H H    `   3U  HHMuHHM)fHMe҉ Htw      33D  H/u
HGHP0IMXHEH;tIE3HU{L;=̈ u@Hc H
 H	{ H HU       3U  H; I
HHu)H H    a   3T  HÀu( Ht   )   33C  H/u
HGHP0A]xL;= u@Hܱ H
 H	 H H~ (      3>T  H| I	HHu)Hݎ H>       3S  HÀu( Ht   R   33C  H/u
HGHP0A]yL;= u@H H
 H	͆ HF H Q      3gS  HM IHHu)H Hg       3'S  H@L   Hr HMtA HHu   k   3,B  H/u
HGHP0H Ht'Hp H {      R  H.u
HFHP03A]|L;= u>H H
 H	 H Ht       6R  H IHHu'HՌ H6       Q  HHM}HHMMbHMa Ht'H H    /   Q  H.u
HFHP03I   HEH;tIE3HU萞L;= u>HЯ H
 H	 H	 Hj       ,Q  H IHHu'Hˋ H,    x   P  HÀu2 Ht'H H    4   P  H.u
HFHP03A   L;= u>H H
Ǆ H	 H' H 2    #  JP  H0 IHHu'H HJ     %  P  H
J HHu'H H    [ '  O  H@L   H HMtAI HHus    )  >  H/u
HGHP0A   HH HHu0    ,  
O  H.u
HFHP03H+u
HCHP03H9Dy    /  I>  H/u
HGHP0EC%  L;=Q u>H H
 H	  Hy H    & <  N  H IHHu'H; H F    >  ^N  H< H
 HH9Gu HHu    @  f=  H/u
HGHP0H H HH9CuzJ HHu   N C  M  H+u
HCHP03HDu$ Htf    F  <  H/u
HGHP0E   L;=Հ u>H< H
 H	 H H^     S   M  Hn IHHu'H H     l U  L  H H HH9GuS#~ HHu   ' W  ;  H/u
HGHP0Hk Ht HH9Cu} HHu0    Z  
L  H+u
HCHP03HDu$E Ht    ]  O;  H/u
HGHP0E   L;=Y u>H H
! H	 H H    . j  K  H I"HHu'HC H N    l  fK  HD~ H HH9Gu | HHu	    n  n:  H/u
HGHP0H} H HH9Cu R| HHu   V q  J  H+u
HCHP0HGL   H HMtA4~ HHu^     t  9  H/u
HGHP0H{~ Ht     w  I  H+u
HCHP0A   L;=} u>HF H
W~ H	>} H H    d   I  H( IXHHu'Hy H    &   I  Hz| HK HH9Cu
z HHu?      I  H+u
HCHP0H%| HN HH9Guz HHu      O8  H/u
HGHP0Hu$} Ht   I   H  H+u
HCHP0A   L;=| u>H H
| H	{ H> H I      aH  H IHHu'H  Ha       #H  H{ H HH9Cudy HHu   h   G  H+u
HCHP0Hz H HH9Gu?y HHuq      6  H/u
HGHP0HNu${ Ht.      G  H+u
HCHP0A   L;=z u>H H
e{ H	Lz HŁ H&    r   F  H6 IfHHu'H H    4   F  Hy HY HH9Cuw HHuM      *F  H+u
HCHP0H3y H HH9Guw HHu      ]5  H/u
HGHP0H@@u$z Ht   R   E  H+u
HCHP0A   L;=y u>HN H
y H	x HG H R       jE  H IHHu'H	 Hj        ,E  H
x H HH9Cumv HHu    q   D  H+u
HCHP0Hw Hn HH9GuHv HHuz       3  H/u
HGHP0HWu$x Ht7       D  H+u
HCHP0A   L;=w u>H H
nx H	Uw H~ H/  !  {   C  H? IoHHu'H~ H  !  =   C  Hv Hb HH9Cu$t HHuV !     3C  H+u
HCHP0H<v H HH9Gut HHu !     f2  H/u
HGHP0Hu$w Ht !  `   B  H+u
HCHP0A   L;=-v u>H H
v H	u HU} H ` "     xB  H IHHu'H} Hx " "     :B  Hu H HH9Cu{s HHu "     A  H+u
HCHP0Ht H HH9GuV&s HHu "  *   0  H/u
HGHP0H襜@@u$u Ht@ "     A  H+u
HCHP0A   L;=t u>HV H
wu H	^t H{ H8  #     @  HH IxHHu'H{ H  #  F   @  Hs Hk HH9Cu-q HHu_ #     <@  H+u
HCHP0HEs H HH9Guq HHu
 #     o/  H/u
HGHP0Hr H9CusHs (f.z&u$	t Ht #  P   ?  H+u
HCHP0A   L;=s u>H H
s H	r HCz H N $   %  f?  H IHHu'Hz Hf  $   '  (?  Hr H HH9Cuip HHu $  m )  >  H+u
HCHP0Hq H HH9GuDp HHuv $   ,  -  H/u
HGHP0H,q H9CusHq (f.z&u$ur Ht $   /  =  H+u
HCHP0A   L;=q u>H~ H
Or H	6q Hx H  %  \ <  =  H  IPHHu'Hqx H | %   >  =  Hrp HC HH9Cun HHu7 %   @  =  H+u
HCHP0Hp H HH9Gun HHu %   C  G,  H/u
HGHP0Ho H9CusHbp (f.z&u$p Ht %  ( F  c<  H+u
HCHP0A   L;=o u>H H
p H	o Hw H| & &   S  ><  H IHHu'Hv H>  &   U   <  Hn H HH9CuqAm HHu &  E W  ;  H+u
HCHP0Hn HR HH9Gul HHuN &   Z  *  H/u
HGHP0Hku$fo Ht &   ]  :  H+u
HCHP0A   L;=zn u>H H
Bo H	)n Hu H  '  O j  :  H ICHHu'Hdu H o '   l  :  Hem H6 HH9Cuk HHu* '   n  :  H+u
HCHP0Hm H HH9Gusk HHu '  w q  :)  H/u
HGHP0Hu$m Ht '  4 t  o9  H+u
HCHP0A   L;=m u>Hp H
m H	l H)t H 4 (     L9  H IHHu'Hs HL  (     9  Hk H HH9CuOj HHu (  S   8  H+u
HCHP0Hk H HH9Gu*i HHu\ (     '  H/u
HGHP0Hyu$tl Ht (     7  H+u
HCHP0A   L;=k u>H H
Pl H	7k Hr H  )  ]   7  H! IQHHu'Hrr H } )     7  Hsj HD HH9Cuh HHu8 )     7  H+u
HCHP0Hj H HH9Guh HHu )     H&  H/u
HGHP0Hi H9CusHcj (f.z&u$j Ht )  )   d6  H+u
HCHP0A   L;=i u>H H
j H	i Hq H} ' *     ?6  H IHHu'Hp H?  *     6  Hh H HH9CurBg HHu *  F   5  H+u
HCHP0Hh H{ HH9Guf HHuO *     $  H/u
HGHP0HCL   H HMtAh HHu *     4  H+u
HCHP03HtDi Ht *  Z   $  H/u
HGHP0E   L;='h u>H H
h H	g HOo H Z +     r4  H IHHu'Ho Hr  +     44  Hg H HH9Guue HHu +  y   <#  H/u
HGHP0Hf H HH9CuP e HHu +  $   _3  H+u
HCHP03H6f H9GuwH g (f.z&u$g Ht$ +     "  H/u
HGHP0A  L;=f u>H H
Yg H	@f Hm H  ,  f   2  H* IZHHu'H{m H  ,  (   2  H|e HM HH9Guc HHuA ,     !  H/u
HGHP0H'e H HH9Cuc HHu ,     1  H+u
HCHP03Hd H9GuwHje (f.z&u$e Ht ,  0      H/u
HGHP0A  L;=d u>H2 H
e H	d H#l H . -     F1  H IHHu'Hk HF  -     1  Hc H HH9GuyIb HHu -  M      H/u
HGHP0Hc H HH9Cu$a HHuV -     30  H+u
HCHP0H
| OHHu -     ~  H@L   H, HMtAc HHu -  u   8  H+u
HCHP0A   HHFe HHu -  2     H/u
HGHP0H.u
HFHP03H蛊yG -   	  $/  H+u
HCHP0  L;=b u>H H
}c H	db Hi H>  .      /  HN I~HHu'Hi H   .  L   .  Ha Hq HH9Cu3` HHue .     B.  H+u
HCHP0HKa H HH9Fu_ HHu'Hh HX  .     .  H.u
HFHP03Hݫu$b Ht .  _    -  H+u
HCHP0A  
.  L;='a u>H H
a H	` HOh H Z /   7  r-  H IHHu'Hh Hr  /   9  4-  H` H HH9Cuu^ HHu /  y ;  ,  H+u
HCHP0H_ H HH9FuP ^ HHu'Hig H t /   >  ,  H.u
HFHP0H
 mHHu7 /   A  ,  H@L   H HMtA_ HHu /   C  +  H.u
HFHP0A   HHda HHu /  P F    H+u
HCHP03H/u
HGHP0H蹆y'HLf H W /   I  o+  H.u
HFHP03+  L;=^ u>Hr H
_ H	r^ He HL  0   V  +  H\ IHHu'He H  0  Z X  *  H] H HH9FuA\ HHu'HZe H e 0   Z  }*  H.u
HFHP0HK] H HH9Gu[ HHu 0   ]  u  H/u
HGHP0H\ H9FuvH] (f.z4u2^ Ht'Hd H  0  H `  )  H.u
HFHP0A   )  L;=] u>H H
] H	\ H6d H A 1     Y)  H? IHHu'Hc HY  1     )  H
Y HHu'Hc H  1  j   (  H@L   H HMtAX\ HHu 1  $     H/u
HGHP0A   HH] HHu? 1     (  H.u
HFHP03H+u
HCHP03HHDy 1     X  H/u
HGHP0E6  L;=`[ u>H_ H
(\ H	[ Hb H  2  5   '  H I)HHu'HJb H U 2     m'  HKZ H$ HH9GuX HHu 2     u  H/u
HGHP0HY H HH9CuYX HHu 2  ]   &  H+u
HCHP03H薤Du$Z Htu 2       H/u
HGHP0E   L;=Y u>H H
Z H	Y Ha Hm  3     /&  H} IHHu'H` H/  3  {   %  HX H HH9Gub2W HHu 3  6     H/u
HGHP0HzX H HH9Cu
V HHu? 3     %  H+u
HCHP03HDu$TY Ht 3     ^  H/u
HGHP0E   L;=hX u>H H
0Y H	X H_ H  4  =   $  H I1HHu'HR_ H ] 4     u$  HSW H, HH9GuU HHu 4     }  H/u
HGHP0HV H HH9CuaU HHu 4  e   #  H+u
HCHP0HGL   H HMtACW HHum 4       H/u
HGHP0H
W Ht/ 4  ѿ   #  H+u
HCHP0A   L;=V u>H H
fW H	MV H] H' ѿ 5  s   "  H7 IgHHu'H] H  5  5   "  HU Hb HH9CuS HHuN 5     +"  H+u
HCHP0H4U HU HH9GuS HHu 5     ^  H/u
HGHP0H}@@u$V Ht 5  S   !  H+u
HCHP0A   L;= U u>H H
U H	T HH\ H S 6     k!  H IHHu'H
\ Hk  6     -!  HT H HH9CunR HHuн 6  r      H+u
HCHP0HS Hw HH9GuIR HHu{ 6        H/u
HGHP0H1S H9CusHS (f.z&u$zT Ht 6       H+u
HCHP0A   L;=S u>HS H
TT H	;S HZ H  7  a     H% IUHHu'HvZ H  7  #     HwR HP HH9Cu
P HHu< 7  ޻     H+u
HCHP0H"R Hk HH9GuP HHu 7     L  H/u
HGHP0HQ H9CusHgR (f.z&u$R Ht 7  -   h  H+u
HCHP0A   L;=Q u>H H
R H	Q H Y H + 8  ͺ '  C  H IHHu'HX HC  8   )    HP H HH9CuvFO HHu 8  J +    H+u
HCHP0HP H HH9Gu!N HHuS 8   .    H/u
HGHP0H	P H9CusHP (f.z&u$RQ Ht 8   1    H+u
HCHP0A   L;=dP u>H{ H
,Q H	P HW H  9  9 >    H I-HHu'HNW H Y 9   @  q  HOO H( HH9CuM HHu 9   B    H+u
HCHP0HN HS HH9Gu]M HHu 9  a E  $  H/u
HGHP0HuN H9CusH?O (f.z&u$O Htc 9   H  @  H+u
HCHP0A   L;=N u>H H
O H	N HU HY  :   U    Hi IHHu'HU H ŷ :  g W    HM H HH9CuNL HHu :  " Y  ]  H+u
HCHP0HfM Ho HH9GuK HHu+ :  Ͷ \  	  H/u
HGHP0HL H9CusHM (f.z&u$*N Ht϶ :  q _    H+u
HCHP0A   L;=<M u>H} H
N H	L HdT Hż o ;   l    Hվ IHHu'H&T H 1 ;  ӵ n  I  H'L H  HH9CuJ HHu ;   p    H+u
HCHP0HK H HH9Gue5J HHu ;  9 s    H/u
HGHP0HMK H9CusHL (f.z&u$L Ht; ;  ݴ v    H+u
HCHP0A   L;=K u>H7| H
pL H	WK HR H1 ۴ <  }     HA IqHHu'HR H  <  ?     HJ Hl HH9Cu&H HHuX <     5  H+u
HCHP0H>J H߷ HH9GuH HHu <     h  H/u
HGHP0Hu$K Ht <  b     H+u
HCHP0A   
  L;=*J u>Hz H
J H	I HRQ H ] =     u  H[ IHHu'HQ Hu  =     7  H
u (HHu =       H@L   H HMtAI HHu =  N     H/u
HGHP0A   HHK HHui =     F  H+u
HCHP03H.u
HFHP03HrpDy =       H/u
HGHP0EM  L;=H u>Hiy H
RI H	9H HO H  >  _     H# ISHHu'HtO Hշ  >  !     HuG HN HH9GuE HHu: >  ܰ     H/u
HGHP0H G H HH9FuE HHu'HN H- װ >  y     H.u
HFHP03HF H9GuwHUG (f.z&u$G Hty >       H/u
HGHP0A   L;=F u>Hw H
G H	F HN Ho  ?     1  H IHHu'HM H1 ۯ ?  }     HE H HH9Gud4D HHu ?  8     H/u
HGHP0H|E H HH9FuC HHu'H(M H 3 ?  ծ   K  H.u
HFHP03HD H9GuwHE (f.z&u$0F Htծ ?  w   :  H/u
HGHP0A      L;==E u>Hlv H
F H	D HeL Hƴ p @       Hn IHHu'H'L H 2 @  ԭ   J  H
 ;HHu   mH@L   H HMtAD HHux   4H.u
HFHP0A   HHLF HHuGB    @  E3HfK Hǳ Ho  H/e  HGHP0V  H/u
HGHP0H+u
HCHP0Huk؅y'HK Hi  @     +  H.u
HFHP03b  L;=C u>Ht H
GD H	.C HJ H  A  T     H IHHHu'HiJ Hʲ t A       HjB H HH9Fu@ HHu'HJ Hw ! A  ë   9  H.u
HFHP0HB H HH9Cuj@ HHu̫ A  n     H+u
HCHP0HFL   H HMtALB HHu'H]I H h A  
     H.u
HFHP03H#B Ht( A  ʪ     H+u
HCHP0A   L;=A u>Hs H
_B H	FA HH H  ʪ B  l (  
  H0 I`HHu'HH H  B  . *  
  H@ H HH9Cu> HHuG B   ,  $
  H+u
HCHP0H-@ H HH9Fu> HHu'HG H:  B   /    H.u
HFHP03H迊u$@ Ht B  A 2  |  H+u
HCHP0A   L;=@ u>Hq H
@ H	? H6G H A C   ?  Y  H IHHu'HF HY  C   A    H> H" HH9Cu\= HHu C  ` C    H+u
HCHP0H> H HH9Fu7= HHu'HPF H [ C   F  s  H.u
HFHP03H6u$q? Ht C   I  
  H+u
HCHP0A   L;=> u>HTp H
M? H	4> HE H  D  Z V  
  H INHHu'HoE HЭ z D   X  
  Hp= H HH9Cu; HHu5 D  צ Z  
  H+u
HCHP0H= H$ HH9Fu访~; HHu'HD H( Ҧ D  t ]  	  H.u
HFHP03H譇u$= Ht D  / `  j	  H+u
HCHP0A   L;=< u>Hn H
= H	< H$D H / E  ѥ m  G	  H IžHHu'HC HG  E   o  		  H; H HH9CuzJ: HHu E  N q    H+u
HCHP0H; H HH9Fu%9 HHu'H>C H I E   t  a  H.u
HFHP03H$u$_< Ht E   w    H+u
HCHP0A   L;=s; u>Hm H
;< H	"; HB H  F  H     H I<HHu'H]B H h F  
     H^: H HH9Cu8 HHu# F  ţ      H+u
HCHP0H	: H HH9Fu蜼l8 HHu'HA H  F  b     H.u
HFHP03H蛄u$: Ht{ F     X  H+u
HCHP0A   L;=9 u>H1l H
: H	9 HA Hs  G     5  H I賻HHu'H@ H5 ߢ G       H8 H HH9Cuh87 HHu G  <   w  H+u
HCHP0H8 H) HH9Fu6 HHu'H,@ H 7 G  ١   O  H.u
HFHP03H7 H9CusH8 (f.z&u$49 Ht١ G  {     H+u
HCHP0A   L;=F8 u>Hj H
9 H	7 Hn? Hϧ y H       Hߩ IHHu'H0? H ; H  ݠ   S  H17 HZ HH9CuĹ5 HHu H       H+u
HCHP0H6 H HH9Fuo?5 HHu'H> H  H  5     H.u
HFHP03H^@@u$7 HtI H     &  H+u
HCHP0A   L;=6 u>HOi H
7 H	g6 H= HA  I       HQ I聸HHu'H= H  I  O     H5 H̢ HH9Cu64 HHuh I  
   E  H+u
HCHP0HN5 HW HH9Fu3 HHu'H< H[  I       H.u
HFHP03H4 H9CusH5 (f.z&u$6 Ht I  I     H+u
HCHP0A   L;=5 u>Hg H
5 H	4 H<< H G J     _  H IݶHHu'H; H_ 	 J     !  H3 H( HH9Cu蒶b2 HHup      H+u
HCHP0H3 H% HH9FuG2 HHu'H`; H k J  
      H.u
HFHP03HF~   }4 H   ʜ    J  E3H: HO HtH+u
HCHP0MtI.u
IFIP0HL$0Ht
H)uHAP0HtH.u
HFHP0H
Jf H+u
HCHP0A   HL$`Ht
H)uHAP0HL$hHtH)uHAP0HMTLD$@MM HT$8HL$@=   DBoHL$@&RLD$PMM HT$8HL$P>   DBoHL$PQHMH3L?L$  I[PA(sA({IA_A^A]A\_^]HL$USVWATAUAVAWHl$HX  3LHt$(Ht$pDHt$0DHt$xDI0 Hu'HM9 H X     j  =  HD$(0 Hu'H9 Hw !    Ú v  o=  A$   HD$ !1 HHu,H8 H\$ H. ؚ    z   &=  H
/ HηHHu    J   4<  H+u
HCHP0H\$(LH HM/ yc       :  H/u
HGHP0AL$   W0 HHu,H8 H\$ Hd        \<  HD LH. yޙ       9  H/u
HGHP0IL$+HHu,H7 H\$ H     2   ;  H LHJ. y`       
9  H/u
HGHP0AD$H/ HHu,H	7 H\$ He        ];  H% LH- yߘ       8  H/u
HGHP0AL$PiTHHu,H6 H\$ H     2   :  H6 LHJ- y`       
8  H/u
HGHP0AL$xSHHu,H6 H\$ Hg        _:  HO LH, y       7  H/u
HGHP0A8t$yt~IL$X)HHu,H5 H\$ H     .   9  H LHF, y\       	7  H/u
HGHP0A8$      I$   &)HHu,H4 H\$ HS        K9  H LH+ y͖    o   z6  H/u
HGHP0H
 ƯHHu,Hw4 H\$ HӜ }       8  AL$|   a- LHu'H
24 H
 =    ߕ 
  7  H+ LcI9$  LkM  H{HIE HHH)uHAP0HGLgH;.    A   LmHUL}HõHHu    O !  97  Im u
IEIP0LI/u
IGIP0H+u
I$HP0H
ϙ LH|$pzHHA  H\$ ;    ݔ G  M7  H;1. u]HOQ=   uJLmL}HAH uHOE3HUEAHHAՔ    w *  a6     O+ LHu'H
2 H
     = 1  56  LhE3Lx IHLL脳HHu^      7  5  I.IFIIHBHH       5  H@HH L   MtA* HHuғ    t I  y3  H/u
HGHP0A   HIE, HHu    1 L  5  H+u
HCHP0HQ؅yX     N  2  H/u
HGHP0O  IFIH L   MtA) HHuH\$      Y  5  Ld$(LH I' y    b [  g2  H/u
HGHP0L   A   L$8) HHuH\$ r     e  4  HX LI,' yB     g  1  H/u
HGHP0A   L$@) HHuH\$      q  
4  H! LI& yˑ    m s  r1  H/u
HGHP0A   L$H( HHuH\$     & }  3  H LI>& yT       0  H/u
HGHP0A   L$P(( HHuH\$ 
       3  H LI% yݐ       0  H/u
HGHP0L& IH % yH\$     6   2  A   ,LH\$ HHua       s2  H LH% y1    LЏ   L/  H/u
HGHP0A   q& HHu       1  H LH$ y    LZ   Lg/  H/u
HGHP0A   % HHuu       1  Hۓ LH/$ yE    L   L.  H/u
HGHP0A   % HHu       1  H} LH# yώ    Ln   L{.  H/u
HGHP0A   L$X$ HHu    )   0  HM LHA# yW    L   L.  H/u
HGHP0A   L$`E$ HHu       !0  HՑ LH" yߍ    L~   L-  H/u
HGHP0A   L$h# HHu    9   /  H LHQ" yg    L   L-  H/u
HGHP0A   # HHu!    Ì   3/  H LH! y    L   L,  H/u
HGHP0A  1# HHu    M   .  H	 LHe! y{    L    L',  H/u
HGHP0A  " HHu5    ׋ 
  G.  H# LH  y    L   L+  H/u
HGHP0H
% HHuH\$     _   -  A   M" LLHu    +   -  HG! LcI9$  L{M  H{HIHHH)uHAP0HGLgH;#    A   L}HULuHHHu     ,  ,  I/u
IGIP0LI.u
IFIP0H+u
I$HP0HGHH L   M   A  H;# u]HOQ=   uJL}LuHAH uHOE3HUEAHHZ;    ݉ 5  +       LHu     <  +  LxE3Lp IHLLHHu҉    t B  ^+  Im u
IEIP0LIH賦HH    + %  +  8  HHub     H  )  H/u
HGHP0H  LHL$(
 y      K  *  HLH\$0HHu
HCHP0H
9 HHu*H& LH ň    g W  t*  H@HHܒ L   MtAU HHu    ! Y  *  H+u
HCHP0A   HI  HHu<    އ \  '  H/u
HGHP0HYFy     ^  )  H+u
HCHP0   L   A$  M HHu*H% LH     E i  R)  HA LHL$ [ yq     k  (  H+  HCHP0  H
 aHHu*H% LHp        (  H@HH L   MtA HHuԆ    v   ](  H+u
HCHP0A   HIG HHu    3   ;&  H/u
HGHP0HDyZ       '  H+u
HCHP0tL   A$    HHu*H# LHS        '  H LHL$  oǅ    i   P'  H
 ОHHu*H# LHߋ     +   8'  H@HH L   MtA HHuC       &  H+u
HCHP0A   HI HHu        $  H/u
HGHP0HCy˄    m   T&  H+u
HCHP0L   H
 轝HHu*Hn" LH̊ v       %&  H@HH L   MtA HHu0    ҃   %  H+u
HCHP0A   HI HHu       #  H/u
HGHP0H
By    X   ?%  H+u
HCHP0L^	  H
 褜HHu'HU! H `       %  A$   MD LHu.    Ђ   "  H LgI9$  LwM  H_HIHHH)uHAP0HCLcH;}    A   LuHULmH赢HHu    A   L"  I.u
IFIP0LIm u
IEIP0H/u
I$HP0HCHHB L   M  A  H;; u]HKQ=   uJLu LmHAH uHKE3HU EAHHY߁       !     Y LHu    U   `!  LpE3Lh IHLL蜠HHuv       #!  I/u
IGIP0LIHXHH.    Ѐ       HHu    L 
  "  H+u
HCHP0H
r LH|$xHHu*H LH     P   ]"  H@HH L   MtA> HHuh    L      H/u
HGHP0A   HI HHu"    L   !  H+u
HCHP0H<>؅y    L     H/u
HGHP0  H\$ L HH ~ y*H{ LHم     % )  7!  Ld$(HL IHHu*H5 LH =    ~ 2     H Hj HHu    L~ 4    H/u
HGHP0Hǁ LI y~    Lh~ 7  R   H+u
HCHP0Lv  H
, 跗HHu*Hh LHƄ p~    ~ K     H@HH L   MtA  HHu*~    L} M    H+u
HCHP0A   HI HHu}    L} P    H/u
HGHP0H;y}    LI} R  3  H+u
HCHP0#  H\$ L HHn @ y*H= LH E}    | ]    Ld$(H I֕HHu*H LHU |    | f    H H, HHu|    Lm| h  W  H+u
HCHP0H LIu y|    L*| k  5  H/HGHP0L4  H
 uHHu*H& LH .|    {     H@HH~ L   MtA HHu{    L{     H/u
HGHP0A   HIX HHu{    LA{   +  H+u
HCHP0H9؅yh{    L{     H/u
HGHP0L
  H\$ LÅ HH)  y'H HY {    z     Ld$(H} I蔓HHu'H H z    bz   t  H~ H HHuz    1z   <  H/u
HGHP0HM} LI9 yOz    y     H+uHCHP0Ld$(H\$ IH} L   H HG y    y     H
G~ HHuH\$ y    ay     H@HH| L   MtAO HHuyy    y     H+u
HCHP0A   HI HHu6y    x     H/u
HGHP0HS7yx    x     H+u
HCHP00  IFIH} L   MtAw HHuH\$ x    >x     Ld$(LH~ IQ
 ygx    	x     H+u
HCHP0L   A   L$h4 HHuH\$ x    w   +  H{ LI yw    w   o  H+u
HCHP0A   L$` HHuH\$ w    Dw     H~ LI\ yrw    w     H+u
HCHP0A   L$XF HHuH\$ +w    v   =  H1~ LI yv    v     H+u
HCHP0A   L$P
 HHuH\$ v    Vv     Hz LIn yv    &v   
  H+u
HCHP0A   L$HX
 HHuH\$ =v    u   O  Hz LI
 y
v    u     H+u
HCHP0A   S HHuH\$ u    ju )    Hn LI
 yu    :u +    H+u
HCHP0A    1HHuH\$ Uu    t 5  g  Hw LI
 y%u    t 7    H+u
HCHP0A   L$@ HHuH\$ t    t A    HL| LI	 yt    Pt C  4  H+u
HCHP0A   
 HHuH\$ it    t M  {  Ho~ LI#	 y9t    s O    H+u
HCHP0H
y 2HHuH\$ s    s Y  	  A   M
 LHus    hs [  p  H	 LgLI9$  LoM  H_HIE HHH)uHAP0HCLcH;    A   LmHUL}HIHHu3s    r o    Im u
IEIP0LI/u
IGIP0H/u
I$HP0HCHHw H\$0L   M  A  H; u]HKQ=   uJLm L}(HAH uHKE3HU EAHHTnr    r x        LHuBr    q     LhE3Lx IHLL+HHur    q     I.IFIIHHHq    aq h  i  n HHuH\$ q    5q     Ld$(LHs IH y^q     q     H+u
HCHP0H\$ I$IMtI,$uID$IP0HtH+u
HCHP0HL$pHt
H)uHAP0HL$0Ht
H)uHAP0HD$xHtH(u
HPHR0HHX  A_A^A]A\_^[]H

u HHuH\$ p    'p     H@HHtx L   MtA HHu?p    o     H+u
HCHP0A   HI HHuo    o     H/u
HGHP0H.yo    go   K  H+u
HCHP0  IFIHt L   MtA= HHuH\$ bo    o   t  H|$(LHXu H y-o    n     H+u
HCHP0L   A$   L$8 HHuH\$ n    n     Hr LH yn    Pn   4  H+u
HCHP0A$   M HHuH\$ gn    	n   y  Hmq LH! y7n    m     H+u
HCHP0A$   )HHuH\$ m    m     Hr LH ym    em   I  H+u
HCHP0H
9p 輆HHuH\$ m    #m     A$   Me LLHuLm    l     H
 LgI9$  LM  H_HIHHH)uHAP0HCLcH;    A   L}0HU0Lu8HӌHHul    _l   j  I/u
IGIP0LI.u
IFIP0H/u
I$HP0HCLHaq HH\$0L   M   A  H;R u]HKQ=   uJL}@LuHHAH uHKE3HU@EAHHRk    k        p LHuk    lk   w  LxE3Lp IHLL賊HHuk    /k   :  Im u
IEIP0LIHnHHDk    j   
   HHu*H	 LHbq k    j )    Ld$(LHm I  yj    yj +  `  H+u
HCHP0H
Mm ЃHHu*H LHp j    +j 5  8  H@HHu L   MtA HHuCj    i 7    H+u
HCHP0A   HI HHu j    i :  	  H/u
HGHP0H(yi    ki <  R  H+u
HCHP0cH
7l 躂HHu*Hk LHo si    i I  "  H@HHJr L   MtA  HHu-i    h K  
  H+u
HCHP0A   HI HHuh    h N    H/u
HGHP0H'yh    Uh P  <
  H+u
HCHP0{  H        HHu*HL LHn Th    g [  
  Hl LI  y$h    g ]  	  H+u
HCHP0   k  HHu*H LH*n g    vg g  	  H*n LI  yg    Fg i  -	  H+u
HCHP0     HHu*HL LHm Tg    f s  	  Hk LI  y$g    f u    H+u
HCHP0   k  HHu*H LH*m f    vf     Hq LI  yf    Ff   -  H+u
HCHP0     HHu*HL LHl Tf    e     HZp LI  y$f    e     H+u
HCHP0   k  HHu*H LH*l e    ve     Hp LI  ye    Fe   -  H+u
HCHP0     HHu*HL LHk Te    d     Hl LI   e    d     H
g )~HHu*H LH8k d    d     H@HHn L   MtAr  HHud    >d   %  H+u
HCHP0A   HI  HHuYd    c     H/u
HGHP0Hv"y"d    c     H+u
HCHP0H      Z  HHu*H LHj c    ec   r  Hg LI}  yc    5c     H+u
HCHP0     HHu*H; LHi Cc    b     Hi LI  yc    b     H+u
HCHP0   Z  HHu*H  LHi b    eb   r  H	g LI}  yb    5b     H+u
HCHP0     HHu*H;  LHh Cb    a     Hl LI  yb    a     H+u
HCHP0   Z  HHu*H  LHh a    ea   r  Hk LI}  ya    5a     H+u
HCHP0     HHu*H;  LHg Ca    `     Hl LI  a    ` 	    H
ee zHHuH\$ `    ` '    H@HHd L   MtAm  HHu`    9` )    H+u
HCHP0A   HI
  HHuOT`    _ ,  LLH\$ H  H}f H  H/  HGHP0  H/u
HGHP0H;y_    _ .  m  H+u
HCHP0Ld$(|Lj IHe   yH\$ _    3_ 9    LW  IH]j G  yH\$ X_    ^ B  j  L   A$     HHuH\$ _    ^ K  -  H|$ LHi H  y^    ^ M  oH+u
HCHP0A$   .  HHu^    HG^ W     H;f LH_  yYu^    ^ Y  LLHB  Hd HtH+u
HCHP0H\$ MtjI/udIGIP0XH+u
HCHP0Ld$(HHa LI  ]    ] c  H  LHd MtIm u
IEIP0MtI.u
IFIP0D] H
I ;] n@Ld$(MHUATAUAVAWHhHP  HEHXHpHx H H3HEHL3HL$XHL$PHL$`HL$hHE@   HM8M(HE    HMMDDDH
[ HAH;  uE33|+H;  uHA@t	3zE3HG` {HHu'H{  Hb \ y   (\   _
  HHL$XLahA$AAD$AIL$HHu'H&  Hb 1\ }   [   

  LHL;
  t;MIL H H
p  H	  [ }   [   O	  HKH)uHAP0HsIL$ /HHu'H  Ha [ ~   =[   t	  LHL;
  t;MIL Hq H
  H	q  S[ ~   Z     HK H)uHAP0Hs AD$8C(3_  HHu'H  HQa Z    Z     H|$PI\$@I;\$H2  IE3D  HCH+HHHD$xHLT$@D$8  DT$0HD$(LT$ A   LD$xAQHqZ HH  H   HHHD$`Ht
H)uHAP0LLGHG HE3AL;AL9G tHHGJ4I@HGHI  tE3HI;\$H)NH  H1` Y    }Y c    H  H
` Y    VY W    3  HHu'Hr  H_ }Y    Y v  V  I\$XI;\$`   fHEH;tIE3HHM	H IE3HUHM(l	HE   LmDmIE3HU(HMH	H9  HD$(HM#(  HHteHVH9V ~H HNHHJHNHH  uH/u
HGHP0I;\$`A2X    3X     xX    X     Ht$hH
_ |qHHu'H-  H^ 8X    W     H@L   H` HMtA  LHu'H  H:^ W    W   h  H/u
HGHP0   N  HHu'H  H] W    <W   3  HHpHD$PH HG E3HH
G` zvLHu'H
;  H
] FW    V     H/u
HGHP03IvH  H9  I~H  I^HHILH)uHAP0HsHH;  u`H}L}A   HUHvHHu'H  H\ V    ?V   !  H/u
HGHP03?  H;|  uhHKQ=   uUH}L}HA t3HKE3EAHUHHuH
  Hk\ V    U          LHu'H
  H
1\ U    }U   _  Hx3Lx E3E3IHtHHu'H  H[ U    3U   *  Im uSIEIGII{rHHu'H<  H[ GU    T     I/u
IGIP0I.u	HIP0E3L|$XIO0H)uHAP0I_0I$  cHHu-H  H%[ T    qT   E3E3M  IO@H)uHAP0I_@A$  AGHI$  HMH
  HL$(H#  HHu-HE  HZ PT    S   E3E3  IOPH)uHAP0I_PI$  HHu-H  HOZ S    S   E3E3w  IOXH)uHAP0I_X3  HHu-H  HY S    IS   E3E3%  I$  I;$    HEH;tIE3HHMH IE3HUHM(HE   HE    E IE3HU(HMdHU  HD$(HM?"  LHt^HNH9N ~H HFL4HAHFIH  u#I.u
IFIP0I;$  :   SR   
GR   E3E3R    Hh  HX H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0MtI/u
IGIP0MtIm u
IEIP0DR Q H
( 43L|$XIO`H)uHAP0Iw`IIMtI/u
IGIP0HL$PHt
H)uHAP0HL$`Ht
H)uHAP0HL$hHtH)uHAP0LE IrIHU~HE    HE    E HM(QHHMHH3L$P  I[8Is@I{HIA_A^A]A\]@SH H  HH HI`H)uHAP0H}  HC`3H [@SH H[  HH HI`H)uHAP0H=  HC`3H [H\$WH LJHL;
  HtrH;  tiH
  L
 MIHI H	X  H!  HV ,P [   O m  m  H
z A[   2H\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH H  HH HIXH)uHAP0H  HCX3H [@SH H  HH HIXH)uHAP0H  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H  HH HIPH)uHAP0H  HCP3H [@SH H  HH HIPH)uHAP0Hm  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0H  H)t$ H9BurH  (f.5 zTuR  HtGH  HR L X   AL j  j  H
] AX   b/(t$ H0[sH3(t$ H0[KH(AH  Hu;H  HfR L X   K G  G  H
>
 AX   .3H(H(AHA  Hu;H  HR K X   RK G  G  H
	 AX   s.3H(@SH H  HH HI@H)uHAP0H  HC@3H [@SH H  HH HI@H)uHAP0H  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H  HH HI8H)uHAP0H  HC83H [@SH H  HH HI8H)uHAP0Hm  HC83H [H\$WH LJHL;
  HtrH;4  tiH
  LD MIH H	  HQ  HO \I V   H     H
 AV   ,H\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H;  HH HI0H)uHAP0H  HC03H [@SH H  HH HI0H)uHAP0H  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H;  H)t$ H9BurH  (f.5R zTuRx  HtGH  HeM G T   F     H
 AT   )(t$ H0[s(3(t$ H0[KH(A(  Hu;Hu  HL F T   "F     H
 AT   C)3H(H(A(  Hu;H  HvL  F T   E     H
~ AT   (3H(@SH H{  HH HI H)uHAP0H]  HC 3H [@SH H;  HH HI H)uHAP0H  HC 3H [H\$WH LJHL;
  HtrH;  tiH
  L   MIH  H	8  H  HbK E S   D     H
  AS   'H\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH H  HH HIH)uHAP0H  HC3H [@SH H  HH HIH)uHAP0H  HC3H [H\$WH LJHL;
`  HtrH;T  tiH
#  L   MIHi  H	  Hq  HI |C R   C     H
z  AR   ?&H\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;  AE3H;C  A3H;  DEuH  DEEtR  HtGHJ  HH UB Q   A 
  
  H
  AQ   %H\$0H _È_3H\$0H _;H(y tH  H H  H  H H  Hu;H  HH A Q   SA 
  
  H
  AQ   t$3H({H\$WH HH["؃uO  HtDH"  HG -A P   @ 
  
  DCQH
  #H\$0H _É_3H\$0H _kH(IL$0  Hu;H  HF @ P   @@ j
  j
  H
  AP   a#3H(H(IL$0_  Hu;H3  HF >@ P   ? j
  j
  H
|  AP   #3H(H\$Hl$Ht$WH H3H
  3HAH;  uE33_+H;  uHA@t	3]HJC E3^HHu'H{  HE ? q   (? 
  O  HCHHB L   MtA  HHu> 
     H  H9C  H{H  HsHHHHH)uHAP0HH	\HHuH
  H
+E > 
  QH/u
HGHP03H+u
HCHP0   :  HH   <> $
  Hm  HD x> q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HWHR0D!> H
  =  3cHZHH6=  
  XH
< HHHHh Hp(H
g  HH
]  HH0H
R  HH
H  HH8H\$0Hl$8Ht$@H _{@UAWH8HBE3H;  AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH;'  t[HHx  HHu'H  HZC = m   <     H@L   Mu^<   i  HIIMMu>HZ  H9GuH;w  H_HHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHI6VHHtFLHI7  tH+BHCHP03; n   ;      ; n   |;   k  H   H
\  LI;   HHD9   }      @t3HIHW  ug;   c; m   H@  HA HtH/u
HGHP0HtH+u
HCHP0D$; H
  :    H/u
HGHP0L=  ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Hl$ AVH H> E3H\$0E3HHt$8H
D: H|$@څHHu2H-  H$  H@ /: f   HE 9     HXHH
ZD H+> HAL   MtA  HHu'H  H"@ 9 h   n9    H  H  IH9C   H{H   HsHHHHH)uHAP0HHVHHu9 -  uH/u
HGHP0IH+u
HCHP0HHue  HHu]H  Hg? 9 i   8 ?  {HUHHu8 0  H  H)? 8 h   HtD2HHHubH  H> 8 i   F8 A  H+u
HCHP0HtH/u
HGHP0Dn8 H
[  
8 @&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Ypt3H A^A\_^[Hl$PLl$`L|$hMu*H  E3H= 7 i   ?7     \  LHu'H]  H= h7 i   
7   Z  IFHHHu-H
  L  H0 H	B  6     HAH;  tWH;  tNHS  HHuH
  H
5= 6   ~  H@L   Mual6   Q  H3E3H@ Mu>H<  H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA  HHtNH+u
HSHR0IVLI3  uH/HGHP0P5   5  A5   &  H

  L  H. H	  5        Ht H  HHz   D  H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$pNILl$`H A^A\_^[4   3HG  H: R4 i   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D3 H
m  3 H\$Hl$Ht$H|$ AVH HG7 HH
%3 E3
}HHuH&    H   H
1 HxHH5= L5; H-: h  HHtzHIH_HG3HGt GpHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`HGh[  H+u
HCHP0HG  H  H9 e2 2 i   Ai   H
&  H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtHa  HH [H [@SH HYhHtHia  HH [H [H(HB      tHAL   MtAa  Hu;Hu  H7 1 `   "1     H
n  A`   C3H({H   HD$ r  Ht
33@HĈ   H(HHHu  ȅx3H(@WH@HD$ H\$XH] H3HD$0HHL$(LL$xHAHyrH	HH;}HH33a  E3MtAL  HHQHHL$0H3H\$XH@_LAL9A ~HHAJI@HA3H%	  LYE3HA EHL;AL9Y AEtHHAJICHA3H%    HUHhH   HEHXHpHx H~ H3HEGHHM3uE   HE   Hu@uDFH  HMCHE   Hu@uDFH  HMHuHE   Hu@uIE3HUHM%HE7   Hu/@uIE3HUHM HUH   }HM襡HM蜡HEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  HHE   HuE HEHrPHHMH=   r<t  HAH;r  H+Hs  H'vx  HHE   HuE A   H  HMHE   HuE A   Hg  HME   E   HE   HuE IE3HUHMHE7   Hu/E IE3HUHMrHUH   A|HMHMHMHMHHMGH3KL$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+H'HCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;v  H    H=   r<t  HAH;r  H+Hs  H'vx  HH3HsHsHH\$@Ht$PH0_@SH Ho H;HH  ,HH6 HH, >HHTv  H# HHH  HH HH, HH*  H HHH  HH HHk+ HHH [H%ػ  H(HY  @HHH(H%  @UVWATAUAVAWH$H@  Hǅx  H$  Hx H3H8  LD$pHT$PHMH  L  ML  MLt$hHM*WD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
 [  H
 M  3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM3H]Mt`IrAfo` IHfHnflfHAfHnflfLHH;rI;s     HHI;rL%] L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH  H{ H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  "H H   L   L  L   L   HUH   ǓL   H   H   H   H   XE3AL}H   H   HMI+HL   H;vdM9s
HH;rbH  HD$x3HEHEH	 HD$XD$`HUHL$X  H HD$xH1 HL$x	H
 %  Hդ HE Lu(Le0HEH+HHE8HUHM@ŒLE0HU8HMXHU8H   bILuHU8H   HMI+HLE(H;vdM9s
HH;rbH  HD$x3HEHEH HD$XD$`HUHL$X#  H HD$xH0 HL$xH
 8  L%  LeHT$hHULmH  HEWD$PWM LmLD$PHM   NHHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  ;H H  HE(H  HE0H  HE8H  HU@H  H  HD$XL% L  HE`H   HEhH  HEpH  HUxH  ?H   H0  蛐H{ HH  H   HP  H   HX  H   H`  H   Hh  OH  HD$XL  H   H  H   H  H   H  H  H  莀H   H  H H@  HH  HD$XL%x LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX  Ld$xH  HEHE   LmE IE3H  HMhH  HD$(H  HD$ LH  L@  HT$xHHHU HtLEL+IhH   Ht%L   L+IHWf   L   HMXHU@HtLEPL+IWfE@LmPL% Le H   Ht%L0  L+IWf   L0  H    H   Ht%L   L+IWf   L   L   L- L  H  ޓL  L  L  H  轓L  MtLEM+II.HtH+HLHMtLEM+IIHH8  H3H$  H@  A_A^A]A\_^]@SH H: HD$0H+: H
: HH\$0H;sSH: HT$0H;wBH\$0H+HH;
: u   H
: kH
: Hu: Ht9HH)H;
p: u   H
R: 5H
N: Ht
HH
?: HP< HD$0H+<< HHH
: H
F: H\$0H;sSH-: HT$0H;wBH\$0H+HH;
 : u   H
: H
9 H9 Ht9HH)H;
9 u   H
9 H
9 Ht
HH
9 H; HD$0H+; HHH
9 H
; H\$0H;sSH: HT$0H;wBH\$0H+HH;
: u   H
: H
: H: Ht9HH)H;
: u   H
: H
: Ht
HH
: HHx9 H
y: H
9 Hn9 H
9 zHS9 H
9 H [yHXHu8 H9f8    HRH
58 H\$PxH|8 H
U: H-=8 HRxH-\8 Lm: H
9 IHT: H+HHYH;s>@ HHtH   L.: H: IHH+HH;rH
~9 HQ-wH-m9 H\$PHXHh  D$(HD$0HT$83HL$ HD$8HD$@H  HD$   H Hp+ HD$0HL$0HXH57 H9&7    H6 Lb9 HS9 H6 H9 H9 IH+H\$PH3Ht;     HHtH   L9 H8 IHH+HH;rH&7 H\$PH8 H?7     HH7 H>7 H HH)7 HXH-  D$(HD$0HT$83HL$ HD$8HD$@H  HD$   HD H5* HD$0HL$0|H\$WH H      ?HAH
5 H9
5 H5 u	H=5 HIHH+5 HHkHH<H;sfD  HKHHPH;wH\$0H _HI5 H+:5 H
[5 HH+AH95 H9*5 @WH H
C    HHu H
  H?  H	  H _HN  H\$0H(  H/Hu
HWHR0Hu%H
Y  H*  H	A  H\$0H _H,  H9Ct9H
װ  H  H	  H+  HCHP0H\$0H _3H
  H+H_ uHCHP0HL Hu%H
p  H  H	  H\$0H _=	  H tA	  H  %  
H s4  A
   H  H
  DH	  H\$0H _  u	H  t%H$  H
ů  H	  H\$0H _3H\$0H _3H%  H(Hu           H(HtIw  3H(3HtIv   "     "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[HHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHH6H\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=Ae      Hh)|$@)t$Pf( f( fYf(% f(
 f\v ff(fXf~Ё  fYf@  fY8 fff\L      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfX fX| fYfYfYfXfXT ffXfY(t$P(|$@Hhf     ??f\f(^ fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0L f(5 f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(: ffM ff(5! ff5$ fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5m ff5P  A~0  fA0  fff(5 ffffYf(t$P(|$@Hh     HH)|$ )t$0f( f( fYff(% f(
 fXf:	 f(f~Ё  fYf@  fYJ fff\L      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfX fX fYfYfYfXfXf ffXfY(t$0(|$ HHfff     ??f\f(n fsA~$ L f(5A f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(j ff} ff(5Q ff5T fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$0(|$ HH     %"  %  %  %x  %£  %t  %v  %x  %z  %|  %~  %  %  %  %.  ff     @UH HE t
e HMPH ]@UH HE t
e HMpH ]@UH HE t
e HMP躂H ]Hp  tHp  阂Hp  \Hp  适HH   hHp   8Hp  \Hp   Hp  DH`   H`   HH`   HH`   H(thH`   H@dH`   HXThHH   tdH@   DoHH   8oH(   餁@UH HE t
e HMHgH ]@UH HE t
e HMHcH ]H8   4v@UH HE te H   jH ]HP   HP  H`   DgH`   H4gH`   HH$gH`   H`gH`   HxgHP   tH@   dH`   THX   DH   @UH HE te HM`H   Ȟ  H ]H`   HH%   H`   HP  H@   H@  H   H   HH   H   HH0   H0   HP   H    H@   HH   H   (H   XH   LHP   @HP   4H@   (H@   H(   ~H(   ~H(   eHP  ~H0  HH0  l~H0  0H0  T~H0  H~H0   H0  0~H0  $~HP  ~H0  ~H0  H0  H0  }H0   H0  }H0  }H`   
HP   H	H`   	HP   H	H`   	Hh   	H`   H	Hh   	H`   H	Hh   |	H`   H0l	H(   }HH   |H(   |HH   |H`   $FHp   	H`   H@	H@  |@UH HE te HM@H   ,  H ]H@   H H%T  H0   H%  H@   H@  >|HT$UH HLE0H HMHL HHMhHMH{HEhH   HCEhH
a  HMH3HMPHMXHE0E8HUPHM0Ś  H HEHA   H HMHHH   {Hh   {{HH   鯽HT$UH HLE H HM8L HHMX HM8!{HEXH}pHCEXH
  HM83HM@HMHHE E(HU@HM   H) HE8A  HX HM8 H8   zHX   zH8   HT$UH HLE HP HM8_L7 HHMX HM8azHEXH}pHCEXH
Ԣ  HM83HM@HMHHE E(HU@HM 8  Hi HE8A  H HM8 H8   yHX   yH8   "Hp   yHP   HT$SUH(HHMHHHPHH;uHAH HHEHLE0I H H   OL HHMPLHHMpHMPAyH   4yHEpH   HCEpH
  HMP3HMXHM`H   ƅ   HUXH     H0 HEPA@  H' HMPH   xHP   xHp   xHP   ݺH   dH   H$H   HDH   H(^H   H@ZH   HX^H   XYH   ^Hh   ZH8   aH   wH   \^Hh   P^H8   aH   wH0   H(   H(   HP   \H   @UH HE0te0H   H ]H   ?wH   3wH   'wH`   ]H   wHT$SUH8HHǅ      Hǅ       ƅ    A4   H׽ H   ۲H]8HH   HP@H   vHǅ      Hǅ       ƅ    A   H H   胲HH   HP@H   UvH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   uHg  HEH3HEPHEXH HE8E@HUPHM8Ĕ  Hu HEHH HMH迸H   uH   uH   tu@UH HE0te0H   H ]H   ;uH   /uH   #uHH   [H   uHx   o[HT$SUH8HHǅ      Hǅ       ƅ    A*   HO H   ˰H]8HH   HP@H   tHǅ      Hǅ       ƅ    A   H H   sHH   HP@H   EtH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   sHW  HE`3HEhHEpH
 HE8E@HUhHM8  He HE`H HM`诶H   |sH   psH   dsHT$UH0HHǅ      HEx    Eh A/   H HMh6HM0HHUhP@HMh
sH  HEH3HEPHEXHA HE0E8HUPHM0  H HEHH HMHHh   rHT$UH HHEh   HE`    EP A/   HZ HMP艮HM HHUPP@HMP`rH  HE03HE8HE@H HE E(HU8HM >  H HE0H, HM09HP   rH(   qHP  qH0  qH0  qH0  qH0  qH0  qHP  qHP  qHP  qH0  HH0  <H0   0HP  TqH`   4tH   :H   xH   H@hH0  qH0   H0  pH(   pH(   pH(   pH(   pH(   pH(   pH(   pHP   DH   H   H   HP   HX   xH`   dH`   HTH@   DH@   8H    ,H     H   Hx   xcHH   DH@   HP   $H   H   H0   H0   H    H    H  tHH   鴴H@   XH8   LHX   頵HP   H0   H    H0   HH0   H8\H0   HpH0   H   ٸH    mH@   THH   HH@   4H@   H THH   H@   H8@UH HE$t
e$HMPJH ]H   mHX   HX   H@   鄾H    JH`  mH@  mH@  mH@  xmH@  lmH@  `mH@   锯H@   tH@   H0SH@   HHSH@   H`SH@   H   qSH@   H   VH@   H   +H@   H   8SH@   H   %SH@   H   RVHp   4OHX   RH  |lH  plH   dlH0   RH  LlH  @lH   4lH  (lH0   RH  lH  lH   kH  kH0   PRH  kH  kH   kH  kH0   RH  kH  kH   kH  tkH0   QH  \kH  PkH   DkH  8kH0   QH   kH  kH   kH  jH0   `QH  jH  jH   jH  jH0   $QH0   QH  jH  jH   jH  xjH0   PH  H  TjH  HjH   <jH  0jH0   PH  jH  jH    jH  iH0   XPH  iH  iH   iH  iH0   PH  iH  iH   iH  |iH0   OH  diH   OH  RHT$UH0HH   L H   =H   H`   tOH`   <HH   \OH@  KH0  hH  hH  hHP  hH  hH0  OHT$UH0HHǅ(     Hǅ       ƅ   A   Hq H  eH8  HPLH  H  HH  葫H H  4H  hH  gH  gH  gH  gHP  gH  gH0  NHT$UH0HHǅ(     Hǅ       ƅ   A   H H  zH0  HPLH  H  HH  親H H  IH  gH  
gH  fH  fH  fHP  fH  fH0  2MH0  &MHT$UH0HHǅ(     Hǅ       ƅ   A#   H H  胢H  HPLH  H  HHX  诩H HX  RH  fH  fH  fH  eH  eHP  eH  eH  ;LHT$UH0HHǅ       Hǅ(      E33H  A'   Hb H  莡H(  HPLH  H  HH  躨H H  ]H  *eH  eH  eH  eHP  dH  dH  dH  FKH  :KHT$UH0HHǅ       Hǅ(      E33H  A"   H H  荠H   HPLH  H  HHp  蹧H Hp  \H  )dH  dH(   dH(   cH(   cH(   cH(   cH(   cH(   cH(   cH(   cH    dHH  cH(  |cHh  pcH(  dcH  XcH(  LcH  @cH(  4cH(  (cH(  cH(  cH(  cH(  bH(  bH(  bH(  bH(  bH(  bH0   tHP  bH0  bHp  bH0  tbH  hbH0  \bH  PbH0  DbH0  8bH0  ,bH@   HHH@   H pHH@   H@KH@   HXVH@   HaH@   H(p@UH HE t
e HMHVH ]HT$UH0HHM8HPH
  HMh3HMpHMxHE@EHHUpHM@^  H} HEhH HMhYH   GHP   GH   ܱH   aH8   C@UH HE4te4H   AGH ]H   $GHH   GH   lH  `H0   $CHh   F@UH HE@t
e@HMxFH ]H   H  2`HH   BH`   H8   B@UH HE0te0H   UFH ]H`   锸H`   Hp4H`   H  TH`   H  n?H`   H  {TH`   H  H?H`   H  EH`   H  AH`   H0  /TH@   TH    THH   ^@UH HHU@HMHʡH ]@UH HHU@HMH计H ]HT$SUH8HH]PHHtJHS=#HKH+H*HHLI?LH{H    HC    HC    33iHT$SUH8HH]PHHtJHS(HKH+H*HHLI?LHC{H    HC    HC    33HT$SUH8HH]PHHt3HSm$HLCL+IڋH    HC    HC    33蠠HT$SUH8HH]PHHt3HS
$HLCL+IzH    HC    HC    33@H`   ]@UH HEhtehHMPH   {  H ]HP   H H%z  HX   H%Z{  @UH HEPtePHM@H   8{  H ]H@   H H%`z  @UH HEPtePHM@H   z  H ]H@   HH%Pz  H8   >HT$SUH8HH]PHHtJHS HKH+H*HHLI?LH#yH    HC    HC    33ٞHP   锽HP   H DEH(   AHT$SUH8HH]`HHtJHS]%HKH+H*HHLI?LHxH    HC    HC    339H@   [H(   H@   H%y  HT$UH HHUhHUhHsHExH{H ]HT$SUH(HH]`HCHr\HHHv{  H=   r<t{  HAH;rz  H+Hsz  H'vz  H	HC   HC    H{rH 339H(   H(   HT$UH HHUpHHcHHA   wv  HH ]H(   DH(   阎HT$UH HHUpHHcHHA   'v  HH ]H(   H(   HHT$UH HHUpHHcHHA   u  H{H ]H@   $H0  YHh   DH`   8Hh   ,H`   HHh   H`   H( H(   4H(   8pHT$UH HHUPHHcHHA   u  HiH ]H(   锚@UH HE t
e HM@0XH ]H   NH   NH   DH8   4HP   G@UH HE0te0HMPH   Xv  H ]HP   H H%u  H@   H%*v  HP   FHP  jWHT$UH0HHjH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH
H0]HT$UH0HH*H0]HT$UH0HHJH0]HT$UH0HHjH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]H  $<Hp   X?HP   <H  HH  $8@UH HEDteDH  H   	t  H ]H  H H%1s  Hh   H%s  H  H  U@UH HEDteDH  H   s  H ]H  H H%r  Hh   H%rs  H  鎥H  T@UH HEDteDH   H   7s  H ]H   H H%_r  Hh   H%	s  H   %H  ITHT$UH@HH  萱LU@H   =H  H  DH   CH  CH  CH0  餤HP  SH  鬵H  H  F@UH Hp   H  bH ]H8  xHH  霗H   PH   9HP  xH   9HP  0HHh  $HH   SH   SH   SH   d9Hp  X9HP  RH  RH0  RH0  鈣Hp  RH0  P<Hp  GH  RHp  ,<H0  8HP  8H8   8H   8HT$UH0H33SH8   8H   HT$UH0Hv33H8   D8H   鸔HT$UH0H633ӔH8   8H   xHT$UH0H33蓔H`   锓H`   鈓H   7H`   pH`   dH   7H`   LH  p7H`   d7H   X7H   L7Hx   @7H(  47H(  (7HT$UH`HHP  L HH  詰HP  @UH HE t
e HM0PEH ]H8   >PHH   9@UH HE te H   /H ]H0   2H0   2@UH HH   H   跒H ]@UH HH   H   蕒H ]H`   H%l  HP   H%l  @UH HEPtePHM@HP\H ]@UH Hꋅ   t   HM(HP&H ]@UH HX   HM@цH ]HT$SUH8HH]PHHtJHSHKH+H*HHLI?LHkH    HC    HC    33詑@UH H0   H   >H ]@UH Hꋅ   t   HM(k  H ]H   H%k  @UH HEHteHHM@H   l  H ]H@   H H%k  HP   H%zl  H8   @UH HEPtePHM@HP謧H ]H@   FHT$SUH(HH] HKm  HK m  HK(m  33mHT$SUH8HHU0HM8LE@HU8X{335H@   H@  LH0  H   L@UH HE@te@HM`H   Xk  H ]H`   HH%j  HH   H%*k  H`   H`  jL@UH HE@te@HP  H   j  H ]HP  HH%Gj  HH   H%j  HP  H@  LHP   DH   d@UH HE te HM0HPХH ]H0   .H8  "9H0  9H0   J7H
[ J}@UH HX   H@  <H ]@UH HE te H@  HPGH ]H   H鑦H   t@UH HE te HM0HP H ]H0   >H8  R8H0  F8H0   *7H
 z|@UH HX   H@  lH ]@UH HE te H@  HPwH ]H   HH@   ,H0   *@UH HE te HM`H   h  H ]H`   H H%g  HP   H%h  H`   骚H`  IH`   T,HH   0H   IHP   $,@UH HE@te@H   /H ]H   +Hx   /H  HT$SUHHHHǅ     Hǅ      ƅ   E3Hr  H  H   HH  HP H  HHǅ     Hǅ      ƅ   An   H\  H  蠄HH  HP H  rHH   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  1HH  HP H  HHǅ     Hǅ      ƅ   A   H	  H  ݃HH  HP H  GHǅ     Hǅ      ƅ   Ah   HE  H  艃HH  HP H  [G E@H~HH][H  3GH  'GH  GH  GH  GH  ǗHH   ;H  FH  C-H  闗H   鋗H  -H  sH   4)H`   ,H  LH  p6H  H(  6H   H  e3H  	H@   -;H  !FH   ,H  ٖH  EH  H  EH  I,H  靖H  1,H  酖H  EH  EH  EH  EH   (H`   +H  ,H  P6H  HH  5H   H  u2H  H@   
:H  EH   e+H  鹕H  DH  顕H  DH  )+H  }H  +H  eH  DH  }DH  qDH  eDH  &H   *H  |H   H   tH   Hx   9H   ĜH   鴜HP  t&Hp   8*H   H   01H  D&Hp   *H   H   QHP  &Hp   )H   H    1H  %Hp   )H   lH   `JH   %H   x)HX   7H   BHx   4Hx   (H8  鴅H8  騅HH  )H   )H8  鄅Hx   (H   (H  (H   (H   (H   (H   (H  H   (BH  H   BH  ԒH   AH  鼒H   AHT$UH`HH  'L% H  ѡH  DH@  鄄H@  xHH  'H   'Hp   'H   'H  'H   'H   'H   'H   'H  H   AH  ȑH   @H  鰑H   @H  阑H   @HT$UH`HH  L H  譠H   HP   &Hh   &@UH HEDteDH  H   ^  H ]H  H H%^  HH   H%^  H  ېH   ?@UH HEDteDH  H   ^  H ]H  H H%]  HH   H%V^  H  rH  ?@UH HEDteDH  H   ^  H ]H  H H%C]  HH   H%]  H  	H  -?@UH HEDteDH   H   ]  H ]H   H H%\  HH   H%]  H   頏H  >HT$UH@HH  LU@H   踞H  +H@   $HX   $H   $HT$UH@HH   裛L  H   MH   HT$UH HHU HMP33#HT$UH HHU HMP33@UH HHUPHMX蚀H ]HT$UH HHUPHMh33觀@UH HE0te0HM@H   \  H ]H@   HH%`[  H@   DH0  (=H   5H   5H  <Hx   fH  <H  頍H  <H`   (#H  LH@   #@UH HE\te\H   H   %[  H ]H   H H%MZ  H  H%Z  H   H  7<H  H  H  <H(   <H(   ;H(   ;Hp   $H   H(   ;H(   ;H(   ;H(   ;H(   ;H   H  H0  H  H   H   H   |Hx   pHh   dHh   XH   DH   8@UH HE te H   m$H ]H   DdH   8dH   |HX   PH  t:H  h:H8  cH  cH@   H  cH  cH@   pH  c@UH HEPtePH  H   X  H ]H  H H%W  HH   H%kX  H  释H   H8  9H8  9H8  9H8  {9H  d9HT$UH@HL
p H) $H   bH   bH  9H  9@UH HEHteHHP  H   W  H ]HP  HH%V  Hh   H%jW  HP  H  8@UH HEHteHHP  H   /W  H ]HP  HH%V  Hh   H%W  HP  ]H  A8HT$UH@HH   xkHߏH@]H  aH   aHP   EH  aH  }aHP   !H   eaHT$UH@H    HH@]H  ^H  7H  FH  j7H   `H   `H   `H   lyHX   H0  7H0  7H`  `H0  `H@   4H0  x`H0  l`H@   H0  T`@UH HEPtePH`  H   9U  H ]H`  H H%aT  HH   H%U  H`  'H0  H`  ?6H`  36H`  '6H`  6H  6HT$UH@HL
 Hə H   w_H   k_H  5H  5@UH HEHteHH`  H   8T  H ]H`  HH%S  H`   H%
T  H`  fH  J5@UH HEHteHH`  H   S  H ]H`  HH%'S  H`   H%S  H`  H  4HT$UH@HH   MH\H@]H  M^H0  A^HP   H  )^H  ^H0  ^HT$UH@H    HH@]H  
H  .4H  H  4H0  ]HT$UH0HL   HU8#H      H   HH(HH0]H0   鄄H0  3H  H  ؿH  ̿H  H0  H   騿H   霿H   鐿HT$UH HL   H   33=vH@   HPH@   H@H@   H(0H@   H8 H@   HHH@   HX H@   H   2H   HH   HX   $&H0   餾HH   阾HH   錾@UH HEPtePHM@HPH ]H@   Z@UH HEPtePHM@HP܋H ]H@   :@UH HEPtePHM@HP蜋H ]H@   (HT$UH0HHMP033wtH@   锽H@   鈽@UH HE0te0H   H   O  H ]H   H H%N  Hh   H%O  H   髁HT$UH0HM8M8LEXIA;|'H HD$ L
 H H
H >HH0]H@   ļH@   鸼@UH HE0te0H   H   N  H ]H   H H%N  Hh   H%N  H   ۀHT$UH0HM8M8LEXIA;|'H" HD$ L
 H H
x C=H[H0]HT$SUH8HH   H{  t'HM8HPHHK HHdM  HH8][Hh   锻H`   鈻Hh   |H`   H lHh   `H`   H0PH   H   H@   HHX   lHX   `@UH HHU0HM8qH ]@UH HH   HM8{qH ]@UH HE4te4H   H ]H   Hx   ?#H   #H  w@UH HE4te4H   H   L  H ]H   H H%K  HX   H%~L  H   ~HT$SUH8HH  H   i:Hx H  -H]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  7iHH  HP H  	-33&pH  ,@UH HE4te4H   H   xK  H ]H   H H%J  HX   H%JK  H   f}HT$SUH8HH  H   59Hx H  a,H]8tHH   HPHǅ     Hǅ      ƅ   A   HW  H  #hHH  HP H  +Hǅ     Hǅ      ƅ   A<   H#  H  gHH  HP H  +H  HHPHmH;uHAHtk HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  :gHH  HP H  +H4H8][H  *H  *H  *HT$SUH8HH  H   w7Hx H  *H]8tHH   HPHǅ     Hǅ      ƅ   AH   HQ  H  efHH  HP H  7*H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  eHH  HP H  )33lH  )H  )H  )H  )H  )H  FzH  HT$SUH8HH  H  	6Hx H  5)H]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  dHH  HP H  (33kH  (H  (H  {(H  o(H  c(H  'yH  yH  ?(H  3(H  '(H  (H  xH  (H  xHH   XH  'H  @H  'H  xH  'H  'H  'H  XxH  |'@UH HEDteDH   H   F  H ]H   H H%)E  H   H%E  H   wH   'H   t
Hp   8iHp   ,iH   P
Hp   iHp   8
H   ,
H   
H   
H   
H8  H8  HT$UH`HHh  ǃLŻ H`  qHh  H@   H   HX   lHX   `H0   TH0   HHp   \HT$UH0H'    H/H0]H(   H   H(   H@   @UH HꋅH  tH  HM@H   D  H ]H@   H H%*C  H0   H%C  H@   uH@  Hx  H   hHp   <HT$UHpHH:Hp]H   H   H   DH   Hx   ܰHT$UHpHH?Hp]H   H   鹵H   Hx  H   
Hp   lHT$UHpHHCHp]H   5H   驵H   tH   8
Hx   HT$UHpHHHHp]H   H   IH   =Hp   鴯Hp   騯H   H   @HT$SUHxHHǅH     Hǅ@      ƅ0   A!   HP  H0  _H   HH0  HP H0  "H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  ^HH0  HP H0  h"HPHx][H0  L"H0  @"Hx   鄮Hx   xH   Hh  H   hHp   <HT$UHpHHSTHp]H   H   ٳH   DH   Hx   ܭHT$UHpHHYHp]H   H   yH   =Hx  H   Hp   lHT$UHpHH]Hp]H   5H   iH   tH   8Hx   HT$UHpHHbHp]H   H   	H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  <\H   HH0  HP H0   H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  [HH0  HP H0  HfHx][H0  |H0  pHx   鴫Hx   騫H   H8   $bH`   HH   @UH HE0te0H  H   =  H ]H  H H%<  H@   H%s=  H  oHP  @UH HE0te0H  H   8=  H ]H  H H%`<  H@   H%
=  H  &oH0  J@UH HE0te0H  H   <  H ]H  H H%;  H@   H%<  H  nH  @UH HE0te0H   H   f<  H ]H   H H%;  H@   H%8<  H   TnH  xHT$UH0HH  zLU8H   l}H  ߌH  `H@   HX   |H   pHT$UH@HH   GzL  H   |H   dHX   $H@   @UH HE4te4H  H   -;  H ]H  H H%U:  H8   H%:  H  mH  ?@UH HE4te4H  H   :  H ]H  H H%9  H8   H%:  H  lH  @UH HE4te4H  H   [:  H ]H  H H%9  H8   H%-:  H  IlH  m@UH HE4te4H  H   9  H ]H  H H%9  H8   H%9  H  kH  @UH HE4 te4H   H   9  H ]H   H H%8  H8   H%[9  H   wkH  HT$UH0HH  wLU0HMxzH  H   餦H0   kHT$SUH(HH0  HM0&HXH0  HtHM HHU0P33 ]H   4H   (H8   H8   H   H   H  H  H   ԥH   ȥH  <jHT$UH0Hꋍ      P  ;|.U4Hx HD$ L
< LE4H	 H
z &H2H0]H(   dH@   H   $H   HX   HX    Hp   Hp   H   ܤH   ФH   ĤH   鸤H@  ,iHT$UH0Hꋍ        ;|.U4Hh~ HD$ L
,~ LE4H} H
 %HH0]H   @UH HHEXD HUPHM(ZH ]@UH HEPtePHM@H`qH ]H@   HpH    t[H8   X@UH HE t
e HMXH ]H@   dH   TH   DH(   4H(   (HH   H   @UH Hꋅ   t   HM(H`pH ]@UH Hh   HM@ANH ]@UH HEPtePHM@HPLpH ]H@   :H8   dH8   XH(   LH`   4H  $H  H  H   H0  H   H   ܡH   С@UH HEPtePHM@H`loH ]H@   :H   4H  (H8  HX  H0   DWH   H   H  H0   WH   
H(   H(   HP  t]HP  H	HP  H $HP  H8HP  HPH@   H	HX   H   H   Hp   XVHp   LVH   pHp   4VHp   XH   LH  @H   4H   (H8  H8  HT$UH`HHh  pL H`  sHh  HP   H8   H@   H`   xH   cHT$SUHHHH  H   Hx H  H]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  NHKHH  P H  XHHQHH][H  <HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  MH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  MHH0  HP H0  XHUHx][H0  <H0  0Hx   tHx   hH   |HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  LH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  VLHH0  HP H0  (HsYHx][H0  H0   Hx   DHx   8H   LHT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  KH   HH0  HP H0  gH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  &KHH0  HP H0  HS]Hx][H0  H0  Hx   Hx   H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  lJH   HH0  HP H0  7H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  IHH0  HP H0  
H3aHx][H0  
H0  
Hx   Hx   ؙH   HT$SUH8HH]PHHtJHSMHKH+H*HHLI?LHs*H    HC    HC    33)PHT$SUH8HH]PHHt3HSHLCL+I
;H    HC    HC    33OH8   OHh   H@   @UH HE0te0H  H   +  H ]H  H H%)*  H`   H%*  H  \H0  @UH HE0te0H  H   *  H ]H  H H%)  H`   H%j*  H  \H  @UH HE0te0H  H   /*  H ]H  H H%W)  H`   H%*  H  \H  A@UH HE0te0H  H   )  H ]H  H H%(  H`   H%)  H  [H  
@UH HE0 te0H   H   ])  H ]H   H H%(  H   H%/)  H   K[H  o
HT$UH0HH  gLU8H   cjH  yH0   MH@   hH   LH`   HHH   \H@   LHP   ؙ@UH HHU`HMPLH ]HT$UH HHU`HMh:33L@UH HHU`HMPZLH ]HT$UH HHU`HMhJ33gLHT$SUWH0HH   HO@HO 	H@33-L@UH HHUXHMPKH ]HT$UH HHMh@33KHT$SUWH0HH   HO@HO H`@33K@UH HHU`HMPZKH ]HT$UH HHU`HMh
33gK@UH HHUHHMPKH ]HT$UH HHM@?33+K@UH HHUHHMPJH ]HT$UH HHM@?33JH(   H(   H   JHT$UH Hv33JH   锗H0   H%&  HT$UH HHH ]@UH HHUPHMXJH ]HT$UH HHUPHMh33'JH`   dHH   XHx   |HX   HP   H@   tWH0   HH   dH   dHT$UH HHMHHt
H   33mIHT$UH HHMHHt
H   33=IHh   tHP   hHT$SUWH0HH   HO@qHO H=33HHT$SUWH0HH   HO@HO HP=33H@UH HHE(D HUxHM0BHH ]HT$SUWH HH]pH   H;t-Hf     HK$  H$  H[(HCH;u33HH  	@UH HEPtePHM@HP^H ]H@   @UH HEPtePHM@HP^H ]H@   jH   tH   锐H   H鄐H8   HP   Hh   @UH HEPtePHM@HP]H ]H@   dHH   H   HH@   HH   (H@   tHH   @UH HEPtePHM@HPL]H ]H@   aH   H  H8  HX  H0   $EH   (cH   Hh  H@   tH8   H   ԎH(   Hh   鴎Hh   騎H   @UHH3Ɂ8  ]@UH HM@H ]69@UH H_7M8H ]9@UH0HHHL$(T$ L
9LEpUhHM`6H0]HH   @UH HE te H   qH ]H0   H`   H0   @UH HE te H   H ]H    2@UH HE8t
e8HMXH ]H`    H    @UH HE te H   qH ]HX   _H@   #H   H0   ;@UH HE te H   H ]@UH HE te H   _H ]HX   H@   H   H0   @UH HE te H   fH ]H0   T@UH HE te H   1H ]@UH HE t
e HM@H ]HP   H   }Hx   qHP   eH   YHx   MH(   !H@   H(   	H@   HP   H   Hx   HP   H   Hx   HP   H   Hx   HH   H0   Hp   H@   H    UH   iHp   H0   XH    %XH   Hh   HP   HT$UH@HYH(  HI     B=  HsH@]H   CH   7Hp   +HX   HT$UH H]YHv(  Hא    # r6  HH ]HX   H@   HT$UH HYH(  H} '   ɉ 5  H
H ]H0   VH    V@UH HH  H  4H ]HT$UH HXH'  H    O o%  HL^H ]HH   =VH8   aVH   u@UH H  H   34H ]HT$UH HXH'  H} ' y  Ɉ "  HsH ]@UH H(  H   3H ]HT$UH HWH&  H ň z  g "  HgsH ]@UH HH  HM r3H ]HT$UH HBWH[&  H f    #  HaqH ]HT$UH H WH&  Hz $   Ƈ '$  HpH ]H8   T@UH HEPtePH   TH ]H   oH   H8   gT@UH HEPtePH   DTH ]H   H   vHP   TH@   >TH   RH(  FH  :HT$UH HHM(HPHH
  H	p  HUH ]HT$UH HHM0HPHH
P  H	7  HUH ]HT$UH HHM8HPHH
  H	  H}UH ]HT$UH HHM@HHPH;H;uHAHX9 HHEHH
{  H	  H!UH ]HT$UH HHMHHHPHt;H;uHAH8 HHEHH
  H	F  HTH ]HT$UH HHMPHPHH
  H	
  HTH ]HT$UH HHMXHHPLw
 I;uHAHg8 HHEHH
  H	  H0TH ]HT$UH HHM`HHPH:H;uHAH8 HHEHH
  H	U  HSH ]HT$UH HHMhHHPL I;uHAH7 HHEHH
  H	  HxSH ]HT$UH HHMpHHPLs I;uHAHS7 HHEHH
F  H	  HSH ]HT$UH HHMxHPHH
%  H	d  HRH ]HT$UH HH9  H
  H	1  HRH ]H(   @UH HE t
e HM06fH ]HX   H8   xH   HhH   \VH8   PHX   DH   H4H   (VHH   H   H8   tH   hH  WH  XH  WHp   WH  l<H  WH  H H  H8BH  HpH  ?H   XWH   H H   H88BH   HpH   |?H   WH   :@UH H꺸  HMP,H ]Hp   VHp   :H   VH   H 3HX   VH   H8AH   >Hh   VHh   H HX   cVHh   H8SAHh   >H0   ;VHX   /VH0   :H  VH(H=| r_H
[ 6Hg HH=   r<t  HAH;rq  H+Hsa  H'vT  H+H    H       H(}6H(H=| r_H
[ V6Hg HH=   r<t  HAH;r  H+Hs  H'v  H*H    H       H(5H(H=| r_H
[ 5Hg HH=   r<tA  HAH;r1  H+Hs!  H'v  HC*H    H       H(=5H(H= r_H
 5H HH=   r<t  HAH;r  H+Hs  H'vt  H)HP    H=     &  H(4H(H= r_H
 v4H HH=   r<t  HAH;r  H+Hs  H'v  H)HP    H=     &  H(3H(H=L~ r_H
+~ 3H7~ HH=   r<ta  HAH;rQ  H+HsA  H'v4  Hc(H}    H}     }  H(]3H
 KH
I KH(H=  t:33L H L+I WH     h H(H(H=̗  t:22Lɗ H L+IN WH      H(H(H=L  t:}2x2LI H2 L+IWH(      H(bH(H=4  t:22L1 H L+IWH      H(H(H=  t:11L H L+INWH     x H(H(H=,  t:}1x1L) H L+IWH      H(H
9 IH
 IH(H   H_s RH
Ss HuH(                                                                                                                                                                                                                                                                                                                                                                                                                                         D     j                         ̤     ܤ                    0     D     `     ~               ¥     ֥                    6     R     R                       J          
     N          ؘ                    p     .               F          ֓               h               ڑ          :     ^                    Ғ          4     ̗     D               Σ          z     T     6          ڢ               l     F     
     ȡ          D               t     ,               l          ޞ          H                |     6               j     *               |     (     Ԛ     h               N          f                                 Ȧ     ڦ                     8     B     X                    v                               Ȩ     Ҩ     H                  §               Ϊ     ֪     ܪ                                   ƪ                            |     d     H     ,     
          ި     ܧ                             d          P     4     *     x               ԧ                  Z          n     ʧ                  >                       r     V     B     ,                    ܍     ƍ                    ^     L     >     ,                    ތ     Ό                         r     d     P     B     ,                    ڋ                         h     T     :     $                     ފ     Ί                              ^     P     @                         ։                         t     \     F     8           
               Ј                    x     h     N     :     *                    ڇ                    |     h     N     6                                Ȇ     ʎ          $     6          F     b     t                              Ώ     2     z                          4     H     ^     J     \     r                    Ȑ     ؐ                    $     B     <     ܎     v     *                    څ                    x     ^     J     :     &                            P     Q           H         `             @    `                        0            P                      `                                                           0                                                                               "   3            p5            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        P
   @           @Z   Z   X
           
           ȥ
   8       bad array new length    
      h
      P    P       P    H
   `@   `    
   T     U    warning OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np     H   @   P   ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  ImportError 1   __getstate__.<locals>.genexpr   reshape num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info misc    __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  1   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    pystan._compat  iter_save_wo_warmup     Stan model {} is of mode 'test_grad';
sampling is not conducted.    upar        data sim model_name model_pars par_dims mode inits stan_args stanmodel date get adapt_window    p   init_alpha  get stan_args_method_t  b   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  B   warmup2 __str__ traceplot   shape   UNIT_E  h   int_time    range   method  H   pystan.plots    _summary    NUTS    lp__    array   fitptr  i   (dense_e)   append  I   stansummary l   AttributeError  gradient    order   pystan  L   sampling_algo_t pars    data_args   DIAG_E  q   ndarray is not C contiguous Q   adapt_t0    error   unit_e  f   pars_oi_bytes   epsilon adapt_iter  d   handler tol_rel_obj user    probs   vars_i  g   warnings    index   chains  Zf  __import__  Zd  collections Zg  stepsize    split   metric  O   extract (diag_e)    OPTIM   holder  par grad_samples    _get_kept_samples   dstack  sim _pars_total_indexes s   chain_id    utf-8   format  s   ndarray is not Fortran contiguous   double  end model_code  end TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   chains  '   Couldn't allocate space for StanHolder. _verify_has_samples name    LBFGS   'char'  s   Metropolis  s   output_samples  dims_oi samples pystan.constants    flush   'long'  %s  _check_pars int string_types    _remove_empty_pars  =   _call_sampler_star  #   adapt_kappa keys    send    throw   =   row_stack   #   SAMPLING    start   =   MemoryError #   squeeze seed    variational =   init_list   #   save_iterations `inc_warmup` ignored when `permuted` is True.   data    
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          =   tol_rel_grad    BFGS    init_radius #   __test__    tuple   =   `dtypes` ignored when `permuted` is False.  #   sampling    inits   =   adjust_transform    value   #   _split_data =   RuntimeError    __getstate__    VARIATIONAL #   genexpr Format string allocated too short, see comment in numpy.pxd =   elbo_samples    variational_algo_t  #   tol_param   thin    inits   =   DENSE_E refresh adapt_term_buffer       Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. #   newaxis flatnames   flat    dtype   =   getLogger   #   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330 Couldn't allocate space for stan_fit.   init    sampler_params  pystan.misc warn    numpy   =   numpy.core.multiarray failed to import  digits_summary  column_stack    adapt_delta #   stepsize_jitter fnames_oi   =   sampler_t   #   control random_seed =   numpy.core.umath failed to import   #   handlers    numpy   =   (unit_e)    numpy   #   logging adapt_init_buffer   =   Non-native byte order not supported #   diagnostic_file argsptr adapt_engaged   C:\Users\appveyor\AppData\Local\Temp\1\tmpa5wan1it\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.pyx  adapt_gamma =   history_size    _call_sampler   numpy.core.multiarray   numpy.core.multiarray failed to import  _ARRAY_API  #   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  =   _ARRAY_API is NULL pointer      module compiled against ABI version 0x%x but this version of numpy is 0x%x      module compiled against API version 0x%x but this version of numpy is 0x%x  #   FATAL: module compiled as unknown endian        FATAL: module compiled as little endian, but detected different endianness at runtime   numpy.core.umath    numpy   =   numpy.core.umath failed to import   #   _UFUNC_API  =   _UFUNC_API not found    _UFUNC_API is not PyCapsule object  #   _UFUNC_API is NULL pointer  =   SSE, SSE2   #   empty_nested() must be true before calling recover_memory()     empty_nested() must be false before calling recover_memory_nested() self        empty_nested() must be false before calling set_zero_all_adjoints_nested()  =   stan_version_major  #   stan_version_minor  =   stan_version_patch  #   unknown file name   =   unknown file name       __init__.pxd    Unknown exception       C:\Users\appveyor\AppData\Local\Temp\1\tmpa5wan1it\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.cpp  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.pyx #   stringsource    type.pxd        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.__getitem__        attr_names      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.__getstate__.genexpr       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.__getstate__   list        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.__setstate__       Expected %.16s, got %.200s  list        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.__reduce__ stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.num_failed.__get__ dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.num_failed.__set__ list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.test_grad.__get__  list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.test_grad.__set__  list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.inits.__set__  =   Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.par.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.value.__get__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.value.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.args.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.mean_lp__.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.mean_lp__.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder.sampler_param_names.__set__    ufunc   #   Expected %.16s, got %.200s  =   Expected %.16s, got %.200s      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._pystanholder_from_stanholder   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._dict_from_stanargs #   'NoneType' object has no attribute '%.30s'  =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  _call_sampler_star      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._set_stanargs_from_dict stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._dict_to_vars_r dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._dict_to_vars_i self    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._call_sampler_star  #   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._call_sampler   Expected %.16s, got %.200s      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330._call_sampler   __cinit__       attr_names  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__cinit__ __init__    numpy   =   __init__    'int'   #   __init__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__init__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__getstate__.genexpr      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__getstate__  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__setstate__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__reduce__        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.plot  =   'NoneType' object is not subscriptable  extract stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.plot  #   traceplot   =   traceplot       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.traceplot stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.traceplot extract 'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.extract   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.extract   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__unicode__       stansummary upar        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__str__   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__repr__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.__getitem__   #   stansummary args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.stansummary       summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.stansummary       grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.summary   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.summary   log_prob    throw   =   log_prob        grad_log_prob   get_logposterior        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.log_prob  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.log_prob  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.grad_log_prob dict        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.grad_log_prob args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_adaptation_info   #   get_logposterior        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_logposterior  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_logposterior  get_sampler_params  =   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_sampler_params    throw   #   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_sampler_params    close   =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_posterior_mean        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.constrain_pars    PyObject_GetBuffer: view==NULL argument is obsolete     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.unconstrain_pars  'NoneType' object is not iterable       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_seed  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.get_stancode      numpy.ndarray.__getbuffer__ plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.flatnames.__get__ 'NoneType' object has no attribute '%.30s'      numpy.PyArray_MultiIterNew1 data        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._verify_has_samples       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._update_param_oi  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._get_param_names  numpy._util_dtypestring stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._get_param_fnames_oi      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._get_param_names_oi       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._get_param_dims   numpy.import_array      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._get_param_dims_oi        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.constrained_param_names   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.unconstrained_param_names stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model._call_sampler #   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew2 mode        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model.sim.__set__   =   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 =   numpy.PyArray_MultiIterNew5 #   Expected %.16s, got %.200s  =   numpy.import_array  #   numpy.import_umath  T   numpy.import_umath  A   numpy.import_ufunc  S   numpy.import_ufunc  A   vector.to_py.__pyx_convert_vector_to_py_double  string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    %d.%d   S   string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   t   string.from_py.__pyx_convert_string_from_py_std__in_string  A   vector.from_py.__pyx_convert_vector_from_py_size_t      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ date        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  #   num_failed  #   test_grad   #   mean_pars   #   mean_lp__   # 
 adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.PyStanHolder    extract Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  #   traceplot   #   __unicode__ 1.0 stansummary 1.0 summary log_prob    a_row   1.0 grad_log_prob   get_adaptation_info 1.0 get_logposterior    a_row   1.0 get_sampler_params  [   get_posterior_mean  ,   constrain_pars  unconstrain_pars    ]   get_seed    #   get_inits   #   get_stancode    get_stanmodel   _verify_has_samples #   _update_param_oi    #   _get_param_names    .   _get_param_fnames_oi    _get_param_names_oi .   _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel       PyStanHolder    StanFit4Model   type    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.StanFit4Model   ndarray Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.__pyx_scope_struct____getstate__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.__pyx_scope_struct_1_genexpr    cython_runtime  '%.200s' object is not subscriptable    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.__pyx_scope_struct_2___getstate__       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.__pyx_scope_struct_3_genexpr     while calling a Python object  cannot fit '%.200s' into an index-sized integer need more than %zd value%.1s to unpack  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330 builtins        flatiter        broadcast       builtins        __builtins__    __name__         while calling a Python object  at most stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330 exactly stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330 %s() got multiple values for keyword argument '%U'      init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330    init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330    name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope      NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        at least        %.200s() takes %.8s %zd positional argument%.1s (%zd given)     %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       calling %R should have returned an instance of BaseException, not %R    %s() got an unexpected keyword argument '%U'    '%.200s' object is unsliceable  Missing type object     Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'      Expected a dimension of size %zu, got %zu       Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected     Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d        Expected a comma in format string, got '%c'     Expected %d dimension(s), got %d    S   Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler   T   Big-endian buffer not supported on little-endian compiler   Y   Buffer acquisition: Expected '{' after 'T'  A   Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)   t   'NoneType' object is not iterable   A   Missing type object Y   Cannot convert %.200s to %.200s '%.50s' object has no attribute '%U'    cannot import name %S   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330 %s (%s:%d)  S   value too large to convert to int   T   can't convert negative value to int Y   value too large to convert to unsigned int  cap can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    gamma   A   can't convert negative value to pystan::stan_args_method_t  t   value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   A   value too large to convert to pystan::optim_algo_t  Y   can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    delta   1.0 can't convert negative value to pystan::variational_algo_t  1.0 value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  1.0 can't convert negative value to long    _cython_0_28_3  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing 1.0 can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object 1.0 _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections.abc collections 1.0 Cython module failed to register with collections.abc module    Cython module failed to register with collections module    gamma       backports_abc   send    close() -> raise GeneratorExit inside generator.        send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    gamma       gi_running  ,   gi_yieldfrom    object being iterated by 'yield from', or None  gi_code __name__    error    /  name of the generator   __qualname__    qualified name of the generator generator       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330 %.200s.%.200s is not a type object      compiletime version %s of module '%.100s' does not match runtime version %s     %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    model   %]  an integer is required  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      k (internal counter)    The binomial coefficient is undefined for k > n, but got k = %1%.    [  grad_2F1        exceeded        Argument n out of range: got %1%         iterations, hypergeometric function gradient did not converge. grad_2F1    value   S   boost::math::prime<%1%> is not converging   T   grad_reg_inc_gamma  Y   is not converging   A   grad_reg_inc_gamma  t    iterations, gamma function gradient did not converge.  exceeded    A   k (internal counter)    grad_reg_inc_gamma  Y   grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    gamma   S   t_change    delta   T   *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    Must use algorithm="Fixed_param" for model that has no parameters.  Y   Output generated by Stan (test_grad)    Point Estimate Generated by Stan    gamma   A   Sample generated by Stan    gamma   t   Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    A   Sample generated by Stan    cap Sample generated by Stan (Variational Bayes)    user    stepsize__  Y   treedepth__ S   n_leapfrog__    divergent__ k_s energy__    gamma   k_s stepsize__  k_s int_time__  k_s energy__    delta   k_s # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    k_s boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    gamma   %1% boost::math::cbrt<%1%>(%1%) :   0.003379167095512573896158903121545171688   %1% 0.0834305892146531832907    gamma   %1% -0.338165134459360935041    :   -0.0509990735146777432841   %1% -0.00772758345802133288487  :   -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    0.1e1   :   0.00858571925074406212772   %1% 0.000370900071787748000569  S   -0.098090592216281240205    0.1e1   k_s 0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    0.1e1   k_s 0.0195049001251218801359    gamma   k_s 0.00180424538297014223957   k_s 1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017    delta   k_s 0.337511472483094676155e-5  k_s -0.0243500476207698441272   nan 0.0386540375035707201728    gamma   NAN 0.04394818964209516296  0.0175679436311802092299    gamma   %1% 0.00323962406290842133584   :   0.000235839115596880717416  %1% 1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373    %1% 0.00410369723978904575884   :   0.00295276716530971662634   %1% 0.0137384425896355332126    0.1e1   %1% 0.00840807615555585383007   :   0.00212825620914618649141   1.0 0.000250269961544794627958  0.0 0.113212406648847561139e-4  1.0 1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444    0.1e1   1.0 0.0105982906484876531489    0.1e1   1.0 0.000479411269521714493907  1.0 0.00628057170626964891937   0.0 0.0175389834052493308818    1.0 -0.212652252872804219852    0.0 -0.687717681153649930619    1.0 -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  C:\bld\fbprophet_1529035098489\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1529035098489\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   TEST GRADIENT MODE      Initial log joint probability =         Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  lp__    but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.    0.0 . Improved by    Log joint probability =    1.0 Iteration   1.0 Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  1.0 Optimization terminated normally:   1.0 Optimization terminated with error:     Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  1.0 Optimization terminated normally:   1.0 Optimization terminated with error:     lp__    lp__    t_change    1.0 *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    0.003379167095512573896158903121545171688   1.0 0.0834305892146531832907    0.0 -0.338165134459360935041    1.0 -0.0509990735146777432841   0.0 -0.00772758345802133288487  1.0 -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    :   0.00858571925074406212772   %1% 0.000370900071787748000569  %1% -0.098090592216281240205    :   0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    %1% 0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)     0.9016312093258695918615325266959189453125e-19  0.25479851061131551     Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      -0.32555031186804491    Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      The argument a to the incomplete beta function must be greater than zero (got a=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Adjust your expectations accordingly!   Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Initialization failed.  Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.      Log probability evaluates to log(0), i.e. negative infinity.   Log probability=       Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:        Rejecting initial value:          Gradient evaluated at the initial value is not finite.         seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps         attempts.      ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       Exception initializing step size.       t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)  The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%)  Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Result of tgamma is denormalized.       The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.  Evaluation of tgamma at a negative integer %1%. Unknown function operating on type %1%  The argument a to the incomplete beta function must be greater than zero (got a=%1%).   Error in function       The argument b to the incomplete beta function must be greater than zero (got b=%1%).   Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Cause unknown: error caused by bad argument with value %1%      Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)    Random variable Location parameter      Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       -3.7595974497819597599e+11      7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "   D            D (          "   E            E (          "   lE            E P          "   0F            PF           "   F            F (          "   G            4G           "   G            G (          "   G            H (          "   PH            XH 8          "   J            J h          "   8K            PK h          "   K            K            "   K             L            "   TL            lL h          "   L            L h          "   LM            dM h          "   M            M (          "   <N         	   \N           "   N         
   O           "   O    O    O          "   4R    dR    R           "   HS    hS 
   S           "   ,X    lX    X           "   dY    Y     Z          "   8\         
   `\           "   \         
   ]           "   ]            ]           "   $^            4^           "    a    a    b            "   c            c            "	   d            `d (          "    e            e (          "%   Xe         '   f x                               
      v      v            Pv   p         ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx
   p       
      `   @   `    
        
           `
   L    P    
   i   5    
   @   {      0{   0         z      (
   d   \   b   h   n   t   z               P   0         8
    %    b   b   b   b   b   b   b   b   H
      h
   `   Mb`MbPMbP?Mb`?       `
   <   (
   p    @
   )        
   p                   P       
   0        
   P             
   !   P    P       P    
   T   p
   b   b   b   b   b   b   b   b   H
   L      d   
   P_    _    
           
   T    W    P
   A   `    
    C   h
            `   0                   
   b   b   b   b   b   b   b   b   P
    j       
          @
   `j       
   P^     ^    
           8
   ,    &    p'     )     '    *    *    +    @,    p
          
   H   
   P        P    
   P          0                   Ȱ
   @   {      0{   0         z      
   p   `   0   Е      P      P   X
    "   P    P       P    
            UUUUUU?UUUUUUUUUUUU?UUUUUU
   T    `[     
            P    P    
           P
       @                     p       
   *       `
   0    P    P    P    P    P    P    P    P    P    P    
         `         t   `                 0         0   
      p      p
                  `
   0        
   P       
   .   `0    
   P       X
   @       |   
      (
   T    @T    
   ,    &    p'     )     '    *    *    +    @,    (
          /          
       
   `6    P    P    P    P    h
                    E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        
                                  h
      
   Ѓ      0   0             `   
   /    b   /    b   b    
       b   P    P    P    P    P    
      P~                     p       
    C    p?    ?     @    7    7    7    @    7    
           
   T    x    
   @                                
       0   $   
           
   t   
    @   `   
      b   P    P                   
      b   P    P                p   
            h
   P    `0    
   6       
   b   b   b   b   b   b   b   b   
      \   b         t   `                           
   P7    7    6    6    6    
   p            
   
                  
       @                     p       h
   b   b   .    
           P    P    P    P    P    X
      
           
   $   
   P       
           0
   0       (
   5    5                                     
 
                     	               	               
                                              
          
   @   t      v            Pv   p   
   @   @   0         0      `   
   T    0X    p
    %    7    7    7    7    7    7    7    7    h
           
      `   P   `   
          /          P
   P       
       
    A   `    
   P_    0s   0
   d   
   P^     w    x
   H   
   @   `   x
       
                  _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?
        
      `   P   `   
   @                                
          `
   p5    0    0    1    1    2    2    3    3    4    4    
       P    P       P    
   @B   @
   P            
            ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?
   P    
   $   `
           
             0                      ?   =
?   @33?   =
?      ?   ?    ?
            `   0                   H
   l          
   T    Z    0
           
   b           $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?
       b   P    P    0               
                                   x
   x          0
   P       `
   X   
      X
      @      `   0                   
           
              (
   0      `         (
        
   P       8
    >    P8    8    :     8    9    ;    <    =    
   P        P            gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@8
   R       
   P    `    
   4       T    
      v      v            Pv   p   '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        
   `i   5    0
   T    Y    
       0y      0{   0         z      `
           @
      
   P          0                   @
   <   `
   P    `       Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context             bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product     to_matrix(array)        vector size     rows * columns  .   y   n   m   k   T   Y   A   variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   C:\bld\fbprophet_1529035098489\_h_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =     anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2      data initialization K   t   cap S       t_change    X   sigmas  tau     trend_indicator s_a s_m delta   beta    variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   trend   beta_m  beta_a      Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        right-hand side left-hand side  assign  Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!   , but must be >= 0!     C:\bld\fbprophet_1529035098489\_h_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      rep_array   cols    []  Undefined transformed parameter: trend  Undefined transformed parameter: Y      Undefined transformed parameter: beta_m Undefined transformed parameter: beta_a iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed       Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.                 iter             ELBO   delta_ELBO_mean   delta_ELBO_med   notes         MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   C:\bld\fbprophet_1529035098489\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "                 4 `          "               H4           "               4           "   `            3            "   1            1 `          "   0            0            "               P0            "   0             0           "   /            / 0          "   )            `-            "   ,            , x          "   ,            ,          "               8,            "               (+           "               *           "   $*            `* X          "   ,            )          "   )            )            "    %            P)            "   3            (            "   0x            (            "    x            (            "   X(            h(            "   (             (            "   3            '            "   v            '            "   `%            p%           "    %            %            "   3            $            "               $            "               `$            "   3            0$            "   3            $            "   0x            #            "    x            #            "   3            #            "   3            #            "   3            "            "   v            "            "               " 8          "               ! 8          "   3                         "                 (  `          "                          "               0 0          "   L             8          "               ( (          "   x             X          "   t             @          "   ,            8          "                           "                           "   3            (            "   3                         "   0x                        "    x                        "   3                        "   3            `            "   0x            8            "    x                        "   +                        "   3                        "   3                        "   3            P            "   v                         "   3                        "   v                        "   \            h          "                         "   4    L    x            "   HH         8          "   HH    0    X 8          "                @          "   HH                    "   HH    L    x            "                X          "                 (          "                X          "                           "                @          "   8                         "               
            "    	            
            "   	            `
            "   	             
            "   \    t                "        	               "   
    
 
                "   |                    "           (            "   D    \                "   HH         0          "        8    `            "   HH         0          "           8            "   T    l                "                H          "                @          "                0 8          "   `     X (              "   HH         0          "   HH    X     0          "   P                   "   0    p               "       P               "       8    `           "           @ p          "                0          "               8            "            X         "   $         
   p           "                           "   x             X          "                X          "   8            H            "   ,             p         "   P            X            "                           "   ,            p p         "   P                        "                0          "                            "                           "               @            "   Ԣ                       "   3                        "   3                        "   `            h            "   0            8            "
   ̤             p         "                H          "                           "               ` (          "
   ̤             p         "                 (          "                (          "   h            p           "               ( (          "                8          "                (          "               h            "   x             0          "   x             0          "   3            @            "   3                        "   0x                        "    x                        "   3                        "   3            p            "   3            @            "   v                        "                           "   3                        "   x                        "   H            P            "               (            "
           @ 8         "   @            P            "
       (    P          "       (    P (          "                         "   <    , &   ` p          "   	             @          "       <    p           "        "              "                      "   t                   "   X         `         "   4    t               "        X     `         "       <    p           "   l                      "   D                   "   $    \     `         "       D    p           "           P p         "   T             8          "                           "                           "	   4    |               "            X         "   l             x          "+   t     Y   `           "                (          "   L            `            "                P          "               P P          "               ( P          "   $            `            "   HH    t     0          "   (z                        "                @            "   4    t               "       T               "               Ⱥ            "   HH    Թ      0          "                           "   <            P            "                           "                          "   @            H            "                           "                          "            	   @            "   HH                    "                 p         "   P            `            "   HH         0          "    <    < ;    P         "            *    (         "!   <    D =    @         "            *    @         "   (z                        "   `z            x            "   3                        "   0x                        "    x                        "   3                        "   0x            p            "    x            H            "   3                         "   0x                        "    x            Ц            "                (          "               X           "                           "
   ̤              x         "                0            "                (          "   Ԣ                       "   P            h            "   l                       "   l                       "   b             8          "   v            О            "   v                        "   3                        "   v            P            "               (            "                8          "                8          "               @ P          "   T    l                "   HH        @ (          "   HH        ș (          "        
    x          "   H         @           "        '   Д          "   |    4 )   `          "   ,                       "   ,            `           "                         "               0 @         "   p            ؎           "   0                       "   p            h           "   0            0           "               Ѝ          "                @ @         "   p                       "   0                       "   p            x           "   0            8           "   d                      "            -   Љ           "            -              "       ( %   P           "   0            @ H          "   Ѓ             x          "               P H          "               Ȃ 8          "   \                       "               p           "                P          "   `            h (          "
   ~            ~ P          "   ^            @~ 8          "   p`            ~            "               } P          "    |            P} 8          "               | P          "    |            @| 8          "   L            { 8          "   HH    \{    { H          "   HH    z    z (          "   `z            pz            "   (z            0z            "   3             z            "   y            y            "   @y            `y            "   HH    x    x 0          "   3            x            "   3            `x            "   0x            8x            "    x            x            "   3            w            "   b            Hw 8          "   b            v 8          "   3            v            "   3            xv            "   3            @v            "   v            v            "   8u            @u            "    u            u            "   t            Pt (          "   s            s (          "   q    8r '   `r @         "   p    q    0q 0          "   p    <p    pp 0          "   Lo    lo 	   o 0          "   |n    n 	   n 0          "$   @k         ?   `l          "   T            j 0          "   h    hi    i           "   HH     h    Hh 0          "   HH    g    g 0          "   HH    Pg    xg 0          "   HH    f    g 0          "   HH    f    f 0          "   HH    f    @f 0          "   HH    e    e 0          "   HH    He    pe 0          "   HH    d    e 0          "   HH    xd    d 0          "   HH    d    8d 0          "   HH    c    c 0          "   HH    @c    hc 0          "   ^            c 8          "   b            b 8          "   ^            Hb 8          "   a            a 0          "   a            a 8          "   p`            Xa P          "   a            (a            "   `            ` (          "   `            ` (          "   p`            x`            "   _    _ 
    `            "   _            P_            "   ^            ^ 8          "               ^ P          "   h]    ]    ]            "   \    \    \            "   [    [     \            "   Y    Y    @Z            "                   Y            "   L            Y            "   X            X            "   PX            `X            "   X            X 8          "   3            PW            "                   8W            "   3            W            "   3            V            "   HH    U    (V 0          "   U            U            "   HH    U    @U 0          "   T            T 0          "   3            T            "   S            S            "   S            S            "   ,S            HS            "                   S            "   tR            R X          "   tR            R X          "                    R            "   HH     Q    (Q 0          "   HH    `P    P 0          "   L             P            "   3            O            "   3            O            "   3            pO            "   3            @O            "                    O            "   L            N            "   HH    <N    hN 0          "   HH    M    HM 0          "   L            L            "   <L            XL 8          "	   tK            K (          "   K             K P          "    H            J (          "    H            J (          "   LJ            pJ p          "   I            I           "   H            I           "   HH    XH    H 0          "    H            (H (          "   G            G            "   tG            G            "   F            F            "   D         &   D           "               C            "	   B             C            "8   <    > f   p?          "J   5    7    8           "
   4             5            "   3            4            "   3            X4            "   3            04            "   3             4            "   3            3            "   3            3            "   3            p3            "   3            @3            "   3            3            "   82            2 8          "   1         
   1 H          "   ,            X1            "   0            1            "   0            0            "   /         
   00 (          "   $,            / (          "   $,            P/ (          "   +             / (          "   +            .            "   +            . (          "   .            . h          "   -            .           "   -            -           "   (            0- 0          "   ,            ,            "   <(            ,            "   $,            `, (          "   $,            0, (          "   +            + (          "   +            +            "   +            + (          "   4+            H+ p          "   )            8*           "   )            )           "   (            ) 0          "   (            (            "   <(            X(            "   '            ' 0          "   '            P'            "   ,%            &            "   @&            X&            "   %            %            "   ,%            8%            "
   #            @$            "   #            #            "   "    "    # H          "   ("    @"    h" `          "
         !    P!           "   @                   "                @          "                (          "                          "
       @    p @          "           @ 0          "       D    p 0          "   X         @          "   h             (          "                           "                            "   `                        "                           "               @            "	               @            "                           "   ,            p            "                            "   (         
   p 0         "                           "                           "   x	            x            "                          "   ,
                        "   
            
           "   ,
            P
            "                H          "   L             0          "   L            ` 8          "                P          "                           "   x	                        "   	            P            "   	                        "   x	            
            "    	            
            "    	            p
            "   x	            8
            "   	             
            "   	            	            "   x	            	            "    	            	            "   d                        "                 H          "                (          "   T             0          "   T            ` 0          "   ,             (          "   ,             (          "   |             (          "   ,            8 (          "   ,                        "   ,                        "   ,                        "   ,            h            "   ,            8            "                               "                           "                 (          "   (            p            "	   0             `          "                (          "   \            h (          "                   8                          Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                         ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    y:#[    
   p  d
 d
                                                                                                                                                     _            0             x
 P
                            
         
                          @   x
                         	 
 ȥ
                            
         (
 
 @
                      	            @   
                        
                	   P
         (            @   
                      ( 
 
                 0            @   
                `      ` 
 
                            xP 
  
                            0 
 H
                            2 
 p
                            
         x
             !            @   
                       0 
 
                            
         h!            @   
                        
         (            @   P
                        F @
 
                 P*            @   
             
 
 
 
 
 0
 
 
 
 0
                                                            X
                   
                   PV 
 h
                              @   X
             L            @   
                         @   h
                (        9 P
 
                             h
 0
                             R `
 X
                 h
 
                            pF 8
 
                 7            @   ظ
             8
 
 
                     
 
 @
                                P P
 (
                            
                    
         	            @   
             8
 
 
 @
 @
 
 h
                                     #            @   P
                  (       @   X
                        ; 
 8
                            8% H
 `
                 xP             @   
                         @   
             
 ȴ
                            
         4            @   P
                       
                   F @
 H
                           P
                   з
                   H
                    1 
 
                 `
 0
 
 @
 
                             x
 
 @
                        (       A X
 0
                            7 ظ
 X
                  2            @   0
             M            @   h
             `
 
 
                                
            P      0 
 
                 
 
 @
                               ȿ
                     (
 h
                              @   P
             
 
                            
                    ) 
 
                 >            @   
             
 
                 4            @   
             
             @   
                          @   0
                        PX 
 Ȱ
                             
 
                           > 
 
                 
 8
 
 
                                    
                     @   
                      P      P   (
              
 
                 
 
 
 @
 
                                        T 
 
                 8%             @   H
                         
 h
                 
 
                 
 @
                 
 
 @
                               0) 
 
                           
                    
         )            @   
                       I 
 `
                            ; `
 
                            
                    (
                    . 
 
                            
         
 @
                 P            @   p
             +            @   
             ;            @   
                        (
         8             @   
                        # P
 
                  B            @   
                       L 
 @
                 `<            @   p
                        x
         
 @
                 @
             @
 8
 
 
                         I            @   
                        ` h
  
                 
 
                    (        
 `
                            
                    0
         
 @
 @
 
                         
 
                            
                   
                    
          
 
                              @   P
                        h 
 
                             @   
             
 
 X
 @
 @
 
 h
                                                 
                    
                     @   
             ؽ
 H
 ȴ
                     h
                       ) 
 
                 X
 h
                           (
         
 x
                             @   P
             
 
 @
 
                         C            @   8
                P      L 
 
                            G h
 
                            `
                    8
                
   
                     
                     @   
                        p 
 X
                 
 `
 @
                                H
         
 
 @
 @
 
 h
                                 PV            @   
                        
         !               @   
                       p
         0	 	           @   H
             0
 
 @
                      	           @    
                         " 
 
                 
                        M h
 
                  R             @   `
                P      ) 
 h
                            
         &            @   
                        
         '             @   P
                           @   ȳ
                         ; 
 8
                            
         
 h
 @
                                 
                     @   
             +            @   P
             #            @   
             h
 @
                             
 @
                            
         
 @
                 @6             @   
                        2 
 
                              @   (
                         
 
                 p
            @   
             8
 
                            
         (
 
 @
                                
         
 
 `
 
 
 
 
                                               C 8
 
                 
 X
                 
 @
 8
 
 
 P
 
                                                
         x
             
 
 
 0
                         p(            @   
             X
 @
 @
                                `K `
  
                 h            @   
                        
 
 p
                             
 
                 
                        @   й
             H
 
                 
 @
                 <            @   
                        
                    T Я
 h
                             @   
                        H
                    
                    P* 
 
                 A            @   
                       h
                    x
         @            @   
                        
         
            @   
             !            @   (
             E             @   
                        X
         
 
                            	 
 P
                 pF            @   8
             (
 x
                            
                     
                    @1 
 
                 H=           @   
                        PV 
 8
                 G            @   h
             `
 
 @
                     @4            @    
                        < 
 
                 P            @   P
                        
                    P& 
 8
                 ;            @   `
             8
 
 
                                @ 
 
                 (            @   
             >            @   
                        HR 
  
                 
 x
 
 
 
 H
 x
                                     
 @
 @
                                 V  
 
                  
  
 
 
                                    h
                    @
                    + P
 (
                 `
 @
                 X
  
  
 
 
 p
 
                                     @
                (       # 
 
                 @,            @   
             `
 
 
 0
                                   7 ظ
 0
                 
 
 @
 @
 
                             
 
 @
                                
                    
                    H
         
 @
                            xE 
 
                           P p
 0
                 R            @   
             V            @   @
                         @   P
             (
 x
                 F            @   @
                        & 
 
                 P&            @   
             
 
                           
 
 x
                 
                       
                    C 8
 
                            
             (       @   h
             xE            @   
             x
 
 
 
                                    @@ H
 
                 <            @   
             ȴ
                        
                    ` 
 
                            V @
  
                            
                    H= 
 `
                 
 
 @
                                / h
 
                 ;            @   
             0            @   
             p/            @   
             U            @    
                        9 
 p
                            8! 
 
                            h
         hI            @   м
                        
                    , 
 
                 2            @   
                        C p
 h
                            P
                    S 
 
                            
                    
 
 
                             
 
                 M            @   
                        % 
 `
                 HR            @   
                         B 
 
                           
         
 x
                            H
         C            @   p
             
 
                             
 `
                 
                       
                   
                    
         D            @   
                       
                   R 
  
                    P      ( P
 H
                            < 
 p
                             
                    
                      P
 
                            0) 
 
                 @
 
                            > 
 0
                 ,            @   
                        
         P
 
                             
                    p
 
 
                 
 
 
 
                                    P 0
 
                 PM             @   
                       1 
 h
                            > 
 
                             @   й
                        2 0
 
                  W            @   
             P            @   h
                       % 
 X
                           h
         `%            @   
                         O H
 
                 
 x
                 `K            @   `
                        h! 
 (
                            
                  @      P   (
                        ( P
 
                 1            @   
                        
                    
          I           @   
             A            @   X
                        
 `
                 `            @   h
                         @   H
                       
                     @   8
             
            @   P
                        @ P
 @
                            E 
 h
                 H
 
                 E            @   
             X
 
 
 
 
 
 
                                                 @   8
             T            @   Я
                        
          V            @    
                       / h
 
                             @   
                        
                    
                     
  
                            @
          I            @   
                        
         h
             
 
 
 
 @
 
 h
                                     S            @   
                        `
 h
 
                 
                       # P
 P
                  J             @   
                        P p
 
                 
 
 
 
                                    ( 
 
                 0"            @    
                       0
                     @   
             Ц
 `
 @
                                  
 
                 8
 
 @
                        P      PV 
 
                 
 
                            @T 
 (
                 
             
 X
                            PM 
 x
                     (       @   
             P
 
 
 
                         
 
 
                     
                         W 
  
                            @   й
             
 
 @
                                
          
 X
                 %            @   
             @
 
                            P> 
  
                 
             !             @   
                         x
 `
                 
 
 @
                                
                   X
                    (
                   8
                    
                     @   
                        
         /            @   h
                        P
                    M 
 
                            `
                   H
         -            @   
                        : 
  
                            `
                      
 `
                            P h
 
                 =            @   h
             
 @
                 
 
                 
 @
                             
  
                         
 
 
 
 0
 
 
 
 0
                                                        P
                     @   
                        8
                     
 
                 
 @
                         p
 
 
 
 
 0
 
 
 
 0
                                                 0)            @   
                        > 
 
                 
 X
 @
 @
 
                             P>             @   
                        I 
 @
                           
                    p
                    + 
 
                            
                      @   
             !             @   (
             `            @   
                         2 0
 P
                 
 @
 @
                     h
 
 
 
 
 h
                                            
                    0
                    # 
  
                 
 
                            
                    
                    
                    W 
 
                  "            @   
             x
             
                         
 
                 
 
 @
                     0            @   
             
 H
 ȴ
                                е
                     @   X
                        0 
 
                          0	 H
 
                             9 P
 
                 PX            @   
                        x
                     X
 
                 
 P
 
                     .            @   
                        
                     @   
                        
         p            @   
             8
  
 
 
 
 h
                                 @            @   P
                        p 
 
                            
         
 @
                             @   
             8
 
 
 @
 
                             P            @   0
             0
 `
 0
 
 @
 
 h
                                                = 
 
                 @
             (
 
 @
                     `
            @   h
             
 
 
 @
 
 h
                                           
                    `< p
 
                 x
 
                    (       ` 
 
                            % 
  
                 h
 
 
                     
 (
 x
                                 @   P
             @
 @
                 P;               P   
                        R 
 
                    P       2 0
 
                            A X
 @
                            
                     
 
                  ;             @   
             2            @   
             
 p
                  R     (       @   `
                        
                   
                      @   x
             H
                        
         (
 
 
 `
 @
 
 
                                     *            @   
                        0< 
  
                             
 H
                 H=           @   
             T             @   
             >            @   
             @            @   h
                        
                     @   
             %            @   
                         @   
                        - 
 
                            @, 
 
                  
             
             :            @   
                        
         
 x
                            
            P      1 
 
                           
         0
 h
                            
         
 @
 @
                     @
 
                            hI м
 (
                            (
                    Ю
                    A 
 
                 
 8
 
 
 @
 
 h
                                     
 H
                 
 
 
                     H=            @   
                    
   @
                    `
                     @   P
              9            @   P
             @            @   
             
 `
 
 
                         8
             
 
 8
 
 
 (
 
                                                  @   
                        
            (       ( P
 
                                @   8
                        
         9             @   
             0
 @
                 P;            @   
                        
 x
                 =            @   
                        1 
 
                 X
              
 
 
 
                         >           @   
             >           @   
             8!             @   
                        
                    
            P       
 
                            
                    
         
             
 
 
                     H
 ȴ
                 !            @   
                        U  
 
                            
                    8
                    @
         0<            @   
             1            @   
                P      A X
 X
                             H
 
                           
                    L 
 
                            ج
                    
 P
  
                            @ 
 (
                            h
          O             @   H
                         8
 
                            
         @T            @   
                        @
         
                        0 
  
                 p             @   
                        б
                    * 
 
                            
         
 
 `
 @
 
                                        
                     
                    `% 
 (
                            p/ 
 P
                 
 
                 P
 
 p
                                
                    @4  
 
                             
 
                 @1            @   
             
 
 @
                      
 
 
                                 
         
 @
                             @   P
             @@            @   H
             
 `
 
 
 0
                                        
         
 
 
                 GCTL   `  .text$di    `  : .text$mn    Q     .text$mn$00 0Q   .text$x @   .text$yd      
  .idata$5        .00cfg      .CRT$XCA        .CRT$XCL       .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ        .CRT$XPA        .CRT$XPZ         .CRT$XTA        .CRT$XTZ      .rdata  (
 (   .rdata$T    P
 X  .rdata$r    d
 t  .rdata$zzzdbg        .rtc$IAA         .rtc$IZZ         .rtc$TAA         .rtc$TZZ      g .xdata  h   .xdata$x    x    .edata  \y    .idata$2    8z    .idata$3    Pz 
  .idata$4     2&  .idata$6      X  .data    P  .data$r Y $  .bss      @n  .pdata    <   .gfids$y          .tls         .tls$        .tls$ZZZ         _RDATA     `   .rsrc$01    `     .rsrc$02                                                 20
 
4 
2p B   R0
 b  n 
     p  * d 4 pI 
 r   0Q               Q         2P1	 T 4  p`  I h
    `Q     Q             &     
        
 d
 T	 4 2p2  	p`0PI @
   Q     Q Q    Q Q    Q    Q    R    R                  8            *                     "     e"     "     #     $  
 
4 
Rp d	 4 Rp 4 R
p`Pn 
  R     ,R    <R    LR    \R    lR    h    h         `%  %      %     %     %     %     %     %     &     *&     Q&     c&   d T 4 2 T 4 2`% %t !d T 4 
	n 
 R p'  t(      (  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 Rpn ȓ
 R     R     h h     .  .      .     /     /      W/     f/   4 Rpn 
     /   0I x
 J   R     0  "1      ?1   0I P
 J       1  2      /2   0I (
 J       2  3      3   0I  
 J       3  3      4   0I ؒ
 J       4  4      4   d T 4 pn 
 R     8  8      8  9      m9   d T 4 pn 
 R     9   :      :  :      }:   d T 4 pn `
     :  ;      ;  ,;      ;   d T 4 pn 8
     ;   <      %<  <<      <   4 pn 
  S     <  =      <=   4 pn 
     =  =      =   d	 T R( (d $T  4 
pn 
 0S     @  A      $ 	0 0  I 
 r  `S     lS @C  C      C     $D  m md
 h4 
rp 4
 rpn p
 S     S    S    S    S     F   G      $G     ]G     lG     {G     G  ! t K  7L    !   K  7L     h r0n H
 S M  ZM      kM      
4	 
2pXI    * *x h r0 Rp`P0 t d
 4	 Rn  
 S pU  U      U   h d 4
 rpn 
 S      V  V      V   h d 4
 rpn А
  T     V  :W      eW   t d
 4	 Rn 
     `X  X      X   h d 4 rpn 
     Y  gY      Y   h d 4 rpn X
      Z  wZ      Z   t d
 4	 Rn 0
     [  '\      V\   h d 4
 rpn 
     \  \      ]   h d 4
 rpn 
     @]  ]      ]   d
 4	 Rpn 
 ^  ^      ^   4 
p	`Pn 
 T _  _      `  * 0 p`0P  I h
 r   T     NT `T    lT `  a      7a     oa     b     + / I @
 b  T     T     b  c      Nc     c  . d1 40 . p  I 
 b  c  c      d     Cd  . 0 p`
0  I 
 r      pd  d      $e     e   h b  +
 +h &4 
p`Pn Ȏ
 T T    T    T     i  Ri      i     i     j     j   t 4 P' 't# #d" 4!  P  n 
 T T    T     0l  yl      %m     m     _n     n    p  !  
T 4 0o  \o    ! d \o  o   !   \o  o   !   0o  \o    !     T  4 0o  \o    " "h 	p`0Pn x
     p  p      q     q     r     "r  ' 't #d 4  P  n P
 U     `s  s      Ut   p! 4 u  u   ! d u  u   !   u  u   !   u  u    d
 4	 Rpn (
  w  ow      w   4	 
Rpn  
  U     0x  bx      x   4 Rpn ؍
 0U     0y  y      y  *
 *x &h "42 , 
p`P  n 
 @U     LU    XU    dU    pU    |U           U         y  y      6z     dz     mz     {     {     |     }     }     }     }      }  6
 6x h d 4 rp( d 4
 pI 
 J   U U     ~  F        z     )   d 4 2p 0I `
 J          P      _   d T 4
 rpn 8
 U     Ѓ          8	 'x8 #h9 4v t P  I 
 r  U     U    U    U     V    V    V    $V    0V             Ѕ  H      ^                    L     x               b          ǈ     9     G          ŉ     ߉        6	 %x8 !h9 t p0P  I 
 r  @V     LV     XV    dV    pV    |V    V    V             2     D                *     V     ό          0     ύ          B     V     p         4 Rp`Pn 
 V V    V    V    V    Y      w                    ӏ  $
 $T 4 R
	p`n 
 V V    W    W    (W    4W   ;      W     k                      0
 !4 
p`PI p
 j   PW     \W hW    tW             P  +      \           ȓ             
  K     v                   R
 R T
 4	 2p`$
 $T 4
 R
	p`n H
 W     W     W    R      s             4 p`P!  @     !   @     ;
 -t7 )d6 %44 . 
P  I  
 b  W W    W    W 
X    X                                                    Z     v  ! t       !   t       
 d T
 4 2p$ 	 0  I 
               X    X    X    X                	   hI    0X 8     p      y  0X     =X    RX    fX    X    
 
2Pn 
 "  I Ћ
               Y    Y    Y    Y               X 	   hI x    Y 8       `           Y     
Y    "Y    6Y    Y    
 
2Pn Ћ
 , h	 	 0  I 
               ZZ    fZ    fZ    rZ                 	   hI x   Y 8                          Y     Y    Y    Y    CZ    
 
2Pn 
 
 h 4 R
p`P
 
4 
2p R! t d 4	      !" "T
    =   !     =   !     T
   =   !      =   !     t  d  4	       RP!  t 4	 p    L !# #d
      T !       T !     d
     T !        T !       t  4	 p    L ! t @      ! d      !        !   t @      !   t  d @      
 
B0P  ! t
 d	 p    H !9 9  t
  d	 p    H !     t
  d	 p    H ! 4	 0    L !  t 	d
  4	 0    L $ 	 0  I 
            Z    Z        [    [    [    [    [    [        	      T 	   xE H   Z H                         ^     v  Z     Z    Z    [    [     [    |[ 	    BP0  n 
 :
 ,t9 (d8 $47 0 
P  I X
 r  [     [    [    [    \    \    ,\    8\    D\    P\ 	   \\    h\    t\    \ 
   \                 
     #     2     A     P          Ź     Թ       	   .  
   ׺  	   7          =     J     Y       
        ʼ  
   Լ          4     V  	   r          ½   	  d* T) 4( & p  n 0
 \           $ $d0  T/ 4. * p  n 
 \ \    \        ^                       - " p`0  I 
   \     \            ]    !]    -]    9]    E]            ^    ^    ^              	    R    Q] X           @  v                           #     X     f               3          J     a           _]    ] 	   ]    ] 
   ]    ]^    n^     bP0  n 
 , # p`0I 
   ^            _    %_    1_    =_    I_    U_    U_         	   ` 	   ` 	   `             4! 	    R    a_ X              5      \                         )     R          N                          o_ 	   _ 
   _ 	   _    ` 	   m`    ~` 	    bP0  n 
 "  I 
               a               T" 	        a H     :         a     
a    ;a    Ja    
 
RPn 
   I h
 {              Nb               " 	    p   a 8          $      -  a     a    a    a    
 
2Pn h
 *
 * x h 
4 
p( d
 4 rpI @
 2   `b     p          7	 &dv "4u p pP  I 
 r  pb     |b b b b b    b b b b 	   b 
   b     c             @                   E         y       ;     L                   M     ^           	      
   4                 
     	      4
 pn 
 c     @           Bp0  !  

 T     P% ! d	     \% !       \% !       P%  4 
	p`n ȉ
  c     ,c     8c             +     G        d 4 p6 (t3 $d2  40 , P  I 
 R  Pc \c    hc   '      5                 j   4
 pn x
        U      k  
 
4 
 p  ! d     & !       & ) t 4
 	PI P
 J   c c c c c c c           3      A         Q     _         o     }       	         & &4/ * p`P  n (
 c                d
 T 4 rp+
 +h &4 
p`Pn  
 c c    d             h     {     :     =  ! !d
 4 R
pn ؈
  d     ,d     `             }         4 
r	p`n 
 @d     Ld         9        T 4 p` 4 p`P! h @  X  <) !   @  X  <) !    <  `) !     <  `) & &d "4  	pP  n 
 `d ld    xd    d   P      <     D                 & &d "4  	pP  n `
     0  p      Z     b          
        4 
p`P!  @  z  p* !   @  z  p*  t d 4 P
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T   ?  * !     ?  * &	 &d "4  	pP  n 8
 d     d             )              4 
Rpn 
 d     0  V      m   d 4
 
Rpn 
 d         .   4 
Rpn 
     P  v         4 
Rpn 
 d                4 
Rpn p
       6      J  " "h 	p`0Pn H
     p        6    E          	p`P0n  
 d     d  ;     T           4 
r	p`n 
  a           t d 4 %
 %h t d 4 P"	 "d 4  pP  n І
  e e    e    $e     @	 u	     
    '
    
    
    
 "	 "d 4  pP  n 
  E                       d 4 pP' 'h
 #T# 4"  	p`  n 
 0e         4 
Rpn X
             d 4
 
Rpn 0
   p       4 
Rpn 
             4 
Rpn 
       F     Z  4 
Rpn 
               )	 
	p`P0  I 
 b   @e     Le    Xe    de    pe    |e    e    e    e    e 	   e 
   e             P                 ) 	   9 
   E    u                   
R0n h
 e     e    6      I        4
 
Rpn @
 f     f    ,f    8f                       '!    5! # 4
 pI 
 J   . @/     N/ 6 (4   
p`P  I 
    Pf     vf    f    f         / "0     0    2    2    b3    o3    y3     3    &4     = ,4C 8 
p`P  I Ȅ
   f     f     f    f    f    f    f    f         4 4     $5    E6     6    6    6    &7    N7    7    7    7    8    ;     4	 
Rpn 
  g     ; 0<     q<  4	 
Rpn x
     < <     =  4	 
Rpn P
     = P=     =  4	 
Rpn (
     =  >     a>  4	 
Rpn  
     p? ?     ?  R0n ؃
 h A B     6B  4 Rpn 
     @B B     B  R0n 
 B B     C  4 Rpn `
      C bC     }C  
R0n 8
 g     g    ,g    <g    Lg    _g    rg    g    g    g D D     D    D    D    E    E    'E    <E    QE    fE 	   oE =
 +h# &dQ "4P H 
p  I 
 #  g     g           g    g    g    g    h    h     h 	   ,h 
   8h    Dh    Ph 
   \h    hh    th    h    h    h    h    h    h    h    h    h    h    h    i    i    i    (i    4i    @i !   Li "   Xi #   di    pi    |i &   i '   i (   i    i    i    i ,   i -   i .   i    i     j    j 2   j 3   $j 4   0j    <j    Hj 7   Tj 8   `j 9   lj    xj    j <   j =   j >   j    j    j A   j B   j C   j    j    j    k        H   Dk    G   I      7 	    R    k H               E E     E    E    7F    lF    F    F    F    F    yG    G    H    I    gI    I 	   I 
   I    J 
   /J 	   =J    KJ    J    J    RK 
   K    K    K    K    L    ,L 
   :L    L    EM    RN    N    N    N    N    O    (O    6O    O    6P    BQ    wQ    Q    Q    Q    
R    R    &R    R    ,S    !T    \T    T    T    T    T    T    
U    [U     U    V !   WV "   V #   V $   V #   V "    W !   W    W %   X    ?Y &   zY '   Y (   Y )   Y (   Z '   %Z &   3Z    Z *   Z    C[ +   [    \ ,   %] -   b] .   q] /   ] .   ] -   ] ,   ]    ^ 0   ^    ^ 1   ^    _ 2   ` 3   N` 4   Y` 5   ` 4   ` 3   ` 2   `    a 6   ea    a 7   b 8   ?b 9   Jb :   pb 9   b 8   b 7   b    c ;   Rc    c <   d =   >d >   Md ?   sd >   ~d =   d <   d    e @   <e    f A   4f B   If C   Xf D   ~f C   f B   f A   f    g E   Ig    h F   h    i G   i    i     i k     !k H   .k I   
 
RPn 
 9 'h( R 
p`0  I 
 s  Pk \k    hk    tk    k    k    k    k    k    k                  Sl    _l    kl    wl    l    l    l    l                  >m    Jm    Vm    bm    nm    zm    m    m    m                   5n !   An    Mn    Yn    en %   qn &   }n '   n               *   *o +   6o    Bo    No    Zo /   fo 0   ro 1   ~o    o 3       3       5   +p 6   7p 
   
   
      ?             ?       "      ,? )   )   ,      @? 4   4   7      T? 	    R 8  k H   	    R 0  l H   	    R   m H   	    R (  n H   	    R    o H            l Ul     l    l    l    l    l    m    n    o    Po    o    o 	   o    o    o    p    #p 
   3p    jp    p    1q    q    q    r    >r    Lr    rr    r    r    r    r    r    &s    <s    s    Ht    t    t    u    %u    Ku    u    u    u    u    v    /v    jv #   v    1w $   w    w %   x &   Px '   ^x (   x '   x &   x %   x    x )   y    Ay -   Wy    z .   iz    z /   
{ 0   G{ 1   Y{ 2   { 1   { 0   { /   {    | 3   M| 4   _| 3   |    |    |    |    | k     k    l    0l 
   l     l    l    m    m     m     m !   n "   n     n *   n +   o ,   o     o 5   o 6   p 7   
 
RPn 
 .  t d 4 	PI 
 J   Pp \p hp tp p p p p p         0} }     ;~ ~    g                N    [      Ȁ    Հ      $
 $t d 4
 
rPn 
 @       ?
 .tC *dB &4@ : 
P  I p
   p     p     p     p     p     p     q     q      q     ,q     8q     Dq     Pq     \q     hq     tq     q     q     q                  )     I    U              ވ         T    b              	         7    C     p 	   ~      
   Ȋ               L    X      
        ̋    ؋               L    X              ̌    ،      < +tC 'dB #4@ < P  I H
   q     q     q     q     q     q     q     r     r     r     (r                                                                 0 }                      #     C    O         Ύ              u                   	        , 
   8     P  4	 
Rpn  
 @r     Pr    `r    pr     0 Y     e    q    }      d 4
 
Rpn 
 r     r   ?     W      
R0n Ё
 r   6       n 
                       lH 	    R 8   r H   0 C     c r     r    
 
RPn 
 3	 < 	p`0P  I 
   ls     0s    <s    Hs    Ts    `s     И           .    P            7    m             9 (h $4D < 
p`P  I X
   s     s    s    s    s    s   K     V    x    ӛ    *    `                        +     G & 6 p`0  I 0
   s     t    "t     .t      ϝ             ٞ               
R0n 
 P f      
R0n 
          d 4  p  n 
 Xt     @t    Lt           /    =    g         * *d %T  4
 R
pn 
 t     t    t    t    t    t    t    u    u               _    p    )    =    O    d        ڣ 0
 "d 4 	pPI h
 j   @u     Lu    Xu       :     D        
          # #h 4 Rp 
4 
pXI `    4
 Rpn @
 pu u            * # #t
 d 4 rn 
               0M @           u X              u     u     bP0  n 
  4 2! d t  A M !   t  A M !    A M  d 4 2! t @  M !   @  M ! d p  x !   p  x  d 4 
rpn 
               PN @            v X               v     .v     bP0  n 
  4
 Rpn 
        6    D  2p! 4 `  N !   `  N  R0n 
       4 Rpn x
       ?     h  4	 Rpn P
             d T 4 2p d
 4	 Rp 4 Rpn (
 p        4	 Rpn  
           7  4
 Rpn ~
     0             d 4 
rpn ~
               tP @           v X   0 4     G v     v     bP0  n ~
 ! d 0 H x !   0 H x  d 4 
rpn ~
               Q @           v X    2     E v     v     bP0  n ~
 ! d   x !     x ! d t 0  M !   t 0  M !   0  M ! t   M !     M ! d P h x !   P h x  4 Rpn `~
   t	 d 4 2 d	 T 4 2p0	 "d 4  pP  I 8~
    Pw             ! t `    !   t `    0	 "d 4  pP  I ~
                R0n }
   R
p`0n }
 `w     w    w           7    i      4	 Rpn }
 w     w               H  4	 Rpn p}
 w     x      P     l      0  ! t    T !      T + +d 4 p   BP0  ! t	   <T !  

 d  t	   <T !   
  t	   <T 
 b  n H}
       
     L #	 p
`P0  n  }
 0x `      |  d 4 
rpn |
               ,U @           @x X   p 
       @x     Nx     bP0  n |
 " "d
 T 4 
rpn |
 x     x    x       	            
 ! !d 4
 r
pn |
               V @           x X       `       x     x     bP0  n |
  T 4
 2
`! 	 t   dV !     dV ! 	 t   dV !     dV  4	 Rpn |
      @     e  4	 Rpn X|
       0     U 
 b  n 0|
   R0n |
 P	 w	     	 >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pPI {
 b   Py          2p`0 4
 rpn {
 `y h       1    U  
4 
pXI H    4	 Rpn {
 py        
 t d
 T	 4 R
 	 T d 4
 Rp 4
 Rpn h{
     0) )     ) )    )  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b  n @{
     : ! bp`0  n {
                                     Z             ,Z @           y 8   @           y H   p; ;     !< y     y    y    y     y    
 
2Pn {
  BP0  n {
 
  ` St
 6 
B`P0   T 4 2`! t @ #A Z !   @ #A Z  4  d T 2p! 4 `E E  [ !   `E E  [ !   4 `E E  [ ! 4 G G  [ !   G G  [ !   4 G G  [ $
 $d  4 r
pn z
 Pz \z               h    h             [ @           hz 8            J J     J    J    K    K    K    K hz     uz    z     
 
2Pn z
 $
 $d  4 r
pn z
 z z               h    h             \ @           z 8    L L     L    L    M    M    M    N z     z    z     
 
2Pn z
 $
 $d  4 r
pn z
 z z               h    h             ] @           { 8   0N N     N    O    O    O    O    'P {     {    2{     
 
2Pn z
  T	 4 2! t d  Q FQ (^ !    Q FQ (^ / 1 	p`0PI xz
 r  Q AR     `R    R    S    ' - p`P0I Pz
 R  @{     L{     `S S     T    ?T  4 R
p`Pn (z
 `{ l{    x{    {    {    {             T T     OU    cU    U    U    U    U  d
 4 
rpn  z
 { {               h             _ @           { 8           V )W     8W    <W    `W    W    W {     {    {     
 
2Pn  z
 
   n y
  | W +X     6X " "d T
 4	 
Rpn y
 |     @X kX      4	 
Rpn y
     pY Y      4" 	  p  n `y
 @|     L|             pZ Z     Z    ! 	0I 8y
 r       Z [     [  	 0  XI    $	 $4  
p`P  n y
 `|     P] ]     ^   0  n x
 p|     || ||     ^ (_     6_    _ 	`    ` & , p`0  I x
 R       ` m`     `    ` 6 (d8 $47 0 	pP  I x
 r  |     |    | |    |  a a     b    Mb    `b    b    #c ' - p`P0I px
 R      Pc c     c    1d 
   n Hx
               Tc @            } H   Pg ]g     ~g g     
 
RPn Hx
 
   n  x
               c @            } H   g g     g g     
 
RPn  x
 
   n w
               $d @           @} H   g g     g  h     
 
RPn w
 
   n w
               d @           `} H   h h     >h @h     
 
RPn w
 
   n w
               d @           } H   Ph ]h     ~h h     
 
RPn w
 
   n w
               \e @           } H   h h     h h     
 
RPn w
 
   n Xw
               e @           } H   h h     h  i     
 
RPn Xw
 
   n 0w
               ,f @           } H   i i     >i @i     
 
RPn 0w
 
   n w
               f @            ~ H   Pi ]i     ~i i     
 
RPn w
 
   n v
               f @            ~ H   i i     i i     
 
RPn v
 
   n v
               dg @           @~ H   i i     i  j     
 
RPn v
 
   n v
               g @           `~ H   j j     >j @j     
 
RPn v
 
   n hv
               4h @           ~ H   Pj ]j     ~j j     
 
RPn hv
 
 
t 4 1	  
p`0  I @v
           ~    ~     ~    ~    ~    ~    ~    
        - 
   9    E    v 
                                       D              |i 	    R     X   `k k     l    *l    am    m    Vn    n    o    Up    wp    p    p    q    Pq    }q    q 
   q    r    Gr    xr    r    r    s 	   =s 
   us    s    t    t     $    1    
 
rPn @v
  t d
 T	 R! 4 0u u j !   0u u j $ $d  T 4 
pn v
     u bv     v F 5u 0xv ,hw  
	p`0PI u
 B  P     \    h    t                         	    	   ܀         
                $    0    <    H    T    `    l    x                                ́    ؁ !    "    `w ex     px    }x    x    x    
{    Z{    { 	   
| 
    | 	   S|    }|    | 
   }    [} 
   u}    }                (    =    ߀    D    n    ӂ    ڇ    ?    Ҍ            R    o    d    t                    Ð    $    V                ӑ        ג     +     !   9 "   ʔ #    "   9 !   Y         	       /    I    V    c % %h !t d 4 
	n u
                                n 	    R P    H                і         1    F    E           %    
 
RPn u
 % %h !t d 4 
	n u
         @    L                  o 	    R P   X H                !     6                  X     e    
 
RPn u
 ) )h %t !d 4 
	n xu
                                   Pp     R P    H               @          6         ȝ          
 
RPn xu
 ) )h %t !d 4 
	n Pu
      ̂                             q     R P   ؂ H       p      E    f     Ҡ     ؂         
 
RPn Pu
 B B& =' 8x( 4h) %T p`0  n (u
        $    0    <    H    T           ` 	   l 
   x                       ؃             Lr 	    R H   x    V     h Т                         D    Ǩ    ٨    g     	   M 
       Э     
   Ȯ    B    P    p     
    	       @    p     Ӵ     
   2 	   g                          
 
Pn (u
 ' d 4 pI  u
 Z              :         :     ! 
	p`0Pn t
 <     0    e    q    }                           O    [        P    [                      d 4
 2
p! T	   t !     t  4 rp`Pn t
 Є @ g     -  d
 4 rpn t
  P z     A  
4 
pXI @   ! 4 @ _  !   @ _  !   4 @ _  	 	2`0! 
 t	 T   u !     u !   
  t	  T   u  
R0n `t
        ?  d 4
 
Rpn 8t
 P        d T
 4	 Rpn t
      $     O m       4 Rpn s
           ) / !t3 42 0 P  I s
 r        3    q             / !t3 42 0 P  I s
 r                    ,    ]  b  ! t 4   w !     w !   t  4   w  R0n ps
   '     B  
 n Hs
   `        R0n  s
 P   !     0  R0n r
 P        R0n r
       2 # #t
 d 4 rn r
               x @           p X              p     ~     bP0  n r
  d 4  p  n r
           -    S                   4 R
pn Xr
 @     n                   (    a  4 Rpn 0r
     p          n r
  `       " "d 4	 Rpn q
      ʆ           P  t T
 4	 R`2	  d 4  p  I q
                  z @            H                    BP0  n q
 f
 fd <t 	 4 2% %4 p`n q
               p{ @             X       ` '     k       .     bP0  n q
 ' / p`P0I hq
 b   B          . 4S N p`P  I @q
 b  `     l    x       }             (    v : : &  x 	h   / 1 	p`0PI q
 r       A     `              h 0!  x ` $ | !    ` $ | !     x ` $ | . 4S N p`P  I p
 b                         * 0 p`0P  I p
 r    Y     x        8    ] ] U  
	p`0P! h
  C } !    C }    n p
 P      $ 	, 0  I xp
 R        B     @
 /t[ +dY '4X R 
P  I Pp
            Ї އ            '    9    G    S               #    :                    5     	   % &
 &d
 !T 4 R
pn (p
 ` `       * 0 p`0P  I  p
 r            2        , ,4)  
p`P  n o
 p     |                h    h     ʈ    ֈ     	       /    h     h h               o             )    =    S    p            !    0 	   F 
                       O          
               '  , ,4)  
p`P  n o
 @     L    v            h    h              	   ҉        h     h h             P             8    y                        q     	    
               X    h             - 
   M     Q g    w    d 4 pn o
   M     i 
 
r0
 
4
 
rp= ,4= 2 
p`P  I `o
         ,    Z    l     z                       /	    B	    	    F    P     x     6 (4   
p`P  I 8o
                
     *
    N
    \
    
       
0n o
 ܊     Њ ` v              L :c 2d -e (xf $hg  
p`0  I n
 #                  (           !    -    9    E    Q    ] 
   i    u     
                      	      < 	    R    4 h         ;    I    y         
       >        d 
   r    + 
   G                             
   2    N     } 4     B    v        ы        @    Q             	             P0  n n
 A 0x ,h (4<2
p`P  I n
 b	       ̍    ؍                        '    3    ? 
   K    W    c    o    {                        Î    ώ                           #    m    r        	            
 	        
        
       j    {    - 
   
#    #    #    $    $    $    $    &%    3%    %    %    V&    g&    &    &    &    &    &    &    &    3'    M'    f'    '     ' A 0x ,h (4@6
p`P  I n
 	                       #    /    ;    G    S    _ 
   k    w                            ˏ    ׏          ( (     ")    /)    C)    )    )    *    )*    *    
+    @+ 	   ,    7- 
   D-    - 
    .    .    .    ]/ 
   :3    3    4    54    B4    4    
5    V5    c5    6    +6    6    6    6    6    6    7    7    7    +7    c7    }7    7    7     7 / /h +/ 't. #d- 4, ( P  n pn
               $    0    <    H     08 8     )9    79    k9    9    :    :    S:    ;    ;    ;    <     < "	 "d( T' 4& $ p  n Hn
 ` < <     = "	 "d. T- 4, * p  n  n
 p = ,>     t? "	 "d( T' 4& $ p  n m
 ? ?     @ "	 "d. T- 4, * p  n m
 @ A     dB #	 #t3 d2 41 . P  n m
               B {C     C    &D    ]D    
E    IE     dE 1
 1x -h )tC %dB !4A > P  n m
          Ȑ    Ԑ         E F     F    *G    G    H    I     &I "	 "d( T' 4& $ p  n Xm
 PI I     fJ "	 "d. T- 4, * p  n 0m
 J J     L "	 "d( T' 4& $ p  n m
 @L |L     VM "	 "d. T- 4, * p  n l
 M M     O #	 #d4 43 . pP  n l
               0O P     ^P    P    P    Q    Q     R 0
 0x ,h (dB $4A < pP  n l
          (    4          R S     aS    S    /T    XU    U     U 7
 )h %42 ( 
p`P  I hl
 "  @     L    X    d    p    |     U V     V    W    *W    X    SY    Y    sZ    Z    Z     Z 7
 )h %42 ( 
p`P  I @l
 "      [ [     '\    5\    Z\    ]    ^    _    _    _    _     ` <
 *hs &d "4  
p  I l
 #                       ̑    ؑ         	    
    
    
     
   , 
   8    D 
   P    \ 
   h    t                        H 	    R    x       @` `     ` a    2a Fa    a    c    )d    nd    e    f    yg 	   6h 
   ,i    =i 
   i    i 
   m 
   m    Wn 
   n    n    Uo 
   o    o    Lp 
   {p    p    ;q 
   r 	   s    7s    ls    s    s    s     t              
 
Pn l
 <
 *hs &d "4  
p  I k
 #   ̒ ؒ                                   	     
   , 
   8 
   D 
   P 
   \    h 
   t     
                  ԓ              	    R    x               t u     .u Zu    ou u    
v    )x    3y    y    z 	   v{ 
   l|    }| 
   |    } 
   Հ 
         
   ́         
   ł         
            u 
    	   N                    >    l              
 
Pn k
 @ .xc *hd &d "4  
p  I k
 #                      )    ;    I    U    a     	               ʔ 
       
        '    3    d    v                ɕ              $ 	    R     X           Ї h         6    m        ߌ        7    h     
           '    _            ߎ 	   / 
   O                    W    w                             
 
rPn k
 @ @ ; 6x 2h %> p`0  n k
                         4              Ę 	    R     X            A     x    #        >        t             
 
rPn k
  4 2p!
 
d T  # @ !    # @ !   d  T  # @ $ Rp`0n xk
                @           @ 8    >     s @     M    
 
2Pn xk
 $ Rp`0n Pk
               ( @           p 8        ޚ      p     }    
 
2Pn Pk
  2
p!
 
d 4   . x !     . x !   d  4   . x !
 
d 4   x !     x !   d  4   x !
 
d 4 0 > x !   0 > x !   d  4 0 > x  R
p`0n (k
                            @            8         (     2    C     Q      ɖ    
 
2Pn (k
 !
 
d T ` s @ !   ` s @ !   d  T ` s @ / 1 	p`0PI  k
 r  p џ         *        ) , p`P0  I j
 R             ,  H     g            2	  44 , p`P  I j
 R      @      Ȣ        M    	 t d T 4    d 4 
p  !
 
 T Х  8 !   Х  8     zx dh &% p`P0!  
    t !  	 	
   ߩ  !     ߩ  !      t  	  0  n j
 @     L             н           
R0n `j
 о 	     O  d 4
 
Rpn 8j
 `        
R0n j
 @ y       
R0n i
  )     o / !t3 42 0 P  I i
 r                    ;    l =
 ,hP (4  
p`P  I i
   ` l    x                             	               ) 
   5 
   A      (     w     8    I                [                    . 	   j 
   }             
       ] 
        
               8    X    t =
 ,hP (4  
p`P  I pi
        X          h    y            *                #    D    ^ 	    
                
        
        
       +    ?    h         
 
d	 
Rp! 4   V   !     V   .  t d 4 	PI Hi
 J   P \ h                  < < 7x
 3h /t' +d& '4$  
P  n  i
              , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t ` } 8 !   ` } 8  d 4 pn h
        _ 	 	 0      d 4 p h d
 4	 Rp.  t d 4 	PI h
 J      Ę И          h          = m    z           ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P  n h
                          (    4    @    L                            D    k        I     	       E    Q    \    g    r              / / *x &h % 
	p`0Pn h
 `     l     P                / / *x &h % 
	p`0Pn Xh
      J     O    K     V ( (d $T  4 
pn 0h
             0n h
 `
 
     8  R0n g
 P q       R0n g
       0  0n g
 @ t     
  R0n hg
 0
 Q
     `
  R0n @g
 
 
       
 n g
   T       R0n f
         R0n f
  q       0XI `   ! t   ( !     ( " "d 4	 Rpn f
       D     R        n xf
         { j7 b8 Z9 R: J; B< := 2> -x? )h@  
	p`0PI Pf
 b           ș    ԙ                            ( 
   4 
   @    L 
   }                        ͚    ٚ      &     7                K    \                  -    m             	       *     
        
       ! 
   6     
       $    A    g     "    "    '#    8#    E#    v#    #    #    '$    8$    X$    $     $ :
 (xT $hU  
p`0  I (f
 3               )    5    A           M    ~ 	                
                          G    S    _    k    w                          Ɯ    Ҝ    ޜ                                                	       X   	        X   	    (   X       0% &     "& &    & &    '    '    '    3(    (    )    o)    t)    ) 
   )    *    (*    *    *    *    + 	   \+ 
   ~+    +    ,    w,    ,    ,    -    d-    -    -    -    3.    r.    .    .    .    /    @/    O/    /    d0    v0    0    0    d1    v1    1    1     1    2    ;2      	         ,    9              
 
rPn (f
 { j: b; Z< R= J> B? :@ 2A -xB )hC  
	p`0PI  f
            (    4    @    L    X    d    p    |     
    
        
   ݝ            	        !    -    9             2 3     4    4    4    4    5    ,5    5    5    6    6    @7    q7    7    7 	   7    8    u8 
   8    8 
   9    %9 
   :9    : 
   :    ;    /;    R=    ?    ?    @    @    $@    U@    @    @    A    A    7A    A     A :
 (xW $hX  
p`0  I e
 c  P         }                           ޞ 	           
     
   G    Y    g    s                       ˟    ן                          &    2    >    J             x                           	    H  \ X   	    P   X   	    X   X               B B     B C    C C    C    D    D    E    E    E    LF    QF    oF 
   F    F    G    hG    G    G    G 	   9H 
   [H    H    H    SI    dI    I    I    ]J    J    J    J    K    [K    lK    K    K    K    (L    L    L    L    NM    M    M    M    IN    UN    N    N \     i                           
 
rPn e
   
p`0  n e
               Դ 	    R 8   ` H   O O     &P `     m         
 
RPn e
  0. h 42 . p  I e
 R        R S     DS    RS     S = = 8 3x /h +4> 8 p`P  n `e
  ̠    ؠ                                  T gW     W    W    JX    X    Y    Y    Z    [    ]\    h\    \    \  p`0n 8e
                @             8       \ 7]     ]       -    
 
2Pn 8e
  4
 
Rpn e
 P     `    p                            ] ]      ^    ^    ^    ^     ^    @^    _  0+
 +t# 'd" #4!  
P  n d
 С _ _     c 4 4 /	 *x
 &h "d 4  pP  n d
  c e     !e  d 4 pn d
  0g og     +h > > 9 4x 0h ,5 (t4 $d3  42 . P  n pd
             Ph h     k    k    il     l  4	 Rpn Hd
 0     Z     l !m     /m    sm  4	 Rpn  d
 p          m m     m    #n " "d 4	 Rpn c
      ڢ @n n     n    n # #t
 d 4 rn c
                @            H        o 5o     Ro          
 
RPn c
 ' 'x h 	   4 r
p`P!  p >q H !   p >q H ! h 
r r p !   
r r p ( (h $d  T 4 
pn c
 ps s     Zu D 2 - (x  $h! D 
p`0  I c
               (    Y    k    y                    h 	       H       u rv     v    ?w    lw    w    w    w    y    {y    z          Σ     
 
RPn c
 D 2 - (x $h  B 
p`0  I Xc
                   )    ;    I                     	      U H       pz z     {    {    {    
|    ]|    ||    }    }    P~ U     b         
 
RPn Xc
 & 4 p`PI 0c
 J       ~ ~           (    6     ŀ C    Q 
 t	 d T 4 2
 
4 
2`! t  Ń  !    Ń     n c
        ! t  ̇   !    ̇   ! t   5   !     5   ( (h $d  4 
pn b
                	    R 8    X       Љ 9     ^                bP0  n b
 ! t  ؋   !    ؋    4 R
p`Pn b
      (    4    D    P                   O    h                ˍ 	 	2P0! 
 t	 d    !       4	 2`! t  ӎ ؿ !    ӎ ؿ / 1 	p`0PI b
 r  0              Q    !  x  t | !     t | !     x  t | )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '       ! h	    !      !       , 42 	0 p  I hb
 r  @              d    = = *  x h   " 1 I @b
 r  @          ܣ    Z    % %4) %  p`P  !& & 
 x h    !      !     
  x  h      n b
 `               0 0h ,4  p
`Pn a
 p     |                              F      ǩ     ֩            ¬    _    m                5      <
 *x %h 
p`0  I a
        	        !    -    9    j    |                   
   a    m     
                         d    p    |                ƪ    Ҫ    ު                          ͫ    ٫             #   	 $    $   ! $   -    9    E )   Q 	   	                                   D 	    R     X         ʧ X       R     X   	    R    X           `      3    K    2                W    u 	       %        ʹ     
   @    ^        V    h                    "    >    P    ^    r    }        y        ϸ         % !   7    X    u            Ĺ     "       3 #    $    %   0 $   q &    $   Ļ '   ֻ $    #            9    U    q            n (        )   X *   j )   x        F      
   :    K 
   ʧ     ا    N    _            7    H    U                 {                          bP0  n a
 B 1xS -hT )4  
p`P  I a
 "  `     l    x                            ̬ 	   ج 	           ' 	   5    A           )             v    =    Z            2                     	   L 
   i 	   D    [     
               O 	                    	 3 3( .x) *h* &d^ "4] V 
p  n xa
 P                   \           h    t                	    
            
   ȭ 
   ԭ 
              
              
              
                                       	    R `   x           `     C    U                         	    
   b         
        
   H    Y 
   ~         
    	   R    q                       
 
Pn xa
 @ @
 ; 6x 2h ## p`0n Pa
       ,    8    D    P    \    h                                R    t H                 z                 i            7                 F         '        7    C    O      t              
 
RPn Pa
  d 4
 rpn (a
  p        T 4 	p`n  a
          Ȯ       K     Y    ~              D Dx @h <4> /6 !p`P  n `
          & 4 @     P k                  c    o $ $h d> 4= 8 p  n `
 P     \    h                                   0 	      t                      V    g        S                          &     H t     
 
Pn `
 :
 (x* $h+ X 
p`0  I `
            ȯ                                       X 	      ԯ        p              M        "    P        }                    ԯ     
 
Pn `
 $ $h d< 4; 6 p  n ``
       ,    8                  _    k             p 	      D                       f    o        =        p                       5 D     
 
Pn ``
 :
 (x( $h) T 
p`0  I 8`
 {                                 ˰    װ              	    p          `              %                    J    V     x |               
 
Pn 8`
 : : 5h 142 %( p`P  n `
                 k         L    e        y <
 * %h 0 
p`0  I _
 S                    ,    8 8               P 	    R (                    Q     1 Z    '          q       .    e    }    ۱              P0  n _
 . .x )h $t?  d> 4= 8 	  n _
 P     \    h                                   l 	      t          $    5        !    U    D                       	 t     
 
Pn _
 :
 (x* $h+ X 
p`0  I _
            Ȳ                                        	      Բ        @              )	    	    	    
        V    b                Բ     
 
Pn _
 )
 )x $h d> 4= 8 p  n p_
       ,    8                  _    k              	      D             
     @    I            V    E                       
 D     
 
Pn p_
 :
 (x( $h) T 
p`0  I H_
 {                                 ˳    ׳              	    p          @                                  5    A     c g    s           
 
Pn H_
 <
 * %h 0 
p`0  I  _
 S             ش                           	    R (                   a     A j    7                  5    M            ɴ      P0  n  _
 <
 *hh &d "4  
p  I ^
 s           ,    8    D    u                 	   ޵ 
           
        G    Y    g    s            ¶    ж    ܶ                      	    R     H                                            !    J!    {!    !    !    "    :"    r"    "    " 	   " 
   B#    b#    # 
   #    #    $    k$    $    $    $    %    %                 
 
RPn ^
 4 4h! %D p`0  n ^
 0        <    H    T                     P 	    R    ` X               & X'     q'    '    T(    (    t)    ,    ,    `     m    z    
 
rPn ^
  d 4
 pn ^
 0- -     - :
 (hp $d  4  
p  I ^
                               	        !    R 	   d    r    ~     
       ͸    ۸            $    6    D    P    \                                      @ 	    R x   Ź H                . .     .    ^/    2    ?2    2    2    2    3    B3    d3    3    3    4    >4    k4 
   4    4    4    55    f5    5    5 	   6 
   %6    ]6    6    6    6    -7    M7    7    7    7    7     ҹ    ߹    
 
RPn ^
 ! t P8 e8  !   P8 e8   t d
 T	 4 2 T r
p! h 
d
 4 p; ;  !   p; ;  ! h 
d
 4 0< N<  !   0< N<  Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P  n X^
       h      ? D@     B    
B     $C * , p`0  I 0^
 [                               <     R P   H   C C    
D     D      *     BP0  n 0^
 >
 ,x- (h. ^ 
p	`0  I ^
   p |                        ĺ    к    ܺ 	       
    	       
            < 	    R    H   D E     sF    F    BG    RG    "H    2H    I    I    I 	   J 
   J    _M 
   {M 	   P    P    Q    Q    Q          L     
 
RPn ^
 + +h ' #t d 4 Pn ]
 `     l `Q Q     US    hS     S >
 ,x' (h( R 
p	`0  I ]
 k                       Ȼ    Ի         	       
    	       
              	    R `   H               T hU     2V    DV    RW    _W    "X    2X    Y    Y    Y 	   Z 
   Z    ] 
   ] 	   ?a    Na    ]a    ia    ua          \     
 
RPn ]
   n ]
 p     a a      R0n h]
   b b     b  
R0n @]
   c 9c     c  d 4
 
Rpn ]
 c c     >d  4	 
Rpn \
      @g g     g  
R0n \
 h Ih     h  d 4
 
Rpn \
 h h     Ki  4 Rpn x\
     i i     i  4 Rpn P\
     `j j     j  
 n (\
 j k     ck  R0n  \
 k k     k  R0n [
 k 1l     Ll  R0n [
 pl l     l * T 4 p`I [
 Z   h                          l 7m     Dm    m    xn    n     n * T 4 p`I `[
 Z   n <o     Io    o    }p    p     p # #t d
 4	 Rn 8[
     ps s     ut &
 &d
 !T 4
 R
pn [
  t t     / /x +h	 'T #4  
	p`  n Z
 @     v ew     x &
 &d
 !T 4
 R
pn Z
 0y _y     = / *x &h % 
	p`0PI Z
    P { |     }    T 4
 
R	p`n pZ
     P~ y~      d
 T r! x h 
t 4
 ` ~  !   ` ~     4  p`P  n HZ
 `       3       h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  n  Z
             @              '    :    h            =     	   w    ;    G    R    ]    h             ׏    T 4
 
R	p`n Y
     @ i     #
 #h d T 4 pn Y
 p |     P          ߓ    
     "	 "T 4  	p`  n Y
          P        
 XI    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  n Y
              w                             ;        o 	           ɡ    ԡ    ߡ            1     Y  
 n XY
        C  R0n 0Y
  `        R0n Y
       ,  R0n X
 P w      J J B
 = 8 3x /h +t- 'd, #4+ $ 
P  n X
       M " "d 4	 Rpn X
           P 	 	B  ! 4 0 i N !   0 i N " "d 4	 Rpn hX
       *     @           / /h
 + 't #d 4  P  n @X
 @ L    X     P              Ҳ    3 S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P  n X
 p      K     ` . h 42 . p  I W
 R  и      G    U      = = 8 3x /h +4> 8 p`P  n W
                      Ⱦ    Ծ       G     d        *    Ⱦ                    =    H    g    r V H @ 8 3 .x *h &44 * 
p`P  I W
            . h 42 . p  I xW
 R  p               X = = 8 3x /h +4> 8 p`P  n PW
               $        h        *    5    &                 " "d 4	 Rpn (W
      
 P            t d 4 	 4H @ 
p`P  ! G   | !     | 3	 %46 0 p`P  I  W
 z        ,    8    D    P    \            @              .            6 (t/ $d.  4, ( P  I V
 :  p     |                 <     a             h R00	 0 & x 	h   !   #  !    #  !     #  / / & x h 4 p!    $ !     $ !      $ 8 8 & x h 4 p"
 "4 
p	`Pn V
                  R R J B
 = 8x 4h 04- !" p`P  n V
      ̿    ܿ                    $             P                      #                         8 8( 3) .x* *h+ &d` "4_ X 
p  n `V
 0            <           H           T    `           l 	   x 
            
    
    
              
              
              
                                       	    R `   x               `     L    ^                         	   A 
           t 
   h    y 
        
   
    C
    x
 
   
 	   
        #     R              
 
Pn `V
 2 2 -x )h %t !d T 4 
	n 8V
        0 0x ,h (d $T  4  
p  n V
        
 1     U          3	 !4= 6 	p`  I U
         ,    8                                 	    R x   D h                	                 7    S     X    t      D     R            	      P0  n U
 <
 * %h 0 
p`0  I U
 S                 $ 0 <    H H               L 	    R (  0     a     A j    7         0     >    u                	      P0  n U
 <
 * %h 0 
p`0  I U
 S             H    T ` l    x x               d 	    R (  `             q     Q z    G         `     n                ,    9      P0  n U
 <
 * %h 0 
p`0  I pU
 S             x                           	    R (                    a     W          "                  K    \    i      P0  n pU
 <
 * %h 0 
p`0  I HU
 S                                        	    R (               # #     q$ $    g%    %    '                  {              P0  n HU
 " "4
 rpn  U
               l @            X   ( (     (           bP0  n  U
 " "4
 rpn T
                @           ` X   ( H)     ^) `     n     bP0  n T
 <
 *hv &d "4  
p  I T
 S                          '    5    A    M 	   ~ 
                                       P    b    p    |                                         l 	    R     H   ) /*     H*    v*    +    2.    T.    .    .    .    0/    ]/    /    /    /    '0    X0    0    0    0    1    O1    1    1 	   1 
   2    ?2    w2 
   2    2    2    G3    g3    3    3    3    4                 
 
RPn T
  0(
 (x #h  	p`P0  n T
 0                       < 5 n7    
8 G8     [8 '
 'h	 #T 4  	p`  n T
 P \    h 9 :    ;    ;    ; <     0< ' 'x
 #h  
	p`P0n XT
              `< R>    &? c?     w?  R
p`0n 0T
                            @            8       ? ?     ?    ?     @          
 
2Pn 0T
  R
p`0n T
                             @            8       @ 8@     B@    S@     b@      	    
 
2Pn T
 % % !t d 4 
	n S
                @             X       @ A     SC yC     /     RpP0n S
  R
p`0n S
         `                  L @           | 8   C C     C    -D |         
 
2Pn S
 % % !t d 4 
	n S
                @            X       @D qD     F F          RpP0n S
    4 Rp`n hS
                           p @            8        G .G     ;G    qG     G      	    
 
2Pn hS
  4 Rpn @S
                             @           < 8       G G     G    G <     I    
 
2Pn @S
  4 Rpn S
         `                   @           | 8        H *H     8H    FH |         
 
2Pn S
  T 2`! 	 t 4 `H zH  	 !   `H zH  	  d 2p! T 4 I I 8	 !   I I 8	 ! T 4 J J 8	 !   J J 8	 5 5x h   ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P   T 4 p`!   `U U 	 !   `U U 	 
 d T 4 p!  0X `X (
 !   0X `X (
  h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
pn R
                                     	    R      8           ] ]     ]    ^    e^    w^    ~_     _          
 
2Pn R
  4& $ p  n R
                                  	   	      8   _ 	`     >`    [`    `     ` `     `      
 
2Pn R
  d	 4 Rp R
p`0n R
                             @           < 8        b Hb     Rb    cb     qb <     I    
 
2Pn R
 Y Yh  0  ' 'h "d T 4
 
rpn xR
     d ,f     Rf ' 'h "d T 4
 
rpn PR
     f g     g #
 #h t
 d 4 rn (R
  h h     i " "d 4	 Rpn  R
  l Dl     Rl    l " "d 4	 Rpn Q
 l m     m    `m " - 	p`XI @  !C
 Ch 8, &4 T3 42 o p   !   o p   	 d T 4  p  n Q
 `     l    x     0s fs     s    s    :t    t     7u    T
 4 
R	p`n Q
       u v     `v    pv )  	p`0PXI   !/
 /< &x= h> ~ Ԉ v ;w 0 !   v ;w 0 ! 
  <  x=  h>  ~  Ԉ v ;w 0 3	 %49 0 p`P  I `Q
 z  P ۂ         B    ^    ͅ    ܅     4* 	( p  n 8Q
    3     w !     !      !        x h 
- n Q
                          p K     M          $    C \      k 
	`P!*
 *2 x3 h4 tj 4s  Ǝ  !    Ǝ   4
 
Rpn P
               ` @            8        Օ               
 
2Pn P
  4
 
Rpn P
                @             8        5     ^       -    
 
2Pn P
   x h   
 x h p`P0$
 $  x h 
 2 2x .h	 *4  p
`P  n P
 P     \ @                " "x h 	p`P0! t   ?   !     ?   $
 $d  4 r
pn pP
               D @           p X              RpP0n pP
 ! t     !       $
 $d  4 r
pn HP
                @            X              RpP0n HP
  
p`0  n  P
                           ` @            H         *     Q    j           #     2pP0n  P
  `  ! T    ! t 4  T    !   t  T  4       ! 4  P d  !   P d  ! 4     !      !
 
t d  8  T !    8  T !
 
t  4 p   !   p   !
 
t d P x  T !   P x  T . .4= 4 
p`P  n O
        E      UeDx  =h! 6tL /dK (4J cD 
PI O
   p      *      ! 4    !      !   4     
R0n O
 `        d 4
 
Rpn O
  >       
R0n XO
  	     O  d 4
 
Rpn 0O
 `        4 Rpn O
     p        4 Rpn N
     0 ^     y  d 4
 
Rpn N
        7 	 	b   
 n N
       c  R0n hN
         R0n @N
  1     L  R0n N
 p        
 n M
       S  R0n M
 p        R0n M
  !     <  R0n xM
 `       s st 
 ! 4  Z @ !    Z @ " "d 4	 Rpn PM
       0 t          " "d 4	 Rpn (M
        4     B     Pe?h 841 &c!& p`PI  M
          1      ' 'd #T 4  
p  n L
              0 x         z } }  x 0! h  }  !    }  3	 %40 ( p`P  I L
 :      0          U    d     @ `0P  ! I H tF   8 !     8 !   I  H  tF   8  "p0  !    d T
   6  !     6   d 4 p! t d 4    !       4* 	( p  n L
   S      = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x `   !   `   * * h  !   j  !   x j    !   j    !    j  @
 @ , "   ! x P  P !   I h ! h I  | !   I  | !    I h !   P  P 9 9 !x 
 !  h  e  !  e   !     !      !   e   !    e  9 9 &x h 
  !    T !    h !     h !     T   0  ' / p`P0I `L
 b  
 
     D     ' 't #d 4 
Pn 8L
 0     <           
    
     ;  d Rp! T	   X ! h 
 4   d !     d !     X /
 /t" +d! '4   
P  n L
     `      c )
 )h
 $t  d T 4    n K
 P  U      ! T  
 H !    
 H  d
 T	 4 Rpn K
       . =     Y !" "t  d 
T 4 0 W  !   0 W  ! t  
d 4    !      !" "t  d 
T 4 p   !   p    Bp
`  !$
 $  
 
T	 4  , 4! !    , 4! ! t  
d 4    !      + - 	p`P0I K
 R  ! r!     !    !    "    + - 	p`P0I pK
 R  `" "     "    #    f#     2pP!
     
d 4	 # # 0" !   # # 0"   P!   t d 4 & 0' p" !   & 0' p"  
R0n HK
 @( y(     (  d 4
 
Rpn  K
 ( )     {)  4 Rpn J
     * >*     Y*  @ 
	`P  ! > t? 4F  0 60 0# !    0 60 0#  " P   R0n J
     2 2     3  
 n J
  3 T3     3  R0n J
 3 3     3  R0n XJ
 4 q4     4  R0n 0J
 4 4     4 " "d 4	 Rpn J
 5 T5     b5    5 " "d 4	 Rpn I
 5 6     "6    p6  4 Rpn I
     6 6     6 " "d 4	 Rpn I
 `      7 T7     b7    7 IE;h 7t! 0d  )4 C 
PI hI
      7 <8     8    : W
 Wx 8h  4J B 
p	`P  ! I P: : % !   P: : % U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4  `E E  !   `E E  !  t d G G  T !   G G  T !  t d H I  T !   H I  T  p  ! 4 @L TL & !' '  d TL qL & !   TL qL & !   @L TL &  . `P  !p ph :* /+ $, t- 44 M M <' !   h  *  +  ,  t-  44 M M <'  
R0n @I
     0P iP     P  d 4
 
Rpn I
 P Q     kQ  d 4
 
Rpn H
       Q Q     Q    Q  d 4
 
Rpn H
       R `R     vR    R  
 n H
 T $U     sU  R0n xH
 U U     U  R0n PH
 U AV     \V  T 4 `  ! t V V  ) !   V V  ) " "d 4	 Rpn (H
     W $X     2X    X " "d 4	 Rpn  H
       * X X     X    @Y Pe?h 841 &c!& p`PI G
       `Y Z     ] 3	 %49 0 p`P  I G
 z  @     L    X    d    p    |            ] k^     ^    ^    _    ]a    la    0
E"h t d 4 C
P  XI `   /
 /t" +d! '4   
P  n G
 f !g     g /
 /t" +d! '4   
P  n `G
  i ai     j O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4 t t  !   t t  ! t  d 
T 4 pv v  !   pv v  " "4 
p	`Pn 8G
 `x x     y Ne=h 6t< /d; (4: c4 
PI G
          z z     {    ~     ~  	  h d 4  p  n F
          t d 4  t T 4 ! d  ! - !    ! - " "d 4	 Rpn F
               ` 
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h  % - !    % - 	 	2p0!  
d	 T  ѓ - ! 
 ѓ  - !   ѓ  - !    ѓ - !" "t  d 
T 4    !       T `  !
 
t 4   l. !     l. ! t    !      9 9 "% p`P0!{ {	 m
 X I =
 1   x h p  . !   p  . !   	  
      
      x  h p  . 
 
0!,
 ,  ( t d T  ګ X/ !    ګ X/ <5.h *t #d 4 3
P  I F
 R      D         ) )d: %49 2 	pP  n pF
        t       d 4
 rpn HF
       >    O -	%t d
 4 #P  I  F
 B        p O     ` , ,1 pP!I Ih :+ ', #- . 
d/ 40   0 !     0 L L 7 " p`P0!| | g C 9 	 x
 h  -  1 !    -  1 1
 1h -4# ! p
`P  n E
                 0             p
 ph hd+   
p0P  !  t d    T !      T !d d	 [
 O B 9
 0 $ x h  D . !    D . !   	  
      
      x  h  D . ! !dK !4J !B pP  ! h  I   7 2 !   h    7 2 !     7 2 '
 'tK 'dJ '4I 'B P  !* * ! x h  @  2 !   @  2 !  t d   L  T !     L  T      T 4 
R	p`n E
     p        T p  !
 
d 4 p  3 !   p  3 /
 /t0 +d/ '4. ( 
P  n E
     p       /
 /t0 +d/ '4. ( 
P  n E
  N     )  9 
0P! 5 6 t7 d8   `4 !     `4 !   6  t7  d8   `4  	  h
 d 4  p  n XE
      0      BE1h *+ #* d) 4( C	& PXI      ! t d 4 p   5 !   p   5  d
 T	 4 Rpn            	 "  z    
 n  n  P  
 
4
 
rP t	 d 4 2z     
 ,      d 4 2pz     < C     	 4 rp`z     K _ K  rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!    [ |6 !. . 	 [  6 !	 	   6 !     6 !   [  6 != =2 *3 4 4=   7 !     [ |6  B  ! 4 @  ,7 ! t  4 @  ,7 !   @  ,7  20 R0
 
4 
2p 20%	 4- $ 
p`P  XI   " "t 20 % XI    B   B  
 
4 
Rp 20
 t
 d T 4
 r B   B   20! 	 t 
d T ( ) 8 !   ( ) 8  20
 
4 
2p d 4 2p 4 p R
pP0! d
 , , 8 !   d
 , , 8 !   d
 , , 8 !   d
 , , 8 
 
4 
2p! d `/ / 8 !   `/ / 8  20 d	 T 4 2! t @1 1 9 !   @1 1 9  20
 
4 
2p 20u ut 
4 
2`
 
4 
2p 4 2
p`P 4  d 4 2p
 
4 
2p B  ! 4 `< < 9 ! t  4 `< < 9  B  ! 4 @= = 9 ! t  4 @= = 9 !   @= = 9  B  ! 4  > y> 8: ! t  4  > y> 8: !    > y> 8:  B  ! 4  ? Y? |: ! t  4  ? Y? |: !    ? Y? |:  B  ! 4 ? 9@ : ! t  4 ? 9@ : !   ? 9@ :  B  ! 4 @ A ; ! t  4 @ A ; !   @ A ;  B  ! 4 A B H; ! t  4 A B H;  B  ! 4 `B B |; ! t  4 `B B |; !   `B B |;  B   B   B   B   B   B   B   B  U UT	 P4 t d
 2 d T 4 p T	 4 2p!  d F  G 0< !   F  G 0<  2p 4  bp`  !) )     
T 4
 H I x< !   H I x< 
 
4 
2p T 4 Rp`! 
 J K < !   J K < G G4 d T 2p B   T 4 R
p`
 
4 
2P!
 
t d  O 5O 0= !    O 5O 0= !   t  d  O 5O 0= !   t  d  O 5O 0= 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !   Y IY = !     Y IY = !H
 HT : 5t
 0d	    Y IY =  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p
 t d
 T	 4 R d 4 2p! T 0i i > !   0i i > 
 
20 d	 T 4 2p!  k  l > !   k  l > !    k  l > !   k  l >  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d s dt ? !   t s dt ? !   s dt ?  t 20 20 d
 T	 2
p! 4 v v ? !   v v ?  b   t	 d T 2! 4 w x ,@ !   w x ,@ 	 	B   20 20 20
 
d	 
Rp! 4 `{ { @ !   4 `{ { @ !   `{ { @  t d 4 2 t 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p 2p! 4  ̈́ `A !   4  ̈́ `A !   4  ̈́ `A  B   d 4 2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	  ׷ C !    ׷ C  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	   W  D !     W  D  B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
Pn                p                          U      2P'
 '4 
p`Pn        0 ]     q    .      2P6 (4   
p`P  I     .     "    T    h    `            <    J        F                    "    *    4      2P, ,4"  
p`P  n 0 l                                               2P'
 '4 
p`Pn X       `          ^      2P, ,4"  
p`P  n           #    /       Y    b    n    "    f          2P'
 '4 
p`Pn  G     ;                 2P- -x )h %4 
p	`Pn  |     p `                2P' d 4 pI  j    0 ]      2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 4 
p`PXI P   
 
4 
Rp9
 +t! 'd  #4  
P  I                		 		     		    		    	    e	     	 9
 +t! 'd  #4  
P  I H              
	 
	     
	    
	    	    u	     	  d 4 pn p       	 	     	    	     	  d 4 pn  +     7 `	 	     	    m	     	 9
 +t! 'd  #4  
P  I     C     O    [ 	 Z	     m	    }	    {	    	     O	 9
 +t! 'd  #4  
P  I     g     s      	 j	     }	    	    	    	     _	 9
 +t! 'd  #4  
P  I               0	 z	     	    	    	     	     o 	 *
 *4 
p`Pn 8       @!	 !	     !	    %	     &	  t d T 4 9
 +t! 'd  #4  
P  I `                  @/	 /	     /	    /	    /	    Y6	    6	    f7	     7	  B  
 
4 
Rp, ,4  
p`P  n               h    h    h :	 :	     :	    :	    ?	    ?	    ?	    !@	    E@	    q@	    (D	    RD	     |D	 	 $ 
p`0  n       '    3                           O @           ? X   D	 E	     E	    E	    NF	    F	    vK	    K	     K	 ?     L    s     
 
rPn  
 
4 
Rp
  
	p`0P $ 
  !v vT" $   t  d! 4# ``	 ~`	 xP !    ``	 ~`	 xP !   ``	 ~`	 xP !         t   d!  T"  4# ``	 ~`	 xP  T
 4 rp`  
  !m m bT   t d 4 v	 v	 Q !    v	 v	 Q !   v	 v	 Q !         t  d  T  4 v	 v	 Q  T
 4 rp` B  !6
 6 1t )d
 
T	 4 p	 	 Q !   p	 	 Q ! 
    t  d
  T	  4 p	 	 Q )	 !  p`0  n                                          xR @            8   0	 q	     	    	    	    	    r	    >	    Z	    y	     	               
 
2Pn   d T 4 p*	 *4  p`  n                                   |S @            8    	 =	     L	    	    	    Ϛ	     	          ?     
 
2Pn   #
 4 
p`PXI X    	p`P0XI `   
 d T 4 p t d
 T	 4 2 	p`P0XI X    BP  !; ;t
  
d	 4 Ш	 ߨ	 |T !   Ш	 ߨ	 |T  20!
 
t d  	 H	 T !   t  d  	 H	 T    !2 2 '	  t
 d T 4 	 	 T !   	 	 T 
 d T
 4 rp% e PXI   ! 4d &_ ` a tb dc 	 	 LU !   ` 	 	 LU !   	 	 LU !   _  `  a  tb  dc  4d 	 	 LU #
 4 
p`PXI `   D
 Dt d	 T 4 2
 d T 4 p   XI    !$ $  t d T 4% 	
  

 $V !    	
  

 $V !   	
  

 $V 
 d T 4 p
 
P  !( ( 	 
 t 
d 4 0
 :
 V !   0
 :
 V  bP  !$ $   t 
d 4
 
 	
 V !   
 	
 V  T	 2! t d 4 !
 !
 $W !   !
 !
 $W  2
p`0! 
 
 T
 p$
 $
 \W !    p$
 $
 \W !   
    T
 p$
 $
 \W 
 t	 d T 4 2 20 20 d 4 2p t d T 4 #	  
p`0  n ( M     Y    h    h    h           e                    X @            8   p-
 -
     -
    3
    3
    4
    @4
    o4
    4
    75
    I5
    \5
    67
     g7
                2P
 
2Pn (  d 4 2p)	 !$ p`0  n P                                       M           h    h    h                                             <Z             PZ    
         dZ             xZ @            8   @           m 8   @            8   @            8   P8
 8
     8
    8
    _>
    t>
    >
    >
    >
    C
 	   3C
    ZC
 
   C
    C
    C
    2D
    AD
 
   VD
    H
    H
    cM
    M
     M
          ?     z                       B      2P
 
2Pn P  2P
 
2Pn P  2P
 
2Pn P 
 
2Pn P  4 
p`PXI X    d 4 2p6 (40 & 
p`P  I x *  \     P            h `R
 R
     R
    S
    S
    Y
    Y
    Y
    `Z
    Z
      2P6 (40 & 
p`P  I  *                   h Z
 5[
     U[
    [
    [
    b
    Bb
    b
    b
    #c
      2P; -x )h %4, " 
p`P  I               c
 c
     c
    d
    
    
     ;
 
 + 
	p`0P9
 +t3 'd2 #41 * 
P  I  J         Q     `           20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   d T 4 2p bP  !$ $   t 
d 4
 # # _ !   # # _  T	 2! t d 4 & & ,` !   & & ,`  2
p`0! 
 
 T
 `) ) d` !    `) ) d` !   
    T
 `) ) d` 
 t	 d T 4 2 20 20 B    n                        $a 	    (   & 8   	   + 0   _ 8   	     8    8   	    @    8   	   xE H   - 8   	   	 P    8   	   < X    8   	   = `    8   	    h   z 8   	   . p    8   	    R x   2 8   @           k 8    0 00     G0 &     3    Q     l                           :    {                       +    l                  $     ?    ]     x         
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn   B  # 4 rpI @ 2    0 0     1 1	 #t! d  4  P  I h                                      , 1 1     .2    S2    |2    2    2    2    /3     3    3    
4    /4    @4    S4    ]4      2P d
 4 
Rpn  8 4 4     5  20 B  ? .4  
p`P  I  :  D     P    \    h    t                     	    
            
               (    4    @    L    i    u                                             	 !        ! #   - 6 W7     g7    a9    9    :    8:    :    : 	   : 
   :    ; 
   ;    ;    ;    y<    <    <    
=    F=    =    =    =    =    2>    >>    >    > !   > "   ? $   9?    o?    ?    ?    h@    @    @    @     @  2P 20   ! 4
 C C g !   C C g    ! 4
 D (E g !   D (E g 
 
4 
2p 2p! 4  G BG ,h !   4  G BG ,h !   4  G BG ,h !   4  G BG ,h !   4  G BG ,h !   4  G BG ,h  B  
 t	 d T 4 2        h 	x    h 	x       $     i                    8i n xj                      	                             0         8   <                 @     m                    xk l Pj hr xj v m                                     (          K                  P     8w                           w                     hI         (   `d                  R            `                       (u                     ,            )                      (n                    n r xj                      (          =                A         X                   `         h    c                      l                    Pt hu r xj s u                                             =                 /         @   `                      Hn                              8   =                q p @r r xj s u                                      9         P   c                       q                    hs w xj                           k                              @                    `i hr xj                    n xj                      P                           (     Pv                             X   @(                hl k xj                    Pk u t (k xt u                                       u                     xE            e                             K                              >                PV         X   0P                       m                     @1         8   ;                 F         @   P                v xj                 2         X   h                o Xx hs w xj s u                                           8t                     p     o                    r w xj                          k                           s                     0)         @   (                 %         @   `                              p>                (         X   @                       v                    @s w xj                    )         X                         s                            w                                 0                  =            >                 +            6                              v                 0         X   `                 `         8   =                n w xj                    hr xj                 <            b                  @            P                `o n xj                           (s                             (   C                 g     o                     @     w                    w xj                L         X                     R (          `                           (   C                 b     i                            w                    u r xj                    v  l n w xj s u                                     
         @   P                      @                          .            0?                 #         @                    	         8   p?                       m                     n p j r xj s u                                    1         X   о                @r r xj                      (       (   C                r  q xj                    r xj                o o w xj s u                                       pp                     (            _                 r 0x r w xj s u                                    Hq Xm t i xt u                                 P         @                    I         @   h                 [:#[    x          x x x  
y   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330.cp36-win_amd64.pyd PyInit_stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_8347890744695566330           Z   {         6  Pz         h   }         x h `           X~         Ω                       p ~         0 0 ~         P  @~         r                          D     j                         ̤     ܤ                    0     D     `     ~               ¥     ֥                    6     R     R                       J          
     N          ؘ                    p     .               F          ֓               h               ڑ          :     ^                    Ғ          4     ̗     D               Σ          z     T     6          ڢ               l     F     
     ȡ          D               t     ,               l          ޞ          H                |     6               j     *               |     (     Ԛ     h               N          f                                 Ȧ     ڦ                     8     B     X                    v                               Ȩ     Ҩ     H                  §               Ϊ     ֪     ܪ                                   ƪ                            |     d     H     ,     
          ި     ܧ                             d          P     4     *     x               ԧ                  Z          n     ʧ                  >                       r     V     B     ,                    ܍     ƍ                    ^     L     >     ,                    ތ     Ό                         r     d     P     B     ,                    ڋ                         h     T     :     $                     ފ     Ί                              ^     P     @                         ։                         t     \     F     8           
               Ј                    x     h     N     :     *                    ڇ                    |     h     N     6                                Ȇ     ʎ          $     6          F     b     t                              Ώ     2     z                          4     H     ^     J     \     r                    Ȑ     ؐ                    $     B     <     ܎     v     *                    څ                    x     ^     J     :     &                             PyBaseObject_Type qPyObject_SetAttr  PyUnicode_InternFromString  ? PyCFunction_Type  4PyOS_snprintf PyThreadState_Get V_Py_CheckRecursionLimit  PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches _PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  PyExc_RuntimeWarning   PyErr_PrintEx [PyFunction_Type JPyFrame_New PyLong_AsSsize_t   PyExc_DeprecationWarning  PyExc_KeyError  zPyImport_ImportModule |PyImport_ImportModuleLevelObject   PyErr_NormalizeException  QPyUnicode_AsUnicode oPyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  qPyUnicode_DecodeUTF8  SPyObject_GenericGetAttr PyTraceBack_Here  _PyThreadState_UncheckedGet PyExc_RuntimeError   PyExc_IOError rPyObject_SetAttrString  PyLong_FromLong RPyObject_GC_UnTrack PyUnicode_FromUnicode _PyObject_Hash  PyErr_SetNone 
PyExc_MemoryError  PyDict_GetItemWithError Py_GetVersion XPyObject_GetAttr  9PyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags * PyBytes_AsStringAndSize m_Py_NoneStruct  PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size <PyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable \PyObject_GetIter  PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx )PyExc_ValueError  W_Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError mPyObject_RichCompare  PyTuple_Type  b_Py_FalseStruct u PyCoro_Type APyFloat_Type  PyMethod_Type PyLong_Type PyType_IsSubtype  PyNumber_Subtract  PyErr_Restore PyExc_OverflowError vPyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  F PyCapsule_GetPointer  PPyObject_GC_Del  PyErr_Fetch CPyObject_CallFunctionObjArgs  PyLong_AsLong IPyObject_ClearWeakRefs  iPyObject_Not  PyUnicode_FromFormat  ZPyObject_GetBuffer  PyList_New  PyModule_Create2  PySlice_New iPyImport_AddModule  !PyType_Ready  YPyObject_GetAttrString  q_PyGen_Send  PyErr_Clear PyList_Append 6 PyBytes_Type  _PyUnicode_Decode  W PyCode_New  2PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  APyObject_CallFinalizerFromDealloc ;_PyDict_GetItem_KnownHash cPyObject_IsInstance PyNumber_Index  PyExc_StopIteration PyList_Type  PyDict_GetItemString  [PyObject_GetItem  FPyObject_CallObject  PyErr_CheckSignals  QPyObject_GC_Track 3 PyBytes_FromStringAndSize wPyImport_Import PyExc_NotImplementedError YPyUnicode_Compare dPyObject_IsSubclass !PyExc_TypeError PyMem_Realloc > PyCFunction_NewEx N PyCapsule_Type  ePyObject_IsTrue PyExc_NameError PyTuple_Pack  _PyByteArray_empty_string Py_OptimizeFlag ?_PyUnicode_Ready  PyMem_Malloc  PyExc_IndexError  PyExc_ImportError fPyGen_Type  t_Py_TrueStruct  
 PyArg_UnpackTuple PyExc_SystemError  PyExc_AssertionError  sPyObject_SetItem  _PyObject_GC_New  
PyTraceBack_Type  PyMethodDescr_Type   PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  _PyType_Lookup  tPyObject_Size  PyBuffer_Release  ?PyObject_Call ' PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python36.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 1EnterCriticalSection  LeaveCriticalSection  
DeleteCriticalSection SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  vGetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  iSetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  ~IsProcessorFeaturePresent wIsDebuggerPresent AQueryPerformanceCounter GetCurrentProcessId GetCurrentThreadId  GetSystemTimeAsFileTime DisableThreadLibraryCalls aInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                                                                                                                                                                                                                                  2-+  ] f      /                              0`   H`                   Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
                       8a                                   0           Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

                                       p                                                           	                                          W                   p                                                                                                                    @                                                                                                                                                                                                                            
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         Transform parameters from unconstrained space to defined support                hm          t                      xm          H              m   m          h                                                                                     `N   p                                                                                                                           D     N   P                                      0                                                                                                                                                         P   *
                  P   !
                  P   
                  A    
             P   
             N   
             P   p	                  P   @	              Q   p	                  Q   0	              Q   	              0Q    	          @   HQ   	          `   hQ   u	             Q   P`	          0   Q   K	             Q   D	          0   Q   :	                  Q   P9	                  Q    9	                  Q   8	                   R   0/	                  R   &	                  0R   0!	                  HR    	                  `R   	                  xR    	                  R   P	                  R   	                  R   
	                  R   	                                                  Transform parameters from defined support to unconstrained space                Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       Pl   P2          l   =   +          l   >   `/          Xl                                   
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

                                                     X           a                                                                   0                                                   Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                                             n   x               )                                                                                                                   @             P+                   8               0                                                                                                                                                     (                           V                   0                                                                                                                    @             Ы   `                                                                                                                                                                                                      
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
              m   (   `(   m           m   @(   '    n                                                   *   PR
                                                 V                                                                                                                                        @                                                                                                                                        Ъ                                                                                   \                                                                                      R                   Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
           Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                                         S   p                                                  	              p                   	                            D     S                                         0                                                       +
           p                                                                                   M    /                  M   &                  M   #                                                  M                         M                            `                                               <   @                             `                   t;   @                      N   н   P                   N                         (N                         8N      p                   HN   P                                                               ,    N
                     Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
           R                               DB                          R   `                            p                   S   P   б                   S      0                   (S                         $G   p                         Я   P                   8S   0                      HS                         DM      p                                                                                          0W                                                                                                                                       @                                                                                                                                    0                                                                                   Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.               d   P                        k   
                        h                            i      (                      c      &                      d      &                      c                           i                           h                            g      <                      `c      #                      @l                           `j                           Pj                           c   (                        d   0                        k                            l                            i   P   $                      hi                           j                           Xg   $                        i   @                         j   X   
                     `d      	                     e      %                      i   P   (                      g   p   A                      j                           g                           xe   x                        `g                           d   x                        pi                           Pl   0                         e                           c                           8d                            8i   8                        h                           i                           @e      	                     8e   (                        c      
                     (i   x                         `   (                        pc   x   
                     (h   4                        d   `                        `                           e                           f                           g   8                        @i                           c   |                        g   @                        (k                           i      	                     pd   \                        j                           g                           Hd   D                        h   x                        l   p   
                     e                           i   `                        h`                           d      
                     hj                           i                            j      L                      k   0                        k                           d   (   
                      k                           xc      	                      hh   x                         e                            8`   `                        h   P                        d                           H`                            j   
   +                      xh      
                     k                            Hi   ,                        k                            i                           l   L                        d      
                     hc                           i                           g                           hg                           h       
                     g   t                        Hg      
                     `i   ,                        h                           8a                           0j       
                     c                           d   P   
                     d   h   
                     i                           h      
                     P`   `   	                     Pg                           0h       	                     e   0   
                     j                           g   (   
                     Ph   h                        X`                           j   x   .                      g   T                        pe                            0e   (                        j   X   
                     f   
                         e      	                     Xe   @                        (g       
                     f   X                        Pd                           8h                           h   0                        xg                           g       	                     l   x                        (d   p   
                     k      
                     pg                           `h                            d                             i   h                        f                           h   4                        Pf                           (l                            hf   8   "                      0d                           pk   <                        k        x                      h                           pj   8   '                      Xh      "                      He                           c   x   
                      g   l                        e   @                        0`                           a                            j                           d                            Pa   8   	                     c                           (e                           `   4                        k   t                        i   H                        0i   `                        Hf                           @f      
                     x`                            k                           xd                            (j                           d                           k                           d       
                      h                           j                           e                            e                           @d      
                     j   X                        @j      	                     h                           g                           e   h                        e                           xi   @                        d                           h                           e                           j   H                        g   8                        e   8                        k      H                     @g   @                        k      	                     `e                           @k                           i      
                     f                           d      	                     8g   
   	                     Hl      
                     g                           he                           k      	                     h                           e   h                        g      
                     0l   
   
                     xk                            c      
                     k                           j      	                      c   P   %                      (`                           i                           c   ,                         hd   $                         g                            d   H                        f                           Xj   <                        d                            g                            c   p                        0g                           8l   $                        h                           Pe   H   	                     c                                                                   0`   `   8`           X`           h`   `   a           X`           (`   `                   0`   H`                   0`   `                   0`   Pa   X`   H`                   h`   x`                   (`   `   P`           u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                         .?AU?$located_exception@Vexception@std@@@lang@stan@@               .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                         .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x29fd2c7f@math@stan@@                          .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVlogger@callbacks@stan@@                        .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@               .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                 .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AVlength_error@std@@                     .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVdomain_error@std@@             .?AVcovar_adaptation@mcmc@stan@@                           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .?AVexp_vari@?A0x29fd2c7f@math@stan@@              .H                         .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AVanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@                    .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                 .?AVbad_exception@std@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                           .?AV?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@                      .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@                     .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVbad_typeid@std@@               .?AVop_dv_vari@math@stan@@                 .?AVps_point@mcmc@stan@@                   .?AVadd_vv_vari@?A0x29fd2c7f@math@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@             .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AUbad_exception_@exception_detail@boost@@                .?AV?$adapt_unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$numpunct@D@std@@             .?AVvari@math@stan@@               .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AVdump@io@stan@@                         .?AV?$unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@                      .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@             .?AVrounding_error@math@boost@@            .?AV?$diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVunderflow_error@std@@                  .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@               .?AVsum_v_vari@math@stan@@                         .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVempty_var_context@io@stan@@            .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AUPyErr_CheckSignals_Functor@?A0x29fd2c7f@pystan@@                       .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                          .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AV?$adapt_dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVdivide_vv_vari@?A0x29fd2c7f@math@stan@@                .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AVchained_var_context@io@stan@@                  .?AVfacet@locale@std@@             .?AVmultiply_vv_vari@?A0x29fd2c7f@math@stan@@              .?AVdiag_e_point@mcmc@stan@@               .?AVfixed_param_sampler@mcmc@stan@@                .?AVout_of_range@std@@             .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                   .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVbase_mcmc@mcmc@stan@@                  .?AVsubtract_dv_vari@?A0x29fd2c7f@math@stan@@              .?AV?$adapt_dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             .?AVdense_e_point@mcmc@stan@@                      .?AV?$dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                 .?AVneg_vari@?A0x29fd2c7f@math@stan@@              .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVsum_values@pystan@@            .?AV?$adapt_diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@                       .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@                     .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AVprob_grad@model@stan@@                 .?AVdivide_dv_vari@?A0x29fd2c7f@math@stan@@                .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AV?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVexception@std@@                .?AVadd_vd_vari@?A0x29fd2c7f@math@stan@@                           .?AV?$adapt_diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVmultiply_vd_vari@?A0x29fd2c7f@math@stan@@              .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                        .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AVwindowed_adaptation@mcmc@stan@@                .?AVvalue@pystan@@                         .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AV?$adapt_unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                                                                                                   V   `             >   @  ^               
   0            F   P                        V   `                                            &   0  F   `        #   `       %   0  p    p    $   y  @      P        M$   p$  $   $  $    %  +%    0%  T%    `%  w&   &  '    '  o'   p'  )    )  	*  8 *  *  P *  +  P +  4,  h @,  ,  h ,  $-   0-  .  x .  9.    @.  i.    .  .    .  v/   /  /    /  ;0   `0  0    0  0    0  0   0  1   1  1   1  2  P 2  2   2  3   3  3   3  ~4   4  4   4  n5   p5  5    5  6   6  P6    `6  6    6  6    6  7   7  G7    P7  7   7  7     8  G8   P8  8   8  9   9  :  ` :  ;   ;  <   <  q=  @ =  >  x  >  K>    P>  o?  h p?  ?    ?   @    @  @   @  @   @  B    C  4C   @C  =D   @D  F  @ F  G  P G  K   K  K    K  7L    7L  L   L  L   L  M    M  |M   M  M   	 M  P  (	 P  Q  <	  R  ?T  L	 T  T    pU  V  \	  V  V  	 V  W  	 `X  Y  
 Y  Y  P
  Z  Z  
 [  r\  
 \  1]  
 @]  ]  0 P^  ~^    ^  _  h P_  ~_    _  _    _  `   `  nb   pb  b    b  b    b  c  8 c  hd   pd  e   e  e     h  
i   
 i  j  
 j  "l  
 0l  "o  
 0o  \o    \o  o   o   p  (  p  p  < p  p  L p  p  \ p  8r  x @r  ^s  
 `s  u   u  u   u  u   u  pv  , pv  v  @ v  v  P v   w     w  w  ` 0x  x   0y  y   y  ~    ~  <~    @~  ~   ~  P   P       ہ             H         ΃  X Ѓ  ΅   Ѕ                    @    M   P  ۔           7   @            }  ,     <   ݝ      M    P    x                  П          (     @   W    `        $   0                 =   =  ʩ   ʩ  Z   Z        Ū   Ū  ۪   ۪  k  , p    L     T     p   #   #  Z   Z            <   @                       .   .  o  0 p    H   ȱ  T ȱ    l   !   0    L   8   8       /   0  i   p       ƶ   ж                   b   p  Ҿ       p    5   @                 "    B  "   b  P# p    h# @  ;  # @    %     P%     \%     x%   :  % :  I  % `          %     &     &    y  &     &   ;  & ;  T  & `          &     '           (   \  ( `    (     (      &   3  () @  X  <) X    L)   <  `) <    p)     )   !  ) 0  >  * @  z  p* z    *   Q  * `    *   E  <) P    *     *   ?  * ?    *     +     +    "    0    p+   A  + P    +     ,   k  H, p   x,   ,   -  ! P- 0  P-  3	 d- @	 
 |-   -  | P.   *  4 <) @ v *   *   d.   .    .   /   { 8/   h/              /      P   P        A   P 
 /  r      R  `     -  0 d  p   h      0   C! 0 P! !   ! !   " 4"  @" . h . / @1 / N4 p1 `4 4   4 ; 2 ; < 2 < = (3 = = X3 = =   = o> 3 p> >   > >   > 0?   0? p?   p? ? 3  @ V@  `@ @  @ A   A vA  A A  A <B 3 @B B 4 B C H4  C C p4 C C   D D   D xE 4 E i `5 i k h  l &} < 0} < B @  C  + C 0  E  Đ  А  h  $ x 0  `G    G       h   o H p    ɗ  З     )  0 Ș 8H И  H    hI  L 0J P  J   J   J   PK   
 L   L  R  p      L   6   @  L  ֫    4 L @ v    Ԯ L       t L  : L @      h  7  M @        A M A  M   M   M   4   @  M   M   M   |    /  T / ` ú  к            |      g   p  x    N   N  ӿ $N         T N `  N   N   N   O    (O   XO   O  j O p  O  V O ` . O 0 # P 0 $  0 ` HP `     0  0 H x H  P   P  X P `     x  U dQ U c xQ p    0  M  " Q " l Q l { Q   M    Q   4 Q @    V  ` L  P h x h  Q   Q       K  P       z      W h `      R      !   0        )   0  (R    <R   ] PR `      R   R     \ R    S   C  P     S  V pS `        S    T   T   T  T ,T   <T   HT  ( \T ( a |T p       ` h `  h      Q T ` 	 T          "  0  N   g  p 3  U @    B  P    " |U 0     R  `    Q  ` 	 U   N   dV   xV   V   dV  z V z  V      V    V  b  p     c  p            U  `    A	 (W P	 	 @W 	 n
 h p
 R hW ` D h P q W  F  P J h p  h   W   W   W   ; W @     y W   0X    h  g <X p 1   @     X   X  d  p   p$ $  $ b%  p% %  % & X & ' X ' R(  `( +) X 0) ) X  * r*  *  + O  + r+  + d, 8Y p, F- HY P- - O - .  . / X  0 n0  p0 5 \Y  5 9 pY 9 Y: Y `: :  : A; Y P; p;  p; < Y  = @ Z @ #A Z #A A Z A A Z  B xB Z B B Z  C C   C D X `E E  [ E G [ G -G $[ -G G 4[ G G  [ G MI H[ MI ]I \[ ]I I l[ I I   J L [  L )N h\ 0N DP H] PP P   P Q W  Q FQ (^ FQ Q 8^ Q Q P^ Q [S `^ `S [T ^ `T T  T U ^ U eV O pV V  V W _ W @X `` @X Y ` Y nY  pY Y `  Z bZ  pZ Z ` Z \ @a \ \ pa \ J]  P] ^ a ^ ` a  ` a (b  a Kc hb Pc Md b Pd d  d e  e de   pe e  e &f   0f f   f f   f Fg   Pg g 0c g g c g h  d h Fh hd Ph h d h h 8e h i e i Fi f Pi i pf i i f i j @g j Fj g Pj j h j ^k xh `k (u h 0u u j u u j u u j u Ww j `w  k   Xn  6 (o @ p o p  p   q   s   s   t  y t y  t  ۼ h  7 h @ H t P _  u ` 9 Xu @ _  _  lu   u   u   u  & u & 2 u 2 ? u @  h   h      H u P  (v   L   `      Xv     ^ v   v  ~ (w   w   w   w   w   \ w `  w   J  x P  Px  L xx  7 x P  Y   $y   h  o y p  y  +  0 R   `  z      c Hz p  O  t    Y   x z   z   ,{     @   @ _  `  D{   {     |   p|  [ | ` $ | $ x | x   }   }   ,}    }  C } C  }   }  P   P  ~   (~  U `~ `  @      I   P   8     	      F  P o  p   	      R  `      `  '   ( (8  08 < 8 < =  = ? P ? @  @ B Ȍ B E   E KI  PI J  J @L H @L ~M  M 0O  0O R   R U p U [   [ 6`  @` vt P t   Ї     P      # @ #  L   d  ٙ t  ~        . x .       ՛    x      ؚ  +  0 > x > ȝ   ȝ ɝ  ɝ  (   Y @ ` s @ s       )  p     8 h @  М   h  ĥ   Х  8   L  } d    t   ߩ  ߩ Գ  Գ  ԝ  Ľ  н <  @    Ͼ   о X @ `  h   ?   @        x           ,   0 |                 X  `     Y  `        @   w          V   V           0 w    0           i  p     _  ` P  P V $ ` } 8 }  H   `  &  0    t p  "  @            ̣      E  P        (  ^
  `
 J  P    6  @ *
 8 0
 z
 ` 
        
 ا       (  9 8 9 p L p  Z    \  J  P    :  @           .%  0% 2  2 
B  B N   O O Z O Q   Q ~Q ( Q Q   Q R & R S 0  T \  \ ] p ] _   _ _  _ c  c e ط f *g  0g Kh ( Ph l ` l m  m 1n ( @n n p  o ho  po p 8 p >q H >q 
r \ 
r r p r Ms  Ms ns  ps u  u cz  pz ~   ~ ā   Ё        Ń  Ń     н      d  p  *  ̇   ̇ )  ) /           5   5  ,  ɉ @ Љ  P  ؋   ؋ >  > e  p    ߍ      t  t  ȿ  ӎ ؿ ӎ    #  0    t | t Ȗ P Ȗ  h  ϙ | Й Û  Л ?  @                  7 $ @  4  ? x @             k  k    Ш < Ш       Z p `  H  Y < `     b  p     G  P 
 (  k  p     X   `     @     6  @    2 0 @  H   p  E&  P& &  & #-  0- -   . .   . M8  P8 e8  e8 8  8 8  8 c;  p; ;  ; ;  ; &<  0< N<  N< <  < < 8 < > H  ? C h C D  D `Q  `Q T  T a x a  b   b b 8 b b    c c h c Qd  `d d  d e () e f    f vf   f f   f 6g   @g g  g h   h h   h ^i ( `i i  i j X  j _j  `j j  j uk  k k  k fl  pl l 0 l n X n p  p ,s xh ps t H t u  u Dv   v v  v ,y  0y Gz  Pz z   0{ w{  { H~ 8 P~         O  P V $ ` ~  ~        /  0  8 Ѓ d H  ބ   1 ̣ @ ; P @  @      ?  @ F $ P B p P Е  Е Z 8 p    0 ^  `  ̣   0  U   `  P  F  P       c ( p    f  p ! ` 0 i N i  h   |  6  @ t       4  @        v      6  @     ϱ Z P f  p ٴ    ĸ P и              i  p  8  F  P      8   h      l  p M & P u    |  L  L    > h @     P      #  #            $   @   T  S d ` l  p    "  0  x     '   0 O  P _  `    
  
  P           "   # ( $ ( ( D ( i)  p) )  ) j4 4  p4 5  5 8  8 9  9 W< X `< ?  ? 
@ @ @ m@  p@ @ h @ C  C 8D  @D F   G G , G G   H TH h `H zH  	 zH I 	 I I (	 I I 8	 I pJ D	 pJ ~J \	 J J 8	 J K l	 K K 	 K K  K M 	  M R 	 R SU  `U U 	 U 7W  
 7W 'X 
 0X `X (
 `X pY @
 pY `Z T
 `Z ] d
 ] _ 
 _ `   a a 8 a  b    b b   b yb H c jd  d d  d vf  f h 8
  h 3i x
 @i i  i k Z  l l 
 l sm 
 m n  n sn  n n   n o ` o p   p s 8 s %s \ 0s u l u v  v ;w 0 ;w  L   p  G  P             8   L  o \ p t p  Ǝ  Ǝ     (   8  l  p  (  ۙ <  2 T @ H l P        ?   ? u  u            E  E            h     ܬ  ܬ Z  Z -  P d  d      4     y D y  X  8  T 8  h  k  p    f  f   P x  T x           (     )  ) /  / 5  @ _   `           X  `  8 0 o  p  h  /  0    J  P  Z      u     (  f P p  x  e  p    V  `    Z @ Z  L   `    Z   +   0  p     ,   0  P  }  }    (  0     8   L   h   x   6  6    ^  ` =                 0   0 O  P            @  d l p [  `    a  a u   j  j     "  " ( 0 ( P @ P  P  I h I  |  |  |          e  e           $   4   D   T   h   |  0  0    D  	 
  
 
  
        &  Q Z ` { W   X   d  F x F U  U V  `       
 H 
 o @  o  T   q d   " Z 0 W  W                /   p    U ! U  $!  , 4! ,  @!   d!     c  t! c  
! ! ! X" ! `" # ! # # 0" # % <" % u& `" & 0' p" 0' ' |" '  ( "  ( ?(   @( ( " ( ) " ) )   ) *  * *  # * -   - / xh  0 60 0# 60 1 D# 1 1 `# 1 2 p# 2 3 |#  3 3 # 3 
4 # 4 4 # 4 5  $ 5 5 H$ 5 6 $ 6 7 $ 7 7 $ 7 G: 0% P: : % : ; % ; = % = =   = >  > ? % ? @ % @  A   A B xh B VE $& `E E  E ZF h& ZF %G |& G G  T G H & H H & H I  T I J & J XJ & @L TL & TL qL & qL XM  ' XM M ' M M ,' M M <' M P L' P P t' P /P   0P P ' P ~Q ' Q R ' R R @( R R  R T Z T U ( U U ( U vV ( V V  ) V W ) W W $) W X 4) X SY p) `Y ] ) ] a  * a a  a a  pe f * f i *  i Mk  + Pk o @+ o s x+ t t  t u + u pv + pv v  v hw + hw Qx , `x y ,  z  P,   ,   \ xh `  ,  ! - ! e  - e  4-  s D-  % - % " - "  -  ѓ - ѓ  -   .  ͔ . ͔ ֔ ,.     ŕ <. ŕ  \.   l.  ԗ x. ԗ ۗ .     [ . [ a . p  .   .  3 / 3  $/   /  ګ X/ ګ  d/   /   Z   G / P  /    /  j 80 p  p0   0   0   0  -  1 - L  1 L  L1  . \1 0  1    T   1  	 2  D . D * 2 *  P2  2 `2 2  P2   7 2 7 X 2 X @ 2 @ = 2 @  2   3   ,3   L  T L  <3  9 X3   H   m h3 p j p3 p  3  ` 3 ` g 3 p  3    4   `4   p4  } 4 }  4   4  l 4 p   5  C  (5 C  w  D5     xh  ! T5 $ \     5   h  ,  , \   \     #   $      h  T   T          	  	 	  	 }	 O 	 	  	 	  	 
   
 
 5 
 u 5 x             /  @ k   l    
 5 
 j 5 l a 6 d  O   h   4   4    y <6 |  H6     8 z  |   	    	   X6  D h6 D g       h  N h   [ |6 [  6   6  + 6 +  6   6   6   7 @  ,7  	 47 	 < H7 < ` `7 p  p7   x7  e  7 p  ! 7  ! " 7 " 	# 7 # # 7  $ k$ 7 $ >% 7 `% & 7 & 3' 7 @' ' 7 ' /( 8 `( ( 8 ( ) 8 ) ) $8 ) ) D8 ) * T8  * @+ \8 P+ + h8 + ~, x8 , , 8 , - 8 - ,. 8 ,. . 8 . S/ 8 `/ / 8 / / 8 / 0  9 0 81 9 @1 1 9 1 2 ,9 2 A2 @9 P2 R3 P9 `3 3 X9 3 4 d9 04 p5 l9 5 N6 |9 `6 8 9 8 9 9  9 : 9 : : 9 `< < 9 < < 9 < /= 9 @= = 9 = = 9 = = : = > (:  > y> 8: y> > @: > > T: > > l:  ? Y? |: Y? x? : x? ? : ? ? : ? 9@ : 9@ X@ : X@ @ : @ @ : @ A ; A 8A ; 8A hA  ; hA A 8; A B H; B 'B P; 'B WB d; `B B |; B B ; B C ; C ,C ; @C OC ; `C oC ; C C ; C C ; C C ; C C ;  D D ;  D /D ; @D qE  < E F < F  G 0<  G G @< G H X< H `H h< pH H p< H I x< I &J < &J /J < @J J < J K < K K < K K <  L L  = L L =  M N =  O 5O 0= 5O O <= O O T= O P d= P P |= 0P P = P TR = R V =  W Y =  Y IY = IY Y = Y Y = Y \ >  \ \ 0> \ ] 8> ] m^ @> ^ =_ H> P_ >` P> P` ia X> `c c `> d ye h> e 'f p> 0f f > f 7g > @g nh > 0i i > i 6j > 6j k >  k k > k  l >  l Nl > Nl |l ? |l m  ? m m 4?  n q D? @q q X? q r `?  s s |? s s ? s dt ? dt t ? t t ? t t ? Pu ?v ? Pv v ? v v ? v mw  @ mw w @ w w $@ w x ,@ x x @@ x x T@ x #y d@ 0y z l@ z wz t@ z z |@ `{ { @ { { @ { | @ | D| @ P| } @ } ~ @ p~ ~ @   s @  [  A p U A `  $A   <A    TA  ̈́ `A ̈́ a hA a Ć |A Ć  A @ ۖ A  Й A   A   A   A  ^ A p  A    A   A   n  B   B 0  B   $B    4B Ъ K @B ` ǫ HB Ы  PB 0 ˬ `B  [ lB p ݭ tB  } B   B P  B  ] B   B 0  B б = B p  B  M B   B 0  B    C   C  ׷ C ׷ b  C b h 4C p  DC   F TC p ݻ \C  } hC   tC  D |C P  C  6 C ` ; C   1 C @  C   C  V C   C   C  f C p  C  I C P  C   W  D W  D   D   ,D   4D   h LD p  `D 0  D   DE  X F `  F   F  M |G ` $ G 0  4H  N pH `  H  . H @  H   H   7 H @ u H   H   7 H @ w H   H    I @ w I   I   I   5 (I   4I   <I   5 DI @ u PI   \I   7 dI @ u lI   xI   7 I @ w I   I   I @ w I   I   I   	 5 	 I  	  	 I  	  	 I  	 5	 I @	 u	 I 	 	 I  	 7	 J @	 	 J P	 	 J 	 	  J 	 	 (J 	 E	 4J 	 	 @J 	 	 HJ 	 E	 PJ P	 	 \J 	 	 hJ 	 		 J 		 ~
	 J 
	 	 K 	 I	 K `	 	 K 	 	 (L  	 	 L 0	 !	  M @!	 &	 M &	 &/	 M @/	 A8	 N 8	 9	 N p9	 u:	 N :	 D	 N D	 K	 tO K	 L	 TP L	 =`	 `P ``	 ~`	 xP ~`	 ns	 P ns	 s	 P s	 s	 P s	  u	 P u	 v	  Q v	 v	 Q v	 j	  Q j	 	 LQ 	 ځ	 `Q ځ	 	 pQ 	 a	 Q p	 	 Q 	 x	 Q x	 	 Q 	 	 Q 0	 Ғ	 R 	 	 S  	 !	 (S 0	 ŝ	 S Н	 b	 T p	 z	 ,T 	 0	 DT @	 ʨ	 `T Ш	 ߨ	 |T ߨ	 	 T 	 	 T  	 H	 T H	 	 T 	 Ӭ	 T 	 	 T 	 ͱ	 T ͱ	 	 $U  	 ]	 4U 	 	 LU 	 	 `U 	 	 U 	 @	 U @	 
 U 
 
 U 
 
 U 
 	
 V 	
  

 $V  

 
 8V 
 
 `V 
 
 tV  
 *
 V 0
 :
 V :
 
 V 
 
 V 
 	
 V 	
 !
 V !
 !
 W !
 !
 $W !
 N$
 0W N$
 g$
 LW p$
 $
 \W $
 '
 lW '
 '
 W '
 (
 W (
 )
 W  *
 O*
 W `*
 *
 W *
 *
 W  +
 ]-
 W p-
 7
 X 7
 <8
 4Y P8
 N
 DY  N
 P
 [ P
 IR
  \ `R
 Z
 \ Z
 zc
 \ c
 
 `] 
  ]  ? ] P  \^   d^   l^   x^   W ^ `  ^   ^   W ^ `  ^   ^   ^ `  ^   t ^   ^   ^   W ^ `  ^    _   W _ `  _  T _   (_  ' 0_ 0 e 8_ p  D_   P_   \_  d d_ p  l_   t_   |_   7 _ @ w _  4 _  F _ `  _  k  _     _   F! _ P! # _ # # _ # & _ & & ` & & ,` & >) 8` >) W) T` `) ) d` ) o, t` o, , ` , {- ` - . ` / ?/ ` P/ / ` / 0 `  0 O0 ` `0 0 c 0 *1 c 1 4 c 4 5 d 5 6  e 6 6 (e 6  A 0e 0A C g C C g C yD g yD D g D (E g (E E g E F h  F F  h  G BG ,h BG G 4h G G Hh G &H \h &H H ph H H h H H h H WI h XI uI  xI I  T I SJ h pJ J h J M h M P h  Q "Q x6 0Q VQ  `Q Q  Q Q  R R  R S  0S YS   T NT  W W  0X X   Y Y  Y ZZ  Z [  \ ]  Q] ^   ^ _  a_ `  "  a a " a Nb @# Pf vf  k Dk < k Sl B l >m B m 5n B n *o B o +p B r r  r .s H ls s  s t  Xt t  pu u  u u  u v pM  v v N v v P v Gw PQ `w w  w w  w x  @x x hU x Ny PV y y Z y Nz Z hz z X\ z z 8] { @{ ^ {  | P` | 6|  | |   } } c  } ;} c @} [} Xd `} {} d } } (e } } e } } e } } `f  ~ ~ f  ~ ;~ 0g @~ [~ g `~ {~  h ~ ~ hh ~ 
  E v      D j  ܀   4 o X t o   p ؂  pq  ؃ s    < e  }           P  P m  p ޅ y       -  @ n   ʆ    {   R {     '  |       /  L v   ҉  ҉   , Z  ܊   4 ! x     ԓ   )  a   ʔ   3 d   ɕ @  4 0 @ d  p  h      Л          L }     M ~      G   Ɯ   ݝ  \ }   ޞ   G        `     J ض 0 Z  p    ڢ    ( ( Y   ܣ   )  U     о     ۥ   	  9 j   a ( m   ʧ d (   (   (       t  p    t   ԯ   D _    0     t   Բ    D _ 8   `  ش  D u   ޵   G        `      ! R      $  \   Ź    g   Z   j      ڼ   6          *   
     D   0   ` H   x    0  ^  `        M ~      P                    p   Z  ` |  |               <  < \ X ` |  |     p   (   <  < `       J  p  p        j        `     *   , 5 , C  C _  _  L   D  " <E . T F l  F   F   tG G p G |  ,H   hH ?  DP   R  M S e  Y   $Y   [  M [ M m [ m  [   [   [  P [ \  \   X] & _ b _  c   c  - $c -  4c   Dc   Tc  z dc z  tc  2 c 2 k c k  c   d L i g @    s          S  `     m  p    
    m  p    
  , W                                                                                                                                                                                                                                                                                                                                                                                                                                                                  1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `                     <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                    ȪЪت  (08@HPX`hpxЫЬج  @HPX`hpx@HPX                  (08@HȭЭح  (08@HPX`hpxȮЮخ  (08@HPX`hpxȯЯد  x    (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء  (08@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPXȤФؤ  (08@HPX`hpxȥХإ  (08@HPX`pxȦЦئ  (08@HPX`hpxȧЧاШب (08@HPX`hpxȩЩة  (08@HPX`hpxȪЪت  (08@HPX`hpxȫЫث  (08@HPX`hpxȬЬج  (08@HPX`hȭЭح  (08@HPX`hpxȮЮخ        (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء  (0ȢТآ  (08@HPX`hpxȣУأ  (ؤ  (08@HPXȥХإ (08@ȦЦئ  (08@HPX`hxȧЧا  (0@HPX`hpxȨШب  
 x   ȡСء  (08@HPX08@HPX`hpxȣУأ  (08@H 
     (08@       @Hh8xHȣ (HPЦPX`ا08PXpxȨШب(08PXhpxȩЩة(08HPXpxЪت08PXpxЫث(08HPXh    ,   ЦX(H`h       (0hpHȡ Щ(PX`Ȫت08PXpxث (08PX`xȬЬج  (@HPhpxЭȯЯد      (@HPhpxȠ08@X`hȡhp (0PXxȤФ @Hhp08X`Цئ  (HPpxȧ8@`hب (0PXxȩЩ @Hhp08X`Ыث  (HPpxȬ8@`hح (0PXxȮЮ @Hhp      08X`Рؠ  (HPpxȡ8@`hآ (0PXxȣУ @Hhp08X`Хإ  (HPpxȦ8@`hا (0PXxȨШ @Hhp08X`Ъت  (HPpxȫ8@`hج (0PXxȭЭ @Hhp08X`Яد         (HPpxȠ8@`hء (0PXxȢТ @Hhp08X`Фؤ  (HPpxȥ8@`hئ (0PXЧا  (@H`hpx 0@`0`Ьp    P   P@hȤ@pȦ0Pp@ ` P      L   8hء 0У8`PpШ0P@p   0 H   @ Т@@  Pȫ0`HP @ <   @  xإp h `ЬP    P (   x Hأ@ PЦ P                                                                                                                                                                                                                                                                                                                                                                                                                                    ub.