ύ     pystan.model	StanModel)}(module_filenameZstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.cp35-win_amd64.pyd
model_codeXy  functions {
  real[ , ] get_changepoint_matrix(real[] t, real[] t_change, int T, int S) {
    // Assumes t and t_change are sorted.
    real A[T, S];
    real a_row[S];
    int cp_idx;

    // Start with an empty matrix.
    A = rep_array(0, T, S);
    a_row = rep_array(0, S);
    cp_idx = 1;

    // Fill in each row of A.
    for (i in 1:T) {
      while ((cp_idx <= S) && (t[i] >= t_change[cp_idx])) {
        a_row[cp_idx] = 1;
        cp_idx = cp_idx + 1;
      }
      A[i] = a_row;
    }
    return A;
  }

  // Logistic trend functions

  real[] logistic_gamma(real k, real m, real[] delta, real[] t_change, int S) {
    real gamma[S];  // adjusted offsets, for piecewise continuity
    real k_s[S + 1];  // actual rate in each segment
    real m_pr;

    // Compute the rate in each segment
    k_s[1] = k;
    for (i in 1:S) {
      k_s[i + 1] = k_s[i] + delta[i];
    }

    // Piecewise offsets
    m_pr = m; // The offset in the previous segment
    for (i in 1:S) {
      gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
      m_pr = m_pr + gamma[i];  // update for the next segment
    }
    return gamma;
  }
  
  real[] logistic_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[] cap,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    gamma = logistic_gamma(k, m, delta, t_change, S);
    for (i in 1:T) {
      Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta))
        * (t[i] - (m + dot_product(A[i], gamma)))));
    }
    return Y;
  }

  // Linear trend function

  real[] linear_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    for (i in 1:S) {
      gamma[i] = -t_change[i] * delta[i];
    }
    for (i in 1:T) {
      Y[i] = (k + dot_product(A[i], delta)) * t[i] + (
        m + dot_product(A[i], gamma));
    }
    return Y;
  }
}

data {
  int T;                // Number of time periods
  int<lower=1> K;       // Number of regressors
  real t[T];            // Time
  real cap[T];          // Capacities for logistic trend
  real y[T];            // Time series
  int S;                // Number of changepoints
  real t_change[S];     // Times of trend changepoints
  real X[T,K];         // Regressors
  vector[K] sigmas;     // Scale on seasonality prior
  real<lower=0> tau;    // Scale on changepoints prior
  int trend_indicator;  // 0 for linear, 1 for logistic
  real s_a[K];          // Indicator of additive features
  real s_m[K];          // Indicator of multiplicative features
}

transformed data {
  real A[T, S];
  A = get_changepoint_matrix(t, t_change, T, S);
}

parameters {
  real k;                   // Base trend growth rate
  real m;                   // Trend offset
  real delta[S];            // Trend rate adjustments
  real<lower=0> sigma_obs;  // Observation noise
  real beta[K];             // Regressor coefficients
}

transformed parameters {
  real trend[T];
  real Y[T];
  real beta_m[K];
  real beta_a[K];

  if (trend_indicator == 0) {
    trend = linear_trend(k, m, delta, t, A, t_change, S, T);
  } else if (trend_indicator == 1) {
    trend = logistic_trend(k, m, delta, t, cap, A, t_change, S, T);
  }

  for (i in 1:K) {
    beta_m[i] = beta[i] * s_m[i];
    beta_a[i] = beta[i] * s_a[i];
  }

  for (i in 1:T) {
    Y[i] = (
      trend[i] * (1 + dot_product(X[i], beta_m)) + dot_product(X[i], beta_a)
    );
  }
}

model {
  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  y ~ normal(Y, sigma_obs);
}

model_cppcodeXH  // Code generated by Stan version 2.17.1

#include <stan/model/model_header.hpp>

namespace anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unknown file name");
    reader.add_event(157, 157, "end", "unknown file name");
    return reader;
}

template <typename T0__, typename T1__>
std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
get_changepoint_matrix(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        vector<vector<local_scalar_t__> > A(T, (vector<local_scalar_t__>(S)));
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        current_statement_begin__ = 5;
        validate_non_negative_index("a_row", "S", S);
        vector<local_scalar_t__> a_row(S);
        stan::math::initialize(a_row, DUMMY_VAR__);
        stan::math::fill(a_row,DUMMY_VAR__);
        current_statement_begin__ = 6;
        int cp_idx(0);
        (void) cp_idx;  // dummy to suppress unused var warning

        stan::math::fill(cp_idx, std::numeric_limits<int>::min());


        current_statement_begin__ = 9;
        stan::math::assign(A, rep_array(0,T,S));
        current_statement_begin__ = 10;
        stan::math::assign(a_row, rep_array(0,S));
        current_statement_begin__ = 11;
        stan::math::assign(cp_idx, 1);
        current_statement_begin__ = 14;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 15;
            while (as_bool((primitive_value(logical_lte(cp_idx,S)) && primitive_value(logical_gte(get_base1(t,i,"t",1),get_base1(t_change,cp_idx,"t_change",1)))))) {

                current_statement_begin__ = 16;
                stan::math::assign(get_base1_lhs(a_row,cp_idx,"a_row",1), 1);
                current_statement_begin__ = 17;
                stan::math::assign(cp_idx, (cp_idx + 1));
            }
            current_statement_begin__ = 19;
            stan::math::assign(get_base1_lhs(A,i,"A",1), a_row);
        }
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(A);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct get_changepoint_matrix_functor__ {
    template <typename T0__, typename T1__>
        std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
    operator()(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) const {
        return get_changepoint_matrix(t, t_change, T, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
logistic_gamma(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 28;
        validate_non_negative_index("k_s", "(S + 1)", (S + 1));
        vector<local_scalar_t__> k_s((S + 1));
        stan::math::initialize(k_s, DUMMY_VAR__);
        stan::math::fill(k_s,DUMMY_VAR__);
        current_statement_begin__ = 29;
        local_scalar_t__ m_pr;
        (void) m_pr;  // dummy to suppress unused var warning

        stan::math::initialize(m_pr, DUMMY_VAR__);
        stan::math::fill(m_pr,DUMMY_VAR__);


        current_statement_begin__ = 32;
        stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
        current_statement_begin__ = 33;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 34;
            stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 38;
        stan::math::assign(m_pr, m);
        current_statement_begin__ = 39;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 40;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
            current_statement_begin__ = 41;
            stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
        }
        current_statement_begin__ = 43;
        return stan::math::promote_scalar<fun_return_scalar_t__>(gamma);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_gamma_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) const {
        return logistic_gamma(k, m, delta, t_change, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
logistic_trend(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 57;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 58;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 60;
        stan::math::assign(gamma, logistic_gamma(k,m,delta,t_change,S, pstream__));
        current_statement_begin__ = 61;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 62;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (get_base1(cap,i,"cap",1) / (1 + stan::math::exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))));
        }
        current_statement_begin__ = 65;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) const {
        return logistic_trend(k, m, delta, t, cap, A, t_change, S, T, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
linear_trend(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 80;
        validate_non_negative_index("gamma", "S", S);
        vector<local_scalar_t__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        current_statement_begin__ = 81;
        validate_non_negative_index("Y", "T", T);
        vector<local_scalar_t__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);


        current_statement_begin__ = 83;
        for (int i = 1; i <= S; ++i) {

            current_statement_begin__ = 84;
            stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
        }
        current_statement_begin__ = 86;
        for (int i = 1; i <= T; ++i) {

            current_statement_begin__ = 87;
            stan::math::assign(get_base1_lhs(Y,i,"Y",1), (((k + dot_product(get_base1(A,i,"A",1),delta)) * get_base1(t,i,"t",1)) + (m + dot_product(get_base1(A,i,"A",1),gamma))));
        }
        current_statement_begin__ = 90;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linear_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
    operator()(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) const {
        return linear_trend(k, m, delta, t, A, t_change, S, T, pstream__);
    }
};

class anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
    int trend_indicator;
    vector<double> s_a;
    vector<double> s_m;
    vector<vector<double> > A;
public:
    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 96;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 97;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 98;
            validate_non_negative_index("cap", "T", T);
            context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
            validate_non_negative_index("cap", "T", T);
            cap = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("cap");
            pos__ = 0;
            size_t cap_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
                cap[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 99;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 101;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 102;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 103;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "trend_indicator", "int", context__.to_vec());
            trend_indicator = int(0);
            vals_i__ = context__.vals_i("trend_indicator");
            pos__ = 0;
            trend_indicator = vals_i__[pos__++];
            current_statement_begin__ = 106;
            validate_non_negative_index("s_a", "K", K);
            context__.validate_dims("data initialization", "s_a", "double", context__.to_vec(K));
            validate_non_negative_index("s_a", "K", K);
            s_a = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_a");
            pos__ = 0;
            size_t s_a_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_a_limit_0__; ++i_0__) {
                s_a[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 107;
            validate_non_negative_index("s_m", "K", K);
            context__.validate_dims("data initialization", "s_m", "double", context__.to_vec(K));
            validate_non_negative_index("s_m", "K", K);
            s_m = std::vector<double>(K,double(0));
            vals_r__ = context__.vals_r("s_m");
            pos__ = 0;
            size_t s_m_limit_0__ = K;
            for (size_t i_0__ = 0; i_0__ < s_m_limit_0__; ++i_0__) {
                s_m[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 95;
            current_statement_begin__ = 96;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 97;
            current_statement_begin__ = 98;
            current_statement_begin__ = 99;
            current_statement_begin__ = 100;
            current_statement_begin__ = 101;
            current_statement_begin__ = 102;
            current_statement_begin__ = 103;
            current_statement_begin__ = 104;
            check_greater_or_equal(function__,"tau",tau,0);
            current_statement_begin__ = 105;
            current_statement_begin__ = 106;
            current_statement_begin__ = 107;
            // initialize data variables
            current_statement_begin__ = 111;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            stan::math::fill(A,DUMMY_VAR__);

            current_statement_begin__ = 112;
            stan::math::assign(A, get_changepoint_matrix(t,t_change,T,S, pstream__));

            // validate transformed data
            current_statement_begin__ = 111;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 116;
            ++num_params_r__;
            current_statement_begin__ = 117;
            ++num_params_r__;
            current_statement_begin__ = 118;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 119;
            ++num_params_r__;
            current_statement_begin__ = 120;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_db8febf10f23d7fa27a62fbcfd7f17b2() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            local_scalar_t__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<local_scalar_t__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            local_scalar_t__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<local_scalar_t__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(trend[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: trend" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(Y[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Y" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_m[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_m" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(beta_a[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_a" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // model body

            current_statement_begin__ = 149;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 150;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 151;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 152;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
            current_statement_begin__ = 153;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 156;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("trend");
        names__.push_back("Y");
        names__.push_back("beta_m");
        names__.push_back("beta_a");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 124;
            validate_non_negative_index("trend", "T", T);
            vector<local_scalar_t__> trend(T);
            stan::math::initialize(trend, DUMMY_VAR__);
            stan::math::fill(trend,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("Y", "T", T);
            vector<local_scalar_t__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("beta_m", "K", K);
            vector<local_scalar_t__> beta_m(K);
            stan::math::initialize(beta_m, DUMMY_VAR__);
            stan::math::fill(beta_m,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("beta_a", "K", K);
            vector<local_scalar_t__> beta_a(K);
            stan::math::initialize(beta_a, DUMMY_VAR__);
            stan::math::fill(beta_a,DUMMY_VAR__);


            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }

            // validate transformed parameters
            current_statement_begin__ = 124;
            current_statement_begin__ = 125;
            current_statement_begin__ = 126;
            current_statement_begin__ = 127;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(trend[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(Y[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_m[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_a[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "trend" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Y" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_m" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_a" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 stan_model;


model_cppname+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2module_bytesB  MZ                @                                      	!L!This program cannot be run in DOS mode.

$       EG^S&0 &0 &0 ^ &0 l{1&0 :x3&0 :x4
&0 :x1&0 :x5&0 x1&0 &1 l'0 x9 &0 x0 &0 x  &0 x2 &0 Rich&0                 PE  d	 7#[         "                                         0         `                                   h    h          p n             \  0
                    
 (   P
              p
                          .text   W                        `.rdata  :                   @  @.data                        @  .pdata  n   p  p   4             @  @.gfids  <                      @  @.tls    	                      @  _RDATA                         @  @.rsrc                         @  @.reloc  \                      @  B                                                                                                                                        H(H
B 0 A   HB    HL H}B     H
fB _B  *  H
 H( H(H
A о A   HA    H HA     H
A A   H
3 H(b H(H
A p A   HA    H H@     H
@ @  j H
s H( H(u
 1 GA H(H(u
 1 /@ H(u
 ^@ ? H(u
 U1 7@ H(H(\u
 51 ? H(? W
 @ H(u
 
1 0 W
 @ H(? XX? @ H(H
@   A   H@    H$ Hm@     H
V@ O@   H
 H( H(H
? 蠼 A   H?    H H?     H
? ?   H
 H(2 H(H
> @ A   H>    H H}>     H
f> _>  : H
# H( H(H
X  WHX     H
K kX H( H(H
Z 蠻 WHZ     H
 cZ H(R H( WHyZ     H
2 ZZ H( H(2  H
  H( H(H
W  WHW     H
{ W H( H(H
W к WHW     H
 W H( H(H
Y 萺 WHY     H
[ X H(B H( H
  H( H(G H
 H( H('  q
 j TC|
 f/ss
 v  "     r
 ; T|
 f/Ds
 v  "   H(H(Y H(H(g H(黔 + 雓 H(X H(p
  p
 C H(p
  H(H(|p
 _ H(H
  @SH HHHSH
Q H3H
HJHH HH [H! HHH%+ HQHM HHEH\$WH H HHH t
   H# HH\$0H _3HAH HAH HH  H(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH(b @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ Ho HHH0[@SH HHHSH
 H3H
HJHH H$ HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0) HT$0   HC   HsH{rHH  H @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" HQ HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HHL$pH3\ L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtHg H' uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIH:' uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H= HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v HG @H$   H3 L$   I[0Ik8IA^_^́aHI    H HH\$Hl$Ht$WAVAWH HrE3HLH(IDIH. HGAH+HHt6@ Ht
,Hq. HHH HGHH+HH;rM)IDHH\$@Hl$HHt$PH A_A^_%. @USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtH B$   H  HIHP   Hp  	 HIHPH
 H HEH  ,+ HH + HIB/ HH + HI(/ HHf * HH/ Hp  Hp   HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H
 HD$ HB HL$  HIHP   Hp   H& H  :* HH +* HIP. HH * HI6. HHt ) HH. Hp  Hp   HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8
 H HD$ HA HL$  HMHT$HHPHT$PLL$HI+HLHFI+HH;  HL$p H@ HM') HH ) HI=- HH ( HI#- HH ( (HM* 3ۋHFH+HHt9D  Ht,HM* HHHM HHFH+HH;r̲)HM* H HMq( (HM* HD$PHL$HH+HHt<Ht,HM`* HL$HHHM HHD$PHL$HH+HH;rĲ)HM)* Hp  HL$p HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8) H: HD$ H.? HL$ " 3ۋH  IM+     HI9uHHH;r{  HMp
 H H   I' HH :' HI_+ HH  ' HIE+ HHk ' HHZ HH & LHUp/H( H   & (H   ( HD$PHL$HH+HHtBHt,H   ( HL$HHH   ߾ HHD$PHL$HH+HH;r)H   x( Hp  HMph HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8y H HD$ H~= HL$ r MtLD$XM+II H  H3 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H讪 HHHH\$@H0_H\$Ht$WH0HD$        IHf HHHH\$@HpHHt$HH0_@SH H˩ HHt
    HH [@SH H   H HH [H% HL$UVWAVAWH0HD$ H\$pILHH HHqHt$hE3L>L~$ HH_H\$hL;L{# HL(L0L8L@LHLPLXL`LhI;t8HHRH! HH@HH HH@L~DD$`IH˛ H;t9HHRH' HH@HH HH@L{DD$`HHޚ HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP HW yI^I;^u3HIN͙ HI;FtHP H( yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H辫 yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP HH tHHH;t-IM轘 HH;tHP H yHHS@   IM萘 HI}H;tHP H tHH;   HIMY HH;tHP H赪 tHHS@HL$H͎ H|$PH\$HH+HHHL$0讦 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH\ IU(I莥 IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP H裩 yHHH;t*IO HH;tHP Hw yHHSX?IO IHH;tHP HI yHH;tHIO IWXH蓤 H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP H质 yI_I;_t/HIO* HI;GtHP H腨 yI_HS@IW@H蛌 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI處 HI;GtHP H yI_I;_t/HIOj HI;GtHP Hŧ yI_HSXIWXH H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3聛 HGHH;tiD  HS Hd { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3њ HGHH;tiD  HS H贙 { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   H" HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+I H_@H_HH_PHW(HtLG8L+IN H_(H_0H_8LGHT$0MHOM J HOa LGHT$0MHOM  HO@ H\$8Hܠ HH _@SH LHT$0MHM  HH [ @SH LHT$0MHM  HH [ H H@SH H HHt
    HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH H[ HHt
   v HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH H[ HHt
    HH [@SH HS HHt
    HH [H(HIc HHy H(H% @SHPHD$ Ho H3HD$HHHHT$(H HHK HH : HD$@HrQHHL$(H=   r<t HAH;r H+Hss H'vf H HL$HH3 HP[H(HIs HH H(H% @SHPHD$ Hn H3HD$HHHHT$(H HHK HH( J HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vv H HL$HH3( HP[H(HI HH H(H% @SHPHD$ H"m H3HD$HHHHT$(H HHK" HH8 Z HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH38 HP[H(HI  HH H(H%Ʈ @SHPHD$ H2l H3HD$HHHHT$(H/ HHK 2 HHH j HD$@HrQHHL$(H=   r<tð HAH;r H+Hs H'v H HL$HH3H HP[H(HI( HH H(H%֭ @SHPHD$ HBk H3HD$HHHHT$(H? HHK(B HHX z HD$@HrQHHL$(H=   r<tӯ HAH;rï H+Hs H'v H HL$HH3X HP[@SH Hs HHt
0    HH [HI HH H\$WH H HHH t
(   HC HH\$0H _@SH HHHSH
 H3H
HJHH3 Hܣ HHH [H٠ H@SH Hà HHt
    HH [@SH H# HHH贝 H} HH [ K H(HQHI? HHU H(H%r @SH HHQHI
 HH HH H [H%1 H\$WH H_ HHH H Ht
0   H HH\$0H _23HHBHBH@SH HHRH;c HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+Ib HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iѹ WD$0Hl$@@tHT$HHtLD$XL+I袹 HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Iq WD$0Hl$@@tHT$HHtLD$XL+IB HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+Ia WD$0Hl$@@tHT$HHtLD$XL+I2 HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWH% HL$8Ht HT$@] LD$HHT$8L+I: H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWH腞 HL$8Ht HT$@0] LD$HHT$8L+I H\$`HP_@SH H HHt
    HH [H\$Ht$WH Hj HH3HIPH*Ht:HSX_ HK`HH+KPHHLI?LHSP H{PH{XH{`HS8HtLCHL+I H{8H{@H{HHK Ht:HS(n_ HK0HH+K HHLI?LHS 虲 H{ H{(H{0HKHt)HS[ HSLCL+IW H{H{H{Ht$8Hw HH\$0H _@SH HYLHIHWN H;H [Hl$Ht$AVH0HHHQE3HIDt$ N H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHHt Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ M H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQH遇 @SH0HD$     HQ8H賍 HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI~ D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0L I?HHD$0H;t?HHtLGL+I L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H HHHIVI+H*HHHH?HH;s(9 2 + $  IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   H HH\$0H _@SH  HD$HH\ H3H$p   HH      HL$P' Hg HL$`e HH HH  H$P  HL$PW HxrH H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8j H{ HD$ Ho HL$ c H$p  H3 HĀ  [HL$WH@Lo( HH
=( IL
C( LL+!( ILF( M;s$K9<sIHH+' HL"( L;rH\$XHt$hM;~  H' HpHH;HBHHt$`hH' HHD$PHD$PH;sNH
' HD$PH;w=H\$PH+HH;' uH
r' = Hn' Ht;HZ' HH
$H;Z' uH
A'  H=' Ht
HH.' HH#' Hz    H
)' HD$`L
' H;sLHD$`L;wBH\$`I+HH;
' u   H
& 8 H
& L
& HtGIH0H;
& u   H
&  H
& L
& HtH1H
& L
& L& HH
|& HU& Ht$hH\$XJH8H
|& KHHf& H@_3H_ HD$0HL$ H HD$(HR HD$  HT$HL$WH@HD$ H\$hHD$X   H=% H|$`   dHD$PWf% 3H% LD$P H% Wf% LD$XH
%  H% H^% H
HL$XH
% HH% H% Wf% f% H% H% f% H9u13HD$8H HD$0HF HD$(H* HL$( HH\$hH@_H\$WH H$ 3H
$ HH+HHt7D  HHtH H$ H
$ HHH+HH;rH$ HH   H$ H+HH;v H    H=   r<t HBH;rw H+Hsg H'vZ HH H
# WfT$ H=E$ H&$ H   H&$ H+HH;v H    H=   r<t HBH;r H+HsЛ H'vÛ HH H
H# Wf# H=# Hw# H   Hw# H+HH;vu H    H=   r<tY HBH;rI H+Hs9 H'v, HHX H
" Wf" H=" H" H   H" H+HH;vޚ H    H=   r<t HBH;r H+Hs H'v HH H
" Wf/" H= " Ht}H" H+HH;vR H    H=   r<t6 HAH;r& H+Hs H'v	 H8 WH=! f! H\$0H _L! L9! u0HY! H~!     HH\! H}! H HHh! I@IHH
q! H
! HH?! HH
m! H
~! HH3! HH!! H
b! @SH HHHSH
 H3H
HJHH H HHH [@SH Hہ IHHHA    HD$0H HL$0H;sdH HL$0H;wSH|$8H|$0H+HH; u   H
 n H Hx HtHHHm H|$80H;g u   H
I , HE Ht
HH6 HHH( H [H H@SH H HHـu
   KHH [@SH@HD$ )t$0(HH HHH H; r
   HHL$PHt
(3HH(t$0H@[HH3HC HD$0HL$ H HD$(H6 HD$  H\$ WH H7R H3HD$3LA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HAP  AO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3' H\$HH _KN  WN  cN  {N  N  N  N  !O  oN  N  N  N  N  N  N  N  N  N  O  
O  *O  3O  <O  EO  NO  UO   	
	
	
 	


	

@SH@eH%X   H)t$0(1
    )|$ (=O<
 Hȋ
9    f]5d=
 f_5<B
 fYfX= ;
 ffT=l;
 f\(|$ ((fY
8
 fY;
 f\ff\fI (frfYfpc((fY%8
 fY
8
 fX%9
 fX
9
 fYfYfX%:
 fX
J:
 fY(t$0fYfX
;
 f\f^fY%;
 fX%:
 fYf_H@[H
  = fo7
 H
 f f @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH Hx HHـu
(   [HH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH2 HH(H$ H; r
(   HHt$@Ht*H?HOXKHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^Ho HH(Ha H;R r
(   HH|$`Ht&H(XKHNH_w Hx HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(HWf.z
uI H^H HH(H H; r
(   HH|$XHt&H(XKHH_w HNx HH>HH\$PHt$`(t$0H@_HIHII      AD$HD$I#I;w]HB HL$HD$I#I;wAB^XAAHJ HBAHYJY^A\AI      LAHB L@HA IYI@Y^@\@AVH0HD$ H\$HHt$PH|$XIHLHB HH(H4 H;% r
(   HHt$@Ht*H?HK^OHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$XHt$`)t$0I(HH HH(H H;u r
(   HH|$PHt&H(^KHqwH_ Hq HH>HH\$XHt$`(t$0H@_AID$I      HD$I#I;w,HQ BD$HD$I#I;wB\ABHA H      HH@WH@HD$ H\$XHt$`)t$0I(HH HH(Ht H;e r
(   HH|$PHt&H(\KHawH_ H HH>HH\$XHt$`(t$0H@_HIHII      AD$HD$I#I;wHHB @D$HD$I#I;w,YBXAAHBHJ @YBXAAI      LAHB L@HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH HH(H H; r
(   !HHt$@Ht*H?HOYKHH^H~ H-{ HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHf.	*
 z
uHH^H HH(H  H; r
(   ]HH|$`Ht&H(YKHH_w H HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(Hf.
I)
 z
uI H^HN HH(H@ H;1 r
(   HH|$XHt&H(YKH-H_w HŃ HH>HH\$PHt$`(t$0H@_HQIBD$HD$I#I      I;vH      HBB\AB@SH Hxo HHـu
    ۸HH [@WH0HD$ H\$HHt$PHHH* HH H H;
 r
    yHH|$@Ht%HKW
2
 HH_Hw HH>HH\$HHt$PH0_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH Hxn HHـu
0   ۷HH [@SH HHHSH
1 H3H
HJHHÃ H{ HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3 H+` HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$H HHoHH$   Hp_^]H	H%^ @USVWAVHl$H  HD$PH%? H3HEpMA؋H   D$     Ht HD$`HM9 D$    E3E3HT$hHL$` HD$`HcHH1o HD`HD$`HcHxT\   HL$h" H HL$` HH q HH b Hȋǀ HH H HH 9 HȺ    HHi  Hȋ HI HH HUPHL$`M HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@  Hs HD$(HM HL$( @SH H   H HH [H%| @SH HHHSH
 H3H
HJHH Hs HHH [E   Hx  HD$8H= H3H$`  DL$0HL$@ H HL$P HHƸ  H$@  HL$@} H$@  H$X  HC$@  HD$ L
\ LD$0Hx H
 T HWHp  HD$0HXHpHU< H3H$`  AAH$  A|A@;|iHL$@~ H HL$P
 Hȋ$  j~ H$@  HL$@} L$@  H$X  LC$@  Ht$ DË~H$`  H3m L$p  I[IsI_E  SVWH  HD$HHu; H3H$p  AHHHL$P} H HL$`= HH{ . HH# HHA  HH	 HH  Hȋ_} H$P  HL$P{ H$P  H$h  HC$P  H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8 ~ Hx HD$ H HL$  @SH HHHSH
! H3H
HJHH} Hx HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu(( (
 D$T$f (fYfYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
ƛ fYfYfXƛ fX
Λ fYfYfXΛ fX(f^((5p (
>p D$T$f (fYfYfYfX&p fX
.p fYfYfX.p fX
6p fYfYfX6p fX
>p fYfYfX>p fX
Fp fYfYfXFp fX
Np fYfYfXNp fX(f^(H8W)t$ f/(vbWT)
 
 
 
 f/D$@   f.z$u"| !
 X "   (t$ H8{ X(t$ H8>
 
 
 f/D$@wHf.z uB|  
  "   (t$ H8(t$ H8H%J{ LD$@H Iq LD$@H 7q HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3z HV HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHM蛯 IwHu@HH^H^uHtFHHHH;t_LLMt3y IV HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHMȮ I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMHq H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHXO
 LqWMHHEIHEI~Ht3w HS HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHMsB L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;t\IHHt3u HQ HELuH}LE7HUHM LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHM B HMu HMu L$   I[(Is0I{8IA_A^]LWH   H
n
 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tH=t Ht
HXP HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0; H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3s H+O HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHM I~H}@HH_uHt3qr HN HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHMh I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM触 HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHM5 H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHX
 LqWMHHEIHEI~Ht3Pp HpL HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHMܥ LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHMC; LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM< HMn L$   I[(Is0I{8IA_A^]LWH   H

 f/   HA\I[3IsHq ICD$hH9rt"H
n Ht
H0J HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0+ H$   HĀ   _@SH HHHSH
u H3H
HJHHl Hq HHH [AYAHAX@@@WH0HD$ H\$HHt$PHHH HH H| H;m r
    HH|$@Ht&HCY
 (HdH_Hk HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HHa HHGH+HH    HJ HHH= H;. rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDHh HH(HZ H;K r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHM HMHM 8F HELELEHM HMLHUNL+t	H
 HMF LHEHMHMHULL+t	HY
 WD$PH}LHt3i HE HHD$PH}HL$PLt$X3L;t-ji HtHE HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$`& =V
    HEH   L   LD$PHH    H9V~EH
 
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3 h HtH;D HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$`Ԝ HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HU HD$@HD$`H|$HHFH;t'H;tH g Ht
HC HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM HL$@uf HL$Pif I_f HMTf HMIf HM?f HM5f L$`  I[0A(sA({IA_A^_^]@SH HHI(e HKe HH [H%e H\$Ht$WH@HY)t$0H!f H\$PHHHJ()|$ H(A HLGLCHLGIL+LtH
 H\$XH~(|$ v Ht$`(t$0H@_He HHIH%3e @WHPHD$ H\$hHt$pH  H3HD$HHHD$@   3Ht$8@t$(DFHш HL$(+ HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVH HH;HKHtdHA   HqHyrHHH<H;Cu
   H賅 HKHt(HA   HqHyrHHHT$(  R HC HD$@HrQHHL$(H=   r<td HAH;rd H+Hsd H'vd H HD$@   Ht$8D$( A
   H HL$( HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H HH;HKHtdHA   HqHyrHHH<H;Cu
   H} HKHt(HA   HqHyrHHHT$(   HC HL$(-S HL$HH3考 H\$hHt$pHP_H\$WH Hc HHHIb t
(   H賊 HH\$0H _HW H@SH H{W HHt
   f HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHHSb H\$0HHHJ= HLFLCHVLFIL+LtHT
 HFH\$8HGHF Ht$@HG HH _H^ HHt H\$WH H^ HHH^t t
(   HT HH\$0H _@SHPHD$ H H3HD$HHHD$@   HD$8    D$( A   H HL$(! HHHT$(PHD$@HrQHHL$(H=   r<tsa HAH;rca H+HsSa H'vFa Hu HL$HH3 HP[HWH@H@HXHhHpIHHW@3HpVHHA LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
ҕ <] IPL+IIHL+IM;HCH;HCHL$(茨 LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
B \ IPL+IIHL+IM;HCH;HCHL$( LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+I7 H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xH
 H3Hp  I((Hǅh     Hǅ`      ƅP   A   H HP  ) HHPH0  S\ HP  H@   H([ HHɁ t H0  H0  Z LHHAPHH  HrSHH0  H=   r<t ^ HAH;r^ H+Hs ^ H'v] H" HM0[ HǅH     Hǅ@      ƅ0   A H`  H0   H0  HM@ H(Z HH  HH  HrSHH0  H=   r<tV] HAH;rF] H+Hs6] H'v)] HX H0  HM08Y LHHAPHH  HrSHH0  H=   r<t\ HAH;r\ H+Hs\ H'v\ Hك HL$0OZ HǅH     Hǅ@      ƅ0   A H`  H0  軆 XH0  HL$@ H(Y HH : HH  HrSHH0  H=   r<t\ HAH;r[ H+Hs[ H'v[ H	 H0  HL$0W LHHAPHH  HrSHH0  H=   r<t[ HAH;rw[ H+Hsg[ H'vZ[ H艂 HHPHMW HMLY H   W H   2Y H  eW H  Y Hh  HrSHHP  H=   r<tZ HAH;rZ H+HsZ H'vZ Hׁ Hp  H3Xz L$  I[A(sA({I]HUSWHHH  HD$ )p)xHL H3Hp  ((HHǅh     3H`  @P  DGHK} HP  o HǅH     H@  @0  E3HIy H0  ? HKHH0  P HH  HrSHH0  H=   r<tY HAH;rzY H+HsjY H'v]Y H茀 H0   W HP  H@  l H(V HHv| ! HKHH0  PHM0V HǅH     H@  ƅ0   A H`  H0  ' H0  HM@ H(V HH| 諽 HH  HrSHH0  H=   r<txX HAH;rhX H+HsXX H'vKX Hz HKHHU0PHL$0U HǅH     H@  ƅ0   A H`  H0  R XH0  HL$@ H(8U HHV{ Ѽ HH  HrSHH0  H=   r<tW HAH;rW H+Hs~W H'vqW H~ HKHHT$0PHǅH     H@  ƅ0   E3Hv H0  袂 HKHH0  P HH  HrTHH0  H=   r<tV HAH;rV H+HsV H'vV H} HMS HMT H   R H   T H  R H  T Hh  HrSHHP  H=   r<tDV HAH;r4V H+Hs$V H'vV HF} Hp  H3u ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHH|C HHqHt$`3H.HnHcڅt3T H0 HH^HwHt$`H.HnHt3T H0 HH^Ho(Hw0Ht$`H.HnHt3TT Ht0 HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHHB HHrHyH|$hE3L'LgHt3S H/ HHwLu HsHt$hL&LfMt3S I/ HLvHE(HC(L}8Ls0Lt$hM&MfMt3hS I/ IM~HUH% HUH HU0I
 HH\$pHl$xH0A_A^A\_^H\$WH HHHH HC(HSHOHG( HS0HO0 H\$0HH _@UVWATAUAVAWHpHD$ H$   H H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHn4 HcH;U|H
j O EL9e#  IIf     HD$@   Ld$8D$( A   Htv HL$(F~ IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH萦 HwHtoHF   LfH~rHH  H{sLCItHHO 	HHL#HCHFHCHFHC   H{LcrH HG HL$H@ HL$(@ AIcH;]}/H
v M H
h M H
: M AH9u   I HD$@   Ld$8D$( A   HXt HL$(&| IIFH+HH;vJHLHT$(HL$H HH5 HL$H? HL$(? HcH;]zH
 L HL$hH3o H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHH: HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;ICw HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;IC HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC7 HSHt
HHH
HB   H
$ J H
 J LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC蚕 HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
a I H
S I HL$VWATAVAWH0HD$ H\$hHl$xHcLH7K II~@H|$pE3L'LgLgIHtIHHH;tHHHt3jK H' HH_H_LHMI;~NL    
 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHYJ Mt
It& HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx HT H3HE`LHE3ADt$ HEX   LuP@}@EF Hm HM@u IE HU@IPHEXHrPHHM@H=   r<tI HAH;rI H+HsI H'vI Hp Aމ\$$H9^H  ML=@ H: H
K HL$@HT$PHMG |$ E3HT$XHL$@~G HD$@HcHHME HD@HD$@HcHhT<HD$XHD$0HL$XD L|$XLuDuHF@BHL$PEF A   EL9vP~S@ ff     H~@H^HIIH~l HL$P谭 HE AIIcH;FP|Ë\$$|$ HU@HL$@D ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   HOo HD$@HcHHD HD@HD$@HcHhT<L=/? L|$XHL$XP~ HL$XE HL$`E HME É\$$IHcH;FH}$E3G G G G HM`H3>g L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0UF HKKF HKH [H%;F @SH HH   D H   HLcBADuluHT$0|D H [fD H   HLcBADuLt2H [H\$WH HH   HT$0O L   I HcHBDuT$0@:tIC 2H\$8H _ðH\$8H _@SH HHT$0H    L   I HcPBDt2H [L$0F tT$0HK H|$84 H   HT$0lC HHcQDu@fD  L$0=F u8L$0&F u)T$0_t$.tH   C H|$8H [T$0HK +4 H   HT$0B HHcQDtH|$8H [@SH HHT$0H   ֶ H   HHcPD
uT$0"tFyB H   HT$0蠶 H   HHcPD
uT$0't2CB HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33{D l$HlD ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @CA Hv_H~HHfff     I   A HHu2Hv&H~HHfI   @ HHu2j@SH   HD$@H/ H3H$   HHL$0HA    HyrHH  H   HT$ @ HHcQDuAL$ ?C uL$ @C T$ tHo1 H   H   !@ HqHX H$   H37b HĠ   [@SH HyHHA    rHH  HT$0H   ? HHcQDufL$0B uL$0B T$0t6H0 H   HT$0x? HHcQDtH*   H [H   ?? H   H [H   HD$0H H3H$   HL$ d H$   H3#a HĘ   @SH   HD$0)$   H7 H3H$   HHL$ ' (Wf.zu	HѸ (H$   H3` ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5e DH@ H   HUHP HHcJD   UH:7   HD847uAHe HEt
5 5 HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKXa HS`HtHCXHH
HB  H   W= HvSHHHH   8= HvHu.Hv(HHHD  H   = HvHuE3Hd Ht  HKXHUHEH*   @2LsH{rHHD0HU@H   < HHcQDugH
     M@u? U@uB<:w2Hs,@H- H   HU@\< HHcQDt
H   /< @u<HC`H+CXHu,HEtHK@EHHUH$ HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKX` HS`HtHCXHH
HB%H;Chu   HKX_ HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5 BH;Chu   HKXm_ HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0: HLcBAD u!L$0t= uT$0H   v: H   HT$8蝮 L   I HcHBDuT$8-tDI<: H   HT$8@2` H   HHcPD
uT$8+t: @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(t9 2H0A^H\$HHT$@Ht$XH|$(语 I   HHcPD
uT$@)   N9 IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@\ IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINp\ IVxHt:IFpHH
IFx   I;   u   INp\ IFxHtH0IFxkI;FPu	IN@\ IFHHt0IFHHHl$PI   HT$@' I   HHcPD
uT$@)t#7 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INp[ IVxHt7IFpHH
IFxI;   u   INp[ IFxHtL8IFxU@UH0HHT$@H   6 H   HHcPD
uT$@(t6 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   6 HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMXZ HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMp)Z HUxHt:HEpHH
HEx   H;   u   HMpY HExHtL0HExtH;Ehu   HMXY HE`HtL0HHE`HHt$PH   HT$@U H   HHcPD
uT$@)t"4 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMpY HUxHt7HEpHH
HExH;   u   HMpX HExHtL8HExV@SH HHT$0H   f H   HHcPD
uT$0(t	4 2H [HT$0H|$@* H   HHcPD
uT$0)   3 Ht$8HH   HT$0 H   HHcHDuT$0,tH   3 Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKpW HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp-W HSxHt@HCpHH|$@H
HCxH [H;   u   HKpV HCxHtH8HCxH|$@H [H;   u   HKpV HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH   3 H   HHcPD
uU(t1 2H([]Ht$HHzY AH|$PHH˄t
   AH?U H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@ MM;~fHUHK@ EȉE;}HCpHUHCxH   / H   HHcPD
uU,t0 Ht$H2H|$PH([]ò.H~tAHhX Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8 ,Ht'HrHUHEHKp ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp HMHHMH;v)Hh뒐HUHKps HEHHEH;s)H9`@UH0HHT$@H   v H   HHcPD
uT$@ct)/ AHV HḦ́tH0]HH0]AHR Ḧ́t
H0]AHV Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@Q HUHHt%HE@
H;EPu	HM@Q HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@YQ HUHHt%HE@
H;EPu	HM@6Q HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@ Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+I5O H{pH{xH   HSXHtLChL+I
O H{XH{`H{hHS@HtLCPL+I8> H{@H{HH{PHK C HH\$0H _1 @SH0H3HQ D$ IE3HHC   HC@[ HH0[@SH0HD$     HQpH HH0[@SH0HD$     HQ@H  HH0[@SH0HD$     HQXH HH0[@SH   HD$@H H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H   E L   I HcHBD   T$ <tI*    -H   Hi   HǄ$      HǄ$       D$pA   HhR HL$pnX HD$pH$   HCD$pH
4 HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   + H% HD$PA;  HR HL$P 2H$   H34L H   [HUATAUAVAWHl$H  HEHXHpHx H5 H3HEpHLHMH] HLiLl$03I} I}躐 IE M|$L|$0I?I蠐 II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIg HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	9
 uH;s3H;t.LuLEIƅ LH HD$ LHT$0I H\$0HK@HT$8: HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  HQ HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  HP HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  HP HT$hHtLD$xL+I8 WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$ HHT$8 HM HT$PHtLD$`L+IH HT$8HtLD$HL+IG HT$hHtLD$xL+IG WD$hH|$xHUHQLEL+IG <' ' ' ' ' y' r' k' d' ]' V' O' H' A' HMIHMpH3F L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+IF H{H{ H{(HHtLCL+I5 H;H{H{H\$0H _H\$WH HQ3HHtLA(L+IXF H{H{ H{(HHtLCL+I4F H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0# HK HL$@؊ Ht3HwHK HL$@辊 H;sHvI HL$@訊 HH;rHqK HL$@菊 HH" HHIK t HT$0HHD$0HcHHf! HD0HD$0HcHhT,Hw HD$HHL$H[ HL$H%# HL$Pb" H$   # HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tHHHt3# H LHD$(Lt$(H\$0H\$8HH~AL    M
 HIH;u(WHHH;|HMH;|HL$P! HI HL$` Ht3HnAHL$`"! H;sHG HL$`贈 HH;rH}I HL$`蛈 HH  HHIG 耈 HH  HH:I e HT$PIHD$PHcHHW HDPHD$PHcHhTLHh HD$hHL$hY HL$h! HL$pS  H$   ! I" IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   H H3H$  ILHH$   LL$83ۉ\$0HHYMt3{! H HH~D$0   HǄ$      H$   Ƅ$    A   EHH H$   M HǄ$      H$   Ƅ$    EGHG H$   NM HǄ$      H$   Ƅ$    EGHG H$   M HHL$`aHD$ L$   L$   H$   IuZHT$`HtLD$pL+IIA WD$`H\$pH$   HrTHH$   H=   r<t! HAH;r! H+Hs  H'v  HH HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t  HAH;r  H+Hsy  H'vl  HG HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t  HAH;r  H+Hs H'v HG HǄ$      H$   Ƅ$    A
   HE H$   'K IL$   HT$xIPH$   HrTHH$   H=   r<tk HAH;r[ H+HsK H'v> HmF HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;vw H    H=   r<t[ HAH;rK H+Hs; H'v. H]E HH$  H3= H  A_A^_^[LSVWAVH  IǃXH H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFH
D IpH HǄ$      L$   D$   EF
HIC H$   H HǄ$      L$   D$   EFHC H$   H LHHL$H\HD$ L$   L$   H$   HUHT$HHtLD$XL+I< WD$HLt$XH$   HrTHH$   H=   r<tz HAH;rj H+HsZ H'vM H|C HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t HAH;r H+Hs H'v HB HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t~ HAH;rn H+Hs^ H'vQ HB HǄ$      L$   Ƅ$    A
   HA H$   F HL$   HT$xHPH$   HrTHH$   H=   r<t HAH;r H+Hs H'v HA HǄ$      L$   Ƅ$    DDHT$xHL$H迒 HHHHHHJHCHBHKHJHCHBHKHL$HM HT$xHtL$   L+I: HH$  H39 H  A^_^[H   HD$`H H3H$   LHT$03DI          M;HsBIIcD$@HD$@I#I;uHuQ HD$(Hq? H
J@  IWD  I;Ps8IHcf/w"HQ HD$(LH+? H
@ g HH$   H38 HĨ   H   HD$HH H3HD$xHT$ L褒 HL$xH38 HĈ   AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ D AXA((yXA@^A(]\A(\YYAX(qv
 K8W
 Ys ^C0\(u
 D\YDYCDX(DCu
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hHx H3HD$0HHHT$(H HHHA   3HqHyrHH@0IE3C Hs(Hs0s8s@C<Hf HHL$0H36 H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH H3Hp  DHH  f  LAH= HP  蜉 L= HH0  E LHHAP HH  HrSHH0  H=   r<t HAH;r H+Hs H'v H= HǅH     3H@  @0  Hh  HrSHHP  H=   r<t HAH;ry H+Hsi H'v\ H< HǅH     H@  ƅ0   A&   H< H0  @ HH0  HP HH  HrSHH0  H=   r<t HAH;r H+Hs H'v H; HǅH     H@  ƅ0   E3H4 H0  ? HH0  HP HH  Hy  HH0  H=   r<t@ HAH;r0 H+Hs  H'v HB; !  C  3A;  HǅH     H@  @0  DG9HZ; H0  6? HH0  HP HH  HrSHH0  H=   r<t HAH;rr H+Hsb H'vU H: HǅH     H@  ƅ0   A   H: H0  > L0  H: HP   LHHAP Hh  HrSHHP  H=   r<t HAH;r H+Hs H'v H9 Hǅh     H`  ƅP   HH  HrSHH0  H=   r<tM HAH;r= H+Hs- H'v  HO9 Dv(WI*(Y H,ȉN,Y
ز H,F0D+D+Dv4Hǅh     H`  ƅP   A9   H9 HP  $= HHP  HP HP    Hǅh     H`  ƅP   A/   H9 HP  < HHP  HP HP    H0   H9 H@  &v HȋV, HH0  HPHM0 H9 HM@u HȋV4L HHU0HPHL$0} H9 HL$@u HȋV0 HHT$0HPHǅh     H`  ƅP   E3H/ HP  ; HHP  HP HP    HM HMP H    H   6 H  i H   Dv(DF,DN0N4~8N@AAF<Hp  H3/ L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   Hb8 HH: HT$(HH HHOHfHH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHI<K8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKHޘ,CHE3L% fnHGLH(X^^Y%ڮ L9G~    MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKHѓC8L|$ Lt$PHl$@H(_[ÍAC82H(_[H  @SH A HO* HHH
 HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLH IIv@H$   3H>H~Ht3 H  HH^i D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$H@ IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tH  Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@و H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx H H3HEPLLHEH   HE@    E0 A)   H3 HM0J6 IHU0IPHEHHrPHHM0H=   r<t
 HAH;r
 H+Hs
 H'vr
 H1 HL$0 IF@HL$@    I9vH~:~D  I^@H- HL$@+o Hu HHcI;FH|HU0HL$0  MHIAPHEHHrQHHM0H=   r<t	 HAH;r	 H+Hs	 H'v	 H0 HD$0HcHH HD0HD$0HcHhT,H  HD$HHL$H? HL$HU HL$P HMH HMPH3( L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   H+ HH)4 HT$(HH HHOHVHH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHI視K8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKH蟘,CHLOLH|$HN % fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^Y L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0j HKH#C8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A H% HHH
 HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pH H3HEHHE   3H}@}DG<H. HM>1 HHUHP HEHrPHHMH=   r<t HAH;r H+Hss H'vf H, HE   H}E A   H. HM0 HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H, HE   H}E AC   H9. HM 0 HHUHP HEHrPHHMH=   r<tu HAH;re H+HsU H'vH Hw+ HE   H}E A/   H- HM/ HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H* HE   H}E A<   H, HM/ HHUHP HEHrPHHMH=   r<tW HAH;rG H+Hs7 H'v* HY* HE   H}E E3H}" HMv. HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H) HE   H}E E3H! HM- HHUHP HM  HMH3" H\$hH|$pHP]LEK ECL$UVWHP  HD$0I[AAم+H9 HD$ L
9 MCH, H
+  ̅/H9 HD$ L
9 L$  H+ H
+  ̅/H}9 HD$ L
Q9 L$  H+ H
{+ ^ fn\_
 9_
 ,;tCt
Ù-  HL$P  H$  HL$`bj H+ HL$`!f HcHL$8
 HL$`HcQHL$`HHPHL$`_
 HHQ+ e HȋE
    HL$8
 HH/+ HL$`e HHu3
H HcHHHUU kdH
 HH* te H* HL$`ce H$  HL$`i H$  HHT$PPH$     H$   2
 H$x  HP  _^]H\$WH0ME3M@HMtHMHH      @ f     IcAD$PHD$PH#H;w)IM;r܋A(L
** HˉD$ z H\$@H0_H47 MH) HD$(H蝼 H\$Hl$Ht$ WH@I@H-	* MHIHHD$0LHl$(HH LH${ HGL
) DC(H) HHD$ 1} HOE3HOHtCHII      f     IcD$PHD$PI#I;wIL;rH\$XHl$`Ht$hH@_LHHZ HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt3%
 HE HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHM2 LvLu@II^I^uHtFHHHH;teLLMt3`
 I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHMG1 ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+t	Z
 II^H\$XH    HC    HC    HtFHHHH;tdHHHt3
 H( HH{H{LHSE3L9C~JL    
u 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH@HD$0H\$pMHHHJs HHHGHFHHGLL+tX
 H^H\$hININ8 HHIFHCIFHCIIFIFLL+tX
 HWV(E3LGMtlHII      @ f     IcD$hHD$hI#I;w
IM;r#H$2 HD$(LH$ H
v% 艷 ̉T$ L
$ H
^% Qu MHO% HHH\$pH@A^_^H\$Ht$WH`HLH4% HHHs3HD$ HGH;t'H;tH
 Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@v H\$xH$   H`_H\$Hl$VWAVH`HLHa$ HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH
 Ht
H HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@hu L\$`I[(Ik0IA^_^N`H\$UVWHHpHcy(3H)t$`WuH9yt"H	
 Ht
H HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM+ Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tH
 Mt
I HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHM* H$   Hp_^]s^HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t]LLMt3h
 I HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHM+ WEIHEIHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHM* LEHUIHM!
 HM
 IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;t[LLMt3H
 Ih HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHM* WEIHEIHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHM8* LEHUIHM
 HM
 IL$   I[8Is@IA_A^A\_]H\$UVWATAWHHpB(L
c DA(LHD$ Hf H
 _ I3IHEHFH;t'H;tHv
 Ht
H HHH~LHEHEHHELELNHEHE0HEIHHuH+HHHH~!D  HE(A)HH;}LEMHMXn MgH~IGHOM HELeI;uL9tqMt"MtHHIL;   HGL$   MMHL;tH}
 Mt
I HHL$   LgLHGHUHHEHUHUHUHU0HUHMLGLH}IHH+HHHH~"    HE()HH;}HMHMLm H$   HHpA_A\_^]0XH\$Ht$H|$ UHHpB(L
? DA(HHD$ HB H
S ] LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHM HFHOLFHUL	HEHAHEHUHUHUHULELMLQLHUIHMHH+HHH~*    A(fAXA)HH;}
LELMMHMH^ L\$pHI[Is I{(I]H\$UVWHHpB(L
 DA(HHD$ H H
 V\ H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM HOHM(LFLEHFHEL	LMHAHEHELQLQHEHEHEHE HEHE(HEIHH+HHH~1@ ff     A(fA^A)HH;}
LELMMHMH H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM辺 LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMH( HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM^ HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHM˴ HH\$xH`]H\$Ht$WHPeH%X   HT    )t$@HЋ9Hr    HcF(3HfnY5o ~nHFHl$`Hn)|$0=+ H4   D)D$ EWf     HH(TfA.zt	YG
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
q 
 =q DVV H
wq XǊ Y/ o V
 HHPUWAVHhH   HEHXHp MHH3}׋A(D$ L
 M@H
 c DINHthIII      fff     IcEgHEgI#I;w
IL;r#H  HD$(MH H
 k HFHELuEEHuH;H{LvMt3
 I2 HLsHUHM HHE7HvHCH;t'H;tH
 Ht
H HH;HsLLEHEHEHEHEHEgHEH]LKIHH+HHHH~+fD  HE7HM(fXA)HH;}LEMHM HM'<
 HL$   I[0Is8IA^_]@SH HHI
 HH [H%
 HT$WH0HD$(H\$@HHD$     IHHH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHGHFHHGLL+tC
 H^H\$HHOHO I HHHGHCHG HCHWHGHG LL+tC
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHHHK
 Hx
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IrHHHO$
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IbHHGHO
 H
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3^
 I~ HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHMK HwHu@HH^uMt3
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHM Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ) HHIFHFIIFLL+t@
 InH~H$   3HH_WD$(Ht3
 Hν HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$H IFF HHpA^_^][HL$VWAVH@HD$0H\$pILHHJ HHIFHCIIFLL+t\?
 H{H|$hHNͼ HHHFHGHHFLL+t&?
 INK HCHD$ L
 DHP H

 _ E3AHSII      HtULfD  HcAD$hHD$hI#I;w
HH;r&H HD$(LLHY H
Z
  HOHtSH     IcD$hHD$hI#I;w
IL;r#HD HD$(LHM
 H
 詝 HH\$pH@A^_^H\$Ht$H|$ AVHpA L
 LBHH

 D$ L7[ I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHD$0HFH;t'H;tH
 Ht
H׺ HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~  HD$0()HH;}HL$@HL$P\ L\$pI[Is I{(IA^H MHq HD$(H
   H\$Ht$H|$ AVHpA L
I	 LBHH
 D$ LY I~3DHtFIHI      fIc$   H$   H#I;   IL;rIHHD$0HFH;t'H;tH8
 Ht
HS HHH~HHD$@HD$PHD$0HD$XH$   HD$`HL$@LFIHt$hHH+HHHH~HD$0()HH;}HL$@HL$P[ L\$pI[Is I{(IA^H: MH	 HD$(H
|
 蟚 H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	,
 Ht
HG HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHM Hcw HuH9wt"H
 Ht
H袷 HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHMh (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H誶 HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHM WEHHE'H~Ht3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHM LEHUI4HM1
 HM&
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 Hڴ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHME WEHHE'H~Ht3
 H, HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM LEHUIwHMt
 HMi
 IL$   I[(Is0IA^_]H\$Ht$UWAVHHpB L
 DA LHD$ H H
= PF I3I~HEHFH;t'H;tH
 Ht
H HHH~LHEHEHHELELNHEHE HEIHHuH+HHHH~ HE(A)HH;}LEMHMT IFH~MvHEHGI;t'L;tH9
 Mt
IT HHLwHHEHEHEHEHE HEHMLGIH}HH+HHHH~&fff     HE()HH;}HMHMT L\$pHI[(Is0IA^_]H\$Ht$H|$ UHHpB L
 DA HHD$ H" H
 D LHEL3HEHEHEHEHELELMHOHH}HH+HHЋHH~)fD  A(fAXA)HH;}
LELMLHMѡ LOLGHNHEHEHEHEHEHEHMLMLEM@IHH+HHH~,ff     (fAXA)HH;}
HMLMHHMR L\$pHI[Is I{(I]H\$UVWHHpB L
  DA HHD$ H  H
 FC H}(HEL3HEHEHEHE HEHE(HELELLMHOHHH+HHЋHH~)fD  A(fA^A)HH;}
LELMLHM豣 HGHE(HUHNHUHUHUHU HML HUHU(LELHIHUHH+HHH~% A(f^A)HH;}
HMLEMHMH/ H$   HHp_^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHMΡ LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHMK HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM~ HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM HH\$xH`]HHPVWAVH   HD$hHXHh )pMHH3|$0I@HD$ L
 DA H H
 CO DIVHteIII      Ic$   H$   I#I;w
IL;r#H^ HD$(MH H
` Í H;H{HnHt3
 H被 HHkIH$   HFH$   HH$   HvH;t'H;tH:
 Ht
HU HH;HsHHD$8HD$8HD$HH$   HD$PH$   HD$XH\$`HkHHH+HHHH~MH$   (4H$   ()D$pHL$p';H$   (fYfXHD$8)4HH;|LHHL$Hq	 HL$   I[0Ik8A(sIA^_^HT$WH0HD$(H\$@HHD$     IHHH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+tM,
 H_H\$HHN辩 HHHFHCHVHFLL+t,
 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHH$HK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHOT
 HK
 HH\$@H0_HG  @SH0HD$     HQHs  HH0[H\$WH HHQHtLAL+I  3HCHCHCHӾ H@t
    H HH\$0H _@SH HQHHt.LAL+I>  3HCHCHCHi HH [HY HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXH
 D$(HD$0HT$83HL$ HD$8HD$@H HD$ 
 H HGL HD$0HL$0 H\$WH HHQ HtLA0L+I8  3HC HC(HC0Hc H@t
8   HU HH\$0H _@SH HQ HHt.LA0L+I  3HC HC(HC0H HH [H HH [@SH HHHSH
a
 H3H
HJHH
 H HHH [HAHH`HAHH`H\$WH H HHAH荹  HV HGHt
8   HE HH\$0H _@SH H HHAH3  H HCHH [@SUVWATAUAVAWHxHD$(H H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HHv HHHL$ H HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ H
 HIFHAIFHAIFHAH IV   HD HHNط  L- L.H' IGIO躷  MoM/H  I  IV HtMF0L+I  3IF IF(IF0M.HHL$`H3 HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+I  H{pH{xH   HK8]  HS HtLC0L+I  H{ H{(H{0H HH\$0H _H\$WH H,   t
  H HH\$0H _H\$Ht$WH H  HHt*L  L+IO  3H  H  H  H5q H   H  HKpH=޼ HKPH{@q  Hs@HKHs8H{\  HsH3H\$0Ht$8H _HL$SH0HD$ HH HLALD$HHp I HBI@HIHHA   HA    HyrHH  IE3  HH0[HL$WH0HD$ H\$PHHH HHBHAHBHAHBHAH H 蓭  HO8HL$HHʲ HHC@HAHCHHAHCPHAHSXH   HSpHOpL  HH\$PH0_@SH HHI HtCHS(| LC0H*L+C IHLI?LHS   3HC HC(HC0H HH [H\$WH Ht
   HR HH\$0H _H\$WH H<t
8   H HH\$0H _H\$Ht$WH HHHHE
 ' HH ' HH
 ~' HHW+ HH- ڿ
 H7
 HS' HH D' HH
 5' WPH`
 HHn- 
 H
 H	' HH[ & HH
 & HH
 HH&- H
 H
 H& HH & HH
 & WH
 HH, 
 O|tttt3   H
 HW& HH H& HH
 9& Hȋ
 HHt, 
 O|  [  	  H
 H% HHg % HH
 %    H4
 HH
, ,
 H
 H% HH+ % HH8
 %    H
 HH+ 
 Hu
 HY% HH J% HH4
 ;%    H
 HHr+ 
 Hi
 H
% HH $ HH
 $    HP
 HH&+ H
 H}
 H$ HHs $ HHD
 $    H
 HH* 
 H?
 Hs$ HH) d$ HH>
 U$    H
 HH* 
    tB  Hu
 H$ HH $ HH
 # H   H
 H# HH # HH
 # H W  L   H> H
 H# HH # HH
 r#    H
 HH) ʻ
           H H"# HH # HH] # HH " HH;) ]
 L   H> L   H> L   HH !> L   H2? L   HHQ <= L   Hm? L   HH < #  H
 HS" HH) D" HH
 5" HHc &" HHl( 
 L   H= L   H(> L   HH? R= L   Hc> L   HH m< L   H> j  H
 H! HHp ! HHe
 |! H   H
 Ha! HHS R! HH
 C!    H
 HHz' 
 H
 H! HH ! HH
      H
 HH-' O
 Hd
 H  HH   HH
      H
 HH& 
 L   H; H
 Hm  HH ^  HHp
 O    H
 HH& 
 H
 H  HHM   HH
     HH
 HH6& X
 H
 H HH  HHd
     H۶
 HH% 
 HP
 H HH u HHO
 f    H
 HH% 
 H
 H6 HH ' HH
     H_
 HHM% o
 H
 H HHV  HH
     H
 HH$ !
 H
 H HH  HH
 |    Hö
 HH$ Ӷ
          tB  Hz
 H& HH  HHI
  H   H
 H HH  HH
  H l  H
 H HHb  HHo
  HHt  HH# 
 L   HHV 8   H
 HM HH > HH
 /   H
 HHf# 
    tzt?   H
 H HH  HHs
  H jHF
 H HH`  HH=
  HU 4H
 H| HH* m HH
 ^ H HO H" H
 y tIH	 H* HH  HHe	  HHWX0  HHF" h
     tLH	 H HH~  HHS	  HH    HH! 
 H	 H HHB } HHG	 n WxH
 HH! ɳ
 H.
 HB HH! H\$0Ht$8H _H%
 H%
 @WHPHD$ H\$hHp H3HD$HHHD$@   3H|$8@|$(E3H9 HL$(1  HT$(H胲  HD$@HrQHHL$(H=   r<t
 HAH;rt
 H+Hsd
 H'vW
 H H   H   H  HHL$HH3 H\$hHP_@UVWATAUAVAWHl$H   HEH$   Ho H3HEA؉]HLHUE    A}NH
 HE3HEHEH HEEHUHM
 H HEH1 HM H    HB    HB    E   HE   HE    E A   HH HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtH ^
 u
HJ  H{rHHA   I;LBMtH #
 u
H  H{rHHA   I;LBMtHg 
 uDHu>LFIH+HgfffffffHHHH?H  IHT  HF   H{H{rHH?A   I;LBMtH Hn
    Hs	3Hu{A^HE   HE    EIE3HUHM  ]HUH~  HM財  3IV(HEH;tIE3HM  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHMB  DmHUH2~  HM  HEHrPHHMH=   r<t[
 HAH;rK
 H+Hs;
 H'v.
 H] HNH
 HE3HEHEHL HEEHUHMf
 Hw HEHl- HMa HMH3 H$   Hİ   A_A^A]A\_^]  @SH HH(  HKH [  @UVWATAUAVAWH$@H  HD$8H$  HUk H3H   MHHL$@  HHPHH HL$P HH }Ht HL$P n  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<HN HL$P HHS HH y HHD$ T׬
 HL$(Lt$ I+IHHLI?LAxcIcH<HLfK4H HL$P HH@ HH  HBT7 c
 Md$HAxLt$ H HL$P HH 4
 HL$ Ht2HT$(f HL$0H+L$ IHHLI?LHT$   HU`HL$@葪  H0 tSHEX   HEP    E@ A	   H HM@  LE@HU`H   Ex  H* H    H0 tSHEX   HEP    E@ A   H HM@K  LE@HU`H   Fv  H! H   9 Hz0 tSHEX   HEP    E@ A
   Hu HM@  LE@HU`H   Gt  H # H    H[0 tSHEX   HEP    E@ A
   H& HM@  LE@HU`H   Hr  Hy, H   { H<0 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H. HM@ H0 tXHE`H}xHCE`H
7
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@Hv' HM@ H/ tXHE`H}xHCE`H
ӳ
 HM@3HMHHMPHD$ D$(HUHHL$ T
 HE HE@H, HM@O H/ tXHE`H}xHCE`H
o
 HM@3HMHHMPHD$ D$(HUHHL$ 
 Hi HE@H# HM@ H/ tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ 
 Hݠ HE@H% HM@ H/ tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ (
 H HE@H& HM@# Hd/ tXHE`H}xHCE`H
C
 HM@3HMHHMPHD$ D$(HUHHL$ Ĩ
 H} HE@H2" HM@ H@/ tXHE`H}xHCE`H
߱
 HM@3HMHHMPHD$ D$(HUHHL$ `
 H HE@H# HM@[ H/ tXHE`H}xHCE`H
{
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H
 HE@H& HM@ HEX   HEP    E@ A   H_ HM@  LE@HU`H   l  H
$ H    HL$WH0HD$ H\$HHHH
 HHQ3HHBHKA
 H HHSHOHA   HA    HyrHH  IE30  HH\$HH0_HL$WH0HD$ H\$HHHH#
 HHQ3HHBHK
 H
 HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHK!
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_@SH HHHSH

 H3H
HJHH
 H HHH [HL$WH0HD$ H\$HHHHî
 HHQ3HHBHKQ
 H HHSHOHA   HA    HyrHH  IE3@  HH\$HH0_@SH HHHSH
A
 H3H
HJHHӤ
 H HHH [@SH HHHSH

 H3H
HJHH
 H HHH [@SH HHHSH
 H3H
HJHHS
 H HHH [@SH HHHSH
 H3H
HJHH
 H HHH [HL$WH0HD$ H\$HHHH3
 HHQ3HHBHK
 Hi HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH Hߚ HHH>  H
 HOH
 t
8   H HH\$0H _H\$WH H
 HHHޓ  H?
 HOHJ
 t
8   H HH\$0H _H\$WH H HHH~  H߫
 HOH
 t
8   H0 HH\$0H _H\$WH H HHH  H
 HOH
 t
8   H HH\$0H _H\$WH H HHH辒  H
 HOH*
 t
8   Hp HH\$0H _@SH0HD$ HHo HHŪ
 HA(H0ϡ
 H  HHKHtHP tHC    H0[@WH0HD$ H\$@HH HH^
 HA(H0h
 H HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH_ HH
 HA(H0
 H  HHKHtHP tHC    H0[@WH0HD$ H\$@HH HH~
 HA(H0
 H HHKHtHP tHC    @t
@   H HH\$@H0_H\$WH HHd HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   W L   H988L  M+IHLI?LI  3H   H   H  H   ؜  H   H [H%
 HL$SH0HD$ HHۜ HE3LAHH` HLC0LC8LC@LCHLCPLCXLC`LChLCpL   L   L   L   L   L   L   L   L   L   L   L   L   L   L   L  L  H   HH0[LWATAUAVAWH@  Iǃ8I[Is A)sHVZ H3H$   HHT$HHHL$PWD$p3ID$XHt$hB $    _   Iǃp   Ih@$  DFHJ IX:  HǄ$     H$  @$  DFH H$    HǄ$     H$  @$   DFH H$     HL$0HD$ L$  L$  H$   H/HT$0HtLD$@L+I  WD$0Ht$@H$  HrTHH$   H=   r<tѝ
 HAH;r
 H+Hs
 H'v
 H HǄ$     H$  Ƅ$    H$  HrTHH$  H=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 HU HǄ$     H$  Ƅ$   H$  HrTHH$  H=   r<t՜
 HAH;rŜ
 H+Hs
 H'v
 H Lc(A4$HǄ$     H$  Ƅ$   A   Hj H$    HL$  HT$0HP(HHD$pH;t*HH\$pHJHL$xHBH$   H2HrHrH\$pHT$0HtLD$@L+I;  WD$0Ht$@H$  @  A$ `   HǄ$     H$  Ƅ$   A   H H$  
  HǄ$     H$  Ƅ$    A   H H$     HǄ$     H$  Ƅ$   A   H H$    HL$0qHD$ L$  L$   H$  HHT$0HtLD$@L+IϺ  WD$0Ht$@H$  $  H$     H$    H\$Ps,HǄ$     H$  Ƅ$   A   H# H$    HL$  HT$0HP(HHL$p6  HT$0HtLD$@L+Ik  WD$0Ht$@H$  p  HD$pK, a   E$H H
 UHǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$    A   H5 H$     HǄ$     H$  Ƅ$   A   H H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Ht$@H$  5  H$   '  H$    E$H H
W W$  Ic$WD$0Ht$@L$  HL$0һ  L{0L$   HT$0I詄  HT$0HtLD$@L+I.  HǄ$     H$  Ƅ$   A   H H$  x  HL$  HT$0HPHHL$X4  HT$0HtLD$@L+I蹷  WD$0Ht$@H$    LMc$LHt$XA   IrmIHHPLL+AH+MSIIN4    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sIJHJIHIM;r b   E$H H
 VHǄ$     E3L$  D$  EFH H$    HǄ$     L$  D$   EFH; H$     HǄ$     L$  D$  EFH H$    Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0Lt$@H$  9  H$   +  H$    E$H H
_ $  Ic$WD$0Lt$@L$  HL$0ٸ  HsHHT$0H踁  HT$0HtLD$@L+I=  HǄ$     L$  Ƅ$   A   H H$    HL$  HT$0HPHHL$XC  HT$0HtLD$@L+Iȴ  WD$0Lt$@H$    MMc$MLt$XIrrHHHPML+IH+MSIIN<    M@      IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r c   E$H H
߶ fHǄ$     E3L$  D$  EFH H$  /  HǄ$     L$  D$   EFH{ H$     HǄ$     L$  D$  EFH H$  ž  Ic$HL$0HD$ L$  L$   H$  H HT$0HtLD$@L+I  WD$0Lt$@H$  I  H$   ;  H$  -  E$H H
 &$  Ic$WD$0Lt$@L$  HL$0  Hs`HT$0H~  HT$0HtLD$@L+IM  L$  L$  E33H$    A   H H$  葽  HL$  HT$0HPHHL$XM~  HT$0HtLD$@L+Iұ  WD$0Lt$@H$  '  MMc$MLt$XIrlHHHPML+IH+MSIIN<    MfD  IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sHKHJIHIM;r d   E3L$  L$  E33H$  踵  EFHa H$  P  L$  L$  E33H$   }  EFHj H$     L$  L$  E33H$  B  EFH H$  ڻ  HL$0HD$ L$  L$   H$  H9HT$0HtLD$@L+I
  WD$0Lt$@H$  b  H$   T  H$  F  DsxL$  L$  E33H$  耴  A   Hk H$    HL$  HT$0HP(HHL$prv  HT$0HtLD$@L+I觞  WD$0Lt$@H$  ~  HD$pD DCx e   H H
 L$  L$  E33H$    A   H$ H$  W  L$  L$  E33H$   脳  A   Hw H$     L$  L$  E33H$  G  A   H H$  ݹ  HcSxHL$0HD$ L$  L$   H$  H8HT$0HtLD$@L+I  WD$0Lt$@H$  a}  H$   S}  H$  E}  DCxH H
 >
$  HcSxWD$0Lt$@L$  HL$0  L   L$   HT$0Iy  HT$0HtLD$@L+IZ  L$  L$  E33H$    A   H H$  螸  HL$  HT$0HPHHL$XZy  HT$0HtLD$@L+I߬  WD$0Lt$@H$  4|  Lc[xE3Ht$XIrlIHHPLL+IH+MSIIN4    MfD  IDHBIHIDHBHIDHHR IuH|$HH\$PM;sIJHJIHIM;r  f   E$H H
 DC,H H
о oE3L$  L$  E33H$  蚰  EGH H$  2  L$  L$  E33H$   _  EGH` H$     L$  L$  E33H$  $  EGH H$  輶  LcC,Ic$HL$0HD$ L$  L$   H$  HHT$0HtLD$@L+I  WD$0L|$@H$  <z  H$   .z  H$   z  E$H H
z 
DC,HJ H
c 
$  HcS,WD$0L|$@L$  HL$0ŭ  Ic$W$  L$  LD$0H$  蚞  L   H$  Ic  H$  &c  HT$0HtLD$@L+I  L$  L$  E33H$  蘮  A   H H$  .  HL$  HT$0HPHHL$Xu  HT$0HtLD$@L+Io  WD$0L|$@H$  x  MLck,MM   Lt$X@      LcC(IIr{I$LHP0M^O˾   H+IXHHH<    LfHJICJHJICJH
IJI7HICJM[ HR`HuH\$PE3I;s(M$HHL+IKJIHRIuIM;?H|$H( g   Lk,EE H
 H
* L$  L$  E33H$    A   H H$  艳  L$  L$  E33H$   趬  A   H H$   L  L$  L$  E33H$  y  A   HD H$    IcU HL$0 HD$ L$  L$   H$  HjHT$0HtLD$@L+I>  WD$0L|$@H$  v  H$   v  H$  wv  EE H H
չ pIcU W$  H$  C\  H$  H   H   H$  H   υ
 L$  L$  E33H$  U  A   HX H$    HL$  HT$0HPHHL$Xr  HT$0HtLD$@L+I,  WD$0L|$@H$  u  MMc] MHt$XIrvH   HHPLL+Ȼ   H+MSIIN4    Mff     IDHBIHIDHBH;IDHHR IuH|$HH\$PM;sH   JHJIHIM;r! h   L$  L$  E33H$    A   Hj H$  蝰  L$  L$  E33H$   ʩ  A   Hշ H$   `  L$  L$  E33H$  荩  A   HX H$  #  HL$0HD$ L$  L$   H$  H肽HT$0HtLD$@L+IV  WD$0L|$@H$  s  H$   s  H$  s  L   M<$L$  L$  E33H$  ¨  A   HͶ H$  X  HL$  HT$0HPHHL$Xp  HT$0HtLD$@L+I虣  WD$0L|$@H$  r  HD$XHI$0 i   L$  L$  E33H$    A   H H$  謮  L$  L$  E33H$   ٧  A   H H$   o  L$  L$  E33H$  蜧  A   Hg H$  2  HL$0HD$ L$  L$   H$  H葻HT$0HtLD$@L+Ie  WD$0L|$@H$  q  H$   q  H$  q  D   L$  L$  E33H$  զ  A   H H$  k  HL$  HT$0HP(HHL$ph  HT$0HtLD$@L+I  WD$0L|$@H$  q  HD$p   B j   EE H+ H
h  L$  L$  E33H$    A   Ht H$  觬  L$  L$  E33H$   ԥ  A   H H$   j  L$  L$  E33H$  藥  Hh H$    IcU HL$0$HD$ L$  L$   H$  H莹HL$0SV  H$  o  H$   o  H$  o  EE H H
7 $  IcU L$  HL$0l  H   HHal  HL$0U  H H$  p  HL$  HT$0HPHHL$Xl  HL$0U  H$  o  Mc] E3Lt$XIroHHHPML+Ȼ   H+MSIIN<    M    IDHBIHIDHBHIDH9HR IuH|$HH\$PM;sLKHKIHIM;r k   EE H H
 fH H$  o  Hα H$   }o  H] H$  ho  IcU HL$0HD$ L$  L$   H$  H胷HL$0HT  H$  m  H$   m  H$  m  EE H H
0 $  IcU L$  HL$0j  H   HHVj  HL$0S  H H$  n  HL$HHL$  HT$0PHHL$Xj  HL$0S  H$  
m  E3Mc] E3Ht$XIrjHHHPLL+A   L+MSIIN4    MfD  JD
HBJ
HJD
HBHJD
J9HR IuH\$PM;sHJHJIHIM;r `   D$H   LL$HM}  h   D$H    LL$HMn | o   H{(DH H
 HsxDHT H
  $  HcL$  H$   ?i  HcLHL$0>W  H   HHU  HL$0RU  H$   R  H$   H  p   Ht$ LL$   H$   H$  U HH H$  T  H\$PHC    HCHCHCo v   DHe H
 HcHHCE x   EE H. H
{ IcE HCHL$X4Q  HL$pYM  H$   H3	 L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH H2e HH3H   H*HtNH  @4 L   HH  I+HHLI?LIc  H   H  H  H   Ht(L   L+Io  H   H   H   H   Ht(L   L+I;  H   H   H   H   Ay
 H   HtNH   q3 L   HH   I+HHLI?LI蔆  H   H   H   H   Ht(L   L+I蠙  H   H   H   HS`HtLCpL+Ir  H{`H{hH{pHSHHtLCXL+IM  H{HH{PH{XHS0HtLC@L+I(  H{0H{8H{@Hu HKHH\$0Ht$8H _:  @SVWATAUAVAWH  HǄ$  )$  H3 H3H$p  LL$8MLHIHL$`,b  IHL$xJ   $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGH H$0  董  IH$0  IPH$H  HrTHH$0  H=   r<tw
 HAH;rw
 H+Hsw
 H'vw
 H؞ tiHe
 H$   3H$   H$   H HD$8D$@H$   HL$8u
 Hr H$   H
 H$   © HǄ$     H$   Ƅ$   A   H H$  u  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+I脖  W$0  H$@  H$  HrTHH$  H=   r<tLv
 HAH;r<v
 H+Hs,v
 H'vv
 HN HǄ$     H$  Ƅ$   A   H% H$  X  HǄ$h     H$`  Ƅ$P   A   H H$P  !  HǄ$     H$   Ƅ$   A   H H$    H$0  輴HD$ L$  L$P  H$  IFH$0  Ht(L$@  L+I  W$0  H$@  H$  cd  H$P  Ud  H$  Gd  D$0HT$0HL$`_  HǄ$     H$  Ƅ$   A   H H$    IH$  IPH$  c  tiH0|
 H$   3H$   H$   H HD$8D$@H$   HL$8r
 Ho H$   H
 H$   荦 HǄ$     H$  Ƅ$   A   Hɖ H$  @  IL$  H$0  IPHHL$H_  H$0  Ht(L$@  L+Ix  W$0  H$@  H$  b  HǄ$     H$   Ƅ$   A   Hn H$  衞  HǄ$h     H$`  Ƅ$P   A   H H$P  j  HǄ$     H$  Ƅ$   A   H H$  3  H$0  HD$ L$  L$P  H$  I菫H$0  Ht(L$@  L+I]  W$0  H$@  H$  a  H$P  a  H$  a  HD$H D$0HT$0HL$`\  HǄ$     H$  Ƅ$   A   H H$  K  IH$  IPH$  a  tiHty
 H$   3H$   H$   H HD$8D$@H$   HL$8o
 Hl H$   H
 H$   ѣ HǄ$     H$  Ƅ$   A   H H$  脜  IL$  H$0  IPHHL$H=]  H$0  Ht(L$@  L+I輐  W$0  H$@  H$  `  HDFxHU H
 HǄ$     H$   $  A   H H$  ̛  HǄ$h     H$`  Ƅ$P   A   H* H$P  蕛  HǄ$     H$  Ƅ$   A   H H$  ^  HcVxH$0  LHD$ L$  L$P  H$  I趨H$0  Ht(L$@  L+I脏  W$0  H$@  H$  ^  H$P  ^  H$  ^  Wt$0HcVxW$0  H$@  LD$0H$0  脒  L$0  9Vx~*ILD$H@      IH[HHI;Vx|;^x}HcIHL$`Y  HǄ$     H$  Ƅ$   A	   Hl H$    IH$  IPH$  ]  tiH0v
 H$   3H$   H$   H HD$8D$@H$   HL$8l
 Hi H$   H
 H$   荠 HǄ$     H$  Ƅ$   A	   H H$  @  IL$  H$  IPHHL$HY  H$  Ht(L$   L+Ix  W$  H$   H$  \  H$   H$(  E33H$    A   Hh H$  蛘  H$`  H$h  E33H$P  ȑ  A	   Hà H$P  ^  H$  H$  E33H$  苑  A   Hޟ H$  !  H$  HD$ L$  L$P  H$  I}H$  Ht(L$   L+IK  W$  H$   H$  [  H$P  [  H$  ~[  HD$H D$0LD$0(HL$`
.  H$   H$(  E33H$  蚐  A   H͞ H$  0  IH$  IPH$  Z  tiHYs
 H$   3H$   H$  H HD$8D$@H$   HL$8i
 Hf H$   H
 H$   趝 H$   H$(  E33H$  ͏  A   H  H$  c  IL$  H$  IPHHL$HW  H$  Ht(L$   L+I蛊  W$  H$   H$  Y  HDF,H( H
u H$`  H$h  E33H$P    A   Hq H$P  褕  H$  H$  E33H$  ю  A   H H$  g  H$   H$(  E33H$  蔎  A   H H$  *  HcV,H$  HD$ L$P  L$  H$  I肢H$  Ht(L$   L+IP  W$  H$   H$  X  H$  X  H$P  X  t$0HcV,W$  H$   LD$0H$  S  L$  L|$H9V,~$Ifff     IH[HHI;V,|;^,}HcIHL$`bS  HT$`HL$8P  HT$xI19  MtL$   M+IIT  MtL$@  M+II7  H$@  HtH+HLjw  MtLD$XM+II   HL$`*  H$p  H3赇 ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xH" H3HEH3HI  HE   3Hu@uDFHh HMߒ  HCHMH;sTHHUH;wHH}H+H;CuVH譇  HH;HKHtcHA   HqHyrHHH;H;Cu
   Hj  HKHt'HA   HqHyrHHHU  
  HC HEHrPHHMH=   r<tf
 HAH;rf
 H+Hsyf
 H'vlf
 H蛍 HE   HuE A   H: HM赑  HCHMH;sVHHUH;wJH}H+H;Cu
   H聆  HH;HKHtcHA   HqHyrHHH;H;Cu
   H>  HKHt'HA   HqHyrHHHU  ޖ  HC HMT  HE   HuE A   Hk HMڐ  HUHI  HMT  HE   HuE A	   H HM蝐  HUHI  HMvT  HE   HuE A   H HM`  HUHI  HM9T  HE   HuE A   H HM#  HUHFI  HMS  HE   HuE A   Hw HM  HUH	I  HMS  HE   HuE A   H HM詏  HUHH  HMS  HE   HuE A   Hq HMl  HUHH  HMES  HMH3虃 H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLH?  WEE3L}HMvK  HUH>  HMaK  HUH>  HMLK  Ic~xH} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
: _
 HQM+IIHHH+IMI;LCL;ICHM  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
 _
 HQM+IIHHH+IMI;LCL;ICHMZ  HMHtH9HHMHUHz=  HMI  HUHe=  HMI  Ic~,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
Ė .^
 HQM+IIHHH+IMI;LCL;ICHMy  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
< ]
 HQM+IIHHH+IMI;LCL;ICHM  HMHtH9HHMHUH<  HMxH  Ic~(H} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
p \
 HQM+IIHH+II;LCL;ICHM+  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
 \\
 HQM+IIHH+II;LCL;ICHM譧  HMHtH9HHMHUH:  HM4G  Ic^(H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HMɀ  HMHtHHHMHUH9:  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM_  HMHEHt)HH H;Mu   HM5  HMHtHHHMHUH9  HMF  Ic^,H] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM  HMHEHt)HH H;Mu   HM  HMHtHHHMHUH9  HUHtLEL+IW}  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HE HXHpHx H H3H   EELHHL$ Z  HL$8N  E3LmH HL$0  HU(HL$ X  HILA  HE@HrQHHM(H=   r<t\
 HAH;ro\
 H+Hs_\
 H'vR\
 H聃 HL$8趒  LmH' HL$01  HU(HL$ CX  HI@  HE@HrPHHM(H=   r<t[
 HAH;r[
 H+Hs[
 H'v[
 H    9sx   HL$8  LmH HL$0  HȲ.  HȋX
 HU(HL$ W  HI?  HE@Hr4HHM(H=   r uAHAH;s1H+Hr!H'wHO ;{x!g[
 Z
 Z
 Z
 HL$8]  LmH HL$0ؿ  HU(HL$ V  HI^?  HM(J  9s,   f     HE@   Lm8E( HL$8  LmHM(I  Hr HL$0h  HȲ.~  HȋW
 HU(HL$ eV  HI>  HM(I  ;{,~E  9s(|   @ HE@   Lm8E( HL$8f  LmHM(II  H> HL$0ؾ  HȲ.  Hȋ3W
 HU(HL$ U  HII>  HM(H  ;{(~9s(|yHE@   Lm8E( HL$8  LmHM(H  HZ| HL$0X  HȲ.n  HȋV
 HU(HL$ UU  HI=  HM(H  ;{(~9s,|yHE@   Lm8E( HL$8f  LmHM(IH  HF HL$0ؽ  HȲ.  Hȋ3V
 HU(HL$ T  HII=  HM(G  ;{,~{,|zfHE@   Lm8E( HL$8  LmHM(G  HΌ HL$0X  HȲ.n  HȋU
 HU(HL$ UT  HI<  HM(G  ;s,~HM_T  HMV
 H   H3w L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx H H3H   LHHL$04U  HL$H  E3L}H[z HL$@a  HU0HL$0sS  HI;  HEHHrQHHM0H=   r<tW
 HAH;r
W
 H+HsV
 H'vV
 H~ HL$HQ  L}Hy HL$@̻  HU0HL$0R  HIR;  HEHHrPHHM0H=   r<tV
 HAH;ruV
 H+HseV
 H'vXV
 H}    9_x       HL$H覌  L}H# HL$@!  HȲ.7  Hȋ|S
 HU0HL$0R  HI:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH| ;_x!gU
 U
 U
 U
 HL$H  L}H> HL$@l  HU0HL$0~Q  HI9  HM0D  ,   @ ff     HEH   L}@E0 HL$H膋  L}HM0iD  H HL$@  HȲ.  HȋSR
 HU0HL$0P  HIi9  HM0D  ;w,~     HMP  HMR
 H   H3Nt L$  I[ Is0I{8IA_A^]H\$WH H<t
  H{ HH\$0H _H\$Ht$WH H3H  Ht;H  $
 H  L   L+Iq  H  H  H   H  H*HtNH  
 L  HH  I+HHLI?LI6`  H  H  H  H  B  H  Ht(L  L+I6s  H  H  H  HKp   HKXHt)HS`6	 HSXLChL+Ip  H{XH{`H{hHK@Ht:HSHD HKPHH+K@HHLI?LHS@o_  H{@H{HH{PHS HtLC0L+Ir  H{ H{(H{0HSHtLCL+Ier  H{H{H{H\$0Ht$8H _H\$WH HHA  HOXA  LG8HT$0MHO8M )p  HO8@y LG(HT$0MHO(M p  HO(y HOH\$8H _<A  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hsl  HH_8H\$HH3HsT  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"   H  H]w HH [H\$Ht$WH H3H0  Ht;H8   H0  L@  L+Ijm  H0  H8  H@  H  Ht(L   L+I^  H  H  H   H  Ht(L  L+IRo  H  H   H  H  H*HtNH  ; L  HH  I+HHLI?LI[  H  H  H  H  Ht;H   H  L  L+IWl  H  H  H  H  HtNH   L  HH  I+HHLI?LI
[  H  H  H  H  Ht;H  P H  L  L+Ik  H  H  H  HKpHH\$0Ht$8H _HT$SH0HD$(H3D$ HHBHBD$    H  H  L  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H[  HH0[@SH0HD$     H  H2  HH0[@SH0HD$     H  H2  HH0[H   HD$0LH0  L  HQpHD$ I  tWHZT
 HD$P3HD$XHD$`H HD$@D$HHT$XHL$@J
 HG HD$PH
 HL$P~ 3HĈ   @USVWATAVAWH$ H  HEH H3H   EIHHHUH]E3Dd$4IHL$PS5  Lt$XL+t$PIL;vx   HMaI  H^xHU HM蜰  HIH
 HH. 聰  HHH
 HH f  H   HMvG  HxrH H
S
 HL$h3HL$pHL$xHEEHT$pHMI
 H%N HD$hH	
 HL$h} Dd$0H   H+   HWD$8Ld$HLD$0HL$8*  L'LgLgD$4   HNpLLD$8HT$PEt;    HT$8HtLD$HL+IY  WD$8Ld$HHT$PHtLD$`L+I?j  HHtLCL+I&j  L#LcLcHH   H3i H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH H3H   EEHHHUHL$H+3  Ht$PH+t$HHH;wx   HM9G  H_xH-~ HMt  HHF
 HH~ Y  HHF
 HH} >  H   HMNE  HxrH H
P
 HL$h3HL$pHL$xHEEHT$pHMdG
 HK HD$hH
 HL$h]{ 3t$`H   H+   HWD$0Ht$@LD$`HL$0  EuLHOpLD$0HT$HEt2  (HT$0H   LD$@L+IW  WL$0| WD$hHt$xHOpLL$hLD$0HT$HEt  
  (HT$hHtLD$xL+Ig  HT$0HtLD$@L+I#W  WD$0Ht$@HT$HHtLD$XL+Ig  HHtLCL+Ig  H3HsHs(H   H3Dg H$   ($  H  A_A^_^]@SVWH  HD$pHM H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   D  HxH^H+HH{ H$   ͫ  HH!D
 HH_{ 貫  HHD
 HH@{ 藫  H$  H$   B  HxrH H
8N
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`D
 HNI HD$HH2
 HL$Hx H   H+   HHL$H  HOpD$0D$(H\$ L HT$HHtLD$XL+IU  HH$  H3e Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E32HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK2WD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`HT$8HtLD$HL+IS  HL$`裌HL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xH~HHMp衣3D
 L   A   AA+iA+AD̉    AA+iD+EDD  H   HUpH  Q 3DL  L  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;r  H  H  (  H  H  4Q  H  H;H{H{H  H  H     (  H0  H8  H@  H|$ (     f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   H&d  HKHHt(HHH;Cu
   Hc  HCHtH8HCHH|$ (  H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hc  HHKHt,HH#H;Cu
   Hic  HCHtH HCH  H   L0  H  H    HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H
 H3HEHLHUHMm&  H]HLuI E3H;  HE   LeDeED$Hc HMk  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
yu <
 HSM+IIHL+IIM;HCH;HCHM豔  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
t 3<
 HSM+IIHL+IIM;HCH;HCHM  H]Ht*HC   LcH{rHHHU  H>p  H H]HEHrPHHMH=   r<t>
 HAH;r>
 H+Hs>
 H'v>
 He HUIE  M0  I  I  f  H]Ht HUH LEL+IH[  HHt'HV[ HLFL+I[  L&LfLfHMH3] L\$pI[@IsHIA_A^A\_]H\$L$WH0f.
X IH)t$ z	uA0LL$H \D$H菛	 (HCHL$Ht$HH;sEHHT$HH;w8H|$HH+HH;Cu
   Hf_  HSHt
HHH
HB$H;Cu
   H:_  HCHt0H(t$ HCH\$@H0_H\$WH HQ3HHtLA(L+I(L  H{H{ H{(HHtLCL+I\  H;H{H{H\$0H _Hy0HArH @SH H( HHH+  H5D
 HKHH [H%:;
 H\$ WHpHG
 H3HD$`3HHAIHAH@( HHL$@胰  HHL$ Ls  HHOLp   HD$8HrQHL$ HH=   r<t;
 HAH;r;
 H+Hs;
 H'v;
 Hb HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tO;
 HAH;r?;
 H+Hs/;
 H'v";
 HQb HHL$`H3Z H$   Hp_@SH H7 HHHD*  HB
 HKHH [H%9
 H\$ WHpH
 H3HD$`3HHAIHY HAH6 HHL$@  HHL$ Lܫ  HHOLVo Y  HD$8HrQHL$ HH=   r<t+:
 HAH;r:
 H+Hs:
 H'v9
 H-a HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t9
 HAH;r9
 H+Hs9
 H'v9
 H` HHL$`H3:Y H$   Hp_@SH H5 HHH(  HA
 HKHH [H%
8
 H\$ WHpH
 H3HD$`3HHAIH$X HAHA5 HHL$@L  HHL$ L<  HHOLm 蹭  HD$8HrQHL$ HH=   r<t8
 HAH;r{8
 H+Hsk8
 H'v^8
 H_ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t8
 HAH;r8
 H+Hs7
 H'v7
 H_ HHL$`H3W H$   Hp_@SH H@
 HHH'  He?
 HKHH [H%j6
 H\$ WHpHw
 H3HD$`3HHAIHV HAH?
 HHL$@謫  HHL$ L蜨  HHOLl   HD$8HrQHL$ HH=   r<t6
 HAH;r6
 H+Hs6
 H'v6
 H] HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tx6
 HAH;rh6
 H+HsX6
 H'vK6
 Hz] HHL$`H3U H$   Hp_@SH H, HHHd%  H=
 HKHH [H%4
 H\$ WHpH
 H3HD$`3HHAIHT HAH+ HHL$@  HHL$ L  HHOLvj y  HD$8HrQHL$ HH=   r<tK5
 HAH;r;5
 H+Hs+5
 H'v5
 HM\ HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t4
 HAH;r4
 H+Hs4
 H'v4
 H[ HHL$`H3ZT H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuH6?  HKHL$@HHHHL$HHtC *H;KuH?  HKHL$@HL$HHt	H HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LHr  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH>  HwHtlHHHF   HF     HHHd  C F ;H;OuH>  H_Ht$HC   HHC    H c  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	F HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf	 HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI LGHVH pMt/HWIU HOH+IHHLI?LH=  HNH+IHHHH?HH>  tLHVH蜋 HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LH,=  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   H3=  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   H<  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+HS-
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+-
 H[HI~H+LH,
 Ht$0H;H|$8IFIH\$@H A^HtH=  HSIH+H>  t!HH[I>H+LH,
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I=  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
b 6*
 HH|$0Xr  HHFHHHNI~IHH+LH+
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
(b )
 q  HH    HGLH3HHOH_ H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXH3
 D$(HD$0HT$83HL$ HD$8HD$@HY HD$ R*
 HC H
 HD$0HL$0K^ H3
 D$(HD$0HT$83HL$ HD$8HD$@HK HD$ )
 Ht H-
 HD$0HL$0] HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`H2
 D$(HD$0HT$83HL$ HD$8HD$@HX HD$ :)
 H+ H|
 HD$0HL$03] H\$WH HHH;Qt>H	)
 HtH HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH HHHtLAL+II  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
_ &
 o  HL    HCHHIHKH LCHH\$0H _@SH L
 HL II+HH;sH+IH H [H;   L H+II+HH;s\IIH+H;sH
X^ %
 HM+I3IHL+IM;HCH;HCFo  L
 L ILI+3HIL+I[ H
 HH+ٱ HH+HHϱ H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
Y] $
 HM+I3IHL+IM;HCH;HCH4o  HOLH3H+HL+I%Z HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH:  HSHt7HHH
HCH\$0H _H;CuHy:  HKHtHHHCH\$0H _@SH HH	Ht@HS6 LCH*L+IHLI?LH\3  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LH2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
Z B"
 HIh  HHCHHHHKLHVHT HCHH\$XHt$`H@_@SH 3HHHAHAe9  HH [H\$WH 3HHHHAHAHtNH
H;vH
Z !
 g  HHHCHHL    IHKH4 LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   H!9  HKHL$@HHHHL$HHtn
  /H;Ku
   H8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR蕂  HH@HH HH@HC    DD$@HHH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+IVA  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@H8| LHD$ HT$@HLH  HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHRu  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+IW?  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I?  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HJ  VH;Cu
   H>  HKHL$@HL$HHt03HA   HAHyrHH  IE3HJ  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
R 
 HM+I3IHL+IM;HCH;HCHq  HOHHH+HH+ HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LI9  HSHm HGH+HH   HCH+HL;w'HILHI  LCHWH~ LHtI HLCL+I9  HWH+HH<  tLHWH} HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+I9  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H;  HKHt@HH;H;Cu
   Ht;  HKHtHA   HHA      L  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I08  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
OO 
 Hd  HHCHH;H{LHVH{ HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH:  HSHt3H
HCH\$0H _H;CuH:  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+I(  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   HU:  HSHt<HHH
HCH\$0H _H;Cu
   H:  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+
 H[HI~H+LHg
 Ht$0H;H|$8IFIH\$@H A^HtH6  HSIH+HN9  t!HH[I>H+LH	
 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
K 
 HH|$0\  HHFHHHNI~IHH+LHU
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
J R
 |[  HH    HGLH3HHOHG H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   H7  HSHt
HHH
HBHCH\$0H _H;Cu
   H6  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
I 
 HM+I3IHL+IM;HCH;HCHD\  HOLH3H+HL+IUF HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+Il3  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH 3HHHAHAu6  HH [@SH0HE3HQ(DD$ HC   LCDD8tI IB< uH.>  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH=  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	fo	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ =  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
F 
 H;sLHH`g  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<tl
 HAH;r\
 H+HsL
 H'v?
 Hn7 HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t
 HAH;r
 H+Hs
 H'v
 H6 HC   HC    H{rHH  HH@  HH\$@H0_@SH E3HA   LAHDD8tIIB< u:  HH [@SH HA   IHA    E3 H;  HH [H\$WH HH  HH
 tHCh    H\$0H _HH{hH\$0H _H%`

 @SH H    Ht'  tH   s
 y	H [3H [@SH HMH   Ht9HuMuEAE3/
 uH   D@HhB  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|?  tsH   HT$0
 u]HtH   D@H
 u@H   HT$0
 u*IFHHGt
?  HOtHD$0HCH    HKH	
 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb>  tYHutH   DH
 u8H   HT$0
 u"H!>  HKtHD$0HGH    HOH
 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   
 tl  d  HE/   E3Lu'DuH   e
   HU'HHH  HZH  LM/L;sLHHM8a  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOhN
    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+3Z3  HUH}/r'HHu#E	
     	
 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   	
 H~LEHU]#H
> 	
 H
> 
 HUHE/HrPHH=   r=Et
 HBH;r
 H+Hs
 H'v
 HH/ HM7H3{( L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@
 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp H/
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   
 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKh
       HELELM/IICH}H+t.HMIICL   LǺ   
 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHM-3  3u#MH   N
 ;ELM/LELM/LEIrQIAH=   r=Et
 I@I;r
 L+Is
 I'v
 LI+ HM7H3|$ L$   I[0Is8IA^_]H   HtH%}
 H   HtH%e
 @SH0HD$ HH
 HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H9  HH0[H%
 @SH0HD$     HV;  HH0[H\$WH HhHHcPH
 H
hHhHcPH
 DhD
dHAH9  HOY
 HOH\$0H _H% 
 DL$ HL$SVWH0HD$ HHD$h    HY HH
 HAH   6
 D$h   H^E3HH 
 HHcHH
 H1HHcHhT1H\$XHh	 H
 HLGHrH?HCh    Cp    MtHHP^  HH0_^[DD$HL$WH0HD$ H\$HHD$P    Hy HH
 HAH   V 
 D$P   E3HWH 
 HHcPH
 H:HHcPDhDD:   HOI;  HH\$HH0_@SH0HD$     H9  HH0[H\$WH HxHHcPH
 H
xHxHcPHw
 DxD
tHAH7  HO	 HOH\$0H _H%|	 DD$HL$WH0HD$ H\$HHD$P    H
 HH   	 D$P   E3E3HWH	 HHcPH
 H:HHcPDxDD:   HO9  HH\$HH0_@SMPHMLLA@I Ht
H9AhsHAhH	 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   H	 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjH	 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
Ho	 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIH~Y	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI=5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH HG
 HHHI	 HO {	 HO(q	 H	 t
0   Hv! HH\$0H _H\$WH Ht
   HB! HH\$0H _H\$Ht$WH H'H	 @t   Hh  Ht$8HhH\$0H _H\$Ht$WH HH	 @t   Hx  Ht$8HxH\$0H _H\$WH H
 HH/  H1	 t
x   HO  HH\$0H _H8HD$ HHHcHHLHHt+HHPH1H;uH   Ht	 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLH  H\$ HSH HHCI  H$   HVHM HHFI  HHGWD$8HD$H    I  Hl$(HT$8H  ILl$8I;^F  M  @ HI5  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtHt U	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  HV  HGH+HA(  MtwHD$HI+HH?H;vV	 H    H=   r=At9	 IEI;r)	 L+Is	 I'v	 LI8 HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
) D	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
) t	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [H(H
L;v/	 K@HH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
' &	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _n5  H _H\$WH 3HHHHAHAHt:H
H;vH
(' 	 4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
x& 	 H3  HHCHHHHKLHVHK HCHH\$XHt$`H@_H(H?L;v	 J    H=   r<t	 HBH;rs	 H+Hsc	 H'vV	 HHH(~ H(LQLLAII+HH;s_H	I?L+III+H;sH
\% 	 L+II3IHL+IM;HCH;HCIH(C5  H(H\$WH 3HHHHAHAHt6H?H;vH
$ B	 l4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHH
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
$ 	 IHO uM  H    HHWHL$(HHO E7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wHT HH;_s%	 	 	 	 	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;v	 H    H=   r<t{	 HAH;rk	 H+Hs[	 H'vN	 H} 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
L" 	 L+II3IHL+IM;HCH;HCIH(#4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
! $	 L+HI3IHL+IM;HCH;HCIH(q4  H(@SH0WHs        fs I1  LHms HHks HHH
hs H谤 HIH
Ms H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
  	 ".  HHCHL4    HIHKHMHH I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
 F	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _4  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uH&  AE3'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AD  3ҋm%  AD$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH`   AE3S!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEu   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ=  AD`  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v?	 II   r<t&	 HBH;r	 H+Hs	 H'v	 HHH(!	 LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRB  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRWC  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@HS0  LD$PL;D$XuLHH\$HH0_H(HL;v	 J    H=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(LQLLAII+HH;s_H	IL+III+H;sH
 	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
( 	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
 	 L+HI3IHL+IM;HCH;HCIH(#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
 	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
 	 ,#  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH讕 HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
 *	 T"  HLHCHHHHKLIa MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHAH;uH   Ht	 ҐH8@SH0HD$ H 	 u
Hj	 HHHcHHLHHt+HHPL
 I;uH   Ht@	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtH8	 HCHH=   r=@t	 HGH;r	 H+Hs	 H'v	 HH HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALH	 HHt8Ht!LIH7	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1It7	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHH6	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ :0  H\$hH0A_A\^HKI;sH

 	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
[
 	 L+H|$XH;s;HCHrHHHrHHMtHMJ HH	 LCIH+HHu	H   HvH
 6	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HHR	 H{rHHHtJ LI4	 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH
 	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JLW	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH
 T	 HvH
 @	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L` H{H{rHH8 Ht$8HH\$0H _̀: uE3   IIB< u    H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH
	 	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLHI1	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
 	 I+H;HGH;u9I8H9AsH
 	 HAHyrH	 3He   HvH
K 	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6L'0	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH
x 	 H|$0I<H   HvH
R 	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
 m	 H|$0I<0H   HvH
 G	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLH-	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
7 A	 LAH+H;HGIHH;wH
  R	 H|$0I<0H   HvH
 ,	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.L,	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBIt	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpH
 H3HEHHyh   yq   du2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh>	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H2	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H
 	 H
 	 ̳IrNIAH=   r=Et	 HAH;r	 H+Hs	 H'v	 H HMH3\ L\$pI[(Is0IA^_]@SVWH AAq HHA|>	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXHBS HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHD	 HEHC| Cq j	 H
R HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   I	 HtyA   HHHT$(H	 HG  HH+	 t
HCh    H{hH	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t5	 HAH;r%	 H+Hs	 H'v	 H7 HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPHg
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r	 H+Hs	 H'   }	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(|   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t	 HAH;r	 H+Hs	 H'v	 H HHL$HH3< H\$pHP_@WH0HD$ H\$HH!	 H
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;wV	  HH'HHAHH(H HH(H(I   r<tp	 HBH;r`	 H+HsP	 H'vC	 HHH(k Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;vo	 KHH=   r<tS	 HBH;rC	 H+Hs3	 H'v&	 HHH(N H(H88L;v	 KHH=   r<tӿ	 HBH;rÿ	 H+Hs	 H'v	 HHH( H(Hu	3ɋH(H88H;v	 HHH   r,HA'H;wػ	 HW HH'HHAHH(> HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH9" HH988LKHML+IHHLI?IHt+I~u HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;v	 HHH   r&HA'H;w|	 H HX'HHC HHVLHHl$@Lt$Hd" HHgfffffffLNHML+ILIMI?MHt+Iu HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;v	 HRHH   r,HA'H;wh	 H HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH! HH*LKHML+IHHLI?IHt+I>p HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt莍/H;Ku
   HhHKHL$@HL$HHt	H]HCH\$PH0_H(Hu	3ɋH(H?H;vi	 H    H   r,HA'H;wH	 H HH'HHAHH( HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;vi	 H    H   r,HA'H;wH	 H HH'HHAHH( HH(H\$WH HHu3UHH;v	 H    H   r&HA'H;wĵ	 HC HX'HHC0 HH^B HL\B L+Ht$0^	 H?B H5@B H+HHtL5B L+IHHB HB HHt$0H\$8HA H _H\$Ht$WH HHHu3UHH;v	 H    H   r&HA'H;w̴	 HK HX'HHC8 HHHLGL+Hl$0m	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+	 HH{H+HHtLCL+IHHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;v}	 HRHH   r&HA'H;w\	 H HX'HHC HHVLHHl$@Lt$H HH*LNHML+ILIMI?MHt+In HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;vi	 HH   r)HJ'H;wL	  HH'HHAHH(H HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;v	 H    H=   r<t	 HAH;r۰	 H+Hs˰	 H'v	 H HoXHo`HohHO@Ht~HGPH?H+HH;v	 H    H=   r<td	 HAH;rT	 H+HsD	 H'v7	 Hf Ho@HoHHoPHO 聟HI HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;vW	 H    H=   r<t;	 HAH;r+	 H+Hs	 H'v	 H= HoXHo`HohHO@HttHGPH+HI;vګ	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H Ho@HoHHoPHO ۚH HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHH HHWHH+Hta HLGL+IuHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
 *	 THLHCHHHHKLId MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPL1
 I;uH   Ht	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;w	 H
 Hp'HHF HH\$`Lt$pH|$hHt$xMtH{rHHMtMHa	 HCHrOHHH=   r<tz	 HAH;rj	 H+HsZ	 H'vM	 H| HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH
b
 l	 IALd$XLd$pI;sH
A
 K	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH
 >	 Ll$`L+L,9M;sBIvH
 	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HH
	 H~rH6H{rHHH6  J&LJ0,	 !  H;suHCHrHHHrHHHtJ!LJ0	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0*	 HCHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   Ivn	 H|$0H   r#IH'H;wP	  Hx'HHGH HLHHO	 CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH
 T	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHHy HH*LKHML+IHHLI?IHt+IZ HKHH+HHLI?LHKHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H! 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   HH 3HC   H{HSrHH %  HxH\$0Hl$8Ht$@H _ŝ	 	 	 	 	 	 	 	 	 	 	 x	 q	 j	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   Hs 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH   HxH\$0Hl$8Ht$@H _	 	 	 	 y	 r	 k	 d	 ]	 V	 O	 H	 A	 :	 H(p   J HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL-֊
 Ht#HHPI;uH   Ht[	 ҐHHcH|1 uHL1PHtH;t3	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1H	 tVHڅuVHHcHMIHL1H	 I;u0D  H~/HHcHT1XHL1H	 u
Hջ   \$xHHcHHD1(    L-É
 Ht$p\$xLd$(HHcHHE3`	 ѕ	 u
I	 I$HcHJL!HHt#HHPI;uH   Ht	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%
 Ht#HHPI;uH   Htg	 ҐHHcH|1 uHL1PHtH;t?	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1HГ	 ADމ$   HHHcHAHL1H	 ADމ$   u(H~#HHcHT1XHL1Hy	 ADHL%ć
 Ht$p$   L|$(HHcHHD1(    HHcHHE3N	 	 u
I
	 IHcHJL9HHt#HHPI;uH   Ht	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-
 Ht#HHPI;uH   Ht@	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1Hđ	 u   \$x7Hυu.I~rM6HHcHMIHL1H	 I;t   +Ht*HHcHT1XHL1Ha	 uHՉ\$xHHcHHD1(    L-
 Ht$p\$xL|$(HHcHHE32	 	 u
I	 IHcHJL9HHt#HHPI;uH   HtΓ	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHH	 H	 Hx	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHH
 %H H;uIVHNH;HHQs	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HMڐ	 HH
 sHH[H;uIFHMH	 HH	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PH N
 H3HEpMMHHH   D$     Hσ
 HD$`HM	 D$    E3E3HT$hHL$`ِ	 HD$`HcHH~
 HD`HD$`HcHDxDD\   HL$hHHL$`YHH
 JHH?HHշ
 0HI%HA	 HHHUPHL$``HxrH H
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@3	 H
 HD$(H
 HL$(, @SUVWHh  HD$8HL
 H3H$P  IHHDD$0$  D;   HL$@aH}
 HL$@?HH4HHZ
 %Hȋ	 HH(
 H$0  HL$@YH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3q Hh  _^][H\$WH 	HHf/v\XH\$0H _\(~XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3܎	 Hj  HLsHsHuH{H|$hL?LHt3	 Hj  HHwHuH~H   H{(H|$hL?LHt3h	 Hj  HHwC< HHҙ  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H		 t
Hj  HH    Hk~LFHHIl H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3臾HC   HHC    H 艿HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHsH;uH   HtԌ	 Ґ3H	 D$0t/HHcHHLH	 u   |$`	H\$P|$`HHcHHE3	 HHcHHLHHt*HHPHH;uH   Ht9	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$h uB3HD$8HN
 HD$0Hr
 HD$(H
 HD$@H
 HD$HHL$([P HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHH$x  ? t
HHÀ< uLHHIE3HH2HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLH}  HC   HHC    H ۼHH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
w  IE3HHGA
   H
 HHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHI蕹HC   HHC    H HH0[@WH   HD$ H$  AHHH$   P  HX(H
D
 HH0x8HH$   
N HHL$(N H HL$(褼 @SH   HD$PHD
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$(Z ȋD$ -ut=   w2t=w2ɄuB3HD$8H
 HD$0H
 HD$(H
 HD$@Hʬ
 HD$HHL$(L HL$pH3Ũ HĀ   [@SH   HC
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`2P u-HT$PHL$X/ t9C,+<:wH     HrD$PH$   H3 HĐ   [荗  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(  HL$UVWAVAWH   HD$8H$   IcIcHL3l$0HBH+HDDHD$   HLHI/IoIoMtBHt4HHHL;t̅tHHHL;tIHt3
	 H*b  IMwIH\$PLt$`IHL$@Lt$HHD$@HD$hHD$PHD$pH$   HD$xL$   IHHH+HHH~%     )HH;}H\$PHL$@LHHL$h IH$   HĐ   A_A^_^]HT$HL$SH   HD$0I譖  DKH{uH f/% w'D HHL$89  HT$PH{|  HL$8ׄ	 $       $      HL$`H$   LT$XL$   H$   H$   I;HMHE3L\$PW3H~N   If/sQHIH;|II|LH"
 H
K
 j  H$   '	 HL$p	 HL$P	 2C HĠ   [@SVWH`  HD$8H?
 H3H$P  IHLD$0Hc$  L;   HL$@褃H
 HL$@HHwHH
 hHȋ́	 HHk
 NH$0  HL$@蜂H$0  H$H  HC$0  HD$ LD$0HȮ
 H舙  H$P  H3跣 H`  _^[HUWATAVAWHl$H  HD$8HXHpH>
 H3HEpML3ۉ\$0A   MPM;  EWD  HE~2MNfHcI;}$IIIHf.z uHI;|AIIcI;U  H
 HD$PHt
 HD$`HM^	 D$0   E3HT$hHL$P"	 HD$PHcHH~
 HDPHD$PHcHhTLHD$hHD$@HL$h~	 Hy
 HD$hH]Љ]H
 HL$`HH%
 HHN
 qHHC
 bHȍV	 HH
 GHAW	 HHT
 +HUPHL$P=~LMPH}hLCMPMMcMFHcLOH`
 HD$ H
 IN< HMpH3葡 L$  I[8Is@IA_A^A\_]@SUVWHh  HD$8H<
 H3H$P  IHHDD$0H$  D;   HL$@pH
 HL$@NHHCHHi
 4HHX}	 HH6
 H$0  HL$@gH$0  H$H  HC$0  HD$ L
 LD$0HHH$P  H3 Hh  _^][H\$WH HIHu	 HHHH+	 zH}	 HHH\$0H _H%}	 H\$WH HIH	 4HH)HH	 He}	 HHSH\$0H _H%j}	 @SH Hߜ	 IHH
 HH	 H"}	 HHH [H%}	 H\$WH HIH	 tHHiHH{	 ZH|	 HHH\$0H _H%|	 @SH Hw	 IHHQ
 HHn	 HH|	 HH6H [H%R|	 @SH H	 IHH
 HH	 H{	 HHH [H%{	 @SH H	 I[HH
 LHH	 =H{	 HHvH [H%{	 @SH H	 IHHi
 HH	 H({	 HHH [H%2{	 HHHD$0D$    L
l
 L
 36 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L]
 3v 2HHHHHD$0D$    L

 L
 36 2HHHHHD$0D$    L
|
 L
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L]
 3v 2HHHHHD$0D$    L
D
 L
 36 2HHHHHD$0D$    L
T
 L
 3 2HHHHHD$0D$    L
,
 L
 3 2HHHHHD$0D$    L
4
 L]
 3v 2HHHHHD$0D$    L
̐
 L
 36 2HH{^  \  H\$H|$L	LLAH*M+HIE3HHHH?HtfE3K3KDH+HHt%f     IHHKDK+HH;rHKHH+IHIHHH?HL;rH\$H|$@SVWATAUAVAWH  HǄ$   H4
 H3H$   IL$   L$   H$   HL$hL$p  E3Dt$DD$@   EHa	 H
r	 EE H"	 H
k	 zIcU H$  9cHcWD$pL$   LHL$p7H$  Ht(L$  L+I襘W$  L$  MHL$xLd$pI+I*IHHHHH?HH      tGIԐILHBI+HHt!ff     IHHBH+HH;rIHL;rMHtHIfILHBI+HHt!ff     IHHBH+HH;rIHL;rD$@   EE HV	 H
	 IcU HL$PaILD$XIHT$PH+HHt#LIHLD$XIHT$PH+HH;rIL+IMtHHHD$XH+D$PHH;rD$@	   Dt$HEM DHT$HH$  谖  HHHH+IHHHH?HHT$0L=.
 L|$(LL/
 H
8
 p  IH;sH[HHI迗  HH$  e  D$@
   Dt$HEE HT$HH$    HH@H+HLL$XL+L$PIHD$0L|$(L
 H
 ap  IHD$XHL$PH+HHt4LLffAn AHM@HD$XHL$PH+HH;rH$  HtL$  L+IHL$PA   EH*Lh	 I      ?H$   D;8  D$@   E;u ,  IcH$   L HxI+H  G;  IcH$   HHxH+H  G;|  3DfA/D  D$@   H|$XH+H|!G;}LLD$@   AHL$PHH)w
 H$   He
 H$   H$H  r	 D$D   E3H$   H$   r	 H$   HcHHp
 H   H$   HcHh   H$   HD$hH$   
p	 Hrk
 H$   3H$0  $8  H

 H$      Hgq	 H$  H$   pL$  H$  LC$  H	 HD$ DËqHv
 H$  Hd
 H$  H$H  q	 D$D   E3H$  H$  q	 H$  HcHH^o
 H  H$  HcHh  H$  HD$hH$  n	 HJj
 H$  3H$0  $8  H
 H$     H?p	 H$  H$  nL$  H$  LC$  H<	 HD$ DƋIHt
 H$  Hrc
 H$  H$H  p	 D$D   E3H$  H$  jp	 H$  HcHH6n
 H  H$  HcHh  H$  HD$hH$  m	 H"i
 H$  HǄ$0      Ǆ$8      H
 H$     Ho	 H$  H$  mL$  H$  LC$  Hb	 HD$ DËD$@   IcHL$xI+H*HHHLI?LLT$(D$    DH[HD$XH+D$PHMLM+LIHD$0H=0
 H|$(L4
 H
=
 j  3ITIDH+HHt&LD$P IHHIDI+DHH;rAHL$PD$@   HT$pH|$hH軒  HT$PHt#LD$`L+I?WD$PHD$`    H\$pHt4HT$xH) H$   H+HHHLI?LH|HH$   H3謏 H  A_A^A]A\_^[Hl$Ht$H|$ AVH0LHT$ LH  LGH*L+HI3HHH?HtLH\$@     IHHH  HOHH+HHHHHH?HH;rH\$@Hl$HHt$PH|$XH0A^HWATAUAVAWHPH@HXHhHpMLHIPI$ I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8w  Hl$@LH\$8LIT$Ie  HtZHHy$ HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HH: HII HFH+HH;s(:m	 m	 m	 m	 m	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@Hl(
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`Ht	 H  3H  H  HC	 HEpExH  HMpZk	 Hkh
 H  H] H  O Hj
 HE@Hi	 HEHHEPHEXHKi	 HE`HEhHi
 HEH   Y  H  Y  H  j
   ~y   A   ~x DEHVXHzrHH   ҡE3HH   HcHH   uHAPh	 H3h	 F|uH	 H   Hd	 auH	 H   Hk	 @uH	 H   Hz	 u2H	 H   H	 HqHHh	 H    H   H膨      H   HzrHA   H  趠E3HH  HcHH  uHAPf	 H3f	 F|uH	 H  H	 auH	 H  H	 @uH	 H  H	 u2H	 H  dH	 HUHHg	 H   H  HjHǅ     E3L  D   EFH	 H   gHa
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  GH  HrSHH   H=   r<tti	 HAH;rdi	 H+HsTi	 H'vGi	 Hv L   HNHYHyrH	HA   I;LBMtH	  u1Hu+Kl H   LF8HV(HCHH       HHc
 HH   WELuAEHUIZHf
 HEWELuAN   D.DvDu~HH
Z
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHI  DGHUHMHD$ IH  F  HOH*TH  Ht)L  L+I談W  Hǅ      HUHtLEL+I|He
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHIԐ  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHI  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHI{  DHUH   XHM1HQH}LL+c	 HH}H}8HO HUbMw8HUHtLEL+IH  HtL  L+IH}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMFHǅ     Hǅ      ƅ   A   H	 H  蒏LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   蟧 LH  SH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHI芶  D    PHMmEA
   H 	 LuI蔎IN A   H	 ~IN@A   H
	 hIN`A   H	 RI   A   H	 9Hǅ     Hǅ      ƅ   A   H	 H  LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H    LH  Q    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI%  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIy  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI蒺  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E?  Dq  d  PHM?A
   H	 LuIIN A
   H	 IN@A   H	 ͈Hǅ     Hǅ      ƅp   A   H	 Hp  藈LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H   褠 LHp  L          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIW  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ 1  D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ o  DLupEWA(WEHE    DEHUH+UHLEHM_B  HMH+M HLM L+MILɋ   ~gfn
 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@?  G HOpH/7  H   HM?HD$ IH  蚀  HOH~CH  Ht)L  L+IvW  Hǅ      H   HtL0  L+IvH  HU>  H   H  RHǅ     Hǅ      ƅ   A   E3H	 H   {HEHtTA   LH	 H   {LEI+LH  H   DHH  FH  wED   D   A   E3H}	 H   Y{H  HHEL@A   H^	 H   *{HLLEH  H   DHH  ]RH  DH   H  Q	 A   LH	 H   zHL@A   H	 H   zLLGH   H   CHH  FH   YDH   H  %Q	 Hx  (QHx  R	 H}8H  H  H;tIE3H  AIP  HW  Hǅ      MX  H  } HU H W   Hǅ0      LEH    LM LEH(  H   K  H  H  <  H  H   ,7HOXHUp7MtI   IH   Ht&H(  H	 L0  L+IHKqH  Ht=H  H H  H+H*HHLI?LH`H  BH   BHUHtLEL+IsH}Ht HU H8	 LE(L+IHpH} HtHUH	 LEL+IH|pH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H	 Hp  }H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H   輕 HHEpHp  )AH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    u   I  DW   E3L0  L   H   H    H(  H   H+I*IHHHH?HHH  ;EL  L  M+IMt ff     HHKIHM;rH}8H  H   8  H  HU3H  H  8HOpH0  HU HM'HD$ IHMy  HOHi<HUHtLEL+IoWELuHU HtLEL+IoHMpHtH   H  HtL  L+IoH   Ht:H(  H H0  H+IHHLI?LH\E3H}HtH   HHUHtLEL+I!oWELuH5NA
 HuH]HtHH& LEL+IHlHF
 H@  HP  8>H@  Hx  KHx  L	 H  .  H   -  AH  H3Kn L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHH+$3fD  H;_s^I4H
 HHH
 H;
 r
   HH$   Ht
(貴HHHD$8HHMLD$8H$   H  H$   pH      ?HHH=b
 H
{
 H9
l
 t	H>
 $HH+2
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HIf8HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;vL	 H    H=   r<tqL	 HAH;raL	 H+HsQL	 H'vDL	 Hss  (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH!3fD  H;_s^I4H{
 HHHm
 H;^
 r
   ʪHH$   Ht
(bHHHD$8HHMLD$8H$   H  H$   pH      ?HHH=
 H
+
 H9

 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI6HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v=J	 H    H=   r<t!J	 HAH;rJ	 H+HsJ	 H'vI	 H#q ͛ (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
~
 )F	 HL$8:  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   @HHL$@LD$8H$   Ht(H˯HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$89  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8-9  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
|
 =D	 H
|
 /D	 MLD$8H$   I  H p HL$8Ht{HD$HH+HH;vG	 H    H=   r<tF	 HAH;rF	 H+HsF	 H'vF	 Hm WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
{
 B	 HL$87  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   HHL$@LD$8H$   Ht(H蛬HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8{6  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$85  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
y
 
A	 H
y
 @	 MLD$8H$   I  H p HL$8Ht{HD$HH+HH;vC	 H    H=   r<tC	 HAH;rC	 H+HsC	 H'vC	 Hj WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH L@HPHHSVWATAUAVAWH  Hǀh)p)xD)@D)HMH3H$   Hf.IU IEH+HHuZHJ	 HD$`3HD$hHD$pH{
 HD$xƄ$   HT$hHL$x&A	 H7>
 HD$`H#{
 HL$`i DD$  IEH+HHwZH9J	 HD$`3HD$hHD$pH{
 HD$xƄ$   HT$hHL$x@	 H=
 HD$`Hz
 HL$` A   DJD$  W$   E3EL$   HFxHD$xLcL$   EL$   M_  IH$   @ IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   H$  H+HI;   IH+HH   H+HIH+H9  HL+IIHIH+IMI;LCL;ICH$   /L$   H$   IH$   L$   L$   H   HH   I;   IH+HHsxH+HIH+H   HL+IIHIH+IMI;LCL;ICH$   聈L$   H$   IL$   L$   Ht2HH$   IL$   M;s{-H
6u
 <	 H
(u
 <	 HG	 HD$`3HD$hHD$pHZx
 HD$xƄ$   HT$hHL$x=	 H;
 HD$`Hw
 HL$`8 IEI+E HL;rZHG	 HD$`3HD$hHD$pHw
 HD$xƄ$   HT$hHL$x=	 H:
 HD$`Hw
 HL$` IIIE  (WX$   $   L$   L$   LcF,L$  E3AH$   H$   Mj  IEI+E HL;  IIIE 4$  H$  H$   H;   H$  H;   L$  L+II;   IH+HH   H+HIIH+HO  HSL+IIHIH+IMI;LCL;ICH$   L$   L$   H$   H$   E3H$   L$  HtJHL$     I;   IH+HH   H+HIIH+H   HSL+IIHIH+IMI;LCL;ICH$   BL$   L$   H$   E3H$   L$  Ht3HH$   HH$   I;s{
H
q
 `9	 H
q
 R9	 HBD	 HD$`3HD$hHD$pHu
 HD$xƄ$   HT$hHL$x:	 H7
 HD$`Ht
 HL$` H$  H;G   LH$  L;   L$  M+IHGH9Gu{H+GHHsmHOI+HIIH+HsH
q
 |8	 HWI+HHLGM+IIHL+IIM;HCH;HCH轃HOHHt.JH%HGH9Gu
   HA]HGHtD HGH$  H;GsKHH$  H;w;L$  L+IHGH9Gu
   H\HOHHt.JH%HGH9Gu
   H\HGHtDHGE3ED9nx~7H$   Ld$xfIcHHA%AE;<$|H$  L$   H$   H;GsKHH$   H;w;L$   L+IHGH9Gu
   H$\HOHHt-JH$HGH9Gu
   H[HGHt8HGED9n,L$   ~$D  IcH    IHz$AD;~,|W$  HǄ$       G
 |   DF(Hx\
 H
m
 HcV(HL$`#E3ALL$hIHT$`H+HI      Ht0L@ f     M<HLL$hIHT$`H+HH;rIL+IMtL<HHD$hH+D$`HH;r
 }   DF(H[
 H
[
 5HcV(H$   "E3AL$   IH$   H+HHt4Lfff     M<HL$   IH$   H+HH;rIL+IMt+fff     L<HH$   H+$   HH;rά
 ~   DF,Hj
 H
hl
 oHcV,H$   ."3ɋL$   IL$   I+HHt0M    M<HL$   IL$   I+HH;rM+IMt.@ ff     M<HH$   H+$   HH;r
    DF,Hi
 H
k
 诶HcV,HL$xq!3DL$   IHT$xH+HHt N<IL$   IH+D$xHL;rHT$xL+IMt+@ ff     L<HH$   H+D$xHH;r㋆   uvW
    H   H   HV0LN(LL$@LNxLL$8HD$0HL$(HT$ L$   L$  H$  H$(    HHL$`W        ت
    H   H   HVHLF0LN(LL$HLNxLL$@HD$8HL$0HT$(LD$ L$   L$  H$  H$(    HHL$`aW  H$(  HtL$8  L+IUL$      H
{h
 $  ;F,q  
    LcHI+HH$  HL$(D$    EDĳL   L+   IH
h
 HL$(D$    E薳H   BtCYtL$   L+$   IH
:i
 HL$(D$    EQH$   Bt`
    Hg
 HD$(D$    ED$  L   L+   IH
[g
 HL$(D$    EH   BtCYtL$   L+D$xIH
h
 HL$(D$    E褲HD$xBt$  xA   =
 D;~(  
    IcLD$hL+D$`IH
h
 HL$(D$    D;HD$`H$  H   L\f
 H  HH$  H$   H+$   HLIL+	IHD$0HU
 HD$(LU
 H
U
 Z-  H$  LAL+IH$   H	(Le
 HH     HH$  H$   H+D$xHLIL+	IHD$0H[U
 HD$(LSU
 H
PU
 ,  H$  LAL+IHT$xH	cXH$  YtXL$   L+$   IH
ZU
 HL$(D$    DݰH$   tAK
    E3D8$     A;^(}HcHD$`HHA;^(}HcH$   HHAfD  ;^,}HcH$   HHtA;^,}HcHD$xHHTHT$x$   P  Ht%L$   L+ITQWD$xL$   H$   Ht(L$   L+I"QW$   L$   H$   Ht(L$   L+IPW$   L$   HT$`HtLD$pL+IPWD$`L|$pH$  Ht#ML+IPW$  L$   Mt&M+IMIiPW$   L$   H$   Ht&L+IMH6PW$   L$     Ht%L$   L+IPWD$xL$   H$   Ht(L$   L+IOW$   L$   H$   Ht(L$   L+IOW$   L$   HT$`HtLD$pL+InOH$  HtL+IMQOMtM+IMI9OH$   HtL+IMHOL$  A(sA({E(CE(KIA_A^A]A\_^[LWH`ICI[IsH H3HD$XHIK3t$ H1HqHqD$    HHD$P   Ht$H@t$8DFH7	 HL$8YHD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHNHH;HKHthHA   HqHyrHHH@HCH9Cu
   HlNHKHt(HA   HqHyrHHHT$8  _HC HD$PHrQHHL$8H=   r<t-	 HAH;r-	 H+Hsx-	 H'vk-	 HT HHL$XH3M H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUH:L?LLE   HuHI?LuI;   HHM>HHMRn HHFHMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHS HI;{=,	 6,	 /,	 (,	 !,	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   H8HOHMPH[HHHMXHt2HGH9Gu
   H8HOHMPHMXHt
HUHGHMHtiHEH+HI;vE+	 H    H=   r<t)+	 HAH;r+	 H+Hs	+	 H'v*	 H+R H   IHF  HMH+IHHHH?HH
H;v*	 HRHH=   r=@t*	 HFH;r*	 H+Hsq*	 H'vd*	 HHQ HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHHo  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   H9HSHt(H
H;Cu
   Hy9HCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H8HSHt(H
H;Cu
   H8HCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_H\$Ht$WH IHHH;t HHHHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HHTH H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`#	 H5B
 Ht$hH
6$	 $	 HHEH;xsHHHH   3ۀx$ t#	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8HdF
 HD$0H(
 HD$(H< HL$(xY H\$hH
 HHRHE HL$` #	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$P"	 H'
 HD$XH
+#	 #	 HHFH;xsHHHH   3ۀx$ t"	 H;xs
H@HHumH\$XHucHHL$X4"	 Hu13HD$8HPE
 HD$0H
 HD$(H( HL$(dX H\$XHy
 HHPHD HL$P"	 HH\$`Ht$hH@_H\$WHPH H3HD$@HHD$8   HL$ HD$0    ID$  E3QHLD$ HWH( HHD$8H+HHrQHL$ HH=   r<t%	 HAH;r %	 H+Hs$	 H'v$	 HL HHL$@H3D H\$`HP_H(Hu3H(HH;w*H\$ H    H#	 HuHuH\$ H(@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0证 t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHRu  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHRe  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H	  H
 HCPH [HL$SH0HD$ HD$P    EtH
 HA@H
 HAPD$P   J   H
 HH@
 HCHC@HcHH 
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHHN)	 HHQ3HHBHK	 H
 HH{3HHDH^H\$HH]"
 HHOHKHtHPHGHCHGHCG C H
 HHX#
 HHH\$PHt$XH0_Hq
 HH@SH HHI0	 HK 	 HH [H%	 Hq
 H@SH HH   H`HcPH
 HHHHHcPDHDDHh	 HH [H%K	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3LHo(Hs(H;t<HHRH]HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3KGxCxGyCyG|C|H   H   H;tIE3K                                                  HH\$HHl$PHt$XH0_H\$WH H  H
 HGPt
X   HgE HH\$0H _@WH0HD$ H\$@HH
 HH
 HAHI HtHP tHC     H%	 HHK	 @t
@   HD HH\$@H0_H	HtH   H k  HUHl$H  HD$8HXHxHP H3HEpIID$0    3A fAn	 f/rHHr   H]
 HD$PH
 HD$`HM:	 D$0   E3HT$hHL$P	 HD$PHcHH
 HDPHD$PHcHhTLHD$hHD$@HL$h`	 H
 HD$hHE    E    HS
 HL$`cHL$`	 HUPHL$PhHEPH}hHCEPHD$ L
S
 LHN
 H
LN
   HMpH3; L$  I[I{I]HUHl$H  HD$8HXHxH H3HEpIID$0    3A	A;|HHr   H
 HD$PH
 HD$`HM	 D$0   E3HT$hHL$P	 HD$PHcHHZ
 HDPHD$PHcHhTLHD$hHD$@HL$h	 HU
 HD$hHE    E    HR
 HL$`HL$`S	 HUPHL$PHEPH}hHCEPHD$ L
rR
 LH\M
 H
L
   HMpH3W: L$  I[I{I]H8MPE3MPMtYMH\$@HH|$0H      ff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8  @SH0HD$ HHW
 HH
 HAHI HtHP tHC     H!	 HHKH0[H%	 LH   ICAC    HQH
 ICH
 ICAC   IKH
 HD$(H@8
 HD$@HD$hHcHH
 HDhHD$hHcHDd    H6 HL$(K @SH0HD$ HٹX   ; HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHW
 HH7
 HAHA@HcPH*
 HD
@HA@HcPDBDD
<H
 HHk
 HAHI HtHP tHC     H	 HHKH0[H%	 @SH0HD$ HH
 HH
 HAHI HtHP tHC     H	 HHKH0[H%	 HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIv  HWH*  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHhq pMt/HWI  HOH+IHHLI?LH"HNH+IHHHH?HH#tLHVHp HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+HV7HH+HH4H+H;7HOHHLH+HH+O  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   7 HH$   LCMu	H4
 
IP(HuIP0HL$(k	 HǄ$      3H	 H*	 HHH  H>HL$(5	    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
dI
 	 H;s/LHjHtH{HsrH3 H\$0Ht$8H _HsH;LƲLBZ8HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    H
 HH	 HAH   w	 D$H   H_E3HH;	 HHcHHD
 H9HHcHHT9H\$PH	 H!
 HC| Cq H	 Hǃ       H
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH	 HH~
 HAHI HtHP tHC     H	 HHK	 @t
@   HX9 HH\$@H0_H\$WH HHHUt
  H9 HH\$0H _@SH HH		 HKH [H%	 LHXICLI@I+ HHQH;rQH;	 IC3ICICHJ
 ICD$0ISIK	 H
 HD$8HI
 HL$8  HBHAI HX@SH HH	H   HS  HH*HSH+HHHH?HH
H;v	 HRHH=   r<t	 HAH;r	 H+Hst	 H'vg	 H7 3HHCHCH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH	 HA@H
 HAPD$P   OH
 HHOH.
 HHG@HcPH
 HD:@HG@HcPDBDD:<HSHHDaYHH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H	q	 HtHHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
*D
 	 L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HHaTHSLHH HH{H+HHtLCL+I.HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
B
 :
	 H|$@K<H   HvH
B
 
	 H9{s#HHcH   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0>	 H{rHHHtLHsj H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%	 HWAVAWH   HD$(HXHp HA H3H$   LLHL$ H		 HT$0I		 3IFIF IF(HT$`I	 H
W+
 $  IFI	 HHHHǀ<8 uHǺ   H
	 HHu5	 HHtHRHvHuIN I	 HHÀ< uHú   H
	 HHu	 HHtff     HIHHuIV(fAF.,H$   H3* L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
O@
 Y	 LAI+H|$8H|$PH;HGIHH;wH
@
 `	 Ht$0I48H  HvH
?
 :	 H9qs H`H   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8a	 I;u>HKI?MIDHrHHHrHHHt8HL 	 *I~rM6H{rHHHtK>LHg H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HH HH0[@SH HHHSH
	 H3H
HJHHc	 3HC HC(HC0Hv	 C8HH
 HCHH [@SH0HD$     5 HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH
=
 	 I4L+IIHH+I3I;HCH;HCHt$@HRLHD$8HD$0LHT$xHm HD$0LH$   H$   i HD$0LHWHL$xvm HWHHH+HHHt藽  HLGL+I%HIHwHIH_L7%IH>i HHWLHL$x H_H\$pHPA^_^@SUVWHx  HD$8H H3H$`  IIHHI@I+ HL;   HL$@oHg@
 HL$PkHH	 HH@
 kHH?
 kHHy?
 tkHH:?
 ekH$@  HL$@sHCH+HHD$0H$@  H$X  HC$@  HD$ L
?
 LD$0HH< H$`  H3% Hx  _^][@UVWHp  HD$8H$  H H3H$`  IHLL$0H$  H$  L;  HL$@Hd;
 HL$@rjHHgjH$@  HL$@H$0  WHs;
 H$0  2jHH;
 #jHHjHH>;
 	jHH]	 HH;
 iH$   H$0  9H$   H$8  HC$   H$@  H$X  HC$@  HD$ L
l5
 LD$0H軮 H$`  H3:$ H$  Hp  _^]Hx)t$`()|$PD)D$@D
 D)L$0D
i
 fD/D)T$ EWA(r`A(\(a (\f/
%
 vAXfA.zu	 
  !      =
 Y(a ^fA.ztf/5
 r
(q O
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(萻 X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PH  H3HEpMMHHH   D$     H	 HD$`HM	 D$    E3E3HT$hHL$` 	 HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h;HHL$`YgHH!
 JgHH?gHH'
 0gHI%gHA HHgHUPHL$`` HxrH H
		 HL$(3HL$0HL$8HD$@D$HHT$0HL$@3 	 H
 HD$(H HL$(,4 @SH`W)t$Pf/D)D$0D(   u+DW
 3A(W
 (t$PD(D$0H`[t
 fA/DWǭ
 A(v(
)
 \((t$PD(D$0H`[3bX
 (t$PD(D$0H`[5	
 fA/)|$@D)L$ D
 !  
 fA/vTfD.z  Dk
 eH%X      HЋ9
   %O
 AYDYA
 AX  j
 eH%X      HЋ9>
 
  A(AY(Y((Y%*
 (Y
_}
 Y
 X%
 X
7}
 X
 YYY'}
 X%ǂ
 X
|
 YX|
 XYX^X%{
 AY  3t

 1
 fA/  j
 eH%X   =P
 fA/   HЋ   9
   A(A(\AYW
 (Y\ ((Yz
 (Yz
 (Y
w
 Xz
 Xz
 A^X
v
 YYYXqz
 X
v
 YYX(Yv
 X
v
 X:z
 Xv
 YXvv
 YX^Xz
 Y  
 fA/   9h
 '  A(A(\AYW
 (Y[ ((Yv
 (Yv
 (Y

 Xv
 Xv
 A^X
]
 YYYXv
 X
1
 YYX(Y2
 XZv
 X
 YXX

 ^X
 Y  ݟ
 fA/   9
   A(A(\5
 AY(Wǩ
 Y[ ((Yx
 (Yx
 (Y
|
 Xx
 Xx
 A^X
{
 YYYXYx
 X
{
 YYX(Y{
 X*x
 X{
 YXX
z{
 ^X֝
 Y   9
 Z  A(A(A^AY(YW
 .Z ((Yf|
 (YS|
 (Y
|
 X8|
 X(|
 A^X
|
 YYYX{
 X{
 X
_|
 YYYX{
 X
3|
 X(YL|
 X4|
 YX|
 YX^X
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
v
  =j
 ̛
 H
U
 

  H
$
  =
 (
 H

 (
 }
 
 }
 (
 x
 
 
}
 (
¡
 
x
 
w
 
 qH

 Y =
 V(I
 H
ڀ
 (
۠
 v
 (
 .v
 (
 
v
 (
 Jr
 Z
 
+r
 (
 Lr
 
5r
 | H
4
  =(
 (
 H

 (
ݟ
 r
 (
 
r
 (
 r
 (
 
$
 (
5
 &
 
/
  [H

 M =
 .(=
 H

 (
 t
 (Q
 
t
 (
S
 t
 (
 
x
 (
g
  x
 
)x
  H

  =
 (ߞ
 H

 (
 x
 (
 x
 
 x
 (
 
x
 (
7
  y
 8
 
y
 (
z
 "y
 
y
  @UVWHp  HD$8H$  He H3H$`  IHLL$0H$  H$  L;   HL$@4H.
 HL$@]HH]H$@  HL$@UH$0  H.
 H$0  \HHp.
 \HH\HH-
 \HH HH-
 \H$   H$0  H$   H$8  HC$   H$@  H$X  HC$@  HD$ LD$0H  H$`  H3 H$  Hp  _^]@USVWAVHl$H  HD$PH H3HEpIHHL   D$     H	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h/HHL$`A[HH
 2[HH'[HH
 [HH-
 	[HHuH
 HZIH: IHZHUPHL$`)HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H	 HD$(Hyw HL$(' DD$USVWAUAWHl$H   LjLy3HHM;otI@ Mt
I[II7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH Mt
IHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMxq HIH HHGHGHtH    
Hw
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM' w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH Mt
IHH7LEwH_HUoLwH* H}HEHHMLwH]LuHEw W(f.z
u5
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]LuN IUHO(QLG(IHr HW(H|$ I葱 G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM ($   L$   HL$   fG<Hĸ   A_A]_^[]YYY@SH HHHSH
 H3H
HJHHS 3HC HC(HC0H>	 C8HH HCHH [LHXIC3ICH
 ICH		 ICHNA
 ICH
 ICIK @SH`  HD$8HO H3H$P  DD$0H$  D;   HL$@,HH&
 HL$@
UHH
 THH!&
 THH@ HH%
 TH$0  HL$@H$0  H$H  HC$0  HD$ L
l 
 LD$0H\
 H
-
 `\H$P  H3/ H`  [HUATAUAVAWHHH  HD$PHXHpHx H2 H3H  M3t$@I@HD$0H
 HD$(MHLH

 oML$I  DM  
L
 Ď
 @ M]MM;}UI$N    IIIHIIIL@      A \Tf/rIHMM;|MM;x  H=J	 H|$`HM D$@   E3E3HT$hHL$`T HD$`HcHH	 HD`HD$`HcHxT\HD$hHD$HHL$h H	 H\$hHuE   H$
 HL$`RHH
 RHHx$
 RHIU HH #
 {RHIW HH
 _RH`  HL$`H}PH    D$@   E3E3HUXHMPW HEPHcHH	 HD
PHEPHcHxT
LHEXHD$HHMX H]XHǅ       ǅ      I<$I\$IIH#
 HMPQHH
 QHHn#
 QHIW HH"
 qQHIU HH
 UQH H@  HMPL@  HX  LC@  L`  Hx  LC`  M$ID$IIMLT$ H
 H
	
 L  H  H3 L$  I[0Is8I{HIA_A^A]A\]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;tSIHHt34 HTHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVHl$H  HD$PHe H3HEpMHHH   D$     H7	 HD$`HMx D$    E3E3HT$hHL$`A HD$`HcHHp	 HD`HD$`HcHDxDD\   HL$h_#HHL$`NHH'	
 NHHNHH=
 NHHb
 NHI HHrNHUPHL$`HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@ Hp	 HD$(HTd HL$( HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH
 HEL%	 LeHM	 HEH	 HEL5	 LuD$    L-	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH HE3HEHEHUHM H	 HD$0H
	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP H.p	 HD$@Ho	 HD$HE   
Q
 eH%X   A   HȾ   A9&m
 Z  H
m
  =
m
 A  NW	 LHEwHA	 IF@HF	 IFPD$    HT$0I  H	 IH	 IF(IF@HcHHQ	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw HUHHMHH]wHt=C;u2HHP{;u LI@H
0H;HuAАMIHM)1Em
 fsfH~HtBHM0H
  H
k
  L5&	 m
 m
 fsfH~HtpH	 HD$0Hq	 HEHEHcHH&	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR Hm
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH
 HEL%	 LeH	 HEH	 HEL5	 LuD$    L-4	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH HE3HEHEHUHM9 HY
 HD$0H	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP Hl	 HD$@Hbl	 HD$HE   
tM
 eH%X   A   HȾ   A9"j
 Z  H
j
 X =	j
 A  NW LHEwH	 IF@H	 IFPD$    HT$0I%  H 
 IH	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw HUHHMHH]wHt=C;u2HHP{;u LI@H
:,H;HuAАMIHM,Ej
 fsfH~HtBHM>,H
w z H
h
  L5	 j
 j
 fsfH~HtpH	 HD$0H	 HEHEHcHH^	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM} LmHMHtHR HZi
 H$H  H   A_A^A]A\_^]LEK ECWH`ICI[IsIcLH3t$0y*H.
 ICL

 MCH
 H
i
 Ey/H
 HD$ L

 L$   HH
 H
5
 IcWD$@Ht$PHL$@5HH3HsHsLD$@Hi HT$@HtLD$PL+IHH\$pHt$xH`_DD$SH@HH3ɉL$0Ex"HHKHKHIcL4HH@[H$
 L

 HD$ LD$`H
 H
]
 H\$WH@LIL3
 L+	HHBH
2
 H+HHHD$0H
 IHD$(L3HCI+HHt(HfnHRAHHCH+HH;rH\$PH@_H\$WH@LIL
 L+	HHBH

 H+HHHD$0H\
 IHD$(&L3HCI+HHt,H@ ff     HIHHCH+HH;rH\$PH@_@SH0HD$     * HH0[HHHD$pI*HHH+IHILIIH?LIHI+L
 HLL$0H

 HHH?HHr
 LHD$(=HH@UVWATAUAVAWH$pH  HD$HH$  H H3H   MHHHL$(3Dt$ IPIВ  IIFHCH+HsHI[  WD$0Ht$@HHM`貮HT$0Hu L|$0ILd$8M;  HH	 H
	 HL$`HT$pHM} ADl$ E3HT$xHL$`@ HD$`HcHH	 HD`HD$`HcHhT\HD$xHD$PHL$x H
	 HD$xHuuHHL$pDHH#8	 @HsH+3H3Ht(HHL$p HH 8	 o@HH;rHHL$p HH7	 G@HU`HL$`YHIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICI/HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICI
/IvHtrHF   3HNH~rHHƈHsLGItHH] 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM HI;t(H|$(39H

 K H

 = Mt6IIl  HL$@I+H*HHLI?LIH   H3 H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   Hٓ H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHMHHMWE3H]Ll$8H|$0\$(L$ LMMHHM7 HE   H]]DCH\b	 HM#HHUHP HEHrPHHMH=   r<tx HAH;rh H+HsX H'vK Hz L|$8H|$0Lt$(EwD$ ]oLEHUH軱 HUHt LEL+IWEHE    HUHtLEL+IHMH3 H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   HHT$PHtLD$`L+IhHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xHא H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`HHL$dW$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$x& H$  hL$   HT$xI (D$@IH$  IPH$x  H$x  | E3|$@L$   L$   Ld$pH|$hH$  H^	 H$  $9H(p IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   H_	 H$  3H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH

  HQM+IIHL+IIM;HCH;HCHL$H'HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH

 c HQM+IIHL+IIM;HCH;HCHL$H0'HL$PHt0HA   LqHyrHHH$    kHL$PH HL$PH$  pAEHT$HItI$H
)	 H;tHT$HIP A$     D
G~
 Dq
 $     W$  L$  H$  ?D$0D$(H$  HD$ LD$xI
H$   H$  uHXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  \ I$L@H
-	 H$  H;uIL$IAАH$x  H$x   H$  HtL$  L+I|$@HHHH;tHD(L$   HT$xI (D$@H$      H$     HH\	 H$   !5HHuI
H HcHHHW
   H$    HƋHQ HHk-	 4HH(\	 4HHuI
H HcHHHW(A\(H HH[	 4H( HH,	 h4IH$   IPATH$x  H$x  H fD/s;$  H|$haW$  L$  H$  D$0D$(H$  HD$ LD$xIyH$   H$  HXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  3Z I$L@H
	 H$  H;uIL$}IAАH$x  H$x  9 H$  HtL$  L+IHL$HHt.HT$P  LD$XHT$HL+I|WD$HLt$XH$x  H$x   HT$xHt%L$   L+IWD$xL$   H$   HtL$   L+I3H$   H3 L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xH H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$x	HHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`_ H  H  H  ~L H  HUH   H  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#3 H襦HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  rk H      	    	    	    	     	    Hc(	  H  8  =	w
 Wt$XH  HV	 H  P/H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   HV	 H  dH  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	 K HQM+IIHL+IIM;HCH;HCHL$@HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
-	  HQM+IIHL+IIM;HCH;HCHL$@dHL$HHt/HA   LiHyrHHH    HL$HH HL$HH  覷AEHT$@HjIH
`	 H;tHT$@IP 0	  @   WELmH  D$0D$(HEHD$ LD$`HoH  H  HXH  HtIH  IPHD$XHD$ A   LEHUHM6S IL@H
	 HUH;uIO膯IAАH(  H(  D HUHtLEL+I
H
cLc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HcS	 H  IH  IP H  ٵH  }  D8  Wt$XH  HL$`許3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HM HHw#	 H   *HHu3
H HcHHHWHH HH)#	 p*   HM) HH;#	 H   K*HHu3
H HcHHHW   HM LHu3
HHcHHIPA(HO HH"	 )H(  Ll (YH     HM HH"	 H   )HHu3
H HcHHHW   HMY LHu3
HHcHHIPA(H HHB"	 I)   HM( HH'	 H   $)HHu3
H HcHHHW   HM8 LHu3
HHcHHIPAH  @k (H HHN'	 (
   HMHn HH`'	 H   (HHu3
H HcHHHW   HMX= LHu3
HHcHHIPAP  H HH&	 ((
   HMh HH#)	 H   (HHu3
H HcHHHW   HMx LHu3
HHcHHIPAX  H HH(	 'HP     HMM HH)	 H   o'HHu3
H HcHHHWHH HH(	 8'H)	 H   %'HHh  F+HH(	 'IH   IPH(  :H(   0	  HuH  H  ߽HXH  H   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  H  v@  W  H  H  蟾D$0D$(H  HD$ LD$`Hk}H  H  ؼHXH  HtIH  IPHD$XHD$ A   L  HUH  ,L IL@H
	 H  H;uIOyIAАH(  脼H(  7 H  HtL  L+IEH
M@
  W  3H  H  ~D$0D$(H  HD$ LD$`HJ|H  H  跻HXH  HtIH  IPHD$XHD$ A   L  HUH  K IL@H
u	 H  H;uIOXIAАH(  cH(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   HK	 IH  IP H  5A$   HK	 IH  IP H  蹭F   EH    LHF%	 H  >2MHIAP H  sH  fHL$@Ht.HT$Ht  LD$PHT$@L+I{WD$@H|$PH(  H(  Ļ H  w  H    H(  ޹H(   HT$`HtLD$pL+IUWD$`H|$pHUHtLEL+I~H`  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xHw H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`? H  肹H  H  4 H  HUH   H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3e H腖HHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  R[ H Hc	  H  2  	    (	    0	    8	    @	    H	    HcP	  H  8  =f
 Wt$XH  HG	 H  H(i IH  IPWD$@Ll$PHǅ     L  ƅ   A   HaG	 H  1H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@
HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
	 d HQM+IIHL+IIM;HCH;HCHL$@1
HL$HHt/HA   LiHyrHHH    mHL$HH HL$HH  sAEHT$@HZIH
-	 H;tHT$@IP X	  @   WELmH  mD$0D$(HEHD$ LD$`H<tH  H  詳HXH  ٦HtIH  IPHD$XHD$ A   LEHUHMC IL@H
m	 HUH;uIOSIAАH(  ^H(   HUHtLEL+IH
0Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HD	 H  IH  IP H  詥H    D8  Wt$XH  HL$`x3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   TH`     HMU HH	 H   wHHu3
H HcHHHWHH HH	 @   HM HH	 H   HHu3
H HcHHHW   HMȱ LHu3
HHcHHIPA(H HH	 H(  \ (YH     HMZ HH	 H   |HHu3
H HcHHHW   HM) LHu3
HHcHHIPA(H HHB	    HM(Ұ HH	 H   HHu3
H HcHHHW   HM8 LHu3
HHcHHIPAH  [ (H HH	 
   HMH> HHP	 H   `HHu3
H HcHHHW   HMX
 LHu3
HHcHHIPAP  H_ HH	 
   HMh HH	 H   HHu3
H HcHHHW   HMx LHu3
HHcHHIPAX  Hү HH<	 kHp     HM HH	 H   ?HHu3
H HcHHHWHHw HHq	 H	 H   HHh  HH	 IH   IPH(  
H(   X	  HuH  H  语HXH  ߠH   IH  IPHǅ     3H    E3Hp H  H  H  H  HC  H  L  Mt
H  H  F@  W  H  H  oD$0D$(H  HD$ LD$`H;mH  H  訬HXH  ؟HtIH  IPHD$XHD$ A   L  HUH  ; IL@H
f	 H  H;uIOIIAАH(  TH(   H  HtL  L+IEH
@
  W  3H  H  ND$0D$(H  HD$ LD$`HlH  H  臫HXH  跞HtIH  IPHD$XHD$ A   L  HUH  : IL@H
E	 H  H;uIO(IAАH(  3H(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H<	 IH  IP H  轝5A$   Ht<	 IH  IP H  艝F   EH    LH	 H  "MHIAP H  CH  6HL$@Ht.HT$Hc  LD$PHT$@L+IKWD$@H|$PH(  H(   H  G  H  ˍ  H(  让H(  a HT$`HtLD$pL+I%WD$`H|$pHUHtLEL+INH  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pHHL$tWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHM8v Hx	 H   H   HuH   HEL}HEHHUH+HWEHt!3 HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%	 LeHaHEH]LL+tHH WED$xHE    HL$xDHT$xH   H   PAEHT$xI|MHHT$xHP HL$xHt|HU`  HEHL$xH+HHH;vm HH=   r<tU HAH;rE H+Hs5 H'v( HW Ld$xHMYHEHMHMHULL+tH EEfEML   HT$xHM ` L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H   踦  +fn^5L
 LM(WJLM(WJ(WHMNLeHM, H" H:	 H   HMHtsHEH+HHH;vʨ H    H=   r<t HAH;r H+Hs H'v H 3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHH5H$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHP H$   aL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHp H$   qL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH}H$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   dHH   uWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$pk HC	 HEWHMKKH	 HEHY	 HEH}H	 HEH   HEH   HE(iG
 )E (
E
 )ME        D
 E(E0    E4 WE8H	 HE   f/vM   f/v2B
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM H?	 HEH	 HEHM HM HMڞ H	 HEHT$pHtLEL+I荿3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   fHH  wW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$ph H?	 HEWHMGHH	 HEHU	 HEH}H	 HEH   HEH   HE(eD
 )E (
B
 )ME        A
 E(E0    E4 Wu8EH H'	 HEP>
 Ex(
D
 )   h@
    uXW)E`HU	 HEH5J	 Hu@P  f/vE=>
 X  f/vf/vM`  OȉM$Y Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM Hu@H}	 HEH	 HEHM, HM" HM H1	 HEHT$pHtLEL+I˻3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHvH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHl H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHUuH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH* H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHerH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH蜿 H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH%qH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH: H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   ĮHH   ժWEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$p_ H	 HEWHM>H\	 HEH	 HEH}HZ	 HEH   HEH   HE(:
 )E (
8
 )M5
 ] WM0E(
   H	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHMH H	 HEH	 HEHMO HME HM; HT	 HEHT$pHtLEL+I3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   ǫHH  اW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$p \ H	 HEWHM;HY	 HEH	 HEH}HW	 HEH   HEH   HE(7
 )E (
5
 )M=2
 } Wu0E(
   E@ H{	 HEH(57
 )Ep(
9
 )   W)EPu`H	 HEH5	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
h3
 (V Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMy Hu8HE	 HEH2|	 HEHM HM HM H	 HEHT$pHtLEL+I;3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pHI H3HE AALL   L   H   L  H  HEI荈   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pHHL$t!WE3H}Ht$8Ll$0D$(t$ LL$pMIHMjX WD$XH|$hHE   H}@} DGH0	 HM GHE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	 7 HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XPHL$`Ht,HA   HyHyrHHHU   菽HL$`H HL$`HEHrPHHM H=   r<t HAH;r H+Hs H'v H AEHT$XI.IHT$XIP H}H]H+HWD$xHt3 HfHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMv  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMNw  HL$x HL$XHt2HT$`@  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I3HM H3ݩ H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHD H3HE AALL   L   H   L  H  HEI]   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pޢHHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHM:S WD$XH|$hHE   H}@} DGH	 HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
	 S HQM+IIHL+IHM;HCH;HCHL$X HL$`Ht,HA   HyHyrHHHU   _HL$`H HL$`HEHrPHHM H=   r<t HAH;rՆ H+Hsņ H'v H AEHT$XIc)IHT$XIP H}H]H+HWD$xHt3 HaHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHMh    D$8   D$0   D$(   D$ LL$pLD$xIHMiq  HEHD$@L|$8Ll$0   D$(   D$ D   D      HMg  HL$xj HL$XHt2HT$`];  LD$hHT$XL+IǢWD$XHD$h    HUHtLEL+I3HM H3譤 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH@  Hǀ`HXHp )pH? H3H$   MMH$`  HH<
 HHH.
 H;
 r   HH
 H$8  Ht
'
 HE3H
 E3AHHH
 H;
 r
   1HH$8  WHt
(HIW$H  L$X  L$   L$   L$   L$   L$(  HT$`H$   蠳  HD$`H$(  L$0  HT$`H$   y  HD$`H$0  W$   L$   HcFxHD$pIHt'I;v
H
t	  HH$   ~tHD$pMfD  H$   L;  HT$`  HD$`H$   L$   H;   HD$`L;   L|$`M+IL$   I;uxIH+HHshI+HIH+Hs
H
Ʒ	 0 HQM+IIHIH+IMI;LCL;ICH$   sH$   L$   H   K   L$   I;upIH+HHs`I+HIH+Hs
H
/	 ~ HQM+IIHIH+IMI;LCL;ICH$   sH$   HtHD$`HH$   HH$   IHD$pkL$@  HT$hi  HHD$`H
	
 LH(H
 H;
 r(   YLHL$`L$8  Mt*L)AMXOIIMo H	 IML$8  HT$`HL$p(HHL$`HD$`H$@  WD$xL$   Lcn,MtM;v
H
ݵ	 G} IHL$xqM    M;  HT$`H$   e  HD$`H$   H;   HD$`LD$xL;   H|$`I+HL$   I;urIH+HHsbI+HIH+Hs
H
9	 | HQM+IIHIH+IMI;LCL;ICHL$xqH$   LD$xHt7I&H;$   uHL$xbpH$   HtHD$`HH$   HH$   I |   H~(DH	 H
~	 HcH$   UIL$   IH$   H+HHt0ff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r+ }   DH]	 H
Z	 HcH$  ]TIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;rk ~   DF,HT	 L%	 I	HcV,H$   SIL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r    DF,H	 H
M	 LHcV,H$   RIL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$   赲 HH$          c    HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$   . HH$   荼 H$   HtL$   L+IH$      L=	 H	 ;~,      HcL   L+   IHT$(D$    DSL   L$   L+D$xIL|$(D$    D&HD$xL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID    L   L+   IH
	 HL$(D$    DL   L$   L+D$xIH
	 HL$(D$    DcHD$xL$L$   L+$   IH
	 HL$(D$    D*L$   ATIT$HL$`H IDH$   L%ǭ	 P       5
 L-	 I*;~(      HcH   H+   IHHLI?LLl$(D$    DyH[H   L$H   H+IHHLI?LLl$(D$    D7H[H   L,L$   L+$   IH
٬	 HL$(D$    DH$   HHHD$`L$  L+$  IH
0	 HL$(D$    DL$  L$   IT$HL$h4 LL$   IUHL$p L(H$  LHT$`H$  MHH$    H IDH$   RAH$   ;^(   HcH<    H$  uHڱ	 H$   U[HkHt ]HVH$   H$  AsHHxrHH~ H$h  3H$p  H$x  H$   Ƅ$   H$p  H$   =u HNr	 H$h  H? H$h  0 AH$      ;^(   HcH<    H$  tH	 H$   W[HmHs ]HXH$   H$  CrHHxrHH} H$  3H$  H$  H$   Ƅ$   H$  H$   ?t HPq	 H$  HA H$  2 AH$   ;^,   HcH<    H$  %sH5	 H$   `[HvHr ]HaH$   H$  LqHHxrHH| H$  3H$  H$  H$   Ƅ$   H$  H$   Hs HYp	 H$  HJ H$  ; A;^,   HcH<    H$  6rHn	 H$   q[HHq ]HrH$   H$  ]pHHxrHH{ H$  3H$  H$  H$   Ƅ$   H$  H$   Yr Hjo	 H$  H[ H$  L l    D$p   Dt$`LL$pLD$`H$(  HL$h HT$hH$H  ): '    D$`   Dt$pLL$`LD$pH$0  HL$h HT$hH$H  9     Dt$`L   LD$`H$   HL$h HT$hH$H  9     
 D$hDt$`LL$hLD$`H$@  HL$p< HT$pH$H  Z9 X    Dt$`L   LD$`HT$xHL$hP HT$hH$H  9     HV`L$@  L$  HL$h HT$hH$H  8 H$   Ht(L$   L+IW$   L$   H$   Ht(L$  L+I͑W$   L$  H$  Ht(L$   L+I蘑W$  L$   H$   Ht(L$   L+IcW$   L$   HT$xHt%L$   L+I1WD$xL$   H$   HtL$   L+IH$8  H$H  7 H$H  H$`  HH$H  HtL$X  L+I诐HH$   H3l L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWH@  Hǀ`HXHp )pHW+ H3H$   IMH$`  HH HHH H; r   KHH H$@  Ht

 HE3H E3AHHH H; r
   HH$@  WHt
(IH$@  W$H  L$X  L$   H$   L$   L$   L$(  HT$`H$   [  HD$`H$(  L$0  HT$`H$   4  HD$`H$0  W$   L$   LcoxIMt"M;v
H
4	 k IH$   >`MH$   M;  HT$`  HD$`H$   L$   H;   HD$`L;   Ht$`I+HL$   I;x   IH+HHshI+HIH+Hs
H
	 j HQM+IIHIH+IMI;LCL;ICH$   o_H$   L$   H   I   L$   I;upIH+HHs`I+HIH+Hs
H
	 `j HQM+IIHIH+IMI;LCL;ICH$   ^H$   HtHD$`HH$   HH$   IlL$8  HT$h5  HH$   %(HHL$`HD$`H$8  WD$pL$   Lcg,MtM;v
H
"	 i IHL$p/^MM;   HT$`H$   豜  HD$`HL$xH;sDHT$`HD$pH;w5Ht$`H+HH;$   uHL$pC]HL$xHD$pHt1H#H;$   uHL$p]HL$xHt
HD$`HHL$xHHL$xIV |   Hw(DHގ	 H
?	 NHcH$   AIL$   IH$   H+HHt1fff     HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;r }   DH	 H
	 HcH$  AIL$  IH$  H+HHt0ff     HHL$  IH$  H+HH;rIL+IMt.fff     HHH$  H$  H+HH;r+ ~   DG,H	 L%Ş	 IHcW,H$   X@IL$   IH$   H+HHt+D  HHL$   IH$   H+HH;rML+IMt.fff     JIH$   H$   H+HL;rk    DG,HT	 H

	 HcW,H$   ?IL$   IH$   H+HHt.     HHL$   IH$   H+HH;rIL+IMt.fff     HHH$   H$   H+HH;r݋   uu    HGxH   H   LG0Ht$@HD$8HL$0HT$(LD$ L$   L$0  H$(  H$   u HH$   ԩ       #    HGxH   H   LGHLO0Ht$HHD$@HL$8HT$0LD$(LL$ L$   L$0  H$(  H$    HH$   M H$   HtL$   L+IˇH$      L=ǚ	 H	 ;w,  e    HcL   L+   IHT$(D$    DL   LD$xL+D$pIL|$(D$    DHD$pL<L$   L+$   ILd$(D$    DL$   ATIWHL$hH ID    L   L+   IH
ϙ	 HL$(D$    DZL   LD$xL+D$pIH
	 HL$(D$    D)HD$pL$L$   L+$   IH
	 HL$(D$    DL$   ATIT$HL$`H IDH$   L%	 V       5
 L-Ҙ	 I*;w(      HcH   H+   IHHLI?LLl$(D$    D?H[H   L$H   H+IHHLI?LLl$(D$    DH[H   L,L$   L+$   IH
	 HL$(D$    DH$   HHHD$`L$  L+$  IH
	 HL$(D$    DyL$  L$   IT$HL$h LL$   IUH$   ެ L(H$  kLHT$`H$  VMHH$   H IDH$   OAH$   ;_(   HcH<    H$  aH	 H$   [H-Hra ]HH$   H$  `HHxrHHk H$h  3H$p  H$x  H$   Ƅ$   H$p  H$   a H_	 H$h  H H$h   AH$  ;_(   HcH<    H$  `H͝	 H$    [H6H{` ]H!H$   H$  _HHxrHHj H$  3H$  H$  H$   Ƅ$   H$  H$   a H^	 H$  H
 H$   AH$   f;_,   HcH<    H$  _H	 H$   '[H=H_ ]H(H$   H$  ^HHxrHHi H$  3H$  H$  H$   Ƅ$   H$  H$   ` H ]	 H$  H H$   Aސ;_,   HcH<    H$  ^H4	 H$   7[HMH^ ]H8H$   H$  #]HHxrHHh H$  3H$  H$  H$   Ƅ$   H$  H$   _ H0\	 H$  H! H$   2    Ǆ$      Dt$`L$   LD$`H$(  HL$h軯 HT$hH$H  &     D$`   D$   LL$`L$   H$0  HL$hp HT$hH$H  &     Dt$`L   LD$`H$   HL$h聰 HT$hH$H  _& ]     
 D$hDt$`LL$hLD$`H$8  H$    H$   H$H  &     Dt$`L   LD$`HT$pHL$h HT$hH$H  %     HW`L$8  L$  HL$hZ HT$hH$H  % H$   Ht(L$   L+I~W$   L$   H$   Ht(L$  L+I~W$   L$  H$  Ht(L$   L+IL~W$  L$   H$   Ht(L$   L+I~W$   L$   HT$pHt%L$   L+I}WD$pL$   H$   HtL$   L+I}H$@  H$H  ]$ H$H  H$`  HH$H  HtL$X  L+Ic}HH$   H3 } L$@  I[@IsHA(sIA_A^A]A\_HWATAUAVAWHP  Hǀ(HXHp)p)xH H3H$   ML$   H$   HL$HH$  H$   L$  L$  L$  H$  H$   D$D    D$@P   EHR H
 IcHL$PF3LD$XIHT$PH+HH      Ht'L@ IHLD$XIHT$PH+HH;r3L+IMtfHHHD$XH+D$PHH;rD$@Q   DH H
i HHcHL$hF3LD$pIHT$hH+HHt/L@      IHLD$pIHT$hH+HH;r3L+IMtfHHHD$pH+D$hHH;r   =
 H
 A;?   D$@T   HcMFM+IHL$(D$    DI6MD$M+$IH
K HL$(D$    DrI$tYtWLD$XL+D$PIH
 HL$(D$    D5HD$PtJ   L}	 H*H$   ;0M  D$@W   HcMu IMI+HHHHHH?H  G;  H<[ID$I+$HMLM+LIHD$0LD$(L|	 H
|	 TILMDL+II$(H$   L8HxI+HD  G;9  Mu IMI+H*HHHHH?H  G;  H<[HD$XH+D$PHMLM+LIHD$0H{	 HD$(L{	 H
{	 HSILMDL+IHT$PH$   X0AYtH$   X XH|$pHL$hH+H|G;}
t2H[	 H$   HI	 H$   H$H  V D$D   E3H$   H$   V H$   HcHHnT	 H   H$   HcHh   H$   HD$HH$   S HZO	 H$   3H$0  $8  Hy	 H$      HOU H$  H$   SL$  H$  LC$  HT HD$ DËYHY	 H$  HH	 H$  H$H  U D$D   E3H$  H$  zU H$  HcHHFS	 H  H$  HcHh  H$  HD$HH$  R H2N	 H$  3H$0  $8  Hx	 H$  Ż   H'T H$  H$  RL$  H$  LC$  H HD$ DË1HX	 H$  HZG	 H$  H$H  T D$D   E3H$  H$  RT H$  HcHHR	 H  H$  HcHh  H$  HD$HH$  Q H
M	 H$  3H$0  $8  Hw	 H$  蝺   HR H$  H$  QL$  H$  LC$  H$ HD$ DË	HW	 H$  H2F	 H$  H$H  lS D$D   E3H$  H$  *S H$  HcHHP	 H  H$  HcHh  H$  HD$HH$  zP HK	 H$  3H$0  $8  Hzv	 H$  u   HQ H$   H$  rPL$   H$  LC$   H HD$ DËD$@Z   HT$hH\$HH HL$hH   HD$xH+HHH;vS H    H=   r<tS HAH;rS H+HsS H'vS Hz WD$h3HD$xHT$PHtLD$`L+IIsHH$   H3s L$P  I[8Is@A(sA({IA_A^A]A\_HLH L@HPHHSVWATAUAVAWH  HD$x)p)xD)@D)HMILD$p    Ǆ$  9   H$p  DHv H
 HcHL$@<3LD$HIHT$@H+HH      Ht#LIHLD$HIHT$@H+HH;r3L+IMtfHHHD$HH+D$@HH;rǄ$  :   L$x  E$H H
m \Ic$HL$X<3LD$`IHT$XH+HHt#LIHLD$`IHT$XH+HH;r3L+IMtHHHD$`H+D$XHH;rǄ$  <   H|$(H$h  HD$ MLIH$   c HHHH+HLL$HL+L$@IHL$0Hc	 HD$(Lg	 H
p	 #K3HD$HHT$@H+HHt)L     IHHHD$HH+D$@HH;rH$   HtL$   L+Ip   H$`  D
	 D:	 L H*A;<$+  Ǆ$  >   HcHNH+HHHH?HLD$(D$    DDL4[L>IEI+E HOLO+LIHD$0Hr	 HD$(Lr	 H
r	 JKLODL+IIU (L$P  MFM+IH
 HL$(D$    D(M.HNH+H*HHLI?LH HD$(D$    DL4[L>HD$HH+D$@HOLO+LIHD$0Hq	 HD$(Lq	 H
q	 0IKLODL+IHT$@H$@  X At\L$8  AX?YAWL$X  MFM+IH
k HL$(D$    D*(l IAXt^LD$`L+D$XIH
 HL$(D$    DHD$XtL$H  Ǆ$  A   HT$XL$0  I HL$XHHt{HD$hH+HH;vM H    H=   r<tM HAH;rM H+HsM H'vM Ht WD$XHD$h    HL$@HtiHD$PH+HH;vcM H    H=   r<tGM HAH;r7M H+Hs'M H'vM HIt IL$  A(sA({E(CE(KIA_A^A]A\_^[H\$WH0LIHL+	H*ILD$(DHHHD$    H?HD&HH[H\$@HHH0_Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hr H3HsHsHH;uHl$0Ht$8H\$@H _<K 5K .K 'K  K DL$ LD$HT$HL$SVWH0HD$(HH9z ucH 臭 HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH G HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHp H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _9I 2I +I $I H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   Ho H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weH~o HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _G G G G G G G G H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHn H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _)G "G G G HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHH>0HHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1HSm H3HsHsHH;uHl$0Ht$8H\$@H _E E E E E HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PHp  H3HEpMMHHH   D$     H?6	 HD$`HMC D$    E3E3HT$hHL$`IC HD$`HcHHx0	 HD`HD$`HcHDxDD\   HL$hg~HHL$`ɩHH/d	 躩HH诩HHEj	 蠩HI蕩HAA HH|HUPHL$`BHxrH H
$L HL$(3HL$0HL$8HD$@D$HHT$0HL$@B H:G	 HD$(H HL$(v @SUVWAVH`  HD$8H H3H$P  IIHLD$0    H4	 HD$@H$   	B D$0   E3E3HT$HHL$@A HD$@HcHH/	 HD@HD$@HcHDxDD<   HL$H|HHL$@RHH$z	 CHHU@ HH$x	 'H$0  HL$@uAHHcD$0H$0  H$H  HC$0  Hz	 HD$ L
z	 LD$0I9@UVWAVAWH`  HD$8H$  H H3H$P  MIHLH$  D$0    Hk3	 HD$@H$   @ D$0   E3E3HT$HHL$@q@ HD$@HcHH-	 HD@HD$@HcHDxDD<   HL$H{HHL$@HHx	 HIV5? HHv	 ƦH$0  HL$@@HIcD$0H$0  H$H  HC$0  Hl$ L
4y	 LD$0IH\$Ht$WH IHHH;t HHe)HHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(IHf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IIHA(HWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   HX(H
_	 HH0@8   HH$   蔍 HHL$(H HL$(KY H\$WH HHHÀ< uHú   H% HHu# Ht!HH+fff     9HHuHH\$0H _@SH HRP  H	 HCPH [HL$SH0HD$ HD$P    EtH~	 HA@H	 HAPD$P   J   H	 HH	 HCHC@HcHHn	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH>- HHQ3HHBHK# H	 HH{3HHDH^H\$HHM&	 HHOHKHtHPHGHCHGHCG C Hr
	 HH - HHH\$PHt$XH0_@SH HRM  HS	 HCPH [HL$SH0HD$ HD$P    EtH	 HA@H	 HAPD$P   z  H	 HHq	 HC(HC@HcHH&	 HD@HC@HcHD<    HH0[@SH HJ  H	 HCPH [HL$SH0HD$ HD$P    EtH^	 HA@Hc	 HAPD$P     H[B	 HH!	 HC(HC@HcHH	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH Hc	 HHH	 HAPHI8" HK " HK! H	 HH [@SH HkA	 HHHV	 HAPHI8! HK ! HK! H	 HH [H\$WH H|L  H	 HGPt
X   HI HH\$0H _H\$WH HJ  H	 HGPt
X   HGI HH\$0H _H\$WH HH#	 HHHJHKHtHPHGHS0HCHO0HGHCG C Hv) HC(3HHB  H	 HHB!	 HC(HH\$0H _H\$WH HG  H	 HGPt
X   HwH HH\$0H _H\$WH HH4"	 HHHJHKHtHPHGHS0HCHO0HGHCG C H( HC(3HHB; H	 HHB	 HC(HH\$0H _@SH HH    H   HKX HKH HK8x HK(n HKd HKH [H%T H\$WH HQ@3HHtLAPL+I?H{@H{HH{PHS(HtLC8L+I?H{(H{0H{8HSHtLCL+I.H{H{H{H\$0H _H\$WH HH   7  L   HgfffffffL+   IHLI?LH   r  H   HOXT HOHJ HO8@ HO(6 HO, HOH\$0H _H% HUHl$H  HD$8HXHxH H3HEpIID$0    3A A	    f/rHHr   H 	 HD$PHy	 HD$`HM D$0   E3HT$hHL$P~ HD$PHcHHM	 HDPHD$PHcHhTLHD$hHD$@HL$h HH	 HD$hHE    E    H}U	 HL$`HL$`, HUPHL$PHEPH}hHCEPHD$ L
cU	 LHU	 H
"U	 HMpH3H= L$  I[I{I]HUVWATAUAVAWHH  HEHX)pHE H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHW	 H  IHHL@H
	 H;u.HSHKHH  مHH H  HAАH  HrSHH  H=   r<tW HAH;rG H+Hs7 H'v* HYC HWHL$x9@  MEHT$xH.\  (Hǅ     L  ƅ   A   H
W	 H  9GIH  IPH  HrSHH  H=   r<t HAH;ru H+Hse H'vX HB H   HV	 H   7H( H  H   8ILAHIAАH  HrTHH  H=   r<t HAH;r H+Hs H'v HA HH  HH   H\$0Lt$(x  D$ p  (HT$xH K  H_HD$xH  HuHCH;t'H;tHM Ht
HhHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH   HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
qN	  W  L  D$@Ll$PH^	 HEH		 HEHMH= D$\   E3HUHM HEHcHH	 HD
HEHcHhT
HEH  HMg H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMrHXH  Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
HM	  IPL+IIHL+IIM;HCH;HCHL$@_LD$HMtM(LD$HILD$HIPHL$@H;t
I;t,B IHT$@IPHǅ     L  ƅ   E3H6	 H  BIH  IP H  H  HR	 H  |HȋW$e HHKR	 {IH  IPAD9o$Y  f     LGHWHL$xm EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  
D$0D$(HD$@HD$ LD$`HH  H  EHXH  uHtIH  IPLD$HL;D$Pu   HL$@7LD$HMtM(LD$HILD$HIPHL$@H;t
I;tb@ IHT$@IPHH  HH   ;w$}H
J	 	 Hǅ     L  ƅ   A
   HP	 H  @IH  IP H  HH  cHH   HMHLHMH HT$@HtLD$PL+I4WD$@Ll$PH  HtL  L+I#HT$`HtLD$pL+I}4HM HL$x 3H  H3&4 H$`  ($   H  A_A^A]A\_^]H8D$`AD$hAD$pLALA$A D$xA HLIy ~y ~By  ~g    HH8HK	 LAHD$ H
O	 L
K	 HO	 HK	 LAHD$ H
dO	 L
]K	 HO	 yHiK	 LA HD$ H
9O	 L
2K	 HO	 NH>K	 L
K	 HD$ HO	 H
O	 'HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHM	 H  >HL@H
Z
	 H;u.HSHK{HH  {HH} H  HAАH  HrSHH  H=   r<t' HAH;r H+Hs H'v H)9 HWHL$xK@  MEHT$xHn  (Hǅ     L  ƅ   A   HL	 H  	=IH  IPH  HrSHH  H=   r<tU HAH;rE H+Hs5 H'v( HW8 H   HkL	 H   vH(S H  H   
ILAHIAАH  HrTHH  H=   r<t HAH;r H+Hs H'vw H7 HH  HH  l H\$0Lt$(x  D$ p  (HT$xH]  H_HD$xH  HuHCH;t'H;tH Ht
H8HL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH   HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
AD	  W  L  D$@Ll$PH.	 HEH HEHMH

 D$\   E3HUHM HEHcHH
	 HD
HEHcHhT
HEH  HM7
 H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMB
HXH  rHt
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
C	 
 IPL+IIHL+IIM;HCH;HCHL$@ULD$HMtM(LD$HILD$HIPHL$@H;t
I;t7 IHT$@IPHǅ     L  ƅ   E3H,	 H  8IH  IP H  QH  
HeH	 H  qHȋW$5
 HHH	 qIH  IPAD9o$Y  f     LGHWHL$xc EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  	D$0D$(HD$@HD$ LD$`HH  H  HXH  EHtIH  IPLD$HL;D$Pu   HL$@-LD$HMtM(LD$HILD$HIPHL$@H;t
I;t26 IHT$@IPHH  HH  j	 ;w$}H
@	  Hǅ     L  ƅ   A
   HF	 H  ~6IH  IP H  PHH  3HH   HMHHMH HT$@HtLD$PL+I*WD$@Ll$PH  HtL  L+IHT$`HtLD$pL+IM*HMj	 HL$x_	 3H  H3) H$`  ($   H  A_A^A]A\_^]@SH A(HA g CH [Ht$WH0HD$     H      t@W H   HVxH\$@       ^FxH\$@,;L   HHt$HH0_@SH H HH   H'	 HH HAPHI8B HK 8 HK. HG HH [Wf/v%      ^Ix,;L   H\$WH HHH   HqH   HbH   HH\$0H _I@UHHPHEH\$`Ht$pH|$xHa H3HEHHE   3Hu@uDF
HD	 HM3HKHEH;sTHHUH;wHH}H+H;KuVHg(HH;HKHtcHA   HqHyrHHH;H;Ku
   H$(HKHt'HA   HqHyrHHHU  8HC HEHrPHHMH=   r<tS HAH;rC H+Hs3 H'v& HU. HE   HuE A
   HC	 HMo2HCHMH;sVHHUH;wJH}H+H;Cu
   H;'HH;HKHtcHA   HqHyrHHH;H;Cu
   H&HKHt'HA   HqHyrHHHU  7HC HMHE   HuE A   HB	 HM1HUHHMmHMH3% H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3ur  HSHrr  H_HGPLG`HHOPP8MHHOP-p  HHMAHCHEEWH9puA(H HD$8HEHEHL$0> (Y5;	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0 Yɥ	 XC(EoHHEoH#H      H;v/	 \(=b (5	 f/vIHOhIn  f/v:HEH;t1HKHUuEC(HKHUuHK0HUt]HCHEHx tH HD$8HEHEHL$0 D(DY	 DXC(D   0H4	 I$I\$H]oHOHHHGHCHWHGLL+t6a W=	 A|$At$ HMs HMi HM_ IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA ` CH [H\$WH0HD$     H      tS HWxH   %HH\$@H0_@SH H{ HH   H HH HAPHI8r HK h HK^ Hw HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=	 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@,f HL$0 ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@@f HL$0 L$   HHH$   ($   HĠ   _zj  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Ht HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     OHHK8HOHS0LC8IL+LtH\ HH\$@H0_H\$WH0IH IHD$     HHK HOHSLC IL+LtHD\ HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3G HgHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$P"2 HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P` (Y%]	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$   Ո (X\(HĐ   [B(HhHBHD$(Hx uWYɝ	 HhH HL$8HD$@HD$ HD$P Y	 HhWf/v	 f/v   Wf/vIxHAHH H\$WH HHi  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs蜇 Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$Xh f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HRHSHt
HHH
HJ$H;Cu
   H&HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HWHSHt
HHH
HB&H;Cu
   H+HKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xHѳ H3HEHHE   3Hu@uDF
H"5	 HM	$HCHMH;sTHHUH;wHH}H+H;CuVHHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  4)HC HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   HuE A   H(4	 HM"HCHMH;sVHHUH;wJH}H+H;Cu
   HHH;HKHtcHA   HqHyrHHH;H;Cu
   HhHKHt'HA   HqHyrHHHU  (HC HMHE   HuE A   H]3	 HM"HUH'HMHE   HuE A   H03	 HM!HUHHMHE   HuE A   H2	 HM!HUHHMcHMH3 H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    a  HSHOb  H~HFPLF`HHNPP8MHHNP
`  HHMHUH   
HUHM0HUH   HFPLHUHNPP(HM!HE HMHM(HULL+tH|R HMHEHMHMHULL+t	HRR HN(HD$xH^(H]HV LL+tH&R H]EWA(HGH  Hx uE(H HEH   HEHMK D(DF	 EYDXO(D$`    DEǆ       Ɔ          D^	 D%	 D-	 @      WD$hHt3 HHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM' D]HNh\  fA/  HEH;  LcuIL;wt%HO EtHHGHG    H_E~LEN    HUHOBP EG(Lcu IL;w t%HO} EtHHGHG    H_ E~LE N    HUHOO LcuIL;w8t%HO0) EtHDHG0HG0    H_8E~LEN    HUHO0O Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      Hy`  HEH;  HWHMLbG(EHWHM5bHM   H   H;t=HOH   b   G(HOH   aHO0H   aLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      H_  H   H;t=HWH   iaG(   HWH   LaH   HW0<a     uf/w(\N (HNhZ  f/v=H   HM8`   EXH   HMH`H   HM``f/v\(rX(\(r(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  z fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  Pz fA/v"HL$hv    9   }H]HL$hT D$`   fnu^HE0H;t1HOHU8^EXG(HOHUH^HO0HU`^HY     V0W[	 HV(IHL$x HM HM  HM H    H    H    HM`t HMHj HM8` H   R H   E H   8 HM- HM# HM IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5	 EW=܍	 E   I$HEI|$HFH;t'H;tH Ht
H"HL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$`& H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMv    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMv EHSxHExHD$(H  HD$ L   L   HM]B YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(HC t0Eu"A   EEH&	 H   vA#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtH.HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HMG HtHbHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Af  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`H Y   SxE3{e  H   HCxMHHa  [pSh(\%ْ	 T   f/vA      8  f/vA        f/vA
      H  H9   rA(   ~TUpT]xH0  HMp f/HGHExf/HG^(  5p	 Yf/vA   !H_  @  Y   f/DGHM HMx AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   H Ic    HA   H!	 vAO   H!	 gAO   H9"	 XA6   Hz"	 IAD   H"	 :AC   H"	 +A9   H%#	 AQ   H^#	 
A   H#	 HC   HLKDHH0[ u    W    *  9  H  f     HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5 	 EW=	 E   I$HEI|$HFH;t'H;tHG Ht
HbHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
Z	 ff     HE(WA)HH;}LEMHL$`D H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMn    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMm EHSxHExHD$(H   HD$ L   L   HM9 YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H; t0Eu"A   EEH	 H   A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HMS HtHnHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtH袺HEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I?  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Aa  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`@ Y   SxE3a  H   HCxMHH_  [pSh(\%	 T   f/vA        f/vA         f/vA
      H   H9   rA(   ~TUpT]xH  HMp f/HGHExf/HG^  5|	 Yf/vA   !H~^     Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]HHHWATAUAVAWHPH@HXHhHp LLE3D`LBL+H*HIHHH?H!D$    AINI+HHHHH?H!  AI     IHHL$0p  HIHH;tDHHtLCL+IL#LcLcHHHGHCHGHCL'LgLgHL$0HtJHD$@H+HI;   H    H=   r uhHAH;sXH+HrHH'w;HJ HHINI+H*HHHH?HH;s(     IL\$PI[8Ik@IsHIA_A^A]A\_LSH   ICHAC    H ICH ICAC   Hu ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$Xv H HD$(H[ HD$PHD$hHcHH6 HDhHD$hHcHDd    HP HL$(= @SH0HD$ HٹX    HD$@HSHca  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HA(HA@HcPH HD
@HA@HcPDBDD
<HE HH HA(H0 H HHKHtHP tHC    H0[LSH   ICHAC    H ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$X H HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    HL HL$(]
 @SH0HD$ HٹX    HD$@HSH3`  HHtH@@HcHHB@HH0[@SH0HD$ HH HHe HA(HA@HcPH HD
@HA@HcPDBDD
<H HH HA(H0 H& HHKHtHP tHC    H0[LH   ICAC    HQH3 ICH8 ICAC   IKH HD$(H8 HD$@HD$hHcHH HDhHD$hHcHDd    HK HL$( @SH0HD$ HٹX   < HD$@HSHS_  HHtH@@HcHHB@HH0[@SH0HD$ HH HH} HAHA@HcPHb HD
@HA@HcPDBDD
<H
 HH HAHI HtHP tHC     H5 HHKH0[H%: @SHpHK H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8^ @-H$   u	HHHtHL$`H3k Hp[2HL$`H3V Hp[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PHC HA@HH HAPD$P   Hg HHOH HHG@HcPH7 HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_H[ H\$WH H_ HH   H HH HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH HG HHH0 HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH H' HH   Hl HH HAPHI8 HO  HO H! Ht
  H HH\$0H _H\$WH H HHH@ HAPHI8 HO  HO H Ht
   H HH\$0H _H\$Ht$WH0H3HRH\$ H+HeHHGH+HHtHHHHHGH+HH;rH\$@HHt$HH0_LHXICLL	IAI+HHIH;rQHx IC3ICICHS	 ICD$0ISIK H HD$8H	 HL$87HAI@IHH
HHXHUSVWATAUAVAWHH  HE@)p)xD)@D)xD)hD)XD)HD)8D)(D)H׉ H3H`  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,HS	 HD$ L
'	 LD$@HS	 H
	 ǈfE/w,H 	 HD$ L
	 LD$HH0	 H

	 蔈̋  .H	 HD$ L
	 L  H 	 H

	 HHPHMKIHPHM:E(D=4r	 o	 T$@fn=~n	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGH HE3HEHE H]	 HEEHUHM H HEHMI HuIH HD$XHHL$`HD$pHD$hHǅ(     L   ƅ   A!   H
	 H  &HH  HP H(  HrSHH  H=   r<tr HAH;rb H+HsR H'vE Ht Hǅ(     L   ƅ   AC   H	 H  HH  HP H(  HrSHH  H=   r<t HAH;r H+Hs H'v H 2 EAA   D5x	 D-l	 @      G D$ L
	 DEH	 H
	 9IGHHHL$ L
	 DG H	 H
u	 pIHt$0IGHD$(AGD$ MOMHUH* HMAu3H8  !HHMTHH   H8     H8  HD$@HUHL(HMHHMʥH8  HMH@  HULL+t	H( HM虥HH  HMHP  HULL+tH' E؉X  L8  
k	 HMpLHH  HHMH    H   HM( HM fEnEA(' ^H8  HD$@HUpHML
?k	 H  HHM诤H8  HMH@  HULL+t	H' HM~HH  HMHP  HULL+tH& EX  L8  (HMH{LHHMHH`HM( HM H    H   AƙA ;  A(LHI~Y  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(uHtX9HI;IDH;tHuWI*MyX)k	 ^HT$XU  D(H H   HZ H   H8   L$PE3H   H   Y H   HcHH& H
   H   HcHh
   H   HD$HH    H H   3H   (  PH  w HH H   +HHu3
H HcHHHW   H  3 HAH HH M+HHu3
H HcHHHW   H   HH5H\ HHu3
H HcHHHW   H   HA(H& HH *HHu3
H HcHHHW   H  i HHH HHu3
H HcHHHW   H   H(H HH{ 2*HHu3
H HcHHHW   H    HHHA HHu3
H HcHHHWA(H  Z +Efn^5h	 t$H3H  H   H  WH  H  HtD	H  HH  HT$HH  H;sLHT$HH;wBH\$HH+HH;   u   H  H  H  HtHHH1H;   u   H  H  H  Ht1H  H  HH  HT$@H;sLHT$@H;wBH\$@H+HH;   u   H  H  H  Ht;HH+H;   u   H  IH  HtDH  HH  IE L@H
׺ H  H;Iu#/AfD/vH	 H   'E2fE/vH	 H   'E2AG D;~!fE/wfA/vH	 H   'HH   HPE   A(A\A^ATf/*c	    HǅP     HH  D8  Aa   HV	 H8  HH8  HP H8  lHǅP     HH  D8  AH   Hv	 H8  JHH8  HP H8  H  Ht%L   L+IW  H   H8  νH8   =Ib	 H}D;     HǅP     3HH  8  DCiH	 H8  HH8  HP H8  iHǅP     HH  8  DCBH6	 H8  JHH8  HP H8  E2AEu8LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtNHMk HMa HMV HML H`  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH`  Hǀ)p)xHz H3H$0  ILL$hEHHT$pLH$   H$   DD$XL$   E3ADt$HE,H$ HD$ L
 LD$XH	 H
	 HǄ$     L$  @$  A   H	 H$  aHH$  HP H$  HrTHH$  H=   r<t HAH;r H+Hs H'v} H (5g	 $  (
e	 $   ^	 $  
b	 $   LHIO  $   I$HPH$   I$HPH$   j_	 $  
p_	 $  ^	 $   WL$xD$@AΉL$D|$@ 
  Hc  $  $   A   D|$`E;  AAHǄ$     L$  Ƅ$   E3H H$  HǄ$     L$  Ƅ$   E3H~ H$  sF    EHt$8H$  HD$0H$  HD$(E͋莺H$  HrTHH$  H=   r<t HAH;r H+Hsy H'vl H HǄ$     L$  Ƅ$   H$  HrUHH$  H=   r<t HAH;r H+Hs H'v H HL$pY $   D$P;  ML$Iq\$P;u4Ht$hHt$0ID$HD$(AD$D$ M$H$   b   H H$P  H$   |$HE3E3H$X  H$P   H$P  HcHH HP  H$P  HcHxL  H$X  HD$hH$X  ˶ H3 H$X  L$  Ǆ$     H H$P  Hm HH HHHʶ H HH$  H$P  ָH$  H$  HC$  HD$ L
# LD$PH H
 'H/ H$P  H$  i |$HE3E3H$X  H$P  - H$P  HcHHY HP  H$P  HcHxL  H$X  HD$hH$X  u Hݰ H$X  L$  Ǆ$     H H$P  nH H_H HPH HV H6H$  H$P  職H$  H$  HC$  HD$ L
 LD$PH H
7 %E3$   D|$`L$   |$HH$   HD$pDl$XH$   Ht$hH$   Au:H$  HH$   H$   H$  7  H$  HD$PH$H  L$   H$   HH$   ZH$  H$   H$  H$   LL+t	H H$   H$  H$   H$  H$   LL+tHf $   $  L$  $  H$p  LHH$  +HH$   *H$  c H$  U H$0  F H$   8 fAn (^H$  HD$PH$p  H$   L$  H$  HH$    H$  H$   H$  H$   LL+t	HK H$   H$  H$   H$  H$   LL+tH $   $  L$  (H$H  LHH$   HH\$pHH$0   H$    H$   H$   AǋL$D?LHIF  7E3$   L$   |$HH$   H\$pDl$XH$   Ht$h$   f/
  f/$      H$  H H$  4HH %HL$xn HH D|$DH$  AH |H HH$  HPHǄ$     L$  Ƅ$   E3H H$  
HH$  HP H$  ݣD$@ H$8  軰H$8  m   D|$DA}$      f/$   :  H$  ӱH H$  HH HL$xH HH HH$  HPHǄ$     L$  Ƅ$   E3H H$  
HH$  HP H$  ݢD$@ H$8  軯H$8  m H$    $  D$xAD|$DIT$H$   HHH$0  $ H$    AFL
 H #n  H$    H$   ޱ H$   ϱ H$    D$xH$0  H3S ($P  ($@  H`  A_A^A]A\_^[HUSVWATAUAVAWHxHH  HE()p)xD)@D)xD)hD)XD)HD)8D)(D)Hm H3H  D((UHHULT$@\$HH  L  E3Dt$PEWfA/w,H HD$ L
W LD$@H H
D kfE/w,HP HD$ L
$ LD$HH` H
 k̋  .H HD$ L
 L  HP H
 HHPHM諲IHPHM蚲E(D=dU	 R	 T$@fn=Q	 YfAnG ^L$HHD$@HL$Hf/HF, HcLt$xHH;vGHJ HE 3HEHEH HEE HUHMǮ H HE HM - HuIH0HD$XHHL$`HD$pHD$hHǅH     L@  ƅ0   A!   H2 H0  VHH0  HP HH  HrSHH0  H=   r<t HAH;r H+Hs H'vu H HǅH     L@  ƅ0   AC   H H0  HH0  HP HH  HrSHH0  H=   r<t HAH;r H+Hsޮ H'vѮ H  b EAA   D55[	 D-O	 @      G(D$ L
 DEH H
 IGHHHL$ L
 DG(H H
 ,Ht$0IGHD$(AGD$ MOMHUH HMAu3H`  !HHMdHp   H`    H`  HD$@H`  L(HM0HHMH`  HMHh  HULL+t	HL HMHMHp  LELx  HMH  LHUNL+tH E艅  L`  
N	 H  7LHH0  EHHMHH@   H0   HM@ HM0 fEnEA(
 ^H`  HD$@H  HMոL
RN	 H0  >HHMH`  HMHh  HULL+t	H
 HMHM茇Hp  LELx  HMH  LHUNL+tH	 E  L`  (H`  LHHM08HH<HM@ HM0ߪ H@  Ѫ H0  Ī AƙA   A(LHI@  D(D$@(A_D(\^ATLL$`ILT$XI+HLD$xI;tHMu2HD$p0HT$pHLT$XLL$`I;IDHHT$hLD$xFHT$pHL$h?HT$pHt2LD$xHT$pLL$`LT$XHI;IDILD$xHL$hHT$pMA(u)Ht$fff     X9HI;IDH;tHuWI*MyXN	 ^HT$X8  D(H HE`HN HEpH    L$PE3HUxHM`V HE`HcHH& HD
`HE`HcHhT
\HExHD$HHMx H$ HEx3H      PH   HH HMpHHu3
H HcHHHW   H  H HAH HH bHHu3
H HcHHHW   H   HHJHq HHu3
H HcHHHW   H   HA(H; HH 
HHu3
H HcHHHW   H   ~ HHH HHu3
H HcHHHW   H  - H(H HH G
HHu3
H HcHHHW   H    HH/HV HHu3
H HcHHHWA(H5 o +Efn^5K	 t$H3H0  H@  H8  WH0  H8  HtD	H8  HH8  HT$HH0  H;sLHT$HH;wBH\$HH+HH;@  u   H0  4H8  H0  HtHHH1H;@  u   H0  H8  H0  Ht1H8  H0  HH8  HT$@H;sLHT$@H;wBH\$@H+HH;@  u   H0  H8  H0  Ht;HH+H;@  u   H0  ^H8  HtDH8  HH8  IE L@H
 H0  H;Iu8AfD/vH HMp
E2fE/vH HMp
E2AG D;~fE/wfA/vH HMp
HHU`HPE   A(A\A^ATf/KF	    Hǅx     Hp  D`  Aa   Hw H`  HH`  HP H`  荔Hǅx     Hp  D`  AH   H H`  kHH`  HP H`  =H0  Ht%L@  L+IW0  H@  H   H    =jE	 H}D;     Hǅx     3Hp  `  DCiH4 H`  HH`  HP H`  芓Hǅx     Hp  `  DCBHW H`  kHH`  HP H`  =E2AEu)LD$`ILL$hI+HHT$XHL$xH;|
IH+HH+IHD$hL+IHtoHM HM HMw HMm H  H3 L$H  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]HSVWATAUAVAWH  Hǀ)p)xH] H3H$`  MLL$`EHHT$pLH$   H$   DD$XL$   3t$HE,HG HD$ L
 LD$XH H
 +HǄ$     H$   @$  A   H H$  IH$  IP H$  HrTHH$  H=   r<t͡ HAH;r H+Hs H'v H (XJ	 $   (
)H	 $0  B	 $@  
E	 $   MHI6  $   IHPH$   ԢIHPH$   迢B	 $   
B	 $   A	 $   WL$xD$@ΉL$D    |$@ R
  Hc   $   $   A   Dd$hE;D  AAHǄ$     H$  Ƅ$   E3Hҿ H$  HǄ$     H$   Ƅ$   E3H H$  F    ELt$8H$  HD$0H$  HD$(E͋讝H$  HrTHH$  H=   r<t HAH;r H+Hs H'v H HǄ$     H$   Ƅ$   H$  HrUHH$  H=   r<t; HAH;r+ H+Hs H'v H= HL$pY($(  D$P;  MOMq\$PA;u1Lt$`Lt$0IGHD$(AGD$ MH$   E   H H$`  H$   |$HE3E3H$h  H$`   H$`  HcHH҉ H`  H$`  HcHx\  H$h  HD$`H$h   HV H$h  H$  Ǆ$     H( H$`  H HH HIH H HH$  H$`  H$  H$  HC$  HD$ L
F LD$PH H
 :
HR H$`  H$   |$HE3E3H$h  H$`  P H$`  HcHH| H`  H$`  HcHx\  H$h  HD$`H$h   H  H$h  H$  Ǆ$     H H$`  H HH HsHؙ Hy HYH$  H$`  褚H$  H$  HC$  HD$ L
 LD$PH H
Z 3$   Dd$hL$   |$HH$   HD$pDl$XL$   Lt$`H$   Au:H$  辥HH$   H$   H$  T  H$  HD$PH$X  wL$   H$0  ^HH$   ~vH$  H$   H$  H$   LL+t	H H$   H$   6vH$  L$   L$  H$   H$  LH$   NL+tHm $   $  L$  $   H$  蕵LHH$  袳HH$   表H$   j H$  \ H$@  M H$0  ? fAn (^H$  H$   -L$   H$  蔴HH$   H$X  \L(H$  ɴLHH$0  HH\$pHH$@   H$0   H$   H$  s AċL$DMHI.  63$   L$   |$HH$   H\$pDl$XL$   Lt$`$   f/
  f/$      H$  艖Hy H$  HHB HL$x HH Dd$DH$  AH7 |HV qIH$  IPHǄ$     H$  Ƅ$   E3H H$  IH$  IP H$  mD$@ H$X  KH$X     Dd$DA}$      f/$   9  H$  cHS H$  HH HL$xؔ HHF qIH$  IPHǄ$     H$  Ƅ$   E3H H$  IH$  IP H$  mD$@ H$X  KH$X   H$    $   D$xADd$DIWH$0  HHH$@   H$0   AL
p HQ Q  H$   } H$   o H$  ` H$   R D$xH$`  H3 ($  ($p  HĐ  A_A^A]A\_^[H\$
7	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI{  C(WoA	 C(H$   H$   H0HHD$XHHCH;t/H;t"H Ht
HoH3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
@	 fff     HD$X(WA)HH;}LD$@MHL$h HĐ   _^[@SH`HBHHD$(Hx uWY4	 XB(H`[H HL$8HD$@HD$ HD$P Y4	 XC(H`[@SH    Wf.HAxHH   zt9HhPYP5	 \4	 Y   X4	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
HnHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pHM H3H$P  HHHL$0袏sxH% HL$@H(' H$0  HL$0ݍLHHAPH$H  HrUHH$0  H=   r<tz HAH;rj H+HsZ H'vM H| H$   莍H$   @ H$P  H3 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHMc| (Y
`1	 XK(MHEHH#H      H;v
3	 (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   f/vH0   X<1	 (T H0  X  H;t/HSHNI HC(HF(HSHN4 HS0HN0' LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$hZ HMHLHT$hP(HH   HHHHPHKHHHSHL$h HHEHsH   HCH;t'H;tHa Ht
H|iHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h; H       D  HY(WEHt3 HhHEH] =1	 } H  H[WEHt3g HhHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h7    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM0	7}H  L@LEWEMt3 HM&gHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHM׿ H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(
(Xu \
(XuuHUH(  HEf/w"\[ (H   Hhnf/vHE0H;tHU0HS6WEH]HHt3O HoeLHEH]LEHuHEHEHEHEH;t-I HtH/eLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM+ LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHMT LML   H   H   豌HM HM HM` HMH HM8 HM HM| L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   H'  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0d$  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0XM LLHHG%  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK    辩 HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_@SHpahHAHT%J2	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$hi f/0  s0  ^W1	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HM_oHHEH[IG3H;t'H;tI Ht
H-`II?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
)1	 f     HE(WA)HH;}LEMHM HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM{ (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM` Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHML H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHM
 Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM H(H;~uH>H;~IDHHMtLE'M+II,L$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHMw D(=C"	 EtCH]H{ uA(HHEHEHEHM}l (A^H  HG     (A^}gH]H{ uA(HHEHEHEHM-l D^DG0DMWEWMHUH  HM~ HM~ HEgHEH]HuHOH;uHOMgIHHUGF (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   @SHpahHAHT%*	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h	 f/  s  ^Wl*	 Hp[HWH   H@HXHpHHHHL@@@HPHHq HsHG3H;t'H;tH| Ht
HXHHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
)	 fff     HD$`(W)HH;}HL$(HL$8膷 HL$p{ L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$H D(5	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;t'HHHt3z HVHD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0 E   LuI~ tIHD$PHD$xHD$`HL$Hf (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"Hoy Ht
HUHH    H_H_LEHT$xHJ   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;tAHHHt3x HTHD$HH\$PH\$XLEHT$xHL$HG H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;tIIHGHH;t"H5x Ht
HPTHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$Hw ID$HEDMLeLeLEHT$xHħ HL$0pw (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    Hfb HA@Hkp HAPD$P   VHb HH(q HG(HG@HcHHi HD9@HG@HcHQT9<HH>HH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    Ha HA@Ho HAPD$P   "UHh HHc HG(HG@HcHHb HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHa HA@Ho HAPD$P   PHgc HHOH	j HHG@HcPHk HD:@HG@HcPDBDD:<HSHHDѿHH\$HHt$XH0_HL$AVH@HD$0H\$XHt$`H|$hMHH_  tH7MHH H[HHOH\$XHt$`H|$hH@A^HL$HHW	 LL$P)t$0LD$X3)|$ s5!	 =	 Tf/vEu  "   7	 LL$PLD$X3sTf/vu  "   	 LL$PLD$X3XsTf/vt  "   	 LL$PLD$X3*sTf/vt  "   	 LL$PLD$X3rTf/vt  "   	 LL$PLD$X3rTf/v_t  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
+ p 3Ld$xM+L$3IIHH+II;HCI;LCI萹H$   HH+LL$   HH-HIL$   L+q LGH3H$   IL+q HHGH+HHHtLGL+I KLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$pq HOLD$pHH+$   HH+H,H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0xp H$   ILkHGL+LI+HRp H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(肸Ht$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
K l H
= l LD$0H|$(IH+HHHDL$pHH 3HthH+HI;vo H    H=   r=@tjo HGH;rZo H+HsJo H'v=o HHi (L\$PI[(Ik0Is8(t$@IA_A^_HSVWATAUAVAWH   HǀH)p)xD)@D)HH) H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ Ht3m HIHD$@H\$HDd$8A܉\$4D	 fD  A;]  MuAA  ~1ID  H\$@MA(( ;HA;w |ۋ|$0LD$@H$   I袜HHL$@HHT$@HPHL$HHHHT$HH$   l Hp H$   H^ H$   H$H  k |$0E3H$   H$   k H$   HcHHpi H   H$   HcHh   H$   HD$hH$   h L5\d L$   L$0  D$8  HT$@IM V  (D$hH$  H$   hHXH$  HrTHH$  H=   r<tl HAH;rl H+Hsl H'vsl H袓 HtHt$`HH$   HPt$pHD$pH      H#H;u+H# HD$ L
ߣ LD$hH H
 &DXDL$P\$4É\$4H$   HcHHg H   H$   HcHh   L$   H$    H$   i H$   h H$H  i 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^IOHy t#HH$   H$   H$   腖(fAnw Y5(	 
0 AXYXAXHL$@i (H$  H3舊 L$   A(sA({E(CE(KIA_A^A]A\_^[HSVWATAUAVAWH  Hǀ@)p)xD)@D)HH_% H3H$  LD$`LLHL$XHT$xL$   E3ADd$0WD(|$PWD$@HcZ(Ht3i H5EHD$@H\$HDd$8A܉\$4D	 fD  A;]  MuAA( ~1ID  H\$@MA((l ;HA;w(|ۋ|$0LD$@H$   I肀HHL$@HHT$@HPHL$HHHHT$HH$   Zh Hk H$   H+Z H$   H$8  eg |$0E3H$   H$   $g H$   HcHHd H   H$   HcHh   H$   HD$hH$   td L5_ L$   L$   D$(  HT$@IM   (D$hH$  H$   xdHXH$  HrTHH$  H=   r<t h HAH;rh H+Hs h H'vg H" HtHt$`HH$   HPt$pHD$pH      H#H;u+H HD$ L
_ LD$hH H
d !DXDL$P\$4É\$4H$   HcHHvc H   H$   HcHh   L$   H$   蠝H$   *e H$   dd H$8  e 0E3DL$PWLl$XL|$xL$   LD$`|$0\$4fAnED^I|(AXHL$@e (H$  H3R L$  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pHI! H3HEIHHE   3Hu@uDFnHǫ HM~HHUHP@HEHrPHHMH=   r<te HAH;re H+Hse H've HՌ HHPHE   HuE 8 uLIIB<  uHHMؐHHUHP@HEHrPHHMH=   r<t-e HAH;re H+Hs
e H'v e H/ HE   HuE A   H HMIHHUHP@HEHrPHHMH=   r<td HAH;rd H+Hs~d H'vqd H蠋 HE   HuE Ah   H HM躏HHUHP@HEHrPHHMH=   r<td HAH;rc H+Hsc H'vc H HE   HuE E3H5 HM.HHUHP@HEHrPHHMH=   r<tc HAH;rsc H+Hscc H'vVc H腊 HMH3	 H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ IK  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HO:` HO0` HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;v` KHH=   r<t` HBH;r` H+Hs~` H'vq` HHH(陇 H(LHXICHfffffffH;vJHh IC3ICICHF ICD$0ISIK^ HpO HD$8HL$8  Hu3KH;vt\ HHH   r&HA'H;wS\ H҂ HH'HHA迂 HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"Hh^ Ht
H:HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHMH HLFhLNH     HFH^HHEH~HCH;t+H;t"H] Ht
H9HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
	 fHE(WA)HH;}LEMHM襘 H   Hǆ       HJ} E3L\$pI[Is I{(I]/He EHEHU3HMHEHEHǤ HE[ HY H
 HEHM @SH 3HHHAHAHt~H
H;vH
 	Z HRH|$0H<    H   r#HO'H;wY ! HH'HHAH HHHKHHH|$0HKH [LALIIHQ I+HH;|
IH+HH+IHHAHtL+I||H\$WH HI HHAPHI8t[ HO j[ HO`[ HyP Ht
   Hd HH\$0H _@SH HHI[ HKH [H%[ @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(OFE3EL9{~HN(HJJIL;S|HFXLFLN@HV(H5;	 WAE H^HH+^@HI;^tIY Ht
H5IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtHA HH*LW    cAE $   H$   H#H;t3@HN Ht+HR 蕾HH# 膾HHV       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [HhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$PqD WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3V H2HLsHkHnH{ H|$hH|$hL?LHt3V Hc7 HHoHnH{0H|$hL?LHt3sV H2HHoC@   CD HHH HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	q uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
 S HH|$0#HT$8HHFHHH\$@HNH+H>LH]T H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     HF HD$`HMS D$    E3E3HT$hHL$`S HD$`HcHH@ HD`HD$`HcHDxDD\   HL$h觎HHL$`	HHot HHHHz HIչHI)R HH边HUPHL$`SHxrH H
f\ HL$(3HL$0HL$8HD$@D$HHT$0HL$@R HM HD$(H
 HL$(܆ @SH`W)t$Pf/D)D$0D(   u+DW 	 3A(W 	 (t$PD(D$0H`[$ fA/DWw 	 A(v(
 \((t$PD(D$0H`[3bXb (t$PD(D$0H`[5 fA/)|$@D)L$ D
0 !  J fA/vTfD.z   eH%X      HЋ99   % AYDY AX   eH%X      HЋ9 
  A(AY(Y((Y%z (Y
 Y_ X%O X
g X7 YYYW X% X
/ YX+ XYX^X%+ AY  3t
S  fA/  Ǽ eH%X   =  fA/   HЋ   9   A(A(\AYWb (Y蠯 ((Y` (YM (Y
 X2 X" A^X
m YYYX X
A YYX(YB X
 X X YX YX^X* Y  1 fA/   9 '  A(A(\AYWj (Y訮 ((Y (Y (Y
 X X A^X
 YYYX X
 YYX(Y XR X YXX
z ^X^ Y   fA/   9   A(A(\5> AY(Ww Y踭 ((Y  (Y (Y
b X X A^X
5 YYYX X
	 YYX(Y
 Xj X YXX
 ^X Y   9 Z  A(A(A^AY(YW ެ ((Yf (YS (Y
h X8 X( A^X
; YYYX X X
 YYYX X
 X(Y X YX YX^X Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
 o = | H
 U <o H
 o =x (; H
d (
 6  F (/ H  
 (
r : 
 n qH
 	o = V( H
 (
  (]  (? 
 (
1  
 
 (
  
 ,n H
 {n = ( H
t (
  ( 
 (
  (S 
 (
  
 m [H
* m = .( H
 (
o   ( 
" (
 $ (e 
n (
 p 
y 0m H
0 m =$ ( H
 (
Q  (c    (e 
 (
   
 (
*  
 l H\$D$WH`)t$PI)|$@H(D)D$0 f/   (ͨ f.zuJ   !   t  (E (Wf/B WvW 胨 D(E3(LHXD\(a D\  q f/vfWf.zo (
 Tf/v D(DW     ^\n T D(    f/v$((\ \
 (E D(of/= r! f/v(+K 茧 D(DHL$pw D((X: \ [ \% \= YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
 )t$P)|$@   HD)D$0D)L$ D(ȋ
9    DX
 5 D(A(AYD^A(A(AY蜦  EX
 YYA^Xt X
d D(L$ X(t$PYYX= X
- YY(|$@X AYXX AYD(D$0\HhH
 i = ( H
 (
 ) ( )
 (
y ) )
 "i H8eH%X   
Q A   )t$ (HB9    (\58 \-` (\-U Y\-! ((Y% (Y (Y
 X% X; Y X
 YX YX% YX YX
u YYY(t$ XXP X%X X^YY-\ X(H8H
 Xh = ? H
 (
 1 (  ( ս ( 
 (
 ٽ 	 
 (
 ˽ 
 kg HH   )xD)@D(DTa D)HD(DT
P D)PE(D)XDq fE/D)`D(EYrA(A(A( (    fA/A()$   rL (A(L =W   M (A(M (XY=] YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW=l (($   HĨ   @WH  HD$PH$  H
 H3H$p  IHD$     H5 HD$`H$   B D$    E3E3HT$hHL$`B HD$`HcHH/ HD`HD$`HcHDxDD\   HL$h}H HL$`HHgc HHHH}i بHHͨHH1c 辨HH"c 诨H$P  HL$`AHxrH H
SK HL$(3HL$0HL$8HD$@D$HHT$0HL$@A HiF HD$(HM
 HL$(u H@Hx)p()xD)@D D)HD
E fD/D)PEWA(rPA(\(pĠ (\f/
 vAXfA.z   = Y(豠 ^fA.z   f/5 r
(ZX
 f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   H4 H
 D$   . L$   H H
  H  HD$PH
 H3H$p  D$     H2 HD$`H$   ? D$    E3E3HT$hHL$`? HD$`HcHH, HD`HD$`HcHxT\   HL$hzHEh HL$`HHy` HHf HHf HHJ` ץHHw ȥHH,` 蹥H$P  HL$`?HxrH H
]H HL$(3HL$0HL$8HD$@D$HHT$0HL$@> HsC HD$(HW
 HL$(r HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p5d )xWD)@Dw D)HD
 H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4CF H;}&HEHM(HE)HH;|LHMH HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ p E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   `K HHL$(rK H
 HL$(n @SH0HD$     zHH0[@SH0HD$       HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH 3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+I~Je  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHMLeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHM=LeHEH}IHtHHHEIM;w!H
o }6 H
o o6 H]3MtyIrTIƃIH+fo f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHMSHUHH?HMHthHEH+HH;v8 H    H=   r<t8 HAH;r8 H+Hsx8 H'vk8 H_ A   L}XI;      HVHHM
E3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HDHNHMKHHHMHt		H]L}X1L;Fu
   HDHNHMXHMHt
HU	H]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH0^ IL}XL;}s(6 6 6 6 6 HtsL+IHL;v6 J    H=   r=@t6 HGH;ru6 H+Hse6 H'vX6 HH] IM H   IEH+HH?H;v6 H    H=   r<t6 HAH;r5 H+Hs5 H'v5 H] 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){Hw
 H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0 f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   C V  H$  H$   aHL;   IM Ht~IEH+HHH;vt3 H    H=   r<tX3 HAH;rH3 H+Hs83 H'v+3 HZZ Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;v2 H    H=   r<t2 HAH;r2 H+Hs2 H'vv2 HY   H5 H$  L$  H$   H$  H4 H$   H3# H$0  H$  m0 AD|$4E3H$8  H$   *0 H$   HcHH- H   H$   HcHh  H$8  HD$XH$8  z- H( H$8  H$  $  ML$   H$  HL$PnH$  H$   x-HXH$  HrTHH$  H=   r<t 1 HAH;r1 H+Hs 1 H'v0 H"X HtHH$   HPH$   HcHH, H   H$   HcHh  H' H$8  H$8  fH$8  . H$@  - H$  q. H2 H$   HJ! H$0  H$  . AD|$4E3H$8  H$   A. H$   HcHH
, H   H$   HcHh  H$8  HD$XH$8  + H& H$8  H$  $  L$   IHL$PE (H$  H$   +HXH$  HrTHH$  H=   r<t=/ HAH;r-/ H+Hs/ H'v/ H?V HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   H H$  ZHH$  HP H$  HǄ$     H$  Ƅ$   A>   H H$  YHH$  HP H$  HǄ$     H$  Ƅ$   A4   H H$  oYHH$  HP H$  ?H$  !*H$  + H$     H$  S+W$  H$  A. L$  L$   IHL$P- +fn^5 H$  H$  X)HXH$  HtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   H H$  WHH$  HP H$  HǄ$     H$  Ƅ$   A8   H H$  WHH$  HP H$  rHǄ$     H$  Ƅ$   A4   H1 H$  LWHH$  HP H$  E2HI;EulMtL$  M+II|KH$(  'H$(  ) H$  'H$  d) H$   薄Ld$`4  $   J  HǄ$     H$  Ƅ$   E3H74 H$  kVHH$  HP H$  ;H$  ~(H H$  蹏H(( HH 螏HH$  HPH$  0(Y5 H H$  cHHy THH~ EH(' HH? *HH$  HPHǄ$     H$  Ƅ$   A%   H H$  SUHH$  HP H$  #HǄ$     H$  Ƅ$   E3H2 H$   UHH$  HP H$  HǄ$     H$  Ƅ$   E3H2 H$  THH$  HP H$  }H$(  _%H$(  ' H$(  C%H$(  & MtL$  M+IIHH$(  
%H$(  & H$  $H$  & H$   ҁD$HL$@T$2   H$  $H$  e& H$   藁3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3H0 H$  SHH$  HP H$  H$  %H H$  QH($ HHo 6H($ HH HH HȋT$@o$ HHe HH$  HPHǄ$     H$  Ƅ$   Ae   Hf H$  RHH$  HP H$  H$(  "H$(  }$ H.. H$   3H$   H$   H H$   Ƅ$   H$   H$   $ H() H$   H	
 H$   X HL$pHIPH\$xHt(H$   HL$   L+IH[CH$   HtL$   L+I4IH$  H3FE ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH0
 H3H   (MLHT$`HL  L  H  3ۉ\$DH   "WD$HH\$XLL$HMIHd(H  H    HXH  HrSHH  H=   r<tx$ HAH;rh$ H+HsX$ H'vK$ HzK H   IH   IPH  H   > HLAH? H;t
HHAАH  HrSHH  H=   r<t# HAH;r# H+Hs# H'v# HJ W  Hǅ      t$(H  HD$ MMIHJ H  H   tHXH  HrSHH  H=   r<t# HAH;r# H+Hs" H'v" H J H   IH   IPH  H   HLAH H;t
HHAАH  Hr\HH  H=   r<tt" HAH;rd" H+HsT" H'vG" HvI Hm E3EDd$@H  H H  H(^ HH;tHPH  H  HLAH;t
HHAАH  HrSHH  H=   r<t! HAH;r! H+Hs|! H'vo! HH HH;tHPHǅ     L  ƅ   E3H* H  LIH  IP H  HrSHH  H=   r<t  HAH;r  H+Hs  H'v  HG IH  IPHǅ     L  ƅ   E3H) H  KIH  IP H  HrSHH  H=   r<t<  HAH;r,  H+Hs  H'v  H>G H  
   HL$h H  HcQH  HHP   H    HH H  讄HHuI
H HcHHHW   HMJ HH| HpHHuI
H HcHHHW   HM HH& H2HHuI
H HcHHHW   HM HH HHHuI
H HcHHHWH< HȃH  H  HLAH H;t
HHAАH  HrSHH  H=   r<te HAH;rU H+HsE H'v8 HgE IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
8  =] HX HEH  HEHMH
 L$DE3HUHM HEHcHH HD
HEHcHhT
HEH   HM: H HE3HE0E8IHHH   
   HM HMHcQHMHHP   HM LIHMb HHu3
H HcHHIWA   HM LH   H HHu3
H HcHHIWA   H   X LB+H HHu3
H HcHHIWA   H   LH HHu3
H HcHHIWAB+\Hg H   HMHLAH  H;t
HHAАH   5IHUIPB+\Tf/vD$@HMHHMH IHL|$`IGI+HL;H|$hH
x6Dl$@H  H\$HHX  HX  X HX  HX  > HtL  L+IH;HtLD$XL+IH:HX  ;HX   AH   H3: L$P  I[XA(sA({IA_A^A]A\_^]HWATAUAVAWH  HǀHXHp)p)xD)@LH5' EWWHHǀX    H`LhHǀp    Hǀx    H
HBH+HHucH! HD$p3HD$xH$   HR H$   Ƅ$   HT$xH$   9 HJ HD$pH6R HL$p|HǄ$H     $   HBH+HHwcHB! HD$p3HD$xH$   HR H$   Ƅ$   HT$xH$    H HD$pHQ HL$p   H$H  AD$hW$   E3L$   LcnxIMt*M;v
H
0N  IH$   
aL$   E3H$   L$   M;  IFI+HH;rcHG  HD$p3HD$xH$   HQ H$   Ƅ$   HT$xH$    H HD$pHP HL$pHHH$H  I<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
M z HM+IIHIH+IE3I;LCL;ICH$   _L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
wL  HM+IIHIH+IE3I;LCL;ICH$   *_L$   H$   L$   Ht:HH$   IH$8  mt AX$   WD$pE3L$   Lcf,MtM;v
H
K & IHL$p^MH\$xLt$pM;   H$8  (D$`HD$`H;sGHD$`L;w=H|$`I+HH;$   u   HL$p7H\$xLt$pHt5IH,H;$   u   HL$p7H\$xLt$pHt;HH\$xIS= |   H~(DHk8 H
I ۔HcH$   IL$   IH$   H+HHt0LD  A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r} }   DH7 H
7 HcH$  IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;r͈ ~   DF,HF H
gH nHcV,H$   -IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;r
    DF,HE H
G 讒HcV,H$   mIL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rߋ   uoC    HFxH   H   LF0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  
HH$   3   ˆ    HFxH   H   LFHLN0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  詾HH$   X3H$8  HtL$H  L+Iv1A   HyD D;f,`      IcLM+IHD$(D$    DEЏL   L+   IH
D HL$(D$    D袏H   tAYtL$   L+$   IH
GE HL$(D$    D^H$   tn    HC HD$(D$    DE'L   L+   IH
nC HL$(D$    DH   tAYtL$   L+$   IH
D HL$(D$    D赎H$   tA   = f;~(      HcL$   L+$   IH
+D HL$(D$    DJL$   LwB HH   LH$   H+$   HMNM+IHD$0H1 HD$(L1 H
1 v	MFM+IH$   I(LA HH   BLH$   H+$   HMNM+IHD$0H1 HD$(L|1 H
y1 MFM+IH$   I葏XAYtXL$  L+$  IH
1 HL$(D$    DH$  tmAŋN(    ;}AD  ;}AŋN,f;}AD  ;}ւ    Ǆ$      Dl$`L$   HT$`H$   d $   H$   H$       D$`   D$   LD$`H$   HL$h D$hHT$hH$   M;    Dl$`L   HT$`H$   % D$hHT$hH$   
    c D$hDl$`LD$hHT$`H$    D$hHT$hH$       Dl$`L   HT$`HL$p D$hHT$hH$   r    HN`L$   H$   $   H$   H$   CH$   Ht(L$   L+IQ,W$   L$   H$   Ht(L$   L+I,W$   L$   H$  Ht(L$  L+I+W$  L$  H$   Ht(L$   L+I+W$   L$   HT$pHtL$   L+I+H$   HtL$   L+I^+D$   H$   H$   H$   q (H$   HtL$0  L+I
+(L$  I[8Is@A(sA({E(CIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@2 D($h  H^H+HWL$XLt$hHtHHHH;trHHHt3	 H;HD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3 HHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$XHVH+HHL$pW5 D D$   =c  fD/i  Y5 $   fD/  HL$pHHtmH$   H+HH;v H    H=   r<tw HAH;rg H+HsW H'vJ Hy/ HL$0U HL$XI HtqH$   H+HH;v	 H    H=   r=@t HGH;r H+Hs H'v HH. HtlHD$PH+HH;v H    H=   r<tz HCH;rj H+HsZ H'vM HHy. A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI̺(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;v H    H=   r<t HAH;r H+Hs H'v H, HL$0 HL$X HtqH$   H+HH;v H    H=   r=@tm HGH;r] H+HsM H'v@ HHl, HtlHD$PH+HH;v H    H=   r<t HCH;r H+Hs H'v HH+ (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(BHHT$(HPAEHT$(HHHHT$(P HL$(Ht HT$0-LD$8HT$(L+I!H\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHH莝HHT$(HPWD$@Hl$PHT$@H襫HLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$H^LD$PHT$@L+I WD$@Hl$PHL$(Ht.HT$0&LD$8HT$(L+I WD$(Hl$8H[ IIN L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
4LP  L8  L0  D  =J HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn(_ _ ,H
HX HD$@H  HD$PHM H  E3HT$XHL$@ HD$@HcHHz HD@HD$@HcHhT<HD$XHD$0HL$X
 Hu HD$X3HEEHX HL$PfHcHMh HL$PHcQHL$PHHPAHL$PT HH| eHȋ  6    HMx HD$0HO} HL$PeHHu3
H HcHHHD$0HPfAnY^,H HH| SeH (   H HEHL$P0eHX  HHT$@PHD$@HcHH HD@HD$@HcHhT<H. HD$XHL$XO6HL$X HL$` HM HX  L0  HLMHU@HPHIR  H
 HE@HMH     t5Ǚ  u(H@  HD$ LMI* LII;   D  D   H
q1L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  HH$  W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  HL8HL$pHHLxHL$xHHLxH$   H$  d HHL$p?H H$   WH$   ?H H$   H$  H H$  H$  H$  H$  H$    $(  (
Q )$0  W$@  D$H  Ǆ$L      $P  D$X  Ƅ$\   $`  H H$   HT$pH$   菰$8  f/v	$0  $@  f/v؝ f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H H$   H H$  H$   i H$   [ H$   M H$   ? HX H$   HL$p% H$   HtL$   L+I33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHi
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p3HHL$tFW$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   WD$xH$   LLGIH$   HHHL$xHHHXH$   HHHXH$   H$    HHL$xH< H$   WH$   贫H H$P  H$`  H H$X  HD$pH$h  HD$pH$p  < $x  (
̞ )$  W$  $  Ǆ$     f $  $  Ƅ$   $  HF H$   WH$  .L5g L$   L=  L$  HT$xH$   ޫ$X  f/v	$  $`  =- f/vf/v	$  $  $h  Oȉ$  Y
. (U $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   $ L$   L$  H$p   H$`  
 H$  HH) H$   HZ H$X  H$8   H$(   H$   H$    H H$   HL$x H$   HtL$   L+IF33HL$x^ H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  
HH$  	W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   WD$pLLGHH$h  HL8HL$pHHLxHL$xH$h  l HHL$pWH H$   WH$   H H$   H$  H H$   H$  H$  H$  H$  (Z )$   (
{ )$0  D$@  Ǆ$D       $H  D$P  Ƅ$T   W$X  H H$   HT$pH$   B$(  f/v	$(  $0  f/v f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     H H$   Hr H$   H$   | H$   n H$   ` H$   R Hk H$   HL$p8 H$   HtL$   L+I33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHy
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pC	HHL$tVW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   蓹WD$xLLFIH$   RHHHL$xHHHXH$   H$    HHL$xH, H$   VH$   HU H$8  H$H  H^ H$@  HD$pH$P  HD$pH$X  ( )$`  (
 )$p  $  Ǆ$      $  $  Ƅ$   W$  H H$   VH$  aL5r L$   L=# L$  HT$xH$   $8  f/v	$h  $@  =` f/vf/v	$x  $  $H  Oȉ$  Y
a (OK $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   5  L$   L$  H$X  N H$H  @ H$   {HD H$   H H$@  H$(   H$   H$    H$    H H$   HL$x H$   HtL$   L+Iy33HL$x H$   HtL$   L+IGN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3 HHHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHMyg Hq H]HL$x#HEHL$xHMHT$pLL+t
H|G HT$pWEH WEHE    HM肃HHUHPAEHUI2IE HUIP HMHtHUqLEHUL+IH]HMpHEHMHMHULL+tHF EEfEMLHUHM
| D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H    +fDnED^ HMEH   HIP  H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H    b +fn^5 LM(A(xLM(A(h(A(HMH  HEHM L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  [c II耥  L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   Zb HR H$   H$   H$   H$   H$   HT$xLL+t
HKB HT$xW$   H H$   LMH$   H$   H$   VLMHH$   P D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I B +fDnED^ Aƅ    A   YA AExH$   lH$   I,QIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4v +fn^5$ L$   (A(舃L$   (A(t(A(H$    H H$   H$     H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  
HH$  W$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   =WD$pL$   LLFIH$  HL HL$pHHL`HL$xHHL`H$   H$   HHL$pqH H$   VH$   qH H$   H$  H H$  H$  H$  H$  H$    $(  (
 )$0  W$@  = $H  $X  Ǆ$P  
   H H$   HT$pH$   ٓ$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H H$   H. H$  H$    H$    H$    H$   ~ H H$   HL$pd H$   HtL$   L+I33HL$p2 H$   HtL$   L+IN   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pWHHL$tjW$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   触WD$xH$   MLFIH$   HHHL$xHHHXH$   HHHXH$   H$    IHL$xH` H$   VH$  ؎H9 H$`  H$p  H H$h  HD$pH$x  HD$pH$  `{ $  (
 )$  W$  =| $  $  Ǆ$  
   HP H$   VH$  hL=1 L$   L%b L$  HT$xH$  $X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y
]} (K8 $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   9 L$   L$  H$x  B H$h  4 H$   oH H$   H H$h  H$H   H$8   H$    H$   H H$   HL$x H$   HtL$   L+Im33HL$x H$   HtL$   L+I;N   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   !WD$pLLFIH$h  HH     HL$pHHH@    HL$xH$h   HHL$puH H$   VH$   %H H$   H$  H H$   H$  H$  H$  H$  (x| )$   (
z )$0  =w $@  W$P  Ǆ$H  
   Hz H$   HT$pH$   x$8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H H$   H H$   H$    H$    H$    H$   } H H$   HL$pc H$   HtL$   L+I33HL$p1 H$   HtL$   L+IN   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pWHHL$tjW$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   觜WD$xLMFIH$   fHHHL$xHHHXH$   H$    HHL$x H@ H$   AVH$   Hh H$H  L$X  Hq H$P  HD$pH$`  HD$pH$h  (x )$p  (
)v )$  =!s $  W$  Ǆ$  
   H
 H$   AVH$  L= L$   L%; L$  HT$xH$   $8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
~s (l. $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   #H$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$   j
 L$   L$  H$`  c H$P  U H$  萾H! H$   H H$P  H$8   H$(   H$    H$    H H$   HL$x H$   HtL$   L+I33HL$x H$   HtL$   L+I\N   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H詨I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KJ IIp  L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JI HB H$   H$   H$   H$   H$   HT$xLL+t
H;) HT$xW$   H~ H$   LMH$   H$   H$   FhLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^m Aƅ    A   I( AExH$   \hH$   I8IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$f +fn^5m L$   (A(xjL$   (A(dj(A(H$   oH H$   H$   z  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[HWATAUAVAWH  HǀHXHp)pH
 H3H$p  MLL$xL$   H$   HL$@H$  H$   H$  H$   L$  L$  H$   H$   D$0    HHP HHH:P H;+P r
   'HHL$8Ht
l -/H3D$8P   E$HD H
F GIc$HL$`3LD$hIHL$`H+HHt-@ f     HHLD$hIHL$`H+HH;r3L+IMtfHHHD$hHL$`H+HH;rD$8Q   DHUD H
fD FHcHL$Hx3HD$PH|$HH+HHtHHHD$PH|$HH+HH;r3HD$PH+HHtHHHD$PH|$HH+HH;r   5s H
E A;4$   D$8T   HcMFM+IHL$(D$    DIEIL<MEM+E IH
We HL$(D$    DEMu LD$hL+D$`IH
E HL$(D$    DDH|$`ALWMGH$   |>H HDH|$HLt$x.A   Ll$xH*H$   D;8  D$8W   IcH$   L HHI+HHHHHH?H  F;  HCH@IH$   L LpM+I-  AF;!    F;  H[M4Ht$PH+H   F;   LD$`H$   `
  LH$   HL$x5HMIVH$   4
  LH$   H$   \5ATHH$   U<LHH$   25H HDAH|$HH H$   H H$   H$x   D$0   E3H$   H$    H$   HcHH[ H   H$   HcHh   H$   HD$@H$   ߿ HG H$   3H$`  $h  H H$   (   H< H$  H$   ׿L$  H$  LC$  HA HD$ DËF?H H$  Ho H$  H$x   D$0   E3H$  H$  g H$  HcHH3 H  H$  HcHh  H$  HD$@H$   H H$  3H$`  $h  H H$  '   H H$  H$  课L$  H$(  LC$  Ha@ HD$ DË>H H$  HG H$  H$x   D$0   E3H$  H$  ? H$  HcHH H  H$  HcHh  H$  HD$@H$   H H$  3H$`  $h  H H$  &   H H$0  H$  臽L$0  H$H  LC$0  H> HD$ DA<H H$  H H$  H$x  X D$0   E3H$  H$   H$  HcHH H  H$  HcHh  H$  HD$@H$  f Hη H$  3H$`  $h  Hf H$  a%   Hý H$P  H$  ^L$P  H$h  LC$P  HP= HD$ DË;D$8Z   HT$HH|$@Hb HL$HHHtyHD$XH+HH;v H    H=   r<t HAH;r H+Hs H'vu H WD$H3HD$XHL$`HtiHD$pH+HH;v; H    H=   r<t HAH;r H+Hs H'v H! HH$p  H3 L$  I[8Is@A(sIA_A^A]A\_H\$WH@LIL L+	HHBH
 H+HHHD$0H IHD$(膸HK3H+HHt%@ HHHHHHKH+HH;rH\$PH@_HLH L@HPHHSVWATAUAVAWH   Hǀ()pMMLD$p    HE HHHE H;E r
   HH$  Ht
ca $H3Ǆ$  9   H$  DH; H
= <HcHL$@i3LD$HIHL$@H+HHt-@ f     HHLD$HIHL$@H+HH;r3L+IMtfHHHD$HHL$@H+HH;rǄ$  :   H$  DH; H
; *<HcHL$X轒3LD$`IHL$XH+HHt!HHLD$`IHL$XH+HH;r3L+IMtfHHHD$`HL$XH+HH;rǄ$  <   H|$(H$  HD$ MMIH$     HHHH+HLL$HL+L$@IHL$0H0 HD$(L4 H
= 3HD$HHT$@H+HHt,     HHHHHD$HHT$@H+HH;rH$   HtL$   L+I[   L$  5] L=; L: I*;>  Ǆ$  >   HcIMI+M IHHHH?HLD$(D$    DD9H[IE H4L$  MFM+IL|$(D$    DP9M>IMI+M IHHLI?LH: HD$(D$    D9H[IE L4L$  MD$M+$IH
i: HL$(D$    D8I$HD$xLD$`L+D$XIH
V: HL$(D$    D8Ld$XLD$@HVH$   *  LH$p  H$   R*LALH$   .HL$x  IVH$     LH$h  H$   *HH$   3LHH$   D0HH$   KL(H$   !+LHD$xLH$   F-H IDH$  Ǆ$  A   HT$XL$`  Io  HL$XHHt{HD$hH+HH;v˸ H    H=   r<t HAH;r H+Hs H'v H WD$XHD$h    HL$@HtiHD$PH+HH;vF H    H=   r<t* HAH;r H+Hs
 H'v H, I($  H   A_A^A]A\_^[@WHPHD$@H\$hHt$pIHHI@I+ HLJL+
IHD$0H HD$(L H
 蔱H=? HH0H/? H; ? r
0   HHL$`HtHLOL+ILE  3HHH\$hHt$pHP_@SH0HD$     HH0[HWATAUAVAWH  HD$pHXHp)pHq
 H3H$  MMHHL$8L$`  L$h  D$4    D$0   EH6 H
6 5IcHL$X蕠3LD$`IHT$XH+HH      Ht/L@      IHLD$`IHT$XH+HH;r3L+IMtfHHHD$`H+D$XHH;rD$0   EAHT H
6 %5AHcHL$@E3HL$HHHT$@H+HHt&L KIHL$HHHT$@H+HL;rE3HH+HHt.Lfff     KIHL$HHHT$@H+HL;rD$0    H+HHf5 HD$(D$    A   D3HHD$@H   H
L5 A;   D$0"   HcLD$HL+D$@IHL$(D$    D13Ht$@MFM+IH
F5 HL$(D$    D3ItXtHcLD$HL+D$@IH
5 HL$(D$    D2HD$@tHAU    A9  Lt$`HT$X%U D$0(   HcI|$I+<$Hm  G;b  M$H|$HLD$@I+H  G;  Hc  G;  ADA^D(\AL\YL+Is  AF;g  \D$0)   Lt$`IHT$XH+H|G;}XTA;  Ha H$   H H$   H$  4 D$4    E3H$   H$    H$   HcHH H   H$   HcHhT|H$   HD$8H$   E H H$   3H$   $  HE H$   @   H H$  H$   =L$  H$  LC$  H3 HD$ DË-H< H$  Hբ H$  H$   D$4   E3H$  H$  ͯ H$  HcHH H  H$  HcHh|  H$  HD$8H$   H H$  3H$   $  H H$     Hz H$  H$  L$  H$  LC$  H2 HD$ DA,H H$  H H$  H$   D$4   E3H$  H$   H$  HcHHp H  H$  HcHh|  H$  HD$8H$   H\ H$  3H$   $  H H$     HQ H$  H$  L$  H$  LC$  H&1 HD$ DƋ[+H H$  H H$  H$   D$4   E3H$  H$  | H$  HcHHH H  H$  HcHh|  H$  HD$8H$  ̪ H4 H$  3H$   $  H H$     H) H$  H$  ĪL$  H$  LC$  H/ HD$ DË3*Hð H$  H\ H$  H$   D$4   E3H$  H$  T H$  HcHH  H  H$  HcHh|  H$  HD$8H$   H H$  3H$   $  H H$     H H$  H$  蜩L$  H$  LC$  HL HD$ DË)D$0+   HT$XHt$8H0HT$@Ht!LD$PL+IWD$@3HD$PHT$XHtLD$hL+IHH$  H3 L$  I[8Is@A(sIA_A^A]A\_H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtHp 
 uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
 I   LNB	9:3   HII9H3H-U2 HLL%R2 HL=P2 H;1HLH0  HEH?L   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
01  =$1 H
K0 H
1  Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05K f     IM(W Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05QJ f     IM(WO Hv;}(|(t$0Ht$hH\$`MHT$ H`IHHIINHPHHHL$ IVA Hl$pH@A_A^_H   "A)(YJ ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YYJ Y=HJ \A(YI ^X^^A(\AX(YY\U H$   (DsI XD^H (\D H$   A(YA(^WS (YA^A^XX^YWoS AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM1  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHK$HH@  HEHCHEHLL+ty E3EH  D=6Q D5E @ f     H   H HEuIHEI^HGH;t'H;tHs Ht
HHL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHM LMHH   H}HtAXAY
HuLuI~ uA("HHEIHEHEHEHMF/  (A$A(H   YH(  X	f/   fA/r	E   (T
O A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHFܡ D(Y5E A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(A H\$    LMHH	 DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(HY\
 H3H$X  MMHHH$  H\$ HL$0ӞH$0  HD$@H$8  MMHH$0   H$0  HL$0HxH$H  HrTHH$0  H=   r<t HAH;r H+Hs H'v H HtHHT$0HPH$   譜H$   _ H$X  H3 H`  A_A^_^[HL@SVWATAUAVAWH  Hǀp)p)xH[
 H3H$  IH$(  LH$0  H$  H$X  H$   H$`  H|$PA D$ L
! DB H6 H
 
HCHD$ L
2 EE H H
 Ic] W$   Ht3f HzHH$   H$   H$   W($   HL$XHD$XH$   H$   H$   HD$0H$   H$   H$   HHH+HHHE3AH~!f)HH;}$   HL$XLH$    Ic] WD$8Ht3 HyHHD$8HL$8H\$@(|$XH$   H$   H$   HD$XH$   HD$0H$   HD$8H$   HHH+HHHIH~'fD  f)HH;}D$XH$   LH$   ? Ic] W$   Ht3 HxHH$   H$   H$   (|$XH$   H$   H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$   _ Ic] W$  Ht3ٛ HwHH$  H$  H$  (|$XH$   H$   H$   HD$XH$   HD$0H$   H$  H$   HHH+HHHIH~)     f)HH;}D$XH$   LH$    Ic] W$   Ht3 HwHH$   H$   H$   (|$XH$h  H$h  H$   HD$XH$   HD$0H$   H$   H$   HHH+HHHIH~)     f)HH;}D$XH$h  LH$    EDt$4D$   5< I      @      $P  D;  AA}  ~LIL$   fff     H$  M((z HA;u |I      H|$PL$  H$   I"HH$   HH$   HPH$   HHH$   H$   N H$  ؗH$@  H$x  H$  H$  L$   L$   H$   H$x   H$  H$  HXH$  HtHH$  HPIL$   L$    I;sQHcA$   H$   I#I;u*HR HD$(LL$   H H
 VHL$  H$   H$   H$   H$   H$  H$   HD$HH$   H$   H$   L$   IHH+HHHIH~-@ A(fX)HH;}L$  H$   MH$   d LD$8L$   L$   L$@  L$  L$P  HL$8HL$hHD$hH$  H$8  H$  HD$1H$  H$   H$  LT$@IHH+HHHIH~?     A(fAY(fX)HH;}L$P  L$@  HL$hMH$  ) ADd$4H$8  H$8   H|$PE3Dd$4WL$0  H$  H$(  H|$P@fn(T$hH$   H$   H$   H$  HD$hH$  HD$1H$  H$   H$  L$   IHH+HHHIH~.f(f(f^)HH;}D$hH$   H$   T$hHL$8H$   H$   H$  HD$hH$  HD$1H$  HD$8H$  LD$@IHH+HHHIH~,(f(f^)HH;}T$hH$   H$  & HD$8HD$PHL$8H$@  IMH$X  IUH9T$@tA   HL$PH HD$PHHL$hHL$hH$  H$8  H$  HL$1H$  HL$PH$  HpHHH+HHHIH~J    H$X  ()$   H$    H$@  (fYHD$h)HH;|LHH$  C HD$8H$  t$hHL$8H$   H$   H$  HD$hH$  HD$1H$  H$  H$  LD$@IHH+HHH~6     (fB(fXB)IL;}t$hH$   HH$  b H$   H$(  ݳHT$8H$(  KH$   $ H$   H$    HL$8 H$    H$  H3胳 ($  ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
  HMLM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMLMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMfLMHMLEHtHHLMLEHMHHMHHcI;F}!H
0  H
"  WEHE    LEHUI  (HMH   HEH+HH?H;vc H    H=   r<tG HAH;r7 H+Hs' H'v HI WEHE    HMHthHEH+HI;v H    H=   r<tƐ HAH;r H+Hs H'v Hȷ (L\$pI[ Is(I{0Mc8(t$`IA_A^]HL@SVWATAUAVAWH  Hǀp)p)xHEK
 H3H$h  IH$   LH$   H$   H$  H$   H$   H$   A(D$ L
^ DB(Hs H
 /HCHD$ L
o EG(H, H
m 
Ic_(W$   Ht3 HjHH$   H$   H$   W($@  H$   H$   HD$8H$@  HD$@HD$0HD$HH$   HD$PHHH+HHHE3AH~&ff)HH;}$@  H$   LHL$8O Ic_(WD$XLt$hHt?HHHHH;tHtHHHH;tHHHt3| HiHHD$XHL$XH\$`H\$h($   H$@  H$H  H$@  HD$8H$   HD$@HD$0HD$HHD$XHD$PHHH+HHHIH~$f)HH;}$   H$@  LHL$8/ Ic_(WD$pHt3 HhHHD$pHL$pH\$x($   H$@  H$@  HD$8H$   HD$@HD$0HD$HHD$pHD$PHHH+HHHIH~1@ f     f)HH;}$   H$@  LHL$8_ Ic_(W$   Ht3ً HgHH$   H$   H$   ($   H$@  H$@  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$@  LHL$8 Ic_(W$   Ht3 HgHH$   H$   H$   ($   H$  H$  HD$8H$   HD$@HD$0HD$HH$   HD$PHHH+HHHIH~2@ ff     f)HH;}$   H$  LHL$8蟿 EDt$4D$   5, I      @      $  D;  AA( ~GIL$   fff     H$   M((z  HA;w(|I      L$   HT$8I芡HH$   HH$   HPH$   HHH$   HL$8Y H$@  H$  H$(  H$P  H$0  LL$pL$@  H$   H$(   H$@  H$@  HXH$@  *yHtH$   HH$@  HPILL$xLD$pI;sNHcA$@  H$@  I#I;u'Ha HD$(LLD$pH
 H
 FHL$  H$   H$   H$   H$@  H$  H$H  HD$1H$P  H$   H$X  L$   IHH+HHHIH~/fD  (fAX)HH;}L$  H$   MH$@  T AA( c  MfD  MM?  MYICH   A   IHT$`IHL$XHD$pBH$   BYXIRHT$`IHL$XHD$pBH$   BYDXIHT$`IHL$XH$   BDHD$pBYXIRHT$`IHL$XHD$pBH$   BYDXIIM;M;<IHT$`IHL$XH$   BHD$pBYXIM;~IA;_(ADl$4H$  aH$   
E3Dl$4WL$   H$   H$   fn($   H$   H$  H$  HD$8H$   HD$@HD$1HD$HH$   HD$PL$   IHH+HHHIH~/(f(f^)HH;}$   H$  HL$8V $   HL$XH$   HD$`H$   H$   HT$8H$   HT$@HT$1HT$HHT$XHT$PLD$hLIHH+HHHIH~2 (f(f^)HH;}$   H$   HL$8 IIwHT$XL\$`HD$hH$   L$   H$   L$   I;IMLL$@  I   I@H$   LfIMkIL6OLHMIHHH$   fD  (A^XKIII(^DXDDKK(^DXDDJ6I(^DK3IXDDIJ    LH    LIML;$   H$   XL$@  M;}BN   H4   IIHHIHM+(^X  HIIuH$   H$   ԉHT$XH$   貊H$   ˂ H$    HL$p HL$X H$    H$h  H3- ($  ($p  HĐ  A_A^A]A\_^[H   HD$ HH$     HHL$(  H
 HL$(臵 @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@q  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQH g HC(HCH;CuHHCHC H0[@SH H@  Hz HC`H [HL$SH0HD$ HD$P    EtH HAPHSz HA`D$P   J   H˟ HHQ HC(HCPHcHHt HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHO Hz HHGHFHG HF H^(H\$HH HHO0HKHtHPHG8HCHG@HCGHC Hi HHun HHH\$PHt$XH0_H\$WH HHT HHQ3HHHKHB~ Hy HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tH Ht
H1[HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@  IFL\$`I[(HEIF HE HIk0IA^_^@SH H{k HHHj HAhHIH0~ HK8&~ HK ~ HK~ H+s HH [@SH Hw HHHu HA`HIH} HK8} HK } HK} Hr HH [@SH H{g HHHi HAhHIHp} HK8f} HK \} HKR} Hkr HH [@SH H HHHt HA`HIH} HK8} HK | HK| Hr HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3HW(HK(HA   HA    HyrHH  IE3˩HH\$HH0_@SH H  Hu HCPH [HL$SH0HD$ HD$P    EtH>g HA@HCu HAPD$P   J   Hi HH) HCHC@HcHHVm HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHKz H}k HH{3HHDH^H\$HH
} HHOHKHtHPHGHCHGHCG C Hh HH(f HHH\$PHt$XH0_H\$WH H<:  H
t HG`t
h   H觢 HH\$0H _@WH0HD$ H\$@HH0d HHN| HA(HI0HtHP tHC0    H؂ HHKy @t
P   H( HH\$@H0_H\$WH H  HMs HGPt
X   H HH\$0H _@WH0HD$ H\$@HHg HH{ HAHI HtHP tHC     H HHK#y @t
@   Hh HH\$@H0_LH   ICAC    HQHsd ICHxr ICAC   IK{Hf HD$(HX| HD$@HD$hHcHHj HDhHD$hHcHDd    H	 HL$( @SH0HD$ HٹX   | HD$@HSHC  HHtH@@HcHHB@HH0[@SH0HD$ HHe HH{ HAHA@HcPHi HD
@HA@HcPDBDD
<He HHy HAHI HtHP tHC     Hu HHKH0[H%zw @SH0HD$ HHe HHy HAHI HtHP tHC     H HHKH0[H%w HVWAVH`H@HXHhH3
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHK9t HD$(6t HHL$ )tHB    HL$ OHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
b H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHB  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HA  HL$8eHL$(HtHPHtL    HA2HL$XH3 L\$`I[(Ik0IA^_^HVWAVH`H@HXHhH1
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK 4r HD$(1r HHL$ $tHA    HL$ MHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
` H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHA  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2H@  HL$8cHL$(HtHPHtL    HA2HL$XH3  L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH>  (H8Hr HH_(H    H
 HHH
 H;
 rOHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HH
 HHH
 H;
 rHHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   W   ^   ,A;ALǉ   LCHSHH  OgtUHH?        ^,A;ALǉ   Y t    H   H   HH\$PHl$`Ht$hH0A_A^_@SH Hi HHH^` H   Hp  :n H`  -n H  i^H HHe HC`HKHn HK8m HK m HKm Hb HH [Wf/v(      ^   ,;L   H\$WH HHH   HYH   HYH   HH\$0H _XHHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J=  HSHH_HG`LGpHHO`P8LHHO`yHHL$@s(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;v \( (= f/vNHOxf/v?HD$@H;t5HKHT$HD$hC(HKHT$XHK0HT$p]s(HHO`Y  X   w0Hk I$I\$H$   HOGHHHGHCHWHGLL+t W5 At$A|$ HL$p+k HL$X k HL$Hk IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   R   ^   ,A;ALǉ   LCHSHH  [tUHH@I        ^,A;ALǉ   Y
     H   H   HH\$PHl$`Ht$hH0A_A^_@SH Hӈ HHHn H   Hx  i Hh  i H   YHjS HHU HChHKHbi HK8Xi HK Ni HKDi H]^ HH [Wf/v(      ^   ,;L   H\$WH HHH   HqTH   HbTH   HH\$0H _ITHUSVWATAUAVAWHhH(  HE)p)xD)@HR$
 H3HEMILH3t$8F  HSHH_HGhLGxHHOhP8MHHOhHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PD	 DD$XLD$`HL$pLD$xHEHEHT$@HM   HE XC(D$0HHD$0H#H      H;v \( (=	 f/vLH   f/v:HEH;t1HKHUEC(HKHUHK0HU]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM:  HE XC(   w0Hf IE I]H\$0HOBHHHGHCHWHGLL+t W5 AuA} HMf HMf HMf IHMH3蟆 L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   MLGHWHH  ]t8HH6     Y	     H   H   HH\$PHl$`H0A^_^@SH HKZ HHH^ H   Hx  d Hh  d H   TH] HH\ HC`HKHd HK8d HK ~d HKtd HY HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=) H(Vc(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_cH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@@ HL$0b L$   HHH$   ($   HĠ   _zHl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]XF ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3a H=HHkHF@HD$hHFHD$xHv H;t'H;tHa Ht
H=HH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@ HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Yh H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWY H   H	H H$   HD$@H$   H$   H$   H$   < Y H   Wf/v7 f/v   Wf/v   H\$WH HH4  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHJfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H諁HSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   H"HSHt
HHH
HJ$H;Cu
   HHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H薀HSHt
HHH
HB$H;Ku
   HjHCHt0HH   HCH;s;HH;w3H+HH;Cu
   H'HSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    ,  HSI+I^IF`MFpHIN`P8MHIN`HHMHUH   HUHM0HUH   IF`LHUIN`P(HM7HE HMHM(HULL+tHX HM7HEHMHMHULL+t	H. IN(7HD$xIN(HMIV LL+t	H EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      Dk  D
 D% D-  H}WD$hHt3Z H6HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM蒏 DUINxfA/  HEH;   HcuH;st$HKY tH
6HCHC    Hs~LEN    HUHKW EC(Hcu H;s t$HKY tH5HCHC    Hs ~LE N    HUHK HcuHH;s8t$HK0CY tH_5HC0HC0    Hs8~LEN    HUHK0謷 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I.  HEH;  HSHMgC(EHSHMPHM   H   H;t=HKH   +   C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I-  H   H;t=HSH   C(   HSH   fH   HS0V@  A   uf/w(\ (INx3f/v=H   HM8
   EXH   HMHH   HM`f/v\(X(\((XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHM=# HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$hU A   A9   HL$huU Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0We IV(HHL$xT HMT HM T HMT H   T H   T H   T HM`~T HMHtT HM8jT H   \T H   OT H   BT HM7T HM-T HM#T HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   ;LGHWHH   
Et8HH^2     Y     H   H   HH\$PHl$`H0A^_^@SH HV HHH>V H   H  R Hp  R H(  	CH? HH ? HChHKHR HK8R HK R HKR HG HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=9 H(fQ(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_!QH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@P HL$0P L$   HHH$   ($   HĠ   _銼HWH   H@HXHhHp )pIHHz W@Ht3P H,HD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrB  H$   H$   HD$8HD$(HD$@HMHT$8T HL$H P HL$(O L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3O H+HHoIvHH;t'H;tH\O Ht
Hw+HHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   " HIFHD$pHD$x   INHIF@H$   H$   % D$0HT$ LL$pL$   IVP HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   Y H$   \(t$pHĀ   _   LH   H	
 H3H$   HB LB IKICH@D$@ICISISMCMCIC  HD$h H$   H3m HĘ   Wf/v f/v   Wf/v   H\$WH HH+0  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HH78fn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H+oHSHt
HHH
HB$H;Cu
   HnHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HnHSHt
HHH
HJ$H;Cu
   HvnHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HnHSHt
HHH
HB$H;Ku
   HmHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HmHSHt
HHH
HB&H;Cu
   H{mHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w(  HSI諷I^IFhMFxHINhP8MHINhfHHMzHUH   iHUHM0[HUH   JIFhLHUINhP(HM}%HE HMHM(HULL+tHا HMS%HEHMHMHULL+t	H讧 IN((%HD$xIN(HMIV LL+t	H肧 EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      D D D% D- H}WD$hHt3NH Hn$HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM} DUI   fA/  HEH;   HcuH;st$HKkG tH#HCHC    Hs~LEN    HUHKԥ EC(Hcu H;s t$HKG tH.#HCHC    Hs ~LE N    HUHK{ HcuHH;s8t$HK0F tH"HC0HC0    Hs8~LEN    HUHK0) Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I*  HEH;  HSHMC(EHSHMͷHM   H   H;t=HKH   訷   C(HKH   苷HK0H   {Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I)  H   H;t=HSH    C(   HSH   H   HS0Ӷ@  A   uf/w!(\薣 (I   譯f/v=H   HM8臶   EXH   HMHjH   HM`Zf/v\(xX(\(c(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$hC A   A9   HL$hB Hx  D$`A   fn}^HE0H;t1HKHU8蒴EXC(HKHUH{HK0HU`ns(HINhXA   AV0W IV(HHL$xPB HMEB HM :B HM/B H   !B H   B H   B HM`A HMHA HM8A H   A H   A H   A HMA HMA HMA HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQH;E ICH: ICAC   IKH` HD$(HA HD$PHD$xHcHH;5 HDxHD$xHcHDt    H	 HL$(2t @SH0HD$ Hٹh   d HD$@HSH-  HHtH@PHcHHBPHH0[@SH0HD$ HHO_ HH@ HA(HAPHcPH4 HD
PHAPHcPDBDD
LH) HHB HA(HI0HtHP tHC0    HH HHKH0[H%? @SH0HD$ HH) HHA HA(HI0HtHP tHC0    H/H HHKH0[H%4? HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  Da fA/  HGPLG`HHOPP8MHHOPuH轫(HGHLd$ _xLGPHHOHH藫EPHHEPH#H      D H;vA(\  D(ȃ   f/GLcD= D  HD$pH;t2HKHT$xEC(HKHUѯHK0HUįHGPLG`HHOPP8MHHOP胩HsHt$8H~ u(HHD$PHD$0HD$`HL$H* (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$HM* AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$xzEC(HKHUcHK0HUV   H"E HD$03HD$8HD$@Hb HD$HD$PHT$8HL$H; H8 HD$0H	 HL$0o HD HD$03HD$8HD$@Hۅ HD$HD$PHT$8HL$HA; HR8 HD$0HF	 HL$0:o HM; HM; HL$x; L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PH& HA@H4 HAPD$P   _H( HHOH/ HHG@HcPH1 HD:@HG@HcPDBDD:<HSHHDaHH\$HHt$XH0_H(t ?T f/( w* !T f/
 w H
 H(H% H
vq a2 H H
bq M2 H(
  Tp f/ w2
  TJ f/z wH
 H(H x3  H k3  HL$H( LD$0HT$8@T f/ vY:  "   + LD$0HT$8T f/ v%:  "    LD$0HT$8T f/ v9  "   HM
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+HxH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH
*HSHt7HHH
HCH\$0H _H;CuH)HKHtHHHCH\$0H _H\$WH H\t
  H_ HH\$0H _H\$WH HgU HHHX/ HA`HIHj7 HO8`7 HO V7 HOL7 He, Ht
   HP_ HH\$0H _H\$WH H<t
  H_ HH\$0H _H\$WH H  HHH(# HAhHIH6 HO86 HO 6 HO6 H+ Ht
   H^ HH\$0H _H\$WH HLt
  HR^ HH\$0H _H\$WH H/ HHH- HA`HIH5 HO85 HO 5 HO5 H* Ht
   H] HH\$0H _H\$WH H|t
  H] HH\$0H _H\$WH Hw" HHH! HAhHIH*5 HO8 5 HO 5 HO5 H%* Ht
   H] HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PH  HA@H. HAPD$P   HO" HHOH7 HHG@HcPH& HD:@HG@HcPDBDD:<HSHHD~HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt3{1 H
HEH]WEHt3V1 Hv
HEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軼(HM/ HM/ (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9Hx]Y] \ Y   X Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`   EWfA.z  D
# fA/  HG`LGpHHO`P8MHHO`7s(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      D H;vA(\^ 迌 D(   f/GHcD% HD$`H;t3HKHT$h蒟EC(HKHT$xzHK0HUmHG`LGpHHO`P8MHHO`,s(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$hhEC(HKHT$xPHK0HUC   H5 HD$H3HD$PHD$XHOv HD$8D$@HT$PHL$8+ H( HD$HH	 HL$H~_ H4 HD$H3HD$PHD$XHu HD$8D$@HT$PHL$8.+ H?( HD$HH3	 HL$H'_ HM+ HL$x+ HL$h+ L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pH	 H3H$P  HHHL$0)   H"p HL$@ؐH($) H$0  HL$0'LHHAPH$H  HrUHH$0  H=   r<tw+ HAH;rg+ H+HsW+ H'vJ+ HyR H$   'H$   =) H$P  H3J H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   Wf/vH0   Xb (z H0  X  H;t/HSHNoHC(HF(HSHNZHS0HN0MLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h' HHEHsH   HCH;t'H;tH' Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h[  H       D  HY(WEHt3& HHEH] = } H  H[WEHt3& HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hW[    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0)}H  L@LEWEMt3'% HMFHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMY H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\((Xu \(XuuHUH(  HEf/w"\{ (H   Hx莎f/vHE0H;tHU0HsWEH]HHt3o# HLHEH]LEHuHEHEHEHEH;t-I4# HtHOLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHMK LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   &HM! HM! HM`! HMH! HM8! HM! HM! L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9HY \ Y   X Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH	 H3HELHHyHHL$@c   EWfA.z\  D
 fA/H  HFhLFxHHNhP8MHHNhw(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      Dl H;vA(D\ w~ (   fD/GLcD fHD$@H;t5HOHT$HHD$hG(HOHT$X/HO0HT$p!HFhLFxHHNhP8MHHNhLGI@H_@HEDELEH]LEHEHEHUHM虞  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM;  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H軏D$hG(HOHT$X袏HO0HT$p蔏   H`& HE3HEHEHg HD$0D$8HUHL$0 H HEH	 HMP H& HE3HEHEH"g HD$0D$8HUHL$0 H HEH	 HMP HL$p
 HL$X HL$H HMH3= L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pHu	 H3H$P  HHHL$0   Ha HL$@8H( H$0  HL$0:LHHAPH$H  HrUHH$0  H=   r<t HAH;r H+Hs H'v HC H$   H$    H$P  H3=< H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
O (  \f/   vƇ   \H(  f/v(\nH(  X \(UXH(   Wf/vH0   X¼ (x H0  X  H;t/HSHNϋHC(HF(HSHN躋HS0HN0譋LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hB  HMHLHT$hP(HH   HHHHPHKHHHSHL$h
 HHEHsH   HCH;t'H;tH Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h軖  H       D  HY(WEHt3$ HDHEH] =t } H  H[WEHt3 HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hL    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt3 HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMWK H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(l(Xu \Y(XuuHUH(  HyEf/w"\s (H   Hf/vHE0H;tHU0HWEH]HHt3 HLHEH]LEHuHEHEHEHEH;t-I HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM諤 LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM_  LML   H   H   1HM< HM1 HM`& HMH HM8 HM HM L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH HAPH HA`D$P   Ho1 HHO(H HHGPHcPH HD:PHGPHcPDBDD:LHS(HHD\HH\$HHt$XH0_HL$HH LL$P)t$0LD$X3)|$ t5< =l Tf/    LL$PLD$X3>Tf/   Y LL$PLD$X3Tf/   k LL$PLD$X3Tf/    LL$PLD$X3̽Tf/    LL$PLD$X3覽Tf/ws(t$0(|$ HHHY H
0H  HY H
H  HY H
H  HY H
G  HoY H
G  H[Y H
G  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	8 Ht
HSHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@  IVHO   L\$`HI[Is I{(IA^H\$WH HW HHA`HIHd HO8Z HO P HOF H_ Ht
   HJ7 HH\$0H _H\$WH Hw HHAhHIH HO8 HO  HO H Ht
   H6 HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	q Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@I  H\$xHH$   H`_@SH0HD$     HHd  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH
 Ht
H*HL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ Պ  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8"z (fo IHFHMEHEUHMHME0HuMH] E H](M@fo
 fEPU`Mp  Xf/FvFHHI;L$8  IHN 踔  ID~DHN0LN@HLF0A   HV 
  H$@  FDHAD~HH   A_A^_^]sH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _
 HH
 HH}
 H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMHk HHEHE   HE    E A   H3@ HM5HE0   HE(    E ; uE3IIB< uHHM5HEP   HEH    E8 A   H HM8^53fff     H}H;   H+H   HHuH}HCuHH   LǺ%   H HH   :
- uH:
" uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
T* A   HHMb0H)IE3HUHM89A   H HM87IHMXө  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H HH    :M uC:B uC:7 u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM/IIE3HUHM87HE8H}PHCE8H
b HL$03HL$8HL$@HD$HD$PHT$8HL$H Hx
 HD$0HT$0HM% HHL$`w H	 HL$`9 HUAVAWHhH@  HD$XHXHpHx H		 H3HE8L=[ HLEHE   E3LuDuEF"HA HM52HE0   Lu(DuEFH! HM2A@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH    :M uC:B uC:7 uAtH+HHHsHEH}HCEH+Ht+HD$    L
' A   HHM-H(IE3HUHM5A   HӇ HM^4A? tI@ IC<7 uMIHM74HEH}0HCEH

 HL$03HL$8HL$@HD$HD$PHT$8HL$H H HD$0HT$0HM] HHL$` HP{	 HL$`t7 @SH0W)t$ f/Ȼ   (vW5M (b e (,t
Xʃ\
(\(f/
 v\(Y
 (bb fnY(t$ YH0[Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v(a W   fD.z  f.zv  D)T$ D֥ fA/L  D
 fA/r4D ff     AX(ya fA/XsD(E\n
 eH%X      HЋ9
   X5 A(AYAY((Y
 (Y
 Y
9
 XY
 XY
 X

 YYYX%
 X%
 X
~
 AYYYX
 X
~
 X(Y~
 AYX~
 YX~
 YXX
p~
 ^YY5p X  D& fD/v(E` E(\D(AXl
 eH%X   ' f/ƹ   HЋ   9S
 h  A(A(AYAY((Y
 (Y
 Y
z
 X
 X
 X
R
 YYYX
 X
 X

 AYYYXa
 X
 X(Y

 X
 YXօ
 AYX^YY% X   9
 )  EYDW A(AY((Yl
 (YY
 Y
x
 XA
 X1
 X
x
 YYYX
 X
x
 AYYX(Yx
 X
ex
 XՁ
 Xmx
 YXQx
 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
n
 ! =b
 () H
N
 (
 <
 ( N
  N
 ( 
 
 (
1 ){
 (s )
{
 (
U ){
 )
{
 ! UH
އ
 ]! =҇
 (ͬ H
 (
 H
 ( Z
 r Z
 ( 
,
 (
է 
  
 (
x 
 
 p  H
d
   =X
 ( H
D
 (
! 

 ( 
 ( 

 (
w xv
  
Yv
 (
Z zv
 
cv
  IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
 A(.  \ f.zu"   !     W f/   (LW Hh((Y(T
O fD/vlY
x  f/vVfA.zu3(H       $   H$      Ew fn "   Y! S   ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ Z f.(   u~ f/vpH      $   H$   H#H;  fA/s(tZ (f/;   
 f/  ,H Y<Z  l f/v: f/vJ =  "   D^D\
 AY  H$   }D6 D(DX
 YE\A(Y 
/ Yf/   AYf/wBAYA(\5 (Y (A(Y Y (^^Yf/vvfA.zu3*H       $   H$      EËO fn "   Y (A\A((Y (A(X ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   HB H
4 s L$   HB H
cD s H\$D$WH`)t$PI)|$@H(D)D$0? f/ro(AX f.z  (m(Wf/˦ WvWc X D(E3(LHqD\(W D\   f/vfWf.z0  U (
j Tf/vW D(DW@    [ ^\ TuW D(   ~ f/v$((\r \
 (
  D(of/=| r!Z f/v(d  W D(DHL$po{ W D((XÛ \+ V \ \= YDXH\$xA(D(D$0(t$P(|$@H`_LD$pHҡ H
   LD$pH) H
   H(Y LL$0LD$83#(T
 f/
 w
Y H(H3@ H
. o  H(Y LL$0LD$8ã(T
 f/
 w
Y H(H? H
d.   H\$D$WH`)t$PI)|$@HD)D$0(DV D)L$ A(EWfD/   `U f.zZ   f/ru(LW H((fY(T
 fD/vY
 Y f/  W ^fA.    A(  fD/v ff     ^AXfD/wt$p(T f.(   u~˙ f/vpH      $   H$   H#H;  fA/s(=T (f/   
 f/x  ,HQ Y<   5 f/v* f/Z  D^D\g AY   HL$pswD
 D(DX YE\A(S 
 Yf/vVAYf/  AYA(\5 (S (A(_S 5 (^^Yf/v&   A\A((DS (A( S ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pHv H
 R  H  H
   LD$pH< H
. m LD$pH< H
q> m H. H
U   HȠ H
A   H H
-   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3C HcHD$(Hl$0HT$(H茝  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"H Ht
HHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H Ht
HHH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;tZHtHHHH;tYHHHHGH;t"Hi Ht
HHH    H_H_HHL$8 HL$(/ H$   H`A_A^A]A\_^]@SH Hby  HH [@SH0HD$     zx  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIRM7MwMwLuI*HH/WD$@HD$P    E3E3HT$@H芒L\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uH8HHF)L;t$HV! HHVHH~H$`  H$P  HHHI$I$H;uIT$H;uH藤I$ID$'H;t"LIT$! HIT$HjI\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W-J 3MtlA(Y5ώ (Y=Ď D(D\D
: D HfE/v((+ AYA((XI IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  袩LLD$XHT$pHHH
L;   IH   IW%MIOI+H*HHHH?HH;v HRHH=   r=Atp I@I;r` L+IsP I'vC LIo I?IIHIHCIGHCIGH;H{H{HL$pH   HT$x[H$   LD$pI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'vs LI H$   HtwH$   H+HH?H;v5 H    H=   r<t HAH;r	 H+Hs H'v H HL$XHttHD$hH+HHH;v H    H=   r<t HAH;r H+Hs{ H'vn H H   HT$HHvHD$PH+HHH;v- HH=   r=@t HEH;r H+Hs H'v HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWATAUAVAWH  HǀpHXHp)p)xD)@D)HHL5" EWE(W8HǀH    HPLXHǀ`    Hǀh    H
HBH+HHucH HD$p3HD$xH$   H! H$   Ƅ$   HT$xH$   0 HA HD$pH-! HL$psHǄ$H     $   HBH+HHwcH9 HD$p3HD$xH$   H! H$   Ƅ$   HT$xH$    H HD$pH  HL$p   H$H  AD$hW$   E3L$   McgxIMt*M;v
H
'  IH$   0L$   E3H$   L$   fD  M;  HFH+HH;rcH8 HD$p3HD$xH$   H
  H$   Ƅ$   HT$xH$    H HD$pH HL$pHHH$H  H<|$`HD$`H;   HD$`L;   H\$`I+HI;uIH+HHsoI+HIH+Hs
H
 k HM+IIHIH+IE3I;LCL;ICH$   .L$   H$   L$   H   IH   I;uIH+HHsoI+HIH+Hs
H
h  HM+IIHIH+IE3I;LCL;ICH$   .L$   H$   L$   Ht:HH$   IH$8  DXYC AX$   WD$pE3AL$   IcG,H$   Ht/I;v
H
  HHL$pz-H$   H$   MH\$xHt$pL;  H$8  W(D$`HD$`H;   HD$`H;   Lt$`L+IH;uwHH+HHsgH+HIH+Hs
H
 a HSH+HHHIH+HE3H;LCL;ICHL$p,H$   H\$xHt$pHt8JH/H;u!   HL$p(H$   H\$xHt$pHt;HH\$xIH$   X
 |   I(DH H
1 @cHcH$    E3AL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rW
 }   DH H
 bHcH$  ?IL$  IH$  H+HHt+LA4HL$  IH$  H+HH;rIL+IMt#f4HH$  H+$  HH;r-W
 ~   EG,H H
 aIcW,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rmV
    EG,HV H
 aIcW,H$   IL$   IH$   H+HHt2L    A4HL$   IH$   H+HH;rIL+IMt*f     4HH$   H+$   HH;rA   uoU
    IGxI   I   MG0H|$@HD$8HL$0HT$(LD$ L$   LD$hH$   H$8  iHH$   8   *U
    IGxI   I   MGHMO0H|$HHD$@HL$8HT$0LD$(LL$ L$   LD$hH$   H$8  HH$   H$8  HtL$H  L+IA   L-      E;g,W  tT
    IcLL+ILl$(D$    DE'^M   M+   IH
r HL$(D$    D]I   tYtL$   L+$   IH
 HL$(D$    D]H$   tS
    Ll$(D$    DE]M   M+   IH
 HL$(D$    DX]I   tYtL$   L+$   IH
 HL$(D$    D]H$   tA   L-  = A;(|  R
    HcL$   L+$   IH
 HL$(D$    D\L$   L HI   HH$   H+$   HLNL+IHD$0Ll$(LW  H
T  LFL+IH$   Hl^(L^ HI   裐HH$   H+$   HLNL+IHD$0Ll$(L H
 dLFL+IH$   H]XAYtXL$  L+$  IH
 HL$(D$    Dz[H$  tzE3AAO(;}A;}AAO,;}AD  ;}FQ
    Ǆ$      Dt$`L$   HT$`H$   ԍ  $   H$   H$   P
    D$`   D$   LD$`H$   HL$h腍  D$hHT$hH$   P
    Dt$`M   HT$`H$   蕎  D$hHT$hH$   }kP
    | D$hDt$`LD$hHT$`H$   i  D$hHT$hH$   1P
    Dt$`M   HT$`HL$p茑  D$hHT$hH$   O
    IO`L$   H$  a  $   H$   H$   H$   Ht(L$   L+IW$   L$   H$   Ht(L$   L+IW$   L$   H$  Ht(L$  L+IWW$  L$  H$   Ht(L$   L+I"W$   L$   HT$pHtL$   L+IH$   HtL$   L+ID$   H$   H$   ~H$   W  (H$   HtL$0  L+I}(L$  I[8Is@A(sA({E(CE(KIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHHVH+HL$   IJ3HFH+HH   $   D(DXL%HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;v H    H=   r<t HAH;r H+Hs H'v H L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHL"(W$   LKL+IL$   IIGMH$   HD$ MH$   IbHSH+HHL$PWD$8HD$H    LCHHL$8,3HKH+HHT$8H  L5v HIL43 HBX@ LL$PMHT$8I43HCH+HHl$PHtvMH# YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8LH -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;vF H    H=   r<t* HBH;r H+Hs
 H'v HH) HtmHD$`H+HH;v H    H=   r=@t HEH;r H+Hs H'v HH (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  H0	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@:HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
 5 HQM+IIHL+IHM;HCH;HCHL$@HL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
8  HQM+IIHL+IHM;HCH;HCHL$@HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   
LFLL$`I{`  H$  H$   UHXH$  HtINHH$   PHt$hH\$`H~&Hfff     HHL$@袼HcH;|IHHT$@PH$  H$   H!H$  H$   HL$` HT$@HtLD$PL+IUH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H詫I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  KM  IIL$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   JL  HB H$   H$   H$   H$   H$   HT$xLL+t
H;, HT$xW$   H~ H$   LMH$   H$   H$   FkLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^p Aƅ    A   I+ A   H$   YkH$   I蹯IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI!c +fn^5p L$   (A(umL$   (A(am(A(H$   
rH H$   H$   w  H$P  H3
 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I~ Ht
H虦I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  ;H  II萚L$   H$   H$   L$   WD$xHt3 H豥HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   :G  H2 H$   H$   ݤH$   H$   H$   HT$xLL+t
H+' HT$xW$   Hn H$   LMH$   H$   H$   6fLMHH$   0 D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I" +fDnED^k Aƅ    A   9& A   H$   IfH$   I	IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIS +fn^5k L$   (A(ehL$   (A(Qh(A(H$   lH H$   H$   g  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"In Ht
H艡I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  +C  IIL$   H$   H$   L$   WD$xHt3 H衠HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   *B  H" H$   H$   ͟H$   H$   H$   HT$xLL+t
H" HT$xW$   H^ H$   LMH$   蛿H$   H$   &aLMHH$     D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^f Aƅ    A   )! A   H$   9aH$   I虥IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIC +fn^5e L$   (A(UcL$   (A(Ac(A(H$   gH H$   H$   W  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH|	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I^ Ht
HyI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  >  IIpL$   H$   H$   L$   WD$xHt3q H葛HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   =  H H$   H$   轚H$   H$   H$   HT$xLL+t
H HT$xW$   HN H$   LMH$   苺H$   H$   \LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^a Aƅ    A    A   H$   )\H$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI3 +fn^5` L$   (A(E^L$   (A(1^(A(H$   bHż H$   H$   G  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
 L HSHHCHHHHKLHT$`HL$X[  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
9  HHHGHHH_LHT$`HL$X  HGH\$hH@_@SH0HD$     ?  HH0[HWATAUAVAWHp  HǀHXHp)pHGv	 H3H$P  MLD$XHH$   H$  H$   L$  D$0    HB
 HHHB
 H;B
 r
   HHL$8Ht
^ !H3D$8   EE H> H
> 	:IcU HL$h蛐3LD$pIHL$hH+HHt HHLD$pIHL$hH+HH;r3L+IMtHHHD$pHL$hH+HH;rD$8   EE AHg H
= q9AE HcHL$@E3HT$HHHL$@H+HHt!JIHT$HHHL$@H+HL;rE3HH+HHt.@ ff     JIHT$HHHL$@H+HL;rD$8    H+HH< HD$(D$    A   D7HHD$@H   H5T= H
E= A;]    D$8"   HcMD$M+$IHL$(D$    Dz7I$L<LD$HL+D$@IHt$(D$    DO7HD$@L4HcLD$HL+IH< HD$(D$    D7H|$@MGIVH$   (H HD3HD$X   5Z H HD$XA;M   D$8(   DyIcH|$HHT$@H+H  G;  HLHcكw  G;l  HHL$   I6I~H+H  G;  H|$pLt$hI+H  G;  H$   *L(H$   ,HLD$XLH$   z,LHH$   .H IDD$8)   H|$pHL$hH+H|&G;}LAMHT$XHL$`s'AHL H$   H H$   H$X   D$0    E3H$   H$   ݴ H$   HcHH H   H$   HcHh   H$   H$   H$   * H H$   3H$@  $H  H* H$   %   H H$  H$   "L$  H$  LC$  HT; HD$ DË1H! H$  H H$  H$X   D$0   E3H$  H$   H$  HcHH~ H  H$  HcHh  H$  HD$`H$   Hj H$  3H$@  $H  H H$     H_ H$  H$  L$  H$  LC$  H|9 HD$ DËi0H H$  H H$  H$X  ̲ D$0   E3H$  H$   H$  HcHHV H  H$  HcHh  H$  HD$`H$  گ HB H$  3H$@  $H  H H$     H7 H$  H$  үL$  H$  LC$  HHa HD$ DËA/Hѵ H$  Hj H$  H$X   D$0   E3H$  H$  b H$  HcHH. H  H$  HcHh  H$  HD$`H$   H H$  3H$@  $H  H H$     H H$  H$  誮L$  H$(  LC$  H6 HD$ DË.H H$  HB H$  H$X  | D$0   E3H$  H$  : H$  HcHH H  H$  HcHh  H$  HD$`H$   H H$  3H$@  $H  H H$     H H$0  H$  肭L$0  H$H  LC$0  H5 HD$ DË,D$8+   HT$hH$   HHT$@Ht!LD$PL+IWD$@3HD$PHT$hHtLD$xL+IHH$P  H3y L$p  I[8Is@A(sIA_A^A]A\_@SH`HD$XMHH
AD$0HD$0II#I      I;v#H HD$ LH>^ H
'^ *fAnT$0HD$0I#I;u'H HD$ L
 H^ H
] ǬA*H HD$ L
 MH] H
] 薬Wd$8LD$8LD$@HT$HfnEQ ^I\Y(YYP (\Y\d$8HHL$8k2  HH`[@SUVWATAVAWH   HD$8)$   )|$pIIHLLBH
IH+H  W(3DHI      HtZ    J@D$0HD$0I#I;tIIH+HL;r#H HD$(LH] H
\   fnE D$0HD$0I#H
\ I;u#HC HD$ L
 LH\ f/w#H HD$ L
 LH\ {hD$0HD$0I#I;u#H HD$ L
 LH\ EhLLH\ 貦HGH+HA   I;IFEI;LGHHL$@S(BO ^HMtwLA%Y HcIQfnE \(T(Y\f.zuAf/AGfnYHL$@\HI;r(IHL$@w.  HL$@ GH4
 HHH4
 H;4
 r
   HHL$0Ht
WH3II($   (|$pHĐ   A_A^A\_^][@SH`HD$XMHH
AD$0HD$0II#I      I;v#H HD$ LH6[ H
[ fAnT$0HD$0I#I;u'H HD$ L
 H[ H
Z 跨AWf/w*H HD$ L
m MHZ H
Z fd$8HD$8HD$@HT$H9M ^I\Y(YYL (\Y\d$8HHL$8_.  HH`[HVWATAVAWH   HD$@HXHh)pIMLLHBH+H  Iy   WL  fAn$$   H      H$   H#H;u*H HD$ L
N MH,Z H
Z `3DHOHt>HIcf/v
IL;r#H' HD$(LHY H
Y tgH|$0Me  IHL$`$InI+.H   H;HFHWH;HFHL$H,HHt$HH9_v&H
K fHc(^HH;OrHtcIJ     HcHIfAn$\Y(YY\YHD$`\HH;r(IHL$`*  HtLD$XL+IHHL$`1 JH0
 HHH0
 H;0
 r
   /HH$   Ht
WH3IIL$   I[0Ik@A(sIA_A^A\_^HSUVWATAUAVAWH   HD$H)p)xMMLHLZHML+I  IXILL+Ir  W3DIH      MtdIff     BD$0HD$0I#H;wIIH+HL;r#H HD$(MHW H
W   LIMtW@ J@D$0HD$0H#H;tIHH+HL;r#Hi HD$(MHW H
cW   I$@f/w#H HD$ MHpW H
1W ,H|$@LD$0LT$8HD$0HL$8M;HCHLMHkW H
V ߟLMH:W H
V ƟIHL$X!t$xHD$xH$   L$   I/I_H+HM>IFI+HH;HFظ   H;HFI$@=&H ^K (Htr%}G D  HcT I\PY(Y\(Y\(YHD$XX(Y\H$   XHH;r(HHL$P%  HL$X GH-
 HHH-
 H;y-
 r
   HHL$@Ht
WH3H>H($   ($   H   A_A^A]A\_^][LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHNwHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHH.HH|$`HHH0_^[H\$Ht$WH I-  HHX f@  Ht4HH3HC   Hs@3Hs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	A_  IB  H1H;>u=IP Iő  H$   HD$(LAII_  I  H;uAH^HK I  H$   HD$(LE3IIf_  I  IP IB   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK IǐtCHCIIπx H$   HD$(tLE3^  I   LA^  I   IHO q   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS It=HGIIπx H$   HD$(tLE3]  I6LA]  I&H$   HD$ MHT$8I`  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I*  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3HHs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aaa  IB  H1H;>u=IP Ie  H$   HD$(LAIIa  I  H;uAH^HK I  H$   HD$(LE3II`  I  IP I   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK IgtCHCIIπx H$   HD$(tLE3`  I   LA`  I   IHO    H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS I行t=HGIIπx H$   HD$(tLE3R_  I6LAB_  I&H$   HD$ MHT$8Ia  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HH0H H|$`H HH\$XH0A^_^@WH0HD$ H\$XH&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@WH0HD$ H\$XHd&  HHD$@f@  HH HL$HHL$PHt	H	 HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS- HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSHW HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH' HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     wHH0[L$D$HXH      )t$@D$x(HD$xH#)|$0(H;t`D$xHHD$xH#H;woWf/   L$`HD$`H#H;   I
  Y(t$@X(|$0HXH| L
= HD$ LD$`H H
 RH  L
 HD$ LD$`H H
 RH L
 HD$ LD$hH H
 RH L
 HD$ LD$hH H
a TRHHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(DC A\D)xD)hD)XD)H(D)8ATD   f/  L   WD88 D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXY8 ^A(\AY(Y\u fE/(vWB (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y56 A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"H Ht
HpHH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@/  H   MMH9?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"Hw Ht
HoHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@  H   MMHk8L|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HE:(H   A] (YH   Xf/wXfA/sQH   (AT W? f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
	 I   LNB	9J
   HII9H3H-e
 HLL%b
 HL=`
 H;1HLH0  HEHDL   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
@
 蓱 =4
 H
[
 H

  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-zD)@HD!, Ip     D)HI   D
?* D)PD)* D)XEWD)d$@D%I+ D)l$0D-6 D)t$ D5* )pغ   H  W4   H*AYff        H  WHH*X(AYH5rԺ   HW  WH*LcXEFLcAYB BY f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zB  B fA/B  (\\YXr*((B\ Y\YYX\(((B\ Y\YYX\fD/&fD/w(YAYAW f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=) H%  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLLJ I^WD$(Ht3 H7bLHD$(L|$(H\$03HcI;^}UI4H
 HHH
 H;z
 r
   HH$   Ht
(~HILD$(H$   IM   H$   HCH$   HI~I;|$t!I$W HtHraI$I4$I|$H      ?HCH=
 H

 H9

 t	H
  HH+
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|I  L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH 3H$   HH$   HH$   HWn H$   HLCL+H$   n A   E3H$   HL$0 HD$0HcHHD$0HȺ    HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQDuHL$0 u2HL$0` H$   A HL$0A H$   " 2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H  HD$(H;wH
H\$ H;vHH+HH=   HH  H\$@Ht$HH0_@SH HHHSH
 H3H
HJHH 3HC HC(HC0H6p C8HH}m HCHH [@SH0HD$     	  HH0[LL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHTHHH|$PH0_^[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$XY  HL$8( 3($   H   [HIH% H%~ H\$WH Hc~ t
h   H聧 HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    H
 LHH
 H

 H;rHLH
 H
q
 HHHl
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH
 HH0H
 H;
 r
0   HH\$`Ht!(HHj HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    H
 LHH
 H;
 rHQLH
 HHH
 H;
 rH)HH
 3LCIHI+HHt2f     I HIHLCI@I+ HH;rHg
 3H9S~-L3ff     JH9HIHcH;C|H2
 HH0H$
 H;
 r
0   HH\$`Ht!(HHi HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHH}
 LHHo
 H`
 H;r   LHO
 H@
 HHH:
 H;r
   HHKHIHHH

 HH0H

 H;

 r
0   `HH\$PHt%(HHg HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$Ht$WH0H3HRH\$ H+HQHGH+HHt&D  HHHHHHGH+HH;rH\$@HHt$HH0_H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfoj' (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   & II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %&& ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PHCc HA@HHq HAPD$P   OHe HHOH){ HHG@HcPHWi HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH+{ HAPHp HA`D$P   H HHO(Hw HHGPHcPH/k HD:PHGPHcPDBDD:LHS(HHDQHH\$HHt$XH0_H\$WH HH4 HHQ3HHHKHBu Hp HHCHGHC H\$0HG 3HG0HG8HG@H` GHHHd HG(HH _H\$WH HHH;Qt>H	u HtHV  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   腙 LHtHHHtHHIHHtHHIH [HL$H(G LD$0HT$8p{T" f/ wU LD$0HT$8H{Ta" f/ wA LD$0HT$8 {T9" f/i w-H(H H
 l  Hw H
 l  Hc H
l l  LVWATAWHh  HQ0	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  z7E3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XA	AX
	AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ 5L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3詑 Hh  A_A\_^HWH   H@HXHhHpIIHIPHH[3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`H-Hl$PH\$HH+HH;ntH p Ht
H;LHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;vp H    H=   r<ttp HAH;rdp H+HsTp H'vGp Hv HHtmHD$XH+HH;vp H    H=   r<to HCH;ro H+Hso H'vo HH HL$`HtiHD$pH+HH;vo H    H=   r<to HAH;rto H+Hsdo H'vWo H膖 L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHHt3m HIHHkHsC  IH!h  HH\$`Hl$hH0A^_^@USVWATAWH$H  HY)	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  = WD f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HEH  HE H  IH B<L;~  HH+HNHfoU T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
 foLu@MH  EhL  E   M  E  fo
 f      h  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&i  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfo
 IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   #  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  )2 LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@9  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3΃ H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     b  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  H	 H3HExMH HHEH- HHEHE   HE    E 8 uE3IIB<  uHHM薍HE0   HE(    E ; uE3I IB< uHHMZHEP   HEH    E8 A   H HM8/3@      H}H;   H+H   HHuH}HCuHH   LǺ%   H_ HH   :
] uH:
R uH:
G u3tH+HHHsHEH}HCEH+Ht+HD$    L
, A   HHM2H)IE3HUHM8A   H4 HM8IHMX`  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H^ HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8蟏HE8H}PHCE8H
2g HL$03HL$8HL$@HD$HD$PHT$8HL$H] HHb HD$0HT$0HM_  HHL$`G`  H HL$`茑 @WH@  HD$(H$P  HHD$     HL$@~\   HL$0[ LD$PMcHHL$PIHPHL$P[ HHL$@ZH$   ZH$   ~\ HH$P  H@  _Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v( W
   fD.z  f.zv  D)T$ D fA/L  D
 fA/r4D ff     AX(艻 fA/XsD(E\-	 eH%X      HЋ9	   X5 A(AYAY((Y	 (Y	 Y
Y	 Xa	 Xa	 X
1	 YYYX-	 X-	 X
	 AYYYX 	 X
	 X(Y	 AYX	 YX	 YXX
	 ^YY5 X  D6 fD/v(U E(\D(AX	 eH%X   7 f/ƹ   HЋ   9	 h  A(A(AYAY((Yu	 (Yr	 Y
	 XJ	 XJ	 X
Z	 YYYX	 X	 X
&	 AYYYX	 X
	 X(Y	 X	 YX	 AYX^YY% X   9~	 )  EYDW A(AY((Y	 (Y	 Y
	 X	 X	 X
	 YYYX	 X
	 AYYX(Y	 X
]	 XU	 Xe	 YXI	 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
	 	| =	 (9  H
	 (
 D	 ( V	  V	 ( 
(	 (
A )	 ( )
	 (
e )	 )
	 { UH
	 m{ =	 ( H
	 (
 	 ( 	  	 ( 
	 (
 	  
	 (
 	 
	 z H
H	 z =<	 ( H
(	 (
1 	 ( 	 (% 
~	 (
 p	  
Q	 (
j r	 
[	 y IHHh  HD$X)p)x((Wf.zu( YL   f.z  f.
 z0u.(W _((_YY59 (L  f/
 rT=x (_.  (Z  HrDJ  J ȃw_H\ H(+[     (~\     ((螰     (]     ($     (^     H#_ HD$03HD$8HD$@H+ HD$HD$PHT$8HL$HU HL HD$0HT$0H$   諲  H
c HH(H
Ƞ HH0@8B  HH$   m  HHL$`  H HL$`D ($P  ($@  Hh  ÐM Z g w   HUVATAUAVAWHxHX  Li3ILLDM   
r HXH      ?HxI)p)x=E D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E   S  IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C莇  H;}&f        HE(f)HH;|LHMHT  LM@L  HH  HM` MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL     MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@覷  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMHa  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  xr  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH       9r @   @   H
J HHxHHH\$PH0_HT$WH0HD$ H\$PHHH       q @   @   H
@ HHxHHH\$PH0_HxHD$8)t$`)|$PD)D$@9|$0HD$0II#I      I;v*H HD$ L
 LH H
L fDnEDD$0HD$0I#I;u*H HD$ L
 LH H
 JA 'H HD$ L
t H H
 Jfn5P ^u A\Yf	 WX\YY= \((t$`(|$PD(D$@Hx@SUVWAVH`HD$8)t$P)|$@ILHHHIH+HH  W3DI      HtQfff     BD$0HD$0I#I;t
IL;r#H HD$(LH? H
  諈  fAnD$0HD$0I#I;u*Hg HD$ L
# MH	 H
 5If/w*H HD$ L
 LH H
 D$0HD$0I#I;u*H HD$ L
 LH H
i TLLH H
O DH/HGH+H   H;HFH;HG=U ^z (HtJfAn	 %  (X(\HcL \TY\HH;r(W(t$P(|$@H`A^_^][HH   H@)p)xD)@D)H9xH@II#I      I;v*H HD$ L
x LH H
 fDn
EDL$0HD$0I#I;u*Ht HD$ L
0 LH H
o BGA EWfA/w'H" HD$ L
 Hw H
8 5 ^ A\Y
	 AX\YY= \((t$p(|$`D(D$PD(L$@HĈ   HHPHHUVWATAUAVAWH   HD$@HX)p)xMLLLYLII+H  M@M  W3DHH      HtlH@      C$   H$   H#H;wIII+HL;r#H HD$(MH H
h   fAn$$   H$   H#H;u*H HD$ L
\ MHB H
 nELMt@IfIcf/v
IM;r#H9 HD$(MH H
 Lt$0MHm  I_I+H   H;HFIVH;HFH$   HL$hD2IVHL$P52HLl$hHl$PI9vvZM>HML+= Hc(A^AA薥 HH[I;~rH$   L$   L$   HtjMfAn$HIH+L	 % @      HcA\YY(X(\1Y\HHH;rHtLD$`L+IHfMtLD$xM+IIf(WL$   I[PA(sA({IA_A^A]A\_^]@SUVWATAVAWH`HD$8)t$P)|$@MLLHHyH+HH  MINI+HH  W3DI      HtVIfD  BD$0HD$0I#I;w
IL;r#H} HD$(MH H
    LHtHfCD$0HD$0I#I;t
IL;r#H} HD$(MH  H
  諁  A$f/w*H_} HD$ L
3} MH  H
r  H;HBLMH  H
Q  4>LMH  H
8  >I7IH+HI.IFH+HH;HF   H;HFA$= ^ˢ (HtQ	  @ f     Hc\L Y(X(\YY\HH;r(W(t$P(|$@H`A_A^A\_^][H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
 HDH H;HBL<LH LH
r H\$@H0_si  @SH HALHH$I$IHH;r6H|$0H|$XHO@HO 3Hj H
 `@ H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMt: uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I-t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@OHN .Hnf I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@NHO 5.He H
. ; H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtj uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I(t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN )Ha I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	%8 Ht
H@HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@IVHOKb  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ Hݼ H+H= H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/L L+L
 L+A:tA:	uHr:IuL L+L
 L+    B:tB:	uHr@-tH      < @-tH        D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;tHIHKH;tHn- Ht
H	HL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}fo5 UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMA  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHMa*    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5_  e    HG(Hx tL   LHH%\  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vHHE HHuxL4    I   w2IFHHH;wHHHŀ H+HD$`HHHE 1I>( HE HuMt裑HILuXE3L9?LDL  Lx  H  H    H=     I;vLHGHEHu`H    H   w2HCHHH;wHHH H+HD$`HHHEHz' HEHuHtߐ3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX= 5 MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  I.HUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  H@HHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  L  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} H#HHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t    t	I H  H3@ H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    H HuHuH\$ H(RL@SH Hr	  H3 HCPH [HL$SH0HD$ HD$P    EtH	 HA@H HAPD$P   J   Hc
 HHq HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH& HHQ3HHBHK< H! HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C Hb HH HHH\$PHt$XH0_@SH H  H HCPH [HL$SH0HD$ HD$P    EtH~ HA@H HAPD$P   J   H HH HCHC@HcHH& HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH>% HHQ3HHBHK HM  HH{3HHDH^H\$HHM HHOHKHtHPHGHCHGHCG C H HH HHH\$PHt$XH0_HIH% H\$WH H|  H= HGPt
X   HC HH\$0H _@WH0HD$ H\$@HH` HH~ HAHI HtHP tHC     H$ HHK @t
@   HXC HH\$@H0_H\$WH H  H} HGPt
X   HC HH\$0H _@WH0HD$ H\$@HH HH HAHI HtHP tHC     HH# HHKS @t
@   HB HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJdHHHFHGHHFLL+tx H_H\$HHN.HHHFHCHVHFLL+tx HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$HT$H8IE3IPH+HHtHII      @ f     H@D$HHD$HI#I;wIHL;rH8H-Q H HD$(H
 V  3HIHtH   H LH   ICAC    HQHs ICHx ICAC   IK;H HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H HL$(K @SH0HD$ HٹX   |; HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH HH
 HAHA@HcPHZ
 HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     Hu HHKH0[H%z @SH0HD$ HH HH HAHI HtHP tHC     H HHKH0[H% LH   ICAC    HQH ICH ICAC   IKH HD$(H  HD$@HD$hHcHHk
 HDhHD$hHcHDd    HN HL$("I @SH0HD$ HٹX   9 HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HH7 HHE HAHA@HcPH HD
@HA@HcPDBDD
<H
 HH HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HHw
 HH HAHI HtHP tHC     H HHKH0[H%$ HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A   U H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH H HHt
   9 HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H
 HAPD$P   H' HHOHI HHG@HcPH HD:@HG@HcPDBDD:<HSHHDZHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHS HA@HX	 HAPD$P   H HHOH	 HHG@HcPH? HD:@HG@HcPDBDD:<HSHHD!ZHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vxHHMHHumJ    H   w2HCHHH;wHHHf H+HL$`HHHM*H( HHEHuHtwH3H9HDHEXH   L   J    H=      M;vEwLnMu_J    H   w.HCHHH;wHHHe H+Ll$`IIH{
 LHuHtvHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HW3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIK  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H0     t
HMX H   H3+ H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3
 HHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xU?  HIHD$hHD$p   INIHD$xH$   ] D$0HT$ LL$hLD$xIV  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v%c HA    (|$@D(L$ H`[ HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    vw A    A   A((T T f/vOA^)t$P5. (YXdg fE/
 vW^3YWs(t$PJD^A(AYX۪ g fD/ vW
< ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H H3HE8H HHEL=8 HLEHE   E3LuDuD80uE
IIF84 uHHM3HE0   Lu(E A   H HM3IH}H;   H+H   HHuH}HCuHH   LǺ%   HV HH    :ݍ uC:ҍ uC:Ǎ uAtH+HHHsHEH}HCEH+Ht+HD$    L
( A   HHM.H(IE3HUHMT7A   Hc HM5A? tI@ IC<7 uMIHM5HEH}0HCEH
 HL$03HL$8HL$@HD$HD$PHT$8HL$H' H	 HD$0HT$0HM  HHL$`?  H| HL$`9 @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH		 Mt
I$HL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH Mt
IHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ cLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8q  (fo IHCHMEHEUHMHME0H]MH} E H}(M@fo
R fEPU`Mp;Xf/CvCHIH;HC  l  H$0  HL$H  HADc$L$@  H   A_A]^[]kk@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4C  H;}. HD$8HHD$ (HD$ )HH;|LHL$PHՏ  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1H&HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@^   HL$0u LD$PMcHHL$PIHPHL$P HHL$@H$   H$   ^ HH$P  H@  _@SH HHHSH
 H3H
HJHHs 3HC HC(HC0H C8HH HCHH [@SH0HD$     O  HH0[@SH HHHSH
a H3H
HJHH 3HC HC(HC0H~ C8HH] HCHH [@SH0HD$     JN  HH0[H(((T
 f/
? v6f/
U rWf/   . H([ \ H( f/v(H((Y((Y%ܝ (Y
ɝ (Y X%> Y֝ X
& XV YXB YX% YX
z YYY\\\% X YY- ^X(H(H6 H
4 73L(DIDAf     A0
 f/sffA;uDA  f/sffA;uDAHkAHAR HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DYf A(Z D
ܝ (E(A(Y=	 A(»   EY(D(T
p f/
    A(AYY (A(Y% YXf;vM- (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_HC H
1 QHHXWH   )pA)xfD)@(D)H(D)PD(D fD)X   D(D)`DYD((DYYE^Y؞ DW
0 uX Y= L$   L$   3D(DY(DYt ((T
ڦ f/
    Yl WA^(Xf;v.ffnYA(EY\AYXf;rDY) A(W Y L$   I[(|$pE(CE(KE(SE([E(cYA(sI_HA H
0 H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
 EYW=Υ (A\AYYQ V YWA(Y	 (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PY L@D)XD((D(Tݤ f/
    DYn )|$`D)D$PD A(A\EX(A(U E\Wf.EYD(DY" zt1AYAYY= A^(U AYY D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxH? H
. H   eH%X   
b	 )t$pWA   D)T$0D(HB9~	   fA/vDW fD.zu֘ (t$pD(T$0HĈ   c fA/rfA(L$   AYH,n	 H
Uy	 $   /v  %}	 (Y%L A(|	 AX\\
	 Y  D)\$ Do fE/rz0 L$   A(Ho	 AYH
p	 Y
 \$   ot  %}	 (Y% A(`|	 AX\\
	 Y(  % E^)|$`A(D)D$PAYD)L$@f/   D((DY
t	 Yz	 DX
t	 Xz	 DYYDX
bt	 Xy	 DYYDX
@t	 Xy	 DYYDX
t	 Xy	 DYYDX
s	 X|y	 D^   s	 (^D((DYfDXs	 DYDXfDYDXs	 DYDXfDYDX
y	 YfXy	 YXfYXx	 YXfYXD^f/   D((DYqy	 Yu	 DXXy	 Xxu	 DYYDX6y	 XVu	 DYYDXy	 X4u	 DYYDXx	 Xu	 DYYDXx	 Xt	 D^   x	 ^D((DYfDXx	 DYDXfDYDXx	 DYDXfDYDXt	 YfX~t	 YXfYXst	 YXfYXD^A()Q (A(P (A(Q -i (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
'z	 n =z	 g( H
z	 (
 u	 ( u	  
t	 (
՝ u	 (֜ 
i	 (
 i	 ( 
i	 (
 )l	 (ޛ )
l	 (
  )l	 (b )
l	 (
 )-k	 ( )
/k	 (
ș )1k	 (ڛ )
3k	 (
\ ep	 ( 
gp	 (
 ip	 (B 
u	 (
 u	 ( 
u	 (
h 9v	 (j 
;v	 (
, =v	 (Κ 
7r	 (
 9r	 A 
:r	 
 "w	 B 
:w	 
 x	 R 
Zy	 
" Bx	 5:h	 
*z	  rH   eH%X   
>[	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D% B9x	   fE.E(DTƜ zu	A(   fA/)|$prnA(L$   AYHem	 H
k	 $   Xo  %x	 (Y%u A(A(X5v	 \AY\
4x	 YY9  D)T$@D fE/rnA(L$   AYH9r	 H
s	 $   m  %|x	 (Y% A(A(X	x	 \AY\
Hx	 YY   E^)$   A(AY$   A(M (A(L (L$   H-j	 H
Vn	 An  (L$   (AYHp	 XH
g	 Yn  \YXA(L Y ($   D^AYD(T$@fE/vY= ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
v	  =v	 (g H
|v	 (
ɘ i	 (ۖ ,i	  

i	 (
~ i	 ( 
0k	 (
 2k	 ( 
4k	 (
u ).q	 ( )
0q	 (
9 )2q	 ( )
4q	 (
- )&p	 (/ )
(p	 (
A )*p	 ( )
,p	 (
ś e	 (w 
e	 (
ɛ e	 ( 
o	 (
= o	 (/ 
 o	 (
 Zl	 ( 
\l	 (
 ^l	 (7 
 h	 (
) h	  
h	 
k r	 ۏ 
;u	 
 ku	  
t	 
S cu	 Di	 Dd	 D%pn	 Dk	 D%g	 
&u	 u
 D$H   eH%X   
V	 )|$`= A   HD)T$0D(B9t	   WfA/	  fD.z(	  Ѝ fA/)t$pD)D$P  A(E(^2r	 EYVI (A(fA/X(Y^%    A(A(Yc	 Yp	 Xnc	 Xvp	 AYAYXLc	 XTp	 AYAYX*c	 X2p	 AYAYXc	 Xp	 AYAYXb	 Xo	 ^   b	 A^((YfXb	 YXfYXb	 YXfYXo	 YfXo	 YXfYX|o	 YXfYX^r	 A(Y \p	 AX\/q	 YYX  ^ fA/   A(AY$   A(^Mr	 ~G (A((XL$   Hk	 H
?d	 Y^- h  %r	 (Y%ۉ A(q	 AX\\
r	 YYX  D)\$ D fE/   A(AY$   A(^Mp	 F (A(T(XL$   Hf	 H
Wn	 Y^- f  %.q	 (Y%# A(o	 AX\\
o	 YYX  E^D)L$@A(AYf/   D((DY
wk	 Ygg	 DX
^k	 XNg	 DYYDX
<k	 X,g	 DYYDX
k	 X
g	 DYYDX
j	 Xf	 DYYDX
j	 Xf	 D^   j	 (^D((DYfDXj	 DYDXfDYDXj	 DYDXfDYDXTf	 YfXQf	 YXfYXFf	 YXfYXD^f/   D((DYg	 Yc	 DXg	 Xc	 DYYDXg	 Xc	 DYYDX~g	 Xfc	 DYYDX\g	 XDc	 DYYDX:g	 X"c	 D^   !g	 ^D((DYfDXg	 DYDXfDYDXg	 DYDXfDYDXb	 YfXb	 YXfYXb	 YXfYXD^A(C (A(kC (A(C ۆ (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
n	  =n	 R( (
 (]	 ( :]	 (; ,j	 (ݓ 
]	 (
/ _	 (! 
i	 (
S _	  
i	 (
f _	 ( 
`_	 (
i f	 ( 
e	 (
 )i	 ( 
 f	 (
1 )i	 (s )
i	 (
 )^b	 ( )
i	 (
 )bb	 ( )
Db	 (
 f	 (? )
Hb	 (
q g	 (s 
f	 (
Ս b	 ( 
b	 (
) bd	 ( 
b	 (
} fd	 ( 
Hd	 (
A *`	 ڄ 
`	 (
Ċ i	  

`	 
} j	  
k	 
- Mj	 U 
k	 
E k	 =d	 
l	 
E H
k	  
>k	 &j	  L$   H H
ެ Ha H
ʬ D$HxeH%X   
L	 )t$`W)|$P(A   HD)T$ Dփ B9j	 >  f/~  \ f/D)D$@   (Y$   (^Yj	 ? (((XL$   H[	 H
4_	 Y^-Ѓ `  %g	 D(Y% (i	 X\\
g	 Y^DYDX^  D)L$0D
& fD/   (Y$   (^Hg	 > ((X(XL$   HZ	 H
Y	 Y^- ]  %*h	 D(Y%V (f	 X\\
sg	 Y^DYDX   D^A(AY$   (m> ((>> (L$   H`	 H
1f	 _  D(L$   (EYH`	 \H
&^	 DY|_  XYD\(> Y D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
5h	  =)h	 ( H
h	 (
 +]	 (ԉ =]	 ݃ =]	 ( 
]	 (
H Y	 (j 
{Y	 (
 )5X	 ( 
Y	 (
 )9X	  )
X	 (
 ;X	 ( )
X	 (
f )X	 (h )
X	 (
 )X	 (L )
X	 (
n \	 (P 
\	 (
 3_	 (Č 
\	 (
 7_	 (h 
_	 (
 Sd	 (, 
5d	 (
N ]	 ( 
9d	 (
 ^	 3 
]	 
 f	 < 
,d	 
d~ $d	 L 
,d	 
 $e	 DX	 DW	 5[	 Dq^	 5c	 D]	 
Xd	   xL$   H/ H
h zHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H'  HH   [A(f.-[~ LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((YV| Y
N| (\f/~ vY} H(((H(6  H\$WH0IXHT$(I+HD$ H|$pHHD$(    HOHHL$ H
8 HDH H;HBLLH\ LH
 H\$@H0_   @SUVWHx  HD$8H\ H3H$`  IIHHM;H   HL$@H HL$P?HHk HHy >HH* >HH >HH >H$@  HL$@HCHD$0H$@  H$X  HC$@  HD$ L
] LD$0HH譃H$`  H3,  Hx  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
b  HMrLM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMSLMHELEHtHHLMLEHEHHEHHcI;N}!H
 W H
 I WEHE    LMLEIIRHMH   HEH+HH?H;v H    H=   r<t HAH;r H+Hs H'v H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;rr H+Hsb H'vU H  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	 Ht
H)HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@RH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHH4  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHHr 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3Q HqHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM获  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HMQ5  L;}:@      HMHEBEffYfBXB)IL;|LHHM5  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIK!H$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLGA  HL$hW HL$pL L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH,  HC   HkH{rHH  HHH H H;t    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AIk# AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  (q I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@SUVWAVAWHh  HD$8H~ H3H$P  IMHLH$  D$0    H HD$@H$    D$0   E3E3HT$HHL$@ HD$@HcHH׮ HD@HD$@HcHDxDD<   HL$HHHL$@((HH (HHUl HH 'H$0  HL$@KID$0H$0  H$H  HC$0  Ht$ L
n LD$0I}@SUVWAVAWHh  HD$8H} H3H$P  IMHLH$  D$0    HR HD$@H$    D$0   E3E3HT$HHL$@X HD$@HcHH HD@HD$@HcHDxDD<   HL$HvHHL$@&HH &HHU HH &H$0  HL$@IHHT$0H$0  H$H  HC$0  Ht$ LD$0IbLD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H  HS HCPH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   J   H HH HCHC@HcHH. HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK\ H HH{3HHDH^H\$HHݼ HHOHKHtHPHGHCHGHCG C Hj HH HHH\$PHt$XH0_@SH HHHSH
! H3H
HJHH H HHH [H\$WH H,
  H HGPt
X   H7  HH\$0H _@WH0HD$ H\$@HH HH޻ HAHI HtHP tHC     Hh HHKs @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HH HH5 HAHI HtHP tHC     H HHKH0[H%İ LH   ICAC    HQH3 ICH8 ICAC   IKkH, HD$(H HD$@HD$hHcHHK HDhHD$hHcHDd    H) HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HHo HHM HAHA@HcPH HD
@HA@HcPDBDD
<Hu HH HAHI HtHP tHC     H5 HHKH0[H%: @SH0HD$ HH HHE HAHI HtHP tHC     HϷ HHKH0[H%Ԯ DD$HL$WH0HD$ H\$HHt$XHH3t$PH3 HA@H8 HAPD$P   HG HHOHi HHG@HcPHס HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHs HA@Hx HAPD$P   ϏH HHOH HHG@HcPH_ HD:@HG@HcPDBDD:<HSHHDAHH\$HHt$XH0_@WH0HD$ H\$@HH0 HH^ HAHI HtHP tHC     H HHK @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH3 HA@H8 HAPD$P   oH/ HHOH	 HHG@HcPHO HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upHg H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3 HǇHH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HM{AwI_ HSHH;vYHHumH    H=   w9H   HHH;w
HHH	 H+HL$@HH$L<    I~ HHuMtHCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
I HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
I f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CTH;}D$`HD$Hf)HH;|LHL$ H#	  (YX f/ArWU AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
! H3H
HJHH 3HC HC(HC0H C8HH= HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
yH D)PD(D)XD(DYD)`E(D)l$ D((DYYE^YJ S Y=G L$   L$   3D(DY(DYRG Q((T
R f/
I    YJG H    H WA^(Y5G X    AYHDXA\EYAY(YXHuDYI A( YF L$   A({E(CE(KE(SE([E(cD(l$ YA(sIHP H
 茜HHXHpWH   )pH52)x3D)@WD)HD(D)PD(EY{
D)XD(DF DYDYI ff     A(Y3  AX(AY Y3 H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
 H3H
HJHH 3HC HC(HC0H C8HHŤ HCHH [%G (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-JD)@HD1B Ip     D)HI   D
B D)PDC D)XD)d$PEWD)l$@E(D-D D)t$0D5hN D)|$ D=A )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcB  XY5XB Y  f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/z   B B  (\YX(\\Y\fD/v\(YX\fD/w(AW f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5: MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  Hc HCPH [HL$SH0HD$ HD$P    EtH HA@H# HAPD$P   J   H+ HH~ HCHC@HcHH^ HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHHޛ HHQ3HHBHKl H HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H HHP HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3ѿH~ H|$HHS H[eHS8HO|HH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3AH~ H|$HHS H|HS8HO{HH\$PHt$XH0_H\$WH H,  H͊ HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfoS> TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %= II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   (= ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQHcz ICHh ICAC   IKHl HD$(Hy HD$@HD$hHcHH~ HDhHD$hHcHDd    HN HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH HH5y HAHA@HcPH} HD
@HA@HcPDBDD
<H HHۏ HAHI HtHP tHC     He HHKH0[H%j H\$Hl$VHA3: HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PHcw HA@Hh HAPD$P   H_w HHOH9 HHG@HcPH HD:@HG@HcPDBDD:<HSHHD1HH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHv HA@H HAPD$P   H HHOH1v HHG@HcPHz HD:@HG@HcPDBDD:<HSHHDqHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   HbF H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vSHHMHHumJ    H   w2HCHHH;wHHH H+HL$`HHHM*Hx HHEHuHtH3H9HDHEXH   L   J    H=      M;vLnMu_J    H   w.HCHHH;wHHHN H+Ll$`IIHˈ LHuHt1HM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HG3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpIIHP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   aKHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMXl H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  HA H3HExMH[c HHEHuc HHEHE   HE    E 8 uE3IIB<  uHHMHE0   HE(    E ; uE3I IB< uHHMʱHEP   HEH    E8 A   Hc HM8蟱3@      H}H;   H+H   HHuH}HCuHH   LǺ%   HV HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHM袬H)IE3HUHM8UA   H< HM8IHMX3LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H& HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM\IIE3HUHM8HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H Hhl HD$0HT$0HM%HHL$`wH HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[A$ f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^A{# f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^AK" f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0Ho: H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHHg H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	I} HM H3.  H]`HuhH}p(u0He@A_A^]HS} HHXHOHLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3| HXHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$ !{ L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3z HVHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$ x L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D%| HxEW@      IL$LkM4$Hfo HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D= HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  ( C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;tHIHt3k H5GHLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  H% H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   DL   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;v@IHU`HtLmH4    H   w.HFHHH;wIHH H+Ll$`II*Hgh LHuHtHU`IHuX3HIDH   H  H  H    H=     M;v}HUhHtL_J    H   w.HCHHH;wIHH1 H+Ld$`II Hg LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   I(3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   IO&LEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   *HIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HdHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
Ize    tH   ce HM`Xe HMhNe H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKWLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH:HL$@Bd HL$HL$   I[Is A(sI_H%d H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	ua Ht
H=HHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;ta Ht
H:=HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"H_ Ht
H;HH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^DD$HL$WH0HD$ H\$HHt$XHH3t$PHJ HA@HX HAPD$P   H| HHOHJ HHG@HcPHN HD:@HG@HcPDBDD:<HSHHDQHH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     Af AfYD HH;|Ld$PH;}3IGHp HhIL0 0 YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"HK Ht
H(HH    H|$0HsH\$8H ^ LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0H H3HE MLHAp AY1LIIM;vH9HHuzJ    H=   w2J   HHH;wHHH襌 H+H|$0HH8J    H4 HHuHt耝HIHFE3EL96LDL}HEH    H=   @@uIM0I;v.MM(MufH    H=   w2H   HHH;wHHH H+LL$0II$H    HY3 LHuHt远IE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
I
3 @t	I2 HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;tIIHOH;tH>0 Ht
HYHH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}foG UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HM
/    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$8c    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht3- H
HD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%- @UHPHl$ HE H]@HuHH}PHr H3HE HHLBHL;vŖL
MumJ    H=   w9J   HHH;w
HHHu H+LL$ II$J<    H, LHuHtPHC3H9;IDH    H=   LFHHN1   t	H, HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5& MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDX(YLXA(YD
XX

A(YL
YDXA(YL
X(YDXXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+A((YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YX(YLXA(AYD XXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;t6HtHtIHHH;tLLMt#3 ILHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;t蜈HII;t$I HtH9HEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHMosHMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM" HM HM
 H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$I HtHIE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4COI;} D$XHEf)HI;|LHL$ IOIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CNI;}D$XHEf)HI;|LHL$ IuNMIIII+L;  L@MtHHIL;  IMIH
HWE3LL9G~L
? L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]虀@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH  x L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   foӥ f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G/5H;}%ff     EHD$@f)HH;|MHL$XH4HEPLM LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHNEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI  2 LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5Ο )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4G.H;}EHEf)HH;|MHL$PH. L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;t\HHHt3 H=HHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3> H^HD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$ . L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3 HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%H Ht
HHL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfo~ IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI HfoK IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMEI~ p    RL   L   IH!   H  A_A^[]PLWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK;H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLC1HL$h HL$p L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H  H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	H\ H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHHE= H+HL$@HH	H HHHNNAVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+`	HcAH+2HcAH+hHcAH+LHcAH+HPLHcAH+2HcAH+
HcAH+Ho(HHcAH+diHcAH+HPHcAH+xHcAH+SHcAH+HwHcAH+HPdH;(HcAH+ܠHHcAH+HcAH+HcAH+,
HcAH+HP|PHHcAH+HhH(OgHcAH+ H7PH4H_HcAH+hHcAH+H`fH(HcAH+HPH({?HcAH+RHcAH+HPHcAH+HP,gHsHcAH+HcAH+HcAH+<H(3fH(WH[HcAH+HcAH+HPl&HcAH+HPLHsHfH(?HWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtHHE HHXH:E H [% % % %t %f %X %J %< %. %  % % %~ %p ff     H;
A uHfuHS  H\$Ht$WH E3H
D   m  H
 $ HH   H H H! HH H. HH HHtnHtiHtdH%`D  H
  H
ID H @   ?+HH3HH3H=1D H2D H
O   ^  H\$03Ht$8H _E3E33AQR HC Hu     ̹   {  H(H
C  H
C Ht H(@SH HH
dC ~ # H
TC  H [   @SH HH
4C N  H
!C I s eH%X   A   LЋX CV H [h   @SH HH
B  ; u4d      ;teH%X   
H A   Hȋ AH
B H [H% @SH H
B Hu0H˘ H3B ?HH  H
mB HH [H H
]B H [H% H\$Ht$WH 3H9=6B u8He H3,B ?HH>  DHA H
A Ӆ3H
A ' H
A E35 H
A  H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
pA u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
d@ H(%  u#  H(H(3%  H(  @SH W@ ɻ   DÈG@ 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
? u
  t2zH
? a
  gH I¹@   ?+ȰIL3LELEELEMa? LELEELE
Y? MU? 
]? H\$PH@]ù     HLMZ  f9uyHcDHH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuHZ> H [@SH =>  tu(  !  H [@SH H3 HًH3> ?HHu
H  HH
=   3ɅHDHH [H(HH(]  @SH HS HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@=<  t
   r  <    tg	  H
	  5	  H
>	  P	  Hm H
V 
  u)0t H5 H
 ]
  g<    @2@N	  HH8 t$H2tHH?  Lƺ   I`<    H\$0Ht$8H|$HH A^H\$Ht$WH @,< 3ۅ3Pȉ< =@D$8=; t
   K  J; o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9; 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH H) IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH%q @SH H3W HF P HȺ	 H [H%D HL$H8   	  t   )H
w:    HD$8H^; HD$8HH: HG; H9 HD$@H: 9 	 9    9       Hk H
9 H      Hk H
. HL    HkH
! HL H
  H8@SVWH@H/ H   3E3HT$`H Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$  ǃ|H@_^[H\$UH$@H  ٹ     t)%=  HM3A    HM H   H  HE3o Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 36 H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T    HD$PHD$@HEHD$H3 HL$@ u
!< H$  H  ]@SH HHH
 HHS3H
HJHHl  H HHH [3HAH HAH HHH HH  H\$WH H HHH  t
   HHH\$0H _HHHL$ H?K HL$   HHHL$ ZHD HL$   H\$H|$UHH e 33<    D)    cAMDDDAentiAineIAntelEDD; AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
 A%?D9; = t(=` t!=p t wH     HsAD: Eu  ` rAD:    UDM;|$3E]MU]	sAD: Asn        AsSAsL3H HHUHE$<u2؊ Ǌ    E  t      H\$83H|$@H ]̸   39 H\$ UHH He H2-+  HM H;uoHM HEHE H1E HM H1E E HMH H3E H3EH3H  H#H3-+  H;HDHى H\$HHH҉ H ]H(uH=S  uS    H(H
A9 H%B H
19   H59 H59 H(HHH(HW H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _%* % % % % %$ %& %( %* %, %6 % %j %l %> %0 %" % % % % % % % 33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D%5x D)xEWY5l fA.zuT=x D\   D)$P  (Tw (T
w D(f/D)$0  D)$  EYv
D(^^D((fE.Dl zuA('YAX(( L   (H   AYfE.D($  z.u,fA/w	Dn (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0舿L(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3̅tH H H H H H H(H H9A   LAIHH3H+H.MtAHIHEH(3HIHEH(IIw;HWB< HAIHHH(ËAIHHHH(H(H% H\$0
 HHuHH\$0H(HH|$ Q H+Hu
HSHR0H\$0HH|$ H(         @SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
^ H9Ht6H HH [<    HuH
 Hk? H	 HH [@SH0HAH      t-H
0 L)@ LH   H	? u/HH0[H
{ LH@LH@ HD$ H	 H+u
HCHP03H0[E3H;
n AAH;
& H;
l AAuH% H\$WH HHHIH H;t6
 u,LHT$0H HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _@SH H=R     He D  C
HKt1{ t 0HSLCHMtE3  
HSH HKHHCHHt= HtH(H{ u3H [ÃH [H\$ UVWAVAWH   H~ H3H$  ILL4 HH1  HO H/Hu
HWHR0H  I HH   HHb H.Hu
HVHR0H+u
HSHR0H   HG    |H
 H; MMH	\ tHG H;vBHl$0L< HD$(HL$@MLt$     E3HT$@3 x.HJtH
& H< Hl$(MMHD$ H	 H/uHGH
H+u
HCHP03H$  H3H$h  H   A_A^_^]@SH  HHuH [HH|$0 H+Hu
HSHR0HH|$0H [H(  H| H3H$  A   D$    L HL$4AQ  L    LHL$0 D$08D$4u%D$28D$6u3H$  H3+H(  HD$0   HD$(LL$4HX: L: HD$ HL$@q A   HT$@3 H$  H3H(  H(H'  H H
'4 Hp H1 K HuH+ H(HH
5   Hy+ HuH(3H(H(=D     H
6 Z Hu13 H
F H6 A   H	8 y/H(H   JD    HHtH(uH@P0H
6  Ht$HK   HtH(uHPHR03H() 3H(   H\$WH0H HH   LZ H4 H2    L+* H3 H    LH3 H xoLm5 H3 H xTLHD$     LH
4    Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0HD H
 Hn3 A   H	 yH/u
HGHP03HH\$@H0_@SH HQHLIMtIHD$XAt 3ɉKpHK@HKHHK HK(HK0HK8HtH HCXHD$PHtH HCPHD$`HtH HKhHHC` HH [H\$Hl$Ht$H|$ AVH@H
o( IH5m4 HH-2 L50  HtHt$0LHl$(HHLt$ H\$PHl$XHt$`H|$hH@A^H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
 HB1 H	 H(HAXHHD H H(LHt4HB      t$HIPHIPPHt
H)uHAP03H(H
1 H0 H	 H(HAPHHD H @SH yp H   Hl$0Ht$8H|$@Lt$H HHhPHpXLp`3HGPHGXHG`9CpuHt3H  HHu. HtH8 
H(uH@P0MLHH8I  Lt$HH|$@Ht$8Hl$0H [@SH H H{8 t	H {p |H H1 u HL H$   HH [H%ż H [H\$WH H3HIHtH{H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HKhHtH{hH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _LI[WHP3HIC H ICA   ICHICHIC ICEAICIC u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0yt HHYHHt!H
 H, H	 3H0_][Ht$PHt  HH t$xL I;t5HB    }      @t3Hg
  IH tetaHH  H+u
HSHR0HOHHtHGH    H)uHAP0   3Hd  HHt$PH0_][   GtHHCH;." u(HD$pHLL$hLD$`t$(HD$ H'  L   H~' MtA HH   H+u
HCHP0H
 H	ʸ uHt$PGt3H0_][. HOHHtHGH    H)uHAP0Gt LD$hHHT$`*=  3Hp  HHu' H9XPuH
m E3E3HHH!D  HHt$PH0_][HT$pHHt LL$hHLD$`HD$      H.Hu
HFHP0Gt H+u
HCHP0Hu7H  HHu' H9hPuH
ɶ E3E3HHH}C  HHt$PH0_][H\$WH yt HHYHt$H
 H;) H	 3H\$8H _HtIHHHt$0  HOHHtHGH    H)uHQR0H+u
HCHP0Ht$0uH
 H	/ 3H  Ht4H(u
HPHR0H
A H( H	y 3H\$8H _F Ht*L HH  M H]	  # Hh H\$8H HY H _@SH HHIH{t tH
 H' H	޶ 3H [Ht4CtHAH; u   Ct Hu!HH [  Hζ HH [  H [H\$Hl$Ht$ AVH H 3HLH9BuHHH      AtHHBHn" H|$0L   MtAb HHu%H
 H	" u	Hյ  '3H2 H/Hu
HGHP0HDH|$0AFt HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIH{t tH
 H_& H	> 3H [HtKCtHAH;J u H;J u   LH" 3  Ct HuDHP   H  HHu'` H9XPuH
 E3E3HHH?  HH [H\$WH 3HHIHHD$0HtHGHH)uHAP0 HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu' H9XPuH
G E3E3HHH>  HH [H\$VH ApHHمu2Ht-H;ݳ t$H
̵ H$ H	 3H\$8H ^Ãu"HtH
 H	 3H\$8H ^H|$0ݵ H{  HtSHC0HtHHHGHtH HGHAHC LGhHWpHOxHGhHC(HGpHC0HGxLC HS(HK0DH   HGhHC HGpHC(HGxHC0HC HtH HC(HtH HC0HtH LCtHHSH|$0Ct H\$8H ^HtH
 H	H% H
 H# H	H%@ H
 HB# H	H%  H\$WH HQ 3Hy(HY0HA HA(HA0HtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWAVAWHH HqP3HYXLHy`LHu0H]@H}HHAPHAXHA`HuGHtH/u
HGHP0H]@HtH+u
HCHP0HW H HM I  HV L I;   HuH& H H H}HHu0jHKI;u	H[@H-      t<H{|	H[HHݰ H HӰ HM@H)uHAP0H}HHu0I@     H   HtH/u
HGHP0Hu0H.  HFH  HF    }      @t3H  IHw H}HH]@Hu0u%LLHI:  H\$XH A_A^_^]LEHHU@HM0 HE@HHH HH;t2 u(LMHILE@HU0:  H\$XH A_A^_^]HMHHt
H)uHAP0HM0H)uHAP0HE@HX@HHM@H)uHAP0I3H\$XH A_A^_^]H\$HHYhLYpLQxHAhI HApIHAxHH\$MMH\$Ht$WH HHHQHHs HHttL@A      u	H; HG H9C t-HX H
 LGH	 H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
8 H	_ tլ Hܬ xHWLH xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _~    uHH  uH\$0H _ø   H\$0H _LH;u   HA    }      @t3   H% E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
h AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL; AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H; ø   Htfff     H   H;tHu3H;f ø   H(HA      tiHQHHtVHtHHt0Hy H
 Hy H	P HH(H(H% AIHHH(ËAH(3H(H\$0HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,H= H3H(ËAH(ËAH(H(H%o H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(>= >= >= ,= %= 6= >= >= >= H(HA      tEHAHHw,Hx> H3H(ËAH(ËAH(H(H% H\$0=HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(> > > > > > > > > H(HA      tEHAHHw,H'X? H3H(ËAH(ËAH(H(H% H\$0]HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(> > > > > > > > > H(HA      tEHAHHw,HG8@ H3H(ËAH(ËAH(H(H%Ϧ H\$0}HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(? ? ? ? ? ? ? ? ? H(HA      tEHAHHw,HgA H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(þ@ @ @ @ @ @ @ @ @ H(HA      tTHQHHtAHt3HHyH
r H{ H	 H(H(H%_ AH(3H(H\$0HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,HǽB H3H(ËAH(ËAH(H(H%O H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(^B ^B ^B LB EB VB ^B ^B ^B H(N H(H(. H(H( H(H( H(H(Τ H(H( H(H(f H(H(n H(Ht$H|$ ATAVAWH L%M AL LtHv  tDADH\$@Hl$HEt8H- Ht,| H  ;n }HHD9Du
H\ H,MDƋI   HHthtHЋ  Ls E3HI HHtHȉp| HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH|$XH A_A^A\H\$Hl$Ht$WH   HAIɋ0 HHtVtDL HH
  " 	H HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_H E3H
 E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$      H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H=b
 HڋHuH   m H  hHHH4
 &
 @   
    H\$@Hl$HH _Ht$0Dŋ5	 HϋLt$83  LcD;}'IH9luHHH)   HAP0}	 ;u.p@HHcH HHtX5	 5	 H	 HcMI;~#HHHI+@ AHIAHuMƉ5K	 BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H=	 Ht/ H9   ; }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@VWH8HH
 H  H\$PHl$XLd$`Lf`Ll$0E3Lt$(LvPL|$ L~XLnXLnPLn`͠ H
 HtLBH HTH
P HAL   MtA͞ HHt@H\ H-ş HE-ӝ H+u
HCHP0HtH- AE$ל L AH.
 H
  MMIH)  L|$ Lt$(Ll$0Ld$`Hl$XH\$PH8_^H\$WH HAHL   MtA HHu.H
 H	 tH
՞ H	 LH	
 HH\$0H _H\$Hl$VWAWH0333HLHu3 HH   HH
W Lt$P, LHt~^ HHtp.   H
R	  Ht<LD$    LII͝ HHu7H
 H	ś t#; LD$     LII HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^HAH    tH%˜    Hl$Ht$WH HBHHiH      uHl$8Ht$@H _H% HH\$0 HHu"H
 H LELH	5 3:H H@L  Mt$LHHAH+Hu
HSHR0HHH\$0Hl$8Ht$@H _H(LALH
 HW H	 3H(LI[IkVWAVH0HAP3ICIHAXMCICLHA`ISHi`HHiPIHiXIKIC H9nP   HD$PHt(HL$(H    HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHVhLH~pHH^xIHNhLFpHFxHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP03QHL$ I.H/H+Ht
H)uHAP0HL$(Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIPLH;u   Hu3HB      2   HA    }      @t3H%s H\$UH HjE3HH~HB H;|   IHL;|Ht$0H|$83H   HrfHH;   HC    }{      @toHX  Ht4L@3M~HH9tHHHI;|3H   H\$@H ]H     H   H;tHuH;ؚ    	H{ u'HHH;O3Ht$0H|$8H\$@H ]ø   H\$WH LQhHypHYxHQhLApLIxMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _HAhHHApI HAxIHHtH I HtH IHtH H\$WH   H3HH9HHDG<Е u#H H;HC8HC0HJl HC@H{FDK$AtPH
w H A   H	A H9;tH
l H9C@uH{@Hj H$   HĐ   _H$   HL$@  HS(HL$@  HtCH
z H;tbLCHs HHj L
d HGIHD$0H] Hz LOHL$(Hz H
 HD$ H	} 7H9{@uHCk HC@3H$   HĐ   _3HHAH` HA8HA0Hk HA@H9 tHj H9A@uHA@    H%> H\$HT$UVWH HHLrfHH}  A$V 3AU IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <9}4HÍv4p<0}H\$Hu,H
 H DH	t t*LHcHG(H H
n H	 3H\$@H _^]H
O H AZ   H	 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]H cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]fNU R U eT >T R R S R S  T sS U T  







































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtHt H
} H	 3    t   LA       )   эB<       A<	  CDA0H<0|f<9}CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGH DHHH
s D@XH	F    HGHcHLH
M MDHa H	 gH
/ Hx DH	 JH
 H DH	ގ 3+; uH eHCGGHG(   IH7 H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
) LMHt H	 Ld$XH(A^[D8cGu+DAXHz H
 H	 Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
 H LH	 H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH LICHD$(IM HD$ GHuL
 L̑ H Lg HL	AHDAP@  HD$(H LT$ MH
 H	 H8H(DA@1wVL
hHA$] A] IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
 H H	Z 2H( \ \ \ \ \ \ \      H(DA@4wEHH] ] H   H(ø   H(ø   H(ø   H(H
 H H	 3H(Î] ] ] ] ]       H(DA@4wEHH^ ^ H   H(ø   H(ø   H(ø   H(H
 H H	 3H(^^ h^ r^ |^ ^       H(DA@1wqL
HA_ A_ I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
 H  H	 3H(0_ :_ D_ N_ n_ X_ _      H(DA@4   L
HA` A` I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
 H H	 3H(H
͆ H H	 3H(f4` >` H` R` r` \` ` `       Hs   L̞A db Ab IH H H H Ho H Hw HÔ Hw H H ÅH
 H HEÅH
 H HEÅH
 H HEH H H H H, H  b Za ja za a a a a a Ra Ja a a a ba ra a a a 	b  	

DH H
 H	H%\ @SH HDA@<	w<BHA؃0<0|<9}H[X<0}HtH [ÃHH H
 D H	փ H [HDA@<	w7BHEA0<0|<9}GHE@F@<0}HAÃE3HN LJLkh HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=h Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJH HHHL$ H
 H	e 3H8fD  H   H;tHuH;H t   H8H\$Ht$WH LAHIxpHt[H tTH MtI	HL
 HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
' H  M@H	 H\$03Ht$8H _H(H H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H(" y,H(LH /   HHtH(uH@P03H(H\$WH HAIL   MtA` HHuH\$0H _HH*   H+Hu
HSHR0HH\$0H _H\$Hl$VWAVH0HA3H; H   LqM   HYH H9Cu HT$(DFHT$ Lt$ H        w HH   IE3LpHHHHx H  Hm Hu
HUHR0H+u
HSHR0HEH;, H|$PuA   HT$P  H;l uHA@t    HHH\$XHl$`H0A^_^EH;uH H H߀ HAH;~ uCLAIHH3H+HMtQ3ҋIEA;tH~ H H~ H;~ uAfAnf.zuzA   H%~ H\$Ht$WH H:} 3HH΋H9CH9G5  C u
H xG u H yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM @ƋH\$8Ht$@H _L} I;uUI;@ƅuJA   HH| HHHH+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HHt| t/HD$8HH      tJE3LD$8HT$HHE| uLL$8MtLH
~ L HJ H	| 3H [H
~ L H H	{ 3H [ø   H [H\$Hl$Ht$ WH H3H
0| IHL;u3H;Lt$0HMHDߋ      Ht:H   MtH^} I9@tH
} H2 H	{ h  HHHH} Ht(} HH`H;tHHp`Ht
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHI{ t   IMMHC      tHHӹ   { 3z HHtuE3HH| H+Hu
HSHR0HtNLOHA      @H
| H LH	y H9 H
b| H	)z Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4ISuy   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@%y HLL$pH8G `<`uHH@Iy( uIy LL$pAA `<`uIAIA@H;u-HIH	nx yy H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$ w q3H\$`H0A_A^_^]HY@%x HLL$pHC `<`uH[H[@Iy( uIx LL$pAA @t
 tIAIA@H;u)HIH	\w ؅ypx HuqLL$pt@HI;H H
y L$   H	w H\$`H0A_A^_^]H; H
by Hk L$   H	v H\$`H0A_A^_^]LLH
y H H	H%v HHLT$pH M;LT$0MLH
x MML
 IML
= H| H	LDIH΃ HDHg HD$(L\$ v HHH\$Hl$Ht$H|$ ATAVAWH Hx HL`PLpXLx`3HEPHEXHE`MtI$MtIMtIMMIH      x Hw HMPHHuXH}`LePLuXL}`Ht
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
u Uu HJu H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAPHHAXI HA`I3HAPHAXHA`H\$WH LQPHyXHY`HQPLAXLI`MtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
t H A   H	s H(H(   H\$UH v HHXPH   H
Ar LI;tCHK    }      @t3HIH(v uH\$@H ]3Ht$0HuXH|$8H}`HE`HEPHEXH+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HH@y LL
O H
r Hu LDH	H%r H
r H A   H	H%zr @SH HSq 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H L ËH [Lbr I;AuI;AuA   q HHu	H [HH|$0H+u
HSHR0H|$0H [@SH Ir Hu~r Ht3H [HH H [Hl$Ht$WAVAWH E3IILHL9quL9qu  y3   H\$@L9wtAG t;   Nq HHtsHE HHhIHHp G tE3W=W8   q HHt8IE3LxHHE Hh HHp(HO~  LH+u
HCHP0H\$@IHl$HHt$PH A_A^_Hl$Ht$H|$ AVH 3ILHH9iuH9iu   y3   H\$0H9ot9G t3   Pp HHtcHHHpIG tE3W5W0   p HHt0IE3LpHHHp HO  HH+u
HCHP0H\$0HHl$8Ht$@H|$HH A^H(HALHty u
IIH(H(@SH HAHH	HHAL   MtAzo LHu	H [LKIAHp H;tcHX  Ht1LA3M~eHfH9tAHHI;|3H [    H   H;tHuH;Xq    tIA(HHHKIA(HᏉK 3H [@SH Hn HuJ.o Hu7HӍHmo HHt#H
o HH	p H+u
HSHR03H [H H [@SH LAHHH
a Cl Ht	H H [n Ht3H [HH [  HH;}HH33H%n LL$8E3HMtIH%k HAH@pHtH@HtH   Ht$WH0LAHHI@hH   Hx    HH\$@wHHuYm HtNHl HH(o t%fk LGH H
m M@H	?l 3H\$@Ht$HH0_A   HHD   H\$@Ht$HH0_H
n Hn M@H	k Ht$H3H0_H\$Ht$H|$AVH Lq3L;5Nj HH   L;5k uDLI?AEDuHQHH;WHH?   HD   MvhM   I9v   EtGHyBIHt:HxHHHAV   H
j H	j u3   j HHAVtHH?EuHWHH;WHH?u5Hk HHtHH%i H+Hu
HSHR0HHGHH H\$0Ht$8H|$@H A^@SH HHu3H [H|$0h H+Hu
HSHR0HH|$0H [HAH;l u
E33  H;l uHA@t3   H` E3  HT$H(HAH;4l uA   HT$8  H(H;vl uHA@t
   H(   H(H\$Ht$WH HH   i HHuH\$0Ht$8H _HE3HHxH#  H+Hu
HSHR0H\$0HHt$8H _H\$Ht$WH HAH@ Hpt3HYk @ H Huk ;~#H
R h t3H\$0Ht$8H _HHH
?k H؋   ~z<R)k H 9x }
k @$ Hu"\i HuH
 j H H	`h Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Huj    j @ H Huj ;~H
" g t3lLHHH
Jj H   ~ZR4j H 9X }
&j @$ Hu"gh HuH
i H H	kg HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyLLqHHY Ici @ DH Hi D;~H
 f t3    uL CuFHu9wuLMIH   |u%Ht LCHcGI;uHSMH   UfHU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ f HHh    ~YIh H 9X }
h @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHHLh E3LHHLg HHt\H~.Hx  fff     HHIH[H HCHAHu3H9g AF HH/u
HWHR0AN HH\$0Hl$8Ht$@H|$HH A^LH H
'f H	H%d HB      tHAL   MtIH%e H\$WH HH
D HHAL   MtAd HHuH
e HH LH	d HH\$0H _HAL   MtIH%d @WH H{ 3Ht	H H _H\$0i   HZk H      `  H
0 H  H=?  tDZ H
 3H
 H)uHAP0H\$0H     H H _3c H Hu'Hj H      `  e3H
Mi Ea Hf Hu'Hj H     ? 
`  #3H
i e H4 Hu'H@j H k     `  y'Hj HQ ;     `    H
5 Va H HuVHi H      2`  "c HuH
c H H	&b H H\$0H _HKa H Hu'H`i H      4`  HQ H
 H ` HZ Hu'Hi HW A     6`  H
 Q` HB Hu'Hh H      7`  wL H` H
 a y'Hh H     M ;`  1;  y'H`h H      =`  9= tFL H H
 ]a y'Hh HS =     B`  _ HHu'Hg H      F`  ~H H^ HuBL H HI` y'Hg H     C H`  '1  y'HVg H      M`    y'H&g Hg Q     O`  
    Wy'Hf H      Z`  }k  u'Hf H  #   h d`  LH
 3HHu'Hnf H  &   + m`  H LH
U W] ye &    o`  
  H+u
HCHP0H
 3\HHu'He H.  '    y`  Hv LH
 \ y '   v {`  	  H+u
HCHP0H
 3HHu'Hle H  (   ) `  
Hu LH
S U\ yc (    `  }	  H+u
HCHP0H
y 3ZHHu'Hd H,  *    `  H LH
 [ y *   t `    H+u
HCHP0H
h 3ٿHHu'Hjd H  ,   ' `  H LH
Q S[ ya ,    `  {  H+u
HCHP0H
 3XHHu'Hc H*  -    `  H LH
 Z y -   r `    H+u
HCHP0   Z HHu'Hkc H  .   ( `  H< HH HKH+ HH H HKH HAH
 kHHu'H
b H
= ' .    `  O  H+u
HCHP0H H蝽HHu'Hb H  .   k `    H LH
 Y y .   7 `    H+u
HCHP0H HHHu'H,b Hm W .    `    H LH
 Y y# .    `  =  H+u
HCHP0H/u
HGHP0   -Y HHu'Ha H  /   [ `  ?H HH HOH HH H HOH HAH H HOH HAH H HOH HAH H HOH HA H
 SHHu'H` H%  /    `  G  H/u
HGHP0H H腻HHu /   a `    H LH
 W y /   - `    H/u
HGHP0H HHHu[ /    `  u  H LH
 W y' /    `  A  H/u
HGHP0H] H蝺HHu /   y `    H- LH
 V y /   E `    H/u
HGHP0H H)HHus /    `    H LH
/ 1V y? 0    `  Y  H/u
HGHP0H H赹HHu /    `    HU LH
 U y 0   ] `    H/u
HGHP0H+u
HCHP0H
	 HHu'HE^ H p 2    a  H@HH' L   MtAV HHu* 2    a  D  H+u
HCHP0H E3HHHu'H] H ٿ 2   k a    H/u
HGHP0HO LH
 3T y 2   % 
a    H+u
HCHP0L H
*+ 3V HHu'H] HT > o  о a  H LH
 S y
 o   a  $  H+u
HCHP0Lp H

 3)V HHu'H\ H  r  G  a  +H LH
q sS y r   "a     H+u
HCHP08S HHu'H\ HR <    ν *a  L HHh R y ,a  %H LH
 R yT} -a  ׽    H[ H H+u
HCHP0H5H/+HGHP0H+HCHP0H8 H\$0H _33H(A`  H H
` H Hu*HZ H  	    _  H(A`   Htk H
l 褌HM Hu    L _     AH
  H H
'm fH Hu|     _     A0  H H
m (HI Hu>    л _  tAP   Hq H
{ H Hu     _  9A   Hz H
 貋Hc Hu*Ȼ h  Z _  HY H H(3H(H\$Ht$WH H= HP y_ E    Z_  A  3H5H9
 H uH4
 H;MR HDH"
 H
ӹ Hܬ LR y E    __    H= H=p( HO yź   W a_    H9c) Ht( uH( H;Q HDH( H
B H[ LzQ yh    f_  J  H5F: H=? HfO y4 f   ƹ h_    H92; H={H<: uH: H;$Q HDHy: H5 H5+ HO yй i   b n_     H9 H/ uH~ H;P HDHl H5E H5^ HN ys    t_  XH9T He uH H;mP HDH H5 H5 HKN y5    z_  HV H
 H\$0Ht$8H _H9[  Hl uH H;O HDH H\$03H5[ Ht$8H _333H(HeN Hn yy (_  .   N H Hu )_     wN H( Hu *_      NN H߹ Huh +_     + %N H Hu? ,_      M HM Hu -_  d3lN H Hu ._  D   IN H HuӶ /_  !   &N H Hu* 0_  HT H     H(3H(H   H2    ON H Hu |  ? ^     H    N H Huv ~   ^    H̸    M H Hu?   ѵ '^    H
    M H Hu    2^  [  H^    sM H Huѵ   c =^  $  H    <M H Hu 3  , H^    H(    M H޺ Huc 5   S^    H
K LHuJ H> Hu+ f   ^^  ~  H
K LH=J H Hu f   a^  F  H    ^L H Hu p  N l^    Hj    L
 L H HD$(H HD$ L Hھ Hu_ y   w^    H-    K H Hu( 3   ^  {  H    K H< Hu 5   ^  D  H    \K Hݹ Hu C  L ^  
  Hp    %K HN Hu-HRQ H u     ^  HĘ   H%    J H Hu-HQ H@ *     ^  HĘ   H2    J H Hu-HP H ߲   q ^  HĘ   HG    DJ H Hu-HqP H  *  & ^  HĘ   H    I H
 Hu-H&P H_ I .  ۱ ^  HĘ   H    I H Hu-HO H  B   ^  HĘ   H    cI H Hu-HO Hɷ    E ^  HĘ   HS    I H Hu-HEO H~ h    ^  HĘ   H    H Hֵ Hu-HN H3     ^  HĘ   H    H H Hu 2   r _  3  HN    KH H| HHu o  8 _    H, E3H HT$pD$ho  HD$`H HD$XH HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    E HH Hu o   _  h  H3    L
 L H H$   H HD$xH HD$pH
 HD$hH HD$`H HD$XH HD$PHB HD$HHη HD$@Hʳ HD$8H^ HD$0Hj HD$(H HD$ F H HHuʮ _     H E3HL HT$pD$hr  HD$`EAHG HD$XH HD$PHD$HHL$@HD$8HD$0HT$(3D$    JC H Hu-D _   r  H[L H HĘ   3HĘ   H(H
M  H1 Hu*H
L HN 8    ʭ ]  H(H
; H? Hu*HK H  |   ]  H(H
! |H Hu*HK Hʳ  W  F ]  H(H
 :H Hu*HGK H r _   ]  H(H
ݯ H Hu*HK HF 0 =  ¬ ]  H(H
+ H Hu     ]  ZH
 Hѳ Huά *  ` ]  ,H
 ZH Hu*   2  ^  H[J H H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HB HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
V Hz  @ǅtH0 H
0 H\$0H _HH\$0H _H@  @SH 3LHy  
 t=Hò Hc
ƪ H3HHCHCLCH   ? HH [3IA0  HHuH [@SH HSA HHIHCHAA H Ht
H)uHAP0H%A HKHCHA H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H@ HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
z Hz  @ǅtHp H
T H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   p= HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H=? HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
< t=Hs Hc
 H3HHCHCLCH   ; HH [3IA0  HHuH [@SH H= HHIHCH= H Ht
H)uHAP0Hu= HKHCHf= H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H-= HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
Τ Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
\ t=H# Hc
> H3HHCHCLCH   9 HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _H_; H HIhH)uHAP0HD; HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _H: H HI`H)uHAP0H: HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H: H HIXH)uHAP0H: HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H9 H HIPH)uHAP0Hd9 HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _H8 H HIHH)uHAP0H8 HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H?8 H HI@H)uHAP0H$8 HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _H7 H HI8H)uHAP0H7 HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H6 H HI0H)uHAP0H6 HC03H\$0H _HA0H HA0@SH HHt
H [O  H6 H HI(H)uHAP0Hf6 HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _H5 H HI H)uHAP0H5 HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _HO5 H HIH)uHAP0H45 HC3H\$0H _HAH HAy  H\$WH HHj5 HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH Hc4 HHIHCHQ4 H Ht
H)uHAP0H54 HK HC H&4 H Ht
H)uHAP0H
4 HK(HC(H3 H Ht
H)uHAP0H3 HK0HC0H3 H Ht
H)uHAP0H3 HK8HC8H3 H Ht
H)uHAP0H3 HK@HC@Hz3 H Ht
H)uHAP0H^3 HKHHCHHO3 H Ht
H)uHAP0H33 HKPHCPH$3 H Ht
H)uHAP0H3 HKXHCXH2 H Ht
H)uHAP0H2 HK`HC`H2 H Ht
H)uHAP0H2 HKhHChH2 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu|/   HH|$H1 LD$0HT$8HL$@0 HH{HtHH  HPULD$0HT$8HL$@H 0 HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  H1 E3Hl 8  HH	  HK/ LHCHH:/ HH H-/ HC H"/ H H/ HC(H
/ H H/ HC0H. H H. HC8H. H H. HC@H. H H. HCHH. H H. HCPH. H H. HCXH. H H. HC`Hz. H Hp. HChHe. H o y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [H H- H HI`H)uHAP0H- HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H_- H HIXH)uHAP0HD- HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H, H HIPH)uHAP0H, HCP3H\$0H _HAPH HAPH(Ht	H(J H
* HЁ H	+ H(H(AH+ Hu;H53 Hv ` X    G  G  H
~S AX   3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H+ H HI@H)uHAP0Hd+ HC@3H\$0H _HA@H HA@@SH HHt
H [L H+ H HI8H)uHAP0H* HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _Ho* H HI0H)uHAP0HT* HC03H\$0H _HA0H HA0H(Ht	H(N H
' Hx H	) H(H(A() Hu;H0 H&  T        H
^O AT   蓅3H(@SH HHt
H [hO HQ) H HI H)uHAP0H6) HC 3H [HA H HA @SH HHt
H [P H( H HIH)uHAP0H( HC3H [HAH HAH(Ht	H(.Q H
G& H} H	/( H(Q H(Ht	H(>R H
% H8| H	' H(H(IL$0W( Hu;H/ HT > P   А j
  j
  H
lJ AP   3H(H\$WH HH*( HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H#' HHIHCH' H Ht
H)uHAP0H& HK HC H& H Ht
H)uHAP0H& HK0HC0H& H Ht
H)uHAP0H& HK8HC8H& H Ht
H)uHAP0Ht& HK@HC@He& H Ht
H)uHAP0HI& HKPHCPH:& H Ht
H)uHAP0H& HKXHCXH& H Ht
H)uHAP0H% HK`HC`H% H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu" @  HH|$H% LD$0HT$8HL$@# HH{hHtHu  HHLD$0HT$8HL$@H# HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  H% E3HM 8  HHuH(H+# HAH # H H# HA H# H H# HA0H" H H" HA8H" H H" HA@H" H H" HAPH" H H" HAXH" H H" HA`H" H HH(H\$Hl$Ht$WAVAWH L3  HHu'H~) H  =   + X     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHH)  u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_s X  
g X  H( Hɐ  =   H/u
HGHP0HtH+u
HSHR0D H
Dv  }3tH\$Hl$VWAVH L3 HHu'H( H5  =    W     In3I+.HHtafIL$H! HHtiHGH9G ~HHOHHHHOHH u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^ W  

 W  H>' Ho Y =   H/u
HGHP0HtH+u
HSHR0D- H
r  {3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H;5 tgH;t t^IH HHu/H>& Ho A/   DV eW   H]_  H@L   MuSgW    HLL Mu8H H9GuL;w1  HGJL;w  J\HIHAHHG  ILHt
H)uHQR0HHM]  HHEH;t?HUHtLEL+Ix*HH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPHA4 Hu`HUHMHHM-HUHLEL+I)\ U N G @ A0   W  f H   H
 LI;   HH    }      @t3HuoIH uZW  A/   H]H# H D  HtH/uHGHP0D  H
@q {x& H/u
HGHP0HUIH]MtIm uIEIP0HtlHEH+HH;v) H    H=   r<t
 HCH;r H+Hs H'v HH@H]H   HUHHMH+H*HHHH?HH
H;v HRHH=   r<tg HCH;rW H+HsG H'v: HHf?IL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H; toH; tfIH LHu/H! H A/   D V  7 Hu  H@H   HEPHuV  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HrEHu HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMz[L}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMZL}H]HuHt;HH]HEP7A0   #W  H}@H?   H
J  H
sJ   H   H
 LI;   HH    }      @t3HGjIH udW  H}@H?A/   H H DӀ i MtI.uIFIP0D G H
k Cs8 I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hs H'v HH:HH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   HI H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH; twH; tnIHi HHu3H H A/   D~ V  ~ H]L}9  H@H   HEHuV  H]L}  HLHHMH]L}Hu8H? H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  H8HE   HE    E HHMBHEHrDHHMH=   r0  HAH;  H+H  H'  HP8 H  HE   3H}@}IE3HUHM=HEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHM1eLuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHMdLuH]L}Ht*HC   H{H{rHHHU  H@H H]HMHET M F ? 8 1 * # H
D  H
uD  A0   V  H}c HH   H L I;   HA    }      @t	38d	I uZV  H}A/   H H Dz gz HtH.uHFHP0Dz Ez H
e Am2 H.u
HFHP0HUH}HYLuH]L}MtIm uIEIP0HM]MtHIM+IMIz+HHMH3-H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
[ H;E  H; 8  H HHu>y    x /V    H@L   HEo    HAHHt[HEo   HAHHtEHAHޚyH
 H
~ jx 6V  UH+9  HCHP0*  H+u
HCHP03u	HMoÛH\ H~ x >V  mx    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   H$r H
- H	 2Mx-Hi L
{ ILDHn H

 H	
 w    Lw V    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I$f Htv MV  eHHMQ  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+Im*
 Ht@Pv NV  v    Hw H| Dv +v H
<a 'i   HUHMHHUHMUHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I)HUHtLEL+IHUHtLEL+IWELmHUHtLEL+IE)MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I)HUHtLEL+I7IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;U	 toH;
 tfIH
 LHu/H^ Hz A/   Dvt U  t Hu  H@H   HEPHuU  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HdEHu
 HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMJLL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMKL}H]HuHt;HH]HEP7A0   U  H}@H?   H
Q;  H
C;  ^	 H   H
 LI;   HH    }      @t3H[IH
 udU  H}@H?A/   H Hw Dq 9q MtI.uIFIP0Dq q H
 [ d8{ I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hsv H'vi HH+HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H; 8  H< HHuo    po IU    H@L   HEo    HAHHt[HEo   HAHHtEHAH~yH
S
 H
u 
o PU  UH+9  HCHP0*  H+u
HCHP03耑u	HMocH H-u n XU  
o    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hh H
 H	 2Mx-H	 L
 ILDH@e H
 H	p Zn    m 5U    H;u
Hz HrHrH~H6HHE3LLHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+It! HtWm gU  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I
! Ht@l hU  Jm    H HHs D5m l H
W _   HUHMEHHUHM5HHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I< HUHtLEL+I# HUHtLEL+I
 WELmHUHtLEL+IMtI/u
IGIP0MtI.uIFIP0HUHtLEL+IHUHtLEL+IIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH; toH;4 tfIH LHu/H H/q A/   Dk T  j Hu  H@H   HEPHuT  Hu  HLHHMPH]HuHu8Hc I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H!UHHEHHu HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHMEL}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHM%EL}H]HuHtH;HH]HEP1A0   T  H}@H   H
1 U H
1 G  H   H
X LI;   HH    }      @t3HQIH; udT  H}@HA/   H HPn D=h g MtI.uIFIP0Dh g H
bQ Z8 I.u
IFIP0HUH}@HL}HuHMtIm uIEIP0HthL+IL;vM J    H=   r=@t0 HFH;r  H+Hs H'v HH/"HH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH;O toH; tfIH HHu/HX Hl A/   Dpf LT  f Lu  H@H   HEPHuNT  Lu  HLHHMP= H]LuHu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0H H9GuwuHHH (EHf.zu HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHM@L}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHMY@L}H]LuHt3HH]HEPA0   yT  H}@H   H
-  H
- z + H   H
 LI;   HH    }      @t3HLIHn udiT  H}@HA/   HR Hi Dpc c HtH.uHFHP0DNc b H
K U8H H.u
HFHP0HUH}@HL}LuHMtIm uIEIP0MthM+IL;v J    H=   r=Atc IFI;rS L+IsC I'v6 LIbHH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is H H3HD$hHHIK3t$ HA   HqHyrHH@0D$    HJHH H;t- u#LD$(HT$0H^ x,HT$0LD$(LGLD$(MtHW(H+ Hu>H_ Hg za    a T  T  A   H
rJ S   HD$`   Ht$XD$H HL$H[ HT$HHHD$`HrQHHL$HH=   r<t HAH;r H+Hs H'v HHHL$hH32L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3 HHu'H> Hof Y` =   _ S     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_3_ S  
'_ S  HX He s_ =   H/u
HGHP0HtH+u
HSHR0DG_ H
H ^ Q3tH(HyHQrH	x Hu;H Hd ^ 2   y^ sS  sS  H
F A2   jQ3H(H\$Hl$Ht$H|$ AVH L3 HHu'HL H}d g^ =   ] R     In3I+.HHtgff     I HHtqHGH9G ~HHOHHHHOHH u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^S] R  
G] R  Hx Hc ] =   H/u
HGHP0HtH+u
HSHR0Dg] H
dD \ O3r@SUVWAUAVAWH 3H\$`H\$hH\$p LLxhLppHhxMtIMtIHtHE D   H Hb \   V\ >Q  H IMPL I;tUH  I@      t
IY*HA9   }      @t	3E	I&    DK\ H
? [ NLL$pILD$hHT$`Wy\   [ XQ  [Hb E3H
e HHu|[ dQ  'E33HvH+u
HCHP0S[ hQ  [   Hr H\$`Ht$hH|$pHa LMIIZHtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D9[ H
A Z MH A_A^A]_^][MtI/u
IGIP0MtI.u
IFIP0HtHm u
HEHP0H A_A^A]_^][@SH HC HH HIhH)uHAP0H% HCh3H [@SH H HH HIhH)uHAP0H HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH H HH HI`H)uHAP0H HC`3H [@SH H HH HI`H)uHAP0H HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH H HH HIXH)uHAP0H HCX3H [@SH H HH HIXH)uHAP0He HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H HH HIPH)uHAP0He HCP3H [@SH HC HH HIPH)uHAP0H% HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH HC HH HIHH)uHAP0H% HCH3H [@SH H HH HIHH)uHAP0H HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH H HH HI@H)uHAP0H HC@3H [@SH H HH HI@H)uHAP0H HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H HH HI8H)uHAP0H HC83H [@SH H HH HI8H)uHAP0He HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH H HH HI0H)uHAP0He HC03H [@SH HC HH HI0H)uHAP0H% HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH HC HH HI(H)uHAP0H% HC(3H [@SH H HH HI(H)uHAP0H HC(3H [H\$WH LJHL;
( HtrH; tiH
 L`) MIHY5 H	  H HU O   nO E  E  H
j5 A  _BH\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH H HH HI H)uHAP0H HC 3H [@SH Hs HH HI H)uHAP0HU HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH Hs HH HIH)uHAP0HU HC3H [@SH H3 HH HIH)uHAP0H HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HAH\$UVWAVAWH@HQ H3HD$8H=R LLHH
RQ 33LG, HHtH ' Ht3K D  <  H}HHHuK D    H 3H9Au%HYHtHyHHH)uHAP0   H~ H9GufIGHT$(HD$(DEHHH+H\$ Lt$0zHHu9K D     H  H+  HCHP0   M HHuH
" H
cQ J D  VHtHX3IGE3HH IGHDEIHLt9yHHu~J D  H HQ J l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0DJ H
/ 4J 7=3#H.u
HVHR0H/u
HWHR0HHL$8H3H$   H@A_A^_^]H\$WH0L
/ E3H; HHRHA3I;At   KMuH
 HxF H	? +HBL H
[ HlF MIHD$ H	 3u/H
m H
O I k  *I qD  3H\$@H0_HHH\$@H0_HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI6HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUoLEHUL+I3 HHu'H4 HuN _H h  G 3D  -  IM;<       HEH;tIE3HHMtH IE3HUHM\HE   H}E IE3HUHM8H	 HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p
G =D  
F ;D  H QG h  HVM H.u
HFHP0HtH/u
HGHP03DG F H
+ 9LHH.uHFHP0HEHrPHHMH=   r<ty HAH;ri H+HsY H'vL H{HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIM+IHL;v II   r=At IFI;rs L+Isc I'vV LI IHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H֓ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI֒HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU_LEHUL+I3 HHu'H$ HeJ OD c  C C  -  IM;<       HEH;tIE3HHMdH IE3HUHMLHE   H}E IE3HUHM(H HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pB C  
B C  H AC c  HFI H.u
HFHP0HtH/u
HGHP03DC B H
' 5LHH.uHFHP0HEHrPHHMH=   r<ti HAH;rY H+HsI H'v< HkHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIыM+IHL;v II   r=Ats IFI;rc L+IsS I'vF LIrIHM/H3L$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHI$HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`wHL$hH+L$XHHHLI?LHT$XHT$(HL$@谡HL$@薴Hu;H* HkF U@ _  ? C  C  A_  H
# 2HH|$@Ht2HT$HH܇HL$PH+HHHLI?LHXH|$(Ht1HT$0H蠇HL$8H+HHHLI?LHHL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHI褅HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`ǆHL$hH+L$XHHHLI?LHT$X?HT$(HL$@ HL$@Hu;Hz HD > Z  7> 7C  7C  AZ  H
! (1HH|$@Ht2HT$HH,HL$PH+HHHLI?LHH|$(Ht1HT$0HHL$8H+HHHLI?LHlHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx Hf H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+I[3C HHu'H HB < T  q< B  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM
 HHt[HNH9N ~H HFH<HAHFHH( u H/u
HGHP0I;ܿ    >p; B  
~; B  H ; T  HA H.u
HFHP0HtH/u
HGHP03D; 2; H
C ..LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hso H'vb HHE'   H}E MtzIIaM+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx HV H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI&HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU߂LEHUL+IK33 HHu'H H> 8 O  a8 mB  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMHy HD$(HM	 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pz7 wB  
n7 uB  H 7 O  H= H.u
HFHP0HtH/u
HGHP03D7 "7 H
 *LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t HAH;ro H+Hs_ H'vR HHE'   H}E MtzIIQM+IHL;v
 II   r=At IFI;r L+Is I'v LIIHM/H3sL$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx HF H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI{HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU~LEHUL+I;3# HHu'H H: 4 J  Q4 B  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMHi HD$(HMs HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pj3 B  
^3 B  H 3 J  H9 H.u
HFHP0HtH/u
HGHP03D|3 3 H
3 &LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<to HAH;r_ H+HsO H'vB HqHE'   H}E MtzIIA|M+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3cL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHH   HEH$   HE3ELeWELeLeXAAELe3 LHu<1 C  0 jA  c  HFH; tLH; tCIHV HHu0 pA    H@L   MuUu0 rA    HMMMu8Hc H9FuL;v  HFJL;v  J\HIHAHH   HMXH]XHt
H)uHQR0HCL   H<8 HMtA HH   E3H;6 HC^HHtgH+u
HSHR0IIOI9O ~HIGH<HAIGHI uH/ HGHP0N/ A  |B/ A  p6/ A  a H   H
. LI;   HH    }      @t3HIH u}. A  IH #/ C  H(5 I/u
IGIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Lu   H.u
HFHP0MIHMHMH;t$HH]HHHMHHHML L`L`H]HMHtHU0xLEHUL+I~ Ht$H H;4 %. D  - A  aHUHMHUHMcHHM@HI裀ȉMP HuA- F  f- A  H H3 H]D- G- H
 C LH]MtI.u
IFIP0HMXHtH)uHAP0HHttHUH#wHEH+HH;v HH=   r<t HCH;r H+Hs H'v HHH]HtsHUHvHEH+HH;vh HH=   r<tP HCH;r@ H+Hs0 H'v# HHOIH$   HĀ   A_A^A]A\_^]H\$Hl$Ht$H|$ ATAVAWH@Hc4 LHIHE333EFBHHu'H H1 + :  b+ f@    3H; @3H; 3H;3 uH y}+ :  + h@    H+u
HCHP0s  HK1 H L5A1 HB3 IIFL   MtA HHu'H H1  + =  * }@    H LgI9$r  HoHe  H_HHE HHH)uHAP0HF LcI9$   IG0HT$ A   HD$(HHl$ YHHui* =  ) @    Hm u
HEHP03H/u
I$HP0H
. H|VHH   * =  3) @  y      HHu'H
 H
/ ) =  h) @  k  HhE3IG0HH3H IG0HF WHHu) =  $) @    H.2HFHP0#IW0HUHHH) =  ( @    H+u
HCHP0E33H`CH/u
HGHP0H 3H/ ( =  ( @    H2 A   IOH?HHu'H H. ( >  ?( @    H؅y( >  ( @  
  H/u
HGHP0   IO(L I;uEH
 L H H	= H H/. ( >  ' @    H0 LHHu'H H- ' >  p' @    3H;
Z H(uH@P0  H#/ H L5/ H/ IIFL   MtA4 HHu'H- Hn- X' @  & @  R  H LcI9$  HsHs  H{HHHHH)uHAP0H LgI9$   IG0HT$0A   HD$8HHt$0UHHu^& @  +  H.u
HFHP03H+u
I$HP0H
* HRHH%  v& @  3& A  H' Hh, HtH/u
HGHP0H2  Hm '  HEHP0      HHu% 	A  sHpE3IG0HH3H IG0HE THHul% A  <Hm HEHP0	IW0HQHH.% @  % @  HE H+ H*H+ HCHH/u
HGHP0E33H?H+u
HCHP0H H,+ % @  $ A  HtH.u
HFHP0D$ H
 $ MtI.u
IVIR03
HR H H\$`Hl$hHt$pH|$xH@A_A^A\[HUATAUAVAWHhH   HEHXHpHx Hs H3HE/HHMWEE3LeELeEAAELeELeHE'   LeDe37 LHu'H H) # 3  e# ?    Ls8IFH;Y t`H; tWHI LHu# 3  # ?  Z  H@L   Mu]b# 3  " ?  1  IIܐMu8H I9FuI;^   IFH4I;^   ItHHIAHH   ILHt
H)uHQR0HFL   H* HMtA| HH   E3H.+ HPHH   H.u
HVHR03IOI9O ~HIGH<HAIGHIe u$H/HGHP0E3A   '" 3  ! ?  E3  " 3  ! ?  E3  ! 3  ! ?  E3   HtfH
w LI;tQHH    }      @t3H
IH^ u! 3  ! ?  E3M   E3I.u
IFIP0ML}IHM芡HMH;t$HH]HHHMHHHML L`L`H]HMHtHUjLEHUL+IC% Ht'H H&   4  ^  @     HUHR@HM蠗HMH;t$H8H}HHHMHHHML L`L`H}HMHt5HU-hHMH+MH*HHLI?LHUs Ht'H H0&   4   @  R  LEHUHMD36 LHu'H H%  5  d @    H]H;]  HEH;tIE3HHMH HMH}'HCMHU HH   ILHt
H)uHQR0HGL   Hs) HMtA LH   E3HZ$ H:MHHtwI.u
IFIP0MIOI9O ~HIGH<HAIGHIܳ uH/u
HGHP0H;]   5  5 @  u 5   @  _ @  FHB Hs$ ] 2    sS  sS  A2   H
E M @  % 5  IH߻ H $ I/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0HtH/u
HGHP0LuH]H}D H H
 DMLuH]H}MtI.u
IFIP0MtIm uIEIP0HE'HrPHHMH=   r<t HAH;r۰ H+Hs˰ H'v HHE'   LeE H   HUHdHMH+H*HHHH?HH
H;vY HRHH=   r=@t< HGH;r, H+Hs H'v HH;Ht~HUHfHEH+HHH;vѯ HH=   r<t HCH;r H+Hs H'v HHH]HtHUHeLEL+IHIHM/H3L$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`H" HAL   MtA Hu;H H   &  g H?  H?  H
3 A&  X
3H({HAPH HAPHAPH HAPH\$WH0HIXE33hDHHu?H H
2 A   H  >  D  3H\$@H0_H HH! H9CuA] HHu\H~ A   >  H D 7 H+uHCHP0D  H
 3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHl$H   HEH$   LWEE3L}L}L}L}L}MHEL}L}<HEAEL}wH=O# LGHH
 c HHtH ȯ HtIHJHHuh    =  =  HCL   H HMtA HHu"    =    H+u
HCHP0HFL   H! HMtA HHu'H H    P =    H.u
HFHP0ILcHe I9$  HsH  H{HHHHH)uHAP0LgH I9$uSHuLmA   HUHFFHHu     =    H.u
HFHP0I      z LHu'H
 H
    ` =    HpIIE Lh E3IHDHHu   " >  e  I.u8IFIP0,IHBHHuR    =  '  H+u
I$HP0HGH H;   H;    HU HHu ">     H/u
HGHP0HFH   MHHMHtTA   HLHtAHH7y   ( *>  k  L)&u
HFHP0I   H.u
HFHP0I7uI8B    2>    HOHtf~A   H6 H
? H	 
Hx28 
>  H M   H H/  HGH  H;u
Lw H_H_LsHHIH/u
HGHP0H]LuHHM HHEH;tJHUHRHM
HMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHM\
HEH@HEH HEH@L}H}HIHM HHEH;tJHUHRHMHMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUHM<   DBoHMzLMLEHUHMgHIaHHMEHUHtLEL+IH
5 ;LHu'HѰ H     ]>    H@L   H IMtA HHu'H} H    : _>    I.u
IFIP0HMԳLHu
 b>  C  ILcH/ I9$
  HsH   H{HHHHH)uHAP0LgH I9$uJHuLuA   HUHAHHu v>     H.=  HFHP0.     M LHEwHu'H
r H
    / >     HpILp ME3IH?HHu >  8Im    IEI   IH=HH    o>     Hٮ H HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0HMwHt
H)uHAP0D H H
) D#I.u
IFIP0H+u
I$HP0LHMHt
H)uHAP0HMHtH)uHAP0LEMM HUwHM   DBoHM9LEMM HUwHM   DBoHMHUHtLEL+IIH$   HĠ   A_A^A]A\_^]HSVWATAUAVAWH   H@HLW@E3LPD$XLt$hD$@Lt$PAAEL`LXH;ԥ tJHtEH(HD$0H$   tu]Hج H     2=    L$   L$   H H$   H$   L%z L$   HH$   蒧HL$XH;t%HHL$XHHHL$`HHHL$hL0LpLpH$   HtL$   L+I Ht'H HQ ;   
 ==    LD$XH$   IMjZHL$@H;t%HHL$@HHHL$HHHHL$PL0LpLpH$   HtL$   L+IjHT$@H$   藉L- MEIH
z \ HHtH  HtII?HHu'H( Hi S
    N=    HCL   H6 HMtAۣ HHu'HԪ H     P=  ]  H+u
HCHP0H$   'HHu'H H    E S=  &  ILoHj I9E F  HwH9  LoHIE HIH)uHAP0IMH$h  H H9urHt$pH\$xA   HT$pI@;LHu'H H"     g=  j  H.u
HFHP0H+   HCH      X LHu'H
 H
    > w=  
  HpIHX E3II9LHu'H9 Hz d   
 }=     I/uUIGIIHH7LHu$H H1    
 `=  |H+uHCHP0P0L$h  H/u
IE HP0H$    \  H$   H
v H;IDH$   H$    +  E3AAAEHtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0MtI/u
IGIP0H=v  HLxPL`XLh`LpPLpXLp`H$    t%H$   H;IDH$   H$   ; HKPHsXH{`L{PLcXLk`Ht
H)uHAP0HtH.u
HFHP0HtH/u
HGHP0D	 "	 H
c MHT$@HtLD$PL+I HT$XHtLD$hL+IH$   HtL$   L+I¼IH   A_A^A]A\_^[H\$WH0LRHH HL;u   ^HuH
 HN H	 >It   -H
) Ln IBLJH+ HD$ H	 3u/H
0 H
q [    =  3H\$@H0_HHH\$@H0_HHHAUH   H) E3HXHhAHxAL`LLpHAL$   L$   Ll$ L   L$   MtAi H$   HL|$xHu'HU H
     >;    HCL{H;6 I   HsH   LsHHIIH)uHAP0IFM~H; Ht$(uA   HT$(I6+H; uIF@t
HI4HI3LHu   Y K;    H.u
HFHP0IH+u	IHP0I.u
IFIP0ID$IHs
 L   MtsAtH; uE33Hd51H;C uHC@t3He3H	 E3HA4LHl    N;     Hu'H H    g [;    H
 H$   .HHu'Hg H  	  $ g;    H@HH
 L   MtA HHuL 	   i;  H  H+u
HCHP03i HHu'Hڢ H  	   l;  $  IL$(H;
~ u0H
m H H	-  	  Y p;    He
 ,HHu 	  , r;    H@IH;  t_H;_ tVHM HHuS 	   x;  O  H@L   Mu%* 	   z;  &  HHMMH/u
HGHP0 Mu>H H9EuL;u   HEJ<HI)L;u   J|HIHAHHb  H$   H$   Ht
H)uHAP0H HH H9Gu]+ HH   HKH9K ~H HCH<HAHC$HH3  	   ;  
  IHm u
HEHP0H L~II9  HnH  LvHHE IIH)uHAP0HE M~I9  A   Hl$(HT$(H\$0I1LHu{m 	   ;  i  T 	   ;  P  { H3Hۖ HHt.  	   ;    Hm u
HEHP0IH+u
HCHP0H.u	IHP0H
 L$   *HH   Hf H  
  # ;        HHue 	    ;  a  HhE3HHX IIa/LHu'H H3  	    ;  <  H/,HGHHHA-LH  	  i  ;  
  H@HH L   MtA_ HHu'HX H   
    ;  
  H.u
HFHP03 HHu'H HR <  
   ;  p
  H$   HI(H;
 u>H
 H> H	] H H  
  { ;  
  H 'HHu'H H  
  @ ;  	  H@H;8 t\H;w tSH̕ HHun 
    ;  j	  H@L   Mu%E 
   ;  A	  HHMMH+u
HCHP0Mu>H H9EuL;e(  HEJHI)L;e  J\HIHAHH   H$   H$   Ht
H)uHAP0H HH H9Cu{& HHtOHNH9N ~H HFHHAHF+HHU 7 
   <  3  H H&  
   <  /  7 Ht H HH    Hm u
HEHP0H LII9  HoH  LwHHE IIH)uHAP0H M~I9   A   Hl$8HT$8Ht$@If,LHuNH HH 2 
   +<  Q  H H!  
   <  *  Hm u
HEHP0IH.u
HFHP0H/u	IHP0H
 Lt$ %HH   Hi H    & Q<        HHu'H/ Hp Z 
   ;<  y  HhE3Hp HIIIS*LHu 
   A<    H+,HCHHHA(LHH H  
  [ $<    H@HHX L   MtAQ HHu'HJ H u    S<    H/u
HGHP0H# L{II9  H{H  LsHHIIH)uHAP0H M~I9   L$   HT$HA   Ld$PIH|$H)LHu   IY g<    H/u
HGHP0IH+u	IHP0IL$   MH)uHAP0H D9(z  H$    HH   H
 HN  8    <  l      HHu    u<    L$   E3HxHIII$L` 'LHu   X {<    H.HFHP0L$   HI%LHu   I a<  n  I Hu'H HR <    <  p  H;t7H
 H	 HՖ H      <  4  H
 I!HHu'H H  
  W <    H@HH$ L   MtAM HHu <  {  H+u
HCHP0    HHu'H HU ? 
   <  ^  IL~H@IHL$ L0HHCHHH܍ I9  H~H  LvHHIIH)uHAP0Hj M~I9&  A   H|$XHT$XH\$`I&LHu. <    H/u
HGHP0H+u
HCHP0H.u	IHP0IMH$   L|$xL$   H$   H$   H$   H$   Ht
H)uHAP0MtI,$uID$IP0HL$ L$   Ht
H)uHAP0MtIm u
IEIP0H$   HtH(u
HPHR0IHİ   A]ù    HHu <  }HxE3HHX II$LHu$H HY C 
   <  eHm HEHHHi"LH <   
  H H HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0HtHm u
HEHP0D H
  L$   ;HT$HL$SUVWATAUAVAWH   HAE3HE AL|$hAL$   AL   EL|$`EL|$xEL$   L$(  L|$XMtA HHu'H H    > /9    HGL$   HD$PH H;V 4  HWH$   H  HwHHHHH)uHAP0H$   HFH$   HD$PH H;Ì uA   H$   H##%H; uHF@t
H&!H HHu'H H    Z <9  *  H$   H)uHAP0L$   H/uHD$PHH P0H.Iu
HFHP03 HH   W    L9    H;݋ uE33HF"1H;% uHG@t3HG H E3H#!HHWH H    m ?9  =  H$  HI(H;
M u0H
< Hu H	    ( P9    H4 oHHui    R9    H@H; toH;2 tfHHD$p~ H$   Hu    X9  Z  H@H   HL$PHu3    Z9  ,  HLH$   H\$pL|$PH\$pHL$   H/u
HGHP0HuHH< I9FuI;^  IFH<HHH\$p-I;^  I|HHH\$pIHH  H$   LH$   Ht
H)uHAP0H
> IvHH_  HHH H   HHt HH  Hm u
HEHP0H IH@ I9Eu5 HH  H
 LH  HHH H   IHt H$(  LH4  I.u
IFIP0H2 IH I9Eu
 LH  H҅ Ml$L|$XI9E 
  IT$HT$XH   Md$H$(  HHL$(  I$H(uH@P0HT$XH; Ml$L$   I9E uNH$   A   H$   L$   IzLH  HD$XH(u
HPHR0L|$Xx    LH  HT$XE3HPILp HL|$XM(LH  Im u
IEIP0L$   'II&LH  I.u
IFIP0H$(  H)uIE P0   " H$(  LH#  H
W E3HhHIL` LH  I.u
IFIP0H LkL$(  I9E    HSH$(  H   LsHHIIH)uHAP0H$(  H MnI9E uQH$   A   H$   L$   IHH  H$(  H)uHAP0L$(  s    HH  H$(  E3Le HIHEL$(  MtHHh  Hm u2HEH&IH}HH  I,$uID$IP0H+u
IE HP0HNIH9N ~HHFH<HAHFHHف   H/H\$pHl$PL$   HGHP0II.u
IFIP0H$  Ht$hɺ.  H* MHh R    :  R
  9    9  u       9  _     M 9  C     } 9  $     d 9       K 9       2 9        9    n     9    U    9    <    9  x  #   M 9  \     M 9  @     Mz 9  $     a 9       H 9       I, ~9     HH! HH^tt Q   I v9    
  H$  HH(H;
 uAH
 H H	i Hʇ MH     #:    Hp HHu*H MH    F %:       & H$   HHu ':  I  HD$hE3H
E HH HCHs zHHu /:  I  H+u
HCHP0HFH;} t_H; tVHIU H$   HHu 6:  I  H@L   Lt$PMu+d 8:  I  HHH$   MML|$PH.u
HFHP0IHMH$   LMu<H} H9EuL;e'  HJ4HI(L;e  J4HIHAHH  HFH~ H;   H;| tHX~ HHO  H.u
HFHP0HEHMH   HH  HA   HH  HH	o  L)u uGHEH;HNH  H;u
H^ H~H~H_H?HHH.u
HFHP0IH$   LHt
H)uHAP0HL$`IH\$`H$  Ht
H)uHAP0IEIH;{ tKH;| tBIH7} HHG  H@L   Mu&   W :    IE IIMMu>HA{ H9FuH;n   H^HHH)H;n   H\HHHAHH   HL$xH\$xHt
H)uHAP0IEHHpHtHAHt
HIHIQHH  L$  HHH|  H+u
HCHP0HT$xLII} :  H/HGHP0I+| Ht H5z HHr9  z H.u
HFHP0H$  IH$   Lt$PH$   HD$`H MH1 M   M }:  w  Hm u
HEHP0I1uIH MH M   MR :  "     9 u:          :    u    :  C_    :  -I    :  3    :  IH MH! MH$  MHD$`IY~H
 z H	 A   H	y 
Hxd `:     IMMMHo H HtH.u
HFHP0H  H/  HGHP0  z Ht Hx HHD   Vx Hm u
HEHP0Ht$hHLHtH.u
HFHP0H$   Ht
H)uHAP0HL$`Ht
H)uHAP0HL$xHt
H)uHAP0H$   HtH(u
HPHR0IH   A_A^A]A\_^][' T:     MMMIH2 Hs H$   Ht
H)uHAP0HtHm u
HEHP0HtH+u
HCHP0MtI,$uID$IP0MtI.u
IFIP0Ht$hH$(  Ht
H)uHAP0HL$XHt
H)uHAP0MtIm u
IEIP0D H
0 2 5fH\$Hl$VWAVH@H/y IHzLH\$pHM   HtH   HZH\$pHw HHu-H  H HLBu HtHHD$pHH   H~ HHD$(LL$pH H|$ y
8     H\$p   H   H   H} H|$0HH; H?L
 HL! HHDHHD$(H HL$ LIH
x H H	Bv 9  H} H/     A  H
 3HZHIH\$`Hl$hH@A^_^HHPHHATH   H E3HXAHhAHpAHxLhEHALd$XLd$hLd$pL   L$   L$   MtAv L$   HL$   Hu'H| H: $    7  k  HGLH;t M  LwM  HwHIHHH)uHAP0HFL~H;`w Lt$xuA   HT$xH
+H;w uHF@t
IHIH1HHuk    7  
  I.u
IFIP0MH/u	IHP0H.Iu
HFHP03cs LH   H{ H     7  	  H;v uE33H1H;v uHG@t3H
HJ E3HHHN    7  <	  H$   HI(H;
s u&H
u H׷ H	s  7    H +HHu 7  ^  H@HH;q Ht$PtMH;r tDHDs LHu 7    H@H   HL$`Hu^ 7    HLILd$`H/u
HGHP0 HD$`Hu>H/q I9FuI;v\  IFH<HH(I;vB  I|HHIHH   HL$hH|$hHt
H)uHAP0H$r HH H9Gup HH   Hq HH H9Gugp HHtgH/u
HGHP0IOII9O ~HIGHHAIGHIp uH+HCH "8      8      8     |r HtHo HHtV3p I.u
IFIP0H$   IL|$XNyeHx H    p 18  %  a 8  IHx H    I/l  IGIP0]  tIMx  3o LHu'H1x Hr \    68    H$   HH(H;
p uAH
r H6 H	}p Hw IH     :8    H HHu'Hw H    ] <8       =p HHu'Hfw H    # >8  c  IE3H
Q HLxHX HHu F8    H/u
HGHP0HCH;m teH;o t\Hko HHu'Hv H     M8    H@H   Ht$`Hu$m O8    HHLd$PILd$`HH+uHCHP0    HuHH4m H9GuH;o_  HGHHHHl$P-H;o@  H\HHHl$PHHH  HCHn H;)  H;l   H`n HH  H+u
HSHR0HMIMH   HH$   MH  HA   LHm  HHI  L)} u
HEHP0Ht$`HL$pH$   H\$pHt
H)uHAP0H$   L$   L$   Ht
H)uHAP0L$   HMHHS  INI9N ~eH IFHHAIFdHKH`  H;u
Lk HCHCLhH H$   H IE H+3HCHP0$HIk    H+tH$   Hl$PH$   HCHP0H$   Hl$PH$    8    Hm u
HEHP0IuuIY 8     8    Hs IH H$   H$      n 8    Hs IH H$   H$      4 8  _  ~,H
k H A   H	k  w8    Hx w8     l Ht Hi HH#   5j H/u
HGHP0Ht$XML$   L$   L$   H$   H$   H$   HtH.u
HFHP0HL$hH$   Ht
H)uHAP0HL$pHt
H)uHAP0H$   HtH(u
HPHR0IH   A\ k8  IL$   MB   Hq H@ HtH/u
HGHP0MtI.u
IFIP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtHm u
HEHP0Ht$XD H
Ю 2 5H\$Hl$VWAVH@H/k IHzLH\$pHM   HtH   HZH\$pHi HHu-H  H HLBg HtHHD$pHH   H& HHD$(LL$pHy H|$ y
7     H\$p   H   H   Ho H|$0HH;v H?L
 HLѬ HHDHHD$(H HL$ LIH
j H H	Bh 7  Ho H/     A  H
 3HZHI"H\$`Hl$hH@A^_^ATAWH8HAE3H EH\$XHl$`HL   MtAKh Ht$0HH|$(Lt$ Hu'H5o Hv `    6  U  HCLsH;g I  H{H  HsHHHHH)uHAP0HFLvH;i H|$PuA   HT$PH+H;i uHF@t
HHHHmHHu'Hnn H    + 7  d  H/u
HGHP0IH+u	IHP0H.Iu
HFHP03e HH   Hm H? )    7  	  H;h uE33H1H;h uHC@t3HHx E3HHHNHm H    ? 7  x  HM(H;
'f u&H
h H H	e  7    H SHHu 7    H@H;c tLH; e tCHHqe HHu  7    H@L   Mu "7    HHIMH+uHCHP0    Mu>Hdc H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0H\d HH H9Cu7b HHtEHNH9N ~H HFHHAHF.HHc  H7      F7     e HtHyb HH趶tfb H/u
HGHP0HLH.u
HFHP0Lt$ H|$(Ht$0Hl$`H\$XMtI/u
IWIR0IH8A_A\ >7  Hk HL 6   H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D H
¦  臿LHL@HPHHSVWATAUAVAWH   H@HWhE3LxD$xL`AED$`L|$pD$HL|$XEL%\ MD$IH
 ` HHtH \c HtIIHHu'Hi H     /6    HCL   H HMtAvb HHu'Hoi H    , 16  o  H+u
HCHP0IH$H  LfH9a I9$g  H^H$H  HR  H~HHHHH)uHAP0LgHc I9$u}H$   H$8  H$   A   H$   HHHu'Hh H    \ E6    H+u
HCHP0IH$H        a LHu'H
Eh H
 p    S6  E  HXIH$H  H$8  H IF E3IHYHHu'Hg H+     Y6    I.uFIFIP0:HH=HHu'Hg H    [ ?6    H.u
I$HP0HGL   Hd HMtAA` HHu'H:g H{ e    _6  "  H/u
HGHP0HH$   bHHL$`-IH$   HtL$   L+I|>` Ht*Hf H    w b6  M  H.u
HFHP0IHT$`H$   DH$@  @@u5_ Ht*HGf H r    m6  MD  H$   H$   EDLH$   H$0  HIHHL$H"HH$   HtL$   L+I{HT$HHL$xCH
 EHHu*He H    S ~6  M  H@L   H HMtAF^ LHu'H?e H j    6  *  H/u
HGHP0HL$xhHHu'Hd H7 !    6    IMfH\ I9$E  I^H8  MfHI$IMH)uHAP0IL$H$H  HW_ H9urH\$(H|$0A   HT$(IHHu'HNd H y    6  9  H+u
HCHP0H/   HGH      \ LHu'H
c H
/     6     HXHx E3IIHHu'Hc H    f 6     Im uUIEIIHIHHu$H_c H     6  MH/uHGHP0P0L$H  I.   I$IP0   E3AH$H  AEMHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0MtIm u
IEIP0D V H
 RIHT$HHtLD$XL+I4xHT$`HtLD$pL+IxHT$xHtL$   L+IwH$   HtL$   L+IwHH   A_A^A]A\_^[H\$Hl$Ht$WATAUAVAWHPH[ E3Ld$@MH\$HHLAM   LzIMt"HtH   HZ H\$HHzH|$@IZ HIMtHt*UH: ILB-X HD$@HH   HH,  H ILBW HtHHD$HHH   H IHD$(LL$@H8j L|$ Ny
5     H\$HH|$@   HBH   H   HNHA_ HHL$0Hbf HLL
 AHD$(IHH HLd$ H
[ LY LMHƼ H	mX 6  H` HZ  >   A  H
% д3HZ HzLHIVL\$PI[0Ik8Is@IA_A^A]A\_HLH L@HHVWATAUAVH   H@HXLW@H@    33D$@HXL5 MFIH
h JV HHtH X Ht3IHHu'H_ HX B    l5  6  HGL   H% HMtAW HHu'H^ H     n5    H/u
HGHP03H|$ LcHV I9$M  H{H|$ H;  LsHIHIH)uHAP0MfHY I9$uqH$   L$   A   H$   IaLHu'H^ HC -    5  !  H/u
HGHP03H|$       V HHu'H
] H
 ׿   i 5    Hx3H|$ IE Lh E3HILHu'H\] H     5    H.uFHFHP0:IHLHu'H] HQ ;   ; |5  /  H+u
I$HP0IFL   H IMtAU HHu)H\ H ׾   i 5  3  I.u
IFIP0HD$0    HHL$pWHHL$@>HT$pHtL$   L+IrU Ht)H'\ Hh R    5  3D  H+u
HCHP03HT$@HL$X:H$   gAAu4=U Ht)H[ H    v 5  3   H$   @@u4T Ht)Hl[ H    ) 5  3   HT$XHL$p:DEHH$   HIS HH   H[ HF 0   ¼ 5  3%Lt$0H|$ IIMtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0D M H
. I3HT$@HtLD$PL+I,pHT$XHtLD$hL+IpHH$   HĠ   A^A]A\_^H\$ UVWATAUAVAWH`H
 H3HD$XH-S E3H5Q MLt$@HHl$HLHt$PM4  LbIMt1Ht"HtH4  Hr(Ht$PHj Hl$HLrLt$@IR HIMtHt3HtZ   HB ILB5P HD$@LH   HHw  H ILBP HtHHD$HHHJ  H ILBO HtHHD$PHH  H IHD$(LL$@H3b Ld$ )y
75     Ht$PHl$HLt$@   HBH   H   H   HSH
W HHT$0A   H
(^ HLL
 HL$(   H
R H;AML HHD$ H	H MML .P J5  HW H     A  H
 葬3Hr(Hj LrLLIIHL$XH33mH$   H`A_A^A]A\_^]@SUVWATAVAWHPHB H3HD$@H- MLLH
C H33LEN HHtH 'P Ht3θ 4    HHHu 4    HCHHd L   MtAO HHus 4    H+u
HCHP0HGHH@ L   MtAYO HHu'HRV H }    4  d  H/u
HGHP0H+N 33H9Cu+H{Ht"HCHHHH H)uHAP0   HP H9CugHT$(HDEH+H|$ HLt$(L|$0Ld$8HHuq 4     H  H/
  HGHP0   M1N HHuH
ZU H
 ! 4  ZHtHx3IE3HHLtEIL|EI$LdmHHu~Ӷ 4  HT H5    HtH+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0Dٶ H
6 h k3#H.u
HVHR0H+u
HSHR0HHL$@H3jHPA_A^A\_^][H\$Hl$Ht$WAVAWHPHL MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I~L HHHtHt/ZHR  H ILBJ HtHHD$@HH%  H. ILBqJ HtHHD$HHH   H IHD$(LL$@H]\ Hl$ y
~4     H|$HH\$@   H   H   H   H
 Hl$0HL
k H?L HHe HHLIH
X HL$(H
wM HD$ H	J 4  HR Hֺ `    A  H
 L3Hz HZLHIH\$pHl$xH$   HPA_A^_H\$Hl$Ht$H|$ ATAVAWH H5 MLHH
 HM3LFH HHtH 'NK Ht3 $4    HHHu~ $4    HGHH3 L   MtAtJ HHuB &4  D  H/u
HGHP0HCHH' L   MtA(J HHu'H!Q Hb L   ޲ )4  
  H+u
HCHP0H HHu ,4     H} LHG y .4     H MHG ye /4  jH4 MHG yB 04  GHy MHuG y 14  $H LHHHui 24  HP H[ E   HtH/u
HGHP0HtH+u
HSHR0D H
  覤3#H/u
HWHR0H+u
HSHR0HH\$@Hl$HHt$PH|$XH A_A^A\@SUVWATAVAWH`HR  H3HD$XH=H MH- LH5 LrH|$@IHl$HHt$PM2  Mt1Ht"HtH>  Hr(Ht$PHj Hl$HHzH|$@IG HIMtHt8Ht_   H  H ILBE HtHHD$@HHt  H0 ILBsE HtHHD$HHHG  Hk ILBFE HtHHD$PHH  H. IHD$(LL$@HRW Lt$ y
3     Ht$PHl$HH|$@   M   H   H   H   H{L Lt$0IHS H?L
& HLۅ HHHDMHD$(Hp HL$ LIH
0H H H	E 4  HLM H  q y  Ay  H
 3Hr(Hj HzLLHIHL$XH3bH`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   H MtAE H|$PHHu v  R 3  k  C HHu5 3        E HHuH
>L H
  3  lILLxHH 1C yۭ 3  4H+u
HCHP0H± LH?HHuf 3  HK H  v  H.u
HFHP0HtH/u
HGHP0H   H+   HCHP0uH.u
HFHP0H/u
HGHP0HCHHHpHtHAHt
IHIHHu=P w   3  HK HD D1 H
΂  ßLL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAH_ L   MtA`C Ht$8HH|$@Lt$HHu'HJJ H u s   13    HCLs3H;)B    H{H   HsHHHHH)uHAP0HFLvH;D H|$0uA   HT$0H+H;D uHF@t
HHHHHHuY >3     H/u
HGHP0H+u	IHR0HLt$HH|$@Ht$8H [H;D uE33H1H;^D uHC@t3HH߮ E3H\HHuª A3  HH H$  s  HtH+u	IHP0HtH/u
HWHR0Dު H
 m p3/AVAWHHH\$`E3Hl$hEH-) Ht$pHH|$@ALd$8ALELl$0LH
>  ? HHtH A HtIHHHu% o   2  3  HCHHl L   MtA@ HHuߩ o  q 2    H+u
HCHP0HGHHV L   MtAW@ HHu'HPG H { o  
 2    H/u
HGHP0H)? LcII9$w  H{Hj  HkHHHHE H)uHAP0HA LeI9$   A   H|$ HT$ Ll$(HHHuը o  g 2    H/u
HGHP0IH+u
I$HP0H
X LHH   HEF IH m p   2       > HHu'H
F H
I 3 o  ŧ 2  O  HxE3IE HHLh I+HHu o   2    H.)HFHP0IHHH o  > 2     Huy! 2  I   H+u
HCHP0   HEHHC L   MtA= HHu'HD IH3  p   2  QHN E3H#HHu| 2   p  HD H HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D H
l{  !H+u
HCHP0HHE LLl$0Ld$8H|$@Ht$pHl$hH\$`MtI/u
IWIR0IHHA_A^[H\$Hl$Ht$WAVAWH0H-y LH
 H33LE: HHtH '< Ht3: /2  "  H5HHu /2    HCHHЧ L   MtA< HHuߤ 12    H+u
HCHP0HGHHĪ L   MtA; HHu'HB H  l  { 42    H/u
HGHP0H: Ls3I9  H{H  HkHHHHE H)uHAP0H= LuI9uoA   H|$ HT$ L|$(HpHHu H2     H/u
HGHP0H+u	IHR0HH\$PHl$XHt$`H0A_A^_ù   : HHuH
A H
 { V2  tHxE3IHHLx 3HHuL \2  7H.oHFH`IHHHL B2  H4A Hu _ l  HtH+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0D H
vw  諕3LUAUIHH  H} H3H   E3IsI{AMcMMsEHT$hM{LH  LEHUIHHAH LL$xHL$XL   LmLmLmLl$PLl$`LmLmLl$pLmLmLmLmLmLmLmLmLl$@Ll$HMtA8 H$@  HHu'H? H ١ 1  k ?+  G  HGLH;7 IG  H_H:  LwHHIIH)uHAP0IFM~H;: H]uA   HUIu+H;T: uIF@t
HIuHILHu*H> MH'  1   L+  E  H+u
HCHP0IH/u	IHP0I.u
IFIP0H
8 H9L$x  L;A{  H
 LH   HR> MH z 3   p+  7E  H; 9 uE33Hi1H;H9 uHG@t3HjHɣ E3HFLH'H= MH  1   O+  D  H@IH L   MtA6 HHu 3  G r+  7D  I.u
IFIP0Hӡ E3HLHu*H9= MHw a 3   u+  	D  H/u
HGHP0I.u
IFIP0H
5 H9M  L;%4 A   H
y dLHu*H< MH ݞ 5  o +  C  H@IHܥ L   MtAe5 HHu 5  ) +  C  I.u
IFIP0Hݣ E3HLHu*H< MHY C 5  ՝ +  B  H/u
HGHP0I.u
IFIP0H
4 Ld$hL;   Lt$XIF(H;uAH
v6 HGo H	64 H; MHգ  8  Q +  |B  H] HHu*HY; MH  8   +  >B  I,$IHD$h   ID$P0   H
ץ LHu*H: MH9 # 9   +  A  II1 u 9  I +  vA  I.u
IFIP0t_   
2 HHu*H{: MH  :  5 +  `A  I$IH@HT$hL I,$uID$P0Lt$XH
 HHu*H: MHT > ;  Л ,  @  H@HH L   MtA2 HHu*H9 MH  ;  y ,  @  H/u
HGHP0HCHH L   MtA_2 HHu*HX9 MH  ;   	,  =@  H+u
HCHP0IN(IH;
1 uAH
3 Hl H	1 H8 LH5  ;   ,  ?  H HHu*H8 MH  ;  s ,  ?  IN(H;
[1 uAH
J3 Hkl H	
1 Hk8 MH  ;  % ,  ;?  H lLHu'H
-8 H
n X ;   ,   ?  H0 MELl$@H9Gu2LgLd$@Mt$HGHI$HH H)uHAP0A   H2 H9G   HD$hH   H   EFAHHH+L   H   L   LHu'He7 H  ;  " ',  8>  MtI,$uID$IP0H+MLl$@u
HCHP0I/   IGI   AN/ HD$HLHu'H
6 H
# 
 ;   9,  =  MtL`MLl$@HL$hE3AIHILAFI\HAFIM|MLHu'Hl6 H  ;  ) G,  ?=  HL$HH)uHAP0H/u
HGHP0HL$hIMLt$hH)uHAP0H]H;. uI- Hu*H5 MH,  =   a,  =  H+HHEuHCP0H\$XHK(H;
w. uAH
f0 Hi H	&. H5 MHŝ  ?  A x,  <  HM 舿LHu*HI5 MH q ?   z,  g<  HK(H;
- u8H
/ HKi H	- 4 ?  IÖ ~,  Ll$H;  H HHu! ?  I ,  Ll$Hy;  HI - HD$HHHuŖ ?  IT ,  D;  I.u
IFIP0H/u
HGHP0H
( H]Ll$HHHu-H34 IHq MX @   ,  N;  H@HH L   MtA, LHu-H3 MH I @   ,  :  H/u
HGHP0IFIH L   MtAv, HHu @  I7 ,  ':  I.u
IFIP0HS+ MAH9Gu+LwMt"HGHIHH H)uHAP0   H- H9GuoHEHUpHEpDCHHH+LuhL}x&HD$HHHu @  I ,  z9  MtI.u
IFIP0M   KO+ LHu @  I@ ,  39  MtLpMHME3HT$hHILCHHITIHD$HHHuP @  Iߓ ,  8  I/u
IGIP0H/u
HGHP0H+u
HCHP0H
 Ll$HaHHu B  Iz ,  j8  H@HH/ L   MtAp* LHu B  I1 ,  $8  H/u
HGHP0IGIH L   MtA* HHuI B  Iؒ ,  7  I/u
IGIP0H\$XMHK(H;
) u3H
+ H0e H	W)  B  I ,  s7  H ǺLHu B  IP ,  C7  HK(H;
8) u3H
'+ Hd H	(  C  I ,  7  H WHD$0LHu*H0 IHQ ; C  ͑ ,  6  HK(H;
( u3H
* Hd H	d(  D  I ,  6  H ԹHHuΑ D  ` ,  S6  H' MELl$@H9Gu2LgLd$@Mt$HGHI$HH H)uHAP0A   H
* H9G   HD$hH   H   EFL   HLd$0AHH+L   L   H   .HD$HLHu B  M -  5  HL$@Ht
H)uHAP0I/Ll$@u
IGIP0I,$uID$IP0H+   HCH   AN' HHu,H
H. Lt$0H
 n B    #-  5  Mt	L`Ll$@HT$hE3Ld$0HAL|AFLdMAFH\AFHIHTH1HD$HLHu'H- H  B  z 4-  4  H.u
HFHP0H/u
HGHP03Lu$ HD$HHHu-H]- IH M G   C-  s4  H\$XHK(H;
% uDH
' Ha H	% H- IHE M, G   G-  4  H HHu-H, IH M G  } I-  3  HK(H;
e% uGH
T' Ha H	% Hu, IH M G  I) M-  ?3  H pHHu-H1, IHo MV G   O-  2     $ HHu*H+ MH/  G   Q-  2  H
ߖ E3HHxHp HHu*H+ MH ͍ G  _ Y-  2  H+u
HCHP0HFH;G"    H;# tyHI# HHu*H<+ MHz d G   `-  P2  H@L   Mu3H+ MH@ * G   b-  1  HHMH.u
HFHP0H|$HMu>H! H9CuL;c  HCJ4HI)L;c  JtHIHAHH  HFH" H;$  H;0!   H" HD$8LH  H.u
HFHP0IG3ɋDHL$8L   AL|$0HHb  HL$8D~AHD$0HH  L|$8IAH  I/u
IGIP0Lt$0HL$pH|$pHt
H)uHAP0HMIHEHtH)u
HAP0IHH[! HHb  H|$HHOH9O ~\H HGH4HAHG[HNH]  H;u
Lv H~H~LwH?HIH.PHFHP0AHH(     H.HFHP0E3An  Lt$0E3ފ G  p -  c/  HL$8H)uHAP0E3uIݭLt$0L G  ) -  /  HE( E3H m G   -  */  H( E3HY E@ G  ҉ -  .  H' E3H, E G   -  .  ~H
'  H A   H	 
Hx
H' E3Hԏ E G  M -  x.    HtHF HHrt^ E3H+u
HCHP0HMH}ILl$HWyYH' Lt$PHR < I  Έ -  -.  H& E3H( E G   ~-  -  q   H
 RHHu,H& Lt$PHߎ Ɉ J  [ -  -  H@HHh L   MtAQ HHu*HJ& MH r J   -  /-  H+u
HCHP0H  IH9F   H^H   H~HHHHH)uHAP0HH^HD$HHHu*H% MH  J  t -  ,  H+u
HCHP0IH.u
HFHP0HL$hIH|$PHAH;<    H;w    ILe  HD$HHHumH'% MHe O K   -  ,  H<HD$HHHgH$ MH"  J   -  +  H@H   HEHuCH$ MH Ά K  ` -  +  HIHEHHL$HMLm MLl$8MHuFH3 H9GuL;g  HGJ4HILe ,L;g  JtHILe HHHv  HL$`LHt$`Ht
H)uHAP03\ HH'  LEI@HHpHtHAHt
IIII!HH  H@H;j tXH; tOHI HD$0LH@  H@H   H|$xHu2~ M  I
 4.   *  HLH\$0MILl$xH+u
HCHP0Hu>H I9FuM;f  IFJHI(M;f  K\HIIHHZ  HMH]Ht
H)uHAP0H
m I-HH1  H@HH L   MtAT LH  H/u
HGHP0IGIH L   MtA HH  I/u
IGIP0H MALl$8MH9Gu3LL|$8Mt%HGHIHH H)uHAP0   DH H9GuiHEDAH   H   HD$XL   H@(H   HHH+趲HH`  MtI/u
IGIP0MLl$8} HD$@HH  MtLxMLl$8HEE3HT$XH JDHB(H HB(HJD HAHH  HL$@H)uHAP0Ll$@H/u
HGHP0HNIH9N ~"HHFH|$xLt$0HHAHFeHH   H|$xLt$0B Ht H2 HHok    I.u
IFIP0HMLHuHt
H)uHAP0H
M I蕪LH  H@IHÌ L   MtA HH  I.u
IFIP0H L{MLl$0I9   LsLt$0M   LsHLd$0II$IH)uHAP0H( M~I9uFHEHUA   HE ILeyHH  I,$uID$IP0MLl$0r    HH  L`E3LeHILl$0I$L` 'HH
  H/u
HGHP0MIH+HHf  H+u	IHP0HMHuHt
H)uHAP0L}IHH IIGL   MtA2 HIH  H4 H9CuRH{HtIHsHHHHH)uHAP0HH}HH7
  H/u
HGHP0IHHHS  H+u
HCHP0Ld$`HIIT Dx
AADE  H.u
HFHP0IE  HMH HAL   MtA- HHL
  IGHHpHtHAHt
IIII~HH  H L{MLl$0I9*  LsLt$0M  LsHLd$0II$IH)uHAP0Hr M~I9   A   Le(HU(H}0IíHH  I,$uID$IP0H/Ll$0u
HGHP0Ld$`H+u	IHP0HMHH]IH)   HAP0       HD$@H  E3L`HLl$0IHx 4HH]  HL$@H)uHAP0Ll$@lHH1HHw  H/PHGHP0AH] HH  LIHw {  HL$pLHt$pHt
H)uHAP0HL$PIHх HAL   MtA HH  LxLl$@H I9   LcLd$@M   LsHI$IIH)uHAP0H M~I9uDHD$pHU8A   HE@ILe8ҫHH
  I,$uID$IP0Ll$@x    HH
  L`E3Ld$pHILl$@I$L` 肪HH
  H/u
HGHP0ILd$pIH聨HH  H+u	IHP0H.Iu
HFHP0Lt$XIIN(H;
 V  H{ ΣHH  H@HH L   MtAe HH  H+u
HCHP0HZ LII9   H_H   LwHHIIH)uHAP0H M~I9uHHD$`HUHA   HEPIH]H1HH	  H+u
HCHP0Lt$XI      u HD$@LH	  HXE3HD$`IIIH ID$ ڨHH@	  I,$uID$IP0Lt$XLl$@HT$`HӦHHz
  H/u	IHP0HMIHuLHt
H)uHAP0IN(IH;
   H] HH  H@HHpHtHAHt
IHIH1HHh  H.u
HFHP0HMLH}Ht
H)uHAP03I HH  A   HI HD$@LH  H.u
HFHP0IIGDr  I,$uIT$IR0Et/   v HD$@LH  H
v HH@HIMI/IMLeuIGP0HUH
} 5HH
      HD$@LH
  H@IIH8 HHJ
  I,$uID$IP0HMLLl$@H}Ht
H)uHAP0L|$PIGHHpHtHAHtHT$`I
HT$`IvHH	  H@HHz L   MtA HD$@LHZ	  H/u
HGHP0   a HH	  ILp HH  L~ HH} }   LHI觥HHU  I,$uID$IP0H/Ll$@u
HGHP0H.Iu
HFHP0Ld$`LIII"   H+u
HCHP0IIN H  HEAEh  HME3AQHH
  H A   H臍HH  H+u
HCHP0HIDD  H.u
HVHR0E  H
u HH  H@HH.| L   MtA HHk  H+u
HCHP0IGHHpHtHAHt
IIII(HH  H LwLl$@I9   LgLd$@M   HwHI$HHH)uHAP0H$ LvI9u?A   LeXHUXH]`HyHH  I,$uID$IP0Ll$@y    HD$0LH  HX E3HL`HLl$@I*HH  I/u
IGIP0L|$PLl$0'HH'HH  H+u
HCHP0H/u	IHP0HT$`LII i  H.u
HFHP0L|$8ILt$0H|$HLe HEH H[z Et M  s 2.    Lt$0't L  s w.    Lt$0	t L  s .    Lt$0s L  }s .  p  Lt$0s L  _s .  R  s L  Fs e.  9  s L  -s b.     s L  s `.    is M  Ir P.    L|$8IEs N  Mr .    H L|$8H,y s N  r .    L|$8Mr N  r .  z  L|$8r O  ir .  \  L|$8Mr P  Hr /  ;  Hd L|$8Hx r P  r 1/  G  L|$8Mir P  q +/    L|$8Kr P  q /    L|$8Lt$0(r P  q /    L|$8Lt$0r P  q /    L|$8Lt$0q R  tq j/  g  L|$8Lt$0q R  Qq ~/  D  L|$8Lt$0q R  .q x/  !  L|$8Lt$0yq S  q /    L|$8Lt$0Vq S  p /    L|$8Lt$03q S  p /    L|$8Lt$0q V  p /    L|$8Lt$0p [  p 60  r  L|$8Lt$0p [  \p 30  O  L|$8Lt$0p [  9p 10  ,  L|$8Lt$0p \  p \0  	  L|$8Lt$0ap \  o r0    H IL|$8HHv 2p \  o l0    L|$8ILt$0p \  o x0    L|$8Lt$0o \  {o U0  n  L|$8ILt$0o \  Uo H0  H  L|$8ILt$0o \  /o E0  "  L|$8ILt$0wo \  	o C0    L|$8Lt$0To [  n *0    L|$8Lt$01o Y  n  0    L|$8Lt$0o Y  n 0    L|$8Lt$0n Y  }n 0  p  L|$8Lt$0n Y  Zn 0  M  L|$8Lt$0n Y  7n 0  *  L|$8Lt$0n Y  n 0    L|$8Lt$0_n Y  m 0    L|$8Lt$0<n W  m 0    L|$8Lt$0n W  m /    L|$8Lt$0m W  m /  Ll$@v  L|$8Lt$0m V  `m /  S  L|$8Lt$0m V  =m /  0  L|$8Lt$0m V  m /  
  L|$8Lt$0em T  l /    L|$8Lt$0Bm T  l /    H
 HA@ H	x L|$8Lt$0m T  l /    L|$8Lt$0l S  wl /  j  L|$8Lt$0l S  Tl /  G  L|$8Lt$0l S  1l /  $  H
 Hv? H	 L|$8Lt$0el S  k /    L|$8Lt$0Bl R  k d/    L|$8Lt$0l R  k W/    L|$8ILt$0k Q  k L/  ~  L|$8ILt$0k Q  ek J/  X  L|$8Lt$0k O  Bk .  5  L|$8k O  $k .    L|$8tk O  k .    L|$8ISk N  j .    :k N  Ij .    H H&q k N  j .    j M  Ij ,.  y  j L  Ijj ".  ]   Ht Hc HHS   H/u
HGHP0Lt$PIMHML$  L$(  H$0  H$8  H$@  Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0MtI.u
IFIP0HL$`L$   Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$pHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$hHt
H)uHAP0HEHtH(u
HPHR0IH   H3$HH  A]]h K  I*h .  
  3 HHu,H6 Lt$PHrn \h ^  g 0  M
  H\$XLHD$PIHK(H;
 u>H
  H~; H	u H Hn h _  g 0    Hm ڏHHu'H Hm g _  Xg 0    H LHu'Hb Hm g _  g 0  ~  H/u
HGHP0Ll$HMLl$0MM
  f     H
q 褏HH	  H@HHi L   MtA HHu	  H.u
HFHP0HGHHAj L   MtA HH	  H/u
HGHP0I HH  Hj AMLl$0H9Fu3HVHT$0Ht%HFHHHH H)uHAP0   DH H9F   HC(DALt$0H   H\$xH   HHH+L   H   H   HD$HH!  MtI.u
IFIP0H/MLl$0   HGHP0   : HH  HD$0Ht	HCLl$0HL$XE3J|HIHA(H HA(HJD HD$xH JD({HD$HHG  H+u
HCHP0H\$xLt$0H.u
HFHP0HMIHD$HHEHt
H)uHAP0H|$XLl$HHO(H;
|   HWk ʌHD$HHq  E33HHH9  HL$HH)uHAP0HMLl$HHuHt
H)uHAP0HI2     HO(H;
   Hi <HH  E33HcHD$HLH  H.uHFHP0LT$HH]IH HH=  HL$HH)uHAP0H+HHuuHCP0H
m HD$HLH  H@IHh L   MtAA HH  HL$HH)uHAP0H4 LsLl$HI9   H{H|$HH   HsHHHHH)uHAP0H LvI9uAHEHUA   HEHH}HH  H/u
HGHP0Ll$Ht   O HH  HD$HE3HGHHEHLl$HH HG 贐HH  H/u$HGHP0HUH躎HHc  H+u	IHP0HFHHyh L   MtA HH  H.u
HFHP0HMIH]HHt
H)uHAP0H
k BHH  H@HHXd L   MtAi HHG  H+u
HCHP0    HH  Hwk H HCHe H HC Hs(HGH@pHtH@Ht
HHHHsHH  H+u
HCHP0HL$PHIu=  H.u
HFHP0Lt$0IIM;  H\$X` `  IQ` 0  A  ` d  I5` ,1  I"  ` d  I` )1  I  h` d  I_ '1  I  H
 H	4 H	 2` d  I_ %1  I  Lt$0I` e  _ X1    Lt$0_ e  _ l1  o  Lt$0I_ e  ^_ f1  N  Lt$0I_ f  =_ 1  -  Lt$0I_ f  _ 1    Lt$0Ii_ f  ^ 1    Lt$0IH_ f  ^ 1    Lt$0I'_ f  ^ 1    Lt$0I_ e  ^ r1    Lt$0I^ e  w^ R1  g  ^ e  I[^ D1  IH  ^ e  I<^ B1  II&  ^ c  I^ 1  I  l^ b  I] 1  I  M^ b  I] 	1  I  H
 H1 H	} ^ b  I] 1  I  Lt$0] `  ] 0  u  Lt$0] `  g] 0  W  ] `  IK] 0  ;  ] `  I/] 0    ] `  I] 0    h] `  I\ 0  I  H
`g 諅HHu\ 1  I  H@HH` L   MtA HHu\ 1  x  H+u
HCHP0H LII9+  H_H  LwHHIIH)uHAP0H5 M~I9uxLd$PHU A   LeIH] 腋HHuLt$0[ 1     H+u
HCHP0H/u	IHP0I,$ILID$P0    HD$HHuLt$0[ 1  yLd$PE3HXHIII$L` HHuLt$0U[ 1  >HL$HH)cHAWLd$PHIHH>[ 1  o[ g  MH) Hja MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0MtI/u
IGIP0Lt$PH|$HLd$@MtI,$uID$IP0HtH/u
HGHP0HtH.u
HFHP0DZ H
. BZ EMH\$ UVWATAUAVAWHpH- H3HD$`H= MH5$ HL52 LLzH|$@IHt$HLt$PH|$XM}  Mt@Ht1Ht"HtH  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@IM HIMtHtBHtiH      H  HoX ILBZ HtHHD$@HH  HbY ILB- HtHHD$HHHx  H=X ILB  HtLHD$PHHK  H X ILB HtHHD$XHH  H) IHD$(LL$@H L|$ %uy
*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
.P L|$0IL
R H?LT) HHR HMLIH
 HL$(H
 HD$ H	- +  H H^ W W   A  H
( J3&Hj0Lr(Hr HzMHl$ LHIHL$`H3)H$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMHXY L   MtA	 H|$0HHu'H H>] (W   V }*         HHuV *  sHE Hh HHuH
 H
\ hV *  QHU MH yEV *   LHH轄HHuy#V *  HD H\ oV   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0D.V H
& U H33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPH1 MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt/ZHR  HS ILB HtHHD$@HH%  HS ILB HtHHD$HHH   H$ IHD$(LL$@Hm Hl$ qy
N*     H|$HH\$@   H   H   H   H
*L Hl$0HL
N H?Lx$ HHN HHLIH
 HL$(H
 HD$ H	) _*  H HZ S S   A  H
!$ F3Hz HZLHIBH\$pHl$xH$   HPA_A^_LATAVH   HS H3H$   HE3H; LI[ AIkIsAI{AMkEM{ELD$@HT$ HL$0Ld$(  3w HHu'H H)Y S   R )    HD$0HH(H;
 u0H
w H! H	7 R   cR )    HoR zHHu'H
k H
X R   (R )    H@H;  tsH;_ tjHI HHu'H
 H
ZX DR   Q )  O  H@H   HL$8Hu'R   Q )    HHMLd$8H/u
HGHP0HD$8Hu>H| H9CuL;s   HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0HMW IL;tIhxUnHMH9M ~IHEL<HAHELIH5 8Q   P 6)    P   P 4)     % HtH HH9t9 H+u
HCHP0HL$ LHl$ H)T  HAP0H  P   P ,)     L5Y H
JU IMF% HHtH % HtIO N)  <IցHHuO N)   HL$ H DuEO P)  O   H HU HI  Hm >  HEHP0/  Hm u
HEHP0Et[    HHu,HW Lt$ HU }O   O \)     HL$ LHT$ HH@HLt$ H=Y H
T HLG HHtH [ HtIH豀HH   H HT N   {N u)  Lt$ HtH+u
HCHP0MtIm u
IEIP0HL$(Ht
H)uHAP0HtH.u
HFHP0D|N H
) N AG  HCHHP L   MtA HHu'H H6T  N   M w)  2H+u
HCHP0HGHHV L   MtA HHuH HS XM z)    H/u
HGHP0Hl$0HM(H;
+ u>H
 H H	 H; H|S fM   L )  xHM ?uHHu'H  HAS +M   L )  =HM(H;
 u4H
 H H	T H HR |L )  =  HT tLHuYL )    H IAHL$(H9Cu5HKHL$(Ht'HCHHHH H)uHAP0HL$(   H  H9C   HL$HHT$PDEHHH+Lt$PH|$XLl$`@{HHuH H"R K )  lHL$(Ht
H)uHAP0H/Ld$(u
HGHP0Im    IEI   MJ HHuDHK )  H
i H
Q K   HH/HGHP0HL$(Ht	HHLd$(IE3HHLtEH|ELlMXyHHu'H H*Q K   J )  &H.u
HFHP0H+u
HCHP0ILH)uHAP0H
gU *sHHu*H{ IHP J    5J )  H@HHRN L   MtA+ HHu*H$ MHbP LJ    I )  cH+u
HCHP0HFHHSL L   MtA HHu'H HO I    zI )  *H.u
HFHP0H IAH9Cu+HsHt"HCHHHH H)uHAP0   H  H9C   HD$0HT$pHD$pDGHD$@HH$   HH+Ht$hHl$xSxHHu*H MH2O I    H )  3H   H.   HFH   Oq LHu'H HN H    WH )  HtHpIHL$0E3HT$@HILGHE HIlGHITIvHHu'H& HgN QH    G )  hIm u
IEIP0H+u
HCHP0LL$   H$   H$   H$   H$   MtI/u
IGIP0L$   MtI.u
IVIR0IH$   H3%Hĸ   A^A\H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt/ZHR  HE ILB HtHHD$@HH%  HE ILB HtHHD$HHH   H IHD$(LL$@H
 Hl$ by
(     H|$HH\$@   H   H   H   H
> Hl$0HL
@ H?L HH@ HHLIH
 HL$(H
 HD$ H		 (  H HK E E   A  H
 l83Hz HZLHIH\$pHl$xH$   HPA_A^_@UAWHHHM 3H\$`Ht$hH|$pH L=M Ld$@Ll$8LH
&J Lt$0L52I IMF HHtH Z HtHIvHHu'H HK D   ~D (  }  HCHHO L   MtAt HHu'Hm HJ D   *D (  )  H+u
HCHP0HF LfHI9$  H^H  LvHHIIH)uHAP0H MfI9$   A   H\$ HT$ L|$(IsLHu'H HI C   wC $(  v  H+u
HCHP0HH.u
I$HP0I.Hu
IFIP0   ! LH  HF HHI nC    C H(        HHu'H
	 H
JI 4C   B 2(    HXE3IHILx H-qLHu'H HH B   {B 8(    H/
HGHP0IH
oLHHg HH B   $B (  #  IEIH IEIFIE H IE IF IEHE L   MtA HHuA P(     H HH9G  H_H  HwHHHHH)uHAP0HH4nHHujA ](  DH+u
HCHP0HH/u
HGHP0   * HH   $A d(  HE HG pA   I.u
IFIP0HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0DA H
 @ 3fHmHH9@ `(  [H@ HH HGLw Hw(HW H HM HG0HB H H8 HG8Lt$0Ll$8Ld$@H|$pHt$hH\$`MtI/u
IWIR0HHHA_]@UAWH8HBE3H; AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH; t[HH@ HHu'H HE ?   f? '    H@L   Mu^G? '  i  HIIMMu>H2 H9GuH;w  H_HHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHIFhHHtFLHI tH+BHCHP03>   U> '     >   <> '  k H   H
4 LI;   HHD9   }      @t3H'IH ug= '  3>   H H1D HtH/u
HGHP0HtH+u
HCHP0D= H
 = 0  H/u
HGHP0L=W ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Hl$ AVH H@ E3H\$0E3HHt$8H
< H|$@ړHHu2H- H HC <   HE < '    HXHH
E H@ HAL   MtAx HHu'Hq HB <   .< '  H  HZ IH9C   H{H   HsHHHHH)uHAP0HHhHHu; #'  uH/u
HGHP0IH+u
HCHP0HHue  HHu]H HA ;   s; 5'  {HgHHuW; &'  Hx HA ;   HtD2HHHubHI HA t;   ; 7'  H+u
HCHP0HtH/u
HGHP0D>; H
 : -&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Ypt3H A^A\_^[Hl$PLl$`L|$hMu*HE E3H@ m:   9 &    4 LHu'H
 HN@ 8:   9 &  Z  IFHHHu-H
 L H[3 H	
 9 &    HAH; tWH; tNH HHuH
 H
? K9 &  ~  H@L   Mua,9 &  Q  H3E3H@ Mu>H H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA HHtNH+u
HSHR0IVLI3 uH/HGHP08 &  5  8 &  &  H
 L H1 H	N 7 &     i Ht H HH
!    H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$p.ILl$`H A^A\_^[6 &  3H H8= "7   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D6 H
 W6 Z)H\$Hl$Ht$H|$ AVH H: HH
6 E3
HHuH |&  H   H
4 HxHH5@ L5u> H-V= ( HHtzHIH_HG3HGt GpHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`HGh3 H+u
HCHP0HG&  HZ H; %5 5   A  H
 (H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtHxH  HH [H [@SH HYHtHixH  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@MG  LbIMt4HtH2  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@I$ HIMtHt*LH2 ILBM HD$@HH   HH2 ILB% HD$HHHtNHH  H IHD$(LL$@H Ld$ wOy
%     H\$HH|$@   H
 H HD$0   L
* HD$(L` H1- HD$    H	 %  OHzt}HFL
* H
/ LP HD$0H, HA HD$(H	HD$    ~ %  H* Hk8 U2   1 A  H
 $:HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HǄ$   HE3L|$0L|$8*HD$0L|$ L|$()HD$ EEAL|$PAL$   EHCHu'H HS7 =1   0 $  #  H6  LkL$   Lc Ld$XIE I$Ll$hLd$pIH
; RYHHu'H H6 0   `0 $    H@L   H3 HMtAV HHu'HO H6 z0   0 $    H+u
HCHP0HFL   Hu9 HMtA HHu'H H,6 0   / $    H.u
HFHP0IL$  LcH I9$h  HsH$  HS  LkHIE HIH)uHAP0MeH5 I9$u}H$   H$   H$   A   H$   Iy^HHu'H H[5 E/   . %    H.u
HFHP0IL$         LHu'H H5 .   }. %  c  HpIL$  H$   H IF E3II\HHu'He H4 .   ". %    I.uFIFIP0:IHZHHu'H HZ4 D.   - $    H+u
I$HP0HGH H;1  H; $  HG HHu*H H3 -   m- 9%  Me  H/u
HGHP0IHFL   MHAHMHtlA   HALHtXHAHiOy'H. Ho3 Y-   , A%    L).u
HFHP0IL$     H.u
HFHP0IWOuI;PH H3 ,   , I%  g  HOHtU~A   H& H
 H	 
HxOHh H2 ,   %, $%  M  H;u
Lw H_H_LsHHIH/u
HGHP0H\$PH\$xL$   L$   L$   MHHL$@&  HHD$0H;tTHT$0HRHL$0C"HD$0H@HD$0H HD$0H@L|$8HL$0HHD$0HHL$8HCHD$8HKH|$@HWHL$@!HD$@H@HD$@H HD$@H@L|$HH|$@HcH$   HHL$@n  HHD$ H;tTHT$ HRHL$ ^HD$ H@HD$ H HD$ H@L|$(HL$ HHD$ HHL$(HCHD$(HKLD$@MM H$   HL$@   DBoHL$@Ld$XIu2 Ht'Hy H0 *   6* j%  S  H  WH$   LD$ HT$0HyH$   HAH   E3Hm3 H
v- iXHHu'H H;0 %*   ) %     E33HMDH+u
HCHP0H H/ )   s) %     L$   Ht$P   HD$hH$   HL$pHL$XH\$xH\$PL$   L$   H$   HH$  LHtH+u
HCHP0HtH/u
HGHP0H$   Ld$XHtH.u
HFHP0MtI.u
IFIP0Ht$PL$   D) ( H
 AMtIm u
IEIP0MtI,$uID$IP0HtH.u
HFHP0HtH/uHGHP0LD$ MM H$   HL$ =   DBoHL$ zLD$0MM H$   HL$0   DBoHL$0IAHİ   A_A^A]A\_^[H\$Ht$WH IHHMt-IZ H~HMAuH\$0Ht$8H _HHHH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH  H@LE3L|$`L|$hL$   L$   L|$HL|$PHD$HL|$8L|$@HD$8L$   L|$(L$   EAW$   L$   Hq1 LCHH
+  HHtH  HtIH@XHHu'HQ H, |& x  & 3"  l  HGL   H( HMtA LHu'H H>, (& x  % 5"    H/u
HGHP0IFL   H#/ IMtA HHu'H H+ % x  V% 8"    I.u
IFIP0ML$P  LgHc I9$X  LwL$P  MC  H_IHHHH)uHAP0LcH I9$uuL$   L$   A   H$   H0THHu'H H+ $ x  $ L"    I.u
IFIP0ML$P        N HHu'Hw H* $ x  4$ Z"    LpML$P  IE Lh E3HHRHHu'H# Hd* N$ x  # `"  >  H.uFHFHP0:IHvPHHu'H H* $ x  # F"    H/u
I$HP0IHCH H;(  H;i   H LHu'Hk H) # x  (# "  n  H+u
HCHP0IFH   MIHIHtjA   IHHtWIH-Ey'H H3) # x  " "  
  M)&u
IFIP0ML$P     I.u
IFIP0MEuIEH H( " x  E" "    HKHtR~A   H H
 H	 
HxEH, Hm( W" x  ! l"  /  H;u
Hs H{H{HwH?HHH+u
HCHP0HHD$`H$   IHt$hH$   I  HH$   3A  HHcLH$   (  HH$   3A(  HHDdH$   M   E3H( H
$ OHHu'H H_' I! |    "  N
  E33Hq;H+u
HCHP0Hھ H' ! |    "  

  H   E3HG( H
$ NHHu'H H&   ~  I  "    E33H:H+u
HCHP0HH H& s  ~    "  x  Ha H$`  H( H9Au7Hϴ Hu'H H4&      "  #  H$   H
& _HHHu'H H%    m 
#    H@L   HN& HMtAc HHu'H\ H%     #  b  H+u
HCHP0HFH;    H;< t~HH$   LH HHu'H H,%     #    H@L   Mu?H H$    q #  
  HHMMHǄ$   H.u
HFHP0Mu?H@ IL|$0H9CuL;c   HCJ4L;c}zJtHI  HAHHD$0H   HtHH HH$t: *H H"$     1#  I	  H+u
HCHP0H$`  LHL;
۳ tRH;b tIMIL= H6 H
? H	 Hg H#    $ h#  	  HH$      HT$`HL$p  HHD$HH;tTHT$HHRHL$HHL$HHIHL$HH	HD$HH@L|$PHL$HHHD$HHHL$PHCHD$PHKH|$pHWHL$p4HD$pH@HD$pH HD$pH@L|$xH|$pHHT$hHL$p  HHD$8H;tTHT$8HRHL$8HL$8HIHL$8H	HD$8H@L|$@HL$8HHD$8HHL$@HCHD$@HKLD$pMM HT$ HL$p   DBoHL$p;H  HD$ LD$8HT$HHikLM   E3H% H
 JHHu'H H!    U #    E33H5H+u
HCHP0HT H!     #    IL|$ L$h  L;%   3 HHu'H  HA! +    #  0  ID$H; t~H; tuIH HHu*H H     n #  I  H@L   MuAHw H     4 #  Iz  II$IH$   MHMu@H
 H9FuH;N   HFH<H;N   H|HHH$   HAHHD$ H9  H$   H$   Ht
H)uHAP0HGL   H! HMtA HH   E3H  HGLHt~H/u
HGHP0IIHr  u5I.u
IFIP0ML$P  H$   IL|$    H HS =    #    H H,     #    HĶ H     #     HtEHz HHtͭ 'Ht H    1 #  z  H.u
HFHP0IL|$0H$   LcIu'H# Hd N    #  S  HT$pI^HXH+HHL$p1L;t|H$   HL$pJHH$   ڐHL$p " Ht'H H    [ $    H$   HL$pHIQjL$   H$   HIe^DH$   E  Hu'H) Hj T    2$  Y  HD$(HL|  HHu'H H.     >$    HD$(HH8H)uHAP0HD$(HX8H$   HtH9X(  HMtI/ZD$P  A HHu'H_ H     `$        HHu'H% Hf P    b$  +  HXH\$(HHX   E3H$   HL$`L$   Ld$hL|$(AH|$ L$P  Ht$0  E3H$   HL$`L$   Ld$hL|$(AAL$P  Ht$0  H$   LH$   HtH)u
HAP0LIIAL   H IMtA" HHu'H H\ F    A#  !  ML$P  H H9G   LwL$P  MttHwIHHHH)uHAP0IH6AHHu'H H    T N#     I.u
IFIP0ML$P  4H@HHu$HC H n     Q#  LH/HGHP0H$   HT$`E3H$   L$P  AAL|$(HT$hIHtH+u
HCHP0HtH/u
HGHP0MtI.u
IFIP0HtH.u
HFHP0D Q H
R MIH\$(HL$`Ht
H)uHAP0HL$hHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0HtH+u
HCHP0H$   HtH)uHAP0H$   Ht(H$   H\L$   L+IHLD$8MM H$P  HL$8g   DBoHL$8LD$HMM H$P  HL$H&   DBoHL$HsHH  A_A^A]A\_^[H\$UVWAVAWH`H` H3HD$XH5 WHt$PMHD$@Mq  LzIMt3Ht"HtHg  Hr(Ht$PHB HD$HHjHl$@Hl$@I  HIMtHt0HtKvH ILBC HD$@HH   HH ILB HD$HHt{HHv  H ILB HtHHD$PHHI  H IHD$(LL$@HM L|$ C-y
!     Ht$PHl$@  H
W H| HD$0   L
  HD$(L H
 HD$    H	 !  xHBH   H   HCH! 3HD$0HL
 L` HHH HD$(HL$ LMH
 Hz
 H	! !  Hͭ H  r   Ar  H
	 3!Hr(HB HjHD$HLD$HLH?HL$XH3"H$   H`A_A^_^]H\$Ht$WH H5 HH
H HLF# HHtH  H   H@HH   H H9CuHH HHuH
ɬ H
  !  .E3HH=HHuIH H ` !   p  H/u
HGHP0HtgH+uaHCHP0UH/u
HWHR0H+u
HSHR0HH\$0Ht$8H _H H^ H p  
 !  D7 H
 
  3H\$0Ht$8H _{@UVWATAUAVAWHl$H0  HEH$  H\ H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@HD$8ELd$HL#LcHD$P   AAAWEWMEHE   LeDeIEH; tsH;" tjILd$XIn LHD$`Hu'HҪ H  i        H@H   HD$hHuok    Q  MLl$`IE Ld$X3HD$hfD  Hu=HD I9FuM;f  IFJ<M;f  K|HILd$XIHHw  ILH}Ht
H)uHAP03HУ 98uIG      7  IEHHpHtHAHt
IIII55HH  H@L   H HMtA| HH  H/u
HGHP0HCL   H^ HMtA; HHA  H+u
HCHP0IEHHpHtHAHt
IIII|4HH  H@L   H. HMtAá HH  H+u
HCHP0   l HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM诐HHMS|HUHtLE L+IWEH] HUHtLEL+IE H  IHMHHM΍HM5W Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
!  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8H]HUHK@rmHKXHULt$`L}Ld$XLmHD$h9H H
ˠ H	  j  V !  33B   l  9 A!  )   l    @!    u k   .!     \ k   +!     C k   )!  3   ( k   &!  3   
 k   #!  3    k   !!  33s H   H
x LI;   HH    }      @t3HIH[      !  33o i  H, Hm
 MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
* 'H\$pc I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8HvMtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+Hsҙ H'vř HHE   HE    E HUHtLEL+I臹HUHtLEL+I辨LD$8MM HUHL$8t   DBoHL$8HHM(H3H$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  HS H3HE(LHUHHL$pHME3Dd$PLd$8Ld$@HD$8ELd$HL#LcgHD$P   AAAWEWMEHE   LeDeIEH;S tsH; tjILd$XIޚ LHD$`Hu'HB H
 m W   3     H@H   HD$hHuo 5   Q  MLl$`IE Ld$X3HD$hfD  Hu=H I9FuM;f  IFJ<M;f  K|HILd$XIHHw  ILH}Ht
H)uHAP03H@ 98uIG      7  IEHHpHtHAHt
IIII,HH  H@L   H	 HMtA HH  H/u
HGHP0HCL   H HMtA HHA  H+u
HCHP0IEHHpHtHAHt
IIII+HH  H@L   H	 HMtA3 HH  H+u
HCHP0   ܘ HHU  HxHp 33HL$HHD$HHtH)u
HAP0H3HHMHHMvHUHtLE L+I芵WEH] HUHtLEL+Ie H  IHMZHHM>HM襄ǘ Ha  L|$8II@8w   LeLuLm@ HO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
8  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8H]HUHK@b|HKXHUU|Lt$`L}Ld$XLmHD$h9HB H
; H	 4  X   e   33B    Z      )   Z         Y  w ~       Y  ^ {       Y  E y   3    Y  * v   3   } Y   s   3   b Y   q   33s H   H
 LI;   HH    }      @t3HAIH˗     P   33 W  H H MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
* H\$pcx I.u
IFIP0HD$8H\$pH;t>HHRHzHH@HH HH@HC    DD$0HT$8HnMtI/u
IGIP0HL$HHtH)uHAP0HEHrPHHMH=   r<tb HAH;rR H+HsB H'v5 HdHE   HE    E HUHtLEL+IHUHtLEL+IްLD$8MM HUHL$8ԯ   DBoHL$8!HHM(H3rH$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH   HEHX)p)xHdK H3HELL3H|$PH|$XHD$PH|$@H|$HHD$@H}H}HE   H}@}DH|$0L;=ڒ uEL͜ H: H
 H	2 H H$  	     `  L-$  H
 I HHu7 HuI'H H  	  J   _  HHDu$̒ Ht 	     N  H/u
HGHP0E,$L;= u>HJ H
ӓ H	 H H< & 
     6_  H\ I"HHu'H H   
  z   ^  HDu$ Ht 
  F   M  H/u
HGHP0El$L;= u>H H
 H	̐ H- Hn  X      h^  HV I."HHu'H H0        *^  HHM賗HHM}HM|  Ht   g    M  H/u
HGHP0IL$HEH;tIE3HUL;=% u>Hĵ H

 H	ԏ H5 Hv `      p]  H^ I6!HHu'H H8 "      2]  H8 H;uA   (HDy   x   L  H/u
HGHP0E+  H
S !HHu'Hg H  
  $   \  H@L   H HMtA LHuL 
     [  H+u
HCHP0IFL   HG IMtAĎ HHu'H H  
  z 	  [  I.u
IFIP0E3L;=S u0H H
; H	  
  .   H[  H  IrLHul 
     [  3HL$0LkH I9E -  HSHT$0H  H{HHHHH)uHAP0HT$0LoH I9E uYHULuA   HUH%HHu 
  b $  |Z  HL$0H)uHAP03HL$0      $ HHu'H
M H
 x 
  
 4  2Z  HL$0HH3HL$0Lp E3E3HHh$HHu2 
   :  Y  H.uEHFH9IH]"HHu 
     Y  I.u
IFIP0H+u
IE HP03HGH H;   H;O    H LHu 
   [  3H  H/u
HGHP0IFH   E3IH3HtPDnIHHt?IH"y  
   c  X  M).   IFI   I.u
IFIP0E3(uI 
  ` k  zX  HOHtF~A   H H
ˊ H	 
Hx 
   F  3G  H;u
Hw H_H_HsHHHH/u
HGHP0H]HuHHMHHL$PBgLEMM HT$8HM躦   DBoHMHHMHHL$@dLEMM HT$8HM臥   DBoHMŹIL$(HT$PFgIL$8HT$@dL;=  u@H߰ H
 H	ω H0 Hq [      3=W  H/ I/HHu)H H1       3V  H߈ H9GuwH (=* f.z*u( Ht   W   33E  H/u
HGHP0At$HL;=( u@H H
 H	׈ H8 Hy c      3EV  H I7HHu)H H9 #      3V  HHM躏HHMuHMu' Ht   n   33 E  H/u
HGHP0IL$XHEH;tIE3HUL;=( u@H' H
 H	ׇ H8 Hy c      3EU  H I7HHu)H H9 #      3U  H^Àu(6 Ht   }   33D  H/u
HGHP0A\$xL;=P u@H߯ H
8 H	 H` H       3mT  H I_HHu)H  Ha K      3-T  H膾Àu(^ Ht      337C  H/u
HGHP0A\$yL;=x u@HW H
` H	' H H    E   3S  Ho IHHu)HH H s      3US  H@L   H HMtA HHu+      3QB  H/u
HGHP0H&6 Ht'H H    o   R  H.u
HFHP03A\$|L;=D u>Hۯ H
, H	 HT H       cR  H5 IUHHu'H HW A      %R  HHMڋHHMqHM%qG Ht'HË H       Q  H.u
HFHP03I$   HEH;tIE3HU L;=9 u>H H
! H	 HI H t      XQ  H" IJHHu'H HL 6      Q  HsÀu2K Ht'HǊ H       P  H.u
HFHP03A$   L;=V u>H= H
> H	 Hf H    # #  uP  HO IgHHu'H( Hi S    %  7P  H
 HHu'H H.     '  O  H@L   H HMtA HHu   d )  >  H/u
HGHP0A   HH HHu   ! ,  8O  H.u
HFHP03H+u
HCHP03H訹DyC    /  k>  H/u
HGHP0EX%  L;= u>H H
 H	W H H    u <  N  HI IHHu'Hz H    7 >  N  H Hl HH9Gun HHu`    @  =  H/u
HGHP0H> H/ HH9Cu~ HHu    C  M  H+u
HCHP03HDu$ Ht   W F  <  H/u
HGHP0E$   L;=+ u>Hb H
 H	 H; H| f    S  JM  H I<HHu'H H> (    U  M  H H HH9Gu} HHu   u W  <  H/u
HGHP0H~ H HH9Cu4} HHu     Z  7L  H+u
HCHP03H)Du$ HtH    ]  p;  H/u
HGHP0E$   L;=~ u>H
 H
 H	]~ H H    { j  K  HO IHHu'H H    = l  K  H} Hr HH9Gut| HHuf    n  :  H/u
HGHP0HD} H
 HH9Cu{ HHu    q  J  H+u
HCHP0HGL   H$ HMtA} HHu   M t  9  H/u
HGHP0H} Ht}    w  &J  H+u
HCHP0A$   L;=| u>Hj H
~ H	| H H4       J  H I
HHu'H H    r   I  H{ H HH9Cu
Az HHu   -   DI  H+u
HCHP0Hy{ Hj HH9GuT
y HHuF      n8  H/u
HGHP0Hu$N| Ht      H  H+u
HCHP0A$   L;=i{ u>H H
Q} H	{ Hy H    6   H  H
 IzHHu'H; H| f      JH  HTz H- HH9Cu/x HHu!      G  H+u
HCHP0Hy H HH9Gurx HHu   ^   6  H/u
HGHP0Hiu$z Ht      2G  H+u
HCHP0A$   L;=y u>Hƥ H
{ H	y H H@ *      G  H I HHu'H H    ~   F  Hx H HH9Cu
Mw HHu   9   PF  H+u
HCHP0Hx H HH9Gu`
v HHuR      z5  H/u
HGHP0H@@u$Uy Ht
      E  H+u
HCHP0A$   L;=px u>Ho H
Xz H	x H H     =   E  H I	HHu'HB H m       QE  H[w H4 HH9Cu6	u HHu(       D  H+u
HCHP0Hw H HH9Guyu HHu    e   3  H/u
HGHP0Hpu$w Ht    "   9D  H+u
HCHP0A$   L;=v u>H H
x H	v H~ HG 1 !     D  H IHHu'H} H	  !     C  Hu H HH9CuTt HHu !  @   WC  H+u
HCHP0Hu H HH9Gugs HHuY !     2  H/u
HGHP0Hu$av Ht !     B  H+u
HCHP0A$   L;=|u u>Hˡ H
dw H	+u H| H  "  I   B  H IHHu'HN| H y "     ]B  Hgt H@ HH9CuBr HHu4 "     A  H+u
HCHP0Ht H HH9Gur HHu "  q   1  H/u
HGHP0H@@u$t Ht "  )   @A  H+u
HCHP0A$   L;=s u>Ht H
u H	s H
{ HN 8 #     A  H IHHu'Hz H  #     @  Hr H HH9Cu[q HHu #  G   ^@  H+u
HCHP0Hr H$ HH9Gunq HHu` #     /  H/u
HGHP0Hr H9CusHr (f.z&u$Os Ht #     ?  H+u
HCHP0A$   L;=hr u>H H
Pt H	r Hxy H  $  5 %  ?  H	 IyHHu'H:y H{ e $   '  I?  HSq H, HH9Cu.o HHu  $   )  >  H+u
HCHP0Hp Ho HH9Guqo HHu $  ] ,  -  H/u
HGHP0Hp H9CusHCq (f.z&u$q Hto $   /  >  H+u
HCHP0A$   L;=p u>H H
r H	p Hw H$  %   <  =  Ht IHHu'Hw H  %  b >  =  Ho H HH9Cu1n HHu %   @  4=  H+u
HCHP0Hio H HH9GuDm HHu6 %   C  ^,  H/u
HGHP0Hn H9CusHo (f.z&u$%p Ht %  l F  <  H+u
HCHP0A$   L;=>o u>H- H
&q H	n HNv H y &   S  ]<  H IO HHu'Hv HQ ; &   U  <  H)n H HH9Cu l HHu &   W  ;  H+u
HCHP0Hm H HH9GuGl HHu &  3 Z  *  H/u
HGHP0H~u$n Ht^ &   ]  ;  H+u
HCHP0A$   L;=m u>Hۚ H
o H	sm Ht H  '   j  :  He IHHu'Ht H  '  S l  :  Hl H HH9Cu"k HHu| '   n  %:  H+u
HCHP0HZl H+ HH9Gu5j HHu' '   q  O)  H/u
HGHP0Hu$/m Ht '  v t  9  H+u
HCHP0A$   L;=Jl u>H H
2n H	k HZs H  (     i9  H I[HHu'Hs H] G (     +9  H5k H HH9Cui HHu (     8  H+u
HCHP0Hj H HH9GuSi HHu (  ?   '  H/u
HGHP0Hu$k Htj (     8  H+u
HCHP0A$   L;=j u>H7 H
l H	j Hq H!  )     7  Hq IHHu'Hq H  )  _   7  Hi H HH9Cu.h HHu )     17  H+u
HCHP0Hfi H? HH9GuAg HHu3 )     [&  H/u
HGHP0Hh H9CusHi (f.z&u$"j Ht )  i   6  H+u
HCHP0A$   L;=;i u>Hʖ H
#k H	h HKp H v *     Z6  H ILHHu'H
p HN 8 *     6  H&h H HH9Cuf HHu *     5  H+u
HCHP0Hg H HH9GuDf HHu *  0   $  H/u
HGHP0HCL   H HMtAh HHuH *     4  H+u
HCHP03H胾DRh Ht *     /$  H/u
HGHP0E$   L;=mg u>H$ H
Ui H	g H}n H  +  :   4  H I~HHu'H?n H j +     N4  HXf H1 HH9Gu3d HHu% +     M#  H/u
HGHP0Hf Hl HH9Cuvd HHu +  b   y3  H+u
HCHP03He H9GuwHFf (f.z&u$f Htr +     "  H/u
HGHP0A$  L;=e u>H H
g H	e Hl H'  ,     2  Hw IHHu'Hl H  ,  e   2  Hd H HH9Gu4c HHu ,      !  H/u
HGHP0Hld He HH9CuGb HHu9 ,     1  H+u
HCHP03Hc H9GuwHd (f.z&u$&e Ht ,  m   !  H/u
HGHP0A$  L;=?d u>HF H
'f H	c HOk H z -     ^1  H IPHHu'Hk HR < -      1  H*c H HH9Gua HHu -        H/u
HGHP0Hb H HH9CuHa HHu -  4   K0  H+u
HCHP0H
 HHue -       H@L   Hx HMtAb HHu -     G  H+u
HCHP0A   HHa HHu -  n     H/u
HGHP0H.u
HFHP03Hy -  % 	  </  H+u
HCHP0  L;=a u>H( H
c H	a H	i HJ 4 .     /  H I
HHu'Hh H  .     .  H` H HH9CuW_ HHu .  C   Z.  H+u
HCHP0H` H8 HH9Fuj_ HHu'H#h Hd N .     2.  H.u
HFHP03Hu$Ta Ht	 .      -  H+u
HCHP0A$  ".  L;=j` u>H H
Rb H	` Hzg H  /  7 7  -  H I{HHu'H<g H} g /   9  K-  HU_ H. HH9Cu0] HHu" /   ;  ,  H+u
HCHP0H _ H HH9Fus] HHu'Hf H  /  Q >  ,  H.u
HFHP0H
 HHu /   A  +,  H@L   HE HMtA
_ HHu< /   C  +  H.u
HFHP0A   HH] HHu /   F  !  H+u
HCHP03H/u
HGHP0Hy'Hwe H  /  4 I  +  H.u
HFHP03+  L;=^ u>H H
_ H	] He HW A 0   V  %+  H IHHu'Hd H  0   X  *  H\ H HH9Fud[ HHu'Hd H  0  B Z  *  H.u
HFHP0H\ H' HH9Gui[ HHu[ 0   ]    H/u
HGHP0H\ H9FuvH\ (f.z4u2J] Ht'Hc H  0   `  )  H.u
HFHP0A$   *  L;=P\ u>H H
8^ H	[ H`c H  1     o)  HI IaHHu'H"c Hc M 1     1)  H
 HHu'Hb H(  1     (  H@L   H HMtA[ HHu 1  ^     H/u
HGHP0A   HHZ HHu 1     2(  H.u
HFHP03H+u
HCHP03H袒Dy= 1     e  H/u
HGHP0EA  L;=Z u>Hq H
\ H	QZ Ha H  2  o   '  HC IHHu'Hta H  2  1   '  HY Hn HH9Guh X HHuZ 2       H/u
HGHP0H8Y H) HH9CuW HHu 2     &  H+u
HCHP03H蠳Du$
Z Ht 2  Q     H/u
HGHP0E$   L;=%Y u>H H

[ H	X H5` Hv ` 3     D&  H I6HHu'H_ H8 " 3     &  HX H HH9GuV HHu 3  o     H/u
HGHP0HW H HH9Cu.V HHu 3     1%  H+u
HCHP03H#Du$X HtB 3     j  H/u
HGHP0E$   L;=W u>Hǆ H
Y H	WW H^ H  4  u   $  HI IHHu'Hz^ H  4  7   $  HV Ht HH9GunU HHu` 4       H/u
HGHP0H>V H HH9CuT HHu 4     #  H+u
HCHP0HGL   H HMtAV HHu 4  G     H/u
HGHP0HV Htw 4  	    #  H+u
HCHP0A$   L;=U u>H$ H
W H	U H\ H.  5     "  H~ IHHu'H\ H ھ 5  l   "  HT H HH9Cu;S HHu 5  '   >"  H+u
HCHP0HsT H HH9GuNR HHu@ 5  ҽ   h  H/u
HGHP0Hm@@u$CU Ht 5     !  H+u
HCHP0A$   L;=^T u>H̓ H
FV H	
T Hn[ H  6  +   }!  H IoHHu'H0[ Hq [ 6     ?!  HIS H* HH9Cu$Q HHu 6        H+u
HCHP0HR H HH9GugQ HHu 6  S      H/u
HGHP0HwR H9CusH9S (f.z&u$S Hte 6        H+u
HCHP0A$   L;=R u>H` H
T H	xR HY H  7       Hj IHHu'HY H ƻ 7  X     HQ H HH9Cu'P HHu 7     *  H+u
HCHP0H_Q H HH9Gu:O HHu, 7     T  H/u
HGHP0HP H9CusHQ (f.z&u$R Htк 7  b   y  H+u
HCHP0A$   L;=4Q u>H H
S H	P HDX H o 8   '  S  H IEHHu'HX HG 1 8  ù )    HP H  HH9CuN HHu 8  ~ +    H+u
HCHP0HO H HH9Gu=N HHu 8  ) .    H/u
HGHP0HMO H9CusHP (f.z&u$P Ht; 8  ͸ 1    H+u
HCHP0A$   L;=O u>H H
Q H	NO HV H ڸ 9  l >    H@ IHHu'HqV H  9  . @    HN Hk HH9CueL HHuW 9   B     H+u
HCHP0H5N HV HH9GuL HHu 9   E  *  H/u
HGHP0HM H9CusHzN (f.z&u$N Ht 9  8 H  O  H+u
HCHP0A$   L;=
N u>H~ H
O H	M HU H[ E :  ׶ U  )  H IHHu'HT H  :   W    HL Hֺ HH9CuhK HHu¶ :  T Y  k  H+u
HCHP0HL H HH9Gu{K HHum :   \  	  H/u
HGHP0H#L H9CusHL (f.z&u$\M Ht :   _    H+u
HCHP0A$   L;=uL u>H| H
]N H	$L HS Hƻ  ;  B l    H IHHu'HGS H r ;   n  V  H`K HA HH9Cu;I HHu- ;   p    H+u
HCHP0HK HԿ HH9Gu~I HHuش ;  j s     H/u
HGHP0HJ H9CusHPK (f.z&u$K Ht| ;   v  %  H+u
HCHP0A$   L;=J u>H?{ H
L H	J HQ H1  <       H IHHu'HQ H ݳ <  o     HI H HH9Cu>H HHu <  *   A  H+u
HCHP0HvI H HH9GuQG HHuC <  ղ   k  H/u
HGHP0Hu$KJ Ht  <       H+u
HCHP0A$     L;=aI u>Hy H
IK H	I HqP H  =  .     HZ IrHHu'H3P Ht ^ =     B  H
 HHu1 =  ñ     H@L   H, HMtAH HHu =  }     H/u
HGHP0A   HHG HHu =  :   Q  H+u
HCHP03H.u
HFHP03HDy\ =       H/u
HGHP0EO  L;=G u>Hpx H
I H	pG HN H  >       Hb IHHu'HN HԶ  >  P     HF H HH9GuE HHuy >       H/u
HGHP0HWF Hк HH9Fu2D HHu'HM H,  >       H.u
HFHP03HE H9GuwHF (f.z&u$G Ht >  J     H/u
HGHP0A$   L;=F u>Hv H
H H	E H,M Hm W ?     ;  H I-HHu'HL H/  ?       HE H HH9GuzC HHuԮ ?  f     H/u
HGHP0HD H HH9Fu%C HHu'HFL H q ?     U  H.u
HFHP03H%D H9GuwHD (f.z&u$^E Ht ?     ;  H/u
HGHP0A$   *  L;=rD u>Hqu H
ZF H	!D HK Hó  @  ?     Hk IHHu'HDK H o @     S  H
ű HHuެ   mH@L   HR HMtAC HHu   4H.u
HFHP0A   HHB HHuGo   ɬ @  E3HJ HĲ Hx  H/n  HGHP0_  H/u
HGHP0H+u
HCHP0Hz؅y'H%J Hf P @     4  H.u
HFHP03l  L;=B u>Hs H
D H	cB HI H  A       HU IHHu'HI HǱ  A  C     HA HЮ HH9Fuz@ HHu'H3I Ht ^ A     B  H.u
HFHP0H<A H HH9Cu? HHu	 A       H+u
HCHP0HFL   H HMtAA HHu'HzH H  A  7     H.u
HFHP03H A Hte A       H+u
HCHP0A$   L;=@ u>Hr H
B H	z@ HG H  B   (  
  Hl IHHu'HG Hޯ ȩ B  Z *  
  H? H HH9Cu)> HHu B   ,  ,
  H+u
HCHP0Ha? HR HH9Fu<= HHu'HF H6   B   /  
  H.u
HFHP03H軙u$&@ Htۨ B  m 2    H+u
HCHP0A$   L;=A? u>Hp H
)A H	> HQF H | C   ?  `  H IRHHu'HF HT > C  Ч A  "  H,> H] HH9Cu< HHu C   C    H+u
HCHP0H= H HH9FuJ< HHu'HkE H  C  ( F  z  H.u
HFHP03H1u$> HtQ C   I  
  H+u
HCHP0A$   L;== u>HVo H
? H	f= HD H  D   V  
  HX IHHu'HD Hʬ  D  F X  
  H< Hө HH9Cu}; HHuo D   Z  
  H+u
HCHP0HM< H HH9Fu(: HHu'HC H"  D   ]  	  H.u
HFHP03H觖u$= Htǥ D  Y `  p	  H+u
HCHP0A$   L;=-< u>Hm H
> H	; H=C H~ h E   m  L	  Hέ I>HHu'HB H@ * E   o  	  H; HI HH9Cu9 HHu E  w q    H+u
HCHP0H: H, HH9Fu69 HHu'HWB H  E   t  f  H.u
HFHP03Hu$; Ht= E  ϣ w    H+u
HCHP0A$   L;=: u>Hl H
< H	R: HA H ޣ F  p     HD IHHu'HuA H  F  2     H9 H HH9Cui8 HHu[ F       H+u
HCHP0H99 H§ HH9Fu7 HHu'H@ H  F       H.u
HFHP03H蓓u$9 Ht F  E   \  H+u
HCHP0A$   L;=9 u>H0k H
; H	8 H)@ Hj T G     8  H I*HHu'H? H,  G       H8 H5 HH9Cuw6 HHuѡ G  c   z  H+u
HCHP0H7 H` HH9Fu"6 HHu'HC? H n G      R  H.u
HFHP03H"7 H9CusH7 (f.z&u$[8 Ht G       H+u
HCHP0A$   L;=t7 u>Hi H
\9 H	#7 H> HŦ  H  A     H IHHu'HF> H q H     U  H_6 H HH9Cu:4 HHu, H       H+u
HCHP0H
6 H HH9Fu}4 HHu'H= Hߥ ɟ H  [     H.u
HFHP03Hm@@u$6 Ht H     (  H+u
HCHP0A$   L;=5 u>HLh H
7 H	5 H< H6   I       H IHHu'H< H  I  t     H4 H HH9CuC3 HHu I  /   F  H+u
HCHP0H{4 H HH9FuV2 HHu'H< HP : I  ̝     H.u
HFHP03H3 H9CusH4 (f.z&u$'5 Htܝ I  n     H+u
HCHP0A$   L;=@4 u>Hf H
(6 H	3 HP; H { J  
   _  H IQHHu'H; HS = J  Ϝ   !  H+3 H\ HH9Cu1 HHu      H+u
HCHP0H2 H HH9FuS1 HHu'Ht: H  J  1      H.u
HFHP03H:   3 H      H J  E3H: HC HtH+u
HCHP0MtI.u
IFIP0HL$0Ht
H)uHAP0HtH.u
HFHP0H
.e H+u
HCHP0A$   HMHt
H)uHAP0HMHtH)uHAP0HMLD$@MM HT$8HL$@.M   DBoHL$@kaLD$PMM HT$8HL$PM   DBoHL$P=aHMH3NL$   I[PA(sA({IA_A^A]A\_^]H\$UVWATAUAVAWHl$H   3LHt$0HuHt$(DHuDD/ Hu'H^8 H      j  #>  HD$0K/ Hu'H'8 Hh R     v  =  A$MoHD$ 2 HHu,H7 H\$ H"        =  H
. HBHHuܙ    n   	=  H+u
HCHP0H\$0LHʘ H. y    )   :  H/u
HGHP0AL$Mw>1 HHu/H7 HH\$ HX B    Ԙ   <  Hx LH. y       :  H/u
HGHP0IL$9HHu/H6 HH\$ Hמ     S   [<  H LH- y    #   9  H/u
HGHP0AD$H. HHu/H6 HH\$ HS =    ϗ   ;  H LH, y
       9  H/u
HGHP0AL$PcHHu/H5 HH\$ Hѝ     M   U;  H! LH}, y       8  H/u
HGHP0AL$x%cHHu/H5 HH\$ HO 9    ˖   :  Hw LH+ y	       
8  H/u
HGHP0A8t$y   IL$X7HHu/H4 HH\$ HÜ     ?   G:  H LHo+ y}       ~7  H/u
HGHP0A8$      I$   '7HHu/H3 HH\$ H1        9  Hќ LH* y    }   6  H/u
HGHP0H
1 $HHu/Hu3 HH\$ H     *   29  AL$|Mw, LHu'H
03 H
q [     
  8  H+ HKHL$8H9  LkM  H{HIE HHH)uHAP0H- HOHL$8H9   A   LmHUL}HHHuÔ    U !  7  Im u
IEIP0LI/u
IGIP0H+uHD$8HH P0H
 LH}ͼHH   H2 LH\$ HHP :    ̓ G  7     * LHu'H
1 H
       1  ;7  LhE3Lx IHLLHHuÓ    U 7  6  I.IFIIHHH}       6  H@HH$ L   MtA* HHu7    ɒ I  24  H/u
HGHP0A   HI( HHu     L  6  H+u
HCHP0H!a؅y    O N  3  H/u
HGHP0  IFIH< L   MtA-) HHu2H&0 LH\$ HH\ F    ؑ Y  5  H\$0LH H' y     [  3  H/u
HGHP0A$   L$@( HHu2H/ LH\$ HH˗     G e  $5  H LHw& y     g  2  H/u
HGHP0A$   L$HP( HHu2H	/ LH\$ HH? )     q  4  H LH% y     s  1  H/u
HGHP0A$   L$P' HHu2H}. LH\$ HH     / }  4  Hk LH_% ym       h1  H/u
HGHP0A$   L$X8' HHu2H- LH\$ HH'        3  Hג LH$ y    s   0  H/u
HGHP0L% HH $ y2Hd- LH\$ HH        2  A$   +[H\$ HHu-H- LHU H<    Ύ   2  H: LH# y    L   L0  H/u
HGHP0A$   C% HHu-H, LHʔ H    C    2  H7 LHs# y    L   L/  H/u
HGHP0A$   $ HHu-H, LH? H&       1  H LH" y    L   L.  H/u
HGHP0A$   -$ HHu-Hv+ LH H    -   
1  H LH]" yk    L   Lk.  H/u
HGHP0A$   M	% HHu-H* LH( H       ~0  HՔ LH! yߌ    Ln   L-  H/u
HGHP0A$   M}$ HHu-H^* LH H       /  HI LHE! yS    L   LS-  H/u
HGHP0A$   M# HHu-H) LH H       f/  Hō LH  yǋ    LV   L,  H/u
HGHP0A$   ! HHu-HG) LH Hl       .  H: LH.  y<    Lˊ   L<,  H/u
HGHP0A$  s! HHu-H( LH H    s   P.  H? LH y    L@    L+  H/u
HGHP0A$    HHu-H1( LHo HV     
  -  HD LH y&    L   L&+  H/u
HGHP0H
 YHHu2H' LH\$ HH ʉ    \   9-  A$   M  LLHu    '   ,  HS HKHL$8H9]  L{MP  H{HIHHH)uHAP0H! HOHL$8H9   A   L}HULuH$HHu     ,  +,  I/u
IGIP0LI.u
IFIP0H+uHD$8HH P0HGHH^ L   M   A       LHuu     <  +  LxE3Lp IHLLnHHu8    ʇ B  e+  Im u
IEIP0LDIHYHH     %  +   HHuȇ    Z H  (  H/u
HGHP0HF LHL$0x y     K  *  HLH\$(HHu
HCHP0H
_ 貯HHu*H% LHA +     W  {*  H@HHB L   MtA HHu    w Y  *  H+u
HCHP0A   HI HHu    4 \  '  H/u
HGHP0HTyk     ^  )  H+u
HCHP0tyA$  M3 HHu*H# LH*      i  d)  H LHL$    ޅ    p k  )  H
Ԍ 'HHu*Hx# LH     2   (  H@HHg L   MtA( HHuZ       (  H+u
HCHP0A   HI HHu       &  H/u
HGHP0HDSy    r   
(  H+u
HCHP0txA$    HHu*Hb" LH        '  H LHL$ J   T       ~'  H
J 蝬HHu*H! LH,        f'  H@HHE L   MtA HHuЃ    b   &  H+u
HCHP0A   HI HHu       $  H/u
HGHP0HQyX       &  H+u
HCHP0H
> 葫HHu*H  LH  
       Z&  H@HH9 L   MtA HHuĂ    V   %  H+u
HCHP0A   HI HHu       #  H/u
HGHP0HPyJ    ܁   t%  H+u
HCHP0L  H
m xHHu'H H
        D%  A$   M LHu    T   "  H LgI9$U  LwMH  H_HIHHH)uHAP0H	 LcI9$   A   LuHULmHYHHu3    ŀ   4"  I.u
IFIP0LIm u
IEIP0H/u
I$HP0HCHH L   M   A      K LHu    ?   !  LpE3Lh IHLL覮HHup       q!  I/u
IGIP0LIIH蒬HH!(       )!   HHu    L 
  +#  H+u
HCHP0H
, LH}0HHu*H LH     ;   "  H@HHP L   MtA1 HHuc    L~   a   H/u
HGHP0A   HI# HHu    L~   G"  H+u
HCHP0HGM؅y~    Lr~     H/u
HGHP0  H\$ L HHg  y*HV LH ~~    ~ )  !  Ll$0H IOHHu*H LHN 8~    } 2  !  H H] HHu~    L} 4    H/u
HGHP0H LI ~  }    LO} 7     H
 HHu*HW LH }    } K     H@HH L   MtA HHu9}    L| M  c   H+u
HCHP0A   HI HHu|    L| P    H/u
HGHP0HKy|    LH| R    H+u
HCHP0  H\$ L HH= W y*H, LHj T|    { ]    Ll$0H~ I%HHu*H LH$ |    { f  ^  H} H3 HHu{    Ll{ h    H+u
HCHP0HX~ LI y{    L){ k    H/B  HGH3  H
 ʣHHu*H LHY C{    z     H@HHr} L   MtA HHuz    Lz     H/u
HGHP0A   HI HHuz    LFz     H+u
HCHP0HH؅y}z    Lz   {  H/u
HGHP0L  H\$ L؄ HH  y'H H. z    y   m  Ll$0H| IHHu*H LH y    dy   '  H } H HHuy    L0y     H/u
HGHP0H| LIP y^y    Lx     H+u
HCHP0LH\$ H| LHL$0 7  H H x    x   T  H
U} HHHu2H LH\$ HH~ x    Kx   (  H@HH{ L   MtAA HHusx    x     H+u
HCHP0A   HI6 HHu0x    w   +  H/u
HGHP0H]Fyw    w      H+u
HCHP0+  IFIHx| L   MtAi HHu2Hb LH\$ HH} w    w     Lt$0LH8} I? yMw    v   t  H+u
HCHP0A$   M HHu2H LH\$ HH} v    v   a  Hz LI yv    Tv     H+u
HCHP0A$   M
 HHu2HG LH\$ HH}| gv    u     H=} LI) y7v    u   ^  H+u
HCHP0A$   M
 HHu2H LH\$ HH{ u    nu   K  H| LI
 yu    >u     H+u
HCHP0A$   L$Xw HHu2H0 LH\$ HHf{ Pu    t     Hx LI
 y u    t   G  H+u
HCHP0A$   L$P HHu2H LH\$ HHz t    Vt   3  HBy LI	 yt    &t     H+u
HCHP0A$   
 HHu2H LH\$ HHPz :t    s )    H~ LI y
t    s +  1  H+u
HCHP0A$   ?HHu2H LH\$ HHy s    Ds 5  !  Hu LIt ys    s 7    H+u
HCHP0A$   L$HM
 HHu2H LH\$ HH<y &s    r A    HTz LI yr    r C    H+u
HCHP0A$   3	 HHu2H| LH\$ HHx r    .r M    H| LI^ ylr    q O    H+u
HCHP0H
w 襚HHu2H LH\$ HH,x r    q Y    A$   M LHuq    vq [    H LgLI9$`  LoMS  H_HIE HHH)uHAP0H'
 LcI9$   A   LmHUL}HwHHuQq    p o  O  Im u
IEIP0LI/u
IGIP0H/u
I$HP0HCHHu HH\$(L   M   A      a LHup    Up     LhE3Lx IHLL輞HHup    p     I.u
IFIP0Lt$0?IH覜HH<p    o h  :   HHu/H
 LH\$ Hv o    o   n  Hq LI yo    ao     H+  HCHP0  H
t HHu2HP
 LH\$ HHu po    o     H@HH_w L   MtA HHu*o    n   Q  H+u
HCHP0A   HI HHun    yn     H/u
HGHP0H=yn    Bn     H+u
HCHP0  IFIH/s L   MtA  HHu2H LH\$ HHOt 9n    m     H|$0LHs H yn    m   +  H+u
HCHP0A$   L$@ HHu2H LH\$ HHs m    :m     Hq LHj yxm    
m     H+u
HCHP0A$   MD HHu2H
 LH\$ HH3s m    l     Ho LH yl    l     H+u
HCHP0A$   8HHu2Hu
 LH\$ HHr l    'l     Hp LHW yel    k     H+u
HCHP0H
n 螔HHu2H	 LH\$ HH%r l    k   ~  A$   L$8 LLHuk    kk     H HOHMH9`  LMS  H_HIHHH)uHAP0H HKHMH9   A   L}HULuHjHHuDk    j   E  I/u
IGIP0LI.u
IFIP0H/u
HEHH P0HCHHo H\$(L   M   A      U LHuj    Ij     LxE3Lp IHLL谘HHuzj    j   {  Im u
IEIP0L@IH蛖HH1j    i   2    HHu*H LHp i    i )  I
  Lt$0LHk I  yi    Vi +    H+u
HCHP0H
k HHu*HN LHo vi    i 5    H@HHs L   MtA  HHu0i    h 7  Z  H+u
HCHP0HL$(A   H  HHuh    }h :  	  H/u
HGHP0H7yh    Fh <    H+u
HCHP0  H
j HHu*H6 LHtn ^h    g I    H@HH5q L   MtA  HHuh    g K  B  H+u
HCHP0HL$(A   H  HHug    eg N    H/u
HGHP0H 6yg    .g P  
  H+u
HCHP0  A$     HHu*H LHXm Bg    f [  
  H k LI  yg    f ]  <
  H+u
HCHP0A$   O  HHu*H LHl f    Rf g  
  Hl LI  yf    "f i  	  H+u
HCHP0A$     HHu*H LHTl >f    e s  	  Hj LI   yf    e u  8	  H+u
HCHP0A$   K  HHu*H LHk e    Ne   	  Hp LI~  ye    e     H+u
HCHP0A$     HHu*H LHPk :e    d     H@o LI  y
e    d   4  H+u
HCHP0A$   G  HHu*H LHj d    Jd     Hvo LIz  yd    d     H+u
HCHP0A$     HHu*H LHLj 6d    c     Htk LI  -  d    c   ,  H
Hf KHHu*H LHi c    Vc     H@HHm L   MtAL  HHu~c    c     H+u
HCHP0HL$(A   H?  HHu9c    b   7  H/u
HGHP0Hf1yc    b   ,  H+u
HCHP0  A$   7  HHu*H  LHh b    :b     Hff LIj  yxb    
b     H+u
HCHP0A$     HHu*H  LH<h &b    a   v  H<h LI  ya    a      H+u
HCHP0A$   3  HHu*H|  LHg a    6a     He LIf  yta    a     H+u
HCHP0A$     HHu*H  LH8g "a    `   r  Hhk LI  y`    `     H+u
HCHP0A$   /  HHu*Hx  LHf `    2`     Hj LIb  yp`    `     H+u
HCHP0A$     HHu*H  LH4f `    _   n  Hj LI  y_    _ 	    H+u
HCHP0H\$ H|$(  H
%d HHu2Hi  LH\$ HHe _    _ '    H@HHc L   MtA  HHuC_    ^ )  j  H+u
HCHP0A   HI  HHuO _    ^ ,  LLH\$ H  Hd H8  H/.  HGHP0  H/u
HGHP0H,y^    %^ .    H+u
HCHP0Lt$0  LLi IH*d 4  y2H	  LH\$ HH?d )^    ] 9    L  IHh   y2H  LH\$ HHc ]    n] B  K  A$   )  HHu2Hr  LH\$ HHc ]    $] K    H|$ LHg HO  y]]    \ M     H+u
HCHP0A$     HHu-H  HH!c L]    H\ W  wH^d LH     \    f\ Y  LLH  Hb HtH+u
HCHP0H\$ MtI/u
IGIP0H|$(MtIm u
IEIP0MtI.u
IFIP0DP\ H
 [ NLt$0qH+u
HCHP0H_ HLI  Hy>H  LHb [    [ c  ^Lt$0H|$(HH\$ IIMtI.u
IFIP0HtH+u
HCHP0HMHt
H)uHAP0HtH/u
HGHP0HEHtH(u
HPHR0HH$@  H   A_A^A]A\_^]HUATAUAVAWHhH@  HEHXHpHx H H3HE8L3HL$XHL$`HL$hHL$pHE0   HM(MHE   HMMDDDH
VZ HAH;;  uE33觉+H;  uHA@t	3談E3H^ 芈HHu'H  H\` FZ y   Y   	  HHL$XLahA$AAD$AIL$eHHu'H  H` Y }   Y   	  LHL;
{  t;MIL H H
H  H	  Y }   ;Y     HKH)uHAP0HsIL$ HHu'H0  Hq_ [Y ~   X   	  LHL;
  t;MIL H! H
  H	)  Y ~   X   I  HK H)uHAP0Hs AD$8C(3  Hu'H  H^ X    PX   g  HHD$`I\$@I;\$H/  IE3D  HCH+HHHD$xHLL$@D$8  DL$0HD$(LL$ A   LD$xAQH)X HH  H   HHHD$hHt
H)uHAP0LGHG HE3AL;AL9G tHHGJ4I@HGHH  tE3HI;\$H,NHs  H] W    0W c  G  HL  H] wW    	W W     3  HHu'H  HV] @W    V v    I\$XI;\$`   D  HEH;tIE3HHMTH IE3HUHM<HE   LmDmIE3HUHMH  HD$(HM'  HHteHVH9V ~H HNHHJHNHH  uH/u
HGHP0I;\$`A2QV    U     8V    U   n  Ht$pH
A] |~HHu'H  H\ U    U     H@L   H^ HMtA  LHu'Hy  H[ U    6U     H/u
HGHP0     HHu'H/  Hp[ ZU    T     HHpHD$`H HG E3HH
^ JLHu'H
  H
[ U    T   Z  H/u
HGHP03IvH  H9.  I~H!  I^HHILH)uHAP0HsH8  H9u`H}L}A   HUH葃HHu'H2  HsZ ]T    S     H/u
HGHP03        LHu'H
  H
"Z T    S   `  Hx3Lx E3E3IHHHu'H  HY S    TS   +  Im uSIEIGIIHHu'HM  HY xS    
S     I/u
IGIP0I.u	HIP0E3L|$XIO0H)uHAP0I_0I$  tHHu-H  HY  S    R   E3E3N  IO@H)uHAP0I_@A$  AGHI$  HMYH
  HL$(H#  HHu-HV  HX R    R   E3E3  IOPH)uHAP0I_PI$  HHu-H  H@X *R    Q   E3E3x  IOXH)uHAP0I_X3<  HHu-H  HW Q    jQ   E3E3&  I$  I;$    HEH;tIE3HHMH IE3HUHMHE   HE    E IE3HUHMHu  HD$(HM"  LHt^HNH9N ~H HFL4HAHFIH  u#I.u
IFIP0I;$  :   sP   
gP   E3E3P    Hx  HV H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0MtI/u
IGIP0MtIm u
IEIP0DAP O H
H B3L|$XIO`H)uHAP0Iw`IIMtI/u
IGIP0HL$`Ht
H)uHAP0HL$hHt
H)uHAP0HL$pHtH)uHAP0HEHrPHHMH=   r<t8  HAH;r(  H+Hs  H'v  H:
HE   HE    E HMMHHM8H3L$@  I[8Is@I{HIA_A^A]A\]@SH H  HH HI`H)uHAP0He  HC`3H [@SH HC  HH HI`H)uHAP0H%  HC`3H [H\$WH LJHL;
  HtrH;  tiH
  L MIH) H	@  H  H2T N [   M m  m  H
Z
 A[   @H\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH H  HH HIXH)uHAP0H  HCX3H [@SH H  HH HIXH)uHAP0H  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H  HH HIPH)uHAP0H  HCP3H [@SH Hs  HH HIPH)uHAP0HU  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0H  H)t$ H9BurHu  (f.5 zTuR  HtGHd  HP J X   !J j  j  H
=	 AX   =(t$ H0[sH3(t$ H0[KH(AH  Hu;H  HP  J X   I G  G  H
 AX   <3H(H(AH)  Hu;Hu  HO I X   2I G  G  H
 AX   #<3H(@SH H  HH HI@H)uHAP0H  HC@3H [@SH H  HH HI@H)uHAP0H  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H  HH HI8H)uHAP0H  HC83H [@SH Hs  HH HI8H)uHAP0HU  HC83H [H\$WH LJHL;
  HtrH;  tiH
  LP  MIH H	p  H!  HbM LG V   F     H
 AV   9H\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H#  HH HI0H)uHAP0H  HC03H [@SH H  HH HI0H)uHAP0H  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H+  H)t$ H9BurH  (f.5} zTuRX  HtGH  HK D T   D     H
 AT   7(t$ H0[s(3(t$ H0[KH(A(  Hu;HE  HJ pD T   D     H
  AT   63H(H(A(  Hu;H  H&J D T   C     H
^  AT   63H(@SH Hc  HH HI H)uHAP0HE  HC 3H [@SH H#  HH HI H)uHAP0H  HC 3H [H\$WH LJHL;
  HtrH;  tiH
  Lp  MIH  H	   H  HI B S   B     H
  AS   5H\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH H  HH HIH)uHAP0H  HC3H [@SH H  HH HIH)uHAP0Hu  HC3H [H\$WH LJHL;
X  HtrH;<  tiH
+  L  MIH  H	  HA  HG lA R   @     H
z  AR   3H\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;q  AE3H;+  A3H;n  DEuH  DEEtR  HtGH  H[F E@ Q   ? 
  
  H
  AQ   2H\$0H _È_3H\$0H _;H(y tH  H H  H  H H  Hu;Hv  HE ? Q   3? 
  
  H
  AQ   $23H({H\$WH HH0؃uOv  HtDH  H3E ? P   > 
  
  DCQH
  1H\$0H _É_3H\$0H _kH(IL$0  Hu;Hc  HD > P    > j
  j
  H
  AP   13H(H(IL$0G  Hu;H  HDD .> P   = j
  j
  H
\  AP   03H(H\$Hl$Ht$WH H3H
  3HAH;k  uE33l+H;  uHA@t	3jH:A E3kHHu'HK  HC v= q   = 
  O  HCHH@ L   MtA  HHu< 
     H  H9C  H{H  HsHHHHH)uHAP0HH9iHHuH
  H
B a< 
  QH/u
HGHP03H+u
HCHP0   "  HH   < $
  H=  H~B h< q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HWHR0D< H
  ; .3cHgHH6y;  
  XH
}; HHHHh Hp(H
O  HH
E  HH0H
:  HH
0  HH8H\$0Hl$8Ht$@H _{@UAWH8HBE3H;  AH\$PAHt$XH|$`Ld$0Ll$(LLt$ LtdH;  t[HH`  HHu'H  H
A : m   :     H@L   Mu^g:   i  HIIMMu>HR  H9GuH;w  H_HHH)H;w  H\HHHAHH   HHHt
H)uHQR0IFHHpHtHAHt
HIHIfcHHtFLHI  tH+BHCHP039 n   u9      9 n   \9   k  H   H
T  LI;   HHD9   }      @t3H"IH7  ug8   S9 m   H  HQ? HtH/u
HGHP0HtH+u
HCHP0D9 H
a  8 +   H/u
HGHP0L=w  ILt$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A_]Hl$ AVH H< E3H\$0E3HHt$8H
T7 H|$@誒HHu2H-  H  H5> 8 f   HE 7     HXHH
JB H< HAL   MtA  HHu'H  H= 7 h   N7    H  Hz  IH9C   H{H   HsHHHHH)uHAP0HHcHHu6 -  uH/u
HGHP0IH+u
HCHP0HHue  HHu]H  H= 7 i   6 ?  {HbHHuw6 0  H  H< 6 h   HtD2HHHubHi  H< 6 i   &6 A  H+u
HCHP0HtH/u
HGHP0D^6 H
  5 (&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Ypt3H A^A\_^[Hl$PLl$`L|$hMu*He  E3H; 5 i   5     T  LHu'H-  Hn; X5 i   4   Z  IFHHHu-H
  Lj  H{. H	*  4     HAH;  tWH;  tNH;  HHuH
  H
: k4   ~  H@L   MuaL4   Q  H3E3H@ Mu>H4  H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA  HHtNH+u
HSHR0IVLI3  uH/HGHP003   5  !3   &  H
  L
  H, H	n  2        Ht H  HH*   <  H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$pNILl$`H A^A\_^[1   3H  HX8 B2 i   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D1 H
-  w1 z$H\$Hl$Ht$H|$ AVH H75 HH
E0 E3݉HHuH    H   H
/ HxHH5; L59 H-v8 H  HHtzHIH_HG3HGt GpHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`HGhS  H+u
HCHP0HG  Hz  H6 E0 0 i   Ai   H
  1#H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtHo  HH [H [@SH HYhHtHio  HH [H [H(HB      tHAL   MtAI  Hu;HE  H5 p/ `   /     H
.  A`   !3H({H   HD$ R  Ht
33@HĈ   H(HHH]  ȅx3H(@WH@HD$ H\$XH]} H3HD$0HHL$(LL$xHAHyrH	HH;}HH33I  E3MtAD  HHQHHL$0H3H\$XH@_LAL9A ~HHAJI@HA3H%  LYE3HA EHL;AL9Y AEtHHAJICHA3H%    HUHhH   HEHXHpHx H| H3HEGHHM3u
E   HE   Hu@uDFH  HMCHE   Hu@uDFH  HMHuHE   Hu@uIE3HUHM%HE7   Hu/@uIE3HUHM HUH   ϋHM襯HM蜯HEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  HHE   HuE HEHrPHHMH=   r<t  HAH;r  H+Hs  H'vx  HHE   HuE A   HJ  HMHE   HuE A   H7  HME   E   HE   HuE IE3HUHMHE7   Hu/E IE3HUHMrHUH   AHMHMHMHMHHMGH3KL$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+H'HCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;v  H    H=   r<t  HAH;r  H+Hs  H'vx  HH3HsHsHH\$@Ht$PH0_@SH H_ H;"HH  ,"HH& "HH* >&HHT(v  H H!HH  !HH !HH* %HH(*  H H!HHY  !HH !HH[) %HH'H [H%ع  H(H)  @!HH'H(H%  @UVWATAUAVAWH$H@  Hǅx  H$  Hv H3H8  LD$pHT$PHMH  L  ML  MLt$hHM*WD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
a ˶  H
S   3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM3H]Mt`IrAfoF^ IHfHnflfHAfHnflfLHH;rI;s     HHI;rL% L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH  H H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  "H£ H   L   L  L   L   HUH   ǡL   H   H   H   H   XE3AL}H   H   HMI+HL   H;vdM9s
HH;rbH  HD$x3HEHEH HD$XD$`HUHL$X  H HD$xH=/ HL$x	H
 
  H HE Lu(Le0HEH+HHE8HUHM@ŠLE0HU8HMXHU8H   bILuHU8H   HMI+HLE(H;vdM9s
HH;rbH  HD$x3HEHEH HD$XD$`HUHL$X#  H HD$xHP. HL$xH
    L%  LeHT$hHULmH  HEWD$PWM LmLD$PHM   NHHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  ;H H  HE(H  HE0H  HE8H  HU@H  H  HD$XL%/ L  HE`H   HEhH  HEpH  HUxH  ?H   H0  蛞H[ HH  H   HP  H   HX  H   H`  H   Hh  OH  HD$XL  H   H  H   H  H   H  H  H  莎H   H  H H@  HH  HD$XL% LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX  Ld$xH  HEHE   LmE IE3H  HMhH  HD$(H  HD$ LH  L@  HT$xHHHU HtLEL+IhH   Ht%L   L+IHWf   L   HMXHU@HtLEPL+IWfE@LmPL%A Le H   Ht%L0  L+IWf   L0  H    H   Ht%L   L+IWf   L   L   L-Q L  H  ޡL  L  L  H  轡L  MtLEM+II.HtH+HLHMtLEM+IIHH8  H3H$  H@  A_A^A]A\_^]@SH H8 HD$0H+8 H
8 HH\$0H;sSH8 HT$0H;wBH\$0H+HH;
8 u   H
x8 kH
t8 He8 Ht9HH)H;
`8 u   H
B8 5H
>8 Ht
HH
/8 H@: HD$0H+,: HHH

8 H
68 H\$0H;sSH8 HT$0H;wBH\$0H+HH;
8 u   H
7 H
7 H7 Ht9HH)H;
7 u   H
7 H
7 Ht
HH
7 H9 HD$0H+9 HHH
7 H
9 H\$0H;sSH8 HT$0H;wBH\$0H+HH;
8 u   H
8 H
8 H8 Ht9HH)H;
8 u   H
8 H
8 Ht
HH
{8 HHh7 H
i8 H
r7 H^7 H
w7 HC7 H
|7 H [HXHe6 H9V6    HRH
%6 H\$PÆHl6 H
E8 H--6 HR褆H-L6 L]8 H
7 IHD8 H+HHYH;s>@ HHtH   L8 H8 IHH+HH;rH
n7 HQ-H-]7 H\$PHXHH  D$(HD$0HT$83HL$ HD$8HD$@HI  HD$   H H ) HD$0HL$0HXH%5 H95    H4 LR7 HC7 H4 H7 H7 IH+H\$PH3Ht;     HHtH   L6 H6 IHH+HH;rH5 H\$PH6 H/5     HH
5 H.5 H HH5 HXH
  D$(HD$0HT$83HL$ HD$8HD$@H  HD$   HԢ H' HD$0HL$0|H\$WH H      ?HAH
3 H9
3 H3 u	H=3 HIHH+3 HHkHH<H;sfD  HKHHPH;wH\$0H _H93 H+*3 H
K3 HH+AH)3 H93 @WH H
    HHu H
  H  H	v  H _H  H\$0H  H/Hu
HWHR0Hu%H
A  H  H	)  H\$0H _H$  H9Ct9H
  H  H	  H+  HCHP0H\$0H _3H  H+HG uHCHP0H4 Hu%H
X  H  H	  H\$0H _=	  H tA	  H  %  
H s4  A
   H  H
  DH	٬  H\$0H _  u	H  t%H$  H
  H	  H\$0H _3H\$0H _3H%  H(Hu           H(HtIw  3H(3HtIv   "     "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[HHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHH6H\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=Ac      Hh)|$@)t$Pf( f( fYf(% f(
 f\v ff(fXf~Ё  fYf@  fY8 fff\L      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfX fX| fYfYfYfXfXT ffXfY(t$P(|$@Hhf     ??f\f(^ fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0L f(5 f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(: ffM ff(5! ff5$ fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5m ff5P  A~0  fA0  fff(5 ffffYf(t$P(|$@Hh     HH)|$ )t$0f( f( fYff(% f(
 fXf:	 f(f~Ё  fYf@  fYJ fff\L      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfX fX fYfYfYfXfXf ffXfY(t$0(|$ HHfff     ??f\f(n fsA~$ L f(5A f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(j ff} ff(5Q ff5T fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$0(|$ HH     %"  %  %  %x  %¡  %t  %v  %x  %z  %|  %~  %  %  %  %.  ff     @UH HE t
e HMPH ]@UH HE t
e HMpH ]@UH HE t
e HMP躐H ]Hp  tHp  阐Hp  \Hp  逐HH   vHp   8Hp  \Hp   Hp  DH`   H`   HH`   HH`   H(tvH`   H@rH`   HXTvHH   trH@   D}HH   8}H(   餏@UH HE t
e HMHuH ]@UH HE t
e HMHqH ]H8   4@UH HE te H   xH ]HP   HP  H`   DuH`   H4uH`   HH$uH`   H`uH`   HxuHP   tH@   dH`   THX   DH   @UH HE te HM`H   Ȝ  H ]H`   HH%   H`   HP  H@   H@  ȍH   H   HH   H   HH0   H0   HP   H    H@   HH   H   6H   XH   LHP   @HP   4H@   (H@   H(   鴌H(   騌H(   sHP  鄌H0  HH0  lH0  0H0  TH0  HH0   H0  0H0  $HP  H0  H0  H0  H0  H0   H0  ̋H0  H`   HP   HH`   HP   HH`   Hh   H`   HHh   H`   HHh   |H`   H0lH(   HH   H(   HH   H`   $THp   H`   H@H@  養@UH HE te HM@H   ,  H ]H@   H H%T  H0   H%  H@   H@  >HT$UH HLE0H HMH
Lo HHMhHMHHEhH   HCEhH
A  HMH3HMPHMXHE0E8HUPHM0Ř  H HEHA   H HMHHH   釉Hh   {HH   HT$UH HLE Hн HM8
Lg HHMXHM8!HEXH}pHCEXH
t  HM83HM@HMHHE E(HU@HM   Hђ HE8A  H HM8H8   麈HX   鮈H8   HT$UH HLE H HM8_L HHMXHM8aHEXH}pHCEXH
  HM83HM@HMHHE E(HU@HM 8  H HE8A  H HM8H8   HX   H8   "Hp   ԇHP   HT$SUH(HHMHHHPHH;uHAHP HHEHLE0I H H   OL HHMPLHHMpHMPAH   4HEpH   HCEpH
  HMP3HMXHM`H   ƅ   HUXH     Hؐ HEPA@  H HMPH   HP   鵆Hp   驆HP   H   dH   H$H   HDH   H(lH   H@hH   HXlH   XgH   lHh   hH8   oH   H   \lHh   PlH8   oH   ȅH0   H(   H(   HP   \H   @UH HE0te0H   H ]H   ?H   3H   'H`   kH   HT$SUH8HHǅ      Hǅ       ƅ    A4   H H   H]8HH   HP@H   詄Hǅ      Hǅ       ƅ    A   Hw H   HH   HP@H   UH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   HG  HEH3HEPHEXHں HE8E@HUPHM8Ē  H] HEHHB HMHH   錃H   逃H   t@UH HE0te0H   H ]H   ;H   /H   #HH   iH   Hx   oiHT$SUH8HHǅ      Hǅ       ƅ    A*   H H   ˾H]8HH   HP@H   虂Hǅ      Hǅ       ƅ    A   Hg H   sHH   HP@H   EH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   ցH7  HE`3HEhHEpHʸ HE8E@HUhHM8  HM HE`H2 HM`H   |H   pH   dHT$UH0HHǅ      HEx    Eh A/   HǸ HMh6HM0HHUhP@HMh
Hn  HEH3HEPHEXH HE0E8HUPHM0  H HEHHi HMHHh   鳀HT$UH HHEh   HE`    EP A/   H HMP艼HM HHUPP@HMP`H  HE03HE8HE@HT HE E(HU8HM >  Hד HE0H HM09HP   H(   HP  H0  H0  H0  H0  H0  HP  HP  HP  H0  HH0  <H0   0HP  TH`   4H   HH   xH   H@hH0  H0   H0  ~H(   ~H(   ~H(   ~H(   ~H(   ~H(   ~H(   ~HP   DH   
H   
H   
HP   
HX   x
H`   d
H`   HT
H@   D
H@   8
H    ,
H     
H   
Hx   xqHH   DH@   	HP   $H   	H   	H0   	H0   	H    	H    	H  t	HH   H@   XH8   LHX   HP   H0   H    H0   HH0   H8\H0   HpH0   H   H    mH@   THH   HH@   4H@   H bHH   H@   H8@UH HE$t
e$HMPXH ]H   {HX   HX   H@   H    XH`  {H@  {H@  {H@  x{H@  l{H@  `{H@   锽H@   t)H@   H0aH@   HHaH@   H`aH@   H   qaH@   H   dH@   H   +H@   H   8aH@   H   %aH@   H   RdHp   4]HX   `H  |zH  pzH   dzH0   `H  LzH  @zH   4zH  (zH0   `H  zH  zH   yH  yH0   P`H  yH  yH   yH  yH0   `H  yH  yH   yH  tyH0   _H  \yH  PyH   DyH  8yH0   _H   yH  yH   yH  xH0   `_H  xH  xH   xH  xH0   $_H0   _H  xH  xH   xH  xxH0   ^H  H  TxH  HxH   <xH  0xH0   ^H  xH  xH    xH  wH0   X^H  wH  wH   wH  wH0   ^H  wH  wH   wH  |wH0   ]H  dwH   ]H  `HT$UH0HH   L H   =H   H`   t]H`   JHH   \]H@  YH0  vH  vH  vHP  vH  vH0  ]HT$UH0HHǅ(     Hǅ       ƅ   A   H1 H  eH8  HPLH  H  HH  葹HB H  4H  vH  uH  uH  uH  uHP  uH  uH0  \HT$UH0HHǅ(     Hǅ       ƅ   A   H~ H  zH0  HPLH  H  HH  覸HW H  IH  uH  
uH  tH  tH  tHP  tH  tH0  2[H0  &[HT$UH0HHǅ(     Hǅ       ƅ   A#   H H  胰H  HPLH  H  HHX  请H` HX  RH  tH  tH  tH  sH  sHP  sH  sH  ;ZHT$UH0HHǅ       Hǅ(      E33H  A'   H" H  莯H(  HPLH  H  HH  躶Hk  H  ]H  *sH  sH  sH  sHP  rH  rH  rH  FYH  :YHT$UH0HHǅ       Hǅ(      E33H  A"   Ha H  荮H   HPLH  H  HHp  蹵Hj Hp  \H  )rH  rH(   rH(   qH(   qH(   qH(   qH(   qH(   qH(   qH(   qH    dHH  qH(  |qHh  pqH(  dqH  XqH(  LqH  @qH(  4qH(  (qH(  qH(  qH(  qH(  pH(  pH(  pH(  pH(  pH(  pH0   tHP  pH0  pHp  pH0  tpH  hpH0  \pH  PpH0  DpH0  8pH0  ,pH@   HVH@   H pVH@   H@YH@   HXdH@   HoH@   H(p@UH HE t
e HMHdH ]HT$UH0HHM8HPH
ڇ  HMh3HMpHMxHE@EHHUpHM@^~  Ho{ HEhHd HMhYH   UHP   UH   ܿH   oH8   Q@UH HE4te4H   AUH ]H   $UHH   UH   lH  nH0   $QHh   T@UH HE@t
e@HMxTH ]H   H  2nHH   PH`   H8   P@UH HE0te0H   UTH ]H`   H`   Hp4H`   H  bH`   H  nMH`   H  {bH`   H  HMH`   H  SH`   H  OH`   H0  /bH@   bH    bHH   l@UH HHU@HMHʯH ]@UH HHU@HMH讯H ]HT$SUH8HH]PHHtJHS=1HKH+H*HHLI?LH賉H    HC    HC    33iHT$SUH8HH]PHHtJHS6HKH+H*HHLI?LHCH    HC    HC    33HT$SUH8HH]PHHt3HSm2HLCL+IڙH    HC    HC    33蠮HT$SUH8HH]PHHt3HS
2HLCL+IzH    HC    HC    33@H`   k@UH HEhtehHMPH   y  H ]HP   H H%x  HX   H%Zy  @UH HEPtePHM@H   8y  H ]H@   H H%`x  @UH HEPtePHM@H   x  H ]H@   HH%Px  H8   LHT$SUH8HH]PHHtJHS.HKH+H*HHLI?LH#H    HC    HC    33٬HP   HP   H DSH(   OHT$SUH8HH]`HHtJHS]3HKH+H*HHLI?LH胆H    HC    HC    339H@   iH(   H@   H%w  HT$UH HHUhHUhHsHExH{H ]HT$SUH(HH]`HCHr\HHHvy  H=   r<ty  HAH;rx  H+Hsx  H'vx  H	HC   HC    H{rH 339H(   H(   HT$UH HHUpHHcHHA   t  HH ]H(   DH(   阜HT$UH HHUpHHcHHA   /t  HH ]H(   H(   HHT$UH HHUpHHcHHA   s  H{H ]H@   $H0  gHh   DH`   8Hh   ,H`   HHh   H`   H( H(   4H(   8~HT$UH HHUPHHcHHA   s  HiH ]H(   锨@UH HE t
e HM@0fH ]H   \H   \H   DH8   4HP   U@UH HE0te0HMPH   Xt  H ]HP   H H%s  H@   H%*t  HP   FHP  jeHT$UH0HHjH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH
H0]HT$UH0HH*H0]HT$UH0HHJH0]HT$UH0HHjH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]H  $JHp   XMHP   JH  VH  $F@UH HEDteDH  H   	r  H ]H  H H%1q  Hh   H%q  H  H  c@UH HEDteDH  H   q  H ]H  H H%p  Hh   H%rq  H  鎳H  b@UH HEDteDH   H   7q  H ]H   H H%_p  Hh   H%	q  H   %H  IbHT$UH@HH  萱LU@H   =H  H  DH   QH  QH  QH0  餲HP  aH  H  H  T@UH Hp   H  bH ]H8  xVH  霥H   PH   GHP  xH   GHP  0VHh  $VH   aH   aH   aH   dGHp  XGHP  `H  `H0  `H0  鈱Hp  `H0  PJHp  UH  `Hp  ,JH0  FHP  FH8   FH   8HT$UH0H33SH8   FH   HT$UH0Hv33H8   DFH   鸢HT$UH0H633ӢH8   FH   xHT$UH0H33蓢H`   锡H`   鈡H   EH`   pH`   dH   EH`   LH  pEH`   dEH   XEH   LEHx   @EH(  4EH(  (EHT$UH`HHP  L HH  詾HP  @UH HE t
e HM0PSH ]H8   >^HH   G@UH HE te H   =H ]H0   @H0   @@UH HH   H   跠H ]@UH HH   H   蕠H ]H`   H%zj  HP   H%jj  @UH HEPtePHM@HP\H ]@UH Hꋅ   t   HM(HP&H ]@UH HX   HM@єH ]HT$SUH8HH]PHHtJHS&HKH+H*HHLI?LHyH    HC    HC    33詟@UH H0   H   >H ]@UH Hꋅ   t   HM(i  H ]H   H%i  @UH HEHteHHM@H   j  H ]H@   H H%i  HP   H%zj  H8   @UH HEPtePHM@HP謵H ]H@   THT$SUH(HH] HKk  HK k  HK(k  33mHT$SUH8HHU0HM8!LE@HU8X335H@   H@  ZH0  H   Z@UH HE@te@HM`H   Xi  H ]H`   HH%h  HH   H%*i  H`   H`  jZ@UH HE@te@HP  H   h  H ]HP  HH%Gh  HH   H%h  HP  H@  ZHP   DH   d@UH HE te HM0HPгH ]H0   .H8  "GH0  GH0   JEH
K J@UH HX   H@  <H ]@UH HE te H@  HPGH ]H   H鑴H   t@UH HE te HM0HP H ]H0   >H8  RFH0  FFH0   *EH
 z@UH HX   H@  lH ]@UH HE te H@  HPwH ]H   HH@   :H0   8@UH HE te HM`H   f  H ]H`   H H%e  HP   H%f  H`   骨H`  WH`   T:HH   >H   WHP   $:@UH HE@te@H   =H ]H   9Hx   =H  HT$SUHHHHǅ     Hǅ      ƅ   E3Hp  H  H   HH  HP H  VHǅ     Hǅ      ƅ   An   H  H  蠒HH  HP H  rVH   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  1HH  HP H  VHǅ     Hǅ      ƅ   A   H  H  ݑHH  HP H  UHǅ     Hǅ      ƅ   Ah   H  H  艑HH  HP H  [Us
 E@H~HH][H  3UH  'UH  UH  UH  UH  ǥHH   IH  TH  C;H  闥H   鋥H  ;H  sH   47H`   :H  LH  pDH  H(  DH   H  eAH  	H@   -IH  !TH   :H  ٤H  SH  H  SH  I:H  靤H  1:H  酤H  SH  SH  SH  SH   6H`   9H  ,H  PDH  HH  CH   H  u@H  H@   
HH  SH   e9H  鹣H  RH  顣H  RH  )9H  }H  9H  eH  RH  }RH  qRH  eRH  4H   8H  |H   H   tH   Hx   GH   ĪH   鴪HP  t4Hp   88H   H   0?H  D4Hp   8H   H   _HP  4Hp   7H   H    ?H  3Hp   7H   lH   `XH   3H   x7HX   EH   PHx   4Hx   (H8  鴓H8  験HH  7H   7H8  鄓Hx   6H   6H  6H   6H   6H   6H   6H  H   (PH  H   PH  ԠH   OH  鼠H   OHT$UH`HH  'L H  ѯH  DH@  鄒H@  xHH  5H   5Hp   5H   5H  5H   5H   5H   5H   5H  H   OH  ȟH   NH  鰟H   NH  队H   NHT$UH`HH  L H  譮H   HP   4Hh   4@UH HEDteDH  H   \  H ]H  H H%\  HH   H%\  H  ۞H   M@UH HEDteDH  H   \  H ]H  H H%[  HH   H%V\  H  rH  M@UH HEDteDH  H   \  H ]H  H H%C[  HH   H%[  H  	H  -M@UH HEDteDH   H   [  H ]H   H H%Z  HH   H%[  H   頝H  LHT$UH@HH  LU@H   踬H  +H@   2HX   2H   2HT$UH@HH   裛L  H   MH   HT$UH HHU HMP33#HT$UH HHU HMP33@UH HHUPHMX蚎H ]HT$UH HHUPHMh33觎@UH HE0te0HM@H   Z  H ]H@   HH%`Y  H@   DH0  (KH   CH   CH  JHx   tH  JH  頛H  JH`   (1H  L-H@   1@UH HE\te\H   H   %Y  H ]H   H H%MX  H  H%X  H   H  7JH  H  H  JH(   JH(   IH(   IHp   $H   H(   IH(   IH(   IH(   IH(   IH   H  H0  H  H   H   H   |Hx   pHh   dHh   XH   DH   8@UH HE te H   m2H ]H   DrH   8rH   ̊HX   PH  tHH  hHH8  qH  qH@   H  qH  qH@   pH  q@UH HEPtePH  H   V  H ]H  H H%U  HH   H%kV  H  釘H  .H8  GH8  GH8  GH8  {GH  dGHT$UH@HL
0 H $H   pH   pH  GH  G@UH HEHteHHP  H   U  H ]HP  HH%T  Hh   H%jU  HP  H  F@UH HEHteHHP  H   /U  H ]HP  HH%T  Hh   H%U  HP  ]H  AFHT$UH@HH   xyHߝH@]H  oH   oHP   EH  oH  }oHP   !H   eoHT$UH@H    HH@]H  ^H  EH  FH  jEH   nH   nH   nH   lHX   H0  EH0  EH`  nH0  nH@   4H0  xnH0  lnH@   H0  Tn@UH HEPtePH`  H   9S  H ]H`  H H%aR  HH   H%S  H`  'H0  *H`  ?DH`  3DH`  'DH`  DH  DHT$UH@HL
З H H   wmH   kmH  CH  C@UH HEHteHH`  H   8R  H ]H`  HH%Q  H`   H%
R  H`  fH  JC@UH HEHteHH`  H   Q  H ]H`  HH%'Q  H`   H%Q  H`  H  BHT$UH@HH   [H\H@]H  MlH0  AlHP   H  )lH  lH0  lHT$UH@Ht    HH@]H  
H  .BH  H  BH0  kHT$UH0HL   HU8#H      H   HH(HH0]H0   鄒H0  AH  H  H  H  H0  
H   H   H   HT$UH HL   H   33=H@   HPH@   H@H@   H(0H@   H8 H@   HHH@   HX H@   H   @H   &HH   HX   $4H0   HH   HH   @UH HEPtePHM@HPH ]H@   Z@UH HEPtePHM@HPܙH ]H@   :@UH HEPtePHM@HP蜙H ]H@   6HT$UH0HHMP>33wH@   H@   @UH HE0te0H   H   M  H ]H   H H%L  Hh   H%M  H   髏HT$UH0HM8M8LEXIA;|'H HD$ L
v HG H
 LHH0]H@   H@   @UH HE0te0H   H   L  H ]H   H H%L  Hh   H%L  H   ێHT$UH0HM8M8LEXIA;|'H HD$ L
 Hw H
8 CKH[H0]HT$SUH8HH   H{  t'HM8HPHHK HHdK  HH8][Hh   H`   Hh   |H`   H lHh   `H`   H0PH   H   H@   H#HX   lHX   `@UH HHU0HM8H ]@UH HH   HM8{H ]@UH HE4te4H   "H ]H   Hx   ?1H   #H  @UH HE4te4H   H   J  H ]H   H H%I  HX   H%~J  H   隌HT$SUH8HH  H   iHHx H  ;H]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  7wHH  HP H  	;33&~H  :@UH HE4te4H   H   xI  H ]H   H H%H  HX   H%JI  H   fHT$SUH8HH  H   5GHx H  a:H]8tHH   HPHǅ     Hǅ      ƅ   A   H  H  #vHH  HP H  9Hǅ     Hǅ      ƅ   A<   H  H  uHH  HP H  9H  HHPH{H;uHAH4i HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  :uHH  HP H  9H4!H8][H  8H  8H  8HT$SUH8HH  H   wEHx H  8H]8tHH   HPHǅ     Hǅ      ƅ   AH   H  H  etHH  HP H  78H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  sHH  HP H  733zH  7H  7H  7H  7H  7H  FH  HT$SUH8HH  H  	DHx H  57H]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  rHH  HP H  633yH  6H  6H  {6H  o6H  c6H  'H  H  ?6H  36H  '6H  6H  ߆H  6H  ĆHH   XH  5H  @H  5H  鈆H  5H  5H  5H  XH  |5@UH HEDteDH   H   D  H ]H   H H%)C  H   H%C  H   H   5H   tHp   8wHp   ,wH   PHp   wHp   8H   ,H   H   H   H8  H8  HT$UH`HHh  ǃL H`  qHh  H@   H   HX   lHX   `H0   TH0   HHp   \HT$UH0H    H=H0]H(   (H   H(   (H@   (@UH HꋅH  tH  HM@H   B  H ]H@   H H%*A  H0   H%A  H@   H@  Hx  H   hHp   <HT$UHpHHHHp]H   H   H   DH   Hx   ܾHT$UHpHHMHp]H   H   H   Hx  H   Hp   lHT$UHpHHQHp]H   5H   H   tH   8Hx   HT$UHpHHVHp]H   H   IH   =Hp   鴽Hp   騽H   H   @&HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  mH   HH0  HP H0  0H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  lHH0  HP H0  h0H^Hx][H0  L0H0  @0Hx   鄼Hx   xH   Hh  H   hHp   <HT$UHpHHSbHp]H   H   H   DH   Hx   ܻHT$UHpHHgHp]H   H   yH   =Hx  H   Hp   lHT$UHpHHkHp]H   5H   iH   tH   8Hx   HT$UHpHHpHp]H   H   	H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   Hh  H0  <jH   HH0  HP H0  .H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  iHH0  HP H0  -HtHx][H0  |-H0  p-Hx   鴹Hx   騹H   H8   $pH`   HH   @UH HE0te0H  H   ;  H ]H  H H%:  H@   H%s;  H  }HP  ,@UH HE0te0H  H   8;  H ]H  H H%`:  H@   H%
;  H  &}H0  J,@UH HE0te0H  H   :  H ]H  H H%9  H@   H%:  H  |H  +@UH HE0te0H   H   f:  H ]H   H H%9  H@   H%8:  H   T|H  x+HT$UH0HH  zLU8H   lH  ߚH  nH@   HX   |H   pHT$UH@HH   GzL  H   H   dHX   $H@   @UH HE4te4H  H   -9  H ]H  H H%U8  H8   H%8  H  {H  ?*@UH HE4te4H  H   8  H ]H  H H%7  H8   H%8  H  zH  )@UH HE4te4H  H   [8  H ]H  H H%7  H8   H%-8  H  IzH  m)@UH HE4te4H  H   7  H ]H  H H%7  H8   H%7  H  yH  )@UH HE4 te4H   H   7  H ]H   H H%6  H8   H%[7  H   wyH  (HT$UH0HH  wLU0HMx蒈H  H   餴H0   yHT$SUH(HH0  HM04HXH0  (HtHM HHU0P33 kH   4H   (H8   H8   H   H   H  H  H   ԳH   ȳH  <xHT$UH0Hꋍ      P  ;|.U4H8} HD$ L
| LE4H| H
: 4H2H0]H(   d
H@   	H   $H   HX   HX    Hp   Hp   H   ܲH   вH   ĲH   鸲H@  ,wHT$UH0Hꋍ        ;|.U4H(| HD$ L
{ LE4H{ H
j 3HH0]H   @UH HHEXD HUPHM(hH ]@UH HEPtePHM@H`H ]H@   Hp%H    tiH8   X%@UH HE t
e HMXH ]H@   dH   TH   DH(   4H(   (HH   H   @UH Hꋅ   t   HM(H`~H ]@UH Hh   HM@A\H ]@UH HEPtePHM@HPL~H ]H@   :H8   dH8   XH(   LH`   4H  $H  H  H   H0  H   H   ܯH   Я@UH HEPtePHM@H`l}H ]H@   :H   4#H  (#H8  #HX  #H0   DeH   H   "H  "H0   eH   H(   H(   HP  tkHP  HHP  H $HP  H8HP  HPH@   HHX   H   H   Hp   XdHp   LdH   pHp   4dHp   XH   LH  @H   4H   (H8  H8  HT$UH`HHh  pLզ H`  葁Hh  HP   H8   H@   H`   xH   qHT$SUHHHH  H   -Hx H   H]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  \HKHH  P H  X HH_HH][H  < HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  [H   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  [HH0  HP H0  XHcHx][H0  <H0  0Hx   tHx   hH   |HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  ZH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  VZHH0  HP H0  (HsgHx][H0  H0   Hx   DHx   8H   LHT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  YH   HH0  HP H0  gH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  &YHH0  HP H0  HSkHx][H0  H0  Hx   Hx   H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  lXH   HH0  HP H0  7H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  WHH0  HP H0  H3oHx][H0  H0  Hx   Hx   اH   HT$SUH8HH]PHHtJHSMHKH+H*HHLI?LHs8H    HC    HC    33)^HT$SUH8HH]PHHt3HSHLCL+I
IH    HC    HC    33]H8   ]Hh    H@    @UH HE0te0H  H   )  H ]H  H H%)(  H`   H%(  H  jH0  @UH HE0te0H  H   (  H ]H  H H%'  H`   H%j(  H  jH  @UH HE0te0H  H   /(  H ]H  H H%W'  H`   H%(  H  jH  A@UH HE0te0H  H   '  H ]H  H H%&  H`   H%'  H  iH  @UH HE0 te0H   H   ]'  H ]H   H H%&  H   H%/'  H   KiH  oHT$UH0HH  gLU8H   cxH  ևH0   [H@   hH   ZH`   HHH   \H@   ZHP   ا@UH HHU`HMPZH ]HT$UH HHU`HMh:33Z@UH HHU`HMPZZH ]HT$UH HHU`HMhJ33gZHT$SUWH0HH   HO@ HO HN33-Z@UH HHUXHMPYH ]HT$UH HHMhN33YHT$SUWH0HH   HO@ HO H`N33Y@UH HHU`HMPZYH ]HT$UH HHU`HMh
33gY@UH HHUHHMPYH ]HT$UH HHM@M33+Y@UH HHUHHMPXH ]HT$UH HHM@M33XH(   H(   H   XHT$UH Hv33XH   锥H0   H%$  HT$UH HHH ]@UH HHUPHMXXH ]HT$UH HHUPHMh33'XH`   dHH   XHx   |HX   HP   H@   teH0   VH   rH   rHT$UH HHMHHt
H   33mWHT$UH HHMHHt
H   33=WHh   tHP   hHT$SUWH0HH   HO@qHO HK33VHT$SUWH0HH   HO@HO HPK33V@UH HHE(D HUxHM0BVH ]HT$SUWH HH]pH   H;t-Hf     HK"  H"  H[(HCH;u33VH  @UH HEPtePHM@HPlH ]H@   @UH HEPtePHM@HPlH ]H@   j
H   tH   锞H   H鄞H8   HP   Hh   @UH HEPtePHM@HPkH ]H@   rHH   H   HH@   HH   (H@   tHH   @UH HEPtePHM@HPLkH ]H@   oH   H  H8  HX  H0   $SH   (qH   Hh  H@   tH8   H   ԜH(   Hh   鴜Hh   騜H   @UHH3Ɂ8  ]@UH HM@H ]6G@UH H_EM8H ]G@UH0HHHL$(T$ L
GLEpUhHM`DH0]HH   @UH HE te H   qH ]H0   H`   H0   @UH HE te H   H ]H    2@UH HE8t
e8HMXH ]H`    H   @UH HE te H   qH ]HX   _H@   #H   H0   ;@UH HE te H   H ]@UH HE te H   _H ]HX   H@   H   H0   @UH HE te H   fH ]H0   T@UH HE te H   1H ]@UH HE t
e HM@
H ]HP   H   }
Hx   q
HP   eH   Y
Hx   M
H(   !H@   H(   	H@   HP   H   
Hx   HP   H   Hx   HP   H   Hx   HH   H0   Hp   H@   H    UH   iHh   H0   fH    %fH   HX   H@   HT$UH@HYH&  H    u B=  H0~H@]H   CHx   7H`   +HH   HT$UH H]YHF&  H q    r6  HH ]HX   H@   HT$UH HYH%  H-     5  HH ]H0   dH    d@UH HH  H   BH ]HT$UH HXHr%  H    / o%  H]H ]HH   =dH8   adH   u@UH H  H   3BH ]HT$UH HXH$  H-  y   "  HrH ]@UH H(  H   AH ]HT$UH HWH$  Hˌ  z  G "  H[rH ]@UH HH  HM rAH ]HT$UH HBWH+$  Hl V    #  HUpH ]HT$UH H WH#  H*     '$  HoH ]H8   b@UH HEPtePH   bH ]H   oH   H8   gb@UH HEPtePH   DbH ]H   H   vHP   bH@   >bHx   RH  FH   :HT$UH HHM(HPHH
  H	X  HUH ]HT$UH HHM0HPHH
X  H	  HUH ]HT$UH HHM8HPHH
  H	  H}UH ]HT$UH HHM@HHPHIH;uHAH7 HHEHH
c  H	  H!UH ]HT$UH HHMHHHPHtIH;uHAH6 HHEHH
  H	.  HTH ]HT$UH HHMPHPHH
  H	  HTH ]HT$UH HHMXHHPL I;uHAH'6 HHEHH
  H	  H0TH ]HT$UH HHM`HHPHHH;uHAH5 HHEHH
  H	=  HSH ]HT$UH HHMhHHPL I;uHAHo5 HHEHH
"  H	  HxSH ]HT$UH HHMpHHPL I;uHAH5 HHEHH
  H	  HSH ]HT$UH HHMxHPHH

  H	L  HRH ]HT$UH HH7  H
  H	  HRH ]H(   @UH HE t
e HM06tH ]HX   H8   xH   HhH   \dH8   PHX   DH   H4H   (dHH   H   H8   tH   hH  eH  fH  eHp   eH  lJH  eH  H H  H8PH  HpH  MH   XeH   H H   H88PH   HpH   |MH   eH   H@UH H꺸  HMP:H ]Hp   dHp   HH   dH   H 3HX   dH   H8OH   LHh   dHh   H HX   cdHh   H8SOHh   LH0   ;dHX   /dH0   HH  dH(H=l r_H
K DHW HH=   r<t  HAH;rq  H+Hsa  H'vT  H9H     H       H(}DH(H=l r_H
K VDHW HH=   r<t  HAH;r  H+Hs  H'v  H8H     H~     ~  H(CH(H=l~ r_H
K~ CHW~ HH=   r<tA  HAH;r1  H+Hs!  H'v  HC8H ~    H}     }  H(=CH(H=~ r_H
~ CH~ HH=   r<t  HAH;r  H+Hs  H'vt  H7H@~    H-~     ~  H(BH(H=} r_H
} vBH} HH=   r<t  HAH;r  H+Hs  H'v  H7H@}    H-}     }  H(AH(H=<| r_H
| AH'| HH=   r<ta  HAH;rQ  H+HsA  H'v4  Hc6H{    H{     {  H(]AH
ٗ YH
9 YH(H=  t:AAL Hz L+I.WHp     X H(H(H=  t:@@L H L+IN.WH      H(H(H=<  t:}@x@L9 H" L+I-WH       H(pH(H=$  t:@@L! H
 L+I-WH       H(H(H=  t:??L H L+IN-WH     h H(H(H=  t:}?x?L H L+I,WH      H(H
) WH
 WH(H   HOq R+H
Cq HuH(                                                                                                                                                                                                                                                                                                                                                                                                                                         l                    Γ     ܓ                    *     >     X     l                    Δ                    .     D     ^     z     z                  &     r               2     v                l          ڄ          V          ʃ     n               ƀ          6     b                              6     \               ܂               >     "          Ȓ          |     ^     8                         n     2               l     *     ֏          T          Ў          F               p     (               ^          ԋ          R                    P               $          v     @     ,                       ڕ                         "     H     `     j     ܙ          ҙ                             0                       p                       4                         
                     &     ,                  Ș                         p     T     2                         H                       ֖     x     \     R          >     җ                            ̖                       Ė     f             }     }     }     x}     b}     L}     8}      }     }     |     |     |     |     |     |     t|     b|     F|     8|     $|     |     |     {     {     {     {     {     {     {     p{     X{     H{     .{     {     z     z     z     z     z     z     ~z     hz     Xz     Dz     0z     "z     z     z     y     y     y     ~     y     y     y     }     Py     <y     (y     y     y     x     x     x     x     x     x     rx     \x     Nx     <x     "x     x     w     w     w     w     w     w     |w     lw     Tw     >w     ,w     w     w     v     v     v     v     v     ~v     jv     Tv     "~     8v     }     6~     H~     Z~     v     l~     |~     ~     ~     u     ~     ~     ~     ~     jy     u               0     H     \     p     u     u                                              $     8     L     j     u      ~     y     u     u     ru     bu     Ju     *u     u     t     t     t     t     t     t     xt     dt     Pt             P     C           H         `             @    `                        0            P                      `                                                           0                                                                               "   #            0%            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        
   @           0J   J   ؙ
           
           
   8       bad array new length    
      
      P    P       P    
   `@   `           warning OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np               ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  ImportError 1   __getstate__.<locals>.genexpr   reshape num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info misc    __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  1   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    pystan._compat  iter_save_wo_warmup     Stan model {} is of mode 'test_grad';
sampling is not conducted.    upar        data sim model_name model_pars par_dims mode inits stan_args stanmodel date get adapt_window    0   init_alpha  get stan_args_method_t  b   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  B   warmup2 __str__ traceplot   shape   UNIT_E  h   int_time    range   method  H   pystan.plots    _summary    NUTS    lp__    array   fitptr  i   (dense_e)   append  I   stansummary l   AttributeError  gradient    order   pystan  L   sampling_algo_t pars    data_args   DIAG_E  q   ndarray is not C contiguous Q   adapt_t0    error   unit_e  f   pars_oi_bytes   epsilon adapt_iter  d   handler tol_rel_obj user    probs   vars_i  g   warnings    index   chains  Zf  __import__  Zd  collections Zg  stepsize    split   metric  O   extract (diag_e)    OPTIM   holder  par grad_samples    _get_kept_samples   dstack  sim _pars_total_indexes s   chain_id    utf-8   format  s   ndarray is not Fortran contiguous   double  end model_code  end TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   chains  '   Couldn't allocate space for StanHolder. _verify_has_samples name    LBFGS   'char'  s   Metropolis  s   output_samples  dims_oi samples pystan.constants    throw   'long'  %s  _check_pars int string_types    _remove_empty_pars  =   _call_sampler_star  #   adapt_kappa keys    send    flush   =   row_stack   #   SAMPLING    start   =   MemoryError #   squeeze seed    init_list   =   variational #   save_iterations `inc_warmup` ignored when `permuted` is True.   data    
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          =   tol_rel_grad    BFGS    init_radius #   __test__    tuple   =   `dtypes` ignored when `permuted` is False.  #   sampling    inits   =   adjust_transform    value   #   _split_data =   RuntimeError    __getstate__    VARIATIONAL #   genexpr Format string allocated too short, see comment in numpy.pxd =   variational_algo_t  #   elbo_samples    tol_param   thin    inits   =   DENSE_E refresh adapt_term_buffer       Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. #   newaxis flatnames   flat    dtype   =   getLogger   #   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747 Couldn't allocate space for stan_fit.   init    sampler_params  pystan.misc warn    numpy   =   digits_summary  numpy.core.multiarray failed to import  column_stack    adapt_delta #   stepsize_jitter fnames_oi   =   sampler_t   #   control random_seed =   numpy.core.umath failed to import   #   handlers    numpy   =   (unit_e)    numpy   #   logging adapt_init_buffer   =   Non-native byte order not supported #   diagnostic_file argsptr adapt_engaged   C:\Users\appveyor\AppData\Local\Temp\1\tmpbe6d0xcb\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.pyx  adapt_gamma =   history_size    _call_sampler   numpy.core.multiarray   numpy.core.multiarray failed to import  _ARRAY_API  #   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  =   _ARRAY_API is NULL pointer      module compiled against ABI version %x but this version of numpy is %x  numpy.core.umath        module compiled against API version %x but this version of numpy is %x  FATAL: module compiled as unknown endian        numpy.core.umath failed to import       FATAL: module compiled as little endian, but detected different endianness at runtime   _UFUNC_API  #   _UFUNC_API not found    _UFUNC_API is not PyCapsule object  =   _UFUNC_API is NULL pointer  #   SSE, SSE2   =   empty_nested() must be true before calling recover_memory() self        empty_nested() must be false before calling recover_memory_nested() list        empty_nested() must be false before calling set_zero_all_adjoints_nested()  #   stan_version_major  =   stan_version_minor  #   stan_version_patch  =   unknown file name   #   unknown file name       __init__.pxd    Unknown exception       C:\Users\appveyor\AppData\Local\Temp\1\tmpbe6d0xcb\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.cpp  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.pyx =   stringsource    type.pxd        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.__getitem__        attr_names      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.__getstate__.genexpr       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.__getstate__       Expected %.16s, got %.200s  list        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.__setstate__       Expected %.16s, got %.200s  dict        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.__reduce__ stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.num_failed.__get__ list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.num_failed.__set__ list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.test_grad.__get__  list    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.test_grad.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.inits.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.par.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.value.__get__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.value.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.args.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.mean_lp__.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.mean_lp__.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder.sampler_param_names.__set__    numpy   #   Expected %.16s, got %.200s  =   Expected %.16s, got %.200s      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._pystanholder_from_stanholder   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._dict_from_stanargs #   'NoneType' object has no attribute '%.30s'  =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._set_stanargs_from_dict stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._dict_to_vars_r _call_sampler_star      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._dict_to_vars_i dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._call_sampler_star  #   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._call_sampler   Expected %.16s, got %.200s  self        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747._call_sampler   __cinit__       attr_names      genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__cinit__ __init__    ufunc   =   __init__    numpy   #   __init__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__init__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__getstate__.genexpr      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__getstate__  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__setstate__  plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__reduce__        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.plot  =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.plot  #   traceplot   =   traceplot       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.traceplot stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.traceplot extract extract stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.extract   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.extract   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__unicode__       stansummary upar        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__str__   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__repr__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.__getitem__   #   stansummary args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.stansummary       summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.stansummary   =   summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.summary   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.summary   log_prob    'int'   #   log_prob        grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.log_prob  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.log_prob  grad_log_prob   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.grad_log_prob dict        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.grad_log_prob args        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_adaptation_info   =   get_logposterior    throw   #   get_logposterior        'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_logposterior  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_logposterior  get_sampler_params  =   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_sampler_params    throw   #   'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_sampler_params    close   =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_posterior_mean        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.constrain_pars    PyObject_GetBuffer: view==NULL argument is obsolete     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.unconstrain_pars  'NoneType' object is not iterable       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_seed  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.get_stancode      numpy.ndarray.__getbuffer__ plot        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.flatnames.__get__ 'NoneType' object has no attribute '%.30s'      numpy.PyArray_MultiIterNew1 data        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._verify_has_samples       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._update_param_oi  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._get_param_names  numpy._util_dtypestring stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._get_param_fnames_oi      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._get_param_names_oi       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._get_param_dims   numpy.import_array      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._get_param_dims_oi        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.constrained_param_names   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.unconstrained_param_names stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model._call_sampler #   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew2 mode        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model.sim.__set__   =   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 =   numpy.PyArray_MultiIterNew5 #   Expected %.16s, got %.200s  =   numpy.import_array  #   numpy.import_umath  =   numpy.import_umath  #   numpy.import_ufunc  T   numpy.import_ufunc  A   vector.to_py.__pyx_convert_vector_to_py_double  string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    %d.%d   S   string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   A   string.from_py.__pyx_convert_string_from_py_std__in_string  S   vector.from_py.__pyx_convert_vector_from_py_size_t      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ date        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  t   num_failed  A   test_grad   #   mean_pars   #   mean_lp__   #   adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.PyStanHolder    extract Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  #   traceplot   # 
 __unicode__ #   stansummary #   summary log_prob    a_row   1.0 grad_log_prob   get_adaptation_info 1.0 get_logposterior    a_row   1.0 get_sampler_params  1.0 get_posterior_mean  1.0 constrain_pars  unconstrain_pars    [   get_seed    ,   get_inits   ]   get_stancode    get_stanmodel   _verify_has_samples #   _update_param_oi    #   _get_param_names    #   _get_param_fnames_oi    _get_param_names_oi #   _get_param_dims _get_param_dims_oi  .   constrained_param_names unconstrained_param_names   .   _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel       PyStanHolder    StanFit4Model   type    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.StanFit4Model   ndarray Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.__pyx_scope_struct____getstate__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.__pyx_scope_struct_1_genexpr    cython_runtime  '%.200s' object is not subscriptable    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.__pyx_scope_struct_2___getstate__       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.__pyx_scope_struct_3_genexpr     while calling a Python object  cannot fit '%.200s' into an index-sized integer need more than %zd value%.1s to unpack  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747 builtins        flatiter        broadcast       builtins        __builtins__    __name__         while calling a Python object  at most stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747 exactly stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747 %s() got multiple values for keyword argument '%U'      init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747    init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747    name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope      NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        at least        %.200s() takes %.8s %zd positional argument%.1s (%zd given)     %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       calling %R should have returned an instance of BaseException, not %R    %s() got an unexpected keyword argument '%U'    '%.200s' object is unsliceable  Missing type object     Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'      Expected a dimension of size %zu, got %zu       Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected     Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d        Expected a comma in format string, got '%c'     Expected %d dimension(s), got %d        Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler       Big-endian buffer not supported on little-endian compiler   S   Buffer acquisition: Expected '{' after 'T'  T   Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)   Y   'NoneType' object is not iterable   A   Missing type object t   Cannot convert %.200s to %.200s '%.50s' object has no attribute '%U'    cannot import name %S   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747 %s (%s:%d)  A   value too large to convert to int   Y   can't convert negative value to int S   value too large to convert to unsigned int  T   can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    gamma   Y   can't convert negative value to pystan::stan_args_method_t  cap value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   A   value too large to convert to pystan::optim_algo_t  t   can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    delta   A   can't convert negative value to pystan::variational_algo_t  Y   value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  1.0 can't convert negative value to long    _cython_0_28_3  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing 1.0 can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object 1.0 _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections.abc collections 1.0 Cython module failed to register with collections.abc module    Cython module failed to register with collections module    gamma   1.0 backports_abc   send    close() -> raise GeneratorExit inside generator.        send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    gamma   1.0 gi_running      gi_yieldfrom    object being iterated by 'yield from', or None  gi_code __name__        name of the generator   __qualname__    qualified name of the generator generator       %.200s.%.200s is not a type object      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747 an integer is required  compiletime version %s of module '%.100s' does not match runtime version %s     %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    ,   boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      k (internal counter)    The binomial coefficient is undefined for k > n, but got k = %1%.    /  grad_2F1        exceeded        Argument n out of range: got %1%         iterations, hypergeometric function gradient did not converge. grad_2F1    error   %]  boost::math::prime<%1%> is not converging    [  grad_reg_inc_gamma  S   is not converging   T   grad_reg_inc_gamma  Y    iterations, gamma function gradient did not converge.  exceeded    A   k (internal counter)    grad_reg_inc_gamma  t   grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    model   A   t_change    value   Y   *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    Must use algorithm="Fixed_param" for model that has no parameters.  S   Output generated by Stan (test_grad)    Point Estimate Generated by Stan    gamma   T   Sample generated by Stan    delta   Y   Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    gamma   A   Sample generated by Stan    gamma   t   Sample generated by Stan (Variational Bayes)    user    stepsize__  A   treedepth__ cap n_leapfrog__    divergent__ Y   energy__    S   stepsize__  k_s int_time__  k_s energy__    gamma   k_s # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    delta   k_s boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    k_s boost::math::cbrt<%1%>(%1%) k_s 0.003379167095512573896158903121545171688   %1% 0.0834305892146531832907    gamma   :   -0.338165134459360935041    gamma   %1% -0.0509990735146777432841   %1% -0.00772758345802133288487  :   -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    0.1e1   :   0.00858571925074406212772   %1% 0.000370900071787748000569  :   -0.098090592216281240205    0.1e1   %1% 0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    0.1e1   S   0.0195049001251218801359    gamma   k_s 0.00180424538297014223957   k_s 1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017    delta   k_s 0.337511472483094676155e-5  k_s -0.0243500476207698441272   k_s 0.0386540375035707201728    k_s 0.04394818964209516296  0.0175679436311802092299    gamma   nan 0.00323962406290842133584   NAN 0.000235839115596880717416  %1% 1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373    gamma   :   0.00410369723978904575884   %1% 0.00295276716530971662634   %1% 0.0137384425896355332126    :   0.00840807615555585383007   %1% 0.00212825620914618649141   %1% 0.000250269961544794627958  :   0.113212406648847561139e-4  1.0 1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444    0.1e1   0.0 0.0105982906484876531489    0.1e1   1.0 0.000479411269521714493907  1.0 0.00628057170626964891937   1.0 0.0175389834052493308818    0.1e1   1.0 -0.212652252872804219852    0.0 -0.687717681153649930619    1.0 -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  C:\bld\fbprophet_1529034468248\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1529034468248\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   TEST GRADIENT MODE      Initial log joint probability =         Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  lp__    but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.    0.0 . Improved by    Log joint probability =    1.0 Iteration   0.0 Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  1.0 Optimization terminated normally:   1.0 Optimization terminated with error:     Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes  1.0 Optimization terminated normally:   1.0 Optimization terminated with error:     lp__    lp__    t_change    1.0 *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    0.003379167095512573896158903121545171688   1.0 0.0834305892146531832907    1.0 -0.338165134459360935041    1.0 -0.0509990735146777432841   0.0 -0.00772758345802133288487  1.0 -0.000322780120964605683831 0.0 0.455004033050794024546 0.0875222600142252549554    1.0 0.00858571925074406212772   %1% 0.000370900071787748000569  :   -0.098090592216281240205    %1% 0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    %1% 0.0195049001251218801359    :   0.00180424538297014223957   %1% 1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)     0.9016312093258695918615325266959189453125e-19  0.25479851061131551     Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      -0.32555031186804491    Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      The argument a to the incomplete beta function must be greater than zero (got a=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Adjust your expectations accordingly!   Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Initialization failed.  Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.      Log probability evaluates to log(0), i.e. negative infinity.   Log probability=       Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:        Rejecting initial value:          Gradient evaluated at the initial value is not finite.         seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps         attempts.      ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       Exception initializing step size.       t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)  The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%)  Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Result of tgamma is denormalized.       The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.  Evaluation of tgamma at a negative integer %1%. Unknown function operating on type %1%  The argument a to the incomplete beta function must be greater than zero (got a=%1%).   Error in function       The argument b to the incomplete beta function must be greater than zero (got b=%1%).   Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Cause unknown: error caused by bad argument with value %1%      Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       (S + 1) t_change        *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)    Random variable Location parameter      Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       -3.7595974497819597599e+11      7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "   84            X4 (          "   4            4 (          "    5            H5 P          "   5            6           "   l6            |6 (          "   6            6           "   P7            `7 (          "   7            7 (          "   8            8 8          "   p:            : h          "   :            ; h          "   T;            d;            "   ;            ;            "   <             < h          "   <            < h          "    =            = h          "   p=            = (          "   =         	   >           "   >         
   >           "   H?    p?    ?          "   A    B    @B           "   B    C 
   DC           "   G    G    $H           "   H    |I     J           "   K         
   K           "   pL         
   L           "    M            8M p          "   M            M           "   P    P    Q            "   hS            pS            "	   S            S (          "   T            T (          "%   T         '   V x                               `
      v      v            Pv   p         ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx
   p       
      `   @   `   h
        P
           
   L    P    (
   i   5    `
   @   {      0{   0         z      
   d   \   b   h   n   t   z               P   0         @
    %    b   b   b   b   b   b   b   b   
      
   `   Mb`MbPMbP?Mb`?       H
   <      (
   p    P
   )       
   T     U    (
   p                   P       
   0       
   P            
   !   P    P       P    h
   T   
   b   b   b   b   b   b   b   b   
   L      d   
   P_    _    H
          h
   A   `   
    C   X
            `   0                   p
   b   b   b   b   b   b   b   b   X
    j       
          H
   `j       0
           H
   ,    &    p'     )     '    *    *    +    @,    `
          
   H   о
   P        P    
   P          0                   
   @   {      0{   0         z      
   p   `   0   Е      P      P   8
    "   P    P       P    
            UUUUUU?UUUUUUUUUUUU?UUUUUU 
            P    P    
           
       @                     p       
   *       `
   0    P    P    P    P    P    P    P    P    P    P     
         `         t   `                 0         0    
      p      0
                  H
   0       
   P       
   P        
   @       |    
      
   ,    &    p'     )     '    *    *    +    @,    
   P^     ^    
          /          Ȣ
      
   `6    P    P    P    P    H
            
   T    Z    E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        
                                   
      
   Ѓ      0   0             `   
   /    b   /    b   b    
       b   P    P    P    P    P    
      P~                     p       H
    C    p?    ?     @    7    7    7    @    7    
           h
   T    x    
   @                                
       0   $   
           
   t   (
    @   `    
      b   P    P                   Ю
      b   P    P                p   
            
   P    `0    
   6       
   b   b   b   b   b   b   b   b   (
      \   b         t   `                           P
   P7    7    6    6    6    
   p            
   
                 
       @                     p       `
   b   b   .    
           P    P    P    P    P    (
   T    W    
      
           
   $   
   P       ȹ
           
   0       
   5    5                             
 
                     	               	               
                                              
          
   @   t      v            Pv   p   `
   @   @   0         0      `   0
    %    7    7    7    7    7    7    7    7    p
           
      `   P   `   
          /          X
   P        
      ȥ
    A   `   
   d   
   H   
   @   `   Ц
   .   `0    x
       ز
   T    `[    ȟ
          _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?8
        8
      `   P   `   к
   @                                
           
   p5    0    0    1    1    2    2    3    3    4    4    
       P    P       P    
   @B    
   P^     w    
   P            x
                    ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9? 
   P    (
   T    Y     
   $   
           
             0                              ?   =
?   @33?   =
?      ?   ?    ?
            `   0                   (
   l   `
   P_    0s          
           p
   T    0X    
   b   $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?p
       b   P    P    0               
   T    @T    
                                   8
   x          
   P       
   X   
      8
      @      `   0                   
            
              
   0      `         
        
   P       
    >    P8    8    :     8    9    ;    <    =    Р
   P        P    gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@x
   R       
   P    `    X
   4       T   
      v      v            Pv   p   '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        
   `i   5    (
       0y      0{   0         z      8
           H
      
   P          0                   
   <   `
   P    `    Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context             bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product     to_matrix(array)        vector size     rows * columns  .   y   n   m   k   T   Y   A   variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   C:\bld\fbprophet_1529034468248\_h_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =     anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2      data initialization K   t   cap S       t_change    X   sigmas  tau     trend_indicator s_a s_m delta   beta    variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   trend   beta_m  beta_a      Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        right-hand side left-hand side  assign  Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!   , but must be >= 0!     C:\bld\fbprophet_1529034468248\_h_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      rep_array   cols    []  Undefined transformed parameter: trend  Undefined transformed parameter: Y      Undefined transformed parameter: beta_m Undefined transformed parameter: beta_a iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed       Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.                 iter             ELBO   delta_ELBO_mean   delta_ELBO_med   notes         MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   C:\bld\fbprophet_1529034468248\_h_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "               $ `          "   
            $           "   
            #           "    o            P#            "   D!            `! `          "   T             `             "   t                         "                          "                0          "   H                         "                x          "   @            P          "                           "   
                       "   
                       "                 X          "   	                      "   H            X            "                           "   #                        "   g                        "   g            X            "               (            "                           "   "                        "   e            p            "                0           "                           "   #                        "   	            X            "   H	                         "   #                        "   #                        "   g                        "   g            x            "   #            P            "   #                        "   "                        "   e            x            "   H             8          "   H             8          "   #            @            "                `          "   
                       "                0          "   
             8          "                (          "   8            
 X          "   4
            P
 @          "   	            	          "   	            	            "   H	            X	            "   #                        "   #                        "   g                        "   g            p            "   #            H            "   #                         "   g                        "   g                        "                           "   #            p            "   #            @            "   "                        "   e                        "   "                        "   e                        "               (          "                         "           8            "   8         8          "   8         8          "   X            h @          "   8                    "   8        8            "   H             p  X          "                (          "                X          "                           "   L            h @          "                           "   d                        "   
            X            "   t
                         "   t
                        "       4    `            "   X    x 	               "        
               "   <    T                "                       "           H            "   8         0          "                        "   8    d     0          "                       "       ,    X            "                H          "   @            X @          "                8          "         (   @           "   8         0          "   8        @ 0          "       P               "       0    `           "           @           "                       "             p          "   @            P 0          "   d                        "            X         "            
   0           "   t                        "   8            ` X          "                X          "                           "               p p         "                           "                          "               0 p         "                           "   T            ` 0          "                           "   d            x            "   H                         "                          "   #            x            "   #            P            "                (            "                           "
               @ p         "                H          "   P            h            "   `              (          "
               ` p         "                (          "   `            h (          "   (            0           "   `             (          "                8          "   `            h (          "   d
            (            "   8             0          "   8            x 0          "   #                         "   #                        "   g                        "   g                        "   #            `            "   #            0            "   "                         "   e                        "                           "   "            p            "   8            @            "                           "                           "
   d          8         "                            "
                     "            (          "   t                      "        &     p          "   t
             @          "           0           "       P "              "   \                   "   4    t               "       P     `         "       4    `           "           @ `         "           0           "   ,            X          "       D    p           "           P `         "   Ŀ        0           "       ܾ     p         "               @ 8          "                           "   X            `            "	       <    p           "   й        к X         "   ,             x          "+   4     Y               "   T             (          "                            "   
            h P          "   
             P          "   
             P          "                            "   8    4    ` 0          "   i                        "                            "       4    `           "   Ԫ        @           "   d                        "   8         0          "   H            X            "                           "               Ȩ            "   X            p           "                            "   ȧ            Ч            "   x                       "            	                "   8    D    p            "   t             p         "                            "   8         0          "         ;    P         "   Ğ         *    (         "!        =    @         "   ̘         *    @         "   i            h            "    j            8            "   #            З            "   g                        "   g                        "   #            X            "   g            0            "   g                        "   #                        "   g                        "   g                        "   d            p (          "                          "                          "
                x         "                           "   H            P (          "                          "               (            "   ,            А           "   ,                       "   PR            Ȏ 8          "   e                        "   e            h            "   "            @            "   e                        "   ȍ                        "   H             8          "   H            h 8          "   
              P          "       ,    X            "   8    ԉ      (          "   8    `     (          "   @    p 
    x          "       І                 "       \ '             "   <     )              "                          "                           "   X                      "   ~            ~ @         "   0|            ~           "   {            `~           "   0|            (~           "   {            }           "   h}            }          "   |             } @         "   0|            |           "   {            p|           "   0|            8|           "   {            {           "   ${            `{          "   x         -   y           "   |v         -   @w           "   Xt    t %   u           "   s             t H          "   s            s x          "   r            s H          "   r            r 8          "   q            q           "   o            0p           "   
            `o P          "    o            (o (          "
   Ln            n P          "   N             n 8          "   0P            m            "   
            `m P          "   k            m 8          "   
            pl P          "   k             l 8          "   
            k 8          "   8    k    Hk H          "   8    j    j (          "    j            0j            "   i            i            "   #            i            "   di            i            "    i             i            "   8    |h    h 0          "   #            Hh            "   #             h            "   g            g            "   g            g            "   #            g            "   PR            g 8          "   PR            f 8          "   #            xf            "   #            8f            "   "             f            "   e            e            "   d             e            "   d            d            "   c            d (          "   c            c (          "   pa    a '    b @         "   `    `    ` 0          "   _    _    0` 0          "   _    ,_ 	   `_ 0          "   <^    \^ 	   ^ 0          "$    [         ?    \          "   
            Z 0          "   hX    (Y    PY           "   8    W    X 0          "   8    xW    W 0          "   8    W    8W 0          "   8    V    V 0          "   8    @V    hV 0          "   8    U     V 0          "   8    pU    U 0          "   8    U    0U 0          "   8    T    T 0          "   8    8T    `T 0          "   8    S    S 0          "   8    hS    S 0          "   8     S    (S 0          "   N            R 8          "   PR            xR 8          "   N            R 8          "   Q            Q 0          "   dQ            pQ 8          "   0P            Q P          "   P            P            "   lP            P (          "   lP            xP (          "   0P            8P            "   hO    O 
   O            "   N            O            "   N            N 8          "   
            @N P          "   (M    XM    M            "   HL    xL    L            "   `K    K    K            "   I    I     J            "                   pI            "   <            H            "   hH            pH            "   H             H            "   G            G 8          "   #            G            "                   F            "   #            F            "   #            F            "   8    E    E 0          "   XE            pE            "   8    D     E 0          "   D            D 0          "   #            hD            "   C            C            "   DC            XC            "   B            C            "                   B            "   4B            B X          "   4B            @B X          "                   A            "   8    @    @ 0          "   8     @    H@ 0          "   <            ?            "   #            ?            "   #            ?            "   #            0?            "   #             ?            "                   >            "   <            x>            "   8    =    (> 0          "   8    <    = 0          "   <            <            "   ;            < 8          "	   4;            ; (          "   :            : P          "   7            : (          "   7            x: (          "   :            0: p          "   P9            9           "   8            8           "   8    8    @8 0          "   7            7 (          "   7            7            "   47            X7            "   5            p6            "   3         &   4           "   d            3            "	   2            2            "8   ,    `. f   0/          "J   L%    '    '           "
   p$            $            "   #            H$            "   #            $            "   #            #            "   #            #            "   "            #            "   "            `#            "   "            0#            "   "             #            "   "            "            "   !            @" 8          "   X!         
   ! H          "   
            !            "                             "   h             x             "            
    (          "               @ (          "                (          "   D             (          "                           "   D             (          "   H            P h          "   \                       "   \                       "                0          "                           "               X            "                 (          "                (          "   D             (          "                           "   D            P (          "                p          "   x                       "   x                       "                0          "   d            x            "                           "                0          "                           "               h            "                            "                           "                           "
                            "   D            P            "            H          "            ( `          "
   x                   "        `               "                @          "   P            X (          "               P
           "
            0 @          "            	 0          "           0 0          "       H    p @          "   (            ` (          "                           "                           "                P            "                           "                            "	                            "   d            p            "   
            0            "                             "   
         
   0  0         "   
            
            "   d
            p
            "   8
            8
            "   
            
           "   
            X
            "   t
            
           "   
            
            "   
            
 H          "   
            `
 0          "   
             
 8          "   
            
 P          "   p
            x
            "   8
            @
            "   
            
            "   t
            
            "   8
            
            "   
            h
            "   
            0
            "   8
            
            "   
            
            "   t
            
            "   8
            @
            "   
            
            "   $
            P
            "   
            
 H          "   
            
 (          "   
            P
 0          "   
             
 0          "   
            
 (          "   
            
 (          "   <
            H
 (          "   
            
 (          "   
            
            "   
            
            "   
            X
            "   
            (
            "   
            
            "                   
            "   \
            
            "   
            
 (          "   
            0
            "	   
            @
 `          "   |
            
 (          "   
            (
 (          "                   
                          Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                         ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    7#[    
   p  $
 $
                                                                                                               p   x                                 O            0             8
 
                            P
         `
                          @   8
                         
 
                            ȕ
         
 
  
                                 @   
                        
                	   
                     @   P
                       
 h
                 `            @   
                `       H
 
                            @ 
 
                            ` 
 
                            # 
 0
                 
             X            @   
                        p
 
                            
                    
                      @   И
                        6 H
 
                             @   X
             
 8
 Ȝ
 
 p
 
 
 
 p
 
                                                            X
                   
                   @F 0
 
                 0             @   `
             =            @   
             	            @   
                (       ) 
 
                            	 
 
                            B 
 ؙ
                 
  
                             7 
 
                 `(            @   Ш
             
 
  
                     P
 @
  
                                A @
 
                            
                    
                     @   
             `#            @   x
              
 
 @
 8
  
 
 
                                                 @   0
             0     (       @   `
                        , 
 
                            H H
 
                 @             @   
              
            @   ȿ
             p
 p
                            
                    x
         P%            @   
                       
         h
 h
 H
                               6 H
 (
                           `
                   ȧ
                   8
                    P" 
 
                 
 
 @
  
 
                             
 `
  
                        (       `2 8
 
                            `( Ш
 8
                 "            @   
             0>            @   x
             
 8
  
                                
            P       p
 
                 
 @
  
                               
         P
 H
                            p 
 `
                 p
            @   З
                        h
                     p
 ȟ
                  /            @   
             
  
                 %            @   Ȼ
             8             @   X
                          @   @
                        @H 
 
                             
 ȿ
 Р
                            / 
 
                 
 
 
  
                                    0
                     @   ط
                         @   0
             p         P      P   
             
 0
                 
 P
 @
  
 
                                        D 
  
                 H             @   H
                        8 
 p
                  
 
                 P
 H
                           p 
 Ȣ
                           
                    
                     @   p
                       P: X
 H
                            
                    
                    ` 8
 
                 
 H
                             @   P
             8            @   `
             ,            @   
                        0
         )             @   x
                         0
 
                 2            @   
                       = 
 
                 ,            @   x
                        
         
  
                 H
             P
 H
 
  
                         P:            @   X
                         x
 ȥ
                 0
 
                    (       8 
 
                            x
                    
         
 8
  
 
                         
 
                            
                   
                    `# x
 Ц
                            
         H
 
                 @             @   @
                         
 P
                 8            @   H
                         @   H
             
 X
 
 8
  
 
 
                                                
                    
         8            @   
             ȭ
 `
 p
                     
                        p
 
                 `
 
                           
         
 
                 @            @   @
             
 @
  
 
                         `4            @   (
                P      = 
 x
                            `8 
 
                            `
                    
                
   `
         	            @   
                         p
 8
                 
 
  
                                P
         8
 
 8
  
 
 
                                 @F            @   0
                       
                        @   @
                       
           	           @   
             
 @
  
                     @ 	           @   
                         x
 
                 
                        0> x
 
                 B             @   
                P       p
 H
                             
 p
                             
                     @   
                        `
                      @   
             p             @   
                        + 8
 @
                 
 
  
                                
                     @    
             `            @   
                         @   
             
  
                 0
 
 H
                                 h
 P
                            
         (
 H
                  '             @   P
                        # 
 Ю
                            P 
 
                 p             @   
                         @   О
             
 
                            
                    
         
 
 
 8
  
 
 
                                               `4 (
 
                  
 (
                 
 P
 H
 
  
 
 p
                                                м
         X
             Ȝ
 
 p
 
                                     @   H
             
 8
  
                                < 
 
                             @   
                         
 `
                             
 
                 
             X           @   ȩ
             8
 0
                 @
  
                 @-            @   д
                        
                    pD 
 X
                             @   h
                        
                    x
                    8 H
 ز
                             X
  
                           H
                    
                     @   
                        
                     @   
                         @    
             6             @   0
                        
                     0
 (
                 
 
                             
 h
                  7            @   
             8
 
                            
                    
                     @   0
                         " 
 (
                 -           @   
                        @F 0
 x
                 `8            @   
                        
                    @- д
 
                 A            @   @
                        p
                    ` 
 H
                  
 
 H
                     H
 
  
                                 
 
                             @   
             .            @   
             
 
 
 8
  
 H
  
                                     X
 8
  
                                F 8
 
                  
 
 
  
                                    x
                    
                    ` 
 
                 
  
                 P
  
 
 
  
 
 p
                                      
                (        
 
                             @   8
             
 
 p
 
                                   `( Ш
 
                 
 @
 8
  
 
                                        H
                    `
                    
         
 H
                            (6 0
 ȹ
                            P
 
                 B            @   
             F            @   H
             @            @   @
             
 X
                 6            @   H
                         
 к
                 `            @   
              
 
                            
 8
                            0
         
                       
                    `4 (
 
                            0
         	    (       @   
             (6            @   0
             ,            @   
             
 
 8
  
                                    0 
 
                 -            @   
             p
                        
                     H
 
                            F H
  
                            h
                    - 
 `
                 
 
  
                                 p
 
                 H,            @   
                         @   p
             0             @   
                        
         E            @   
             x
 
 H
                                @* 
 
                             h
 о
                            p
         :            @   ج
                        
                     
 P
                 #            @   
                        84 
 
                            
                    
                    8 X
 
                             H
  
                              
 H
                            2 
 p
                           `
         
 
                            
         84            @   
             
  
                              
  
                 
                       
                   P
                    
         5            @   X
                       
                   B 
 
                    P        И
 
                            - 
 0
                            ȣ
                    
                    p
 З
 
                            p 
 
                 x
 
                             @   
                        H
         0
 
                            
                     О
 `
                 
 
 
  
                                    PA 
 
                  >             @   
                       P" 
  
                             / 
 (
                 X            @   ȩ
                        
                   " 
 
                 F            @   
                          @   H
                         
 
                           X
         p            @   
                        ? p
 p
                 H
 X
                 <            @   
             p         @      P   
                          И
  
                 !            @   
                         
                    
         9           @   
             `2            @   8
                        h
 
                             @   x
             0
            @    
                       
                     @   
                        H0 К
 
                            6 0
 
                 X
 0
                 X6            @   
             
 
 
 
  
 P
 h
                                                 @   
             pD            @   
                        
         F            @   8
                        p
 
                  
            @   
                        
                    
                     ط
 h
                             
         9            @   
             
             `
 
 P
 @
  
 
 
                                                 p
  
                 
                        0
 X
                 :             @   H
                         P
 
                 x
 
 
 h
                                     P
 
                 @            @   
                       (
                      @   
                        
         
 
  
                                p 
 
                    P      @F 0
 
                 @
 0
                            0D 
 (
                  
             P
 (
                             > 
 x
                     (       @    
             
 н
 
 
                         
  
 
                      
                        F 
  
                 X           @   ȩ
             
 @
  
                                
         
 (
                              @   
             P
 0
                            . 
  
                 
                          @   @
                        X 
 `
                 
 Ȱ
 H
                                
                     0
 
                           8
                    
                   
                    x
         `            @   
                        
                     @   p
                        P
                    p
                   (
                      @   p
                         
                    0  
 8
                              H
 `
                 0.            @   
             
 
                 h
 H
                             
 
 
                         8
 Ȝ
 
 p
 
 
 
 p
 
                                                        0
         8            @   
                        
                      
 
                 Ȱ
 H
                         P
 8
 Ȝ
 
 p
 
 
 
 p
 
                                                 p            @   
             0
 Ȱ
 H
                                . 
 
                 @            @   
             X
 
 8
  
 
                             .             @   
                        P: X
 H
                           
                    p
                    8 `
 
                            
         p            @   
                          @    
                         @   H
                        " 
 X
                 
 8
  
                     
 x
 
 
 h
 
                                            
                     
                     
 
                 8
  
                            
                    
                     
                   F 
 
                             @   x
             
                        @ 
 
                 
                        ` 
 (
                 p!            @   `
             `
 `
 p
                                x
         0            @   `
                         p
 
                            
  
                            ) 
 (
                 @H            @   
                        h
                    0 `
 
                 
 0
 
                     `            @   8
                        P
         0            @   
                        
                     @   p
             
 
 
 
 h
 
                                 H0            @   К
                         
 
                            
          
  
                              @   
             
 
 @
  
 
                             PA            @   
             
 
 
 @
  
 
 
                                                 . 
 
                 
                         @   p
             Ъ
 
 @
  
 
 
                                           
                    H
                    , x
 
                 
 0
                    (        H
  
                              
 (
                 X
 
 
                     
 8
 
                     @            @   @
             8
  
                 +               P   h
                        B 
 
                    P      " 
  
                            `2 8
 H
                            
                    0 
 
                 +             @   8
             #            @   
                        , 
  
                             2 ȵ
 (
                 `
 
                 B     (       @   
                        h
                   x
         X             @   
             
                        
         0
 (
 
 
  
 
 
                                                 @   
             
 
 H
                                p, 
 
                            	 
 
                 -           @   
             D             @   
             	            @   (
                        0 
 `
                             
         
 h
 H
                                  @   
                         @   
             P            @   
                          p
 8
                             8
 `
                 
             0
                        P
         X
 
                            X
            P      P" 
 
                           
         
 
                            X
         @
 8
  
                     0
 
                            : ج
 
                            (
                    
                    x `
 
                            
         
 
 
 @
  
 
 
                                     
 
                 
 8
  
                     -            @   
                    
    
                    
         @            @   @
             )            @   
                         @   
             
 
 8
  
                         8
             @
 
 
 
  
 
  
                                     0            @    
                        
                    
            (         И
 H
                                @   
                        
         @*             @   
             
 
                 +            @   h
                      @ 
 
                  .            @   
                        ! 
 h
                 (
             
 
 
 h
                         .           @   
             .           @   
                          @   h
                        
            P       h
 X
                            
                    
                    (
         
             н
 
 
                     `
 p
                             @   @
                        E 
 8
                            
                    P
                    H
         p,            @   
                         @   
             P"            @   
                P      `2 8
  
                            0
  
 H
                           0
                    = 
 
                            
                     
 
                            `
         ?             @   p
                         
 0
                            
         0D            @   
             
                        p! `
 
                              @   
                        ء
                     
 
                            
         0            @   
             (
 
 
  
 
                                        
                    p 
 
                            0  
 
                 
 0
                 
 
 H
                     
 `
 
                      2            @   ȵ
                        8 
 
                  "            @   
             (
 
                 
 
  
                                
         x            @   `
             `
  
                 @            @   @
             0            @   
             ض
 
 
 p
 
                                        p
         
 
  
                 GCTL   `  .text$di    `  , .text$mn    C     .text$mn$00 0C   .text$x @   .text$yd      p
  .idata$5    p    .00cfg      .CRT$XCA        .CRT$XCL       .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ        .CRT$XPA        .CRT$XPZ        .CRT$XTA        .CRT$XTZ      .rdata  
 (   .rdata$T    
 X  .rdata$r    $
 t  .rdata$zzzdbg   
    .rtc$IAA    
    .rtc$IZZ    
    .rtc$TAA    
    .rtc$TZZ    
 g .xdata  X   .xdata$x    h    .edata  h    .idata$2    i    .idata$3    i p
  .idata$4    Pt %  .idata$6      X  .data    P  .data$r I $  .bss     p n  .pdata    <   .gfids$y         .tls        .tls$       .tls$ZZZ          _RDATA    `   .rsrc$01    `    .rsrc$02                                                 20
 
4 
2p B   R0
 b  n x
     p  * d 4 p; P
 r   0C               Q         2P1	 T 4  p`  ; (
    `C     C             &     
        
 d
 T	 4 2p2  	p`0P;  
   C     C C    C C    C    C    D    D                  8            *                     "     e"     "     #     $  
 
4 
Rp d	 4 Rp 4 R
p`Pn ؃
  D     ,D    <D    LD    \D    lD    h    h         `%  %      %     %     %     %     %     %     &     *&     Q&     c&   d T 4 2 T 4 2`% %t !d T 4 
	n 
 D p'  t(      (  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 Rpn 
 D     D     h h     .  .      .     /     /      W/     f/   4 Rpn `
     /   0; 8
 J   D     0  "1      ?1   0; 
 J       1  2      /2   0; 
 J       2  3      3   0; 
 J       3  3      4   0; 
 J       4  4      4   d T 4 pn p
 D     8  8      8  9      m9   d T 4 pn H
 D     9   :      :  :      }:   d T 4 pn  
     :  ;      ;  ,;      ;   d T 4 pn 
     ;   <      %<  <<      <   4 pn Ё
  E     <  =      <=   4 pn 
     =  =      =   d	 T R( (d $T  4 
pn 
 0E     @  A      $ 	0 0  ; X
 r  `E     lE @C  C      C     $D  m md
 h4 
rp 4
 rpn 0
 E     E    E    E    E     F   G      $G     ]G     lG     {G     G  ! t K  7L  
 !   K  7L  
  h r0n 
 E M  ZM      kM      
4	 
2pX;    * *x h r0 Rp`P0 t d
 4	 Rn 
 E pU  U      U   h d 4
 rpn 
 E      V  V      V   h d 4
 rpn 
  F     V  :W      eW   t d
 4	 Rn h
     `X  X      X   h d 4 rpn @
     Y  gY      Y   h d 4 rpn 
      Z  wZ      Z   t d
 4	 Rn 
     [  '\      V\   h d 4
 rpn 
     \  \      ]   h d 4
 rpn 
     @]  ]      ]   d
 4	 Rpn x
 ^  ^      ^   4 
p	`Pn P
 F _  _      `  * 0 p`0P  ; (
 r   F     NF `F    lF `  a      7a     oa     b     + / ;  
 b  F     F     b  c      Nc     c  . d1 40 . p  ; ~
 b  c  c      d     Cd  . 0 p`
0  ; ~
 r      pd  d      $e     e   h b  +
 +h &4 
p`Pn ~
 F F    F    F     i  Ri      i     i     j     j   t 4 P' 't# #d" 4!  P  n `~
 F F    F     0l  yl      %m     m     _n     n    p  !  
T 4 0o  \o  
 ! d \o  o  
 !   \o  o  
 !   0o  \o  
 !     T  4 0o  \o  
 " "h 	p`0Pn 8~
     p  p      q     q     r     "r  ' 't #d 4  P  n ~
 G     `s  s      Ut   p! 4 u  u  
 ! d u  u  
 !   u  u  
 !   u  u  
  d
 4	 Rpn }
  w  ow      w   4	 
Rpn }
  G     0x  bx      x   4 Rpn }
 0G     0y  y      y  *
 *x &h "42 , 
p`P  n p}
 @G     LG    XG    dG    pG    |G           G         y  y      6z     dz     mz     {     {     |     }     }     }     }      }  6
 6x h d 4 rp( d 4
 p; H}
 J   G G     ~  F        z     )   d 4 2p 0;  }
 J          P      _   d T 4
 rpn |
 G     Ѓ          8	 'x8 #h9 4v t P  ; |
 r  G     G    G    G     H    H    H    $H    0H             Ѕ  H      ^                    L     x               b          ǈ     9     G          ŉ     ߉        6	 %x8 !h9 t p0P  ; |
 r  @H     LH     XH    dH    pH    |H    H    H             2     D                *     V     ό          0     ύ          B     V     p         4 Rp`Pn |
 H H    H    H    H    Y      w                    ӏ  $
 $T 4 R
	p`n X|
 H H    I    I    (I    4I   ;      W     k                      0
 !4 
p`P; 0|
 j   PI     \I hI    tI             P  +      \           ȓ             
  K     v                   R
 R T
 4	 2p`$
 $T 4
 R
	p`n |
 I     I     I    R      s             4 p`P!  @     !   @     ;
 -t7 )d6 %44 . 
P  ; {
 b  I I    I    I 
J    J                                                    Z     v  ! t     
 !   t     
 
 d T
 4 2p$ 	 0  ; {
               J    J    J    J               \ 	   :    0J 8     p      y  0J     =J    RJ    fJ    J    
 
2Pn {
 "  ; {
               K    K    K    K                	   : x    K 8       `           K     
K    "K    6K    K    
 
2Pn {
 , h	 	 0  ; h{
               ZL    fL    fL    rL                	   : x   K 8                          K     K    K    K    CL    
 
2Pn h{
 
 h 4 R
p`P
 
4 
2p R! t d 4	     t	 !" "T
    =  |	 !     =  |	 !     T
   =  |	 !      =  |	 !     t  d  4	     t	  RP!  t 4	 p    
 !# #d
      
 !       
 !     d
     
 !        
 !       t  4	 p    
 ! t @    
 ! d     
 !       
 !   t @    
 !   t  d @    
 
 
B0P  ! t
 d	 p     !9 9  t
  d	 p     !     t
  d	 p     ! 4	 0    
 !  t 	d
  4	 0    
 $ 	 0  ; @{
            L    L        M    M    M    M    M    M        	       	   (6 H   L H                         ^     v  L     L    L    M    M     M    |M 	    BP0  n @{
 :
 ,t9 (d8 $47 0 
P  ; {
 r  M     M    M    M    N    N    ,N    8N    DN    PN 	   \N    hN    tN    N 
   N                 
     #     2     A     P          Ź     Թ       	   .  
   ׺  	   7          =     J     Y       
        ʼ  
   Լ          4     V  	   r          ½   	  d* T) 4( & p  n z
 N           $ $d0  T/ 4. * p  n z
 N N    N        ^                       - " p`0  ; z
   N     N            O    !O    -O    9O    EO            P    P    P             t 	   B    QO X           @  v                           #     X     f               3          J     a           _O    O 	   O    O 
   O    ]P    nP     bP0  n z
 , # p`0; xz
   P            Q    %Q    1Q    =Q    IQ    UQ    UQ         	   R 	   R 	   R              	   B    aQ X              5      \                         )     R          N                          oQ 	   Q 
   Q 	   Q    R 	   mR    ~R 	    bP0  n xz
 "  ; Pz
               S                	        S H     :         S     
S    ;S    JS    
 
RPn Pz
   ; (z
 {              NT                	    p   S 8          $      -  S     S    S    S    
 
2Pn (z
 *
 * x h 
4 
p( d
 4 rp;  z
 2   `T     p          7	 &dv "4u p pP  ; y
 r  pT     |T T T T T    T T T T 	   T 
   T     U             @                   E         y       ;     L                   M     ^           	      
   4                 
     	      4
 pn y
 U     @           Bp0  !  

 T      ! d	      !        !         4 
	p`n y
  U     ,U     8U             +     G        d 4 p6 (t3 $d2  40 , P  ; `y
 R  PU \U    hU   '      5                 j   4
 pn 8y
        U      k  
 
4 
 p  ! d      !        ) t 4
 	P; y
 J   U U U U U U U           3      A         Q     _         o     }       	         & &4/ * p`P  n x
 U                d
 T 4 rp+
 +h &4 
p`Pn x
 U U    V             h     {     :     =  ! !d
 4 R
pn x
  V     ,V     `             }         4 
r	p`n px
 @V     LV         9        T 4 p` 4 p`P! h @  X   !   @  X   !    <    !     <    & &d "4  	pP  n Hx
 `V lV    xV    V   P      <     D                 & &d "4  	pP  n  x
     0  p      Z     b          
        4 
p`P!  @  z  0 !   @  z  0  t d 4 P
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T   ?   !     ?   &	 &d "4  	pP  n w
 V     V             )              4 
Rpn w
 V     0  V      m   d 4
 
Rpn w
 V         .   4 
Rpn w
     P  v         4 
Rpn Xw
 V                4 
Rpn 0w
       6      J  " "h 	p`0Pn w
     p        6    E          	p`P0n v
 V     V  ;     T           4 
r	p`n v
  a           t d 4 %
 %h t d 4 P"	 "d 4  pP  n v
  W W    W    $W     @	 u	     
    '
    
    
    
 "	 "d 4  pP  n hv
  E                       d 4 pP' 'h
 #T# 4"  	p`  n @v
 0W         4 
Rpn v
             d 4
 
Rpn u
   p       4 
Rpn u
             4 
Rpn u
       F     Z  4 
Rpn xu
               )	 
	p`P0  ; Pu
 b   @W     LW    XW    dW    pW    |W    W    W    W    W 	   W 
   W             P                 ) 	   9 
   E    u                   
R0n (u
 W     W    6      I        4
 
Rpn  u
 X     X    ,X    8X                       '!    5! # 4
 p; t
 J   . @/     N/ 6 (4   
p`P  ; t
    PX     vX    X    X         / "0     0    2    2    b3    o3    y3     3    &4     = ,4C 8 
p`P  ; t
   X     X     X    X    X    X    X    X         4 4     $5    E6     6    6    6    &7    N7    7    7    7    8    ;     4	 
Rpn `t
  Y     ; 0<     q<  4	 
Rpn 8t
     < <     =  4	 
Rpn t
     = P=     =  4	 
Rpn s
     =  >     a>  4	 
Rpn s
     p? ?     ?  R0n s
 h A B     6B  4 Rpn ps
     @B B     B  R0n Hs
 B B     C  4 Rpn  s
      C bC     }C  
R0n r
 Y     Y    ,Y    <Y    LY    _Y    rY    Y    Y    Y D D     D    D    D    E    E    'E    <E    QE    fE 	   oE =
 +h# &dQ "4P H 
p  ; r
 #  Y     Y           Y    Y    Y    Y    Z    Z     Z 	   ,Z 
   8Z    DZ    PZ 
   \Z    hZ    tZ    Z    Z    Z    Z    Z    Z    Z    Z    Z    Z    Z    [    [    [    ([    4[    @[ !   L[ "   X[ #   d[    p[    |[ &   [ '   [ (   [    [    [    [ ,   [ -   [ .   [    [     \    \ 2   \ 3   $\ 4   0\    <\    H\ 7   T\ 8   `\ 9   l\    x\    \ <   \ =   \ >   \    \    \ A   \ B   \ C   \    \    \    ]        H   D]    G   I      ' 	   B    ] H               E E     E    E    7F    lF    F    F    F    F    yG    G    H    I    gI    I 	   I 
   I    J 
   /J 	   =J    KJ    J    J    RK 
   K    K    K    K    L    ,L 
   :L    L    EM    RN    N    N    N    N    O    (O    6O    O    6P    BQ    wQ    Q    Q    Q    
R    R    &R    R    ,S    !T    \T    T    T    T    T    T    
U    [U     U    V !   WV "   V #   V $   V #   V "    W !   W    W %   X    ?Y &   zY '   Y (   Y )   Y (   Z '   %Z &   3Z    Z *   Z    C[ +   [    \ ,   %] -   b] .   q] /   ] .   ] -   ] ,   ]    ^ 0   ^    ^ 1   ^    _ 2   ` 3   N` 4   Y` 5   ` 4   ` 3   ` 2   `    a 6   ea    a 7   b 8   ?b 9   Jb :   pb 9   b 8   b 7   b    c ;   Rc    c <   d =   >d >   Md ?   sd >   ~d =   d <   d    e @   <e    f A   4f B   If C   Xf D   ~f C   f B   f A   f    g E   Ig    h F   h    i G   i    i     i ]     !] H   .] I   
 
RPn r
 9 'h( R 
p`0  ; r
 s  P] \]    h]    t]    ]    ]    ]    ]    ]    ]                  S^    _^    k^    w^    ^    ^    ^    ^                  >_    J_    V_    b_    n_    z_    _    _    _                   5` !   A`    M`    Y`    e` %   q` &   }` '   `               *   *a +   6a    Ba    Na    Za /   fa 0   ra 1   ~a    a 3       3       5   +b 6   7b 
   
   
      .             .       "      . )   )   ,       / 4   4   7      / 	   B 8  ] H   	   B 0  ^ H   	   B   _ H   	   B (  ` H   	   B    a H            l Ul     l    l    l    l    l    m    n    o    Po    o    o 	   o    o    o    p    #p 
   3p    jp    p    1q    q    q    r    >r    Lr    rr    r    r    r    r    r    &s    <s    s    Ht    t    t    u    %u    Ku    u    u    u    u    v    /v    jv #   v    1w $   w    w %   x &   Px '   ^x (   x '   x &   x %   x    x )   y    Ay -   Wy    z .   iz    z /   
{ 0   G{ 1   Y{ 2   { 1   { 0   { /   {    | 3   M| 4   _| 3   |    |    |    |    | ]     ]    ^    0^ 
   ^     ^    ^    _    _     _     _ !   ` "   `     ` *   ` +   a ,   a     a 5   a 6   b 7   
 
RPn r
 .  t d 4 	P; r
 J   Pb \b hb tb b b b b b         0} }     ;~ ~    g                N    [      Ȁ    Հ      $
 $t d 4
 
rPn Xr
 @       ?
 .tC *dB &4@ : 
P  ; 0r
   b     b     b     b     b     b     c     c      c     ,c     8c     Dc     Pc     \c     hc     tc     c     c     c                  )     I    U              ވ         T    b              	         7    C     p 	   ~      
   Ȋ               L    X      
        ̋    ؋               L    X              ̌    ،      < +tC 'dB #4@ < P  ; r
   c     c     c     c     c     c     c     d     d     d     (d                                                                 0 }                      #     C    O         Ύ              u                   	        , 
   8     P  4	 
Rpn q
 @d     Pd    `d    pd     0 Y     e    q    }      d 4
 
Rpn q
 d     d   ?     W      
R0n q
 d   6       n hq
                       ,8 	   B 8   d H   0 C     c d     d    
 
RPn hq
 3	 < 	p`0P  ; @q
   le     0e    <e    He    Te    `e     И           .    P            7    m             9 (h $4D < 
p`P  ; q
   e     e    e    e    e    e   K     V    x    ӛ    *    `                        +     G & 6 p`0  ; p
   e     f    "f     .f      ϝ             ٞ               
R0n p
 P f      
R0n p
          d 4  p  n xp
 Xf     @f    Lf           /    =    g         * *d %T  4
 R
pn Pp
 f     f    f    f    f    f    f    g    g               _    p    )    =    O    d        ڣ 0
 "d 4 	pP; (p
 j   @g     Lg    Xg       :     D        
          # #h 4 Rp 
4 
pX; `    4
 Rpn  p
 pg g            * # #t
 d 4 rn o
               < @           g X              g     g     bP0  n o
  4 2! d t  A D= !   t  A D= !    A D=  d 4 2! t @  = !   @  = ! d p  8
 !   p  8
  d 4 
rpn o
               > @            h X               h     .h     bP0  n o
  4
 Rpn o
        6    D  2p! 4 `  > !   `  >  R0n `o
       4 Rpn 8o
       ?     h  4	 Rpn o
             d T 4 2p d
 4	 Rp 4 Rpn n
 p        4	 Rpn n
           7  4
 Rpn n
     0             d 4 
rpn pn
               4@ @           h X   0 4     G h     h     bP0  n pn
 ! d 0 H 8
 !   0 H 8
  d 4 
rpn Hn
               @ @           h X    2     E h     h     bP0  n Hn
 ! d   8
 !     8
 ! d t 0  D= !   t 0  D= !   0  D= ! t   = !     = ! d P h 8
 !   P h 8
  4 Rpn  n
   t	 d 4 2 d	 T 4 2p0	 "d 4  pP  ; m
    Pi             ! t `  
 !   t `  
 0	 "d 4  pP  ; m
                R0n m
   R
p`0n m
 `i     i    i           7    i      4	 Rpn Xm
 i     i               H  4	 Rpn 0m
 i     j      P     l      0  ! t   C !     C + +d 4 p   BP0  ! t	   C !  

 d  t	   C !   
  t	   C 
 b  n m
       
     L #	 p
`P0  n l
 0j `      |  d 4 
rpn l
               D @           @j X   p 
       @j     Nj     bP0  n l
 " "d
 T 4 
rpn l
 j     j    j       	            
 ! !d 4
 r
pn hl
               E @           j X       `       j     j     bP0  n hl
  T 4
 2
`! 	 t   $F !     $F ! 	 t   $F !     $F  4	 Rpn @l
      @     e  4	 Rpn l
       0     U 
 b  n k
   R0n k
 P	 w	     	 >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pP; k
 b   Pk          2p`0 4
 rpn xk
 `k h       1    U  
4 
pX; H    4	 Rpn Pk
 pk        
 t d
 T	 4 R
 	 T d 4
 Rp 4
 Rpn (k
     0) )     ) )    )  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b  n  k
     : ! bp`0  n j
                                     I             I @           k 8   @           k H   p; ;     !< k     k    k    k     k    
 
2Pn j
  BP0  n j
 
  ` St
 6 
B`P0   T 4 2`! t @ #A J !   @ #A J  4  d T 2p! 4 `E E J !   `E E J !   4 `E E J ! 4 G G J !   G G J !   4 G G J $
 $d  4 r
pn j
 Pl \l               h    h             K @           hl 8            J J     J    J    K    K    K    K hl     ul    l     
 
2Pn j
 $
 $d  4 r
pn j
 l l               h    h             L @           l 8    L L     L    L    M    M    M    N l     l    l     
 
2Pn j
 $
 $d  4 r
pn `j
 l l               h    h             lM @           m 8   0N N     N    O    O    O    O    'P m     m    2m     
 
2Pn `j
  T	 4 2! t d  Q FQ M !    Q FQ M / 1 	p`0P; 8j
 r  Q AR     `R    R    S    ' - p`P0; j
 R  @m     Lm     `S S     T    ?T  4 R
p`Pn i
 `m lm    xm    m    m    m             T T     OU    cU    U    U    U    U  d
 4 
rpn i
 m m               h             O @           m 8           V )W     8W    <W    `W    W    W m     m    m     
 
2Pn i
 
   n i
  n W +X     6X " "d T
 4	 
Rpn pi
 n     @X kX      4	 
Rpn Hi
     pY Y      4" 	  p  n  i
 @n     Ln             pZ Z     Z    ! 	0; h
 r       Z [     [  	 0  X;    $	 $4  
p`P  n h
 `n     P] ]     ^   0  n h
 pn     |n |n     ^ (_     6_    _ 	`    ` & , p`0  ; h
 R       ` m`     `    ` 6 (d8 $47 0 	pP  ; Xh
 r  n     n    n n    n  a a     b    Mb    `b    b    #c ' - p`P0; 0h
 R      Pc c     c    1d 
   n h
               S @            o H   Pg ]g     ~g g     
 
RPn h
 
   n g
               |S @            o H   g g     g g     
 
RPn g
 
   n g
               S @           @o H   g g     g  h     
 
RPn g
 
   n g
               LT @           `o H   h h     >h @h     
 
RPn g
 
   n hg
               T @           o H   Ph ]h     ~h h     
 
RPn hg
 
   n @g
               U @           o H   h h     h h     
 
RPn @g
 
   n g
               U @           o H   h h     h  i     
 
RPn g
 
   n f
               U @           o H   i i     >i @i     
 
RPn f
 
   n f
               TV @            p H   Pi ]i     ~i i     
 
RPn f
 
   n f
               V @            p H   i i     i i     
 
RPn f
 
   n xf
               $W @           @p H   i i     i  j     
 
RPn xf
 
   n Pf
               W @           `p H   j j     >j @j     
 
RPn Pf
 
   n (f
               W @           p H   Pj ]j     ~j j     
 
RPn (f
 
 
t 4 1	  
p`0  ;  f
           p    p     p    p    p    p    p    
q    q    -q 
   9q    Eq    vq 
   q    q    q    q    q    q    q    r        Dr              <Y 	   B    r X   `k k     l    *l    am    m    Vn    n    o    Up    wp    p    p    q    Pq    }q    q 
   q    r    Gr    xr    r    r    s 	   =s 
   us    s    t    t     $r    1r    
 
rPn  f
  t d
 T	 R! 4 0u u XZ !   0u u XZ $ $d  T 4 
pn e
     u bv     v F 5u 0xv ,hw  
	p`0P; e
 B  Pr     \r    hr    tr    r    r    r    r    r    r 	   r 	   r    r    r 
    s    s    s    $s    0s    <s    Hs    Ts    `s    ls    xs    s    s    s    s    s    s    s    s    s !   s "   s `w ex     px    }x    x    x    
{    Z{    { 	   
| 
    | 	   S|    }|    | 
   }    [} 
   u}    }                (    =    ߀    D    n    ӂ    ڇ    ?    Ҍ            R    o    d    t                    Ð    $    V                ӑ        ג     +     !   9 "   ʔ #    "   9 !   Y         	       /    I    V    c % %h !t d 4 
	n e
          t    t                  p^ 	   B P   t H                і         1    F    E      t     %t    
 
RPn e
 % %h !t d 4 
	n `e
         @t    Lt                  @_ 	   B P   Xt H                !     6                  Xt     et    
 
RPn `e
 ) )h %t !d 4 
	n 8e
 t     t                             `    B P   t H               @          6         ȝ t     t    
 
RPn 8e
 ) )h %t !d 4 
	n e
 t     t                             `    B P   t H       p      E    f     Ҡ     t     t    
 
RPn e
 B B& =' 8x( 4h) %T p`0  n d
  u u u    $u    0u    <u    Hu    Tu           `u 	   lu 
   xu    u    u    u           u             b 	   B H  u x    V     h Т                         D    Ǩ    ٨    g     	   M 
       Э     
   Ȯ    B    P    p     
    	       @    p     Ӵ     
   2 	   g             u     u    u    
 
Pn d
 ' d 4 p; d
 Z   u     v      :         :     ! 
	p`0Pn d
 <v     0v    ev    qv    }v    v                       O    [        P    [                      d 4
 2
p! T	   pd !     pd  4 rp`Pn pd
 v @ g     -  d
 4 rpn Hd
 v P z     A  
4 
pX; @   ! 4 @ _ 
 !   @ _ 
 !   4 @ _ 
 	 	2`0! 
 t	 T   de !     de !   
  t	  T   de  
R0n  d
 v       ?  d 4
 
Rpn c
 P        d T
 4	 Rpn c
      $     O m       4 Rpn c
           ) / !t3 42 0 P  ; c
 r        3    q             / !t3 42 0 P  ; Xc
 r                    ,    ]  b  ! t 4   @g !     @g !   t  4   @g  R0n 0c
   '     B  
 n c
  w `        R0n b
 Pw   !     0  R0n b
 P        R0n b
       2 # #t
 d 4 rn hb
               h @           pw X              pw     ~w     bP0  n hb
  d 4  p  n @b
 w      x    -x  x  S                   4 R
pn b
 @x     nx    x               (    a  4 Rpn a
     p          n a
 x `       " "d 4	 Rpn a
 x     x           P  t T
 4	 R`2	  d 4  p  ; xa
                  j @           x H          x     x     BP0  n xa
 f
 fd <t 	 4 2% %4 p`n Pa
               0k @            y X       ` '     k  y     .y     bP0  n Pa
 ' / p`P0; (a
 b   B          . 4S N p`P  ;  a
 b  `y     ly    xy    y   }             (    v : : &  x 	h   / 1 	p`0P; `
 r       A     `              h 0!  x ` $ l !    ` $ l !     x ` $ l . 4S N p`P  ; `
 b                         * 0 p`0P  ; `
 r    Y     x        8    ] ] U  
	p`0P! h
  C m !    C m    n ``
 P      $ 	, 0  ; 8`
 R        B     @
 /t[ +dY '4X R 
P  ; `
   y     y    y y    y    y    'z    9z    Gz    Sz               #    :                    5     	   % &
 &d
 !T 4 R
pn _
 `z `       * 0 p`0P  ; _
 r            2        , ,4)  
p`P  n _
 pz     |z    z    z    z    h    h     z    z    z 	   {    /{    h     h h               o             )    =    S    p            !    0 	   F 
                       O          
               '  , ,4)  
p`P  n p_
 @{     L{    v{    {    {    h    h     {    {    { 	   {    {    h     h h             P             8    y                        q     	    
               X    h             - 
   M     Q g    w    d 4 pn H_
 |  M     i 
 
r0
 
4
 
rp= ,4= 2 
p`P  ;  _
    |     ,|    Z|    l|     z|    |                   /	    B	    	    F    P     x     6 (4   
p`P  ; ^
    |     |    |   
     *
    N
    \
    
       
0n ^
 |     | ` v              L :c 2d -e (xf $hg  
p`0  ; ^
 #  }     }           (}           !    -    9    E    Q    ] 
   i    u     
                      	      t 	   B    4} h         ;    I    y         
       >        d 
   r    + 
   G                             
   2    N     } 4}     B}    v}    }    }    }    @~    Q~    ~    ~    ~ 	   ~          P0  n ^
 A 0x ,h (4<2
p`P  ; ^
 b	                                   '    3    ? 
   K    W    c    o    {                        À    π                           #    m    r        	            
 	        
        
       j    {    - 
   
#    #    #    $    $    $    $    &%    3%    %    %    V&    g&    &    &    &    &    &    &    &    3'    M'    f'    '     ' A 0x ,h (4@6
p`P  ; X^
 	                       #    /    ;    G    S    _ 
   k    w                            ˁ    ׁ          ( (     ")    /)    C)    )    )    *    )*    *    
+    @+ 	   ,    7- 
   D-    - 
    .    .    .    ]/ 
   :3    3    4    54    B4    4    
5    V5    c5    6    +6    6    6    6    6    6    7    7    7    +7    c7    }7    7    7     7 / /h +/ 't. #d- 4, ( P  n 0^
               $    0    <    H     08 8     )9    79    k9    9    :    :    S:    ;    ;    ;    <     < "	 "d( T' 4& $ p  n ^
 ` < <     = "	 "d. T- 4, * p  n ]
 p = ,>     t? "	 "d( T' 4& $ p  n ]
 ? ?     @ "	 "d. T- 4, * p  n ]
 @ A     dB #	 #t3 d2 41 . P  n h]
               B {C     C    &D    ]D    
E    IE     dE 1
 1x -h )tC %dB !4A > P  n @]
          Ȃ    Ԃ         E F     F    *G    G    H    I     &I "	 "d( T' 4& $ p  n ]
 PI I     fJ "	 "d. T- 4, * p  n \
 J J     L "	 "d( T' 4& $ p  n \
 @L |L     VM "	 "d. T- 4, * p  n \
 M M     O #	 #d4 43 . pP  n x\
               0O P     ^P    P    P    Q    Q     R 0
 0x ,h (dB $4A < pP  n P\
          (    4          R S     aS    S    /T    XU    U     U 7
 )h %42 ( 
p`P  ; (\
 "  @     L    X    d    p    |     U V     V    W    *W    X    SY    Y    sZ    Z    Z     Z 7
 )h %42 ( 
p`P  ;  \
 "      [ [     '\    5\    Z\    ]    ^    _    _    _    _     ` <
 *hs &d "4  
p  ; [
 #                       ̃    ؃         	    
    
    
     
   , 
   8    D 
   P    \ 
   h    t                         	   B    x       @` `     ` a    2a Fa    a    c    )d    nd    e    f    yg 	   6h 
   ,i    =i 
   i    i 
   m 
   m    Wn 
   n    n    Uo 
   o    o    Lp 
   {p    p    ;q 
   r 	   s    7s    ls    s    s    s     t              
 
Pn [
 <
 *hs &d "4  
p  ; [
 #   ̄ ؄                                   	     
   , 
   8 
   D 
   P 
   \    h 
   t     
                  ԅ             p 	   B    x               t u     .u Zu    ou u    
v    )x    3y    y    z 	   v{ 
   l|    }| 
   |    } 
   Հ 
         
   ́         
   ł         
            u 
    	   N                    >    l              
 
Pn [
 @ .xc *hd &d "4  
p  ; [
 #                      )    ;    I    U    a     	               ʆ 
       
        '    3    d    v                ɇ               	   B     X           Ї h         6    m        ߌ        7    h     
           '    _            ߎ 	   / 
   O                    W    w                             
 
rPn [
 @ @ ; 6x 2h %> p`0  n `[
                         4               	   B     X            A     x    #        >        t             
 
rPn `[
  4 2p!
 
d T  #   !    #   !   d  T  #   $ Rp`0n 8[
               t @           @ 8    >     s @     M    
 
2Pn 8[
 $ Rp`0n [
                @           p 8        ޚ      p     }    
 
2Pn [
  2
p!
 
d 4   . 8 !     . 8 !   d  4   . 8 !
 
d 4   8 !     8 !   d  4   8 !
 
d 4 0 > 8 !   0 > 8 !   d  4 0 > 8  R
p`0n Z
                           @ @            8         (     2    C     Q      Ɉ    
 
2Pn Z
 !
 
d T ` s   !   ` s   !   d  T ` s   / 1 	p`0P; Z
 r  p џ         *        ) , p`P0  ; Z
 R             ,  H     g            2	  44 , p`P  ; pZ
 R      @      Ȣ        M    	 t d T 4    d 4 
p  !
 
 T Х   !   Х       zx dh &% p`P0!  
    4 !  	 	
   ߩ ` !     ߩ ` !      4  	  0  n HZ
 @     L             н           
R0n  Z
 о 	     O  d 4
 
Rpn Y
 `        
R0n Y
 @ y       
R0n Y
  )     o / !t3 42 0 P  ; Y
 r                    ;    l =
 ,hP (4  
p`P  ; XY
   ` l    x                             	               ) 
   5 
   A      (     w     8    I                [                    . 	   j 
   }             
       ] 
        
               8    X    t =
 ,hP (4  
p`P  ; 0Y
        X          h    y            *                #    D    ^ 	    
                
        
        
       +    ?    h         
 
d	 
Rp! 4   V  !     V  .  t d 4 	P; Y
 J   P \ h                  < < 7x
 3h /t' +d& '4$  
P  n X
              , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t ` }  !   ` }   d 4 pn X
        _ 	 	 0      d 4 p h d
 4	 Rp.  t d 4 	P; X
 J      Ċ Њ          h          = m    z           ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P  n hX
                          (    4    @    L                            D    k        I     	       E    Q    \    g    r              / / *x &h % 
	p`0Pn @X
 `     l     P                / / *x &h % 
	p`0Pn X
      J     O    K     V ( (d $T  4 
pn W
             0n W
 `
 
     8  R0n W
 P q       R0n xW
       0  0n PW
 @ t     
  R0n (W
 0
 Q
     `
  R0n  W
 
 
       
 n V
   T       R0n V
         R0n V
  q       0X; `   ! t    !      " "d 4	 Rpn `V
       D     R        n 8V
         { j7 b8 Z9 R: J; B< := 2> -x? )h@  
	p`0P; V
 b           ȋ    ԋ                            ( 
   4 
   @    L 
   }                        ͌    ٌ      &     7                K    \                  -    m             	       *     
        
       ! 
   6     
       $    A    g     "    "    '#    8#    E#    v#    #    #    '$    8$    X$    $     $ :
 (xT $hU  
p`0  ; U
 3               )    5    A           M    ~ 	                
                          G    S    _    k    w                          Ǝ    Ҏ    ގ                     @             T             h 	       X   	        X   	    (   X       0% &     "& &    & &    '    '    '    3(    (    )    o)    t)    ) 
   )    *    (*    *    *    *    + 	   \+ 
   ~+    +    ,    w,    ,    ,    -    d-    -    -    -    3.    r.    .    .    .    /    @/    O/    /    d0    v0    0    0    d1    v1    1    1     1    2    ;2      	         ,    9              
 
rPn U
 { j: b; Z< R= J> B? :@ 2A -xB )hC  
	p`0P; U
            (    4    @    L    X    d    p    |     
    
        
   ݏ            	        !    -    9             2 3     4    4    4    4    5    ,5    5    5    6    6    @7    q7    7    7 	   7    8    u8 
   8    8 
   9    %9 
   :9    : 
   :    ;    /;    R=    ?    ?    @    @    $@    U@    @    @    A    A    7A    A     A :
 (xW $hX  
p`0  ; U
 c  P         }                           ސ 	           
     
   G    Y    g    s                       ˑ    ב                          &    2    >    J             8             L             ` 	    H  \ X   	    P   X   	    X   X               B B     B C    C C    C    D    D    E    E    E    LF    QF    oF 
   F    F    G    hG    G    G    G 	   9H 
   [H    H    H    SI    dI    I    I    ]J    J    J    J    K    [K    lK    K    K    K    (L    L    L    L    NM    M    M    M    IN    UN    N    N \     i                           
 
rPn U
   
p`0  n pU
                	   B 8   ` H   O O     &P `     m         
 
RPn pU
  0. h 42 . p  ; HU
 R        R S     DS    RS     S = = 8 3x /h +4> 8 p`P  n  U
  ̒    ؒ                                  T gW     W    W    JX    X    Y    Y    Z    [    ]\    h\    \    \  p`0n T
               X @             8       \ 7]     ]       -    
 
2Pn T
  4
 
Rpn T
 P     `    p                            ] ]      ^    ^    ^    ^     ^    @^    _  0+
 +t# 'd" #4!  
P  n T
 Г _ _     c 4 4 /	 *x
 &h "d 4  pP  n T
  c e     !e  d 4 pn XT
  0g og     +h > > 9 4x 0h ,5 (t4 $d3  42 . P  n 0T
             Ph h     k    k    il     l  4	 Rpn T
 0     Z     l !m     /m    sm  4	 Rpn S
 p          m m     m    #n " "d 4	 Rpn S
      ڔ @n n     n    n # #t
 d 4 rn S
                @            H        o 5o     Ro          
 
RPn S
 ' 'x h 	   4 r
p`P!  p >q  !   p >q  ! h 
r r 0 !   
r r 0 ( (h $d  T 4 
pn hS
 ps s     Zu D 2 - (x  $h! D 
p`0  ; @S
               (    Y    k    y                    ( 	       H       u rv     v    ?w    lw    w    w    w    y    {y    z          Ε     
 
RPn @S
 D 2 - (x $h  B 
p`0  ; S
                   )    ;    I                    H 	      U H       pz z     {    {    {    
|    ]|    ||    }    }    P~ U     b         
 
RPn S
 & 4 p`P; R
 J       ~ ~           (    6     ŀ C    Q 
 t	 d T 4 2
 
4 
2`! t  Ń p !    Ń p    n R
        ! t  ̇ 
 !    ̇ 
 ! t   5 
 !     5 
 ( (h $d  4 
pn R
               H 	   B 8    X       Љ 9     ^                bP0  n R
 ! t  ؋ 
 !    ؋ 
  4 R
p`Pn xR
      (    4    D    P                   O    h                ˍ 	 	2P0! 
 t	 d   ` !     `  4	 2`! t  ӎ  !    ӎ  / 1 	p`0P; PR
 r  0              Q    !  x  t l !     t l !     x  t l )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '       ! h	    !      !       , 42 	0 p  ; (R
 r  @              d    = = *  x h   " 1 ;  R
 r  @          ܣ    Z    % %4) %  p`P  !& & 
 x h    !      !     
  x  h      n Q
 `               0 0h ,4  p
`Pn Q
 p     |                              F      ǩ     ֩            ¬    _    m                5      <
 *x %h 
p`0  ; Q
        	        !    -    9    j    |                   
   a    m     
                         d    p    |                Ɯ    Ҝ    ޜ                          ͝    ٝ             #   	 $    $   ! $   -    9    E )   Q 	   	         ȴ             ܴ              	   B     X         ʙ X      B     X   	   B    X           `      3    K    2                W    u 	       %        ʹ     
   @    ^        V    h                    "    >    P    ^    r    }        y        ϸ         % !   7    X    u            Ĺ     "       3 #    $    %   0 $   q &    $   Ļ '   ֻ $    #            9    U    q            n (        )   X *   j )   x        F      
   :    K 
   ʙ     ؙ    N    _            7    H    U                 {                          bP0  n Q
 B 1xS -hT )4  
p`P  ; `Q
 "  `     l    x                            ̞ 	   ؞ 	           ' 	   5    A           )             v    =    Z            2                     	   L 
   i 	   D    [     
               O 	                    	 3 3( .x) *h* &d^ "4] V 
p  n 8Q
 P                   \           h    t                	    
            
   ȟ 
   ԟ 
              
              
              
                                       	   B `   x           `     C    U                         	    
   b         
        
   H    Y 
   ~         
    	   R    q                       
 
Pn 8Q
 @ @
 ; 6x 2h ## p`0n Q
       ,    8    D    P    \    h                           P    B    t H                 z                 i            7                 F         '        7    C    O      t              
 
RPn Q
  d 4
 rpn P
  p        T 4 	p`n P
          Ƞ       K     Y    ~              D Dx @h <4> /6 !p`P  n P
          & 4 @     P k                  c    o $ $h d> 4= 8 p  n pP
 P     \    h                                    	      t                      V    g        S                          &     H t     
 
Pn pP
 :
 (x* $h+ X 
p`0  ; HP
            ȡ                                        	      ԡ        p              M        "    P        }                    ԡ     
 
Pn HP
 $ $h d< 4; 6 p  n  P
       ,    8                  _    k             0 	      D                       f    o        =        p                       5 D     
 
Pn  P
 :
 (x( $h) T 
p`0  ; O
 {                                 ˢ    ע             X 	    p          `              %                    J    V     x |               
 
Pn O
 : : 5h 142 %( p`P  n O
                 k         L    e        y <
 * %h 0 
p`0  ; O
 S                    ,    8 8                	   B (                    Q     1 Z    '          q       .    e    }    ۣ              P0  n O
 . .x )h $t?  d> 4= 8 	  n O
 P     \    h                                   , 	      t          $    5        !    U    D                       	 t     
 
Pn O
 :
 (x* $h+ X 
p`0  ; XO
            Ȥ                                       H 	      Ԥ        @              )	    	    	    
        V    b                Ԥ     
 
Pn XO
 )
 )x $h d> 4= 8 p  n 0O
       ,    8                  _    k             d 	      D             
     @    I            V    E                       
 D     
 
Pn 0O
 :
 (x( $h) T 
p`0  ; O
 {                                 ˥    ץ              	    p          @                                  5    A     c g    s           
 
Pn O
 <
 * %h 0 
p`0  ; N
 S             ئ                           	   B (                   a     A j    7                  5    M            ɦ      P0  n N
 <
 *hh &d "4  
p  ; N
 s           ,    8    D    u                 	   ާ 
           
        G    Y    g    s            ¨    Ш    ܨ                     d 	   B     H                                            !    J!    {!    !    !    "    :"    r"    "    " 	   " 
   B#    b#    # 
   #    #    $    k$    $    $    $    %    %                 
 
RPn N
 4 4h! %D p`0  n N
 0        <    H    T                      	   B    ` X               & X'     q'    '    T(    (    t)    ,    ,    `     m    z    
 
rPn N
  d 4
 pn hN
 0- -     - :
 (hp $d  4  
p  ; @N
                               	        !    R 	   d    r    ~     
       ͪ    ۪            $    6    D    P    \                                        	   B x   ū H                . .     .    ^/    2    ?2    2    2    2    3    B3    d3    3    3    4    >4    k4 
   4    4    4    55    f5    5    5 	   6 
   %6    ]6    6    6    6    -7    M7    7    7    7    7     ҫ    ߫    
 
RPn @N
 ! t P8 e8 p !   P8 e8 p  t d
 T	 4 2 T r
p! h 
d
 4 p; ;  !   p; ;  ! h 
d
 4 0< N<  !   0< N<  Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P  n N
       h      ? D@     B    
B     $C * , p`0  ; M
 [                                   B P   H   C C    
D     D      *     BP0  n M
 >
 ,x- (h. ^ 
p	`0  ; M
   p |                        Ĭ    Ь    ܬ 	       
    	       
             	   B    H   D E     sF    F    BG    RG    "H    2H    I    I    I 	   J 
   J    _M 
   {M 	   P    P    Q    Q    Q          L     
 
RPn M
 + +h ' #t d 4 Pn M
 `     l `Q Q     US    hS     S >
 ,x' (h( R 
p	`0  ; xM
 k                       ȭ    ԭ         	       
    	       
             	   B `   H               T hU     2V    DV    RW    _W    "X    2X    Y    Y    Y 	   Z 
   Z    ] 
   ] 	   ?a    Na    ]a    ia    ua          \     
 
RPn xM
   n PM
 p     a a      R0n (M
   b b     b  
R0n  M
   c 9c     c  d 4
 
Rpn L
 c c     >d  4	 
Rpn L
      @g g     g  
R0n L
 h Ih     h  d 4
 
Rpn `L
 h h     Ki  4 Rpn 8L
     i i     i  4 Rpn L
     `j j     j  
 n K
 j k     ck  R0n K
 k k     k  R0n K
 k 1l     Ll  R0n pK
 pl l     l * T 4 p`; HK
 Z   h                          l 7m     Dm    m    xn    n     n * T 4 p`;  K
 Z   n <o     Io    o    }p    p     p # #t d
 4	 Rn J
     ps s     ut &
 &d
 !T 4
 R
pn J
  t t     / /x +h	 'T #4  
	p`  n J
 @     v ew     x &
 &d
 !T 4
 R
pn J
 0y _y     = / *x &h % 
	p`0P; XJ
    P { |     }    T 4
 
R	p`n 0J
     P~ y~      d
 T r! x h 
t 4
 ` ~ x !   ` ~ x    4  p`P  n J
 `       3       h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  n I
             @              '    :    h            =     	   w    ;    G    R    ]    h             ׏    T 4
 
R	p`n I
     @ i     #
 #h d T 4 pn I
 p |     P          ߓ    
     "	 "T 4  	p`  n hI
          P        
 X;    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  n @I
              w                             ;        o 	           ɡ    ԡ    ߡ            1     Y  
 n I
        C  R0n H
  `        R0n H
       ,  R0n H
 P w      J J B
 = 8 3x /h +t- 'd, #4+ $ 
P  n xH
       M " "d 4	 Rpn PH
           P 	 	B  ! 4 0 i > !   0 i > " "d 4	 Rpn (H
       *     @           / /h
 + 't #d 4  P  n  H
 @ L    X     P              Ҳ    3 S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P  n G
 p      K     ` . h 42 . p  ; G
 R  и      G    U      = = 8 3x /h +4> 8 p`P  n G
                      Ȱ    ԰       G     d        *    Ⱦ                    =    H    g    r V H @ 8 3 .x *h &44 * 
p`P  ; `G
            . h 42 . p  ; 8G
 R  p               X = = 8 3x /h +4> 8 p`P  n G
               $        h        *    5    &                 " "d 4	 Rpn F
      
 P            t d 4 	 4H @ 
p`P  ! G   < !     < 3	 %46 0 p`P  ; F
 z        ,    8    D    P    \            @              .            6 (t/ $d.  4, ( P  ; F
 :  p     |                 <     a             h R00	 0 & x 	h   !   #  !    #  !     #  / / & x h 4 p!     !      !       8 8 & x h 4 p"
 "4 
p	`Pn pF
                  R R J B
 = 8x 4h 04- !" p`P  n HF
      ̱    ܱ                    $             P                      #                         8 8( 3) .x* *h+ &d` "4_ X 
p  n  F
 0            <           H           T    `           l 	   x 
            
    
    
              
              
              
                                       	   B `   x               `     L    ^                         	   A 
           t 
   h    y 
        
   
    C
    x
 
   
 	   
        #     R      Ͳ    ڲ    
 
Pn  F
 2 2 -x )h %t !d T 4 
	n E
        0 0x ,h (d $T  4  
p  n E
        
 1     U          3	 !4= 6 	p`  ; E
         ,    8                                	   B x   D h                	                 7    S     X    t      D     R            	      P0  n E
 <
 * %h 0 
p`0  ; E
 S                 $ 0 <    H H                	   B (  0     a     A j    7         0     >    u                	      P0  n E
 <
 * %h 0 
p`0  ; XE
 S             H    T ` l    x x               $ 	   B (  `             q     Q z    G         `     n                ,    9      P0  n XE
 <
 * %h 0 
p`0  ; 0E
 S             x                          D 	   B (                    a     W          "          ն        K    \    i      P0  n 0E
 <
 * %h 0 
p`0  ; E
 S                   ̸    ظ ظ               d 	   B (               # #     q$ $    g%    %    '      η            {              P0  n E
 " "4
 rpn D
               , @            X   ( (     (           bP0  n D
 " "4
 rpn D
                @           ` X   ( H)     ^) `     n     bP0  n D
 <
 *hv &d "4  
p  ; D
 S          ̹    ع            '    5    A    M 	   ~ 
                                       P    b    p    |            ˻    ٻ                         , 	   B     H   ) /*     H*    v*    +    2.    T.    .    .    .    0/    ]/    /    /    /    '0    X0    0    0    0    1    O1    1    1 	   1 
   2    ?2    w2 
   2    2    2    G3    g3    3    3    3    4                 
 
RPn D
  0(
 (x #h  	p`P0  n hD
 0                       < 5 n7    
8 G8     [8 '
 'h	 #T 4  	p`  n @D
 P \    h 9 :    ;    ;    ; <     0< ' 'x
 #h  
	p`P0n D
              `< R>    &? c?     w?  R
p`0n C
                           @ @            8       ? ?     ?    ?     @      ɼ    
 
2Pn C
  R
p`0n C
                            @            8       @ 8@     B@    S@     b@      	    
 
2Pn C
 % % !t d 4 
	n C
               x @             X       @ A     SC yC     /     RpP0n C
  R
p`0n xC
         `                   @           | 8   C C     C    -D |         
 
2Pn xC
 % % !t d 4 
	n PC
                @            X       @D qD     F F          RpP0n PC
    4 Rp`n (C
                           0 @            8        G .G     ;G    qG     G      	    
 
2Pn (C
  4 Rpn  C
                             @           < 8       G G     G    G <     I    
 
2Pn  C
  4 Rpn B
         `                  h @           | 8        H *H     8H    FH |         
 
2Pn B
  T 2`! 	 t 4 `H zH  !   `H zH   d 2p! T 4 I I  !   I I  ! T 4 J J  !   J J  5 5x h   ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P   T 4 p`!   `U U  !   `U U  
 d T 4 p!  0X `X  !   0X `X   h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
pn B
                                     	   B     ľ 8           ] ]     ]    ^    e^    w^    ~_     _ ľ     Ѿ    
 
2Pn B
  4& $ p  n B
                                  	   x      8   _ 	`     >`    [`    `     ` `     `      
 
2Pn B
  d	 4 Rp R
p`0n `B
                            H @           < 8        b Hb     Rb    cb     qb <     I    
 
2Pn `B
 Y Yh  0  ' 'h "d T 4
 
rpn 8B
     d ,f     Rf ' 'h "d T 4
 
rpn B
     f g     g #
 #h t
 d 4 rn A
  h h     i " "d 4	 Rpn A
  l Dl     Rl    l " "d 4	 Rpn A
 l m     m    `m " - 	p`X; @  !C
 Ch 8, &4 T3 42 o p  !   o p  	 d T 4  p  n pA
 `     l    x     0s fs     s    s    :t    t     7u    T
 4 
R	p`n HA
       u v     `v    pv )  	p`0PX;   !/
 /< &x= h> ~ Ԉ v ;w  !   v ;w  ! 
  <  x=  h>  ~  Ԉ v ;w  3	 %49 0 p`P  ;  A
 z  P ۂ         B    ^    ͅ    ܅     4* 	( p  n @
    3     w !     !      !        x h 
- n @
      ̿    ؿ                p K     M          $    C \      k 
	`P!*
 *2 x3 h4 tj 4s  Ǝ   !    Ǝ    4
 
Rpn @
                 @            8        Օ               
 
2Pn @
  4
 
Rpn @
                @             8        5     ^       -    
 
2Pn @
   x h   
 x h p`P0$
 $  x h 
 2 2x .h	 *4  p
`P  n X@
 P     \ @                " "x h 	p`P0! t   ? 
 !     ? 
 $
 $d  4 r
pn 0@
                @           p X              RpP0n 0@
 ! t   
 !     
 $
 $d  4 r
pn @
                @            X              RpP0n @
  
p`0  n ?
                             @            H         *     Q    j           #     2pP0n ?
  `  ! T    ! t 4  T    !   t  T  4       ! 4  P d  !   P d  ! 4     !      !
 
t d  8 C !    8 C !
 
t  4 p   !   p   !
 
t d P x C !   P x C . .4= 4 
p`P  n ?
        E      UeDx  =h! 6tL /dK (4J cD 
P; ?
   p      *      ! 4   
 !     
 !   4   
  
R0n h?
 `        d 4
 
Rpn @?
  >       
R0n ?
  	     O  d 4
 
Rpn >
 `        4 Rpn >
     p        4 Rpn >
     0 ^     y  d 4
 
Rpn x>
        7 	 	b   
 n P>
       c  R0n (>
         R0n  >
  1     L  R0n =
 p        
 n =
       S  R0n =
 p        R0n `=
  !     <  R0n 8=
 `       s st 
 ! 4  Z  	 !    Z  	 " "d 4	 Rpn =
       0 t          " "d 4	 Rpn <
        4     B     Pe?h 841 &c!& p`P; <
          1      ' 'd #T 4  
p  n <
              0 x         z } }  x 0! h  } p
 !    } p
 3	 %40 ( p`P  ; p<
 :      0          U    d     @ `0P  ! I H tF   
 !     
 !   I  H  tF   
  "p0  !    d T
   6 T !     6 T  d 4 p! t d 4   
 !     
  4* 	( p  n H<
   S      = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x `  t !   `  t * * h  !   j  !   x j   !   j   !    j  @
 @ , "   ! x P  
 !   I (
 ! h I  <
 !   I  <
 !    I (
 !   P  
 9 9 !x 
 !  h  e 
 !  e  
 !    
 !     
 !   e  
 !    e 
 9 9 &x h 
  !     !    ( !     ( !        0  ' / p`P0;  <
 b  
 
     D     ' 't #d 4 
Pn ;
 0     <           
    
     ;  d Rp! T	    ! h 
 4   $ !     $ !      /
 /t" +d! '4   
P  n ;
     `      c )
 )h
 $t  d T 4    n ;
 P  U      ! T  
  !    
   d
 T	 4 Rpn ;
       . =     Y !" "t  d 
T 4 0 W  !   0 W  ! t  
d 4    !      !" "t  d 
T 4 p   !   p    Bp
`  !$
 $  
 
T	 4  ,  !    ,  ! t  
d 4    !      + - 	p`P0; X;
 R  ! r!     !    !    "    + - 	p`P0; 0;
 R  `" "     "    #    f#     2pP!
     
d 4	 # #  !   # #    P!   t d 4 & 0' 0 !   & 0' 0  
R0n ;
 @( y(     (  d 4
 
Rpn :
 ( )     {)  4 Rpn :
     * >*     Y*  @ 
	`P  ! > t? 4F  0 60  !    0 60   " P   R0n :
     2 2     3  
 n h:
  3 T3     3  R0n @:
 3 3     3  R0n :
 4 q4     4  R0n 9
 4 4     4 " "d 4	 Rpn 9
 5 T5     b5    5 " "d 4	 Rpn 9
 5 6     "6    p6  4 Rpn x9
     6 6     6 " "d 4	 Rpn P9
 `      7 T7     b7    7 IE;h 7t! 0d  )4 C 
P; (9
      7 <8     8    : W
 Wx 8h  4J B 
p	`P  ! I P: : P !   P: : P U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4  `E E  !   `E E  !  t d G G C !   G G C !  t d H I C !   H I C  p  ! 4 @L TL  !' '  d TL qL  !   TL qL  !   @L TL   . `P  !p ph :* /+ $, t- 44 M M  !   h  *  +  ,  t-  44 M M   
R0n  9
     0P iP     P  d 4
 
Rpn 8
 P Q     kQ  d 4
 
Rpn 8
       Q Q     Q    Q  d 4
 
Rpn 8
       R `R     vR    R  
 n `8
 T $U     sU  R0n 88
 U U     U  R0n 8
 U AV     \V  T 4 `  ! t V V  !   V V  " "d 4	 Rpn 7
     W $X     2X    X " "d 4	 Rpn 7
       * X X     X    @Y Pe?h 841 &c!& p`P; 7
       `Y Z     ] 3	 %49 0 p`P  ; p7
 z  @     L    X    d    p    |            ] k^     ^    ^    _    ]a    la    0
E"h t d 4 C
P  X; `   /
 /t" +d! '4   
P  n H7
 f !g     g /
 /t" +d! '4   
P  n  7
  i ai     j O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4 t t  !   t t  ! t  d 
T 4 pv v  !   pv v  " "4 
p	`Pn 6
 `x x     y Ne=h 6t< /d; (4: c4 
P; 6
          z z     {    ~     ~  	  h d 4  p  n 6
          t d 4  t T 4 ! d  !  !    !  " "d 4	 Rpn 6
               ` 
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h  % @ !    % @ 	 	2p0!  
d	 T  ѓ  ! 
 ѓ   !   ѓ   !    ѓ  !" "t  d 
T 4    !       T `  !
 
t 4   , !     , ! t   p !     p 9 9 "% p`P0!{ {	 m
 X I =
 1   x h p   !   p   !   	  
      
      x  h p   
 
0!,
 ,  ( t d T  ګ  !    ګ  <5.h *t #d 4 3
P  ; X6
 R      D         ) )d: %49 2 	pP  n 06
        t       d 4
 rpn 6
       >    O -	%t d
 4 #P  ; 5
 B        p O     ` , ,1 pP!I Ih :+ ', #- . 
d/ 40   x  !     x  L L 7 " p`P0!| | g C 9 	 x
 h  -   !    -   1
 1h -4# ! p
`P  n 5
                 0             p
 ph hd+   
p0P  !  t d   C !     C !d d	 [
 O B 9
 0 $ x h  D  !    D  !   	  
      
      x  h  D  ! !dK !4J !B pP  ! h  I   7 T" !   h    7 T" !     7 T" '
 'tK 'dJ '4I 'B P  !* * ! x h  @  " !   @  " !  t d   L C !     L C      T 4 
R	p`n 5
     p        T p  !
 
d 4 p  h# !   p  h# /
 /t0 +d/ '4. ( 
P  n h5
     p       /
 /t0 +d/ '4. ( 
P  n @5
  N     )  9 
0P! 5 6 t7 d8    $ !      $ !   6  t7  d8    $  	  h
 d 4  p  n 5
      0      BE1h *+ #* d) 4( C	& PX;      ! t d 4 p  $ !   p  $  d
 T	 4 Rpn            	 "  z    
 n  n  P  
 
4
 
rP t	 d 4 2z     
 ,      d 4 2pz     < C     	 4 rp`z     K _ K  rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!    [ <& !. . 	 [  \& !	 	   p& !     p& !   [  \& != =2 *3 4 4=   & !     [ <&  B  ! 4 @  & ! t  4 @  & !   @  &  20 R0
 
4 
2p 20%	 4- $ 
p`P  X;   " "t 20 % X;    B   B  
 
4 
Rp 20
 t
 d T 4
 r B   B   20! 	 t 
d T ( ) ' !   ( ) '  20
 
4 
2p d 4 2p 4 p R
pP0! d
 , , D( !   d
 , , D( !   d
 , , D( !   d
 , , D( 
 
4 
2p! d `/ / ( !   `/ / (  20 d	 T 4 2! t 01 1 ( !   01 1 (  20
 
4 
2p 20u ut 
4 
2`
 
4 
2p 4 2
p`P 4  d 4 2p
 
4 
2p B  ! 4 < < ) ! t  4 < < )  B  ! 4 < I= ) ! t  4 < I= ) !   < I= )  B  ! 4 = )> ) ! t  4 = )> ) !   = )> )  B  ! 4 > 	? <* ! t  4 > 	? <* !   > 	? <*  B  ! 4 ? ? * ! t  4 ? ? * !   ? ? *  B  ! 4 p@ @ * ! t  4 p@ @ * !   p@ @ *  B  ! 4 PA A + ! t  4 PA A +  B  ! 4 B iB <+ ! t  4 B iB <+ !   B iB <+  B   B   B   B   B   B   B   B  U UT	 P4 t d
 2 d T 4 p T	 4 2p!  d `F F + !   `F F +  2p 4  bp`  !) )     
T 4
 H H 8, !   H H 8, 
 
4 
2p T 4 Rp`! 
 pJ J , !   pJ J , G G4 d T 2p B   T 4 R
p`
 
4 
2P!
 
t d N N , !   N N , !   t  d N N , !   t  d N N , 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !  X X - !    X X - !H
 HT : 5t
 0d	   X X -  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p T 4 Rp` d 4 2p! T h i h. !   h i h. 
 
20 d	 T 4 2p!  k k . !   k k . !    k k . !   k k .  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d s t L/ !   t s t L/ !   s t L/  t 20 20 d
 T	 2
p! 4 0v nv / !   0v nv /  t	 d T 2! 4 0w lw / !   0w lw /  B   20 20 20
 
d	 
Rp! 4 z z 80 !   4 z z 80 !   z z 80  t d 4 2 t 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p 2p! 4   1 !   4   1 !   4   1  B   d 4 2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	 p  2 !   p  2  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	  ' 3 !    ' 3  B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
Pn x               @ t             g    t        %      2P'
 '4 
p`Pn          -     A          2P6 (4   
p`P  ;     .     "    T    h    `                                                         2P, ,4"  
p`P  n  l              `                                2P'
 '4 
p`Pn        0 ]     q    .      2P, ,4"  
p`P  n @          #    /       )    2    >        6    P      2P'
 '4 
p`Pn h G     ;                 2P- -x )h %4 
p	`Pn  |     p 0 c     w    a      2P' d 4 p;  j      -      2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 4 r
p`PX; 8   
 
4 
Rp9
 +t! 'd  #4  
P  ;               	 :	     M	    ]	    [
	    
	     /	 9
 +t! 'd  #4  
P  ;                	 J	     ]	    m	    k	    	     ?	  d 4 pn 0       	 6	     ?	    	     Y	  d 4 pn X +     7 	 	     	    	     		 9
 +t! 'd  #4  
P  ;     C     O    [ p	 	     	    	    	    E	     	 9
 +t! 'd  #4  
P  ;     g     s     	 	     	    	    	    U	     	 9
 +t! 'd  #4  
P  ;               	 	     	    	    	    e	     	 *
 *4 
p`Pn        	 	     	    #	     e$	  t d T
 4 r9
 +t! 'd  #4  
P  ;                    ,	 -	     8-	    A-	    Q-	    3	    S4	    4	     y5	  B  
 
4 
Rp, ,4  
p`P  n H              h    h    h  8	 ^8	     w8	    8	    <	    =	    '=	    O=	    s=	    =	    @	    (A	     RA	 	 $ 
p`0  n p      '    3                           ? @           ? X   A	 A	     A	    A	     C	    C	    G	    G	     
H	 ?     L    s     
 
rPn p 
 
4 
Rp  	  !e e ]d   t T 4 0I	 JI	 @ !    0I	 JI	 @ !   0I	 JI	 @ !         t  d  T  4 0I	 JI	 @ 
  p
`P0 T
 4 rp`  
  !m m b  t d T 4 q	 q	 @ !   d q	 q	 @ !   q	 q	 @ !         t  d  T  4 q	 q	 @  T
 4 rp` b  !6
 6 1t )d 
T 4 	 	 dA !   	 	 dA ! 
    t  d  T  4 	 	 dA )	 ! p`0  n                                          ,B @            8   	 ф	     ބ	    	    	    	    P	    	    	    ٌ	     	               
 
2Pn   d T 4 p*	 *4  p`  n                                  0C @            8   `	 	     	    Ɠ	    	    	     Ŕ	          ?     
 
2Pn  #
 4 
p`PX; X    	p`P0X; @   
 d T 4 p t d
 T	 4 2 	p`P0X; X    BP  !; ;t
  
d	 4 0	 ?	 0D !   0	 ?	 0D : :	 5t -d 20   !8 8 , $t d 
T
 4 	 	 D !   	 	 D 
 d T 4
 Rp% I PX;    ! 4H "C D E tF dG p	 	 D !   D p	 	 D !   p	 	 D !   C  D  E  tF  dG  4H p	 	 D #
 4 
p`PX; `   D
 Dt d	 T 4 2
 d T 4 p   X;    !$ $  t d T 4 	 	 E !    	 	 E !   	 	 E 
 d T 4 p P  !6 6 ' " t 
d
 4 
 
 ,F !   
 
 ,F  bP  !$ $   t 
d 4
  
 
 pF !    
 
 pF  T	 2! t d 4 
 
 F !   
 
 F  2
p`0! 
 
 T
 
 
 F !    
 
 F !   
    T
 
 
 F 
 t	 d T 4 2 20 20 d 4 2p t d T 4 #	  
p`0  n  M     Y    h    h    h           e                    H @            8   
 
     
    :%
    l%
    %
    %
    %
    !&
    &
    &
    &
    (
     (
                2P
 
2Pn   d 4 2p)	 !" p`0  n                                        M           h    h    h                                             I             I    
         I             J @            8   @           m 8   @            8   @            8   )
 -*
     A*
    p*
    W/
    l/
    /
    /
    /
    3
 	   '4
    N4
 
   {4
    4
    4
    &5
    55
 
   J5
    9
    9
    W>
    >
     >
          ?     z                       B      2P
 
2Pn   2P
 
2Pn   2P
 
2Pn  
 
2Pn   4 
p`PX; X    d 4 2p6 (40 & 
p`P  ; 8 *  \     P            h PC
 C
     C
    C
    D
    wJ
    J
    J
    PK
    K
      2P6 (40 & 
p`P  ; ` *                   h K
 %L
     EL
    L
    L
    S
    2S
    rS
    S
    T
      2P; -x )h %4*   
p`P  ;               pT
 T
     T
    T
    
    ȵ
     
  4(   
p`P  9
 +t1 'd0 #4/ ( 
P  ;  :         
 
     
         
  20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   d T 4 2p bP  !$ $   t 
d 4
   |O !     |O  T	 2! t d 4   O !     O  2
p`0! 
 
 T
 `  O !    `  O !   
    T
 `  O 
 t	 d T 4 2 20 20 B    n                        P 	    (   & 8   	   8 0   _ 8   	   0 8    8   	    @    8   	   (6 H   - 8   	   x P    8   	   - X    8   	    . `    8   	    h   z 8   	   ` p    8   	   B x   2 8   @           k 8    " 0"     G" &     3    Q     l                           :    {                       +    l                  $     ?    ]     x         
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn  
 
2Pn   B  # 4 rp;   2    " "     # 1	 #t! d  4  P  ; (                                      , # #     .$    S$    |$    $    $    $    /%     %    %    
&    /&    @&    S&    ]&      2P d
 4 
Rpn P 8 & &     '  20 B  ? .4  
p`P  ; x :  D     P    \    h    t                     	    
            
               (    4    @    L    i    u                                             	 !        ! #   - ( W)     g)    a+    +    ,    8,    ,    , 	   , 
   ,    - 
   -    -    -    y.    .    .    
/    F/    /    /    /    /    20    >0    0    0 !   0 "   1 $   91    o1    1    1    h2    2    2    2     2  2P 20   ! 4
 5 5 \W !   5 5 \W    ! 4
 6 (7 W !   6 (7 W 
 
4 
2p 2p! 4  9 B9 W !   4  9 B9 W !   4  9 B9 W !   4  9 B9 W !   4  9 B9 W !   4  9 B9 W  B  
 t	 d T 4 2    h 	x    h 	x                  K                  $     X                    X X 0Z                                                  `         8   <                 @     8]                    0[ \ Z a 0Z hf p]                                     (          K                  P     f                           g                     :         (   `d                 B            `                       d                                 )                      ]                    ^ a 0Z                     	 (          =                `2         X                            h    c                      H\                    c d a 0Z `c  e                                 	            =                          @   `                       ^                              8   =                @a ` a a 0Z `c  e                                     )         P   c                        a                    b  g 0Z                           Z                     8         @                    Y a 0Z                    X 0Z                 p     P                           (     e                             X   @(                 \ [ 0Z                    [ pe 0d Z d  e                                       d                     (6            e                              >                @F         X   0P                       X]                      "         8   ;                 6         @   P                e 0Z                "         X   h                X_ g b  g 0Z `c  e                                           c                     p     @_                     b  g 0Z                          x[                           b                     p         @   (                           @   `                 0            p>                          X   @                       Hf                    b  g 0Z                             X                          c                           f                     8            0                   .            >                 8            6                              v                          X   `                          8   =                X^  g 0Z                    a 0Z                 -            b                              P                ^ X 0Z                           b                     0        (   C                 g     _                     @     Hg                     g 0Z                =         X                    B (          `                  0         (   C                 b     `Y                           f                    He a 0Z                     f [ X^  g 0Z `c  e                                              @   P                 p     @                          `            0?                          @                             8   p?                       \                    ] `` xZ a 0Z `c  e                                    P"         X   о                a a 0Z                     0 (       (   C                pb ` 0Z                    a 0Z                ^ _  g 0Z `c  e                                        `                                 _                 Hb g  b  g 0Z `c  e                                    ` ] 0d Y d  e                                          @                    P:         @   h                 7#[    Bh          8h <h @h  h   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747.cp35-win_amd64.pyd PyInit_stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747 o           j         ^  i            Hm          h n         ֘  m           xo           Po         6 p n         X 0 n         x  m                                   l                    Γ     ܓ                    *     >     X     l                    Δ                    .     D     ^     z     z                  &     r               2     v                l          ڄ          V          ʃ     n               ƀ          6     b                              6     \               ܂               >     "          Ȓ          |     ^     8                         n     2               l     *     ֏          T          Ў          F               p     (               ^          ԋ          R                    P               $          v     @     ,                       ڕ                         "     H     `     j     ܙ          ҙ                             0                       p                       4                         
                     &     ,                  Ș                         p     T     2                         H                       ֖     x     \     R          >     җ                            ̖                       Ė     f             }     }     }     x}     b}     L}     8}      }     }     |     |     |     |     |     |     t|     b|     F|     8|     $|     |     |     {     {     {     {     {     {     {     p{     X{     H{     .{     {     z     z     z     z     z     z     ~z     hz     Xz     Dz     0z     "z     z     z     y     y     y     ~     y     y     y     }     Py     <y     (y     y     y     x     x     x     x     x     x     rx     \x     Nx     <x     "x     x     w     w     w     w     w     w     |w     lw     Tw     >w     ,w     w     w     v     v     v     v     v     ~v     jv     Tv     "~     8v     }     6~     H~     Z~     v     l~     |~     ~     ~     u     ~     ~     ~     ~     jy     u               0     H     \     p     u     u                                              $     8     L     j     u      ~     y     u     u     ru     bu     Ju     *u     u     t     t     t     t     t     t     xt     dt     Pt              PyBaseObject_Type kPyObject_SetAttr  PyUnicode_InternFromString  < PyCFunction_Type  .PyOS_snprintf PyThreadState_Get _Py_CheckRecursionLimit  PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches v_PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  PyExc_RuntimeWarning   PyErr_PrintEx VPyFunction_Type EPyFrame_New PyLong_AsSsize_t   PyExc_DeprecationWarning  PyExc_KeyError  uPyImport_ImportModule wPyImport_ImportModuleLevelObject   PyErr_NormalizeException  KPyUnicode_AsUnicode iPyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  kPyUnicode_DecodeUTF8  MPyObject_GenericGetAttr PyTraceBack_Here  PyExc_RuntimeError   PyExc_IOError lPyObject_SetAttrString  PyLong_FromLong LPyObject_GC_UnTrack PyUnicode_FromUnicode YPyObject_Hash  PyErr_SetNone PyExc_MemoryError  PyDict_GetItemWithError Py_GetVersion RPyObject_GetAttr  4PyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags ' PyBytes_AsStringAndSize #_Py_NoneStruct  
PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size 7PyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable VPyObject_GetIter  PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx $PyExc_ValueError  _Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError gPyObject_RichCompare  PyTuple_Type  _Py_FalseStruct <PyFloat_Type  PyMethod_Type PyLong_Type PyType_IsSubtype  PyNumber_Subtract  PyErr_Restore 
PyExc_OverflowError qPyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  C PyCapsule_GetPointer  JPyObject_GC_Del  PyErr_Fetch =PyObject_CallFunctionObjArgs  PyLong_AsLong CPyObject_ClearWeakRefs  cPyObject_Not  PyUnicode_FromFormat  TPyObject_GetBuffer  PyList_New  PyModule_Create2  PySlice_New dPyImport_AddModule  PyType_Ready  SPyObject_GetAttrString   PyErr_Clear PyList_Append 3 PyBytes_Type  YPyUnicode_Decode  T PyCode_New  -PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  ;PyObject_CallFinalizerFromDealloc _PyDict_GetItem_KnownHash ]PyObject_IsInstance 
PyNumber_Index  PyExc_StopIteration PyList_Type  PyDict_GetItemString  UPyObject_GetItem  @PyObject_CallObject  PyErr_CheckSignals  KPyObject_GC_Track 0 PyBytes_FromStringAndSize rPyImport_Import PyExc_NotImplementedError SPyUnicode_Compare ^PyObject_IsSubclass PyExc_TypeError PyMem_Realloc ; PyCFunction_NewEx K PyCapsule_Type  _PyObject_IsTrue PyExc_NameError PyTuple_Pack  _PyByteArray_empty_string Py_OptimizeFlag _PyUnicode_Ready  PyMem_Malloc   PyExc_IndexError   PyExc_ImportError *_Py_TrueStruct  
 PyArg_UnpackTuple PyExc_SystemError  PyExc_AssertionError  mPyObject_SetItem  _PyObject_GC_New  PyTraceBack_Type  PyMethodDescr_Type   PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  _PyType_Lookup  nPyObject_Size  PyBuffer_Release  9PyObject_Call $ PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python35.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 1EnterCriticalSection  LeaveCriticalSection  
DeleteCriticalSection SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  vGetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  iSetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  ~IsProcessorFeaturePresent wIsDebuggerPresent AQueryPerformanceCounter GetCurrentProcessId GetCurrentThreadId  GetSystemTimeAsFileTime DisableThreadLibraryCalls aInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2-+  ] f      /                              0   ?
                     (Q                                   "           B                              2   в   P                   B   0                            @                   B                          B                          B      `                   6   @                                                B                          C   `                      =      @                                                                   p	                                   >   p                                                                  P                                                       D     >                                          p                                                                      p                                                                                                           @                                                   Transform parameters from unconstrained space to defined support                
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
                                  PF                                                                                                                                       @                                                                                                                                                                                                                           `@    
                  p@   
                  @   
                  D1   	
             @   	          Ъ   x>   	             @   `	                  @   	          p   @   К	                  @   	             @   @	             @   	          P   A   }	             (A   o	          0   @A   [	          p   XA   PH	             hA   A	             A   8	                  A   6	                  A   6	                  A   6	                  A   ,	                  A   %	                  A   	                  B   	                   B   p	                  8B   `	                  HB   	                  `B    	                  xB   	                  B   	                                                                         F                   P                                                                                                                    @                                                                                                                                                                                                                       (]          t                      8]          H              H]   x]          h                                                              Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              \   @2          P\   -   +          \   L.   `/          \                                   Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
                                  `G                   @                                                                                                                    @                                                                                                                                                                                                                           Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                                                              @H           Q                                                                                                                                              ]   x               )                                                                                                                   @             P+                   8               0         p                                                                                                                                           (   X   @C
                  Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                                            @C   p               p                                   	           0                      @	                            D     C   `   p                                                                                          
           @                                                                                   ]   (   `(   ]           ]   @(   '   ]                                                           Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                  Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

               
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
              ,                                                                                      R                   =                         =      P                      0                            p                         н                         0                   +                         =                          =                         =   `                      =      @                   >       й                                                                   
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         x=    !                  =                     =                                                     Transform parameters from defined support to unconstrained space                                       E                                                                                                                                        @                0                                                                                                                                                                                                      Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               S                            p[                           X   p                         Y      (                      XS   X   &                      S       &                      S                           xY   t                        W                           V   `   <                      S      #                      0\                           PZ                           @Z                           hS                           T                            [                           [                           pY       $                      XY                           Z                           W                           Y                            Z   (   
                     T      	                     U      %                      X        (                      HW   @   A                      Y                           W   t                        hU   H                        W                           pT   H                        `Y   X                        @\                              U   P                        `S   `                        S                           (Y                           X                           Y                           0U      	                     (U                           0S      
                     X   H                        O                            S   H   
                     W                           T   0                        xP   X                         U   X                        V                           PW                           0Y                           S   L                        W                           Z                           Y      	                      T   ,                        Z   X                        V                           S                           pX   H                        [   @   
                     U                           Y   0                        XP   x                        T   h   
                     XZ                           Y                           Z      L                      x[                            [   x                        T      
                      [   l                        (S      	                      X   H                        U                           (P                           X                            T                           0P                           Y      +                      (X      
                     Z                           8Y                           [                           X                           \                           T      
                     S   x                        X                           V                           W                           HX      
                     W                           V   p   
                     PY                           xX   X                        (Q                            Z      
                     S                           T       
                     T   8   
                     Y                           8X      
                     8P   0   	                      W                           W      	                      U       
                     Z                           @W      
                      X   8                        @P   h                        Z   H   .                      W   $                        `U                             U                           Z      
                     8V                           T      	                     HU                           V      
                     V   (                         T                           W                           W                            (W                           hW   `   	                      \   H                        S   @   
                     Z   X   
                      W                           X   l                        S   X                        X   8                        V                           W                            V                           \                            V      "                      S                           `[                           [      x                      X   d                        `Z      '                      X      "                      8U                           S   H    
                     V   <                        U                           P   `                         Q                           Z                           T                           8Q      	                     @S                           U                           P                           [   D                        Y                            Y   0                        U                            U      
                     hP                           Z                           (T                           Z   x                        S                           [                           T      
                     W                           Z                           U                           U                            S      
                      Z   (                        0Z      	                     XX   P                        W                           U   8                        U   x                        hY                           T                           `X                           pU   d                        xZ                           8W                           U                           [   `    H                     V                           [   X   	                     PU   `                        Z   p                        Y   h   
                     V   T                        T      	                     V      	                     8\      
                     0W                           XU   D                        [   X   	                     X                           U   8                        xW      
                      \   p   
                     h[                           S   x   
                     [                           Z      	                      S       %                      P                           Y                           xS                            T                            W   l                        T   (                        V                           HZ                           S   t                        pW                           HS   @                        V   h                        (\                            hX                           @U      	                     8S   T                                                                P   8Q   @P   0P                   XP   xP    Q           P   0P                   XP   hP                   P   0P                   @P           P   P                   P   P   (P           @P           P   O                   P   O   8P           u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                 .?AVdivide_vv_vari@?A0xd60d79df@math@stan@@                        .?AU?$located_exception@Vexception@std@@@lang@stan@@               .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                 .?AVmultiply_vd_vari@?A0xd60d79df@math@stan@@              .?AVadd_vd_vari@?A0xd60d79df@math@stan@@                           .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVlogger@callbacks@stan@@                        .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@               .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                 .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AVlength_error@std@@                     .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVdomain_error@std@@             .?AVmultiply_vv_vari@?A0xd60d79df@math@stan@@              .?AVcovar_adaptation@mcmc@stan@@                           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .H                 .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AVanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@                    .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                 .?AVbad_exception@std@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                           .?AV?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@                      .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@                     .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVbad_typeid@std@@               .?AVop_dv_vari@math@stan@@                 .?AVps_point@mcmc@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@             .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AUbad_exception_@exception_detail@boost@@                .?AV?$adapt_unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$numpunct@D@std@@             .?AVvari@math@stan@@               .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AVdump@io@stan@@                         .?AV?$unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@              .?AVneg_vari@?A0xd60d79df@math@stan@@              .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AVadd_vv_vari@?A0xd60d79df@math@stan@@                   .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@             .?AVrounding_error@math@boost@@            .?AV?$diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVunderflow_error@std@@                  .?AVdivide_dv_vari@?A0xd60d79df@math@stan@@                .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@               .?AVsum_v_vari@math@stan@@                         .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AUPyErr_CheckSignals_Functor@?A0xd60d79df@pystan@@               .?AVempty_var_context@io@stan@@                    .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                          .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AV?$adapt_dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AVchained_var_context@io@stan@@                  .?AVfacet@locale@std@@             .?AVdiag_e_point@mcmc@stan@@               .?AVfixed_param_sampler@mcmc@stan@@                .?AVexp_vari@?A0xd60d79df@math@stan@@              .?AVout_of_range@std@@                     .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                   .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVbase_mcmc@mcmc@stan@@                  .?AV?$adapt_dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             .?AVdense_e_point@mcmc@stan@@                      .?AV?$dot_product_vari@NVvar@math@stan@@@?A0xd60d79df@math@stan@@                          .?AV?$dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVsubtract_dv_vari@?A0xd60d79df@math@stan@@              .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                         .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVsum_values@pystan@@            .?AV?$adapt_diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@                       .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@                     .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AVprob_grad@model@stan@@                 .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AV?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVexception@std@@                        .?AV?$adapt_diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                        .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AVwindowed_adaptation@mcmc@stan@@                .?AVvalue@pystan@@                         .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AV?$adapt_unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                                                                                                                   V  
 `    
     
    >  
 @  ^  
     
     
   
  
 0    
     
   F  
 P    
     
     
      
    V  
 `    
     
     
      
      
     
     
     
   &  
 0  F  
 `    
   #  
 `    
   %  
 0  p  
 p    
   y   
     X
 P    
    M$  
 p$  $  
 $  $  
  %  +%  
 0%  T%  
 `%  w&  
 &  '  
  '  o'  
 p'  )  
  )  	*  
 *  *  
 *  +  
 +  4,  (
 @,  ,  (
 ,  $-  
 0-  .  8
 .  9.  
 @.  i.  
 .  .  
 .  v/  D
 /  /  
 /  ;0  
 `0  0  
 0  0  
 0  0  
 0  1  
 1  1  
 1  2  
 2  2  
 2  3  @
 3  3  
 3  ~4  p
 4  4  
 4  n5  
 p5  5  
 5  6  
 6  P6  
 `6  6  
 6  6  
 6  7  
 7  G7  
 P7  7  
 7  7  
  8  G8  
 P8  8  
 8  9  
 9  :   
 :  ;  p
 ;  <  
 <  q=   
 =  >  8
  >  K>  
 P>  o?  (
 p?  ?  
 ?   @  h
  @  @  h
 @  @  
 @  B  x
  C  4C  
 @C  =D  
 @D  F   
 F  G  
 G  K  
 K  K  
 K  7L  
 7L  L  
 L  L  
 L  M  
 M  |M  
 M  M  
 M  P  
 P  Q  
  R  ?T  
 T  T  
 pU  V  
  V  V  X
 V  W  
 `X  Y  
 Y  Y  
  Z  Z  H
 [  r\  
 \  1]  
 @]  ]  
 P^  ~^  
 ^  _  (
 P_  ~_  
 _  _  
 _  `  X
 `  nb  
 pb  b  
 b  b  
 b  c  
 c  hd  @
 pd  e  
 e  e  
  h  
i  
 i  j  
 j  "l  @
 0l  "o  P
 0o  \o  
 \o  o  
 o   p  
  p  p  
 p  p  
 p  p  
 p  8r  8
 @r  ^s  @
 `s  u  
 u  u  
 u  u  
 u  pv  
 pv  v   
 v  v  
 v   w  
  w  w   
 0x  x  P
 0y  y  
 y  ~  
 ~  <~  
 @~  ~    ~  P    P    
   ہ  
     
          
    ΃   Ѓ  ΅  H Ѕ                         M  
 P  ۔       P    7  h @            }          ݝ  
   M  
 P    8
     
           П    
              W  
 `       $   0    P	     h	     t	   =  |	 =  ʩ  	 ʩ  Z  	 Z    	   Ū  	 Ū  ۪  	 ۪  k  	 p    
     
     0
   #  H
 #  Z  X
 Z    p
     H
   <  
 @    
     
     
     
   .  
 .  o  
 p       ȱ   ȱ    ,   !  H 0    
   8  d 8    x   /  
 0  i  
 p    
   ƶ  
 ж    
               b  
 p  Ҿ  
     0    5  p @          \         B  p   b   p    ( @  ;  h @                   8   :  L :  I  \ `    
     l              y  P        ;   ;  T   `    
                
        \   `    H              3   @  X   X       <    <    0     D   !  T 0  >   @  z  0 z    D   Q  X `    h   E   P    |        ?   ?                  "  
 0    0   A  h P            k   p   8        !  0    3	 $ @	 
 <     |    h  4  @ v |      $   h          {    (   
    
   
   X   
   P 
 P  
   
  A 
 P 
 `  r 
   
  R 
 `  
  - 
 0 d 
 p   (
      X    C!   P! ! 
 ! ! 
  " 4" 
 @" . (
 . /  ! / N4 0! `4 4 
 4 ; ! ; < " < = " = = # = = 
 = o> H# p> > 
 > > 
 > 0? 
 0? p? 
 p? ? x#  @ V@ 
 `@ @ 
 @ A 
  A vA 
 A A 
 A <B # @B B # B C $  C C 0$ C C 
  D D 
 D xE `$ E i  % i k (
  l &} x, 0} < p2 @  x3  + 3 0  5  Đ 
 А  (
  $ 8
 0   7    7   
   (
   o 7 p  
  ɗ 
 З  
   ) 
 0 Ș 7 И  x8    (9  L 9 P  h:   :   :   ;   
 ;   P<  R 
 p  
   `<   6 
 @  `<  ֫ 
  4 `< @ v 
  Ԯ `<   
   t `<  : t< @  
   (
  7 < @  
   
  A D= A  P=   h=   |=   4 
 @  =   =   =   | 
   X  T X ` ú 
 к  
   
   
  | 
   
  g 
 p  8
   =   =  ӿ =   
   
  T d> `  >   >   >   >    >   ?   H?  j \? p  l?  V ? ` . H? 0 # ? 0 $ 
 0 ` @ `  
  0 
 0 H 8
 H  @   @  X @ `  
   8
  U $A U c 8A p   
 0  D=  " HA " l `A l { tA   =    A   4 A @  
  V 
 ` L 
 P h 8
 h  A   A   
   K 
 P  
   
  z 
   
  W (
 `  
   A   
  ! 
 0  
   
  ) 
 0  A    A   ] B `  
   XB   lB   
  \ B   B   C 
 P  
   B  V 0C `  
   
   xC   C   C   C  T C   C   D  ( D ( a <D p  
   
  ` (
 `  (
   
   Q TD ` 	 D   
   
  " 
 0  >   g 
 p 3 D @  
  B 
 P  
  " <E 0  
  R 
 `  
  Q 
 ` 	 E   >   $F   8F   PF   $F  z `F z  xF   
   F    F  b 
 p  
   c 
 p  
    
   
   U 
 `  
  A	 F P	 	  G 	 n
 (
 p
 R (G ` D (
 P q @G  F 
 P J (
 p  (
   \G   pG   G   ; G @  
   y G   G    (
  g G p 1 
 @  
   @H   TH  d 
 p  
 p$ $ 
 $ b% 
 p% % 
 % & H & ' H ' R( 
 `( +) H 0) ) H  * r* 
 *  + H?  + r+ 
 + d, H p, F- I P- - H? - . 
 . / H  0 n0 
 p0 5 I  5 9 0I 9 Y: HI `: : 
 : A; \I P; p; 
 p; < xI  = @ dJ @ #A J #A A J A A J  B xB J B B J  C C 
 C D H `E E J E G J G -G J -G G J G G J G MI K MI ]I K ]I I ,K I I 
  J L @K  L )N (L 0N DP M PP P 
 P Q \G  Q FQ M FQ Q M Q Q N Q [S  N `S [T hN `T T 
 T U N U eV H? pV V 
 V W PO W @X  P @X Y PP Y nY 
 pY Y P  Z bZ 
 pZ Z P Z \  Q \ \ 0Q \ J] 
 P] ^ DQ ^ ` Q  ` a Q  a Kc (R Pc Md R Pd d 
 d e 
 e de 
 pe e 
 e &f 
 0f f 
 f f 
 f Fg 
 Pg g R g g XS g h S h Fh (T Ph h T h h T h i `U i Fi U Pi i 0V i i V i j  W j Fj hW Pj j W j ^k 8X `k (u DX 0u u XZ u u lZ u u Z u Ww Z `w  Z   ^  6 ^ @ p _ p  `   @a   hc   c   pd  y d y  d  ۼ (
  7 (
 @ H d P _ d ` 9 e @ _ 
 _  ,e   @e   Pe   de  & pe & 2 e 2 ? e @  (
   (
   
  H e P  e   L 
 `  
   f   
  ^ `f   f  ~ f   @g   Hg   `g   pg   \ g `  g   J g P  h  L 8h  7 `h P  HI   h   (
  o Pi p  i  + 
 0 R 
 `  i   
  c j p  H?  t 
   HI   x Pj   dj   j   
  @ 
 @ _ 
 `  k   k    k   0l  [ Ll ` $ l $ x l x  l   l   l    @m  C m C  m   m  P 
 P  m   m  U  n `   o   @o   I  o P   p   hr  	 r   r  F r P o 
 p  
   r   R hs `  s    t  ' Lv  ( (8 x 08 < z < = { = ? | ? @ P| @ B | B E | E KI @} PI J } J @L ~ @L ~M @~ M 0O x~ 0O R ~  R U 0 U [  [ 6`  @` vt  t  x Ї  ؅       
  #   #     $  ٙ 4  ~ L      . 8 .  @   X  ՛ h   8        +  0 > 8 > ȝ  ȝ ɝ ؊ ɝ     Y   ` s   s       ) ȋ p    8 ( @     (
  ĥ  Х       } $    4   ߩ ` ߩ Գ x Գ    Ľ  н <  @  
  Ͼ 
 о X   `  (   ? 
 @  X   
  x    
   
  , 
 0 | 
   
   
    
   
  X 
 `  
  Y 
 `  
          @g      
   V  V  ̑      
 0 w 
       `   
   i 
 p  
  _  ` P Ԓ P V  ` }  }        & 
 0  
  t 0  " h @  t   
    |         E H P     
     ^
 @ `
 J  P    6 Ж @ *
  0
 z
   
  H    p  
         9  9 p  p  J      J 
 P  
  : 
 @  
   
    X  .%  0% 2 К 2 
B x B N Р  O O J O Q h  Q ~Q  Q Q 
 Q R  R S   T \ H \ ] 0 ] _   _ _ H _ c P c e  f *g H 0g Kh  Ph l   l m  m 1n  @n n 0  o ho x po p  p >q  >q 
r  
r r 0 r Ms @ Ms ns T ps u d u cz  pz ~  ~ ā  Ё  
    X  Ń p Ń  |       
  d  p  h  ̇ 
 ̇ ) ȭ ) / ܭ   
   
   5 
 5    ɉ   Љ    ؋ 
 ؋ >  > e  p  t  ߍ Ȯ   `  t l t    ӎ  ӎ    #  0  ȯ  t l t Ȗ  Ȗ  (  ϙ < Й Û T Л ? l @               ԰  7  @    ? 8 @  T         ̱  k ܱ k  ̱  Ш  Ш  
   
  Z 0 `    Y  `     b Ȼ p  @   G x P 
   k  p     X  `           6  @    2  @     0  E& T P& & r & #-  0- -   . . 
  . M8  P8 e8 p e8 8 ` 8 8 t 8 c;  p; ;  ; ;  ; &<  0< N<  N< <  < <  < >   ? C ( C D  D `Q T `Q T  T a 8 a  b   b b  b b 
  c c ( c Qd X `d d 
 d e  e f 
  f vf 
 f f 
 f 6g 
 @g g  g h 
 h h  h ^i  `i i 
 i j   j _j 
 `j j H j uk x k k  k fl  pl l  l n  n p  p ,s 8X ps t  t u @ u Dv 
 v v 
 v ,y x 0y Gz  Pz z 
 0{ w{ 
 { H~  P~  H    
  O  P V  ` ~ x ~        /  0   Ѓ d   ބ 
  1  @ ;  @      
  ?  @ F  P B 0 P Е  Е Z  p   0 ^ 
 `       U  `    F @ P  h     c  p  
  f 
 p !   0 i > i  (   <  6 
 @ t 
   
   4 
 @  
   
   v 
   
  6 
 @  L   ϱ J P f  p ٴ 
  ĸ  и  x       
   i  p    F @ P        (   
   l 
 p M  P u 
   <  L T L  h  > (
 @  x         #  #                    S $ ` l T p  
  " 
 0  8   T  ' 
 0 O 
 P _  `    
  
     x        "   # (  ( (  ( i) | p) ) 
 ) j4  p4 5  5 8  8 9  9 W<  `< ?  ? 
@   @ m@  p@ @ (
 @ C @ C 8D  @D F `  G G  G G   H TH ( `H zH  zH I  I I  I I  I pJ  pJ ~J  J J  J K , K K D K K 
 K M T  M R d R SU  `U U  U 7W  7W 'X  0X `X  `X pY   pY `Z  `Z ] $ ] _ d _ ` @  a a  a  b 
  b b 
  b yb  c jd  d d 
 d vf  f h   h 3i 8 @i i 
 i k J  l l p l sm  m n 
 n sn 
 n n 
 n o   o p  p s  s %s  0s u , u v  v ;w  ;w     0  G @ P  d                o   p t 0   Ǝ   Ǝ             l p p    ۙ   2  @ H , P     
   ? 
 ? u  u        
  E D E  X   h       (     ܬ  ܬ Z  Z -  P d  d          y  y    8 C 8  (  k @ p    f P f  h P x C x  x            
  ) @ ) / T / 5 d @ _ 
 `  x      
  X  `   0 o 
 p  (  / 
 0  X  J  P  J      u      f  p  8  e ` p    V  `    Z  	 Z  	    	    J   + 
 0  0	   x	  , 	 0  
  } p
 }  
  ( 
 0  
   
      (   8   6 T 6  d  ^  ` =    
            0 
 0 O 
 P  
   
   
      d , p [ X `  t  a  a u   j  j    "  " (  ( P  
 P  
  I (
 I  <
  | P
 |  d
   t
   
  e 
 e  
   
   
   
   
         (   <  0 P 0  `  D p 	 
 
 
 
 
 
  |        Q J ` { \G      $  F 8 F U T U V d `  t     
  
 o   o    q $  " J 0 W  W  h           /  p    U  U    ,  ,      $     c  4 c  
! P ! X" ` `" #  # #  # %  % u&   & 0' 0 0' ' < '  ( X  ( ?( 
 @( ( h ( )  ) ) 
 ) * 
 * *  * -  - / 8X  0 60  60 1  1 1   1 2 0 2 3 <  3 3 h 3 
4  4 4  4 5  5 5  5 6 @ 6 7 x 7 7  7 G:  P: : P : ; p ; =  = = 
 = > 
 > ?  ? @  @  A 
 A B 8X B VE  `E E  E ZF ( ZF %G < G G C G H L H H h H I C I J x J XJ  @L TL  TL qL  qL XM  XM M  M M  M M  M P  P P 4 P /P 
 0P P \ P ~Q  Q R  R R   R R 
 R T J T U H U U p U vV  V V  V W  W W  W X  X SY 0 `Y ] x ] a  a a 
 a a 
 pe f X f i   i Mk  Pk o   o s 8 t t  t u | u pv  pv v  v hw  hw Qx  `x y   z     x   \ 8X `    !  ! e  e    s   % @ % " X "    ѓ  ѓ       ͔  ͔ ֔      ŕ  ŕ     ,  ԗ 8 ԗ ۗ P   p  [ ` [ a t p       3  3       ګ  ګ  $   H   J   G X P        j  p  0    x           -   - L   L  !  . ! 0  !   C   !  	 !  D  D * ! *  "  2  " 2  "   7 T" 7 X p" X @ " @ = " @  "   "   "   L C L  "  9 #      m (# p j 0# p  h#  ` t# ` g # p  #   #    $   0$  } P$ }  `$   |$  l $ p  $  C  $ C  w  %     8X  ! % $ \ 
   H%   (
  , 
 , \ 
 \  
  # 
 $  
   (
  T 
 T  
   
   
  	 
 	 	 
 	 }	 H? 	 	 
 	 	 
 	 
 
 
 
 t% 
 u L% x  
   
   
  / 
 @ k 
 l  
  
 % 
 j % l a % d  H?   (
   4 
 4    y % |  &   
 8 z 
 |  
   
   &  D (& D g 
   
   (
  N (
   [ <& [  \&   p&  + & +  &   &   &   & @  &  	 & 	 < ' < `  ' p  0'   8'  e  @' p  ! L'  ! " T' " 	# t' # # '  $ k$ ' $ >% ' `% & ' & 3' ' @' ' ' ' /( ' `( ( ' ( ) ' ) ) ' ) ) ( ) * (  * @+ ( P+ + (( + ~, 8( , , D( , - P( - ,. d( ,. . x( . S/ ( `/ / ( / / ( / 0 ( 0 %1 ( 01 1 ( 1 	2 ( 	2 12  ) @2 3 ) 3 3 ) 3 3 $) 3  5 ,) 5 5 <) 6 8 H) 8 8 \) 8 9 d) 9 7: t) < < ) < < ) < < ) < I= ) I= h= ) h= = ) = = ) = )> ) )> H>  * H> x> * x> > ,* > 	? <* 	? (? D* (? X? X* X? |? p* ? ? * ? @ * @ 8@ * 8@ \@ * p@ @ * @ @ * @ A * A <A * PA A + A A + A B $+ B iB <+ iB B D+ B B X+ B B p+ B B + C C + 0C ?C + PC _C + pC C + C C + C C + C C + C !E + 0E SF + `F F + F G  , G G , G H (,  H H 0, H H 8, H I D, I I l, I \J |, pJ J , J LK , LK K , K vL , L L , L >N , N N , N UO , UO eO - eO O $- O O <- O LP T- P R `- pR V p- V X - X X - X uY - uY Y - Y [ - [ z\ - \ V] - `] ^  . 0^ ^ .  _ _ .  ` a . c c  . d )e (. 0e e 0. e mf @. f f H. f 
h T. h i h. i i x. i j . j k . k k . k k . k l . l m . m m . m p  / p Vq / `q r / r ,s 8/ @s s D/ s t L/ t Qt X/ Qt ft p/ ft st / t u / u #v / 0v nv / nv 
w / 
w !w / 0w lw / lw w / w x 0  x Mx 0 `x 7y  0 @y y (0 y y 00 z z 80 z +{ D0 +{ L{ X0 L{ t{ l0 { | |0  } B} 0 } } 0  ~ s~ 0 ~ [ 0 p U 0 `  0   0  R 1   1  1 1 1  01  ۓ D1   X1   `1  _ p1 p Ѣ x1  Ӥ 1  . 1 @ ۥ 1  k 1   1  > 1 P  1   { 1  ި 1   1   1 0  1   2    2  +  2 @  (2  M 42   @2    L2  - X2 ` ͯ d2   m p2  
 |2 @  2   2 P  2   \ 2 p Z 2 ` ` 2 p  2  2 2 2 8 2 @  2 й  3 @  3  M 3   (3   03    83   D3 0  L3 н  X3  d `3 p  h3  & p3 P  x3  ѿ 3  6 3 @  3   3    3  ' 3 ' d 3 d j 3 p ^ 3 p  3  8  4 @  4    4  Q 4 ` ( 5 0  L6   6   07 0  7    7   $8 0  <8   D8   \8   p8   x8  E 8 P  8   8  G 8 P  8   8  G 8 P  8   8   8 P  8   8   8  E 9   9   9  E  9 P  ,9   89  G @9 P  H9   T9  G `9 P  h9   p9   |9 P  9   9   	 9  	 E 	 9  	  	 9  	 	 9 	 	 9  	 W	 9 `	 	 9 	 	 9 	 	 9 `	 	 9 	 	 9 	 	 :  	 U	 : 	 	 : 	 	 8: 	 	 D:  	 	 : 	 	 <; 	 Y	 ; p	 ^	 ; 	 n	 X< 	 ~	 < 	 $	 P=  %	 ,	 = ,	 5	 = 06	 6	 X>  7	 8	 `>  8	 A	 l> A	 DH	 (? PH	 I	 @ 0I	 JI	 @ JI	 .Z	  @ .Z	 dZ	 L@ dZ	 Z	 `@ Z	 [	 p@  \	 o	 @ o	 qq	 @ q	 q	 @ q	 x|	 @ x|	 |	  A |	 |	 A |	 }	 $A }	 q	 PA 	 	 dA 	 ؃	 pA ؃	 	 A 	 n	 A 	 /	 A @	 X	 B `	 	 B 	 	 C 	 Ț	 C К	 ڜ	 C 	 	 C 	 *	 D 0	 ?	 0D ?	 K	 <D K	 g	 \D 	 	 lD 	 	 D 	 	 D 	 ,	 D P	 L	 D p	 	 D 	 	 D 	 Z	 E Z	 	 ,E 	 	 <E 	 	 dE 	 	 E 	 	 E 	 	 E 	 [	
 E [	
 x	
 E x	
 	
 F 	
 
 F 
 
 ,F 
 
 8F 
 
 `F  
 
 pF 
 
 |F 
 
 F 
 
 F 
 ^
 F ^
 w
 F 
 
 F 
 
 F 
 
 G 
 
 ,G 
 
 HG 0
 _
 `G p
 
 hG 
 

 pG 
 m
 G 
 -)
 G @)
 )
 H )
 ?
 H ?
 A
 tK A
 9C
 K PC
 K
 K K
 jT
 HL pT
 T
 L `
 
 pM  
 C M P  M   M    N   N   W N `  N   (N   W 4N `  <N   DN   PN `  \N   t hN   pN   xN   W N `  N   N  	 W	 N `	 	 N 	 T
 N 
 
 N 
 ' N 0 e N p  N   N  
 N 
 d
 N p
 
  O 
 
 O 
  O   7 O @ w $O  4 ,O  F 8O `  DO  k LO   XO  F `O P  hO   |O   O   O   O  > O > W O `  O  o P o  $P  { 8P    TP ! ?! lP P! ! tP ! " |P  " O" P `" " HS " *# PS # & S & ' |T ' ( T ( ( T (  3 T 03 5 TW 5 5 \W 5 y6 dW y6 6 xW 6 (7 W (7 7 W 7 8 W  8 8 W  9 B9 W B9 9 W 9 9 W 9 &: W &: : X : : X : : ,X : W; @X X; u; 
 x; ; C ; S< HX p< < `X < ? hX ? B xX  C "C 8& 0C VC P
 `C C P
 C C P
 D D P
 D E P
 0E YE P
  F NF P
 I I P
 0J J   K K p K ZL @	 L M  N O P
 QO P H P Q P
 aQ R   S S ` S NT   PX vX P
 ] D] h, ] S^ `2 ^ >_ `2 _ 5` `2 ` *a `2 a +b `2 d d P
 d .e h8 le e P
 e f P
 Xf f P
 pg g P
 g g P
 g h 0=  h h P> h h p@ h Gi A `i i P
 i i P
 i j P
 @j j (E j Nk F k k @J k Nl PJ hl l L l l L m @m M m  n P n 6n P
 n n P
  o o HS  o ;o S @o [o T `o {o T o o T o o PU o o U o o  V  p p V  p ;p V @p [p XW `p {p W p p (X p 
q P
 Eq vq P
 q q P
 r Dr HZ r r P
 t 4t ^ Xt tt _ t t p` t t 0a u u Xc u v P
 <v ev P
 }v v P
 v v P
 v w P
  w Pw P
 Pw mw P
 pw w h w  x P
  x -x P
 @x nx P
 x x P
 x y j  y Ry pk y y P
 y 'z P
 |z z P
 z { P
 { /{ P
 L{ v{ P
 { { P
 { { P
 ,| Z| P
 | } P
 4} ! 8v   h  ԅ ȅ  ) P
 a  P
 ʆ  P
 3 d P
  ɇ    4  @ d  p  (   P
      P
   P
   P
 L } P
   h M ~ P
   P
  G h  Ǝ h  ݏ P
 \ } X  ސ P
  G P
   X   X `  ؤ   J  0 Z P
 p  P
  ڔ P
    ( Y P
  ܕ   ) P
 U  Ь      P
  ۗ P
  	 P
 9 j P
  a  m  P
 ʙ d          P
    t  0   P
 t   ԡ   D _         t   Ԥ   D _       ئ @ D u P
  ާ P
  G P
   P
    `     P
 ! R P
   P
  $ P
 \  P
 ū  P  g @  Z   j    P
  ڮ P
  6 P
   P
   P
   * P
  
 P
    D  x 0   ` H   x      ^ h `     P
 M ~ P
   P
  P P
   P
      P
      P
    0   Z  ` | P
 |  P  ڽ    P
       < P
 < \  ` | P
 |   ľ  0      < P
 < `    `   J  p  0      P
  j p   P
   P
 `  P
   * P
  , l% , C P
 C _ P
 _  
   4  " 4 . T 5 l  D6   6   (7 G p 7 |  7   8 ?  ?   B  M C e  H   H   K  M $K M m 4K m  <K   LK   TK  P dK \  @L   L & _ R _  R   R  - R -  R   R   R  z R z  S  2 S 2 k (S k  8S   tT L i LW @  
  s 
   
    
  S 
 `  
   m 
 p  
  
 
   m 
 p  
  
 
 , W 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `                    <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                    pxȪЪت  (08@HPX`hpxȬЬج  (08@HPX`hp (            ȧЧا hpxȭЭح  (08@HPX`hpxȮЮخ  (08hpȯЯد    |    (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء  (08@HPX`hpxȢТآ  (08@HPX`hpxȣУأ 08@HPX`hpxȤФؤ  (08@HPX`hpxȥХإ (08@HPX`hpxȦЦئ  (08@HPX`hpx`hpxȨШب  (08@HPX`hpxȩЩة  (08@HPX`hpxȪЪت  (08@HPX`hpxȫЫث  (08@HPX`hpxȬЬج(08@HPX`hpxȭЭح  (08@HPX`hpxȯЯد        (08@HPX`hpxȠРؠ  (08@HPX`hpx(08@HPX`hpxȢТآ  (08@HPX`hpxxȤФؤ X`hpxȥХ ȦЦئ  (08@HP`hpxȧЧا (08@HPX`hpxȨШب    
 t   ȡСء  (08 (08@HPX`hpxȣУأ    
    Ȥ        @HXhȠРؠ  (@HPhpxȡ08@X`hآ(0pxhHȭ (@H`hȮخ  (@HX`hxȯد       (8@H`hȠ  (@H`hȡ8PآXأ (08HPXhЧXب H8`hpx8HPhȯد  h   px`Ьج  (0HPXpxȭЭ 8@H`hp    X  pxXp xУأ  (HPpxȤ8@`hإ (0PXxȦЦ @Hhp08X`Шب  (HPpxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد       (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp08X`Чا  (HPpxȨ8@`hة (0PXxȪЪ @Hhp08X`Ьج  (HPpxȭ8@`hخ (0PXxȯЯ     @Hhp08X`Сء  (HPpxȢ8@`hأ (0PXxȤФ @Hhp08X`Цئ  (pxȧ  08PX`pШ x8p8`@ج 8x0   P   0X `@X@@pة 0p8p pЯ    L   0X@ Hp `Ч بpЩPЪ8` `Я   H   0pȡ P`P `@ЫHpج@ȭ 0Ю    0 <   H `Т8`Х(X `ЩP 0   @ $   P0pإ@@                                                                                                                                                                                                                                                                                                                                                                                                                                           module_nameGstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_9000114820052150747
model_name+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2ub.