(cpystan.model
StanModel
q oq}q(U
model_cppnameqX+   anon_model_db8febf10f23d7fa27a62fbcfd7f17b2qU
model_codeqTy  functions {
  real[ , ] get_changepoint_matrix(real[] t, real[] t_change, int T, int S) {
    // Assumes t and t_change are sorted.
    real A[T, S];
    real a_row[S];
    int cp_idx;

    // Start with an empty matrix.
    A = rep_array(0, T, S);
    a_row = rep_array(0, S);
    cp_idx = 1;

    // Fill in each row of A.
    for (i in 1:T) {
      while ((cp_idx <= S) && (t[i] >= t_change[cp_idx])) {
        a_row[cp_idx] = 1;
        cp_idx = cp_idx + 1;
      }
      A[i] = a_row;
    }
    return A;
  }

  // Logistic trend functions

  real[] logistic_gamma(real k, real m, real[] delta, real[] t_change, int S) {
    real gamma[S];  // adjusted offsets, for piecewise continuity
    real k_s[S + 1];  // actual rate in each segment
    real m_pr;

    // Compute the rate in each segment
    k_s[1] = k;
    for (i in 1:S) {
      k_s[i + 1] = k_s[i] + delta[i];
    }

    // Piecewise offsets
    m_pr = m; // The offset in the previous segment
    for (i in 1:S) {
      gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
      m_pr = m_pr + gamma[i];  // update for the next segment
    }
    return gamma;
  }
  
  real[] logistic_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[] cap,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    gamma = logistic_gamma(k, m, delta, t_change, S);
    for (i in 1:T) {
      Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta))
        * (t[i] - (m + dot_product(A[i], gamma)))));
    }
    return Y;
  }

  // Linear trend function

  real[] linear_trend(
    real k,
    real m,
    real[] delta,
    real[] t,
    real[ , ] A,
    real[] t_change,
    int S,
    int T
  ) {
    real gamma[S];
    real Y[T];

    for (i in 1:S) {
      gamma[i] = -t_change[i] * delta[i];
    }
    for (i in 1:T) {
      Y[i] = (k + dot_product(A[i], delta)) * t[i] + (
        m + dot_product(A[i], gamma));
    }
    return Y;
  }
}

data {
  int T;                // Number of time periods
  int<lower=1> K;       // Number of regressors
  real t[T];            // Time
  real cap[T];          // Capacities for logistic trend
  real y[T];            // Time series
  int S;                // Number of changepoints
  real t_change[S];     // Times of trend changepoints
  real X[T,K];         // Regressors
  vector[K] sigmas;     // Scale on seasonality prior
  real<lower=0> tau;    // Scale on changepoints prior
  int trend_indicator;  // 0 for linear, 1 for logistic
  real s_a[K];          // Indicator of additive features
  real s_m[K];          // Indicator of multiplicative features
}

transformed data {
  real A[T, S];
  A = get_changepoint_matrix(t, t_change, T, S);
}

parameters {
  real k;                   // Base trend growth rate
  real m;                   // Trend offset
  real delta[S];            // Trend rate adjustments
  real<lower=0> sigma_obs;  // Observation noise
  real beta[K];             // Regressor coefficients
}

transformed parameters {
  real trend[T];
  real Y[T];
  real beta_m[K];
  real beta_a[K];

  if (trend_indicator == 0) {
    trend = linear_trend(k, m, delta, t, A, t_change, S, T);
  } else if (trend_indicator == 1) {
    trend = logistic_trend(k, m, delta, t, cap, A, t_change, S, T);
  }

  for (i in 1:K) {
    beta_m[i] = beta[i] * s_m[i];
    beta_a[i] = beta[i] * s_a[i];
  }

  for (i in 1:T) {
    Y[i] = (
      trend[i] * (1 + dot_product(X[i], beta_m)) + dot_product(X[i], beta_a)
    );
  }
}

model {
  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  y ~ normal(Y, sigma_obs);
}
qUmodule_filenameqUBstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.pydq	U
model_cppcodeq
X  // Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

template <typename T0__, typename T1__>
std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
get_changepoint_matrix(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<vector<fun_scalar_t__> > A(T, (vector<fun_scalar_t__>(S)));
            stan::math::initialize(A, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(A,DUMMY_VAR__);
            vector<fun_scalar_t__> a_row(S);
            stan::math::initialize(a_row, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(a_row,DUMMY_VAR__);
            int cp_idx(0);
            (void) cp_idx;  // dummy to suppress unused var warning
            stan::math::fill(cp_idx, std::numeric_limits<int>::min());


            current_statement_begin__ = 9;
            stan::math::assign(A, rep_array(0,T,S));
            current_statement_begin__ = 10;
            stan::math::assign(a_row, rep_array(0,S));
            current_statement_begin__ = 11;
            stan::math::assign(cp_idx, 1);
            current_statement_begin__ = 14;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 15;
                while (as_bool((primitive_value(logical_lte(cp_idx,S)) && primitive_value(logical_gte(get_base1(t,i,"t",1),get_base1(t_change,cp_idx,"t_change",1)))))) {

                    current_statement_begin__ = 16;
                    stan::math::assign(get_base1_lhs(a_row,cp_idx,"a_row",1), 1);
                    current_statement_begin__ = 17;
                    stan::math::assign(cp_idx, (cp_idx + 1));
                }
                current_statement_begin__ = 19;
                stan::math::assign(get_base1_lhs(A,i,"A",1), a_row);
            }
            current_statement_begin__ = 21;
            return stan::math::promote_scalar<fun_return_scalar_t__>(A);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct get_changepoint_matrix_functor__ {
    template <typename T0__, typename T1__>
        std::vector<std::vector<typename boost::math::tools::promote_args<T0__, T1__>::type> >
    operator()(const std::vector<T0__>& t,
                           const std::vector<T1__>& t_change,
                           const int& T,
                           const int& S, std::ostream* pstream__) const {
        return get_changepoint_matrix(t, t_change, T, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
logistic_gamma(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<fun_scalar_t__> gamma(S);
            stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma,DUMMY_VAR__);
            vector<fun_scalar_t__> k_s((S + 1));
            stan::math::initialize(k_s, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(k_s,DUMMY_VAR__);
            fun_scalar_t__ m_pr;
            (void) m_pr;  // dummy to suppress unused var warning
            stan::math::initialize(m_pr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(m_pr,DUMMY_VAR__);


            current_statement_begin__ = 32;
            stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
            current_statement_begin__ = 33;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 34;
                stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 38;
            stan::math::assign(m_pr, m);
            current_statement_begin__ = 39;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 40;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
                current_statement_begin__ = 41;
                stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
            }
            current_statement_begin__ = 43;
            return stan::math::promote_scalar<fun_return_scalar_t__>(gamma);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_gamma_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t_change,
                   const int& S, std::ostream* pstream__) const {
        return logistic_gamma(k, m, delta, t_change, S, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
logistic_trend(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<fun_scalar_t__> gamma(S);
            stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma,DUMMY_VAR__);
            vector<fun_scalar_t__> Y(T);
            stan::math::initialize(Y, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(Y,DUMMY_VAR__);


            current_statement_begin__ = 60;
            stan::math::assign(gamma, logistic_gamma(k,m,delta,t_change,S, pstream__));
            current_statement_begin__ = 61;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 62;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), (get_base1(cap,i,"cap",1) / (1 + exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))));
            }
            current_statement_begin__ = 65;
            return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct logistic_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type>
    operator()(const T0__& k,
                   const T1__& m,
                   const std::vector<T2__>& delta,
                   const std::vector<T3__>& t,
                   const std::vector<T4__>& cap,
                   const std::vector<std::vector<T5__> >& A,
                   const std::vector<T6__>& t_change,
                   const int& S,
                   const int& T, std::ostream* pstream__) const {
        return logistic_trend(k, m, delta, t, cap, A, t_change, S, T, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
linear_trend(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            vector<fun_scalar_t__> gamma(S);
            stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma,DUMMY_VAR__);
            vector<fun_scalar_t__> Y(T);
            stan::math::initialize(Y, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(Y,DUMMY_VAR__);


            current_statement_begin__ = 83;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 84;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 86;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 87;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), (((k + dot_product(get_base1(A,i,"A",1),delta)) * get_base1(t,i,"t",1)) + (m + dot_product(get_base1(A,i,"A",1),gamma))));
            }
            current_statement_begin__ = 90;
            return stan::math::promote_scalar<fun_return_scalar_t__>(Y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e,current_statement_begin__);
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct linear_trend_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type>
    operator()(const T0__& k,
                 const T1__& m,
                 const std::vector<T2__>& delta,
                 const std::vector<T3__>& t,
                 const std::vector<std::vector<T4__> >& A,
                 const std::vector<T5__>& t_change,
                 const int& S,
                 const int& T, std::ostream* pstream__) const {
        return linear_trend(k, m, delta, t, A, t_change, S, T, pstream__);
    }
};

class anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
    int trend_indicator;
    vector<double> s_a;
    vector<double> s_m;
    vector<vector<double> > A;
public:
    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    anon_model_db8febf10f23d7fa27a62fbcfd7f17b2(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
        validate_non_negative_index("t", "T", T);
        t = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("t");
        pos__ = 0;
        size_t t_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
            t[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
        validate_non_negative_index("cap", "T", T);
        cap = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("cap");
        pos__ = 0;
        size_t cap_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
            cap[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
        validate_non_negative_index("y", "T", T);
        y = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "S", "int", context__.to_vec());
        S = int(0);
        vals_i__ = context__.vals_i("S");
        pos__ = 0;
        S = vals_i__[pos__++];
        context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
        validate_non_negative_index("t_change", "S", S);
        t_change = std::vector<double>(S,double(0));
        vals_r__ = context__.vals_r("t_change");
        pos__ = 0;
        size_t t_change_limit_0__ = S;
        for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
            t_change[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
        validate_non_negative_index("X", "T", T);
        validate_non_negative_index("X", "K", K);
        X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_limit_1__ = K;
        for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
            size_t X_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                X[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("sigmas", "K", K);
        sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("sigmas");
        pos__ = 0;
        size_t sigmas_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
            sigmas[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
        tau = double(0);
        vals_r__ = context__.vals_r("tau");
        pos__ = 0;
        tau = vals_r__[pos__++];
        context__.validate_dims("data initialization", "trend_indicator", "int", context__.to_vec());
        trend_indicator = int(0);
        vals_i__ = context__.vals_i("trend_indicator");
        pos__ = 0;
        trend_indicator = vals_i__[pos__++];
        context__.validate_dims("data initialization", "s_a", "double", context__.to_vec(K));
        validate_non_negative_index("s_a", "K", K);
        s_a = std::vector<double>(K,double(0));
        vals_r__ = context__.vals_r("s_a");
        pos__ = 0;
        size_t s_a_limit_0__ = K;
        for (size_t i_0__ = 0; i_0__ < s_a_limit_0__; ++i_0__) {
            s_a[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "s_m", "double", context__.to_vec(K));
        validate_non_negative_index("s_m", "K", K);
        s_m = std::vector<double>(K,double(0));
        vals_r__ = context__.vals_r("s_m");
        pos__ = 0;
        size_t s_m_limit_0__ = K;
        for (size_t i_0__ = 0; i_0__ < s_m_limit_0__; ++i_0__) {
            s_m[i_0__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"K",K,1);
        check_greater_or_equal(function__,"tau",tau,0);
        // initialize data variables
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
        stan::math::fill(A,DUMMY_VAR__);

        try {
            current_statement_begin__ = 112;
            stan::math::assign(A, get_changepoint_matrix(t,t_change,T,S, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += S;
        ++num_params_r__;
        num_params_r__ += K;
    }

    ~anon_model_db8febf10f23d7fa27a62fbcfd7f17b2() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        // generate_declaration k
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        // generate_declaration m
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        // generate_declaration delta
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        // generate_declaration sigma_obs
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        // generate_declaration beta
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ k;
        (void) k;  // dummy to suppress unused var warning
        if (jacobian__)
            k = in__.scalar_constrain(lp__);
        else
            k = in__.scalar_constrain();

        T__ m;
        (void) m;  // dummy to suppress unused var warning
        if (jacobian__)
            m = in__.scalar_constrain(lp__);
        else
            m = in__.scalar_constrain();

        vector<T__> delta;
        size_t dim_delta_0__ = S;
        delta.reserve(dim_delta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            if (jacobian__)
                delta.push_back(in__.scalar_constrain(lp__));
            else
                delta.push_back(in__.scalar_constrain());
        }

        T__ sigma_obs;
        (void) sigma_obs;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_obs = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_obs = in__.scalar_lb_constrain(0);

        vector<T__> beta;
        size_t dim_beta_0__ = K;
        beta.reserve(dim_beta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            if (jacobian__)
                beta.push_back(in__.scalar_constrain(lp__));
            else
                beta.push_back(in__.scalar_constrain());
        }


        // transformed parameters
        vector<T__> trend(T);
        stan::math::initialize(trend, DUMMY_VAR__);
        stan::math::fill(trend,DUMMY_VAR__);
        vector<T__> Y(T);
        stan::math::initialize(Y, DUMMY_VAR__);
        stan::math::fill(Y,DUMMY_VAR__);
        vector<T__> beta_m(K);
        stan::math::initialize(beta_m, DUMMY_VAR__);
        stan::math::fill(beta_m,DUMMY_VAR__);
        vector<T__> beta_a(K);
        stan::math::initialize(beta_a, DUMMY_VAR__);
        stan::math::fill(beta_a,DUMMY_VAR__);


        try {
            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < T; ++i0__) {
            if (stan::math::is_uninitialized(trend[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: trend" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < T; ++i0__) {
            if (stan::math::is_uninitialized(Y[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: Y" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < K; ++i0__) {
            if (stan::math::is_uninitialized(beta_m[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta_m" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < K; ++i0__) {
            if (stan::math::is_uninitialized(beta_a[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta_a" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {

            current_statement_begin__ = 149;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 150;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 151;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 152;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
            current_statement_begin__ = 153;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 156;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("trend");
        names__.push_back("Y");
        names__.push_back("beta_m");
        names__.push_back("beta_a");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
        for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
        }
        vars__.push_back(sigma_obs);
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector<double> trend(T, 0.0);
        stan::math::initialize(trend, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(trend,DUMMY_VAR__);
        vector<double> Y(T, 0.0);
        stan::math::initialize(Y, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Y,DUMMY_VAR__);
        vector<double> beta_m(K, 0.0);
        stan::math::initialize(beta_m, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta_m,DUMMY_VAR__);
        vector<double> beta_a(K, 0.0);
        stan::math::initialize(beta_a, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta_a,DUMMY_VAR__);


        try {
            current_statement_begin__ = 129;
            if (as_bool(logical_eq(trend_indicator,0))) {

                current_statement_begin__ = 130;
                stan::math::assign(trend, linear_trend(k,m,delta,t,A,t_change,S,T, pstream__));
            } else if (as_bool(logical_eq(trend_indicator,1))) {

                current_statement_begin__ = 132;
                stan::math::assign(trend, logistic_trend(k,m,delta,t,cap,A,t_change,S,T, pstream__));
            }
            current_statement_begin__ = 135;
            for (int i = 1; i <= K; ++i) {

                current_statement_begin__ = 136;
                stan::math::assign(get_base1_lhs(beta_m,i,"beta_m",1), (get_base1(beta,i,"beta",1) * get_base1(s_m,i,"s_m",1)));
                current_statement_begin__ = 137;
                stan::math::assign(get_base1_lhs(beta_a,i,"beta_a",1), (get_base1(beta,i,"beta",1) * get_base1(s_a,i,"s_a",1)));
            }
            current_statement_begin__ = 140;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 141;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(trend,i,"trend",1) * (1 + dot_product(get_base1(X,i,"X",1),beta_m))) + dot_product(get_base1(X,i,"X",1),beta_a)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(trend[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(Y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_m[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta_a[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_db8febf10f23d7fa27a62fbcfd7f17b2";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trend" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_a" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trend" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_a" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

} // namespace

typedef anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2 stan_model;

qUmodule_bytesqT < MZ                @                                       	!L!This program cannot be run in DOS mode.

$       ?QQQIQQQQPQQQQRichQ                        PE  d 7#[         " 	    n     H
                                                                                d                        ` 
                                                     0	                          .text                           `.rdata  H                    @  @.data                        @  .pdata          h             @  @.reloc  D   `     "             @  B                                                                                                                                                                                                                                                                                                                                H%! @WH H
  HHu H
 H H	 H _H HH\$0 HHu
HWHR0Hu%H
 H H	a H\$0H _Hd H9Ct9H
_ H H	/ H,  HCHP0H\$0H _H, HHr uHCHP0Hr Hu%H
 H H	 H\$0H _=	  t7H|r H
 H H	DA	   H\$0H _HEr   
s;H3r   H
v H H	DA
   m H\$0H _Hq   u	H t%H H
" H	) H\$0H _3H\$0H _LHwH       II     MAu    IAtIIHHRL;uD  LIHHHRL;tIIHHL;u     LIHHHL;tIvI|I@SHPHD$ HH HL$( HHT$(HHL$( HP[E~utAAu2D~tAAu2@WHPHD$ H\$`HHH HL$( HHT$(HHL$( LHASHHL$( HHT$(HHL$( H1 HL$( HHT$(HHL$( H HL$(Z HHT$(HHL$(` LHH\$`HP_IcHT$WHPHD$ H\$`HHLH HL$( LHHAHL$( HH\$`HP_H% @SHPHD$ HL/p H@ HL$(} LHHAHL$( LUo H& HL$(K LHHAHL$(Z Lp H HL$( LHHAHL$(( HP[@SH H7 A   E3H H LL;tHH H [  LI LYE3EIHL;AM;AEtHHAJICHA3H% LAL9A ~HHAJI@HA3H% H   HD$P* Ht
33螵
 HĈ   HAH HA@SH H HH HAHHIH9 uHAP0L 3L[H [H HC3H [HA H HA @SH HK HH HA HHI H9 uHAP0L& 3L[ H [H HC 3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH Hk HH HA0HHI0H9 uHAP0LF 3L[0H [H3 HC03H [HA8H HA8@SH H HH HA8HHI8H9 uHAP0L 3L[8H [H HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH H HH HA@HHI@H9 uHAP0L 3L[@H [H HC@3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH H+ HH HAPHHIPH9 uHAP0L 3L[PH [H HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH HK HH HAXHHIXH9 uHAP0L& 3L[XH [H HCX3H [HA`H HA`@SH H HH HA`HHI`H9 uHAP0L 3L[`H [H HC`3H [H\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _HAHH HAHHAXH HAXHAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH HK HH HAHHIH9 uHAP0L& 3L[H [H HC3H [HA H HA @SH H HH HA HHI H9 uHAP0L 3L[ H [H HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH H HH HA(HHI(H9 uHAP0L 3L[(H [H HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H HH HA0HHI0H9 uHAP0L 3L[0H [H HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH H+ HH HA8HHI8H9 uHAP0L 3L[8H [H HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH HK HH HA@HHI@H9 uHAP0L& 3L[@H [H HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH Hk HH HAHHHIHH9 uHAP0LF 3L[HH [H3 HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH H HH HAPHHIPH9 uHAP0Lf 3L[PH [HS HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH H HH HAXHHIXH9 uHAP0L 3L[XH [Hs HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH H HH HA`HHI`H9 uHAP0L 3L[`H [H HC`3H [H(   Hr
30  HN H'X E38  LHuH(H2 ICH' H H IC H H H IC0H H H IC8H H H IC@H H H ICPH H H ICXH H H IC`H H IH(H\$Ht$WH HHIIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH H HHIHCH H Ht
HuHAP0Hm HK HC H^ H Ht
HuHAP0HB HK0HC0H3 H Ht
HuHAP0H HK8HC8H H Ht
HuHAP0H HK@HC@H H Ht
HuHAP0H HKPHCPH H Ht
HuHAP0H HKXHCXH H Ht
HuHAP0Hk HK`HC`H\ H Ht
HuHAP03H [H\$WH HH HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _H\$Ht$WH HHIIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht	HօunHK8Ht	Hօu\HK@Ht	HօuJHKHHt	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH H HHIHCH H Ht
HuHAP0H HK HC H H Ht
HuHAP0Hr HK(HC(Hc H Ht
HuHAP0HG HK0HC0H8 H Ht
HuHAP0H HK8HC8H
 H Ht
HuHAP0H HK@HC@H H Ht
HuHAP0H HKHHCHH H Ht
HuHAP0H HKPHCPH H Ht
HuHAP0Hp HKXHCXHa H Ht
HuHAP0HE HK`HC`H6 H Ht
HuHAP03H [H\$WH HH HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _@SH 3Hy  L
X t=HU Hc
W H3HCHCHLCH   ( HH [3IA0  HHuH [H\$WH H HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
LW Hz  @ǅtH@T H
$W H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH H HHIHCH H Ht
HuHAP0H HKHCH H Ht
HuHAP03H [@SH 3Hy  L
V t=HM Hc
U H3HCHCHLCH    HH [3IA0  HHuH [H\$WH H HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
@U Hz  @ǅtHL H
U H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH 3Hy  L
rT t=HcO Hc
RT H3HCHCHLCH   x HH [3IA0  HHuH [H\$WH H% HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
S Hz  @ǅtHN H
|S H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH H; HHIHCH) H Ht
HuHAP0H
 HKHCH H Ht
HuHAP03H [@SH 3Hy  L
fR t=HK Hc
FR H3HCHCHLCH   h HH [3IA0  HHuH [H\$WH H HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
Q Hz  @ǅtHJ H
pQ H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H   HRN     H@M HuMG y  P Z  `  H#N     H)K HuG {  O Z  )  H$K    y HzH HuF   O Z    H}K    B HJ HuF   rO Z    HJ     H$I HuqF   ;O Z    HM     HJ Hu:F   O Z  M  H
 LH H%K HuF K  N Z    H
 LHl HF HuE K  N Z    HM    - HNL HuE U  ]N Z    H1J     HgG Hu\E   &N Z  o  HI     H8L Hu%E   M Z  8  HI     HH HuD   M [    HI    Q HrF Hu-HƩ D    zM [  HG HĘ   H	L     HM Hu-H{ eD    /M [  HF HĘ   HH     HL Hu-H0 D   L '[  H}F HĘ   HK    p H1J Hu-H C *  L 2[  H2F HĘ   HpG    % HI Hu-H C .  NL =[  HE HĘ   H}G     HJ Hu-HO 9C B  L H[  HE HĘ   HjK     HXD Hu-H B   K S[  HQE HĘ   HD    D HE Hu-H B   mK ^[  HE HĘ   HD     HI Hu-Hn XB   "K g[  HD HĘ   HI     HF HuB 2   J r[  '  HG    w LHEC HuA l  J }[    H@G HI A   HT$hD$`l  HD$XH
E E3HD$PH#D HD$HHD$@L\$8HD$0HD$(HT$     HF HuNA l  J [  a  H4G L

A LA HG H$   H@ HD$xHD    HD$pHF HD$hHGA HD$`H+H HD$XHF HD$PH#I HD$HHWC HD$@HA HD$8HF HD$0H[C HD$(HGD HD$  LHRA Hu;I [  }LE HC A   LD$hD$`o  HD$XHC AQ
AHD$PHB HD$HHD$@L\$8HD$0HD$(LD$ E3 HF Hu-H [  ? o  Hۤ HDB HĘ   3HĘ   33333HAL   MtIH@@HtH HH% H\$WH HH
DF HAL   MtHAL@@Mt	HW A	Ha HHuH
J LG Hw; H	 HH\$0H _HB   s HAL   Mu
L@@MtH IH% LH
 H/; H	H%e H\$Hl$Ht$WH H} MHH(IHE3MHg HHtT3H~&     HHHH H;HCHp  |3H/ EHHu
HWHR0MHH\$0Hl$8Ht$@H _DD$HT$HL$SUVWATAUAVAWHhLiHyHq 3Ll$PH|$XIMcLMtIj LLH HAH~ HHL 9J~H
&: @ t3  HtMuYA}CuRHuE9}uMLIIHK  Eu)Ht$LFIcEI;uHVLIbH  H   K$ HH   LpH$   HMNMLH$    tQMM~f     IE IH$   H IO,H M}MMHX uLl$PD$   IHH+HLHLH$   HH(Ht
HFH^HL$   HT$XHL$HD$@H\$8Dd$0E3ILt$(D|$  HHtHu
HGHP0H HHIHhA_A^A]A\_^][H\$Hl$Ht$WH HAIHH   HHu5 Hl HAH_ HH- 9J~H
'8 ! t3ELHHH
' HHJHu"{ HuH
 H 8 H	 HH\$0Hl$8Ht$@H _H\$Ht$WH HAHqHHxH HAH L Ht A9H~#H
7 g t3H\$0Ht$8H _HHH
b HHJHu" HuH
 H7 H	 Ht$8HH\$0H _H\$Ht$WH H   H HHuH\$0Ht$8H _HE3HHHx#HHu
HSHR0H\$0Ht$8HH _HT$SHPHAHH;0    Hs Hl$`HiHHt$pHqH|$xHy BHK HH 9J~(H
5 
 tH|$xHt$pHl$`3HP[Ã~Cu!Hu~uDGHT$hLHUNLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(LL$hHE3HD$     H
 H|$xHt$pHHl$`JHP[H;, uHA@tHP[@HP[@SHPHAHH;   H' Hl$`HiHHt$hHqH|$pHy BH HH 9J~(H
4  tH|$pHt$hHl$`3HP[Ã~Cu:Hu9~u0LE33HfLGHcFI;uHWLHHLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(HE3E3HՉD$ 6 H
7 H|$pHt$hHHl$`JHP[H; uHA@t3HP[%H.9 E3HP[A@SH HHu3H [H|$0_ HHu
HSHR0HH|$0H [Ht$WH 3HHLAtHALEt]L;VϋMuHHH\$0 HHtHH HHu
HSHR0HH\$0Ht$8H _JDHt$8H H _H\$Hl$Ht$WH 3HHE   HAH;0    H;+ uDHDƋAEDuHQ9t$PtH;W΋H   HD   HhhH   H9u   EtGHyBHE Ht9HxHHHU   H
 H	 u3    HHUsHҋ΋EuHW9t$PtJH;W΋Hu5H HHtHH? HHu
HSHR0HHGHH H\$0Hl$8Ht$@H _E3MMEAMADtMyLMHMyLL;LOM+M33H% HD$8IIHtLD$0HLL$0LD$(H%c @SH HHH
5: / Ht	H H [HH [@SH HAHH	HHAL   MtAH@@HtH y LHu	H [L[IC HHHKIC H3K H [Hl$Ht$H|$ ATH 3ILHH9iuH9iuOy3   H\$0H9otEG t?    HHtpHHpG tE3HIWHBHIWH4   i HHt1I$L`HHp HOE3HHHu
HCHP0H\$0HHl$8Ht$@H|$HH A\Hl$Ht$WATAUH 3IMLHH9quH9quNy3   H\$@H9wtRG tL    HH   I$L`HE Hh G tE3HIWHKHIWH=   [ HHt:IE LhI$L` HE Hh(HOE3HHHu
HCHP0H\$@HHl$HHt$PH A]A\_LH
~ H. H	H% HLH
J H	H L

 H. LDH%_ H\$WH LQHHyPHYXHQHLAPLIXMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _HAHHHAPI HAXI3HAHHAPHAXHAWH@|$x HXHhHpHxL`LhHLpt DAH H(3LeHLmPLuXHEHHEPHEX9D$pt6MtI$MtIE MtIMMIH    H HMHHuPH}XLeHLd$0LmPLl$(LuXLt$ Hl$XHHt
HuHQR0HtHu
HFHP0Ht$`HtHu
HGHP0H|$8HuH
  " H Hu
HCHP0|$x H\$Pt	A H@A_HHLT$pM;}	H, 
MH, LT$0H_ L
, LDIH HDHx, HD$(LD$ LH
 H	û HH@SH HH. H
W Hh, H	LLH [H%{ LI[IkVWATAUAVH03MMICICICH$   HMKH4MCISLY   f     LHT$hHM   IH9   HAHHuHL HH9B   HB        MtiHH9tNH	 y? H  HT$ht'HH; u8H9 tHD$ H+HI  HD$ HH+HIH;    HH;   HH9G  H	 y Hf    HT$hHH;u   MtA HHHBH9AuJ HT$huHH; uHD$ HH+HIH; u`HH;t9@ HH9   HHBH9Au    HT$hHH;uM   LD$ I̵    LL$ LD$hHT$(I\ 3H\$`Hl$pH0A^A]A\_^H
 L$   H) H	 HT$hHa H) HO H) H
q L$   LH	 {LD$HT$HL$H(HtHLD$@HT$8HL$0H E3HtH;tHLD$@HL$0Hֵ LL$8Mt=L;t8I HL$@H^ H9AtH
 Hj) H	    HL$0LL$@HA         LD$@HT$8HL$0 H LD$@HT$8LHD$0H\$HIIHIYXH|$ IyPIAHMAXIQPHt
HuHAP0HtHu
HGHP0H|$ HtHu
HCHP0H\$HH(L9L$8tH
 H( H	 EHL$8HAHD$0H HY HHL$0S ,H
 H( H	 HD$8HtHHL$8H9 uHAP0HD$0HtHHL$0H9 uHAP0HD$@HJHHL$@H9 8HAP0H(H\$Ht$WH03AHLD$XHT$ E3HHD$XHD$ Q t:D  HD$XHH   rs]LD$XHT$ E3H u˅ukHL$XHtaW H
 H	H' LL 3H\$@Ht$HH0_H
Q H' LH	~ 3H\$@Ht$HH0_H\$@Ht$H   H0_H;uHd H HZ HAH;V uD9AtHO H HE H;E u0LIIHH3H+HMt
AIu3A;uH; uAfAnf.zulA   H% H\$Hl$Ht$H|$ ATH`H 3LH9AP  HiHC  HYHP H9C   H LcHs Hl$PHkHT$XHAHl HH: 9J~H
# .    }Cu!Hu}uDFHT$PMHLHS(Ht
HNHFHHHT$HL$@HD$8|$0LL$PE3IHH|$(D$    ˰ HHɰ HIa    HHtNHE HhI$L` HE3HHHHu
HVHR0HuHSHR0HL\$`HI[IkIs I{(IA\H\$WH HAIL   MtAH@@HtH  HHuH\$0H _HHHHu
HSHR0HH\$0H _H(H5 H9AuSLI LYE3EIHL;AM;AEtHHAJICHA3H( y,H(LH** 
HHtH uH@P03H(HA`HHAhI HApIHHtH I HtH IHtH H\$WH LQ`HyhHYpHQ`LAhLIpMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _LI[IkVWATH0HAHE3IICHAPHICHAXHLaXLaHLaPIKMCISICI L9fHtlHD$ Le L'L#HtHHL$ L9!uHAP0HD$(HtHHL$(L9!uHAP0HD$PHtHHL$PL9!uHAP0   HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHM LHHV`H~hH^pHN`LFhHFpHtHu
HBHP0HtHu
HGHP0HtHu
HCHP03H\$XHl$`H0A\_^H(LAH
Q LJ H	H" ] 3H(Hl$Ht$WH HBHiH   HrHl$8Ht$@H _H% HH\$0 HHu#H
֮ LELO H	H<" ޮ 3DH H@   s0L  Mt$LHHAHHu
HSHR0HHH\$0Hl$8Ht$@H _HAH    tH%c H\$Hl$VWATAVAWH@3LH
F' HAELL   HHMtH+$ AH+H@@HtH$ H HH$ C HH   Mu3 HHtwLH
`( Ll$p LHtU HHtGA~ LHt6Hl$0HD$(LMIHLt$ ] I$HuIT$IR0Ll$pHu
HVHR0HtHu
HCHP0HtHu
HGHP0H\$xHH$   H@A_A^A\_^H\$WH HAHL   MtAH@@HtH  HHu/H
x H	o tH
L LG H  H	p HH\$0H _@UWH8HH
& Hu	H8_]H\$PHt$XLd$`LeHLl$0LmPLt$(LuXL|$ E3L}HL}PL}X HtH% H H   H
& HAL   MtH% AH,L@@MtH% H AHHz%  HHt@HC H5 HE5 Hu
HCHP0HtH AE$ L_ H% H
% A MMIHL|$ Lt$(Ll$0Ld$`Ht$XH\$PH8_]H\$E3DRHEExIcHD;D~H\$E~.AA+Ù+EIcHLD;}E~#EYE;|IcHD;DA~AAH\$H\$A@WH Dt;H=$ Ht/$ HI;$ }HHD9Du
HH H _3H _̅Q  H\$Hl$ WH H$ HHuH   e H  hH8HHd$ V$ @   H$    H\$@Hl$HH _Ht$05-$ DHˋLd$8LcD;}*IH9luHH<H   HAP0   # ;u.p@HHcHĤ HHt\5# 5# H# LcIM;~(MILL+IAIIIAIAIAuHƉlH<H5h# Ht$0Ld$8H\$@Hl$HH _H\$Hl$Ht$WHpHIA HHtAtL  H
 DHգ 	H¤ HHu(Hu
HCHP03L\$pI[IkIs I_Hc H
D E3HL$hl$`H|$XH\$PHD$HHD$@HD$8HD$0HD$(HL$ E333 HHu
HSHR0Hu
HWHR0HpHl$H|$ ATAUAVH H MAL LtItDADH\$@Ht$HEt6H5! Ht*! H΋;}HcHD9Du	HH,MDŋIUHHthtHЋLZ E3HI HHtHȉh|' HtHu
HCHP0HtHu
HGHP0Ht$HH\$@Hl$PH|$XH A^A]A\H( H(H( H(H(ޡ H(H( H(H( H(H(~ H(H(^ H(H(> H(Htfff     H   H;tHu3H; ø   H;tMLX  Mt#MH3M~IHH9t-HHI;|3H   H;tHu3H;B ø   @SVH(Hʡ Hl$@H|$HH(Ld$PLl$XLeHLmPLt$ LuXHEH    HEP    HEX    IHHtɟ uHѠ uHH uH 3HMHH}PH]XLeHLd$PLmPLl$XLuXLt$ Hl$@Ht
HuHAP0HtHu
HGHP0H|$HHtHu
HCHP0H(^[H;u   HAH; t      t
   rH%۞ L3H\$WH IHH;t\I;tWHAH; t;      t
   r%} u*HHm uH\$0H _H\$0H _/   H\$0H _Ht$WH HH
 F HHuHt$8H _H HWHH\$06 HH   HH      uH
 LGH H	' %HG H9C t-H
ԟ LGH H	  Hu
HCHP03Hu
HFHP0Ht$8HH\$0H _H
 H	 t H  xHWLH xHHH\$IMLI HHI`LZhLRpHB`IHBhHHBpIMLH\$@SUVH LQHHYPLYX3HHLT$XH\$@L\$PHAHHAPHAXMuVMtIHL$PH9uHAP0H\$@HtHHL$@H9 uHAP0H] H HS H3H ^][L? M;   HuH* H H  L\$PLT$XqHK   sSH{|	H[HH H H HD$@HHL$@H9 uHAP0L\$PLT$XL\$PLT$XI   H   MtIHL$PH9 uHAP0LT$XI
HL$XH9 uHAP0H3H ^][M M;tbIBH;& t%      tA   rII	 
3Iu"LL$PLD$@HT$XHH ^][LD$PHT$@HL$X HӞ HL$@HH9AtHIHx tHD$PH|$HHtHHL$PH9 uHAP0HD$XHHL$XH9 uHAP0HL$@HAL   MtH AH,L@@MtH H AHH  HHD$@HHL$@H9 uHAP0Ht#3H HHu
HSHR0Hu!E3E33HL͛ IH=Û H>H|$H3H ^][H\$WH HQ Hy(HY03HA HA(HA0HtHu
HBHP0HtHu
HGHP0HtHu
HCHP0H\$0H _H
A HR H	H%8 H
 HR H	H% H(HtH
؜ H	ǜ H(H\$VH ApHHمu2Ht-H; t$H
 H H	 3H\$8H ^Ãu"HtH
^ H	M 3H\$8H ^Hy  Hܙ H|$0H8tSHA0HtHHHGHtH HGHAHC LG`HWhHOpHG`HC(HGhHC0HGpLC HS(HK0A2HG`HC HGhHC(HGpHC0HC HtH HC(HtH HC0HtH LHHCtSH|$0Ct H\$8H ^@SH HH   H HH9ZHuwH? Ht$0H|$8L 3I HJHHrPHzXLBHHBPHBXHt
HuHAP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$8HH [H\$WH 3HHIHHD$0HtHGHHuHAP0H
# HT$0H	H\$0E3HHHHtHu
HSHR0HH\$8H _@SH HHIH{t tH
. H? H	& 3H [HtYCtHAH; u H;җ u   LH !Ct Hu.HHHH [0E3HHHH [H\$Hl$Ht$ ATH H| 3HLH9BuH  HH      AtHBH|$0L   MtH HAH2L@@MtH HH AHH H HHu%H
 H	 u	H ە '3H~ HHu
HGHP0HDH|$0AD$t HtHu
HSHR0H\$8Hl$@Ht$HH A\@SH HHIH{t tH
. H? H	& 3H [Ht4CtHAH; u   Ct HuHH [H E3HH [H\$WH yt HYHHt$H
 H H	 3H\$8H _HtIHHHt$0HOHHtHGH    HuHQR0Hu
HCHP0Ht$0uH
 H	 3HDB9Ht4H u
HPHR0H
 H^ H	 3H\$8H _ Ht*L H HM HÓ H| H\$8H Hm H _LL$ LD$SUWH0yt HYHHHt!H
P Ha H	H 3H0_][Ht$PH   HH t$xL I;t?HBH;Ǒ t$      t
   rIH 
3Ht|txHH<Hu
HSHR0HOHHtHGH    HuHAP0xLD$hHT$`E3H3E33HHHHt$PH0_][GtHCH;X u+HD$pLL$hLD$`HHˉt$(HD$ H  L   MtH HAH2L@@MtH HH AHH Hn HHucHu
HCHP0H
ǔ H	 uHt$PGt3H0_][ HOHHtHGH    HuHAP0Gt HT$pHtH H"LL$hLD$`HHHD$     d HHu
HFHP0Gt Hu
HCHP0HuH HHLI[WHP3HA   IC ICICICIC HICICEAH HICB u
3H\$`HP_LL$pLD$xHT$@HD$(   H\$ H\$`HP_H\$Ht$WH HHIIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _H\$WH HHI3HtH{HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HKhHtH{hHuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP03H\$0H _@SH H H{8 t	H {p |&H L[HAx  H; Hݎ H}H H [@SH yp H   H   HW Hl$0Ht$8H03HnHH|$@H~PLd$HLfXHFHHFPHFX9ApuHt0HHuq HtHc 
H uH@P0MLHHCHHLd$HH|$@Ht$8Hl$0tHH [HAPHHD H H(LHt2HB   s$HIPHIPPHt
HuHAP03H(H
 HL H	 H(HAXHHDi H H(LHt2HB   s$HIXHIPXHt
HuHAP03H(H
+ H H	+ H(@SH HHQLIMtI3At ApHA@HAHHA HA(HA0HA8HD$XHtH HAXHD$PHtH HAPHD$`HtH HA`MtI LAhQ HH [H\$Ht$WH0HH HH   L* H+ H    L;	 H$ H    H$ LH xpLE H Hm xULLú  HHD$     T Ht3H u
HPHR0HuiHCHP0HH\$@Ht$HH0_Hu
HCHP0H[ H
 H H	A    yHu
HGHP03H\$@Ht$HHH0_Hy H(=m
     H
  Hu13 H
^ H H	A   P y6H(H H
    HHtH uH@P0H
  Ht+H HHtH uHPHR03H(S 3H(H(HH
 H Hx Hы H HH(H  A   L H$  AQD$    
  L H$  LȺ    D$  D8$  u$  8$  u
3H  H$  L$  L HD$(Hv HL$0   HD$  HT$0A   3 H  @SH  HHuH [HH|$0( HHu
HSHR0HH|$0H [H\$Hl$Ht$H|$ ATAUAVH  EILLE HH<  H HHu
HWHR0H  I HH   HH HHu
HVHR0Hu
HSHR0H   HG      uH
ȇ H MH	M |HG EuGH;vEHl$0HD$(L HL$@Mͺ   Ld$  HT$@E33 x1HMH;tH
\ H MH	MHl$(HD$ t HuHGH
Hu
HCHP03L$  I[ Ik(Is0I{8IA^A]A\@SH H9 Ht_{  HKtHSE3H {" t  
HSH HHHH9 t H	 tH(H; u3H [ÃH [H\$WH HHt HHIH;t6҄ u,HT$0LHU HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _H(E3H;
 AH;
 AH;
 AAu H(@SH0HAHH
\ L@H	LLD$ LH } Hu
HCHP03H0[@SH HA3ۋ         H@`H|$0HtbH   HtH=ݵ HH   Ht<H= HHt+HC   r=r7HHH|$0H [
d HuH
h HY H	h HH|$0H [HHH [H(HAH; u	HcAH(H;    LAIHH3H+HMtA3I   HH(IIw;H|B  HAIHHH(ËAIHHHH(H(H% H\$0 HHuHH\$0H(HH|$  HHu
HSHR0H\$0HH|$ H(fO  O  :  O  O  O  (  O  O  ̅tHU H HK HS H HI HT$tHHHD$LD$HكH;HL$IMH HT$tHHHD$LD$HكH;HL$ICH H H+ HH\$Ht$WH`H} )|$@3D)D$0D)L$ HHD
 8HA H+AHfAWHtTH;r~ HOH@f/v#HG H+HH;rz~ HOHxHG HH+HH;rHO fEWH+OHH   )t$Pfff     HY| 0H;r~ H_fAWH@f.zt1HG H+HH;r} H_H@\E
 DXHO HH+HH;r(t$PfA(E
 H\$pHt$xD(D$0D(L$ X(|$@H`_LD$HL$WH0HD$ H\$XIHD$H    H֛ HHQHIR| D$H   H8| HH\$XH0_H\$Ht$WH L   HIL+   IgfffffffHIIHHH?HH;r2H\$0Ht$8H _H   IH+   HHHH?HH;r| H   HHH{ H\$0Ht$8H _HL$WH0HD$ H\$HIMHLAHy rLYLYE3AHAMtHyIHHIHMyMM;MOL+M33} H6LHD$hHtLD$`IIHLL$`LII} HHz HH\$HH0_H(HB   s'HAL   MtAL@@Mt	H A	~ Hu9L
W D@`H
 
  g `   1 
  L
 3H(HT$HL$SVWAUH8Li3339Ypt3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'HV  i    >  HG   { LHu'HV  i   y ?  H a  IEHHHuEH
| L HK H	 LkV ] i   L   A    HAH; | tyH;| tpH~ HHu'H
V  i    F  H
q   H@L   Mu2HU  i    H  H:   H3HE3LdD  MuFH{ H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AHS{ H	H{ HHtdHu
HSHR0IULI3>z uHu
HGHP03HT v i   @ s  H (  H]T O i    p  H   H
z L H H	/} LT 
 i   Lw  m     z HtH| HHktyy Hu
HFHP0H\$`HL$hLK0LC(HS &HHC0    HC(    HC     CpLt$(Ld$0Hl$pIL|$ H8A]_^[HWS I i    c  H MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
N D  H
b uH\$Hl$Ht$WH HH
zx 33虵HHu'HzR l q   6   H a  HCH HL   MtAL@@Mt	H Ax HHu      H-w H9C&  H{H  HsHHHHHuHAP0HH膳HHuH
Q }   H
 QHu
HGHP03Hu
HCHP0   w HH   1   HZQ H HE @ q   u
HEHP0HtHu
HFHP0HtHu
HCHP0HtHu
HWHR0L
b D  H
 3cHݳHH/   QH
 HHHHh Hp(H
Mw HH
Cw HH0H
8w HH
.w HH8H\$0Hl$8Ht$@H _H(IL$0Gu Hu9L
3P D@PH
h    P      L
x 3H(H(y tHu H Hu Hu H Hu Hu9L
O D@QH
 D
   Q   b D
  L
 63H(H\$WH E3H;t HAE3H;v A3H;~t DEuH*w DEÀuRu HtGL
O H
c g
  AQ    Q    g
  L
M H\$0H _È_H\$03H _HAH HAH\$WH LJHHL;
Ut trH;$u tiH
3u MIL H	H Xw L
AN H
* 
  AR   L
  R    
  H\$0H _HHAHHIH9 uHAP0H_H\$03H _@SH Hkt HH HAHHIH9 uHAP0LFt 3L[H [H3t HC3H [HA H HA H\$WH LJHHL;
s trH;s tiH
s MILT H	HV v L
L H
j   AS   L
H  S      oH\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH Hs HH HA HHI H9 uHAP0Lr 3L[ H [Hr HC 3H [H(A(s Hu9L
K D@TH
ʪ b   T    b  L
: u3H(@SH0Hp )t$ HH9Bur
HUs f(f.5! zTuR/r HtGL
cK H
   AT   C T   
   L
 (t$ H0[s((t$ 3H0[HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H+q HH HA0HHI0H9 uHAP0Lq 3L[0H [Hp HC03H [HA8H HA8H\$WH LJHHL;
q trH;p tiH
p MIL H	H^ r L
I H
j )  AV   L
  V   T )  /H\$0H _HHA8HHI8H9 uHAP0H_8H\$03H _@SH Ho HH HA8HHI8H9 uHAP0Lo 3L[8H [Ho HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH Hn HH HA@HHI@H9 uHAP0Ln 3L[@H [Hn HC@3H [H(AHo Hu9L
G D@XH
    X      L
 U3H(@SH0Hl )t$ HH9Bur
H5o f(f.5 zTuRn HtGL
CG H
   AX   # X      L
 (t$ H0[sH(t$ 3H0[HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH Hm HH HAPHHIPH9 uHAP0Ll 3L[PH [Hl HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH H+l HH HAXHHIXH9 uHAP0Ll 3L[XH [Hk HCX3H [HA`H HA`H\$WH LJHHL;
j trH;k tiH
k MIL H	H m L
D H
   A[   L
  [   T   /H\$0H _HHA`HHI`H9 uHAP0H_`H\$03H _@SH Hj HH HA`HHI`H9 uHAP0Lj 3L[`H [Hj HC`3H [H\$Ht$WH H5 H
{ HHol HHtH HbHHu'HC u m  ?    H    HDi H9CuHHk HHuH
9C     H
 .E3HHȢHHuyH	C     Hh H m  u
HGHP0HtHu
HCHP0L
2 D  H
 Y3H\$0Ht$8H _Hu
HWHR0Hu
HSHR0H\$0HHt$8H _H\$Hl$Ht$ WATAUH@3MHHH\$pM   LjIMtH   HZH\$pIh HMu H Ij HHD$pHtPHH   H LL$pH۞ HD$(E3ILl$ >y$  YH\$p   Hzt}HGH
Gh L
 H	HD$0Hτ HD$(LM H HD$    Oj 	%  L
3A H
< A      L
 %HZHHEHHMH9 uHAP0H]3H\$`Hl$hHt$xH@A]A\_HT$HL$SVWAUH8Li3339Ypt3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'Hr@ d   . %  H   Le LHu'H=@ /    %  H a  IEHHHuEH
yf Lگ H H	i L?    LJ  %    HAH;e tyH;e tpHg HHu'H
?    X %  H
   H@L   Mu2He? W   ! %  H   H3HE3LdD  MuFHe H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AHd H	d HHtdHu
HSHR0IULI3c uHu
HGHP03H>     %  HY (  H=     %  H2   H
&d L Hx H	f L=    L M %     2d HtHf HHtyIc Hu
HFHP0H\$`HL$hLK0LC(HS 覴HHC0    HC(    HC     Cp?Lt$(Ld$0Hl$pIL|$ H8A]_^[H<     %  H, MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
 DS ! H
: ATAVHHHI H\$`Ht$pH H5 L5. H|$@L|$0LH
 E3HId HHtH H螗HHl$hLl$8Hu'H;    q '  H
 9  HCL   MtH HAH2L@@MtH HH AHH Ha HHu'H5; '    '  H z  Hu
HCHP0H&` LnII9E   H^H  HnHHHE HHuHAP0H` LmI9E    E3HT$ HEAH\$ Lt$(HHu'H: r   < 1'  H   Hu
HCHP0IHu
IE HP0HE Iu
HEHP0   ^` HH  H:     U'  H` :      ` HHu'H
9     ?'  H
&   HXIE3HHLp IEHHu'H9 x   B E'  H   Hu
HGHP0IIHHHH09 "    +'  H _  IGH IGHEIGL   MtHZ IAH1H@@HtH? IH HH* I)_ HHu'H8    ^ Z'  H    H] IH9G4  H_H'  HwHHHHHuHAP0HHHHu$H*8     g'  H \Hu
HCHP0IHu
HGHP0   ^ HH   H7     n'  H! HtHE u
HEHP0HtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L
 DJ  H
 ~HBHH,H7     j'  Ht NH  LH HGHo Hw(H] H H] HG0H] H Hx] HG8L|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@VWAUH0HA3LL   MtH AH,L@@MtH H AHH \ HH\$PHl$XLd$`Hu'H5      j)  HQ   HZ Lg3I9$c  H_HV  HoHHHE HHuHAP0H[ LeI9$   E3HT$ HEAH\$ Ll$(גHHu'HX5 J     })  H   Hu
HCHP0Hu
I$HR0HLd$`Hl$XH\$PH0A]_^ù   2[ HHu'H
4      )  H
8    HXIE E3HHLh 3WHHu$H4     T )  H RHIHFHP0:IHHH#HD4 6      w)  H Hu
I$HP0HtHu
HCHP0HtHu
HVHR0L
X D  H
 3H\$VWAUH0H= LH
j H3_\ HHtH HRHHl$PLd$XHu'Hi3 [ Q  % m0  H   HCHkL   MtH HAH2L@@MtH{ HH AHHe HlY HHu'H2  Q   o0  H: T  Hu
HE HP0HGL   MtH HAH2L@@MtH HH AHH HX HHu'HU2 G Q   r0  H   Hu
HGHP0HFW Hk3H9E d  H{HW  LcHHI$HIuHAP0HW Il$H9E    E3HT$ IEAH|$ Ll$(LHu'H1  Q  \ 0  H   Hu
HGHP0Hu
HU HR0ILd$XHl$PH\$`H0A]_^ù   zW HHu'H
+1  Q   0  H
    HxIE E3HILh 3蟐LHu$H0  Q   0  H5 RHIHFHP0:IH_LH#H0 ~ Q  H 0  H Hu
HE HP0HtHu
HGHP0HtHu
HVHR0L
 D%  H
 Ǳ3ATAVHHH\$`Ht$pH|$@H=B E3L|$0LH
 HMIX HHtH H|HHl$hLl$8Hu'H/  T  O 0  H G  HCL   MtH HAH2L@@MtH HH AHH HU HHu'H/  T   0  Hh   Hu
HCHP0HGL   MtH HAH2L@@MtH HH AHH H
U HHu'H. u T  ? 0  H 
  Hu
HGHP0HtS LkII9E   H{H  HkHHHE HHuHAP0HT LmI9E    E3HT$ HEAH|$ L|$(MHHu'H-  T   0  H# H  Hu
HGHP0IHu
IE HP0H
l LHH  Hi- [ U  % 1  H      ~S HHu'H
/- ! T   1  H
   HxIE3HHLx I裌HHu'H,  T   1  H9 ^  Hu
HFHP0IIHaHHH,  T  J 0  H   HvDy'HX, J U   !1  H    Hu
HCHP0E*  HEL   MtHP HAH2L@@MtH5 HH AHH HFR HHu$H+  U  { $1  H LHC E3H@HHu~H+ s U  = &1  H Hu
HCHP0HtHu
HGHP0HtHu
HFHP0L
 D  H
 輬Hu
HCHP0HHE LL|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@SH HAL   MtH AH,L@@MtHs H AHH` P HHt$0H|$8Hu'H9* + X   o1  H   H:O 3H9C   H{H   HsHHHHHuHAP0HH葋HHu$H)  X  ~ |1  H eHu
HGHP0Hu
HSHR0HH|$8Ht$0H [HzHHuH[) M X   1  H HtHu
HCHP0HtHu
HWHR0L
 D  H
K 親H|$8Ht$03H [H\$Ht$H|$ ATAUAVH@H= LH
n LHM3]Q HHtH HPHHl$`Hu'Hl( ^ _  ( V2  H   HCL   MtH HAH2L@@MtH HH AHHl HsN HHu'H'  _   X2  HA   Hu
HCHP0HGL   MtHM HAH2L@@MtH2 HH AHH HM HHu'H\' N _   [2  H   Hu
HGHP0HML 33H9Cu+H{Ht"HCHHH HHuHAP0   HL H9C   HcHT$(DEHE3HH+H|$ Lt$(Ll$0Ld$8HHu'H&  _  Z m2  H    H#  H  HGHP0
  EHcL HHu$H
A& 3 _   {2  H
 dHtHx3IHcE3LtIE Ll I$HHLd(螅HH   H%  _   2  H0 Hu
HCHP0HtHu
HGHP0HtHu
HVHR0L
 Dt B H
 3#Hu
HVHR0Hu
HSHR0HHl$`H\$hHt$pH|$xH@A^A]A\AVAWH8HAE3H\$PL   Hl$XHMMtH AH,L@@MtH H AHH{ %K HHt$`H|$0Ld$(Ll$ Hu'H$ |   F 4  H ]  HI IH9C   H{H   HsHHHHHuHAP0HHHHu'H
$     4  H
g   Hu
HGHP0IHu
HCHP0HIu
HFHP03H HHu^H#    a 4  H 9  H荆HHuHn# `   * 4  H   HM H;
I u>H
J Hӝ H	
L L##    L  4    H H HHu'H" ٽ    4  H< {  H@H;H t|H;H tsHHJ HHu'H"    Q 4  H )  H@L   Mu3H^" P    4  H   HHIMHu
HCHP0LdMuFHG H9GuH;o.  HGHH\HI,H;o  I$HHIHAHH   ILHt
HuHAP0H HG HHtoHNH9N ~H HFHHAHFHHeH uH:HCHP0+HA! 3    4  H    H!     4  Ho    G HtHI HHmtkF Hu
HGHP0HHLu
HFHP0Ll$ Ld$(H|$0Ht$`Hl$XH\$PMtIu
IWIR0IH8A_A^Hg  Y   # 4  H HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
v D  H
 蝡;HHHATH   HXHpHxLhLpE3LxHALL   L$   ML$   Lt$ L$   IIMtH= AH,L@@MtH% H AHH E HH$   Hu'H-     8  H >  H.D IH9C   HkH   LcHE HI$HIuHAP0HI肀LHu'H    o 8  H U  HE u
HEHP0IHu
HCHP0I$uID$IP0IEL   MtFHV IAcHFLHuH'     8  H|   L@@MtH IH AH ISD Hu'H     9  H$   L% H
i H$   IXF HHtH IKyHHu'Hl ^   ( 9  H   HCL   MtH HAH2L@@MtH HH AHH HsC HHu'H ޷    9  HA   Hu
HCHP03A HHu'H    a 9  H G  IM H;
2C u>H
AC H* H	AE LZ L   L  9    H -B HHu'H
    ڿ 9  H
s   H@IH;A t{H;A trHMC HHu'H
      9  H
 k  H@L   Mu0H    N "9  H 4  HHMHu
HGHP03NlfMuFH$A H9FuL;f:  HFIJ|HI,L;f  I} IHIHAHH   H$   H$   Ht
HuHAP0HJ H@ HHtmHKH9K ~H HCH<HAHCHHA uHu
HGHP03#Hl ^   ( H9  H   HE 7    F9  H 
  @ Ht HB HH蘟   ? Hu
HFHP0H? E3LmII9E x  HuHk  LeHHI$HIuHAP0H? Ml$I9E    E3HT$(IEAHt$(H\$0vLHuNHa S    ^9  H 
  H: ,    >9  H   Hu
HFHP0HI   HCHP0      #? HHu'H Ƴ    n9  H) v  HpE3HIIHX KxLHu'H ~   H t9  H K  Hu
HGHP0IJHHzLHu'H= /    W9  H   Hu
HCHP0HE u
IE HP0H
E L$   hHHu'H ˲    9  H.   H@L   MtH* HAH2L@@MtH HH AHH H= HHu'HY K    9  H   HE u
HEHP03< HHu'H    ͺ 9  Hf 
  H$   HI H;
= u>H
= H H	? L    L s 9  }
  HG < HHu'H t   > 9  H׳ $
  H@H;7< txH;6< toH#> HHu'H4 &    9  H 	  H@L   Mu3H     9  HR 	  HHMMHu
HCHP0NdMuFH; H9FuL;~<  HFIJ\HI,L;~  I$IHIHAHH   H$   H$   Ht
HuHAP0H> H-; HHtoHMH9M ~H HEHHAHEHH; uH0HCHP0!H ȯ    9  H+ x  H    k 9  H Q  I; Ht H5= HH   \: Hu
HFHP0Hu9 LoII9E x  HwHk  LgHHI$HIuHAP0H: Ml$I9E    E3HT$8IEAHt$8Hl$@MqLHuNH     9  H#   H    c 9  H I  Hu
HFHP0HE Iu
HEHP0I      9 HHu'HA 3    9  H   HpHh E3HIIIrLHu'H     9  HK   HuZHCHP0NHHytLHu'H    f 9  H i  HE u
HEHP0IHu
IE HP0H
 Ld$ yHHu'HF 8    9  H   H@L   MtHO HAH2L@@MtH4 HH AHH HM8 HHu'H     9  H   Hu
HGHP0H6 LkII9E   H{H  LcHHI$HIuHAP0HT7 Ml$I9E    L$   E3HT$HEAIH|$HL|$PnLHu'H    Ĵ :  H]   Hu
HGHP0IHu
IE HP0IL$   MHuHAP0HK8 D90  H$   <8 HH  Hx j   4 5:  Hͭ M     6 HHu'H> 0    :  H   L$   HxE3IHILx IoLHu'H ݪ    #:  H@   HE u
HEHP0IL$   HI_qLHH ~   H 	:  H .  I7 Hu'HV H    6:  H +  H;t7H
6 H	7 L    Ly ϲ 9:    H
C nvHHu'H ѩ    E:  H4   H@L   MtH HAH2L@@MtH HH AHHߪ H4 HHu'H_ Q    G:  H   Hu
HCHP0   3 HHu'H    ѱ J:  Hj   I$H@HL$ L HHCHHH2 LmII9E K  H}H>  LeHHI$HIuHAP0H3 Ml$I9E uvE3HT$XIEAH|$XH\$`jLHu'HX
 J    d:  H    Hu
HGHP0H  HCHP0u     D3 HHu'H     t:  HJ    HxE3HIIHX llLHu$H    i z:  H oH   HFHP0   HH,nLH   HY K    ]:  H HtHu
HCHP0E3E3HtHE u
HEHP0HtHu
HGHP0HtHu
HFHP0L$   L$   L
8 D  H
ĉ _M(Hu
HCHP0HE u
IE HP0I$MH$   L$   H$   H$   H$   H$   Ht
HuHAP0MtIu
IGIP0HL$ L|$xHt
HuHAP0MtIu
IFIP0H$   L$   HtH u
HPHR0IHİ   A\H\$WH HYPHCH;0 u3H9CtIHCHHpH;m0 u3H9Ct'H[HQHHhHtHAHt3HH330 HHu3HH/0 HHu
HGHP0Hu?L

 A  ;  H
 L
g D  蕋3H\$0H _H H/ HHucL
	 HA  ;  D L
 f uHSHR0L
 Dx F H
_ 3H\$0H _Hu
HSHR0HH\$0H _HAHH HAHH(HIXH	 HAL   MtAL@@Mt	H AL/ Hu;L
 H
 L<  A     r L<  L
 F3H(HAXH HAXH\$Ht$WATAUH@H LH
 LH30 HHtH HcHHl$`HHu'H  $   A  HW   H- 33H9Au%HYHtHqHHHuHAP0   H- H9F   IEHT$(DEHD$(HcE3HHH\$ H+Ld$0dHHu'H[ M $   A  H    H"  H  HCHP0	  EHcM- HHu$H
  $   A  H
S cHtHX3IEHcE3H IEHHDI$Ld H\fHH   H  $  U A  H Hu
HFHP0HtHu
HCHP0HtHu
HWHR0L
 D2   H
 ԇ3#Hu
HWHR0Hu
HVHR0HHl$`H\$hHt$pH@A]A\_HAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH H+ HH HAHHIH9 uHAP0L+ 3L[H [H+ HC3H [HA H HA H\$WH LJHHL;
}, trH;d+ tiH
s+ MIL H	H - L
 H
 oB  A  L
ء Z   $ oB  H\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH H* HH HA HHI H9 uHAP0L* 3L[ H [Hs* HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH H) HH HA(HHI(H9 uHAP0L) 3L[(H [H) HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H( HH HA0HHI0H9 uHAP0L( 3L[0H [H( HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH H( HH HA8HHI8H9 uHAP0L' 3L[8H [H' HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH H+' HH HA@HHI@H9 uHAP0L' 3L[@H [H& HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH HK& HH HAHHHIHH9 uHAP0L&& 3L[HH [H& HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH Hk% HH HAPHHIPH9 uHAP0LF% 3L[PH [H3% HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH H$ HH HAXHHIXH9 uHAP0Lf$ 3L[XH [HS$ HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH H# HH HA`HHI`H9 uHAP0L# 3L[`H [Hs# HC`3H [H\$Hl$Ht$H|$ ATH H3k! HHu'H| ^ =   ( RO  H   Le 3L+eIMz   D  HE H+EHH;r HE# HHtqHFH9F ~HHNHHHHNHH" u6Hu
HCHP0HI;rHH\$0Hl$8Ht$@H|$HH A\c ZO  
W XO  H Hn =   Hۘ u
HFHP0HtHu
HSHR0L
 D8  H
' |3kH(Hy HQrHIH!# Hu9L
 D@2H
҂ P  Ǖ 2    P  L
* e|3H(H\$Hl$Ht$H|$ ATAUAVH L3g HHu'Hx Z =   $ zP  H >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;r IL$H:HH}   HGH9G ~HHOHHHHOHH  uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\# P  
 P  HP H. =   H u
HGHP0HtHu
HSHR0L
s D Ɯ H
 z3gHL$SWHXHD$ HHD$x    h D$x   HKH  H;t9 u/L$   H$   H}  x5H$   L$   LCL$   MtHS(HQ  Hu>L
= L
      P  P  A   H
 yH'HL$( HH& HL$( HHX_[H\$Hl$VWATH H3 HHu'H  =   P }T  H    Le 3L+eIMtxHE H+EHH;r HEL$H HHtiHFH9F ~HHNHHHHNHH u.Hu
HCHP0HI;rHH\$@Hl$PH A\_^ T  
 T  H H =   H u
HFHP0HtHu
HSHR0L
 Dn < H
 x3sH\$Hl$Ht$H|$ ATAUAVH L3 HHu'H( 
 =   ԙ T  Hm >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;r7 IL$HHH}   HGH9G ~HHOHHHHOHHS uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\Ә T  
ǘ T  H  Hޏ =   HK u
HGHP0HtHu
HSHR0L
# D v H
_ Jv3gHAH HAHA H HA HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _H H HA0HHI0H9 uHAP0Hn HC0H\$03H _HA8H HA8HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _H H HA@HHI@H9 uHAP0H HC@H\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _H H HAPHHIPH9 uHAP0H HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _H` H HAXHHIXH9 uHAP0H> HCXH\$03H _HA`H HA`HAH HAH\$WH HHHt,HHAHHIH9 uHAP0H{3H\$0H _H H HAHHIH9 uHAP0Hn HCH\$03H _HA H HA HA(H HA(H\$WH HHHt,HHA(HHI(H9 uHAP0H{(3H\$0H _H H HA(HHI(H9 uHAP0H HC(H\$03H _HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _H H HA0HHI0H9 uHAP0H HC0H\$03H _HA8H HA8H\$WH HHHt,HHA8HHI8H9 uHAP0H{83H\$0H _H` H HA8HHI8H9 uHAP0H> HC8H\$03H _HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _H H HA@HHI@H9 uHAP0H HC@H\$03H _HAHH HAHH\$WH HHHt,HHAHHHIHH9 uHAP0H{H3H\$0H _H  H HAHHHIHH9 uHAP0H HCHH\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _HP H HAPHHIPH9 uHAP0H. HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _H H HAXHHIXH9 uHAP0H~ HCXH\$03H _HA`H HA`H\$WH HHHt,HHA`HHI`H9 uHAP0H{`3H\$0H _H H HA`HHI`H9 uHAP0H HC`H\$03H _H(H
 FH Hu*H      }Z  H" H(H
 nFH Hu*H } y  G ~Z  H H(H
1 ,FHm Hu*HI ; <   Z  H H(H
 EHC Hu*H  D  Í Z  H\ H(H
 EH	 Hu*H     Z  H H(H
c fEH Hu|    F Z  ZH
Ŋ 8EH HuN *   Z  ,H
g 
EH# Hu*     Z  H H| H(3H(@SH H=  H H tfH{ { HKtHE3H { t HH HKHHKH9 t9H	 t+H(H{ u3l
 H Hu [  P [  D   =
 H Hu [  !   
 H Hu+̋ [  H     HT H [3H [H\$Ht$WH H=z H) y E   Y [  A  3H5bH| H9] uH H;u HDH H
 H4} L y) E    [    H=7 H= H y    [    H H9l uH H; HDH H
z H| L: y   b [  J  H5 H= H
 yd f   . [    H H=`H9d uH H;L HDH H5R H5 H
 y  i   ʉ [     H H9 uH H;
 HDH H5 H5 H=
 y   m [  XH H9	 uH4	 H;
 HDH"	 H5 H5
 H	 y5I    [  H< H H\$0Ht$8H _H
 H9
 uHK
 H;
 HDH9
 H\$0H55 Ht$83H _H(Hz H
z E3Ah  H Hu*H  	   Y [  H H(E3Hz H
z EA`蠂HQ HuF     [     Hlz H
qz E3AH
  _H Hu    χ [     HCz H
Hz E3A0  H߇ Hu~     [  xE3Hz H
z EAPH Hu~    R [  <Hy H
y E3A   褁Hu Hu*J~ h   [  HE H H(3H(H\$VH LAHHI@hH  Hx   HH|$8臅HHuY	 HtNH	 HH` t% LCH
	 M@H	H{  3H|$8H\$@H ^HF3Hl$0H;S uNHxHHFHH;VˋH   HFHl$0H|$8HHHH\$@H ^H; uKHxHHFHH;VˋH   H\Hl$0H|$8HHH\$@H ^HhhHt}H9]twHyQHE HtHHHx$HHHUHl$0H|$8HH\$@H ^H
m H	d tWb HHUHl$0H|$8HH\$@H ^H HHtHH, HHu
HGHP0Hl$0H|$8HH\$@H ^H
 M@Hy H		 H\$@3H ^HAH@pHtH@HtHH(HALHty u
IIH(HH(@SH HBIH; toH; tfH;r t]H; u:HX HT$8Ht=W uH [LHH
  ;HH [LHH
 LH [I HHDH H [H\$WH 3ALH;uAËH\$0H _H DH9AAH9BA   MAL;BtËH\$0H _B A8A uIuËH\$0H _AIB;t
tuII H a	 uËH\$0H _ÅËH\$0H _L M;hI;ЋAWDI HHuH\$0H _HHu
HSHR0H\$0H _H\$UH H H(H]HH   H L I;tMHCH; t$      t
   rIH 
3HebuH\$@H ]3Ht$0HuPH|$8H}XHEHHEPHEXHu
HCHP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$83H\$@H ]@SH HHt0HuHAP0H
 HWv LH	+ H [H [H\$Hl$Ht$H|$ ATAUAVH ILAHIhhLH  H}  	  39\$pu3Mt+I	H;
^ t?HHuP H  H9\$xu?HD$`Ht+HH;
  tHHu H  
H9$   toHˋHt[HE HtRIHx*HyHHHHy7Hy2LHIHU i  H
 H	 O   LHIU :  MhpM  I}   Ld$hMt	I<$   3HMtI9'9\$ptH HHH   H= HD$`HtH @9l$xt3H HHu)H   H   HCHP0   H L HHy HHtHu
HSHR0HtHE u
HEHP0HtBHIAUHMuHu
HWHR0HH
` M@H
v H	 3H\$@Hl$HHt$PH|$XH A^A]A\H8MLHuH
Z  Hu H	
 3H8Et)H; u-HAH;
 t	H; u   H8HI^uIBLJHu HHMHL$ H
  H	 3H8H\$Hl$Ht$WH Hj3HH~WHrLI;tbHCH;
 t$      t
   rIH
 
3H]u#HHH;|3H\$0Hl$8Ht$@H _ø   HIHH;u   Hu3HB   s6HAH;s
 t      t
   rH%\
 L32]H(HA   sAH(sEHAHHw,HY( H3H(ËAH(ËAH(H(H%
 H\$0yHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAx&H(sTHQHHtAHt3HHyH
X
 Ht H	8  H(H(H%
 AH(3H(H\$0xHHu
H\$0H(HH|$ ZHu
HSHR0H\$0H|$ H(H(HA   sAH(sEHAHHw,H	 H3H(ËAH(ËAH(H(H%	
 H\$0/xHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f	 	 	 z	 s	 	 	 	 	 H(HA   sAH(sEHAHHw,H
 H3H(ËAH(ËAH(H(H%
 H\$0?wHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f|
 |
 |
 j
 c
 t
 |
 |
 |
 H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%)
 H\$0OvHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(fl l l Z S d l l l H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%9
 H\$0_uHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f\ \ \ J C T \ \ \ H(HA   sAH(sEHAHHw,H
 H3H(ËAH(ËAH(H(H%I
 H\$0otHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(fL
 L
 L
 :
 3
 D
 L
 L
 L
 H(HA   s
HcAx(H(siHQHHtVHtHHt0Hy H
 Hq H	
 HH(H(H%A
 AIHHH(ËAH(3H(H\$0VsHHuHH\$0H(HH|$ CHHu
HSHR0H\$0HH|$ H(H\$Ht$WH@IIH
 HHuH\$PHt$XH@_H$   LLHD$0HD$xHHD$(HD$pHD$ jH\$PHt$XH@_33333333AVHPHD$ H\$`Hl$hHt$pH|$x)t$@AAfnf(m	 ~	 D,G  l+;ttC-  H$   H$   H
 H9 H虸 IcHL$(k
 L3HuH
HHcHHISAH
 HH Q Hȋ
    HL$(
 LH H$ HHt
H HcxHIVHAfnY- ^,Ho
 HH ط H H $    HEH趷 H$   H
 H
 H
 H$   F
 H$   H\$`Hl$hHt$pH|$x(t$@HPA^H%
 H(H @ Hq
 HH(H%k
 @SH H7S H H H H& H Hs H
 H
 H
 HR H辶 Hg H诶 H& H蠶 H)r H
 H
 H
 HR Hq H2 Hb HG& HS H<s Hs
 Ht
 HH [H%m
 HtzH\$Ht$WH HH AH HH
 DD+^A}H
 H
 D[E~Af H HuH\$0Ht$8H _H%  WHPHD$ H\$`Hl$hHt$pIIH   D4HHx
 HHv
 x
 H}    HU HL$(
 H H HHT$(-
 +\$@}H%
 H$
    ~ H HuHL$(
 H H豴 HH
 HH{ 薴 HH
 
 H
 H
 H\$`Hl$hHt$pHP_HWHP  HD$ HXHhHpIIHH   DBHL$P
 H HL$` HH"
 H v,H HL$`ڳ HH
 HH 迳 HT$(HL$P
 L$  LHHHL$(L
 HL$P
 L$P  I[IkIs I_HWH   HǄ$  HXHpH   DBH
 HHPHH H$0   Hȋ
 HH  HH H$   H$   
 Hё    H H$   D
 A   H HL$`
 LL L\$`L( H$   HL$ 
 HL$   H$   
 HL HL$x
 H$   
 HL$ 
 H HL$`a	 HT    H% HL$ 
 HZ HL$`
 L L\$`Lt H$   H$   &
 HLD$ H$   
 HL6 HL$x
 H$   5
 H$   '
 H HL$`誴	 Hݐ    H~ HL$ 
 H3 H$0  H$0  HL$`0
 L L\$`L H$   H$   _
 HLD$ H$   Q
 HLo HL$x4
 H$   n
 H$   `
 Hɂ HL$`	 HV    H HL$ 
 H HL$`
 Lr L\$`L H$   H$   
 HLD$ H$   
 HL HL$x}
 H$   
 H$   
 H HL$`,	 Hߏ tJHL$ 
 H HD$ H$   HL$8h
 H HD$ HT HL$ ֲ	 Hɏ tJHL$ Z
 Hj HD$ H$   HL$8
 Hz HD$ H HL$ 耲	 H賏 tJHL$ 
 H HD$ H$   HL$8
 H< HD$ H~ HL$ *	 H蝏 tJHL$ 
 H HD$ H$   HL$8f
 H HD$ HJ~ HL$ Ա	 H臏 t>HL$`X
 Hh HD$`H$   HL$x
 Hh~ HL$`花	 H} tJHL$ 
 H HD$ H$   HL$8
 H HD$ H HL$ 4	 Hg tJHL$ 
 Hp HD$ H$   HL$8p
 H HD$ Hd HL$ ް	 HQ tJHL$ b
 H HD$ H$   HL$8
 H* HD$ H~ HL$ 舰	 H; t>HL$`
 H HD$`H$   HL$x
 H$~ HL$`>	 HB HL$ w
 HL$`
 L L\$`Lh H$   H$   
 HLD$ H$   
 HL* HL$x
 H$   )
 H$   
 H} HL$`螯	 {kH\$Hl$Ht$H|$ ATH H` HH
Mg E3=HHuH
   H   H
f HxHH5Dc L%_ H-v` @
 HHt{HykH_HGH3GpHG@HGHHG HG(HG0HG8Gt MtI$LgXHtHE HoPHtHHHw`HGh
 Hu
HCHP0HG  L
9 H
 Ai   e ] i   L
_ CHu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH HN_ H\$0HH
e E3Ht$8H|$@
E3HHu2H-C
 }\ f   Ge   HE Hl H^   HXHH
r_ HAL   MtHk_ AH,L@@MtHS_ H AHH@_ 
 HHu'H [ h   d   HP^   H
 IH9C   H{H   HsHHHHHuHAP0HHR"HHu'H
 u[ h   ?d   H
]    Hu
HGHP0IHu
HCHP0HIHuHHuXH" [ i   c   Hw] jH
#HHuH Z h   c   HC] 6HYPHH   H Z i   rc   H] HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
\ DJZ c H
a @&Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\HHHATAUH8HXHhHp HxLpE3LxHBLMIH;r
 t|H;q
 tsHHZ
 HHu'Hk ]Y m   'b #  H[ =  H@L   Mu3H4 &Y m   a %  H[   HHIMHl MuFH
 H9GuH;w3  HGHH\HH,H;w  H] HHHHAHH   ILHt
HuHQR0IFHHpHtHAHt
HIHHI=HHtVHL$PLI,
 tH5HCHP0&H X n   ` R  HtZ    H W n   ` P  HMZ    
 HtH~
 HHKBtb
 Hu
HGHP0L-R
 IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\HN @W m   
` @  HY Hu
HGHP0HtHu
HCHP0L
wY DV _ H
s =S+iH(IL$0
 Hu9L
 D@PH
   V P   __   L
X 3=3H(H\$WH HH؃uO
 HtDL
B DCQH
 
  $V P   ^ 
  L
X <H\$0H _É_H\$03H _j[k+lkmH(A(i
 Hu9L
 D@TH
Z b  gU T   1^ b  L
W <3H(n+pH(AH
 Hu9L
 D@XH
   T X   ]   L
JW ;3H(+rtHAVHp  E3HXHhHpHxL`LhLxLMILt$8Lt$HILt$ Lt$@MLt$(G
 Hu'H; -T    \   HV pH  HHD$0
 Hu'H S    \   HVV 6H  A$HHD$8$  x
 HHu*H S    u\   HV IG  H

 HGHHu'Hx jS    4\   HU F  Hu
HCHP0H[ LH
 y'H* S    [   HU F  Hu
HGHP0AL$$  
 HHu'Hٷ R    [   H.U SF  HJU LH>
 y'H R    W[ !  HT F  Hu
HGHP0IL$QHHu'HR DR    [ +  HT E  HT LH
 y'H R    Z -  HiT E  Hu
HGHP0A$   
 HHu'HŶ Q    Z 7  HT ?E  H~V LH*
 y'H yQ    CZ 9  HS E  Hu
HGHP0A$   ZHHu'H: ,Q    Y C  HS D  HY LH
 y'H P    Y E  HQS vD  Hu
HGHP0A$   YHHu'H P    kY O  HS )D  H@Q LH
 y'Hq cP    -Y Q  HR C  Hu
HGHP0IA8$      I$   HHu'H P    X e  HiR C  HT LHy
 y'Hִ O    X g  H+R PC  Hu
HGHP0IE8$     I$   xHHu'Hy kO    5X   HQ B  HR LH
 y'H; -O    W   HQ B  Hu
HGHP0IH
aO |HHu'H N    W   HBQ RB  A$   $  
 LHu'H
 N    eW   H
P B  H
 HkLt$(H9E z  HSHT$(Hh  HsHHHHHuHAP0HT$(H<
 HnH9E    E3H$   H$   EAHL$   oHHu'H M    V   HEP UA  HL$(HuHAP0IE Lt$(u
IEIP0Ht$8M      
 LHu'H
 sM    =V   H
O @  HL$(Lh E3HHHHLt$(MHHu'H/ !M    U   HO @  Iu
IGIP0Ht$8MNIHHHu'H۱ L    U   H0O @@  IE u
IEIP0MHu
HE HP0H
L HH|$HHHu'Ht fL    0U   HN ?  H@L   MtHR HAH2L@@MtHR HH AHHR H{
 HHu'H K    T   HIN n?  Hu
HGHP0A   HH

 HHu'H K    _T   HM ?  Hu
HCHP0H{Q؅y'H^ PK    T   HM >  Hu
HGHP0I^  HEL   MtHDM HAH2L@@MtH)M HH AHHM HJ
 HHu/Hï Hl$0J    HM sS   I>  Hl$0HN LH
 y'Hx jJ    4S   HL =  Hu
HGHP0A$   $   ;
 HHu'H$ J    R   HyL =  HJ LH
 y'H I    R   H;L `=  Hu
HGHP0A$,  L$p
 HHu'H I    QR   HK =  HI LH
 y'HW II    R   HK <  Hu
HGHP0A$0  $   
 HHu'H H    Q   HXK }<  HO LHh
 y'Hŭ H    Q 
  HK ?<  Hu
HGHP0A$$  $   
 HHu'Hq cH    -Q   HJ ;  HP LH
 y'H3 %H    P   HJ ;  Hu
HGHP0L<
 HM H
 y*H G    P #  H6J I;  A$@  PHHu'H G    ]P ,  HI ;  HRL LH
 y'Hc UG    P .  HI :  Hu
HGHP0A$H  
 HHu'H G    O 8  HiI :  HeJ LHy
 y'H֫ F    O :  H+I P:  Hu
HGHP0A$P  n
 HHu'H yF    CO D  HH :  HXG LH
 y'HI ;F    O F  HH 9  Hu
HGHP0A$X  
 HHu'H E    N P  HOH t9  HSI LH_
 y'H E    xN R  HH 69  Hu
HGHP0A$`  $   '
 HHu'Hh ZE    $N \  HG 8  HE LH
 y'H* E    M ^  HG 8  Hu
HGHP0A$d  $   
 HHu'H֩ D    M h  H+G P8  H?J LH;
 y'H D    TM j  HF 8  Hu
HGHP0A$h  $   
 HHu'HD 6D     M t  HF 7  HK LH
 y'H C    L v  H[F 7  Hu
HGHP0A$p  
 HHu'H C    sL   HF 17  HJ LH
 y'Hy kC    5L   HE 6  Hu
HGHP0A$  
 HHu'H* C    K   HE 6  H#E LH
 y'H B    K   HAE f6  Hu
HGHP0A$  
 HHu'H B    YK   HD 6  HC LH
 y'H_ QB    K   HD 5  Hu
HGHP0H
D IHHu'H B    J   HfD v5  A$(  $   
 LHu'Hͦ A    J   H"D 25  H
 HkMH9E b  LkMU  HsIE HHHHuHAP0Hk
 HnH9E    E3H$   HEAL$   L$(  HHu'H A    I   HtC 4  IE u
IEIP0IMu
IGIP0M      
 HD$(Hu'H @    sI   HC 4  LhLx E3HHMM+HHu'Hl ^@    (I   HB 3  HL$(HuHAP0Lt$(MIHHHu'H @    H   HnB ~3  Iu
IGIP0MHu
HE HP0HGL   MtHA HAH2L@@MtHA HH AHHA H
 HHu'Hv h?    2H   HA 2  Hu
HGHP0Hl$0HB LHI
 y'H  ?    G   HuA 2  HHH\$ HHu
HCHP0H
DA WHHu'Hȣ >    G   HA -2  H@L   MtHB HAH2L@@MtHA HH AHHA H
 HHu'HH :>    G   H@ 1  Hu
HCHP0A   HH^
 HHu'H =    F   HL@ \1  Hu
HGHP0HICy'H =    kF   H@ 1  Hu
HCHP0   A$  L$hm
 HHu'HV H=    F   H? 0  H> HL$8L
 y'H =    E   Hk? {0  H  HCHP0Ht$   H
9? L	HHu'H <    yE 
  H? "0  H@L   MtHD HAH2L@@MtH{D HH AHHeD H
 HHu'H= /<    D   H> /  Hu
HCHP0HL$ A   HQ
 HHu'H ;    D   H?> O/  Hu
HGHP0HIAy'H ;    ^D   H= /  Hu
HCHP0   A$  2
 HHu'HK =;    D   H= .  H|> HL$8L
 y'H :    C !  H`= p.  H}  HCHP0Ht$ u  H
.= AHHu'H :    nC 5  H= .  H@L   MtHk: HAH2L@@MtHP: HH AHH:: H
 HHu'H2 $:    B 7  H< -  Hu
HCHP0Ht$ A   HHC
 HHu'Hܞ 9    B :  H1< A-  Hu
HGHP0HI?y'H 9    RB <  H; ,  HuHCHP0Ht$ Ht$ H
; HHu'H= /9    A T  H; ,  H@L   MtH8 HAH2L@@MtH8 HH AHH8 HD
 HHu'H 8    yA V  H; ",  Hu
HCHP0A   HH
 HHu'Hl ^8    (A Y  H: +  Hu
HGHP0HIA>y'H$ 8    @ [  Hy: +  Hu
HCHP0
  H
8 `HHu'Hќ 7    @ f  H&: K+  A$x  $   
 HHD$(Hu'H z7    D@ h  H9 +  H
 HwMH9_  LMR  H_IHHHHuHAP0H(
 HsH9   E3H$   HEAL$   H$  \HHu'Hݛ 6    ? |  H29 B*  Iu
IGIP0HE Mu
HEHP0Lt$(      
 LHu'Hu g6    1?   H8 )  LxE3HHMHh Lt$(HHu'H( 6    >   H}8 )  IE u
IEIP0MPHHHHu'Hؚ 5    > u  H-8 =)  HE u
HEHP0Lt$(Hu	HHP0HCL   MtH7 HAH2L@@MtH7 HH AHH7 H
 HHu'H3 %5    =   H7 (  Hu
HCHP0H
5 HH|$@oHHu'H 4    =   H57 Z(  H@L   MtHy8 HAH2L@@MtH^8 HH AHHH8 H
 HHu'H` R4    =   H6 '  Hu
HGHP0A   HHv
 HHu'H 4    <   Hd6 t'  Hu
HCHP0H9؅y'Hʘ 3    <   H6 D'  Hu
HGHP0I;  L: H	; HL$8
 y1Hk Hl$0Ht$ H5 L3    <   '  Hl$0H6 H,
 HHu'H 3    ;   Hr5 &  H4 H]
 HHu'Hޗ 2    ;   H35 C&  Hu
HGHP0HG6 LHI0
 y'H 2    I;   H4 %  HU  HCHP0F  H
3 HHu'H9 +2    :   H4 %  H@L   MtH5 HAH2L@@MtH5 HH AHHi5 H@
 HHu'H 1    u:   H4 %  Hu
HCHP0A   HHϻ
 HHu'Hh Z1    $:   H3 $  Hu
HGHP0HI=7y'H  1    9   Hu3 $  Hu
HCHP08  L4 Hb8 HL$8g
 y1Hĕ Hl$0Ht$ H#3 0    o9   _$  Hl$0H.4 H
 HHu'Hv h0    29   H2 #  Hw8 H
 HHu'H7 )0    8   H2 #  Hu
HCHP0H3 LH
 y'H /    8   H>2 c#  H  HGHP0  H
q0 $HHu'H /    Q8 
  H1 #  H@L   MtH6 HAH2L@@MtH6 HH AHH6 H
 HHu'H /    7   Hj1 "  Hu
HGHP0A   HH+
 HHu'Hē .    7   H1 )"  Hu
HCHP0H4؅y'H q.    ;7   H0 !  Hu
HGHP04  L5 H5 HL$8Ƹ
 y1H# Hl$0Ht$ H0 .    6   !  Hl$0H1 H
 HHu'HՒ -    6 (  H*0 O!  H5 H
 HHu'H -    R6 *  H/    Hu
HGHP0H0 LHI
 y'HE 7-    6 -  H/    HuHCHP0Hl$0LD$8H/ H
 !  H Ht$ ,    HD/ 5 J     H
- 9HHu'H ,    f5 ]  H.    H@L   MtH4 HAH2L@@MtH4 HH AHH4 H
 HHu'H* ,    4 _  H.   Hu
HCHP0A   HH@
 HHu'Hِ +    4 b  H.. >  Hu
HGHP0HI1y'H +    M4 d  H-   Hu
HCHP0,	  HEL   MtHz- HAH2L@@MtH_- HH AHHI- H
 HHu/H Hl$0*    HS- 3 o  H  Hl$0H. LHQ
 y'H *    j3 q  H-   Hu
HCHP0A$   L$xt
 HHu'H] O*    3 {  H,   H+ LH´
 y'H *    2 }  Ht,   Hu
HCHP0A$(  $   
 HHu'Hˎ )    2   H , 0  H\+ LH0
 y'H )    I2   H+   Hu
HCHP0A$,  $   P
 HHu'H9 +)    1   H+   H( LH
 y'H (    1   HP+ `  Hu
HCHP0A$0  $   
 HHu'H (    c1   H*   H0 LH
 y'Hi [(    %1   H*   Hu
HCHP0A$4  $   ,
 HHu'H (    0   Hj* z  H6( LHz
 y'H׌ '    0   H,* <  Hu
HCHP0A$8  o
 HHu'H z'    D0   H)   H!- LH
 y'HJ <'    0   H)   Hu
HCHP0A$@  /HHu'H &    /   HR) b  H+ LHb
 y'H &    {/   H) $  Hu
HCHP0A$D  L$P
 HHu'Hn `&    */   H(   H( LHӰ
 y'H0 "&    .   H(   Hu
HCHP0A$H  Ȳ
 HHu'H %    .   H6( F  H+ LHF
 y'H %    _.   H'   Hu
HCHP0H
& HHu'HX J%    .   H'   A$$  $   +
 LHu'H %    -   Hi'   H
 HwLt$(H9e  HoHl$(HS  H_HE HHHHuHAP0H
 HsH9   E3H$  HEAH$  L$  HHu'Ha S$    -   H&   HE u
HEHP0IE Lt$(u
IEIP0M      G
 LHu'H #    , 
  HM& r  Lh E3HHHhLt$(MjHHu'H #    g,   H &   Iu
IGIP0MNIH+HHu'H\ N#    ,   H%   IE u
IEIP0MHu	HHP0HCIHL   H\$ MtH/% HAH2L@@MtH% HH AHH$ H5
 HHu,H Hl$0"    H% ^+ #    Hl$0H* LH	
 y'Hf X"    "+ %  H$   H  HCHP0  H
" HHu'H "    * 9  Hg$ w  H@L   MtH' HAH2L@@MtH' HH AHHr' H
 HHu'H !    N* ;  H#   Hu
HCHP0A   HH
 HHu'HA 3!    ) >  H#   Hu
HGHP0HI'y'H      ) @  HN# ^  Hu
HCHP0D  HEL   MtH" HAH2L@@MtH" HH AHH" H
 HHu/Ha Hl$0N     H" ) K  Hb  Hl$0HU$ LH
 y'H      ( M  Hk" {  Hu
HCHP0A$   $   ٩
 HHu'H     ~( W  H" '  H{  LH'
 y'H v    @( Y  H!   Hu
HCHP0A$$  L$XJ
 HHu'H3 %    ' c  H!   H& LH
 y'H     ' e  HJ! Z  Hu
HCHP0A$,  'HHu'H     d' o  H  
  H% LH
 y'Hj \    &' q  H    Hu
HCHP0H
c$ HHu'H     & {  Ht    A$(  L$`
 LHu'Hނ     & }  H3  X  Hߧ
 HwMH9h  LoM[  H_IE HHHHuHAP0H}
 HsH9   E3H$0  HEAL$0  L$8  HHu'H2 $    %   H   IE u
IEIP0IMu
IGIP0M      
 HHD$(Hu'Hǁ     %   H A  LhLx E3HHMM;HHu'H| n    8%   H   HE u
HEHP0Hl$0Lt$(MIHHHu'H%     $   Hz   Iu
IGIP0MHu	HHP0HCIHL   H\$ MtH HAH2L@@MtH HH AHH H
 HHu'Hx j    4$   H   HY# LHݥ
 y'H: ,    #   H   Hu
HCHP0H
3! ~HHu'H     #   HD T  H@L   MtH  HAH2L@@MtHm  HH AHHW  H
 HHu'Ho a    +#   H 
  Hu
HCHP0A   HH
 HHu'H     "   Hs 
  Hu
HGHP0HIy'H~     "   H+ ;
  Hu
HCHP09  H
 HHu'H~ u    ?"   H   H@L   MtH  HAH2L@@MtH  HH AHHs  H
 HHu'H~     !   HX h  Hu
HCHP0HL$ A   H
 HHu'H}     l!   H   Hu
HGHP0HIy'Hh} Z    $!   H   Hu
HCHP0  A$0  
 HHu'H}         Hf v  HR LHv
 y'H|         H( 8  Hu
HCHP0A$H  k
 HHu'H| v    @    H 
  H LH
 y'HF| 8        H 
  Hu
HCHP0A$8  ޣ
 HHu'H{        HL \
  H LH\
 y'H{     u   H 
  Hu
HCHP0A$@  Q
 HHu'Hj{ \    & 
  H 	  H LHϠ
 y'H,{        H 	  Hu
HCHP0A$8  Ģ
 HHu'Hz        H2 B	  H LHB
 y'Hz     [   H 	  Hu
HCHP0A$@  7
 HHu'HPz B     %  H   H LH
 y'Hz      '  Hg w  Hu
HCHP0A$@  
 HHu'Hy      1  H (  H4 LH(
 y'Hy w    A 3  H   H  HCHP0Ht$   H
p HHu'H,y      G  H   H@L   MtH HAH2L@@MtH HH AHH H3
 HHu'Hx     h I  H   Hu
HCHP0HL$ A   H
 HHu'HYx K     L  H   Hu
HGHP0HI.y'Hx      N  Hf v  Hu
HCHP0f  A$0  
 HHu'Hw     v Y  H   H LH
 y'H|w n    8 [  H   Hu
HCHP0A$H  
 HHu'H-w      e  H   H> LH
 y'Hv      g  HD T  Hu
HCHP0A$8  
 HHu'Hv     \ q  H   H LH
 y'Hbv T     s  H   Hu
HCHP0A$@  
 HHu'Hv      }  Hh x  H\ LHx
 y'Hu        H* :  Hu
HCHP0A$8  m
 HHu'Hu x    B   H   H LH
 y'HHu :       H   Hu
HCHP0A$@  
 HHu'Ht        HN ^  H LH^
 y'Ht     w   H    H  HCHP0Ht$ $  H
 HHu'Hbt T       H   H@L   MtHs HAH2L@@MtHX HH AHHB Hi
 HHu'Hs        H7 G  Hu
HCHP0A   HH
 HHu'Hs     M   H   Hu
HGHP0HIfy'HIs ;       H   Hu
HCHP0  Hl$0L% H& H
 y*Hr 
       H? H  L
 H HH
 y*Hr 
    a   H H  A$   J
 HHu'Hcr U
       H    Ht$8H LH×
 y'H r 
       Hu    Hu
HCHP0A$(  
 HHu$Hq        H& 9H LH9
 yzHq     R   H HtHu
HCHP0HtHu
HGHP0Hl$0Ht$ 
Hl$0Ht$ Mt_IE uXIEIP0LHu
HCHP0H$ LH
 y}Hp        HJ HHL$(Ht
HuHAP0MtIu
IGIP0L
 D g H
 ;7Hl$0H&H!Ht$ Ht$ Ht$ Ht$ Ht$ HE LL$@  L$H  L$P  H$X  H$  HtHE u
HEHP0HL$8H$h  Ht
HuHAP0HL$HHt
HuHAP0HtHu
HFHP0HD$@H$`  HtH u
HPHR0IHp  A^+H\$Hl$Ht$H|$ ATH H HH
 E3-HHuH
 %  H   H
 HxHH5 L% H- 
 HHt{H9.H_HGH3GpHG@HGHHG HG(HG0HG8Gt MtI$LgXHtHE HoPHtHHHw`HGh:
 Hu
HCHP0HG%  L
yn H
 A  6 X	   L
  Hu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH H H\$0HH
/ E3Ht$8H|$@譽E3HHu2H-
     &  HE Hm H   HXHH
 HAL   MtH AH,L@@MtH H AHH 
 HHu'H;m -    #&  H
   H<
 IH9C   H{H   HsHHHHHuHAP0HHHHu'H
l     0&  H

    Hu
HGHP0IHu
HCHP0HIHuHHuXHbl T    B&  H	 jHMHHuH.l      3&  H	 6HHH   Hk     D&  HK	 HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
	 D X H
 ,&Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\HHHATAUH8HXHhHp HxLpE3LxHBLMIH;
 t|H;
 tsHH
 HHu'Hj    g &  H  =  H@L   Mu3Htj f   0 &  H   HHIMHl MuFH
 H9GuH;w3  HGHH\HH,H;w  H] HHHHAHH   ILHt
HuHQR0IFHHpHtHAHt
HIHHI}HHtVHL$PLIl
 tH5HCHP0&H_i Q   
 &  H    H8i *    &  H    ҏ
 HtH
 HHtb
 Hu
HGHP0L-
 IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\Hh    J &  H Hu
HGHP0HtHu
HCHP0L
 D< 
 H
 S+HHPHHAUH   HHXE3HhHpHxL`LpLxMHIIML$   MH;q
 >  3
 HHu'Hg    X '  H *
  HM H;
)
 u>H
8
 H
 H	8
 LQg C   L  (  L  H $
 HHu'H
g    
 (  H
j   H@H;ʌ
    H;Ō
 t~HI
 HHu*H
f    {
 (  H
 M  H@H   Hl$ Hu8Hf r   <
 
(  H Mx  HHILl$ Hu
HGHP0JLH$   H$   HuUH
 H9Cu'L;s4  HCIJ|HHH$   2L;s
  H9IHHH$   HHH  ILHt
HuHAP0Hv H$   IL;bH
 AEH9BI9GADtUMGL;B   B IO 8   IAGDJA;tt
A   H ~Q	 A^Lŋ
 AM;ucI;AAuUA   I;
 HH   HHE Du
HUHR0Hl$ Ex[H$   EMuHNH9N ~ IHFL<HAH$   HFKIHg
 u:H$   .E3HLd >    1(  H MD	  H"d     3(  Hw M	  
 HtH
 HHrt?Љ
 Hu
HCHP0H$   H$   HJ  HAP0M>  Hc    T )(  H  M  H- H
/ H&
 HHtH HHHu'H:c ,    K(  H  5  H$   Hq
 u'Hb     M(  HP    Hu
HFHP0tf   
 HHu'Hb    i Y(  H    H$   H$   HH@HHuHAP0MH= H
 H
 HHtH HHHu*H&b     r(  H{ IZ  HCL   MtHT HAH2L@@MtH9 HH AHH# H*
 HHu*Ha    _ t(  H I  Hu
HCHP0HGL   MtHY HAH2L@@MtH> HH AHH( H
 HHu'Ha     w(  He    Hu
HGHP0H$   HN H;
 uAH
 H]
 H	
 L`    L b |(  I  H[ }
 HHu'Hn` `   * ~(  H ~  HN H;
 u>H

 H
 H	

 L#`    L  (  3  H  
 LHu'H
_     (  H
<   H
 IL$   AH9Cu4HkH$   Ht#HCHE HH HHuHAP0   Hy
 H9C   H$   HT$HDFHD$HHcE3HHHl$@H+H|$PLt$X蝼HHu'H_     (  Hs   HtHE u
HEHP0HIL$   u
HGHP0IIu
IFIP0M   FHc
 LHu'H
^    S (  H
   HtHhL$   IH$   HcE3HILI| Mt(HIIMHHu'H#^     (  Hx   I$uID$IP0MHu
HCHP0H$   H$   HuHAP0H
  5HHu'H]    b (  H   H@L   MtHw HAL2L@@MtH\ HH ALHF H
 LMu'H&]      (  H{ ]  Hu
HCHP0ID$L   MtH~  IAH2L@@MtHc  IH AHHM  I
 HHu'H\    Q  (  H   I$uID$IP0H
 MAH9Cu,LcMt#HCI$HH HHuHAP0   H%
 H9C   H$   HT$0DEHD$0HcE3HHLd$(H+Ht$8NHHu'H[     (  H$    M  I${  ID$IP0k  EHc
 LHu/Hp[ H$   Z   H  (     MtL`MH$   HcE3HILHHIIt úHH   H [     (  HU HtHu
HFHP0HtHu
HGHP0H$   H$   HtHu
HCHP0MtIu
IFIP0HtHE u
HEHP0MtI$uID$IP0L
 D@  H
'
 #Iu
IFIP0Hu
HCHP0LLt$pLd$xH$   H$   H$   H$   MtIu
IGIP0H$   L|$hHtH u
HPHR0IHĠ   A]H\$Hl$VWATH@H/
 HzILH\$pHM   HtH   HZH\$pIc
 HHu)H  H H
 HtHHD$pHH   HB
 LL$pH HD$(E3HH|$ yy
>)     H\$p   H   H   Hy3L
(
    L
*
 HH
 H|$0H
 L
 HDH
 HD$(HL$ H
(
 H	_
 L)  L
CX H
 A    "   L
 3HZHI!H\$`Hl$hH@A\_^HLH L@HPHHAVH  HE3HhHpHxL`LhHAIL   ILL$   L$   L$   Lt$PLt$8L$   Lt$XL$   L$   Lt$pLt$`Lt$hL$   L$   Lt$xLt$0Lt$(IMtH AL+H@@HtH H LH b}
 LH$  L$  Mu'HV     ;*  H  K  H{
 MI9D$   M|$M   I\$IIHHLuHAP0IHHHu*HPV B    H*  H HJ  Iu
IGIP0MI$uID$IP0HMu
HCHP0H
{
 AH;  H;A  H=u H
 H}~
 HHtCH II谸HHzHU    I K*  H HI  H2HHu*HSU E    l*  H HI  HCL   MtH HAL2L@@MtH HH ALHx HW{
 LMu*HT     n*  H% HAI  Hu
HCHP0H E3I;HHu*H|T n   8 q*  H HH  I$uID$IP0HMu
HCHP0Hz
 H$  H;   IM H;uGH
z
 H=
 H	|
 LS  "  LT  *  HLHH  H y
 HHu*HS  "  l *  H H!H  HH$  HH   HAP0   H
 ݺHHu*HNS @ #  
 *  H HG  HHz
 u*HS  #   *  Hf HG  Hu
HCHP0tc   w
 HHu*HR  $  | *  H H1G  HE H@HH(HHH$  uHAP0H
 LHu*H\R N %   *  H HF  H@L   MtH IAL2L@@MtHo IH ALHY I`x
 LMu*HQ  %   *  H. H_F  I$uID$IP0IGL   MtH IAL2L@@MtHr IH ALH\ Iw
 LMu0HDQ 6 %    *  HLHH E  Iu
IGIP0IM MH;
w
 uAH
w
 H
 H	y
 LP  %  L<  *  HcE  H v
 LHu*HP  %  Z *  H H$E  IM H;
(w
 uAH
7w
 H@
 H	7y
 LPP B %  L  *  HD  H&  v
 LHD$0Hu*H
P  %   *  H
a HD  H
u
 ILt$(AI9D$u7I|$H|$(Ht(ID$HIH HLuHAP0LL$0   Hu
 I9D$   L$X  HcH$H  HDCE3IH+H$@  H$H  L$P  趬HHu*H7O ) %   *  H HC  HtHu
HGHP0IILt$(u
IGIP0HL$0MHuHAP0Lt$0I   CHct
 HHu'H
N  %  f +  H
 3C  HtHxLt$(IH$  HcE3HHLHL$0HL(L| HIMLt$0HHu'H2N $ %   +  H B  HE u
HEHP0II$uID$IP0H$  MH$  H HuH@P0IM H;
vt
 u>H
t
 H
 H	v
 LM  '  L S &+  B  HO qs
 HHu'HbM T '   (+  H A  IM H;
s
 u>H
s
 HW
 H	u
 LM 	 '  Lv  ,+  A  H r
 LHu'HL  '   .+  H0 OA  HHt
 HHu'HL  '  \ 0+  H A  Hu
HCHP0I$uID$IP0H
 H$   IǳLHu'H8L * (   >+  H @  H@L   MtHi IAH2L@@MtHN IH AHH8 I?r
 HHu'HK  (  t @+  H
 A@  I$uID$IP0HCL   MtH_ HAL2L@@MtHD HH ALH. Hq
 LMu'H&K  (   C+  H{ ?  Hu
HCHP0Hp
 IAI9D$u-I\$Ht#ID$HIH HLuHAP0   Hp
 I9D$   H$  H$   H$  H$   H$  HcHDGE3IH+H$  ʧHHu'HKJ = (   U+  H >  HtHu
HCHP0I   GHcBp
 HD$0Hu'HI  (   c+  HF e>  HtHXIH$   HcH|$0HHLH$  HHL E3IH?HHu'HI r (  < n+  H =  Hu
HGHP0Lt$0I$uID$IP0HE u
HEHP0H
 I虰LHu'H
I  *   |+  H_ ~=  H@L   MtH; IAHHD$0<L@@MtH IH AHHD$0H  Io
 HHD$0Hu'H{H m *  7 ~+  H <  I$uID$IP0HGL   MtH HAL2L@@MtH HH ALH Hpn
 LMu'HG  *   +  H> ]<  Hu
HGHP0IM Lt$0H;
an
 u>H
pn
 H
 H	pp
 LG { *  L > +  ;  H: \m
 LHD$0Hu'HHG : *   +  H ;  H$   HO H;
m
 u>H
m
 H
 H	o
 LF  +  LT  +  i;  H l
 HHu'HF  +  u +  H -;  HO H;
Fm
 u>H
Um
 H&
 H	Uo
 LnF ` ,  L # +  :  H/ Al
 LHu'H2F $ ,   +  H :  H3k
 Lt$(AI9D$u3Il$Hl$(Ht$ID$HE IH HLuHAP0   Hk
 I9D$   H$  H$  DGH$  HcE3HIH$  H+L$  H$  L$  ֢HD$ Hu,HUE Hl$ B *  H  +  9  HtHE u
HEHP0IE ILt$(u
IEIP0HLt$0u
HCHP0IIu
IGIP0Hl$ M   GHc k
 HHu*H
D  *  m +  H
 I"9  Ht	HhLt$(H$  HcE3H\ L|(LlHHL0HILt$0IMHHu'H6D ( *   +  H 8  Hu
HFHP0H|$(II$uID$IP03H$   h
 HHD$ Hu'HC  /   +  H 8  L$   IM H;
Mj
 u>H
\j
 HU
 H	\l
 LuC g /  L * +  W8  H> Hi
 LHu'H9C + /   +  H 7  IM H;
i
 u>H
i
 H
 H	k
 LB  /  LM  +  w7  H h
 HHu'HB  /  n +  H ;7     h
 LHu'HxB j /  4 +  H 7  H
 L`E3HHp MHHu,H,B Ld$0 /  H  ,  6  Iu
IGIP0HFH;g
    H;g
    HIi
 LHD$@Hu,HA Ld$0 /  H h ,  i6  H@L   MuDH|A L|$@Ld$0H ] /  ' ,  (6  HHHt$@MMH|$@Hu
HFHP0I3NtMuEHf
 H9GuL;o  HGIJtHI+L;o  I6IHIHAHHW  HFHf
 H;   H;f
    Hzh
 LHD$0H  Hu
HFHP0ID$IHH   LH{  HL$0   HHc  Hl$0H׺   Hb  HE u
HEHP0H|$@3Hl$0?HNH  H;u
LfH^ HFL HXI$HHu
HFHP0HL$XILd$XHt
HuHAP0H$   LHH$   HtHu
HAP0HHHHf
 HHM  LD$ IHI9H ~H I@H4HAI@HI/f
    Hu
HFHP0HH? L|$@Hl$ Hg  /   U,  r3  HL$0HuHAP03HL$0p`uH4H> L|$@Hl$ H  /  X ],  3  H|> L|$@H|$(Hl$ H X /  " M,  #3  HF> L|$@H|$(Ld$0Hl$ H  /   f,  2  H> L|$@H|$(Ld$0Hl$ H`  /   d,  2  H~H
d
 H
 A   H	f
 
Hx(H= L|$@H|$(Ld$0Hl$ H x /  B 8,  C2  'd
 HtHf
 HHti>c
 Hu
HGHP0LD$ H$  E3MIL$   #ygH= H|$( 1  Hb  t,  1  H< L|$@H|$(Ld$0Hl$ H1  /  } ,,  ~1    H
 LHu1H< H|$(Ld$0H f 2  0 ~,  11  H@L   MtH IAH2L@@MtH IH AHH Ib
 HHu1H; H|$(Ld$0HZ  2   ,  0  Iu
IGIP0H`
 MH9F  L~M  H^IHHHHuHAP0IH8HHu1Hi; H|$(Ld$0H J 2   ,  0  Iu
IGIP0MHu
HFHP0H$  ILHAHl$PH;`
    H;`
    HH\$@b
 HHD$ HuvH: H|$(Ld$0H'  3  s ,  t/  H覝HH^H: H|$(Ld$0H d 2  . ,  //  H@H   H$   HuQH:: H|$(Ld$0H  3   ,  .  HIIHHL$ H\$@H$   fHuHH_
 H9EuH;]  HEH4HHH\$@-H;]h  HtHHH\$@HHH  HL$8HH\$8Ht
HuHAP03[^
 HH  L$   I@HHpHtHAHt
HILHI	VLM[  IGH;^
 t^H;^
 tUIH`
 HH  H@L   Mu5H8 Hl$  5  H1  ,  F-  IIIIu
IGIP03LlLMuFHc^
 H9CuH;kV  HCHL|II,H;k7  M} HIIHALH  HL$xL|$xHt
HuHAP0H
o L臟LH=  H@L   MtHL IALHD$0<L@@MtH, IH ALHD$0H I^
 LHD$0M  I$uID$IP0LL$0IAL   MtHa IAL2L@@MtHF IH ALH0 I]
 LM  HL$0HuHAP0H*\
 H|$0I9D$u5IT$HT$0Ht&ID$HIH HLuHAP0   HH\
 I9D$u|HD$xH|$0DAH$0  H$   H$0  H@ E3H$(  H$8  HcIHH+ғLH  HtHu
HGHP03H|$0   AHci\
 HHD$(H  HD$0Ht
HAHD$0    HD$xH$   E3H HDHB H HB HHD HI{LHQ  Hu
HGHP03H|$(I$uID$IP0HNLH9N ~IHFL<HAHFIHh\
 
  Iu
IGIP0L\
 Ht H]
 HH軺  [
 Hu
HCHP0H$   LH$   Ht
HuHAP0Y
 HH  H
 JLH  H@L   MtH IAL2L@@MtH IH ALH IZ
 LM  Iu
IGIP0HrY
 E3I|$MH9   M|$M   I\$IIHHLuHAP0HZ
 H{H9uHE3H$   HEAL$   L$   CHHa
  Iu
IGIP0Mt   Y
 HHD$(H
  LxIE E3HHLh M)HH3
  HE u
HEHP0Lt$(II
HH  I$u	HIP0HT$8LHMX
 j  Hu
HCHP0HL$XHHt$XHt
HuHAP0Ll$PIIEL   MtHT IAH2L@@MtH9 IH AHH# IY
 HH  HW
 HkH9E    LcM   H{I$HHHHuHAP0H?X
 HoH9E uOHD$XE3H$   EAHL$   H$   qHH  I$uID$IP0Mx   X
 LHD$(H8  L`HD$XE3H IHIE MQHH  IE u
IEIP0Lt$(HH2HH\  Hu
HE HP0Hu
HFHP0L$   IIM H;
W
   H W
 HH  H@L   MtH HAHHD$(<L@@MtHb HH AHHD$(HG H.W
 HHD$(H   Hu
HCHP0HU
 HoIH9E    H_H   HHT$(HHHHH|$(uHBP0HMV
 HoH9E uMHD$8E3H$   EAHH$   H$   HH
  Hu
HCHP0Iu   #V
 LH
  HXHD$8E3H IHID$ IeHHw
  I$uID$IP0MHT$8HEHH  Hu
HE HP0H$   Lt$(HH$   Ht
HuHAP0IM IH;
U
   H$ U
 HH  H@HHpHtHAHtHHHHD$(HHKHHD$(Hb  Hu
HFHP0H$   LH$   Ht
HuHAP03Lt$(|S
 HH
  A   HHS
 LH
  Hu
HFHP0IIWM
  I$uIT$IR0Mt0   	S
 LH3	  H
 HH@HIMIE IIH$   LHuHAP0H$   H
 ~HHD$(H     R
 LHN  H@IIH8T
 HHD$(H  I$uID$IP0HL$pMH|$pHt
HuHAP0Ll$PIEHHpHt HAHtHl$8IHHHD$(Hl$8IHIHHD$(HN  HGL   MtH_ HAL2L@@MtHD HH ALH. HS
 LM
  Hu
HGHP0   R
 HHD$(Hm
  HD$pH HGSQ
 HH#
  L( H HQ
 	  LHIʋHH	  I$uID$IP0HMu
HGHP0HILt$(u
HFHP0LHIIS
 	  Hu
HCHP0HL$pLS
 H  H\$@Hl$ HH$   A~H\$pHCH;>Q
 uH{tLHCHXHyH;$Q
 uH{t*H[ H[HHhHtHAHt   HH:   Q
 HHuIHHP
 HHu
HGHP0HH  H E3HEAkHHx  Hu
HCHP0H؅*  Hu
HVHR0H$   H\$@IeH
 ɑHH  H@L   MtH HAHHD$(<L@@MtH HH AHHD$(H HZP
 HHD$(H0  Hu
HCHP0IEHHpHtHAHtHT$8IHHT$8IoFHH  HN
 HoH9E    LgM   HHT$(I$HHHH|$(uHBP0H=O
 HoH9E u^E3H$   HEAL$   H$  tHHJ  I$uID$IP0HM   HCHP0z   O
 LHe  L`E3HHMHX MHH  Iu
IGIP0M)HH1HHl  HuHCHP0 Hu
HE HP0HT$8LILt$(O
    HH\$@Hl$ H$   HFHP0H$   H' Hl$  5  HE  ,  Z  H' Hl$  4  H o %-  .  H' Hl$  4  H C C-    Hg' Hl$ T 4  H  >-    H;' Hl$ ( 4  H  3-    H' Hl$  4  Hi  -  ~  H& Hl$  4  H=  -  R  H& Hl$  4  H g -  &  H& Hl$ x 5  H ; ,    H_& Hl$ L 6  H  q-    H3& Hl$   6  H  -    H& Hl$  6  Ha  -    H% Hl$  7  H5  -  J  H% Hl$  7  H	 _ -    H% Hl$ p 7  H 3 -    HW% Hl$ D 8  H  -    H+% Hl$  8  H  -    H$ Hl$  8  HY  -  n  H$ Hl$  ;  H-  %.  B  H$ Hl$  A  H W .    H{$ Ld$0Hl$ H \ A  & .  '  HJ$ Hl$ 7 A  H  .    H$ Hl$  A  Hx  .    H# Hl$ ߾ A  HL  .  a  H# Ld$0 A  H  v .  w  H#  A  V .  H   Hs# e A  / .  H   HL# Ld$09 @  H  v.    H #  @   s.  Hu   H"  @   q.  HN m  H" Ld$0Hl$ H1  @  } j.  ~  H" Hl$  >  H Q `.    Hu" Hl$ b >  HϿ % [.    HI" Hl$ 6 >  H  Z.    H" Hl$ 
 >  Hw  X.    H! Hl$ ޼ >  HK  S.  `  H! Hl$  >  H u P.  4  H! Hl$  >  H I N.    Hm! Hl$ Z <  HǾ  A.    HA! Hl$ . <  H  <.    H! Hl$  <  Ho  :.    H  Hl$ ֻ ;  HC  ".  X  H  Hl$  ;  H m  .  ,  H  Hl$ ~ ;  H A .     He  Hl$ R 9  H  .    H9  Hl$ & 9  H  .    H
F
 HN
 H	H
 L Hl$ LZ ܺ 9   
.  e  H Hl$  8  H$ z -  9  H Hl$  8  H N -  
  Hr Hl$ _ 8  H̼ " -    H
F
 H_
 H	H
 L/ Hl$ L  8   -    H Hl$  7  H]  -  r  H H|$(Ld$0Hl$ H1  7  } -  ~  H Hl$  6  H Q -    Hu Hl$ b 6  Hϻ % k-    HI H|$(Ld$0Hl$ H % 6   ]-    H Hl$   6  Hm  [-    H Hl$ Ը 6  HA  Y-  k  H  5  w ,  H D  H  4  P ,  H   .D
 HtHF
 HHt EC
 HE   HEHP0  H,  3   ,  H   3A
 HHu,H H|$( C  HO  .    HD$PH$   IHH H;
mC
 uCH
|C
 H-
 H	|E
 L H|$(L { D  E .  r  HQ cB
 HHu,HT H|$(A D  H  .  1  HC
 LHu,H H|$( D  Hp ƿ .    HE u
HEHP03HH\$ LMT
  ff     H
 4HH
  H@L   MtH HAH2L@@MtH޶ HH AHHȶ HA
 HH*
  Hu
HFHP0HGL   MtHt HAH2L@@MtHY HH AHHC HbA
 HH  Hu
HGHP0ImA
 HHD$(H;  H?
 LHH9Fu.L~Mt%HFIHH HHuHAP0   HHr@
 H9F   H$   H|$(H$  H@ DAH$h  H$p  HcE3HHL$`  H+H$h  H$x  vwHD$ H  MtIu
IGIP0HLu
HGHP0HH\$(   AHc?
 HH  MtLxE3HT$(H$   H$  HTHA E3H HA HHD HE Hl(3HH|$(yHD$ H}
  Hu
HCHP03Hu
HFHP0HL$`LD$ HLD$`Ht
HuHAP0H$   HH H;
?
 	  Hӻ >
 LHD$ H	  H@H;>
 uIx tMI@H0H~H;>
 uIx t,IpH`HHhHtHAHt3ILD$ H=3?
 HHuH#HL$ HC>
 HHu
HCHP03LD$ H  I u
I@IP0HL$hHt$hHt
HuHAP0HH@  )  H$   HH H;
~>
 {  H =
 HH3  H@H;|=
 uH~ tJHFH(HE sH;b=
 uH~ t(HnHE THHhHtHAHt3HH63=
 HHuH!HH#=
 HHu
HCHP03He  Hu
HFHP0HL$hH?>
 HH  HE u
HEHP0HL$hHt$hHuHAP0HH
 $~HH  H@L   MtH	 HAH2L@@MtH HH AHHر H<
 HHB  HE u
HEHP0HK;
 E3HkLD$ H9E   HSHT$ H   H{HHHHHuHAP0HT$ H;
 HoH9E u\HD$`E3H$   H$   EAHH$   sHH  HL$ HuHAP0H|$(E3LD$       ;
 HD$(H  LD$ HL$`HL@HHH E3HLD$ tHHL  HT$(Hu
HBHP03H|$(HT$`HvHH  Hu
HE HP0HFL   MtH HAH2L@@MtHַ HH AHH H:
 HH%  Hu
HFHP0H$   3HH$   Ht
HuHAP0H
 {HH  H@L   MtH HAH2L@@MtHr HH AHH\ HS:
 HH!  Hu
HCHP0   9
 HH  H H HCHS H HC Hs(HEH@pHtH@Ht
HHHHH:0HHH  Hu
HCHP0HL$PHщ  Hu
HFHP03IM;H  Hl$ =H Ld$0Hl$ HU ׭ E   /    H Ld$0 I  H u l/  v  H Ld$0 I  H I i/  J  Hm Ld$0Z I  Hǯ  g/  H  H
9
 H'
 H	;
 L' Ld$0L 
 I  ׵ e/  H  H Hl$  J  HR  /  g  H Hl$  J  H& | /  ;  H Hl$  J  H P /    Hl$ H
 xHH  HW I L   /  H   H0 Ld$0Hl$ H  K  ۴ /    H Hl$  K  HY  /  n  H Hl$  K  H-  /  B  H Hl$  K  H W /    H{ Hl$ h K  Hխ + /    HO Ld$0Hl$ H 0 J   /    H Hl$  J  Hx γ /    H Ld$0ߪ J  HL  /    H Ld$0 J  H  v /  w  H Ld$0 H  H J X/  HH  Hk Ld$0Hl$ Hʬ L G   K/    H: Ld$0' G  H  I/  I  H
5
 H
 H	7
 L Ld$0LX ک G   G/  H  H Hl$  E  H u 6/  4  H  E  U (/  H 
  Hr Ld$0_ E  H̫ " /  #  HF Ld$03 E  H  /    H Ld$0 E  Ht ʱ /    H
 H|$(Ld$0HM Ϩ E   .    H@L   MtH} HAHHD$(<L@@MtH] HH AHHD$(HB H3
 HHD$(Hu'HU
 G L   /  H   Hu
HCHP0HF2
 Ho3H9E _  H_HR  HHT$(HHHHH|$(uHBP0H2
 HoH9E upLl$PE3HT$@EAHH\$@Ll$HjHHu,H Hl$  L  H J /  	  H  HCHP0     2
 LHu*HB 4 L   0  H I   HXHD$PE3H IHIE kHHu/H Ld$0ߦ L  HL  0  I   IE u
IEIP0Ll$P   Ll$PHI_mHH  H Hl$ y L  H < /  HtHu
HCHP0MtI$uID$IP0H|$(Ld$0
H|$(Ld$0MtIu
IGIP0MtI$uID$IP0HtHu
HGHP0HtHE u
HEHP0HtHu
HFHP0E3E3L
 D r H
ˀ
 FLl$P*Hu
HE HP0ILHuHAP0IE MH$   L$  L$  H$  H$  H$  H$  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0MtIE u
IEIP0HL$8L$  Ht
HuHAP0H$   Ht
HuHAP0HL$XHt
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$pHt
HuHAP0HL$`Ht
HuHAP0HL$hHt
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$xHt
HuHAP0H$  HtH u
HPHR0IH  A^k@UATH(HAH\$@E3L   Ht$HLl$ LIIMtH& AH,L@@MtH H AHH ].
 HH|$PHu'H â [   1  H&   ,
 HHu'H  [  X 1  H       -
 HHu'H
b T [   1  H
    IE LhH LH,
 y$H  [  ت 1  Hq LHu
HCHP0Hx LHfHHufH  [   1  H# Hu
HFHP0HtHu
HGHP0H   H   HCHP0uHu
HFHP0Hu
HGHP0HCHHHpHtHAHt
IHIH#HuDH  \  ѩ 1  Hj L
c D  H
}
 芇LLl$ H|$PHt$HH\$@HtHE u
HUHR0IH(A\]H\$Hl$Ht$WATAUHPH),
 HjMLH\$@HH\$HHM   Ht"HtH   Hz H|$HHZH\$@IF+
 HHHtHt+RHT  H[ I-
 HtHHD$@HH+  H I-
 HtHHD$HHH  H|
 LL$@Huz HD$(E3IHl$ (ry
&2     H|$HH\$@   H   H   H   Hy3L
ȝ
    L
ʝ
 HHG
 Hl$0H[
 L,|
 HDH
 HD$(HL$ H
*
 H	,
 72  L
 H
{
 A^    ^  L
/ j3Hz HZLHIH\$pHl$xH$   HPA]A\_[HHPATH   E3HXHhHxLhLpHALIL   L$   Ld$HLd$0Ld$8IL$   Ld$ Ld$(MtH AH,L@@MtH H AHH 7)
 HHt$xL|$XHu'H    b v5  H 1
  H'
 MH9G   LM   HwIHHHHuHAP0IHcHHu'H.      5  H   Iu
IGIP0MHu
HGHP0HIu
HFHP03&
 HHu^H    } 5  H   HdHHuH |   F 5  Hߞ w  IN H;
(
 u>H
&(
 H}
 H	&*
 L? 1   L  5  ,  HȜ '
 HHu'H     5  HX   H@HH$   H;&
 t~H;&
 tuH(
 LHu*H     e 5  H H  H@L   Mu6Ho  a   + 5  Hĝ HY  HLIMHu
HGHP0MdMuFH%
 I9GuI;o  IGHH|HI,I;o}  I<$HHIIAHH4  HL$HH|$HHt
HuHAP0H˚ H%
 HH   Hg H%
 HH   Hu
HWHR0HN3H9N ~HHFHHAHFHH=&
 uHu
HCHP03H
 
   ע 5  Hp H  H
 H$   ۙ   HH  5     H
 H$      H o 5     T%
 HtH@'
 HH
t\k$
 Iu
IGIP0H$   HH$   [yvH@
 2    5  H E3  H
 H$       Hm á 5  H  H  HFHP0  tH   3"
 LHu'H
    j 5  H   IN H;
;$
 u>H
J$
 Hky
 H	J&
 Lc
 U   L  5  t  H 6#
 HHu'H'
     5  H| 8     <#
 HHu'H
 ߗ    5  HB   HH
 E3HHpHX `\HHu'H
    ] 5  H   Hu
HGHP0HCH;F"
 t}H;E"
 ttH2$
 HHu'HC
 5    5  H ?  H@H   Ht$@HuEH
    ß 5  H\   HE3HIL$   ILl$@E3HHu
HCHP0Lt$0LdHuVH|!
 H9Gu'H;o  HGHH\H$   HI3H;o  I$HHIH$   HHHQ  HCH!
 H;   H;!
    H"
 LHD$(H	  Hu
HSHR0INIIH   IH$   H}  Iν   HD$ He  I֍UHR  Iu
IFIP0H$   Ht$ Lt$0Ll$(NHKH  H;uHKHs H$   HCHHpH$   HHHu
HCHP0H$   ILHD$0Ht
HuHAP0HL$8HL$   HD$8HtHu
HAP0HI^Ll$ HshH   H~     H;d 
 t"HBHHuS 
 H  IHy?HHt7IHxHy(Hy#IH
H 
 H	?
   9
 IHIV HSH[pH  H{ w  H
 HL
 HHw  HISHHu
HVHR0HU  IOI9O ~HIGHHAIGHI
    HHt$@HCHP0Hu
 H$   _   H̕ " <6  i  Iu
IFIP0Ll$(uHbH 
 H$   
   Hw ͛ D6    H
 H$   ے   HH  46    H
 H$      H o M6    MFH
_
 H
 M@H	 
 IHq
 H$   [   HȔ  K6  e  H~H

 He
 A   H	6 
 
HxaH
 H$      Hj  6    
 Ht H
 HH^|   
 Hu
HGHP0H$   ILL|$XLt$`Ll$hH|$pHt$xH$   HtHE u
HEHP0HL$HH$   Ht
HuHAP0HL$0Ht
HuHAP0HD$8HtH u
HPHR0IHĐ   A\H
 H$      H^  6  HtHu
HGHP0MtIu
IGIP0HtHu
HCHP0H$   Ht
HuHAP0HL$ Ht
HuHAP0HL$(HtHuHAP0E3E3L
 DC  H
Zq
 vHHPHHH   HXHhHxL`3E3H3H$  HD$(HD$0HD$ HD$HHC3L   Ld$`Ld$pLd$@Ld$PLd$XHL$8MtHi HAH2L@@MtHN HH AHH8 H
 HH$   L$   L$   L$   Hu'H8
 *    6  H   H9
 3H$   H9G   HwH$   H   H_HHHHHuHAP0HHULHu*H
    m 6  H L	  Hu
HFHP0H$   3H$   Hu
HGHP03Iu
IFIP032
 LHunH3
 L$      H  6    HVLHuH
 L$   ލ   HK  6  G  HK H;
y
 uFH

 Ho
 H	
 L
 L$   L    N 6    H" l
 HHu/H]
 L$   G   H 
 6    H@H;

    H;
    HI
 HH$   Hu*H
      7  HH LK  H@L   Mu;H
    u 7  H L  HHH$   E3Hu
HGHP03NlMuFHB
 H9FuL;f$	  HFIJ|HI,L;f	  I} IHIHAHH  HL$XHH|$XHt
HuHAP0H; H
 3H
 HH$  HtH HLHH$  H$  HAL   MtH AH,L@@MtH H AHH 
 HH  H$  HuHAP0Hp H/
 H$  H<  Hg H
ؑ H
 HHD$0HtH HKHHD$0H  HFL   MtHM HAHHD$ <L@@MtH- HH AHHD$ H H
 HHD$ H0  Hu
HFHP0HA HL$XN
 HHD$0H  H
^
 HsH|$8H9.  LCLD$8M  H[HD$ I HH HH\$ uH@P0HT$0LD$8H
 HsH9urE3L$   H$   H$   EAHLHD$(H+  HD$8H u
HPHR0HL$03HH\$8uHAP0H\$0H\$       
 HHD$HH0  HL$8E3HHHD$03HL$8HL$0HHB MHD$(H  HL$HHuHAP0H|$H-HOHD$(HB  HL$0HuHAP0H|$0Hu	HHP0   
 HHD$ H  H$  H
ǋ E3HCHD$(HHC 3H$  MHD$(Hc  Hu
HCHP0Hp
 HuH|$ H9)  HUHT$ H  H]HHHHHuHAP0HT$ H
 HsH9umHD$(E3H$   H$   EAHH$   6JHH  HL$ HuHAP0HL$(3HH\$ uHAP0H\$(      
 HH$  H  HD$ 3E3HAHD$(HT$ HT$(HHA HKHHv  H$  HuHAP03H$  5H\$(HHMHH  Hu
HCHP0HD$(    HE u	HHP0IN3I9N ~HIFH<HAIFHI
 9  Hu
HGHP0H$   3Hm
 L$   W   HĈ  F7    H>
 L$   (   H  \7    H
 L$      Hf  V7  b  H
 L$   ʅ   H7  7  3  H
 L$      H ^ 7    H
 L$   l   Hه / 7    HS
 L$   =   H   7    H$
 L$      H{ э x7  w  H
 L$   ߄   HL  j7  H  H
 L$      H s b7    H
 L$      H D ?7  
  Hh
 L$   R   H  27  
  H9
 L$   #   H  /7  
  H

 L$      Ha  -7  ]
  H
 L$   Ń   H2  +7  .
  H
 L$      H Y (7  	  H}
 L$   g   Hԅ * &7  	  
 HtH
 HHmtY&
 Hu
HFHP0H$   E3MLt$`yVH
     7  HP 
  H
 L$      H+  7  '	  tIb
  H$   HI H;
E
 u>H
T
 Hd
 H	T
 Lm
 _   L̄ " 7  	  H @
 LHu'H1
 #    7  H      F
 HHu*H
     7  HL LO  I$H
 E3HL`Lp fFLHu*H
    c 7  H L  Hu
HFHP0IFH;I
    H;D
    HIH$   !
 H$   Hu/H-
 L$      H ډ 7    H@H   Ht$xHuPH
 L$   Ӏ   H@  7  <  I33ML$   Ht$xH$   L$   Iu
IFIP0ILHL$hHumH$   HJ
 H9Fu/H;^   HFHLLtH$   IHHL$h:H;^  L1HLIHH$   HL$hILH  IFH

 H;   H;

    I
 HH$  H`  IuIFIP0H$  HA3H   HH  L$     IHH  IӍVH{  I$uID$IP03H$  ?INH  H;u
I~In IFH8HhHHE Iu
IFIP0HL$pHH\$pHt
HuHAP0HL$@3Hl$@Ht
HuHAP0HC3H;	
 tYH;	
 tPHIu
 LHS  H@L   Mu3Hr
 d~   . B8  Hǀ   HE3LE3OlMuHH	
 I9Fu M;f  IFIJlHE I-M;f  Im IHE IIAHH  HL$PHl$PHt
HuHAP0HCHHpHtHAHt
HHHHHwHH  H}HwhH   H~     HD$@H;	
 t"HHHu
	
 H  3Hy>HHt6HHxHy'Hy"3H
	
 H	
 ?  
 IHHV HUHpH  H   H{
 HL$@L=
 HH  HHWHHu
HSHR0H  HE u
HEHP0H\$pHT$PLH3
 D  Hu
HGHP03
 Ht H	
 HHf  	
 IH$   HL$hHt$xL$   oIFIP0HL$h[H
 {    %8  H'~ T  L$  I$uID$IP0E3@uHKH}
 o{   9 -8  H}   HV
 H{    8  H}   H/
 !{    @8  H}   H
 L$   z   H_}  r8  [  LEH

 HV{
 M@H	
 3H
 L$   z   H} e o8    H
 L$   sz   H| 6 m8     HZ
 L$   Dz   H|  ]8     H~H

 HNx
 A   H	
 
HxIH
 y    8  HQ| Z
 Hn  H
 HHNdt
 H$   M  H
 y   \ 7  H{ MtIu
IFIP0L$  L$  HtHu
HGHP0MtIE u
IEIP0MtI$uID$IP0HtHE u
HEHP0HL$(Ht
HuHAP0HL$0HtHuHAP0Ld$`Ld$`HL$ Ht
HuHAP0HL$8Ht
HuHAP0HL$HHt
HuHAP0L
z Dux C H
Z
 _E3$H$   Hu
HFHP0Ld$`MI$L$   L$   H$   H$   H$   H$   MtI$uID$IP0HL$pL$   Ht
HuHAP0HL$@Ht
HuHAP0HL$PHt
HuHAP0HD$XHtH u
HPHR0IL$   H   鋼;H\$Hl$Ht$WATAUAVAWH@Hx LHI@E3E33ED$33OHHu'H
 v    j=  HFy   E3H; 
 A3H; 
 3H;=f
 AuH
 DEyv   O l=  C  Hu
HGHP0E  H~ H L%~ H9w ID$IL   MtAL@@Mt	H A
 HHu'H	
 u   ~ =  H^x   H
 
 LkI9E n  HsHa  H{HHHHHuHAP0H 
 LoI9E    IG(E3HT$ EAHHt$ HD$(7HHu]u   '~ =    Hu
HFHP03Hu
IE HP0H
a| H;HH   u   } =       1 
 HHu'H

 t   } =  H
7w   HpIG(E3H IG(HH3HE O9HHut   S} =  G  HE u
HEHP03&IW(H;HH@t   
} =    Hu
HGHP0E3E33HIHu
HCHP0H
 s   | =  HSv   HOv IO@E3EALHHu'H
 s   t| =  H
v   Hyy'H
 us   ?| =  Hu O  Hu
HCHP03ۅ   IO L	 I;uEH
"
 L)
 H4X
 H	+
 L
 s   Lsu { =    Hs HHu'H
 r   { =  H.u   H;j	 @H u
H@HP033ۅ@ǅ  H}v H L%sv Hds ID$IL   MtAL@@Mt	H A	 HHu'H4
 &r   z =  Ht 9  H5	 Lw3I9  HoH  LoHE HIE HIuHAP0H	 MuI9   IG(E3HT$0EAIHl$0HD$84HHuZz =  GHE u
HEHP03Hu	IHP0H
x H8HH  z >  3q   H0
 Hs HtHu
HGHP0HtHu
HCHP0H  H   HFHP0      	 HHuy 
>  zHhIG(E3H IG(HI3HF H5HHuVy >  @Hu
HFHP03IW(H7HHy =  Hu
HCHP0E3E33HEHu
HGHP0H
 o   x >  Har HtHE u
HEHP0L
Dr Do x H
 U
 kVMtI$uIT$IR03
HQ	 H H\$pHl$xH$   H@A_A^A]A\_H8LJL)	 E3H;	 A3M;A   MuH
V	 Ho
 H		 FL;	 uL;
	 t]L;
	 tTIAH
	 MJH	LR
 Ho
 HD$ 	 H

 n #  w uA  3H
*q H8H8L@SUVWATAUAVH H	 3L0H\$`HMn`MfhInpH\$hHH\$pMtIE MtI$HtHE 4  Ht	 INHL
!
 L   AM  L
tp m Dv I;trH'  I@   s
I#5HAH;^	 t!      t
   rIE	 3W   L
o m DPv DH
X
 ATLL$pLD$hHT$`IWJyEm   v M  ^Hn H
r E31HHuu 	N  *E3E33HBHu
HCHP0u 
N  l   H
 H\$`Ht$hH|$pH2o LMII1IHtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L
n D`l .u H
W
 SH A^A]A\_^][MtIE u
IEIP0MtI$uID$IP0HtHE u
HEHP0H A^A]A\_^][H(IL$0	 Hu9L

 D@PH
,
   k P   ot   L
n CR3H(鋀H(Ht	H(H
	 Hh\
 H	'	 H(@SH HHt
H [鈁H	 H HAHHIH9 uHAP0H	 HC3H [@SH HHt
H [xHi	 H HA HHI H9 uHAP0HG	 HC 3H [H(A(9	 Hu9L
U
 D@TH
*.
 b  7j T   s b  L
l P3H(H(Ht	H(NH
?	 H[
 H		 H(@SH HHt
H [鸄Hi	 H HA8HHI8H9 uHAP0HG	 HC83H [H(AH9	 Hu9L
U
 D@XH
j.
   7i X   r   L
k O3H(H(Ht	H(nH
?	 HZ
 H		 H(@SH HHt
H [鸈Hi	 H HA`HHI`H9 uHAP0HG	 HC`3H [@SH HHt
H [H		 H HA HHI H9 uHAP0H	 HC 3H [H\$WH03j   H
 g    p t\  HEj H
p H  H=n  t#L
$j Dg H
c
 3ONH
Xp HuHAP0H@p     H\$@H0_3	 Hi Hu'HZ
 Lg    p u\  Hi eH
j
 3[	 Hl Hu'H
 
g    o v\  Hmi #H
P
 3	 Hjl Hu'H
 f    o w\  H+i qhy'H
 f    bo \  Hh Ho H
 b
 E3E3D$   	 Ho H  H H@	 H	m Hu'H5
 'f    n \  Hh @Hl H
a
 H 	 Hm Hu'H
 e    n \  H@h H
a
 	 Hn Hu'H
 e    gn \  H h Ll H
=n H^a
  	 y'He
 We    !n \  Hg pPy'H5
 'e    m \  Hg @9=m tFL^g H
m H`
 	 y'H
 d    m \  H<g y'H
 d    sm \  Hg y'H
 yd    Cm \  Hf x(ey'H=
 /d    l \  Hf Hu'H
 c #   l \  Haf H
5j A3CHHu'H

 c &   l \  H
 f 	  Hi H
ej L,	 yc &   Ll \  	  Hu
HCHP0H
c A3CHHu?c '   	l \  q	  Hb H
i L	 yc '   k \  =	  Hu
HCHP0H
h A3BHHub (   k \    HVh H
wi L>	 yb (   ^k \    Hu
HCHP0H
ji A3'BHHuQb *   k \    Hg H
 i L	 yb *   j \  O  Hu
HCHP0H
{d A3AHHua ,   j ]    H(i H
h LP	 ya ,   pj ]    Hu
HCHP0H
Dc A39AHHuca -   -j ]    Hh H
h L	 y/a -   i ]  a  Hu
HCHP0   	 HHu` .   i ]  %  H` AHH HKH` HHe H HKHe HAH
Ab d@HHu'H

 ` .   Qi &]  H
b   Hu
HCHP0HF` HAHHu@` .   
i )]  r  H` H
f L	 y` .   h +]  >  Hu
HCHP0HBd HAHHu_ .   h -]    Hd H
{f LB	 y_ .   bh /]    Hu
HCHP0Hu
HGHP0   R	 HHu'HS
 E_ /   h :]  Ha   Ha AHH HOHa HH=e H HOH/e HAHt` H HOHf` HAH_ H HOH_ HAH"_ H HOH_ HA H
Yb d>HHu^ /   Xg K]    Hu
HGHP0H` H?HHuN^ /   g N]    H` H
d L	 y^ /   f P]  L  Hu
HGHP0H(d H ?HHu] /   f R]    Hc H
d LP	 y] /   pf T]    Hu
HGHP0H_ H>HHuf] /   0f V]    H^ H
d L	 y2] /   e X]  d  Hu
HGHP0H] H8>HHu\ /   e Z]  $  H] H
c Lh	 y\ 0   e \]    Hu
HGHP0H\ H=HHu~\ /   He ^]    H\ H
-c L	 yJ\ 0   e `]  |  Hu
HGHP03Hu
HCHP0H
[ (HHu[ 2   d k]  -  H@Ha HL   MtAL@@Mt	H A1	 HHu[ 2   md m]    Hu
HCHP0Ha_ E3H& HHu`[ 2   *d p]    Hu
HGHP0H` H
a L3	 y[ 2   c s]  L  Hu
HCHP0L`` H
9
 3)	 HHuZ l  c }]    Hb H
a LI	 yZ l  ic ]     Hu
HCHP0L_ H
n
 3	 HHuXZ o  "c ]     H] H
a L	 y$Z o  b ]  YHu
HCHP0	 HHub ]  %Ha H
` Ls	 yYb ]  Y    H
 H%\ HtHu
HCHP0HHHGHP0HuYHCHH\$@H0_H`0H\
 NY    b \  H[ 	 HuH
	 HU
 H		 H\$@H0_+kORH\$Hl$VWATH@HO	 HzILH\$pHM   HtH   HZH\$pI	 HHu)H  H] H	 HtHHD$pHH   H-
 LL$pH? HD$(E3HH|$ *y
'     H\$p   H   H   Hy3L
HV
    L
JV
 HH 
 H|$0H
 L-
 HDH1V
 HD$(HL$ H
H	 H		 '  L
c
 H
|-
 A   ` BW   L
Y =3HZHITH\$`Hl$hH@A\_^LI[IkIsI{ ATAUAVH`H=	 H-	 H5	 LbI{IkIsMLIM%  Mt0Ht!HtH1  Hr(IsHj Hl$HHzH|$@I	 HIMtHt1HtT{H  H[ I	 HtHHD$@HHg  H|W I	 HtHHD$HHH>  H+V I	 HtHHD$PHH  H-
 LL$@HN= HD$(E3ILd$ I(y
)     Ht$PHl$HH|$@   M   H   H   H   My3L
S
    L
S
 HH	 Ld$0H1
 LV-
 HDHS
 HD$(HL$ H
	 H		 )  L

 H
N-
 A  ] T   L
AW |;3Hr(Hj HzLLHIaL\$`I[ Ik(Is0I{8IA^A]A\+H\$Hl$VWATH@H	 HzILH\$pHM   HtH   HZH\$pIC	 HHu)H  H;T H	 HtHHD$pHH   H4
 LL$pH~; HD$(E3HH|$ Y&y
@5     H\$p   H   H   Hy3L
R
    L
R
 HH	 H|$0H_
 L3
 HDHQ
 HD$(HL$ H
	 H	?	 N5  L
#
 H
3
 A  [ S   L
oU 93HZHI致H\$`Hl$hH@A\_^H\$Hl$VWATH@H	 HzILH\$pHM   HtH   HZH\$pI	 HHu)H  HR H	 HtHHD$pHH   H3
 LL$pH9 HD$(E3HH|$ $y
6     H\$p   H   H   Hy3L
XP
    L
ZP
 HH%	 H|$0H
 L<3
 HDHAP
 HD$(HL$ H
X	 H		 6  L
s
 H
3
 A  0Z RQ   L
S 73HZHIH\$`Hl$hH@A\_^H(Ht	H(~H
/	 HA
 H		 H(DL$ DD$T$L$SUVWATHp  HD$@AA؋/H
 HD$ L
 L$  HX	 H
8  ̅y/H HD$ L
 L$  HE	 H
n8 ٬ ̅/H
 HD$ L
 L$  H*	 H
;8 覬 E/Hi
 HD$ L
U
 L$  H	 H
8 r fn$ 5 D,G;tt
m     DBHL$pT	 H$  H$   	 H	 H$   A IcHL$0	 H$   LcAJ   HPH$   	 HH	  Hȋw	    HL$0	 HH9	 H$   Ȝ HHu3
HHcIHHVkdřH!	 HH	 芜 H	 H	 $   HEH$   c H$  H$   }	 HT$HHL$p=	 H$  LHAHL$H	 HL$p	 Hp  A\_^][@SH Hp H
q H+p H H+HH [H\$Hl$Ht$WATAUH0HyXHq(Hi(MLLHT$ H HH HtH;t	 H9{u2SHT$ MH HHHu	 HHu3HH@0H9Cu	 HSIH@]	 H\$PHl$XHt$`H0A]A\_@UVWATAUAVAWH  HǄ$   H$  LE3IL|$`L|$hL|$pH$   c	 H$   T	 MML$  L$  H
U LHu'Hb
 HN ML y   U W  G  HH$  LphAACAFACINzHHu'H
 HtN K }   T   
  LHL;
	 tIMILK
 HL
 H
	 H		 L
 LN K }   jT   
  HFHHNL9!uHAP0H~IN8ѳHHu'Hb
 HM MK ~   T   G
  LHL;
	 tIMIL
 H
 H
	 H	#	 L
 LuM J ~   S   \  HF HHN L9!uHAP0H~ AFhF(3	 Hu'H
 HM J    gS     HHD$`I   I;   v	 IFpHD$PH\$X(D$PfD$PHt$PH|$XI   I9   v	 HtI;vpt	 AH;  Hu	 MLI;{ r	 HG H+GHHH$   Hux	 MLI;{ rd	 H_H;_ vT	 HHuF	 MLI;[ r2	 L|$@D$8  D|$0H\$(L|$ A   L$   AQH
R HH  HH   HL$hHD$hHt
HuHAP0LEHM HHAL;AI;tHHEJI@HEHH	 t(Huv	 MLI;{ rb	 H0iH
 HK H    gQ   H$  
  H
 HJ nH    8Q   H$  `
  3C	 HHu'HD
 HJ /H    P   	  I   I;   v	 I   HD$PH\$X(D$PfD$PIHt$PHl$X
II   I9   v\	 Ht	I;   tH	 H;  Hu4	 MLI;k r 	 HH$   	 Hu	 MLI;k r	 H(H$   H$   ~	 H$   H$   	 HH$   H@H{ rHKHKII;}HH33	 L'H=	  tE3	 LE3E3	 LHa	 Mt|HOH9O ~I$HGL$HAHGIH	 u%I$ID$IP0IHP
 HH ;F    O     H)
 HH F    N 
  y  H|$pH
ML xLHu*H

 H
RH E    N   I]  H@L   MtH/F IAL2L@@MtHF H IALHE I	 LMu*Hf
 HG QE    N   I  I$uID$IP0   f	 LHu*H
 HG E    M !  I  HHxHD$`H ID$ E3IH
H ~	HH$  Hu*H

 H
 G D    lM )  I+  I$uID$IP0MIuH	 H9y  MeMl  I]I$HILHuHAP0HsH=	 H9   L$   H$   E3EAH$   HuHHu'H
 H_F C    L >  F  I$uID$IP0MHE u
HEHP0L$       	 HH$  Hu'H

 H
E lC    6L N    L`MHh L$  E3HHHHu'H1
 HE C    K T    H$  HuHAP0L$  SHI	HHu'Hا
 HAE B    K 7  (  HE u
HEHP0L$  IE u	HIP0MH$  HF0HHN0L99uHAP0H~0Ip  轪HHu'HN
 HD 9B    K g    HF@HHN@L9)uHAP0H~@A  FHI  H$(  	 HH$   H@H{ rHKHKIII;}HH33|	 H'H=	  tE3	 HE3E3[	 HH'	 Hu'Hk
 HC VA     J     HFPHHNPH9 uHAP0H~PI  胫HHu'H
 H}C @    I   d  HFXHHNXH9 uHAP0H~X3	 HHu'H
 H*C @    vI     I  I;   v+	 I   H$   H$   ($   fD$PHt$PHl$Xffff     I   I9  v	 Ht	I;   t	 H;D  Hu	 MLI;k r	 HH$   5	 Hu	 MLI;k rn	 H(H$   H$   	 H$   H$P  V	 HH$   H@H{ rHKHKIII;}HH33*	 L'H=m	  tE3b	 LE3E3		 LH	 MtnHOH9O ~IE HGL,HAHGIH	 uIE IEIP0Hϣ
 H8A >    G   "H
 HA >    `G   HtHu
HGHP0H$  H$  MtI$uID$IP0MtIE u
IEIP0H$  Ht
HuHAP0HtHu
HGHP0H$  H$  L
d@ D= F H

 $*H$  HF`HHN`H9 uHAP0H~`HLHtHu
HFHP0HL$`Ht
HuHAP0HL$hHt
HuHAP0HD$pHtH uHPHR0H$   	 H$   	 IH$  HĀ  A_A^A]A\_^]H\$Hl$Ht$H|$ ATHPH      ?)t$@HAH=_ H5_ HH;vg	 H=_ H5_ H_ H[_ Hl$(H+_ H\$ (t$ HuH;v
"	 H+_ H\$ Ht$(ZH
_ H+ft$ H& H0H+Hu	 E3LH| I;{ wHtH3H;xs	 H|$((D$ HL$ HT$0fD$ HHHA)t$ H|$ H\$(HBLd$8Hl$0HtH;ti	 L;   ft$0HuO	 E3LI;[w;	 HD$0HsHu'	 E3LI;s r	 HHPHu	 E3LI;[w	 HH\$((t$ `H\$`Hl$hHt$p(t$@H|$xHPA\@SH   HD$ H?^ H+0^ HtNH	 HL$(f	 HL$P	 H
 HD$PHT$(HL$he	 HX
 HL$Pߋ H
C] h H
o] h 3H\ H
\ H+HHtKfD  H;r
	 H
\ LMtI    IH
\ HH\ H+HH;rH
\\ _h HD[     HZ H
Z H+HHu
	 H
Z HH#[ HZ H
Z H+HHuS	 HZ H
Z HHH
Z HĐ   [@SH   HD$ H\ H+\ HuNHA	 HL$(	 HL$P	 H*
 HD$PHT$(HL$h	 H-W
 HL$PO H
+\  E3HH
[ ,n L-\ IH+\ HtIL\ H
A[  E3HH
[ m LC[ IH+1[ HtIL&[ H
oZ J HHZ H
Z H+HH;sEH;r
	 H
Z LMtI    IH
Z HHZ H+HH;rH
Z  E3HH
GZ :m LZ IH+Y HtILY H
X HĐ   [] H\$ WH0HoZ H=Z 3H+WZ HHT$@HuLLZ L+IH
Z Hl$HHt$PHH+HI;sHAHHZ    HH;vͿ	 H
nZ H=_Z H@Z HHt$(H+HHT$ HuH)H;v
	 HZ HtH;tv	 H+H(D$ LL$@HT$ H
Y A   fD$ G H-Y H;-Y v2	 H=Y Hu 	 LLHL I;K wHtHHH;Hs	 HUY H=X H+?Y HHT$@HuLLX L+IH
X HH+HI;sHAHHX    HH;v	 H
X H=qX HRX HHt$(H+HHT$ HuH)H;v
G	 H X HtH;t0	 H+H(D$ LL$@HT$ H
W A   fD$ BF H-W H;-W v	 H=W Huڽ	 LLHL I;K wHtHHH;Hs	 HoW H=W H+YW HHT$@HuLLV L+IH
V HH+HI;sHAHHV    HH;vA	 H
V H=V H|V HHt$(H+HHT$ HuH)H;v
	 HJV HtH;t	 H+H(D$ LL$@HT$ H
V A   fD$ D H-V H;-V v	 H=U Hu	 LLHD I;C wHtHH;Csm	 HU H
U  HU H
4U  HT H
QU Ht$PHl$HH\$XH0_ @WH@HD$ H\$XHl$`Ht$h)t$0IIf(HHT HH0H{T H;lT r0   H
S 1 HH\$PHt)f(Hh L- LHkHs HD$pHC(3HHH\$XHl$`Ht$h(t$0H@_HVWATAUAVH   HD$ HXHh)p)xD)@D)HD)PIHLL$    H=S LIH=S H;=S rIH
S Y LH=S Ht2IHI+Hffffff     HHHHuH=HS fWf(3H|EHVLCIIJ    HBXpHBXpHXpHBXpH IuH;sHXpHH;rfEL*, HyDXA^3H|tLFHSHHH    I@@\YXI@H\YXI @\YXI@H\YXI HuH;sH@\YXHH;rHCfEL*HyDXf(A^X fD(HIH=Q H;=Q rIH
cQ 	 HH=Q 
t+ f/vEfA( 

 ^$   H  HH$   HHH=vQ    EY
 A^E3H   H~HMLL+HSHHL    HG@\YAI	H\Y	HG@\YAHH\YIH H HuH=P L;s4JT H+HI+H2@\YHHuH=P HH0H=~P H;=oP r0   H
O 4 HH$   Ht%fA(Hg H) HH^Ln Hn(3I6IL$   I[8Ik@(t$p(|$`E(CE(KE(SIA^A]A\_^HT$HL$SUVWATH0HD$ HHE3Dd$pHz H+zHAL$ HtH0IHDd$pLD$pHHe IHC H+CHHtVD  HC H+CHH;r	 HkHF H+FHH;r~	 HND HHC H+CHH;rHKHt~ LcLc Lc(H~ HH0A\_^][HHHUVWATAUAVAWH   HD$ HX)p)xHH@       ~ Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3ANN~ HtH3HHC    HC     HC(    Ǆ$      HGH;	    H;	 t{IH	 HHu+L

 L
. A/   D~, P  G5   H@L   Mu4L
k
 L
. A/   DC, P  5 }  HE3E3Nl=
 MuEH	 H9GuL;g|  HGJHII,L;g^  I] HIIHAHH  ILHt
HuHQR0H	 H9Cus$   HV	 f($   f.zu+	 H!  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$pHH;v	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;v{	 HT$PHtH;tf	 H+H(D$0fD$@L$   A   HT$@HL$P2 Hl$hH;l$pv%	 H\$PHu	 E3LHL I;K wHtH3H;H,	 !L
J
 L
, A0   D"* Q  2 H$   W˵	 Ht~H	 HHt	 `L

 L
J, A/   D) Q  2 H$   HuHGHP0L
, D) f2 H

 :%Hu
HGHP0HT$PH$   HS MtIuIFIP0HL$hHtjz HD$h    HD$p    HD$x    HL$PEz HL$   I[HA(sA({IA_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       y Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3ANy HtH3HHC    HC     HC(    Ǆ$      HGH;		    H;	 t{HH	 HHu+L

 L
g* A/   D' `Q  0   H@L   Mu3L
ӌ
 L
,* A/   D' bQ  t0 Q  H3E3LlfMuEHd	 H9GuH;oX  HGHHHI,H;o:  I] HHIHAHH  ILHt
HuHQR0HHH$   Hu	 H  H\$hHu3HT$xH+HHL$pHH+HH;sH1HAHD$p%HH;vG	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;v	 HT$PMtL;t	 H+H(D$0fD$@L$   A   HT$@HL$P
7 Ld$hL;d$pv	 H\$PHu	 E3LII;K wHtH3H;HPz	 EL
ފ
 L
7( A0   D% Q  . H$   W_	 Ht~HK	 HHtv	 `L

 L
' A/   D]% }Q  &. H$   HuHGHP0L
' D,% - H
{
 %Hu
HGHP0HT$PH$   H7O MtIuIFIP0HL$hHtu HD$h    HD$p    HD$x    HL$Pu HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMI Ǆ$     IANxu Ht
HL$PHIHD$PLt$hLt$pLt$x   Hu Ht
H$   HIH$   L$   L$   L$   HCH
	 H;a  H;	 T  Hy	 HHu'H
 H% u#    ?, Q     H@L   HAHHtjA   HAHHtVHAHAV۪y$H
0
 H
% #    + Q  aHU  HCHP0E3F  Hu
HCHP03耩uIDH͇
 H&% "    r+ Q  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   Ha 
 H
	 H	1	 2Mx-H~	 L
	 ILDH] 
 H
έ	 H		 H
 HO$ !    * Q    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$PK HL$8Htr Lt$8Lt$@Lt$HHL$ r 	 Ht$HU
 H# 0!    ) R  tHHL$ ;HH$   JK HL$8Ht&r Lt$8Lt$@Lt$HHL$ 
r 	 HtGH߅
 H8#      ) 
R  L
# D  p) H
)
 D;  H$   H$   HHT$PHL$  HH$    HH$    H$   IuJ IO0H$   dJ H$   Ht=q L$   L$   L$  H$   q H$   Htq L$   L$   L$   H$   p HL$8Htp Lt$8Lt$@Lt$HHL$ p H$(  Htp L$(  L$0  L$8  H$  p MtI$uID$IP0HtHE uHEHP0H$   Ht@p L$   L$   L$   H$   p HL$hHtp Lt$hLt$pLt$xHL$Po IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       o Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3ANvo HtH3HHC    HC     HC(    Ǆ$      HGH;ɨ	    H;Ĩ	 t{HH	 HHu+L
΂
 L
'  A/   D FR  o&   H@L   Mu3L

 L
 A/   Dk HR  4& M  H3E3LlfMuEH$	 H9GuH;oT  HGHHHI,H;o6  I] HHIHAHH  ILHt
HuHQR0H4$   u	 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;vҤ	 HT$PMtL;t	 H+H(D$0fD$@L$   A   HT$@HL$P& Ld$hL;d$pv|	 H\$PHul	 E3LII;K wHtH3H;HT>	 IL

 L
 A0   Dz sR  C$ H$   W#	 Ht~H	 HHt:	 `L
I
 L
 A/   D! cR  # H$   HuHGHP0L
k D # H
	
 %Hu
HGHP0HT$PH$   H;F MtIuIFIP0HL$hHtk HD$h    HD$p    HD$x    HL$Pk HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMI Ǆ$     IAN8k Ht
HL$PHIHD$PLt$hLt$pLt$x   k Ht
H$   HIH$   L$   L$   L$   HCH
`	 H;a  H;H	 T  H9	 HHu'HZ~
 H 5    ! R     H@L   HAHHtjA   HAHHtVHAHAV蛠y$H
}
 H
I     ! R  aHU  HCHP0E3F  Hu
HCHP03@uIH}
 H h    2! R  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   H!
 H
£	 H		 2Mx-H>	 L
x	 ILDH
 H
	 H		 H|
 H     [  R    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$PB HL$8Ht\h Lt$8Lt$@Lt$HHL$ Ch Ѣ	 Ht$H|
 Hn      R  tHHL$ HH$   
A HL$8Htg Lt$8Lt$@Lt$HHL$ g [	 HtGH{
 H z    D R  L
 Db 0 H

 ;  H$   H$  躻 HHT$PHL$  HH$    HH$   膻 H$   IuA IO0H$   $@ H$   Htf L$   L$   L$  H$   f H$   Htf L$   L$   L$   H$   f HL$8Htf Lt$8Lt$@Lt$HHL$ xf H$(  Htef L$(  L$0  L$8  H$  @f MtI$uID$IP0HtHE uHEHP0H$   Ht f L$   L$   L$   H$   e HL$hHte Lt$hLt$pLt$xHL$Pe IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       se Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN6e HtH3HHC    HC     HC(    Ǆ$      HGH;	    H;	 t{IHm	 HHu+L
x
 L
 A/   Df S  /   H@L   Mu4L
Sx
 L
 A/   D+ S   N  HE3E3NlMuEH	 H9GuL;gU  HGJHII,L;g7  I] HIIHAHH  ILHt
HuHQR0H$   u@	 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v˚	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;v	 HT$PHtH;t}	 H+H(D$0fD$@L$   A   HT$@HL$P^ Hl$hH;l$pv<	 H\$PHu,	 E3LHL I;K wHtH3H;HS	 HL
av
 L
 A0   D9 S   H$   W	 Ht~HΞ	 HHt	 `L
v
 L
a A/   D S   H$   HuHGHP0L
* D } H
 
 Q%Hu
HGHP0HT$PH$   H; MtIuIFIP0HL$hHta HD$h    HD$p    HD$x    HL$P\a HH$   HĀ   A_A^A]A\_^]H\$Ht$H|$ ATH`HQ Igfffffff3H+QIHHHHH?H}   Hl$pHfH;rE	 HsH~	 A   HE3H	 HH	 L L;t	H	 HK IHH+KH(HHHH?HH;rHl$pH{ H9{v͗	 HHsH|$(HD$ (D$ fD$ H;s v	 HHA H{HH;{ v	 HL$ HtH;tr	 HL$0	 H+LIHHHH?HH%{ L\$`I[Is I{(IA\HT$SH0HD$ HfWD$PHT$P&S uQ D$P2H0[HVWATAUAVH   HǄ$   HXHhHٹ   M_ E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   	 H$   w	 HT$`HK< HHL$  H\$xHt.H$   H;tfH'	 H(H;uH\$xH^ Ll$xL$   L$   HL$`n^ 3*	 HHu'H+r
 H 
    ?    H\$8H;\$@v	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8vN	 HtH;t$ t<	 L;  Hu(	 MLM;c r	 IH$   	 Hu	 MLM;c r	 I(H$   H$   r	 H$   HL$`ϓ	 HH$(  H@H} rHMHMII;}HH33	 H'H=	  tE3	 HE3E3	 HHX	 HtlHOH9O ~HHGHHAHGHHx	 uHHCHP0HTp
 H
 ?   	 ?  "H0p
 H
     ?  Hu
HGHP0HtHu
HCHP0L
Y
 D
  H
	 IHHuHGHP0H$   Y	 H$   J	 H\$8Ht.Ht$@H;tD  H'	 H(H;uH\$8H[ Ll$8Ll$@Ll$HHL$ t[ HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ   =[ E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   v	 H$   g	 HT$`HK8 HHL$  H\$xHt.H$   H;tfH	 H(H;uH\$xH}Z Ll$xL$   L$   HL$`^Z 3	 HHu'Hn
 H 	    ?    H\$8H;\$@v	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v>	 HtH;t$ t,	 L;  Hu	 MLM;c r	 IH$   	 Hu	 MLM;c rԐ	 I(H$   H$   b	 H$   HL$`	 HH$(  H@H} rHMHMII;}HH33	 H'H=	  tE3Ք	 HE3E3|	 HHH	 HtlHOH9O ~HHGHHAHGHHh	 uHHCHP0HDl
 H	 /    ?  "H l
 H	     ?  Hu
HGHP0HtHu
HCHP0L
I	 D  H
	 pIHHuHGHP0H$   I	 H$   :	 H\$8Ht.Ht$@H;tD  H	 H(H;uH\$8H}W Ll$8Ll$@Ll$HHL$ dW HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ   -W E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   f	 H$   W	 E3E3HT$`HK HHL$ t H\$xHt,H$   H;tH	 H(H;uH\$xHiV Ll$xL$   L$   HL$`JV 3	 HHu'Hj
 Hp    
 @    H\$8H;\$@vu	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8v.	 HtH;t$ t	 L;  Hu	 MLM;c r	 IH$   	 Hu،	 MLM;c rČ	 I(H$   H$   R	 H$   HL$`	 HH$(  H@H} rHMHMII;}HH33	 H'H=А	  tE3Ő	 HE3E3l	 HH8	 HtlHOH9O ~HHGHHAHGHHX	 uHHCHP0H4h
 H     @  "Hh
 Hy     @  Hu
HGHP0HtHu
HCHP0L
9 D  H
	 `IHHuHGHP0H$   9	 H$   *	 H\$8Ht.Ht$@H;tD  H	 H(H;uH\$8HmS Ll$8Ll$@Ll$HHL$ TS HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ   S E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   V	 H$   G	 E3E3HT$`HK HHL$ d H\$xHt,H$   H;tH	 H(H;uH\$xHYR Ll$xL$   L$   HL$`:R 3	 HHu'He
 H`      	 7A    H\$8H;\$@ve	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8v	 HtH;t$ t	 L;  Hu	 MLM;c r	 IH$   {	 HuȈ	 MLM;c r	 I(H$   H$   B	 H$   HL$`	 HH$(  H@H} rHMHMII;}HH33}	 H'H=	  tE3	 HE3E3\	 HH(	 HtlHOH9O ~HHGHHAHGHHH	 uHHCHP0H$d
 H 
     AA  "H d
 Hi 
     ?A  Hu
HGHP0HtHu
HCHP0L
) D
 | H
%	 PIHHuHGHP0H$   )	 H$   	 H\$8Ht.Ht$@H;tD  H	 H(H;uH\$8H]O Ll$8Ll$@Ll$HHL$ DO HL$   I[0Ik@IA^A]A\_^HHHUVWATAUAVAWH   HD$PHXHLE3DxAOO Ht
HL$ HIHD$ L|$8L|$@L|$HM   N HtL0IIM~M~ M~(Ǆ$      HL$X	 HCH;#	    H;	 t{HH	 HHu+L
(b
 L

 A/   D 
 ,S     H@L   Mu4L
a
 L
F
 A/   D
 .S   g  HIMHlMuEH	 H9CuH;so  HCH<HHH,H;sQ  H} HHHHAHH   ILHt
HuHQR0HH$   WhHHL$X`	 H$   	 Ç	 Hu5HT$XH$   	 HHL$ }f H$   ~	 L
`
 L
+
 A0   D
 YS  s O[	 HtvHG	 HHtr	 XL
`
 L

 A/   DY
 IS  " HuHCHP0L

 D0
  H
	 Hu
HCHP0HT$ I MtI$uID$IP0HL$X	 H\$8Ht)H|$@H;tHr	 H(H;uH\$8HK L|$8L|$@L|$HHL$ K IH$   Hİ   A_A^A]A\_^]HT$WH0HD$ H\$PHHD$@    IH HHE HK	 H	 HH\$PH0_HT$WH0HD$ H\$PHHD$@    IH/ HHtE HKQ	 HH	 HH\$PH0_LD$WH0HD$ H\$HIHD$@    I HHE HO	 Hہ	 HH\$HH0_HL@WHpHD$ HXHp )pIf(HǄ$       HHPI_ H^3$   H\$(H$   HD$0HSHCHD$@HT$Ht$PHT$8HL$( HH8D H	 H
	 HL\$pI[Is((t$`I_HT$WH0HD$ H\$PHHD$@    IH HHTM HK	 H	 HH\$PH0_HT$WH0HD$ H\$PHHD$@    IH HHL HK1	 H(	 HH\$PH0_LD$WH0HD$ H\$HIHD$@    I HHwL HO	 H	 HH\$HH0_LD$WH0HD$ H\$HHt$XIHD$@    L$@HT$@I] HT$@HN] HHK HN6	 H-	 HH\$HHt$XH0_++++HL@HHUWATAVH  )p)xD)@D)xD)hD)XD)HD)8D)BtB|IMLLFfEWA\Y5
 D%
 fA.D-2
 z#u!D=%
 fA(fAT\DX  D=
 f(f(fATfATf/fD($  EY$  v
H$  H$  DfE.z	ufA(@f/v
H$  H$   A^YAXzE L$  f(AYfE.z?u=fA/v   f(fn^X^fA(Y\DX$fA/wfAWXfA(D^A\DXI;EHE\E}  H$  H$  H$  H$  HI\L$  H,   L$x  HD)$   D5
 L,IIVHHI+L$  H$  L<    fE.z'u%fE/vfA(fA(  fA(fA(   fE.z"u fE/fA(v
fA(   fA(   fA(fA(fATfATf/v_fE(E^fA(AYAXC fE/vfAWH$  L$  H$  fA(^IVf(AYfAWVfA(A^f(YAXsC fE/vfAWH$  L$  H$  fA(^IVYfAWI;KAf(f(YYf(Y\YYYfD(X\XYYDYf(f(\YYAXf(YD\DS~f(f(YKAY\KH;}fD(YDYfEWH   HL$0Ht$8Ht$@fAWt$ HL$0H$   L$   |$(HH$   Hl$PHHAHt$XHBHAHL$0HBHHT$hHHALD$ HBHAH$   HBHT$PH$   H$    H$  L$  H$  IVHHMII;/D($   L$x  L$  H$  H$  L$  A(sA({E(CE(KE(SE(xE(hE(XE(8IA^A\_]HWH   HǄ$   HXHhHpHٹ   A 3Ht
HL$PHHHD$PHl$hHl$pHl$x   NA Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HKJ HHL$PI H$   HtLH$   H;t:HYHHt@ H+HkHkHK@ H0HCH;uH$   @ H$   H$   H$   H$   f@ HT$PHL$  HL$ ]HHu<L
T
 L
{
 
   
 ;@  ;@  A  H
5	 HHL$8HtKH|$@H;t<HYD  HHt? H+HkHkHK? H0HCH;uHL$8? Hl$8Hl$@Hl$HHL$ ? HL$hHtLH|$pH;t=HYfD  HHto? H+HkHkHK[? H0HCH;uHL$hD? Hl$hHl$pHl$xHL$P+? HL$   I[IkIs I_HWH   HǄ$   HXHhHpHٹ   > 3Ht
HL$PHHHD$PHl$hHl$pHl$x   > Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HKGH HHL$P H$   HtLH$   H;t:HYHHt)> H+HkHkHK> H0HCH;uH$   = H$   H$   H$   H$   = HT$PHL$ + HL$ A[HHu<L
Q
 L

 m
   7
 @  @  A  H
	  HHL$8HtKH|$@H;t<HYD  HHtO= H+HkHkHK;= H0HCH;uHL$8$= Hl$8Hl$@Hl$HHL$ = HL$hHtLH|$pH;t=HYfD  HHt< H+HkHkHK< H0HCH;uHL$h< Hl$hHl$pHl$xHL$P< HL$   I[IkIs I_[HHHUVWATAUAVAWH  HǄ$   HX)pLHE3D`AL$,< Ht
HL$@HIHD$@HL$@۞ HD$pƀ   HD$pH@HD$pH HD$pH@Ld$xMIH\$0H= Ǆ$     IIM   ; Ht
H$   HIH$   L$   L$   L$      p; Ht
H$   HIH$   L$   L$   L$   H$X  p	 IEH;t	    H;t	 txIIv	 HHu'HN
 H
 
 T  [
 p  M  H@H   HD$ Hu5HjN
 H
 U
 T  
 r    IIE 3HD$ JLH$   HuTHt	 H9Eu&L;e  HEJ<HIHH$   2L;e  H9HIHH$   HHH  ILHt
HuHAP03HLu	 98uIG   ?  IEHHpHtHAHt
IIHII<jHHQ  HGL   MtHi
 HAH2L@@MtHN
 H HAHH8
 Hws	 HH  Hu
HGHP0HFL   MtH|
 HAH2L@@MtHa
 H HAHHK
 H
s	 HH<  Hu
HFHP0IEHHpHtHAHt
IIHII(iHH  HFL   MtHm
 HAL2L@@MtHR
 H HALH<
 Hcr	 LMG  Hu
HFHP0   r	 HH  HxLp 3E3HHHD$0Ht
HuHAP03HH$   HHH$    HS0H$    H$@  Htq7 3H$@  H$H  H$P  H$(  J7 H$  Ht87 H$  H$  H$   H$   7 q	 H   IH$  QHH$X  l	 H$  Wm	 aq	 H   H$X  HL$@趍 HH$   H HK0H$    H$   HD$ H\$0H
 H
q	 H	\q	 L-J
 L
 
 U  
     HJ
 Ho
 
 W  
   ]  HI
 HH
 
 W  
   6  HI
 H!
 
 V  m
     HI
 H
 |
 V  F
      HjI
 H
 U
 V  
      HCI
 H
 .
 V  
      HI
 H
 
 V  
   vHH
 Ha
 
 V  
   Ro	 H  H}q	 HHJtn	 p  HH
 H

 
 T  Y
   HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIu
IFIP0Hn	 H8LwHLgPLoX3HGHHGPHGXMtIMtI$MtIE MMIH課   m	 H
	 m	 HHOHHoPHwXLwHLgPLoXHt
HuHQR0HtHE u
HEHP0HtHu
HFHP0HuH
&n	 (m	 Hm	 Hu
HCHP0H\$0L$      HE u
HEHP0HD$@L$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   I( HT$@IK MtIu
IGIP0HtHuHCHP0H$X  2i	 H$   Ht2 E3L$   L$   L$   H$   s2 H$   Hta2 L$   L$   L$   H$   <2 HT$pHHD$@HHH\$(HD$ (D$ fD$ Hu|i	 HT$pHD$@H;uOHHtH;tZi	 HT$pH;u2HRHL$@ L\$pM[Ll$xHD$pH HD$pH@   H|$ H\$(@ HtH;t i	 H;   (t$ Huh	     th	 gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$@r =HL$p0 Ll$pLl$xHL$@0 IH$  ($  H  A_A^A]A\_^]HHHUVWATAUAVAWH  HǄ$   HX)pLHE3D`AL$l0 Ht
HL$@HIHD$@HL$@ HD$pƀ   HD$pH@HD$pH HD$pH@Ld$xMIH\$0H} Ǆ$     IIM   / Ht
H$   HIH$   L$   L$   L$      / Ht
H$   HIH$   L$   L$   L$   H$X  d	 IEH;h	    H;h	 txIIj	 HHu'HB
 HO
 
 f  
     M  H@H   HD$ Hu5HB
 H
 
 f  _
 "     IIE 3HD$ JLH$   HuTHCh	 H9Eu&L;e  HEJ<HIHH$   2L;e  H9HIHH$   HHH  ILHt
HuHAP03Hi	 98uIG   ?  IEHHpHtHAHt
IIHII|^HHQ  HGL   MtH
 HAH2L@@MtH
 H HAHHx
 Hg	 HH  Hu
HGHP0HFL   MtH
 HAH2L@@MtH
 H HAHH
 HJg	 HH<  Hu
HFHP0IEHHpHtHAHt
IIHIIh]HH  HFL   MtH
 HAL2L@@MtH
 H HALH|
 Hf	 LMG  Hu
HFHP0   Df	 HH  HxLp 3E3HHHD$0Ht
HuHAP03HH$   |HHH$   ) HS0H$    H$@  Ht+ 3H$@  H$H  H$P  H$(  + H$  Htx+ H$  H$  H$   H$   S+ e	 H   IH$  8FHH$X  >a	 H$  a	 e	 H   H$X  HL$@趄 HH$   H3 HK0H$    H$   HD$ H\$0H$
 H
5f	 H	e	 Lm>
 L
 X
 g  "
 R     HF>
 H
 1
 i  
 ~   ]  H>
 H
 

 i  
 }   6  H=
 Ha
 
 h  
 k     H=
 H:
 
 h  
 h      H=
 H
 
 h  _
 f      H=
 H
 n
 h  8
 c      H\=
 H
 G
 h  
 `   vH8=
 H
 #
 h  
 ^   Rc	 H  He	 HHtb	 p  H<
 HM
 
 f  
 =   HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIu
IFIP0Hb	 H8LwHLgPLoX3HGHHGPHGXMtIMtI$MtIE MMIH   a	 H
	 a	 HHOHHoPHwXLwHLgPLoXHt
HuHQR0HtHE u
HEHP0HtHu
HFHP0HuH
fb	 ha	 H]a	 Hu
HCHP0H\$0L$      HE u
HEHP0HD$@L$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   Ih HT$@I MtIu
IGIP0HtHuHCHP0H$X  r]	 H$   Ht& E3L$   L$   L$   H$   & H$   Ht& L$   L$   L$   H$   |& HT$pHHD$@HHH\$(HD$ (D$ fD$ Hu]	 HT$pHD$@H;uOHHtH;t]	 HT$pH;u2HRHL$@ L\$pM[Ll$xHD$pH HD$pH@   H|$ H\$(@ HtH;t@]	 H;   (t$ Hu']	     t]	 gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$@ =HL$p% Ll$pLl$xHL$@$ IH$  ($  H  A_A^A]A\_^]@SH HYHtHIz H$ H [HX PH   )p)xD)@D)HD)PD)XD
g
 fEWfA(fA(fE(D)`D)l$PD)t$@D5a
 fD(fA(D)|$0fATf/fD(fA(AYL$(   D$   fff     AXfD/   DXf(f(θ   AXAXA\DYfA(D  tYtY3fA(LD$ H$   $   ^f(AX f(fD(fATf/
p
    $   f(" Y|$(AYYA^f(fATf/$   'D(l$PD(t$@D(|$0L$   fA(A(sA({E(CE(KE(SE([E(cIH
 H
[
  HUVWATAUAVAWH  HǄ$h  HX)p)xHL   " Ht
H$   H3H$   H$   : H$   ƀ   H$   H@H$   H H$   H@HǄ$          "" Ht
H$   H3H$   H$   Ʉ H$0  ƀ   H$0  H@H$0  H H$0  H@HǄ$8      3H$   HT$`H$@  W	 3E3L$  E33H;-[	 uELυ	 H	 H

^	 H	$^	 L
5
 Lv
 
 	  
 P  e  L&
 Ho
 HwTHHu'H
4
 H
1
 
 	  }
 R  d  H\Du2R[	 Ht'H4
 H
 q
 	  ;
 T  d  Hu
HCHP0E'H;-[	 u>H	 H
[	 H	]	 L,4
 L
 
 
  
 a  d  H
 HY	 HHu'H3
 HV
 
 
  
 c  #d  H\Du2wZ	 Ht'H3
 H
 
 
  `
 e  c  Hu
HCHP0EgH;-(Z	 u>HG	 H
0Z	 H	7\	 LP3
 L
 ;
   
 r  c  H
 H Y	 HHu'H3
 Hz
 
   
 t  Gc  HHL$h:HH$@  U	 HL$hvU	 Y	 Ht'H2
 H
 
   i
 v  b  Hu
HCHP0IOH$@  T	 H;-#Y	 u>Hj	 H
+Y	 H	2[	 LK2
 L
 6
    
   b  H
 HX	 HHu'H2
 Hu
 
   
   Bb  H
 H;uA      3HLW	 H9BE3H9CADteLCL;BtE3   B 8C tE3   IuE   CJ;tt
tE3   H HK  E3Ai3L
W	 I;tE3Z3I;AtE3HA   HoV	 LH7a  HDIE u
IUIR0L$  E
a  Hu
HCHP0E  H

 9HHu'H
0
 H

 
 
  _
   `  H@L   MtH
 HAL2L@@MtH
 H HALH
 HV	 LMu'H*0
 H
 
 
  
   u`  Hu
HGHP0IEL   MtH
 IAH2L@@MtH
 H IAHH
 I!V	 HHu'H/
 H
 
 
  O
   _  IE u
IEIP0E3H;-V	 u>H	 H
V	 H	&X	 L?/
 L
 *
 
  
   _  H
 HU	 LHu'H /
 Hi
 
 
  
   K_  E3L$  LgHS	 I9$y  LwL$  Md  H_IHHHHuHAP0LcHT	 I9$   Lt$PLl$XE3EAHT$PHˋHHu'HL.
 H
 7
 
  
   ^  Iu
IFIP0E3L$  IE u
IEIP0E3L$        %T	 HHu'H
-
 H
?
 
 
  
   !^  LpE3L$  Lh E3L$  E3HH:HHu'H{-
 H
 f
 
  0
   ]  Hu
HFHP03VIHHHu'H--
 H
 
 
  
   c]  IE u
IEIP0E3L$  Hu
I$HP03HCHR	 H;.  H;R	 !  HT	 LHu'H,
 H
 
 
  [
   \  Hu
HCHP0IEH   E3IHHtrA   IHHt_IHAT$Ny'H+,
 H
 
 
  
   v\  IE u
IEIP0HǄ$         IE u
IEIP0E3MuIDH+
 H&
 
 
  r
   \  HKHtVH~A   H	 H
QR	 H	T	 
HxH]+
 H
 H
 
  
   [  H;u
H{Hs HCH8HpHHHu
HCHP0HH$   3Ht$`3HL$hHH$   H;tmH$   HL$HH$   HT$@H	HL$8HT$0(D$@fD$@(L$0fL$0LL$@LD$0H$   H$    HH$    H$   LHD$hLHH\$8HD$0(D$0fD$@HuM	 H$   HD$hH;ubHMtL;tM	 H$   L;uBHRHL$h L$   M[HǄ$       H$   H H$   H@   Ld$@H\$HMtM;tNM	 I;   (t$@Mu5M	     t&M	 eHC    u-HH     u     HH     tH\$H+HC    uH;XuHH@    tHHD$Hft$0LD$0H$   HL$h ?H$    HǄ$       HǄ$       HL$h HT$`HL$h_HH$    H$   HD$8HL$hHL$0H HD$HHL$@(D$0fD$0(L$@fL$@LL$0LD$@H$   HL$h H$   v HǄ$       HǄ$       HL$hT IO0H$   w IOpH$   v L$  H;-N	 u>HF	 H
N	 H	P	 L'
 L@
 
   
 7  MX  H
 HM	 HHu/H'
 H
 
   M
 9  L$  W  HL	 H9Cus
H#O	 f(=i
 f.z<u:M	 Ht/H-'
 H
 
   
 ;  L$  [W  Hu
HCHP0A   H;-M	 u>H\	 H
M	 H	O	 L&
 L.
 
   z
 H  ;W  HV
 HL	 HHu/H&
 H
 q
   ;
 J  L$  V  HHL$h-HH$@  H	 HL$hH	 L	 Ht/H!&
 H
 
   
 L  L$  OV  Hu
HCHP0I   H$@  H	 H;-L	 u>Hl	 H
L	 H	N	 L%
 L
 
   b
 Y  #V  H>
 H}K	 HHu/Hn%
 H
 Y
   #
 [  L$  U  HNAAu:K	 Ht/H %
 H
 
   
 ]  L$  NU  Hu
HCHP0E   H;-K	 u>H	 H
K	 H	M	 L$
 L#
 
   o
 j  0U  H
 HJ	 HHu/H{$
 H
 f
   0
 l  L$  T  H[AAu:J	 Ht/H-$
 H
 
   
 n  L$  [T  Hu
HCHP0E   H;-J	 u>Hև	 H
J	 H	L	 L#
 L0
 
   |
 {  =T  H
 HI	 HHu/H#
 H
 s
   =
 }  L$  S  H
 H~HHu/HB#
 H
 -
   
   L$  pS  Hu
HCHP0H"LI	 Ht'H"
 HW
 ٽ
   
   dS  Hu
HFHP03A   H;-fI	 u>Hņ	 H
nI	 H	uK	 L"
 L
 y
   C
   S  H
 H^H	 HHu'HO"
 H
 :
   
   R  HHL$hR)HH$@  XD	 HL$hD	 H	 Ht'H!
 H[
 ݼ
   
   hR  Hu
HFHP03I   H$@  C	 H;-\H	 u>H	 H
dH	 H	kJ	 L!
 L
 o
   9
   Q  H=
 HTG	 HHu'HE!
 H
 0
   
   Q  H-Àu2G	 Ht'H!
 Hj
 
   
   wQ  Hu
HFHP03A  H;-yG	 u>H(	 H
G	 H	I	 L 
 L

 
   V
   Q  H
 HqF	 HHu'Hb 
 H˽
 M
   
   P  H

 趇HHu/H' 
 H
 
   
   L$  UP  H
 H{HHu/H
 HJ
 ̺
   
   L$  P  Hu
HCHP0A   HHD	 HHu/H
 H
 s
   =
   L$  O  Hu
HFHP03Hu
HGHP03HDDy/H&
 H
 
   
   L$  TO  Hu
HCHP0Ee(  H;-E	 u>Hm	 H
E	 H	G	 L
 L'
 
   s
   4O  H׼
 HD	 HHu/H
 H
 j
   4
   L$  N  HX
 HGD	 HHu/H8
 H
 #
   
   L$  fN  Hu
HCHP0Hٹ
 HC	 HHu/H
 HJ
 ̸
   
   L$  N  Hu
HGHP03HDDu:QD	 Ht/H
 H
 p
   :
   L$  M  Hu
HCHP0E   H;-C	 u>H	 H
C	 H	F	 L
 L
 

   
   M  H8
 HB	 HHu/H
 HI
 ˷
   
   L$  M  H
 HB	 HHu/H
 H
 
   N
   L$  L  Hu
HCHP0H
 HQB	 HHu/HB
 H
 -
   
   L$  pL  Hu
HGHP03H`CDu:B	 Ht/H
 HO
 Ѷ
   
   L$  L  Hu
HCHP0E$  H;-XB	 u>H	 H
`B	 H	gD	 L
 L
 k
   5
   K  H
 HPA	 HHu/HA
 H
 ,
   
   L$  oK  H
 H	A	 HHu/H
 Hc
 
   
   L$  (K  Hu
HCHP0Hý
 H@	 HHu/H
 H
 
   X
   L$  J  Hu
HGHP0H
 HuHHu/HM
 H
 8
   
   L$  {J  Hu
HCHP0HD@	 Ht/H
 Hb
 
   
   L$  <J  Hu
HGHP0A(  H;-k@	 u>H~	 H
s@	 H	zB	 L
 L
 ~
   H
   	J  H
 Hc?	 HHu/HT
 H
 ?
   	
   L$  I  H-
 H?	 HHu/H

 Hv
 
   ¼
   L$  ;I  Hu
HGHP0H
 H>	 HHu/H
 H
 
   k
   L$  H  Hu
HCHP0H?؃u:)?	 Ht/H]
 HƵ
 H
   
   L$  H  Hu
HGHP0A,  H;->	 u>HF}	 H
>	 H	@	 L
 L`
 
   
 )  mH  H
 H=	 HHu/H
 H!
 
   m
 +  L$  G  H
 H=	 HHu/Hq
 Hڴ
 \
   &
 -  L$  G  Hu
HGHP0H
 H)=	 HHu/H
 H
 
   Ϻ
 0  L$  HG  Hu
HCHP0H:>؃u:=	 Ht/H
 H*
 
   v
 3  L$  G  Hu
HGHP0A0  H;-3=	 u>H{	 H
;=	 H	B?	 L[
 Lĳ
 F
   
 @  F  Ht
 H+<	 HHu/H
 H
 
   ѹ
 B  L$  _F  H
 H;	 HHu/H
 H>
 
   
 D  L$  F  Hu
HGHP0H
 H;	 HHu/H~
 H
 i
   3
 G  L$  E  Hu
HCHP0HNÀu:;	 Ht/H"
 H
 

   ׸
 J  L$  eE  Hu
HGHP0A4  H;-;	 u>H[z	 H
;	 H	=	 L
 L%
 
    q
 W  2E  Hղ
 H:	 HHu/H}
 H
 h
    2
 Y  L$  D  HV
 HE:	 HHu/H6
 H
 !
    
 [  L$  dD  Hu
HGHP0H
 H9	 HHu/H
 HH
 ʮ
    
 ^  L$  
D  Hu
HCHP0H:؃u:R:	 Ht/H
 H
 q
    ;
 a  L$  C  Hu
HGHP0A8  H;-9	 u>Hx	 H
 :	 H	<	 L 
 L
 
 !  ն
 n  C  H9
 H8	 HHu/H
 HJ
 ̭
 !  
 p  L$  $C  H
 H8	 HHu/H
 H
 
 !  O
 r  L$  B  Hu
HGHP0H
 HR8	 HHu/HC
 H
 .
 !  
 u  L$  qB  Hu
HCHP0Hc9؃u:8	 Ht/H
 HS
 լ
 !  
 x  L$  -B  Hu
HGHP0A<  H;-\8	 u>Hsw	 H
d8	 H	k:	 L
 L
 o
 "  9
   A  H
 HT7	 HHu/HE
 H
 0
 "  
   L$  A  H
 H
7	 HHu/H
 Hg
 
 "  
   L$  ,A  Hu
HGHP0H
 H6	 HHu/H
 H
 
 "  \
   L$  @  Hu
HCHP0HwÀu:7	 Ht/HK
 H
 6
 "   
   L$  @  Hu
HGHP0A@  H;-6	 u>Hu	 H
6	 H	8	 L
 LN
 Ъ
 #  
   [@  H
 H5	 HHu/H
 H
 
 #  [
   L$  ?  H
 Hn5	 HHu/H_
 HȬ
 J
 #  
   L$  ?  Hu
HGHP0H
 H5	 HHu/H
 Hq
 
 #  
   L$  6?  Hu
HCHP0H4	 H9Guw
H6	 f(f.z<u:a5	 Ht/H
 H
 
 #  J
   L$  >  Hu
HGHP0AH  H;-5	 u>Hlt	 H

5	 H	7	 L-
 L
 
 $  
   >  HF
 H3	 HHu/H

 HW
 ٨
 $  
   L$  1>  Hǩ
 H3	 HHu/H

 H
 
 $  \
   L$  =  Hu
HGHP0H`
 H_3	 HHu/HP

 H
 ;
 $  
   L$  ~=  Hu
HCHP0Ha2	 H9Guw
H4	 f(f.z<u:3	 Ht/H
 HF
 ȧ
 $  
   L$   =  Hu
HGHP0AP  H;-M3	 u>Hr	 H
U3	 H	\5	 Lu
 Lީ
 `
 %  *
   <  H
 HE2	 HHu/H6
 H
 !
 %  
   L$  y<  H
 H1	 HHu/H
 HX
 ڦ
 %  
   L$  <  Hu
HGHP0H0
 H1	 HHu/H
 H
 
 %  M
   L$  ;  Hu
HCHP0H0	 H9Guw
H3	 f(f.z<u:1	 Ht/H%
 H
 
 %  ڮ
   L$  h;  Hu
HGHP0AX  H;-1	 u>HLq	 H
1	 H	3	 L

 L&
 
 &  r
   3;  H֨
 H0	 HHu/H~

 H
 i
 &  3
   L$  :  HW
 HF0	 HHu/H7

 H
 "
 &  
   L$  e:  Hu
HGHP0H
 H/	 HHu/H	
 HI
 ˤ
 &  
   L$  :  Hu
HCHP0H1؃u:S0	 Ht/H	
 H
 r
 &  <
   L$  9  Hu
HGHP0A`  H;-/	 u>Ho	 H
0	 H	2	 L!	
 L
 
 '  ֬
   9  H:
 H.	 HHu/H
 HK
 ͣ
 '  
   L$  %9  H
 H.	 HHu/H
 H
 
 '  P
   L$  8  Hu
HGHP0H
 HS.	 HHu/HD
 H
 /
 '  
   L$  r8  Hu
HCHP0HT0؃u:.	 Ht/H
 HT
 ֢
 '  
   L$  .8  Hu
HGHP0Ad  H;-].	 u>Hdn	 H
e.	 H	l0	 L
 L
 p
 (  :
   7  H
 HU-	 HHu/HF
 H
 1
 (  
   L$  7  H
 H-	 HHu/H
 Hh
 
 (  
   L$  -7  Hu
HGHP0H@
 H,	 HHu/H
 H
 
 (  ]
   L$  6  Hu
HCHP0H.؃u:-	 Ht/HO
 H
 :
 (  
   L$  6  Hu
HGHP0Ah  H;-,	 u>Hl	 H
,	 H	.	 L
 LR
 Ԡ
 )  
 &  _6  H
 H+	 HHu/H
 H
 
 )  _
 (  L$  5  H
 Hr+	 HHu/Hc
 H̢
 N
 )  
 *  L$  5  Hu
HGHP0H4
 H+	 HHu/H
 Hu
 
 )  
 -  L$  :5  Hu
HCHP0H*	 H9Guw
H,	 f(f.z<u:e+	 Ht/H
 H
 
 )  N
 0  L$  4  Hu
HGHP0Ap  H;-	+	 u>H`k	 H
+	 H	-	 L1
 L
 
 *  
 =  4  HJ
 H*	 HHu/H
 H[
 ݞ
 *  
 ?  L$  54  H˟
 H)	 HHu/H
 H
 
 *  `
 A  L$  3  Hu
HGHP0H
 Hc)	 HHu/HT
 H
 ?
 *  	
 D  L$  3  Hu
HCHP0HE
 H^HHu/H
 Hg
 
 *  
 G  L$  ,3  Hu
HGHP03H-Ds)	 Ht/H
 H
 
 *  \
 J  L$  2  Hu
HCHP0Ex  H;-)	 u>Hi	 H
!)	 H	(+	 LA
 L
 ,
 +  
 W  2  HZ
 H(	 HHu/H
 Hk
 
 +  
 Y  L$  02  H۝
 H'	 HHu/H
 H$
 
 +  p
 [  L$  1  Hu
HCHP0H
 Hs'	 HHu/Hd
 H͞
 O
 +  
 ^  L$  1  Hu
HGHP03Hs&	 H9Cus
H(	 f(f.z<u:'	 Ht/H 
 HX
 ڛ
 +  
 a  L$  1  Hu
HCHP0A  H;-_'	 u>Hh	 H
g'	 H	n)	 L 
 L
 r
 ,  <
 n  0  H
 HW&	 HHu/HH 
 H
 3
 ,  
 p  L$  v0  H!
 H&	 HHu/H 
 Hj
 
 ,  
 r  L$  /0  Hu
HCHP0Hj
 H%	 HHu/H H
 
 ,  _
 u  L$  /  Hu
HGHP03H$	 H9Cus
H#'	 f(f.z<u:&	 Ht/H5 H
  
 ,  
 x  L$  c/  Hu
HCHP0A  H;-%	 u>Htf	 H
%	 H	'	 L L6
 
 -  
   C/  H
 H$	 HHu/H H
 y
 -  C
   L$  .  Hg
 HV$	 HHu/HG H
 2
 -  
   L$  u.  Hu
HCHP0H
 H#	 HHu/H HY
 ۘ
 -  
   L$  .  Hu
HGHP0H

 ,eHHu/H H
 
 -  R
   L$  -  Hޛ
 HYHHu/HW H
 B
 -  
   L$  -  Hu
HGHP0A   HHe"	 HHu/H Hg
 
 -  
   L$  ,-  Hu
HCHP0Hu
HFHP03H輝؅y/H H
 
 -  T
   L$  ,  Hu
HGHP0  H;-#	 u>Hd	 H
#	 H	%	 L8 L
 #
 .  
   ,  HQ
 H"	 HHu/H Hb
 
 .  
   L$  <,  Hҗ
 H!	 HHu/H H
 
 .  g
   L$  +  Hu
HGHP0H
 Hj!	 HHu/H[ HĘ
 F
 .  
   L$  +  Hu
HFHP03Hy"؃u:!	 Ht/H  Hi
 
 .  
   L$  C+  Hu
HGHP0A  +  H;-m!	 u>Hb	 H
u!	 H	|#	 L L
 
 /  J
   +  H
 He 	 HHu/HV H
 A
 /  
   L$  *  H/
 H 	 HHu/H Hx
 
 /  ĝ
   L$  R*  Hu
HGHP0H؜
 H	 HHu/H H!
 
 /  m
   L$  )  Hu
HFHP0H

 `HHu/He HΖ
 P
 /  
   L$  )  HF
 HTHHu/H H
 

 /  Ԝ
   L$  M)  Hu
HFHP0A   HH-	 HHu/H H/
 
 /  {
   L$  (  Hu
HGHP03Hu
HCHP0H脙؅y'Hg HЕ
 R
 /  
   (  Hu
HFHP03)  H;-	 u>H%`	 H
	 H	 	 L Lo
 
 0  
   |(  H
 H	 HHu'H H0
 
 0  |
   =(  H
 H	 HHu/H H
 s
 0  =
   L$  '  Hu
HFHP0H
 H@	 HHu/H1 H
 
 0  
   L$  _'  Hu
HCHP0HB	 H9Fuv
H	 f(f.z4u2	 Ht'H H'
 
 0  s
   4'  Hu
HFHP0A  p'  H;-1	 u>H^	 H
9	 H	@	 LY L
 D
 1  
   &  HZ
 H)	 HHu'H H
 
 1  ϙ
   &  H
S
 n]HHu/H HH
 ʐ
 1  
   L$  
&  Hx
 HHQHHu/H H
 
 1  N
   L$  %  Hu
HCHP0A   HH	 HHu/H@ H
 +
 1  
   L$  n%  Hu
HFHP03Hu
HGHP03HDy/H HG
 ɏ
 1  
   L$  %  Hu
HCHP0E  H;-N	 u>H\	 H
V	 H	]	 Lv Lߑ
 a
 2  +
 (  $  H
 HF	 HHu/H7 H
 "
 2  
 *  L$  e$  H
 H	 HHu/H HY
 ێ
 2  
 ,  L$  $  Hu
HCHP0H
 H	 HHu/H H
 
 2  N
 /  L$  #  Hu
HGHP03HDu:		 Ht/H= H
 (
 2  
 2  L$  k#  Hu
HCHP0E   H;-	 u>Hn[	 H
	 H		 L L@
 
 3  
 ?  M#  H
 H	 HHu/H H
 
 3  M
 A  L$  "  H
 H`	 HHu/HQ H
 <
 3  
 C  L$  "  Hu
HCHP0Hʔ
 H		 HHu/H Hc
 
 3  
 F  L$  ("  Hu
HGHP03HDu:j	 Ht/H H
 
 3  S
 I  L$  !  Hu
HCHP0E$  H;-	 u>HY	 H
	 H		 L8 L
 #
 4  
 V  !  HQ
 H	 HHu/H Hb
 
 4  
 X  L$  '!  Hb
 H	 HHu/H H
 
 4  g
 Z  L$     Hu
HCHP0H{
 Hj	 HHu/H[ Hč
 F
 4  
 ]  L$     Hu
HGHP0HL
 HKHHu/H Hn
 
 4  
 `  L$  3   Hu
HCHP0H}	 Ht/H H
 
 4  f
 c  L$    Hu
HGHP0A(  H;-#	 u>H2X	 H
+	 H	2	 LK L
 6
 5   
 p    Hd
 H	 HHu/H Hu
 
 5  
 r  L$  O  Hu
 H	 HHu/H H.
 
 5  z
 t  L$    Hu
HGHP0H
 H}	 HHu/Hn H׋
 Y
 5  #
 w  L$    Hu
HCHP0H>Àu:	 Ht/H H{
 
 5  Ǒ
 z  L$  U  Hu
HGHP0A,  H;-	 u>HV	 H
	 H		 L L
 
 6  a
   "  Hŋ
 H|	 HHu/Hm H֊
 X
 6  "
   L$    H֐
 H5	 HHu/H& H
 
 6  ې
   L$  T  Hu
HGHP0HO
 H	 HHu/H H8
 
 6  
   L$    Hu
HCHP0H	 H9Guw
HJ	 f(f.z<u:(	 Ht/H\ Hŉ
 G
 6  
   L$    Hu
HGHP0A0  H;-	 u>H+U	 H
	 H		 L L]
 ߆
 7  
   j  H

 H	 HHu/H H
 
 7  j
   L$    H
 H}	 HHu/Hn H׈
 Y
 7  #
   L$    Hu
HGHP0HG
 H&	 HHu/H H
 
 7  ̎
   L$  E  Hu
HCHP0H(	 H9Guw
H	 f(f.z<u:p	 Ht/H H

 
 7  Y
   L$    Hu
HGHP0A8  H;-	 u>HS	 H
	 H	#	 L< L
 '
 8  
     HU
 H	 HHu/H Hf
 
 8  
   L$  @  Hf
 H	 HHu/H H
 
 8  k
   L$    Hu
HGHP0H
 Hn	 HHu/H_ HȆ
 J
 8  
   L$    Hu
HCHP0Hp	 H9Guw
H	 f(f.z<u:	 Ht/H HU
 ׃
 8  
   L$  /  Hu
HGHP0A@  H;-\	 u>HR	 H
d	 H	k	 L L
 o
 9  9
     H
 HT	 HHu/HE H
 0
 9  
   L$    H
 H
	 HHu/H Hg
 
 9  
   L$  ,  Hu
HGHP0H
 H
	 HHu/H H
 
 9  \
   L$    Hu
HCHP0H	 H9Guw
H"	 f(f.z<u: 	 Ht/H4 H
 
 9  
   L$  w  Hu
HGHP0AH  H;-
	 u>H{P	 H

	 H		 L L5
 
 :  
   B  H
 H	 HHu/H H
 x
 :  B
   L$    H
 HU	 HHu/HF H
 1
 :  
   L$  t  Hu
HGHP0H/
 H	 HHu/H HX
 ڀ
 :  
   L$    Hu
HCHP0H 	 H9Guw
Hj
	 f(f.z<u:H	 Ht/H| H
 g
 :  1
   L$    Hu
HGHP0AP  H;-	 u>HN	 H
	 H	
	 L L}
 
 ;  Ɉ
     H-
 H
	 HHu/H H>
 
 ;  
   L$    H>
 H
	 HHu/H H
 y
 ;  C
   L$    Hu
HGHP0H
 HF
	 HHu/H7 H
 "
 ;  
   L$  e  Hu
HCHP0HH		 H9Guw
H	 f(f.z<u:
	 Ht/H H-
 ~
 ;  y
   L$    Hu
HGHP0AX  H;-4
	 u>H[M	 H
<
	 H	C	 L\ Lŀ
 G~
 <  
     Hu
 H,		 HHu/H H
 ~
 <  ҆
   L$  `  H
 H	 HHu/H H?
 }
 <  
   L$    Hu
HGHP0H_
 H	 HHu/H H
 j}
 <  4
   L$    Hu
HCHP0H	؃u:	 Ht/H& H
 }
 <  ۅ
   L$  i  Hu
HGHP0A`    H;-	 u>HK	 H
	 H	
	 L L$
 |
 =  p
 2  1  H
 H	 HHu/H| H~
 g|
 =  1
 4  L$    H
|
 HHHu/H9 H~
 $|
 =  
 6  L$  g  Hj
 H<HHu/H H\~
 {
 =  
 8  L$  !  Hu
HCHP0A   HH	 HHu/H H~
 {
 =  O
 ;  L$    Hu
HGHP03Hu
HFHP03HVDy/H8 H}
 #{
 =  
 >  L$  f  Hu
HCHP0E  H;-	 u>HJ	 H
	 H		 L L9}
 z
 >  
 K  F  H}
 H	 HHu/H H|
 |z
 >  F
 M  L$    Hy
 HY	 HHu/HJ H|
 5z
 >  
 O  L$  x  Hu
HCHP0H
 H	 HHu/H H\|
 y
 >  
 R  L$  !  Hu
HFHP0H{
 HL:HHu/H H|
 y
 >  R
 U  L$    Hu
HCHP0H=	 Ht'HI H{
 4y
 >  
 X    Hu
HFHP03A$  H;-	 u>H`H	 H
	 H		 L LR{
 x
 ?  
 e  _  H|
 H	 HHu'H H{
 x
 ?  _
 g     Hx
 Hz	 HHu/Hk Hz
 Vx
 ?   
 i  L$  
  Hu
HFHP0Hy
 H#	 HHu/H H}z
 w
 ?  ɀ
 l  L$  B
  Hu
HCHP0H4؃u2	 Ht'H H$z
 w
 ?  p
 o  1
  Hu
HFHP03A   H;-3	 u>HF	 H
;	 H	B	 L[ Ly
 Fw
 @  
 |    Htz
 H+	 HHu'H Hy
 w
 @  
 ~    Hv
 H	 HHu/H HFy
 v
 @  
   L$    Hu
HFHP0HVx
 H	 HHu/H Hx
 qv
 @  ;
   L$    Hu
HCHP0H؃u2	 Ht'H- Hx
 v
 @  ~
     Hu
HFHP03A(  H;-	 u>HE	 H
	 H		 L L6x
 u
 A  ~
   C  Hx
 H 	 HHu'H Hw
 yu
 A  C~
     Ht
 H^ 	 HHu/HO Hw
 :u
 A  ~
   L$  }
  Hu
HFHP0Ht
 H 	 HHu/H Haw
 t
 A  }
   L$  &
  Hu
HCHP0H؃u2k 	 Ht'H Hw
 t
 A  T}
   
  Hu
HFHP03A,  H;- 	 u>H.D	 H
 	 H	&	 L? Lv
 *t
 B  |
   	  HXw
 H HHu'H  Hiv
 s
 B  |
   v	  Hqs
 H HHu/H H*v
 s
 B  v|
   L$    Hu
HFHP0H{
 Hy HHu/Hj Hu
 Us
 B  |
   L$    Hu
HCHP0H؃u2 Ht'H Hzu
 r
 B  {
     Hu
HFHP03A0  H;- u>HB	 H
 H	 	 L Lu
 r
 C  f{
   '  Hu
 H HHu'Hr Ht
 ]r
 C  '{
     Hq
 HB HHu/H3 Ht
 r
 C  z
   L$  a  Hu
HFHP0H<r
 H HHu/H HEt
 q
 C  z
   L$  
  Hu
HCHP0H؃u2O Ht'H Hs
 nq
 C  8z
     Hu
HFHP03A4  H;- u>HbA	 H
 H	
 L# Ls
 q
 D  y
     H<t
 H HHu'H HMs
 p
 D  y
   Z  HUp
 H HHu/H Hs
 p
 D  Zy
   L$    Hu
HFHP0H&v
 H] HHu/HN Hr
 9p
 D  y
   L$  |  Hu
HCHP0H_ H9Fuv
H f(f.z4u2 Ht'H HDr
 o
 D  x
   Q  Hu
HFHP03A8  H;-Q u>H?	 H
Y H	` Ly Lq
 do
 E  .x
     Hr
 HI HHu'H: Hq
 %o
 E  w
     Hn
 H
 HHu/H Hdq
 n
 E  w
   L$  )  Hu
HFHP0Hs
 H HHu/H H
q
 n
 E  Yw
   L$    Hu
HCHP0HttÀu2 Ht'HH Hp
 3n
 E  v
     Hu
HFHP03A@  H;- u>Hw>	 H
 H	 L LQp
 m
 F  v
   ^  Hq
 H HHu'H Hp
 m
 F  ^v
     Hm
 Hy HHu/Hj Ho
 Um
 F  v
 
  L$    Hu
HFHP0HSs
 H" HHu/H H|o
 l
 F  u
 
  L$  A  Hu
HCHP0H$ H9Fuv
H f(f.z4u2l Ht'H H	o
 l
 F  Uu
     Hu
HFHP03AH  H;- u>H<	 H
 H	% L> Ln
 )l
 G  t
     HWo
 H HHu'H Hhn
 k
 G  t
   u  Hpk
 H HHu/H H)n
 k
 G  ut
 !  L$     Hu
HFHP0HQm
 Hx HHu/Hi Hm
 Tk
 G  t
 $  L$     Hu
HCHP0H؃u2 Ht'H Hym
 j
 G  s
 '     Hu
HFHP0AD     H H6m
 j
   s
   L$  HtHu
HCHP0HtHu
HGHP0MtIE u
IEIP0MtIu
IFIP0HtHu
HFHP0D$(    D$    L
l
 Dj
 r
 H
:	 :H$   Ht
HuHAP0HL$`HtHuHAP0H$@   H$0  HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   g H$0  蒺 HǄ$0      HǄ$8      H$   m H$   HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   Dg H$    HǄ$       HǄ$       H$   ޹ L$  I[@A(sA({IA_A^A]A\_^]@SH HYHtH) H荹 H [HHHUVWATAUAVAWHp  HǄ$P  HX)pL   f 3Ht
H$   HHH$   H$8  H$@  H$H  H$  L    Ht
H$   HHH$   H$    H$  ƀ   H$  H@H$  H H$  H@H$     謸 Ht
H$   HHH$   H$   R H$   ƀ   H$   H@H$   H H$   H@H$   HLH=Kn
 HH
m
  HHtH H'HHu*H H i
 f
   lo
 :  E3?  HCL   MtHf
 HAL2L@@MtHf
 H HALHf
 H LMu'H4 Hh
 f
   n
 :  a  Hu
HCHP0ID$L   MtHh
 IAH2L@@MtHg
 H IAHHg
 I* HHu*H Hh
 e
   Xn
 :  E3
  I$uID$IP0LHkH H9E M  LcM@  H{I$HHHHuHAP0HoH( H9E usL$   L$   E3EAH$   Hc'HHu'H HMg
 d
   m
 :  	  I$uID$IP0E3M       HHu'H
 H
f
 xd
   Bm
 :  	  L`E3IE Lh E3HH )HHu'HA Hf
 ,d
   l
 ;  Y	  Hu
HFHP0E3I=IH*HHu'H HXf
 c
   l
 :  	  E3Hu
HE HP0IHGH H;%  H;~   Ho LHu'H He
 kc
   5l
 &;    Hu
HGHP0ID$H   IIHHtg   IHHtUIHȍUy'H Hpe
 b
   k
 .;  4  I$uID$IP0M   I$uID$IP0McuH'2H H	e
 b
   Uk
 6;    HOHtVH~A   H`	 H
4 H	c 
Hx1H@ Hd
 +b
   j
 ;  X  H;u
H_Hw HGHHpHHHu
HGHP0H$  LHHL$@vHH$   H;tmH$  HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$   _ HH$   ^ HT$pLHD$@HHH\$(HD$ (D$ fD$0Hu HT$pHD$@H;uRHHtH;t HT$pL;u5HRHL$@t L\$pM[E3Ll$xHD$pH HD$pH@   H|$0H\$8HtH;tM I;   (t$0Hu4     t% dHC    u,HH     u    HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@m @E3HL$p Ll$pLl$xHL$@ HHL$@oHH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$   ] HH$   _ HT$pHHD$@HHH\$(HD$ (D$ fD$0Hu HT$pHD$@H;uOHHtH;t HT$pH;u2HRHL$@r L\$pM[Ll$xHD$pH HD$pH@   H|$0H\$8    HtH;t@ H;   (t$0Hu'     t gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@k =HL$p Ll$pLl$xHL$@ L$   L$   HT$@H$  HIu HH$   ؇ HL$XHt贮 Ll$XLl$`Ll$hHL$@蛮 H
b
 )HHu'HT H_
 ?]
   	f
 a;    H@L   MtHb
 HAH2L@@MtHb
 H HAHHa
 H[ HHu'H H=_
 \
   e
 c;    Hu
HFHP0H$   HHu'H H^
 s\
   =e
 f;    MHkH H9E O  LcMB  H{I$HHHHuHAP0HoH" H9E uxLd$ Ht$(E3EAHT$ HfHHu'H HP^
 [
   d
 z;     I$uID$IP0H  HFHP0|      LHu'H
 H
]
 m[
   7d
 ;     L`MHp IE3HHHHu$H7 H]
 "[
   c
 ;  RI   IFIP0   HH!HH   H HL]
 Z
   c
 s;  HtHu
HGHP0HtHu
HCHP0E3E3MtI$uID$IP0HtHu
HFHP0MtIu
IFIP0L
\
 DCZ
 c
 H
=	 @I Hu
HFHP0Hu
HE HP0H$  Ht
HuHAP0MtIuIGIP0H$   LH$   HHH\$(HD$ (D$ fD$0HuG H$   H$   H;uaHHtH;t H$   L;uAHRH$   am L$   M[L$   H$   H H$   H@   Ht$0H\$8    HtH;t I;   (t$0Hu     t gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$   f :H$   y L$   L$   H$   \ H$  HD$(H$   HL$ H H$   H$   (D$ fD$ ($   f$   LL$ L$   H$   H$   $V H$   L$  L$  H$   ƨ H$8  Ht賨 L$8  L$@  L$H  H$   莨 HH$  ($`  Hp  A_A^A]A\_^]HHHUVWATAUAVAWH   HǄ$   HXHLE3DxAOA Ht
HL$ HIHD$ L|$8L|$@L|$HM    HtL0IIM~M~ M~(Ǆ$        ݧ Ht
HL$PHIHD$PL|$hL|$pL|$xHGH;<    H;7 t{HH  HHu+L
A L
X
 A/   DV
 
T  ^
   H@L   Mu4L
 L
_X
 A/   DU
 T  ^
   HIMHl@ MuEH H9GuH;w  HGHHHH,H;w  H] HHHHAHH   ILHt
HuHQR0HH$   @HHL$P讀 H$   HtG L$   L$   L$   H$   "  Hu]HT$PH$   Y[ HHL$ k H$   Ht L$   L$   L$   H$   迥 L
 L
V
 A0   DoT
 7T  8]
 O  HtvH HH>t7 XL
F L
V
 A/   DT
 'T  \
 HuHGHP0L
pV
 DS
 \
 H
LD	 :Hu
HGHP0HT$ IXO MtI$uID$IP0HL$hHtͤ L|$hL|$pL|$xHL$P贤 HL$8HtFH|$@H;t7HYHHt莤 L;L{L{HKz H0HCH;uHL$8c L|$8L|$@L|$HHL$ J IH$  H   A_A^A]A\_^]H\$ WH Hu LD$0HT$8HL$@ H{HHtHt Hأ LD$0HT$8HL$@H HK3HtH{HuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  @SH HYhHtHf H} H [LL$ LD$HL$SVWATAUAVAWH   HǄ$   L   V HtHL$0H33HHD$0Ht$HHt$PHt$XLHt$(    Ht
HL$`HHHD$`Ht$xH$   H$   HU
 HH
UW
 O HHtH HBHHu'Hc HR
 NP
   Y
 3    HGL   MtH,U
 HAH2L@@MtHU
 H HAHHT
 Hj HHu'H HLR
 O
   X
 3  >  Hu
HGHP0HHt$ LsH I9Y  H{H|$ HG  LcHI$HIHuHAP0Mt$Hc I9usH$   L$   E3EAH$   ILHu'H
  H
Q
 O
   W
 *3    Hu
HGHP0HHt$        LHu'H
ɳ H
2Q
 N
   ~W
 83  $  HxHHt$ ILx E3HI8LHu'Hy HP
 dN
   .W
 >3     IE u
IEIP0LHt$(:IHLHu'H$ HP
 N
   V
 $3     Hu	IHP0ID$L   MtHP
 IAH2L@@MtHrP
 H IAHH\P
 I HHuFH HO
 M
   IV
 D3  M  I$  ID$IP0  I$uID$IP0HH$   HHL$`ew H$   Ht> H$   H$   H$   H$     Ht'H۱ HDO
 L
   U
 G3  6  Hu
HCHP0HH$   HT$`HL$0v H$0  RAAu22 Ht'Hf HN
 QL
   U
 S3     H$8  IRAAu/ Ht$H HN
 L
   T
 T3  yHT$0H$   l EEHH$   HI0  HH   H HN
 K
   kT
 [3  3H|$ H$   Ll$(HtHu
HGHP0HtHu
HCHP0MtIE u
IEIP0L
M
 D3K
 T
 H
)	 1HHL$xHt? Ht$xH$   H$   HL$`  HL$HHt Ht$HHt$PHt$XHL$0 HH   A_A^A]A\_^[LD$HT$HL$SVWATAUAVAWH  HǄ$@     蹛 HtH$   H33HH$   H$  H$   H$(     v Ht
H$   HHH$   H$   H$   H$   LH\$    / Ht
HL$hHHHD$hH$   H$   H$       Ht
HL$8HHHD$8H\$PH\$XH\$`LH5N
 HH
4P
 . HHtH H!
HHu'HB HK
 -I
   Q
 3    HGL   MtHN
 HAL2L@@MtHM
 H HALHM
 HI LMu'H­ H+K
 H
   wQ
 3  !  Hu
HGHP0HH$  M|$H I9r  I|$H$  H\  It$HHILHuHAP0L~H; I9u~H$0  H$  H$8  E3EAH$0  Ho
HHu'H
 H
YJ
 G
   P
 3    Hu
HGHP0HH$         LHu'H
 H
I
 G
   KP
 3    HxHH$  H$  H IE E3IHHHu'H; HI
 &G
   O
 4  6  IE u
IEIP0LH\$ ?H$  I
HHu'H HJI
 F
   O
 3    I$u	IIP0HFL   MtHJI
 HAL2L@@MtH/I
 H HALHI
 H LMu'HQ HH
 <F
   O
 4  L  Hu
HFHP0IH$   HHL$hCp H$   Ht H$   H$   H$   H$     Ht'H H"H
 E
   nN
 
4    I$uID$IP0LH$   HT$hH$   o H$  mK@@u2 Ht'H? HG
 *E
   M
 4    H$   H$H   DLH$   H$  HI躬 HHL$8o H$   Ht H$   H$   H$   H$   Е HT$8H$   n H
I
 HHu'Hv HF
 aD
   +M
 &4  q  H@L   MtH?I
 HAL2L@@MtH$I
 H HALHI
 H} LMu'H H_F
 C
   L
 (4    Hu
HFHP0H$   HHu'H HF
 C
   _L
 +4    HM}H I9Y  I}HL  M}HIIMHuHAP0IOH$  H> H9u~H|$(Ht$0E3EAHT$(ILHu'H HmE
 B
   K
 ?4     Hu
HGHP0H  HFHP0L$         LHu'H
 H
E
 B
   NK
 O4     HxHp E3HILHu'HT HD
 ?B
   	K
 U4     Iu
IFIP0L$  fHILHu9H  HiD
 A
   J
 84  Ht_HuYHFHP0MHuHFHP0L$  IE    IIP0   3H$  L$   Ll$ MHtHu
HGHP0MtI$uID$IP0MtIE u
IEIP0MtIu
IFIP0L
C
 DA
 I
 H
O 	 'LHL$PHt$ H\$PH\$XH\$`HL$8 H$   Ht H$   H$   H$   HL$h֑ H$   HtÑ H$   H$   H$   H$   螑 H$  Ht苑 H$  H$   H$(  H$   f IHĀ  A_A^A]A\_^[@SH HYhHtHyU H
 H [LI[IkIsWATAUAVAWH`H- H5 E3MHLIkIsMcM'  LrIMt0Ht!HtH'  Hr(IsHj Hl$HLbLd$@Ih HIMtHt,HtOvHHB
 I LHD$@H   HHj  HF
 I HtHHD$HHHA  HC
 I HtHHD$PHH  Hy	 LL$@H
=
 HD$(E3ILt$  y
2     Ht$PHl$HLd$@   HBH   H   H   HKH}   L
<	    L
<	 HL$0H
 HH	Ll H IDL	 HD$(HT$ H<	  2  L
ɢ H
	 Aa  F
 =
 a  L
@
 P$3Hr(Hj LbLLII?L\$`I[0Ik8Is@IA_A^A]A\_LI[IkIsI{ ATAUAVHPH=\ 3MHLI{IsM   LjIMt!HtH   Hz I{HrHt$@I HIMtHt&MH?
 I HHD$@H   HH.  HD
 IR HtHHD$HHH  H"	 LL$@H:
 HD$(E3ILl$ y
3     H|$HHt$@   HBH   H   HKH}   L
:	    L
:	 HL$0H
 HH	LD H IDL	 HD$(HT$ H[:	  3  L
 H
z	 A  ^D
 ;
   L
=
 ("3Hz HrLHIL\$PI[ Ik(Is0I{8IA^A]A\@UVWATAUAVAWH   HǄ$  H$`  L   L E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HL$p  L$h  II    Ht
H$   HIH$   L$   L$   L$      ċ Ht
H$   HIH$   L$   L$   L$   H$    3 LHu'H H<
 :
   B
 <    I_0HCH; t|H; tsHH HHu'H
Þ H
,<
 9
   xB
 <  %  H@L   Mu-H H;
 w9
   AB
 <    HILdMuEH4 H9CuH;{  HCH4HHI,H;{  I4$HHIHAHHu  H$h  H$h  Ht
HuHQR0HFL   MtH>
 HAH2L@@MtH=
 H HAHH=
 H	 HH   E3Hs:
 H#HH   Hu
HVHR03INI9N ~HE IFH,HAIFHI) uHE u
HEHP03H Ho:
 7
   @
 <  E3e  Hܜ HE:
 7
   @
 <  E3;  H H:
 7
   g@
 <  E3  I HtHH5 HH"t` *H_ H9
 J7
   @
 <  E3  Hu
HCHP0E3IL$p  IHL$`!9HH$    B H|$xHt4L$   I;t     H H(I;uH|$xH Ll$xL$   L$   HL$`· \ Ht'H H8
 {6
   E?
 =  G  IW8HL$`2HH$   1 HL$xHtNL$   I;t<HyD  HHtO L/LoLoHO; H0HGI;uHL$x$ Ll$xL$   L$   HL$`  Ht'Hǚ H08
 5
   |>
 =  ~  ALD$ H$   H$    3r LHu'Hs H7
 ^5
   (>
 =    HL$8HH\$@H;v۽ H\$@HL$8HD$ HD$PH|$X(D$PfD$PH|$PLd$XL$h  D  H;v HtH;|$ t L;  Huo E3LM;c r[ IH$    Hu? E3LM;c r+ I(H$   H$  HC$   H$   HHu7L
` L
6
 ;4
 2   =
 P  P  D@2H
!	 Ht  ILH$h  Ht
HuHAP0HCL   MtH7
 HAH2L@@MtHm7
 H HAHHW7
 H HH   E3H:
 H8HH   Hu
HCHP03INI9N ~HE IFH,HAIFHI> u"HE u
HEHP03H\$@HL$8H Hz5
 2
   ;
 "=  E3sH HS5
 2
   ;
 =  E3LH× H,5
 2
   x;
 =  E3%H H5
 2
   Q;
 =  E3MtIu
IFIP0HtHu
HCHP0HtHu
HFHP0HtHE u
HEHP0L
4
 D2
 :
 H
	 ME3H$p  Ht
HuHAP0H$h  HtHuHAP0H$   n H$   HtLH$   H;t:HYHHt辂 L+LkLkHK誂 H0HCH;uH$   萂 L$   L$   L$   H$   k H$   Ht3H$   H;t@ HǸ H(H;uH$   H* L$   L$   L$   H$    H\$8Ht-H|$@H;t@ Hg H(H;uH\$8H́ Ll$8Ll$@Ll$HHL$ 贁 IH$`  H   A_A^A]A\_^]H\$ WH H LD$0HT$8HL$@P H{hHHtHE HH LD$0HT$8HL$@H$ HK3HtH{HuHAP0HK HtH{ HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  HL@HPHHUVWATAUAVAWH  HǄ$(  HX MMHLE3Dd$hH$  HL$p9 AL$ Ht
HL$8HIHD$8IH\$PIHL$XLd$`ILd$0H$   H+$   HH  H;r HL$XH\$PH$   L9,M  HuIHT$`H+HHH+HH;sH1HHL$XH\$P  HH;v HL$XH\$PHl$8H$   H$   HH+HuI$H;vP HtH;l$8t> H+H($   f$@  LL$0A   H$@  HL$8I> H\$PLHL$XH;v HL$XH\$PHl$8Hu׵ E3HL$XH\$PHD$8LII;S wHt	HE E3E3IH;Ps HL$XH\$PE3HHt$0H$   H+$   HH;gH$  IH$   H+$   HH$   Ht=H;r- H$   H4HH$   H+$   HH;rHL$XH\$PIH+HHt[H;r H\$PHH$   H+$   HH;r H$   L$HHD$XH\$PH+HHH;r   7} Ht
H$   HIH$   Ld$0LD$0HH$    [ IHt=    H$   H$   H+HH;r H$   HHH;rH5	 H$  H$  IH$    LL$pH$  LIH$P  a L$   LIH$   E H
 H$   L$   L$   H$  H$  fWD$0H$  H$      | Ht
H$  HIH$  LD$0IH$  Y H$p  H$   H$  HD$0H$  H$0  H$8  H$@  H$p  H$   H$x  H$   H$  H$  H$  H$  H$  t H=$H
 H$  H$(  H$  H$0  H$  H$8  H$  H$@  H$   H$  H$   H;
 H$  H$x  H$  H$  H$  H$  H$  H$  H$   # H$  H$0   H$  H$X  H$  H$`  H$  H$h  H$  H$p  H$  V H$  H$   H$  H$  H$  H$  H$   H$  H$(  H$  H$0  " H$  H$`   H$8  H$  H$@  H$   H$H   H$p  HD$ L$  L$  H$8  H$`  0< HI D$h   H$x  Hty L$x  L$  L$  H$`  x H56	 H$@  H$p   H$   L$h  L$   H$x   H$h  H$`  H$(  Htwx L$(  L$0  L$8  H$  Rx H$   H$  Ht8x L$  L$  L$  H$  x H$  HtLH$  H;t:HYHHtw L#LcLcHKw H0HCH;uH$  w L$  L$  L$  H$  w H$p  H$X  Ht{w L$X  L$`  L$h  H$@  Vw H$   H$  Ht<w L$  L$  L$  H$  w H$  HtLH$  H;t:HYHHtv L#LcLcHKv H0HCH;uH$  v L$  L$  L$  H$  v H$  H$  Htv L$  L$  L$  H$p  Zv H$P  H$   Ȭ H$  H$   Ht)v L$   L$   L$   H$   v HL$PHtu Ld$PLd$XLd$`HL$8u H$   Htu L$   L$   L$   HL$pu I  IH$  HĐ  A_A^A]A\_^]HL$SVWATAUAVAWHp  HǄ$P  )$`  Hڹ   Xu HtH$   HE3E3IH$   H$     H$   ƀ   H$   H@H$   H H$   H@L$(     t Ht
H$   HIH$   H$     H$   ƀ   H$   H@H$   H H$   H@L$   Lt$HILt$@IL$  MMMHKHu'H Hg%
 "
   +
 #    AH  Ht	H[H43Y HHuIHH HHu
HGHP0Hu'Hy H$
 d"
   .+
 $  @
  H\$HH$H  H=)
 HH
)
  LHtH HLMu'H Hz$
 !
   *
 $  	  IEL   MtHB"
 IAL2L@@MtH'"
 H IALH"
 I LMu'H H#
 |!
   F*
 $  m	  IE u
IEIP0ID$L   MtHp#
 IAL2L@@MtHU#
 H IALH?#
 I LMu*H Hh#
  
   )
 $  I	  I$uID$IP0ML$  IuHܪ H9T  MeL$  M?  I}I$HILHuHAP0HwHu H9uoLd$PH\$XE3EAHT$PHHHu'H
; H
"
 & 
   (
 +$    I$uID$IP0ML$        . LHu'H
߄ H
H"
 
   (
 9$    L`ML$  HHX E3HHKHHu'H H!
 w
   A(
 ?$  S  Iu
IGIP0M:HIHHu'H= H!
 (
   '
 %$    IE u	HIP0MHCH H;-  H;ϩ    H LHu'Hу H:!
 
   '
 `$    Hu
HCHP0ID$H   IILHto   ILHt]IHȍWy'HX H 
 C
   
'
 h$  4  I$uID$IP0ML$     I$uID$IP0M謤uHpH HR 
 
   &
 p$    HKHtVH~A   H	 H
} H	 
HxH H
 t
   >&
 K$  P  H;u
LkL{ HCL(LxIE IHu
HCHP0IHT$@H$@  MIL$  L$0  ML$8  HL$`1HH$   H;tmH$   HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$    HH$    H$   LHD$`HHH\$(HD$ (D$ fD$0Hu H$   HD$`H;u`HHtH;tŤ H$   L;u@HRHL$`
0 L$   M[3H$   H$   H H$   H@   H\$8H|$0HtH;t^ I;   (t$0HuE     t6 eHC    u-HH     u     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$`( ?3H$  H$   "l H$   H$   HL$`l HHL$`o;HH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$    HH$    H$   LHD$`HHH\$(HD$ (D$ fD$0Hu H$   HD$`H;uaHHtH;t H$   L;uAHRHL$`- L$   M[E3L$   H$   H H$   H@   H\$8H|$0HtH;t/ I;   (t$0Hu     t fHC    u.HH     uf     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$`& >E3H$  H$   i L$   L$   HL$`i p  i HD$0HtL$   H$   H LMH$  LXAM[  E3H
 H
H
 HHucH4} H
 
    
 $  HtHu
HCHP0M   IE u
IEIP0H$  Ht$@   E3E33HXHu
HCHP0H| H
 
   f 
 $  Ht$@?E3H$H  HD$HH$@  H$0  L$  L$8  
H$  Ht$@MtI$uID$IP0MtIu
IGIP0L

 D
 
 H
 AHt$@EHL$HHt
HuHAP0HtHu
HFHP0HtHuHGHP0H$   LH$   HHH\$(HD$ (D$ fD$0Hu H$   H$   H;uaHHtH;t H$   L;uAHRH$   5* L$   M[L$   H$   H H$   H@   H\$8H|$0HtH;t I;   (t$0Hur     tc bHC    u*HH     uD  HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$   " ?H$   Yf L$   L$   H$   <f H$   HD$(H$   HL$ H HD$XHL$P(D$ fD$ (L$PfL$PLL$ LD$PH$   H$    H$   e L$   L$(  H$   e A($`  Hp  A_A^A]A\_^[+HL$UVWATAUAVAWH   HǄ$   H$  HE3ML$  AN[e Ht
HL$PHIHD$PLt$hLt$pLt$xMII   "e Ht
HL$ HIHD$ Lt$8Lt$@Lt$H3 LHu'Hx H
 
   J
 n>  g  HFH;J t|H;I tsHH2 HHu'H
Cx H

 .
   
 t>    H@L   Mu-Hx Hu
 
   
 v>    HILlMuEH H9FuH;n  HFHHHI,H;n  I] HHIHAHH  ILHt
HuHQR0HCL   MtH
 HAH2L@@MtH
 H HAHHl
 H HH   E3H
 HHH   Hu
HSHR03IL$I9L$ ~HID$H<HAID$HI uHu
HGHP03Hv H
 y
   C
 >  LE3  Hav H
 L
   
 >  L$  E3  H/v H
 
   
 >  L$  E3   HtPH HHwt՛ 2Hu H=
 
   
 >  L$  E3E  Hu
HFHP0E3IMIH$   HHL$ r H$   Ht6L$   I;t!    H H(I;uH$   HZa L$   L$   L$   H$   5a Û Ht'Ht H`
 
   
 >     HT$ HL$P HT$PH$   v< HH$   HI2 ȉ$   LH   Ht H
 j
   4
 >  MtI$uID$IP0HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
w
 D
 
 H
 MMtIE u
IEIP0MtIuIGIP0H\$8Ht)H|$@H;tHR H(H;uH\$8H_ Lt$8Lt$@Lt$HHL$ _ H\$hHt)H|$pH;tH H(H;uH\$hHk_ Lt$hLt$pLt$xHL$PR_ IH$  H   A_A^A]A\_^]HVWATAUAVH   HǄ$   HXHhHٹ   _ E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   V H$   G HT$`HKx HHL$ j H\$xHt.H$   H;tfH H(H;uH\$xH]^ Ll$xL$   L$   HL$`>^ 3 HHu'Hq Hd
 
   
 q?    H\$8H;\$@vi HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v HtH;t$ t L;  Hu MLM;c r IH$   { HuȔ MLM;c r I(H$   H$   B H$   HL$` HH$(  H@H} rHMHMII;}HH33} H'H=  tE3 HE3E3\ HH( HtlHOH9O ~HHGHHAHGHHH uHHCHP0H$p H

 
   
 {?  "H p Hi

 

   
 y?  Hu
HGHP0HtHu
HCHP0L
)

 D

 |
 H
 PIHHuHGHP0H$   ) H$    H\$8Ht.Ht$@H;tD  H H(H;uH\$8H][ Ll$8Ll$@Ll$HHL$ D[ HL$   I[0Ik@IA^A]A\_^H\$Ht$WH IHHMt7I H~)H E3HcuH\$0Ht$8H _HHH>Hu
HSHR0H\$0Ht$8H _;H\$Ht$WH    IHHr
30  H H
 E38  HH   H LHHCH HH Ht HC Hi H H_ HC(HT H HJ HC0H? H H5 HC8H* H H  HC@H H H HCHH  H H HCPH H H HCXH֓ H H̓ HC`H H !y"Hu
HCHP03H\$0Ht$8H _Ht$8HH\$0H _HWATAUAVAWH   HǄ$   HXHhHp LA   HHL$` H|$pLHt$hLHHH3HuH9H;v)  H<    H HHuHt)  H|$pHt$hHL$0Ll$8Lt$@IHtHtIHHH;t~)  Ht:HtIHHH;t\)  HtIHHH;t?)  HHMI;t%0 HtHZ  HHD$0HH\$0Ht$8H|$@HHHH+HLMHM~!fHD$`f(f)HI;}HL$0LHT$0HL$`  H$   HHuHI=II;v{(  HH} HHuHt[(  H$   Ht$HHl$PHtI;t4(  HtI;t(  ̄t(  H;t(H HtHiY  HHD$HHH\$HH|$PHHH+HLMHM~!f     HD$xf(f)HI;|LHT$HHL$x  HD$0H$0  MH$   H$0   > LHHiHuH/I;vR'  H<    HP HHuHt.'  HL$ Hl$(IE HxHtI;t'  HtI;t&  ̄t&  H;t HtH?X  HD$ H\$ H|$(HT$ Ia H$    DM9\$~IHM	 	 D  HD$ 1fT^fWAHIcI;D$|LD$ H$   HL$0< H$   HW HHxHtI;t&  HtI;t%  ̄t%  I;|$t!I$ HtH>W  I$I$I|$HHH+HLMM~$f     HE f(I$f)HI;|LIH  H$   p H$   a HL$ U HK HL$0? H$   0 HL$x% HL$` L$   I[0Ik8IsHIA_A^A]A\_HLH L@WATAUAVAWH  HǄ$  HXHp)pLE3L|$XL|$`L$P  L$   AO4S Ht
H$p  HIH$p  H$p  ڵ  H$  ƀ   H$  H@H$  H H$  H@L$     R Ht
H$  HIH$  H$  l  H$@  ƀ   H$@  H@H$@  H H$@  H@L$H  L$   ML$  I   BR Ht
H$  HIH$  L$  L$  L$  H
 HH
t
 n HHtH HaHHu'He H
 m 
 u  7	
 p!    HGL   MtH 
 HAL2L@@MtH 
 H HALH 
 H LMu'He Hk
  u  
 r!    Hu
HGHP0IFL   MtH
 IAH2L@@MtH
 H IAHH
 I HHu'Hrd H
 ] u  '
 u!    Iu
IFIP0ML|$PLgHW I9$\  LwLt$PMJ  H_IHHHHuHAP0LcH I9$uvL$`  L$h  E3EAH$`  H.HHu*H
c H

  u  d
 !  MR  Iu
IFIP0ML|$P       HHu*HUc H 
 @ u  

 !  M
  LpML|$PIE Lh E3HHHHu*Hc Hj 
  u  
 !  M  Hu
HFHP0I=IH~HHu*Hb H 
  u  d
 !  MR  Hu
I$HP0IHCHV H;1  H;> $  H/ LHu*H@b H + u  
 !  M  Hu
HCHP0IFH   MIHHtpA   IHHt]IHAT$}y*Ha H+  u  w
 !  Mz  Iu
IFIP0ML|$P   Iu
IFIP0MuIHWa H B u  
 !  M  HKHtYH~A   HG H
 H	 
Hx{H` H]  u  
 !  M  H;u
H{Hs HCH8HpHHHu
HCHP0HHD$XH$   IL|$xHt$`H$   I0  L H$   HtH[ HH$   IH$     L H$   HtH HHD$pIHL$pAH   E3H 
 H
 蚿HHu*H_ HD  y  
 "  M~  E3E33H8Hu
HCHP0H_ H | y  F
 	"  M  AH   E3HS H
L HHu*H8_ H # {  
 %"  M  E3E33HHu
HCHP0H^ HW  {  
 )"  MO  H\ H$P   HHu*H^ H  |  \
 ;"  MJ  H$P  H
% HHu*Ha^ H L }  
 G"  M  H@L   MtH HAH2L@@MtH| H HAHHf He HHu*H] HG  }  
 I"  M  Hu
HCHP0HFH;    H;{    HHD$hLHX HHu*Hi] H T }  
 P"  M  H@L   Mu?H/] H  }   
 R"  M  HHMMHD$hHu
HFHP0IL|$0Mu@H H9CuL;c   HCJ4HI  L;c}zJtHI  HAHHD$0H  = HtHH) HHtT *HS\ H > }   
 n"  M
  Hu
HCHP0L$   H$P  LHL;
̓ tUH; tLMIL H H
 H	 L[ L:     "  M2  HHL$p!%HT$XH$   oHH$p  H;tmH$  HL$(H$p  HT$ H	HL$HHT$@(D$ fD$ (L$@fL$@LL$ LD$@H$   H$p   HH$p   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Huf~ H$   H;ufH$   MtL;tA~ L;uIH$   HRH$   	 L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@t} H;\$H   (t$ Mu}     t} ]HC    u%HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$   H :H$   E L$   L$   H$   E HT$`H$   HH$  H;tsH$@  HL$HH$  HT$@H	HL$(HT$ (D$@f$   (L$ fL$@L$   LD$@H$  H$  5 HH$   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Hu| H$   H;ufH$   MtL;t{ L;uIH$   HRH$   5 L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@t{ H;\$H   (t$ Mun{     t_{ ^HC    u&HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$    9H$   SC L$   L$   H$   6C p  OC HD$ HtL$  H$p  HM LMAM   E3HB H
 ^HHu*HV H    T "  MB  E3E33HHu
HCHP0HUV H @   
 "  M
  AL$X  L;%| AǅP  3z HHu*HU H_     "  M  ID$H;{ t~H;{ tuI} HHu*HU H
    Y #  MG  H@L   Mu>HjU H U    #  M
  II$IHL$hMHMuHH{ H9FuH;N  HFH<HHHL$h3H;N   H|HHHL$hHAHHD$xH  H$  H$  Ht
HuHAP0HGL   MtH HAH2L@@MtH H HAHH Hz HH   E3HR HLH   Hu
HGHP0IL|$xHKH9K ~IHCL4HAHCIHz u"Iu
IFIP0ML|$PHL$hHS H'    s +#  Ma  HS H    I (#  M7  HjS H U    &#  M
  z HtHH{ HHty *HS H     #  M  Hu
HFHP0IL|$0H$   L$   LcIu*HR H$    p 9#  Ms  H$   I HH H+HHgfffffffHHHH?HAL;H$       H$   H$   BHH$  ! H$    x Ht*HR Hj     D#  M  H$  H$    HIN H$   LHT$pIE< DH誟HHu*HQ H v   @ o#  M.  HD$0HL$p蹗HHu,HJQ H 5    {#  Ld$0  HL$0HA8HHI8H9 uHAP0HD$0HX8H\$pHtH H= MtI蘒 I< MtIu
IGIP0Dd$PAu HHu,HP H    S #  Ld$0?     v HHu,H_P H J    #  Ld$0   HXLd$0I$L`   E3H$   HL$XH$   HD$`MH$   H|$xLt$PHt$0  E3H$   HD$XH$   HD$`MIH|$xLt$PHt$0w  H$   LH$   HtHu
HAP0LIIAL   MtH IAH2L@@MtH H IAHH Iu HHu*H&O H  ~   ~"  M   ML|$PHt H9GuLwLt$PMtqHwIHHHHuHAP0IHxHHu'HN H  ~  ^ "  MOIu
IFIP0ML|$PlHwHHu\HXN H C ~  
 "  MHtHu
HCHP0H   H   HGHP0   Hu
HGHP0IL|$xHu
HFHP0IL|$0E3H$   HT$XH$   HT$`MLt$PI(E3H$   HT$XH$   HT$`MLt$PIMtIu
IFIP0HtHu
HFHP0L
 D@  H
G IHL$XHt
HuHAP0HL$`Ht
HuHAP0H$P  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0MtI$uID$IP0H$  HtHuHAP0H$  Ht6H$  H;t!    Ho H(H;uH$  Hj8 L$  L$  L$  H$  E8 H$@  LH$  LHH\$HHD$@(D$@fD$ Huo H$@  H$  H;uaHMtL;tWo H$@  L;uAHRH$   L$@  M[L$H  H$@  H H$@  H@   H\$(H|$ HtI;tn I;   (t$ Hun     tn fHC    u.HH     uf     HH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$  Y 5H$@  6 L$@  L$H  H$  6 H$  HD$HH$p  HL$@H H$h  H$`  (D$@f$   ($`  fL$@L$   LD$@H$  H$p  ^ H$  6 L$  L$  H$p   6 HL$  I[0Is8A(sIA_A^A]A\_LI[IkIsWATAUAVAWH`L%5p 3MHLMcI{HI{Ml  LrIMt0Ht!HtHb  Lb(McHj Hl$HHzH|$@I=o HIMtHt,HtFmH Iq HHD$@H  HHA Iq HHD$HHtHH  H Igq HtLHD$PHH\  H LL$@H HD$(E3ILt$ y
*!     Ld$PHl$HH|$@  H
o H2 HD$0   H	HT$(   L
 Lb H HD$ q  !     HBH   H   HKH}   L
H    L
J HL$0H
vn L
 H	HH IDL HT$(H" HD$ p <!  L
cG H
 Ao  H o   L
 3Lb(Hj HzMLHIL\$`I[0Ik8Is@IA_A^A]A\_Hp	 HH%j H\$WH Hp	 HHj tH2 HH\$0H _Hip	 HH%j H\$WH H?p	 HHQj tHp2 HH\$0H _H\$WH Hp	 HHHAh Hj tH"2 HH\$0H _@SH Ho	 HHHArh HH [H%i HL$WH0HD$ H\$HHHli H$p	 HHOH,h HH\$HH0_@SH Ho	 HHHAg HH [H%3i H\$WH Ho	 HHHAg Hi tH"1 HH\$0H _HL$WH0HD$ H\$HHHh HTo	 HHSHO[g HH\$HH0_HL$WH0HD$ H\$HHHDh H\n	 HHSHOg HH\$HH0_́aI    H́aI   HHo	 H@SH Ho	 HHt/ HH [H(Ht
H   H(@SH Hko	 HHt/ HH [HL$HT$LD$LL$ HQo	 HH%g HIo	 H\$WH Ho	 HHf tH / HH\$0H _Hao	 H@SH HKo	 HHt. HH [@SH Hif Ljl	 LHH [HIo	 HHHHEB HL$ A   4f Ll	 H HL$ L\$ k. HL$WH0HD$ H\$HHHe Hk	 HHSHOd Hl	 HHH\$HH0_HfWE3I   H$I@HHH+LYHLRL    fD  AJBI I HAYKAYBXf(AJXABAYKAYCXXuH$M;s"H+JM+HIYHXuf(HH)f(
@n	 f(Hn	 f(pn	 f(n	 f f(fYfYfYfX
+n	 fX3n	 fYfYfXf(
?n	 fXf(Cn	 fYfXfYf(?n	 fXfYf(
?n	 fXfYf(On	 fXfYf(On	 fXfYf(
On	 fXfYfYfXfXf)$^D$HH)f(
 n	 f((n	 f(Pn	 f(n	 f f(fYfYfYfX
n	 fXn	 fYfYfXf(
n	 fXf(#n	 fYfXfYf(n	 fXfYf(
n	 fXfYf(/n	 fXfYf(/n	 fXfYf(
/n	 fXfYfYfXfXf)$^D$HHL$WH0HD$ H\$HHHb Hh	 HHSHOa Hh	 HHH\$HH0_AA @SH Hm	 HHt* HH [̋Q<A4A@    QHTQDHH%` Ham	 H3HAHAHAH\$WH HHIHHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHIHHPuHOHHPuH\$0H _ðH\$0H _Hh	 HHL$SH0HD$ HH_ Hi	 HH0[HL$WH0HD$ H\$HHH` Hf	 HHSHO_ Hg	 HHH\$HH0_̋   tt
tt3Ë   @SH HY` LBf	 LHH [HL$WH0HD$ H\$HHH` Hf	 HHSHO^ Hf	 HHH\$HH0_@SH Hl	 HHHA^ Le	 HLH [H%_ Hy8rHA HA @SH Hcl	 HHHA2^ HH [H%;_ @SH HKl	 HHHA^ Le	 HLH [H%9_ @SH H3l	 HHHA] HH [H%^ @SH H+l	 HHHA] HH [H%^ H   HD$ HAl	 HL$(>] HL$P^ Hd	 HD$PHT$(HL$h=] Hd	 HD$PH! HL$P& H   HD$ Hk	 HL$(\ HL$P^ H"d	 HD$PHT$(HL$h\ HMd	 HD$PH! HL$P;& H(HHHcHHLHHt
H\ H(LI@HI@    uHPHBI@HA0H;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI     uHPHBI@HA0H;PuL@ILBHBH;uL ILBL@ILB@SH H9 Hu\ HK    tHAHC    tH [H%a\ H    u/HH    u     HHI    tHCH [HI    uHH9CuHKHI    tHC    uHKH [@SH LHHuHRAHH [HHRHcHHAHH [HHHD$0D$    L
 L݃ 3 $ 2HHHHHD$0D$    L
D L 3# 2HHHHHD$0D$    L
< L] 3# 2HHHHHD$0D$    L
 L 3`# 2HHHHHD$0D$    L
\ L݂ 3 # 2HHHHHD$0D$    L
D L 3" 2HHHHHD$0D$    L
4 L] 3" 2HHHHHD$0D$    L
 L 3`" 2HHHHHD$0D$    L
4 L݁ 3 " 2HHHHHD$0D$    L
 L 3! 2HHHHHD$0D$    L
 L] 3! 2HHHHHD$0D$    L
 L 3`! 2HHHHHD$0D$    L
 L݀ 3 ! 2HHH\$Ht$WH HQ 3HH+Q   HHt'H;r+X HFHV HH+H|H;rH\$0Ht$8H _H`	 HH@WHPHD$ H\$`IHH_j	 HL$(V HHT$(HHL$(V LHASHHL$(rV HHT$(HHL$(xV Hqi	 HL$(FV HHT$(HHL$(LV Hh	 HL$(V HHT$(HHL$( V LHH\$`HP_IcH\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$Ht$WH HHHH;tp H(H;tdHH[T uHH(H;t2f     HH4T uH(HH(T H(H;uHG(H\$0Ht$8H _H\$0HHt$8H _Hl$Ht$ WAUAVH LI HIgfffffffL+IIMHIHHH?HtHuU HVHtS HN Iƿ   H+NHHHH?HH;skH\$@Ld$HDg'H;rT HFIHI!S HHS HN IH+NHI(HHHH?HH;rLd$HH\$@HR HHl$PHt$XH A^A]_H%R Hl$Ht$H|$ ATH HA MHH+AHHHtHuS HFH]R HF    H+FHH;sGH\$0H;rS H^IH/R HR HF H+FHHH;rH\$0H	R HHl$8Ht$@H|$HH A\H%Q H\$LLLM+HgfffffffHIHLI?IL;~HIHI+HHHH?HL+H\$KHL+I@SH AHD$@    A)   HOIc  HHh	 HQ HH [Hg	 H{Q HH [HKg	 HbQ HH [Hf	 HIQ HH [Hf	 H0Q HH [H0f	 HQ HH [He	 HP HH [H^e	 HP HH [He	 HP HH [   y  . G `  ı  ihQp%~W	 H8  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(ihQp%W	 H  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(H   "uf	 A))t$p)|$`D)D$PE f(f(D)L$@D)T$0D)\$ YD	f(AXYf(YfA(YDYf	 Ye	 YD^\fA(Ye	 ^fA(X^YD\YfA(AY\ 
e	 H$   Dqe	 D`e	 fA(0\f(H$   ^AXf(f(Y^fWA^fWf(YAXA^YAXYAYAXAYYAXYf/vf(f(f/v8f/v2f(YA^AXYAYAXYf/vf(f(f/v6f/v0f(YA^AXYAYAXYf/vf(f((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   H\$WH HH*N LV	 LHCHGHC H\$0HG HH _@WH0HA HH+AHHu
fWH0_H\$@)t$ HuM HGHO    H+H0H;s(H;rM HGHO HH+HXtH;rH\$@f((t$ H0_HA HHA@HHAXD H3HHHWH@  HD$ HXHH@       DBHL$@[K    HL$(RK HL$PHcQHLPHPHL$P7K HHL$@1K Ǆ$`     HL$@#K HH$X  H@  _3f(LHDIDA     A
 f/sffA;ufDAP
 f/sffA;ufDAAHkHfAB`
 HL$WH0HD$ H\$HHHDL HS	 HHSHOK HKU	 HHH\$HH0_AW	 f/ryf(f(YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^AV	 f/   f(f(YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^AU	 f/   f(f(YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^LL$ LD$HT$SVWH`H$   L$   HHME3HHHHHT$8Hg  H$   Ld$XLl$PKRLt$HL|$@IHJMIMHIMK,HMH$L|$0Ll$Hl$HL$E3I4  IKLHHL$ HHIM+HL$(JLH+H+MM+MELl$ IMHUH+L+Hl$(IEHHMLfD  KIHHpHBH HxI@I HAHEH M;HAIDHAHBHAHDHAHDHAKDHAHBHAI@HAKDHAHD/HAHBHAI@HAHEHAWL$   H$   Hl$Ll$L|$0H$HL$M;}_MIHML+H+H+M+JTOJL I
H HIHBHAHBHDHBHDHBuH$HL$IMIMHHl$Ll$H$HL$2H$   HT$8L$   L$   L|$@Lt$HLl$PLd$XH$   H;   HJ4    IH+H$   IfE3I|]MSJLHSIIN    M     HBH H IHAHBHAHBHAHBHAuH$   M;}JIIM;JD|HHH$   lH`_^[HL$WH0HD$ H\$HHHD HJ	 HHSHO{C HK	 HHH\$HH0_@SH HHt*H|$0CuHHPCu	HHPH|$0H [@SH HA HHA`    H+AHHuC HCHHKpHCPH+CHHHuC HCHHHKpHKhH [̋j f()f(
@	 ufo%@	 f%7 A fo%' f]-@	 f_-@	 fYfX
@	 fffT
@	 f\f(f(fY@	 fY
@	 f\f\f(fYf(f(fY@	 fY@	 fX@	 fX@	 fYfYfX@	 fX@	 fYfYfX@	 ff\ffrf^fpcfY@	 fX@@	 fYf_f(H\$WH0HA 3)t$ H+AfWHHHt,H;rLB HOHHDXpHG H+HH;rH\$@f((t$ H0_@SH HI	 HHt
 HH [H(HQHIN@ HO@ HH(H%I@ @SH HHQHI@ HH
@ H@ HH [H%@ HL$WH0HD$ H\$HHHY@ H)J	 Ht
H	 HHH\$HH0_H\$WH HN	 HHHA? L%G	 HL9A tHX	 HH\$0H _H\$WH HM	 HHHA? H@ tH	 HH\$0H _H\$WH HM	 HHHAL? L]F	 HL@ tH HH\$0H _H\$WH H_M	 HHHA> H? tHR HH\$0H _H\$WH H7M	 HHHA> H? tH HH\$0H _@SH HH	HtHP tH    H [@SH H9 Hu? HK    tH [H%? HA    u.H    uf     HH	    tHCH [HI    uHAH9CuHKHI    tHKH [HL$SH0HD$ H|< u
Hw< HHHcHHLHHt
H< H0[HHLHuKH HH3HIH(sE3HT$XHL$ LD$Xk> L4D	 H HL$ L\$  HHLHuJ    g HH3HIHsE3HT$XHL$ LD$X= LC	 Hu HL$ L\$  HHLHuJ     HH3HIHsE3HT$XHL$ LD$X= LTC	 H HL$ L\$  HHLHuK@H HH3HIH0sE3HT$XHL$ LD$X= LB	 H HL$ L\$ 2 HL$VWATAUAVH@HD$ H\$xDH3ۉ$   LHL$(HLc@ILHHtH: HHcH|1 uHL1PHt': HHcH|1 D$0   H|1(H3HϋD1%  @t=A      H~0HHcHT1XHL1H9 AD܉$   HA   HHcHAHL1Hs9 AD܉$   u/H~*HHcHT1XHL1HE9 AD܉$   HHt$p$   Ll$(HHcHHD1(    HHcHHE39 9 u
I8 IE HcHJL)HHtH9 HHH\$xH@A^A]A\_^HL$VWATAUAVH@HD$ H\$xLH3ۉ$   3HHHLiHHcHH|1(H~
I;~I+3LHt$(HL1HHtH8 HHcH|1 uHL1PHt08 HHcH|1 D$0u
      D1%  @t6H~-HHcHT1XHL1H7 u$   H΅u]HHcHMIHL1H7 I;t   $   2H~-HHcHT1XHL1Hd7 u$   HHHcHHD1(    Ht$p$   Ld$(HHcHHE37 7 u
I7 I$HcHJL!HHtH7 HHH\$xH@A^A]A\_^HWH  HD$ HXHhHpIIHHٺ   DBH^6 HH$   HH?X	 HHHH!X	 HHHȋU 6 HH$  }HT$hH$   5 HHL$(L8 H\>	 HD$(HHL$@	7 Hq>	 HD$(H HL$(w  HD@WHP  HD$0HhHpIHHD;$        DBHL$`U5 HW	 HL$`HHHHvW	 HH$  5 HH>W	 HT$8HL$`	5 HD$@H|$XHCD$@HD$ L
W	 L$p  HH(L$P  IkIsI_HD@WHP  HD$0HhHpIHHD;$        DBHL$`e4 HV	 HL$`HHHHV	 Hȋ$  14 HHOV	 HT$8HL$`4 HD$@H|$XHCD$@HD$ L
V	 L$p  HH9L$P  IkIsI_H\$WH HHP I$HHHj H
HH.4 H/4 HH\$0H _H%#4 ATAUAVAWH(HQ I*E3H+QIE3LHHHH?H   H\$PHl$XHt$`H|$ 3L;r.5 I~3۽   HL> H+L>HHt)H;r5 HD>HL> HH+HlH;rIN III+NDH0HHHH?HL;rH|$ Ht$`Hl$XH\$PAH(A_A^A]A\H(Hu3H(HH;vlH\$ H    He4 HuHtFH\$ H(H	 H\$Hl$Ht$WH HAIIHHHAH;t4H	3 HtHLHsH{HH    HsH{LALIH\$0Hl$8Ht$@H _H(y t	H	3 H(HH H\$Hl$Ht$ LD$WATAUAVAWH LT$xL$   Ht$pLIIHE3E3ۃH<HHH|$H  H$   MMlL+H    MxL+HL$L,$ILd$fff     L3H  H\$`IDkIkHL$LH|HNKTHIMHHHH    Lfff     IBHHpIBHxIHBIBMHBIEHBIEHBIE HBIEMHBID$HBID$HBI$HBID$MHBHGHBHGHBHHBHGIHHB_L,$H|$Ld$LD$`H;}RHKLL    HIITLL+OHBH HAHBHAHHAHBIIHAuLD$`HL$I IMI L;L,$oLT$xL$   I;   L$   L+M,LT$xD  ME3H   H~LHDm HIHHKLHL$    MMM\ I\ MfIH LHAHHHAI LHAILHHAuLT$xL$   L;}.IHL    HI+IL HIIHKDuIIH+I+LILT$xH\$PHl$XHt$hH A_A^A]A\_LL$ LD$SUVWATAULl$hH|$XLILL$`E3IIHH,HHH   HD$pLL$HILl$PH+L]H+IH4    HI    LH~<KN    IHfD  fH If)@fAIHf)@uLI IuH\$PHt$HLL$`Ll$hIH+H|UL\$pKZH~4L    HLfHHIDHBIIIDuLL$`IH+I+HLAL\$pI;  Lt$8H+L|$@L<L4fD  ME3H   HL] HD] LHKTILHHwHMIHL,    M IH MHBHIHBHIHBIMHHBuH\$PL\$pHt$HLL$`L;}0IHL    HHI+HHIIHKDuHD$hHIH+II+LI;L|$@Lt$8A]A\_^][B(H\$Hl$Ht$H|$ ATHPH$   HH$   )t$@)|$0f(f(Y=B	 H|$(IHf(LH\$ Pf(M$LHIH|$(H\$ ASM$Lf(HIH|$(H\$ ASH\$`(t$@(|$0Hl$hHt$pH|$xHPA\@SH LHH~qLHIIgfffffffMQIIH+HHHH?HL;|M+IIHHH?HL+KHHHKI;IuMHC    H [y:IM~%HQHuHHPH	HCHH [yIIBHH [HWH  HD$ HXHhHpIIHHٺ   DBH~) HH$   HH_K	 HHHHAK	 HHHȋU 5) HH$  HT$hH$   ) HHL$(l+ H|1	 HD$(HHL$@)* Hy1	 HD$(H HL$( HWH  HD$ HXHhHpIIHHٺ   DBH~( HH$   HH_J	 HHHHAJ	 HHHHU $( HH$  HT$hH$   ( HHL$(k* H{0	 HD$(HHL$@() H0	 HD$(H HL$( H\$Hl$Ht$WH LHHgfffffffL+IHIHHH?HHI,H;tH+fHH;( H(H;uH\$0Ht$@HHl$8H _H\$WH HH8 IHHH HHH' H' HH\$0H _H%' H\$WH HH  IDHH9H H*H& HO' HH\$0H _H%C' H\$WH HH IHHHֿ HH& H& HH\$0H _H%& H\$WH HH IHHyH~ HjH& H& HH\$0H _H%& H\$WH HHD I$HHH& H
H%& H.& HH\$0H _H%"& H\$WH HH IHHHξ HH% H% HH\$0H _H%% H\$WH HH IdHHYHv HJHe% Hn% HH\$0H _H%b% H\$WH HH< IHHH HH% H% HH\$0H _H%% H\$WH HH IHHHν HH# H$ HH\$0H _H%$ Hh)t$P  )|$@  L
kg LQ D$     D)D$0D  3p LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
g L(Q 3D$      HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
h LP D$     D)D$0D  30 LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
/i LO 3D$      HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
i LdO D$     D)D$0D  3 LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
j LN 3D$     C HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
;k L$N D$     D)D$0D  3 LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
k LhM 3D$      HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
l LL D$     D)D$0D  3p LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
m L(L 3D$      HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
m LK D$     D)D$0D  30 LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
on LJ 3D$      HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_HWH  HD$ HXHhHpIIHHٺ   DBH HH$   HH=	 ~HHsHH=	 dHHYHM s HH$  ;HT$hH$    HHL$(
 H$	 HD$(HHL$@ H$	 HD$(H HL$(5 LL$ LD$SUVWATHHl$hLd$`HHE3IHI؃LIIM~`MKIIfM~?JL    HIf     fH If)@fAIHf)@uH IuH\$PHI+H|CM~:L    JIfffff     HIJDHAIHJDuIL;
  Ll$@Lt$I;L<$N4L<fff     E3I   I{I{LHIl$JTHIHHMIL,    HM    IH MHBHIHBHIHBHIHHBuH|$XH\$PHl$hM;}0IIL    HII+HHIIHJDuIIIL;&L<$Lt$Ll$@HA\_^][H\$Hl$ LD$VWATAUAVHLT$hLl$`LIIE3HE3IH<HHH|$H  MdL|$@MxL$$     3I   IDsIsLHKTIH|Hl IMHMHHHH    LfIBHHpIBHxIHBIBMHBID$HBID$HBI$HBID$MHBHEHBHEHBHE HBHEIHBHGHBHGHBHHBHGIHHB_L$$H|$Hl$PI;}RHMKLL    HIL+OHTHBH HAHBHAHHAHBIIHAuI II L;L$$LT$hL|$@I;   L+Hl LT$hE3I|~I}LHvHIHHKLHL$    LLL\ H\ Mff     IH LHAHHHAI LHAILHHAuLT$hM;}.IIL    HI+HL HIIHKDuHILT$h3H\$HHl$XHA^A]A\_^HWH`  HD$0HXHhHpIIHH3EEE;|HHrp   DBHL$`` HX:	 HL$pfHL$p HT$8HL$`I HD$@H|$XHCD$@HD$ L
9	 LHHL$`  I[IkIs I_HWH`  HD$0HXHhHpIIHH3fAnA@ f/rHHrp   DBHL$` H{9	 HL$pHL$p HT$8HL$`l HD$@H|$XHCD$@HD$ L
8	 LHH`L$`  I[IkIs I_HWH  HD$ HXHhHpIIHHٺ   DBH^ HH$   HH?6	 HHHH!6	 HHHHU  HH$  |HT$hH$    HHL$(K H[	 HD$(HHL$@ Hp	 HD$(H HL$(v HWH  HD$ HXHhHpIIHHٺ   DBH^ HH$   HH?5	 HHHH!5	 HHHHHH$  ~HT$hH$    HHL$(M H]	 HD$(HHL$@
 HZ	 HD$(H HL$(x L LLMu    A   H L Ht HHL$HHI;HD$IMLMM~I3II3I;}HIHSH  HD$p)p)xIf(f(HR7	 HL$H    DBH$   7 HHPHV7	 HL$  HT$ H$   o HL$  HT$HH$   0 Hf( HH6	 HT$ H$    LHHAHL$ x H6	 HL$ F HT$ H$    HL$ F A HT$`HL$  HH$    Hf(| HH5	 EHL$  HT$ H$   & LHHAHL$  H6	 HL$  HT$ H$   7 HL$  A HT$`HL$   XHH$    Hf( HH35	 HL$ J HT$ H$   w LHHAHL$  LHASH$   M HL$H ($  ($  HĠ  [H%1 MLAuGHA L HAXLcHA@IcKLILM+M;IB KL IB@D+HIBXED 3HHBBHHD$0MLt3HHBBHHHA H$HHA@HIBXLc L+LH+EtwAtBA   M   M;   IB HHIB@I+IHIBXD+DD XJHxbI;]HIB HIB@D+HIBXDD )Mx7M;2IB JHIB@D+HIBXDD IJ@IB H	H+H
HH$3HBBHH@SH HH	& HK HKH [H% D$HD$HH#H H;w	HH      H;s   H¸    HH   )p)xf(%	 f(D)@D)Pf/fEWfD(fA(vf(T fW%	 c  fA.zR  fA.zE  D)$   D)\$`D$	 fA/D)d$PD)l$@D)t$0D)|$   D
$	 D	 fA/r6fff     fA(A\Xf( fA/Xsf(A\ג    3	 
3	 %3	  D3	 D
|3	 Dk3	 D%Z3	 J 
J %J DI D
H DG D%F <D%; D* D
 D % 
 ؑ    2	 D52	 D=2	  } 2	 DT l d2	 D5C [ C2	 D=2 J "2	 fE(= D=
 D5 D- f(AXYf(YAYAXYXYXf(AYAXYXf(Y
ϐ YX
 Xf(YY X
 X YAXYYAXYXAX^YY5<1	 XV  D
r	 fD/vf(P fA(fD(\AX0	 f/  _    0	 
0	 50	 6 D0	 D0	 D%s0	 D-b0	 Z 
Z 5Z DY DX D%W D-V <D-K D%: D) D 5 
  ux/	 D5/	 D=/	 q  /	 D
p  p/	 D5_ w O/	 D=N f D=; D5* D
 fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
 AYX
ٍ Xf(YY͍ AXX YAXYAXAYX^YY%m.	 X  F uq%J.	 :.	 5*.	 ! D.	 D-	 D%-	 %  5 D D D% 3D%، Dǌ D 5  %  uz
r-	 D-a-	 D5P-	  w D=6-	 
6 
-	 
. 
-	 D
 
 D- D5 D= $D=ߋ D5΋ D- D
 DYfW-w	 f(f(YYf(AYAXYXf(AYXYYf(Y
 Xf(Yp X
` XYAXAXYYAXAXYX^AYDY,	 AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIHT$WH0HD$ H\$@HHH       A Ht@   @   H
	 HHx3HHH\$@H0_HT$WH0HD$ H\$@HHH        Ht@   @   H
_	 HHx3HHH\$@H0_HILH+HH(  HH$HHHHHL    IL
f/v
H;t	A
f/vL;t	A

f/v
H;t	A	IKI+ f/vL;t	A	Af/vI;t	A	A	 f/vL;t	AIIH+H$I+f/v
H;t 	A f/vL;t	A f/v
H;t 	A	f/vL;t	A
Af/vI;t	 A	A	f/vfL;taA
H
f/v
H;t	Af/vL;t	A 

f/v
H;t	HHVWATHP  HD$0HXHhIIHL   DBHL$`a HHL$`HHA*	 HHV HHU	 HT$8HL$`( HE H+EHH;r0 HE$  HT$@H|$XHCT$@H$  HD$ L$  L$  IXL LLMu    A   H L H HHL$  HH	I;HD$IMLMM~I3II3I;}HIH(HIHt
H   H(H\$UVWH0I@ 3II+@HHHHtNLd$PI      H;r HOD$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]H$	 LLHD$(H|$	 HHHD$ H8HD$  H;tMtHI IHIH8H\$H|$ 3HLH9yLH|$   MQMM;},HI	MMIHSIIHJMQM;|IAHT$HL$I;HD$HMHLI|bMZff     IIIIHH<IIIIHH|IIIIHH|IIIIHHI;H||I;}IIIIHHI;H<|IM;ALD$H\$H|$ LL$ LD$HT$HL$SUVWATAUAVAWH  H$   HLHHT$t
LHT$`+HHD$HT$(HHكH;HL$(HMLLT$`LM+IML\$PICH$   IHH3H+LIAu33ILcHl$L$   L$  IՃtH&IHD$LL$(HHكH;HL$(IMHE3Ld$0Ld$ EL$HujHuefff     HHH3H+L;tIIILd$ |IuE3L$   Ld$0.M;H$   HL$ HML Ld$0E3E3LT$`L\$P$@  fW   L;ADL;DDHcII+IcHHHM<M;L$    L$  L$8  L$  )$  )$  D)$  H$0  IID)$p  D)$`  D)$P  HH$   ID)$@  D)$0  D)$   HH$   ID)$  IHIH$   H$0  IL    IHK<1HH|$pH$   HIHIHHT$(IT$HIIL$0  HML$   N&H$0  N$1ILd$ MIH$8  O,0HJ42L$   H$   IH$   HLM+LL+HI+HD$XH+IH+D$0L4$LL$HHHL$hHHHD$    D$D$f(E3IfD(fD(fD(( fD(fD(fD(fD(.  MLML$   ML+L+L+MLL$LL$XHVHl$LIML$   LHGH$   M+LL$ML\$M+L$   LL$hLL$   ML$   L$   L+LL$xLL$HLH$   LL$@MJHt$@IIN    LT$8LT$xff     A08H I H H If(f(Y@YIXDXf(YBAYPf(DXDXBT!BYL0DXf(f(Y@YIXf(DXBYD8Y\(DXDXB\*f(f(Y@YIXf(DXBYDYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   DT$DL$H|$pH$  H$   Ld$ L$   L|$8L4$M;}uILMILH+L+L+JI+AHHf(f(Y@YLXf(DXAYD AYTDXDXuDT$DL$M;$  H$   HE  H  H   M;  L4$III+LMHLH+HL+L+HJfB(0f HHfYfDXfDfYfDXfBD fYfDXfADfYfDXu)  L;$   fB(DfC(LMfG(|f)$   f)$   U  JHHHD$8KDLfD(fD(Hl$8HD$@H$   L\$@I+H+HH+L+HNLO|HM4f     fA(qfA(fA(oI I fA((fB(
EI H HfYfYDf(fAXfDYfAYfAYfF(T	fE(KfD(fAXfAXfDXf(EfA(fE(fYAfD(fA(CfAXfYfYfD(fDXfDXfD(fDX4DL$DT$$@  L\$PH$  M;  L<$III+LMHLH+HL+L+HJfff     fB(8f( HHfYfDXfDfYfDXfBD fYfDXfBDfYfDXu  M;  L4$III+LMHLH+HL+L+HJff     fB(0f( HHfYfDXfDfYfDXfB(D fYfDXfBDfYfDXu~M;}yL4$III+LMHLH+HL+L+HJאfB(0f( HHfYfDXf(DfYfDXfB(D fYfDXfB(DfYfDXufA(fADXfA(AXfADXfA(EXfADXfA(EXfADXEXL;M  HI+H  L$MLLL+L+L$   MOL+JTKLLD$8LD$XJDH$   LLD$xLM+LD$@MM+L$   LD$hLL$   MLd$xL$   L+L$   LD$HLH\$8LD$LHl$@Ht$M+IIIOL$   LT$L$   B8H I H H If(f(Y@YIXDXf(YBAYQf(DXDXATBYL0DXf(f(Y@YIXf(DXBYD8Y\DXDXA\f(f(Y@YIXf(DXYD)BYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   H|$pH$  H$   Ld$ L$   L|$L;}kL4$ILMHLH+L+L+I+JB0HHf(f(Y@YLXf(DXBYD BYTDXDXuH$   H$   L$   fWYDYX9L$   HT$(DYDY9EXHD$XHD$hHD$HEEXEDXL4$LH$   DHLHLH$   L4$HHLLHl$H|$pHT$(L$   H$   Ld$ H$   L$   L$   VL$   L$  L$  D($  D($   D($0  D($@  D($P  D($`  D($p  D($  ($  ($  HD$0M;  H$8  H$  H$  (% H    H$  IHH$0  L$IHMD LLIIIM+L$  fffff     3If(f(|jIRHKI@HI4HH<    HH H HYIY@Xf(HX@YIYAXXuI;}&IIIH+HHY@XuM;   AAu@M;}|IKII+HHHff     f(HHfYAfXuAM;}<IKII+HHHff     ff(HHfYfXuf(fXXL;I   HI+H|wHJLKDI+I4HHHI<ff     H0H H HYIY@Xf(HX@YIYAXXuH;}&HIIH+HHY@XuH$  fWYMH    LAX$A$MIHD$0HtfWL$  E3L3HD$0Hĸ  A_A^A]A\_^][LD$HT$HL$UVWATAUAVAWH`  Hl$ H  )0  )   HIMLHD)  D)   D)   D)   D)   D)   D)   H;v݈L  3IHDH  L3HIDH   H    H=   E Ity3H|QLON    IJIIJ    HIH HAHIHAHIHAHIIHAuH;}J    HHHH;ID|L  D  fEWHOMN    HHM IHU8HE8    HE HNIIҋI+ѸH#I+IHHU0   H   IO49HI+M]H   HMHH   IMI+MH]xHE(M+II+L}MHEM+   I+LUpL]`H   HL   I+L}8HU H   HCLu@LeH;  f(=[ fE(fE(HMKfD(H+fA(EYGY;H  AEEfDAfDAu&IH  LEXHHكH;HMXICHLHfA(I+fA(LEPHI@H   IYBYL0lAXCAXACf(AYXACY,;LAXI;#  IH+H  HM8H}I@LE HEhH   I\ IJL]0NL LE0HE(IHH  ILu(H+ILEH}XH  LeXfD  IAAAII H AYAYaXH CXLCLKf(YIAYAXf(AYXADAYXAXL9AL9CD1YAYDXAQXf(f(AYAYXBXL!BL!f(BYTBY\XAQXAYf(AYXAXLALYSYcXXL;}hH  LEPL]`Lu@LeM;scIIO,MH+JI+HHAYf(AYXBXLBLBD YYDXXuOL L;s{LeHII+I+HHII+HMHff     fAffIHHf(fYfAYfYfAYfAXYfDXfXfXfA)YuH;  H]HH+H  L]N<HGN$+KMH]PL  H  H}PHEhILLuMLHDL+O<+ffff     YP!HH H I f(f(AYAYXBD AYAXLALAYQAYYXPXYf(AYXBXL BL DYBYD XPXf(f(AYAYXBXL9BL9f(YT9Yd9XPXAYf(AYXCXLCLAYQAYYXXH;UhH  L]`Lu@H]H;sdMHN+IL+HH+BHHAYf(AYXBXL BL DYBYDXXuL   L   H]xf(fLE(LELE0XfA(XfADXAYAX{DXLeHMHL}8EYEXA{MLEpHEIIMIH]xLEpL]`L,    I   w<H   HHH;w
HHH萷 H+LT$ III LHMXH  H  L}H   HMML HHHL+HLL+H;   HE fA(fA(IHHMHHBY\f(AYDIK8AXAfH;},	HHf(YXDDAYLXHMHAYLLIAXQAQa}  t
H   p H  (0  (   D(  D(   D(   D(   D(   D(   D(   H@  A_A^A]A\_^]Hl$ WH H\$03Ht$8IHHtHJHͲ(OHF HH+FHHtbLd$@LgfHtHHͲ,IEHF H+FHH;r HVIH" HF HH+FHH;rLd$@Ht$8H\$0HtHo)HHl$HH _鲧@SH H#
	 HHHIHtHP tHC    H [@SH  HD$  HH         DBH$    H		 H$   HH< HH
  HT$hH$    HHL$( HS HD$(HHL$@X Hy HL$(ҫ HĐ  [HWH  HD$ HXHhHpIAHٺ   DBH HH$   HH		 HH		  Hȋ} HH[		 HH,		 קHȺ   Q HH		 躧Hȋ7 HH褧HH$  蔧HT$hH$    HHL$(c Hs HD$(HHL$@  H HD$(Hw HL$(莪 E  HWH  HD$ HXHpAHH   DBH H$		 H$   צHH	 ȦHH车HH	 讦HH裦HH	 蔦Hȋ HT$(H$   v HT$0H|$HHCT$0H$    HL$P: HJ HD$PH$   HL$h HZ HD$PHvv HL$P` HWH  HD$pHXHpH   LAH		 HL$HX L		 HHL$ " H$  LHHAHL$ I HL$H= HN		 HL$  HHT$ HHL$  LHASi  C$  ;>  H	 HL$  H$  HHT$ HHL$  H:	 HL$  HHT$ HHL$  w0fH*f(Y	 H,ȉO4Y
	 H,G8++w<H	 HL$ $ HHT$ HHL$ *    DBH$   ; H3	 H$   >HȋW4 HT$HH$    LHHAHL$H H	 HL$  HT$ H$   0 HL$  H	 H$   HȋW< HT$HH$    LHHAHL$HH H	 HL$  HT$ H$    HL$  H	 H$   BHȋW8 HT$HH$   # LHHAHL$H LHASH$    w0DG4DO8O<HHL$  I[IsI_@SH0HHQHI)t$ f( HH H	 H腢Hf( H H(t$ H0[H% H\$WH HHQHIAb HHV HG	 HH H= HH\$0H _H%1 H\$WH HHQHII HH H	 H跡HH H HH\$0H _H% E   H\$Hl$Ht$WH HHHQHIIcI HH} H H>HOX    H;},fD  HOHA	 H* HH;|H+ HO) H\$0Hl$8Ht$@H _E  UVWATH(H\$PHc\$pIcILH   HQHILl$XL|$  IH H H LL   Lt$`L4    HNHVr HM \ I~5H]I|$D  HNHA	 H+ HHuH* HN( IIuLt$`Ll$XL|$ H\$PH(A\_^]HL$WH0HD$ H\$HHH H\ HHSHOK HH\$HH0_HL$WH0HD$ H\$HHH H$ HHSHO HH\$HH0_HL$WH0HD$ H\$HHHT H HHSHO HH\$HH0_HL$WH0HD$ H\$HHH HT HHSHO[ H HHH\$HH0_HL$WH0HD$ H\$HHH4 H HHSHO H HHH\$HH0_HL$WH0HD$ H\$HHH H, HHSHO HH\$HH0_HL$WH0HD$ H\$HHH H HHSHOK HH\$HH0_@SH H	 HH(HAHA HX L LHKHtHP tHC    H [H\$WH H	 HH(HAH H L LHKHtHP tHC    @tH HH\$0H _@SH H#	 HH(HAHY H L! LHKHtHP tHC    H [H\$WH H	 HH(HAH H" L LHKHtHP tHC    @tH HH\$0H _H\$WH HHl HHHJHKHtHPHGHCHGHCG C HH\$0H _H\$WH 3HHHAHA HA(Ht0HH;vwHHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht0H?H;vwHHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht4HfffffffH;v)wHߖHHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht7HUUUUUUUH;vvH迗HHHCHC HȰHK(H\$0H _H8HD$     HD$HHt3H3HPHtH
HPHtH
ƀ   ƀ    H8H\$Hl$Ht$WH IIHHu%3HHkHl$8HsHt$@HH\$0H _HH;vmH<    H HuHtmH\$Ht$WH IHHu3HHsHt$8HH\$0H _HH;vVmH<    HT HuHt5mHL@WHP  HD$0HhHpIHHHc$  L;      DBHL$` H HL$` HHHH Hȋ$  ~ HH HT$8HL$`g HD$@H|$XHCD$@HD$ L
a L$p  HHfL$P  IkIsI_@SH H+MHH    J H~LLHI HH [@SH H+MHH    J H~LLHI HH [@SH L+LIIJ    J
MtLMHe HH [@SH H+IHH    H+H~LLHH& HH [@SH H+IHH    H+H~LLHH HH [HL$WH0HD$ H\$HHH H HHSHO HtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H
 HH HG@HH\$HH0_H@  @SH H HHH& HA@HIHHtHP tHCH    H  HKH HH [H%D @SH H HHH HA@HAhHcPH[ HD
hHAhHcPH/ DBDD
dHH HA@HIHHtHP tHCH    Hf HKHi HH [H% HcAH+Hx頃  H@闃  @SH H3 HHH HA@HIHHtHP tHCH    H8 HKH HH [H%$ H\$WH H HًHH HA@HIHHtHP tHCH    H HKH} H @tH HH\$0H _HWH`  HD$0HXHhHp IIHHI@ I+@HL;      DBHL$`# H HL$p)HH} HH+ HH HH HHV HT$8HL$` HC H+CHH$  HD$@H|$XHCD$@HD$ L
 L$  HHlL$`  I[IkIs(I_HLH WHp  HD$0HhHpIHHL;$       DBH HH$   HHHT$8H$       DBH$  \ H H$  ǑHH$  跑HH$  觑HHe 蘑HH$   HH- xHT$`H$   HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
 L$  HL$p  IkIsI_HSH   fW)pD)Hf/fD(   u"5: 3fDWfA(fW  H fA/v+fDW
 fA(
 \f(  fDW
 3fA(aX    )$   D)$   f/D)T$pD)\$`D)d$PD D)l$@D)t$0D)|$    fA/vRfD.z  P u% %P P %P AYDY
 AX  }P u[a 
Q -A XP 5( = P 
P -P 5P =P (=P 5O -O 
O O uaD D% D- O D5u DlO D%kO D-jO D5iO D@O fE(-D5PO D-?O D%.O DO DO fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X% AYtu fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [ fA/v
 fA/  HN uuD D% D-  N D5 D=~ n DuM D%tM D-sM D5rM D=qM qM -D=^M D5MM D-<M D%+M DM ur DL M L  L  L  L  L l L fA(fE(D\AYfW fA(fA(AYAY蹎 f(f(f(f(YL Y
GL X
/L AXAYYYX
L AXAXYAYYX
K Xf(YK A^XK AXYXK AYX^X Ytj fA/  1L  uuDD D%3 D-"  	L D5 D=  DJ D%J D-J D5J D=J J -D=J D5J D-J D%J DJ @ubo @DSJ mK MJ E EJ - =J  5J  -J fA(fE(D\AYfW fA(fA(AYAY貌 f(f(f(f(YJ Y
I X
I AXAYYYX
I AXAXYAYAYXf(YI AXA^XdI YXX
DI ^X  Yy fA/  6J xvD D% D- 
J D5 D=  DH D%H D-H D5H D=H H -D=H D5rH D-aH D%PH D?H rc	 DG nI G  G  G  G  G fE(fA(D\s AYfW fA(fA(AYAY诊 f(f(f(f(YG Y
uG X
]G AXAYYYX
3G AXAXYAYAYXf(Y#G AXA^XG YXX
F ^X YvFH 	   D D%r D-a 	H D5F D=5 % 
 D4F D%3F D-2F D51F D=0F 0F 
0F -D=F D5F D-E D%E DE 
rs 
D~E hG xE h pE P hE 8 `E   XE  PE fE(fA(E^AYfA(fA(fWz AYAY蝈 f(f(f(f(Y3E Y3E Y
D X
D AXAXYYYX
D AXAXAYYYX
~D AXA^Xf(YD XtD YXXD AYX^X YLHLH WHp  HD$0HhHpIHHL;$       DBHs HH$   HHׄHT$8H$   T    DBH$  , Hp H$  藄HH$  臄HH$  wHH5 hHH$  ϼ HH HHT$`H$  ż HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
 L$  H賓L$p  IkIsI_HWH  HD$ HXHhHpIIHHٺ   DBH HH$   }HH nHHcHH THHIHM HuHI H1IHI H$  HHT$hH$    HHL$( H HD$(HHL$@ H HD$(HS HL$( H8HD$  HtHtI HHHH8HVWATHP  HD$0HXHhIIHL   DBHL$` HHL$`3HH $HHVw HH HT$8HL$` HcHE $  HT$@H|$XHCT$@H$  HD$ L$  L$  I̝HL$WH0HD$ H\$HHHd H| HHSHO+ H HHtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H HH HG@HH\$HH0_H@H(H(HL$WH0HD$ H\$HHH H HHSHOK H HHtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H HHv HG@HH\$HH0_H@{  HL$WH0HD$ H\$HHHH HHJHOHtHPHCHGHCHGC G HS(HO( H HH HG(HH\$HH0_HL$WH0HD$ H\$HHHH HHJHOHtHPHCHGHCHGC G HS(HO( H HH HG(HH\$HH0_HL$WH0HD$ H\$HHH Hd HHSHOk 3HGHHGPHGXG`H HH HG@HH\$HH0_HL$WH0HD$ H\$HHH$ H< HHSHO 3HGHHGPHGXG`H HH HG@HH\$HH0_LALIHH+HLIHHHHM   IIf(
~DHf(B~+HALR HH    fAX
fAXBI HuL;fX~fXM;f(fX}dII+H|>IJDI+HHHMfD  XHH HXHXHXHuM;}JM+XHIuf(M
   L;A~YI@H|5IHIAHHH   X@H HX@X@X@uI;}IL+X HIu@SH H HHH HA@HAhHcPHs HD
hHAhHcPH DBDD
dHH HA@HIHHtHP tHCH    H HKH HH [H% HcAH+Hx`v  H@Wv  @SH HH(HL HAH) HHC@HcPH HD@HC@HcPH DBDD<HHH H_ L LHKHtHP tHC    H [H(u  HcAH+HPu  @SH HH(H HAH HHC@HcPH HD@HC@HcPHK DBDD<HH H LH LHKHtHP tHC    H [H(u  HcAH+HPpu  @SH H HHH HA@HIHHtHP tHCH    H HKHó HH [H% @SH H HHH HA@HAhHcPH HD
hHAhHcPH DBDD
dHHL HA@HIHHtHP tHCH    H~ HKH) HH [H%j HcAH+Hxt  H@t  HSH   fW)pD)Hf/fD(   u"5j 3fDWfA(fW  x fA/v+fDW
8 fA(
C \f(  fDW

 3fA(aXI    )$   D)$   f/D)T$pD)\$`D)d$PD D)l$@D)t$0D)|$    fA/vRfD.z  : u% %: : %: AYDY
 AX  : u[ 
 -q : 5X =H 8: 
8: -8: 58: =8: (=.: 5: -: 
9 9 uaD D% D- 9 D5 D9 D%9 D-9 D59 Dh9 fE(-D5x9 D-g9 D%V9 DE9 D49 fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X% AYtu fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [5 fA/v
 fA/  p8 uuD D% D- H8 D5 D=  D7 D%7 D-7 D57 D=7 7 -D=7 D5u7 D-d7 D%S7 DB7 ur& D6 7 6  6  6  6  6  6 fA(fE(D\AYfW fA(fA(AYAYv f(f(f(f(Y6 Y
o6 X
W6 AXAYYYX
-6 AXAXYAYYX
5 Xf(Y6 A^X5 AXYX5 AYX^X Yt fA/  Y6  uuDt D%c D-R  16 D58 D='  D5 D%5 D-5 D55 D=5 5 -D=5 D54 D-4 D%4 D4 @ub @D{4 5 u4 u m4 ] e4 E ]4 - U4 fA(fE(D\AYfW fA(fA(AYAYt f(f(f(f(Y84 Y
 4 X
3 AXAYYYX
3 AXAXYAYAYXf(Y3 AXA^X3 YXX
l3 ^XP Yy7 fA/  ^4 xvD D%  D- 54 D5 D=  D2 D%2 D-2 D52 D=2 2 -D=2 D52 D-2 D%x2 Dg2 rc9 D2 3 2  2  2  1  1 fE(fA(D\ AYfW fA(fA(AYAYr f(f(f(f(Y1 Y
1 X
1 AXAYYYX
[1 AXAXYAYAYXf(YK1 AXA^X)1 YXX
	1 ^X Yvn2 	   D D% D- 	?2 D5v D=e U 
E D\0 D%[0 D-Z0 D5Y0 D=X0 X0 
X0 -D==0 D5,0 D-0 D%
0 D/ 
rs 
D/ 1 /  /  / h / P / 8 x/ fE(fA(E^AYfA(fA(fW AYAYp f(f(f(f(Y[/ Y[/ Y
/ X
/ AXAXYYYX
. AXAXAYYYX
. AXA^Xf(Y. X. YX. AYX^XC YLHH   )p)xD)@f(D)HD)PD)XD)`D)l$@D)t$0O0 D)|$    D
 D% D-n 0 D5T D=C 3 D" D
/ D%/ D-/ D5/ D=/ / D
/ D/ fE(?D/ D/ D=q/ D5`/ D-O/ D%>/ D
-/ 5 fW\fD(Xf(f($   YD^fA(AYn $   Y
 DYDYL$   DX. EXD(|$ DYDY^EXD(t$0EXD(l$@XA(sDYDYA({EXE(cEYEXE([EXE(KEYE(CA\E(SIHH   )p)xD)@$   D)HD)PD)XD)`D)l$ D)t$. D)<$u
 
~. . 
n. uo  5 Q. = Dx D
g - - 5- =- D- D
- 2D
- D- =- 5- - - %    D D% D- - D5 D=  D- D%- D-- D5- D=- - %, fD(6D=, D5, D-, D%, D, D, $   L$   f(\\- $   \- \f(YYf(AYE(KX$   YXf(AYE(CYXA(sYf(AYD(<$XXAXD(l$ YAXf(E([Y
, YA({AXD(t$YAXE(cYAXE(SX^YY- Xf(I@SH HD$0    HH [Hl$ ATAUAVH LA LI*L+AI3LIHHH?H   H\$@Ht$HH|$P3H;r Iu3HD7 H+D7HHt/H;rm I$HL7HHDHD7 H+D7HH;rIM IHI+MH0HHHH?HH;rH|$PHt$HH\$@Hl$XH A^A]A\HATH`  HD$0HXHhHpHx IMHHHY H+YH|C;}HH;r HFHj   DBHL$`ß H HL$pfHȋF HT$8HL$` LL$@H|$XLCL$@Ld$ DǋH
 L$`  I[IkIs I{(IA\LD$SVWH0HD$ IHHH\$PH;t+H\$XH\$(Ht
HH H(H\$`H(HH0_^[HATH`  HD$0HXHhHpHx IMHHLQ L+QH*IHHHH?H|#G;}HH;r? H[HHFj   DBHL$`U H HL$p[eHȋ؝ HT$8HL$`@ LL$@H|$XLCL$@Ld$ DËH
E 証L$`  I[IkIs I{(IA\LD$SVWH`HD$ IHHH$   HL$0 H;t?H$   H\$(HtHT$0Ha HH H(H$   H(HL$0/ HH`_^[HL$WH0HD$ H\$HHH LM LHGHCHG HC H HC(HO0HK0HtHPHG8HC8HG@HC@GHCHH HH HC(HH\$HH0_H(i  HL$WH0HD$ H\$HHHt H HHSHO; 3HGHHGPHGXG`H HH HG@HH\$HH0_@SH H3 HHH HA(HI0HtHP tHC0    H HHH [H% @SH HC HHH& HA(HAPHcPH HD
PHAPHcPH DBDD
LHH, HA(HI0HtHP tHC0    Hn HHH [H% H(Gg  HcAH+H`0g  H8MPE3MtIMH\$0H      ffffff     IcAD$PHD$PH#H;tIM;rH\$0H8Hc HD$(H7 HD$ %@SH0fW)t$    f/f(vfW5 f(d 
) H,f(t
X\f(\f(f/- v\f(Y-i f(c fnY(t$ YH0[HH   )p)xf( f(D)@D)Pf/fEWfD(fA(vf(dc fW c  fA.zR  fA.zE  D)$   D)\$`D fA/D)d$PD)l$@D)t$0D)|$   D
 D fA/r6fff     fA(A\Xf(b fA/Xsf(A\$    ׿ 
ǿ % $ D D
 D{ D%j j$ 
j$ %j$ Di$ D
h$ Dg$ D%f$ <D%[$ DJ$ D
9$ D($ %$ 
$ #    ؾ D5Ǿ D= $ #  Dt# # t D5c# {# S D=R# j# 2 fE(]# D=*# D5# D-# f(AXYf(YAYAXYXYXf(AYAXYXf(Y
" YX
" Xf(YY" X
" X" YAXYYAXYXAX^YY5L XV  D
 fD/vf(`` fA(fD(\AX f/  "    ߼ 
ϼ 5 V" D D D% D-r r! 
r! 5r! Dq! Dp! D%o! D-n! <D-c! D%R! DA! D0! 5 ! 
!  ! ux D5ӻ D=» !    D
     D5w    _ D=f  ~  D=S  D5B  D
1  fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
  AYX
 Xf(YY AXX YAXYAXAYX^YY%} X  f  uq%Z J 5: A  D  D D% %  5 D D D% 3D% D D 5  %  uz
 D-q D5`   D=F 
N 
. 
F 
 D

 
5 D- D5 D= $D= D5 D- D
 DYfW- f(f(YYf(AYAXYXf(AYXYYf(Y
 Xf(Y X
x XYAXAXYYAXAXYX^AYDY AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIH\$Hl$Ht$WH HIIH+HIHHHH+HHH讌HKH;s&D  CHCf/wf/wHH;rH;   HH+HHHHH|vfD  	f/   f/wzIf/p  f/f  If/N  f/D  If/,  f/"  HGH H;|H;sf/wf/w	HH;rLLL;C  HI+HHHHH   IPAf/w#f/  HHI;t
 A JLRf/w#f/  HHI;t
 A
f/w"f/d  HHH;t JLRf/w#f/8  HHI;t
 AHGI H L;L;s7Af/wf/w"HHI;t
 A IL;rL;vFIQ    f/wf/w$HH;tHHIHI;rL;   L;   I;tH;tHHILHHIL;'HAIHHHI;I2I)IL;u8HL;tHAIHH;HHM;tIA I AI~Ht$@H] H\$0HMHHl$8H _M;   H\$H|$IMHI+HH|WLHII+ODL+HJTHHMI@H I HHBIDHBI@HBI@HBuM;}"HHH+JM+HHIHAuH\$H|$H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3AY@@MtIJHtH3AY@@MtIJHtH3AY  MtIJHtH3AH HY@@dM;};HM+HJMtIJHtH3AHIY@@uH\$M;   H\$H|$IMHI+HH|wLHILI+KTHM+KDHHMBH H HX@@ALXHHBX@@JXHHuM;},HHHH+M+JHIX@@uH\$H|$H\$WH Hs tHU HH\$0H _H\$ UVWH0I@ 3II+@HHHHtbLd$PLl$XI      IH;r HOD$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]H: LLHD$(H HHHD$ `HH   v )pD)@D)XD)`D)l$@g fD(D)t$0D)|$    . % - - 5 D% D- D5 D=    i  i %Y  I -I  ) 59  	 D%( p D- D5 D=  f(DD= D5 D- D% 5 - % 
 D u\n ^  = =  -  
  D  uy  }   }   } } u e m M e )$   D)$        D
   ڿ fA(     D
  | = | = D
q fD.  zu
fA(  2 D)T$pfA/  EYfA(AYfD(f(Y	 DY X DX YDYX DX YDYDX AXYDYAXEXYDYXEXYDYXAYDXDYDXf(Y
 DXf(Y X
 X YX
 YAYXXD^   E^fA(D\ fA(AYO fD(fA(O YDYf(X= DX
 Y
% D^X
 f(Y YYX= X
 YYDYX X=o X
 DX
f YAYDYX AXAYX=. X^DYfA(D(T$pD($   ($   D(l$@L$   A(sE(CE([E(cD(t$0D(|$ IHH   )pD)HD)PfD(D)XD)`D)l$@ D)t$0D)|$    
   %p -` 5P D%? D-. D5 D=  L  
  4  % $  -  | 5  D% D- D5 D=  LD= D5 D-{ D%j 5Z -J %: * 
 D
 ubռ ż l      D
  c     C 3     
   ڻ  »      )$   D)$   uze DT fA(^ . . DE  
 =5 
   պ  = D fWfE(fD.fDTC z   fA/  EYfA(D$   AYfD(f(DY Y} DXl X\ DYYDXB X2 DYYEXAXDYYEXAXDYYDXXDYYDX$   XYDYDXf(Y
u DXf(Y\ X
L X< YX
( YYXX
 D^EY   E^fA(D\
B fA(AYI fD(fA(I YDYf(X=W
 DXF
 Y

 D^X

 f(Y}
 YYX
U
 X=
 YDYYX@
 X
 
 DX X= YAYEYX
 AXYXX
 ^DYfA(D($   ($   D(l$@L$   A(sE(KE(SE([E(cD(t$0D(|$ IH;   Ht$WH0H\$@HYHHH;   Hl$H   )t$ H+ 3Hf/v+HT+HH~HLH+LH" 7.CHCf/vD  @HHf/w1HH;u(t$ Hl$HH\$@Ht$PH0_@SH HD$0    ڮHH [@UHMILH;u2H]Ht$0L$$<-AEu<+uHHH+H}Ht$0L$$2H]H\$(H\$@3H+DHL+ِD D:tE:uDAHArHL;   IH+H|D$X8uD$`A8B   2   LT$PL\$HH|$Hu5IIDH+H+HD  D D:tD:uAHAr+Hu|L+L+fD  B:tB:uaHrEuH| HHM 'H| H        D$ HD$ H3HE H|$H\$(Ht$0L$$H]2EuHX{ HHM HF{ H        D$ HD$ H3HE HVWATHP  HD$0HXHhIIHL   DBHL$`{ HHL$`BHHa BHHV7{ HHu BHT$8HL$`H{ HE H+EHH;rP} HEHH$  HT$@H|$XHCT$@H$  HD$ L$  L$  I芾M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDB\DCD|HL$WH0HD$ H\$HHH| H HHSHOk{ H HHtH@3H4 HG@HKHOHHtHPHCHGPHCHGXC G`H HHִ HG@HH\$HH0_H@j  HL$WH0HD$ H\$HHH{ H HHSHOz H HHtH@3Ht HG@HKHOHHtHPHCHGPHCHGXC G`H HHf HG@HH\$HH0_H@j  @SH H HHH HA@HIHHtHP tHCH    H( HKHy HH [H%{ @SH H+ HHH HA@HAhHcPH۳ HD
hHAhHcPH_ DBDD
dHH\ HA@HIHHtHP tHCH    H HKH9y HH [H%zz HcAH+Hxh  H@h  @SH H# HHH֟ HA@HIHHtHP tHCH    H HKHx HH [H%y @SH HS HHH6 HA@HAhHcPH HD
hHAhHcPH DBDD
dHH< HA@HIHHtHP tHCH    H HKHx HH [H%Zy HcAH+Hx0h  H@'h  H\$WH`)t$P)|$@D)D$0fD(f(Af   f(fYEYD)L$ fW=C D
 fA(\AYYT Q@ fA(YY f(XZ f;vGfffff     f(ffA(YAY\fn^f(YXf;rH\$p(t$P(|$@f(D(D$0D(L$ H`_HH   D)@D)PD)XfD(D)`W uy
C 3 # 2 
 
   
 
Ҳ 
 
  
  D%1 fEWҨuk 
p  7 O 
/ 
7 '  ' 
 D% D     
ձ <   
| 
 t  
l 
l d T 
\ 
< T 
T     
    
 
˰     
 
  D% 
z Z ujF 
6    
 
     
 D  uj 
   O  
G 
g ? O ?  
' D%. @ur 
 @A   
 
Ѯ   
 
  
 D xst 
d    B 
  
*    
  
   
  D%  D)l$@rD-ĭ D-w  I 	D-f  	r 	D   
)$   r5` 
5   5  D)|$ rD=' D=  	D= )$   r= =  = 
D)t$0rD5 
D5e _ 	D5T fE.fE(fDTx zu
fA(  K D)$   fA/rifA(L$   H  H
  E3AY$   j&Y5 fA(fD(fA(\AXAYA\YDY,  D-٫ fE/rlfA(L$   H H
 E3AY$   'Y= fA(fD(fA(Xr \AYA\YDY   E^fA(AY$   fA(n9 f(fA(B9 L$   H' H
X E3f(d%L$   Hu f(XfD(H
 E3EYDY/%\YDXfA(8 YX D^EYfE/v	DY
Ώ fA(D($   D(|$ D(t$0D(l$@($   ($   D($   D(T$pD(\$`D(d$PH   LL$ LD$HT$HL$SUVWATAUAVAWHx  H$  D)$   MLLHAHL$t
LHL$8+HHD$HT$HHكH;HL$HMLL\$8HI+HIH\$@HCH$   IHH3H+LIAu33IHcHl$H$   H$  HփtH&HHD$LL$HHكH;HL$IMHE3Ld$L$$EL$Hu]MuXHHH3H+L;tIIIL$$|IuE3L$   Ld$,M;H$  H$HML Ld$3E3L\$8H\$@D$      L;ADL;DDHcII+McHHHIL;HT$  L$  H$  I)$`  )$P  D)$@  MIHH$   HD)$0  D)$   D)$  D)$   HH$   ID)$   D)$   IL    IM,1HH$  HIHHT$hIT$HH$   IIL4HL4$IL    HIIL$  HN$8HD$0IIM+Ld$xI+L$  L|$(HD$PH$  HLHOIMHL$0L$   H$   H+L$   H$  HL$0HL$H+L$HHHHL$HL$hfA(3IY	DfA(AY	fDDfDfA(Y
DfA(AYfDDfD  MKL\$0HI+MIHD$HIM+I+MIT$HD$XIHOH|$HHl$XH+HD$`ILFH\$`H+HD$pILd$pI+IH$   J    L$   HD$ ffff     IfA(fA(H I H fA(I ICYD2XAAYJXfA(IAYPXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(AYLXIIYBXfA(AAYHXfA(ICYD XAL\$8H\$@H$  H$  Ld$xL4$HD$ I;}MLMMIM+M+M+L+H+HIfA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuI;  H$   H  Hc  H   L;k  HT$(HMI+MMHL+HHL+L+HJސfBfBfB HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  H$   fG(dfF(lL;MfG(t  I+ILHLH+HL+M+KDHK\ NTKlM<Lfff     f(}f(fA("KfEYfEYI H fB(,fA(sf(H I HfAYfAYfAYEDfAXJfXfA(fD((fEYfAYfA(fD(eAfXfXfAYfXfAXfA)JfE(sfXfXfA)zBL\$8H\$@H$  L;  HT$(HMI+MMHL+HHL+L+HJff     fBfA(fA HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  L;  HT$(HMI+MMHL+HHL+L+HJ     fBfB(fB HHfAYfAYfAYfXf(@fAYfXfXfXTf)Tu   L;   HT$PHMI+MLHM+HHM+M+HKD     fB(fB(fB( HHfAYfAYfAYfXf(@fAYfXfXfXTf)TuH;H\$H  HH+H'  ILMH+L+ITHD$pIHI+HLMHD$ IM+H|$ I+IH$   ILLH$   H+HD$`ILd$`H+HD$XII+Lt$XIH$   JH\$pL$   HD$HfD  HfA(fA(H I H fA(I ICYDXAAYJXfA(IAYQXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(CYLXIIYBXfA(AAYIXfA(ICYDXAL\$8H\$@H$  H$  Ld$xL4$HD$HH;}MLMMHM+M+M+L+H+HJ9fA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuH$   HL$hL$   H$   L$   HLHLH$   HL$hL$   HD$PHD$(H$   HD$0LLLHHl$Ld$xL4$H$   L$   L$  HT$H$  D($   D($   D($   L$  D($  D($   D($0  D($@  ($P  ($`  HD$fD  I;  H$  HMIH$  MkL    HM2L+HH$  LL+L$fA(E3IAY$f||ISIHHGHHL    D  f(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuM;}.IIJH+I+f(HHYDX@@uCuHL;}   HIJI+H+HHH    f(HHfYfX@f)@u>L;}9HIJI+H+HHH fHHfYfX@f)@uH;H   HH+H   HMILH+L+HDHHHH4ff(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuH;}.IHHH+H+f(HHYDX@@uH$  MMH    LIHD$Ht!H$  L$  3L3HD$3D($   Hx  A_A^A]A\_^][M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCD|HL$WH0HD$ H\$HHH4_ He HHSHO] H;h HHtH@3HĄ HG@HKHOHHtHPHCHGPHCHGXC G`H HHf HG@HH\$HH0_H@'_  HL$WH0HD$ H\$HHHt^ Hd HHSHO;] 3HGHHGPHGXG`H HHܖ HG@HH\$HH0_HL$WH0HD$ H\$HHH] Hd HHSHO\ 3HGHHGPHGXG`HƖ HH HG@HH\$HH0_@SH HC HHHF HA@HIHHtHP tHCH    H d HKH#\ HH [H%d] @SH H HHHf HA@HAhHcPH3 HD
hHAhHcPH DBDD
dHH HA@HIHHtHP tHCH    Hc HKH[ HH [H%\ HcAH+Hx\  H@\  @SH Hۘ HHH& HA@HIHHtHP tHCH    HXb HKH[ HH [H%D\ H\$WH Hw HًHH HA@HIHHtHP tHCH    Ha HKHZ H[ @tH$ HH\$0H _HHXHpWH   )p)xfW3H5W{
D)@D)HD)PfD(fD(fD(EYDYD)XDYp Dg fD  fA(Y3@
 AXf(AY" HHY3h@
 ^Xu(t$pL$   AYE(CE(KE(SI[Isf((|$`E([I_HL$WH0HD$ H\$HHHZ H` HHSHOKY HtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H HH HG@HH\$HH0_H@HL$WH0HD$ H\$HHHY H` HHSHOX 3HGHHGPHGXG`HF HH, HG@HH\$HH0_HL$WH0HD$ H\$HHHDY H\_ HHSHOX 3HGHHGPHGXG`H~ HH HG@HH\$HH0_@SH H HHH HA@HAhHcPHÖ HD
hHAhHcPH DBDD
dHH\~ HA@HIHHtHP tHCH    H^ HKH9W HH [H%zX HcAH+Hxa  H@a  @SH HD$0    jHH [HE3LLL9QLT$S  H\$H<$fff     ICHL$ HT$I;HD$ HME3H9H   H_fMtI@HtH3IH@IISIHMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIIL;HDDL;}3MtI@HtH3IH@IISIIL;H|IM;SLT$H<$H\$HM;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBu@SLLHL$MBIBHT$ L;LD$HD$ HME3HH   H|$H{MtIAHtH3IRI
H@HIHMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIIL;HDAH|$L;}3MtIAHtH3IRI
H@HIIL;H|[@WH0HD$ H\$PHt$XHH3H\$@HJHt3HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt	HHP H\$PHt$XH0_@SHP )t$@HѨu+ X_  Yh   I(3fnY   HBHl$`HjHt$hH|$pH4   )|$0=X D)D$ fEWHfHH(fTfA.zt	p XHHuD(D$ (|$0H|$pHt$hHl$`f((t$@HP[H\$Hl$Ht$WH0Hi HH9iv	R H3Hl$(3Ht$ (D$ fD$ HuQ LLH]I;[ wHtHHH;XsQ HD$ HuQ H8H;_ rQ Hl$HHt$PHH\$@H0_H\$WH HHH;Qt>H	iQ HtHH{HH\$0H _H    H{H\$0H _HQH\$0H _@SH HHIHt H3HCHC HC(H [j H\$Hl$WH0LA HYHIHH+HH;w/Ht$@I;vP H?H\$(3H|$ (D$ fD$ HuiP LLHI;[ wHtHHH;Xs>P HD$ Hu.P H0H;^ Ht$@rP Hl$PHH\$HH0_H\$Hl$Ht$WH HcjHHH;it!H	O t
H7HH    Hk~LFHHI\ H\$0Hl$8Ht$@H _H\$Ht$WH HHI3HC    H+HHt6 HC H+HH;r:O HKHC HH+HHtH;rHKHt HHC    HC     HC(    { H\$0HHt$8H _HATAUAVH`  HD$0HXHhHpHx ILLA   MPMM;3  fW@ 33E~4LE HcI;}%HM IIHf.z uHI;|AIIcI;   믺   DBHL$`SL H# HL$pYHHm JHI?HHs 0HȍVK HHFw HAT$K HH HT$8HL$`K LL$@H|$XLCL$@IcHMHHcHHE LHp HD$ II.L$`  I[ Ik(Is0I{8IA^A]A\D$Hx  HD$0)$`  f(H7K fWb f.z   3f/rHHr\       DBHL$`J Hn HL$pf(HL$pK HT$8HL$`J HD$@H|$XHCD$@HD$ L
En L$  H H
 -($`  Hx  @SH HR|LCT L[xH [HL$SH0HD$ HD$P    EtH HAhHT HAxD$P   zLw LHw HC@HChHcHH^w HDhHChHcHDd    HH0[H\$WH H{LS L_xtH HH\$0H _H\$WH Hv HًHH0q HA@HIHHtHP tHCH    H
R HKH
J HTK @tHr HH\$0H _H\$WH HH   Ht> HKp3H   H   H    HKXHt HK@H{XH{`H{h HK Ht HKH{ H{(H{0H\$0H _ LSH   HǄ$   AC    HYH΋ ICH#R ICAC   HHL$ )J HP HD$ HSHL$8H HtH@3Ho HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H\u HD$ H@u HD$`H$   HcHHu H   H$   HcHǄ       H
 HL$  H8MPE3MPMtYMH\$@H|$0H      Hff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8Ht HD$(Hrj HD$ `H8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
p Hj L
j H HD$ 1̃y +LAH
? Hi L
i H* HD$  ̃y  +LA H
 Hi L
i Hɇ HD$ ̃ 'H
 Hi L
|i Hu HD$ HH8H8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
x Hi L
i H HD$ 1̃y +LAH
G Hh L
h H* HD$  ̃y  +LA H
 Hh L
h HɆ HD$ ̃ 'H
 Hh L
|h Hu HD$ HH8HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHXN HAxD$X   /uHq HHq HC@HChHcHHq HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_@SH HD$0    HH [@SH`
d )t$P)|$@f/Hf(D)D$0D)L$ fEWDsQ fA(rtfA(\f(f(>
 f(\f/
Z vfA(A\XfA.zuD  !   HjC     =Z Yf(
 ^fA.ztf/5 rf(H詜uZ f/v*f     fA(fA(A\Xf/^XwfD/v*     fA(fA(^AXfD/\Xwf(HRXf((t$P(|$@D(D$0D(L$ H`[@SH HD$0    HH [HL$WH@HD$ H\$`Ht$hIHHHL$XD  Ht*H\$(H\$0Ht
HHB HH(H\$PH\$`Ht$hH@_H\$Hl$Ht$WH HH+HgfffffffIIHHHHH?HHHH+H;tH+H(HHA H;uH\$0Ht$@HHl$8H _HMLH+HL+H;tL+D  HJHII;uI@SH H袋LJ L[xH [HL$SH0HD$ HD$P    EtH> HAhHJ HAxD$P   Lu LHt HC@HChHcHHt HDhHChHcHDd    HH0[@SH H貋L#J L[PH [HL$SH0HD$ HD$P    EtH. HA@HI HAPD$P   
Lt LHt HC(HC@HcHH^t HD@HC@HcHD<    HH0[@SH H貋LsI L[PH [HL$SH0HD$ HD$P    EtH~ HA@H3I HAPD$P   LKt LH)t HC(HC@HcHHs HD@HC@HcHD<    HH0[@SH HLH L[xH [HL$SH0HD$ HD$P    EtH. HAhHH HAxD$P   Ls LHs HC@HChHcHHs HDhHChHcHDd    HH0[H\$WH H܈L
H L_xtHp HH\$0H _H\$WH H\LG L_PtH0 HH\$0H _H\$WH H̉LG L_PtH HH\$0H _H\$WH H蜊LMG L_xtH HH\$0H _H\$WH Hp HًHHd HA@HIHHtHP tHCH    H"E HKH= H? @tH2 HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHhF HAxD$P   ?mHj HHi HC@HChHcHHi HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HǄ$   AC    HYH^ ICHE ICAC   HHL$ = HC HD$ HSHL$8}< HC HD$ HtH@3HDc HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Ho HD$ Ho HD$`H$   HcHHdo H   H$   HcHǄ       HF
 HL$ X LSH   HD$ HAC    H} ICHD ICAC   Hlb ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$Pe< H%o HD$(Ho HD$PHD$hHcHHn HDhHD$hHcHDd    H
 HL$( LSH   HD$ HAC    H} ICHC ICAC   Ha ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$P; Hn HD$(Hin HD$PHD$hHcHH4n HDhHD$hHcHDd    H
 HL$( LSH   HǄ$   AC    HYH~| ICHB ICAC   HHL$ : H@ HD$ HSHL$89 HA HD$ HtH@3Hd` HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Hm HD$ Hm HD$`H$   HcHH\m H   H$   HcHǄ       H.
 HL$ x HL$WH0HD$ H\$HHt$PHH3|$XEtHS{ HAhHA HAxD$X   /}H'l HH
l HC@HChHcHHk HDhHChHcHQTdHtH~@HHK@1HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtHz HAhH@ HAxD$X   O}H?l HH%l HC@HChHcHHk HDhHChHcHQTdHtH~@HHK@qHH\$HHt$PH0_H\$Ht$WH@HB LI HH+BL+IHHHl L9{ HD$0H{ H
{ HD$(IHT$ jHG 3H+GHHtoHl$Pfff     HF H+FHH;r7 HG HnH+GHH;r7 fnD HGHDHG H+GHH;rHl$PH\$XHt$`H@_H\$Ht$WH@HB LI HH+BL+IHHHk LIz HD$0H-z H
z HD$(IHT$ iHG 3H+GHHtiHl$Pfff     HF H+FHH;r6 HG HnH+GHH;r6 HD HOHHDHG H+GHH;rHl$PH\$XHt$`H@_@SH HD$0    HH [@SH HLS> L[`H [HL$SH0HD$ HD$P    EtH^y HAPH> HA`D$P   ږLk LHk HC(HCPHcHHfk HDPHCPHcHDL    HH0[H\$WH HL= L_`tH  HH\$0H _H\$WH Hj HًHH@[ HA(HI0HtHP tHC0    H= HH65 @tH HH\$0H _H\$Hl$Ht$WH0Hi HH9iv4 H3Hl$(3Ht$ (D$ fD$ Hu4 LLH]I;[ wHtHHH;Xsy4 HD$ Hui4 H8H;_ rX4 Hl$HHt$PHH\$@H0_HL$WH0HD$ H\$HHt$XHH3|$PEtHu HAhH< HAxD$P   wHf HH}f HC@HChHcHHJf HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtHu HAhHX; HAxD$P   wHf HHf HC@HChHcHHbf HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HD$ AC    HYHu ICH: ICAC   HIKE2 L: L\$(HCHD$@HC HD$HHPX HD$PHK0HL$XHtHPHC8HD$`HC@HD$hCHD$pHg HD$(Hg HD$PHD$xHcHHg HDxHD$xHcHDt    H
 HL$(s @WE3LHL9I   H\$HYfL;M}gMtI@HtHH3HtHA3H@HPLIIHtH3AHI^AIIH_L;|IL;O|H\$_H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(fY   MtI@3H@HMtI@3H@A   M;Hf(JfYI}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXN  HI+H   LSMtI@3H@HMtI@3H@HBBYXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@IM;HBDBYDX
L;}BMtI@3H@HMtI@3H@IL;HBLBYLX|f(H\$MtI@3H@HMtI@3H@HY   H;N  HCH   LS    MtI@3H@LMtI@3H@HAYXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HI;HDAYDXH;}AMtI@3H@LMtI@3H@HH;HLAYLX|H\$f(HL$WH0HD$ H\$HHt$PHH3|$XEtHo HAPHx4 HA`D$X   ?Hb HHa HC(HCPHcHHa HDPHCPHcHQTLHtH~(HHK(HH\$HHt$PH0_H\$Ht$WH 3HHt$0+ L 4 LHCHGHC H\$8HG Hw0Hw8Hw@Ht$@H` GHHH` HG(HH _HhI)|$@9|$pHD$pI#I      I;v*LH
j HW L
L H HD$ sD)D$0fDnEDD$pHD$pI#I;u*H
 HL LHv L
L HD$ A 'H
 HL L
pL HY HD$ fn)t$P56 ^f 
 X
p6 A\D(D$0\Y(t$PYY=t X(|$@f(HhHl$Ht$ WHPHA IHH+AHH  LH
: H )t$@fW&H      fnm l$`HD$`H#H;u*H
 HK L
rK H LHD$ f/w*H
Ĉ HMK L
>K H LHD$ 
D$`HD$`H#H;u*H
 H(K L
K Hr LHD$ 
LO H
Y H L+OLH\$h)|$0IZHG H+GHHu( H_H =4 H+   HH;^HF 3f(HtVfnU a %. fffff     Hcf(HX\f(\fTY\H;r(|$0H\$hf((t$@Hl$pHt$xHP_fWHl$pHt$xHP_HhID)D$@DDD$pHD$pI#I      I;v*LH
 HS L
I HR HD$ 	D)L$0fDn
EDL$pHD$pI#I;u*H
Ԇ HeI LH L
4I HD$ bA f/\3 w'H
 HI L
I H HD$ )t$P53 ^ 
E X

3 E\D(L$0\DY(t$PEYDY& AXD(D$@f(HhATAUAVHpHA MLH+ALH!  HB H+BH
  LH
ۅ H )t$PfWfH
 H  M #A.f/w*H
 HH L
G H MHD$ |MD$ IU H$   M+D$I+UH$   IHH$   L$   H$   3I;Ht$hH|$`)|$@H= H$   Hl$0HCH MHHLEWHn LMH0WIE I+EHHuY% ID$ I}I+D$HHu<% Iu IL$ I\$I+uHH+HHH;w
HH+HA=1    H;HF^ f(HtG" : fHcf(HX\f(\YYYXH;r(|$@H|$`Ht$hH$   H$   f((t$PHpA^A]A\fWHpA^A]A\HWH  HD$ HXHHHH! HG H$   E3E33H$     HY H$   HLCL+H$   Z A   E3H$   HL$0  HD$0HcHHL0     HD$0HcHdHHD$0HcHHDP   HHL$0  HHcQHB    HEHtHL$0f  u2HL$0X  H$   ! HL$0:  H$   s! 2H$   H  _M;   H\$H|$IMMI+HHH}   HILHI+MLHKLHM+HKDM@H H H^A@HA^LH@^A@H^IHuM;}3HHHHL L+M+JHIB^DAuH\$H|$HL$WH0HD$ H\$HHt$XHH3|$PEtH#e HAPH) HA`D$P   蟂HwW HH]W HC(HCPHcHH*W HDPHCPHcHQTLHtH~(HHK(aHH\$HHt$XH0_LAMtI@3H@LPIHH+HLIHLIIM  MtI@3IH@Hf(fY   MtI@3H@   I;Hf(IfY}LMtI@3H@Hf(fYfXMtI@3H@HI;Hf(DfYfX|M;fX~"MtI@3H@HfB(fYfXM;f(fX   II+H   IRMtI@3H@HBYXMtI@3H@HBDYXMtI@3H@HBDYXMtI@3H@IL;HBDYXhM;}+MtI@3H@IM;HBLYX|f(MtI@3H@   L;HY   IBH   MJfD  MtI@3H@HYXMtI@3H@HDYXMtI@3H@HDYXMtI@3H@HI;HDYXlI;}*MtI@3H@HI;HLYX|f(H\$UVWH0I@ 3II+@HHHHtRLd$PI      H;r HOH@D$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]H? LLHD$(Hh? HHHD$ 萟H\$ UVWH0I@ 3II+@HHHHtfLd$PLl$XI      IH;r HOH@D$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]HH LLHD$(H> HHHD$ 輞H\$LAMtI@3H@ HXHHH+HLHHLIIM  MtIP3HtHB3H@HHtHB3H@Hf(fYMtI@3IH@Hf(	fY  MtIP3HtHB3H@Hf(AHtHB3H@HfYAMtI@3H@A   M;Hf(YfY       MtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfBYfXMtIP3HtHB3H@HHtHB3H@HfB(TfBYTMtI@3H@IM;HfB(DfYfX,M;fX~dMtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfB(fYfXL;f(fX}iMtIH3HtHA3H@HHtHA3H@HBBYMtI@3H@IL;HBYDX|f(H\$MtIH3HtHA3H@HHtHA3H@H	Y
MtI@3H@   H;HY	}gMtIH3HtHA3H@LHtHA3H@HAYMtI@3H@HH;HYDX|H\$f(HWH`  HD$0HXHhHp IIHHM;H      DBHL$` H.F HL$pHH( HHE HHE HH@E HHE HT$8HL$`| HGH$  HD$@H|$XHCD$@HD$ L
D L$  HHL$`  I[IkIs(I_M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBXDCD|M;D  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3AAOAYI\AAMtIBHtHH3HtHA3H@HHtH3ALAAYI\AAMtIBHtHH3HtHA3H@HHtH3AYI\AMtIBHtHH3HtHA3H@HHtH3AAI)H I HYI\AALd$0Ht$(Hl$ H\$L;}aIE L MtIBHtHH3HtHA3H@HHtH3BCIL;YI\CD|A]_M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAYAAXAAAMtIBHtHH3HtHA3H@HHtH3ADYAAXAAAMtIBHtHH3HtHA3H@HHtH3YAAXAMtIBHtHH3HtHA3H@HHtH3I)H I HYAAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;YACXDCD|A]_@SH HL L[xH [HL$SH0HD$ HD$P    EtH>T HAhH HAxD$P   ڕLK LHK HC@HChHcHHK HDhHChHcHDd    HH0[@SH H肘L# L[xH [HL$SH0HD$ HD$P    EtHS HAhH HAxD$P   LK LHiK HC@HChHcHH6K HDhHChHcHDd    HH0[H\$WH H謖Lm L_xtH HH\$0H _H\$WH HJ HًHH7 HA@HIHHtHP tHCH    HB HKH H4 @tHR HH\$0H _H\$WH HL L_xtH HH\$0H _H\$WH HI HًHHP6 HA@HIHHtHP tHCH    H* HKH- Ht @tH HH\$0H _LSH   HǄ$   AC    HYH~Q ICH ICAC   HHL$  H HD$ HSHL$8 H HD$ HtH@3Hd5 HD$`HKHL$hHtHPHCHD$pHCHD$xC $   HH HD$ HH HD$`H$   HcHH\H H   H$   HcHǄ       H
 HL$ x LSH   HǄ$   AC    HYH^P ICH ICAC   HHL$  Hy HD$ HSHL$8}
 Hu HD$ HtH@3HD4 HD$`HKHL$hHtHPHCHD$pHCHD$xC $   HG HD$ HG HD$`H$   HcHHG H   H$   HcHǄ       H
 HL$ X HL$WH0HD$ H\$HHt$PHH3|$XEtH3O HAhH HAxD$X   ϐHF HHF HC@HChHcHHF HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtHsN HAhH HAxD$X   ϐHgF HHMF HC@HChHcHHF HDhHChHcHQTdHtH~@HHK@QHH\$HHt$PH0_@SH HD$0    躭HH [@SH HD$0    HH [H    D)$   fD(Ȩuy
AS 1S !S ` 
  
 S ( R 
 
R 
 
R  
  ` fWۨuiR 
pR ߛ g OR 
_ 
7R W R W 
G O O    Q 
Q n  Q 
 
Q  Q 
 
nQ  VQ 
 
>Q  
    Q 
Q ݚ  P 
ݙ 
P ՙ P ՙ P 
 
P ř ř 
 %]P D)l$@D)t$0D)|$ umD-6P D5%P D=P 3 
O O D- D5 D= 
  %Ș f(+
ژ D=ɘ D5 D- - )$    u[5kO [O   5J 5:O %* 5: 5O  5* * % @ui5N N @3 5 5N  5 5N 5 5{N 5 5cN 5 xb5GN 7N Ř 5
 5N  5 5M  5 5M 5 D)$   rDM D R 	D 	D)\$`rDrM 	D]  	DL 
)$   r=6M 
="  = D)T$prDL D  	Dו r5L 5  5 
D)d$PrD%L 
D%{ ] 	D%j fA/v	fDW
R fD.zu	f(  H fA/r^fA(L$   H H
Ζ E3AY$   pY= @ EXf(fA(\A\AYY7  D? fE/rjfA(L$   H H
 E3AYYK \$   Y5? EXf(fA(\A\AYY  E^fA(AYf/   f(fD(DY Y X֔ DXDYYX EXDYYEXX DYEXYXw DYDXYXD^   f(^f(fD(DYYX9 EXDYYEXX& DYEXYX DYDXB YX DYDX0 YX D^f/   fD(f(DY Yk DX XR DYYDXh X0 DYYDXF X DYYDX$ X DYYDX Xʒ    ^fD(f(DYߒ Y DX֒ X DYYDXĒ X DYYDX Xz DYYDX Xh DYYDX XV D^fA(1 f(fA( f(fA( - f(EY^X\AYAY\Yf(D(|$ D(t$0D(l$@D(d$PD(\$`D(T$pD($   ($   ($   D($   H   M;  H|$ AT
( III+LLHI  HH\$Hl$Ht$ N   II+ؾ   HHH+H+HIHMMtIBHtH3HtH3H@L*HB	fWBMtIBHtH3HtH3H@HBD	fWBMtIBHtH3HtH3H@HBfWMtIBHtH3HtH3H@H I HHHDfWBHt$ Hl$H\$L;}FI$MtIBHtH3HtH3H@IL;HBDfWBD|H|$(A\M;L}kHHLMtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCXDCD|@SH H"L3 L[xH [HL$SH0HD$ HD$P    EtHA HAhH HAxD$P   誠LS< LH9< HC@HChHcHH< HDhHChHcHDd    HH0[H\$WH HlL} L_xtH HH\$0H _H\$WH H; HًHH % HA@HIHHtHP tHCH    H HKH HD @tHb HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtHC@ HAhH HAxD$P   ߁H7 HH7 HC@HChHcHH7 HDhHChHcHQTdHtH~@HHK@!HH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH? HAhH HAxD$P   ߁Hw7 HH]7 HC@HChHcHH*7 HDhHChHcHQTdHtH~@HHK@aHH\$HHt$XH0_LSH   HǄ$   AC    HYH> ICH# ICAC   HHL$ ) H HD$ HSHL$8 H- HD$ HtH@3H" HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H9 HD$ H8 HD$`H$   HcHH8 H   H$   HcHǄ       H
 HL$  HL$WH0HD$ H\$HHt$PHH3|$XEtH= HAhH HAxD$X   诜HW8 HH=8 HC@HChHcHH
8 HDhHChHcHQTdHtH~@HHK@聧HH\$HHt$PH0_@SH HD$0    蚡HH [@SH HD$0    HH [@VM;MHL  II+HW  HH\$Hl$H|$ Ld$(J   I   II+H+L+HLHHMfMtIBHtH3HtH3H@KH
YAAMtIBHtH3HtH3H@HDYAAMtIBHtH3HtH3H@HYAMtIBHtH3HtH3H@I H HHHBD	YAA	Ld$(H|$ Hl$H\$M;}EHMtIBHtH3HtH3H@IM;HBDYBD|^M;  LMK ISSVAUH@IMII+HI{H`  HIkMcMsM{MM+A   HIH+N$   IL+I,ILK4HtHCHtH3HtH3H@I|- H9 EHtHCHtH3HtH3H@HD9n EHtHCHtH3HtH3H@HB!6 E HtHCHtH3HtH3H@HI) H I IELl$xHT$hL|$ Lt$(Ld$0Hl$`I;}CH:HtHCHtH3HtH3H@H荿 HI;D|H|$8H@A]^[H\$M;IML}L
MtIBHtH3HPHtHJ3HtHA3H@L HtH3CYAHtHB3H@IL;HBXDCD|H\$@SH HL L[xH [HL$SH0HD$ HD$P    EtH.8 HAhH HAxD$P   L4 LH4 HC@HChHcHHv4 HDhHChHcHDd    HH0[H\$WH HLL
 L_xtHp HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtHS7 HAhH HAxD$P   _H2 HH1 HC@HChHcHH1 HDhHChHcHQTdHtH~@HHK@1HH\$HHt$XH0_LSH   HǄ$   AC    HYH6 ICH ICAC   HHL$  H HD$ HSHL$8 HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H2 HD$ H2 HD$`H$   HcHHp2 H   H$   HcHǄ       Hj
 HL$ 褼 HL$WH0HD$ H\$HHt$PHH3|$XEtHs5 HAhH HAxD$X   /H2 HH1 HC@HChHcHH1 HDhHChHcHQTdHtH~@HHK@QHH\$HHt$PH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH4 HAhH HAxD$P   oHG1 HH-1 HC@HChHcHH0 HDhHChHcHQTdHtH~@HHK@葞HH\$HHt$XH0_@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HDJD|H|$Ht$M;}%LIPI IHIIM;HJD|[HcAH+HcAH+4HcAH+THcAH+HcAH+THcAH+DHcAH+dHcAH+DHcAH+THcAH+$HATAUAVH  HǄ$   HXHhHpHx IMLLHi; I@    I$IIP      DBH$    I$IIPH
: H: HEH$   蕵HH: 膵HI HHh: kHI HH=: PHHt H$   H$   . HHL$P H HD$PHHL$h H-
 HL$PG I$IIP      DBH$    H9 H$   豴HH9 袴HI HH9 致HI HHY9 lHH H$   H$   J HHL$P, H HD$PHHL$h HI
 HL$Pc I$MHT$ IPH$   HT$@LHL$8L+IHF H+FHL;     DBH$    HS8 H$   螳HH8 菳HI HHq8 tHI HH7 YLH$   IH7 H$   2(H$   S3HL$@HHT$8H+HHtcHt,H$   $HL$@HT$8H+HH;r HT$8HH$   ! HHL$@HHT$8H+HH;r)H$   ưH$   H$    HHL$Pb H HD$PHHL$h H
 HL$P虵 3HM  fD  HF H+FHH;r HT$@HL$8HnHH+HH;r HT$@HL$8HH9D uHHH+HH;r     DBH$    H5 H$   螱HH6 菱HI HHq6 tHI HH5 YHH HH5 >LH$   IH5 H$   (H$   8HL$@HHT$8H+HHtcHt,H$   HL$@HT$8H+HH;ro HT$8HH$    HHL$@HHT$8H+HH;r)H$   譮H$   H$   g HHL$PI H HD$PHHL$h Hf
 HL$P耳 Ht] H\$8H\$@H\$HHL$ D L$  I[ Ik(Is0I{8IA^A]A\H\$Ht$WH HA 3HH+AHHHta     HC H+CHH;rI HKH94t$HC H+HH;r) HKH# HC HH+CHH;rH   Ht育 H   H   H   H   a H   HtP H   H   H   H   / H   Ht HKxH   H   H     HKHHt HK0HsHHsPHsXݱ HKHtϱ HHsHs Hs(H\$0Ht$8H _鬱 H\$Ht$WH@HB LI HH+BL+IHHHp L3 HD$0H3 H
3 HD$(IHT$ HG Hs H+GH+sHHHu HC HH+CHHu HKLHH\$PHt$XH@_H	H%^ H)3 HHIH%C H\$WH H2 HHHI tH茰 HH\$0H _H\$WH HHH;t/HHΗL_(HWHKL[(蹗HW0HK0謗HH\$0H _@SH HHI0 HK{ HKH [H%k @SH HHI(U HKK HH [H%< H\$WH HHIHHt衯 HK03H{HH{PH{X芯 HKHt| HH{H{ H{(H\$0H _^ @SATAUH HZ LJLLHgfffffffLM+IHHH?H   Hl$@Ht$HH|$PL;vw I4$Huh E3LI;[wT HkI\$I;\$ v> I<$HtH;t* H;t`Hu E3LI;[ r IMHy Hn H:Hu E3LI;[ r H(I荓IMH0 H1 H0 H|$PHt$HHl$@H A]A\[@SUAUH HZ LBHHLI+H  Ht$@H|$HLd$PL;v= Hu Hu. E3LI;[w H}LcH;} v H] fHtH;t I;taHu E3LI;{ r IM6 H3 HHu E3LI;{ r HH   IM H H Ld$PH|$HHt$@H A]][@SH HHI5 HH [H%& @SH HHI8Ht腬 HK 3HC8HC@HCHn L LH [H\$Hl$Ht$WH0Hi HH9iv H3Hl$(3Ht$ (D$ fD$ Hu LLH]I;[ wHtHHH;XsY HD$ HuI H8H;_ r8 Hl$HHt$PHH\$@H0_HL$ATH0HD$ H\$HHt$PH|$XHHٹ   蝫 HtH33HHHw H+wHHKHK HK(Ht}HH;v訄HKHˤHCHC HHC(Hw H9wv{ LgL;g vk HKI+HH    H<
HtLM H{ HH\$HHt$PH|$XH0A\HL$WH0HD$ H\$HHt$PH   親 3HtH8HHHwHw Hw(H_0   z HtHHHHsHs Hs(HH\$HHt$PH0_@SH0HD$ Hٹ   $ 3HtHHHHKHK HK(HH0[H\$Hl$Ht$H|$ ATH@Hy0MHH_H{i u#HKI tH[HH{i tHH^0H|$(HD$ HtH;t H;tHWIy uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$WH HHIpHtѨ HKX3H{pH{xH   跨 HK@Ht詨 HK(H{@H{HH{P蔨 HH\$0H _H% H\$Hl$Ht$WH Hq HH9qv H{H;{ v H9{wH;{ v H+H9swH;s v HtH;+t H;t/HC H+HH    H,:H~LLH* Hk H\$0Hl$8Ht$@H _@SH03MM؈D$(D$@HLIMIHˈD$ =H0[HWHpHD$ HXHhHpHHH HHw H9wv H_H;_ v HHD$0H\$8(D$0fD$0H;tfD  HH u	H(H;uHwH;w vW HD$0HtH;tB H+HgfffffffHHHHH?HHL$@& HL\$pI[IkIs I_@SH L+LIIJ    J
MtLMH HH [@SH0HD$ Hٹ   D HD$HHt3HSDIDHLE3Mu3
IChHcHJDhH0[H(LALIHQ II+HH;|
L+II+IHAH	Ht螥 H(@SH A   HD$0    THH [HSUVWATAUAVAWH   HǄ$   HE3D`L- LhLpLxL`pED$H¸
 HH L51 L$   H
 H$   H= H|$pL=O L$   Ǆ$0     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$X H HD$0H HD$XHD$pHcHHn HDpHD$pHcHQTlIH$@  H$   HtRHH$8  P(HH$@  Ht
HHPH$8  HtHP H$8  IEH$8  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP Ho HD$@Ho HD$HD$P   qk X  `k X   > HH$H  HtXHx@LxPǄ$0     HT$0HHW
 HH5
 HC(HC@HcHH
 HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$H  0HT$(HHL$(HH$H  Ht GuHHPGu	HHPLHHL$ rHD$ HNj HD$(HJj Ht/@H\$(Ht CuHHPCu	HHPH
o ֢ Hi HE Hi HEHt@H" HD$0H HD$XHD$pHcHH HDpHD$pHcHQTlLt$0H  H\$XHL$X0 Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$    L$   H$   HtHP HHH   A_A^A]A\_^][LSUVWATAUAVAWH   HǄ$   HE3EcL-
 MhMpMxMcAsH> ICISIKD L5 L$   H	 H$   H= H|$pL= L$   Ǆ$@     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$Xs H{
 HD$0HW
 HD$XHD$pHcHH"
 HDpHD$pHcHQTlIH$X  H$   HtRHH$H  P(HH$X  Ht
HHPH$H  HtHP H$H  IEH$H  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP Hdl HD$@Hk HD$HD$P   f X  f X   語 HH$   HtXHx@LxPǄ$@     HT$0HH	 HH HC(HC@HcHH HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$   HT$(HHL$(HH$   Ht GuHHPGu	HHPLHHL$ mHD$ He HD$(He Ht/@H\$(Ht CuHHPCu	HHPH
 B H~e HE H{e HEHt@H HD$0H HD$XHD$pHcHH} HDpHD$pHcHQTlLt$0Ht H\$XHL$X Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$   Q L$   H$   HtHP HHH   A_A^A]A\_^][H\$UWAUH@LB HHL+BHI I*H+OIILIIH?LILD$0L} HHH_ H
P LHD$(H I?HD$ LHHO IH+O3HHHH?H   Ht$`Ld$hH@ HM IH+MHHHH?HH;r HEHO H+OL$IHHHH?HH;r HGIH*HO IH+OHH0HHHH?HH;nLd$hHt$`H\$pH@A]_]HLH L@HPSUVWATAUAWH@  L$  H$  L$  D)@D)HH$  H$  L$  LHHIDIIMDE3HHH$  HHL$  HLH   IH\$hII+L$  H;HD$pILMHMH,L$HHMuL$  IHL+D$  fEWL$  )$0  H  )$   J    D)$   H$   E3IHKAO<D)$   D)$   D)$   H$   IID)$   D)$   HKܺ@   HD$xI$   Lt$@HD$8KH$  IL|$H\$ HD$(KAIHD$IHD$K@IĀ   HD$hHHL$0HHHD$`ffff     H$  J    H~XH$  H$  IIHJ         fWHfpDHHf)JuH$  HL$0M"  H$  LL$8N    AfDHLIfD)$   IDL$  HIHǀHI+IIIffff     H( fD(fD(fD(fD(fD(fD(fD(f(f)D$PA	C
IH7  LEIIf(!fD(Af(f(Pf(X f(h@f(pPf(x`f(fAYfYfDXf(H0fDXf(fAYfYfDXf(Q fDXf(fAYfYfDXf(XpfDXf(fAYfD(D$PfYf(   fDXf(I0fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYf(IPfYf(Q@fDXfDXf(fYfD)D$PfYfDXfD(   f(   fDXf(fYfYfDXf(   fDXf(fYfYfDXfDXf(fYfDXf(Y`f(   f(|$PfYH   f(IpfA(fXHIfYfDYfDXf(fEXfYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDXf)|$PfD($   I;   ML+D  f(!f(if(H f(Pf(X f(fYH@IfYfDXf(HfDXf(fYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDX{f)|$PfAAffZfA(H IfAYfAdfAiftI fzfXfA(H IfAYfA`fAhfA(fXfA(fAYfXfA(fAYfXfA(fAYfXfA(fAYfXfA(fD(D$PfAYfAYfD($   fXfApfTfTf`fhfA`fAhfApfXfAxftftfpfxfApfAxD$  fEWL$  H$  L$L$  H\$ H$  Lt$@H|$p/  L$  IHJ`H	f( If(f(f(H  HUHH    f(	f( H   H@HfYfXf(fYfXf( fYfXf(0fYf(IfXf(@fYfXf(PfYfXf(`fYfXf(pfYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYfXI;}UIH+ff     f(	f( H@HHfYfXf(@fYfXf(@fYfXf(@fYfXuJAAffJf(f(fYf(fYfXf fYfYfXffXfBff[ffPf	fIfXfB$fBdL$  H$  L;?  H$  H$  L\$H\$H|$(IL4H$  IH$  ILL+$$L<    Ht$Lffffff     A	3IfA(fA(fA(fA(I   MBIIIIJ    fQYHH If(f(Y@YHXXf(Y@YPf(XXQYHXf(f(Y@YHXf(XY@YXXXYf(f(Y@YHXf(XY@YPXf(XY@Xf(YXY@XXI;}BAHH I;f(f(Y@YHXf(XY@YPXX|AYAYAYIHHHMIXffXoAYoXssAX{A{8L$H\$ Lt$@L|$H$   HL$0L$   HT$8HT$HT$HT$(HD$xL$  H$  H$  L$  L$  HHLHl$`H$  H\$ HL$0L|$Lt$@NH\$hD($   D($   D($   D($   D($   D($   ($   H$  H;  H$  HN4    IJ	M<HH$  H$  H+H<JH$  M$H$  HDH$  M~1IHIfW HfpDHHf)IuH$  M   L$  (5 HIHAL$  IAfILIIA	f(f(IM~3ID  f(	f( HH HfYfXf(@fYfXufA@f(f(I LIfYfYfXfA@fAPfAPfXfAHfAHiL$L$  H|$p   L$  IL$  HJ@I	f( M~)IIH+     f(HHfYAfXuAAffA$fYfXfA$fAL$L$  L$  H$  L;  H,    IIHIHMI+fffff     AE3IfA(|yIRLHOHM+I@HL    fffff     HAH H HYIY@Xf(HX@YIYAXXuM;}(HIKI+I+HHY@XuAYHLHXSS(L$H$  H$  H$  L$  H    MMHH$  IHH$  H$  ($0  L$  L$@  E(CE(KIA_A]A\_^][@WATAUH0HD$ H\$PHt$`HHHH;vcHIHu3HC(H+HH;   HKLHD$XH{ H9{v LkL;k v I+HHtH    LMI{ HKH{ H+HHt IHC(IHC LcH\$PHt$`H0A]A\_@SH0HD$ Hٹ    HD$HHt3HSDIDHTLE3Mu3
IChHcHJDhH0[@WH0HD$ H\$@HD$H    X   臈 HHD$PHttH HG@H HGPD$H   HSHH HHv HG(HG@HcHHC HD9@HG@HcHDADD9<HSHYk3Hu3
HG@HcHHD9@H\$@H0_@WH0HD$ H\$@HD$H    X   跇 HHD$PHttHK  HG@H  HGPD$H   HSHH HH HG(HG@HcHH HD9@HG@HcHDADD9<HSHj3Hu3
HG@HcHHD9@H\$@H0_@SH0HD$ Hٹ    HD$HHt3HSDIDHLE3Mu3
IChHcHJDhH0[HHD 3LL$XLD$`3)t$0)|$ D$XD$`5 = fTf/vw  "   
 3LL$XLD$`3҈D$XD$`fTf/v>  "   
 3LL$XLD$`3҈D$XD$`fTf/v  "   o
 3LL$XLD$`3҈D$XD$`dfTf/v̼  "   .
 3LL$XLD$`3҈D$XD$`+fTf/v  "   	 3LL$XLD$`3҈D$XD$`fTf/vZ  "   (t$0(|$ HH@SH A   HD$0    HH [H\$UWAUH@LB HHL+BHI I*H+OIILIIH?LILD$0L
 HHH H
 LHD$(HI I?HD$ LHHO IH+O3HHHH?H   Ht$`Ld$hH@ HM IH+MHHHH?HH;rY HEHO H+OL$IHHHH?HH;r* HGIHʂHO IH+OHH0HHHH?HH;nLd$hHt$`H\$pH@A]_]@SH A   HD$0    4HH [M;  VAUIIMI+LLH  HH\$Hl$ L H|$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAXAAAMtIBHtHH3HtHA3H@HHtH3ADXAAAMtIBHtHH3HtHA3H@HHtH3XAAMtIBHtHH3HtHA3H@HHtH3I)H I HXAAALd$0H|$(Hl$ H\$L;}WIE L MtIBHtHH3HtHA3H@HHtH3BIL;XACD|A]^LAMtI@3H@HHMtI@3H@LXLIHH+HLIHLIIM[  MtI@3IH@fov Hf(	fT   MtI@3H@   I;Hf(QfT}LMtI@3H@Hf(fTf_MtI@3H@HI;Hf(DfTf_|M;f_~"MtI@3H@HfB(fTf_M;f(f_L$o  D II+H  ISMtI@3H@HHD$BfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$IL;L$M;}FMtI@3H@HHD$BfTf/D$wHD$IM;L$|f(MtI@3H@    L;H	fTL$`  ICH  MKMtI@3H@HHD$fTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$HI;L$I;}EMtI@3H@HHD$fTf/D$wHD$HI;L$|f(@SH0HD$ Hٹh   | HD$HHt3HSDIDHDLE3Mu3
ICPHcHJDPH0[@SHPLQL	H)t$0Ap)|$ A8f.= zuf.5 zO  Hl$pHt$HH|$@D)D$D)$LT$`tM&HHD$`HT$hHHكL;HL$hHMLIDI+3HDHfDH+HII<CfD  ISMIIHL+HCHH4    fYP!H H Hf(f(YY\A\ YYXPPIf(f(YY\YYYXPPAL f(f(YY\YYPPXf(YYIf(YY\XPII;}NIIHH+H+HHf(f(YY\YYXXLuOLT$`AtI&IHD$`HT$hHHكL;HL$hHMH I;utL;  HII+I+HHHH     fA(f(IHHf(f(fAYfAYf\fAYfAYf)XfXfA)Hu  HHHHIL;   HIHI+I+I+HHIhHHfD  fAfm f(f($.f(I H H HfAYfAYf(fAYf\fAYf)RfXf(fAYfAYfAHfMf(fAYfAYfXf\fMf)d.fMoH;tAfAf(f(fAYfAYf(fAYfAYfXf\fAf)fALI;D($D(D$Ht$HHl$po  IH+H  IMITH+L+HDHHHH<fD  ZP"H H Hf(f(YY\A\ YYXPPJf(f(YY\ZYYXPPAL f(f(YY\YYPPXf(YYJf(YY\XPJI;}JL+HL+AHIf(f(YY\YYXXALuH|$@    (t$0(|$ HP[@SH A   HD$0    HH [H  HD$ HH$   -HHL$(HKH
 HL$(Uv H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(
fY	   MtI@3H@HMtI@3H@A   M;Hf(RfYQ}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXM  HI+H   HSMtI@3H@HBMtI@3H@HBYXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@IL;HBYDX
L;}AMtI@3H@HBMtI@3H@IL;HBYDX|f(H\$MtI@3H@HMtI@3H@   H;HYA  HCH   LKMtI@3H@HMtI@3H@HYXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HI;HYLXH;}?MtI@3H@HMtI@3H@HH;HYLX|H\$@WHyLYE3LH  
/ fWH\$fD  3I   I[DRI;uf(f(IIIIHIBI;uf(f(IIIHIM;uf(f(IIIIIIBI;uf(f(IHIIIHH;I_I;}*I;uf(f(IIIIHHI;|IL;H\$_LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHǅ8  )@  MMHU8H  L(L}pHGH  L  LE8H;MMIH]XIIHN,    II;vnAHHEHHuL$    I   w6H   HHH;wHHH&x H+HD$pHHHE1I HEHuMt@HIL  3H9HDH  H  H    H=     I;v@HGHE HunH    H   w6H   HHH;wHHHcw H+HD$pHHHE 'HT HE HuHt1@I3H9_HDH   H(  H    H=   0  M;v?HGHEPHukJ    H   w=J   HHH;w
HHHv H+HD$pHHHEPH HEPHuHtw?E3L9WLDL   J    H=   E 3HUE3LE(IIH   IHH   3H}0L  IHM8IL  IHH   5 D  I;  H  HEpL  H9MpIML(L   ML L   I+H   IIHu LL   H~>KMHD$8    HD$0    HL$(Ll$ MIH  HULE(3M   HEH   IMIL  H  H~KHMHH  HHNIHMHD$8    Ll$0HHD$(H\$ MHH  ipHHII;HULE(|L  L  Hu H}03HMH  H  J    H   IHH   IHH   LEXIHH   LHUxH  LLUH L  H  LMXM;IMHE3ML   HE(HE`ML   LH   HH   LUhH}M;  Hǅ     LE@H  L]@IINH8H   HEML]@M~`HEPHD$hLt$`Lt$XLl$PLl$Ht$@H|$8Ld$0H\$(LL$ LMMIH  HMH  L]@LUhMH+  H  L4    MFN$    LxMIffffff     H  M(  LLHE`IIH  LH<I+H  I A3H   MAIJHCHHH    @ f(AYHA\Af(Y\f(AYHA\Af(AYA\AH I HuH;}0IMM+HH+f(BY  \ HHuMMIHH   H   MFL]@H  A3H|cIBHSHHH    ffff     @^@H^H ^ H^HH HuH;}A^AHH;|IMML;HML   L  E3HELH  LLd$8L   Ll$0H\$(H|$ MH}HH  oIL   H   HE`L   IH   LUhMLUhL   IL   L   L   L   HMH  wL   M~uH   IHHHEPHD$hLt$`Lt$XHD$PHD$Ht$@LD$8Ll$0H\$(H   HD$ LMH  HMH  LEXIHMLuxL   LuxLUHJ    LLUHH;  Hu H}0]L  HUHUpHUHM8H   HM8LE(L   LE(H   H}0L  L  ^}  tH   C 0   tH   ,    t
H   (@  HX  A_A^A]A\_^[]M;   Hl$Ht$ WH HH\$0Ld$8L IIHHtHFHtHX3HtHC3HtH3H@Hpe HtHC3H@HH;HYDAD|Ld$8H\$0Hl$@Ht$HH _@SH0HD$ Hٹ   e HD$HHt3HSDIDHDLE3Mu3
IChHcHJDhH0[@SH0HD$ Hٹ   de HD$HHt3HSDIDH褏LE3Mu3
IChHcHJDhH0[H\$HYLQE3LH   
\ fWE3M~eHtHBHtH3HM;uf(f(HtH3H@(HHH II\IIIKIIM;|IL;|H\$@SH A   HD$0    HH [@SH A   HD$0    tHH [@SH0HD$ Hٹ   c HD$HHt3HSDIDHLE3Mu3
IChHcHJDhH0[@SH A   HD$0    HH [LWATAUAVAWHPHD$ I[Is MMLHIKIHIAHAIKI HI@HAICHtI;Ctj Ht$8H+t$HHHCHu3H{(H+HH3  LS IH+HHHH+H;s<L1I;  HHH+H;s3HI;IBHKH
\LH$   IMLCI+HH    LL$   HtLHv L$   HL$@IHIFHAHL$0IHIGHAHD$HLD$8I+HH    N4HtLI HS MEI+HHtHLI HKHC H+HHHta IHC(IHC Lc   HL$@IHIFHAHL$0IHIGHAHT$HLD$8I+HHtHLIt HK IULH;t!HL;tA HI IL;uHK HLI;t!II;tI HA HI;uHC HH;t HH;tHHHH;uHs L\$PI[8IsHIA_A^A]A\_M;   UVATH H\$@H|$HLl$PL*MIH@ HtHEHtH3HxHtHG3HX	HtHC3HtH3H@HM_ HtHC3H@HYHtHG3H@8HI;HXDADeLl$PH|$HH\$@H A\^]@SH0HD$ Hٹ   _ HD$HHt3HSDIDHĢLE3Mu3
IChHcHJDhH0[LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MMH0  LG(LEHGH0  L0  L   H;MMIHE(HIMLJ    HEII;v/L/HMusH4    H   w2H   HHH;wHHHf H+Ll$pII0H LHuHtz/HIE3IH9IDHEHH]PH    H=   EXM;v4/HwHulJ    H   w2J   HHH;wHHHe H+Ht$pHH)H HHuHt.E3IIH HDHE`LehJ    H=   EpHUI;v.LgMumH    H   w9H   HHH;w
HHHHe H+Ld$pII#H= LHuHt.HUE3MH MDLE8H    H=   0  IM  HUHH   HHE0(  H   ff     HHUH   LEL;IML0L+LL$8LL$0H\$(Lt$ L  L  HHM CKE3MH   H  LE(L  H   HM     K<H}@H   LE@H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM VuLd$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM LLHM LE(J    HHM LH   H;A    )L   H   HMHEH  L}0L   L   I;HUmLE80  t
I
 }p tHM` }X t
HMH (   H   A_A^A]A\_^[]@SH A   HD$0    tHH [LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MH0  Lw(Lu HGH0  L0  L   H;MMIHEHIMLIII;v*L/HMusH4    H   w2H   HHH;wHHHa H+Ll$pII0H LHuHt*HIE3IH9IDHEHH]PH    H=   EXM;v?*HwHulJ    H   w2J   HHH;wHHHa H+Ht$pHH&H HHuHt)IE3IH HDHE`LehJ    H=   EpM;v)LgMuiJ    H   w9J   HHH;w
HHHW` H+Ld$pIIHL LHuHt*)E3IH IDHU0J    H=   0  IL   M  HU HH   HHE@HL  IHHE8(  H   HHUH   LUL;IML0L+L\$8L\$0H\$(Lt$ L  HHM rE3MH   H   LEL  H   HME3K<H}(H   LE(H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM _pLd$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM ULHMLEJ    HHMLH   H;,L   H   HMHE8H  L}@L   L   I;HU L  A    oHU00  t
H }p tHM` }X t
HMH (   H   A_A^A]A\_^[]H\$M;IML}uL
MtICHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CD|H\$@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHDIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HD JD|H|$Ht$M;}&LIPI IHIIM;HDJD|[H\$M;IML   HL MtIBHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CXDCD|H\$HcAH+HcAH+$HcAH+HcAH+鴬HcAH+dHcAH+HcAH+HcAH+HcAH+HcAH+@WH0HD$ H\$PH3|$HOR HtHHHH{H{ H{(HH\$PH0_HL$VWATH0HD$ H\$XHl$`HH& HHc3IuH,I;va#H,    H_ HuHt@#HGH_HuH,I;v##H,    H! HuHt#HGH_ Hw(Ht/I;v"H,    H HHuHt"Hw0H_8HH\$XHl$`H0A\_^H\$Hl$VH0LI HqHMHgfffffffHL+IHHH?HH;w)H|$@I;vG HHt$(3H\$ (D$ fD$ Hu" LLHD H4I;s wHtHHH;ps HD$ Hu H8H;w H|$@r̇ H\$HHl$PHH0^HL$WATAUAVAWH0HD$ H\$hHl$pHt$xLHH HHZH3HuH6H;vR!H<    HP HuHt1!HHFH^I\$ HuH,H;v!H<    H HuHt HFH^ ID$(HF(I|$8Ht9HH;v H    H HHuHt Hn0H~8IT$HNy6IT$HNk6IT$0HN0]6HH\$hHl$pHt$xH0A_A^A]A\_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH膢t,HL$@HtN Hl$@Hl$HHl$PHL$(M t0HL$pHtM Hl$pHl$xH$   HL$XM HHL$   I[Ik Is(I_H\$WH0MM@E3LMtGIHH      fffff     IcD$PHD$PH#H;w0IM;r݋A(L
 H IˉD$ pH\$@H0_Hv H MHD$(HP IHD$ ;H\$Hl$Ht$WH@I@MHHHD$0H- H IHH LHHl$(HD$ LHH.5L_DC(L
 Hp HL\$ LLHHH\$PHl$XHt$`H@_:  LWH   HD$ I[IkIsHHHIHB H+BHH;tYH IKD HL$P H HD$PHT$(HL$hC HÉ HD$PH
 HL$PK HGH9Gr`3HtYfff     HG@H+G8HH;rق Hw8HE H+EHH;r HEXHH;_rHGL$   I[IkIs I_H\$WH HHI8HtJ HK 3HC8HC@HCHJ L- L@tHJ HH\$0H _HL$ATH0HD$ H\$HHt$PH|$XHHٹ   J HtH33HHHw H+wHHKHK HK(Ht}H?H;v#HKH;DHCHC HHC(Hw H9wv{ LgL;g vk HKI+HH    H<
HtLM H{ HH\$HHt$PH|$XH0A\I;t,H\$WH IHH H(H;uH\$0H _H\$WH HYHHt.Ht$0Hq H;tH H(H;uHO-I Ht$0H\$83HGHG HG(H _@SH HHIHtH 3HCHC HC(H [@WATAUAVAWH@HD$ H\$xH$   )t$0MILHHAHu3HY(H+HM  La IH+HHHH+I;s!LI;   HHH+H;s3HI;IBHNHALHD$pM~L+~IJHfHtIE HHHIVLFI+HHtHLI HV MFI?II+HHtHL~ HNHF H+HHHtG IHF(IHF Lf   II+FHH;swA1IVLMHРHV HI+FHHH+Ht
2HHH    HF HN H+IFH;tjffff     0HH;uOA1HIH+MMHHQHF MHIN讬M^I;L;tA3IL;uH\$xH$   (t$0H@A_A^A]A\_@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HH?HH+I;szLI;   HHH+H;s3HI;IBHNH?LHD$`M~L+~IJHHtAE HHIVLFI+HHtHLI| HV MFI?II+HHtHL| HNHF H+HHHt8E IHF(IHF Lf   II+FHH;spAIVLMH譪HV HI+FHHH+    HtHHH    HF HN H+IFH;t`@ HH;uOE!HIH+MMHH5HF MHIN袪M^I;L;tD  E#IL;uH\$hHt$pH0A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMu3Igfffffff(HI(I+IgfffffffIHHHHH?HM?  MD$ II+IHHHH?HHfffffffHH+H;sL2I;^  HHH+H;s3HI;IBHIL$m<HHD$8IMI+L$IHLIIH?LL|$@D$0    KH3D$($   D$ ML$L$   HI6D$0   3D$($   D$ ML$LIUIL$yD$0   I7LN3D$($   D$ ML$IT$ IM@ML$IL$ I+IHHHH?HHMtMD$ IIIL$(B HHIL$(HHIL$ I|$  M+EIIHHH?HH;   IHL$Pax HH    IML3D$($   D$ ML$IT$ sMT$ II+MIHHHH?HH+3D$($   D$ ML$LD$PHI4I\$ I|$ H+I]H;tHT$PHJw H(H;uHL$Pw    IHL$Pw I|$ HH4    HH+3ML$D$($   D$ LHHID$ 3D$($   D$ D$   LHIM4I]H<3H;tfHT$PHv H(H;uHL$Pv HĀ   A_A^A]A\_^[@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HHHH+I;sJLI;   HHH+H;s3HI;IBHNHE9LHD$`M~L+~IJHHtIE HHHIVLFI+HHtHLIv HV MFI?II+HHtHLpv HNHF H+HHHt? IHF(IHF Lf   II+FHH;spIIVLMHLHV HI+FHHH+fD  HtHHHH    HF HN H+IFH;t_ HHH;uNM!HIH+MMHHԗHF MHIN1M^I;L;t@ M#IL;uH\$hHt$pH0A_A^A]A\_HL$SH0HD$ HH   Uu H   Pt HKX=u HKH2u HK8'u HK(u HKu HKH0[H% u H\$Hl$Ht$WH HY HH9Yvt HwH;w vt H9wwH;w vt H/H9_wH;_ vt HtH;/tt H;t2HO HH+HHH;tH+ HHHDH;uHW H\$0Hl$8Ht$@H _HI H%-t DD$SVAUH0Hq HHIHLH+HH;sPH;vs HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MH0A]^[H;   Hl$PH|$XLd$hH;vs H{H;{ vss H+E3Hubs ML] J<I;{ wHtLe I;|$s9s Ld$hH9{wH;{ v"s H+H9swH;s v
s HtH;+tr H;t/HC H+HH    H,:H~LLHr Hk Hl$PH|$XH0A]^[HL$WH@HD$ H\$XHt$`IHHHI^H_8H_@   ; 3HtHHHHsHs Hs(H_p   : HtHHHHsHs Hs(H   HH\$XHt$`H@_HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H   o H   H   H   H-C6?H   H?H   H-q=H   HMbP?H   Hǃ   '  H      ?H  H:0yE>H   H  H   H     @H  H     @@H(  HH\$HH0_HL$WH0HD$ H\$HHl$PHt$XIHHH HRHLx L]H HEHH}XH֐ HEPHu`HuhH 
   >HEpH?HExH   Hǅ       HH\$HHl$PHt$XH0_HAHH f/
| vIxf/
{ v{ f/v   HWH`  HD$ HX)pHHٺ   DBHL$Pm sxH5 HL$`4Hf(m HT$(HL$Pm LHHAHL$(=n HKHHPHL$Plm H$p  ($P  H`  _H\$WH H HHAPHI8n HO n HOn LIz LtH-7 HH\$0H _HT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$Pt%n HL$HH+L$XIgfffffffIHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHfffffffHH+I;sN"I;\  HHH+H;s3HI;IBHHN/HH$   H$   3D$($   D$ LNLH$   HRHNwLH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$HLH$   3D$($   D$ LNHV H$   HHLF LNII+HgfffffffHHHH?HLMtIH.HN4 HHHN(KHHN H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$HH^ I}H;tH(H;tHH$j H(H;uKL$    H^ I<H;t fH(H;tHHi H(H;uHF II}H;tH(H;tHHi H(H;uLf H`A_A^A]A\_^[H  HD$ HH$   HHL$(肮Hs
 HL$(3 H  HD$ HH$   P4HHL$(H
 HL$(E3 @SH HJHHt3 H3HCHC HC(H [2 HIH%]j H   HD$ HH$   P>HHL$(H	
 HL$(2 LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHH詆H0H\$`H0HH0_^[M;   H\$H|$IMHI+HH   HLHII+ODL+HJTHHMf     HBA@H I@I HBHBADIDBHBAHI@JHBA@I@BuM;}0HHL JL+M+HAHIIDBuH\$H|$H   H%h HIPH%h H   H%zh @WH  HD$pH$  HH8 HHEH=8 HHEHL$Hg H8 HL$ 	g A   E3H* HL$Hf HH
f H;tTffffff     L
Qq A   HHL$Hf LCA   HH* HL$Hf HHf H;uHT$HHL$ rd H7* HL$ hd HHL$ Zd H$   g HTn H$   HT$ H$   Qf HIn H$   H$   H$@  [HH$   sH
 H$   / H  HD$ HH$   HHL$(H	
 HL$(E/ H\$Hl$Ht$H|$ ATH`H$   MHHHuHAHxHQLAHFHHJIHLI IHILHLH$   IHD$XHF HD$PHBHD$HHD$@I@LCL\$8HD$0HCLT$(HD$ OL\$`I[IkIs I{(IA\HWH   HǄ$   HXHpIHH` HHEH=` HHEHL$pdd HHL$HUd H
a HL$ Bd A   E3Ha HL$p.d HH
,d H;tM    L
n A   HHL$p
d LGA   H` HL$pc HHc H;8uHT$pHL$ a H` HL$ a HH$   HH$   H$   HC$   3HHHHqDHE3H9` HL$HZc HHXc H;tE LA   HHL$HAc L7A   H_ HL$Hc HHc H;8uHT$HHL$ ` H$   0d Hj H$   HT$ H$   b H%m H$   H$   H$  HhHH$  H
 H$  ', M;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBuHIpH%}b H\$WH H   HH+   HuHHOxo~HHO`H   HH+   HtHAH   H   8~HHOpH   HH+   HtHAH   H   ~HHOhH   HH+   HtHAH   H\$0H _HWH   HD$ HXHhHp IHH3hHIHIP t!HNHLHT$XP(   $   HNHLHT$(P(   $   HHt,HL$@Htx) Hl$@Hl$HHl$PHL$(_) t0HL$pHtJ) Hl$pHl$xH$   HL$X.) HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH|t,HL$@Hth( Hl$@Hl$HHl$PHL$(O( t0HL$pHt:( Hl$pHl$xH$   HL$X( HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP0   $   HNHLHT$(P0   $   HH{t,HL$@HtX' Hl$@Hl$HHl$PHL$(?' t0HL$pHt*' Hl$pHl$xH$   HL$X' HHL$   I[Ik Is(I_Ht$WH HHH;  HR LFHI+HHu  HHt$8H _LQLI M+II;wBI+HH~HIL] HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHMWLO LF HHH\$0HG HHt$8H _MtI% HV HH+VH,tLOLF HVHDHG HHt$8H _Ht$WH HHH;  HR LFHI+HHu|HHt$8H _LQLI M+II;wBI+HH~HIL\ HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHMWLO LF HH脊H\$0HG HHt$8H _MtI$ HV HH+VHLtLOLF HVH4HG HHt$8H _HL$WATAUH@HD$0H\$hHt$xHHٹ   _$ HtHE3E3IHHO H+OHgfffffffHHHHH?HLCLC LC(t{HfffffffH;vQHHKHCHC HHHC(Hw H9wv [ LgL;g v[ 3D$(D$pD$ LKLCHI޹HC HH\$hHt$xH@A]A\_HL$WH0HD$ H\$HHt$PHHYHt$Hq H;tHY H(H;uHO# 3HGHG HG(HH\$HHt$PH0_" H\$Hl$Ht$WH Hq HH9qv)Z H{H;{ vZ H9{wH;{ vZ H+H9swH;s vY HtH;+tY H;t/HC H+HH    H,:H~LLHY Hk H\$0Hl$8Ht$@H _@SH HH  D$0    HHH [@SH HHx  D$0    H`HH [HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtSHH;vH	LHFHF HHN(HHHtHHHHIHF H\$HHt$PH0_H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v>X IE HtH;t*X I}I+HIE HL$ HT$ HIEMHAHA   5LcL;c vW HLd$(H\$ (D$ fD$ HuW LLI<I;{ wHtH3H;~sW H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\T$SVAUH0Hq HHIHLH+HH;sPH;v*W HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MH0A]^[H;   Hl$PH|$XLd$hH;vV H{H;{ vV H+E3HuV ML] J<I;{ wHtLe I;|$sxV Ld$hH9{wH;{ vaV H+H9swH;s vLV HtH;+t<V H;t/HC H+HH    H,:H~LLHU Hk Hl$PH|$XH0A]^[H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;vU IE HtH;tU I}I+HIE HL$ HT$ HIEMHAHA   LcL;c vEU HLd$(H\$ (D$ fD$ Hu"U LLI<I;{ wHtH3H;~sT H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\H\$Hl$Ht$H|$ ATAUAVH0LHHI H{IgfffffffLL+I3MIIHHH?HuH=H;vVT HM HtH;tBT HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   ZHkH;k vS HHl$(H\$ (D$ fD$ HuS LLHH| I;{ wHtH3H;~sS H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\LD$SVAUH0Hq HHIHLH+HH;sPH;v+S HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+M/H0A]^[H;   Hl$PH|$XLd$hH;vR H{H;{ vR H+E3HuR ML] J<I;{ wHtLe I;|$syR Ld$hH9{wH;{ vbR H+H9swH;s vMR HtH;+t=R H;t/HC H+HH    H,:H~LLHQ Hk Hl$PH|$XH0A]^[HL$WATAUH@HD$0H\$hHt$pMHH3HAHA HA(HtZHH;vHHHCHC HHK(3D$(L$`L$ LKMHHHHC H\$hHt$pH@A]A\_HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtQH?H;vHLHFHF HHN(HHHt
HHIHF H\$HHt$PH0_H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;vNP IE HtH;t:P I}I+HIE HL$ HT$ HIEMHAHA   LcL;c vO HLd$(H\$ (D$ fD$ HuO LLI<I;{ wHtH3H;~sO H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HE3LBHLJLJHDL$3H
LBD$HBHBH@SH HH0  KHH [ATAUAVH@HD$0H\$`Ht$pH|$xHHHH;vHIHu3HC(H+HH;   HKLHD$hH{ H9{vN LkL;k vqN 3D$(D$hD$ LKMHIKHKH{ H+HHt IHC(IHC LcH\$`Ht$pH|$xH@A^A]A\f/
Z v%      Ix^,;L   HHHWH@  HD$ HXHH@       DBHL$@K    HL$(K HL$PHcQHLPHPHL$PK HHL$@K Ǆ$`     HL$@K HH$X  H@  _f/
 Y vY f/v   f/
X v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$PJ    H" HL$`Hf(J HT$(HL$PJ LHHAHL$(*K HKHHPHL$PYJ H$p  ($P  H`  _f/
W v   HAHH`f/
W vW f/v   f/
W v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$PBI    H HL$`@Hf([I HT$(HL$P#I LHHAHL$(I HKHHPHL$PH H$p  ($P  H`  _f/
V v   H\$WH Hg HHHZ HAPHI8:J HO 0J HO&J LU LtH HH\$0H _H\$WH Hס HHHZ HA`HIHI HO8I HO I HOI L5U LtH HH\$0H _H\$WH Hס HHHXZ HA`HIHJI HO8@I HO 6I HO,I LT LtH HH\$0H _H\$WH H7 HHH(Z HAhHIHH HO8H HO H HOH L5T LtH HH\$0H _LL$ WATAUAVAWH@HD$0H\$xH$   ILLHAHu3HY(H+HM*  Lq IH+HHHH+I;sLI;   HHH+H;s3HI;IBHIL$	HHD$pMuM+t$IJ3D$(D$pD$ ML$L$   H#3D$(D$pD$ ML$LIUIL$DI6L3D$(D$pD$ ML$IT$ IMDIL$ID$ H+HHHt HID$(HID$ I|$  II+EHH;   IH\$pH<    IML93D$(D$pD$ ML$I!DIL$ HI+EHH+3D$(D$pD$ ML$LD$pHI|$ IL$ H+IEH;tqD  HHH;u^I3HIH+ML$D$(D$pD$ MIHCID$ MHIMM]I3L;tfIIL;uH\$xH$   H@A_A^A]A\_H   HD$ HfffffffH;vSH HL$(D HL$PE HK HD$PHT$(HL$hD HL HD$PHL$PHu3	H(HĘ   HXHD$ HM HL$(AE LM L\$(H>
 HD$@H
 HD$HHL$(H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HHsH0H;uH\$0Ht$@HHl$8H _LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHH	aHH0H\$`H@_^[E3DL$HtHIHAHBHAHBLBLJ LJ(HH\$WH   Hy HHrHIHH@D$@)D$8(H<H LHD$0H L
 HD$(H] HHL$hH|$pHL$PHD$ H|$Xu8HL$PHtG<et<Et<-t<+u2H$   HĀ   _ðH$   HĀ   _HWH   HD$ HXHpHHHyHC H+CHH;ruH* HL$hA HL$(B HI HD$(HT$hHL$@A HT$(H$   H
 HHPH
 HHX@`   HeHGHAHC H+CHH;r5B HCHHHL$   I[IsI_@WH   HD$ H$  HHyHC H+CHH;ruH? HL$h@ HL$( B HH HD$(HT$hHL$@@ HT$(H$   H
0 HHPH
- HHX@`   HzHGHAHC H+CHH;rJA HCH$  H   _LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHHɾH0H\$`H0HH0_^[E3DL$HtHIHAHBHAHBI HBLJ LJ(LJ0H3H
LBD$HBHBHB HH\$Hl$VWATH0Hq A LD$PHH9qv-@ H{H;{ v@ H9{wH;{ v@ H+H9swH;s v? HtH;+t? H;t/HC H+HH    H,:H~LLH? Hk H{H;{ v? HH|$(LL$PHD$ HT$ M(D$ HfD$ %H\$XHl$`H0A\_^HWH   HǄ$   HXHpIHH HHEH=& HHEHL$p> HHL$H= H= HL$ = A   E3H5 HL$p= HH
= H;tM    L
)H A   HHL$p= LGA   H HL$p= HH= H;8uHT$pHL$ R; H HL$ H; HH$   H$   H$   HC$   3HHHHqDHE3Hi HL$H< HH< H;tE LA   HHL$H< L7A   H$ HL$H< HH< H;8uHT$HHL$ : H$   = HC H$   HT$ H$   < HC H$   H$   H$  1HH$  wHX	 H$   @WH  HD$pH$  HH HHEH= HHEHL$H; H HL$ ; A   E3H4 HL$H; HH
; H;tTffffff     L
E A   HHL$H}; LCA   H HL$HQ; HHO; H;uHT$HHL$ "9 H HL$ 9 HHL$ 
9 H$   L< HC H$   HT$ H$   ; HB H$   H$   H$@  /HH$   #H	 H$   C LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCISHxHWH   HǄ$   HXHpIHH HHEH=6 HHEHL$p9 HHL$H9 HM HL$ 9 A   E3H HL$p~9 HH
|9 H;tM    L
C A   HHL$p]9 LGA   H HL$p19 HH/9 H;8uHT$pHL$ 7 H HL$ 6 HH$   H$   H$   HC$   3HHHHqDHE3H! HL$H8 HH8 H;tE LA   HHL$H8 L7A   H HL$He8 HHc8 H;8uHT$HHL$ 66 H$   9 H? H$   HT$ H$   58 H? H$   H$   H$  ,HH$  'H	 H$  w E3DL$MtIMHHHAHBHAHBHAHBHA HB I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhI@HHBpI@PHBxL   L   HLIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCISHxHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHLJPLJXHHE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhI@(HBpI@0HBxI@8H   I@@H   L   L   HH;   HH$LLH	HI H
ML;tIHIHIQMPL;tI
HIH
IQ MP L;tI
HIH
I(I(M;tIII I	H@VATHH1
A LHHT$0L@HHHD$ L;LD$ HL$0HME3L I  H\$(Hl$8H<$H>Il$MtIAHtH3HWLHIHtH3H@f(HHH HI^AXAMtIAHtH3LIXLSIHWIHtH3H@f(HHH II^DAXDADMtIAHtH3LHHWIHtH3H@f(HHH HI^DAXDADMtIAHtH3LLSIHWIHtH3H@f(HHH IIIL;^DAXDADH<$Hl$8H\$(M;}aLMtIAHtH3ISMHIHtH3H@f(HHH HIIM;^AXA|HA\^LAMtI@3LX8IHH+HLIHHHHM~  MtI@3H@0f MtI@3IH@ffY   MtI@3H@0f@MtI@3H@   H;fXfY}sMtI@3H@0fMtI@3H@ffYfXMtI@3H@0fLMtI@3H@HH;fDfYfX|L;fX~4MtI@3H@0fMtI@3H@ffYfXM;f(fXB  II+H   MJ   M+IIIOMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0Y
XMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(MtIH3MtI@3H@HI0A   M;Y?  ICH   MSAQIIN   D  MtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0YXMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(LATH   HD$`I[IkIsI{ A)sHHHyH (  H   HYH{   qAY0HWHMHEE3McMcMcICIKISMCISIKL$   IH$   H$   IH$   H$   J    H$   HFHPHFHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLG莜HL$p. HL$x. H$   . L$   I[IkIs I{(A(sIA\H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3@^A@MtIJHtH3@^A@MtIJHtH3 ^A MtIJHtH3@H H^A@dM;}:HM+HJMtIJHtH3 HI^A@uH\$HE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA(HB(I HB0I@HB8I@HB@I@HBHI@ HBPLJXLJ`LJhHHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA HB HA(HB(HA0HB0I HB8I@HB@I@HBHLJXLJ`LJhHLATH   HD$`I[IkIsI{ A)sHHH9H "  H   HYH{   A0HWHMHEE3McMcMcICIKISMCISIK;L$   IH$   H$   IH$   H$   J    H$   HFHPHHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLG՗HL$pa) HL$xV) H$   H) L$   I[IkIs I{(A(sIA\HLE3LMSI   IH\$H<$IzAXHfffff     III8H IIHKXBBII8IHXBBII8IHKHXBBII8L;IXBB|H<$H\$M;}-IJII8IHIIM;XBB|H@VLE3LIsH  H\$Hl$AZH|$ Hn{MtI@HtH3IS8MIHtHH33AH@L8YI(\AMtI@HtH3MHSIS8HtHH33AH@L8YI(\AMtI@HtH3MHIS8HtHH33AH@8YI(\AMtI@HtH3MHSIS8HtHH33AH@IH HL;L8YI(\AH|$ Hl$H\$L;}YMtI@HtH3IK8MIHtHH33AH@IL;BLYJ(\A|^ATM;MML  II+H  HH\$Hl$L Ht$ H|$(N   IHI+ھ   HHI+I+HI+KHMD  HtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3H@BAYH(\HtHAHtH3HtHL3E3BH@H HI HLAYH(\BH|$(Ht$ Hl$H\$M;}VI$L HtHAHtH3HtHH33CH@IM;BLYJ(\CD|A\M;L}yHLfMtIBHtH3HHHtHA3H	tHH33H@BYJ(HtH3CYI8IM;\CD|HWH   HD$0HXHhHp HHHIHP8    3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP8H_ H9_v" HHD$`H\$hH$   HH$   H;v" H$   H$   HL$pHL$@Ht$HH;v" HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`H螳H$   Ht2H$   H;t H! H(H;uH$   Hz H$   H$   H$   HL$pX L$   I[Ik Is(I_HWH   HD$0HXHhHp HHHIHP@   & 3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP@H_ H9_v&! HHD$`H\$hH$   HH$   H;v  H$   H$   HL$pHL$@Ht$HH;v  HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`HH$   Ht2H$   H;t Hg H(H;uH$   H H$   H$   H$   HL$p L$   I[Ik Is(I_@SH H~ HHHI(Htk HK3HC(HC0HC8H [O H\$WH H} HًHHI(Ht% HK3HC(HC0HC8 @tH  HH\$0H _H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;v HH|$(LD$ HD$ HT$0L(D$ HfD$ 9H\$PHt$XH@_H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;vF HH|$(LD$ HD$ HT$0L(D$ HfD$ )H\$PHt$XH@_H\$Ht$WHPLAHHIgfffffffMuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ oL_(L[ H\$hHt$pHP_L;vL HH|$8LD$0HD$0HT$@L(D$0HfD$0_H\$hHt$pHP_H\$Hl$Ht$ WH0Hq HH9qv H_H;_ v H9_wH;_ v H/H9wwH;w v HtH;/t H;tIDL$@HW 3D$(D$@LHΈD$ yHw HHH;tHa H(H;uHo H\$HHl$PHt$XH0_HL@VWATAUAVHPHD$0HXHh MLHHq HILL+HgfffffffHIHHH?HI;sZH;v HHL$@Ht$H(D$@fD$@HO H+OHHHHH?HL+MMHT$@H͟   L;   H;vT H_H;_ vD H/E3Hu3 ML] KD HI;[ wHtLe I;\$s H9_wH;_ v H/H9wwH;w v HtH;/t H;tO3D$($   D$ D$   LHW HHHw HH;tH H(H;uHo IL\$PI[8IkHIA^A]A\_^H%h @WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH' H(H|$`HS(H6HSXHO06D$h   Ɔ    HH\$HHt$PH0_@WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH H(H|$`HS(HIHSXHO0;6D$h   Ɔ    HH\$HHt$PH0_LATAUAVH  HD$`I[IkIsI{ IM3HJ H+JHgfffffffHLIIH?LII I+II*IHHHH?HL;  UDEIx HO H+OIHHHHH?HHz H$   HH HHTz HH
z HI HHy mHT$hH$   Z HHL$ < HL HD$ HHL$8 Ha HD$ HT$ H$  H
Zw HHPH
v HHX@`?   H|HMtSHHO H+OIHHHH?HH;ri HGHHL$h74HHHH0I;rI] I+]HH;      DBH$   L Hv H$   OHH HHu 4HH HHu HT$hH$    HHL$  H HD$ HHL$8 H
 HD$ HT$ H$  NH
v HHPH
u HHX@`I   H(L$  I[ Ik(Is0I{8IA^A]A\@SWAWH`HLE3H3LGǄ$       Mu3HW(I+HH_ HI+HH;sHC    HG =L;v HH\$(L$   HD$ LD$ HT$0(D$ fD$ HIO H*I+OHHHHH?HH/  H$   Ht$XLd$PLl$HLt$@E3E3L$       HG H+GHL;r	 IO LgHI+OHHHH?HL;r Io3۾   IL- I+L-HHt)H;r ID-IL- HH+HtH;rH$   HWB DD$   Hu3HO(H+HH_ HH+HH;sHCDHG    H;v9 HO HoH7HHt$ H\$(H+Hu3"H;v HtH;7t H+H(D$ L$   HT$0A   HfD$0ڕHoH;o v H7Hu E3LHL I;K wHtH3H;Hs IO H$   II+OH*I0HHHHH?HIFH;Lt$@Ll$HLd$PHt$XH$   H`A__[HHHz HL$(HT$0u	fWHHHT$PHL$ HH@SH Hi HHHn# HAPHI8 HK  HK L% LH [@SH Hi HHH# HAPHI8` HK V HKL L LH [@SH Hj HHH# HA`HIH HK8 HK  HK L{ LH [@SH H;j HHH" HA`HIH HK8 HK  HK L LH [@SH H;j HHH" HAhHIHP HK8F HK < HK2 L LH [@SH H[j HHHN" HAhHIH HK8 HK  HK L[ LH [@SH Hҟ H      ?   Hǃ       ^CxH   ,;L   Hr HHH [H\$WH HH   HHH   HrH   HH\$0H _YHHHz  HBHD$(ufWY% HHHT$XHL$ Yt% HH@SH HҞE3H     @@ǃ      D   H   H>r D   HD   L   HH [@SHPHD$ HHq HL$( HT$(HHL$(" Hsr HL$(
 HT$(HHL$(
 H7r HL$(
 HT$(HHL$(
 Hq HL$(
 HT$(HHL$(
 Hq HL$(l
 HT$(HnHL$(r
 HP[H\$Hl$Ht$ WH@HH   HHwLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v
 HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H请fn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;vH
 HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H)   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H襶H   HH\$XHl$`Ht$hH@_H\$WH HH   HHH   HH   HH\$0H _yH\$Hl$Ht$ WH@HH   HHGLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hfn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v
 HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HuH   HH\$XHl$`Ht$hH@_H\$VH@Iy IHH\$0LD$(tPHT$`HL$ f/  v7H{ Ht$(H\$0t&HT$`HL$ f/ v
H\$PH@^2H\$PH@^@SHPHD$ HHWl HL$( HT$(HHL$( Hl HL$(` HT$(HbHL$(f Hk HL$(4 HT$(H6HL$(: HP[H\$WH HH   HHQH   HBH   HH\$0H _)H\$WHPHz8 HB)t$@HD$(HB0HHHD$0ufWHT$`HL$ mf(HHHH\$hYQ \(t$@HP_H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H迱fn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;vX HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H9   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H走H   HH\$XHl$`Ht$hH@_@SH H袕z 3H      ?   ^CxH   H   ,;L      H$ H   H      ?H   H   H   H?H   H      ?H   H   H      $@H   H   Hi HHbi H   HH [H\$WHP)t$@)|$0= f/HHD)D$ DADXDAvf(q(f(fA(XA@\^f(Y\YAXfA(q. K8Ys ^C0fW
 \fA( \YY{Xf({ H\$`(t$@(|$0D(D$ HP_@SH A(HA  CH [@SH H#h HH   Hz[ HH HAPHI8R HK H HK> L LH [@SH HBǃ      E3H     @@H   D   D   D   L   D   H:" L   L   H   H      ?L   H   H   H?H   H      ?H   H      $@H   Hg HHjg H   HH [@SH HKg HH   HZ HH HAPHI8 HK  HK L LH [HL$SH0HD$ HHg HHyg H   Hx   Hh   H   H{Z HH HC`HKHs HK8i HK _ HKU L
 LH0[M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OA^AAXAAAMtIBHtHH3HtHA3H@HHtH3AD^AAXAAAMtIBHtHH3HtHA3H@HHtH3^AAXAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;^ACXDCD|A]_H\$M;IML   HL MtIBHtH3HPHtHJ3HtHA3H@L HtHA3H@HBC\HtHB3H@IL;HBYDCXDCDpH\$M;L   LMtIBHtH3HHHtHA3H!tHP3J HtH3YH(HtH3H	tHA3H@HHtH3BIM;YAXCDgHL$SH0HD$ HHc HHc H   H  M Hp  @ H   ; HV HH! HC`HKH HK8	 HK  HK L~	 LH0[@SH A(HA  CH [HL$SH0HD$ HHc HHic H   H  m Hp  ` H   [ HV HH HChHKH3 HK8) HK  HK L LH0[M;
  VAUIIMI+LLH  HH\$Hl$ H|$(Ld$0HI+   IHJ   H+HL+LHMMtIBHtHH3HtHA3H@HHtH3OA^AAAMtIBHtHH3HtHA3H@HHtH3AD^AAAMtIBHtHH3HtHA3H@HHtH3^AAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAALd$0H|$(Hl$ H\$L;}TME MtIBHtHH3HtHA3H@HHtH3BIL;^ACD|A]^HM;ML   H$HfD  MtIBHtH3HPHtHJ3H	tHA3H@LHtHA3H@HBC\HtH3YB(IM;BD|H$HHI(H% H\$Ht$H|$HqHYE3LHH    fWfff     E3H   @ MtICHtH3HtHH3H!M;uf(f(HtH3YI(HtHH3H	tHA3H@HPL IIHtH3AHIHOAYIXIL;SIL;7H\$Ht$H|$E3DL$HtHIHHHAHBHAHBHAHBI HB LJ(LJ0LJ8HHL$SH0HD$ HH_ HH^ H   H  m Hx  ` H(  [ HQ HH	 HChHKH3 HK8) HK  HK L LH0[H\$WH HGO HHH HAPHI8 HO  HO L? LtH# HH\$0H _H\$WH H[ HH   HtN HH
 HAPHI8L HO B HO8 L LtH西 HH\$0H _H\$WH H[ HH   HDN HH HAPHI8 HO  HO LA LtH% HH\$0H _H\$WH HtH HH\$0H _H\$WH HtH軾 HH\$0H _H\$WH HltH苾 HH\$0H _H\$WH H<tH[ HH\$0H _H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;vn IE HtH;tZ I}I+HIE HL$ HT$ HIEMHAHA   赬LcL;c v HLd$(H\$ (D$ fD$ Hu LLI<I;{ wHtH3H;~s H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HWATAUH   HD$ HXHhHp)pL    Ht
HL$PH3HD$P3H\$h3HL$p3HT$xI9U u3I}HQ  Hu3H+HHH+HH;sHHHHL$pH\$h   HH;v HL$pH\$hHl$PHl$0Ht$8HH+Hu3$H;v HtH;l$Pt H+H(D$0fD$@LA   HT$@HL$PsH\$hLHL$pH;vI HL$pH\$hHl$PHu/ E3HL$pH\$hHD$PLII;S wHtHE 3H;Ps HL$pH\$hHI;}uI} I;}tHt
HT$xLL+IIHH;v HL$pH\$hHH;v HL$pH\$hHl$PHu{ E3HL$pH\$hHD$PLJ4I;s wHtHE 3H;psA HL$pH\$hH;v, HH+HH=   ~Eff     LHHL$00^L\$8L;wI
H|$0H;v HH+HH=   E3HHqHD$pHL$hH+HL;r HL$hB4Ht" HD$h    HD$p    HD$x    HL$P f(L$   I[ Ik(Is0A(sIA]A\_H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HH胒H0H;uH\$0Ht$@HHl$8H _@SH03MM؈D$(D$@HLIMIHˈD$ 耆H0[@SH@Hy` HAXHHD$(ufWn YCxH@[HT$PHL$ O YCxH@[@SHPHy )t$@qhHAHHHD$(HAfT5 HD$0t$hufWHT$`HL$ H8  f/wHD$h^ (t$@fWz HP[@SHPHy )t$@qhHAHHHD$(HAfT5 HD$0t$hufWHT$`HL$ AH  f/wHD$h^ (t$@fW HP[@SH HHI% HKH [H% DD$HL$SVWH@HD$0IcHD$x    Ey,H HD$ L
 LD$pHV H
U ̋2   K HtH3Ht$pHLD$pH8HH@_^[HVWATAUAVH   HD$ HXHh)pIHH3IMuH,M;vN$    I HuMtHD$8H|$@HuH,I;vЇL$    I HuMt诇HD$(H|$0H   LuLNLL+A   L+A   L+IL+LGIIJ    fffff     KT
 INHD$8HIAHHHD$(HK
HD$8HLIHHHD$(HLKINHD$8HIAHHHD$(HAKHD$8IA@HD$(I I IdH;s0H+H)HD$8HHHD$(HH;rHD$8HD$PHD$(HD$XH|$0 ufWH$   HL$H+f(HL$(D HL$88 f(L$   I[0Ik8(t$pIA^A]A\_^HL$UVWH@HD$ H\$p)t$0HH3ۉ\$hHj H+jHKq HtH8HHfWD$hLD$hHHgHF H+FHHtRD  H;ru HF4HG H+GHH;rU HG4HHF H+FHH;rHHH\$p(t$0H@_^]@SH HD$0    HH [HHHWATAUAVAWH`  HǄ$   HXHp)p)xD)@MMHD$0    H 0D$0L$  Ic$   . Ht
H$   H3H$   fW|$8LD$8HH$   Hc  E3@ H$   HH$   H+HL;sBI3@ H+HH;s4HH$   H$   A$Hcع   w Ht
HL$@H3HD$@|$8LD$8HHL$@iH  3fff     H\$`HHL$XH+HH;s
H3fff     HH+HH;s4HH\$`HL$XD$0    H+HC  Hu HL$XHH       A;4$  D$0"   HcH\$`Ld$XI+H  C;   LoL;r Ld$XA   Lͤ HIFC4X0HcH\$`HL$XH+H|,C;}%HH;rP HL$X4L$  I   DBH$0  Z H H$@  ]   H HT$pH$0  < LL$xH$   LCL$xH\ HD$ DǋH
7    DBH$0   H H$@  ݬ   HW HT$pH$0   LL$xH$   LCL$xH HD$ DǋH
 A7A   D5 D  E;,$  D$0(   IcH$  H~ H+~HV  G;K  LsL;r L~H|$`HHL$XH+H  F;  LcL;r H|$`HL$XN$AIcH+H  G;  HH;r\ HL$XA$^fA(\C\YH$   H+$   H   G;   HsH;r H$   <D$0)   H$   H+$   H|/G;}(HH;r H$   X4L$     DBH$0   H H$@  Ū   H? HT$pH$0   LL$xH$   LCL$xH HD$ DËH
    DBH$0  B H H$@  E   H HT$pH$0  $ LL$xH$   LCL$xH HD$ DËH
    DBH$0   H H$@  ũ   H? HT$pH$0   LL$xH$   LCL$xH HD$ DƋH
    DBH$0  B H H$@  E   H H$   H$0  ! L$  H$   LC$  H HD$ DËH
 y    DBH$0   Hy
 H$@  輨   H6 H$   H$0   L$   H$   LC$   Hf HD$ DËH
 D$0+   H$   H$  HHL$XHtk 3H|$XH|$`H|$hHL$@P H$   Ht= H$   H$   H$   H$    H      DBH$0   He	 H$@  訧   H" H$   H$0   L$   H$   LC$   H HD$ A   H
v L$`  I[8Is@A(sA({E(CIA_A^A]A\_HL$UVWH0HD$ H\$`HH3|$XHZ H+ZHO6 HtH0HHH|$XLD$XHHqHE H+EHHtKH;rD H]HHF H+FHH;r% HFHHHE H+EHH;rHHH\$`H0_^]LWH   HǄ$   I[IsHISHHHAHBHAHBHAHBHA HB HyH^HF3HL$@IKIKI[ICI{MCISIKL\$hIHD$XHD$pIHD$`HD$xJ    H$   HF HL$@HL$0HD$(HHD$ L$   L$   HH7HL$@ HL$H HL$PL$   I[IsI_H% LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHHY]HH0H\$`H@_^[H(f(f(fT
\ f/
 vGf/
J r+f/H vHF H
د v H( \ H( f/v	f(H(%G G f(Yf(f(YdG Y
G X
lG \f(YG YYXG YXhG YXf(YG \%F \YY\F YY-F XXH ^Xf(H(H@H   )pD)@D)P=q
 fD(Шum
H DH H q
 
p
 
H Dp
 
p
 
aH p
 
p
 
AH 
p
 	Dp
 5 ua
H H p
 
9p
 
G !p
 
)p
 
G 51p
 
p
 
G 
p
 uyG 
uG 4p
 o
 TG 
o
 
<G o
 $G o
 G 
lo
 
F to
 
do
 uqF 
F o
 n
 F 
n
 
F n
 oF 
n
 
WF n
 
n
 5n
    'F 
F >o
 &n
 E 
n
 
E n
 E 
n
 
E n
 E 
m
 
~E m
 
m
     VE 
FE  n
 Um
 %E 
Mm
 

E Em
 D Em
 D 
-m
 
D 5m
 55m
 
m
 ! @ugq! -! 
q! @n
 X! l
 8! l
 pl
 -pl
 
pl
 pl
 f(
Zl
 -Jl
 %:l
 x\    m
 k
   k
 k
   k
 k
 5k
 k
 rjT  D  2m
 Rk
 "  :k
 Bk
   :k
  2k
  *k
 	rb  	l
 j
  j
 j
 b 5j
 j
 B j
 
D)d$PrD%B 
D%@j
 Rl
 	D%/j
 rB 
j
 'l
 riB i
 l
 
D)\$`rD:B 
Di
 k
 	Di
 D)|$ rD=A D=zi
 k
 	D=ii
 D)$   rD
A D
<i
 vk
 	D
+i
 D)t$0rD5A D5i
 Ck
 	D5h
 )$   r=JA =h
 k
 =h
 D)l$@rD-A D-h
 j
 	D-{h
 fWfA/vH
E
 L$   H ]fD.zuH
E
 H
? n fA/  fA(fA(AY8fD(fA(A^ f/Y DYD^
    f(f(Y
j
 Yi
 X
j
 Xi
 YYX
i
 Xi
 YYX
i
 Xi
 YYX
i
 Xli
 YYXTi
 AX^   ^f(f(Y2i
 AYX
]i
 X%i
 YX
Qi
 YXi
 YX
Ai
 YXi
 YX
1i
 YXh
 YX
!i
 YXh
 ^DY fE(EXE\E\EYDYEX  > fA/rXfA(L$   Hg
 H
&h
 E3AY$   蘉DY
G =wf
 fA(A\fD(A\hD fE/   fA(L$   H	g
 H
Bg
 E3AY$   <Y= fA(fD(\=e
 A\f(AXYfA(DYD^f(fA(訜 Y Y^5& DX  E^fA(AYf/   f(fD(DY%If
 Yf
 DX%0f
 Xe
 DYYDX%f
 Xe
 DYYXe
 DXDYYDXXe
 DYDXYXD^   f(^f(fD(DYYX\e
 DXDYYDX%}e
 XEe
 DYDX%oe
 YX3e
 DYDX%]e
 YX!e
 DYDX%Ke
 YXe
 D^f/   fD(f(DY
d
 Yd
 DX
d
 Xmd
 DYYDX
d
 XKd
 DYYDX
ad
 X)d
 DYYDX
?d
 Xd
 DYYDX
d
 Xc
    ^fD(f(DY
c
 Yc
 DX
c
 Xc
 DYYDX
c
 Xc
 DYYDX
c
 Xc
 DYYDX
c
 Xc
 DYYDX
c
 Xqc
 D^fA( f(fA( f(fA( D f(EYD^X\AYAYXDYD(|$ D(t$0D(l$@L$   fA(A(sE(CE(SD(d$PD(\$`D($   ($   ID$H   f
 D)$   D)T$`fD(uy
%= = = |f
 
<f
 
< Df
 < 
,f
 
< 
,f
 
< f
 
$f
 f
 D urg< 
W< e
 e
 6< 
~e
 
< ve
 < 
ne
 
; fe
 
fe
 Dee
    ; 
; e
 d
 ; 
d
 
t; d
 \; d
 D; 
d
 
,; d
 ; 
d
 
: d
 
d
    : 
: d
 c
 : 
c
 
: c
 s: 
c
 
[: c
 C: 
c
 
+: c
 
c
 Dc
 	 fWҨui	 
	 Ad
 b
 	 
b
 
i	 b
 Q	 b
 b
 
b
 b
  uj	 

	  c
 Tb
  
Lb
 
 Db
  Db
 b
 
,b
 D3b
 @uq 
w @fc
 a
 V 
a
 
> a
 & 
a
 
 a
 
a
 a
 xs 
 b
 `
  
`
 
 `
  
`
 
h `
 
`
 D`
 D)\$PrD"8 D}`
 ob
 	Dl`
 	D)d$@rD%7 	D%B`
 <b
 	D%1`
 
)$   r57 
5`
 	b
 5_
 D)t$ rD5r7 D5_
 a
 	D5_
 )$   r=67 =_
 a
 =_
 
D)l$0rD-6 
D-X_
 ra
 	D-G_
 fA/rL$   H1 H
j ͐ D)L$pfA/r|fA(L$   H`
 H
`
 E3AY$   Y5v fA(fD(fA(\AXA\YfA(A^DYSE^f(   D" fE/   fA(L$   H_
 H
_
 E3AY$   膁Y= fA(fD(fA(\AXA\YfA(A^DYRE^f(fA(贒 Y Y^52 DX   E^fA(AY$   fA(耒 f(fA(T L$   H]
 H
^
 E3f(v~L$   H^
 f(\fD(H
C^
 E3EYDYA~XYD\fA(
 Yj D^EYD(t$ D(l$0D(d$@fA(D(L$pD(\$P($   ($   D($   D(T$`Hĸ   H@H   )p)xD)HfD(D)P`
 uk
h6 X6 H6 _
 /6 %6 -6 
_
 _
 _
 _
 %_
 -_
 0-_
 %_
 u_
 e_
 U_
 
E_
 = D)\$`D)d$PD)l$@u<D~5 D%m5 <_
 D^
 D%^
 =^
 fD(D-^
 D%^
 D^
 D5 D)$   D)t$0D)|$ u_D4 D=4 54 ^
 DZ^
 D4 D0^
 DG^
 D=&^
 5&^
 fE(D=^
 D5]
 u>5Y4 DH4 O^
 5]
 D]
 D]
 =]
 	D]
    D3 53  ^
 D]
 D3 5]
 D
]
 D3 D]
 D3 D\
 Dp3 D\
 DV3 D\
 D<3 D\
 D"3 D\
 D3 D\
     D2  =S\
 =]
 D[
 D2 D[
 D2 D[
 D2 D[
 Dm2 D[
 DS2 D[
 D92 D[
 D2 D[
 D2 D[
 D1 D[
 fWfA/vH
 4
 L$   H 謊fD.zuH
3
 H\- /]fA/   fA(AYf(YfD(DYDXDYDXf(YXDYYDXf(AYAXDXYAXD^fA(! f(f(f(Y
o[
 Y?[
 X
O[
 X'[
 YY5C[
 YX[
 AXAXYYAXX^YD\8  A^fA(fW` f(Y腌 fD(fA(蔌 f(f(D^f(f(YZ
 YZ
 Y
Z
 XWZ
 XY
 X
Y
 YGZ
 YYXZ
 XY
 XZ
 YYYXY
 X
Y
 XY
 YYYYXY
 XY
 X
SY
 YYYX7Y
 XY
 X
Y
 YYYXY
 XXWY
 X^DYD(|$ D(t$0D(l$@L$   fA(A(sA({E(KE(SD(d$PD(\$`D($   IH@H   )xD)@D)HD
*1 fD(D)XD)`D)l$@Z
 D)t$0D)|$ uqD%0 D-0 D50 Z
 D=0 0 D%qZ
 D-pZ
 D5oZ
 D=nZ
 nZ
 D
=Z
 fE(-D=MZ
 D5<Z
 D-+Z
 D%Z
 D	Z
 =9 u<
0 D
Y
 Z
 
Y
 
/ =Y
 
Y
 	D
Y
 fWua/ 
/ Y
 OY
 / /Y
 ?Y
 o/ 
Y
 /Y
 O/ 'Y
 uA3/ 
#/ bY
 X
 / 
X
 X
 =X
    . 
. Y
 !X
 . 
	X
 X
 . 	X
 i. X
 Q. W
 9. W
 !. W
 	. W
 - W
 - W
     - 
-  XX
 W
 - 
V
  W
 h- =(W
 V
 H- V
 0- V
 - V
  - V
 , V
 fA/vH
-
 L$   H 薄fD.zuH
-
 HF' WfA/)$   D)T$p  fA(fA(AYf(YQ f(Y
V
 f(fD(f(YV
 X
V
 Y"W
 XV
 AXYYYX
V
 AXYYXf(YdV
 X
dV
 XLV
 YX8V
 YX$V
 ^f(AYDYAXYXf(YaV
 AXXLV
 YX8V
 YAX^DXE^8  A^fA(fW
 f(Y/ fD(fA(> f(f(D^f(f(YqU
 YU
 YYU
 XIU
 XT
 X1U
 Y
T
 YYXU
 XT
 X
T
 YYYXT
 XT
 XuT
 YYYYXT
 X
]T
 XT
 YYYX)T
 XiT
 X
!T
 YYXYT
 XYXS
 X^DY($   D(l$@D(t$0L$   fA(A({E(CE(KE([E(cD(T$pD(|$ ILATH   HǄ$   I[IkIsI{ A)sHHHH{   H{    HqH~    A0HSHMHEE3Ld$0Ld$8Ld$@ICIKISMCISIKeL\$XIHD$HHD$`IHD$PHD$hJ    HD$pHGHHHH$   H$   H$   $   HT$0H$   Ld$(HL$ E3L@3H$   UHL$0 HL$8 HL$@ L$   I[IkIs I{(A(sIA\M;6  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3I@IBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@HBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@BYBPAXAHtHAHtH3HtL@E3HtHP3I@I I HHBDYBPAXAAALd$0H|$(Ht$ Hl$L;}]IE LHtHAHtH3HtL@E3HtHP3I@IL;BDYBPCXDCD|A][M;  WAVHIIMI+LLH  HH\$ Hl$(Ht$0Ld$8L,$HHA   I+IJ   HH+L+HL+LHMMtIBHtH3HtL@E3HtHP3I@KL
 ^BpAAMtIBHtH3HtL@E3HtHP3I@I)^BpAAMtIBHtH3HtHP3HtHH3HB^ApAMtIBHtH3HtL@E3HtHP3I@KH I H^BpAAL,$Ld$8Ht$0Hl$(H\$ L;}QMMtIBHtH3HtHP3HtHH3HBIL;BD^ApCD|HA^_E3LLIPMuIHHJuIHaHAuIH@fBHtHIIpHJffYHuIH	HAuIH@fB$HtLIAIPIHffYfXfBXfB)HtHA3LPIHH+HLIHLIIM  HtHA3IH@ffY   HtHA3H@   I;fHfY}FHtHA3H@ffYfXHtHA3H@HI;fDfYfX|M;fX~HtHA3H@fBfYfXM;f(fX   II+H   MJ   M+IIIOHtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(HtHA3H@A   M;Y   IBH   MJAPIIN   D  HtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(M;I  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3AAI@IBYJp\AAHtHAHtH3HtL@E3HtHP3AAI@HBYJp\AAHtHAHtH3HtL@E3HtHP3AI@BYJp\AHtHAHtH3HtL@E3HtHP3AAI@I HI HBLYJp\AALd$0H|$(Ht$ Hl$L;}`IE LHtHAHtH3HtL@E3HtHP3CI@IL;BLYJp\CD|A][HL$WH0HD$ H\$HHHD$P       Py HtH3HHD$P    LD$P   HFWHC H+CHHu^ HCH8HH\$HH0_HL$WH0HD$ H\$HHt$PIHHD$X       x HtH3HHD$X    LD$X   HVHC H+CHHuƯ HCH0HC H+CHHw HCHxHH\$HHt$PH0_H\$Ht$ WH@HA`HA Hy`H+AHHHH;s<fHCPH+CHHH;r9 HCHH94sHC`HC H{`H+CHH;rHC H+CHH9C`   HK0'HHH;HBHL$`HT$PHHD$PnHH8 u6H		 HL$ A    L HB	 HL$ L\$ /w HT$`HK0HC H{`H+CHH;ra HCH<H7Hs`HCpHKPH+KHHH;r6 HKHHHHt$hHHKhH\$XH@_HT$HL$UVWH`HD$ H$   HHHH$      ~v 3HtHHHL$      HwTH{0H$      @v HtH8HHL$      H;THk`HC H+CHHuO HSHHHKhHC H+HHu* HCHHKpH{x   u HtH8HHHoHo Ho(H      u HtH8HHHoHo Ho(H      gu HtH8HHHoHo Ho(HC H+CHHu HCH8 u6A   H	 HL$( L L\$(HG@	 HL$(t HH$   H`_^]@SVWH03H_ IHHqH=4F
 HHL$PHuHH+F
 H+HH
F
 HH+HH;sHAHHE
 HH0_^[Hl$XLd$`HH;v H
E
 H=E
 HE
 HHl$(H+LHT$ HuH)H;v
e HnE
 MtL;tN H+H(D$ LL$PHT$ H
AE
 A   fD$ `3L%AE
 L;%BE
 v
 H=E
 Hu LLILd$`Hl$XI;C wHtH7H;FsȪ HH0_^[@SH@HD$ )t$0f(HH>C
 HHH0C
 H;!C
 r   H
B
 HHL$PHtf( 3HH(t$0H@[LAHHI      A@D$HD$H#I;wAHB @D$HD$H#I;w%BAX@A@HB @XB@Hܦ HIHHΦ HR HHJHQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBHY HHJ@WH0HD$ H\$HHl$PHt$XIHHHA
 HH(HA
 H;A
 r(   H
A
 JHHt$@Ht,H?HOXKHuH^H~ H H3Hu HH\$HHl$PHt$XH0_@WH@HD$ H\$PHt$X)t$0f(HHf.X z
uHHHmH@
 HH(H@
 H;@
 r(   H
G@
 HH|$`Ht)Hf(XKHH_w HY H3H>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0If(Hf.
 z
uI HHmH
@
 HH(H?
 H;?
 r(   H
w?
 HH|$XHt)Hf(XKHH_w H H3H>HH\$PHt$`(t$0H@_H	 HHLAHHI      A@D$HD$H#I;wdHB @D$HD$H#I;wHHB B^@AX@A@HJ HBHAYJY^A\AHI HIHH; HR HHJHA IYI@Y^@\@@WH0HD$ H\$HHl$PHt$XIHHHR>
 HH(HD>
 H;5>
 r(   H
=
 HHt$@Ht,H?HK^OH%H^H~ Hv H3Hu HH\$HHl$PHt$XH0_@WH@HD$ H\$XHt$`)t$0If(HH=
 HH(H=
 H;=
 r(   H
=
 IHH|$PHt)Hf(^KHxwH_ H H3H>HH\$XHt$`(t$0H@_AHI      D$HD$H#I;w0HA @D$HD$H#I;wHA @\A@H5 HQ HHJ@WH@HD$ H\$XHt$`)t$0If(HH<
 HH(Hs<
 H;d<
 r(   H
;
 )HH|$PHt)Hf(\KHXwH_ H8 H3H>HH\$XHt$`(t$0H@_LAHHI      A@D$HD$H#I;wSHB @D$HD$H#I;w7HB @YBAX@A@HBHJ @YBXAAH HIHHܟ HR HHJHQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBHi HHJ@WH0HD$ H\$HHl$PHt$XIHHH:
 HH(H:
 H;:
 r(   H
:
 ZHHt$@Ht,H?HOYKHH^H~ H H3Hu HH\$HHl$PHt$XH0_@WH@HD$ H\$PHt$X)t$0f(HHf.` z
uHHHmH9
 HH(H9
 H;9
 r(   H
W9
 HH|$`Ht)Hf(YKHH_w H H3H>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0If(Hf.
 z
uI HHmH9
 HH(H9
 H;8
 r(   H
8
 HH|$XHt)Hf(YKHH_w H) H3H>HH\$PHt$`(t$0H@_HQIBD$HD$I#I      I;vHќ HHJB\AB@WH0HD$ H\$HHt$PHHH8
 HH H8
 H;7
 r    H
7
 HH|$@Ht(HKfW
 HH_H H3H>HH\$HHt$PH0_E3HL9Av0@ HB IJLHB(BDYBXAAL;BrAHAYAX@@@WH0HD$ H\$HHt$PHHH7
 HH H7
 H;6
 r    H
6
 HH|$@Ht)HCf f(HH_HA H3H>HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHHE[f(HHa HHG H+GHH    HC6
 HHH66
 H;'6
 rH
5
 HHNHG H+GHHF 3Ht8 HG H+GHH;r9 HGHNHHHH;^ rHHH\$HHt$PH0_E3L9A v(    HAIJTBXABL;A r@WH0HD$ H\$@HHHB H+BHufWHNH15
 HH(H#5
 H;5
 r(   H
4
 HHL$HHt
HT3HHH\$@H0_HATAUAVH   HD$ HXHhHpHx ILH3H9Y~%HƐHI5HH}HcH;G|DH9w~gL H HL$P HIILHHL$(O HHs}HL$(w HL$Pk AMcL;w|H ~hLD  Ha HL$( HIILHHL$Pߙ HH}HL$P HL$( LcL;o|L$   I[ Ik(Is0I{8IA^A]A\H\$Hl$Ht$WH 3HHH9y~'Hf     HCHH{HcH;K|H9{~XHff     HCHH{HcH;K|H9{~*Hffff     HC0HH`{HcH;K|H\$0Hl$8Ht$@H _HLH L@HHSVWATAUAVAWH  HǄ$H  )pILLIH臶HH$   v-N $  H$   (?H$   {   b HtH$   H33HH$   H$8  H$@  H$H     a Ht
H$   HHH$   H$  H$   H$(  H
 H$P  × IH$P  IPH$P   tZHK
 HL$@ H$   ɘ H H$   HT$@H$8  ~ H.	 H$   ` H
 H$P  + IL$P  HT$@IPHH$   9HL$XHt` H|$XH|$`H|$hHL$@v` H$P   HD HL$@ H} H$x   HC H$P   HL$p
HD$ LL$@L$x  H$P  IH$   Ht_ H$   H$   H$   HL$p_ H$P  ; H$x  , HL$@  L$@  H$8  L+IMu H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;vh H$   H$   H$   LHL$0Ht$8HH+HuH*H;v% H$   MtL;t
 H+H(D$0fD$0L$   A   HT$0H$   L$   L;$   vÕ H$   Hu LLII;K wHtHHH;Hs H
 HL$@b IHT$@IPHL$@c tZH	 HL$@- H$`  n H& H$`  HT$@H$x  # H+	 H$`  ] H	 HL$@ӓ ILD$@HT$pIPHH$   ^6H$   Ht7] H$   H$   H$   HL$p] HL$@ H H$P  X H H$x  B H HL$@/ HL$p4
HD$ L$P  L$x  HT$@I!H$   Ht\ H$   H$   H$   HL$ph\ HL$@ H$x  ђ H$P   L$@  H$8  L+IMu H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v
 H$   H$   H$   LHL$0Ht$8HH+HuH*H;vǒ H$   MtL;t H+H(D$0fD$0L$   A   HT$0H$   -L$   L;$   ve H$   HuR LLII;K wHtHHH;Hs' H HL$@ IHT$@IPHL$@ tZHJ HL$@ϐ H$   HȘ H$  HT$@H$  Ő H%(	 H$  <Z H HL$@u ILD$@HT$pIPHH$    3H$   HtY H$   H$   H$   HL$pY HL$@/ LH H$P   Hw H$x   H HL$@Ώ Ic   HL$pHD$ L$P  L$x  HT$@I蹟H$   Ht"Y H$   H$   H$   HL$p Y HL$@x H$x  i H$P  Z fW$   Ic      X Ht
H$  HHH$  L$   HH$  6DHA    {   fMIH$  H$  H+HH;r H$  H$@  H$8  H+HL;r H$8  JHAHL$0  E;   |D@ E;     IcH$  H$  H+HH;r. H$  L$H$   HuHH$   H+HL$   IH+HH;s0   IfHtI$HHHI@H$     II;v L$   H$   H$   LHL$0Ht$8IH+HuH*I;vi H$   MtL;tQ H+H(D$0f$   MA   H$   H$   
L$   L;$   v H$   Hu LLII;K wHtHHH;Hsȍ L$0  L$0  ANH HL$@ IHT$@IPHL$@ tZH HL$@W H$`   HP H$`  HT$@H$x  M H#	 H$`  U Hh HL$@ ILD$@HT$pIPHH$   .H$   HtaU H$   H$   H$   HL$p?U HL$@ H H$P   H  H$x  l H HL$@Y HL$p^HD$ L$P  L$x  HT$@IKH$   HtT H$   H$   H$   HL$pT HL$@
 H$x   H$P   L$@  H$8  L+IMu H$8   f(u>$   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v+ H$   H$   H$   LHL$0Ht$8HH+HuH*H;v H$   MtL;tЊ H+H(D$0fD$0L$   A   HT$0H$   N
L$   L;$   v H$   Hus LLII;K wHtHHH;HsH Hh HL$@% IHT$@IPHL$@& tZH HL$@ H$`  1 H H$`  HT$@H$x   HF 	 H$`  ]R H HL$@ ILD$@HT$pIPHH$   !+H$   HtQ H$   H$   H$   HL$pQ HL$@P LH H$P   HH H$x   H HL$@ IcUDHL$p HD$ L$P  L$x  HT$@IݗH$   HtFQ H$   H$   H$   HL$p$Q HL$@ H$x   H$P  ~ $   Ic]D   Q Ht
H$  HHH$  L$   HH$  .DHA}D v   MIH$  H$  H+HH;r H$  H$@  H$8  H+HL;r H$8  JHAHL$0  E;eD|D    E;uD  IcH$  H$  H+HH;ra H$  L$H$   HuHH$   H+HL$   IH+HH;s3   ID  HtI$HHHI@H$     II;v܆ L$   H$   H$   LHL$0Ht$8IH+HuH*I;v H$   MtL;t H+H(D$0f$   MA   H$   H$   L$   L;$   v6 H$   Hu# LLII;K wHtHHH;Hs L$0  L$0  ANH$   H$H  i'H$   H$@  (H$  Ht-N H$  H$  H$  H$  N H$  HtM H$  H$  H$  H$  M H$  HtM H$  H$   H$(  H$   M H$8  HtM H$8  H$@  H$H  H$   `M H$   HtMM H$   H$   H$  H$   (M H$   HtM H$   H$   H$   H$   L ($  H  A_A^A]A\_^[HATH   HD$0HXHhHpHx IIHH   L E3Ht
HL$8HIHD$8Ld$PLd$XLd$`   L Ht
HL$hHIHD$hL$   L$   L$   H\$ LL$8LD$hHHHl$XH+l$PHH;otHt Ht
HNHL'HoAIH~?     HD$XH+D$PHH;r' HHD$PHHHHcH;G|H$   HtK L$   L$   L$   HL$haK HL$PHtQK Ld$PLd$XLd$`HL$88K L$   I[IkIs I{(IA\HWATAUHP  HD$HHXHhHpEEHHپ   DƍVHL$Pp HL$ L HHL$P HL$ ! H HL$`PGHT$ HL$P@ HHcHL$  HL$  HHL$P^ HL$  H? HL$`FHT$ HL$P HHcHL$  9   |~HL$  HHL$P~ HL$ Y H HL$`FHȲ.DHȋ~ HT$ HL$Pc HHcHL$  ;   ~HL$  HHL$Pw~ HL$  H HL$`
FHT$ HL$P~ HHbHL$  9sD|{HL$ ~ HHL$P~ HL$ u H HL$`EHȲ.CHȋ~ HT$ HL$P~ HH#bHL$ ' ;kD~EuEuHL$PS~ .  9s@|{HL$ ~ HHL$Pu} HL$ ~ H HL$`EHȲ..CHȋ{} HT$ HL$P} HHaHL$ ~ ;k@~9s@|{HL$ } HHL$P| HL$ W~ HH HL$`DHȲ.BHȋ| HT$ HL$Pa} HHaHL$ 	~ ;k@~9sD|{HL$  } HHL$Pq| HL$ } H HL$`DHȲ.*BHȋw| HT$ HL$P| HH`HL$ } ;kD~{D   fD  HL$ u| HHL$P{ HL$ J} H+ HL$`yCHȲ.AHȋ{ HT$ HL$PT| HH_HL$ | ;sD~Eu
HL$P-| HL$P | L$P  I[ Ik(Is0IA]A\_@VWH8HHH;  LZ H\$XHZLd$0MIgfffffffL+IILIIH?LuJ`H\$XLd$0HH8_^LQHl$`Hi HII+HLIIH?LM;   DL$P3MD$(D$PIHˈD$ RHo HH;t@ H{ H(H;uHN IH+NHHHH?HHGHHHHO Hl$`H\$XLd$0H8_^Mu3HO(II+HHHH?HL;wZKDL$PHH3MD$(D$PHӈD$ 5RLG HV 3LOD$(D$PHˈD$ HG HgMtLIHHOfD HN IH+NHHHHH?HVtLOLF HVHnHG HHH8_^HT$VWATH0HD$(H\$PHl$`AAHHE3Dd$ AL$C HtHIHLcLc Lc(D$    H  DDHHH\$PHl$`H0A\_^HWATAUH   HD$0HXHhHpMLHIp    tYH HHy HL$8z Hـ HD$8HT$xHL$Py H HD$8Hh	 HL$8B I;LA    tH~$HF    tIIL$HyH;   H^    uH_HE0H9puHxH93uH;H{HU0H92u8    tH'HH    uf     HH     tH
HU0H9r       tH"HHG    ufHH@    tHJ   IKHHH;NuH$HY    uH_H;HFHAHFHHHE0H9puHHHFH90uHHHHFHAH   L   L;tAA 
     HE0H;x  ff          HH;udHK    uƁ   ƃ    HHuHK    tH   H      HA   u}Ɓ    HZ    uƁ   ƃ    HHH    tH'HA      H   uzƁ    HH[HE0H;x   HA   u Hƀ   Ɓ    HH=HK      ƃ   HAƀ   HHoUH   u HAƀ   Ɓ    HHDH      ƃ   Hƀ   HHƇ   H   Ht? 3H   H   H   HNpl? HNXHt^? H~XH~`H~hHN@I? HNu H7? HE8HtHHE8HL$ I$HID$HAHD$(HD$(HE HD$ HL$ HIE HAIEIL$   I[ Ik(Is0IA]A\_I;tXWH H\$0Ht$8I3HZ HHt> HKH3HsHs{> H0HCH;uHt$8H\$0H _H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ vu HHL$0H^HHE HHEHAH\$8H9_wH;_ vKu HHtH;t8u LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$h0Ho LH;t2HXHHtx= HKL+LkLkd= H0HCH;uLg Ld$hH\$pHl$xHH@A]_^Hl$Ht$WH     HHH   H\$0fD  HVHH   H6Ht< HOp3H   H   H   < HOXHt< HO@3HGXHG`HGh< HOs H<     HyH\$0Hl$8Ht$@H _ATHPHD$8H\$`Ht$hH|$pIIL⹨   O< HHD$0HD$@Ht+$   L$(H$   HL$ LLIHYHH\$`Ht$hH|$pHPA\ATHPHD$8H\$`Ht$hH|$pIIL⹨   ; HHD$0HD$@Ht+$   L$(H$   HL$ LLIHYHH\$`Ht$hH|$pHPA\@SH03MM؈D$(D$@HLIMIHˈD$ P1H0[H\$Ht$WHPHHIHHuE3LC(L+IH{ HH+HI;s;3LLKD$(D$`   HψD$ 謴L_L[ H\$hHt$pHP_H;vq HH|$8LD$0HD$0HT$@L(D$0HfD$0{H\$hHt$pHP_H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,CH;}8D$8f    HHH;Hf(DfYf)D|HL$ LLHH\$pHH@_^]@SH HLE3LHHIHH+HLMM~+@ HIM;HIfB(DfBXDfB)D|HI>HH [HT$VWATH0HD$ H\$PHl$hH3t$`M`Il$HuH9HH;v	H    Ho HHuHt	HHoI\$HHtH;t	HtH;t|	̄tr	H;tno Ht
H:HH7H_HHH+HLMM~!    I$f(Hf)HI;|LHIHH\$PHl$hH0A\_^H   HL$ LD$PHB@HD$(HHz HT$0HHT$HI HAI@HAI@HAI@ufWYG HĈ   H$   HL$@QY% HĈ   HT$UVWHPHD$ H$   H3ۉ\$pHAHpHt$0fWD$@HuH6HH;vH,    Hn HuHtHHwHt.HH;t̄t̄tHwHHH+HLMM~ (j      Hf)HI;|LHHL$(	HH$   HP_^]HT$VWATH0HD$ H\$PHl$hH3t$`M`0Il$HuH9HH;vH    Hl HHuHtHHoI\$HHtH;tHtH;t̄tH;t~l Ht
H7HH7H_HHH+HLMM~!    I$f(Hf)HI;|LHI(HH\$PHl$hH0A\_^Dʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ   +i+ȋH [At+;s
H|$0H [ÍU  H|$0H [LDA   H   Ip     AtlEtgAuE\3҃A=r#E   AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ   AA+iD+'EIMIIH+HHHHiɫL+IADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ  +i+ȋH [At+;s
H|$0H [Í  H|$0H [LDA   H   I   AtlEtgAuE\3҃A=r#E  AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ  AA+iD+'EIMIIH+HHHHiL+IAH\$Hl$VWATH0LHyHHHL$PH|$hAtH$IHD$hHL$ IAI;LD$ HMHHLE3H+HHH+HT$PHL$CI;}2HE HHI;fDf(Lf)DHE fLfL|HT$PLMHYH\$XHl$`H0A\_^HWH   HD$ HXHhHpIIH   ]/ 3Ht
HL$PHHHD$PHl$hHl$pHl$xHv HL$(ce HT$(HL$PcHHL$(ge H8 HL$(5e HT$(HL$P5HHL$(9e LHT$PHASAEHT$PHHHHT$PPH\$hHt,H|$pH;t Hd H(H;uH\$hHM. Hl$hHl$pHl$xHL$P4. L$   I[IkIs I_HHPVWATH   HǄ$   HXHhIIHH   - E3Ht
HL$ HIHD$ Ld$8Ld$@Ld$HH H$   c H$   HL$ FH$   c H H$   c H$   HL$ FH$   c LHT$ HAS   D- Ht
HL$PHIHD$PLd$hLd$pLd$xE3E3HT$PHLLD$ HT$PHAS(HMHHT$ PH\$hHt,H|$pH;t H'c H(H;uH\$hH, Ld$hLd$pLd$xHL$Pt, H\$8Ht,H|$@H;t Hb H(H;uH\$8H=, Ld$8Ld$@Ld$HHL$ $, Hp HHNc L$   I[ Ik0IA\_^HLH L@HPHHSVWATAUAVAWH   HǄ$   )p)xMD$@    H=` 0D$@L$x  Ic]    + Ht
HL$HH3HD$HfW$x  L$x  HHL$H	H_  E3ffff     HL$hHHT$`H+HL;sBI3ff     H+HH;s4HHL$hHT$`H$  Hc   * Ht
HL$xH3HD$x$x  L$x  HHL$xH'_  E3     H$   HH$   H+HL;sBI3@ H+HH;s4HH$   H$   ھ   L$p  =Ew D  A;u   D$@T   HcA   L HISHA   L HI80Y7fWH|$hHL$`H+H|&G;}HH;ra HL$`4p   DBH$   _ Hч H$   &   H^ H$   H$   ^ L$   H$   LC$   H" HD$ DËH
 H}A   L$h  f     H$  D;/  D$@W   IcH$`  H^ H+^H  C;  LwL;r_ L~A   L
 HI1HHL$hH+L$`HLH L+HIHL$0H HD$(H, HD$ Lp HH
V qHs H+sHHD$hLd$`I+HHui_ Ld$`HC H+CHHuM_ LIHKf(A   L	 HL$h  IjH$X  Huf(H$H  X0CY4H$P  X8XH$   H$   H+H|*C;}#HH;r^ H$   4AN   DBH$   \ H H$   #   H<\ H$   H$   \ L$   H$   LC$   H HD$ DǋH
 z   DBH$   6\ H H$   9#   H[ H$   H$   \ L$   H$   LC$   HS HD$ DǋH
 mzD$@Z   HT$xL$@  I_rH$   Ht% 3H$   H$   H$   HL$x% HL$`Ht% H\$`H\$hH\$pHL$H% I($  ($  H   A_A^A]A\_^[HLH L@HPHHSVWATAUAVAWH0  HǄ$   )p)xD)@D)HIMLE3Dd$@HY 0D$@H$  HcAL$% Ht
HL$HHIHD$HfW$  L$  HHL$HHKY  Mffff     HL$hHHT$`H+HL;sBIIf     H+HH;s4HHL$hHT$`L$  Ic   [$ Ht
HL$xHIHD$x$  L$  HHL$xFHX  M    H$   HH$   H+HL;sBII H+HH;s4HH$   H$   D$@<   H$  HD$0H|$(H$  HD$ LMIH$   oHHL$H_#H$   Ht8# L$   L$   L$   H$   # A   L%F H5 L$  D"p D
if E;/=  D$@>   IcA   L4 HI}HHL$hH+L$`HLH L+HIHL$0Ld$(Ht$ Lʤ HH
 ˌHw H+wHHD$hLd$`I+HHuY Ld$`HG H+GHHuY LIHO8f(A   Lw HH$  wHA   L[ HI謸H$  H,pf(A   L3 HH$  +H$  X9 \H$x  X0YfAW  AX7^H$   H$   H+H|8G;}1HH;rX H$   4AH5( L%m C   DBH$   V H} H$      H:V H$   H$   V L$   H$   LC$   H* HD$ DËH
 tD$@A   HT$xL$p  IlH$   Hto  3H$   H$   H$   HL$xK  HL$`Ht;  H\$`H\$hH\$pHL$H"  IL$0  A(sA({E(CE(KIA_A^A]A\_^[LL$ LD$VWATHpHD$(H$   ILHH\$     HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@HH;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt Ht$XHt$`Ht$hHL$@ HH$   HpA\_^@WHH$H\$ HH;   MH LR f     H0I0I0I0L;tcMHI LII;tHIHIMZIYI;tHIHIM;tI	III
MZIYI;tHIHIH;uIIH\$ H_H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,C&H;}8D$8f    HHH;Hf(Df^f)D|HL$ LLH&H\$pHH@_^]H\$Hl$Ht$WATAUH I@ HMI+@IHHHH    H	 HHH	 H;	 rH
1	 lHHHOH	 HLHHz	 H;k	 rH
	 5LLGLG HGHN E3H+NIHHHO(HF HoH+FHHt-H;rlS HFHHLHLHF H+FHH;rHV HOI$H+VHHHOHHH;tfL)HH;uH\$@Hl$HHt$PHH A]A\_H\$WH@HHHL$ HHBE3HAHBHAHBHAHHHzHHH+HLMM~AL\$0LL$( IIIM;fB(DHfBYDHHfBXDfB)D|HL$ LHQHH\$PH@_H\$Ht$WH IHHMuhHQ(H	 HHHH	 H;	 rH
'	 bH3HH9W(v,@ HHHHDH;W(rH\$0Ht$8H _L
H\$0Ht$8H _H\$Ht$WH IHHMuhH	 HQ(HLHH	 H;	 rH
	 ¡L3LH9K(v,I+JHIIAH;K(rH\$0Ht$8H _L
H\$0Ht$8H _@SH HD$0    oHH [HUVWATAUAVAWH   HD$8HX)p)xD)@MLLHA H+AH  Ix   fWLH H
D	 ofAn.$  H      H$  H#H;u*H$r HD$ L
q MHN H
	 $E3MIL$HtPI$D  Icf/v
IL;r/Hq HD$(Hq HD$ MH H
	 zH=	 H$  L$(  ME M+EILD$0H$  H$(  HHDHD$0L;HBHLMH
 HLMH
 HQ6IE I+EHHuO I}I$Mm L+I   L;LFIt$L;LFH Ht
HL$@HIHD$@$  L$  HHL$@It$   R Ht
HL$pHIHD$p$  L$  HHL$p=IM9|$   DeZ D  Hc<HD$`HL$XH+HH;r,N HL$XfA(^<H$   H$   H+HH;rM H$   f( D HI;t$rIM   D  Hc<fEnEHD$`H+D$XHH;rM A\HD$XY<YX5	 H$   H+$   HH;r[M H$   \4	 YXHD$`H+D$XHH;r%M HI;YH$   Ht L$   L$   L$   HL$pq HL$XHta L|$XL|$`L|$hHL$@H f(fWL$   I[HA(sA({E(CIA_A^A]A\_^]HATH   HD$ HXHhHpHx IHH    E3Ht
HL$PHIHD$PLd$hLd$pLd$xLOHD$0Ld$8(D$0fD$0LD$0HT$@HL$PHT$hHuIHL$xH+HH\$pHH+HH;sHG HHCHD$p=H;vK HD$PHD$0H\$8(D$0fD$0LO LD$0HT$@HL$PHHT$PHPLHT$PHAS0HMHHT$PPHL$hHt Ld$hLd$pLd$xHL$P L$   I[IkIs I{(IA\HWH  HD$PHXHp HH3LQM  L	E3HH      D  C$  H$  H#H;t,$  H$  H#H;wIHcI;|E      Ht
HL$ H3HD$ HD$8    HD$@    HD$H    AEHT$ H   DBH$   7H H?HcHL$@LD$8I+HgfffffffHHHH?HH;rI LD$8HIH$   *H HH HH HH/ H$   H$   G HHL$XI HO HD$XHHL$pWH HO HD$XH HL$X L$  I[Is(I_HL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;vH    HH HHuHtHHwI\$HHtH;tgHtH;tR̄tHH;tDH Ht
HHH/H_HHH+HLMM~I$f(Hf)HI;|LHIHH\$XHl$`H0A\_^HHXWH   )p)xD)@AD)HD)PD)XfD(EYDYn] D)`fD(fA(\ D
qS fE(L$   H$      f(fA(fA(EYY=_ gf(fD(fT
&M f/
] vHͣ H
 fA(AY f(fA(Y-_ YXf;vT%\  ff(AYA\DXfnf(fA(fD(YA^^XYf;r(|$pL$   f(A(sE(CE(KI[E(SE([E(cI_Ht$WLE3IsI{HP  H\$E3H   H_HtHBHtL@E3IK IA@IIYHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIIL;YDDL;}=HtHBHtL@E3IK IA@IIIL;Y|IL;H\$Ht$_H\$M;IML   HL MtIBHtH3HHHtHA3H	tL@E3HtHP3I@BYJ0HtH3CYI@IL;\CD|H\$HWATAUHPHD$ HXHhHp )p)xf(f(LLH HHyH|$pHr3HuH9HH;vH    HC HHuHtnHHwI\$HHtH;tCHtH;t.̄t$H;t C Ht
H{HH/H_HHH+HLMM~#f     I$f(Hf)HI;|LHIȲA}Au IL\$PI[(Ik0Is8(t$@(|$0IA]A\_@VWATAUAVH0HD$ H\$hHl$pLLH3 HHyH|$`Hr3HuH9HH;v#H    H!B HHuHtHHwI^HHtH;tHtH;t̄tH;tA Ht
H

HH/H_HHH+HLMM~%fff     IFf(Hf)HI;|LHINWIFIEIF IE IH\$hHl$pH0A^A]A\_^HHHUVWATAUH`HD$ HX)pHHHPfWp3HuH6HH;vH,    H@ HuHtHH~IHt$I;ts̄tīt_H~HHH+HLMHM~"(= ff     Hf)HI;|LHHL$(H|$0H|$8t$@HnH$   LLLLIHkHt,IHHH;t̄t̄tLLIHwLMLMIHH+HLMM~(< HE f)HI;|HHL$(~(HH$   (t$PH`A]A\_^]HL$VWATAUAVH0HD$ H\$pHl$xMLHHj3HuH9HH;vH4    H> HHuHtHHoIt$IHtI;tHtI;t{̄tqH;tm> Ht
H	HHHwHHH+HLMHM~ I$f(Hf)HI;|LHIHwHt$hMMMEIIHiMMMEMtMtIHIL;tMt:MtIHIL;tMtIHIL;t~IIHN	LNLNIHH+HLMM~IE f(Hf)HI;|HI:ID$G(MH	 HMH	 H蝸HH\$pHl$xH0A^A]A\_^HL$UVWATAUH0HD$ H\$pLHHj3HuH9HH;vH4    H< HHuHttHHoIt$IHtI;tIHtI;t4̄t*H;t&< Ht
HHHHwHHH+HLMHM~I$f(Hf)HI;|LHIԫHwHt$hML$ MD$IIHgML$ MD$MtMtIHIL;tuMt:MtIHIL;tSMtIHIL;t6IIHLNLNIHH+HLMM~"    ID$f(Hf)HI;|HIL$AD$(G(HH\$pH0A]A\_^]HHHVWATAUAVH`HD$ HXHh )pHLHPfWp3IHuH,I;vUH4    HS: HuHt4I$I\$IHt$I;t̄t̄tI\$HHH+HHHHH~("7 fI$f)HH;|LLIHL$(+H\$0t$@It$H$   HuH,I;v~L,    I|9 HuMt]HH^Ht$I;tĀt7̄t-H^H~$(l6 ffff     Hf)HH;|LLHHL$(lA\$ IL\$`I[@IkH(t$PIA^A]A\_^HHHVWATAUAVHPHD$ HXHh LHHr3IHuH/I;vrH<    Hp8 HHuHtNHM HuI}IHtI;t#HtI;t̄tH;t 8 HtH[HE H] H}HHH+HLMHM~@ IE f(HE f)HI;|LHI觧I}H|$0fWD$@HuH$   HuH,I;vcL$    Ia7 HuMtBHH~Ht$I;t&̄t̄tH~HHH+HLMM~(@4 Hf)HI;|LHHL$(OIEE HL\$PI[@IkHIA^A]A\_^HL$UVWATAUAVAWH@HD$0H$   MLHHjH3HuH/H;vNH4    HL6 HHuHt*HHoIuIHtI;t HtI;t̄tH;t5 Ht
H8HHHwHHH+HLMHM~ IE f(Hf)HI;|LHI舥HoH$   MfMuH9HL;vIJ4    HG5 HHuHt%HM LeIvHtI;tHtI;t̄tI;t4 HtH< HE H] HuHHH+HLMHM~D  If(HE f)HI;|LHI舤IMO HGHD$ L
 DHބ H
?	 zLI      H9_vbH@ Ic$   H$   I#I;wIL;Or/H_ HD$(HU HD$ LH H
˥	 vHMHtaHU Hc$   H$   I#I;w
HH;r2H~_ HD$(HbU HD$ LLH H
a	 <vHH$   H@A_A^A]A\_^]HL$UVWATAUAVAWH0HD$ H$   LHHrH3HuH/H;vH    H2 HHuHtHM HuI^IHtI;tHtI;t̄tH;t2 HtHHE H} H]HHH+HLMHM~ If(HE f)HI;|LHI8HuHt$xMfMuH9HL;vJ    H1 HHuHtHLfI^HtI;tHtI;t̄tI;t1 Ht
HHH>H^HHH+HLMM~IFf(Hf)HI;|LHINEAF E HH$   H0A_A^A]A\_^]@SHPHD$ HHL$(/ L3HH HL$(/ HT$(HHL$(/ HG HL$(/ HT$(HHL$(/ H HL$(l/ HT$(HnHL$(r/ H HL$(@/ HT$(HBHL$(F/ HW HL$(/ HT$(HHL$(/ H HL$(. HT$(HHL$(. Hߤ HL$(. HT$(HHL$(. H HL$(. HT$(HHL$(. Hw HL$(d. HT$(HfHL$(j. HP[@SH@L
E3MJL$0HILT$(HH+HLMM~,fI
Hf(HIfBXDM;fB)D|HL$ H?tHH@[HL$WATAUH@HD$0H\$hHt$xHHٹ   O HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;vAHHKDHCHC HvHHHK(Hw H9wv
. LgL;g v- 3D$(D$pD$ LKLCHIHC HH\$hHt$xH@A]A\_@SH HH@  D$0    HHH [@SH HH  D$0    HHH [H\$Hl$WH HY3HHtLHt$0Hq H;t0D  HKHt HHkHk Hk( H0H;uHO Ht$0H\$8HoHo Ho(Hl$@H _H\$UVWH0Hq HH9qv, H_H;_ v, H9_wH;_ v, H/H9wwH;w vz, HtH;/tj, H;tsDL$PHW 3D$(D$PLHΈD$ QHw HH;t?Ld$XHXE3HHt HKL#LcLc H0HCH;uLd$XHo H\$`H0_^]HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ LķHHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYHd IK) HL$`&+ H61 HD$`HT$8HL$x) Ha1 HD$`H5 HL$`O HQ0D$( H$   HD$ LL蹶LHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ L4HHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYHD IK% HL$`' H- HD$`HT$8HL$x% HA- HD$`H HL$`/ HQ0D$( H$   HD$ LL)LHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ vP# HHL$0H^HHE HHEHAH\$8H9_wH;_ v# HHtH;t# LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$h1Ho LH;t2HXHHtH HKL+LkLk4 H0HCH;uLg Ld$hH\$pHl$xHH@A]_^D$HH)t$0f(]A f/vLD$PH+ H
 f.z+u)!  "   HK   fW7 (t$0HH)|$ f(X=. f.=- zuf((|$ (t$0HHf( \=- ^(|$ Y(t$0HHH\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,CH;}:D$Hfffff     HHH;f(DfYf)D|HT$ HL$0LL菑H$   HHP_^]HL$WHPHD$ H\$hHt$xHH3t$pN HtHHHHsHs Hs(D$p   HH0H HL$( HT$(H HL$($ HH\$hHt$xHP_@SH`HHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HLHIHH+3HLMM~\LT$@L\$8H|$pH|$(f     IIHI;f(Df\DHf(LHfYHfXLf)L|H|$pHL$ HDHH`[HHPUVWATAUHPHD$ HXH3퉬$   Mh@LhM`L`It$HuH9HH;v¸H    H HHuHt螸HHwI\$HHtH;tsHtH;t^̄tTH;tP Ht
HHH/H_HHH+HLMM~,f     I$IE f(fYHf)HI;|LHHL$(MHH$   HPA]A\_^]HL$ATAUAVH@HD$0H\$hHt$pH|$xMHH3HAHA HA(HtaHUUUUUUUH;viHoHHCHC L$MJHK(3D$(D$`D$ LKMHHJHC H\$hHt$pH|$xH@A^A]A\HL$SUWAUAVH0A   LH  AM  A
e  E3AADEDE+t3AAAAD+u	AD+AHp     HiM  HHH+HHHHiH+A;u3IչN  _3ɍPCD跰H0A^A]_][3Ht$hM  Ld$(E3L|$ DAD|$pM  Ip     E   uD+;sD3D3U  uA`A;uW3҃=r!˸   +i+(ƋHIHHH+HHHHiH+ȋыѯuAAv+;s<U  A;uAU3҃=r#Ëظ   +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ   +i+,Ӌ苮D؅t+D;sDE;U  AIqD|$pH|$`tV3Ҹ=r)D   DAAA+iD+֋=sDpDV  Ht$hEtAD3AܭADOL|$ Ld$(H0A^A]_][HL$SUWAUAVH0A   LH'  A  A>  E3AADEDE+t3AAAAD+u	AD+AH   Hi  HHH+HHHHiH+A;u3Iչ  /3ɍPD臯H0A^A]_][3Ht$h  Ld$(E3L|$ DAD|$pM  I   E   uD+;sD3D3  uA`A;uW3҃=r!˸  +i+(ƋHIHHH+HHHHiH+ȋы衮uAAv+;s<  A;uAU3҃=r#Ëظ  +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ  +i+,Ӌ[D؅t+D;sDE;  AIqD|$pH|$`tV3Ҹ=r)D  DAAA+iD+֋߬=sDpD  Ht$hEtA)D3A謬ADL|$ Ld$(H0A^A]_][H\$Hl$WH HZHyHHHtH;t(HtH;t̄t	Ht$03H;_tH Ht
HUHH7HH_HH+HLMM~ HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _钅HWATAUAVAWH  HǄ$0  HXHp)p)xD)@D)HIILfEWfA(3L$  I½H$  H$  HǄ$      HǄ$      H$  f($  H$  fD($     k Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       M   Mc'Mc       H$  C$  H$   Hu3H$   H+HH$   HH+HH;sHAH$      HH;v H$   H$   H$   HHT$pH|$xHH+Hu3*H;v H$   HtH;t H+H(D$pfD$`L$  A   HT$`H$   H$   H;$   vL H$   Hu9 E3LHI;K wHtH3H;Hs IH$  f(H fW
( fD.zt f(AXt$p   j Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       MceDMa  H$  P$  H$   Hu3H$   H+HH$   HH+HH;sHAH$      HH;v H$   H$   H$   HHT$`H|$hHH+Hu3*H;v H$   HtH;t H+H(D$`f$  L$  A   H$  H$   H$   H;$   vS H$   Hu@ E3LHI;K wHtH3H;Hs IIVHuE3IIN(H+HE3I^ HH+HH;s;HCIF    H;v I>H|$`H\$hIN IvHH+HuI"H;v HtI;>t{ H+H(D$`f$  L$  A   H$  IIvI;v v8 I>Hu* MLHI;K wHtHIH;Hs IVHuIIN(H+HI^ HH+HH;sDHCIF    H;v I>H|$`H\$hIN IvHH+HuI"H;v HtI;>ts H+H(D$`f$  L$  A   H$  IIvI;v v0 I>Hu" MLHI;K wHtHIH;Hs AA? ~@HcH$   H$   H+HH;r H$   HIA;|IVHuIIN(H+HI^ HH+HH;s3HCIF    H;vf I>H|$`H\$hIN IvHH+HuI"H;v3 HtI;>t# H+H(D$`f$  LL$pA   H$  I裍IvI;v v
 I>Hu
 MLHI;K wHtHIH;Hs
 AA}D ~AHcH$   H$   H+HH;r{
 H$   HIA;]D|$   utH$   Ht L$   L$   L$   H$    H$   Ht L$   L$   L$   H$   r       Ht
H$  HIH$  L$  L$  L$  |	 f(DL$pI}@Hc   0 Ht
H$   HIH$   LD$pHH$   '	 f(IH$   HH$   H+HHt;H;r H$   4HH$   HH$   H+HH;rIH+HHt>    H;r H$   <HH$   H$   H+HH;rDL$pHc   5 Ht
H$p  HIH$p  LD$pHH$p  #, f(IH$  HH$  H+HHt@fD  H;r H$  4HH$  HH$  H+HH;rIH+HHt>    H;r
 H$  <HH$  H$  H+HH;rDL$pIc]D   4 Ht
H$  HIH$  LD$pHH$  "+ f(IH$0  HH$(  H+HHt?D  H;r
 H$(  4HH$0  HH$(  H+HH;rIH+HHt>    H;r	 H$(  <HH$0  H$(  H+HH;rDL$pIc]D   4 Ht
H$@  HIH$@  LD$pHH$@  "+ f(IH$`  HH$X  H+HHt?D  H;r	 H$X  4HH$`  HH$X  H+HH;rIH+HHtA    H;r H$X  <HH$`  H$X  H+HHH;rAX     	    I   I  MEHH$  HD$HH|$@L|$8HL$0HT$(LD$ L$   L$  H$  H$  HH$   H$  Ht L$  L$  L$  H$  c       	    I   I  MExMMHH$  HD$PH|$HL|$@HL$8HT$0LD$(LL$ L$   L$  H$  H$  yHH$   H$  Ht L$  L$  L$  H$      A;]D   O~	    HcA   L{ HH$   dHI  A   L Hd6Y0A   L{ HH$  d0}	    A   Lz HH$   hdHI`  A   L- HId6Y0A   L,{ HH$@  $d0g}	       = fA;]@   D}	    HcA   Lz HH$   cLA   L HI  dH$  H}f(A   Ld HI  dH$@  HMXAY4$XA   LZz HH$p  Bc07E3AA9]@~AHcH$   H$   H+HH;r H$   HIBA;]@|AA9]@~BHcH$  H$  H+HH;r H$  HIA;]@|AA9]D~GfD  HcH$0  H$(  H+HH;rk H$(  HIA;]D|AA9]D~GfD  HcH$`  H$X  H+HH;r H$X  HIWA;]D|D8$    H$X  Htk L$X  L$`  L$h  H$@  F H$(  Ht3 L$(  L$0  L$8  H$   H$  Ht L$  L$  L$  H$p   H$   Ht L$   L$   L$  H$    H$  Ht L$  L$  L$  H$  f H$   HtS L$   L$   L$   H$   . H$   Ht L$   L$   L$   H$      H$X  Ht L$X  L$`  L$h  H$@   H$(  Ht L$(  L$0  L$8  H$   H$  Hto L$  L$  L$  H$p  J H$   Ht7 L$   L$   L$  H$    H$  Ht L$  L$  L$  H$   H$   Ht L$   L$   L$   H$    H$   Ht L$   L$   L$   H$   j L$  I[0Is8A(sA({E(CE(KIA_A^A]A\_HPWH  HǄ$   HXHhHp IHH    3Ht
HL$@HHHD$@Hl$XHl$`Hl$h   DBH$   ^ H$   HD$8D$0D$(HD$@HD$ L$  LHHnH$   H$   ( Hx H$    t7H$   H$    H$  LHAH$    H|$XHHL$`H;vo HL$`H|$XHT$@HHT$pH\$xHH+HuH'H;v5 HT$@HtH;t  H+H(D$pfD$pL$  A   HT$pHL$@~Ht$XH;t$`v H|$@Hu LLHI;K wHtHHH;Hs H$  HHT$@PH$    HL$XHt Hl$XHl$`Hl$hHL$@ L$  I[IkIs(I_HWATAUAVAWH   HǄ$   HXHhHp )p)xD)@IHHHY     E3Ht
H$   HIH$   fEWD$P  L$P  HH$   zLt$pLt$xHt$HH^HHtH;txHtH;tc̄tYH;]t!HM P HtHHE Lu H]HHH+HLMIM~2(
m fffff     Hf(fWHE f)HI;|LHHL$@RH|$pIH\$xH$   H9$   v H$   HD$0Ht$8(|$0)|$0L|$0Ld$8    H  uIHGH;  (D$pf$   HuHwH$   H$   H;0uHpf$   HuHGH$   H$   H;uHALpfD$`HuHGHD$hHL$`H;uHAHHD$HHl$PLmMufA(H$P  HL$@f(YvHl$ H$P  HD$(Lt$Ht$PIHH+HLM3M~9ffD  If(HE f(fYf\f)HI;|MHT$ HL$@f$   Mu E3MME3M;cw It$H$   Hu MLI;s r 6HuH_H;uH_H(H\$xMu MMM;cw LHt$8(|$0HW0HH  uIH_H$   HH;$   vF H$   H$   HD$ Ht$((D$ fD$ HI  Hl$`H$P  HD$hLd$ Ht$(ffff     HCLkHD$HHl$PH} ufA(H$P  HL$@f(Y3Mu MM$I;s r \Ll$HL$PLMIHH+HLMIM~>fff     IE f(fYHE f(fXf)HI;|HT$`HL$@	H(H;_uHH;_IDMu MM$I;s r HHH$   HtQ L$   L$   L$   H$   , L$   I[8Ik@IsHA(sA({E(CIA_A^A]A\_D$SH`
e )t$P)|$@f/=W HD)D$0D)L$ fEWf(fE(   f(\f(L$pf( f(\f/

 v
fA(\XfA.z%u#\LD$pHyo H
" |$p诼DE
 AYf(轿 D^fA.zuLD$pH5o H
 qf/5@8 rf(HJOt@
 f/v*ff     fA(f(\Xf/^DXwf/v*ff     f(fA(^Xf/\DXwf(HP(t$P(|$@D(L$ DXfA(D(D$0H`[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
qh	 HR" LH L
1 HD$ 7fAn D$XHD$XH#H;u'H
+h	 H L
 Hn HD$ A9 *H
g	 H L
 HY LHD$ H	 H
u	 Ht$PHHHj	 H;r"H
	    $FH
E	 HHC	 LHH5	 H;rH
	    ELHIPHIL;t3     HHH;ufnH HLD$ LIP^fnE \A YYf(Y\Y
f	 A A   X
  8Ht$PH\$`IH0A\_]LD$SWATAVHxHB MIH+BHLHN  H
f	 )t$PfWLHG )|$@f(9H      fn+$   H$   H#H;u*H
?f	 H( L
 H LHD$ %A$f/w*H
	f	 H L
 H MHD$ O$   H$   H#H;u*H
e	 H L
 H MHD$ LO H
e	 H$   L+OHt$pH LILl$hL|$`"%HG H+GHHuK HG H_   LL+IL;LFH
΋	 H+HHD$0L,    H	 H$   IH	 H;r%H
-	 IeCH
	 H$   H	 HIHr	 H;rH
	 I.CHHO E3H+OIHHtBL$   H;r L$   HGHHLILHO H+OHH;rE3L$   Ht$pIL- Ll$hHH;t LHH;u, IA^$M   % L$   ff     fAn HcHP\f(f.f(fTY\XzuAf/v   D fnHY\D I;rLD$0f(IHl$ X5L|$`(t$P(|$@H$   IHxA^A\_[fWFIHxA^A\_[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
b	 H LH L
 HD$ /2fAn D$XHD$XH#H;u'H
b	 H| L
U H֘ HD$ |Af/v w*H
mb	 H. L
 H LHD$ Hۈ	 H
̈	 Ht$PHHH	 H;r"H
E	    {@H
	 HH	 LHH	 H;rH
	    F@LHIPHIL;t3HHH;ufnE  HLD$ LI^P\A YYf(Y\Y
fa	 A A   X
[ .3Ht$PH\$`IH0A\_]HHHUVWATAUAVAWH   HD$@HX)p)xD)@MMHHHB H+BH  Iy   fWLH H
`	 8fAn.$   H      H$   H#H;u*Hm HD$ L
A MH? H
`	 cE3MIL$HtKI$Icf/v
IL;r/H HD$(H HD$ MH H
%`	 0H=`	 H$   Ll$0LF L+FILD$8H$   HD$0HHDHD$8L;HBHLLHҖ HZLMH HHF H+FHHD$8H<    H	 LHH	 H
	 H;r HH
	 =LH	 H
ԅ	 HHHυ	 H;rHH
P	 =HIHN H+NHHt/@ H;r HFHIHHN H+NHH;rH/HH;tf     L(HH;uHF H+FHHu H~I$Ln L+I   L;LFIt$L;LFH
 Ht
HL$HH3HD$H$   L$   HHL$H3I9t$vMD#  Hc4HD$hHL$`H+HH;r HL$`fA(^HI;t$r3HM   HcHpfEnEHL$hHHT$`H+HH;r HL$hHT$`A\Y4f(Y]	 YXH+HH;rM HT$`Y4D \D HI;g3Hl$ MLD$8f(H$   H.HL$`Ht耳 Ht$`Ht$hHt$pHL$Hg HfW@HL$   I[PA(sA({E(CIA_A^A]A\_^]@UAUAVAWH   HB MIH+BLLH  I@ I+@H  H
\	 LH )$   fWK]H
l\	 H LMACf/w*H
G\	 H L
 Hr MHD$ m+LE IU H$   L+EI+UH$   IHH$   H=[	 L$   HT$@L$   HL$@E3)$   I;H$   Ld$HHCH% MHHL$H LLHL$   H$   L\$0HD$(H$   HL$PMLIHD$ ŔIE I+EHHu HE I}H+EHHu Iu HM H]I+uHH+HHH;w
HH+H=    H;HFI@^菰 f(HtyHT$xLD$pffffff     Z	 Ic\IHf(\HYf(YYYXf(\YAXAXL;rHD$`LL$XLD$Pf(IHD$ +L$   H$   ($   ($   H$   H$   IHĸ   A_A^A]]fW<IHĸ   A_A^A]]LL$ LD$VWATHpHD$(H$   ILHH\$     HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@HH;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt Ht$XHt$`Ht$hHL$@ HH$   HpA\_^HLH WATAUAVAWH  HǄ$H  HXHp)p)xD)@IHLH  0fWfD(ǹ   葮 HtH$  H33HH$  H$  H$  H$  H$   H$   H$   H$   H$   k$   H$   UD$`    Ht
H$@  HHH$@  H$X  H$`  H$h  Mc   IH$@  #Mr  A   ff     H$   Ӣ$   H$X  HuHH$h  H+HH$`  HH+HH;sHAH$`     HH;v H$`  H$X  H$@  LHT$pHt$xHH+HuH*H;v< H$@  MtL;t$ H+H(D$pf$   L$   MH$   H$@  cL$X  L;$`  v H$@  Hu LLII;K wHtHHH;Hs M+A   H$   kH fW
( f.ztfD(DXC X$       Ht
H$   HHH$   H$   H$   H$   McuDIH$   !Ml       H$   àD$pH$   HuHH$   H+HH$   HH+HH;sHAH$      HH;vr H$   H$   H$   LH$   H$  HH+HuH*H;v) H$   MtL;t H+H($   f$0  LL$pMH$0  H$   aL$   L;$   v H$   Hu LLII;K wHtHHH;Hs IIu@Hc>    Ht
H$  HHH$  |$pLD$pHH$  HH$  HH$  H+HHt:H;r H$  4HH$  HH$  H+HH;rHH+HHtA    H;r H$  4HH$  H$  H+HHH;rHc>   ) Ht
H$   HHH$   |$pLD$pHH$   HH$   HH$  H+HHt:H;r H$  4HH$   HH$  H+HH;rHH+HHt?D  H;r H$  4HH$   H$  H+HHH;rIc}D   8 Ht
H$  HHH$  |$pLD$pHH$   HH$0  HH$(  H+HHt:H;r" H$(  4HH$0  HH$(  H+HH;rHH+HHt>@ H;r H$(  4HH$0  H$(  H+HHH;rIc}D   H Ht
H$p  HHH$p  |$pLD$pHH$p  0HH$  HH$  H+HHt:H;r2 H$  4HH$  HH$  H+HH;rHH+HHt>@ H;r H$  4HH$  H$  H+HHH;rAX     T	    I   I  IUHL$  LL$HHt$@M   LL$8HD$0HL$(HT$ L$@  LD$`H$   H$   yHH$  ˥H$   Ht褥 H$   H$   H$   H$          3T	    I   I  IUxMEHL$  LL$PHt$HM   LL$@HD$8HL$0HT$(LD$ L$@  LD$`H$   H$   HH$   H$   Ht٤ H$   H$   H$   H$   贤 ED  E;uDt  dS	    IcH$   L$   I+H  F;  LL;r L$   I  A   LX H9C4Y0H$0  H$(  H+H  F;  LgL;rg H$(  B4R	    H$   L$   I+H
  F;  LL;r L$   I`  A   LW H8C4Y0H$  H$  H+H|*F;}#HH;r H$  4A   DÍSH$`   H H$p  ßH@ H$   H$`   H$    H
4O HL$ LDǋH
    DÍSH$`  A H H$p  DH H$   H$`  # H$    H
M HL$ LDǋH
!    DÍSH$`   H  H$p  ŞHB H$   H$`   H$    H
>N HL$ LDǋH

 A   EAWH$`  A H  H$p  DAH H$   H$`  " H$    H
L HL$ LDǋH
 
 O	    A   E=     E;u@  O	    IcH$  L$  Ld$pI+H  G;  HFH;r* H$  HD$pMLT HI  T7HH$0  H+$(  HLH L+HIHL$0H" HD$(HI HD$ L" HH
s" 
Lg L+gIH$0  L$(  I+HHu L$(  HG H+GHHua MIHOqf(A   LT HI  6HH$  H+$  HLH L+HIHL$0H! HD$(Hw HD$ L! HH
! 	Lg L+gIH$  L$  I+HHu L$  HG H+GHHu MIHO qXHD$pYtXA   MLeK HH$   M40AEǺ   H$`  c H# H$p  fAH H$   H$`  D H$    H
J HL$ LDƋH
B
 A}@ ~*HcH$  H+$  HH;r A;}@|֋A}@ ~2     HcH$   H+$  HH;r^ A;}@|֋A}D ~*HcH$0  H+$(  HH;r+ A;}D|֋A}D ~4ff     HcH$  H+$  HH;r A;}D|4L	    Ǆ$      \$pL$   HT$pH$   S$   H$  HuHH$  H+HH$  HH+HH;s#HMt
 IHHGH$  YH;vD H$  H$   H$  ($   f$0  L$   L$0  H$   H$  ~DK	    D$p   $   LD$pH$   HL$`fD$`HT$`H$  J	    \$pMP  HT$pH$@  gD$`HT$`H$  迴J	    
 D$`\$pLD$`HT$pH$   <D$`HT$`H$  trJ	    \$pM@  HT$pH$   -D$`HT$`H$  53J	    I   L$   H$   $   H$   H$  D$   H$   H$  ѳH$  Df(H$  Ht H$  H$  H$  H$p  Ś H$(  Ht貚 H$(  H$0  H$8  H$  荚 H$  Htz H$  H$   H$(  H$   U H$  HtB H$  H$  H$  H$   H$   Ht
 H$   H$   H$   H$    H$X  Htҙ H$X  H$`  H$h  H$@  譙 H$  Ht蚙 H$  H$  H$  H$  u f(L$  I[0Is8A(sA({E(CIA_A^A]A\_HL$VWATH0HD$ H\$XHl$`MIHHMHHf(H:$HrN HLc(3LL$pMueJ    Hh	 HHHh	 H;h	 rH
ch	  HHKHH9S(v7H+fff     HHHHH;S(rHSMILHG~LL$xMumHS(HHnh	 LHHah	 H;Rh	 rH
g	  LLC H9{(v*fffffff     HK HD HHH;{(rHHHS MI LH}HH\$XHl$`H0A\_^LI E3L9A(v* KHAIBDYAXBBL;A(rHL$WH`HD$ H\$xH$   HHٹ   p 3HtHHH   T Ht
HL$(HHHD$(Ht$@Ht$HHt$PLD$(HH记HL$@Ht Ht$@Ht$HHt$PHL$(і HH\$xH$   H`_HHd 3LL$XLD$`3)t$0)|$ D$XD$`5 = fTf/vH* H
6 Re	 3LL$XLD$`3҈D$XD$`fTf/vHU* H
6 e 3LL$XLD$`3҈D$XD$`}fTf/vH* H
U6 dw 3LL$XLD$`3҈D$XD$`<fTf/vH) H
6 d. 3LL$XLD$`3҈D$XD$`fTf/vH) H
5 Nd 3LL$XLD$`3҈D$XD$`fTf/vHQ) H
5 
d(t$0(|$ HHH\$Hl$WH HZHHHHtH;t)fHtH;tf̄t
fHt$03H;_tH Ht
HVHH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHH;Ht$0H\$8Hl$@HH _H(Y 3LL$0LD$83҈D$0D$8if(fT
M f/
5 vH' H
54 bY H(H(Y 3LL$0LD$8D$0D$8	f(fT
 f/
 vH' H
3 PbYg H(HL@HHWATAUAVAWH  HǄ$8  HXHp )pMLE3Dt$HH 0H
c	 HHHb	 H;b	 rAVH
{b	 HHL$@Htf(HID$0L$  Ic}    誒 Ht
H$   HIH$   Lt$8LD$8HH$   wH 0I@ H$   HH$   H+HH;sSH:b	 HHH,b	 H;b	 r   H
a	 HHL$@Htf(IHHIfff     H+HH;sHHH$   H$   AE Hc   訑 Ht
HL$PHIHD$PLt$8LD$8HHL$PvH 0Ifff     HD$pH|$hH+HH;sSHCa	 HHH5a	 H;&a	 r   H
`	 HHL$@Htf(%IHHI@ HD$pH+HH;sHHH|$hHB 0H`	 HHH`	 H;`	 r   H
,`	 gHH|$hHL$@Htf(H|$hD$0    H\$pH+HC8  Hu H|$hI$HA   E;u   D$0"   McH\$pHHt$hH+HA  GD;  Ml$L;r; H\$pHt$hN,AIcH+H|VC;}OHH;r Ht$hA   Ld II$LIHL$@H HL$  ;   DBH$   H H$     Hc H$   H$   L$  H$   LC$  Hv HD$ DǋH
    DBH$  ] H H$  `   H H$   H$  < L$   H$   LC$   Hu HD$ EċH
1 H$  H HD$8   5 fD  A;u   D$0(   FD$HLcH|$pHHL$hH+HA  CD;  IL;r< H|$pHL$hJHD$@HcH+H
  G;  HsH;r HL$hL<H$  H~ H+~HA  G;6  LcL;r LvH$   L$   I+Hz  G;o  HsH;r~ L$   LD$@IH$P  Lf(H$H  M HLD$8CH$X  2 LHH$0  !H ID D$0)   H$   H$   H+H|LG;}EHH;r H$   LHT$8H$@  H HD$8t$HL$     DBH$   H H$  ˈ   HE H$   H$   L$   H$   LC$   H| HD$ DËH
    DBH$  ? H H$  B   H H$   H$   L$   H$   LC$   H0| HD$ DËH
 v   DBH$   Hv H$  蹇   H3 H$   H$   L$  H$   LC$  H{ HD$ DËH
    DBH$  - H H$  0   H H$`  H$   L$h  H$  LC$h  Hfr HD$ DËH
 d   DBH$   Hd H$  视   H! H$   H$   L$   H$   LC$   Hq HD$ EċH
x D$0+   H$   H$  HoHL$hHtV 3H|$hH|$pH|$xHL$P; H$   Ht( H$   H$   H$   H$    H      DBH$   HP H$  蓅   H
 H$   H$  o L$   H$   LC$   Hn HD$ A   H
a L$  I[8IsHA(sIA_A^A]A\_HATAUAVH`HD$ HXHhHpHx LHٹ   : E3Ht
HL$(HIHD$(Ll$@Ll$HLl$PE3E3HT$(H<HL$(&IH|$HHH\$@H+IgfffffffIHHHH?H   IH;r H\$@H+I$IPt2HH(H|$HHH\$@H+IHHHH?HH;rRH\$@Ht+H|$HH;tfH H(H;uH\$@H
 Ll$@Ll$HLl$PHL$( 2DHt$H;tHa H(H;uH\$@Hǆ Ll$@Ll$HLl$PHL$(讆 L\$`I[ Ik(Is0I{8IA^A]A\H\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$GI;       HtHCHtL@E3ItIP3H	tHB3H@HfHtHB3H@Hff\MtIE3A@(HE HI;ffYf)ToLMHHH\$@Hl$XH A\_^H;  WATAUAVAWH@HD$ H\$pHl$xH$   HLLi3MuH9HL;v5VJ<    H3 HHuHtVHt$(Ll$0I|$IHtI;tUHtI;tŪtUI;t(H HtHHHD$(HH\$(H|$0HHH+HLMHM~     I$f(f)HI;|LMHT$(IV+LuMtM;t-UMtM;tŪtUM;t$t!I$ MtI_I$I$Mt$IHH+HLMHM~"    HE f(I$f)HI;|MIH*Ht$I;tT̄tyT̄toTH;}t!HM f HtHHE H] H}M~f(HE f)HI;|LMHHL$($*H H\$pHl$xH$   H@A_A^A]A\_H\$Hl$WATAUH HZLLHHtH;tSHtH;tS̄tSHt$@3I;\$t$IL$t HtHτID$It$HI\$HH+HLMM~'     IEMT$HI;f(DfA)D|IT$IML)M]Ht$@H\$HHl$PM\$IE ID$ IH A]A\_@SH HH      D$0HD$0H#H;uH H
 ' LRf/ rx _ f/7 f(w{7 f/w
,H [HT H
=7 L}RHL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;vQH    H HHuHtQHHwI\$HHtH;tQHtH;tQ̄txQH;tt Ht
HςHH/H_HHH+HLMM~I$f(Hf)HI;|LHI%'IT$HOnHH\$XHl$`H0A\_^H   HLD$(I HAI@HAI@HAI@HA HL$PI@ HHHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@H|$X ufWHĨ   H$   HL$ 蝂HĨ   HHXWH   )p)xD)@Af(f(f   fD)HD)PD)XD fD(fD(DYDYD)`fDW
 E^fD(f(YY } Y= 3L$   L$   3fD(f(DYƈ$   $   DY ~f(fT
b f/
J vH	 H
J LY A^f(X53 f;v5fD  ffnYfA(EY\AYXf;rDY fA(| (|$pL$   I[E(CE(KYc YE(SE([E(cA(sI_LH   E)K3fD(Y E)SE)[MKMCACACfD(\ f(fD(fT
; f/
# vH H
C K)t$p5 )|$`D)D$PDYD fA(A\EXfA(f({ E\fD(EYDYfWf.zt5AYAYY= ^f(}{ AYY. \DX(|$`(t$pD(L$@fA(D(D$PD(T$0D(\$ HĈ   HWATAUAVAWH   HǄ$   HXHhHp IILLIX   { E3Ht
HL$pHIHD$pfW$   L$   HHL$pYEIH9_~GfH/H$   H$   H+HH;r H$   HD HAHIcH;G|   { Ht
HL$@HIHD$@L|$XL|$`L|$h   z Ht
H$   HIH$   L$   L$   L$   H$@  HD$8$8  D$0$0  D$(HD$@HD$ L$   LD$pII5Hl$`H+l$XHH;ntLH Ht;HH;vKH    H} HuHt^KHL>HnAIH~=fD  HD$`H+D$XHH;r' HHD$XHHHHcH;F|H$   Hty L$   L$   L$   H$   ^y HL$XHtNy L|$XL|$`L|$hHL$@5y H$   Ht"y L$   L$   L$   HL$p y L$   I[0Ik8IsHIA_A^A]A\_H\$H|$Lٍ   A   AHp     H   AEAAAHHiN  HHH+HHHHiH+HAEKMi  IIH+HHHHiL+EKD;sA+	A+ɁAEtAH;wH\$H|$A#H\$Hl$WH H*HHH]HtH;tIIHtH;t4Īt*IHt$03H;_tH Ht
HvzHH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHHHt$0H\$8Hl$@HH _%. f(LIp     I   \f     EIMiN  IIH+HHHHiL+IEAIHi  HHH+HHHHiH+AIA;sD+
D+AfAHH*^YXf/mH\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$G` I;       HtHCHtL@E3ItIP3H	tHB3H@HfHtH3JffYMtIE3AH HE HI;ffYf)TkLMHHH\$@Hl$XH A\_^HH   )p)xD)@f(f(D)HD)PD)XD
) fD(fE(DYD)`D)l$ fD(fD(DYf(E^YY s Y=N 3L$   L$   3fD(f(DYƈ$   $   DYM f(fT
 f/
| vH; H
| BY 6 H*    A^f(Y5* X5I AYHHDXA\EYAYf(YXuDY% fA(r D(l$ L$   A({E(CE(KY YA(sE(SE([E(cIH\$UVWHPHBBJ HD$0HHD$8L$@HHxH|$ptH#HHD$pHL$xHڃH;HT$xHMHHHL$ LH+E3HH+HHH,CH;}XD$8HT$0D$@ff HHH;fDHfYHfYfXDf)D|HL$ LLHaH$   HHP_^]@UATAUH`Hl$PLaH]0HID$Hu8HH}@L)u A0H;v9CI$HuLH<    H      H   HHH;w
HHHy H+HL$PHHID$HSLt$@3HD$8   LI94$HDHH=   IE HD$0HD$(   HL$ HK@]@t	H H]0Hu8H}@(u HeA]A\]Hl HHmHdBB@UH`Hl$PH] HYHu(HCH}0H9Le8L)u qHAY0H;vAHHuLH4    H      H   HHH;w
HHHx H+HL$PHHHCHWLt$@3HD$8   LH93HDHH=   I$H HD$0HD$(   HL$ HOt	HE H] Hu(H}0(u Le8He]H* HHnHe AHM;ML   HH$H MtIBHtHH3HtHA3HatL@E3HtHP3I@BYJpHtHA3H	tHP3HtHH3HBIM;BDYAPXBXDBD\H$HATHPHLLL MAvHPA\_Hl$@HhH|$0Ll$(Lt$ LpH@ Hl$xHl$`HH3H+LIAMtH$IHD$`HL$pIAI;LD$pHMH8E3M;  H\$HHt$8    L3L+ILH   M$HwMtIAHtHX3IH I CIHYMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHHH;YDD!H;}AI$MtIAHtL@E3HK HA@IHHH;Y|I;H}ZfMtIAHtHH3II$IL@ HHH fHMf(LHI;fYfB)|L;}?M$MtIAHtHP3IH I BIIIL;Y|J/HL$xHH3H+HT$`H;HD$`HMIM;H9Ht$8H\$HLl$(H|$0Hl$@Lt$ HPA\@SH HID$8    H`HH [HL$UVWATAUHPHD$ H$   LHHj3HuH9HH;v<H4    H HHuHt<HHoIt$IHtI;tV<HtI;tA<̄t7<H;t3 Ht
HmHHHwHHH+HLMM~I$f(Hf)HI;|LHII\$H\$0H\$8HwH$   HHLLHHHtWHtIHHH;t~;HtIHHH;ta;HtIHHH;tD;LLHHmHT$(HID$G(HH$   HPA]A\_^]H\$Hl$WH HLH|	 HH]HHtH;t:HtH;t:̄t:Ht$03H;_tH Ht
HkHH7HH_HH+HLMM~!D  HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _"H\$WH HLH	 HLGLOHMt\MtHHIL;t9Mt:Mt5HHIL;t9MtHHIL;t9IHKINkLK E3LKIHH+HLMM~*ffff     HHKIM;fB(DfB)D|HSHH\$0H _Hl$Ht$WHPHcq()t$@fWHHt$8Ht$(Ht$H;t8̄t8̄t8H\$`3H;qtH	 Ht
HiHHHHwHHH+HLMM~( @ HHI;f)D|HL$ LH:LcG(t$8LD$(LD$0MtWMtHHIL;t7MtHHIL;t7MtHHIL;t7IHOMIiLO LOIHH+HLMM~(՚ D  HGHI;f)D|HWHL$ 9H\$`Hl$h(t$@Ht$pHP_Hl$Ht$H|$ ATH0B(DA(HH
	 HL
 H D$  fH}IHtI;t6HtI;t6̄t6H\$@3H;~tH Ht
HhHHHH~HH+HHLMM~"fD  HE HHI;f(Df)D|LHHVLELM MtMtIHIL;t6Mt:MtIHIL;t5MtIHIL;t5IHNIgLN LNIHH+HLMM~,ffffff     HELVHI;f(DfA)D|HVHMH\$@Hl$HH|$XHHt$PH0A\H\$Ht$WH@B(DA(HH

	 HL
 H D$ 6dLOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0HLO L_MKHD$PL\$0HD$8IHNHH+HLMM~-ffff     HIHI;f(DfXDf)D|HT$0EH\$XHt$`HH@_H\$Ht$ WH@B(DA(HH
	 HL
 H D$ cHD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$PvHNHD$XHD$0HL$XLIHD$PL_LIHD$8IL\$PHH+HLMM~,@ HIHI;f(Df^Df)D}HL$XHT$0HL$P	vH\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ LO L_t$0MKIL\$`HL\$(H+HLMM~.ffD  IHI;f(DfXf)D|HT$`HL$ UH\$hH(t$@HP_H\$Hl$Ht$ WH0A LBHH
{
	 HL
 H D$ qH]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t591H
		 H H HD$(H LHD$ HtH;t0H;^tH Ht
HHbHH>HH^HH+HLMM~"fD  HE HHI;f(Df)D|LHHH\$HHl$PHt$XH0_H\$Hl$Ht$ WH0A LBHH
		 HL
 H D$ H]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t5/H
	 H H HD$(H LHD$ jHtH;t/H;^t!HN| HtH`HFH~HH^HH+HLMM~  HE HNHI;f(Df)D|HVLHH\$HHl$PHt$XH0_Hl$Ht$WHPHcq )t$@fWHHt$8Ht$(Ht$H;t.̄t.̄t.H\$`3H;qtH	 Ht
H_HHHHwHHH+HLMM~( @ HHI;f)D|HL$ LH0Hcw t$8Ht$(Ht$H;t.̄t.̄t-H;wt!HO HtHI_HGH_HHwHH+HLMM~( HGHI;f)D|HWHL$ L
0H\$`Hl$h(t$@Ht$pHP_Hl$WATAUH0B DA HH
!	 LL
 H D$ W\I|$IHtI;t-HtI;t,̄t,H\$P3Ht$XH;}t!HM  HtH;^HE H] HH}HH+HHLMM~!@ I$HM HI;f(Df)D|LHIIt$HtI;t\,HtI;tG,̄t=,H;ut!HM4 HtH]HEH]HHuHH+HLMM~*fff     ID$LUHI;f(DfA)D|HUIL$LH\$PHt$XHHl$`H0A]A\_H\$Ht$WH@B DA HH
X	 HL
6 H D$ ZLOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0HLOL_HD$PL\$0HNHD$8IHH+HLMM~"HIHI;f(DfXDf)D|HT$0H\$XHt$`HH@_H\$Ht$ WH@B DA HH
P	 HL
& H D$ vYHD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$PlHNHD$XHD$0HD$PHL$XLIHD$8L_IL\$PHH+HLMM~1f     HIHI;f(Df^Df)D}HL$XHT$0HL$PilH\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ %LOL_t$0IL\$`L\$(HH+HLMM~3ffff     IHI;f(DfXf)D|HT$`HL$ H\$hH(t$@HP_HL$WATAUH@HD$0H\$hHt$xHHٹ   V HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;v/HHKPHCHC HvHHHK(Hw H9wv} LgL;g vm 3D$(D$pD$ LKLCHI;#HC HH\$hHt$xH@A]A\_@SH H_HH [U Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?Lu_HH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ MbGLG HHHN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ FLG HV 3LOHˈD$(D$@D$ dJHG HMtMIHEHOS HN IH+NHHHHH?HXtLOLF HVHHG HmHHt$XH0_H\$Ht$WH HY0HHR0HRLH_HCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _H\$Hl$Ht$H|$ ATHPHA0IIH(I LHHtH;t  H9kujHHn0HtH;t H9ouMHV0HHR-L^0M[HF0HF8    H HF0H@HF0HHI$IL$   fD  HHtH;t} HGH9CHt7HL$ HHCHAH(JLD$0HT$@(l$ fl$0H[HL$0HHCHAHD$8HL$ HD$(HHD$ HI$HAID$H\$`Hl$hHt$pH|$xIHPA\H\$Ht$WH HY0HHR0HRLH`HCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _LSHPHHA0MKICH IS(D$ fD$ ISICMC(L$0fL$0ISHHK0GP E3L[0L[8HP[H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIH tHH[    tIM HHL$0HD$8@tTIE0HHtH;t
 H;u)AHT$0LILd$ [EHH@HM :HL$02*HD$8HHI tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIH tHH[    tIM HHL$0HD$8@tTIE0HHtH;t H;u)AHT$0LILd$ ^EHH@HM :HL$0)HD$8HHI` tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$WH@)t$02)|$ 9HHf/vH\f/5D f(v!fWޚ M HT$PbXXWL HT$PbXB\f/= f(vfW L HT$PWbXL HT$PBbXH\$X(t$0(|$ H@_@SH   MH$   L$   )t$pf(IHLHT$@HD$ AR0LK Ht$`LH$   H\$0HD$8IL\$XHH+3HLMM~=f     IHf(HI;fYDf(Lf\f)L|HT$0HL$PhlHL$@Ń (t$pHĀ   [H\$UVWH0Hq HH9qv H_H;_ vq H9_wH;_ v_ H/H9wwH;w vJ HtH;/t: H;tsDL$PHW 3D$(D$PLHΈD$ ёHw HH;t?Ld$XHXE3HHtxK HKL#LcLcdK H0HCH;uLd$XHo H\$`H0_^]H\$
 LH   Ip     ffff     MIEMiN  IIH+HHHHiL+HEAHHi  HHH+HHHHiH+AHA;sD+
D+AfAIH*AYBf/pH\$HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HHHSPH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKPHHf(X$   HH$   H#H      H;vH# (f($  \f/   vƃ   \$   H$   H$  HHf/5 vH$   X  f(iH H$  X  H;t/HVHOU0L^(L_(HVHO@0HV0HO030L$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;tpHHtH;tQ̄tGH;]t!HM > HtHJHE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$   ~ HuHtHH;tHHtH;t̄t~H$  H;stHn~ Ht
HIHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHH$      I  HY(HSIH$   H$   H{  5 fW$   H$  H[H$   fW$   HHLH$   H$   HHt$H;tY̄tO̄tEH$   HHH+HLM3HM~*(jz ff     fA)HI;}
L$   LH$   H$   _F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   -| H$   | 2i  HSH$   NH&z  fW$   H$  HXH$   $   A   LHHL$pHt.HH;t̄t̄tH;\$xt$HL$pt{ HtHFHD$pH|$pH\$xHHH+HLMHM~(~x HD$pf)HI;|LHT$pH$   H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$ptz H$   ez H$  Wz H$   Iz H$   :z H$   +z 2v  H$   H$   f($   H$   H$  H$   f/vH$   Hϑ4\A f(H$  Hhf/vH$   H虑H$   H$   HD$pH$   A   HT$xLH$   豥H\$xHtHH;t-HHtH;t̄tH;$   t-H$   x HtHNDH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   `H$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   x HL$pw H$   w H$  w H$   w H$   w H$   w L$  I[8A(sA({E(CE(KI_^]@SH H      Hf.h H   zt9Hx
D Y \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HXHS`H$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HK`HHf(X$   HH$   H#H      H;vHCt (f($  \f/   vƃ   \$   H$   H$  Hhf/5ԁ vH$   X  f(= H$  X  H;t/HVHOu%L^(L_(HVHO`%HV0HO0S%L$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;tHHtH;tq̄tgH;]t!HM ^t HtH?HE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$   s HuHtHH;t
HHtH;t
̄t
H$  H;stHs Ht
H>HH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHH6H$      I  HY(Hs>H$   H$   Hq  5 fW$   H$  H[H$   fW$   H>LH$   H$   HHt$H;ty̄to̄teH$   HHH+HLM3HM~*(o ff     fA)HI;}
L$   LH$   H$   F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   Mq H$   >q 2i  HSH$   nHFo  fW$   H$  HXH$   $   A   LHHL$p2Ht.HH;t
̄t
̄t
H;\$xt$HL$pp HtH;HD$pH|$pH\$xHHH+HLMHM~(m HD$pf)HI;|LHT$pH$   H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$po H$   o H$  wo H$   io H$   Zo H$   Ko 2v  H$   H$   f($   H$   H$  H$   f/vH$   H4\6 f(H$  Hxf/vH$   H蹆H$   H$   HD$pH$   A   HT$xLH$   њH\$xHtHH;tMHHtH;t.̄t$H;$   t-H$   n HtHn9H$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   UH$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   %m HL$pm H$   
m H$  l H$   l H$   l H$   l L$  I[8A(sA({E(CE(KI_^]@SH H      Hf.x H   zt9H
dx Y, \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  H`HShH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKhHHf(X$   HH$   H#H      H;vHci (f($  \f/   vƃ   \$   H$   H$  Hf/5v vH$   Xv  f(2 H$  X  H;t/HVHOL^(L_(HVHOHV0HO0sL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;tHHtH;t̄tH;]t!HM ~i HtH4HE H} H]HHH+HLMHM~fHf(HE f)HI;|LHH(H$   i HuHtHH;tHHtH;t̄tH$  H;stHh Ht
H	4HH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHVH$      I  HY(H3H$   H$   H<f  5} fW$   H$  H[H$   fW$   H:3LH$   H$   HHt$H;t̄t̄tH$   HHH+HLM3HM~*(d ff     fA)HI;}
L$   LH$   H$   F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   mf H$   ^f 2i  HSH$   Hfd  fW$   H$  HXH$   $   A   LHHL$pRHt.HH;t̄t̄tH;\$xt$HL$pe HtH1HD$pH|$pH\$xHHH+HLMHM~(b HD$pf)HI;|LHT$pH$   H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$pd H$   d H$  d H$   d H$   zd H$   kd 2v  H$   H$   f($   H$   H$  H$   f/vH$   H|4\+ f(H$  H/f/vH$   H{H$   H$   HD$pH$   A   HT$xLH$   H\$xHtHH;tmHHtH;tN̄tDH;$   t-H$   3c HtH.H$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   JH$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   Eb HL$p9b H$   *b H$  b H$   b H$   a H$   a L$  I[8A(sA({E(CE(KI_^]HHHWATAUAVAWH   HǄ$   HXHhHp )pMLHٹ   * Ht
HL$ H3HD$ HD$8    HD$@    HD$H    IVHL$ ۟E3M9nt  E3HL$@H\$8II,Hu3HT$HH+HHH+HH;sHE HHHL$@H\$8  HH;v` HL$@H\$8Ht$ H$   H$   HH+Hu3$H;v` HtH;t$ to` H+H($   f$   LA   H$   HL$ H\$8HHL$@H;v$` HL$@H\$8Ht$ Hu
` E3HL$@H\$8HD$ LHT I;S wHtH3H;Ps_ HL$@H\$8AIIcI;FH$      P( Ht
HL$PH3HD$PHD$h    HD$p    HD$x    MLD$PHT$ Hyf(HL$hHt' HD$h    HD$p    HD$x    HL$P' HL$8Ht' HD$8    HD$@    HD$H    HL$ y' f(L$   I[8Ik@IsHA(sIA_A^A]A\_LVWATHPHD$@I[IkIHLI@ I+@HLJ L+JIICHD ICH ISL2 H
 6L II0L L; r0   H
l 觮HHt$pHt^H_ H+_HHE H+EHHu] HmHG H+GHHu] 3HD$(HD$ LLHWH3I$IH\$xH$   HPA\_^HATAUAVH   HD$ HXHhHpHx )p)xD)@IMHLHH%zHW H+WHfWH3HG H+GHHM  $   fD(DYr L$   fD  HD$HHL$@H+HH;r\ HL$@f(XMMHT$(Invf(HG H+GHH;r\ HwHD$HHL$@H+HH;rs\ HL$@\MMHT$(I
v\A^HE H+EHH;r-\ HE4HG H+GHH;r
\ HwHD$HHL$@H+HH;r[ HL$@HHHHG H+GHH;HL$@HtE$ HD$@    HD$H    HD$P    HL$( $ L$   I[ Ik(Is0I{8A(s(|$pE(CIA^A]A\H\$Hl$Ht$H|$ ATH   Hj3MHHH   HtHS3HC HHtH3HHL$PLD$HHHBHt$8HAHBHAHBHVHAHHD$pHHHT$(HT$@HL$ HT$ I襜HH;nL$   I[IkIs I{(IA\HHHVWATAUAVH`HD$ HXHh HHE3DhLB L+BI*IIHHH?H$Ǆ$      IHM H+MIHHHH?H   IH;rY HEHHL$(mLHN H+NIHHHH?HH;rY HFHI)HL$@Ht" Ll$@Ll$HLl$PHL$(! HH0HM H+MIHHHH?HH;THHL\$`I[@IkHIA^A]A\_^HL$ATAUAVH@HD$0H\$hHt$pH|$xMHH3HAHA HA(HtaHUUUUUUUH;vHHHCHC L$MJHK(3D$(D$`D$ LKMHHxJHC H\$hHt$pH|$xH@A^A]A\H\$Hl$WH HZHHHHtH;tHtH;t̄tHt$03H;_tHW Ht
HF#HH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHHHUHOHt$0H\$8Hl$@HH _H\$D$WHp)t$`)|$PD)D$@fEWIHfD/f(D)L$0D
-c fA(;   f.zuV  !   HRU     f/   f(LHfWl `f(f(cYf(fT
\ fD/vqY
l l f/v[fA.zu3(H       $      H$   EV  "   HS fnY %  5K ^fA.zu
fA(  f(Ff(  fD/v ^AXfD/w$   f(D)T$  f.z3u1 f/v#H$   HҜH
n Y<  k f/v= f/v5U  "   HR 8D^D\
fk AY4  H$   $   Dj fD(DX
^ YE\fA( 
k Yf/   AYf/v
fA.zZuX3|AYfA(\5 f( f(fA( j f(^^Yf/v{fA.zu3(H       $      H$   ET fn "   HQ Y -A\fA(f(* f(fA(
 ^Yf(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_H\$D$WH`)t$P)|$@D)D$0D_ IHf(fA(D)L$ fEWfD/    f.zuH
f LD$pH ] f/   f(LHfWi cf(f(Yf(fT
6Y fD/v*Y
i h f/vH
 H
 5 ^fA.zu
fA(  f(Bf(  fD/v#fffff     ^AXfD/wt$pf( f.z0u. f/v HL$pH螙H
gk Y<7  Kh f/v:] f/vH
  H D^D\5h AY   HL$pt$psD
g fD(DX[ YE\fA( 
g Yf/vzAYf/vH
 H	 9AYfA(\5 f( f(fA(q wg f(^^Yf/v9H
B H	 A\fA(f(> f(fA( ^Yf(H\$x(t$P(|$@D(D$0D(L$ H`_HHXHpWHp)p5\ )xHHp     H   D)@D)HD)PDf D@ D
o HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\ f(AY^=2 ff     HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\J f(YAYAYf/X=p (t$`L\$pE(CE(KE(Sf(I[Is(|$PI_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tMt5HHIL;t|MtHHIL;t_IHI/LK3LKIHH+HLMM~ (wK     HHI;f)D|HL$ HLD$XH-Z l$XHH\$PH@_HHHVWATAUAVH  HǄ$   HXHhIILL   @ E3Ht
HL$@HIHD$@Lt$XLt$`Lt$hLNHD$pLt$x(D$pf$   L$   H$   HL$@AHT$XHuIHL$hH+HH\$`HH+HH;sHF HHCHD$`FH;vL HD$@HD$pH\$x(D$pf$   LN L$   H$   HL$@HE HT$@HPLt$pLt$x   DBH$   J LFH$   HD$0D$(D$ LL$pIH$   	H$   H$   J Hx H$   -K t3H$   H$   SJ IMLHAH$   J E3Lt$xMj  Hl$pHL$`H\$XfD  Hu3HT$hH+HHH+HH;sHE HHHL$`H\$X  HH;vtK HL$`H\$XHt$@H$   H$   HH+Hu3$H;v8K HtH;t$@t&K H+H($   f$   LA   H$   HL$@H\$XLHL$`H;vJ HL$`H\$XHt$@HuJ E3HL$`H\$XHD$@LII;S wHtH3H;PsJ HL$`H\$XAHIcI;H$   H	HHT$@PH$   H HL$pBJ HL$XHt E3Lt$XLt$`Lt$hHL$@ L$  I[8Ik@IA^A]A\_^H\$Hl$Ht$WH@HH   H)t$0)|$ o4   =, fH*Y5 fff        H3HDfI*Xf(YH5rҺ   HH\$Pn(|$ Hl$XfH*HX(t$0Y^ Ht$`H@_H\$Hl$H|$ ATH H*HLH]HHtH;tHtH;t̄tHt$03H;_tHH Ht
HHH7HH_HH+HLMM~'fff     HE HHI;f(Df)D|LHHFIT$HO記Ht$0H\$8Hl$@HH|$HH A\H(] f(f(YYf(\f/\ vY] H(D
 k f(f(H(H\$Hl$Ht$H|$ ATHpHj3MHHH   HtHS3HCHHtH3HBBHVHHD$XHL$hD$`HHHT$(HT$@HL$ LD$HHT$ IHt$87HH;|L\$pI[IkIs I{(IA\H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tyMt5HHIL;t\MtHHIL;t?IHILK3LKIHH+HLMM~ (WC     HHI;f)D|HL$ HaLD$XH-Q l$XHcH\$PH@_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tYMt5HHIL;t<MtHHIL;tIHILK3LKIHH+HLMM~ (7B     HHI;f)D|HL$ HALD$XH-P l$XHH\$PH@_HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;t<H;t!HI4D HtHHEH]HHuHHH+HLMM~(AA HEHI;f)D|HUHL$ LLLE LM(t$8LD$(LL$0MtWMtRIHIL;tMt5IHIL;tvMtIHIL;tYIHMI(LM(LM IHH+HLMM~(r@ fHEHI;f)D|HUHL$ H\$`Hl$h(t$@Ht$pH|$xHPA\HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;t|H;t!HItB HtH
HEH]HHuHHH+HLMM~(? HEHI;f)D|HUHL$ LHu t$8Ht$(HtI;tH;t!HMA HtH<
HEH]HHu HH+HLMM~(> HEHI;f)D|HUHL$ LH\$`Hl$h(t$@Ht$pH|$xHPA\HWATAUH   HD$`HXHhHp LLX*M HPHiHhHu3HuL9HH;vH    H@ LHuHtLD$ Ht$(H]HHtH;tHtH;t̄tvH;t(Io@ HtHLHD$ LH|$ H\$(HHH+HHHLH~4ff     HM IE fB(fB\fC)IL;}LD$ LLHT$ HL$@A$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMM~3ffD  HD$ f(HE f^fXf)HI;|HT$0HL$@,=Ll$HHl$PHD$ HD$pHT$xHL$@HHHAHBHAHBHAHBID$HD$0H$   HD$8HT$hHL$0HL$ > L$   I[(Ik0Is8IA]A\_@WHPJ )t$@1Hf/   H\$`HY Hl$h\t$0HiHHl$(HtH;tmHtH;tX̄tNHt$p3H;ZtH
?> Ht
H	HH7HH_HH+HLMM~,fHE HI;f(DHf^f)D|HL$ LH@Ht$pH\$`Hl$h(t$@HP_HL$VWATHPHD$ H\$xH$   HcLгHh I$H3HuH6HH;vQH4    HO= HuHt0ID$@Il$HHl$0(I D$@Ht.HH;t̄t̄tH;t$IL$@< HtH2ID$@I\$@Il$HHHH+HLMM~(D: @ ID$@f)HI;|LIT$@HL$(IH\$xH$   HPA\_^HATHP  HD$HHXHhHpHx LHH^ HL$ ; I$HT$ IHL$ ;    DƍVHL$P: HE@HL$`F: H9uH~:~D  H]@H HL$` H: HHcH;EH|HT$ HL$P9 M$HIAHL$ t: HL$P9 L$P  I[IkIs I{(IA\H\$WH HH 
HO  H\$0LC LH _HWATAUAVAWH   HD$ HXHhHpHHHIHB H+BHH;tZH HL$(9 HL$P: H@ HD$PHT$(HL$h9 H
A HD$PH HL$P HGH9GuZH] HL$('9 HL$Pk: H{@ HD$PHT$(HL$h&9 H@ HD$PH
 HL$P 3H   HI*    HE H+EHH;r9 LuHO@H+O8IHHHH?HH;r9 Lg8LoJD& J+D&HL;rm9 JL&IJHH0H;_rHGL$   I[0Ik8Is@IA_A^A]A\_H\$Ht$WH HH HN  LA L@tHn H\$0HHt$8H _H\$Ht$WH H HH  H@4H   H  Ht H  3H  H  H    Hx  Ht  H`  Hx  H  H    H@  8 H  
H    H   Htx  H   H   H   H  W  H   HtF  H   H   H   H   %  H   Ht  HOxH   H   H    HO`Ht HOHHw`HwhHwp LP LHO(Ht HOHw(Hw0Hw8H\$0Ht$8H _ H\$WH H,tHk HH\$0H _HL$WH0HD$ H\$HHHٹ   X HtH3HHbHC0ƀ   HC0H@HC0H HC0H@HC8    HHLHH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MC訫HHͪHH\$`HP_HL$WH0HD$ H\$HHHٹ   H HtH3HHaHC0ƀ   HC0H@HC0H HC0H@HC8    HHlHH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MC蘪HHHH\$`HP_Hl$ VWATHPHy8 IMHHuLL$ LI0A?	  HA0H\$pHI HtH;t[4 IT$H;u2HH3 <  ML$AHHHl$ =  I$H_0HtH;t4 IT$H;u=HG0HHHH2   LO0E3HMIHHl$   HHs2 tzI$HL$0HID$HAHL$0H\$8HHK>2 tEHC    tLE3HHHl$ p  ML$AHHHl$ S  IL$HH1   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?u2 H\$8    t2 WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0tb2 L$   I;Lt$xtHSH1 t?ML$IA    tE3HHHl$ 6LAHHHl$ HT$0LHPHHH@HFH\$pHH$   HPA\_^Hl$ VWATHPHy8 IMHHuLL$ LI0Ao
  HA0H\$pHI HtH;tk1 IT$H;u2HH0 <  ML$AHHHl$ 
=  I$H_0HtH;t1 IT$H;u=HG0HHHH/   LO0E3HMIHHl$ 	  HH/ tzI$HL$0HID$HAHL$0 H\$8HHKN/ tEHC    tLE3HHHl$ G	p  ML$AHHHl$ *	S  IL$HH.   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?u/ H\$8    t/ WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0tr/ L$   I;Lt$xtHSH. t?ML$IA    tE3HHHl$ 
6LAHHHl$ HT$0LH耨HHH@HFH\$pHH$   HPA\_^LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;s
L2I;l  HHH+H;sIHI;IBHIL$HHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   HMD$0   3D$($   D$ ML$LIVIL$D$0   HD$8HL@IL3D$($   D$ ML$IT$ INML$IL$ I+IHHHH?HHMtMD$ II藶IL$I H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PEHvHINL3D$($   D$ ML$IT$ MT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHI(LI\$ I|$ H+I^H;tHT$PHH0H;uHL$hHt7 Ll$hLl$pLl$xHL$P    IHL$P`I|$ H4vHHH+3ML$D$($   D$ LHHID$ LHINs   I^H<3H;tfD  HT$PHH0H;uHL$hHt Ll$hLl$pLl$xHL$Pn HĀ   A_A^A]A\_^[H\$Ht$WH0DL$@3ID$(D$@HD$ H~H+H\$HH*HHHH?HHRHH+HHt$PH0_Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?LuZHH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ MR8LG HHSHN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ 7LG HV 3LOHˈD$(D$@D$ ľHG HMtMIH腲HO8 HN IH+NHHHHH?HStLOLF HVH7HG HmHHt$XH0_@SH HAx   Hf.K4 H   zt9Hho
'4 Y= \Y   XY      H [HL$WH0HD$ H\$HHt$PIHHH HHRHS HFXH^hHFH HF`H~pH~xH 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH H'8 HHA`HIH' HO8
' HO  ' HO& L2 LtHc HH\$0H _H\$Hl$Ht$ WH`)t$P)|$@f( IIH   f/D)D$0   f(g f.zu)&  !   H$    f(fWf(; f/fWvfW;  E3LHfD(f(;D\f( D\C  ; f/vwfWf.z^+ 
ͩ f(fTf/v fD(fDWT; "1 ^\; fTs fD(f/      [ f/v7f(f(LD$(LL$pHT$ \; \
91 f(pfD(yf/=: r#wN f/vf( fD(LHL$p|$p< 5: fD(f(Xv. \ \\0 YDXHtfA((t$P(|$@L\$`I[Ik Is(E(CI_@SH HD$0    HH [HLH L@HPHHSVWATAUAVAWH0  HǄ$   )pE3Dd$0H$! 0H HHH H; rAT$H
 ItHHL$0Htf(wHID$0L$  Ic?   > Ht
HL$hHIHD$hL$  L$  HHL$hjHz  0IH$   HH$   H+HH;sVHջ HHHǻ H; r   H
B }sHH$  Htf(vIHHI H+HH;sHHH$   H$   H$  Hc8   F Ht
HL$8HIHD$8L$  L$  HHL$8rH 0I HD$XH|$PH+HH;sVH HHHպ H;ƺ r   H
P rHH$  Htf(uIHHI̐HD$XH+HH;sHHH|$P   L$  5l7 A;75  D$0T   HcH$   L$   I+H   C;}zLoL;rb! L$   A   L HH$  =HA   L HI"fWLH$  ZH KH|$PK   DBH$    HG H$0     H H$   H$    L$   H$   LC$   H1 HD$ DǋH
T O=A        L$  E;,$k  D$0W   IcL$  I\$ I+\$H  C;  LvL;r
  H|$PM|$H\$XH+H   C;   LfL;r H|$PA   L HH$  ~LD$hHH$  LH$  H$   bvHA   L& HH$  ~L$  HH$   LH$x  H$   vCHH$   }LHH$   uH JAH|$P   DBH$    HE H$0     H H$   H$    L$   H$   LC$   H; HD$ DƋH
R M;   DBH$    HME H$0     H
 H$   H$   l L$   H$  LC$   Hf HD$ DƋH
aR :D$0Z   HT$8H$p  HHL$PHtB 3H|$PH|$XH|$`HL$8' H$   Ht H$   H$   H$   HL$h H($   H0  A_A^A]A\_^[HLH L@HPHHSVWATAUAVAWH@  HǄ$   )pMME3Dl$@H 0H HHH H;~ rAUH
	 DmHHL$@Htf(~pHID$@L$  Ic<$   8 Ht
HL$xHIHD$xL$  L$  HHL$xdHt 0ID  H$   HH$   H+HH;sVHʴ HHH H; r   H
7 rlHH$  Htf(oIHHI     H+HH;sHHH$   H$   L$  Ic}    5 Ht
HL$HH3HD$HHǄ$      L$  HHL$H^Hn 03HL$hHH|$`H+HH;sUHг HHH³ H; r   H
= xkHH$  Htf(n3HH3H+HH;sHHHL$hH|$`D$@<   H$  HD$0Ld$(H$  HD$ MMH$  H$   OHHL$xH$   Ht 3H$   H$   H$   H$       L$  L$  5& A;u   D$@>   HcH\$hLd$`I+Ho  C;d  LoL;r Ld$`A   L HIxLD$xHH$  ϺLH$  H$   WpHA   L[ HH$  WwLH$  CuHA   L+ HIxxL$  HH$   PLH$  H$   oHH$(  XyLHH$   vHH$  5zLf(H$  qHA   L HIvLH$   bsH KL$  b   DBH$0   HM? H$@     H
 H$   H$0  l L$   H$   LC$   H HD$ DǋH
aL 4D$@A   HT$HH$  HHL$`HtB 3H|$`H|$hH|$pHL$H' H$   Ht H$   H$   H$   HL$x H($0  H@  A_A^A]A\_^[@SH0; LD$H3)t$ H5& fTf/
- vHs H
ҕ 腮d LD$H3pfTf/, vHs H
 OH(t$ H0[HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;vK HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@H1   L;   H;v HHD$@H\$HHnH;n v HH\$0Hl$8(D$0fD$0Hu E3LKdHHI;k wHtH3H;hsw Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PHuHOHt HG    HG     HG(    HL\$`I[ Ik(IA\_^ @WH HAHLHHL@MtDHMtHHIL;t轮MtHHIL;t蠮IHOH\$0IjHWHH\$0HGH _HHXHhHp @WH`)p)xf(S IIH   f/D)@   f( f.zuH
 LD$pH f(wfWf() f/fWvfWH)  E3LHfD(f(<D\f( D\\  t) f/   fWf.zuH
G LD$pH >U 
U f(fTf/v( fD(fDW( "" ^\) fT fD(f/      >I f/v7f(f(LD$(LL$pHT$ \( \
 f(fD(yf/=Q( r#; f/vf(蠾y fD(LHL$p|$pĮ] 5( fD(f(X \; \\A YDXHt(t$P(|$@L\$`fA(I[Ik Is(E(CI_HSH@  HD$0)p)xD)@IfD(f(f(fWf.zuf( YR*   f.z  f.
 z5u3f(fW9' dFf(f(WFYY5' f(j  f/
J' rfT=P f('FJ  f(yHo
DJ8
 J8
 ȃ   H HLf(f(%   H$P  HD$(H\$ fA(f(f(Z   L$P  fA(f(f(Md   f(f(軗   L$P  f(f(   f(f([uH HL$x; HL$8 H HD$8HT$xHL$P: HT$8H$   H
ל HHPH
, HHX@`B  H	L$@  A(sA({E(CI[û    * D HT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$PtE HL$HH+L$XI*IHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHUUUUUUUHH+I;s记N"I;b  HHH+H;s3HI;IBHHNHH$   H$   3D$($   D$ LNLH$   HRHN&LH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$HѣLH$   3D$($   D$ LNHV H$   HH&LF LNII+H*HHHH?HLMtIH>HN H[HHHF(KdHHHF H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$HH^ I}H;t  H0H;tHH<H0H;uO$dIH^ I<H;tH0H;tHH
H0H;uHF II}H;tH0H;tHHH0H;uLf H`A_A^A]A\_^[@UATAUAVAWH   Hl$@HE H   H   H   )u@HLqxAY0LBHL;vH>IHupJ    H=   w2J   HHH;wIHH H+H|$@HH.J    H HHuHtiHHFE3ML96LDLeHEHH=   @@uIM8H;v%MM0MufH    H=   w2H   HHH;wIHH H+LL$@II$H    H
 LHuHt趤IE8I}0 MDLu HE(HH=   È]0t$0H|$(HD$    ME IU IMt
Ie
 @t	IV
 H   H   H   (u@HePA_A^A]A\]H\$UVWHpHHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@HHHpH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CY{H;}%HT$ fHHH;HfXDf)D|HL$ LLH{H$   HHp_^]H\$UVWHPHBB(HHL$(HHBHAHBHAHHHxD$HH|$ptH#HHD$pHT$xHكH;HL$xHMHHHL$ LH+E3HH+HHH,CYH;}PD$HHT$(ffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLHH$   HHP_^]H\$UVWH`HBB0J8HHL$0HHBHAHB HAHHHxD$PL$XH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CBH;}]D$PHT$0D$Xff@ fHf(HH;HfYfYf(Lf\f)L|HL$ LLHH$   HH`_^]@UH`Hl$PHBH] Hu(H}0Le8L)u A0HHH;v^H
HuLH    H      H   HHH;w
HHH H+HL$PHHHFML$@M$t$@IT$3HD$8   H9>HL$0HD$(   HDIL$HH=   ID$HHD$ @t	H H] Hu(H}0(u Le8He]H HHkHbfHL$SH0HD$ H5}HH0[ HHHUVWATAUH`HD$ HX)pLHcHXfWpHqHp3uH6HH;vӞH,    H HuHt貞HH^IHt$I;t茞̄t肞̄txH^HHH+HLMHM~(  Hf)HI;|LHHL$(诠H\$0H\$8t$@It$H$   HHLLHH/HtWHtIHHH;tםHtIHHH;t躝HtIHHH;t蝝LLHHkLNLNIHH+HLMM~(  D  Hf)HI;|HHL$(I詾IH$   (t$PH`A]A\_^]@SHP )t$@1Hf/   LA LI(H|$`\t$0HyHH|$(MtMtHHIL;t衜Mt:MtHHIL;tMtHHIL;tbIHI2LK3LKIHH+HLMM~0fD  HHI;f(DHf^f)D|HL$ HH|$`(t$@HP[HHHVWATAUAVH`HD$ HXHh )pLHcHxfWpHqHp3IuH,I;v~H,    H| HuHt]HH~IHt$I;t7̄t-̄t#H~HHH+HLMHM~&(N ffffff     Hf)HI;|LHHL$(OH|$0t$@It$H$   HuH,I;v袚H,    H  HuHt聚HH~Ht$I;tēt[̄tQH~HHH+HLMM~( Hf)HI;|LHHL$(莜I5IL\$`I[8IkH(t$PIA^A]A\_^HL$WHPHD$ H\$hHt$xHH HL$( HHD$pH HHNH E3D^0D^4D^8D^<D^@D^HFDHr H* HHNPHH\$hHt$xHP_@SH A H HHH HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HL$WHPHD$ H\$hHt$xHH HL$(l HHD$pH HHNHu E3D^0D^4D^8D^<D^@D^HFDHB HZ HHNP<HH\$hHt$xHP_@SH A H? HHHR HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HL$WH0HD$ H\$PHH   Ht 3H   H  H  H    H   Ht H   H   H   H    H   Htz H   H   H   H   Y H_HH\$HHtH? H_H\$HHtH$ HX HH\$PH0_HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;vH4    H HHuHtHL$@Ll$HLt$PHsHkIHtHtIHHH;t豕Ht:HtIHHH;t菕HtIHHH;trLLMM;t%c MtIHHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;tI
IHt:HtIHHH;tǔHtIHHH;t誔LLM;t% MtIHHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;tEMt:HtIHHL;t#HtIHHL;tIHI;t% HtHVHHD$@HHL$@Ld$HHt$PHHH+HLMHM~Hf(fYf)HI;|LHT$@HL$(dIwHLHD$(Ht$0I_HtI;tRHtI;t=̄t3H;t(I, HtHLHD$(LH|$(H\$0IwHtI;tHtI;tӒ̄tɒH;t(I HtHLHD$(LH|$(Ht$0I_HtI;t~HtI;tīt_H;t(IX HtHLHD$(LH|$(H\$0HHH+HLMM~!fD  If(fYfA)HI;|LHT$(HL$XLD$@HT$(H$   H蘸HL$( HL$@ HH$   HpA_A^A]A\_^]HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;v(H4    H& HHuHtHL$@Ll$HLt$PHsHkIHtHtIHHH;tHt:HtIHHH;t蟐HtIHHH;t肐LLMM;t%s MtIHHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;tI
IHt:HtIHHH;t׏HtIHHH;t躏LLM;t% MtI
HHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;tUMt:HtIHHL;t3HtIHHL;tIHI;t% HtHfHHD$@HHL$@Ld$HHt$PHHH+HLMHM~HfQf)HI;|LHT$@HL$(HIwHLHD$(Ht$0I_HtI;tfHtI;tQ̄tGH;t(I@ HtH蛿LHD$(LH|$(H\$0IwHtI;tHtI;t̄tݍH;t(I HtH1LHD$(LH|$(Ht$0I_HtI;t蒍HtI;t}̄tsH;t(Il HtHǾLHD$(LH|$(H\$0HHH+HLMM~!ff     IfQfA)HI;|LHT$(HL$XLD$@HT$(H$   H謳HL$( HL$@ HH$   HpA_A^A]A\_^]HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;vCH,    HA LHuHtLD$@Ht$HHkIHtI;tHtI;t݋̄tӋH;t(I HtH'LHD$@LH|$@Hl$HHsHtI;t舋HtI;ts̄tiH;t(Ib HtH轼LHD$@LH|$@Ht$HHkHtI;tHtI;t	̄tH;t(I HtHSLHD$@LH|$@Hl$HHHH+HHHHH~ Hf(fYfA)HH;|LLHT$@HL$(`It$HLHD$(Ht$0I\$HtI;tLHtI;t7̄t-H;t(I& HtH聻LHD$(LH|$(H\$0It$HtI;tHtI;t̉̄tH;t(I HtHLHD$(LH|$(Ht$0I\$HtI;tvHtI;tātWH;t(IP HtH諺LHD$(LH|$(H\$0HHH+HLMM~I$f(fYfA)HI;|LHT$(HL$PLD$@HT$(I-HL$( HL$@ IL\$pI[8Ik@IA^A]A\_^HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;v3H,    H1 LHuHtLD$@Ht$HHkIHtI;tHtI;t͇̄tÇH;t(I HtHLHD$@LH|$@Hl$HHsHtI;txHtI;tc̄tYH;t(IR HtH譸LHD$@LH|$@Ht$HHkHtI;tHtI;t̄tH;t(I HtHCLHD$@LH|$@Hl$HHHH+HHHHH~ HfQfA)HH;|LLHT$@HL$($It$HַLHD$(Ht$0I\$HtI;t@HtI;t+̄t!H;t(I HtHuLHD$(LH|$(H\$0It$HtI;tՅHtI;t̄t超H;t(I HtH
LHD$(LH|$(Ht$0I\$HtI;tjHtI;tŪtKH;t(ID HtH蟶LHD$(LH|$(H\$0HHH+HLMM~fI$fQfA)HI;|LHT$(HL$PLD$@HT$(I#HL$( HL$@ IL\$pI[8Ik@IA^A]A\_^H\$Ht$WH HH   Ht H   3H   H   H   Ʋ HOpѼHOp贲 H	 H_PHO8Ht蛲 HO Hw8Hw@HwH膲 Ht$8HH\$0H _HL$WH0HD$ H\$PHHHS HHBHAHBHAHBHAH H sHOPHL$HHr HHCXHAHC`HAHChHAHSpH [H   H   &HH\$PH0_LATH   HD$ I[IkIsI{ LHHB H+BHH;AtYHT: IK HL$P H& HD$PHT$(HL$h HQ HD$PH%} HL$P? 3H9yvtfHC@H+C8HH;ry HC8H,ID$ I+D$HH;rX It$H   H+   HH;r6 H   HHHH;{rHKPHH   L$   I[IkIs I{(IA\H`HL$WH0HD$ H\$PHt$XHH  Ht; 3H  H   H(  H    H5m H  H  HO@H_H\$HHKf H3H7H\$PHt$XH0_H\$WH HtH蛯 HH\$0H _HL$WH0HD$ H\$PHHHc} HHHL$HHP HHBHAHH HS@HO@H  H  H  HL$HHa7 HH  HAH  HAH  HAH   H %HH\$PH0_H\$WH0HAHH)t$ Hf(P@HC@HK@f(HP@H  Hf(HP@H  f(HHH\$@(t$ H0_H`@H\$Ht$WH HAHHAHP8HC@HK@DHP8H  DHHP8H  DHHH\$0Ht$8H _H`8H\$Ht$WH HAHHIHP0HC@HK@LHP0H  LHHP0H  LHHH\$0Ht$8H _H`0H\$Hl$Ht$WH HAHHAIHP(HC@HK@DLHP(H  DHLHP(H  DHLHH\$0Hl$8Ht$@H _H`(H\$Hl$Ht$H|$ ATH0HA\$`HHAIL\$ P HG@HO@DLIԉ\$ P H  DHLIԉ\$ P H  HDLIԉ\$ P H\$@Hl$HHt$PH|$XH0A\H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`@SH HAHHPHC@HK@PH  HPH  HH [H`H\$WH HAHHHHC@HK@HH  HHH  HHH\$0H _H HL$WH0HD$ H\$PHH   X H   J H_pH\$HHZH諪 H_0H\$HHYH萪 HOH\$PH0_H% HL$WH0HD$ H\$HHH@  H   Ht3 3H   H(  H0  H   H  Ht H  H  H   H  ݩ H  H  ĩ Hx  [H@  辳H@  螩 H  5H  8HH\$HH0_eHL$SH0HD$ Hٹ   p HtH3HH)HC0ƀ   HC0H@HC0H HC0H@HC8    HH0[HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKH tH[HH    tH|$(I4$Ht$ Ml$0HtH;t 3I;tHWH   (D$ f$      c Ht
HL$0HHHD$0H\$HH\$PH\$X   3 Ht
HL$`HHHD$`H\$xH$   H$   HH$   ^ H$   H$p  HT$0H$   HT$`H$   L$   L$   H$0  I?HT$ HH
H@HBH$  HtV H$  H$   H$(  H$   1 H$   Ht H$   H$   H$   H$    H$   p HL$xHtܦ H\$xH$   H$   HL$`车 HL$HHt讦 H\$HH\$PH\$XHL$0蕦 H|$(Ht$ Hu HH;{0u HG@HG@L$P  I[(Ik0Is8IA]A\_HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKH# tH[HH    tH|$(I4$Ht$ Ml$0HtH;t' 3I;tHWH   (D$ f$      裥 Ht
HL$0HHHD$0H\$HH\$PH\$X   s Ht
HL$`HHHD$`H\$xH$   H$   HH$    H$   H$p  HT$0H$   CZHT$`H$   0L$   L$   H$0  IoHT$ HH
H@HBH$  Ht薤 H$  H$   H$(  H$   q H$   Ht_ H$   H$   H$   H$   : H$    HL$xHt H\$xH$   H$   HL$` HL$HHt H\$HH\$PH\$XHL$0գ H|$(Ht$ Hu4 HH;{0u# HG@HG@L$P  I[(Ik0Is8IA]A\_H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;v HM HtH;tr HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   ZHkH;k v HHl$(H\$ (D$ fD$ Hu LLH<HHI;{ wHtH3H;~s H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\@WATAUAVAWH@HD$0H\$pH$   HHHUUUUUUUH;vB{HAHu3I*%HI(H+I*IHHHH?HH;   HHK HHD$xLk L9kv LcL;c v 3D$(D$xD$ LKLIILC LKII+IHLIIH?LMtIHAbHK HHHHC(KdHHHC HsH\$pH$   H@A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;s]yL2I;l  HHH+H;sIHI;IBHIL$5HHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   HQD$0   3D$($   D$ ML$LIVIL$D$0   HD$8HL@IL3D$($   D$ ML$IT$ INML$IL$ I+IHHHH?HHMtMD$ II_IL$虞 H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PHvHINL3D$($   D$ ML$IT$ MT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHIȐI\$ I|$ H+I^H;tHT$PHvH0H;uHL$hHt臝 Ll$hLl$pLl$xHL$Pn    IHL$PI|$ H4vHHH+3ML$D$($   D$ LHHID$ LHINéI^H<3H;tfD  HT$PHvH0H;uHL$hHtל Ll$hLl$pLl$xHL$P辜 HĀ   A_A^A]A\_^[HL$WH0HD$ H\$PHHYHH\$HHKHg H_H\$@HKHH\$PH0_B H\$WH HHBHAH0 HS0HO0;HSpHOp>L   H   L      H       D   D      H         H       D  H   H   A   D  藛 H\$0HH _@WH HA HLHHAL@MtDHMtHHIL;t|lMtHHIL;t_lIHO(H\$8I)LL$0LD$0HW(HvH\$8HG(H _HHPHHWATAUAVAWH  HǄ$  HXHp )pIILH 0Hj HHHtj H;ej r   H
i *"HHPj H$   Htf(Z%HD$p3H,j 3H|$pHHHj H;j r   H
i !HH$   HtfWf($LHD$hLH|$hfWL$      趙 Ht
H$   HHH$   H$  H$  H$  H$P  H$X  H$`  H$h  HT$xH$P  蟍L\$xL$  HT$xH$P  耍L\$xL$P      Ht
H$   HHH$   H$8  H$@  H$H  Mc$   IH$   M  \$`ffffff     H$   H$P  H$8  HuHH$H  H+HL$@  IH+HH;s73D$(\$ L$0  L$   PI.M\$L$@     MI;vn L$@  H$8  H$   LH$   L$   IH+HuL*I;v% H$   MtL;t
 L+I($   f$   L$   A   H$   H$   bL$8  L;$@  v H$   Hu LLKI;K wHtHHH;Hs| IrL$  Ll$hHT$hH$P  SHH\$xHt  fW f.z   Hf HH(Hf H;f r(   H
Bf }HH$   Ht'KAXMH!LnH^ H;= HHH$   HT$xH$   /Hf(HL$x(%H\$xH\$x   4 Ht
H$   HHH$   H$   H$   H$   Mc|$DIH$   :~M  \$`ffff     HT$hH$P  H$   HuHH$   H+HL$   IH+HH;s43D$(\$ L$   LD$hPITM\$L$      MI;v L$   H$   H$   LH$   L$   IH+HuL*I;vK H$   MtL;t3 L+I($   f$   LL$hA   H$   H$   苃L$   L;$   v H$   Hu LLKI;K wHtHHH;Hs I{L$  Iw@Hc   2 Ht
H$X  HHH$X  H|$hLD$hHH$X  [yHH$x  HH$p  H+HHtCLd$p H;r H$p  L$HH$x  HH$p  H+HH;rLd$pHH+HHt:H;r H$p  L$HH$x  H$p  H+HHH;rHc   : Ht
H$  HHH$  H|$hLD$hHH$  cxHH$  HH$  H+HHt9H;r% H$  L$HH$  HH$  H+HH;rHH+HHt9H;r H$  L$HH$  H$  H+HHH;rIc_D   Q Ht
H$  HHH$  H|$hLD$hHH$  zwHH$  HH$  H+HHt@    H;r5 H$  L$HH$  HH$  H+HH;rHH+HHt9H;r H$  L$HH$  H$  H+HHH;rIc_D   a Ht
H$  HHH$  H|$hLD$hHH$  vHH$  HH$  H+HHt@    H;rE H$  L$HH$  HH$  H+HH;rHH+HHt9H;r H$  L$HH$  H$  H+HHH;rAX     ?    I   I  MGHH$   HD$HHt$@I   HD$8HL$0HT$(LD$ L$   L$P  H$  H$   HH$X  H$8  Ht躏 H$8  H$@  H$H  H$   蕏       I>    I   I  MGxMOHH$   HD$PHt$HI   HD$@HL$8HT$0LD$(LL$ L$   L$P  H$  H$   DHH$X  H$8  Ht H$8  H$@  H$H  H$   ǎ A   D  E;wD  t=    IcH$   H$   H+H  F;  LcL;r H$   N<H$  L$  I+H4  F;)  LkL;r L$  H$  H  A   LUB Hm#IHL$h#H K<    H$   H$   H+H,  F;!  LcL;r H$   N<H$  L$  I+H|jF;}cLkL;r L$  H$  H`  A   LA H"IHL$p#H KAL$  O   DBH$   H` H$  裉   H H$P  H$   H$P   H
9 HL$ LDËH
}    DBH$    H H$  #   H H$   H$   H$   x H
7 HL$ LDËH
 `   DBH$   H` H$  裈   H H$   H$   H$    H
8 HL$ LDËH
}    DBH$    H H$  #   H H$P  H$   H$P  x H
6 HL$ LDËH
 `9    A   5w     E;g@U  9    IcH$x  H$p  H+H  F;  LkL;r H$p  JHD$hH$  L$  I+H   F;   LsL;r L$  I  A   L> HH L$  HHL$pbLA   LP> HH L$  HH$   bLf(H$  LHT$hH$   MHH$   H KD AL$     DBH$  " H H$  %   H H$   H$   H$   z H
5 HL$ LDËH
 b   DBH$   Hb H$  襅   H H$P  H$   H$P   H
'5 HL$ LDËH
 A@    H$p  ffff     HcH$x  H+HH;rÿ H$p  H< t
A;_@|      DBH$  Ƚ HX H$  ˄HȲ[Hȋ> HȲ]܂H$   H$   HH$  u H- H$  HH$  , HU H$  裇 A@    H$  f     HcH$  H+HH;rþ H$  H< t
A;_@|      DBH$  ȼ H`W H$  ˃HȲ[Hȋ> HȲ]܁H$   H$   HH$   u H- H$   HH$8  , HT H$   裆 AD    H$  f     HcH$  H+HH;rý H$  H< t
A;_D|      DBH$  Ȼ H8V H$  ˂HȲ[Hȋ> HȲ]܀H$   H$   HH$`  u H- H$`  HH$x  , HS H$`  装 AD    H$  f     HcH$  H+HH;rü H$  H< t
A;_D|      DBH$  Ⱥ HU H$  ˁHȲ[Hȋ> HȲ]H$   H$   HH$  u H- H$  HH$  , HR H$  裄 L3    Ǆ$      |$pL$   LD$pH$  H$   LH$  HuHH$  H+HH$  HH+HH;s83D$(D$`D$ L$   Mƺ   HHCH$     LH;vB H$  H$  H$   LH$   L$   HH+HuL*H;v H$   MtL;t L+I($   f$   MA   H$   H$   ;rH$  H;$  v H$   Hu LLJI;K wHtHHH;HsU 1    D$p   $   LL$pL$   H$P  H$   ZHH$   GX1    |$pMP  LD$pH$   H$   HH$   [G1    i D$h|$pLL$hLD$pHT$xH$   sHH$   G0    |$pM@  LD$pH$   H$   4HH$   F0    I   LL$xL$  H$   yHH$   FH$   H$   FH$   H$  HH$  HtT H$  H$  H$  H$  / H$  Ht H$  H$  H$  H$   H$  Ht H$  H$  H$  H$  迀 H$p  Ht謀 H$p  H$x  H$  H$X  臀 H$   Htt H$   H$   H$   H$   O H$8  Ht< H$8  H$@  H$H  H$    H$  Ht H$  H$  H$  H$    HL$  I[@IsHA(sIA_A^A]A\_HHPHHWATAUAVAWH  HǄ$p  HXHp )pIILH 0HO HHHtO H;eO r   H
N *HHPO H$x  Htf(Z
HD$h3H,O 3H|$hHHHO H;O r   H
N HH$x  HtfWf(	HfWH$x     ~ Ht
H$   HHH$   H$   H$   H$  H$@  H$H  H$P  H$X  HT$xH$@  rL\$xL$@  HT$xH$@  rL\$xL$      &~ Ht
H$  HHH$  H$(  H$0  H$8  Mc$   IH$  )fM  \$`fff     HT$pH$@  qH$(  HuHH$8  H+HL$0  IH+HH;s43D$(\$ L$   LD$pPIDM\$L$0     MI;v L$0  H$(  H$  LH$   L$   IH+HuL*I;v; H$  MtL;t# L+I($   f$   LL$pA   H$   H$  {kL$(  L;$0  vӳ H$  Hu LLKI;K wHtHHH;Hs I{L$  HT$pH$@  qpH HD$xH
 fW f.zt(HT$xH$h  Hf(HL$x
HD$xHD$x   { Ht
H$   HHH$   H$   H$   H$   Mc|$DIH$   cM  \$`HT$pH$@  oH$   HuHH$   H+HL$   IH+HH;s43D$(\$ L$   LD$pPIM\$L$      MI;v3 L$   H$   H$   LH$   L$   IH+HuL*I;v H$   MtL;tұ L+I($   f$   LL$pA   H$   H$   *iL$   L;$   v H$   Huo LLKI;K wHtHHH;HsD I{L$  Mg@Ic$   y Ht
H$H  HHH$H  H|$pLD$pHH$H  ^HH$h  HH$`  H+HHtAHt$hH;r H$`  H4HH$h  HH$`  H+HH;rHt$hHH+HHt:H;re H$`  H4HH$h  H$`  H+HHH;rIc$   x Ht
H$  HHH$  H|$hLD$hHH$  ^HH$  HH$  H+HHt9H;rį H$  H4HH$  HH$  H+HH;rHH+HHt@    H;ru H$  H4HH$  H$  H+HHH;rIc_D   w Ht
H$  HHH$  H|$hLD$hHH$  ]HH$  HH$  H+HHt9H;rԮ H$  H4HH$  HH$  H+HH;rHH+HHt@    H;r H$  H4HH$  H$  H+HHH;rIc_D   v Ht
H$  HHH$  H|$hLD$hHH$  "\HH$   HH$  H+HHt9H;r H$  H4HH$   HH$  H+HH;rHH+HHt@    H;r H$  H4HH$   H$  H+HHH;rAX     $    I   I  MGHH$  HD$HLd$@I   HD$8HL$0HT$(LD$ L$  L$   H$@  H$  誈HH$H  yuH$(  HtRu H$(  H$0  H$8  H$  -u       #    I   I  MGxMOHH$  HD$PLd$HI   HD$@HL$8HT$0LD$(LL$ L$  L$   H$@  H$  ܎HH$H  tH$(  Htt H$(  H$0  H$8  H$  _t A   E;wD  #    IcH$   H$   H+H  F;  LcL;r| H$   N<H$  L$  I+H7  F;,  LkL;r6 L$  H$  H  A   L' H
	IH$h  v	H K="    H$   H$   H+H,  F;!  LcL;r H$   N<H$   L$  I+H|jF;}cLkL;rm L$  H$  H`  A   L%' HAIHL$hH KAL$  L   DBH$  : H H$  =o   H H$@  H$   H$@   H
 HL$ LDËH
 z   DBH$   Hz H$  n   H7 H$  H$   H$   H
[ HL$ LDËH
    DBH$  : H H$  =n   H H$  H$   H$   H
 HL$ LDËH
 z   DBH$   Hz H$  m   H7 H$@  H$   H$@   H
[ HL$ LDËH
 g    A   5 E;g@U  D    IcH$h  H$`  H+H  F;  LkL;r H$`  JHD$hH$  L$  I+H   F;   LsL;rd L$  I  A   L $ HHL$  HH$h  eHLA   L# HHZL$  HHL$p5HLf(H$x  ALHT$hH$   MHH$   H KD AL$     DBH$  ¤ H H$  k   H? H$  H$   H$   H
C HL$ LDËH
    DBH$  B H H$  Ek   H H$@  H$  ! H$@   H
 HL$ LDËH
 A@    H$`  ffff     HcH$h  H+HH;rc H$`  H< t
A;_@|      DBH$  h H(> H$  kjHȲ[hHȋޢ HȲ]|hH$  H$  6 HH$   Hͫ H$  HH$  ̣ H,; H$  Cm A@    H$  f     HcH$  H+HH;rc H$  H< t
A;_@|      DBH$  h H = H$  kiHȲ[gHȋޡ HȲ]|gH$  H$  6 HH$   Hͪ H$  HH$(  ̢ H,: H$  Cl AD    H$  f     HcH$  H+HH;rc H$  H< t
A;_D|      DBH$  h H; H$  khHȲ[fHȋޠ HȲ]|fH$  H$  6 HH$P   Hͩ H$P  HH$h  ̡ H,9 H$P  Ck AD    H$  f     HcH$   H+HH;rc H$  H< t
A;_D|      DBH$  h H: H$  kgHȲ[eHȋޟ HȲ]|eH$  H$  6 HH$   Hͨ H$  HH$  ̠ H,8 H$  Cj     D$p   |$hLL$pLD$hH$@  H$   詪LH$   HuHH$  H+HH$   HH+HH;s83D$(D$`D$ L$   Mƺ   HHCH$      LH;v H$   H$   H$   LH$   L$   HH+HuL*H;v H$   MtL;t L+I($   f$   MA   H$   H$   WH$   H;$   v9 H$   Hu& LLJI;K wHtHHH;Hs I    D$h   |$pLL$hLD$pH$   H$   HH$   F-    |$hMP  LD$hH$  H$   ǪHH$   -     $   |$hL$   LD$hHT$xH$   HH$   ,w    |$hM@  LD$hH$   H$   گHH$   z,8    I   LL$xL$  H$   HH$   ?,H$x  H$   ),H$   H$  HH$  Htf H$  H$   H$  H$  f H$  Htf H$  H$  H$  H$  f H$  Htf H$  H$  H$  H$  ef H$`  HtRf H$`  H$h  H$p  H$H  -f H$   Htf H$   H$   H$   H$   e H$(  Hte H$(  H$0  H$8  H$  e H$   Hte H$   H$   H$  H$   e HL$  I[@IsHA(sIA_A^A]A\_LEK ECIKSUVWATHpHD$8IcIcHE3Dd$0Ey*H ICL
^ MCH6 H
 pEy/Hb HD$ L
. L$   H5 H
 Kp̋*   d Ht
HL$@HIHD$@$   HL$   HL$@J   d HtHIHLD$@HHBHL$XHtLd Ld$XLd$`Ld$hHL$@3d HHpA\_^][HHXHhHpWATAUH   Dվ )p)xHHHHD)@D)HD)PWQD\$(H-|$ AA| IcL    
 AY)
 f/U  D D
 Dհ Ip     I   E^      IHiN  HHH+HHHHiH+IŉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYfD/xA)P
 A)X
 \YXf(YAYa f/wUD` HL$ HOD\$(|$ AA| IcL    
 AY)
 f/fnY(t$p(|$`L$   I[ Ik(Is0E(CE(KE(SIA]A\_HHnHfnY@WH HAHLHHAL@MtDHMtHHIL;t3MtHHIL;t2IHO H\$8IdLL$0LD$0HW H#QH\$8HG H _H8 3LD$PHT$HE3)t$ D$H'5 fTf/s vH2 H
;$ / 3LD$PHT$HE3ɈD$H݃fTf/1 vH H
# /5 3LD$PHT$HE3ɈD$H蛃fTf/ vH H
# j/(t$ H8HLH HPHHUVWATAUAVAWH   HǄ$   HXIMHH   )` Ht
HL$8H3HD$8HD$P    HD$X    HD$`    IWHL$8:HE3M9w  3\$0Ht$XH|$PIL,Hu3HL$`H+HHH+HH;s03D$(\$ LL$HMōPHtHHt$XH|$P  HH;v Ht$XH|$PLd$8L$   H$   HH+Hu3$H;vw MtL;d$8te H+H($   f$   MA   H$   HL$8MH|$PLHt$XH;v Ht$XH|$PLd$8Mu  E3Ht$XH|$PHD$8LIL I;K wMtI$3H;Hsŕ Ht$XH|$PAIcI;OH$  H$(  H$     9^ Ht
HL$hH3HD$hHǄ$       HǄ$       HǄ$       H|$ LL$hLD$8HHH$   Ht] HǄ$       HǄ$       HǄ$       HL$h] HL$PHtp] HD$P    HD$X    HD$`    HL$8K] HH$   H   A_A^A]A\_^]@UATAUH   Hl$PHE H]PHuXH}`)u HL!LiA0HJHH;vO.HHumH    H=   w9H   HHH;w
HHHe H+HT$PHH$H    H HHuHt-HG3H97HDHH=   IE IL$t$@HD$8   HT$0HD$(   HD$ LM$IT$#t	H} H]PHuXH}`(u He0A]A\]H\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,CdH;}:D$Hfffff     HHH;f(Df^f)D|HT$ HL$0LLdH$   HHP_^]Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;t
,̄t ,̄t+H\$P3H;tH
 Ht
HC]HHHHwHH+HLMM~#( ff     HHI;f)D|HL$ LH-LD$XH-~ l$XHH\$PHl$`Ht$hH@_LI[IkIs WH   Hj3HHH   ICICICIC@ HtHS3HCHHtH3HBBHVHHD$hHL$xD$pHHHT$8HT$PHL$0HL$ HT$XHt$HHH;|L$   I[Ik Is(I_H\$UVWH   HBBPHHL$(HHBHAHBHAHB HAHB(HA HB0HA(HB8HA0HB@HA8HBHHA@HHHxD$pH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,C*H;}ID$pHT$(fffffff     fHHH;HfYfXDf)D|HL$ LLHH$   HHĀ   _^]LI[UVWH   HBBpHHL$(HHBHAHBHAHB IKHHB(HAHB0HAHB8IKHHB@HAHBHHAHBPICHB`ACICHBhICHHHhIktH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH4CH;}U$   HT$(ffffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLHH$   HHĠ   _^]@UH   Hl$PHH   H   L   L   L)   A0HU0HHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@HAHHU HHAPHBHAXHBHA`HBHAhHB LeHL;v&H}     HM LMpLE0HU8t$@3HD$8   J    H9u HDH=   IE HD$0HD$(   HL$ HM@4t	H_ H   H   L   (   L   H   ]J    H   w<J   HHH;w
HHH\ H+HL$PHH$H HHH%HL$VWATAUAVH@HD$ H\$xH$   MLHH) HH荪HOH胪H      T E3HtHIHLsLs Ls(H      S HtHIHLsLs Ls(H      S HtHIHLsLs Ls(IHOTIHOHUHH\$xH$   H@A^A]A\_^H\$Hl$Ht$H|$ ATH@Hy0MHH_H񀻡    u2ffff     HKI tH[HH    tHH^0H|$(HD$ HtH;t H;tHWIǈ uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$Hl$Ht$H|$ ATH0Hq8HiLHHLHT$ HH HtH;ta H9wuHIHP tH\$@Hl$HHt$PH|$XH0A\H\$Hl$Ht$ WATAUAVAWH0Li8LqHHHT$ 3HIt$`?LH HtI;tɈ M9l$tGHT$ HOLHHHu HHtH1HF0H9Gu HWHp*HHHP tHOHHT$ LH   H)Hl$pHt$xHH\$hH0A_A^A]A\_HWATAUAVAWH   HD$ HXHhHp IHH3$   Li8LqHT$(H0LH HtI;t M9l$tULHT$(HKHHHu HHtH1HF0H9Cuv HSH@HFH  HHHP   HKHLHT$(HHHu( HHuHHH@0H9Cu HSH@HL$8H\$XH+\$PH   O Ht
HL$hHHHD$hfW$   L$   HHL$ht-HHD$XH|$PH+HHtaH;r H|$PH$   H$   H+HH;rX H$   fnHHD$XH|$PH+HH;rHT$hHH$   HtN H$   H$   H$   HL$hsN HL$PHtcN Ht$PHt$XHt$`HL$8JN HH   H芢HL$   I[8Ik@IsHIA_A^A]A\_H\$Hl$Ht$H|$ ATHPHHL$ Lu 3IL(iHE8H}HHu8HtH;}t( H;   Hu E3LI;[0u  HSIfHu     tڄ HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\H\$Hl$Ht$H|$ ATHPHHL$ LE 3ILgHExH}HHHuxHtH;}Ht H;   Hu E3LI;[0uЃ HSIeHu     t HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\HL$WHPHD$ H\$hHt$xHcHFH! HH~@H|$p3HHGHGLHMt:MtHHIL;tMtHHIL;tIIMHWNLOLGLD$0LL$8MtWMtHHIL;tCMtHHIL;t&MtHHIL;t	IIHMHT$(HHH\$hHt$xHP_HWATAUAVAWHP  HD$HHXHhHpLHH  HL$  IHT$ IHL$     DBHL$P E3IL9vH   H HL$ . HT$ HL$P~ HL$ 1 HF@HL$` A   ML9fP~Kffffff     H~@IH^HHH
 HL$` FH: AIIcH;FP|HT$ HL$P~ MHIAHL$  AHIcH;FH'HL$P~ L$P  I[0Ik8Is@IA_A^A]A\_H\$ WH   HًI@H;K4rS0+C8;s;tHKPI>C@SD;  K0;  +K8H$   L$   )$   )$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPH@HwH|$05 D,[PHt$PfAnf(X^^j D$`|$8Y5 t$hHt.HH;t"̄t̄tH$   3H;tH~ Ht
HXJHH/HHwHH+HLMM~JffY^| ffD  Hf(HI;fDfYfXf)L|HL$ LH<HKP;C@H$   ($   ($   L$   H$   H$   HĠ   _C@H$   2HĠ   _HHPWATAUAVAWH@  HǄ$   HXHhHp MMHHd3E3E3HV H+VHgfffffffHHHH?Hd  HCHD$0Hl$ 3H|$(H*$x       IO I+OHHHH?HL;r<} IGHH$   H-LIt$I;t$ v
} I<$H|$pHt$x(D$pfD$`Hu| E3LJ4I;s wHtH3H;ps| Ht$hIt$I;t$ v| I<$H|$@Ht$H(D$@fD$PHu| E3LH4I;s wHtH3H;psW| Ht$X   D Ht
H$   H3H$   (D$`f$  (L$Pf$0  DL$  H$0  H$   CIO I+OH*HHHH?HL;r{ H|$(IH$   H$   肘HH$   qH$x  HN H+NHgfffffffHHHH?HL;rZ{ HT$ HVHL$0ךHH$   HHO0H$   H$   HtC 3H$   H$   H$  H$   uC H$   HtcC H$   H$   H$   H$   >C IH$   Ht)C H$   H$   H$   H$   C IH|$(H0H|$(HD$ (HN H+NHgfffffffHHHH?HL;H*L$@  I[0Ik@IsHIA_A^A]A\_H\$Ht$WH0HyxHqHHHLHT$ 8HH HtH;ty H9{Ht$HH\$@H0_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ LHHHuNy HHtH1HF0H9Gu3y HWH@H   HHl$PHt$XHH\$HH0_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ LHHHux HHtH1HF0H9Gux HWHpH   HZHl$PHt$XHH\$HH0_H\$WH HztH@ HH\$0H _HHPUVWATAUAVAWH   HD$PHX)pMHLE3D$   I@HD$ L
* DA H_ H
 ?MIVIHtgII      Ic$   H$   I#I;w
IL;r/H^ HD$(HB HD$ MH H
 I]H\$8Lt$`HT$hHL$0HHHAHBHAHBH$   HL$XHHHAHBHAHBHAHBHA HB HA(HB(L$   ImHuI9HH;vH4    Hv HHuHtHHoIuHtI;twHtI;tb̄tXH;tTv Ht
HAHL'HwImHtI;tHtI;t̄tH;tHu Ht
HPAHL'HoIuHtI;tHtI;t̄tH;tHu Ht
H@HL'HwHHH+HHHH~JIE fB(4HfB(f)D$0HL$01f(IfB(fYfXHfB)IL;|LLHH$   HH$0  ($   H   A_A^A]A\_^]LD$HT$WH0HD$ H\$XIHD$@    LAHHQHD$@   Hs HH\$XH0_LL$ LD$HT$HL$SUVWATAUAVH0HD$ IIHLH
 HHHL$(H HHBHAHHs IM@HI  H	I  HL$(H HL$   IFHAIFHAIFHAH IV 腐HOr Hz| HHHIN8Ht; 3IF8IF@IFHIN ; IIH0A^A]A\_^][H\$WH HLtH; HH\$0H _HL$WH0HD$ H\$HHt$PHH   H  wEH  W; H  q H  Ht7; 3H  H  H  Hp  ; H   H   HOpEHOp: HOPHt: HwPHwXHw`HO8: HO Ht: Hw Hw(Hw0HOH\$HHt$PH0_: HL$SH0HD$ HH p HK0HKpH   o H   o HH0[H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ OL_0L[ H\$hHt$pHP_L;vp HH|$8LD$0HD$0HT$@L(D$0HfD$0ϕH\$hHt$pHP_HHPWH  HD$hHXHpIHH3t$0MHHL$pN9 Ht
HL$8HHHD$8Ht$PHt$XHt$`   8 HtHHHHsHs Hs(D$0   H  Hl HD$ LLD$8HT$pHL$PHt[8 Ht$PHt$XHt$`HL$8B8 HL$p+rHL$  I[Is I_HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;v+o HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@H   L;   H;vn HHD$@H\$HHnH;n vn HH\$0Hl$8(D$0fD$0Hun E3LKdHHI;k wHtH3H;hsWn Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PHJHOHt6 HG    HG     HG(    HL\$`I[ Ik(IA\_^n6 H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;vvm HM HtH;tbm HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k v
m HHl$(H\$ (D$ fD$ Hul LLH<HHI;{ wHtH3H;~sl H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\HT$HL$SUVWATAUAVAWH   HD$ HHHx  8OH  \?L  I   4 Ht
HL$pH3HD$pHǄ$       HǄ$       HǄ$       H@  H$   HT$pHULL; vk L7H_ H9_vk MtL;7tk L;  Muvk E3MM;{ rbk IH  cLH0  H+(  HgfffffffHHHH?HL;  Muk E3MM;{ rj IHx  LHN H+NH*HHHHH?HL;rj K<dHHFHH  Muj E3MM;{ rj Hv I
i 1  HǄ$  IUHu3IM(H+HI] HH+HH;sHHCIE H$     H;vj I} H|$0H\$8IM IuHH+Hu3#H;vi HtI;} ti H+H(D$0fD$PL$  A   HT$PIIuI;u vi I} Hui E3LHI;K wHtH3H;H  Qi H$   H$     HN H+NHHHHH?HL;ri Hn   3HL H+LHHt/    H;rh HD4HHL H+HH;r؋H$   H$   H+HL;rh H$   B,H$  L$+I;C   IUHu3IM(H+HI] HH+HH;sH+HCIE    H;v:h I} H|$@H\$HIM IuHH+Hu3#H;vh HtI;} tg H+H(D$@fD$`L$  A   HT$`I	IuI;u vg I} Hug E3LHI;K wHtH3H;Hsg HH$  I;H$   H$   H$   *H$   H$   H$   H$   H$   Mug E3MM;{ r	g I(VH  H  PIE I+EH8  H$   HtU/ HǄ$       HǄ$       HǄ$       HL$p'/ HĨ   A_A^A]A\_^][HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   . Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$pMH{   \$0ffff     IG I+GHL;re IGB4Hh HHHZ H;K r   H
 HHL$8Htf(JIHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH讧L_L$      H$   H9$   vd Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   vd HtH;t$ptd I+H(D$PfD$`LL$8A   HT$`HL$pL$   L;$   vKd Ht$pHu;d MHD$pLIL I;K wHtHIH;Hs
d IH$   L;pHH$  HD$ L$  LD$pHT$8H諑H pH$   Ht7, L$   L$   L$   HL$p, f(($   H   A_A^A]A\_^[HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   + Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$pMH{   \$0ffff     IG I+GHL;rb IGB4HH HHH: H;+ r   H
 HHL$8Htf(*IHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH莤L_L$      H$   H9$   va Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   va HtH;t$ptoa I+H(D$PfD$`LL$8A   HT$`HL$pL$   L;$   v+a Ht$pHua MHD$pLIL I;K wHtHIH;Hs` IH$   L;pHH$  HD$ L$  LD$pHT$8H苩H pH$   Ht) L$   L$   L$   HL$p( f(($   H   A_A^A]A\_^[HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   ( Ht
HL$8H3HD$8HǄ$       L$   HHL$8
3I;^   IE I+EHH;r_ IE4H: HHH, H; r   H
 HH$   Htf(H3HD$XHL$PH+HH;r&_ HL$PH<HZH$   HD$ MLD$8H$   IЌH$   q.HT$XH+T$PHfWId3fHD$XH|$PH+HH;s/ID$ I+D$HH;r^ HIL$H@HHHtH& HD$P    HD$X    HD$`    HL$8& 蓚f(L$   I[ I{0Mc8(t$pIA_A^A]HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   u& Ht
HL$8H3HD$8HǄ$       L$   HHL$83I;^   IE I+EHH;rj] IE4H
 HHH H; r   H
w 貭HH$   Htf(H3HD$XHL$PH+HH;r\ HL$PH<HZH$   HD$ MLD$8H$   I蠥H$   qHT$XH+T$PHfWI43fHD$XH|$PH+HH;s/ID$ I+D$HH;ra\ HIL$H@HHHtH$ HD$P    HD$X    HD$`    HL$8$ cf(L$   I[ I{0Mc8(t$pIA_A^A]@SH H3g H      ?   Hǃ       ^   H   ,;L   H HHH [@SH H3E3H     @@ǃ      D   H   H D   HD   L   HH [HL$WH0HD$ H\$HHt$PHH3H      ?H   Hǆ       f ^   ,   ;L   H	 HWH   \L` LH> H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHX2E3D   ǆ      H     @@H   D   D   L   H HWH   [LF LH$ H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PIHHH+ HHRTH HF`H^pHfz HFhH~xH   H 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH HGj HHAhHIHX HO8X HO X HOX LOd LtH3! HH\$0H _HL@HHWATAUAVAWHPHD$0HXHp )pMMLLfWHRH@ 3HI9\$~Dff     M,$IF`I+FXHH;rX INXID HHI;\$|L$   I   MFIF8HD$ MNpIV@I5m fWAE I   I+   HI;wtLIW Ht;HH;vL$    IW HuMteII?IwI   I+   HH   H       I   I+   HH;rW I   $   H$   H#H;tUI   I+   HH;rV I   fWIHI   I+   HH;k6IN8HtH HHU U    mH      AE $   H$   H#H;t3@IN8Ht+Hh {HH9 lHHT T       L\$PI[8IsH(t$@IA_A^A]A\_HLH L@HPHHSVWATAUAVAWH0  HǄ$  )p)xIME3Dd$8HR 0t$pD$0H$  HcAL$ Ht
HL$@HIHD$@fW|$8LD$8HHL$@Hc    Ht
HL$xHIHD$xLD$@HHL$xA7HL$XHt} Ld$XLd$`Ld$hHL$@d LQ AD$8HT$8HL$xǱHT$pHL$x踱Hc   K Ht
H$   HIH$   |$pLD$pHH$   3HQ  M@ H$   HH$   H+HL;sBII H+HH;s4HH$   H$   D$0	   Dd$8DDHT$8HL$@HHL$x芗HL$XHtNH|$`H    H;t-HKHt) LcLc Lc(H H0HL$X H$  Ld$XLd$`Ld$hHL$@ D$0
   Dd$8DHT$8HL$@9dHH$   HL$XHt Ld$XLd$`Ld$hHL$@ A   EfD  D;?  D$0   D;.  IcI^ I+^H  C;  LgL;rR MvIcH$x  HX H+XH.  C;#  HH;rgR H$x  HBfC/  D$0   H$   H$   H+H|KC;}DHH;rR H$   H      ?HD$0   AH$  L$     DBH$  O Hx H$      HyO H$   H$  O L$   H$   LC$   H5 HD$ DǋH
Ѕ 3n   DBH$  sO H3x H$   v   HN H$   H$  RO L$   H$   LC$   HT HD$ DƋH
G m   DBH$  N Hw H$      HgN HT$@H$  N LL$HH|$`LCL$HH# HD$ DǋH
ʄ -mH$  L$  D$0   IcH$   L$   I+H*HHHHH?H؃|EC;}>HH;rO L$   HHIH$   fAH$     DBH$  M Hv H$      HTM HT$@H$  M LL$HH|$`LCL$HH HD$ DǋH
 lD$0   HT$xL$p  I*H$   Ht 3H$   H$   H$   H$   n H$   HtEH$   HH;t0HKHtB HsHs Hs(H. H0H$    H$   H$   H$   HL$x I($   ($  H0  A_A^A]A\_^[HWATAUAVAWH`  HǄ$  HXHhHp)p)xf(IHH   DBH"L     E3Ht
HL$`HIHD$`Lt$xL$   L$   H$0  HD$ LL$`LHHPf(HT$8H$   K Hx HL$8vL L$  t,HT$8H$   K MHIAHL$8>L     Ht
H$   HIH$   L$   L$   L$   H$0  HD$(t$ L$   LHH6HT$8H$   K Hx HL$8K t,HT$8H$   J MHIAHL$8K ADt$0Hl HL$8FK HT$8H$   I HL$8FK H7 H$0  rHf(J MIASHT$8H$   HJ MHIAHL$8J MIASH\l HL$8J HT$8H$   OI HL$8J 
   H$   H H$0  HcQH0  HP   H$   H HH H$0  HHuI
H HcHHHW   H$   LH HHN HZHHuI
H HcHHHW   H$   
H HH HHHuI
H HcHHHW   H$   G HH HHHuI
H HcHHHWH~ HHT$8H$   H MHIAHL$8>I IHE H+EHH+  $  =P D  Hj HL$8H HT$8H$   zG HL$8H L$   L+\$xII;rI HD$xH$   H$   HH$   H+HH;rI H$   H$   HH$   H+HH;rRI H$   H$   H+D$xHH;r.I Ll$xHE H+EHH;rI Lu
   H$   +F H$0  HcQH0  HP   H$   E LHH$0  jF HHu3
H HcHHIT$A$   H$   E LAHF HHuE3I
H HcHHE3IT$A$   H$0  mE LAL HF HHuI
H HcHHIT$A$   H$   'E LH^F HHuI
H HcHHIT$A$L$   AH$   \HF HT$8H$   E MHIAHL$8F L$   H|$xL+II;rXG H|$xH$   H$   H+HH;r1G H$   \fTf/vt$0Ɖt$0t$0HHE H+EHH;H$   Hte L$   L$   L$   H$   @ HL$xHt0 Lt$xL$   L$   HL$` H$   D L$`  I[0Ik8Is@A(sA({IA_A^A]A\_HH   )xHXD)@fD(,L ID)HD)PD)XfD(fDTfD(fDTfE(D)`EYD%Q fE/r)H@fA(fA(LHD$ fA(3f(    )$   fA/rWfA(zf(fA(z=ǒ H$   E^LHD$ fA(YfA(\fA(V3\]fA(&zf(fA(zH$   E^fA(LHD$ f(XY=Z YfA(\fA(2\($   fWD(d$0D(T$PH$   fA/D(\$@D(L$`D(D$pvfW=bZ f(($   HĨ   HT$HL$UVWATAUAVAWH   HǄ$   H$   EHHLq L+qI    Ht
HL$PH3HD$PHD$h    HD$p    HD$x    LD$P3H@-HLH$   Hu4HMHtV HE    HE     HE(    HM 5       J Ht
HL$ H3HD$ 3H\$83HL$@3HT$HA   M;f  MM+L$(  Hu3H+HHH+HH;sLHHL$@H\$8	  HH;vC HL$@H\$8Ht$ H$   H$   HH+Hu3$H;vB HtH;t$ tB H+H($   f$   L$(  A   H$   HL$ H\$8LHL$@H;vqB HL$@H\$8Ht$ HuWB E3HL$@H\$8HD$ LII;S wHtH3H;PsB HL$@H\$8IM;w
HT$HL$   EtpE3IMthff     HH+HH;rA HL$@H\$8H4H+HH;rA H\$8IH+HHHI;sHL$@H\$8E3D$(      
 Ht
HL$PHIHD$PL$(  IHL$PHT$PL$  IHL$hHt	 L|$hL|$pL|$xHL$P	 I+  II HHL$PþIM   fD  HD$@H\$8H+HH;r@ H\$8HHD$pHT$hH+HH;r@ HT$hH4HE H+EHH;ro@ HT$hHE9r.HD$pH+HH;rF@ HT$hD<HI;aHD$pH+HH;r@ HT$hHT$PIcHL$hHt L|$hL|$pL|$xHL$Pf IHL$8HtM L|$8L|$@L|$HHL$ 4 HMHt% L}L} L}(HM  H$   H   A_A^A]A\_^]HL@HHUVWATAUAVAWH   HǄ$   HX )p)xMHHT uG  / uI*   
j 
 *  
B 
 H$H  HD$ f(fW$(  HW H+WHHL$(  L$@  IH_ H+_H    E3Ht
H$   HIH$   $(  L$(  HH$   H_ H9_v= HHD$@H\$HH_H;_ v= HHD$0H\$8   { Ht
HL$PHIHD$P(D$@fD$@(L$0fL$0D$(  LD$@HT$0HL$PQIH_ H+_HH       HIE I+EHH;rE= IEL4fffff     HG H+GHH;r= H_HD$pHL$hH+HH;r< HL$hH=9A XHD$     L$   MHT$PH3HG H+GHH   L=8ff     H$   H$   H+HH;rn< H$   5 CY<
 Y4f(AXAHw H+wHHHIE I+EHH;r< IEX44HHG H+GHH;_L$0  H$   II HG H+GHH;r; H_HD$pHL$hH+HH;r; HL$hHHHH_ H+_HH;A    HL$hHt Ld$hLd$pLd$xHL$P H$   Ht L$   L$   L$   H$    f(L$   I[XA(sA({IA_A^A]A\_^]H8,j 3LD$PHT$HE3)t$ D$H5@ fTf/P vc:  "   Շ 3LD$PHT$HE3ɈD$HfTf/iP v):  "    3LD$PHT$HE3ɈD$H{fTf//P v9  "   (t$ H8LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCIS)HxHHXHhHp L@WATAUAVAWH   )p)xD)@D)HD)PD)xD)hD)XD)t$pD)|$`L$  IA   MHLDD$ ADH`D@xD	? fA(A\f(fATf/V  H$  L$X  =N DkN D$  D$  D$  D$  gfffIH      AA+ufA(AXAYA$(  fA(fA(A\AXYM ^fA(AY\f(Y\  fE/f(vfW-M f(Y-M fA(AXA\fA(\A\YXfA(^\$  A$H$  H#H;tRfE/H$  wH$  Y5T f(X f/w%fE/H$  wH$   \f/vfA(AXAYA$=L IH]A4$Ll$0t$HHl$@Ht!I;  HtI;  H;^tTH6 Ht?HH;  H<    H6 Hu	H|  H$@  HH    H3H^HH+HLMM~:fHE f(HI;fYLIE f(DHfXf)D|HL$(LH>H$P  MLH|  @ fE/H$  wH$  fE/0H$  AX4$AYA4$wH$  A\fATf/  H]t$HLl$0Hl$@HHt!H;\  HtH;O  H;^tTHV5 Ht?HH;4  H<    H55 Hu	H  H$@  HH    H3H^HH+HLMM~:fHE HI;f(LIE fYf(DHfXf)D|HL$(LH==H$P  MLHHId!H$p  f(A$f(YH$`  Xf/wwfA/spH$x  f(fAT fWf/  fA(A\Yf/@ rD$  fE(fE(fE(E$fD(fD(D$  $  fD(fD(fD(DD$ AfA(ADD$ A\f(fATf/   D(t$pD(|$`L$   I[0Ik8IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_'!	3tHWH`HD$ HXHp HHHzHxfW@Ht4HHHHt̄t̄tH;t"H2 Ht
HHH    H{HHH+HLM3M~%(/ fffff     Hf)HI;|LHHL$(-> l$xH$   HNHtH3HAAHNHL$(HD$8D$@HD$H    HD$P    LD$xH$   HL$(cHL$HH\$pH$   H`_H%1 HHX WATAUH`  LQH)p)xHCHHD$PHT$hIBHD$XHAHLRHBHAHBHA MHB HA(MHB(HA0HB0HA8HB8HA@HB@H$   H$   Iu
fWf(CH$   HT$PAh    H|$X fWuf(H$  H$   pzf( ;H$  H$  f/   f(Yf/   IE     A<$HoHt$@Hl$0H$  tH&HH$  HT$ HكH;HL$ HMHHHL$(LH+E3HH+HHH4CgH;}$D$@fHHH;f)T|HL$(LLH+-  f(YX f/A$rfWAE A$H$   HT$PAh    HHwf(A\,$H$  $0  tH&HH$  HT$ HكH;HL$ HMHHH$   LH+E3HH+HHH,CuH;}?$0  H$   f    fHHH;f^f)D|H$   LLHuA$\A^$AE H$  H$  L$`  I[8A(sA({IA]A\_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,C;H;}(D$8f@ HHH;f)T|HL$ LLHLD$hH-{9 l$hI!H\$`Hl$xH@A\_^@UH   Hl$PH]PHuXH}`LehLHM )u0A0ID$(HHID$0HAID$8HAID$@HAID$HHA HBHH;vH
HuLH    H      H   HHH;w
HHH H+HL$PHHHFML$ M$t$@3HD$8   HL$0H9>HDIL$HH=   HEHPHE HT$(IT$HD$ 誻t	H, H]PHuXH}`(u0LehHe@]H+ HHhH_@UH   Hl$PH]pHuxHHFHHM H   HHFPL   )uPA0HAHFXLHAHF`HAHFhHA HFpHA(HFxHA0H   HA8H   HA@HBHH;v$H
HuLH    H      H   HHH;w
HHH H+HL$PHHID$LN@Lt$@HV3HD$8   I9<$HL$0HDHNHH=   HE8HD$(HE HD$ 	t	Ht* H]pHuxH   (uPL   He`]HS* HHhH_)H\$UVWHpHBB8J@HHL$0HHBHAHB HAHB(HAHB0HA HHHxD$XL$`H$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}aD$XHT$0D$`ff@ fHf(HH;HfYf(fYf(Lf\f)L|HL$ LLH9H$   HHp_^]LH   HD$ LL$(HIHBIAHBIAHT$HHA(HHA0HBHA8HBHA@HBHAHHB HAPHB(HAXHB0HA`HB8HAhHB@ISHHHAHBHAHBHAHBHA HB 3ICICHT$(HL$H胚3H   H%
( HHHWH`HD$ HXHp HHY    3HtHHHHsHs Hs(H_8   V HtHHHHsHs Hs(H_p   , HtHHHHsHs Hs(H       HtHHHHsHs Hs(H   H\$xHK=% HK03FHKp)FH   % H   
% Hp      HtHHHHsHs Hs(H  $ H     P HtHHHHsHs Hs(H      # HtHHHHsHs Hs(HL\$`I[ Is(I_H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ ?L_0L[ H\$hHt$pHP_L;v% HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_HHPUVWATAUH@  HǄ$   HX)pEAHHHL$0AHD$PH+D$HHH;         DBH$0  # H   H\$PH+\$HHHO H$@  HHF" HH$ HH+" HH= H$  H$0  " HH$   $ H* H$   HH$   <# H* H$   H% H$    E3D$p  HH  H+@  HAM Ht
HL$`HIHD$`L$p  HHL$`mEQ  @   H  L
\  LD$`HT$0f(HL$xHt Ll$xL$   L$   HL$` HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(H f(  H  L
 LD$`HT$0yf(HL$xHtR Ll$xL$   L$   HL$`3 HL$HHt# Ll$HLl$PLl$XHL$0
 HKHt LkLk Lk(H f(X      Ht
H$   HIH$   L$   L$   L$   @t0H  H HD$ L$   LD$`HT$0f(.H  H HD$ L$   LD$`HT$0f(H$   Ht* L$   L$   L$   H$    HL$xHt Ll$xL$   L$   HL$` HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(H f(H$  ($0  H@  A]A\_^]LD$HT$UVWATAUH  HǄ$   H$X  EIHHE3Dl$0IHL$8b=HD$XH+D$PHH;      AUEEH$   H   H\$XH+\$PHH H$   vHH HH [HH HH @H$   H$  * HH$   	  H& H$   HH$    H& H$   H H$   ( D$@  HH  H+@  H    Ht
HL$hHIHD$hL$@  HHL$h    HtHIHLkLk Lk(D$0   Et'H  H HD$ LLD$hHT$8蚾&H  H HD$ LLD$hHT$8H$   Ht, L$   L$   L$   HL$h
 HL$PHt Ll$PLl$XLl$`HL$8 HOHt LoLo Lo(H HH$X  H  A]A\_^]HLH HPHHSVWATAUAVAWH  HǄ$  )pLL'    u HtH$x  H33HH$x  H$  H$  H$     2 Ht
H$   HHH$   H$  H$   H$(  Hn  $  Hg HL$h H H$    H H$@   HL$0HD$ LL$hL$   H$@  I+HL$HHtI H\$HH\$PH\$XHL$00 H$@   H$    HL$h Ml$@L$h  A] H HL$hG ILD$hHT$0IP(HH$x  HL$HHt H\$HH\$PH\$XHL$0 HL$h
 L$  H$  L+IMu H$   AE H~f H$@   HL H$    H: HL$h HL$0脑HD$ L$@  L$   HT$hIq*HL$HHt H\$HH\$PH\$XHL$0 HL$h< H$   - H$@   M\$DL$  A\$DH HL$h ILD$hHT$0IP(HH$x  襽HL$HHtA H\$HH\$PH\$XHL$0( HL$h L$  H$  L+IMun H$   AD$DH# H$@  : H H$   $ H HL$h IcU HL$0BiHD$ L$@  L$   HT$hI(HL$HHtk H\$HH\$PH\$XHL$0R HL$h H$    H$@   EE HE H
" 7fWt$`Ic}     Ht
HL$0HHHD$0LD$`HHL$0ID$HHD$`HT$0H̺HL$HHt H\$HH\$PH\$XHL$0 H HL$h ILD$hHT$0IPHH$   lHL$HHtH H\$HH\$PH\$XHL$0/ HL$h HMc} HM   H\$`LL4    HHC H+CHH;rZ LcH$   H$  H+HL;r4 H$  J1IHI;r3L$(  L$h  L$   Hk! H$@   Hy H$    Ho HL$h IcU HL$0fHD$ L$@  L$   HT$hI&HL$HHt H\$HH\$PH\$XHL$0 HL$hm H$   ^ H$@  O EE H H
 H5t$`Ic}     Ht
HL$0HHHD$0LD$`HHL$0軽HT$0IL$x{HL$HHtW H\$HH\$PH\$XHL$0> H? HL$h ILD$hHT$0IPHH$   HL$HHt H\$HH\$PH\$XHL$0 HL$hV HIcE HH   HLL<    HI$   I+$   HH;r M$   H$   H$  H+HL;r H$  J9ID HH;r3L$(  L$h  H H$@   H! H$   s H HL$h` IcU HL$0dHD$ L$@  L$   HT$hIN$HL$HHt H\$HH\$PH\$XHL$0 HL$h H$   
 H$@   EE H H
i 2t$`Ic}    p Ht
HL$0HHHD$0LD$`HHL$0gL$   HT$0I$   HL$HHt H\$HH\$PH\$XHL$0 Hܻ HL$h1 ILD$hHT$0IPHH$   輵HL$HHt H\$HH\$PH\$XHL$0 HL$h HIcE HH~   HؐLL<    HI$   I+$   HH;r M$   H$   H$  H+HL;ry H$  J9ID HH;r3L$(  H^ H$@  1 Hź H$    Hú HL$h HL$0
HD$ L$@  L$   HT$hI!HL$HHtf H\$HH\$PH\$XHL$0M HL$h H$    H$@   L$   A   H
 HL$hf ILD$hHT$0IP(HH$x  1HL$HHt H\$HH\$PH\$XHL$0 HL$h, L$  H$  L+IMu H$   A   HR H$@   HL H$    HV HL$h Ic   HL$0`HD$ L$@  L$   HT$hI HL$HHt H\$HH\$PH\$XHL$0 HL$hQ H$   B H$@  3 E   H H
 )/t$`Ic       Ht
HL$0HHHD$0LD$`HHL$0虷I   HD$`HT$0HOHL$HHt+ H\$HH\$PH\$XHL$0 H HL$hd ILD$hHT$0IPHH$   HL$HHt H\$HH\$PH\$XHL$0 HL$h* HMc   HMt}H\$` LL4    HHC H+CHH;r LcH$   H$  H+HL;r H$  J1IHI;r3L$(  L$   H H$@  f HF H$   P H HL$h= M}DMcL$h  Ic$HL$0^HD$ L$@  L$   HT$hIHL$HHt H\$HH\$PH\$XHL$0o HL$h
 H$   
 H$@  
 E$Hb H
 ,EH4 H
i ,$p  Ic?   & Ht
H$   HHH$   L$p  HH$   Ic<$    Ht
HL$0HHHD$0L$   HHL$0FI  H$   HT$0HHL$HHtNHt$PH;t7HyHHtO HH_H_HO; H0HGH;uHL$H$ H$   H\$HH\$PH\$XHL$0 H$   Ht H$   H$   H$   H$    H HL$h ILD$hHT$0IPHH$   訮HL$HHt H\$HH\$PH\$XHL$0k HL$h H$p  IcH$0  LH/  H*ff     Ic$H$  LH   HH$p  fffff     LL<    HHN H+NHHHHH?HL;r; HvHD7 H+D7HL;r Ht7H$   H$  H+HL;r H$  IJIH0L;$  H$   H*PH$p  3IL;$0  H$   L$h  L$(  L$  EH H
 )Ic?HuHI9II;vDL$    IB HHuMt H$0  H$8  L$   Ht.HH;t̄tߤ̄tդI;$H  tQI$@  
 Ht6I;v譤L,    I
 HuMt茤I$@  I$@  I$H  HHH+HLMHM~#     f(I$@  f)HI;|LI$@  H$0  -zH
 Ht H$@   Hj H$    H HL$h IcH$   XHD$ L$@  L$   HT$hIH$   Ht H$   H$   H$   H$    HL$hm H$   ^ H$@  O H HL$0 ILD$0H$   IPHH$   襪H$   Ht~ H$   H$   H$   H$   Y HL$0 HMc?HMt\ HL,    HM$@  H$   H$  H+HH;rx H$  ID IHI;rL$(  H H$   2 H HL$h Hǯ HL$0 H$   ~HD$ L$   LD$hHT$0IH$   Htg H$   H$   H$   H$   B HL$0 HL$h H$    L$   IP  Hٮ H$@  [ IL$@  H$   IPHH$   H$   Ht H$   H$   H$   H$    H$@  	 L$   H$  L+IMu H$  H IP  HvQ H$    H HL$h H5 HL$0z H$   ||HD$ L$   LD$hHT$0IlH$   Ht H$   H$   H$   H$    HL$0( HL$h H$   
 AX  H? H$@   IL$@  H$   IP(HH$x  薨H$   Ht/ H$   H$   H$   H$   
 H$@   L$  H$  L+IMuM H$   AX  H H$    H HL$h H HL$0 M}DIcH$   THD$ L$   LD$hHT$0IH$   HtE H$   H$   H$   H$     HL$0 HL$h H$   } EH H
8 w"$0  Ic?    Ht
HL$hHHHD$hL$0  HHL$hM`  HT$hI蠥H$   Hty H$   H$   H$   HL$hW H HL$0 ILD$0H$   IPHH$   1H$   Ht
 H$   H$   H$   H$    HL$0] HIcHH   H     LL<    HID$ I+D$HH;r	 Ml$H$   H$  H+HL;r H$  IID HH;r3L$(  L$   L$  H H$    Hr HL$hw H HL$0d IcH$   QHD$ L$   LD$hHT$0ISH$   Ht H$   H$   H$   H$    HL$0 HL$h H$     EHv H
~ $0  Ic?   h Ht
HL$hHHHD$hL$0  HHL$h\M  HT$hIH$   Ht H$   H$   H$   HL$h H~ HL$0   ILD$0H$   IPHH$   訢H$   Ht H$   H$   H$   H$   \ HL$0 HIcHHtH LL<    HID$ I+D$HH;r  Ml$H$   H$  H+HL;rb  H$  IID HH;r3L$   L$  Ǆ$      L$   MH H
u $   L$   MP  HQ H
u 5H$h  DH H
 M   E$HA H
 $0  Ic<$   B Ht
HL$0HHHD$0L$0  HHL$06Hc>    Ht
H$   HHH$   LD$0HH$   fH$   I  H$   H$    HL$HHtr H\$HH\$PH\$XHL$0Y H$  I  [v p   H$8  HD$(Ld$ LLD$`IUHH$   裨HI  *H$   H$    I]IMZMcIc$ILIMH$  Ht H$  H$   H$(  H$    H$  Ht| H$  H$  H$  H$x  W ($  H  A_A^A]A\_^[HATH   HD$ HXHhHpHx HHHZIHtI;tcHtI;tN̄tDH;Y@t%HI8; HtHHE8HE8    H]@HHH+HLM3M~Hf(HE8f)HI;|LHU8HlHuLEhLHU8HM +tNH HL$( HL$P H HD$PHT$(HL$h H HL$P Ht$0H^HtI;tLHtI;t7̄t-H;]Pt%HMH$ HtHHEHHEH    H]PHHH+HLM3M~3fo
= fffff     Hf(HEHfWf)HI;|LHUHHL$(!Hǅ       H   H L$   I[IkIs I{(IA\H%, Ht$WH 3HH9q vGH\$0fD  H_HK: HK0 HG(HGHH;GuHHGH;w rH\$0Ht$8H _HWATAUAVAWH  HD$`HXHhHpAMHLIHC H+CHuII     9 E3Ht
HL$ HIHD$ L|$8L|$@L|$HHHL$h3xDHT$ HµMD8$  AH\$8H;\$@v! HD$ HD$PH\$X(D$PfD$PH|$PH\$XHt$@H9t$8v HtH;|$ t H;     DBH$    IH$   ' HHw Hu MLI;[ ry Hk H+kHHIti@ HuU MLI;[ rA HC H+CHH;r* HCIH$    HHy SHH;rHu MLI;[ r HC H+CHH;r HCIH$   ] HH{ HT$hH$    HIHL$h H$    HuY MLI;[ rE H0?H\$8HtJHt$@H;t6H@ HHt L;L{L{HK H0HCH;uHL$8t L|$8L|$@L|$HHL$ [ L$  I[0Ik8Is@IA_A^A]A\_LD$HL$SVWATAUAVAWHPHD$ )t$@ML7I\$Hu3LI9II;v>H<    H= LHu
Ht3Ll$(H\$0HcI;\$}_I$4H HHH H; r   H
 KGHH$   Htf(JHID H$   LHLD$(H$   H^H$   HCH$   HIt$I;wt@I` Ht/I;vIL4    IH Hu
Mt)II?IwHe0D  HcI;T$}ID IH@HI 3(t$@HPA_A^A]A\_^[L$D$HXH      )t$@D$xHD$x)|$0f(H#f(H;u,H
:k Hk L
D LD$`Hx HD$ D$xHD$xHH#H;v,H
j H! L
 LD$`H/ HD$ }f/
 w,H
j H L
 LD$hH HD$ GL$`HD$`H#H;v,H
|j H  L
 LD$hH HD$ HL$`IXY(t$@X(|$0HXHLH HPHHUVWATAUAVAWH  HǄ$   HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(IHH$  HL$  LI|$ ufEWH$  H$   fD(fE(H$  DY(D$  fE(H$   DYD$  H$(  D3H$  D HnHE3HuI/H;v5H    H3 HHuHtH$   H$   H^HHtH;tތHtH;tɌ̄t迌H;t+ HtHHH$   IH$   H$   HHH+HLMIM~Hf(f)HI;|LH$   HTbEL$   H$  D5 D=. D% D  L$   L$   $   I\$HtHH;  
HHtH;    H;_tHH Ht7HH;  H4    H Hu	H[  HL/H_HHH+HLMIM~=f    I$f(fYIf(fXHf)HI;|LHH$   LH$  LHH$  HBtAXAYIHf(fA(H$  YH$  X	f/,  fA/r	E  f(fATfA(fAWf/   f/=h sMfD(fD(HH$   3fD(Y50 Aa $  H$  H$   D$   DD$xDT$p|$hT$`t$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHHڵD   0    $  H$  H$   $   T$xt$pDL$hDD$`DT$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHH2DH$    AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]H\$Ht$WH 3IHt$80HHH\$0HGHwHwHw Ht$@HH _@SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQHPHC(HCH;CuHHCHCHCQHKHL$P3D$@HD$@HD$XHL$(HtIHIQH5HC(HCH;CuHHCHC H0[H\$Ht$WH HAHHxHt HHHHtH;y(t%HI  HtH4HF HF     HV HH~(趹H\$0HF Ht$8H _LD$VWATH@HD$ H\$xIHHH\$hE3@ HWH;VthH\$(3D$`HD$`HD$0H\$8HtHHHHK3HHG(HGH;AuHHGHHHH9OuLgH(H\$pHH\$xH@A\_^H\$UVWH   HBBXHHL$0HAh   HHBHhHAHBHAHBHAHBHA HBHA(HBHA0HBHA8HBHA@H$   D$x	 H   HHh$   H$   tH,HH$   H$(  HكH;H$(  HMHHHL$ LH+E3HH+HHH4CCH;}#ff     LD$!HH3HH;|HL$ LLHCH$0  HH   _^]HLH L@HPHHSUVWATAUAVAWH8  )p5F	 E3H0H8H@IMHHILt$hN,    ILL$`H$   HH$   LHT$pL;H
 Lt$xh  HH\$XHD$XHOL8L|$XK7H$   M  IBHIIML$  IA   H4IEM+@ ^H  H$  H$   H$  H$h  L$p  I.HH$   H$  HHHAHBHAH$h  HBHH$  HHAHBHAH$   HBHH$(  HHAHBHAH$   HBHCH$   $`  H$   H$   L$@  H$   HD$PL$P  H$   L$X  KYL$  IEHHIHILt$xL|$XH$   Ht$`H$  H$   Hl$hLd$pH$  L$  HH+H~8Mt$@HD$8   LL$0HMLIHD$(   Ht$ DwL$  H$  L$  HH@IIL$   H$   Ht$`Hl$hLd$p($   H8  A_A^A]A\_^][LI[IkIs WH   Hj3HHH   ICHD$ ICHD$(fHtHK3HC0HtH3HAA(HT$@HHAHBHAHN@HBHHHHFHT$0D$`L$hHD$xHHL$pH$   HHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   GHH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,CH;}(D$8f@ HHH;f)T|HL$ LLH軁LD$hH-; l$hI}H\$`Hl$xH@A\_^HWATAUH   HD$`HXHhHp LLX HPHiHhHu3HuL9HH;v~H<    H LHuHtr~LD$ Ht$(H}HHtH;tE~HtH;t0~̄t&~H;t(I HtHzLHD$ LH\$ H|$(HHH+HLMHM~2ff     HM IE f(f\fA)HI;}LD$ LMHT$ HL$@fA$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMHM~6fАHD$ f(f^HE f(fXf)HI;|HT$0HL$@L\$ L$   Ll$HHl$PL$   HT$hHL$AI|$H|$0H$   HL$8HLLOLOIHH+HLMM~&     IHf(fXf)HI;|HT$0IeTH$   ^ HL$ R L$   I[(Ik0Is8IA]A\_H\$WH   HًI@H;K4rDK0A+C8;sA;tHKPIC@SD;r  K0;g  +K8H$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPH|LGLO D,[PHL$ LD$(LL$0fAnHHT$hH|$Pf(X^^L$XHHAHBHAHBHAY| HB$   MtaHMtHHIL;tzMtHHIL;tzMtHHIL;tzIHIzHT$@H}HKPC@H$   H$   HĠ   _C@H$   2HĠ   _LIKVWATHpHD$ I[IkIHHH > HE3LaHyI{AL$褨 HtH8IHD$   D$   L$   3HҍHi HH{H   Y HtH8IHLgLg Lg(H{x   / HtH8IHLgLg Lg(H       HtH8IHLgLg Lg(H      է HtH8IHLgLg Lg(H     訧 HtH8IHLgLg Lg(L@  LH  H`     m HtH8IHLgLg Lg(H     @ HtH8IHLgLg Lg(H      HtH8IHLgLg Lg(LL$   HH!HL\$pI[(Ik0IA\_^HWATAUH   HD$ HXHhHp HL   茦 E3Ht
HL$pHIHD$pL$   L$   L$   LD$p3Hn   A Ht
HL$@HIHD$@Ll$XLl$`Ll$hE33HL$@HT$@HE33HL$@HT$@HE33HL$@ĉMc$   L$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;v HT$@HtH;tw H+H(D$0fD$0L$   A   HT$0HL$@dHt$XH;t$`v6 H|$@Hu& MLHI;K wHtHIH;Hs HT$@H讵E33HL$@HT$@H蒵E33HL$@cMcD$DL$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;vh HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;v. HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@*cHt$XH;t$`v H|$@Hu MLHI;K wHtHIH;Hs HT$@HPE33HL$@!McD$@L$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v& HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;v HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@aHt$XH;t$`v H\$@Hu MLHI;K wHtHIH;Hs[ HT$@HE33HL$@߅Mc\$@L$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;v HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@`Ht$XH;t$`vT H\$@HuD MLHI;K wHtHIH;Hs HT$@H̱E33HL$@蝄Mc\$DL$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;vh HT$@HtH;tS H+H(D$0fD$0L$   A   HT$0HL$@d_Ht$XH;t$`v H\$@Hu MLHI;K wHtHIH;Hs HT$@H芰E33HL$@[Mc\$DL$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v` HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;v& HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@"^Ht$XH;t$`v H\$@Hu MLHI;K wHtHIH;Hs HT$@HHHL$XHt Ll$XLl$`Ll$hHL$@ L$   I[ Ik(Is8IA]A\_HHHVWATH`HD$ HXHh HH^ HE3LaHQLAHi AL$覝 HtH(IHE LeLe Le(HSHMIL9c   fW$    Hs   R Ht
HL$(HIHD$(L$   HHL$(F{HT$(H(HL$@Ht Ld$@Ld$HLd$PHL$(˜ HH;{rHHL\$`I[0Ik8IA\_^DL$ HT$UVWATAUAVAWH   HǄ$   H$   AIHLI˶E3MT$ M+T$HgfffffffIHHH?H   E3E3$     5 Ht
HL$0H3HD$03HD$HHD$PHD$XHO H+OH*HHHH?HL;r0 HGI<IL$ I+L$HgfffffffHHHH?HL;r ID$ID$  DLD$0HH} H9}v HE HD$`H|$hHD$PHH|$HH;v HD$PH|$HHL$0HL$pHt$xH;v HL$0H$   H$   (D$pf$   ($   f$   (D$`f$   \$ L$   L$   H$   HcH|$HHt-Ht$PH;t@ H H(H;uH|$HHm 3HD$HHD$PHD$XHL$0R II0I(IL$ I+L$HgfffffffHHHH?HL;H$  @$(  H$   H   A_A^A]A\_^]HHHVWATH   HǄ$   HXHh HHE3D`AL$ә Ht
HL$ HIHD$ Ld$8Ld$@Ld$HHT$ H   薙 HtH(IHE LeLe Le(Ǆ$0     HL$8HHt$@H;v Ht$@HL$8HD$ HD$PH\$X(D$PfD$PH\$PH|$XH;vm HtH;\$ t[ H;   HuG MLI;{ r3 HH$   HH$   HHg^H$   Ht耘 L$   L$   L$   H$   [ Hu MLI;{ r H0Ht$@HL$8%   C Ht
HL$`HIHD$`Ld$xL$   L$   HT$`H]HL$xHt֗ Ld$xL$   L$   HL$`跗 HL$8HtHH|$@H;t9HYfHHt菗 L#LcLcHK{ H0HCH;uHL$8d Ld$8Ld$@Ld$HHL$ K HL$   I[(Ik8IA\_^H\$Hl$ WH03IHH9Z ~GHt$@)t$ fWHfHL$HH2HGHXDHcH;G |(t$ Ht$@H\$PHl$XH0_H\$Hl$ WH@3IHH9Z ~eHt$P)t$0)|$ fWHHL$XHP2HG@f(Xڕ HGH^tHcH;G |(|$ (t$0Ht$PH\$`Hl$hH@_@SH Hsz H      ?   Hǃ       ^   H   ,;L   H3x HHH [H\$WH H% HHHH HAhHIH HO8 HO  HO LU LtH9 HH\$0H _@SH HrE3H     @@ǃ      D   H   Hw D   HD   L   HH [HL$WH0HD$ H\$HHt$PHHXrH      ?H   Hǆ        ^   ,   ;L   Hv HWH   L1 LH1 H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHqE3D   ǆ      H     @@H   D   D   L   Hov HWH   L1 LHt1 H   HH\$HHt$PH0_ATH@HD$ H\$PHl$XHt$`H|$hHL3HH\$(H\$0Hz H+zHHt3 HHHD$(H|$0HN H+NHHt,H;rN HFHHL HHN H+NHH;rHT$(IpHL$(H\$PHl$XHt$`H|$hH@A\H% H\$Hl$Ht$WH IIHHkHHtJ LHgfffffffH3L+HsIHHH?HHD Hl$8HHS H;HKHDHt$@H{H\$0H _HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q ~5L5$ fWHMf(f(=AAID;m |LHT$(HPHHXHHtH;tbHtH;tb̄tbH;_tH Ht
HHH7H_HHH+HLMM~!    HE f(Hf)HI;|LHH88HL$($ L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;tātātaH\$P3H;tH
 Ht
HHHHHwHH+HLMM~#( ff     HHI;f)D|HL$ LHcLD$XH- l$XH`2H\$PHl$`Ht$hH@_HATHp  HD$XHXHpHxIIHL   DBHL$` Ld$HHD$pHD$PLLHHL$HHT$ HL$` Hx HL$ h t/HT$ HL$` H$  LHAHL$ 6 HL$`r L$p  I[IsI{ IA\HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA D$ L
gs DB HDs H
m; L[L\$ L
s EG H5s H
F; 詍Ic_ H\$hfWt$xHuE3IH<HH;v;_H<    H9 HHuHt_E3H$   H$   Ht.II;t^̄t^̄t^IH$   HHH+HLMIM~( f)HI;}
H$   LH$   HL$``Ic_ H\$ht$xHuI/H;vM^H<    HK HHuHt)^HL$HH\$PHt$I;t
^̄t ^̄t]H\$PHHH+HLMIM~(  f)HI;}HL$HLHT$HHL$`)`Ic_ H\$ht$xHuI/H;v]H<    H HHuHta]H$   H$   Ht.HH;t2]̄t(]̄t]HH$   HHH+HLMIM~*(; fff     f)HI;}
H$   LH$   HL$`3_Ic_ H\$ht$xHLH$   H$   Ht$H;tt\̄tj\̄t`\H$   HHH+HLMIM~'(     fA)HI;}
L$   LH$   HL$`^Mcw Lt$ht$xA   MIHL$8<Mt$L;t[̄t[̄t[L;t$@t,HL$8 MtILHD$8MLl$8Ld$8Lt$@IHH+HLMM~-( IIHHHfff     f) HHuMHT$8HL$`]A݉\$0Dl$X= fff     $  ;/  AA  ~CIL$  ffff     H$   Mf(f(HA;w |E3L$   HT$`I_HHHXHtHH;tjZHHtH;tKZ̄tAZI;t(I: HtH蕋LHD$8MLl$8LH\$@HHH+HLMIM~fHf(fA)HI;|LHT$8H/HL$`ſ    DBH$   ݽ H$  H$   H$0  H$   L$   L$  HT$8H$   H$   H$    Hx H$   F t7H$   H$   l H$  LHAH$    L$   HTl H
4 "L$   L$   H$  H$   L$   L$   IHH+HLMII;}I
If(fXf)HH$   Il0H$   H$   H$   H$   HD$HH$   H$   H$  H$  H$  H$   H$  k\$0É\$0H$   J E3L$  Lt$@Ld$8fW= \$0fn$  H$  H$   L*$  H$  HL$H1*I_H\$hHD$HH$   H$   HL$`HHHAHBHAHBHD$HH$  Ht$PHHH+HHHH~7HfB(f)D$`HL$`gyHD$HfB(fYfB)IL;|LLH$  H$   $  HD$HH$  H$  H$  SH$   H$  H$HT$HH&I| H$   m H$   ^ HL$HR H$   C ($@  ($0  HP  A_A^A]A\_^[@SH0
e e LD$H)t$ Hu5 fTf/ vH H
Dd ~
f  LD$HdufTf/ vHW H
d c~H(t$ H0[HL@WATAUH   HD$0HXHpMHL>pH~H|$`fWD$pHu3L;HH;v
UH    H LHuHtT3LD$HH|$PHt.HH;tT̄tT̄tTH|$PLT$XHHH+HHHHH~5 MtIBHtHHHffA)HH;|LLHT$HIVLd$ LL$HL$   IH=$   $   I      H$   I#I;   H
t HL$Xʸ I$HT$XIHL$Xϸ H t HL$X I$HT$XIHL$X Ht HL$Xp I$HT$XIHL$Xu M$IASHL$HV 2
  HHT$PH   H|$H$   H$   I#I;tHHcH;|   Hs HL$X޷ I$HT$XIHL$X Hs HL$X I$HT$XIHL$X Hs HL$X I$HT$XIHL$X M$IASHl 2#H|$HHZ HL$HK 22L$   I[ Is(IA]A\_HHHWATAUAVAWH  HǄ$  HXHp )p)xD)@D)HD)PD)xD)hD)XMMfD(f(fWo @HH$@  H$   H$   H$X  HHHAHB    HtH$   H33HH$   H$   H$   H$   E3E3H$   I4H$   kA   L$H  $   D$   fEWD
 D[? D ff     D;-, s  I|$   T Ht
HL$pHHHD$pD$(  L$(  HHL$p>]fff     HcI;|$   f(AYfA(AYf(\fA/vH$   #nf(AY"D
x f(fA(H$   jf(H$   H$   H+HH;rԵ H$   4H$   H$   H+HH;r H$   I$HH*H$   H$   H$P  L	LH$0  A    ~ Ht
H$   HHH$   H$  H$  H$      } Ht
H$(  HHH$(  H$@  H$H  H$P  H\$8D$0 D$( H$   HD$ L$(  LD$pH$@  I#   I} Ht
HL$@HHHD$@H\$XH\$`H\$hHT$@IVHT H$  H$  H$(     | Ht
H$  HHH$  H$  H$  ƀ   H$  H@H$  H H$  H@H$  H$  H$(     n| Ht
H$  HHH$  H$  H$  ƀ   H$  H@H$  H H$  H@H$       | Ht
H$  HHH$  H$   H$(  H$0     { Ht
H$8  HHH$8  H$P  H$X  H$`     { Ht
H$h  HHH$h  H$  H$  H$  LL$@L$   H$   H$  {4H H$X  H$0  H$`  H$  H$h  E3MH$X  I-MII  H H$X  H$  胴HL$XHt?Ht$`HH;t-HOHtiz H_H_ H_(HUz H0HL$XEz H\$XH\$`H\$hHL$@,z H$@  Htz H$@  H$H  H$P  H$(  y H$  Hty H$  H$  H$   H$   y H$0  袳H$   Hty H$   H$   H$   HL$pyy D;-&   H$   Ht,H$   HH;tHʯ H(H$   3y H$   H$   H$   H$   y   H; H$X  H$  ޲HL$XHt?Ht$`HH;t-HOHtx H_H_ H_(Hx H0HL$Xx H\$XH\$`H\$hHL$@x H$@  Httx H$@  H$H  H$P  H$(  Ox H$  Ht<x H$  H$  H$   H$   x H$0  H$   Htw H$   H$   H$   HL$pw A   DBH$0  a    DBH$  I fA(H$@  u $ H$   IIPIIPH$  H$   HHT$@H$0   HHT$pH$0   LHj H$   d LH` HH$(  + LHH$    Li HH$   LHH$X   Lpi HH$   Ϭ MHIAH$    H$X   H$  ݬ H$   ά H$(   H$    HL$p HL$@ H$   Hi H$   T IH$   IH$   T H$   H$0  ~ H$   Ht,H$   HH;tH H(H$   xu H$   H$   H$   H$   Su 22L$  I[@IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_@UH@Hl$ HE H]0Hu8H}@LeHHLLBHL;v/FL
MumJ    H=   w9J   HHH;w
HHH| H+LL$ II$J    Hܫ LHuHtEHG3H97IDHH=   MD$I$IL$t	H H]0Hu8H}@LeHHe ]HL$SUVWATH   HD$ IHH@ HHQLAIA I+AHHAH IHOPLGHWLgH   H$      s 3HtH(HHE fW$   L$   IH~QH vfD  HHYHOH9sHH;_rZH2Y HL$(_ HL$P H HD$PHT$(HL$h^ H HD$PHB? HL$Pr HHĐ   A\_^][HHPWATAUH   HD$ HXHhHp LLHHMH$   HH$   H;v H$   H$   HH;v H$   H$   Hl$hHl$0H\$8(D$0fD$0H;vg Hl$hH;t*fffff     HA Hا u	H(H;uHD$0HtH;t H;u.H
 HL$@ HT$@HL$hHL$@ HT$hIn<M$@  I$  I$x  AH$   Ht2H$   H;t H H(H;uH$   H
q 3H$   H$   H$   HL$hp IML$   I[ Ik0Is8IA]A\_HL$UVWATAUAVAWHpHD$ H$   LSLˤ II  3[ LAǆ        AA+iɫA+A  utA  A   uAǆ       AA+iD+E  uEtAA  A   uAǆ     I  I  臆I  I@  I@  vqAp  I  Ix  KI@  I  xI     vo 3HtHHHHsHs Hs(M     Go HtL(HIE IuIu Iu(Ap  A8  M@     o HtL8HIIwIw Iw(LH$   A8  -  fD  HSHuHHK(H+HH{ HH+HH;sL'HGHC    H;v٥ H+Hl$0H|$8HK LkHI+HuH"L;v HtH;+t I+H(D$0fD$@L$   A   HT$@H-LkL;k vY H+HuK LL] IL I;K wHtHE HH;Hs IL$   A8  L;M  HǄ$   HSHuHHK(H+HH{ HH+HH;sHHGHC    H;v H+Hl$0H|$8HK LcHI+HuH"L;vo HtH;+t_ I+H(D$0fD$@L$   A   HT$@Hr,HkH;k v" HHu LLHD I;C wHtH3H;Fs II  辍AMI  Ix  IH$   HpA_A^A]A\_^]HT$WH0HD$ H\$@Ht$XHH3t$PNl HtHHHHsHs Hs(D$P   H  Hx  AL"HH\$@Ht$XH0_H\$Ht$WH HHHxHtHH;t<H;yt%HIТ HtH+nHFHF    HVHH~H\$0HFHt$8H _HLH HPHHWH`HD$0HXHLJ0HL@LC(HIcC(fW C(H\$xH0H\$HH{HtHH;t;HHtH;t;̄t;H;t&Hϡ HtH*mHE3E3LE3H{HHH+HHHH~)(
 fD  Hf(fBWfB)IL;|LLHHL$@ўH$   H`_HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz Hu3H8HH;v:H    Hנ HuHt:3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVI   DBH$    L$   HT$@H>f(D$PHT$hH$   { Hx @HL$h' @t,HT$hH$   O MHIAHL$h t$XHD$XI#I;u+H HD$ L
 LD$PHO H
 X|$8É\$0H$    I      H$   L$  L$  |$8\$0fnF^IL$Hy ufW
H$  fAnt$ Y5Ĵ 
! X
 YXXHL$@ f(($  ($  H  A^A]A\_^[Hl$Ht$H|$ ATH@HqfWILHD$8Ht$(Ht.HH;tq8̄tg8̄t]8H\$P3H;tH	O Ht
HiHHHHwHH+HLMM~(a HHI;f)D|HL$ LHn:LIHH\$PHl$XHt$`H|$hH@A\VHATAUAVH  HD$ HXHhHpHx )p)xD)@D)HD)PD)XD)xD)hIMHfD(fD(fDW
 A   L$P  D9%Z    D-۲ D% D% 3H9^~pfA(AYfA(AYfD(D\3fE/vf(f(HTAYD
2 fA(fA(H(HHHcH;F|MIH#uAD;% fD;%      DBH$      DBH$  v fA(H$   D H$   M] IASM] IASH$  H$  : HH$   H$  ! HHT$xH$   LHE H$h   LfE HHL$PT LHH$@  G L?E HH$   & LHH$    LE HHL$( ME HIAHL$() H$    H$    H$@   HL$P H$h   HL$xՙ H$   ƙ H$   HD HL$( IE HT$(IHL$( H$  Ø H$   2L$  I[ Ik(Is0I{8A(sA({E(CE(KE(SE([E(cE(kIA^A]A\HHHWATAUH  HD$pHXHpMIHHHHL$@ L$  M$LH$   IA$   t`H$   HuLLd$0H$  HD$(Ll$ LL$  HHH$   ؛H^ XE3LH$   HH$   覛L$  HHH H$   2L$  I[(Is0IA]A\_HT$WH0HD$ H\$PHHD$@    HALHHL@IIHlHGLHHL@HMtMtHHIL;tQ2Mt:MtHHIL;t/2MtHHIL;t2IIHcHHGRHH\$PH0_LSVWATAUH  IXE3IILH  IkMsHD$0M{ L$@  HD$ A)sICL4   HHD$(HHGAH+Hl$XH$   f(BYHH$   Ah   H$   HGHHAHGH$  HAHGHAHG HA HG(HA(HG0HA0HG8HA8HG@HA@HH$   H$   HFBY4H+HHL$hHD$PHHHFHAHFHAHFHAHF HA H$   HL$PH$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@H$h  HB@H$   $X  ^ H$   HL$ $  Ll$0Hl$82IMHL;q($  L$8  L$(  H$   H  A]A\_^[LI[IkIs WH   Hj3HHH  HD$0HD$ ICHD$(HtHK3HC8HtH3HAA0H$   HHAHBHAHBHA HBHA(HN@HB HHHHFH$   $   $   HD$8HHL$0HL$HHHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   njHH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$0Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,C=H;}(D$0f@ HHH;f)T|HL$ LLHK=LD$hH- l$hIjH\$`Hl$xH@A\_^H\$WHpI IHLHT$0H)t$`f(P(LOLWt$PLH$   LT$ HD$(IL\$HHH+3HLMM~;fff     II
f(HI;fYDfXDf)D|HT$ HL$@}HL$0 L$   L$   HHH$   (t$`Hp_LMK ECISIKSVWATAUAVAWH  HǄ$P  A)sA){MELHE+H HD$ L
 MCHnD H
' 
fHBD H$   Ԑ IH$   IH$   Ԑ -, $   s $  5 $  = $  P7 $   
C $   MIH$   HHPH$   VHHPH$(  nV$   LC $   $   fWL$HD$@E3D|$DH
D |$@   Ic   $      t$P A;  AAHHL$X H H$   j GLt$8HD$XHD$0H$   HD$(D$ E3ҋH$   I HL$X= AE D$ L
= D$   H= H
 "YHGHHHL$ L
f= EE H= H
 XLt$0HGHD$(GD$ LOLH$   I2H$P  L$h  D$`  L$X  D|$D$   t$Pu?HT$XH$   远HH$(  HL$hJ HL$X?    H$X  H$   }L$   H$   tHH$(  H$  [L$   H$  CLHHL$X
HH$(  BHL$h HL$X H$    H$    fnV f(^H$  H$(  ğL$   H$   ;HH$   H$  ZLf(H$X  LHHL$X
HISHL$h HL$X H$   Ս H$   Ǎ Ɖt$PH
 MIH_L ;L H$P  L$h  D$`  L$X  D$PD|$D$   $   f/   f/$         DBH$  Y HI? H$  \RHH? MRHL$Hf HHܙ /RA}H> H$  RH> H$  QHT$XH$   MHIAHL$X MIASD$@ H$      A}$   |$H   f/$         DBH$  Y HI> H$  \QHH> MQHL$Hf HH= /QHT$XH$   MHIAHL$XÊ MIAS|$HD$@ H$   H$(  AD|$DHWHL$XRHIHL$h] HL$XR H
 bLD$ L
< H< H
L OuH$8   H$(  
 H$    H$    D$H($   ($  H  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/H HD$ L
 L$   Hv? H
'  bkfA/w/Hë HD$ L
 L$  H? H
 ,k̋$  /H HD$ L
u L$  H> H
 ]HHPH$  NIE HPH$p  NfE(D%;   $   fn= YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhH H$   H$   H H$  H$  H$   H  H$  H$  Hu3HH$   JHD$pHHL$xH$   H$   H<= H$    L$  I$H$   IH$    H< H$   І I$H$   IH$   φ Y $   AA   D= D5E D  G D$ L
25 D$0  H5 H
 PM]ICHD$ L
4 DG H4 H
Y lOLd$0IEHD$(AED$ MMME H$  HAuHH$   H$  SHH$p  BH$   ۆ H$   ͆    H$  H$  Lf(H$   HH$p  H$  /SL
8 HL$@LHH$   wHH$p  H$   ? H$   1 H$   " H$    fAnf(
N ^HT$@H$p  TL
 H$   HH$  H$  dRLf(H$  LHH$   HHH$   z H$   l H$   ] H$   O AƙA} &	  fA(MHIfD($  fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(HtD  DX HI;IDH;tHufH*HyX` D^HT$pINfD(Ⱥ   DBH$      H$P  ހ HHl8 H$   HHHu3
H HcHHHW	   H$p   HAH1 HH8 HHH HHu3
H HcHHHW   H$@  K LHu3
HHcHHISA   H$    HfA(HB HH7 HHHu3
H HcHHHW   H$0  ̀ HHH9 HHu3
H HcHHHW   H$`  z HfA(H HH6 zGHHu3
H HcHHHW   H$  ; HHH~ HHu3
H HcHHHWfA(H6 X +fn^5f6 $      CJ Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHu] HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;v HL$`H\$XHt$@H$P  H$X  HH+Hu3$H;vŀ HtH;t$@t H+H($P  f$  L$   A   H$  HL$@+ H\$XHHL$`H;vc HL$`H\$XHt$@HuI E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;v HL$`H\$XHt$@H$`  H$h  HH+Hu3$H;v HtH;t$@tn H+H($`  f$  L$   A   H$  HL$@H\$XHHL$`H;v HL$`H\$XHt$@Hu E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps~ HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;v{~ HL$`H\$XHt$@H$@  H$H  HH+Hu3$H;v?~ HtH;t$@t-~ H+H($@  f$  L$  A   H$  HL$@Ht$XH;t$`v} H\$@Hu} E3LHI;K wHtH3H;Hs} H$   HHT$@PfE/vH02 H$   BE2fE/vH1 H$   BE2AE D;~"fE/wfE/vH1 H$   zBH$   H$  d{ M$HIAH$   | E   fA(A\A^fATf/*1 vmH0 H$   { I$H$   IH$   { H30 H$   u{ I$H$   IH$   t{ HL$XHtD HD$X    HD$`    HD$h    HL$@D H$  xz H$  $   D;$  uoH0/ H$   z I$H$   IH$   z H. H$   z I$H$   IH$   z E2AE$   =	 HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	IC H$  ({ H$p  { H$   { H$  z L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H   cx H      B H   H   H   H   H   H-C6?H   H?H   H-q=H  HMbP?H  Hǃ  '  H      ?H8  H:0yE>H   H(  H@  H     @H0  H     @@HH  HH\$HH0_HT$VWATH`HD$ H$   HHLAL+HgfffffffIHHH?HH;   H)3HH$   HK H$   H$   H$   H;HCHLH\$(3HD$0H~LHSHE%HD$0HyHHL$(KHD$0Ld$(H\$8HD$@    Ld$HHD$PLK(LHT$8HL$HċLLHHSH$   H`A\_^HL@HHUVWATAUAVAWH  HǄ$  HX)p)xILH   @ E3Ht
H$   HIH$   L$   L$  L$     V@ Ht
H$  HIH$  L$0  L$8  L$@     @ Ht
H$  HIH$  L$  L$  L$     ? Ht
H$  HIH$  L$  L$  L$      ? Ht
H$  HIH$  L$   L$(  L$0  H H$   u H$   H$   XH$   u H[ H$   Uu H$   H$   OXH$   Pu LH$  HASAEH$  IE3E3H$  ILL$  H$  HAS(L$8  L+$0  IgfffffffIILIIH?LH$  H+$   IHLIIH?LH$  H+$  IHHHHH?HIIO$Ld$`H$  HtHXIH H$P  t Lc8  A+<  LcH$  HL$8Ld$0LD$(LT$ LLHH$  9   DBH$P  	s H˕ H$   s H-; H$  H$`  H$   H$   H$  s H$   s Hr H$  Qs H$0  Hp H$8  H$  H$@  Ks H$  4s H$   HtHXIH
 H$   r LHH$  fH
 H$  r H$  Hp H$  H$  H$  r H$  r L$  L$   H$  H$   H$  H$   H$       u<MLHH$   \HH$   0MLHH$   
r D$xH H$h  q H H$   q H$   H$P  jp H$   q ^H H$`  7HȋQp HHw 7HHq 
q H$  H$P  p $  D$t0  D$p   t)tttA   A      D,  Hn H$   EL$0  E   H$   HD$PAA+@ 2u H$  H$   p HH$h  H$   p H$   HL$8H\$0HD$(D$ DL$tD3A}HH$0  HL$ L$  LH$   HPHHWH H$   H$   !q Aę|$pu.Lt$ LLIH$   "#LHH$   _$AE;H$  ep +D$xfn^=q% H$h  n @   1  H H$   po H$   H$P  	n H$   jo D$     L
 LD 3H8 HHRH H$   o H$   H$  H$  H$   o LH$  HAS H$   H$P  n HH$h  `n H$   n L$  IE3H$   H$h  5l HH$h  n H$   tn n D$|$  D$p0  D$t   t+tttE3D   E3D   D   ,  H
k H$   D+E3E  H$   HL$PfD  2r H$  H$   m HH$h  H$   m H$   HL$8H\$0HD$(D$  DL$pED5 AzHH$0  HL$ L$  LH$   HPHHUH
 H$   H$   n Aę|$tu.Lt$ LLIH$     LHH$   ]!AE;H$  cm +D$|fn^5o" L$  f(f(H$   BYL$  f(f(H$   %YL$  f(f(H$   YfW   5 HtH$H  HE3E3IH$H  L$`  L$h  L$p  L$  IT$ I+T$Hf(H$H  D<  E"  fAn5x ^H$  H$  H+HHul H$  f(Y?IH$h  HL$`  I+HH   Ld$`J,    ffffff     H$  H+HJ#H;r2l H$  H$h  L$`  I+HH;rl L$`  f(Y/AHHH$h  HL$`  I+HH;s
H$  nL$      tm^H H
lh 0HȋDi HH 0HH   i HH_ 0HHi i H$  g    tH$   g H$  HMpH$  @E H   HMHMIHp  H$H  }  H  H$h  hi L$  IH$  I;vj L$  H$  H$p  H\$`Ht$hI;vuj H$p  H\$PH|$X(D$PfD$PHuMj MLH0I;{ wHtHIH;xs"j H|$X   2 Ht
H$8  HIH$8  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$8  /H$  HH$   H;vi H$  H$   H$   H\$`Ht$hH;vwi H$   H\$PH|$X(D$PfD$PHuOi MLH(I;{ wHtHIH;xs$i H|$X   1 Ht
H$x  HIH$x  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$x  5-H$  H9$  vh H$x  H$   H$   H$8  HH$0  H;vvh H$8  H$0  H$  HL$PH|$XH;vIh H$  HL$`H\$h(D$PfD$P(L$`fL$`($   f$   D$@D$ LL$PLD$`H$   H$x  XH  H$8  =H   H$x   H   H$(  H$  Ht0H$  H;tHf H(H;uH$  H/ L$  L$  L$  H$x  / H$P  HtLH$X  H;t:HYHHt/ L+LkLkHK/ H0HCH;uH$P  {/ L$P  L$X  L$`  H$8  V/ H$`  HtC/ L$`  L$h  L$p  H$H  / H$h  e H$  e H$h  ue H$  fe H6o H$  H$  He H$  H$@  1e H$0  H$  e H$  H$P  Kd H$  Htl. L$  L$  L$  H$  G. H$  H$   &{H$0  {L$  L\$PH$  d H$  H$  H$   Ht2H$(  H;t HWd H(H;uH$   H- L$   L$(  L$0  H$  - H$  Ht/H$  H;tHc H(H;uH$  HX- L$  L$  L$   H$  3- H$  Ht/H$  H;tHc H(H;uH$  H, L$  L$  L$  H$  , H$0  Ht/H$8  H;tH1c H(H;uH$0  H, L$0  L$8  L$@  H$  o, H$   Ht7H$  H;t"     Hb H(H;uH$   H*, L$   L$  L$  H$   , L$  I[HA(sA({IA_A^A]A\_^]HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$07GxfEWfA.zJ  D
 fA/6  HGPLG`HHOPP8MMHHOPs(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  IH$  I#H      H;vHC`  \ ) fD(f/v   HcDw D%w @ HD$0H;t5HKHT$8l$Xk(HKHT$HHK0HT$`HGPLG`HHOPP8MMHHOPs(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  H$  I#H      H;vH#_  \HufA/vEGxAYHufD/v,GxAYGxfA/   fA.tkHD$0H;t6HKHT$8l$Xk(HKHT$HhHK0HT$`ZHL$`V` HL$HK` HL$8@`    H H$   _ HL$xR` H
g HD$xH$   H$   _ Hg HL$x( HM H$   ^ HL$x_ Hf HD$xH$   H$   ^ H HL$x*( HL$`_ HL$Hw_ HL$8l_ L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HVWATH   HD$ HXHh)p)xD)@D)HAIHHHPL@fEWIx ufE(H$   HL$(-fD(=j E3@t;H\$0L9cufA(H$   HL$(<=f(A^HcLg f(A^$   H\$0L9cufA(H$   HL$(<D^DO0DD$(Ld$0Ld$8Ld$@Ld$HHT$(HoHL$@] HL$0] L$   L\$(H\$0Hl$8HOH;uHO$   IHHT$0f(L$   I[(Ik0A(s(|$pE(CE(KIA\_^H\$Hl$H|$ ATH HH
HHt
HEH;   LeHI|$HtH;tHtH;t̄tHt$03H;{t\ Ht
HI(HH3HH{HH+HLMM~#    I$HHI;f(Df)D|LHIHt$0HMHH	H\$8Hl$@H|$HH A\HL$WH0HD$ H\$HHH   `H   Ht$ H   [ HOX\ HOH[ HO8[ HO([ HO[ HOH\$HH0_H%[ HWATAUAVAWH0  HǄ$  HXHhHp)pAAf(LH H(OZ H$  HH$   HH$   GZ IUH$   f"   L$  DH$   If(H H$   Y L$  IH$   IH$   Y    DBH$   X H H$0  Hf( Y H$   H$   X MHIAH$   fY H$   X L$  H|$0H$  Ht$($  D$ $  f(H$   ISI}HH$   HtH;tHtH;t̄tH;_t"HY Ht
H
%HH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   OM]I[   ! Ht
HL$PH3HD$PfW$  L$  HHL$PE3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;vX H\$PH\$@H|$H(D$@f$   Hu}X E3LH<I;{ wHtH3H;xsSX L$   Mu@X E3MI;{ r,X I.HAHIEIcH;p=H$  ̹     Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM VLHAS   DBH$   U H= H$0  HAU$U HH H$   H$   nU LHHAH$   V E3E9}$I  D  MEIUH$   {E3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;vV H\$PH\$@H|$H(D$@f$   HumV E3LH<I;{ wHtH3H;xsCV L$   Mu0V E3MI;{ rV I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM  UAE;}$}=HM
 H$   T HH$   HH$   T H$   S H$   Ht HǄ$       HǄ$       HǄ$       H$    HL$hHt HD$h    HD$p    HD$x    HL$P{ H$   T H$   T 3L$0  I[0Ik8Is@A(sIA_A^A]A\_HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   ,HSH=H_HGPLG`HHOPP8L$   MMHHOP蚱HHL$@]s(HGPHHOPf(X9   ~7ff     HGHLt$(Ll$    LGPHHOH;   |s(HGPHHOPX$   HH$   H#H      H;vHQ  \f(J f(5\_ f/vNHOhf/v?HD$@H;t5HKHT$Hl$hk(HKHT$XHK0HT$pf/vf(s(HGPHHOPX   W0fWh HWf(IHL$pR HL$XR HL$HR IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      )HSI;I|$ID$PMD$`HIL$PP8L$  MMHIL$P+HH$   H$   H$P  H$   H$  H$   H$  ID$PLH$   IL$PP(H$   HHHu33H;vHHQ HHuHtH$   H$   H$   HHtH;tHtH;t̄tH;t*P HtHHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   #H$   HHu3=HH;vHHO HHuHtH$   H$   H$   HtH;tHtH;t̄t~H;t*zO HtHHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   It$(Hu39HH;vH    HN HHuHtH$   H$   I\$(HtHH;tvHHtH;tW̄tMH;t*IN HtHHH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ ɽfEWfA($   w(ID$PHIL$PfD(DX3퉬$  D%Y D$   A$   A$   D-c A9$   |  Db D:l fH$   H$  D$   HuH5HH;+  H4    HL HHu	H  HL$pH\$xHt(HH;      H;t%L HtHHHD$pHHL$pH\$xHHH+HLMHM~(I f)HI;}HL$pLHT$pH$  HNJ  fAW$  IL$hRfA/  H$   H;tAHOH$   $   o(HOH$   HO0H$   Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   ISH$   H;Z  HWH$   o($   HWH$   HW0H$     H$P  H;tAHOH$X  $x  o(HOH$h  HO0H$  Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I5H$P  H;tAHWH$X  o($x  HWH$h  HW0H$    A$   $  f/vSH$  H$  $  $8  H$  H$(  jH$  H$@  Un\< f(IL$hf/vQH$  H$  !$  $8  H$  H$(  H$  H$@  H$  H$   pf($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$pIM$L$   L$   H$   IASHt:HL$pH E$   E9$   }=HL$pG HL$pG ̋$  A$   fn$   ^H$  H;tAHOH$  $8  o(HOH$(  eHO0H$@  Tw(ID$PHIL$PXA$   AT$0fAWIT$f(H$  H
H$   G H$   F H$   F H$   F H$  F H$  F H$  F H$@  F H$(  F H$  F H$  tF H$h  fF H$X  XF H$   IF H$   ;F H$   -F HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   HSH/H_HG`LGpHHO`P8L$   MMHHO`ʢHHL$@荽s(HG`HHO`f(X9   ~7ff     HGXLt$(Ll$    LG`HHOX;   |s(HG`HHO`X$   HH$   H#H      H;vHB  \f(z f(5P f/vNHOxf/v?HD$@H;t5HKHT$HOl$hk(HKHT$X6HK0HT$p(f/vf(s(HG`HHO`X   W0fWY HWf(IHL$pC HL$XC HL$HC IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      HSI,I|$ID$`MD$pHIL$`P8L$  MMHIL$`[HH$   H$   H$P  H$   H$  H$   H$  ٺID$`LH$   IL$`P(H$   HHHu33H;vGHHIB HHuHt'H$   H$   H$   HHtH;tHtH;t̄tH;t*A HtH(
HH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   SH$   HHu3=HH;vHHA HHuHtH$   H$   H$   HtH;tHtH;t̄tH;t*@ HtHHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   1It$(Hu39HH;vH    H? HHuHtH$   H$   I\$(HtHH;tHHtH;t̄t}H;t*y? HtH
HH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ fEWfA($   w(ID$`HIL$`fD(DX3퉬$  D%J D$   A$   A$   D-BT A9$   |  DT Dj] fH$   H$  D$   HuH5HH;+  H4    H(> HHu	H  HL$pH\$xHt(HH;      H;t%= HtH(	HHD$pHHL$pH\$xHHH+HLMHM~(: f)HI;}HL$pLHT$pH$  H~;  fAW$  IL$x肺fA/  H$   H;tAHOH$   	$   o(HOH$   HO0H$   Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   IcH$   H;Z  HWH$   >o($   HWH$   HW0H$     H$P  H;tAHOH$X  $x  o(HOH$h  HO0H$  Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   IEH$P  H;tAHWH$X  %o($x  HWH$h  HW0H$    A$   $  f/vSH$  H$  $  $8  H$  H$(  H$  H$@  n\l f(IL$x輷f/vQH$  H$  Q$  $8  H$  H$(  *H$  H$@  H$  H$   蠴f($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$pyM$L$   L$   H$   IASHt:HL$pO9 E$   E9$   }=+%HL$p9 HL$p9 ̋$  A$   fn$   ^H$  H;tAHOH$  $8  o(HOH$(  HO0H$@  w(ID$`HIL$`XA$   AT$0fAWIT$f(H$  H=H$   68 H$   '8 H$   8 H$   	8 H$  7 H$  7 H$  7 H$@  7 H$(  7 H$  7 H$  7 H$h  7 H$X  7 H$   y7 H$   k7 H$   ]7 HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   &HSHJ H_HGhLGxHHOhP8L$   MMHHOhHHL$@轮s(HGhHHOhf(X9   ~7ff     HG`Lt$(Ll$    LGhHHO`;   |s(HGhHHOhX$   HH$   H#H      H;vH3  \f(  f(5A f/vQH   f/v?HD$@H;t5HKHT$H|l$hk(HKHT$XcHK0HT$pUf/vf(s(HGhHHOhX   W0fWJ HWf(IHL$p5 HL$X5 HL$H4 IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      HSII|$ID$hMD$xHIL$hP8L$  MMHIL$h苑HH$   KH$   H$P  5H$   H$  H$   H$  	ID$hLH$   IL$hP(H$   HHHu33H;vwHHy3 HHuHtWH$   H$   H$   HHtH;t HtH;t̄tH;t*2 HtHXHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   胢H$   HHu3=HH;vJHHL2 HHuHt*H$   H$   H$   HtH;tHtH;t̄tH;t*1 HtH5HH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   aIt$(Hu39HH;v.H    H,1 HHuHt
H$   H$   I\$(HtHH;tHHtH;t̄tH;t*0 HtHHH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ )fEWfA($   w(ID$hHIL$hfD(DX3퉬$  D%; D$   A$   A$   D-rE A9$     DKE DN fH$   H$  D$   HuH5HH;;  H4    HX/ HHu	H  HL$pH\$xHt(HH;      H;t%. HtHXHHD$pHHL$pH\$xHHH+HLMHM~(, f)HI;}HL$pLHT$pH$  H,  fAW$  I$   诫fA/  H$   H;tAHOH$   6$   o(HOH$   HO0H$   Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   IpH$   H;Z  HWH$   ko($   HWH$   LHW0H$   ;  H$P  H;tAHOH$X  $x  o(HOH$h  HO0H$  Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   IRH$P  H;tAHWH$X  Ro($x  HWH$h  3HW0H$  "  A$   $  f/vSH$  H$  $  $8  H$  H$(  H$  H$@  q\  f(I$   f/vQH$  H$  {$  $8  H$  H$(  TH$  H$@  ?H$  H$   ʥf($   H$   H$  H$  H$  L$   IHH+HLMHM~1ffff     HD$pH$   f(fXf)HI;|H$  HL$p虜M$L$   L$   H$   IASHt:HL$po* E$   E9$   }=KE?9HL$p5* HL$p(* ̋$  A$   fn$   ^H$  H;tAHOH$  $8  o(HOH$(  HO0H$@  w(ID$hHIL$hXA$   AT$0fAWIT$f(H$  H]H$   V) H$   G) H$   8) H$   )) H$  ) H$  ) H$  ( H$@  ( H$(  ( H$  ( H$  ( H$h  ( H$X  ( H$   ( H$   ( H$   }( HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]Ht$WH0HD$`HHHD$ D$@    Y    t@W H   HVxH\$H6"H\$H   ^nx   ,;L   HHt$PH0_H\$WH0HD$`HHHD$ D$@        tS HWxH   !HH\$HH0_HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0'   fEWfA.zU  D
 fA/A  HG`LGpHHO`P8MMHHO`s(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  IH$  I#H      H;vH-$  \   fD(f/v   HcD; D%n; HD$0H;t5HKHT$8l$Xk(HKHT$HHK0HT$`HG`LGpHHO`P8MMHHO`ۂs(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  H$  I#H      H;vH#  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$8cl$Xk(HKHT$HJHK0HT$`<HL$`8$ HL$H-$ HL$8"$    H H$   " HL$x4$ H* HD$xH$   H$   " HI HL$xc  H/ H$   " HL$x# H* HD$xH$   H$   " H HL$x  HL$`d# HL$HY# HL$8N# L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0   fEWfA.zU  D
 fA/A  HGhLGxHHOhP8MMHHOhs(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  IH$  I#H      H;vH  \   fD(f/v   HcDg7 D%.7 HD$0H;t5HKHT$8fl$Xk(HKHT$HMHK0HT$`?HGhLGxHHOhP8MMHHOh~s(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  H$  I#H      H;vH  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$8#l$Xk(HKHT$H
HK0HT$`HL$` HL$H HL$8    H~ H$    HL$x H& HD$xH$   H$    H	 HL$x#  H H$   Y HL$x HU& HD$xH$   H$   R H HL$x  HL$`$ HL$H HL$8 L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxY=_ n     fWf/vf* f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;t۷HHtH;t轷t贷H;^t)HN HtHHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVILL$   H$   HԹ2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxYm]      fWf/v( f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;tHHtH;ttH;^t)HN HtH7HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI|L$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   H> It EL   H> IX H5& fWD E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMH HtHrHEHLmHH}PHHH+HLMIM~)(
4 @ Hf(fWHEHf)HI;|LHUHH$   H   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   #$@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   $0  H  HUxH$8  HL$(HD$ L$@  L$H  H$0  AY$0  $8  f/v
H$0  H$8  L    A$   L     A$   H  H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM r#t[Eu7A   H$ I HD诱話裱HL$x HL$h G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;t蝰HHtH;t~̄ttH;\$pt$HL$hi HtHHD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   L$   L$   I^HtHH;t趯HHtH;t藯̄t药H;$   t$HL$x HtHHD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   L$   I|$ uf(H$0  H$     fD(HD$hH$   H|$p tH$0  H$   ef(f(  f(EtIH   ALD$hHT$xHSf($0  H$0  HMXY   ux'H   E3LD$hHT$xH
L   L]xMHUHHmp\mhfT- (  f/vA      @  fA/vA   x   f/vA
   bH  H9   rA(   JH0  5) Yf/vA    H>#H  Yf/vA   HL$xS HL$hG AL$   A(sA({E(CIA_A^A]A\_^][HWH`HD$ HXHhHpHHPHoHHD$0HXHHtH;t贬HtH;t蟬̄t蕬3H;_tH Ht
HHH7H_HHH+HLMM~2(
 fffff     HE f(fWHf)HI;|LHHL$(HL$P H\$pHl$xH$   H`_HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YZR      fWf/v f/v   fD/v	D   f/v   $   f/v  H   HL$   I\$HtHH;tHHtH;tڪtѪH;^t)HN HtH$HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIiL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YP      fWf/v f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;t(HHtH;t
tH;^t)HN HtHTHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI~L$   H$   H12L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YN      fWf/v f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;tXHHtH;t:t1H;^t)HN)
 HtHHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI|L$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YL      fWf/v f/v   fD/v	D  f/v  $   f/v  H   HL$   I\$HtHH;t舥HHtH;tjtaH;^t)HNY HtHHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIzL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\LUVWATAUAVAWH  HǄ$X  I[A)sA){LHHAE3HxH,  II(IKI0>) ACHL4I      ?=   LFHIIHHT$0LD$8Ht$HLD$PIH+HH$   H$   H$   HL$0HHHAHBHAHBHAHBHA HB L$   H$   HH$  HEH$  H$  H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$  L$  L$  H$  H$   rLHFIIN|LFLIIIH$   L$   H$   IH$   IH+HH$   H$   L$   H$   HIHAIBHAIBHAIBHA IB H$   L$  H$   HIHAIBHAIBHAIBHA IB HA(IB(HA0IB0HA8IB8HA@IB@$  $P  HNH+IH+IHIHD$0Hl$8Hl$@Ht$HHT$PH$@  HL$0HHHAHBHAHBHAHBHA HB L$  H$  H$@  IT$H+I$HHT$XHl$`Ld$pIL$HL$xHT$XHH$0  * LFIIHHHT$XLD$`Ht$pMLD$xIH+HH$   H$  L$  HL$XHIHAIBHAIBHAIBHA IB L$@  IL$H+I$HH\$0Hl$8Ld$HID$HD$PH$   L$   H$   L$   L+JH$`  H$h  H$x  H$   HHHAHBHAHBHAHBHA HB L$  H$  H$`  HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$0Nf(YY$   H$   H$   L$   ID$H$   H$  H$   tIT$HH+I$HHL$XHl$`Ld$pHT$xHVLHIIH$   H$   H$   H$   HH+HH$   H$  L$  H$   HIHAIAHAIAHAIAHA IA H$@  HNH+HHHI+IH$  HD$ LL$XL$   lML^HJ$  BDI$B4IIHL;L$  I[HA(sA({IA_A^A]A\_^]HVWATAUAVHP  HǄ$   HXHh )p)xLHq3H  H~fW=" I.MfLkIHIHD HD$ H|$(Lt$8Ld$@HT HT$pH$   L$   HǄ$      HDHD$HH|$PH\$XLt$`Ld$hID$H\ H~iYҹ   H;}IHYXHA   I}&3ɐH;}IHYXHIf(\Xf/   f(  $  ID$HD H   H   H$   HL$pHHHAHBHAHBHAHBHA HB L$   H$   HL$H$  L$  HT$ HH$   H~H$  HL$ nIHL;3HHL$P  I[@IkHA(sA({IA^A]A\_^HVWATAUAVH0  HD$ HXHh )p)xLHq3H  H~fW=k   IN LkI.HHIHD H$   H$   H$   H*IFHBIFHBIFHBHJ H$   H$   HD H$   H$   H$   H*IFHBIFHBIFHBHJ HǄ$     HDHD$0H|$8H\$@HT$HH*IFHBIFHBIFHBHJ HD$hHD$pLaLB\ H   L$   AYҹ   H$  H    J
 H;} YXHHA   I}(3ID  H;}YXHHIf(\Xf/   f(  $h  BD H   H   H$   H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$   H$h  HL$0$`  L$`  H$   HOH$   H~H$h  H$   kIHL;wHHL$0  I[@IkHA(sA({IA^A]A\_^HWH  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HAd
 A\ HD$8LT$@D$HHT$0HL$ XP  HQLL$0HT$8HI HHH$   H$   IBH$   H$   HHHQLQHCHAHC HA H$   H$   LH$   H$   HT$0HH$   LL\$PHCHD$XHL$hLHAHCHAHCHAHC HA H$   H$   HD$0HD$ H$  HD$(HT$PHL$  L$   HL$0HIHAICHAIC$  HHD$PHCHD$XHL$hHHHCHAHCHAHCHAHC HA H$   H$   HD$PHD$ H$  HD$(H$   HL$ {L$   HIHFICHFICHFICHF IC HT$XHL$0HHHAHBHAHBD$xL$   H$   HL$QL$  L$  H$   HH$x   L$  I[Is I_HHPVWATAUAVH   HD$0HXHh IHL3퉬$   A(D$ L
L M@HK H
q 2(LHSIHtgHI      Ic$   H$   I#I;w
IL;r/H& HD$(H HD$ LHZ| H
#q =IL$LHT$X胫HWLHD$@Ld$HIt$HuH9HH;v蚔H    H HHuHtvHHwI\$HtI;tUHtI;t@̄t6H;t2 Ht
HHH/H_HHH+HLMM~.fff     I$IE f(fXHf)HI;|LHHL$8HL$h HL$   I[@IkHIA^A]A\_^@SH HHP  諮HH [HSH   HD$ )pHZHX @LB@HPHHHHD$0H\$8H{ ufWH$   HL$(@Kf(HL$h f(($   HĐ   [HHPVWATAUAVH@HD$0HXHh IHH@    H$   Hh諲A   Dt$p       S H   H      ^   ,A;ALƉ   LGHWHH  wt]LHH      ^,A;ALƉ   Y8 п     H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   HhD$p       tuS H   H   LGHWHH  vt@LHH   Y7      H   H   HHHH$   H@A]A\_^]HHPVWATAUAVH@HD$0HXHh IHH@    H$   HhkA   Dt$p       S H   H      ^   ,A;ALƉ   LGHWHH  t]LHH      ^,A;ALƉ   Y6      H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   HhD$p       tuS H   H   wLGHWHH   t@LHH   Y5 ڼ     H   H   HHHH$   H@A]A\_^]HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhD
 fAWA   DBHXf H H$@  iHM  HT$@H$0  H L$  MHIAHL$@ L$   $    t2H$  HD$0Lt$(H$  HD$ MU HH$(  k2$  E3fW L   ~<EtACu,H HL$@6 IHT$@IHL$@< HDFhfAWE f(HV@I袛IH9^@~@f     H~8IE I+EHH;r IMHHHH;^@|Ћ$(  EuH    u2H     utA  HO HL$@] HT$@H$0   HL$@] H      H$   c HHI H$@  lHHuI
H HcHHHWHH HH 4   H$    HH H$@  
HHuI
H HcHHHW   H$    LHuI
HHcHHISAL$  AH HHp 藶   H$   d HHZ H$@  mHHuI
H HcHHHW   H$   - LHuI
HHcHHISAHG f(H2 HH܈ HFHD$HHx uf(H$  HL$@C莸  f(   H$    HH H$@  蠵HHuI
H HcHHHW   HL$pc LHuI
HHcHHISAf(Hp HH" 9
   H$   HH H$@  HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H HH 衴
   H$   n HH| H$@  wHHuI
H HcHHHW   H$   7 LHuI
HHcHHISA   H@ HH 	H     H$    HH H$@  سHHuI
H HcHHHWHH HH 蠳H H$@  茳HH    HHv mHT$@H$0  Z MHIAHL$@ H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  E$  Ex.H HL$@e IHT$@IHL$@k 2Hڅ HL$@7 IHT$@IHL$@= AF   EH$0  H$LH HL$@ MHIAHL$@ H$0   H$0   AL$  A(sA({E(CIA_A^A]A\_^][HHXHhHpWH   )pp  )xX  IIHL
7 LJ D)@DH  D)H@    DP  3ʴ  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ 
h  Dd  D`  ,  H  Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
18 L: D)@DH  D)H@    DP  3躳  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ 	L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
a8 L* D)@DH  D)H@    DP  3課  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
8 L D)@DH  D)H@    DP  3蚱  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ Jh  Dd  D`  ,  H   Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q(~5L5 fWHMf(f(-AAID;m(|LHT$(H
HHXHHtH;t襁HtH;t萁̄t膁H;_tH~ Ht
HٲHH7H_HHH+HLMM~!    HE f(Hf)HI;|LHH(WHL$( L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA(D$ L
G DB(H$ H
\ 蠯L[L\$ L
 EE(H H
\ 艮Ic](H\$HfW|$XHu3H9HH;vH<    H HHuHtHL$hH\$pHt.II;t̄t̄tIH\$pHHH+HLM3M~( f)HI;}HL$hLHT$hHL$@Ic](H\$HH\$P|$XHHHu3/H;v9L$    I7 HHuMtHL$xH$   H$   HtWHtIHHH;t~HtIHHH;t~HtIHHH;t~H$   H$   HHH+HLM3M~ ( @ f)HI;}HL$xLHT$xHL$@ɀIc}(H|$H|$XHu3/H;v&~H4    H$ HHuHt~H$   H$   Ht.HH;t}̄t}̄t}HH$   HHH+HLMM~$( HIHHHff) HHuLH$   HL$@Ic}(H|$H|$XH赮LH$   H$   Ht$H;t}̄t}̄t
}H$   HHH+HLM3M~"(2 ffA)HI;}
L$   LH$   HL$@2Mcu(Lt$H|$XA   MIHL$0Mt$L;tw|̄tm|̄tc|L;t$8t,HL$0X MtI賭LHD$0E3Ld$0Ld$0Lt$8IHH+HLMM~-(X IIHHHfff     f) HHuMHT$0HL$@P~E3D$  D|$`5     $  D;9  3A9u(~I3L$  ffffff     H$   Mf(f(;HA;u(|D$  L$   HT$@IzHHXHtHH;t{HHtH;tz̄tzI;t(I HtH@LHD$0E3Ld$0LH\$8HHH+HLM3M~Hf(fA)HI;|LHT$0HPHL$@s    DBH$    H$  H$   H$0  H$   L$   L$  HT$0H$   pH$   H$   J Hx H$    t7H$   H$    H$  LHAH$    L$   H H
U BL\$hL$   H$  H$   L$   LL$pIHH+HLM3ҐI;}IIf(fXf)HH$   I QE3H$   D  E;](}QE3    E;=IcIcL$   LLHL$xH$   YBXBAAAD$  H$    L$  H$   Lt$8Ld$0D$  fW5| fn$  H$  HL$hJHD$xH$   H$  H$   H$   HD$HH$   HD$Pt$XHT$@H$   襈M]L\$@H$   HL$@HHHAHBHD$xHD$@(D$@fD$@HD$@H$   H$  H$   H$   H$   HHHAHBHAHBHAHBH$   H$   \HT$hH$  HG<HT$xH*=I8 H$   ) H HL$x HL$h ($@  ($0  HP  A_A^A]A\_^[HT$UVWH0HD$ H\$`HHD$P    HHpHu39HH;vvH<    H HHuHt`vHHsHE HxHHtH;t2vHtH;tv̄tvH;t Ht
HjHH    H{HHHH\$`H0_^]HT$UVWHPHD$ H\$pIHǄ$       IH@HT$(3HHHqHu39HH;v\uH    HZ HHuHt8uHHwHE HXHHtH;t
uHtH;tt̄ttH;t Ht
HBHH    H_HHHL$8 HH\$pHP_^]HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz(Hu3H8HH;v)tH    H' HuHtt3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVIv   DBH$    L$   HT$@Hwf(D$PHT$hH$    Hx @HL$hw @t,HT$hH$    MHIAHL$hF t$XHD$XI#I;u+H HD$ L
 LD$PH܈ H
EO hX|$8É\$0H$   2 I      H$   L$  L$  |$8\$0fnF^I^f(XHL$@ f(($  ($  H  A^A]A\_^[HWATAUH  HǄ$   HXHhHp )p)xD)@D)HEIHH3H\$@H\$HH\$PHT$(LD$0fWI9Xuf(H$8  HL$ 警f(D fE(D^H$8  Hl$(DL$0L$8  H$   HL$!ȖLHNHL$(HL$0HT$`HD$ HH
HHHJHHHJH@HBI=H$   LHL@IMtMtIHIL;tqMt:MtIHIL;tpMtIHIL;tpIIHL$@蛢HT$XHL$@<:H$    E   Ht$(H~ tH$8  HL$ 6f(^D^HD$@H$8  HD$@HD$(DD$0L$8  HT$XHL$!tHHHLIHHLAMtMtIHIL;t pMt:MtIHIL;toMtIHIL;toIIH葡HH֎HL$x 0  fA(LHT$XHL$@HL$@H$8  L$8  H$   HHT$ Hz<HLHL@MtMtIHIL;toMt:MtIHIL;tnMtIHIL;tnIIH诠LOLOIHH+HLMM~Hf(Hf)HI;|HHDHL$  H$   y HL$hm H$8  Hl$(DL$0L$8  HT$XHL$!zL$8  L$8  HHBHL$x HL$@ f(L$  I[ Ik0Is8A(sA({E(CE(KIA]A\_HLH VWATAUH(  L$x  IE3LIMo  HXHhH$p  LpLxL$  )p(5 IHǀ@   LD$pHMHL$xIH+H$       H$   L)H$x  f)$   f)$   f)$   IL$x  H$x  f)$   f)$   f)$   HMH$   HH$  f)$   f)$   HD$hH$  LD$`LD$XHD$PHD$H D$@H\$8L|$0A   H\$(Hl$ ' E3MH~JL    IPHIIfD  H;}JHĐ   XDDIIL;|H$h  H;MHL+ILHD$pHH$x  IT H$  HD$hH$  LT$`LT$XHD$PHD$H D$@H\$8L|$0LD$(LHl$ IHl$xH$   H    HIHD$pI;A    ($  L$   L$`  H$X  H$P  H(  A]A\_^HWHp  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HA A\ LT$8HD$@D$HHT$0HL$ *  HILL$0HL$@HHH$   IBH$   H$   H$   HHLQHCHAHCHAHC HA H$   H$   HL$PHHHBHAHBHAHBHAHB HA L$   H$   HL$P[HT$0H;H$`   LL\$PHCHD$`HL$hLHCHAHCHAHCHAHC HA HǄ$      HD$0HD$ H$  HD$(H$   HL$PHHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$ 
/HH$   HCH$   H$  HHHCHAHCHAHCHAHC HA HǄ$0     H$   HD$ H$  HD$(HT$XHL$0HHHAHBHAHBl$xHT$PHL$ iL\$XHIHFICHFICHFICHF IC $   LD$0H$   HL$QL$  L$  H$   HJ8H$H   L$p  I[Is I_LMK ECISIKSVWATAUAVAWHP  HǄ$p  A)sA){MELHE+Hm HD$ L
Y MCH H
C zH H$   D IH$   IH$   D - $   
 $   5 $   = $   r $   
 $   MIH0$   HHPH$   蓋HHPH$@  ~$   ~ $   $   fWL$HD$@E3D|$DH
 |$@   Icĸ   $      t$P A;  AAHHL$X H` H$   GLt$8HD$XHD$0H$  HD$(D$ E3ҋXH$   HL$X AE(D$ L
=y D$  Hy H
A 蒔HGHHHL$ L
x EE(Hy H
A wLt$0HGHD$(GD$ LOLH$   I;2H$  L$  D$  L$  D|$D$   t$Pu?HT$XH$   OHH$@  n/HL$h HL$X    H$x  H$   
L$   H$  HHH$@  H$  |L$   H$  HLHHL$X3GHH$@  ,HL$h HL$X H$    H$   fn  f(^H$  H$@  4L$   H$  GHH$   H$  賌Lf(H$x  GLHHL$XFHI.HL$h_ HL$XT H$   E H$  7 Ɖt$PH
 MIHLo ;Lf H$  L$  D$  L$  D$PD|$D$   $   f/   f/$         DBH$   Hz H$   ̍HHz 轍HL$H HHL 蟍A}H:z H$   腍Hz H$   oHT$XH$  \ MHIAHL$X MIASD$@ H$  .    A}$   |$H   f/$         DBH$   Hy H$   ̌HHy 轌HL$H HH@y 蟌HT$XH$   MHIAHL$X3 MIAS|$HD$@ H$  X H$@  'AD|$DHWHL$X#HI)HL$h HL$X H
 bLD$ L
Bx H#x H
< 述H$P   H$@  z H$   k H$   ] D$H($@  ($0  HP  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/Hi HD$ L
U L$   Hz H
; ҦfA/w/H3 HD$ L
 L$(  Hz H
; 蜦̋$0  /H HD$ L
 L$0  H6z H
W; HHPH$   ̓IE HPH$P  跃fE(D% w  $   fn= YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhHC H$p   H$  ^ Hn H$  H$p  H$   H H$  H$  XHu3HH$   HD$pHHL$xH$   H$   Hx H$   ~ L$8  I$H$   IH$   u H.x H$   @ I$H$   IH$   ?  $   AA   D= D5 D  G(D$ L
p D$H  H{p H
,9 M]ICHD$ L
;p DG(Hhp H
9 ܊Ld$0IEHD$(AED$ MMME H$   HAu?HT$@H$   HH$P  'HL$PQ HL$@F    H$  H$   Lf(H$   `@HH$P  H$  L
-t H$  0@LHHL$@>HH$P  $HL$P HL$@ H$    H$    fAnf(艉  ^H$  H$P  L
e H$   (?HH$   H$  PLf(H$  l?LHHL$@|>HH%HL$P HL$@ H$    H$    AƙA} +	  fA(MHIfD($   fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(Ht$ff     DX HI;IDH;tHufH*HyX1 D^HT$pIfD(Ⱥ   DBH$0  z    H$`  ^ HHs H$@  gHHu3
H HcHHHW	   H$    HAH HHs HH Wz HHu3
H HcHHHW   H$P  ˼ LHu3
HHcHHISA   H$    HfA(H¼ HHs 苃HHu3
H HcHHHW   H$0  L HH"VH HHu3
H HcHHHW   H$   HfA(H1 HHwr HHu3
H HcHHHW   H$@   HHUH( HHu3
H HcHHHWfA(H ؼ +fn^5q $      Å  Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHuݼ HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;v HL$`H\$XHt$@H$  H$  HH+Hu3$H;vE HtH;t$@t3 H+H($  f$  L$   A   H$  HL$@;H\$XHHL$`H;v HL$`H\$XHt$@Huɻ E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;v< HL$`H\$XHt$@H$   H$   HH+Hu3$H;v  HtH;t$@t H+H($   f$  L$   A   H$  HL$@f:H\$XHHL$`H;v HL$`H\$XHt$@Hu E3HL$`H\$XHD$@LHT I;S wHtH3H;PsJ HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;v HL$`H\$XHt$@H$   H$  HH+Hu3$H;v HtH;t$@t H+H($   f$  L$   A   H$  HL$@%9Ht$XH;t$`vc H\$@HuS E3LHI;K wHtH3H;Hs) H$@  HHT$@PfE/vHm H$@  K~E2fE/vHrm H$@  -~E2AE D;~"fE/wfE/vHm H$@  }H$   H$0   M$HIAH$    E   fA(A\A^fATf/l vmH9l H$   + I$H$   IH$   * Hk H$    I$H$   IH$    HL$XHt`  HD$X    HD$`    HD$h    HL$@;  H$0   H$  $   D;$0  uoHj H$   b I$H$   IH$   a H*j H$   , I$H$   IH$   + E2AE$   = HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	I;  H$`   H$P   H$0   H$   } L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   H It EL   H IX H5 fWDo E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMH HtHrHEHLmHH}PHHH+HLMIM~)(
4 @ Hf(fWHEHf)HI;|LHUHH$   H   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   #$@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   т$0  H   HUxH$8  HL$(HD$ L$@  L$H  H$0  cAY$0  $8  f/v
H$0  H$8  L    A$   L      A$   H   H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM rt[Eu7A   H$m I HDLLLHL$x HL$h G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;tKHHtH;t~K̄ttKH;\$pt$HL$hi HtH|HD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   3L$   L$   I^HtHH;tJHHtH;tJ̄tJH;$   t$HL$x HtH{HD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   3L$   I|$ uf(H$0  H$   虎w  fD(HD$hH$   H|$p tH$0  H$   ef(f(w  f(EtIH   ALD$hHT$xH#f($0  H$0  HMXY   ux'H   E3LD$hHT$xHL   L]xMHUHH mp\mhfT-   f/vA         fA/vA   x   f/vA
   bH   H9   rA(   JH]  5 Yf/vA    H达(  Yf/vA   HL$xS HL$hG AL$   A(sA({E(CIA_A^A]A\_^][LD$SUVWATAUAVAWH   HǄ$   )$   IHHHHXE3I;XtIʭ Ht
H%yHL7H_LnL$   HM H  HH;  Hl$HHUH$(  HEH$8  H$(  L$8  H;IMHHD$(P D$8HT$ HL$HWL]L\$PHEHD$XfWt$`HT$HH2UMeM  L$0  fffff     LHN MSL+M+Ԁ~    HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$ 蝭   HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$ LEIIHE HHT$ LD$(Hl$8LD$@HHxI+HIH+HHD$pH|$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H|$Pt$`H$0  L|$pAtH/IHHكH$(  H$0  H$(  H;HMHHH+HH+HL,CLE3HT$pHL$H4GI;}=D$`fIIH+HHHff     f)HHuLMHT$pHL$HFIsE3L$        HHXHI+L;  LEIIHE HHT$ LD$(Hl$8LD$@I+HIH+HHD$pH\$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H\$Pt$`H$0  Ll$pAtH/IHHكH$(  H$0  H$(  H;HMH8HH+HH+HL$GLE3HT$pHL$HEI;}>D$`fIL IH+HHHff     f)HHuLMHT$pHL$H]EIL$   HL@HMt:MtHHIL;tBMtHHIL;t~BIIMHKtLELD$(LMLL$0MtWMtHHIL;t8BMtHHIL;tBMtHHIL;tAIIHsHT$ HI]H>  @ LHN MSL+L+D8v   HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$ 荨   HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$ H($   H   A_A^A]A\_^][HWATAUAVAWH@  HǄ$   HXHhHp)pAAf(LHT^ H H$  HH$   HH$    IUH$      L$  DH$   If(H] H$    L$  IH$   IH$       DBH$0   H^] H$@  jHf( H$   H$0   MHIAH$   & H$0  _ L$  H|$0H$  Ht$($  D$ $  f(H$   II}HH$   HtH;t>HtH;t>̄tz>H;_t"Hr Ht
HoHH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   M]I[   l  Ht
HL$PH3HD$PfW$  L$  HHL$PJE3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;ve H\$PH\$@H|$H(D$@f$   Hu= E3LH<I;{ wHtH3H;xs L$   Mu  E3MI;{ r I.HAHIEIcH;p=H$  ND̹   ck  Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM 覡LHAS   DBH$0  ] HY H$@  `gHAU$۟ HHY DgH$   H$0  . LHHAH$   Ҡ E3E9}$I  D  MEIUH$   KE3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;vU H\$PH\$@H|$H(D$@f$   Hu- E3LH<I;{ wHtH3H;xs L$   Mu E3MI;{ rܠ I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM AE;}$}AH
X H$   G HH$   HH$   G H$0   H$   Hth  HǄ$       HǄ$       HǄ$       H$   ph  HL$hHt`h  HD$h    HD$p    HD$x    HL$P;h  H$    H$    3L$@  I[0Ik8Is@A(sIA_A^A]A\_HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhDδ fAWA   DBHX& H7 H$@  )dHM C HT$@H$0   L$  MHIAHL$@ L$   $    t2H$  HD$0Lt$(H$  HD$ MU HH賝$(  k2$  E3fW L   ~<EtACu,H6 HL$@ IHT$@IHL$@ HDFhfAWE f(HV@IbFIH9^@~@f     H~8IE I+EHH;r IMHHHH;^@|Ћ$(  EuH    u2H     utA  H9 HL$@ HT$@H$0   HL$@ H      H$   # HH)6 H$@  ,bHHuI
H HcHHHWHHc HH5 a   H$    HH5 H$@  aHHuI
H HcHHHW   H$    LHuI
HHcHHISAL$  AH HHP5 Wa   H$   $ HH:5 H$@  -aHHuI
H HcHHHW   H$    LHuI
HHcHHISAHf(H HH4 `HFHD$HHx uf(H$  HL$@zNc  f(   H$   W HHu4 H$@  ``HHuI
H HcHHHW   HL$p# LHuI
HHcHHISAf(H0 HH4 _
   H$  Ɨ HH3 H$@  _HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H HHr3 a_
   H$   . HH\3 H$@  7_HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H  HH2 ^H     H$    HH2 H$@  ^HHuI
H HcHHHWHHϖ HH2 `^H2 H$@  L^HH   l HHV2 -^HT$@H$0   MHIAHL$@ H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  輗E$  Ex.H1 HL$@% IHT$@IHL$@+ 2H1 HL$@ IHT$@IHL$@ AF   EH$0  HDLH1 HL$@ MHIAHL$@ H$0   H$0  ߕ AL$  A(sA({E(CIA_A^A]A\_^][@USVWATAUAVAWH(  Hl$pHǅ   )   A0uxHA HE8HHE(HB HELzL}hLaHHE0L}XLeHL  ML Mu    H A   L H HHHH   H   H  I;HMH	HM H~H3IHHM 3I;}LII~IHL,IIH    H  HIHIHHH;v0L4    HI   w9H   HHH;wHHHf  H+H\$pHHH  -I HH  HuMt/HI     H   H      HH;vU/H4    H   w2H   HHH;wHHH#f  H+Lt$pIIH LHuHt.H      H  MLU3M  3H}HE HLMIHU`HIHHUpLE0LEPfffff     HHU@HEXL]@L;IMH0H+3HD$8HD$0Ld$(Ht$ IH  x3LHU MM  ff     3K</H  HEHH  L;HMHI+HEIHM0LHT$8HT$0H\$(Ht$ LMH  H  AvHE HMHM;HMHM(JLt$h3HL$`HL$XHD$PHD$Ht$@H HD$8Ht$0H\$(HEHD$ L  LE8H  MLHEJHU8H   LL}(Lt$@HMxHL$8Ht$0H\$(HD$ H  LLIH  3LH} I;H}HM@LEPLEpLEPH}`H}L}hI;HE LULM.    t
I    t	H (   H   A_A^A]A\_^[]@WH@HD$ H\$PHl$XHt$`HHHHXHu36HH;v(,H<    H& HuHt,HD$(H\$0LD$(HHHL$(H\$PHl$XHt$`H@_H%ӑ @VAVH(  HqLH }H(  A^^降H$   H$  H$  HHǄ$H     L$  HL$   H$H  )$   HǄ$P     HHHHH$@  HHH$@  H$P  HMH9   HN3L(L$@  H  5 MHIMFH$@  H$H  I;H$H  HHMILt$8HI@LD$@HHH+HD$ I@H+HT$(HT$0HT$XHHHl$PLt$`HLD$hHl$xHD$HHH$   L$   L$   IHHHHL$ HD$poH   H   HL$ H$   HHHAHBHAHBHAHBHA H$   HB HT$HخHL$pH$   $H  HL$H  HHAHBHAHBHAHBHA H$   HB HT$H"IIH;HL$   L$  H$  ($   H$  H$   H(  A^^HH\$Ht$WH LBHHHMtHHIL;t(IMIZLGLOMt\MtHHIL;t(Mt:Mt5HHIL;tv(MtHHIL;tY(IHI)ZLK3LKIHH+HHLMM~ D  HHHI;f(Df)D|HH
HC.HH@ƉsH\$0Ht$8H _HL$WH0HD$ H\$HHHLJLB3HHAHAMtDHMtHHIL;tr'MtHHIL;tU'IIH%YC HH%HH\$HH0_@SH HHD$8    H4HH [HWATAUH   HD$(HXHhHp EIHHHYHu36HH;v&L$    I HuMt}&HD$0H\$8HT$0HŁHt$@HNH$   HVHT$ H$   LD$ H;IML IMtM;t&H$   HT$ H$   LD$ H;IMHHtI;t%̄t%H;]t%HM ʋ HtH%WHE HE     H]HT$@H&Ht$@LFIHH$   HVHT$ H$   LL$ H;IMHHtI;tM%IHH$   HT$ H$   LD$ H;IMHHtI;t%̄t%H;_t"H Ht
HYVHH    H_HT$@HE   HFHt$PHL$0HL$XD$` HHD$hHD$p   LFMtMtIHIL;tu$Mt:MtIHIL;tS$MtIHIL;t6$IIMHVHHL$PHL$0 L$   I[(Ik0Is8IA]A\_HVWATH   HD$ HXHh)pIHHZ IHu3,I;v#H<    H HuHtu#HD$(H\$03H~;fWfffffff     HH$   XHD$(HH;|$0|HM@HT$PH$   H$   HD$@HD$(HD$HH|$0Ht$HH;t"̄t"H;} tIHMĈ Ht2I;v"H4    H HuHt"HEHE    H} HUHL$8*HL$Pg HL$([ L$   I[ Ik0(t$pIA\_^HUVWATAUAVAWH   HD$0HX )p)xD)@HLA   AAHjHHtH;t!̄t!3H;i t!HI HtHSIEIuIm H  HIMH HE   HLLIASMELD$@MMLL$HW D$PMtWMtHHIL;t !MtHHIL;t!MtHHIL;t IIIRMMMMIHH+HLMHM~&(] fffff     IE f)HI;|IHL$8#Au8AE<E}=I  LKLCMtMtHHIL;tC Mt:MtHHIL;t! MtHHIL;t IIIQLKLCMt:MtHHIL;tMtHHIL;tIII~QHICLl$@H$  HL$8$   fWf.zuo $   Ll$@D$HHT$8I~SH}H$  HIM(3EME(IUI"E3IMH!  = D? H;  HH+H<  H   HH+HHHHf     ME(IEBTfTfTLfTDfTXfTAYf/rNLME(IEBTfTfTLfTfTXfTAYf/rNLME(IEBfTfTfTDfTXfTAYf/rNME(IEBTfTfTLfTDfTXfTAYf/rNLH HH;}GIM(IEfTfTLfTfTXfTAYf/rLHH;|H|]IE(HLAf.zyuwf.z8u6Af.z%u#Af.zuHH HH;H5H0H  IE(HLf.zuHHH   H   IHHkL;   H_H|]IE(HLAf.ztmf.zt*Af.zt"Af.ztHH H~H2H,H&H~!IE(HLf.ztHHHEtIE IHl$(HD$ LLIU(IM'E3HHkL;EM8AE8   A9u8   IH$  H       IEH
Iɸ   H;    f/vf(HHH;|H   LIEJHH;tHHEt^IUIM HIHHD$8HT$@Ll$PHT$XHHHHD$`HT$hLl$xH$   E3HT$8HL$`E3HHH;(H$   IM_AE<E}=IL$   I[XA(sA({E(CIA_A^A]A\_^]HL$VWATAUAVH0HD$ H\$hHl$pELHLJLB3H1HqHqMtDHMtHHIL;tMtHHIL;tIIHKI|$IHuH,I;vH,    H HuHtHCH{ I|$H~H   Ht/I;vtH,    Hr HHuHtPHs(H{0C< EIHHH\$hHl$pH0A^A]A\_^HL@HPHHSVWATAUAVAWH`  HǄ$  )p)xD)@D)HMHL   nG  HtHL$8H33HHD$8H\$PH\$XH\$`   :G  Ht
HL$xHHHD$xH$   H$   H$   H\$(HD$xHD$ LL$8MHI>fD($   H~ H+~HH$   H$   H$   HtNHt"HHHHH;tHHtHHHH;tLLMt3} IIH$   H$   H$   HH$   H$   H+HHtCH;rU} H$   HH$   HHH$   H$   H+HH;rH~ H+~HHuH6HH;vL$    I| HuMtHD$hH|$pHHD$XHL$PH+HHt6H;r| HL$PHHD$hHHHD$XHL$PH+HH;rHT$hH$   H~ H+~H   E  Ht
H$   HHH$   fWD$0LD$0HH$   "5 Ds= D$   =Y= fD/  Y5 t$0fD/   H$   HtFD  H$   H$   H$   H$   !D  HL$h{ H$   { H$   HtC  H$   H$   H$   HL$xC  HL$PHtC  H\$PH\$XH\$`HL$8C  fA(  HHF H+FHHtlH;rz LfLl$hH$   H$   H+HH;rz H$   f(AYL A\HHF H+FHH;rH\$ LL$8MH$   Ief(|3L$  H$  L$  D$   t$0D$   $   :HHF H+FHHtgfD  H$   L$   I+HH;ry L$   HF H+FHH;ry HNIHHHF H+FHH;rH$   Ht)B  H$   H$   H$   H$   B  HL$hty H$   ey H$   HtA  H$   H$   H$   HL$xA  HL$PHtA  H\$PH\$XH\$`HL$8A  f(L$`  A(sA({E(CE(KIA_A^A]A\_^[HL@UVWATAUAVAWHP
  HǄ$  HX )p)xD)@D)HD)xMMLH   DǸ   $
  H$ 	  v Hd H$  7w Hǖ H$p  H u H$x  H$  H$  *w H$  w H' H$0  v H$P  Ht H$X  H$0  H$`  v H$0  v D]    AA+iA+L$
  AM utAE A}  uA}   AA+iD+E]uEtAAEA} uA}]H HIZHIMU]fW$
  I\$   ?  3Ht
H$   HHH$   L$
  HH$   I\$H$8  $H  HuH;HH;v}H4    H{v HHuHtY3HL$`H\$hHHt$H;t.̄t$̄tH\$hHHH+HLMHM~ (Ds @ f)HI;}HL$`LHT$`H$0  F$
  I\$0I+\$(H   V>  Ht
H$   HHH$   L$
  HH$   1$   >  Ht
H$`  HHH$`  H$x  H$  H$     =  Ht
H$  HHH$  H$  H$  H$  HUH$  s H$  r H$  H$
  HUpH$  >H$  H$
  HU0H$  =L$  L$
  H	 H$  H$  H$  =H$  H$X  >H$  &H$  <  H$  
H$  <  H H$  r tH H$  p    H= H$  [r tH, H$  rp mDǺ   H$  q    H$  q HT$pH$  q HH$  q HL$pZr H$  q Hb H$0  r H H$  H$	  H$   H$0  H$(  r H$0  q       H$
  H$  tG$
  f.zuL$  IHL$`iH$  HD$ MMHT$`JH$  HL$pwq t$8\$0H$  HL$(H$  HL$ MMHT$`Hu[HT$pH$ 	  ap HH$  @r Hx H$  HH$  p HW H$  n:  3H9\$h~VHD$`H$
  H$   H$   H+HH;rq H$   H$
  HHHHcH;D$h|H$(  lp H<z H$  H$X  H$
  H$  H$  H$X  H$  H H$  H$  ($  f$0  ($  f$  L$0  L$  H$  H$X  H$  A9  3H$  H$  H$X  "9  H$  H$
  H$  hH$  8  H$  ko N9  Ht
H$   HHH$   H$   H$   H$   Ht$8D$0D$(H$   HD$ L$   L$   IIgZ     H[n H
l Vn HH< 5HH5n 7n    (  H H$  rn H H$  H;l H$  H$  H$  en H$  Nn L$  L\$(t$ f(L$   H$   I HT$pH$ 	  Jm HH
k im HHgm im HL$pm AAFINH$   TH$  m H=w H$  H$   Ht7  H$   H$   H$   H$   6  H$  _m H$  Ht6  H$  H$  H$  H$  6  H$x  Ht6  H$x  H$  H$  H$`  k6  H$  HtX6  H$  H$   H$(  H$   36  HL$`m H$   Ht6  H$   H$   H$   H$   5  H$`  dl H$P  H$  Ml H$p  H$ 	  ~k 3/3  H$  i H$  i    X    tAD    DEH   r	H   H   A@   H$  Hi       t1H  r	H   H   A@   DH$  	i H> H$  Lk H܊ H$  H$  H$  H$  H$  >k H$  'k D   A	  (  ,  $  At*AtAtAt3   3      DH  D8  D@  D  $
  0  $
  4  $
      t@Hh H$  0HH 0HHi i H$  cy   t@H H$   f0HH W0HHi i H$   yj $   I\$H$8  $H  H/6LH$  H$  Ht.HH;t̄t̄tzH$  HHH+HLMM~*(g I@HHff     fA)IHuLH$  H$0  L$0  Hf H$8  L$  L$  HT$`H$0  ?ryi +$   fDnE= D^H<h H
}f 7h H H
if .Hh H
Vf h Hh H
Bf g H H
.f .HH .Hg H
f g Hg H
e g H H
e _.HfA(yg HH B.HHpg rg fnYAYH H
e .Hf()g HH -HH g "g H H
Te -H g H
Ae f Hf H
-e f HD H$  2g H H$  Hd H$  H$  H$  %g H$  g Hn H$0  f H$  H$  H$   H$0  H$(  f H$0  f H H$  f LH$   H$  $  g            	0  Ht
HL$pH3HD$p3H$   H$   H$   H H$  f H$  HL$pIH$  f AEHT$pI^H H$  e L$  H$  HL$p^H$  e HL$p$
  D$8$
  D$0$  D$(t$ MLD$`IHL$pL$  L\$@H$  HD$8H$  HD$0|$(DL$ $
  DEfA(HL$p蛿$
  $  ^            .  Ht
HL$pH3HD$p3H$   H$   H$   H H$  d H$  HL$pGH$  d AEHT$pIH H$0  >d L$0  H$  HL$pH$0  4d HL$pI
$
  D$8$
  D$0$  D$(t$ MLD$`IHL$p_L$  L\$@H$  HD$8H$  HD$0|$(DL$ DEfA(HL$pI   HؐH$  c H=Ym H$  H$(  kc H$  H$  Tc H$  H$  5d H$  .c H$  H$  ` H$  ` H$   Htq,  3H$   H$   H$   H$   J,  H$  b H$  Ht(,  H$  H$  H$  H$  ,  H$x  Ht+  H$x  H$  H$  H$`  +  H$  Ht+  H$  H$   H$(  H$   +  HL$`c H$   Htt+  H$   H$   H$   H$   O+  H$`  a H$P  H$  a H$p  H$ 	  ` 3(  A
  (  \
  H H
(_ 'HH` ` H H
_ 'HH$  ` HH` `     t3H H
^ C'HH   c` HHa` c` ,  H} H
^ 	'Hm_ HH+` -` 0  H^ H
W^ &Hf(_ HH_ _ 8  H6 H
^ &Hf(_ HH_ _ @  H H
] b&Hf(}_ HH_ _ H  H H
] *&Hf(E_ HHK_ M_ P  H H
w] %Hf(
_ HH_ _ X  H H
?] %Hf(^ HH^ ^ `  Hp H
	] %Hȋ^ HH^ ^ ] HO H
\ S%Hȋ] HHv^ x^     >  H H$  %HH %HH6^ 8^ H$  mH H$  $HH $HH $HH ] HH] ] H H$  $HH v$HHX g$HH ] HH] ] Hd H$  3$HH $$HH $HH 5] HH3] 5] Hz H$  #HHC #HHL #HH$  \ HH\ \ ,  Hh H$  #HH x#HH i#H[ HH\ \ 0  HF H$  1#HH "#HH #Hf(.\ HH4\ 6\ 8  H H$  "HHh "HH "Hf([ HH[ [ @  H H$  "HH t"HH~ e"Hf([ HH[ [ H  HY H$  ,"HH "HH/ "Hf()[ HH/[ 1[ P  H
 H$  !HH !HH !Hf(Z HHZ Z X  H H$  ~!HHD o!HH `!Hf({Z HHZ Z `  Hn H$  )!HH !HHD !HȋY HH.Z 0Z ] H& H$   HH  HH  HȋY HHY Y H$  CiH$  yHv H$0  Z H$0  H$  
=H$0  Z AEH$  IdHy HL$pY LD$pH$  H$  gHL$pY H$  $
  ,  $  HPW H$0  H$  LL$   IH$0  H$   H$  iHc`  H$  0  $  8  $  P  $  @  $   X  $(  H  $   HVHcH$  H-z HL$pX Hx H$  H$  H$  HT$pH$  ~X HL$pjX L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  IUd$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(IIXH$  OU 3Ht$8D$0D$(H$`  HD$ L$   L$   IIBIN8H$`  AvhH$  IW H=a H$  H$0  L
H$      HJ H
T >HHlV nV HO H
T HH$  :V HH8V :V     t3H H
cT HH   U HHU U ,  H H
)T HU HHU U 0  H H
S mHf(U HHU U 8  H H
S 5Hf(PU HHVU XU @  H H
S Hf(U HHU  U H  HY H
JS Hf(T HHT T P  H1 H
S Hf(T HHT T X  H	 H
R UHf(pT HHvT xT ] H H
R "HȋS HHET GT       HW H$  HH HHT T H$  jcL H H$  _L( H H$  DLm H H$  )L$  H H$  +D,  D$
  L$
  Hf H$  +0  $
  L$
  HI H$  +8  $
  L$
  H, H$  ',@  $
  L$
  H H$  Z,H  $
  L$
  H H$  ,P  $
  L$
  H H$  ,X  $
  L$
  H H$  ,D] D$
  L$
  H H$  +-H$  aH$  qHq HL$p^R HT$pH$  [5HL$p_R AEH$  IH
 H$0  R L$0  H$  H$  H$0  R H$  $
  ,  $  HO H$  H$  LL$   IH$  H$   H$  贇0  $  8  $  P  $  @  $   X  $  H  $  HHcH$  Hr HL$pP Hxp H$  H$  H$  HT$pH$  P HL$pP L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  I$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(IIdPH$  M 3Ht$8D$0D$(H$`  HD$ L$   L$   II=;IN8H$`  LAvhH$  O H=xY H$  H$  H$  S  C  HY H
"M HHN N       H H$  lHH: ]HHN N H$  ]Lq H: H$  L H7 H$  L H4 H$  L$  H, H$  &D] D$
  L$
  H H$  (H$  N]H$  mH HL$pN HT$pH$  1HL$pN AEH$  IxH
 H$0  M L$0  H$  H$  uH$0  M H$  H$  mHt$ L$  L$   H$   I5f(f(\5uZ H H
'K Hf(L HHL L f(\f(D
0T fAT^D fA/  A   _Q fD(E3L$   H$   If($      H H
J IH$0  J HH
hJ Hȋ`K HHR HH$  J HHN H
'J HHgHf(K f(A\H: H
I nHf(K HH; RHK H
I ~K H
I J 
   ǀ       f(H$  3K HȲ,1Ht$8D$0D$(H$`  HD$ L$   L$   II6H HL$pXK LD$pH$  H$`  HL$pQK f(A\f(fAT^fA/#L$
  Ht$8D$0D$(H$`  HD$ L$   L$   IIa6IN8H$`  pA~h    tdf(H$  'J HȲ,%H HL$pJ LD$pH$  H$`  HHL$p|J H$  H H$  Ht  H$  H$  H$  H$    H=T H=S H$  J H$  H$  G H$  G H$   Ht[  H$   H$   H$   H$   6  H$  I H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$     HL$`I H$   Ht`  H$   H$   H$   H$   ;  H$`  H H$P  H$  H H$p  H$ 	  G 3{  HH$   H$   H+HHt?H;rAI H$   HHD$`HHH$   H$   H+HH;r   t,H   E Hл   DK>DH$  rE        t@H H$  HH 
HH%G 'G H$  V   t@HR H$   
HH 
HHF F H$  qVx  tuD(  I|$ u_tZHm HL$pF H$  3H HN H$  HT$pH$  F HH H$  _  f(f(HT$`H$H    HgS H$
  ,   t-H' H
@D HHE E 3ۉ,  3Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$
  MIHH~R H$
  H H$H  H$P  F H$  E H=O H$  H$  4C H$  %C H$   Ht  H$   H$   H$   H$     H$  NE H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`  Z  H$  HtG  H$  H$   H$(  H$   "  HL$`E H$   Ht  H$   H$   H$   H$   
  H$`  SD H$P  H$  <D H$p  H$ 	  mC 3  t(ttǄ$
  '  333ۉ$
  	$
  3ۍ$
  A@   tdy]
  HcH@(
 
 HMIH$  3HH$  dLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  51  MIH$  =4HH$  |Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHKH$  0B  MIH$  uHH$  tLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  0  MIH$  MHH$  Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  m0  MIH$  tHH$  Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  50z  MIH$  tHH$  Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  /  MIH$  u:HH$  p  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  !Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ;  MIH$  ;HH$  Up  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  "Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH
H$  ;  MIH$  HH$  L$P  L\$ L$p  LD$`HH$  LRLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHKH$  ;B  MIH$  HH$  L$P  L\$ L$p  LD$`HH$  RLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  +?  MIH$  cqHH$  L$P  L\$ L$p  LD$`HH$  RLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  I?   MIH$  QqHH$  L$P  L\$ L$p  LD$`HH$  6SLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  CH H$H  H$P  < H$  
; H=D H$  H$  |8 H$  m8 H$   HtF  H$   H$   H$   H$   !  H$  : H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$   j  HL$`: H$   HtK  H$   H$   H$   H$   &  H$`  9 H$P  H$  9 H$p  H$ 	  8 3iHJ HL$p79 H$  x: H@ H$  HT$pH$  -9 H@ H$  H H$    L$P
  I[XA(sA({E(CE(KE(SIA_A^A]A\_^]
 
 H
 
 x
 
 
 
 
 H
 

 
 W
  	
H   HD$0LH  L@  L  H  HD$(LT$ ItNH HL$87 HL$`8 H? HD$`HT$8HL$x7 H HL$`  3HĨ   %5 %5 %5 %5 %5 %5 %5 %5 %t5 %f5 %8 %8 %8 %8 %8 %8 %8 %8 %8 %r8 %d8 H\$Ht$WH Ht*DAL
       @t	HK3   HCv  @tH   HH\$0Ht$8H _%7 %7 %7 %7 %7 %n7 %87 %*7 %7 %6 %6 %6 %6 @SH HH
 v6 HD$8HuHj6 ~     H
 H6 HD$8H
 66 HD$@H@6 HLD$@HT$8<  HHL$8 6 H HL$@6 Ho      HH [H(GHH(@SH    5 HH5 H( H HuC#H#   H
  H
  3H [HHXHhHxL` AUAVAWH 3ML;8   ;#  Dn eH%0   HXH;t  2 3Hd uA   L t   [    H
Q 4 LH;   H
0 4 MLHHI;rZH9} tl4 H9E tHM |4 HS4 HE H
 `4 H
 HP4 L;uL;tLLI4 4 H H = D;   H={    3      eH%0   HXH;t  0 3H: u   # ;t   3  >HS H
S       ;uHcS H
9       ;u
HH H9= t!H
   ;tMĺ   I     H\$@Hl$HH|$PLd$XH A_A^A]HHXHpHxATH0IL   X5 u9# u
3ۉX   tu3H HtЋ؉D$ tLƋI4؉D$    LƋI  ؉D$ u5u1L3I  L3IL MtL3IAӅtu7LƋI#ˋىL$ tH HtLƋIЋ؉D$ 3ۉ\$ C H\$@Ht$HH|$PH0A\H\$Ht$WH IHug  LǋHH\$0Ht$8H _H\$DD$HL$VWATH@IALHك|$pxI+H\$`H H\$hH@A\_^HLH D@HPSVWATH8MIcH` HHHHX|$pxH+H\$`HAD$    H8A\_^[%1 %1 %0 %0 H
 8  H\$WH HGA H=@A HHtHH;rH\$0H _H\$WH HA H=A HHtHH;rH\$0H _HMZ  f9t3HcH<H39PE  u  f9QLcA<E3LLA@EXJL EtQL;r
AL;rAH(E;r3HH(LL
,Ijt"M+IIHt@$Ѓ3H(%p/ %b/ %L/ %>/ H(uH=+  uc,    H(H\$WH H Hd$0 H2-+  H;tHH vHL$0+ H\$0+ DI3+ DI3+ HL$8DI3+ L\$8L3H  L#H3-+  L;LDL
 IL H\$@H _%V. %/ %B. ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H@UH HHM(- H ]@UH HHM(- H ]@UH HHM(m- H ]@UH HHM(M- H ]@UH HHM(-- H ]@UH HHMh
- H ]@UH HHM(, H ]@UH HHM(, H ]@UH HHM(, H ]@UH HHM(, H ]HT$UH HHM0HPHH
w0 H	2 HE@ H ]HT$UH HHMpHPHH
?0 H	F2 H@ H ]HT$UH HHM@HPHH
/ H	2 H? H ]HT$UH HHM`HPHH
/ H	1 H? H ]HT$UH HHM HPHH
/ H	1 HE? H ]HT$UH HHM(HPHH
O/ H	F1 H? H ]HT$UH HHM8HPHH
/ H	1 H> H ]HT$UH HHMHHPHH
. H	0 H> H ]HT$UH HHMXHPHH
. H	0 HE> H ]HT$UH HHMhHPHH
g. H	F0 H> H ]HT$UH HHMxHPHH
/0 H	0 H= H ]HT$UH HHdR H
/ H	/ H= H ]@UH HHMPm) H ]@UH HHM@H ]@UH HEHt
eHHM@H ]@UH HHM@( H ]@UH HExtexHMp( H ]@UH HHM(( H ]@UH HH   ( H ]@UH HH   j( H ]@UH HHM(=( H ]@UH HHMPe' H ]@UH HHM(' H ]@UH HH   "' H ]@UH HH   ' H ]@UH HH   ' H ]@UH HHM }' H ]@UH HHM ]' H ]@UH HHM =' H ]@UH HHM m( H ]@UH HHM M( H ]@UH HHM -( H ]@UH HHM 
( H ]@UH HHM`' H ]@UH HHM ' H ]@UH HHM ' H ]@UH HHM ' H ]@UH HHM`m' H ]@UH HHM % H ]@UH HHMp%% H ]@UH HHMH% H ]@UH HH   % H ]@UH HH   z% H ]@UH HH   Z% H ]@UH HH   :% H ]@UH HH   % H ]@UH HHM($ H ]@UH HHMP& H ]@UH HHM($ H ]@UH HHMP% H ]@UH HHMP计H ]@UH HH   苡H ]@UH HHMhH ]@UH HHM`H ]@UH HHMPH ]@UH HHMPH ]@UH HH   [H ]@UH Hꋅ   t   H   GH ]@UH HHMPH ]@UH HHMPH ]@UH HH   H ]@UH Hꋅ   t   H   H ]@UH Hꋅ  t  H  G<H ]@UH HHMP.H ]@UH HHMP.H ]@UH HH   H ]@UH HH   H ]@UH HHM H ]@UH HHM H ]@UH HH  H ]@UH HHM nH ]@UH HH   KH ]@UH HH   ;H ]@UH HHMPH ]@UH HHMPH ]@UH HH   H ]@UH Hꋅ   t   H   H ]@UH Hꋅ  t  H  ':H ]@UH HHMPH ]@UH HHMPH ]@UH HH   H ]@UH HH   H ]@UH HHM H ]@UH HHM H ]@UH HH  kH ]@UH HHM NH ]@UH HH   +H ]@UH HH   8H ]@UH HHMPH ]@UH HHMPH ]@UH HH   {H ]@UH Hꋅ   t   H   gH ]HT$UH HHt HHEHHH\ H ]@UH HHM H ]@UH HHM H ]@UH HH    H ]@UH HH    H ]@UH HHM`H ]@UH HHM`>H ]@UH HH(  Z H ]@UH HHM H ]@UH HHM H ]@UH HHM H ]@UH HH    H ]@UH HH    H ]@UH HHM`H ]@UH HHM`>H ]@UH HH(  Z H ]@UH HHM H ]@UH HHM H ]@UH HHM H ]@UH HH    H ]@UH HH    H ]@UH HHM`H ]@UH HHM`>H ]@UH HH(  Z H ]@UH HHM H ]@UH HHM H ]@UH HHM H ]@UH HH    H ]@UH HH    H ]@UH HHM`H ]@UH HHM`>H ]@UH HH(  Z H ]@UH HHM H ]@UH HHM H ]@UH HHM H ]@UH HH   H ]@UH Hꋅ   t   H   ǿH ]@UH HHMX H ]@UH HH   j H ]@UH HH   J H ]@UH HHM H ]@UH HHMH5H ]@UH HHMH5H ]@UH HHMP~5H ]@UH HH   [5H ]@UH HHMH.5H ]@UH HHMH5H ]@UH HHMP4H ]@UH HHMP4H ]@UH HHMPH ]@UH HHMP螋H ]@UH HHM ~H ]@UH HHM ^H ]@UH HH   ;H ]@UH HHMPH ]@UH HHMPH ]@UH HHM H ]@UH HHM 變H ]@UH HH   苊H ]@UH HHM@^H ]@UH HHM@H ]@UH Hꋅ  t  H   H ]@UH HH   H ]@UH HH   H ]@UH HH  H ]@UH HH   /H ]@UH HHX   H ]@UH HH   K/H ]@UH HH  j H ]@UH HHM@H ]@UH HHM@H ]@UH HHM@H ]@UH Hꋅ  t  H   gH ]@UH HH   {H ]@UH HH   {H ]@UH HH  ;H ]@UH HH   .H ]@UH HHX  : H ]@UH HH   -H ]@UH HH   H ]@UH HHM@H ]@UH HH   {H ]@UH HH   +H ]@UH HH   ;H ]@UH HH   H ]@UH HH@  : H ]@UH HHMh H ]@UH HHMhH ]@UH HHMhH ]@UH HHMhNH ]@UH HHMh^H ]@UH HHMh} H ]@UH HHMh] H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   kH ]@UH HH   
H ]@UH HH   +H ]@UH HH   H ]@UH HHM@H ]@UH HHM@H ]@UH HHM@~H ]@UH HHM@H ]@UH HHM@H ]@UH HH   KH ]@UH HH   +H ]@UH HHM H ]@UH HHM ރH ]@UH HH   H ]@UH Hꋅ  t  H   臃H ]@UH HHMPnH ]@UH HHMPnH ]@UH HH   KH ]@UH HH   +H ]@UH HHM0H ]@UH HHM0޾H ]@UH HHM`H ]@UH HHM`螾H ]@UH HH   {H ]HT$UH HN"L L0    | Y3  H; H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   諽H ]@UH HHMhnH ]@UH HHMhnH ]@UH HHM8.H ]@UH HHM8.H ]@UH HH   H ]@UH HH   H ]HT$UH H L7 L "    4  HzC H ]@UH HHM ^H ]@UH HHM 螲H ]@UH HH   H ]@UH HH   [H ]@UH HH   H ]@UH HH   H ]@UH HH    H ]@UH HHM`ޱH ]@UH HHM`^H ]@UH HHM`>H ]@UH HH   H ]@UH HHM H ]@UH HH   H ]@UH HHMp޺H ]@UH HHM8H ]@UH HHM8螺H ]@UH HH   [H ]@UH HH   [H ]@UH HH  ˤH ]@UH HH  +H ]@UH HHP   H ]@UH HH   k H ]@UH HH   KH ]@UH HH   {H ]@UH HH   {&H ]@UH HH   H ]@UH HH   ;&H ]@UH HHM0讣H ]@UH HHM0H H ]@UH HH   kH ]@UH HHM0HPH ]@UH HHM0.H ]@UH HH0  H ]@UH HH0  H WH ]@UH HH   ˢH ]@UH HH0  HPH ]@UH HH0  H ]@UH HH@  kH ]@UH HH`   H ]@UH HEhtehH   H ]@UH HH`  H ]@UH HH   ۡH ]@UH HH  軡H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   KH ]@UH HHM`.H ]@UH HHM`>H ]@UH HHM`H ]@UH HHM`H ]@UH HHM0H ]HT$UH HLG L 2~    $  Hf H ]@UH HH   kH ]@UH HH   KH ]@UH HHMPH ]@UH HHMP^H ]@UH HHM H ]@UH HHM H ]@UH HH   H ]@UH HH   {H ]@UH HHM ^H ]@UH HHMP>H ]@UH HHM H ]@UH HHM ^H ]@UH HH    H ]@UH HH    H ]@UH HHM`H ]@UH HHM`~H ]@UH HH(   H ]@UH HHM >H ]@UH HHM`H ]@UH HHM0H ]@UH HHM0H ]@UH HHMHH ]@UH HHMHnH ]@UH HH   KH ]@UH HHM .H ]@UH HHM H ]@UH HH   H ]@UH HH   H ]@UH HHp  H ]@UH HHp  {H ]@UH HH  H ]@UH HH  ;H ]@UH HH  KH ]@UH HH  苧H ]@UH HH   H ]HT$UH HLw L{ by v  , !  H H ]@UH HH   WH ]HT$UH HL Lp{ x w   !  H H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHM jH ]HT$UH HL Lz x   ̀ "  H
 H ]@UH HH   蛥H ]HT$UH H.L Lz w   \ d#  Ha H ]@UH HH  H ]@UH HH  H ]@UH HHp  H ]@UH HHM@H ]HT$UH0HH
 H0]HT$UH0HH* H0]HT$UH0HHJ H0]HT$UH0HHj H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HHʤ H0]HT$UH0HH H0]HT$UH0HH
 H0]HT$UH0HH* H0]HT$UH0HHJ H0]HT$UH0HHj H0]HT$UH0HH H0]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM@  H ]@UH Hꋅ`  t`  HP  6  H ]@UH HHM@~H ]@UH HHM(^H ]@UH HHM(>H ]HT$UATH(HHUpHHcHHA     HU H(A\]@UH HHM(ޞH ]@UH HHM(辞H ]@UH HHM(螽H ]HT$SUH(HHUpHHcHHA     H H(][@UH HHM(>H ]@UH HHM`  H ]@UH HHM8  H ]@UH HH   R  H ]@UH HHMh]  H ]@UH HHM(  H ]@UH HHMH  H ]@UH HH   B  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HHM }  H ]@UH HHM ]  H ]@UH HHM =  H ]@UH HHM   H ]@UH HHM   H ]HT$UH HHMHHt
H   33[H ]HT$UH HHMHHt
H   33H ]HT$UH H33H ]@UH HH     H ]@UH HHMh  H ]@UH HHM(M  H ]@UH HH   "  H ]@UH HHM(  H ]@UH HH     H ]@UH HHMP  H ]@UH HHMH]  H ]@UH HHM =  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HH     H ]@UH HHMH}  H ]@UH HHM ]  H ]@UH HHMH=  H ]@UH HHM   H ]@UH HHMH  H ]@UH HHM@螌H ]@UH HHM@  H ]@UH HHM@}  H ]@UH HHM@ދH ]HT$UH HHMH־33H ]@UH HH     H ]@UH HHM8
  H ]@UH HH    H ]@UH HHM`  H ]HT$UH H33>H ]@UH HHM@  H ]@UH HHM@ދH ]@UH HHM@H ]@UH HHM@}  H ]@UH HHUXHM(JqH ]HT$SUWH HH]PH}`H;t@ H  H(H;u33YH _][@UH HHM0  H ]@UH HH   HM(pH ]HT$SUWH HH   H   H;tHE  H(H;u33ǼH _][@UH HHM@H ]@UH HHM@=  H ]@UH HHM@辊H ]@UH HHM@>H ]@UH HHMHH ]@UH HHM`  H ]@UH HHM8M  H ]@UH HEXteXHM@HxlH ]@UH HHM@"H ]@UH HHU(HM0oH ]HT$SUWH HH]XH}PH;t@ H  H(H;u33)H _][@UH HEPtePHM@HP謊H ]@UH HEPtePHM@Hx|H ]@UH HHM@!H ]@UH Hꋅ   t   HM Hx&H ]@UH HHM 
  H ]@UH HHM H ]@UH Hꋅ   t   HM(HP趉H ]@UH HHM(
H ]@UH HEXteXHM@HxlH ]@UH HHM@!H ]@UH HEXteXHM@HxH ]@UH HHM@;H ]@UH HEPtePHM@H`̈H ]@UH HEPtePHM@Hx蜈H ]@UH HHM@ H ]@UH HEPtePHM@HxLH ]@UH HHM@:H ]@UH Hꋅ   t   HM(H`H ]@UH HHM(莈H ]@UH HEXteXHM@H`謇H ]@UH HHM@NQH ]@UH HH   r  H ]@UH HH   H ]@UH HHM0  H ]HT$UH HH H ]@UH HEPtePHM@H`܆H ]@UH HHM@~PH ]@UH HEPtePHM@Hx茆H ]@UH HEXteXHM@Hx\H ]@UH HHM@rH ]@UH HEXteXHM@HxH ]@UH HHM@sH ]@UH HEPtePHM@Hx輅H ]@UH HHM@.rH ]@UH HEPtePHM@HxlH ]@UH HHM@rH ]@UH Hꋅ   t   HM HxH ]@UH HHM   H ]@UH HHM ~H ]@UH HEXteXHM@Hx謄H ]@UH HHM@ΎH ]@UH HEPtePHM@Hx\H ]@UH HHM@~H ]@UH HEXteXHM@HxH ]@UH HHM@NH ]@UH HEPtePHM@Hx較H ]@UH HHM@H ]@UH HH   r  H ]@UH HH   
  H ]@UH HHMP=  H ]@UH HH     H ]@UH HH     H ]@UH HHMP  H ]@UH HHM NH ]@UH HH     H ]@UH HH   *  H ]@UH HHMP]  H ]@UH HH   2  H ]@UH HH     H ]@UH HHMP  H ]@UH HHM@NH ]HT$UH HHM@h33H ]@UH HHM@H ]@UH HHM@H ]@UH HHM(辴H ]@UH HHM@  H ]@UH HH   {H ]@UH HH   kH ]@UH Hꋅ0  t0  HM0HP趀H ]@UH HHM0H ]@UH HHM0H ]@UH HH@  蛨H ]@UH HH8  {H ]@UH HHM0螥H ]@UHmx dx ]@UH HHH  H ]@UH Hꋅ0  t0  HH  HPH ]@UH HHM HڢH ]@UH HH   H ]@UH HH   H ]@UH Hꋅ@  t@  HM0HPH ]@UH HHM0^H ]@UH HHM0H ]@UH HHX  H ]@UH HHH  ˦H ]@UH HHM0螤H ]@UHv v ]@UH HH   WH ]@UH Hꋅ@  t@  H   HP}H ]@UH HHM H*H ]HT$UH HHMX֭33H ]@UH HHMP読H ]@UH HEHteHHMPHPL}H ]@UH HHMPH ]@UH HHMP:H ]@UH HEHteHHMPHP|H ]@UH HHMP
H ]@UH HH   H ]@UH HjpH  zH ]@UH HjpH   ZH ]HT$UH HH   c33rH ]@UH HHMH:H ]@UH HjpHMHH ]@UH HjpHM`ͯH ]@UH HHMPHH ]@UH HHMPHH ]@UH HHM`HH ]@UH HHM`HH ]@UH HHM`H0jH ]@UH HHM@~H ]HT$UH HHM@
b33%H ]HT$UH HHMp33H ]HT$UH H33ΪH ]HT$UH HHM`薪33襪H ]HT$UH H33~H ]HT$SUVWATH0HDe0A~$H}@HH]8LHH   Hr`H   H]8H}@E~#H   HHLHHH9`Hݩ33H0A\_^][@UH HHMP-  H ]HT$UH0HH   LH   HA NH   HPJ_33pH0]@UH HHMP  H ]HT$UH HHM`33%H ]HT$UH H33H ]@UH HHMPH*H ]@UH HHM(H ]@UH HHMPH@H ]@UH HHM0讫H ]@UH HHM@HZH ]@UH HHM@H:H ]@UH HHM@H(H ]@UH HHM@H8H ]@UH HHM@HHH ]@UH HHM@HXH ]@UH HHM@.}H ]@UH HHMP5  H ]@UH HHM(  H ]HT$SUH8HL   H   HH   e]H	33H8][@UH HH   +H ]@UH HH   +)H ]@UH HH   +@H ]@UH HHUXHM(:ZH ]HT$SUVWH(HH]PH}`H;tHuhHHsH0H;u33FH(_^][@UH HHMH  H ]@UH HHM m  H ]@UH HH     H ]@UH HH   tH ]@UH HH@  cH ]@UH HH   蛀H ]@UH HHMp  H ]@UH HHMH  H ]@UH HHM   H ]@UH HH   j  H ]@UH HH     H ]@UH HH   sH ]@UH HH  ~H ]@UH Hꋅ   t   HMX躊H ]@UH Hꋅ   t   HM(芊H ]@UH HHM`NH ]HT$UH0HHM`zZ33H0]HT$UH HHM@Z33ţH ]HT$UH0HHM`zZ33蕣H0]HT$UH HHM@JZ33eH ]HT$UH0HHMh&335H0]HT$UH0HHMp33H0]HT$UH0H33ޢH0]@UH HHM(-  H ]@UH HHMP]  H ]@UH HHMP^pH ]@UH HHM(rH ]@UH HHU(HM0UH ]HT$SUVWH(HH]hH}`H;tHuxHHnH0H;u33H(_^][@UH HHMh=  H ]@UH HHM(m  H ]@UH HHM(oH ]@UH HH   H ]@UH HHUXHM(TH ]HT$SUVWH(HH]PH}`H;tHuhHHmH0H;u33H(_^][HT$UH0HH   WW33ҠH0]@UH HHMp  H ]@UH HHMH  H ]@UH HHM   H ]@UH HH     H ]@UH HH     H ]@UH HH   mH ]@UH HH  ;\H ]HT$UH0HH   V33H0]@UH HHMpH ]@UH HHMp订H ]@UH HHMp{H ]@UH HHMpnH ]@UH HH     H ]@UH HHM@m  H ]@UH HHM`.H ]@UH HH   r  H ]@UH HHMh
  H ]@UH HHM =  H ]@UH HHM >lH ]@UH HH  {H ]@UH HH     H ]@UH HHMhm  H ]@UH HHM   H ]@UH HHM kH ]@UH HH  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(m  H ]@UH HHM(M  H ]@UH HHM(-  H ]@UH HHM(
  H ]@UH HHM@H ]@UH HHM8^H ]@UH HHM`nH ]@UH HH   KH ]@UH HH   KH ]@UH HHM@H ]@UH HHM@H ]@UH HH0  R  H ]@UH HH     H ]@UH HH0    H ]@UH HHMp  H ]@UH HH0    H ]@UH HHMpm  H ]@UH HH0    H ]@UH HH   *  H ]@UH HH0  R  H ]@UH HH     H ]@UH HH0    H ]@UH HHMp  H ]@UH HH0    H ]@UH HHMpm  H ]@UH HH0    H ]@UH HHMp-  H ]HT$UH0HU0H   H0]@UH HHMP螜H ]@UH HHM@~H ]@UH HHU(HM0LH ]HT$SUVWH(HH]hH}`H;tHuxHHeH0H;u33H(_^][@UH HHM0H ]@UH HH   ˛H ]@UH HH   ~H ]@UH HH   苛H ]@UH HH   H0~H ]@UH HHM@NH ]@UH HH   HxG~H ]@UH HHMHH ]@UH HH   H   ~H ]@UH HHMP辚H ]@UH HH   H   }H ]@UH HHMPJH ]@UH HHM`JH ]@UH HHMXJH ]@UH HHM@JH ]@UH HHM@hH ]@UH HHMHNJH ]@UH HHMP  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHMP  H ]@UH HH   K|H ]@UH HH   H ]@UH HH   H ]@UH HH   {H ]@UH HH   諘H ]@UH HH   {H ]@UH HHP    H ]@UH HHM@  H ]@UH HH     H ]@UH HHP  J  H ]@UH HHM@{H ]@UH HHM@
  H ]@UH HHx    H ]@UH HHP    H ]@UH HHMpzH ]HT$SUH8HHk? HM@a  HH0  HRLHHx    HH  ~  H6 H  HH  7  Ha H  诓H8][@UH HHM@  H ]@UH HHx    H ]@UH HH  
  H ]@UH HHM@  H ]@UH HHM@}  H ]@UH HH`    H ]@UH HHM@=  H ]@UH HHMpxH ]@UH HHP    H ]@UH HHx    H ]@UH HHM@  H ]@UH HHMp~xH ]HT$SUH8HH;= HM@Q  HH8  HRLHHx    HH   n  H& H   HH8  '  H_ H   蟑H8][@UH HHM@  H ]@UH HHx    H ]@UH HH     H ]@UH HHM@  H ]@UH HHM@m  H ]@UH HH    H ]@UH HHM@-  H ]@UH HHMpvH ]@UH HHP    H ]@UH HHx    H ]@UH HHM@  H ]@UH HHMpnvH ]@UH HH  +H ]@UH HH  +vH ]HT$SUH8HH: HM@  HH@  HRLHHx    HH    H H  HH    H7] H  OH8][@UH HHM@  H ]@UH HHx  z  H ]@UH HH    H ]@UH HHM@=  H ]@UH HHM@  H ]@UH HH`  J  H ]@UH HHM@  H ]@UH HHMptH ]@UH HHP    H ]@UH HHx  z  H ]@UH HHM@]  H ]@UH HHMptH ]HT$SUH8HH8 HM@  HHP  HRLHHx    HH    H H  HH    H'[ H  ?H8][@UH HHM@  H ]@UH HHx  j  H ]@UH HH    H ]@UH HHM@-  H ]@UH HHM@
  H ]@UH HH`  :  H ]@UH HHM@  H ]@UH HHMprH ]@UH HHP    H ]@UH HHx  j  H ]@UH HHM@M  H ]@UH HHMprH ]@UH HH  ˎH ]@UH HH  qH ]HT$SUH8HH6 HM@  HHX  HRLHHx  V  HH  .YHX H  H8][@UH HHM@]  H ]@UH HHx  :  H ]@UH HHM8ލH ]@UH HHM8pH ]@UH HHMh融H ]@UH HHMhpH ]@UH HHMP  H ]@UH HHM }  H ]@UH HHM ]  H ]@UH HHM =  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM ݿ  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM }  H ]@UH HHM ]  H ]@UH HHM =  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM ݾ  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM }  H ]@UH HHM ]  H ]@UH HHMXH ]@UH HE t
e HMX0dH ]@UH HHMx  H ]@UH HHM8  H ]@UH HHU0HM@:H ]HT$UH0HHM033H0]@UH HHU0HM@:H ]HT$UH0HHM0趆33ņH0]@UH HHMxH ]@UH HHMP讉H ]@UH HHMPbH ]@UH HHM(  H ]@UH HHM(  H ]@UH HHMP.H ]@UH HH   H ]@UH HHM H ]@UH HHM .bH ]@UH HH     H ]@UH HH   ʻ  H ]@UH HHMPnH ]@UH HHMPaH ]@UH HHMP.H ]@UH HHM H ]@UH HHMHH ]@UH HHMHjH ]@UH HHMx讇H ]@UH HHMxjH ]@UH HH     H ]@UH HH     H ]@UH HH     H ]@UH HH   J  H ]@UH HH   r  H ]@UH HH   
  H ]HT$UH@HU@H   H@]@UH HHMH~H ]@UH HHMH~iH ]@UH HHMx>H ]@UH HHMx>iH ]@UH HH   iH ]@UH HH   b  H ]@UH HH     H ]HT$UH@HU@H   H@]@UH HHM@nH ]@UH HHM@nhH ]@UH HHU0HM85H ]HT$SUVWH(HH] H   H;t$H   f     HHuNH0H;u33见H(_^][@UH HHM@讄H ]@UH HHM@gH ]@UH HHMpnH ]@UH HHMpngH ]@UH HHMP.H ]@UH HHMP.gH ]@UH HHM H ]@UH HHM .]H ]@UH HH   2  H ]@UH HH   ʶ  H ]@UH HHMX  H ]@UH HHMPH ]@UH HHMpH ]@UH HHM`H ]@UH HH   H ]@UH HH   H ]@UH HH   {H ]@UH HHM`^H ]@UH HHM`>H ]@UH HHMhH ]@UH HHM`HH ]@UH HHM`H ]@UH HHM`H ]@UH HHMhH ]@UH HH   {H ]@UH HH   [H ]@UH HH   ;H ]@UH HH   HH ]@UH HHMpH ]@UH HHMpH ]@UH HHMxH ]@UH HHM(
  H ]@UH HHM(  H ]@UH HHM(ͳ  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(m  H ]@UH HHM(M  H ]@UH HHM(-  H ]@UH HHM(
  H ]@UH HHM`H ]HT$UH0HHM`Z33U|H0]HT$UH0HHUxHM`>33!|H0]HT$UH0HHUxHM`>33{H0]@UH HHM`~H ]@UH HEpt
epHM`0XH ]@UH HHM(  H ]@UH HH   [H ]HT$UH0HHM`:335{H0]@UH HH   ;~H ]@UH HH   ;aH ]@UH HH   }H ]@UH HH   `H ]@UH HH  }H ]@UH HH  `H ]@UH HH   {}H ]@UH HH   {`H ]@UH HHp  ;}H ]@UH HHp  ;`H ]@UH HH  |H ]@UH HH  _H ]@UH HH@  |H ]@UH HH@  _H ]@UH HH  _H ]@UH HH  {_H ]HT$UH`H' H(  QH`]HT$UH`H' H   !H`]@UH HHM@{H ]@UH HHM@^H ]@UH HH   "  H ]@UH HH     H ]@UH HH   [{H ]@UH HH   [^H ]@UH HHMH{H ]@UH HHMH^H ]@UH HHM@zH ]@UH HHM@]H ]@UH HHU0HM8+H ]HT$SUVWH(HH] H   H;t$H   f     HHCH0H;u33wH(_^][@UH HH  zH ]@UH HH  ]H ]@UH HH@  yH ]@UH HH@  \H ]@UH HH   yH ]@UH HH   \H ]@UH HH  [yH ]@UH HH  [\H ]@UH HH   yH ]@UH HH   \H ]@UH HH  xH ]@UH HH  [H ]@UH HHp  xH ]@UH HHp  [H ]@UH HH   {[H ]@UH HH   [[H ]@UH HH`    H ]@UH HH   :  H ]@UH HH`  b  H ]@UH HH     H ]@UH HH`  "  H ]@UH HH     H ]@UH HH`    H ]@UH HH   z  H ]@UH HH`    H ]@UH HH   :  H ]HT$UH`He" H@  H`]HT$UH`H5" HP  H`]@UH HHMPDH ]@UH HHMp^vH ]@UH HHM(>vH ]@UH HHM(>YH ]@UH HHM@~&H ]@UH HH   uH ]@UH HH   XH ]@UH HHM@&H ]@UH HHMP~uH ]@UH HHMP~XH ]@UH HHM@%H ]@UH HHM@%H ]@UH HH    H ]@UH HH     H ]@UH HH  B  H ]@UH HH   ڧ  H ]@UH HH    H ]@UH HH     H ]@UH HH  ¦  H ]@UH HH   Z  H ]@UH HH    H ]@UH HH`    H ]@UH HH  B  H ]@UH HH   ڦ  H ]@UH HH    H ]@UH HH     H ]@UH HH  ¥  H ]@UH HH   Z  H ]HT$UH0HU0H(  H0]@UH HHM(rH ]@UH HHM(LH ]@UH HHM(rH ]@UH HHM(nrH ]@UH HHM(H ]@UH HHM(H ]@UH HHMP޽H ]@UH HHMP辽H ]@UH HHMpqH ]@UH HHMpTH ]@UH HHM@qH ]@UH HHM@TH ]@UH HH   KqH ]@UH HH   KTH ]@UH HH   ۼH ]@UH HH   軼H ]@UH HH   蛼H ]@UH HHM`pH ]HT$UH0HHM`Zw33UmH0]@UH HH   +H ]@UH HH   H ]@UH HH   H ]@UH HH   ˻H ]@UH HH   {H ]@UH HHMp莻H ]@UH HHMpnH ]@UH HH   KH ]@UH HH   +H ]@UH HHM >oH ]@UH HHM >RH ]@UH HHMPnH ]@UH HHMPQH ]@UH HHMp>H ]@UH HHM(QH ]@UH Hꋅ   t   H   gH ]@UH HHM(nQH ]HT$UH0HHM`t33jH0]@UH HHM@mH ]@UH HHM@PH ]@UH HHMp莹H ]@UH HH   "  H ]@UH HH     H ]@UH HHM .H ]@UH HHMp޹H ]@UH HHMpH@H ]@UH HHM =  H ]@UH HHMPe  H ]@UH HHM   H ]@UH HHM(ݟ  H ]@UH HHMP
  H ]@UH HHM(  H ]@UH HHMP͠  H ]@UH HHM@lH ]HT$UH HHM@33hH ]@UH HHM@kH ]HT$UH HHM@33uhH ]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   HO)H   H]@H}8E~)H   HLRILHHHH)Hg33gH0A\_^][@UH HHMPMH ]HT$UH0HH   L@IH   HA MH   HPI(33]gH0]@UH HHMPMH ]@UH HHM0H ]@UH HHMh.jH ]@UH HHMh.MH ]@UH HH  kH ]@UH HHM8iH ]@UH HHM8LH ]@UH HH  H ]@UH HH     H ]@UH HH     H ]@UH HH     H ]@UH HH   J  H ]@UH HH   r  H ]@UH HH   
  H ]HT$UH0HU0H   ĮH0]@UH HHM@H ]@UH HHMx^hH ]@UH HHMx^KH ]@UH HH  H ]@UH HHMHgH ]@UH HHMHJH ]@UH HH  ;H ]@UH HH   JH ]@UH HH0    H ]@UH HH     H ]HT$UH@HU@H   TH@]@UH HH   +JH ]@UH HHMx-  H ]@UH HHM8]  H ]@UH HHM8^1H ]@UH HH   {>H ]HT$SUH8HL   H   HH   U$H	c33cH8][@UH Hj@HMfH ]@UH Hj@HM fH ]@UH HHM@eH ]@UH HH   英H ]@UH HH   HgH ]@UH HH   KH ]@UH HH   H'H ]@UH HHMp}  H ]@UH HHM`n7H ]@UH HHM@8H ]@UH HHM@H誓H ]@UH HHMHdH ]@UH HHMHdH ]@UH HHM@NH ]@UH HHM@.H ]@UH HHM(H ]@UH HHM(H ]@UH HHM@1H ]@UH HHM@H FH ]@UH HHMHn1H ]@UH HHM@HP\H ]@UH HHM@.1H ]@UH HHMH1H ]@UH HHM@0H ]@UH HHMH0H ]@UH HHM@H*6H ]@UH HHM@H@芬H ]@UH HHM@H  gH ]@UH HHMHN0H ]@UH HHM@H  H ]@UH HHM@H0*H ]@UH HHM@Hp
H ]@UH HHM@H   V  H ]@UH HHMHaH ]@UH HHMHaH ]@UH HHM@nH ]@UH HHM@H  ]H ]@UH HHM@H  :H ]@UH HHM@H@  WH ]@UH HHM@Hx  :H ]@UH HHM@H  H ]@UH HHM@H  DH ]@UH HHM@H  CH ]@UH HHM0`H ]@UH HHM0CH ]@UH HH@  {`H ]@UH HHM0^H ]@UH HH   z  H ]@UH HHp  ;CH ]@UH HH   ˳H ]HT$UH0HHMx\33\H0]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   HH   H]@H}8E~)H   HLRILHHHH@H[33\H0A\_^][@UH HHMP.BH ]HT$UH0HH   L@IH   HA MH   HPI33[H0]@UH HHMPAH ]@UH HHM@HJH ]@UH HHMH^^H ]@UH HHM@>^H ]@UH HH   H ]@UH HH   {H ]@UH HH   ]H ]@UH HH   @H ]@UH HH   ]H ]@UH HH   @H ]@UH HH   
H ]@UH HH   ;]H ]@UH HH   ;@H ]@UH HHX  \H ]@UH HHX  ?H ]@UH HH  \H ]@UH HH  ?H ]@UH HH  {\H ]@UH HH  {?H ]@UH HH  ;\H ]@UH HH  ;?H ]@UH HH   ?H ]@UH HH   >H ]@UH HH  B  H ]@UH HHP  ڎ  H ]@UH HH    H ]@UH HH     H ]@UH HH    H ]@UH HH   Z  H ]@UH HH    H ]@UH HHP    H ]@UH HH  B  H ]@UH HHP  ڍ  H ]@UH HH    H ]@UH HH     H ]HT$UH`H Hx  QH`]@UH HH    H ]@UH HH   *  H ]@UH HH  Z  H ]@UH HH  2  H ]@UH HH   ʌ  H ]@UH HH     H ]@UH HH  ҋ  H ]@UH HH   j  H ]@UH HH`    H ]@UH HH  r  H ]@UH HH   
  H ]@UH HH  :  H ]HT$UH`H H  衞H`]@UH HHx  H ]@UH HHx  H ]@UH HH   XH ]@UH HH   ;H ]@UH HH  WH ]@UH HH  :H ]@UH HH   WH ]@UH HH   :H ]@UH HHH  [WH ]@UH HHH  [:H ]@UH HH  WH ]@UH HH  :H ]@UH HH  VH ]@UH HH  9H ]@UH HH  VH ]@UH HH  9H ]@UH HH  {9H ]@UH HH  [9H ]@UH HH    H ]@UH HH@  :  H ]@UH HH  b  H ]@UH HH    H ]@UH HH  "  H ]@UH HH    H ]@UH HH    H ]@UH HH@  z  H ]@UH HH    H ]@UH HH@  :  H ]@UH HH  b  H ]@UH HH    H ]HT$UH`H%  H  豚H`]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH  *  H ]@UH HH  Z  H ]@UH HH  2  H ]@UH HH  ʆ  H ]@UH HHP    H ]@UH HH  ҅  H ]@UH HH  j  H ]@UH HH    H ]HT$UH`Hu H  H`]@UH HHM@RH ]@UH HHM@5H ]@UH HH   {RH ]@UH HjPHMRH ]@UH HHMp^%H ]@UH HHMpHH ]@UH HHMpHHʀH ]@UH HHM(QH ]@UH HHMpH   4H ]@UH HHM0QH ]@UH HHMpH   4H ]@UH HHM8^QH ]@UH HHMpH   W4H ]@UH HHM8>4H ]@UH HHMhPH ]@UH HHMh3H ]@UH HHM`^H ]@UH HHMpnH ]@UH HHM`H@JH ]@UH HHM   H ]@UH HHMPł  H ]@UH HHM ]  H ]@UH HHM =  H ]@UH HH   OH ]@UH HH   2H ]@UH HH   2H ]@UH HH   {H ]@UH HH(  +H ]@UH HHMP}  H ]@UH HE@t
e@HMHH ]@UH HH   H ]@UH HH   {H ]@UH HH   [H ]@UH HHMx!H ]@UH HHMpH ]@UH HHM(H ]@UH HHMpHZ!H ]@UH HHMpH@躗H ]@UH HHMpH  藗H ]@UH HHM(~H ]@UH HHMx^H ]@UH HHM@H0H ]@UH HHM@H80H ]@UH HHM@HpJH ]@UH HHM@H   &H ]@UH HHM@H   ǞH ]@UH HHM@Hp  0H ]@UH HHM@H    H ]@UH HHM@H  H ]@UH HHM@H  H ]@UH HHM@H0:{H ]@UH HHM@Hp{H ]@UH HHM@H   f  H ]@UH HHMp辂H ]@UH HHM8KH ]@UH HHM8.H ]@UH HH  KH ]@UH HE0te0H  .H ]@UH HHMp^KH ]@UH HHMp^.H ]@UH HHMpKH ]@UH HHMp.H ]@UH HHM8^H ]HT$UH0H>33GH0]@UH HHMpJH ]@UH HHMp-H ]@UH HHM8H ]HT$UH0H论33FH0]@UH HHM8IH ]@UH HHM8,H ]@UH HH   ;H ]HT$UH0H33iFH0]@UH HHM8nIH ]@UH HHM8n,H ]@UH HH   H ]HT$UH0H莹33EH0]@UH HHM@jH ]HT$SUH8HH   H{8 t'HM8HPHHK8BHHL{  N{  H& H8][@UH HHM@^HH ]@UH HHM@^+H ]@UH HHMxHH ]@UH HHMxH ]@UH HH   GH ]@UH HH   *H ]@UH HHM@H ]@UH HHM@*H ]@UH HH  y  H ]@UH HHM@}z  H ]@UH HH  y  H ]@UH HH   :z  H ]@UH HH  by  H ]@UH HH   y  H ]@UH HH  "y  H ]@UH HHM@y  H ]HT$UH0HU0H   tH0]@UH HH   x  H ]@UH HHM`FH ]@UH HHM`)H ]@UH HHM8
y  H ]@UH HH   EH ]@UH HH   (H ]@UH HHM8x  H ]@UH HHM8x  H ]@UH HHM8mx  H ]@UH HHM8Mx  H ]@UH HHM8-x  H ]@UH HHM8
x  H ]@UH HHM8w  H ]@UH HH  'H ]@UH HH   kDH ]@UH HHM NDH ]@UH HHM N'H ]@UH HHMPDH ]@UH HHMP'H ]@UH HHMP&H ]@UH HH   CH ]@UH HH   &H ]@UH HHMPnCH ]@UH HHMPn&H ]HT$UH0HH   I33?H0]@UH HHM(H ]@UH HHMHH ]@UH HHM(BH ]@UH HHMpH%H ]@UH HHM0~BH ]@UH HHMpH8z%H ]@UH HHM8>BH ]@UH HHMpHpH ]@UH HHM@AH ]@UH HHMpH   7H ]@UH HHMxHt  H ]@UH HHMxH0jpH ]@UH HHMxHpJpH ]@UH HHMxH   t  H ]@UH HHMpH   H ]@UH HHMHAH ]@UH HHMpHp  $H ]@UH HHMpH  t  H ]@UH HHMP@H ]@UH HHMpH  H ]@UH HHMX~@H ]@UH HHx  {#H ]@UH HHM0^#H ]@UH HH0  r  H ]@UH HH  :s  H ]@UH HH   jt  H ]@UH HHM`?H ]@UH HHM`"H ]@UH HH   {?H ]@UH HH   {"H ]@UH HHP  ["H ]@UH HHM8>"H ]@UH HH  q  H ]@UH HH   r  H ]@UH HH   Js  H ]@UH HHMh>H ]@UH HHMh!H ]@UH HHH  [>H ]@UH HE0te0HH  M!H ]@UH HHx  >H ]@UH HHx  !H ]@UH HH   =H ]@UH HH    H ]@UH HHMhp  H ]@UH HH   p  H ]@UH HH@  p  H ]@UH HHM0N H ]@UH HHMhMp  H ]@UH HHM0 H ]@UH HH@  
p  H ]@UH HH   o  H ]@UH HHMho  H ]@UH HHM0H ]@UH HHMho  H ]@UH HHM0NH ]@UH HH@  Jo  H ]@UH HH   *o  H ]@UH HHMh
o  H ]@UH HHM0H ]@UH HHM0;H ]@UH HHM0H ]@UH HHMhn  H ]@UH HHM0NH ]@UH HH@  Jn  H ]@UH HH   *n  H ]@UH HHMh
n  H ]@UH HHM0H ]@UH HHM0:H ]@UH HHM0H ]@UH HHMhm  H ]@UH HHM0NH ]@UH HH@  Jm  H ]@UH HH   *m  H ]@UH HHMh
m  H ]@UH HHM0H ]@UH HHM09H ]@UH HHM0H ]@UH HHMhl  H ]@UH HHM0NH ]@UH HH@  Jl  H ]@UH HH   *l  H ]@UH HHMh
l  H ]@UH HHM0H ]@UH HHMhk  H ]@UH HHM0H ]@UH HH@  k  H ]@UH HH   jk  H ]@UH HHMhMk  H ]@UH HHM0H ]@UH HHM07H ]@UH HHM0H ]@UH HHMhj  H ]@UH HHM0H ]@UH HH@  j  H ]@UH HH   jj  H ]@UH HHMhMj  H ]@UH HHM0H ]@UH HH   6H ]@UH HH   H ]@UH HHM06H ]@UH HHM0nH ]@UH HHMhi  H ]@UH HHM0NH ]@UH HH0  ہH ]@UH HH@  *i  H ]@UH HH   
i  H ]@UH HHMhh  H ]@UH HH   H ]@UH HHM0h  H ]@UH HH   kH ]@UH HH   jh  H ]@UH HHMhMh  H ]@UH HHM0-h  H ]@UH HH   H ]@UH HH@  g  H ]@UH HH   H ]@UH HH   g  H ]@UH HHMhg  H ]@UH HHM0mg  H ]@UH HH   +H ]@UH HH@  *g  H ]@UH HH   H ]@UH HH   f  H ]@UH HHMhf  H ]@UH HHM0f  H ]@UH HH   kH ]@UH HHMh.3H ]@UH HHMh.H ]@UH HHM0-f  H ]@UH HH   H ]@UH HH   e  H ]@UH HHMhe  H ]@UH HHM0e  H ]@UH HH   kH ]@UH HHMh.2H ]@UH HHMh.H ]@UH HHM0-e  H ]@UH HH   H ]@UH HHM01H ]@UH HHM0H ]@UH HH   k1H ]@UH HH   KH ]@UH HH   +H ]HT$UH0H H  !wH0]@UH HHM(d  H ]@UH HHMPMe  H ]@UH HHM 0H ]@UH HHM ~H ]@UH HH   b  H ]@UH HHMh}c  H ]@UH HHM({H ]@UH HH   {H ]HT$UH H33,H ]@UH HH   {{H ]@UH HH   [{H ]@UH HHEXD HUPHM(H ]@UH HHE0D HU(HM8H ]HT$SUWH HH]hH}pH;t!@ HK.c  HK$c  H(H;u33+H _][@UH HHM zH ]@UH HHM nzH ]@UH HHMhhH ]@UH HHM(^.H ]@UH HH   kBH ]@UH HHM0.H ]@UH HH   HHH ]@UH HHM8-H ]@UH HH   HxH ]@UH HHM@-H ]@UH HH   H   H ]@UH HHMHN-H ]@UH HH   H   DH ]@UH HHMP,H ]@UH HH   H  H ]@UH HH   H@  txH ]@UH HHMX~,H ]@UH HH   H`  tH ]@UH HHM`.,H ]@UH HH   H  $H ]@UH HHMh+H ]@UH HH   H  H ]@UH HH   +H ]@UH HHM@n+H ]@UH HHM@nH ]@UH HH   H ]@UH HHMX+H ]@UH HH   H H ]@UH HHM(*H ]@UH HHM(
H ]@UH HHM0*H ]@UH HHM0H ]@UH HHM0N*H ]@UH HHM .*H ]@UH HHM H ]@UH HH   )H ]@UH Hꋅ0  t0  H   H ]@UH HH   H ]@UH HHM`~)H ]@UH HHM`~H ]@UH HHM@KH ]@UH HHM@>LH ]@UH HHM`[  H ]HT$SUH(HHU HM`T[  Hx HM \  t*HU HM`0[  H  LHAHM [  33_%H(][@UH HHM [  H ]@UH HHM [  H ]@UH HH   sH ]@UH HH   sH ]@UH HHMHsH ]@UH HHMHsH ]@UH HH   {sH ]@UH HH   [sH ]@UH HH   ;sH ]@UH HH   sH ]@UH HHM8rH ]@UH HHM8rH ]@UH HHM`rH ]@UH HH   RY  H ]@UH HH   Y  H ]HT$UH0HMXMX  ;|4  H HD$ L
 L  HM H
F .H H0]HT$SUH8HHM@HPHHMX+Y  H   HHUXHHMX,Y  LHASHˡ H8][@UH HHMXX  H ]@UH HHMHnqH ]@UH HHMHNqH ]HT$SUH8HHU8H   H_iH@ HMX^X  HHUXHHMXfX  H7 HMX5X  HHUXHHMX=X  LHASH͠ H8][@UH HHMX
X  H ]@UH HHMXW  H ]@UH HHMXW  H ]@UH HHMXW  H ]@UH HHMXW  H ]@UH HHMXmW  H ]@UH HHMXMW  H ]@UH HHMX-W  H ]@UH HH   #H ]@UH HH   H ]@UH HHMp#H ]@UH HHMpH ]@UH HH0  YH ]@UH HH   +#H ]@UH HH   +H ]@UH HH(  "H ]@UH HH(  H ]@UH HHM@"H ]@UH HHM@H ]@UH HH  H ]@UH HH(  K"H ]@UH HH  HPH ]@UH HH(  "H ]@UH HH  HHPH ]@UH HHP  !H ]@UH HH  H   H ]@UH HHX  {!H ]@UH HH  H   tH ]@UH HH`  +!H ]@UH HH  H   $H ]@UH HH  WH ]@UH HHX  H ]@UH HH0  "S  H ]@UH HH  S  H ]@UH HH  S  H ]@UH HHM@}S  H ]@UH HHMp]S  H ]@UH HH   :S  H ]@UH HH(  S  H ]@UH HH   R  H ]@UH HH  R  H ]@UH HHX  R  H ]@UH HH   R  H ]@UH HH   zR  H ]@UH HH   H ]@UH HH   H ]HT$SUHHHH H   Q  HH  HH   HH   Q  H  HPHH   Q  HH   HH   Q  Hӥ HH][@UH HH   zQ  H ]@UH HH   ZQ  H ]@UH Hj HMH ]@UH HH   H ]@UH HH   H  H ]@UH HH   HPH ]@UH HH   {H ]@UH HH   H   t H ]@UH HHM(mP  H ]@UH HHMPQ  H ]@UH HH   KH ]@UH HHMh.H ]@UH HHM@O  H ]@UH HHMhH ]@UH HH   SH ]@UH HH   H  H ]@UH HH   H  tH ]@UH HH   H@  H ]@UH HH   Hx  H ]@UH HH   H  H ]@UH HHMP^H ]@UH HH   H  TH ]@UH HHMXH ]@UH HH   H  H ]@UH HHM`H ]@UH HH   H@  H ]@UH HHMHnH ]@UH HEPt
ePHMHH ]HT$UH0HL   HU8HMp_LhL  AHEx@(H H0]@UH HHM@eH ]@UH HH   2L  H ]@UH HHMhL  H ]HT$UH0Hꋍ    L   IA;|'H HD$ L
b H3 H
t o!Hӭ H0]@UH HH  K  H ]@UH HH  bK  H ]@UH HH  K  H ]@UH HH   K  H ]@UH HHMxK  H ]@UH HHh  K  H ]@UH HHMP}K  H ]@UH HH@  ZK  H ]@UH HH   :K  H ]@UH HH   K  H ]@UH HHM(J  H ]@UH HHM(J  H ]@UH HH  J  H ]@UH HH   NH ]HT$SUHHHH  HM@QJ  H  HHU@HHM@RJ  HMhHPHHM@J  HHU@HHM@#J  H	 HH][@UH HHM@I  H ]@UH HHM@I  H ]@UH HHMHNbH ]@UH HH   I  H ]HT$UH@HLm LD$ L
 HY H
z }4H@]@UH HH   eH ]@UH HH(  eH ]@UH HHMXH  H ]@UH HH   H  H ]HT$UH@HH   觴H H@]@UH HHMX>eH ]@UH HH   eH ]@UH HHMXdH ]@UH HH   dH ]@UH HHMXdH ]HT$UH@H# EPH: H@]@UH HH  G  H ]@UH HHMXG  H ]@UH HH  F  H ]@UH HHMX]G  H ]@UH HHMXcH ]@UH HH  cH ]@UH HHp  cH ]@UH HH  F  H ]@UH HH  
H  H ]@UH HH  H ]@UH HHMpjH ]@UH HH   ZF  H ]@UH HH   :F  H ]@UH HH   bH ]@UH HH   bH ]@UH HH   bH ]@UH HH   kbH ]@UH HH   KbH ]@UH HH  D  H ]@UH HHM@H ]@UH HHM@H ]@UH HH   E  H ]@UH HH   D  H ]@UH HH   D  H ]@UH HH   D  H ]@UH HH   D  H ]@UH HHM@H
]H ]@UH HHM@H\H ]@UH HHM@H(\H ]@UH HHM@H8\H ]@UH HHM@HH\H ]@UH HHM@HXj\H ]@UH HHM@H   C  H ]HT$UH HH   Ht
33
H ]@UH HH   +H ]@UH HH   kH ]@UH HH  H ]@UH HH  +H ]@UH HH  H ]@UH HH  H ]@UH HH  kH ]@UH HH  H ]@UH HH  +H ]@UH HH  kH ]@UH HH   *B  H ]@UH HH   
B  H ]@UH HH  ZH ]@UH HHP  A  H ]@UH HH   A  H ]@UH HH  H ]@UH HH  [H ]@UH HH  JA  H ]@UH HH0  H ]@UH HH0  H ]@UH HH  H ]@UH HH  @  H ]@UH HH  H ]@UH HH  {H ]@UH HHh  j@  H ]@UH HH   J@  H ]@UH HH  *@  H ]@UH HHMP
@  H ]@UH HH   XH ]@UH HHh  ?  H ]@UH HH   ?  H ]@UH HH   ?  H ]@UH HH   j?  H ]@UH HH   J?  H ]@UH HHMP-?  H ]@UH HH   WH ]@UH HHH  H ]@UH HHH  H ]@UH HH8  kH ]@UH HH8  KH ]@UH HHx  +H ]@UH HHx  kH ]@UH HHx  
H ]@UH HH  {H ]@UH HH  [H ]@UH HH0  ;H ]@UH HH  H ]@UH HH  H ]@UH HHMPH ]@UH HH  
H ]@UH HH  	H ]@UH HH  	H ]@UH HH  	H ]@UH HH   	H ]@UH HHM(nNH ]@UH HH   <  H ]@UH HH   YH ]@UH HH   J<  H ]@UH HH   r;  H ]@UH HH   
<  H ]@UH HHMPH ]@UH HHMPH ]@UH HH   kH ]@UH HH   kH ]@UH HH   :  H ]@UH HH   J;  H ]@UH HH   *;  H ]@UH HH   kTH ]@UH HHP  KTH ]@UH HH  +TH ]@UH HH  TH ]@UH HH   SH ]@UH HH   RH ]@UH HH   RH ]@UH HH   RH ]@UH HH   RH ]@UH HH   {RH ]@UH HH   [RH ]@UH HHMp>RH ]@UH HHMpRH ]@UH HHM@RH ]@UH HHM0RH ]@UH HH   *9  H ]@UH HHMx]:  H ]@UH HH   8  H ]@UH HHMx:  H ]HT$SUH(HH  HM08  H   HHU0HHM08  HM(HPHHM0K8  HHU0HHM0S8  H H(][@UH HHM0-8  H ]@UH HHM0
8  H ]HT$SUH(HH3  HM07  H   HHU0HHM07  HM(HPHHM07  HHU0HHM07  H, H(][@UH HHM0m7  H ]@UH HHM0M7  H ]@UH HHMhOH ]@UH HHMxOH ]@UH HHM@~H ]HT$SUH(HH  HM06  H   HHU0HHM06  HM(HPHHM0k6  HHU0HHM0s6  H' H(][@UH HHM0M6  H ]@UH HHM0-6  H ]HT$SUH(HH[  HM05  H   HHU0HHM05  HM(HPHHM05  HHU0HHM05  H/( H(][@UH HHM05  H ]@UH HHM0m5  H ]HT$SUH(HH  HM0!5  H   HHU0HHM0"5  HM(HPHHM04  HHU0HHM04  H?) H(][@UH HHM04  H ]@UH HHM04  H ]HT$SUH(HH+  HM0a4  H   HHU0HHM0b4  HM(HPHHM0+4  HHU0HHM034  HO* H(][@UH HHM0
4  H ]@UH HHM03  H ]@UH HH  H ]@UH HH   H ]@UH HHh  H ]@UH HH   H ]@UH HHMXH ]@UH HH   KH ]@UH HHMHοH ]@UH HEpt
epHMxKH ]@UH HHM(NKH ]@UH HHMh.KH ]@UH HHMhKH ]@UH HHMxJH ]@UH HHMxJH ]@UH HH   JH ]@UH HH   JH ]@UH HH   kJH ]@UH HH   KJH ]@UH HHM0.JH ]@UH HHM0JH ]@UH HHM@IH ]@UH HH   0  H ]@UH HH   1  H ]HT$UH0HM`M`  ;|4  H HD$ L
 L  H} H
 HS H0]@UH HHMXIH ]@UH HHM(H ]@UH HHMxHH ]@UH HHM@HH ]@UH HH   R/  H ]@UH HHMh/  H ]HT$UH0Hꋍ    L   IA;|'H HD$ L
 HS H
̦ HW H0]@UH HHM@GH ]@UH HH   H ]@UH HHMX޻H ]@UH HHMXH ]@UH HH   kH ]@UH HHM NGH ]@UH HH   H ]@UH HH   z.  H ]HT$UH@HLR LD$ L
 H9 H
 ]H@]@UH HH   JH ]@UH HH@  JH ]@UH HHMX-  H ]@UH HH  -  H ]HT$UH@HH   臏Hgc H@]@UH HHMXJH ]@UH HH  IH ]@UH HHMXIH ]@UH HH  IH ]@UH HHMXIH ]HT$UH@H EPHd H@]@UH HH  +  H ]@UH HHMX},  H ]@UH HH  +  H ]@UH HHMX=,  H ]@UH HHMXHH ]@UH HH   HH ]@UH HHP  HH ]@UH HHp  +  H ]@UH HH  ,  H ]@UH HH  H ]@UH HHMpNH ]@UH HH   :+  H ]@UH HH   +  H ]@UH HHM@GH ]@UH HH   GH ]@UH HHM@nGH ]@UH HH   KGH ]@UH HHM@.GH ]@UH HH0  )  H ]@UH HHM@H ]@UH HHM@H ]@UH HH   )  H ]@UH HH   )  H ]@UH HH   )  H ]@UH HH   )  H ]@UH HH   z)  H ]@UH HH   Z)  H ]@UH HH   EH ]@UH HH   )  H ]@UH HH0  B(  H ]@UH HH   (  H ]@UH HHMP~H ]@UH HHMP~H ]@UH HH   ;H ]@UH HH   ;H ]@UH HH0  '  H ]@UH HH   (  H ]@UH HH   '  H ]@UH HH0  "'  H ]@UH HHM@'  H ]@UH HHM@'  H ]@UH HHM@}'  H ]@UH HHM@]'  H ]@UH HHM@='  H ]@UH HHM@'  H ]@UH HH0  &  H ]@UH HHM@&  H ]@UH HjpH   
H ]@UH HHM@.?H ]@UH HHM@?H ]@UH HHM0>H ]@UH HHM(>H ]@UH HHMP>H ]@UH HHM`>H ]@UH HHM`n>H ]@UH HHM`HJ>H ]@UH HHM`H(*>H ]@UH HHM8>H ]@UH HHM8>H ]@UH HHMxH ]@UH HHMxH ]@UH HH   =H ]@UH HH   k=H ]@UH HHMhN=H ]@UH HH   [H ]@UH HH   [H ]HT$UH0H    HЪ H0]@UH HH 	  r#  H ]@UH HH  
$  H ]@UH HHp  [H ]@UH HHp  H ]@UH HH0  #  H ]@UH HHP  H ]@UH HHP  [H ]@UH HH   H ]@UH HH   H ]@UH HHM`;H ]@UH HHM`~;H ]@UH HH   H ]@UH HH   H ]@UH HH`  KH ]@UH HH`  KH ]@UH HH  H ]@UH HH  H ]@UH HH  
"  H ]@UH HH  !  H ]@UH HH
  [H ]@UH HH
  ;H ]@UH HH
  H ]@UH HH  HH ]@UH HH
  H ]@UH HH
  H ]@UH HH  MH ]@UH HH  2   H ]@UH HHMp   H ]@UH HH0     H ]@UH HH  H ]@UH HH  [H ]@UH HHMpM   H ]@UH HH  z!  H ]@UH HH  {H ]@UH HH  HwH ]@UH HH
  H ]@UH HH
  kH ]@UH HH   KH ]@UH HH   KH ]@UH HH  J  H ]@UH HH  蛹H ]@UH HH  H ]@UH HHMp  H ]@UH HH  ;H ]@UH HHP  H ]@UH HHp  H ]@UH HH    H ]@UH HH    H ]@UH HH  *  H ]@UH HH  {H ]@UH HH  ۽H ]@UH HH  [6H ]@UH HH  ;6H ]@UH HH    H ]@UH HH  ۷H ]@UH HH  ;H ]@UH HH0  *  H ]@UH HH  {H ]@UH HH  ۼH ]@UH HH  軼H ]@UH HHMpnH ]@UH HHMpH ]@UH HH  j  H ]@UH HH  J  H ]@UH HHMpH ]@UH HHMp.H ]@UH HH    H ]@UH HH0    H ]@UH HH  H ]@UH HH  H ]@UH HH  ۵H ]@UH HH  軵H ]@UH HHP  蛵H ]@UH HHp  {H ]@UH HH  H ]@UH HH0    H ]@UH HHMp  H ]@UH HH  +H ]@UH HH  HP  H ]@UH HH  !H ]@UH HHMp  H ]@UH HH  kH ]@UH HH  ˹H ]@UH HH  +H ]@UH HH  軿H ]@UH HHMp}  H ]@UH HH0  Z  H ]@UH HH  軤H ]@UH HH  H0  4H ]@UH HH  H ]@UH HHMp  H ]@UH HH  H ]@UH HH  {H ]@UH HH  ۲H ]@UH HH  kH ]@UH HHMp-  H ]@UH HH0  
  H ]@UH HH  H ]@UH HHMp  H ]@UH HHMp  H ]@UH HH  H ]@UH HHP  ۱H ]@UH HHp  軱H ]@UH HHMp-  H ]@UH HH  Z  H ]@UH HHH  /H ]@UH HH
  H ]@UH HH  H ]@UH HHP  H ]@UH HHp  ۰H ]@UH HH  kH ]@UH HH  H ]@UH HH  H ]@UH HH  H ]@UH HH  KH ]@UH HH  H ]@UH HH  H ]@UH HH  H ]@UH HH  [H ]@UH HH  H ]@UH HH  [H ]@UH HH  ;H ]@UH HHMp  H ]@UH HH    H ]@UH HH  H ]@UH HHP  ۮH ]@UH HHp  軮H ]@UH HHM8-  H ]@UH HHM`]  H ]@UH HH
 H ]@UH HH
 H ]@UH HH
H kH ]@UH HH
 KH ]@UH HH
@ +H ]@UH HH
 H ]@UH H   H ]@UH HHHM(HM$H ]@UH H H ]@UH HHM8HM(HE(HHM0HE08csmtE     E nH ]@UH H}  uLMxDEpHUhHM`HH ]@UH HH3Ɂ8  H ]H(H2  H
   H
  H(H(H3  H
Γ   H
  H(dH(H2  H
   H
  H(4H(t( o H( ^X  H(4( M H(H(R - H(HI    H)   fW'  H    ' 
    tYtY
 H(' }Y^  H(H(& _O H(@ Y X & ^ (  fW&   H( 
 ^
k H(H(4& 7 H(H( } H(H(fWa H(H($& = H(H(%  H(Б fW% Б H( fW%  H(X fWp%  H($% fWB% : H(0 YP% p  X ȑ  fW$  H(H/  H
^ 
  H
  H(tH(H/  H
ޏ 
  H
  H(DH(H/  H
 
  H
  H(H8HD$    3HtH
k HHH\ Hm Hn Ho H
  H8H8HD$    3HtH
C HHH4 HE HF HG H
P  H8SH8HD$    Y3HtH
C HHH4 HE HF HG H
  H8H(H
    ;_H
t  H(H8HD$    3HtH
 HHH H H H H
  H8cH8HD$    i3HtH
 HHH| H H H H
0  H8H8HD$    	3HtH
 HHH H H H H
  H8H(H
 0/H
y  H(|H(H
e 3H
	  H(\H80 LD$@3)t$ 5 fTf/! v_   "   X LD$@3fTf/q! v1   "   (t$ H8HL$FMHL$=HL$FH
Y OH
 HL$Fr ~ S   HT$~, HT$9x HT$@X HT$GH
 H%2	  H
 H%"	  H
I H%	  H
Y H%	  H
 H%  H
A H%  @SH HK Ht*H|$0CuHHPCu	HHPH|$0H [@SH H Ht*H|$0CuHHPCu	HHPH|$0H [@SH H Ht*H|$0CuHHPCu	HHPH|$0H [@SH H Ht*H|$0CuHHPCu	HHPH|$0H [H(H
 HtH
ġ 3Hӡ Hԡ Hա H(H(H
= HtH
 3H# H$ H% H(H(H
 HtH
| 3H H H H(`H
	 4H(H
u Ht7H
L 3H[ H\ H] H(H(H
ա HtH
 3H H H H(H(H
] HtH
4 3HC HD HE H(                                                                                                                                                                                                                                                                                                                                                    ^     H     2     "                                 p     4               b               v     $               L               t     0                         B               l                    R                    F     >          `                    X               4               X                    t     *                    R               0     (               V          `                              |           ~               H     ƽ     x     "     ؼ     z     0     ޻                  v     d     V     F     8     ,                                                       x     n     d     Z     8     ,                                             d     H     <                                   t     P     F     @     8     2     ,     &                    
                            >     $                    ƶ                    |     d     T     @     2                    ޵     ĵ                         p     b     R     :     &     
               д                         n     ^     H     0               Գ     Ƴ                    z     h     T     D     0     "                    Ҳ                         n     Z     J     <     .                    ܱ     ʱ                    ~     n     Z     D     ,                    »               ~     j     V     :     (                     ں     ƺ                    n     \     J     :     "                     ֹ     ¹                    x     d     H     ,               ָ     Ƹ                         h     T     <     ,                     ַ                    z     d          N     ڰ     Ȱ                    n     X     H                                 0   P   p                   P   p                    @   `                  @   `                0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            `                                                                                                                                                                                                                                                                   p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @                                                                                                                                                                                                                                                                   `                                                                                                                                                                                                                                                                                   T
                   bad allocation  numpy.core.multiarray   numpy.core.multiarray failed to import  _ARRAY_API  2   _ARRAY_API not found    _ARRAY_API is not PyCObject object  14  _ARRAY_API is NULL pointer  0   module compiled against ABI version %x but this version of numpy is %x  numpy.core.umath    2   module compiled against API version %x but this version of numpy is %x  FATAL: module compiled as unknown endian    14  numpy.core.umath failed to import   0   FATAL: module compiled as little endian, but detected different endianness at runtime   _UFUNC_API      _UFUNC_API not found    _UFUNC_API is not PyCObject object      _UFUNC_API is NULL pointer      SSE, SSE2       empty_nested() must be true before calling recover_memory() .           empty_nested() must be false before calling recover_memory_nested()  /  :0yE>empty_nested() must be false before calling set_zero_all_adjoints_nested()      No free parameters for unit metric              Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        model =         stan_version_major =    stan_version_minor =    stan_version_patch =    Iteration:  %]   [       (Warmup)        (Sampling)  /  stan::services::variational::print_progress %]  Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   [   (Adaptation)    (Variational Inference)    #   stan_version_major      stan_version_minor      stan_version_patch      )       (   --  >   =<  :       Exception thrown at line        bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type           c:\users\appveyor\appdata\local\temp\1\tmppbp3f1\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.cpp F           stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.pyx      __init__.pxd    stringsource    type.pxd        Unknown exception   T   n   lp__    np  HMC PY2 eta get ret sum __str__ zip BFGS    NUTS    args    ctrl    data    flat    init    iter        __main__    misc    name    pars    plot    seed    send        __test__    thin    upar    user    warn    LBFGS   OPTIM   array   ascii   close   error   flush   index   numpy   optim   order   plots   probs   range   shape   split   throw   utf-8   value   DIAG_E  Newton  UNIT_E  append  chains  data_i  data_r  decode  diag_e  dstack  encode  fitptr  format  holder      __import__  logger  method  metric  n_save  pystan  unit_e  update  vars_i  vars_r  warmup      DENSE_E argsptr asarray control dense_e dims_oi epsilon extract genexpr handler logging mean_lp__       newaxis pars_oi refresh reshape samples squeeze _summary        tol_obj warmup2 SAMPLING        adapt_t0        chain_id        (diag_e)        __getstate__    gradient        handlers        int_time        permuted        sampling        stepsize        tol_grad        (unit_e)        warnings        algorithm       data_args       (dense_e)       eval_elbo       flatnames       fnames_oi       getLogger       holderptr       init_list       iter_save       mean_pars       row_stack       sampler_t       test_grad       tol_param       traceplot       Metropolis      ValueError      adapt_iter      _check_pars get inc_warmup      init_alpha      model_code      _split_data get ImportError b   MemoryError B   OrderedDict h   VARIATIONAL H   adapt_delta i   adapt_gamma I   adapt_kappa l   collections L   _get_samples    init_radius q   pystan.misc Q   random_seed f   sample_file d   save_warmup g   tol_rel_obj Zf  variational Zd  RuntimeError    adapt_window    _call_sampler   column_stack    elbo_samples    grad_samples    history_size    optim_algo_t    pystan.plots    string_types    tol_rel_grad    TEST_GRADIENT   adapt_engaged   max_treedepth   pars_oi_bytes   _print_stanfit  AttributeError  append_samples  output_samples  pystan._compat  sampler_params  adaptation_info diagnostic_file sampling_algo_t save_iterations stepsize_jitter adjust_transform        _get_kept_samples       pystan.constants        sample_file_flag        tol_history_size        adapt_init_buffer       adapt_term_buffer       _call_sampler_star      _remove_empty_pars      sampling_metric_t       cline_in_traceback      enable_random_init      _pars_total_indexes Zg  stan_args_method_t      variational_algo_t      _verify_has_samples O   iter_save_wo_warmup par sampler_param_names sim diagnostic_file_flag    __getstate__.<locals>.genexpr   Variable name must be bytes.    ndarray is not C contiguous s   Stan model {} is of mode 'test_grad';
sampling is not conducted.        `inc_warmup` ignored when `permuted` is True.   numpy.core.multiarray failed to import  unknown dtype code in numpy.pxd (%d)    Couldn't allocate space for StanHolder. Couldn't allocate space for stan_fit.   Format string allocated too short, see comment in numpy.pxd s   Non-native byte order not supported %s  Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. int Stan model {} does not contain samples. c:\users\appveyor\appdata\local\temp\1\tmppbp3f1\stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.pyx self        data sim model_name model_pars par_dims mode inits stan_args stanmodel date =   ndarray is not Fortran contiguous               num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names numpy.core.umath failed to import       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711  Couldn't allocate space for StanArgs.   Format string allocated too short.      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.__getitem__ genexpr stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.__getstate__.genexpr        attr_names              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.__getstate__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.__setstate__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.__reduce__          stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.num_failed.__get__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.num_failed.__set__  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.test_grad.__get__   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.test_grad.__set__   list    Expected %.16s, got %.200s              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.inits.__set__   list        Expected %.16s, got %.200s              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.par.__set__ dict    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.value.__get__       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.value.__set__       Expected %.16s, got %.200s      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.args.__set__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.mean_lp__.__get__   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.mean_lp__.__set__   list    Expected %.16s, got %.200s              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder.sampler_param_names.__set__ list    Expected %.16s, got %.200s  list        Expected %.16s, got %.200s              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._pystanholder_from_stanholder    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._dict_from_stanargs      'NoneType' object has no attribute '%.30s'      'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable          stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._set_stanargs_from_dict          stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._dict_to_vars_r  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._dict_to_vars_i  _call_sampler_star              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._call_sampler_star       _call_sampler   _call_sampler   _call_sampler   _call_sampler           stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._call_sampler    dict    Expected %.16s, got %.200s              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711._call_sampler    __cinit__       tuple index out of range        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__cinit__  __init__        __init__                stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__init__           stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__getstate__.genexpr       attr_names  self        genexpr plot    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__getstate__       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__setstate__       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__reduce__ plot    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.plot       'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.plot       traceplot       traceplot               stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.traceplot          stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.traceplot  extract extract 'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.extract    'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.extract            stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__unicode__        stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__str__            stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__repr__           stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.__getitem__        summary summary stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.summary            stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.summary    log_prob        log_prob                stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.log_prob           stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.log_prob   grad_log_prob   grad_log_prob           stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.grad_log_prob      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.grad_log_prob      'NoneType' object is not subscriptable          stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_adaptation_info        get_logposterior        get_logposterior                stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_logposterior   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_logposterior   get_sampler_params      get_sampler_params      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_posterior_mean stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.unconstrain_pars   list index out of range args    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_seed           stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.get_stancode       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.flatnames.__get__  'NoneType' object has no attribute '%.30s'      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._verify_has_samples                stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._update_param_oi   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._get_param_names   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._get_param_fnames_oi               stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._get_param_names_oi                stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._get_param_dims    stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._get_param_dims_oi stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.constrained_param_names            stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.unconstrained_param_names          stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model._call_sampler  dict        Expected %.16s, got %.200s              stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model.sim.__set__        PyObject_GetBuffer: view==NULL argument is obsolete #   numpy.ndarray.__getbuffer__ 0   numpy.PyArray_MultiIterNew1 0   numpy.PyArray_MultiIterNew2 #   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 #   numpy.PyArray_MultiIterNew5 ,   'NoneType' object is not iterable       'NoneType' object is not subscriptable  tuple   Expected %.16s, got %.200s      numpy._util_dtypestring numpy.import_array      numpy.import_array      numpy.import_umath      numpy.import_umath      numpy.import_ufunc      numpy.import_ufunc      vector.to_py.__pyx_convert_vector_to_py_double          string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string        string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string          string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string              vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___       string.from_py.__pyx_convert_string_from_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.from_py.__pyx_convert_vector_from_py_size_t      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ inits       vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__      num_failed      test_grad   value   chains  args        mean_pars       mean_lp__       adaptation_info sampler_params  sampler_param_names ,   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.PyStanHolder ,   Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  plot        traceplot       extract __unicode__ ,   summary log_prob        grad_log_prob   get_adaptation_info ,   get_logposterior        get_sampler_params      get_posterior_mean      unconstrain_pars        get_seed        get_inits       get_stancode    get_stanmodel   _verify_has_samples .   _update_param_oi        _get_param_names        _get_param_fnames_oi    _get_param_names_oi .   _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames   data        model_name      model_pars      par_dims    mode    inits       stan_args       stanmodel   date                stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.StanFit4Model    Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.__pyx_scope_struct____getstate__ stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.__pyx_scope_struct_1_genexpr ,   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.__pyx_scope_struct_2___getstate__                stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.__pyx_scope_struct_3_genexpr ,   PyStanHolder    StanFit4Model   type    __builtin__ dtype   numpy       flatiter    numpy       broadcast   numpy       ndarray numpy   ufunc   numpy   stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711  __builtin__ 1.0 cython_runtime  __builtins__    __name__                init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711 throw       init stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711 1.0 name '%.200s' is not defined            free variable '%s' referenced before assignment in enclosing scope       while calling a Python object   while calling a Python object  NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      '%.200s' object is not subscriptable    cannot fit '%.200s' into an index-sized integer too many values to unpack (expected %zd)        need more than %zd value%.1s to unpack  at least        at most exactly %.200s() takes %.8s %zd positional argument%.1s (%zd given) 1.0 %s() got multiple values for keyword argument '%s'      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    '%.200s' object is unsliceable  Missing type object 1.0 Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      'NoneType' object is not iterable       Missing type object 1.0 Cannot convert %.200s to %.200s '%.50s' object has no attribute '%.400s'        cannot import name %.230s       %s (%s:%d)      value too large to convert to int       can't convert negative value to int t   value too large to convert to unsigned int      can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t        can't convert negative value to pystan::stan_args_method_t      value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t       value too large to convert to pystan::optim_algo_t      can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t        can't convert negative value to pystan::variational_algo_t      value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long      can't convert negative value to long    _cython_0_28_3  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing A   can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object [   _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections.abc collections ,   Cython module failed to register with collections.abc module    Cython module failed to register with collections module        backports_abc   send    send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.   throw               throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    close       close() -> raise GeneratorExit inside generator.        gi_running      gi_yieldfrom    object being iterated by 'yield from', or None  gi_code __name__        name of the generator   __qualname__    qualified name of the generator generator   %d.%d       stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711          compiletime version %s of module '%.100s' does not match runtime version %s ]   %.200s.%.200s is not a type object              %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __%.4s__ returned non-%.4s (type %.200s)    long        an integer is required  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Argument n out of range: got %1%        boost::math::prime<%1%> is not converging       grad_reg_inc_gamma      is not converging       grad_reg_inc_gamma  lp__    user    user        TEST GRADIENT MODE              Sample generated by Stan (Automatic Differentiation Variational Inference)      Sample generated by Stan (Automatic Differentiation Variational Inference)      This is Automatic Differentiation Variational Inference.         procedure.)    (EXPERIMENTAL ALGORITHM: expect frequent updates to the  seconds        Gradient evaluation took         seconds.       1000 iterations under these settings should take        Adjust your expectations accordingly!   lp__    lp__    STAN OPTIMIZATION COMMAND (LBFGS)       init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  #   tol_param =     tol_rel_obj =   tol_rel_grad =  history_size =  seed =  Point Estimate Generated by Stan (LBFGS)        stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj #   tol_rel_grad    history_size    seed    lp__    STAN OPTIMIZATION COMMAND (BFGS)        init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  =   tol_param =     tol_rel_obj =   tol_rel_grad =  seed =  Point Estimate Generated by Stan (BFGS) stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj #   tol_rel_grad    seed    lp__    STAN OPTIMIZATION COMMAND (Newton)      Point Estimate Generated by Stan (Newton)       stan_version_major      stan_version_minor      stan_version_patch  init    seed    lp__        initial log joint probability =         Iteration       Log joint probability =         . Improved by   Sample generated by Stan        Sample generated by Stan        Must use algorithm="Fixed_param" for model that has no parameters.              Warning: warmup will be skipped for the fixed parameter sampler!        No sampler matching HMC specification!  boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.        boost::math::cbrt<%1%>(%1%) =   0.003379167095512573896158903121545171688       -0.000322780120964605683831 #   -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228          C:\bld\fbprophet_1529034466179\_h_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1529034466179\_h_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   t_change    a_row       *** IF YOU SEE THIS, PLEASE REPORT A BUG ***     Log probability=   error       finite diff model   value       param idx   =   #   =   #   =   #   =   #   =   #   =   #   =   #   =   #       initial log joint probability =             Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   initial log joint probability =             Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   #   #   #   #   )        (Chain     .    is written to file     Sample of chain         Exception initializing step size.       Exception initializing step size.       0.003379167095512573896158903121545171688       -0.000322780120964605683831 1.0 -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  1.0 1.0 0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  1.0 1.0 -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%) 1.0 -0.0020713321167745952  Argument a to the incomplete gamma function must be greater than zero (got a=%1%).              Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   0.9016312093258695918615325266959189453125e-19  -0.045251321448739056   -0.28919126444774784    -0.65031853770896507    -0.32555031186804491    0.25479851061131551 A   -0.55789841321675513e-6 0.0021284987017821144   0.054151797245674225    0.43593529692665969 t   1.4606242909763515      2.0767117023730469      ibeta_derivative<%1%>(%1%,%1%,%1%)              The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).           Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)          Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  delta   t_change    gamma   A   Y       *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    A   t   A   cap Y       *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable  attempts.  ,   ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization from source failed.      t_change    delta   gamma   A   t   A   Y       *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    cap A   t   A   Y       *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1% -0.324588649825948492091e-4 %1% -0.541009869215204396339e-3 :   -0.259453563205438108893e-3 %1% 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 :   -0.223352763208617092964e-6 %1% 0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 :   -0.240149820648571559892e-1 %1% -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 k_s 0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 k_s 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 k_s -0.827193521891290553639e-6 k_s -0.100666795539143372762e-2 k_s 0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. ,   Result of tgamma is too small to represent. k_s Result of tgamma is denormalized.       Result of tgamma is too large to represent. k_s Result of tgamma is too large to represent. k_s Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)          The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)          Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                The argument a to the incomplete beta function must be >= zero (got a=%1%). k_s The argument b to the incomplete beta function must be >= zero (got b=%1%). k_s The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.          The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. nan Result of tgamma is too small to represent. NAN Result of tgamma is denormalized.       Result of tgamma is too large to represent. %1% Result of tgamma is too large to represent. :   Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) delta   t_change    gamma   gamma       *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    Rejecting initial value:          Error evaluating the log probability at the initial value.    Rejecting initial value:          Log probability evaluates to log(0), i.e. negative infinity.    Stan can't start sampling from this initial value.    Rejecting initial value:          Gradient evaluated at the initial value is not finite.          Stan can't start sampling from this initial value.     attempts.  %1% ) failed after  Initialization between (-                Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization partially from source failed.    delta   t_change    gamma   gamma       *** IF YOU SEE THIS, PLEASE REPORT A BUG ***    normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1% boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.324588649825948492091e-4 1.0 -0.541009869215204396339e-3 1.0 -0.259453563205438108893e-3 1.0 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 1.0 -0.223352763208617092964e-6 )   0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 %1% -0.240149820648571559892e-1 :   -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 0.0 0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 1.0 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 1.0 -0.827193521891290553639e-6 1.0 -0.100666795539143372762e-2 1.0 0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   -5.2487866627945699800e-18      -1.5982226675653184646e-14      -2.6843448573468483278e-11      -3.0517226450451067446e-08      -2.5172644670688975051e-05      -1.5453977791786851041e-02      -7.0935347449210549190e+00      -2.4125195876041896775e+03      -5.9545626019847898221e+05      -1.0313066708737980747e+08      -1.1912746104985237192e+10      -8.4925101247114157499e+11      -3.2940087627407749166e+13      -5.5050369673018427753e+14      -2.2335582639474375249e+15      -4.8527560179962773045e+03      1.0377081058062166144e+07       -1.2207067397808979846e+10      7.8858692566751002988e+12       -2.2335582639474375245e+15      -9.6090021968656180000e+00      3.1611322818701131207e+01       -2.3517945679239481621e+01      5.5674518371240761397e+00       -4.4700805721174453923e-01      1.3067392038106924055e-02       -2.2210262233306573296e-04      -3.1446690275135491500e+01      8.5539563258012929600e+01       -6.0228002066743340583e+01      1.3982595353892851542e+01       -1.1151759188741312645e+00      3.2547697594819615062e-02       -5.5194330231005480228e-04      -1.9705291802535139930e-19      -6.5245515583151902910e-16      -1.1928788903603238754e-12      -1.4831904935994647675e-09      -1.3466829827635152875e-06      -9.1746443287817501309e-04      -4.7207090827310162436e-01      -1.8225946631657315931e+02      -5.1894091982308017540e+04      -1.0588550724769347106e+07      -1.4828267606612366099e+09      -1.3357437682275493024e+11      -6.9876779648010090070e+12      -1.7732037840791591320e+14      -1.4577180278143463643e+15      -5.1326864679904189920e+03      1.1594225856856884006e+07       -1.4386907088588283434e+10      9.7887501377547640438e+12       -2.9154360556286927285e+15      -6.0437159056137599999e-02      8.5591872901933459000e-01       -1.9746376087200685843e+00      1.3960118277609544334e+00       -3.4198728018058047439e-01      2.9204895411257790122e-02       -8.9359825138577646443e-04      1.4582087408985668208e-05       -3.8806586721556593450e+00      3.2593714889036996297e+00       -8.5017476463217924408e-01      7.4212010813186530069e-02       -2.2835624489492512649e-03      3.7510433111922824643e-05       boost::math::bessel_ik<%1%>(%1%,%1%)            Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.   initialized to invalid value ( Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::expm1<%1%>(%1%)    -1.2117036164593528341e-01      1.0344222815443188943e+02       -3.6629814655107086448e+04      6.6302997904833794242e+06       -6.2140700423540120665e+08      2.7282507878605942706e+10       -4.1298668500990866786e+11      9.3614022392337710626e+02       4.5612696224219938200e+05       1.3985097372263433271e+08       2.6328198300859648632e+10       2.3883787996332290397e+12       4.8591703355916499363e+01       7.4321196680624245801e+02       4.4176707025325087628e+03       1.1725046279757103576e+04       1.0341910641583726701e+04       -7.2879702464464618998e+03      -1.2254078161378989535e+04      -1.8319397969392084011e+03      -2.5258076240801555057e+01      3.3307310774649071172e+02       -2.9458766545509337327e+03      1.8680990008359188352e+04       -8.4055062591169562211e+04      2.4599102262586308984e+05       -3.5783478026152301072e+05      8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04       1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01      9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03 0.0 1.4130e+03      5.46860286310649596604e-04      -1.0767857011487300348e-02      1.0650724020080236441e+01       -4.4615792982775076130e+03      9.8062904098958257677e+05       -1.1548696764841276794e+08      6.6781041261492395835e+09       -1.4258509801366645672e+11  1.0 1.0742272239517380498e+03       5.9117614494174794095e+05       2.0228375140097033958e+08       4.2091902282580133541e+10       4.1868604460820175290e+12       4.6179191852758252278e+00       -7.5023342220781607561e+03      5.0793266148011179143e+06       -1.8113931269860667829e+09      3.5580665670910619166e+11       -3.6658018905416665164e+13      1.6608531731299018674e+15       -1.7527881995806511112e+16  1.0 1.3886978985861357615e+03       1.1267125065029138050e+06       6.4872502899596389593e+08       2.7622777286244082666e+11       8.4899346165481429307e+13       1.7128800897135812012e+16       1.7253905888447681194e+18   0.0 -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06  1.0 -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06  0.0 3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04   1.0 8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) -1.8402381979244993524e+01      1.0102532948020907590e+04       -2.1287548474401797963e+06      2.0422274357376619816e+08       -8.3716255451260504098e+09      1.0723538782003176831e+11   1.0 6.6475986689240190091e+02       2.3889393209447253406e+05       5.5662956624278251596e+07       8.1617187777290363573e+09       5.8873865738997033405e+11       1.7427031242901594547e+01       -1.4566865832663635920e+04      4.6905288611678631510e+06       -6.9590439394619619534e+08      4.3600098638603061642e+10       -5.5107435206722644429e+11      -2.2213976967566192242e+13  1.0 8.3030857612070288823e+02       4.0669982352539552018e+05       1.3960202770986831075e+08       3.4015103849971240096e+10       5.4266824419412347550e+12       4.3386146580707264428e+14       -1.7439661319197499338e+01      2.1363534169313901632e+04       -1.0085539923498211426e+07      2.1958827170518100757e+09       -1.9363051266772083678e+11      -1.2829912364088687306e+11      6.7016641869173237784e+14       -8.0728726905150210443e+15  1.0 8.7903362168128450017e+02       5.3924739209768057030e+05       2.4727219475672302327e+08       8.6926121104209825246e+10       2.2598377924042897629e+13       3.9272425569640309819e+15       3.4563724628846457519e+17       8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04   1.0 1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01  1.0 9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       boost::math::bessel_y0<%1%>(%1%,%1%)    Got x = %1% but x must be non-negative, complex result not supported.   -3.1714424660046133456e+02      2.2157953222280260820e+05       -5.9157479997408395984e+07      7.2144548214502560419e+09       -3.7595974497819597599e+11      5.4708611716525426053e+12       4.0535726612579544093e+13   1.0 8.2079908168393867438e+02       3.8136470753052572164e+05       1.2250435122182963220e+08       2.7800352738690585613e+10       4.1272286200406461981e+12       3.0737873921079286084e+14       -1.2337180442012953128e+03      1.9153806858264202986e+06       -1.1957961912070617006e+09      3.7453673962438488783e+11       -5.9530713129741981618e+13      4.0686275289804744814e+15       -2.3638408497043134724e+16      -5.6808094574724204577e+18      1.1514276357909013326e+19   1.0 1.2855164849321609336e+03       1.0453748201934079734e+06       6.3550318087088919566e+08       3.0221766852960403645e+11       1.1187010065856971027e+14       3.0837179548112881950e+16       5.6968198822857178911e+18       5.3321844313316185697e+20   0.0 -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06  1.0 -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06  0.0 3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04   1.0 8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%) 1.0 boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  5.8599221412826100000e-04       1.3166052564989571850e-01       1.1999463724910714109e+01       4.6850901201934832188e+02       5.9169059852270512312e+03       2.4708152720399552679e+03       -2.4994418972832303646e+02      2.1312714303849120380e+04       -1.6414452837299064100e+00      -2.9501657892958843865e+02      -1.7984434409411765813e+04      -3.7333769444840079748e+05      -1.6128136304458193998e+06  1.0 -2.5064972445877992730e+02      2.9865713163054025489e+04       -1.6128136304458193998e+06      1.1394980557384778174e+02       3.6832589957340267940e+03       3.1075408980684392399e+04       1.0577068948034021957e+05       1.7398867902565686251e+05       1.5097646353289914539e+05       7.1557062783764037541e+04       1.8321525870183537725e+04       2.3444738764199315021e+03       1.1600249425076035558e+02   1.0 2.0013443064949242491e+02       4.4329628889746408858e+03       3.1474655750295278825e+04       9.7418829762268075784e+04       1.5144644673520157801e+05       1.2689839587977598727e+05       5.8824616785857027752e+04       1.4847228371802360957e+04       1.8821890840982713696e+03       9.2556599177304839811e+01       boost::math::bessel_k0<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported   4.8127070456878442310e-01       9.9991373567429309922e+01       7.1885382604084798576e+03       1.7733324035147015630e+05       7.1938920065420586101e+05       -2.2149374878243304548e+06  1.0 -2.8143915754538725829e+02      3.7264298672067697862e+04       -2.2149374878243304548e+06      -2.2795590826955002390e-01      -5.3103913335180275253e+01      -4.5051623763436087023e+03      -1.4758069205414222471e+05      -1.3531161492785421328e+06  0.0 1.0 1.0 -3.0507151578787595807e+02      4.3117653211351080007e+04       -2.7062322985570842656e+06      6.4257745859173138767e-02       7.5584584631176030810e+00       1.3182609918569941308e+02       8.1094256146537402173e+02       2.3123742209168871550e+03       3.4540675585544584407e+03       2.8590657697910288226e+03       1.3319486433183221990e+03       3.4122953486801312910e+02       4.4137176114230414036e+01       2.2196792496874548962e+00       3.6001069306861518855e+01       3.3031020088765390854e+02       1.2082692316002348638e+03       2.1181000487171943810e+03       1.9448440788918006154e+03       9.6929165726802648634e+02       2.5951223655579051357e+02       3.4552228452758912848e+01       1.7710478032601086579e+00       boost::math::bessel_k1<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)              The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1% Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1%                       "                            "            	   l            "                           "               P            "           t P                                  +eG?+eG?            "~+@"~+@W6}+W6}+      ?      ?      ?      ?    @.?    @.?ʫy>ʫy>K͉ ?K͉ ?_6.>_6.>~,?~,?9d?9d?t	?t	?       @       @"   #            #            "   $$            H$            "   D)            x)            "   -            ,.            "   l.            .            "   .            .            "   /            40          "   <6            x6 @          "   6            47           "   7            7            "   8            88            "   t8            8            "   8             9            "   9            P9            "   x9            9            "   :            |:            "   :            ; @         "    <            <            "   <            = @         "   $>            >            "   >    ?    L?            "   |?             @           "   @            4A           "   A            HB           "   B            \C           "   C            pD P          "   D            E            "   E            @E            "   XE            |E            "   E            E            "   E            E            "   F            8F            "   PF            tF            "   F            F            "   4G         	   G           "   G         	   \H           "   H            |I           "   J            J           "   K            L h         "
   hM            `N P         "    O            O           "   (P    tP    P           "   PQ    Q    XR @         "   HS            ,T          "   T         &   V (         "
   X    X    0Y P         "   Y            |Z           "   Z            [           "   \            \           "   h]    ^ (   _          
   @   6
   
      6
   @
      P   
      P   H
      P   
      P   X
      P           "                           
      P   `
      P   
      P   p
      P           "                                   "               4                    
      N
   N
   N
   N
   N
   N
   N
   N
   p
   N
   N
       
   p   N
   P   N
   N
   `
                 bad lexical cast: source type value could not be interpreted as target  bad cast                @
   N
   N
   N
   N
   N
   N
   N
   N
   N
   @   
   \       -q=0
      P   double  long double             "               0a              E@'
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        "               a                    
      N
                       
      `                             ?        P
      P   }   0           @   P       "   j            a                    "               a                    "               b            ]        [origin:        
      P   
       P   0
   P   P   bad exception   
      P   bad typeid      
       P   vector<T> too long      "   0b            @b            invalid vector<T> subscript             "   0b            pb                    "       b    b 0                  "       c    @c 0                  "       c    c 0                  "       c    d 0                  "       Pd    xd 0                  "       d    d 0                  "        e    He 0                  "       e    e 0                  "       e    f 0                  "       Xf    f 0                  "       f    f 0                  "       (g    Pg 0                  "       g    g 0                  
   N
   N
   N
   N
   N
   N
   N
   N
           
   N
   N
   N
   N
   N
   N
   N
   N
           
   N
   N
   N
   N
   N
   N
   N
   N
           but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  "   g         	   h            Unknown termination code                Line search failed to achieve a sufficient decrease, no more progress can be made       Maximum number of iterations hit, may not be at an optima               Convergence detected: absolute parameter change was below tolerance             Convergence detected: relative gradient magnitude is below tolerance    Convergence detected: gradient norm is below tolerance  Convergence detected: relative change in objective function was below tolerance Convergence detected: absolute change in objective function was below tolerance Successful step completed       -DT!	@Adaptation terminated         ?      @                    @      (@       @      @            P>      <     (@ox?p
   p   P    P   @   @   
   p   P    P   @   @   "   i             i                                             
 
                     	               	               
                                                 ?   =
?   @33?   =
?      ?   ?    ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@"               Li            kﴑ[?;f?     
   
                 m0_?Q63E?mBP
?        "               i                          ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adxp
      
              
          0      0(   p'   '   &   @&   @           "   j             j                  "   Hj            Pj                    "   j    j 
   j                    "   k    hk 
   k                    "   {            (l                :   "   y            ll 0          (       ) must match in size     (  ) and               "   y            l 0                  H
      0         P      p   5	           
      0         P      p   5	           H
   P

   0         P   '
   p   y
           "   {            m                    "   {            n                    "   {            tn            is      , but must be > 0!      , but must be finite!   "   to            4o 0          , but must be greater than or equal to  "   to            o 0                  "   {            o                    "   {            p             seconds (Total)         seconds (Sampling)      seconds (Warm-up)       Elapsed Time:  "
   Pp            p p                  
   v   N
   T
   Z
   `
   f
   l
   r
   x
   `          ~
   
       ?1~ʉʐ|E~Pۆ,̿]g?~vt`2?A<?4`Bkʫ?}
|;¿ȼu??    ?kr	`?[}`?P=x:?/@V;0@{R=a? ZpPT*b!ezFĿp2ڿ2s"\ڿ1i5ϸaƯ?      ?    X?IWUQ{-?f/Ҁ? BN?R?׹^oyd?S?=QAV 1 Lé?]OL?̺?`w"       q    q                    "       Dr    lr                    "   y            r 0          [       "       Ps    xs            
   N
           "   t            t            invalid alignment to 8 bytes, ptr=      uninitialized   "   {            (u             and    expecting index to be between    out of range;  index   : accessing element out of range.       ; index position =              "   lu            u            ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration           "   u            @v p                     term_buffer =                   adapt_window =                  init_buffer =                 Defaulting to a 15%/75%/10% partition, ?333333?         overflow the total number of warmup iterations.                WARNING: The initial buffer, adaptation window, and terminal buffer              performed for num_warmup < 20   estimation is  WARNING: No           Y@ =  ,   "   w            w                    "   w            w                    "   $x            ,x                    "               Xx                    "               x                    "               x                    "   x            x            
   +   
   ,           "       y    Dy                    "   y            y 0                  "   (            y            h
   `3   
   `   P   
   @y   0   p4   X
   4   
       P   , but must not be nan!  , but must be >= 0!     
   4   P   @
           Pp	       
           Pp	       P
           Pp	       has dimension =         multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         "   to             z 0                  "   \z            |z 0              d?Eĵ@oI+@P	6@"ܢ}/@^ʥ
&@`I2W@DNxR	x3j濍4c08˿ą@?A!y?    dL?      @[sS/k??~}?rJ󓉸?0"S?7¬?O~x>2Lf0?kFoa?@8?Ų"?Zf0h?      @    7?HS 	p?رo߬??Io?Ж}?/ēr.?Mj?DbjT?u`v`?TEvʣ?:8      @    ?H P>ئ8?ҍ?Uh?0?^бF?{]?i?tiY?K_n!r?\v?7<
w   @33@      <@    ?oN8?S(c?ng?`<?,7Z'5ICcaI`տж)[?      ?#6k?|="   \z            `{ 0                  "   {            {                    "       |    8|                    "   y            | 0                  "   ܃            |            
   H    
    H   6
   (
   0H   6
           "   ܃            |            
   H   P
      P   "   X}            ,}                    "   X}            `}                    "               }                    "               }            
    y      0M   
   @M   
      P   
   y      M   
   M   6
   
      
   y      N   
   N   6
    
       
   `y   `   O   
   O   
   `   P   ^^^^^^ܿYY|?qAAp?UUUUUU?    ?   n?=  @cb?HO

oa?,aȹ?6(]?0ɗ^?AMg @7%l`x<rc.+ҿZ)nh/AԿxIiN?e;"   to             0          []      size of         "       \                        "   to              0                  "   p    H                        "                           
   @e   
   P      "                           
   y      f   
   f   
         
   v   N
   T
   Z
   `
   f
   l
   r
   x
   `          ~
   
   ?      .@{T4bU@
+/NW+@HM%;KZr?a7	Bu?u"7#?@&p7*E@wǛܿ&-DٔÊ?39e0!cAg?IBx.ȼ٥m4XL.Q$]WsAb`CF:ey_b
٢+8 ,"zYǣp0ih8vJU;È[1
@Y?4뿡i?6+Ab\ƖG?7pc?,xV?_տZ?:ղ>GHM]!_k;>fAδ>6
)%$Ç5=ΡB)r
@.ցǼ]?t	${?N`Ch6޿
NMfV|O102dQ*Cv=?	h@k}}Sų()%a5"   y             0                  "   ܃                        0
   Ї   
      P   "   (            8            
      X
   @   P   
   py   p      
      
   @   P   
   0y          
   Њ   
       P          @      p?E6`     @JQ5     @Pr@	ouU@{@@ZG@FLHnAC&kĨ5A
B;AžѠ%A.A@wp@6Ґ@
b-(@M @O:8@u	2/Ʋ7wȳYXzbqw.`b YI?76O0Y)МbZFtP,811AMʲ@{aUA7oTPB[MBbzsFmNCZCRοx@MUNXG`SAF1TBU·J
&C3"OUFeȐ@5J
"AK5A)꾙#B$vBMu
TLm+M%@ÈIc⃼A)*-ANՎ]@"   (            P            
   @   
   p   P   "                                   "                           
   y   P   P   p
   `   
   0   P   
   Ч   P           _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?        $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?        "   ܃                        P
              "               H                    "               t            @
   Py   @      
      x
   
   P   "                            Expecting a square matrix; rows of      columns of      "   to            ؇ 0          ]=      is not lower triangular;        "   to             0          lb_free Lower bounded variable          "               <                    "               h           Number of posterior samples for output  Evaluate ELBO at every eval_elbo iteration      Number of Monte Carlo samples for ELBO  Number of Monte Carlo samples for gradients     stan::variational::advi "                                 $@"       l                        "                                   "   $            ,               "   $            T                    "               |               "                                   "                                  "   p            8                    "   p                                "                                  "                                   "   T            d            assign  right-hand side left-hand side  "                              "   $            4                    "   l            |                    "                                   "   ,            <                    "   d    <                        "                                   "   to             0                  "               p                    "                                   "               ̑                   "               0                   "                                   "   Ȓ            ؒ                  ?ȅeA?     @&GVW     @@E.,[@@.=@/R V@hcjzB@,G`@ N@Nj֐W@
z=4L6}(e[ NV` l=gW/7c@14=]@)3M3@oַ@Zw?ub8c@L1@t@WY_,0@t>@1Ds+t@HB9M_L\?>@%_ qwV.8Ao+#LKH@1%9@xB)A@~@>F2@4bwI+1
  Z,h-A@VA!q髠AHps!BՉp³`BfTO)QwMY@!|l!hBGJYA(z-	X"                                   "               Г                    "                                   "               L                   "                                   "               l                    "                                   "                                  "   @            P                    "                                   "
               p           ; position=     mismatch in dimension declared and found in context     ; dims found=   ; dims declared=        mismatch in number dimensions declared and found in context     ; base type=    ; variable name=        ; processing stage=     variable does not exist int variable contained non-int values   int     dot_product v2  v1      h
              "                               "   L            d                    "   \                                "                                   "   ԡ                                "   `                               "                                  "       h                        "   ԡ            Н                    "                                   "   X            p                    "   ԡ                             @@      @      @      @      ?      ?        "   ԡ            0                    "                                   "               $                  "   ԡ                                "   ԡ                                "   ԡ                                "       4    \                    "   ԡ            ܡ                    "   l                               "   l            |                   "   \                                "               ,            
   g    i               "                           X
   g    i               "                           Mean vector     Dimension of input vector       Dimension of current vector     Dimension of mean vector        Dimension of Cholesky factor    Cholesky factor         
                                      0           "   0b                        vector provided does not match the parameter length     "        ؤ                        "        
                       "        
                       "   ħ    t     H                  "        
                       "   d                                "   8            X                    "   d                                "   -                                 X
      N
                        Г   "               4            Step size =             "            0                  "                                   "               $                    "   D            L                    "           Ȭ                    "                H p                  "                                   "   ܭ         	                      "               |                    "               ̮                    "                                   "       ̯     0                  "   \            d                    "           ̰                    "       ر      0                  "       X                        "           $ 0                  
   P   	      `                Г   `
      P	   `   `                Г   p           "   i            l                    
      	      @            ж      "                                   
   @    	   `               з      p           P
   6	   	         p         0       "                                   0
      	   `   P   p         0       p           "       L 
    0                  "                           circular_buffer         "   T            \                    "           ص                    "   @            `                    C:\bld\fbprophet_1529034466179\_h_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     no more scalars to read "   @                        double __cdecl stan::io::reader<double>::scalar(void)   "   ,        D                    "            	                      "                L p                  "           ̸ 0                  "            	              numeric overflow        "            0          Value %1% can not be represented in the target integer type.            "               P `                  "                `                  "   l             0                  "   l            ̻ 0          
              "   $            , 0                  "   \            l                    "   \                                "
               < `           is needed.      is found, but  array is not long enough for all elements:              C:\bld\fbprophet_1529034466179\_h_env\lib\site-packages\pystan\stan\src\stan/io/array_var_context.hpp           void __cdecl stan::io::array_var_context::validate<double>(const class std::vector<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >,class std::allocator<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > > > &,const class std::vector<double,class std::allocator<double> > &,const class std::vector<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> >,class std::allocator<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> > > > &)   ).  should be no smaller than number of parameters (found   )       size of vector of dimensions (found             0
   P   	      `                Г   energy__        int_time__      stepsize__      
      P	   `   `                Г   p           "               4            divergent__     n_leapfrog__    treedepth__             "               Ծ            H
   `       P
   0   	      `                Г   h
   `              p
      	   `   `                Г   p           "   T-            D            H
   `       
   0
   

      @            ж      "   -                            `      p
   `
    
   `               з      p           "   J            ̿               `           
    
         p         0       "   J            `               `         
   0
   `   P   p         0       p           "                                   "   p             0          rep_array   n           "   4            <                    "   p            x            Overflow Error          "        #                      "                                   "   $            ,                   "       p                    6s?D?    ͜?{>MA?      ?Dݿf2	A?ʇƅȏD?{    ͜Vph?4W'ђ
cՇ?MA6;
>boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)              @!?     X@i4E?     @=Ը.h?     l@!X@VMS@Ը.?t AmqDx@3q&zA5X3=4BIB~Ӝ+C+/CD뤍p1o}/@L}<cn[P\AD
F
C9=£:CM%<<w@=JKAskPA-խBTB
胩BϚnsfQm1@_7QADT4jM$B?gx	`144o5Ƅ@cto)
AdˊA
q"aB"gAd[ag2"7D@yxl=@M/")8B%/bXAa۾     @!]?     @.N@CԾ@m@c/ALyo&AfdQBmbgoB5c[CvACt<DQ9=AFFFUB@ͷ1I/-U,CeawTïT]Cd@FAO'|5A)ÊB+EhBxBNsA?_5[A\At<U,o"B@4W=A1nBdAMi@OP@$@̴F@钳|A0U&@@<I;@	Ch@O'R#W@OQ|\@Ƭ@
R,X@@ n%=APnAT)Qx@jۧa@f\( ]@P@Topvm*@<!\C'"]I{f)DCprd
8`6>o}'-@c03C?@?I'@$H}@إ@9VkM@	# B@4t@<r@93@7V`c@gPUJ@n28p@z86V?BlFA@2s?
;@:goz`@b]W@O♿@"@!V@
o'iϔ@,Su@#1@4F@3!$sX7&D}
@Ny-Ϳ<MJr~)X7&4Sq`	2@T)#?rX@'#oˉ@?d=쩥A%f:%Aq@        "   4            <           boost::math::trunc<%1%>(%1%)    boost::math::expm1<%1%>(%1%)            "   \                                "   \            @                    "
                                   "               x            @   \   Y      \    Z           "   H                                "   (                                "   d                        P   \   \      \   ]           "   H            P                    "                           `   \   @_   "                              \   ``   p   \   a           "   H                                "   (            0                    "   d            l            P	   \   c   "   H                        	   \   d   X
   \   d   
   \    e   "   H                        #B;      C        "                           `   \   f   "   0            8            accept_stat__   lp__    "   t         	               g_  p_  "O           T H         Error transforming variable beta:       Error transforming variable sigma_obs:  Error transforming variable delta:      Error transforming variable m:  Error transforming variable k:  variable beta missing   beta    variable sigma_obs missing      sigma_obs       variable delta missing  delta   variable m missing  m   initialization  variable k missing  k   :0yE>        "   \"              0          beta_a  beta_m  Y   trend               "   \         )    H                  "                (          invalid map/set<T> iterator             "               ( 0                  "   ,        D 8                  "            8                  "   T            \                    "                                   "   T                                "   T         	   |                    "	               ,                   "           t                   "   t    L                       "       t 	    (          Evaluation of function at pole %1%      "   x             8                  "               0                    "   l             P                  "                                   "                                   "                                   "   <                                "   d                        stan::variational::normal_fullrank      "                                   "   <            T                    "                                   "                0          Log std vector  Dimension of log std vector     stan::variational::normal_meanfield     "   d            |                    "	                                   "            0                  "            0                  "               4 0          map/set<T> too long     "            0                  "                0          log1p<%1%>(%1%) log1p(x) requires x > -1, but got x = %1%.              "                                   "   D            L                    "            0                  "        +    0         X   s_a s_m             "   D            d                   "                                  "               d @                  "   $     	   T (                  ".   ,     1    H                 "   @            H               \   4   "                                   "   @     ,     8                 "                            
   >"   4            D            boost::math::digamma<%1%>(%1%)  boost::math::itrunc<%1%>(%1%)           A        "                                   "   D         
   t             A?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?        "                           stan::variational::set_mu       stan::variational::set_L_chol   Dimension of lhs        Dimension of rhs        stan::variational::normal_fullrank::operator=   stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  Input vector    stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/=         "            0                  "	               @ 0                 "	               , 0                 "	               ` 0                 "   L             l                    "                  @                  "                                   "   l            |                    "            0                      @e@-DT!	      4        gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                "            
                    >      >"                `                  "   L            \            `   g    i   `           "                H          ,       Diagonal elements of inverse mass matrix:                                                        "            	   8            `
              "                               "   x    P                        "           @ H                  "   -            $	                    
      N
                    з            Pboost::math::tgamma<%1%>(%1%)           "   	    	    @
                   "   l    D                       "                           boost::math::lgamma<%1%>(%1%)           "    
         	   @
 0                  C:\bld\fbprophet_1529034466179\_h_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/math/special_functions/owens_t.hpp              long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed                         "       
    
 0                  "   <            L @                  "   \                                "                                   "                                   "   (                              covariance         `   p   "   (            8                  variance        @   `   p   "   t                                "                                   "               l                    "                                   "               $            h              "   p                                                                                 "   0b                                "   $            4                    "   p                                h           P       P      `         p           "            
   L                    "            
                       "   \            P                    "            
                      "            
   8                   "            0                  "       T     H                  "   X            p                    "3   <     M             Undefined transformed parameter: beta_a Undefined transformed parameter: beta_m Undefined transformed parameter: Y      Undefined transformed parameter: trend          "3       t K   \ p                 "   !            ! 8          cols    rows                    1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?      ?"   \"            |"                   "   "            " P                  "	   #            #                       P    z   {   z            0~   `   "   h$            $                    "   $            $            h   g    i              "   0%         	   P% H          Elements of inverse mass matrix:        MbP?      @"   &            $&                      P    z   {   z            0~   `   "   &            & P          stan::variational::normal_meanfield::transform          "   &            &                    "   '            d'                    "   '         
   (                    "   |(            (                    "   (         	   ) h                  "               t)                    "   )            )                    "   8*    * 
   `* @                  "   +    * 
   4+ @                  "   +    +    , 0                  "   ,    ,    , 0                  h      	      @            ж         @    	   `               з      p           "   T-            \-                    "   -            -                    "   -            -                          N
           p         0       "       .    D. 0          Non-finite function evaluation. Error evaluating model log probability:         Error evaluating model log probability: Non-finite gradient.            "   .    .    |/                  "
   0            0          q=
ףp?"   H2            2                   "   $3            D3           UUUUUU?UUUUUUUUUUUU?UUUUUUMb`?MbPMb`Mb@?        "       3    3 0          {Gz?"   `4            h4                   "   5             5                    "   P5            5                    "	   6            6            vs     Number of unconstrained parameters does not match that of the model (           "	   7            $8                   "l    9    8    `<          A       trend_indicator tau     vector_d    sigmas      t_change    S   y   cap t   K   data initialization T           anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace::anon_model_db8febf10f23d7fa27a62fbcfd7f17b2              "   0b            B            Error evaluating initial BFGS point.    boost::math::owens_t<%1%>(%1%,%1%)              "   HC            hC `                  "    D    C 
    D            Scale parameter Location parameter      normal_rng      "   D            D           ؗҜ<"   E            $E                  @      ?        "   E    hE    E                   "   TF            lF `                  "   F            G                    "   PH            hH                    "   H            H                    "   @I            XI                   "   I            I                      6	   	         p         0             	   `   P   p         0       p           "   J            J                    "   J            K                    "   x            <K                    "   x            K                    "   L    K    0L X                  "   L    L    `M          The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.   Gradient of mu  Dimension of variables in model Dimension of elbo_grad  Dimension of variational q      stan::variational::normal_meanfield::calc_grad  "   N    tN "   <O 0                  "*   P    P M   R                  "   T            T                    "   T         
   U            filter is looking for elements out of range             "   U            U                    "   V            pV                    "   V            W                    "       LW    tW 0                  "    X    W    (X `          log_prob        stan::variational::advi::calc_ELBO      stan::variational::advi::calc_ELBO_grad         "   X            HY                    "   lZ    DZ    Z p                  "   0[            8[                    "   T\    [ ,   \ P                 Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.  ].  .        earlier than expected.  Found best value [eta =        Success!        ?Begin eta adaptation.   Number of adaptation iterations stan::variational::advi::adapt_eta      "   ^         )   P_                  This variational approximation is not guaranteed to be meaningful.              Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation may not have converged to a good optimum.        Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!       ?   MAY BE DIVERGING... INSPECT ELBO        MEDIAN ELBO CONVERGED           MEAN ELBO CONVERGED       @@          iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes    Begin stochastic gradient ascent.       Maximum iterations      Relative objective function tolerance   Eta stepsize    stan::variational::advi::stochastic_gradient_ascent     "
   `         	   `                    "       la    a                    "9   a         Q   c                  "   m            f p          Posterior is improper. Please check your model.         No acceptably small step size could be found. Perhaps the posterior is not continuous?  ?    cA        "   g            g                    "   d            g                    "   g            Lh          COMPLETED.       from the approximate posterior...      Drawing a sample of size    eta =       Stepsize adaptation complete.   iter,time_in_seconds,ELBO               "   4i            <i 0                  "
   i             j                  "   4i            j 0                  "
   i            Tk                  "   4i            Ll 0                  "
   i            l                  "   m            n p                  "   m            n p                  "   o    \o 
   o                    "   \p    4p 
   |p                    "   p            q `          LS failed, Hessian reset        )\(?"   dq            lq                    "   q    q 
   r                    "   r    r 
   r                    "   s    ts 
   s                    "   tt    Lt 
   t                    "   u            u X                 "   \u            du                   "   u            u                    "   u            u                   "   $v            4v 0          stan::variational::normal_fullrank::transform           "   lv            tv                    "   w            v 0                  "   w            v 0                  "   w            w 0                  "   w            <w 0                  "	   xw            w h                  "   x            x                    "   (y     y    y          stan::variational::normal_fullrank::calc_grad           "   T            z                    "   z            z                    "   L{    ${    t{ `                  "   |         
   8|                   "    }            }                   "   }    X} ,   x~ p                 "   $         )   ̀                  "   p            @ `                  "   Ȃ            (                   "	   xw             h                  "   ̄            Ԅ                   "   x                                "                                   "                (                  "                0                    "                                   "   X    0              }Ô%IJz5        "                                 "                0          Something went wrong after call_sampler.        -DT!@"                                   "                (                    "   P            X                    "                                   "                                   "                           0   
                      + 
 
                            0
         H
 p
                 +            @   
             ,             @   
                        
         p
                        8, 
 
                             
         
 p
                 8,            @   
                        `, h
 @
                            
         
 p
                 `,            @   h
                        , 
 
                             
          
 
 p
                     ,            @   
                        , p
 H
                            
         
 
 p
                     ,            @   p
                        , 
 
                            
         0
 
 p
                     ,            @   
                        - 
 X
                            
         
 
 p
                     -            @   
                        0- 
 
                             
         8
 p
                 0-            @   
                        X- 
 `
                            
         
 8
 p
                     X-            @   
                        - 
 
                            (
         H
 8
 p
                     -            @   
                        - 
 p
                            
         
 8
 p
                     -            @   
                        -  
 
                            8
         H
             -             @    
                        . 
 p
                            
         
             .             @   
                        H. 
 
                            (
         8
             H.             @   
                        . 
 `
                            
         
 
 p
                     .            @   
             .            @   
                        (
         
 p
                            . h
 @
                            
         
             .             @   h
                        (/ 
 
                            
         
             (/             @   
                        P/ X
 0
                            p
         
 8
 p
                     P/            @   X
                        
         
             /             @   
                        / 0
 
                            H
         X
             /             @   0
                        
         
             /             @   
                        0 
 
                            
         (
 X
                 0            @   
                        H0 x
 P
                            
         
 H
                 H0            @   x
                        
         
             0             @   
                        `1 H
  
                            `
         
 
 p
                     `1            @   H
                        1 
 
                            
         
 
 p
                     1            @   
                         2 X
 0
                            p
         
 H
 p
                      2            @   X
                        P2 
 
                            
         
 @
 p
                     P2            @   
             0            @   h
                        
         @
 p
                            2 
 
                            
         
 p
                 2            @   
                        2 @
 
                            X
         h
             2             @   @
                        P4 
 
                            
         
             P4             @   
                        5 0
 
                            H
         X
             5             @   0
                        
         
             7             @   
                        
         
             p8             @   
                        8
         H
             9             @    
                        0; 
 p
                            
         
 8
                 0;            @   
                        ; 
 
                            0
         H
 8
                 ;            @   
                        H< 
 p
                            
         
 
                 H<            @   
                        < 
 
                            0
         H
 
                 <            @   
                        
         
 
                 <            @   p
                        < 
 
                            
          
 
                 <            @   
                        P= p
 H
                            
         
 h
                 P=            @   p
                        > 
 
                            
          
 
                 >            @   
                        ? p
 H
                            
         
 X
                 ?            @   p
                        
         
 
                 A            @   
                        8
         P
 
                 pB            @    
                        
         
 H
                 C            @   x
                        T 
 
                            
         (
 P
                 T            @   
             T             @   x
                        
         P
                        8U 
 
                            
         
             8U             @   
                        `U @
 
                           X
         
 
 
 
                         `U            @   @
             8,    (       @   
             ,     (       @   
                        U  
 
                           8
         `
 
 
 
                         U            @    
             +    (       @   
                         V 
 
                           
         
 8
 p
 @
                          V            @   
             8U     @       @   
                @        V 
 h
                            `V 
 
                           
         
 
 8
 p
 @
 0
                                 `V            @   
             .         h      P   
                @       `V 
 X
                    x      `V 
 
                            V 
 
                           
         
 
 
 p
 @
                             V            @   
                        @W h
 @
                            
         
 
 
                     @W            @   h
                        X 
 
                            
         (
 P
 
                     X            @   
                         Z x
 P
                            
         
 
 H
                      Z            @   x
                @       V 
 
                    (       `U @
  
                    (       U  
 (
                            `[ x
 P
                           
         
 0
 
 p
 @
                             `[            @   x
                @       `[ x
 
                            [ 8
 
                           P
         
 
 
 
 p
 @
 0
                                     [            @   8
                @       [ 8
 
                    x      [ 8
 
                            P\ 0
 
                           H
         
 
 
 
 
 
                                 P\            @   0
             .         @      P   
                (       P\ 0
 
                    P      P\ 0
 
                            \ H
  
                           `
         
 `
 
 
 
 
                                 \            @   H
                (       \ H
 
                    P      \ H
 
                             ] 8
 
                           P
         
 
 0
 
 p
 @
 0
                                      ]            @   8
                @        ] 8
 
                    x       ] 8
 
                            ] 0
 
                           H
         x
 
 
 p
 
                             ]            @   0
             8U     (       @   
                (       ] 0
 
                             ^ 
 
                           0
         p
 x
 
 
 p
 
 
                                      ^            @   
             .         P      P   
                (        ^ 
 
                    `       ^ 
 
                            ^ 8
 
                            P
         p
 (
 P
                     ^            @   8
                         _ 
 
                           
         
  
 
 p
 @
                              _            @   
                @        _ 
 0
                            `_ 
 X
                           
         
 
 8
 p
 @
                             `_            @   
                @       `_ 
 
                            _ @
 
                           X
         
 
  
 
 p
 @
 0
                                     _            @   @
                @       _ @
 
                    x      _ @
 
                            @` 8
 
                           P
         
 
 
 8
 p
 @
 0
                                     @`            @   8
                @       @` 8
 
                    x      @` 8
 
                            ` 0
 
                           H
         x
 
 8
 p
 @
                             `            @   0
                @       ` 0
 
                             a 
 
                           
         H
 x
 
 8
 p
 @
 0
                                      a            @   
                @        a 
 p
                    x       a 
 
                            a 
 
                            
         (
 
 p
 @
                         a            @   
                @       a 
 P
                            b 
 x
                           
         
 (
 
 p
 @
 0
                                 b            @   
                @       b 
 
                    x      b 
 @
                            (c 
 h
                            
         
             (c             @   
                        Xc 
 
                             
         0
             Xc             @   
                        c 
 X
                            
         
 0
                 c            @   
                        c  
 
                            
         0
 
                 c            @    
                        c 
 X
                            
         
 X
                 c            @   
                        Pe  
 
                            
         8
 
 X
                     Pe            @    
                        f 
 `
                            
         
 
 X
                     f            @   
                        0h 
 
                            (
         H
 p
 X
                     0h            @   
             i            @   
                        
         p
 X
                            k 
 
                            
         (
 p
 X
                     k            @   
                        l x
 P
                            
         
 
 X
                     l            @   x
             m            @    
                        
         
 X
                            `o X
 0
                            p
         
 
 X
                     `o            @   X
                        8q 
 
                            
         
             8q             @   
                        0E X
 0
                            p
         
 8
 
 X
                         0E            @   X
                        pF 
 
                             
         (
 
 
 X
                         pF            @   
                        L x
 P
                           
         
 
 8
 
 X
 
  
                                     L            @   x
             <           @   p
             /            @   
                       L x
 H
                            N 
 p
                           
         
 (
 
 
 X
 
 @
                                     N            @   
             <           @   p
             /            @   
                       N 
 h
                            PO 
 
                           
         
 8
 H
 p
 X
 
  
                                     PO            @   
             G            @   `
                        x
         8
 H
 p
 X
                         hq           @   
                        
         
 
                 hq            @   
             /            @   
                       PO 
 H
                            P 
 p
                           
         
   (
 p
 X
                                         P            @   
             H            @   @                         X            (
 p
 X
                         hq           @   
             /            @   
                       P 
                              Q                               8         x  
 
 X
                                        Q            @                 0J            @                                     
 
 X
                         q           @   0                        H         ` 
                 q            @   0                       Q                               0S                                      0 X 
 
 X
                                       0S            @                K            @                                    X 
 
 X
                         q           @   0             /            @   
                       0S                              P         h 
                 q            @   8                                  
                  r            @                                      
                 Pr            @                           r h @                                       
                     r            @   h                        r                                       (  
                     r            @                            s x P                                       
                      s            @   x                        @s                                        8 h 
                     @s            @                            s  `                                      h 
                     s            @                           s                              (         H  
                     s            @                            t  p                                       
                      t            @                           	         (	 
                 @t            @                           pt x	 P	                            	         	 (	 
                     pt            @   x	                        t  
 	                            
         0
 
                 t            @    
                        t 
 X
                            
         
 
                 t            @   
                         u   
                                     8 (	 
                      u            @                            Xu  `                                      
                 Xu            @                           u                                        8 
                 u            @                           v  `                                      0
                 v            @                           v 
                              
         8
 
                 v            @   
                         w 
 `
                            
         
 
                  w            @   
                        i 
 
                            w 0                             H         h 
 
                     w            @   0                        q 0                             w                                        
 
                     w            @                           hq 
 @                            x  h                                      
                 x            @                           @x                              (         @ 
                 @x            @                           x  h                                      
                 x            @                           x                              (         @ H
                 x            @                            y  h                                      0
                  y            @                           0y                              (         @ H
                 0y            @                           G `
 h                            H @                              m  
                             0J                              K                              Hz X 0                            p                      Hz             @   X                                              4	 
RpB
 

 `        4	 
RpB
 
 0 U     n  4	 
RpB
 @
         2p! 4   U  L !   4   U  L !   4   U  L !   4   U  L !   4   U  L !   4   U  L !   4   U  L  
  0B
 0 
  2P           
 @
 `
 
  4 pB
 X 
  2P 2P 2P 2P                      )  G     U  
     
  4 
pB
  
  2P 2P                     
  
  
  0B
  
  2P 2P 2P        )  N     [          20        	   8, 0   @
 8   	   . p   
 8   	   0 @   
 8   	   , `    
 8   	   ,     @
 8   	   0 (   
 8   	   - 8   
 8   	   X- H    
 8   	   - X   @
 8   	   - h   
 8   	   , x   
 8   @            
 8                    B
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
 
 
2PB
  
                   @
     M
    k
     
    
     
    
     
    +
     M
    k
     
    
     
    
     
    +
     M
    k
     
    
     
    
     
    %
      20 20
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   d 4 2p 20
 
4 
2p d 4 2p 20
 
4 
2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p  
 
4 
2p d T 4 2p	 p`P0   d T 4 2p d 4 2p d 4 2p
 
0! t d T A  A    !   t  d  T A  A    !   A  A     0! t d
 T  C  AC  P !   t  d
  T  C  AC  P !    C  AC  P  t 20
 
d 
2p! 4 D  $E   !   D  $E    d T 4 2p 20 20 t	 d T 2! 4 PH  H    !   PH  H     d
 T	 2
p! 4 PI  I  8 !   PI  I  8 
 
4 
2p	 	r! 4
 K  K  | !    t d T K  K   !   t  d K  K   !   t K  K   !   K  K   !   K  K  |     20
 T 4 R
p` B  ! 4	 P  Q  4 ! t Q  Q  < !   Q  Q  < !   P  Q  4  d	 4 Rp
 t d T 4 
 
4 
2p B  
 
4 
2p T 4 R
p` B  E E4 d T 2p
 T 4 rp`!  Z  p[   !   Z  p[   
 
4 
2pK K B 9 0 +d &4
 bpP   4  2p T	 4 2p!  d @_  _  x !   @_  _  x  d T 4 pP Pd	 K4 t T
 2 B   B   B   B   B   B   B   B   B`0  !$
 $  
 
t	 T d  d     !   t	 d  d     !   d  d     
 
4 
2p< <4 
d 
2p 4  2`P0! t	 g  j    
 
4 
2p B   t 
4 
2` 20!
 
t d `m  m    !   t `m  m    !   `m  m    
 
4 
2p 20 d	 T 4 2! t `o  o  4! !   `o  o  4!  20
 
4 
2p! d 0q  vq  t! !   0q  vq  t!  R
pP0! d
 pr  r  ! !   d
 pr  r  ! !   d
 pr  r  !  4 p d 4 2p
 
4 
2p 20 20!! !	 t 
d T w  x  " !   w  x  "  B   B   20 d	 4 Rp B   B   ! " "t 20!
 !t) !d( !T' !4& !"    20
 
4 
2p B   R0 20! t Ё    " !   t Ё    " !   Ё    "  B  ! 4   Z  $# ! t  4   Z  $# !     Z  $# ) ) # x d 4 p! h   p  h# !     p  h# 
     @
    `
  4 RpB
 
  2P 2P 2P0  S      [     w            d 4 2p
  4	 
RpB
 
  2P`           B   b
p`0  !   
 T Ј    h$ !         T Ј    h$  d T 4 2p B   B  
 
4 
2p
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 d 4 2p
 d T
 4 rp b
p`0  !   
 T P  ~  % !         T P  ~  %    !` ` [T
 %  t 
d 4     (& !       (& h
 h cT ^4
 	Rp`K
 K FT
 
4 
R	p`   !Y Y TT
  t 
d 4     & !       &  20!
 
t d p    & !   t  d p    & X XT t d 4
 r b  !k k f at \d T 4
      4' !        4' !       t  d  T  4
      4'   	  ! T    t d 4 0  @  ' !      0  @  ' !    0  @  ' !   0  @  ' 
 
4 
2p B  O
 OT d 4
 r
p
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 t	 d T 4 2 B   t d
 T	 4 2
      
  p0  B
 @
  2P 2P@  Z      &     3       T
 4 2p` t d
 T	 4 2
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p B   20 d 4 2p B  
 
4 
2`! t     * ! T  t     * !   t  T     * !   t  T     * !   t  T     * !   t  T     * !       *  B   20
 
4 
2p
 
4 
2P! t d  ? P+ !   t  ? P+ !    ? P+  20 t d
 T	 4 2 b   d T 4 2p B  ! 4 p  + ! t  4 p  + !   p  +  B  ! 4 `  , ! t  4 `  ,  B  ! 4 0	 	 P, ! t  4 0	 	 P, !   0	 	 P,  B  ! 4  
 
 , ! t  4  
 
 , !    
 
 ,  B  ! 4  w , ! t  4  w , !    w ,  B  ! 4   g - ! t  4   g - !     g -  B  ! 4  W
 `- ! t  4  W
 `- !    W
 `-  B  ! 4 
 p - ! t  4 
 p -  d 4
 rp 
     @
 ( (h #t d T
 4 B
 h
  2P 2P     l     {  B   20 d 4 2pp
 & &d !T
 4 
pB
 
  2Pp      5 
     
  	  d. T- 4, * p  B
 
  2P 2P      R    i     u 
     
    
    0
    P
    p
    
    
    
    
    
    0
    P
    p
    
    
  dH 4G D p  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      7    ]                    r        )    A    a                
    C 	   c     
               9    Y     
               *    
 t	 d T 4 2 T	 2! t d 4 @ R <1 !   @ R <1  b	  !   t d
 T 4 @! O! t1 !   @! O! t1 !       t  d
  T  4 @! O! t1  B  
 
4 
2p B   B   .   ! ( ) * t+ d, T- 40 p& & 2 !   d,  T- p& & 2 !   d, p& & 2 !   p& & 2 
 t	 d T 4 2 T	 2! t d 4  r r 2 !    r r 2  b	  !   t d
 T 4  u u 2 !    u u 2 !       t  d
  T  4  u u 2   
  ! 
   t d T 4  x x 43 !   
  x x 43 !    x x 43  T
 4 rp` >   ! 7 4= 8 9 t: d; T< 0 R 3 !   8 0 R 3 !   0 R 3  BP  !g gt
  d	 4    4 !      4 
 d T 4 p  	  !  d  
 t T 4   T4 !   T   T4 !     T4 !       
  t  d  T  4   T4   !    d  t T 4   4 !        4 !      4  d T 4 rp b   2	p`P0 B   B   20 20 B   B   20 B   B   20 20
 
4 
Rp T
 4 rp` t d T 4  T
 4 rp` T
 4 rp` B  
     
 ( . p`P0  B
 
  2P 2PP* +     ,    ,     ,  20
 d T 4
 Rp
     0
    P
    p
    
 ' '48 0 
p`P  B
 0
  2P 2P 2P 2P 2P . n.     }.    3    V4    +9    9    };    ;    =     = ) )h t d T
 4 
     
  	 0  B
 X
  2P 2P @ ;@     G@    d@     v@  
      
  	 0  B
 
  2P 2PA A     A    A     B S Sd
 NT	 
4 
Rp@
 #
 #h d
 T 4 rpB
 
  2PG H     7H `
 : : 5 0 +x 'h #T 4 	p`B
 
  2P`H L     3L 
     
  Rp
`P0B
 
  2P 2PL L     L    L     QM 0
     
     
    
 . .x *h	 &4  
p	`P  B
  
  2P 2P 2P 2PM M     M    N    !N    9N    Q     
     p
     
    
 &
 &4 
p	`PB
 H
  2P 2P 2P 2P0R \R     R    R    R    R    /V     
     @
     `
    
    
    
    
     
     
    @
    `
 ) )43 * 
p	`P  B
 p
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2PV V     V    W    5W    MW    Y    Y    Y    Z    Z    Z    Z 	   Z 
   Z    \[    [    [    "\     
     
     
    
 &
 &4 
p	`PB
 
  2P 2P 2P 2Pp\ \     \    \    \    ]    k`     0
     `
     
    
    
    
     
     
    @
    `
    
 ) )43 * 
p	`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P` `     ?a    Na    ua    a    c    c    6d    Gd    d    d    d 	   e 
   -e    e    e    *f    bf     
     
     
    
 &
 &4 
p	`PB
 
  2P 2P 2P 2Pf f     g    g    9g    Qg    j      t d 4 ! T k Vk > !   k Vk >         	   . (   P
 8                 ?  
R0B
 
 
 
2PB
 
 l l     l P
     ]
    n
     
 
    
    
    
    0
    P
 p
 & &T& "4$  	p`  B
 8
  2P 2P 2P 2P 2P 2P 2P 2Pl -m     <m    Km    Zm    im    wm    m    o    _o    Yp    hp    wp    p 
 
    
    
    
    0
    P
 p
 & &T& "4$  	p`  B
 `
  2P 2P 2P 2P 2P 2P 2P 2Pp =q     Lq    [q    jq    yq    q    q    s    os    it    xt    t    t 
 
    
    
    
    0
    P
 p
 & &T& "4$  	p`  B
 
  2P 2P 2P 2P 2P 2P 2P 2P u Mu     \u    ku    zu    u    u    u    $w    w    yx    x    x    x 
 
    
    
    
    0
    P
 p
 & &T& "4$  	p`  B
 
  2P 2P 2P 2P 2P 2P 2P 2Py ]y     ly    {y    y    y    y    y    4{    {    |    |    |    | 
     
     
    
     
    @
    `
     
 & &4  
p	`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P } L}     s}    }    }    }    }    ~    ~    &    4    %    1    s     
  4
 
RpB
  
  2P ր      
  4
 
RpB
 (
  2P  F     ] 
  4	 
RpB
 P
  2P      ʁ  
 ! !h d 4 pB
 x
  2P  6      0
  4
 
RpB
 
  2PЂ      
 P
  4
 
RpB
 
  2P@ f     } p
  4	 
RpB
 
  2P փ      
  d 4	 
RpB
 
  2P  K     x U U
 M E = 5 - %  x h 3 
pP!E
 E 8/ (0 d1 42   F !     F 
 
    
    
    0
 #	 #d T 4  p  B
 @
  2P 2P 2P 2P 2P          )    8    J    X    3     `
 
    
    
    
 #	 #d T 4  p  B
 h
  2P 2P 2P 2P 2P@              ȍ    ڍ        Î    2 P
     
     0
    
    
    
    
     
     
    @
     `
 -
 -h )4A 8 
p	`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P #     K        ΐ        
    %    4            I 	   [             
   w     
     
     
    
    
    0
    P
    p
    
    
     
 -
 -h )4A 8 
p	`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P          @            ͜            W    y    	 	       @    O     
   7      20w w ^ X R 0 + &	 !
 x h  
 
    0
    P
    p
    
    
    
    
    
    0
    P
    p
 
 - -x )h %4: 2 
p`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      4    Z        ê    -    ?    $        8    R    c 	   ޷     
   ҹ            2    A         
   Q  20
 
     
     
    @
    `
    
    
    
    
     
     
    @
 -
 -h )47 . 
p	`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      1    c                ;        *    D     	   7    h 
   y    0!    "    "    i#    w# 
     p
     
    
     
     
    @
    `
 ) )4!  
p	`P  B
 0
  2P 2P 2P 2P 2P 2P 2P 2P# $     6$    E$    b$    n$    $    $    %    %    8&    F&    `'    '     
 
4	 
2p 20
 
    
    
    
               @           0
 8               `P -	 ! p`0  B
 X
  2P 2P 2P 2P 2P
 
2PB
 X
 ) %*     4*    ]*    r*    -    -    /    A/    /    0 0
     =
    d
     
 
    
    
     
     
    @
    `
    
        	   
        @           
 8   	   
         Q -	 !0 p`0  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2PB
 
 p0 0     0    1    1    H1    `1    1    1     5    5    5 	   '6 
   56 	   m6    	:    2:    g:    : 
     
    
      20 d T 4 p t d T 4 
 0
    P
    p
    
    
    
    
    
    0
    P
 p
 ' '4, $ 
p`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P? .@     =@    z@    @    @    @    @     D    D    dD    D 	   D    DI    SI    I 
   *J    8J    ~J 
 
4	 
2p
     
    
    
    
    
    0
    P
    p
    
 	   
 
   
    
 
   
 
   0
 
   P
    p
    
    
    
    
    
    0
    P
    p
    
    
 
   
 
    
    @
    `
 1 14 ! p`P  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P L EL    XL    yL    L    FO    aO    O    O    O 	   P    |P    P 
   P    Q    rQ    Q    Q    Q    ;R    KR    R    R    R 
   S    $S    S    S    S 
   S 
   S 	   T    U    U    V    9V    bV    V     
 
    
    
    
    0
    P
    p
           
            
  
 @           
 8      	   
      |X + +h . 
p`0  B
 
  2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2PB
 
  2P 2PV +W     rW    W    W    ^    ^    *`    D`    `    [b    fb    ub 	   b    \d    e    f    zf 
     
 
   
     P
 p
    
    
    
    
    
 0
 + +4!  
p`P  B
  	
  2P 2P 2P 2P 2P 2P 2P 2Pf g     +g    Ug    dg    j    j    j    Ql    l    l    l P
 p
    
    
    
    
    
 0
 & &T& "4$  	p`  B
 H	
  2P 2P 2P 2P 2P 2P 2P 2Pm ]m     lm    {m    m    m    m    m    4o    o    p    p    p    p  d 4 2p d 4 2pP
     p
     
    
    
    
         0     0     P  	   p  +
 +d' 'T% #4$  
p  B
 p	
  2P 2P 2P 2P 2P 2P 2P 2P 2P 2PPs s     t    u    hu    v    Cv    v     w    yw 	   w 
   :x 	   Ix    Xx    dx    nx     zx                       @           `               	              @    `                              0                        @            8   @            8   @            8   @           P 8               0^ 	   
         D^             X^             l^ 3
 3h  /dI +4H B p  B
 	
  2P 2P 2P 2P 2P 2P 2P
 
2PB
 	
  2P
 
2PB
 	
  2P 2P 2P 2P 2P
 
2PB
 	
  2P
 
2PB
 	
  2P 2P 2Px Iy     y    y    y    ;z    Sz             	    
            
       ̆    L                ;    ߍ        S    n                        /                   $              ]          d T 4 p 4	 
RpB
 @

       . !   P e غ ! 4  P e غ  "   4	 
RpB
 
   %     >  
R0B
  
  Ƣ     Ѣ  4	 
RpB
 P
       .  4	 
RpB
 
  գ        B
 p
       @ c     o           B
 
  ӥ     ߥ         
 
RPB
 
 
   B
 
               b @             H         > @     
 
RPB
  
 
   B
  
               ,c @           @ H   P ]     ~      
 
RPB
 P
 
   B
 P
               c @           ` H               
 
RPB
 
 
   B
 
               c @            H   Ш ݨ            
 
RPB
 
 
   B
 
               dd @            H         > @     
 
RPB
 
 
   B
 
               d @            H   P ]     ~      
 
RPB
 
 
   B
 
               4e @            H               
 
RPB
 @
 
   B
 @
               e @             H   Щ ݩ            
 
RPB
 p
 
   B
 p
               f @             H         > @     
 
RPB
 
 
   B
 
               lf @           @ H   P ]     ~      
 
RPB
 
 
   B
 
               f @           ` H               
 
RPB
  
 
   B
  
               <g @            H   Ъ ݪ            
 
RPB
 0
 
   B
 0
               g @            H         > @      4 pB
 
       Ы       /    = [    i      !   `  |h !
 
	 4 `  |h  d T
 2
p!     h ! 4   h  t	 d T 2G G A ; ( "x h  . .h )4 Rp 4+ ( p  B
 0
 `     @ P     ڶ      4	 
RpB
  
        !     i ! 
   	 
 
 T   i  p`0 4	 
RpB
 
  5     N !   p ~ 0 ! t p ~ 0  h 
4 
Rp 4	 
RpB
 "
   @ ]     h  
R0B
 "
    6     J  BP  B
 "
  4 r
	p`B
 "
             j @            H                   0 0              v                        BP0  B
  #
  4 r
	p`B
  #
             |k @            H   P p                  z             j                        	  d4 T3 42 0 p  B
 P#
  #                    d- T, * p  B
 #
  ,             d- T, * p  B
 #
       w     !     a l ! t d 
T 4
   a l  B  * *4 B   d T 4 2p! !d
 !T !4
 !2p!     lm !     lm  p
`P07 7x 2h t d T
 4  	  d4 T3 42 0 p  B
  %
       y             	  d4 T3 42 0 p  B
 0%
       z            " "x h 
4 
p: : x 	h    	  d4 T3 42 0 p  B
 `%
   c                 !      n !   
     n  p
`P0!   @  n !  @  n 
 T 4	 p` 	  d0 T/ 4. , p  B
 %
 0            	  d0 T/ 4. , p  B
 &
 @     `   f           	  d4 T3 42 0 p  B
 @&
  #                  	  d4 T3 42 0 p  B
 p&
  #                  x h 4 0  B
 &
                  	    0	    P	    p	    	    	 `                  0    =    [    o                            9    k     	             1 14    !     q !5 5 / ) #  	   q ,
 , '	 x
 h 
 
 
2PB
 (
  4 
RpB
 (
               q @           	 8         G 	     	    	     
 
2PB
  )
  4 
RpB
  )
               Xr @           
 8   `       
     
    :
     !     غ ! 4    غ 	 T/ 4. * p`  B
 P)
        i    !   
 p    p !   p    p ! 
 p    p 
 
2PB
 )
 
 b  B
 )
               ds @           P
 8     0     J P
     ]
    g
     
 
t 4 !     s !  l c Z B 9 0  x h   s '
 '7  p`P0%
  y q i a Y ;x 4h -47 &#!, p`P!     t !     t !    t ! d 4   t 
 
T	 
2p 	2 0  B
 )
 p
     
    
        J     V     q        	  d4 T3 42 0 p  B
  *
         !    !    !    % %d; !4: 8 
p  B
 *
 
     
        0 ! "     "    "    "    "    "  d3 42 0 p  B
 +
 P     p         0    P    p          # A#     W#    l#     x# #    # #    # $    ($ }$    $ $    $    $    
%    !%    `% 	   m%    % 
   %    %    %    &  h R0 d T 4 2p!   0( B( w !   B( h( w !   h( ( lw !  h( ( lw !
 
  B( h( w ! 4
 0( B( w  Bp`
P   4	 
RpB
 0-
  @) e)     ~)  4	 
RpB
 `-
  ) )     )  4	 
RpB
 -
 
 ) *     *  4	 
RpB
 -
 0* U*     n*  4	 
RpB
 -
 * *     *  4	 
RpB
  .
 * +     .+  4	 
RpB
 P.
 0
 @+ e+     ~+ 
 
2PB
 .
 
 b  B
 .
               0y @           P
 8   0/ L/     r/ P
     ]
    p
        d- T, * p  B
 .
       0 0     *1    [1  4	 
RpB
  /
 2 2     2    D3 
 
4 
2p 	  d1 T/ 4. , p  B
 p1
 p5 5     06    u6    dQ TP N p  B
 1
 
     
    
    
 6 6     
7    %7    7    7 !               	  x
  8 8 0{ !    8 8 0{ !     8 8 0{ !B B < 6 ' !  	 x
  8 8 0{   h  0     dQ TP N p  B
 3
 C D     =D    UD    D    E  	  d4 T3 42 0 p  B
  4
 0     P    p 0E sE     F    F    ,F    
 
2PB
 P4
 
 b  B
 P4
               $| @             8   PF `F     yF       
         	 T/ 4. * p`  B
 4
 F F     	G     4	 
RpB
 4
 `G G     G G    G  4	 
RpB
  5
 @H eH     ~H H    H  4	 
RpB
 p5
  I QI     tI  4	 
RpB
 5
 ` I I     J  4	 
RpB
 5
  J EJ     ^J  4	 
RpB
  6
 J J     J !               	  x
 O P 0{ !   O P 0{ !    O P 0{ !B B < 6 ' !  	 x
 O P 0{ G G ; 5 / * %   	 x
 h 
 K K  @ : 4 / * %  x h	 
 !   ` a ~ ! t
 
d	 4 ` a ~  T 2	% %t1 !d0 T/ 4. ,   B
  8
 a &b     Sb    {b  2pP0B
 @8
  Rp`0B
 @8
              p @            H                b b     b    b     b               % %t1 !d0 T/ 4. ,   B
 p8
  c c     c    c  2pP0B
 8
  p`0B
 8
             \ @           P H               0         d Bd    Td    hd    d P     _          4	 
RpB
 8
  d d     'e  4	 
RpB
  9
 Pe ue     e !   4 f f ؈ !   f f ؈ ! 4 f f ؈  h R0!    h qh q !5 5 / ) #  	  h qh q !     
 v v  !   v v  !
 
 
 v v   4
 Rp`P!   z z   !  z z   !  x
 w z 8 B B < + %   	 h 
 ! 	 x
 0}  t ? ? 9 - ' "   h 
 !      !     Ԃ ! h T	   Ԃ ! 4     d
 Rp!      d  4    !      t  d  4    !   7  T ! t 7  T ! 4     d    !	 	  d     P	 T/ 4. * p`  B
 0<
        I     4	 
RpB
 `<
   @   E     ^ h      4	 
RpB
 <
          (    ~ E E  x h 
4 
p!    5  !	 	  5  !
  x
  [h    Ą #
 #   	 
 !   @ 4   !s s j R I @ 7  x h @ 4   8 8
 '/  p`P0 4	 
RpB
 `?
       Τ ؤ    .  4	 
RpB
 ?
 P u       4	 
RpB
 ?
  Х       X X : 5 0 x h d 4 p 4	 
RpB
 PA
 @ e     ~    ԩ  4	 
RpB
 A
   %     >  4	 
RpB
 A
        !     غ !	 	t  4   غ !   `  ̢ ! t `  ̢  d 4
 RpB
 0B
          ֯              V !     \ !.
 .  x t d
 T   \  h 0 d
 T	 4 Rp!      ! d     T
 4	 Rp)
 )t3 %d2 !T1 40 , 	  B
 B
           [  h 
/ B
 B
       &    _  
R0B
 0C
  ɷ        0  B
 `C
 p          ܹ    %     o !   t  4   ؈ !     ؈ !
 
t 4   ؈  b   d
 4	 
RpB
 PD
       0 t         н /
 / ) x h 0 2pP0B
 D
  d
 4 
rpB
 D
               @            H                                         ,      
R0B
 D
   9       
R0B
 D
 @       /  
R0B
 E
 `        
R0B
 @E
  I       d 4	 
RpB
 pE
 p        d     r       0  B
 E
       0    L     X           0B
 E
   5     t           0B
  F
 0     `       T    d        0  B
 0F
           ,     8           d
 4	 
RpB
 `F
        $     2      d
 4	 
RpB
 F
                  @ !   `   ! T
 `    d 4 rp!   P   ! T
 P    
R0B
 F
           d 4	 
RpB
 G
 P      p            d 4	 
RpB
 @G
       0 t            0  B
 pG
         &     Y          !      ! 4     p   d
 4	 
RpB
 G
 @     p  T     b      d 4 2p h d x   !      ! x 4
 h     d T p h g    !     L  ! x t d
 {T j4 h   L  
 

 
2PB
 G
  4$ " p  B
 G
             P 	   0      8                       `               
    m    y            t 4  d 4	 
RpB
  H
      @           P !   
   p !     p ! 
   p  4 Rp`P!     
 @ h  !   @ h  !
 
 
 @ h   	  d1 T/ 4. , p  B
 0H
            !   P {  !  d 
T 4 P {  !      !  d 
T 4     
R0B
 `H
   9       
R0B
 H
 `       /   0  B
 H
           ,     8            0  B
 H
                    0    L     X           d
 4	 
RpB
  I
         D     R      d
 4	 
RpB
 PI
                 ` !
   qx
 < 		    ! h      <    !   0 d t ! d 
T 4 0 d t  t    
R0B
 0K
         d 4	 
RpB
 `K
 0     `  4     B      d 4	 
RpB
 K
                 P   0  B
 K
 p                   1     {  d
 4	 
RpB
 K
 @     p           0 !      !  t 
T 4    !   `
 
 P !   
 
 < !    T 
 
 < ! t `
 
 P  r`0 
R0B
  L
 
 I
     
  d 4	 
RpB
 PL
       
 $     2       0  B
 L
                          U       d
 4	 
RpB
 L
                 `  d 4	 
RpB
 L
 0     `             !   @ Y ̢ !
 
t d @ Y ̢ ,
 ,t? (d> $T=  4< 8 	  B
 M
                      @    `             
          =                  ;                     N         	           N 
                !     L ! t
 
d	 T   L 
 
20!   0 Y  ! 
 
t	 d 0 Y  	 	2P0
 
2PB
 N
 # #t d
 4	 RB
 N
             И @           @ 8                             %!    q! @     M    `      d
 4	 
RpB
 N
 p      ! !     !    !    "  R0B
  O
  " N"     Z" 
 t
 d T 4
 r d T 4 pB
 0O
  $ $     %  R0B
 `O
  & !&     D&  B   P  "
  
	p`P0B
 O
      0    `                           	   @     & 2'     f'    '    '    '    *(    F(    `(    (    (    )    -) 	   :) 
   ) 	   )    )    *    g*    *    
+ "
  
	p`P0B
 O
              0    P    p             	       0 p+ +     +    ,    b,    v,    ,    ,    ,    f-    u-    -    - 	   - 
   . 	   !.    D.    .    .    /    / !    0 0  !
 

 d  0 0  
 
4 
r	pP!   }2 2  !n n
 e N E
 <  x }2 2  ! h 0 p1 }2  B
 B =  ( p`P0  
 
2PB
 O
  d 4
 
RpB
 O
               | @           P 8   `B B     C P     ]    p      R0B
  P
 PC qC     C  4 RpB
 PP
           C C     C    D    XD     \D  4 RpB
 P
          @ D D     D    D    (E     ,E  R0B
 P
 PE qE     E !   pG H  !
 

 d pG H  !   I ;I  !  t 
T 4 I ;I   R0B
 Q
 O O     O !   O 1P  !   t O 1P  !
    t 
d	 T O 1P     x h 0 # B
 @Q
 ` U U     !   pZ Z  ! 4 pZ Z  >
u>h ,s'9  p`0P  B
 pQ
       [ ]     ]    ve     e !   e e t !
 
 4 e e t  d	 T 2p R0B
 Q
 f f     f  R0B
 Q
 f g     $g  4  R0B
  R
 Ph qh     h 
 
2PB
 0R
 !
 !d 4 
pB
 0R
               H @            8   h i     j               !   k k  ! 
 
t	 4 k k   2
`
P R0B
 `R
  l l     m ;
u;h ,s'!  p`0P  B
 R
  m rn     o    q     q ;
u;h ,s'!  p`0P  B
 R
       0   r gs     
t    v     v !   w w ̢ !
 
t d w w ̢  0   4
 RpB
 R
 y y     y    T 4 
R	p`B
  S
 P      p   z yz     z    z !   { Y{ p ! t { Y{ p  T
 4	 R`* *d %T  4
 R
pB
 pS
               | |     |    )}    T}  	  d T 4  p  B
 S
 '     ' } }     } }    
~     >~ 
 
4 
Rp d T 4
 rp 	  d T 4  p  B
 T
  ]     i          
 
2PB
 PU
 # #t d
 4	 RB
 PU
              @           ! 8                      ׁ     %    q !     !    0!      4 2p!   Ђ   ! d Ђ   
 
4 
2p
 
2PB
 U
 ) )h $d 4 r
pB
 U
                             @           p! 8   @           @! 8   ` '           @!     M!    `!     }!    !     
 
2PB
 U
 !
 !d 4
 R
pB
 U
               ̦              @           ! 8   @           ! 8          D    p !     !    !     !    !     
 
RPB
 U
  R	p`P0B
 U
 / &p`0B
 U
                             @           " H   @           ! h           "               "  8     щ h             6    ǋ !     !    i"     "    "     
 
2PB
 V
 !
 !d 4
 R
pB
 V
               Ш              @           @# 8   @           # 8                          u     #     #    0#     M#    W#      
R0B
 @V
 #      $     $    @$    `$    $ @ V    q    |                  !      !      ! 
    !
 
t T
     d 4 
rpB
 pV
 `#     #     #    #   3     W    c              4	 
RpB
 V
  ؑ                          Ò " "d T
 4	 
RpB
 V
       |  h 4. , p  B
 PW
   7     k    x       bP0  B
 W
 " 
p`0B
 W
                @            % X     k     &  %     %    =%      # B
 W
 P%        # B
 W
 p% И        B
  X
 % `      
 
B	p`P0  B
 PX
  R
p`0B
 PX
               @           % X           %      ș     י          %     %    &      48 	6 p  B
 X
  &     @&    `&    &    & @          U    x             # B
 X
 & М      
 t d T 4  dC 4B @ p  B
 X
 &      '     '    @'    `'    '    '  =     L    _    	                	     	  d T 4  p  B
 Y
   r               ޢ  	  d T 4  p  B
 @Y
 0                  	  d T 4  p  B
 pY
 @           ͤ      !   P   ! 4 P   !    E  ! 4  E  
 
d 
2p
 
RPB
 Y
 ! !d 4
 r
pB
 Y
              @           @( H    (                 Ч          ƨ @(     M(    `(      d
 4	 
RpB
 Y
 i        ; 
 
2PB
  Z
  d
 4	 
RpB
  Z
                @           p( 8          p(     }(    (     !   P Ԭ H !   Ԭ ެ 0 ! 
 Ԭ ެ 0 !
 
t T
 P Ԭ H  R
`0!   P Ӱ  !   Ӱ ݰ  ! 
 Ӱ ݰ  !
 
t T
 P Ӱ  
 
R	`0
 
RPB
 0Z
 ! !d 4
 r
pB
 0Z
                @           ( H    .     W (     (    (     
 
2PB
 `Z
  d
 4	 
RpB
 `Z
               l @           ( 8   p ڲ      (     (    (      t
 d T 4
 R
 
RPB
 Z
 "
 "t d 4 
rB
 Z
                @            ) H         a  )     
)     )      4+ ( p  B
 p[
  .    z      h 4. , p  B
 [
 $     $  G     ~           h 4. , p  B
 \
 p      ޸          
 
RPB
 `]
 (
 (d  4 r
pB
 `]
                            t @           `) H   @           0) H   @      }      5 0)     =)    P)     m)    w)       B
 ]
 )     )     )           ;     G    R 
   B
 ]
 ) p      
 
B	p`P0  B
  ^
  r
p`0B
  ^
               @            * X            *     @ h     w           *     0*    _*     
 
4 
p d# 4"   p  B
 0^
 p*     *     *    *           #    6    \  4" 	  p  B
 0_
               !    G 
 
B	p`P0  B
 _
  R
p`0B
 _
               @           + X           *                     +      +    O+      T 4 Rp` dC 4B @ p  B
 _
 +     +    +    +    ,    0,    P, P              i    !    D    S    i     48 	6 p  B
 _
                           
 
RPB
  `
    B
  `
                @           `+ H     C      `+     m+    +      dC 4B @ p  B
 P`
                   q                
 
RPB
 `
    B
 `
                @           p, H                  p,     },    ,      
"  !      ! t  
T 4     `  *
 *h %t !d T 4    B
  a
 P +      *
 *h %t !d T 4    B
 0a
 ,       L !     غ !	 	t  4   غ    !      ! t 
T 4     `  !     D ! t d 
T 4   D     	  d T 4  p  B
 `a
 , ,  - P                	  d T 4  p  B
 a
   S     k    3      d 4
 rp$
 $T  4 
	p`B
 a
  -       6  d
 4	 RpB
  b
 @-     `- `            d
 4	 RpB
 0b
  2     H    V )
 )tI %dH !TG 4F B 	  B
 `b
 -     -    -    -     .  .    @.    `.    .    .                                    	    $    0    C 	   i !    _  !
  	 
 
d T  _  	 	p0    0B
 f
 . .  /  / @/ `                 	     5    C  d
 T 4 rp
 
4
 
r` 0B
 0g
 `/ / /       # A    O m    {  h 
4
 
p,
 , x h 
4 
p 
R0B
 @h
         & !      !  d 
T 4     
p 
R0B
 h
 0 ^       
R0B
 pi
  >     f !      !  t 
T 4     
`!     غ ! 4    غ  t 
d 4  
R0B
  j
  >     f (
 (h $d  T 4  p  B
 j
 @K `K   k           r0 h 0 r
p`0B
 j
  $     9 ' 'h #T 4 	p`B
 k
 / P      u  h 4 rp`PB
 @k
  0        
 
RPB
 k
 8 8C 3xD /hE +d '4  
p  B
 k
               	   ,    2 H            0     @0    `0    0    0    0    0     1     1 	   @1    `1    1    1 
   1    1     2     2    @2    `2    2                         N    n             	    
           E    w    '    ]                    '    ]         
            0     i                     ,!    D!    }!    !     2    2      4 Rp`PB
 k
 2 ! :"     P"  d 4  p  B
 k
 2 " u#     # 
 
B	p`P0  B
 l
  r
p`0B
 l
               @           03 X           3     # $     '$    8$     F$ 03     @3    o3     !k k ;x
  z* +  !   y  % z* ,   	 h  !` `  6 7 X !
 x	  nh
 9  P2 6 | " "  
 !   		  : i;     ٸ &  x
 h  !  h @ -D  M M G ; 5 0  	 x
  -
 -h (t $d  T 4    B
 q
 3 F G     H !   PH xH  !  t 
d T PH xH   
0!   J J  !
    d 
T 4 J J   
p  !   P P  !  t 
d T P P   4	 
RpB
 `r
 R S     ;S  d
 4	 
RpB
 r
 pS S     S  d
 4 rp" "4 
p`PB
 r
 3 3    3     4     4    @4    `4    4    4    4 U U     
V    0V    FV    V    V    V    V    	W    W 	   lW !   W W X !
 
 T W W X  Rp`0 h r0B
 r
  Y RY     dY  d T
 4	 RpB
 Ps
 Z Z     ![  h d 4
 rpB
 s
 @[ [     [  h d 4
 rpB
 s
 \ \     \  d T
 4	 RpB
 t
 `5 ] >^     q^  h d 4 rpB
 @t
  5 ^ ^     _  h d 4 rpB
 t
 _ `     ?`  d T
 4	 RpB
 t
 a a     b  h d 4
 rpB
 u
  5 0b b     b  h d 4
 rpB
 @u
 @5  c vc     c  d
 4	 RpB
 u
  d vd     d  d
 4	 RpB
 u
  e ve     e  d
 4	 
RpB
 0v
 5 e e     f  4 RpB
 pv
 5 f _g     pg ) )t %d !T 4 	B
 v
 5     5  6     6 g h     2h    >h     Jh h    h    h    h  bP0  B
 v
 1 1hN ! p`0  B
 v
                    !       -   -   1       ;   ;   ?       K   K   N      x 	   , X  @ X   	   , P  > X   	   , @  < X   	   , 8  0: X   	   , 0   8 X   @6 `6    6    6    6    6     7     7    @7    `7 	   7    7    7    7 
    8                  8    8    8    9    09    P9    p9    9    9    9    9    :                  :    :      ;     ;    @; #   `;    ; %   ;    ; '   ; (    < )    <    @<    `< ,       ,       .   = /   0= 0   P= ,   p= ,   = 3   = ,   = 5   = ,   > 7   0> 8   P> 9   p> ,       ,       <    ? =   @? >   `? ,   ? ,   ? A   ? ,   ? C    @ ,    @ E   @@ F   `@ G   @ ,   @ ,   @ J       J       L   PA M   pA i 
j     Fj    qj    j    j    j    j    j    k    (k    Kk    `k    vk 	   k 
   k 	   k    k    k    l 
   l    Bl 
   wl    l    l    l    ,n    ?n    Rn    tn    n    n    n    n    n    n    (o    Io    _o    ro    }o    o    o    o    o    5p    q    q "   q    q #   q $   r #   r    ,r %   @r &   Qr %   r    r '   r (   r )   r *   s )   =s (   Is '   Xs    s +   s ,   ]t -   u ,   v 2   (v ,   Jv 3   Yv 4   |v 3   v ,   v 5   v 6   v 5   v ,   w 7   5w 8   Hw 9   Sw :   vw 9   w 8   w 7   w ,   x ;   iy ,   |y @   y ,   y A   y B   y A   y ,   z C   z D   0z C   ez ,   z E   z F   z G   z H   z G   { F   %{ E   4{ ,   v{ I   { J   *| K   } J   } ,   5~    m~    ~    ~  8     .8    B8    e8    s8    8    8     >:    R:    u:     : !   :     :     < .   < /   < 0   < 1   < 0   =     > <   > =   > >   > ?   ? >   ?     @ L   A M   #A N   FA     % %t !d T 4    B
 x
 p              
        ܀ $ $d0  T/ 4. * p  B
 x
 B     0B     PB     pB     B     B     B     B     C     0C     PC     pC     C     C     C     C     D     0D     PD 0 y                  ́                   ,     M    \              ˂    ڂ              1 	   @      
              ̓    ܃         *     O 
   ^              ф         "    .     \    k              Ѕ !    *  !     T  4  *  !	 	T    4  *  !  4  *   bp`     T 4
 
R	p`B
  y
 D     pD 0 ^              $ $d  T 4  p  B
 Py
 D     D Ј      (    E     c !     x !
 
d 4   x 
 
2p!     T ! 
   T !    5  ! 4  5   d T 2p
 
RPB
 y
  t d
 4 B
 y
               @            E H            E               N  E     -E    @E     
 
RPB
 y
  t d
 4 B
 y
               @           pE H           PE     p          ސ pE     }E    E      R0 d 4
 p   T
 4
 
R	p`B
 y
             4 p`PB
 z
 E P ԕ     R    T
 4
 
R	p`B
 @z
 p       !   t 0 M 0 ! t 0 M 0 !   t P m 0 ! t P m 0    d T 4 pB
 pz
 E E     F     F @F М      +    >    N    l    |         &	 &T "4  	p`  B
 z
 `F     F     F    F    F     G     G    @G     `G 0 b                             3    B    y        ɟ          
 
rPB
 z
 9
 9x 5h %@ p`0  B
 z
     
   
       	   ,    H X           G     G    G    G     H     H    @H    `H    H 	   H                   P      Ӡ                آ        I    * 	   c 
               $    B    y     H    H     
 
rPB
  {
 C C >  9x! 5h" %F p`0  B
  {
        
      ` 	   ,    I X           H     I    0I    PI    pI    I    I            	       Ц 7     c            ;            ,    e                 I    I     
 
B	p`P0  B
 0{
 # #4 p`B
 0{
              @           `J X    J  J           @J               P          Ȭ    ۬    ` `J     pJ    J      4 p 4 rp`P
 d
 T	 4 2p/ /
 *x &h "4#  
p`P  B
 {
             J J     K     K                                    
                %    D        ̶ %
 %t !d T 4 B
 {
 0          i  d= 4; 8 p  B
 {
 K K    K    K     L  k             K    W    r        T 4 
R	p`B
 |
  L  &     ̻ G G / * %  x h 4  p  !     ` ! 4   `  d p  ) )x %h !d T 4 pB
 @|
 @L  J       
  T 4
 
R	p`B
 p|
 `L 0      j #
 #h 4 
p	`PB
 |
               `    c $
 $T 4 R
	p`B
 |
 L  M     M    @M                     4 R
p`PB
  }
 `M M    M  D                  ( (h $T  4 
	p`B
 P}
 L L    L            [         $
 $T  4 
	p`B
 }
  k         v         %
 %4 r
p`PB
 }
 M M     N     N       9        9    E %
 %4 R
p`PB
 0~
 @N `N    N `              |      0B
 `~
 N N N  O  O @O `O O O        	     5    C a    o                     =    K 
 
RPB
 ~
 ! !d 4
 r
pB
 ~
              @           O H   O                  '          O     O     P     !   P m d ! d P m d  T 4 2p!    {  !   {  
 
RPB
 ~
  rp`0B
 ~
                @           P H    9     ] P     P    4P      	  d T 4  p  B
 ~
 p                
 
RPB
 0
  rp`0B
 0
                @           @P H    Y     } @P     MP    dP      	  d T 4  p  B
 `
                      & !     T ! 
   T  T 4 rp`!   x @   ! x @    h 
   d 4
 
pB
 
 P     pP     P  3     Q    ]              !       ! t      0 4 
p	`PB
  
 P        
 
RPB
 0
 '
 't "d 4
 r	B
 0
                @            Q H    k       Q     
Q     Q     !          !   d
      R
pP0!           !   d
      ] ]d T 4 2p
 
PB
 `
 9 9$ 4% /x& +h' 'dW #4V P 
p  B
 `
                           	   ,    `S x   	   , (  0S x   0Q PQ    pQ    Q    Q    Q    Q    R    0R    PR 	   pR 	   R    R    R 
          R    S 
                     
       
                     0      5        6    [                 M    c    H    ^ 	   I 
   _    I    _ 
               X    i    y 
        	   /     g                K     	           +    c     0S     =S    PS     mS    S     (	 (d; $T9  48 6 	p  B
 
 S S    S    S  d     s        	             / 8 8 3x /h +d- 'T, #4+ $ 
p  B
 Ѐ
 T 0T p          
 8
 8 2 x h 0 d
 
4 
R	pP!    &  !      , t !  
 d   , t ! T &    ! x h  &   	p0  ! d
    
 
4 
R	pP3 3 .x	 *h
 &4   
p	`P  B
  
             PT pT                                                  
        l         !    d  ! x	  t d p4 h
  d    P
 
B	p`P0  B
 0
 # #4 p`B
 0
              @           T X   T T           T                 v                 0 T      U    >U     
 
PB
 `
 8 86 3x7 /h8 +dy '4x r 
p  B
 `
              *   *   -       	   , P  X x   	   , @  X x   PU pU    U    U    U    U    V    0V    PV    pV 	   V 	   V    V    V 
          W    0W    PW    pW    W    W    W    W    X    0X    PX    pX 
                     
                     
       !       "       
       $       %       
       '       (       
       
       +       ,       p          x                  b"    ~"    T#    p# 	   E$ 
   a$    5%    Q% 
   %    u&    &    @'    Q'    ))    _)    )    )    )    
*    '*    ]*    *    *    *    +    -    -    - 
   . *   1 
   @1    x1 	   1    1     2    X2    2 X     X    X     X +   X        T 4 
R	p`B
 
 X  3 G3     F4 P4     d4    d 4 
pB
 Ё
 Y     0Y     PY 4 5     #5    25    C5     l5 $ $x h   
 
RPB
  
 3
 3hY /d +4  p  B
  
             , 	   , (  p\ H   pY        Y    Y    Y    Y    Z    0Z    PZ    pZ 	   Z    Z    Z    Z 
   [    0[    P[    p[    [    [    [    [    \    0\    P\                    9 9     9 9    9    9    V:    i:    :    :    M;    `;    ;    ;    = 
   <=    t=    =    =    =    !@    Z@    @    @    @    A    3A    lA    A    A    A    -B    EB    ~B    B    B    C    AC    YC 	   C 
   C    p\     }\    \     & &t "d T 4 
	B
 0
 \ \ \  ] C @D     OD    D    >E LE    E  T 4 2p`1 1d )T $4 r
pB
 `
  ] @]  G G     kH    I `
 `d T
 4	 2
p   T 4 
R	p`B
 
 `] ] K K     L    L   d d B = 8  x h 4  p    x xh ( #  
 +
 +d% 'T# #4"  
p  B
 
 ] ]    ]     ^     ^    @^ pP P     P    fQ    uQ    Q    Q    R    R    S 
 
t 4 \ \d T 4 2pQ Q K . ) $  x h	 
 8
U8h 1t #d 4 S
P  -
U-h & t d 4 SP  !   \ \ غ ! 4  \ \ غ !   ] /^  !
 
d 4	 ] /^  >
 > 9 4t +T ! !4 
p`PB
 
 `^ ^    ^ ` 7a     a    b    b    b k kd T 4 2pb
 b4 h d T
 p
 4 t d
 T	 R d
 4 rp h 
4
 
p d T
 4	 Rp
 d 4
 T R
p
 
RPB
  
 ! !d 4
 r
pB
  
              @           ^ H   ^                 pu u     #v    iv ^     ^     _     !   v v  	 !   
  4	 v v  	 ! 
 4	 v v  	 
 t d T
 4  0
 d T
 4 rp x h 
4 
rp! !h 	0!      !      4 Rp`P7 7 2 -x )h %47 0 p
`P  B
 P
 Ё      ل ݅    9    ҆    }                     9    E    p         `    H                     7 7 2 -x )h %47 0 p
`P  B
 
                    ]    l         ߒ            %    P    _ t    @    (                ˖    ږ 7 7 2 -x )h %47 0 p
`P  B
 
 _ 0_    P_    p_    _    _    _    _    `  ޙ                  =    L a    s        k            0    ? T             e    t             3 3h /d! +T  '4  
p  B
 
 0` P`    p`    `   \     w    &    A    Z      T 4 p`B
 
 `        6 6 1x -h )t %d !T 4  	  B
 @
 `   l      
 t d T 4 $
 $T  4 
	p`B
 p
 `      a @ j         (     
 
RPB
 
 '
 't "d 4
 r	B
 
                @           @a H         D @a     Ma    `a     !   P ݭ H !  P ݭ H : :   x h 4 p> >   x h 4 pF F A <  x h d 4 p
 
4
 
rp* *TB &4A : 
	p`  B
  
 pa a    a    a    a  :     I        7            \    k    w , ,x 'h d T 4
 rpe
 ed t	 T 4 2
 t d T 4  h t d T
 4 $ $d  T 4  p  B
 @
 b `       !     $ !d dd T
 4   $  h p# #T 4 
	p`B
 p
 0b     Pb   1         F % %t/ !d. T- 4, *   B
 
 pb b    b `           3    A    M (
 (d $T  4  
p  B
 
 b     b c    0c       "    ?     ] z              d 4 2p
 
2PB
 
  4	 
RpB
 
              @           pc 8   Pc                       I    U pc     }c    c     
 
2PB
 
  4	 
RpB
 
             d @           c 8   c                  '     Y    e c     c    c      4 p!     : l !   :   !# #  :   ! 4   : l !    * l !   *  X !# #  *  X ! 4  * l 
 
T 
	p`
 
RPB
  
  R	p`P0B
  
 / &p`0B
  
                             @           d H   @           c h           d                e  
      L    ~         1     c     d    d     d    d      d
 4	 Rp!   ` y  	 !   
  4	 ` y  	 ! 
 4	 ` y  	 
 
d 
Rp d
 4	 
RpB
 P
       b B B x h d T 4 p
 
RPB
  
 5 5h2 %f p`0  B
  
    
         	 	   ,    f H    e        @e    `e    e    e    e    e     f     f    @f 
   `f    f    f                   p       
    9    W            1    O                
 	   B         
   D    \ 
                   f     f    f     
 
rPB
 0
 5 5h# %H p`0  B
 0
    
   
      X 	   ,    0h X   f        g    0g    Pg    pg    g    g    g    g 	   h                   p      
     ?    ]            A    c            B    P    \ 	    
               0h     =h    Mh      h R0   T 4 	p`B
 `
 `h   )     l m m4 2pD D !x h d T 4 p!	 ! x h ( 0  B
 
 h     h     h    h        f     r                   bP0  B
 `
 " 
p`0B
 `
               
 @            i X     K       i     i    =i     7E7h 3t ,d %4 C 
PB
 
 Pi     pi p }          F     T  4 p`P 4 p`P&
U&h  t d 4 SP   
R0B
 
 P f     l #
 #h 4 
p	`PB
 
 i i    i    j               o     x  !       p ! t     p  h 0( (h $T  4 
	p`B
  
  [         7          d 4
 
pB
 P
       E O    e  d 4
 
pB
 
 0j Pj   <     u       4
 
RpB
 
 pj     j    j     j 0 K                           #
 #4 
p	`PB
 @
 j k    0k    Pk 0      -
    F
             #
 #4 
p	`PB
 p
            2              2P 
  T 4 	p`B
 
       1    K              
  T 4 	p`B
 И
        =    W              4
 
RpB
 
 pk     k    k    k           '    W    k % %t !d T 4    B
 
                  d 4
 
RpB
 Й
 k     l       P    [     ^  4
 
RpB
  
 0l     Pl     pl    l    l    l                   $    0    l  h 
4 
Rp
 t d
 T	 4 R 4
 
RpB
 
 l     m    0m    Pm    pm     m @! [!    i!    w!    !    !    !     !    !     !  4	 
RpB
 
 m     m    m    n    0n    Pn    pn    n ! !    !    -"    `"    y"    "    "    "     "  
R0B
 
 " "     1# ' 'd1 #T0 4/ * p  B
  
 n n    n o    0o    Po    po @# $     #$    D$    Y$    k$    $    $    $    Q% ' 'd1 #T0 4/ * p  B
 P
  & &     &    '    '    +'    N'    a'    '    ( 
 
RPB
 
 $
 $d 4 r
pB
 
                @           o H   0* *     
+ o     o    o     
 
RPB
 
  R	p`P0B
 
 / &p`0B
 
                            | @           p H   @           o h           `p               p + ,     `- -    ..    y.    . .    V/ o     o    Rp     p    p      4
 
RpB
 
 p     q 0q / /     /    /     / /    / n n4 2p
 
PB
 
 3
 3hZ /d +4  p  B
 
       "      ( /   /   2       	   ,   v x   	   , x  0u x   Pq pq q q    q    q    r    0r    Pr    pr    r 
   r 
   r    r    s    0s    Ps           ps    s    s    s    s    t    0t    Pt    pt    t    t    t    t    u                !          `u #   u $   u    u &   u '    v     v )   @v *   `v    v ,   v -   v               0       1       1 2     =2 p2    2 2    2    d3    |3    5    5    I6    a6    K8 	   f8 
   C9    ^9    ,: 
   G:    ;    7;    ;    _<    p<    -=    >=    I?    ?    ?    ?    @    1@    I@    @    @    @    A    1A    B     C    /C    GC    C    C    !D #   mD $   |D %   D $   D    !E &   mE '   |E (   E '   E    !F )   mF *   |F +   F *   F    !G ,   mG -   |G .   G -   G /   J    J    K    FK 
   ~K    K    K    &L 0u     =u     Pu     v 0    w     
 
PB
 
 3
 3hY /d +4  p  B
 
       "       /   /   2       	   ,   | x   	   ,   z x   w 0w Pw pw    w    w           w    w    x    0x 
   Px 
   px    x    x    x    x           y    0y    Py    py    y    y    y    y    z    0z    Pz    pz    z    z                !           { #    { $   @{    `{ &   { '   {    { )   { *    |     | ,   @| -   `|               0       1       L M     =M pM    M M    M    WN    oN    P    P    R 	   R 
   S    S    T 
   T    U    U    IV    V    V    W    W    Y    Y    Z    /Z    hZ    Z    Z    Z    [    /[    h[    [    ']    `]    ]    ]    ]    ^    ^ #   ^ $   ^ %   ^ $   _    _ &   _ '   _ (   _ '   `    ` )   ` *   ` +   ` *   a    a ,   a -   a .   a -   b /   e    0e    he    e 
   e    f    Hf    f z     z     z     | 0   |     " p`P0B
 
 | |    | f g     g    g    g D D ? : +x 'h d T 4 p1 14$ ! p`P  B
 `
 A A    A    A k Ml     hl    =n    an    |n    n *
U*h &t "d 4 S
P  B
 
 } o o     .p  4 p`P d T 4 p 4 p`P 4  
p	`P  7U7h
 -! &  d 4 S	 P'
 'T 4 r
	p`B
 
 0}     P}    p}    }    }    }    }    ~    0~  x 0x     Dx    Nx    rx    ~x    x    x    x    x    x  d T 4
 Rp(
 (d $T  4  
p  B
 @
 P~     p~     ~ { |     |    
}    }     }  d 4
 
pB
 p
 ~     ~     ~       ۀ    :    Ł (
 (d2 $T1  40 * 
p  B
 
  0    P    p  !     / O    s                9 !   p Ã % !
 T  x h	  d p Ã % 
 
4 
 p  /
 /d1 +T0 '4. ( 
p  B
  
                                    d	 4 Rp*
 *h
 &4&  
p	`P  B
 
   !       4 RpB
  
 P     0      #     + "Rp`P0B
 0
                            @    `             @ w                ȏ    ԏ 	    
       !    *     3  d
 4	 
RpB
 `
                @    `                  ͐            )    6    C    V     z  
R0B
 
                @  ё     ۑ                d6 44 2 p  B
 
      `              9     P    o    ~            ғ            T 4 	p`B
 
   I      &
  p
`P0B
  
  0 @      ח    ՜ 
 
RPB
 P
 . .h ! p`0  B
 P
             $*    ,     H   P p                   0          (    ;                  ̄     
 
RPB
 
 . .h ! p`0  B
 
             *    ,    @ H                         P      à    H    [    ޢ     @     M    \     
 
RPB
 
 ) )h % !t 4 	B
 
              + 	   , h   Ѕ H           p              p      ѣ        Y    n    5     h Ѕ     ݅         
 
RPB
 
 ) )h % !t 4 	B
 
              , 	   , h   ` H                      @      ե         #            e      `     m    |      d
 4	 
RpB
 
        9  d
 4	 
RpB
 
 / P        d
 4	 
RpB
  
 $   &       bP0  B
 
 - -h )d %4 pB
 
               0. 	   , 8    X                         
 
RPB
 `
 9
 9x1 5h2 %f p`0  B
 `
              . 	   ,     H                0    P    p     p            Ї         
   0    P    p            Ј                       Э 0     \    y            2    N    ٯ        x 	           &    ^    v     
        
   5    d        H    w        ϴ         -     3 3x$ /h% +dT 'TS #4R L 
p  B
 
 @     `                               @    `             p ǵ              j    w            (    5    [    o        Ʒ     	       j 
   w    ù    ׹    !    .    ͼ         , !   p ~ 2 !   ~ 
 1 ! h	 ~ 
 1 !F F ( #  	 4 p ~ 2  x 
 0 04$  
p`P  B
 
                  @    `         0 j              ؿ      ,    A    W    m                     	 5 5x 1h
 -4'  p
`P  B
 
             P              0    A    j    h b  
 
RPB
 `
    B
 `
               3 @           @ H          @     M    c     ^! ^ X R J	 B
 : 5 0
 +x 'h #d) #T' #4& #  p   d 4 pB
 
 p        ! d2 0 ( 4 
 T1 "x h 43 , 
p   T 4 rp`)U)h  t d 4 S	 P:U:h
 6 (t d 4 S	 P 
 B
 
          d 4 pB
 
  Ќ            0    P    p            Ѝ 	    
       0    P    p            Ў                   &    D    P    q    }         	    
            
                ,    M    Y ) )h# %4P H 
p	`P  B
  
      0    P    p            Џ         p              ]    l                    7    f              
     3 ^                 8    g      ,	 ,4K B 
p`P  B
 
 0     0    P    p            А               !    /    a            	    -    h    ~                3    \     
 
RPB
 Ъ
 1 1h !< p`0  B
 Ъ
 g   h   k      8 	   ,   ` H   `                           @    `         
                     @    `                              @    `                              @    `      !    "                  &   @    ` (    )    *        ,          .   @ /   ` 0                4          6   @ 7   ` 8            ;    ;          >   @    `     A    B    C         E        @ G   ` H    I        K         M     N   @ O   `     Q        S    T     U        @    `     Y        [    \     ]        @    `     a            d     d            g   @        i       j             $    K    c                        
        +    Z    n 	            
       "    - 
   P    y     
                       g    }                            Z    m                                            H    T    c                    %    6    _         . !   A "   P #   s "    !             $    %   5    p &    '    &       p (    )    *    +    *    )    (       ; ,   O -   ` ,        .    /    0    1   ; 0   d /   p .        2    3       = 4   Q 5   b 4       ; 6   Q 7   d 8    9    8    7    6       W :   p ;    <    =    ;   :     >    ?    >        @        A    B    C    D    C   H B   T A   c     E    F    E       o G    H    I    J    I    H    G       F K   ` L   q K        M    N   ' O   5 P   U O    N    M        Q    R    Q   3     S    T    U    V    U    T   ) S   5     W    X        Y    	 Z     	 Y   X 	    	 [   *	 \   =	 ]   N	 ^   n	 ]   	 \   	 [   	    	 _   %	 `   :	    	 a   	 b   	 a   	    5	 c   K	 d   u	 e   	 f   	 d   	    	 g   .	 h   >	 g   Y	    v	    	 `     m i        % %t !d T 4    B
 
  	 	     	    5	     G	 !   P	 e	  ! 4 P	 e	  (
 (d< $T;  4: 4 
p  B
 `
 О         0 	 A		     P		    		    &	    2	    >	    t	 
 
2PB
 
 '
 'h 
p`0B
 
              C 	   ,      8           P    p     	 C	     	    	    
	    
	     
	               / /x h   s s k c [ S K C > 9x 5h 14< !2 p`P  B
 
   @	 	     m	    	  d 4 2p R0B
  
   	 N	     g	  2pP0B
 `
  4 
r	p`B
 `
              |E @           ` H           0      	 I	     t	    	     	 `     o          4&   p`P  * *h" &G p`P0	 d! T  4  p  $ $d  T 4  p  B
 
  Р     	 I	      	     	    L!	    [!	 !   !	 !	 F ! d !	 !	 F 
 
4 
 p     T 4 	p`B
 
  0    P    p            С             @ 	   p 	                   @    `         p#	 #	     #	    $	    #$	    A$	    M$	    n$	    z$	    $	    $	 	   $	 
   $	    $	    %	 
   %	    0%	    <%	    ]%	    i%	    %	 $ $d  T 4  p  B
 
      %	 %	     &	 6&	    E&	    ).	    T 4 	p`B
  
 @     `              p.	 .	     .	    .	    %/	    ;/	    I/	    z/	 0 04$  
p`P  B
 P
      /	 A0	     R0	    1	    1	 &	 &T' "4%   	p`  B
 
      @     `        Х         P2	 |2	     2	    2	    2	    2	    3	    3	    44	    I4	    W4	    4	     !   5	 -5	 `J !
 
h d 5	 -5	 `J  T 4
 Rp!   5	 5	 J ! x 
h d
 5	 5	 J  T
 4 rp d
 4	 
RpB
 `
 0 7	 7	     8	  d
 4	 
RpB
 
 P 08	 8	     8	 #
 #t
 d T 4
 rB
 
 8	 9	     9	 . .x *h &t "d T 4 
	B
 
 P:	 :	     ;	 ` `4
 d
 T rp BP0  B
  
 !	 !t2 d1 40 .   B
  
             K    , `   H   p                            <	 =	    5=	     m=	    =	     =	          Ѧ             
 
RPB
 P
 5
 5x# 1h$ !J p`0  B
 P
    
         L 	   ,     H   @ `                              @    ` 	    	               	       =	 >	     @?	    ?	    @	    `@	    @	    (A	    A	    A	    B	 	   $C	 
   C	 	   C	    D	    D	 
   D	    E	    E	 	   3G	    =G	    LG	    [G	    gG	          8        h R0 bP0  B
 
 $ $d  4 
pB
 
               N             N 	   , 8    X   	   , @   P X               Щ                                         @    `     @H	 mH	     sH	 H	    vI	    I	    I	 	   I	    J	 
   J	    1J	    @J	    WJ	 iJ	    J	    J	    J	 
   J	    K	    ,K	    CK	 PK	    UK	 P     ^    v                 C    P    l    y          P0  B
 
 Z ZG RH JI BJ =K 8L 3xM /hN +d '4  
p  B
 
     &   )      P 	   ,    h                                  @    `         	    	                 @    `                        @    `            Ю            0    P    p             Я !    "       0     P     p     '   0 '   P K	 K	     jL	    L	    #M	    CM	    VN	    }N	    N	    N	    N	 	   .O	 
   =O	    KO	    O	 
   O	    P	    VP	    }P	    P	    P	    P	    P	    Q	    6Q	    eQ	    Q	    Q	    Q	 	   R	    IR	    R	    R	    R	 &   !S	     /S	 6S	    ES	    SS	 	   S	    S	    &T	    4T	    T	    T	    T	    U	    U	    5U	    NU	    cU	     |U	 !   U	 "   U	 #   U	 "   U	 !   U	     U	    U	    V	    V	    V	    )V	    MV	 $   ^V	    mV	    |V	    V	 %   V	     V	 V	      '    (   ʰ '    )    '        #%#
 t d 4
 #rP  B
 
 p @W	 X	     %X	   	p`P0  B
 @
          б            @    ` PX	 qX	     X	    X	    X	    Y	    BY	    NY	    kY	    Y	 ( (d $T  4  
p  B
 
                Y	 Y	     Y	    Z	    Z	    Z	    L[	     W[	 %
 %4 
p`PB
 в
            P                    0    `     	    	   д [	 [	     [	    \	    \	    \	    \	    \	    ]	    *]	    6]	 	   e]	 
   q]	    _	  d 4 
RpB
  
         `	 3`	     Q`	    ]`	     
 
RPB
 0
 ! !4 pB
 0
               `W 	   , 8   P H   0a	 Ta	     a	 P     ]         
 
RPB
 `
 0 0x ,h 9 p`0B
 `
             W 	   ,     H                            pb	 c	     ;c	    Sc	    c	    c	    d	    'd	     d	       
    R     i
 i4
 t
 d T rU U9 M: E; @< ;= 6> 1x? -h@ )t %d !T 4  	  B
 
 p             ж            0    P    p     	       з e	 [g	     sg	    g	    g	    g	    h	    %h	    :h	    Sh	    hh	 	   ~h	 
   h	 	   h	    h	    h	    h	    h	    h	    h	    h	    i	    +i	    7i	     Fi	  P0  B
  
 $	 $d:  49 4 
p  B
  
             XZ 	   , h   0 h                               и i	 i	    i	    Kj	    Yj	 fj	    }j	    j	     j	 0     >    P    d                  4
 
RpB
 P
  j	 %k	     k	 !   k	 k	 [ !# #h G E TD k	 k	 [  > 
p`0  # #h 
4 
p
 
rPB
 
 ;
 ;x/ 6h0 %b p`0  B
 
             @\             ,\             \ 	   ,    X   	   ,    X   	   ,   0 X            p            й                       @ 
   `                                  0    P    p @q	 q	     q	 Rr	    ir	 ~r	    r	    !s	    7s	    is	    xs	    s	    t	    Rt	 	   ct	    t	 
   t	    t	 
   u	    xu	    u	 
   u	    u	    v	    v	    v	    w	    "w	    <w	    w	    w	    w	    x	    Dx	    Px	    x	    x	 0     =    d         
     ͺ    ں     u uA mB eC ]D UE MF EG @H ;xI 7hJ 34 # p`P  B
 `
          л            0    P    p         	   м            0 
   P 
   p            н          y	 Dz	     Zz	    z	    {	    ){	    8{	    F{	    }{	    {	    {	    {	    {	    |	    |	    }	 	   Z}	 
   k}	 	   }	    }	    $~	    0~	    M~	    	 
   3	    H	    	    	    	    	    ,	    >	    M	 
   	    	    ч	    	    	    5	    	     	  4	 
RpB
 p
 0     P    p            о                          	 8	     @	    H	    P	    X	    `	    n	    C	 
 
2PB
 
  4 
	p`B
 
               a @            8   `	 	     n	          8     5 5xx 1hy -4  p
`P  B
 й
 @ `                              @    ` 	    	    	        
             @ 
   @    `                                       @    `                                 @     `                     (     (     *   @ *   ` *                
     	     2   @    `              	 	      	    '	    ?	    f	    ~	    	    	    	    	 	   	 
   (	 	   L	    b	 	   Ȏ	    	 
   	    ,	    P	    ~	    ˏ	    	    	    	    А	    	    M	    	    	    n	    z	    	     1	 !   H	     	 "   	     	 #   	     ,	 $   >	     	 %   	     p	 &   |	     	 '   	 (   	 )   	 *   	 +   	 ,   	 -   Z	 *   h	 (   	     	    .	    =	    L	 .   [	    j	 /   y	    	 0   	    	 1   	 
   	    	 2   $	 3   3	 2   ;	 	   C	 4   	    	 5   	    
	 6   ^	    l	 7   	    Ο	 8   *	 O O G ? : 5 0x ,h (d3 $T2  41 * 
p  B
  
 `	 ʠ	     W	 }	     	    	    £	    ԣ	     	    	    	    +	 1 1 , 'x #h T 4  p`  B
 к
   	 	     	 !   @	 	 Xg ! d @	 	 Xg  t	 T 4 2 4	 
RpB
  
 `	 {	    	    	    	    ǧ	    ҧ	     ݧ	 / /h2 +dn 'Tm #4l f 
p  B
 0
   @    `                              @ 	   ` 	     	 R	     k	 	    Ȩ	    	    	    ?	    L	    [	    	    	    ٫	    	    L	 	   	 
   	 	   	    +	 	   :	    I	    	    ®	 0 0x ,h	 (d $T  4  
p  B
  
 @ 	 	     	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  B
 0
                        @    `                 
     
     P	 	     ,	    B	    X	    q	    Ҳ	    	    	    	    	 	   	 
   	    	    	 
   	    Ȼ	 
   	    	    ¼	    Ѽ	    	    	    6	     a	 0 0x ,h	 (d $T  4  
p  B
 `
 	 t	     ο	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  B
 
  	 	     	    	    (	    A	    	    n	    	    	    	 	   	 
   	    [	    ^	 
   	    	 
   t	    	    	    	    	    	    	     1	 0 0x ,h	 (d $T  4  
p  B
 
 	 D	     	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  B
 
 	 	     	    	    	    	    r	    >	    	    `	    	 	   	 
   	    +	    >	 
   f	    x	 
   T	    c	    r	    	    	    	    	     	 !   	 	 m ! 4	 	 	 m 
 
d
 
Rp
 
4	 
RpO O G ? : 5 0x ,h (d3 $T2  41 * 
p  B
  
 `                   p	 	     u	 	     	    	    	    	     	    	    7	    I	 O O G ? : 5 0x ,h (d3 $T2  41 * 
p  B
 P
 	 	     	 	     	    	     	    2	     H	    T	    w	    	  BP0  B
 
 . . )x %h !t d 4    B
 
               po 	   , (     H                   	 	     	                4    V    c    n      BP0  B
 
 . . )x %h !t d 4    B
 
               Hp 	   , (    H              @    ` 	 z	     ]	                      #    .     , , 'x #h
  
	p`P0B
 
       	 	     	    	     	 -	    Z	     f	  d T 4 pB
 0
  	 	     	  BP0  B
 `
 . . )x %h !t d 4    B
 `
               q 	   , (    H              `     	 	     p	                   6    C    N      BP0  B
 
 . . )x %h !t d 4    B
 
               r 	   , (    H                   @ 	 ]	     @	                                BP0  B
 
 . . )x %h !t d 4    B
 
               s 	   , (   ` H                    p	 -	     	 `     n                          BP0  B
 
 . . )x %h !t d 4    B
 
               `t 	   , (     H                   @	 	     	       .    @    T    v             / /x' *h( %4[ R 
p`P  B
  
  	 I	     	 . .x *h &T3 "42 * 	p`  B
 P
   	 z
     
 + +x! 'h" #TO 4N F 	p`  B
 
    
 
     
  d8 47 4 p  B
 
 @ 
 	
     
 '
 'T #4 
	p`B
 
 `      
 
     B	
    	
  h  0  B
 @
  P

 

     

 $
 $T  4 r
	p`B
 p
 

 
      4 r
p	`PB
 
  
 H
     $
 $T  4 r
	p`B
 
   
 -
      4 r
p	`PB
  
 0
 X
     8 8& 3x' /h( "S p`P0B
 0
                0     P     p               
 
     
    
     k
    y
     D
    X
     
    
     <
    J
     j
    x
     
    
    
    
     
 Y Y K 'x h d T 4 p. .x *h &t "d T 4 
	B
 `
  `
 
     
 
 
RPB
 
 5
 5x# 1h$ !J p`0  B
 
    
         y 	   ,     H    0    P    p                        0 	   P 	          p     	       
 
     I
    
    h
    
    T 
    ~ 
     
    %!
    !
 	   y"
 
   :#
 	   F#
    ^#
    #
 
   #
    %
    %
 	   w&
    &
    &
    &
    &
                4 Rp`PB
 
 &
 X'
     '
  4 p`PB
  
 @     ` '
 0(
     (
    (
 
 
RPB
 P
 0 0x ,h 9 p`0B
 P
             8{ 	   ,    H                             )
 )
     )
    *
    b*
    o*
    *
    *
     *+
          2     9 9
 4 /x +h 'd) #T( 4& " p  B
 
 P     p                   `+
 +
     +,
    -
     -
    .
     3.
    Y.
    i.
    %/
    1/
    @/
     /
 !   /
 0
 | !$
 $h $ , T+ 4* /
 0
 |  % 
	p` d2 41 . p  B
 
  2
 3
     3
 
 
rPB
 
 ;
 ;x3 6h4 %j p`0  B
 
             }             }             } 	   ,     X   	   ,    X   	   ,   P X   0                                       @    ` 
                                 0    P    p     5
 ]6
     n6
 6
    6
 7
    #7
    7
    7
    7
    8
    8
    8
    8
 	   8
    ?9
 
   ~9
    9
 
   9
    :
    B:
 
   N:
    e:
    :
    :
     ;
    ;
    ;
    ;
     <
    u<
    <
    <
    <
    <
    "=
    ?=
 P     ]             *              u uC mD eE ]F UG MH EI @J ;xK 7hL 34 # p`P  B
 
                  0    P    p             	           0    P 
   p 
                       0 =
 >
     >
    ?
    ?
    ?
    ?
    ?
    
@
    #@
    =@
    a@
    s@
    KA
    \A
    A
 	   A
 
   A
 	   	B
    kB
    B
    B
    B
    oD
 
   F
    F
    K
    +K
    vK
    K
    K
    K
    K
 
   L
    ?L
    QL
    uL
    L
    L
    M
     M
 , , 'x #h
  
	p`P0B
 @
 M
 M
     M
    Q
     Q
 -Q
    ZU
     fU
 , ,h  
	p`P0/ /h3 +dp 'To #4n h 
p  B
 p
 P p                        0    P    p 	    	    @]
 ]
     ]
 ]
    ^
    !^
    G^
    ^
    ^
    ^
    _
    _
    a
    =a
    a
 	   a
 
   a
 	   Zc
    kc
 	   zc
    c
    c
    d
 8 8& 3x' /h( "S p`P0B
 
 Pd
 d
     d
    e
     e
    e
     f
    f
     j
    j
     |k
    k
     k
    k
     k
    k
     l
    l
     l
 +
u+h s% 
	p`0P  B
 
  `l
 Gn
     q
  d T 4
 rpB
  
 @q
 q
     q
 !   h     !  t"  T#  4$ q
 r
 p !I Ih 9  /! t" T# 4$ q
 r
 p  % ` 4	 
RpB
 0
  0 u
 v
     lv
    |v
 $
 $d  T 4 pB
 `
 P v
 >w
     y
 #
 #h T 4 p`B
 
 p      y
 Fz
     z
    F{
     R{
 / /	 *x
 &h "4#  
p`P  $
 $T 4
 R
	p`B
 
           0
 r
     ˃
    
    i
    |
 
 
RPB
 
 ? ? : 5x 1h !, p`0  B
 
 	   	   
      D    ,   P H   0 P    p                        0               
 
     
    =
    U
    
    0
    
    |
    
    
    
    (
    7
    l
 
    
 	   ?
    
    9
    E
    T
    
 P     ] 
   m     C C ; 6 1x -h )4UJ
p	`P  B
 0
                                 @    @    `     
    
                     @    `                              @    `                              @    @ !   ` "            %                 @ )   ` *    *    )    -    )               )   @ 2   ` 3    4    4    3    7    7     9     :   @ :   ` 9   ` =    >    >    =    A    B     B     D   @ D   ` B    B    H    H    A     =     9   @ 3   `          7    Q    Q     7     T   @ 7   p V    W    W    V    V    7    \   0 \   P 7   p _    7    a    b     b     a     a   @ 7   ` g    g    7    j    j     3        @     ` 7    p    7    r    3              @ r   ` r    r    r    r    r     r     r   @ r   ` r    r    r    r         3        @     ` 
 T
     j
    
    Ë
    
    
 	   
 
   d
    
    '
 
   @
    g
    
    
    
    ю
    
    
    2
    W
    m
    {
    
    
    
    
    I
    [
    g
    
    
 !   
 "   
 #   ґ
 "   
 !   F
 $   U
    d
 %   t
 &   
 %   
    +
 '   9
    G
    z
 (   
 )   /
 +   d
 -   
 .   ؔ
 -   
 /   
 )   
    S
    b
    
    ҕ
    

 
   
    N
 0   ]
    e
 1   t
     |
 
 )   
 2   
 3   U
 5   
 7   
 8   
 9   o
 ;   
 =   ț
 ?   
 A   3
 B   m
 C   
 D   
 E   
 D   
 F   
 D   
 B   
 G   
 H   
 I   +
 H   c
 J   ~
 H   
 B   )
 K   8
 A   G
 L   V
 =   ^
 M   m
 9   u
 7   
 N   
 3   
 2   
 )   
    
    
    :
    r
    
 
   
    
 O   
    
 P   
     
 1
 7   {
 Q   
 R   
 Q   ߨ
 S   
 Q   
 7   F
 T   b
 U   x
 V   
 X   K
 Z   i
 [   x
 V   
 7   0
 \   C
 ]   V
 \   
 ^   
 \   
 7   
 _   
 `   -
 a   
 c   
 e   

 f   
 a   (
 7   p
 g   
 h   
 g   δ
 i   
 g   
 7   
 j   I
 k   d
 j   
 l   9
 j   S
 7   
 m   
 3   
 2   
 )   ϸ
    
    
    N
    
    
 
   ʹ
    
 n   
    
 o   (
     0
 E
 7   
 p   
 q   
 p   
 7   
 r   )
 s   ü
 r   Ҽ
 7   
 t   
 3   
 2   
 )   ,
    d
    s
    
    
    
 
   '
    _
 u   n
    v
 v   
     
 
 r   
     
 r   ,
 w   
 r   Ŀ
 x   6
 r   \
 y   
 r   
 z   f
 r   
 {   
 r   $
 |   
 r   
 }   
 r   
 ~   t
 r   
    6
 r   \
    
 r   
    
 r   
    |
 r   
 7   
    
 3   
 2   
 )   
    
    +
    c
    
    
 
   
    
    &
    .
    =
     E
 W
 r   j
    y
    
    
 
       B
 `
 
 
     
    1
     C
 
 b  B
 
  0 d     y 
 b  B
 
         
 b  B
  
    $     9 
 b  B
 P
          
 b  B
 
 @       ) 
 b  B
 
 ` @ t       h b  !     0 ! t   0  20!   0 B 0 ! t 0 B 0 !     0 ! t   0 !     0 ! t   0         202
    
 )
 {       t
 T	 4 2 t
 d	 4 R2
    ;
 
  
 5
 #
      	 4
 rp`2
    
 
  
  bp`0  2
    
 (
      	 B  2
    W
 
 P 
 
 
4 
2p             ȗ                                      8,            p                 ,            H
                 0     P                    p                       ,         @                    `,         @                    0                                                 -         @                    0     H                                      0                                                ,         @                    0                                                ,         @                          P                    h                  0-         @   0                                                                           p                          (                                                    H                     p     ؛                                                                     `1         @   @)                                        1         @   )                 .            f
                h                        2         @   @+                 +                            ؜                        P2         @   )                 0            
                H h                      X-         @                    h                      -         @   0*                ؝ h                      -         @   *                                  2         @   *                 p     `                      h                                   `V                              V         h   2                 8U @       (   0-                 .     h                               X                                                              [                              V         h   `G                                          @ h                                    P\         X                    `U         @    I                 8U         (   0-                 8, (          p                 , (          H
                 .     @                          @     P                       ء                                  \         X   `                 U         @   I                 + (                                                     `  p                                         ]                             `[         h   @H                 `     Т                     8 `                                          ^         h                    ]         P   d                 .         (   @                 8U (       (   0-                 .     P                                                   8 `                                         _                               _         h                                                H h                                       @`                             `_         h                         X                       h                                        a                             `         h                    P/         @                         0                    h                                     b            
                 a         h   @                  л  X          @                      x                        ^     H     2     "                                 p     4               b               v     $               L               t     0                         B               l                    R                    F     >          `                    X               4               X                    t     *                    R               0     (               V          `                              |           ~               H     ƽ     x     "     ؼ     z     0     ޻                  v     d     V     F     8     ,                                                       x     n     d     Z     8     ,                                             d     H     <                                   t     P     F     @     8     2     ,     &                    
                            >     $                    ƶ                    |     d     T     @     2                    ޵     ĵ                         p     b     R     :     &     
               д                         n     ^     H     0               Գ     Ƴ                    z     h     T     D     0     "                    Ҳ                         n     Z     J     <     .                    ܱ     ʱ                    ~     n     Z     D     ,                    »               ~     j     V     :     (                     ں     ƺ                    n     \     J     :     "                     ֹ     ¹                    x     d     H     ,               ָ     Ƹ                         h     T     <     ,                     ַ                    z     d          N     ڰ     Ȱ                    n     X     H              PyErr_Format  0 PyCObject_AsVoidPtr  PyExc_RuntimeError  6 PyCObject_Type   PyExc_AttributeError  	PyObject_GetAttrString   PyErr_SetString  PyExc_ImportError CPyImport_ImportModule  PyErr_CheckSignals  _PyList_Append  PyExc_ArithmeticError  PyExc_OverflowError  PyExc_IndexError   PyExc_IOError  PyExc_ValueError   PyExc_TypeError  PyExc_MemoryError  PyErr_Occurred  _Py_NoneStruct   PyBaseObject_Type SPyInt_FromSsize_t PyObject_GC_Track PyObject_GC_UnTrack P PyCode_New  mPySlice_New PyTuple_Pack  PyObject_GetAttr   PyExc_NameError  PyEval_EvalFrameEx  !PyFrame_New _PyThreadState_Current   PyEval_EvalCodeEx  PyDict_Next PyTuple_New _Py_CheckRecursiveCall  _Py_CheckRecursionLimit  PyDict_Size  PyExc_SystemError PyObject_Call / PyCFunction_Type  -PyFunction_Type PyObject_GetItem   PyErr_Clear  PyErr_ExceptionMatches  PyTuple_Type  kPyList_Type PyUnicodeUCS2_Decode  PyUnicodeUCS2_FromUnicode } PyDict_GetItem  2PyGILState_Release   PyErr_WriteUnraisable PyString_FromString  PyErr_PrintEx 0PyGILState_Ensure uPyString_AsString  PyDict_SetItem  _PyString_Eq  PyUnicodeUCS2_Compare PyString_Type PyType_IsSubtype   PyExc_BaseException  PyErr_NormalizeException  PyTraceBack_Type  PyObject_RichCompare  PyFloat_Type  PyLong_Type _Py_ZeroStruct  WPyInt_Type  _Py_TrueStruct  PyMethod_Type _PyType_Lookup  PyObject_GenericGetAttr PyObject_CallFunctionObjArgs  QPyInt_FromLong   PyDict_New  PyModule_GetDict  ePyList_New  PyObject_SetAttr  PyObject_Not  _PyObject_GetDictPtr  PyMem_Realloc PyMem_Malloc  ~PyString_FromFormat PyTraceBack_Here  ~PyLong_FromUnsignedLong PyObject_IsSubclass  PyErr_GivenExceptionMatches N PyClass_Type   PyObject_SetAttrString  PyType_Ready  7PyImport_AddModule  UPySequence_GetItem   PyExc_StopIteration  PyErr_SetNone _PyObject_CallFunction_SizeT   PyExc_GeneratorExit PyObject_CallObject 	 PyArg_UnpackTuple PyObject_GC_Del PyObject_ClearWeakRefs   PyErr_WarnEx   PyExc_RuntimeWarning  IPyRun_StringFlags  PyDict_SetItemString  PyObject_SelfIter QPy_GetVersion PyOS_snprintf APyImport_Import PyObject_Hash PyString_FromStringAndSize  PyString_InternFromString PyUnicodeUCS2_DecodeUTF8  v_PyByteArray_empty_string vPyString_AsStringAndSize  & PyByteArray_Type  PyObject_IsTrue LPyInt_AsSsize_t PyNumber_Index  qPyLong_AsSsize_t  PyObject_GetIter  PyFloat_FromDouble  PyFloat_AsDouble   PyDict_Type aPySequence_Tuple   PyExc_AssertionError  "PyObject_Size `Py_OptimizeFlag ,PyUnicode_Type  
 PyBaseString_Type mPyLong_AsLong rPyLong_AsUnsignedLong sPyLong_AsUnsignedLongLong _PyObject_GC_New  PyNumber_Add  PyObject_IsInstance !PyObject_SetItem  PyNumber_Subtract  PyExc_Exception  PyExc_NotImplementedError . PyCFunction_NewEx UPy_InitModule4_64 PyUnicodeUCS2_FromStringAndSize  PyErr_SetObject  PyErr_Restore  PyErr_Fetch python27.dll  o??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z  _??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 
?replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0PEBD@Z  	?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB ?find@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z  t??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z i ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBDAEBV10@@Z ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z  ?find_first_of@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z e ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@0@Z  g ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@PEBD@Z  ??$?MDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  ]?_Lock@_Mutex@std@@QEAAXXZ  ?_Unlock@_Mutex@std@@QEAAXXZ  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  , ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  - ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z  ?endl@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z   ??$?6DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@0@AEAV10@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z  ?swap@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEAV12@@Z \??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ O_LNan ??_D?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  Y?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??0?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z  G_Inf  v??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD_K@Z y??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 7?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?uncaught_exception@std@@YA_NXZ Z?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z  ??_D?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ ?str@?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z  d??0?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z $??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  #??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z z??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z N_LInf j??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ !
?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z +
?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  j?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ  ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ &?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z ?_Xsgetn_s@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_K_J@Z  )?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  :?flush@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z c?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z [_Nan  ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  L?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z ?exceptions@ios_base@std@@QEAAXH@Z  @??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z O?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z  `??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ^??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  
?quiet_NaN@?$numeric_limits@N@std@@SANXZ  J?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  d?close@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?substr@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV12@_K0@Z  P?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??_D?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ  	?open@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXPEBDHH@Z  ??0?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAA@XZ MSVCP90.dll {atan  |atan2 ceil  cos exp floor log pow sin sqrt  <tan _time64  ??0exception@std@@QEAA@AEBQEBD@Z  E ?what@exception@std@@UEBAPEBDXZ  ??1exception@std@@UEAA@XZ  ??3@YAXPEAX@Z 	 ??0exception@std@@QEAA@AEBQEBDH@Z c __CxxFrameHandler3   ??0exception@std@@QEAA@XZ 
 ??0exception@std@@QEAA@AEBV01@@Z  _purecall 
 ??1bad_cast@std@@UEAA@XZ   ??0bad_cast@std@@QEAA@PEBD@Z  I _CxxThrowException  malloc  free  _invalid_parameter_noinfo  ??0bad_typeid@std@@QEAA@PEBD@Z   ??1bad_typeid@std@@UEAA@XZ  l __RTDynamicCast  ??2@YAPEAX_K@Z  memmove_s  ??0bad_cast@std@@QEAA@AEBV01@@Z =_errno  memcpy  memcmp  log10  ??0bad_typeid@std@@QEAA@AEBV01@@Z clock MSVCR90.dll Y __C_specific_handler  _unlock  __dllonexit 7_encode_pointer =_lock _onexit -_decode_pointer N_malloc_crt _initterm _initterm_e 8_encoded_null  _amsg_exit  Z __CppXcptFilter C ?terminate@@YAXXZ 8 ?_type_info_dtor_internal_method@type_info@@QEAAXXZ { __clean_type_info_names_internal  Sleep  DisableThreadLibraryCalls QueryPerformanceCounter GetTickCount  GetCurrentThreadId  GetCurrentProcessId GetSystemTimeAsFileTime KERNEL32.dll                7#[                      stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711.pyd initstanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711                                                                                                                                                                                          #   *    +   H+   X+   h+                                       L   p                                     Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

       XM   p                     Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest

        Note
        ----
        This is currently an alias for the `traceplot` method.
                  Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
                  Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
            parameter (or quantile) name(s)
        permuted : bool
            If True, returned samples are permuted. All chains are merged and
            warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are discarded. If
           `permuted` is True, `inc_warmup` is ignored.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

              
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                     Transform parameters from defined support to unconstrained space                @l   "                  Pl    "                  `l   0$                                                  pl   0   *                   l                         k                          ,5       @                   l                          l                           l       @                   l                           l                          l   P    p                    l                             l       @                                                                                           (                                                                            m   p               J                                                      x                                                   E&     Pm   P&     '                                                                                                           P%                                                                                    0o   @"                  @o   P"                  Po   w                  \o   `"          0   ho             `   xo   $          @   o                     o                     o   @;             o   =          `   o                o   &             o   P(              p             @   p    ;             0p                     @p                      Pp                     `p                      pp    *                  p   q                  p                     p   q                  p                     p   Џ                  p                     q   Є                  (q                     Hq                                                     Xq    q                           dq                           D5                          pq                           q   P    p                    q                             q                           q   `                        q       0                    q                           q   p                                                                                        +                                                            &                                          q   h                (                                                 `                                              E&     0r    )    )                                    p           0                                                       q                                                                                                          pt                   ,                                                                                                                    A&             p-    -                                                                                                                    0,                                                                                                           t                   .                                                                                                                    A&             /                                                                                                                            @.                                                                                                           0u                   p0                                                                                                                    A&              1    1                                                                                                                    /                                                                                                           u                   2                                                                                                                    A&             03                                                                                                                            1                                                                                    H   n           P      u              ,   0q           8                                   p          t                                H                           h                                                              ȅ   x    x    ؅              Py    py                                                                                           x               w                                                                                                                    A             u                    8               p    P      p                                                                                                                           w            iW
@      <                            P}   2                           +                           6   (                          :   &                      0   6   &                         -                        ~   -                           *                           6   <                      (   (:   #                          +                        8   0                        h   t,                        (   1                         {   x0                        ~   +                           -                        ~   7   $                      ؀   |,                        {   1                        z   +                        8{   @7                         h   1   
                        .   	                        7   (                      P   5   A                      @   +                        X   2                        ~   -                        p   (1                        z   0                           5                         |   81                           2                        ~   H1                        {   4                        |   0                        ~   X1                            .   	                        (4                           2   
                      }   H3                           3                           x/   
                     H   $-                        {   3                        {   +                        `{   -                        {   ,                           -                           ,                        x~    8   t                      X~   2                        P   @4                        }   .   	                     0{   ,-                            0                           4                           ,                        `   h1                        P   (2   
                     (}   -                        P~   +                           +                           /   
                     }   4-                        ~   <-                        (   8   L                      ~   D-                            .                           /   
                      ~   L-                        8   .   	                      `~   X3                        |   H5                           .                           T-                        z   82   
                        4                        X   \-                        }   .                        h   ,                        Ѐ   +                           /   
                      {   .                        0   d-                        }   +                         ~   /   
                     p~   ,                        |   /   
                      |   l-                        }    .                            +                        Ȁ   /   
                     |   3                        `   x1   
                        .   
                     }   `5                        |   H2   
                        .   	                     h   (.                           .   	                        X2   
                     z   t-                            /   
                     @   -                        H{   0                        @   6   .                      }   ,                        p}   +                        x   0                        {   /   
                        1                        h~   /   	                     {   +                        z   0   
                     z   5                           -                        z   0.                           +                        h}   ,   	                     |   2                           8.   
                        0   
                     8   -                           -                        x{   ,                           0                           +                            -                        H}   ,                           5                            8   "                      |   H.                        `   +                        0~    9   x                         ,                        `   86   '                       }   9   "                         ,                        @   h2   
                        ,                        X{   3                        p   $,                        z   P.                           2                           4                        p|   /   	                     Ђ   ,,                           ,                        P   2                        z   ,                        p   -                        |   (3                        ~   3                        }   1                        |   x2   
                        1                        x   ,                        Ȃ   X.                        }   X4                        ~   `.                        ~   +                        x|   (0   
                        1                        z   3                        H   05                        ~   83                        ~   80   
                     {   h.                        |   (/   	                     x}   h3                        {   p4                           x3                        {   1                        {   4,                        (   <,                        X}   ,                        @~   ,                        8}   0                            p.                        p{   4                        x   9   ?                     0}   8/   	                     {   3                           +                        h   2   
                     z   +                        z   x.   	                        H,   	                     0   H0   
                     Ё   T,                        ؂   ,                        |   H/   	                     {   3                        ({   .                        H   X0   
                     }   2   
                     8   1                           h0   
                     `   -                        |   X/   	                      {   `6   %                      8~   \,                        {   -                           d,                         0   ,                         @}   -                        z   1                        |   4                        h{   -                        X   -                        |    5                        @{   -                        X   .                        z   l,                           h/   	                     |   +                                                                
           .?AVbad_exception@std@@ 
           .?AVexception@std@@     
           .?AVbad_alloc@std@@     
           .?AVlogic_error@std@@   
           .?AVdomain_error@std@@  
           .?AVinvalid_argument@std@@      
           .?AVlength_error@std@@  
           .?AVout_of_range@std@@  
           .?AVruntime_error@std@@ 
           .?AVoverflow_error@std@@        
           .?AVunderflow_error@std@@       
           .?AVrange_error@std@@   
           .?AVvar_context@io@stan@@       
           .?AVclone_base@exception_detail@boost@@ 
           .?AVsp_counted_base@detail@boost@@      
           .?AVbad_lexical_cast@boost@@    
           .?AVbad_cast@std@@              
           .?AVbase_writer@writer@interface_callbacks@stan@@       
           .?AVvari@math@stan@@    
           .?AVrounding_error@math@boost@@ 
           .?AVbase_adapter@mcmc@stan@@    
           .?AVbase_mcmc@mcmc@stan@@       
           .?AVbase_adaptation@mcmc@stan@@ 
           .?AVfixed_param_sampler@mcmc@stan@@     
           .?AVchained_var_context@io@stan@@       
           .?AVbad_typeid@std@@    
           .?AVfailure@ios_base@std@@              
           .?AV?$var_context_factory@Vpy_var_context@io@pystan@@@var_context_factory@interface_callbacks@stan@@            
           .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@            
           .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@             
           .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@        
           .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@           
           .?AU?$located_exception@Vexception@std@@@lang@stan@@            
           .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         
           .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         
           .?AV?$base_hamiltonian@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@        
           .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      
           .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      
           .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@     
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@              
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@  
           .?AVwindowed_adaptation@mcmc@stan@@     
           .?AVstepsize_adaptation@mcmc@stan@@     
           .?AVstepsize_adapter@mcmc@stan@@        
           .?AVstream_writer@writer@interface_callbacks@stan@@                        
           .?AV?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     
           .?AV?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     
           .?AV?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    
           .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       
           .?AV?$unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                
           .?AV?$dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      
           .?AV?$adapt_unit_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           
           .?AV?$adapt_unit_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$adapt_diag_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           
           .?AV?$adapt_diag_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$adapt_dense_e_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@          
           .?AV?$adapt_dense_e_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                
           .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@         
           .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@     
           .?AVexception@boost@@   
           .?AUbad_alloc_@exception_detail@boost@@ 
           .?AUbad_exception_@exception_detail@boost@@     p           p   z           
           .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@         
           .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@  
           .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@      
           .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       
           .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@          
           .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@               
           .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@  
           .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@              
           .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@   
           .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@    
           .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@             
           .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@        
           .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@          
           .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@        
           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@   
           .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@ 
           .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@ 
           .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@          
           .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@           
           .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@    p           p   p|   H{           H{           H{           8D
   8D
         @            H         H   
           .?AVsample@mcmc@stan@@  (   
           .?AVps_point@mcmc@stan@@        
           .?AVunit_e_point@mcmc@stan@@    
           .?AVsum_values@pystan@@ 
           .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              
           .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              
           .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_static_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      
           .?AV?$base_hmc@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_nuts@Vanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    
           .N      
           .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@       
           .?AVprob_grad@model@stan@@      
           .?AVstepsize_var_adapter@mcmc@stan@@    
           .?AVstepsize_covar_adapter@mcmc@stan@@  (         
           .?AVop_dv_vari@math@stan@@      
           .?AVop_vv_vari@math@stan@@      
           .?AVop_vd_vari@math@stan@@      
           .?AVadd_vv_vari@?A0x21e70d80@math@stan@@        
           .?AVadd_vd_vari@?A0x21e70d80@math@stan@@        
           .?AVdivide_vv_vari@?A0x21e70d80@math@stan@@     
           .?AVdivide_dv_vari@?A0x21e70d80@math@stan@@     
           .?AVsubtract_dv_vari@?A0x21e70d80@math@stan@@   
           .?AVmultiply_vv_vari@?A0x21e70d80@math@stan@@   
           .?AVmultiply_vd_vari@?A0x21e70d80@math@stan@@   
           .?AVop_v_vari@math@stan@@       
           .?AVneg_vari@?A0x21e70d80@math@stan@@   
           .?AVstored_gradient_vari@math@stan@@    
           .?AVpartials_vari@?A0x21e70d80@math@stan@@      
           .?AVexp_vari@?A0x21e70d80@math@stan@@   
           .?AVsum_v_vari@math@stan@@               |
   ~
            h                  p            
           .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x21e70d80@math@stan@@       
   8
   
   
   
   (
   X
   
   
   
       
           .?AVdiag_e_point@mcmc@stan@@    
           .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@     
           .?AVanon_model_db8febf10f23d7fa27a62fbcfd7f17b2@anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_namespace@@    
           .?AVcovar_adaptation@mcmc@stan@@        
           .?AVvar_adaptation@mcmc@stan@@  
           .?AVpy_var_context_factory@io@pystan@@  
           .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@    
           .?AVpystan_sample_writer@pystan@@       
           .?AVpy_var_context@io@pystan@@  
           .?AVdense_e_point@mcmc@stan@@   
           .?AVarray_var_context@io@stan@@ ȣ
   p
   
   
   d       8~                 8~              
   
   d       8
   8
   
   
   
   
   8
   8
             {   z           u      
           .?AVtype_info@@         2-+  ] f                                                                                                                                                                                                                                                                                                                                                                                          U  L U    T     h   4  | 4  t   t                 $     t  8          (             A  d p    l   =  t P       !   P          0  }          ]   p       A   P       ]   p       A   p       !   P           0   }   $       0 !  ]!  8 p!  !  D !  ="  L P"  "  X "  #  ` 0#  #  l #  #  t $  a$   $  $   $  A%   P%  ?&   P&  '    '  (   (  (    )  )   )  +   +  ,   0,  ,   ,  [-   p-  -    -  7.   @.  .   .  k/    /  /  , /  [0  < p0  1  D  1  n1  P 1  1  ` 1  k2  h 2  3  p 03  ~3  | 3  Q;   ;  X<   <  z=   =  ?   ?  @   @  IA   PA  A   A  A    A  VB   VB  B  $ B  C  @  C  AC  P AC  C  X C  LD  t LD  D   D  D   D  $E   $E  iE   iE  |E   E  	G   G  G   G  EH   PH  H    H  (I   (I  >I  ( PI  I  8 I  ?J  L ?J  SJ  ` J  <K  p K  K  | K  K   K  [L   [L  L   L  L   L  L   L  L   L  bM   pM  M   M  P   P  Q  4 Q  Q  < Q  Q  P Q  Q  d Q  R  t R  S   T  &V   0V  V   V  ?W   W  W   X  Y   Y  Y   Y  Z   Z  p[   p[  [   [  4\  ( @\  \  8 \  @^  D P^  ^  h ^  0_  p @_  _  x _  `   `  `   `  a   a  b   b  b   c  c   0c  ?c   Pc  _c   pc  c     c  c    c  c    c  c    d  d     d  Te  ,  Te  e  P  e  e  d  e  qf  t  f  g    g  g    g  j    j  k     k  k    k  k    l  Nm    `m  m    m  m    m  m    m  n  ! n  n   ! n  Lo  ,! `o  o  4! o  fp  H! fp  p  \! p  #q  l! 0q  vq  t! vq  q  ! q  ar  ! pr  r  ! r  s  ! s  Xt  ! Xt  t  ! u  u  ! u  Fv  ! Pv  pw  " w  w  " w  x  " x  x  $" x  x  D" x  =y  T" py  y  \" y  hz  d" pz  {  l" {  |  |" |  }  "  }  }  "  ~  I~  " P~    "      "     "    ^  " p    " Ё    "   f  " f     #     #   Z  $# Z  {  ,# {    @#   ԃ  X#   p  h# p    #   (  # 0    #   R  $ `  5  ,$ @    `$ Ј    h$     x$   P  $ `    $     $      $   V  $   ;  $ P    $ В    $     %    R  % `    % 0  }  $%     0%   ˖  8%   1  D% `    L%     X%    r  `%     h% P    t%     % 0  }  %     %   ˛  %   1  % @    %   I  % P  ~  % ~  2  % 2  У  &     (&   w  4& w    \&   H  l& P     &     &   E  & E  a  & p    &     &   ,   ' @    '      4'     @'     h'   (  x' 0  @  ' @    '     '   +  ' +  H  ( P    (       (   ,  (( `    @(     L( @    T(   a  `(     h(   A  t( p    |(   !  ( P    (     ( 0  }  (     (   ]  ( p    (   =  ( P    (     ( 0    (     (   a   ) p    )    b   ) p  -  () @  I  T) P    )   }  )   k  )   ;  ) p    )      )   k  )   ;  * p    *      *   K  (*     4* 0    @*   [  L*     X*      d*    =  l* P  0  t* @    *     *     *     *   A  * A    *     *     +   7  $+ p    4+   K  <+ `   D+  ? P+ ?  \+   t+   +   +   +  Z + `  + p  +   +  ( + ( L , `  ,   $,  )	 8, 0	 	 P, 	 	 X, 	 	 l, 	 
 ,  
 
 , 
 
 , 
 
 , 
 
 ,  w , w  ,   ,   -   g - g  $-   8-   P-  W
 `- W
 v
 h- v
 
 |- 
 
 - 
 p - p  -   -  E -   -   L.   T.  a \. p  t.   .   /  - $1 @ R <1 R ! H1 ! +! d1 @! O! t1 O! # 1 # # 1 # '$ 1 @$ $ 1 $ % 1 p% % 1 % B& 1 p& & 2 & o 2 o p <2 p Yp T2 Yp vp h2 p q x2  r r 2 r t 2 t t 2  u u 2 u ]w 2 ]w {w 2 {w w 3  x x 43 x 2 @3 2 T l3 T q 3   3 0 R 3 R  3  Q 3 Q } 3    4  T 4 T p ,4   <4   T4   `4   4   4   4   4   4  + 5 +  ,5   @5  d \5  $ d5 0  x5   5  - 5 @  5   5   1 5 @  5   5   1 5 @  5   5   ! 5 `" # 5 $ & 5 & <( 6 P( )  6 * A* 46 P* , L6 - @- 6 P- . 6  . = 6  > ? 7  @ A 7 A NC 8 `C G `8 G WH |8 `H nL 8 L M (9 M  R 9 0R V <: V i\ ; p\ ` @< ` f = f j D> k Vk > Vk k > k l > l l ,? l p ? p t @  u y A y } B  }  D   D   ~ $E   `E   ł E Ђ . E @  F   XF    F   F  [  G [  $G  - \G @  H   H  h \J p  dK   lK   L   `M  # M # ( @O  ( ) P ) )  P ) [0 P p0 : Q ; 5; S @; = S = ? ,S ? J S J K T  L V U V f X f m Z m q [ 0q q [ q Hs  \ Ps x h\ x a ^ p   a @ z y  ڙ y  ( y 0 ] 0 `    ݚ 0  ( y 0 |   ̛     F 0 P h 0 p  0  * y @ f 0 p  0     F a P e غ e  Xa   Ha    la   la   V ta   0   G y P  y   a  F a   0   a  G 0 p  0  פ 0  
 0  = 0 @   b   `b   G 0  ȧ 0 Ч  0  F b P  c  ƨ pc Ш  c  F @d P  d  Ʃ e Щ  xe  F e P  Hf  ƪ f Ъ  g  F g P   Ы  g  8 Ԡ @  Ԡ  `  `  |h  M dh M q Th   h  ( h ( N h P  Ԡ  . 0  4 h @ ~ y   h P  h  ַ 8i   i  G ti G  di  f i p ~ 0 ~  i   i   0 0  i   0   0   9 0 @  j   y   H y P  y   y   H y P x 0   0   n 8j p    C  P    #  0  |j    Lk   l   Pl   l   y   a l a  l   l   u m   m  ( 0 @  (m   lm   Tm   Dm    |m   0   m   m  > m @  y   y   ^ y `  y   y   ~ y   y  > y @  y  L @n P  ,n   @n   ,n    @n  T ,n `  @n   ,n  O @n P  ,n   @n   ,n     Tn    n  ( n ( 3 n @  n  ) n ) $ n 0  o    To   o   o `  4p `  Hq   0   q   dq   Tq  U q `  0r   غ   r   r   r P  l  0 p    p     s     s    r   R @s `  s   s  : s : 8 s @  t   t   t  W tt W f dt f ~ Tt   0    t   ! u ! " Pu  # <& u @& & w & ' y ' p' y p' -( w 0( B( w B( h( w h( ( lw ( &) Xw &) 0) Hw 0) >) 8w >) @) (w @) ) w ) ) w ) ,* x 0* * Dx * * px * <+ x @+ + x + + 0 + _, y `, , 0 , /- y 0- - y - - y - N. y P. . y . %/ y 0/ / y / 
0 m 0 |0  0 p1 ty p1 1 0 1 1 0 1 ,2 0 02 k2 0 p2 2 0 2 R3 y p3 3 0 3 f4 0 4 4 0 4 h5 y p5 6  z 6 7 @z  8 8 0{ 8 =;  { =; Q; z Q; k; z k; C z C #E D{ 0E JF { PF ~F  | F UG h| `G H | @H H |  I I } I J D}  J J x} J K } L &M 0 PM M 0  N N 0 N O 0 O O 0 O P 0{ P 
S $~ 
S !S ~ !S ;S  ~ ;S [ } [ ] T~ ] ` ~ ` ` 0 ` a ~ a a ~ a a ~ a b ~ b b H  c d  d d 4 d 5e Ѐ Pe e  e "f 0 0f f 0 f f ؈ f 9g T 9g >g D >g \g 0 `g g h  h qh q qh o  o o t o s m s rt  t u Ԡ u v  v v y v v  v Jw ԁ Jw Ww ā Ww w  w z 8 z z   z |  | -}  0}  t   \      Ԃ           ߃ 0     7 p 7  T  \ @ \ p 0 p t  t        ̇ ȃ      0    0   0    0  ߋ `   Ą  5  5    = | @ 4   4 %  %  ܄  < < P ƥ x Х F  P  0  F 0 p ̧ 0 Ч H y P 8 ؅ @      v 4   `    0  ߫ 0   غ  O  O T  `  ̢  h Ć h    t ؆   \  e 8 e t (  0 h 0  y  Ҳ 0         |  % m 0 Դ   }   o  p  0   ,   Z y ` ظ y  n y p  T   ؈        !  0 & ؈ 0 & ؈ 0     0   (   0   T    m   0       0  8  @ _ 0 `  D   0   l   y   y   Z y `  y   y       ܊    (   `        S < `    ?  ? O  P    ) Ȍ ) 9  @ _ 0 `  0   ܌  J y P  y  p h p #  0  T               Ԡ     F \ P  l               L  L H  H W Ў `  $     c    p   \   L  1 8 @ h  h           Ԡ    P {  { 4  4        t @ t  0   0    `   0  8  @ z y   y   : y @  y          h  s    0   0   <     &  0 d t d  X   H   0  (  0 j y p  y     c  p  8  C  P o 0 p  0     
 ܔ 
 W
 ̔ `
 
 P 
 
 < 
    N  N P  P  Ԡ  
 0 
 
 \ 
 
 y 
     ̕  s (  3 p @ Y ̢ Y  Ȗ            I    y   y   M 0 P | 0   y   L   0  )   0 Y  Y [ h [ d X p  0   0    h   !  ! " 4  " c"  p" E#  P# # y # w$ m $ $   $ % ̙ % % 0  & `&  `& & 0 & & 0 & b+ @ p+ / h  0 0  0 \1  \1 j1  p1 }2  }2 2  2 > ؜ > RB Ȝ `B OC L PC C  C }D  D ME D PE E  E 3G  @G eG 0 pG H  H H ؞ H H Ȟ H I 0 I ;I  ;I J   J .K  O O   O 1P  1P T l T U X U U H U U 0 U  V   V mZ Ԡ pZ Z  Z [ ؟ [ [ ȟ [ e  e e t e tf \ tf vf L f f  f @g  @g g Ԡ g h 0  h Eh 0 Ph h ܠ h h 0 h k  k k  k l  l l  l  m ġ  m q  q r 0  r v D v ~w Ԡ w w ̢ w 4x  4x ax  px y Ԡ y y Ԣ  z 
{   { Y{ p Y{ { \ { { L  | t}  } ~  ~ F D P  P  + d 0  y     Â P Ђ     l  - \ 0 [ 0 `     p   X  4 t @  T  z m               ԩ       ђ           y    p  И  И    B 0 `  4   t  
  @   М       .  @  y   / \ 0 ?  @ O  P    C \ C  L  E  E    Χ p Ч ݨ   R D `  m   I 0 P y 0      O  P Ԭ H Ԭ ެ 0 ެ C  C          P  P Ӱ  Ӱ ݰ  ݰ B t B  d   T  k  p 
 @  ?    0   ܲ   T  ȷ  p ( س P  y  1 y @  y  1 y @ ׽ ,  l  p  D  > m @        $       P N  P     4          p               P  (   Ԡ   h   غ  d  d       8  8     D  _ $ _   P  L       0  J y P         (   x  X  `  D  {    ļ  _  _  Ľ        , 0 0 | 0   0  6 0 @  0   0   ^ 0 `  y      [ 0 ` T  ` >  @  y  n  p        y  N  P .  0  0      " 0 0  0  n  0 p    0   s 4     T l T  \  v Ԡ 0     0        z  z     غ  	 , 	 	  	 
 @   P  ' y 0  y  %
 y 0
 _
 y `
 
 y 
 
 y 
 
 y 
     e x p  m  &   0 |       |    0  D  P     T   0  !  ! "  " #  # N$ \ P$ % 0 % z* , z* +  + C2  P2 6 | 6 7 X 7 : @  : i;  i; @  @ -D  -D F  F GH  PH xH  xH *J d *J J T J J  J jL  jL L  P P  P jR  jR R  R gS  pS $T ( 0T U X U W h W W X W X @ X X 0  Y uY d Z =[  @[ \  \ \  ] ^ , ^ :_ h _ Z`  a -b  0b b   c c H  d d   e e  e f  f g  g h P  i i m i f  p "  0  8  *  * z  z 7 h 7  L  ( < 0   Ј q    x  ݍ ` ݍ ߍ P   T        5  5 ̏  ̏ ܏   g  p     6   @  (      { 0   8  C t P e | p   0 M 0 M         P m 0 m  $  ˚  ˚ ݚ   ʜ  М ! 8 0 E  P Ȧ  Ц I  P  \  `  ` R   `  0  r          ߲ 0  ( H 0     P     q    `   L   <    Ԡ  , l 0        D            `  `  D  \  `        0   I 0 P m d m  P   @  {  {     t  j  p     l      T   @  4 0 @     |   h   "         o  o     (   t                  H  I 0 P . d 0    p $ p @  @        &  &      , t ,  X  m D m  4           d  d        l  p 2   3 z4 $ 4 5 p 5 C7  P7 28  @8 8 0 8 8 0  9 C  C E  E G   G I  I J d J tK 0 K L | L {M  M "O  0O jP  pP ]S  `S -T  0T U  U XW  `W Y  Y "Z " 0Z o[  p[ \ , \ \ غ \ ] \ ] ] L ] /^  /^ j`  j` ` p ` ` 0 ` b  b c  c d y d kf ( pf Yh @ `h ~i  i j X j k h k >m x @m n x n @p ( @p r  r s   s jt X pt nu h pu v  v v 0 v v  	 v w p w x X x x H x oy  py z  z {  { |  | .}  0} N~  P~                  Ɓ Ԡ Ё 1  @  0        0                M   P 5 4 @  L  ^  ` O  P ݭ H ݭ  4  ί $ Я  d     ص       L   h  	 0  ܼ              T  `     $         _ 0 ` v |   y            y  c  p    s <      : l :    `  `       * l *  X  P @ P  0         ^  ` y  	 y    L  L Z  `  0  u 	   y  A <	 P o 0 p i l	 p i   p         A  P      
   a 
 p     t   "     K  P y          p    \   L   |  x    0      . 0 0 . ` 0      L      !  0    y \     q    y  z \     Z  `    P m P    D  y P    y     0   @! y @! !  ! "  " :# @ @# % h  & (  ( "*  0* +  + / 8 / / D  0 0 y 0 1  1 L  L f L f h !  h `j " `j j   k k |3 k o 8" o Up " `p Tq " `q er K pr Es # Ps t  # t v 0#  v w D#  x y d# y y   z z  z { $$ { *~ @$ 0~ Z  `    ؁ $  e % p Ã % Ã  %   %   %   \&   x  N x P  y  ؎ l&  ; & @ m & p  y   '  
 l(   (   (   Ε X) Е 2  @ ) ) 0 F ) P f * p  +  ħ p, Ч 1 0 @  0  L <- P  t-    -   y   ϭ - Э j . p g \0 p ~ 2 ~ 
 1 
 վ 1 վ  1  " 1 0 G $2 P  2   |3   3     4  , H4 0 ( 4 ( f 4 p f 4 p  4   4   t   5  n 85 p a ( p  6   7   	 8  	 L	 B P	 e	  e	 	 C 	 	 B 	 	  C 	 
	 C 
	 =	 pD @	 U	 D `	 	 D 	 	 E 	 	   	 	 PE 	 2	 E @	 c	 E p	 	 F 	 	 4 	 !	 0F !	 !	 F !	 J#	 F J#	 b#	 F p#	 %	 F %	 n.	 ,H p.	 /	 H /	 N2	 I P2	 
5	 I 5	 -5	 `J -5	 t5	 HJ t5	 5	 8J 5	 5	 J 5	 6	 J 6	 "6	 pJ 06	 6	 0 6	 7	 y  7	 {7	 0 7	 ,8	 J 08	 8	 J 8	 9	 K 9	 K:	 m P:	 ;	 TK ;	 <	 K <	 =	 K =	 G	 L G	 <H	 8N @H	 K	 XN K	 5W	 `P @W	 HX	 T PX	 Y	 T Y	 ~[	 lU [	 `	 U `	 `	 V `	 'a	  0a	 mb	 8W pb	 d	 W d	 e	 X e	 i	 X i	 j	 $Z j	 k	 [ k	 k	 [ k	 m	 `[ m	 m	 P[ m	 Go	 F Po	 Fp	 4 Pp	 <q	 [ @q	 x	 [  y	 	 \^ 	 Q	 ` `	 	 Ta 	 \	 a `	 	 @f 	 ;	 f @	 	 Xg 	 /	 Dg /	 S	 4g `	 	 lg  	 	 g 	 M	 i P	 ѽ	 Ti 	 	 j  	 	 k 	 	 l 	 	 dl 	 	 m 	  	 m  	 	 pm 	 c	 m p	 	 m 	 	 xn 	 	 0o 	 	 p 	 	 p 	 	 Hq 	 	 q 	 o	 pr p	 ?	 Hs @	 	  t 	 	 t 	 
 0u  
 

 |u 
 
 u 
 

 v  

 B

 0 P

 

 Tv 

 
 v  
 
 v  
 -
 v 0
 
  w 
 
 Lw  
 $
 Xx 0
 4
 Xx @
 D
 Xx P
 T
 Xx `
 
 |x 
 &
 x &
 '
 xz '
 )
 z  )
 Z+
  { `+
 /
 { /
 0
 | 0
 2
 | 2
 2
 | 2
 5
 | 5
 =
 0} =
 M
  M
 U
  U
 6]
  @]
 Fd
  Pd
 Sl
  `l
 2q
  @q
 q
  q
 r
 p r
 t
 H t
 t
   t
 u
  u
 v
 | v
 v
 0 v
 y
  y
 z{
   {
 /
 X 0
 
  
 
   
 
  
 M
  
 5
  
 <
  <
 S
 0 T
 
 0 
 
 Ж 
 E
  H
 
  
 
 ( 
 2
 P X
 
 y 
 
 y P
 
 x 
 
 0 
 
  
 
   
 
   
 9
 L @
 Y
 T `
 y
 \ 
 
 d 
 
  
 
  
 
 8  
 
 @  
 9
 H @
 {
  
 
  
 
   
 ;
  @
 {
  
 
  
 
   
 ;
 $ @
 {
 4 
 
 D 
 
 T  
 5
 d @
 Y
 # `
 x
 # 
 
 # 
 
 @$ 
 
 h)  
 
 p)  
 <
 . @
 \
 $. p
 
 . 
 
 . 
 
 . 
 
 / 
 
 / 
 ,
 / 0
 I
 / P
 i
 / p
 
 / 
 
 / 
 
 / 
 
 / 
 	
 / 
 )
 0 0
 I
 0 P
 i
 0 p
 
 0 
 
 $0 
 
 ,0 
 
 h6 
 	
 p6 
 ,
 7 0
 L
 7 P
 l
 7 p
 
 $7 
 
 ,7 
 
 7 
 
 7  
 
 (8  
 9
 08 @
 X
 8 `
 {
 8 
 
 @9 
 
 H9 
 
 9 
 
 9 
 +
 9 0
 _
 9 p
 
 \: 
 
 d: 
 
 l: 
 
 t: 
 ?
 0; @
 X
 8; `
 x
 @; 
 
 H; 
 
 P; 
 
 X; 
 
 `;  
 
 h;  
 8
 p; @
 [
 x; `
 {
 ; 
 
 `< 
 
 h< 
 
 p< 
 
 x< 0
 _
 4= `
 x
 <= 
 
 D= 
 
 L= 
 
 T= 
 
 \=  
 
 d=  
 ;
 l= @
 X
 t= `
 {
 |= 
 
 = 
 
 d> 
 
 l> 
 
 t> 
 ?
 |> P
 ~
 <? 
 
 ? 
 
 ? 
 
 ? 
 
 ? 
 (
  @ 0
 H
 @ P
 l
 @ p
 
 @ 
 
 @ 
 
 @ 
 
 A 
 
 A 
 (
 A 0
 H
 A P
 l
 $A p
 
 ,A 
 
 B 
 
 B 
 
 B 
 
  B 
 (
 (B 0
 H
 0B P
 l
 8B p
 
 @B 
 
 C 
 
 $C 
 
 ,C 
 
 4C 
 (
 <C 0
 H
 DC P
 l
 LC p
 
 TC 
 
 0D 
 
 8D 
 
 @D 
 
 HD  
 9
 PD @
 \
 XD `
 |
 `D 
 
 hD 
 
 D 
 
 8E 
 
 tE  
 
 E 0
 H
 E P
 h
 0F p
 
 lF 
 
 F 
 
 |G 
 
 G 
 
 G 
 (
 G 0
 K
 G `
 x
 4H 
 
 <H 
 
 DH 
 
 LH 
 
 TH 
 (
 $I 0
 H
 ,I P
 
 4I 
 
 <I 
 
 DI 
 
 LI 
 
 TI  
 
 \I  
 ;
 dI @
 \
 lI `
 x
 tI 
 
 J 
 
 J 
 
 J 
 
 J 
 +
 J 0
 K
 J P
 k
 J p
 
 J 
 
 J 
 
 J 
 
 J 
 
 8L 
 +
 @L 0
 K
 HL P
 k
 PL p
 
 XL 
 
 `L 
 
 hL 
 
 pL 
 
 xL 
 (
 L 0
 I
 L P
 i
 L p
 
 L 
 
 L 
 
 M 
 
  N  
 
 N  
 ;
 N @
 [
 N `
 {
  N 
 
 (N 
 
 0N 
 
 8N 
 
 @N  
 
 HN  
 ;
 PN @
 [
 XN p
 
 dO 
 
 lO 
 
 tO 
 
 |O  
 
 O  
 8
 O @
 [
 O `
 {
 O 
 
 P 
 
 P 
 
 P 
 
 P 
 +
 P 0
 t
 P 
 
 Q 
 
  R 
 
 R 
 
 R  
 
 R  
 8
  R @
 X
 (R `
 x
 0R 
 
 8R 
 
 @R 
 
 HR 
 (
 S 0
 H
 S P
 k
 S p
 
 S 
 
 S 
 
 S 
 
 S 
 
 T 
 (
 T 0
 H
 T P
 k
 T p
 
 $T 
 
 U 
 
 U 
 
 U 
 
 V 
 +
 V 0
 K
 V P
 k
 V p
 
 $V 
 
 ,V 
 
 4V 
 
 <V 
 
 DV 
 +
 LV 0
 K
 TV P
 k
 \V p
 
 dV 
 
 lV 
 
 tV 
 
 |V 
 
 V 
 +
 V 0
 O
 V P
 k
 V p
 
 V 
 
 V 
 
 V 
 
 V 
 
 V  
 ;
 V @
 [
 V `
 {
 V 
 
 X 
 
 X 
 
 X 
 
 X 
 (
 X 0
 H
 X P
 h
 X p
 
  Y 
 
 Y 
 
 Y  
 
  Y  
 ;
 (Y P
 h
 <Z p
 
 DZ 
 
 LZ 
 
 TZ 
 
 \Z 
 
 dZ 
 (
 lZ 0
 H
 tZ P
 h
 @[ p
 
 H[ 
 
 P[ 
 
 X[ 
 
 `[ 
 
 h[ 
 ,
 p[ 0
 H
 x[ P
 h
 \ p
 
 \ 
 
 \ 
 
 \ 
 
 \ 
   \   (  \ 0  H  \ P  k  \ p    \     ^      _     _    _   ; _ @ [  _ ` { (_   0_   @_  4 H_ @ [ X_ ` { `_   h_   p_   x_  $ _ 0 K _ P  _   _   _   _       = b @ ] b ` } `c   c   0d   d    e    he   = e @ ] 8f ` } f   g   pg             9  @ Y  `             . hj 0 H  P h  p     8k     	   )  0 L  P i  p             		  	 )	  0	 I	  P	 i	  p	 	  	 	  	 	  	 
 q 
 A
  r P
 n
 0s p
 
  
 
  
 
  
 
  
 	   ,  0 I  P i  p             	   ,  0 I  P i  p             	
  
 )
  0
 H
  P
 w
 x 
 
  
 
  
 
  
 
     {   9  @ X  ` x          4  )  0 O  P                   8  @ Y  ` y            5 @ @ j  p          	   (  0 `  ` x                 J  P z                 8  @ j  p             
   :  @ X  `          
   (  0 Z  ` x                  8  @ j  p          
   (  0 Z  ` x                    9  @ X  ` |                    8  @ g  p                +  0 `  ` x                 8   ;  @ s               (  0 H  P k  p        8     #  0 L  P w <              :  @ X  ` {                 )   0  I   P  l   p                      !  ! 7!  @! g!  p! !  ! ! ` ! ! ` ! u" @ " "  " " 0 " 	#  # 7# d @# ^# d `# |#  # #  # #  # #  # #   $ $   $ <$  @$ \$  `$ |$  $ $  $ $  $ $  $ $   % E% \ P% k%  p% %  % %  % %  % & \  & 9&  @& Y&  `& |&  & &  & &  & &  & &   ' '   ' 9'  @' \'  `' |'  ' '  ' '  ' '  ' (   ( 8(  @( g(  p( ( | ( (  ( ( 0  ) ') ̲ 0) W)  `) ~)  ) )  ) )  ) )  ) )   * *   * i* l p* *  * *  * *  * *  * +  + Y+ ض `+ +  + +  + +  + +  + ,  , ,,  0, K,  P, k,  p, , ` , ,  , ,  , ,   - -   - <-  @- Y-  `- x-  - -  - -  - -  - -   . .   . <.  @. Y.  `. y.  . .  . .  . .  . .   / /   / 9/  @/ Y/  `/ y/  / /  / /  / /  / /   0 0   0 ;0  @0 [0  `0 x0  0 0  0 0  0 0  0 0   1 1   1 <1  @1 Y1  `1 |1  1 1  1 1  1 1  1 1   2 2   2 <2  @2 Y2  `2 |2  2 2  2 2  2 2  2 3  3 ,3  03 y3 D 3 3  3 3  3 3  3 3   4 4   4 84  @4 _4  `4 x4  4 4  4 4  4 4   5 5   5 85  @5 X5  `5 x5  5 5  5 5  5 5  5 5   6 6   6 96  @6 [6  `6 {6  6 6  6 6  6 6  6 6   7 7   7 97  @7 \7  `7 |7  7 7  7 7  7 7  7 7   8 8   8 8  8 8  8 8  8 9  9 )9  09 I9  P9 l9  p9 9  9 9  9 9  9 9  9 	:  : (:  0: :  : :  : :   ; ;   ; 9;  @; Y;  `; |;  ; ;  ; ;  ; ;  ; ;   < <   < 8<  @< [<  `< {<  < =  = )=  0= L=  P= l=  p= =  = =  = =  = =  = >  > ,>  0> L>  P> i>  p> >  > ?   ? 9?  @? \?  `? |?  ? ?  ? ?  ? ?  ? ?   @ @   @ <@  @@ \@  `@ y@  @ @  @ @  @ @  @ NA  PA iA  pA A  A A  A A  A A  A B  B )B  0B IB  PB iB  pB B  B B  B B  B B  B 	C  C )C  0C IC  PC iC  pC C  C C  C C  C C  C 	D  D )D  0D ID  PD iD  pD D  D D  D D  D D   E E   E GE  PE lE  pE E | E E  E E  E E   F F   F 9F  @F XF  `F {F  F F  F F  F F  F F   G G   G 8G  @G XG  `G xG  G G  G G  G G  G G   H H   H <H  @H \H  `H |H  H H  H H  H H  H I  I (I  0I HI  PI hI  pI I  I I  I I  I I   J J   J 8J  @J \J  `J J D J J  J J   K K   K 8K  @K XK  `K xK  K K  K K  K K  K K   L L   L 8L  @L XL  `L xL  L L  L L  L L  L L   M M   M 8M  @M \M  `M xM  M M  M M  M M  M M   N N   N ?N  @N XN  `N xN  N N  N N  N N  N N   O O   O 9O  @O YO  `O yO  O O  O O  O O  O P  P ;P  @P kP \ pP P  P P  P P  P P   Q 'Q d 0Q KQ  PQ kQ  pQ Q  Q Q  Q Q  Q Q  Q R  R +R  0R KR  PR kR  pR R  R R  R R  R R  R S  S +S  0S WS x `S S x S S  S S  S S  S T  T +T  0T KT  PT hT  pT T  T T  T T  T T  T HU  PU kU  pU U  U U  U U  U U  U V  V +V  0V KV  PV kV  pV V  V V  V V  V V  V W  W +W  0W KW  PW lW  pW W  W W  W W  W W  W X  X ,X  0X LX  PX lX  pX X  X X  X X  X Y  Y (Y  0Y HY  PY hY  pY Y  Y Y  Y Y  Y Y  Y Z  Z (Z  0Z HZ  PZ hZ  pZ Z  Z Z  Z Z  Z Z  Z [  [ ,[  0[ L[  P[ l[  p[ [  [ [  [ [  [ [  [ \  \ ,\  0\ L\  P\ l\  p\ \  \ \  \ \  \ \   ] ]   ] 8]  @] X]  `] x]  ] ]  ] ]  ] ]  ] ]   ^ ^   ^ ;^  @^ [^  `^ {^  ^ ^  ^ ^  ^ ^  ^ _  _ +_  0_ K_  P_ k_  p_ _  _ _  _ _  _ _  _ `  ` +`  0` H`  P` h`  p` `  ` `  ` `  ` `  ` a   a 8a  @a ga  pa a  a a  a a  a a  a b  b (b  0b Hb  Pb lb  pb b  b b  b b  b b  b 	c  c )c  0c Ic  Pc hc  pc c  c c  c c , c d  d d  d d |  e e   e 8e  @e Xe  `e xe  e e  e e  e e  e e   f f   f <f  @f \f  `f |f  f f  f f  f f \	 f g  g (g  0g Hg  Pg kg  pg g  g g  g g  g g  g h  h ,h  0h Th  `h {h  h h  h h  h h  h h   i Ei 
 Pi ii  pi i  i i  i i  i i  i j  j /j  0j Ij  Pj hj  pj j  j j  j j  j j  j k  k (k  0k Hk  Pk hk  pk k  k k  k k  k k  k l  l (l  0l Hl  Pl hl  pl l  l l  l l  l l  l 
m  m ,m  0m Lm  Pm pm  pm m  m m  m m  m m  m n  n /n  0n On  Pn on  pn n  n n  n n  n n  n o  o (o  0o Lo  Po ko  po o  o o  o ^p   `p xp  p p  p p  p q  q (q  0q Hq  Pq kq  pq q  q q  q q  q q  q r  r +r  0r Kr  Pr kr  pr r  r r  r r  r r  r s  s +s  0s Ks  Ps ks  ps s  s s  s s  s s  s t  t ,t  0t Lt  Pt lt  pt t  t t  t t  t t  t u  u ,u  0u Wu  `u |u  u u  u u  u u  u u   v v   v <v  @v \v  `v |v  v v  v v  v v  v w  w +w  0w Kw  Pw kw  pw w  w w  w w  w w  w x  x +x  0x Kx  Px kx  px x  x x  x x  x x  x y  y +y  0y Ky  Py ly  py y  y y  y y  y y  y z  z ,z  0z Lz  Pz lz  pz z  z z  z z  z z <  { {   { <{  @{ \{  `{ |{  { {  { {  { {  { {   | |   | <|  @| \|  `| ||  | | < | |  | |  | }  } )}  0} H}  P} l}  p} }  } }  } }  } }  } ~  ~ (~  0~ O~  P~ h~  p~ ~  ~ ~  ~ ~  ~ ~  ~    )  0 I  P i  p                +  0 I  P v         ۀ           8  @ \  ` |         ؁           <  @ _  `          ߂           <  @ `  ` x         ۃ   	   (  0 H  P h  p       ӄ )          8  @ c * p       ˅  Ѕ  +       8  @ [  `  `,      -  (  0 H  P h  p       ˇ  Ї       ,  0 I  P l  p       ̈  Ј    	   4 t. @ \  ` x         ۉ           9  @ Y  ` y         ي           8  @ X  ` x         ۋ           8  @ j 3 p       Ȍ  Ќ       ,  0 H  P l  p       ͍  Ѝ       0  0 O  P h  p       Ȏ  Ў       +  0 H  P l  p       ȏ  Џ       +  0 K  P h  p       ̐  А       +  0 Y  ` {         ۑ           <  @ X  ` y         ܒ           9  @ X  ` |         ؓ           9  @ X  ` |         ؔ           9  @ X  ` |         ؕ           9  @ X  ` |         ؖ           <  @ \  ` y         ؗ           <  @ \  ` y         ۘ           9  @ X  ` {         ٙ           ;  @ \  ` y         ܚ           9  @ Y  ` {         ܛ           ;  @ X  ` x         ܜ           ;  @ X  ` x         ؝           ;  @ [  `  8     ɞ  О       ,  0 I  P h  p     C  ۟       $  0 T  `  <E  Ƞ  Р       (  0 K  P h  p       ϡ  С        8  @ b  p             2  @ X  `       ң           8  @ [  ` x         ؤ           8  @ X  ` x      ϥ  Х       (  0 H  P h  p     K       9  @ [  ` {         ۧ           ;  @ X  ` x         ܨ   H L P  DN  ɩ  Щ        DN     ٪           9  @ Y  ` y         ۫           ;  @ [  ` {         ج           ;  @ _  ` {               2  @ [  `       ˮ  Ю       ,  0 I  P i  p       ̯  Я       ,  0 L  P k  p    $ LP 0 L  P l  p       ϱ  б       2  @ Y  ` y         ٲ           B  P r      ҳ      (  0 R  ` x      ȴ  д         F  P  (W     ܵ       b W p       ̶  ж    	   ,  0 I  P l  p       ɷ  з       +  0  Z  ɸ  и       ,  0 k [ p       ɹ  й     [   8  @ [  ` x          [     )  0 L  P i  p       ˻  л       +  0 H  P l  p       ˼  м       +  0 L  P h  p       ̽  н       ,  0 L  P l  p       ̾  о       ? Da @ [  ` {         ۿ           ;  @ [  ` {                    ;  @ [  ` |                    ;  @ \  ` |                    <  @ \  ` |                    ;  @ [  ` {                    ;  @ X  ` {                    <  @ [  ` |                    ;  @ \  ` |                    ;  @ [  ` {                    8  @ X  ` x                 o        ? o @ Y  ` y            _ q ` y       \r   9  @ Y  `  4s           t                ;  @ [  ` x               (  0 H  P h  p                (  0 H  P h  p        x   8  @ X  ` x            B z P h  p                +  0 L  P   }              :  } @ X  ` {            
  }  ,  0 I  P l  p                ,  0 K  P h  p                +  0 H  P l  p                ,  0 L  P l  p                (  0 K  P k  p             	   )  0 I  P i  p                (  0 H  P h  p                ,  0 H  P h  p                +  0 K  P }                    ;  @ [  ` {                    ;  @ [  ` {                    ;  @ _  ` {                    ;  @ [  ` y                    ;  @ [  ` |                    ;  @ \  ` |                    <  @ [  ` {                    8  @ \  ` |                    ;  @ [  ` {                    ;  @ b  p                +  0 I  P l  p                  ;  @ [  ` {                    ;  @ [  ` {                    ;  @ [  ` {                    ;  @ [  ` {                    ;  @ [  ` {                    ;  @ [  ` {  {             F  P q    0   0   0  . 0 P n 0 p  0   F 0 P n 0   0    0   > 0 @ Z 0 ` ~ 0   0   0  ; 0   0   0   ( 0 0       I @ P u 0   p  9  @  Е   0   0  W     0     "  0 B 0 B l H l r 8   0   l   \   0         \ 0 `  0   0  , 0 0 l 0 p  0                                                                                                                                                                                                                                                                T   8@HPX`hpxȩЩة  (08@HPX`  (   hpxȬЭخ          
    Щة  (08@HPX`hpȪЪت pxȫЫث  ȬЬج@HPX`hpxЯد   
 |    ȠРؠ  (@HP`hpxȤФؤ  (08@Щة  (  
     08@HPX`hpx (08@HP`hpxȤФؤ (08@HPX`hpxx(08@HPX`hpxȯЯد 0
      (08@HPؤ HPX`h(08@HPX`hpxȦЦئ  (08@ HPX`hpxȩЩة ج  (08@HPX`hpx @
 <    (08@HPX`x  (   P
    HPX`ȤФؤ  (08@HȪЪت  (08@HPX`ȫЫث (08@HPX`hpȬ  (08@HP `
      (08pxX`hpxȧЧ  (0hpxȨ  (08@HPX`ȩЩة(08@HPX`hpx p
 P    (08@أ hpxȤФhpxȥХإX`h 
 D   ȡ (08@HPX`hpȮ 
 L   xا  @HPX`hpx08@HPX`hpx 
      (08PX`hpx (08@HPX`hpxPX`hpxȮЮخ  (08@HP 
    ئ  $     (8X`     X    (@HФؤ  (0HPXpxȥХ 8@HHPȧاpxШب(08PXpxȩЩة(08HPXpxЪت08PXpxЫث08X`hЬج  (0HPXpxȭЭ(hخ08@hx     (@ȠРHСXآH`hؤxPXhpxЦ px Шبhة (0PXxȪЪ @Hhp08X`Ьج  (HPpxȭ8@`hخ (0PXxȯЯ       @Hhp08X`Сء  (HPpxȢ8@`hأ (0PXxȤФ @Hhp08X`Цئ  (HPpxȧ8@`hب (0PXxȩЩ @Hhp08X`Ыث  (HPpxȬ8@`hح (0PXxȮЮ @Hhp   d  08X`Рؠ  (HPpxȡ8@`hآ (0PXxȣУ @Hhp08X`Хإ  (HPpxȦ8@`hا (0PXxȨШ @Hhp08X`Ъت  (HPpx8`0XH(P   0 <   H` PPpЩ0H8PЯ @     pУ0p0P P @   08`إ `@ `P   ` ` H   @ Т  (PXP0`   p    Ƞ8hء P @ @p XȥإHPX`hpxЦ ا@Ш 0`hpxȩة  (0H                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              q
Umodule_nameqU>stanfit4anon_model_db8febf10f23d7fa27a62fbcfd7f17b2_1845989711qU
model_nameqU+anon_model_db8febf10f23d7fa27a62fbcfd7f17b2qub.