(cpystan.model
StanModel
q oq}q(U
model_cppnameqX+   anon_model_047a6166bd9c6ecaed4dd3733fae7c6bqU
model_codeqTN  data {
  int T;                                // Sample size
  int<lower=1> K;                       // Number of seasonal vectors
  real t[T];                            // Day
  real cap[T];                          // Capacities
  real y[T];                            // Time-series
  int S;                                // Number of changepoints
  real A[T, S];                   // Split indicators
  real t_change[S];                 // Index of changepoints
  real X[T,K];                    // season vectors
  vector[K] sigmas;              // scale on seasonality prior
  real<lower=0> tau;                  // scale on changepoints prior
}

parameters {
  real k;                            // Base growth rate
  real m;                            // offset
  real delta[S];                       // Rate adjustments
  real<lower=0> sigma_obs;               // Observation noise (incl. seasonal variation)
  real beta[K];                    // seasonal vector
}

transformed parameters {
  real gamma[S];                  // adjusted offsets, for piecewise continuity
  real k_s[S + 1];                 // actual rate in each segment
  real m_pr;

  // Compute the rate in each segment
  k_s[1] = k;
  for (i in 1:S) {
    k_s[i + 1] = k_s[i] + delta[i];
  }

  // Piecewise offsets
  m_pr = m; // The offset in the previous segment
  for (i in 1:S) {
    gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
    m_pr = m_pr + gamma[i];  // update for the next segment
  }
}

model {
  real Y[T];

  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.1);
  beta ~ normal(0, sigmas);

  // Likelihood
  for (i in 1:T) {
    Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta)) * (t[i] - (m + dot_product(A[i], gamma))))) + dot_product(X[i], beta);
  }
  y ~ normal(Y, sigma_obs);
}
qUmodule_filenameqUAstanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.pydq	U
model_cppcodeq
Xn  // Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class anon_model_047a6166bd9c6ecaed4dd3733fae7c6b : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<vector<double> > A;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
public:
    anon_model_047a6166bd9c6ecaed4dd3733fae7c6b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    anon_model_047a6166bd9c6ecaed4dd3733fae7c6b(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
        validate_non_negative_index("t", "T", T);
        t = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("t");
        pos__ = 0;
        size_t t_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
            t[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
        validate_non_negative_index("cap", "T", T);
        cap = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("cap");
        pos__ = 0;
        size_t cap_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
            cap[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
        validate_non_negative_index("y", "T", T);
        y = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "S", "int", context__.to_vec());
        S = int(0);
        vals_i__ = context__.vals_i("S");
        pos__ = 0;
        S = vals_i__[pos__++];
        context__.validate_dims("data initialization", "A", "double", context__.to_vec(T,S));
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
        vals_r__ = context__.vals_r("A");
        pos__ = 0;
        size_t A_limit_1__ = S;
        for (size_t i_1__ = 0; i_1__ < A_limit_1__; ++i_1__) {
            size_t A_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < A_limit_0__; ++i_0__) {
                A[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
        validate_non_negative_index("t_change", "S", S);
        t_change = std::vector<double>(S,double(0));
        vals_r__ = context__.vals_r("t_change");
        pos__ = 0;
        size_t t_change_limit_0__ = S;
        for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
            t_change[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
        validate_non_negative_index("X", "T", T);
        validate_non_negative_index("X", "K", K);
        X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_limit_1__ = K;
        for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
            size_t X_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                X[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("sigmas", "K", K);
        sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("sigmas");
        pos__ = 0;
        size_t sigmas_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
            sigmas[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
        tau = double(0);
        vals_r__ = context__.vals_r("tau");
        pos__ = 0;
        tau = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"K",K,1);
        check_greater_or_equal(function__,"tau",tau,0);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += S;
        ++num_params_r__;
        num_params_r__ += K;
    }

    ~anon_model_047a6166bd9c6ecaed4dd3733fae7c6b() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        // generate_declaration k
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        // generate_declaration m
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        // generate_declaration delta
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        // generate_declaration sigma_obs
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        // generate_declaration beta
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ k;
        (void) k;  // dummy to suppress unused var warning
        if (jacobian__)
            k = in__.scalar_constrain(lp__);
        else
            k = in__.scalar_constrain();

        T__ m;
        (void) m;  // dummy to suppress unused var warning
        if (jacobian__)
            m = in__.scalar_constrain(lp__);
        else
            m = in__.scalar_constrain();

        vector<T__> delta;
        size_t dim_delta_0__ = S;
        delta.reserve(dim_delta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            if (jacobian__)
                delta.push_back(in__.scalar_constrain(lp__));
            else
                delta.push_back(in__.scalar_constrain());
        }

        T__ sigma_obs;
        (void) sigma_obs;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_obs = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_obs = in__.scalar_lb_constrain(0);

        vector<T__> beta;
        size_t dim_beta_0__ = K;
        beta.reserve(dim_beta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            if (jacobian__)
                beta.push_back(in__.scalar_constrain(lp__));
            else
                beta.push_back(in__.scalar_constrain());
        }


        // transformed parameters
        vector<T__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);
        vector<T__> k_s((S + 1));
        stan::math::initialize(k_s, DUMMY_VAR__);
        stan::math::fill(k_s,DUMMY_VAR__);
        T__ m_pr;
        (void) m_pr;  // dummy to suppress unused var warning
        stan::math::initialize(m_pr, DUMMY_VAR__);
        stan::math::fill(m_pr,DUMMY_VAR__);


        try {
            current_statement_begin__ = 29;
            stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
            current_statement_begin__ = 30;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 35;
            stan::math::assign(m_pr, m);
            current_statement_begin__ = 36;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
                current_statement_begin__ = 38;
                stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < S; ++i0__) {
            if (stan::math::is_uninitialized(gamma[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < (S + 1); ++i0__) {
            if (stan::math::is_uninitialized(k_s[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: k_s" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(m_pr)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: m_pr";
            throw std::runtime_error(msg__.str());
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                vector<T__> Y(T);
                stan::math::initialize(Y, DUMMY_VAR__);
                stan::math::fill(Y,DUMMY_VAR__);


                current_statement_begin__ = 46;
                lp_accum__.add(normal_log<propto__>(k, 0, 5));
                current_statement_begin__ = 47;
                lp_accum__.add(normal_log<propto__>(m, 0, 5));
                current_statement_begin__ = 48;
                lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
                current_statement_begin__ = 49;
                lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.10000000000000001));
                current_statement_begin__ = 50;
                lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
                current_statement_begin__ = 53;
                for (int i = 1; i <= T; ++i) {

                    current_statement_begin__ = 54;
                    stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(cap,i,"cap",1) / (1 + exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))) + dot_product(get_base1(X,i,"X",1),beta)));
                }
                current_statement_begin__ = 56;
                lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("k_s");
        names__.push_back("m_pr");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((S + 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
        for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
        }
        vars__.push_back(sigma_obs);
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector<double> gamma(S, 0.0);
        stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(gamma,DUMMY_VAR__);
        vector<double> k_s((S + 1), 0.0);
        stan::math::initialize(k_s, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(k_s,DUMMY_VAR__);
        double m_pr(0.0);
        (void) m_pr;  // dummy to suppress unused var warning
        stan::math::initialize(m_pr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(m_pr,DUMMY_VAR__);


        try {
            current_statement_begin__ = 29;
            stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
            current_statement_begin__ = 30;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 35;
            stan::math::assign(m_pr, m);
            current_statement_begin__ = 36;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
                current_statement_begin__ = 38;
                stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < (S + 1); ++k_0__) {
            vars__.push_back(k_s[k_0__]);
        }
        vars__.push_back(m_pr);

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (S + 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "m_pr";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (S + 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "m_pr";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

} // namespace

typedef anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b stan_model;

qUmodule_bytesqT  MZ                @                                       	!L!This program cannot be run in DOS mode.

$       ?QQQIQQQQPQQQQRichQ                        PE  d {XZ         " 	    J     (u
                                                                           M     d                         
                                                    0	                          .text   ~                        `.rdata  6                   @  @.data      P     D             @  .pdata                       @  @.reloc                       @  B                                                                                                                                                                                                                                                                                                                                H%! @WH H
  HHu H
 H H	 H _H HH\$0 HHu
HWHR0Hu%H
 H H	a H\$0H _Hd H9Ct9H
_ H H	/ H,  HCHP0H\$0H _H, HHA uHCHP0H. Hu%H
 H H	ʇ H\$0H _=	  t7H H
Ç H H	DA	   H\$0H _H   
s;H   H
v H H	DA
   m H\$0H _Hp   u	H t%H H
" H	) H\$0H _3H\$0H _LHwH       II     MAu    IAtIIHHRL;uD  LIHHHRL;tIIHHL;u     LIHHHL;tIvI|I@SHPHD$ HH HL$( HHT$(HHL$( HP[E~utAAu2D~tAAu2@WHPHD$ H\$`HHH HL$(~ HHT$(HHL$(~ LHASHHL$(~ HHT$(HHL$(~ H1 HL$(~ HHT$(HHL$(~ H HL$(Z~ HHT$(HHL$(`~ LHH\$`HP_IcHT$WHPHD$ H\$`HHLH HL$(} LHHAHL$(} HH\$`HP_H%} @SHPHD$ HL H@ HL$(}} LHHAHL$(} L H& HL$(K} LHHAHL$(Z} L H HL$(} LHHAHL$((} HP[@SH H7 A   E3H| H| LL;tHH| H [  HAL   MtIH@@HtH HH%ր LI LYE3EIHL;AM;AEtHHAJICHA3H% LAL9A ~HHAJI@HA3H%Q H   HD$P Ht
33NY
 HĈ   HAH HA@SH H HH HAHHIH9 uHAP0Ln 3L[H [H[ HC3H [HA H HA @SH H HH HA HHI H9 uHAP0L~ 3L[ H [H~ HC 3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H3~ HH HA0HHI0H9 uHAP0L~ 3L[0H [H} HC03H [HA8H HA8@SH H} HH HA8HHI8H9 uHAP0L} 3L[8H [H{} HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH H| HH HA@HHI@H9 uHAP0L| 3L[@H [H| HC@3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH H{ HH HAPHHIPH9 uHAP0L{ 3L[PH [H{ HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH H{ HH HAXHHIXH9 uHAP0Lz 3L[XH [Hz HCX3H [HA`H HA`@SH Hz HH HA`HHI`H9 uHAP0Lnz 3L[`H [H[z HC`3H [H\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _HAHH HAHHAXH HAXHAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH Hy HH HAHHIH9 uHAP0Lx 3L[H [Hx HC3H [HA H HA @SH Hx HH HA HHI H9 uHAP0Lnx 3L[ H [H[x HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH Hw HH HA(HHI(H9 uHAP0Lw 3L[(H [H{w HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH Hv HH HA0HHI0H9 uHAP0Lv 3L[0H [Hv HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH Hu HH HA8HHI8H9 uHAP0Lu 3L[8H [Hu HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH Hu HH HA@HHI@H9 uHAP0Lt 3L[@H [Ht HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH H3t HH HAHHHIHH9 uHAP0Lt 3L[HH [Hs HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH HSs HH HAPHHIPH9 uHAP0L.s 3L[PH [Hs HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH Hsr HH HAXHHIXH9 uHAP0LNr 3L[XH [H;r HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH Hq HH HA`HHI`H9 uHAP0Lnq 3L[`H [H[q HC`3H [H(   Hr
30  Hq Hg E38  LHuH(Hp ICHp H Hp IC Hp H Hp IC0Hp H Hp IC8Hp H Hp IC@Hp H Hp ICPHp H H|p ICXHqp H Hgp IC`H\p H IH(H\$Ht$WH HHIIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH Hco HHIHCHQo H Ht
HuHAP0H5o HK HC H&o H Ht
HuHAP0H
o HK0HC0Hn H Ht
HuHAP0Hn HK8HC8Hn H Ht
HuHAP0Hn HK@HC@Hn H Ht
HuHAP0Hn HKPHCPHzn H Ht
HuHAP0H^n HKXHCXHOn H Ht
HuHAP0H3n HK`HC`H$n H Ht
HuHAP03H [H\$WH HHm HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _H\$Ht$WH HHIIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht	HօunHK8Ht	Hօu\HK@Ht	HօuJHKHHt	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH Hl HHIHCHl H Ht
HuHAP0Hel HK HC HVl H Ht
HuHAP0H:l HK(HC(H+l H Ht
HuHAP0Hl HK0HC0H l H Ht
HuHAP0Hk HK8HC8Hk H Ht
HuHAP0Hk HK@HC@Hk H Ht
HuHAP0Hk HKHHCHHk H Ht
HuHAP0Hck HKPHCPHTk H Ht
HuHAP0H8k HKXHCXH)k H Ht
HuHAP0H
k HK`HC`Hj H Ht
HuHAP03H [H\$WH HHj HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _@SH 3Hy  L
Z t=H Hc
: H3HCHCHLCH   i HH [3IA0  HHuH [H\$WH Hi HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
 Hz  @ǅtH  H
d H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH Hh HHIHCHh H Ht
HuHAP0Hh HKHCHvh H Ht
HuHAP03H [@SH 3Hy  L
N t=H Hc
. H3HCHCHLCH   g HH [3IA0  HHuH [H\$WH Hg HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
 Hz  @ǅtH  H
X H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH 3Hy  L
 t=H Hc
 H3HCHCHLCH   @f HH [3IA0  HHuH [H\$WH He HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
 Hz  @ǅtH  H
 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH He HHIHCHd H Ht
HuHAP0Hd HKHCHd H Ht
HuHAP03H [@SH 3Hy  L
 t=H3 Hc
 H3HCHCHLCH   0d HH [3IA0  HHuH [H\$WH Hc HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
 Hz  @ǅtH` H
 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H   HZ    b HH Hu y  W Z  `  H+    xb Hq Hur {    Z  )  Hl    Ab H Hu;    	[    H    
b H Hu    [    H    a Hd Hu͸   { [    H    a Hչ Hu   D *[  M  H
a LHla H- Hu^ K   5[    H
pa LH4a Hյ Hu& K  Խ 8[    H     ` HV Hu U   C[    H9    ` H Hu   f N[  o  H    ` H@ Hu   / Y[  8  H˸    P` H! HuJ    d[    H    ` H Hu-H      o[  HS HĘ   HQ    _ HO Hu-HK     o z[  H HĘ   HN    _ H$ Hu-H  v   $ [  H HĘ   H    8_ Hy Hu-H + 7  ٻ [  Hr HĘ   H    ^ H Hu-Hj  ;   [  H' HĘ   HŶ    ^ H3 Hu-H  O  C [  Hܴ HĘ   H    W^ H Hu-H J    [  H HĘ   H    ^ H Hu-H     [  HF HĘ   HԳ    ] H Hu-H>    b [  H HĘ   H    v] HO Hup 2    [  '  H    ?] LH} Hu6 l   [    H@ HI A   HT$hD$`l  HD$XHR E3HD$PHc HD$HHD$@L\$8HD$0HD$(HT$    \ H Hu l  X [  a  H< L
M Lְ H H$   H HD$xH    HD$pH HD$hH HD$`Hs HD$XH HD$PHk HD$HH HD$@H; HD$8H HD$0H۲ HD$(H HD$ [ LH Hu{ [  }Lڴ H A   LD$hD$`o  HD$XH AQ
AHD$PH HD$HHD$@L\$8HD$0HD$(LD$ E3Z[ H Hu- [  : o  H H HĘ   3HĘ   H\$WH HH
̵ HAL   MtHAL@@Mt	HW A	H9[ HHuH
Z LG H H	&] HH\$0H _HB   s HAL   Mu
L@@MtH IH%Z LH
&Z H H	H%\ H\$Hl$Ht$WH HY MHH(IHE3MHY HHtT3H~&     HHHH H;HCHp  |3HY EHHu
HWHR0MHH\$0Hl$8Ht$@H _DD$HT$HL$SUVWATAUAVAWHhLiHyHq 3Ll$PH|$XIMcLMtIX LLHX HAHX HHX 9J~H
 X t3  HtMuYA}CuRHuE9}uMLIIHK  Eu)Ht$LFIcEI;uHVLIbH  H   K$X HH   LpH$   HMNMLH$   W tQMM~f     IE IH$   H IO,H M}MMHW uLl$PD$   IHH+HLHLH$   HH(Ht
HFH^HL$   HT$XHL$HD$@H\$8Dd$0E3ILt$(D|$ 5W HHtHu
HGHP0HW HHIHhA_A^A]A\_^][H\$Hl$Ht$WH HAIHH   HHuV HV HAHV HH}V 9J~H
 qV t3ELHHH
wV HHJHu"V HuH
V Hp H	X HH\$0Hl$8Ht$@H _H\$Ht$WH HAHqHHxHV HAHU L HU A9H~#H
- U t3H\$0Ht$8H _HHH
U HHJHu"U HuH
ZU H H	
X Ht$8HH\$0H _H\$Ht$WH H   H0U HHuH\$0Ht$8H _HE3HHHx#HHu
HSHR0H\$0Ht$8HH _HT$SHPHAHH;T    HT Hl$`HiHHt$pHqH|$xHy BHT HHiT 9J~(H
c ]T tH|$xHt$pHl$`3HP[Ã~Cu!Hu~uDGHT$hLHUNLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(LL$hHE3HD$    S H
S H|$xHt$pHHl$`JHP[H;|S uHA@tHP[@HP[@SHPHAHH;4S   HwS Hl$`HiHHt$hHqH|$pHy BHOS HHS 9J~(H
 S tH|$pHt$hHl$`3HP[Ã~Cu:Hu9~u0LE33HfLGHcFI;uHWLHHLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(HE3E3HՉD$ R H
R H|$pHt$hHHl$`JHP[H;R uHA@t3HP[%H E3HP[AE3MMEAMADtMyLMHMyLL;LOM+M33H%|Q HD$8IIHtLD$0HLL$0LD$(H%[Q @SH HHH
= 'Q Ht	H H [HH [@SH0HBIH;P t=H;P t4H;P t+3H;Q LH HDHD$ LP H0[P HHDH H0[LH
fQ H H	H%S HLH
2Q H	Hm L
 Hr LDH%OS H\$WH LQHHyPHYXHQHLAPLIXMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _HAHHHAPI HAXI3HAHHAPHAXHAWH@|$x HXHhHpHxL`LhHLptN DAHO H(3LeHLmPLuXHEHHEPHEX9D$pt6MtI$MtIE MtIMMIH   N HN HMHHuPH}XLeHLd$0LmPLl$(LuXLt$ Hl$XHHt
HuHQR0HtHu
HFHP0Ht$`HtHu
HGHP0H|$8HuH
O N HN Hu
HCHP0|$x H\$Pt	AP H@A_HHLT$pM;}	HK 
MHO LT$0HOk L
B LDIH~ HDH0 HD$(LD$ LH
tN H	P HH@SH HH&M H
?N H  H	LLH [H%kP LI[IkVWATAUAVH03MMICICICH$   HMKH4MCISLIM   f     LHT$hHM   IH9   HAHHuHL HH9B   HB        MtiHH9tNH	L y'M H  HT$ht'HH; u8H9 tHD$ H+HI  HD$ HH+HIH;    HH;   HH9G  H	K yL Hf    HT$hHH;u   MtA HHHBH9AuBK HT$huHH; uHD$ HH+HIH; u`HH;t9@ HH9   HHBH9AuJ    HT$hHH;uM   LD$ IJ    LL$ LD$hHT$(ILK 3H\$`Hl$pH0A^A]A\_^H
K L$   H H	M HT$hHYJ HZ HGJ H H
YK L$   LH	M {LD$HT$HL$H(HtHLD$@HT$8HL$0HJ E3HtH;tHLD$@HL$0HJ LL$8Mt=L;t8I HL$@H^I H9AtH
J H" H	L    HL$0LL$@HA         LD$@HT$8HL$0I HI LD$@HT$8LHD$0H\$HIIHIYXH|$ IyPIAHMAXIQPHt
HuHAP0HtHu
HGHP0H|$ HtHu
HCHP0H\$HH(L9L$8tH
I Ht H	K EHL$8HAHD$0H HYH HHL$0SH ,H
I He H	K HD$8HtHHL$8H9 uHAP0HD$0HtHHL$0H9 uHAP0HD$@HJHHL$@H9 8HAP0H(H\$Ht$WH03AHLD$XHT$ E3HHD$XHD$ AH t:D  HD$XHH   rs]LD$XHT$ E3HH u˅ukHL$XHtaOG H
hH H	H LLJ 3H\$@Ht$HH0_H
9H HZ LH	nJ 3H\$@Ht$HH0_H\$@Ht$H   H0_@SH HHu3H [H|$0wF HHu
HSHR0HH|$0H [Ht$WH 3HHLAtHALEt]L;VϋMuHHH\$01G HHtHHE HHu
HSHR0HH\$0Ht$8H _JDHt$8H H _H\$Hl$Ht$WH 3HHE   HAH;HE    H;CE uDHDƋAEDuHQ9t$PtH;W΋H   HD   HhhH   H9u   EtGHyBHE Ht9HxHHHU   H
LF H	D u3   D HHUsHҋ΋EuHW9t$PtJH;W΋Hu5HE HHtHHWD HHu
HSHR0HHGHH H\$0Hl$8Ht$@H _H;uHC H HC HAH;nD uD9AtHC H HC H;C u0LIIHH3H+HMt
AIu3A;uH;lC uAfAnf.zulA   H%JC H\$Hl$Ht$H|$ ATH`HB 3LH9AP  HiHC  HYHC H9C   HC LcHs Hl$PHkHT$XHAHC HHC 9J~H
 C    }Cu!Hu}uDFHT$PMHLHS(Ht
HNHFHHHT$HL$@HD$8|$0LL$PE3IHH|$(D$    ;C HH9C HIa   C HHtNHE HhI$L` HE3HHHHu
HVHR0HuHSHR0HL\$`HI[IkIs I{(IA\H\$WH HAIL   MtAH@@HtH C HHt,HHHHu
HCHP0HH\$0H _3H\$0H _H(H
A H9AuSLI LYE3EIHL;AM;AEtHHAJICHA3H(pB y,H(LHқ 
HHtH uH@P03H(HA`HHAhI HApIHHtH I HtH IHtH H\$WH LQ`HyhHYpHQ`LAhLIpMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _LI[IkVWATH0HAHE3IICHAPHICHAXHLaXLaHLaPIKMCISICI? L9fHtlHD$ Le L'L#HtHHL$ L9!uHAP0HD$(HtHHL$(L9!uHAP0HD$PHtHHL$PL9!uHAP0   HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHM LHHV`H~hH^pHN`LFhHFpHtHu
HBHP0HtHu
HGHP0HtHu
HCHP03H\$XHl$`H0A\_^H\$Hl$VWATAVAWH@3LH
 HAELL   HHMtHC AH+H@@HtH+ H HH k? HH   Mu3B= HHtwLH
x Ll$p-= LHtU'= HHtGA= LHt6Hl$0HD$(LMIHLt$ < I$HuIT$IR0Ll$pHu
HVHR0HtHu
HCHP0HtHu
HGHP0H\$xHH$   H@A_A^A\_^H\$WH HAHL   MtAH@@HtH 7> HHu/H
@ H	w< tH
? LG HA H	@ HH\$0H _H\$Hl$Ht$WATAUAVAWH LaHLiPLqXE3HLyHLyPLyXH
m o; H HtHr< HfH
F HAL   MtAL@@Mt	H AI= HHt@H; H=Q; HE=O; Hu
HCHP0HtH: AE$[; L; He H
 A: HNHH~PH^XLfHLnPLvXHt
HuHAP0HtHu
HGHP0HtHu
HSHR0H\$PHt$`Hl$XH A_A^A]A\_H\$E3DRHEExIcHD;D~H\$E~.AA+Ù+EIcHLD;}E~#EYE;|IcHD;DA~AAH\$H\$A@WH Dt;H= Ht/ HI; }HHD9Du
HH H _3H _̅Q  H\$Hl$ WH H HHuH   9 H  hH8HHt f @   X    H\$@Hl$HH _Ht$05= DHˋLd$8LcD;}*IH9luHH<H   HAP0    ;u.p@HHcHd8 HHt\5Җ 5Ȗ Hɖ LcIM;~(MILL+IAIIIAIAIAuHƉlH<H5x Ht$0Ld$8H\$@Hl$HH _H\$Hl$Ht$WHpHIA8 HHtAtL H
 DHu7 	Hj8 HHu(Hu
HCHP03L\$pI[IkIs I_Hs H
 E3HL$hl$`H|$XH\$PHD$HHD$@HD$8HD$0HD$(HL$ E3338 HHu
HSHR0Hu
HWHR0HpHl$H|$ ATAUAVH H-8 MAL LtItDADH\$@Ht$HEt6H5 Ht*є H΋;}HcHD9Du	HH,MDŋIUHHthtHЋL2 E3HI7 HHtHȉh|5 HtHu
HCHP0HtHu
HGHP0Ht$HH\$@Hl$PH|$XH A^A]A\H(5 H(H(F5 H(H(~5 H(H(^5 H(H(>5 H(H(5 H(H(4 H(H(4 H(Htfff     H   H;tHu3H;>6 ø   H;tMLX  Mt#MH3M~IHH9t-HHI;|3H   H;tHu3H;5 ø   @SVH(Hj5 Hl$@H|$HH(Ld$PLl$XLeHLmPLt$ LuXHEH    HEP    HEX    IHHti3 uHy4 uHHG3 uHW4 3HMHH}PH]XLeHLd$PLmPLl$XLuXLt$ Hl$@Ht
HuHAP0HtHu
HGHP0H|$HHtHu
HCHP0H(^[H;u   HAH;2 t      t
   rH%{2 L3H\$WH IHH;t\I;tWHAH;32 t;      t
   r%2 u*HH
2 uH\$0H _H\$0H _/   H\$0H _Ht$WH HH
, 5 HHuHt$8H _H HWHH\$05 HH   HH      uH
3 LGH H	5 %HG H9C t-H
l3 LGH H	5 Hu
HCHP03Hu
HFHP0Ht$8HH\$0H _H
D5 H	1 t1 H0 xHWLH0 xHHH\$IMLI HHI`LZhLRpHB`IHBhHHBpIMLH\$@SUVH LQHHYPLYX3HHLT$XH\$@L\$PHAHHAPHAXMuVMtIHL$PH9uHAP0H\$@HtHHL$@H9 uHAP0H1 H H1 H3H ^][L3 M;   HuH1 H H1 L\$PLT$XqHK   sSH{|	H[HH1 H H}1 HD$@HHL$@H9 uHAP0L\$PLT$XL\$PLT$XI   H   MtIHL$PH9 uHAP0LT$XI
HL$XH9 uHAP0H3H ^][M M;tbIBH;. t%      tA   rII. 
3Iu"LL$PLD$@HT$XHH ^][LD$PHT$@HL$X:/ Hs2 HL$@HH9AtHIH(/ tHD$PH|$HHtHHL$PH9 uHAP0HD$XHHL$XH9 uHAP0HL$@HAL   MtH AH,L@@MtH H AHH 0 HHD$@HHL$@H9 uHAP0Ht#3H1 HHu
HSHR0Hu!E3E33HLe/ IH=[/ H>H|$H3H ^][H\$WH HQ Hy(HY03HA HA(HA0HtHu
HBHP0HtHu
HGHP0HtHu
HCHP0H\$0H _H
. H H	H%0 H
. H H	H%0 H(HtH
x0 H	g0 H(H\$VH AhHHمu2Ht-H;-. t$H
<. H H	D0 3H\$8H ^Ãu"HtH
/ H	/ 3H\$8H ^Hy  H|- H|$0H8tSHA0HtHHHGHtH HGHAHC LG`HWhHOpHG`HC(HGhHC0HGpLC HS(HK0A2HG`HC HGhHC(HGpHC0HC HtH HC(HtH HC0HtH LHHClSH|$0Cl H\$8H ^@SH HH   H, HH9ZHuwH. Ht$0H|$8L 3I HJHHrPHzXLBHHBPHBXHt
HuHAP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$8HH [H\$WH 3HHIHHD$0HtHGHHuHAP0H
+ HT$0H	H\$0E3HHHHtHu
HSHR0HH\$8H _@SH HHIH{l tH
+ H H	- 3H [HtYClHAH;" u H;j+ u   LH QCl Hu.HHHH [0E3HHHH [H\$Hl$Ht$ ATH H 3HLH9BuH  HH      AlHBH|$0L   MtH HAH2L@@MtH HH AHH H* HHu%H
, H	( u	HQ) ( '3H, HHu
HGHP0HDH|$0AD$l HtHu
HSHR0H\$8Hl$@Ht$HH A\@SH HHIH{l tH
) H H	+ 3H [Ht4ClHAH;" u   Cl HuHH [HN) E3HH [H\$WH yl HYHHt$H
2) H H	2+ 3H\$8H _HtIHHHt$0HOHHtHGH    HuHQR0Hu
HCHP0Ht$0uH
* H	* 3HDB9Ht4H u
HPHR0H
* H H	* 3H\$8H _R( Ht*LF* H'* HM H& H( H\$8H H( H _LL$ LD$SUWH0yl HYHHHt!H
' H H	) 3H0_][Ht$PH   HH) t$xL I;t?HBH;g% t$      t
   rIHK% 
3Ht|txHH<Hu
HSHR0HOHHtHGH    HuHAP0xLD$hHT$`E3HE33HHHHt$PH0_][GlHCH;h u+HD$pLL$hLD$`HHˉt$(HD$ H  L   MtH HAH2L@@MtH HH AHH߁ H& HHucHu
HCHP0H
g( H	$ uHt$PGl3H0_][$ HOHHtHGH    HuHAP0Gl HT$pHtH' H"LL$hLD$`HHHD$     $ HHu
HFHP0Gl Hu
HCHP0HuH HHLI[WHP3HA   IC ICICICIC HICICEAH HIC& u
3H\$`HP_LL$pLD$xHT$@HD$(   H\$ H\$`HP_H\$Ht$WH HHIIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _H\$WH HHI3HtH{HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP03H\$0H _@SH H" H{8 t	H$ {h |&H" L[HAx  H; H" HH|$ H [@SH yh H   H   H" Hl$0Ht$8H03HnHH|$@H~PLd$HLfXHFHHFPHFX9AhuHt0HHu)" HtH+! 
H uH@P0MLHHHHLd$HH|$@Ht$8Hl$0tHH [HAPHHD! H H(LHt2HB   s$HIPHIPPHt
HuHAP03H(H
s! H H	{# H(HAXHHD!! H H(LHt2HB   s$HIXHIPXHt
HuHAP03H(H
  HD H	" H(@SH HHQLAMtI 3Al AhHA@HAHHA HA(HA0HA8HD$PHtH HAXMtIHD$XLIPHtH HA`  HH [H\$Ht$WH0HHU HH   L H H!    L{| H Hs!    H LHX! xpLMz H~ H=! xULLú  HHD$     $! Ht3H u
HPHR0HuiHCHP0HH\$@Ht$HH0_Hu
HCHP0H3 H
  H H	A     yHu
HGHP03H\$@Ht$HHH0_H H(=}     H
  Hu13 H
.  H? H	A      y6H(Hu HK}    HHtH uH@P0H
/ q Ht+H5 HHtH uHPHR03H( 3H(H(HU H
 H' HH Ha H5z HH(H  A   L` H$  AQD$      LM H$  LȺ    D$  D8$  u$  8$  u
3H  H$  L$  L* HD$(Hޚ HL$0   HD$ I HT$0A   3n H  @SH  HHuH [HH|$0 HHu
HSHR0HH|$0H [H\$Hl$Ht$H|$ ATAUAVH  EILL HH<  H HHu
HWHR0H  I HH   HH HHu
HVHR0Hu
HSHR0H   HG      uH
 H MH	M |HG EuGH;vEHl$0HD$(L HL$@Mͺ   Ld$  HT$@E33 x1HMH;tH
$ H MH	MHl$(HD$ D HuHGH
Hu
HCHP03L$  I[ Ik(Is0I{8IA^A]A\@SH H9 Hte{  HKtHSE3H {" t 
HSH HHHH9 t&H	 u H(H; u3H [ÃH [H\$WH HH< HHIH;t6 u,HT$0LH HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _H(E3H;
 AH;
U AH;
 AAu H(@SH0HAHH
$ L@H	LLD$ LHc M Hu
HCHP03H0[@SH HA3ۋ         H@`H|$0HtbH   HtH=I HH   Ht<H= HHt+HC   r=r7HHH|$0H [
, HuH
0 H H	8 HH|$0H [HHH [H(HAH; u	HcAH(H;?    LAIHH3H+HMtA3I   HH(IIw;HB  HAIHHH(ËAIHHHH(H(H%f H\$0c HHuHH\$0H(HH|$ G HHu
HSHR0H\$0HH|$ H(f    j        X      HT$tHHHD$LD$HكH;HL$IMH HT$tHHHD$LD$HكH;HL$ICH H1 H+" HH\$Ht$WH`H )|$@3D)D$0D)L$ HHD
$ 8HA H+AHfAWHtTH;r HOH@f/v#HG H+HH;rz HOHxHG HH+HH;rHO fEWH+OHH   )t$Pfff     HY 0H;r H_fAWH@f.zt1HG H+HH;r H_H@\	 DXHO HH+HH;r(t$PfA(	 H\$pHt$xD(D$0D(L$ X(|$@H`_LD$HL$WH0HD$ H\$XIHD$H    H+ HHQHIR D$H   H8 HH\$XH0_H\$Ht$WH L   HIL+   IgfffffffHIIHHH?HH;r2H\$0Ht$8H _H   IH+   HHHH?HH;r H   HHH H\$0Ht$8H _HL$WH0HD$ H\$HIMHLAHy rLYLYE3AHAMtHyIHHIHMyMM;MOL+M33% H6LHD$hHtLD$`IIHLL$`LII HH HH\$HH0_H(HB   s'HAL   MtAL@@Mt	H A Hu9L
 D@`H
E _
  h `   n _
  L
:h e3H(HT$HL$SVWAUH8Li3339Yht3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'H ph i   n 
  Hg    LHu'H ;h i   m 
  Hg a  IEHHHuEH
 LE Hk H	 Lk g i   L:g m 
    HAH; tyH; tpH HHu'H
 g i   Hm 
  H
f   H@L   Mu2H cg i   m 
  Hf   H3HE3LdD  MuFH H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AH H	 HHtdHu
HSHR0IULI3F uHu
HGHP03H f i   k *  HIe (  H] e i   k '  H"e   H
 L;C H H	/ L e i   Ld =k $      HtH HHty1
 Hu
HFHP0H\$`HL$hLK0LC(HS HHC0    HC(    HC     ChLt$(Ld$0Hl$pIL|$ H8A]_^[HW d i   j   Hd MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
c D_d j H
A HHHATAUH8HXHhHp HxE3LpLxHBLMIH; t|H; tsHH2 HHu'HK c m   wi   Hc   H@L   Mu3H c m   @i   Hb   HHIMHl MuFH H9GuH;w  HGHH\HH,H;w   H] HHHHAHH   ILHt
HuHQR0HI
 HHtVHL$PLI.
 tHWHCHP0HH! b n   Mh 	  Ha    H xb n   &h   Ha     HtH
 HHtb
 Hu
HGHP0L-L IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\HP a m   |g   Ha Hu
HGHP0HtHu
HCHP0L
` Da <g H
u?  SH\$Hl$Ht$WH H` HH
	 E333HHu'H a q   f S  He` a  HCH]f HL   MtAL@@Mt	H AI
 HHuwf U     HC H9C&  H{H  HsHHHHHuHAP0HH\HHuH
 f b  H
_ QHu
HGHP03Hu
HCHP0    HH   e i  H HY_ HE _ q   u
HEHP0HtHu
HFHP0HtHu
HCHP0HtHu
HWHR0L
^ D_ Ke H
= 3cH賴HH/e e  QH
ae HHHHh Hp(H
k HH
a HH0H
V HH
L HH8H\$0Hl$8Ht$@H _H(IL$0g Hu9L
S D@PH
=   ^ P   od   L
^ 33H(H(y tH H H H H H
 Hu9L
 D@QH
=   D^ Q   c   L
] 3H(H\$WH E3H; HAE3H; A3H; DEuHB DEÀuR HtGL
* H
= 
  AQ   ] Q   Dc 
  L
\ H\$0H _È_H\$03H _HAH HAH\$WH LJHHL;
 trH;< tiH
K MIL: H	H.= x L
a H
:= c
  AR   L
(\ \ R   tb c
  ?H\$0H _HHAHHIH9 uHAP0H_H\$03H _@SH H HH HAHHIH9 uHAP0L^ 3L[H [HK HC3H [HA H HA H\$WH LJHHL;
 trH; tiH
 MIL : H	H^< ( L
 H
j< 
  AS   L
Z v[ S   $a 
  H\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH H3 HH HA HHI H9 uHAP0L 3L[ H [H HC 3H [H(A( Hu9L
 D@TH
;   Z T   1`   L
Y 3H(@SH0H )t$ HH9Bur
Hm f(f.5A zTuRG HtGL
 H
; <  AT   Y T   _ <  L
6Y a(t$ H0[s((t$ 3H0[HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH HC HH HA0HHI0H9 uHAP0L 3L[0H [H HC03H [HA8H HA8H\$WH LJHHL;
 trH; tiH
 MILd: H	Hf:  L
Ѻ H
z:   AV   L
W 6X V   ]   H\$0H _HHA8HHI8H9 uHAP0H_8H\$03H _@SH H  HH HA8HHI8H9 uHAP0L  3L[8H [H  HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH H  HH HA@HHI@H9 uHAP0L
 3L[@H [H
 HC@3H [H(AH  Hu9L
 D@XH
8   cV X   \   L
U 3H(@SH0H
 )t$ HH9Bur
HM  f(f.5! zTuR'
 HtGL
c H
8   AX   U X   }[   L
U A(t$ H0[sH(t$ 3H0[HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH H#
 HH HAPHHIPH9 uHAP0L
 3L[PH [H
 HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH HC
 HH HAXHHIXH9 uHAP0L
 3L[XH [H
 HCX3H [HA`H HA`H\$WH LJHHL;
M
 trH;
 tiH
 MIL5 H	H6 
 L
ѵ H
6   A[   L
R 6S [   X   H\$0H _HHA`HHI`H9 uHAP0H_`H\$03H _@SH H
 HH HA`HHI`H9 uHAP0L
 3L[`H [H
 HC`3H [H\$Ht$WH H5R H
U HH
 HHtH H2HHu'H !R m  W    HhQ    H
 H9CuHH 
 HHuH
Y W    H
(Q .E3HH蘣HHuyH) _W    HP HQ m  u
HGHP0HtHu
HCHP0L
P DcQ W H
@ 3H\$0Ht$8H _Hu
HWHR0Hu
HSHR0H\$0HHt$8H _H\$Hl$Ht$ WATAUH@3MHHH\$pM   LjIMtH   HZH\$pI?
 HMu HT I
 HHD$pHtPHH   HA LL$pH HD$(E3ILl$ ny$  YH\$p   Hzt}HGH
_
 L
j H	HD$0H HD$(LMA Hj HD$    o
 $  L
S H
<A A  U O   L
O :%HZHHEHHMH9 uHAP0H]3H\$`Hl$hHt$xH@A]A\_HT$HL$SVWAUH8Li3339Yht3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'H O   T {%  HWN   l
 LHu'H] N   T |%  H"N a  IEHHHuEH
 L@ Hh H	"
 L N   LM 0T ~%    HAH;(
 tyH;'
 tpH
 HHu'H
 :N   S %  H
M   H@L   Mu2H N   S %  HJM   H3HE3LdD  MuFH
 H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AH{
 H	p
 HHtdHu
HSHR0IULI3
 uHu
HGHP03H$ L   PR %  HK (  H {L   )R %  HK   H
F
 L> He H	
 L 6L   LK Q %     J
 HtH>
 HHkty
 Hu
HFHP0H\$`HL$hLK0LC(HS VHHC0    HC(    HC     ChLt$(Ld$0Hl$pIL|$ H8A]_^[H uK   #Q %  HJ MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
^J DJ P H
:= uHHHATAUH8HXHhHp HxE3LpLxHBLMIH;Z
 t|H;Y
 tsHH
 HHu'H iJ   P `&  HI   H@L   Mu3H 2J   O b&  HyI   HHIMHl MuFH
 H9GuH;w  HGHH\HH,H;w   H] HHHHAHH   ILHt
HuHQR0HIg
 HHtVHL$PLI
 tHWHCHP0HH ?I   N &  HH    H I   N &  H_H    ,
 HtH 
 HHMtb
 Hu
HGHP0L-
 IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\H nH   N }&  HG Hu
HGHP0HtHu
HCHP0L
G D*H M H
: 蠸SATAVHHHE H\$`Ht$pH H55J L5D H|$@L|$0LH
BK E3HI#
 HHtH H螕HHl$hLl$8Hu'H G   1M &  HF 9  HCL   MtHC HAH2L@@MtHC HH AHHC H
 HHu'H G   L &  HJF z  Hu
HCHP0Hf
 LnII9E   H^H  HnHHHE HHuHAP0H
 LmI9E    E3HT$ HEAH\$ Lt$(HHu'HШ NF   K &  HE   Hu
HCHP0IHu
IE HP0HE Iu
HEHP0   
 HH  H[ E   K '  H E :     p
 HHu'H
! E   MK '  H
D   HXIE3HHLp IEHHu'H֧ TE   K 
'  HD   Hu
HGHP0IIHHHH D   J &  HED _  IGH IGHEIGL   MtH"J IAH1H@@HtHJ IH HHI I
 HHu'H pD   J "'  HC    H
 IH9G4  H_H'  HwHHHHHuHAP0HHHHu$Hz C   I /'  H?C \Hu
HCHP0IHu
HGHP0   o
 HH   H C   HI 6'  HB HtHE u
HEHP0HtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L
B D&C H H
16 蜳~HBHH,Ho B   H 2'  H4B NHH LH HGHo Hw(H
 H H
 HG0H
 H H
 HG8L|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@VWAUH0HA3LL   MtHF AH,L@@MtHF H AHHF j
 HH\$PHl$XLd$`Hu'HL A    xG 2)  HA   H=
 Lg3I9$c  H_HV  HoHHHE HHuHAP0H
 LeI9$   E3HT$ HEAH\$ Ll$(אHHu'H &A    F E)  Hm@   Hu
HCHP0Hu
I$HR0HLd$`Hl$XH\$PH0A]_^ù   
 HHu'H
3 @    _F S)  H
?    HXIE E3HHLh 3WHHu$H f@    F Y)  H? RHIHFHP0:IHHH#H @    E ?)  HY? Hu
I$HP0HtHu
HCHP0HtHu
HVHR0L
? D? kE H
4 /3H\$VWAUH0H=C LH
B H3
 HHtH HRHHl$PLd$XHu'H 7? Q  D =0  H~>   HCHkL   MtHN< HAH2L@@MtH3< HH AHH< HD
 HHu'H5 > Q  aD ?0  H= T  Hu
HE HP0HGL   MtHf@ HAH2L@@MtHK@ HH AHH5@ H
 HHu'H #> Q  C B0  Hj=   Hu
HGHP0H
 Hk3H9E d  H{HW  LcHHI$HIuHAP0H4
 Il$H9E    E3HT$ IEAH|$ Ll$(LHu'H n= Q  C V0  H<   Hu
HGHP0Hu
HU HR0ILd$XHl$PH\$`H0A]_^ù   
 HHu'H
{ < Q  B d0  H
@<    HxIE E3HILh 3蟎LHu$H0 < Q  \B j0  H; RHIHFHP0:IH_LH#Hܞ Z< Q  B P0  H; Hu
HE HP0HtHu
HGHP0HtHu
HVHR0L
`; D< A H
4 w3ATAVHHH\$`Ht$pH|$@H=
@ E3L|$0LH
 ? HMI
 HHtH H|HHl$hLl$8Hu'H a; T  A 0  H: G  HCL   MtH|8 HAH2L@@MtHa8 HH AHHK8 Hr
 HHu'Hc : T  @ 0  H(:   Hu
HCHP0HGL   MtH< HAH2L@@MtHy< HH AHHc< H
 HHu'HӜ Q: T  ? 0  H9 
  Hu
HGHP0H
 LkII9E   H{H  HkHHHE HHuHAP0Ha
 LmI9E    E3HT$ HEAH|$ L|$(MHHu'H 9 T  J? 0  H8 H  Hu
HGHP0IHu
IE HP0H
,6 L|HH  H 79 U  > 0  H~8      
 HHu'H
 8 T  > 0  H
D8   HxIE3HHLx I裊HHu'H4 8 T  `> 0  H7 ^  Hu
HFHP0IIHaHHHޚ \8 T  
> 0  H7   HDy'H &8 U  = 0  Hm7    Hu
HCHP0E*  HEL   MtH9 HAH2L@@MtH9 HH AHH9 H
 HHu$H 7 U  ;= 0  H6 LH: E3H@HHu~Hљ O7 U  < 0  H6 Hu
HCHP0HtHu
HGHP0HtHu
HFHP0L
U6 D6 < H
10 lHu
HCHP0HHE LL|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@SH HAL   MtH8 AH,L@@MtH7 H AHH7 
 HHt$0H|$8Hu'H 6 X  ; ?1  HN5   Hz
 3H9C   H{H   HsHHHHHuHAP0HH葉HHu$H 5 X  >; L1  H4 eHu
HGHP0Hu
HSHR0HH|$8Ht$0H [HzHHuH )5 X  : O1  Hp4 HtHu
HCHP0HtHu
HWHR0L
?4 D4 : H
{. VH|$8Ht$03H [@UATH(HAH\$@E3L   Ht$HLl$ LIIMtH^1 AH,L@@MtHF1 H AHH31 
 HH|$PHu'H 4 [  9 1  Hf3   {
 HHu'Hl 3 [  9 1  H13       
 HHu'H
2 3 [  ^9 1  H
2    IE LhH5 LH
 y$H j3 [  9 1  H2 LHu
HCHP0H2 LH
HHuIH 3 [  8 1  Hc2 Hu
HFHP0HtkHueHGHP0YHu
HFHP0Hu
HGHP0IHH
 HHuYH 2 \  J8 1  H1 HtHu
HCHP0L
1 Dh2 8 H
c, ޢLLl$ H|$PHt$HH\$@HtHE u
HUHR0IH(A\]H\$Ht$H|$ ATAUAVH@H=86 LH
V5 LHM35
 HHtH HHHl$`Hu'H 1 _  H7 &2  H0   HCL   MtH. HAH2L@@MtH. HH AHH. H
 HHu'H 1 _  6 (2  Ha0   Hu
HCHP0HGL   MtHm- HAH2L@@MtHR- HH AHH<- H
 HHu'H 0 _  86 +2  H/   Hu
HGHP0H
 33H9Cu+H{Ht"HCHHH HHuHAP0   H
 H9C   HcHT$(DEHE3HH+H|$ Lt$(Ll$0Ld$8}HHu'HN / _  z5 =2  H/    H#  H  HGHP0
  EHc@
 HHu$H
 o/ _  5 K2  H
. dHtHx3IHcE3LtIE Ll I$HHLd(HH   H 	/ _  4 Y2  HP. Hu
HCHP0HtHu
HGHP0HtHu
HVHR0L
. D. b4 H
k) &3#Hu
HVHR0Hu
HSHR0HHl$`H\$hHt$pH|$xH@A^A]A\AVAWH8HAE3H\$PL   Hl$XHMMtH, AH,L@@MtH, H AHH, ]
 HHt$`H|$0Ld$(Ll$ Hu'H: -   f3 o4  H, ]  H+
 IH9C   H{H   HsHHHHHuHAP0HHAHHu'H
 @-   2 |4  H
,   Hu
HGHP0IHu
HCHP0HIu
HFHP03T
 HHu^HU ,   2 4  H, 9  HHHuH ,   J2 4  H+   HM H;
 u>H
 HS) H	
 Lӎ Q,   L+ 1 4    H) 
 HHu'H ,   1 4  H\+ {  H@H;
 t|H;
 tsHH,
 HHu'HE +   q1 4  H
+ )  H@L   Mu3H +   :1 4  H*   HHIMHu
HCHP0LdMuFH	
 H9GuH;o.  HGHH\HI,H;o  I$HHIHAHH   ILHt
HuHAP0H) H
 HHtoHNH9N ~H HFHHAHFHH
 uH:HCHP0+H o*   0 4  H)    Hʌ H*   / 4  H)    \
 HtHP
 HH}tk
 Hu
HGHP0HHLu
HFHP0Ll$ Ld$(H|$0Ht$`Hl$XH\$PMtIu
IWIR0IH8A_A^H )   C/ 4  H( HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
( D7) . H
B& 譙;HHHATH   HXHpHxLhLpE3LxHALL   L$   ML$   Lt$ L$   IIMtHU' AH,L@@MtH=' H AHH*' 
 HH$   Hu'H݊ [(   	. 8  H' >  H
 IH9C   HkH   LcHE HI$HIuHAP0HI{LHu'Hc '   - 8  H(' U  HE u
HEHP0IHu
HCHP0I$uID$IP0IEL   MtFHv' IAcH|LHuH׉ U'   - 8  H&   L@@MtH'' IH AH' I
 Hu'H &   , 8  HD&   L%( H
Q* H$   I0
 HHtH ItHHu'H &   H, 8  H%   HCL   MtH# HAH2L@@MtH# HH AHH# H
 HHu'H &   + 8  Ha%   Hu
HCHP03T
 HHu'HU %   + 8  H% G  IM H;
 u>H
 H% H	
 L
 %   L$ /+ 8    H" E
 HHu'H
· L%   * 8  H
$   H@IH;
 t{H;
 trHM`
 HHu'H
y $   * 8  H
>$ k  H@L   Mu0HB $   n* 8  H$ 4  HHMHu
HGHP03NlfMuFH<
 H9FuL;f:  HFIJ|HI,L;f  I} IHIHAHH   H$   H$   Ht
HuHAP0H*& H
 HHtmHKH9K ~H HCH<HAHCHH6
 uHu
HGHP03#H #   H)  9  H"   H s#   !) 9  H" 
  
 Ht H{
 HH託   

 Hu
HFHP0H
 E3LmII9E x  HuHk  LeHHI$HIuHAP0HU
 Ml$I9E    E3HT$(IEAHt$(H\$0@rLHuNH "   =( 69  H! 
  H h"   ( 9  H!   Hu
HFHP0HI   HCHP0      
 HHu'H "   ' F9  HI! v  HpE3HIIHX sLHu'H< !   h' L9  H! K  Hu
HGHP0IJHHluLHu'H k!   ' /9  H    Hu
HCHP0HE u
IE HP0H
-# L$   HxHHu'H !   & \9  HN    H@L   MtHB HAH2L@@MtH' HH AHH H
 HHu'H	     5& ^9  H   HE u
HEHP03
 HHu'H ?    % a9  H 
  H$   HI H;
>
 u>H
M
 H&  H	U
 Ln    L= % e9  }
  H_ 
 HHu'H2    ^% g9  H $
  H@H;O
 txH;N
 toH
 HHu'H b   % m9  H 	  H@L   Mu3H +   $ o9  Hr 	  HHMMHu
HCHP0NdMuFH
 H9FuL;~<  HFIJ\HI,L;~  I$IHIHAHH   H$   H$   Ht
HuHAP0H&! HE
 HHtoHMH9M ~H HEHHAHEHH
 uH0HCHP0!H    # 9  HK x  H_    # 9  H$ Q  
 Ht H
 HH   t
 Hu
HFHP0H
 LoII9E x  HwHk  LgHHI$HIuHAP0H
 Ml$I9E    E3HT$8IEAHt$8Hl$@lLHuNH~    " 9  HC   HW    " 9  H I  Hu
HFHP0HE Iu
HEHP0I      @
 HHu'H~ o   " 9  H   HpHh E3HIIInLHu'H~ $   ! 9  Hk   HuZHCHP0NHHoLHu'HZ~    ! 9  H i  HE u
HEHP0IHu
IE HP0H
 Ld$ rHHu'H} t   "! 9  H   H@L   MtH7 HAH2L@@MtH HH AHH H
 HHu'Hv}      9  H;   Hu
HGHP0HW
 LkII9E   H{H  LcHHI$HIuHAP0H
 Ml$I9E    L$   E3HT$HEAIH|$HL|$PiLHu'H| 6    9  H}   Hu
HGHP0IHu
IE HP0IL$   MHuHAP0H
 D90  H$   
 HH  H(|    T 
:  H M     =
 HHu'H{ l    9  H   L$   HxE3IHILx I
kLHu'H{     9  H`   HE u
HEHP0IL$   HIlLHH<{    h 9  H .  I
 Hu'H{    2 :  H +  H;t7H
 H	
 Lz H   L  :    H
+ NoHHu'Hz 
    :  HT   H@L   MtH( HAH2L@@MtH
 HH AHH H
 HHu'Hz    ; :  H   Hu
HCHP0   ľ
 HHu'Hy C    ":  H   I$H@HL$ L HHCHHH
 LmII9E K  H}H>  LeHHI$HIuHAP0HH
 Ml$I9E uvE3HT$XIEAH|$XH\$`7fLHu'Hy    4 <:  H    Hu
HGHP0H  HCHP0u     
 HHu'Hx #    L:  Hj    HxE3HIIHX gLHu$H]x     R:  H" oH   HFHP0   HHiLH   H	x    5 5:  H HtHu
HCHP0E3E3HtHE u
HEHP0HtHu
HGHP0HtHu
HFHP0L$   L$   L
X D  H
4 oM(Hu
HCHP0HE u
IE HP0I$MH$   L$   H$   H$   H$   H$   Ht
HuHAP0MtIu
IGIP0HL$ L|$xHt
HuHAP0MtIu
IFIP0H$   L$   HtH u
HPHR0IHİ   A\H\$WH HYPHCH;
 u3H9CtIHCHHpH;
 u3H9Ct'H[HQHHhHtHAHt3HH33
 HHu3HHG
 HHu
HGHP0Hu?L
u A  ;  H
~ L
 D(  襃3H\$0H _H H
 HHucL
iu HA  ;  D L
,  uHSHR0L
 D f H
 *3H\$0H _Hu
HSHR0HH\$0H _HAHH HAHH(HIXH HAL   MtAL@@Mt	H A
 Hu;L
xt H
 (<  A      (<  L
+ V3H(HAXH HAXH\$Hl$Ht$H|$ ATAUAVH@H+ LHI@E3E33EE33uHHu'Hs >    F=  H /  E3H;
 A3H;
 3H;=-
 AuHb
 DEy    H=  !  Hu
HGHP0E  H H L- Hp IEIL   MtAL@@Mt	H A
 HHu'Hr W    ]=  H H  Hʷ
 LcI9$j  HsH]  H{HHHHHuHAP0H{
 LgI9$   IF(E3HT$ EAHHt$ HD$(c_HHu   g p=    Hu
HFHP03Hu
I$HP0   5
 HH   g    =       
 HHu'H
q 4    ~=  H
{   HpIF(E3H IF(HH3HE `HHu    =  *  HE u
HEHP03*IV(HbHH   N j=    H
 E3HHxS`HHui    =    Hu
HCHP0E3E33HRlHu
HGHP0Hp     =  H`
   H\
 IN@E3EAqHHu
    =    H{Dy
   ` =    Hu
HGHP0E   IN L
 I;uEH
۸
 L
 H H	
 Lo K
   L  =  <  H
 dHHu
    =  X  H;)
 H u
H@HP0E3AE  H
 H L-
 H
 IEIL   MtAL@@Mt	H A
 HHu'Hn {   ) =  H l  H
 LcI9$J  HkH=  H{HE HHHHuHAP0H
 LgI9$   IF(E3HT$0EAHHl$0HD$8[HHu =    HE u
HEHP03Hu
I$HP0   a
 HH   K =        ;
 HHu'Hm j    =  H
    HhIF(E3H IF(HH3HF 	]HHu =  cHu
HFHP03BIV(H^HH* =  (H
 E3HHx\HHucr =  
   H!m H	 HtHu
HGHP0HtHu
HCHP0HtdHu^HFHP0RHu
HCHP0E3E33HYhHu
HGHP0Hl  
    >  Hg	 HtHE u
HEHP0L
J	 D	  H
v azMtIE u
IUIR03
H
 H H\$`Hl$hHt$pH|$xH@A^A]A\H\$Ht$WATAUH@H	 LH
 LH3
 HHtH H9WHHl$`HHu'Hk  	 $   wA  Hg   H
 33H9Au%HYHtHqHHHuHAP0   HM
 H9F   IEHT$(DEHD$(HcE3HHH\$ H+Ld$0*XHHu'Hj y $  ' A  H    H"  H  HCHP0	  EHc
 HHu$H
j  $  
 A  H
c cHtHX3IEHcE3H IEHHDI$Ld HYHH   H9j  $  e
 A  H Hu
HFHP0HtHu
HCHP0HtHu
HWHR0L
 D^ 
 H
y
 w3#Hu
HWHR0Hu
HVHR0HHl$`H\$hHt$pH@A]A\_HAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH H
 HH HAHHIH9 uHAP0Ln
 3L[H [H[
 HC3H [HA H HA H\$WH LJHHL;

 trH;
 tiH

 MIL\
 H	H> 8
 L
!h H
J UB  A  L
    4 UB  uH\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH HC
 HH HA HHI H9 uHAP0L
 3L[ H [H
 HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH Hc
 HH HA(HHI(H9 uHAP0L>
 3L[(H [H+
 HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H
 HH HA0HHI0H9 uHAP0L^
 3L[0H [HK
 HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH H
 HH HA8HHI8H9 uHAP0L~
 3L[8H [Hk
 HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH Hê
 HH HA@HHI@H9 uHAP0L
 3L[@H [H
 HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH H
 HH HAHHHIHH9 uHAP0L
 3L[HH [H
 HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH H
 HH HAPHHIPH9 uHAP0Lި
 3L[PH [H˨
 HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH H#
 HH HAXHHIXH9 uHAP0L
 3L[XH [H
 HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH HC
 HH HA`HHI`H9 uHAP0L
 3L[`H [H
 HC`3H [H\$Hl$Ht$H|$ ATH H3
 HHu'H`  =   8 O  H   Le 3L+eIMz   D  HE H+EHH;rY
 HEz
 HHtqHFH9F ~HHNHHHHNHHo
 u6Hu
HCHP0HI;rHH\$0Hl$8Ht$@H|$HH A\s O  
g O  H0_ H =   H u
HFHP0HtHu
HSHR0L
 Dd  H
 l3kH(Hy HQrHIH
 Hu9L
^ D@2H
 tP   2    tP  L
: el3H(H\$Hl$Ht$H|$ ATAUAVH L3
 HHu'H^  =   4 P  H >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;r'
 IL$H:HH}   HGH9G ~HHOHHHHOHH;
 uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\3  P  
'  P  H\ HZ =   H u
HGHP0HtHu
HSHR0L
 D$  H
_ j3gHL$SWHXHD$ HHD$x    
 D$x   HKH5
 H;t9
 u/L$   H$   H
 x5H$   L$   LCL$   MtHS(H
 Hu>L
[ L
 D     Q  Q  A   H
 iH'HL$(S
 HHƝ
 HL$("
 HHX_[H\$Hl$VWATH H33
 HHu'HD[  =   ` T  H    Le 3L+eIMtxHE H+EHH;r
 HEL$H
 HHtiHFH9F ~HHNHHHHNHH
 u.Hu
HCHP0HI;rHH\$@Hl$PH A\_^ T  
 T  HfZ H =   H! u
HFHP0HtHu
HSHR0L
 D L H
} h3sH\$Hl$Ht$H|$ ATAUAVH L3
 HHu'HY 6 =    U  H} >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;rל
 IL$HHH}   HGH9G ~HHOHHHHOHH
 uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\ U  
 U  HX H
 =   H[ u
HGHP0HtHu
HSHR0L
3 D  H
? Jf3gHAH HAHA H HA HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _H(
 H HA0HHI0H9 uHAP0H
 HC0H\$03H _HA8H HA8HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _HX
 H HA@HHI@H9 uHAP0H6
 HC@H\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _H
 H HAPHHIPH9 uHAP0H
 HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _H
 H HAXHHIXH9 uHAP0H֛
 HCXH\$03H _HA`H HA`HAH HAH\$WH HHHt,HHAHHIH9 uHAP0H{3H\$0H _H(
 H HAHHIH9 uHAP0H
 HCH\$03H _HA H HA HA(H HA(H\$WH HHHt,HHA(HHI(H9 uHAP0H{(3H\$0H _HX
 H HA(HHI(H9 uHAP0H6
 HC(H\$03H _HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _H
 H HA0HHI0H9 uHAP0H
 HC0H\$03H _HA8H HA8H\$WH HHHt,HHA8HHI8H9 uHAP0H{83H\$0H _H
 H HA8HHI8H9 uHAP0H֘
 HC8H\$03H _HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _HH
 H HA@HHI@H9 uHAP0H&
 HC@H\$03H _HAHH HAHH\$WH HHHt,HHAHHHIHH9 uHAP0H{H3H\$0H _H
 H HAHHHIHH9 uHAP0Hv
 HCHH\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _H
 H HAPHHIPH9 uHAP0HƖ
 HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _H8
 H HAXHHIXH9 uHAP0H
 HCXH\$03H _HA`H HA`H\$WH HHHt,HHA`HHI`H9 uHAP0H{`3H\$0H _H
 H HA`HHI`H9 uHAP0Hf
 HC`H\$03H _H(H
  :H) Hu*HmN      Z  H2 H(H
 9H Hu*H+N  y  W Z  H H(H
A |9H Hu*HM g <   Z  H H(H
 :9H Hu*HM % D   Z  Hl H(H
- 8H! Hu*HeM     Z  H* H(H
s 8H_ Hu    V Z  ZH
 8H Huz 7  ( Z  ,H
? Z8H Hu*L    Z  HL H H(3H(@SH H=u  tuHu f     { HKtHE3Ho
 { ti
 HHc
 HKHHKH9 t?H	Q
 uv
 H(H{ u3
 H Hu- [  P! [  D   ܐ
 H
 Hu [  !   
 H Hu+ [  HK     Hc H [3H [H\$WH 3ALH;uAËH\$0H _H
 DH9AAH9BA   MAL;BtËH\$0H _B A8A uIuËH\$0H _AIB;t
tuII H j	 uËH\$0H _ÅËH\$0H _L/
 M;hI;ЋAWDI
 HHuH\$0H _HtwHu
HSHR0H\$0H _H\$UH HG
 H(H]HH   H
 L I;tMHCH;]
 t$      t
   rIHA
 
3HuZuH\$@H ]3Ht$0HuPH|$8H}XHEHHEPHEXHu
HCHP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$83H\$@H ]@SH HHt0HuHAP0H
 H  LH	ۑ
 H [H [H\$Hl$Ht$H|$ ATAUAVH ILAHIhhLH  H}  	  39\$pu3Mt+I	H;

 twHHu
 H  H9\$xu?HD$`Ht+HH;
Ȏ
 tvHHu
 H  
H9$   toHˋHt[HE HtRIHx*HyHHHHy7Hy2LHIHU i  H
t
 H	ی
 O  Ռ
 LHIU :  MhpM  I}   Ld$hMt	I<$   3HMtI9'9\$ptH
 HHH   H=
 HD$`HtH @9l$xt3H
 HHu)H   H   HCHP0   Hd
 L]
 HH!
 HHtHu
HSHR0HtHE u
HEHP0HtBHIAUHMuHu
HWHR0HH

 M@H  H	<
 3H\$@Hl$HHt$PH|$XH A^A]A\H8MLHuH

 HS  H	
 3H8Et)H;_
 u-HAH;
 t	H;
 u   H8HIVuIBLJH  HHMHL$ H
>
 H	}
 3H8H\$Hl$Ht$WH Hj3HH~WHrLI;tbHCH;
 t$      t
   rIH
 
3HUu#HHH;|3H\$0Hl$8Ht$@H _ø   HIHH;u   Hu3HB   s6HAH;#
 t      t
   rH%
 L3BUH(HA   sAH(sEHAHHw,H	x H3H(ËAH(ËAH(H(H%y
 H\$0qHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f   
      H(HA   sAx&H(sTHQHHtAHt3HHyH
 
 H
 H	
 H(H(H%}
 AH(3H(H\$0pHHu
H\$0H(HH|$ ZHu
HSHR0H\$0H|$ H(H(HA   sAH(sEHAHHw,HI8 H3H(ËAH(ËAH(H(H%
 H\$0pHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f
 
 
 
 
 
 
 
 
 H(HA   sAH(sEHAHHw,HY( H3H(ËAH(ËAH(H(H%Ɉ
 H\$0oHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAH(sEHAHHw,Hi H3H(ËAH(ËAH(H(H%ه
 H\$0/nHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAH(sEHAHHw,Hy H3H(ËAH(ËAH(H(H%
 H\$0?mHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%
 H\$0OlHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   s
HcAx(H(siHQHHtVHtHHt0Hy H
}
 H&
 H	e
 HH(H(H%
 AIHHH(ËAH(3H(H\$06kHHuHH\$0H(HH|$ CHHu
HSHR0H\$0HH|$ H(H\$Ht$WH0IIHJ
 HHuH\$@Ht$HH0_HD$hLLHD$(HD$`HHD$ bH\$@Ht$HH0_33333333AVHPHD$ H\$`Hl$hHt$pH|$x)t$@AAfnf(
\	 [	 D,G  l+;ttC-  H$   H$   H}
 H
 Hy IcHL$(+|
 L3HuH
HHcHHISAH|
 HHZ
 1 Hȋ|
    HL$({
 LH
 H HHt
H HcxHIVHAfnY-أ ^,H/|
 HHA
 踧 HA
 HJ
 $    HEH薧 H$   H|
 HF{
 H|
 H$   }
 H$   H\$`Hl$hHt$pH|$x(t$@HPA^H%|
 H(H
   H1|
 HH(H%+|
 @SH H
 H H\
 Hܦ H
 Hͦ HN H{
 H{
 H{
 H
 H螦 H'
 H菦 HT
 H耦 HY H{
 H{
 H{
 HU
 HQ H
 HB H
 H3 Hl H3{
 H4{
 HH [H%-{
 HtzH\$Ht$WH HH
 AHץ HHz
 DD+^A}Hz
 Hz
 D[E~Af Hƣ HuH\$0Ht$8H _H%  WHPHD$ H\$`Hl$hHt$pIIH   D4HH8z
 HH6z
 8z
 H}    H
 HL$({z
 H
 H HHT$(y
 +\$@}Hy
 Hy
    ~ H HuHL$(@z
 H]
 H葤 HHy
 HH;
 v HHy
 y
 Hwy
 Hvy
 H\$`Hl$hHt$pHP_HWHP  HD$ HXHhHpIIHH   DBHL$Px
 H
 HL$`ޣ HHx
 H v,H
 HL$`躣 HHx
 HHt
 蟣 HT$(HL$Pox
 L$  LHHHL$(y
 HL$PHx
 L$P  I[IkIs I_HWH   HǄ$  HXHpH   DBHw
 HHPHHҟ
 H$0   HȋBw
 HH
 ˢ HH H$   H$   w
 H豁    H
 H$   x
 A   HV5 HL$`Ky
 L< L\$`L H$   HL$ w
 HL$   H$   w
 HLځ HL$xow
 H$   w
 HL$ w
 H'
 HL$`U	 H4    H
 HL$ Jw
 HJ} HL$`gx
 L L\$`Ld H$   H$   v
 HLD$ H$   v
 HL& HL$xv
 H$   v
 H$   v
 HP
 HL$`JT	 H轀    H>
 HL$ v
 H# H$0  H$0  HL$`w
 L L\$`L H$   H$   v
 HLD$ H$   v
 HL_ HL$xu
 H$   .v
 H$    v
 Hi
 HL$`S	 H6    H
 HL$ u
 H HL$`v
 Lb L\$`L H$   H$   hu
 HLD$ H$   Zu
 HL HL$x=u
 H$   wu
 H$   iu
 H
 HL$`R	 H tJHL$ pv
 Hx HD$ H$   HL$8(u
 Hx HD$ H
 HL$ vR	 H tJHL$ v
 HZx HD$ H$   HL$8t
 Hjx HD$ H6
 HL$  R	 H tJHL$ u
 Hx HD$ H$   HL$8|t
 H,x HD$ H
 HL$ Q	 H} tJHL$ nu
 Hw HD$ H$   HL$8&t
 Hw HD$ H
 HL$ tQ	 Hg t>HL$`u
 HXw HD$`H$   HL$xs
 H
 HL$`*Q	 H] tJHL$ t
 Hw HD$ H$   HL$8s
 Hw HD$ Hz
 HL$ P	 HG tJHL$ xt
 H`w HD$ H$   HL$80s
 Hw HD$ H
 HL$ ~P	 H1 tJHL$ "t
 H
w HD$ H$   HL$8r
 Hw HD$ H
 HL$ (P	 H t>HL$`s
 Hv HD$`H$   HL$xr
 H
 HL$`O	 H
 HL$ 7r
 HL$`{s
 L| L\$`LX| H$   H$   q
 HLD$ H$   q
 HL| HL$xq
 H$   q
 H$   q
 H
 HL$`>O	 ;cH\$Hl$Ht$H|$ ATH H HH
} E3-
HHuHnu
 
  H   H
 HxHH5 L%
 H-  v
 HHtwH9cH_HGH3GhHG@HGHHG HG(HG0HG8Gl MtI$LgXHtHE HoPHtHHHw`t
 Hu
HCHP0HG
  L
- H
 Ai   * h i   L
 ;Hu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH H H\$0HH
 E3Ht$8H|$@	E3HHu2H-t
  f    V  HE H<- H   HXHH
 HAL   MtH AH,L@@MtH H AHH s
 HHu'H, I h    e  H   Hq
 IH9C   H{H   HsHHHHHuHAP0HHHHu'H
S,  h    r  H
    Hu
HGHP0IHu
HCHP0HIHuHHuXH+ p i      H jHHHuH+ < h    u  H 6HHHH   H+  i      HK HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
 D X H
1
 9&Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\cfH(IL$0wo
 Hu9L
c* D@PH
    P      L
 C83H(H\$WH HH؃uOp
 HtDL
) DCQH
   ` P      L
 7H\$0H _É_H\$03H _{hhijH(A(q
 Hu9L
5) D@TH
    T   Q   L
 73H(lmH(AHp
 Hu9L
( D@XH
   # X      L
j 63H(o;rHUHp  3HXHpHxL`LhLpLxLLHHHl$0Hl$8Hl$@LHl$(Ll
 Hu'H' m       H %I  Ll
 Hu'H' 8       H H  A$HD$ $  4l
 HHu,Hu' H|$     H?    H     m
 HHu'H6'     b   H E  HxH
l
 E3H`HHu'H& o       H gG  Hu
HCHP0H LIHKl
 y'H&        He E  Hu
HGHP0AL$$  k
 HHu,HO& H|$     H o   G  H+ LIk
 y'H&     8   H nD  Hu
HGHP0IL$"HHu,H% H|$ <    H    F  Hg LI+k
 y'H%        HE C  Hu
HGHP0A$   m
 HHu,H1% H|$     H Q   bF  H LIj
 y'H$ l       H PC  Hu
HGHP0A8$   tHi
 H H=i
 Hi
 H H=i
 Hu,H$ H|$     HN    E  HP LIi
 y'HA$     m   H B  Hu
HGHP0A8$   tH i
 H H=i
 Hi
 H H=i
 Hu,H# H|$ P    H    E  H˾ LI?i
 y'H#      
  HY A  Hu
HGHP0A8$      I$   HHu'H:#     f !  H A  H LIh
 y'H" z    ( #  H ^A  Hu
HGHP0A8$     I$   HHu'H"       @  Hg A  HC LIh
 y'Hd"      B  H) @  Hu
HGHP0H
 HHu'H"     E U  H޾ B  A$   $  f
 LHu'H
! S     W  H
 KB  Hf
 HsHl$(H9k  HkHl$(HW  H{HE HHHHuHAP0Hmg
 HwH9   E3H$   HEAH$   L$   QHHu'H"!     N k  H ?  HE u
HEHP03IE Hl$(u
IEIP0L      g
 LHu'H
  5     {  H
| -A  Hh3Lh E3HHHl$(LHHu'Hh         H- >  Iu
IFIP0LP3IHHHu'H      C d  Hܼ y>  IE u
IEIP0LHu	HHP0H
 HHH|$0mHHu'H ,       Hs >  H@L   MtH_ HAH2L@@MtHD HH AHH. H=f
 HHu'H.     Z   H =  Hu
HGHP0A   HH,d
 HHu'H [    	   H ?=  Hu
HCHP0HHKy'H        HZ <  Hu
HGHP0F  Ht$0HFL   MtH HAH2L@@MtHκ HH AHH He
 HHu,H H|$ q    Hº    >  Hl LI`c
 y'H 3       Hz <  Hu
HGHP0A$   $   xb
 HHu'Ha ߺ       H& ;  H LIb
 y'H#     O   H ;  Hu
HGHP0A$,  L$xa
 HHu'H P       H 4;  HC LI?b
 y'H        HY :  Hu
HGHP0A$0  $   Wa
 HHu'H@     l   H :  H LIa
 y'H     .   HǸ d:  Hu
HGHP0A$$  $   `
 HHu'H ,    ھ   Hs :  H LIa
 y'Hp        H5 9  Hu
HGHP0La`
 H I`
 y,H H|$     H >   #<  A$@   tH`
 H H=_
 H_
 H H=_
 Hu,H H|$ 7    H ޽   ;  Ht$ H LH!`
 y'Hv        H; 8  Hu
HGHP0A$H  b
 HHu'H'     S   H 8  H LH_
 y'H g       H K8  Hu
HGHP0A$P  ya
 HHu'H     Ƽ    H_ 7  HӴ LH_
 y'H\ ڶ       H! 7  Hu
HGHP0A$X  `
 HHu'H
     9   Hҵ o7  H޶ LHz^
 y'H M       H 17  Hu
HGHP0A$`  $   :]
 HHu'H{        H@ 6  H\ LH]
 y'H=     i   H 6  Hu
HGHP0A$d  $   \
 HHu'H g     $  H K6  H LHV]
 y'H )    ׺ &  Hp 
6  Hu
HGHP0A$h  $   \
 HHu'HW մ     0  H 5  H( LH\
 y'H     E 2  H޳ {5  Hu
HGHP0A$p  ^
 HHu'H H     <  H ,5  H LH7\
 y'H 
     >  HQ 4  Hu
HGHP0A$  ^
 HHu'H=     i H  H 4  H LH[
 y'H }    + J  HĲ a4  Hu
HGHP0A$  ]
 HHu'H .    ܸ T  Hu 4  H LH[
 y'Hr      V  H7 3  Hu
HGHP0H
 	HHu'H'     S `  H 5  A$(  L$`Y
 LHu'H d     b  H \5  HY
 HsLH9g  LkMZ  H{IE HHHHuHAP0HZ
 HwH9   E3H$  HEAL$  L$   iHHu'H:     f v  H 2  IE u
IEIP0ILu
IFIP0L      #Z
 HHD$(Hu'H M       H E4  Lh3Lu E3HHLLHHu'H         HG 1  HE u
HEHP03Hl$(MIHHHu'H.     Z o  H 1  Iu
IFIP0LHu	HHP0HGL   MtH} HAH2L@@MtHb HH AHHL HY
 HHu'H 
       HQ 0  Hu
HGHP0Hm LIW
 y'H>     j   H 2  HHH\$8HHu
HCHP0H
Ү HHu'H d       H \2  H@L   MtH HAH2L@@MtH| HH AHHf HuX
 HHu'Hf        H+ 1  Hu
HCHP0A   HHdV
 HHu'H     A   Hڭ w/  Hu
HGHP0H>y'H N       H F1  Hu
HCHP0   A$  $   U
 HHu'Ht        H9 0  Ht$ HP LHU
 y'H1     ]   H 0  Hw  HCHP0h  H
ɬ HHu'H [    	   H S0  H@L   MtH. HAH2L@@MtH HH AHH HlV
 HHu'H] ۬       H" /  Hu
HCHP0A   HH[T
 HHu'H     8   Hѫ n-  Hu
HGHP0H<y'H E       H =/  Hu
HCHP0   A$  OV
 HHu'Hp        H5 .  Ht$ H LHS
 y'H-     Y   H .  Hs  HCHP0d  H
Ū HHu'H
 W       H O.  H@L   MtH HAH2L@@MtH HH AHHѧ HhT
 HHu'HY
 ת       H -  Hu
HCHP0A   HHWR
 HHu'H
     4   Hͩ j+  Hu
HGHP0H:y'H C       H ;-  Hu
HCHP0Ht$ H
a 4HHu'Hu        H: ,  H@L   MtH HAH2L@@MtH HH AHHm HS
 HHu'H s    !   H k,  Hu
HCHP0HL$8A   HP
 HHu'H      ή   Hg *  Hu
HGHP0H8y'H] ۨ       H" +  Hu
HCHP0H݅
  H
K HHu'H     3 "  H̧ i)  A$x  L$pO
 LHD$(Hu'H
 ?     $  H #)  HO
 LHoH9E g  LwMZ  HwIHHHHuHAP0H`P
 HnH9E    E3H$   HEAL$   L$   CHHu'H
     @ 8  H٦ v(  Iu
IFIP03I$LuID$IP0Ht$(      O
 LHu'H	 '    լ H  Hn (  Lp3E3IHMe LHD$(HHu'HZ	 ئ     N  H '  IE u
IEIP03LSIHHHu'H	     4 1  Hͥ j'  I$uID$IP03Ht$(Hu
HE HP0HCL   MtHP HAH2L@@MtH5 HH AHH HnO
 HHu'H_ ݥ     T  H$ (  Hu
HCHP0H
X 3LHH|$@HHu'H     3 a  H̤ i&  H@L   MtH HAH2L@@MtH HH AHH HN
 HHu'H      c  HL %  Hu
HGHP0A   HIL
 HHu'H6     b f  H %  Hu
HCHP0HH;4y'H l     h  H P%  Hu
HGHP0,  Ht$ Lr H H:L
 y'H 
     s  HT '  H IK
 HHu'HP Σ    | |  H $  H! HM
 HHu'H     = ~  H֢ s$  Hu
HGHP0H LInK
 y'H A       H 9&  H@  HCHP01  H
 .HHu'Ho        H4 %  H@L   MtHH HAH2L@@MtH- HH AHH HK
 HHu'H m       H e%  Hu
HCHP0A   HII
 HHu'H     ʧ   Hc  #  Hu
HGHP0H1y'HY ס       H $  Hu
HCHP0H݅/  Ht$ LR H HI
 y'H u    #   H $  H I/I
 HHu'H 6       H} .$  H1 HJ
 HHu'Hy        H> !  Hu
HCHP0HZ LIHH
 y'H(     T   H !  H  HGHP0  H
 HHu'H R        H 6!  H@L   MtH HAH2L@@MtH HH AHHt HcI
 HHu'HT ҟ       H    Hu
HGHP0A   HIRG
 HHu'H     /   HȞ e   Hu
HCHP0HH/y'H 9       H    Hu
HGHP0%  Ht$ L Hp HG
 y'H\ ڞ       H! !  HM IF
 HHu'H     I   H   HN H]H
 HHu'H  \    
   H @  Hu
HGHP0H LI;F
 y'H         HU !  HuHCHP0Ht$ Hڜ LIE
 !  H7      c   H    H
ؚ HHu'H
 z    (   H r   H@L   MtH HAH2L@@MtH HH AHHl HF
 HHu'H|
        HA   Hu
HCHP0Ht$0A   HHuD
 HHu'H&
     R   H   Hu
HGHP0H.,y'H
 _    
    H W  Hu
HCHP0^	  HFL   MtH: HAH2L@@MtH HH AHH	 HXE
 HHu,HI
 H|$     H i +  N  H LIC
 y'H
     2 -  H˚ |  Hu
HCHP0A$   $   B
 HHu'H
 0    ޠ 7  Hw (  HӘ LIC
 y'Ht
      9  H9   Hu
HCHP0A$(  $   7B
 HHu'H 
     L C  H   H LIB
 y'H
 `     E  H X  Hu
HCHP0A$,  $   A
 HHu'H
      O  HS   H_ LIA
 y'HP
 Ι    | Q  H   Hu
HCHP0A$0  $   A
 HHu'H
 z    ( [  H r  HŞ LIiA
 y'H
 <     ]  H 4  Hu
HCHP0A$4  L$H@
 HHu'Hm
      g  H2   H LI@
 y'H/
     [ i  H   Hu
HCHP0A$8  B
 HHu'H
 ^     s  H V  H LIM@
 y'H
      Ν u  Hg   Hu
HCHP0A$@   tH?
 H Hv?
 Hu?
 H Hk?
 Hu,H7
 H|$     H W   <  H LI?
 y'H
 r        H j  Hu
HCHP0A$D  $   >
 HHu'H
     ̜   He   H LI
?
 y'Hb
        H'   Hu
HCHP0A$H  @
 HHu'H
     ?   Hؕ   HL LI>
 y'H
 S       H K  Hu
HCHP0H
 HFHHu'H
        HL   A$$  $   Z=
 LHu'HC
     o   H   H4=
 Hl$(HoH9E l  LgLd$(MZ  HwI$HHHHuHAP0H=
 HnH9E    E3H$  HEAL$  L$  HHu'H
        HS   I$uID$IP03IE Ht$(u
IEIP0L      q=
 LHu'H"
     N   H   L`E3Lh E3HHLd$(MAHHu'H
 P       H 4  Iu
IFIP0MPIHHHu'H
        HH   IE u
IEIP03LHu
HE HP0HCH\$8L   MtHɒ HAH2L@@MtH HH AHH H<
 HHu3H
 Ht$0H|$ H E       3  H% LI9;
 y'H
        HS   H  HCHP0Ht$0H|$   H
 HHu'H0
     \   H   H@L   MtH HAH2L@@MtHޔ HH AHHȔ H;
 HHu'H
 .    ܗ   Hu &  Hu
HCHP0A   HH9
 HHu'H_
 ݑ       H$   Hu
HGHP0Hg!y'H
     F   Hߐ   Hu
HCHP0]  HFL   MtHs HAH2L@@MtHX HH AHHB H:
 HHu,H
 H|$     HL      H LI8
 y'H?
     k 	  H   Hu
HCHP0A$   L$P8
 HHu'H
 l       H d  H LI[8
 y'H
 .    ܕ   Hu &  Hu
HCHP0A$$  L$Xv7
 HHu'H_
 ݏ       H$   Hh LI7
 y'H!
     M !  H   Hu
HCHP0A$,   tH6
 H H6
 H6
 H H6
 Hu,H
 H|$ /    H ֔ +    Hr LI7
 y'Hs
      -  H8   Hu
HCHP0H
 HHHu'H%
     Q 7  H   A$(  L$h5
 LHu'H
 b     9  H F  H5
 LHoH9E h  LoM[  HwIE HHHHuHAP0H6
 HnH9E    E3H$(  HEAL$(  L$0  eHHu'H6
     b M  H   IE u
IEIP03ILu
IFIP0L      6
 HD$(Hu'H
 J     ]  H .  3LhLp LLE3HHHHu'H
      c  HD 
  HL$(HuHAP03Ht$(OIHHHu'H*
     V F  H 
  Iu
IFIP03LHu
HE HP0HCHH\$8L   MtHn HAH2L@@MtHS HH AHH= H5
 HHu'H}
      s  HB   H֐ LI3
 y'H?
     k u  H   Hu
HCHP0H
p HHu'H
 r        H j  H@L   MtHō HAH2L@@MtH HH AHH H4
 HHu'Ht
        H9 
  Hu
HCHP0A   HHr2
 HHu'H#
     O   H   Hu
HGHP0H+y'H
 \    
   H T
  Hu
HCHP0B  H
 JHHu'H
 	       HP 
  H@L   MtH$ HAH2L@@MtH	 HH AHH H3
 HHu'H
     7   HЈ   Hu
HCHP0A   HH	1
 HHu'H
 8       H 
  Hu
HGHP0Hy'Hu
        H:   Hu
HCHP0  A$0  2
 HHu'H
     J   H   H׌ LI0
 y'H
 ^       H V  Hu
HCHP0A$H  p2
 HHu'H
        HV   H LI/
 y'HS
 ч       H 
  Hu
HCHP0A$8  1
 HHu'H
     0   HɆ z
  H] LIq/
 y'H
 D       H <
  Hu
HCHP0A$@  V1
 HHu'Hw
        H< 	  H( LI.
 y'H9
     e   H 	  Hu
HCHP0A$8  0
 HHu'H
 h       H `	  H# LIW.
 y'H
 *    ؋   Hq "	  Hu
HCHP0A$@  <0
 HHu'H]
 ۅ       H"   H LI-
 y'H
     K   H   Hu
HCHP0A$@  /
 HHu'H
 N       H F  H LI=-
 y'H
        HW   H  HCHP0Ht$0H|$ 	  H
 HHu'H4
     `   H   H@L   MtH
 HAH2L@@MtH HH AHH܇ H-
 HHu'H
 2       Hy *  Hu
HCHP0A   HH+
 HHu'Hc
        H(   Hu
HGHP0Hky'H
     J 
  H   Hu
HCHP0j  A$0  -
 HHu'H
 E       H =  H LI4+
 y'H
        HN   Hu
HCHP0A$H  -
 HHu'H:
     f !  H   HÇ LI*
 y'H
 z    ( #  H r  Hu
HCHP0A$8  ,
 HHu'H
 +    ه -  Hr #  H LI*
 y'Ho
      /  H4   Hu
HCHP0A$@  +
 HHu'H 
     L 9  H   H LI)
 y'H
 `     ;  H X  Hu
HCHP0A$8  r+
 HHu'H
      E  HX 	  H̃ LI )
 y'HU
 Ӏ     G  H   Hu
HCHP0A$@  *
 HHu'H
     2 Q  H |  HG LIs(
 y'H
 F     S  H >  H  HCHP0Ht$0H|$ J  H
F} )HHu'Hj
      q  H/   H@L   MtH HAH2L@@MtH؄ HH AHH H(
 HHu'H
 h     s  H~ `  Hu
HCHP0A   HH&
 HHuDH
     ń v  H^~ H  H  HGHP0  Hu
HGHP0Hy'H7
 ~    c x  H}   Hu
HCHP0  LP H I&
 y,H
 H|$ V~    H}      L%
 H IA&
 y,H
 H|$ ~    H`}      A$   1(
 HHu'HR
 }    ~   H}    H|$ H} LH%
 y'H
 }    ;   H|    Hu
HCHP0A$(  '
 HHu$H
 >}       H| 9H, LH0%
 y[H
 }       HJ| HtHu
HCHP0MtnIE u
IEIP0Ht$0H|$ 3[Hu
HCHP0H{ LI$
    H
 }|    +   H{ Ht$0H|$ 3HL$(Ht
HuHAP0MtIu
IFIP0L
{ D$| ց H
`
 SHt$0H|$ AHt$0H|$ 5Ht$0H|$ )Ht$0H|$ Ht$0H|$ Ht$0H|$ H|$ IIL$H  L$P  L$X  H$  MtIu
IGIP0L$@  HtHu
HGHP0H$`  HtHu
HFHP0HL$8H$h  Ht
HuHAP0HD$@HtH u
HPHR0HHp  ]{(H\$Hl$Ht$H|$ ATH H?z HH
 E3=HHuH#
 Q%  H   H
b HxHH5Ly L%my H-z `$
 HHtwH*H_HGH3GhHG@HGHHG HG(HG0HG8Gl MtI$LgXHtHE HoPHtHHHw`#
 Hu
HCHP0HGY%  L
]
 H
k
 A   y   L
y DHu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH Hx H\$0HH
 E3Ht$8H|$@ͻE3HHu2H-k"
 9y   ~ %  HE H
 Hux   HXHH
| HAL   MtHy AH,L@@MtHx H AHHx :"
 HHu'H+
 x   W~ %  Hw   H 
 IH9C   H{H   HsHHHHHuHAP0HH2HHu'H

 1x   } %  H
xw    Hu
HGHP0IHu
HCHP0HIHuHHuXHR
 w   ~} 
&  Hw jHHHuH
 w   J} %  Hv 6HHH   H
 dw   } &  Hv HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
ev Dw | H
Qi
 |&Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\+k.HHPHHAUH   HHXE3HhHpHxL`LpLxMHIIML$   MH;9
 >  3k
 HHu'Hl
 u   { '  H1u *
  HM H;

 u>H
 
 Hi
 H	!
 L!
 u   Lt F{ '  L  HBr \
 HHu'H

 cu   { '  H
t   H@H;
    H;
 t~HIv
 HHu*H

 
u   z '  H
Tt M  H@H   Hl$ Hu8HP
 t   |z '  Ht Mx  HHILl$ Hu
HGHP0JLH$   H$   HuUH4
 H9Cu'L;s4  HCIJ|HHH$   2L;s
  H9IHHH$   HHH  ILHt
HuHAP0H~v H$   IL;bH#
 AEH9BI9GADtUMGL;B   B IO 8   IAGDJA;tt
A   H . A^L
 AM;ucI;AAuUA   I
 HH   HHE Du
HUHR0Hl$ Ex[H$   EMuHNH9N ~ IHFL<HAH$   HFKIH/
 u:H$   .E3H
 r   Hx '  Hq MD	  H
 pr   x '  Hq M	  
 HtHu
 HHt?
 Hu
HCHP0H$   H$   HJ  HAP0M>  Hh
 q   w '  H-q M  H-s H
7u H
 HHtH H虿HHu'H

 q   6w (  Hp 5  H$   HA
 u'H
 Iq   v (  Hp   Hu
HFHP0tf   |
 HHu'H}
 p   v !(  HBp   H$   H$   HH@HHuHAP0MH=u H
#t H

 HHtH H腾HHu*H
 tp   "v :(  Ho IZ  HCL   MtHm HAH2L@@MtHqm HH AHH[m H
 HHu*Hs
 o   u <(  H8o I  Hu
HCHP0HGL   MtHn HAH2L@@MtH~n HH AHHhn H
 HHu'H
 ^o   u ?(  Hn    Hu
HGHP0H$   HN H;
M
 uAH
\
 H
c
 H	d
 L}
 n   LLn t D(  I  Hk 
 HHu'H>
 n   jt F(  Hn ~  HN H;

 u>H

 Hb
 H	
 L
 qn   Lm t J(  3  Hq .
 LHu'H

 5n   s L(  H
|m   H
 IL$   AH9Cu4HkH$   Ht#HCHE HH HHuHAP0   HI
 H9C   H$   HT$HDFHD$HHcE3HHHl$@H+H|$PLt$XHHu'H
 lm   s ](  Hl   HtHE u
HEHP0HIL$   u
HGHP0IIu
IFIP0M   FHc
 LHu'H
g
 l   r o(  H
,l   HtHhL$   IH$   HcE3HILI| Mt(HIIMbHHu'H
 ql   r }(  Hk   I$uID$IP0MHu
HCHP0H$   H$   HuHAP0H
bp 5HHu'Hv
 k   q (  H;k   H@L   MtHl HAL2L@@MtHl HH ALHl H
 LMu'H
 tk   "q (  Hj ]  Hu
HCHP0ID$L   MtHp IAH2L@@MtHp IH AHHp It
 HHu'He
 j   p (  H*j   I$uID$IP0HD
 MAH9Cu,LcMt#HCI$HH HHuHAP0   H
 H9C   H$   HT$0DEHD$0HcE3HHLd$(H+Ht$8ιHHu'H
 j   o (  Hdi    M  I${  ID$IP0k  EHc
 LHu/H@
 H$   i   Hi ]o (     MtL`MH$   HcE3HILHHIIt CHH   H
 Ni   n (  Hh HtHu
HFHP0HtHu
HGHP0H$   H$   HtHu
HCHP0MtIu
IFIP0HtHE u
HEHP0MtI$uID$IP0L
g Dh Nn H
\
 #Iu
IFIP0Hu
HCHP0LLt$pLd$xH$   H$   H$   H$   MtIu
IGIP0H$   L|$hHtH u
HPHR0IHĠ   A]H\$Hl$VWATH@H
 HzILH\$pHM   HtH   HZH\$pI3
 HHu)H  Hi H
 HtHHD$pHH   H[
 LL$pHF? HD$(E3HH|$ Yy
)     H\$p   H   H   Hy3L
    L

 HH,
 H|$0HO@
 L|[
 HDH
 HD$(HL$ H

 H	/
 )  L

 H
\[
 A  @l ~f   L
e 3HZHI$H\$`Hl$hH@A\_^HLH L@HPHHAUH  HE3HXHhHpL`LpHAML   ILL$   L$   L$   Ll$8Ll$PL$   Ll$XL$   Ll$xL$   Ll$`Ll$pL$   L$   Ll$hLl$0Ll$(Ll$ IMtHd AH+H@@HtHc H HHc 
 HH$  L$  Hu'H
 e   j *  H[d J  H
 MH9C   L{M   H{IHHHHuHAP0IH蝸HHu'H
 d   Jj *  Hc gI  Iu
IGIP0MHu
HCHP0HIu
HGHP0H

 AH;  L;A  H-` H
g Hx
 HHt<H BH3HHuHd
 c   i *  H)c H  H輱HHu'H-
 c   Yi 3*  Hb vH  HGL   MtH_ HAH2L@@MtH_ HH AHH_ H
 HHu'H
 +c   h 5*  Hrb G  Hu
HGHP0H.d E3H˴HHu'H\
 b   h 8*  H!b G  Hu
HCHP0HIu
HGHP0H
 L;   L$   IM H;u>H

 HX
 H	
 L
 Xb "  La g Z*  MG  H^ 

 HHu'H
 b "  g \*  Hca F  IILH$    IFP0  H
#c HHu'H?
 a #  kg r*  Ha F  HI{
 u'H
 a #  1g t*  H` NF  Hu
HGHP0ti   
 HHu'H
 5a $  f *  H|`  F  IH@IL0ILH$  uIFP0L$   L$   L$  H
)e HHu'H=
 ` %  if *  H` E  H@L   MtH] HAL2L@@MtH] HH ALH] H	
 LMu'H
 ;` %  e *  H_ E  Hu
HCHP0IGL   MtH^ IAH2L@@MtH^ IH AHH^ I<	
 HHu'H-
 _ %  Ye *  H^ D  Iu
IGIP0IM 3LH;

 u>H

 HuU
 H	

 L
 K_ %  L^ d *  +D  H[ 
 LHu'H
 _ %  d *  HV^ C  IM H;

 u>H
%
 HU
 H	-

 LF
 ^ %  L^ kd *  C  HWa 
 LHD$0Hu'H

 ^ %  1d *  H
] cC  H
 LHl$(H9Cu5LsLt$(Mt'HCIHH HHuHAP0LL$0   H
 H9C   L$X  HcH$H  HDGE3HH+L$@  L$H  L$P  gHHu'H8
 ] %  dc *  H\ B  MtIu
IFIP0ILHl$(u
IGIP0HL$0LHuHAP0Hl$0L   GHc
 LHD$ Hu'H

 '] %  b *  H
n\ B  MtLpHl$(LH$  HcE3HILHL$0IL(M| IHLHl$0蠮HHu'H1
 \ %  ]b *  H[ zA  I$uID$IP0LHl$ Hu
HCHP0H$  HH$  H HuH@P0IM H;
i
 u>H
x
 HR
 H	
 L
 \ '  Lh[ a *  NA  HX 
 HHu'H]
 [ '  a *  H"[ @  IM H;

 u>H

 H2R
 H	
 L
 [ '  LZ 7a *  [@  HCZ M
 HHu'Hֽ
 T[ '  a *  HZ @  HH
 LHD$ Hu'H
 [ '  ` *  H[Z ?  Hu
HGHP0Hu
HCHP0H
'_ L$   Hl$ HHu'H.
 Z (  Z` +  HY ?  H@L   MtHW HAH2L@@MtHW HH AHHW H
 HHu'H
 ,Z (  _ +  HsY ?  Hu
HCHP0HGL   MtH] HAH2L@@MtHt] HH AHH^] H-
 HHu'H
 Y (  J_ 
+  HX g>  Hu
HGHP0H 
 HH9Cu+H{Ht"HCHHH HHuHAP0   H
 H9C   H$  H$  DEH$   HcE3HHH$  H+L$  聨LHD$ Hu'HM
 X (  y^ +  HX =  HtHu
HGHP03H   EHcB
 LHD$0Hu'H
 lX (  ^ *+  HW 7=  HtHx3I$H$  HcMdHIL HE3ILHD$ Hu'H
 X (  ] 5+  HJW <  HL$0HuHAP03Hl$0Hu
HCHP0I$uID$IP0H
[ Hl$ ɮHHu'H

 W *  6] C+  HV S<  H@L   MtHT HALHD$0<L@@MtHT HH ALHD$0HhT H 
 LHD$0Mu'H{
 V *  \ E+  H@V ;  HuHCHP0LL$0IAL   MtHX IAH2L@@MtHW IH AHHW I	 HHu'H
 dV *  \ H+  HU /;  HL$0HuHAP0IM Hl$0H;
T	 u>H
c	 HL
 H	k
 L
 V *  LSU [ M+  :  HR 	 LHD$0Hu'HC
 U *  o[ O+  HU :  IM H;
	 u>H
	 HhL
 H	 
 L
 vU +  LT [ [+  A:  H	X 3	 HHu'H
 :U +  Z ]+  HT :  IM H;
A	 u>H
P	 H	L
 H	X 
 Lq
 T ,  L@T Z i+  9  HS 	 LHu'H5
 T ,  aZ k+  HS ~9  H&	 LHl$(H9Cu0LsLt$(Mt"HCIHH HHuHAP0   H	 H9C   H$  H$  DEH$  HcE3HHL$  H+L$  H$  L$  莣HD$ Hu'H]
 S *  Y +  H"S 8  MtIu
IFIP03I$LHl$(uID$IP0HHl$0u
HGHP0IHu
IGIP0Ld$ L   EHc	 HHu'H

 :S *  X +  H
R 8  MtLpE3Lt$(H$  Hc3H| L|(LdHHL0E3HHHl$0HL认LHD$ Hu'H:
 R *  fX +  HQ 7  Hu
HFHP0HHu
HCHP03L$   	 LHD$ Hu'HӴ
 QR /  W +  HQ 7  IM H;
X	 u>H
g	 HHI
 H	o	 L
 R /  LWQ W +  =7  HV 	 HHu'HL
 Q /  xW +  HQ 6  IM H;
	 u>H
	 HH
 H		 L
 Q /  LP &W +  _6  HR <	 HHu'Hų
 CQ /  V +  HP #6     	 LHu'H
 	Q /  V +  HPP 5  H
Q HXE3HHp H订HHu'H?
 P /  kV +  HP 5  Iu
IGIP0HFH;L	    H;G	 t}HI	 LHD$@Hu'HԲ
 RP /   V +  HO G5  H@L   MuBH
 L|$@P /  HgO U +  5  HE3HMMHt$@Hl$@E3Hu
HFHP0INtfMuEH|	 H9EuL;m~  HEIJtHI+L;m_  I6IHIHAHH  HFH)	 H;   H;	    H	 HHD$0H  Hu
HFHP0HCHIH   HHx  HL$0A   HH_  Ld$0Iպ   HJh  I$uID$IP0Hl$@E3Ld$0>HNH  H;u
H^H~ HFHHxHHHu
HFHP0HL$XHH\$XHt
HuHAP0H$   HIH$   HtHu
HAP0HHHI	 HH*  LD$ IHI9H ~H I@H4HAI@HIF	    Hu
HFHP0IH'
 L|$@M /  HL GS  ,  k2  HL$0HuHAP03HL$0euIhHѯ
 L|$@JM /  HL R (,  2  H
 L|$@M /  HoL R ,  2  Hy
 L|$@L /  HCL R 1,  1  HM
 L|$@L /  HL mR /,  1  H~H
	 Hg
 A   H		 
Hx艤H
 L|$@kL /  HK R ,  `1  	 HtHs	 HHtn	 HE u
HEHP0HD$ H$  3LLHl$ H$   yXHc
 Lt$(K 1  H-K Q ?,  1  H7
 L|$@K /  HK WQ +  0    H
N 订LHu'H
 mK 2  Q I,  HJ b0  H@L   MtHH IAH2L@@MtHH IH AHHoH I~	 HHu'Ho
 J 2  P K,  H4J /  Iu
IGIP0HP	 LH9F   L~M   H~IHHHHuHAP0IHfLHD$ Hu'H
 `J 2  P Y,  HI U/  Iu
IGIP0LHu
HFHP0H$  HMHALd$8H;	    H;	    HH|$@7	 LHD$ HugHK
 I 3  wO n,  HI .  HLHD$ HcH
 I 2  7O \,  HH ~.  H@H   H$   HuEH̫
 JI 3  N p,  HH ?.  HHLHL$ HHl$@H$   LHuLH	 I9D$u!I;|$
  ID$H4HHH|$@.I;|$  ItHHH|$@IHH  IHt$PLHt
HuHAP03	 HHG  H$   IO	 LH  H@H;	 tYH;	 tPII	 HH  H@L   Mu3H
 H 5  M ,  HZG ,  IILLIu
IGIP0Nl@ MuFH	 H9GuL;gS  HGIN|II,L;g4  M} IIIHALH  HL$hL|$hHt
HuHAP0H
K LxHH  H@L   MtHuD HALHD$0<L@@MtHUD HH ALHD$0H:D Ha	 LHD$0M7  HuHCHP0LL$0IAL   MtHD IAH2L@@MtHqD IH AHH[D I	 HH  HL$0HuHAP0H	 HՋHT$0H9Cu8HSHT$0Ht*HCHHH HHuHAP0HT$0   HH~	 H9CuyHD$hH$(  DAH$0  H$   H$0  H@ E3H$8  HcHHH+FLH>  HL$0Ht
HuHAP03Hl$0   AHc+	 HHD$(Hs  HD$0Ht
HAHD$0    HD$hH$   E3H HDHB H HB HHD HLH
  HL$(HuHAP03Hl$(Hu
HCHP0HNHH9N ~IHFL<HAHFIH%	 p
  IIGIP0	 Ht H	 HH߸  A	 Hu
HGHP0H$   LH$   Ht
HuHAP0	 HH  H
F >LH\  H@L   MtHF IAH2L@@MtHF IH AHHF I1	 HH  Iu
IGIP0H&	 LHkH9E    L{M   H{IHHHHuHAP0H	 HoH9E uHE3H$   HEAL$   L$   軒HH  Iu
IGIP0E3v   	 LHD$(H
  LxI$E3E3HHML` 螔HH  Iu
IFIP0Ll$(IH耖HH  Hu
HE HP0HT$P3LHH~	 ;  Hu
HGHP0HL$XLHt$XHt
HuHAP0Ll$8HIEL   MtH? IAH2L@@MtHe? IH AHHO? IN	 HH  HS	 LgI9$   H_H   HoHHHE HHuHAP0H	 LeI9$uJE3H$   HEAH$   L$   HH  Hu
HCHP03Hx   	 LHD$(H  HXHD$XE3H IHIF 3˒HHW  Iu
IFIP03Hl$(IH諔HHF  Hu
I$HP0Hu
HFHP0L$   HIM H;
	   H4= N	 HH  H@L   MtH? HALHD$(<L@@MtH? HH ALHD$(H? H	 LHD$(M  Hu
HGHP0Ho	 MfHI9$   I~H   InHIHE HLHl$(uHAP0H	 LeI9$uOHD$PE3H$   EAHH$   H$   HH
  Hu
HGHP03Hs   	 HH3
  HxHD$PE3H HHHC 3ߐHH	  Hu
HCHP03HHT$PI迒HH  Iu
I$IP0H$   Hl$(LH$   Ht
HuHAP0IM HH;
	   H&A P	 HH
  IH8	 LHD$(H
  Hu
HFHP0HL$xLt$xHt
HuHAP03Hl$(v	 HH+
  A   HI	 HH  Hu
HFHP0HH  Hu
HSHR03ۅt0K	 HH  H
E< HH@3HHHII3IILHD$xuIFP0   	 LHD$(H  H$   H
6B E3H IIFHH  Iu
IFIP0   ]	 LHD$(HJ  H@IIH	 HH  Iu
IFIP0H$   Hl$(LH$   Ht
HuHAP0Ll$8HT$PIX	 HH
  H@L   MtH< HALHD$(<L@@MtH< HH ALHD$(H< H	 LHD$(M	  Hu
HCHP0   	 HH	  I$L`C	 HHb	  LP= H	= H	 	  LHIjHH  Iu
IFIP0HHl$(u
HCHP0HHu
HFHP0Lt$PLIIH	 ]  Hu
HGHP0I6	 H  H|$@Ld$ HH$   L$   ID$H;	 uI|$tOID$HxH{H;y	 uI|$t+I|$ H[HHhHtHAHt   IH:   	 HHuH"HI3	 HE Hu
HEHP03H  H8 E3HEAHH  Hu
HGHP0H  Hu
HVHR0Ld$ H$   H|$@HH
; ߐHH  H@L   MtHt: HAH2L@@MtHY: HH AHHC: H	 HH  Hu
HGHP0II	 HHC  H	 LcHl$(I9$   LsLt$(M   HkIHHE HHuHAP0HU	 LeI9$u`E3H$   HEAL$   H$  <HH  Iu
IFIP03HHl$(   HGHP0~   	 LH  3E3HHL$(HLpHx HH  Iu
IGIP03L'HHHH  Hu
HGHP0Hu
I$HP0Lt$PLIIH	   HH|$@Ld$ H$   HFHP0H$   xH
 z7 5  (= ,  H6 E  Hՙ
 S7 4  = ,  H6   H
 ,7 4  < -  Hs6   H
 7 4  < 	-  HL6   H`
 6 4  < ,  H%6   H9
 6 4  e< ,  H5   H
 6 4  >< ,  H5 [  H
 i6 4  < ,  H5 4  HĘ
 B6 5  ; ,  H5 
  H
 6 6  ; <-  Hb5   Hv
 5 6  ; P-  H;5   HO
 5 6  {; J-  H5   H(
 5 7  T; u-  H4 q  H
 5 7  -; -  H4 J  Hڗ
 X5 7  ; -  H4 #  H
 15 8  : -  Hx4   H
 
5 8  : -  HQ4   He
 4 8  : -  H*4   H>
 4 ;  j: -  H4   H
 4 A  C: m.  H3 `  H
 n4 A  : .  H3 N  Hɖ
 G4 A  9 }.  H3   H
  4 A  9 .  Hg3   H{
 3 A  9 f.  H@3   HT
 3 A  9 Y.  H3   H-
 3 A  Y9 V.  H2 v  H
 3 A  29 T.  H2 O  Hߕ
 ]3 @  9 G.  H2 R  H
 63 @  8 D.  H}2   H
 3 @  8 B.  HV2   Hj
 2 @  8 ;.  H/2   HC
 2 >  o8 1.  H2   H
 2 >  H8 ,.  H1 e  H
 s2 >  !8 +.  H1 >  HΔ
 L2 >  7 ).  H1   H
 %2 >  7 $.  Hl1   H
 1 >  7 !.  HE1   HY
 1 >  7 .  H1   H2
 1 <  ^7 .  H0 {  H
 1 <  77 
.  H0 T  H
 b1 <  7 
.  H0 -  H
 ;1 <  6 .  H0   H
 1 ;  6 -  H[0   Ho
 0 ;  6 -  H40   HH
 0 ;  t6 -  H
0   H!
 0 9  M6 -  H/ j  H
 x0 9  &6 -  H/ C  H
	 H'
 H		 L
 :0 9  L/ 5 -    H
 0 8  5 -  HZ/   Hn
 / 8  5 -  H3/   HG
 / 8  s5 -  H/   H
	 H'
 H		 L	
 / 8  L. .5 -  g  H
 `/ 7  5 o-  H. +  H
 9/ 7  4 b-  H. .  H
 / 6  4 V-  HY.   Hm
 . 6  4 6-  H2.   HF
 . 6  r4 (-  H.   H
 . 6  K4 &-  H-   H
 v. 6  $4 $-  H-   Hѐ
 O. 5  3 ,  H- D  H
 (. 4  3 ,  Ho-   <	 HtH0	 HH]t!	 I$  ID$IP0  HA
 - 3  m3 ,  H-   3		 LHu,H

 Lt$(- C  H, *3 .    H$   HD$8LHO H;
z	 uCH
	 H"%
 H		 L
 Lt$(L~, - D  2 .  Z  H+ 	 LHu,Hi
 Lt$(, D  H3, 2 .    H	 LHu,H+
 Lt$(, D  H+ K2 .    I$uID$IP0Hl$ LM   H
0 脃HH  H@L   MtH) HAH2L@@MtHf) HH AHHP) Hw	 HH   Hu
HFHP0HCL   MtH- HAH2L@@MtH, HH AHH, H
	 HH  Hu
HCHP0I	 HH@  H	 LH9Fu.L~Mt%HFIHH HHuHAP0   HH	 H9F   HG L$  DAH$p  HcH$h  HE3HH+L$`  H$h  L$x  [zHHD$ H  MtIu
IGIP03HLu
HCHP0H   AHc,	 HH 
  MtLxE3H$   L$  H\HA E3HH HA HHD I$Ld(3H{HD$ H	  Hu
HGHP0H|$ Hu
HFHP0HL$`HH|$`Ht
HuHAP0H$   Hl$ HO H;
	   H. ~	 LHD$ H  H@H;B	 uIx tMI@H0HH;)	 uIx t,IpHaHHhHtHAHt3ILD$ H>37	 HHt!HL$ H	 HHu
HGHP0LD$ H$   H  I u
I@IP0HL$pHl$ Ht$pHt
HuHAP0IH\z  =  HO H;
	 O  H) V	 HH  H@H;	 u!H~ t\HFL Ld$ I$   H;	 uH~ t2LfLd$ I$aHHhHtHAHt3HLHD$ >3	 HHu
LHl$ $HH	 HLHD$ u
HGHP0M,  Hu
HFHP0H|$pIH]	 HH  I$uID$IP0HHHt$puHGP0HH
P) s~LHD$ H  H@L   MtH$ IAH2L@@MtHp$ IH AHHZ$ Ia	 HHm  I$uID$IP0HT	 LgHl$ I9$   HWHT$ H   HoHHHE HHuHAP0HT$ H	 LeI9$uSHD$`E3H$   H$   EAHH$   uHH=  HL$ HuHAP03Hl$ }   	 HHY  HD$ E3HHC3HHD$ HD$`H HC wHH  Hu
HCHP03HHT$`HyHH  Hu
I$HP0HFL   MtH* HAH2L@@MtHy* HH AHHc* H	 HHp  Hu
HFHP0H$   HLH$   Ht
HuHAP0H
& |HH  H@L   MtH# HAH2L@@MtH# HH AHH" H	 HHu  Hu
HGHP0   	 HH'  H& HIH HGH! H HG Hw(	 HH  Hu
HGHP0HL$8H譊{  Hu
HFHP0IHM;X  H$   hHA
 # E  m) .  H#   H
 # I  F) </  H"   H
 q# I  ) 9/  H" f  H̅
 J# I  ( 7/  H" ?  H
m	 Hn
 H	u	 L
 # I  L]" ( 5/    Hg
 " J  ( h/  H,"   H@
 " J  l( |/  H"   H
 " J  E( v/  H! b  H
 p" K  ( /  H! e  H˄
 I" K  ' /  H!   H
 "" K  ' /  Hi!   H}
 ! K  ' /  HB!   HV
 ! K  ' /  H!   H/
 ! J  [' /  H    H
 ! J  4' b/  H  Q  H
 _! J  
' T/  H  T  H
 8! J  & R/  H  -  H
 ! H  & (/  HX    Hl
   G  & /  H1    HE
   G  q& /  H
    H
	 H
 H		 L
   G  L ,& /  z  H
 ^  E  & /  H )  H
 7  E  % .  H~   H
   E  % .  HW   Hk
  E  % .  H0   HD
  E  p% .  H	   H
  E  I% .  H   H
~! vHHu'H
 ` L  % /  H +  H@L   MtH# HAH2L@@MtH# HH AHH# Hq	 HHu'Hb
  L  $ /  H'   Hu
HGHP0HC	 LcHI9$E  H{H8  HkHHHE HHuHAP0H	 LeI9$a  Ll$8E3HT$@EAHH|$@Ll$HmHHu'H
 & L  # /  Hm   Hu
HGHP0Hu
I$HP0IHt$8LHuHAP0IE H$   L$  L$  L$  H$  H$  H$  H$  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$8Ht
HuHAP0HL$PHt
HuHAP0H$   Ht
HuHAP0HL$XHt
HuHAP0H$   Ht
HuHAP0HL$xHt
HuHAP0H$   Ht
HuHAP0HL$`Ht
HuHAP0HL$pHt
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$hHt
HuHAP0H$  HtH u
HPHR0IH  A]ù   	 LHD$ Hu'HZ~
  L  ! /  H    HxHD$8E3H IHIE |mHHu$H
~
  L  9! /  H nIE u
IEIP0Ll$8]Ll$8HI5oHHAH}
 0 L    /  Hw HtHu
HGHP0HtHu
HCHP0MtIu
IGIP0HL$0HtHuHAP0Lt$(Ld$ 
Lt$(Ld$ MtIu
IFIP0MtI$uID$IP0HtHu
HFHP0E3E3L
 D\   H

 ҊqK[H\$Hl$Ht$WATAUHPH	 HjMLH\$@HH\$HHM   Ht"HtH   Hz H|$HHZH\$@I&	 HHHtHt+RHT  Hs I	 HtHHD$@HH+  H I	 HtHHD$HHH  HQ
 LL$@H
 HD$(E3IHl$ ty
1     H|$HH\$@   H   H   H   Hy3L
p3
    L
r3
 HHu	 Hl$0H	 L
 HDHY3
 HD$(HL$ H
	 H		 2  L
z
 H

 A^   . ^  L
 誈3Hz HZLHI H\$pHl$xH$   HPA]A\_HHPATH   E3HXHhHxLhLpHALIL   L$   Ld$HLd$0Ld$8IL$   Ld$ Ld$(MtH  AH,L@@MtH H AHH 	 HHt$xL|$XHu'Hy
     F5  HK 1
  Hw	 MH9G   LM   HwIHHHHuHAP0IHjHHu'Hy
    : S5  H   Iu
IGIP0MHu
HGHP0HIu
HFHP03	 HHu^Hx
     c5  Hf   H9kHHuHjx
     V5  H/ w  IN H;
	 u>H
	 H
 H		 Lx
    L D g5  ,  H Z	 HHu'Hw
 a    i5  H   H@HH$   H;	 t~H;	 tuHp	 LHu*Hw
     o5  HN H  H@L   Mu6HOw
    { q5  H HY  HLIMHu
HGHP0MdMuFHG	 I9GuI;o  IGHH|HI,I;o}  I<$HHIIAHH4  HL$HH|$HHt
HuHAP0H H	 HH   H Hλ	 HH   Hu
HWHR0HN3H9N ~HHFHHAHFHH	 uHu
HCHP03Hu
 y   ' 5  H H  Hu
 H$   G   H  5     Hu
 H$      Hi  5     ,	 HtH 	 HHMt\	 Iu
IGIP0H$   HH$   kyvH u
    L 5  H E3  Ht
 H$   l   H  5  H  H  HFHP0  tH   3	 LHu'Ht
     5  HS   IN H;
	 u>H
"	 H
 H	*	 LCt
    L h 5  t  H ~	 HHu'Ht
    3 5  H 8     	 HHu'Hs
 K    5  H   HH
S E3HHpHX bHHu'Hs
     5  HF   Hu
HGHP0HCH;	 t}H;	 ttH
	 HHu'H#s
    O 5  H ?  H@H   Ht$@HuEHr
 e    5  H   HE3HIL$   ILl$@E3HHu
HCHP0Lt$0LdHuVHķ	 H9Gu'H;o  HGHH\H$   HI3H;o  I$HHIH$   HHHQ  HCHa	 H;   H;I	    Hʹ	 LHD$(H	  Hu
HSHR0INIIH   IH$   H}  Iν   HD$ He  I֍UH(  Iu
IFIP0H$   Ht$ Lt$0Ll$(NHKH  H;uHKHs H$   HCHHpH$   HHHu
HCHP0H$   ILHD$0Ht
HuHAP0HL$8HL$   HD$8HtHu
HAP0HI^Ll$ HshH   H~     H;<	 t"HRHHu+	 H  IHy?HHt7IHxHy(Hy#IH
 	 H		   	 IHIV HSH[pH  H{ w  H	 HL^	 HHw  HISHHu
HVHR0HU  IOI9O ~HIGHHAIGHIz	    HHt$@HCHP0HUo
 H$      H r 6  i  Iu
IFIP0Ll$(%uHdH o
 H$   v   H  6    Hn
 H$   G   H  6    Hn
 H$      Hi  !6    MFH
7	 H(
 M@H	k	 IHQn
 H$      H n 6  e  H~H
	 H
&
 A   H		 
HxcHm
 H$   i   H
  5    }	 Ht Hq	 HH    	 Hu
HGHP0H$   ILL|$XLt$`Ll$hH|$pHt$xH$   HtHE u
HEHP0HL$HH$   Ht
HuHAP0HL$0Ht
HuHAP0HD$8HtH u
HPHR0IHĐ   A\Hl
 H$   ]
   H	  5  HtHu
HGHP0MtIu
IGIP0HtHu
HCHP0H$   Ht
HuHAP0HL$ Ht
HuHAP0HL$(HtHuHAP0E3E3L
	 D	 a H

 %zHHPHHH   HXHhHxL`3E3H3H$  HD$(HD$0HD$ HD$HHC3L   Ld$`Ld$pLd$@Ld$PLd$XHL$8MtH HAH2L@@MtH HH AHH HG	 HH$   L$   L$   L$   Hu'Hk
    D 6  H u  H		 3H$   H9G   HwH$   H   H_HHHHHuHAP0HH\LHu*Hj
    
 6  HV L  Hu
HFHP0H$   3H$   Hu
HGHP03IE u
IEIP03	 LHunHj
 L$      H /
 6  i  H\LHuHi
 L$   I   H  6  *  HK H;
P	 uFH
_	 H`
 H	g	 Li
 L$   LQ     6    Hi 	 HHu/H<i
 L$      H Y 6    H@H;Q	    H;L	    HI	 HH$   Hu*Hh
 P    6  H L.  H@L   Mu;Hh
     6  H] L  HHH$   E3Hu
HGHP03NtMuEH	 H9FuL;f#	  HFIJ|HI+L;f	  I>IHIHAHH  HL$XHH|$XHt
HuHAP0H H
 3H	 HH$  HtH HSHH$  H$  HAL   MtHY AH,L@@MtHA H AHH. @	 HH  H$  HuHAP0H Hw	 H$  H<  H H
 H׬	 HHD$0HtH HMRHHD$0H  HFL   MtH HAHHD$ <L@@MtHu HH AHHD$ HZ Ha	 HHD$ H0  Hu
HFHP0H HL$X	 HHD$0H  H
.	 HsH|$8H9.  LCLD$8M  H[HD$ I HH HH\$ uH@P0HT$0LD$8Hū	 HsH9urE3L$   H$   H$   EAHRHD$(H+  HD$8H u
HPHR0HL$03HH\$8uHAP0H\$0H\$       w	 HHD$HH0  HL$8E3HHHD$03HL$8HL$0HHB ]THD$(H  HL$HHuHAP0H|$H-H>VHD$(HB  HL$0HuHAP0H|$0Hu	HHP0   Ϫ	 HHD$ H  H$  H
 E3HCHD$(HHC 3H$  SHD$(Hc  Hu
HCHP0H@	 HuH|$ H9)  HUHT$ H  H]HHHHHuHAP0HT$ H	 HsH9umHD$(E3H$   H$   EAHH$   PHH  HL$ HuHAP0HL$(3HH\$ uHAP0H\$(      	 HH$  H  HD$ 3E3HAHD$(HT$ HT$(HHA HzRHHv  H$  HuHAP03H$  5H\$(HHMTHH  Hu
HCHP0HD$(    HE u	HHP0IM3I9M ~HIEH<HAIEHIs	 9  Hu
HGHP0H$   3HMb
 L$   
   H
 j 7    Hb
 L$   
   H
 ; 07  u  Ha
 L$   e
   H
  *7  F  Ha
 L$   6
   H
  S7    Ha
 L$   
   HX
  i7    Hba
 L$   
   H)
  c7    H3a
 L$   
   H
 P o7    Ha
 L$   z
   H
 ! L7  [  H`
 L$   K
   H
  >7  ,  H`
 L$   
   Hm
  67  
  Hw`
 L$   
   H>
  7  
  HH`
 L$   
   H
 e 7  
  H`
 L$   
   H
 6 7  p
  H_
 L$   `
   H
  7  A
  H_
 L$   1
   H
  6  
  H_
 L$   
   HS
  6  	  H]_
 L$   
   H$
 z 6  	  	 HtHۧ	 HHqtYn	 Hu
HFHP0H$   E3MLl$`&yVH^
 Y
    }7  H
 	  H^
 L$   *
   H{
  6  	  t	IE E
  H$   HI H;
	 u>H
+	 HT	 H	3	 LL^
 
   L
 q 7  d	  H
 	 LHu'H^
 
   < 7  H
 o     %	 HHu*H]
 T
    7  H
 L2  I$H
X
 E3HL`Lh LLHu*H]
 
     7  HK
 L  Hu
HFHP0IEH;	    H;	    HIH$   	 H$   Hu/H]
 L$   
   H
 )  7  c  H@H   Ht$xHuQH\
 L$   >
   H
 
 7    IE 33ML$   Ht$xH$   L$   IE u
IEIP0ILHL$hHuoH$   H	 H9Fu0H;^  HFHLLlH$   IE HHL$h;H;^  L)HLIE HH$   HL$hILH  IEH	 H;   H;	    I	 HH$  H?  IE uIEIP0H$  HA3H   HH  L$     IHH  IӍVH6Y  I$uID$IP03H$  @IMH  H;u
I}Im IEH8HhHHE IE u
IEIP0HL$pHH\$pHt
HuHAP0HL$@3Hl$@Ht
HuHAP0HC3H;Ο	 tYH;͟	 tPHIF	 LH0  H@L   Mu3HKZ
 
   w
 8  H
   HE3LE3OtMuGHV	 I9Eu M;e  IEIJlHE I,M;e  I.IHE IIAHH  HL$PHl$PHt
HuHAP0HH	 HH  HxHwhH   H~     HD$@H;	 t"H&HHu	 H  3Hy>HHt6HHxHy'Hy"3H
	 H	]	 @  W	 IHHV HUHpH  H   Hp	 HL$@L2	 HH  HHWHHu
HSHR0H  HE u
HEHP0H\$pHT$PLH3	 E  Hu
HGHP03	 Ht Hߠ	 HHj  n	 IE H$   HL$hHt$xL$   IEIP0HL$hzHW
 L
   
 7  H
 U  L$  I$uID$IP0E3
uHMHyW
 
   
 8  H>
    HRW
 
   ~
 7  H
   H+W
 
   W
 8  H
   HW
 L$   z
   H
 !
 J8  [  L@H
	 H
 M@H	͟	 3HV
 L$   *
   H{
 
 G8    HV
 L$   
   HL
 
 E8     HVV
 L$   
   H
 s
 58     H~H
	 H
 A   H		 
HxKHU
 v
   $
 7  H
 Z	 Hn  H}	 HHgt	 H$   M  HU
 
   
 7  Ha
 MtIE u
IEIP0L$  L$  HtHu
HGHP0MtIu
IFIP0MtI$uID$IP0HtHE u
HEHP0HL$(Ht
HuHAP0HL$0HtHuHAP0Ld$`Ld$`HL$ Ht
HuHAP0HL$8Ht
HuHAP0HL$HHt
HuHAP0L
\
 D
 
 H
	 sbE3$H$   Hu
HFHP0Ld$`MI$L$   L$   H$   H$   H$   H$   MtI$uID$IP0HL$pL$   Ht
HuHAP0HL$@Ht
HuHAP0HL$PHt
HuHAP0HD$XHtH u
HPHR0IL$   H   +H8LJL	 E3H;Ǚ	 A3M;A   MuH
	 H_
 H	ƛ	 FL;u	 uL;
	 t]L;
	 tTIAH
	 MJH	L	 H9
 HD$ 	 H
R
 
 #  
 [A  3H
Z
 H8H8l@SUVWATAUAVH H	 3L0H\$`HMn`MfhInpH\$hHH\$pMtIE MtI$HtHE   H4	 INHL
Q
 L   AAN  L

 F
 D
 I;trH'  I@   s
I35HAH;	 t!      t
   rI	 3<b   L
-
 
 D
 DH
	 A>_LL$pLD$hHT$`IVy
   ?
 [N  ^H
 H

 E3G@HHu
 gN  *E3E33HcLHu
HCHP0
 kN  '
   HP
 H\$`Ht$hH|$pHb
 LMIIUHtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L

 D
 ^
 H
	 "^H A^A]A\_^][MtIE u
IEIP0MtI$uID$IP0HtHE u
HEHP0H A^A]A\_^][H(IL$0	 Hu9L
O
 D@PH
	   
 P   
   L
8
 c]3H(+H(Ht	H(鎎H
_	 Hh	 H		 H(@SH HHt
H [(H	 H HAHHIH9 uHAP0H_	 HC3H [@SH HHt
H [H!	 H HA HHI H9 uHAP0H	 HC 3H [H(A(	 Hu9L
N
 D@TH
	   
 T   1
   L

 [3H(H(Ht	H(H
	 H	 H		 H(@SH HHt
H [XH!	 H HA8HHI8H9 uHAP0H	 HC83H [H(AH	 Hu9L
M
 D@XH
	   
 X   1
   L

 Z3H(H(Ht	H(H
	 H	 H		 H(@SH HHt
H [XH!	 H HA`HHI`H9 uHAP0H	 HC`3H [@SH HHt
H [H	 H HA HHI H9 uHAP0H	 HC 3H [H\$Ht$WH03Hty'HK
 *
    
 >\  Hq
   3đ	 H}
 Hu'HqK
 
    
 ?\  H6
   H
	 3j	 H
 Hu'H/K
 
    [
 @\  H
 i  H
g	 30	 H
 Hu'HJ
 k
    
 A\  H
 '  sy'HJ
 ;
    
 L\  H
   Hf
 H
	 E3E3D$   	 H
 HE  H HW	 HX
 Hu'HLJ
 
    x
 g\  H
   H%
 H
n	 H 	 Hn
 Hu'HJ
 
    .
 i\  H
 <  H
;	 	 H
 Hu'HI
 @
    
 j\  H
   L
 H

 H	 	 y'H|I
 
    
 n\  HA
   y'HLI
 
    x
 p\  H
   95j
 tFL
 H
N
 H	 	 y'HH
 |
    *
 u\  H
 8  Iy'HH
 L
    
 \  H
   Y,y'HH
 
    
 \  Hc
   H'_
 H	 y'HcH
 
 E   
 \  H(
   H
t
 H	 LH5_
 	 y'HH
 
 E   F
 \  H
 T  H
 H<f
 Hk	 y'HG
 V
   
 \  H
   H

 HJ	 LH5(f
 *	 y'HG
 

   
 \  HT
 
  H 
 HAg
 H	 y'HMG
 
 f   y
 \  H
 
  H
 Hh
 H50g
 H	 y'HG
 
 i   0
 \  H
 >
  H
 Hi
 H5wh
 HN	 y'HF
 9
   
 \  H
   HD
 Hk
 H5i
 H	 y'HrF
 
   
 \  H7
   H	 H
	 E3Ah  H5j
 H
 pH
 Hu'H-F
 
 	   A
 \  H
 O  E3H	 H
	 EA`KpH<
 Hu'HE
 F
    
 \  H
   Hy	 H
~	 E3AH
  oH
 Hu'HE
 
    
 \  H>
   HB	 H
G	 E3A0  oH
 Hu'H2E
 
    V
 \  H
 d  E3H	 H
		 EAP`oHi
 Hu'HD
 [
    	
 \  H
   H	 H
	 E3A   oH"
 Hu'HD
 
 u  
 \  HS
 
  yly'H^D
 
    
 \  H#
 
  u'H-D
 
 #   Y
 \  H
 g
  H

 A3KHHu'H
C
 j
 &   
 \  H

 	  H
 H

 LU	 y/
 &   
 \  	  Hu
HCHP0H

 A3JHHu
 '   
 \  w	  Hn
 H
G
 Lވ	 y
 '   f
 \  C	  Hu
HCHP0H

 A3JHHuu
 (   #
 \   	  H
 H

 Lg	 yA
 (   
 \    Hu
HCHP0H

 A3IHHu
 *   
 \    H
 H
Y
 L	 y
 *   x
 \  U  Hu
HCHP0H

 A31IHHu
 ,   5
 \    H
 H

 Ly	 yS
 ,   
 \    Hu
HCHP0H

 A3HHHu
 -   
 \    HJ
 H
k
 L	 y
 -   
 \  g  Hu
HCHP0   	 HHu
 .   N
 ]  +  HZ
 AHH HKHE
 HH
 H HKH
 HAH

 GHHu'H
@
 4
 .   
 ]  H
{
   Hu
HCHP0H
 HIHHu
 .   
 ]  x  H
 H
H
 L߅	 y
 .   g
 ]  D  Hu
HCHP0H
 HHHHuy
 .   '
 ]    H
 H

 Lk	 yE
 .   
 ]    Hu
HCHP0Hu
HGHP0   s	 HHu'Ht?
 
 /   
 #]  H9
   H%
 AHH HOH
 HH
 H HOH
 HAH
 H HOH
 HAH,
 H HOH
 HAH
 H HOH
 HA H

 EHHu;
 /   
 4]    Hu
HGHP0He
 HGHHu
 /   
 7]    H5
 H
V
 L	 y
 /   u
 9]  R  Hu
HGHP0H
 HFHHu
 /   5
 ;]    HQ
 H

 Ly	 yS
 /   
 =]    Hu
HGHP0H
 H-FHHu
 /   
 ?]    H]
 H
n
 L	 y
 /   
 A]  j  Hu
HGHP0Ha
 HEHHu
 /   M
 C]  *  H1
 H

 L	 yk
 0   
 E]    Hu
HGHP0H
 HEEHHu+
 /   
 G]    HU
 H

 L	 y
 0   
 I]    Hu
HGHP0HHu
HCHP0H
V
 0HHu
 2   U
 T]  2  H@H
 HL   MtAL@@Mt	H Aق	 HHuO
 2   
 V]    Hu
HCHP0H
 E3H*HHu
 2   
 Y]    Hu
HGHP0HF
 H
W
 LH	 y
 2   s
 \]  P  Hu
HCHP0Lg
 H
0;
 3H	 HHu~
 l  ,
 f]  	  H
 H

 Lp	 yJ
 l  
 h]     Hu
HCHP0L
 H
M;
 3́	 HHu
 o  
 r]     H%
 H
^
 L	 y
 o  }
 t]  ]Hu
HCHP0%	 HHuS
 |]  )Hj
 H

 L	    (
 ~]  f
    H9
 H
 HtHu
HCHP0HtHu
HGHP0H

 H   H95
 t#L
f
 D
 H
	 3GH

 HuHAP0H5
 H\$@Ht$HH0_Hu^HCHH\$@Ht$HH0_H`0H9
 
    K
 e\  H
 	 HuH
ʁ	 Hk	 H		 H\$@Ht$HH0_\H\$Hl$VWATH@H'	 HzILH\$pHM   HtH   HZH\$pIc~	 HHu)H  H
 H
~	 HtHHD$pHH   H	 LL$pH.
 HD$(E3HH|$ 0y
'     H\$p   H   H   Hy3L
	    L
	 HH	 H|$0H	 Ll	 HDH	 HD$(HL$ H
 ~	 H	_	 '  L
C7
 H
<	 A  p
 
   L

 *E3HZHI'^H\$`Hl$hH@A\_^LI[IkIsI{ ATAUAVH`H=l}	 H-{	 H5{	 LbI{IkIsMLIM%  Mt0Ht!HtH1  Hr(IsHj Hl$HHzH|$@Iv|	 HIMtHt1HtT{H  H
 I|	 HtHHD$@HHg  H
 I{	 HtHHD$HHH>  Hs
 I{	 HtHHD$PHH  H	 LL$@H
 HD$(E3ILd$ 9.y
)     Ht$PHl$HH|$@   M   H   H   H   My3L
	    L
	 HH	 Ld$0H	 L	 HDHk	 HD$(HL$ H
{	 H	}	 )  L
4
 H
	 A  
 @
   L

 B3Hr(Hj HzLLHIkL\$`I[ Ik(Is0I{8IA^A]A\H\$Hl$VWATH@Hgy	 HzILH\$pHM   HtH   HZH\$pI3z	 HHu)H  H
 Hy	 HtHHD$pHH   H	 LL$pH.
 HD$(E3HH|$ Y,y
5     H\$p   H   H   Hy3L
	    L
	 HHŖ	 H|$0HO	 L\	 HDH	 HD$(HL$ H
y	 H	/|	 5  L
3
 H
<	 A  @
 ~
   L

 @3HZHI藸H\$`Hl$hH@A\_^H\$Hl$VWATH@Hw	 HzILH\$pHM   HtH   HZH\$pIx	 HHu)H  H
 H*x	 HtHHD$pHH   HZ	 LL$pH
 HD$(E3HH|$ *y
o6     H\$p   H   H   Hy3L
	    L
	 HH	 H|$0H	 L	 HDH	 HD$(HL$ H
@x	 H	z	 }6  L
c1
 H
	 A  
 
   L

 J?3HZHI'H\$`Hl$hH@A\_^H(Ht	H(H
/x	 H0	 H	y	 H(DL$ DD$T$L$SUVWATHp  HD$@AA؋/H
 HD$ L
 L$  HX	 H
a
  ̅y/H
 HD$ L
 L$  HE	 H
.
  ̅/H
 HD$ L
 L$  H*	 H

 趫 E/Hi
 HD$ L
U
 L$  H	 H
ǲ
 肫 fnP O D,G;tt
m     DBHL$pTq	 H$  H$   q	 H	 H$   a IcHL$0p	 H$   LcAJ   HPH$   p	 HH˗	  Hȋwp	    HL$0o	 HH9	 H$    HHu3
HHcIHHVkdřH!p	 HH	 誛 H	 H	 $   HEH$   胛 H$  H$   }p	 HT$HHL$p=p	 H$  LHAHL$Hp	 HL$pp	 Hp  A\_^][@SH H3
 H

 H+
 H|Q H+HH [H\$Hl$Ht$WATAUH0HyXHq(Hi(MLLHT$ H HH HtH;tq	 H9{u2SHT$ MH HHHup	 HHu3HH@0H9Cup	 HSIH@]o	 H\$PHl$XHt$`H0A]A\_@UVWATAUAVAWH  HǄ$   H$  LE3IL|$`L|$hL|$pH$   cn	 H$   Tn	 MML$  L$  E3Hs
 H

 LHu'HX,
 H1
 
 y   }
   M  HH$  LphAACAFACINHHu'H,
 H
 x
 }   &
 7  
  LHL;
q	 tIMIL!	 H"	 H
r	 H	t	 L+
 L
 "
 }   
 9  
  HFHHNL9!uHAP0H~IN8'HHu'HX+
 H1
 
 ~   }
 G  M
  LHL;
up	 tIMIL	 H	 H
q	 H	t	 L+
 L
 y
 ~   '
 I  b  HF HHN L9!uHAP0H~ AFhF(3o	 Hu'H*
 H
 
    
 a    HHD$`I   I;   v
n	 IFpHD$PH\$X(D$PfD$PHt$PH|$X    I   I9   vm	 HtI;vptm	 AH;  Hum	 MLI;{ rm	 HG H+GHHH$   Huhm	 MLI;{ rTm	 H_H;_ vDm	 HHu6m	 MLI;[ r"m	 L|$@D$8  D|$0H\$(L|$ A   L$   AQHu
 HH  HH   HL$hHD$hHt
HuHAP0LEHM HHAL;AI;tHHEJI@HEHHo	 t(Hufl	 MLI;{ rRl	 H0iH(
 H{
 
    
   H$  
  Hs(
 HL
 
    
   H$  `
  33m	 HHu'H4(
 H

 
    Y
   	  I   I;   vk	 I   HD$PH\$X(D$PfD$PIHt$PHl$X
II   I9   vLk	 Ht	I;   t8k	 H;  Hu$k	 MLI;k rk	 HH$   i	 Huj	 MLI;k rj	 H(H$   H$   ni	 H$   H$   i	 HH$   H@H{ rHKHKII;}HH33l	 L'H=n	  tE3n	 LE3E3l	 LHQi	 Mt|HOH9O ~I$HGL$HAHGIHhm	 u%I$ID$IP0IH@&
 H
 
    e
     H&
 H
 
    >
   y  H|$pH

 LHu*H
%
 H

 P
    
   I]  H@L   MtH
 IAL2L@@MtHl
 H IALHV
 Iel	 LMu*HV%
 H/
 
    {
   I  I$uID$IP0   Vk	 LHu*H%
 H
 ~
    ,
   I  HHxHD$`H ID$ E3IH
s
 HH$  Hu*H
$
 H

 
    
   I+  I$uID$IP0MIuH|i	 H9y  MeMl  I]I$HILHuHAP0HsH-j	 H9   L$   H$   E3EAH$   HHHu'H#
 H
 ]
    
   F  I$uID$IP0MHE u
HEHP0L$       i	 HH$  Hu'H
q#
 H
J
 
    
     L`MHh L$  E3HHHHu'H!#
 H
 
    F
     H$  HuHAP0L$  SHIGHHu'H"
 H
 ?
    
   (  HE u
HEHP0L$  IE u	HIP0MH$  HF0HHN0L99uHAP0H~0Ip  
HHu'H>"
 H
 
    c
     HF@HHN@L9)uHAP0H~@A  FHI  H$(  d	 HH$   H@H{ rHKHKIII;}HH33g	 H'H=i	  tE3i	 HE3E3sg	 HHd	 Hu'H[!
 H4
 Ҿ
    
 7    HFPHHNPH9 uHAP0H~PI  HHu'H!
 Hݽ
 {
    )
 F  d  HFXHHNXH9 uHAP0H~X3e	 HHu'H 
 H
 (
    
 U    I  I;   vd	 I   H$   H$   ($   fD$PHt$PHl$Xffff     I   I9  vc	 Ht	I;   tc	 H;D  Huc	 MLI;k rc	 HH$   %b	 Hurc	 MLI;k r^c	 H(H$   H$   a	 H$   H$P  Fb	 HH$   H@H{ rHKHKIII;}HH33Be	 L'H=Ug	  tE3Jg	 LE3E3!e	 LHa	 MtnHOH9O ~IE HGL,HAHGIHe	 uIE IEIP0H
 H
 6
    
 `  "H
 Ht
 
    
 ^  HtHu
HGHP0H$  H$  MtI$uID$IP0MtIE u
IEIP0H$  Ht
HuHAP0HtHu
HGHP0H$  H$  L
ĺ
 De
 
 H
	 +*H$  HF`HHN`H9 uHAP0H~`HLHtHu
HFHP0HL$`Ht
HuHAP0HL$hHt
HuHAP0HD$pHtH uHPHR0H$   _	 H$   _	 IH$  HĀ  A_A^A]A\_^]H\$Hl$Ht$H|$ ATHPH      ?)t$@HAH=
 H5
 HH;vW`	 H=
 H5
 HZ
 H
 Hl$(H+?
 H\$ (t$ HuH;v
`	 H
 H\$ Ht$(ZH

 H+ft$ H? H0H+Hu_	 E3LH| I;{ wHtH3H;xs_	 H|$((D$ HL$ HT$0fD$ HHHA)t$ H|$ H\$(HBLd$8Hl$0HtH;tY_	 L;   ft$0Hu?_	 E3LI;[w+_	 HD$0HsHu_	 E3LI;s r_	 HHPHu^	 E3LI;[w^	 HH\$((t$ `H\$`Hl$hHt$p(t$@H|$xHPA\@SH   HD$ H
 H+
 HtNHy	 HL$(V]	 HL$P^	 H`
 HD$PHT$(HL$hU]	 H HL$P: H

 ; H

 ; 3HA
 H
2
 H+HHtKfD  H;r
]	 H

 LMtI    IH

 HH
 H+HH;rH

 ; H
     H]
 H
N
 H+HHu
t]	 H
5
 HH
 H\
 H
M
 H+HHuC]	 H\
 H
-
 HHH
?
 HĐ   [@SH   HD$ H
 H+ 
 HuNH1	 HL$([	 HL$P
]	 HJ_
 HD$PHT$(HL$h[	 H HL$P9 H

 < E3HH

 c L
 IH+{
 HtILp
 H

 L< E3HH

 Jc L
 IH+
 HtIL
 H

 
< HH8
 H
)
 H+HH;sEH;r
[	 H

 LMtI    IH

 HH
 H+HH;rH
a
 ; E3HH

 b Lc
 IH+Q
 HtILF
 H

 HĐ   ["[ H\$ WH0H
 H=8
 3H+
 HHT$@HuLL%
 L+IH

 Hl$HHt$PHH+HI;sHAHH
    HH;vZ	 H

 H=
 H
 HHt$(H+HHT$ HuH)H;v
}Z	 Hn
 HtH;tfZ	 H+H(D$ LL$@HT$ H
A
 A   fD$ C H-A
 H;-B
 v"Z	 H=
 HuZ	 LLHL I;K wHtHHH;HsY	 H
 H=>
 H+
 HHT$@HuLL-
 L+IH

 HH+HI;sHAHH
    HH;vwY	 H

 H=
 H
 HHt$(H+HHT$ HuH)H;v
7Y	 H
 HtH;t Y	 H+H(D$ LL$@HT$ H
S
 A   fD$ A H-S
 H;-T
 vX	 H=%
 HuX	 LLHL I;K wHtHHH;HsX	 H
 H=h
 H+
 HHT$@HuLLW
 L+IH
A
 HH+HI;sHAHH$
    HH;v1X	 H

 H=
 H
 HHt$(H+HHT$ HuH)H;v
W	 H
 HtH;tW	 H+H(D$ LL$@HT$ H
}
 A   fD$ |@ H-}
 H;-~
 vW	 H=O
 HuW	 LLHD I;C wHtHH;Cs]W	 Hf
 H
w
 ږ Hc
 H

 ǖ HH
 H

 Ht$PHl$HH\$XH0_頖 @WH@HD$ H\$XHl$`Ht$h)t$0IIf(HH
 HH0H
 H;
 r0   H
V
 Q HH\$PHt)f(H LY
 LHkHs HD$pHC(3HHH\$XHl$`Ht$h(t$0H@_HVWATAUAVH   HD$ HXHh)p)xD)@D)HD)PIHLL$    H=
 LIH=
 H;=
 rIH
~
 y LH=
 Ht2IHI+Hffffff     HHHHuH=
 fWf(3H|EHVLCIIJ    HBXpHBXpHXpHBXpH IuH;sHXpHH;rfEL*;
 HyDXA^3H|tLFHSHHH    I@@\YXI@H\YXI @\YXI@H\YXI HuH;sH@\YXHH;rHCfEL*HyDXf(A^(0 fD(HIH=F
 H;=7
 rIH

  HH=$
 
$
 f/vEfA(/ 
$\
 ^$   H  HH$   HHH=
    EY[
 A^E3H   H~HMLL+HSHHL    HG@\YAI	H\Y	HG@\YAHH\YIH H HuH=%
 L;s4JT H+HI+H2@\YHHuH=
 HH0H=
 H;=
 r0   H
Y
 T HH$   Ht%fA(H H@
 HH^Ln Hn(3I6IL$   I[8Ik@(t$p(|$`E(CE(KE(SIA^A]A\_^HT$HL$SUVWATH0HD$ HHE3Dd$pHz H+zHAL$o. HtH0IHDd$pLD$pHH` IHC H+CHHtVD  HC H+CHH;rQ	 HkHF H+FHH;rnQ	 HND HHC H+CHH;rHKHt- LcLc Lc(H- HH0A\_^][HHHUVWATAUAVAWH   HD$ HX)p)xHH@       [- Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN- HtH3HHC    HC     HC(    Ǆ$      HGH;Q	    H;Q	 t{IHmT	 HHu+L

 L
_
 A/   D
 KQ  
   H@L   Mu4L
[
 L
$
 A/   D
 MQ  l
 }  HE3E3Nl=j
 MuEHLQ	 H9GuL;g|  HGJHII,L;g^  I] HIIHAHH  ILHt
HuHQR0HP	 H9Cus$   H>S	 f($   f.zuR	 H!  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$pHH;vN	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;vkN	 HT$PHtH;tVN	 H+H(D$0fD$@L$   A   HT$@HL$P0 Hl$hH;l$pvN	 H\$PHuN	 E3LHL I;K wHtH3H;H,M	 !L
:

 L

 A0   D
 xQ  K
 H$   WP	 Ht~HR	 HHt:O	 `L
	
 L

 A/   DE
 hQ  
 H$   HuHGHP0L
s
 D
 Ƭ
 H
߱	 %Hu
HGHP0HT$PH$   HP MtIuIFIP0HL$hHt:) HD$h    HD$p    HD$x    HL$P) HL$   I[HA(sA({IA_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       ( Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN( HtH3HHC    HC     HC(    Ǆ$      HGH;aM	    H;\M	 t{HHO	 HHu+L

 L
Ǥ
 A/   Db
 Q  
   H@L   Mu3L

 L

 A/   D'
 Q  Ԫ
 Q  H3E3LlfMuEHL	 H9GuH;oX  HGHHHI,H;o:  I] HHIHAHH  ILHt
HuHQR0H$HH$   HuM	 H  H\$hHu3HT$xH+HHL$pHH+HH;sH1HAHD$p%HH;v7J	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;vI	 HT$PMtL;tI	 H+H(D$0fD$@L$   A   HT$@HL$P2 Ld$hL;d$pvI	 H\$PHuI	 E3LII;K wHtH3H;HPjI	 EL

 L

 A0   D2
 Q  ߨ
 H$   WGL	 Ht~H;N	 HHhtJ	 `L
u
 L
>
 A/   D٢
 Q  
 H$   HuHGHP0L

 D
 Z
 H
	 %Hu
HGHP0HT$PH$   HgL MtIuIFIP0HL$hHt$ HD$h    HD$p    HD$x    HL$P$ HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMI Ǆ$     IANH$ Ht
HL$PHIHD$PLt$hLt$pLt$x   $ Ht
H$   HIH$   L$   L$   L$   HCH
H	 H;a  H;H	 T  HaK	 HHu'H
 HS
 
    
 LR     H@L   HAHHtjA   HAHHtVHAHAVy$H
 
 H

 
    5
 SR  aHU  HCHP0E3F  Hu
HCHP03uIDH
 H
 $
    ҥ
 [R  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   H	 H
H	 H	!K	 2Mx-Hne	 L
w	 ILDH	 H
H	 H	J	 H
 H
 M
    
 8R    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$PH HL$8Htl! Lt$8Lt$@Lt$HHL$ S! G	 Ht$HE
 H
 
    Z
 jR  tHHL$ ;HH$   zH HL$8Ht  Lt$8Lt$@Lt$HHL$   G	 HtGH 
 H
 6
    
 kR  L
}
 D
 У
 H
Y	 ;  H$   H$    HHT$PHL$ x  HH$   g  HH$   V  H$   IG IO0H$   G H$   Ht
  L$   L$   L$  H$    H$   Ht L$   L$   L$   H$    HL$8Ht Lt$8Lt$@Lt$HHL$  H$(  Htu L$(  L$0  L$8  H$  P MtI$uID$IP0HtHE uHEHP0H$   Ht L$   L$   L$   H$    HL$hHt Lt$hLt$pLt$xHL$P IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@        Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3ANF HtH3HHC    HC     HC(    Ǆ$      HGH;!C	    H;C	 t{HHE	 HHu+L
 L

 A/   D"
 R  Ϡ
   H@L   Mu3L
 L
L
 A/   D
 R  
 M  H3E3LlfMuEH|B	 H9GuH;oT  HGHHHI,H;o6  I] HHIHAHH  ILHt
HuHQR0Ht$   uhC	 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v?	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;v?	 HT$PMtL;t?	 H+H(D$0fD$@L$   A   HT$@HL$P* Ld$hL;d$pvl?	 H\$PHu\?	 E3LII;K wHtH3H;HT.?	 IL
 L
[
 A0   D
 R  
 H$   WB	 Ht~HC	 HH,
t@	 `L
9 L

 A/   D
 R  J
 H$   HuHGHP0L
˗
 Dl
 
 H
	 %Hu
HGHP0HT$PH$   H MtIuIFIP0HL$hHt HD$h    HD$p    HD$x    HL$Pm HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMI Ǆ$     IAN Ht
HL$PHIHD$PLt$hLt$pLt$x    Ht
H$   HIH$   L$   L$   L$   HCH
>	 H;a  H;>	 T  H!A	 HHu'HJ H
 
    _
 6S     H@L   HAHHtjA   HAHHtVHAHAVۯy$H
 H

 G
    
 =S  aHU  HCHP0E3F  Hu
HCHP03耮uIH} HF
 
    
 ES  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   Hٯ	 H
>	 H	@	 2Mx-H.[	 L
hm	 ILDHկ	 H
v>	 H	@	 H Ho
 

    
 "S    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$P HL$8Ht, Lt$8Lt$@Lt$HHL$  =	 Ht$H HΓ
 l
    
 TS  tHHL$ HH$   :> HL$8Ht Lt$8Lt$@Lt$HHL$  C=	 HtGH HX
 
    
 US  L
=
 Dޓ
 
 H
	 T;  H$   H$  J HHT$PHL$  HH$    HH$    H$   I5 IO0H$   T= H$   Ht L$   L$   L$  H$    H$   Ht L$   L$   L$   H$   q HL$8Hta Lt$8Lt$@Lt$HHL$ H H$(  Ht5 L$(  L$0  L$8  H$   MtI$uID$IP0HtHE uHEHP0H$   Ht L$   L$   L$   H$    HL$hHt Lt$hLt$pLt$xHL$P IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       C Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN HtH3HHC    HC     HC(    Ǆ$      HGH;8	    H;8	 t{IHU;	 HHu+L
~ L
G
 A/   D
 S  
   H@L   Mu4L
C L

 A/   D
 S  T
 N  HE3E3NlMuEH<8	 H9GuL;gU  HGJHII,L;g7  I] HIIHAHH  ILHt
HuHQR0H$$   u(9	 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v5	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;v5	 HT$PHtH;tm5	 H+H(D$0fD$@L$   A   HT$@HL$P^  Hl$hH;l$pv,5	 H\$PHu5	 E3LHL I;K wHtH3H;HS4	 HL
Q L

 A0   D
 *T  b
 H$   W7	 Ht~H9	 HHtQ6	 `L
 L

 A/   D\
 T  	
 H$   HuHGHP0L

 D+
 ݓ
 H
	 %Hu
HGHP0HT$PH$   H MtIuIFIP0HL$hHtQ HD$h    HD$p    HD$x    HL$P, HH$   HĀ   A_A^A]A\_^]H\$Ht$H|$ ATH`HQ Igfffffff3H+QIHHHHH?H}   Hl$pHfH;r53	 HsHnU	 A   HE3H1	 HH2	 L L;t	H1	 HK IHH+KH(HHHH?HH;rHl$pH{ H9{v2	 HHsH|$(HD$ (D$ fD$ H;s v2	 HH@ H{HH;{ vw2	 HL$ HtH;tb2	 HL$0w0	 H+LIHHHH?HHu L\$`I[Is I{(IA\HT$SH0HD$ HfWD$PHT$PvN u]M D$P2H0[HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   v/	 H$   g/	 HT$`HK7 HHL$  H\$xHt.H$   H;tfH0	 H(H;uH\$xH]
 Ll$xL$   L$   HL$`>
 32	 HHu'H H
 
   @
 >    H\$8H;\$@v0	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v>0	 HtH;t$ t,0	 L;  Hu0	 MLM;c r0	 IH$   .	 Hu/	 MLM;c r/	 I(H$   H$   b.	 H$   HL$`.	 HH$(  H@H} rHMHMII;}HH331	 H'H=3	  tE33	 HE3E31	 HHH.	 HtlHOH9O ~HHGHHAHGHH`2	 uHHCHP0HD H
 
   i
 >  "H  H
 
   E
 >  Hu
HGHP0HtHu
HCHP0L

 DZ
 
 H
	 IHHuHGHP0H$   I-	 H$   :-	 H\$8Ht.Ht$@H;tD  H-	 H(H;uH\$8H]
 Ll$8Ll$@Ll$HHL$ D
 HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ   
 E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   f+	 H$   W+	 HT$`HK4 HHL$ 
  H\$xHt.H$   H;tfH,	 H(H;uH\$xHM	 Ll$xL$   L$   HL$`.	 3
.	 HHu'H H
 
   0
 ?    H\$8H;\$@vy,	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v.,	 HtH;t$ t,	 L;  Hu,	 MLM;c r+	 IH$   *	 Hu+	 MLM;c r+	 I(H$   H$   R*	 H$   HL$`*	 HH$(  H@H} rHMHMII;}HH33-	 H'H=/	  tE3/	 HE3E3-	 HH8*	 HtlHOH9O ~HHGHHAHGHHP.	 uHHCHP0H4 H

 
   Y
 ?  "H H
 
   5
 ?  Hu
HGHP0HtHu
HCHP0L

 DJ
 
 H
e	 IHHuHGHP0H$   9)	 H$   *)	 H\$8Ht.Ht$@H;tD  H)	 H(H;uH\$8HM Ll$8Ll$@Ll$HHL$ 4 HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   V'	 H$   G'	 E3E3HT$`HK" HHL$  H\$xHt,H$   H;tH'	 H(H;uH\$xH9 Ll$xL$   L$   HL$` 3)	 HHu'H HЁ
 n
   
 @    H\$8H;\$@ve(	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8v(	 HtH;t$ t(	 L;  Hu'	 MLM;c r'	 IH$   {&	 Hu'	 MLM;c r'	 I(H$   H$   B&	 H$   HL$`&	 HH$(  H@H} rHMHMII;}HH33)	 H'H=+	  tE3+	 HE3E3)	 HH(&	 HtlHOH9O ~HHGHHAHGHH@*	 uHHCHP0H$ H
 
   I
 @  "H  H
 w
   %
 @  Hu
HGHP0HtHu
HCHP0L

 D:
 
 H
u	 IHHuHGHP0H$   )%	 H$   %	 H\$8Ht.Ht$@H;tD  H$	 H(H;uH\$8H= Ll$8Ll$@Ll$HHL$ $ HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   F#	 H$   7#	 E3E3HT$`HK HHL$  H\$xHt,H$   H;tH#	 H(H;uH\$xH) Ll$xL$   L$   HL$`
 3%	 HHu'H H}
 ^~
    
 A    H\$8H;\$@vU$	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8v$	 HtH;t$ t#	 L;  Hu#	 MLM;c r#	 IH$   k"	 Hu#	 MLM;c r#	 I(H$   H$   2"	 H$   HL$`"	 HH$(  H@H} rHMHMII;}HH33%	 H'H='	  tE3'	 HE3E3t%	 HH"	 HtlHOH9O ~HHGHHAHGHH0&	 uHHCHP0H H{
 |
    9
 'A  "H H{
 g|
    
 %A  Hu
HGHP0HtHu
HCHP0L
{
 D*|
 ܁
 H
Ձ	 IHHuHGHP0H$   !	 H$   
!	 H\$8Ht.Ht$@H;tD  H 	 H(H;uH\$8H- Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HHHUVWATAUAVAWH   HD$PHXHLE3DxAO Ht
HL$ HIHD$ L|$8L|$@L|$HM    HtL0IIM~M~ M~(Ǆ$      HL$X	 HCH;{"	    H;v"	 t{HH$	 HHu+L
 L
y
 A/   D|z
 S  )
   H@L   Mu4L
 L
y
 A/   DAz
 S  
 g  HIMHlMuEH!	 H9CuH;so  HCH<HHH,H;sQ  H} HHHHAHH   ILHt
HuHQR0HH$   HHL$XP	 H$   	 "	 Hu5HT$XH$   	 HHL$ ]` H$   n	 L
 L
x
 A0   D&y
 S  ~
 OC"	 HtvH7$	 HHdt 	 XL
q L
:x
 A/   Dx
 S  ~
 HuHCHP0L
x
 Dx
 ^~
 H
7	 "Hu
HCHP0HT$ I MtI$uID$IP0HL$X	 H\$8Ht)H|$@H;tHb	 H(H;uH\$8H L|$8L|$@L|$HHL$  IH$   Hİ   A_A^A]A\_^]HT$WH0HD$ H\$PHHD$@    IH/ HH> HK	 H	 HH\$PH0_HT$WH0HD$ H\$PHHD$@    IH߽ HH> HKA	 H8	 HH\$PH0_LD$WH0HD$ H\$HIHD$@    I¾ HH= HO	 H	 HH\$HH0_HL@WHpHD$ HXHp )pIf(HǄ$       HHPIW H^3$   H\$(H$   HD$0HSHCHD$@HT$Ht$PHT$8HL$( HH< H	 H	 HL\$pI[Is((t$`I_HT$WH0HD$ H\$PHHD$@    IH HHE HK	 H	 HH\$PH0_HT$WH0HD$ H\$PHHD$@    IH_ HHE HK!	 H	 HH\$PH0_LD$WH0HD$ H\$HIHD$@    IB HHE HO	 H	 HH\$HH0_LD$WH0HD$ H\$HHt$XIHD$@    L$@HT$@IU HT$@HNU HHD HN&	 H	 HH\$HHt$XH0_++++HL@HHUWATAVH  )p)xD)@D)xD)hD)XD)HD)8D)BtB|IMLLFfEWA\Y5*
 D%*
 fA.D-R!
 z#u!D=E
 fA(fAT\DX  D=$
 f(f(fATfATf/fD($  EY$  v
H$  H$  DfE.z	ufA(@f/v
H$  H$   A^YAXJ L$  f(AYfE.z?u=fA/v   f(fn^X^fA(Y\DX$fA/wfAWXfA(D^A\DXI;EHE\E}  H$  H$  H$  H$  HI\L$  H,   L$x  HD)$   D5t2
 L,IIVHHI+L$  H$  L<    fE.z'u%fE/vfA(fA(  fA(fA(   fE.z"u fE/fA(v
fA(   fA(   fA(fA(fATfATf/v_fE(E^fA(AYAX fE/vfAWH$  L$  H$  fA(^IVf(AYfAWVfA(A^f(YAXC fE/vfAWH$  L$  H$  fA(^IVYfAWI;KAf(f(YYf(Y\YYYfD(X\XYYDYf(f(\YYAXf(YD\DS~f(f(YKAY\KH;}fD(YDYfEWH   HL$0Ht$8Ht$@fAWt$ HL$0H$   L$   |$(HH$   Hl$PHHAHt$XHBHAHL$0HBHHT$hHHALD$ HBHAH$   HBHT$PH$   H$    H$  L$  H$  IVHHMII;/D($   L$x  L$  H$  H$  L$  A(sA({E(CE(KE(SE(xE(hE(XE(8IA^A\_]HWH   HǄ$   HXHhHpHٹ   P 3Ht
HL$PHHHD$PHl$hHl$pHl$x    Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HKC HHL$P H$   HtLH$   H;t:HYHHt H+HkHkHKu H0HCH;uH$   [ H$   H$   H$   H$   6 HT$PHL$ K HL$ !uHHu<L
 L
k
 yl
   'r
 !@  !@  A  H
p	 HHL$8HtKH|$@H;t<HYD  HHt H+HkHkHK H0HCH;uHL$8 Hl$8Hl$@Hl$HHL$ k HL$hHtLH|$pH;t=HYfD  HHt? H+HkHkHK+ H0HCH;uHL$h Hl$hHl$pHl$xHL$P HL$   I[IkIs I_HWH   HǄ$   HXHhHpHٹ    3Ht
HL$PHHHD$PHl$hHl$pHl$x    Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HK@ HHL$PI H$   HtLH$   H;t:HYHHt H+HkHkHK H0HCH;uH$    H$   H$   H$   H$    HT$PHL$ 軽 HL$ rHHu<L
r L
Ki
 i
   o
 q@  q@  A  H
n	 PHHL$8HtKH|$@H;t<HYD  HHt H+HkHkHK H0HCH;uHL$8 Hl$8Hl$@Hl$HHL$  HL$hHtLH|$pH;t=HYfD  HHt H+HkHkHK H0HCH;uHL$h Hl$hHl$pHl$xHL$Pk HL$   I[IkIs I_[HHPHHSUVWATAUAVAWH  HǄ$   )pHHE3DpAN Ht
HL$PHIHD$PHL$PK H$   ƀ   H$   H@H$   H H$   H@L$   MLt$@H豉 Ǆ$0     IIM   s Ht
H$   HIH$   L$   L$   L$      4 Ht
H$   HIH$   L$   L$   L$   H$h  	 HCH;	    H;	 txIHq	 HHu'H Hcf
 g
 T  l
 0    H@H   HD$ Hu8HN H'f
 f
 T  sl
 2  e  HHMIHD$ NtHuDHT	 H9EuL;e|  HEJ<HII*L;e^  I>HIIHHH  ILHt
HuHAP03H=	 98uIG     IH
	 HH,  H@L   MtHj
 HAH2L@@MtHj
 H HAHHj
 H	 HH  Hu
HGHP0HFL   MtHGe
 HAH2L@@MtH,e
 H HAHHe
 H	 HH  Hu
HFHP0IH	 HH  H@L   MtHd
 HAL2L@@MtHc
 H HALHc
 H(	 LMD  Hu
HFHP0   A
	 HH  HxLh 3E3HL$@HD$@HtHu
HAP0H3HH$  GHHH$   $ HS0H$    H$P  Ht 3H$P  H$X  H$`  H$8  e H$   HtS H$   H$(  H$0  H$  . 	 H   IH$  iHH$h  9	 H$  	 	 H   H$h  HL$P聅 HH$   H.
 HK0H$   
 H$(  HD$ sHg
 H
-
	 H		 Lm LFb
 b
 U  h
 b    HF Hb
 b
 W  kh
   ]  H Ha
 b
 W  Dh
   6  H Ha
 ob
 V  h
 {    H Ha
 Hb
 V  g
 x     H Ha
 !b
 V  g
 v     H H\a
 a
 V  g
 s     H\ H5a
 a
 V  g
 p  vH8 Ha
 a
 V  ]g
 n  R
	 H  H	 HHtP		 k  H H`
 [a
 T  	g
 M  HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIE u
IEIP0H		 H(LuHLePLmX3HEHHEPHEXMtIMtI$MtIE MMIH   	 H
'O	 	 HHMHHuPH}XLuHLePLmXHt
HuHQR0HtHu
HFHP0HtHu
HGHP0HuH
^		 p	 He	 Hu
HCHP0L$      HE u
HEHP0HD$PL$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   I
 HT$PI0 MtIu
IGIP0HL$@HtHuHAP0H$h  u	 H$   Ht E3L$   L$   L$   H$    H$   Ht L$   L$   L$   H$   _ H$   HHD$PHHH\$8HD$0(D$0fD$ Hu	 H$   HD$PH;u^HHtH;t	 H$   H;u>HRHL$Pl L$   M[L$   H$   H H$   H@   H|$ H\$(fHtH;t0	 H;   (t$ Hu	     t	 gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$P2 =H$    L$   L$   HL$P I($  H  A_A^A]A\_^][HHPHHSUVWATAUAVAWH  HǄ$   )pHHE3DpAN| Ht
HL$PHIHD$PHL$P˒ H$   ƀ   H$   H@H$   H H$   H@L$   MLt$@H1~ Ǆ$0     IIM    Ht
H$   HIH$   L$   L$   L$       Ht
H$   HIH$   L$   L$   L$   H$h   	 HCH;}	    H;x	 txIH	 HHu'H
 HZ
 [
 f  /a
     H@H   HD$ Hu8Hν HZ
 E[
 f  `
   e  HHMIHD$ NtHuDH	 H9EuL;e|  HEJ<HII*L;e^  I>HIIHHH  ILHt
HuHAP03H	 98uIG     IH_	 HH,  H@L   MtH|_
 HAH2L@@MtHa_
 H HAHHK_
 H	 HH  Hu
HGHP0HFL   MtHY
 HAH2L@@MtHY
 H HAHHY
 H-	 HH  Hu
HFHP0IHm	 HH  H@L   MtHX
 HAL2L@@MtHX
 H HALHiX
 H	 LMD  Hu
HFHP0   	 HH  HxLh 3E3HL$@HD$@HtHu
HAP0H3HH$  HHH$   t HS0H$    H$P  Ht 3H$P  H$X  H$`  H$8   H$   Ht H$   H$(  H$0  H$   T	 H   IH$  ^HH$h   H$   	 H   H$h  HL$P| HH$   H~ HK0H$    H$(  HD$ sH\
 H
	 H		 L LV
 dW
 g  ]
      Hƹ HV
 =W
 i  \
 >   ]  H HxV
 W
 i  \
 =   6  Hx HQV
 V
 h  \
 +     HQ H*V
 V
 h  v\
 (      H* HV
 V
 h  O\
 &      H HU
 zV
 h  (\
 #      Hܸ HU
 SV
 h  \
     vH HU
 /V
 h  [
    RM H  H=	 HHjt k  Hd H=U
 U
 f  [
   HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIE u
IEIP0HI H(LuHLePLmX3HEHHEPHEXMtIMtI$MtIE MMIHy   V H
C	 Q HHMHHuPH}XLuHLePLmXHt
HuHQR0HtHu
HFHP0HtHu
HGHP0HuH
  H Hu
HCHP0L$      HE u
HEHP0HD$PL$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   I荪 HT$PI MtIu
IGIP0HL$@HtHuHAP0H$h   H$   Ht> E3L$   L$   L$   H$    H$   Ht L$   L$   L$   H$    H$   HHD$PHHH\$8HD$0(D$0fD$ Hu< H$   HD$PH;u^HHtH;t H$   H;u>HRHL$P L$   M[L$   H$   H H$   H@   H|$ H\$(fHtH;t H;   (t$ Hu     t gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$P =H$   \ L$   L$   HL$PB I($  H  A_A^A]A\_^][@SH HYHtHIr H H [HX PH   )p)xD)@D)HD)PD)XD
	 fEWfA(fA(fE(D)`D)l$PD)t$@D5Y	 fD(fA(D)|$0fATf/fD(fA(AYL$(   D$   fff     AXfD/   DXf(f(θ   AXAXA\DYfA(D  tYtY3fA(LD$ H$   $   ^f(AX f(fD(fATf/
;
    $   f( Y|$(AYYA^f(fATf/$   'D(l$PD(t$@D(|$0L$   fA(A(sA({E(CE(KE(SE([E(cIHN
 H
3{
  HUVWATAUAVAWH  HǄ$h  HX)p)xHL    Ht
H$   H3H$   H$   * H$   ƀ   H$   H@H$   H H$   H@HǄ$          r Ht
H$   H3H$   H$   蹄 H$0  ƀ   H$0  H@H$0  H H$0  H@HǄ$8      3H$   HT$`H$@  ~ 3E3L$  E33H;-T uEL?!	 H2	 H
} H	 L} LVM
 M
 	  S
   e  LJ
 HWS
 H7HHu'H
8 H
M
 M
 	  ]S
   d  HlDu2 Ht'H HL
 mM
 	  S
   d  Hu
HCHP0E'H;-l u>HK2	 H
t H	 L LuL
 M
 
  R
   d  H}L
 H HHu'H] H6L
 L
 
  R
   #d  HkDu2 Ht'H HK
 L
 
  @R
 !  c  Hu
HCHP0EgH;- u>H1	 H
 H	 L LK
 7L
   Q
 .  c  HiK
 H HHu'H HZK
 K
   Q
 0  Gc  HHL$hQHH$@   HL$h  Ht'H$ HJ
 K
   IQ
 2  b  Hu
HCHP0IOH$@  * H;- u>H0	 H
 H	 L LJ
 2K
   P
 ?  b  HdJ
 H HHu'H| HUJ
 J
   P
 A  Bb  HO
 H;uA      3H H9BE3H9CADteLCL;BtE3   B 8C tE3   IuE   CJ;tt
tE3   H HK 
 E3Ai3L
g I;tE3Z3I;AtE3HA   H LH7a  HDIE u
IUIR0L$  E
a  Hu
HCHP0E  H
N
 ٠HHu'H
 H
H
 I
 
  ?O
 N  `  H@L   MtHF
 HAL2L@@MtHF
 H HALHF
 H LMu'H HsH
 I
 
  N
 P  u`  Hu
HGHP0IEL   MtHG
 IAH2L@@MtHG
 H IAHHG
 I HHu'H
 HG
 H
 
  /N
 S  _  IE u
IEIP0E3H;- u>H-	 H
 H	 L LG
 &H
 
  M
 X  _  HE
 H LHu'Hp HIG
 G
 
  M
 Z  K_  E3L$  LgHR I9$y  LwL$  Md  H_IHHHHuHAP0LcH I9$   Lt$PLl$XE3EAHT$PHHHu'H HF
 3G
 
  L
 n  ^  Iu
IFIP0E3L$  IE u
IEIP0E3L$         HHu'H
F H
F
 F
 
  kL
 ~  !^  LpE3L$  Lh E3L$  E3HHZHHu'H HE
 bF
 
  L
   ]  Hu
HFHP03VIHHHu'H HvE
 F
 
  K
 g  c]  IE u
IEIP0E3L$  Hu
I$HP03HCH H;.  H;| !  H LHu'H HD
 E
 
  ;K
   \  Hu
HCHP0IEH   E3IHHtrA   IHHt_IHAT$^y'H HtD
 E
 
  J
   v\  IE u
IEIP0HǄ$         IE u
IEIP0E3@]uIĜH- HD
 D
 
  RJ
   \  HKHtVH~A   H^	 H
 H	 
HxdHͦ HC
 DD
 
  I
   [  H;u
H{Hs HCH8HpHHHu
HCHP0HH$   3Ht$`3HL$hOHH$   H;tmH$   HL$HH$   HT$@H	HL$8HT$0(D$@fD$@(L$0fL$0LL$@LD$0H$   H$    HH$    H$   LHD$hLHH\$8HD$0(D$0fD$@HuL H$   HD$hH;ubHMtL;t' H$   L;uBHRHL$h L$   M[HǄ$       H$   H H$   H@   Ld$@H\$HMtM;t I;   (t$@Mu     t eHC    u-HH     u     HH     tH\$H+HC    uH;XuHH@    tHHD$Hft$0LD$0H$   HL$h½ ?H$   l HǄ$       HǄ$       HL$hJ HT$`HL$hHH$    H$   HD$8HL$hHL$0H HD$HHL$@(D$0fD$0(L$@fL$@LL$0LD$@H$   HL$hǗ H$    HǄ$       HǄ$       HL$h IO0H$    IOpH$    L$  H;- u>H&	 H
 H	. LG L @
 @
   lF
   MX  H8B
 H HHu/H H?
 @
   -F
   L$  W  H H9Cus
H f(=_
 f.z<u:a Ht/H Hv?
 @
   E
   L$  [W  Hu
HCHP0A   H;- u>H%	 H

 H	 L5 L?
 ?
   ZE
   ;W  H@
 Hm HHu/H H>
 m?
   E
 
  L$  V  HHL$hQEHH$@   HL$hS U Ht/H Hj>
 ?
   D
   L$  OV  Hu
HCHP0I   H$@   H;- u>H$	 H
 H	 L L=
 >
   BD
   #V  H<
 HU HHu/Hޠ H=
 U>
   D
   L$  U  HAAu:T Ht/H Hi=
 >
   C
   L$  NU  Hu
HCHP0E   H;- u>H#	 H
 H	 L* L=
 =
   OC
 *  0U  H9
 Hb HHu/H H<
 b=
   C
 ,  L$  T  HAAu:a Ht/H Hv<
 =
   B
 .  L$  [T  Hu
HCHP0E   H;- u>H&#	 H
 H	 L7 L<
 <
   \B
 ;  =T  H=
 Ho HHu/H H;
 o<
   B
 =  L$  S  Hi;
 HdHHu/H H;
 )<
   A
 ?  L$  pS  Hu
HCHP0H[" Ht'H^ H7;
 ;
   A
 B  dS  Hu
HFHP03A   H;- u>H"	 H
 H	 L L:
 u;
   #A
 O  S  H;
 H6 HHu'H H:
 6;
   @
 Q  R  HHL$h"AHH$@   HL$h$ & Ht'Hb H;:
 :
   @
 S  hR  Hu
HFHP03I   H$@  c H;- u>H3!	 H
 H	 L L9
 k:
   @
 `  Q  H9
 H, HHu'H H9
 ,:
   ?
 b  Q  HÀu25 Ht'Hq HJ9
 9
   ?
 d  wQ  Hu
HFHP03A  H;- u>Hx 	 H
 H	 L L8
 9
   6?
 q  Q  H:
 HI HHu'Hқ H8
 I9
   >
 s  P  H
s6
 VHHu/H Hp8
 9
   >
 u  L$  UP  HP<
 H`aHHu/HQ H*8
 8
   v>
 w  L$  P  Hu
HCHP0A   HHG HHu/H H7
 o8
   >
 z  L$  O  Hu
HFHP03Hu
HGHP03HDy/H Ho7
 
8
   =
 }  L$  TO  Hu
HCHP0Ee(  H;- u>H	 H
 H	 L. L7
 7
   S=
   4O  H7
 Hf HHu/H H6
 f7
   =
   L$  N  Hp5
 H HHu/H H6
 7
   <
   L$  fN  Hu
HCHP0H4
 H HHu/HQ H*6
 6
   v<
   L$  N  Hu
HGHP03HTDu: Ht/H H5
 l6
   <
   L$  M  Hu
HCHP0E   H;-_ u>HF	 H
g H	v L Lh5
 6
   ;
   M  H 6
 H HHu/HP H)5
 5
   u;
   L$  M  H3
 H HHu/H	 H4
 5
   .;
   L$  L  Hu
HCHP0H9
 H) HHu/H H4
 )5
   :
   L$  pL  Hu
HGHP03H SDu: Ht/HV H/4
 4
   {:
   L$  L  Hu
HCHP0E$  H;- u>H	 H
 H	 L L3
 g4
   :
   K  H4
 H( HHu/H H3
 (4
   9
   L$  oK  H22
 H HHu/Hj HC3
 3
   9
   L$  (K  Hu
HCHP0H8
 H HHu/H H2
 3
   89
   L$  J  Hu
HGHP0Ht2
 H[HHu/H H2
 43
   8
   L$  {J  Hu
HCHP0HS- Ht/Hi HB2
 2
   8
   L$  <J  Hu
HGHP0A(  H;- u>H
	 H
 H	 L L1
 z2
   (8
   	J  H2
 H; HHu/HĔ H1
 ;2
   7
   L$  I  HE0
 H HHu/H} HV1
 1
   7
   L$  ;I  Hu
HGHP0H.
 H HHu/H& H0
 1
   K7
   L$  H  Hu
HCHP0HO؃u: Ht/H͓ H0
 D1
   6
   L$  H  Hu
HGHP0A,  H;-7 u>H	 H
? H	N Lg L@0
 0
   6
   mH  H0
 H HHu/H( H0
 0
   M6
   L$  G  H.
 HX HHu/H H/
 X0
   6
   L$  G  Hu
HGHP0H3
 H HHu/H Hc/
 0
   5
   L$  HG  Hu
HCHP0HM؃u: Ht/H1 H
/
 /
   V5
   L$  G  Hu
HGHP0A0  H;- u>H"	 H
 H	 Lˑ L.
 B/
   4
    F  H\/
 H HHu/H He.
 /
   4
   L$  _F  H
-
 H HHu/HE H.
 .
   j4
   L$  F  Hu
HGHP0H+
 He HHu/H H-
 e.
   4
   L$  E  Hu
HCHP0HÀu:V Ht/H Hk-
 	.
   3
 
  L$  eE  Hu
HGHP0A4  H;- u>H	 H
 H	 L, L-
 -
    Q3
   2E  H-
 Hd HHu/H H,
 d-
    3
   L$  D  Hn+
 H HHu/H H,
 -
    2
   L$  dD  Hu
HGHP0Hw)
 H HHu/HO H(,
 ,
    t2
   L$  
D  Hu
HCHP0HJ؃u: Ht/H H+
 m,
    2
 !  L$  C  Hu
HGHP0A8  H;-` u>H7	 H
h H	w L Li+
 ,
 !  1
 .  C  H!,
 H HHu/HQ H*+
 +
 !  v1
 0  L$  $C  H)
 H HHu/H
 H*
 +
 !  /1
 2  L$  B  Hu
HGHP0H'
 H* HHu/H H*
 *+
 !  0
 5  L$  qB  Hu
HCHP0H#I؃u: Ht/HZ H3*
 *
 !  0
 8  L$  -B  Hu
HGHP0A<  H;- u>H	 H
 H	 L L)
 k*
 "  0
 E  A  H*
 H, HHu/H H)
 ,*
 "  /
 G  L$  A  H6(
 H HHu/Hn HG)
 )
 "  /
 I  L$  ,A  Hu
HGHP0H?+
 H HHu/H H(
 )
 "  </
 L  L$  @  Hu
HCHP0HÀu: Ht/H H(
 2)
 "  .
 O  L$  @  Hu
HGHP0A@  H;-% u>HL	 H
- H	< LU L.(
 (
 #  z.
 \  [@  H(
 H HHu/H H'
 (
 #  ;.
 ^  L$  ?  H&
 HF HHu/Hϊ H'
 F(
 #  -
 `  L$  ?  Hu
HGHP0H(
 H HHu/Hx HQ'
 '
 #  -
 c  L$  6?  Hu
HCHP0Hq H9Guw
H f(f.z<u: Ht/H H&
 |'
 #  *-
 f  L$  >  Hu
HGHP0AH  H;-m u>H	 H
u H	 L Lv&
 '
 $  ,
 s  >  H.'
 H HHu/H^ H7&
 &
 $  ,
 u  L$  1>  H$
 H HHu/H H%
 &
 $  <,
 w  L$  =  Hu
HGHP0H8$
 H7 HHu/H H%
 7&
 $  +
 z  L$  ~=  Hu
HCHP0H H9Guw
H3 f(f.z<u: Ht/HM H&%
 %
 $  r+
 }  L$   =  Hu
HGHP0AP  H;- u>H,	 H
 H	 L L$
 \%
 %  
+
   <  Hv%
 H HHu/H H$
 %
 %  *
   L$  y<  H'#
 H HHu/H_ H8$
 $
 %  *
   L$  <  Hu
HGHP0H%
 H HHu/H H#
 $
 %  -*
   L$  ;  Hu
HCHP0H H9Guw
H{ f(f.z<u:Y Ht/H Hn#
 $
 %  )
   L$  h;  Hu
HGHP0AX  H;- u>H	 H
 H	 L- L#
 #
 &  R)
   3;  H#
 He HHu/H H"
 e#
 &  )
   L$  :  Ho!
 H HHu/H H"
 #
 &  (
   L$  e:  Hu
HGHP0Hp 
 H HHu/HP H)"
 "
 &  u(
   L$  :  Hu
HCHP0HA؃u: Ht/H H!
 n"
 &  (
   L$  9  Hu
HGHP0A`  H;-a u>H(	 H
i H	x L Lj!
 "
 '  '
   9  H""
 H HHu/HR H+!
 !
 '  w'
   L$  %9  H
 H HHu/H H 
 !
 '  0'
   L$  8  Hu
HGHP0H#
 H+ HHu/H H 
 +!
 '  &
   L$  r8  Hu
HCHP0H@؃u: Ht/H[ H4 
  
 '  &
   L$  .8  Hu
HGHP0Ad  H;- u>H		 H
 H	 L L
 l 
 (  &
   7  H 
 H- HHu/H H
 - 
 (  %
   L$  7  H7
 H HHu/Ho HH
 
 (  %
   L$  -7  Hu
HGHP0H($
 H HHu/H H
 
 (  =%
   L$  6  Hu
HCHP0Hx>؃u: Ht/H H
 6
 (  $
   L$  6  Hu
HGHP0Ah  H;-) u>H@	 H
1 H	@ LY L2
 
 )  ~$
   _6  H
 H HHu/H H
 
 )  ?$
   L$  5  H
 HJ HHu/HӀ H
 J
 )  #
   L$  5  Hu
HGHP0H!
 H HHu/H| HU
 
 )  #
   L$  :5  Hu
HCHP0Hu H9Guw
H f(f.z<u: Ht/H	 H
 
 )  .#
   L$  4  Hu
HGHP0Ap  H;-q u>H	 H
y H	 L Lz
 
 *  "
   4  H2
 H HHu/Hb H;
 
 *  "
   L$  54  H
 H HHu/H H
 
 *  @"
   L$  3  Hu
HGHP0H 
 H; HHu/H~ H
 ;
 *  !
   L$  3  Hu
HCHP0H%
 H}DHHu/Hn~ HG
 
 *  !
   L$  ,3  Hu
HGHP03H|=D Ht/H~ H
 
 *  <!
 
  L$  2  Hu
HCHP0Ex  H;- u>H	 H
 H	 L} L
 (
 +   
   2  HB
 H HHu/Hr} HK
 
 +   
   L$  02  H
 H HHu/H+} H
 
 +  P 
   L$  1  Hu
HCHP0H|
 HK HHu/H| H
 K
 +  
   L$  1  Hu
HGHP03H H9Cus
HE f(f.z<u:# Ht/H_| H8
 
 +  
 !  L$  1  Hu
HCHP0A  H;- u>HV	 H
 H	 L{ L
 n
 ,  
 .  0  H
 H/ HHu/H{ H
 /
 ,  
 0  L$  v0  H9
 H HHu/Hq{ HJ
 
 ,  
 2  L$  /0  Hu
HCHP0HB
 H HHu/H{ H
 
 ,  ?
 5  L$  /  Hu
HGHP03H H9Cus
H f(f.z<u:i Ht/Hz H~
 
 ,  
 8  L$  c/  Hu
HCHP0A  H;-
 u>H	 H
 H	$ L=z L
 
 -  b
 E  C/  H
 Hu HHu/Hy H
 u
 -  #
 G  L$  .  H
 H. HHu/Hy H
 .
 -  
 I  L$  u.  Hu
HCHP0H
 H׾ HHu/H`y H9
 
 -  
 L  L$  .  Hu
HGHP0H

 mHHu/H
y H
 
 -  2
 O  L$  -  H
 H>HHu/Hx H
 >
 -  
 Q  L$  -  Hu
HGHP0A   HH HHu/Hnx HG
 
 -  
 T  L$  ,-  Hu
HCHP0Hu
HFHP03H\؅y/Hx H
 
 -  4
 W  L$  ,  Hu
HGHP0  H;-x u>HW H
 H	 Lw L
 
 .  
 d  ,  H9
 H HHu/Hiw HB
 
 .  
 f  L$  <,  H
 H HHu/H"w H
 
 .  G
 h  L$  +  Hu
HGHP0H
 HB HHu/Hv H
 B
 .  
 k  L$  +  Hu
HFHP03H92؃u:4 Ht/Hpv HI
 
 .  
 n  L$  C+  Hu
HGHP0A  +  H;-ռ u>H H
ݼ H	 Lv L
 |
 /  *
   +  H
 H= HHu/Hu H
 =
 /  
   L$  *  HG
 H HHu/Hu HX
 
 /  
   L$  R*  Hu
HGHP0H
 H HHu/H(u H
 
 /  M
   L$  )  Hu
HFHP0H

 iHHu/Ht H
 L
 /  
   L$  )  H.
 H:HHu/Ht Hh
 
 /  
   L$  M)  Hu
HFHP0A   HH HHu/H6t H
 
 /  [
   L$  (  Hu
HGHP03Hu
HCHP0H$؅y'Hs H
 N
 /  
   (  Hu
HFHP03)  H;-F u>Hu H
N H	] Lvs LO
 
 0  
   |(  H
 H HHu'H7s H
 
 0  \
   =(  H
 Ho HHu/Hr H
 o
 0  
   L$  '  Hu
HFHP0H
 H HHu/Hr Hz
 
 0  
   L$  _'  Hu
HCHP0H H9Fuv
H f(f.z4u2 Ht'H.r H
 
 0  S
   4'  Hu
HFHP0A  p'  H;- u>H H
 H	 Lq L
 @
 1  
   &  HB
 H HHu'Hq Hc
 
 1  
   &  H
+
 fHHu/HOq H(
 
 1  t
   L$  
&  H 
 H7HHu/H	q H

 
 1  .
   L$  %  Hu
HCHP0A   HH HHu/Hp H

 '
 1  
   L$  n%  Hu
HFHP03Hu
HGHP03H蜝Dy/HNp H'

 

 1  s
   L$  %  Hu
HCHP0E  H;- u>H5 H
 H	͸ Lo L
 ]

 2  
   $  Hw

 H HHu/Ho H
 

 2  
   L$  e$  H
 H״ HHu/H`o H9
 
 2  
   L$  $  Hu
HCHP0Hi

 H HHu/H	o H
 
 2  .
   L$  #  Hu
HGHP03Hw*Du:q Ht/Hn H
 $
 2  
   L$  k#  Hu
HCHP0E   H;- u>H H
 H	. LGn L 
 
 3  l
   M#  H
 H HHu/Hn H

 
 3  -
   L$  "  H
 H8 HHu/Hm H

 8
 3  
   L$  "  Hu
HCHP0H
 H HHu/Hjm HC

 

 3  
   L$  ("  Hu
HGHP03H(Du:ҳ Ht/Hm H	
 

 3  3
 	  L$  !  Hu
HCHP0E$  H;-x u>HG H
 H	 Ll L	
 

 4  
   !  H9

 H HHu/Hil HB	
 	
 4  
   L$  '!  HJ
 H HHu/H"l H
 	
 4  G
   L$     Hu
HCHP0Hc
 HB HHu/Hk H
 B	
 4  
   L$     Hu
HGHP0H,
 H1HHu/Huk HN
 
 4  
    L$  3   Hu
HCHP0Hu+ Ht/H!k H
 
 4  F
 #  L$    Hu
HGHP0A(  H;- u>H H
 H	 Lj L
 2
 5  

 0    HL
 H HHu/H|j HU
 
 5  

 2  L$  O  H]

 H HHu/H5j H
 
 5  Z

 4  L$    Hu
HGHP0H
 HU HHu/Hi H
 U
 5  

 7  L$    Hu
HCHP0HޖÀu:F Ht/Hi H[
 
 5  
 :  L$  U  Hu
HGHP0A,  H;- u>H H
 H	 Li L
 
 6  A
 G  "  H
 HT HHu/Hh H
 T
 6  
 I  L$    H
 H
 HHu/Hh Ho
 

 6  
 K  L$  T  Hu
HGHP0H7

 H HHu/H?h H
 
 6  d
 N  L$    Hu
HCHP0H8 H9Guw
H f(f.z<u: Ht/Hg H
 C
 6  

 Q  L$    Hu
HGHP0A0  H;-4 u>H{ H
< H	K Ldg L=
 
 7  

 ^  j  H
 H HHu/H%g H
 
 7  J

 `  L$    H

 HU HHu/Hf H
 U
 7  

 b  L$    Hu
HGHP0H
 H HHu/Hf H`
 
 7  	
 e  L$  E  Hu
HCHP0H H9Guw
H f(f.z<u:ج Ht/Hf H
 
 7  9	
 h  L$    Hu
HGHP0A8  H;-| u>H H
 H	 Le L
 #
 8  
 u    H=
 H HHu/Hme HF
 
 8  
 w  L$  @  HN
 H HHu/H&e H
 
 8  K
 y  L$    Hu
HGHP0H 
 HF HHu/Hd H
 F
 8  
 |  L$    Hu
HCHP0Hȩ H9Guw
HB f(f.z<u:  Ht/H\d H5
 
 8  
   L$  /  Hu
HGHP0A@  H;-Ī u>H[ H
̪ H	۬ Lc L 
 k
 9  
     H
 H, HHu/Hc H 
 ,
 9  
   L$    H
 H HHu/Hnc HG 
  
 9  
   L$  ,  Hu
HGHP0H
 H HHu/Hc H  
 9  <
   L$    Hu
HCHP0H H9Guw
H f(f.z<u:h Ht/Hb H}  
 9  
   L$  w  Hu
HGHP0AH  H;- u>H H
 H	# L<b L  :  a
   B  H Ht HHu/Ha H t :  "
   L$    H
 H- HHu/Ha H - :  
   L$  t  Hu
HGHP0H
 H֦ HHu/H_a H8  :  
   L$    Hu
HCHP0HX H9Guw
HҨ f(f.z<u: Ht/H` H c :  
   L$    Hu
HGHP0AP  H;-T u>H; H
\ H	k L` L]  ;  
     H H HHu/HE` H  ;  j
   L$    H&
 Hu HHu/H_ H u ;  #
   L$    Hu
HGHP0H' H HHu/H_ H  ;  
   L$  e  Hu
HCHP0H H9Guw
H f(f.z<u: Ht/H4_ H
  ;  Y
   L$    Hu
HGHP0AX  H;- u>H H
 H	 L^ L C <  
     H] H HHu/H^ Hf  <  
   L$  `  Hn
 H HHu/HF^ H  <  k
   L$    Hu
HGHP0H Hf HHu/H] H f <  
   L$    Hu
HCHP0H_؃u:Z Ht/H] Ho 
 <   
   L$  i  Hu
HGHP0A`    H;- u>H2 H
 H	 L+] L  =  P 
   1  H Hc HHu/H\ H c =   
   L$    H
 hQHHu/H\ H   =     L$  g  HR Hr"HHu/Hc\ H<  =     L$  !  Hu
HCHP0A   HHY HHu/H
\ H  =  /   L$    Hu
HGHP03Hu
HFHP03HDy/H[ H  =     L$  f  Hu
HCHP0E  H;- u>Ho H
 H	' L@[ L  >  e   F  H Hx HHu/H[ H x >  & 
  L$    H H1 HHu/HZ H 1 >     L$  x  Hu
HCHP0H Hڟ HHu/HcZ H<  >     L$  !  Hu
HFHP0H H HHu/H
Z H  >  2   L$    Hu
HCHP0H} Ht'HY H 0 >       Hu
HFHP03A$  H;-) u>H H
1 H	@ LYY L2  ?  ~ %  _  H H HHu'HY H  ?  ? '     H HR HHu/HX H R ?    )  L$  
  Hu
HFHP0H H HHu/HX H]  ?   ,  L$  B
  Hu
HCHP0H؃u2 Ht'H+X H  ?  P /  1
  Hu
HFHP03A   H;- u>HJ H
 H	 LW L B @   <    H\ H HHu'HW He  @   >    Hm HĜ HHu/HMW H&  @  r @  L$    Hu
HFHP0H. Hm HHu/HV H m @   C  L$    Hu
HCHP0Hf؃u2a Ht'HV Hv  @   F    Hu
HFHP03A(  H;-
 u>H H
 H	$ L=V L  A  b S  C  H Hu HHu'HU H u A  # U    H H6 HHu/HU H 6 A   W  L$  }
  Hu
HFHP0Hx Hߚ HHu/HhU HA  A   Z  L$  &
  Hu
HCHP0H؃u2ӛ Ht'HU H  A  4 ]  
  Hu
HFHP03A,  H;- u>H~ H
 H	 LT L & B   j  	  H@ H HHu'HpT HI  B   l  v	  HQ H HHu/H1T H
  B  V n  L$    Hu
HFHP0H HQ HHu/HS H Q B   q  L$    Hu
HCHP0HJ؃u2E Ht'HS HZ  B   t    Hu
HFHP03A0  H;- u>H H
 H	 L!S L  C  F   '  H HY HHu'HR H Y C       H H HHu/HR H|  C     L$  a  Hu
HFHP0H H× HHu/HLR H%  C  q   L$  
  Hu
HCHP0H
؃u2 Ht'HQ H j C       Hu
HFHP03A4  H;-c u>H H
k H	z LQ Ll 
 D       H$ H˖ HHu'HTQ H-  D  y   Z  H5 H HHu/HQ H  D  :   L$    Hu
HFHP0H H5 HHu/HP H 5 D     L$  |  Hu
HCHP0H H9Fuv
H1 f(f.z4u2 Ht'HKP H$  D  p   Q  Hu
HFHP03A8  H;- u>H0 H
 H	И LO L ` E       Hz H! HHu'HO H ! E       H H HHu/HkO HD  E     L$  )  Hu
HFHP0H< H HHu/HO H  E  9   L$    Hu
HCHP0H|Àu2| Ht'HN H / E       Hu
HFHP03A@  H;-( u>H H
0 H	? LXN L1  F  }   ^  H H HHu'HN H  F  >     H HQ HHu/HM H Q F     L$    Hu
HFHP0H H HHu/HM H\  F     L$  A  Hu
HCHP0H| H9Fuv
H f(f.z4u2ԓ Ht'HM H  F  5     Hu
HFHP03AH  H;-~ u>HE H
 H	 LL L % G       H? H HHu'HoL HH  G     u  HP H HHu/H0L H	  G  U   L$     Hu
HFHP0H) HP HHu/HK H P G     L$     Hu
HCHP0HI؃u2D Ht'HK HY  G        Hu
HFHP0AD     H=K H    b C  L$  HtHu
HCHP0HtHu
HGHP0MtIE u
IEIP0MtIu
IFIP0HtHu
HFHP0D$(    D$    L
y D  H
5  AH$   Ht
HuHAP0HL$`HtHuHAP0H$@   H$0  HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   = H$0  i HǄ$0      HǄ$8      H$   i H$   HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   T= H$   Si HǄ$       HǄ$       H$   .i L$  I[@A(sA({IA_A^A]A\_^]@SH HYHtH) Hh H [LL$ LD$HL$SVWATAUAVAWH   HǄ$   L   h HtHL$0H33HHD$0Ht$HHt$PHt$XLHt$(   zh Ht
HL$`HHHD$`Ht$xH$   H$   H HH

  HHtH Hr3HHu'HG H Z    2    HGL   MtH HAH2L@@MtH H HAHH Hr HHu'HcG H<     2  >  Hu
HGHP0HHt$ LsH8 I9Y  H{H|$ HG  LcHI$HIHuHAP0Mt$H I9usH$   L$   E3EAH$   I3LHu'H
F H
y     2    Hu
HGHP0HHt$        LHu'H
IF H
"    n 3  $  HxHHt$ ILx E3HIh5LHu'HE H p    3     IE u
IEIP0LHt$(:IH#7LHu'HE H}     2     Hu	IHP0ID$L   MtH IAH2L@@MtH H IAHH I# HHuFHE H    9 3  M  I$  ID$IP0  I$uID$IP0HH$   C7HHL$`% H$   Htd H$   H$   H$   H$   yd  Ht'H[D H4     3  6  Hu
HCHP0HH$   HT$`HL$0葋 H$0  DqAAu2 Ht'HC H ]    #3     H$8  pAAu/_ Ht$HC Ht     $3  yHT$0H$   c EEHH$   HI0x  HH   H6C H    [ +3  3H|$ H$   Ll$(HtHu
HGHP0HtHu
HCHP0MtIE u
IEIP0L
 D?  H
 PHHL$xHtb Ht$xH$   H$   HL$`b HL$HHtpb Ht$HHt$PHt$XHL$0Wb HH   A_A^A]A\_^[LD$HT$HL$SVWATAUAVAWH  HǄ$@     b HtH$   H33HH$   H$  H$   H$(     a Ht
H$   HHH$   H$   H$   H$   LH\$    a Ht
HL$hHHHD$hH$   H$   H$      Va Ht
HL$8HHHD$8H\$PH\$XH\$`LH5~ HH
 ֆ HHtH HQ,HHu'H@ H 9    3    HGL   MtH HAL2L@@MtH H HALH HQ LMu'HB@ H    g 3  !  Hu
HGHP0HH$  M|$H I9r  I|$H$  H\  It$HHILHuHAP0L~H I9u~H$0  H$  H$8  E3EAH$0  H,HHu'H
p? H
I     3    Hu
HGHP0HH$        e LHu'H
? H
    ; 3    HxHH$  H$  H IE E3IH*.HHu'H> H 2    3  6  IE u
IEIP0LH\$ ?H$  I/HHu'Ha> H:     3    I$u	IIP0HFL   MtHz HAL2L@@MtH_ H HALHI H LMu'H= H H    3  L  Hu
HFHP0IH$   !0HHL$h H$   Ht|] H$   H$   H$   H$   W]  Ht'H9= H    ^ 3    I$uID$IP0LH$   HT$hH$   j H$  j@@u2 Ht'H< H 6    3    H$   H$H  \ DLH$   H$  HIu HHL$8܃ H$   HtU\ H$   H$   H$   H$   0\ HT$8H$   葃 H
 0HHu'H; H m    3  q  H@L   MtH HAL2L@@MtH H HALH H LMu'Hv; HO     3    Hu
HFHP0H$   HHu'H*; H    O 3    HM}H I9Y  I}HL  M}HIIMHuHAP0IOH$  H H9u~H|$(Ht$0E3EAHT$(I'LHu'H: H]     4     Hu
HGHP0H  HFHP0L$        h LHu'H
: H
    > 4     HxHp E3HIC)LHu'H9 H K    %4     Iu
IFIP0L$  fHI*LHu9H9 HY     4  Ht_HuYHFHP0MHuHFHP0L$  IE    IIP0   3H$  L$   Ll$ MHtHu
HGHP0MtI$uID$IP0MtIE u
IEIP0MtIu
IFIP0L
 D$  H
 FLHL$PHtX H\$PH\$XH\$`HL$8kX H$   HtXX H$   H$   H$   HL$h6X H$   Ht#X H$   H$   H$   H$   W H$  HtW H$  H$   H$(  H$   W IHĀ  A_A^A]A\_^[HHHUVWATAUAVAWHp  HǄ$P  HX)pL   W 3Ht
H$   HHH$   H$8  H$@  H$H  H$  L   :W Ht
H$   HHH$   H$   
 H$  ƀ   H$  H@H$  H H$  H@H$     V Ht
H$   HHH$   H$   
 H$   ƀ   H$   H@H$   H H$   H@H$   HLH= HH
! | HHtH H!HHu*H5 H n    :  E3?  HCL   MtH HAL2L@@MtHr H HALH\ H| LMu'Ht5 HM     :  a  Hu
HCHP0ID$L   MtH IAH2L@@MtH H IAHH I{ HHu*H4 H Z    :  E3
  I$uID$IP0LHkHy H9E M  LcM@  H{I$HHHHuHAP0HoHhz H9E usL$   L$   E3EAH$   HS!HHu'H$4 H    I :  	  I$uID$IP0E3M      z HHu'H
3 H
 D    :  	  L`E3IE Lh E3HH"HHu'H3 HZ     :  Y	  Hu
HFHP0E3I=IH$HHu'H/3 H    T :  	  E3Hu
HE HP0IHGH>x H;%  H;&x   Hz LHu'H2 H 7    ;    Hu
HGHP0ID$H   IIHHtg   IHHtUIHȍURy'HG2 H     l 
;  4  I$uID$IP0M   I$uID$IP0MuHw'H1 H W    ;    HOHtVH~A   H H
lx H	z 
Hx'H1 HY     :  X  H;u
H_Hw HGHHpHHHu
HGHP0H$  LHHL$@fHH$   H;tmH$  HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$   $ HH$   # HT$pLHD$@HHH\$(HD$ (D$ fD$0Hut HT$pHD$@H;uRHHtH;ts HT$pL;u5HRHL$@O L\$pM[E3Ll$xHD$pH HD$pH@   H|$0H\$8HtH;ts I;   (t$0Huts     tes dHC    u,HH     u    HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@H @E3HL$p<O Ll$pLl$xHL$@(O HHL$@oHH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$   " HH$   # HT$pHHD$@HHH\$(HD$ (D$ fD$0Huq HT$pHD$@H;uOHHtH;tq HT$pH;u2HRHL$@M L\$pM[Ll$xHD$pH HD$pH@   H|$0H\$8    HtH;tq H;   (t$0Hugq     tXq gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@F =HL$p/M Ll$pLl$xHL$@M L$   L$   HT$@H$  HI` HH$   Xt HL$XHtL Ll$XLl$`Ll$hHL$@L H
0 S!HHu'H, Hm     =;    H@L   MtH HAH2L@@MtHz H HAHHd H#s HHu'H, H    9 ?;    Hu
HFHP0H$   HHu'H+ H ?    B;    MHkHp H9E O  LcMB  H{I$HHHHuHAP0HoHbq H9E uxLd$ Ht$(E3EAHT$ HVHHu'H'+ H     L V;     I$uID$IP0H  HFHP0|     q LHu'H
* H
 9    f;     L`MHp IE3HHHHu$Hw* HP     l;  RI   IFIP0   HHHH   H#* H    H O;  HtHu
HGHP0HtHu
HCHP0E3E3MtI$uID$IP0HtHu
HFHP0MtIu
IFIP0L
n D  H
 7I Hu
HFHP0Hu
HE HP0H$  Ht
HuHAP0MtIuIGIP0H$   LH$   HHH\$(HD$ (D$ fD$0Hul H$   H$   H;uaHHtH;t_l H$   L;uAHRH$   1H L$   M[L$   H$   H H$   H@   Ht$0H\$8    HtH;tk I;   (t$0Huk     tk gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$   @ :H$   G L$   L$   H$   |G H$  HD$(H$   HL$ H H$   H$   (D$ fD$ ($   f$   LL$ L$   H$   H$    H$  G L$  L$  H$   F H$8  HtF L$8  L$@  L$H  H$   F HH$  ($`  Hp  A_A^A]A\_^]HHHUVWATAUAVAWH   HǄ$   HXHLE3DxAOaF Ht
HL$ HIHD$ L|$8L|$@L|$HM   .F HtL0IIM~M~ M~(Ǆ$        E Ht
HL$PHIHD$PL|$hL|$pL|$xHGH;j    H;j t{HHXm HHu+L
% L
J A/   D lT     H@L   Mu4L
F% L
 A/   D nT  W   HIMHl@ MuEH<j H9GuH;w  HGHHHH,H;w  H] HHHHAHH   ILHt
HuHQR0HH$   ,0HHL$PH H$   HtgD L$   L$   L$   H$   BD j Hu]HT$PH$   E HHL$ V H$   HtD L$   L$   L$   H$   C L
# L
 A0   D; T   OXj HtvHLl HHy5th XL
# L
O A/   D T   HuHGHP0L
  D s H
 71Hu
HGHP0HT$ I8 MtI$uID$IP0HL$hHtB L|$hL|$pL|$xHL$PB HL$8HtFH|$@H;t7HYHHtB L;L{L{HKB H0HCH;uHL$8B L|$8L|$@L|$HHL$ jB IH$  H   A_A^A]A\_^]H\$ WH Hh LD$0HT$8HL$@ i H{HHtHD HA LD$0HT$8HL$@Hh HK3HtH{HuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  @SH HYhHtHQ H@ H [LI[IkIsWATAUAVAWH`H-}e H5~e E3MHLIkIsMcM'  LrIMt0Ht!HtH'  Hr(IsHj Hl$HLbLd$@If HIMtHt,HtOvHp Ie LHD$@H   HHj  H Ie HtHHD$HHHA  H Iae HtHHD$PHH  H LL$@H- HD$(E3ILt$ y
2     Ht$PHl$HLd$@   HBH   H   H   HKH}   L
&    L
( HL$0H
e HH	L H IDLT HD$(HT$ H g 2  L
y H
B Aa    a  L
5 `,3Hr(Hj LbLLIIoL\$`I[0Ik8Is@IA_A^A]A\_LI[IkIsI{ ATAUAVHPH=b 3MHLI{IsM   LjIMt!HtH   Hz I{HrHt$@Ic HIMtHt&MH IWc HHD$@H   HH.  H I*c HtHHD$HHH  H LL$@H HD$(E3ILl$ y
t3     H|$HHt$@   HBH   H   HKH}   L
    L
  HL$0H
\c HH	L H IDL HD$(HT$ H me 3  L
Q H
 A  ~    L

 8*3Hz HrLHIL\$PI[ Ik(Is0I{8IA^A]A\K@SH HYhHtHM H; H [@UVWATAUAVAWH   HǄ$  H$`  L   ; E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HL$p  L$h  II   S; Ht
H$   HIH$   L$   L$   L$      ; Ht
H$   HIH$   L$   L$   L$   H$   a\ 3_ LHu'H Hb      <    I_0HCH;_ t|H;_ tsHHb HHu'H
3 H
    X <  %  H@L   Mu-H Hն s   ! <    HILdMuEH_ H9CuH;{  HCH4HHI,H;{  I4$HHIHAHHu  H$h  H$h  Ht
HuHQR0HFL   MtH HAH2L@@MtH H HAHH H` HH   E3HS HCHH   Hu
HVHR03INI9N ~HE IFH,HAIFHI_ uHE u
HEHP03Hv HO     <  E3e  HL H% õ   q <  E3;  H" H    G <  E3  ^ HtHH` HH)t8] *H H F    <  E3  Hu
HCHP0E3IL$p  IHL$`9HH$    . H|$xHt4L$   I;t     HY H(I;uH|$xH=7 Ll$xL$   L$   HL$`7 ] Ht'H  Hٳ w   % <  G  IW8HL$`bHH$    HL$xHtNL$   I;t<HyD  HHt6 L/LoLoHO6 H0HGI;uHL$xt6 Ll$xL$   L$   HL$`U6 \ Ht'H7 H    \ <  ~  ALD$ H$   H$    3Z LHu'H H Z    <    HL$8HH\$@H;vKY H\$@HL$8HD$ HD$PH|$X(D$PfD$PH|$PLd$XL$h  D  H;vY HtH;|$ tX L;  HuX E3LM;c rX IH$   bW HuX E3LM;c rX I(H$   H$  HC$   H$  \ HHu7L
 L
 7 2    tP  tP  D@2H
ͻ "Ht  ILH$h  Ht
HuHAP0HCL   MtHp HAH2L@@MtHU H HAHH? H[ HH   E3H8 HXHH   Hu
HCHP03INI9N ~HE IFH,HAIFHIZ u"HE u
HEHP03H\$@HL$8H HZ     <  E3sHZ H3 Ѱ    <  E3LH3 H    X <  E3%H H    1 <  E3MtIu
IFIP0HtHu
HCHP0HtHu
HFHP0HtHE u
HEHP0L
r D ŵ H
  ME3H$p  Ht
HuHAP0H$h  HtHuHAP0H$   T H$   HtLH$   H;t:HYHHt2 L+LkLkHK1 H0HCH;uH$   1 L$   L$   L$   H$   1 H$   Ht3H$   H;t@ H7T H(H;uH$   Hz1 L$   L$   L$   H$   U1 H\$8Ht-H|$@H;t@ HS H(H;uH\$8H1 Ll$8Ll$@Ll$HHL$ 1 IH$`  H   A_A^A]A\_^]H\$ WH HMW LD$0HT$8HL$@W H{hHHtHA H0 LD$0HT$8HL$@HW HK3HtH{HuHAP0HK HtH{ HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  HL@HPHHUVWATAUAVAWH  HǄ$(  HX MMHLE3Dd$hH$  HL$pI/ AL$N/ Ht
HL$8HIHD$8IH\$PIHL$XLd$`ILd$0H$   H+$   HH  H;rbR HL$XH\$PH$   L9,M  HuIHT$`H+HHH+HH;sH1HHL$XH\$P  HH;vQ HL$XH\$PHl$8H$   H$   HH+HuI$H;vQ HtH;l$8tQ H+H($   f$@  LL$0A   H$@  HL$8I: H\$PLHL$XH;vaQ HL$XH\$PHl$8HuGQ E3HL$XH\$PHD$8LII;S wHt	HE E3E3IH;PsQ HL$XH\$PE3HHt$0H$   H+$   HH;gH$  IH$   H+$   HH$   Ht=H;rP H$   H4HH$   H+$   HH;rHL$XH\$PIH+HHt[H;rQP H\$PHH$   H+$   HH;r)P H$   L$HHD$XH\$PH+HHH;r   , Ht
H$   HIH$   Ld$0LD$0HH$   p] IHt=    H$   H$   H+HH;rO H$   HHH;rH5i	 H$  H$  IH$   jN LL$pH$  LIH$P  衽 L$   LIH$   腽 H՛	 H$   L$   L$   H$  H$  fWD$0H$  H$      Q+ Ht
H$  HIH$  LD$0IH$  ?\ H$p  H$   H$  HD$0H$  H$0  H$8  H$@  H$p  H$   H$x  H$   H$  H$  H$  H$  H$  * H=	 H$  H$(  H$  H$0  H$  H$8  H$  H$@  H$  /* H$  H$   H	 H$  H$x  H$  H$  H$  H$  H$  H$  H$    H$  H$0  ) H$  H$X  H$  H$`  H$  H$h  H$  H$p  H$  f) H$  H$   H$  H$  H$  H$  H$   H$  H$(  H$  H$0   H$  H$`  ( H$8  H$  H$@  H$   H$H  [K H$p  HD$ L$  L$  H$8  H$`  6 HI D$h   H$x  HtV( L$x  L$  L$  H$`  1( H5P	 H$@  H$p  蹽 H$  謽 L$h  L$   H$x  J H$h  H$`  H$(  Ht' L$(  L$0  L$8  H$  ' H$   H$  Ht' L$  L$  L$  H$  c' H$  HtLH$  H;t:HYHHt8' L#LcLcHK$' H0HCH;uH$  
' L$  L$  L$  H$  & H$p  H$X  Ht& L$X  L$`  L$h  H$@  & H$   H$  Ht& L$  L$  L$  H$  g& H$  HtLH$  H;t:HYHHt<& L#LcLcHK(& H0HCH;uH$  & L$  L$  L$  H$  % H$  H$  Ht% L$  L$  L$  H$p  % H$P  H$   8H H$  H$   Hty% L$   L$   L$   H$   T% HL$PHtD% Ld$PLd$XLd$`HL$8+% H$   Ht% L$   L$   L$   HL$p$ IG IH$  HĐ  A_A^A]A\_^]HL$SVWATAUAVAWHp  HǄ$P  )$`  Hڹ   $ HtH$   HE3E3IH$   H$     H$   ƀ   H$   H@H$   H H$   H@L$(     4$ Ht
H$   HIH$   H$   z  H$   ƀ   H$   H@H$   H H$   H@L$   Lt$HILt$@IL$  MMMHKHu'Hn HG     #    AH  Ht	H[H43I HHuIHHpH HHu
HGHP0Hu'H H `    #  @
  H\$HH$H  H= HH
 H LHtH HLMu'H HZ     #  	  IEL   MtH IAL2L@@MtH H IALH II LMu'H Hڞ x   & #  m	  IE u
IEIP0ID$L   MtHP IAL2L@@MtH5 H IALH I~H LMu*Ho HH     #  I	  I$uID$IP0ML$  IuH<F H9T  MeL$  M?  I}I$HILHuHAP0HwHF H9uoLd$PH\$XE3EAHT$PHHHu'H
  H
 "   У #    I$uID$IP0ML$        F LHu'H
O  H
( Ɲ   t #    L`ML$  HHX E3HHkHHu'H H՜ s   ! $  S  Iu
IGIP0M:HI,HHu'H H $   Ң #    IE u	HIP0MHCHD H;-  H;D    H(G LHu'HA H    f ($    Hu
HCHP0ID$H   IILHto   ILHt]IHȍWӵy'H H ?    0$  4  I$uID$IP0ML$     I$uID$IP0MluHHY H2 Л   ~ 8$    HKHtVH~A   H H
D H	G 
HxH HҚ p    $  P  H;u
LkL{ HCL(LxIE IHu
HCHP0IHT$@H$@  MIL$  L$0  ML$8  HL$`]2HH$   H;tmH$   HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$    HH$   ! H$   LHD$`HHH\$(HD$ (D$ fD$0HuZ@ H$   HD$`H;u`HHtH;t5@ H$   L;u@HRHL$`
 L$   M[3H$   H$   H H$   H@   H\$8H|$0HtH;t? I;   (t$0Hu?     t? eHC    u-HH     u     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$` ?3H$  H$   r H$   H$   HL$`X HHL$`;HH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$    HH$   # H$   LHD$`HHH\$(HD$ (D$ fD$0Hu,> H$   HD$`H;uaHHtH;t> H$   L;uAHRHL$` L$   M[E3L$   H$   H H$   H@   H\$8H|$0HtH;t= I;   (t$0Hu=     tw= fHC    u.HH     uf     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$` >E3H$  H$   A L$   L$   HL$`'   @ HD$0HtL$   H$   H. LMH$  LXAM[  E3Hϕ H
  HHucH H}    ɛ r$  HtHu
HCHP0M   IE u
IEIP0H$  Ht$@   E3E33HHu
HCHP0H! H    F v$  Ht$@?E3H$H  HD$HH$@  H$0  L$  L$8  
H$  Ht$@MtI$uID$IP0MtIu
IGIP0L
m D  H
 AHt$@EHL$HHt
HuHAP0HtHu
HFHP0HtHuHGHP0H$   LH$   HHH\$(HD$ (D$ fD$0Hu: H$   H$   H;uaHHtH;tc: H$   L;uAHRH$   5 L$   M[L$   H$   H H$   H@   H\$8H|$0HtH;t9 I;   (t$0Hu9     t9 bHC    u*HH     uD  HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$    ?H$    L$   L$   H$    H$   HD$(H$   HL$ H HD$XHL$P(D$ fD$ (L$PfL$PLL$ LD$PH$   H$   # H$   " L$   L$(  H$    A($`  Hp  A_A^A]A\_^[+HL$UVWATAUAVAWH   HǄ$   H$  HE3ML$  AN Ht
HL$PHIHD$PLt$hLt$pLt$xMII   r Ht
HL$ HIHD$ Lt$8Lt$@Lt$H39 LHu'H Hސ |   * T>  g  HFH;"9 t|H;!9 tsHH; HHu'H
 H
 *   ؖ Z>    H@L   Mu-H| HU     \>    HILlMuEH8 H9FuH;n  HFHHHI,H;n  I] HHIHAHH  ILHt
HuHQR0HCL   MtHE HAH2L@@MtH* H HAHH H9 HH   E3HŐ HHH   Hu
HSHR03IL$I9L$ ~HID$H<HAID$HI9 uHu
HGHP03H H׎ u   # >  LE3  H H H    >  L$  E3  H Hx    Ĕ >  L$  E3  &8 HtPH: HHGt6 2HD H    i w>  L$  E3E  Hu
HFHP0E3IMIH$   HHL$ r H$   Ht6L$   I;t!    Hg3 H(I;uH$   H L$   L$   L$   H$    +7 Ht'Hg H@ ލ    >     HT$ HL$P HT$PH$   8 HH$   HIr ȉ$  
5 LH   H HȌ f    >  MtI$uID$IP0HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
W D  H
 nMMtIE u
IEIP0MtIuIGIP0H\$8Ht)H|$@H;tH1 H(H;uH\$8H Lt$8Lt$@Lt$HHL$  H\$hHt)H|$pH;tHu1 H(H;uH\$hH Lt$hLt$pLt$xHL$P IH$  H   A_A^A]A\_^]HVWATAUAVH   HǄ$   HXHhHٹ   m E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   / H$   / HT$`HK踧 HHL$ j H\$xHt.H$   H;tfHg0 H(H;uH\$xH
 Ll$xL$   L$   HL$`
 3j2 HHu'Hk HD     W?    H\$8H;\$@v0 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v0 HtH;t$ t|0 L;  Huh0 MLM;c rT0 IH$   . Hu80 MLM;c r$0 I(H$   H$   . H$   HL$`/ HH$(  H@H} rHMHMII;}HH332 H'H=(4  tE34 HE3E31 HH. HtlHOH9O ~HHGHHAHGHH2 uHHCHP0H Hm     a?  "Hp HI     _?  Hu
HGHP0HtHu
HCHP0L
	 D \ H
U  IHHuHGHP0H$   - H$   - H\$8Ht.Ht$@H;tD  Hg- H(H;uH\$8H
 Ll$8Ll$@Ll$HHL$ 
 HL$   I[0Ik@IA^A]A\_^H\$Ht$WH IHHMt7IR0 H~)H^x E3HuH\$0Ht$8H _HHH>Hu
HSHR0H\$0Ht$8H _;H\$Ht$WH    IHHr
30  H0 Hf E38  HH   H/ LHHCH/ HH H/ HC H/ H H/ HC(H/ H H/ HC0H/ H H/ HC8H/ H H/ HC@H}/ H Hs/ HCHHh/ H H^/ HCPHS/ H HI/ HCXH>/ H H4/ HC`H)/ H !y"Hu
HCHP03H\$0Ht$8H _Ht$8HH\$0H _HWATAUAVAWH   HǄ$   HXHhHp LA   HHL$` H|$pLHt$hLHHH3HuH9H;v*  H<    HU+ HHuHt)  H|$pHt$hHL$0Ll$8Lt$@IHtHtIHHH;t)  Ht:HtIHHH;t)  HtIHHH;to)  HHMI;t%* HtHZ  HHD$0HH\$0Ht$8H|$@HHHH+HLMHM~!fHD$`f(f)HI;}HL$0LHT$0HL$`  H$   HHuHI=II;v(  HH) HHuHt(  H$   Ht$HHl$PHtI;td(  HtI;tO(  ̄tE(  H;t(H~) HtHX  HHD$HHH\$HH|$PHHH+HLMHM~!f     HD$xf(f)HI;|LHT$HHL$x  HD$0H$0  MH$   H$0  9 LHHiHuH/I;v'  H<    H( HHuHt^'  HL$ Hl$(IE HxHtI;t7'  HtI;t"'  ̄t'  H;tT( HtHW  HD$ H\$ H|$(HT$ I H$   ( DM9\$~IH9	 5*	 D  HD$ 1fT^fWAHIcI;D$|LD$ H$   HL$08 H$   H^ HHxHtI;t<&  HtI;t'&  ̄t&  I;|$t!I$S' HtHV  I$I$I|$HHH+HLMM~$f     HE f(I$f)HI;|LIH  H$   & H$   & HL$ & H& HL$0& H$   & HL$x& HL$`& L$   I[0Ik8IsHIA_A^A]A\_HLH L@WATAUAVAWH  HǄ$  HXHp)pLE3L|$XL|$`L$P  L$   AO Ht
H$p  HIH$p  H$p  ʵ  H$  ƀ   H$  H@H$  H H$  H@L$      Ht
H$  HIH$  H$  \  H$@  ƀ   H$@  H@H$@  H H$@  H@L$H  L$   ML$  I    Ht
H$  HIH$  L$  L$  L$  H HH
 ' HHtH HHHu'H H} i~ u   0!    HGL   MtH{ HAL2L@@MtHp{ H HALHZ{ H' LMu'Hr HK} } u   2!    Hu
HGHP0IFL   MtH| IAH2L@@MtH| H IAHH| I& HHu'H H| Y} u   5!    Iu
IFIP0ML|$PLgH$ I9$\  LwLt$PMJ  H_IHHHHuHAP0LcHc% I9$uvL$`  L$h  E3EAH$`  HNHHu*H
 H
{ | u  D I!  MR  Iu
IFIP0ML|$P      % HHu*H H{ <| u   W!  M
  LpML|$PIE Lh E3HHHHu*Hq HJ{ { u   ]!  M  Hu
HFHP0I=IHHHu*H Hz { u  D C!  MR  Hu
I$HP0IHCH.# H;1  H;# $  H% LHu*H Hz '{ u  Հ !  M  Hu
HCHP0IFH   MIHHtpA   IHHt]IHAT$=y*H2 Hz z u  W !  Mz  Iu
IFIP0ML|$P   Iu
IFIP0MڒuI^H Hy >z u   !  M  HKHtYH~A   H H
P# H	% 
HxHd H=y y u   m!  M  H;u
H{Hs HCH8HpHHHu
HCHP0HHD$XH$   IL|$xHt$`H$   I0   H$   HtH*B HH$   IH$      H$   HtH HHD$pIHL$pAH   E3H~{ H
u HHu*HK H$x x y  p~ !  M~  E3E33HHu
HCHP0H Hw xx y  &~ !  M  AH   E3H;y H
$u HHu*H Hw x {  } !  M  E3E33HHu
HCHP0H^ H7w w {  } !  MO  H<w H$P   HHu*H Hv w |  <} !  MJ  H$P  H
y HHu*H Hv Hw }  | "  M  H@L   MtH7y HAH2L@@MtHy H HAHHy H]  HHu*HN H'v v }  s| 
"  M  Hu
HCHP0HFH;X    H;S    HHD$hLH  HHu*H Hu Pv }  { "  M  H@L   Mu?H Hxu v }  { "  M  HHMMHD$hHu
HFHP0IL|$0Mu@H H9CuL;c   HCJ4HI  L;c}zJtHI  HAHHD$0H   HtHH  HHt, *H Ht :u }  z 2"  M
  Hu
HCHP0L$   H$P  LHL;
5 tUH; tLMILe H e H
 H	X  LA Lt t   fz i"  M2  HHL$p!%HT$XH$   HH$p  H;tmH$  HL$(H$p  HT$ H	HL$HHT$@(D$ fD$ (L$@fL$@LL$ LD$@H$   H$p   HH$p   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Hu H$   H;ufH$   MtL;t L;uIH$   HRH$    L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@tG H;\$H   (t$ Mu,     t ]HC    u%HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$   H :H$    L$   L$   H$    HT$`H$   'HH$  H;tsH$@  HL$HH$  HT$@H	HL$(HT$ (D$@f$   (L$ fL$@L$   LD$@H$  H$  E HH$   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Hu H$   H;ufH$   MtL;tc L;uIH$   HRH$   5 L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@t H;\$H   (t$ Mu     t ^HC    u&HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$    9H$    L$   L$   H$       HD$ HtL$  H$p  H荇 LMAM   E3Hn H
l ~HHu*H Hn o   4u "  MB  E3E33H|Hu
HCHP0H Hn <o   t "  M
  AL$X  L;%@ AǅP  3e HHu*Hf H?n n   t "  M  ID$H; t~H;~ tuI HHu*H Hm n   9t "  MG  H@L   Mu>H Hm Qn   s "  M
  II$IHL$hMHMuHH H9FuH;N  HFH<HHHL$h3H;N   H|HHHL$hHAHHD$xH  H$  H$  Ht
HuHAP0HGL   MtHo HAH2L@@MtHgo H HAHHQo H HH   E3H:n H
LH   Hu
HGHP0IL|$xHKH9K ~IHCL4HAHCIHS u"Iu
IFIP0ML|$PHL$hH. Hl l   Sr "  Ma  H Hk {l   )r "  M7  H Hk Ql   q "  M
  i HtHH] HHt *H H`k k   q "  M  Hu
HFHP0IL|$0H$   L$   LcIu*H+ Hk k   Pq "  Ms  H$   Ix HH H+HHgfffffffHHHH?HAL;H$       H$   H$   HH$  ! H$   S 5 Ht*Hq HJj j   p #  M  H$  H$    HI莀 H$   LHT$pI DHHHu*H Hi rj    p 3#  M.  HD$0HL$pyHHu,H Hi 1j   o ?#  Ld$0  HL$0HA8HHI8H9 uHAP0HD$0HX8H\$pHtH Ha MtI蘊 IL MtIu
IGIP0Dd$PA% HHu,H Hh i   3o a#  Ld$0?      HHu,H Hh Fi   n c#  Ld$0   HXLd$0I$L`   E3H$   HL$XH$   HD$`MH$   H|$xLt$PHt$0  E3H$   HD$XH$   HD$`MIH|$xLt$PHt$0w  H$   LH$   HtHu
HAP0LIIAL   MtHh IAH2L@@MtHh H IAHHh I HHu*H Hog 
h ~  m B"  M   ML|$PH| H9GuLwLt$PMtqHwIHHHHuHAP0IH蘻HHu'H Hf g ~  >m O"  MOIu
IFIP0ML|$PlH藼HHu\H Hf ?g ~  l R"  MHtHu
HCHP0H   H   HGHP0   Hu
HGHP0IL|$xHu
HFHP0IL|$0E3H$   HT$XH$   HT$`MLt$PI(E3H$   HT$XH$   HT$`MLt$PIMtIu
IFIP0HtHu
HFHP0L
e D<f k H
V IHL$XHt
HuHAP0HL$`Ht
HuHAP0H$P  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0MtI$uID$IP0H$  HtHuHAP0H$  Ht6H$  H;t!    Hw
 H(H;uH$  H L$  L$  L$  H$   H$@  LH$  LHH\$HHD$@(D$@fD$ Hu
 H$@  H$  H;uaHMtL;t
 H$@  L;uAHRH$   L$@  M[L$H  H$@  H H$@  H@   H\$(H|$ HtI;t_
 I;   (t$ HuF
     t7
 fHC    u.HH     uf     HH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$  Y 5H$@   L$@  L$H  H$   H$  HD$HH$p  HL$@H H$h  H$`  (D$@f$   ($`  fL$@L$   LD$@H$  H$p  n H$  m L$  L$  H$p  P HL$  I[0Is8A(sIA_A^A]A\_LI[IkIsWATAUAVAWH`L% 3MHLMcI{HI{Ml  LrIMt0Ht!HtHb  Lb(McHj Hl$HHzH|$@I
 HIMtHt,HtFmHme IL
 HHD$@H  HH_ I(
 HHD$HHtHH  H`^ I	 HtLHD$PHH\  H7Q LL$@Hk] HD$(E3ILt$ ~y
      Ld$PHl$HH|$@  H
m
 H: HD$0   H	HT$(   L
{ LP H{ HD$ x       HBH   H   HKH}   L
{    L
{ HL$0H
	 L}& H	HH: IDLNP HT$(HZ{ HD$     L
 H
<P Ao  D` o  e L
_ 3Lb(Hj HzMLHIL\$`I[0Ik8Is@IA_A^A]A\_HQ	 HH%O H\$WH H'	 HH! tH  HH\$0H _H		 HH% H\$WH H	 HH tH HH\$0H _@SH H	 HHHA2 HH [H%s H\$WH H	 HHHA HC tHB HH\$0H _HL$WH0HD$ H\$HHH H	 HHOH HH\$HH0_H\$WH H	 HHHA\ H tH HH\$0H _@SH HC	 HHHA HH [H%S HL$WH0HD$ H\$HHH H	 HHSHO HH\$HH0_HL$WH0HD$ H\$HHH H	 HHSHO{ HH\$HH0_́aI    H́aI   H@SH H	 HHt_ HH [H!	 H@SH H	 HHt HH [H(Ht
H   H(@SH H	 HHt HH [HL$HT$LD$LL$ H	 HH%G H	 H\$WH H	 HH	 tH@ HH\$0H _H	 H@SH H	 HHt HH [@SH H L	 LHH [H	 HHHH HL$ A   t L	 Hy HL$ L\$  HL$WH0HD$ H\$HHH H\	 HHSHO Hs	 HHH\$HH0_HfWE3I   H$I@HHH+LYHLRL    fD  AJBI I HAYKAYBXf(AJXABAYKAYCXXuH$M;s"H+JM+HIYHXuf(HH)f(
	 f(	 f(	 f((	 f f(fYfYfYfX
	 fX	 fYfYfXf(
	 fXf(	 fYfXfYf(	 fXfYf(
	 fXfYf(	 fXfYf(	 fXfYf(
	 fXfYfYfXfXf)$^D$HH)f(
	 f(	 f(	 f(	 f f(fYfYfYfX
{	 fX	 fYfYfXf(
	 fXf(	 fYfXfYf(	 fXfYf(
	 fXfYf(	 fXfYf(	 fXfYf(
	 fXfYfYfXfXf)$^D$HHL$WH0HD$ H\$HHH HL 	 HHSHO HK 	 HHH\$HH0_AA H1	 H̋Q<A4A@    QHTQDHH%E 3HAHAHAH\$WH HHIHHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHIHHPuHOHHPuH\$0H _ðH\$0H _Hq 	 HHL$SH0HD$ HH` H`	 HH0[HL$WH0HD$ H\$HHHD H HHSHO H HHH\$HH0_̋   tt
tt3Ë   @SH H L LHH [HL$WH0HD$ H\$HHH Ht HHSHOK Hs HHH\$HH0_@SH HK	 HHHA L[ HLH [H%9 @SH H#	 HHHA HH [H% @SH H	 HHHA L HLH [H% @SH H	 HHHAR HH [H%# Hy8rHA HA @SH H	 HHHA HH [H%C H   HD$ H	 HL$( HL$P H2 HD$PHT$(HL$h H] HD$PHr HL$P H(HHHcHHLHHt
H H(LBI HBI     uHPHBI@HA0H;PuL@ILBHBH;uL ILBL@ILBLI@HI@    uHPHBI@HA0H;Pu
L@IPLBHBH;Pu
L@IPLBL IPLB@SH H9 Huk HK    tHAHC    tH [H%A H    u/HH    u     HHI    tHCH [HI    uHH9CuHKHI    tHC    uHKH [@SH LHHuHRAHH [HHRHcHHAHH [HHHD$0D$    L
 L} 3 2HHHHHD$0D$    L
 L= 3 2HHHHHD$0D$    L
 L 3` 2HHHHHD$0D$    L
4 L 3  2HHHHHD$0D$    L
 L} 3 2HHHHHD$0D$    L
 L= 3 2HHHHHD$0D$    L
 L 3` 2HHHHHD$0D$    L
 L 3  2HHHHHD$0D$    L
 L} 3 2HHHHHD$0D$    L
 L= 3 2HHHHHD$0D$    L
 L 3` 2HHHHHD$0D$    L
< L 3  2HHHHHD$0D$    L
 L} 3 2HHH\$Ht$WH HQ 3HH+Q   HHt'H;r HFHV HH+H|H;rH\$0Ht$8H _H HH@WHPHD$ H\$`IHH?	 HL$( HHT$(HHL$( LHASHHL$(R HHT$(HHL$(X HQ	 HL$(& HHT$(HHL$(, H 	 HL$( HHT$(HHL$(  LHH\$`HP_IcH\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$Ht$WH HHHH;tp H(H;tdHH; uHH(H;t2f     HH uH(HH H(H;uHG(H\$0Ht$8H _H\$0HHt$8H _Hl$Ht$ WAUAVH LI HIgfffffffL+IIMHIHHH?HtHu HVHT HN Iƿ   H+NHHHH?HH;skH\$@Ld$HDg'H;r HFIHI HH HN IH+NHI(HHHH?HH;rLd$HH\$@H HHl$PHt$XH A^A]_H% Hl$Ht$H|$ ATH HA MHH+AHHHtHu HFH= HF    H+FHH;sGH\$0H;r H^IH H HF H+FHHH;rH\$0H HHl$8Ht$@H|$HH A\H% H\$LLLM+HgfffffffHIHLI?IL;~HIHI+HHHH?HL+H\$KHL+I@SH AHD$@    A)   HZIc$   HH Ht HH [H H[ HH [H+ HB HH [H H) HH [Hy H HH [H H HH [H H HH [H> H HH [H H HH [ ˥   5 N g     ihQp% H8  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(ihQp% H  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(H   "U A))t$p)|$`D)D$PE f(f(D)L$@D)T$0D)\$ YD	f(AXYf(YfA(YDY Y YD^\fA(Y ^fA(X^YD\YfA(AY\ 
j H$   DQ D@ fA(0\f(H$   ^AXf(f(Y^fWA^fWf(YAXA^YAXYAYAXAYYAXYf/vf(f(f/v8f/v2f(YA^AXYAYAXYf/vf(f(f/v6f/v0f(YA^AXYAYAXYf/vf(f((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   H\$WH HH
 L LHCHGHC H\$0HG HH _@WH0HA HH+AHHu
fWH0_H\$@)t$ Hu HGHO    H+H0H;s(H;r HGHO HH+HXtH;rH\$@f((t$ H0_HA HHA@HHAXD H3HHHWH@  HD$ HXHH@       DBHL$@;    HL$(2 HL$PHcQHLPHPHL$P HHL$@ Ǆ$`     HL$@ HH$X  H@  _3f(LTDIDA     A f/sffA;ufDAP f/sffA;ufDAAHkHfAB` HL$WH0HD$ H\$HHH$ H HHSHO H[ HHH\$HH0_A f/ryf(f(YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^A f/   f(f(YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A f/   f(f(YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^LL$ LD$HT$SVWH`H$   L$   HHME3HHHHHT$8Hg  H$   Ld$XLl$PKRLt$HL|$@IHJMIMHIMK,HMH$L|$0Ll$Hl$HL$E3I4  IKLHHL$ HHIM+HL$(JLH+H+MM+MELl$ IMHUH+L+Hl$(IEHHMLfD  KIHHpHBH HxI@I HAHEH M;HAIDHAHBHAHDHAHDHAKDHAHBHAI@HAKDHAHD/HAHBHAI@HAHEHAWL$   H$   Hl$Ll$L|$0H$HL$M;}_MIHML+H+H+M+JTOJL I
H HIHBHAHBHDHBHDHBuH$HL$IMIMHHl$Ll$H$HL$2H$   HT$8L$   L$   L|$@Lt$HLl$PLd$XH$   H;   HJ4    IH+H$   IfE3I|]MSJLHSIIN    M     HBH H IHAHBHAHBHAHBHAuH$   M;}JIIM;JD|HHH$   lH`_^[HL$WH0HD$ H\$HHH H HHSHO[ H# HHH\$HH0_@SH HHt*H|$0CuHHPCu	HHPH|$0H [@SH HA HHA`    H+AHHu HCHHKpHCPH+CHHHu HCHHHKpHKhH [̋A f()f(
 ufo% f%A A fo%wA f]- f_- fYfX
 fffT
 f\f(f(fY fY
 f\f\f(fYf(f(fY fY fX fX fYfYfX fX fYfYfX ff\ffrf^fpcfY fXP fYf_f(H\$WH0HA 3)t$ H+AfWHHHt,H;r, HOHHDXpHG H+HH;rH\$@f((t$ H0_@SH H HHt? HH [H(HQHI. H/ HH(H%) @SH HHQHI HH H HH [H% HL$WH0HD$ H\$HHH9 H9 Ht
H} HHH\$HH0_H\$WH H' HHHA L5 HL tH HH\$0H _H\$WH H HHHA| H tH¸ HH\$0H _H\$WH H HHHA, Lm HLi tHh HH\$0H _H\$WH Ho HHHA H tH HH\$0H _H\$WH HG HHHA| H tH· HH\$0H _@SH HH	HtHP tH    H [@SH H9 Hu HK    tH [H% HA    u.H    uf     HH	    tHCH [HI    uHAH9CuHKHI    tHKH [HL$SH0HD$ H\ u
HW HHHcHHLHHt
H H0[HHLHuKH藶 HH3HIH(sE3HT$XHL$ LD$XK LD HR HL$ L\$ B HHLHuJ    ' HH3HIHsE3HT$XHL$ LD$X L H5R HL$ L\$ ҵ HHLHuJ    践 HH3HIHsE3HT$XHL$ LD$Xk Ld HQ HL$ L\$ b HHLHuK@HG HH3HIH0sE3HT$XHL$ LD$X L HUQ HL$ L\$  HL$VWATAUAVH@HD$ H\$xDH3ۉ$   LHL$(HLc@ILHHtH HHcH|1 uHL1PHt HHcH|1 D$0   H|1(H3HϋD1%  @t=A      H~0HHcHT1XHL1H AD܉$   HA   HHcHAHL1HS AD܉$   u/H~*HHcHT1XHL1H% AD܉$   HHt$p$   Ll$(HHcHHD1(    HHcHHE3  u
I IE HcHJL)HHtHa HHH\$xH@A^A]A\_^HL$VWATAUAVH@HD$ H\$xLH3ۉ$   3HHHLiHHcHH|1(H~
I;~I+3LHt$(HL1HHtH HHcH|1 uHL1PHt HHcH|1 D$0u
      D1%  @t6H~-HHcHT1XHL1H u$   H΅u]HHcHMIHL1Hk I;t   $   2H~-HHcHT1XHL1HD u$   HHHcHHD1(    Ht$p$   Ld$(HHcHHE3  u
I I$HcHJL!HHtH} HHH\$xH@A^A]A\_^HWH  HD$ HXHhHpIIHHٺ   DBH> HH$   HH HHHH HHHȋU  HH$  }HT$hH$    HHL$(, Hl HD$(HHL$@ H HD$(HMN HL$(7 HD@WHP  HD$0HhHpIHHD;$        DBHL$`5 Hy HL$`HHHHV HH$   HH HT$8HL$` HD$@H|$XHCD$@HD$ L
 L$p  HH(L$P  IkIsI_HD@WHP  HD$0HhHpIHHD;$        DBHL$`E H HL$`HHHHf Hȋ$   HH/ HT$8HL$` HD$@H|$XHCD$@HD$ L
 L$p  HH9L$P  IkIsI_H\$WH HH( I$HHH H
HH H HH\$0H _H% ATAUAVAWH(HQ I*E3H+QIE3LHHHH?H   H\$PHl$XHt$`H|$ 3L;r I~3۽   HL> H+L>HHt)H;r HD>HL> HH+HlH;rIN III+NDH0HHHH?HL;rH|$ Ht$`Hl$XH\$PAH(A_A^A]A\H(Hu3H(HH;vH\$ H    HE HuHtH\$ H(H\$Hl$Ht$WH HAIIHHHAH;t4H	 HtH\HsH{HH    HsH{LALIH\$0Hl$8Ht$@H _H(y t	H	 H(HH B(H\$Hl$Ht$ LD$WATAUAVAWH LT$xL$   Ht$pLIIHE3E3ۃH<HHH|$H  H$   MMlL+H    MxL+HL$L,$ILd$fff     L3H  H\$`IDkIkHL$LH|HNKTHIMHHHH    Lfff     IBHHpIBHxIHBIBMHBIEHBIEHBIE HBIEMHBID$HBID$HBI$HBID$MHBHGHBHGHBHHBHGIHHB_L,$H|$Ld$LD$`H;}RHKLL    HIITLL+OHBH HAHBHAHHAHBIIHAuLD$`HL$I IMI L;L,$oLT$xL$   I;   L$   L+M,LT$xD  ME3H   H~LHDm HIHHKLHL$    MMM\ I\ MfIH LHAHHHAI LHAILHHAuLT$xL$   L;}.IHL    HI+IL HIIHKDuIIH+I+LILT$xH\$PHl$XHt$hH A_A^A]A\_LL$ LD$SUVWATAULl$hH|$XLILL$`E3IIHH,HHH   HD$pLL$HILl$PH+L]H+IH4    HI    LH~<KN    IHfD  fH If)@fAIHf)@uLI IuH\$PHt$HLL$`Ll$hIH+H|UL\$pKZH~4L    HLfHHIDHBIIIDuLL$`IH+I+HLAL\$pI;  Lt$8H+L|$@L<L4fD  ME3H   HL] HD] LHKTILHHwHMIHL,    M IH MHBHIHBHIHBIMHHBuH\$PL\$pHt$HLL$`L;}0IHL    HHI+HHIIHKDuHD$hHIH+II+LI;L|$@Lt$8A]A\_^][H\$Hl$Ht$H|$ ATHPH$   HH$   )t$@)|$0f(f(Y= H|$(IHf(LH\$ Pf(M$LHIH|$(H\$ ASM$Lf(HIH|$(H\$ ASH\$`(t$@(|$0Hl$hHt$pH|$xHPA\@SH LHH~qLHIIgfffffffMQIIH+HHHH?HL;|M+IIHHH?HL+KHHHKI;IuMHC    H [y:IM~%HQHuHHPH	HCHH [yIIBHH [HWH  HD$ HXHhHpIIHHٺ   DBHn HH$   HHO HHHH1 HHHȋU % HH$  HT$hH$   
 HHL$(\ H HD$(HHL$@ H HD$(HA HL$(g HWH  HD$ HXHhHpIIHHٺ   DBHn HH$   HHO HHHH1 HHHHU  HH$  HT$hH$   	 HHL$([ H HD$(HHL$@ H HD$(H|@ HL$(f H\$Hl$Ht$WH LHHgfffffffL+IHIHHH?HHI,H;tH+fHH+ H(H;uH\$0Ht$@HHl$8H _H\$WH HHM IHHHL HHH H HH\$0H _H% H\$WH HHPQ ITHHIH>N H:H~ H? HH\$0H _H%3 H\$WH HH(Z IHHH&Q HH H HH\$0H _H% H\$WH HHY IHHHY HzHu H~ HH\$0H _H%r H\$WH HHxY I4HH)HZY HH H HH\$0H _H% H\$WH HH Y IHHHY HH H HH\$0H _H% H\$WH HHX ItHHiHX HZHU H^ HH\$0H _H%R H\$WH HHpX IHH	HRX HH H HH\$0H _H% H\$WH HH X IHHHX HH׿ H HH\$0H _H% Hh)t$P  )|$@  L
 L D$     D)D$0D  3@ LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     蓝 HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
[ LT D$     D)D$0D  3  LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     S HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
 L D$     D)D$0D  3 LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
/ LX 3D$      HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
 L D$     D)D$0D  3耚 LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     ә HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
; L D$     D)D$0D  3@ LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     蓘 HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
 LT D$     D)D$0D  3  LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     S HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_HWH  HD$ HXHhHpIIHHٺ   DBH HH$   HH HHHH tHHiHM c HH$  KHT$hH$    HHL$( H: HD$(HHL$@ H7 HD$(H4 HL$( LL$ LD$SUVWATHHl$hLd$`HHE3IHI؃LIIM~`MKIIfM~?JL    HIf     fH If)@fAIHf)@uH IuH\$PHI+H|CM~:L    JIfffff     HIJDHAIHJDuIL;
  Ll$@Lt$I;L<$N4L<fff     E3I   I{I{LHIl$JTHIHHMIL,    HM    IH MHBHIHBHIHBHIHHBuH|$XH\$PHl$hM;}0IIL    HII+HHIIHJDuIIIL;&L<$Lt$Ll$@HA\_^][H\$Hl$ LD$VWATAUAVHLT$hLl$`LIIE3HE3IH<HHH|$H  MdL|$@MxL$$     3I   IDsIsLHKTIH|Hl IMHMHHHH    LfIBHHpIBHxIHBIBMHBID$HBID$HBI$HBID$MHBHEHBHEHBHE HBHEIHBHGHBHGHBHHBHGIHHB_L$$H|$Hl$PI;}RHMKLL    HIL+OHTHBH HAHBHAHHAHBIIHAuI II L;L$$LT$hL|$@I;   L+Hl LT$hE3I|~I}LHvHIHHKLHL$    LLL\ H\ Mff     IH LHAHHHAI LHAILHHAuLT$hM;}.IIL    HI+HL HIIHKDuHILT$h3H\$HHl$XHA^A]A\_^HWH`  HD$0HXHhHpIIHH3EEE;|HHrp   DBHL$`P HH HL$pvHL$pѱ HT$8HL$`9 HD$@H|$XHCD$@HD$ L
 LHHL$`  I[IkIs I_HWH`  HD$0HXHhHpIIHH3fAnA@ f/rHHrp   DBHL$`s Hk HL$pHL$p HT$8HL$`\ HD$@H|$XHCD$@HD$ L
 LHH`L$`  I[IkIs I_HWH  HD$ HXHhHpIIHHٺ   DBHN HH$   HH/ HHHH HHHHU ܯ HH$  HT$hH$    HHL$(; H{ HD$(HHL$@ H HD$(H\, HL$(F HWH  HD$ HXHhHpIIHHٺ   DBHN HH$   HH/ HHHH HHHHHH$  HT$hH$    HHL$(= H} HD$(HHL$@ Hz HD$(H+ HL$(H L	 LLMu    A   H L H HHL$HHI;HD$IMLMM~I3II3I;}HIHSH  HD$p)p)xIf(f(HB HL$H    DBH$   ' HHPH	 HL$ î HT$ H$   _ HL$ î HT$HH$     Hf( HH HT$ H$    LHHAHL$ h H| HL$ 6 HT$ H$   Ҭ HL$ 6 A HT$`HL$  HH$    Hf(l HH UHL$  HT$ H$    LHHAHL$  H HL$  HT$ H$   ' HL$  A HT$`HL$  XHH$   Ҭ Hf( HH# HL$ : HT$ H$   g LHHAHL$  LHASH$   = HL$H ($  ($  HĠ  [H%! H\$WH H tH HH\$0H _MLAuGHA L HAXLcHA@IcKLILM+M;IB KL IB@D+HIBXED 3HHBBHHD$0MLt3HHBBHHHA H$HHA@HIBXLc L+LH+EtwAtBA   M   M;   IB HHIB@I+IHIBXD+DD XJHxbI;]HIB HIB@D+HIBXDD )Mx7M;2IB JHIB@D+HIBXDD IJ@IB H	H+H
HH$3HBBHH@SH HH	 HKܫ HKH [H%̫ D$HD$HH#H H;w	HH      H;s   H¸    HH   )p)xf(J f(D)@D)Pf/fEWfD(fA(vf( fWμ c  fA.zR  fA.zE  D)$   D)\$`D fA/D)d$PD)l$@D)t$0D)|$   D
c D fA/r6fff     fA(A\Xf(W fA/Xsf(A\     
w %g 
 DM D
< D+ D% z
 
z
 %z
 Dy
 D
x
 Dw
 D%v
 <D%k
 DZ
 D
I
 D8
 %(
 

 
     D5w D=f 
  E D  $ D5s   D=b z  fE(m D=: D5) D- f(AXYf(YAYAXYXYXf(AYAXYXf(Y
 YX
 Xf(YY X
 X YAXYYAXYXAX^YY5 XV  D
b fD/vf( fA(fD(\AX f/       
 5o f DU DD D%3 D-" 
 
 5
 D
 D
 D%
 D-
 <D-{
 D%j
 DY
 DH
 58
 
(
 
 ux D5 D=r 
 	 Q D
	 	 0 D5	 	  D=~	 	 D=k	 D5Z	 D
I	 fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
&	 AYX
		 Xf(YY AXX YAXYAXAYX^YY%- X  v	 uq%
  5 Q	 D D D% %  5 D D D% 3D% D D 5  %  uz
2 D-! D5   D= 
f 
 
^ 
 D
% 
M D- D5 D= $D= D5 D- D
 DYfW-7 f(f(YYf(AYAXYXf(AYXYYf(Y
 Xf(Y X
 XYAXAXYYAXAXYX^AYDY AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIHT$WH0HD$ H\$@HHH        Ht@   @   H
_ HHx3HHH\$@H0_HT$WH0HD$ H\$@HHH       q Ht@   @   H
 HHx3HHH\$@H0_HILH+HH(  HH$HHHHHL    IL
f/v
H;t	A
f/vL;t	A

f/v
H;t	A	IKI+ f/vL;t	A	Af/vI;t	A	A	 f/vL;t	AIIH+H$I+f/v
H;t 	A f/vL;t	A f/v
H;t 	A	f/vL;t	A
Af/vI;t	 A	A	f/vfL;taA
H
f/v
H;t	Af/vL;t	A 

f/v
H;t	HHVWATHP  HD$0HXHhIIHL   DBHL$`! HHL$`HH HHVם HHE HT$8HL$` HE H+EHH;r HE$  HT$@H|$XHCT$@H$  HD$ L$  L$  I(L LLMu    A   H L H HHL$  HH	I;HD$IMLMM~I3II3I;}HIH(HIHt
H   H(H\$UVWH0I@ 3II+@HHHHtNLd$PI      H;r HOD$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]Hn LLHD$(H< HHHD$ H8HD$  H;tMtHI IHIH8H\$H|$ 3HLH9yLH|$   MQMM;},HI	MMIHSIIHJMQM;|IAHT$HL$I;HD$HMHLI|bMZff     IIIIHH<IIIIHH|IIIIHH|IIIIHHI;H||I;}IIIIHHI;H<|IM;ALD$H\$H|$ LL$ LD$HT$HL$SUVWATAUAVAWH  H$   HLHHT$t
LHT$`+HHD$HT$(HHكH;HL$(HMLLT$`LM+IML\$PICH$   IHH3H+LIAu33ILcHl$L$   L$  IՃtH&IHD$LL$(HHكH;HL$(IMHE3Ld$0Ld$ EL$HujHuefff     HHH3H+L;tIIILd$ |IuE3L$   Ld$0.M;H$   HL$ HML Ld$0E3E3LT$`L\$P$@  fW   L;ADL;DDHcII+IcHHHM<M;L$    L$  L$8  L$  )$  )$  D)$  H$0  IID)$p  D)$`  D)$P  HH$   ID)$@  D)$0  D)$   HH$   ID)$  IHIH$   H$0  IL    IHK<1HH|$pH$   HIHIHHT$(IT$HIIL$0  HML$   N&H$0  N$1ILd$ MIH$8  O,0HJ42L$   H$   IH$   HLM+LL+HI+HD$XH+IH+D$0L4$LL$HHHL$hHHHD$    D$D$f(E3IfD(fD(fD(( fD(fD(fD(fD(.  MLML$   ML+L+L+MLL$LL$XHVHl$LIML$   LHGH$   M+LL$ML\$M+L$   LL$hLL$   ML$   L$   L+LL$xLL$HLH$   LL$@MJHt$@IIN    LT$8LT$xff     A08H I H H If(f(Y@YIXDXf(YBAYPf(DXDXBT!BYL0DXf(f(Y@YIXf(DXBYD8Y\(DXDXB\*f(f(Y@YIXf(DXBYDYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   DT$DL$H|$pH$  H$   Ld$ L$   L|$8L4$M;}uILMILH+L+L+JI+AHHf(f(Y@YLXf(DXAYD AYTDXDXuDT$DL$M;$  H$   HE  H  H   M;  L4$III+LMHLH+HL+L+HJfB(0f HHfYfDXfDfYfDXfBD fYfDXfADfYfDXu)  L;$   fB(DfC(LMfG(|f)$   f)$   U  JHHHD$8KDLfD(fD(Hl$8HD$@H$   L\$@I+H+HH+L+HNLO|HM4f     fA(qfA(fA(oI I fA((fB(
EI H HfYfYDf(fAXfDYfAYfAYfF(T	fE(KfD(fAXfAXfDXf(EfA(fE(fYAfD(fA(CfAXfYfYfD(fDXfDXfD(fDX4DL$DT$$@  L\$PH$  M;  L<$III+LMHLH+HL+L+HJfff     fB(8f( HHfYfDXfDfYfDXfBD fYfDXfBDfYfDXu  M;  L4$III+LMHLH+HL+L+HJff     fB(0f( HHfYfDXfDfYfDXfB(D fYfDXfBDfYfDXu~M;}yL4$III+LMHLH+HL+L+HJאfB(0f( HHfYfDXf(DfYfDXfB(D fYfDXfB(DfYfDXufA(fADXfA(AXfADXfA(EXfADXfA(EXfADXEXL;M  HI+H  L$MLLL+L+L$   MOL+JTKLLD$8LD$XJDH$   LLD$xLM+LD$@MM+L$   LD$hLL$   MLd$xL$   L+L$   LD$HLH\$8LD$LHl$@Ht$M+IIIOL$   LT$L$   B8H I H H If(f(Y@YIXDXf(YBAYQf(DXDXATBYL0DXf(f(Y@YIXf(DXBYD8Y\DXDXA\f(f(Y@YIXf(DXYD)BYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   H|$pH$  H$   Ld$ L$   L|$L;}kL4$ILMHLH+L+L+I+JB0HHf(f(Y@YLXf(DXBYD BYTDXDXuH$   H$   L$   fWYDYX9L$   HT$(DYDY9EXHD$XHD$hHD$HEEXEDXL4$LH$   DHLHLH$   L4$HHLLHl$H|$pHT$(L$   H$   Ld$ H$   L$   L$   VL$   L$  L$  D($  D($   D($0  D($@  D($P  D($`  D($p  D($  ($  ($  HD$0M;  H$8  H$  H$  (% H    H$  IHH$0  L$IHMD LLIIIM+L$  fffff     3If(f(|jIRHKI@HI4HH<    HH H HYIY@Xf(HX@YIYAXXuI;}&IIIH+HHY@XuM;   AAu@M;}|IKII+HHHff     f(HHfYAfXuAM;}<IKII+HHHff     ff(HHfYfXuf(fXXL;I   HI+H|wHJLKDI+I4HHHI<ff     H0H H HYIY@Xf(HX@YIYAXXuH;}&HIIH+HHY@XuH$  fWYMH    LAX$A$MIHD$0HtfWL$  E3L3HD$0Hĸ  A_A^A]A\_^][LD$HT$HL$UVWATAUAVAWH`  Hl$ H  )0  )   HIMLHD)  D)   D)   D)   D)   D)   D)   H;v]L  3IHDH  L3HIDH   H    H=   E Ity3H|QLON    IJIIJ    HIH HAHIHAHIHAHIIHAuH;}J    HHHH;ID|L  D  fEWHOMN    HHM IHU8HE8    HE HNIIҋI+ѸH#I+IHHU0   H   IO49HI+M]H   HMHH   IMI+MH]xHE(M+II+L}MHEM+   I+LUpL]`H   HL   I+L}8HU H   HCLu@LeH;  f(=K fE(fE(HMKfD(H+fA(EYGY;H  AEEfDAfDAu&IH  LEXHHكH;HMXICHLHfA(I+fA(LEPHI@H   IYBYL0lAXCAXACf(AYXACY,;LAXI;#  IH+H  HM8H}I@LE HEhH   I\ IJL]0NL LE0HE(IHH  ILu(H+ILEH}XH  LeXfD  IAAAII H AYAYaXH CXLCLKf(YIAYAXf(AYXADAYXAXL9AL9CD1YAYDXAQXf(f(AYAYXBXL!BL!f(BYTBY\XAQXAYf(AYXAXLALYSYcXXL;}hH  LEPL]`Lu@LeM;scIIO,MH+JI+HHAYf(AYXBXLBLBD YYDXXuOL L;s{LeHII+I+HHII+HMHff     fAffIHHf(fYfAYfYfAYfAXYfDXfXfXfA)YuH;  H]HH+H  L]N<HGN$+KMH]PL  H  H}PHEhILLuMLHDL+O<+ffff     YP!HH H I f(f(AYAYXBD AYAXLALAYQAYYXPXYf(AYXBXL BL DYBYD XPXf(f(AYAYXBXL9BL9f(YT9Yd9XPXAYf(AYXCXLCLAYQAYYXXH;UhH  L]`Lu@H]H;sdMHN+IL+HH+BHHAYf(AYXBXL BL DYBYDXXuL   L   H]xf(fLE(LELE0XfA(XfADXAYAX{DXLeHMHL}8EYEXA{MLEpHEIIMIH]xLEpL]`L,    I   w<H   HHH;w
HHH0g H+LT$ IIIB LHM؀H  H  L}H   HMML HHHL+HLL+H;   HE fA(fA(IHHMHHBY\f(AYDIK8AXAfH;},	HHf(YXDDAYLXHMHAYLLIAXQAQa}  t
H   0 H  (0  (   D(  D(   D(   D(   D(   D(   D(   H@  A_A^A]A\_^]Hl$ WH H\$03Ht$8IHHtHJHͲ(/HF HH+FHHtbLd$@LgfHtHHͲ,IEHF H+FHH;rC HVIH} HF HH+FHH;rLd$@Ht$8H\$0HtHo)HHl$HH _钧@SH H HHHIHtHP tHC    H [@SH  HD$  HH         DBH$   } H H$   ȨHH| HH} } HT$hH$   y} HHL$([ HC HD$(HHL$@~ HX
 HL$(r[ HĐ  [HWH  HD$ HXHhHpIAHٺ   DBHo| HH$   HH\ HHE Hȋ=| HH ƧHH 跧HȺ   | HHǠ 蚧Hȋ{ HH脧HH$  tHT$hH$   { HHL$(#~ Hc HD$(HHL$@| H HD$(H
 HL$(.Z E  HWH  HD$ HXHpAHH   DBH{ H H$   跦HH 訦HH蝦HH 莦HH胦HHQ tHȋz HT$(H$   6{ HT$0H|$HHCT$0H$   { HL$P| H: HD$PH$   HL$h{ HJ HD$PH
 HL$P Y HWH  HD$pHXHpH   LAH HL$H{ Lx HHL$ z H$  LHHAHL$ 	{ HL$Hz H HL$ z HHT$ HHL$ z LHASi  C$  ;>  Hv HL$ {z H$  HHT$ HHL$ yz H HL$ Gz HHT$ HHL$ Mz w0fH*f(Y H,ȉO4Y
 H,G8++w<HW HL$ y HHT$ HHL$ y    DBH$   x H H$   HȋW4Zx HT$HH$   x LHHAHL$Hy H HL$ Ty HT$ H$   w HL$ Ty HU H$   蠣HȋW<w HT$HH$   ax LHHAHL$Hy H HL$ x HT$ H$   rw HL$ x H H$   "HȋW8^w HT$HH$   w LHHAHL$Hx LHASH$   w w0DG4DO8O<HHL$  I[IsI_@SH0HHQHI)t$ f(w HHw Hu HeHf(`w Hiw H(t$ H0[H%]w H\$WH HHQHIA"w HHw H HHTv Hv HH\$0H _H%v H\$WH HHQHIIv HHv H H藡HHv Hv HH\$0H _H%v E   H\$Hl$Ht$WH HHHQHIIcIIv HH=v H HHOv    H;},fD  HOH Hu HH;|Hu HOu H\$0Hl$8Ht$@H _E  UVWATH(H\$PHc\$pIcILH   HQHILl$XL|$ xu IHlu Hmu Hlu LL   Lt$`L4    HNHV2u HM u I~5H]I|$D  HNH Ht HHuHt HNt IIuLt$`Ll$XL|$ H\$PH(A\_^]HL$WH0HD$ H\$HHHDv HL HHSHOu HH\$HH0_HL$WH0HD$ H\$HHHu H HHSHOt HH\$HH0_HL$WH0HD$ H\$HHHu H HHSHOkt HH\$HH0_HL$WH0HD$ H\$HHHTu HDx HHSHOt Hsx HHH\$HH0_HL$WH0HD$ H\$HHHt Hw HHSHOs Hw HHH\$HH0_HL$WH0HD$ H\$HHHt H~ HHSHO[s HH\$HH0_HL$WH0HD$ H\$HHHDt H|} HHSHOs HH\$HH0_@SH H HH(HAH1v Ht L LHKHtHP tHC    H [H\$WH H? HH(HAHu Hs LK LHKHtHP tHC    @tHO HH\$0H _@SH H HH(HAHIu HHs L LHKHtHP tHC    H [H\$WH H HH(HAHt Hr L{ LHKHtHP tHC    @tHN HH\$0H _H\$WH HH, HHHJHKHtHPHGHCHGHCG C HH\$0H _H	DN H\$WH 3HHHAHA HA(Ht0HH;vwHߗHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht4HfffffffH;vYwHHHCHC HHC(H\$0H _@SH HHIHtUM 3HCHC HC(H [H\$WH 3HHHAHA HA(Ht0H?H;vvHOHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht7HUUUUUUUH;vYvH_HHHCHC HȰHK(H\$0H _H8HD$    yL HD$HHt3H3HPHtH
HPHtH
ƀ   ƀ    H8H\$Hl$Ht$WH IIHHu%3HHkHl$8HsHt$@HH\$0H _HH;vnH<    HCo HuHtmH\$Ht$WH IHHu3HHsHt$8HH\$0H _HH;vmH<    Hn HuHtumHL@WHP  HD$0HhHpIHHHc$  L;      DBHL$`2l Hv HL$`HH赗HHS 覗Hȋ$  k HH 臗HT$8HL$`k HD$@H|$XHCD$@HD$ L
 L$p  HHL$P  IkIsI_@SH H+MHH    J H~LLHIem HH [@SH L+LIIJ    J
MtLMH%m HH [@SH H+MHH    J H~LLHIl HH [@SH H+IHH    H+H~LLHHl HH [@SH H+IHH    H+H~LLHHfl HH [HL$WH0HD$ H\$HHHl Ho HHSHO[k HtH@3H. HG@HKHOHHtHPHCHGPHCHGXC G`H HHp HG@HH\$HH0_H@  @SH HC HHH HA@HIHHtHP tHCH    Hn HKHj HH [H%k @SH H+ HHH HA@HAhHcPHے HD
hHAhHcPH DBDD
dHH HA@HIHHtHP tHCH    Hn HKHi HH [H%*k HcAH+Hx鰃  H@駃  @SH H HHH HA@HIHHtHP tHCH    Hl HKHci HH [H%j H\$WH HO HًHH  HA@HIHHtHP tHCH    Hl HKHh HDj @tHBF HH\$0H _HWH`  HD$0HXHhHp IIHHI@ I+@HL;      DBHL$`g H HL$pɒHHf HH 讒HH\ 蟒HH 萒HH֑ 聒HT$8HL$`Qg HC H+CHH$  HD$@H|$XHCD$@HD$ L
w L$  HHL$`  I[IkIs(I_HLH WHp  HD$0HhHpIHHL;$       DBH#f HH$   貑HH觑HT$8H$   f    DBH$  e H  H$  gHH$  WHH$  GHH 8HH$  ge HH HT$`H$  ue HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
[ L$  H蓴L$p  IkIsI_HSH   fW)pD)Hf/fD(   u"5x 3fDWfA(fW  x fA/v+fDW
x fA(
x \f(  fDW
]x 3fA(aXn   ,x )$   D)$   f/D)T$pD)\$`D)d$PDn D)l$@D)t$0D)|$   d fA/vRfD.z   u%6 %  % AYDY
 AX  m u[ 
ё - H 5 =   
  -  5  =  (= 5 - 
  uaD1 D%  D-  D5 D\ D%[ D-Z D5Y D0 fE(-D5@ D-/ D% D
 D fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X% AYtu fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [ fA/v
n fA/  8 uuDK D%: D-)  D5 D=  De D%d D-c D5b D=a a -D=N D5= D-, D% D
 urv D t  L  4        fA(fE(D\AYfW t fA(fA(AYAY> f(f(f(f(Yo Y
7 X
 AXAYYYX
 AXAXYAYYX
 Xf(Y A^X AXYX AYX^X Yt fA/  !  uuDČ D% D-   D5 D=w g D D% D- D5 D=  -D= D5 D- D% D @ub @DC ] = ŋ 5  -  % }  fA(fE(D\AYfWr fA(fA(AYAY< f(f(f(f(Y  Y
 X
 AXAYYYX
 AXAXYAYAYXf(Yv AXA^XT YXX
4 ^X Yy fA/  & xvDa D%P D-?  D5$ D=  D D% D- D5 D=  -D=s D5b D-Q D%@ D/ rc D ^  ^  F  .    fE(fA(D\ AYfWp fA(fA(AYAY: f(f(f(f(Y Y
e X
M AXAYYYX
# AXAXYAYAYXf(Y AXA^X YXX
 ^X- Yv6 	   D D% D- 	 D5Ƈ D=  
 D$ D%# D-" D5! D=    
  -D= D5 D- D% D 
rs 
Dn X h  ` І X  P  H  @ fE(fA(E^AYfA(fA(fWm AYAY7 f(f(f(f(Y# Y# Y
 X
˿ AXAXYYYX
 AXAXAYYYX
n AXA^Xf(Y| Xd YXH AYX^X YLHLH WHp  HD$0HhHpIHHL;$       DBHX HH$   肄HHwHT$8H$   X    DBH$  X Hv H$  7HH$  'HH$  HHv HH$  OX HH}v HT$`H$  EX HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
+v L$  HCL$p  IkIsI_HWH  HD$ HXHhHpIIHHٺ   DBHW HH$   HHou HHHHQu HHHM HuH{ HтIHW H$  H豂HT$hH$   W HHL$(`Y H[ HD$(HHL$@X H[ HD$(H
 HL$(k5 H8HD$  HtHtI HHHH8HVWATHP  HD$0HXHhIIHL   DBHL$`AV HHL$`ӁHH!z āHHVU HHea 訁HT$8HL$`V HcHE $  HT$@H|$XHCT$@H$  HD$ L$  L$  I\HL$WH0HD$ H\$HHHW H,Z HHSHOV HCZ HHtH@3Hty HG@HKHOHHtHPHCHGPHCHGXC G`H` HHf HG@HH\$HH0_H@H(H(GHL$WH0HD$ H\$HHHW HLY HHSHOU H{Y HHtH@3Hx HG@HKHOHHtHPHCHGPHCHGXC G`H HH HG@HH\$HH0_H@{  HL$WH0HD$ H\$HHHHx HHJHOHtHPHCHGHCHGC G HS(HO(	V H| HH  HG(HH\$HH0_HL$WH0HD$ H\$HHHH{w HHJHOHtHPHCHGHCHGC G HS(HO(yU H| HH HG(HH\$HH0_HL$WH0HD$ H\$HHH$U HX HHSHOS 3HGHHGPHGXG`HF| HH,| HG@HH\$HH0_HL$WH0HD$ H\$HHHT HV HHSHOkS 3HGHHGPHGXG`HV| HH\ HG@HH\$HH0_LALIHH+HLIHHHHM   IIf(
~DHf(B~+HALR HH    fAX
fAXBI HuL;fX~fXM;f(fX}dII+H|>IJDI+HHHMfD  XHH HXHXHXHuM;}JM+XHIuf(M
   L;A~YI@H|5IHIAHHH   X@H HX@X@X@uI;}IL+X HIu@SH HC HHH& HA@HAhHcPH HD
hHAhHcPHz DBDD
dHHLt HA@HIHHtHP tHCH    HT HKH)Q HH [H%jR HcAH+Hxpv  H@gv  @SH HH(H̀ HAH HHC@HcPHw HD@HC@HcPHkx DBDD<HHS HQ Lxs LHKHtHP tHC    H [H(v  HcAH+HPu  @SH HH(Hd HAHA HHC@HcPH HD@HC@HcPHw DBDD<HH0S H/Q Lr LHKHtHP tHC    H [H(u  HcAH+HPu  @SH H#~ HHHfr HA@HIHHtHP tHCH    HR HKHCO HH [H%P @SH H HHH~ HA@HAhHcPHK HD
hHAhHcPH} DBDD
dHHq HA@HIHHtHP tHCH    H.R HKHN HH [H%O HcAH+Hxt  H@t  HSH   fW)pD)Hf/fD(   u"5` 3fDWfA(fW  ` fA/v+fDW
` fA(
` \f(  fDW
` 3fA(aXV   \` )$   D)$   f/D)T$pD)\$`D)d$PDV D)l$@D)t$0D)|$   z fA/vRfD.z  ڵ u%fz %  % AYDY
5z AX   u[z 
z -y p 5y =y ( 
( -( 5( =( (= 5 - 
 ޴ uaDay D%Py D-?y  D5%y D D% D- D5 DX fE(-D5h D-W D%F D5 D$ fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X%Mx AYtu2x fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [w fA/v
l fA/  ` uuD{w D%jw D-Yw 8 D5?w D=.w w D D% D- D5 D=  -D=v D5e D-T D%C D2 urv D  ܱ |v Ա dv ̱ Lv ı 4v  v  fA(fE(D\AYfWP\ fA(fA(AYAYI& f(f(f(f(Y Y
_ X
G AXAYYYX
 AXAXYAYYX
 Xf(Y A^X AXYXȰ AYX^X3u Ytu fA/  I  uuDt D%t D-t  ! D5t D=t t D D%
 D- D5 D=
 
 -D= D5 D-կ D%į D @ubt @Dk  e s ] s U s M s E fA(fE(D\AYfWIZ fA(fA(AYAYB$ f(f(f(f(Y( Y
 X
خ AXAYYYX
 AXAXYAYAYXf(Y AXA^X| YXX
\ ^Xr Yyr fA/  N xvDr D%r D-or % D5Tr D=Cr 3r D D% D- D5 D=  -D= D5 D-y D%h DW rcq D   q  vq  ^q  Fq  fE(fA(D\#q AYfWFX fA(fA(AYAY?" f(f(f(f(YŬ Y
 X
u AXAYYYX
K AXAXYAYAYXf(Y; AXA^X YXX
 ^X]p Yv^ 	   D3p D%"p D-p 	/ D5o D=o o 
o DL D%K D-J D5I D=H H 
H -D=- D5 D- D% D 
rsCo 
D   o   o  n x n p n h fE(fA(E^AYfA(fA(fW*V AYAY-  f(f(f(f(YK YK Y
 X
 AXAXYYYX
ũ AXAXAYYYX
 AXA^Xf(Y X YXp AYX^Xm YLHH   )p)xD)@f(D)HD)PD)XD)`D)l$@D)t$0? D)|$    D
s D%r D-r 
 D5r D=r r Dr D
 D% D- D5 D=  D
 D fE(?D Dz D=a D5P D-? D%. D
 5J fW\fD(Xf(f($   YD^fA(AY $   Y
T DYDYL$   DXש EXD(|$ DYDY^EXD(t$0EXD(l$@XA(sDYDYA({EXE(cEYEXE([EXE(KEYE(CA\E(SIHH   )p)xD)@$   D)HD)PD)XD)`D)l$ D)t$ D)<$u
qq 
n p 
^ uoBq 2q 5"q A =	q Dp D
p   5 = D D
 2D
ڨ Dɨ = 5   %H    D`p D%Op D->p  D5$p D=p p D D% D-  D5 D=  %Ƨ fD(6D=ާ D5ͧ D- D% D D $   L$   f(\\-`o $   \-Go \f(YYf(AYE(KX$   YXf(AYE(CYXA(sYf(AYD(<$XXAXD(l$ YAXf(E([Y YA({AXD(t$YAXE(cYAXE(SX^YY-nn Xf(I@SH HD$0    HH [LD$SVWH0HD$ IHHH\$PH;t+H\$XH\$(Ht
HHE= H(H\$`H(HH0_^[HATH`  HD$0HXHhHpHx IMHHHY H+YH|C;}HH;r= HFHj   DBHL$`; H` HL$pfHȋV; HT$8HL$`; LL$@H|$XLCL$@Ld$ DǋH
m fL$`  I[IkIs I{(IA\HATH`  HD$0HXHhHpHx IMHHLQ L+QH*IHHHH?H|#G;}HH;r< H[HHFj   DBHL$`: H_ HL$peHȋH: HT$8HL$`: LL$@H|$XLCL$@Ld$ DËH
l XL$`  I[IkIs I{(IA\LD$SVWH`HD$ IHHH$   HL$09 H;t?H$   H\$(HtHT$0H: HH: H(H$   H(HL$0: HH`_^[HL$WH0HD$ H\$HHH,; L? LHGHCHG HC H;] HC(HO0HK0HtHPHG8HC8HG@HC@GHCHHWl HH=l HC(HH\$HH0_H('h  HL$WH0HD$ H\$HHH: H,= HHSHO9 3HGHHGPHGXG`H&h HHh HG@HH\$HH0_@SH Hk HHH6\ HA(HI0HtHP tHC0    H> HHH [H%&: @SH Hk HHHk HA(HAPHcPHSk HD
PHAPHcPHj DBDD
LHH[ HA(HI0HtHP tHC0    H> HHH [H%9 H(gf  HcAH+H`Pf  H8MPE3MtIMH\$0H      ffffff     IcAD$PHD$PH#H;tIM;rH\$0H8HV HD$(HV HD$ @SH0fW)t$    f/f(vfW5ZJ f(i 
@ H,f(t
X\f(\f(f/-J v\f(Y-I f(* fnY(t$ YH0[HH   )p)xf(
J f(D)@D)Pf/fEWfD(fA(vf( fWI c  fA.zR  fA.zE  D)$   D)\$`DwI fA/D)d$PD)l$@D)t$0D)|$   D
#I D? fA/r6fff     fA(A\Xf( fA/Xsf(A\נ    GX 
7X %'X  D
X D
W DW D%W J 
J %J DI D
H DG D%F <D%; D* D
 D % 
 ؟    HW D57W D=&W  } W DT l V D5C [ V D=2 J V fE(= D=
 D5 D- f(AXYf(YAYAXYXYXf(AYAXYXf(Y
Ϟ YX
 Xf(YY X
 X YAXYYAXYXAX^YY5U XV  D
"= fD/vf( fA(fD(\AXwU f/  _    OU 
?U 5/U 6 DU DU D%T D-T R 
R 5R DQ DP D%O D-N <D-C D%2 D! D 5  
  uxTT D5CT D=2T q  T D
h  S D5W o S D=F ^ D=3 D5" D
 fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
 AYX
ћ Xf(YYś AXX YAXYAXAYX^YY%R X  F uq%R R 5R ! DR DR D%nR %ޚ ޚ 5ޚ Dݚ Dܚ D%ۚ 3D%К D D 5  %~  uz
Q D-Q D5Q  w D=Q 
. 
Q 
& 
Q D
 
 D- D5 D= $D=י D5ƙ D- D
 DYfW-B f(f(YYf(AYAXYXf(AYXYYf(Y
 Xf(Yh X
X XYAXAXYYAXAXYX^AYDYP AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIH\$Hl$Ht$WH HIIH+HIHHHH+HHH^HKH;s&D  CHCf/wf/wHH;rH;   HH+HHHHH|vfD  	f/   f/wzIf/p  f/f  If/N  f/D  If/,  f/"  HGH H;|H;sf/wf/w	HH;rLLL;C  HI+HHHHH   IPAf/w#f/  HHI;t
 A JLRf/w#f/  HHI;t
 A
f/w"f/d  HHH;t JLRf/w#f/8  HHI;t
 AHGI H L;L;s7Af/wf/w"HHI;t
 A IL;rL;vFIQ    f/wf/w$HH;tHHIHI;rL;   L;   I;tH;tHHILHHIL;'HAIHHHI;I2I)IL;u8HL;tHAIHH;HHM;tIA I AI~Ht$@H] H\$0HMHHl$8H _M;   H\$H|$IMHI+HH|WLHII+ODL+HJTHHMI@H I HHBIDHBI@HBI@HBuM;}"HHH+JM+HHIHAuH\$H|$H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3AY@@MtIJHtH3AY@@MtIJHtH3AY  MtIJHtH3AH HY@@dM;};HM+HJMtIJHtH3AHIY@@uH\$M;   H\$H|$IMHI+HH|wLHILI+KTHM+KDHHMBH H HX@@ALXHHBX@@JXHHuM;},HHHH+M+JHIX@@uH\$H|$H\$ UVWH0I@ 3II+@HHHHtbLd$PLl$XI      IH;r?) HOD$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]HP LLHD$(HF HHHD$ @HH   \ )pD)@D)XD)`D)l$@w fD(D)t$0D)|$    [ %[ -[ = 5[ D%[ D-s[ D5b[ D=Q[ A[ ђ )[ y  	[ %i  Z -Y  Z 5I  Z D%8  D-/ D5. D=- - f(DD= D5 D- D% 5ӑ -Ñ % 
 Dj/ u\Z Y  M Y - = Y  - D,  uyY vY   UY   5Y  Y  Y } X u )$   D)$      X X D
X  ʏ zX fA( ]X   =X D
  X =  = D
 fD.- zu
fA(  W D)T$pfA/  EYfA(AYfD(f(Y DY X DX YDYXΏ DX͏ YDYDX AXYDYAXEXYDYXEXYDYXAYDXDYDXf(Y
 DXf(Y X
ێ Xˎ YX
 YAYXXD^   E^fA(D\V fA(AY  fD(fA(  YDYf(X= DX
 Y
5 D^X
 f(Y YYX= X
 YYDYX׍ X= X
 DX
v YAYDYX AXAYX=> X^DYfA(D(T$pD($   ($   D(l$@L$   A(sE(CE([E(cD(t$0D(|$ IHH   )pD)HD)PfD(D)XD)`D)l$@ D)t$0D)|$   IW 
9W )W Ў %W - W 5V D%V D-V D5V D=V V \ V 
  D \V % 4 <V -܍ $ V 5̍  D%Í D- D5 D=  LD= D5 D- D%z 5j -Z %J : 
* D
) ubuU eU | Ԍ DU  Č $U D
ˌ  U     T T  * T   T  zT 
 bT  JT  2T  )$   D)$   uzT DS fA(n > S DU - S =E  S  uS 
 = D fWfE(fD.fDT" z  #R fA/  EYfA(D$   AYfD(f(DY Y DX| Xl DYYDXR XB DYYEXAXDYYEXAXDYYDXXDYYDX$   XYDYDXf(Y
 DXf(Yl X
\ XL YX
8 YYXX
 D^EY   E^fA(D\
P fA(AYM fD(fA(\ YDYf(X=g DXV Y
 D^X
 f(Y YYX
e X= YDYYXP X
0 DX X=׈ YAYEYX AXYXX
 ^DYfA(D($   ($   D(l$@L$   A(sE(KE(SE([E(cD(t$0D(|$ IH;   Ht$WH0H\$@HYHHH;   Hl$H   )t$ H+ 3Hf/v+HT+HH~HLH+LH 7.CHCf/vD  @HHf/w1HH;u(t$ Hl$HH\$@Ht$PH0_@SH HD$0    HH [@UHMILH;u2H]Ht$0L$$<-AEu<+uHHH+H}Ht$0L$$2H]H\$(H\$@3H+DHL+ِD D:tE:uDAHArHL;   IH+H|D$X8uD$`A8B   2   LT$PL\$HH|$Hu5IIDH+H+HD  D D:tD:uAHAr+Hu|L+L+fD  B:tB:uaHrEuH[ HHM 'HK H        D$ HD$ H3HE H|$H\$(Ht$0L$$H]2EuH HHM H H        D$ HD$ H3HE HVWATHP  HD$0HXHhIIHL   DBHL$`! HHL$`CHH< CHHV HHE# CHT$8HL$` HE H+EHH;r HEHH$  HT$@H|$XHCT$@H$  HD$ L$  L$  I調M;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBuM;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDB\DCD|HL$WH0HD$ H\$HHHD H HHSHO H HHtH@3H9 HG@HKHOHHtHPHCHGPHCHGXC G`HL HHvL HG@HH\$HH0_H@k  HL$WH0HD$ H\$HHH Ht HHSHOK Hs HHtH@3H9 HG@HKHOHHtHPHCHGPHCHGXC G`H L HHL HG@HH\$HH0_H@k  @SH HK HHH8 HA@HIHHtHP tHCH    H HKHs HH [H% @SH HK HHHK HA@HAhHcPH{K HD
hHAhHcPHJ DBDD
dHH7 HA@HIHHtHP tHCH    H^ HKH HH [H% HcAH+Hxi  H@i  @SH HJ HHHv7 HA@HIHHtHP tHCH    H HKHS HH [H% @SH HJ HHHJ HA@HAhHcPHJ HD
hHAhHcPH/J DBDD
dHH6 HA@HIHHtHP tHCH    H HKH HH [H% HcAH+Hxpi  H@gi  H\$WH`)t$P)|$@D)D$0fD(f(Af   f(fYEYD)L$ fW=% D
Z fA(\AYY%  fA(YY( f(X* f;vGfffff     f(ffA(YAY\fn^f(YXf;rH\$p(t$P(|$@f(D(D$0D(L$ H`_HH   D)@D)PD)XfD(D)`g uy
J J J B 
 
J 
 J 
 
rJ 
 
ZJ ʀ 
 ڀ D% fEWҨuk J 
J  G I 
? 
I 7 I 7 
' D%. D-    I 
uI L  TI 
 
<I  $I 
| 
I t H 
l 
H d 
d    H 
H  ~ H 
~ 
kH ~ SH ~ ;H 
~ 
#H ~ D%~ 
~ G ujG 
G - ~ G 
} 
G } G } } 
} D}  ujPG 
@G  ~ _} G 
W} 
G O} F O} } 
7} D%>} @urF 
F @Q~ | F 
| 
qF | YF 
| 
AF | 
| D| xsF 
F } | E 
{ 
E { E 
{ 
E { 
{ D%{ D)l$@rD-dE D-{ Y} 	D-v{ 	r0E 	T{ .} 
)$   r5 E 
5${ } 5{ D)|$ rD=D D=z | 	D=z )$   r=D =z | =z 
D)t$0rD5RD 
D5uz o| 	D5dz fE.fE(fDTq zu
fA(   D)$   fA/rifA(L$   H{ H
{ E3AY$   *&Y5C fA(fD(fA(\AXAYA\YDY,  D-yC fE/rlfA(L$   Hz H
z E3AY$   &Y=AC fA(fD(fA(Xy \AYA\YDY   E^fA(AY$   fA( f(fA( L$   H7y H
hy E3f($%L$   Hy f(XfD(H
y E3EYDY$\YDXfA(x Y  D^EYfE/v	DY
n' fA(D($   D(|$ D(t$0D(l$@($   ($   D($   D(T$pD(\$`D(d$PH   LL$ LD$HT$HL$SUVWATAUAVAWHx  H$  D)$   MLLHAHL$t
LHL$8+HHD$HT$HHكH;HL$HMLL\$8HI+HIH\$@HCH$   IHH3H+LIAu33IHcHl$H$   H$  HփtH&HHD$LL$HHكH;HL$IMHE3Ld$L$$EL$Hu]MuXHHH3H+L;tIIIL$$|IuE3L$   Ld$,M;H$  H$HML Ld$3E3L\$8H\$@D$      L;ADL;DDHcII+McHHHIL;HT$  L$  H$  I)$`  )$P  D)$@  MIHH$   HD)$0  D)$   D)$  D)$   HH$   ID)$   D)$   IL    IM,1HH$  HIHHT$hIT$HH$   IIL4HL4$IL    HIIL$  HN$8HD$0IIM+Ld$xI+L$  L|$(HD$PH$  HLHOIMHL$0L$   H$   H+L$   H$  HL$0HL$H+L$HHHHL$HL$hfA(3IY	DfA(AY	fDDfDfA(Y
DfA(AYfDDfD  MKL\$0HI+MIHD$HIM+I+MIT$HD$XIHOH|$HHl$XH+HD$`ILFH\$`H+HD$pILd$pI+IH$   J    L$   HD$ ffff     IfA(fA(H I H fA(I ICYD2XAAYJXfA(IAYPXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(AYLXIIYBXfA(AAYHXfA(ICYD XAL\$8H\$@H$  H$  Ld$xL4$HD$ I;}MLMMIM+M+M+L+H+HIfA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuI;  H$   H  Hc  H   L;k  HT$(HMI+MMHL+HHL+L+HJސfBfBfB HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  H$   fG(dfF(lL;MfG(t  I+ILHLH+HL+M+KDHK\ NTKlM<Lfff     f(}f(fA("KfEYfEYI H fB(,fA(sf(H I HfAYfAYfAYEDfAXJfXfA(fD((fEYfAYfA(fD(eAfXfXfAYfXfAXfA)JfE(sfXfXfA)zBL\$8H\$@H$  L;  HT$(HMI+MMHL+HHL+L+HJff     fBfA(fA HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  L;  HT$(HMI+MMHL+HHL+L+HJ     fBfB(fB HHfAYfAYfAYfXf(@fAYfXfXfXTf)Tu   L;   HT$PHMI+MLHM+HHM+M+HKD     fB(fB(fB( HHfAYfAYfAYfXf(@fAYfXfXfXTf)TuH;H\$H  HH+H'  ILMH+L+ITHD$pIHI+HLMHD$ IM+H|$ I+IH$   ILLH$   H+HD$`ILd$`H+HD$XII+Lt$XIH$   JH\$pL$   HD$HfD  HfA(fA(H I H fA(I ICYDXAAYJXfA(IAYQXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(CYLXIIYBXfA(AAYIXfA(ICYDXAL\$8H\$@H$  H$  Ld$xL4$HD$HH;}MLMMHM+M+M+L+H+HJ9fA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuH$   HL$hL$   H$   L$   HLHLH$   HL$hL$   HD$PHD$(H$   HD$0LLLHHl$Ld$xL4$H$   L$   L$  HT$H$  D($   D($   D($   L$  D($  D($   D($0  D($@  ($P  ($`  HD$fD  I;  H$  HMIH$  MkL    HM2L+HH$  LL+L$fA(E3IAY$f||ISIHHGHHL    D  f(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuM;}.IIJH+I+f(HHYDX@@uCuHL;}   HIJI+H+HHH    f(HHfYfX@f)@u>L;}9HIJI+H+HHH fHHfYfX@f)@uH;H   HH+H   HMILH+L+HDHHHH4ff(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuH;}.IHHH+H+f(HHYDX@@uH$  MMH    LIHD$Ht!H$  L$  3L3HD$3D($   Hx  A_A^A]A\_^][M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCD|H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3@^A@MtIJHtH3@^A@MtIJHtH3 ^A MtIJHtH3@H H^A@dM;}:HM+HJMtIJHtH3 HI^A@uH\$HL$WH0HD$ H\$HHH H HHSHOk H HHtH@3H4 HG@HKHOHHtHPHCHGPHCHGXC G`H0 HH0 HG@HH\$HH0_H@7_  HL$WH0HD$ H\$HHH H, HHSHO 3HGHHGPHGXG`Hf- HHL- HG@HH\$HH0_HL$WH0HD$ H\$HHHd HT HHSHO+ 3HGHHGPHGXG`H6- HH- HG@HH\$HH0_@SH H/ HHH HA@HIHHtHP tHCH    H HKH HH [H% @SH H/ HHH/ HA@HAhHcPH/ HD
hHAhHcPH/ DBDD
dHH HA@HIHHtHP tHCH    H& HKH HH [H%: HcAH+Hx\  H@\  @SH HK/ HHH HA@HIHHtHP tHCH    H HKHs HH [H% H\$WH H. HًHH0 HA@HIHHtHP tHCH    H HKH
 HT @tHR HH\$0H _HHXHpWH   )p)xfW3H5a{
D)@D)HD)PfD(fD(fD(EYDYD)XDY_ D fD  fA(Y3 AXf(AY HHY3h ^Xu(t$pL$   AYE(CE(KE(SI[Isf((|$`E([I_HL$WH0HD$ H\$HHH H< HHSHO HtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H- HH . HG@HH\$HH0_H@HL$WH0HD$ H\$HHH4 H$ HHSHO 3HGHHGPHGXG`H+ HH+ HG@HH\$HH0_HL$WH0HD$ H\$HHH H HHSHO{ 3HGHHGPHGXG`H+ HH- HG@HH\$HH0_@SH H- HHHf- HA@HAhHcPH3- HD
hHAhHcPH+ DBDD
dHH HA@HIHHtHP tHCH    H. HKH HH [H% HcAH+Hx b  H@a  @SH HD$0    jHH [HE3LLL9QLT$S  H\$H<$fff     ICHL$ HT$I;HD$ HME3H9H   H_fMtI@HtH3IH@IISIHMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIIL;HDDL;}3MtI@HtH3IH@IISIIL;H|IM;SLT$H<$H\$H@SLLHL$MBIBHT$ L;LD$HD$ HME3HH   H|$H{MtIAHtH3IRI
H@HIHMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIIL;HDAH|$L;}3MtIAHtH3IRI
H@HIIL;H|[@WH0HD$ H\$PHt$XHH3H\$@HJHt3HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt	HHP H\$PHt$XH0_@SHP\ )t$@HѨu+P X \ Y  \ }\ I(3fnY   HBHl$`HjHt$hH|$pH4   )|$0=P D)D$ fEWHfHH(fTfA.zt	 XHHuD(D$ (|$0H|$pHt$hHl$`f((t$@HP[H\$Hl$Ht$WH0Hi HH9ivy H3Hl$(3Ht$ (D$ fD$ HuT LLH]I;[ wHtHHH;Xs) HD$ Hu H8H;_ r Hl$HHt$PHH\$@H0_H\$WH HHH;Qt>H	 HtHTH{HH\$0H _H    H{H\$0H _HQH\$0H _H\$Hl$WH0LA HYHIHH+HH;w  Ht$@I;v> H?H\$(3H|$ (D$ fD$ Hu LLHI;[ wHtHHH;Xs HD$ Hu H0H;^ Ht$@r Hl$PHH\$HH0_H\$Hl$Ht$WH HcjHHH;it!H	 t
HHH    Hk~LFHHI H\$0Hl$8Ht$@H _H\$Ht$WH HHI3HC    H+HHt6 HC H+HH;r HKHC HH+HHtH;rHKHt+ HHC    HC     HC(     H\$0HHt$8H _HATAUAVH`  HD$0HXHhHpHx ILLA   MPMM;3  fW@ 33E~4LE HcI;}%HM IIHf.z uHI;|AIIcI;   믺   DBHL$` H$ HL$p)HHw HIHH]  HȍV\ HH HAT$? HHe$ HT$8HL$` LL$@H|$XLCL$@IcHMHHcHHE LHA HD$ II.L$`  I[ Ik(Is0I{8IA^A]A\D$Hx  HD$0)$`  f(H fWk f.z   3f/rHHr\c       DBHL$` H HL$pf(HL$p HT$8HL$` HD$@H|$XHCD$@HD$ L
 L$  Hn# H
_# -($`  Hx  @SH L+LIIJ    J
MtLMH HH [@SH HB|L L[xH [HL$SH0HD$ HD$P    EtH+ HAhH HAxD$P   zL LH HC@HChHcHH HDhHChHcHDd    HH0[H\$WH H{L- L_xtH@ HH\$0H _H\$WH H? HًHH HA@HIHHtHP tHCH    H HKH} H @tH HH\$0H _H\$WH HH   Ht HKp3H   H   H   n HKXHt` HK@H{XH{`H{hK HK Ht= HKH{ H{(H{0H\$0H _ LSH   HǄ$   AC    HYH>) ICH ICAC   HHL$  H HD$ HSHL$8] HtH@3H0 HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHHx H   H$   HcHǄ       Hd
 HL$ $ H8MPE3MPMtYMH\$@H|$0H      Hff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8H HD$(H HD$ PH8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
" H L
z H HD$ ̃y +LAH
o" HX L
I H HD$ ̃y  +LA H
>" H' L
 H9 HD$ O̃ 'H
" H  L
  H HD$ #HH8H8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
! H  L
z  H HD$ ̃y +LAH
w! HX  L
I  H HD$ ̃y  +LA H
F! H'  L
  H9 HD$ O̃ 'H
! H L
 H HD$ #HH8HL$WH0HD$ H\$HHt$PHH3|$XEtHs% HAhH HAxD$X   uHo	 HHU	 HC@HChHcHH"	 HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_@SH HD$0    
HH [@SH`
 )t$P)|$@f/Hf(D)D$0D)L$ fEWD fA(rtfA(\f(f(莼 f(\f/
V vfA(A\XfA.zuO  !   H     = Yf(R ^fA.ztf/5 rf(H虜u f/v*f     fA(fA(A\Xf/^XwfD/v*     fA(fA(^AXfD/\Xwf(HBXf((t$P(|$@D(D$0D(L$ H`[@SH HD$0    HH [HL$WH@HD$ H\$`Ht$hIHHHL$XD  Ht*H\$(H\$0Ht
HH8 HH(H\$PH\$`Ht$hH@_H\$Hl$Ht$WH HH+HgfffffffIIHHHHH?HHHH+H;tH+H(HH H;uH\$0Ht$@HHl$8H _HMLH+HL+H;tL+D  HJHII;uI@SH H蒋Ls L[xH [HL$SH0HD$ HD$P    EtH! HAhH3 HAxD$P   
L LHi HC@HChHcHH6 HDhHChHcHDd    HH0[@SH H袋L L[PH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   L# LH HC(HC@HcHH HD@HC@HcHD<    HH0[@SH H袋L L[PH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   چL LH HC(HC@HcHHf HD@HC@HcHD<    HH0[@SH HLc L[xH [HL$SH0HD$ HD$P    EtH HAhH# HAxD$P   ڄLK LH1 HC@HChHcHH
 HDhHChHcHDd    HH0[H\$WH ḦL L_xtH HH\$0H _H\$WH HLLm L_PtH耷 HH\$0H _H\$WH H載L- L_PtH@ HH\$0H _H\$WH H茊L L_xtH  HH\$0H _H\$WH H HًHH` HA@HIHHtHP tHCH    H HKH= H @tH肶 HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH HAxD$P   /mH HHe HC@HChHcHH2 HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HǄ$   AC    HYH ICHS ICAC   HHL$ ) Hq HD$ HSHL$8 H HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H( HD$ H HD$`H$   HcHH H   H$   HcHǄ       HX
 HL$ 訴 LSH   HD$ HAC    HR ICH7 ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$P H HD$(Hq HD$PHD$hHcHH< HDhHD$hHcHDd    HoX
 HL$(ѳ LSH   HD$ HAC    Hr ICHW ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$P H HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    HX
 HL$( LSH   HǄ$   AC    HYH ICHs ICAC   HHL$ I H HD$ HSHL$8
 H HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H  HD$ H HD$`H$   HcHH H   H$   HcHǄ       H~X
 HL$ ȱ HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHH HAxD$X   }H HH} HC@HChHcHHJ HDhHChHcHQTdHtH~@HHK@1HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhH HAxD$X   ?}H HH HC@HChHcHHb HDhHChHcHQTdHtH~@HHK@qHH\$HHt$PH0_@SH HD$0    ژHH [@SH H袙L L[`H [HL$SH0HD$ HD$P    EtH HAPH HA`D$P   躗L LH HC(HCPHcHH HDPHCPHcHDL    HH0[H\$WH HL L_`tH0 HH\$0H _H\$WH H HًHH HA(HI0HtHP tHC0    H HH @tH輮 HH\$0H _H\$Hl$Ht$WH0Hi HH9iv H3Hl$(3Ht$ (D$ fD$ Hu LLH]I;[ wHtHHH;Xs HD$ Hu H8H;_ r Hl$HHt$PHH\$@H0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH HAxD$P   oyH HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtHS HAhH HAxD$P   yH HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HD$ AC    HYH! ICH& ICAC   HIK LV L\$(HCHD$@HC HD$HH HD$PHK0HL$XHtHPHC8HD$`HC@HD$hCHD$pH' HD$(H HD$PHD$xHcHH  HDxHD$xHcHDt    H	S
 HL$(裫 @WE3LHL9I   H\$HYfL;M}gMtI@HtHH3HtHA3H@HPLIIHtH3AHI^AIIH_L;|IL;O|H\$_H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(fY   MtI@3H@HMtI@3H@A   M;Hf(JfYI}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXN  HI+H   LSMtI@3H@HMtI@3H@HBBYXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@IM;HBDBYDX
L;}BMtI@3H@HMtI@3H@IL;HBLBYLX|f(H\$MtI@3H@HMtI@3H@HY   H;N  HCH   LS    MtI@3H@LMtI@3H@HAYXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HI;HDAYDXH;}AMtI@3H@LMtI@3H@HH;HLAYLX|H\$f(HL$WH0HD$ H\$HHt$PHH3|$XEtH HAPH HA`D$X   HW HH= HC(HCPHcHH
 HDPHCPHcHQTLHtH~(HHK(HH\$HHt$PH0_LWATAUAVAWHPHD$ I[Is MMLHIKIHIAHAIKI HI@HAICHtI;Ct Ht$8H+t$HHHCHu3H{(H+HH3  LS IH+HHHH+H;sL1I;  HHH+H;s3HI;IBHKHLH$   IMLCI+HH    LL$   HtLH L$   HL$@IHIFHAHL$0IHIGHAHD$HLD$8I+HH    N4HtLIz HS MEI+HHtHLIV HKHC H+HHHtͣ IHC(IHC Lc   HL$@IHIFHAHL$0IHIGHAHT$HLD$8I+HHtHLI HK IULH;t!HL;tA HI IL;uHK HLI;t!II;tI HA HI;uHC HH;t HH;tHHHH;uHs L\$PI[8IsHIA_A^A]A\_H\$Ht$WH 3HHt$0 L LHCHGHC H\$8HG Hw0Hw8Hw@Ht$@H8 GHHH HG(HH _HhI)|$@9|$pHD$pI#I      I;v*LH
 Hc L
L HE~ HD$ 
D)D$0fDnEDD$pHD$pI#I;u*H
? H( LH~ L
 HD$ 5A 'H
 H L
 H} HD$ fn)t$P5 ^覠 
x% X
  A\D(D$0\Y(t$PYY= X(|$@f(HhHl$Ht$ WHPHA IHH+AHH  LH
Z H} )t$@fW5%H      fnm l$`HD$`H#H;u*H
 H L
 Hc} LHD$ f/w*H
 H L
 HG} LHD$ 2	D$`HD$`H#H;u*H
 H L
a H
} LHD$ LO H
y H"} L+OLH\$h)|$0IYHG H+GHHu1 H_H =] H+   HH;^HFߞ 3f(HtVfnU 1$ %! fffff     Hcf(HX\f(\fTY\H;r(|$0H\$hf((t$@Hl$pHt$xHP_fWHl$pHt$xHP_HhID)D$@DDD$pHD$pI#I      I;v*LH
? H  L
 H{ HD$ D)L$0fDn
EDL$pHD$pI#I;u*H
  H LH{ L
 HD$ A f/ w'H
  Ht L
e H{ HD$ )t$P5 ^C 
" X
 E\D(L$0\DY(t$PEYDYF  AXD(D$@f(HhATAUAVHpHA MLH+ALH!  HB H+BH
  LH
 H{ )t$PfW&H
 H{ M!A.f/w*H
 Hg L
X H{ MHD$ MD$ IU H$   M+D$I+UH$   IHH$   L$   H$   3I;Ht$hH|$`)|$@H=>
 H$   Hl$0HCH6{ MHHL%VH{ LMHVIE I+EHHu ID$ I}I+D$HHu Iu IL$ I\$I+uHH+HHH;w
HH+HA=    H;HF^) f(HtG Z
 fHcf(HX\f(\YYYXH;r(|$@H|$`Ht$hH$   H$   f((t$PHpA^A]A\fWHpA^A]A\HWH  HD$ HXHHHH H H$   E3E33H$   Z HB H$   HLCL+H$   z A   E3H$   HL$0 HD$0HcHHL0    HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQHB    HEHtHL$0ƺ u2HL$0 H$    HL$0 H$   ӻ 2H$   H  _M;   H\$H|$IMMI+HHH}   HILHI+MLHKLHM+HKDM@H H H^A@HA^LH@^A@H^IHuM;}3HHHHL L+M+JHIB^DAuH\$H|$HL$WH0HD$ H\$HHt$XHH3|$PEtHc HAPHh HA`D$P   菀H HH HC(HCPHcHHz HDPHCPHcHQTLHtH~(HHK(QHH\$HHt$XH0_LAMtI@3H@LPIHH+HLIHLIIM  MtI@3IH@Hf(fY   MtI@3H@   I;Hf(IfY}LMtI@3H@Hf(fYfXMtI@3H@HI;Hf(DfYfX|M;fX~"MtI@3H@HfB(fYfXM;f(fX   II+H   IRMtI@3H@HBYXMtI@3H@HBDYXMtI@3H@HBDYXMtI@3H@IL;HBDYXhM;}+MtI@3H@IM;HBLYX|f(MtI@3H@   L;HY   IBH   MJfD  MtI@3H@HYXMtI@3H@HDYXMtI@3H@HDYXMtI@3H@HI;HDYXlI;}*MtI@3H@HI;HLYX|f(H\$UVWH0I@ 3II+@HHHHtRLd$PI      H;rN HOH@D$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]H LLHD$(H HHHD$ PH\$ UVWH0I@ 3II+@HHHHtfLd$PLl$XI      IH;r HOH@D$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]H LLHD$(H HHHD$ |H\$LAMtI@3H@ HXHHH+HLHHLIIM  MtIP3HtHB3H@HHtHB3H@Hf(fYMtI@3IH@Hf(	fY  MtIP3HtHB3H@Hf(AHtHB3H@HfYAMtI@3H@A   M;Hf(YfY       MtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfBYfXMtIP3HtHB3H@HHtHB3H@HfB(TfBYTMtI@3H@IM;HfB(DfYfX,M;fX~dMtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfB(fYfXL;f(fX}iMtIH3HtHA3H@HHtHA3H@HBBYMtI@3H@IL;HBYDX|f(H\$MtIH3HtHA3H@HHtHA3H@H	Y
MtI@3H@   H;HY	}gMtIH3HtHA3H@LHtHA3H@HAYMtI@3H@HH;HYDX|H\$f(HWH`  HD$0HXHhHp IIHHM;H      DBHL$`. H HL$pTHH HH6 9HH *HH HHa HT$8HL$`ܰ HGH$  HD$@H|$XHCD$@HD$ L
 L$  HHL$`  I[IkIs(I_M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBXDCD|M;D  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3AAOAYI\AAMtIBHtHH3HtHA3H@HHtH3ALAAYI\AAMtIBHtHH3HtHA3H@HHtH3AYI\AMtIBHtHH3HtHA3H@HHtH3AAI)H I HYI\AALd$0Ht$(Hl$ H\$L;}aIE L MtIBHtHH3HtHA3H@HHtH3BCIL;YI\CD|A]_M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAYAAXAAAMtIBHtHH3HtHA3H@HHtH3ADYAAXAAAMtIBHtHH3HtHA3H@HHtH3YAAXAMtIBHtHH3HtHA3H@HHtH3I)H I HYAAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;YACXDCD|A]_@SH HҖLc L[xH [HL$SH0HD$ HD$P    EtH HAhH# HAxD$P   蚔LK LH1 HC@HChHcHH HDhHChHcHDd    HH0[@SH HBL L[xH [HL$SH0HD$ HD$P    EtH HAhHs HAxD$P   誔L LH HC@HChHcHH HDhHChHcHDd    HH0[H\$WH HlL L_xtH HH\$0H _H\$WH Ho HًHHp HA@HIHHtHP tHCH    Hҭ HKHM H @tH蒇 HH\$0H _H\$WH H̕L= L_xtHP HH\$0H _H\$WH H HًHH HA@HIHHtHP tHCH    H HKH HԪ @tH҆ HH\$0H _LSH   HǄ$   AC    HYH ICHc ICAC   HHL$ 9 H HD$ HSHL$8 H} HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHH H   H$   HcHǄ       HF.
 HL$ 踅 LSH   HǄ$   AC    HYH ICHC ICAC   HHL$  H	 HD$ HSHL$8ݧ H HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H8 HD$ H HD$`H$   HcHH H   H$   HcHǄ       H-
 HL$ 蘄 HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhH HAxD$X   菏H? HH% HC@HChHcHH HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHX HAxD$X   菏H HH HC@HChHcHHz HDhHChHcHQTdHtH~@HHK@AHH\$HHt$PH0_@SH HD$0    読HH [@SH HD$0    
HH [H   c D)$   fD(Ȩuy
   0 
 
p  X 
 
@ 
 
(  
   fWۨui 
  7  
/ 
 '  ' 
      W 
G >  & 
~ 
 v  
n 
 f  
^ 
 V 
V     
v   U 
 
=  %  
 
 
   
} % D)l$@D)t$0D)|$ umD- D5 D=  
k [ D- D5 D= 
  % f(+
 D= D5 D-w -g )$    u[5   j 5 5 % 5
 5  5  % @ui5T D @ 5{ 5# c 5k 5 5c 5 5[ 5 5S xb5   5 5  5 5e  5 5E 5 D)$   rD Dh " 	DW 	D)\$`rD 	D-  	D 
)$   r= 
=  = D)T$prDm D  	D r59 5 _ 5u 
D)d$PrD%  
D%K - 	D%: fA/v	fDW
 fD.zu	f(   fA/r^fA(L$   Hm H
 E3AY$   Y= EXf(fA(\A\AYY7  DJ fE/rjfA(L$   H H
 E3AYY \$   膹Y5 EXf(fA(\A\AYY  E^fA(AYf/   f(fD(DY Y X DXDYYX EXDYYEXXe DYEXYXG DYDXYXD^   f(^f(fD(DYYX	 EXDYYEXX
 DYEXYX
 DYDX YX
 DYDX  YX
 D^f/   fD(f(DYs
 Y;
 DXZ
 X"
 DYYDX8
 X 
 DYYDX
 X DYYDX X DYYDX X    ^fD(f(DY Yw DX Xn DYYDX X\ DYYDX XJ DYYDXp X8 DYYDX^ X& D^fA(qy f(fA(Ey f(fA([y -# f(EY^X\AYAY\Yf(D(|$ D(t$0D(l$@D(d$PD(\$`D(T$pD($   ($   ($   D($   H   M;  H|$ AT
 III+LLHI  HH\$Hl$Ht$ N   II+ؾ   HHH+H+HIHMMtIBHtH3HtH3H@L*HB	fWBMtIBHtH3HtH3H@HBD	fWBMtIBHtH3HtH3H@HBfWMtIBHtH3HtH3H@H I HHHDfWBHt$ Hl$H\$L;}FI$MtIBHtH3HtH3H@IL;HBDfWBD|H|$(A\M;L}kHHLMtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCXDCD|@SH HLÞ L[xH [HL$SH0HD$ HD$P    EtH HAhH HAxD$P   蚠L LH HC@HChHcHHf HDhHChHcHDd    HH0[H\$WH H\L
 L_xtH v HH\$0H _H\$WH H HًHH HA@HIHHtHP tHCH    H HKH] H @tHu HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH( HAxD$P   蟀HO HH5 HC@HChHcHH HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHh HAxD$P   蟀H HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@QHH\$HHt$XH0_LSH   HǄ$   AC    HYH. ICH ICAC   HHL$  Hy HD$ HSHL$8M H HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Hh HD$ HL HD$`H$   HcHH H   H$   HcHǄ       H
 HL$ s HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhH HAxD$X   蟜H HH HC@HChHcHHj HDhHChHcHQTdHtH~@HHK@qHH\$HHt$PH0_@SH HD$0    芡HH [@SH HD$0    HH [@VM;MHL  II+HW  HH\$Hl$H|$ Ld$(J   I   II+H+L+HLHHMfMtIBHtH3HtH3H@KH
YAAMtIBHtH3HtH3H@HDYAAMtIBHtH3HtH3H@HYAMtIBHtH3HtH3H@I H HHHBD	YAA	Ld$(H|$ Hl$H\$M;}EHMtIBHtH3HtH3H@IM;HBDYBD|^M;  LMK ISSVAUH@IMII+HI{H`  HIkMcMsM{MM+A   HIH+N$   IL+I,ILK4HtHCHtH3HtH3H@I|- H9n EHtHCHtH3HtH3H@HD9n EHtHCHtH3HtH3H@HB!vn E HtHCHtH3HtH3H@HI)<n H I IELl$xHT$hL|$ Lt$(Ld$0Hl$`I;}CH:HtHCHtH3HtH3H@Hm HI;D|H|$8H@A]^[H\$M;IML}L
MtIBHtH3HPHtHJ3HtHA3H@L HtH3CYAHtHB3H@IL;HBXDCD|H\$@SH HLS L[xH [HL$SH0HD$ HD$P    EtH HAhH HAxD$P   ڛL# LH	 HC@HChHcHH HDhHChHcHDd    HH0[H\$WH H<L L_xtHl HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH8 HAxD$P   OHg HHM HC@HChHcHH HDhHChHcHQTdHtH~@HHK@!HH\$HHt$XH0_LSH   HǄ$   AC    HYH ICH ICAC   HHL$ Y H HD$ HSHL$8 HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H$ HD$ H HD$`H$   HcHH H   H$   HcHǄ       H
 HL$ j HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHX HAxD$X   Hg HHM HC@HChHcHH HDhHChHcHQTdHtH~@HHK@AHH\$HHt$PH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH HAxD$P   _H HH HC@HChHcHHZ HDhHChHcHQTdHtH~@HHK@聝HH\$HHt$XH0_@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HDJD|H|$Ht$M;}%LIPI IHIIM;HJD|[M;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBuHcAH+HcAH+$HcAH+THcAH+HcAH+DHcAH+DHcAH+tHcAH+4HcAH+DHcAH+HATAUAVH  HǄ$   HXHhHpHx IMLLH I    I$IIP      DBH$    I$IIPH
_ H@ HEH$   HH HI
 HH HI HH вHHԇ H$   H$    HHL$Pp HX HD$PHHL$h- Hm
 HL$Pe I$IIP      DBH$    HV H$   1HH' "HI& HH HI HH HH H$   H$    HHL$P Ht HD$PHHL$hI H
 HL$Pd I$MHT$ IPH$   HT$@LHL$8L+IHF H+FHL;     DBH$    H H$   HH HI HH HI HH^ ٰLH$   IH/ H$   貰(H$   Ӯ3HL$@HHT$8H+HHtcHt,H$   褮HL$@HT$8H+HH;r HT$8HH$    HHL$@HHT$8H+HH;r)H$   FH$   H$    HHL$P H HD$PHHL$h H
 HL$Pb 3HM  fD  HF H+FHH;r) HT$@HL$8HnHH+HH;r HT$@HL$8HH9D uHHH+HH;r     DBH$    Hc H$   HH HI HH HI HH ٮHH
 HHC 辮LH$   I{H H$   藮(H$   踬HL$@HHT$8H+HHtcHt,H$   苬HL$@HT$8H+HH;rτ HT$8HH$   h HHL$@HHT$8H+HH;r)H$   -H$   H$   ǂ HHL$P H HD$PHHL$hf H	 HL$P` Ht` H\$8H\$@H\$HHL$ ` L$  I[ Ik(Is0I{8IA^A]A\H\$Ht$WH HA 3HH+AHHHta     HC H+CHH;r HKH94t$HC H+HH;r HKH HC HH+CHH;rH   Ht_ H   H   H   H   _ H   Ht_ H   H   H   H   o_ H   Ht^_ HKxH   H   H   @_ HKHHt2_ HK0HsHHsPHsX_ HKHt_ HHsHs Hs(H\$0Ht$8H _^ H\$Ht$WH@HB LI HH+BL+IHHH  L) HD$0H H
 HD$(IHT$ HG Hs H+GH+sHHHu  HC HH+CHHu HKLHH\$PHt$XH@_'H	H% H HHIH% H\$WH Ho HHHIu tH] HH\$0H _H\$WH HHH;t/HH~L_(HWHKL[(iHW0HK0\HH\$0H _@SH HHI0 HKۀ HKH [H%ˀ @SH HHI( HK HH [H% H\$WH HHIHHt\ HK03H{HH{PH{X\ HKHt\ HH{H{ H{(H\$0H _\ @SATAUH HZ LJLLHgfffffffLM+IHHH?H   Hl$@Ht$HH|$PL;v I4$Hu E3LI;[w HkI\$I;\$ v I<$HtH;t H;t`Huz E3LI;[ rf IMH} HΤ H躨Hu? E3LI;[ r+ H(I}IMH} H} H} H|$PHt$HHl$@H A]A\[@SUAUH HZ LBHHLI+H  Ht$@H|$HLd$PL;v~ Hu Hu~ E3LI;[wz~ H}LcH;} vf~ H] fHtH;tP~ I;taHu@~ E3LI;{ r,~ IM| H HHu~ E3LI;{ r} HH]  IML| HU| HT| Ld$PH|$HHt$@H A]][@SH HHI} HH [H%} @SH HHI8HtY HK 3HC8HC@HCHY LS LH [@SH0HD$ Hٹ   Y 3HtHHHHKHK HK(HH0[HL$WH0HD$ H\$HHt$PH   FY 3HtH8HHHwHw Hw(H_0   Y HtHHHHsHs Hs(HH\$HHt$PH0_H\$Hl$Ht$H|$ ATH@Hy0MHH_H{i u#HKIz tH[HH{i tHH^0H|$(HD$ HtH;t{ H;tHWIz uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$WH HHIpHtW HKX3H{pH{xH   W HK@HtW HK(H{@H{HH{PW HH\$0H _H%z @SH03MM؈D$(D$@HLIMIHˈD$ `<H0[HWHpHD$ HXHhHpHHHy HHw H9wvz H_H;_ vsz HHD$0H\$8(D$0fD$0H;tfD  HHx u	H(H;uHwH;w v'z HD$0HtH;tz H+HgfffffffHHHHH?HHL$@x HL\$pI[IkIs I_@SH0HD$ Hٹ   4V HD$HHt3HSDIDH蔗LE3Mu3
IChHcHJDhH0[H(LALIHQ II+HH;|
L+II+IHAH	HtU H(@SH A   HD$0    HH [HSUVWATAUAVAWH   HǄ$   HE3D`L- LhLpLxL`pED$H4
 HHx L5A L$   H H$   H= H|$pL=| L$   Ǆ$0     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$Xx Hצ HD$0H HD$XHD$pHcHH~ HDpHD$pHcHQTlIH$@  H$   HtRHH$8  P(HH$@  Ht
HHPH$8  HtHP H$8  IEH$8  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP Hh
 HD$@H	 HD$HD$P   
 X  
 X   .S HH$H  HtXHx@LxPǄ$0     HT$0H> Hg HHE HC(HC@HcHH HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$H  HT$(HHL$(HH$H  Ht GuHHPGu	HHPLHHL$ csHD$ H
 HD$(H
 Ht/@H\$(Ht CuHHPCu	HHPH
on R Hz
 HE Hw
 HEHt@H2 HD$0H HD$XHD$pHcHH٣ HDpHD$pHcHQTlLt$0H`w H\$XHL$X@u Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$   t L$   H$   HtHP HHH   A_A^A]A\_^][LSUVWATAUAVAWH   HǄ$   HE3EcL- MhMpMxMcAsH~} ICISIKTt L5 L$   H& H$   H= H|$pL=w L$   Ǆ$@     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$Xs H HD$0Hg HD$XHD$pHcHH2 HDpHD$pHcHQTlIH$X  H$   HtRHH$H  P(HH$X  Ht
HHPH$H  HtHP H$H  IEH$H  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP H HD$@HX HD$HD$P   u
 X  d
 X   N HH$   HtXHx@LxPǄ$@     HT$0H:H HH HC(HC@HcHHƠ HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$   \HT$(HHL$(HH$   Ht GuHHPGu	HHPLHHL$ nHD$ HR
 HD$(HN
 Ht/@H\$(Ht CuHHPCu	HHPH
i 2N H
 HE H
 HEHt@H HD$0H HD$XHD$pHcHH HDpHD$pHcHQTlLt$0Hr H\$XHL$Xp Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$   ap L$   H$   HtHP HHH   A_A^A]A\_^][HLH L@HPSUVWATAUAWH@  L$  H$  L$  D)@D)HH$  H$  L$  LHHIDIIMDE3HHH$  HHL$  HLH   IH\$hII+L$  H;HD$pILMHMH,L$HHMuL$  IHL+D$  fEWL$  )$0  H  )$   J    D)$   H$   E3IHKAO<D)$   D)$   D)$   H$   IID)$   D)$   HKܺ@   HD$xI$   Lt$@HD$8KH$  IL|$H\$ HD$(KAIHD$IHD$K@IĀ   HD$hHHL$0HHHD$`ffff     H$  J    H~XH$  H$  IIHJ         fWHfpDHHf)JuH$  HL$0M"  H$  LL$8N    AfDHLIfD)$   IDL$  HIHǀHI+IIIffff     H(3f fD(fD(fD(fD(fD(fD(fD(f(f)D$PA	C
IH7  LEIIf(!fD(Af(f(Pf(X f(h@f(pPf(x`f(fAYfYfDXf(H0fDXf(fAYfYfDXf(Q fDXf(fAYfYfDXf(XpfDXf(fAYfD(D$PfYf(   fDXf(I0fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYf(IPfYf(Q@fDXfDXf(fYfD)D$PfYfDXfD(   f(   fDXf(fYfYfDXf(   fDXf(fYfYfDXfDXf(fYfDXf(Y`f(   f(|$PfYH   f(IpfA(fXHIfYfDYfDXf(fEXfYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDXf)|$PfD($   I;   ML+D  f(!f(if(H f(Pf(X f(fYH@IfYfDXf(HfDXf(fYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDX{f)|$PfAAffZfA(H IfAYfAdfAiftI fzfXfA(H IfAYfA`fAhfA(fXfA(fAYfXfA(fAYfXfA(fAYfXfA(fAYfXfA(fD(D$PfAYfAYfD($   fXfApfTfTf`fhfA`fAhfApfXfAxftftfpfxfApfAxD$  fEWL$  H$  L$L$  H\$ H$  Lt$@H|$p/  L$  IHJ`H	f(Za If(f(f(H  HUHH    f(	f( H   H@HfYfXf(fYfXf( fYfXf(0fYf(IfXf(@fYfXf(PfYfXf(`fYfXf(pfYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYfXI;}UIH+ff     f(	f( H@HHfYfXf(@fYfXf(@fYfXf(@fYfXuJAAffJf(f(fYf(fYfXf fYfYfXffXfBff[ffPf	fIfXfB$fBdL$  H$  L;?  H$  H$  L\$H\$H|$(IL4H$  IH$  ILL+$$L<    Ht$Lffffff     A	3IfA(fA(fA(fA(I   MBIIIIJ    fQYHH If(f(Y@YHXXf(Y@YPf(XXQYHXf(f(Y@YHXf(XY@YXXXYf(f(Y@YHXf(XY@YPXf(XY@Xf(YXY@XXI;}BAHH I;f(f(Y@YHXf(XY@YPXX|AYAYAYIHHHMIXffXoAYoXssAX{A{8L$H\$ Lt$@L|$H$   HL$0L$   HT$8HT$HT$HT$(HD$xL$  H$  H$  L$  L$  HHLHl$`H$  H\$ HL$0L|$Lt$@NH\$hD($   D($   D($   D($   D($   D($   ($   H$  H;  H$  HN4    IJ	M<HH$  H$  H+H<JH$  M$H$  HDH$  M~1IHIfW HfpDHHf)IuH$  M   L$  (5m[ HIHAL$  IAfILIIA	f(f(IM~3ID  f(	f( HH HfYfXf(@fYfXufA@f(f(I LIfYfYfXfA@fAPfAPfXfAHfAHiL$L$  H|$p   L$  IL$  HJ@I	f(fZ M~)IIH+     f(HHfYAfXuAAffA$fYfXfA$fAL$L$  L$  H$  L;  H,    IIHIHMI+fffff     AE3IfA(|yIRLHOHM+I@HL    fffff     HAH H HYIY@Xf(HX@YIYAXXuM;}(HIKI+I+HHY@XuAYHLHXSS(L$H$  H$  H$  L$  H    MMHH$  IHH$  H$  ($0  L$  L$@  E(CE(KIA_A]A\_^][@WATAUH0HD$ H\$PHt$`HHHH;vdHIHu3HC(H+HH;   HK辄LHD$XH{ H9{vV^ LkL;k vF^ I+HHtH    LMI] HKH{ H+HHtu: IHC(IHC LcH\$PHt$`H0A]A\_@SH0HD$ Hٹ   T: HD$HHt3HSDIDHdLE3Mu3
IChHcHJDhH0[@WH0HD$ H\$@HD$H    X   9 HHD$PHttH HG@Ha HGPD$H   HSHH HH HG(HG@HcHHË HD9@HG@HcHDADD9<HSHim3Hu3
HG@HcHHD9@H\$@H0_@WH0HD$ H\$@HD$H    X   9 HHD$PHttH˙ HG@H` HGPD$H   HSHH HHn HG(HG@HcHH; HD9@HG@HcHDADD9<HSHl3Hu3
HG@HcHHD9@H\$@H0_@SH0HD$ Hٹ   T8 HD$HHt3HSDIDH$LE3Mu3
IChHcHJDhH0[HH` 3LL$XLD$`3)t$0)|$ D$XD$`5] =?m fTf/vZ  "   Q 3LL$XLD$`3҈D$XD$`fTf/vZ  "    3LL$XLD$`3҈D$XD$`fTf/vZ  "   ϣ 3LL$XLD$`3҈D$XD$`dfTf/vLZ  "    3LL$XLD$`3҈D$XD$`+fTf/vZ  "   M 3LL$XLD$`3҈D$XD$`fTf/vY  "   (t$0(|$ HH@SH A   HD$0    DHH [@SH A   HD$0    ԈHH [M;  VAUIIMI+LLH  HH\$Hl$ L H|$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAXAAAMtIBHtHH3HtHA3H@HHtH3ADXAAAMtIBHtHH3HtHA3H@HHtH3XAAMtIBHtHH3HtHA3H@HHtH3I)H I HXAAALd$0H|$(Hl$ H\$L;}WIE L MtIBHtHH3HtHA3H@HHtH3BIL;XACD|A]^LAMtI@3H@HHMtI@3H@LXLIHH+HLIHLIIM[  MtI@3IH@foO Hf(	fT   MtI@3H@   I;Hf(QfT}LMtI@3H@Hf(fTf_MtI@3H@HI;Hf(DfTf_|M;f_~"MtI@3H@HfB(fTf_M;f(f_L$o  dX II+H  ISMtI@3H@HHD$BfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$IL;L$M;}FMtI@3H@HHD$BfTf/D$wHD$IM;L$|f(MtI@3H@V    L;H	fTL$`  ICH  MKMtI@3H@HHD$fTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$HI;L$I;}EMtI@3H@HHD$fTf/D$wHD$HI;L$|f(@SH0HD$ Hٹh   / HD$HHt3HSDIDHLE3Mu3
ICPHcHJDPH0[@SHPLQL	H)t$0Ap)|$ A8f.=Z zuf.5Z zO  Hl$pHt$HH|$@D)D$D)$LT$`tM&HHD$`HT$hHHكL;HL$hHMLIDI+3HDHfDH+HII<CfD  ISMIIHL+HCHH4    fYP!H H Hf(f(YY\A\ YYXPPIf(f(YY\YYYXPPAL f(f(YY\YYPPXf(YYIf(YY\XPII;}NIIHH+H+HHf(f(YY\YYXXLuOLT$`AtI&IHD$`HT$hHHكL;HL$hHMH I;utL;  HII+I+HHHH     fA(f(IHHf(f(fAYfAYf\fAYfAYf)XfXfA)Hu  HHHHIL;   HIHI+I+I+HHIhHHfD  fAfm f(f($.f(I H H HfAYfAYf(fAYf\fAYf)RfXf(fAYfAYfAHfMf(fAYfAYfXf\fMf)d.fMoH;tAfAf(f(fAYfAYf(fAYfAYfXf\fAf)fALI;D($D(D$Ht$HHl$po  IH+H  IMITH+L+HDHHHH<fD  ZP"H H Hf(f(YY\A\ YYXPPJf(f(YY\ZYYXPPAL f(f(YY\YYPPXf(YYJf(YY\XPJI;}JL+HL+AHIf(f(YY\YYXXALuH|$@    (t$0(|$ HP[@SH A   HD$0    蔐HH [H  HD$ HH$   00HHL$(H	 HL$(%) H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(
fY	   MtI@3H@HMtI@3H@A   M;Hf(RfYQ}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXM  HI+H   HSMtI@3H@HBMtI@3H@HBYXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@IL;HBYDX
L;}AMtI@3H@HBMtI@3H@IL;HBYDX|f(H\$MtI@3H@HMtI@3H@   H;HYA  HCH   LKMtI@3H@HMtI@3H@HYXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HI;HYLXH;}?MtI@3H@HMtI@3H@HH;HYLX|H\$@WHyLYE3LH  
OP fWH\$fD  3I   I[DRI;uf(f(IIIIHIBI;uf(f(IIIHIM;uf(f(IIIIIIBI;uf(f(IHIIIHH;I_I;}*I;uf(f(IIIIHHI;|IL;H\$_LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHǅ8  )@  MMHU8H  L(L}pHGH  L  LE8H;MMIH]XIIHN,    II;vEHHEHHuL$    I   w6H   HHH;wHHH* H+HD$pHHHE1IF HEHuMtDHIL  3H9HDH  H  H    H=     I;vRDHGHE HunH    H   w6H   HHH;wHHH3* H+HD$pHHHE 'HDE HE HuHtCI3H9_HDH   H(  H    H=   0  M;vCHGHEPHukJ    H   w=J   HHH;w
HHHy) H+HD$pHHHEPHD HEPHuHt'CE3L9WLDL   J    H=   E 3HUE3LE(IIH   IHH   3H}0L  IHM8IL  IHH   5^ D  I;  H  HEpL  H9MpIML(L   ML L   I+H   IIHu LL   H~>KMHD$8    HD$0    HL$(Ll$ MIH  HULE(3M   HEH   IMIL  H  H~KHMHH  HHNIHMHD$8    Ll$0HHD$(H\$ MHH  ysHHII;HULE(|L  L  Hu H}03HMH  H  J    H   IHH   IHH   LEXIHH   LHUxH  LLUH L  H  LMXM;IMHE3ML   HE(HE`ML   LH   HH   LUhH}M;  Hǅ     LE@H  L]@IINH8H   HEML]@M~`HEPHD$hLt$`Lt$XLl$PLl$Ht$@H|$8Ld$0H\$(LL$ LMMIH  HMH  L]@LUhMH+  H  L4    MFN$    LxMIffffff     H  M(  LLHE`IIH  LH<I+H  I A3H   MAIJHCHHH    @ f(AYHA\Af(Y\f(AYHA\Af(AYA\AH I HuH;}0IMM+HH+f(BY  \ HHuMMIHH   H   MFL]@H  A3H|cIBHSHHH    ffff     @^@H^H ^ H^HH HuH;}A^AHH;|IMML;HML   L  E3HELH  LLd$8L   Ll$0H\$(H|$ MH}HH  rIL   H   HE`L   IH   LUhMLUhL   IL   L   L   L   HMH  wL   M~uH   IHHHEPHD$hLt$`Lt$XHD$PHD$Ht$@LD$8Ll$0H\$(H   HD$ LMH  HMH  LEXIHMLuxL   LuxLUHJ    LLUHH;  Hu H}0]L  HUHUpHUHM8H   HM8LE(L   LE(H   H}0L  L  ^}  tH   3= 0   tH   =    t
H  = (@  HX  A_A^A]A\_^[]M;   Hl$Ht$ WH HH\$0Ld$8L IIHHtHFHtHX3HtHC3HtH3H@H@ HtHC3H@HH;HYDAD|Ld$8H\$0Hl$@Ht$HH _@SH0HD$ Hٹ    HD$HHt3HSDIDHԓLE3Mu3
IChHcHJDhH0[@SH0HD$ Hٹ   4 HD$HHt3HSDIDH4LE3Mu3
IChHcHJDhH0[H\$HYLQE3LH   
|C fWE3M~eHtHBHtH3HM;uf(f(HtH3H@(HHH II\IIIKIIM;|IL;|H\$@SH A   HD$0    tHH [@SH A   HD$0    HH [@SH0HD$ Hٹ    HD$HHt3HSDIDH蔣LE3Mu3
IChHcHJDhH0[@SH A   HD$0    褩HH [M;   UVATH H\$@H|$HLl$PL*MIH@ HtHEHtH3HxHtHG3HX	HtHC3HtH3H@H
 HtHC3H@HYHtHG3H@8HI;HXDADeLl$PH|$HH\$@H A\^]@SH0HD$ Hٹ   D HD$HHt3HSDIDHDLE3Mu3
IChHcHJDhH0[LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MMH0  LG(LEHGH0  L0  L   H;MMIHE(HIMLJ    HEII;v6L/HMusH4    H   w2H   HHH;wHHHg H+Ll$pII0H|7 LHuHt6HIE3IH9IDHEHH]PH    H=   EXM;v5HwHulJ    H   w2J   HHH;wHHH H+Ht$pHH)H6 HHuHtl5E3IIH HDHE`LehJ    H=   EpHUI;v*5LgMumH    H   w9H   HHH;w
HHH H+Ld$pII#H6 LHuHt4HUE3MH MDLE8H    H=   0  IM  HUHH   HHE0(  H   ff     HHUH   LEL;IML0L+LL$8LL$0H\$(Lt$ L  L  HHM CQE3MH   H  LE(L  H   HM     K<H}@H   LE@H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM F{Ld$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM LHM LE(J    HHM LH   H;A    )L   H   HMHEH  L}0L   L   I;HUmLE80  t
I3 }p tHM`3 }X t
HMH3 (   H   A_A^A]A\_^[]@SH A   HD$0    HH [LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MH0  Lw(Lu HGH0  L0  L   H;MMIHEHIMLIII;v1L/HMusH4    H   w2H   HHH;wHHHr H+Ll$pII0H2 LHuHt%1HIE3IH9IDHEHH]PH    H=   EXM;v0HwHulJ    H   w2J   HHH;wHHH H+Ht$pHH&H1 HHuHtw0IE3IH HDHE`LehJ    H=   EpM;v90LgMuiJ    H   w9J   HHH;w
HHH H+Ld$pIIH,1 LHuHt/E3IH IDHU0J    H=   0  IL   M  HU HH   HHE@HL  IHHE8(  H   HHUH   LUL;IML0L+L\$8L\$0H\$(Lt$ L  HHM xE3MH   H   LEL  H   HME3K<H}(H   LE(H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM OvLd$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM 赿LHMLEJ    HHMLH   H;,L   H   HMHE8H  L}@L   L   I;HU L  A    oHU00  t
H. }p tHM`. }X t
HMH. (   H   A_A^A]A\_^[]H\$M;IML}uL
MtICHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CD|H\$@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHDIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HD JD|H|$Ht$M;}&LIPI IHIIM;HDJD|[H\$M;IML   HL MtIBHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CXDCD|H\$HcAH+HcAH+HcAH+HcAH+鄲HcAH+dHcAH+DHcAH+HcAH+HcAH+HcAH+4@WH0HD$ H\$PH3|$HOK HtHHHH{H{ H{(HH\$PH0_HL$VWATH0HD$ H\$XHl$`HHv HHc3IuH,I;v*H,    H?+ HuHt)HGH_HuH,I;v)H,    H+ HuHt)HGH_ Hw(Ht/I;v)H,    H* HHuHtb)Hw0H_8HH\$XHl$`H0A\_^H   HD$ HY4 HL$(N) HL$P* H, HD$PHT$(HL$hM) H- HD$PH	 HL$P H\$Hl$VH0LI HqHMHgfffffffHL+IHHH?HH;wHH|$@I;v) HHt$(3H\$ (D$ fD$ Hu) LLHD H4I;s wHtHHH;psb) HD$ HuR) H8H;w H|$@r<) H\$HHl$PHH0^HL$WATAUAVAWH0HD$ H\$hHl$pHt$xLHH9t HHZH3HuH6H;v'H<    H( HuHta'HHFH^I\$ HuH,H;v5'H<    Hs( HuHt'HFH^ ID$(HF(I|$8Ht9HH;v&H    H"( HHuHt&Hn0H~8IT$HN9<IT$HN+<IT$0HN0<HH\$hHl$pHt$xH0A_A^A]A\_HIH%' HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH  t,HL$@HtX Hl$@Hl$HHl$PHL$(? t0HL$pHt* Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_H\$WH0MM@E3LMtGIHH      fffff     IcD$PHD$PH#H;w0IM;r݋A(L
[r H4r IˉD$ PH\$@H0_HM Hq MHD$(HC IHD$ H\$Hl$Ht$WH@I@MHHHD$0H-=r H^` IHH)` LHHl$(HD$ LHH:L_DC(L
q Hq HL\$ QLHHH\$PHl$XHt$`H@_@  LWH   HD$ I[IkIsHHHIHB H+BHH;tYHr IK# HL$P$ H(' HD$PHT$(HL$h# HS' HD$PHם	 HL$P  HGH9Gr`3HtYfff     HG@H+G8HH;r9$ Hw8HE H+EHH;r$ HEXHH;_rHGL$   I[IkIs I_H\$WH HHI8Ht/  HK 3HC8HC@HCH  L( L@tH   HH\$0H _HL$ATH0HD$ H\$HHt$PH|$XHHٹ    HtH33HHHw H+wHHKHK HK(Ht}HH;v()HKHKIHCHC HHC(Hw H9wv" LgL;g v" HKI+HH    H<
HtLM{" H{ HH\$HHt$PH|$XH0A\H\$Hl$Ht$WH Hq HH9qvY" H{H;{ vI" H9{wH;{ v7" H+H9swH;s v"" HtH;+t" H;t/HC H+HH    H,:H~LLH! Hk H\$0Hl$8Ht$@H _HL$ATH0HD$ H\$HHt$PH|$XHHٹ    HtH33HHHw H+wHHKHK HK(Ht}H?H;vh'HKHGHCHC HHC(Hw H9wv! LgL;g v! HKI+HH    H<
HtLM  H{ HH\$HHt$PH|$XH0A\H\$Hl$Ht$WH Hq HH9qv  H{H;{ v  H9{wH;{ vw  H+H9swH;s vb  HtH;+tR  H;t/HC H+HH    H,:H~LLH Hk H\$0Hl$8Ht$@H _H\$Hl$Ht$WH0Hi HH9iv H3Hl$(3Ht$ (D$ fD$ Hu LLH]I;[ wHtHHH;Xs HD$ Huy H8H;_ rh Hl$HHt$PHH\$@H0_Ht$WH HHH;  HR LFHI+HHu[HHt$8H _LQLI M+II;wBI+HH~HIL HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHMGLO LF HH6H\$0HG HHt$8H _MtI HV HH+VHltLOLF HVH46HG HHt$8H _I;t,H\$WH IHH H(H;uH\$0H _H\$WH HYHHt.Ht$0Hq H;tH H(H;uHO Ht$0H\$83HGHG HG(H _@WATAUAVAWH@HD$ H\$xH$   )t$0MILHHAHu3HY(H+HM  La IH+HHHH+I;s#LI;   HHH+H;s3HI;IBHNH
CLHD$pM~L+~IJHfHtIE HHHIVLFI+HHtHLI? HV MFI?II+HHtHL HNHF H+HHHt IHF(IHF Lf   II+FHH;swA1IVLMH`HV HI+FHHH+Ht
2HHH    HF HN H+IFH;tjffff     0HH;uOA1HIH+MMHHHF MHINNM^I;L;tA3IL;uH\$xH$   (t$0H@A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMu3Igfffffff(HI(I+IgfffffffIHHHHH?HM?  MD$ II+IHHHH?HHfffffffHH+H;st L2I;^  HHH+H;s3HI;IBHIL$?HHD$8IMI+L$IHLIIH?LL|$@D$0    KH3D$($   D$ ML$L$   HI:D$0   3D$($   D$ ML$LIUIL$yD$0   I7LN3D$($   D$ ML$IT$ IM@ML$IL$ I+IHHHH?HHMtMD$ IIIL$x HHIL$(HHIL$ I|$  M+EIIHHH?HH;   IHL$P HH    IML3D$($   D$ ML$IT$ sMT$ II+MIHHHH?HH+3D$($   D$ ML$LD$PHI8I\$ I|$ H+I]H;tHT$PH H(H;uHL$P    IHL$P I|$ HH4    HH+3ML$D$($   D$ LHHID$ 3D$($   D$ D$   LHIM8I]H<3H;tfHT$PH
 H(H;uHL$P^ HĀ   A_A^A]A\_^[@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HHHH+I;sLI;   HHH+H;s3HI;IBHNH<LHD$`M~L+~IJHHtIE HHHIVLFI+HHtHLI	 HV MFI?II+HHtHL HNHF H+HHHtW IHF(IHF Lf   II+FHH;spIIVLMH,HV HI+FHHH+fD  HtHHHH    HF HN H+IFH;t_ HHH;uNM!HIH+MMHH货HF MHIN!M^I;L;t@ M#IL;uH\$hHt$pH0A_A^A]A\_@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HH?HH+I;sLI;   HHH+H;s3HI;IBHNH:LHD$`M~L+~IJHHtAE HHIVLFI+HHtHLI HV MFI?II+HHtHL HNHF H+HHHt IHF(IHF Lf   II+FHH;spAIVLMHm+HV HI+FHHH+    HtHHH    HF HN H+IFH;t`@ HH;uOE!HIH+MMHH*HF MHINM^I;L;tD  E#IL;uH\$hHt$pH0A_A^A]A\_HL$SH0HD$ HH   u H   p HKX] HKHR HK8G HK(< HK1 HKH0[H%  H\$Hl$Ht$WH HY HH9Yv HwH;w v H9wwH;w v H/H9_wH;_ v HtH;/t H;t2HO HH+HHH;tH+ HHHDH;uHW H\$0Hl$8Ht$@H _DD$SVAUH0Hq HHIHLH+HH;sPH;v HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MH0A]^[H;   Hl$PH|$XLd$hH;v H{H;{ v H+E3Hu ML] J<I;{ wHtLe I;|$si Ld$hH9{wH;{ vR H+H9swH;s v= HtH;+t- H;t/HC H+HH    H,:H~LLH Hk Hl$PH|$XH0A]^[HL$WH@HD$ H\$XHt$`IHHHIH_8H_@   + 3HtHHHHsHs Hs(H_p    HtHHHHsHs Hs(H   HH\$XHt$`H@_HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H    H   H   H   H-C6?H   H?H   H-q=H   HMbP?H   Hǃ   '  H      ?H  H:0yE>H   H  H   H     @H  H     @@H(  HH\$HH0_HL$WH0HD$ H\$HHl$PHt$XIHHH6] HRH/LY L]H5 HEHH}XH* HEPHu`HuhH 
   >HEpH?HExH   Hǅ       HH\$HHl$PHt$XH0_f/
 vIxf/
` vN f/v   HWH`  HD$ HX)pHHٺ   DBHL$P
 sxH\ HL$`6Hf( HT$(HL$P
 LHHAHL$(} HKHHPHL$P
 H$p  ($P  H`  _H\$WH H HHAPHI8 HO 
 HO  L LtHM HH\$0H _LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCIS)BHxHT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$Pt
 HL$HH+L$XIgfffffffIHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHfffffffHH+I;snN"I;\  HHH+H;s3HI;IBHHN/HH$   H$   3D$($   D$ LNLH$   HRHNLH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$HLH$   3D$($   D$ LNHV H$   HH;LF LNII+HgfffffffHHHH?HLMtIHHNq HHHN(KHHN H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$H&H^ I}H;tH(H;tHH H(H;uKL$    H^ I<H;t fH(H;tHH H(H;uHF II}H;tH(H;tHH{ H(H;uLf H`A_A^A]A\_^[H  HD$ HH$   0HHL$(­H	 HL$(% H  HD$ HH$   3HHL$(貭H	 HL$( @SH HJHHt H3HCHC HC(H [ HI H% H   HD$ HH$   @HHL$(ҹH	 HL$(U LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHH	H0H\$`H0HH0_^[M;   H\$H|$IMHI+HH   HLHII+ODL+HJTHHMf     HBA@H I@I HBHBADIDBHBAHI@JHBA@I@BuM;}0HHL JL+M+HAHIIDBuH\$H|$H   H%Z HIPH%M H   H%: @WH  HD$pH$  HH HHEH= HHEHL$H H HL$  A   E3H\ HL$H HH
 H;tTffffff     L
A
 A   HHL$H LCA   H HL$Ha HH_ H;uHT$HHL$ 2 H? HL$ ( HHL$  H$   \ HD H$   HT$ H$    H9 H$   H$   H$@  d]HH$   CHt	 H$   3 H  HD$ HH$    HHL$(H	 HL$( H\$Hl$Ht$H|$ ATH`H$   MHHHuHAHxHQLAHFHHJIHLI IHILHLH$   IHD$XHF HD$PHBHD$HHD$@I@LCL\$8HD$0HCLT$(HD$ /L\$`I[IkIs I{(IA\HWH   HǄ$   HXHpIHH HHEH= HHEHL$p$ HHL$H H HL$  A   E3H HL$p  HH
  H;tM    L
 A   HHL$p  LGA   H HL$p  HH  H;8uHT$pHL$ r H{ HL$ h HH$   (H$   H$   HC$   3HHHHqDHE3H) HL$H  HH  H;tE LA   HHL$H  L7A   H HL$H HH H;8uHT$HHL$  H$     H H$   HT$ H$    H H$   H$   H$  jHH$  gH	 H$   HIpH%=  H\$WH H   HH+   Hu( HOxHHO`H   HH+   HtHAH   H   HHOpH   HH+   HtHAH   H   HHOhH   HH+   HtHAH   H\$0H _HWH   HD$ HXHhHp IHH3hHIHIP t!HNHLHT$XP(   $   HNHLHT$(P(   $   HHt,HL$@Ht Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH6t,HL$@Ht Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP0   $   HNHLHT$(P0   $   HH&t,HL$@Ht Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_Ht$WH HHH;  HR LFHI+HHukHHt$8H _LQLI M+II;wBI+HH~HIL HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHM藍LO LF HHčH\$0HG HHt$8H _MtI HV HH+VH<tLOLF HVHtHG HHt$8H _HL$WATAUH@HD$0H\$hHt$xHHٹ   ? HtHE3E3IHHO H+OHgfffffffHHHHH?HLCLC LC(t{HfffffffH;vq HHK$ HCHC HHHC(Hw H9wv  LgL;g v 3D$(D$pD$ LKLCHI~HC HH\$hHt$xH@A]A\_HL$WH0HD$ H\$HHt$PHHYHt$Hq H;tH H(H;uHO 3HGHG HG(HH\$HHt$PH0_ @SH HH  D$0    HPHH [@SH HH  D$0    H HH [LD$SVAUH0Hq HHIHLH+HH;sPH;v HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MOH0A]^[H;   Hl$PH|$XLd$hH;vS H{H;{ vC H+E3Hu2 ML] J<I;{ wHtLe I;|$s	 Ld$hH9{wH;{ v H+H9swH;s v HtH;+t H;t/HC H+HH    H,:H~LLHu Hk Hl$PH|$XH0A]^[H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v. IE HtH;t I}I+HIE HL$ HT$ HIEMHAHA   LcL;c v HLd$(H\$ (D$ fD$ Hu LLI<I;{ wHtH3H;~s H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\T$SVAUH0Hq HHIHLH+HH;sPH;v HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MnH0A]^[H;   Hl$PH|$XLd$hH;v H{H;{ v H+E3Hu ML] J<I;{ wHtLe I;|$sh Ld$hH9{wH;{ vQ H+H9swH;s v< HtH;+t, H;t/HC H+HH    H,:H~LLH Hk Hl$PH|$XH0A]^[H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v IE HtH;tz I}I+HIE HL$ HT$ HIEMHAHA   LcL;c v5 HLd$(H\$ (D$ fD$ Hu LLI<I;{ wHtH3H;~s H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\H\$Hl$Ht$H|$ ATAUAVH0LHHI H{IgfffffffLL+I3MIIHHH?HuH=H;vF HM HtH;t2 HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k v HHl$(H\$ (D$ fD$ Hu LLHH| I;{ wHtH3H;~s H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtSHH;v#HILHFHF HHN(HHHtHHHHIHF H\$HHt$PH0_HL$WATAUH@HD$0H\$hHt$pMHH3HAHA HA(HtZHH;vHHHCHC HHK(3D$(L$`L$ LKMHHAHHC H\$hHt$pH@A]A\_HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtQH?H;vHiLHFHF HHN(HHHt
HHIHF H\$HHt$PH0_H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v IE HtH;t I}I+HIE HL$ HT$ HIEMHAHA   LcL;c v HLd$(H\$ (D$ fD$ Hu LLI<I;{ wHtH3H;~sl H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HE3LBHLJLJHDL$3H
LBD$HBHBH@SH HH0  HH [>ATAUAVH@HD$0H\$`Ht$pH|$xHHHH;vHIHu3HC(H+HH;   HKLHD$hH{ H9{vA LkL;k v1 3D$(D$hD$ LKMHIOHKH{ H+HHtb IHC(IHC LcH\$`Ht$pH|$xH@A^A]A\f/
  v%      Ix^,;L   HHHWH@  HD$ HXHH@       DBHL$@{    HL$(r HL$PHcQHLPHPHL$P HHL$@Q Ǆ$`     HL$@C HH$X  H@  _f/
 v f/v   f/
 v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$Pb    H; HL$`Hf({ HT$(HL$PC LHHAHL$( HKHHPHL$P H$p  ($P  H`  _f/
 v   HAHH HAHH`f/
 v f/v   f/
p v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$P    H: HL$`Hf( HT$(HL$P LHHAHL$(z HKHHPHL$P H$p  ($P  H`  _f/
p v   H\$WH HW= HHH HAPHI8 HO  HO L LtH# HH\$0H _H\$WH H7= HHH8 HAPHI8z HO p HOf L LtH HH\$0H _H\$WH HW= HHH HA`HIH
 HO8  HO  HO L LtH9 HH\$0H _H\$WH H= HHH HAhHIH HO8 HO v HOl L% LtH HH\$0H _H\$WH H= HHHh HAhHIH
 HO8  HO  HO L LtH9 HH\$0H _LL$ WATAUAVAWH@HD$0H\$xH$   ILLHAHu3HY(H+HM*  Lq IH+HHHH+I;sVLI;   HHH+H;s3HI;IBHIL$P
HHD$pMuM+t$IJ3D$(D$pD$ ML$L$   H3D$(D$pD$ ML$LIUIL$NHI6L3D$(D$pD$ ML$IT$ IM$HIL$ID$ H+HHHt HID$(HID$ I|$  II+EHH;   IH\$pH<    IML93D$(D$pD$ ML$IGIL$ HI+EHH+3D$(D$pD$ ML$LD$pH܌I|$ IL$ H+IEH;tqD  HHH;u^I3HIH+ML$D$(D$pD$ MIHGID$ MHIMM]I3L;tfIIL;uH\$xH$   H@A_A^A]A\_H   HD$ HfffffffH;vSH2; HL$( HL$P HS HD$PHT$(HL$h H~ HD$PHL$PHu3	H(l
HĘ   HXHD$ Hd HL$( L L\$(H>1
 HD$@H1
 HD$HHL$(#H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HHH0H;uH\$0Ht$@HHl$8H _E3DL$HtHIHAHBHAHBLBLJ LJ(HH\$WH   Hy HHrHIHH@D$@)D$8(H<H LHD$0H L
 HD$(H
 HHL$hH|$pHL$PHD$ H|$Xu8HL$PH/$tG<et<Et<-t<+u2H$   HĀ   _ðH$   HĀ   _@SH HHIHt H3HCHC HC(H [ھ HWH   HD$ HXHpHHHyHC H+CHH;ruH9 HL$h HL$(K H3 HD$(HT$hHL$@ HT$(H$    H
8 HHPH
8 HHX@`   HՔHGHAHC H+CHH;r HCHHHL$   I[IsI_@WH   HD$ H$  HHyHC H+CHH;ruH8 HL$h HL$(` HH HD$(HT$hHL$@ HT$(H$   H
8 HHPH
7 HHX@`   HHGHAHC H+CHH;r HCH$  H   _LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHH艾H0H\$`H0HH0_^[E3DL$HtHIHAHBHAHBI HBLJ LJ(LJ0H3H
LBD$HBHBHB HH\$Hl$VWATH0Hq A LD$PHH9qv H{H;{ v} H9{wH;{ vk H+H9swH;s vV HtH;+tF H;t/HC H+HH    H,:H~LLH Hk H{H;{ v HH|$(LL$PHD$ HT$ M(D$ HfD$ eH\$XHl$`H0A\_^HWH   HǄ$   HXHpIHHd HHEH=~ HHEHL$pd HHL$HU H HL$ B A   E3H HL$p. HH
, H;tM    L
 A   HHL$p
 LGA   H HL$p HH H;8uHT$pHL$  H/ HL$  HH$   (H$   H$   HC$   3HHHHqDHE3H HL$HZ HHX H;tE LA   HHL$HA L7A   Ht HL$H HH H;8uHT$HHL$  H$   0 Hp H$   HT$ H$    He H$   H$   H$  6HH$  Ha	 H$   @WH  HD$pH$  HH< HHEH=V HHEHL$H, HL HL$  A   E3H HL$H HH
 H;tTffffff     L
 A   HHL$H LCA   H0 HL$H HH H;uHT$HHL$  H HL$ x HHL$ j H$    H H$   HT$ H$   a H H$   H$   H$@  4HH$   蓠H`	 H$   胷 LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCIS)HxHWH   HǄ$   HXHpIHH HHEH=Ε HHEHL$p HHL$H H HL$  A   E3H HL$p HH
 H;tM    L
q A   HHL$p LGA   H@ HL$p HH H;8uHT$pHL$ b H/ HL$ X HH$   H$   H$   HC$   3HHHHqDHE3H HL$H
 HH H;tE LA   HHL$H L7A   H HL$H HH H;8uHT$HHL$  H$    H  H$   HT$ H$    H H$   H$   H$  1HH$  藝HH]	 H$  跴 E3DL$MtIMHHHAHBHAHBHAHBHA HB I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhI@HHBpI@PHBxL   L   HHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHLJPLJXHHE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhI@(HBpI@0HBxI@8H   I@@H   L   L   HH;   HH$LLH	HI H
ML;tIHIHIQMPL;tI
HIH
IQ MP L;tI
HIH
I(I(M;tIII I	H@VATHH1

 LHHT$0L@HHHD$ L;LD$ HL$0HME3L I  H\$(Hl$8H<$H>Il$MtIAHtH3HWLHIHtH3H@f(HHH HI^AXAMtIAHtH3LIXLSIHWIHtH3H@f(HHH II^DAXDADMtIAHtH3LHHWIHtH3H@f(HHH HI^DAXDADMtIAHtH3LLSIHWIHtH3H@f(HHH IIIL;^DAXDADH<$Hl$8H\$(M;}aLMtIAHtH3ISMHIHtH3H@f(HHH HIIM;^AXA|HA\^LAMtI@3LX8IHH+HLIHHHHM~  MtI@3H@0f MtI@3IH@ffY   MtI@3H@0f@MtI@3H@   H;fXfY}sMtI@3H@0fMtI@3H@ffYfXMtI@3H@0fLMtI@3H@HH;fDfYfX|L;fX~4MtI@3H@0fMtI@3H@ffYfXM;f(fXB  II+H   MJ   M+IIIOMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0Y
XMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(MtIH3MtI@3H@HI0A   M;Y?  ICH   MSAQIIN   D  MtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0YXMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(LATH   HD$`I[IkIsI{ A)sHHHyH (  H   HYH{   qAY0HWHMHEE3McMcMcICIKISMCISIKL$   IH$   H$   IH$   H$   J    H$   HFHPHFHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLG莚HL$p HL$x H$    L$   I[IkIs I{(A(sIA\HE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA(HB(I HB0I@HB8I@HB@I@HBHI@ HBPLJXLJ`LJhHHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA HB HA(HB(HA0HB0I HB8I@HB@I@HBHLJXLJ`LJhHLATH   HD$`I[IkIsI{ A)sHHH9H "  H   HYH{   A0HWHMHEE3McMcMcICIKISMCISIK[L$   IH$   H$   IH$   H$   J    H$   HFHPHHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLGHL$pq HL$xf H$   X L$   I[IkIs I{(A(sIA\HLE3LMSI   IH\$H<$IzAXHfffff     III8H IIHKXBBII8IHXBBII8IHKHXBBII8L;IXBB|H<$H\$M;}-IJII8IHIIM;XBB|H@VLE3LIsH  H\$Hl$AZH|$ Hn{MtI@HtH3IS8MIHtHH33AH@L8YI(\AMtI@HtH3MHSIS8HtHH33AH@L8YI(\AMtI@HtH3MHIS8HtHH33AH@8YI(\AMtI@HtH3MHSIS8HtHH33AH@IH HL;L8YI(\AH|$ Hl$H\$L;}YMtI@HtH3IK8MIHtHH33AH@IL;BLYJ(\A|^ATM;MML  II+H  HH\$Hl$L Ht$ H|$(N   IHI+ھ   HHI+I+HI+KHMD  HtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3H@BAYH(\HtHAHtH3HtHL3E3BH@H HI HLAYH(\BH|$(Ht$ Hl$H\$M;}VI$L HtHAHtH3HtHH33CH@IM;BLYJ(\CD|A\M;L}yHLfMtIBHtH3HHHtHA3H	tHH33H@BYJ(HtH3CYI8IM;\CD|HWH   HD$0HXHhHp HHHIHP8   Ơ 3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP8H_ H9_v HHD$`H\$hH$   HH$   H;v H$   H$   HL$pHL$@Ht$HH;v HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`HH$   Ht2H$   H;t H' H(H;uH$   Hj H$   H$   H$   HL$pH L$   I[Ik Is(I_HWH   HD$0HXHhHp HHHIHP@    3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP@H_ H9_v6 HHD$`H\$hH$   HH$   H;v H$   H$   HL$pHL$@Ht$HH;v HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`H>H$   Ht2H$   H;t Hw H(H;uH$   H躝 H$   H$   H$   HL$p蘝 L$   I[Ik Is(I_@SH H HHHI(Ht[ HK3HC(HC0HC8H [? H\$WH H HًHHI(Ht HK3HC(HC0HC8 @tH HH\$0H _H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;v HH|$(LD$ HD$ HT$0L(D$ HfD$ YH\$PHt$XH@_H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;vV HH|$(LD$ HD$ HT$0L(D$ HfD$ IH\$PHt$XH@_H\$Ht$WHPLAHHIgfffffffMuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ L_(L[ H\$hHt$pHP_L;v\ HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_H\$Hl$Ht$ WH0Hq HH9qv H_H;_ vٽ H9_wH;_ vǽ H/H9wwH;w v HtH;/t H;tIDL$@HW 3D$(D$@LHΈD$ Hw HHH;tHq H(H;uHo H\$HHl$PHt$XH0_HL@VWATAUAVHPHD$0HXHh MLHHq HILL+HgfffffffHIHHH?HI;sZH;vǼ HHL$@Ht$H(D$@fD$@HO H+OHHHHH?HL+MMHT$@Hm   L;   H;vd H_H;_ vT H/E3HuC ML] KD HI;[ wHtLe I;\$s H9_wH;_ v H/H9wwH;w v HtH;/t޻ H;tO3D$($   D$ D$   LHW HHHw HH;tH H(H;uHo IL\$PI[8IkHIA^A]A\_^H%x @WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH7 H(H|$`HS(H艗HSXHO0{D$h   Ɔ    HH\$HHt$PH0_@WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH H(H|$`HS(H蹘HSXHO0D$h   Ɔ    HH\$HHt$PH0_LATAUAVH  HD$`I[IkIsI{ IM3HJ H+JHgfffffffHLIIH?LII I+II*IHHHH?HL;  UDEIx޷ HO H+OIHHHHH?HHo H$   HH HHD HH HI HH HT$hH$   j HHL$ L H HD$ HHL$8	 H HD$ HT$ H$  BH
J HHPH
 HHX@`?   H̰HMtSHHO H+OIHHHH?HH;ry HGHHL$hH/HHH0I;rI] I+]HH;      DBH$   \ H H$   HH HH dHH HH IHT$hH$    HHL$  H8 HD$ HHL$8 HM HD$ HT$ H$  H
 HHPH
{ HHX@`I   HxL$  I[ Ik(Is0I{8IA^A]A\@SWAWH`HLE3H3ĥLGǄ$       Mu3HW(I+HH_ HI+HH;sHC    HG =L;vö HH\$(L$   HD$ LD$ HT$0(D$ fD$ H1IO H*I+OHHHHH?HH/  H$   Ht$XLd$PLl$HLt$@E3E3L$       HG H+GHL;r IO LgHI+OHHHH?HL;r Io3۾   IL- I+L-HHt)H;rŵ ID-IL- HH+HtH;rH$   HWB DD$   Hu3HO(H+HH_ HH+HH;sHCDHG    H;vI HO HoH7HHt$ H\$(H+Hu3"H;v HtH;7t H+H(D$ L$   HT$0A   HfD$0HoH;o vʴ H7Hu E3LHL I;K wHtH3H;Hs IO H$   II+OH*I0HHHHH?HIFH;Lt$@Ll$HLd$PHt$XH$   H`A__[HHHz HL$(HT$0u	fWHHHT$PHL$ HH@SH H+ HHH~ HAPHI8 HK  HK Le LH [@SH H+ HHH. HAPHI8p HK f HK\ L LH [@SH Hk HHH. HA`HIH  HK8 HK  HK L LH [@SH H HHHο HA`HIH HK8 HK  HK L[ LH [@SH H HHH HAhHIH` HK8V HK L HKB L LH [@SH H HHH^ HAhHIH  HK8 HK  HK L LH [@SH H貣 H      ?   Hǃ       ^CxH   ,;L   H HHH [@SHPHD$ HH HL$(, HT$(HHL$(2 H HL$(  HT$(HHL$( H HL$(ԯ HT$(HHL$(گ HP[H\$WH HH   HHH   HH   HH\$0H _HHHz  HBHD$(ufWY  HHHT$XHL$ Y HH@SH HE3H     @@ǃ      D   H   H D   HD   L   HH [@SHPHD$ HH_ HL$( HT$(H~HL$( H HL$(` HT$(HRHL$(f H HL$(4 HT$(H&HL$(: H{ HL$( HT$(HHL$( H
 HL$(ܭ HT$(HHL$( HP[H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v> HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H/fn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H詸   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v4 HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H%H   HH\$XHl$`Ht$hH@_"H\$VH@Iy IHH\$0LD$(tPHT$`HL$ @f/ v7H{ Ht$(H\$0t&HT$`HL$ f/ƴ v
H\$PH@^2H\$PH@^H\$WH HH   HHH   HrH   HH\$0H _YH\$WHPHz8 HB)t$@HD$(HB0HHHD$0ufWHT$`HL$ ]f(HHHH\$hY \(t$@HP_H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hfn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H艵   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HH   HH\$XHl$`Ht$hH@_H\$WH HH   HHH   HH   HH\$0H _H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H߳fn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;vh HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HY   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HղH   HH\$XHl$`Ht$hH@_@SH H肙 3H      ?   ^CxH   H   ,;L      H H   H      ?H   H   H   H?H   H      ?H   H   H      $@H   H   Ht HHR H   HH [H\$WHP)t$@)|$0=Ԯ f/HHD)D$ DADXDAvf(q(f(fA(XA@\^f(Y\YAXfA(q K8Ys ^C0fW
ӷ \fA( \YY{Xf({踁 H\$`(t$@(|$0D(D$ HP_@SH HC HH   H HHP HAPHI8 HK  HK~ L7 LH [@SH HRǃ      E3H     @@H   D   D   D   L   D   Hz L   L   H   H      ?L   H   H   H?H   H      ?H   H      $@H   H HH H   HH [@SH A(HA ; CH [@SH H; HH   H HH HAPHI8" HK  HK Lǫ LH [HL$SH0HD$ HH HHi H   Hx   Hh   H   H HH HC`HKH HK8y HK o HKe L LH0[M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OA^AAXAAAMtIBHtHH3HtHA3H@HHtH3AD^AAXAAAMtIBHtHH3HtHA3H@HHtH3^AAXAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;^ACXDCD|A]_H\$M;IML   HL MtIBHtH3HPHtHJ3HtHA3H@L HtHA3H@HBC\HtHB3H@IL;HBYDCXDCDpH\$M;L   LMtIBHtH3HHHtHA3H!tHP3J HtH3YH(HtH3H	tHA3H@HHtH3BIM;YAXCDgHL$SH0HD$ HH  HH  H   H  ] Hp  P H   K H HH1 HC`HKH# HK8 HK  HK L LH0[HL$SH0HD$ HH  HH  H   H   Hp   H    H HHѫ HChHKHs HK8i HK _ HKU L LH0[@SH A(HA y CH [M;
  VAUIIMI+LLH  HH\$Hl$ H|$(Ld$0HI+   IHJ   H+HL+LHMMtIBHtHH3HtHA3H@HHtH3OA^AAAMtIBHtHH3HtHA3H@HHtH3AD^AAAMtIBHtHH3HtHA3H@HHtH3^AAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAALd$0H|$(Hl$ H\$L;}TME MtIBHtHH3HtHA3H@HHtH3BIL;^ACD|A]^HM;ML   H$HfD  MtIBHtH3HPHtHJ3H	tHA3H@LHtHA3H@HBC\HtH3YB(IM;BD|H$HHI(H%- H\$Ht$H|$HqHYE3LHH   / fWfff     E3H   @ MtICHtH3HtHH3H!M;uf(f(HtH3YI(HtHH3H	tHA3H@HPL IIHtH3AHIHOAYIXIL;SIL;7H\$Ht$H|$E3DL$HtHIHHHAHBHAHBHAHBI HB LJ(LJ0LJ8HHL$SH0HD$ HH HH H   H  } Hx  p H(  k H HH HChHKHC HK89 HK / HK% Lޠ LH0[H\$WH H HH   H4 HH HAPHI8̘ HO  HO Lq LtHu HH\$0H _H\$WH Hg HH   H HH
 HAPHI8L HO B HO8 L LtHt HH\$0H _H\$WH HtHKt HH\$0H _H\$WH H,tHt HH\$0H _H\$WH HtHs HH\$0H _H\$WH HtHs HH\$0H _H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v IE HtH;tږ I}I+HIE HL$ HT$ HIEMHAHA   LcL;c v HLd$(H\$ (D$ fD$ Hur LLI<I;{ wHtH3H;~sL H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HWATAUH   HD$ HXHhHp)pL   kr Ht
HL$PH3HD$P3H\$h3HL$p3HT$xI9U u3I}HQ  Hu3H+HHH+HH;sHHHHL$pH\$h   HH;vS HL$pH\$hHl$PHl$0Ht$8HH+Hu3$H;v HtH;l$Pt H+H(D$0fD$@LA   HT$@HL$PqwH\$hLHL$pH;vɔ HL$pH\$hHl$PHu E3HL$pH\$hHD$PLII;S wHtHE 3H;Psu HL$pH\$hHI;}uI} I;}tHt
HT$xLL+IIHH;v- HL$pH\$hHH;v HL$pH\$hHl$PHu E3HL$pH\$hHD$PLJ4I;s wHtHE 3H;ps HL$pH\$hH;v HH+HH=   ~Eff     LHHL$0@cL\$8L;wI
H|$0H;v HH+HH=   E3HHuHD$pHL$hH+HL;r+ HL$hB4Hto HD$h    HD$p    HD$x    HL$P]o f(L$   I[ Ik(Is0A(sIA]A\_LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHHnHH0H\$`H@_^[LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHHYpHH0H\$`H@_^[H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HH胕H0H;uH\$0Ht$@HHl$8H _@SH03MM؈D$(D$@HLIMIHˈD$ 耊H0[@SH@Hy` HAXHHD$(ufWm YCxH@[HT$PHL$ dl YCxH@[@SHPHy )t$@qhHAHHHD$(HAfT5 HD$0t$hufWHT$`HL$ 1H8  f/wHD$h^ (t$@fW: HP[@SHPHy )t$@qhHAHHHD$(HAfT5 HD$0t$hufWHT$`HL$ H  f/wHD$h^ (t$@fW HP[@SH HHI HKH [H%Տ HVWATAUAVH   HD$ HXHh)pIHH3IMuH,M;v0N$    In HuMtHD$8H|$@HuH,I;vL$    I. HuMtύHD$(H|$0H   LuLNLL+A   L+A   L+IL+LGIIJ    fffff     KT
 INHD$8HIAHHHD$(HK
HD$8HLIHHHD$(HLKINHD$8HIAHHHD$(HAKHD$8IA@HD$(I I IdH;s0H+H)HD$8HHHD$(HH;rHD$8HD$PHD$(HD$XH|$0 ufWH$   HL$H;f(HL$( HL$8 f(L$   I[0Ik8(t$pIA^A]A\_^LWH   HǄ$   I[IsHISHHHAHBHAHBHAHBHA HB HyH^HF3HL$@IKIKI[ICI{MCISIK<L\$hIHD$XHD$pIHD$`HD$xJ    H$   HF HL$@HL$0HD$(HHD$ L$   L$   HHuEHL$@q HL$Hf HL$PL$   I[IsI_H%F H(f(f(fT
\ f/
ĝ vGf/
 r+f/H vH H
X 軆 H(g \ H(˝ f/v	f(H(%  f(Yf(f(Yt Y
 X
| \f(Y YYX YXx YXf(Y \% \YY\ YY- XXH ^Xf(H(H@H   )pD)@D)P}	 fD(Шum
 D  R	 
*	 
 D		 
	 
q 	 
		 
Q 
	 	D	 5 ua
"  	 
y	 
 a	 
i	 
 5q	 
Y	 
 
Q	 uy 
 t	 	 d 
	 
L 	 4 	  
	 
 	 
	 uq 
 	 	  
	 
 	  
	 
g 	 
	 5	    7 
' ~	 f	  
^	 
 V	  
N	 
 F	  
>	 
 6	 
6	     f 
V  	 	 5 
	 
 	  	  
m	 
 u	 5u	 
]	 } @ugQ -a 
Q @X	 8 	  	 	 -	 
	 	 f(
	 -	 %z	 x\  	 4	  	 $	 l 	 	 5	 	 rj4 $ r	 	  z	 	  z	  r	  j	 	rb  		 	 b 	 	 B 5	 	 " 	 
D)d$PrD% 
D%	 	 	D%o	 r M	 g	 ry %	 G	 
D)\$`rDJ 
D	 	 	D	 D)|$ rD= D=	 	 	D=	 D)$   rD
 D
|	 	 	D
k	 D)t$0rD5 D5A	 	 	D50	 )$   r=Z =	 P	 =	 D)l$@rD-! D-	 	 	D-	 fWfA/vH
9	 L$   Hh ͩfD.zuH
	 H ~ϕ fA/  fA(fA(AYfD(fA(A^_ f/Y DYD^
Z    f(f(Y
\	 Y$	 X
D	 X	 YYX
$	 X	 YYX
	 X	 YYX
	 X	 YYX	 AX^   ^f(f(Yr	 AYX
	 Xe	 YX
	 YXU	 YX
	 YXE	 YX
q	 YX5	 YX
a	 YX%	 ^DY fE(EXE\E\EYDYEX   fA/rXfA(L$   H5	 H
f	 E3AY$   舚DY
 =	 fA(A\fD(A\hD fE/   fA(L$   HI	 H
	 E3AY$   ,Y= fA(fD(\=6	 A\f(AXYfA(DY=D^f(fA(X] YR Y^5 DX  E^fA(AYf/   f(fD(DY%	 YQ	 DX%p	 X8	 DYYDX%N	 X	 DYYX	 DXDYYDXX	 DYDXYXD^   f(^f(fD(DYYX	 DXDYYDX%	 X	 DYDX%	 YXs	 DYDX%	 YXa	 DYDX%	 YXO	 D^f/   fD(f(DY
	 Y	 DX
	 X	 DYYDX
	 X	 DYYDX
	 Xi	 DYYDX
	 XG	 DYYDX
]	 X%	    ^fD(f(DY
:	 Y	 DX
1	 X	 DYYDX
	 X	 DYYDX

	 X	 DYYDX
	 X	 DYYDX
	 X	 D^fA(Z f(fA(Z f(fA(Z Du f(EYD^X\AYAYXDYD(|$ D(t$0D(l$@L$   fA(A(sE(CE(SD(d$PD(\$`D($   ($   ID$H   	 D)$   D)T$`fD(uy
5 %  	 
|	 
 	  
l	 
 
l	 
 D	 
d	 T	 DÅ urw 
g >	 	 F 
	 
. 	  
	 
 	 
	 D	     
 	 	  
	 
 	 l 	 T 
	 
< 	 $ 
	 
 	 
	     
 #	 	  
	 
 	  
	 
k 	 S 
	 
; 	 
	 D	  fWҨui 
r 	 9	 Q 
1	 
9 )	 ! )	 	 
	 	  uj 
ݱ  	 	  
	 
 	  	 T	 
l	 Ds	 @uqW 
G @	 	 & 
	 
 	  
	 
ް 	 
	 	 xs 
 0	 8	  
0	 
h (	 P 
 	 
8 	 
	 D	 D)\$PrD2 D	 	 	D	 	D)d$@rD% 	D%	 |	 	D%q	 
)$   r5 
5G	 I	 57	 D)t$ rD5 D5
	 	 	D5	 )$   r=F =	 	 =	 
D)l$0rD-
 
D-	 	 	D-	 fA/rL$   H1d H
jd =t D)L$pfA/r|fA(L$   H	 H
	 E3AY$   趐Y5F fA(fD(fA(\AXA\YfA(A^DYdE^f(   D fE/   fA(L$   H	 H
	 E3AY$   vY= fA(fD(fA(\AXA\YfA(A^DY)dE^f(fA(dS Y^ Y^5 DX   E^fA(AY$   fA(0S f(fA(S L$   H	 H
B	 E3f(fL$   H_	 f(\fD(H
	 E3EYDY1XYD\fA(R Y: D^EYD(t$ D(l$0D(d$@fA(D(L$pD(\$P($   ($   D($   D(T$`Hĸ   H@H   )p)xD)HfD(D)PT	 uk
x h X /	 ? %/ - 
	 	 	 	 %	 -	 0-	 %	 	 	 	 
	 =} D)\$`D)d$PD)l$@u<D D%} |	 D+	 D%*	 =*	 fD(D-	 D%		 D	 D' D)$   D)t$0D)|$ u_D D= 5 	 D	 D Dp	 D	 D=f	 5f	 fE(D=N	 D5=	 u>5i DX 	 5	 D	 D	 =	 	D	    D	 5 @	 D_	 D 5F	 DM	 D DC	 D D9	 D D/	 Df D%	 DL D	 D2 D	 D D	     D  =	 }	 D4	 D D*	 D D 	 D D	 D} D	 Dc D	 DI D	 D/ D	 D D	 D D	 fWfA/vH
	 L$   Hc fD.zuH
k	 H ?mfA/   fA(AYf(YfD(DYDXDYDXf(YXDYYDXf(AYAXDXYAXD^fA(M f(f(f(Y
	 Y	 X
	 Xg	 YY5	 YXG	 AXAXYYAXX^YD\8  A^fA(fW0 f(Y5M fD(fA(DM f(f(D^f(f(Y	 Y_	 Y
O	 X	 X7	 X
'	 Y	 YYX_	 X	 XW	 YYYX+	 X
	 X	 YYYYX	 X	 X
	 YYYXw	 X	 X
_	 YYYXC	 XX	 X^DYD(|$ D(t$0D(l$@L$   fA(A(sA({E(KE(SD(d$PD(\$`D($   IH@H   )xD)@D)HD
: fD(D)XD)`D)l$@'	 D)t$0D)|$ uqD% D- D5 	 D=  D%	 D-	 D5	 D=	 	 D
}	 fE(-D=	 D5|	 D-k	 D%Z	 DI	 =9w u<
- D
		 S	 
	 
 =	 
	 	D
	 fWua 
 	 	  o	 	  
_	 o	 _ g	 uAC 
3 	 	  
	 	 =	     
 Y	 a	  
I	 Q	  I	 y A	 a 9	 I 1	 1 )	  !	  	  	      
  	 P	  
8	 @	 x =h	 0	 X (	 @  	 ( 	  	  	 fA/vH
	 L$   Hc fD.zuH
]	 H )gfA/)$   D)T$p  fA(fA(AYf(YH f(Y
7	 f(fD(f(Y	 X
	 Yb	 X	 AXYYYX
	 AXYYXf(Y	 X
	 X	 YXx	 YXd	 ^f(AYDYAXYXf(Y	 AXX	 YXx	 YAX^DXE^8  A^fA(fW| f(YF fD(fA(F f(f(D^f(f(Y	 YQ	 Y	 X	 X)	 Xq	 Y
!	 YYXQ	 X	 X
	 YYYX	 X	 X	 YYYYX	 X
	 X	 YYYXi	 X	 X
a	 YYX	 XYX1	 X^DY($   D(l$@D(t$0L$   fA(A({E(CE(KE([E(cD(T$pD(|$ ILATH   HǄ$   I[IkIsI{ A)sHHHH{   H{    HqH~    A0HSHMHEE3Ld$0Ld$8Ld$@ICIKISMCISIKEL\$XIHD$HHD$`IHD$PHD$hJ    HD$pHGHHHH$   H$   H$   $   HT$0H$   Ld$(HL$ E3L@3H$   eHL$0zh HL$8oh HL$@dh L$   I[IkIs I{(A(sIA\M;6  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3I@IBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@HBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@BYBPAXAHtHAHtH3HtL@E3HtHP3I@I I HHBDYBPAXAAALd$0H|$(Ht$ Hl$L;}]IE LHtHAHtH3HtL@E3HtHP3I@IL;BDYBPCXDCD|A][M;  WAVHIIMI+LLH  HH\$ Hl$(Ht$0Ld$8L,$HHA   I+IJ   HH+L+HL+LHMMtIBHtH3HtL@E3HtHP3I@KL
 ^BpAAMtIBHtH3HtL@E3HtHP3I@I)^BpAAMtIBHtH3HtHP3HtHH3HB^ApAMtIBHtH3HtL@E3HtHP3I@KH I H^BpAAL,$Ld$8Ht$0Hl$(H\$ L;}QMMtIBHtH3HtHP3HtHH3HBIL;BD^ApCD|HA^_E3LLIPMuIHHJuIHaHAuIH@fBHtHIIpHJffYHuIH	HAuIH@fB$HtLIAIPIHffYfXfBXfB)HtHA3LPIHH+HLIHLIIM  HtHA3IH@ffY   HtHA3H@   I;fHfY}FHtHA3H@ffYfXHtHA3H@HI;fDfYfX|M;fX~HtHA3H@fBfYfXM;f(fX   II+H   MJ   M+IIIOHtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(HtHA3H@A   M;Y   IBH   MJAPIIN   D  HtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(M;I  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3AAI@IBYJp\AAHtHAHtH3HtL@E3HtHP3AAI@HBYJp\AAHtHAHtH3HtL@E3HtHP3AI@BYJp\AHtHAHtH3HtL@E3HtHP3AAI@I HI HBLYJp\AALd$0H|$(Ht$ Hl$L;}`IE LHtHAHtH3HtL@E3HtHP3CI@IL;BLYJp\CD|A][HL$WH0HD$ H\$HHHD$P        : HtH3HHD$P    LD$P   HjHC H+CHHu.] HCH8HH\$HH0_HL$WH0HD$ H\$HHt$PIHHD$X       h9 HtH3HHD$X    LD$X   H^jHC H+CHHu\ HCH0HC H+CHHww\ HCHxHH\$HHt$PH0_H\$Ht$ WH@HA`HA Hy`H+AHHHH;s<fHCPH+CHHH;r	\ HCHH94sHC`HC H{`H+CHH;rHC H+CHH9C`   HK0;HHH;HBHL$` HT$PHHD$P.H;H8 u6H	 HL$ A   [ L] HB HL$ L\$ 7 HT$`HK0ܚHC H{`H+CHH;r1[ HCH<H7Hs`HCpHKPH+KHHH;r[ HKHHHHt$hHHKhH\$XH@_HT$HL$UVWH`HD$ H$   HHH H$      .7 3HtHHHL$      H'hH{0H$      6 HtH8HHL$      HgHk`HC H+CHHuZ HSHHHKhHC H+HHuY HCHHKpH{x   q6 HtH8HHHoHo Ho(H      D6 HtH8HHHoHo Ho(H      6 HtH8HHHoHo Ho(HC H+CHHuTY HCH8 u6A   H	 HL$(Y L[ L\$(H HL$(5 HH$   H`_^]@SVWH03H_^ IHHqH=t	 HHL$PHuHHk	 H+HH
U	 HH+HH;sHAHH8	 HH0_^[Hl$XLd$`HH;vuX H
	 H=	 H	 HHl$(H+LHT$ HuH)H;v
5X H	 MtL;tX H+H(D$ LL$PHT$ H
	 A   fD$ @L%	 L;%	 vW H=S	 HuW LLILd$`Hl$XI;C wHtH7H;FsW HH0_^[@SH@HD$ )t$0f(HH~	 HHHp	 H;a	 r   H
	 HHL$PHtf( 3HH(t$0H@[LAHHI      A@D$HD$H#I;wAHB @D$HD$H#I;w%BAX@A@HB @XB@HS HIHHS HR HHJHQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH)S HHJ@WH0HD$ H\$HHl$PHt$XIHHH	 HH(H	 H;	 r(   H
O	 JHHt$@Ht,H?HOXKHuH^H~ H H3Hu HH\$HHl$PHt$XH0_@WH@HD$ H\$PHt$X)t$0f(HHf.X] z
uHHHmH	 HH(H	 H;	 r(   H
	 HH|$`Ht)Hf(XKHH_w Hi H3H>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0If(Hf.
\ z
uI HHmHJ	 HH(H<	 H;-	 r(   H
	 HH|$XHt)Hf(XKHH_w H H3H>HH\$PHt$`(t$0H@_LAHHI      A@D$HD$H#I;wdHB @D$HD$H#I;wHHB B^@AX@A@HJ HBHAYJY^A\AH)P HIHHP HR HHJHA IYI@Y^@\@@WH0HD$ H\$HHl$PHt$XIHHH	 HH(H	 H;	 r(   H
	 
HHt$@Ht,H?HK^OH5H^H~ H H3Hu HH\$HHl$PHt$XH0_@WH@HD$ H\$XHt$`)t$0If(HH	 HH(H	 H;	 r(   H
^	 YHH|$PHt)Hf(^KHwH_ H  H3H>HH\$XHt$`(t$0H@_AHI      D$HD$H#I;w0HA @D$HD$H#I;wHA @\A@HN HQ HHJ@WH@HD$ H\$XHt$`)t$0If(HH	 HH(H	 H;	 r(   H
>	 9HH|$PHt)Hf(\KHhwH_ HX H3H>HH\$XHt$`(t$0H@_LAHHI      A@D$HD$H#I;wSHB @D$HD$H#I;w7HB @YBAX@A@HBHJ @YBXAAHL HIHHL HR HHJ@WH0HD$ H\$HHl$PHt$XIHHHr	 HH(Hd	 H;U	 r(   H
	 HHt$@Ht,H?HOYKHH^H~ H6 H3Hu HH\$HHl$PHt$XH0_HQIBD$HD$I#I      I;vHK HHJB\AB@WH0HD$ H\$HHt$PHHHz	 HH Hl	 H;]	 r    H
	 HH|$@Ht(HKfW
_ H
H_H H3H>HH\$HHt$PH0_E3HL9Av0@ HB IJLHB(BDYBXAAL;BrAHAYAX@@HR HH@WH0HD$ H\$HHt$PHHHj	 HH H\	 H;M	 r    H
	 HH|$@Ht)HC( f(HH_H H3H>HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHHEnf(HH HHG H+GHH    H	 HHH	 H;w	 rH
	 HHNHG H+GHHF 3Ht8 HG H+GHH;rL HGHNHHHH;^ rHHH\$HHt$PH0_E3L9A v(    HAIJTBXABL;A r@WH0HD$ H\$@HHHB H+BHufWHNH	 HH(Hs	 H;d	 r(   H
	 HHL$HHt
HT3HHH\$@H0_HATAUAVH   HD$ HXHhHpHx ILH3H9Y~%HƐHI HH蚋HcH;G|DH9w~gL Hu HL$PnI HII` LHHL$(/I HHCHL$(WI HL$PKI AMcL;w|H ~hLD  H HL$(H HIILHHL$PH HHӊHL$PH HL$(H LcL;o|L$   I[ Ik(Is0I{8IA^A]A\H\$Hl$Ht$WH 3HHH9y~'Hf     HCHH萉HcH;K|H9{~XHff     HCHH`HcH;K|H9{~*Hffff     HC0HH0HcH;K|H\$0Hl$8Ht$@H _HLH L@HHSVWATAUAVAWH  HǄ$H  )pILLIH%HH$   &- $  H$   %H$   '   $ HtH$   H33HH$   H$8  H$@  H$H     $ Ht
H$   HHH$   H$  H$   H$(  H= H$P  F IH$P  IPH$P  F tZH HL$@hF H$   G HJ H$   HT$@H$8  ^F H H$   # H H$P  F IL$P  HT$@IPHH$   JHL$XHtO# H|$XH|$`H|$hHL$@6# H$P  E HTL HL$@E H H$x  E H H$P  mE HL$pHD$ LL$@L$x  H$P  IH$   Ht" H$   H$   H$   HL$p" H$P  E H$x  E HL$@ E L$@  H$8  L+IMuE H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;vHE H$   H$   H$   LHL$0Ht$8HH+HuH*H;vE H$   MtL;tD H+H(D$0fD$0L$   A   HT$0H$   K'L$   L;$   vD H$   HuD LLII;K wHtHHH;HseD H HL$@BC IHT$@IPHL$@CC tZHh HL$@
C H$`  ND H6G H$`  HT$@H$x  C HC H$`  Z  H" HL$@B ILD$@HT$pIPHH$   ~GH$   Ht H$   H$   H$   HL$p HL$@mB HH H$P  8B H H$x  "B H HL$@B HL$p4HD$ L$P  L$x  HT$@I衸H$   HtJ H$   H$   H$   HL$p( HL$@A H$x  A H$P  A L$@  H$8  L+IMupB H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;vA H$   H$   H$   LHL$0Ht$8HH+HuH*H;vA H$   MtL;tA H+H(D$0fD$0L$   A   HT$0H$   #L$   L;$   vEA H$   Hu2A LLII;K wHtHHH;HsA H7 HL$@? IHT$@IPHL$@? tZH HL$@? H$  @ HC H$  HT$@H$  ? H H$   H HL$@U? ILD$@HT$pIPHH$    DH$   Ht H$   H$   H$   HL$pw HL$@? LHE H$P  > H H$x  > H! HL$@> Ic   HL$pHD$ L$P  L$x  HT$@I9H$   Ht H$   H$   H$   HL$p HL$@X> H$x  I> H$P  :> fW$   Ic       Ht
H$  HHH$  L$   HH$  LDHA    {   fMIH$  H$  H+HH;r> H$  H$@  H$8  H+HL;rn> H$8  JHAHL$0  E;   |D@ E;     IcH$  H$  H+HH;r> H$  L$H$   HuHH$   H+HL$   IH+HH;s0   IfHtI$HHHI@H$     II;v= L$   H$   H$   LHL$0Ht$8IH+HuH*I;vI= H$   MtL;t1= H+H(D$0f$   MA   H$   H$   L$   L;$   v< H$   Hu< LLII;K wHtHHH;Hs< L$0  L$0  ANH HL$@l; IHT$@IPHL$@m; tZHB HL$@7; H$`  x< H`? H$`  HT$@H$x  -; Hm H$`   H HL$@: ILD$@HT$pIPHH$   ?H$   Ht! H$   H$   H$   HL$p HL$@: H A H$P  b: Hz H$x  L: H HL$@9: HL$p^HD$ L$P  L$x  HT$@I˰H$   Htt H$   H$   H$   HL$pR HL$@9 H$x  9 H$P  9 L$@  H$8  L+IMu: H$8   f(Q$   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v: H$   H$   H$   LHL$0Ht$8HH+HuH*H;v9 H$   MtL;t9 H+H(D$0fD$0L$   A   HT$0H$   L$   L;$   vf9 H$   HuS9 LLII;K wHtHHH;Hs(9 H HL$@8 IHT$@IPHL$@8 tZH HL$@7 H$`  9 H; H$`  HT$@H$x  7 H H$`   Hy HL$@v7 ILD$@HT$pIPHH$   A<H$   Ht H$   H$   H$   HL$p HL$@07 LH= H$P  6 H H$x  6 HB HL$@6 IcUDHL$p0HD$ L$P  L$x  HT$@I]H$   Ht H$   H$   H$   HL$p HL$@|6 H$x  m6 H$P  ^6 $   Ic]D    Ht
H$  HHH$  L$   HH$  DDHA}D v   MIH$  H$  H+HH;r6 H$  H$@  H$8  H+HL;r6 H$8  JHAHL$0  E;eD|D    E;uD  IcH$  H$  H+HH;rA6 H$  L$H$   HuHH$   H+HL$   IH+HH;s3   ID  HtI$HHHI@H$     II;v5 L$   H$   H$   LHL$0Ht$8IH+HuH*I;vy5 H$   MtL;ta5 H+H(D$0f$   MA   H$   H$   L$   L;$   v5 H$   Hu5 LLII;K wHtHHH;Hs4 L$0  L$0  ANH$   H$H  8H$   H$@  DH$  Ht H$  H$  H$  H$   H$  Ht H$  H$  H$  H$   H$  Ht} H$  H$   H$(  H$   X H$8  HtE H$8  H$@  H$H  H$     H$   Ht
 H$   H$   H$  H$    H$   Ht H$   H$   H$   H$    ($  H  A_A^A]A\_^[HATH   HD$0HXHhHpHx IIHH   u E3Ht
HL$8HIHD$8Ld$PLd$XLd$`   B Ht
HL$hHIHD$hL$   L$   L$   H\$ LL$8LD$hHHHl$XH+l$PHH;otHT2 Ht
HaHL'HoAIH~?     HD$XH+D$PHH;r2 HHD$PHHHHcH;G|H$   HtC L$   L$   L$   HL$h! HL$PHt Ld$PLd$XLd$`HL$8
 L$   I[IkIs I{(IA\HWATAUHP  HD$HHXHhHpEEHHٽ   DōUHL$PP/ HL$ ,/ HHL$P. HL$ 0 Hf HL$`PZHT$ HL$P / HHqHL$ / HL$ . HHL$P>. HL$ / Hߟ HL$`YHT$ HL$P. HHUqHL$ i/ 9   |~HL$ d. HHL$P- HL$ 9/ HZ HL$`YHȲ.WHȋ- HT$ HL$PC. HHpHL$ . ;   ~HL$ - HHL$PW- HL$ . H HL$`
YHT$ HL$P- HHnpHL$ . 9kD|{HL$ - HHL$P, HL$ U. H& HL$`XHȲ.VHȋ, HT$ HL$P_- HHoHL$ . ;{D~EuEuHL$P3-   9   |~HL$ , HHL$PR, HL$ - H HL$`XHȲ.+VHȋX, HT$ HL$P, HHToHL$ h- ;   ~      HL$ R, HHL$P+ HL$ '- H  HL$`vWHȲ.UHȋ+ HT$ HL$P1, HHnHL$ , ŋ   ;zHL$ + HHL$P=+ HL$ , Hr HL$`VHT$ HL$P+ HHTnHL$ h, Eu
HL$P+ HL$P+ L$P  I[ Ik(Is0IA]A\_@VWH8HHH;  LZ H\$XHZLd$0MIgfffffffL+IILIIH?LunH\$XLd$0HH8_^LQHl$`Hi HII+HLIIH?LM;   DL$P3MD$(D$PIHˈD$ pfHo HH;t@ HG+ H(H;uHN IH+NHHHH?HHGHHHHO Hl$`H\$XLd$0H8_^Mu3HO(II+HHHH?HL;wZKDL$PHH3MD$(D$PHӈD$ eLG HV 3LOD$(D$PHˈD$ HG HgMtLIHC
HO HN IH+NHHHHH?H趹tLOLF HVHHG HHH8_^HT$VWATH0HD$(H\$PHl$`AAHHE3Dd$ AL$@ HtHIHLcLc Lc(D$    H  DDHHH\$PHl$`H0A\_^HWATAUH   HD$0HXHhHpMLHIp    tYH7 HH( HL$89* Hy, HD$8HT$xHL$P( H, HD$8H HL$8B INLA    tH~$HF    tIIL$HyH;   H^    uH_HE0H9puHxH93uH;H{HU0H92u8    tH'HH    uf     HH     tH
HU0H9r       tH"HHG    ufHH@    tHJ   IKHHH;NuH$HY    uH_H;HFHAHFHHHE0H9puHHHFH90uHHHHFHAH   L   L;tAA 
     HE0H;x  ff          HH;udHK    uƁ   ƃ    HH.HK    tH   H      HA   u}Ɓ    HZ    uƁ   ƃ    HH.H    tH'HA      H   uzƁ    HH[HE0H;x   HA   u Hƀ   Ɓ    HH-.HK      ƃ   HAƀ   HH-UH   u HAƀ   Ɓ    HHt-H      ƃ   Hƀ   HH-Ƈ   H   Ht 3H   H   H   HNp HNXHt H~XH~`H~hHN@ HN3% H HE8HtHHE8HL$ I$HID$HAHD$(HD$(HE HD$ HL$ HIE HAIEIL$   I[ Ik(Is0IA]A\_I;tXWH H\$0Ht$8I3HZ HHt HKH3HsHs H0HCH;uHt$8H\$0H _H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ v$ HHL$0H^HHE HHEHAH\$8H9_wH;_ v$ HHtH;t$ LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$hI@Ho LH;t2HXHHt  HKL+LkLk  H0HCH;uLg Ld$hH\$pHl$xHH@A]_^Hl$Ht$WH     HHH   H\$0fD  HVHH   H6Ht,  HOp3H   H   H     HOXHt HO@3HGXHG`HGh HO" H     HyH\$0Hl$8Ht$@H _ATHPHD$8H\$`Ht$hH|$pIIL⹨    HHD$0HD$@Ht+$   L$(H$   HL$ LLIHsgHH\$`Ht$hH|$pHPA\ATHPHD$8H\$`Ht$hH|$pIIL⹨    HHD$0HD$@Ht+$   L$(H$   HL$ LLIHsgHH\$`Ht$hH|$pHPA\@SH03MM؈D$(D$@HLIMIHˈD$ `AH0[H\$Ht$WHPHHIHHuE3LC(L+IH{ HH+HI;s;3LLKD$(D$`   HψD$ L_L[ H\$hHt$pHP_H;vY! HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,CH;}8D$8f    HHH;Hf(DfYf)D|HL$ LLHH\$pHH@_^]@SH HLE3LHHIHH+HLMM~+@ HIM;HIfB(DfBXDfB)D|HI>HH [HT$UVWHPHD$ H$   H3ۉ\$pHAHpHt$0fWD$@HuH6HH;vH,    HC HuHtHHwHt.HH;t̄t̄tHwHHH+HLMM~ (H      Hf)HI;|LHHL$(HH$   HP_^]HT$VWATH0HD$ H\$PHl$hH3t$`M`Il$HuH9HH;vH    H. HHuHtHHoI\$HHtH;tHtH;t̄tH;t Ht
H9MHH7H_HHH+HLMM~!    I$f(Hf)HI;|LHIHH\$PHl$hH0A\_^H   HL$ LD$PHB@HD$(HHz HT$0HHT$HI HAI@HAI@HAI@ufWY. HĈ   H$   HL$@eYu. HĈ   HT$VWATH0HD$ H\$PHl$hH3t$`M`0Il$HuH9HH;v H    H^ HHuHtHHoI\$HHtH;tHtH;t̄tH;t Ht
HiKHH7H_HHH+HLMM~!    I$f(Hf)HI;|LHI(HH\$PHl$hH0A\_^H\$Hl$WH HY3HHtLHt$0Hq H;t0D  HKHt HHkHk Hk( H0H;uHOx Ht$0H\$8HoHo Ho(Hl$@H _Dʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ   +i+ȋH [At+;s
H|$0H [ÍU  H|$0H [LDA   H   Ip     AtlEtgAuE\3҃A=r#E   AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ   AA+iD+'EIMIIH+HHHHiɫL+IADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ  +i+ȋH [At+;s
H|$0H [Í  H|$0H [LDA   H   I   AtlEtgAuE\3҃A=r#E  AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ  AA+iD+'EIMIIH+HHHHiL+IAH\$Hl$VWATH0LHyHHHL$PH|$hAtH$IHD$hHL$ IAI;LD$ HMHHLE3H+HHH+HT$PHL$CI;}2HE HHI;fDf(Lf)DHE fLfL|HT$PLMHyH\$XHl$`H0A\_^HHHSVWATAUAVAWH   HǄ$  )p)xD)@D)HD)xIILfEWfA(3L$  IH$  H$  E3L$   L$(  H$  3fD($x  H$  3fD($  AN Ht
HL$pHIHD$pL$   L$   L$   Mc   Mf  fff     H$  33$p  H$   HuIH$   H+HH$   HH+HH;sHAH$      HH;v? H$   H$   HT$pHH$@  H$H  HH+HuI'H;v HT$pHtH;t H+H($@  fD$0L$p  A   HT$0HL$pBH$   H;$   v H\$pHu MLHI;K wHtHIH;Hs_ IH$  1f(Hm fW
$ fD.zt f(AX$@      Ht
H$   HIH$   L$   L$   L$   MceDMi  D  H$  C1$p  H$   HuIH$   H+HH$   HH+HH;sHAH$      HH;vO H$   H$   H$   HHT$0H|$8HH+HuI*H;v H$   HtH;t H+H(D$0f$   L$p  A   H$   H$   LH$   H;$   v H$   Hu MLHI;K wHtHIH;Hsf IIWHuIIO(H+HI_ HH+HH;sDHCIG    H;v I?H|$0H\$8IO IwHH+HuI"H;v HtI;?t H+H(D$0f$   L$x  A   H$   I-IwI;w v I?Hu MLHI;K wHtHIH;HsT IWHuIIO(H+HI_ HH+HH;sDHCIG    H;v I?H|$0H\$8IO IwHH+HuI"H;v HtI;?t H+H(D$0f$   L$  A   H$   I%IwI;w v I?Huw MLHI;K wHtHIH;HsL AA9   ~DHcH$   H$   H+HH;r H$   HIGOA;   |IWHuIIO(H+HI_ HH+HH;s3HCIG    H;v I?H|$0H\$8IO IwHH+HuI"H;v HtI;?tq H+H(D$0f$   L$@  A   H$   IIwI;w v. I?Hu  MLHI;K wHtHIH;Hs
 AA9]D~AHcH$   H$   H+HH;r
 H$   HIMA;]D|$   uqH$   Ht L$   L$   L$   H$    H$   Ht L$   L$   L$   HL$p T      Ht
H$P  HIH$P  L$h  L$p  L$x  H
 8D$p  Ic      [ Ht
H$   HIH$   L$p  HH$   Fg	 f(IH$   HH$   H+HHt:H;r^ H$   4HH$   HH$   H+HH;rIH+HHt:H;r H$   <HH$   H$   H+HHH;rD$p  A   Hcع   V Ht
HL$@HIHD$@L$p  HHL$@Jk f(IHT$`HHL$XH+HHt4 H;re HL$X4HHT$`HHL$XH+HH;rIH+HHt1H;r% HL$X<HHD$`HL$XH+HHH;r d	    H\$`HL$XH+HCr  Hu
 HL$XD       A;   U  d	    HcH|$`HL$XH+H  G;  LcL;rb
 HL$XN$H$   H$   H+H   G;   HH;r 
 H$   HL$XA4$X4HcH\$`H+H|$C;}HH;r	 HL$X4   DBH$   H, H$  3   Hl H$  H$   H$  O H
Xy HL$ LDǋH
9 o   DBH$  o H/, H$  2   H H$  H$  N H$   H
 x HL$ LDËH
|9    DBH$   H+ H$  2   Hl H$  H$   H$  O H
Xx HL$ LDËH
8 oD$p  &b	 $   A   =l ffff     E;     a	 %   IcH\$`HLd$XI+H#  G;  LnL;r H\$`Ld$XO,AIcI+He  C;Z  HH;r Ld$XH$`  H  A   L	y HYAE A^f(\A\YH$   H$   H+H|fC;}_H~H;r H$   4`	 &   A   Lv HH$   DXD$p  L$`     DBH$   H) H$  
0   Hd H$  H$   H$  G H
Tv HL$ LDƋH
6 g   DBH$  g H') H$  /   H H$  H$  F H$   H
u HL$ LDǋH
t6    DBH$   H( H$  
/   Hd H$  H$   H$  G H
Pu HL$ LDƋH
5 g3A9   ~Mf     HcH$   H$   H+HH;r H$   HI7EA;   |A   ~Lfffff     HcHD$`HL$XH+HH;r HL$XHIDA   ;|H$p  ID@8$  
  HL$XHt Ht$XHt$`Ht$hHL$@ H$   Ht H$   H$   H$   H$    H$h  Htl H$h  H$p  H$x  H$P  G H$   Ht4 H$   H$   H$   H$    H$   Ht H$   H$   H$   HL$p   HL$XHt Ht$XHt$`Ht$hHL$@ H$   Ht H$   H$   H$   H$   u H$h  Htb H$h  H$p  H$x  H$P  = H$   Ht* H$   H$   H$   H$    H$   Ht H$   H$   H$   HL$p       DBH$    H@% H$  +   H H$  H$  _  H$   H
q HL$ LA   H
2 L$   A(sA({E(CE(KE(SIA_A^A]A\_^[HPWH  HǄ$   HXHhHp IHH    3Ht
HL$@HHHD$@Hl$XHl$`Hl$h   DBH$   ^ H$   HD$8D$0D$(HD$@HD$ L$  LHH.H$   H$   ( Hx H$    t7H$   H$    H$  LHAH$    H|$XHHL$`H;vo  HL$`H|$XHT$@HHT$pH\$xHH+HuH'H;v5  HT$@HtH;t   H+H(D$pfD$pL$  A   HT$pHL$@Ht$XH;t$`v H|$@Hu LLHI;K wHtHHH;Hs H$  HHT$@PH$    HL$XHt Hl$XHl$`Hl$hHL$@ L$  I[IkIs(I_HWH   HD$ HXHhHpIIH    3Ht
HL$PHHHD$PHl$hHl$pHl$xHl HL$( HT$(HL$P?HL$( HXl HL$( HT$(HL$P?HL$( LHT$PHASAEHT$PHHHHT$PPH\$hHt,H|$pH;t HG H(H;uH\$hH Hl$hHl$pHl$xHL$Pt L$   I[IkIs I_HHPVWATH   HǄ$   HXHhIIHH   4 E3Ht
HL$ HIHD$ Ld$8Ld$@Ld$HH,k H$   V H$   HL$ C>H$   T Hj H$    H$   HL$ >H$    LHT$ HAS    Ht
HL$PHIHD$PLd$hLd$pLd$xE3E3HT$PH[LLD$ HT$PHAS(HMHHT$ PH\$hHt,H|$pH;t H H(H;uH\$hH Ld$hLd$pLd$xHL$P H\$8Ht,H|$@H;t H7 H(H;uH\$8H} Ld$8Ld$@Ld$HHL$ d HB HHN L$   I[ Ik0IA\_^LL$ LD$VWATHpHD$(H$   ILHH\$     HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@HvH;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt
 Ht$XHt$`Ht$hHL$@ HH$   HpA\_^H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,CH;}8D$8f    HHH;Hf(Df^f)D|HL$ LLHH\$pHH@_^]H\$Hl$Ht$WATAUH I@ HMI+@IHHHH    HNq	 HHHAq	 H;2q	 rH
p	 輜HHHOHq	 HLHH
q	 H;p	 rH
p	 腜LLGLG HGHN E3H+NIHHHO(HF HoH+FHHt-H;r HFHHLHLHF H+FHH;rHV HOI$H+VHHHOHHH;tfL)HH;uH\$@Hl$HHt$PHH A]A\_H\$WH@HHHL$ HHBE3HAHBHAHBHAHHHzHHH+HLMM~AL\$0LL$( IIIM;fB(DHfBYDHHfBXDfB)D|HL$ LH\\HH\$PH@_H\$Ht$WH IHHMuhHQ(HHo	 HHHH7o	 H;(o	 rH
n	 貚H3HH9W(v,@ HHHHDH;W(rH\$0Ht$8H _L
H\$0Ht$8H _H\$Ht$WH IHHMuhHn	 HQ(HLHHn	 H;n	 rH
n	 L3LH9K(v,I+JHIIAH;K(rH\$0Ht$8H _L
H\$0Ht$8H _HUVWATAUAVAWH   HD$8HX)p)xD)@MLLHA H+AH  Ix   fWLH H
G	 fAn.$  H      H$  H#H;u*Hd HD$ L
8 MHƯ H
F	 j-E3MIL$HtPI$D  Icf/v
IL;r/H HD$(H HD$ MH~ H
OF	 :H=BF	 H$  L$(  ME M+EILD$0H$  H$(  HHDHD$0L;HBHLMHN HƊLMH H1AIE I+EHHuZ I}I$Mm L+I   L;LFIt$L;LFH Ht
HL$@HIHD$@$  L$  HHL$@It$   r Ht
HL$pHIHD$p$  L$  HHL$p]IM9|$   D D  Hc<HD$`HL$XH+HH;rl HL$XfA(^<H$   H$   H+HH;r2 H$   f( D HI;t$rIM   D  Hc<fEnEHD$`H+D$XHH;r A\HD$XY<YX5rS	 H$   H+$   HH;r H$   \4C	 YXHD$`H+D$XHH;re HI;YH$   Ht L$   L$   L$   HL$p HL$XHt L|$XL|$`L|$hHL$@h f(fWL$   I[HA(sA({E(CIA_A^A]A\_^]HATH   HD$ HXHhHpHx IHH    E3Ht
HL$PHIHD$PLd$hLd$pLd$xLOHD$0Ld$8(D$0fD$0LD$0HT$@HL$PRHT$hHuIHL$xH+HH\$pHH+HH;sHG HHCHD$p=H;v HD$PHD$0H\$8(D$0fD$0LO LD$0HT$@HL$PHHT$PHPLHT$PHAS0HMHHT$PPHL$hHt Ld$hLd$pLd$xHL$P L$   I[IkIs I{(IA\HWH  HD$PHXHp HH3LQM  L	E3HH      D  C$  H$  H#H;t,$  H$  H#H;wIHcI;|E     + Ht
HL$ H3HD$ HD$8    HD$@    HD$H    AEHT$ H   DBH$   w H?HcHL$@LD$8I+HgfffffffHHHH?HH;r LD$8HIH$   j HHX KHE HH' .H$   H$    HHL$X H HD$XHHL$p H/ HD$XHh HL$X L$  I[Is(I_HL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;vH    H HHuHtHHwI\$HHtH;tgHtH;tR̄tHH;t Ht
HHH/H_HHH+HLMM~I$f(Hf)HI;|LHIHH\$XHl$`H0A\_^HHXWH   )p)xD)@AD)HD)PD)XfD(EYDY D)`fD(fA(| D
 fE(L$   H$      f(fA(fA(EYY= 7`f(fD(fT
 f/
N vHE H
V 	fA(AY f(fA(Y-  YXf;vT%  ff(AYA\DXfnf(fA(fD(YA^^XYf;r(|$pL$   f(A(sE(CE(KI[E(SE([E(cI_HWATAUAVAWH   HǄ$   HXHhHp IILLIX    E3Ht
HL$pHIHD$pfW$   L$   HHL$pEIH9_~GfH/H$   H$   H+HH;r H$   HD HAHIcH;G|   ! Ht
HL$@HIHD$@L|$XL|$`L|$h    Ht
H$   HIH$   L$   L$   L$   H$@  HD$8$8  D$0$0  D$(HD$@HD$ L$   LD$pII%Hl$`H+l$XHH;ntLH Ht;HH;voH    H HuHtNHL>HnAIH~=fD  HD$`H+D$XHH;rW HHD$XHHHHcH;F|H$   Ht L$   L$   L$   H$   n HL$XHt^ L|$XL|$`L|$hHL$@E H$   Ht2 L$   L$   L$   HL$p L$   I[0Ik8IsHIA_A^A]A\_Ht$WLE3IsI{HP  H\$E3H   H_HtHBHtL@E3IK IA@IIYHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIIL;YDDL;}=HtHBHtL@E3IK IA@IIIL;Y|IL;H\$Ht$_H\$M;IML   HL MtIBHtH3HHHtHA3H	tL@E3HtHP3I@BYJ0HtH3CYI@IL;\CD|H\$HWATAUHPHD$ HXHhHp )p)xf(f(LLH- HHyH|$pHr3HuH9HH;vH    H HHuHt~HHwI\$HHtH;tSHtH;t>̄t4H;tp Ht
HHH/H_HHH+HLMM~#f     I$f(Hf)HI;|LHI訸A}Au IL\$PI[(Ik0Is8(t$@(|$0IA]A\_@VWATAUAVH0HD$ H\$hHl$pLLH+ HHyH|$`Hr3HuH9HH;v3H    Hq HHuHtHHwI^HHtH;tHtH;t̄tH;t Ht
H}HH/H_HHH+HLMM~%fff     IFf(Hf)HI;|LHIN7IFIEIF IE IH\$hHl$pH0A^A]A\_^HHHUVWATAUH`HD$ HX)pHHHPfWp3HuH6HH;vH,    H HuHtHH~IHt$I;t̄tȳtoH~HHH+HLMHM~"(
 ff     Hf)HI;|LHHL$(H|$0H|$8t$@HnH$   LLLLIHrHt,IHHH;t̄t̄tLLIHLMLMIHH+HLMM~(A HE f)HI;|HHL$(~(HH$   (t$PH`A]A\_^]HL$VWATAUAVH0HD$ H\$pHl$xMLHHj3HuH9HH;vH4    H- HHuHtHHoIt$IHtI;tHtI;t̄tH;t Ht
H8HHHwHHH+HLMHM~ I$f(Hf)HI;|LHIHwHt$hMMMEIIHpMMMEMtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHLNLNIHH+HLMM~IE f(Hf)HI;|HIID$G(MH0	 H߸MH0	 H荹HH\$pHl$xH0A^A]A\_^HL$UVWATAUH0HD$ H\$pLHHj3HuH9HH;vH4    H HHuHtHHoIt$IHtI;tYHtI;tD̄t:H;tv Ht
H
HHHwHHH+HLMHM~I$f(Hf)HI;|LHI贱HwHt$hML$ MD$IIHQnML$ MD$MtMtIHIL;tMt:MtIHIL;tcMtIHIL;tFIIHf
LNLNIHH+HLMM~"    ID$f(Hf)HI;|HIL$ȰAD$(G(HH\$pH0A]A\_^]HHHVWATAUAVH`HD$ HXHh )pHLHPfWp3IHuH,I;veH4    H HuHtDI$I\$IHt$I;t̄t̄tI\$HHH+HHHHH~( fI$f)HH;|LLIHL$([H\$0t$@It$H$   HuH,I;vL,    I HuMtmHH^Ht$I;tQ̄tḠt=H^H~$( ffff     Hf)HH;|LLHHL$(A\$ IL\$`I[@IkH(t$PIA^A]A\_^HHHVWATAUAVHPHD$ HXHh LHHr3IHuH/I;vH<    H HHuHt^HM HuI}IHtI;t3HtI;t̄tH;tP HtH	HE H] H}HHH+HLMHM~@ IE f(HE f)HI;|LHI臭I}H|$0fWD$@HuH$   HuH,I;vsL$    I HuMtRHH~Ht$I;t6̄t,̄t"H~HHH+HLMM~( Hf)HI;|LHHL$(IEE HL\$PI[@IkHIA^A]A\_^HL$UVWATAUAVAWH@HD$0H$   MLHHjH3HuH/H;v^H4    H HHuHt:HHoIuIHtI;tHtI;t̄tH;t- Ht
HHHHwHHH+HLMHM~ IE f(Hf)HI;|LHIhHoH$   MfMuH9HL;vYJ4    H HHuHt5HM LeIvHtI;tHtI;t̄tI;t1 HtHHE H] HuHHH+HLMHM~D  If(HE f)HI;|LHIhIMO HGHD$ L
K DH# H
(	 LI      H9_vbH@ Ic$   H$   I#I;wIL;Or/H5 HD$(H HD$ LHJ" H
'	 v}HMHtaHU Hc$   H$   I#I;w
HH;r2H HD$(H HD$ LLHJ H
1'	 }HH$   H@A_A^A]A\_^]HL$UVWATAUAVAWH0HD$ H$   LHHrH3HuH/H;vH    HO HHuHtHM HuI^IHtI;tHtI;t̄tH;t HtHZHE H} H]HHH+HLMHM~ If(HE f)HI;|LHIHuHt$xMfMuH9HL;vJ    HJ HHuHtHLfI^HtI;tHtI;t̄tI;t Ht
H`HH>H^HHH+HLMM~IFf(Hf)HI;|LHIN%AF E HH$   H0A_A^A]A\_^]@SHPHD$ HHL$(c L3HHB HL$( HT$(HHL$( HWB HL$( HT$(HHL$( HB HL$( HT$(HHL$( HA HL$( HT$(HHL$( HgA HL$(d HT$(HVHL$(j HGB HL$(8 HT$(H*HL$(> HB HL$( HT$(HHL$( HA HL$( HT$(HHL$( HP[@SH@L
E3MJL$0HILT$(HH+HLMM~,fI
Hf(HIfBXDM;fB)D|HL$ HwHH@[HL$WATAUH@HD$0H\$hHt$xHHٹ   语 HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;vHHKHCHC HvHHHK(Hw H9wv LgL;g v} 3D$(D$pD$ LKLCHIHC HH\$hHt$xH@A]A\_@SH HH  D$0    HHH [@SH HH@  D$0    HHH [H\$UVWH0Hq HH9qv H_H;_ v H9_wH;_ v H/H9wwH;w v HtH;/tz H;tsDL$PHW 3D$(D$PLHΈD$ !Hw HH;t?Ld$XHXE3HHt蘫 HKL#LcLc脫 H0HCH;uLd$XHo H\$`H0_^]HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ LdHHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYHdD IK HL$`6 Hv HD$`HT$8HL$x H HD$`H%G HL$`? HQ0D$( H$   HD$ LLYLHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ LԧHHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYHD@ IK HL$` HV HD$`HT$8HL$x H HD$`HC HL$` HQ0D$( H$   HD$ LLɦLHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ v` HHL$0H^HHE HHEHAH\$8H9_wH;_ v+ HHtH;t LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$h3Ho LH;t2HXHHt8 HKL+LkLk$ H0HCH;uLg Ld$hH\$pHl$xHH@A]_^D$HH)t$0f(m f/vLD$PH+< H
< f.z+u)   "   H[  fW (t$0HH)|$ f(X=D f.=< zuf((|$ (t$0HHf(躠 \= ^(|$ Y(t$0HHH\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,C胘H;}:D$Hfffff     HHH;f(DfYf)D|HT$ HL$0LL/H$   HHP_^]HL$WHPHD$ H\$hHt$xHH3t$pN HtHHHHsHs Hs(D$p   HHH=G HL$(. HT$(H HL$(4 HH\$hHt$xHP_@SH H蒧HH [a @SH`HHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HLHIHH+3HLMM~\LT$@L\$8H|$pH|$(f     IIHI;f(Df\DHf(LHfYHfXLf)L|H|$pHL$ H$!HH`[HHPUVWATAUHPHD$ HXH3퉬$   Mh@LhM`L`It$HuH9HH;vrH    H HHuHtNHHwI\$HHtH;t#HtH;t̄tH;t@ Ht
HHH/H_HHH+HLMM~,f     I$IE f(fYHf)HI;|LHHL$(HH$   HPA]A\_^]HL$ATAUAVH@HD$0H\$hHt$pH|$xMHH3HAHA HA(HtaHUUUUUUUH;vyHHHCHC L$MJHK(3D$(D$`D$ LKMHHT-JHC H\$hHt$pH|$xH@A^A]A\HL$SUWAUAVH0A   LH  AM  A
e  E3AADEDE+t3AAAAD+u	AD+AHp     HiM  HHH+HHHHiH+A;u3IչN  o3ɍPSDǤH0A^A]_][3Ht$hM  Ld$(E3L|$ DAD|$pM  Ip     E   uD+;sD3D3U  uA`A;uW3҃=r!˸   +i+(ƋHIHHH+HHHHiH+ȋыuAAv+;s<U  A;uAU3҃=r#Ëظ   +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ   +i+,Ӌ蛢D؅t+D;sDE;U  AIqD|$pH|$`tV3Ҹ=r)D   DAAA+iD+֋=sDpDV  Ht$hEtA	D3AAD_L|$ Ld$(H0A^A]_][HL$SUWAUAVH0A   LH'  A  A>  E3AADEDE+t3AAAAD+u	AD+AH   Hi  HHH+HHHHiH+A;u3Iչ  ?3ɍP#D藣H0A^A]_][3Ht$h  Ld$(E3L|$ DAD|$pM  I   E   uD+;sD3D3  uA`A;uW3҃=r!˸  +i+(ƋHIHHH+HHHHiH+ȋы豢uAAv+;s<  A;uAU3҃=r#Ëظ  +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ  +i+,ӋkD؅t+D;sDE;  AIqD|$pH|$`tV3Ҹ=r)D  DAAA+iD+֋=sDpD  Ht$hEtA9D3A輠AD/L|$ Ld$(H0A^A]_][H\$Hl$WH HZHyHHHtH;tطHtH;t÷̄t蹷Ht$03H;_tH Ht
HeHH7HH_HH+HLMM~ HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _HWATAUAVAWH   HǄ$   HXHhHp )p)xD)@IHHHY    豔 E3Ht
H$   HIH$   fEWD$P  L$P  HH$   Lt$pLt$xHt$HH^HHtH;thHtH;tS̄tIH;]t!HM  HtHHE Lu H]HHH+HLMIM~2(
ͯ fffff     Hf(fWHE f)HI;|LHHL$@"H|$pIH\$xH$   H9$   vݶ H$   HD$0Ht$8(|$0)|$0L|$0Ld$8    H  uIHGH;  (D$pf$   HuHwH$   H$   H;0uHpf$   HuHGH$   H$   H;uHALpfD$`HuHGHD$hHL$`H;uHAHHD$HHl$PLmMufA(H$P  HL$@pf(YvHl$ H$P  HD$(Lt$Ht$PIHH+HLM3M~9ffD  If(HE f(fYf\f)HI;|MHT$ HL$@f$   MuC E3MME3M;cw) It$H$   Hu MLI;s r 6HuH_H;uH_H(H\$xMuӴ MMM;cw LHt$8(|$0HW0HH  uIH_H$   HH;$   vv H$   H$   HD$ Ht$((D$ fD$ HI  Hl$`H$P  HD$hLd$ Ht$(ffff     HCLkHD$HHl$PH} ufA(H$P  HL$@~f(Y3Mu۳ MM$I;s rƳ \Ll$HL$PLMIHH+HLMIM~>fff     IE f(fYHE f(fXf)HI;|HT$`HL$@H(H;_uHH;_IDMu) MM$I;s r HHH$   Hta L$   L$   L$   H$   < L$   I[8Ik@IsHA(sA({E(CIA_A^A]A\_D$SH`
 )t$P)|$@f/= HD)D$0D)L$ fEWf(fE(   f(\f(L$pf( f(\f/
 v
fA(\XfA.z%u#\LD$pHi$ H
V |$pDu AYf(͍ D^fA.zuLD$pH%$ H
nV Af/5p rf(Hmtp f/v*ff     fA(f(\Xf/^DXwf/v*ff     f(fA(^Xf/\DXwf(Ho(t$P(|$@D(L$ DXfA(D(D$0H`[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
!	 H LHxU L
a HD$ VfAn D$XHD$XH#H;u'H
	 HL L
% H>U HD$ \A9 *H
	 H L
 H)U LHD$ ,H$(	 H
(	 Ht$PHHH
(	 H;r"H
'	    SH
'	 HH'	 LHH'	 H;rH
Y'	    OSLHIPHIL;t3     HHH;ufn HLD$ LIP^fnE \A YYf(Y\Y
 	 A A   X
T XHt$PH\$`IH0A\_]LD$SWATAVHxHB MIH+BHLHN  H
B 	 )t$PfWLHT )|$@f(	H      fn+$   H$   H#H;u*H
 HX L
1 HS LHD$ eA$f/w*H
 H
 L
 HS MHD$ $   H$   H#H;u*H
v H L
 HqS MHD$ LLO H
H H$   L+OHt$pHxS LILl$hL|$`CHG H+GHHu{ HG H_   LL+IL;LFH
n%	 H+HHD$0L,    H[%	 H$   IHI%	 H;r%H
$	 IPH
&%	 H$   H%	 HIH%	 H;rH
$	 IPHHO E3H+OIHHtBL$   H;r L$   HGHHLILHO H+OHH;rE3L$   Ht$pIL- Ll$hHH;t LHH;u IA^$M   %r L$   ff     fAn HcHP\f(f.f(fTY\XzuAf/v   D fnHY\D I;rLD$0f(IHl$ TL|$`(t$P(|$@H$   IHxA^A\_[fWSIHxA^A\_[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
 H LHP L
 HD$ PfAn D$XHD$XH#H;u'H
S H L
 HP HD$ Af/ֲ w*H
 H^ L
O HP LHD$ H{"	 H
l"	 Ht$PHHHa"	 H;r"H
!	    MH
<"	 HH:"	 LHH,"	 H;rH
!	    MLHIPHIL;t3HHH;ufnE  HLD$ LI^P\A YYf(Y\Y
 A A   X
 nRHt$PH\$`IH0A\_]HHHUVWATAUAVAWH   HD$@HX)p)xD)@MMHHHB H+BH  Iy   fWLHTO H
 fAn.$   H      H$   H#H;u*H HD$ L
q MHO H
0 E3MIL$HtKI$Icf/v
IL;r/H/ HD$(H HD$ MHN H
 xOH= H$   Ll$0LF L+FILD$8H$   HD$0HHDHD$8L;HBHLLHN H
>LMHeN HuHF H+FHHD$8H<    H	 LHH	 H
	 H;r HH
"	 KLH	 H
t	 HHHo	 H;rHH
	 JHIHN H+NHHt/@ H;r HFHIHHN H+NHH;rH/HH;tf     L(HH;uHF H+FHHu H~I$Ln L+I   L;LFIt$L;LFH Ht
HL$HH3HD$H$   L$   HHL$H3I9t$vMD  Hc4HD$hHL$`H+HH;r HL$`fA(^HI;t$r3HM   HcHpfEnEHL$hHHT$`H+HH;r HL$hHT$`A\Y4f(Y7 YXH+HH;r} HT$`Y4D \D HI;g3Hl$ MLD$8f(H$   H4NHL$`Ht萁 Ht$`Ht$hHt$pHL$Hw HfW}MHL$   I[PA(sA({E(CIA_A^A]A\_^]@UAUAVAWH   HB MIH+BLLH  I@ I+@H  H
> LHlK )$   fWzH
 H]K LMACf/w*H
 H L
	 HBK MHD$ JLE IU H$   L+EI+UH$   IHH$   H= L$   HT$@L$   HL$@E3)$   I;H$   Ld$HHCHJ MHHL9HJ LLH9L$   H$   L\$0HD$(H$   HL$PMLIHD$ թIE I+EHHu. HE I}H+EHHu Iu HM H]I+uHH+HHH;w
HH+H=    H;HFI@^~ f(HtyHT$xLD$pffffff     H Ic\IHf(\HYf(YYYXf(\YAXAXL;rHD$`LL$XLD$Pf(IHD$ KL$   H$   ($   ($   H$   H$   IHĸ   A_A^A]]fWTJIHĸ   A_A^A]]LL$ LD$VWATHpHD$(H$   ILHH\$    ~ HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@H}H;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt
} Ht$XHt$`Ht$hHL$@| HH$   HpA\_^@WHH$H\$ HH;   MH LR f     H0I0I0I0L;tcMHI LII;tHIHIMZIYI;tHIHIM;tI	III
MZIYI;tHIHIH;uIIH\$ H_HHHWATAUAVAWHp  HǄ$  HXHp)p)xD)@D)HD)PD)xD)hD)XIHLHn 8fEWfE(   { HtH$  HE3E3IH$  L$  L$  L$  H$X  H$`  L$h  L$p  H$X  VfD($  H$X  ;fD($     #{ Ht
H$   HIH$   L$   L$   L$   Mc   IH$   w?M^  H$X  $   H$   HuIH$   H+HH$   HH+HH;sHAH$      HH;v͝ H$   H$   H$   HHT$0H|$8HH+HuI*H;v H$   HtH;tr H+H(D$0fD$PL$   A   HT$PH$   H$   H;$   v( H$   Hu MLHI;K wHtHIH;Hs IH$X  cH D fAWfD.ztfD(EXtx AX$      y Ht
H$   HIH$   L$  L$  L$   McnDIH$   q=Mf       H$X  賺D$PH$  HuIH$   H+HH$  HH+HH;sHAH$     HH;v H$  H$  H$   HHT$0H|$8HH+HuI*H;v H$   HtH;tg H+H(D$0f$  LL$PA   H$  H$   }H$  H;$  v H$   Hu MLHI;K wHtHIH;Hsܚ IIc      Qw Ht
H$(  HIH$(  DD$PLD$PHH$(  8IH$H  HH$@  H+HHt?D  H;rU H$@  <HH$H  HH$@  H+HH;rIH+HHtA    H;r H$@  <HH$H  H$@  H+HHH;rA   Hcع   Pv Ht
HL$`HIHD$`DD$PLD$PHHL$`@IH$   HHL$xH+HHt4H;re HL$x<HH$   HHL$xH+HH;rIH+HHt4H;r" HL$x<HH$   HL$xH+HHH;r    H$   HL$xH+HC  HuĘ HL$xD!   D  A;   m      HcH$   HL$xH+H  G;  LkL;r_ HL$xN,H$   H$   H+H   G;   HH;r H$   HL$xAu X4HcH$   H+H|$C;}HH;rח HL$x4   DBH$   H H$      Hf H$   H$  ȕ H$   I H
R HL$ LDǋH
 i   DBH$  i H) H$      H H$X  H$  H L$`  H$x  LC$`  H HD$ DËH
m    DBH$   H H$      H] H$   H$   L$   H$   LC$   H
= HL$ DËH
 W $   A   D] E;   m   %   IcH$   HLl$xI+H  F;  LsL;rɕ H$   Ll$xOt AIcI+H  G;  HH;r Ll$xH$  H  A   L HOWAA^D fA(\A\YH$H  H$@  H+H   G;   HsH;r H$@  4 &   H$H  H+$@  H|0G;})HH;r H$@  DXL$     DBH$  Ē H H$      HA H$   H$   H$   $ H
1 HL$ LDËH
 D   DBH$  D H H$   g   H H$   H$  # H$    H
 HL$ LDËH
Q    DBH$  đ H H$      HA H$   H$   H$   $ H
- HL$ LDƋH
 D   DBH$  D H H$   g   H H$X  H$  # H$X   H
 HL$ LDËH
Q AA    ~3fD  HcH$H  H+$@  HH;rn A;   |AA   ~1 HcH$   H+D$xHH;r1 A   ;|Ic^@   n Ht
H$   HIH$   DD$PLD$PHH$   苟M    H$   HH$   H+HL;sB<II H+HH;s<HH$   H$   \ .   D$P   Dd$@Dd$0HHD$0H#H      H;v.H HD$ L
  L$  HI H
 DD$0HD$0H#H;u+H HD$ L
 LD$@HI H
 H$  Ht$@H\$PfA(fA(MIsfnfA(^ql f(II7 %w     Hs9fn\Yf(AXfD(D\YYDXHDD$0HT$0H$  X /   D$P   Dd$@LD$PHT$@H$  *D$0HT$0H$   0   Dd$PM  HT$PH$   *D$0HT$0H$  t 1    D$0Dd$PLD$0HT$PH$   D$0HT$0H$  ( 2   Dd$PMp  HT$PH$   D$0HT$0H$  F   D$      A;~@3   6   HcINxA   L0 HPLA   L HI   QH$   HfD(INHA   L HcPLA   L HI   4QH$(  Hf(I@  A   L HQH$   Hf(AXAE \EXAYfAWi AXA7^XA   L& HH$   O0 8   I   L$   H$   }D$0HT$0H$  H$   Hti L$   L$   L$   H$   i Dl$0HT$0H$  cH$  f(HL$xHtoi Ld$xL$   L$   HL$`Pi H$@  Ht=i L$@  L$H  L$P  H$(  i H$  Hti L$  L$  L$   H$   h H$   Hth L$   L$   L$   H$   h H$  Hth L$  L$  L$  H$  ph f(      DBH$   Hܮ H$   ?   H H$   H$   L$   H$   LC$   H
y HL$ A   H
 L$p  I[8Is@A(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_HL$VWATH0HD$ H\$XHl$`MIHHMHH&f(H1Hr HLc(3LL$pMueJ    H	 HHH	 H;	 rH
C	 >.HHKHH9S(v7H+fff     HHHHH;S(rHSMILH藓LL$xMumHS(HHN	 LHHA	 H;2	 rH
	 -LLC H9{(v*fffffff     HK HD HHH;{(rHHHS MI LHmHH\$XHl$`H0A\_^LI E3L9A(v* KHAIBDYAXBBL;A(rHHԎ 3LL$XLD$`3)t$0)|$ D$XD$`95g = fTf/vH H
W ҃) 3LL$XLD$`3҈D$XD$`~9fTf/vH H
 葃 3LL$XLD$`3҈D$XD$`=9fTf/vHd H
 P 3LL$XLD$`3҈D$XD$`8fTf/vH# H
 N 3LL$XLD$`3҈D$XD$`8fTf/vH H
S ΂ 3LL$XLD$`3҈D$XD$`z8fTf/vH H
 荂(t$0(|$ HHH\$Hl$WH HZHHHHtH;t)HtH;t̄t
Ht$03H;_tH; Ht
H趶HH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHHvZHt$0H\$8Hl$@HH _H(Y$ 3LL$0LD$83҈D$0D$8)7f(fT
 f/
u vHD H
 0Y H(H(YĚ 3LL$0LD$8D$0D$86f(fT
] f/
 vH H
u ЀY H(HATAUAVH`HD$ HXHhHpHx LHٹ   Jb E3Ht
HL$(HIHD$(Ll$@Ll$HLl$PE3E3HT$(HTHL$(QIH|$HHH\$@H+IgfffffffIHHHH?H   IH;r/ H\$@H+I$IPt2HH(H|$HHH\$@H+IHHHH?HH;rRH\$@Ht+H|$HH;tfH׃ H(H;uH\$@Ha Ll$@Ll$HLl$PHL$(a 2DHt$H;tH H(H;uH\$@H` Ll$@Ll$HLl$PHL$(` L\$`I[ Ik(Is0I{8IA^A]A\H\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$GI;       HtHCHtL@E3ItIP3H	tHB3H@HfHtHB3H@Hff\MtIE3A@(HE HI;ffYf)ToLMHHH\$@Hl$XH A\_^H;  WATAUAVAWH@HD$ H\$pHl$xH$   HLLi3MuH9HL;v%J<    Hc HHuHtHt$(Ll$0I|$IHtI;tӀHtI;t辀̄t贀I;t(H HtHhHHD$(HH\$(H|$0HHH+HLMHM~     I$f(f)HI;|LMHT$(IULuMtM;tMtM;t̄tM;t$t!I$4 MtI诰I$I$Mt$IHH+HLMHM~"    HE f(I$f)HI;|MIHgTHt$I;ts̄ti̄t_H;}t!HM  HtHHE H] H}M~f(HE f)HI;|LMHHL$(SHB H\$pHl$xH$   H@A_A^A]A\_H\$Hl$WATAUH HZLLHHtH;t~HtH;t~̄tv~Ht$@3I;\$t$IL$ HtHID$It$HI\$HH+HLMM~'     IEMT$HI;f(DfA)D|IT$IMLRM]Ht$@H\$HHl$PM\$IE ID$ IH A]A\_@SH HH      D$0HD$0H#H;uH H
p L@|f/ rZ oZ f/ f(w f/w
,H [Hl H
 L{HHHVWATAUAVH  HǄ$   HXHhIILL   Z E3Ht
HL$@HIHD$@Lt$XLt$`Lt$hLNHD$pLt$x(D$pf$   L$   H$   HL$@HT$XHuIHL$hH+HH\$`HH+HH;sHF HHCHD$`FH;vu} HD$@HD$pH\$x(D$pf$   LN L$   H$   HL$@ZHE HT$@HPLt$pLt$x   DBH$   B{ LFH$   HD$0D$(D$ LL$pIH$   iH$   H$   { Hx H$   { t3H$   H$   z IMLHAH$   { E3Lt$xMj  Hl$pHL$`H\$XfD  Hu3HT$hH+HHH+HH;sHE HHHL$`H\$X  HH;v| HL$`H\$XHt$@H$   H$   HH+Hu3$H;v{ HtH;t$@t{ H+H($   f$   LA   H$   HL$@^H\$XLHL$`H;vk{ HL$`H\$XHt$@HuQ{ E3HL$`H\$XHD$@LII;S wHtH3H;Ps{ HL$`H\$XAHIcI;H$   H	HHT$@PH$   .y HL$pz HL$XHt&W E3Lt$XLt$`Lt$hHL$@
W L$  I[8Ik@IA^A]A\_^HL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;vxH    H4z HHuHtxHHwI\$HHtH;txHtH;tx̄txH;ty Ht
H?HH/H_HHH+HLMM~I$f(Hf)HI;|LHIMIT$HOHH\$XHl$`H0A\_^H   HLD$(I HAI@HAI@HAI@HA HL$PI@ HHHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@H|$X ufWHĨ   H$   HL$ 
HĨ   HHXWH   )p)xD)@Af(f(f   fD)HD)PD)XDu fD(fD(DYDYD)`fDW
Ӊ E^fD(f(YY S Y=l 3L$   L$   3fD(f(DYƈ$   $   DYk N(f(fT
y f/
 vHi H
 UrY, A^f(X5 f;v5fD  ffnYfA(EY\AYXf;rDY fA(R (|$pL$   I[E(CE(KY YE(SE([E(cA(sI_LH   E)K3fD(Y2 E)SE)[MKMCACACfD(,'f(fD(fT
x f/
s vHB H
 .q)t$p5  )|$`D)D$PDYDw~ fA(A\EXfA(f(Q E\fD(EYDYfWf.zt5AYAYY=؇ ^f(Q AYY~ \DX(|$`(t$pD(L$@fA(D(D$PD(T$0D(\$ HĈ   H\$H|$Lٍ   A   AHp     H   AEAAAHHiN  HHH+HHHHiH+HAEKMi  IIH+HHHHiL+EKD;sA+	A+ɁAEtAH;wH\$H|$A#H\$Hl$WH H*HHH]HtH;tIsHtH;t4s̄t*sHt$03H;_tH[t Ht
H֣HH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHHGHt$0H\$8Hl$@HH _% f(LIp     I   \f     EIMiN  IIH+HHHHiL+IEAIHi  HHH+HHHHiH+AIA;sD+
D+AfAHH*^YXf/mH\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$GCI;       HtHCHtL@E3ItIP3H	tHB3H@HfHtH3JffYMtIE3AH HE HI;ffYf)TkLMHHH\$@Hl$XH A\_^BHH   )p)xD)@f(f(D)HD)PD)XD
y fD(fE(DYD)`D)l$ fD(fD(DYf(E^YY L Y= 3L$   L$   3fD(f(DYƈ$   $   DY p!f(fT
s f/
 vH H
 wkYN v HO    A^f(Y59 X5x AYHHDXA\EYAYf(YXuDY%( fA( L D(l$ L$   A({E(CE(KY YA(sE(SE([E(cIH\$UVWHPHBBJ HD$0HHD$8L$@HHxH|$ptH#HHD$pHL$xHڃH;HT$xHMHHHL$ LH+E3HH+HHH,C1BH;}XD$8HT$0D$@ff HHH;fDHfYHfYfXDf)D|HL$ LLHAH$   HHP_^]@UATAUH`Hl$PLaH]0HID$Hu8HH}@L)u A0H;v9mI$HuLH<    H      H   HHH;w
HHHS H+HL$PHHID$HSLt$@3HD$8   LI94$HDHH=   IE HD$0HD$(   HL$ HK@@t	Hm H]0Hu8H}@(u HeA]A\]Hm HHmHdBl@UH`Hl$PH] HYHu(HCH}0H9Le8L)u qHAY0H;vkHHuLH4    H      H   HHH;w
HHHQ H+HL$PHHHCHWLt$@3HD$8   LH93HDHH=   I$H HD$0HD$(   HL$ HOt	Hl H] Hu(H}0(u Le8He]Hjl HHnHe kHM;ML   HH$H MtIBHtHH3HtHA3HatL@E3HtHP3I@BYJpHtHA3H	tHP3HtHH3HBIM;BDYAPXBXDBD\H$HATHPHLLL MAvHPA\麂Hl$@HhH|$0Ll$(Lt$ LpH@ Hl$xHl$`HH3H+LIAMtH$IHD$`HL$pIAI;LD$pHMH8E3M;  H\$HHt$8    L3L+ILH   M$HwMtIAHtHX3IH I CIHYMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHHH;YDD!H;}AI$MtIAHtL@E3HK HA@IHHH;Y|I;H}ZfMtIAHtHH3II$IL@ HHH fHMf(LHI;fYfB)|L;}?M$MtIAHtHP3IH I BIIIL;Y|J/HL$xHH3H+HT$`H;HD$`HMIM;H9Ht$8H\$HLl$(H|$0Hl$@Lt$ HPA\@SH HID$8    HtHH [HL$UVWATAUHPHD$ H$   LHHj3HuH9HH;vfH4    Hg HHuHtfHHoIt$IHtI;tVfHtI;tAf̄t7fH;tsg Ht
HHHHwHHH+HLMM~I$f(Hf)HI;|LHI:I\$H\$0H\$8HwH$   HHLLHH@HtWHtIHHH;t~eHtIHHH;taeHtIHHH;tDeLLHHbHT$(H5ID$G(HH$   HPA]A\_^]H\$Hl$WH HLH< H?H]HHtH;tdHtH;td̄tdHt$03H;_tHe Ht
HGHH7HH_HH+HLMM~!D  HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _8H\$WH HLHY Hq?LGLOHMt\MtHHIL;tcMt:Mt5HHIL;tcMtHHIL;tcIHKI螔LK E3LKIHH+HLMM~*ffff     HHKIM;fB(DfB)D|HSHH\$0H _7Hl$Ht$WHPHcq()t$@fWHHt$8Ht$(Ht$H;tb̄tb̄tbH\$`3H;qtH	c Ht
HPHHHHwHHH+HLMM~(] @ HHI;f)D|HL$ LHILcG(t$8LD$(LD$0MtWMtHHIL;taMtHHIL;taMtHHIL;taIHOMIےLO LOIHH+HLMM~(E\ D  HGHI;f)D|HWHL$ HH\$`Hl$h(t$@Ht$pHP_Hl$Ht$H|$ ATH0B(DA(HH
 HL
@ H! D$ 耏H}IHtI;t`HtI;t`̄t`H\$@3H;~tHa Ht
HkHHHH~HH+HHLMM~"fD  HE HHI;f(Df)D|LHH&5LELM MtMtIHIL;t`Mt:MtIHIL;t_MtIHIL;t_IHNILN LNIHH+HLMM~,ffffff     HELVHI;f(DfA)D|HVHMU4H\$@Hl$HH|$XHHt$PH0A\H\$Ht$WH@B(DA(HH
 HL
V H7 D$ 薍LOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0H5LO L_MKHD$PL\$0HD$8IHNHH+HLMM~-ffff     HIHI;f(DfXDf)D|HT$05H\$XHt$`HH@_H\$Ht$ WH@B(DA(HH
 HL
6 H D$ vHD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$PiHNHD$XHD$0HL$XLIHD$PL_LIHD$8IL\$PHH+HLMM~,@ HIHI;f(Df^Df)D}HL$XHT$0HL$PH\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ LO L_t$0MKIL\$`HL\$(H+HLMM~.ffD  IHI;f(DfXf)D|HT$`HL$ H\$hH(t$@HP_H\$Hl$Ht$ WH0A LBHH
; HL
9 H D$ 1H]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t59[H
 HR H HD$(H/z LHD$ HtH;tZH;^tH-\ Ht
H訋HH>HH^HH+HLMM~"fD  HE HHI;f(Df)D|LHHH\$HHl$PHt$XH0_R/H\$Hl$Ht$ WH0A LBHH
ӭ HL
ɧ H D$ H]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t5YH
I H H HD$(Hx LHD$ *HtH;tYH;^t!HNZ HtH7HFH~HH^HH+HLMM~  HE HNHI;f(Df)D|HVLHH\$HHl$PHt$XH0_-Hl$Ht$WHPHcq )t$@fWHHt$8Ht$(Ht$H;tX̄tX̄tXH\$`3H;qtH	Y Ht
HPHHHHwHHH+HLMM~(S @ HHI;f)D|HL$ LH?Hcw t$8Ht$(Ht$H;tX̄tX̄tWH;wt!HO.Y HtH詈HGH_HHwHH+HLMM~(nR HGHI;f)D|HWHL$ L*?H\$`Hl$h(t$@Ht$pHP_Hl$WATAUH0B DA HH
 LL
w HX D$ 跅I|$IHtI;tWHtI;tV̄tVH\$P3Ht$XH;}t!HM  X HtH蛇HE H] HH}HH+HHLMM~!@ I$HM HI;f(Df)D|LHIU+It$HtI;t\VHtI;tGV̄t=VH;ut!HMtW HtHHEH]HHuHH+HLMM~*fff     ID$LUHI;f(DfA)D|HUIL$L*H\$PHt$XHHl$`H0A]A\_H\$Ht$WH@B DA HH
 HL
 H D$ LOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0H+LOL_HD$PL\$0HNHD$8IHH+HLMM~"HIHI;f(DfXDf)D|HT$0u+H\$XHt$`HH@_H\$Ht$ WH@B DA HH
 HL
 Hw D$ ւHD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$PɗHNHD$XHD$0HD$PHL$XLIHD$8L_IL\$PHH+HLMM~1f     HIHI;f(Df^Df)D}HL$XHT$0HL$PIH\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ uLOL_t$0IL\$`L\$(HH+HLMM~3ffff     IHI;f(DfXf)D|HT$`HL$ H\$hH(t$@HP_HL$WATAUH@HD$0H\$hHt$xHHٹ   / HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;vYHHKzHCHC HvHHHK(Hw H9wvR LgL;g vR 3D$(D$pD$ LKLCHIKHC HH\$hHt$xH@A]A\_Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?Lu:HH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ MmLG HH,HN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ lLG HV 3LOHˈD$(D$@D$ dpHG HMtMIH5+HO8- HN IH+NHHHHH?H8tLOLF HVHp.HG HmHHt$XH0_H\$Ht$WH HY0HHR0HRLHWHCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _H\$Hl$Ht$H|$ ATHPHA0IIH(I LHHtH;t`O H9kujHHn0HtH;tCO H9ouMHV0HHR+L^0M[HF0HF8    H HF0H@HF0HHI$IL$   fD  HHtH;tN HGH9CHt7HL$ HHCHAHsLD$0HT$@(l$ fl$0HK$HL$0HHCHAHD$8HL$ HD$(HHD$ HI$HAID$H\$`Hl$hHt$pH|$xIHPA\H\$Ht$WH HY0HHR0HRLHGHCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _LSHPHHA0MKICH IS(D$ fD$ ISICMC(L$0fL$0ISHHK0) E3L[0L[8HP[H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIHpK tHH[    tIM HHL$0HD$8@tTIE0HHtH;tjL H;u)AHT$0LILd$ }EHH@HM :HL$0SHD$8HHIJ tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIHPJ tHH[    tIM HHL$0HD$8@tTIE0HHtH;tJK H;u)AHT$0LILd$ EHH@HM :HL$0RHD$8HHII tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$WH@)t$02)|$ 9HHf/vH\f/5R f(v!fW>\ K& HT$PXXW2& HT$PքXB\f/=R f(vfW[ & HT$P规X% HT$P蒄XH\$X(t$0(|$ H@_@SH   MH$   L$   )t$pf(IHLHT$@HD$ AR0LK Ht$`LH$   H\$0HD$8IL\$XHH+3HLMM~=f     IHf(HI;fYDf(Lf\f)L|HT$0HL$PhHL$@%I (t$pHĀ   [H\$UVWH0Hq HH9qvH H_H;_ vH H9_wH;_ vH H/H9wwH;w vH HtH;/tH H;tsDL$PHW 3D$(D$PLHΈD$ qHw HH;t?Ld$XHXE3HHt$ HKL#LcLc$ H0HCH;uLd$XHo H\$`H0_^]H\$
CP LH   Ip     ffff     MIEMiN  IIH+HHHHiL+HEAHHi  HHH+HHHHiH+AHA;sD+
D+AfAIH*AYBf/pH\$HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HHHSPH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKPHHf(X$   HH$   H#H      H;vHD (f($  \f/   vƃ   \$   H$   H$  HHf/5DN vH$   X&N  f(! H$  X  H;t/HVHOZL^(L_(HVHOYHV0HO0YL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;tCHHtH;tqC̄tgCH;]t!HM D HtHtHE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$   1D HuHtHH;tBHHtH;tB̄tBH$  H;stHC Ht
HIsHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHH$      I  HY(HrH$   H$   H\A  5T fW$   H$  H[H$   fW$   HzrLH$   H$   HHt$H;tyĀtoĀteAH$   HHH+HLM3HM~*(; ff     fA)HI;}
L$   LH$   H$   (F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   A H$   ~A 2i  HSH$   >H?  fW$   H$  HXH$   $   A   LHHL$pHt.HH;t?̄t?̄t?H;\$xt$HL$p@ HtHOpHD$pH|$pH\$xHHH+HLMHM~(: HD$pf)HI;|LHT$pH$   &H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$p? H$   ? H$  ? H$   ? H$   ? H$   ? 2v  H$   H$   f($   H$   H$  H$   f/vH$   HϽ4\ f(H$  Hhf/vH$   H虽H$   H$   HD$pH$   A   HT$xLH$   H\$xHtHH;tM=HHtH;t.=̄t$=H;$   t-H$   S> HtHmH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   虋H$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   e= HL$pY= H$   J= H$  <= H$   .= H$   = H$   = L$  I[8A(sA({E(CE(KI_^]@SH H      Hf.D H   zt9Hx
D YlN \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HXHS`H$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HK`HHf(X$   HH$   H#H      H;vH9 (f($  \f/   vƃ   \$   H$   H$  Hhf/5dC vH$   XFC  f( H$  X  H;t/HVHO%OL^(L_(HVHOOHV0HO0OL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;t8HHtH;t8̄t8H;]t!HM 9 HtH9iHE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$   Q9 HuHtHH;t7HHtH;t7̄t7H$  H;stH8 Ht
HihHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHH&H$      I  HY(HgH$   H$   H|6  5 J fW$   H$  H[H$   fW$   HgLH$   H$   HHt$H;t6̄t6̄t6H$   HHH+HLM3HM~*(1 ff     fA)HI;}
L$   LH$   H$   F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   6 H$   6 2i  HSH$   ^
H4  fW$   H$  HXH$   $   A   LHHL$pHt.HH;t4̄t4̄t4H;\$xt$HL$p5 HtHoeHD$pH|$pH\$xHHH+HLMHM~(./ HD$pf)HI;|LHT$pH$   H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$p4 H$   4 H$  4 H$   4 H$   4 H$   4 2v  H$   H$   f($   H$   H$  H$   f/vH$   H4\ f(H$  Hxf/vH$   H蹲H$   H$   HD$pH$   A   HT$xLH$   H\$xHtHH;tm2HHtH;tN2̄tD2H;$   t-H$   s3 HtHbH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   蹀H$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   2 HL$py2 H$   j2 H$  \2 H$   N2 H$   ?2 H$   02 L$  I[8A(sA({E(CE(KI_^]@SH H      Hf.: H   zt9H
9 YC \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  H`HShH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKhHHf(X$   HH$   H#H      H;vH. (f($  \f/   vƃ   \$   H$   H$  Hf/58 vH$   Xf8  f( H$  X  H;t/HVHOEDL^(L_(HVHO0DHV0HO0#DL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;t-HHtH;t-̄t-H;]t!HM . HtHY^HE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$   q. HuHtHH;t-HHtH;t,̄t,H$  H;stH. Ht
H]HH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHFH$      I  HY(H]H$   H$   H+  5 ? fW$   H$  H[H$   fW$   H\LH$   H$   HHt$H;t+̄t+̄t+H$   HHH+HLM3HM~*(:& ff     fA)HI;}
L$   LH$   H$   F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   + H$   + 2i  HSH$   ~H)  fW$   H$  HXH$   $   A   LHHL$p2Ht.HH;t)̄t)̄t)H;\$xt$HL$p+ HtHZHD$pH|$pH\$xHHH+HLMHM~(N$ HD$pf)HI;|LHT$pH$   H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$p* H$   * H$  ) H$   ) H$   ) H$   ) 2v  H$   H$   f($   H$   H$  H$   f/vH$   H4\& f(H$  H/f/vH$   H٧H$   H$   HD$pH$   A   HT$xLH$   ѹH\$xHtHH;t'HHtH;tn'̄td'H;$   t-H$   ( HtHXH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   uH$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   ' HL$p' H$   ' H$  |' H$   n' H$   _' H$   P' L$  I[8A(sA({E(CE(KI_^]HHHWATAUAVAWH   HǄ$   HXHhHp )pMLHٹ   Z Ht
HL$ H3HD$ HD$8    HD$@    HD$H    IVHL$ E3M9nt  E3HL$@H\$8II,Hu3HT$HH+HHH+HH;sHE HHHL$@H\$8  HH;v& HL$@H\$8Ht$ H$   H$   HH+Hu3$H;v% HtH;t$ t% H+H($   f$   LA   H$   HL$ ,H\$8HHL$@H;v% HL$@H\$8Ht$ Huj% E3HL$@H\$8HD$ LHT I;S wHtH3H;Ps0% HL$@H\$8AIIcI;FH$       Ht
HL$PH3HD$PHD$h    HD$p    HD$x    MLD$PHT$ H
f(HL$hHt HD$h    HD$p    HD$x    HL$P  HL$8Ht  HD$8    HD$@    HD$H    HL$   f(L$   I[8Ik@IsHA(sIA_A^A]A\_LVWATHPHD$@I[IkIHLI@ I+@HLJ L+JIICHj ICHU ISLj H
j Lϛ II0L L; r0   H
< 7HHt$pHt^H_ H+_HHE H+EHHuW# HmHG H+GHHu<# 3HD$(HD$ LLHWH3I$IH\$xH$   HPA\_^HATAUAVH   HD$ HXHhHpHx )p)xD)@IMHLHH%HW H+WHfWH<,3HG H+GHHM  $   fD(DY>4 L$   fD  HD$HHL$@H+HH;r4" HL$@f(XMMHT$(I^f(HG H+GHH;r! HwHD$HHL$@H+HH;r! HL$@\MMHT$(I\A^HE H+EHH;r! HE4HG H+GHH;rm! HwHD$HHL$@H+HH;rM! HL$@HHHHG H+GHH;HL$@Ht HD$@    HD$H    HD$P    HL$(` L$   I[ Ik(Is0I{8A(s(|$pE(CIA^A]A\H\$Hl$Ht$H|$ ATH   Hj3MHHH   HtHS3HC HHtH3HHL$PLD$HHHBHt$8HAHBHAHBHVHAHHD$pHHHT$(HT$@HL$ HT$ I՛HH;nL$   I[IkIs I{(IA\H\$Hl$WH HZHHHHtH;tYHtH;tD̄t:Ht$03H;_tHk Ht
HNHH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHHHUHOYHt$0H\$8Hl$@HH _H\$D$WHp)t$`)|$PD)D$@fEWIHfD/f(D)L$0D
& fA(;  e f.zuG  !   H    a f/   f(LHfW0 `f(f(sYf(fT
c  fD/vqY
0 / f/v[fA.zu3(H       $      H$   E  "   HT fnY %  5 ^fA.zu
fA(  f(qf(  fD/v ^AXfD/w$   f(D)T$   f.z3u1( f/v#H$   H"H
2 Y<  . f/v= f/v  "   Hx 8D^D\
. AY4  H$   $   DU. fD(DX
" YE\fA(b 
. Yf/   AYf/v
fA.zZuX3|AYfA(\5te f( f(fA( %. f(^^Yf/v{fA.zu3(H       $      H$   E fn "   H[ Y -A\fA(f( f(fA(j ^Yf(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_H\$D$WH`)t$P)|$@D)D$0Dw# IHf(fA(D)L$ fEWfD/    f.zuH
fm LD$pHr }@ f/   f(LHfW, cf(f(Yf(fT
 fD/v*Y
, , f/vH
l H+ F5e ^fA.zu
fA(  f(nf(  fD/v#fffff     ^AXfD/wt$pf( f.z0u. f/v HL$pHH
. Y<7  + f/v: f/vH
 l H9} |D^D\+ AY   HL$pt$pD
*+ fD(DXT YE\fA(7 
a+ Yf/vzAYf/vH
k Hf AYfA(\5Fb f( f(fA( * f(^^Yf/v9H
Bk H; A\fA(f( f(fA(~ ^Yf(H\$x(t$P(|$@D(D$0D(L$ H`_HHXHpWHp)p5  )xHHp     H   D)@D)HD)PD* D D
3 HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\Y f(AY^= ff     HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\ f(YAYAYf/X= (t$`L\$pE(CE(KE(Sf(I[Is(|$PI_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tMt5HHIL;tMtHHIL;tIHIELK3LKIHH+HLMM~ ('     HHI;f)D|HL$ HLD$XH- l$XHëH\$PH@_H\$Hl$Ht$WH@HH   H)t$0)|$ 菟4   =, fH*Y5 fff        HSHDfI*Xf(YH5rҺ   H%H\$Pn(|$ Hl$XfH*HX(t$0Y3& Ht$`H@_H\$Hl$H|$ ATH H*HLH]HHtH;tHtH;t̄tHt$03H;_tH Ht
H}CHH7HH_HH+HLMM~'fff     HE HHI;f(Df)D|LHH6IT$HOȞHt$0H\$8Hl$@HH|$HH A\H(% f(f(YYf(\f/\ vY% H(D
C2 f(f(H(7H\$Hl$Ht$H|$ ATHpHj3MHHH   HtHS3HCHHtH3HBBHVHHD$XHL$hD$`HHHT$(HT$@HL$ LD$HHT$ IHt$8WHH;|L\$pI[IkIs I{(IA\H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tMt5HHIL;t|MtHHIL;t_IHIALK3LKIHH+HLMM~ (
     HHI;f)D|HL$ HLD$XH-q l$XHAH\$PH@_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tyMt5HHIL;t\MtHHIL;t?IHI_@LK3LKIHH+HLMM~ (	     HHI;f)D|HL$ HLD$XH-Q l$XHSDH\$PH@_HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;t\H;t!HI HtH?HEH]HHuHHH+HLMM~( HEHI;f)D|HUHL$ LLE LM(t$8LD$(LL$0MtWMtRIHIL;t
Mt5IHIL;t
MtIHIL;ty
IHMI>LM(LM IHH+HLMM~( fHEHI;f)D|HUHL$ H\$`Hl$h(t$@Ht$pH|$xHPA\HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;tH;t!HI
 HtHO=HEH]HHuHHH+HLMM~( HEHI;f)D|HUHL$ LHu t$8Ht$(HtI;t	H;t!HMA
 HtH<HEH]HHu HH+HLMM~( HEHI;f)D|HUHL$ L<H\$`Hl$h(t$@Ht$pH|$xHPA\HWATAUH   HD$`HXHhHp LLX HPHiHhHu3HuL9HH;vH    HD LHuHt
LD$ Ht$(H]HHtH;t
HtH;t
̄t
H;t(I HtHJ;LHD$ LH|$ H\$(HHH+HHHLH~4ff     HM IE fB(fB\fC)IL;}LD$ LLHT$ HL$@A$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMM~3ffD  HD$ f(HE f^fXf)HI;|HT$0HL$@|gLl$HHl$PHD$ HD$pHT$xHL$@HHHAHBHAHBHAHBID$HD$0H$   HD$8HT$hHL$0jGHL$ W
 L$   I[(Ik0Is8IA]A\_@WHPb )t$@1Hf/   H\$`HY Hl$h\t$0HiHHl$(HtH;tHtH;tx̄tnHt$p3H;ZtH
	 Ht
H9HH7HH_HH+HLMM~,fHE HI;f(DHf^f)D|HL$ LH,kHt$pH\$`Hl$h(t$@HP_HL$VWATHPHD$ H\$xH$   HcLPHh I$H3HuH6HH;vqH4    H HuHtPID$@Il$HHl$0 D$@Ht.HH;t̄t
̄t H;t$IL$@7 HtH7ID$@I\$@Il$HHHH+HLMM~( @ ID$@f)HI;|LIT$@HL$(+IH\$xH$   HPA\_^HATHP  HD$HHXHhHpHx LHH^ HL$ c I$HT$ IHL$ h    DƍVHL$Pz HE@HL$` H9uH~:~D  H]@H HL$`{0Hu HHcH;EH|HT$ HL$P. M$HIAHL$  HL$P L$P  I[IkIs I{(IA\H\$WH HH 
HO  H\$0L} LH _HWATAUAVAWH   HD$ HXHhHpHHHIHB H+BHH;tZHNS HL$( HL$P/ Ho HD$PHT$(HL$h H HD$PH HL$P8 HGH9GuZH$ HL$( HL$P H HD$PHT$(HL$h HN HD$PHJ HL$P 3H   HI*    HE H+EHH;r LuHO@H+O8IHHHH?HH;r Lg8LoJD& J+D&HL;r JL&IJHH0H;_rHGL$   I[0Ik8Is@IA_A^A]A\_H\$Ht$WH HH HN  Lk	 L@tH H\$0HHt$8H _H\$Ht$WH H HHHp   H@  {H@  K H(  Ht: H  3H(  H0  H8   H   /H    H   Ht H   H   H   H    H   Ht HOxH   H   H    HO`Ht HOHHw`HwhHwp{ L\ LHO(Htc HOHw(Hw0Hw8H\$0Ht$8H _? H\$WH HtH HH\$0H _HL$WH0HD$ H\$HHHٹ    HtH3HHaHC0ƀ   HC0H@HC0H HC0H@HC8    HH輱HH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MCHH=HH\$`HP_HL$WH0HD$ H\$HHHٹ    HtH3HHQHC0ƀ   HC0H@HC0H HC0H@HC8    HHܲHH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MCHH]HH\$`HP_Hl$ VWATHPHy8 IMHHuLL$ LI0A1  HA0H\$pHI HtH;t+  IT$H;u2HH <  ML$AHHHl$ 1=  I$H_0HtH;t IT$H;u=HG0HHHHx   LO0E3HMIHHl$ E1  HHC tzI$HL$0HID$HAHL$0H\$8HHK tEHC    tLE3HHHl$ 0p  ML$AHHHl$ 0S  IL$HH   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?u H\$8    t WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0t2 L$   I;Lt$xtHSH t?ML$IA    tE3HHHl$ /6LAHHHl$ /HT$0LHHHH@HFH\$pHH$   HPA\_^Hl$ VWATHPHy8 IMHHuLL$ LI0A/3  HA0H\$pHI HtH;t; IT$H;u2HH <  ML$AHHHl$ 2=  I$H_0HtH;t IT$H;u=HG0HHHH   LO0E3HMIHHl$ u2  HHS tzI$HL$0HID$HAHL$0H\$8HHK tEHC    tLE3HHHl$ 2p  ML$AHHHl$ 1S  IL$HH   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?u H\$8    t WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0tB L$   I;Lt$xtHSH t?ML$IA    tE3HHHl$ 06LAHHHl$ 0HT$0LHHHH@HFH\$pHH$   HPA\_^LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;sL2I;l  HHH+H;sIHI;IBHIL$ HHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   HfD$0   3D$($   D$ ML$LIVIL$QD$0   HD$8HL@IL3D$($   D$ ML$IT$ INML$IL$ I+IHHHH?HHMtMD$ IIIL$ H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PuHvHINL3D$($   D$ ML$IT$ CMT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHIXeI\$ I|$ H+I^H;tHT$PHCH0H;uHL$hHt Ll$hLl$pLl$xHL$P    IHL$PI|$ H4vHHH+3ML$D$($   D$ LHHWID$ LHINs   I^H<3H;tfD  HT$PHH0H;uHL$hHt7 Ll$hLl$pLl$xHL$P HĀ   A_A^A]A\_^[H\$Ht$WH0DL$@3ID$(D$@HD$ HUH+H\$HH*HHHH?HHRHH+HHt$PH0_Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?LuʬHH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ MbcLG HHHN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ bLG HV 3LOHˈD$(D$@D$ HG HMtMIHHO HN IH+NHHHHH?HtLOLF HVHbHG HmHHt$XH0_@SH HAx   Hf.K H   zt9Hh߫
' Y \Y   XY      H [HL$WH0HD$ H\$HHt$PIHHHw HHRdH HFXH^hH HF`H~pH~xH 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH H HHA`HIH HO8 HO  HO L LtH HH\$0H _HHPHHWATAUAVAWH0  HǄ$@  HXHp )pIILHu 0Hbj HHHTj H;Ej r   H
i ʕHH0j HL$xHtf(LE3Hj E3MHHHi H;i r   H
ui pHHL$xHtfWf(覘LHD$8ML|$8fWLt$x    Ht
H$   HIH$   L$   L$   L$   H$  H$  L$  L$  HT$PH$  H|$PH$  HT$PH$  Ht$PH$     t Ht
H$   HIH$   L$   L$   L$  Ic   H\$XHH$   H  \$0D  HT$HH$  L$   MuIH$  I+HL$   II+HH;s33D$(\$ L$   LD$HPI4M]L$     IHD$@M;v L$   L$   HD$@H$   HHL$`HD$hII+HuM4M;v H$   HT$`HtH;t Ll$@M+I(D$`f$  LL$HA   H$  H$   H$   HD$PH;$   v4 L$   Mu! MMHD$PJI;K wMtIIH;Hs Hl$XeLt$8HT$8H$  nHH\$PH  fWs  f.z   Hf LH(Hf H;f r(   H
-f (LLl$xMt(KAXNIXMuI] HX IE MLl$xHT$PHL$X輠Hf(HL$PۘH\$PH\$P    Ht
H$@  HIH$@  L$X  L$`  L$h  L$`  Ic^DH\$XHH$@  H  \$0 HT$8H$  .L$X  MuIH$h  I+HL$`  II+HH;s33D$(\$ L$P  LD$8PITM^L$`    MM;v L$`  L$X  H$@  HHL$`L|$hII+HuE3/M;v H$@  HT$`HtH;t M+I(D$`f$  LL$8A   H$  H$@  L$X  L;$`  vh L$@  MuU E3M] KI;K wMt	IE E3E3IH;Hs	" E3Hl$XsL$`  Ic       Ht
H$  HIH$  L|$8LD$8HH$  IH$0  HH$(  H+HHt9H;r H$(  L$HH$0  HH$(  H+HH;rIH+HHt9H;rM H$(  L$HH$0  H$(  H+HHH;rA   Hcع    Ht
H$   HIH$   L|$8LD$8HH$   "IH$   HH$   H+HHt9H;r H$   L$HH$   HH$   H+HH;rIH+HHt@    H;rU H$   L$HH$   H$   H+HHH;r	D    H$   H$   H+HC  Hu H$   H9A   Dl$Hf     E;     C    IcH$   H$   H+H  C;  LoL;r| H$   JHD$8H$   LL$   M+I  AE;  HI;r. H$   L$   IHD$XDl$HADl$HIcI+H|EC;}>HH;r L$   LD$8HT$XHL$@ؒH IL$`     DBH$    H H$0     HR H$p  H$    H$p  5 H
>X HL$ LDǋH
 Ui   DBH$   U H H$0  x   H H$  H$   4 L$  H$  LC$  H
W HL$ DAH
X h   DBH$`   H
 H$p     HH H$  H$`   L$   H$  LC$   HpV HD$ DǋH
 BhHt$@@ $   A   5D @ E;     @ %   AED$HHcH$   HH$   H+H  C;  HH;r H$   H$   HHD$8IcH+HM  G;B  HsH;r\ H$   L4H$0  H$(  H+H  G;|  LkL;r H$(  LD$8IHL$XLLf(H$(  HL$`  I  A   LaW H豧LD$@H$  ˔LHH$   H Js? &   H$0  H$(  H+H|BG;};HH;rV H$(  LHT$@HL$pKH0Ht$@Dl$H)   DBH$`  J H
 H$p  m   H H$p  H$`  ) H$p   H
T HL$ LDËH
W e   DBH$`   H H$p  
   HG H$p  H$`   H$p  * H
7T HL$ LDËH
 Je   DBH$   J H
 H$0  m
   H H$  H$   ) H$   H
S HL$ LDËH
W d   DBH$    H H$0     HG H$  H$    H$  * H
3S HL$ LDƋH
 JdAA       H$(  HcH$0  H+HH;r H$(  H< tA;   |      DBH$`   Hg H$p  HȲ[>
Hȋk HȲ])
H$p  H$`   HH$`   H H$`  HH$x  Y H] H$`  谾 AA      H$   HcH$   H+HH;r H$   H< tA   ;|      DBH$`   Hf H$p  HȲ[9	Hȋf HȲ]$	H$p  H$`   HH$   H H$  HH$  T H\ H$  諽 H   VDFH$`  @ He H$p  c
H$p  H$`  - HH$   H H$  HH$   H\ H$   Ic^@    Ht
H$p  HIH$p  L|$8LD$8HH$p  MH$  HH$  H+HL;s	N$IIǐH+HH;sL$HH$  H$  9 .   D$H   D|$@LL$HLD$@H$  HL$p.LH$   HuIH$   H+HH$   HH+HH;s83D$(D$0D$ L$   Mź   H膆HCH$      HH;vG H$   H$   H$   LHL$`Ht$hHH+HuI*H;v H$   MtL;t H+H(D$`fD$`MA   HT$`H$   H$   H;$   v H$   Hu MLHI;K wHtHIH;Hsi K8 /   D$@   D|$HLL$@LD$HH$  HL$pF-HH$   F8 0   D|$@M  LD$@H$   HL$p	/HH$   	7 1   _ D$8D|$@LL$8LD$@HT$PHL$pc2HH$   û7 2   D|$@Mp  LD$@H$@  HL$p&4HH$   膻   A;v@  87 6   HcI@  A   LU H
L$@  HHL$pLA   LlU HI   ٟL$  HH$   LH$  H$  نLINHA   LU H蝞MH$(  蹋LA   LT HI   ZL$   HHL$8ELH$  HL$X`HHL$@ÍMHHL$H賌HH$8  賎Lf(H$H  蟇HINxA   LcT HLH$  ߉MHHL$`߅HA   LT HH$p  蟝HHB5 8   I   LL$PL$p  HL$`6HH$   芹H$  Ht÷ L$  L$  L$  H$p  螷 HT$xH$   ?H$   H$h  HgH$   Ht` L$   L$   L$   H$   ; H$(  Ht( L$(  L$0  L$8  H$   H$X  Ht L$X  L$`  L$h  H$@  ˶ H$   Ht踶 L$   L$   L$  H$   蓶 H$   Ht耶 L$   L$   L$   H$   [ H      DBH$`   H H$p  +   H H$  H$`   L$   H$  LC$   H
eI HL$ A   H
	
 |ZL$0  I[@IsHA(sIA_A^A]A\_HHPHHWATAUAVAWH0  HǄ$@  HXHp )pIILH 0HQ HHHP H;P r   H
oP j|HHP H$h  Htf(LE3HP E3MHHHP H;P r   H
P 
|HH$h  HtfWf(@IfWH$h     赴 Ht
H$   HIH$   L$   L$   L$   H$  H$  L$  L$  HT$PH$  ^H|$PH$  HT$PH$  ?Ht$PH$      Ht
H$   HIH$   L$   L$   L$   Ic   H\$@HH$   wH  \$0f     HT$HH$  L$   MuIH$   I+HL$   II+HH;s33D$(\$ L$   LD$HPI}M^L$     IHD$8M;v L$   L$   HD$8H$   HHL$`HD$hII+HuM4M;vH H$   HT$`HtH;t+ Lt$8M+I(D$`f$  LL$HA   H$  H$   AH$   HD$PH;$   v L$   Mu MM] HD$PJI;K wMtIE IH;Hs Hl$@cL$`  HT$@H$  	H HD$PH
 fW f.zt%HT$PHL$8ǇHf(HL$PHD$PHD$P   袱 Ht
H$  HIH$  L$   L$(  L$0  Ic^DH\$HHH$  H  \$0fD  HT$8H$  >L$   MuIH$0  I+HL$(  II+HH;s33D$(\$ L$  LD$8PId{M^L$(    IHD$@M;v  L$(  L$   HD$@H$  HHL$`HD$hII+HuM4M;v H$  HT$`HtH;t Lt$@M+I(D$`f$  LL$8A   H$  H$  H$   HD$@H;$(  vd L$  MuQ MM] HD$@JI;K wMtIE IH;Hs Hl$HcL$`  Ic      芯 Ht
H$8  HIH$8  L|$@LD$@HH$8  IH$X  HH$P  H+HHt9H;r H$P  L$HH$X  HH$P  H+HH;rIH+HHt9H;rM H$P  L$HH$X  H$P  H+HHH;rA   Hcع   虮 Ht
HL$xHIHD$xL|$@LD$@HHL$x+IH$   HH$   H+HHt9H;r H$   L$HH$   HH$   H+HH;rIH+HHt9H;re H$   L$HH$   H$   H+HHH;r+    H$   H$   H+HC&  Hu H$   H9A   Dl$Hf     E;     *    IcH$   H$   H+H  C;  LoL;r H$   JHD$@H$   LL$   M+I  AE;  HI;r> H$   L$   IHD$8Dl$HADl$HIcI+H|HC;}AHH;r L$   LD$@HT$8H$  yH IL$`     DBH$    H H$0     H_ H$p  H$    H$p  B H
K? HL$ LDǋH
 bP   DBH$   b H" H$0     H H$  H$   A L$  H$  LC$  H
> HL$ DAH
e O   DBH$`   H H$p     HU H$  H$`   L$   H$  LC$   H}= HD$ DǋH
 OOHt$8( $   A   5Q E;     ' %   AED$HHcH$   HH$   H+H  C;
  HH;r H$   H$   HHD$@IcH+HP  G;E  HsH;rl H$   L4H$X  H$P  H+H  G;  LkL;r& H$P  LD$@IH$  YzLf(H$(  |HL$`  I  A   Ln> H辎LD$8H$  {LHH$   %}H J& &   H$X  H$P  H+H|BG;};HH;rc H$P  LHT$8HL$pXvH0Ht$8Dl$H&   DBH$`  W H H$p  z   H H$p  H$`  6 H$p   H
; HL$ LDËH
d L   DBH$`   H H$p     HT H$p  H$`   H$p  7 H
D; HL$ LDËH
 WL   DBH$   W H H$0  z   H H$  H$   6 H$   H
: HL$ LDËH
d K   DBH$    H H$0     HT H$  H$    H$  7 H
@: HL$ LDƋH
 WKAA       H$P  fffff     HcH$X  H+HH;r H$P  H< tA;   |      DBH$`   HN H$p  HȲ[>Hȋk HȲ])H$p  H$`   HH$`   H H$`  HH$x  Y HD H$`  谥 AA      H$   HcH$   H+HH;r H$   H< tA   ;|      DBH$`   HM H$p  HȲ[9Hȋf HȲ]$H$p  H$`   HH$   H H$  HH$  T HC H$  諤 H   VDFH$`  @ HL H$p  cH$p  H$`  - HH$   H H$  HH$   HC H$   Ic^@    Ht
H$p  HIH$p  L|$@LD$@HH$p  MH$  HH$  H+HL;s	N$IIǐH+HH;sL$HH$  H$    .   D$H   D|$8LL$HLD$8H$  HL$pLH$   HuIH$   H+HH$   HH+HH;s83D$(D$0D$ L$   Mź   HmHCH$      HH;vG H$   H$   H$   LHL$`Ht$hHH+HuI*H;v H$   MtL;t H+H(D$`fD$`MA   HT$`H$   H$   H;$   v H$   Hu MLHI;K wHtHIH;Hsi K /   D$8   D|$HLL$8LD$HH$  HL$pFHH$   F 0   D|$8M  LD$8H$   HL$p	HH$   	 1   _ D$@D|$8LL$@LD$8HT$PHL$pcHH$   â 2   D|$8Mp  LD$8H$  HL$p&HH$   膢   A;v@  8 6   HcI@  A   L< H
L$  HHL$pLA   Ll< HI   نL$8  HH$   LH$  H$  mLINHA   L< H蝅MH$(  rLA   L; HI   ZL$   HH$  BLH$  HL$@]mHHL$8tMHHL$HsHH$8  uLf(H$H  nHINxA   L`; HLH$  pMHHL$`lHA   L; HH$p  蜄HH? 8   I   LL$PL$p  HL$`HH$   臠H$  Ht L$  L$  L$  H$p  蛞 H$h  H$   9H$   H$h  HavH$   HtZ L$   L$   L$   HL$x8 H$P  Ht% L$P  L$X  L$`  H$8    H$   Ht L$   L$(  L$0  H$  ȝ H$   Ht赝 L$   L$   L$   H$   萝 H$   Ht} L$   L$   L$   H$   X H      DBH$`   H H$p  (   H H$  H$`   L$   H$  LC$   H
b0 HL$ A   H
 yAL$0  I[@IsHA(sIA_A^A]A\_H\$Hl$Ht$ WH`)t$P)|$@f(E IIH   f/D)D$0   f(跛 f.zu  !   H$    f(fWf(b f/fWvfW ` E3LHfD(f(;D\f(; D\C  C f/vwfWf.z^m 

= f(fTf/v fD(fDW ": ^\ fTÚ fD(f/      & f/v7f(f(LD$(LL$pHT$ \ \
 f(pfD(yf/=9 r# f/vf(舟A fD(LHL$p|$pl% 5 fD(f(X \ \\Y YDXHtfA((t$P(|$@L\$`I[Ik Is(E(CI_@SH0 LD$H3)t$ H5 fTf/ vHi H
6 U LD$H3
fTf/d vH3 H
\6 H(t$ H0[HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;vۼ HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@H   L;   H;vx HHD$@H\$HHnH;n v[ HH\$0Hl$8(D$0fD$0Hu8 E3LKdHHI;k wHtH3H;hs Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PH蕖HOHt2 HG    HG     HG(    HL\$`I[ Ik(IA\_^ @WH HAHLHHL@MtDHMtHHIL;t
MtHHIL;tIHOH\$0I
HWH螤H\$0HGH _HHXHhHp @WH`)p)xf(K@ IIH   f/D)@   f(u f.zuH

 LD$pHn 
f(賁fWf(# f/fWvfW ! E3LHfD(f(<D\f( D\\   f/   fWf.zuH
W
 LD$pH#n n 
7 f(fTf/v蘕 fD(fDWl " ^\ fTk fD(f/       f/v7f(f(LD$(LL$pHT$ \) \
 f(
fD(yf/= r# f/vf(谝 fD(LHL$p|$p͔ 5 fD(f(X \諔 \\ YDXHt(t$P(|$@L\$`fA(I[Ik Is(E(CI_HSH@  HD$0)p)xD)@IfD(f(f(fWf.zuf( Y   f.z  f.
Y z5u3f(fW 1f(f(1YY5 f(j  f/
 rfT= f(w1J  f()H#DJ8 J8 
 ȃ   HT HLf(f(u   H$P  HD$(H\$ fA(f(f(>   L$P  fA(f(f(E   f(f(諢   L$P  f(f(1   f(f(@uH>C HL$x˵ HL$8 HO HD$8HT$xHL$Pʵ HT$8H$    H
g= HHPH
< HHX@`B  HٲL$@  A(sA({E(CI[+ @ i    HLH HPHHUVWATAUAVAWH   HǄ$   HXIMHH   艒 Ht
HL$8H3HD$8HD$P    HD$X    HD$`    IWHL$8E3M9w  3\$0Ht$XH|$PIL,Hu3HL$`H+HHH+HH;s03D$(\$ LL$HMōPHt\HHt$XH|$P  HH;v3 Ht$XH|$PLd$8L$   H$   HH+Hu3$H;v MtL;d$8t H+H($   f$   MA   H$   HL$8H|$PLHt$XH;v Ht$XH|$PLd$8Mu E3Ht$XH|$PHD$8LIL I;K wMtI$3H;HsE Ht$XH|$PAIcI;OH$  H$(  H$     虐 Ht
HL$hH3HD$hHǄ$       HǄ$       HǄ$       H|$ LL$hLD$8HH%H$   Ht HǄ$       HǄ$       HǄ$       HL$h HL$PHtЏ HD$P    HD$X    HD$`    HL$8諏 HH$   H   A_A^A]A\_^]HT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$Pt HL$HH+L$XI*IHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHUUUUUUUHH+I;s>N"I;b  HHH+H;s3HI;IBHHNHH$   H$   3D$($   D$ LNLH$   HRHNLH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$H聪LH$   3D$($   D$ LNHV H$   HH[LF LNII+H*HHHH?HLMtIH>HNA H[HHHF(KdHHHF H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$H萩H^ I}H;t  H0H;tHHH0H;uO$dIH^ I<H;tH0H;tHHH0H;uHF II}H;tH0H;tHHlH0H;uLf H`A_A^A]A\_^[@UATAUAVAWH   Hl$@HE H   H   H   )u@HLqxAY0LBHL;vH>IHupJ    H=   w2J   HHH;wIHH H+H|$@HH.J    H HHuHt虭HHFE3ML96LDLeHEHH=   @@uIM8H;vUMM0MufH    H=   w2H   HHH;wIHH; H+LL$@II$H    HH LHuHtIE8I}0 MDLu HE(HH=   È]0t$0H|$(HD$    ME IU IM"t
Iխ @t	Iƭ H   H   H   (u@HePA_A^A]A\]H\$UVWHpHHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@HHHpH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CYH;}%HT$ fHHH;HfXDf)D|HL$ LLHH$   HHp_^]H\$UVWHPHBB(HHL$(HHBHAHBHAHHHxD$HH|$ptH#HHD$pHT$xHكH;HL$xHMHHHL$ LH+E3HH+HHH,CH;}PD$HHT$(ffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLHQH$   HHP_^]H\$UVWH`HBB0J8HHL$0HHBHAHB HAHHHxD$PL$XH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}]D$PHT$0D$Xff@ fHf(HH;HfYfYf(Lf\f)L|HL$ LLH-H$   HH`_^]@UH`Hl$PHBH] Hu(H}0Le8L)u A0HHH;v莨H
HuLH    H      H   HHH;w
HHHi H+HL$PHHHFML$@M$t$@IT$3HD$8   H9>HL$0HD$(   HDIL$HH=   ID$HHD$ t	H H] Hu(H}0(u Le8He]H  HHkHb薧HL$SH0HD$ HE[HH0[ HL$WH0HD$ H\$PHH   Ht 3H   H  H  H   轄 H   Ht謄 H   H   H   H   苄 H   Htz H   H   H   H   Y H_HH\$HHlZH? H_H\$HHQZH$ H HH\$PH0_HHHUVWATAUH`HD$ HX)pLHcHXfWpHqHp3uH6HH;vH,    HA HuHtHH^IHt$I;t輥̄t貥̄t訥H^HHH+HLMHM~(C  Hf)HI;|LHHL$(H\$0H\$8t$@It$H$   HHLLHH6HtWHtIHHH;tHtIHHH;tHtIHHH;tͤLLHHLNLNIHH+HLMM~(U D  Hf)HI;|HHL$(I蹕IH$   (t$PH`A]A\_^]@SHP )t$@1Hf/   LA LI(H|$`\t$0HyHH|$(MtMtHHIL;tѣMt:MtHHIL;t诣MtHHIL;t蒣IHILK3LKIHH+HLMM~0fD  HHI;f(DHf^f)D|HL$ HdH|$`(t$@HP[HHHVWATAUAVH`HD$ HXHh )pLHcHxfWpHqHp3IuH,I;v订H,    H HuHt荢HH~IHt$I;tḡt]̄tSH~HHH+HLMHM~&( ffffff     Hf)HI;|LHHL$(蟉H|$0t$@It$H$   HuH,I;vҡH,    H HuHt象HH~Ht$I;t蕡̄t苡̄t聡H~HHH+HLMM~( Hf)HI;|LHHL$(ވIEIL\$`I[8IkH(t$PIA^A]A\_^HL$WHPHD$ H\$hHt$xHH_0 HL$( HHD$pHm HHNH E3D^0D^4D^8D^<D^@D^HFDH H/ HHNPHH\$hHt$xHP_@SH A H/ HHH HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HL$WHPHD$ H\$hHt$xHH/ HL$(ܟ HHD$pH= HHNH E3D^0D^4D^8D^<D^@D^HFDH H*/ HHNP<HH\$hHt$xHP_@SH A H/ HHHº HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;vHH4    H HHuHt$HL$@Ll$HLt$PHsHkIHtHtIHHH;tHt:HtIHHH;t违HtIHHH;t袝LLMM;t%Ӟ MtINHHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;t/I
IHt:HtIHHH;tHtIHHH;tڜLLM;t% MtIHHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;tuMt:HtIHHL;tSHtIHHL;t6IHI;t%k HtHHHD$@HHL$@Ld$HHt$PHHH+HLMHM~Hf(fYf)HI;|LHT$@HL$(tIwHwLHD$(Ht$0I_HtI;t肛HtI;tm̄tcH;t(I HtHLHD$(LH|$(H\$0IwHtI;tHtI;t̄tH;t(I2 HtHLHD$(LH|$(Ht$0I_HtI;t讚HtI;t虚̄t菚H;t(Iț HtHCLHD$(LH|$(H\$0HHH+HLMM~!fD  If(fYfA)HI;|LHT$(HL$XLD$@HT$(H$   H踹HL$(4 HL$@( HH$   HpA_A^A]A\_^]HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;vXH4    H HHuHt4HL$@Ll$HLt$PHsHkIHtHtIHHH;tHt:HtIHHH;tϘHtIHHH;t貘LLMM;t% MtI^HHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;t?I
IHt:HtIHHH;tHtIHHH;tLLM;t% MtIHHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;t腗Mt:HtIHHL;tcHtIHHL;tFIHI;t%{ HtHHHD$@HHL$@Ld$HHt$PHHH+HLMHM~HfQf)HI;|LHT$@HL$(XIwHLHD$(Ht$0I_HtI;t薖HtI;t聖̄twH;t(I HtH+LHD$(LH|$(H\$0IwHtI;t,HtI;t̄t
H;t(IF HtHLHD$(LH|$(Ht$0I_HtI;tHtI;t譕̄t裕H;t(Iܖ HtHWLHD$(LH|$(H\$0HHH+HLMM~!ff     IfQfA)HI;|LHT$(HL$XLD$@HT$(H$   H̴HL$(H HL$@< HH$   HpA_A^A]A\_^]HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;vsH,    H LHuHtOLD$@Ht$HHkIHtI;t"HtI;t
̄tH;t(I< HtHLHD$@LH|$@Hl$HHsHtI;t踓HtI;t裓̄t虓H;t(IҔ HtHMLHD$@LH|$@Ht$HHkHtI;tNHtI;t9̄t/H;t(Ih HtHLHD$@LH|$@Hl$HHHH+HHHHH~ Hf(fYfA)HH;|LLHT$@HL$(pIt$HrLHD$(Ht$0I\$HtI;t|HtI;tḡt]H;t(I HtHLHD$(LH|$(H\$0It$HtI;tHtI;t̄tH;t(I+ HtHLHD$(LH|$(Ht$0I\$HtI;t覑HtI;t葑̄t臑H;t(I HtH;LHD$(LH|$(H\$0HHH+HLMM~I$f(fYfA)HI;|LHT$(HL$PLD$@HT$(IMHL$(9 HL$@- IL\$pI[8Ik@IA^A]A\_^HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;vcH,    H LHuHt?LD$@Ht$HHkIHtI;tHtI;t̄tH;t(I, HtHLHD$@LH|$@Hl$HHsHtI;t訏HtI;t蓏̄t艏H;t(I HtH=LHD$@LH|$@Ht$HHkHtI;t>HtI;t)̄tH;t(IX HtHӿLHD$@LH|$@Hl$HHHH+HHHHH~ HfQfA)HH;|LLHT$@HL$(4It$HfLHD$(Ht$0I\$HtI;tpHtI;t[̄tQH;t(I HtHLHD$(LH|$(H\$0It$HtI;tHtI;t̄tH;t(I HtH蚾LHD$(LH|$(Ht$0I\$HtI;t蚍HtI;t腍̄t{H;t(I HtH/LHD$(LH|$(H\$0HHH+HLMM~fI$fQfA)HI;|LHT$(HL$PLD$@HT$(ICHL$(/ HL$@# IL\$pI[8Ik@IA^A]A\_^H\$Ht$WH HH   Ht9j H   3H   H   H   j HOp1rHOpj H H_PHO8Hti HO Hw8Hw@HwHi Ht$8HH\$0H _HL$WH0HD$ H\$PHHH HHBHAHBHAHBHAH H iHOPHL$HH
 HHCXHAHC`HAHChHAHSpH J9H   H   6iHH\$PH0_LATH   HD$ I[IkIsI{ LHHB H+BHH;AtYH IKB HL$P HƎ HD$PHT$(HL$hA H HD$PHu HL$Ph 3H9yvtfHC@H+C8HH;r HC8H,ID$ I+D$HH;rȋ It$H   H+   HH;r H   HHHH;{rHKPHH   L$   I[IkIs I{(IA\H`HL$WH0HD$ H\$PHt$XHH  Htg 3H  H   H(  H   hg H5
 H  H  HO@H_H\$HHK։ H3H7H\$PHt$XH0_H\$WH HtHf HH\$0H _HL$WH0HD$ H\$PHHH HHHL$HH HHBHAHH7 HS@HO@H  H  H  HL$HH HH  HAH  HAH  HAH   H 5fHH\$PH0_H\$WH0HAHH)t$ Hf(P@HC@HK@f(HP@H  Hf(HP@H  f(HHH\$@(t$ H0_H`@H\$Ht$WH HAHHAHP8HC@HK@DHP8H  DHHP8H  DHHH\$0Ht$8H _H`8H\$Ht$WH HAHHIHP0HC@HK@LHP0H  LHHP0H  LHHH\$0Ht$8H _H`0H\$Hl$Ht$WH HAHHAIHP(HC@HK@DLHP(H  DHLHP(H  DHLHH\$0Hl$8Ht$@H _H`(H\$Hl$Ht$H|$ ATH0HA\$`HHAIL\$ P HG@HO@DLIԉ\$ P H  DHLIԉ\$ P H  HDLIԉ\$ P H\$@Hl$HHt$PH|$XH0A\H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`@SH HAHHPHC@HK@PH  HPH  HH [H`H\$WH HAHHHHC@HK@HH  HHH  HHH\$0H _H HL$WH0HD$ H\$PHH   Ȅ H    H_pH\$HH(8Ha H_0H\$HH
8Ha HOH\$PH0_H%n HL$WH0HD$ H\$HHH  YH  Hta 3H  H  H  H  `a H  HtNa H  H  H  Hp  -a H@  DiH@  a H  ˊH  iH  ` H  襊H  HHH\$HH0_HL$SH0HD$ Hٹ   ` HtH3HHHC0ƀ   HC0H@HC0H HC0H@HC8    HH0[HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKHS tH[HH    tH|$(I4$Ht$ Ml$0HtH;tW 3I;tHWH   (D$ f$      _ Ht
HL$0HHHD$0H\$HH\$PH\$X   _ Ht
HL$`HHHD$`H\$xH$   H$   HH$   ΁ H$   H$p  HT$0H$   _HT$`H$    _L$   L$   H$0  I߁HT$ HH
H@HBH$  Ht^ H$  H$   H$(  H$   ^ H$   Hto^ H$   H$   H$   H$   J^ H$    HL$xHt,^ H\$xH$   H$   HL$`
^ HL$HHt] H\$HH\$PH\$XHL$0] H|$(Ht$ Hud HH;{0uS HG@HG@L$P  I[(Ik0Is8IA]A\_HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKH tH[HH    tH|$(I4$Ht$ Ml$0HtH;t 3I;tHWHC   (D$ f$      \ Ht
HL$0HHHD$0H\$HH\$PH\$X   \ Ht
HL$`HHHD$`H\$xH$   H$   HH$    H$   H$p  HT$0H$   ^HT$`H$   @\L$   L$   H$0  IHT$ HH
H@HBH$  Ht[ H$  H$   H$(  H$   [ H$   Ht[ H$   H$   H$   H$   [ H$    ~ HL$xHtl[ H\$xH$   H$   HL$`M[ HL$HHt>[ H\$HH\$PH\$XHL$0%[ H|$(Ht$ Hu~ HH;{0u~ HG@HG@L$P  I[(Ik0Is8IA]A\_H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;v} HM HtH;t} HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k v} HHl$(H\$ (D$ fD$ Hug} LLH<HHI;{ wHtH3H;~s:} H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\@WATAUAVAWH@HD$0H\$pH$   HHHUUUUUUUH;v҂HAHu3I*%HI(H+I*IHHHH?HH;   HHK萣HHD$xLk L9kvH| LcL;c v8| 3D$(D$xD$ LKLIIWLC LKII+IHLIIH?LMtIHAVHKDX HHHHC(KdHHHC HsH\$pH$   H@A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;sL2I;l  HHH+H;sIHI;IBHIL$šHHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   HqD$0   3D$($   D$ ML$LIVIL$AD$0   HD$8HL@IL3D$($   D$ ML$IT$ INML$IL$ I+IHHHH?HHMtMD$ IISIL$U H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PUHvHINL3D$($   D$ ML$IT$ 3MT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHII\$ I|$ H+I^H;tHT$PHc|H0H;uHL$hHtT Ll$hLl$pLl$xHL$PT    IHL$PTI|$ H4vHHH+3ML$D$($   D$ LHHGID$ LHINcI^H<3H;tfD  HT$PH{H0H;uHL$hHt'T Ll$hLl$pLl$xHL$PT HĀ   A_A^A]A\_^[HHPHHWATAUAVAWH  HǄ$  HXHp )pLL)    S HtH$h  H33HH$h  H$  H$  H$     S Ht
H$   HHH$   H$   H$   H$   H| HL$hu He	 H$   u H;	 H$   mu HL$0JHD$ LL$hL$   H$   IHL$HHtR H\$HH\$PH\$XHL$0R H$   'u H$   u HL$hu A^@H HL$ht ILD$hHT$0IP(HH$h  qVHL$HHtR H\$HH\$PH\$XHL$0R HL$ht L$  H$  L+IMuju H$   AF@H H$   7t H H$   !t H HL$ht HL$03IHD$ L$   L$   HT$hIHL$HHtLQ H\$HH\$PH\$XHL$03Q HL$hs H$   s H$   s I~DH$  H4 HL$hms ILD$hHT$0IP(HH$h  UHL$HHtP H\$HH\$PH\$XHL$0P HL$h3s L$  H$  L+IMut H$   Hy H$   r H8 H$   r Hr HL$hr IcV@HL$0HD$ L$   L$   HT$hI5HL$HHtO H\$HH\$PH\$XHL$0O HL$h`r H$   Qr H$   Br EF@H H
 {fWt$`Ic~@   O Ht
HL$0HHHD$0LD$`HHL$0芀MfHHT$0IvHL$HHt$O H\$HH\$PH\$XHL$0O H HL$h}q ILD$hHT$0IPHH$   HvHL$HHtN H\$HH\$PH\$XHL$0N HL$hCq HIcF@HHt}HؐLL<    HID$ I+D$HH;rq Ml$H$   H$   H+HL;rq H$   J9ID HH;r3L$  L$  H@w H$   p H H$   lp H$ HL$hYp IcV@HL$0HD$ L$   L$   HT$hIHL$HHtM H\$HH\$PH\$XHL$0zM HL$hp H$   p H$   o EF@H H
: -t$`Ic~@   IM Ht
HL$0HHHD$0LD$`HHL$0@~MfxHT$0I^tHL$HHtL H\$HH\$PH\$XHL$0L H HL$h3o ILD$hHT$0IPHH$   sHL$HHtzL H\$HH\$PH\$XHL$0aL HL$hn HIcF@HH   H LL<    HID$ I+D$HH;ro Ml$H$   H$   H+HL;ro H$   J9ID HH;r3L$  L$  Ht H$   2n H H$   n H HL$h	n IcV@HL$0jHD$ L$   L$   HT$hIHL$HHtCK H\$HH\$PH\$XHL$0*K HL$hm H$   m H$   m EF@HM H
* t$`Ic~@   J Ht
HL$0HHHD$0LD$`HHL$0{M   HT$0IrHL$HHtJ H\$HH\$PH\$XHL$0nJ H  HL$hl ILD$hHT$0IPHH$   qHL$HHt'J H\$HH\$PH\$XHL$0J HL$hl HIcF@HH|   HLL<    HID$ I+D$HH;rYm Ml$H$   H$   H+HL;r2m H$   J9ID HH;r3L$  L$  Hȳ H$   k H H$   k H HL$hk HL$0@HD$ L$   L$   HT$hIKHL$HHtH H\$HH\$PH\$XHL$0H HL$hvk H$   gk H$   Xk A   H HL$hk ILD$hHT$0IP(HH$h  LHL$HHtfH H\$HH\$PH\$XHL$0MH HL$hj L$  H$  L+IMuk H$   A   H;q H$   }j H H$   gj H HL$hTj Mc   IcV@HL$0>HD$ L$   L$   HT$hIHL$HHtG H\$HH\$PH\$XHL$0nG HL$hj H$   i H$   i EF@H H
* !E   HW H
 t$`Ic       G Ht
H$   HHH$   LD$`HH$   xIc~@   F Ht
HL$0HHHD$0L$   HHL$0sI   HL$`HT$0sHL$HHtIHt$PH;t:Hy HHtOF HH_H_HO;F H0HGH;uHL$H$F H\$HH\$PH\$XHL$0F H$   HtE H$   H$   H$   H$   E H HL$hEh ILD$hHT$0IPHH$   mHL$HHtE H\$HH\$PH\$XHL$0sE HL$hh HIc   H$   LH  H* Mc~@LM   HH\$`     LH    H$0  HH$   HK H+KHHHHH?HL;rkh HsHD7 H+D7HL;rNh Ht7H$   H$   H+HL;r'h H$   H$0  HJIH0M;H$   H*=3H$   L$  IL;L$  H`m H$   f HB H$   f HD HL$hyf Ic   HL$0	HD$ L$   L$   HT$hIHL$HHtC H\$HH\$PH\$XHL$0C HL$h/f H$    f H$   f E   H H
 G$   Ic      ]C Ht
HL$0HHHD$0L$   HHL$0QtM  HT$0IljHL$HHtB H\$HH\$PH\$XHL$0B H HL$hAe ILD$hHT$0IPHH$   jHL$HHtB H\$HH\$PH\$XHL$0oB HL$he HIc   HHt~HfLL<    HID$ I+D$HH;re Ml$H$   H$   H+HL;re H$   J9ID HH;r3L$  L$  H k H$   Bd H H$   ,d H HL$hd IvDLcIcV@HL$0HD$ L$   L$   HT$hIHL$HHtLA H\$HH\$PH\$XHL$03A HL$hc H$   c H$   c EF@HV H
 DH( H
 $   Hc>   @ Ht
H$   HHH$   L$   HH$   qIc~@   @ Ht
HL$0HHHD$0L$   HHL$0:M@  Ld$`HT$0ImHL$HHtQHt$PH;t>Hy    HHt@ HH_H_HO? H0HGH;uHL$H? IvDH\$HH\$PH\$XHL$0? H$   Ht? H$   H$   H$   H$   ? Hx HL$hb ILD$hHT$0IPHH$   fHL$HHtH? H\$HH\$PH\$XHL$0/? HL$ha HHcH$0  LH  fffff     IcF@HH   HHff     LL<    HH$   IL$ I+L$H*HHHH?HH;r*b Md$JD' J+D'HL;rb Nd'H$   H$   H+HL;ra H$   J9KHH0H;H$   Ld$`H3L$  IL;$0  
L$  IvDDH3 H
 Hc>HuHI9II;v`L$    INa HHuMt_H$   H$(  Mp  Ht.HH;t_̄t_̄t_I;|$tEI$` Ht2I;v_L,    I` HuMt`_I$I$I|$HHH+HLMHM~    f(I$f)HI;|LIH$   3HD` H H$   _ H H$   _ H HL$h^ MnDIcU H$8  HHD$ L$   L$   HT$hIuH$P  Ht< H$P  H$X  H$`  H$8  ; HL$h^ H$   ^ H$   s^ H HL$0A^ ILD$0H$8  IPHH$   	cH$P  Ht; H$P  H$X  H$`  H$8  ]; HL$0] HMc} HMtbfD  HL,    HM4$H$   L$   I+HH;r^ L$   K(IHI;rL$  L$  H
d H$   O] H HL$h<] H HL$0)] H$8  K2HD$ L$   LD$hHT$0H$  HH$P  Ht\: H$P  H$X  H$`  H$8  7: HL$0\ HL$h\ H$   \ I  H H$   x\ HL$   H$8  HPHH$   =aH$P  Ht9 H$P  H$X  H$`  H$8  9 H$   &\ L$   H$   L+IMu\ H$   H I  Ǆ$      L$   MHq H
^ I$   L$   M  H$ H
5 I^INrJMc] Ic   ILINH$   Ht8 H$   H$   H$   H$   8 H$  Ht8 H$  H$  H$  H$h  k8 L$  I[@IsHA(sIA_A^A]A\_HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   "8 Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$plMH{   \$0ffff     IG I+GHL;r[ IGB4H( HHH H; r   H
 HHL$8Htf(IHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH~L_L$      H$   H9$   v5Z Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   vY HtH;t$ptY I+H(D$PfD$`LL$8A   HT$`HL$prL$   L;$   vY Ht$pHuY MHD$pLIL I;K wHtHIH;HsZY IH$   L;pHH$  HD$ L$  LD$pHT$8HfH pnH$   Htg5 L$   L$   L$   HL$pE5 f(($   H   A_A^A]A\_^[HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   5 Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$poiMH{   \$0ffff     IG I+GHL;rW IGB4H HHH H; r   H
u pHHL$8Htf(IHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH^L_L$      H$   H9$   vW Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   vV HtH;t$ptV I+H(D$PfD$`LL$8A   HT$`HL$pnL$   L;$   v{V Ht$pHukV MHD$pLIL I;K wHtHIH;Hs:V IH$   L;pHH$  HD$ L$  LD$pHT$8H|H pNH$   HtG2 L$   L$   L$   HL$p%2 f(($   H   A_A^A]A\_^[HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   1 Ht
HL$8H3HD$8HǄ$       L$   HHL$8^c3I;^   IE I+EHH;rT IE4H HHH H; r   H
g bHH$   Htf(H3HD$XHL$PH+HH;rvT HL$PH<HZH$   HD$ MLD$8H$   IaH$   qHT$XH+T$PHfWI]3fHD$XH|$PH+HH;s/ID$ I+D$HH;rS HIL$H@HHHtH*0 HD$P    HD$X    HD$`    HL$80 f(L$   I[ I{0Mc8(t$pIA_A^A]HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   / Ht
HL$8H3HD$8HǄ$       L$   HHL$8.a3I;^   IE I+EHH;rR IE4H HHH H; r   H
7 2HH$   Htf(iH3HD$XHL$PH+HH;rFR HL$PH<HZH$   HD$ MLD$8H$   IxH$   q^HT$XH+T$PHfWI[3fHD$XH|$PH+HH;s/ID$ I+D$HH;rQ HIL$H@HHHtH- HD$P    HD$X    HD$`    HL$8- f(L$   I[ I{0Mc8(t$pIA_A^A]HL$WH0HD$ H\$PHHYHH\$HHHg- H_H\$@HyHH\$PH0_B- H\$WH HHBHAHPO HS0HO0NHSpHOpOL   H   L      H      O D   D      H         H      N D  H   H   A   D  , H\$0HH _@WH HA HLHHAL@MtDHMtHHIL;t\NMtHHIL;t?NIHO(H\$8IYLL$0LD$0HW(H.H\$8HG(H _HL@HHWATAUAVAWHPHD$0HXHp )pMMLLfWHRH@X3HI9\$~Dff     M,$IF`I+FXHH;rN INXID HHI;\$|L$   I   MFIF8HD$ MNpIV@I"5:` fWAE I   I+   HI;wtLIWN Ht;HH;vLL$    I4N HuMtLII?IwI   I+   HH   H       I   I+   HH;rM I   $   H$   H#H;tUI   I+   HH;rM I   fWIHI   I+   HH;k6IN8HtH vHHK K    mH      AE $   H$   H#H;t3@IN8Ht+HX KvHH) <vHHJK LK       L\$PI[8IsH(t$@IA_A^A]A\_HWATAUAVAWH`  HǄ$  HXHhHp)p)xf(IHH   DBHrJ    ( E3Ht
HL$`HIHD$`Lt$xL$   L$   H$0  HD$ LL$`LHHPf(HT$8H$   J Hx HL$8J L$  t,HT$8H$   I MHIAHL$8J    ( Ht
H$   HIH$   L$   L$   L$   H$0  HD$(t$ L$   LHH&(HT$8H$   SI Hx HL$8 J t,HT$8H$   )I MHIAHL$8I ADt$0H<k HL$8I HT$8H$   2H HL$8I H H$0  sHf(H MIASHT$8H$   H MHIAHL$8?I MIASHj HL$8I HT$8H$   G HL$8I 
   H$   G H$0  HcQH0  HP   H$   F HH9 H$0  sHHuI
H HcHHHW   H$   F HH HrHHuI
H HcHHHW   H$   ZF HH HrHHuI
H HcHHHW   H$   F HHN HFrHHuI
H HcHHHWH HrHT$8H$   F MHIAHL$8G IHE H+EHH+  $  =J D  Hh HL$8.G HT$8H$   E HL$8.G L$   L+\$xII;rH HD$xH$   H$   HH$   H+HH;rG H$   H$   HH$   H+HH;rG H$   H$   H+D$xHH;r~G Ll$xHE H+EHH;rbG Lu
   H$   {D H$0  HcQH0  HP   H$   ND LHH$0  D HHu3
H HcHHIT$A$   H$   D LAH>E HHuE3I
H HcHHE3IT$A$   H$0  C LAL HD HHuI
H HcHHIT$A$   H$   wC LHD HHuI
H HcHHIT$A$L$   AH$   \HkD HT$8H$   0D MHIAHL$8D L$   H|$xL+II;rE H|$xH$   H$   H+HH;rE H$   \fTf/vt$0Ɖt$0t$0HHE H+EHH;H$   Ht! L$   L$   L$   H$   p! HL$xHt`! Lt$xL$   L$   HL$`A! H$   C L$`  I[0Ik8Is@A(sA({IA_A^A]A\_HL@HHUVWATAUAVAWH   HǄ$   HX )p)xMHH u  ϻ uIʻ   
 
 j  
R 
z H$H  HD$ pf(fW$(  HW H+WHHL$(  L$@  IcH_ H+_H     E3Ht
H$   HIH$   $(  L$(  HH$   PH_ H9_v/C HHD$@H\$HH_H;_ vC HHD$0H\$8    Ht
HL$PHIHD$P(D$@fD$@(L$0fL$0D$(  LD$@HT$0HL$P6IH_ H+_HH       HIE I+EHH;ruB IEL4fffff     HG H+GHH;rIB H_HD$pHL$hH+HH;r)B HL$hHmA0 XHD$     L$   MHT$PH3HG H+GHH   L=ff     H$   H$   H+HH;rA H$   5. CY<(
 Y4f(AXAHw H+wHHHIE I+EHH;rEA IEX44HHG H+GHH;_L$0  H$   II HG H+GHH;r@ H_HD$pHL$hH+HH;r@ HL$hHHHH_ H+_HH;A    HL$hHt Ld$hLd$pLd$xHL$P H$   Ht L$   L$   L$   H$    f(L$   I[XA(sA({IA_A^A]A\_^]HHXHhHpWATAUH   D_ )p)xHHHHD)@D)HD)Pw*D\$(H-|$ AA| IcL    
 AY)
 f/U  DO D
G DUQ Ip     I   E^      IHiN  HHH+HHHHiH+IŉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYfD/xA)@)
 A)H)
 \YXf(YAYX f/wUD] HL$ H)D\$(|$ AA| IcL    
 AY)
 f/fnY(t$p(|$`L$   I[ Ik(Is0E(CE(KE(SIA]A\_HHn%fnY@WH HAHLHHAL@MtDHMtHHIL;tL<MtHHIL;t/<IHO H\$8IImLL$0LD$0HW HC*H\$8HG H _HHXHhHp L@WATAUAVAWH   )p)xD)@D)HD)PD)xD)hD)XD)t$pD)|$`L$  IA   MHLDD$ ADH`D@xD> fA(A\f(fATf/V  H$  L$X  =$N DN D$  D$  D$  D$  gfffIH      AA+ufA(AXAYA$(  fA(fA(A\AXYM ^fA(AY\f(Y\ fE/f(vfW-XM f(Y-lM fA(AXA\fA(\A\YXfA(^\$  A$H$  H#H;tRfE/H$  wH$  Y5 f(X f/w%fE/H$  wH$   \f/vfA(AXAYA$=L IH]A4$Ll$0t$HHl$@Ht!I;  HtI;  H;^tTH{: Ht?HH;  H<    HZ: Hu	H|  H$@  HH    H3H^HH+HLMM~:fHE f(HI;fYLIE f(DHfXf)D|HL$(LHH$P  MLHl  @ fE/H$  wH$  fE/0H$  AX4$AYA4$wH$  A\fATf/  H]t$HLl$0Hl$@HHt!H;\  HtH;O  H;^tTH8 Ht?HH;4  H<    H8 Hu	H  H$@  HH    H3H^HH+HLMM~:fHE HI;f(LIE fYf(DHfXf)D|HL$(LH}H$P  MLHHIH$p  f(A$f(YH$`  Xf/wwfA/spH$x  f(fAT fWf/  fA(A\Yf/? rD$  fE(fE(fE(E$fD(fD(D$  $  fD(fD(fD(DD$ AfA(ADD$ A\f(fATf/   D(t$pD(|$`L$   I[0Ik8IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_55{5u5o5i5c5]53tH8a 3LD$PHT$HE3)t$ D$Hw{58 fTf/SH vH" H
 1] 3LD$PHT$HE3ɈD$H-{fTf/H vH H
ٻ 0 3LD$PHT$HE3ɈD$HzfTf/G vH H
 0(t$ H8@UATAUH   Hl$PHE H]PHuXH}`)u HL!LiA0HJHH;v4HHumH    H=   w9H   HHH;w
HHH H+HT$PHH$H    H4 HHuHt3HG3H97HDHH=   IE IL$t$@HD$8   HT$0HD$(   HD$ LM$IT$s(t	H}4 H]PHuXH}`(u He0A]A\]H\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,C9H;}:D$Hfffff     HHH;f(Df^f)D|HT$ HL$0LL8H$   HHP_^]Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;t1̄t1̄t1H\$P3H;tH
2 Ht
HcbHHHHwHH+HLMM~#(*, ff     HHI;f)D|HL$ LHLD$XH-: l$XHH\$PHl$`Ht$hH@_LI[IkIs WH   Hj3HHH   ICICICIC@ HtHS3HCHHtH3HBBHVHHD$hHL$xD$pHHHT$8HT$PHL$0HL$ HT$XHt$HHH;|L$   I[Ik Is(I_H\$UVWH   HBBPHHL$(HHBHAHBHAHB HAHB(HA HB0HA(HB8HA0HB@HA8HBHHA@HHHxD$pH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CZH;}ID$pHT$(fffffff     fHHH;HfYfXDf)D|HL$ LLHH$   HHĀ   _^]LI[UVWH   HBBpHHL$(HHBHAHBHAHB IKHHB(HAHB0HAHB8IKHHB@HAHBHHAHBPICHB`ACICHBhICHHHhIktH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH4CH;}U$   HT$(ffffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLHH$   HHĠ   _^]@UH   Hl$PHH   H   L   L   L)   A0HU0HHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@HAHHU HHAPHBHAXHBHA`HBHAhHB LeHL;v,H}     HM LMpLE0HU8t$@3HD$8   J    H9u HDH=   IE HD$0HD$(   HL$ HM@tt	H_- H   H   L   (   L   H   ]J    H   w<J   HHH;w
HHH H+HL$PHH$H, HHH{+HL$VWATAUAVH@HD$ H\$xH$   MLHH HHHOHH       E3HtHIHLsLs Ls(H       HtHIHLsLs Ls(H       HtHIHLsLs Ls(IHO)IHOH*HH\$xH$   H@A^A]A\_^H\$Hl$Ht$H|$ ATH@Hy0MHH_H񀻡    u2ffff     HKI* tH[HH    tHH^0H|$(HD$ HtH;t+ H;tHWI) uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$Hl$Ht$H|$ ATH0Hq8HiLHHLHT$ HH HtH;ta* H9wuHIHP tH\$@Hl$HHt$PH|$XH0A\H\$Ht$WH0HyxHqHHHLHT$ XHH HtH;t) H9{Ht$HH\$@H0_H\$Hl$Ht$ WATAUAVAWH0Li8LqHHHT$ 3HIt$`LH HtI;ti) M9l$tGHT$ HOLHHHu@) HHtH1HF0H9Gu%) HWHp*HHHP tHOHHT$ LZH   HiHl$pHt$xHH\$hH0A_A^A]A\_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ LHHHun( HHtH1HF0H9GuS( HWHpH   HHl$PHt$XHH\$HH0_H\$Hl$Ht$H|$ ATHPHHL$ L& 3ILjHE8H}HHu8HtH;}t' H;   Hu' E3LI;[0u' HSIhHu'     tz' HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\H\$WH H<~tH; HH\$0H _HL$WHPHD$ H\$hHt$xHcHH HH~@H|$p3HHGHGLHMt:MtHHIL;t%MtHHIL;t$IIMHVLOLGLD$0LL$8MtWMtHHIL;t$MtHHIL;t$MtHHIL;ti$IIHUHT$(H\HH\$hHt$xHP_HWATAUAVAWHP  HD$HHXHhHpLHH HL$  $ IHT$ IHL$ &$    DBHL$P:# E3IL9vH   HD HL$ # HT$ HL$Pm" HL$ # HF@HL$`%# A   ML9fP~Kffffff     H~@IH^HHHR HL$`MH" AIIcH;FP|HT$ HL$P" MHIAHL$ :# AHIcH;FH'HL$Pd" L$P  I[0Ik8Is@IA_A^A]A\_H\$ WH   HًI@H;K4rS0+C8;s;tHKPIC@SD;  K0;  +K8H$   L$   )$   )$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPHHwH|$05& D,[PHt$PfAnf(X^^:+ D$`|$8Y5V t$hHt.HH;t!̄tx!̄tn!H$   3H;tH" Ht
HRHH/HHwHH+HLMM~JffY. ffD  Hf(HI;fDfYfXf)L|HL$ LH́HKPC@H$   ($   ($   L$   H$   H$   HĠ   _C@H$   2HĠ   _HHPWATAUAVAWH@  HǄ$   HXHhHp MMHH g3E3E3HV H+VHgfffffffHHHH?Hd  HCHD$0Hl$ 3H|$(H*$x       IO I+OHHHH?HL;r  IGHH$   GH5LIt$I;t$ v  I<$H|$pHt$x(D$pfD$`Hu  E3LJ4I;s wHtH3H;ps\  Ht$hIt$I;t$ vE  I<$H|$@Ht$H(D$@fD$PHu!  E3LH4I;s wHtH3H;ps Ht$X   x Ht
H$   H3H$   (D$`f$  (L$Pf$0  DL$  H$0  H$   IO I+OH*HHHH?HL;r` H|$(IH$   H$   HH$   H$x  HN H+NHgfffffffHHHH?HL;r HT$ HVHL$0HH$   H"HO0H$   "H$   Ht 3H$   H$   H$  H$    H$   Ht H$   H$   H$   H$    IH$   Ht H$   H$   H$   H$    IH|$(H0H|$(HD$ (HN H+NHgfffffffHHHH?HL;H*L$@  I[0Ik@IsHIA_A^A]A\_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ LHHHuN HHtH1HF0H9Gu3 HWH@H   HZHl$PHt$XHH\$HH0_HWATAUAVAWH   HD$ HXHhHp IHH3$   Li8LqHT$(HLH HtI;t M9l$tULHT$(HKHHHuq HHtH1HF0H9CuV HSH@HH  HHHP   HKHLHT$(yHHHu HHuHHH@0H9Cu HSH@HL$8H\$XH+\$PH   M Ht
HL$hHHHD$hfW$   L$   HHL$h4)HHD$XH|$PH+HHtaH;r_ H|$PH$   H$   H+HH;r8 H$   fnHHD$XH|$PH+HH;rHT$hH|H$   HtU H$   H$   H$   HL$h3 HL$PHt# Ht$PHt$XHt$`HL$8
 HH   H
HL$   I[8Ik@IsHIA_A^A]A\_H\$Hl$Ht$H|$ ATHPHHL$ LU 3IL\HExH}HHHuxHtH;}Ht H;   Hu E3LI;[0u HSIZHu     t HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\HHPUVWATAUAVAWH   HD$PHX)pMHLE3D$   I@HD$ L
e DA H?e H
n EMIVIHtgII      Ic$   H$   I#I;w
IL;r/H^@ HD$(HB6 HD$ MH H
m 蟿I]H\$8Lt$`HT$hHL$0HHHAHBHAHBH$   HL$XHHHAHBHAHBHAHBHA HB HA(HB(L$   ImHuI9HH;v{H4    H HHuHtWHHoIuHtI;t7HtI;t"̄tH;tT Ht
HFHL'HwImHtI;tHtI;t̄tH;tH Ht
HpFHL'HoIuHtI;t|HtI;tg̄t]H;tH Ht
HFHL'HwHHH+HHHH~JIE fB(4HfB(f)D$0HL$06f(IfB(fYfXHfB)IL;|LLHH$   ?HH$0  ($   H   A_A^A]A\_^]LD$HT$WH0HD$ H\$XIHD$@    LAHHQHD$@   H HH\$XH0_LL$ LD$HT$HL$SUVWATAUAVH0HD$ IIHLH HHHL$(H/ HHBHAHH IM@H詇I  H虇I  HL$(Ha HL$   IFHAIFHAIFHAH IV %HO H HH藆H莆IN8Ht 3IF8IF@IFHIN  IIH0A^A]A\_^][H\$WH H܈tH HH\$0H _LIKVWATH`HD$ I[IkIHHHm HE3LaHyI{AL$T HtH8IHD$   D$   L$   3H!H* HH{H   	 HtH8IHLgLg Lg(H{x    HtH8IHLgLg Lg(H       HtH8IHLgLg Lg(H       HtH8IHLgLg Lg(H     X HtH8IHLgLg Lg(H@     + HtH8IHLgLg Lg(Lp  Lx  LL$   HHۚHL\$`I[(Ik0IA\_^HL$WH0HD$ H\$HHt$PHH   DH  H  g H   H  HtG 3H  H  H  Hp  $ H   ˋH   HOp$HOp HOPHt HwPHwXHw`HO8 HO Ht Hw Hw(Hw0HOH\$HHt$PH0_ HL$SH0HD$ HH0 HK0趌HKp謌H    H     HH0[H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ }L_0L[ H\$hHt$pHP_L;v HH|$8LD$0HD$0HT$@L(D$0HfD$0菑H\$hHt$pHP_HHPWH  HD$hHXHpIHH3t$0MHHL$pN Ht
HL$8HHHD$8Ht$PHt$XHt$`    HtHHHHsHs Hs(D$0   H  H HD$ LLD$8HT$p?HL$PHtk Ht$PHt$XHt$`HL$8R HL$p;fHL$  I[Is I_HHPUVWATAUH@  HǄ$   HX)pEAHHHL$0HD$PH+D$HHH;         DBH$0   H   H\$PH+\$HHH H$@  7HH HHt w7HH HHk \7H$  H$0  & HH$    HE H$   HH$    H< H$   H H$    E3D$p  HH  H+@  HAM Ht
HL$`HIHD$`L$p  HHL$`-EQ  @   H  L
	 LD$`HT$0-f(HL$xHtV Ll$xL$   L$   HL$`7 HL$HHt' Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(H f(  H  L
8	 LD$`HT$0詳f(HL$xHt Ll$xL$   L$   HL$` HL$HHt Ll$HLl$PLl$XHL$0j HKHt[ LkLk Lk(HG f(X     X Ht
H$   HIH$   L$   L$   L$   @t0H  HP HD$ L$   LD$`HT$0Եf(.H  H  HD$ L$   LD$`HT$0Էf(H$   Ht L$   L$   L$   H$   e HL$xHtU Ll$xL$   L$   HL$`6 HL$HHt& Ll$HLl$PLl$XHL$0
 HKHt LkLk Lk(H f(H$  ($0  H@  A]A\_^]LD$HT$UVWATAUH  HǄ$   H$X  EIHHE3Dl$0IHL$8HD$XH+D$PHH;      AUEEH$   H   H\$XH+\$PHH# H$   3HHJ HH 2HH/ HH!g 2H$   H$   HH$   	 H H$   HH$   @ H H$   H	 H$    D$@  HH  H+@  H   o Ht
HL$hHIHD$hL$@  HHL$h   8 HtHIHLkLk Lk(D$0   Et'H  HA HD$ LLD$hHT$8ʲ&H  H HD$ LLD$hHT$8ӴH$   Ht L$   L$   L$   HL$hj HL$PHtZ Ll$PLl$XLl$`HL$8A HOHt2 LoLo Lo(H HH$X  H  A]A\_^]HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;v+ HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@HQ   L;   H;v HHD$@H\$HHnH;n v HH\$0Hl$8(D$0fD$0Hu E3LKdHHI;k wHtH3H;hsW Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PHu?HOHt HG    HG     HG(    HL\$`I[ Ik(IA\_^N HT$HL$SUVWATAUAVAWH   HD$ HHH  GH@  5Lp  I
    Ht
HL$pH3HD$pHǄ$       HǄ$       HǄ$       H  H$   HT$pHMLL; v L7H_ H9_v
 MtL;7t L;  Mu E3MM;{ r IH  LH  H+  HgfffffffHHHH?HL;  Mu E3MM;{ ro IH  PEHN H+NH*HHHHH?HL;r/ K<dHHFHH@  DMu	 E3MM;{ r Hq I} 1  HǄ$  IUHu3IM(H+HI] HH+HH;sHHCIE H$     H;v I} H|$0H\$8IM IuHH+Hu3#H;vL HtI;} t; H+H(D$0fD$PL$  A   HT$PIIuI;u v I} Hu E3LHI;K wHtH3H;H   H$   H$     HN H+NHHHHH?HL;r Hn   3HL H+LHHt/    H;rU HD4HHL H+HH;r؋H$   H$   H+HL;r H$   B,H$  L$+I;C   IUHu3IM(H+HI] HH+HH;sH+HCIE    H;v I} H|$@H\$HIM IuHH+Hu3#H;vw HtI;} tf H+H(D$@fD$`L$  A   HT$`I	IuI;u v) I} Hu E3LHI;K wHtH3H;Hs  HH$  I;H$   H$   H$   *H$   H$   H$   H$   H$   Mu  E3MM;{ ry  I(VH  H@  -IIE I+EH  H$   Ht HǄ$       HǄ$       HǄ$       HL$pw HĨ   A_A^A]A\_^][H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;v HM HtH;tr HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   蚃HkH;k v HHl$(H\$ (D$ fD$ Hu LLH<HHI;{ wHtH3H;~s H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\@SH H
 H      ?   Hǃ       ^   H   ,;L   H HHH [@SH HR
E3H     @@ǃ      D   H   H~ D   HD   L   HH [H\$WH HWR HHH
 HA`HIH HO8 HO v HOl L% LtH HH\$0H _HL$WH0HD$ H\$HHt$PHHX	H      ?H   Hǆ       $ ^   ,   ;L   H HWH   ?\L`] LH>] H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHE3D   ǆ      H     @@H   D   D   L   H HWH   [LF] LH$] H   HH\$HHt$PH0_HATH   HD$ HXHhHpHx HHHZIHtI;tCHtI;t.̄t$H;Y@t%HI8[ HtH*HE8HE8    H]@HHH+HLM3M~Hf(HE8f)HI;|LHU8HHuLEhLHU8HM 蛫tNH( HL$( HL$P H HD$PHT$(HL$h Hu HL$P Ht$0H^HtI;t,HtI;t̄t
H;]Pt%HMHD HtH)HEHHEH    H]PHHH+HLM3M~3fo
 fffff     Hf(HEHfWf)HI;|LHUHHL$(\Hǅ       H   H L$   I[IkIs I{(IA\H%L HL$WH0HD$ H\$HHt$PIHHH; HHRH! HF`H^pH6 HFhH~xH   H 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH H HHAhHIH HO8 HO  HO LO  LtH HH\$0H _HH   )xHXD)@fD(| ID)HD)PD)XfD(fDTfD(fDTfE(D)`EYD%>  fE/r)H@fA(fA(LHD$ fA(W?f(    )$   fA/rWfA(pf(fA(p=@ H$   E^LHD$ fA(YfA(\fA(>\]fA(qf(fA(pH$   E^fA(LHD$ f(XY= YfA(\fA(>\($   fWD(d$0D(T$PH$   fA/D(\$@D(L$`D(D$pvfW= f(($   HĨ   HT$HL$UVWATAUAVAWH   HǄ$   H$   EHHLq L+qI    Ht
HL$PH3HD$PHD$h    HD$p    HD$x    LD$P3H8HLH$   Hu4HMHtV HE    HE     HE(    HM 5       J Ht
HL$ H3HD$ 3H\$83HL$@3HT$HA   M;f  MM+L$(  Hu3H+HHH+HH;sLHHL$@H\$8	  HH;v/ HL$@H\$8Ht$ H$   H$   HH+Hu3$H;v HtH;t$ t H+H($   f$   L$(  A   H$   HL$ yH\$8LHL$@H;v HL$@H\$8Ht$ Huw E3HL$@H\$8HD$ LII;S wHtH3H;Ps> HL$@H\$8IM;w
HT$HL$   EtpE3IMthff     HH+HH;r HL$@H\$8H4H+HH;r H\$8IH+HHHI;sHL$@H\$8E3D$(       Ht
HL$PHIHD$PL$(  IHL$PdHT$PL$  I~HL$hHt L|$hL|$pL|$xHL$P I+  II HHL$PCIM   fD  HD$@H\$8H+HH;r H\$8HHD$pHT$hH+HH;r HT$hH4HE H+EHH;r HT$hHE9r.HD$pH+HH;rf HT$hD<HI;aHD$pH+HH;r8 HT$hHT$PISHL$hHt L|$hL|$pL|$xHL$Pf IHL$8HtM L|$8L|$@L|$HHL$ 4 HMHt% L}L} L}(HM  H$   H   A_A^A]A\_^]LD$HL$SVWATAUAVAWHPHD$ )t$@MLI\$Hu3LI9II;vH<    H LHu
Ht3Ll$(H\$0HcI;\$}_I$4Hh HHHh H;h r   H
`h [HH$   Htf(蒗HID H$   LHLD$(H$   H#:H$   HCH$   HIt$I;wt@I@ Ht/I;vL4    I( Hu
MtII?IwHUD  HcI;T$}ID IH@HI 賒(t$@HPA_A^A]A\_^[HLH HPHHUVWATAUAVAWH  HǄ$   HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(IHH$  HL$  LI|$ ufEWH$  H$   u fD(fE(H$  DY(D$  fE(H$   DYD$  H$(  D3H$  D HnHE3HuI/H;v%H    Hc HHuHtH$   H$   H^HHtH;tHtH;t̄tH;t+ HtHfHH$   IH$   H$   HHH+HLMIM~Hf(f)HI;|LH$   HEL$   H$  D5 D= D% D  L$   L$   $   I\$HtHH;  
HHtH;    H;_tHH Ht7HH;  H4    H Hu	H[  HL/H_HHH+HLMIM~=f    I$f(fYIf(fXHf)HI;|LHH$   cZLH$  LHH$  HtAXAYIH7f(fA(H$  YH$  X	f/,  fA/r	E  f(fATfA(fAWf/   f/= sMfD(fD(HH$   hfD(Y5( A
 $  H$  H$   D$   DD$xDT$p|$hT$`t$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHHjD   0   I $  H$  H$   $   T$xt$pDL$hDD$`DT$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHH¬DH$    AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]H8 3LD$PHT$HE3)t$ D$H')5 fTf/C v  "   U2 3LD$PHT$HE3ɈD$H(fTf/	 v  "    3LD$PHT$HE3ɈD$H(fTf/ v  "   (t$ H8LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCIS5HxHWH`HD$ HXHp HHHzHxfW@Ht4HHHHt̄t̄tH;t"H Ht
H<HH    H{HHH+HLM3M~%( fffff     Hf)HI;|LHHL$(_[- l$xH$   HNHtH3HAAHNHL$(HD$8D$@HD$H    HD$P    LD$xH$   HL$(cyHL$HH\$pH$   H`_H% HHX WATAUH`  LQH)p)xHCHHD$PHT$hIBHD$XHAHLRHBHAHBHA MHB HA(MHB(HA0HB0HA8HB8HA@HB@H$   H$   Iu
fWf(CH$   HT$PAh    H|$X fWuf(H$  H$   f( ;H$  H$  f/   f(Yf/   IE     A<$HoHt$@Hl$0H$  tH&HH$  HT$ HكH;HL$ HMHHHL$(LH+E3HH+HHH4CH;}$D$@fHHH;f)T|HL$(LLHK-  f(YX f/A$rfW A$H$   HT$PAh   ? HHwf(A\,$H$  $0  tH&HH$  HT$ HكH;HL$ HMHHH$   LH+E3HH+HHH,CI~H;}?$0  H$   f    fHHH;f^f)D|H$   LLH}A$\A^$AE H$  H$  L$`  I[8A(sA({IA]A\_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,C[H;}(D$8f@ HHH;f)T|HL$ LLHLD$hH- l$hI2H\$`Hl$xH@A\_^@UH   Hl$PH]PHuXH}`LehLHM )u0A0ID$(HHID$0HAID$8HAID$@HAID$HHA HBHH;vH
HuLH    H      H   HHH;w
HHH H+HL$PHHHFML$ M$t$@3HD$8   HL$0H9>HDIL$HH=   HEHPHE HT$(IT$HD$ Jt	HU H]PHuXH}`(u0LehHe@]H: HHhH_@UH   Hl$PH]pHuxHHFHHM H   HHFPL   )uPA0HAHFXLHAHF`HAHFhHA HFpHA(HFxHA0H   HA8H   HA@HBHH;v$H
HuLH    H      H   HHH;w
HHH H+HL$PHHID$LN@Lt$@HV3HD$8   I9<$HL$0HDHNHH=   HE8HD$(HE HD$ t	H H]pHuxH   (uPL   He`]H HHhH_)H\$UVWHpHBB8J@HHL$0HHBHAHB HAHB(HAHB0HA HHHxD$XL$`H$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}aD$XHT$0D$`ff@ fHf(HH;HfYf(fYf(Lf\f)L|HL$ LLH)H$   HHp_^]LH   HD$ LL$(HIHBIAHBIAHT$HHA(HHA0HBHA8HBHA@HBHAHHB HAPHB(HAXHB0HA`HB8HAhHB@ISHHHAHBHAHBHAHBHA HB 3ICICHT$(HL$Hî3H   H%J HHHWH`HD$ HXHp HHY   袹 3HtHHHHsHs Hs(H_8   v HtHHHHsHs Hs(H_p   L HtHHHHsHs Hs(H       HtHHHHsHs Hs(H   H\$xHK} HK0XHKpWH   [ H   M Hp     諸 HtHHHHsHs Hs(H   H     p HtHHHHsHs Hs(H      C HtHHHHsHs Hs(HL\$`I[ Is(I_H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ /HL_0L[ H\$hHt$pHP_L;v HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_ATH@HD$ H\$PHl$XHt$`H|$hHL3HH\$(H\$0Hz H+zHHt37 H	HHD$(H|$0HN H+NHHt,H;r HFHHL HHN H+NHH;rHT$(I HL$(H\$PHl$XHt$`H|$hH@A\H% Ht$WH 3HH9q vGH\$0fD  H_HKz HKp HG(HGHH;GuHHGH;w rH\$0Ht$8H _HWATAUAVAWH  HD$`HXHhHpAMHLIHC H+CHuII     Y E3Ht
HL$ HIHD$ L|$8L|$@L|$HHHL$hӶDHT$ HMD8$  AH\$8H;\$@va HD$ HD$PH\$X(D$PfD$PH|$PH\$XHt$@H9t$8v+ HtH;|$ t H;     DBH$   1 IH$   g HHS HHu MLI;[ r Hk H+kHHIti@ Hu MLI;[ r HC H+CHH;rj HCIH$    HHT  HH;rHu0 MLI;[ r HC H+CHH;r HCIH$    HHU N HT$hH$    HIHL$h H$    Hu MLI;[ r H0?H\$8HtJHt$@H;t6H@ HHt迲 L;L{L{HK諲 H0HCH;uHL$8蔲 L|$8L|$@L|$HHL$ { L$  I[0Ik8Is@IA_A^A]A\_HATHp  HD$XHXHpHxIIHL   DBHL$` Ld$HHD$pHD$PLLHHL$HHT$ HL$` Hx HL$ h t/HT$ HL$` H$  LHAHL$ 6 HL$`r L$p  I[IsI{ IA\L$D$HXH      )t$@D$xHD$x)|$0f(H#f(H;u,H
) H L
 LD$`Hv HD$ D$xHD$xHH#H;v,H
) HR L
; LD$`Hv HD$ f/
 w,H
{) H L
 LD$hHYv HD$ L$`HD$`H#H;v,H
<) H L
 LD$hHv HD$ XHL$`I躓Y(t$@X(|$0HXH\$Ht$WH 3IHt$8 HHH\$0HGHwHwHw Ht$@HH _@SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH0HC(HCH;CuHHCHCHCQHKHL$P3D$@HD$@HD$XHL$(HtIHIQH*XHC(HCH;CuHHCHC H0[H\$Ht$WH HAHHxHt HHHHtH;y(t%HI 9 HtHHF HF     HV HH~(H\$0HF Ht$8H _HL@WATAUH   HD$0HXHpMHL~H~H|$`fWD$pHu3L;HH;vJH    H LHuHt&3LD$HH|$PHt.HH;t̄t̄tH|$PLT$XHHH+HHHHH~5 MtIBHtHHHffA)HH;|LLHT$HILd$ LL$HL$   IH$   $   I      H$   I#I;   H% HL$XJ I$HT$XIHL$XO H HL$X I$HT$XIHL$X" H+ HL$X I$HT$XIHL$X M$IASHL$H 2
  HHT$PH   H|$H$   H$   I#I;tHHcH;|   Hц HL$X^ I$HT$XIHL$Xc HĆ HL$X1 I$HT$XIHL$X6 H׆ HL$X I$HT$XIHL$X	 M$IASH 2#H|$HH HL$H 22L$   I[ Is(IA]A\_LD$VWATH@HD$ H\$xIHHH\$hE3@ HWH;VthH\$(3D$`HD$`HD$0H\$8HtHHHHKSHHG(HGH;AuHHGHHHH9OuLgH(H\$pHH\$xH@A\_^H\$UVWH   HBBXHHL$0HAh   HHBHhHAHBHAHBHAHBHA HBHA(HBHA0HBHA8HBHA@H$   D$x H   HHh$   H$   tH,HH$   H$(  HكH;H$(  HMHHHL$ LH+E3HH+HHH4C`H;}#ff     LD$!HHiHH;|HL$ LLHt`H$0  HH   _^]HLH L@HPHHSUVWATAUAVAWH8  )p5V E3H0H8H@IMHHILt$hN,    ILL$`H$   HH$   LHT$pL;H
n Lt$xh  HH\$XHD$XHOL8L|$XK7H$   M  IBHIIML$  IA   H4IEM+@ ^H  H$  H$   H$  H$h  L$p  I.HH$   H$  HHHAHBHAH$h  HBHH$  HHAHBHAH$   HBHH$(  HHAHBHAH$   HBHCH$   $`  H$   H$   L$@  H$   HD$PL$P  H$   L$X  [L$  IEHHIHILt$xL|$XH$   Ht$`H$  H$   Hl$hLd$pH$  L$  HH+H~8Mt$@HD$8   LL$0HMLIHD$(   Ht$ 贽L$  H$  L$  HH@IIL$   H$   Ht$`Hl$hLd$p($   H8  A_A^A]A\_^][LI[IkIs WH   Hj3HHH   ICHD$ ICHD$(fHtHK3HC0HtH3HAA(HT$@HHAHBHAHN@HBHHHHFHT$0D$`L$hHD$xHHL$pH$   HHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   HH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,CH;}(D$8f@ HHH;f)T|HL$ LLH諭LD$hH-{ l$hIH\$`Hl$xH@A\_^HWATAUH   HD$`HXHhHp LLX HPHiHhHu3HuL9HH;vfH<    H LHuHtBLD$ Ht$(H}HHtH;tHtH;t ̄tH;t(I/ HtHLHD$ LH\$ H|$(HHH+HLMHM~2ff     HM IE f(f\fA)HI;}LD$ LMHT$ HL$@A$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMHM~6fАHD$ f(f^HE f(fXf)HI;|HT$0HL$@!L\$ L$   Ll$HHl$PL$   HT$hHL$A*I|$H|$0H$   HL$8HtLLOLOIHH+HLMM~&     IHf(fXf)HI;|HT$0IH$   n HL$ b L$   I[(Ik0Is8IA]A\_H\$WH   HًI@H;K4rDK0A+C8;sA;tHKPIC@SD;r  K0;g  +K8H$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPHLGLO^ D,[PHL$ LD$(LL$0fAnHHT$hH|$Pf(X^^L$XHHAHBHAHBHAYX HB$   MtaHMtHHIL;tMtHHIL;tMtHHIL;tzIHIHT$@H}'HKP褲C@H$   H$   HĠ   _C@H$   2HĠ   _HWATAUH   HD$ HXHhHp HL   謞 E3Ht
HL$pHIHD$pL$   L$   L$   LD$p3HK   a Ht
HL$@HIHD$@Ll$XLl$`Ll$hE33HL$@HT$@HE33HL$@HT$@HE33HL$@tMc$   L$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;v HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@XHt$XH;t$`vv H|$@Huf MLHI;K wHtHIH;Hs; HT$@HE33HL$@/HT$@HE33HL$@Mc\$DL$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;vn HT$@HtH;tY H+H(D$0fD$0L$   A   HT$0HL$@Ht$XH;t$`v H|$@Hu MLHI;K wHtHIH;Hsݾ HT$@HPE33HL$@Mc$   L$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;vc HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;v) HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@赦Ht$XH;t$`vӽ H\$@Huý MLHI;K wHtHIH;Hs HT$@HE33HL$@E$   AMcL$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;v޼ HT$@HtH;tɼ H+H(D$0fD$0L$   A   HT$0HL$@jHt$XH;t$`v H\$@Hux MLHI;K wHtHIH;HsM HT$@HE33HL$@AHT$@HHL$XHt耘 Ll$XLl$`Ll$hHL$@g L$   I[ Ik(Is8IA]A\_HHHVWATH`HD$ HXHh HH> HE3LaHQLAHi AL$ HtH(IHE LeLe Le(HSHm>IL9c   fW$    Hs    Ht
HL$(HIHD$(L$   HHL$(HT$(HxHL$@HtT Ld$@Ld$HLd$PHL$(; HH;{rHHL\$`I[0Ik8IA\_^DL$ HT$UVWATAUAVAWH   HǄ$   H$   AIHLIKE3MT$ M+T$HgfffffffIHHH?H   E3E3$     襖 Ht
HL$0H3HD$03HD$HHD$PHD$XHO H+OH*HHHH?HL;r HGI<IL$ I+L$HgfffffffHHHH?HL;r ID$ID$  DLD$0H9H} H9}vY HE HD$`H|$hHD$PHH|$HH;v3 HD$PH|$HHL$0HL$pHt$xH;v HL$0H$   H$   (D$pf$   ($   f$   (D$`f$   \$ L$   L$   H$   HYH|$HHt-Ht$PH;t@ H H(H;uH|$HHݔ 3HD$HHD$PHD$XHL$0 II0I(IL$ I+L$HgfffffffHHHH?HL;H$  @$(  H$   H   A_A^A]A\_^]HHHVWATH   HǄ$   HXHh HHE3D`AL$C Ht
HL$ HIHD$ Ld$8Ld$@Ld$HHT$ H0    HtH(IHE LeLe Le(Ǆ$0     HL$8HHt$@H;v6 Ht$@HL$8HD$ HD$PH\$X(D$PfD$PH\$PH|$XH;v HtH;\$ t H;   Hu׶ MLI;{ rö HH$   3HH$   dHHǥH$   Ht L$   L$   L$   H$   ˒ HuT MLI;{ r@ H0Ht$@HL$8%   賒 Ht
HL$`HIHD$`Ld$xL$   L$   HT$`HHL$xHtF Ld$xL$   L$   HL$`' HL$8HtHH|$@H;t9HYfHHt L#LcLcHK H0HCH;uHL$8ԑ Ld$8Ld$@Ld$HHL$ 軑 HL$   I[(Ik8IA\_^H\$Hl$ WH03IHH9Z ~GHt$@)t$ fWHfHL$HHtHGHXDHcH;G |(t$ Ht$@H\$PHl$XH0_H\$Hl$ WH@3IHH9Z ~eHt$P)t$0)|$ fWHHL$XH`tHG@f(XJ HGH^tHcH;G |(|$ (t$0Ht$PH\$`Hl$hH@_@SH H肺: H      ?   Hǃ       ^   H   ,;L   HW HHH [@SH HE3H     @@ǃ      D   H   HW D   HD   L   HH [HL$WH0HD$ H\$HHt$PHH蘹H      ?H   Hǆ       4 ^   ,   ;L   HV HWH   L LH~ H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHE3D   ǆ      H     @@H   D   D   L   HV HWH   uL LHd H   HH\$HHt$PH0_HLH HPHHWH`HD$0HXHLJ0HL@LC(HIC(fWV C(H\$xH0H\$HH{HtHH;tHHtH;t ̄tH;t&H/ HtHHE3E3LE3H{HHH+HHHH~)(
v fD  Hf(fBWfB)IL;|LLHHL$@H$   H`_H\$Hl$Ht$WH IIHHHHtڌ LHgfffffffH3L+HsIHHH?HHD Hl$8HHS H;HKHDHt$@H{H\$0H _HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q ~5L5 fWHMf(f(AAID;m |LHT$(HZHHXHHtH;t%HtH;t̄tH;_tH> Ht
HHH7H_HHH+HLMM~!    HE f(Hf)HI;|LHHxHL$(Ԯ L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;t̄t̄tH\$P3H;tH
8 Ht
HHHHHwHH+HLMM~#(z ff     HHI;f)D|HL$ LH.LD$XH- l$XHxH\$PHl$`Ht$hH@_HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA D$ L
S DB HS H
 pL[L\$ L
hS EG HS H
 YIc_ H\$hfWt$xHuE3IH<HH;v苫H<    Hɬ HHuHtgE3H$   H$   Ht.II;t5̄t+̄t!IH$   HHH+HLMIM~( f)HI;}
H$   LH$   HL$`aIc_ H\$ht$xHuI/H;v蝪H<    H۫ HHuHtyHL$HH\$PHt$I;tZ̄tP̄tFH\$PHHH+HLMIM~( f)HI;}HL$HLHT$HHL$`虑Ic_ H\$ht$xHuI/H;vթH<    H HHuHt豩H$   H$   Ht.HH;t肩̄tx̄tnHH$   HHH+HLMIM~*( fff     f)HI;}
H$   LH$   HL$`裐Ic_ H\$ht$xHLH$   H$   Ht$H;tĨ̄t躨̄t谨H$   HHH+HLMIM~'(G     fA)HI;}
L$   LH$   HL$`Mcw Lt$ht$xA   MIHL$8L:Mt$L;t̄t
̄tL;t$@t,HL$88 MtILHD$8MLl$8Ld$8Lt$@IHH+HLMM~-(h IIHHHfff     f) HHuMHT$8HL$`A݉\$0Dl$X=۰ fff     $  ;/  AA  ~CIL$  ffff     H$   Mf(f(HHA;w |E3L$   HT$`IHHXHtHH;t躦HHtH;t蛦̄t葦I;t(Iʧ HtHELHD$8MLl$8LH\$@HHH+HLMIM~fHf(fA)HI;|LHT$8HzHL$`U    DBH$   m H$  H$   H$0  H$   L$   L$  HT$8H$   rH$   H$   , Hx H$   ֥ t7H$   H$    H$  LHAH$    L$   HL H
 0mL$   L$   H$  H$   L$   L$   IHH+HLMII;}I
If(fXf)HH$   I{H$   H$   H$   H$   HD$HH$   H$   H$  H$  H$  H$   H$  芭\$0É\$0H$   ڣ E3L$  Lt$@Ld$8fW= \$0fn$  H$  H$   p$  H$  HL$HpI_H\$hHD$HH$   H$   HL$`HHHAHBHAHBHD$HH$  Ht$PHHH+HHHH~7HfB(f)D$`HL$`HD$HfB(fYfB)IL;|LLH$  H$   ~g$  HD$HH$  H$  H$  cH$   H$  HFHT$HH^HI H$    H$    HL$H H$   ӣ ($@  ($0  HP  A_A^A]A\_^[Hl$Ht$H|$ ATH@HqfWILHD$8Ht$(Ht.HH;t̄t̄tH\$P3H;tH	/ Ht
HHHHHwHH+HLMM~(q HHI;f)D|HL$ LH.LIHH\$PHl$XHt$`H|$hH@A\HATAUAVH  HD$ HXHhHpHx )p)xD)@D)HD)PD)XD)xD)hIMHfD(fD(fDW
 A   L$P  D9%    D- D*$ D%ٳ 3H9^~pfA(AYfA(AYfD(D\3fE/vf(f(HYAYD
 fA(fA(H-HHHcH;F|MIHuAD;% fD;%      DBH$  n    DBH$  V fA(H$    H$  Ξ M] IASM] IASH$  H$   HH$   H$   HHT$xH$   LHH H$h  j LA HHL$P4 LHH$@  ' LG HH$    LHH$    LG HHL$(۞ ME HIAHL$(	 H$    H$    H$@  ܞ HL$PО H$h   HL$x H$    H$   H G HL$(e IE HT$(IHL$(j H$   H$   2L$  I[ Ik(Is0I{8A(sA({E(CE(KE(SE([E(cE(kIA^A]A\@SH0
A rA LD$H)t$ Hh5  fTf/ vH H
\@ 
F n LD$H$fTf/x vHG H
 @ H(t$ H0[HHHWATAUAVAWH  HǄ$  HXHp )p)xD)@D)HD)PD)xD)hD)XMMfD(f(fW @HH$@  H$   H$   H$X  HHHAHB   'z HtH$   H33HH$   H$   H$   H$   E3E3H$   IkH$   iA   L$H  $   D$   fEWD
 D+ Dڮ ff     D;-u s  I|$   dy Ht
HL$pHHHD$pD$(  L$(  HHL$pNfff     HcI;|$   f(AYfA(AYf(\fA/vH$   f(AY"D
k f(fA(H$   Z(f(H$   H$   H+HH;r H$   4H$   H$   H+HH;r՛ H$   I$HH*H$   H$   H$P  L	LH$0  A   x Ht
H$   HHH$   H$  H$  H$      w Ht
H$(  HHH$(  H$@  H$H  H$P  H\$8D$0 D$( H$   HD$ L$(  LD$pH$@  I   Yw Ht
HL$@HHHD$@H\$XH\$`H\$hHT$@IFH5 H$  H$  H$(     v Ht
H$  HHH$  H$  B*H$  ƀ   H$  H@H$  H H$  H@H$  H$  H$(     ~v Ht
H$  HHH$  H$  )H$  ƀ   H$  H@H$  H H$  H@H$      v Ht
H$  HHH$  H$   H$(  H$0     u Ht
H$8  HHH$8  H$P  H$X  H$`     u Ht
H$h  HHH$h  H$  H$  H$  LL$@L$   H$   H$  wH H$X  H$0  H$`  H$  H$h  E3MH$X  IEeMIIg  H@ H$X  H$  HL$XHt?Ht$`HH;t-HOHtyt H_H_ H_(Het H0HL$XUt H\$XH\$`H\$hHL$@<t H$@  Ht)t H$@  H$H  H$P  H$(  t H$  Hts H$  H$  H$   H$   s H$0  H$   Hts H$   H$   H$   HL$ps D;-   H$   Ht,H$   HH;tH H(H$   Cs H$   H$   H$   H$   s   H H$X  H$  HL$XHt?Ht$`HH;t-HOHtr H_H_ H_(Hr H0HL$Xr H\$XH\$`H\$hHL$@r H$@  Htr H$@  H$H  H$P  H$(  _r H$  HtLr H$  H$  H$   H$   'r H$0  
H$   Htr H$   H$   H$   HL$pq A   DBH$0      DBH$  y fA(H$@    H$   IIPIIPH$  H$  A HHT$@H$0  + HHT$pH$0   LHL H$    Lx@ HH$(  [ LHH$   N LvL HH$  - LHH$X    L8L HH$    MHIAH$   + H$X   H$  
 H$    H$(   H$    HL$pԒ HL$@Ȓ H$   HK H$    IH$   IH$    H$   H$0   H$   Ht,H$   HH;tH? H(H$   o H$   H$   H$   H$   co 22L$  I[@IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_@UH@Hl$ HE H]0Hu8H}@LeHHLLBHL;vL
MumJ    H=   w9J   HHH;w
HHHv H+LL$ II$J    H LHuHt誐HG3H97IDHH=   MD$I$IL$<t	H H]0Hu8H}@LeHHe ]HL$SUVWATH   HD$ IHH0! HHQLAIA I+AHHAH ImHOPLGHW_LgH   H$      m 3HtH(HHE fW$   L$   IH莞H vfD  HHEHOH9sHH;_rZH28 HL$( HL$PӐ H HD$PHT$(HL$h HV HD$PHR
 HL$Pl HHĐ   A\_^][HHPWATAUH   HD$ HXHhHp LLHH)H$   HH$   H;v H$   H$   HH;v̏ H$   H$   Hl$hHl$0H\$8(D$0fD$0H;v Hl$hH;t*fffff     H1 H u	H(H;uHD$0HtH;tN H;u.H HL$@' HT$@HL$hHL$@+ HT$hI.M$  I$@  I$  ANH$   Ht2H$   H;t H׍ H(H;uH$   Hk 3H$   H$   H$   HL$hj I豔L$   I[ Ik0Is8IA]A\_HL$UVWATAUAVAWHpHD$ H$   LaL II  z3 LAǆ        AA+iɫA+A  utA  A   uAǆ       AA+iD+E  uEtAA  A   uAǆ     I  I  I  I  SI  ƻA  I  I  <I  I@  踻Ip     i 3HtHHHHsHs Hs(M     Wi HtL(HIE IuIu Iu(A  A  M     i HtL8HIIwIw Iw(LH$   A  -  fD  HSHuHHK(H+HH{ HH+HH;sL'HGHC    H;v	 H+Hl$0H|$8HK LkHI+HuH"L;v֋ HtH;+tƋ I+H(D$0fD$@L$   A   HT$@HitLkL;k v H+Hu{ LL] IL I;K wHtHE HH;HsM IL$   A  L;M  HǄ$   HSHuHHK(H+HH{ HH+HH;sHHGHC    H;vҊ H+Hl$0H|$8HK LcHI+HuH"L;v HtH;+t I+H(D$0fD$@L$   A   HT$@H2sHkH;k vR HHuD LLHD I;C wHtH3H;Fs II@  AMI@  I  UIH$   HpA_A^A]A\_^]HT$WH0HD$ H\$@Ht$XHH3t$PN/f HtHHHHsHs Hs(D$P   H@  H  ALHH\$@Ht$XH0_H\$WHpI IHLHT$0H)t$`f(P(LOLWt$PLH$   LT$ HD$(IL\$HHH+3HLMM~;fff     II
f(HI;fYDfXDf)D|HT$ HL$@HL$0 L$   L$   HHH$   (t$`Hp_tH\$Ht$WH HHHxHtHH;tنH;yt%HI HtH苷HFHF    HVHH~=H\$0HFHt$8H _HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz Hu3H8HH;vH    HW HuHt3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVI   DBH$    L$   HT$@H_f(D$PHT$hH$    Hx @HL$h @t,HT$hH$   τ MHIAHL$hv t$XHD$XI#I;u+HD HD$ L
 LD$PH. H
 X|$8É\$0H$   b I      H$   L$  L$  |$8\$0fnF^IL$Hy ufW
H$  1fAnt$ Y5D 
 X
č YXXHL$@u f(($  ($  H  A^A]A\_^[HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0[GxfEWfA.zJ  D
V. fA/6  HGPLG`HHOPP8MMHHOPs(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  IH$  I#H      H;vH3  \- _ fD(f/v   HcD D%t @ HD$0H;t5HKHT$8l$Xk(HKHT$HߗHK0HT$`їHGPLG`HHOPP8MMHHOP}s(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  H$  I#H      H;vH  \HufA/vEGxAYHufD/v,GxAYGxfA/   fA.tkHD$0H;t6HKHT$8l$Xk(HKHT$H訖HK0HT$`蚖HL$`F HL$H; HL$80    H\+ H$    HL$xB H* HD$xH$   H$    H7 HL$xQ^ H* H$    HL$x Hӄ HD$xH$   H$    H HL$x] HL$`r HL$Hg HL$8\ L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HHHWATAUH  HD$pHXHpMIHHHHL$@ L$  M$LH$   IA$   t`H$   HuLLd$0H$  HD$(Ll$ LL$  HH$   H^ XE3LH$   HMH$   L$  HH"H H$   2L$  I[(Is0IA]A\_HT$WH0HD$ H\$PHHD$@    HALHHL@IIHHGLHHL@HMtMtHHIL;t~Mt:MtHHIL;t}MtHHIL;t}IIHHHmHH\$PH0_LSVWATAUH  IXE3IILH  IkMsHD$0M{ L$@  HD$ A)sICL4   HHD$(HHGAH+Hl$XH$   f(BYHH$   Ah   H$   HGHHAHGH$  HAHGHAHG HA HG(HA(HG0HA0HG8HA8HG@HA@HH$   H$   HFBY4H+HHL$hHD$PHHHFHAHFHAHFHAHF HA H$   HL$PH$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@H$h  HB@H$   $X  Y H$   HL$ $  Ll$0Hl$8"IMHL;q($  L$8  L$(  H$   H  A]A\_^[LI[IkIs WH   Hj3HHH  HD$0HD$ ICHD$(HtHK3HC8HtH3HAA0H$   HHAHBHAHBHA HBHA(HN@HB HHHHFH$   $   $   HD$8HHL$0HL$HHHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   .HH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$0Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,CH;}(D$0f@ HHH;f)T|HL$ LLHLD$hH-˂ l$hImH\$`Hl$xH@A\_^HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   HSHH_HGPLG`HHOPP8L$   MMHHOPHHL$@Ps(HGPHHOPf(X9   ~7ff     HGHLt$(Ll$    LGPHHOH;   |s(HGPHHOPX$   HH$   H#H      H;vHYw  \f(T f(5L f/vNHOh0f/v?HD$@H;t5HKHT$H/l$hk(HKHT$XHK0HT$pf/vf(s(HGPHHOPX   W0fWC HWf(I#HL$pox HL$Xdx HL$HYx IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      范HSIPI|$ID$PMD$`HIL$PP8L$  MMHIL$PHH$   ;NH$   H$P  %NH$   H$  NH$   H$  MID$PLH$   IL$PP(H$   HHHu33H;vuHHv HHuHtwuH$   H$   H$   HHtH;t@uHtH;t+ūt!uH;t*]v HtHإHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   sIH$   HHu3=HH;vjtHHu HHuHtJtH$   H$   H$   HtH;ttHtH;tt̄tsH;t*:u HtH赤HH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   QHIt$(Hu39HH;vNsH    Ht HHuHt*sH$   H$   I\$(HtHH;trHHtH;tr̄trH;t*	t HtH脣HH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ GfEWfA($   w(ID$PHIL$PfD(DX3퉬$  D%u{ D$   A$   A$   D-҄ A9$   |  D D fH$   H$  D$   HuH5HH;+  H4    Hr HHu	H  HL$pH\$xHt(HH;      H;t%]r HtHءHHD$pHHL$pH\$xHHH+HLMHM~(k f)HI;}HL$pLHT$pH$  FXHp  fAW$  IL$h)fA/  H$   H;tAHOH$   $   o(HOH$   ʅHO0H$   蹅Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I)H$   H;Z  HWH$   o($   HWH$   HW0H$     H$P  H;tAHOH$X  ˄$x  o(HOH$h  謄HO0H$  蛄Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I(H$P  H;tAHWH$X  o($x  HWH$h  HW0H$  Ճ  A$   $  f/vSH$  H$  衃$  $8  H$  H$(  zH$  H$@  en\J f(IL$h&f/vQH$  H$  1$  $8  H$  H$(  
H$  H$@  H$  H$   #f($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$pCM$L$   L$   H$   IASHt:HL$pm E$   E9$   }={lulolilHL$pm HL$pm Il̋$  A$   fn$   ^H$  H;tAHOH$  蔁$8  o(HOH$(  uHO0H$@  dw(ID$PHIL$PXA$   AT$0fAWIT$f(H$  H}H$   l H$   l H$   l H$   l H$  l H$  |l H$  nl H$@  _l H$(  Ql H$  Cl H$  4l H$h  &l H$X  l H$   	l H$   k H$   k HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   v.HSHH_HG`LGpHHO`P8L$   MMHHO`*HHL$@As(HG`HHO`f(X9   ~7ff     HGXLt$(Ll$    LG`HHOX;   |s(HG`HHO`X$   HH$   H#H      H;vHh  \f(F f(5|r f/vNHOx"f/v?HD$@H;t5HKHT$H_~l$hk(HKHT$XF~HK0HT$p8~f/vf(s(HG`HHO`X   W0fWs{ HWf(ISHL$pi HL$Xi HL$Hi IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      ,HSI耯I|$ID$`MD$pHIL$`P8L$  MMHIL$`軶HH$   k?H$   H$P  U?H$   H$  ??H$   H$  )?ID$`LH$   IL$`P(H$   HHHu33H;vfHH	h HHuHtfH$   H$   H$   HHtH;tpfHtH;t[f̄tQfH;t*g HtHHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   :H$   HHu3=HH;veHHf HHuHtzeH$   H$   H$   HtH;tMeHtH;t8ēt.eH;t*jf HtHHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   9It$(Hu39HH;v~dH    He HHuHtZdH$   H$   I\$(HtHH;t&dHHtH;td̄tcH;t*9e HtH贔HH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ I8fEWfA($   w(ID$`HIL$`fD(DX3퉬$  D%l D$   A$   A$   D-v A9$   |  Du D* fH$   H$  D$   HuH5HH;+  H4    Hc HHu	H  HL$pH\$xHt(HH;      H;t%c HtHHHD$pHHL$pH\$xHHH+HLMHM~(\ f)HI;}HL$pLHT$pH$  vIH>a  fAW$  IL$xfA/  H$   H;tAHOH$   w$   o(HOH$   vHO0H$   vLt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I%H$   H;Z  HWH$   Nvo($   HWH$   /vHW0H$   v  H$P  H;tAHOH$X  u$x  o(HOH$h  uHO0H$  uLt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I$H$P  H;tAHWH$X  5uo($x  HWH$h  uHW0H$  u  A$   $  f/vSH$  H$  t$  $8  H$  H$(  tH$  H$@  tn\< f(IL$xf/vQH$  H$  at$  $8  H$  H$(  :tH$  H$@  %tH$  H$    f($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$p4M$L$   L$   H$   IASHt:HL$p_ E$   E9$   }=]]]]HL$p^ HL$p^ y]̋$  A$   fn$   ^H$  H;tAHOH$  r$8  o(HOH$(  rHO0H$@  rw(ID$`HIL$`XA$   AT$0fAWIT$f(H$  HwH$   ] H$   ] H$   ] H$   ] H$  ] H$  ] H$  ] H$@  ] H$(  ] H$  s] H$  d] H$h  V] H$X  H] H$   9] H$   +] H$   ] HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   *HSHH_HGhLGxHHOhP8L$   MMHHOhZHHL$@
3s(HGhHHOhf(X9   ~7ff     HG`Lt$(Ll$    LGhHHO`;   |s(HGhHHOhX$   HH$   H#H      H;vHY  \f(J7 f(5c f/vQH   Jf/v?HD$@H;t5HKHT$Hol$hk(HKHT$XsoHK0HT$peof/vf(s(HGhHHOhX   W0fWl HWf(ItHL$pZ HL$XZ HL$HZ IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      (HSI谠I|$ID$hMD$xHIL$hP8L$  MMHIL$hHH$   0H$   H$P  0H$   H$  o0H$   H$  Y0ID$hLH$   IL$hP(H$   HHHu33H;vWHH9Y HHuHtWH$   H$   H$   HHtH;tWHtH;tW̄tWH;t*X HtH8HH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   +H$   HHu3=HH;vVHHX HHuHtVH$   H$   H$   HtH;t}VHtH;thV̄t^VH;t*W HtHHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   *It$(Hu39HH;vUH    HV HHuHtUH$   H$   I\$(HtHH;tVUHHtH;t7Ūt-UH;t*iV HtHHH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ y)fEWfA($   w(ID$hHIL$hfD(DX3퉬$  D%] D$   A$   A$   D-2g A9$     Dg DZp fH$   H$  D$   HuH5HH;;  H4    HU HHu	H  HL$pH\$xHt(HH;      H;t%T HtH8HHD$pHHL$pH\$xHHH+HLMHM~(M f)HI;}HL$pLHT$pH$  :HnR  fAW$  I$   fA/  H$   H;tAHOH$   Fh$   o(HOH$   'hHO0H$   hLt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I!H$   H;Z  HWH$   {go($   HWH$   \gHW0H$   Kg  H$P  H;tAHOH$X  (g$x  o(HOH$h  	gHO0H$  fLt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I H$P  H;tAHWH$X  bfo($x  HWH$h  CfHW0H$  2f  A$   $  f/vSH$  H$  e$  $8  H$  H$(  eH$  H$@  eq\9- f(I$   F	f/vQH$  H$  e$  $8  H$  H$(  deH$  H$@  OeH$  H$   *f($   H$   H$  H$  H$  L$   IHH+HLMHM~1ffff     HD$pH$   f(fXf)HI;|H$  HL$p%M$L$   L$   H$   IASHt:HL$p/P E$   E9$   }=NNNNHL$pO HL$pO N̋$  A$   fn$   ^H$  H;tAHOH$  c$8  o(HOH$(  cHO0H$@  cw(ID$hHIL$hXA$   AT$0fAWIT$f(H$  HhH$   O H$   O H$   N H$   N H$  N H$  N H$  N H$@  N H$(  N H$  N H$  N H$h  vN H$X  hN H$   YN H$   KN H$   =N HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]Ht$WH0HD$`HHHD$ D$@    Y    t@W H   HVxH\$HH\$H   ^nx   ,;L   HHt$PH0_H\$WH0HD$`HHHD$ D$@        tS HWxH   kHH\$HH0_LMK ECISIKSVWATAUAVAWH  HǄ$P  A)sA){MELHE+Hj HD$ L
yj MCH^ H
/ 誄H2 H$   dK IH$   IH$   dK -q $    $  5jT $  =p $   $   
 $   MIH $   HHPH$   nHHPH$(  n$   < $   $   fWL$HD$@E3D|$DH
j |$@   Ic   $      t$P A;  AAHHL$XJ HCj H$   I GLt$8HD$XHD$0H$   HD$(D$ E3ҋxH$   I HL$XI AE D$ L
- D$   H H
/ wHGHHHL$ L
 EE H H
 vLt$0HGHD$(GD$ LOLH$   I諜2H$P  L$h  D$`  L$X  D|$D$   t$Pu?HT$XH$   ߳HH$(  HL$hI HL$XI    H$X  H$   蝳L$   H$   /HH$(  H$  sL$   H$  .LHHL$X-HH$(  HL$h>I HL$X3I H$   $I H$   I fn$ f(^H$  H$(  L$   H$   -HH$   H$  sLf(H$X  .LHHL$X/-HIHL$hH HL$XtH H$   eH H$   WH Ɖt$PH
mg MIHoLRg ;LIg H$P  L$h  D$`  L$X  D$PD|$D$   $   f/   f/$         DBH$  E H9 H$  qHH pHL$HE HHP pA}H H$  pH H$  pHT$XH$  |E MHIAHL$X#F MIASD$@ H$  NE    A}$   |$H   f/$         DBH$  D H9 H$  pHH oHL$HD HH oHT$XH$  D MHIAHL$XSE MIAS|$HD$@ H$  xD H$(  AD|$DHWHL$XjHIAHL$hE HL$XE H
d bLD$ L
 H H
T H$8  E H$(  E H$   E H$   }E D$H($   ($  H  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/Hb HD$ L
ub L$   Hf H
/ fA/w/HSb HD$ L
?b L$  H H
 ̉̋$  /Hb HD$ L
b L$  H H
 2|HHPH$  fIE HPH$p  ffE(D% U $   fn=?h YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhH H$  =B H$  ~C HE H$  H$  H$  0B HE H$  H$  [;Hu3HH$   1iHD$pHHL$xH$   H$   H, H$   A L$  I$H$   IH$   A H H$   `A I$H$   IH$   _A A $   AA   D=nD D5S D  G D$ L
 D$0  Hk H
 7oM]ICHD$ L
+ DG HX H
i nLd$0IEHD$(AED$ MMME H$  HAuHH$   H$  sHH$p  H$   kA H$   ]A    H$  H$  +Lf(H$   &HH$p  H$  okL
 HL$@z&LHH$   %HH$p  &H$   @ H$   @ H$   @ H$   @ fAnf(z ^HT$@H$p  tL
H H$   l%HH$  H$  jLf(H$  %LHH$   $HH1H$   
@ H$   ? H$   ? H$   ? AƙA} &	  fA(MHIfD($  fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(HtD  DX HI;IDH;tHufH*HyX D^HT$pI^fD(Ⱥ   DBH$  <    H$P  n; HH\ H$   gHHu3
H HcHHHW	   H$p  (; HAH; HH JgHH:: HHu3
H HcHHHW   H$@  ; LHu3
HHcHHISA   H$   : HfA(H; HHx fHHu3
H HcHHHW   H$0  \; HH9H9 HHu3
H HcHHHW   H$`  
: HfA(HA; HH *fHHu3
H HcHHHW   H$  : HH19H89 HHu3
H HcHHHWfA(H: ; +fn^5V $       Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHu; HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;v; HL$`H\$XHt$@H$P  H$X  HH+Hu3$H;vU; HtH;t$@tC; H+H($P  f$  L$   A   H$  HL$@H\$XHHL$`H;v: HL$`H\$XHt$@Hu: E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps: HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;vL: HL$`H\$XHt$@H$`  H$h  HH+Hu3$H;v: HtH;t$@t9 H+H($`  f$  L$   A   H$  HL$@VH\$XHHL$`H;v9 HL$`H\$XHt$@Hu9 E3HL$`H\$XHD$@LHT I;S wHtH3H;PsZ9 HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;v9 HL$`H\$XHt$@H$@  H$H  HH+Hu3$H;v8 HtH;t$@t8 H+H($@  f$  L$  A   H$  HL$@Ht$XH;t$`vs8 H\$@Huc8 E3LHI;K wHtH3H;Hs98 H$   HHT$@PfE/vH  H$   {aE2fE/vH H$   ]aE2AE D;~"fE/wfE/vH H$   *aH$   H$  5 M$HIAH$   6 E   fA(A\A^fATf/ vmH H$   ;6 I$H$   IH$   :6 H# H$   6 I$H$   IH$   6 HL$XHtP HD$X    HD$`    HD$h    HL$@+ H$  5 H$  $   D;$  uoH  H$   r5 I$H$   IH$   q5 H H$   <5 I$H$   IH$   ;5 E2AE$   =Z HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	I+ H$  5 H$p  5 H$   5 H$  5 L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H   2 H      Q H   H   H   H   H   H-C6?H   H?H   H-q=H  HMbP?H  Hǃ  '  H      ?H8  H:0yE>H   H(  H@  H     @H0  H     @@HH  HH\$HH0_HT$VWATH`HD$ H$   HHLAL+HgfffffffIHHH?HH;   HyNHH$   HK H$   H$   H$   H;HCHLH\$(3HD$0H~LHSHCHD$0HyHHL$(ljHD$0Ld$(H\$8HD$@    Ld$HHD$PLK(LHT$8HL$HDdLLHH3H$   H`A\_^HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$07	   fEWfA.zU  D
 fA/A  HG`LGpHHO`P8MMHHO`$s(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  IH$  I#H      H;vH/  \ F
 fD(f/v   HcD'C D%B HD$0H;t5HKHT$8vEl$Xk(HKHT$H]EHK0HT$`OEHG`LGpHHO`P8MMHHO`~s(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  H$  I#H      H;vH.  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$83Dl$Xk(HKHT$HDHK0HT$`DHL$`/ HL$H/ HL$8/    H H$   p. HL$x/ H2 HD$xH$   H$   i. H HL$x H? H$   . HL$x]/ HE2 HD$xH$   H$   . HR HL$xl HL$`. HL$H. HL$8. L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0   fEWfA.zU  D
 fA/A  HGhLGxHHOhP8MMHHOh{s(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  IH$  I#H      H;vHm+  \ 	 fD(f/v   HcD> D%> HD$0H;t5HKHT$86Al$Xk(HKHT$HAHK0HT$`AHGhLGxHHOhP8MMHHOhzs(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  H$  I#H      H;vHN*  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$8?l$Xk(HKHT$H?HK0HT$`?HL$`x+ HL$Hm+ HL$8b+    H H$   0* HL$xt+ H\. HD$xH$   H$   )* Hi HL$x H H$   ) HL$x+ H. HD$xH$   H$   ) H HL$x, HL$`* HL$H* HL$8* L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HL@HHUVWATAUAVAWH  HǄ$  HX)p)xILH    E3Ht
H$   HIH$   L$   L$  L$     F Ht
H$  HIH$  L$0  L$8  L$@      Ht
H$  HIH$  L$  L$  L$      Ht
H$  HIH$  L$  L$  L$       Ht
H$  HIH$  L$   L$(  L$0  Hu H$   ' H$   H$   iH$   ' H+ H$   e' H$   H$   OiH$   `' LH$  HASAEH$  IE3E3H$  ILL$  H$  HAS(L$8  L+$0  IgfffffffIILIIH?LH$  H+$   IHLIIH?LH$  H+$  IHHHHH?HIIO$Ld$`H$  HtHXIHh H$P  .& Lc8  A+<  LcH$  HL$8Ld$0LD$(LT$ LLHH$     DBH$P  % HG H$   % H-KA H$  H$`  H$   H$   H$  % H$   % HG H$  a% H$0  H	# H$8  H$  H$@  [% H$  D% H$   HtHXIH7 H$   $ LHH$  vH H$  $ H$  H" H$  H$  H$  $ H$  $ L$  L$   H$  H$   H$  H$   H$       u<MLHH$   &HH$   l@MLHH$   F'$ D$xHF H$h  # H)F H$   # H$   H$P  z" H$   # ^H H$`  $NHȋa" HHǼ 
NHH# # H$  H$P  " $  D$t0  D$p   t)tttA   A      D,  H  H$   EL$0  E   H$   HD$PAA+@ B' H$  H$   " HH$h  H$   " H$   HL$8H\$0HD$(D$ DL$tD3AܣHH$0  HL$ L$  LH$   HPHH7H/j H$   H$   1# Aę|$pu.Lt$ LLIH$   袤LHH$   /1AE;H$  u" +D$xfn^= H$h    @   1  HC H$   ! H$   H$P    H$   z! D$     L
- L. 3H  HHRH3 H$   ! H$   H$  H$  H$   ! LH$  HAS H$   H$P  *  HH$h  p  H$     L$  IE3H$   H$h  E HH$h  +  H$     ! D$|$  D$p0  D$t   t+tttE3D   E3D   D   ,  H
 H$   D+E3E  H$   HL$PfD  B$ H$  H$    HH$h  H$    H$   HL$8H\$0HD$(D$  DL$pED5 AڠHH$0  HL$ L$  LH$   HPHH5H-g H$   H$   /  Aę|$tu.Lt$ LLIH$   蠡LHH$   -.AE;H$  s +D$|fn^5 L$  f(f(H$   boL$  f(f(H$   EoL$  f(f(H$   (ofW     HtH$H  HE3E3IH$H  L$`  L$h  L$p  L$  IT$ I+T$Hf(H$H  (D<  E"  fAn5' ^H$  H$  H+HHu H$  f(Y?IH$h  HL$`  I+HH   Ld$`J,    ffffff     H$  H+HJ#H;rB H$  H$h  L$`  I+HH;r L$`  f(Y/AHHH$h  HL$`  I+HH;s
H$  nL$      tm^H H
| GHȋT HHҵ FHH    HH FHH  H$      tH$    H$  HMpH$   'E H   H=HMI Hp  H$H     H  H$h  x L$  IH$  I;v L$  H$  H$p  H\$`Ht$hI;v H$p  H\$PH|$X(D$PfD$PHu] MLH0I;{ wHtHIH;xs2 H|$X     Ht
H$8  HIH$8  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$8  #3H$  HH$   H;v H$  H$   H$   H\$`Ht$hH;v H$   H\$PH|$X(D$PfD$PHu_ MLH(I;{ wHtHIH;xs4 H|$X     Ht
H$x  HIH$x  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$x  ?H$  H9$  v H$x  H$   H$   H$8  HH$0  H;v H$8  H$0  H$  HL$PH|$XH;vY H$  HL$`H\$h(D$PfD$P(L$`fL$`($   f$   D$@D$ LL$PLD$`H$   H$x  H  H$8  #H   H$x  H   H$(  H$  Ht0H$  H;tH H(H;uH$  H  L$  L$  L$  H$x    H$P  HtLH$X  H;t:HYHHt  L+LkLkHK  H0HCH;uH$P  k  L$P  L$X  L$`  H$8  F  H$`  Ht3  L$`  L$h  L$p  H$H    H$h   H$   H$h   H$  v Hv H$  H$  X H$  H$@  A H$0  H$  * H$  H$P  [ H$  Ht\  L$  L$  L$  H$  7  H$  H$   ƉH$0  蹉L$  L\$PH$   H$  H$  H$   Ht2H$(  H;t Hg H(H;uH$   H  L$   L$(  L$0  H$    H$  Ht/H$  H;tH H(H;uH$  HH  L$  L$  L$   H$  #  H$  Ht/H$  H;tH H(H;uH$  H  L$  L$  L$  H$    H$0  Ht/H$8  H;tHA H(H;uH$0  H  L$0  L$8  L$@  H$  _  H$   Ht7H$  H;t"     H H(H;uH$   H  L$   L$  L$  H$     L$  I[HA(sA({IA_A^A]A\_^]HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxYQ      fWf/v6 f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;t;HHtH;ttH;^t)HNL HtHCHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI|L$   H$   H脎2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxY
P      fWf/vf f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;tkHHtH;tMtDH;^t)HN| HtHAHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL$   H$   H贌2L$   I[IsI{ A(s(|$pE(CIA\HVWATH   HD$ HXHh)p)xD)@D)HAIHHHPL@fEWIx ufE(H$   HL$(BfD(= E3@t;H\$0L9cufA(H$   HL$(|Uf(A^Hk7Lg f(A^$   H\$0L9cufA(H$   HL$(/UD^DO0DD$(Ld$0Ld$8Ld$@Ld$HHT$(H<=HL$@ HL$0 L$   L\$(H\$0Hl$8HOH;uHO$   IHHT$0f(L$   I[(Ik0A(s(|$pE(CE(KIA\_^HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YL      fWf/v f/v   fD/v	D   f/v   $   f/v  H   HL$   I\$HtHH;t
HHtH;t
t
H;^t)HN HtHt>HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI)L$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YJ      fWf/v f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;tHHtH;ttH;^t)HN)
 HtH<HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIYL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YH      fWf/vC f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;tH
HHtH;t*
t!
H;^t)HNY HtH:HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL$   H$   HQ2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YG +     fWf/vs f/v   fD/v	D  f/v  $   f/v  H   HL$   I\$HtHH;txHHtH;tZtQH;^t)HN	 HtH9HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\H\$Hl$H|$ ATH HH
HHt
HEH;   LeHI|$HtH;t9HtH;t$̄tHt$03H;{tN Ht
H7HH3HH{HH+HLMM~#    I$HHI;f(Df)D|LHIHt$0HMHH	H\$8Hl$@H|$HH A\uHL$WH0HD$ H\$HHH   -H   Ht  H   { HOXh HOH] HO8R HO(G HO< HOH\$HH0_H%& HWATAUAVAWH0  HǄ$  HXHhHp)pAAf(LH H( H$  HH$   HH$    IUH$   v+   L$  DH$   Ibf(Ho H$   9 L$  IH$   IH$   1    DBH$   B H H$0  e/Hf(` H$   H$   " MHIAH$    H$    L$  H|$0H$  Ht$($  D$ $  f(H$   I#I}HH$   HtH;tHtH;t̄tH;_t"H Ht
H4HH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   ?M]I[     Ht
HL$PH3HD$PfW$  L$  HHL$PE3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;v H\$PH\$@H|$H(D$@f$   Hu E3LH<I;{ wHtH3H;xs L$   Mu E3MI;{ r I.HAHIEIcH;p=H$  ̹     Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM FLHAS   DBH$     H H$0   ,HAU${  HHa ,H$   H$     LHHAH$   r E3E9}$I  D  MEIUH$   +RE3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;v H\$PH\$@H|$H(D$@f$   Hu E3LH<I;{ wHtH3H;xs L$   Mu E3MI;{ r| I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM AE;}$}H H$    HH$   HH$    H$     H$   Ht!  HǄ$       HǄ$       HǄ$       H$     HL$hHt  HD$h    HD$p    HD$x    HL$P  H$   H  H$   :  3L$0  I[0Ik8Is@A(sIA_A^A]A\_HHPVWATAUAVH@HD$0HXHh IHH@    H$   Hh+A   Dt$p       S H   H   X   ^   ,A;ALƉ   LGHWHH  vt]LHH      ^,A;ALƉ   Y;      H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   Hh@D$p       tuS H   H   WLGHWHH  st@LHH   Y: 
     H   H   HHHH$   H@A]A\_^]HHPVWATAUAVH@HD$0HXHh IHH@    H$   HhA   Dt$p       S H   H   V   ^   ,A;ALƉ   LGHWHH  9t]LHH      ^,A;ALƉ   Y9      H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   Hh D$p       tuS H   H   ULGHWHH   8t@LHH   Y8      H   H   HHHH$   H@A]A\_^]HHXHhHpWH   )pp  )xX  IIHL
' LZ D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ *h  Dd  D`  ,  H  Ht$(D$ ~L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
A' LJ D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ }L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
q' L: D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ {|L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
' L* D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ jh  Dd  D`  ,  H   Ht$(D$ k{L$   (t$p(|$`I[IkIs E(CE(KI_HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   H` I EL   HD I H5> fWDY E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMH HtH&HEHLmHH}PHHH+HLMIM~)(
 @ Hf(fWHEHf)HI;|LHUHH$   >YH   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   S'$@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   '$0  H  HUxH$8  HL$(HD$ L$@  L$H  H$0  AY$0  $8  f/v
H$0  H$8  L    A$   L     A$   H  H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM t[Eu7A   H I3 HDHL$x HL$h G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;tHHtH;t̄tH;\$pt$HL$h HtHd"HD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   L$   L$   I^HtHH;tHHtH;t̄tH;$   t$HL$x HtHz!HD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   L$   I|$ uf(H$0  H$   5D  fD(HD$hH$   H|$p tH$0  H$   5f(f(  f(EtIH   ALD$hHT$xH3f($0  H$0  HMX腼Y   ux'H   E3LD$hHT$xHL   L]xMHUHH 8mp\mhfT- (  f/vA      @  fA/vA   x   f/vA
   bH  H9   rA(   JH0  5 Yf/vA    H^H  Yf/vA   HL$x HL$h AL$   A(sA({E(CIA_A^A]A\_^][HWH`HD$ HXHhHpHHPW HgHHD$0HXHHtH;tHtH;t̄t3H;_tH Ht
HHH7H_HHH+HLMM~2(
] fffff     HE f(fWHf)HI;|LHHL$(QHL$P H\$pHl$xH$   H`_LUVWATAUAVAWH  HǄ$X  I[A)sA){LHHAE3HxH,  II(IKI0 ACHL4I      ?=  LFHIIHHT$0LD$8Ht$HLD$PIH+HH$   H$   H$   HL$0HHHAHBHAHBHAHBHA HB L$   H$   HH$  HEH$  H$  H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$  L$  L$  H$  H$   LHFIIN|LFLIIIH$   L$   H$   IH$   IH+HH$   H$   L$   H$   HIHAIBHAIBHAIBHA IB H$   L$  H$   HIHAIBHAIBHAIBHA IB HA(IB(HA0IB0HA8IB8HA@IB@$  $P  HNH+IH+IHIHD$0Hl$8Hl$@Ht$HHT$PH$@  HL$0HHHAHBHAHBHAHBHA HB L$  H$  H$@  IT$H+I$HHT$XHl$`Ld$pIL$HL$xHT$XHqH$0   LFIIHHHT$XLD$`Ht$pMLD$xIH+HH$   H$  L$  HL$XHIHAIBHAIBHAIBHA IB L$@  IL$H+I$HH\$0Hl$8Ld$HID$HD$PH$   L$   H$   L$   L+JH$`  H$h  H$x  H$   HHHAHBHAHBHAHBHA HB L$  H$  H$`  HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$0.pf(YY$   H$   H$   L$   ID$H$   H$  H$   请IT$HH+I$HHL$XHl$`Ld$pHT$xHVLHIIH$   H$   H$   H$   HH+HH$   H$  L$  H$   HIHAIAHAIAHAIAHA IA H$@  HNH+HHHI+IH$  HD$ LL$XL$   GiML^HJ$  BDI$B4IIHL;L$  I[HA(sA({IA_A^A]A\_^]HVWATAUAVHP  HǄ$   HXHh )p)xLHq3H  H~fW=x I.MfLkIHIHD HD$ H|$(Lt$8Ld$@HT HT$pH$   L$   HǄ$      HDHD$HH|$PH\$XLt$`Ld$hID$H\ H~iYҹ   H;}IHYXHA   I}&3ɐH;}IHYXHIf(\Xf/   f(^  $  ID$HD H   H   H$   HL$pHHHAHBHAHBHAHBHA HB L$   H$   HL$Hg$  L$  HT$ HXH$   H~H$  HL$ bIHL;3HHL$P  I[@IkHA(sA({IA^A]A\_^HVWATAUAVH0  HD$ HXHh )p)xLHq3H  H~fW=+   IN LkI.HHIHD H$   H$   H$   H*IFHBIFHBIFHBHJ H$   H$   HD H$   H$   H$   H*IFHBIFHBIFHBHJ HǄ$     HDHD$0H|$8H\$@HT$HH*IFHBIFHBIFHBHJ HD$hHD$pLaLB\ H   L$   AYҹ   H$  H    J
 H;} YXHHA   I}(3ID  H;}YXHHIf(\Xf/   f(s  $h  BD H   H   H$   H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$   H$h  HL$0$`  L$`  H$   HH$   H~H$h  H$   VIHL;wHHL$0  I[@IkHA(sA({IA^A]A\_^HWH  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HAT A\ HD$8LT$@D$HHT$0HL$ vP  HQLL$0HT$8HI HHH$   H$   IBH$   H$   HHHQLQHCHAHC HA H$   H$   LH$   H$   HT$0HJH$  S LL\$PHCHD$XHL$hLHAHCHAHCHAHC HA H$   H$   HD$0HD$ H$  HD$(HT$PHL$ P3L$   HL$0HIHAICHAIC$  HHD$PHCHD$XHL$hHHHCHAHCHAHCHAHC HA H$   H$   HD$PHD$ H$  HD$(H$   HL$ 3L$   HIHFICHFICHFICHF IC HT$XHL$0HHHAHBHAHBD$xL$   H$   HL$QL$  L$  H$   HYH$x   L$  I[Is I_HHPVWATAUAVH   HD$0HXHh IHL3퉬$   A(D$ L
+ M@HV+ H
4 rpLHSIHtgHI      Ic$   H$   I#I;w
IL;r/H HD$(H HD$ LHJZ H
[4 IL$LHT$XH:VLHD$@Ld$HIt$HuH9HH;vH    HX HHuHtHHwI\$HtI;tHtI;t̄tH;t Ht
Hm
HH/H_HHH+HLMM~.fff     I$IE f(fXHf)HI;|LHHL$8M+HL$hy HL$   I[@IkHIA^A]A\_^@SH HHP  HH [~HSH   HD$ )pHZHX @LB@HPHH2HY
HD$0H\$8H{ ufWH$   HL$(f(HL$h f(($   HĐ   [HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhD fAWA   DBHXF Hq H$@  iHM c HT$@H$0  ( L$  MHIAHL$@ L$   $    t2H$  HD$0Lt$(H$  HD$ MU HH$(  k2$  E3fW L   ~<EtACu,H1q HL$@ IHT$@IHL$@ HdDFhfAWE f(HV@IIH9^@~@f     H~8IE I+EHH;r IMHHHH;^@|Ћ$(  EuH    u2H     utA  H/ HL$@= HT$@H$0   HL$@= H      H$   C HHip H$@  lHHuI
H HcHHHWHH HH%p 4   H$    HHp H$@  
HHuI
H HcHHHW   H$    LHuI
HHcHHISAL$  AH HHo    H$   D HHzo H$@  mHHuI
H HcHHHW   H$   
 LHuI
HHcHHISAHgGf(H HHn HFHD$HHx uf(H$  HL$@N  f(   H$   w HHn H$@  HHuI
H HcHHHW   HL$pC LHuI
HHcHHISAf(HP HHBn 9
   H$   HH,n H$@  HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H HHm  
   H$   N HHm H$@  w HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H  HH"m 	 H     H$    HHm H$@  HHuI
H HcHHHWHH HHl Hl H$@  HH    HHl mHT$@H$0  : MHIAHL$@ H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  E$  Ex.H l HL$@E IHT$@IHL$@K 2Hk HL$@ IHT$@IHL$@ AF   EH$0  H$LHk HL$@ MHIAHL$@ H$0   H$0   AL$  A(sA({E(CIA_A^A]A\_^][HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q(~5L5d fWHMf(f(
AAID;m(|LHT$(HjHHXHHtH;tHtH;tp̄tfH;_tH Ht
HHH7H_HHH+HLMM~!    HE f(Hf)HI;|LHHئHL$(4 L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA(D$ L
7y DB(Hy H
]( L[L\$ L
x EE(Hy H
6( Ic](H\$HfW|$XHu3H9HH;vH<    H= HHuHtHL$hH\$pHt.II;t̄t̄tIH\$pHHH+HLM3M~(/ f)HI;}HL$hLHT$hHL$@Ic](H\$HH\$P|$XHHHu3/H;vL$    IW HHuMtHL$xH$   H$   HtWHtIHHH;tHtIHHH;tHtIHHH;tH$   H$   HHH+HLM3M~ ( @ f)HI;}HL$xLHT$xHL$@ɶIc}(H|$H|$XHu3/H;vH4    HD HHuHtH$   H$   Ht.HH;t̄t̄tHH$   HHH+HLMM~$(/ HIHHHff) HHuLH$   HL$@ݵIc}(H|$H|$XHLH$   H$   Ht$H;t̄t̄tH$   HHH+HLM3M~"( ffA)HI;}
L$   LH$   HL$@2Mcu(Lt$H|$XA   MIHL$0_Mt$L;tW̄tM̄tCL;t$8t,HL$0x MtILHD$0E3Ld$0Ld$0Lt$8IHH+HLMM~-( IIHHHfff     f) HHuMHT$0HL$@PE3D$  D|$`5     $  D;9  3A9u(~I3L$  ffffff     H$   Mf(f(;HA;u(|D$  L$   HT$@IHHXHtHH;tHHtH;t̄tI;t(I HtHLHD$0E3Ld$0LH\$8HHH+HLM3M~Hf(fA)HI;|LHT$0H7HL$@    DBH$    H$  H$   H$0  H$   L$   L$  HT$0H$   H$   H$   j Hx H$    t7H$   H$   : H$  LHAH$    L$   Hq H
k! nL\$hL$   H$  H$   L$   LL$pIHH+HLM3ҐI;}IIf(fXf)HH$   IРE3H$   D  E;](}QE3    E;=IcIcL$   LLHL$xH$   YBXBAAAD$  H$    L$  H$   Lt$8Ld$0D$  fW5 fn$  H$  HL$hHD$xH$   H$  H$   H$   HD$HH$   HD$Pt$XHT$@H$   M]L\$@H$   HL$@HHHAHBHD$xHD$@(D$@fD$@HD$@H$   H$  H$   H$   H$   HHHAHBHAHBHAHBH$   H$   HT$hH$  H'cHT$xH
dIX H$   I H? HL$x3 HL$h' ($@  ($0  HP  A_A^A]A\_^[HT$UVWH0HD$ H\$`HHD$P    HHpHu39HH;vdH<    H HHuHt@HHsHE HxHHtH;tHtH;t̄tH;t/ Ht
HHH    H{HH_HH\$`H0_^]HT$UVWHPHD$ H\$pIHǄ$       IH@HT$(HHHqHu39HH;v<H    Hz HHuHtHHwHE HXHHtH;tHtH;t̄tH;t Ht
HHH    H_HH7HL$8 HH\$pHP_^]HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz(Hu3H8HH;v	H    HG HuHt3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVIv   DBH$    L$   HT$@H訞f(D$PHT$hH$    Hx @HL$h @t,HT$hH$    MHIAHL$hf t$XHD$XI#I;u+H4 HD$ L
 LD$PHm H
 
X|$8É\$0H$   R I      H$   L$  L$  |$8\$0fnF^If(XHL$@ f(($  ($  H  A^A]A\_^[HWATAUH  HǄ$   HXHhHp )p)xD)@D)HEIHH3H\$@H\$HH\$PHT$(LD$0fWI9Xuf(H$8  HL$ }f(D  fE(D^H$8  Hl$(DL$0L$8  H$   HL$!LHNHL$(HL$0HT$`HD$ HH
HHHJHHHJH@HBI藅H$   LHL@IMtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHL$@HT$XHL$@lH$    E   Ht$(H~ tH$8  HL$ f(^D^HD$@H$8  HD$@HD$(DD$0L$8  HT$XHL$!4HHHLIHHLAMtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHHH薯HL$x 0  fA(LHT$XHL$@HL$@H$8  L$8  H$   HHT$ HAHLHL@MtMtIHIL;tMt:MtIHIL;tܿMtIHIL;t迿IIHLOLOIHH+HLMM~Hf(Hf)HI;|HHLHL$  H$    HL$h H$8  Hl$(DL$0L$8  HT$XHL$!:L$8  L$8  HHHL$x< HL$@0 f(L$  I[ Ik0Is8A(sA({E(CE(KIA]A\_HLH VWATAUH(  L$x  IE3LIMo  HXHhH$p  LpLxL$  )p(5 IHǀ@   LD$pHMHL$xIH+H$       H$   L)H$x  f)$   f)$   f)$   IL$x  H$x  f)$   f)$   f)$   HMH$   HH$  f)$   f)$   HD$hH$  LD$`LD$XHD$PHD$H D$@H\$8L|$0A   H\$(Hl$ NE3MH~JL    IPHIIfD  H;}JHĐ   XDDIIL;|H$h  H;MHL+ILHD$pHH$x  IT H$  HD$hH$  LT$`LT$XHD$PHD$H D$@H\$8L|$0LD$(LHl$ MHl$xH$   H    HIHD$pI;A    ($  L$   L$`  H$X  H$P  H(  A]A\_^HWHp  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HA4 A\ LT$8HD$@D$HHT$0HL$ pQ  HILL$0HL$@HHH$   IBH$   H$   H$   HHLQHCHAHCHAHC HA H$   H$   HL$PHHHBHAHBHAHBHAHB HA L$   H$   HL$PkHT$0H@H$`   LL\$PHCHD$`HL$hLHCHAHCHAHCHAHC HA HǄ$      HD$0HD$ H$  HD$(H$   HL$PHHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$ /HH$   HCH$   H$  HHHCHAHCHAHCHAHC HA HǄ$0     H$   HD$ H$  HD$(HT$XHL$0HHHAHBHAHBl$xHT$PHL$ yL\$XHIHFICHFICHFICHF IC $   LD$0H$   HL$Q*L$  L$  H$   Hj=H$H  $ L$p  I[Is I_LMK ECISIKSVWATAUAVAWHP  HǄ$p  A)sA){MELHE+H HD$ L
y MCH^f H
_ H2f H$   d IH$   IH$   d - $    $   5j $   = $   R $   
e $   MIH0$   HHPH$   cHHPH$@  N$   <e $   $   fWL$HD$@E3D|$DH
 |$@   Icĸ   $      t$P A;  AAHHL$X HC H$   GLt$8HD$XHD$0H$  HD$(D$ E3ҋxCH$  ٶ HL$XͶ AE(D$ L
-^ D$  H^ H
_
 HGHHHL$ L
] EE(H] H
4
 Lt$0HGHD$(GD$ LOLH$   I;2H$  L$  D$  L$  D|$D$   t$Pu?HT$XH$   HH$@  NVHL$hڶ HL$X϶    H$x  H$   L$   H$  HH$@  H$  LL$   H$  ÙLHHL$XcHH$@  SHL$h> HL$X3 H$   $ H$   fn  f(^H$  H$@  L$   H$  軘HH$   H$  Lf(H$x  LHHL$XHITHL$h HL$Xt H$   e H$  W Ɖt$PH
m MIHLR ;LI H$  L$  D$  L$  D$PD|$D$   $   f/   f/$         DBH$   H9a H$   HHa HL$H HH A}H` H$   H` H$   HT$XH$  | MHIAHL$X# MIASD$@ H$  N    A}$   |$H   f/$         DBH$   H9` H$   HH` HL$H HH_ HT$XH$   MHIAHL$XS MIAS|$HD$@ H$  x H$@  NAD|$DHWHL$XJHIqPHL$h HL$X H
 bLD$ L
^ H^ H
  H$P   H$@   H$    H$   } D$H($@  ($0  HP  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/H HD$ L
u L$   Hfa H
_ fA/w/HS HD$ L
? L$(  Ha H
) ̋$0  /H HD$ L
 L$0  H` H
 2HHPH$   IE HPH$P  fE(D%]  $   fn=? YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhH H$p  = H$  ~ H H$  H$p  H$  0 H H$  H$  [Hu3HH$   1HD$pHHL$xH$   H$   H,_ H$    L$8  I$H$   IH$    H^ H$   ` I$H$   IH$   _  $   AA   D=n D5 D  G(D$ L
U D$H  HkU H
 7M]ICHD$ L
+U DG(HXU H
 Ld$0IEHD$(AED$ MMME H$   HAu?HT$@H$   HH$P  MHL$Pq HL$@f    H$  H$   TLf(H$   萑HH$P  H$  L
Z H$  `LHHL$@ HH$P  _KHL$Pۭ HL$@Э H$    H$    fAnf(艉  ^H$  H$P  L
 H$   XHH$   H$   Lf(H$  蜐LHHL$@謏HHLHL$P HL$@ H$    H$    AƙA} +	  fA(MHIfD($   fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(Ht$ff     DX HI;IDH;tHufH*HyX D^HT$pInfD(Ⱥ   DBH$0      H$`  ~ HHlZ H$@  HHu3
H HcHHHW	   H$   8 HAHѨ HHZ ZHH HHu3
H HcHHHW   H$P   LHu3
HHcHHISA   H$    HfA(H HHY HHu3
H HcHHHW   H$0  l HHҦH٦ HHu3
H HcHHHW   H$   HfA(HQ HHX :HHu3
H HcHHHW   H$@  ۧ HHAHH HHu3
H HcHHHWfA(H֧  +fn^5fX $      Å  Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHu HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;v HL$`H\$XHt$@H$  H$  HH+Hu3$H;ve HtH;t$@tS H+H($  f$  L$   A   H$  HL$@諊H\$XHHL$`H;v HL$`H\$XHt$@Hu E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;v\ HL$`H\$XHt$@H$   H$   HH+Hu3$H;v  HtH;t$@t H+H($   f$  L$   A   H$  HL$@fH\$XHHL$`H;v HL$`H\$XHt$@Hu E3HL$`H\$XHD$@LHT I;S wHtH3H;Psj HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;v HL$`H\$XHt$@H$   H$  HH+Hu3$H;vߥ HtH;t$@tͥ H+H($   f$  L$   A   H$  HL$@%Ht$XH;t$`v H\$@Hus E3LHI;K wHtH3H;HsI H$@  HHT$@PfE/vH0T H$@  E2fE/vHS H$@  mE2AE D;~"fE/wfE/vHS H$@  :H$   H$0   M$HIAH$    E   fA(A\A^fATf/*S vmHR H$   K I$H$   IH$   J H3R H$    I$H$   IH$    HL$XHt`  HD$X    HD$`    HD$h    HL$@;  H$0   H$  $   D;$0  uoH0Q H$    I$H$   IH$    HP H$   L I$H$   IH$   K E2AE$   = HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	I;  H$`  Ȣ H$P   H$0   H$    L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   H  I EL   H Ix H5ީ fWDU E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMH7 HtHHEHLmHH}PHHH+HLMIM~)(
 @ Hf(fWHEHf)HI;|LHUHH$   H   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   $@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   $0  H   HUxH$8  HL$(HD$ L$@  L$H  H$0  NAY$0  $8  f/v
H$0  H$8  L    A$   L      A$   H   H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM bt[Eu7A   H4S Iӛ HD菝艝胝HL$x HL$h G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;t}HHtH;t^̄tTH;\$pt$HL$h HtHHD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   hL$   L$   I^HtHH;t薛HHtH;tw̄tmH;$   t$HL$x HtHHD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   脃L$   I|$ uf(H$0  H$   Yw  fD(HD$hH$   H|$p tH$0  H$   %f(f(w  f(EtIH   ALD$hHT$xH#f($0  H$0  HMX%gY   ux'H   E3LD$hHT$xHL   L]xMHUHH蠫mp\mhfT-^   f/vA         fA/vA   x   f/vA
   bH   H9   rA(   JHȭ  5 Yf/vA    H
(  Yf/vA   HL$xs HL$hg AL$   A(sA({E(CIA_A^A]A\_^][LD$SUVWATAUAVAWH   HǄ$   )$   IHHHHXE3I;XtI Ht
HeHL7H_LnL$   HM H  HH;  Hl$HHUH$(  HEH$8  H$(  L$8  H;IMHHD$( D$8HT$ HL$H苨L]L\$PHEHD$XfWt$`HT$HHMeM  L$0  fffff     LHN MSL+M+Ԁ~    HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$    HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$ LEIIHE HHT$ LD$(Hl$8LD$@HHxI+HIH+HHD$pH|$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H|$Pt$`H$0  L|$pAtH/IHHكH$(  H$0  H$(  H;HMHHH+HH+HL,CLE3HT$pHL$H4}I;}=D$`fIIH+HHHff     f)HHuLMHT$pHL$H|IsE3L$        HHXHI+L;  LEIIHE HHT$ LD$(Hl$8LD$@I+HIH+HHD$pH\$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H\$Pt$`H$0  Ll$pAtH/IHHكH$(  H$0  H$(  H;HMH8HH+HH+HL$GLE3HT$pHL$H{I;}>D$`fIL IH+HHHff     f)HHuLMHT$pHL$H]{IL$   HL@HMt:MtHHIL;t{MtHHIL;t^IIMH{LELD$(LMLL$0MtWMtHHIL;tMtHHIL;tMtHHIL;tޒIIHHT$ HKI]H>  @ LHN MSL+L+D8v   HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$    HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$ H($   H   A_A^A]A\_^][HWATAUAVAWH@  HǄ$   HXHhHp)pAAf(LHE H/ H$  HH$   HH$   ' IUH$   )   L$  DH$   If(HD H$    L$  IH$   IH$       DBH$0   HD H$@  Hf( H$   H$0   MHIAH$   F H$0   L$  H|$0H$  Ht$($  D$ $  f(H$   II}HH$   HtH;tyHtH;td̄tZH;_t"H Ht
H
HH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   cM]I[   l  Ht
HL$PH3HD$PfW$  L$  HHL$P腝E3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;v H\$PH\$@H|$H(D$@f$   Hu] E3LH<I;{ wHtH3H;xs3 L$   Mu  E3MI;{ r I.HAHIEIcH;p=H$  ^d̹   ck  Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM ƌLHAS   DBH$0  } H-A H$@  蠷HAU$ HH@ 脷H$   H$0  N LHHAH$    E3E9}$I  D  MEIUH$   KE3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;vu H\$PH\$@H|$H(D$@f$   HuM E3LH<I;{ wHtH3H;xs# L$   Mu E3MI;{ r I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM  AE;}$}
bH=? H$   g HH$   HH$   g H$0   H$   Hth  HǄ$       HǄ$       HǄ$       H$   ph  HL$hHt`h  HD$h    HD$p    HD$x    HL$P;h  H$   ȋ H$    3L$@  I[0Ik8Is@A(sIA_A^A]A\_HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhD fAWA   DBHXF H! H$@  iHM c HT$@H$0  ( L$  MHIAHL$@ǉ L$   $    t2H$  HD$0Lt$(H$  HD$ MU HHӈ$(  k2$  E3fW L   ~<EtACu,HQ! HL$@ IHT$@IHL$@ HDFhfAWE f(HV@I蒓IH9^@~@f     H~8IE I+EHH;r IMHHHH;^@|Ћ$(  EuH    u2H     utA  HY HL$@= HT$@H$0  ن HL$@= H      H$   C HH  H$@  lHHuI
H HcHHHWHH HHE  4   H$    HH/  H$@  
HHuI
H HcHHHW   H$    LHuI
HHcHHISAL$  AH HH 藱   H$   D HH H$@  mHHuI
H HcHHHW   H$   
 LHuI
HHcHHISAHgf(H HH HFHD$HHx uf(H$  HL$@Nc  f(   H$   w HH H$@  蠰HHuI
H HcHHHW   HL$pC LHuI
HHcHHISAf(HP HHb 9
   H$   HHL H$@  HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H HH 衯
   H$   N HH H$@  wHHuI
H HcHHHW   H$    LHuI
HHcHHISA   H  HHB 	H     H$    HH% H$@  خHHuI
H HcHHHWHH HH 蠮H H$@  茮HH    HH mHT$@H$0  : MHIAHL$@ H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  ܂E$  Ex.H  HL$@E IHT$@IHL$@K 2H HL$@ IHT$@IHL$@ AF   EH$0  H$LH HL$@Ƃ MHIAHL$@Ղ H$0  Ƃ H$0   AL$  A(sA({E(CIA_A^A]A\_^][@USVWATAUAVAWH(  Hl$pHǅ   )   A0uxHA HE8HHE(HB HELzL}hLaHHE0L}XLeHL  MLH Mu    H/ A   L* H HHHH   H   H  I;HMH	HM H~H3IHHM 3I;}LII~IHL,IIH    H  HIHIHHH;vL4    HI   w9H   HHH;wHHHf  H+H\$pHHH  -I HH  HuMtxHI     H   H      HH;v5H4    H   w2H   HHH;wHHH#f  H+Lt$pIIH8 LHuHtH      H  MLU3M  3H}HE HLMIHU`HIHHUpLE0LEPfffff     HHU@HEXL]@L;IMH0H+3HD$8HD$0Ld$(Ht$ IH  3LHU MM  ff     3K</H  HEHH  L;HMHI+HEIHM0LHT$8HT$0H\$(Ht$ LMH  H  qHE HMHM;HMHM(JLt$h3HL$`HL$XHD$PHD$Ht$@H HD$8Ht$0H\$(HEHD$ L  LE8H  MLHEJHU8H   LL}(Lt$@HMxHL$8Ht$0H\$(HD$ H  LLIH  3LH} I;H}HM@LEPLEpLEPH}`H}L}hI;HE LULM.    t
I~    t	H~ (   H   A_A^A]A\_^[]@WH@HD$ H\$PHl$XHt$`HHHHXHu36HH;v}H<    HF~ HuHt|HD$(H\$0LD$(HHHL$(H\$PHl$XHt$`H@_H%} @VAVH(  HqLH }H(  A^^H$   H$  H$  HHǄ$H     L$  HL$   H$H  )$   HǄ$P     HHHHH$@  HHH$@  H$P  HMH9   HN3L(L$@  H  5
 MHIMFH$@  H$H  I;H$H  HHMILt$8HI@LD$@HHH+HD$ I@H+HT$(HT$0HT$XHHHl$PLt$`HLD$hHl$xHD$HHH$   L$   L$   IHHHHL$ HD$pϖH   H   HL$ H$   HHHAHBHAHBHAHBHA H$   HB HT$HHL$pH$   $H  HL$H  HHAHBHAHBHAHBHA H$   HB HT$H"IIH;HL$   L$  H$  ($   H$  H$   H(  A^^HH\$Ht$WH LBHHHMtHHIL;tyIMIѪLGLOMt\MtHHIL;txyMt:Mt5HHIL;tVyMtHHIL;t9yIHIYLK3LKIHH+HHLMM~ D  HHHI;f(Df)D|HHMHC.HH@ƉsH\$0Ht$8H _HL$WH0HD$ H\$HHHLJLB3HHAHAMtDHMtHHIL;tRxMtHHIL;t5xIIHUC HH%HH\$HH0_@SH HHD$8    H4HH [HWATAUH   HD$(HXHhHp EIHHHYHu36HH;v~wL$    Ix HuMt]wHD$0H\$8HT$0H%Ht$@HNH$   HVHT$ H$   LD$ H;IML IMtM;tvH$   HT$ H$   LD$ H;IMHHtI;tv̄tvH;]t%HM w HtHeHE HE     H]HT$@HHt$@LFIHH$   HVHT$ H$   LL$ H;IMHHtI;t-vIHH$   HT$ H$   LD$ H;IMHHtI;tūtuH;_t"Hw Ht
H虦HH    H_HT$@HHE   HFHt$PHL$0HL$XD$` HHD$hHD$p   LFMtMtIHIL;tUuMt:MtIHIL;t3uMtIHIL;tuIIMH3HHL$PHL$02v L$   I[(Ik0Is8IA]A\_HVWATH   HD$ HXHh)pIHHZ IHu3,I;vvtH<    Hu HuHtUtHD$(H\$03H~;fWfffffff     HH$   P5XHD$(HH;|$0|HM@HT$PH$   H$   HD$@HD$(HD$HH|$0Ht$HH;ts̄tsH;} tIHMt Ht2I;vsH4    Ht HuHtlsHEHE    H} HUHL$8kHL$Pt HL$({t L$   I[ Ik0(t$pIA\_^HUVWATAUAVAWH   HD$0HX )p)xD)@HLA   AAHjHHtH;tr̄tr3H;i t!HIs HtHPIEIuIm H  HIMH HE   HLLIqMELD$@MMLL$H{ D$PMtWMtHHIL;t rMtHHIL;tqMtHHIL;tqIIIMMMMIHH+HLMHM~&(l fffff     IE f)HI;|IHL$8YAu8AE<E}=I  LKLCMtMtHHIL;t#qMt:MtHHIL;tqMtHHIL;tpIIILKLCMt:MtHHIL;tpMtHHIL;tpIII计HILl$@H$  HL$8,$   fWf.zuy $   Ll$@D$HHT$8INH}H$  HIM(VEME(IUI"E3IMH!  =Xs Dv H;  HH+H<  H   HH+HHHHf     ME(IEBTfTfTLfTDfTXfTAYf/rNLME(IEBTfTfTLfTfTXfTAYf/rNLME(IEBfTfTfTDfTXfTAYf/rNME(IEBTfTfTLfTDfTXfTAYf/rNLH HH;}GIM(IEfTfTLfTfTXfTAYf/rLHH;|H|]IE(HLAf.zyuwf.z8u6Af.z%u#Af.zuHH HH;H5H0H  IE(HLf.zuHHH   H   IHHkL;   H_H|]IE(HLAf.ztmf.zt*Af.zt"Af.ztHH H~H2H,H&H~!IE(HLf.ztHHHEtIE IHl$(HD$ LLIU(IMWTE3HHkL;EM8AE8   A9u8   IH$  H       IEH
Iɸ   H;    f/vf(HHH;|H   LIEJHH;tHHEt^IUIM HIHHD$8HT$@Ll$PHT$XHHHHD$`HT$hLl$xH$   E3HT$8HL$`ZVE3HHH;(H$   IM'AE<E}=IL$   I[XA(sA({E(CIA_A^A]A\_^]HL$VWATAUAVH0HD$ H\$hHl$pELHLJLB3H1HqHqMtDHMtHHIL;tjMtHHIL;tjIIHI|$IHuH,I;vjH,    Hk HuHtjHCH{ I|$H~H   Ht/I;vTjH,    Hk HHuHt0jHs(H{0C< EIHHH\$hHl$pH0A^A]A\_^HL@HPHHSVWATAUAVAWH`  HǄ$  )p)xD)@D)HMHL   nG  HtHL$8H33HHD$8H\$PH\$XH\$`   :G  Ht
HL$xHHHD$xH$   H$   H$   H\$(HD$xHD$ LL$8MHI%fD($   H~ H+~HH$   H$   H$   HtNHt"HHHHH;thHHtHHHH;thLLMt3i IHH$   H$   H$   HH$   H$   H+HHtCH;rui H$   HH$   HHH$   H$   H+HH;rH~ H+~HHuH6HH;vgL$    Ii HuMtgHD$hH|$pHHD$XHL$PH+HHt6H;rh HL$PHHD$hHHHD$XHL$PH+HH;rHT$hH$   <H~ H+~H   E  Ht
H$   HHH$   fWD$0LD$0HH$   u5z D" D$   =! fD/  Y5y t$0fD/   H$   HtFD  H$   H$   H$   H$   !D  HL$hg H$   g H$   HtC  H$   H$   H$   HL$xC  HL$PHtC  H\$PH\$XH\$`HL$8C  fA(  HHF H+FHHtlH;rg LfLl$hH$   H$   H+HH;rf H$   f(AYL A\HHF H+FHH;rH\$ LL$8MH$   I5f(|3L$  H$  L$  D$   t$0D$   $   :HHF H+FHHtgfD  H$   L$   I+HH;rf L$   HF H+FHH;re HNIHHHF H+FHH;rH$   Ht)B  H$   H$   H$   H$   B  HL$he H$   e H$   HtA  H$   H$   H$   HL$xA  HL$PHtA  H\$PH\$XH\$`HL$8A  f(L$`  A(sA({E(CE(KIA_A^A]A\_^[HL@UVWATAUAVAWHP
  HǄ$  HX )p)xD)@D)HD)xMMLH   DǸ   $
  H$ 	  b H H$  Wc H~ H$p  H a H$x  H$  H$  Jc H$  3c HG H$0  b H$P  H` H$X  H$0  H$`  b H$0  b D]    AA+iA+L$
  AM utAE A}  uA}   AA+iD+E]uEtAAEA} uA}]H HIAHIM腦fW$
  I\$   ?  3Ht
H$   HHH$   L$
  HH$   pI\$H$8  $H  HuH;HH;v]aH4    Hb HHuHt9a3HL$`H\$hHHt$H;tātāt`H\$hHHH+HLMHM~ ([ @ f)HI;}HL$`LHT$`H$0  FH$
  I\$0I+\$(H   V>  Ht
H$   HHH$   L$
  HH$   p   >  Ht
H$`  HHH$`  H$x  H$  H$     =  Ht
H$  HHH$  H$  H$  H$  HUH$  ` H$  _ H$  H$
  HUpH$  ?_H$  H$
  HU0H$  ^L$  L$
  H H$  H$  H$  ]H$  H$X  ^H$  H$  <  H$  H$  <  H H$  ^ tH H$  \    H H$  {^ tH H$  \ mDǺ   H$  ]    H$  ^ HT$pH$  ] HH$  ^ HL$pz^ H$  ] H H$0  6^ Hy H$  H$	  H$   H$0  H$(  (^ H$0  ^       H$
  H$  ,tG$
  f.zuL$  IHL$`iH$  HD$ MMHT$`JH$  HL$p] t$8\$0H$  HL$(H$  HL$ MMHT$`H8u[HT$pH$ 	  \ HH$  `^ HHa H$  HH$  ] HW H$  n:  3H9\$h~VHD$`H$
  H$   H$   H+HH;r] H$   H$
  HHHHcH;D$h|H$(  \ Hb H$  H$X  H$
  H$  H$  H$X  H$  H H$  H$  ($  f$0  ($  f$  L$0  L$  H$  H$X  B
H$  A9  3H$  H$  H$X  "9  H$  H$
  H$  (H$  8  H$  [ N9  Ht
H$   HHH$   H$   H$   H$   Ht$8D$0D$(H$   HD$ L$   L$   IIGF     H{Z H
X vZ HH GHHUZ WZ    (  H{ H$  Z H"v H$  H[X H$  H$  H$  Z H$  nZ L$  L\$(t$ f(L$   H$   IHT$pH$ 	  jY HH
W Y HHY Y HL$pY AAFINH$   ^H$  Y H=_ H$  H$   Ht7  H$   H$   H$   H$   6  H$  Y H$  Ht6  H$  H$  H$  H$  6  H$x  Ht6  H$x  H$  H$  H$`  k6  H$  HtX6  H$  H$   H$(  H$   36  HL$`Y H$   Ht6  H$   H$   H$   H$   5  H$`  X H$P  H$  mX H$p  H$ 	  W 3/3  H$  U H$  U    X    tAD    DEH   r	H   H   A@   H$  hU       t1H  r	H   H   A@   DH$  )U H H$  lW Hr H$  H$  H$  H$  H$  ^W H$  GW D   A	  (  ,  $  At*AtAtAt3   3      DH  D8  D@  D  $
  0  $
  4  $
      t@H8 H$  HH HHU U H$     t@H H$   覀HH 藀HHU U H$   zV $   I\$H$8  $H  HoLH$  H$  Ht.HH;tnŪtdŪtZUH$  HHH+HLMM~*(O I@HHff     fA)IHuLH$  H$0  <L$0  HR H$8  L$  L$  HT$`H$0  dU +$   fDnE=  D^H\T H
R WT H H
R $H5T H
vR 0T H!T H
bR T H H
NR ~HH ~HS H
,R S HS H
R S H H
R ~HfA(S HHo ~HHS S fnYAYH H
Q N~Hf(IS HHO 2~HH@S BS H{ H
tQ ~H S H
aQ S HS H
MQ S H< H$  RS Hn H$  HQ H$  H$  H$  ES H$  .S Ht H$0  R H$  H$  H$   H$0  H$(  R H$0  R Hȴ H$  R LH$   H$  B$  g            	0  Ht
HL$pH3HD$p3H$   H$   H$   H: H$  $R H$  HL$pH$  "R AEHT$pI!H H$  Q L$  H$  HL$paH$  Q HL$pX$
  D$8$
  D$0$  D$(t$ MLD$`IHL$pnL$  L\$@H$  HD$8H$  HD$0|$(DL$ $
  DEfA(HL$p蛿$
  $  ^            .  Ht
HL$pH3HD$p3H$   H$   H$   H H$  P H$  HL$p薒H$  P AEHT$pI# H H$0  ^P L$0  H$  HL$p#`H$0  TP HL$piW$
  D$8$
  D$0$  D$(t$ MLD$`IHL$pnL$  L\$@H$  HD$8H$  HD$0|$(DL$ DEfA(HL$pII   HH$  O H=U H$  H$(  O H$  H$  tO H$  H$  UP H$  NO H$  H$  L H$  L H$   Htq,  3H$   H$   H$   H$   J,  H$  N H$  Ht(,  H$  H$  H$  H$  ,  H$x  Ht+  H$x  H$  H$  H$`  +  H$  Ht+  H$  H$   H$(  H$   +  HL$`#O H$   Htt+  H$   H$   H$   H$   O+  H$`  M H$P  H$  M H$p  H$ 	  L 3(  A
  (  \
  H H
HK wHHL L H H
%K wHH$  L HHL L     t3HW H
J wHH   L HHL L ,  H- H
J IwHK HHKL ML 0  H H
wJ wHf(
L HHL L 8  H H
?J vHf(K HHK K @  H H
J vHf(K HHK K H  H H
I jvHf(eK HHkK mK P  Hn H
I 2vHf(-K HH3K 5K X  HF H
_I uHf(J HHJ J `  H  H
)I uHȋ!J HHJ J ] H H
H uHȋI HHJ J     >  H H$  WuHH HuHHVJ XJ H$  H  H$  uHH uHHʀ tHHw I HHI I HΉ H$  tHHk tHHx tHH} I HHI I H| H$  stHH1 dtHH& UtHH UI HHSI UI H" H$  !tHH tHHD tHH$  I HH I I ,  H H$  sHH sHH sHG HHH H 0  H H$  qsHH_ bsHH SsHf(NH HHTH VH 8  H[ H$  sHH sHH1 rHf(G HHG G @  H H$  rHH rHH rHf(G HHG G H  H H$  lrHH ]rHH NrHf(IG HHOG QG P  Hn H$  rHH; rHHD qHf(F HHF F X  H H$  qHH qHH qHf(F HHF F `  H H$  iqHH ZqHH KqHȋE HHNF PF ] H H$  qHHo 
qHH` pHȋ8E HHE  F H$  H$  &H& H$0  0F H$0  H$  H$0  +F AEH$  IHa HL$pE LD$pH$  H$  UHL$pE H$  L$
  ,  $  HpC H$0  H$  [LL$   IH$0  6H$   H$  kHc`  H$  d0  $  8  $  P  $  @  $   X  $(  H  $   HJHcH$  HMf HL$pD H9` H$  H$  H$  HT$pH$  D HL$pD L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  Ih$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(II%CH$  oA 3Ht$8D$0D$(H$`  HD$ L$   L$   II.IN8H$`  MHAvhH$  iC H=iI H$  H$0  ]H$  <    H H
@ ~mHHB B H H
@ [mHH$  ZB HHXB ZB     t3H H
@ mHH   B HHB B ,  H H
I@ lH(A HHA A 0  H H
@ lHf(A HHA A 8  HY H
? ulHf(pA HHvA xA @  H1 H
? =lHf(8A HH>A @A H  H	 H
j? lHf( A HHA A P  H H
2? kHf(@ HH@ @ X  H H
> kHf(@ HH@ @ ] H H
> bkHȋ? HHe@ g@       H H$  &kHHL kHH%@ '@ H$  L{ HD H$  oL HA H$  oL H> H$  ioL$  H6 H$  {D,  D$
  L$
  H H$  {0  $
  L$
  H H$  $|8  $
  L$
  H H$  W|@  $
  L$
  H H$  |H  $
  L$
  H H$  |P  $
  L$
  H} H$  |X  $
  L$
  H` H$  #}D] D$
  L$
  HH H$  [}H$  H$  qH! HL$p~> HT$pH$  kHL$p> AEH$  I
Hՠ H$0  3> L$0  H$  H$  MH$0  &> H$  8E$
  ,  $  H; H$  H$  /LL$   IH$  .H$   H$  $d0  $  8  $  P  $  @  $   X  $  H  $  HeBHcH$  H^ HL$p= HX H$  H$  H$  HT$pH$  < HL$p< L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  I$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(II;H$  9 3Ht$8D$0D$(H$`  HD$ L$   L$   II'IN8H$`  @AvhH$  ; H=A H$  H$  [VH$  )S  C  H	 H
B9 eHH: :       H] H$  eHH eHH: : H$  PL H H$  %jL> H H$  
jL H H$  iL$  H H$  CvD] D$
  L$
  H H$  yH$  讽H$  1H HL$p>: HT$pH$  +|HL$p?: AEH$  I	H H$0  9 L$0  H$  H$  IH$0  9 H$  @H$  苽Ht$ L$  L$   H$   If(f(\5B H H
G7 cHf(8 HH8 8 f(\f(D
< fAT^D fA/  A   = fD(E3L$   H$   If($      HO H
6 CcIH$0  6 HH
6 AHȋ7 HH 	cHH$  6 HH H
G6 bHHAHf(7 f(A\H H
6 bHf(7 HH{ bH7 H
5 7 H
5 7 
   ǀ       f(H$  S7 HȲ,q`Ht$8D$0D$(H$`  HD$ L$   L$   II"H HL$px7 LD$pH$  H$`  ]HHL$pq7 f(A\f(fAT^fA/#L$
  Ht$8D$0D$(H$`  HD$ L$   L$   IIA"IN8H$`  ;A~h    tdf(H$  G6 HȲ,e_H* HL$p6 LD$pH$  H$`  GHL$p6 H$  64 H$  Ht  H$  H$  H$  H$    H=W< H=N< H$  86 H$  H$  3 H$  3 H$   Ht[  H$   H$   H$   H$   6  H$  5 H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$     HL$`6 H$   Ht`  H$   H$   H$   H$   ;  H$`  4 H$P  H$  4 H$p  H$ 	  3 3{  HH$   H$   H+HHt?H;ra5 H$   HHD$`HHH$   H$   H+HH;r   t,H   1 Hл   DK>DH$  1        t@H H$  F^HH| 7^HHE3 G3 H$     t@H H$   ]HHS ]HH2 2 H$  Ѷx  tuD(  I|$ u_tZH HL$p3 H$  S4 H;7 H$  HT$pH$  3 HH H$  _  f(f(HT$`H$H  pM  H; H$
  ,   t-H׾ H
`0 \HH	2 2 3ۉ,  3Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$
  MIHH: H$
  Hy H$H  H$P  2 H$  1 H=7 H$  H$  T/ H$  E/ H$   Ht  H$   H$   H$   H$     H$  n1 H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`  Z  H$  HtG  H$  H$   H$(  H$   "  HL$`1 H$   Ht  H$   H$   H$   H$   
  H$`  s0 H$P  H$  \0 H$p  H$ 	  / 3  t(ttǄ$
  '  333ۉ$
  	$
  3ۍ$
  A@   tdy]
  HcHn
 m
 HMIH$  ~HH$  nLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  E|  MIH$  HH$  nLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH[H$  {B  MIH$  0HH$  nLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  {  MIH$  0HH$  nLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH+H$  }{  MIH$  5zHH$  nLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  E{z  MIH$  
zHH$  nLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  
{  MIH$  腅HH$  np  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  MLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ~  MIH$  ƆHH$  np  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  .Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$    MIH$  .HH$  &nL$P  L\$ L$p  LD$`HH$  /Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH[ H$  蝆B  MIH$  -HH$  nL$P  L\$ L$p  LD$`HH$  j/Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ;  MIH$  svHH$  mL$P  L\$ L$p  LD$`HH$  /Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  )   MIH$  avHH$  mL$P  L\$ L$p  LD$`HH$  0Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  藎H/o H$H  H$P  1( H$  *' H=*- H$  H$  $ H$  $ H$   HtF  H$   H$   H$   H$   !  H$  & H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$   j  HL$`& H$   HtK  H$   H$   H$   H$   &  H$`  % H$P  H$  % H$p  H$ 	  $ 3iH HL$pW% H$  & H( H$  HT$pH$  M% H( H$  H H$    L$P
  I[XA(sA({E(CE(KE(SIA_A^A]A\_^]b
 c
 (d
 d
 Xe
 e
 f
 wg
 fh
 (i
 i
 j
 7m
  	
H   HD$0LH  L  Lp  H  HD$(LT$ ItNH HL$8# HL$`$ H' HD$`HT$8HL$x# H HL$`  3HĨ   %" %! %! %! %! %! %! %! %! %! %% %% %$ %$ %$ %$ %$ %$ %$ %$ %$ H\$Ht$WH Ht*DAL
       @t	HK3   HCv  @tH   HH\$0Ht$8H _%# %# %# %# %# %# %X# %J# %4# %# %# %" %" @SH HH
 " HD$8HuH" ~     H
f h" HD$8H
L V" HD$@H`" HLD$@HT$8<  HHL$8@" H HL$@." H      HH [H(GHH(@SH    ! HH! H H HuC#H#   H
  H
  3H [HHXHhHxL` AUAVAWH 3ML;8   ;#  D eH%0   HXH;t  7 3H uA   ܛ t   [    H
   LH;   H
   MLHHI;rZH9} t  H9E tHM   Hs  HE H
~   H
i Hp  L;uL;tLLI  /  H8 H9 = D;   H=    3      eH%0   HXH;t  
 3Hʚ u    ;t   3  >H? H
?       ;uH? H
%   e    ;u
HH_ H9=` t!H
W   ;tMĺ   I=     H\$@Hl$HH|$PLd$XH A_A^A]HHXHpHxATH0IL   Xu u9 u
3ۉX   tu3H HtЋ؉D$ tLƋI4؉D$    LƋI  ؉D$ u5u1L3I  L3IL MtL3IAӅtu7LƋI#ˋىL$ tHr HtLƋIЋ؉D$ 3ۉ\$ t H\$@Ht$HH|$PH0A\H\$Ht$WH IHug  LǋHH\$0Ht$8H _H\$DD$HL$VWATH@IALHك|$pxI+H\$`H H\$hH@A\_^HLH D@HPSVWATH8MIcH` HHHHX|$pxH+H\$`HAD$    H8A\_^[%0 %" % % H
 8  H\$WH HO% H=H% HHtHH;rH\$0H _H\$WH H'% H= % HHtHH;rH\$0H _HMZ  f9t3HcH<H39PE  u  f9QLcA<E3LLA@EXJL EtQL;r
AL;rAH(E;r3HH(LL
Ijt"M+IIHt@$Ѓ3H(% % %l %^ H(uH=  u    H(H\$WH H'r Hd$0 H2-+  H;tHHr vHL$0 H\$0 DI3 DI3 HL$8DI3 L\$8L3H  L#H3-+  L;LDLq ILq H\$@H _%v % %b ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H@UH HHM( H ]@UH HHM( H ]@UH HHM( H ]@UH HHM(m H ]@UH HHM(M H ]@UH HHMh- H ]@UH HHM(
 H ]@UH HHM( H ]@UH HHM( H ]@UH HHM( H ]HT$UH HHM0HPHH
 H	 H H ]HT$UH HHMpHPHH
W H	f HU H ]HT$UH HHM@HPHH
 H	& H H ]HT$UH HHM`HPHH
 H	 H՛ H ]HT$UH HHM HPHH
 H	 H H ]HT$UH HHM(HPHH
g H	f HU H ]HT$UH HHM8HPHH
/ H	& H H ]HT$UH HHMHHPHH
 H	 H՚ H ]HT$UH HHMXHPHH
 H	 H H ]HT$UH HHMhHPHH
 H	f HU H ]HT$UH HHMxHPHH
O H	& H H ]HT$UH HH> H
 H	 Hۙ H ]@UH HHMP H ]@UH HHM@H ]@UH HEHt
eHHM@H ]@UH HHM@ H ]@UH HExtexHMp H ]@UH HHM( H ]@UH HH    H ]@UH HH    H ]@UH HHM(] H ]@UH HHMP H ]@UH HHM( H ]@UH HH   B H ]@UH HH    H ]@UH HH    H ]@UH HHM  H ]@UH HHM } H ]@UH HHM ] H ]@UH HHM  H ]@UH HHM m H ]@UH HHM M H ]@UH HHM - H ]@UH HHM`
 H ]@UH HHM  H ]@UH HHM  H ]@UH HHM  H ]@UH HHM` H ]@UH HHM  H ]@UH HHMpE H ]@UH HHMH H ]@UH HH    H ]@UH HH    H ]@UH HH   z H ]@UH HH   Z H ]@UH HH   : H ]@UH HHM(
 H ]@UH HHMP= H ]@UH HHM( H ]@UH HHMP H ]@UH HHMPnH ]@UH HH   KH ]@UH HHMh.H ]@UH HHM`.H ]@UH HHMPH ]@UH HHMP..H ]@UH HH   ˞H ]@UH Hꋅ   t   H   -H ]@UH HHMPnH ]@UH HHMP-H ]@UH HH   +H ]@UH Hꋅ   t   H   7-H ]@UH Hꋅ  t  H  H ]@UH HHMP螝H ]@UH HHMP,H ]@UH HH   [H ]@UH HH   {,H ]@UH HHM ^,H ]@UH HHM >,H ]@UH HH  ,H ]@UH HHM +H ]@UH HH   +H ]@UH HH   ˍH ]@UH HHMPNH ]@UH HHMPn+H ]@UH HH   H ]@UH Hꋅ   t   H   +H ]@UH Hꋅ  t  H  H ]@UH HHMP~H ]@UH HHMP*H ]@UH HH   ;H ]@UH HH   [*H ]@UH HHM >*H ]@UH HHM *H ]@UH HH  )H ]@UH HHM )H ]@UH HH   )H ]@UH HH   請H ]@UH HHMP.H ]@UH HHMPN)H ]@UH HH   H ]@UH Hꋅ   t   H   (H ]HT$UH HH HHEHHH H ]@UH HHM NH ]@UH HHM >H ]@UH HH   	 H ]@UH HH   	 H ]@UH HHM`H ]@UH HHM`讘H ]@UH HH(  z	 H ]@UH HHM nH ]@UH HHM NH ]@UH HHM >H ]@UH HH    H ]@UH HH    H ]@UH HHM`H ]@UH HHM`讗H ]@UH HH(  z H ]@UH HHM nH ]@UH HHM NH ]@UH HHM >H ]@UH HH    H ]@UH HH    H ]@UH HHM`H ]@UH HHM`讖H ]@UH HH(  z H ]@UH HHM nH ]@UH HHM NH ]@UH HHM >H ]@UH HH    H ]@UH HH    H ]@UH HHM`
H ]@UH HHM`讕H ]@UH HH(  z H ]@UH HHM nH ]@UH HHM NH ]@UH HHM >
H ]@UH HH   H ]@UH Hꋅ   t   H   H ]@UH HHMX H ]@UH HH    H ]@UH HH   j H ]@UH HHM ^H ]@UH HHMH~H ]@UH HHMH^H ]@UH HHMP>H ]@UH HH   H ]@UH HHMHH ]@UH HHMH·H ]@UH HHMP讇H ]@UH HHMP莇H ]@UH HHMP.H ]@UH HHMPAH ]@UH HHM H ]@UH HHM AH ]@UH HH   {AH ]@UH HHMP~H ]@UH HHMP.AH ]@UH HHM >H ]@UH HHM @H ]@UH HH   @H ]@UH HHMPΑH ]@UH HHMPZH ]@UH Hꋅ0  t0  H   ZH ]@UH HH   [H ]@UH HH   { H ]@UH HH  H ]@UH HH   KH ]@UH HHh   H ]@UH HH  H ]@UH HH   H ]@UH HHMP~H ]@UH HHMP^H ]@UH HHMPNYH ]@UH Hꋅ0  t0  H   YH ]@UH HH   H ]@UH HH   H ]@UH HH  諏H ]@UH HH   ۀH ]@UH HHh  Z  H ]@UH HH  蛀H ]@UH HH    H ]@UH HHMPH ]@UH HH   H ]@UH HH   WH ]@UH HH   諎H ]@UH HH   WH ]@UH HH@  Z  H ]@UH HHMh=  H ]@UH HHMh>WH ]@UH HHMhH ]@UH HHMhVH ]@UH HHMh΍H ]@UH HHMh  H ]@UH HHMh}  H ]@UH HH   kH ]@UH HH   KH ]@UH HHM0H ]@UH HHM0>H ]@UH HHM`ތH ]@UH HHM`H ]@UH HH   H ]HT$UH HnL LW .X   ] )3  H|w H ]@UH HH   +H ]@UH HH   KH ]@UH HH   H ]@UH HH   H ]@UH HHMh讋H ]@UH HHMhH ]@UH HHM8nH ]@UH HHM8H ]@UH HH   kH ]@UH HH   KH ]HT$UH HL' L V V   L\ 3  H H ]@UH HH   蛊H ]@UH HH   H ]@UH HH   [H ]@UH HH   KSH ]@UH HH   H ]@UH HH   SH ]@UH HHM@RH ]@UH HHM@辉H ]@UH HHM@RH ]@UH HHM@~H ]@UH HHM@H ]@UH HH   ;H ]@UH HH   H ]@UH HHM H ]@UH HHM 7H ]@UH HH   諈H ]@UH Hꋅ  t  H   G7H ]@UH HHMP^H ]@UH HHMP~H ]@UH HH   [H ]@UH HH   ;H ]@UH HHM ·H ]@UH HHM H ]@UH HH   苇H ]@UH HH   {H ]@UH HH   KH ]@UH HH   5H ]@UH HH     H ]@UH HHM`H ]@UH HHM`ΆH ]@UH HHM`~5H ]@UH HH   苆H ]@UH HHM nH ]@UH HH  :  H ]@UH HHMpnH ]@UH HHM8H ]@UH HHM8.H ]@UH HH   ˅H ]@UH HH   H ]@UH HH  H ]@UH HH  H ]@UH HHP  ;iH ]@UH HH   iH ]@UH HH   +H ]@UH HH   H ]@UH HH   ;yH ]@UH HH   H ]@UH HH   xH ]@UH HHM0H ]@UH HHM0H H ]@UH HH   KH ]@UH HHM0HPZH ]@UH HHM0gH ]@UH HH0  H ]@UH HH0  H H ]@UH HH   H ]@UH HH0  HPH ]@UH HH0  ;gH ]@UH HH@  KH ]@UH HH`  iH ]@UH HEhtehH  miH ]@UH HH`  H ]@UH HH   H ]@UH HH  H ]@UH HH   KH ]@UH HH   ;KH ]@UH HH   H ]@UH HH   JH ]@UH HHM`JH ]@UH HHM`讁H ]@UH HHM`JH ]@UH HHM`nH ]@UH HHM0H ]HT$UH HvLg L@L L   R ]$  HF H ]@UH HH   ۀH ]@UH HH   軀H ]@UH HHMP莀H ]@UH HHMP~H ]@UH HHM NH ]@UH HHM >H ]@UH HH   H ]@UH HH   H ]@UH HHM H ]@UH HHMPH ]@UH HHM H ]@UH HHM ~H ]@UH HH   :  H ]@UH HH     H ]@UH HHM`H ]@UH HHM`~H ]@UH HH(    H ]@UH HHM ~H ]@UH HHM`oH ]@UH HHM0nH ]@UH HHM0nnH ]@UH HHMHNnH ]@UH HHMH.nH ]@UH HH   +H ]@UH HHM mH ]@UH HHM mH ]@UH HH   H ]@UH HH   mH ]@UH HHp  ;}H ]@UH HHp  +FH ]@UH HH  |H ]@UH HH  EH ]@UH HH  |H ]@UH HH  H ]@UH HH   H ]HT$UH HNqL LpG H v  M !  Ha H ]@UH HH   WH ]HT$UH HpL' L G G w  LM !  H H ]@UH HH   DH ]@UH HH   {{H ]@UH HH   kDH ]@UH HH   ;{H ]@UH HHM jH ]HT$UH HoL7 LF F   \L "  H H ]@UH HH   H ]HT$UH H~oLǨ LE >F   K (#  H H ]@UH HH  ;zH ]@UH HH  zH ]@UH HHp  yH ]HT$UH0HHj H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH
 H0]HT$UH0HH* H0]HT$UH0HHJ H0]HT$UH0HHj H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]@UH HHM(-  H ]@UH HHM(
  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM@H ]@UH HHM@H ]@UH HHM(H ]@UH HHM(H ]HT$UATH(HHUpHHcHHA     H H(A\]@UH HHM(nH ]@UH HHM(NH ]@UH HHM(.H ]HT$SUH(HHUpHHcHHA   f  H: H(][@UH HHM(H ]@UH HHM`  H ]@UH HHM8
  H ]@UH HH     H ]@UH HHMh  H ]@UH HHM(  H ]@UH HHM`  H ]@UH HHM8m  H ]@UH HHMHM  H ]@UH HH   r  H ]@UH HHM 
  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HHM m  H ]@UH HHM M  H ]@UH HHM -  H ]HT$UH HHMHHt
H   33kH ]HT$UH HHMHHt
H   33+H ]HT$UH H33H ]@UH HH     H ]@UH HHMhM  H ]@UH HHM(}  H ]@UH HH   R  H ]@UH HHM(  H ]@UH HH     H ]@UH HHMP  H ]@UH HHMH  H ]@UH HHM m  H ]@UH HHM M  H ]@UH HHM -  H ]@UH HHM 
  H ]@UH HHM   H ]@UH HH     H ]@UH HHMH  H ]@UH HHM   H ]@UH HHMHm  H ]@UH HHM M  H ]@UH HHMH-  H ]@UH HHM@^H ]@UH HHM@  H ]@UH HHM@  H ]@UH HHM@  H ]@UH HHM@~H ]HT$UH HHMHƾ33վH ]@UH HHM@  H ]@UH HHM@H ]@UH HH     H ]@UH HHM8  H ]@UH HH    H ]@UH HHM`  H ]HT$UH H33H ]@UH HHM@^aH ]@UH HHUXHM(H ]HT$SUWH HH]PH}`H;t@ H  H(H;u33iH _][@UH HHM0  H ]@UH HH   HM(臻H ]HT$SUWH HH   H   H;tHu  H(H;u33׼H _][@UH HHM@H ]@UH HHM@m  H ]@UH HHM@H ]@UH HHM@H ]@UH HHMHnH ]@UH HEPtePHM@HxH ]@UH HEXteXHM@HxlH ]@UH HHM@nsH ]@UH HHU(HM0H ]HT$SUWH HH]XH}PH;t@ H  H(H;u33IH _][@UH HEPtePHM@HPH ]@UH HEPtePHM@Hx|H ]@UH HHM@~rH ]@UH Hꋅ   t   HM(HP&H ]@UH HHM(]H ]@UH Hꋅ   t   HM HxH ]@UH HHM   H ]@UH HHM >H ]@UH HEXteXHM@HxlH ]@UH HHM@rH ]@UH HEXteXHM@HxH ]@UH HHM@^H ]@UH HEPtePHM@H`H ]@UH HEPtePHM@HxH ]@UH HHM@qH ]@UH HEPtePHM@HxLH ]@UH HHM@莋H ]@UH Hꋅ   t   HM(H`H ]@UH HHM(H ]@UH HEXteXHM@H`H ]@UH HHM@H ]HT$UH HH   賷33·H ]@UH HH     H ]@UH HH   ;-H ]@UH HHM0  H ]HT$UH HH7 H ]@UH HEPtePHM@H`H ]@UH HHM@H ]@UH Hꋅ   t   HM HxVH ]@UH HHM }  H ]@UH HHM H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEPtePHM@HxLH ]@UH HHM@^H ]@UH HEPtePHM@HxH ]@UH HHM@.H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEPtePHM@Hx\H ]@UH HHM@NH ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEPtePHM@HxH ]@UH HHM@H ]@UH HH     H ]@UH HH   J  H ]@UH HHMP}  H ]@UH HH   R  H ]@UH HH     H ]@UH HHMP  H ]@UH HHM H ]@UH HH     H ]@UH HH   j  H ]@UH HHMP  H ]@UH HH   r  H ]@UH HH   
  H ]@UH HHMP=  H ]@UH HHM@cH ]@UH HHM@H ]@UH HHM(cH ]@UH HHM@m  H ]@UH HH   KUH ]@UH HH   ;aH ]@UH Hꋅ0  t0  HM0HPH ]@UH HHM0TH ]@UH HHM0`H ]@UH HH@  KH ]@UH HH8  +H ]@UH HHM0H ]@UHmD dD ]@UH HHH  wH ]@UH Hꋅ0  t0  HH  HPH ]@UH HHM HH ]@UH HH   SH ]@UH HH   [`H ]@UH Hꋅ@  t@  HM0HPVH ]@UH HHM0.SH ]@UH HHM0_H ]@UH HHX  H ]@UH HHH  {H ]@UH HHM0H ]@UHB B ]@UH HH   ǮH ]@UH Hꋅ@  t@  H   HPCH ]@UH HHM HH ]HT$UH HHMXF33UH ]@UH HHMPH ]@UH HEHteHHMPHPH ]@UH HHMP~]H ]@UH HHMP読H ]@UH HEHteHHMPHP,H ]@UH HHMP]H ]@UH HH   eH ]@UH HjpH  H ]@UH HjpH    H ]@UH HHMHڬH ]@UH HjpHMH H ]@UH HjpHM` H ]@UH HHM@.^H ]@UH HHMPH*NH ]@UH HHMPH
NH ]@UH HHM`HMH ]@UH HHM`HMH ]@UH HHM`H0MH ]@UH Hꋅ   t   HMXH ]@UH Hꋅ   t   HM(jH ]@UH HHM@]H ]HT$UH HHM@]33EH ]@UH HHM@\H ]HT$UH HHM@z]33H ]HT$UH HHMp趪33ŪH ]HT$UH H33螪H ]HT$SUVWATH0HDe0A~$H}@HH]8LHH   H¯H   H]8H}@E~#H   HHLHHH良H33H0A\_^][@UH HHMPm  H ]HT$UH0HH   LH   HA NH   HPJ33萩H0]@UH HHMP  H ]HT$UH HHM`633EH ]HT$UH H33H ]HT$UH HHM`33H ]HT$UH H33ΨH ]@UH HHM@HjJH ]@UH HHM@HJJH ]@UH HHM@H(*JH ]@UH HHM@H8
JH ]@UH HHM@HHIH ]@UH HHM@HXIH ]@UH HHMPHH ]@UH HHM(nYH ]@UH HHMPH@H ]@UH HHM0.YH ]@UH HHM@~H ]HT$UH0HH   Y33BH0]HT$SUH8HL   H   HH   uH33H8][@UH HH   _H ]@UH HH   yH ]@UH HH   軏H ]@UH HHUXHM(ڤH ]HT$SUVWH(HH]PH}`H;tHuhHHTH0H;u33&H(_^][@UH HH   H ]@UH HHMpm  H ]@UH HHMHM  H ]@UH HHM -  H ]@UH HH   
  H ]@UH HH   :  H ]@UH HH   H ]@UH HH  H ]@UH HHM`VH ]HT$UH0HHM`芪33դH0]HT$UH HHM@*W33襤H ]HT$UH0HHM`V33uH0]HT$UH HHM@V33EH ]HT$UH0HHMh33H0]@UH HHM@  H ]@UH Hꋅ`  t`  HP  F  H ]@UH HHMPu  H ]@UH HHM(
  H ]HT$UH0HHMpF33UH0]HT$UH0H33.H0]@UH HHM(  H ]@UH HHMP  H ]@UH HHMPH ]@UH HHM(H ]@UH HHMh  H ]@UH HHM(M  H ]@UH HHM(H ]@UH HH   YH ]@UH HHUXHM(zH ]HT$SUVWH(HH]PH}`H;tHuhHHH0H;u33ơH(_^][@UH HHMH-  H ]@UH HHM 
  H ]@UH HH   :  H ]@UH HH   H ]@UH HH@  H ]HT$UH0HH   触33H0]@UH HHMp]  H ]@UH HHMH=  H ]@UH HHM   H ]@UH HH     H ]@UH HH   *  H ]@UH HH   kH ]@UH HH  ۬H ]@UH HHMp~H ]@UH HHMpnQH ]@UH HHMp^H ]@UH HHMp.QH ]@UH HH     H ]@UH HHM@  H ]@UH HHM`H ]@UH HH     H ]@UH HHMh}  H ]@UH HHM   H ]@UH HHM H ]@UH HH  kWH ]@UH HH   B  H ]@UH HHMh  H ]@UH HHM 
  H ]@UH HHM NH ]@UH HH  VH ]@UH HHM(]  H ]@UH HHM(=  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(ݿ  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(}  H ]@UH HHM@.H ]@UH HHU(HM0H ]HT$SUVWH(HH]hH}`H;tHuxHH蔸H0H;u33fH(_^][@UH HHU(HM0誚H ]HT$SUVWH(HH]hH}`H;tHuxHH$H0H;u33H(_^][@UH HHM8=H ]@UH HHM@>H ]@UH HHM0H ]@UH HH   MH ]@UH HH   +H ]@UH HH   LH ]@UH HH   H0H ]@UH HHM@LH ]@UH HH   HxH ]@UH HHMHNLH ]@UH HH   H   dH ]@UH HHMPKH ]@UH HH   H   H ]@UH HHMP~H ]@UH HHM`^H ]@UH HHMX>H ]@UH HHM@H ]@UH HHM@辻H ]@UH HHMHޗH ]@UH HHMPݻ  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHMP}  H ]@UH HH   H ]@UH HH   ;H ]@UH HH   +JH ]@UH HH   KH ]@UH HH   IH ]@UH HH   H ]@UH HHP    H ]@UH HHM@}  H ]@UH HH     H ]@UH HHP  :  H ]@UH HHM@nH ]@UH HHM@  H ]@UH HHx  ڹ  H ]@UH HHP    H ]@UH HHMpH ]HT$SUH8HH) HM@Q  HH0  HRLHHx    HH  n  HV H  HH  '  Hg5 H  H8][@UH HHM@  H ]@UH HHx  ʸ  H ]@UH HH    H ]@UH HHM@  H ]@UH HHM@m  H ]@UH HH`    H ]@UH HHM@-  H ]@UH HHMp^H ]@UH HHP    H ]@UH HHx  ʷ  H ]@UH HHM@  H ]@UH HHMpH ]HT$SUH8HH& HM@A  HH8  HRLHHx    HH   ^  HF H   HH8    HW3 H   oH8][@UH HHM@ݶ  H ]@UH HHx    H ]@UH HH     H ]@UH HHM@}  H ]@UH HHM@]  H ]@UH HH    H ]@UH HHM@  H ]@UH HHMpNH ]@UH HHP  ڵ  H ]@UH HHx    H ]@UH HHM@  H ]@UH HHMpH ]@UH HH  kDH ]@UH HH  H ]HT$SUH8HHs$ HM@  HH@  HRLHHx    HH    H H  HH  Ǵ  H1 H  H8][@UH HHM@  H ]@UH HHx  j  H ]@UH HH    H ]@UH HHM@-  H ]@UH HHM@
  H ]@UH HH`  :  H ]@UH HHM@ͳ  H ]@UH HHMpH ]@UH HHP    H ]@UH HHx  j  H ]@UH HHM@M  H ]@UH HHMp~H ]HT$SUH8HH;" HM@  HHP  HRLHHx    HH    H H  HH    H. H  H8][@UH HHM@}  H ]@UH HHx  Z  H ]@UH HH    H ]@UH HHM@  H ]@UH HHM@  H ]@UH HH`  *  H ]@UH HHM@  H ]@UH HHMpH ]@UH HHP  z  H ]@UH HHx  Z  H ]@UH HHM@=  H ]@UH HHMpnH ]@UH HH  @H ]@UH HH  +H ]HT$SUH8HH HM@  HHX  HRLHHx  F  HH  讬H, H  ߍH8][@UH HHM@M  H ]@UH HHx  *  H ]@UH HHM8?H ]@UH HHM8>H ]@UH HHMh>H ]@UH HHMhH ]@UH HHMPծ  H ]@UH HHM m  H ]@UH HHM M  H ]@UH HHM -  H ]@UH HHM 
  H ]@UH HHM   H ]@UH HHM ͮ  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM m  H ]@UH HHM M  H ]@UH HHM -  H ]@UH HHM 
  H ]@UH HHM   H ]@UH HHM ͭ  H ]@UH HHM   H ]@UH HHM   H ]@UH HHMX~<H ]@UH HE t
e HMX`H ]@UH HHMx  H ]@UH HHM8M  H ]@UH HHU0HM@躈H ]HT$UH0HHM033%H0]@UH HHU0HM@jH ]HT$UH0HHM0Ɖ33ՉH0]@UH HHMxn+H ]@UH HHMXN+H ]@UH HHMp;H ]@UH HHMp.H ]@UH HH   :H ]@UH HH   H ]@UH HHP  :H ]@UH HHP  H ]@UH HH   K:H ]@UH HH   kH ]@UH HHM@:H ]@UH HHM@.H ]@UH HH    H ]@UH HH    H ]@UH HH  ©  H ]@UH HH  Z  H ]@UH HH    H ]@UH HH    H ]@UH HH  B  H ]@UH HH  ک  H ]@UH HH    H ]@UH HH    H ]@UH HH  ¨  H ]@UH HH  Z  H ]@UH HH    H ]@UH HH    H ]HT$UH0H H  0H0]HT$UH0H H  /H0]@UH HHM@7H ]@UH HHM@H ]@UH HH     H ]@UH HH   :  H ]@UH HHMP.7H ]@UH HHMPH ]@UH HHM(ݧ  H ]@UH HHM(  H ]@UH HHMP6H ]@UH HH   &H ]@UH HHM n6H ]@UH HHM ^H ]@UH HH     H ]@UH HH     H ]@UH HHMP5H ]@UH HHMPޭH ]@UH HHMP5H ]@UH HHM 5H ]@UH HHM@n5H ]@UH HHM@H ]@UH HHU0HM8H ]HT$SUVWH(HH] H   H;t$H   f     HHeH0H;u337H(_^][@UH HHM@4H ]@UH HHM@H ]@UH HHMpn4H ]@UH HHMpH ]@UH HHMP.4H ]@UH HHMPNH ]@UH HHM 3H ]@UH HHM ޫH ]@UH HH     H ]@UH HH   z  H ]@UH HHMX  H ]@UH HHMPn#H ]@UH HHMp.3H ]@UH HHMpNH ]@UH HHM@2H ]@UH HHM@H ]@UH HH   2H ]@UH HH   H ]@UH HHMp"H ]@UH HHM`n"H ]@UH HHM`N"H ]@UH HHM`."H ]@UH HHMh"H ]@UH HHM`H!H ]@UH HHM`!H ]@UH HHM`!H ]@UH HHMh!H ]@UH HH   k!H ]@UH HH   K!H ]@UH HH   +!H ]@UH HH   !H ]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH   k H ]@UH HH   HG H ]@UH HHMp. H ]@UH HHMp H ]@UH HHMxH ]@UH HHM(  H ]@UH HHM(}  H ]@UH HHM(]  H ]@UH HHM(=  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(ݟ  H ]@UH HHM(  H ]@UH HHM`.H ]HT$UH0HHM`33|H0]HT$UH0HHUxHM`&|33|H0]HT$UH0HHUxHM`{33|H0]@UH HHM8  H ]@UH HHM`  H ]@UH HHM`-H ]@UH HEpt
epHM`蠥H ]@UH HHM(]  H ]@UH HH   kH ]HT$UH0HHM`蚃33{H0]@UH HH   ,H ]@UH HH   H ]@UH HHMH,H ]@UH HHMH޻H ]@UH HHM@~,H ]@UH HHM@螻H ]@UH HHU0HM8
yH ]HT$SUVWH(HH] H   H;t$H   f     HHuH0H;u33GzH(_^][@UH HH  +H ]@UH HH  ۺH ]@UH HH   {+H ]@UH HH   蛺H ]@UH HH   ;+H ]@UH HH   [H ]@UH HH(  *H ]@UH HH(  H ]@UH HHM`*H ]@UH HHM`޹H ]@UH HH    H ]@UH HH   J  H ]@UH HH  r  H ]@UH HH   
  H ]@UH HH  2  H ]@UH HHX  ʚ  H ]@UH HH    H ]@UH HH     H ]@UH HH    H ]@UH HHX  J  H ]@UH HH  r  H ]@UH HH   
  H ]@UH HH  2  H ]@UH HH   ʙ  H ]@UH HH    H ]@UH HH     H ]HT$UH0HI H   H0]@UH HH   K(H ]@UH HH   kH ]HT$UH0H H   H0]@UH HHMPnH ]@UH HHM('H ]@UH HHM(讟H ]@UH HHM(~'H ]@UH HHM(^'H ]@UH HHM(^H ]@UH HHM(>H ]@UH HHM@&H ]@UH HHM@H ]@UH HHMpH ]@UH HH   Җ  H ]@UH HH   j  H ]@UH HHMP~H ]@UH HHMP^H ]@UH HHM`&H ]HT$UH0HHM`j|33UtH0]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   ;H ]@UH HHMpNH ]@UH HHMp.H ]@UH HH   H ]@UH HH   H ]@UH HHM $H ]@UH HHM γH ]@UH HHMPn$H ]@UH HHMP莳H ]@UH HHMppH ]@UH HHM(NH ]@UH HHM H ]@UH HHMpH ]@UH HHMpH@H ]@UH HHM }  H ]@UH HHMP  H ]@UH HHM =  H ]@UH HHM(  H ]@UH HHMPM  H ]@UH HHM(ݓ  H ]@UH HHMP
  H ]@UH HHM@"H ]HT$UH HHM@F33pH ]@UH HHM@^"H ]HT$UH HHM@F33pH ]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   HnH   H]@H}8E~)H   HLRILHHHHmHo33oH0A\_^][@UH HHMP记H ]HT$UH0HH   L@IH   HA MH   HPIbm33}oH0]@UH HHMP>H ]@UH HHMxmH ]@UH HHMxmH ]@UH HH    H ]@UH HH   軯H ]@UH HH   [ H ]@UH HH   {H ]@UH HHMxlH ]@UH HH@  H ]@UH HH@  H ]@UH HH  H ]@UH HH  ۮH ]@UH HH   {H ]@UH HH   蛮H ]@UH HH`  r  H ]@UH HH  
  H ]@UH HH`  2  H ]@UH HH  ʏ  H ]@UH HH     H ]@UH HH    H ]@UH HH     H ]@UH HHp  J  H ]@UH HH   r  H ]@UH HH  
  H ]@UH HH   2  H ]@UH HH  ʎ  H ]@UH HH`    H ]@UH HHp    H ]@UH HH`    H ]@UH HHp  J  H ]HT$UH0H	 H0  AH0]@UH HH`  B  H ]@UH HHp  ڍ  H ]@UH HH`  
  H ]@UH HH`    H ]@UH HHp  z  H ]@UH HH    H ]@UH HH`    H ]@UH HHp    H ]@UH HH  J  H ]@UH HHp  H ]@UH HHp  H ]HT$UH0Hy HP  H0]@UH HHh  KhH ]@UH HHh  +hH ]@UH HH   ;H ]@UH HH   [H ]@UH HH   H ]@UH HH   H ]@UH HH  H ]@UH HH  ۩H ]@UH HH8  {H ]@UH HH8  蛩H ]@UH HHMx>H ]@UH HHMx^H ]@UH HH`  2  H ]@UH HH  ʊ  H ]@UH HH`    H ]@UH HH    H ]@UH HH     H ]@UH HH  J  H ]@UH HH   r  H ]@UH HHp  
  H ]@UH HH   2  H ]@UH HH  ʉ  H ]@UH HH     H ]@UH HH    H ]@UH HH`    H ]@UH HHp  J  H ]@UH HH`  r  H ]@UH HHp  
  H ]HT$UH0H H0  H0]@UH HH`    H ]@UH HHp    H ]@UH HH`  ʉ  H ]@UH HH`    H ]@UH HHp  :  H ]@UH HH  j  H ]@UH HH`  B  H ]@UH HHp  ڇ  H ]@UH HH  
  H ]@UH HHp  H ]@UH HHp  ˥H ]HT$UH0H9 HP  qH0]@UH HHMx-  H ]@UH HHM8]  H ]@UH HHM8螂H ]@UH HH   H ]HT$SUH8HL   H   HH   aHc33cH8][@UH Hj@HM轷H ]@UH Hj@HM 蝷H ]@UH HHM@莊H ]@UH HHM@HH ]@UH HHMHH ]@UH HHMHH ]@UH HH   H ]@UH HH   HH ]@UH HH   H ]@UH HH   HgH ]@UH HHMp  H ]@UH HHM`讈H ]@UH HHM@H ]@UH HHM@H ]@UH HHM(H ]@UH HHM(H ]@UH HHM@莃H ]@UH HHM@H 芢H ]@UH HHMHNH ]@UH HHM@HPZ~H ]@UH HHM@H ]@UH HHMHH ]@UH HHM@΂H ]@UH HHMH讂H ]@UH HHM@HڇH ]@UH HHM@H@:H ]@UH HHM@H  H ]@UH HHMH.H ]@UH HHM@Hق  H ]@UH HHM@H0H ]@UH HHM@HpH ]@UH HHM@H   v  H ]@UH HHMHnH ]@UH HHMHNH ]@UH HHM@nH ]@UH HHM@H  ~H ]@UH HHM@H  H ]@UH HHM@H  藿H ]@UH HHM@H  跈H ]@UH HHM@H@  WH ]@UH HHM@Hp  觟H ]@UH HHM@H  臟H ]@UH HHM0.H ]@UH HHM0NH ]@UH HH@  H ]@UH HHM0H ]@UH HH     H ]@UH HHp  ˞H ]@UH HH   H ]HT$UH0HHMx]33]H0]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   H/[H   H]@H}8E~)H   HLRILHHHHZH\33]H0A\_^][@UH HHMP辝H ]HT$UH0HH   L@IH   HA MH   HPIrZ33\H0]@UH HHMPNH ]@UH HHh  
H ]@UH HHh  H ]@UH HH   
H ]@UH HH   ˜H ]@UH HHMh]~  H ]@UH HH   :~  H ]@UH HH   ~  H ]@UH HHM0NH ]@UH HHMh}  H ]@UH HHM0H ]@UH HH   }  H ]@UH HH   z}  H ]@UH HHMh]}  H ]@UH HHM0莛H ]@UH HHMh}  H ]@UH HHM0NH ]@UH HH   |  H ]@UH HH   |  H ]@UH HHMh|  H ]@UH HHM0ΚH ]@UH HHM0nH ]@UH HHM0莚H ]@UH HHMh|  H ]@UH HHM0NH ]@UH HH   {  H ]@UH HH   {  H ]@UH HHMh{  H ]@UH HHM0ΙH ]@UH HHM0n
H ]@UH HHM0莙H ]@UH HHMh{  H ]@UH HHM0NH ]@UH HH   z  H ]@UH HH   z  H ]@UH HHMhz  H ]@UH HHM0ΘH ]@UH HHM0n	H ]@UH HHM0莘H ]@UH HHMhz  H ]@UH HHM0NH ]@UH HH   y  H ]@UH HH   y  H ]@UH HHMhy  H ]@UH HHM0ΗH ]@UH HHMh]y  H ]@UH HHM0莗H ]@UH HH   y  H ]@UH HH   x  H ]@UH HHMhx  H ]@UH HHM0H ]@UH HH   H ]@UH HH   ˖H ]@UH HHM0nH ]@UH HHM0H ]@UH HHMhx  H ]@UH HHM0NH ]@UH HH   w  H ]@UH HH   w  H ]@UH HHMhw  H ]@UH HHM0ΕH ]@UH HHM0nH ]@UH HHM0莕H ]@UH HHMhw  H ]@UH HHM0NH ]@UH HH   v  H ]@UH HH   v  H ]@UH HHMhv  H ]@UH HHM0ΔH ]@UH HH   kH ]@UH HH   苔H ]@UH HHM0.H ]@UH HHM0޳H ]@UH HHMhu  H ]@UH HHM0H ]@UH HH   H ]@UH HH   zu  H ]@UH HH   Zu  H ]@UH HHMh=u  H ]@UH HH8  kH ]@UH HHM0t  H ]@UH HH8  +H ]@UH HH   t  H ]@UH HHMht  H ]@UH HHM0}t  H ]@UH HH8  諒H ]@UH HH   :t  H ]@UH HH8  kH ]HT$UH0H H  H0]@UH HHMpH ]@UH HHMpH ]@UH HHM8nOH ]HT$UH0H33PH0]@UH HHMpNH ]@UH HHMpnH ]@UH HHM8NH ]HT$UH0H.33IPH0]@UH HHM8H ]@UH HHM8ސH ]@UH HH   KNH ]HT$UH0H33OH0]@UH HHM8.H ]@UH HHM8NH ]@UH HH   MH ]HT$UH0H33)OH0]@UH HHM@HH ]@UH HHMH~ H ]@UH HHM@^ H ]HT$SUH8HH   H{8 t'HM8HPHHK8nHH|p  ~p  H1% H8][@UH HH   p  H ]@UH HHM`H ]@UH HHM`ގH ]@UH HHM8mp  H ]@UH HH   [H ]@UH HH   {H ]@UH HHM8
p  H ]@UH HHM8o  H ]@UH HHM8o  H ]@UH HHM8o  H ]@UH HHM8o  H ]@UH HHM8mo  H ]@UH HHM8Mo  H ]@UH HH   ;H ]@UH HH   [H ]@UH HHMPH ]@UH HHMPH ]@UH HjPHM
H ]@UH HHMprH ]@UH HHMpHH ]@UH HHMpHHjH ]@UH HHM(>H ]@UH HHMpH   WH ]@UH HHM0H ]@UH HHMpH   H ]@UH HHM8H ]@UH HHMpH   ׋H ]@UH HHM`nH ]@UH HHMp~H ]@UH HHM`H@ZH ]@UH HHM 
m  H ]@UH HHMP5l  H ]@UH HHM l  H ]@UH HHM l  H ]@UH HH   H ]@UH HH   車H ]@UH HH   蛊H ]@UH HH   H ]@UH HHM8^H ]@UH HHMhH ]@UH HHMhH ]@UH HH(  H ]@UH HHMPk  H ]@UH HE@t
e@HMHH ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHMx^oH ]@UH HHMpiH ]@UH HHM(iH ]@UH HHMpHnH ]@UH HHMpH@ZH ]@UH HHMpH  7H ]@UH HHM(NiH ]@UH HHMx.iH ]@UH HHM(H ]@UH HH   蛩H ]@UH HHM0H ]@UH HH   HHǇH ]@UH HHM8nH ]@UH HH   Hx臇H ]@UH HHM@.H ]@UH HH   H   DH ]@UH HHMHH ]@UH HH   H   脦H ]@UH HHMPH ]@UH HH   H  褆H ]@UH HHMX>H ]@UH HH   H@  H ]@UH HH   Hp  H ]@UH HHM@HH ]@UH HHM@H8څH ]@UH HHM@HpJH ]@UH HHM@H   gnH ]@UH HHM@H   7H ]@UH HHM@Hp  WH ]@UH HHM@H  f  H ]@UH HHM@H  觤H ]@UH HHM@Hf  H ]@UH HHM@H0誾H ]@UH HHM@Hp芾H ]@UH HHM@H   Ff  H ]@UH HHMp~H ]@UH HHM8H ]@UH HHM8>H ]@UH HH  H ]@UH HE0te0H  H ]@UH HHx  ˃H ]@UH HHM0讃H ]@UH HH0  d  H ]@UH HH  e  H ]@UH HH   Jf  H ]@UH HHM`H ]@UH HHM`H ]@UH HH   H ]@UH HH   ˂H ]@UH HHP  諂H ]@UH HHM8莂H ]@UH HH  bc  H ]@UH HH   c  H ]@UH HH   *e  H ]@UH HHMhH ]@UH HHMhH ]@UH HHH  H ]@UH HE0te0HH  蝁H ]@UH HH   {H ]@UH HHMpH ]@UH HHMp>H ]@UH HHM@~H ]@UH HHM@辰H ]@UH HHM(b  H ]@UH HHMPc  H ]@UH HH  蛀H ]@UH HH   ;H ]@UH HHM H ]@UH HHM >H ]@UH HHMPH ]@UH HHMPH ]@UH HHMPH ]@UH HHM(H ]@UH HH   +=H ]HT$UH H33>H ]@UH HH   +H ]@UH HH   H ]HT$UH0HH   7F33">H0]@UH HHM(^ZH ]@UH HHMHaH ]@UH HHM(^H ]@UH HHMpHz~H ]@UH HHM0H ]@UH HHMpH8:~H ]@UH HHM8H ]@UH HHMpHp芝H ]@UH HHM@H ]@UH HHMpH   fH ]@UH HHMxHI_  H ]@UH HHMxH0JH ]@UH HHMxHp*H ]@UH HHMxH   ^  H ]@UH HHMpH   H ]@UH HHMHH ]@UH HHMpHp  |H ]@UH HHMpH  f^  H ]@UH HHMP^H ]@UH HHMpH  H ]@UH HHMXH ]@UH HHM H ]@UH HHM 讛H ]@UH HH   \  H ]@UH HHMh]  H ]@UH HHM`\  H ]HT$SUH(HHU HM`\  Hx HM 2]  t*HU HM``\  H  LHAHM ]  33o:H(][@UH HHM \  H ]@UH HHM \  H ]@UH HHEXD HUPHM(r8H ]HT$SUH8HHM@HPHHMX;\  H   HHUXHHMX<\  LHASH[ H8][@UH HHMX
\  H ]@UH HHMHH ]@UH HHMHH ]HT$SUH8HHU8H   HoH HMXn[  HHUXHHMXv[  H HMXE[  HHUXHHMXM[  LHASH] H8][@UH HHMX[  H ]@UH HHMXZ  H ]@UH HHMXZ  H ]@UH HHMXZ  H ]@UH HHMXZ  H ]@UH HHMX}Z  H ]@UH HHMX]Z  H ]@UH HHMX=Z  H ]@UH HHE0D HU(HM85H ]HT$SUWH HH]hH}pH;t!@ HKZ  HKZ  H(H;u33.7H _][@UH HHM H ]@UH HHM H ]@UH HHMhH ]@UH HH   KH ]@UH HHM@.H ]@UH HHM@NwH ]@UH HH   XH ]@UH HHMXH ]@UH HH   H wH ]@UH HHM(H ]@UH HHM(vH ]@UH HHM0NH ]@UH HHM0>_H ]@UH HHM0H ]@UH HHM H ]@UH HHM 螕H ]@UH HH   H ]@UH Hꋅ0  t0  H   GH ]@UH HH   uH ]@UH HHM`>H ]@UH HHM`^uH ]@UH HHM@^H ]HT$UH0HL   HU8HMpcLU  AHEx@(H H0]@UH HH   H ]@UH HH   H ]@UH HHMHnH ]@UH HHMHNH ]@UH HH   +H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHM8H ]@UH HHM8H ]@UH HHM`nH ]@UH HH   bT  H ]@UH HH   T  H ]HT$UH0HMXMX  ;|4  H HD$ L
c L  H- H
 詍H H0]@UH HH  S  H ]@UH HH  S  H ]@UH HH  *T  H ]@UH HH   
T  H ]@UH HHMxS  H ]@UH HHh  S  H ]@UH HHMPS  H ]@UH HH@  S  H ]@UH HH   jS  H ]@UH HH   JS  H ]@UH HHM(-S  H ]@UH HHM(
S  H ]@UH HH   H ]@UH HH   YH ]@UH HHMpH ]@UH HHMppH ]@UH HH0  軪H ]@UH HH   [H ]@UH HH   {pH ]@UH HH(  H ]@UH HH(  ;pH ]@UH HHM@H ]@UH HHM@莏H ]@UH HH  UH ]@UH HH(  {H ]@UH HH  HgH ]@UH HH(  ;H ]@UH HH  HH'H ]@UH HHP  H ]@UH HH  H   oH ]@UH HHX  H ]@UH HH  H   nH ]@UH HH`  [H ]@UH HH  H   tnH ]@UH HH  KH ]@UH HHX  KTH ]@UH HH0  O  H ]@UH HH  N  H ]@UH HH  zO  H ]@UH HHM@]O  H ]@UH HHMp=O  H ]@UH HH   O  H ]@UH HH(  N  H ]@UH HH   N  H ]@UH HH  N  H ]@UH HHX  N  H ]@UH HH   zN  H ]@UH HH   ZN  H ]@UH HH   KH ]@UH HH   +H ]HT$SUHHHH H   M  HH  HH   HH   M  H  HPHH   M  HH   HH   M  H HH][@UH HH   ZM  H ]@UH HH   :M  H ]@UH Hj HM}~H ]@UH HH   +LH ]@UH HH   H 'kH ]@UH HH   HPGH ]@UH HH   H ]@UH HH   H   jH ]@UH HHM(ML  H ]@UH HHMP}M  H ]@UH HH   +SH ]@UH HHMhSH ]@UH HHM@K  H ]@UH HHMhH ]@UH HH   ۣH ]@UH HH   H  4HH ]@UH HH   H  TRH ]@UH HH   H  H ]@UH HH   H  QH ]@UH HH   H@  脈H ]@UH HHMPH ]@UH HH   Hp  hH ]@UH HHMX>H ]@UH HH   H  ThH ]@UH HHM`H ]@UH HH   H  PH ]@UH HHMHH ]@UH HEPt
ePHMHPH ]@UH HHM@nH ]@UH HH   bH  H ]@UH HHMhH  H ]HT$UH0Hꋍ    L   IA;|'H HD$ L
b H3 H
$ 证H H0]@UH HH  jH  H ]@UH HH   蛠H ]HT$SUHHHH#  HM@H  H  HHU@HHM@H  HMhHPHHM@G  HHU@HHM@G  H HH][@UH HHM@G  H ]@UH HHM@G  H ]@UH HHMHH ]@UH HH   KH ]@UH HHP  +H ]@UH HH  H ]@UH HH  H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   {H ]@UH HH   [H ]@UH HH   ;H ]@UH HHMpH ]@UH HHMpH ]@UH HHM@H ]@UH HH   E  H ]HT$UH@HLe LD$ L
 H H
 }H@]@UH HH   {H ]@UH HH(  [H ]@UH HHMXD  H ]@UH HH   D  H ]HT$UH@HH   WHW H@]@UH HHMXH ]@UH HH   H ]@UH HHMXH ]@UH HH   kH ]@UH HHMXNH ]HT$UH@Hs EPH H@]@UH HH  B  H ]@UH HHMXC  H ]@UH HH  B  H ]@UH HHMXMC  H ]@UH HHMX~H ]@UH HH  [H ]@UH HHp  ;H ]@UH HH  B  H ]@UH HH  C  H ]@UH HH  ;>H ]@UH HHMpH ]@UH HH   JB  H ]@UH HH   *B  H ]@UH HH   [H ]@UH HH   ;H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH  @  H ]@UH HHM@^H ]@UH HHM@~_H ]@UH HH   
A  H ]@UH HH   @  H ]@UH HH   @  H ]@UH HH   @  H ]@UH HH   @  H ]@UH HHM@H蚿H ]@UH HHM@HzH ]@UH HHM@H(ZH ]@UH HHM@H8:H ]@UH HHM@HHH ]@UH HHM@HXH ]@UH HHM@H   ?  H ]HT$UH HH   Ht33H ]@UH HHM0^H ]@UH HH   :?  H ]@UH HHMxm@  H ]@UH HH   >  H ]@UH HHMx-@  H ]@UH HH   H ]@UH HH   EH ]@UH HH  H ]@UH HH  {EH ]@UH HH  KH ]@UH HH  ;EH ]@UH HH  H ]@UH HH  DH ]@UH HH  H ]@UH HH  DH ]@UH HH   z=  H ]@UH HH   Z=  H ]@UH HH  ۲H ]@UH HHP  b<  H ]@UH HH   <  H ]@UH HH  <H ]@UH HH  ;AH ]@UH HH  <  H ]@UH HH0  ;H ]@UH HH0  @H ]@UH HH  @H ]@UH HH  <  H ]@UH HH  +;H ]@UH HH  [@H ]@UH HHh  ;  H ]@UH HH   ;  H ]@UH HH  z;  H ]@UH HHMP];  H ]@UH HH   {H ]@UH HHh  ;  H ]@UH HH   :  H ]@UH HH   :  H ]@UH HH   :  H ]@UH HH   :  H ]@UH HHMP}:  H ]@UH HH   蛹H ]@UH HHH  KH ]@UH HHH  kXH ]@UH HH8  H ]@UH HH8  wH ]@UH HHx  H ]@UH HHx  @H ]@UH HHx  H ]@UH HH  8H ]@UH HH  k8H ]@UH HH0  K8H ]@UH HH  +8H ]@UH HH  8H ]@UH HHMP7H ]@UH HH  H ]@UH HH  H ]@UH HH  kH ]@UH HH  KH ]@UH HH   +H ]HT$SUH(HH[  HM07  H   HHU0HHM07  HM(HPHHM07  HHU0HHM07  H$ H(][@UH HHM0}7  H ]@UH HHM0]7  H ]HT$SUH(HH  HM07  H   HHU0HHM07  HM(HPHHM06  HHU0HHM06  H% H(][@UH HHM06  H ]@UH HHM06  H ]@UH HHM(~H ]HT$SUH(HH{  HM016  H   HHU0HHM026  HM(HPHHM05  HHU0HHM06  H( H(][@UH HHM05  H ]@UH HHM05  H ]HT$SUH(HH  HM0q5  H   HHU0HHM0r5  HM(HPHHM0;5  HHU0HHM0C5  H) H(][@UH HHM05  H ]@UH HHM04  H ]HT$SUH(HHK  HM04  H   HHU0HHM04  HM(HPHHM0{4  HHU0HHM04  H* H(][@UH HHM0]4  H ]@UH HHM0=4  H ]HT$SUH(HH  HM03  H   HHU0HHM03  HM(HPHHM03  HHU0HHM03  H+ H(][@UH HHM03  H ]@UH HHM0}3  H ]@UH HH   Z3  H ]@UH HH   苶H ]@UH HH   3  H ]@UH HH   B2  H ]@UH HH   2  H ]@UH HHMPH ]@UH HHMPPH ]@UH HH   H ]@UH HH   PH ]@UH HH   1  H ]@UH HH   2  H ]@UH HH   1  H ]@UH HEpt
epHMxH ]@UH HHM@
H ]@UH HH  -H ]@UH HH   -H ]@UH HHh  ,H ]@UH HH   1H ]@UH HHMX^
H ]@UH HH   H ]@UH HHMH*H ]@UH HHM(ޯH ]@UH HHMh辯H ]@UH HHMh螯H ]@UH HHMx~H ]@UH HHMx^H ]@UH HH   ;H ]@UH HH   H ]@UH HH   H ]@UH HH   ۮH ]@UH HHM0辮H ]@UH HHM0螮H ]@UH HHM@~H ]@UH HH   r.  H ]@UH HH   
/  H ]HT$UH0HM`M`  ;|4  H HD$ L
s L  H= H
V gHd H0]@UH HHM(H ]@UH HHMx莭H ]@UH HHM@nH ]@UH HH   b-  H ]@UH HHMh-  H ]HT$UH0Hꋍ    L   IA;|'H HD$ L
b H3 H
T fHi H0]@UH HHM@螬H ]@UH HH   'H ]@UH HHMX&H ]@UH HHMX^H ]@UH HH   ;H ]@UH HHM H ]@UH HH   [-H ]@UH HH   ,  H ]HT$UH@HLL LD$ L
 H H
 }{H@]@UH HH   {H ]@UH HH@  [H ]@UH HHMX+  H ]@UH HH  +  H ]HT$UH@HH   WHWu H@]@UH HHMXήH ]@UH HH  諮H ]@UH HHMX莮H ]@UH HH  kH ]@UH HHMXNH ]HT$UH@Hs EPHv H@]@UH HH  )  H ]@UH HHMX*  H ]@UH HH  )  H ]@UH HHMXM*  H ]@UH HHMX~H ]@UH HH   [H ]@UH HHP  ;H ]@UH HHp  )  H ]@UH HH  *  H ]@UH HH  ;%H ]@UH HHMpH ]@UH HH   J)  H ]@UH HH   *)  H ]@UH HHM@^H ]@UH HH   ;H ]@UH HHM@H ]@UH HH   H ]@UH HHM@ޫH ]@UH HH0  '  H ]@UH HHM@^H ]@UH HHM@~FH ]@UH HH   
(  H ]@UH HH   '  H ]@UH HH   '  H ]@UH HH   '  H ]@UH HH   '  H ]@UH HHMh螦H ]@UH HHMx~H ]@UH HH   *'  H ]@UH HH   [H ]@UH HH   &  H ]@UH HH0  &  H ]@UH HH   &  H ]@UH HHMP螵H ]@UH HHMPDH ]@UH HH   [H ]@UH HH   {DH ]@UH HH0  R%  H ]@UH HH   %  H ]@UH HH   %  H ]@UH HH0  $  H ]@UH HHM@%  H ]@UH HHM@m%  H ]@UH HHM@M%  H ]@UH HHM@-%  H ]@UH HHM@
%  H ]@UH HHM@$  H ]@UH HH0  $  H ]@UH HHM@$  H ]@UH HjpH   UH ]@UH HHM@螣H ]@UH HHM@~H ]@UH HHM0^H ]@UH HHM(>H ]@UH HHMPH ]@UH HHM`H ]@UH HHM`ޢH ]@UH HHM`H躢H ]@UH HHM`H(蚢H ]@UH HHM8^H ]@UH HHM8~AH ]@UH HHMxH ]@UH HHMx>AH ]@UH HH   H ]@UH HH   ۡH ]@UH HHMh辡H ]@UH HH   {H ]@UH HH   @H ]HT$UH0H    H H0]@UH HH 	  B!  H ]@UH HH  !  H ]@UH HHp   H ]@UH HHp  &H ]@UH HH0  z!  H ]@UH HHP   H ]@UH HHP  %H ]@UH HH   +H ]@UH HH   K?H ]@UH HHM`H ]@UH HHM`H ]@UH HH   諯H ]@UH HH   >H ]@UH HH`  kH ]@UH HH`  >H ]@UH HH  +H ]@UH HH  K>H ]@UH HH    H ]@UH HH    H ]@UH HH
  wH ]@UH HH
  wH ]@UH HH
  {wH ]@UH HH  HWwH ]@UH HH
  +H ]@UH HH
  H ]@UH HH  H ]@UH HH    H ]@UH HHMp  H ]@UH HH0  z  H ]@UH HH  H ]@UH HH  "H ]@UH HHMp  H ]@UH HH  J  H ]@UH HH  H ]@UH HH  HuH ]@UH HH
  諬H ]@UH HH
  苬H ]@UH HH   kH ]@UH HH   ;H ]@UH HH    H ]@UH HH  +H ]@UH HH  [!H ]@UH HHMp  H ]@UH HH  H ]@UH HHP  H ]@UH HHp  H ]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH  H ]@UH HH  ; H ]@UH HH  ˚H ]@UH HH  諚H ]@UH HH  Z  H ]@UH HH  kH ]@UH HH  H ]@UH HH0    H ]@UH HH  H ]@UH HH  ;H ]@UH HH  H ]@UH HHMp莩H ]@UH HHMp~!H ]@UH HH  :  H ]@UH HH    H ]@UH HHMpH ]@UH HHMp H ]@UH HH    H ]@UH HH0    H ]@UH HH  H ]@UH HH  H ]@UH HH  kH ]@UH HH  KH ]@UH HHP  +H ]@UH HHp  H ]@UH HH  H ]@UH HH0    H ]@UH HHMp}  H ]@UH HH  H ]@UH HH  HP  2H ]@UH HH  ;H ]@UH HHMp  H ]@UH HH  H ]@UH HH  +H ]@UH HH  H ]@UH HH  H ]@UH HHMpM  H ]@UH HH0  *  H ]@UH HH  kH ]@UH HH  H0  1H ]@UH HH  (H ]@UH HHMp  H ]@UH HH  H ]@UH HH  H ]@UH HH  kH ]@UH HH  ;H ]@UH HHMp  H ]@UH HH0    H ]@UH HH  4H ]@UH HHMp  H ]@UH HHMp}  H ]@UH HH  H ]@UH HHP  kH ]@UH HHp  KH ]@UH HHMp  H ]@UH HH  *  H ]@UH HHH  H ]@UH HH
  H ]@UH HH  H ]@UH HHP  H ]@UH HHp  kH ]@UH HH  +aH ]@UH HH  [aH ]@UH HH  aH ]@UH HH  aH ]@UH HH  bH ]@UH HH  KbH ]@UH HH  nH ]@UH HH  oH ]@UH HH  pH ]@UH HH  [tH ]@UH HH  tH ]@UH HH  yH ]@UH HHMp  H ]@UH HH    H ]@UH HH  H ]@UH HHP  kH ]@UH HHp  KH ]@UH HH
p H ]@UH HH
 H ]@UH HH
ȋ ˠH ]@UH HH
 諠H ]@UH HH
 苠H ]@UH HH
 kH ]@UH H   H ]@UH HHHM(HM$H ]@UH Hh H ]@UH HHM8HM(HE(HHM0HE08csmtE     E ^H ]@UH H}  uLMxDEpHUhHM`8H ]@UH HH3Ɂ8  H ]H(H1  H
&r   H
  H(H(H1  H
Nq   H
  H(TH(H1  H
~r   H
  H($H(" q H( ^q @q H(D" =wq H(H(M q H(HY   5r H9   fW! q H
   =q ! 
     tYtY
9q H($! mYX ?p H(H(  Oo H(o Yp p ! ^o p p fW  o H(\ 
 ^
p H(H(D  p H(H(o mp H(H(fWQp H(H(4  -o H(H( 
o H(Po fW Po H(l fW n H(o fW hn H(4 xfWR n H(n Y` n ho Xn Ho 8o fW hn H(H-  H
m   H
  H(dH(H-  H
^m   H
  H(4H(H-  H
n   H
  H(H8HD$    	3HtH
 HHH܅ H H H H
  H8H8HD$    3HtH
Å HHH HŅ Hƅ Hǅ H
P  H8CH8HD$    I3HtH
Ä HHH Hń HƄ HǄ H
  H8H(H
    {H
t  H(H8HD$    3HtH
 HHH H H H H
  H8SH8HD$    Y3HtH
 HHH H
 H H H
0  H8H8HD$    3HtH
 HHH H H H H
  H8H(H
 0H
y  H(lH(H
 蠕H
	  H(LH8* LD$@3)t$ (5 fTf/ vo	   "   R LD$@3}(fTf/ vA	   "   (t$ H8HL$֭HL$HL$H
ق 4jH
 DKHL$v8 3(  b S HT$} HT$^ HT$ HT$^H
1i H%B  H
yh H%2  H
i H%"  H
h H%  H
yh H%  H
i H%  @SH Hˀ Ht*H|$0CuHHPCu	HHPH|$0H [@SH H Ht*H|$0CuHHPCu	HHPH|$0H [@SH H{w Ht*H|$0CuHHPCu	HHPH|$0H [@SH Hw Ht*H|$0CuHHPCu	HHPH|$0H [H(H
m HtH
D 3HS HT HU H(H(H
 HtH
 3H H H H(H(H
% HtwH
 3H H H
 H(PH
} H(H
~ Ht'H
~ 3H~ H~ H~ H( H(H
U HtH
, 3H; H< H= H(H(H
~ HtH
~ 3H~ H~ H~ H(                                                                                                                                                                                                                                                                                                                                                                    JM     4M     M     M     L     L     L             H     \H      H     G     G     NG     F     F     bF     6F     E     E     8E     D     D     `D     D     C     C     C     vC     .C     B     B     XB     
B     A     A     >A     @     @     n@     2@     *@     ?     L?     
?     >     >     D>     =     =      =     <     <     D<     <     ;     ;     `;     ;     :     :     l:     >:     9     n9     9     9     8     8     B8     7     L7     6     z6     5     5     5     h5     4     j4     3     3     43     2     d2     2     1     f1     1     0             L     bL     PL     BL     2L     $L     L     
L     K     K     K     K     K     K     K     K     lK     dK     ZK     PK     FK     $K     K     K     J     J     J     J     J     J     pJ     PJ     4J     (J     J     I     I     I     I     I     `I     <I     2I     ,I     $I     I     I     I     
I     I     H     H     H     H     vL             ",     ,     +     +     +     +     +     +     p+     `+     H+     8+     $+     +     +     *     *     *     *     *     *     *     p*     X*     J*     :*      *     *     )     )     )     )     )     )     |)     j)     V)     B)     2)     )     )     (     (     (     (     (     r(     Z(     H(     4(     $(     (     (     '     '     '     '     '     '     v'     `'     N'     >'     0'     "'     '     &     &     &     &     &     &     &     r&     b&     N&     8&      &     &     %     %     %     0     0     0     j0     V0     B0     &0     0      0     /     /     /     /     /     ~/     n/     Z/     H/     8/      /     /     .     .     .     .     .     .     .     v.     b.     F.     *.     .     -     -     -     -     -     -     x-     d-     L-     8-      -     -     ,     ,     ,     ,     ,     ,     t,     ^,     H,     (     2,     %     %     %     v%     d%     N%     8%     (%                     p      Ђ           @   `                  @   `                  0   P   p                0   P   p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @                                                                                                                                                                                                                                                                   p                                                                                                                                                                                                                                                                   Ј                                                                                                                                                                                                                                                                   0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         Љ                                                                                                                                                                                                                                                                   P                                                                                                                                                                                                                                                                   `                                                                                                                                                                                                                                                                   p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Њ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            0                                                                                                                                                                                                                                                                   P                                                                                                                                                                                                                                                                                   4q
                   bad allocation  numpy.core.multiarray   numpy.core.multiarray failed to import  _ARRAY_API  2   _ARRAY_API not found    _ARRAY_API is not PyCObject object  14  _ARRAY_API is NULL pointer  0   module compiled against ABI version %x but this version of numpy is %x  numpy.core.umath    2   module compiled against API version %x but this version of numpy is %x  FATAL: module compiled as unknown endian    14  numpy.core.umath failed to import   0   FATAL: module compiled as little endian, but detected different endianness at runtime   _UFUNC_API      _UFUNC_API not found    _UFUNC_API is not PyCObject object      _UFUNC_API is NULL pointer      SSE, SSE2       empty_nested() must be true before calling recover_memory() .           empty_nested() must be false before calling recover_memory_nested()  /  :0yE>empty_nested() must be false before calling set_zero_all_adjoints_nested()      No free parameters for unit metric              Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        model =         stan_version_major =    stan_version_minor =    stan_version_patch =    Iteration:  %]   [       (Warmup)        (Sampling)  /  stan::services::variational::print_progress %]  Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   [   (Adaptation)    (Variational Inference)    #   stan_version_major      stan_version_minor      stan_version_patch      )       (   --  >   =<  :       Exception thrown at line        bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type           c:\users\appveyor\appdata\local\temp\1\tmpmt_mik\stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.cpp              stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.pyx       __init__.pxd    stringsource    type.pxd        Unknown exception   F   T   n   lp__    np  HMC PY2 eta get ret __str__ sum zip BFGS    NUTS    args    ctrl    data    flat    init    iter    __main__    misc    name    pars    plot    seed    send        __test__    thin    upar    user    warn    LBFGS   OPTIM   array   ascii   close   error   flush   index   numpy   optim   order   plots   probs   range   shape   split   throw   utf-8   value   DIAG_E  Newton  UNIT_E  append  chains  data_i  data_r  decode  diag_e  dstack  encode  fitptr  format  holder      __import__  logger  method  metric  n_save  pystan  unit_e  update  vars_i  vars_r  warmup      DENSE_E argsptr asarray control dense_e dims_oi epsilon extract genexpr handler logging mean_lp__       newaxis pars_oi refresh reshape samples squeeze _summary        tol_obj warmup2 SAMPLING        adapt_t0        chain_id        (diag_e)        __getstate__    gradient        handlers        int_time        permuted        sampling        stepsize        tol_grad        (unit_e)        warnings        algorithm       data_args       (dense_e)       eval_elbo       flatnames       fnames_oi       getLogger       holderptr       init_list       iter_save       mean_pars       row_stack       sampler_t       test_grad       tol_param       traceplot       Metropolis      ValueError      adapt_iter      _check_pars get inc_warmup      init_alpha      model_code      _split_data get ImportError b   MemoryError B   OrderedDict h   VARIATIONAL H   adapt_delta i   adapt_gamma I   adapt_kappa l   collections L   _get_samples    init_radius q   pystan.misc Q   random_seed f   sample_file d   save_warmup g   tol_rel_obj Zf  variational Zd  RuntimeError    adapt_window    _call_sampler   column_stack    elbo_samples    grad_samples    history_size    optim_algo_t    pystan.plots    string_types    tol_rel_grad    TEST_GRADIENT   adapt_engaged   max_treedepth   pars_oi_bytes   _print_stanfit  AttributeError  append_samples  output_samples  pystan._compat  sampler_params  adaptation_info diagnostic_file sampling_algo_t save_iterations stepsize_jitter adjust_transform        _get_kept_samples       pystan.constants        sample_file_flag        tol_history_size        adapt_init_buffer       adapt_term_buffer       _call_sampler_star      _remove_empty_pars      sampling_metric_t       cline_in_traceback      enable_random_init      _pars_total_indexes Zg  stan_args_method_t      variational_algo_t      _verify_has_samples O   iter_save_wo_warmup par sampler_param_names sim diagnostic_file_flag    __getstate__.<locals>.genexpr   Variable name must be bytes.    ndarray is not C contiguous s   Stan model {} is of mode 'test_grad';
sampling is not conducted.        `inc_warmup` ignored when `permuted` is True.   numpy.core.multiarray failed to import  unknown dtype code in numpy.pxd (%d)    Couldn't allocate space for StanHolder. Couldn't allocate space for stan_fit.   Format string allocated too short, see comment in numpy.pxd s   Non-native byte order not supported %s  Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. int Stan model {} does not contain samples. c:\users\appveyor\appdata\local\temp\1\tmpmt_mik\stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.pyx              data sim model_name model_pars par_dims mode inits stan_args stanmodel date =   ndarray is not Fortran contiguous               num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names numpy.core.umath failed to import       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355   Couldn't allocate space for StanArgs.   Format string allocated too short.      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.__getitem__          stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.__getstate__.genexpr attr_names  self        genexpr stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.__getstate__ list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.__setstate__ list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.__reduce__           stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.num_failed.__get__   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.num_failed.__set__   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.test_grad.__get__    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.test_grad.__set__    Expected %.16s, got %.200s      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.inits.__set__        Expected %.16s, got %.200s      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.par.__set__          stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.value.__get__        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.value.__set__    dict        Expected %.16s, got %.200s              stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.args.__set__ list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.mean_lp__.__get__    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.mean_lp__.__set__    Expected %.16s, got %.200s      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder.sampler_param_names.__set__  list    Expected %.16s, got %.200s  list        Expected %.16s, got %.200s              stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._pystanholder_from_stanholder #   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._dict_from_stanargs       'NoneType' object has no attribute '%.30s'      'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable          stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._set_stanargs_from_dict           stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._dict_to_vars_r   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._dict_to_vars_i   _call_sampler_star              stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._call_sampler_star        _call_sampler   _call_sampler   _call_sampler   _call_sampler           stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._call_sampler dict        Expected %.16s, got %.200s              stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355._call_sampler 0   __cinit__       tuple index out of range        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__cinit__   __init__        __init__                stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__init__            stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__getstate__.genexpr        attr_names  self        genexpr plot    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__getstate__        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__setstate__        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__reduce__  plot    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.plot        'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.plot        traceplot       traceplot               stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.traceplot           stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.traceplot   extract extract 'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.extract 0   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.extract args        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__unicode__ summary stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__str__ dict        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__repr__            stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.__getitem__ summary stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.summary tuple       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.summary #   log_prob        log_prob                stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.log_prob            stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.log_prob    grad_log_prob   grad_log_prob           stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.grad_log_prob       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.grad_log_prob       'NoneType' object is not subscriptable          stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_adaptation_info get_logposterior        get_logposterior        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_logposterior    'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_logposterior    get_sampler_params      get_sampler_params      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_sampler_params  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_sampler_params  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_posterior_mean  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.unconstrain_pars    list index out of range 'NoneType' object is not iterable       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_seed            stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.get_stancode        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.flatnames.__get__   'NoneType' object has no attribute '%.30s'      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._verify_has_samples stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._update_param_oi    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._get_param_names    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._get_param_fnames_oi                stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._get_param_names_oi stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._get_param_dims #   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._get_param_dims_oi  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.constrained_param_names inits       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.unconstrained_param_names           stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model._call_sampler       Expected %.16s, got %.200s      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model.sim.__set__ numpy.ndarray.__getbuffer__ #   numpy.PyArray_MultiIterNew1 ,   numpy.PyArray_MultiIterNew2 ,   numpy.PyArray_MultiIterNew3 ,   numpy.PyArray_MultiIterNew4 ,   numpy.PyArray_MultiIterNew5 ,   'NoneType' object is not subscriptable  Expected %.16s, got %.200s      numpy._util_dtypestring numpy.import_array      numpy.import_array      numpy.import_umath      numpy.import_umath      numpy.import_ufunc      numpy.import_ufunc      vector.to_py.__pyx_convert_vector_to_py_double          string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string        string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string          string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string              vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___       string.from_py.__pyx_convert_string_from_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.from_py.__pyx_convert_vector_from_py_size_t      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ value       vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__      num_failed      test_grad   chains  args        mean_pars       mean_lp__       adaptation_info sampler_params  sampler_param_names plot        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.PyStanHolder      Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__      traceplot       extract __unicode__ .   summary log_prob        grad_log_prob   get_adaptation_info .   get_logposterior        get_sampler_params      get_posterior_mean      unconstrain_pars        get_seed        get_inits       get_stancode    get_stanmodel   _verify_has_samples ,   _update_param_oi        _get_param_names        _get_param_fnames_oi    _get_param_names_oi ,   _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames   data        model_name      model_pars      par_dims    mode    inits       stan_args       stanmodel   date        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.StanFit4Model 1.0 Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.__pyx_scope_struct____getstate__  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.__pyx_scope_struct_1_genexpr      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.__pyx_scope_struct_2___getstate__ stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.__pyx_scope_struct_3_genexpr      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355   __builtin__ 1.0 cython_runtime  __builtins__    __name__        PyStanHolder    StanFit4Model   type    __builtin__ dtype   numpy       flatiter    numpy       broadcast   numpy       ndarray numpy   ufunc   numpy           init stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355              init stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355      name '%.200s' is not defined            free variable '%s' referenced before assignment in enclosing scope       while calling a Python object   while calling a Python object  NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        need more than %zd value%.1s to unpack  at least        at most exactly %.200s() takes %.8s %zd positional argument%.1s (%zd given) 1.0 %s() got multiple values for keyword argument '%s'      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    '%.200s' object is unsliceable  Missing type object throw       Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      'NoneType' object is not iterable       Missing type object 1.0 Cannot convert %.200s to %.200s cannot import name %.230s       %s (%s:%d)      value too large to convert to int       can't convert negative value to int 1.0 value too large to convert to unsigned int      can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t        can't convert negative value to pystan::stan_args_method_t      value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t       value too large to convert to pystan::optim_algo_t      can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t        can't convert negative value to pystan::variational_algo_t      value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long      can't convert negative value to long    _cython_0_27_3  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing [   can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object ,   _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections.abc collections ]   Cython module failed to register with collections.abc module    Cython module failed to register with collections module        backports_abc   send    send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.   throw               throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    close       close() -> raise GeneratorExit inside generator.        gi_running      gi_yieldfrom    object being iterated by 'yield from', or None  __name__        name of the generator   __qualname__    qualified name of the generator generator   %d.%d       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355   compiletime version %s of module '%.100s' does not match runtime version %s #   %.200s.%.200s is not a type object              %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __%.4s__ returned non-%.4s (type %.200s)    long        an integer is required  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Argument n out of range: got %1%        boost::math::prime<%1%> is not converging       grad_reg_inc_gamma      is not converging       grad_reg_inc_gamma  lp__    user    user        TEST GRADIENT MODE              Sample generated by Stan (Automatic Differentiation Variational Inference)      Sample generated by Stan (Automatic Differentiation Variational Inference)      This is Automatic Differentiation Variational Inference.         procedure.)    (EXPERIMENTAL ALGORITHM: expect frequent updates to the  seconds        Gradient evaluation took         seconds.       1000 iterations under these settings should take        Adjust your expectations accordingly!   lp__    lp__    STAN OPTIMIZATION COMMAND (LBFGS)       init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  #   tol_param =     tol_rel_obj =   tol_rel_grad =  history_size =  seed =  Point Estimate Generated by Stan (LBFGS)        stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj =   tol_rel_grad    history_size    seed    lp__    STAN OPTIMIZATION COMMAND (BFGS)        init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  #   tol_param =     tol_rel_obj =   tol_rel_grad =  seed =  Point Estimate Generated by Stan (BFGS) stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj =   tol_rel_grad    seed    lp__    STAN OPTIMIZATION COMMAND (Newton)      Point Estimate Generated by Stan (Newton)       stan_version_major      stan_version_minor      stan_version_patch  init    seed    lp__        initial log joint probability =         Iteration       Log joint probability =         . Improved by   Sample generated by Stan        Sample generated by Stan        Must use algorithm="Fixed_param" for model that has no parameters.              Warning: warmup will be skipped for the fixed parameter sampler!        No sampler matching HMC specification!  boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.        boost::math::cbrt<%1%>(%1%) #   0.003379167095512573896158903121545171688       -0.000322780120964605683831 =   -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228          C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)    Log probability=   error       finite diff model   value       param idx   #   =   #   =   #   =   #   =   #   =   #   =   #   =   #   initial log joint probability =             Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   initial log joint probability =             Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   #   #   #   #   )        (Chain     .    is written to file     Sample of chain         Exception initializing step size.       Exception initializing step size.       0.003379167095512573896158903121545171688       -0.000322780120964605683831 1.0 -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  1.0 1.0 0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  1.0 1.0 -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%) 1.0 -0.0020713321167745952  Argument a to the incomplete gamma function must be greater than zero (got a=%1%).              Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   0.9016312093258695918615325266959189453125e-19  -0.045251321448739056   -0.28919126444774784    -0.65031853770896507    -0.32555031186804491    0.25479851061131551 ,   -0.55789841321675513e-6 0.0021284987017821144   0.054151797245674225    0.43593529692665969 %1% 1.4606242909763515      2.0767117023730469      ibeta_derivative<%1%>(%1%,%1%,%1%)              The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).           Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)          Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable  attempts.  :   ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization from source failed.      Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% -0.324588649825948492091e-4 %1% -0.541009869215204396339e-3 :   -0.259453563205438108893e-3 %1% 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 :   -0.223352763208617092964e-6 %1% 0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 :   -0.240149820648571559892e-1 %1% -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 ,   0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 nan 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 NAN -0.827193521891290553639e-6 %1% -0.100666795539143372762e-2 :   0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. %1% Result of tgamma is too small to represent. %1% Result of tgamma is denormalized.       Result of tgamma is too large to represent. :   Result of tgamma is too large to represent. %1% Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)          The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)          Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                The argument a to the incomplete beta function must be >= zero (got a=%1%). 1.0 The argument b to the incomplete beta function must be >= zero (got b=%1%). 1.0 The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.          The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. 1.0 Result of tgamma is too small to represent. 1.0 Result of tgamma is denormalized.       Result of tgamma is too large to represent. )   Result of tgamma is too large to represent. %1% Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Rejecting initial value:          Error evaluating the log probability at the initial value.    Rejecting initial value:          Log probability evaluates to log(0), i.e. negative infinity.    Stan can't start sampling from this initial value.    Rejecting initial value:          Gradient evaluated at the initial value is not finite.          Stan can't start sampling from this initial value.     attempts.  :   ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization partially from source failed.    normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.324588649825948492091e-4 0.0 -0.541009869215204396339e-3 1.0 -0.259453563205438108893e-3 1.0 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 1.0 -0.223352763208617092964e-6 1.0 0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 0.0 -0.240149820648571559892e-1 1.0 -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 1.0 0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 0.0 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 1.0 -0.827193521891290553639e-6 0.0 -0.100666795539143372762e-2 1.0 0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   -5.2487866627945699800e-18      -1.5982226675653184646e-14      -2.6843448573468483278e-11      -3.0517226450451067446e-08      -2.5172644670688975051e-05      -1.5453977791786851041e-02      -7.0935347449210549190e+00      -2.4125195876041896775e+03      -5.9545626019847898221e+05      -1.0313066708737980747e+08      -1.1912746104985237192e+10      -8.4925101247114157499e+11      -3.2940087627407749166e+13      -5.5050369673018427753e+14      -2.2335582639474375249e+15      -4.8527560179962773045e+03      1.0377081058062166144e+07       -1.2207067397808979846e+10      7.8858692566751002988e+12       -2.2335582639474375245e+15      -9.6090021968656180000e+00      3.1611322818701131207e+01       -2.3517945679239481621e+01      5.5674518371240761397e+00       -4.4700805721174453923e-01      1.3067392038106924055e-02       -2.2210262233306573296e-04      -3.1446690275135491500e+01      8.5539563258012929600e+01       -6.0228002066743340583e+01      1.3982595353892851542e+01       -1.1151759188741312645e+00      3.2547697594819615062e-02       -5.5194330231005480228e-04      -1.9705291802535139930e-19      -6.5245515583151902910e-16      -1.1928788903603238754e-12      -1.4831904935994647675e-09      -1.3466829827635152875e-06      -9.1746443287817501309e-04      -4.7207090827310162436e-01      -1.8225946631657315931e+02      -5.1894091982308017540e+04      -1.0588550724769347106e+07      -1.4828267606612366099e+09      -1.3357437682275493024e+11      -6.9876779648010090070e+12      -1.7732037840791591320e+14      -1.4577180278143463643e+15      -5.1326864679904189920e+03      1.1594225856856884006e+07       -1.4386907088588283434e+10      9.7887501377547640438e+12       -2.9154360556286927285e+15      -6.0437159056137599999e-02      8.5591872901933459000e-01       -1.9746376087200685843e+00      1.3960118277609544334e+00       -3.4198728018058047439e-01      2.9204895411257790122e-02       -8.9359825138577646443e-04      1.4582087408985668208e-05       -3.8806586721556593450e+00      3.2593714889036996297e+00       -8.5017476463217924408e-01      7.4212010813186530069e-02       -2.2835624489492512649e-03      3.7510433111922824643e-05       boost::math::bessel_ik<%1%>(%1%,%1%)            Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.   initialized to invalid value ( Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::expm1<%1%>(%1%)    -1.2117036164593528341e-01      1.0344222815443188943e+02       -3.6629814655107086448e+04      6.6302997904833794242e+06       -6.2140700423540120665e+08      2.7282507878605942706e+10       -4.1298668500990866786e+11      9.3614022392337710626e+02       4.5612696224219938200e+05       1.3985097372263433271e+08       2.6328198300859648632e+10       2.3883787996332290397e+12       4.8591703355916499363e+01       7.4321196680624245801e+02       4.4176707025325087628e+03       1.1725046279757103576e+04       1.0341910641583726701e+04       -7.2879702464464618998e+03      -1.2254078161378989535e+04      -1.8319397969392084011e+03      -2.5258076240801555057e+01      3.3307310774649071172e+02       -2.9458766545509337327e+03      1.8680990008359188352e+04       -8.4055062591169562211e+04      2.4599102262586308984e+05       -3.5783478026152301072e+05      8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04       1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01      9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03 1.0 1.4130e+03      5.46860286310649596604e-04      -1.0767857011487300348e-02      1.0650724020080236441e+01       -4.4615792982775076130e+03      9.8062904098958257677e+05       -1.1548696764841276794e+08      6.6781041261492395835e+09       -1.4258509801366645672e+11      1.0742272239517380498e+03       5.9117614494174794095e+05       2.0228375140097033958e+08       4.2091902282580133541e+10       4.1868604460820175290e+12       4.6179191852758252278e+00       -7.5023342220781607561e+03      5.0793266148011179143e+06       -1.8113931269860667829e+09      3.5580665670910619166e+11       -3.6658018905416665164e+13      1.6608531731299018674e+15       -1.7527881995806511112e+16      1.3886978985861357615e+03       1.1267125065029138050e+06       6.4872502899596389593e+08       2.7622777286244082666e+11       8.4899346165481429307e+13       1.7128800897135812012e+16       1.7253905888447681194e+18       -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06      -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06      3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04       8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) -1.8402381979244993524e+01      1.0102532948020907590e+04       -2.1287548474401797963e+06      2.0422274357376619816e+08       -8.3716255451260504098e+09      1.0723538782003176831e+11       6.6475986689240190091e+02       2.3889393209447253406e+05       5.5662956624278251596e+07       8.1617187777290363573e+09       5.8873865738997033405e+11       1.7427031242901594547e+01       -1.4566865832663635920e+04      4.6905288611678631510e+06       -6.9590439394619619534e+08      4.3600098638603061642e+10       -5.5107435206722644429e+11      -2.2213976967566192242e+13  1.0 8.3030857612070288823e+02       4.0669982352539552018e+05       1.3960202770986831075e+08       3.4015103849971240096e+10       5.4266824419412347550e+12       4.3386146580707264428e+14       -1.7439661319197499338e+01      2.1363534169313901632e+04       -1.0085539923498211426e+07      2.1958827170518100757e+09       -1.9363051266772083678e+11      -1.2829912364088687306e+11      6.7016641869173237784e+14       -8.0728726905150210443e+15  1.0 8.7903362168128450017e+02       5.3924739209768057030e+05       2.4727219475672302327e+08       8.6926121104209825246e+10       2.2598377924042897629e+13       3.9272425569640309819e+15       3.4563724628846457519e+17       8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04   1.0 1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01  1.0 9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       boost::math::bessel_y0<%1%>(%1%,%1%)    Got x = %1% but x must be non-negative, complex result not supported.   -3.1714424660046133456e+02      2.2157953222280260820e+05       -5.9157479997408395984e+07      7.2144548214502560419e+09       -3.7595974497819597599e+11      5.4708611716525426053e+12       4.0535726612579544093e+13   1.0 8.2079908168393867438e+02       3.8136470753052572164e+05       1.2250435122182963220e+08       2.7800352738690585613e+10       4.1272286200406461981e+12       3.0737873921079286084e+14       -1.2337180442012953128e+03      1.9153806858264202986e+06       -1.1957961912070617006e+09      3.7453673962438488783e+11       -5.9530713129741981618e+13      4.0686275289804744814e+15       -2.3638408497043134724e+16      -5.6808094574724204577e+18      1.1514276357909013326e+19   1.0 1.2855164849321609336e+03       1.0453748201934079734e+06       6.3550318087088919566e+08       3.0221766852960403645e+11       1.1187010065856971027e+14       3.0837179548112881950e+16       5.6968198822857178911e+18       5.3321844313316185697e+20   0.0 -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06  1.0 -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06  0.0 3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04   1.0 8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%) 1.0 boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  5.8599221412826100000e-04       1.3166052564989571850e-01       1.1999463724910714109e+01       4.6850901201934832188e+02       5.9169059852270512312e+03       2.4708152720399552679e+03       -2.4994418972832303646e+02      2.1312714303849120380e+04       -1.6414452837299064100e+00      -2.9501657892958843865e+02      -1.7984434409411765813e+04      -3.7333769444840079748e+05      -1.6128136304458193998e+06  1.0 -2.5064972445877992730e+02      2.9865713163054025489e+04       -1.6128136304458193998e+06      1.1394980557384778174e+02       3.6832589957340267940e+03       3.1075408980684392399e+04       1.0577068948034021957e+05       1.7398867902565686251e+05       1.5097646353289914539e+05       7.1557062783764037541e+04       1.8321525870183537725e+04       2.3444738764199315021e+03       1.1600249425076035558e+02   1.0 2.0013443064949242491e+02       4.4329628889746408858e+03       3.1474655750295278825e+04       9.7418829762268075784e+04       1.5144644673520157801e+05       1.2689839587977598727e+05       5.8824616785857027752e+04       1.4847228371802360957e+04       1.8821890840982713696e+03       9.2556599177304839811e+01       boost::math::bessel_k0<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported   4.8127070456878442310e-01       9.9991373567429309922e+01       7.1885382604084798576e+03       1.7733324035147015630e+05       7.1938920065420586101e+05       -2.2149374878243304548e+06  1.0 -2.8143915754538725829e+02      3.7264298672067697862e+04       -2.2149374878243304548e+06      -2.2795590826955002390e-01      -5.3103913335180275253e+01      -4.5051623763436087023e+03      -1.4758069205414222471e+05      -1.3531161492785421328e+06  0.0 1.0 1.0 -3.0507151578787595807e+02      4.3117653211351080007e+04       -2.7062322985570842656e+06      6.4257745859173138767e-02       7.5584584631176030810e+00       1.3182609918569941308e+02       8.1094256146537402173e+02       2.3123742209168871550e+03       3.4540675585544584407e+03       2.8590657697910288226e+03       1.3319486433183221990e+03       3.4122953486801312910e+02       4.4137176114230414036e+01       2.2196792496874548962e+00       3.6001069306861518855e+01       3.3031020088765390854e+02       1.2082692316002348638e+03       2.1181000487171943810e+03       1.9448440788918006154e+03       9.6929165726802648634e+02       2.5951223655579051357e+02       3.4552228452758912848e+01       1.7710478032601086579e+00       boost::math::bessel_k1<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)              The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1% Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1%                       "   Ԝ
            
            "   
         	   `
            "   
            ܝ
            "   
            D
            "   
    
    h
 P                                  +eG?+eG?            "~+@"~+@W6}+W6}+      ?      ?      ?      ?    @.?    @.?ʫy>ʫy>K͉ ?K͉ ?_6.>_6.>~,?~,?9d?9d?t	?t	?       @       @"   
            L
            "   
            
            "   Ա
            
            "   
            
            "   ,
            X
            "   p
            
            "   ض
            
          "   
            @
 @          "   
            
           "   p
            
            "   ̾
             
            "   <
            l
            "   
            ȿ
            "   
            
            "   @
            
            "   
            D
            "   |
            P
 @         "   
            H
            "   
            T
 @         "   
            L
            "   
    
    
            "   D
            
           "   X
            
           "   l
            
           "   
            $
           "   
            8
 P          "   
            
            "   
            
            "    
            D
            "   \
            
            "   
            
            "   
             
            "   
            <
            "   T
            |
            "   
         	   l
           "   
         	   $
           "   l
            @
           "   
            
           "   \
            h
 h         "   (
    t
    
           "   P
    
    X
 @         "
   
             
 P         "   
            D
           "   
            
          "   
         &   
 (         "
   
    P
    
 P         "   
            <
           "   
            @
           "   
            
           "   (
    @
 (   
          `O
   Ѝ   p
   0P
   0   p
   P
         0Q
         Q
         @R
         R
                 "   (            Л
            PS
   @      S
   @      XT
   @      T
   @              "   (            
                    "   (            (
                    hU
      .p
   .p
   .p
   .p
   .p
   .p
   .p
   .p
   U
   .p
   .p
      XV
   0   .p
      .p
   .p
   V
                 bad lexical cast: source type value could not be interpreted as target  bad cast                W
   .p
   .p
   .p
   .p
   .p
   .p
   .p
   .p
   .p
       (X
   0F   n   -q=X
   @      double  long double             "   (            
              E@'
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        "   (            H
                    xY
      .p
   n   n   n   n   n   @Z
      P+   n   n   n   n   n         ?        Z
          l   p      `      @      "   p
            x
                    "   (            
                    "   (            
            ]        [origin:       [
         \
          \
   p      bad exception   (]
   з      bad typeid      ^
          vector<T> too long      invalid vector<T> subscript     "   @(            
                    "       8
    `
 0                  "       
    
 0                  "       
    0
 0                  "       p
    
 0                  "       
     
 0                  "       @
    h
 0                  "       
    
 0                  "       
    8
 0                  "       x
    
 0                  "       
    
 0                  "       H
    p
 0                  "       
    
 0                  "       
    @
 0                  ^
   .p
   .p
   .p
   .p
   .p
   .p
   .p
   .p
            _
   .p
   .p
   .p
   .p
   .p
   .p
   .p
   .p
           x_
   .p
   .p
   .p
   .p
   .p
   .p
   .p
   .p
           but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  "   t
         	   
            Unknown termination code                Line search failed to achieve a sufficient decrease, no more progress can be made       Maximum number of iterations hit, may not be at an optima               Convergence detected: absolute parameter change was below tolerance             Convergence detected: relative gradient magnitude is below tolerance    Convergence detected: gradient norm is below tolerance  Convergence detected: relative change in objective function was below tolerance Convergence detected: absolute change in objective function was below tolerance Successful step completed       -DT!	@Adaptation terminated         ?      @                    @      (@       @      @            P>      <     (@ox?`
   0         `   `   `a
   0         `   `   "   9            
                                             
 
                     	               	               
                                                 ?   =
?   @33?   =
?      ?   ?    ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@"   (            
            kﴑ[?;f?     
   
                 m0_?Q63E?mBP
?        "   (            0
                          ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adxa
   P   `b
              8c
                p      P         `           "   p
            
                  "   
            
                    "   0
    
 
   X
                    "    
    
 
   (
                    "   
            
                :   "                 
 0          (       ) must match in size     (  ) and               "                 
 0                  c
   @   @   P      t   0u    w              8d
   pv   @   P      t       w               d
   	   @   P      t   	    w   
           "   
            ,
                    "   
            t
                    "   
            
            is      , but must be > 0!      , but must be finite!   "   
            
 0          , but must be greater than or equal to  "   
            
 0                  "   
            L
                    "   
            
             seconds (Total)         seconds (Sampling)      seconds (Warm-up)       Elapsed Time:  "
   
            (
 p                  @f
       .o
   4o
   :o
   @o
   Fo
   Lo
   Ro
   Xo
      0   @   ^o
   do
       ?1~ʉʐ|E~Pۆ,̿]g?~vt`2?A<?4`Bkʫ?}
|;¿ȼu??    ?kr	`?[}`?P=x:?/@V;0@{R=a? ZpPT*b!ezFĿp2ڿ2s"\ڿ1i5ϸaƯ?      ?    X?IWUQ{-?f/Ҁ? BN?R?׹^oyd?S?=QAV 1 Lé?]OL?̺?`w"       8
    `
                    "       
    
                    "                 P
 0          [       "       
    
            g
   .p
           "   0
            H
            invalid alignment to 8 bytes, ptr=      uninitialized   "   
            
             and    expecting index to be between    out of range;  index   : accessing element out of range.       ; index position =              "   
            
            ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration           "   P
            
 p                     term_buffer =                   adapt_window =                  init_buffer =                 Defaulting to a 15%/75%/10% partition, ?333333?         overflow the total number of warmup iterations.                WARNING: The initial buffer, adaptation window, and terminal buffer              performed for num_warmup < 20   estimation is  WARNING: No           Y@ =  ,   "   ,
            4
                    "   `
            h
                    "   
            
                    "   (            
                    "   (            
                    "   (             
                    "   L
            T
            g
   0    hh
    !           "       
    
                    "                   0                  "   h            D             i
   '    i
         j
   `g      (   j
    )    j
         , but must not be nan!  , but must be >= 0!     k
   p)      k
   0   I   p
	   I   8l
   0   I   p
	   I   l
   0   I   p
	   I   has dimension =         multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         "   
              0                  "                  0              d?Eĵ@oI+@P	6@"ܢ}/@^ʥ
&@`I2W@DNxR	x3j濍4c08˿ą@?A!y?    dL?      @[sS/k??~}?rJ󓉸?0"S?7¬?O~x>2Lf0?kFoa?@8?Ų"?Zf0h?      @    7?HS 	p?رo߬??Io?Ж}?/ēr.?Mj?DbjT?u`v`?TEvʣ?:8      @    ?H P>ئ8?ҍ?Uh?0?^бF?{]?i?tiY?K_n!r?\v?7<
w   @33@      <@    ?oN8?S(c?ng?`<?,7Z'5ICcaI`տж)[?      ?#6k?|="                 0                  "   
                                 "       H    p                    "                  0                  "   4                        Hm
   <   pm
   <   p
   m
   <   p
           "   4            (            Xn
   p=   m
   0      "   d            l                    "   d                                "   (                                "   (                        Po
   @g   P	   A   (o
   A   n
   0      hp
   0g   @	   pB   @p
   `B   p
   xo
   p   Xq
   g   0	    C   0q
   C   p
   p
      Pr
   g    	   0D   (r
   @D   q
         ^^^^^^ܿYY|?qAAp?UUUUUU?    ?   n?=  @cb?HO

oa?,aȹ?6(]?0ɗ^?AMg @7%l`x<rc.+ҿZ)nh/AԿxIiN?e;"   P    (    h                    "   
             0          []      "   
             0                  "       X                        "                           8s
   X   xr
          "   (            0            Xt
   g    	   `Z   0t
   PZ   `s
         size of         t
       .o
   4o
   :o
   @o
   Fo
   Lo
   Ro
   Xo
      0   @   ^o
   do
   ?      .@{T4bU@
+/NW+@HM%;KZr?a7	Bu?u"7#?@&p7*E@wǛܿ&-DٔÊ?39e0!cAg?IBx.ȼ٥m4XL.Q$]WsAb`CF:ey_b
٢+8 ,"zYǣp0ih8vJU;È[1
@Y?4뿡i?6+Ab\ƖG?7pc?,xV?_տZ?:ղ>GHM]!_k;>fAδ>6
)%$Ç5=ΡB)r
@.ցǼ]?t	${?N`Ch6޿
NMfV|O102dQ*Cv=?	h@k}}Sų()%a5"                 	 0                  "   4            
            u
   0|   u
          "   h            P
            `v
   |   u
         Xw
   g   	    ~   0w
   ~   v
         Px
   Pg          (x
   0   w
                @      p?E6`     @JQ5     @Pr@	ouU@{@@ZG@FLHnAC&kĨ5A
B;AžѠ%A.A@wp@6Ґ@
b-(@M @O:8@u	2/Ʋ7wȳYXzbqw.`b YI?76O0Y)МbZFtP,811AMʲ@{aUA7oTPB[MBbzsFmNCZCRοx@MUNXG`SAF1TBU·J
&C3"OUFeȐ@5J
"AK5A)꾙#B$vBMu
TLm+M%@ÈIc⃼A)*-ANՎ]@"   h            x            y
   К   xx
         "   (                                "   (                        z
   g         y
      8y
         0z
   `              _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?        $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?        "   4            D            z
              "   (            x                    "   (                        {
   pg      0   {
   @   z
   @      "   (
            8
            Expecting a square matrix; rows of      columns of      "   
            
 0          ]=      is not lower triangular;        "   
            0 0          lb_free Lower bounded variable          "   `            h                    "                          Number of posterior samples for output  Evaluate ELBO at every eval_elbo iteration      Number of Monte Carlo samples for ELBO  Number of Monte Carlo samples for gradients     stan::variational::advi "               ,                  $@"                               "   `                                 "   H            P               "   H            x                    "   `                                "                                   "   4                               "               d                    "                                   "   4                               "   8            H                    "                                   "                              "                                   "   T            d                    "                                   "                                   "       l                        "                               "   p                                "   
            H 0                  "   `                                "   `                                "   4            L                   "                                  "                                   "   0            @                  ?ȅeA?     @&GVW     @@E.,[@@.=@/R V@hcjzB@,G`@ N@Nj֐W@
z=4L6}(e[ NV` l=gW/7c@14=]@)3M3@oַ@Zw?ub8c@L1@t@WY_,0@t>@1Ds+t@HB9M_L\?>@%_ qwV.8Ao+#LKH@1%9@xB)A@~@>F2@4bwI+1
  Z,h-A@VA!q髠AHps!BՉp³`BfTO)QwMY@!|l!hBGJYA(z-	X"   `                           "   (            8                    "   p                                "                                  "               ,                    "   `                                "   $            4                    "   4            h                   "                                   "                                   "
   x                       ; position=     mismatch in dimension declared and found in context     ; dims found=   ; dims declared=        mismatch in number dimensions declared and found in context     ; base type=    ; variable name=        ; processing stage=     variable does not exist int variable contained non-int values   int     dot_product v2  v1      {
               "   '                                "   @            X                    "                                   "   &                                "                t                    "   <!            !                   "       "    #                    "   &            L#                    "   x#            #                    "   #            #                    "   &            ,$                 @@      @      @      @      ?      ?        "   &            $                    "   %            $%                    "   %            %                  "   &            &                    "   &            0&                    "   &            X&                    "   &            &                    "    '            '                   "    '            `'                   "   '            '                    "    (            (            P|
   H    J   n           "   @(            P(                    "   (            (            |
   H    J   n           "   4            ()            Mean vector     Dimension of input vector       Dimension of current vector     Dimension of mean vector        Dimension of Cholesky factor    Cholesky factor         H}
   n   n   n   n   n   n   n   n   n   o           "   @(            )            vector provided does not match the parameter length     "   *    )    ,*                    "   *    *    *                    "   .    + 
   +                    "   ,    ,     - H                  "   .    - 
   -                    "   .    p. 
   .                    "   @/            p/                    "    0            @0                    "   @/            0                    "   0            0                    }
      .p
   n   n      0   @   p      "   9            $1            Step size =             "       l1    1 0                  "       1    2 0                  "   \2            d2                    "   2            2                    "   2            2                    "   3    2    03                    "   3            3 p                  "   3             4                    "   D4         	   |4                   "   4            4                    "   4            D5                    "   4            5                    "   H6     6    `6 0                  "   '            6                    "       7    7                    "       48    \8 0                  "       8    8                    "       <9    d9 0                  H~
      P	   P         0   @         ~
      	            0   @   p                 "   9            9                    X
       (	   P   P   P   0   @         "   9             :                    8
       `*	         P   0   @                    
       6	   P         0   @      P   "   9            D:                    
      09	      @      0   @      P              "   .    : 
   : 0                  "   L;            d;            circular_buffer         "   ;            ;                    "   ;            <                    C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     no more scalars to read "   ;            L<            double __cdecl stan::io::reader<double>::scalar(void)   "   <    <    <                    "   >         	   X=                   "   3            = p                  "       >    8> 0                  "   >         	   >           numeric overflow        Value %1% can not be represented in the target integer type.    "   ?            l? `                  "   ?            ? `                  "   @            @ 0                  "   @            @ 0          (
              "   8A            @A 0                  "   pA            A                    "   pA            A                    "
    B            PB `           is needed.      is found, but  array is not long enough for all elements:              C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\src\stan/io/array_var_context.hpp           void __cdecl stan::io::array_var_context::validate<double>(const class std::vector<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >,class std::allocator<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > > > &,const class std::vector<double,class std::allocator<double> > &,const class std::vector<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> >,class std::allocator<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> > > > &)   ).  should be no smaller than number of parameters (found   )       size of vector of dimensions (found             
      P	   P         0   @         "   C            0C            energy__        int_time__      stepsize__              0
      	            0   @   p                 "   C            C            divergent__     n_leapfrog__    treedepth__     
          
      E	   P         0   @         ؅
       0           
   0   PF	            0   @   p                 "   8            XD            
           
      	   P   P   P   0   @         "   p            D            @
       0   
      	         P   0   @                    "               D            
          h
      	   P         0   @      P   "               dE            
       0    
   @   	      @      0   @      P              "   E            E                    "   (F     F    @F                    "   F    F    F                    "   \G            dG            Overflow Error          "   G            G               6s?D?    ͜?{>MA?      ?Dݿf2	A?ʇƅȏD?{    ͜Vph?4W'ђ
cՇ?MA6;
>boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)              @!?     X@i4E?     @=Ը.h?     l@!X@VMS@Ը.?t AmqDx@3q&zA5X3=4BIB~Ӝ+C+/CD뤍p1o}/@L}<cn[P\AD
F
C9=£:CM%<<w@=JKAskPA-խBTB
胩BϚnsfQm1@_7QADT4jM$B?gx	`144o5Ƅ@cto)
AdˊA
q"aB"gAd[ag2"7D@yxl=@M/")8B%/bXAa۾     @!]?     @.N@CԾ@m@c/ALyo&AfdQBmbgoB5c[CvACt<DQ9=AFFFUB@ͷ1I/-U,CeawTïT]Cd@FAO'|5A)ÊB+EhBxBNsA?_5[A\At<U,o"B@4W=A1nBdAMi@OP@$@̴F@钳|A0U&@@<I;@	Ch@O'R#W@OQ|\@Ƭ@
R,X@@ n%=APnAT)Qx@jۧa@f\( ]@P@Topvm*@<!\C'"]I{f)DCprd
8`6>o}'-@c03C?@?I'@$H}@إ@9VkM@	# B@4t@<r@93@7V`c@gPUJ@n28p@z86V?BlFA@2s?
;@:goz`@b]W@O♿@"@!V@
o'iϔ@,Su@#1@4F@3!$sX7&D}
@Ny-Ϳ<MJr~)X7&4Sq`	2@T)#?rX@'#oˉ@?d=쩥A%f:%Aq@        "   H            I           boost::math::trunc<%1%>(%1%)    boost::math::expm1<%1%>(%1%)            "   '            I                    "   '            J                    "
   HJ            J                    "   @K            HK            
   0F   <   8
   0F   P=           "   $M            |K                    "   K            K                    "   K            K            
   0F   @   H
   0F   @           "   $M            (L                    "   @K            \L            Џ
   0F   `B   "   @K            L            X
   0F   C   "   $M            L            8
   0F   D   "   $M            L            
   0F   E   @
   0F   E   
   0F   F   "   $M            ,M            #B;      C        "   \M            dM            H
   0F   G   "   M            M            accept_stat__   lp__    "   M         	   M            g_  p_  "O   <O    tN    Q H         Error transforming variable beta:       Error transforming variable sigma_obs:  Error transforming variable delta:      Error transforming variable m:  Error transforming variable k:  variable beta missing   beta    variable sigma_obs missing      sigma_obs       variable delta missing  delta   variable m missing  m   initialization  variable k missing  k   :0yE>        "   L            `V 0                  "   V         %   DW H          m_pr    k_s gamma       "   X            Y (          invalid map/set<T> iterator             "   HY            XY 0                  "   pZ    HZ    Z 8                  "   [    Z    ,[ 8                  "   [            [                    "   \            [                    "   \            \                    "    <]    \ 4   <^          t_change                "   _            `                   "   x`         	   `                    "	   a            Pa                   "    b    a 	   Pb (          Evaluation of function at pole %1%      "   b            @c 8                  "   E            c                    "   c            c P                  "   Xd            `d                    "   d         
   d                   "   e            e                    "   e            e                    "   Tg            ,f                    "   |f            f            stan::variational::normal_fullrank      "   f             g                    "   Tg            lg                    "   x            g                    "   h            ,h 0          Log std vector  Dimension of log std vector     stan::variational::normal_meanfield     "   |h            h                    "   h            i                    "   i    i    j 0                  "       j    j 0                  "   	            k 0          map/set<T> too long     "       dk    k 0                  "   	            k 0          log1p<%1%>(%1%) log1p(x) requires x > -1, but got x = %1%.              "   tl            l                    "   m            m                    "       Tm    |m 0                  "   ln            |n                   "   o            o @                  "   p    p 	   p (                  "3   q    q 4   xs          Y   X   t   A   cap     "   4u            <u            ȓ
   0F   
   "   u            u             
   >"    v            0v            boost::math::digamma<%1%>(%1%)  boost::math::itrunc<%1%>(%1%)           A        "   v         
   v                   "    w            0w              A?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?        "   x            x            stan::variational::set_mu       stan::variational::set_L_chol   Dimension of lhs        Dimension of rhs        stan::variational::normal_fullrank::operator=   stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  Input vector    stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/=         "   y    y    y 0                  "	    |            { 0                 "	    |            H| 0                 "	    |            4} 0                 "    ~            @~                   "   ~            ~ @                  "   ~            ~                        @e@-DT!	      4        gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?              >      >"   L            T `                  "               Ѐ            H
   H    J               "               , H          ,       Diagonal elements of inverse mass matrix:       Ȕ
   n   n   `   n   n   n   n   n   n   0           "            	               H
              "   @        X                    "                                "   t    $     H                  "   0            |                    ȕ
      .p
   n   n   P   0   @         "0       ̅ H    @         Undefined transformed parameter: m_pr   Undefined transformed parameter: k_s    Undefined transformed parameter: gamma  "0   d     F    @               Pboost::math::tgamma<%1%>(%1%)   "               \            boost::math::lgamma<%1%>(%1%)           "            	    0                  C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/math/special_functions/owens_t.hpp              long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed                         "   L            l                   "       ԏ     0                  "   X            h @                  "   '            А                    "                                   "   |                                "   |                                 "   h            x            
   P   covariance      x
       0   "   h                        
   P   variance        (
       0   "   X                                 "   X            x                    "   X            Г                    "   X            (            P
   }           "                                   З
   n   n      n   n   n   n   n   n   	           "   @(                                "   8            H                    "                                   P
   
   @
            `   
   
   
   p           "   0         
   `                    "   Ė         
                       "   '            d                    "            
   ؗ                   "            
   L                   "       ̘     0                  "   ș    x     H                  "[   Ț                  tau     vector_d    sigmas  S   y   K   data initialization T           anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b              "   <     
   d @                  "        
   8 @                  "            0                  "            0                  "   T            l                    "            0          Non-finite function evaluation. Error evaluating model log probability:         Error evaluating model log probability: Non-finite gradient.            "
   p            ا                  "   ̨                       UUUUUU?UUUUUUUUUUUU?UUUUUUMb`?MbP?MbPMb`Mb@?        1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?{Gz?      ?        "   ̩            ԩ P                  "	   d                                И
   l    i   v   i   i   v   j   k   Py   "   t                        P
   H    J   @n           "   ܫ         	    H          Elements of inverse mass matrix:              @        "               Ь                   Й
   l    i   v   i   i   v   j   k   Py   "   0            H                    "                P          stan::variational::normal_meanfield::transform          "   ԭ                                "               p                    "               d                    "            
   D                    "               İ                    "            	   8 h                  "	                           vs     Number of unconstrained parameters does not match that of the model (           "	   ̲                               "                                   "                                    P
       (	   P   P   P   0   @         x
       `*	         P   0   @                    "   8            @                    "   p            x            Error evaluating initial BFGS point.    "   @(                                "   0                                
      .p
   n   n      0   @      P   q=
ףp?        "               е                   "       x 
                       "   \            l           ؗҜ<"           Է 0                  "               $                   "   и            ظ                    "                                   "               x            boost::math::owens_t<%1%>(%1%,%1%)      "   ܺ             `                  "       p     X          Scale parameter Location parameter      normal_rng      "   H            P                  @      ?        "        "   ` 0                  "   ľ        ܾ                   "                `                  "   <            T                    "                                   "   ,            D                   "                                  Ț
       6	   P         0   @      P   
      09	      @      0   @      P              "                                   "                                   "       ,    T 0                  "                                   "   D                  The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.   Gradient of mu  Dimension of variables in model Dimension of elbo_grad  Dimension of variational q      stan::variational::normal_meanfield::calc_grad  "               T                    "*        M                     "                                   "            
               filter is looking for elements out of range             "   l                                "               T                    "                                   "   x    P     `          log_prob        stan::variational::advi::calc_ELBO      stan::variational::advi::calc_ELBO_grad         "   D            l p          Posterior is improper. Please check your model.         No acceptably small step size could be found. Perhaps the posterior is not continuous?  ?    cA        "   (         X p                  "                                   "                0                  "
                                 "                0                  "
               8                  "               0 0                  "
                                 "       0 ,   P P                 Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.  ].  .        earlier than expected.  Found best value [eta =        Success!        ?Begin eta adaptation.   Number of adaptation iterations stan::variational::advi::adapt_eta      "            )                     This variational approximation is not guaranteed to be meaningful.              Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation may not have converged to a good optimum.        Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!       ?   MAY BE DIVERGING... INSPECT ELBO        MEDIAN ELBO CONVERGED           MEAN ELBO CONVERGED       @@          iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes    Begin stochastic gradient ascent.       Maximum iterations      Relative objective function tolerance   Eta stepsize    stan::variational::advi::stochastic_gradient_ascent     "
             	   P                    "                               "   D            \ p                  "   D              p                  "9            Q   T                  "   D     
   d                    "        
   <                    "                                   "   D     
   d                    "        
   <                    "        
                       "        
                       "   @/                                "               T          COMPLETED.       from the approximate posterior...      Drawing a sample of size    eta =       Stepsize adaptation complete.   iter,time_in_seconds,ELBO               "   X            , 0                  "   X            ` 0                  "   X             0                  "   X             0                  "                `          LS failed, Hessian reset        )\(?"   x                                "                X                 "                                  "   \            d                    "                                  "                0          stan::variational::normal_fullrank::transform           "                (                    "	               l h                  "               0                    "                      stan::variational::normal_fullrank::calc_grad           "   \                                "   @            P                    "            `                  "            
                      "                                  "   P     ,    p                 "            )   L                  "                `                  "   X                               "	                h                  "                                  "                                   "   h            x                    "                (                  "                                   "   x                                "   0                  }Ô%IJz5        "                                 "   	            	 0          Something went wrong after call_sampler.        -DT!@"   	            	                    "   
            
                    "   8
            @
                    "   h
            p
                    "   
            
                    "   
            
            
   o
                       O
 `O
                            O
         O
 O
                             @   O
             Л             @   P
                         P
         O
                         XP
 0P
                            pP
         P
 O
                             @   XP
                          P
 P
                            P
         Q
 O
                              @   P
                        H XQ
 0Q
                            pQ
         Q
 Q
 O
                     H            @   XQ
                        p Q
 Q
                            Q
         R
 Q
 O
                     p            @   Q
                         hR
 @R
                            R
         R
 Q
 O
                                 @   hR
                        Ȝ R
 R
                            S
         (S
 Q
 O
                     Ȝ            @   R
                         xS
 PS
                            S
         S
 O
                             @   xS
                         S
 S
                            T
         0T
 S
 O
                                 @   S
                        H T
 XT
                            T
         T
 S
 O
                     H            @   T
                        x U
 T
                             U
         @U
 S
 O
                     x            @   U
                         U
 hU
                            U
         U
                          @   U
                        Н V
 U
                             V
         0V
             Н             @   V
                         V
 XV
                            V
         V
                          @   V
                        @ V
 V
                            W
         0W
 XW
 O
                     @            @   V
             p            @   W
                        W
         XW
 O
                             W
 W
                            W
          X
                          @   W
                         PX
 (X
                            hX
         xX
                          @   PX
                         X
 X
                            X
          Y
 S
 O
                                 @   X
                        @Y
         PY
             @             @   (Y
                        p Y
 xY
                            Y
         Y
             p             @   Y
                        Z
         Z
                          @   Y
                        П hZ
 @Z
                            Z
         Z
 Y
                 П            @   hZ
                         Z
 Z
                             [
         [
 U
                             @   Z
                        X[
         h[
                          @   @[
                          [
 [
                            [
         [
 P
 O
                                  @   [
                        p @\
 \
                            X\
         x\
 XW
 O
                     p            @   @\
                         \
 \
                            \
          ]
 O
 O
                                 @   \
                         P]
 (]
                            h]
         ]
 ]
 O
                                 @   P]
             @            @   ]
                        ]
         ]
 O
                            ` 0^
 ^
                            H^
         `^
 O
                 `            @   0^
                         ^
 ^
                            ^
         ^
                          @   ^
                         (_
  _
                            @_
         P_
                          @   (_
                        p _
 x_
                            _
         _
             p             @   _
                        `
         `
             Ц             @   _
                        X`
         h`
             0             @   @`
                        `
         `
                          @   `
                         a
 `
                             a
         8a
 V
                             @   a
                         a
 `a
                            a
         a
 V
                             @   a
                         b
 a
                             b
         8b
 Z
                             @   b
                        @ b
 `b
                            b
         b
 Z
                 @            @   b
                        b
         c
 PY
                 x            @   b
                         `c
 8c
                            xc
         c
  X
                             @   `c
                         c
 c
                            c
         d
 ^
                             @   c
                        P `d
 8d
                            xd
         d
 P_
                 P            @   `d
                         d
 d
                            d
         e
 _
                             @   d
                        Pe
         he
 `
                 а            @   8e
                        e
         e
 h`
                 0            @   e
                         f
         f
 `
                             @   e
                        @ hf
 @f
                            f
         f
 f
                 @            @   hf
                          @   f
                         g
         f
                         8g
 g
                            Pg
         `g
                          @   8g
                          g
 g
                           g
         g
 `g
 h
 @h
                                      @   g
                 (       @   XP
             Л     (       @   P
                        X h
 hh
                           h
         h
 `g
 h
 @h
                         X            @   h
                 (       @   O
                         Hi
  i
                           `i
         i
 S
 O
 i
                                     @   Hi
                  @       @   8g
                @        Hi
 i
                              (j
  j
                           @j
         xj
 i
 S
 O
 i
 j
                                              @   (j
             Н         h      P   V
                @         (j
 j
                    x        (j
 j
                             @k
 k
                           Xk
         k
 R
 Q
 O
 i
                                         @   @k
                          k
 k
                            k
         l
 he
 `
                                  @   k
                        ` `l
 8l
                            xl
         l
 e
 h`
                     `            @   `l
                         l
 l
                             m
          m
 f
 `
                                 @   l
                @        @k
 Hm
                    (         g
 pm
                    (       X h
 m
                              m
 m
                            n
         0n
 R
 Q
 O
 i
                                          @   m
                @         m
 Xn
                             n
 n
                           n
          o
 k
 R
 Q
 O
 i
 j
                                                 @   n
                @        n
 (o
                    x       n
 Po
                             o
 xo
                           o
         o
 g
 `g
 h
 @h
 p
                                             @   o
             Н         @      P   V
                (        o
 @p
                    P       o
 hp
                            p p
 p
                           p
         q
 h
 `g
 h
 @h
 p
                                 p            @   p
                (       p p
 0q
                    P      p p
 Xq
                             q
 q
                           q
          r
 0n
 R
 Q
 O
 i
 j
                                                 @   q
                @        q
 (r
                    x       q
 Pr
                            ` r
 xr
                           r
         r
 0W
 XW
 O
 s
                             `            @   r
                  (       @   8g
                (       ` r
 8s
                             s
 `s
                           s
         s
 r
 0W
 XW
 O
 s
 t
                                                 @   s
             Н         P      P   V
                (        s
 0t
                    `       s
 Xt
                            P t
 t
                            t
         t
 f
 f
                     P            @   t
                         0u
 u
                           Hu
         xu
 Q
 Q
 O
 i
                                         @   0u
                @        0u
 u
                              u
 u
                           v
         8v
 0T
 S
 O
 i
                                          @   u
                @         u
 `v
                             v
 v
                           v
         w
 xu
 Q
 Q
 O
 i
 j
                                                 @   v
                @        v
 0w
                    x       v
 Xw
                              w
 w
                           w
          x
 8v
 0T
 S
 O
 i
 j
                                                  @   w
                @         w
 (x
                    x        w
 Px
                             x
 xx
                           x
         x
  Y
 S
 O
 i
                                         @   x
                @        x
 y
                             `y
 8y
                           xy
         y
 x
  Y
 S
 O
 i
 j
                                                 @   `y
                @        `y
 y
                    x       `y
 z
                            p Xz
 0z
                           pz
         z
 Q
 O
 i
                         p            @   Xz
                @       p Xz
 z
                             {
 z
                           ({
         `{
 z
 Q
 O
 i
 j
                                             @   {
                @        {
 {
                    x       {
 {
                              |
 {
                            |
         (|
                          @    |
                         x|
 P|
                            |
         |
                          @   x|
                        H |
 |
                            }
          }
 |
                 H            @   |
                        x p}
 H}
                            }
         }
  X
                 x            @   p}
                         }
 }
                            ~
          ~
 Y
                             @   }
                         p~
 H~
                            ~
         ~
  ~
 Y
                                 @   p~
                         ~
 ~
                            
         0
  ~
 Y
                                 @   ~
                         
 X
                            
         
 
 Y
                                 @   
             `            @   
                         
         
 Y
                             `
 8
                            x
         
 
 Y
                                 @   `
                        @ 
 
                             
          
 H
 Y
                     @            @   
                         @   p
                        
         H
 Y
                              ȁ
 
                            
          
 H
 Y
                                  @   ȁ
                         P
 (
                            h
         x
                          @   P
                         Ȃ
 
                            
         
 ~
  ~
 Y
                                     @   Ȃ
                        0 X
 0
                            p
         
 0
  ~
 Y
                         0            @   X
                         
 
                            
         @
 
 ~
  ~
 Y
 h
 
                                                 @   
             x           @   b
             @            @   (Y
                        
 
                            н 
 
                            
         `
 
 0
  ~
 Y
 
 
                                     н            @   
             x           @   b
             @            @   (Y
                       н 
 ؅
                             (
  
                           @
         
 
 
 
 Y
 
 
                                                 @   (
             p            @   І
                        
         
 
 
 Y
                         (           @   8
                        P
         h
 PY
                 (            @   8
             @            @   (Y
                        (
 
                            ` 
 
                            
         `
 
 
 
 Y
 
 
                                     `            @   
                         @   
                        Ȉ
         
 
 
 Y
                         (           @   8
             @            @   (Y
                       ` 
 @
                             
 h
                           
         
 
  
 H
 Y
 x
 
                                                 @   
                         @   8
                        P
         
  
 H
 Y
                         `           @   
                        
         Њ
 PY
                 `            @   
                        
 
                             H
  
                           `
         
 ȋ
  
 H
 Y
 0
 X
                                                 @   H
             @            @   
                        
         ȋ
  
 H
 Y
                         `           @   
             @            @   (Y
                        H
 
                            
         ،
 xX
                             @   
                        
         0
 xX
                             @    
                        p
         
 xX
                             @   X
                        @ ؍
 
                            
         
 0
 xX
                     @            @   ؍
                         `
 8
                            x
         
 
 xX
                                 @   `
                         
 
                             
          
 0
 xX
                                 @   
                          p
 H
                            
         
 ،
 xX
                                  @   p
                        @ 
 Џ
                            
         0
 ،
 xX
                     @            @   
                         
 X
                            
         
 0
 xX
                                 @   
                        
         
 xX
                             @   
                         `
 8
                            x
         
 
 xX
                                 @   `
                        ( 
 
                             
         
 xX
                 (            @   
                        ` h
 @
                            
         
 xX
                 `            @   h
                         
 
                             
          
 
 xX
                                 @   
                         p
 H
                            
         
 xX
                             @   p
                        p 
 ȓ
                            
          
 xX
                 p            @   
                          p
 H
                            
         
 |
                              @   p
                        P 
 Ȕ
                            
          
  X
                 P            @   
                         p
 H
                            
         
 x
                             @   p
                        ` 
 ȕ
                              
 
                            0
         P
 8b
 Z
                                  @   
                        ` 
 x
                            X Ȗ
 
                            
          
 8b
 Z
                     X            @   Ȗ
                        ( 8
 (
                             x
 P
                            
         
 h[
                             @   x
                         
 З
                            
         (
  X
                             @   
                         x
 P
                            
         
  X
                             @   x
                        X 
 И
                            
         (
 U
                 X            @   
                         x
 P
                            
         
 |
                             @   x
                         
 Й
                            
         (
 U
                             @   
                        p І
 P
                             
 x
                             p
 
                             8
 Ț
                            @ 
 
                             @
 
                            X
         h
                          @   @
                                             
 
4 
2p 4	 
Rp"p
        -  4	 
Rp"p
 @         4	 
Rp"p
 p  5     N  2p! 4   U  @
 !   4   U  @
 !   4   U  @
 !   4   U  @
 !   4   U  @
 !   4   U  @
 !   4   U  @
 x
  0"p
 `  2P           y
  y
 @y
 `y
  4 p"p
   2P 2P 2P 2P                      )  G     U  y
     y
  4 
p"p
   2P 2P                     y
 y
  z
  0"p
 ،  2P 2P 2P        )  N     [          20        	    0    z
 8   	   p p   `z
 8   	   @ @   z
 8   	   H `   z
 8   	   p      {
 8   	   h (   `{
 8   	   Ȝ 8   {
 8   	    H   {
 8   	   x X    |
 8   	   H h   `|
 8   	   Л x   |
 8   @           |
 8                 
   "p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
   
 
2P"p
                      z
     -z
    Kz
     mz
    z
     z
    z
     z
    {
     -{
    K{
     m{
    {
     {
    {
     {
    |
     -|
    K|
     m|
    |
     |
    |
     |
    }
      20 20
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   d 4 2p 20
 
4 
2p d 4 2p 20
 
4 
2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p  
 
4 
2p d T 4 2p	 p`P0   d T 4 2p d 4 2p d 4 2p
 
0! t d T A  A  
 !   t  d  T A  A  
 !   A  A  
  0! t d
 T B  B  D
 !   t  d
  T B  B  D
 !   B  B  D
  20 R0
 
4 
2p	 	r! 4
 F  F  
 !    t d T F  F  
 !   t  d F  F  
 !   t F  F  
 !   F  F  
 !   F  F  
     20
 T 4 R
p` B  ! 4	 K  L  h
 ! t L  L  p
 !   L  L  p
 !   K  L  h
  d	 4 Rp t 20
 
d 
2p! 4 0O  tO  ԥ
 !   0O  tO  ԥ
  d T 4 2p
 t d T 4 
 
4 
2p B  
 
4 
2p T 4 R
p`
 T 4 rp`!  0W  W  d
 !   0W  W  d
 
 
4 
2p d T 4
 2p 4  2p T	 4 2p!  d [  \  ئ
 !   [  \  ئ
  d T 4 pP Pd	 K4 t T
 2 B   B   B   B   B   B   B   B   B`0  !$
 $  
 
t	 T `  `  
 !   t	 `  `  
 !   `  `  
 
 
4 
2p< <4 
d 
2p 4  2`P0! t	 Pd  yf  
 
 
4 
2p B   t 
4 
2` 20!
 
t d i  i  <
 !   t i  i  <
 !   i  i  <
 
 
4 
2p 20 d	 T 4 2! t k  l  
 !   k  l  
  20
 
4 
2p! d m  m  Ԩ
 !   m  m  Ԩ
  R
pP0! d
 n  o  
 !   d
 n  o  
 !   d
 n  o  
  4 p d 4 2p
 
4 
2p 20 20!! !	 t 
d T 0t  Qt  |
 !   0t  Qt  |
  B   B   20 d	 4 Rp B   B   ! " "t 20!
 !t) !d( !T' !4& !"    20
 
4 
2p B   R0 20! t  ~  *~  D
 !   t  ~  *~  D
 !    ~  *~  D
  B  ! 4 ~    
 ! t  4 ~    
 !   ~    
 ) ) # x d 4 p! h   p  Ȫ
 !     p  Ȫ
 `}
      }
    @}
  4 Rp"p
    2P 2P 2P0  S      [     w            d 4 2p}
  4	 
Rp"p
 H  2P`           B   b
p`0  !   
 T Є    ȫ
 !         T Є    ȫ
  b	  !   t d
 T 4 `  o  
 !   `  o  
 !       t  d
  T  4 `  o  
  d T 4 2p B   B  
 
4 
2p
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 d 4 2p
 d T
 4 rp b
p`0  !   
 T 0  ^  
 !         T 0  ^  
  b	  !   t d
 T 4   Ϣ  
 !     Ϣ  
 !       t  d
  T  4   Ϣ  
    !` ` [T
 %  t 
d 4     `
 !       `
 h
 h cT ^4
 	Rp`K
 K FT
 
4 
R	p`   !Y Y TT
  t 
d 4   ȱ  Ԯ
 !     ȱ  Ԯ
  20!
 
t d    q  
 !   t  d    q  
  BP  !g gt
  d	 4     P
 !       P
 X XT t d 4
 r b  !k k f at \d T 4
 P  _  
 !   P  _  
 !       t  d  T  4
 P  _  
   	  ! T    t d 4     
 !          
 !        
 !       
 
 
4 
2p B   t d T
 4 rO
 OT d 4
 r
p
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 t	 d T 4 2 B   t d
 T	 4 2}
     }
  p0  "p
 p  2P 2P                    T
 4 2p` t d
 T	 4 2
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p B   20
 
4 
2p
 
4 
2P! t d   
 !   t   
 !     
  20 t d
 T	 4 2 b   d T 4 2p B  ! 4  ' 
 ! t  4  ' 
 !    ' 
  B  ! 4  *
 ܳ
 ! t  4  *
 ܳ
  B  ! 4 
 
 
 ! t  4 
 
 
 !   
 
 
  B  ! 4 p  T
 ! t  4 p  T
 !   p  T
  B  ! 4 `  
 ! t  4 `  
 !   `  
  B  ! 4 P  ܴ
 ! t  4 P  ܴ
 !   P  ܴ
  B  ! 4 @   
 ! t  4 @   
 !   @   
  B  ! 4 0  d
 ! t  4 0  d
  d	 4 Rp ~
      ~
 ( (h #t d T
 4 "p
   2P 2P B           B   20 d 4 2pP~
 & &d !T
 4 
p"p
   2P &     u p~
     ~
  	  d. T- 4, * p  "p
   2P 2P 1               ~
     ~
    ~
    
    0
    P
    p
    
    
    
    
    
    0
    P
    p
    
  dH 4G D p  "p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      w        4    W                    i                    -    M     	        
       #    C    y         
       %     E     j     
 t	 d T 4 2 T	 2! t d 4 p" " 
 !   p" " 
  B  
 
4 
2p B   B   . P  ! ( ) * + t, d- 40 ' ' X
 !   (  t,  d- ' ' X
 !   t,  d- ' ' X
 !   d- ' ' X
 !   ' ' X
 
 t	 d T 4 2 T	 2! t d 4 t "t  
 !   t "t  
   
  ! 
   t d T 4 0w Gw 8
 !   
 0w Gw 8
 !   0w Gw 8
  T
 4 rp` >   ! 7 t: 8 9 d; T< 4= `  
 !   `  
 !   7  8  9  t:  d;  T<  4= `  
 
 d T 4 p  	  !  d  
 t T 4   4
 !   T   4
 !     4
 !       
  t  d  T  4   4
   !    d  t T 4  " 
 !       " 
 !     " 
  b   2	p`P0 B   B   20 20 B   B   20 B   B   20 20 d	 4 Rp T
 4 rp` t d T 4  T
 4 rp` T
 4 rp` B  
     Ѐ
 ( . p`P0  "p
 8  2P 2PP       !    !     !  20
 d T 4
 Rp
     
    0
    P
    p
 ' '48 0 
p`P  "p
 `  2P 2P 2P 2P 2P # n#     }#    )    f)    ;.    .    0    0    2     2 ) )h t d T
 4 
     
  	 0  "p
   2P 2P5 K5     W5    t5     5 
      
  	 0  "p
   2P 2P6 6     6    7     7 S Sd
 NT	 
4 
Rp 
 #
 #h d
 T 4 rp"p
 ؏  2P< =     G= @
 : : 5 0 +x 'h #T 4 	p`"p
    2Pp= A     CA p
     
  Rp
`P0"p
 (  2P 2PA A     A    A     aB 
     
     Ђ
    
 . .x *h	 &4  
p	`P  "p
 P  2P 2P 2P 2PB B     B    C    1C    IC    F     
     P
     p
    
 &
 &4 
p	`P"p
 x  2P 2P 2P 2P@G lG     G    G    G    G    ?K     
      
     @
    `
    
    
    
    
     
     
    @
 ) )43 * 
p	`P  "p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2PK K     L    L    EL    ]L    N    N    O    O    O    O    O 	   O 
   O    lP    P    P    2Q     Ѕ
     p
     
    
 &
 &4 
p	`P"p
 Ȑ  2P 2P 2P 2PQ Q     Q    Q    	R    !R    {U     
     @
     `
    
    
    
    
     
     
    @
    `
 ) )43 * 
p	`P  "p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2PU V     OV    ^V    V    V    X    X    FY    WY    Y    Y    
Z 	   Z 
   =Z    Z    Z    :[    r[     
     
     
    Ї
 &
 &4 
p	`P"p
   2P 2P 2P 2P[ [     \    .\    I\    a\    _      t d 4 ! T  ` f` 
 !    ` f` 
         	   @ (   0
 8                 
  
R0"p
 @ 
 
2P"p
 @ a a     a 0
     =
    N
     p
 
    
    Ј
    
    
    0
 P
 & &T& "4$  	p`  "p
 h  2P 2P 2P 2P 2P 2P 2P 2Pa =b     Lb    [b    jb    yb    b    b    d    od    ie    xe    e    e p
 
    
    Љ
    
    
    0
 P
 & &T& "4$  	p`  "p
   2P 2P 2P 2P 2P 2P 2P 2P f Mf     \f    kf    zf    f    f    f    $h    h    yi    i    i    i p
 
    
    Њ
    
    
    0
 P
 & &T& "4$  	p`  "p
   2P 2P 2P 2P 2P 2P 2P 2Pj ]j     lj    {j    j    j    j    j    4l    l    m    m    m    m p
 
    
    Ћ
    
    
    0
 P
 & &T& "4$  	p`  "p
   2P 2P 2P 2P 2P 2P 2P 2P n mn     |n    n    n    n    n    o    Dp    p    q    q    q    q Ќ
     p
     
    
     
     
    @
     `
 & &4  
p	`P  "p
   2P 2P 2P 2P 2P 2P 2P 2P0r \r     r    r    r    r    r    s    	t    6t    Dt    5u    Au    u     
  4
 
Rp"p
 0  2Pu u     u 
  4
 
Rp"p
 X  2P0v Vv     mv 
  4	 
Rp"p
   2Pv v     v 
 ! !h d 4 p"p
   2Pw Fw     w 
  4
 
Rp"p
 В  2Pw x     x 0
  4
 
Rp"p
   2PPx vx     x P
  4	 
Rp"p
    2Px x     x p
  d 4	 
Rp"p
 H  2P0y [y     y U U
 M E = 5 - %  x h 3 
pP!E
 E 8/ (0 d1 42  z { 
 !    z { 
 
 
    Ў
    
    
 #	 #d T 4  p  "p
 p  2P 2P 2P 2P 2P 	         9    H    Z    h    C     @
 `
    
    
    
 #	 #d T 4  p  "p
   2P 2P 2P 2P 2PP          ɂ    ؂            Ӄ    B 0
     
     
    `
    
    
    
    
     
     
     @
 . .h ; p`
P0"p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P  4     [                )    A    P    \    ~     	        =    L     
   P     
     `
     
    Б
    
    
    0
    P
    p
    
     
 . .h ; p`
P0"p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      ې        j                Б    ܔ         	           ̙    > 
   Л      20w w ^ X R 0 + &	 !
 x h  В
 
    
    0
    P
    p
    
    
    Г
    
    
    0
    P
 p
 - -x )h %4: 2 
p`P  "p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P  y     Ğ        5    S        ϡ        .    ȫ         	   n    P 
   b                    R    ` 
     20
 
    
     
     
               @           @
 8               `
 -	 ! p`0  "p
 8  2P 2P 2P 2P 2P
 
2P"p
 8 P                  ^    l            n
    
 @
     M
    t
     
 
    Е
    
    
    0
    P
    p
    
        	   
        @           Ж
 8   	   
         
 -	 !0 p`0  "p
 `  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2P"p
 ` 
 H     `                                    q 	    
    	                    Ж
     ݖ
    
      
 @
    `
    
    
    
    
     
     
    @
    `
    
    
 -
 -h )47 . 
p	`P  "p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P          #    j                u         !    ~! 	   "    (# 
   9#    &    (    (    ))    7) 0
     И
     
    
    `
    
    
    
 ) )4!  
p	`P  "p
   2P 2P 2P 2P 2P 2P 2P 2P) )     )    *    "*    .*    Z*    i*    +    +    +    ,     -    I-     
 
4	 
2p 20 d T 4 p t d T 4  20
 
    0
    P
    p
    
    
    К
    
    
    0
 P
 ' '4, $ 
p`P  "p
 ؔ  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2Pp4 4     4    
5    "5    I5    a5    p5    8    8    8    ?9 	   P9    =    =    b> 
   >    >    ? 
 
4	 
2pО
     p
    
    
    Л
    
    
    0
    P
    p
 	   
 
   
    М
 
   
 
   
 
   0
    P
    p
    
    
    Н
    
    
    0
    P
    p
    
 
   
 
    
     
    @
 1 14 ! p`P  "p
    2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P@ @    @    	A    A    C    C    6D    _D    D 	   D    E    "E 
   _E    E    F    F    gF    }F    F    F    )G    ?G    nG 
   G    G    $H    3H    ;H 
   CH 
   H 	   ~I    zJ    J    J    J    J    'K     p
 
    
    П
    
    
    0
    P
           p
           
  
 @           
 8      	   
      <
 + +h . 
p`0  "p
 (  2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2P"p
 (  2P 2P`K K     L    )L    pL    R     S    T    T    NU    V    V    W 	   *W    X    Z    Z    
[ 
     
 
   Ġ
     0
 P
    p
    
    
    С
    
 
 + +4!  
p`P  "p
 P  2P 2P 2P 2P 2P 2P 2P 2PP[ [     [    [    [    !_    /_    _    `    #a    .a    pa 0
 P
    p
    
    
    Т
    
 
 & &T& "4$  	p`  "p
 x  2P 2P 2P 2P 2P 2P 2P 2Pa a     a    b    b    )b    7b    b    c    d    e    (e    7e    ~e  d 4 2p d 4 2p0
     P
     p
    
    
    У
    
    
    
    0
 	   P
 +
 +d' 'T% #4$  
p  "p
   2P 2P 2P 2P 2P 2P 2P 2P 2P 2Pg "h     h    i    i    j    j    k    k    	l 	   l 
   l 	   l    l    l    l     
m 
 
    
    
     
     
           @
               	   
            
    @
    `
    
           
           
                  
    
 
 @           `
 8   @           Х
 8   @           
 8   @           0
 8               
 	   
         
             
             ,
 3
 3h  /dI +4H B p  "p
 ȕ  2P 2P 2P 2P 2P 2P 2P
 
2P"p
 ȕ  2P
 
2P"p
 ȕ  2P 2P 2P 2P 2P
 
2P"p
 ȕ  2P
 
2P"p
 ȕ  2P 2P 2P`m m      n    Gn    n    n    n    't    9t    ^t 	   pt 
   t    y    y 
   :{    \{    {    }    }    }    }    o                    z        )    7     `
     m
    
     ݥ
    
     ͦ
    
     =
    d
      d T 4 p 4	 
Rp"p
 p  Ւ      !    % ? ! 4   % ?  "   4	 
Rp"p
 @         
R0"p
 P  
 @ V     a  4	 
Rp"p
          4	 
Rp"p
  @ e     ~   "p
  Й               
 
RP"p
  
   "p
                L
 @           
 H   0 =     ^ `     
 
RP"p
   
   "p
                 
 @            
 H   p }           
 
RP"p
 P 
   "p
 P               
 @            
 H         ޜ      
 
RP"p
  
   "p
                
 @           @
 H                
 
RP"p
  
   "p
                
 @           `
 H   0 =     ^ `     
 
RP"p
  
   "p
                T
 @           
 H   p }           
 
RP"p
  
   "p
                
 @           
 H         ޝ      
 
RP"p
 @ 
   "p
 @               $
 @           
 H                
 
RP"p
 p 
   "p
 p               
 @           
 H   0 =     ^ `     
 
RP"p
  
   "p
                
 @            
 H   p }           
 
RP"p
 П 
   "p
 П               \
 @            
 H         ޞ      
 
RP"p
   
   "p
                 
 @           @
 H                
 
RP"p
 0 
   "p
 0               ,
 @           `
 H   0 =     ^ `      4 p"p
  
 
 
 
       + O    ] {          !     
 !
 
	 4   
  d T
 2
p!     <
 ! 4   <
  t	 d T 2G G A ; ( "x h  . .h )4 Rp 4+ ( p  "p
 0 p           4	 
Rp"p
    ū     ޫ !      
 ! 
   	 
 
 T    
  p`0 4	 
Rp"p
  0 U     n !      ! t     h 
4 
Rp 4	 
Rp"p
  ` }       
R0"p
   
 @ V     j  BP  "p
   4 r
	p`"p
              
 @           
 H   @
 `
               
 P      Ի            ϼ     
     
    
      BP0  "p
    4 r
	p`"p
               
 @            
 H   
  
               `
        ˽    ٽ            Ǿ  
     .
    K
      	  d4 T3 42 0 p  "p
 P   C         ſ           d- T, * p  "p
    L             d- T, * p  "p
   <          !   @  h
 ! t d 
T 4
 @  h
  B  * *4 B   d T 4 2p! !d
 !T !4
 !2p!     
 !     
  p
`P07 7x 2h t d T
 4  	  d4 T3 42 0 p  "p
                      	  d4 T3 42 0 p  "p
 0                   : : x 	h   " "x h 
4 
p 	  d4 T3 42 0 p  "p
 ` 
     
     
 0 s                 !   0 + P
 !   
  0 + P
  p
`P0!   P  
 !  P  
 
 T 4	 p` 	  d0 T/ 4. , p  "p
   
     @
 @            	  d0 T/ 4. , p  "p
   v           	  d4 T3 42 0 p  "p
 @  3                  	  d4 T3 42 0 p  "p
 p  3                  x h 4 0  "p
  `
     
    
    
    
     
     
    @
    `
    
 p                  @    M    k                            *    I    {     	             1 14    !   P   !5 5 / ) #  	 P   
 
2P"p
   4 
Rp"p
                L
 @           
 8   0 U      
     
    ʭ
     
 
2P"p
    4 
Rp"p
                 
 @           
 8          
     
    

     !    2 ? ! 4   2 ? 	 T/ 4. * p`  "p
 P   `         !   
    !      ! 
    
 
2P"p
  
 b  "p
                
 @            
 8   ` p       
     -
    7
     
 
t 4 !     l
 !  l c Z B 9 0  x h   l
 '
 '7  p`P0%
  y q i a Y ;x 4h -47 &#!, p`P!     
 !    5 
 !   5 
 ! d 4   
 
 
T	 
2p 	2 0  "p
  @
     `
    
   D                   	  d4 T3 42 0 p  "p
                     % %d; !4: 8 
p  "p
 ж 
     
    
     
  U                     5  d3 42 0 p  "p
   
     @
 `
 
 
 
 
     
     
    @
    `
    
 @                     &    < Z    h          "    /    M    a     	        
           +    A  h R0 d T 4 2p!   p  
 !     
 !     
 !    
 !
 
    
 ! 4
 p  
  Bp`
P   4	 
Rp"p
 0 
         4	 
Rp"p
 ` 
         4	 
Rp"p
  
   E     ^  4	 
Rp"p
  p        4	 
Rp"p
          4	 
Rp"p
   0 U     n  4	 
Rp"p
 P  
        
 
2P"p
  
 b  "p
                
 @           @
 8   # #     # @
     M
    `
        d- T, * p  "p
 к 
     
  % O%     %    %  4	 
Rp"p
   0' U'     n'    '  	  d1 T/ 4. , p  "p
 p ) F*     *    *    dQ TP N p  "p
  
     б
    
    
 + ^+     +    +    ,    ^, !               	  x
 , 4-  !   , 4-  !    , 4-  !B B < 6 ' !  	 x
 , 4-     dQ TP N p  "p
  @8 8     8    8    L9    9  	  d4 T3 42 0 p  "p
   9 9     :    :    :    
 
2P"p
 P 
 b  "p
 P               \ @           0
 8   : :     : 0
     =
    G
     	 T/ 4. * p`  "p
   ; @;     ;     4	 
Rp"p
  ; <     < (<    ~<  4	 
Rp"p
   < <     < =    ^=  4	 
Rp"p
 p P
 = =     =  4	 
Rp"p
  > a>     >  4	 
Rp"p
  > >     >  4	 
Rp"p
    ? E?     ^? !               	  x
 PD E  !   PD E  !    PD E  !B B < 6 ' !  	 x
 PD E    h  0  G G ; 5 / * %   	 x
 h 
 K K  @ : 4 / * %  x h	 
  2pP0"p
    Rp`0"p
                < @           
 H           p
     @U cU     rU    U     U 
     
    ̲
     % %t1 !d0 T/ 4. ,   "p
 0 U V     CV    kV % %t1 !d0 T/ 4. ,   "p
 ` V $W     QW    yW  2pP0"p
   p`0"p
              l @            
 H   
             
         W W    W    W    X  
     /
    ^
      4	 
Rp"p
  p
 0X nX     X  4	 
Rp"p
   
 X Y     Y !   4 pZ Z  !   pZ Z  ! 4 pZ Z   b   h R0!   [ \  !5 5 / ) #  	 [ \  ,
 , '	 x
 h 
 !     
  j Hj $ !    j Hj $ !
 
 
  j Hj $  4
 Rp`P!   km >n X !  km >n X !  x
 j km p B B < + %   	 h 
 ! 	 x
 p &s  ? ? 9 - ' "   h 
 !   Pv cv  	 !   cv {v 	 ! h T	 cv {v 	 ! 4 Pv cv  	  d
 Rp!      d  4 @w _w 	 !      t  d  4 @w _w 	 !   w x 	 ! t w x 	 ! 4     d @w _w 	 !	 	  d @w _w 	  P	 T/ 4. * p`  "p
 0  y `y     y     4	 
Rp"p
 ` { {     { {    |  4	 
Rp"p
  @| e|     ~| |    | E E  x h 
4 
p!   S  
 !	 	 S  
 !
  x
  [h  @ S 
 #
 #   	 
 !     8 !s s j R I @ 7  x h   8 8 8
 '/  p`P0 4	 
Rp"p
 ` p
 
   E     ^ h      4	 
Rp"p
          4	 
Rp"p
  `       X X : 5 0 x h d 4 p 4	 
Rp"p
 P 
 
 О          d  4	 
Rp"p
        Ο  4	 
Rp"p
   5     N !   p  ? !	 	t  4 p  ? !    + 
 ! t  + 
  0   d 4
 Rp"p
 0 г
     
 @ f     {          !    x 
 !.
 .  x t d
 T  x 
  h 0!   0 b 
 ! d 0 b 
  T
 4	 Rp)
 )t3 %d2 !T1 40 , 	  "p
  0      i      h 
/ "p
  Ъ E     v      
R0"p
 0 
   Y        0  "p
 `   9     P    l          !   t  4   8  !     8  !
 
t 4   8   d
 4	 
Rp"p
 P @
     p
           ` /
 / ) x h 0 2pP0"p
   d
 4 
rp"p
                @           
 H           
     @ p               
     
    
      
R0"p
   ɵ       
R0"p
   
 @ y       
R0"p
   )     o  20 
R0"p
 @  ٷ       d 4	 
Rp"p
 p 0
     `
           P   0  "p
  p          ܺ         1     {  0"p
   Ż              R  0"p
   
     
 p               2   0  "p
 0 P               Ƚ         [  d
 4	 
Rp"p
 ` @
     p
 p      ¾      d
 4	 
Rp"p
  
     
 0 t         п  
R0"p
  
 0 i       d
 T	 4 Rp d 4	 
Rp"p
  
     @
   d     r      d 4	 
Rp"p
   `
     
  $     2       0  "p
 P 
     
       	    B      !     X% ! 4   X%  d
 4	 
Rp"p
   
     0
           ` 
 
2P"p
  !
 !d 4 
p"p
                 @           P
 8    ~     3 P
     ]
    s
      d 4 2p h d x   !   0 m  ! x 4
 h 0 m   d T p h g    !     p ! x t d
 {T j4 h   p 
 

 
2P"p
   4$ " p  "p
               	   h     
 8   
 
    
                 )     O ^            
     +    7 
      t 4  d 4	 
Rp"p
   
     0
 P           !   
   H  !     H  ! 
   H   4 Rp`P!     
   $ !     $ !
 
 
   $  	  d1 T/ 4. , p  "p
 @ p      %    b !      !  d 
T 4     
p!   @ k  !  d 
T 4 @ k   
R0"p
 p         
R0"p
  P         0  "p
  е
      
      
 `                   !     k   0  "p
                      A       d
 4	 
Rp"p
 0 
     
           @  d
 4	 
Rp"p
 ` 
     @
 `            !
   qx
 < 		    ! h    `      !      ! d 
T 4     t    
R0"p
 @ @ y       d 4	 
Rp"p
 p `
     
           0  d 4	 
Rp"p
  
     
 P             0  "p
  P
     
     
  I     `    |                d
 4	 
Rp"p
    
     0
 0 t          !   0 W | !  t 
T 4 0 W |  `  !      +   !   +  <   !    T +  <   ! t    +    r`0 
R0"p
 0       /  d 4	 
Rp"p
 ` P
     
               0  "p
  @ y                  ?  d
 4	 
Rp"p
  
     л
 `             d 4	 
Rp"p
  
      
   d     r     !     
 !
 
t d   
 ,
 ,t? (d> $T=  4< 8 	  "p
   @
     `
    
 
    
    
  
     
    @
    `
    
 
   
    
 `	 	     u
    
    
    
 
    Y    e                 #
    /
 	   J
    \
    
 
   <    H    c    u !      ! t
 
d	 T    
 
20!      ! 
 
t	 d    	 	2P0 R0"p
          d
 4	 
Rp"p
  
  
     
           6    B  R0 d T 4 p"p
  @
         R0"p
 @       4  P  "
  
	p`P0"p
 p `
 
    
    о
    
    
    0
    P
    p
    
 	   
    
  "     V    q                6    P                 	   * 
   x 	   }            W    w     "
  
	p`P0"p
  
 0
    P
    
    
    
    
     
     
    @
 	   `
    
 `               R     f                    V!    e!    !    ! 	   ! 
   " 	   "    4"    "    "    #    # !   $ % " !n n
 e N E
 <  x $ % " ! h 0 # $ " B
 B =  ( p`P0  
 
2P"p
   d 4
 
Rp"p
                " @           
 8   4 J5     5 
     
    
      R0"p
   5 5     6  4 Rp"p
 0 
     
    @
 06 a6     |6    6    6     6  4 Rp"p
 ` `
     
    
  7 17     L7    a7    7     7  R0"p
  7 7     8 $ $x h   !    : K: $ !  t 
T 4  : K: $  
` R0"p
  @ @     @ !    A AA $ !   t  A AA $ !
    t 
d	 T  A AA $    x h 0 # "p
   
 F F     !   K K X% ! 4 K K X%  p  >
u>h ,s'9  p`0P  "p
 P 
     
 L N     N    V     V !   V V % !
 
 4 V V %  d	 T 2p R0"p
  W W     W  R0"p
  W X     4X  R0"p
  `Y Y     Y !   Y Z & ! 
 
t	 4 Y Z &  2
`
P R0"p
  0
 Z [     $[ ;
u;h ,s'!  p`0P  "p
 @ P
     p
 @[ \     8]    _     _ ;
u;h ,s'!  p`0P  "p
 p @` a     -b    d     d !   e e 
 !
 
t d e e 
  4
 Rp"p
  
 g h     h    T 4 
R	p`"p
  
     
  h h     h    i   "p
    0     @0 0i Si     _i    |i     !   i i ( ! t i i (  T
 4	 R`* *d %T  4
 R
p"p
 P 
     
    0
 j "k     ek    k    k  	  d T 4  p  "p
   l rl     l l    l     l 
 
4 
Rp d T 4
 rp 	  d T 4  p  "p
  n n     	o    &o     Do 
 
2P"p
 0 # #t d
 4	 R"p
 0              * @           
 8   
                 0p wp     p    q 
     
    
     
 
2P"p
 ` # #t d
 4	 R"p
 `             * @            
 8    
                 q 7r     r    r  
     -
    @
     !   `t u 5 ! 4 `t u 5  4 2p!   u u \+ ! d u u \+ 
 
4 
2p
 
2P"p
  ) )h $d 4 r
p"p
                +             + @           
 8   @           P
 8   @v w     sw w    w P
     ]
    p
     
    
     
 
RP"p
   R	p`P0"p
  / &p`0"p
                ,             , @           `
 H   @           
 h           @
               
 x y     az z    .{    y{    { {    W| 
     
    )
     m
    
     
 
2P"p
  !
 !d 4
 R
p"p
                -             - @            
 8   @           
 8   | ?}     } ~    1~ 
     
    
     
    
     
 
2P"p
   !
 !d 4
 R
p"p
                 .             . @           P
 8   @            
 8                   ~       T      
     -
    @
     ]
    g
      
R0"p
 P p
     
    
    
    
    
   6    Q    \    g    r    }      !   `  / !     / ! 
   / !
 
t T
 `  / 
 
R	`0 d 4 
rp"p
  0
     P
     p
    
 Ѓ      '    3    Q    ]    d  4	 
Rp"p
                    Ȅ    Є     " "d T
 4	 
Rp"p
  
  ۅ     L  h 4. , p  "p
 `       +    8     Q 
 
RP"p
     "p
                1 @           
 H         X 
     
    
      bP0  "p
  " 
p`0"p
                2 @            
 X   `      f  
     
    =
      # "p
   P
 Ћ       # "p
 0 p
  1       "p
 ` 
       
 
B	p`P0  "p
   R
p`0"p
               3 @           
 X           
               (     7 
     
    
      48 	6 p  "p
  
     
    
    
     
  Ŏ     ؎            Ǐ    ݏ     # "p
   
  1     
 t d T 4  dC 4B @ p  "p
   @
     `
    
    
    
    
     
 0 }             I        $    3    I     	  d T 4  p  "p
 P P
     
 `       Ӕ           	  d T 4  p  "p
  p      Е          .  	  d T 4  p  "p
   Җ          
     > !    E 5 ! 4  E 5 
 
d 
2p
 
RP"p
  ! !d 4
 r
p"p
              46 @           @
 H    
                 И          ƙ @
     M
    `
      d
 4	 
Rp"p
         ; !    C / !   C M 6 ! 
 C M 6 !
 
t T
  C /  t
 d T 4
 R!   `  |7 !     d7 ! 
   d7 !
 
t T
 `  |7  R
`0
 
2P"p
 @  d
 4	 
Rp"p
 @               7 @           p
 8   ` ʡ      p
     }
    
     
 
RP"p
 p ! !d 4
 r
p"p
 p               H8 @           
 H     n      
     
    
     
 
2P"p
   d
 4	 
Rp"p
                8 @           
 8         : 
     
    
     
 
RP"p
  "
 "t d 4 
r"p
                P9 @            
 H    _       
     
     
      4+ ( p  "p
  P
     0
 0 n          h 4. , p  "p
 0 
     
 P          ˧       h 4. , p  "p
        .    ;     T 
 
RP"p
  (
 (d  4 r
p"p
                :             : @           
 H   @           
 H     Ŭ     =      
     
    
     
    
       "p
  
     0
     P
  Ү     ޮ              
   "p
  p
 0 s     
 
4 
p d# 4"   p  "p
 @ 
     
     
    
 P          ñ    ֱ      4" 	  p  "p
 @ @                   
 
B	p`P0  "p
   R
p`0"p
               < @           0
 X           
       H     W    h     w 0
     @
    o
      T 4 Rp` dC 4B @ p  "p
   =     L    _    	                	     48 	6 p  "p
   0 u         E    h    w        
 
RP"p
 0    "p
 0               $> @            
 H         8  
     -
    C
      dC 4B @ p  "p
 ` P
     p
    
    
    
    
    
 @              Y        4    C    Y     
"  !   н  8? ! t  
T 4 н  8?  `  *
 *h %t !d T 4    "p
  p K      *
 *h %t !d T 4    "p
  0
        < !     ? !	 	t  4   ?    !     | ! t 
T 4   | !     X@ ! t d 
T 4   X@     	  d T 4  p  "p
 @ P
 p
 
 @          s      	  d T 4  p  "p
 p  C     [    #    z  d 4
 rp$
 $T  4 
	p`"p
  
       &  d
 4	 Rp"p
  
     
 P            d
 4	 Rp"p
   "     8    F )
 )tI %dH !TG 4F B 	  "p
 @ 
     0
    P
    p
    
 
    
    
    
    0
 p                                                3 	   Y !    O B !
  	 
 
d T  O B 	 	p0 0"p
   P
 p
 
 P u                    0"p
  
 
 
 
 0
       # A    O m    {           
 
4
 
r` h 
4
 
p d
 T 4 rp,
 , x h 
4 
p 
R0"p
          !   p   !  d 
T 4 p    
R0"p
    N     v  
R0"p
 P       & !     $ !  t 
T 4   $ !     ? ! 4    ?  t 
d 4  
R0"p
    .     V (
 (h $d  T 4  p  "p
  
 
              
 
B	p`P0  "p
   r
p`0"p
               F @           
 X           p
            '    8     F 
     
    
     
 
B	p`P0  "p
   r
p`0"p
               F @            
 X           
     P x                
     
    ?
      h 0' 'h #T 4 	p`"p
  P
  l       d 4  p  "p
 P p
 P      < !k k ;x
  
  G !   y   
 G   	 h  !` `     H !
 x	  nh
 9    DH " "  
 !   		 P  pH    ٸ &  x
 h  !  h # ]' H M M G ; 5 0  	 x
  -
 -h (t $d  T 4    "p
 0 
 * *     3+ !   + + I !  t 
d T + + I !   - - I !
    d 
T 4 - - I  
p  !   3 3 I !  t 
d T 3 3 I  
0 4	 
Rp"p
  6 O6     k6  d
 4	 
Rp"p
  6 6     7  d
 4 rp" "4 
p`P"p
   
 
    
    
    0
    P
    p
    
    
    
 8 $9     :9    `9    v9    9    9    :    :    9:    E: 	   : !   : #;  K !
 
 T : #;  K  Rp`0 h r0"p
 0 
 0< <     <  d T
 4	 Rp"p
  = >     Q>  h d 4
 rp"p
  0
 p> >     ?  h d 4
 rp"p
  P
 @? ?     ?  d T
 4	 Rp"p
 P  A ^A     A  h d 4 rp"p
  A B     ?B  h d 4 rp"p
  B /C     _C  d T
 4	 Rp"p
   
 0D D     D  d
 4	 Rp"p
 @ 
 0E E     E  d
 4	 Rp"p
  
 p
 @F F     F  d
 4	 
Rp"p
  
 
 F G     G  4 Rp"p
 0
 
 H H     H ) )t %d !T 4 	"p
 p
 
     
 
    0
 H 5I     RI    ^I     jI I    I    I    I  bP0  "p
 
 1 1hN ! p`0  "p
 
             (O       !      O -   -   1       O ;   ;   ?      N K   K   N      N 	   Л X  
 X   	   Л P  
 X   	   Л @  
 X   	   Л 8  @
 X   	   Л 0  0
 X   P
 p
    
    
    
    
    
    0
    P
    p
 	   
    
    
    
 
   
                  
    
     
     
    @
    `
    
    
    
    
     
     
                  
    
     
    0
    P
 #   p
    
 %   
    
 '   
 (   
 )   0
    P
    p
 ,       ,       .    
 /   @
 0   `
 ,   
 ,   
 3   
 ,   
 5    
 ,    
 7   @
 8   `
 9   
 ,       ,       <   0
 =   P
 >   p
 ,   
 ,   
 A   
 ,   
 C   
 ,   0
 E   P
 F   p
 G   
 ,   
 ,   
 J       J       L   `
 M   
 J *K     fK    K    K    K    K    K    L    9L    HL    kL    L    L 	   L 
   L 	   L    M    M    4M 
   ?M    bM 
   M    M    M    M    LO    _O    rO    O    O    O    O    O    P    P    HP    iP    P    P    P    P    P    Q    Q    UQ    R    R "   R    R #   S $   $S #   9S    LS %   `S &   qS %   S    S '   S (   S )   T *   (T )   ]T (   iT '   xT    T +   T ,   }U -   W ,   5W 2   HW ,   jW 3   yW 4   W 3   W ,   W 5   W 6   W 5   X ,   ?X 7   UX 8   hX 9   sX :   X 9   X 8   X 7   X ,   "Y ;   Z ,   Z @   Z ,   Z A   Z B   [ A   [ ,   +[ C   ?[ D   P[ C   [ ,   [ E   [ F   [ G   [ H   \ G   9\ F   E\ E   T\ ,   \ I   \ J   J] K   ^ J   _ ,   U_    _    _    _ 0
     >
    R
    u
    
    
    
     N
    b
    
     
 !   
     
     
 .   
 /   
 0   
 1   
 0   
     
 <   
 =   
 >   
 ?   
 >   &
     
 L   
 M   3
 N   V
     % %t !d T 4    "p
 @
 ` `     `    a    -a    a    a $ $d0  T/ 4. * p  "p
 p
  
     @
     `
     
     
     
     
      
      
     @
     `
     
     
     
     
      
      
 Pb b     b    b     b    b     c    c     @c    Lc     mc    |c     c    c     c    c     'd    3d     Qd 	   `d     d 
   d     d d     d    d     Ae    Me     e 
   e     e    e     f    f     Af    Mf     ]f !   f f X !     T  4 f f X !	 	T    4 f f X !  4 f f X  bp`     T 4
 
R	p`"p
 
 `
     @
 h h     i    i     $ $d  T 4  p  "p
  
 
     
 `i i     i    i     i !   n n Y !
 
d 4 n n Y 
 
2p!   pn -o Y ! 
 pn -o Y  T 4 rp`!   o o Z ! 4 o o Z  d T 2p
 
RP"p
 0
  t d
 4 "p
 0
              \Z @           
 H           
     pp p     p    p 
     
    
     
 
RP"p
 `
  t d
 4 "p
 `
               [ @           @
 H            
      q 9q     >q    nq @
     M
    `
      4 rp`P 4 p`P"p
 
 p
 t t     u    T
 4
 
R	p`"p
 
 0u u     Yv      T
 4
 
R	p`"p
 
 
  w |w     )x !   @x ]x H\ ! d @x ]x H\  T 4 2p!   t Py my  ! t Py my  !   t p{ {  ! t p{ {  
 
RP"p
  
 ? ?= 7> 2? -x@ )hA  
p	`0  "p
  
 
            (]             ] 	   Л   
 H   	   Л   
 H   
 
    
    
    0
    P
    p
    
    
    
 	       
   
    
 
   0
 
   P
 
   p
    
 
   
    
 
   
    
 
   0
    P
 
   p
    
 	                     	       	                     } ~     ~    ƀ    ހ        G                          	    
       3    b 
   z         
    
   3    b 
       ;    j 
            
       ;    j 	   =    f        ֏     G    p             Q 
   i        ԑ 
     
    
     
     
     (	 (d; $T9  48 6 	p  "p
 `
 
 0
    P
    p
  d     s        	             /    d T 4 p"p
 
 
 
    
    
 
 p      ˔    ޔ                Y     &	 &T "4  	p`  "p
 
 0
     P
     p
    
    
    
    
    
     0
 Е      &    5    K    ^            Ӗ            ^    i          
 
B	p`P0  "p
 
 # #4 p`"p
 
             b @           
 X   P
 p
           
                F     U    h    {      
     
    
     
 d
 T	 4 2p/ /
 *x &h "4#  
p`P  "p
 @
             
 0
    P
    p
                                    
                        W     %
 %t !d T 4 "p
 p
  B     Q    )  d= 4; 8 p  "p
 
 
 
    
    0
    P
 p +     F    r            2    P    T 4 
R	p`"p
 
 p
 p       G G / * %  x h 4  p  +
 +d% 'T# #4"  
p  "p
  
 
 
    
    
    
    0
 @      ¨    6    E    l        w        ت !   0 M pe ! 4 0 M pe  d p   4 ) )x %h !d T 4 p"p
 0
 P
 `        
  T 4
 
R	p`"p
 `
 p
  i      #
 #h 4 
p	`P"p
 
 P ϰ     R             $
 $T 4 R
	p`"p
 
 
 
    
    
 0      Y    z    7    d  4 R
p`P"p
 
 
 0
    P
                    ( (h $T  4 
	p`"p
 @
 p
 
    
  6             u    z $
 $T  4 
	p`"p
 p
       ʹ    &         %
 %4 r
p`P"p
 
 0
 P
    p
    
  >         D         %
 %4 R
p`P"p
  	
 
 
    
       9        ,    3  0"p
 P	
 
 0
 P
 p
 
 
 
 
 P                      =    K i    w            r0
 
RP"p
 	
 ! !d 4
 r
p"p
 	
             i @           0
 H   
                 `          Y 0
     =
    P
     !    k lj !   k lj  4 Rp`P
 
RP"p
 	
  rp`0"p
 	
               j @           `
 H    )     M `
     m
    
      	  d T 4  p  "p
 	
 `                
 
RP"p
  

  rp`0"p
  

               xk @           
 H    I     m 
     
    
      	  d T 4  p  "p
 P

                 !      Y ! 
    Y !   x 0  Pl ! x 0  Pl  h 
   d 4
 
p"p
 

  
      
     P
   #     A    M     s         !    - l ! t  - l  0 4 
p	`P"p
 

 p
  *      
 
RP"p
  
 '
 't "d 4
 r	"p
  
               hm @           
 H     {      
     
    
     !        n !   d
   n !        n !   d
   n  R
pP0] ]d T 4 2p8 8 3x /h +d- 'T, #4+ $ 
p  "p
 P
 
 
 @           8
 8 2 x h 0 d
 
4 
R	pP!     4o !      o !  
 d   o ! T   o ! x h   4o  	p0  ! d
 ` \ Xo 
 
4 
R	pP3 3 .x	 *h
 &4   
p	`P  "p
 
              
  
                                                  
       ` <    [    } !    4 Pp ! x	  t d p4 h
  4 Pp   P
 
B	p`P0  "p
 
 # #4 p`"p
 
             p @           
 X   @
 `
           
                F     U    h    {      
     
    
      4 p
 
RP"p
 
 Z Z? R@ JA BB =C 8D 3xE /hF +d '4  
p  "p
 
 
            q '   /   2      q 	   Л   
 H   	   Л   @
 H    
  
    @
    `
    
    
    
    
     
     
 	       
   @
    `
 
   
 
   
 
   
    
 
    
     
 
   @
    `
 
   
    
 
   
    
 
    
     
 	                     	                     	       !       "       	       $       %       	       '   p
 '   
 )       *       )       ,       )       .       	       0       1                  :    R    C    [        )        ! 	    
        9    h 
            
   	 
   B    z 
   %    ^     
           
  
   %     ^       
             
 	    '    (    )   < '   t 	               =    u  
           A @
     M
    `
     
 0   
        T 4 
R	p`"p
  
 
       	 	     	  B  & &t "d T 4 
	"p
 `
  
  
 @
 `
 
                   T  T 4 2p`1 1d )T $4 r
p"p
 
 
 
  z     ;    m `
 `d T
 4	 2
p* *TB &4A : 
	p`  "p
 

 
 
     
     
    @
 P                      ,                T 4 
R	p`"p
 @

 `
 
 0      L    [   d d B = 8  x h 4  p    x xh ( #  
 
 
t 4 Q Q K . ) $  x h	 
  4 p`P8
U8h 1t #d 4 S
P  -
U-h & t d 4 SP  !   ' ' ? ! 4  ' ' ? !   P( ( tx !
 
d 4	 P( ( tx >
 > 9 4t +T ! !4 
p`P"p
  
 
 
    
 + +     ,    ,    L-    T- k kd T 4 2pb
 b4 h d T
 p
 4 t d
 T	 R d
 4 rp h 
4
 
p
 d 4
 T R
p d 4 rp
 
RP"p
 P
 ! !d 4
 r
p"p
 P
             y @           
 H   
                 0@ w@     @    )A 
     
    
     !   @A YA `z !   
  4	 @A YA `z ! 
 4	 @A YA `z 
 
d 
Rp
 t d T
 4  0
 d T
 4 rp x h 
4 
rp! !h 	0!   J KK lj !  J KK lj 7 7 2 -x )h %47 0 p
`P  "p
 
 pL N     yO }P    P    rQ    R    ,R AR    SR    R    KS    S    S    T    T 4T     U    U    EV    TV    `V    V    V 7 7 2 -x )h %47 0 p
`P  "p
 
 
 
    0
    P
    p
    
    
    
    
 PW Y     YZ ][    [    R\    \    ] !]    3]    ]    +^    ^    ^    ^    ^ _    _    `    %a    4a    @a    ka    za 7 7 2 -x )h %47 0 p
`P  "p
 
 0b ~d     9e =f    f    2g    g    g h    h    _h    i    i    i    i    i i    j    k    l    l     l    Kl    Zl 3 3h /d! +T  '4  
p  "p
 
 
 0
    P
    p
 l l     m    n    n    n    /o  T 4 p`"p
 @
 
 o 1p     p 6 6 1x -h )t %d !T 4  	  "p
 p
 
 p q     r 
 t d T 4 \ \d T 4 2p!   t ]v X !  t ]v X : :   x h 4 p> >   x h 4 pF F A <  x h d 4 p, ,x 'h d T 4
 rpe
 ed t	 T 4 2
 t d T 4 
 
4
 
rp h t d T
 4 $ $d  T 4  p  "p
 
 
        p !      !d dd T
 4     h p# #T 4 
	p`"p
 
 
     
  ъ     +     % %t/ !d. T- 4, *   "p
 `
 0
 P
    p
   >     M o    ӌ         (
 (d $T  4  
p  "p
  
 
     
 
    
 `          ߍ          &    C    a 
 
2P"p
 `
  4	 
Rp"p
 `
             , @           0
 8   
                  G     y     0
     =
    P
      4 p
 
2P"p
 
  4	 
Rp"p
 
             Ԃ @           
 8   `
                   W          
     
    
     !   0 j  !   j Δ p !# #  j Δ p ! 4 0 j  
 
T 
	p`!     Z  !   Z  ̃ !# #  Z  ̃ ! 4   Z  
 
RP"p
 
  R	p`P0"p
 
 / &p`0"p
 
               `             L @           p  H   @           
 h           P                   =      |            & a    ֜ 
     
    B      }            d
 4	 Rp!     `z !   
  4	   `z ! 
 4	   `z  d
 4	 
Rp"p
 
   &      
 
RP"p
 p
 3
 3hb /d +4  p  "p
 p
 
              *   ,   /       	   Л P   H   	   Л 0   H         @    `                           
   @ 
   `        
        
        
          
   @    ` 
        
        
          
   @    `                          !    "        $   0 %   P    p '    (           *    *           -       .              ȡ       L    d            @    p    ƥ    ޥ    ӧ 	    
   Ĩ    ߨ     
       M    | 
       ͫ     
       W     
       خ     
       X     
       د     
       X         !   @ "   O #   p "        $   E %   T &   u %        '   ֲ (    )    (    *   F +   a ,   G *        
           R     ɹ 
           U                -   0     
 
RP"p
 
 3
 3hb /d +4  p  "p
 
 
             P *   ,   /      < 	   Л P  P H   	   Л 0  	 H   @ `                               @    ` 
    
           
        
          
   @    ` 
        
        
    	     	 
   @	    `	 
   	    	                         	 !   
 "   0
    P
 $   p
 %   
    
 '   
 (   
        *    *   0        -       .             + ^    y         E    ]        Ӿ     	    
           y 
       @    o 
            
       J     
            
       K    z 
            
       K    z     !   @ "   O #   p "        $   E %   T &   u %        '    (    )    (    *   F +   a ,   J *        
           U      
           X 	     	    	     ] -   p     B B x h d T 4 p h R0   T 4 	p`"p
 `
 p       m m4 2pD D !x h d T 4 p!	 ! x h ( 0  "p
 
                0 )     +                  8 T     1 14$ ! p`P  "p
 ` 
 
 
    
     
 p                      =  bP0  "p
  
 " 
p`0"p
  
                @             X                    =     7E7h 3t ,d %4 C 
P"p
  
 P     p   
                4 p`P&
U&h  t d 4 SP   
R0"p
  
         4
 
Rp"p
  !
                 +                           #
 #h 4 
p	`P"p
 P!
 
 0
    P
    p
           H         !   0 \  ! t 0 \   h 0( (h $T  4 
	p`"p
 !
 `      r        3    <  d 4
 
p"p
 !
 
 
 `             d 4
 
p"p
 "
            % #
 #4 
p	`P"p
 p"
  \             ^    y     #
 #4 
p	`P"p
 "
 
 
        0  L             J    e    q  
  T 4 	p`"p
 "
  ,             a    t      
  T 4 	p`"p
  #
  <             k    ~      d 4 2p 4
 
Rp"p
 @#
 P     p         ` ~                  % %t !d T 4    "p
 #
  _     k           d 4
 
Rp"p
  $
       `                 4
 
Rp"p
 0$
      0     P    p         @	 ^	     q	    	    	    	    	    	  h 
4 
Rp
 t d
 T	 4 R 4
 
Rp"p
 $
              0    P     p 
 
    
                "     +    4     =  4	 
Rp"p
 $
                      0    P    p ` {                	        /    <     I  
R0"p
  %
 `       ' 'd1 #T0 4/ * p  "p
 P%
               0    P                           1    d     ' 'd1 #T0 4/ * p  "p
 %
  d     s                        $     
 
RP"p
 %
 $
 $d 4 r
p"p
 %
                @           p H            X      p     }         
 
RP"p
 %
  R	p`P0"p
 %
 / &p`0"p
 %
                             @           ` H   @            h           @                  M              	    6 q              2     m         
 
RP"p
 &
 3
 3h /dA +4@ 8 p  "p
 &
 W   W   Z       	   Л    H            0    P    p                     
   0    P    p                        0    P    p                        0    P    p                  !    "   0    P    p     &        (    )    *   0    P ,   p     .    /    0           0 3   P 3   p     6        8    9    :   0    P    p     >        @    A    B   0    P    p E    E        H           0 K   P L   p M        O        Q    R   0 S   P    p U                  X       Y       0                          4    ?    b                     	           j 
            
            
       4    H    Y                    	     ,     U     a     p                    $!    8!    I!    r!    "    5"    H"    W"    z"    "    "    "    #    !#    3#    n#    #    #    #    o$     $ !   $ "   $ #   $ "   $ !   $     %    ^% $   q% %   %    % &   % '   % &   &    & (   & )   & *   & +   ' *   ?' )   K' (   Z'    ' ,   ' -   ' ,   '    $( .   :( /   M( 0   c( 1   ( 0   ( /   ( .   (    =) 2   S) 3   x) 4   ) 5   ) 3   *    \* 6   p* 7   * 6   *    + 8   , 9   (, :   :, ;   ], :   , 9   , 8   ,    , <   - =   %-    `- >   t- ?   - >   -    _. @   u. A   . B   . C   . B   . A   . @   /    s/ D   / E   / F   / G   / E   V0    0 H   0 I   0 H   0    2 J   k3    3 K   3 L   3 M   3 N   3 M   $4 L   04 K   ?4    `4 O   w4 P   4 O   4    R5 Q   e5 R   x5 S   5 T   5 S   5 R   5 Q   5    )6 U   C6 V   T6 U   6    B7    z7       X        
 
RP"p
 &
 . .h ! p`0  "p
 &
             (    Л    @ H                         7 ;8     S8    8    8    n:    : @     M    \     
 
RP"p
  '
 . .h ! p`0  "p
  '
                 Л     H   p                     ; [;     s;    ;    <    =    =               
 
RP"p
 P'
 ) )h % !t 4 	"p
 P'
              Ф 	   Л h   `  H                        @       > U>     >    >    	?    ?    ?     @ `      m     |      
 
RP"p
 '
 ) )h % !t 4 	"p
 '
               	   Л h     H                            P@ @     @    @    9A    NA    B     HB            !      4
 
Rp"p
 '
  !     @! `! B B     B    B     B B    B n n4 2p bP0  "p
 '
 - -h )d %4 p"p
 '
                	   Л 8   ! X   pD E     @E !     !    !     3 3x$ /h% +dT 'TS #4R L 
p  "p
 (
 !      "      "    @"    `"    "    "    "    "     #     #    @#    `#  G wG     G    G    H    'H    YH    qH    H    H    I    I    iI    vI    I 	   I    K 
   'K    sK    K    M    M    }N    N     N 5 5x 1h
 -4'  p
`P  "p
 (
 # #    #    #  O OP     qP    P     Q    S    :S D D ? : +x 'h d T 4 p^! ^ X R J	 B
 : 5 0
 +x 'h #d) #T' #4& #  p     h b  *
U*h &t "d 4 S
P  "p
 `-
  $ ^ ^     ._  d T 4 p 4 p`P 4  
p	`P  7U7h
 -! &  d 4 S	 P'
 'T 4 r
	p`"p
 -
  $     @$    `$    $    $    $    $     %     %  g 0g     Dg    Ng    rg    ~g    g    g    g    g    g 
 t
 d T 4
 r d	 4 Rp d T 4
 Rp d T
 4	 Rp d 4
 
p"p
 .
 @%     `%     % l m     ;m    m    %n (
 (d2 $T1  40 * 
p  "p
 `.
 % %    %     & @n n     n n    n    n    no    {o    o !   o #p x !
 T  x h	  d o #p x 
 
4 
 p  /
 /d1 +T0 '4. ( 
p  "p
 .
  & @&    `&    & r s     "t    ot    t    t    au (
 (d $T  4  
p  "p
 @/
 &     &     & v w     
x    -x    x     x *
 *h
 &4&  
p	`P  "p
 p/
  ' z !|     }  4 Rp"p
 /
 @'      ' } ~    #~     + "Rp`P0"p
  0
 p'     '    '    '    '    (    0(    P(    p(    (    ( @~ w~    ~    ~    ~    ~    ~ 	    
       !    *     3    T 4 	p`"p
 00
 ( (    )    0)    P)    p)    )    )    )     * 	   0* 	   P*    *    * 
   *           G    S    q    }            ˀ    ׀ 	    
       %    1 
   ?    V  d
 4	 
Rp"p
 `0
  +      +    @+    `+    +    +    +    + p             ā                &     J  
R0"p
 0
  ,      ,    @,    `,               Â    т    d6 44 2 p  "p
 0
  -     ,    ,    ,    ,  	          ?    N    h    t        ˄     ) )h# %4P H 
p	`P  "p
 0
 0-     P-    p-    -    -    -    -    .    0.  '     2    e    ݅        
    1    n                  :    [          އ                          ,	 ,4K B 
p`P  "p
 p1
 P/     P.    p.    .    .    .    .    /    0/ `                  Y    h                        $    ~        ܋        T 4 	p`"p
 1
 /   I      &
  p
`P0"p
 1
 / / Ѝ C     g    e  d
 4	 
Rp"p
 2
 /         d
 4	 
Rp"p
 2
  0 0      × % %t !d T 4    "p
 03
                '  d
 4	 
Rp"p
 `3
 0 V     Ś !   P ^ h !   ^  @ ! h	 ^  @ !F F ( #  	 4 P ^ h  x 
 0 04$  
p`P  "p
 3
 `0     0     0     0    0     1     1  J     v                   !    7    M    c                  
 
2P"p
  4
 '
 'h 
p`0"p
  4
               	   Л     1 8           @1    `1     0 c             #    ޣ      1     1    1     s s k c [ S K C > 9x 5h 14< !2 p`P  "p
 P4
 1 1       =     
 
RP"p
 4
    "p
 4
                @           1 H     #     x 1     1    2      d 4 p"p
 4
  2       ά ! d2   P 
 T1 "x h 43 , 
p  )U)h  t d 4 S	 P:U:h
 6 (t d 4 S	 P 4 p`P 
 "p
 4
 @2  N     ^  d 4 p"p
 5
 `2 2    2    2    2     3     3    @3    `3    3 	   3 
   3    3     4     4    @4    `4    4    4 p          ڶ                1    =    T    ^ 	   h 
   v         
                   
      d 4
 p#
 #t
 d T 4
 r"p
 @5
 0 h      !    % 5 ! 4  % 5 (
 (d< $T;  4: 4 
p  "p
 5
 4 4     5     5                           4  BP0  "p
 5
 !	 !t2 d1 40 .   "p
 5
                 Л `  `5 H   @5                    5     5 н     5     m          `5     n5    5    5    5     / /x h    d 4 2p R0"p
  6
 6 P        bP0  "p
 `6
 $ $d  4 
p"p
 `6
               Լ              	   Л 8    7 X   	   Л @   @6 X              6 6 6                  7    7    7    7    8    08    P8    p8        W            W 	   f     
                    C    R    p 
                     @6     N6    f6    z6    6     7    37    @7    \7    i7    ~7      2pP0"p
 6
  4 
r	p`"p
 6
               @           8 H           8      9     d    }      8     8    9      4&   p`P  * *h" &G p`P0	 d! T  4  p   T 4 rp`$ $d  T 4  p  "p
 6
 9 09    P9  9             <    K !      ! d    
 
4 
 p  $ $d  T 4  p  "p
 6
 p9 9 9 `                   T 4 	p`"p
  7
 9     9     :    0:    P:       ;    G                 0 04$  
p`P  "p
 P7
 p: : :               P &	 &T' "4%   	p`  "p
 7
 0;     :     :    ;    `;    ;    ;           #    K    W                             !     L !
 
h d   L  T 4
 Rp!       ! x 
h d
      T
 4 rp d
 4	 
Rp"p
 `8
 ; p      	  d
 4	 
Rp"p
 8
 P
         
 
RP"p
 8
 ! !4 p"p
 8
               @ 	   Л 8   ; H          ;     ;    <     . .x *h &t "d T 4 
	"p
 8
  b  )      ` `4
 d
 T rp
 
RP"p
  9
 5
 5x# 1h$ !J p`0  "p
  9
    
         0 	   Л    = H   0< P<    p<    <    <    <    <    =    0=    P= 	   p= 	          =    = 	                      x        n            E     	    
   X 	   d    |     
            / 	                    =     =    (>     i
 i4
 t
 d T rU U9 M: E; @< ;= 6> 1x? -h@ )t %d !T 4  	  "p
 :
 @>     `>    >    >    >    >     ?     ?    @?    `? 	   ?    ?  {                     /    E    Z    s     	    
    	                                    <    K    W     f    h R0 P0  "p
 :
 Z ZG RH JI BJ =K 8L 3xM /hN +d '4  
p  "p
 :
     &   )       	   Л   D h           ?     ?     @     @    @@    `@    @    @    @ 	   @ 	    A     A    @A    `A    A    A    A    A    B    0B    `B    B    B    B    B    C    0C    PC    pC    C    C    C     C !   D "   0D    PD     pD     D     '   PE '   pE `      :    R            &    M    e         	    
   
        a 
           &    M    e                        5    a    p    ~ 	           Q    _     &                 # 	                   X    p                        3     L !   a "   z #    "    !                                 	 $   . 	    = 	    L 	    [ 	 %    	      	  	     D '   D (   D '   E )   %E '   3E     #%#
 t d 4
 #rP  "p
 :
 E 	 	     	   	p`P0  "p
 ;
 E     E    E    F    0F    `F    F  	 A	     p	    	    	    	    	    	    ;	    Y	 ( (d $T  4  
p  "p
 p;
 F     F    F      G p	 	     	    z	    	    	    	     '	  2P%
 %4 
p`P"p
 ;
  G     @G    pG    G    G     H    0H    PH    H    H 	   H 	   H P	 ~	     	    Z	    n	    	    	    	    	    	    	 	   5	 
   A	    		  d 4 
Rp"p
 ;
 @I      I 		 
	     !
	    -
	     # #h 
4 
p
 
RP"p
  <
 0 0x ,h 9 p`0"p
  <
             d 	   H   I H   pI            I    I         	 	     	    	    2
	    ?
	    
	    
	     8	 I     I    "J     O O G ? : 5 0x ,h (d3 $T2  41 * 
p  "p
 <
 PS     pS    S     S    S p	 	     g	 	     	    	    	    	     	    	    )	    ;	  P0  "p
 `=
 $	 $d:  49 4 
p  "p
 `=
              	   Л h   J h   @J            `J             K     K 	 	    	    K	    Y	 f	    }	    	     	 J     J    J    J    J    J    J      4
 
Rp"p
 =
 @K 	 %	     	 !   	 	 < !# #h G E TD 	 	 <  > 
p`0  0 0x ,h	 (d $T  4  
p  "p
 =
 P	 	     >	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  "p
 =
 	 V	     l	    	    	    	    	    	    ?	     	    W	 	   8 	 
   #!	    !	    %	 
   %	    &	 
   &	    &	    '	    '	     '	    K'	    v'	     '	 0 0x ,h	 (d $T  4  
p  "p
  >
  M  (	 (	     *	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  "p
 P>
 `*	 &+	     <+	    R+	    h+	    +	    +	    ,	    -	    -	    '.	 	   /	 
   /	    0	    4	 
   4	    4	 
   5	    5	    5	    5	    5	    6	    F6	     q6	 0 0x ,h	 (d $T  4  
p  "p
 >
 6	 7	     8	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  "p
 >
 `K     K    K    K    K     L     L    @L    `L    L    L 
   L 
   L 09	 9	     :	    ":	    8:	    Q:	    :	    ~;	    ;	    <	    <	 	   =	 
   >	    k?	    ~C	 
   C	    C	 
   D	    D	    D	    D	    D	    D	    &E	     QE	 !   E	 F	  ! 4	 E	 F	  
 
d
 
Rp
 
4	 
Rp
 
rP"p
 >
 ;
 ;x/ 6h0 %b p`0  "p
 >
                                       l 	   H   N X   	   H    N X   	   H   @M X    M         M    M    M    M                  0N    PN 
   pN    N    N                   O     O    @O    `O    O F	 =G	     NG	 G	    G	 G	    H	    H	    H	    H	    H	    H	    vI	    I	 	   I	    J	 
   ^J	    oJ	 
   J	    J	    "K	 
   .K	    EK	    sK	    K	     L	    L	    L	    L	     M	    UM	    bM	    M	    M	    M	    N	    N	 @M     MM    tM     
N    N     N    N     u uA mB eC ]D UE MF EG @H ;xI 7hJ 34 # p`P  "p
 @
 O     O    O     P     P    @P    `P    P    P    P 	   P     Q     Q    @Q 
   `Q 
   Q    Q    Q    Q     R     R pN	 O	     O	    dP	    sP	    P	    P	    P	    P	    Q	    Q	    AQ	    SQ	    .R	    ?R	    R	 	   R	 
   R	 	   R	    WS	    S	    S	    S	    _U	 
   W	    W	    
\	    \	    f\	    x\	    \	    \	    \	 
   \	    /]	    A]	    e]	    w]	    ]	    ]	     ^	  4	 
Rp"p
 C
 @R     `R    R    R    R    R     S                      ^	 ^	     ^	    ^	    ^	    ^	    ^	    ^	    _	 
 
2P"p
  D
  4 
	p`"p
  D
                @            S 8   _	 2`	     `	  S     -S    HS     O O G ? : 5 0x ,h (d3 $T2  41 * 
p  "p
 0D
 `	 Za	     c	 d	     1d	    =d	    `d	    rd	     d	    d	    d	    d	 O O G ? : 5 0x ,h (d3 $T2  41 * 
p  "p
 `D
 0e	 e	     5h	 [h	     qh	    }h	    h	    h	     h	    h	    h	    	i	 5 5xx 1hy -4  p
`P  "p
 D
 S T    0T    PT    pT    T    T    T    T    U 	   0U 	   PU 	   pU    U 
   U    U    U 
   U    V    0V    PV    PV    pV    V    V    V    V    V    W    0W    PW    pW    W     W     W     W     X     0X     PX     pX     X (   X (   X *   X *   Y *   0Y    PY    pY    Y 
   Y 	   Y 2   Y    Z    0Z    PZ    pZ Z pi	 i	     i	    j	    /j	    Vj	    nj	    j	    j	    j	    j	 	   k	 
   k	 	   <k	    Rk	 	   l	    l	 
   l	    m	    @m	    nm	    m	    m	    m	    n	    n	    n	    =o	    o	    p	    ^p	    jp	    p	     !q	 !   8q	     q	 "   q	     q	 #   q	     r	 $   .r	     r	 %   s	     `s	 &   ls	     yt	 '   t	 (   w	 )   w	 *   x	 +   x	 ,   y	 -   Jz	 *   Xz	 (   z	     {	    {	    -{	    <{	 .   K{	    Z{	 /   i{	    q{	 0   {	    {	 1   {	 
   {	    {	 2   |	 3   #|	 2   +|	 	   3|	 4   |	    |	 5   |	    |	 6   N}	    \}	 7   }	    }	 8   ~	  BP0  "p
 D
 . . )x %h !t d 4    "p
 D
               0 	   Л (   Z H              0[    P[ P~	 
	     	 Z     Z    Z    Z    [    [    [      BP0  "p
 D
 . . )x %h !t d 4    "p
 D
                	   Л (   p[ H              [    \  	 ڀ	     	 p[     ~[    [    [    [    [    [     1 1 , 'x #h T 4  p`  "p
  E
 0\ 	 	     	  BP0  "p
 PE
 . . )x %h !t d 4    "p
 PE
               0 	   Л (   P\ H              \    \ 	 ]	     @	 P\     ^\    p\    \    \    \    \      BP0  "p
 E
 . . )x %h !t d 4    "p
 E
                	   Л (   ] H              ]    ] p	 -	     	 ]     ]    0]    D]    f]    s]    ~]      BP0  "p
 E
 . . )x %h !t d 4    "p
 E
                	   Л (   ] H              P^    p^ @	 	     	 ]     ]    ]    ^    &^    3^    >^      BP0  "p
 E
 . . )x %h !t d 4    "p
 E
                	   Л (   ^ H              _    0_ 	 ͉	     	 ^     ^    ^    ^    ^    ^    ^     !   	 W	 ` ! d 	 W	 `  t	 T 4 2 4	 
Rp"p
 F
  	 	    F	    Q	    \	    g	    r	     }	 / /h2 +dn 'Tm #4l f 
p  "p
 @F
 P_ p_    _    _    _    _    `    0`    P`    p` 	   ` 	   ` 	 	     	 +	    h	    	    	    ߍ	    	    	    9	    \	    y	    	    	 	   3	 
   @	 	   	    ˒	 	   ڒ	    	    -	    b	 $
 $T  4 r
	p`"p
 G
 	 ݓ	      4 r
p	`P"p
 @G
 ` 	 	     $
 $T  4 r
	p`"p
 pG
 	 	      4 r
p	`P"p
 G
 	 	     Y Y K 'x h d T 4 p, , 'x #h
  
	p`P0"p
 G
 	 L	     X	    	     	 	    ڣ	     	  d T 4 p"p
  H
  a  	 J	     	 / /x' *h( %4[ R 
p`P  "p
 PH
  a P	 	     	 . .x *h &T3 "42 * 	p`  "p
 H
 @a 	 	     ٭	 + +x! 'h" #TO 4N F 	p`  "p
 H
 `a @	 	     	  d8 47 4 p  "p
 H
 a P	 I	     W	 '
 'T #4 
	p`"p
 I
 a     a 0	 	     	    4	  h  0  "p
 pI
 a 	 ϶	     	 8 8& 3x' /h( "S p`P0"p
 I
 0	 	     ٷ	    	     	    	     d	    x	     ǽ	    Խ	     \	    j	     	    	     	    Ӿ	    	    	     	 . .x *h &t "d T 4 
	"p
 I
 @	 ɿ	     y	 
 
RP"p
  J
 5
 5x# 1h$ !J p`0  "p
  J
    
          	   Л    c H    b @b    `b    b    b    b    b     c     c    @c 	   `c 	          c    c 	       	 	     )	    	    H	    	    4	    ^	    	    	    	 	   Y	 
   	 	   &	    >	    	 
   	    	    	 	   W	    a	    p	    z	    	 c     c    d      4 Rp`P"p
 `J
 	 8	     	  4 p`P"p
 J
 0d     Pd 	 	     `	    	 
 
RP"p
 J
 0 0x ,h 9 p`0"p
 J
              	   H   d H   pd            d    d          	 	     	    	    B	    O	    	    	     
	 d     d    "e     9 9
 4 /x +h 'd) #T( 4& " p  "p
 J
 @e     `e     e     e    e    e @	 	     	    	     _	    	     	    9	    I	    	    	     	     }	 !   	 	 T !$
 $h $ , T+ 4* 	 	 T  % 
	p` d2 41 . p  "p
  K
  f p	 	     	 
 
rP"p
 PK
 ;
 ;x3 6h4 %j p`0  "p
 PK
             <             (              	   H    g X   	   H    g X   	   H   @f X    f         f    f    f    f                  0g    Pg 
   pg    g    g                   h     h    @h    `h    h 	 =	     N	 	    	 	    	    	    	    	    	    	    v	    	 	   	    	 
   ^	    o	 
   	    	    "	 
   .	    E	    s	    	     	    	    	    	     	    U	    b	    	    	    	    	    	 @f     Mf    tf     
g    g     g    g     u uC mD eE ]F UG MH EI @J ;xK 7hL 34 # p`P  "p
 K
 h     h    h     i     i    @i    `i    i    i    i 	   i     j     j    @j 
   `j 
   j    j    j    j     k     k p	 	     	    d	    s	    	    	    	    	    	    	    A	    S	    +	    <	    	 	   	 
   	 	   	    K	    	    	    	    O	 
   	    	    	    	    V	    h	    	    	    	 
   	    	    1	    U	    g	    	    	     	 , , 'x #h
  
	p`P0"p
 K
 @k     `k p	 	     	    	     	 
	    :	     F	 , ,h  
	p`P0/ /h3 +dp 'To #4n h 
p  "p
 K
 k k    k    k     l     l    @l    `l    l    l 	   l 	   l  
 r
     
 
    
    
    '
    _
    l
    {
    
    
    
    
    l
 	   
 
   
 	   :
    K
 	   Z
    i
    
    
 8 8& 3x' /h( "S p`P0"p
 L
  m      m     @m     `m     m     m     m     m     n 0
 
     
    
     	
    	
     d

    x

     
    
     \
    j
     
    
     
    
    
    
     
 +
u+h s% 
	p`0P  "p
 @L
  n @
 '
     
  d T 4
 rp"p
 pL
  
 
     
 !   h     !  t"  T#  4$ 
 
 H !I Ih 9  /! t" T# 4$ 
 
 H  % ` 4	 
Rp"p
 L
 @n `n 
 
     L
    \
 $
 $d  T 4 p"p
 L
 n 
 
     {
 #
 #h T 4 p`"p
  M
 n     n 
 &
     w
    &
     2
 / /	 *x
 &h "4#  
p`P  $
 $T 4
 R
	p`"p
 0M
 n  o     o    @o '
 R'
     '
    '
    I(
    \(
 
 
RP"p
 `M
 ? ? : 5x 1h !, p`0  "p
 `M
 	   	   
          Л   p H   `o o    o    o    o     p     p    @p    `p               (
 (
     (
    )
    5)
    )
    *
    *
    \+
    |+
    +
    +
    ,
    ,
    L,
 ~,
    ,
 	   -
    -
    .
    %.
    4.
    i.
 p     p 
   p     C C ; 6 1x -h )4UJ
p	`P  "p
 M
 p     p    p    q     q    0q    Pq    pq    pq    q    q 
   q 
   q    r    0r    Pr    pr    r    r    r    r    s    0s    Ps    ps    s    s    s    s    t    0t    Pt    pt    pt !   t "   t    t    t %   u    0u    Pu    pu )   u *   u *   u )   u -   u )   v    0v     Pv )   pv 2   v 3   v 4   v 4   v 3   v 7   w 7   0w 9   Pw :   pw :   w 9   w =   w >   w >   w =   w A   x B   0x B   Px D   px D   x B   x B   x H   x H   y A   0y =   Py 9   py 3   y    y     y 7   y Q   z Q   0z 7   Pz T   pz 7   z V   z W   z W    { V    { V    { 7   @{ \   `{ \   { 7   { _   { 7   { a   | b   0| b   P| a   P| a   p| 7   | g   | g   | 7   | j   } j   0} 3   P}    p}     } 7   } p   } 7   } r   ~ 3   0~    P~     p~ r   ~ r   ~ r   ~ r   ~ r    r   0 r   P r   p r    r    r    r    r       0 3   P    p      .
 4/
     J/
    /
    /
    /
    0
 	   0
 
   D1
    1
    2
 
    2
    G2
    _2
    2
    2
    2
    2
    2
    3
    73
    M3
    [3
    i3
    w3
    3
    3
    )4
    ;4
    G4
    k4
    4
 !   5
 "   5
 #   5
 "   5
 !   &6
 $   56
    D6
 %   T6
 &   6
 %   6
    7
 '   7
    '7
    Z7
 (   r7
 )   8
 +   D8
 -   8
 .   8
 -   8
 /   8
 )   8
    39
    B9
    z9
    9
    9
 
   9
    .:
 0   =:
    E:
 1   T:
     \:
 q:
 )   :
 2   :
 3   5;
 5   k;
 7   <
 8   x=
 9   O?
 ;   ?
 =   ?
 ?   ?
 A   @
 B   M@
 C   g@
 D   }@
 E   @
 D   @
 F   @
 D   @
 B   A
 G   A
 H   A
 I   B
 H   CB
 J   ^B
 H   mB
 B   	C
 K   C
 A   'C
 L   6C
 =   >C
 M   MC
 9   UC
 7   dC
 N   sC
 3   {C
 2   C
 )   C
    C
    C
    D
    RD
    D
 
   D
    D
 O   D
    D
 P   D
     D
 E
 7   [L
 Q   qL
 R   L
 Q   L
 S   L
 Q   L
 7   &M
 T   BM
 U   XM
 V   M
 X   +N
 Z   IO
 [   XO
 V   gO
 7   T
 \   #T
 ]   6T
 \   nT
 ^   T
 \   T
 7   T
 _   T
 `   
U
 a   U
 c   U
 e   V
 f   V
 a   W
 7   PX
 g   cX
 h   vX
 g   X
 i   X
 g   X
 7   X
 j   )[
 k   D[
 j   [
 l   \
 j   3\
 7   z\
 m   \
 3   \
 2   \
 )   \
    \
    \
    .]
    f]
    ]
 
   ]
    ]
 n   ]
    ]
 o   ^
     ^
 %^
 7   _
 p   _
 q   _
 p   _
 7   _
 r   	`
 s   `
 r   `
 7   `
 t   `
 3   `
 2   `
 )   a
    Da
    Sa
    a
    a
    a
 
   b
    ?b
 u   Nb
    Vb
 v   eb
     mb
 b
 r   b
     b
 r   c
 w   ~c
 r   c
 x   d
 r   <d
 y   d
 r   d
 z   Fe
 r   le
 {   e
 r   f
 |   vf
 r   f
 }   eg
 r   g
 ~   Th
 r   zh
    i
 r   <i
    i
 r   i
    j
 r   j
    \k
 r   jk
 7   k
    k
 3   k
 2   k
 )   k
    k
    l
    Cl
    {l
    l
 
   l
    l
    m
    m
    m
     %m
 7m
 r   Jm
    Ym
    |m
    m
 m
       "p
 M
 
     
 n
 n
     n
    o
     #o
 
 b  "p
 0N
    T     i 
 b  "p
 `N
 Ѐ       ɇ 
 b  "p
 N
        ) 
 b  "p
 N
  p       
 b  "p
 N
 0 Ј       
 b  "p
  O
 P 0 d     y  h b  !   Ћ   ! t Ћ   !     2  ! t   2  !   p   ! t p   !    Ҍ  ! t  Ҍ          20v
    p
 	q
 k       t
 T	 4 2 t
 d	 4 Rv
    t
 t
  t
 t
 u
      	 4
 rp`v
    u
 u
 ́ u
  bp`0  v
    u
 v
      	 B  v
    7w
 jw
 @ jw
 
 
4 
2p                                                               0                 Л            (p
                 p     0
                    P
 x
                               @                              @                    p     
                    
 x
                      Ȝ         @   0                 p     (                    x
                  p     `                     x
                      p         @                    p                          x
                      H         @                         0                    H                           @                                                                             P                                               P                               (                                                    p                                                     @                                           p         @                    p            Fp
                H p                               @                                                                                @                     @            fp
                ( H                               @   @                p H                      x         @   p                 H                      H         @                                     `         @   0                       @                    x  H                                                                           h   0'                  @       (   p!                 Н     h                          p     8                    x   x
                                                                             h   ;                                             H p                                            X   @                           @   =                          (   p!                  (          0                 Л (          (p
                 Н     @                          ж     0                    h  p                                   p         X                    X         @   >                  (                                                     @ h P
 x
                                                                              h   <                                            @    h                                              h   0                 `         P   0X                 @         (   `                  (       (   p!                 Н     P                                                    @  x
                                                                             h   {                 0                           ( H                                                    P                           h   @|                       8                    x   H                                                   @                          h                              @                                             H p x
                                                                p         h   О                   0  8         H @          K ؒ          dM                       JM     4M     M     M     L     L     L             H     \H      H     G     G     NG     F     F     bF     6F     E     E     8E     D     D     `D     D     C     C     C     vC     .C     B     B     XB     
B     A     A     >A     @     @     n@     2@     *@     ?     L?     
?     >     >     D>     =     =      =     <     <     D<     <     ;     ;     `;     ;     :     :     l:     >:     9     n9     9     9     8     8     B8     7     L7     6     z6     5     5     5     h5     4     j4     3     3     43     2     d2     2     1     f1     1     0             L     bL     PL     BL     2L     $L     L     
L     K     K     K     K     K     K     K     K     lK     dK     ZK     PK     FK     $K     K     K     J     J     J     J     J     J     pJ     PJ     4J     (J     J     I     I     I     I     I     `I     <I     2I     ,I     $I     I     I     I     
I     I     H     H     H     H     vL             ",     ,     +     +     +     +     +     +     p+     `+     H+     8+     $+     +     +     *     *     *     *     *     *     *     p*     X*     J*     :*      *     *     )     )     )     )     )     )     |)     j)     V)     B)     2)     )     )     (     (     (     (     (     r(     Z(     H(     4(     $(     (     (     '     '     '     '     '     '     v'     `'     N'     >'     0'     "'     '     &     &     &     &     &     &     &     r&     b&     N&     8&      &     &     %     %     %     0     0     0     j0     V0     B0     &0     0      0     /     /     /     /     /     ~/     n/     Z/     H/     8/      /     /     .     .     .     .     .     .     .     v.     b.     F.     *.     .     -     -     -     -     -     -     x-     d-     L-     8-      -     -     ,     ,     ,     ,     ,     ,     t,     ^,     H,     (     2,     %     %     %     v%     d%     N%     8%     (%              PyErr_Format  0 PyCObject_AsVoidPtr  PyExc_RuntimeError  6 PyCObject_Type   PyExc_AttributeError  	PyObject_GetAttrString   PyErr_SetString  PyExc_ImportError CPyImport_ImportModule  PyErr_CheckSignals  PyObject_GetAttr  _PyList_Append  PyExc_ArithmeticError  PyExc_OverflowError  PyExc_IndexError   PyExc_IOError  PyExc_ValueError   PyExc_TypeError  PyExc_MemoryError  PyErr_Occurred  _Py_NoneStruct   PyBaseObject_Type SPyInt_FromSsize_t PyObject_GC_Track PyObject_GC_UnTrack P PyCode_New  mPySlice_New PyTuple_Pack   PyExc_NameError  PyEval_EvalFrameEx  !PyFrame_New _PyThreadState_Current   PyEval_EvalCodeEx  PyDict_Next PyTuple_New _Py_CheckRecursiveCall  _Py_CheckRecursionLimit  PyDict_Size  PyExc_SystemError PyObject_Call / PyCFunction_Type  -PyFunction_Type PyUnicodeUCS2_Decode  PyUnicodeUCS2_FromUnicode } PyDict_GetItem  PyObject_CallMethodObjArgs  WPyInt_Type  ,PyUnicode_Type  PyString_Type 2PyGILState_Release   PyErr_WriteUnraisable PyString_FromString  PyErr_PrintEx 0PyGILState_Ensure uPyString_AsString  PyDict_SetItem  _PyString_Eq  PyUnicodeUCS2_Compare PyType_IsSubtype   PyExc_BaseException  PyErr_NormalizeException  PyTraceBack_Type  PyObject_GetItem   PyErr_Clear  PyErr_ExceptionMatches  PyTuple_Type  kPyList_Type PyObject_RichCompare  PyFloat_Type  PyLong_Type _Py_ZeroStruct  _Py_TrueStruct  PyMethod_Type PyObject_CallFunctionObjArgs  QPyInt_FromLong   PyDict_New  PyModule_GetDict  ePyList_New  PyObject_SetAttr  PyObject_Not  _PyObject_GetDictPtr  PyMem_Realloc PyMem_Malloc  ~PyString_FromFormat PyTraceBack_Here  ~PyLong_FromUnsignedLong PyObject_IsSubclass  PyErr_GivenExceptionMatches N PyClass_Type   PyObject_SetAttrString  PyType_Ready  7PyImport_AddModule  UPySequence_GetItem   PyExc_StopIteration  PyErr_SetNone _PyObject_CallFunction_SizeT   PyExc_GeneratorExit PyObject_CallObject 	 PyArg_UnpackTuple PyObject_GC_Del PyObject_ClearWeakRefs   PyErr_WarnEx   PyExc_RuntimeWarning  IPyRun_StringFlags  PyDict_SetItemString  PyObject_SelfIter PyObject_GenericGetAttr QPy_GetVersion PyOS_snprintf APyImport_Import PyObject_Hash PyString_FromStringAndSize  PyString_InternFromString PyUnicodeUCS2_DecodeUTF8  v_PyByteArray_empty_string vPyString_AsStringAndSize  & PyByteArray_Type  PyObject_IsTrue LPyInt_AsSsize_t PyNumber_Index  qPyLong_AsSsize_t  PyObject_GetIter  PyFloat_FromDouble  PyFloat_AsDouble   PyDict_Type aPySequence_Tuple   PyExc_AssertionError  "PyObject_Size `Py_OptimizeFlag 
 PyBaseString_Type mPyLong_AsLong rPyLong_AsUnsignedLong sPyLong_AsUnsignedLongLong _PyObject_GC_New  PyNumber_Add  PyObject_IsInstance !PyObject_SetItem  PyNumber_Subtract  PyExc_Exception  PyExc_NotImplementedError . PyCFunction_NewEx UPy_InitModule4_64 PyUnicodeUCS2_FromStringAndSize  PyErr_SetObject  PyErr_Restore  PyErr_Fetch python27.dll  o??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z  _??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 
?replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0PEBD@Z  	?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB ?find@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z  t??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z i ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBDAEBV10@@Z ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z  ?find_first_of@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z e ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@0@Z  g ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@PEBD@Z  ??$?MDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  ]?_Lock@_Mutex@std@@QEAAXXZ  ?_Unlock@_Mutex@std@@QEAAXXZ  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  , ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  - ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z  ?endl@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z   ??$?6DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@0@AEAV10@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z  ?swap@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEAV12@@Z \??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ O_LNan ??_D?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  Y?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??0?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z  G_Inf  v??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD_K@Z y??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 7?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?uncaught_exception@std@@YA_NXZ Z?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z  ??_D?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ ?str@?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z  d??0?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z $??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  #??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z z??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z N_LInf j??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ !
?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z +
?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  j?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ  ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ &?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z ?_Xsgetn_s@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_K_J@Z  )?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  :?flush@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z c?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z [_Nan  ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  L?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z ?exceptions@ios_base@std@@QEAAXH@Z  @??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z O?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z  `??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ^??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  J?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ  
?quiet_NaN@?$numeric_limits@N@std@@SANXZ  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  d?close@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?substr@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV12@_K0@Z  P?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??_D?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ  	?open@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXPEBDHH@Z  ??0?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAA@XZ MSVCP90.dll {atan  |atan2 ceil  cos exp floor log pow sin sqrt  <tan _time64  ??0exception@std@@QEAA@AEBQEBD@Z  E ?what@exception@std@@UEBAPEBDXZ  ??1exception@std@@UEAA@XZ  ??3@YAXPEAX@Z 	 ??0exception@std@@QEAA@AEBQEBDH@Z c __CxxFrameHandler3   ??0exception@std@@QEAA@XZ 
 ??0exception@std@@QEAA@AEBV01@@Z  _purecall 
 ??1bad_cast@std@@UEAA@XZ   ??0bad_cast@std@@QEAA@PEBD@Z  I _CxxThrowException  malloc  free  _invalid_parameter_noinfo  ??0bad_typeid@std@@QEAA@PEBD@Z   ??1bad_typeid@std@@UEAA@XZ  l __RTDynamicCast  ??2@YAPEAX_K@Z  memmove_s  ??0bad_cast@std@@QEAA@AEBV01@@Z =_errno  memcpy  memcmp  log10  ??0bad_typeid@std@@QEAA@AEBV01@@Z clock MSVCR90.dll Y __C_specific_handler  _unlock  __dllonexit 7_encode_pointer =_lock _onexit -_decode_pointer N_malloc_crt _initterm _initterm_e 8_encoded_null  _amsg_exit  Z __CppXcptFilter C ?terminate@@YAXXZ 8 ?_type_info_dtor_internal_method@type_info@@QEAAXXZ { __clean_type_info_names_internal  Sleep  DisableThreadLibraryCalls QueryPerformanceCounter GetTickCount  GetCurrentThreadId  GetCurrentProcessId GetSystemTimeAsFileTime KERNEL32.dll                    {XZ    M          M M M @ M   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355.pyd initstanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      H   X   h      r                  Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

       8              PP           Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest

        Note
        ----
        This is currently an alias for the `traceplot` method.
                  Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
                  Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
            parameter (or quantile) name(s)
        permuted : bool
            If True, returned samples are permuted. All chains are merged and
            warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are discarded. If
           `permuted` is True, `inc_warmup` is ignored.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

              
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                     Transform parameters from defined support to unconstrained space                   P                     p%                     %                                                     p                                                  D                           ,                                @                      0    P                                                                                 @                                                  `                                                                                                                           (                                                             !                                          @   p               @?                                                   Pf   f                                                   E&        &    P'                                    c           @d                                                           %                                                                                    p   p                     w                      w                  4             P                 R      0           S      `                                          /          @W      2           ]                ^                p_       `          p`   8              b   P   04          pc   h                     x   0                                                                                      Pf                     y                     `f                      y                                         0                      H    y                  `    y                                                                            e                               0    P                    D                                                                                        `                                0                                                    p                                 @                                                                                                               +                                                                                                         h               -                                              m   @n                   p                           E&     `   0)     *                                    Ph           l                                                       pf                                                                                                                             ,                                                                                                                    A&             -     .                                                                                                                    `,                                                                                                                                /                                                                                                                    A&             /                                                                                                                            p.                                                                                                           `                   0                                                                                                                    A&             P1    1                                                                                                                    0                                                                                                                              2                                                                                                                    A&             `3                                                                                                                             2                                                                                        k              L   pq           `      m                                                        l                                 H              0                                                   `    u     u    p              u    u                                                                                         p               s                                                                                                                    A             r                    8                m    0v   v   0w                                                                                                                           0t            iW
@      <                                                           Ȼ                        (      (                      0       &                            &                                                                             0                           0      <                         (   #                                                 p                              t                        `                           p   x                           л                                                   H      $                         |                                                   h                              @                               
                           	                           (                            A                                                                            X                              (                        H                           (                            p   8                                                        H                                                   H                              X                        X      	                        (                              
                     p   H                                                      x   
                        $                        0                              ػ                                                                               H                                                             s                                                    @                              	                        ,                        8                                                                                    h                           (   
                                                                                                            
                        4                        @   <                        `      L                      0   D                        8                            h      
                      P   L                           Ⱦ   	                         X                        X   H                        H                           X   T                           8   
                                                   \                                                                                                                
                                                h   d                        p                                 
                                                h   ȿ   
                     h   l                        (                            X                               ؿ   
                     x                              x   
                        ؾ   
                        `                        0   H   
                           	                        (                              	                        X   
                     @   t                        8      
                                                                           x      .                                                                                                       H      
                     (                                 	                     X                                   
                     8                                                      0   0                                                          	                                                P   8   
                           
                                                                                                      P                           @                           x                                                                                         "                         H                                                          x                      @                              8   '                            "                                                  x   h   
                        ļ                                                      $                        X   P                                                                                    	                     H   ,                           ̼                                                   `   Լ                                                      (                        8                                                       8   x   
                                                   ܼ                        @   X                           X                           `                                                      (   
                                                                                0                        p   8                        (   8   
                     (   h                           (   	                        h                        @   p                           x                                                   `   4                        `   <                                                                                                         x   p                                                   `      >                        8   	                                                 P                                 
                     P                           (   x   	                     p   H   	                     h   H   
                        T                        P                              H   	                                                                              X   
                     x      
                     p                           (   h   
                                                   X   	                         `   %                         \                                                   `   d                                                                                                                                         Ľ                           ̽                        @                               Խ                                                      l                           h   	                     (   Ļ                                                                PO
           .?AVbad_exception@std@@ PO
           .?AVexception@std@@     PO
           .?AVbad_alloc@std@@     PO
           .?AVlogic_error@std@@   PO
           .?AVdomain_error@std@@  PO
           .?AVinvalid_argument@std@@      PO
           .?AVlength_error@std@@  PO
           .?AVout_of_range@std@@  PO
           .?AVruntime_error@std@@ PO
           .?AVoverflow_error@std@@        PO
           .?AVunderflow_error@std@@       PO
           .?AVrange_error@std@@   PO
           .?AVvar_context@io@stan@@       PO
           .?AVclone_base@exception_detail@boost@@ PO
           .?AVsp_counted_base@detail@boost@@      PO
           .?AVbad_lexical_cast@boost@@    PO
           .?AVbad_cast@std@@              PO
           .?AVbase_writer@writer@interface_callbacks@stan@@       PO
           .?AVvari@math@stan@@    PO
           .?AVrounding_error@math@boost@@ PO
           .?AVbase_adapter@mcmc@stan@@    PO
           .?AVbase_mcmc@mcmc@stan@@       PO
           .?AVbase_adaptation@mcmc@stan@@ PO
           .?AVfixed_param_sampler@mcmc@stan@@     PO
           .?AVchained_var_context@io@stan@@       PO
           .?AVbad_typeid@std@@    PO
           .?AVfailure@ios_base@std@@              PO
           .?AV?$var_context_factory@Vpy_var_context@io@pystan@@@var_context_factory@interface_callbacks@stan@@            PO
           .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@            PO
           .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@             PO
           .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@        PO
           .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@           PO
           .?AU?$located_exception@Vexception@std@@@lang@stan@@            PO
           .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         PO
           .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         PO
           .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@        PO
           .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      PO
           .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      PO
           .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@     PO
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@              PO
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@  PO
           .?AVwindowed_adaptation@mcmc@stan@@     PO
           .?AVstepsize_adaptation@mcmc@stan@@     PO
           .?AVstepsize_adapter@mcmc@stan@@        PO
           .?AVstream_writer@writer@interface_callbacks@stan@@                        PO
           .?AV?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     PO
           .?AV?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     PO
           .?AV?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    PO
           .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        PO
           .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        PO
           .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       PO
           .?AV?$unit_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ PO
           .?AV?$unit_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       PO
           .?AV?$diag_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ PO
           .?AV?$diag_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       PO
           .?AV?$dense_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                PO
           .?AV?$dense_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      PO
           .?AV?$adapt_unit_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           PO
           .?AV?$adapt_unit_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ PO
           .?AV?$adapt_diag_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           PO
           .?AV?$adapt_diag_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ PO
           .?AV?$adapt_dense_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@          PO
           .?AV?$adapt_dense_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                PO
           .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@         PO
           .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@     PO
           .?AVexception@boost@@   PO
           .?AUbad_alloc_@exception_detail@boost@@ PO
           .?AUbad_exception_@exception_detail@boost@@                   `           PO
           .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@         PO
           .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@  PO
           .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@      PO
           .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        PO
           .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        PO
           .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       PO
           .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@          PO
           .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@               PO
           .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@  PO
           .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@              PO
           .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@   PO
           .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@    PO
           .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@             PO
           .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@        PO
           .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@          PO
           .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@        PO
           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@   PO
           .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@ PO
           .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@ PO
           .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@          PO
           .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@           PO
           .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@                                                      8   8         xL   L         ࿀M         ࿀N   PO
           .?AVsample@mcmc@stan@@  и   PO
           .?AVps_point@mcmc@stan@@        PO
           .?AVunit_e_point@mcmc@stan@@    PO
           .?AVsum_values@pystan@@ PO
           .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              PO
           .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       PO
           .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             PO
           .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       PO
           .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              PO
           .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             PO
           .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      PO
           .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             PO
           .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    PO
           .N      PO
           .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@       PO
           .?AVprob_grad@model@stan@@      PO
           .?AVstepsize_var_adapter@mcmc@stan@@    PO
           .?AVstepsize_covar_adapter@mcmc@stan@@  Xw         PO
           .?AVop_dv_vari@math@stan@@      PO
           .?AVop_vv_vari@math@stan@@      PO
           .?AVop_vd_vari@math@stan@@      PO
           .?AVadd_vv_vari@?A0x464bfb46@math@stan@@        PO
           .?AVadd_vd_vari@?A0x464bfb46@math@stan@@        PO
           .?AVdivide_vv_vari@?A0x464bfb46@math@stan@@     PO
           .?AVdivide_dv_vari@?A0x464bfb46@math@stan@@     PO
           .?AVsubtract_dv_vari@?A0x464bfb46@math@stan@@   PO
           .?AVmultiply_vv_vari@?A0x464bfb46@math@stan@@   PO
           .?AVop_v_vari@math@stan@@       PO
           .?AVneg_vari@?A0x464bfb46@math@stan@@   PO
           .?AVstored_gradient_vari@math@stan@@    PO
           .?AVpartials_vari@?A0x464bfb46@math@stan@@      PO
           .?AVexp_vari@?A0x464bfb46@math@stan@@   PO
           .?AVsum_v_vari@math@stan@@             N   
   
         ࿈8   9         ࿐9         :         ࿐:   PO
           .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x464bfb46@math@stan@@       H
   h
   
   
   
   X
   
   
   
   
   H   PO
           .?AVdiag_e_point@mcmc@stan@@    PO
           .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@     PO
           .?AVanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@ G   PO
           .?AVcovar_adaptation@mcmc@stan@@        PO
           .?AVvar_adaptation@mcmc@stan@@  PO
           .?AVpy_var_context_factory@io@pystan@@  PO
           .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@    PO
           .?AVpystan_sample_writer@pystan@@       &
   PO
           .?AVpy_var_context@io@pystan@@  PO
           .?AVdense_e_point@mcmc@stan@@   PO
           .?AVarray_var_context@io@stan@@ /
   6
                                  P:
   d   d   8<
   `<
   @
   C
   8I
   (J
   8<
   `<
   @
   C
                X           u      PO
           .?AVtype_info@@ 2-+  ] f          U  @
 U    H
     \
   4  p
 4  t  
 t    
     
     
   $  ܜ
   t  ,
     
     
     |
     
    q  X
     `
    m  h
     t
    Q  |
     
   1  
 `    
     
 @    
     
    q  
     ȡ
 @    ԡ
     
    q  
     
    Q  
     
   1   
 `      
    !  $
 @!  !  ,
 !  !  8
  "  m"  @
 "  "  L
  #  M#  T
 `#  #  `
 #  -$  h
 @$  $  t
 $  
%  |
  %  q%  
 %  o&  
 &  >'  
 P'  (  
 (  )  
 0)  *  
  *  +  ̢
 +  L,  Ԣ
 `,  ,  
 ,  -  
 -  -  
  .  g.  
 p.  .  
  /  /  
 /  /   
 0  0  0
 0  ;1  8
 P1  1  D
 1  2  T
  2  2  \
 2  K3  d
 `3  3  p
 3  ;  
 ;  <  
 <  *=  
 0=  d?  
 p?  9@  
 @@  @  ԣ
  A  sA  
 A  A  
 A  B  
 B  B  
 B  B  4
 B  B  D
 B  RC  L
 RC  C  h
 C  /D  
 D  D  
  E  iE  
 E  LF  
 F  F  
 F  F  
 F  kG  ̤
 kG  G  
 G  G  
 G  G   
 G  G  0
  H  rH  @
 H  H  H
 H  K  P
 K  L  h
 L  L  p
 L  L  
 L  L  
 L  M  
 M  N  
 N  "O  ȥ
 0O  tO  ԥ
 tO  O  
 O  O  
 O  YQ  
 R  S  
 S  :T  0
 @T  T  <
  U  U  D
 U  %W  P
 0W  W  d
 W  =X  |
 =X  X  
 X  Y  
 0Y  Z  
 Z  2[  Ȧ
 @[  [  Ц
 [  \  ئ
 \  \  
 \  \   
 ]  ^  
  ^  J_  $
 P_  __  @
 p_  _  H
 _  _  P
 _  _  X
 _  _  `
 _  _  h
 `  `  p
 0`  ?`  x
 `  `  
 `  a  
 a  a  
 a  a  ħ
 Pb  b  ԧ
 b  c  
  d  Ad  
 Pd  yf  
 yf  wg  
 g  g  
 @h  ^h  $
 ph  i  ,
 i  i  <
 i  Dj  D
 Dj  Yj  \
 Yj  bj  p
 pj  j  
  k  k  
 k  l  
 l  l  
 l  l  
  m  m  ̨
 m  m  Ԩ
 m  n  
 n  n  
 n  o  
 o  o  
 o  p  $
 p  [q  8
 pq  q  L
 r  r  X
 r  s  h
 s  "t  t
 0t  Qt  |
 Qt  t  
 t  t  
  u  }u  
 u  
v  
  v  v  ĩ
 v  w  ̩
  x  x  ܩ
  y  Ay  
 Py  "z  
 0z  yz  
 z  |   
 0|  |   
 |  E}  (
 P}  }  4
 }  }  <
  ~  *~  D
 *~  ~  L
 ~  ~  `
 ~  ~  t
 ~    
     
     
     
   p  Ȫ
 p    
   (  
 0     
   R  t
 `  5  
 @    
 Є    ȫ
     ث
   P  
 `  o  
 o    $
     L
   %  \
 0    
     
    q  
   6  
 `    
 0    
   k  Ȭ
   ђ  Ԭ
   2  ܬ
 @  ߓ  
   ]  
 p    
     
     
 @    
     $
    R  ,
 `    4
 0  }  @
     L
   ]  T
 p    `
     h
     t
      |
   )  
 0  ^  
 ^    
     ԭ
   Ϣ  
 Ϣ     
     (
     8
     `
   '  l
 '  C  
 P    
      
   ȱ  Ԯ
 ȱ    
     
    q  
 q  N   
 N  ܸ  8
     P
   `  \
 `  |  |
   @  
 P  _  
 _    
     ܯ
   x  
     
      
   D  L
 D  {  d
 {    x
   !  
 P    
      
     
   
  а
    q  ܰ
   [  
 p    
   =  
 P    
     
 0    
      
   a  ,
     4
   A  @
 p    H
   !  T
 P    \
     h
 0  }  p
     |
   ]  
 p    
   M  
 `    
     
     
     (
      <
 P    X
      d
   K  p
     |
 P    
      
   K  
     
 0    
   [  Ĳ
     в
 @    ܲ
   k 
  s 
   
   
   
   
   4
   H
  X X
 ` 
 `
 
 
 |
 
 G 
  ' 
 ' F 
 F x 
 x  ̳
  *
 ܳ
 *
 I
 
 I
 y
 
 
 
 
 
  
  8 ,
 8 \ D
 p  T
   \
  ( p
 ( L 
 `  
   
   
  < ̴
 P  ܴ
   
   
  , 
 @   
   (
   <
   T
 0  d
   l
   
    
   
   
    
    
   4
   
    X
 ! i" 
 p" " 
 " B% 
 B% [% $
 % % 4
 % k& <
 & ' H
 @' ' P
 ' ' X
 '  r d
  r r 
 r :r 
 :r \r Ĺ
 \r r ع
 r 	t 
 t "t  
 "t v 
 v v (
 0w Gw 8
 Gw b D
 b  p
   
  L 
 `  
  	 
 	  
  S 
   
   4
   @
   l
  " 
 "   
  " 
 "  Ļ
  / 
 /  
    
  d  (
 p    <
    D
   m L
   T
  2 \
 @ q d
   l
  2 t
 @ q |
   
  - 
 @ > 
   
 0  
  L Լ
 `  
  A 
 P ! 
 " @" h
 P" # p
  # 
3 
 3 5 T
 5 6 
 6 ^8 ܾ
 p8 < (
 < g= D
 p= ~A 
 A B 
 B 0G `
 @G K 
 K yQ 
 Q U 
 U [ 
 [ ` 
  ` f` 
 f` ` 
 ` a 
 a a 
 a e 
  f j 
 j n 
  n 'r 
 0r u 
 u v 
 0v v 
 v v (
 w w d
 w >x 
 Px x 
 x y  
 0y y \
  z { 
 { k 
 k  
  = $
 P ̈́ 
   z 
    
   % $
 0  ,
    
   E  
 P 
 
 
 l 
  ) p
 ) - 
 - Z/ 
 `/ / 
 / 1 
 2 !4 
 @4 e4  
 p4 6? h
 @? @ 
 @ OK 
 `K 5[ d
 P[ a 
 a e 
 e Ff 
 pf g 
 g Om (
 `m  
    
 Ѝ 
 
 0 j 
 p     
  ; 
 @  
      
  \ 
  Ɛ      ( du 0 V    
   &  0 R  p  hC   
  % ? %  
  ֓ 
  Ŕ ,
 Д  ,
   4
  ז 
  ' 
 @ q `
  ֗ 
  2  @  
  ט   
   G  P }   ͙  Й : 
 @ g du 0    +  0 f (
 p  
   
  & `
 0 f 
 p  0
   
  &  
 0 f h
 p  
   8
  & 
 0 f 
 p ӟ `  Ԡ `
  X |e ` ء |e   `   
  m 
 m  
   <
  H (
 H n 
 p ֤ |e  N  0 T P
 `  
  2 p
 p  
   
    
   g 
 g , 
 0  
     ȳ X
 ȳ γ H
 г /  P  l
      du   Y  `  |
   
   h 
 p · 
 з  
   h 
 p    ;  @  
   hC   c hC p Ӻ hC  C hC P  
    
    x
    
   
  = 
 @  h
  ( H
 ( 8 8
 @  x
   
   8 du `  
   
  ' 
 ' 0 
 0  
       
   T
  N 
 P  
  
 
  n 
 p  
  . 
 0  
   
  N 
 P  
  \ 
 `  
   
  $ 
 0  
  d 
 p  
    
  _ 
 `  
   
  $ 
 0 0 
 0 + P
 + 8 4
 8 C $
 P  
  9 p
 9 4 `
 @ 
 
   
   ,
   t
 p  
   0 
   
    P     
  * 
 0  $
   
  2 ? 2 ' 
 '   
   	 0
   du     & 
 & 3 |
 3 ] h
 `  
   
   l
  z 4
 z x $
   
   
  5 
 5  
   
   
       
   x
  7 
 @ | 4
   x
  O 
 P  
  m 
 p  
   
   
  f 
 f p 
 p ~ 
 ~  
   
   L
   l 
 p  
  & 
 0 | 
   8
  #   0    
       ! o! 
 p! ! 
 ! >" 
 @" " 
 " "  " ># 
 @# # 
 # $ |
 $ $ 
 $ $ `  % % 
 % ,&  0& l&  p& &  & &  & +'  0' ' 0  ' L(  P( (  ) l)  p) ) 
 ) + d  + s,   , 4-  4- / d / / P / / @ / >8  @8 9  9 :  : : 8  ; ;  ; <  < l=  = > P > >  > ?   ? ?  A A  A \B  B C  0C C  C &D  PD E  E G \ G G H G G 8 G P  P #R  0R U   U ?U  @U U  U V  V W  W ,X D 0X X  X VY  `Y Y  Y LZ  pZ Z  Z Z l Z Z \ Z Z H Z [  [ \  \ Fc  Fc jc  pc Fg 
 Pg h L h 9i |e @i j L  j Hj $ Hj j  j j  j j  j km p km >n X >n Jp D Jp p 4 p &s  &s Jv  Pv cv  	 cv {v 	 {v 
w  
w w  w w   w ?w  @w _w 	 _w w 	 w x 	 x x x	 x x h	 x x H	 x y ,	  y z 	 { ,|  
 @| | <
  } \}  `} }   ~ |~  ~   @ ? x
 @ S 
 S  
  X 
 X  
   8     z 
   |e   ̚ T  V  ` ֛   <  @ ֜    \  ` ؝ 
  Ȟ  О r     d     &  P o  p  ?  ߢ  ߢ    + 
 +    2  @  
  x 
 x  p
   `
     # 
 0 b 
 b  
   
   u 
  $ ` 0 ͪ 
 Ъ             P   
  h 
 p  
       8  8                s       L   ?  @  x  / 
 p        ?  @ ȶ 8 ж    x h     (  0 j 
 p  
   
  * 
 0  
  c  p    d T p D  P m  p #   0  h     /  0     
   n 
 p          <      X%  =  = ?  @  |e  s   b L p    .  0 m  m 3  3 G  P  $   p   H   8   X  ` P L P  X   H  H           $  n  n {   {    f |e p { (      x  ? h @ k  k    |      (  0 O  P     
    
   
  X 
 ` }       S  `     ?  @ _  `        `     J  J     ?  @    
 
   
  C  P  X  -  0       /  0 W | W  \   L    +   +  <   <            |e     8  @ z 
  3  @ Q T `         
   8   ( `	  P  0 ` 0  A   ^ 
 `  
         ~ 
                    2  @ ~       U ( ` 5  @  
        P  P  du     R  ` # ! # $ " $ % " % 1 T" 1 4 D" 4 5 " 5 06 <# 06 6 d#  7 7 # 7 08 $ 08 9 D$ 9 9  9 :   : K: $ K: ; d$ ; >< T$ @  A $  A AA $ AA E $ E F $ F F $ F F  F G % G }K |e K K X% K L D% L L 4% L V `% V V % V W % W W % W W % W PX  & PX X |e  Y %Y  0Y UY  `Y Y H& Y Y  Y Z & Z Z & Z Z p& Z @[ & @[ ` & ` 5`  @` e 8' e e |e e e 
 e Tf ' Tf f ' f /g |e g h '  h -i ' 0i i 0( i i ( i nj ( nj j p( j l (  l /m ) 0m m X) m n d) n o x) o *p 
 0p *q ) 0q q 
 q r t* r s 
 s `t  `t u 5 u Su + Su u + u u ,+ u u \+ u $v H+ $v =v 8+ @v x x+ x u| d, | ~ - ~  P.    0/  Z 
 `  /   /  R / R  /  ʃ / Ѓ w 0   x0  d 0  u 1  ݇ 
  ] \1 `  1 Ћ  L2  P t2 P     2  B 2 P M L   p3  P 3 P , 4 0 n (4  U 
 ` o 4 p  $5   t5  E 5 E  5  Θ 5 И ݙ 6  R 6 `       C / C M 6 M  6  ! 6 ! * 6 0 _ 7 `  |7   d7  S P7 S  @7  ˞ 07 О  7   ` 7 `  7    8  J 8 P  7      9 0 ڦ 9 P  9  x (:   
  w 
   
   q 
   
    |:  , <; 0 ~ ;   
 @  ;  B  P > ; @   4<    <   (=  . <= 0  =  =  > @ ~ h> @ ̽ ? н  8?   ?  ( ? p  D?    ?   ?  T ? T  ?   |  ( @ (  ?   X@  O 8@ O  (@ @  `@   @     : 
 @  A   A   H  q H  H A P  XA  k A p { A  O B O ~ B ~  B   hC      l  p    &  0       N  P  C  7 
 @  hC      pC   D  N  D P  
   D   D  7 
 @  D        0D  J  P .  0 R  `    c HD p    D D D  pD  f |e    D  s D      $  j  E j  D   ?  o 0E o t  E   DE    TE  % 
 0  
   
   
  ? 
 @ o 
 p  7    |E   N E P  F  . 
 0 f  p  i  < ,G @  ,G     E 8G P r |G   du  
 G 
  G  s G   DH    H  B H P  pH  # TH # ]' H ]' * H * w+ H + + I + Z- ,I Z- - I - - I - / \I / / LI 3 3 I 3 5 I 5 6 I 6 6 I 6 T7 I `7 8  J 8 : 0J : #;  K #; < K < #< J 0< < ,K = m> `K p> 1? K @? @ K  A A L A ZB @L B zC tL 0D D L 0E E L @F F M F G DM H H |M H J M  J J 
 J ` PN ` Bb <V Pb f V f f X f 
g X 
g g X g h |X h h lX h Ri X `i n $Y n n Y n mn Y mn on Y pn -o Y -o ~o Y ~o o Y o o Z o \p Y \p lp Y pp p ,Z  q q Z q q  q r H r s d[ s t  t %u t[ 0u ov [ pv v [  w ?x [ @x ]x H\ ]x x 4\ x x $\ Py my  my y l\ y y X\ y y X\ p{ {  { { \ { { \ { { \ } } (= }  \  p _ p  \` Е  `  < a @ 2 d[ @  b  R   `  `    `   b  o xc p g c p  <d  1 xd @ - d 0 M pe M  \e   Le  Q |e ` ܮ e  D e P / f 0 ~ \f   f   0g   g   g  N \h P  h  Z i ` p i p       k lj k  Xj   Hj  Z j `  j  z Pk   k    Y   l  $ l 0  Pl   <l   (l    w    \l     - l -  l   l   l    4m   n   m  	 m   n   m  Y m ` > $n @  8n   n   n   4o   o   o  P n P = n = T n ` \ Xo \ X Do `  ho  4 Pp 4  (p   p  < xp @   0q    Lq  

 u P
  D$      
 ^
 du `
 
 du 
  lu   u   u   Pv  D  P . hv 0 q w  + Pw 0  Xw   w    w       " u  " # w # $ w $ /& w 0& q' x ' ' ? ' H( 8x H( M( (x P( ( tx ( *+ \x *+ E+ Lx P+ u+  + k- x p- ^. x `. d/ 
 p/ +1 y 01 3 y  3 >4 ly @4 5 4y 5 6 Dy 6 7 H  8 p9 H p9  ; y  ; < Ty < = ly = *? 4y 0? .@ Dy 0@ @A y @A YA `z YA A Hz A ,C 0z ,C :C  z @C D ` D lE lz pE ?F ` @F F z F G z G H z H I z I J z J KK lj KK K z K K z K fL |e pL V z V JW  PW a { a *b  0b l } l o } o p x~ p r ~ r s  s t   t ]v X ]v *x D *x Nx 4 Px 1{ t @{ 7}  @} X~   `~ <  @ F  P  du  |           q       ~ (      |   l          T 
 ` " d 0  `  ݐ `   
            !  0 j  j Δ p Δ  X   H   8   Z  Z  ̃                   `z   L  | 4 |  $       d   
   w   z      p 4 p  @    t  )  0 l  p  (       ,   7  @ R w `       	      $ \ 0 \  \ Q ܑ Q \ ̑ ` ]  `  P     8  @        8        Y ` ` 	 p  Q Ԕ ` 	   	 ?	 
 @	 

 p 
 ~
  
 
 ` 
 Z ` `  
      
  4
 
 @
 
  
 
 
 
 R  ` [  `  T   |  D ( P  7      ! \ 0 7 x 7 :   ; > ģ  > D@  P@ tB t B B @ B C 
 C lD  pD G Ħ  G O @  O S  S U $ U |V  V ] P  ] ^  ^ U_  `_ T` w `` ea  pa Eb  Pb c   c e   e f $  g h D h h   i i  i i  i j , j k H k l lz l l 
 l 8n \ @n o  o #p x #p q T q r D r v  v v H v Jy  Py zz lz z } x } ;~  @~ m  p  
  n Ю p |   ڂ   у H     U  `     ΍  Ѝ  г  " 7 0        q 
  ,   0 ֗ X  ,  0 ؚ ܴ  G 
 P ^ h ^  @   ,        ' t 0  X  %  0     }       P  & < 0 & d 0  p  H  P    n  p .  0 ! H 0  X  % 5 % l  l w   ½  н  P      I ( P ' 8 0  `   |     "  0 S 0 `  L   d  s x     :  : R  `          } l   L   4   $       l   \     k  p        
    
  
          
      \  ` 	 < 	 	 `  	 j	  p	 N	 H P	 		  		 b
	  p
	 \	  `	 	 ` 	 h	 , p	 	   	 	  	 	  	 	 < 	 	  	 	  	 G	 L P	 F	 d P	 	 P 	 (	   (	 ]*	  `*	 6	  6	 09	   09	 E	 H E	 F	  F	 @F	  @F	 NF	  PF	 F	  F	 dN	  pN	 ~^	  ^	 _	  _	 `	  `	 .e	  0e	 ni	  pi	 L~	 ` P~	 	   	 	  	 	  	 o	  p	 ?	  @	 	  	 ߊ	 x 	 W	 ` W	 ϋ	 L ϋ	 	 <  	 	 t 	 	  	 ݔ	  	 	 < 	 	 p 	 Η	  З	 Ԙ	  	 	  	 	   	 	  	 	   	 B	 \ P	 	  	 >	  @	 J	 0 P	 *	 | 0	 ^	  `	 	  	 $	  0	 3	 @ @	 	  	 	 X 	 	  	 	 (  	 :	  @	 	 T 	 	 T 	 `	 0 `	 n	   p	 	 d 	 d	  p	 n	 X p	 {	  	 
   
 &
 , 0
 3
 p @
 
 |  
 
  
 
 H 
 l
   l
 q
  
 
 ` 
 j
 T p
 
  
 
  
 Z
  `
 '
 0 '
 v(
 X (
 .
  .
 n
 X n
 -o
 	 o
 p
 ` lp
 q
  q
 3q
 du 4q
 q
  q
 s
  s
 %u
  (u
 eu
 ` hu
 u
  u
 v
 0 8v
 pv
 
 pv
 v
 
 0w
 qw
 X w
 w
 du w
 cx
 x x
 x
  x
 x
 
  y
 y
 @
  y
 9y
 H
 @y
 Yy
 P
 `y
 yy
 X
 y
 y
 ̝
 y
 y
 ԝ
 y
 y
 ,
 y
 y
 4
  z
 z
 <
  z
 [z
 
 `z
 z
 
 z
 z
 ȟ
 z
 {
 ؟
  {
 [{
 
 `{
 {
 
 {
 {
 
 {
 |
 
  |
 [|
 (
 `|
 |
 8
 |
 |
 H
 |
 }
 X
  }
 9}
 4
 @}
 X}
 <
 `}
 }
 D
 }
 }
 
 }
 }
 
 }
 }
  
  ~
 ~
 ܵ
  ~
 <~
 
 P~
 i~
 P
 p~
 ~
 
 ~
 ~
 
 ~
 ~
 t
 ~
 ~
 |
 ~
 
 
 
 )
 
 0
 I
 
 P
 i
 
 p
 
 
 
 
 
 
 
 
 
 
 
 
 	
 ķ
 
 )
 ̷
 0
 I
 Է
 P
 i
 ܷ
 p
 
 
 
 
 
 
 ɀ
 0
 Ѐ
 
 8
 
 
 Խ
 
 ,
 ܽ
 0
 L
 
 P
 l
 
 p
 
 
 
 
 
 
 ف
 
 
 
 
  
 
 
  
 8
 d
 @
 [
 
 p
 
 
 
 
 
 
 Ȃ
 
 Ђ
 
 
 
 
 
 
 ?
 
 P
 h
 $
 p
 
 ,
 
 
 4
 
 ߃
 <
 
 
 
  
 8
  
 @
 X
 
 `
 {
 
 
 
 
 
 
  
 
 ؄
 (
 
 
 0
  
 
 8
  
 ;
 @
 @
 [
 H
 p
 
 (
 
 
 0
 
 ˅
 8
 Ѕ
 
 @
 
 ?
 
 @
 X
 
 `
 x
 
 
 
 
 
 
 
 
 ؆
 $
 
 
 ,
  
 
 4
  
 8
 <
 @
 [
 D
 `
 {
 L
 
 
 ,
 
 ȇ
 4
 Ї
 
 <
 
 
 D
 0
 ^
 
 p
 
 
 
 
 
 
 ̈
 
 Ј
 
 
 
 
 
 
 (
 
 0
 L
 
 P
 h
 
 p
 
 
 
 
 
 
 ̉
 
 Љ
 
 
 
 
 
 
 (
 
 0
 L
 
 P
 h
 
 p
 
 
 
 
 
 
 ̊
 
 Њ
 
 
 
 
 
 
 (
 
 0
 L
  
 P
 h
 
 p
 
 
 
 
 
 
 ̋
 
 Ћ
 
 
 
 
 
 
 (
 
 0
 L
 
 P
 h
 
 p
 
 
 
 
  
 
 ˌ
 
 Ќ
 
 
  
 
 
  
 <
  
 @
 \
 (
 `
 x
 0
 
 
 
 
 
  
 
 ؍
 <
 
 
 
 
 (
 
 0
 H
 
 P
 h
 4
 p
 
 t
 
 
 D
 
 Ȏ
 L
 Ў
 
 T
 
 
 \
 
 +
 d
 @
 X
 
 `
 x
 
 
 
 
 
 
 
 
 ۏ
 
 
 
 
 
 (
 
 0
 _
 
 `
 {
  
 
 
 
 
 
 
 
 ې
 
 
 
  
  
 
 (
  
 <
 0
 @
 X
 8
 `
 x
 D
 
 
 L
 
 ϑ
 T
 Б
 
 \
 
 
 d
 
 +
 l
 0
 K
 t
 P
 l
 |
 p
 
 
 
 
 
 
 Ȓ
 
 В
 
 
 
 
  
 
 +
 
 0
 K
 
 P
 l
 
 p
 
  
 
 
 (
 
 ȓ
 0
 Г
 
 8
 
 
 @
 
 )
 H
 0
 I
 P
 P
 k
 X
 p
 
 `
 
 
 
 
 ؔ
 
 
 
 
  
 
 
  
 ;
 
 @
 
 
 
 
 
 
 ˕
  
 Е
 
 
 
 
 
 
 (
 
 0
 H
  
 P
 h
 (
 p
 
 0
 
 
 8
 
 ˖
 @
 Ж
 
 H
  
 ;
 
 @
 [
 
 `
 {
 
 
 
 
 
 
 
 
 ۗ
 
 
 
 
  
 
 
  
 8
 
 @
 X
 
 `
 x
 
 
 
 
 
 
 
 И
 
 
 
 
 
 
 +
 
 0
 _
 
 `
 x
 $
 
 
 ,
 
 
 4
 
 ۙ
 <
 
 
 
 
 (
 
 0
 K
 
 P
 k
 
 p
 
 
 
 
 
 
 ̚
 
 К
 
 
 
 
 
 
 (
 
 0
 K
 
 P
 h
 
 p
 
 
 
 
 
 
 ț
 
 Л
 
 
 
 
 
 
 +
 
 0
 K
 
 P
 k
 
 p
 
 
 
 
 
 
 ˜
 
 М
 
 
 
 
 
 
 +
 
 0
 K
 
 P
 h
 $
 p
 
 ,
 
 
 4
 
 ̝
 <
 Н
 
 D
 
 
 L
 
 /
 T
 0
 K
 \
 P
 o
 d
 p
 
 l
 
 
 t
 
 ˞
 |
 О
 
 
  
 
 
  
 ;
 
 @
 [
 
 p
 
 
 
 
 
 
 ˟
 
 П
 
 
 
 
 
 
 (
 
 0
 H
 
 P
 h
 
 p
 
 
 
 Ԡ
 
 
 
 
  
 
 
 0
 H
 
 P
 h
 
 p
 
 
 
 
 
 
 ˡ
 
 С
 
 $
 
 
 ,
 
 (
 4
 0
 H
  
 P
 h
 
 p
 
 
 
 
 
 
 Ȣ
  
 Т
 
 (
 
 
 0
 
 (
 8
 0
 H
 P
 P
 h
 X
 p
 
 `
 
 
 h
 
 ȣ
 p
 У
 
 x
 
 
 
 
 (
 
 0
 K
 
 P
 k
 
 
 
 
 
 
 
 
 ۤ
 
 
 
 
  
 
 
  
 ;
 
 @
 [
 
 `
 
 
 
 ˥
  
 Х
 
 
  
 ;
 
 @
 [
  
 `
 {
 (
 
 
 0
 
 
 8
 
 
 @
 
 +
 P
 0
 t
 X
 
 
 h
 
 
 p
 
 ۧ
 x
 
 
 
  
 
 
  
 =
 
 @
 ]
 P
 `
 }
 
 
 
  
 
 
 
 
 ݨ
 
 
 
 X
  
 
 
  
 =
 (
 @
 ]
 
 `
 }
 
 
 
  
 
  
 ٩
  
 
   
 
   
 8
  @
 X
  `
 x
  
 
 
 
 ت
  
 
   
 
   
 \
 
 `
 x
  
 
  
 
  
 ܫ
  
 
   
 
   
 9
  @
 Y
  `
 y
  
 
  
 
  
 ٬
  
 
   
 
   
 9
  @
 Y
  `
 y
  
 
  
 ѭ
 
 
 
 
  
 >
 
 @
 \
  `
 y
  
 
  
 
  
 ٮ
  
 
   
 
   
 9
  @
 Y
  `
 y
  
 
  
 
  
 ٯ
  
 
   
 
   
 9
  @
 Y
  `
 y
  
 
  
 
  
 ٰ
  
 
   
 
   
 8
  @
 g
 l
 p
 
  
 
  
 ̱
  б
 
  
 
  
 )
  0
 N
 ( P
 h
  p
 
  
 ղ
   
 
   
 
   
 g
 0 p
 
  
 
  
 ȳ
  г
 
  
 
  
 :
  @
 j
  p
 
  
 
  
 
 d  
 *
  0
 Z
  `
 x
  
 
  
 ȵ
  е
  
   
 
   
 8
  @
 j
  p
 
  
 
  
 ض
  
 

  
 :
  @
 X
  `
 
  
 
  
 
  
 
   
 *
  0
 H
  P
 z
 < 
 
  
 
  
 ٸ
  
 
 |  
 *
  0
 H
  P
 
  
 
  
 
  
 
  
 
  
 :
  @
 X
  `
 
  
 
  
 ں
  
 
   
 *
  0
 H
  P
 z
  
 
  
 ʻ
  л
 
  
 
   
 8
  @
 \
  `
 |
  
 
  
 
  
 ܼ
  
 
   
 
   
 <
  @
 \
  `
 y
  
 
  
 
  
 ٽ
  
 
   
 
   
 8
  @
 Y
  `
 {
  
 
  
 о
  о
 
  
 
  
 +
  0
 K
  P
 h
  p
 
  
 
  
 
  
 
  
 +
  0
 K
  P
 
  
 
  
 
  
 
  
 
   
 
   
 6
  @
 [
  `
 
  
 
  
 
 " 
 
  
 :
  @
 X
  `
 x
  
 
  
 
  
 
  
 
  
 ,
  0
 H
  P
 i
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 L
  P
 |
  
 
  
 
  
 
 )  
 
   
 G
 d* P
 w
 h+ 
 
 h+ 
 5
 L, @
 Y
  `
 
 <, 
 
  
 
 p-  
 
 p-  
 G
 @. P
 n
 @. p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 L
  P
 h
  p
 
  
 
  
 
  
 
 L1  
 E
 1 P
 k
  p
 
  
 
  
 
  
 
 2  
 ;
  @
 Y
  `
 y
  
 
  
 
  
 
  
 
   
 
   
 8
  @
 g
 5 p
 
 7 
 
 8 
 
 8  
 '
 9 0
 I
  P
 
  
 
  
 
  
 
 l: 
 
 l: 
 )
  0
 I
  P
 h
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 y
 |< 
 
  
 
  
 
  
 
   
 
   
 J
 = P
 i
  p
 
  
 
  
 
  
 
  
 
  
 +
  0
 H
  P
 h
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 I
  P
 i
  p
 
  
 
  
 
  
 
  
 	
  
 (
  0
 K
  P
 i
  p
 
  
 
  
 
  
 
  
 	
  
 )
  0
 I
  P
 h
  p
 
  
 
 E 
 
   
 I
 F P
 h
  p
 
  
 
  
 
  
 
  
 
  
 /
  0
 H
  P
 o
  p
 
  
 
  
 
  
 
  
 (
  0
 H
  P
 h
  p
 
  
 
  
 
  
 
  
 	
  
 )
  0
 I
  P
 k
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 I
  P
 l
  p
 
  
 
  
 
  
 
  
 
  
 (
  0
 
 <N 
 
  
 
   
 
   
 9
  @
 Y
  `
 |
  
 
  
 
  
 
  
 
   
 
   
 8
  @
 
 <N 
 
  
 
  
 ,
  0
 I
  P
 i
  p
 
  
 
  
 
  
 
  
 
  
 )
  0
 H
  P
 k
  p
 
  
 
 <N  
 9
  @
 \
  `
 |
  
 
  
 
  
 
  
 
   
 
   
 <
  @
 \
  `
 y
  
 
  
 .
 <N 0
 I
  P
 l
  p
 
  
 
  
 
  
 
  
 	
  
 (
  0
 L
  P
 l
  p
 
  
 
  
 
  
 
  
 ^
 <N `
 y
  
 
  
 
  
 
  
 
   
 
   
 9
  @
 Y
  `
 y
  
 
  
 
  
 
  
 
   
 
   
 9
  @
 Y
  `
 y
  
 
  
 
  
 
  
 
   
 
   
 9
  @
 X
  `
 
  
 
  
 
  
 
  
 
 Z  
 <
  @
 g
 Z p
 
  
 
  
 
  
 
  
 
  
 +
  0
 K
  P
 k
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 L
  P
 l
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 L
  P
 l
  p
 
  
 
  
 
 \ 
 
 \ 
 (
  0
 H
  P
 l
  p
 
  
 
  
 
  
 
  
 	
  
 (
  0
 K
  P
 h
  p
 
  
 
  
 
  
 
  
 
  
 (
  0
 H
  P
 h
  p
 
  
 
  
 
 a 
 (
  0
 H
  P
 h
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 L
  P
 i
  p
 
  
 
  
 
  
 
  
 
  
 +
  0
 K
  P
 h
  p
 
  
 
  
 
  
 
  
 
  
 (
  0
 H
  P
 h
  p
 
  
 
  
 
  
 
  
 
  
 +
  0
 K
  P
 k
  p
 
  
 
  
 
  
 
  
 
  
 )
  0
 I
  P
 i
  p
 
  
 
  
 
  
 
  
 	
  
 (
  0
 W
 i `
 
 |j 
 
 @k 
 
  
 
   
 
   
 F
  P
 i
  p
 
  
 
 $m 
 
  
 
   
 
   
 8
  @
 X
  `
 x
  
 
  
 
 `p  
 
   
 ;
  @
 [
  `
 {
  
 
  
 
  
 
  
 
   
 
   
 8
  @
 \
  `
 |
  
 
  
 
  
 
  
 
   
 
   
 <
  @
 \
  `
 |
  
 
  
 
  
 
  
 
   
 
   
 <
  @
 g
 <q p
 
  
 
  
 
 <q 
 
   
 
   
 8
  @
 X
  `
 x
  
 
  
 
  
 
  
 
   
 
   
 <
  @
 \
  `
 x
  
 
  
 
  
 
 |y 
 
  
 +
  0
 K
  P
 k
  p
 
  
 
  
 
  
 
  
 
  
 (
  0
 H
  P
 h
  p
 
  
 
  
 
  
 
  
 
  
 ,
  0
 I
  P
 i
  p
 
  
 
  
 
  
 
  
 	
  
 (
  0
 W
  `
 x
  
 
  
 N   P  h   p                     ;  @ [  ` {                    ;  @ [  ` {                    <  @ \  ` |                    <  @ \  ` |               ,  0 L  P l  p                7  @ [  ` {                    ;  @ [  ` {                    <  @ \  ` |               	 	   	 <	  @	 \	  `	 |	  	 	  	 	  	 	 ܉ 	 
  
 ,
  0
 L
  P
 l
  p
 
  
 
  
 
  
 
  
    +  0 K  P w ܉               E  P i  p             
  
 +
  0
 O
  P
 k
  p
 
  
 
  
 
  
 
  
    (  0 H  P h  p                (  0 H  P l  p                ,  0 P  P h  p                /  0 O  P o  p                ,  0 K  P k  p    > D @ X  `  4           +  0 K  P i  p                ,  0 L  P i  p                )  0 H  P h  p                )  0 H  P h  p                )  0 H  P h  p                )  0 H  P i  p                +  0 K  P h  p                )  0 H  P h  p                )  0 H  P k  p                +  0 L  P l  p                )  0 I  P k  p        h          8  @ c  p                     8   @  [   `                      ! d  ! <!  @! X!  `! x!  ! !  ! !   " "   " 8"  @" Y"  `" {"  " "  " "  " "  " "   # #   # 9#  @# Y#  `# y#  # #  # #  # #  # #   $ $   $ 8$  @$ \$  `$ |$  $ $  $ $  $ $  $ $   % %   % ?%  @% X%  `% x%  % %  % %  % %  % %   & &   & ;&  @& [&  `& {&  & &  & &  & &  & &   ' '   ' 9'  @' f'  p' '  ' '  ' '  ' '  ' (  ( ((  0( L(  P( l(  p( (  ( (  ( (  ( (  ( )  ) ()  0) O)  P) h)  p) )  ) )  ) )  ) )   * "*  0* H*  P* r*  * *  * *  * *   + +   + <+  @+ \+  `+ +  + +  + +  + +  + +   , ,   , <,  @, \,  `, ,  , ,  , ,  , ,  , ,   - )-  0- K-  P- h-  p- -  - -  - -  - -  - .  . +.  0. K.  P. k.  p. .  . .  . .  . .  . /  / (/  0/ K/  P/ y/  / /  / /  / /  / /   0 0   0 90  @0 Y0  `0 {0  0 0  0 0  0 0  0 0   1 1   1 81  @1 X1  `1 {1  1 1 H 1 1  1 1  1 2   2 82  @2 X2  `2 x2  2 2  2 2  2 2  2 2   3 3   3 83  @3 _3  `3 }3  3 3  3 3  3 3  3 3   4 4   4 ?4  @4 `4  `4 x4  4 4  4 4  4 4  4 4   5 5   5 95  @5 Y5  `5 5 < 5 5  5 	6  6 46  @6 6 h 6 6  6 6  6 6   7 7 h 7 7  7 7  7 7  7 	8  8 )8  08 I8  P8 i8  p8 8  8 8  8 9 p 9 (9  09 H9  P9 h9  p9 9  9 9  9 9  9 9  9 :  : /:  0: H:  P: h:  p: :  : :  : :  : :  : ;  ; +;  0; _;  `; {;  ; ;  ; ;  ; ;  ; &<  0< K<  P< k<  p< <  < <  < <  < <  < =  = +=  0= H=  P= h=  p= =  = =  = =  = 8>  @> \>  `> |>  > >  > >  > >  > >   ? ?   ? <?  @? \?  `? |?  ? ?  ? ?  ? ?  ? ?   @ @   @ 8@  @@ [@  `@ {@  @ @  @ @  @ @  @ @   A A   A ;A  @A [A  `A A  A A  A A  A A  A B  B +B  0B RB  `B {B  B B  B B  B B  B C  C ,C  0C LC  PC iC  pC C  C C  C C  C C  C D  D ,D  0D LD  PD lD  pD D  D D  D DE ( PE lE  pE E  E E  E E  E E  E F  F +F  0F RF  `F yF  F F  F F  F F  F F   G G   G ;G  @G bG  pG G  G G  G G   H "H  0H HH  PH rH  H H  H H  H H  H I   I 8I  @I fI  pI I  I I  I I  I 2J  @J \J  `J {J  J J   K K   K 9K  @K XK  `K {K  K K  K K  K K  K K   L L   L ;L  @L [L  `L {L  L L  L L  L L  L L   M M   M <M  @M {M  M M  M M  M M  M M   N *N  0N HN  PN kN  pN N  N N  N N  N N   O O   O 9O  @O \O  `O yO  O O  O O  O O  O O   P P   P ;P  @P XP  `P |P  P P  P P  P P  P P   Q Q   Q ;Q  @Q \Q  `Q xQ  Q Q  Q Q  Q Q  Q Q   R R   R <R  @R \R  `R |R  R R  R R  R R  R R   S  S   S OS  PS hS  pS S  S S  S S  S S  S T  T +T  0T KT  PT kT  pT T  T T  T T  T T  T U  U +U  0U LU  PU lU  pU U  U U  U U  U U  U V  V ,V  0V KV  PV kV  pV V  V V  V V  V V  V W  W ,W  0W LW  PW iW  pW W  W W  W W  W W  W X  X ,X  0X IX  PX kX  pX X  X X  X X  X X  X Y  Y +Y  0Y KY  PY kY  pY Y  Y Y  Y Y  Y Y  Y Z  Z +Z  0Z KZ  PZ kZ  pZ Z  Z Z  Z /[  0[ I[  P[ i[  p[ [  [ 	\  \ )\  0\ H\  P\ \  \ \  \ 	]  ] ]  ] ]  ] ]  ] O^  P^ i^  p^ ^  ^ _ d _ )_  0_ I_  P_ l_  p_ _  _ _  _ _  _ _  _ `  ` (`  0` K`  P` k`  p` `  ` `  ` `  ` `   a a   a ;a  @a [a  `a {a  a a  a a  a a  a a   b b   b 8b  @b Xb  `b xb  b b  b b  b b  b b   c c   c 8c  @c Xc  `c xc  c c  c c  c (d H 0d Hd  Pd hd  pd d  d d  d d  d 2e p @e Xe  `e {e  e e  e e  e e  e e   f f   f <f  @f {f  f f  f f  f f  f f   g *g  0g Hg  Pg kg  pg g  g g  g g  g g   h h   h 9h  @h \h  `h yh  h h  h h  h h  h h   i i   i ;i  @i Xi  `i |i  i i  i i  i i  i i   j j   j 8j  @j \j  `j xj  j j  j j  j j  j j   k k   k <k  @k Xk  `k xk  k k  k k  k k  k k   l l   l 8l  @l Xl  `l {l  l l  l l  l l  l l   m m   m 9m  @m Ym  `m ym  m m  m m  m m  m m   n n   n <n  @n Xn  `n xn  n n  n n  n n  n n   o o   o <o  @o \o  `o xo  o o  o o  o o  o o   p p   p 8p  @p [p  `p {p  p p  p p  p p  p q  q +q  0q Lq  Pq kq  pq q  q q  q q  q q  q r  r +r  0r Kr  Pr kr  pr r  r r  r r  r r  r s  s +s  0s Ks  Ps ks  ps s  s s  s s  s s  s t  t )t  0t Lt  Pt kt  pt t  t t  t t  t t  t u  u +u  0u Ku  Pu ku  pu u  u u  u u  u u  u 	v  v +v  0v Kv  Pv kv  pv v  v v  v v  v v  v w  w +w  0w Kw  Pw lw  pw w  w w  w w  w w  w x  x +x  0x Hx  Px hx  px x  x x  x x  x x  x y  y ,y  0y Ky  Py ky  py y  y y  y y  y y  y z  z ,z  0z Iz  Pz kz  pz z  z z  z z  z z   { {   { ;{  @{ [{  `{ y{  { {  { {  { {  { |  | )|  0| K|  P| k|  p| |  | |  | |  | |  | }  } )}  0} I}  P} k}  p} }  } }  } }  } }  } ~  ~ +~  0~ K~  P~ k~  p~ ~  ~ ~  ~ ~  ~ ~  ~    +  0 K  P k  p                )  0 L  P k  p       ˀ  Ѐ       +  0 K  P k  k       ́  ́    6  @ a  p  du  Ȃ du Ђ  du    du @ ^ du ` ~ du  6 du @ ^ du   du   du  . du 0 J du P n du p  du  ۅ du   + du   du   du   du   y 	  ه 	  9 (
 @ e du p Ɉ X
 Ј ) 
 0  
   du  Љ du Љ G 
 Ћ        
   2  2 \ ( \ b  p     L   <  Ҍ  Ҍ  p   `  L du P  du  ̍ du   du   \ du `  du                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   T   8@HPX`hpxȩЩة  (08@HPX`  (   hpxȬЭخ              (08@HPX`hpxئ  (0ȧЧا  (08@HPȨШب  (8@HpxȫЫث  (08@H  (0HPXpx  t   `hpxȠРؠ  (08@Хإ  ( 08@HPX`hpx      (08@HP`hpxȠРؠ (08@HPX`hpxx(08@HPX`hpxȫЫث  (08@HP    ؠ HPX`h(08@HPX`hpxȢТآ  (08@ 8@HPX`hpxȥХإ ب  (08@HPX`hpx (08@HPX`x  (      x     px (08@HPX  (08@HPX`hpx  (`hpxȨШب @HPX`hpx     Сء ȢТ8@HPX`hpxȣУأ HPX`hpxؤ  (08@xȥХإ (08@HPX`hpX`hpx (08@  
 ,   (08hpx (HPX 
 @   8@HPȦЦئ HP (08@HPX`h    
 |   ء 8@X`h(0px`hpxȭЭح 8@HP  (08 0
 p     (08@HPX`hpxȣУأȧЧا  (08@HP @
    HP P       (08ȠР   ` \  ȣ @HPhpxȤ08@X`hХإ hئ(0pxPXpxȨШب08PXhpxȩЩة(08PXpxЪت08PXpxЫث8@H`hpج (08PX`xHxȮЮ HX   p    (8(@ȣУHФXإ08HPXhpxئ08@HX`hpȧh(pxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد     (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp08X`Чا  (HPpxȨ8@`hة (0PXxȪЪ @Hhp08X`Ьج  (HPpxȭ8@`hخ (0PXxȯЯ  \   @Hhp08X`Сء  (HPpxȢ8@`hأ (0PXxȤФ @Hhp08X`Цئ  (HPpxȧ8@`hب (0PXxȩЩ @Hhp08X`Ы HpȬHxЭ@p@pЯ  <   @h p`pЦ0𪀫@xP        Р00p@Э  @   `@ X  ` p`P   H    pСP`hpТHx`Ъ@        (`@ @(`ؤ 08HXhpȥХإ  P XPX  0@HPX`hpx                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            q
Umodule_nameqU=stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_461242355qU
model_nameqU+anon_model_047a6166bd9c6ecaed4dd3733fae7c6bqub.