(cpystan.model
StanModel
q oq}q(U
model_cppnameqX+   anon_model_1988b9d517e3c16daf27a07f09e3de97qU
model_codeqT  data {
  int T;                                // Sample size
  int<lower=1> K;                       // Number of seasonal vectors
  real t[T];                            // Day
  real y[T];                            // Time-series
  int S;                                // Number of changepoints
  real A[T, S];                   // Split indicators
  real t_change[S];                 // Index of changepoints
  real X[T,K];                // season vectors
  vector[K] sigmas;              // scale on seasonality prior
  real<lower=0> tau;                  // scale on changepoints prior
}

parameters {
  real k;                            // Base growth rate
  real m;                            // offset
  real delta[S];                       // Rate adjustments
  real<lower=0> sigma_obs;               // Observation noise (incl. seasonal variation)
  real beta[K];                    // seasonal vector
}

transformed parameters {
  real gamma[S];                  // adjusted offsets, for piecewise continuity

  for (i in 1:S) {
    gamma[i] = -t_change[i] * delta[i];
  }
}

model {
  real Y[T];

  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  for (i in 1:T) {
    Y[i] = (dot_product(A[i], delta) + k) * t[i] + (dot_product(A[i], gamma) + m) + dot_product(X[i], beta);
  }
  y ~ normal(Y, sigma_obs);
}
qUmodule_filenameqUBstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.pydq	U
model_cppcodeq
X^  // Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class anon_model_1988b9d517e3c16daf27a07f09e3de97 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> y;
    int S;
    vector<vector<double> > A;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
public:
    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
        validate_non_negative_index("t", "T", T);
        t = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("t");
        pos__ = 0;
        size_t t_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
            t[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
        validate_non_negative_index("y", "T", T);
        y = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "S", "int", context__.to_vec());
        S = int(0);
        vals_i__ = context__.vals_i("S");
        pos__ = 0;
        S = vals_i__[pos__++];
        context__.validate_dims("data initialization", "A", "double", context__.to_vec(T,S));
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
        vals_r__ = context__.vals_r("A");
        pos__ = 0;
        size_t A_limit_1__ = S;
        for (size_t i_1__ = 0; i_1__ < A_limit_1__; ++i_1__) {
            size_t A_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < A_limit_0__; ++i_0__) {
                A[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
        validate_non_negative_index("t_change", "S", S);
        t_change = std::vector<double>(S,double(0));
        vals_r__ = context__.vals_r("t_change");
        pos__ = 0;
        size_t t_change_limit_0__ = S;
        for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
            t_change[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
        validate_non_negative_index("X", "T", T);
        validate_non_negative_index("X", "K", K);
        X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_limit_1__ = K;
        for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
            size_t X_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                X[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("sigmas", "K", K);
        sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("sigmas");
        pos__ = 0;
        size_t sigmas_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
            sigmas[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
        tau = double(0);
        vals_r__ = context__.vals_r("tau");
        pos__ = 0;
        tau = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"K",K,1);
        check_greater_or_equal(function__,"tau",tau,0);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += S;
        ++num_params_r__;
        num_params_r__ += K;
    }

    ~anon_model_1988b9d517e3c16daf27a07f09e3de97() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        // generate_declaration k
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        // generate_declaration m
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        // generate_declaration delta
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        // generate_declaration sigma_obs
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        // generate_declaration beta
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ k;
        (void) k;  // dummy to suppress unused var warning
        if (jacobian__)
            k = in__.scalar_constrain(lp__);
        else
            k = in__.scalar_constrain();

        T__ m;
        (void) m;  // dummy to suppress unused var warning
        if (jacobian__)
            m = in__.scalar_constrain(lp__);
        else
            m = in__.scalar_constrain();

        vector<T__> delta;
        size_t dim_delta_0__ = S;
        delta.reserve(dim_delta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            if (jacobian__)
                delta.push_back(in__.scalar_constrain(lp__));
            else
                delta.push_back(in__.scalar_constrain());
        }

        T__ sigma_obs;
        (void) sigma_obs;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_obs = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_obs = in__.scalar_lb_constrain(0);

        vector<T__> beta;
        size_t dim_beta_0__ = K;
        beta.reserve(dim_beta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            if (jacobian__)
                beta.push_back(in__.scalar_constrain(lp__));
            else
                beta.push_back(in__.scalar_constrain());
        }


        // transformed parameters
        vector<T__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);


        try {
            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < S; ++i0__) {
            if (stan::math::is_uninitialized(gamma[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                vector<T__> Y(T);
                stan::math::initialize(Y, DUMMY_VAR__);
                stan::math::fill(Y,DUMMY_VAR__);


                current_statement_begin__ = 34;
                lp_accum__.add(normal_log<propto__>(k, 0, 5));
                current_statement_begin__ = 35;
                lp_accum__.add(normal_log<propto__>(m, 0, 5));
                current_statement_begin__ = 36;
                lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
                current_statement_begin__ = 37;
                lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
                current_statement_begin__ = 38;
                lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
                current_statement_begin__ = 41;
                for (int i = 1; i <= T; ++i) {

                    current_statement_begin__ = 42;
                    stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((((dot_product(get_base1(A,i,"A",1),delta) + k) * get_base1(t,i,"t",1)) + (dot_product(get_base1(A,i,"A",1),gamma) + m)) + dot_product(get_base1(X,i,"X",1),beta)));
                }
                current_statement_begin__ = 44;
                lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("gamma");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
        for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
        }
        vars__.push_back(sigma_obs);
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector<double> gamma(S, 0.0);
        stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(gamma,DUMMY_VAR__);


        try {
            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_1988b9d517e3c16daf27a07f09e3de97";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

} // namespace

typedef anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97 stan_model;

qUmodule_bytesqT h MZ                @                                       	!L!This program cannot be run in DOS mode.

$       ?QQQIQQQQPQQQQRichQ                        PE  d EXZ         " 	  P  8     O
                                                                                d                         
                                                   ` 0	                          .text   N     P                   `.rdata  x  `    T             @  @.data                         @  .pdata                       @  @.reloc          P             @  B                                                                                                                                                                                                                                                                                                                                H%!T @WH H
s V HHu H
X Hs H	X H _Hs HH\$0X HHu
HWHR0Hu%H
X Hr H	aX H\$0H _HdX H9Ct9H
_X Hr H	/X H,  HCHP0H\$0H _H,X HH! uHCHP0H Hu%H
W Hr H	W H\$0H _=	  t7H԰ H
W Hr H	DA	  W H\$0H _H   
s;H   H
vW Hr H	DA
   mW H\$0H _HP   u	Hr t%Hr H
"W H	)W H\$0H _3H\$0H _LHwH       II     MAu    IAtIIHHRL;uD  LIHHHRL;tIIHHL;u     LIHHHL;tIvI|I@SHPHD$ HHs HL$(O HHT$(HHL$(O HP[E~utAAu2D~tAAu2@WHPHD$ H\$`HHHs HL$(N HHT$(HHL$(N LHASHHL$(N HHT$(HHL$(N H1s HL$(N HHT$(HHL$(N Hs HL$(ZN HHT$(HHL$(`N LHH\$`HP_IcHT$WHPHD$ H\$`HHLHs HL$(M LHHAHL$(M HH\$`HP_H%M @SHPHD$ HL H@s HL$(}M LHHAHL$(M L H&s HL$(KM LHHAHL$(ZM LӮ Hs HL$(M LHHAHL$((M HP[@SH H7p A   E3HL HL LL;tHHL H [  HAL   MtIH@@HtH HH%P LI LYE3EIHL;AM;AEtHHAJICHA3H%P LAL9A ~HHAJI@HA3H%QP H   HD$PO Ht
333
 HĈ   HAH HA@SH HO HH HAHHIH9 uHAP0LnO 3L[H [H[O HC3H [HA H HA @SH HO HH HA HHI H9 uHAP0LN 3L[ H [HN HC 3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H3N HH HA0HHI0H9 uHAP0LN 3L[0H [HM HC03H [HA8H HA8@SH HM HH HA8HHI8H9 uHAP0LM 3L[8H [H{M HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH HL HH HA@HHI@H9 uHAP0LL 3L[@H [HL HC@3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH HK HH HAPHHIPH9 uHAP0LK 3L[PH [HK HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH HK HH HAXHHIXH9 uHAP0LJ 3L[XH [HJ HCX3H [HA`H HA`@SH HJ HH HA`HHI`H9 uHAP0LnJ 3L[`H [H[J HC`3H [H\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _HAHH HAHHAXH HAXHAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH HI HH HAHHIH9 uHAP0LH 3L[H [HH HC3H [HA H HA @SH HH HH HA HHI H9 uHAP0LnH 3L[ H [H[H HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH HG HH HA(HHI(H9 uHAP0LG 3L[(H [H{G HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH HF HH HA0HHI0H9 uHAP0LF 3L[0H [HF HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH HE HH HA8HHI8H9 uHAP0LE 3L[8H [HE HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH HE HH HA@HHI@H9 uHAP0LD 3L[@H [HD HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH H3D HH HAHHHIHH9 uHAP0LD 3L[HH [HC HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH HSC HH HAPHHIPH9 uHAP0L.C 3L[PH [HC HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH HsB HH HAXHHIXH9 uHAP0LNB 3L[XH [H;B HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH HA HH HA`HHI`H9 uHAP0LnA 3L[`H [H[A HC`3H [H(   Hr
30  HA HO E38  LHuH(H@ ICH@ H H@ IC H@ H H@ IC0H@ H H@ IC8H@ H H@ IC@H@ H H@ ICPH@ H H|@ ICXHq@ H Hg@ IC`H\@ H IH(H\$Ht$WH HHIIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH Hc? HHIHCHQ? H Ht
HuHAP0H5? HK HC H&? H Ht
HuHAP0H
? HK0HC0H> H Ht
HuHAP0H> HK8HC8H> H Ht
HuHAP0H> HK@HC@H> H Ht
HuHAP0H> HKPHCPHz> H Ht
HuHAP0H^> HKXHCXHO> H Ht
HuHAP0H3> HK`HC`H$> H Ht
HuHAP03H [H\$WH HH= HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _H\$Ht$WH HHIIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht	HօunHK8Ht	Hօu\HK@Ht	HօuJHKHHt	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH H< HHIHCH< H Ht
HuHAP0He< HK HC HV< H Ht
HuHAP0H:< HK(HC(H+< H Ht
HuHAP0H< HK0HC0H < H Ht
HuHAP0H; HK8HC8H; H Ht
HuHAP0H; HK@HC@H; H Ht
HuHAP0H; HKHHCHH; H Ht
HuHAP0Hc; HKPHCPHT; H Ht
HuHAP0H8; HKXHCXH); H Ht
HuHAP0H
; HK`HC`H: H Ht
HuHAP03H [H\$WH HH: HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _@SH 3Hy  L
: t=H Hc
 H3HCHCHLCH   9 HH [3IA0  HHuH [H\$WH H9 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
l Hz  @ǅtH@ H
D H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH H8 HHIHCH8 H Ht
HuHAP0H8 HKHCHv8 H Ht
HuHAP03H [@SH 3Hy  L
. t=H Hc
 H3HCHCHLCH   7 HH [3IA0  HHuH [H\$WH H7 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
` Hz  @ǅtH0 H
8 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH 3Hy  L
 t=H Hc
r H3HCHCHLCH   @6 HH [3IA0  HHuH [H\$WH H5 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
đ Hz  @ǅtH H
 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH H5 HHIHCH4 H Ht
HuHAP0H4 HKHCH4 H Ht
HuHAP03H [@SH 3Hy  L
 t=H Hc
f H3HCHCHLCH   04 HH [3IA0  HHuH [H\$WH H3 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
 Hz  @ǅtH@ H
 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H   H:    2 Hh Hu y  7 Z  `  H    x2 H Hu΄ {    Z  )  H    A2 HZ Hu   ɍ 	[    H    
2 H3 Hu`    [    H    1 HL Hu)   [ [    H    1 H Hu   $ *[  M  H
1 LHl1 HM Hu K   5[    H
p1 LH41 H Hu K   8[    H     0 H6 HuK U  } C[    HY    0 HG Hu   F N[  o  H"    0 H` Hu݂    Y[  8  H    P0 HA Hu   ؋ d[    Hć    0 HR Hu-H h     o[  H HĘ   H1    / H/ Hu-HK     O z[  H HĘ   Hn    / H Hu-H  ҁ    [  He HĘ   Hˉ    8/ HY Hu-H  7   [  H HĘ   H؅    . H Hu-Hj < ;  n [  Hσ HĘ   H    . H Hu-H  O  # [  H HĘ   H    W. H8 Hu-H    ؉ [  H9 HĘ   H    . H Hu-H [    [  H HĘ   Ht    - H Hu-H>    B [  H HĘ   H    v- Ho Hu 2    [  '  H    ?- LH% Hu l  Ĉ [    H` H) A   HT$hD$`l  HD$XHr E3HD$PHK HD$HHD$@L\$8HD$0HD$(HT$    , H Hu l  8 [  a  H\ L
5 L H߅ H$   H  HD$xH    HD$pH˄ HD$hHg HD$`HS HD$XH HD$PHK HD$HH HD$@H# HD$8H HD$0H HD$(H HD$ + LHr Hu[ [  }L H A   LD$hD$`o  HD$XH AQ
AHD$PH HD$HHD$@L\$8HD$0HD$(LD$ E3Z+ H Hu-܆ [  } o  H H, HĘ   3HĘ   H\$WH HH
 HAL   MtHAL@@Mt	HW A	H9+ HHuH
* LG H H	&- HH\$0H _HB   s HAL   Mu
L@@MtH IH%* LH
&* H? H	H%, H\$Hl$Ht$WH H) MHH(IHE3MH) HHtT3H~&     HHHH H;HCHp  |3H) EHHu
HWHR0MHH\$0Hl$8Ht$@H _DD$HT$HL$SUVWATAUAVAWHhLiHyHq 3Ll$PH|$XIMcLMtI( LLH( HAH( HH( 9J~H
6 ( t3  HtMuYA}CuRHuE9}uMLIIHK  Eu)Ht$LFIcEI;uHVLIbH  H   K$( HH   LpH$   HMNMLH$   ' tQMM~f     IE IH$   H IO,H M}MMH' uLl$PD$   IHH+HLHLH$   HH(Ht
HFH^HL$   HT$XHL$HD$@H\$8Dd$0E3ILt$(D|$ 5' HHtHu
HGHP0H' HHIHhA_A^A]A\_^][H\$Hl$Ht$WH HAIHH   HHu& H& HAH& HH}& 9J~H
7 q& t3ELHHH
w& HHJHu"& HuH
& H H	( HH\$0Hl$8Ht$@H _H\$Ht$WH HAHqHHxH& HAH% L H% A9H~#H
͗ % t3H\$0Ht$8H _HHH
% HHJHu"% HuH
Z% H H	
( Ht$8HH\$0H _H\$Ht$WH H   H0% HHuH\$0Ht$8H _HE3HHHx#HHu
HSHR0H\$0Ht$8HH _HT$SHPHAHH;$    H$ Hl$`HiHHt$pHqH|$xHy BH$ HHi$ 9J~(H
 ]$ tH|$xHt$pHl$`3HP[Ã~Cu!Hu~uDGHT$hLHUNLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(LL$hHE3HD$    # H
# H|$xHt$pHHl$`JHP[H;|# uHA@tHP[@HP[@SHPHAHH;4#   Hw# Hl$`HiHHt$hHqH|$pHy BHO# HH# 9J~(H
 # tH|$pHt$hHl$`3HP[Ã~Cu:Hu9~u0LE33HfLGHcFI;uHWLHHLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(HE3E3HՉD$ " H
" H|$pHt$hHHl$`JHP[H;" uHA@t3HP[%Hw E3HP[AE3MMEAMADtMyLMHMyLL;LOM+M33H%|! HD$8IIHtLD$0HLL$0LD$(H%[! @SH HHH
{ '! Ht	H H [HH [@SH0HBIH;  t=H;  t4H;  t+3H;! LH=z HDHD$ L  H0[  HHDH H0[LH
f! H' H	H%# HLH
2! H	H= L
O H LDH%O# H\$WH LQHHyPHYXHQHLAPLIXMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _HAHHHAPI HAXI3HAHHAPHAXHAWH@|$x HXHhHpHxL`LhHLpt DAH H(3LeHLmPLuXHEHHEPHEX9D$pt6MtI$MtIE MtIMMIH    H HMHHuPH}XLeHLd$0LmPLl$(LuXLt$ Hl$XHHt
HuHQR0HtHu
HFHP0Ht$`HtHu
HGHP0H|$8HuH
  H Hu
HCHP0|$x H\$Pt	A  H@A_HHLT$pM;}	H 
MH LT$0HO; L
 LDIHN HDHА HD$(LD$ LH
t H	  HH@SH HH& H
? H H	LLH [H%k  LI[IkVWATAUAVH03MMICICICH$   HMKH4MCISLI   f     LHT$hHM   IH9   HAHHuH HH9B   HB        MtiHH9tNH	 y' H  HT$ht'HH; u8H9 tHD$ H+HI  HD$ HH+HIH;    HH;   HH9G  H	 y Hf    HT$hHH;u   MtA HHHBH9AuB HT$huHH; uHD$ HH+HIH; u`HH;t9@ HH9   HHBH9Au    HT$hHH;uM   LD$ I    LL$ LD$hHT$(IL 3H\$`Hl$pH0A^A]A\_^H
 L$   HU H	 HT$hHY H HG HH H
Y L$   LH	 {LD$HT$HL$H(HtHLD$@HT$8HL$0H E3HtH;tHLD$@HL$0H LL$8Mt=L;t8I HL$@H^ H9AtH
 H H	    HL$0LL$@HA         LD$@HT$8HL$0 H LD$@HT$8LHD$0H\$HIIHIYXH|$ IyPIAHMAXIQPHt
HuHAP0HtHu
HGHP0H|$ HtHu
HCHP0H\$HH(L9L$8tH
 H H	 EHL$8HAHD$0H HY HHL$0S ,H
 H H	 HD$8HtHHL$8H9 uHAP0HD$0HtHHL$0H9 uHAP0HD$@HJHHL$@H9 8HAP0H(H\$Ht$WH03AHLD$XHT$ E3HHD$XHD$ A t:D  HD$XHH   rs]LD$XHT$ E3H u˅ukHL$XHtaO H
h H	HN LL 3H\$@Ht$HH0_H
9 H LH	n 3H\$@Ht$HH0_H\$@Ht$H   H0_@SH HHu3H [H|$0w HHu
HSHR0HH|$0H [Ht$WH 3HHLAtHALEt]L;VϋMuHHH\$01 HHtHH HHu
HSHR0HH\$0Ht$8H _JDHt$8H H _H\$Hl$Ht$WH 3HHE   HAH;H    H;C uDHDƋAEDuHQ9t$PtH;W΋H   HD   HhhH   H9u   EtGHyBHE Ht9HxHHHU   H
L H	 u3    HHUsHҋ΋EuHW9t$PtJH;W΋Hu5H HHtHHW HHu
HSHR0HHGHH H\$0Hl$8Ht$@H _H;uH H H HAH;n uD9AtH H H H; u0LIIHH3H+HMt
AIu3A;uH;l uAfAnf.zulA   H%J H\$Hl$Ht$H|$ ATH`H 3LH9AP  HiHC  HYH H9C   H LcHs Hl$PHkHT$XHAH HH 9J~H
D     }Cu!Hu}uDFHT$PMHLHS(Ht
HNHFHHHT$HL$@HD$8|$0LL$PE3IHH|$(D$    ; HH9 HIa    HHtNHE HhI$L` HE3HHHHu
HVHR0HuHSHR0HL\$`HI[IkIs I{(IA\H\$WH HAIL   MtAH@@HtH  HHt,HHHHu
HCHP0HH\$0H _3H\$0H _H(H
 H9AuSLI LYE3EIHL;AM;AEtHHAJICHA3H(p y,H(LHj 
HHtH uH@P03H(HA`HHAhI HApIHHtH I HtH IHtH H\$WH LQ`HyhHYpHQ`LAhLIpMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _LI[IkVWATH0HAHE3IICHAPHICHAXHLaXLaHLaPIKMCISICI L9fHtlHD$ Le L'L#HtHHL$ L9!uHAP0HD$(HtHHL$(L9!uHAP0HD$PHtHHL$PL9!uHAP0   HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHM LHHV`H~hH^pHN`LFhHFpHtHu
HBHP0HtHu
HGHP0HtHu
HCHP03H\$XHl$`H0A\_^H\$Hl$VWATAVAWH@3LH
>i HAELL   HHMtHcf AH+H@@HtHKf H HH9f k HH   Mu3B
 HHtwLH
Xj Ll$p-
 LHtU'
 HHtGA
 LHt6Hl$0HD$(LMIHLt$  I$HuIT$IR0Ll$pHu
HVHR0HtHu
HCHP0HtHu
HGHP0H\$xHH$   H@A_A^A\_^H\$WH HAHL   MtAH@@HtH 7 HHu/H
 H	w tH
 LG H H	 HH\$0H _H\$Hl$Ht$WATAUAVAWH LaHLiPLqXE3HLyHLyPLyXH
e o Hg HtHr HfH
fe HAL   MtAL@@Mt	H AI
 HHt@H H=Q HE=O Hu
HCHP0HtH
 AE$[ L HEg H
d A
 HNHH~PH^XLfHLnPLvXHt
HuHAP0HtHu
HGHP0HtHu
HSHR0H\$PHt$`Hl$XH A_A^A]A\_H\$E3DRHEExIcHD;D~H\$E~.AA+Ù+EIcHLD;}E~#EYE;|IcHD;DA~AAH\$H\$A@WH Dt;H=f Ht/f HI;f }HHD9Du
HH H _3H _̅Q  H\$Hl$ WH Hf HHuH   	 H  hH8HHTf Ff @   8f    H\$@Hl$HH _Ht$05f DHˋLd$8LcD;}*IH9luHH<H   HAP0   e ;u.p@HHcHd HHt\5e 5e He LcIM;~(MILL+IAIIIAIAIAuHƉlH<H5Xe Ht$0Ld$8H\$@Hl$HH _H\$Hl$Ht$WHpHIA HHtAtL H
~ DHu 	Hj HHu(Hu
HCHP03L\$pI[IkIs I_H[^ H
4a E3HL$hl$`H|$XH\$PHD$HHD$@HD$8HD$0HD$(HL$ E333 HHu
HSHR0Hu
HWHR0HpHl$H|$ ATAUAVH H- MAL LtItDADH\$@Ht$HEt6H5c Ht*c H΋;}HcHD9Du	HH,MDŋIUHHthtHЋLa E3HI HHtHȉh| HtHu
HCHP0HtHu
HGHP0Ht$HH\$@Hl$PH|$XH A^A]A\H( H(H(F H(H(~ H(H(^ H(H(> H(H( H(H( H(H( H(Htfff     H   H;tHu3H;> ø   H;tMLX  Mt#MH3M~IHH9t-HHI;|3H   H;tHu3H; ø   @SVH(Hj Hl$@H|$HH(Ld$PLl$XLeHLmPLt$ LuXHEH    HEP    HEX    IHHti uHy uHHG uHW 3HMHH}PH]XLeHLd$PLmPLl$XLuXLt$ Hl$@Ht
HuHAP0HtHu
HGHP0H|$HHtHu
HCHP0H(^[H;u   HAH; t      t
   rH%{ L3H\$WH IHH;t\I;tWHAH;3 t;      t
   r% u*HH
 uH\$0H _H\$0H _/   H\$0H _Ht$WH HH
|  HHuHt$8H _H HWHH\$0 HH   HH      uH
 LGH| H	 %HG H9C t-H
l LGH| H	 Hu
HCHP03Hu
HFHP0Ht$8HH\$0H _H
D H	 t H  xHWLH  xHHH\$IMLI HHI`LZhLRpHB`IHBhHHBpIMLH\$@SUVH LQHHYPLYX3HHLT$XH\$@L\$PHAHHAPHAXMuVMtIHL$PH9uHAP0H\$@HtHHL$@H9 uHAP0H H H H3H ^][L M;   HuH H H L\$PLT$XqHK   sSH{|	H[HH H H} HD$@HHL$@H9 uHAP0L\$PLT$XL\$PLT$XI   H   MtIHL$PH9 uHAP0LT$XI
HL$XH9 uHAP0H3H ^][M M;tbIBH;
 t%      tA   rII
 
3Iu"LL$PLD$@HT$XHH ^][LD$PHT$@HL$X:
 Hs HL$@HH9AtHIH(
 tHD$PH|$HHtHHL$PH9 uHAP0HD$XHHL$XH9 uHAP0HL$@HAL   MtHS AH,L@@MtHR H AHHR   HHD$@HHL$@H9 uHAP0Ht#3H HHu
HSHR0Hu!E3E33HLe
 IH=[
 H>H|$H3H ^][H\$WH HQ Hy(HY03HA HA(HA0HtHu
HBHP0HtHu
HGHP0HtHu
HCHP0H\$0H _H
 H2x H	H%  H
 H2x H	H%  H(HtH
x  H	g  H(H\$VH AhHHمu2Ht-H;-
 t$H
<
 Hw H	D  3H\$8H ^Ãu"HtH
 H	
 3H\$8H ^Hy  H|
 H|$0H8tSHA0HtHHHGHtH HGHAHC LG`HWhHOpHG`HC(HGhHC0HGpLC HS(HK0A2HG`HC HGhHC(HGpHC0HC HtH HC(HtH HC0HtH LHHClSH|$0Cl H\$8H ^@SH HH   H
 HH9ZHuwH
 Ht$0H|$8L 3I HJHHrPHzXLBHHBPHBXHt
HuHAP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$8HH [H\$WH 3HHIHHD$0HtHGHHuHAP0H
 HT$0H	H\$0E3HHHHtHu
HSHR0HH\$8H _@SH HHIH{l tH
 Hu H	
 3H [HtYClHAH;W u H;j
 u   LHS QCl Hu.HHHH [0E3HHHH [H\$Hl$Ht$ ATH HlV 3HLH9BuH  HH      AlHBH|$0L   MtHS HAH2L@@MtHS HH AHHoS H
 HHu%H
 H	
 u	HQ
 
 '3H
 HHu
HGHP0HDH|$0AD$l HtHu
HSHR0H\$8Hl$@Ht$HH A\@SH HHIH{l tH
 Hs H	
 3H [Ht4ClHAH;U u   Cl HuHH [HN
 E3HH [H\$WH yl HYHHt$H
2
 Hr H	2
 3H\$8H _HtIHHHt$0HOHHtHGH    HuHQR0Hu
HCHP0Ht$0uH
 H	
 3HDB9Ht4H u
HPHR0H
 H>r H	
 3H\$8H _R
 Ht*LF
 H'
 HM H
 H
 H\$8H H
 H _LL$ LD$SUWH0yl HYHHHt!H
 HAq H	
 3H0_][Ht$PH   HH
 t$xL I;t?HBH;g
 t$      t
   rIHK
 
3Ht|txHH<Hu
HSHR0HOHHtHGH    HuHAP0xLD$hHT$`E3HE33HHHHt$PH0_][GlHCH;HR u+HD$pLL$hLD$`HHˉt$(HD$ H  L   MtHP HAH2L@@MtHP HH AHHP H
 HHucHu
HCHP0H
g
 H	
 uHt$PGl3H0_][
 HOHHtHGH    HuHAP0Gl HT$pHtH
 H"LL$hLD$`HHHD$     
 HHu
HFHP0Gl Hu
HCHP0HuH HHLI[WHP3HA   IC ICICICIC HICICEAHse HIC
 u
3H\$`HP_LL$pLD$xHT$@HD$(   H\$ H\$`HP_H\$Ht$WH HHIIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _H\$WH HHI3HtH{HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP03H\$0H _@SH H
 H{8 t	H
 {h |&H
 L[HAx  H; H
 HH|
 H [@SH yh H   H   H
 Hl$0Ht$8H03HnHH|$@H~PLd$HLfXHFHHFPHFX9AhuHt0HHu)
 HtH+
 
H uH@P0MLHHHHLd$HH|$@Ht$8Hl$0tHH [HAPHHD
 H H(LHt2HB   s$HIPHIPPHt
HuHAP03H(H
s
 HLk H	{
 H(HAXHHD!
 H H(LHt2HB   s$HIXHIPXHt
HuHAP03H(H
 Hj H	
 H(@SH HHQLAMtI 3Al AhHA@HAHHA HA(HA0HA8HD$PHtH HAXMtIHD$XLIPHtH HA`
 HH [H\$Ht$WH0HHU
 HH   L
 H;j H
    L[K H4j Hs
    H4j LHX
 xpLmI Hj H=
 xULLú  HHD$     $
 Ht3H u
HPHR0HuiHCHP0HH\$@Ht$HH0_Hu
HCHP0H3
 H
 Hi H	A   
 yHu
HGHP03H\$@Ht$HHH0_Hi H(=L     H
j 
 Hu13
 H
.
 Hj H	A    
 y6H(Hi H+L    HHtH uH@P0H
j q
 Ht+Hh HHtH uHPHR03H(
 3H(H(HU
 H
 H' HH
 Ha HI HH(H  A   L l H$  AQD$    
 
 L H$  LȺ   
 D$  D8$  u$  8$  u
3H  H$  L$  Lk HD$(H~k HL$0   HD$ I
 HT$0A   3n
 H  @SH 
 HHuH [HH|$0
 HHu
HSHR0HH|$0H [H\$Hl$Ht$H|$ ATAUAVH  EILL
 HH<  H
 HHu
HWHR0H  I
 HH   HH
 HHu
HVHR0Hu
HSHR0H   HG      uH
 Hj MH	M
 |HG EuGH;vEHl$0HD$(Lj HL$@Mͺ   Ld$ 
 HT$@E33
 x1HMH;tH
$
 Hj MH	MHl$(HD$ D
 HuHGH
Hu
HCHP03L$  I[ Ik(Is0I{8IA^A]A\@SH H9 Hte{  HKtHSE3H
 {" t
 
HSH
 HHHH9 t&H	
 u
 H(H; u3H [ÃH [H\$WH HH<
 HHIH;t6
 u,HT$0LH
 HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H
 H\$8H _H(E3H;
 AH;
U
 AH;
 AAu
 H(@SH0HAHH
$
 L@H	LLD$ LHi M
 Hu
HCHP03H0[@SH HA3ۋ         H@`H|$0HtbH   HtH= HH   Ht<H=h HHt+HC   r=r7HHH|$0H [
,
 HuH
0
 HYh H	8
 HH|$0H [HHH [H(HAH;
 u	HcAH(H;?
    LAIHH3H+HMtA3I   HH(IIw;HB  HAIHHH(ËAIHHHH(H(H%f
 H\$0c
 HHuHH\$0H(HH|$ G
 HHu
HSHR0H\$0HH|$ H(f    j        X      HT$tHHHD$LD$HكH;HL$IMH HT$tHHHD$LD$HكH;HL$ICH H\ H+\ HH\$Ht$WH`H
 )|$@3D)D$0D)L$ HHD
h 8HA H+AHfAWHtTH;r
 HOH@f/v#HG H+HH;rz
 HOHxHG HH+HH;rHO fEWH+OHH   )t$Pfff     HY
 0H;r
 H_fAWH@f.zt1HG H+HH;r
 H_H@\V	 DXHO HH+HH;r(t$PfA(;	 H\$pHt$xD(D$0D(L$ X(|$@H`_LD$HL$WH0HD$ H\$XIHD$H    H HHQHIR
 D$H   H8
 HH\$XH0_H\$Ht$WH L   HIL+   IgfffffffHIIHHH?HH;r2H\$0Ht$8H _H   IH+   HHHH?HH;r
 H   HHH
 H\$0Ht$8H _HL$WH0HD$ H\$HIMHLAHy rLYLYE3AHAMtHyIHHIHMyMM;MOL+M33%
 H6LHD$hHtLD$`IIHLL$`LII
 HH
 HH\$HH0_H(HB   s'HAL   MtAL@@Mt	H A
 Hu9L
 D@`H
 _
  O4 `   = _
  L
6 e3H(HT$HL$SVWAUH8Li3339Yht3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'H 3 i   < 
  H_6   
 LHu'H 3 i   < 
  H*6 a  IEHHHuEH
 L HR H	
 Lk E3 i   L5 p< 
    HAH;
 tyH;
 tpH
 HHu'H
 2 i   (< 
  H
5   H@L   Mu2H 2 i   ; 
  HR5   H3HE3LdD  MuFH
 H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AH
 H	
 HHtdHu
HSHR0IULI3F
 uHu
HGHP03H ^1 i   : *  H3 (  H] 71 i   i: '  H3   H
 L HO H	/
 L 0 i   L3 : $     
 HtH
 HHty1
 Hu
HFHP0H\$`HL$hLK0LC(HS HHC0    HC(    HC     ChLt$(Ld$0Hl$pIL|$ H8A]_^[HW 10 i   c9   H2 MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
f2 D/ 8 H
b HHHATAUH8HXHhHp HxE3LpLxHBLMIH;
 t|H;
 tsHH2
 HHu'HK %/ m   W8   H1   H@L   Mu3H . m    8   H1   HHIMHl MuFH
 H9GuH;w  HGHH\HH,H;w   H] HHHHAHH   ILHt
HuHQR0HI
 HHtVHL$PLI.
 tHWHCHP0HH! - n   -7 	  H0    H - n   7   Hg0    
 HtH
 HHtb
 Hu
HGHP0L-L
 IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\HP *- m   \6   H/ Hu
HGHP0HtHu
HCHP0L
/ D, 6 H
u  SH\$Hl$Ht$WH H/ HH

 E333HHu'H z, q   5 S  H
/ a  HCH=5 HL   MtAL@@Mt	H AI
 HHuW5 U     HC
 H9C&  H{H  HsHHHHHuHAP0HH\HHuH
ݒ 4 b  H
T. QHu
HGHP03Hu
HCHP0   
 HH   4 i  H H. HE N+ q   u
HEHP0HtHu
HFHP0HtHu
HCHP0HtHu
HWHR0L
- D* +4 H

 3cH賴HH/3 e  QH
A4 HHHHh Hp(H
k
 HH
a
 HH0H
V
 HH
L
 HH8H\$0Hl$8Ht$@H _H(IL$0g
 Hu9L
S D@PH

   * P   O3   L
, 33H(H(y tH
 H H
 H
 H H

 Hu9L
֐ D@QH

   ) Q   2   L
3, 3H(H\$WH E3H;
 HAE3H;
 A3H;
 DEuHB
 DEÀuR
 HtGL
* H

 
  AQ   ( Q   $2 
  L
+ H\$0H _È_H\$03H _HAH HAH\$WH LJHHL;
 trH;<
 tiH
K
 MIL8
 H	H6
 x
 L
a H
J
 c
  AR   L
* "( R   T1 c
  ?H\$0H _HHAHHIH9 uHAP0H_H\$03H _@SH H
 HH HAHHIH9 uHAP0L^
 3L[H [HK
 HC3H [HA H HA H\$WH LJHHL;
 trH;
 tiH
 MILt H	Hv (
 L
 H
 
  AS   L
) & S   0 
  H\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH H3
 HH HA HHI H9 uHAP0L
 3L[ H [H
 HC 3H [H(A(
 Hu9L
 D@TH
   % T   /   L
r( 3H(@SH0H
 )t$ HH9Bur
Hm
 f(f.5! zTuRG
 HtGL
 H
 <  AT   K% T   }. <  L
' a(t$ H0[s((t$ 3H0[HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH HC
 HH HA0HHI0H9 uHAP0L
 3L[0H [H
 HC03H [HA8H HA8H\$WH LJHHL;
 trH;
 tiH
 MIL	 H	H~
 
 L
ъ H
   AV   L
@& # V   ,   H\$0H _HHA8HHI8H9 uHAP0H_8H\$03H _@SH H
 HH HA8HHI8H9 uHAP0L
 3L[8H [H
 HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH H
 HH HA@HHI@H9 uHAP0L
 3L[@H [H
 HC@3H [H(AH
 Hu9L
 D@XH
	   ! X   *   L
R$ 3H(@SH0H
 )t$ HH9Bur
HM
 f(f.5 zTuR'
 HtGL
c H
   AX   +! X   ]*   L
# A(t$ H0[sH(t$ 3H0[HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH H#
 HH HAPHHIPH9 uHAP0L
 3L[PH [H
 HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH HC
 HH HAXHHIXH9 uHAP0L
 3L[XH [H
 HCX3H [HA`H HA`H\$WH LJHHL;
M
 trH;
 tiH
 MIL H	H 
 L
х H
   A[   L
@!  [   '   H\$0H _HHA`HHI`H9 uHAP0H_`H\$03H _@SH H
 HH HA`HHI`H9 uHAP0L
 3L[`H [H
 HC`3H [H\$Ht$WH H5! H
$ HH
 HHtH H2HHu'H } m  &    H     H
 H9CuHH 
 HHuH
Y o&    H
 .E3HH蘣HHuyH) ?&    H H m  u
HGHP0HtHu
HCHP0L
j D % H
 3H\$0Ht$8H _Hu
HWHR0Hu
HSHR0H\$0HHt$8H _H\$Hl$Ht$ WATAUH@3MHHH\$pM   LjIMtH   HZH\$pI?
 HMu H" I
 HHD$pHtPHH   H LL$pH HD$(E3ILl$ ny$  YH\$p   Hzt}HGH
_
 L
; H	HD$0H
 HD$(Lm H~; HD$    o
 $  L
S H
\ A  `$    L
 :%HZHHEHHMH9 uHAP0H]3H\$`Hl$hHt$xH@A]A\_HT$HL$SVWAUH8Li3339Yht3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'H l   # {%  H   l
 LHu'H] 7   i# |%  H a  IEHHHuEH
 L H8 H	"
 L    L # ~%    HAH;(
 tyH;'
 tpH
 HHu'H
    " %  H
)   H@L   Mu2H _   " %  H   H3HE3LdD  MuFH
 H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AH{
 H	p
 HHtdHu
HSHR0IULI3
 uHu
HGHP03H$    0! %  H (  H~    	! %  Hj   H
F
 L HX6 H	
 L~    L/   %     J
 HtH>
 HHkty
 Hu
HFHP0H\$`HL$hLK0LC(HS VHHC0    HC(    HC     ChLt$(Ld$0Hl$pIL|$ H8A]_^[H}      %  Hd MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
 D[  H
Z
 uHHHATAUH8HXHhHp HxE3LpLxHBLMIH;Z
 t|H;Y
 tsHH
 HHu'H|     `&  HX   H@L   Mu3H|     b&  H!   HHIMHl MuFH
 H9GuH;w  HGHH\HH,H;w   H] HHHHAHH   ILHt
HuHQR0HIg
 HHtVHL$PLI
 tHWHCHP0HH{     &  H.    H{ t    &  H    ,
 HtH 
 HHMtb
 Hu
HGHP0L-
 IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\Hz     }&  H] Hu
HGHP0HtHu
HCHP0L
1 D  H
 蠸SATAVHHH H\$`Ht$pH H5U L5 H|$@L|$0LH
" E3HI#
 HHtH H螕HHl$hLl$8Hu'Hz     &  Hr 9  HCL   MtH HAH2L@@MtH HH AHH H
 HHu'Hy _    &  H z  Hu
HCHP0Hf
 LnII9E   H^H  HnHHHE HHuHAP0H
 LmI9E    E3HT$ HEAH\$ Lt$(HHu'Hx     &  H=   Hu
HCHP0IHu
IE HP0HE Iu
HEHP0   
 HH  H[x 5   g '  H :     p
 HHu'H
!x    - '  H
   HXIE3HHLp IEHHu'Hw     
'  HC   Hu
HGHP0IIHHHHw Z    &  H _  IGH IGHEIGL   MtH IAH1H@@HtH IH HH I
 HHu'Hv     "'  H_    H
 IH9G4  H_H'  HwHHHHHuHAP0HHHHu$Hzv T    /'  H \Hu
HCHP0IHu
HGHP0   o
 HH   Hv    ( 6'  H HtHE u
HEHP0HtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L
- D  H
Q 蜳~HBHH,Hou I   { 2'  H NH LH HGHo Hw(H߻
 H Hջ
 HG0Hʻ
 H H
 HG8L|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@VWAUH0HA3LL   MtH AH,L@@MtH H AHH j
 HH\$PHl$XLd$`Hu'HLt &
    X 2)  H   H=
 Lg3I9$c  H_HV  HoHHHE HHuHAP0H
 LeI9$   E3HT$ HEAH\$ Ll$(אHHu'Hs      E)  H   Hu
HCHP0Hu
I$HR0HLd$`Hl$XH\$PH0A]_^ù   
 HHu'H
3s 
    ? S)  H
    HXIE E3HHLh 3WHHu$Hr      Y)  HU RHIHFHP0:IHHH#Hr n     ?)  H Hu
I$HP0HtHu
HCHP0HtHu
HVHR0L

 D K H
 /3H\$VWAUH0H= LH
 H3׷
 HHtH HRHHl$PLd$XHu'Hq 
 Q   =0  H&
   HCHkL   MtH6 HAH2L@@MtH HH AHH HD
 HHu'H5q 
 Q  A ?0  H T  Hu
HE HP0HGL   MtH HAH2L@@MtHk HH AHHU H
 HHu'Hp 	 Q   B0  H   Hu
HGHP0H
 Hk3H9E d  H{HW  LcHHI$HIuHAP0H4
 Il$H9E    E3HT$ IEAH|$ Ll$(LHu'Ho  Q   V0  H]   Hu
HGHP0Hu
HU HR0ILd$XHl$PH\$`H0A]_^ù   ʵ
 HHu'H
{o U Q   d0  H
    HxIE E3HILh 3蟎LHu$H0o 
 Q  < j0  H
 RHIHFHP0:IH_LH#Hn  Q   P0  HI
 Hu
HE HP0HtHu
HGHP0HtHu
HVHR0L

 D]  H
 w3ATAVHHH\$`Ht$pH|$@H= E3L|$0LH
  HMI
 HHtH H|HHl$hLl$8Hu'Hm  T   0  HP	 G  HCL   MtHd HAH2L@@MtHI HH AHH3 Hr
 HHu'Hcm = T  o 0  H   Hu
HCHP0HGL   MtH HAH2L@@MtH HH AHH H
 HHu'Hl  T   0  H@ 
  Hu
HGHP0H
 LkII9E   H{H  HkHHHE HHuHAP0Ha
 LmI9E    E3HT$ HEAH|$ L|$(MHHu'Hl  T  * 0  H H  Hu
HGHP0IHu
IE HP0H
 L|HH  Hk  U  
 0  H&      α
 HHu'H
k Y T  
 0  H
   HxIE3HHLx I裊HHu'H4k  T  @
 0  H ^  Hu
HFHP0IIHaHHHj  T   0  HK   HDy'Hj  U   0  H    Hu
HCHP0E*  HEL   MtH HAH2L@@MtH HH AHH H
 HHu$Hj  U   0  H| LH	 E3H@HHu~Hi  U   0  H> Hu
HCHP0HtHu
HGHP0HtHu
HFHP0L
 DR  H
Q  lHu
HCHP0HHE LL|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@SH HAL   MtH3 AH,L@@MtH H AHH 
 HHt$0H|$8Hu'Hh c X  
 ?1  H   Hz
 3H9C   H{H   HsHHHHHuHAP0HH葉HHu$Hh   X  
 L1  H eHu
HGHP0Hu
HSHR0HH|$8Ht$0H [HzHHuHg   X  	 O1  H HtHu
HCHP0HtHu
HWHR0L
 D<  r	 H
 VH|$8Ht$03H [@UATH(HAH\$@E3L   Ht$HLl$ LIIMtHF  AH,L@@MtH.  H AHH  
 HH|$PHu'Hf { [   1  H   {
 HHu'Hlf F [  x 1  H       
 HHu'H
2f  [  > 1  H
    IE LhH LH
 y$He  [   1  HY LHu
HCHP0H LH
HHuIHe x [   1  H Hu
HFHP0HtkHueHGHP0YHu
HFHP0Hu
HGHP0IHH
 HHuYHe  \  * 1  H  HtHu
HCHP0L
o  D  H
 ޢLLl$ H|$PHt$HH\$@HtHE u
HUHR0IH(A\]H\$Ht$H|$ ATAUAVH@H= LH
6 LHM35
 HHtH HHHl$`Hu'Hd  _  ( &2  H   HCL   MtH HAH2L@@MtH HH AHHl H
 HHu'Hc v _   (2  H	   Hu
HCHP0HGL   MtHU HAH2L@@MtH: HH AHH$ H
 HHu'Hc  _   +2  Hy   Hu
HGHP0H
 33H9Cu+H{Ht"HCHHH HHuHAP0   H
 H9C   HcHT$(DEHE3HH+H|$ Lt$(Ll$0Ld$8}HHu'HNb ( _  Z =2  H    H#  H  HGHP0
  EHc@
 HHu$H
a  _   K2  H
^ dHtHx3IHcE3LtIE Ll I$HHLd(HH   Ha e _   Y2  H Hu
HCHP0HtHu
HGHP0HtHu
HVHR0L
 D B H
 &3#Hu
HVHR0Hu
HSHR0HHl$`H\$hHt$pH|$xH@A^A]A\AVAWH8HAE3H\$PL   Hl$XHMMtHf AH,L@@MtHN H AHH; ]
 HHt$`H|$0Ld$(Ll$ Hu'H:`    F o4  H ]  H+
 IH9C   H{H   HsHHHHHuHAP0HHAHHu'H
_     |4  H
/   Hu
HGHP0IHu
HCHP0HIu
HFHP03T
 HHu^HU_ /   a 4  H 9  HHHuH_    * 4  H   HM H;
 u>H
 H
 H	
 L^    LJ   4    H 
 HHu'H^ q     4  H {  H@H;
 t|H;
 tsHH,
 HHu'HE^    Q  4  H )  H@L   Mu3H^      4  H{   HHIMHu
HCHP0LdMuFH	
 H9GuH;o.  HGHH\HI,H;o  I$HHIHAHH   ILHt
HuHAP0HQ H
 HHtoHNH9N ~H HFHHAHFHH
 uH:HCHP0+H\     4  H^    H\     4  H7    \
 HtHP
 HH}tk
 Hu
HGHP0HHLu
HFHP0Ll$ Ld$(H|$0Ht$`Hl$XH\$PMtIu
IWIR0IH8A_A^H\    # 4  H HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
> D  H
r
 譙;HHHATH   HXHpHxLhLpE3LxHALL   L$   ML$   Lt$ L$   IIMtH AH,L@@MtH H AHH 
 HH$   Hu'HZ     8  HJ >  HΟ
 IH9C   HkH   LcHE HI$HIuHAP0HI{LHu'HcZ =   o 8  H U  HE u
HEHP0IHu
HCHP0I$uID$IP0IEL   MtFH IAcH|LHuHY     8  HD   L@@MtH IH AH I
 Hu'HY Y    8  H   L%  H
1 H$   I0
 HHtH ItHHu'HY    ( 8  H   HCL   MtH HAH2L@@MtH HH AHH H
 HHu'HX v    8  H	   Hu
HCHP03T
 HHu'HUX /   a 8  H G  IM H;
ڞ
 u>H
 H
 H	
 L
X    L  8    H E
 HHu'H
W     8  H
;   H@IH;
 t{H;
 trHM`
 HHu'H
yW S    8  H
 k  H@L   Mu0HBW    N 8  H 4  HHMHu
HGHP03NlfMuFH<
 H9FuL;f:  HFIJ|HI,L;f  I} IHIHAHH   H$   H$   Ht
HuHAP0HJ Hٛ
 HHtmHKH9K ~H HCH<HAHCHH6
 uHu
HGHP03#HV    (  9  H   HU     9  Hb 
  
 Ht H{
 HH託   

 Hu
HFHP0H
 E3LmII9E x  HuHk  LeHHI$HIuHAP0HU
 Ml$I9E    E3HT$(IEAHt$(H\$0@rLHuNHU     69  H~ 
  HT     9  HW   Hu
HFHP0HI   HCHP0      Ӛ
 HHu'HT ^    F9  H v  HpE3HIIHX sLHu'H<T    H L9  H K  Hu
HGHP0IJHHluLHu'HS     /9  HZ   Hu
HCHP0HE u
IE HP0H
M L$   HxHHu'HS c    \9  H   H@L   MtH* HAH2L@@MtH HH AHH H
 HHu'H	S     ^9  Hv   HE u
HEHP03
 HHu'HR     a9  H. 
  H$   HI H;
>
 u>H
M
 Hf
 H	U
 LnR H   L s e9  }
  HG 
 HHu'H2R    > g9  H $
  H@H;O
 txH;N
 toH˙
 HHu'HQ     m9  HQ 	  H@L   Mu3HQ     o9  H 	  HHMMHu
HCHP0NdMuFH
 H9FuL;~<  HFIJ\HI,L;~  I$IHIHAHH   H$   H$   Ht
HuHAP0HF HE
 HHtoHMH9M ~H HEHHAHEHH
 uH0HCHP0!HP `    9  H x  H_P 9   k 9  H Q  
 Ht H
 HH   t
 Hu
HFHP0H
 LoII9E x  HwHk  LgHHI$HIuHAP0H
 Ml$I9E    E3HT$8IEAHt$8Hl$@lLHuNH~O X    9  H   HWO 1   c 9  H I  Hu
HFHP0HE Iu
HEHP0I      @
 HHu'HN     9  H^   HpHh E3HIIInLHu'HN     9  H   HuZHCHP0NHHoLHu'HZN 4   f 9  H i  HE u
HEHP0IHu
IE HP0H
 Ld$ rHHu'HM     9  Hc   H@L   MtHW HAH2L@@MtH< HH AHH& H
 HHu'HvM P    9  H   Hu
HGHP0HW
 LkII9E   H{H  LcHHI$HIuHAP0H
 Ml$I9E    L$   E3HT$HEAIH|$HL|$PiLHu'HL     9  H%   Hu
HGHP0IHu
IE HP0IL$   MHuHAP0H
 D90  H$   
 HH  H(L    4 
:  H M     =
 HHu'HK     9  H[   L$   HxE3IHILx I
kLHu'HK u    9  H   HE u
HEHP0IL$   HIlLHH<K    H 9  H .  I
 Hu'HK     :  Hs +  H;t7H
 H	
 LJ    LA  :    H
K NoHHu'HJ i    :  H   H@L   MtH HAH2L@@MtH HH AHH H
 HHu'HJ     :  H|   Hu
HCHP0   Ď
 HHu'HI     ":  H2   I$H@HL$ L HHCHHH
 LmII9E K  H}H>  LeHHI$HIuHAP0HH
 Ml$I9E uvE3HT$XIEAH|$XH\$`7fLHu'HI     <:  Hu    Hu
HGHP0H  HCHP0u     
 HHu'HH     L:  H    HxE3HIIHX gLHu$H]H 7   i R:  H oH   HFHP0   HHiLH   H	H     5:  Hv HtHu
HCHP0E3E3HtHE u
HEHP0HtHu
HGHP0HtHu
HFHP0L$   L$   L
  DU  H
t
 oM(Hu
HCHP0HE u
IE HP0I$MH$   L$   H$   H$   H$   H$   Ht
HuHAP0MtIu
IGIP0HL$ L|$xHt
HuHAP0MtIu
IFIP0H$   L$   HtH u
HPHR0IHİ   A\H\$WH HYPHCH;
 u3H9CtIHCHHpH;
 u3H9Ct'H[HQHHhHtHAHt3HH33
 HHu3HHG
 HHu
HGHP0Hu?L
E A  ;  H
 L
/ D  襃3H\$0H _H H
 HHucL
iE HA  ;  D7 L
 f uHSHR0L
 D F H

 *3H\$0H _Hu
HSHR0HH\$0H _HAHH HAHH(HIXH HAL   MtAL@@Mt	H A
 Hu;L
xD H
 (<  A  @   r (<  L
 V3H(HAXH HAXH\$Hl$Ht$H|$ ATAUAVH@H LHI@E3E33EE33uHHu'HC     F=  H- /  E3H;
 A3H;
 3H;=-
 AuHb
 DEy<   n H=  !  Hu
HGHP0E  H H L- HX IEIL   MtAL@@Mt	H A
 HHu'HB     ]=  HF H  Hʇ
 LcI9$j  HsH]  H{HHHHHuHAP0H{
 LgI9$   IF(E3HT$ EAHHt$ HD$(c_HHu   G p=    Hu
HFHP03Hu
I$HP0   5
 HH       =       
 HHu'H
A     ~=  H
#   HpIF(E3H IF(HH3HE `HHuE   w =  *  HE u
HEHP03*IV(HbHH   . j=    H
 E3HHxS`HHu    =    Hu
HCHP0E3E33HRlHu
HGHP0H@ u    =  H   HD IN@E3EAqHHu6   h =    H{Dy   @ =    Hu
HGHP0E   IN L
 I;uEH
ۈ
 LȰ
 H
 H	
 L?    LD  =  <  H dHHus    =  X  H;)
 H u
H@HP0E3AE  H H L- H| IEIL   MtAL@@Mt	H A
 HHu'H>    	 =  Hj l  H
 LcI9$J  HkH=  H{HE HHHHuHAP0H
 LgI9$   IF(E3HT$0EAHHl$0HD$8[HHut =    HE u
HEHP03Hu
I$HP0   a
 HH   + =        ;
 HHu'H=     =  HY    HhIF(E3H IF(HH3HF 	]HHu =  cHu
HFHP03BIV(H^HH*| =  (H
 E3HHx\HHucR =     H!= H HtHu
HGHP0HtHu
HCHP0HtdHu^HFHP0RHu
HCHP0E3E33HYhHu
HGHP0H< |    >  H HtHE u
HEHP0L
 DG } H
 azMtIE u
IUIR03
H
 H H\$`Hl$hHt$pH|$xH@A^A]A\H\$Ht$WATAUH@H LH
 LH3
 HHtH H9WHHl$`HHu'H; | $   wA  H   H
 33H9Au%HYHtHqHHHuHAP0   HM
 H9F   IEHT$(DEHD$(HcE3HHH\$ H+Ld$0*XHHu'H:  $   A  Hh    H"  H  HCHP0	  EHc
 HHu$H
: x $   A  H
 cHtHX3IEHcE3H IEHHDI$Ld HYHH   H9:  $  E A  H Hu
HFHP0HtHu
HCHP0HtHu
HWHR0L
e D  H
 w3#Hu
HWHR0Hu
HVHR0HHl$`H\$hHt$pH@A]A\_HAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH H
 HH HAHHIH9 uHAP0Ln
 3L[H [H[
 HC3H [HA H HA H\$WH LJHHL;

 trH;~
 tiH

 MIL
 H	H
 8
 L
!8 H
 UB  A  L
     UB  uH\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH HC~
 HH HA HHI H9 uHAP0L~
 3L[ H [H~
 HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH Hc}
 HH HA(HHI(H9 uHAP0L>}
 3L[(H [H+}
 HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H|
 HH HA0HHI0H9 uHAP0L^|
 3L[0H [HK|
 HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH H{
 HH HA8HHI8H9 uHAP0L~{
 3L[8H [Hk{
 HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH Hz
 HH HA@HHI@H9 uHAP0Lz
 3L[@H [Hz
 HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH Hy
 HH HAHHHIHH9 uHAP0Ly
 3L[HH [Hy
 HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH Hy
 HH HAPHHIPH9 uHAP0Lx
 3L[PH [Hx
 HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH H#x
 HH HAXHHIXH9 uHAP0Lw
 3L[XH [Hw
 HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH HCw
 HH HA`HHI`H9 uHAP0Lw
 3L[`H [Hw
 HC`3H [H\$Hl$Ht$H|$ ATH H3u
 HHu'H0  =    O  Hy   Le 3L+eIMz   D  HE H+EHH;rYs
 HEzw
 HHtqHFH9F ~HHNHHHHNHHov
 u6Hu
HCHP0HI;rHH\$0Hl$8Ht$@H|$HH A\S O  
G O  H0/ H =   H u
HFHP0HtHu
HSHR0L
k D  H
 l3kH(Hy HQrHIHv
 Hu9L
. D@2H
2
 tP  O 2    tP  L
 el3H(H\$Hl$Ht$H|$ ATAUAVH L3s
 HHu'H.  =    P  Hu >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;r'q
 IL$H:HH}   HGH9G ~HHOHHHHOHH;t
 uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\ P  
 P  H, H =   HS u
HGHP0HtHu
HSHR0L
+ D  H
 j3gHL$SWHXHD$ HHD$x    n
 D$x   HKH5t
 H;t9q
 u/L$   H$   Ht
 x5H$   L$   LCL$   MtHS(Hs
 Hu>L
+ L
N      Q  Q  A   H
@
 iH'HL$(Sm
 HHm
 HL$("n
 HHX_[H\$Hl$VWATH H33p
 HHu'HD+  =   @ T  H    Le 3L+eIMtxHE H+EHH;rn
 HEL$Ho
 HHtiHFH9F ~HHNHHHHNHHq
 u.Hu
HCHP0HI;rHH\$@Hl$PH A\_^ T  
} T  Hf* H, =   H u
HFHP0HtHu
HSHR0L
 D , H
 h3sH\$Hl$Ht$H|$ ATAUAVH L3n
 HHu'H)  =    U  H% >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;rl
 IL$HHH}   HGH9G ~HHOHHHHOHHo
 uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\ U  
 U  H( Hf =   H u
HGHP0HtHu
HSHR0L
 D0 f H
 Jf3gHAH HAHA H HA HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _H(n
 H HA0HHI0H9 uHAP0Hn
 HC0H\$03H _HA8H HA8HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _HXm
 H HA@HHI@H9 uHAP0H6m
 HC@H\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _Hl
 H HAPHHIPH9 uHAP0Hl
 HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _Hk
 H HAXHHIXH9 uHAP0Hk
 HCXH\$03H _HA`H HA`HAH HAH\$WH HHHt,HHAHHIH9 uHAP0H{3H\$0H _H(k
 H HAHHIH9 uHAP0Hk
 HCH\$03H _HA H HA HA(H HA(H\$WH HHHt,HHA(HHI(H9 uHAP0H{(3H\$0H _HXj
 H HA(HHI(H9 uHAP0H6j
 HC(H\$03H _HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _Hi
 H HA0HHI0H9 uHAP0Hi
 HC0H\$03H _HA8H HA8H\$WH HHHt,HHA8HHI8H9 uHAP0H{83H\$0H _Hh
 H HA8HHI8H9 uHAP0Hh
 HC8H\$03H _HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _HHh
 H HA@HHI@H9 uHAP0H&h
 HC@H\$03H _HAHH HAHH\$WH HHHt,HHAHHHIHH9 uHAP0H{H3H\$0H _Hg
 H HAHHHIHH9 uHAP0Hvg
 HCHH\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _Hf
 H HAPHHIPH9 uHAP0Hf
 HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _H8f
 H HAXHHIXH9 uHAP0Hf
 HCXH\$03H _HA`H HA`H\$WH HHHt,HHA`HHI`H9 uHAP0H{`3H\$0H _He
 H HA`HHI`H9 uHAP0Hfe
 HC`H\$03H _H(H
E  :HI Hu*Hm G    y Z  Hڹ H(H
 9H Hu*H+  y  7 Z  H H(H
) |9He Hu*H ö <   Z  HV H(H
 :9H; Hu*H  D   Z  H H(H
͸ 8H Hu*He ?   q Z  HҸ H(H
[ 8H Hu    6 Z  ZH
 8Ha Huֵ 7   Z  ,H
_ Z8H Hu*   ھ Z  H H4 H(3H(@SH H=E  tuHE f     { HKtHE3Hod
 { tid
 HHcd
 HKHHKH9 t?H	Qd
 uva
 H(H{ u3a
 H Hu
 [  P [  D   `
 H Hu޽ [  !   `
 Hz Hu+ [  H n    H H [3H [H\$WH 3ALH;uAËH\$0H _H`
 DH9AAH9BA   MAL;BtËH\$0H _B A8A uIuËH\$0H _AIB;t
tuII H E	 uËH\$0H _ÅËH\$0H _L/a
 M;hI;ЋAWDI_
 HHuH\$0H _HtwHu
HSHR0H\$0H _H\$UH HG`
 H(H]HH   Hb
 L I;tMHCH;]^
 t$      t
   rIHA^
 
3HuZuH\$@H ]3Ht$0HuPH|$8H}XHEHHEPHEXHu
HCHP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$83H\$@H ]@SH HHt0HuHAP0H
_
 Ho
 LH	a
 H [H [H\$Hl$Ht$H|$ ATAUAVH ILAHIhhLH  H}  	  39\$pu3Mt+I	H;
_
 twHHu^
 H  H9\$xu?HD$`Ht+HH;
^
 tvHHu^
 H  
H9$   toHˋHt[HE HtRIHx*HyHHHHy7Hy2LHIHU i  H
t^
 H	\
 O  \
 LHIU :  MhpM  I}   Ld$hMt	I<$   3HMtI9'9\$ptH]
 HHH   H=]
 HD$`HtH @9l$xt3H]
 HHu)H   H   HCHP0   Hd]
 L]]
 HH!]
 HHtHu
HSHR0HtHE u
HEHP0HtBHIAUHMuHu
HWHR0HH
]
 M@H%
 H	<_
 3H\$@Hl$HHt$PH|$XH A^A]A\H8MLHuH
\
 H
 H	^
 3H8Et)H;_]
 u-HAH;[
 t	H;[
 u   H8HIVuIBLJH
 HHMHL$ H
>\
 H	}^
 3H8H\$Hl$Ht$WH Hj3HH~WHrLI;tbHCH;Y
 t$      t
   rIHY
 
3HUu#HHH;|3H\$0Hl$8Ht$@H _ø   HIHH;u   Hu3HB   s6HAH;#Y
 t      t
   rH%Y
 L3BUH(HA   sAH(sEHAHHw,H	x H3H(ËAH(ËAH(H(H%y[
 H\$0qHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f   
      H(HA   sAx&H(sTHQHHtAHt3HHyH
 Z
 H
 H	[
 H(H(H%}Z
 AH(3H(H\$0pHHu
H\$0H(HH|$ ZHu
HSHR0H\$0H|$ H(H(HA   sAH(sEHAHHw,HI8 H3H(ËAH(ËAH(H(H%Y
 H\$0pHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f
 
 
 
 
 
 
 
 
 H(HA   sAH(sEHAHHw,HY( H3H(ËAH(ËAH(H(H%X
 H\$0oHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAH(sEHAHHw,Hi H3H(ËAH(ËAH(H(H%W
 H\$0/nHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAH(sEHAHHw,Hy H3H(ËAH(ËAH(H(H%V
 H\$0?mHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%U
 H\$0OlHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   s
HcAx(H(siHQHHtVHtHHt0Hy H
}T
 H
 H	eV
 HH(H(H%T
 AIHHH(ËAH(3H(H\$06kHHuHH\$0H(HH|$ CHHu
HSHR0H\$0HH|$ H(H\$Ht$WH0IIHJT
 HHuH\$@Ht$HH0_HD$hLLHD$(HD$`HHD$ bH\$@Ht$HH0_33333333AVHPHD$ H\$`Hl$hHt$pH|$x)t$@AAfnf(6	 5	 D,G  l+;ttC-  H$   H$   HM
 Hs
 H IcHL$(+L
 L3HuH
HHcHHISAHL
 HHZq
 表 HȋL
    HL$(K
 LHs
 Ht HHt
H HcxHIVHAfnY-t ^,H/L
 HHAs
 ( HAs
 HJs
 $    HEH H$   HL
 HFK
 HL
 H$   M
 H$   H\$`Hl$hHt$pH|$x(t$@HPA^H%L
 H(Hs
 萧 H1L
 HH(H%+L
 @SH H߮
 H[ H\s
 HL H
 H= H. HK
 HK
 HK
 H
 H H's
 H HT
 H H9 HK
 HK
 HK
 HE
 H Hr
 H貦 H
 H裦 HL H3K
 H4K
 HH [H%-K
 HtzH\$Ht$WH HHr
 AHG HHJ
 DD+^A}HJ
 HJ
 D[E~Af H6 HuH\$0Ht$8H _H%  WHPHD$ H\$`Hl$hHt$pIIH   D4HH8J
 HH6J
 8J
 H}    Hk
 HL$({J
 Hq
 H[ HHT$(I
 +\$@}HI
 HI
    ~ HQ HuHL$(@J
 H]q
 H HHI
 HH;q
  HHI
 I
 HwI
 HvI
 H\$`Hl$hHt$pHP_HWHP  HD$ HXHhHpIIHH   DBHL$PH
 Hp
 HL$`N HHH
 H v,Hp
 HL$`* HHH
 HHtp
  HT$(HL$PoH
 L$  LHHHL$(I
 HL$PHH
 L$P  I[IkIs I_HWH   HǄ$  HXHpH   DBHG
 HHPHHo
 H$0  U HȋBG
 HHo
 ; HH0 H$   H$   G
 H    Ho
 H$   H
 A   HV HL$`KI
 LR L\$`LR H$   HL$ G
 HL$   H$   G
 HLR HL$xoG
 H$   G
 HL$ G
 Ho
 HL$`/	 Ht    Hn
 HL$ JG
 HM HL$`gH
 LPR L\$`LR H$   H$   F
 HLD$ H$   F
 HLQ HL$xF
 H$   F
 H$   F
 H
 HL$`.	 H    H>n
 HL$ F
 HQ H$0  H$0  HL$`G
 LQ L\$`LMQ H$   H$   F
 HLD$ H$   F
 HLQ HL$xE
 H$   .F
 H$    F
 H
 HL$`3.	 Hv    Hm
 HL$ E
 H4Q HL$`F
 LQ L\$`LP H$   H$   hE
 HLD$ H$   ZE
 HLXP HL$x=E
 H$   wE
 H$   iE
 Hڷ
 HL$`|-	 H tJHL$ pF
 H`I HD$ H$   HL$8(E
 HXI HD$ H<
 HL$ &-	 H tJHL$ F
 H
I HD$ H$   HL$8D
 HI HD$ H~
 HL$ ,	 H tJHL$ E
 HH HD$ H$   HL$8|D
 HH HD$ H
 HL$ z,	 H tJHL$ nE
 H^H HD$ H$   HL$8&D
 HH HD$ H2
 HL$ $,	 H t>HL$`E
 HH HD$`H$   HL$xC
 HP
 HL$`+	 H tJHL$ D
 HfH HD$ H$   HL$8C
 H^H HD$ Hµ
 HL$ +	 H tJHL$ xD
 HH HD$ H$   HL$80C
 H8H HD$ HL
 HL$ .+	 Hq tJHL$ "D
 HG HD$ H$   HL$8B
 HG HD$ Hִ
 HL$ *	 H[ t>HL$`C
 HdG HD$`H$   HL$xB
 H
 HL$`*	 Hj
 HL$ 7B
 HL$`{C
 LM L\$`LM H$   H$   A
 HLD$ H$   A
 HLL HL$xA
 H$   A
 H$   A
 H̳
 HL$`)	 ;cH\$Hl$Ht$H|$ ATH Hǚ HH
] E3-
HHuHnE
 
  H   H
 HxHH5 L% H-  F
 HHtwH9cH_HGH3GhHG@HGHHG HG(HG0HG8Gl MtI$LgXHtHE HoPHtHHHw`D
 Hu
HCHP0HG
  L

 H
x
 Ai   
 Ė i   L
a ;Hu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH Hv H\$0HH
 E3Ht$8H|$@	E3HHu2H-D
 5 f   g V  HE H<
 H   HXHH
Z HAL   MtHS AH,L@@MtH; H AHH( C
 HHu'H
  h   מ e  H8   HA
 IH9C   H{H   HsHHHHHuHAP0HHHHu'H
S
 - h   _ r  H
    Hu
HGHP0IHu
HCHP0HIHuHHuXH
 ̔ i      H_ jHHHuH
  h   ʝ u  H+ 6HHHH   H
 ` i      H HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
 D 8 H
1v
 9&Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\cfH(IL$0w?
 Hu9L
c
 D@PH
v
   - P   _   L
 C83H(H\$WH HH؃uO@
 HtDL

 DCQH
v
    P      L
O 7H\$0H _É_H\$03H _{hhijH(A(A
 Hu9L
5
 D@TH
x
    T   1   L
 73H(lmH(AH@
 Hu9L

 D@XH
x
    X      L
 63H(o;rHUHp  3HXHpHxL`LhLpLxLLHHHl$0Hl$8Hl$@LHl$(L<
 Hu'H
 ɐ       H\ %I  L<
 Hu'H
     ƙ   H' H  A$HD$ $  4<
 HHu,Hu
 H|$ J    H u   H     =
 HHu'H6
     B   H E  HxH
<
 E3H`HHu'H
 ˏ       H^ gG  Hu
HCHP0H LIHK<
 y'H
 z       H
 E  Hu
HGHP0AL$$  ;
 HHu,HO
 H|$ $    H O   G  H LI;
 y'H
        Hy nD  Hu
HGHP0IL$"HHu,H
 H|$     H5 ×   F  H LI+;
 y'H
 Z       H C  Hu
HGHP0A$   =
 HHu,H1
 H|$     H 1   bF  H= LI:
 y'H
 ȍ       H[ PC  Hu
HGHP0A8$   tH9
 H H=9
 H9
 H H=9
 Hu,H
 H|$ Y    H    E  H0 LI9
 y'HA
     M   H B  Hu
HGHP0A8$   tH 9
 H H=9
 H9
 H H=9
 Hu,H
 H|$     HI ו   E  H LI?9
 y'H
 n     
  H A  Hu
HGHP0A8$      I$   HHu'H:
     F !  H A  H# LI8
 y'H
 ֋     #  Hi ^A  Hu
HGHP0A8$     I$   HHu'H
 |     @  H A  Hc LI8
 y'Hd
 >    p B  Hэ @  Hu
HGHP0H
݋ HHu'H
     % U  H B  A$   $  6
 LHu'H

      W  H
B KB  H6
 HsHl$(H9k  HkHl$(HW  H{HE HHHHuHAP0Hm7
 HwH9   E3H$   HEAH$   L$   QHHu'H"
     . k  H ?  HE u
HEHP03IE Hl$(u
IEIP0L      7
 LHu'H

     Ò {  H
$ -A  Hh3Lh E3HHHl$(LHHu'Hh
 B    t   HՋ >  Iu
IFIP0LP3IHHHu'H
     # d  H y>  IE u
IEIP0LHu	HHP0H
} HHH|$0mHHu'H
        H >  H@L   MtH? HAH2L@@MtH$ HH AHH H=6
 HHu'H.
     :   H =  Hu
HGHP0A   HH,4
 HHu'H
        HJ ?=  Hu
HCHP0HHKy'H
 o       H <  Hu
HGHP0F  Ht$0HFL   MtH HAH2L@@MtHn HH AHHX H5
 HHu,H
 H|$ ͆    Hj    >  H LI`3
 y'H
        H" <  Hu
HGHP0A$   $   x2
 HHu'Ha
 ;    m   HΈ ;  Hj LI2
 y'H#
     /   H ;  Hu
HGHP0A$,  L$x1
 HHu'H
     ގ   H? 4;  H+ LI?2
 y'H
 n       H :  Hu
HGHP0A$0  $   W1
 HHu'H@
     L   H :  H LI1
 y'H
 ܄       Ho d:  Hu
HGHP0A$$  $   0
 HHu'H
        H :  H LI1
 y'Hp
 J    |   H݆ 9  Hu
HGHP0La0
 H I0
 y,H
 H|$     H    #<  A$@   tH0
 H H=/
 H/
 H H=/
 Hu,H
 H|$     H0    ;  Ht$ H LH!0
 y'Hv
 P       H 8  Hu
HGHP0A$H  2
 HHu'H'
     3   H 8  H LH/
 y'H
 Â       HV K8  Hu
HGHP0A$P  y1
 HHu'H
 t        H 7  H LH/
 y'H\
 6    h   HɄ 7  Hu
HGHP0A$X  0
 HHu'H

        Hz o7  H LHz.
 y'H
     ۊ   H< 17  Hu
HGHP0A$`  $   :-
 HHu'H{
 U       H 6  HD LH-
 y'H=
     I   H 6  Hu
HGHP0A$d  $   ,
 HHu'H
 À     $  HV K6  H LHV-
 y'H
      &  H 
6  Hu
HGHP0A$h  $   ,
 HHu'HW
 1    c 0  HĂ 5  H LH,
 y'H
     % 2  H {5  Hu
HGHP0A$p  .
 HHu'H
     ֈ <  H7 ,5  H LH7,
 y'H
 f     >  H 4  Hu
HGHP0A$  .
 HHu'H=
     I H  H 4  HF LH+
 y'H
 ~     J  Hl a4  Hu
HGHP0A$  -
 HHu'H
 ~     T  H 4  H LH+
 y'Hr
 L~    ~ V  H߀ 3  Hu
HGHP0H
 	HHu'H'
 ~    3 `  H 5  A$(  L$`)
 LHu'H
 }     b  HS \5  H)
 HsLH9g  LkMZ  H{IE HHHHuHAP0H*
 HwH9   E3H$  HEAL$  L$   iHHu'H:
 }    F v  H 2  IE u
IEIP0ILu
IFIP0L      #*
 HHD$(Hu'H
 |    ۅ   H< E4  Lh3Lu E3HHLLHHu'H
 \|       H~ 1  HE u
HEHP03Hl$(MIHHHu'H.
 |    : o  H~ 1  Iu
IFIP0LHu	HHP0HGL   MtH~ HAH2L@@MtH~ HH AHH} H)
 HHu'H
 f{       H} 0  Hu
HGHP0H LI'
 y'H>
 {    J   H} 2  HHH\$8HHu
HCHP0H
z} HHu'H
 z       HS} \2  H@L   MtH~ HAH2L@@MtH~ HH AHH~ Hu(
 HHu'Hf
 @z    r   H| 1  Hu
HCHP0A   HHd&
 HHu'H
 y    !   H| w/  Hu
HGHP0H>y'H
 y    ܂   H=| F1  Hu
HCHP0   A$  $   %
 HHu'Ht
 Ny       H{ 0  Ht$ Hz LH%
 y'H1
 y    =   H{ 0  Hw  HCHP0h  H
q{ HHu'H
 x       HJ{ S0  H@L   MtH HAH2L@@MtH HH AHH݀ Hl&
 HHu'H]
 7x    i   Hz /  Hu
HCHP0A   HH[$
 HHu'H
 w       Hyz n-  Hu
HGHP0H<y'H
 w    Ӏ   H4z =/  Hu
HCHP0   A$  O&
 HHu'Hp
 Jw    |   Hy .  Ht$ H4{ LH#
 y'H-
 w    9   Hy .  Hs  HCHP0d  H
my HHu'H
 v       HFy O.  H@L   MtHv HAH2L@@MtHv HH AHHv Hh$
 HHu'HY
 3v    e   Hx -  Hu
HCHP0A   HHW"
 HHu'H
 u       Hux j+  Hu
HGHP0H:y'H
 u    ~   H2x ;-  Hu
HCHP0Ht$ H
	x 4HHu'Hu
 Ou    ~   Hw ,  H@L   MtHu HAH2L@@MtHku HH AHHUu H#
 HHu'H
 t    ~   Hbw k,  Hu
HCHP0HL$8A   H 
 HHu'H
 |t    }   Hw *  Hu
HGHP0H8y'H]
 7t    i}   Hv +  Hu
HCHP0H݅
  H
3u HHu'H
 s    } "  Htv i)  A$x  L$p
 LHD$(Hu'H
 s    | $  H.v #)  H
 LHoH9E g  LwMZ  HwIHHHHuHAP0H` 
 HnH9E    E3H$   HEAL$   L$   CHHu'H
 r     | 8  Hu v(  Iu
IFIP03I$LuID$IP0Ht$(      
 LHu'H
 r    { H  Hu (  Lp3E3IHMe LHD$(HHu'HZ
 4r    f{ N  Ht '  IE u
IEIP03LSIHHHu'H
 q    { 1  Hut j'  I$uID$IP03Ht$(Hu
HE HP0HCL   MtHs HAH2L@@MtHs HH AHHs Hn
 HHu'H_
 9q    kz T  Hs (  Hu
HCHP0H
@r 3LHH|$@HHu'H
 p    z a  Hts i&  H@L   MtH8u HAH2L@@MtHu HH AHHu H
 HHu'H
 ap    y c  Hr %  Hu
HGHP0A   HI
 HHu'H6
 p    By f  Hr %  Hu
HCHP0HH;4y'H
 o    x h  H[r P%  Hu
HGHP0,  Ht$ LRw Hw H:
 y'H
 io    x s  Hq '  Hs I
 HHu'HP
 *o    \x |  Hq $  Hp H
 HHu'H
 n    x ~  H~q s$  Hu
HGHP0Hs LIn
 y'H
 n    w   H0q 9&  H@  HCHP01  H
o .HHu'Ho
 In    {w   Hp %  H@L   MtHhr HAH2L@@MtHMr HH AHH7r H
 HHu'H
 m    v   H\p e%  Hu
HCHP0A   HI
 HHu'H
 xm    v   Hp  #  Hu
HGHP0H1y'HY
 3m    ev   Ho $  Hu
HCHP0H݅/  Ht$ Lrq Ht H
 y'H
 l    v   Hdo $  Hq I/
 HHu'H
 l    u   H%o .$  Hu H
 HHu'Hy
 Sl    u   Hn !  Hu
HCHP0Hzp LIH
 y'H(
 l    4u   Hn !  H  HGHP0  H
 m HHu'H
 k    t   HAn 6!  H@L   MtHs HAH2L@@MtHjs HH AHHTs Hc
 HHu'HT
 .k    `t   Hm    Hu
HGHP0A   HIR
 HHu'H
 j    t   Hpm e   Hu
HCHP0HH/y'H
 j    s   H(m    Hu
HGHP0%  Ht$ Lr HPr H
 y'H\
 6j    hs   Hl !  Hmn I
 HHu'H
 i    )s   Hl   H.r H]
 HHu'H
 i    r   HKl @  Hu
HGHP0Hm LI;
 y'H
 ji    r   Hk !  HuHCHP0Ht$ Hzk LI
 !  H7
 i    Cr   Hk    H
i HHu'H
 h    r   Hik r   H@L   MtH}q HAH2L@@MtHbq HH AHHLq H
 HHu'H|
 Vh    q   Hj   Hu
HCHP0Ht$0A   HHu
 HHu'H&
  h    2q   Hj   Hu
HGHP0H.,y'H
 g    p    HNj W  Hu
HCHP0^	  HFL   MtHi HAH2L@@MtHi HH AHHi HX
 HHu,HI
 H|$ g    Hi Ip +  N  Hk LI
 y'H
 f    p -  Hsi |  Hu
HCHP0A$   $   
 HHu'H
 f    o 7  Hi (  Hg LI
 y'Ht
 Nf    o 9  Hh   Hu
HCHP0A$(  $   7
 HHu'H 
 e    ,o C  Hh   Hg LI
 y'H
 e    n E  HOh X  Hu
HCHP0A$,  $   
 HHu'H
 he    n O  Hg   H?e LI
 y'HP
 *e    \n Q  Hg   Hu
HCHP0A$0  $   
 HHu'H
 d    n [  Hig r  Hm LIi
 y'H
 d    m ]  H+g 4  Hu
HCHP0A$4  L$H
 HHu'Hm
 Gd    ym g  Hf   Hd LI
 y'H/
 	d    ;m i  Hf   Hu
HCHP0A$8  
 HHu'H
 c    l s  HMf V  Hi LIM
 y'H
 |c    l u  Hf   Hu
HCHP0A$@   tH
 H Hv
 Hu
 H Hk
 Hu,H7
 H|$ c    He 7l   <  H;h LI
 y'H
 b     l   Hae j  Hu
HCHP0A$D  $   
 HHu'H
 zb    k   H
e   HYd LI

 y'Hb
 <b    nk   Hd   Hu
HCHP0A$H  
 HHu'H
 a    k   Hd   Hlh LI
 y'H
 a    j   HBd K  Hu
HCHP0H
.c HFHHu'H
 aa    j   Hc   A$$  $   Z
 LHu'HC
 a    Oj   Hc   H4
 Hl$(HoH9E l  LgLd$(MZ  HwI$HHHHuHAP0H
 HnH9E    E3H$  HEAL$  L$  HHu'H
 h`    i   Hb   I$uID$IP03IE Ht$(u
IEIP0L      q
 LHu'H"
 _    .i   Hb   L`E3Lh E3HHLd$(MAHHu'H
 _    h   H?b 4  Iu
IFIP0MPIHHHu'H
 ]_    h   Ha   IE u
IEIP03LHu
HE HP0HCH\$8L   MtHia HAH2L@@MtHNa HH AHH8a H
 HHu3H
 Ht$0H|$ HOa ^    g   3  Hg LI9
 y'H
 h^    g   H`   H  HCHP0Ht$0H|$   H
^ HHu'H0
 
^    <g   H`   H@L   MtHd HAH2L@@MtHc HH AHHc H
 HHu'H
 ]    f   H` &  Hu
HCHP0A   HH	
 HHu'H_
 9]    kf   H_   Hu
HGHP0Hg!y'H
 \    &f   H_   Hu
HCHP0]  HFL   MtH_ HAH2L@@MtH^ HH AHH^ H

 HHu,H
 H|$ W\    H^ e     Ha LI
 y'H?
 \    Ke 	  H^   Hu
HCHP0A$   L$P
 HHu'H
 [    d   H[^ d  H\ LI[
 y'H
 [    d   H^ &  Hu
HCHP0A$$  L$Xv
 HHu'H_
 9[    kd   H]   HHc LI
 y'H!
 Z    -d !  H]   Hu
HCHP0A$,   tH
 H H
 H
 H H
 Hu,H
 H|$ Z    H(] c +    HRb LI
 y'Hs
 MZ    c -  H\   Hu
HCHP0H
` HHHu'H%
 Y    1c 7  H\   A$(  L$h
 LHu'H
 Y    b 9  HQ\ F  H
 LHoH9E h  LoM[  HwIE HHHHuHAP0H
 HnH9E    E3H$(  HEAL$(  L$0  eHHu'H6
 Y    Bb M  H[   IE u
IEIP03ILu
IFIP0L      
 HD$(Hu'H̿
 X    a ]  H9[ .  3LhLp LLE3HHHHu'H
 YX    a c  HZ 
  HL$(HuHAP03Ht$(OIHHHu'H*
 X    6a F  HZ 
  Iu
IFIP03LHu
HE HP0HCHH\$8L   MtHZ HAH2L@@MtHY HH AHHY H
 HHu'H}
 WW    ` s  HY   H_ LI
 y'H?
 W    K` u  HY   Hu
HCHP0H
] HHu'H
 V     `   HaY j  H@L   MtH\ HAH2L@@MtH\ HH AHH\ H
 HHu'Ht
 NV    _   HX 
  Hu
HCHP0A   HHr
 HHu'H#
 U    /_   HX   Hu
HGHP0H+y'H޼
 U    ^   HKX T
  Hu
HCHP0B  H
'\ JHHu'H
 eU    ^   HW 
  H@L   MtH] HAH2L@@MtH\ HH AHH\ H
 HHu'H
 T    ^   HxW   Hu
HCHP0A   HH	
 HHu'H
 T    ]   H'W 
  Hu
HGHP0Hy'Hu
 OT    ]   HV   Hu
HCHP0  A$0  
 HHu'H
 S    *]   HV   H[ LI 
 y'H
 S    \   HMV V  Hu
HCHP0A$H  p
 HHu'H
 kS    \   HU   H[ LI	 y'HS
 -S    _\   HU 
  Hu
HCHP0A$8  
 HHu'H
 R    \   HqU z
  HES LIq	 y'Hƹ
 R    [   H3U <
  Hu
HCHP0A$@  V
 HHu'Hw
 QR    [   HT 	  HS LI	 y'H9
 R    E[   HT 	  Hu
HCHP0A$8   
 HHu'H
 Q    Z   HWT `	  HCX LIW	 y'H
 Q    Z   HT "	  Hu
HCHP0A$@  < 
 HHu'H]
 7Q    iZ   HS   HFT LI	 y'H
 P    +Z   HS   Hu
HCHP0A$@  	 HHu'Hз
 P    Y   H=S F  HQ LI=	 y'H
 lP    Y   HR   H  HCHP0Ht$0H|$ 	  H
V HHu'H4
 P    @Y   HR   H@L   MtHV HAH2L@@MtHV HH AHHV H	 HHu'H
 O    X   H!R *  Hu
HCHP0A   HH	 HHu'Hc
 =O    oX   HQ   Hu
HGHP0Hky'H
 N    *X 
  HQ   Hu
HCHP0j  A$0  	 HHu'Hǵ
 N    W   H4Q =  H`V LI4	 y'H
 cN    W   HP   Hu
HCHP0A$H  	 HHu'H:
 N    FW !  HP   HV LI	 y'H
 M    W #  HiP r  Hu
HCHP0A$8  	 HHu'H
 M    V -  HP #  HM LI	 y'Ho
 IM    {V /  HO   Hu
HCHP0A$@  	 HHu'H 
 L    ,V 9  HO   HyN LI	 y'H
 L    U ;  HOO X  Hu
HCHP0A$8  r	 HHu'H
 mL    U E  H O 	  HR LI 	 y'HU
 /L    aU G  HN   Hu
HCHP0A$@  	 HHu'H
 K    U Q  HsN |  HN LIs	 y'HȲ
 K    T S  H5N >  H  HCHP0Ht$0H|$ J  H
.L )HHu'Hj
 DK    vT q  HM   H@L   MtHS HAH2L@@MtHS HH AHHS H	 HHu'H
 J    S s  HWM `  Hu
HCHP0A   HH	 HHuDH
 sJ    S v  HM H  H  HGHP0  Hu
HGHP0Hy'H7
 J    CS x  HL   Hu
HCHP0  LpO HN I	 y,Hݰ
 H|$ I    HOL R     L	 H"O IA	 y,H
 H|$ kI    HL R     A$   1	 HHu'HR
 ,I    ^R   HK    H|$ HFL LH	 y'H
 H    R   H|K    Hu
HCHP0A$(  	 HHu$H
 H    Q   H-K 9HLN LH0	 y[H
 _H    Q   HJ HtHu
HCHP0MtnIE u
IEIP0Ht$0H|$ 3[Hu
HCHP0HBJ LI	    H
 G    Q   HlJ Ht$0H|$ 3HL$(Ht
HuHAP0MtIu
IFIP0L
+J DG P H
0
 SHt$0H|$ AHt$0H|$ 5Ht$0H|$ )Ht$0H|$ Ht$0H|$ Ht$0H|$ H|$ IIL$H  L$P  L$X  H$  MtIu
IGIP0L$@  HtHu
HGHP0H$`  HtHu
HFHP0HL$8H$h  Ht
HuHAP0HD$@HtH u
HPHR0HHp  ]{(H\$Hl$Ht$H|$ ATH H'I HH
O E3=HHuH	 Q%  H   H
BO HxHH5lH L%
H H-H `	 HHtwH*H_HGH3GhHG@HGHHG HG(HG0HG8Gl MtI$LgXHtHE HoPHtHHHw`	 Hu
HCHP0HGY%  L
]
 H
;
 A  jN $E   L
G DHu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH HG H\$0HH
oN E3Ht$8H|$@ͻE3HHu2H-k	 D   M %  HE H
 HG   HXHH
K HAL   MtHG AH,L@@MtHG H AHHG :	 HHu'H+
 D   7M %  HF   H	 IH9C   H{H   HsHHHHHuHAP0HH2HHu'H

 C   L %  H
 F    Hu
HGHP0IHu
HCHP0HIHuHHuXHR
 ,C   ^L 
&  HE jHHHuH
 B   *L %  HE 6HHH   H
 B   K &  HSE HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L

E DbB K H
q9
 |&Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\+k.HHPHHAUH   HHXE3HhHpHxL`LpLxMHIIML$   MH;9	 >  3k	 HHu'Hl
 FA   xJ '  HC *
  HM H;
	 u>H
 	 H9
 H		 L!
 @   LC &J '  L  H*A \	 HHu'H

 @   I '  H
RC   H@H;	    H;	 t~HIv	 HHu*H

 i@   I '  H
B M  H@H   Hl$ Hu8HP
 *@   \I '  HB Mx  HHILl$ Hu
HGHP0JLH$   H$   HuUH4	 H9Cu'L;s4  HCIJ|HHH$   2L;s
  H9IHHH$   HHH  ILHt
HuHAP0HE H$   IL;bH#	 AEH9BI9GADtUMGL;B   B IO 8   IAGDJA;tt
A   H  A^L	 AM;ucI;AAuUA   I	 HH   HHE Du
HUHR0Hl$ Ex[H$   EMuHNH9N ~ IHFL<HAH$   HFKIH/	 u:H$   .E3H
 =   (G '  H@ MD	  H
 =   F '  H_@ M	  	 HtHu	 HHt?	 Hu
HCHP0H$   H$   HJ  HAP0M>  Hh
 B=   tF '  H? M  H-.B H
D H	 HHtH H虿HHu'H

 <   F (  Hw? 5  H$   HA	 u'Hˣ
 <   E (  H8?   Hu
HFHP0tf   |	 HHu'H}
 W<   E !(  H>   H$   H$   HH@HHuHAP0MH=C H
C H
	 HHtH H腾HHu*H
 ;   E :(  Hc> IZ  HCL   MtHt< HAH2L@@MtHY< HH AHHC< H	 HHu*Hs
 M;   D <(  H= I  Hu
HCHP0HGL   MtH9= HAH2L@@MtH= HH AHH= H	 HHu'H
 :   C ?(  HM=    Hu
HGHP0H$   HN H;
M	 uAH
\	 H-3
 H	d	 L}
 W:   L< C D(  I  H: 	 HHu'H>
 :   JC F(  H< ~  HN H;
	 u>H
	 H2
 H		 L
 9   Lj< B J(  3  H$@ .	 LHu'H

 9   B L(  H
$<   H	 IL$   AH9Cu4HkH$   Ht#HCHE HH HHuHAP0   HI	 H9C   H$   HT$HDFHD$HHcE3HHHl$@H+H|$PLt$XHHu'H
 8   A ](  H[;   HtHE u
HEHP0HIL$   u
HGHP0IIu
IFIP0M   FHc	 LHu'H
g
 A8   sA o(  H
:   HtHhL$   IH$   HcE3HILI| Mt(HIIMbHHu'H
 7   @ }(  H`:   I$uID$IP0MHu
HCHP0H$   H$   HuHAP0H
B? 5HHu'Hv
 P7   @ (  H9   H@L   MtH; HAL2L@@MtH; HH ALH; H	 LMu'H
 6   @ (  Hc9 ]  Hu
HCHP0ID$L   MtH? IAH2L@@MtH? IH AHHu? It	 HHu'He
 ?6   q? (  H8   I$uID$IP0HD	 MAH9Cu,LcMt#HCI$HH HHuHAP0   H	 H9C   H$   HT$0DEHD$0HcE3HHLd$(H+Ht$8ιHHu'H
 y5   > (  H8    M  I${  ID$IP0k  EHc	 LHu/H@
 H$   5   H7 => (     MtL`MH$   HcE3HILHHIIt CHH   HЛ
 4   = (  H=7 HtHu
HFHP0HtHu
HGHP0H$   H$   HtHu
HCHP0MtIu
IFIP0HtHE u
HEHP0MtI$uID$IP0L
6 D3 .= H
,
 #Iu
IFIP0Hu
HCHP0LLt$pLd$xH$   H$   H$   H$   MtIu
IGIP0H$   L|$hHtH u
HPHR0IHĠ   A]H\$Hl$VWATH@H	 HzILH\$pHM   HtH   HZH\$pI3	 HHu)H  H8 H	 HtHHD$pHH   H,
 LL$pHF HD$(E3HH|$ Yy
)     H\$p   H   H   Hy3L
`R
    L
bR
 HH	 H|$0HO
 L+
 HDHIR
 HD$(HL$ H
	 H	/	 )  L

 H
|+
 A   ; 1   L
w4 3HZHI$H\$`Hl$hH@A\_^HLH L@HPHHAUH  HE3HXHhHpL`LpHAML   ILL$   L$   L$   Ll$8Ll$PL$   Ll$XL$   Ll$xL$   Ll$`Ll$pL$   L$   Ll$hLl$0Ll$(Ll$ IMtH2 AH+H@@HtH2 H HH2 	 HH$  L$  Hu'H
 p0   9 *  H3 J  H	 MH9C   L{M   H{IHHHHuHAP0IH蝸HHu'H
 /   *9 *  H2 gI  Iu
IGIP0MHu
HCHP0HIu
HGHP0H
	 AH;  L;A  H-/ H
q6 Hx	 HHt<H BH3HHuHd
 >/   p8 *  H1 H  H輱HHu'H-
 /   98 3*  H1 vH  HGL   MtH. HAH2L@@MtH. HH AHH. H	 HHu'H
 .   7 5*  H1 G  Hu
HGHP0HN3 E3H˴HHu'H\
 6.   h7 8*  H0 G  Hu
HCHP0HIu
HGHP0H	 L;   L$   IM H;u>H
	 H"(
 H		 Lڔ
 - "  LQ0 6 Z*  MG  H- 	 HHu'H
 x- "  6 \*  H0 F  IILH$    IFP0  H
C2 HHu'H?
 - #  K6 r*  H/ F  HI{	 u'H
 , #  6 t*  Hr/ NF  Hu
HGHP0ti   	 HHu'H
 , $  5 *  H$/  F  IH@IL0ILH$  uIFP0L$   L$   L$  H
	4 HHu'H=
 , %  I5 *  H. E  H@L   MtH, HAL2L@@MtH, HH ALH, H	 LMu'H
 + %  4 *  H*. E  Hu
HCHP0IGL   MtH- IAH2L@@MtHk- IH AHHU- I<	 HHu'H-
 + %  94 *  H- D  Iu
IGIP0IM 3LH;
	 u>H
	 H%
 H		 L͑
 * %  LD- 3 *  +D  H* 	 LHu'H
 k* %  3 *  H, C  IM H;
	 u>H
%	 H6%
 H	-	 LF
  * %  L, K3 *  C  Hw0 	 LHD$0Hu'H

 ) %  3 *  H
r, cC  H	 LHl$(H9Cu5LsLt$(Mt'HCIHH HHuHAP0LL$0   H	 H9C   L$X  HcH$H  HDGE3HH+L$@  L$H  L$P  gHHu'H8
 ) %  D2 *  H+ B  MtIu
IFIP0ILHl$(u
IGIP0HL$0LHuHAP0Hl$0L   GHc	 LHD$ Hu'H

 ( %  1 *  H
+ B  MtLpHl$(LH$  HcE3HILHL$0IL(M| IHLHl$0蠮HHu'H1
 ( %  =1 *  H* zA  I$uID$IP0LHl$ Hu
HCHP0H$  HH$  H HuH@P0IM H;
i	 u>H
x	 H"
 H		 L
 s' '  L* 0 *  NA  H' 	 HHu'H]
 7' '  i0 *  H) @  IM H;
	 u>H
	 HR"
 H		 L
 & '  L) 0 *  [@  H( M	 HHu'H֍
 & '  / *  HC) @  HH	 LHD$ Hu'H
 p& '  / *  H) ?  Hu
HGHP0Hu
HCHP0H
. L$   Hl$ HHu'H.
 & (  :/ +  H( ?  H@L   MtH& HAH2L@@MtH& HH AHH~& H	 HHu'H
 % (  . +  H( ?  Hu
HCHP0HGL   MtHo, HAH2L@@MtHT, HH AHH>, H-	 HHu'H
 $ (  *. 
+  H' g>  Hu
HGHP0H	 HH9Cu+H{Ht"HCHHH HHuHAP0   H	 H9C   H$  H$  DEH$   HcE3HHH$  H+L$  聨LHD$ Hu'HM
 '$ (  Y- +  H& =  HtHu
HGHP03H   EHcB	 LHD$0Hu'H
 # (  , *+  H[& 7=  HtHx3I$H$  HcMdHIL HE3ILHD$ Hu'H
 _# (  , 5+  H% <  HL$0HuHAP03Hl$0Hu
HCHP0I$uID$IP0H
* Hl$ ɮHHu'H

 " *  , C+  Hw% S<  H@L   MtH# HALHD$0<L@@MtHk# HH ALHD$0HP# H	 LHD$0Mu'H{
 U" *  + E+  H$ ;  HuHCHP0LL$0IAL   MtH'' IAH2L@@MtH' IH AHH& I	 HHu'H
 ! *  * H+  HS$ /;  HL$0HuHAP0IM Hl$0H;
T	 u>H
c	 H
 H	k	 L
 ^! *  L# * M+  :  H! 	 LHD$0Hu'HC
 ! *  O* O+  H# :  IM H;
	 u>H
	 H
 H		 L
   +  Lo# ) [+  A:  H)' 3	 HHu'H
   +  ) ]+  H)# :  IM H;
A	 u>H
P	 H)
 H	X	 Lq
 K  ,  L" v) i+  9  HB" 	 LHu'H5
   ,  A) k+  H" ~9  H&	 LHl$(H9Cu0LsLt$(Mt"HCIHH HHuHAP0   H	 H9C   H$  H$  DEH$  HcE3HHL$  H+L$  H$  L$  莣HD$ Hu'H]
 7 *  i( +  H! 8  MtIu
IFIP03I$LHl$(uID$IP0HHl$0u
HGHP0IHu
IGIP0Ld$ L   EHc	 HHu'H

  *  ' +  H
)! 8  MtLpE3Lt$(H$  Hc3H| L|(LdHHL0E3HHHl$0HL认LHD$ Hu'H:
  *  F' +  H  7  Hu
HFHP0HHu
HCHP03L$   	 LHD$ Hu'Hӄ
  /  & +  H@  7  IM H;
X	 u>H
g	 Hh
 H	o	 L
 b /  L & +  =7  H% 	 HHu'HL
 & /  X& +  H 6  IM H;
	 u>H
	 H	
 H		 L
  /  Lx & +  _6  H! <	 HHu'HŃ
  /  % +  H2 #6     	 LHu'H
 e /  % +  H 5  H
4  HXE3HHp H订HHu'H?
  /  K% +  H 5  Iu
IGIP0HFH;L	    H;G	 t}HI	 LHD$@Hu'HԂ
  /  $ +  HA G5  H@L   MuBH
 L|$@r /  H $ +  5  HE3HMMHt$@Hl$@E3Hu
HFHP0INtfMuEH|	 H9EuL;m~  HEIJtHI+L;m_  I6IHIHAHH  HFH)	 H;   H;	    H	 HHD$0H  Hu
HFHP0HCHIH   HHx  HL$0A   HH_  Ld$0Iպ   HJh  I$uID$IP0Hl$@E3Ld$0>HNH  H;u
H^H~ HFHHxHHHu
HFHP0HL$XHH\$XHt
HuHAP0H$   HIH$   HtHu
HAP0HHHI	 HH*  LD$ IHI9H ~H I@H4HAI@HIF	    Hu
HFHP0IH'
 L|$@ /  H '"  ,  k2  HL$0HuHAP03HL$0euIhH
 L|$@ /  HC ! (,  2  H
 L|$@z /  H ! ,  2  Hy
 L|$@N /  H y! 1,  1  HM
 L|$@" /  H M! /,  1  H~H
	 H7
 A   H		 
Hx艤H~
 L|$@ /  Hd   ,  `1  	 HtHs	 HHtn	 HE u
HEHP0HD$ H$  3LLHl$ H$   yXHc~
 Lt$(8 1  H c  ?,  1  H7~
 L|$@ /  H 7  +  0    H
 订LHu'H}
  2   I,  H\ b0  H@L   MtH IAH2L@@MtHm IH AHHW I~	 HHu'Ho}
 I 2  { K,  H /  Iu
IGIP0HP	 LH9F   L~M   H~IHHHHuHAP0IHfLHD$ Hu'H|
  2   Y,  HO U/  Iu
IGIP0LHu
HFHP0H$  HMHALd$8H;	    H;	    HH|$@7	 LHD$ HugHK|
 % 3  W n,  H .  HLHD$ HcH|
  2   \,  Hx ~.  H@H   H$   HuEH{
  3   p,  H9 ?.  HHLHL$ HHl$@H$   LHuLH	 I9D$u!I;|$
  ID$H4HHH|$@.I;|$  ItHHH|$@IHH  IHt$PLHt
HuHAP03	 HHG  H$   IO	 LH  H@H;	 tYH;	 tPII	 HH  H@L   Mu3Hz
 o 5   ,  H ,  IILLIu
IGIP0Nl@ MuFH	 H9GuL;gS  HGIN|II,L;g4  M} IIIHALH  HL$hL|$hHt
HuHAP0H
 LxHH  H@L   MtH] HALHD$0<L@@MtH= HH ALHD$0H" Ha	 LHD$0M7  HuHCHP0LL$0IAL   MtHt IAH2L@@MtHY IH AHHC I	 HH  HL$0HuHAP0Hݽ	 HՋHT$0H9Cu8HSHT$0Ht*HCHHH HHuHAP0HT$0   HH~	 H9CuyHD$hH$(  DAH$0  H$   H$0  H@ E3H$8  HcHHH+FLH>  HL$0Ht
HuHAP03Hl$0   AHc+	 HHD$(Hs  HD$0Ht
HAHD$0    HD$hH$   E3H HDHB H HB HHD HLH
  HL$(HuHAP03Hl$(Hu
HCHP0HNHH9N ~IHFL<HAHFIH%	 p
  IIGIP0	 Ht H	 HH߸  A	 Hu
HGHP0H$   LH$   Ht
HuHAP0	 HH  H
; >LH\  H@L   MtH IAH2L@@MtH IH AHH I1	 HH  Iu
IGIP0H&	 LHkH9E    L{M   H{IHHHHuHAP0HԻ	 HoH9E uHE3H$   HEAL$   L$   軒HH  Iu
IGIP0E3v   	 LHD$(H
  LxI$E3E3HHML` 螔HH  Iu
IFIP0Ll$(IH耖HH  Hu
HE HP0HT$P3LHH~	 ;  Hu
HGHP0HL$XLHt$XHt
HuHAP0Ll$8HIEL   MtHh IAH2L@@MtHM IH AHH7 IN	 HH  HS	 LgI9$   H_H   HoHHHE HHuHAP0H	 LeI9$uJE3H$   HEAH$   L$   HH  Hu
HCHP03Hx   ܹ	 LHD$(H  HXHD$XE3H IHIF 3˒HHW  Iu
IFIP03Hl$(IH諔HHF  Hu
I$HP0Hu
HFHP0L$   HIM H;
	   H N	 HH  H@L   MtH HALHD$(<L@@MtH HH ALHD$(Hh H	 LHD$(M  Hu
HGHP0Ho	 MfHI9$   I~H   InHIHE HLHl$(uHAP0H	 LeI9$uOHD$PE3H$   EAHH$   H$   HH
  Hu
HGHP03Hs   	 HH3
  HxHD$PE3H HHHC 3ߐHH	  Hu
HCHP03HHT$PI迒HH  Iu
I$IP0H$   Hl$(LH$   Ht
HuHAP0IM HH;
	   HF P	 HH
  IH8	 LHD$(H
  Hu
HFHP0HL$xLt$xHt
HuHAP03Hl$(v	 HH+
  A   HI	 HH  Hu
HFHP0HH  Hu
HSHR03ۅt0K	 HH  H
 HH@3HHHII3IILHD$xuIFP0   	 LHD$(H  H$   H
 E3H IIFHH  Iu
IFIP0   ]	 LHD$(HJ  H@IIH	 HH  Iu
IFIP0H$   Hl$(LH$   Ht
HuHAP0Ll$8HT$PIX	 HH
  H@L   MtH HALHD$(<L@@MtH HH ALHD$(H H	 LHD$(M	  Hu
HCHP0   	 HH	  I$L`C	 HHb	  Lp H) H	 	  LHIjHH  Iu
IFIP0HHl$(u
HCHP0HHu
HFHP0Lt$PLIIH	 ]  Hu
HGHP0I6	 H  H|$@Ld$ HH$   L$   ID$H;	 uI|$tOID$HxH{H;y	 uI|$t+I|$ H[HHhHtHAHt   IH:   	 HHuH"HI3	 HE Hu
HEHP03H  H E3HEAHH  Hu
HGHP0H  Hu
HVHR0Ld$ H$   H|$@HH
 ߐHH  H@L   MtH	 HAH2L@@MtHy	 HH AHHc	 HҲ	 HH  Hu
HGHP0II	 HHC  H	 LcHl$(I9$   LsLt$(M   HkIHHE HHuHAP0HU	 LeI9$u`E3H$   HEAL$   H$  <HH  Iu
IFIP03HHl$(   HGHP0~   	 LH  3E3HHL$(HLpHx HH  Iu
IGIP03L'HHHH  Hu
HGHP0Hu
I$HP0Lt$PLIIH	   HH|$@Ld$ H$   HFHP0H$   xHi
  5   ,  Hi E  Hi
  4   ,  HB   Hi
  4   -  H   Hi
 a 4   	-  H   H`i
 : 4  l ,  H   H9i
  4  E ,  H   Hi
  4   ,  H [  Hh
  4  
 ,  HX 4  Hh
  5  
 ,  H1 
  Hh
 w 6  
 <-  H
   Hvh
 P 6  
 P-  H   HOh
 ) 6  [
 J-  H   H(h
  7  4
 u-  H q  Hh
   7  
 -  Hn J  Hg
   7  	 -  HG #  Hg
   8  	 -  H    Hg
 f  8  	 -  H   Heg
 ?  8  q	 -  H   H>g
   ;  J	 -  H   Hg
 
 A  #	 m.  H `  Hf
 
 A   .  H] N  Hf
 
 A   }.  H6   Hf
 |
 A   .  H   H{f
 U
 A   f.  H   HTf
 .
 A  ` Y.  H   H-f
 
 A  9 V.  H v  Hf
 
 A   T.  Hs O  He
 
 @   G.  HL R  He
 
 @   D.  H%   He
 k
 @   B.  H    Hje
 D
 @  v ;.  H    HCe
 
 >  O 1.  H    He
 
 >  ( ,.  H  e  Hd
 
 >   +.  Hb  >  Hd
 
 >   ).  H;    Hd
 
 >   $.  H    Hd
 Z
 >   !.  H
   HYd
 3
 >  e .  H
   H2d
 
 <  > .  H
 {  Hd
 
 <   
.  Hx
 T  Hc
 
 <   
.  HQ
 -  Hc
 
 <   .  H*
   Hc
 p
 ;   -  H
   Hoc
 I
 ;  { -  H
   HHc
 "
 ;  T -  H
   H!c
 
 9  - -  H
 j  Hb
 
 9   -  Hg
 C  H
	 H	 H		 Lb
 
 9  L3
  -    Hb
 o
 8   -  H
   Hnb
 H
 8  z -  H
   HGb
 !
 8  S -  H
   H
	 H9	 H		 L	b
 
 8  L
  -  g  Ha
 
 7   o-  HO
 +  Ha
 
 7   b-  H(
 .  Ha
 n
 6   V-  H
   Hma
 G
 6  y 6-  H
   HFa
  
 6  R (-  H
   Ha
 
 6  + &-  H
   H`
 
 6   $-  He
   H`
 
 5   ,  H>
 D  H`
 
 4   ,  H
   <	 HtH0	 HH]t!å	 I$  ID$IP0  HA`
 
 3  M ,  H
   3		 LHu,H
`
 Lt$(
 C  H|
 
 .    H$   HD$8LHO H;
z	 uCH
	 HB	 H		 L_
 Lt$(L&
 x
 D   .  Z  Hv
 	 LHu,Hi_
 Lt$(>
 D  H
 i .    H	 LHu,H+_
 Lt$( 
 D  H
 + .    I$uID$IP0Hl$ LM   H

 脃HH  H@L   MtHi
 HAH2L@@MtHN
 HH AHH8
 Hw	 HH   Hu
HFHP0HCL   MtH,
 HAH2L@@MtH
 HH AHH
 H
	 HH  Hu
HCHP0I	 HH@  H	 LH9Fu.L~Mt%HFIHH HHuHAP0   HH	 H9F   HG L$  DAH$p  HcH$h  HE3HH+L$`  H$h  L$x  [zHHD$ H  MtIu
IGIP03HLu
HCHP0H   AHc,	 HH 
  MtLxE3H$   L$  H\HA E3HH HA HHD I$Ld(3H{HD$ H	  Hu
HGHP0H|$ Hu
HFHP0HL$`HH|$`Ht
HuHAP0H$   Hl$ HO H;
٢	   Hd
 ~	 LHD$ H  H@H;B	 uIx tMI@H0HH;)	 uIx t,IpHaHHhHtHAHt3ILD$ H>37	 HHt!HL$ H	 HHu
HGHP0LD$ H$   H  I u
I@IP0HL$pHl$ Ht$pHt
HuHAP0IH\z  =  HO H;
	 O  H
 V	 HH  H@H;	 u!H~ t\HFL Ld$ I$   H;	 uH~ t2LfLd$ I$aHHhHtHAHt3HLHD$ >3	 HHu
LHl$ $HH	 HLHD$ u
HGHP0M,  Hu
HFHP0H|$pIH]	 HH  I$uID$IP0HHHt$puHGP0HH
p
 s~LHD$ H  H@L   MtHs
 IAH2L@@MtHX
 IH AHHB
 Ia	 HHm  I$uID$IP0HT	 LgHl$ I9$   HWHT$ H   HoHHHE HHuHAP0HT$ H	 LeI9$uSHD$`E3H$   H$   EAHH$   uHH=  HL$ HuHAP03Hl$ }   Ş	 HHY  HD$ E3HHC3HHD$ HD$`H HC wHH  Hu
HCHP03HHT$`HyHH  Hu
I$HP0HFL   MtHt
 HAH2L@@MtHY
 HH AHHC
 H	 HHp  Hu
HFHP0H$   HLH$   Ht
HuHAP0H

 |HH  H@L   MtH
 HAH2L@@MtH
 HH AHH
 H	 HHu  Hu
HGHP0   	 HH'  H3
 HIH HGH
 H HG Hw(	 HH  Hu
HGHP0HL$8H譊{  Hu
HFHP0IHM;X  H$   hHAV
 
 E  M
 .  H
   HV
 
 I  &
 </  H
   HU
 
 I  
 9/  H`
 f  HU
 
 I  
 7/  H9
 ?  H
m	 H	 H	u	 LU
 h
 I  L
 
 5/    HgU
 A
 J  s
 h/  H
   H@U
 
 J  L
 |/  H
   HU
 
 J  %
 v/  H
 b  HT
 
 K  
 /  H_
 e  HT
 
 K  
 /  H8
   HT
 ~
 K  
 /  H
   H}T
 W
 K  
 /  H
   HVT
 0
 K  b
 /  H
   H/T
 	
 J  ;
 /  H
   HT
 
 J  
 b/  Hu
 Q  HS
 
 J  
 T/  HN
 T  HS
 
 J  
 R/  H'
 -  HS
 m
 H  
 (/  H 
   HlS
 F
 G  x
 /  H
   HES
 
 G  Q
 /  H
   H
	 H	 H		 LS
 
 G  L~
 
 /  z  HR
 
 E  
 /  HM
 )  HR
 
 E  
 .  H&
   HR
 l
 E  
 .  H
   HkR
 E
 E  w
 .  H
   HDR
 
 E  P
 .  H
   HR
 
 E  )
 .  H
   H

 vHHu'HQ
 
 L  
 /  HO
 +  H@L   MtH
 HAH2L@@MtH
 HH AHH
 Hq	 HHu'HbQ
 <
 L  n
 /  H
   Hu
HGHP0HC	 LcHI9$E  H{H8  HkHHHE HHuHAP0H	 LeI9$a  Ll$8E3HT$@EAHH|$@Ll$HmHHu'HP
 
 L  
 /  H
   Hu
HGHP0Hu
I$HP0IHt$8LHuHAP0IE H$   L$  L$  L$  H$  H$  H$  H$  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$8Ht
HuHAP0HL$PHt
HuHAP0H$   Ht
HuHAP0HL$XHt
HuHAP0H$   Ht
HuHAP0HL$xHt
HuHAP0H$   Ht
HuHAP0HL$`Ht
HuHAP0HL$pHt
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$hHt
HuHAP0H$  HtH u
HPHR0IH  A]ù   	 LHD$ Hu'HZN
 4
 L  f
 /  H
    HxHD$8E3H IHIE |mHHu$H
N
 
 L  
 /  Hz
 nIE u
IEIP0Ll$8]Ll$8HI5oHHAHM
 
 L  
 /  H
 HtHu
HGHP0HtHu
HCHP0MtIu
IGIP0HL$0HtHuHAP0Lt$(Ld$ 
Lt$(Ld$ MtIu
IFIP0MtI$uID$IP0HtHu
HFHP0E3E3L
c
 D
 
 H
	 ҊqK[H\$Hl$Ht$WATAUHPH	 HjMLH\$@HH\$HHM   Ht"HtH   Hz H|$HHZH\$@I&	 HHHtHt+RHT  H
 I	 HtHHD$@HH+  H
 I	 HtHHD$HHH  H	 LL$@H
 HD$(E3IHl$ ty
1     H|$HH\$@   H   H   H   Hy3L

    L

 HHu	 Hl$0H	 L	 HDH
 HD$(HL$ H
	 H	ߓ	 2  L
J
 H
	 A^  
 
 ^  L
'
 誈3Hz HZLHI H\$pHl$xH$   HPA]A\_HHPATH   E3HXHhHxLhLpHALIL   L$   Ld$HLd$0Ld$8IL$   Ld$ Ld$(MtH
 AH,L@@MtH
 H AHH}
 	 HHt$xL|$XHu'HI
 `
   
 F5  H
 1
  Hw	 MH9G   LM   HwIHHHHuHAP0IHjHHu'HI
 
   
 S5  H{
   Iu
IGIP0MHu
HGHP0HIu
HFHP03	 HHu^HH
 {
   
 c5  H
   H9kHHuHjH
 D
   v
 V5  H
 w  IN H;
	 u>H
	 H	 H		 LH
 
   L
 $
 g5  ,  H
 Z	 HHu'HG
 
   
 i5  HP
   H@HH$   H;	 t~H;	 tuHp	 LHu*HG
 c
   
 o5  H
 H  H@L   Mu6HOG
 )
   [
 q5  H
 HY  HLIMHu
HGHP0MdMuFHG	 I9GuI;o  IGHH|HI,I;o}  I<$HHIIAHH4  HL$HH|$HHt
HuHAP0H
 H	 HH   H
 H΋	 HH   Hu
HWHR0HN3H9N ~HHFHHAHFHH	 uHu
HCHP03HE
 
   
 5  Hh
 H  HE
 H$   
   H@
 
 5     HE
 H$   t
   H
 
 5     ,	 HtH 	 HHMt\	 Iu
IGIP0H$   HH$   kyvH E
 
   ,
 5  H
 E3  HD
 H$   
   He
 
 5  H  H  HFHP0  tH   3	 LHu'HD
 h
   
 5  H
   IN H;
	 u>H
"	 HK	 H	*	 LCD
 
   L
 H
 5  t  H
 ~	 HHu'HD
 
   
 5  Ht
 8     	 HHu'HC
 
   
 5  H:
   HH
s
 E3HHpHX bHHu'HC
 [
   
 5  H
   Hu
HGHP0HCH;	 t}H;	 ttH
	 HHu'H#C
 
   /
 5  H
 ?  H@H   Ht$@HuEHB
 
   
 5  HT
   HE3HIL$   ILl$@E3HHu
HCHP0Lt$0LdHuVHć	 H9Gu'H;o  HGHH\H$   HI3H;o  I$HHIH$   HHHQ  HCHa	 H;   H;I	    Hʉ	 LHD$(H	  Hu
HSHR0INIIH   IH$   H}  Iν   HD$ He  I֍UH(  Iu
IFIP0H$   Ht$ Lt$0Ll$(NHKH  H;uHKHs H$   HCHHpH$   HHHu
HCHP0H$   ILHD$0Ht
HuHAP0HL$8HL$   HD$8HtHu
HAP0HI^Ll$ HshH   H~     H;<	 t"HRHHu+	 H  IHy?HHt7IHxHy(Hy#IH
 	 H		   	 IHIV HSH[pH  H{ w  H	 HL^	 HHw  HISHHu
HVHR0HU  IOI9O ~HIGHHAIGHIz	    HHt$@HCHP0HU?
 H$   '
   H
 R
 6  i  Iu
IFIP0Ll$(%uHdH ?
 H$   
   Ho
 
 6    H>
 H$   
   H@
 
 6    H>
 H$   t
   H
 
 !6    MFH
7	 HX	 M@H	k	 IHQ>
 H$   #
   H
 N
 6  e  H~H
	 H	 A   H		 
HxcH=
 H$   
   Hb
 
 5    }	 Ht Hq	 HH    	 Hu
HGHP0H$   ILL|$XLt$`Ll$hH|$pHt$xH$   HtHE u
HEHP0HL$HH$   Ht
HuHAP0HL$0Ht
HuHAP0HD$8HtH u
HPHR0IHĐ   A\H<
 H$   
   HV
 
 5  HtHu
HGHP0MtIu
IGIP0HtHu
HCHP0H$   Ht
HuHAP0HL$ Ht
HuHAP0HL$(HtHuHAP0E3E3L

 D
 A
 H
:	 %zHHPHHH   HXHhHxL`3E3H3H$  HD$(HD$0HD$ HD$HHC3L   Ld$`Ld$pLd$@Ld$PLd$XHL$8MtHY
 HAH2L@@MtH>
 HH AHH(
 HG	 HH$   L$   L$   L$   Hu'H;
 
   $
 6  H
 u  H		 3H$   H9G   HwH$   H   H_HHHHHuHAP0HH\LHu*H:
 k
   
 6  H
 L  Hu
HFHP0H$   3H$   Hu
HGHP03IE u
IEIP03	 LHunH:
 L$   
   H
 
 6  i  H\LHuH9
 L$   
   HB
 
 6  *  HK H;
P	 uFH
_	 H	 H	g	 L9
 L$   L
 K
   }
 6    HQ
 ~	 HHu/H<9
 L$   
   H
 9
 6    H@H;Q~	    H;L~	    HI	 HH$   Hu*H8
 
   
 6  H?
 L.  H@L   Mu;H8
 r
   
 6  H
 L  HHH$   E3Hu
HGHP03NtMuEH}	 H9FuL;f#	  HFIJ|HI+L;f	  I>IHIHAHH  HL$XHH|$XHt
HuHAP0Hs
 H

 3H}	 HH$  HtH HSHH$  H$  HAL   MtHA
 AH,L@@MtH)
 H AHH
 @~	 HH  H$  HuHAP0H
 Hw|	 H$  H<  H
 H

 H|	 HHD$0HtH HMRHHD$0H  HFL   MtH}
 HAHHD$ <L@@MtH]
 HH AHHD$ HB
 Ha}	 HHD$ H0  Hu
HFHP0H
 HL$X{	 HHD$0H  H
.{	 HsH|$8H9.  LCLD$8M  H[HD$ I HH HH\$ uH@P0HT$0LD$8H{	 HsH9urE3L$   H$   H$   EAHRHD$(H+  HD$8H u
HPHR0HL$03HH\$8uHAP0H\$0H\$       w{	 HHD$HH0  HL$8E3HHHD$03HL$8HL$0HHB ]THD$(H  HL$HHuHAP0H|$H-H>VHD$(HB  HL$0HuHAP0H|$0Hu	HHP0   z	 HHD$ H  H$  H
?
 E3HCHD$(HHC 3H$  SHD$(Hc  Hu
HCHP0H@y	 HuH|$ H9)  HUHT$ H  H]HHHHHuHAP0HT$ Hy	 HsH9umHD$(E3H$   H$   EAHH$   PHH  HL$ HuHAP0HL$(3HH\$ uHAP0H\$(      y	 HH$  H  HD$ 3E3HAHD$(HT$ HT$(HHA HzRHHv  H$  HuHAP03H$  5H\$(HHMTHH  Hu
HCHP0HD$(    HE u	HHP0IM3I9M ~HIEH<HAIEHIsy	 9  Hu
HGHP0H$   3HM2
 L$   
   H
 J
 7    H2
 L$   
   H
 
 07  u  H1
 L$   
   H^
 
 *7  F  H1
 L$   
   H/
 
 S7    H1
 L$   c
   H 
 
 i7    Hb1
 L$   4
   H
 _
 c7    H31
 L$   
   H
 0
 o7    H1
 L$   
   Hs
 
 L7  [  H0
 L$   
   HD
 
 >7  ,  H0
 L$   x
   H
 
 67  
  Hw0
 L$   I
   H
 t
 7  
  HH0
 L$   
   H
 E
 7  
  H0
 L$   
   H
 
 7  p
  H/
 L$   
   HY
 
 7  A
  H/
 L$   
   H*
 
 6  
  H/
 L$   ^
   H
 
 6  	  H]/
 L$   /
   H
 Z
 6  	  u	 HtHw	 HHqtYnt	 Hu
HFHP0H$   E3MLl$`&yVH.
 
   
 }7  HH
 	  H.
 L$   
   H#
 
 6  	  t	IE E
  H$   HI H;
u	 u>H
+u	 H	 H	3w	 LL.
 &
   L
 Q
 7  d	  H
 s	 LHu'H.
 
   
 7  H}
 o     %t	 HHu*H-
 
   
 7  HC
 L2  I$H
x
 E3HL`Lh LLHu*H-
 `
   
 7  H
 L  Hu
HFHP0IEH;r	    H;r	    HIH$   t	 H$   Hu/H-
 L$   
   H{
 	
 7  c  H@H   Ht$xHuQH,
 L$   
   H7
 
 7    IE 33ML$   Ht$xH$   L$   IE u
IEIP0ILHL$hHuoH$   Hq	 H9Fu0H;^  HFHLLlH$   IE HHL$h;H;^  L)HLIE HH$   HL$hILH  IEHq	 H;   H;q	    Is	 HH$  H?  IE uIEIP0H$  HA3H   HH  L$     IHH  IӍVH6Y  I$uID$IP03H$  @IMH  H;u
I}Im IEH8HhHHE IE u
IEIP0HL$pHH\$pHt
HuHAP0HL$@3Hl$@Ht
HuHAP0HC3H;o	 tYH;o	 tPHIFr	 LH0  H@L   Mu3HK*
 %
   W
 8  H
   HE3LE3OtMuGHVo	 I9Eu M;e  IEIJlHE I,M;e  I.IHE IIAHH  HL$PHl$PHt
HuHAP0HHn	 HH  HxHwhH   H~     HD$@H;p	 t"H&HHuo	 H  3Hy>HHt6HHxHy'Hy"3H
o	 H	]n	 @  Wn	 IHHV HUHpH  H   Hpo	 HL$@L2o	 HH  HHWHHu
HSHR0H  HE u
HEHP0H\$pHT$PLH3o	 E  Hu
HGHP03n	 Ht Hp	 HHj  nm	 IE H$   HL$hHt$xL$   IEIP0HL$hzH'
 
   
 7  H;
 U  L$  I$uID$IP0E3
uHMHy'
 S
   
 8  H
    HR'
 ,
   ^
 7  H
   H+'
 
   7
 8  H
   H'
 L$   ֿ
   Hs
 
 J8  [  L@H
m	 H	 M@H	o	 3H&
 L$   
   H#
 
 G8    H&
 L$   W
   H
 
 E8     HV&
 L$   (
   H
 S
 58     H~H
l	 H	 A   H	o	 
HxKH%
 Ҿ
   
 7  He
 Zl	 Hn  H}n	 HHgtk	 H$   M  H%
 v
   
 7  H	
 MtIE u
IEIP0L$  L$  HtHu
HGHP0MtIu
IFIP0MtI$uID$IP0HtHE u
HEHP0HL$(Ht
HuHAP0HL$0HtHuHAP0Ld$`Ld$`HL$ Ht
HuHAP0HL$8Ht
HuHAP0HL$HHt
HuHAP0L

 DY
 
 H
	 sbE3$H$   Hu
HFHP0Ld$`MI$L$   L$   H$   H$   H$   H$   MtI$uID$IP0HL$pL$   Ht
HuHAP0HL$@Ht
HuHAP0HL$PHt
HuHAP0HD$XHtH u
HPHR0IL$   H   +H8LJLj	 E3H;i	 A3M;A   MuH
i	 H	 H	k	 FL;uj	 uL;
h	 t]L;
h	 tTIAH
i	 MJH	L	 H	 HD$ k	 H
"
 q
 #  
 [A  3H

 H8H8l@SUVWATAUAVH Hh	 3L0H\$`HMn`MfhInpH\$hHH\$pMtIE MtI$HtHE   H4i	 INHL
!
 L   AAN  L
L
 
 D
 I;trH'  I@   s
I35HAH;f	 t!      t
   rIf	 3<b   L
ռ
 +
 D`
 DH
f	 A>_LL$pLD$hHT$`IVy
   
 [N  ^HV
 H
7
 E3G@HHu
 gN  *E3E33HcLHu
HCHP0
 kN  
   H 
 H\$`Ht$hH|$pH

 LMIIUHtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L

 D
 >
 H
_	 "^H A^A]A\_^][MtIE u
IEIP0MtI$uID$IP0HtHE u
HEHP0H A^A]A\_^][H(IL$0d	 Hu9L

 D@PH
	   M
 P   
   L

 c]3H(+H(Ht	H(鎎H
_f	 H	 H	g	 H(@SH HHt
H [(He	 H HAHHIH9 uHAP0H_e	 HC3H [@SH HHt
H [H!e	 H HA HHI H9 uHAP0Hd	 HC 3H [H(A(e	 Hu9L

 D@TH
	   ߶
 T   
   L
r
 [3H(H(Ht	H(H
d	 H	 H	f	 H(@SH HHt
H [XH!d	 H HA8HHI8H9 uHAP0Hc	 HC83H [H(AHd	 Hu9L

 D@XH
*	   ߵ
 X   
   L
r
 Z3H(H(Ht	H(H
c	 H	 H	e	 H(@SH HHt
H [XH!c	 H HA`HHI`H9 uHAP0Hb	 HC`3H [@SH HHt
H [Hb	 H HA HHI H9 uHAP0Hb	 HC 3H [H\$Ht$WH03Hty'H
 
    
 >\  H
   3a	 He
 Hu'Hq
 K
    }
 ?\  H޶
   H
~	 3jc	 H
 Hu'H/
 	
    ;
 @\  H
 i  H
g~	 30b	 Hѹ
 Hu'H
 ǳ
    
 A\  HZ
 '  sy'H
 
    ɼ
 L\  H*
   HF
 H
?	 E3E3D$   a	 H
 HE  H HW_	 H8
 Hu'HL
 &
    X
 g\  H
   H
 H
	 H b	 H
 Hu'H
 ܲ
    
 i\  Ho
 <  H
	 b	 H
 Hu'H
 
    λ
 j\  H/
   L
 H

 H	 ^	 y'H|
 V
    
 n\  H
   y'HL
 &
    X
 p\  H
   95J
 tFL
 H
.
 H/	 ]	 y'H
 ر
    

 u\  Hk
 8  Iy'H
 
    ں
 \  H;
   Y,y'H
 x
    
 \  H
   H'/
 H\	 y'Hc
 =
 E   o
 \  Hг
   H
T
 He	 LH5/
 \	 y'H
 
 E   &
 \  H
 T  Hc
 H<6
 Hk\	 y'H
 
   
 \  HE
   H
ɹ
 H	 LH5(6
 *\	 y'H
 i
   
 \  H
 
  H
 HA7
 H[	 y'HM
 '
 f   Y
 \  H
 
  H
 H8
 H507
 H[	 y'H
 ޯ
 i   
 \  Hq
 >
  He
 H9
 H5w8
 HN[	 y'H
 
   Ǹ
 \  H(
   H$
 H;
 H59
 H[	 y'Hr
 L
   ~
 \  H߱
   H	 H
	 E3Ah  H5:
 HŸ
 pHa
 Hu'H-
 
 	   !
 \  H
 O  E3HO	 H
P	 EA`KpH
 Hu'H
 
    Է
 \  H5
   H	 H
	 E3AH
  oHշ
 Hu'H
 S
    
 \  H
   H	 H
	 E3A0  oH
 Hu'H2
 
    6
 \  H
 d  E3H	 H
	 EAP`oHI
 Hu'H
 
    
 \  HJ
   Hn	 H
o	 E3A   oH
 Hu'H
 h
 u  
 \  H
 
  yly'H^
 8
    j
 \  H˯
 
  u'H-
 
 #   9
 \  H
 g
  H

 A3KHHu'H

 Ƭ
 &   
 \  H
Y
 	  Hm
 H

 LUY	 y
 &   
 \  	  Hu
HCHP0H

 A3JHHuH
 '   z
 \  w	  HV
 H
'
 LX	 y
 '   F
 \  C	  Hu
HCHP0H

 A3JHHuѫ
 (   
 \   	  Hϱ
 H

 LgX	 y
 (   ϴ
 \    Hu
HCHP0H

 A3IHHuZ
 *   
 \    H
 H
9
 LW	 y&
 *   X
 \  U  Hu
HCHP0H

 A31IHHu
 ,   
 \    H
 H
±
 LyW	 y
 ,   
 \    Hu
HCHP0H
u
 A3HHHul
 -   
 \    H*
 H
K
 LW	 y8
 -   j
 \  g  Hu
HCHP0   V	 HHu
 .   .
 ]  +  HB
 AHH HKH-
 HHӮ
 H HKHŮ
 HAH
r
 GHHu'H

 
 .   ²
 ]  H
#
   Hu
HCHP0H
 HIHHuI
 .   {
 ]  x  H
 H
(
 LU	 y
 .   G
 ]  D  Hu
HCHP0H
 HHHHuը
 .   
 ]    H˭
 H

 LkU	 y
 .   ӱ
 ]    Hu
HCHP0Hu
HGHP0   sT	 HHu'Ht
 N
 /   
 #]  H
   Hͪ
 AHH HOH
 HH
 H HOH
 HAH
 H HOH
 HAH
 H HOH
 HAH
 H HOH
 HA H

 EHHu
 /   ɰ
 4]    Hu
HGHP0H

 HGHHuW
 /   
 7]    Hݩ
 H
6
 LS	 y#
 /   U
 9]  R  Hu
HGHP0H
 HFHHu
 /   
 ;]    Hq
 H
­
 LyS	 y
 /   
 =]    Hu
HGHP0H5
 H-FHHuo
 /   
 ?]    H
 H
N
 LS	 y;
 /   m
 A]  j  Hu
HGHP0HI
 HEHHu
 /   -
 C]  *  H
 H
ڬ
 LR	 yǥ
 0   
 E]    Hu
HGHP0Hm
 HEEHHu
 /   
 G]    H=
 H
f
 LR	 yS
 0   
 I]    Hu
HGHP0HHu
HCHP0H
>
 0HHu
 2   5
 T]  2  H@H
 HL   MtAL@@Mt	H AR	 HHu
 2   ݭ
 V]    Hu
HCHP0H
 E3H*HHuh
 2   
 Y]    Hu
HGHP0Hf
 H
7
 LHP	 y!
 2   S
 \]  P  Hu
HCHP0L
 H
0
 3HR	 HHuڣ
 l  
 f]  	  Hx
 H

 LpP	 y
 l  ج
 h]     Hu
HCHP0L
 H
M
 3Q	 HHu_
 o  
 r]     HE
 H
>
 LO	 y+
 o  ]
 t]  ]Hu
HCHP0%O	 HHu3
 |]  )HJ
 H

 LO	    
 ~]  ¢
    H	
 HX
 HtHu
HCHP0HtHu
HGHP0H

 H   H95o
 t#L

 Dc
 H
H	 3GH

 HuHAP0H5n
 H\$@Ht$HH0_Hu^HCHH\$@Ht$HH0_H`0H	
 
    +
 e\  H
 O	 HuH
Q	 H	 H	Q	 H\$@Ht$HH0_\H\$Hl$VWATH@H'O	 HzILH\$pHM   HtH   HZH\$pIcN	 HHu)H  Hۦ
 H
N	 HtHHD$pHH   H	 LL$pH.
 HD$(E3HH|$ 0y
'     H\$p   H   H   Hy3L
	    L
	 HHj	 H|$0H~	 L	 HDHy	 HD$(HL$ H
 N	 H	_P	 '  L
C
 H
\	 A  P
 

   L

 *E3HZHI'^H\$`Hl$hH@A\_^LI[IkIsI{ ATAUAVH`H=lM	 H-K	 H5K	 LbI{IkIsMLIM%  Mt0Ht!HtH1  Hr(IsHj Hl$HHzH|$@IvL	 HIMtHt1HtT{H  Hݤ
 IL	 HtHHD$@HHg  Hl
 IK	 HtHHD$HHH>  H[
 IK	 HtHHD$PHH  HҘ	 LL$@H
 HD$(E3ILd$ 9.y
)     Ht$PHl$HH|$@   M   H   H   H   My3L
"	    L
$	 HHh	 Ld$0H|	 L6	 HDH	 HD$(HL$ H
K	 H	M	 )  L

 H
.	 A  
 
   L
9
 B3Hr(Hj HzLLHIkL\$`I[ Ik(Is0I{8IA^A]A\H\$Hl$VWATH@HgI	 HzILH\$pHM   HtH   HZH\$pI3J	 HHu)H  H{
 HI	 HtHHD$pHH   H	 LL$pH.
 HD$(E3HH|$ Y,y
5     H\$p   H   H   Hy3L
`	    L
b	 HHf	 H|$0HOz	 L	 HDHI	 HD$(HL$ H
I	 H	/L	 5  L

 H
|	 A   
 ڛ
   L
w
 @3HZHI藸H\$`Hl$hH@A\_^H\$Hl$VWATH@HG	 HzILH\$pHM   HtH   HZH\$pIH	 HHu)H  H˛
 H*H	 HtHHD$pHH   H	 LL$pH
 HD$(E3HH|$ *y
o6     H\$p   H   H   Hy3L
	    L
	 HHe	 H|$0Hx	 L,	 HDH	 HD$(HL$ H
@H	 H	J	 }6  L
c
 H
	 A  p
 *
   L
ǜ
 J?3HZHI'H\$`Hl$hH@A\_^H(Ht	H(H
/H	 H	 H	I	 H(DL$ DD$T$L$SUVWATHp  HD$@AA؋/Hb
 HD$ L
b
 L$  HXi	 H
a
 茬 ̅y/Hl
 HD$ L
b
 L$  HEi	 H
.
 Y ̅/H}b
 HD$ L
ib
 L$  H*i	 H

 & E/HIb
 HD$ L
5b
 L$  Hi	 H
ǂ
  fn* ) D,G;tt
m     DBHL$pTA	 H$  H$   A	 Hh	 H$   ќ IcHL$0@	 H$   LcAJ   HPH$   @	 HHg	 芜 Hȋw@	    HL$0?	 HH9h	 H$   X HHu3
HHcIHHVkdřH!@	 HHg	  Hg	 Hg	 $   HEH$    H$  H$   }@	 HT$HHL$p=@	 H$  LHAHL$H@	 HL$p@	 Hp  A\_^][@SH H
 H
d
 H+
 H輂 H+HH [H\$Hl$Ht$WATAUH0HyXHq(Hi(MLLHT$ H HH HtH;tA	 H9{u2SHT$ MH HHHu@	 HHu3HH@0H9Cu@	 HSIH@]?	 H\$PHl$XHt$`H0A]A\_@UVWATAUAVAWH  HǄ$   H$  LE3IL|$`L|$hL|$pH$   c>	 H$   T>	 MML$  L$  E3H[
 H
ܞ
 LHu'HX Hٗ
 +
 y   ]
   M  HH$  LphAACAFACINHHu'H H
 Ԕ
 }   
 7  
  LHL;
A	 tIMILA}	 HB}	 H
B	 H	D	 L L,
 ~
 }   
 9  
  HFHHNL9!uHAP0H~IN8'HHu'HX Hٖ
 +
 ~   ]
 G  M
  LHL;
u@	 tIMIL|	 H|	 H
A	 H	D	 L L
 Փ
 ~   
 I  b  HF HHN L9!uHAP0H~ AFhF(3?	 Hu'H H)
 {
    
 a    HHD$`I   I;   v
>	 IFpHD$PH\$X(D$PfD$PHt$PH|$X    I   I9   v=	 HtI;vpt=	 AH;  Hu=	 MLI;{ r=	 HG H+GHHH$   Huh=	 MLI;{ rT=	 H_H;_ vD=	 HHu6=	 MLI;[ r"=	 L|$@D$8  D|$0H\$(L|$ A   L$   AQHU
 HH  HH   HL$hHD$hHt
HuHAP0LEHM HHAL;AI;tHHEJI@HEHH?	 t(Huf<	 MLI;{ rR<	 H0iH H#
 u
    
   H$  
  Hs H
 F
    x
   H$  `
  33=	 HHu'H4 H
 
    9
   	  I   I;   v;	 I   HD$PH\$X(D$PfD$PIHt$PHl$X
II   I9   vL;	 Ht	I;   t8;	 H;  Hu$;	 MLI;k r;	 HH$   9	 Hu:	 MLI;k r:	 H(H$   H$   n9	 H$   H$   9	 HH$   H@H{ rHKHKII;}HH33<	 L'H=>	  tE3>	 LE3E3<	 LHQ9	 Mt|HOH9O ~I$HGL$HAHGIHh=	 u%I$ID$IP0IH@ H
 
    E
     H H
 
    
   y  H|$pH

 LHu*H
 H
Z
 
    ޗ
   I]  H@L   MtHo
 IAL2L@@MtHT
 H IALH>
 Ie<	 LMu*HV Hא
 )
    [
   I  I$uID$IP0   V;	 LHu*H H
 ڍ
    
   I  HHxHD$`H ID$ E3IH

 HH$  Hu*H
 H
(
 z
    
   I+  I$uID$IP0MIuH|9	 H9y  MeMl  I]I$HILHuHAP0HsH-:	 H9   L$   H$   E3EAH$   HHHu'H Hg
 
    
   F  I$uID$IP0MHE u
HEHP0L$       9	 HH$  Hu'H
q H

 D
    v
     L`MHh L$  E3HHHHu'H! H
 
    &
     H$  HuHAP0L$  SHIGHHu'H HI
 
    ͔
   (  HE u
HEHP0L$  IE u	HIP0MH$  HF0HHN0L99uHAP0H~0Ip  
HHu'H> H
 
    C
     HF@HHN@L9)uHAP0H~@A  FHI  H$(  4	 HH$   H@H{ rHKHKIII;}HH337	 H'H=9	  tE39	 HE3E3s7	 HH4	 Hu'H[ H܌
 .
    `
 7    HFPHHNPH9 uHAP0H~PI  HHu'H H
 ׉
    	
 F  d  HFXHHNXH9 uHAP0H~X35	 HHu'H H2
 
    
 U    I  I;   v4	 I   H$   H$   ($   fD$PHt$PHl$Xffff     I   I9  v3	 Ht	I;   t3	 H;D  Hu3	 MLI;k r3	 HH$   %2	 Hur3	 MLI;k r^3	 H(H$   H$   1	 H$   H$P  F2	 HH$   H@H{ rHKHKIII;}HH33B5	 L'H=U7	  tE3J7	 LE3E3!5	 LH1	 MtnHOH9O ~IE HGL,HAHGIH5	 uIE IEIP0H H@
 
    Đ
 `  "H H
 n
    
 ^  HtHu
HGHP0H$  H$  MtI$uID$IP0MtIE u
IEIP0H$  Ht
HuHAP0HtHu
HGHP0H$  H$  L
l
 D
 
 H
o	 +*H$  HF`HHN`H9 uHAP0H~`HLHtHu
HFHP0HL$`Ht
HuHAP0HL$hHt
HuHAP0HD$pHtH uHPHR0H$   /	 H$   /	 IH$  HĀ  A_A^A]A\_^]H\$Hl$Ht$H|$ ATHPH      ?)t$@HAH=
 H5ݨ
 HH;vW0	 H=Ш
 H5
 H:
 H
 Hl$(H+
 H\$ (t$ HuH;v
0	 Hk
 H\$ Ht$(ZH
Ш
 H+ft$ H&q H0H+Hu/	 E3LH| I;{ wHtH3H;xs/	 H|$((D$ HL$ HT$0fD$ HHHA)t$ H|$ H\$(HBLd$8Hl$0HtH;tY/	 L;   ft$0Hu?/	 E3LI;[w+/	 HD$0HsHu/	 E3LI;s r/	 HHPHu.	 E3LI;[w.	 HH\$((t$ `H\$`Hl$hHt$p(t$@H|$xHPA\@SH   HD$ H
 H+p
 HtNHyP	 HL$(V-	 HL$P.	 H1
 HD$PHT$(HL$hU-	 H՝ HL$P_ H

 ^a H

 Ra 3H!
 H

 H+HHtKfD  H;r
-	 H

 LMtI    IH
ѥ
 HHϥ
 H+HH;rH

 ` H
     H=
 H
.
 H+HHu
t-	 H

 HHc
 H<
 H
-
 H+HHuC-	 H<
 H


 HHH

 HĐ   [@SH   HD$ H
 H+
 HuNH1O	 HL$(+	 HL$P
-	 H/
 HD$PHT$(HL$h+	 HE HL$P H
k
 m E3HH

 ` Lm
 IH+[
 HtILP
 H

 m E3HH
פ
 ` L
 IH+q
 HtILf
 H

 Jm HH
 H
	
 H+HH;sEH;r
+	 H

 LMtI    IH
Σ
 HH̣
 H+HH;rH
A
 l E3HH

 _ LC
 IH+1
 HtIL&
 H

 HĐ   [W H\$ WH0H
 H=
 3H+
 HHT$@HuLL
 L+IH

 Hl$HHt$PHH+HI;sHAHHȣ
    HH;v*	 H

 H=
 H
 HHt$(H+HHT$ HuH)H;v
}*	 HN
 HtH;tf*	 H+H(D$ LL$@HT$ H
!
 A   fD$ > H-!
 H;-"
 v"*	 H=
 Hu*	 LLHL I;K wHtHHH;Hs)	 H
 H=
 H+
 HHT$@HuLL

 L+IH

 HH+HI;sHAHHڡ
    HH;vw)	 H

 H=
 H
 HHt$(H+HHT$ HuH)H;v
7)	 H`
 HtH;t )	 H+H(D$ LL$@HT$ H
3
 A   fD$ = H-3
 H;-4
 v(	 H=
 Hu(	 LLHL I;K wHtHHH;Hs(	 H
 H=H
 H+
 HHT$@HuLL7
 L+IH
!
 HH+HI;sHAHH
    HH;v1(	 H

 H=۟
 H
 HHt$(H+HHT$ HuH)H;v
'	 H
 HtH;t'	 H+H(D$ LL$@HT$ H
]
 A   fD$ l< H-]
 H;-^
 v'	 H=/
 Hu'	 LLHD I;C wHtHH;Cs]'	 HF
 H
W
  HC
 H
t
 ט H(
 H

 Ht$PHl$HH\$XH0_鰘 @WH@HD$ H\$XHl$`Ht$h)t$0IIf(HHɝ
 HH0H
 H;
 r0   H
6
 Q HH\$PHt)f(H L	
 LHkHs HD$pHC(3HHH\$XHl$`Ht$h(t$0H@_HVWATAUAVH   HD$ HXHh)p)xD)@D)HD)PIHLL$    H=
 LIH=
 H;=Ҝ
 rIH
^
 y LH=
 Ht2IHI+Hffffff     HHHHuH=
 fWf(3H|EHVLCIIJ    HBXpHBXpHXpHBXpH IuH;sHXpHH;rfEL*
 HyDXA^3H|tLFHSHHH    I@@\YXI@H\YXI @\YXI@H\YXI HuH;sH@\YXHH;rHCfEL*HyDXf(A^
 fD(HIH=&
 H;=
 rIH

  HH=
 
Ԑ
 f/vEfA(
 
,
 ^$   H  HH$   HHH=
    EY,
 A^E3H   H~HMLL+HSHHL    HG@\YAI	H\Y	HG@\YAHH\YIH H HuH=
 L;s4JT H+HI+H2@\YHHuH=̙
 HH0H=
 H;=
 r0   H
9
 T HH$   Ht%fA(H H
 HH^Ln Hn(3I6IL$   I[8Ik@(t$p(|$`E(CE(KE(SIA^A]A\_^HT$HL$SUVWATH0HD$ HHE3Dd$pHz H+zHAL$	 HtH0IHDd$pLD$pHH
^ IHC H+CHHtVD  HC H+CHH;r!	 HkHF H+FHH;rn!	 HND HHC H+CHH;rHKHt] LcLc Lc(HI HH0A\_^][HHHUVWATAUAVAWH   HD$ HX)p)xHH@        Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN HtH3HHC    HC     HC(    Ǆ$      HGH;!	    H;!	 t{IHm$	 HHu+L
 L
x
 A/   DVu
 KQ  ~
   H@L   Mu4L
[ L
w
 A/   Du
 MQ  L~
 }  HE3E3Nl=;
 MuEHL!	 H9GuL;g|  HGJHII,L;g^  I] HIIHAHH  ILHt
HuHQR0H 	 H9Cus$   H>#	 f($   f.zu"	 H!  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$pHH;v	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;vk	 HT$PHtH;tV	 H+H(D$0fD$@L$   A   HT$@HL$P, Hl$hH;l$pv	 H\$PHu	 E3LHL I;K wHtH3H;H,	 !L
: L
u
 A0   Dr
 xQ  +|
 H$   W 	 Ht~H"	 HHt:	 `L
 L
Ru
 A/   Dr
 hQ  {
 H$   HuHGHP0L
u
 Dpr
 {
 H
_	 %Hu
HGHP0HT$PH$   HcM MtIuIFIP0HL$hHt HD$h    HD$p    HD$x    HL$P HL$   I[HA(sA({IA_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       s Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN6 HtH3HHC    HC     HC(    Ǆ$      HGH;a	    H;\	 t{HH	 HHu+L
 L
os
 A/   Dp
 Q  y
   H@L   Mu3L
 L
4s
 A/   Dp
 Q  y
 Q  H3E3LlfMuEH	 H9GuH;oX  HGHHHI,H;o:  I] HHIHAHH  ILHt
HuHQR0H$HH$   Hu	 H  H\$hHu3HT$xH+HHL$pHH+HH;sH1HAHD$p%HH;v7	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;v	 HT$PMtL;t	 H+H(D$0fD$@L$   A   HT$@HL$Pz. Ld$hL;d$pv	 H\$PHu	 E3LII;K wHtH3H;HPj	 EL
 L
?q
 A0   Dn
 Q  w
 H$   WG	 Ht~H;	 HHht	 `L
u L
p
 A/   D5n
 Q  fw
 H$   HuHGHP0L
p
 Dn
 :w
 H
+~	 %Hu
HGHP0HT$PH$   HH MtIuIFIP0HL$hHt~ HD$h    HD$p    HD$x    HL$PY HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMI Ǆ$     IAN Ht
HL$PHIHD$PLt$hLt$pLt$x    Ht
H$   HIH$   L$   L$   L$   HCH
	 H;a  H;	 T  Ha	 HHu'H Hn
 Ml
    u
 LR     H@L   HAHHtjA   HAHHtVHAHAVy$H
  H
n
 k
    u
 SR  aHU  HCHP0E3F  Hu
HCHP03uIDH H.n
 k
    t
 [R  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   H	 H
	 H	!	 2Mx-Hn5	 L
G	 ILDH	 H
	 H		 H HWm
 j
    s
 8R    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$PE HL$8Ht Lt$8Lt$@Lt$HHL$  	 Ht$HE Hl
 j
    :s
 jR  tHHL$ ;HH$   
E HL$8Ht Lt$8Lt$@Lt$HHL$  	 HtGH H@l
 i
    r
 kR  L
%l
 Dzi
 r
 H
y	 ;  H$   H$   HHT$PHL$  HH$    HH$    H$   I5D IO0H$   $D H$   Ht L$   L$   L$  H$    H$   Ht L$   L$   L$   H$   a HL$8HtQ Lt$8Lt$@Lt$HHL$ 8 H$(  Ht% L$(  L$0  L$8  H$    MtI$uID$IP0HtHE uHEHP0H$   Ht L$   L$   L$   H$    HL$hHt Lt$hLt$pLt$xHL$Pr IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       3 Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN HtH3HHC    HC     HC(    Ǆ$      HGH;!	    H;	 t{HH	 HHu+L
 L
/i
 A/   D~f
 R  o
   H@L   Mu3L
 L
h
 A/   DCf
 R  to
 M  H3E3LlfMuEH|	 H9GuH;oT  HGHHHI,H;o6  I] HHIHAHH  ILHt
HuHQR0Ht$   uh	 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;v	 HT$PMtL;t	 H+H(D$0fD$@L$   A   HT$@HL$P& Ld$hL;d$pvl	 H\$PHu\	 E3LII;K wHtH3H;HT.	 IL
 L
g
 A0   DRd
 R  m
 H$   W	 Ht~H	 HH,
t	 `L
9 L
f
 A/   Dc
 R  *m
 H$   HuHGHP0L
sf
 Dc
 l
 H
t	 %Hu
HGHP0HT$PH$   H MtIuIFIP0HL$hHtB HD$h    HD$p    HD$x    HL$P HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMIO Ǆ$     IAN Ht
HL$PHIHD$PLt$hLt$pLt$x    Ht
H$   HIH$   L$   L$   L$   HCH
	 H;a  H;	 T  H!	 HHu'HJ Hd
 
b
    ?k
 6S     H@L   HAHHtjA   HAHHtVHAHAVۯy$H
 H
Qd
 a
    j
 =S  aHU  HCHP0E3F  Hu
HCHP03耮uIH} Hc
 @a
    rj
 ES  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   Hy	 H
	 H		 2Mx-H.+	 L
h=	 ILDHu	 H
v	 H		 H Hc
 i`
    i
 "S    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$Pp HL$8Ht Lt$8Lt$@Lt$HHL$  
	 Ht$H Hvb
 _
    h
 TS  tHHL$ HH$   : HL$8Htf Lt$8Lt$@Lt$HHL$ M C
	 HtGH H b
 R_
    h
 US  L
a
 D:_
 ph
 H
yp	 T;  H$   H$  芷 HHT$PHL$ X HH$   G HH$   V H$   I% IO0H$   9 H$   Ht} L$   L$   L$  H$   X H$   HtF L$   L$   L$   H$   ! HL$8Ht Lt$8Lt$@Lt$HHL$  H$(  Ht L$(  L$0  L$8  H$   MtI$uID$IP0HtHE uHEHP0H$   Ht L$   L$   L$   H$   [ HL$hHtK Lt$hLt$pLt$xHL$P2 IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@        Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN HtH3HHC    HC     HC(    Ǆ$      HGH;	    H;	 t{IHU	 HHu+L
~ L
^
 A/   D>\
 S  oe
   H@L   Mu4L
C L
^
 A/   D\
 S  4e
 N  HE3E3NlMuEH<	 H9GuL;gU  HGJHII,L;g7  I] HIIHAHH  ILHt
HuHQR0H$$   u(		 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;v	 HT$PHtH;tm	 H+H(D$0fD$@L$   A   HT$@HL$PN Hl$hH;l$pv,	 H\$PHu	 E3LHL I;K wHtH3H;HS	 HL
Q L
\
 A0   DZ
 *T  Bc
 H$   W	 Ht~H		 HHtQ	 `L
 L
i\
 A/   DY
 T  b
 H$   HuHGHP0L
2\
 DY
 b
 H
vk	 %Hu
HGHP0HT$PH$   H MtIuIFIP0HL$hHt HD$h    HD$p    HD$x    HL$P HH$   HĀ   A_A^A]A\_^]H\$Ht$H|$ ATH`HQ Igfffffff3H+QIHHHHH?H}   Hl$pHfH;r5	 HsHn%	 A   HE3H	 HH	 L L;t	H	 HK IHH+KH(HHHH?HH;rHl$pH{ H9{v	 HHsH|$(HD$ (D$ fD$ H;s v	 HH@ H{HH;{ vw	 HL$ HtH;tb	 HL$0w 	 H+LIHHHH?HHt L\$`I[Is I{(IA\HT$SH0HD$ HfWD$PHT$PK u-J D$P2H0[HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   v H$   g HT$`HK85 HHL$  H\$xHt.H$   H;tfH 	 H(H;uH\$xH
 Ll$xL$   L$   HL$` 3	 HHu'H HX
 U
    _
 >    H\$8H;\$@v 	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v> 	 HtH;t$ t, 	 L;  Hu 	 MLM;c r 	 IH$    Hu MLM;c r I(H$   H$   b H$   HL$` HH$(  H@H} rHMHMII;}HH33	 H'H=	  tE3	 HE3E3	 HHH HtlHOH9O ~HHGHHAHGHH`	 uHHCHP0HD HV
 T
   I]
 >  "H  HV
 S
   %]
 >  Hu
HGHP0HtHu
HCHP0L
aV
 DS
 \
 H
[	 IHHuHGHP0H$   I H$   : H\$8Ht.Ht$@H;tD  H H(H;uH\$8H
 Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   f H$   W HT$`HKX1 HHL$  H\$xHt.H$   H;tfH H(H;uH\$xH Ll$xL$   L$   HL$` 3
 HHu'H HT
 Q
   [
 ?    H\$8H;\$@vy HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v. HtH;t$ t L;  Hu MLM;c r IH$    Hu MLM;c r I(H$   H$   R H$   HL$` HH$(  H@H} rHMHMII;}HH33 H'H=  tE3 HE3E3 HH8 HtlHOH9O ~HHGHHAHGHHP uHHCHP0H4 HR
 P
   9Y
 ?  "H HR
 O
   Y
 ?  Hu
HGHP0HtHu
HCHP0L
QR
 DO
 X
 H
X	 IHHuHGHP0H$   9 H$   * H\$8Ht.Ht$@H;tD  H H(H;uH\$8H Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   V H$   G E3E3HT$`HK HHL$ t H\$xHt,H$   H;tH H(H;uH\$xH Ll$xL$   L$   HL$` 3 HHu'H HxP
 M
   V
 @    H\$8H;\$@ve HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8v HtH;t$ t L;  Hu MLM;c r IH$   { Hu MLM;c r I(H$   H$   B H$   HL$` HH$(  H@H} rHMHMII;}HH33 H'H=  tE3 HE3E3 HH( HtlHOH9O ~HHGHHAHGHH@ uHHCHP0H$ HN
 K
   )U
 @  "H  HN
 K
   U
 @  Hu
HGHP0HtHu
HCHP0L
AN
 DK
 T
 H
U	 IHHuHGHP0H$   ) H$    H\$8Ht.Ht$@H;tD  H H(H;uH\$8H Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   F H$   7 E3E3HT$`HK HHL$ d H\$xHt,H$   H;tH H(H;uH\$xH Ll$xL$   L$   HL$` 3 HHu'H HhL
 I
    R
 A    H\$8H;\$@vU HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8v HtH;t$ t L;  Hu MLM;c r IH$   k Hu MLM;c r I(H$   H$   2 H$   HL$` HH$(  H@H} rHMHMII;}HH33 H'H=  tE3 HE3E3t HH HtlHOH9O ~HHGHHAHGHH0 uHHCHP0H HJ
 G
    Q
 'A  "H HqJ
 G
    P
 %A  Hu
HGHP0HtHu
HCHP0L
1J
 DG
 P
 H
R	 IHHuHGHP0H$    H$   
 H\$8Ht.Ht$@H;tD  H H(H;uH\$8H Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HHHUVWATAUAVAWH   HD$PHXHLE3DxAO Ht
HL$ HIHD$ L|$8L|$@L|$HM   Q HtL0IIM~M~ M~(Ǆ$      HL$X HCH;{    H;v t{HH HHu+L
 L
H
 A/   DE
 S  	O
   H@L   Mu4L
ݬ L
NH
 A/   DE
 S  N
 g  HIMHlMuEH H9CuH;so  HCH<HHH,H;sQ  H} HHHHAHH   ILHt
HuHQR0HH$   HHL$XP H$     Hu5HT$XH$    HHL$ -_ H$   n L
« L
3G
 A0   DD
 S  M
 OC HtvH7 HHdt XL
q L
F
 A/   D1D
 S  bM
 HuHCHP0L
F
 DD
 >M
 H
U	 "Hu
HCHP0HT$ I MtI$uID$IP0HL$X H\$8Ht)H|$@H;tHb H(H;uH\$8HX L|$8L|$@L|$HHL$ ? IH$   Hİ   A_A^A]A\_^]HT$WH0HD$ H\$PHHD$@    IH HHT3 HK H HH\$PH0_HT$WH0HD$ H\$PHHD$@    IHϫ HH2 HKA H8 HH\$PH0_LD$WH0HD$ H\$HIHD$@    I責 HHw2 HO H HH\$HH0_HL@WHpHD$ HXHp )pIf(HǄ$       HHPIIL H^3$   H\$(H$   HD$0HSHCHD$@HT$Ht$PHT$8HL$( HH1 H H HL\$pI[Is((t$`I_HT$WH0HD$ H\$PHHD$@    IH诲 HH: HK H HH\$PH0_HT$WH0HD$ H\$PHHD$@    IHO HHT: HK! H HH\$PH0_LD$WH0HD$ H\$HIHD$@    I2 HH9 HO H HH\$HH0_LD$WH0HD$ H\$HHt$XIHD$@    L$@HT$@I2J HT$@HN$J HHY9 HN& H HH\$HHt$XH0_++++HL@HHUWATAVH  )p)xD)@D)xD)hD)XD)HD)8D)BtB|IMLLFfEWA\Y5	 D%	 fA.D-	 z#u!D=	 fA(fAT\DX  D=	 f(f(fATfATf/fD($  EY$  v
H$  H$  DfE.z	ufA(@f/v
H$  H$   A^YAX L$  f(AYfE.z?u=fA/v   f(fn^X^fA(Y\DX$fA/wfAWXfA(D^A\DXI;EHE\E}  H$  H$  H$  H$  HI\L$  H,   L$x  HD)$   D5T
 L,IIVHHI+L$  H$  L<    fE.z'u%fE/vfA(fA(  fA(fA(   fE.z"u fE/fA(v
fA(   fA(   fA(fA(fATfATf/v_fE(E^fA(AYAXP fE/vfAWH$  L$  H$  fA(^IVf(AYfAWVfA(A^f(YAX fE/vfAWH$  L$  H$  fA(^IVYfAWI;KAf(f(YYf(Y\YYYfD(X\XYYDYf(f(\YYAXf(YD\DS~f(f(YKAY\KH;}fD(YDYfEWH   HL$0Ht$8Ht$@fAWt$ HL$0H$   L$   |$(HH$   Hl$PHHAHt$XHBHAHL$0HBHHT$hHHALD$ HBHAH$   HBHT$PH$   H$   蠾 H$  L$  H$  IVHHMII;/D($   L$x  L$  H$  H$  L$  A(sA({E(CE(KE(SE(xE(hE(XE(8IA^A\_]HWH   HǄ$   HXHhHpHٹ     3Ht
HL$PHHHD$PHl$hHl$pHl$x    Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HK7 HHL$Pɮ H$   HtLH$   H;t:HYHHt9 H+HkHkHK% H0HCH;uH$    H$   H$   H$   H$    HT$PHL$ ; HL$ !uHHu<L
 L
:
 7
   A
 !@  !@  A  H
%A	 HHL$8HtKH|$@H;t<HYD  HHt_ H+HkHkHKK H0HCH;uHL$84 Hl$8Hl$@Hl$HHL$  HL$hHtLH|$pH;t=HYfD  HHt H+HkHkHK H0HCH;uHL$h Hl$hHl$pHl$xHL$P HL$   I[IkIs I_HWH   HǄ$   HXHhHpHٹ   p 3Ht
HL$PHHHD$PHl$hHl$pHl$x   > Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HKW5 HHL$P9 H$   HtLH$   H;t:HYHHt H+HkHkHK H0HCH;uH$   { H$   H$   H$   H$   V HT$PHL$ 諫 HL$ rHHu<L
r L
7
 E5
   w>
 q@  q@  A  H
>	 PHHL$8HtKH|$@H;t<HYD  HHt H+HkHkHK H0HCH;uHL$8 Hl$8Hl$@Hl$HHL$  HL$hHtLH|$pH;t=HYfD  HHt_ H+HkHkHKK H0HCH;uHL$h4 Hl$hHl$pHl$xHL$P HL$   I[IkIs I_[HHPHHSUVWATAUAVAWH  HǄ$   )pHHE3DpAN Ht
HL$PHIHD$PHL$P苞 H$   ƀ   H$   H@H$   H H$   H@L$   MLt$@HQh Ǆ$0     IIM   # Ht
H$   HIH$   L$   L$   L$       Ht
H$   HIH$   L$   L$   L$   H$h   HCH;    H; txIHq HHu'H H5
 ]2
 T  ;
 0    H@H   HD$ Hu8HN H4
 !2
 T  S;
 2  e  HHMIHD$ NtHuDHT H9EuL;e|  HEJ<HII*L;e^  I>HIIHHH  ILHt
HuHAP03H= 98uIG     IH HH,  H@L   MtH9
 HAH2L@@MtH9
 H HAHH9
 H HH  Hu
HGHP0HFL   MtH3
 HAH2L@@MtH3
 H HAHH3
 H HH  Hu
HFHP0IH HH  H@L   MtH2
 HAL2L@@MtH2
 H HALH2
 H( LMD  Hu
HFHP0   A HH  HxLh 3E3HL$@HD$@HtHu
HAP0H3HH$  GHHH$   
 HS0H$   
 H$P  Ht< 3H$P  H$X  H$`  H$8   H$   Ht H$   H$(  H$0  H$    H   IH$  iHH$h  9 H$    H   H$h  HL$P!d HH$   H	 HK0H$   	 H$(  HD$ sH|6
 H
- H	 Lm L0
 @.
 U  r7
 b    HF H0
 .
 W  K7
   ]  H H0
 -
 W  $7
   6  H Hy0
 -
 V  6
 {    Hє HR0
 -
 V  6
 x     H H+0
 }-
 V  6
 v     H H0
 V-
 V  6
 s     H\ H/
 /-
 V  a6
 p  vH8 H/
 -
 V  =6
 n  R H  H HHtP k  H He/
 ,
 T  5
 M  HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIE u
IEIP0H H(LuHLePLmX3HEHHEPHEXMtIMtI$MtIE MMIH    H
G	  HHMHHuPH}XLuHLePLmXHt
HuHQR0HtHu
HFHP0HtHu
HGHP0HuH
^ p He Hu
HCHP0L$      HE u
HEHP0HD$PL$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   I- HT$PI耤 MtIu
IGIP0HL$@HtHuHAP0H$h  u H$   Htn E3L$   L$   L$   H$   F H$   Ht4 L$   L$   L$   H$    H$   HHD$PHHH\$8HD$0(D$0fD$ Hu H$   HD$PH;u^HHtH;t H$   H;u>HRHL$P L$   M[L$   H$   H H$   H@   H|$ H\$(fHtH;t0 H;   (t$ Hu     t gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$PB =H$   茺 L$   L$   HL$Pr I($  H  A_A^A]A\_^][HHPHHSUVWATAUAVAWH  HǄ$   )pHHE3DpAN, Ht
HL$PHIHD$PHL$P H$   ƀ   H$   H@H$   H H$   H@L$   MLt$@H\ Ǆ$0     IIM   裹 Ht
H$   HIH$   L$   L$   L$      d Ht
H$   HIH$   L$   L$   L$   H$h   HCH;}    H;x txIH HHu'H
 H)
 &
 f  0
     H@H   HD$ Hu8H΍ HO)
 &
 f  /
   e  HHMIHD$ NtHuDH H9EuL;e|  HEJ<HII*L;e^  I>HIIHHH  ILHt
HuHAP03H 98uIG     IH_ HH,  H@L   MtH\.
 HAH2L@@MtHA.
 H HAHH+.
 H HH  Hu
HGHP0HFL   MtHo(
 HAH2L@@MtHT(
 H HAHH>(
 H- HH  Hu
HFHP0IHm HH  H@L   MtH:'
 HAL2L@@MtH'
 H HALH	'
 H LMD  Hu
HFHP0    HH  HxLh 3E3HL$@HD$@HtHu
HAP0H3HH$  HHH$   d HS0H$   # H$P  Ht輵 3H$P  H$X  H$`  H$8  蕵 H$   Ht胵 H$   H$(  H$0  H$  ^ T H   IH$  ^HH$h   H$    H   H$h  HL$Pa[ HH$   Hn HK0H$   - H$(  HD$ sH*
 H
 H	 L Ln%
 "
 g  +
      HƉ HG%
 "
 i  +
 >   ]  H H %
 r"
 i  +
 =   6  Hx H$
 K"
 h  }+
 +     HQ H$
 $"
 h  V+
 (      H* H$
 !
 h  /+
 &      H H$
 !
 h  +
 #      H܈ H]$
 !
 h  *
     vH H9$
 !
 h  *
    RM H  H= HHjt k  Hd H#
 7!
 f  i*
   HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIE u
IEIP0HI H(LuHLePLmX3HEHHEPHEXMtIMtI$MtIE MMIHy   V H
	 Q HHMHHuPH}XLuHLePLmXHt
HuHQR0HtHu
HFHP0HtHu
HGHP0HuH
  H Hu
HCHP0L$      HE u
HEHP0HD$PL$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   I譗 HT$PI@ MtIu
IGIP0HL$@HtHuHAP0H$h   H$   Ht E3L$   L$   L$   H$   ư H$   Ht贰 L$   L$   L$   H$   菰 H$   HHD$PHHH\$8HD$0(D$0fD$ Hu< H$   HD$PH;u^HHtH;t H$   H;u>HRHL$P L$   M[L$   H$   H H$   H@   H|$ H\$(fHtH;t H;   (t$ Hu     t gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$P =H$    L$   L$   HL$P I($  H  A_A^A]A\_^][@SH HYHtHP H譮 H [HX PH   )p)xD)@D)HD)PD)XD
7	 fEWfA(fA(fE(D)`D)l$PD)t$@D5		 fD(fA(D)|$0fATf/fD(fA(AYL$(   D$   fff     AXfD/   DXf(f(θ   AXAXA\DYfA(D  tYtY3fA(LD$ H$   $   ^f(AX f(fD(fATf/
	    $   f(跬 Y|$(AYYA^f(fATf/$   'D(l$PD(t$@D(|$0L$   fA(A(sA({E(CE(KE(SE([E(cIHB
 H
J
  HUVWATAUAVAWH  HǄ$h  HX)p)xHL   蓬 Ht
H$   H3H$   H$   j H$   ƀ   H$   H@H$   H H$   H@HǄ$          " Ht
H$   H3H$   H$    H$0  ƀ   H$0  H@H$0  H H$0  H@HǄ$8      3H$   HT$`H$@  ~ 3E3L$  E33H;-T uEL? H	 H
} H	 L} L
 P
 	  "
   e  L
 H7"
 H7HHu'H
8 H

 
 	  ="
   d  HlDu2 Ht'H Hw
 
 	  !
   d  Hu
HCHP0E'H;-l u>Hk	 H
t H	 L L
 o
 
  !
   d  He
 H HHu'H] H
 0
 
  b!
   #d  HkDu2 Ht'H H
 
 
   !
 !  c  Hu
HCHP0EgH;- u>H	 H
 H	 L~ LA
 
    
 .  c  H
 H HHu'H~ H
 T
    
 0  Gc  HHL$hQHH$@   HL$h  Ht'H$~ H
 
   ) 
 2  b  Hu
HCHP0IOH$@  * H;- u>H 	 H
 H	 L} L<
 
   
 ?  b  H
 H HHu'H|} H
 O
   
 A  Bb  H
 H;uA      3H H9BE3H9CADteLCL;BtE3   B 8C tE3   IuE   CJ;tt
tE3   H HK 轧 E3Ai3L
g I;tE3Z3I;AtE3HA   H LH7a  HDIE u
IUIR0L$  E
a  Hu
HCHP0E  H

 ٠HHu'H
| H

 
 
  
 N  `  H@L   MtH
 HAL2L@@MtH
 H HALHj
 H LMu'H{ H
 m
 
  
 P  u`  Hu
HGHP0IEL   MtH
 IAH2L@@MtHp
 H IAHHZ
 I HHu'H
{ H
 
 
  
 S  _  IE u
IEIP0E3H;- u>H H
 H	 Lz L0
 
 
  
 X  _  H
 H LHu'Hpz H
 C
 
  u
 Z  K_  E3L$  LgHR I9$y  LwL$  Md  H_IHHHHuHAP0LcH I9$   Lt$PLl$XE3EAHT$PHHHu'Hy H=
 
 
  
 n  ^  Iu
IFIP0E3L$  IE u
IEIP0E3L$         HHu'H
Fy H

 
 
  K
 ~  !^  LpE3L$  Lh E3L$  E3HHZHHu'Hx Hl
 
 
  
   ]  Hu
HFHP03VIHHHu'Hx H
 p
 
  
 g  c]  IE u
IEIP0E3L$  Hu
I$HP03HCH H;.  H;| !  H LHu'Hx H
 
 
  
   \  Hu
HCHP0IEH   E3IHHtrA   IHHt_IHAT$^y'Hw H
 n
 
  
   v\  IE u
IEIP0HǄ$         IE u
IEIP0E3@]uIĜH-w H
  
 
  2
   \  HKHtVH~A   H/	 H
 H	 
HxdHv HN
 
 
  
   [  H;u
H{Hs HCH8HpHHHu
HCHP0HH$   3Ht$`3HL$hOHH$   H;tmH$   HL$HH$   HT$@H	HL$8HT$0(D$@fD$@(L$0fL$0LL$@LD$0H$   H$    HH$   c H$   LHD$hLHH\$8HD$0(D$0fD$@HuL H$   HD$hH;ubHMtL;t' H$   L;uBHRHL$h謿 L$   M[HǄ$       H$   H H$   H@   Ld$@H\$HMtM;t I;   (t$@Mu     t eHC    u-HH     u     HH     tH\$H+HC    uH;XuHH@    tHHD$Hft$0LD$0H$   HL$hҸ ?H$    HǄ$       HǄ$       HL$h HT$`HL$hHH$   ~ H$   HD$8HL$hHL$0H HD$HHL$@(D$0fD$0(L$@fL$@LL$0LD$@H$   HL$h H$   v HǄ$       HǄ$       HL$hT IO0H$    IOpH$    L$  H;- u>H H
 H	. LGs L
 
   L
   MX  HX
 H HHu/Hs H
 
   

   L$  W  H H9Cus
H f(=?	 f.z<u:a Ht/Hr H
 p
   
   L$  [W  Hu
HCHP0A   H;- u>H H

 H	 L5r L

 
   :
   ;W  H
 Hm HHu/Hq Hw

 

   
 
  L$  V  HHL$hQEHH$@   HL$hS U Ht/Hq H

 d

   
   L$  OV  Hu
HCHP0I   H$@   H;- u>H H
 H	 Lq L
 	
   "
   #V  H

 HU HHu/Hp H_
 	
   
   L$  U  HAAu:T Ht/Hp H
 c	
   
   L$  NU  Hu
HCHP0E   H;- u>H H
 H	 L*p L
 
   /
 *  0U  H
 Hb HHu/Ho Hl
 
   
 ,  L$  T  HAAu:a Ht/Ho H
 p
   
 .  L$  [T  Hu
HCHP0E   H;- u>HF H
 H	 L7o L

 

   <
 ;  =T  H
 Ho HHu/Hn Hy

 
   
 =  L$  S  H	

 HdHHu/Hn H3

 
   
 ?  L$  pS  Hu
HCHP0H[" Ht'H^n H	
 1
   c
 B  dS  Hu
HFHP03A   H;-δ u>H5 H
ִ H	 Lm L	
 
   
 O  S  H

 H6 HHu'Hm H@	
 
   
 Q  R  HHL$h"AHH$@  ȯ HL$h$ & Ht'Hbm H
 5
   g
 S  hR  Hu
HFHP03I   H$@  c H;-ĳ u>HS H
̳ H	۵ Ll Lu
 
   
 `  Q  H
 H, HHu'Hl H6
 
   
 b  Q  HÀu25 Ht'Hql H
 D
   v
 d  wQ  Hu
HFHP03A  H;- u>H H
 H	 Ll L
 
   
 q  Q  H	
 HI HHu'Hk HS
 
   

 s  P  H
[
 VHHu/Hk H
 j
   

 u  L$  UP  H0
 H`aHHu/HQk H
 $
   V

 w  L$  P  Hu
HCHP0A   HHG HHu/Hj Hy
 
   
 z  L$  O  Hu
HFHP03Hu
HGHP03HDy/Hj H
 i
   
 }  L$  TO  Hu
HCHP0Ee(  H;- u>H H
 H	 L.j L
 
   3
   4O  H
 Hf HHu/Hi Hp
 
   
   L$  N  H
 H HHu/Hi H)
 {
   
   L$  fN  Hu
HCHP0H
 HȮ HHu/HQi H
 $
   V
   L$  N  Hu
HGHP03HTDu: Ht/Hh Hv
 
   

   L$  M  Hu
HCHP0E   H;-_ u>Hf H
g H	v Lh L
 b
   

   M  H@
 Hǭ HHu/HPh H
 #
   U

   L$  M  Hy
 H HHu/H	h H
  
   

   L$  L  Hu
HCHP0H
 H) HHu/Hg H3
  
   	
   L$  pL  Hu
HGHP03H SDu: Ht/HVg H
 ) 
   [	
   L$  L  Hu
HCHP0E$  H;- u>H H
ȭ H	ׯ Lf Lq
    
   K  H
 H( HHu/Hf H2
    
   L$  oK  H 
 H HHu/Hjf H
 =   o
   L$  (K  Hu
HCHP0H
 H HHu/Hf H
    
   L$  J  Hu
HGHP0H
 H[HHu/He H>
    
   L$  {J  Hu
HCHP0HS- Ht/Hie H 
 <   n
   L$  <J  Hu
HGHP0A(  H;-ӫ u>H* H
۫ H	 Le L 
    
   	J  H
 H; HHu/Hd HE 
    
   L$  I  H H HHu/H}d H P   
   L$  ;I  Hu
HGHP0H H HHu/H&d H    +
   L$  H  Hu
HCHP0HO؃u: Ht/Hc HN    
   L$  H  Hu
HGHP0A,  H;-7 u>H H
? H	N Lgc L :   l
   mH  H 
 H HHu/H(c H    -
   L$  G  HQ HX HHu/Hb Hb    
   L$  G  Hu
HGHP0Hz
 H HHu/Hb H ]   
   L$  HG  Hu
HCHP0HM؃u: Ht/H1b H    6
   L$  G  Hu
HGHP0A0  H;- u>HB H
 H	 La LL    
    F  H| H HHu/Ha H
 _   
   L$  _F  H H HHu/HEa H    J
   L$  F  Hu
HGHP0H He HHu/H` Ho    
   L$  E  Hu
HCHP0HÀu:V Ht/H` H e   
 
  L$  eE  Hu
HGHP0A4  H;- u>H H
 H	 L,` L     1
   2E  H Hd HHu/H_ Hn     
   L$  D  H H HHu/H_ H' y    
   L$  dD  Hu
HGHP0H_ HƤ HHu/HO_ H "    T
   L$  
D  Hu
HCHP0HJ؃u: Ht/H^ Hw      
 !  L$  C  Hu
HGHP0A8  H;-` u>HW H
h H	w L^ L c !   
 .  C  HA Hȣ HHu/HQ^ H $ !  V 
 0  L$  $C  Hz H HHu/H
^ H  !   
 2  L$  B  Hu
HGHP0H H* HHu/H] H4  !   5  L$  qB  Hu
HCHP0H#I؃u: Ht/HZ] H - !  _ 8  L$  -B  Hu
HGHP0A<  H;-ģ u>H H
̣ H	ۥ L\ Lu  "   E  A  H H, HHu/H\ H6  "   G  L$  A  H H HHu/Hn\ H A "  s I  L$  ,A  Hu
HGHP0H_ H HHu/H\ H  "   L  L$  @  Hu
HCHP0HÀu: Ht/H[ H<  "   O  L$  @  Hu
HGHP0A@  H;-% u>Hl H
- H	< LU[ L ( #  Z \  [@  H H HHu/H[ H  #   ^  L$  ?  H? HF HHu/HZ HP  #   `  L$  ?  Hu
HGHP0H H HHu/HxZ H K #  } c  L$  6?  Hu
HCHP0Hq H9Guw
H f(f.z<u:ɠ Ht/HZ H  #  
 f  L$  >  Hu
HGHP0AH  H;-m u>H H
u H	 LY L p $   s  >  HN H՞ HHu/H^Y H 1 $  c u  L$  1>  H H HHu/HY H  $   w  L$  =  Hu
HGHP0H  H7 HHu/HX HA  $   z  L$  ~=  Hu
HCHP0H H9Guw
H3 f(f.z<u: Ht/HMX H   $  R }  L$   =  Hu
HGHP0AP  H;- u>HL H
 H	̠ LW Lf  %     <  H H HHu/HW H' y %     L$  y<  H H֜ HHu/H_W H 2 %  d   L$  <  Hu
HGHP0H8 H HHu/HW H  %  
   L$  ;  Hu
HCHP0H H9Guw
H{ f(f.z<u:Y Ht/HV H h %     L$  h;  Hu
HGHP0AX  H;- u>H H
 H	 L-V L   &  2   3;  H He HHu/HU Ho  &     L$  :  H H HHu/HU H( z &     L$  e:  Hu
HGHP0HX Hǚ HHu/HPU H # &  U   L$  :  Hu
HCHP0HA؃u: Ht/HT Hx  &     L$  9  Hu
HGHP0A`  H;-a u>HH H
i H	x LT L d '     9  HB Hə HHu/HRT H % '  W   L$  %9  H{ H HHu/HT H  '     L$  8  Hu
HGHP0H H+ HHu/HS H5  '     L$  r8  Hu
HCHP0H@؃u: Ht/H[S H . '  `   L$  .8  Hu
HGHP0Ad  H;-ř u>H H
͙ H	ܛ LR Lv  (     7  H H- HHu/HR H7  (     L$  7  H H HHu/HoR H B (  t   L$  -7  Hu
HGHP0H H HHu/HR H  (     L$  6  Hu
HCHP0Hx>؃u: Ht/HQ H@  (     L$  6  Hu
HGHP0Ah  H;-) u>H` H
1 H	@ LYQ L , )  ^   _6  H
 H HHu/HQ H  )     L$  5  HC HJ HHu/HP HT  )     L$  5  Hu
HGHP0H H HHu/H|P H O )     L$  :5  Hu
HCHP0Hu H9Guw
H f(f.z<u:͖ Ht/H	P H  )     L$  4  Hu
HGHP0Ap  H;-q u>H H
y H	 LO L" t *     4  HR Hٔ HHu/HbO H 5 *  g   L$  54  H H HHu/HO H  *      L$  3  Hu
HGHP0H H; HHu/HN HE  *     L$  3  Hu
HCHP0H H}DHHu/HnN H A *  s   L$  ,3  Hu
HGHP03H|=D۔ Ht/HN H  *   
  L$  2  Hu
HCHP0Ex  H;- u>H H
 H	 LM L2  +     2  Hb H HHu/HrM H E +  w   L$  02  H H HHu/H+M H  +  0   L$  1  Hu
HCHP0H HK HHu/HL HU  +     L$  1  Hu
HGHP03Hˑ H9Cus
HE f(f.z<u:# Ht/H_L H 2 +  d !  L$  1  Hu
HCHP0A  H;-ǒ u>Hv H
ϒ H	ޔ LK Lx  ,   .  0  H H/ HHu/HK H9  ,   0  L$  v0  H H HHu/HqK H D ,  v 2  L$  /0  Hu
HCHP0H* H HHu/HK H  ,   5  L$  /  Hu
HGHP03H H9Cus
H f(f.z<u:i Ht/HJ H& x ,   8  L$  c/  Hu
HCHP0A  H;-
 u>H H
 H	$ L=J L  -  B E  C/  H Hu HHu/HI H  -   G  L$  .  H' H. HHu/HI H8  -   I  L$  u.  Hu
HCHP0H H׎ HHu/H`I H 3 -  e L  L$  .  Hu
HGHP0H
 mHHu/H
I H  -   O  L$  -  H H>HHu/HH HH  -   Q  L$  -  Hu
HGHP0A   HH HHu/HnH H A -  s T  L$  ,-  Hu
HCHP0Hu
HFHP03H\؅y/HH H  -   W  L$  ,  Hu
HGHP0  H;-x u>Hw H
 H	 LG L) { .   d  ,  HY H HHu/HiG H < .  n f  L$  <,  H H HHu/H"G H  .  ' h  L$  +  Hu
HGHP0H HB HHu/HF HL  .   k  L$  +  Hu
HFHP03H92؃u:4 Ht/HpF H C .  u n  L$  C+  Hu
HGHP0A  +  H;-Ռ u>H H
݌ H	 LF L  /  
   +  H H= HHu/HE HG  /     L$  *  H H HHu/HE H  R /     L$  R*  Hu
HGHP0H H HHu/H(E H  /  -   L$  )  Hu
HFHP0H
i iHHu/HD HV  /     L$  )  H H:HHu/HD H b /     L$  M)  Hu
HFHP0A   HH HHu/H6D H 	 /  ;   L$  (  Hu
HGHP03Hu
HCHP0H$؅y'HC HX  /     (  Hu
HFHP03)  H;-F u>H H
N H	] LvC L I 0  {   |(  H' H HHu'H7C H 
 0  <   =(  Hh Ho HHu/HB Hy  0     L$  '  Hu
HFHP0H H HHu/HB H" t 0     L$  _'  Hu
HCHP0H H9Fuv
H f(f.z4u2 Ht'H.B H  0  3   4'  Hu
HFHP0A  p'  H;- u>H H
 H	 LA LJ  1     &  Hb H HHu'HA H ] 1     &  H
 fHHu/HOA H " 1  T   L$  
&  H@ H7HHu/H	A H  1     L$  %  Hu
HCHP0A   HH HHu/H@ H1  1     L$  n%  Hu
HFHP03Hu
HGHP03H蜝Dy/HN@ H ! 1  S   L$  %  Hu
HCHP0E  H;- u>HU H
 H	͈ L? Lg  2     $  H H HHu/H? H( z 2     L$  e$  Hh Hׄ HHu/H`? H 3 2  e   L$  $  Hu
HCHP0HQ H HHu/H	? H  2     L$  #  Hu
HGHP03Hw*Du:q Ht/H> H.  2     L$  k#  Hu
HCHP0E   H;- u>H H
 H	. LG> L  3  L   M#  H H HHu/H> H  3  
   L$  "  H H8 HHu/H= HB  3     L$  "  Hu
HCHP0H H HHu/Hj= H = 3  o   L$  ("  Hu
HGHP03H(Du:҃ Ht/H= H  3   	  L$  !  Hu
HCHP0E$  H;-x u>Hg H
 H	 L< L) { 4     !  HY H HHu/Hi< H < 4  n   L$  '!  H* H HHu/H"< H  4  '   L$     Hu
HCHP0HC HB HHu/H; HL  4     L$     Hu
HGHP0H H1HHu/Hu; H H 4  z    L$  3   Hu
HCHP0Hu+ Ht/H!; H  4  & #  L$    Hu
HGHP0A(  H;- u>H H
 H	 L: L<  5   0    Hl H HHu/H|: H O 5   2  L$  O  H= H HHu/H5: H  5  : 4  L$    Hu
HGHP0H HU HHu/H9 H_  5   7  L$    Hu
HCHP0HޖÀu:F Ht/H9 H U 5   :  L$  U  Hu
HGHP0A,  H;- u>H+ H
 H	 L9 L  6  ! G  "  H HT~ HHu/H8 H^  6   I  L$    H H
~ HHu/H8 H i 6   K  L$  T  Hu
HGHP0H H} HHu/H?8 H  6  D N  L$    Hu
HCHP0H8} H9Guw
H f(f.z<u:~ Ht/H7 HM  6   Q  L$    Hu
HGHP0A0  H;-4~ u>H H
<~ H	K Ld7 L 7 7  i ^  j  H H| HHu/H%7 H  7  * `  L$    H HU| HHu/H6 H_  7   b  L$    Hu
HGHP0H H{ HHu/H6 H Z 7   e  L$  E  Hu
HCHP0H{ H9Guw
H} f(f.z<u:| Ht/H6 H  7   h  L$    Hu
HGHP0A8  H;-|| u>H H
| H	~ L5 L-  8   u    H] Hz HHu/Hm5 H @ 8  r w  L$  @  H. Hz HHu/H&5 H  8  + y  L$    Hu
HGHP0Hg HFz HHu/H4 HP  8   |  L$    Hu
HCHP0Hy H9Guw
HB| f(f.z<u: { Ht/H\4 H / 8  a   L$  /  Hu
HGHP0A@  H;-z u>H{ H
z H	| L3 Lu  9       H H,y HHu/H3 H6  9     L$    Hv Hx HHu/Hn3 H A 9  s   L$  ,  Hu
HGHP0H Hx HHu/H3 H  9     L$    Hu
HCHP0Hx H9Guw
Hz f(f.z<u:hy Ht/H2 H% w 9     L$  w  Hu
HGHP0AH  H;-y u>H H
y H	#{ L<2 L  :  A   B  H Htw HHu/H1 H~  :     L$    H H-w HHu/H1 H7  :     L$  t  Hu
HGHP0H Hv HHu/H_1 H 2 :  d   L$    Hu
HCHP0HXv H9Guw
Hx f(f.z<u:w Ht/H0 Hm  :     L$    Hu
HGHP0AP  H;-Tw u>H[ H
\w H	ky L0 L W ;       H5 Hu HHu/HE0 H  ;  J   L$    H Huu HHu/H/ H  ;     L$    Hu
HGHP0H Hu HHu/H/ H( z ;     L$  e  Hu
HCHP0Ht H9Guw
Hw f(f.z<u:u Ht/H4/ H  ;  9   L$    Hu
HGHP0AX  H;-u u>H˸ H
u H	w L. LM  <       H} Ht HHu/H. H ` <     L$  `  HN Hs HHu/HF. H  <  K   L$    Hu
HGHP0H' Hfs HHu/H- Hp  <     L$    Hu
HCHP0H_؃u:Zt Ht/H- H i <     L$  i  Hu
HGHP0A`    H;-s u>HR H
t H	v L+- L  =  0   1  H Hcr HHu/H, Hm  =     L$    H
m hQHHu/H, H* | =     L$  g  H2 Hr"HHu/Hc, H 6 =  h   L$  !  Hu
HCHP0A   HHYq HHu/H
, H  =     L$    Hu
HGHP03Hu
HFHP03HDy/H+ H) { =     L$  f  Hu
HCHP0E  H;-r u>H H
r H	't L@+ L  >  E   F  H Hxp HHu/H+ H  >   
  L$    H H1p HHu/H* H;  >     L$  x  Hu
HCHP0H Ho HHu/Hc* H 6 >  h   L$  !  Hu
HFHP0Hd H HHu/H
* H  >     L$    Hu
HCHP0H}p Ht'H) H:  >       Hu
HFHP03A$  H;-)p u>Hг H
1p H	@r LY) L , ?  ^ %  _  H
 Hn HHu'H) H  ?   '     H HRn HHu/H( H\  ?   )  L$  
  Hu
HFHP0H Hm HHu/H( H W ?   ,  L$  B
  Hu
HCHP0H؃u2n Ht'H+( H  ?  0 /  1
  Hu
HFHP03A   H;-n u>Hj H
n H	p L' LL  @   <    H| Hm HHu'H' H
 _ @   >    HU Hl HHu/HM' H   @  R @  L$    Hu
HFHP0H Hml HHu/H& Hw ɿ @   C  L$    Hu
HCHP0Hf؃u2am Ht'H& H p @   F    Hu
HFHP03A(  H;-
m u>H H
m H	$o L=& L  A  B S  C  H Huk HHu'H% H Ѿ A   U    HǾ H6k HHu/H% H@  A   W  L$  }
  Hu
HFHP0HX Hj HHu/Hh% H ; A  m Z  L$  &
  Hu
HCHP0H؃u2k Ht'H% H  A   ]  
  Hu
HFHP03A,  H;-k u>H H
k H	m L$ L0  B   j  	  H` Hi HHu'Hp$ H C B  u l  v	  H9 Hi HHu/H1$ H  B  6 n  L$    Hu
HFHP0H HQi HHu/H# H[  B   q  L$    Hu
HCHP0HJ؃u2Ej Ht'H# H T B   t    Hu
HFHP03A0  H;-i u>H8 H
i H	l L!# L  C  &   '  Hҿ HYh HHu'H" Hc  C       H Hh HHu/H" H$ v C     L$  a  Hu
HFHP0H Hg HHu/HL" Hͽ  C  Q   L$  
  Hu
HCHP0H
؃u2h Ht'H! Ht ƺ C       Hu
HFHP03A4  H;-ch u>HҬ H
kh H	zj L! L f D       HD Hf HHu'HT! Hռ ' D  Y   Z  H Hf HHu/H! H  D     L$    Hu
HFHP0H H5f HHu/H  H?  D     L$  |  Hu
HCHP0He H9Fuv
H1h f(f.z4u2g Ht'HK  H̻  D  P   Q  Hu
HFHP03A8  H;-f u>HP H
f H	h L Lj  E       H H!e HHu'H H+ } E       Hs Hd HHu/Hk H > E  p   L$  )  Hu
HFHP0H\ Hd HHu/H H  E     L$    Hu
HCHP0H|Àu2|e Ht'H H9  E       Hu
HFHP03A@  H;-(e u>H H
0e H	?g LX Lٹ + F  ]   ^  H	 Hc HHu'H H  F       H HQc HHu/H H[  F  ߿   L$    Hu
HFHP0H Hb HHu/H H V F     L$  A  Hu
HCHP0H|b H9Fuv
Hd f(f.z4u2c Ht'H H  F       Hu
HFHP03AH  H;-~c u>He H
c H	e L L/  G       H_ Ha HHu'Ho H B G  t   u  H8 Ha HHu/H0 H  G  5   L$     Hu
HFHP0HѶ HPa HHu/H HZ  G  ޽   L$     Hu
HCHP0HI؃u2Db Ht'H H S G        Hu
HFHP0AD     H= H    B C  L$  HtHu
HCHP0HtHu
HGHP0MtIE u
IEIP0MtIu
IFIP0HtHu
HFHP0D$(    D$    L
! Dv  H
U  AH$   Ht
HuHAP0HL$`HtHuHAP0H$@  \ H$0  HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   + H$0  D HǄ$0      HǄ$8      H$   mD H$   HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   t* H$   D HǄ$       HǄ$       H$   C L$  I[@A(sA({IA_A^A]A\_^]@SH HYHtH HC H [LL$ LD$HL$SVWATAUAVAWH   HǄ$   L   fC HtHL$0H33HHD$0Ht$HHt$PHt$XLHt$(   *C Ht
HL$`HHHD$`Ht$xH$   H$   H HH
 ] HHtH Hr3HHu'H Hd     2    HGL   MtH HAH2L@@MtH H HAHHӵ Hr^ HHu'Hc H 6   h 2  >  Hu
HGHP0HHt$ LsH8\ I9Y  H{H|$ HG  LcHI$HIHuHAP0Mt$H\ I9usH$   L$   E3EAH$   I3LHu'H
 H
! s    2    Hu
HGHP0HHt$       \ LHu'H
I H
ʱ    N 3  $  HxHHt$ ILx E3HIh5LHu'H Hz ̮    3     IE u
IEIP0LHt$(:IH#7LHu'H H% w    2     Hu	IHP0ID$L   MtHe IAH2L@@MtHJ H IAHH4 I#\ HHuFH H     3  M  I$  ID$IP0  I$uID$IP0HH$   C7HHL$`赈 H$   HtN? H$   H$   H$   H$   )? [ Ht'H[ Hܯ .   ` 3  6  Hu
HCHP0HH$   HT$`HL$0! H$0  DqAAu2Z Ht'H Hg     #3     H$8  pAAu/_Z Ht$H H n    $3  yHT$0H$    EEHH$   HIPT [ HH   H6 H 	   ; +3  3H|$ H$   Ll$(HtHu
HGHP0HtHu
HCHP0MtIE u
IEIP0L
F D Ѵ H
 PHHL$xHtO= Ht$xH$   H$   HL$`0= HL$HHt = Ht$HHt$PHt$XHL$0= HH   A_A^A]A\_^[LD$HT$HL$SVWATAUAVAWH  HǄ$@     < HtH$   H33HH$   H$  H$   H$(     < Ht
H$   HHH$   H$   H$   H$   LH\$    ?< Ht
HL$hHHHD$hH$   H$   H$      < Ht
HL$8HHHD$8H\$PH\$XH\$`LH5 HH
̰ V HHtH HQ,HHu'H HC    ǲ 3    HGL   MtH HAL2L@@MtHȮ H HALH HQW LMu'HB Hë    G 3  !  Hu
HGHP0HH$  M|$HU I9r  I|$H$  H\  It$HHILHuHAP0L~HU I9u~H$0  H$  H$8  E3EAH$0  H,HHu'H
p H
 C   u 3    Hu
HGHP0HH$        eU LHu'H
 H
     3    HxHH$  H$  H IE E3IH*.HHu'H H<     3  6  IE u
IEIP0LH\$ ?H$  I/HHu'Ha H 4   f 3    I$u	IIP0HFL   MtH" HAL2L@@MtH H HALH HT LMu'H
 HR    ֯ 3  L  Hu
HFHP0IH$   !0HHL$h蓁 H$   Ht,8 H$   H$   H$   H$   8 S Ht'H9
 H    > 3    I$uID$IP0LH$   HT$hH$    H$  j@@u2S Ht'H H@    Į 3    H$   H$H   DLH$   H$  HIQ HHL$8l H$   Ht7 H$   H$   H$   H$   6 HT$8H$   ! H
 0HHu'H Hw ɤ    3  q  H@L   MtH HAL2L@@MtH H HALH HR LMu'Hv H I   { 3    Hu
HFHP0H$   HHu'H* H    / 3    HM}HP I9Y  I}HL  M}HIIMHuHAP0IOH$  HP H9u~H|$(Ht$0E3EAHT$(I'LHu'H
 H W    4     Hu
HGHP0H  HFHP0L$        hP LHu'H

 H
     4     HxHp E3HIC)LHu'H	 HU    ٫ %4     Iu
IFIP0L$  fHI*LHu9H	 H S    4  Ht_HuYHFHP0MHuHFHP0L$  IE    IIP0   3H$  L$   Ll$ MHtHu
HGHP0MtI$uID$IP0MtIE u
IEIP0MtIu
IFIP0L
+ D  H
Ϣ FLHL$PHt43 H\$PH\$XH\$`HL$83 H$   Ht3 H$   H$   H$   HL$h2 H$   Ht2 H$   H$   H$   H$   2 H$  Ht2 H$  H$   H$(  H$   v2 IHĀ  A_A^A]A\_^[HHHUVWATAUAVAWHp  HǄ$P  HX)pL   62 3Ht
H$   HHH$   H$8  H$@  H$H  H$  L   1 Ht
H$   HHH$   H$   
 H$  ƀ   H$  H@H$  H H$  H@H$     |1 Ht
H$   HHH$   H$   R
 H$   ƀ   H$   H@H$   H H$   H@H$   HLH= HH
 L HHtH H!HHu*H Hx ʞ    :  E3?  HCL   MtHu HAL2L@@MtHZ H HALHD HL LMu'Ht H G   y :  a  Hu
HCHP0ID$L   MtHd IAH2L@@MtHI H IAHH3 IK HHu*H Hd     :  E3
  I$uID$IP0LHkHI H9E M  LcM@  H{I$HHHHuHAP0HoHhJ H9E usL$   L$   E3EAH$   HS!HHu'H$ H    ) :  	  I$uID$IP0E3M      J HHu'H
 H
N    ҥ :  	  L`E3IE Lh E3HH"HHu'H H T    :  Y	  Hu
HFHP0E3I=IH$HHu'H/ H    4 :  	  E3Hu
HE HP0IHGH>H H;%  H;&H   HJ LHu'H HA    Ť ;    Hu
HGHP0ID$H   IIHHtg   IHHtUIHȍURy'HG Hȝ    L 
;  4  I$uID$IP0M   I$uID$IP0MuHw'H Ha     ;    HOHtVH~A   H; H
lH H	J 
Hx'H H S    :  X  H;u
H_Hw HGHHpHHHu
HGHP0H$  LHHL$@fHH$   H;tmH$  HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$    HH$    HT$pLHD$@HHH\$(HD$ (D$ fD$0HuD HT$pHD$@H;uRHHtH;tC HT$pL;u5HRHL$@nJ L\$pM[E3Ll$xHD$pH HD$pH@   H|$0H\$8HtH;tC I;   (t$0HutC     teC dHC    u,HH     u    HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@C @E3HL$p) Ll$pLl$xHL$@) HHL$@oHH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$    HH$   S HT$pHHD$@HHH\$(HD$ (D$ fD$0HuA HT$pHD$@H;uOHHtH;tA HT$pH;u2HRHL$@eH L\$pM[Ll$xHD$pH HD$pH@   H|$0H\$8    HtH;tA H;   (t$0HugA     tXA gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@A =HL$p' Ll$pLl$xHL$@' L$   L$   HT$@H$  HI< HH$   p HL$XHt' Ll$XLl$`Ll$hHL$@k' H
P S!HHu'H H g    =;    H@L   MtH HAH2L@@MtH H HAHH H#C HHu'H H     ?;    Hu
HFHP0H$   HHu'H HI    ͝ B;    MHkH@ H9E O  LcMB  H{I$HHHHuHAP0HoHbA H9E uxLd$ Ht$(E3EAHT$ HVHHu'H' H    , V;     I$uID$IP0H  HFHP0|     A LHu'H
 H
C    ǜ f;     L`MHp IE3HHHHu$Hw H J   | l;  RI   IFIP0   HHHH   H# H    ( O;  HtHu
HGHP0HtHu
HCHP0E3E3MtI$uID$IP0HtHu
HFHP0MtIu
IFIP0L
 Dk  H
 7I Hu
HFHP0Hu
HE HP0H$  Ht
HuHAP0MtIuIGIP0H$   LH$   HHH\$(HD$ (D$ fD$0Hu< H$   H$   H;uaHHtH;t_< H$   L;uAHRH$   B L$   M[L$   H$   H H$   H@   Ht$0H\$8    HtH;t; I;   (t$0Hu;     t; gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$   ; :H$   I" L$   L$   H$   ," H$  HD$(H$   HL$ H H$   H$   (D$ fD$ ($   f$   LL$ L$   H$   H$   $ H$  ! L$  L$  H$   ! H$8  Ht! L$8  L$@  L$H  H$   ^! HH$  ($`  Hp  A_A^A]A\_^]HHHUVWATAUAVAWH   HǄ$   HXHLE3DxAO! Ht
HL$ HIHD$ L|$8L|$@L|$HM     HtL0IIM~M~ M~(Ǆ$          Ht
HL$PHIHD$PL|$hL|$pL|$xHGH;:    H;: t{HHX= HHu+L
 L
 A/   DA lT  r   H@L   Mu4L
F L
 A/   D nT  7   HIMHl@ MuEH<: H9GuH;w  HGHHHH,H;w  H] HHHHAHH   ILHt
HuHQR0HH$   ,0HHL$PD H$   Ht L$   L$   L$   H$    : Hu]HT$PH$   YC HHL$ 2 H$   Ht L$   L$   L$   H$    L
 L
H A0   D T  ȕ OX: HtvHL< HHy5t8 XL
 L
 A/   DF T  w HuHGHP0L
Ȏ D S H
L 71Hu
HGHP0HT$ I( MtI$uID$IP0HL$hHt L|$hL|$pL|$xHL$P HL$8HtFH|$@H;t7HYHHt^ L;L{L{HKJ H0HCH;uHL$83 L|$8L|$@L|$HHL$  IH$  H   A_A^A]A\_^]H\$ WH H8 LD$0HT$8HL$@ 9 H{HHtH H LD$0HT$8HL$@H8 HK3HtH{HuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  @SH HYhHtH. HM H [LI[IkIsWATAUAVAWH`H-}5 H5~5 E3MHLIkIsMcM'  LrIMt0Ht!HtH'  Hr(IsHj Hl$HLbLd$@I6 HIMtHt,HtOvH I5 LHD$@H   HHj  H I5 HtHHD$HHHA  H Ia5 HtHHD$PHH  H) LL$@H
 HD$(E3ILt$ y
2     Ht$PHl$HLd$@   HBH   H   H   HKH}   L
Ƨ    L
ȧ HL$0H
5 HH	LR He IDL HD$(HT$ H 7 2  L
y H
r Aa   @ a  L
݉ `,3Hr(Hj LbLLIIoL\$`I[0Ik8Is@IA_A^A]A\_LI[IkIsI{ ATAUAVHPH=2 3MHLI{IsM   LjIMt!HtH   Hz I{HrHt$@I3 HIMtHt&MH IW3 HHD$@H   HH.  H I*3 HtHHD$HHH  H҆ LL$@H HD$(E3ILl$ y
t3     H|$HHt$@   HBH   H   HKH}   L
    L
 HL$0H
\3 HH	LO Hc IDL< HD$(HT$ Hs m5 3  L
Q H
* A  ^    L
 8*3Hz HrLHIL\$PI[ Ik(Is0I{8IA^A]A\K@SH HYhHtH9) Hm H [@UVWATAUAVAWH   HǄ$  H$`  L   L E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HL$p  L$h  II    Ht
H$   HIH$   L$   L$   L$       Ht
H$   HIH$   L$   L$   L$   H$   a, 3/ LHu'H H
 \    <    I_0HCH;/ t|H;/ tsHH2 HHu'H
3 H
    8 <  %  H@L   Mu-H H} ς    <    HILdMuEH/ H9CuH;{  HCH4HHI,H;{  I4$HHIHAHHu  H$h  H$h  Ht
HuHQR0HFL   MtHۇ HAH2L@@MtH H HAHH H0 HH   E3H HCHH   Hu
HVHR03INI9N ~HE IFH,HAIFHI/ uHE u
HEHP03Hv H I   { <  E3e  HL H̓    Q <  E3;  H" H    ' <  E3  . HtHH0 HH)t8- *H HP    ԉ <  E3  Hu
HCHP0E3IL$p  IHL$`9HH$   ( H|$xHt4L$   I;t     H) H(I;uH|$xH Ll$xL$   L$   HL$` - Ht'H  H     <  G  IW8HL$`bHH$    HL$xHtNL$   I;t<HyD  HHtO L/LoLoHO; H0HGI;uHL$x$ Ll$xL$   L$   HL$` , Ht'H7 H 
   < <  ~  ALD$ H$   H$   *y 3* LHu'H Hd ~    <    HL$8HH\$@H;vK) H\$@HL$8HD$ HD$PH|$X(D$PfD$PH|$PLd$XL$h  D  H;v) HtH;|$ t( L;  Hu( E3LM;c r( IH$   b' Hu( E3LM;c r( I(H$   H$  HC$   H$  , HHu7L
 L
A } 2   ņ tP  tP  D@2H
M "Ht  ILH$h  Ht
HuHAP0HCL   MtH HAH2L@@MtHu H HAHH_ H+ HH   E3HX HXHH   Hu
HCHP03INI9N ~HE IFH,HAIFHI* u"HE u
HEHP03H\$@HL$8H H T|    <  E3sHZ H~ -|   _ <  E3LH3 H~ |   8 <  E3%H H~ {    <  E3MtIu
IFIP0HtHu
HCHP0HtHu
HFHP0HtHE u
HEHP0L
~ Do{  H
.  ME3H$p  Ht
HuHAP0H$h  HtHuHAP0H$   $ H$   HtLH$   H;t:HYHHt L+LkLkHK H0HCH;uH$    L$   L$   L$   H$   k H$   Ht3H$   H;t@ H7$ H(H;uH$   H* L$   L$   L$   H$    H\$8Ht-H|$@H;t@ H# H(H;uH\$8H Ll$8Ll$@Ll$HHL$  IH$`  H   A_A^A]A\_^]H\$ WH HM' LD$0HT$8HL$@' H{hHHtH HH LD$0HT$8HL$@H' HK3HtH{HuHAP0HK HtH{ HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  HL@HPHHUVWATAUAVAWH  HǄ$(  HX MMHLE3Dd$hH$  HL$p AL$	 Ht
HL$8HIHD$8IH\$PIHL$XLd$`ILd$0H$   H+$   HH  H;rb" HL$XH\$PH$   L9,M  HuIHT$`H+HHH+HH;sH1HHL$XH\$P  HH;v! HL$XH\$PHl$8H$   H$   HH+HuI$H;v! HtH;l$8t! H+H($   f$@  LL$0A   H$@  HL$896 H\$PLHL$XH;va! HL$XH\$PHl$8HuG! E3HL$XH\$PHD$8LII;S wHt	HE E3E3IH;Ps! HL$XH\$PE3HHt$0H$   H+$   HH;gH$  IH$   H+$   HH$   Ht=H;r  H$   H4HH$   H+$   HH;rHL$XH\$PIH+HHt[H;rQ  H\$PHH$   H+$   HH;r)  H$   L$HHD$XH\$PH+HHH;r   7 Ht
H$   HIH$   Ld$0LD$0HH$   Y IHt=    H$   H$   H+HH;r H$   HHH;rH5:	 H$  H$  IH$   j LL$pH$  LIH$P  Q L$   LIH$   5 Hl	 H$   L$   L$   H$  H$  fWD$0H$  H$       Ht
H$  HIH$  LD$0IH$  _X H$p  H$   H$  HD$0H$  H$0  H$8  H$@  H$p  H$   H$x  H$   H$  H$  H$  H$  H$   H=	 H$  H$(  H$  H$0  H$  H$8  H$  H$@  H$  o H$  H$   HO	 H$  H$x  H$  H$  H$  H$  H$  H$  H$    H$  H$0   H$  H$X  H$  H$`  H$  H$h  H$  H$p  H$   H$  H$   H$  H$  H$  H$  H$   H$  H$(  H$  H$0   H$  H$`  2 H$8  H$  H$@  H$   H$H  [ H$p  HD$ L$  L$  H$8  H$`   HI4 D$h   H$x  Ht L$x  L$  L$  H$`   H5!	 H$@  H$p  Y H$  L L$h  L$   H$x   H$h  H$`  H$(  Htw L$(  L$0  L$8  H$  R H$   H$  Ht8 L$  L$  L$  H$   H$  HtLH$  H;t:HYHHt L#LcLcHK H0HCH;uH$   L$  L$  L$  H$   H$p  H$X  Ht{ L$X  L$`  L$h  H$@  V H$   H$  Ht< L$  L$  L$  H$   H$  HtLH$  H;t:HYHHt  L#LcLcHK  H0HCH;uH$    L$  L$  L$  H$    H$  H$  Ht  L$  L$  L$  H$p  Z  H$P  H$   8 H$  H$   Ht)  L$   L$   L$   H$     HL$PHt Ld$PLd$XLd$`HL$8 H$   Ht L$   L$   L$   HL$p I IH$  HĐ  A_A^A]A\_^]HL$SVWATAUAVAWHp  HǄ$P  )$`  Hڹ   X HtH$   HE3E3IH$   H$   (  H$   ƀ   H$   H@H$   H H$   H@L$(      Ht
H$   HIH$   H$     H$   ƀ   H$   H@H$   H H$   H@L$   Lt$HILt$@IL$  MMMHKHu'Hn Hn Al   su #    AH  Ht	H[H43 HHuIHHp HHu
HGHP0Hu'H Hjn k   t #  @
  H\$HH$H  H=ms HH
r  LHtH HLMu'H Hn Tk   t #  	  IEL   MtHl IAL2L@@MtHk H IALHk I LMu'H Hm j   t #  m	  IE u
IEIP0ID$L   MtHl IAL2L@@MtHl H IALHl I~ LMu*Ho Hl Bj   ts #  I	  I$uID$IP0ML$  IuH< H9T  MeL$  M?  I}I$HILHuHAP0HwH H9uoLd$PH\$XE3EAHT$PHHHu'H
 H
,l ~i   r #    I$uID$IP0ML$         LHu'H
O H
k "i   Tr #    L`ML$  HHX E3HHkHHu'H H}k h   r $  S  Iu
IGIP0M:HI,HHu'H H.k h   q #    IE u	HIP0MHCH H;-  H;    H( LHu'HA Hj h   Fq ($    Hu
HCHP0ID$H   IILHto   ILHt]IHȍWӵy'H HIj g   p 0$  4  I$uID$IP0ML$     I$uID$IP0MluHHY Hi ,g   ^p 8$    HKHtVH~A   H H
 H	 
HxH Hzi f   o $  P  H;u
LkL{ HCL(LxIE IHu
HCHP0IHT$@H$@  MIL$  L$0  ML$8  HL$`]2HH$   H;tmH$   HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$   ! HH$   q H$   LHD$`HHH\$(HD$ (D$ fD$0HuZ H$   HD$`H;u`HHtH;t5 H$   L;u@HRHL$` L$   M[3H$   H$   H H$   H@   H\$8H|$0HtH;t I;   (t$0Hu     t eHC    u-HH     u     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$` ?3H$  H$   " H$   H$   HL$` HHL$`;HH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$    HH$    H$   LHD$`HHH\$(HD$ (D$ fD$0Hu, H$   HD$`H;uaHHtH;t H$   L;uAHRHL$` L$   M[E3L$   H$   H H$   H@   H\$8H|$0HtH;t
 I;   (t$0Hu
     tw
 fHC    u.HH     uf     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$`
 >E3H$  H$    L$   L$   HL$`    HD$0HtL$   H$   Hވ LMH$  LXAM[  E3Hd H
b HHucH H%d wa   j r$  HtHu
HCHP0M   IE u
IEIP0H$  Ht$@   E3E33HHu
HCHP0H! Hc `   &j v$  Ht$@?E3H$H  HD$HH$@  H$0  L$  L$8  
H$  Ht$@MtI$uID$IP0MtIu
IGIP0L
c Dj` i H
	V AHt$@EHL$HHt
HuHAP0HtHu
HFHP0HtHuHGHP0H$   LH$   HHH\$(HD$ (D$ fD$0Hu
 H$   H$   H;uaHHtH;tc
 H$   L;uAHRH$    L$   M[L$   H$   H H$   H@   H\$8H|$0HtH;t	 I;   (t$0Hu	     t	 bHC    u*HH     uD  HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$   
 ?H$   Y L$   L$   H$   < H$   HD$(H$   HL$ H HD$XHL$P(D$ fD$ (L$PfL$PLL$ LD$PH$   H$   C H$    L$   L$(  H$    A($`  Hp  A_A^A]A\_^[+HL$UVWATAUAVAWH   HǄ$   H$  HE3ML$  AN[ Ht
HL$PHIHD$PLt$hLt$pLt$xMII   " Ht
HL$ HIHD$ Lt$8Lt$@Lt$H3	 LHu'H H_ \   
f T>  g  HFH;"	 t|H;!	 tsHH HHu'H
 H
4_ \   e Z>    H@L   Mu-H| H^ O\   e \>    HILlMuEH H9FuH;n  HFHHHI,H;n  I] HHIHAHH  ILHt
HuHQR0HCL   MtHea HAH2L@@MtHJa H HAHH4a H	 HH   E3H_ HHH   Hu
HSHR03IL$I9L$ ~HID$H<HAID$HI	 uHu
HGHP03H H] Z   d >  LE3  H HR] Z   c >  L$  E3  H H ] rZ   c >  L$  E3  & HtPH
 HHGt 2HD H\ Z   Ic w>  L$  E3E  Hu
HFHP0E3IMIH$   HHL$  H$   Ht6L$   I;t!    Hg H(I;uH$   HZ L$   L$   L$   H$   5 + Ht'Hg H[ :Y   lb >     HT$ HL$PH HT$PH$   v5 HH$   HI"~ ȉ$  
 LH   H Hp[ X   a >  MtI$uID$IP0HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
Z DTX a H
` nMMtIE u
IEIP0MtIuIGIP0H\$8Ht)H|$@H;tH H(H;uH\$8H Lt$8Lt$@Lt$HHL$  H\$hHt)H|$pH;tHu H(H;uH\$hHk Lt$hLt$pLt$xHL$PR IH$  H   A_A^A]A\_^]HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$    H$    HT$`HKh HHL$  H\$xHt.H$   H;tfHg  H(H;uH\$xH] Ll$xL$   L$   HL$`> 3j HHu'Hk HX >V   p_ W?    H\$8H;\$@v  HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v  HtH;t$ t|  L;  Huh  MLM;c rT  IH$    Hu8  MLM;c r$  I(H$   H$    H$   HL$` HH$(  H@H} rHMHMII;}HH33 H'H=(  tE3 HE3E3 HH HtlHOH9O ~HHGHHAHGHH uHHCHP0H HW gT   ] a?  "Hp HV CT   u] _?  Hu
HGHP0HtHu
HCHP0L
V DT <] H
\  IHHuHGHP0H$    H$    H\$8Ht.Ht$@H;tD  Hg H(H;uH\$8H] Ll$8Ll$@Ll$HHL$ D HL$   I[0Ik@IA^A]A\_^H\$Ht$WH IHHMt7IR  H~)H~H E3HuH\$0Ht$8H _HHH>Hu
HSHR0H\$0Ht$8H _;H\$Ht$WH    IHHr
30  H  HNU E38  HH   H LHHCH HH H HC H H H HC(H H H HC0H H H HC8H H H HC@H} H Hs HCHHh H H^ HCPHS H HI HCXH> H H4 HC`H) H !y"Hu
HCHP03H\$0Ht$8H _Ht$8HH\$0H _HWATAUAVAWH   HǄ$   HXHhHp LA   HHL$`蟙 H|$pLHt$hLHHH3HuH9H;v)  H<    HU HHuHt)  H|$pHt$hHL$0Ll$8Lt$@IHtHtIHHH;tN)  Ht:HtIHHH;t,)  HtIHHH;t)  HHMI;t% HtHZ  HHD$0HH\$0Ht$8H|$@HHHH+HLMHM~!fHD$`f(f)HI;}HL$0LHT$0HL$`?  H$   HHuHI=II;vK(  HH HHuHt+(  H$   Ht$HHl$PHtI;t(  HtI;t'  ̄t'  H;t(H~ HtHiY  HHD$HHH\$HH|$PHHH+HLMHM~!f     HD$xf(f)HI;|LHT$HHL$x&  HD$0H$0  MH$   H$0   7 LHHiHuH/I;v"'  H<    H HHuHt&  HL$ Hl$(IE HxHtI;t&  HtI;t&  ̄t&  H;tT HtH?X  HD$ H\$ H|$(HT$ I H$    DM9\$~IH
	  D  HD$ 1fT^fWAHIcI;D$|LD$ H$   HL$05 H$   HW9 HHxHtI;t%  HtI;t%  ̄t%  I;|$t!I$S HtH>W  I$I$I|$HHH+HLMM~$f     HE f(I$f)HI;|LIH  H$    H$    HL$  H HL$0 H$    HL$x HL$` L$   I[0Ik8IsHIA_A^A]A\_HLH L@WATAUAVAWH  HǄ$  HXHp)pLE3L|$XL|$`L$P  L$   AO4 Ht
H$p  HIH$p  H$p  
  H$  ƀ   H$  H@H$  H H$  H@L$      Ht
H$  HIH$  H$  蜵  H$@  ƀ   H$@  H@H$@  H H$@  H@L$H  L$   ML$  I   B Ht
H$  HIH$  L$  L$  L$  HQ HH
P  HHtH HHHu'H HsL I u  R 0!    HGL   MtHsJ HAL2L@@MtHXJ H HALHBJ H LMu'Hr HK EI u  wR 2!    Hu
HGHP0IFL   MtHcK IAH2L@@MtHHK H IAHH2K I HHu'H HcK H u  Q 5!    Iu
IFIP0ML|$PLgH I9$\  LwLt$PMJ  H_IHHHHuHAP0LcHc I9$uvL$`  L$h  E3EAH$`  HNHHu*H
 H
J G u  $Q I!  MR  Iu
IFIP0ML|$P       HHu*HŮ HFJ G u  P W!  M
  LpML|$PIE Lh E3HHHHu*Hq HI DG u  vP ]!  M  Hu
HFHP0I=IHHHu*H HI F u  $P C!  MR  Hu
I$HP0IHCH. H;1  H; $  H LHu*H H1I F u  O !  M  Hu
HCHP0IFH   MIHHtpA   IHHt]IHAT$=y*H2 HH F u  7O !  Mz  Iu
IFIP0ML|$P   Iu
IFIP0MڒuI^HǬ HHH E u  N !  M  HKHtYH~A   He H
P H	 
HxHd HG 7E u  iN m!  M  H;u
H{Hs HCH8HpHHHu
HCHP0HHD$XH$   IL|$xHt$`H$   I0   H$   HtH HH$   IH$      H$   HtH# HHD$pIHL$pAH   E3HJ H
D HHu*HK HF D y  PM !  M~  E3E33HHu
HCHP0H HF C y  M !  M  AH   E3H[H H
D HHu*H H)F {C {  L !  M  E3E33HHu
HCHP0H^ HE 1C {  cL !  MO  H$F H$P   HHu*H HE B |  L !  MJ  H$P  H
H HHu*Hѩ HRE B }  K "  M  H@L   MtHWH HAH2L@@MtH<H H HAHH&H H] HHu*HN HD !B }  SK 
"  M  Hu
HCHP0HFH;X    H;S    HHD$hLH HHu*H٨ HZD A }  J "  M  H@L   Mu?H H D rA }  J "  M  HHMMHD$hHu
HFHP0IL|$0Mu@H H9CuL;c   HCJ4HI  L;c}zJtHI  HAHHD$0H   HtHH HHt, *Hç HDC @ }  I 2"  M
  Hu
HCHP0L$   H$P  LHL;
5 tUH; tLMIL?5 H@5 H
 H	X LA LB @   FI i"  M2  HHL$p!%HT$XH$   HH$p  H;tmH$  HL$(H$p  HT$ H	HL$HHT$@(D$ fD$ (L$@fL$@LL$ LD$@H$   H$p  賷 HH$p   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Hu H$   H;ufH$   MtL;t L;uIH$   HRH$   3 L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@tG H;\$H   (t$ Mu,     t ]HC    u%HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$   X :H$    L$   L$   H$    HT$`H$   'HH$  H;tsH$@  HL$HH$  HT$@H	HL$(HT$ (D$@f$   (L$ fL$@L$   LD$@H$  H$  e HH$   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Hu H$   H;ufH$   MtL;tc L;uIH$   HRH$    L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@t H;\$H   (t$ Mu     t ^HC    u&HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$   	 9H$   S L$   L$   H$   6   O HD$ HtL$  H$p  H=b LMAM   E3H< H
s; ~HHu*H H= :   D "  MB  E3E33H|Hu
HCHP0Hš HF= :   C "  M
  AL$X  L;%@ AǅP  3e HHu*Hf H< 9:   kC "  M  ID$H; t~H;~ tuI HHu*H H< 9   C "  MG  H@L   Mu>Hڠ H[< 9   B "  M
  II$IHL$hMHMuHH H9FuH;N  HFH<HHHL$h3H;N   H|HHHL$hHAHHD$xH  H$  H$  Ht
HuHAP0HGL   MtH> HAH2L@@MtH> H HAHHq> H HH   E3HZ= H
LH   Hu
HGHP0IL|$xHKH9K ~IHCL4HAHCIHS u"Iu
IFIP0ML|$PHL$hH. H: 8   3A "  Ma  H H: 7   	A "  M7  Hڞ H[: 7   @ "  M
  i HtHH] HHt *H H: Z7   @ "  M  Hu
HFHP0IL|$0H$   L$   LcIu*H+ H9 6   0@ "  Ms  H$   I HH H+HHgfffffffHHHH?HAL;H$       H$   H$   HH$   H$    5 Ht*Hq H8 D6   v? #  M  H$  H$    HI>[ H$   LHT$pIE DHHHu*H H|8 5    ? 3#  M.  HD$0HL$pyHHu,H H;8 5   > ?#  Ld$0  HL$0HA8HHI8H9 uHAP0HD$0HX8H\$pHtHh H MtI8i I MtIu
IGIP0Dd$PA% HHu,H H7 4   > a#  Ld$0?      HHu,Hϛ HP7 4   = c#  Ld$0   HXLd$0I$L`   E3H$   HL$XH$   HD$`MH$   H|$xLt$PHt$0  E3H$   HD$XH$   HD$`MIH|$xLt$PHt$0w  H$   LH$   HtHu
HAP0LIIAL   MtH7 IAH2L@@MtH7 H IAHH7 I HHu*H H6 i3 ~  < B"  M   ML|$PH| H9GuLwLt$PMtqHwIHHHHuHAP0IH蘻HHu'H H5 2 ~  < O"  MOIu
IFIP0ML|$PlH藼HHu\Hș HI5 2 ~  ; R"  MHtHu
HCHP0H   H   HGHP0   Hu
HGHP0IL|$xHu
HFHP0IL|$0E3H$   HT$XH$   HT$`MLt$PI(E3H$   HT$XH$   HT$`MLt$PIMtIu
IFIP0HtHu
HFHP0L
C4 D1 : H
& IHL$XHt
HuHAP0HL$`Ht
HuHAP0H$P  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0MtI$uID$IP0H$  HtHuHAP0H$  Ht6H$  H;t!    Hw H(H;uH$  Hj L$  L$  L$  H$  E H$@  LH$  LHH\$HHD$@(D$@fD$ Hu H$@  H$  H;uaHMtL;t H$@  L;uAHRH$  I L$@  M[L$H  H$@  H H$@  H@   H\$(H|$ HtI;t_ I;   (t$ HuF     t7 fHC    u.HH     uf     HH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$  i 5H$@   L$@  L$H  H$   H$  HD$HH$p  HL$@H H$h  H$`  (D$@f$   ($`  fL$@L$   LD$@H$  H$p  莦 H$   L$  L$  H$p    HL$  I[0Is8A(sIA_A^A]A\_LI[IkIsWATAUAVAWH`L% 3MHLMcI{HI{Ml  LrIMt0Ht!HtHb  Lb(McHj Hl$HHzH|$@I HIMtHt,HtFmHM4 IL HHD$@H  HH. I( HHD$HHtHH  HH- I HtLHD$PHH\  HW! LL$@HK, HD$(E3ILt$ ~y
      Ld$PHl$HH|$@  H
m H
 HD$0   H	HT$(   L
qL L  HL HD$ x       HBH   H   HKH}   L
 L    L
"L HL$0H
 L} H	HH
 IDLn  HT$(HK HD$     L
Ӓ H
\  Ao  + o  4 L
7. 3Lb(Hj HzMLHIL\$`I[0Ik8Is@IA_A^A]A\_H HH%O H\$WH H HH! tHм HH\$0H _H HH% H\$WH H HH tHp HH\$0H _@SH Hk HHHA2 HH [H%s H\$WH H7 HHHA HC tH HH\$0H _HL$WH0HD$ H\$HHH Ht HHOH HH\$HH0_H\$WH H? HHHA\ H tHR HH\$0H _HL$WH0HD$ H\$HHH4 H HHSHO HH\$HH0_HL$WH0HD$ H\$HHH H HHSHO HH\$HH0_́aI    H́aI   H@SH H HHt? HH [H H@SH H HHt HH [H(Ht
H   H(HL$HT$LD$LL$ H HH% H H\$WH H HHi tHP HH\$0H _H H@SH H HHt HH [@SH H	 L LHH [H HHHH HL$ A    L H? HL$ L\$ 蛸 @SH H3 HHHAR HH [H% HL$WH0HD$ H\$HHHD H< HHSHO HS HHH\$HH0_HfWE3I   H$I@HHH+LYHLRL    fD  AJBI I HAYKAYBXf(AJXABAYKAYCXXuH$M;s"H+JM+HIYHXuf(HH)f(
 f( f( f( f f(fYfYfYfX
{ fX fYfYfXf(
 fXf( fYfXfYf( fXfYf(
 fXfYf( fXfYf( fXfYf(
 fXfYfYfXfXf)$^D$HH)f(
p f(x f( f( f f(fYfYfYfX
[ fXc fYfYfXf(
o fXf(s fYfXfYf(o fXfYf(
o fXfYf( fXfYf( fXfYf(
 fXfYfYfXfXf)$^D$HHL$WH0HD$ H\$HHH4 H, HHSHO H+ HHH\$HH0_AA ̋Q<A4A@    QHTQDHH% H H3HAHAHAH\$WH HHIHHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHIHHPuHOHHPuH\$0H _ðH\$0H _HQ HHL$SH0HD$ HH H@ HH0[HL$WH0HD$ H\$HHHt Hl HHSHO; H HHH\$HH0_̋   tt
tt3Ë   @SH H L LHH [HL$WH0HD$ H\$HHH HT HHSHO{ HS HHH\$HH0_@SH H+ HHHA2 L; HLH [H%i @SH H HHHA HH [H% @SH H HHHA L HLH [H% @SH H HHHA HH [H%S @SH H HHHAR HH [H% Hy8rHA HA H   HD$ H HL$( HL$P" H HD$PHT$(HL$h HU HD$PH8 HL$P۰ H   HD$ H HL$(n HL$P H HD$PHT$(HL$hm H HD$PH7 HL$Pk H(HHHcHHLHHt
H H(LBI HBI     uHPHBI@HA0H;PuL@ILBHBH;uL ILBL@ILBLI@HI@    uHPHBI@HA0H;Pu
L@IPLBHBH;Pu
L@IPLBL IPLB@SH H9 Hu+ HK    tHAHC    tH [H% H    u/HH    u     HHI    tHCH [HI    uHH9CuHKHI    tHC    uHKH [@SH LHHuHRAHH [HHRHcHHAHH [HHHD$0D$    L
l L= 3P 2HHHHHD$0D$    L
 L 3 2HHHHHD$0D$    L
 L 3Э 2HHHHHD$0D$    L
 L} 3萭 2HHHHHD$0D$    L
 L= 3P 2HHHHHD$0D$    L
 L 3 2HHHHHD$0D$    L
 L 3Ь 2HHHHHD$0D$    L
| L} 3萬 2HHHHHD$0D$    L
 L= 3P 2HHHHHD$0D$    L
L L 3 2HHHHHD$0D$    L
l L 3Ы 2HHHHHD$0D$    L
 L} 3萫 2HHHHHD$0D$    L
d L= 3P 2HHH\$Ht$WH HQ 3HH+Q   HHt'H;r HFHV HH+H|H;rH\$0Ht$8H _H HH@WHPHD$ H\$`IHH HL$(D HHT$(HHL$(J LHASHHL$( HHT$(HHL$( H HL$( HHT$(HHL$( HU HL$( HHT$(HHL$( LHH\$`HP_IcH\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$Ht$WH HHHH;tp H(H;tdHH uHH(H;t2f     HHԿ uH(HHȿ H(H;uHG(H\$0Ht$8H _H\$0HHt$8H _Hl$Ht$ WAUAVH LI HIgfffffffL+IIMHIHHH?HtHu HVH HN Iƿ   H+NHHHH?HH;skH\$@Ld$HDg'H;rU HFIHI HH HN IH+NHI(HHHH?HH;rLd$HH\$@H HHl$PHt$XH A^A]_H%o Hl$Ht$H|$ ATH HA MHH+AHHHtHu HFH HF    H+FHH;sGH\$0H;r_ H^IHϽ H HF H+FHHH;rH\$0H HHl$8Ht$@H|$HH A\H% H\$LLLM+HgfffffffHIHLI?IL;~HIHI+HHHH?HL+H\$KHL+I@SH AHD$@    A)   HZIcd @ HH H4 HH [H4 H HH [H H HH [Hz H HH [H Hм HH [H H HH [HO H HH [H H HH [H Hl HH [  \ ٥ u     $  ihQp% H8  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(ihQp% H  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(H   " A))t$p)|$`D)D$PE f(f(D)L$@D)T$0D)\$ YD	f(AXYf(YfA(YDY Yu YD^\fA(YS ^fA(X^YD\YfA(AY\ 
 H$   D D fA(0\f(H$   ^AXf(f(Y^fWA^fWf(YAXA^YAXYAYAXAYYAXYf/vf(f(f/v8f/v2f(YA^AXYAYAXYf/vf(f(f/v6f/v0f(YA^AXYAYAXYf/vf(f((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   H\$WH HHʹ L; LHCHGHC H\$0HG HH _@WH0HA HH+AHHu
fWH0_H\$@)t$ Hu HGHO    H+H0H;s(H;ro HGHO HH+HXtH;rH\$@f((t$ H0_HA HHA@HHAXD H3HHHWH@  HD$ HXHH@       DBHL$@    HL$( HL$PHcQHLPHPHL$P׶ HHL$@Ѷ Ǆ$`     HL$@ö HH$X  H@  _3f(LTDIDA     Apx f/sffA;ufDA0x f/sffA;ufDAAHkHfAB@w HL$WH0HD$ H\$HHH H HHSHO H˽ HHH\$HH0_@SH HH	f HK\ HKH [H%L A# f/ryf(f(YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^A f/   f(f(YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^Aӽ f/   f(f(YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^LL$ LD$HT$SVWH`H$   L$   HHME3HHHHHT$8Hg  H$   Ld$XLl$PKRLt$HL|$@IHJMIMHIMK,HMH$L|$0Ll$Hl$HL$E3I4  IKLHHL$ HHIM+HL$(JLH+H+MM+MELl$ IMHUH+L+Hl$(IEHHMLfD  KIHHpHBH HxI@I HAHEH M;HAIDHAHBHAHDHAHDHAKDHAHBHAI@HAKDHAHD/HAHBHAI@HAHEHAWL$   H$   Hl$Ll$L|$0H$HL$M;}_MIHML+H+H+M+JTOJL I
H HIHBHAHBHDHBHDHBuH$HL$IMIMHHl$Ll$H$HL$2H$   HT$8L$   L$   L|$@Lt$HLl$PLd$XH$   H;   HJ4    IH+H$   IfE3I|]MSJLHSIIN    M     HBH H IHAHBHAHBHAHBHAuH$   M;}JIIM;JD|HHH$   lH`_^[HL$WH0HD$ H\$HHH$ H HHSHO Hc HHH\$HH0_@SH HHt*H|$0CuHHPCu	HHPH|$0H [@SH HA HHA`    H+AHHuH HCHHKpHCPH+CHHHu& HCHHHKpHKhH [̋* f()f(
> ufo%B f%  fo% f]-/ f_-7 fYfX
; fffT
6 f\f(f(fY2 fY
: f\f\f(fYf(f(fY* fY2 fX: fXB fYfYfXҨ fX: fYfYfX: ff\ffrf^fpcfY fX fYf_f(H\$WH0HA 3)t$ H+AfWHHHt,H;r HOHHDXpHG H+HH;rH\$@f((t$ H0_@SH H HHt HH [H(HQHI H HH(H% @SH HHQHI HH} H~ HH [H%w HL$WH0HD$ H\$HHHɫ Hy Ht
H轓 HHH\$HH0_H\$WH Hg HHHAl Lu HL tHX HH\$0H _H\$WH H HHHA H tH HH\$0H _H\$WH H HHHA L HL tH訒 HH\$0H _H\$WH H HHHA\ H3 tHR HH\$0H _H\$WH H HHHA HS tH HH\$0H _@SH HH	HtHP tH    H [@SH H9 Hu HK    tH [H%r HA    u.H    uf     HH	    tHCH [HI    uHAH9CuHKHI    tHKH [HL$SH0HD$ H u
H HHHcHHLHHt
Hh H0[HHLHuKHא HH3HIH(sE3HT$XHL$ LD$X۩ L H} HL$ L\$ 肐 HHLHuJ    g HH3HIHsE3HT$XHL$ LD$Xk L H
 HL$ L\$  HHLHuJ     HH3HIHsE3HT$XHL$ LD$X L H HL$ L\$ 袏 HHLHuK@H臏 HH3HIH0sE3HT$XHL$ LD$X L4 H- HL$ L\$ 2 HL$VWATAUAVH@HD$ H\$xDH3ۉ$   LHL$(HLc@ILHHtHV HHcH|1 uHL1PHt HHcH|1 D$0   H|1(H3HϋD1%  @t=A      H~0HHcHT1XHL1H AD܉$   HA   HHcHAHL1H AD܉$   u/H~*HHcHT1XHL1H AD܉$   HHt$p$   Ll$(HHcHHD1(    HHcHHE3r s u
In IE HcHJL)HHtH HHH\$xH@A^A]A\_^HL$VWATAUAVH@HD$ H\$xLH3ۉ$   3HHHLiHHcHH|1(H~
I;~I+3LHt$(HL1HHtH_ HHcH|1 uHL1PHt HHcH|1 D$0u
      D1%  @t6H~-HHcHT1XHL1H5 u$   H΅u]HHcHMIHL1H I;t   $   2H~-HHcHT1XHL1HԢ u$   HHHcHHD1(    Ht$p$   Ld$(HHcHHE3  u
I I$HcHJL!HHtH
 HHH\$xH@A^A]A\_^HWH  HD$ HXHhHpIIHHٺ   DBHΡ HH$   HH HHHHq HHHȋU  HH$  }HT$hH$   j HHL$( H HD$(HHL$@y H HD$(H% HL$(w HD@WHP  HD$0HhHpIHHD;$        DBHL$`Š H HL$`HHHHƿ HH$   HH HT$8HL$`y HD$@H|$XHCD$@HD$ L
S L$p  HH(L$P  IkIsI_HD@WHP  HD$0HhHpIHHD;$        DBHL$`՟ H HL$`HHHH־ Hȋ$   HH HT$8HL$` HD$@H|$XHCD$@HD$ L
d L$p  HH9L$P  IkIsI_H\$WH HH I$HHHn H
HH H HH\$0H _H% ATAUAVAWH(HQ I*E3H+QIE3LHHHH?H   H\$PHl$XHt$`H|$ 3L;r I~3۽   HL> H+L>HHt)H;ru HD>HL> HH+HlH;rIN III+NDH0HHHH?HL;rH|$ Ht$`Hl$XH\$PAH(A_A^A]A\H(Hu3H(HH;v<H\$ H    H՟ HuHtH\$ H(H\$Hl$Ht$WH HAIIHHHAH;t4H	q HtH\HsH{HH    HsH{LALIH\$0Hl$8Ht$@H _H(y t	H	 H(HH B(H\$Hl$Ht$ LD$WATAUAVAWH LT$xL$   Ht$pLIIHE3E3ۃH<HHH|$H  H$   MMlL+H    MxL+HL$L,$ILd$fff     L3H  H\$`IDkIkHL$LH|HNKTHIMHHHH    Lfff     IBHHpIBHxIHBIBMHBIEHBIEHBIE HBIEMHBID$HBID$HBI$HBID$MHBHGHBHGHBHHBHGIHHB_L,$H|$Ld$LD$`H;}RHKLL    HIITLL+OHBH HAHBHAHHAHBIIHAuLD$`HL$I IMI L;L,$oLT$xL$   I;   L$   L+M,LT$xD  ME3H   H~LHDm HIHHKLHL$    MMM\ I\ MfIH LHAHHHAI LHAILHHAuLT$xL$   L;}.IHL    HI+IL HIIHKDuIIH+I+LILT$xH\$PHl$XHt$hH A_A^A]A\_LL$ LD$SUVWATAULl$hH|$XLILL$`E3IIHH,HHH   HD$pLL$HILl$PH+L]H+IH4    HI    LH~<KN    IHfD  fH If)@fAIHf)@uLI IuH\$PHt$HLL$`Ll$hIH+H|UL\$pKZH~4L    HLfHHIDHBIIIDuLL$`IH+I+HLAL\$pI;  Lt$8H+L|$@L<L4fD  ME3H   HL] HD] LHKTILHHwHMIHL,    M IH MHBHIHBHIHBIMHHBuH\$PL\$pHt$HLL$`L;}0IHL    HHI+HHIIHKDuHD$hHIH+II+LI;L|$@Lt$8A]A\_^][H\$Hl$Ht$H|$ ATHPH$   HH$   )t$@)|$0f(f(Y=Y H|$(IHf(LH\$ Pf(M$LHIH|$(H\$ ASM$Lf(HIH|$(H\$ ASH\$`(t$@(|$0Hl$hHt$pH|$xHPA\@SH LHH~qLHIIgfffffffMQIIH+HHHH?HL;|M+IIHHH?HL+KHHHKI;IuMHC    H [y:IM~%HQHuHHPH	HCHH [yIIBHH [HWH  HD$ HXHhHpIIHHٺ   DBH HH$   HH HHHH HHHȋU  HH$  HT$hH$    HHL$( Hܙ HD$(HHL$@ Hٙ HD$(H HL$(} HWH  HD$ HXHhHpIIHHٺ   DBH HH$   HH HHHH HHHHU  HH$  HT$hH$    HHL$( Hۘ HD$(HHL$@ H HD$(HT HL$(| H\$Hl$Ht$WH LHHgfffffffL+IHIHHH?HHI,H;tH+fHH H(H;uH\$0Ht$@HHl$8H _H\$WH HH IHHH HHH. H/ HH\$0H _H%# H\$WH HH! ITHHIHf! H:H Hϒ HH\$0H _H%Ò H\$WH HH\* IHHH>* HHe Hn HH\$0H _H%b H\$WH HH* IHHH) HzH H HH\$0H _H% H\$WH HH) I4HH)H) HH H HH\$0H _H% H\$WH HHT) IHHH6) HHE HN HH\$0H _H%B H\$WH HH( ItHHiH( HZH H HH\$0H _H% H\$WH HH( IHH	H( HH H HH\$0H _H% H\$WH HHT( IHHH6( HHg H0 HH\$0H _H%$ Hh)t$P  )|$@  L
 L$ D$     D)D$0D  3x LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
/ Lh 3D$     w HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
 L D$     D)D$0D  3@w LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
o L( 3D$     v HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
+ L D$     D)D$0D  3 v LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     Su HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
{ Ld D$     D)D$0D  3t LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     t HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
˷ L$ D$     D)D$0D  3s LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
_ Lh 3D$     r HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
 L D$     D)D$0D  3@r LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L( 3D$     q HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_HWH  HD$ HXHhHpIIHHٺ   DBH HH$   HH_ HHHHA tHHiHM  HH$  KHT$hH$   8 HHL$( Hz HD$(HHL$@G Hw HD$(H[
 HL$(Ep LL$ LD$SUVWATHHl$hLd$`HHE3IHI؃LIIM~`MKIIfM~?JL    HIf     fH If)@fAIHf)@uH IuH\$PHI+H|CM~:L    JIfffff     HIJDHAIHJDuIL;
  Ll$@Lt$I;L<$N4L<fff     E3I   I{I{LHIl$JTHIHHMIL,    HM    IH MHBHIHBHIHBHIHHBuH|$XH\$PHl$hM;}0IIL    HII+HHIIHJDuIIIL;&L<$Lt$Ll$@HA\_^][H\$Hl$ LD$VWATAUAVHLT$hLl$`LIIE3HE3IH<HHH|$H  MdL|$@MxL$$     3I   IDsIsLHKTIH|Hl IMHMHHHH    LfIBHHpIBHxIHBIBMHBID$HBID$HBI$HBID$MHBHEHBHEHBHE HBHEIHBHGHBHGHBHHBHGIHHB_L$$H|$Hl$PI;}RHMKLL    HIL+OHTHBH HAHBHAHHAHBIIHAuI II L;L$$LT$hL|$@I;   L+Hl LT$hE3I|~I}LHvHIHHKLHL$    LLL\ H\ Mff     IH LHAHHHAI LHAILHHAuLT$hM;}.IIL    HI+HL HIIHKDuHILT$h3H\$HHl$XHA^A]A\_^HWH`  HD$0HXHhHpIIHH3EEE;|HHrp   DBHL$` H HL$pvHL$pa HT$8HL$`Ɂ HD$@H|$XHCD$@HD$ L
 LHHL$`  I[IkIs I_HWH`  HD$0HXHhHpIIHH3fAnA@ f/rHHrp   DBHL$` Hۡ HL$pHL$p HT$8HL$` HD$@H|$XHCD$@HD$ L
6 LHH`L$`  I[IkIs I_HWH  HD$ HXHhHpIIHHٺ   DBH HH$   HH HHHH HHHHU l HH$  HT$hH$   y HHL$(ˁ H HD$(HHL$@ HЄ HD$(H4
 HL$(h HWH  HD$ HXHhHpIIHHٺ   DBH~ HH$   HH HHHH HHHHHH$  HT$hH$   {~ HHL$(̀ H HD$(HHL$@ H HD$(H
 HL$(g Ly LLMu    A   HT LU HD HHL$HHI;HD$IMLMM~I3II3I;}HIHSH  HD$p)p)xIf(f(H HL$H~    DBH$   } HHPH HL$ S~ HT$ H$   | HL$ S~ HT$HH$   } Hf(} HHA HT$ H$   Q} LHHAHL$ } H1 HL$ } HT$ H$   b| HL$ } A HT$`HL$ K| HH$   } Hf(| HH UHL$ y} HT$ H$   | LHHAHL$ M} H HL$ } HT$ H$   { HL$ } A HT$`HL$ { XHH$   b| Hf(M| HHÝ HL$ | HT$ H$   { LHHAHL$ | LHASH$   { HL$Hy| ($  ($  HĠ  [H%{ MLAuGHA L HAXLcHA@IcKLILM+M;IB KL IB@D+HIBXED 3HHBBHHD$0MLt3HHBBHHHA H$HHA@HIBXLc L+LH+EtwAtBA   M   M;   IB HHIB@I+IHIBXD+DD XJHxbI;]HIB HIB@D+HIBXDD )Mx7M;2IB JHIB@D+HIBXDD IJ@IB H	H+H
HH$3HBBHHD$HD$HH#H H;w	HH      H;s   H¸    HH   )p)xf( f(D)@D)Pf/fEWfD(fA(vf(a fW c  fA.zR  fA.zE  D)$   D)\$`D fA/D)d$PD)l$@D)t$0D)|$   D
3 D fA/r6fff     fA(A\Xf(` fA/Xsf(A\    g 
W %G  D- D
 D D% J 
J %J DI D
H DG D%F <D%; D* D
 D % 
     h D5W D=F  } % DT l  D5C [  D=2 J  fE(= D=
 D5 D- f(AXYf(YAYAXYXYXf(AYAXYXf(Y
 YX
 Xf(YY X
 X YAXYYAXYXAX^YY5ܙ XV  D
 fD/vf(^ fA(fD(\AX f/  _    o 
_ 5O 6 D5 D$ D% D- Z 
Z 5Z DY DX D%W D-V <D-K D%: D) D 5 
  uxt D5c D=R q  1 D
p   D5_ w  D=N f D=; D5* D
 fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
 AYX
 Xf(YY AXX YAXYAXAYX^YY%
 X  F uq% ږ 5ʖ ! D D D% %  5 D D D% 3D% D D 5  %  uz
 D- D5  w D=֕ 
6 
 
. 
 D
 
 D- D5 D= $D= D5 D- D
 DYfW- f(f(YYf(AYAXYXf(AYXYYf(Y
 Xf(Yp X
` XYAXAXYYAXAXYX^AYDY AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIHT$WH0HD$ H\$@HHH       Z Ht@   @   H
/ HHx3HHH\$@H0_HT$WH0HD$ H\$@HHH       Z Ht@   @   H
 HHx3HHH\$@H0_HILH+HH(  HH$HHHHHL    IL
f/v
H;t	A
f/vL;t	A

f/v
H;t	A	IKI+ f/vL;t	A	Af/vI;t	A	A	 f/vL;t	AIIH+H$I+f/v
H;t 	A f/vL;t	A f/v
H;t 	A	f/vL;t	A
Af/vI;t	 A	A	f/vfL;taA
H
f/v
H;t	Af/vL;t	A 

f/v
H;t	HHVWATHP  HD$0HXHhIIHL   DBHL$`n HHL$`HH HHVm HHy HT$8HL$`m HE H+EHH;ro HE$  HT$@H|$XHCT$@H$  HD$ L$  L$  IL LLMu    A   H L H HHL$  HH	I;HD$IMLMM~I3II3I;}HIH(HIHt
H   H(H\$UVWH0I@ 3II+@HHHHtNLd$PI      H;rn HOD$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]H> LLHD$(H HHHD$ @SH HKs HHt?U HH [H8HD$  H;tMtHI IHIH8H\$H|$ 3HLH9yLH|$   MQMM;},HI	MMIHSIIHJMQM;|IAHT$HL$I;HD$HMHLI|bMZff     IIIIHH<IIIIHH|IIIIHH|IIIIHHI;H||I;}IIIIHHI;H<|IM;ALD$H\$H|$ LL$ LD$HT$HL$SUVWATAUAVAWH  H$   HLHHT$t
LHT$`+HHD$HT$(HHكH;HL$(HMLLT$`LM+IML\$PICH$   IHH3H+LIAu33ILcHl$L$   L$  IՃtH&IHD$LL$(HHكH;HL$(IMHE3Ld$0Ld$ EL$HujHuefff     HHH3H+L;tIIILd$ |IuE3L$   Ld$0.M;H$   HL$ HML Ld$0E3E3LT$`L\$P$@  fW   L;ADL;DDHcII+IcHHHM<M;L$    L$  L$8  L$  )$  )$  D)$  H$0  IID)$p  D)$`  D)$P  HH$   ID)$@  D)$0  D)$   HH$   ID)$  IHIH$   H$0  IL    IHK<1HH|$pH$   HIHIHHT$(IT$HIIL$0  HML$   N&H$0  N$1ILd$ MIH$8  O,0HJ42L$   H$   IH$   HLM+LL+HI+HD$XH+IH+D$0L4$LL$HHHL$hHHHD$    D$D$f(E3IfD(fD(fD((c fD(fD(fD(fD(.  MLML$   ML+L+L+MLL$LL$XHVHl$LIML$   LHGH$   M+LL$ML\$M+L$   LL$hLL$   ML$   L$   L+LL$xLL$HLH$   LL$@MJHt$@IIN    LT$8LT$xff     A08H I H H If(f(Y@YIXDXf(YBAYPf(DXDXBT!BYL0DXf(f(Y@YIXf(DXBYD8Y\(DXDXB\*f(f(Y@YIXf(DXBYDYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   DT$DL$H|$pH$  H$   Ld$ L$   L|$8L4$M;}uILMILH+L+L+JI+AHHf(f(Y@YLXf(DXAYD AYTDXDXuDT$DL$M;$  H$   HE  H  H   M;  L4$III+LMHLH+HL+L+HJfB(0f HHfYfDXfDfYfDXfBD fYfDXfADfYfDXu)  L;$   fB(DfC(LMfG(|f)$   f)$   U  JHHHD$8KDLfD(fD(Hl$8HD$@H$   L\$@I+H+HH+L+HNLO|HM4f     fA(qfA(fA(oI I fA((fB(
EI H HfYfYDf(fAXfDYfAYfAYfF(T	fE(KfD(fAXfAXfDXf(EfA(fE(fYAfD(fA(CfAXfYfYfD(fDXfDXfD(fDX4DL$DT$$@  L\$PH$  M;  L<$III+LMHLH+HL+L+HJfff     fB(8f( HHfYfDXfDfYfDXfBD fYfDXfBDfYfDXu  M;  L4$III+LMHLH+HL+L+HJff     fB(0f( HHfYfDXfDfYfDXfB(D fYfDXfBDfYfDXu~M;}yL4$III+LMHLH+HL+L+HJאfB(0f( HHfYfDXf(DfYfDXfB(D fYfDXfB(DfYfDXufA(fADXfA(AXfADXfA(EXfADXfA(EXfADXEXL;M  HI+H  L$MLLL+L+L$   MOL+JTKLLD$8LD$XJDH$   LLD$xLM+LD$@MM+L$   LD$hLL$   MLd$xL$   L+L$   LD$HLH\$8LD$LHl$@Ht$M+IIIOL$   LT$L$   B8H I H H If(f(Y@YIXDXf(YBAYQf(DXDXATBYL0DXf(f(Y@YIXf(DXBYD8Y\DXDXA\f(f(Y@YIXf(DXYD)BYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   H|$pH$  H$   Ld$ L$   L|$L;}kL4$ILMHLH+L+L+I+JB0HHf(f(Y@YLXf(DXBYD BYTDXDXuH$   H$   L$   fWYDYX9L$   HT$(DYDY9EXHD$XHD$hHD$HEEXEDXL4$LH$   DHLHLH$   L4$HHLLHl$H|$pHT$(L$   H$   Ld$ H$   L$   L$   VL$   L$  L$  D($  D($   D($0  D($@  D($P  D($`  D($p  D($  ($  ($  HD$0M;  H$8  H$  H$  (%W H    H$  IHH$0  L$IHMD LLIIIM+L$  fffff     3If(f(|jIRHKI@HI4HH<    HH H HYIY@Xf(HX@YIYAXXuI;}&IIIH+HHY@XuM;   AAu@M;}|IKII+HHHff     f(HHfYAfXuAM;}<IKII+HHHff     ff(HHfYfXuf(fXXL;I   HI+H|wHJLKDI+I4HHHI<ff     H0H H HYIY@Xf(HX@YIYAXXuH;}&HIIH+HHY@XuH$  fWYMH    LAX$A$MIHD$0HtfWL$  E3L3HD$0Hĸ  A_A^A]A\_^][LD$HT$HL$UVWATAUAVAWH`  Hl$ H  )0  )   HIMLHD)  D)   D)   D)   D)   D)   D)   H;v轈L  3IHDH  L3HIDH   H    H=   E Ity3H|QLON    IJIIJ    HIH HAHIHAHIHAHIIHAuH;}J    HHHH;ID|L  D  fEWHOMN    HHM IHU8HE8    HE HNIIҋI+ѸH#I+IHHU0   H   IO49HI+M]H   HMHH   IMI+MH]xHE(M+II+L}MHEM+   I+LUpL]`H   HL   I+L}8HU H   HCLu@LeH;  f(=R fE(fE(HMKfD(H+fA(EYGY;H  AEEfDAfDAu&IH  LEXHHكH;HMXICHLHfA(I+fA(LEPHI@H   IYBYL0lAXCAXACf(AYXACY,;LAXI;#  IH+H  HM8H}I@LE HEhH   I\ IJL]0NL LE0HE(IHH  ILu(H+ILEH}XH  LeXfD  IAAAII H AYAYaXH CXLCLKf(YIAYAXf(AYXADAYXAXL9AL9CD1YAYDXAQXf(f(AYAYXBXL!BL!f(BYTBY\XAQXAYf(AYXAXLALYSYcXXL;}hH  LEPL]`Lu@LeM;scIIO,MH+JI+HHAYf(AYXBXLBLBD YYDXXuOL L;s{LeHII+I+HHII+HMHff     fAffIHHf(fYfAYfYfAYfAXYfDXfXfXfA)YuH;  H]HH+H  L]N<HGN$+KMH]PL  H  H}PHEhILLuMLHDL+O<+ffff     YP!HH H I f(f(AYAYXBD AYAXLALAYQAYYXPXYf(AYXBXL BL DYBYD XPXf(f(AYAYXBXL9BL9f(YT9Yd9XPXAYf(AYXCXLCLAYQAYYXXH;UhH  L]`Lu@H]H;sdMHN+IL+HH+BHHAYf(AYXBXL BL DYBYDXXuL   L   H]xf(fLE(LELE0XfA(XfADXAYAX{DXLeHMHL}8EYEXA{MLEpHEIIMIH]xLEpL]`L,    I   w<H   HHH;w
HHHA H+LT$ IIIR LHM8H  H  L}H   HMML HHHL+HLL+H;   HE fA(fA(IHHMHHBY\f(AYDIK8AXAfH;},	HHf(YXDDAYLXHMHAYLLIAXQAQa}  t
H   P H  (0  (   D(  D(   D(   D(   D(   D(   D(   H@  A_A^A]A\_^]Hl$ WH H\$03Ht$8IHHtHJHͲ(_HF HH+FHHtbLd$@LgfHtHHͲ,IE*HF H+FHH;rP HVIHM HF HH+FHH;rLd$@Ht$8H\$0HtHo)HHl$HH _§@SH Hr HHHIHtHP tHC    H [@SH  HD$ hO HH         DBH$   eM HMr H$   HHL HHM M HT$hH$   9M HHL$(O HR HD$(HHL$@M H`
 HL$(5 HĐ  [HWH  HD$ HXHhHpIAHٺ   DBH/L HH$   .HHr HHq HȋK HHq HHq HȺ   K HHwq ʧHȋK HH货HH$  褧HT$hH$   K HHL$(M HP HD$(HHL$@L HQ HD$(H
 HL$(4 E  HWH  HD$ HXHpAHH   DBHTK Hq H$   HHmq ئHHͦHH3q 辦HH賦HHq 褦HȋJ HT$(H$   J HT$0H|$HHCT$0H$   vK HL$PL HO HD$PH$   HL$hrK HO HD$PH
 HL$Pp3 HWH  HD$pHXHpH   LAHKr HL$HJ L(r HHL$ J H$  LHHAHL$ J HL$HJ Hq HL$ J HHT$ HHL$ J LHASi  C$  ;>  H&q HL$ ;J H$  HHT$ HHL$ 9J Hp HL$ J HHT$ HHL$ 
J w0fH*f(Yep H,ȉO4Y
Mp H,G8++w<Hp HL$ I HHT$ HHL$ I    DBH$   H Ho H$   NHȋW4H HT$HH$   H LHHAHL$HFI Hj HL$ I HT$ H$   G HL$ I Ho H$   УHȋW<G HT$HH$   !H LHHAHL$HH Hj HL$ H HT$ H$   2G HL$ H Hgn H$   RHȋW8G HT$HH$   G LHHAHL$HJH LHASH$   yG w0DG4DO8O<HHL$  I[IsI_@SH0HHQHI)t$ f(PG HHDG H%o H蕢Hf( G H)G H(t$ H0[H%G H\$WH HHQHIAF HHF Hn H'HF HF HH\$0H _H%F H\$WH HHQHIIF HHvF HWn HǡHH[F H\F HH\$0H _H%PF E   H\$Hl$Ht$WH HHHQHIIcI	F HHE H"d HNHOE    H;},fD  HOHm  HE HH;|HE HOE H\$0Hl$8Ht$@H _E  UVWATH(H\$PHc\$pIcILH   HQHILl$XL|$ 8E IH,E H-E H,E LL   Lt$`L4    HNHVD HM D I~5H]I|$D  HNHl  HD HHuHD HND IIuLt$`Ll$XL|$ H\$PH(A\_^]HL$WH0HD$ H\$HHHF HO HHSHOD HH\$HH0_HL$WH0HD$ H\$HHHLE HO HHSHO{D HH\$HH0_HL$WH0HD$ H\$HHHD HtO HHSHO+D HH\$HH0_HL$WH0HD$ H\$HHHE HH HHSHOC HH HHH\$HH0_HL$WH0HD$ H\$HHHD HTH HHSHO{C HkH HHH\$HH0_HL$WH0HD$ H\$HHHTD HN HHSHOC HH\$HH0_HL$WH0HD$ H\$HHHD HM HHSHOB HH\$HH0_@SH HSk HH(HAHF HC Laf LHKHtHP tHC    H [H\$WH Hj HH(HAH=F HrC Le LHKHtHP tHC    @tH) HH\$0H _@SH Hj HH(HAHE HC Le LHKHtHP tHC    H [H\$WH H/j HH(HAHUE HB L+e LHKHtHP tHC    @tH+) HH\$0H _H\$WH HHd HHHJHKHtHPHGHCHGHCG C HH\$0H _H	( H\$WH 3HHHAHA HA(Ht0HH;vwHHCHC HHC(H\$0H _@SH HHIHt5( 3HCHC HC(H [H\$WH 3HHHAHA HA(Ht0H?H;v)wHHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht4HfffffffH;vvH诖HHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht7HUUUUUUUH;vYvH菗HHHCHC HȰHK(H\$0H _H8HD$    & HD$HHt3H3HPHtH
HPHtH
ƀ   ƀ    H8H\$Hl$Ht$WH IIHHu%3HHkHl$8HsHt$@HH\$0H _HH;vemH<    H? HuHtDmH\$Ht$WH IHHu3HHsHt$8HH\$0H _HH;vlH<    H> HuHtlHL@WHP  HD$0HhHpIHHHc$  L;      DBHL$`; H[ HL$`HHHHZ ֗Hȋ$  ; HHZ 跗HT$8HL$`; HD$@H|$XHCD$@HD$ L
Z L$p  HH&L$P  IkIsI_@SH H+MHH    J H~LLHI%= HH [@SH L+LIIJ    J
MtLMH< HH [@SH H+MHH    J H~LLHI< HH [@SH L+LIIJ    J
MtLMHe< HH [@SH H+IHH    H+H~LLHH&< HH [@SH H+IHH    H+H~LLHH; HH [HL$WH0HD$ H\$HHH< H? HHSHO: HtH@3H^ HG@HKHOHHtHPHCHGPHCHGXC G`Hc HHc HG@HH\$HH0_H@7  @SH Hc HHH^ HA@HIHHtHP tHCH    H> HKH: HH [H%D; @SH Hc HHH~c HA@HAhHcPHKc HD
hHAhHcPHc DBDD
dHH|] HA@HIHHtHP tHCH    HF> HKHi9 HH [H%: HcAH+Hx  H@ׂ  @SH H#c HHH\ HA@HIHHtHP tHCH    H= HKH8 HH [H%$: H\$WH Hb HًHH\ HA@HIHHtHP tHCH    H< HKH}8 H9 @tHr  HH\$0H _HWH`  HD$0HXHhHp IIHHI@ I+@HL;      DBHL$`#7 Hsc HL$p蹒HH}6 HHc 螒HHb 菒HHb 耒HHFb qHT$8HL$`6 HC H+CHH$  HD$@H|$XHCD$@HD$ L
a L$  HHL$`  I[IkIs(I_HLH WHp  HD$0HhHpIHHL;$       DBH5 HH$   袑HH藑HT$8H$   5    DBH$  \5 HT H$  WHH$  GHH$  7HHET (HH$  4 HH
T HT$`H$  4 HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
S L$  H胴L$p  IkIsI_HSH   fW)pD)Hf/fD(   u"5I 3fDWfA(fW  (I fA/v+fDW
H fA(
H \f(  fDW
H 3fA(aX>   H )$   D)$   f/D)T$pD)\$`D)d$PD> D)l$@D)t$0D)|$   b fA/vRfD.z   u%b %  % AYDY
ub AX  ͙ u[Qb 
Ab -1b  5b =b ` 
` -` 5` =` (=V 5F -6 
&  uaDa D%a D-a  D5ea D D% D- D5 D fE(-D5 D- D%~ Dm D\ fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X%` AYtur` fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [_ fA/v
T fA/   uuD_ D%_ D-_ p D5_ D=n_ ^_ DŖ D%Ė D-Ö D5 D=  -D= D5 D- D%{ Dj ur^ D Ԗ  ^  ^  ^  t^  \^  fA(fE(D\AYfWD fA(fA(AYAYI f(f(f(f(Yϕ Y
 X
 AXAYYYX
U AXAXYAYYX
& Xf(Y> A^X! AXYX  AYX^Xs] YtZ] fA/    uuD4] D%#] D-]  Y D5\ D=\ \ DF D%E D-D D5C D=B B -D=/ D5 D-
 D% D @ub_\ @D   5\  \  \  [ } fA(fE(D\AYfWyB fA(fA(AYAYB f(f(f(f(Y` Y
( X
 AXAYYYX
 AXAXYAYAYXf(Y֒ AXA^X YXX
 ^X[ YyZ fA/   xvDZ D%Z D-Z ] D5Z D=Z sZ D D% D- D5 D=  -D=ӑ D5 D- D% D rcY DD  > Y 6 Y . Y & Y  fE(fA(D\cY AYfWv@ fA(fA(AYAY? f(f(f(f(Y Y
Ő X
 AXAYYYX
 AXAXYAYAYXf(Ys AXA^XQ YXX
1 ^XX Yv 	   DsX D%bX D-QX 	g D56X D=%X X 
X D D% D- D5 D=  
 -D=e D5T D-C D%2 D! 
rsW 
DΎ  Ȏ XW  @W  (W  W  V  fE(fA(E^AYfA(fA(fWZ> AYAY- f(f(f(f(Y Y Y
C X
+ AXAXYYYX
 AXAXAYYYX
΍ AXA^Xf(Y܍ Xč YX AYX^XV YLHLH WHp  HD$0HhHpIHHL;$       DBHs( HH$   rHHgHT$8H$   T(    DBH$  ,( HPG H$  'HH$  HH$  HHG HH$  ' HHF ؃HT$`H$  ' HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
F L$  H3L$p  IkIsI_HWH  HD$ HXHhHpIIHHٺ   DBH' HH$   
HHE HHHHE HHقHM HuH9L HIHI' H$  H衂HT$hH$   & HHL$(( H+ HD$(HHL$@' H+ HD$(H
 HL$( H8HD$  HtHtI HHHH8HVWATHP  HD$0HXHhIIHL   DBHL$`% HHL$`ÁHHJ 贁HHVw% HH1 蘁HT$8HL$`% HcHE $  HT$@H|$XHCT$@H$  HD$ L$  L$  ILHL$WH0HD$ H\$HHHd' H\* HHSHO+& Hs* HHtH@3HI HG@HKHOHHtHPHCHGPHCHGXC G`HO HHT HG@HH\$HH0_H@H(GH(HL$WH0HD$ H\$HHH& H|) HHSHOK% H) HHtH@3HI HG@HKHOHHtHPHCHGPHCHGXC G`HT HHfT HG@HH\$HH0_H@z  HL$WH0HD$ H\$HHHH{H HHJHOHtHPHCHGHCHGC G HS(HO(% H
M HHpS HG(HH\$HH0_HL$WH0HD$ H\$HHHHG HHJHOHtHPHCHGHCHGC G HS(HO($ HL HHR HG(HH\$HH0_HL$WH0HD$ H\$HHH$ HD( HHSHOk# 3HGHHGPHGXG`HL HHL HG@HH\$HH0_HL$WH0HD$ H\$HHH$$ H' HHSHO" 3HGHHGPHGXG`HL HHQ HG@HH\$HH0_LALIHH+HLIHHHHM   IIf(
~DHf(B~+HALR HH    fAX
fAXBI HuL;fX~fXM;f(fX}dII+H|>IJDI+HHHMfD  XHH HXHXHXHuM;}JM+XHIuf(M
   L;A~YI@H|5IHIAHHH   X@H HX@X@X@uI;}IL+X HIu@SH HQ HHHQ HA@HAhHcPHcQ HD
hHAhHcPHJ DBDD
dHHD HA@HIHHtHP tHCH    H$ HKH  HH [H%! HcAH+Hxu  H@u  @SH HH(H<Q HAHQ HHC@HcPHP HD@HC@HcPHH DBDD<HH($ H_! LC LHKHtHP tHC    H [H(7u  HcAH+HP u  @SH HH(HP HAHP HHC@HcPHP HD@HC@HcPH;H DBDD<HH`# H  L8C LHKHtHP tHC    H [H(t  HcAH+HPt  @SH HN HHHB HA@HIHHtHP tHCH    H" HKH HH [H%  @SH HP HHHO HA@HAhHcPHO HD
hHAhHcPHM DBDD
dHH<B HA@HIHHtHP tHCH    H^" HKH) HH [H%j HcAH+Hxs  H@s  HSH   fW)pD)Hf/fD(   u"5J1 3fDWfA(fW  X1 fA/v+fDW
1 fA(
#1 \f(  fDW
0 3fA(aX)'   0 )$   D)$   f/D)T$pD)\$`D)d$PD& D)l$@D)t$0D)|$   K fA/vRfD.z  : u%J %  % AYDY
J AX   u[J 
qJ -aJ Ѓ 5HJ =8J  
 - 5 = (=~ 5n -^ 
N > uaDI D%I D-I F D5I D D% D- D5 D fE(-D5Ȃ D- D% D D fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X%H AYtuH fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [%H fA/v
= fA/   uuDG D%G D-G  D5G D=G G D D% D- D5 D=  -D=ր D5ŀ D- D% D urG DB  < F 4 F , F $ F  F  fA(fE(D\AYfW, fA(fA(AYAYy  f(f(f(f(Y Y
 X
 AXAYYYX
} AXAXYAYYX
N Xf(Yf A^XI AXYX( AYX^XE YtE fA/    uuDdE D%SE D-BE   D5(E D=E E Dn~ D%m~ D-l~ D5k~ D=j~ j~ -D=W~ D5F~ D-5~ D%$~ D~ @ubD @D} ~ } eD } MD } 5D } D } fA(fE(D\AYfW* fA(fA(AYAYr f(f(f(f(Y} Y
P} X
8} AXAYYYX
} AXAXYAYAYXf(Y| AXA^X| YXX
| ^X@C Yy'C fA/  } xvDC D%B D-B } D5B D=B B D| D%| D-| D5| D=| | -D={ D5{ D-{ D%{ D{ rc)B Dl{ | f{ A ^{ A V{ A N{ A F{ fE(fA(D\A AYfW( fA(fA(AYAYo f(f(f(f(Y%{ Y
z X
z AXAYYYX
z AXAXYAYAYXf(Yz AXA^Xyz YXX
Yz ^X@ Yv{ 	   D@ D%@ D-@ 	{ D5f@ D=U@ E@ 
5@ Dy D%y D-y D5y D=y y 
y -D=y D5|y D-ky D%Zy DIy 
rs? 
Dx z x ? x p? x X? x @? x (? x fE(fA(E^AYfA(fA(fW& AYAY] f(f(f(f(Yx Yx Y
kx X
Sx AXAXYYYX
%x AXAXAYYYX
w AXA^Xf(Yx Xw YXw AYX^X3> YLHH   )p)xD)@f(D)HD)PD)XD)`D)l$@D)t$0y D)|$    D
C D%oC D-^C my D5DC D=3C #C DC D
y D% y D-x D5x D=x x D
x Dx fE(?Dx Dx D=x D5x D-x D%x D
}x 5 fW\fD(Xf(f($   YD^fA(AYI $   Y
j$ DYDYL$   DX7x EXD(|$ DYDY^EXD(t$0EXD(l$@XA(sDYDYA({EXE(cEYEXE([EXE(KEYE(CA\E(SIHH   )p)xD)@$   D)HD)PD)XD)`D)l$ D)t$w D)<$u
A 
w w 
w uoA A 5A w =yA DhA D
WA Gw Gw 5Gw =Gw DFw D
Ew 2D
:w D)w =w 5	w v v %    D@ D%@ D-@ v D5@ D=@ s@ Dbv D%av D-`v D5_v D=^v ^v %&v fD(6D=>v D5-v D-v D%v Du Du $   L$   f(\\-? $   \-? \f(YYf(AYE(KX$   YXf(AYE(CYXA(sYf(AYD(<$XXAXD(l$ YAXf(E([YZu YA({AXD(t$YAXE(cYAXE(SX^YY-> Xf(I@SH HD$0    HH [LD$SVWH0HD$ IHHH\$PH;t+H\$XH\$(Ht
HH H(H\$`H(HH0_^[HATH`  HD$0HXHhHpHx IMHHHY H+YH|C;}HH;r9
 HFHj   DBHL$`S H1 HL$pfHȋ
 HT$8HL$`> LL$@H|$XLCL$@Ld$ DǋH
c> &L$`  I[IkIs I{(IA\HATH`  HD$0HXHhHpHx IMHHLQ L+QH*IHHHH?H|#G;}HH;r/ H[HHFj   DBHL$`E
 H/ HL$peHȋ	 HT$8HL$`0
 LL$@H|$XLCL$@Ld$ DËH
U= L$`  I[IkIs I{(IA\LD$SVWH`HD$ IHHH$   HL$0	 H;t?H$   H\$(HtHT$0HQ
 HH	 H(H$   H(HL$0
 HH`_^[HL$WH0HD$ H\$HHH
 L LHGHCHG HC H- HC(HO0HK0HtHPHG8HC8HG@HC@GHCHH< HH< HC(HH\$HH0_H(Wg  HL$WH0HD$ H\$HHHd
 H\
 HHSHO+	 3HGHHGPHGXG`H8 HH|8 HG@HH\$HH0_@SH H< HHH, HA(HI0HtHP tHC0    H HHH [H%	 @SH H< HHH; HA(HAPHcPH; HD
PHAPHcPHo; DBDD
LHH, HA(HI0HtHP tHC0    H> HHH [H%	 H(e  HcAH+H`e  H8MPE3MtIMH\$0H      ffffff     IcAD$PHD$PH#H;tIM;rH\$0H8H3' HD$(H' HD$ @SH0fW)t$    f/f(vfW5 f( 
 H,f(t
X\f(\f(f/-k v\f(Y-9 f(Z fnY(t$ YH0[HH   )p)xf(j f(D)@D)Pf/fEWfD(fA(vf( fW c  fA.zR  fA.zE  D)$   D)\$`D fA/D)d$PD)l$@D)t$0D)|$   D
 D fA/r6fff     fA(A\Xf(G fA/Xsf(A\7o    ( 
( %( o D}( D
l( D[( D%J( n 
n %n Dn D
n Dn D%n <D%n Dn D
yn Dhn %Xn 
Hn 8n    ' D5' D=' En m u' Dm m T' D5m m 3' D=m m ' fE(m D=jm D5Ym D-Hm f(AXYf(YAYAXYXYXf(AYAXYXf(Y
/m YX
m Xf(YYm X
l Xl YAXYYAXYXAX^YY5,& XV  D
R
 fD/vf( fA(fD(\AX% f/  l    % 
% 5% l D% Dt% D%c% D-R% k 
k 5k Dk Dk D%k D-k <D-k D%k Dk Dpk 5`k 
Pk @k ux$ D5$ D=$ k j $ D
j j `$ D5j j ?$ D=j j D=j D5j D
qj fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
Nj AYX
1j Xf(YY%j AXXj YAXYAXAYX^YY%]# X  j uq%:# *# 5# j D # D" D%" %>i >i 5>i D=i D<i D%;i 3D%0i Di Di 5h h %h  uz
b" D-Q" D5@"  i D=&" 
h 
" 
h 
! D
Mh 
uh D-Dh D5Ch D=Bh $D=7h D5&h D-h D
h DYfW-W f(f(YYf(AYAXYXf(AYXYYf(Y
g Xf(Yg X
g XYAXAXYYAXAXYX^AYDY  AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIH\$Hl$Ht$WH HIIH+HIHHHH+HHHHKH;s&D  CHCf/wf/wHH;rH;   HH+HHHHH|vfD  	f/   f/wzIf/p  f/f  If/N  f/D  If/,  f/"  HGH H;|H;sf/wf/w	HH;rLLL;C  HI+HHHHH   IPAf/w#f/  HHI;t
 A JLRf/w#f/  HHI;t
 A
f/w"f/d  HHH;t JLRf/w#f/8  HHI;t
 AHGI H L;L;s7Af/wf/w"HHI;t
 A IL;rL;vFIQ    f/wf/w$HH;tHHIHI;rL;   L;   I;tH;tHHILHHIL;'HAIHHHI;I2I)IL;u8HL;tHAIHH;HHM;tIA I AI~Ht$@H] H\$0HMHHl$8H _M;   H\$H|$IMHI+HH|WLHII+ODL+HJTHHMI@H I HHBIDHBI@HBI@HBuM;}"HHH+JM+HHIHAuH\$H|$H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3AY@@MtIJHtH3AY@@MtIJHtH3AY  MtIJHtH3AH HY@@dM;};HM+HJMtIJHtH3AHIY@@uH\$H\$WH HC tH HH\$0H _H\$ UVWH0I@ 3II+@HHHHtbLd$PLl$XI      IH;ro HOD$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]H! LLHD$(H HHHD$ 耈HH   6- )pD)@D)XD)`D)l$@b fD(D)t$0D)|$    , %, -, Mb 5, D%, D-, D5, D=q, a, a I, a a ), %ya a 	, -ia a + 5Ya a + D%Ha a D-?a D5>a D==a =a f(DD=&a D5a D-a D%` 5` -` %` 
` DJ  u\.+ + a ]` * =` M` * -` =` D<` 
` uy* * ` _ u* _ _ U* _ =* _ %* _ 
* _ )$   D)$      ) ) D
) ` ^ ) fA(^ }) ^ ^ ]) D
^ ^ <) =^ ^ =^ D
^ fD. zu
fA(  ( D)T$pfA/  EYfA(AYfD(f(Y)_ DY(_ X_ DX_ YDYX^ DX^ YDYDX^ AXYDYAXEXYDYXEXYDYXAYDXDYDXf(Y
^ DXf(Y] X
] X] YX
] YAYXXD^   E^fA(D\' fA(AY fD(fA( YDYf(X=] DX
\ Y
E] D^X
(] f(Y$] YYX=\ X
\ YYDYX\ X=\ X
\ DX
\ YAYDYX\ AXAYX=N\ X^DYfA(D(T$pD($   ($   D(l$@L$   A(sE(CE([E(cD(t$0D(|$ IHH   )pD)HD)PfD(D)XD)`D)l$@^ D)t$0D)|$   i( 
Y( I( ] %0( - ( 5( D%' D-' D5' D=' ' l] ' 
] ] T] |' %\ D] \' -\ 4] <' 5\ $] D%\ D-\ D5\ D=\ \ LD=\ D5\ D-\ D%\ 5z\ -j\ %Z\ J\ 
:\ D
 ub& & \ [ d& [ [ D& D
[ [ #& [    & % "\ :[ % "[ *[ % "[ % [ % [ j% 
[ R% [ )$   D)$   uz%% D% fA(~[ NZ $ DeZ =Z $ =UZ -Z $ %Z $ Z =#Z DZ fWfE(fD.fDT z  C# fA/  EYfA(D$   AYfD(f(DYZ YZ DXZ X|Z DYYDXbZ XRZ DYYEXAXDYYEXAXDYYDXXDYYDX$   XYDYDXf(Y
Y DXf(Y|Y X
lY X\Y YX
HY YYXX
,Y D^EY   E^fA(D\
" fA(AY- fD(fA(< YDYf(X=wX DXfX Y
X D^X
X f(YX YYX
uX X=%X YDYYX`X X
@X DXW X=W YAYEYX!X AXYXX
W ^DYfA(D($   ($   D(l$@L$   A(sE(KE(SE([E(cD(t$0D(|$ IH;   Ht$WH0H\$@HYHHH;   Hl$H   )t$ H+ 3Hf/v+HT+HH~HLH+LH 7.CHCf/vD  @HHf/w1HH;u(t$ Hl$HH\$@Ht$PH0_@SH HD$0    誰HH [@UHMILH;u2H]Ht$0L$$<-AEu<+uHHH+H}Ht$0L$$2H]H\$(H\$@3H+DHL+ِD D:tE:uDAHArHL;   IH+H|D$X8uD$`A8B   2   LT$PL\$HH|$Hu5IIDH+H+HD  D D:tD:uAHAr+Hu|L+L+fD  B:tB:uaHrEuH HHM 'H{ H        D$ HD$ H3HE H|$H\$(Ht$0L$$H]2EuH( HHM H H        D$ HD$ H3HE HVWATHP  HD$0HXHhIIHL   DBHL$`Q HHL$`SDHH!
 DDHHV HH% (DHT$8HL$` HE H+EHH;r  HEHH$  HT$@H|$XHCT$@H$  HD$ L$  L$  IZM;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDB\DCD|HL$WH0HD$ H\$HHHt Hl HHSHO; Hk HHtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H HH HG@HH\$HH0_H@gi  HL$WH0HD$ H\$HHH HT HHSHO{ HS HHtH@3H4 HG@HKHOHHtHPHCHGPHCHGXC G`H@ HH& HG@HH\$HH0_H@gi  @SH H HHH
 HA@HIHHtHP tHCH    H HKH HH [H% @SH H HHH HA@HAhHcPH HD
hHAhHcPH DBDD
dHH
 HA@HIHHtHP tHCH    H> HKH	 HH [H%J HcAH+HxPg  H@Gg  @SH H HHH	 HA@HIHHtHP tHCH    H` HKH HH [H% @SH H HHH HA@HAhHcPH HD
hHAhHcPHO DBDD
dHH HA@HIHHtHP tHCH    H HKH HH [H%* HcAH+Hxf  H@f  H\$WH`)t$P)|$@D)D$0fD(f(Af   f(fYEYD)L$ fW= D
: fA(\AYY  fA(YY f(X
 f;vGfffff     f(ffA(YAY\fn^f(YXf;rH\$p(t$P(|$@f(D(D$0D(L$ H`_HH   D)@D)PD)XfD(D)`wQ uy
   RQ 
Q 
 Q  
Q 
 
Q 
z P 
P P D% fEWҨuk@ 
0 P WP  
OP 
 GP  GP 
7P D%>P D=P     
 \P O t 
O 
\ O D 
O 
, O  
|O 
 tO 
tO     
 O N  
N 
 N s N [ 
N 
C N D%N 
N  uj 
 =O N  

N 
 N  N M 
M DM  ujp 
`  N oM ? 
gM 
' _M  _M /M 
GM D%NM @ur 
 @aN L  
L 
 L y 
L 
a L 
L DL xs4 
$ M L  
L 
 L  
K 
 K 
K D%K D)l$@rD- D-K iM 	D-K 	rP 	dK >M 
)$   r5  
54K M 5$K D)|$ rD= D=J L 	D=J )$   r= =J L =J 
D)t$0rD5r 
D5J L 	D5tJ fE.fE(fDTQ zu
fA(   D)$   fA/rifA(L$   HK H
K E3AY$   'Y5 fA(fD(fA(\AXAYA\YDY,  D- fE/rlfA(L$   HJ H
J E3AY$   a(Y=a fA(fD(fA(XI \AYA\YDY   E^fA(AY$   fA( f(fA( L$   HGI H
xI E3f(&L$   HI f(XfD(H
I E3EYDY&\YDXfA(X Y D^EYfE/v	DY
~ fA(D($   D(|$ D(t$0D(l$@($   ($   D($   D(T$pD(\$`D(d$PH   LL$ LD$HT$HL$SUVWATAUAVAWHx  H$  D)$   MLLHAHL$t
LHL$8+HHD$HT$HHكH;HL$HMLL\$8HI+HIH\$@HCH$   IHH3H+LIAu33IHcHl$H$   H$  HփtH&HHD$LL$HHكH;HL$IMHE3Ld$L$$EL$Hu]MuXHHH3H+L;tIIIL$$|IuE3L$   Ld$,M;H$  H$HML Ld$3E3L\$8H\$@D$      L;ADL;DDHcII+McHHHIL;HT$  L$  H$  I)$`  )$P  D)$@  MIHH$   HD)$0  D)$   D)$  D)$   HH$   ID)$   D)$   IL    IM,1HH$  HIHHT$hIT$HH$   IIL4HL4$IL    HIIL$  HN$8HD$0IIM+Ld$xI+L$  L|$(HD$PH$  HLHOIMHL$0L$   H$   H+L$   H$  HL$0HL$H+L$HHHHL$HL$hfA(3IY	DfA(AY	fDDfDfA(Y
DfA(AYfDDfD  MKL\$0HI+MIHD$HIM+I+MIT$HD$XIHOH|$HHl$XH+HD$`ILFH\$`H+HD$pILd$pI+IH$   J    L$   HD$ ffff     IfA(fA(H I H fA(I ICYD2XAAYJXfA(IAYPXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(AYLXIIYBXfA(AAYHXfA(ICYD XAL\$8H\$@H$  H$  Ld$xL4$HD$ I;}MLMMIM+M+M+L+H+HIfA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuI;  H$   H  Hc  H   L;k  HT$(HMI+MMHL+HHL+L+HJސfBfBfB HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  H$   fG(dfF(lL;MfG(t  I+ILHLH+HL+M+KDHK\ NTKlM<Lfff     f(}f(fA("KfEYfEYI H fB(,fA(sf(H I HfAYfAYfAYEDfAXJfXfA(fD((fEYfAYfA(fD(eAfXfXfAYfXfAXfA)JfE(sfXfXfA)zBL\$8H\$@H$  L;  HT$(HMI+MMHL+HHL+L+HJff     fBfA(fA HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  L;  HT$(HMI+MMHL+HHL+L+HJ     fBfB(fB HHfAYfAYfAYfXf(@fAYfXfXfXTf)Tu   L;   HT$PHMI+MLHM+HHM+M+HKD     fB(fB(fB( HHfAYfAYfAYfXf(@fAYfXfXfXTf)TuH;H\$H  HH+H'  ILMH+L+ITHD$pIHI+HLMHD$ IM+H|$ I+IH$   ILLH$   H+HD$`ILd$`H+HD$XII+Lt$XIH$   JH\$pL$   HD$HfD  HfA(fA(H I H fA(I ICYDXAAYJXfA(IAYQXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(CYLXIIYBXfA(AAYIXfA(ICYDXAL\$8H\$@H$  H$  Ld$xL4$HD$HH;}MLMMHM+M+M+L+H+HJ9fA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuH$   HL$hL$   H$   L$   HLHLH$   HL$hL$   HD$PHD$(H$   HD$0LLLHHl$Ld$xL4$H$   L$   L$  HT$H$  D($   D($   D($   L$  D($  D($   D($0  D($@  ($P  ($`  HD$fD  I;  H$  HMIH$  MkL    HM2L+HH$  LL+L$fA(E3IAY$f||ISIHHGHHL    D  f(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuM;}.IIJH+I+f(HHYDX@@uCuHL;}   HIJI+H+HHH    f(HHfYfX@f)@u>L;}9HIJI+H+HHH fHHfYfX@f)@uH;H   HH+H   HMILH+L+HDHHHH4ff(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuH;}.IHHH+H+f(HHYDX@@uH$  MMH    LIHD$Ht!H$  L$  3L3HD$3D($   Hx  A_A^A]A\_^][M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCD|HL$WH0HD$ H\$HHH H HHSHO H HHtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H@ HH& HG@HH\$HH0_H@]  HL$WH0HD$ H\$HHHD H< HHSHO 3HGHHGPHGXG`H  HH  HG@HH\$HH0_HL$WH0HD$ H\$HHH Hd HHSHO 3HGHHGPHGXG`H  HHl  HG@HH\$HH0_@SH H HHH HA@HIHHtHP tHCH    H HKH HH [H%4 @SH HC HHH& HA@HAhHcPH HD
hHAhHcPHo DBDD
dHHl HA@HIHHtHP tHCH    H6 HKHY HH [H% HcAH+Hx[  H@[  @SH H HHH HA@HIHHtHP tHCH    H HKH HH [H% H\$WH H7 HًHH HA@HIHHtHP tHCH    H HKHm H @tHb HH\$0H _HHXHpWH   )p)xfW3H5Xd{
D)@D)HD)PfD(fD(fD(EYDYD)XDY D fD  fA(Y3Н AXf(AY! HHY3X ^Xu(t$pL$   AYE(CE(KE(SI[Isf((|$`E([I_HL$WH0HD$ H\$HHHT HL HHSHO HtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`HR  HHp HG@HH\$HH0_H@HL$WH0HD$ H\$HHH H4 HHSHO[ 3HGHHGPHGXG`H HH HG@HH\$HH0_HL$WH0HD$ H\$HHH H HHSHO 3HGHHGPHGXG`H> HH\  HG@HH\$HH0_@SH H  HHH  HA@HAhHcPH  HD
hHAhHcPH DBDD
dHH HA@HIHHtHP tHCH    H> HKH	 HH [H%J HcAH+Hx`  H@`  @SH HD$0    jHH [HE3LLL9QLT$S  H\$H<$fff     ICHL$ HT$I;HD$ HME3H9H   H_fMtI@HtH3IH@IISIHMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIIL;HDDL;}3MtI@HtH3IH@IISIIL;H|IM;SLT$H<$H\$HM;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBu@SLLHL$MBIBHT$ L;LD$HD$ HME3HH   H|$H{MtIAHtH3IRI
H@HIHMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIIL;HDAH|$L;}3MtIAHtH3IRI
H@HIIL;H|[@WH0HD$ H\$PHt$XHH3H\$@HJHt3HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt	HHP H\$PHt$XH0_@SHP- )t$@HѨu+  X , YW , , I(3fnY   HBHl$`HjHt$hH|$pH4   )|$0=` D)D$ fEWHfHH(fTfA.zt	Х XHHuD(D$ (|$0H|$pHt$hHl$`f((t$@HP[@SH HHIHt H3HCHC HC(H [ H\$Hl$Ht$WH0Hi HH9iv H3Hl$(3Ht$ (D$ fD$ Hut LLH]I;[ wHtHHH;XsI HD$ Hu9 H8H;_ r( Hl$HHt$PHH\$@H0_H\$Hl$Ht$WH0Hi HH9iv H3Hl$(3Ht$ (D$ fD$ HuĽ LLH]I;[ wHtHHH;Xs HD$ Hu H8H;_ rx Hl$HHt$PHH\$@H0_H\$WH HHH;Qt>H	I HtH4H{HH\$0H _H    H{H\$0H _HQH\$0H _H\$WH HHIHHt HK03H{HH{PH{Xڣ HKHt̣ HH{H{ H{(H\$0H _鮣 H\$Hl$WH0LA HYHIHH+HH;wOHt$@I;vN H?H\$(3H|$ (D$ fD$ Hu) LLHI;[ wHtHHH;Xs HD$ Hu H0H;^ Ht$@rػ Hl$PHH\$HH0_H\$Hl$Ht$WH HcjHHH;it!H	 t
HHH    Hk~LFHHI謢 H\$0Hl$8Ht$@H _H\$Ht$WH HHI3HC    H+HHt6 HC H+HH;r HKHC HH+HHtH;rHKHt HHC    HC     HC(    ˡ H\$0HHt$8H _HATAUAVH`  HD$0HXHhHpHx ILLA   MPMM;3  fW@ 33E~4LE HcI;}%HM IIHf.z uHI;|AIIcI;   믺   DBHL$` H HL$pHHg HIHH] HȍVl HH eHAT$O HHe HHT$8HL$` LL$@H|$XLCL$@IcHMHHcHHE LHv HD$ II/L$`  I[ Ik(Is0I{8IA^A]A\D$Hx  HD$0)$`  f(H fW[ f.z   3f/rHHr\#       DBHL$` H HL$pJf(HL$pӶ HT$8HL$` HD$@H|$XHCD$@HD$ L
 L$  Hn H
_ .($`  Hx  @SH H}L L[xH [HL$SH0HD$ HD$P    EtHN HAhH HAxD$P   {L[ LHA HC@HChHcHH HDhHChHcHDd    HH0[H\$WH H\|L- L_xtH@ HH\$0H _H\$WH H HًHH HA@HIHHtHP tHCH    H HKH͵ H @tH HH\$0H _H\$WH HH   Ht莝 HKp3H   H   H   n HKXHt` HK@H{XH{`H{hK HK Ht= HKH{ H{(H{0H\$0H _ LSH   HǄ$   AC    HYHn ICHú ICAC   HHL$  H HD$ HSHL$8 HtH@3Hp HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHH H   H$   HcHǄ       H)
 HL$ $ H8MPE3MPMtYMH\$@H|$0H      Hff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8H> HD$(H HD$  H8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
 H L
 H3 HD$ q̃y +LAH
 H L
y H HD$ @̃y  +LA H
 HW L
H Hy HD$ ̃ 'H
b
 H+ L
 H% HD$ HH8H8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
 H L
 H3 HD$ q̃y +LAH
 H L
y H HD$ @̃y  +LA H
 HW L
H Hy HD$ ̃ 'H
j
 H+ L
 H% HD$ HH8HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhH HAxD$X   uH HH HC@HChHcHHb HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_@SH HD$0    ڌHH [@SH`
: )t$P)|$@f/Hf(D)D$0D)L$ fEWD fA(rtfA(\f(f(莗 f(\f/
 vfA(A\XfA.zu  !   H*     =) Yf(R ^fA.ztf/5O rf(Hiu? f/v*f     fA(fA(A\Xf/^XwfD/v*     fA(fA(^AXfD/\Xwf(HXf((t$P(|$@D(D$0D(L$ H`[@SH HD$0    躋HH [HL$WH@HD$ H\$`Ht$hIHHHL$XD  Ht*H\$(H\$0Ht
HH HH(H\$PH\$`Ht$hH@_H\$Hl$Ht$WH HH+HgfffffffIIHHHHH?HHHH+H;tH+H(HH^ H;uH\$0Ht$@HHl$8H _HMLH+HL+H;tL+D  HJHII;uI@SH HbLs L[xH [HL$SH0HD$ HD$P    EtH HAhH3 HAxD$P   چL LH HC@HChHcHHv HDhHChHcHDd    HH0[@SH HrLò L[PH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   ʇLc LHA HC(HC@HcHH HD@HC@HcHD<    HH0[@SH HrL L[PH [HL$SH0HD$ HD$P    EtH^ HA@Hӱ HAPD$P   誇L LH HC(HC@HcHH HD@HC@HcHD<    HH0[@SH HҌLc L[xH [HL$SH0HD$ HD$P    EtH HAhH# HAxD$P   誅L LHq HC@HChHcHH> HDhHChHcHDd    HH0[H\$WH H蜉L L_xtH HH\$0H _H\$WH HLm L_PtH耒 HH\$0H _H\$WH H茊L- L_PtH@ HH\$0H _H\$WH H\L L_xtH  HH\$0H _H\$WH H_ HًHH HA@HIHHtHP tHCH    H­ HKH HԪ @tH肑 HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH HAxD$P   mH HH HC@HChHcHHr HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HǄ$   AC    HYH ICHS ICAC   HHL$ y Hq HD$ HSHL$8= H HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Hh HD$ HL HD$`H$   HcHH H   H$   HcHǄ       H.
 HL$ 訏 LSH   HD$ HAC    H ICH7 ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$P% H HD$(H HD$PHD$hHcHH| HDhHD$hHcHDd    H
 HL$(ю LSH   HD$ HAC    H ICHW ICAC   H< ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$PE H= HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    Ho
 HL$( LSH   HǄ$   AC    HYH ICHs ICAC   HHL$  H HD$ HSHL$8] H HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H` HD$ HD HD$`H$   HcHH H   H$   HcHǄ       H
 HL$ Ȍ HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHH HAxD$X   }H HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@!HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtH3 HAhH HAxD$X   ~H HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@aHH\$HHt$PH0_@SH HD$0    誙HH [@SH HrLӨ L[`H [HL$SH0HD$ HD$P    EtH HAPH HA`D$P   芘L3 LH HC(HCPHcHH HDPHCPHcHDL    HH0[H\$WH H輙L L_`tH0 HH\$0H _H\$WH H/ HًHH HA(HI0HtHP tHC0    H HH֢ @tH載 HH\$0H _H\$Hl$Ht$WH0Hi HH9ivi H3Hl$(3Ht$ (D$ fD$ HuD LLH]I;[ wHtHHH;Xs HD$ Hu	 H8H;_ r Hl$HHt$PHH\$@H0_HL$WH0HD$ H\$HHt$XHH3|$PEtHC HAhH HAxD$P   ?zH' HH
 HC@HChHcHH HDhHChHcHQTdHtH~@HHK@qHH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHإ HAxD$P   _zH? HH% HC@HChHcHH HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HD$ AC    HYHa ICH& ICAC   HIK LV L\$(HCHD$@HC HD$HH HD$PHK0HL$XHtHPHC8HD$`HC@HD$hCHD$pHg HD$(HK HD$PHD$xHcHH HDxHD$xHcHDt    H
 HL$(裆 @WE3LHL9I   H\$HYfL;M}gMtI@HtHH3HtHA3H@HPLIIHtH3AHI^AIIH_L;|IL;O|H\$_H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(fY   MtI@3H@HMtI@3H@A   M;Hf(JfYI}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXN  HI+H   LSMtI@3H@HMtI@3H@HBBYXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@IM;HBDBYDX
L;}BMtI@3H@HMtI@3H@IL;HBLBYLX|f(H\$MtI@3H@HMtI@3H@HY   H;N  HCH   LS    MtI@3H@LMtI@3H@HAYXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HI;HDAYDXH;}AMtI@3H@LMtI@3H@HH;HLAYLX|H\$f(HL$WH0HD$ H\$HHt$PHH3|$XEtH3 HAPH HA`D$X   H HH} HC(HCPHcHHJ HDPHCPHcHQTLHtH~(HHK(HH\$HHt$PH0_H\$Ht$WH 3HHt$0/ L LHCHGHC H\$8HG Hw0Hw8Hw@Ht$@Hh GHHHG HG(HH _HhI)|$@9|$pHD$pI#I      I;v*LH
 H L
l H5R HD$ D)D$0fDnEDD$pHD$pI#I;u*H

 HH LHQ L
 HD$  A 'H
N
 H L
 HQ HD$  fn)t$P5 ^~ 
 X
 A\D(D$0\Y(t$PYY=
 X(|$@f(HhHl$Ht$ WHPHA IHH+AHH  LH
 HQ )t$@fW(H      fnm l$`HD$`H#H;u*H
X
 H L
 HSQ LHD$ f/w*H
$
 H͵ L
 H7Q LHD$ D$`HD$`H#H;u*H
 H L
 HP LHD$ LO H
 HQ L+OLH\$h)|$0IH]HG H+GHHuq H_H =M H+   HH;^HF| 3f(HtVfnU Q
 % fffff     Hcf(HX\f(\fTY\H;r(|$0H\$hf((t$@Hl$pHt$xHP_fWHl$pHt$xHP_HhID)D$@DDD$pHD$pI#I      I;v*LH

 H0 L
	 HO HD$ 0D)L$0fDn
EDL$pHD$pI#I;u*H
4
 H LHO L
 HD$ A f/ܝ w'H
 H L
 H~O HD$ 
)t$P5 ^3{ 
5
 X
 E\D(L$0\DY(t$PEYDY
 AXD(D$@f(HhATAUAVHpHA MLH+ALH!  HB H+BH
  LH
;
 HO )t$PfW6H

 HO M$A.f/w*H
 H L
x HqO MHD$ 	MD$ IU H$   M+D$I+UH$   IHH$   L$   H$   3I;Ht$hH|$`)|$@H=~
 H$   Hl$0HCH&O MHHLYHN LMHYIE I+EHHu ID$ I}I+D$HHuܒ Iu IL$ I\$I+uHH+HHH;w
HH+HA=    H;HF^y f(HtG
 
 fHcf(HX\f(\YYYXH;r(|$@H|$`Ht$hH$   H$   f((t$PHpA^A]A\fWHpA^A]A\HWH  HD$ HXHHHHX H( H$   E3E33H$    Hr H$   HLCL+H$    A   E3H$   HL$0^ HD$0HcHHL0   L HD$0HcHdHHD$0HcHHDP   HHL$0% HHcQHB    HEHtHL$0 u2HL$0 H$   1 HL$0ڍ H$    2H$   H  _M;   H\$H|$IMMI+HHH}   HILHI+MLHKLHM+HKDM@H H H^A@HA^LH@^A@H^IHuM;}3HHHHL L+M+JHIB^DAuH\$H|$HL$WH0HD$ H\$HHt$XHH3|$PEtH HAPHX HA`D$P   OH HH HC(HCPHcHH HDPHCPHcHQTLHtH~(HHK(1HH\$HHt$XH0_LAMtI@3H@LPIHH+HLIHLIIM  MtI@3IH@Hf(fY   MtI@3H@   I;Hf(IfY}LMtI@3H@Hf(fYfXMtI@3H@HI;Hf(DfYfX|M;fX~"MtI@3H@HfB(fYfXM;f(fX   II+H   IRMtI@3H@HBYXMtI@3H@HBDYXMtI@3H@HBDYXMtI@3H@IL;HBDYXhM;}+MtI@3H@IM;HBLYX|f(MtI@3H@   L;HY   IBH   MJfD  MtI@3H@HYXMtI@3H@HDYXMtI@3H@HDYXMtI@3H@HI;HDYXlI;}*MtI@3H@HI;HLYX|f(H\$UVWH0I@ 3II+@HHHHtRLd$PI      H;r HOH@D$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]H LLHD$(H HHHD$ `H\$ UVWH0I@ 3II+@HHHHtfLd$PLl$XI      IH;r HOH@D$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]HF LLHD$(H HHHD$ 茟H\$LAMtI@3H@ HXHHH+HLHHLIIM  MtIP3HtHB3H@HHtHB3H@Hf(fYMtI@3IH@Hf(	fY  MtIP3HtHB3H@Hf(AHtHB3H@HfYAMtI@3H@A   M;Hf(YfY       MtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfBYfXMtIP3HtHB3H@HHtHB3H@HfB(TfBYTMtI@3H@IM;HfB(DfYfX,M;fX~dMtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfB(fYfXL;f(fX}iMtIH3HtHA3H@HHtHA3H@HBBYMtI@3H@IL;HBYDX|f(H\$MtIH3HtHA3H@HHtHA3H@H	Y
MtI@3H@   H;HY	}gMtIH3HtHA3H@LHtHA3H@HAYMtI@3H@HH;HYDX|H\$f(HWH`  HD$0HXHhHp IIHHM;H      DBHL$`n H HL$pHHȃ HHf HH HHЯ HH HT$8HL$` HGH$  HD$@H|$XHCD$@HD$ L
: L$  HH?L$`  I[IkIs(I_M;D  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3AAOAYI\AAMtIBHtHH3HtHA3H@HHtH3ALAAYI\AAMtIBHtHH3HtHA3H@HHtH3AYI\AMtIBHtHH3HtHA3H@HHtH3AAI)H I HYI\AALd$0Ht$(Hl$ H\$L;}aIE L MtIBHtHH3HtHA3H@HHtH3BCIL;YI\CD|A]_M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAYAAXAAAMtIBHtHH3HtHA3H@HHtH3ADYAAXAAAMtIBHtHH3HtHA3H@HHtH3YAAXAMtIBHtHH3HtHA3H@HHtH3I)H I HYAAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;YACXDCD|A]_@SH HRLÅ L[xH [HL$SH0HD$ HD$P    EtH. HAhH HAxD$P   L LHѶ HC@HChHcHH HDhHChHcHDd    HH0[@SH HL L[xH [HL$SH0HD$ HD$P    EtH~ HAhHӄ HAxD$P   *L LHi HC@HChHcHH6 HDhHChHcHDd    HH0[H\$WH HL] L_xtHpf HH\$0H _H\$WH H HًHH HA@HIHHtHP tHCH    H2 HKH} HD @tHe HH\$0H _H\$WH HLL L_xtHe HH\$0H _H\$WH H HًHHP HA@HIHHtHP tHCH    H HKH=} H~ @tH2e HH\$0H _LSH   HǄ$   AC    HYHn ICHÂ ICAC   HHL$ } H HD$ HSHL$8| H݀ HD$ HtH@3Hd HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHH\ H   H$   HcHǄ       H>	 HL$ d LSH   HǄ$   AC    HYHN ICH ICAC   HHL$ | Hi HD$ HSHL$8{ He HD$ HtH@3HD HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Hز HD$ H HD$`H$   HcHH H   H$   HcHǄ       H	 HL$ b HL$WH0HD$ H\$HHt$PHH3|$XEtH# HAhHx HAxD$X   H߱ HHű HC@HChHcHH HDhHChHcHQTdHtH~@HHK@QHH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtHc HAhH HAxD$X   Hg HHM HC@HChHcHH HDhHChHcHQTdHtH~@HHK@葹HH\$HHt$PH0_@SH HD$0    HH [@SH HD$0    ZHH [H   
 D)$   fD(Ȩuy
!   
 
 
 
 Ƚ 
p
 
 
p
 
 H
 
h
 X
 P fWۨui` 
P ?
 
 / 
 
 
  
 
 
 
    Ǽ 
 
 
  

 
~ 
 f 
 
N 
 6 
 
 
 
     
 =
 E
 Ż 
=
 
 5
  5
 } 

 
e %
 %
 

 %= D)l$@D)t$0D)|$ umD- D5 D= 
 
ۺ ˺ D-Z
 D5Y
 D=X
 
X
 X
 %(
 f(+
:
 D=)
 D5
 D-
 -
 )$    u[5K ;  
 5
 5 %
 5
 5 z
 5
 
 %X
 @ui5Ĺ  @
 5
 5 
 5
 5s 5
 5[ 5
 5C 5
 xb5'  %
 5m
 5 U
 5]
 5ո e
 5M
 5 5E
 D)$   rD D
 
 	D
 	D)\$`rDR 	D
 
 	D
 
)$   r= 
=
 L
 =r
 D)T$prDݷ DH
 
 	D7
 r5 5
 
 5
 
D)d$PrD%p 
D%
 
 	D%
 fA/v	fDW
B fD.zu	f(  8 fA/r^fA(L$   H
 H
.
 E3AY$   Y=  EXf(fA(\A\AYY7  D fE/rjfA(L$   H
 H
H
 E3AYY \$   覽Y5 EXf(fA(\A\AYY  E^fA(AYf/   f(fD(DY~
 YF
 X6
 DXDYYX
 EXDYYEXX
 DYEXYX
 DYDXYXD^   f(^f(fD(DYYX
 EXDYYEXX
 DYEXYXx
 DYDX
 YXf
 DYDX
 YXT
 D^f/   fD(f(DY
 Y
 DX
 X
 DYYDX
 X
 DYYDX
 Xn
 DYYDX
 XL
 DYYDXb
 X*
    ^fD(f(DY?
 Y
 DX6
 X
 DYYDX$
 X
 DYYDX
 X
 DYYDX 
 X
 DYYDX
 X
 D^fA(W f(fA(W f(fA(W - f(EY^X\AYAY\Yf(D(|$ D(t$0D(l$@D(d$PD(\$`D(T$pD($   ($   ($   D($   H   M;  H|$ AT
 III+LLHI  HH\$Hl$Ht$ N   II+ؾ   HHH+H+HIHMMtIBHtH3HtH3H@L*HB	fWBMtIBHtH3HtH3H@HBD	fWBMtIBHtH3HtH3H@HBfWMtIBHtH3HtH3H@H I HHHDfWBHt$ Hl$H\$L;}FI$MtIBHtH3HtH3H@IL;HBDfWBD|H|$(A\M;L}kHHLMtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCXDCD|@SH HbL#s L[xH [HL$SH0HD$ HD$P    EtH HAhHr HAxD$P   LS LH9 HC@HChHcHH HDhHChHcHDd    HH0[H\$WH H謣Lmr L_xtHT HH\$0H _H\$WH H HًHH  HA@HIHHtHP tHCH    Hp HKH
l HTm @tHT HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH3 HAhHq HAxD$P   H HHբ HC@HChHcHH HDhHChHcHQTdHtH~@HHK@aHH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtHs HAhHp HAxD$P   Hw HH] HC@HChHcHH* HDhHChHcHQTdHtH~@HHK@衪HH\$HHt$XH0_LSH   HǄ$   AC    HYH ICHp ICAC   HHL$ 9k Hn HD$ HSHL$8i Hq HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHH H   H$   HcHǄ       H	 HL$ hQ HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHn HAxD$X   HW HH= HC@HChHcHH
 HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_@SH HD$0    ڢHH [@SH HD$0    :HH [@VM;MHL  II+HW  HH\$Hl$H|$ Ld$(J   I   II+H+L+HLHHMfMtIBHtH3HtH3H@KH
YAAMtIBHtH3HtH3H@HDYAAMtIBHtH3HtH3H@HYAMtIBHtH3HtH3H@I H HHHBD	YAA	Ld$(H|$ Hl$H\$M;}EHMtIBHtH3HtH3H@IM;HBDYBD|^M;  LMK ISSVAUH@IMII+HI{H`  HIkMcMsM{MM+A   HIH+N$   IL+I,ILK4HtHCHtH3HtH3H@I|- H9FM EHtHCHtH3HtH3H@HD9M EHtHCHtH3HtH3H@HB!L E HtHCHtH3HtH3H@HI)L H I IELl$xHT$hL|$ Lt$(Ld$0Hl$`I;}CH:HtHCHtH3HtH3H@H-L HI;D|H|$8H@A]^[H\$M;IML}L
MtIBHtH3HPHtHJ3HtHA3H@L HtH3CYAHtHB3H@IL;HBXDCD|H\$@SH HBLi L[xH [HL$SH0HD$ HD$P    EtH HAhHsi HAxD$P   *Lß LH HC@HChHcHHv HDhHChHcHDd    HH0[H\$WH H茞Lh L_xtHK HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtHC HAhHh HAxD$P   蟗H HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@qHH\$HHt$XH0_LSH   HǄ$   AC    HYH ICHg ICAC   HHL$ 	c Hf HD$ HSHL$8a HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Hĝ HD$ H HD$`H$   HcHHp H   H$   HcHǄ       H	 HL$ DI HL$WH0HD$ H\$HHt$PHH3|$XEtHc HAhHf HAxD$X   oH HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@葠HH\$HHt$PH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHe HAxD$P   诙HG HH- HC@HChHcHH HDhHChHcHQTdHtH~@HHK@џHH\$HHt$XH0_@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HDJD|H|$Ht$M;}%LIPI IHIIM;HJD|[HcAH+HcAH+鄩HcAH+THcAH+HcAH+餸HcAH+DHcAH+ԾHcAH+锷HcAH+餶HcAH+tHATAUAVH  HǄ$   HXHhHpHx IMLLHI IP]    I$IIP      DBH$   \ I$IIPH
ϥ H HEH$   5HH{ &HI\ HHH HI\ HH HH\ H$   H$   >\ HHL$P ^ Ha HD$PHHL$h\ He	 HL$PD I$IIP      DBH$   [ HƤ H$   QHH BHI[ HHd 'HI[ HH9 HH[ H$   H$   Z[ HHL$P<] H` HD$PHHL$h[ H	 HL$PD I$MHT$ IPH$   HT$@LHL$8L+IHF H+FHL;     DBH$   Z H3 H$   >HH /HIZ HHQ HIZ HH΢ LH$   IH H$   ҵ(H$   3HL$@HHT$8H+HHtcHt,H$   ĳHL$@HT$8H+HH;r[ HT$8HH$   1Y HHL$@HHT$8H+HH;r)H$   fH$   H$   Y HHL$Pr[ H
_ HD$PHHL$h/Z H	 HL$P9B 3HM  fD  HF H+FHH;rZ HT$@HL$8HnHH+HH;rZ HT$@HL$8HH9D uHHH+HH;r     DBH$   X HӠ H$   >HH /HIX HHQ HIX HHv HHW HH ޳LH$   Ik	H H$   跳(H$   رHL$@HHT$8H+HHtcHt,H$   諱HL$@HT$8H+HH;rY HT$8HH$   W HHL$@HHT$8H+HH;r)H$   MH$   H$   wW HHL$PYY H\ HD$PHHL$hX H	 HL$P @ Ht? H\$8H\$@H\$HHL$ ? L$  I[ Ik(Is0I{8IA^A]A\H\$Ht$WH HA 3HH+AHHHta     HC H+CHH;rYX HKH94t$HC H+HH;r9X HKH3X HC HH+CHH;rH   Ht"? H   H   H   H   ? H   Ht> H   H   H   H   > H   Ht> HKxH   H   H   > HKHHt> HK0HsHHsPHsX}> HKHto> HHsHs Hs(H\$0Ht$8H _L> H	H%.W H\$Ht$WH@HB LI HH+BL+IHHH L HD$0Hy H
f HD$(IHT$ HG Hs H+GH+sHHHuV HC HH+CHHuV HKLHH\$PHt$XH@_闅H	 HHIH%SV H\$WH Hߝ HHHI%V tH,= HH\$0H _H\$WH HHH;t/HHL_(HWHKL[(	HW0HK0HH\$0H _@SH HHI0U HKU HKH [H%{U @SH HHI(eU HK[U HH [H%LU @SATAUH HZ LJLLHgfffffffLM+IHHH?H   Hl$@Ht$HH|$PL;vT I4$HuT E3LI;[wT HkI\$I;\$ vT I<$HtH;tT H;t`HuT E3LI;[ rvT IMHR Hz H:HuOT E3LI;[ r;T H(IIMHR HR HR H|$PHt$HHl$@H A]A\[@SUAUH HZ LBHHLI+H  Ht$@H|$HLd$PL;vS Hu HuS E3LI;[wS H}LcH;} vvS H] fHtH;t`S I;taHuPS E3LI;{ r<S IMQ Hy HHuS E3LI;{ r S HH2IM\Q HeQ HdQ Ld$PH|$HHt$@H A]][@SH HHIR HH [H%R @SH HHI8Ht9 HK 3HC8HC@HCHn9 LX LH [HL$ATH0HD$ H\$HHt$PH|$XHHٹ   M9 HtH33HHHw H+wHHKHK HK(Ht}HH;v(HKHHCHC HHC(Hw H9wvQ LgL;g vQ HKI+HH    H<
HtLM;Q H{ HH\$HHt$PH|$XH0A\HL$WH0HD$ H\$HHt$PH   V8 3HtH8HHHwHw Hw(H_0   *8 HtHHHHsHs Hs(HH\$HHt$PH0_@SH0HD$ Hٹ   7 3HtHHHHKHK HK(HH0[H\$Hl$Ht$H|$ ATH@Hy0MHH_H{i u#HKIN tH[HH{i tHH^0H|$(HD$ HtH;tO H;tHWIN uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$WH HHIpHt6 HKX3H{pH{xH   g6 HK@HtY6 HK(H{@H{HH{PD6 HH\$0H _H%$N H\$Hl$Ht$WH Hq HH9qvN H{H;{ vN H9{wH;{ vN H+H9swH;s vN HtH;+tN H;t/HC H+HH    H,:H~LLHJN Hk H\$0Hl$8Ht$@H _@SH03MM؈D$(D$@HLIMIHˈD$ 0@H0[HWHpHD$ HXHhHpHHHL HHw H9wvM H_H;_ vM HHD$0H\$8(D$0fD$0H;tfD  HH4L u	H(H;uHwH;w vwM HD$0HtH;tbM H+HgfffffffHHHHH?HHL$@FL HL\$pI[IkIs I_@SH0HD$ Hٹ   44 HD$HHt3HSDIDH蔚LE3Mu3
IChHcHJDhH0[H(LALIHQ II+HH;|
L+II+IHAH	Ht3 H(@SH A   HD$0    HH [HSUVWATAUAVAWH   HǄ$   HE3D`L-n LhLpLxL`pED$H"
 HHL L5s L$   Hy H$   H= H|$pL=P L$   Ǆ$0     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$XgK H{ HD$0Hz HD$XHD$pHcHHz HDpHD$pHcHQTlIH$@  H$   HtRHH$8  P(HH$@  Ht
HHPH$8  HtHP H$8  IEH$8  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP HX HD$@H HD$HD$P   !
 X  
 X   .1 HH$H  HtXHx@LxPǄ$0     HT$0H$Hy HHy HC(HC@HcHHRy HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$H  HT$(HHL$(HH$H  Ht GuHHPGu	HHPLHHL$ SvHD$ H
 HD$(H
 Ht/@H\$(Ht CuHHPCu	HHPH
B 0 H
 HE H
 HEHt@Hrx HD$0HNx HD$XHD$pHcHHx HDpHD$pHcHQTlLt$0H`K H\$XHL$XH Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$   EH L$   H$   HtHP HHH   A_A^A]A\_^][LSUVWATAUAVAWH   HǄ$   HE3EcL-]j MhMpMxMcAsH~Q ICISIKG L5n L$   Hfu H$   H= H|$pL=K L$   Ǆ$@     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$XF Hv HD$0Hv HD$XHD$pHcHHrv HDpHD$pHcHQTlIH$X  H$   HtRHH$H  P(HH$X  Ht
HHPH$H  HtHP H$H  IEH$H  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP H HD$@HH HD$HD$P   
 X  
 X   , HH$   HtXHx@LxPǄ$@     HT$0H
 H[u HH9u HC(HC@HcHHu HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$   HT$(HHL$(HH$   Ht GuHHPGu	HHPLHHL$ qHD$ H
 HD$(H~
 Ht/@H\$(Ht CuHHPCu	HHPH
;= 2, H.
 HE H+
 HEHt@H&t HD$0Ht HD$XHD$pHcHHs HDpHD$pHcHQTlLt$0HF H\$XHL$XC Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$   C L$   H$   HtHP HHH   A_A^A]A\_^][HLH L@HPSUVWATAUAWH@  L$  H$  L$  D)@D)HH$  H$  L$  LHHIDIIMDE3HHH$  HHL$  HLH   IH\$hII+L$  H;HD$pILMHMH,L$HHMuL$  IHL+D$  fEWL$  )$0  H  )$   J    D)$   H$   E3IHKAO<D)$   D)$   D)$   H$   IID)$   D)$   HKܺ@   HD$xI$   Lt$@HD$8KH$  IL|$H\$ HD$(KAIHD$IHD$K@IĀ   HD$hHHL$0HHHD$`ffff     H$  J    H~XH$  H$  IIHJ         fWHfpDHHf)JuH$  HL$0M"  H$  LL$8N    AfDHLIfD)$   IDL$  HIHǀHI+IIIffff     H(3: fD(fD(fD(fD(fD(fD(fD(f(f)D$PA	C
IH7  LEIIf(!fD(Af(f(Pf(X f(h@f(pPf(x`f(fAYfYfDXf(H0fDXf(fAYfYfDXf(Q fDXf(fAYfYfDXf(XpfDXf(fAYfD(D$PfYf(   fDXf(I0fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYf(IPfYf(Q@fDXfDXf(fYfD)D$PfYfDXfD(   f(   fDXf(fYfYfDXf(   fDXf(fYfYfDXfDXf(fYfDXf(Y`f(   f(|$PfYH   f(IpfA(fXHIfYfDYfDXf(fEXfYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDXf)|$PfD($   I;   ML+D  f(!f(if(H f(Pf(X f(fYH@IfYfDXf(HfDXf(fYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDX{f)|$PfAAffZfA(H IfAYfAdfAiftI fzfXfA(H IfAYfA`fAhfA(fXfA(fAYfXfA(fAYfXfA(fAYfXfA(fAYfXfA(fD(D$PfAYfAYfD($   fXfApfTfTf`fhfA`fAhfApfXfAxftftfpfxfApfAxD$  fEWL$  H$  L$L$  H\$ H$  Lt$@H|$p/  L$  IHJ`H	f(Z5 If(f(f(H  HUHH    f(	f( H   H@HfYfXf(fYfXf( fYfXf(0fYf(IfXf(@fYfXf(PfYfXf(`fYfXf(pfYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYfXI;}UIH+ff     f(	f( H@HHfYfXf(@fYfXf(@fYfXf(@fYfXuJAAffJf(f(fYf(fYfXf fYfYfXffXfBff[ffPf	fIfXfB$fBdL$  H$  L;?  H$  H$  L\$H\$H|$(IL4H$  IH$  ILL+$$L<    Ht$Lffffff     A	3IfA(fA(fA(fA(I   MBIIIIJ    fQYHH If(f(Y@YHXXf(Y@YPf(XXQYHXf(f(Y@YHXf(XY@YXXXYf(f(Y@YHXf(XY@YPXf(XY@Xf(YXY@XXI;}BAHH I;f(f(Y@YHXf(XY@YPXX|AYAYAYIHHHMIXffXoAYoXssAX{A{8L$H\$ Lt$@L|$H$   HL$0L$   HT$8HT$HT$HT$(HD$xL$  H$  H$  L$  L$  HHLHl$`H$  H\$ HL$0L|$Lt$@NH\$hD($   D($   D($   D($   D($   D($   ($   H$  H;  H$  HN4    IJ	M<HH$  H$  H+H<JH$  M$H$  HDH$  M~1IHIfW HfpDHHf)IuH$  M   L$  (5m/ HIHAL$  IAfILIIA	f(f(IM~3ID  f(	f( HH HfYfXf(@fYfXufA@f(f(I LIfYfYfXfA@fAPfAPfXfAHfAHiL$L$  H|$p   L$  IL$  HJ@I	f(f. M~)IIH+     f(HHfYAfXuAAffA$fYfXfA$fAL$L$  L$  H$  L;  H,    IIHIHMI+fffff     AE3IfA(|yIRLHOHM+I@HL    fffff     HAH H HYIY@Xf(HX@YIYAXXuM;}(HIKI+I+HHY@XuAYHLHXSS(L$H$  H$  H$  L$  H    MMHH$  IHH$  H$  ($0  L$  L$@  E(CE(KIA_A]A\_^][@WATAUH0HD$ H\$PHt$`HHHH;vIhHIHu3HC(H+HH;   HKLHD$XH{ H9{v1 LkL;k v1 I+HHtH    LMIK1 HKH{ H+HHtu IHC(IHC LcH\$PHt$`H0A]A\_@SH0HD$ Hٹ   T HD$HHt3HSDIDHdLE3Mu3
IChHcHJDhH0[@WH0HD$ H\$@HD$H    X    HHD$PHttHo HG@H5 HGPD$H   HSH
HX` HH6` HG(HG@HcHH` HD9@HG@HcHDADD9<HSHYo3Hu3
HG@HcHHD9@H\$@H0_@WH0HD$ H\$@HD$H    X    HHD$PHttH;n HG@H4 HGPD$H   HSH
H_ HH_ HG(HG@HcHH{_ HD9@HG@HcHDADD9<HSHn3Hu3
HG@HcHHD9@H\$@H0_@SH0HD$ Hٹ   T HD$HHt3HSDIDH$LE3Mu3
IChHcHJDhH0[HH4 3LL$XLD$`3)t$0)|$ D$XD$`51 =oA fTf/vG.  "   x 3LL$XLD$`3҈D$XD$`fTf/v.  "   Px 3LL$XLD$`3҈D$XD$`mfTf/v-  "   x 3LL$XLD$`3҈D$XD$`4fTf/v-  "   w 3LL$XLD$`3҈D$XD$`fTf/vc-  "   w 3LL$XLD$`3҈D$XD$`fTf/v*-  "   (t$0(|$ HH@SH A   HD$0    DHH [@SH A   HD$0    ԋHH [M;  VAUIIMI+LLH  HH\$Hl$ L H|$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAXAAAMtIBHtHH3HtHA3H@HHtH3ADXAAAMtIBHtHH3HtHA3H@HHtH3XAAMtIBHtHH3HtHA3H@HHtH3I)H I HXAAALd$0H|$(Hl$ H\$L;}WIE L MtIBHtHH3HtHA3H@HHtH3BIL;XACD|A]^LAMtI@3H@HHMtI@3H@LXLIHH+HLIHLIIM[  MtI@3IH@fo# Hf(	fT   MtI@3H@   I;Hf(QfT}LMtI@3H@Hf(fTf_MtI@3H@HI;Hf(DfTf_|M;f_~"MtI@3H@HfB(fTf_M;f(f_L$o  d, II+H  ISMtI@3H@HHD$BfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$IL;L$M;}FMtI@3H@HHD$BfTf/D$wHD$IM;L$|f(MtI@3H@*    L;H	fTL$`  ICH  MKMtI@3H@HHD$fTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$HI;L$I;}EMtI@3H@HHD$fTf/D$wHD$HI;L$|f(@SH0HD$ Hٹh   
 HD$HHt3HSDIDHLE3Mu3
ICPHcHJDPH0[@SHPLQL	H)t$0Ap)|$ A8f.=. zuf.5. zO  Hl$pHt$HH|$@D)D$D)$LT$`tM&HHD$`HT$hHHكL;HL$hHMLIDI+3HDHfDH+HII<CfD  ISMIIHL+HCHH4    fYP!H H Hf(f(YY\A\ YYXPPIf(f(YY\YYYXPPAL f(f(YY\YYPPXf(YYIf(YY\XPII;}NIIHH+H+HHf(f(YY\YYXXLuOLT$`AtI&IHD$`HT$hHHكL;HL$hHMH I;utL;  HII+I+HHHH     fA(f(IHHf(f(fAYfAYf\fAYfAYf)XfXfA)Hu  HHHHIL;   HIHI+I+I+HHIhHHfD  fAfm f(f($.f(I H H HfAYfAYf(fAYf\fAYf)RfXf(fAYfAYfAHfMf(fAYfAYfXf\fMf)d.fMoH;tAfAf(f(fAYfAYf(fAYfAYfXf\fAf)fALI;D($D(D$Ht$HHl$po  IH+H  IMITH+L+HDHHHH<fD  ZP"H H Hf(f(YY\A\ YYXPPJf(f(YY\ZYYXPPAL f(f(YY\YYPPXf(YYJf(YY\XPJI;}JL+HL+AHIf(f(YY\YYXXALuH|$@    (t$0(|$ HP[@SH A   HD$0    褐HH [H  HD$ HH$   P3HHL$(H	 HL$(% H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(
fY	   MtI@3H@HMtI@3H@A   M;Hf(RfYQ}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXM  HI+H   HSMtI@3H@HBMtI@3H@HBYXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@IL;HBYDX
L;}AMtI@3H@HBMtI@3H@IL;HBYDX|f(H\$MtI@3H@HMtI@3H@   H;HYA  HCH   LKMtI@3H@HMtI@3H@HYXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HI;HYLXH;}?MtI@3H@HMtI@3H@HH;HYLX|H\$@WHyLYE3LH  
O$ fWH\$fD  3I   I[DRI;uf(f(IIIIHIBI;uf(f(IIIHIM;uf(f(IIIIIIBI;uf(f(IHIIIHH;I_I;}*I;uf(f(IIIIHHI;|IL;H\$_LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHǅ8  )@  MMHU8H  L(L}pHGH  L  LE8H;MMIH]XIIHN,    II;vHHHEHHuL$    I   w6H   HHH;wHHH H+HD$pHHHE1IW HEHuMtGHIL  3H9HDH  H  H    H=     I;vBGHGHE HunH    H   w6H   HHH;wHHH3 H+HD$pHHHE 'H HE HuHtFI3H9_HDH   H(  H    H=   0  M;vFHGHEPHukJ    H   w=J   HHH;w
HHHy H+HD$pHHHEPH HEPHuHtFE3L9WLDL   J    H=   E 3HUE3LE(IIH   IHH   3H}0L  IHM8IL  IHH   53 D  I;  H  HEpL  H9MpIML(L   ML L   I+H   IIHu LL   H~>KMHD$8    HD$0    HL$(Ll$ MIH  謏HULE(3M   HEH   IMIL  H  H~KHMHH  HHNIHMHD$8    Ll$0HHD$(H\$ MHH  9wHHII;HULE(|L  L  Hu H}03HMH  H  J    H   IHH   IHH   LEXIHH   LHUxH  LLUH L  H  LMXM;IMHE3ML   HE(HE`ML   LH   HH   LUhH}M;  Hǅ     LE@H  L]@IINH8H   HEML]@M~`HEPHD$hLt$`Lt$XLl$PLl$Ht$@H|$8Ld$0H\$(LL$ LMMIH  HMH  L]@LUhMH+  H  L4    MFN$    LxMIffffff     H  M(  LLHE`IIH  LH<I+H  I A3H   MAIJHCHHH    @ f(AYHA\Af(Y\f(AYHA\Af(AYA\AH I HuH;}0IMM+HH+f(BY  \ HHuMMIHH   H   MFL]@H  A3H|cIBHSHHH    ffff     @^@H^H ^ H^HH HuH;}A^AHH;|IMML;HML   L  E3HELH  LLd$8L   Ll$0H\$(H|$ MH}HH  vIL   H   HE`L   IH   LUhMLUhL   IL   L   L   L   HMH  wL   M~uH   IHHHEPHD$hLt$`Lt$XHD$PHD$Ht$@LD$8Ll$0H\$(H   HD$ LMH  HMH  LEXIHMLuxL   LuxLUHJ    LLUHH;  Hu H}0]L  HUHUpHUHM8H   HM8LE(L   LE(H   H}0L  L  ^}  tH    0   tH   l    t
H  U (@  HX  A_A^A]A\_^[]M;   Hl$Ht$ WH HH\$0Ld$8L IIHHtHFHtHX3HtHC3HtH3H@H@ HtHC3H@HH;HYDAD|Ld$8H\$0Hl$@Ht$HH _@SH0HD$ Hٹ    HD$HHt3HSDIDHtLE3Mu3
IChHcHJDhH0[@SH0HD$ Hٹ   4 HD$HHt3HSDIDHԓLE3Mu3
IChHcHJDhH0[H\$HYLQE3LH   
| fWE3M~eHtHBHtH3HM;uf(f(HtH3H@(HHH II\IIIKIIM;|IL;|H\$@SH A   HD$0    HH [@SH A   HD$0    褡HH [@SH0HD$ Hٹ    HD$HHt3HSDIDH4LE3Mu3
IChHcHJDhH0[@SH A   HD$0    DHH [LWATAUAVAWHPHD$ I[Is MMLHIKIHIAHAIKI HI@HAICHtI;Ct Ht$8H+t$HHHCHu3H{(H+HH3  LS IH+HHHH+H;sBL1I;  HHH+H;s3HI;IBHKHMcLH$   IMLCI+HH    LL$   HtLH L$   HL$@IHIFHAHL$0IHIGHAHD$HLD$8I+HH    N4HtLIZ HS MEI+HHtHLI6 HKHC H+HHHt] IHC(IHC Lc   HL$@IHIFHAHL$0IHIGHAHT$HLD$8I+HHtHLI
 HK IULH;t!HL;tA HI IL;uHK HLI;t!II;tI HA HI;uHC HH;t HH;tHHHH;uHs L\$PI[8IsHIA_A^A]A\_M;   UVATH H\$@H|$HLl$PL*MIH@ HtHEHtH3HxHtHG3HX	HtHC3HtH3H@H HtHC3H@HYHtHG3H@8HI;HXDADeLl$PH|$HH\$@H A\^]@SH0HD$ Hٹ   T HD$HHt3HSDIDHLE3Mu3
IChHcHJDhH0[LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MMH0  LG(LEHGH0  L0  L   H;MMIHE(HIMLJ    HEII;v6L/HMusH4    H   w2H   HHH;wHHHw H+Ll$pII0H LHuHt6HIE3IH9IDHEHH]PH    H=   EXM;v5HwHulJ    H   w2J   HHH;wHHH H+Ht$pHH)H. HHuHtl5E3IIH HDHE`LehJ    H=   EpHUI;v*5LgMumH    H   w9H   HHH;w
HHH H+Ld$pII#H} LHuHt4HUE3MH MDLE8H    H=   0  IM  HUHH   HHE0(  H   ff     HHUH   LEL;IML0L+LL$8LL$0H\$(Lt$ L  L  HHM RE3MH   H  LE(L  H   HM     K<H}@H   LE@H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM |Ld$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM LHM LE(J    HHM LH   H;A    )L   H   HMHEH  L}0L   L   I;HUmLE80  t
IM }p tHM`< }X t
HMH+ (   H   A_A^A]A\_^[]@SH A   HD$0    褢HH [LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MH0  Lw(Lu HGH0  L0  L   H;MMIHEHIMLIII;v1L/HMusH4    H   w2H   HHH;wHHH H+Ll$pII0H LHuHt%1HIE3IH9IDHEHH]PH    H=   EXM;v0HwHulJ    H   w2J   HHH;wHHH H+Ht$pHH&H9 HHuHtw0IE3IH HDHE`LehJ    H=   EpM;v90LgMuiJ    H   w9J   HHH;w
HHH' H+Ld$pIIH LHuHt/E3IH IDHU0J    H=   0  IL   M  HU HH   HHE@HL  IHHE8(  H   HHUH   LUL;IML0L+L\$8L\$0H\$(Lt$ L  HHM yE3MH   H   LEL  H   HME3K<H}(H   LE(H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM wLd$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM żLHMLEJ    HHMLH   H;,L   H   HMHE8H  L}@L   L   I;HU L  A    oHU00  t
HO }p tHM`> }X t
HMH- (   H   A_A^A]A\_^[]H\$M;IML}uL
MtICHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CD|H\$@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHDIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HD JD|H|$Ht$M;}&LIPI IHIIM;HDJD|[H\$M;IML   HL MtIBHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CXDCD|H\$HcAH+HcAH+HcAH+HcAH+锯HcAH+dHcAH+THcAH+HcAH+HcAH+HcAH+D@WH0HD$ H\$PH3|$HO[ HtHHHH{H{ H{(HH\$PH0_HL$VWATH0HD$ H\$XHl$`HH6H HHc3IuH,I;v*H,    H HuHt)HGH_HuH,I;v)H,    Ha HuHt)HGH_ Hw(Ht/I;v)H,    H$ HHuHtb)Hw0H_8HH\$XHl$`H0A\_^  H\$Hl$VH0LI HqHMHgfffffffHL+IHHH?HH;wx0H|$@I;vw HHt$(3H\$ (D$ fD$ HuR LLHD H4I;s wHtHHH;ps" HD$ Hu H8H;w H|$@r H\$HHl$PHH0^HL$WATAUAVAWH0HD$ H\$hHl$pHt$xLHHF HHZH3HuH6H;v'H<    H HuHt'HHFH^I\$ HuH,H;v'H<    H3 HuHtt'HFH^ ID$(HF(I|$8Ht9HH;vD'H    H HHuHt 'Hn0H~8IT$HN<IT$HN<IT$0HN0<HH\$hHl$pHt$xH0A_A^A]A\_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH薥t,HL$@Ht Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_H\$WH0MM@E3LMtGIHH      fffff     IcD$PHD$PH#H;w0IM;r݋A(L
D HC IˉD$ `H\$@H0_H HC MHD$(H` IHD$ kH\$Hl$Ht$WH@I@MHHHD$0H-C H2 IHH1 LHHl$(HD$ LLHH;L_DC(L
C HpC HL\$ RLHHH\$PHl$XHt$`H@_	ALWH   HD$ I[IkIsHHHIHB H+BHH;tYHC IK HL$P H HD$PHT$(HL$h H HD$PHc	 HL$P HGH9Gr`3HtYfff     HG@H+G8HH;r Hw8HE H+EHH;r HEXHH;_rHGL$   I[IkIs I_H\$WH HHI8Ht HK 3HC8HC@HCH LM L@tH HH\$0H _HL$ATH0HD$ H\$HHt$PH|$XHHٹ   m HtH33HHHw H+wHHKHK HK(Ht}H?H;vH*HKHJHCHC HHC(Hw H9wv LgL;g v HKI+HH    H<
HtLM[ H{ HH\$HHt$PH|$XH0A\Ht$WH HHH;  HR LFHI+HHuHHt$8H _LQLI M+II;wBI+HH~HIL HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHM藵LO LF HHĵH\$0HG HHt$8H _MtI| HV HH+VHLtLOLF HVHtHG HHt$8H _I;t,H\$WH IHH H(H;uH\$0H _H\$WH HYHHt.Ht$0Hq H;tH H(H;uHO Ht$0H\$83HGHG HG(H _@WATAUAVAWH@HD$ H\$xH$   )t$0MILHHAHu3HY(H+HM  La IH+HHHH+I;sb'LI;   HHH+H;s3HI;IBHNHGLHD$pM~L+~IJHfHtIE HHHIVLFI+HHtHLIO HV MFI?II+HHtHL& HNHF H+HHHtM IHF(IHF Lf   II+FHH;swA1IVLMH谲HV HI+FHHH+Ht
2HHH    HF HN H+IFH;tjffff     0HH;uOA1HIH+MMHH1HF MHIN޲M^I;L;tA3IL;uH\$xH$   (t$0H@A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMu3Igfffffff(HI(I+IgfffffffIHHHHH?HM?  MD$ II+IHHHH?HHfffffffHH+H;s$L2I;^  HHH+H;s3HI;IBHIL$}DHHD$8IMI+L$IHLIIH?LL|$@D$0    KH3D$($   D$ ML$L$   H	>D$0   3D$($   D$ ML$LIUIL$	D$0   I7LN3D$($   D$ ML$IT$ IMML$IL$ I+IHHHH?HHMtMD$ IIIL$8 HHIL$(HHIL$ I|$  M+EIIHHH?HH;   IHL$P HH    IML3D$($   D$ ML$IT$ MT$ II+MIHHHH?HH+3D$($   D$ ML$LD$PHI<I\$ I|$ H+I]H;tHT$PH H(H;uHL$P    IHL$P I|$ HH4    HH+3ML$D$($   D$ LHH.ID$ 3D$($   D$ D$   LHIM?<I]H<3H;tfHT$PH H(H;uHL$Pn HĀ   A_A^A]A\_^[@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HHHH+I;s*!LI;   HHH+H;s3HI;IBHNHALHD$`M~L+~IJHHtIE HHHIVLFI+HHtHLI HV MFI?II+HHtHL HNHF H+HHHt IHF(IHF Lf   II+FHH;spIIVLMH|HV HI+FHHH+fD  HtHHHH    HF HN H+IFH;t_ HHH;uNM!HIH+MMHHHF MHIN豬M^I;L;t@ M#IL;uH\$hHt$pH0A_A^A]A\_@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HH?HH+I;sLI;   HHH+H;s3HI;IBHNH?LHD$`M~L+~IJHHtAE HHIVLFI+HHtHLI HV MFI?II+HHtHL HNHF H+HHHt IHF(IHF Lf   II+FHH;spAIVLMH譪HV HI+FHHH+    HtHHH    HF HN H+IFH;t`@ HH;uOE!HIH+MMHH5HF MHIN袪M^I;L;tD  E#IL;uH\$hHt$pH0A_A^A]A\_HL$SH0HD$ HH    H    HKXm HKHb HK8W HK(L HKA HKH0[H%0 H\$Hl$Ht$WH HY HH9Yv HwH;w v H9wwH;w v H/H9_wH;_ v HtH;/t H;t2HO HH+HHH;tH+ HHHDH;uHW H\$0Hl$8Ht$@H _DD$SVAUH0Hq HHIHLH+HH;sPH;v+ HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MH0A]^[H;   Hl$PH|$XLd$hH;v H{H;{ v H+E3Hu ML] J<I;{ wHtLe I;|$sy Ld$hH9{wH;{ vb H+H9swH;s vM HtH;+t= H;t/HC H+HH    H,:H~LLH Hk Hl$PH|$XH0A]^[HL$WH@HD$ H\$XHt$`IHHHI^H_8H_@    3HtHHHHsHs Hs(H_p    HtHHHHsHs Hs(H   HH\$XHt$`H@_HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H    H   H   H   H-C6?H   H?H   H-q=H   HMbP?H   Hǃ   '  H      ?H  H:0yE>H   H  H   H     @H  H     @@H(  HH\$HH0_HL$WH0HD$ H\$HHl$PHt$XIHHH2 HRHL. L]H
 HEHH}XH HEPHu`HuhH 
   >HEpH?HExH   Hǅ       HH\$HHl$PHt$XH0_HAHH`f/
0 vIxf/
 v f/v   HWH`  HD$ HX)pHHٺ   DBHL$P sxHE1 HL$`:Hf( HT$(HL$P LHHAHL$(} HKHHPHL$P H$p  ($P  H`  _H\$WH H HHAPHI8 HO 
 HO  Li LtH HH\$0H _HT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$Pte HL$HH+L$XIgfffffffIHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHfffffffHH+I;s.N"I;\  HHH+H;s3HI;IBHHN4HH$   H$   3D$($   D$ LNLH$   HRHNLH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$HLH$   3D$($   D$ LNHV H$   HH;LF LNII+HgfffffffHHHH?HLMtIHnHN HHHN(KHHN H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$H&H^ I}H;tH(H;tHHd H(H;uKL$    H^ I<H;t fH(H;tHH+ H(H;uHF II}H;tH(H;tHH H(H;uLf H`A_A^A]A\_^[H  HD$ HH$   0HHL$(HQ	 HL$(U H  HD$ HH$   7HHL$(HcT	 HL$( @SH HJHHt H3HCHC HC(H [ HI H% HIH% H   HD$ HH$   AHHL$(HsT	 HL$(u LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHH蹈H0H\$`H0HH0_^[M;   H\$H|$IMHI+HH   HLHII+ODL+HJTHHMf     HBA@H I@I HBHBADIDBHBAHI@JHBA@I@BuM;}0HHL JL+M+HAHIIDBuH\$H|$H   H% HIPH% H   H% @WH  HD$pH$  HHĦ HHEH=ަ HHEHL$HL HԦ HL$ 9 A   E3H| HL$H% HH
# H;tTffffff     L
a A   HHL$H LCA   H( HL$H HH H;uHT$HHL$  H_ HL$  HHL$  H$    Hd H$   HT$ H$    HY H$   H$   H$@  $^HH$   cH,S	 H$   S H  HD$ HH$   0HHL$(HcT	 HL$( H\$Hl$Ht$H|$ ATH`H$   MHHHuHAHxHQLAHFHHJIHLI IHILHLH$   IHD$XHF HD$PHBHD$HHD$@I@LCL\$8HD$0HCLT$(HD$ ?L\$`I[IkIs I{(IA\HWH   HǄ$   HXHpIHH HHEH= HHEHL$p HHL$H H HL$ r A   E3H HL$p^ HH
\ H;tM    L
 A   HHL$p= LGA   H HL$p HH H;8uHT$pHL$  H HL$  HH$   H$   H$   HC$   3HHHHqDHE3HI HL$H HH H;tE LA   HHL$Hq L7A   H HL$HE HHC H;8uHT$HHL$  H$   ` H H$   HT$ H$    H5 H$   H$   H$  hkHH$  HpP	 H$   M;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBuHIpH% H\$WH H   HH+   Hu$HOxHHO`H   HH+   HtHAH   H   xHHOpH   HH+   HtHAH   H   AHHOhH   HH+   HtHAH   H\$0H _HWH   HD$ HXHhHp IHH3hHIHIP t!HNHLHT$XP(   $   HNHLHT$(P(   $   HHt,HL$@Ht8 Hl$@Hl$HHl$PHL$( t0HL$pHt
 Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH~t,HL$@Ht( Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$X޷ HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP0   $   HNHLHT$(P0   $   HH}t,HL$@Ht Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$Xζ HHL$   I[Ik Is(I_Ht$WH HHH;  HR LFHI+HHu  HHt$8H _LQLI M+II;wBI+HH~HIL HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHMGLO LF HHtH\$0HG HHt$8H _MtI謵 HV HH+VHtLOLF HVH$HG HHt$8H _HL$WATAUH@HD$0H\$hHt$xHHٹ   _ HtHE3E3IHHO H+OHgfffffffHHHHH?HLCLC LC(t{HfffffffH;v!HHK$HCHC HHHC(Hw H9wv LgL;g v 3D$(D$pD$ LKLCHInHC HH\$hHt$xH@A]A\_HL$WH0HD$ H\$HHt$PHHYHt$Hq H;tH H(H;uHO 3HGHG HG(HH\$HHt$PH0_ H\$Hl$Ht$WH Hq HH9qv H{H;{ v H9{wH;{ vw H+H9swH;s vb HtH;+tR H;t/HC H+HH    H,:H~LLH Hk H\$0Hl$8Ht$@H _@SH HHx  D$0    HHH [@SH HH  D$0    H`HH [LD$SVAUH0Hq HHIHLH+HH;sPH;vk HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MH0A]^[H;   Hl$PH|$XLd$hH;v H{H;{ v H+E3Hu ML] J<I;{ wHtLe I;|$s Ld$hH9{wH;{ v H+H9swH;s v HtH;+t} H;t/HC H+HH    H,:H~LLH% Hk Hl$PH|$XH0A]^[T$SVAUH0Hq HHIHLH+HH;sPH;v HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+M>H0A]^[H;   Hl$PH|$XLd$hH;v H{H;{ v H+E3Huq ML] J<I;{ wHtLe I;|$sH Ld$hH9{wH;{ v1 H+H9swH;s v HtH;+t H;t/HC H+HH    H,:H~LLH Hk Hl$PH|$XH0A]^[H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;vn IE HtH;tZ I}I+HIE HL$ HT$ HIEMHAHA   LcL;c v HLd$(H\$ (D$ fD$ Hu LLI<I;{ wHtH3H;~s H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\H\$Hl$Ht$H|$ ATAUAVH0LHHI H{IgfffffffLL+I3MIIHHH?HuH=H;v& HM HtH;t HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k v HHl$(H\$ (D$ fD$ Hu LLHH| I;{ wHtH3H;~sl H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtSHH;vCH	LHFHF HHN(HHHtHHHHIHF H\$HHt$PH0_H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v> IE HtH;t* I}I+HIE HL$ HT$ HIEMHAHA   LcL;c v HLd$(H\$ (D$ fD$ Hu LLI<I;{ wHtH3H;~s H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HL$WATAUH@HD$0H\$hHt$pMHH3HAHA HA(HtZHH;voH5HHCHC HHK(3D$(L$`L$ LKMHHqHHC H\$hHt$pH@A]A\_HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtQH?H;vHLHFHF HHN(HHHt
HHIHF H\$HHt$PH0_H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v IE HtH;t I}I+HIE HL$ HT$ HIEMHAHA   LcL;c ve HLd$(H\$ (D$ fD$ HuB LLI<I;{ wHtH3H;~s H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HE3LBHLJLJHDL$3H
LBD$HBHBH@SH HH0  
HH [ATAUAVH@HD$0H\$`Ht$pH|$xHHHH;vHIHu3HC(H+HH;   HK9LHD$hH{ H9{v LkL;k v 3D$(D$hD$ LKMHIRHKH{ H+HHt§ IHC(IHC LcH\$`Ht$pH|$xH@A^A]A\f/
` v%      Ix^,;L   HHHWH@  HD$ HXHH@       DBHL$@+    HL$(" HL$PHcQHLPHPHL$P7 HHL$@ Ǆ$`     HL$@ HH$X  H@  _M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBXDCD|HAHH f/
 v f/v   f/
 v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$P    H HL$` Hf( HT$(HL$Ps LHHAHL$( HKHHPHL$PI H$p  ($P  H`  _f/
 v   f/
 v f/v   f/
p v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$PB    H
 HL$`Hf([ HT$(HL$P# LHHAHL$(ʻ HKHHPHL$P H$p  ($P  H`  _f/
p v   H\$WH H HHH( HA`HIH: HO80 HO & HO L LtH HH\$0H _H\$WH H HHH HA`HIH HO8 HO  HO L LtH虢 HH\$0H _H\$WH Hw HHHx HAhHIH: HO80 HO & HO L LtH HH\$0H _LL$ WATAUAVAWH@HD$0H\$xH$   ILLHAHu3HY(H+HM*  Lq IH+HHHH+I;sLI;   HHH+H;s3HI;IBHIL$`HHD$pMuM+t$IJ3D$(D$pD$ ML$L$   H蓑3D$(D$pD$ ML$LIUIL$KI6L3D$(D$pD$ ML$IT$ IMKIL$ID$ H+HHHt衠 HID$(HID$ I|$  II+EHH;   IH\$pH<    IML93D$(D$pD$ ML$IKIL$ HI+EHH+3D$(D$pD$ ML$LD$pH茐I|$ IL$ H+IEH;tqD  HHH;u^I3HIH+ML$D$(D$pD$ MIHJID$ MHIM	M]I3L;tfIIL;uH\$xH$   H@A_A^A]A\_H   HD$ HfffffffH;vSH HL$( HL$PC H3 HD$PHT$(HL$h H^ HD$PHL$PHu3	H(HĘ   HXHD$ HD HL$( LҼ L\$(Hn
 HD$@HJ
 HD$HHL$(H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HHH0H;uH\$0Ht$@HHl$8H _LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHHYdHH0H\$`H@_^[E3DL$HtHIHAHBHAHBLBLJ LJ(HH\$WH   Hy HHrHIHH@D$@)D$8(H<Hr LHD$0Hr L
d HD$(Hc HHL$hH|$pHL$PHD$ H|$X u8HL$PH#tG<et<Et<-t<+u2H$   HĀ   _ðH$   HĀ   _HWH   HD$ HXHpHHHyHC H+CHH;ruHj
 HL$h HL$([ H HD$(HT$hHL$@ HT$(H$   kH
 HHPH
X HHX@`   H蕔HGHAHC H+CHH;r HCHHHL$   I[IsI_@WH   HD$ H$  HHyHC H+CHH;ruH HL$h, HL$(p H HD$(HT$hHL$@+ HT$(H$   H
p HHPH
m HHX@`   H誓HGHAHC H+CHH;r HCH$  H   _LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHHH0H\$`H0HH0_^[E3DL$HtHIHAHBHAHBI HBLJ LJ(LJ0H3H
LBD$HBHBHB HH\$Hl$VWATH0Hq A LD$PHH9qv H{H;{ v H9{wH;{ v{ H+H9swH;s vf HtH;+tV H;t/HC H+HH    H,:H~LLH Hk H{H;{ v HH|$(LL$PHD$ HT$ M(D$ HfD$ eH\$XHl$`H0A\_^HWH   HǄ$   HXHpIHH$[ HHEH=>[ HHEHL$pt HHL$He HU[ HL$ R A   E3HS HL$p> HH
< H;tM    L
y A   HHL$p LGA   H`S HL$p HH H;8uHT$pHL$ ­ HX HL$  HH$   H$   H$   HC$   3HHHHqDHE3HyZ HL$Hj HHh H;tE LA   HHL$HQ L7A   H4Z HL$H% HH# H;8uHT$HHL$  H$   @ H0 H$   HT$ H$    H% H$   H$   H$  x5HH$  觡H)	 H$  ǖ @WH  HD$pH$  HH` HHEH=a HHEHL$H< Ha HL$ ) A   E3HDY HL$H HH
 H;tTffffff     L
I A   HHL$H LCA   HX HL$H HH H;uHT$HHL$  HX HL$  HHL$ z H$    HT H$   HT$ H$   q HI H$   H$   H$@  4HH$   SH)	 H$   C LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCISHxHWH   HǄ$   HXHpIHHti HHEH=i HHEHL$p$ HHL$H Hi HL$  A   E3HM[ HL$p HH
 H;tM    L
1 A   HHL$pͫ LGA   H [ HL$p HH H;8uHT$pHL$ r HZ HL$ h HH$   hH$   H$   HC$   3HHHHqDHE3H[ HL$H HH H;tE LA   HHL$H L7A   H\[ HL$Hժ HHӪ H;8uHT$HHL$  H$    H H$   HT$ H$    Hծ H$   H$   H$  (1HH$  WH%	 H$  w E3DL$MtIMHHHAHBHAHBHAHBHA HB I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhI@HHBpI@PHBxL   L   HLIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCISHxHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHLJPLJXHHE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhI@(HBpI@0HBxI@8H   I@@H   L   L   HH;   HH$LLH	HI H
ML;tIHIHIQMPL;tI
HIH
IQ MP L;tI
HIH
I(I(M;tIII I	H@VATHH1
M LHHT$0L@HHHD$ L;LD$ HL$0HME3L I  H\$(Hl$8H<$H>Il$MtIAHtH3HWLHIHtH3H@f(HHH HI^AXAMtIAHtH3LIXLSIHWIHtH3H@f(HHH II^DAXDADMtIAHtH3LHHWIHtH3H@f(HHH HI^DAXDADMtIAHtH3LLSIHWIHtH3H@f(HHH IIIL;^DAXDADH<$Hl$8H\$(M;}aLMtIAHtH3ISMHIHtH3H@f(HHH HIIM;^AXA|HA\^LAMtI@3LX8IHH+HLIHHHHM~  MtI@3H@0f MtI@3IH@ffY   MtI@3H@0f@MtI@3H@   H;fXfY}sMtI@3H@0fMtI@3H@ffYfXMtI@3H@0fLMtI@3H@HH;fDfYfX|L;fX~4MtI@3H@0fMtI@3H@ffYfXM;f(fXB  II+H   MJ   M+IIIOMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0Y
XMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(MtIH3MtI@3H@HI0A   M;Y?  ICH   MSAQIIN   D  MtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0YXMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(LATH   HD$`I[IkIsI{ A)sHHHyH (  H   HYH{   qAY0HWHMHEE3McMcMcICIKISMCISIK L$   IH$   H$   IH$   H$   J    H$   HFHPHFHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLG辜HL$p HL$x H$   q L$   I[IkIs I{(A(sIA\H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3@^A@MtIJHtH3@^A@MtIJHtH3 ^A MtIJHtH3@H H^A@dM;}:HM+HJMtIJHtH3 HI^A@uH\$HE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA(HB(I HB0I@HB8I@HB@I@HBHI@ HBPLJXLJ`LJhHHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA HB HA(HB(HA0HB0I HB8I@HB@I@HBHLJXLJ`LJhHLATH   HD$`I[IkIsI{ A)sHHH9H "  H   HYH{   A0HWHMHEE3McMcMcICIKISMCISIK+L$   IH$   H$   IH$   H$   J    H$   HFHPHHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLGHL$pћ HL$xƛ H$    L$   I[IkIs I{(A(sIA\HLE3LMSI   IH\$H<$IzAXHfffff     III8H IIHKXBBII8IHXBBII8IHKHXBBII8L;IXBB|H<$H\$M;}-IJII8IHIIM;XBB|H@VLE3LIsH  H\$Hl$AZH|$ Hn{MtI@HtH3IS8MIHtHH33AH@L8YI(\AMtI@HtH3MHSIS8HtHH33AH@L8YI(\AMtI@HtH3MHIS8HtHH33AH@8YI(\AMtI@HtH3MHSIS8HtHH33AH@IH HL;L8YI(\AH|$ Hl$H\$L;}YMtI@HtH3IK8MIHtHH33AH@IL;BLYJ(\A|^M;   H\$H|$IMHI+HH|wLHILI+KTHM+KDHHMBH H HX@@ALXHHBX@@JXHHuM;},HHHH+M+JHIX@@uH\$H|$ATM;MML  II+H  HH\$Hl$L Ht$ H|$(N   IHI+ھ   HHI+I+HI+KHMD  HtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3H@BAYH(\HtHAHtH3HtHL3E3BH@H HI HLAYH(\BH|$(Ht$ Hl$H\$M;}VI$L HtHAHtH3HtHH33CH@IM;BLYJ(\CD|A\M;L}yHLfMtIBHtH3HHHtHA3H	tHH33H@BYJ(HtH3CYI8IM;\CD|HWH   HD$0HXHhHp HHHIHP8   { 3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP8H_ H9_vf HHD$`H\$hH$   HH$   H;v; H$   H$   HL$pHL$@Ht$HH;v HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`HH$   Ht2H$   H;t H H(H;uH$   Hz H$   H$   H$   HL$pxz L$   I[Ik Is(I_HWH   HD$0HXHhHp HHHIHP@   Fz 3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP@H_ H9_v HHD$`H\$hH$   HH$   H;v H$   H$   HL$pHL$@Ht$HH;va HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`H>H$   Ht2H$   H;t H H(H;uH$   Hx H$   H$   H$   HL$px L$   I[Ik Is(I_@SH Hc HHHI(Htx HK3HC(HC0HC8H [ox H\$WH H HًHHI(HtEx HK3HC(HC0HC8.x @tH x HH\$0H _H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;v HH|$(LD$ HD$ HT$0L(D$ HfD$ H\$PHt$XH@_H\$Ht$WHPLAHHIgfffffffMuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ L_(L[ H\$hHt$pHP_L;v HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_H\$Hl$Ht$ WH0Hq HH9qv H_H;_ v	 H9_wH;_ v H/H9wwH;w v HtH;/tҎ H;tIDL$@HW 3D$(D$@LHΈD$ 9Hw HHH;tH H(H;uHo H\$HHl$PHt$XH0_H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;v HH|$(LD$ HD$ HT$0L(D$ HfD$ 9H\$PHt$XH@_HL@VWATAUAVHPHD$0HXHh MLHHq HILL+HgfffffffHIHHH?HI;sZH;vG HHL$@Ht$H(D$@fD$@HO H+OHHHHH?HL+MMHT$@Hݝ   L;   H;v H_H;_ vԌ H/E3HuÌ ML] KD HI;[ wHtLe I;\$s H9_wH;_ v H/H9wwH;w vn HtH;/t^ H;tO3D$($   D$ D$   LHW HHHw HH;tH' H(H;uHo IL\$PI[8IkHIA^A]A\_^H% @WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH H(H|$`HS(HI9HSXHO0;9D$h   Ɔ    HH\$HHt$PH0_@WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH' H(H|$`HS(H虖HSXHO08D$h   Ɔ    HH\$HHt$PH0_LATAUAVH  HD$`I[IkIsI{ IM3HJ H+JHgfffffffHLIIH?LII I+II*IHHHH?HL;  UDEIx^ HO H+OIHHHHH?HH H$   HH HH HHm HIl HHN HT$hH$    HHL$ ̉ H HD$ HHL$8 Hь HD$ HT$ H$  rH
 HHPH
? HHX@`?   H̬HMtSHHO H+OIHHHH?HH;r HGHHL$h6HHHH0I;rI] I+]HH;      DBH$   ܆ Hd H$   oHH3 HH1 THH HH 9HT$hH$    HHL$ x Hh HD$ HHL$85 H} HD$ HT$ H$  H
f HHPH
 HHX@`I   HxL$  I[ Ik(Is0I{8IA^A]A\@SWAWH`HLE3H34LGǄ$       Mu3HW(I+HH_ HI+HH;sHC    HG =L;vC HH\$(L$   HD$ LD$ HT$0(D$ fD$ HIO H*I+OHHHHH?HH/  H$   Ht$XLd$PLl$HLt$@E3E3L$       HG H+GHL;r IO LgHI+OHHHH?HL;rn Io3۾   IL- I+L-HHt)H;rE ID-IL- HH+HtH;rH$   HWB DD$   Hu3HO(H+HH_ HH+HH;sHCDHG    H;vɅ HO HoH7HHt$ H\$(H+Hu3"H;v HtH;7t H+H(D$ L$   HT$0A   HfD$0jHoH;o vJ H7Hu< E3LHL I;K wHtH3H;Hs IO H$   II+OH*I0HHHHH?HIFH;Lt$@Ll$HLd$PHt$XH$   H`A__[HHHz HL$(HT$0u	fWHHHT$PHL$ HH@SH H; HHHޑ HAPHI8@ HK 6 HK, L LH [@SH H; HHH HAPHI8 HK  HK܃ LE LH [@SH H{ HHH HA`HIH HK8 HK  HK L LH [@SH H HHH. HA`HIH@ HK86 HK , HK" L LH [@SH H HHH HAhHIH HK8ւ HK ̂ HK L+ LH [@SH H HHH HAhHIH HK8v HK l HKb Lˊ LH [@SH H" H      ?   Hǃ       ^CxH   ,;L   H HHH [H\$WH HH   HHH   HH   HH\$0H _HHHz  HBHD$(ufWY  HHHT$XHL$ |Y HH@SH H"E3H     @@ǃ      D   H   H D   HD   L   HH [H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v^ HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hofn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;vT HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HeH   HH\$XHl$`Ht$hH@_H\$VH@Iy IHH\$0LD$(tPHT$`HL$ f/ v7H{ Ht$(H\$0t&HT$`HL$ f/ v
H\$PH@^2H\$PH@^@SHPHD$ HH HL$(L} HT$(HHL$(R} H HL$( } HT$(HHL$(&} Ho HL$(| HT$(HHL$(| HP[H\$WH HH   HHH   HH   HH\$0H _@SHPHD$ HH HL$(\| HT$(HHL$(b| HS HL$(0| HT$(HHL$(6| H HL$(| HT$(HHL$(
| H HL$({ HT$(HHL$({ H' HL$({ HT$(HnHL$({ HP[H\$Hl$Ht$ WH@HH   HHwLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v| HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hfn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;v{ HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H虲   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v{ HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HH   HH\$XHl$`Ht$hH@_H\$WH HH   HHH   HH   HH\$0H _yH\$WHPHz8 HB)t$@HD$(HB0HHHD$0ufWHT$`HL$ ]f(HHHH\$hY \(t$@HP_H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;vny HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hfn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;vx HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;vdx HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HuH   HH\$XHl$`Ht$hH@_"@SH H 3H      ?   ^CxH   H   ,;L      H
 H   H      ?H   H   H   H?H   H      ?H   H   H      $@H   H   H HH H   HH [H\$WHP)t$@)|$0= f/HHD)D$ DADXDAvf(q(f(fA(XA@\^f(Y\YAXfA(qN] K8Ys ^C0fW
3 \fA(] \YY{Xf({\ H\$`(t$@(|$0D(D$ HP_@SH A(HA \ CH [@SH H HH   H HH HAPHI8u HK u HKu L7~ LH [@SH H蒓ǃ      E3H     @@H   D   D   D   L   D   H L   L   H   H      ?L   H   H   H?H   H      ?H   H      $@H   H HH H   HH [@SH A(HA ;[ CH [@SH H{ HH   H HH HAPHI8rt HK ht HK^t L| LH [HL$SH0HD$ HH HH H   Hx  
t Hh   t H  r H HH HC`HKHs HK8s HK s HKs L| LH0[M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OA^AAXAAAMtIBHtHH3HtHA3H@HHtH3AD^AAXAAAMtIBHtHH3HtHA3H@HHtH3^AAXAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;^ACXDCD|A]_H\$M;IML   HL MtIBHtH3HPHtHJ3HtHA3H@L HtHA3H@HBC\HtHB3H@IL;HBYDCXDCDpH\$M;L   LMtIBHtH3HHHtHA3H!tHP3J HtH3YH(HtH3H	tHA3H@HHtH3BIM;YAXCDgHL$SH0HD$ HH HH H   H  o Hp  o H   n H HHa} HC`HKHso HK8io HK _o HKUo Lw LH0[HL$SH0HD$ HH HH H   H  n Hp  n H   m H{ HH} HChHKHn HK8n HK n HKn Lw LH0[M;
  VAUIIMI+LLH  HH\$Hl$ H|$(Ld$0HI+   IHJ   H+HL+LHMMtIBHtHH3HtHA3H@HHtH3OA^AAAMtIBHtHH3HtHA3H@HHtH3AD^AAAMtIBHtHH3HtHA3H@HHtH3^AAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAALd$0H|$(Hl$ H\$L;}TME MtIBHtHH3HtHA3H@HHtH3BIL;^ACD|A]^HM;ML   H$HfD  MtIBHtH3HPHtHJ3H	tHA3H@LHtHA3H@HBC\HtH3YB(IM;BD|H$HHI(H%k H\$Ht$H|$HqHYE3LHH   _t fWfff     E3H   @ MtICHtH3HtHH3H!M;uf(f(HtH3YI(HtHH3H	tHA3H@HPL IIHtH3AHIHOAYIXIL;SIL;7H\$Ht$H|$E3DL$HtHIHHHAHBHAHBHAHBI HB LJ(LJ0LJ8HHL$SH0HD$ HH{ HHY H   H  i Hx  i H(  h H HHx HChHKHi HK8i HK i HKi Lr LH0[H\$WH HW HHHv HAPHI8Zi HO Pi HOFi Lq LtHCP HH\$0H _H\$WH H7 HHHv HAPHI8h HO h HOh L?q LtHO HH\$0H _H\$WH H HH   Hd HH
v HAPHI8lh HO bh HOXh Lp LtHUO HH\$0H _H\$WH H HH   H4 HHu HAPHI8g HO g HOg LAp LtHN HH\$0H _H\$WH HLtHN HH\$0H _H\$WH H|tHkN HH\$0H _H\$WH HtH;N HH\$0H _H\$WH HtHN HH\$0H _H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;vf IE HtH;tzf I}I+HIE HL$ HT$ HIEMHAHA   eLcL;c v5f HLd$(H\$ (D$ fD$ Huf LLI<I;{ wHtH3H;~se H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HWATAUH   HD$ HXHhHp)pL   L Ht
HL$PH3HD$P3H\$h3HL$p3HT$xI9U u3I}HQ  Hu3H+HHH+HH;sHHHHL$pH\$h   HH;vd HL$pH\$hHl$PHl$0Ht$8HH+Hu3$H;vd HtH;l$Ptd H+H(D$0fD$@LA   HT$@HL$PsH\$hLHL$pH;vid HL$pH\$hHl$PHuOd E3HL$pH\$hHD$PLII;S wHtHE 3H;Psd HL$pH\$hHI;}uI} I;}tHt
HT$xLL+IIHH;vc HL$pH\$hHH;vc HL$pH\$hHl$PHuc E3HL$pH\$hHD$PLJ4I;s wHtHE 3H;psac HL$pH\$hH;vLc HH+HH=   ~Eff     LHHL$0`cL\$8L;wI
H|$0H;v HH+HH=   E3HHWuHD$pHL$hH+HL;rb HL$hB4HtI HD$h    HD$p    HD$x    HL$PI f(L$   I[ Ik(Is0A(sIA]A\_LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHHmHH0H\$`H@_^[@SH03MM؈D$(D$@HLIMIHˈD$ 萆H0[@SH@Hy` HAXHHD$(ufW>H YCxH@[HT$PHL$ H YCxH@[@SHPHy )t$@qhHAHHHD$(HAfT53d HD$0t$hufWHT$`HL$ aH8  f/wHD$h^ (t$@fWs HP[@SHPHy )t$@qhHAHHHD$(HAfT5c HD$0t$hufWHT$`HL$ H  f/wHD$h^ (t$@fWs HP[@SH HHIe` HKH [H%U` H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HHSH0H;uH\$0Ht$@HHl$8H _HVWATAUAVH   HD$ HXHh)pIHH3IMuH,M;vЍN$    In_ HuMt词HD$8H|$@HuH,I;v萍L$    I._ HuMtoHD$(H|$0H   LuLNLL+A   L+A   L+IL+LGIIJ    fffff     KT
 INHD$8HIAHHHD$(HK
HD$8HLIHHHD$(HLKINHD$8HIAHHHD$(HAKHD$8IA@HD$(I I IdH;s0H+H)HD$8HHHD$(HH;rHD$8HD$PHD$(HD$XH|$0 ufWH$   HL$Hf(HL$(] HL$8] f(L$   I[0Ik8(t$pIA^A]A\_^LWH   HǄ$   I[IsHISHHHAHBHAHBHAHBHA HB HyH^HF3HL$@IKIKI[ICI{MCISIKLL\$hIHD$XHD$pIHD$`HD$xJ    H$   HF HL$@HL$0HD$(HHD$ L$   L$   HH%BHL$@q\ HL$Hf\ HL$PL$   I[IsI_H%F\ H(f(f(fT
_ f/
n vGf/
n r+f/d vH? H
) Kw H(ZB \d H(n f/v	f(H(% l f(Yf(f(Y4 Y
T X
< \f(Yt YYXT YX8 YXf(Yܿ \%̿ \YY\ YY- XXc ^Xf(H(H@H   )pD)@D)P]	 fD(Шum
 D s 2	 
	 
R D	 
	 
1 	 
	 
 
	 	D	 56c ua
  	 
Y	 
 A	 
I	 
 5Q	 
9	 
q 
1	 uyU 
E T	 	 $ 
	 
 	  	 ܿ 
	 
Ŀ 	 
	 uq 
 	 	 o 
	 
W 	 ? 
	 
' 	 
	 5	     
 ^	 F	 ƾ 
>	 
 6	  
.	 
~ &	 f 
	 
N 	 
	     & 
  	 u	  
m	 
ݽ e	 Ž e	  
M	 
 U	 5U	 
=	 = @ug -! 
 @8	  	 ؚ 	 	 -	 
	 	 f(
z	 -j	 %Z	 x\~ n 	 	 L 	 	 , 	 	 5	 	 rj  R	 r	  Z	 b	  Z	  R	 r J	 	rbT D 		 	 " 	 	  5	 	  	 
D)d$PrD% 
D%`	 r	 	D%O	 ra -	 G	 r9 	 '	 
D)\$`rD
 
D	 	 	D	 D)|$ rD=Ϻ D=	 	 	D=	 D)$   rD
 D
\	 	 	D
K	 D)t$0rD5V D5!	 c	 	D5	 )$   r= =	 0	 =	 D)l$@rD- D-	 	 	D-	 fWfA/vH
9	 L$   H8 车fD.zuH
	 Hm zf fA/  fA(fA(AYfD(fA(A^r: f/Yf DYD^
:f    f(f(Y
<	 Y	 X
$	 X	 YYX
	 X	 YYX
	 X	 YYX
	 X	 YYXt	 AX^   ^f(f(YR	 AYX
}	 XE	 YX
q	 YX5	 YX
a	 YX%	 YX
Q	 YX	 YX
A	 YX	 ^DYx fE(EXE\E\EYDYEX  ȷ fA/rXfA(L$   H	 H
F	 E3AY$   DY
 =	 fA(A\fD(A\hD؈ fE/   fA(L$   H)	 H
b	 E3AY$   蜛Y= fA(fD(\=	 A\f(AXYfA(DYD^f(fA(8 Y2d Y^5c DX  E^fA(AYf/   f(fD(DY%i	 Y1	 DX%P	 X	 DYYDX%.	 X	 DYYX	 DXDYYDXX	 DYDXYXD^   f(^f(fD(DYYX|	 DXDYYDX%	 Xe	 DYDX%	 YXS	 DYDX%}	 YXA	 DYDX%k	 YX/	 D^f/   fD(f(DY
޿	 Y	 DX
ſ	 X	 DYYDX
	 Xk	 DYYDX
	 XI	 DYYDX
_	 X'	 DYYDX
=	 X	    ^fD(f(DY
	 Y	 DX
	 Xپ	 DYYDX
	 XǾ	 DYYDX
	 X	 DYYDX
۾	 X	 DYYDX
ɾ	 X	 D^fA(t5 f(fA(H5 f(fA(^5 DUd f(EYD^X\AYAYXDYD(|$ D(t$0D(l$@L$   fA(A(sE(CE(SD(d$PD(\$`D($   ($   ID$H   	 D)$   D)T$`fD(uy
  յ 	 
\	 
 d	  
L	 
 
L	 
l $	 
D	 4	 DsV ur7 
' 	 	  
	 
 	 ִ 
	 
 	 
	 D	     
} 	 	 \ 
ܿ	 
D Կ	 , Կ	  
	 
 Ŀ	  
	 
̳ 	 
	     
 	 	 s 
	 
[ 	 C 
۾	 
+ Ӿ	  
˾	 
 þ	 
þ	 D¾	  fWҨuir 
b a	 	 A 
	 
) 		  		 ٽ	 
	 	  uj݂ 
͂  	 t	  
l	 
 d	 | d	 4	 
L	 DS	 @uqG 
7 @	 Ƽ	  
	 
 	  
	 
΁ 	 
	 	 xs 
 	 	 p 
	 
X 	 @ 
 	 
( 	 
	 D	 D)\$PrD D	 	 	D	 	D)d$@rD% 	D%b	 \	 	D%Q	 
)$   r5{ 
5'	 )	 5	 D)t$ rD5B D5	 	 	D5ܺ	 )$   r= =	 ļ	 =	 
D)l$0rD-ͯ 
D-x	 	 	D-g	 fA/rL$   H4 H
5 -T[ D)L$pfA/r|fA(L$   H˻	 H
	 E3AY$   &Y56 fA(fD(fA(\AXA\YfA(A^DYcE^f(   D~ fE/   fA(L$   H	 H
	 E3AY$   Y=~ fA(fD(fA(\AXA\YfA(A^DYbE^f(fA(. Y>Z Y^5Y DX   E^fA(AY$   fA(- f(fA(- L$   H	 H
"	 E3f(֏L$   H?	 f(\fD(H
c	 E3EYDY衏XYD\fA(j- Y\ D^EYD(t$ D(l$0D(d$@fA(D(L$pD(\$P($   ($   D($   D(T$`Hĸ   H@H   )p)xD)HfD(D)P4	 uk
8 (  	  % -߮ 
	 	 	 	 %	 -	 0-	 %	 	 	 u	 
e	 =}N D)\$`D)d$PD)l$@u<DN D%= \	 D	 D%
	 =
	 fD(D-	 D%	 Dع	 D D)$   D)t$0D)|$ u_D D= 5 ۹	 Dz	 Dy DP	 Dg	 D=F	 5F	 fE(D=.	 D5	 u>5) D o	 5߸	 D޸	 DŸ	 =ո	 	D	    Dɬ 5  	 D?	 D 5&	 D-	 Dt D#	 DZ D	 D@ D	 D& D	 D D	 D D	 Dث D	     D  =s	 ]	 D	 D D
	 Dq D 	 DW D	 D= D	 D# D	 D	 Dض	 D Dζ	 Dժ DĶ	 D D	 fWfA/vH
	 L$   H4 fD.zuH
k	 H hfA/   fA(AYf(YfD(DYDXDYDXf(YXDYYDXf(AYAXDXYAXD^fA(( f(f(f(Y
	 Y_	 X
o	 XG	 YY5c	 YX'	 AXAXYYAXX^YD\8  A^fA(fWT f(Y' fD(fA(' f(f(D^f(f(Y	 Y?	 Y
/	 Xw	 X	 X
	 Yg	 YYX?	 Xߴ	 X7	 YYYX	 X
	 X	 YYYYXӴ	 X	 X
s	 YYYXW	 X	 X
?	 YYYX#	 XXw	 X^DYD(|$ D(t$0D(l$@L$   fA(A(sA({E(KE(SD(d$PD(\$`D($   IH@H   )xD)@D)HD
 fD(D)XD)`D)l$@	 D)t$0D)|$ uqD% D- D5 ӵ	 D= r D%	 D-	 D5	 D=	 	 D
]	 fE(-D=m	 D5\	 D-K	 D%:	 D)	 =G u<
 D
	 3	 
	 
è =	 
Ӵ	 	D
	 fWua 
 	 o	 _ O	 _	 ? 
?	 O	  G	 uA 
 	 	 ҧ 
ʳ	 ҳ	 =ҳ	     
 9	 A	 q 
)	 1	 Q )	 9 !	 ! 	 	 	  		 ٦ 	  	  	      
y  x	 0	 X 
	  	 8 =H	 	  	    	  	 Х 	  	 fA/vH
	 L$   H3 fD.zuH
]	 H bfA/)$   D)T$p  fA(fA(AYf(Y" f(Y
	 f(fD(f(Y	 X
	 YB	 Xұ	 AXYYYX
	 AXYYXf(Y	 X
	 Xl	 YXX	 YXD	 ^f(AYDYAXYXf(Y	 AXXl	 YXX	 YAX^DXE^8  A^fA(fWM f(Y! fD(fA(! f(f(D^f(f(Y	 Y1	 Yy	 Xi	 X		 XQ	 Y
	 YYX1	 Xѯ	 X
ѯ	 YYYX	 X	 X	 YYYYXů	 X
}	 X	 YYYXI	 X	 X
A	 YYXy	 XYX	 X^DY($   D(l$@D(t$0L$   fA(A({E(CE(KE([E(cD(T$pD(|$ ILATH   HǄ$   I[IkIsI{ A)sHHHH{   H{    HqH~    A0HSHMHEE3Ld$0Ld$8Ld$@ICIKISMCISIK赸L\$XIHD$HHD$`IHD$PHD$hJ    HD$pHGHHHH$   H$   H$   $   HT$0H$   Ld$(HL$ E3L@3H$   `HL$0z8 HL$8o8 HL$@d8 L$   I[IkIs I{(A(sIA\M;6  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3I@IBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@HBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@BYBPAXAHtHAHtH3HtL@E3HtHP3I@I I HHBDYBPAXAAALd$0H|$(Ht$ Hl$L;}]IE LHtHAHtH3HtL@E3HtHP3I@IL;BDYBPCXDCD|A][M;  WAVHIIMI+LLH  HH\$ Hl$(Ht$0Ld$8L,$HHA   I+IJ   HH+L+HL+LHMMtIBHtH3HtL@E3HtHP3I@KL
 ^BpAAMtIBHtH3HtL@E3HtHP3I@I)^BpAAMtIBHtH3HtHP3HtHH3HB^ApAMtIBHtH3HtL@E3HtHP3I@KH I H^BpAAL,$Ld$8Ht$0Hl$(H\$ L;}QMMtIBHtH3HtHP3HtHH3HBIL;BD^ApCD|HA^_E3LLIPMuIHHJuIHaHAuIH@fBHtHIIpHJffYHuIH	HAuIH@fB$HtLIAIPIHffYfXfBXfB)HtHA3LPIHH+HLIHLIIM  HtHA3IH@ffY   HtHA3H@   I;fHfY}FHtHA3H@ffYfXHtHA3H@HI;fDfYfX|M;fX~HtHA3H@fBfYfXM;f(fX   II+H   MJ   M+IIIOHtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(HtHA3H@A   M;Y   IBH   MJAPIIN   D  HtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(M;I  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3AAI@IBYJp\AAHtHAHtH3HtL@E3HtHP3AAI@HBYJp\AAHtHAHtH3HtL@E3HtHP3AI@BYJp\AHtHAHtH3HtL@E3HtHP3AAI@I HI HBLYJp\AALd$0H|$(Ht$ Hl$L;}`IE LHtHAHtH3HtL@E3HtHP3CI@IL;BLYJp\CD|A][HL$WH0HD$ H\$HHHD$P        HtH3HHD$P    LD$P   HgHC H+CHHu.- HCH8HH\$HH0_HL$WH0HD$ H\$HHt$PIHHD$X        HtH3HHD$X    LD$X   H~fHC H+CHHu, HCH0HC H+CHHww, HCHxHH\$HHt$PH0_H\$Ht$ WH@HA`HA Hy`H+AHHHH;s<fHCPH+CHHH;r	, HCHH94sHC`HC H{`H+CHH;rHC H+CHH9C`   HK0mHHH;HBHL$`@HT$PHHD$P>HlH8 u6H HL$ A   + L. H HL$ L\$  HT$`HK0HC H{`H+CHH;r1+ HCH<H7Hs`HCpHKPH+KHHH;r+ HKHHHHt$hHHKhH\$XH@_HT$HL$UVWH`HD$ H$   HHH@H$       3HtHHHL$      HGdH{0H$       HtH8HHL$      HdHk`HC H+CHHu* HSHHHKhHC H+HHu) HCHHKpH{x   ! HtH8HHHoHo Ho(H       HtH8HHHoHo Ho(H       HtH8HHHoHo Ho(HC H+CHHuT) HCH8 u6A   H HL$() LK, L\$(H? HL$(I HH$   H`_^]@SVWH03H/ IHHqH=T	 HHL$PHuHHK	 H+HH
5	 HH+HH;sHAHH	 HH0_^[Hl$XLd$`HH;vu( H
	 H=ߠ	 H	 HHl$(H+LHT$ HuH)H;v
5( H	 MtL;t( H+H(D$ LL$PHT$ H
a	 A   fD$ <L%a	 L;%b	 v' H=3	 Hu' LLILd$`Hl$XI;C wHtH7H;Fs' HH0_^[@SH@HD$ )t$0f(HH^	 HHHP	 H;A	 r   H
˝	 HHL$PHtf( 3HH(t$0H@[LAHHI      A@D$HD$H#I;wAHB @D$HD$H#I;w%BAX@A@HB @XB@H# HIHH# HR HHJHQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH)# HHJ@WH0HD$ H\$HHl$PHt$XIHHH	 HH(H	 H;	 r(   H
/	 JHHt$@Ht,H?HOXKHuH^H~ H֐ H3Hu HH\$HHl$PHt$XH0_@WH@HD$ H\$PHt$X)t$0f(HHf.. z
uHHHmH	 HH(H	 H;ݛ	 r(   H
g	 HH|$`Ht)Hf(XKHH_w H) H3H>HH\$PHt$X(t$0H@_HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH9! HHJ@WH@HD$ H\$PHt$X)t$0f(HHf., z
uHHHmH	 HH(H	 H;	 r(   H
'	 BHH|$`Ht)Hf(YKHqH_w Ha H3H>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0If(Hf.
+ z
uI HHmH	 HH(Hܙ	 H;͙	 r(   H
W	 rHH|$XHt)Hf(YKHH_w H H3H>HH\$PHt$`(t$0H@_Hy( HHE3HL9Av0@ HB IJLHB(BDYBXAAL;BrAHAYAX@@@WH0HD$ H\$HHt$PHHHʘ	 HH H	 H;	 r    H
7	 RHH|$@Ht)HC
 f(H|H_H H3H>HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHH5sf(HH1 HHG H+GHH    H	 HHH	 H;ח	 rH
f	 HHNHG H+GHHF 3Ht8 HG H+GHH;r  HGHNHHHH;^ rHHH\$HHt$PH0_E3L9A v(    HAIJTBXABL;A r@WH0HD$ H\$@HHHB H+BHufWmHNH	 HH(HӖ	 H;Ė	 r(   H
N	 iHHL$HHt
HT3HHH\$@H0_HATAUAVH   HD$ HXHhHpHx ILH3H9Y~%HƐHIe$HHHcH;G|DH9w~gL H HL$P HII $LHHL$( HH蓎HL$( HL$P AMcL;w|H ~hLD  H1 HL$(~ HII#LHHL$P? HH#HL$Pg HL$([ LcL;o|L$   I[ Ik(Is0I{8IA^A]A\H\$Hl$Ht$WH 3HHH9y~'Hf     HCHHHcH;K|H9{~XHff     HCHH谌HcH;K|H9{~*Hffff     HC0HH而HcH;K|H\$0Hl$8Ht$@H _HLH L@HHSVWATAUAVAWH  HǄ$H  )pILLIHHH$   (- $  H$   PH$        HtH$   H33HH$   H$8  H$@  H$H      Ht
H$   HHH$   H$  H$   H$(  Hm H$P  # IH$P  IPH$P   tZH HL$@ H$   ) H H$   HT$@H$8   Hf H$    HՊ H$P   IL$P  HT$@IPHH$   KHL$XHt H|$XH|$`H|$hHL$@f H$P  K H! HL$@ HM H$x   H H$P   HL$pHD$ LL$@L$x  H$P  IϻH$   Ht H$   H$   H$   HL$p H$P   H$x   HL$@ L$@  H$8  L+IMuN H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v H$   H$   H$   LHL$0Ht$8HH+HuH*H;v H$   MtL;tm H+H(D$0fD$0L$   A   HT$0H$   'L$   L;$   v# H$   Hu LLII;K wHtHHH;Hs H HL$@ IHT$@IPHL$@ tZH HL$@ H$`   Hf H$`  HT$@H$x   H H$`   HR HL$@3 ILD$@HT$pIPHH$   HH$   Ht' H$   H$   H$   HL$p HL$@ H& H$P   HĆ H$x   H HL$@ HL$pTHD$ L$P  L$x  HT$@IqH$   Htz H$   H$   H$   HL$pX HL$@@ H$x  1 H$P  " L$@  H$8  L+IMu H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;vj H$   H$   H$   LHL$0Ht$8HH+HuH*H;v' H$   MtL;t H+H(D$0fD$0L$   A   HT$0H$   ]$L$   L;$   v H$   Hu LLII;K wHtHHH;Hs Hg HL$@d IHT$@IPHL$@e tZH HL$@/ H$  p H H$  HT$@H$  % H H$  , H؃ HL$@ ILD$@HT$pIPHH$   0EH$   Ht H$   H$   H$   HL$p HL$@ LH H$P  W HG H$x  A HQ HL$@. Ic   HL$pHD$ L$P  L$x  HT$@I	H$   Ht H$   H$   H$   HL$p HL$@ H$x   H$P   fW$   Ic       Ht
H$  HHH$  L$   HH$  'MDHA    {   fMIH$  H$  H+HH;r H$  H$@  H$8  H+HL;r H$8  JHAHL$0  E;   |D@ E;     IcH$  H$  H+HH;r H$  L$H$   HuHH$   H+HL$   IH+HH;s0   IfHtI$HHHI@H$     II;v L$   H$   H$   LHL$0Ht$8IH+HuH*I;v H$   MtL;t H+H(D$0f$   MA   H$   H$   L$   L;$   vf H$   HuS LLII;K wHtHHH;Hs( L$0  L$0  ANH HL$@ IHT$@IPHL$@ tZHr HL$@ H$`   H H$`  HT$@H$x   H5 H$`   H8 HL$@] ILD$@HT$pIPHH$   @H$   HtQ H$   H$   H$   HL$p/ HL$@ HP H$P   H~ H$x   H~ HL$@ HL$p~HD$ L$P  L$x  HT$@I蛰H$   Ht H$   H$   H$   HL$p HL$@j H$x  [ H$P  L L$@  H$8  L+IMu H$8   f(V$   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v H$   H$   H$   LHL$0Ht$8HH+HuH*H;vH H$   MtL;t0 H+H(D$0fD$0L$   A   HT$0H$   ~L$   L;$   v
 H$   Hu
 LLII;K wHtHHH;Hs
 H8| HL$@ IHT$@IPHL$@ tZH{ HL$@P H$`  
 H) H$`  HT$@H$x  F H} H$`  M H{ HL$@ ILD$@HT$pIPHH$   Q=H$   Ht H$   H$   H$   HL$p HL$@ LH H$P  x H{ H$x  b Hr{ HL$@O IcUDHL$pHD$ L$P  L$x  HT$@I-H$   Ht6 H$   H$   H$   HL$p HL$@
 H$x  
 H$P  
 $   Ic]D    Ht
H$  HHH$  L$   HH$  REDHA}D v   MIH$  H$  H+HH;rH H$  H$@  H$8  H+HL;r H$8  JHAHL$0  E;eD|D    E;uD  IcH$  H$  H+HH;r
 H$  L$H$   HuHH$   H+HL$   IH+HH;s3   ID  HtI$HHHI@H$     II;v<
 L$   H$   H$   LHL$0Ht$8IH+HuH*I;v	 H$   MtL;t	 H+H(D$0f$   MA   H$   H$   .L$   L;$   v	 H$   Hu	 LLII;K wHtHHH;HsX	 L$0  L$0  ANH$   H$H  9H$   H$@  H$  Ht H$  H$  H$  H$   H$  Ht H$  H$  H$  H$   H$  Ht H$  H$   H$(  H$    H$8  Htu H$8  H$@  H$H  H$   P H$   Ht= H$   H$   H$  H$    H$   Ht H$   H$   H$   H$    ($  H  A_A^A]A\_^[HATH   HD$0HXHhHpHx IIHH    E3Ht
HL$8HIHD$8Ld$PLd$XLd$`   r Ht
HL$hHIHD$hL$   L$   L$   H\$ LL$8LD$hHHHl$XH+l$PHH;otH Ht
HfHL'HoAIH~?     HD$XH+D$PHH;r HHD$PHHHHcH;G|H$   Hts L$   L$   L$   HL$hQ HL$PHtA Ld$PLd$XLd$`HL$8( L$   I[IkIs I{(IA\HWATAUHP  HD$HHXHhHpEEHH   DÍSHL$P HL$  HHL$P HL$  Ht HL$`@_HT$ HL$P HHuHL$ H HL$ M HHL$P HL$ " Ht HL$`^HT$ HL$PA HHtHL$  9   |~HL$  HHL$PU HL$  Hs HL$`x^HȲ.\Hȋ[ HT$ HL$P HH'tHL$ k ;   ~HL$ f HHL$P HL$ ; Hr HL$`]HT$ HL$PZ HHsHL$  9^D|{HL$   HHL$Pq HL$  HVr HL$`]HȲ.[Hȋw HT$ HL$P HHCsHL$  ;~D~EuEuHL$P       |~HL$ b HHL$P  HL$ 7 Hr HL$`\HȲ.[Hȋ  HT$ HL$PA HHrHL$  ;   ~Eu
HL$P HL$P
 L$P  I[ Ik(Is0IA]A\_@VWH8HHH;  LZ H\$XHZLd$0MIgfffffffL+IILIIH?LurH\$XLd$0HH8_^LQHl$`Hi HII+HLIIH?LM;   DL$P3MD$(D$PIHˈD$ `lHo HH;t@ H  H(H;uHN IH+NHHHH?HHGHHHHO Hl$`H\$XLd$0H8_^Mu3HO(II+HHHH?HL;wZKDL$PHH3MD$(D$PHӈD$ kLG HV 3LOD$(D$PHˈD$ HG HgMtLIHHO HN IH+NHHHHH?HtLOLF HVH>HG HHH8_^HT$VWATH0HD$(H\$PHl$`AAHHE3Dd$ AL$p HtHIHLcLc Lc(D$    H  DDHHH\$PHl$`H0A\_^H\$Hl$WH HY3HHtLHt$0Hq H;t0D  HKHt HHkHk Hk( H0H;uHO Ht$0H\$8HoHo Ho(Hl$@H _HWATAUH   HD$0HXHhHpMLHIp    tYHn HH HL$8) H HD$8HT$xHL$P H\ HD$8Hm HL$8 ITLA    tH~$HF    tIIL$HyH;   H^    uH_HE0H9puHxH93uH;H{HU0H92u8    tH'HH    uf     HH     tH
HU0H9r       tH"HHG    ufHH@    tHJ   IKHHH;NuH$HY    uH_H;HFHAHFHHHE0H9puHHHFH90uHHHHFHAH   L   L;tAA 
     HE0H;x  ff          HH;udHK    uƁ   ƃ    HH3HK    tH   H      HA   u}Ɓ    HZ    uƁ   ƃ    HH3H    tH'HA      H   uzƁ    HH[HE0H;x   HA   u Hƀ   Ɓ    HH]3HK      ƃ   HAƀ   HH2UH   u HAƀ   Ɓ    HH2H      ƃ   Hƀ   HH2Ƈ   H   Ht| 3H   H   H   HNp\ HNXHtN H~XH~`H~hHN@9 HN# H' HE8HtHHE8HL$ I$HID$HAHD$(HD$(HE HD$ HL$ HIE HAIEIL$   I[ Ik(Is0IA]A\_H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ v@ HHL$0H^HHE HHEHAH\$8H9_wH;_ v HHtH;t LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$hiBHo LH;t2HXHHt HKL+LkLk H0HCH;uLg Ld$hH\$pHl$xHH@A]_^Hl$Ht$WH     HHH   H\$0fD  HVHH   H6Ht, HOp3H   H   H    HOXHt HO@3HGXHG`HGh HO H     HyH\$0Hl$8Ht$@H _ATHPHD$8H\$`Ht$hH|$pIIL⹨    HHD$0HD$@Ht+$   L$(H$   HL$ LLIHClHH\$`Ht$hH|$pHPA\ATHPHD$8H\$`Ht$hH|$pIIL⹨    HHD$0HD$@Ht+$   L$(H$   HL$ LLIHClHH\$`Ht$hH|$pHPA\I;tXWH H\$0Ht$8I3HZ HHt_ HKH3HsHsK H0HCH;uHt$8H\$0H _@SH03MM؈D$(D$@HLIMIHˈD$ @CH0[H\$Ht$WHPHHIHHuE3LC(L+IH{ HH+HI;s;3LLKD$(D$`   HψD$ L_L[ H\$hHt$pHP_H;vI HH|$8LD$0HD$0HT$@L(D$0HfD$0<H\$hHt$pHP_H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,CNH;}8D$8f    HHH;Hf(DfYf)D|HL$ LLHH\$pHH@_^]@SH HLE3LHHIHH+HLMM~+@ HIM;HIfB(DfBXDfB)D|HI\HH [HT$VWATH0HD$ H\$PHl$hH3t$`M`Il$HuH9HH;v"H    H> HHuHt|"HHoI\$HHtH;tQ"HtH;t<"̄t2"H;t Ht
HSHH7H_HHH+HLMM~!    I$f(Hf)HI;|LHIHH\$PHl$hH0A\_^H   HL$ LD$PHB@HD$(HHz HT$0HHT$HI HAI@HAI@HAI@ufWY HĈ   H$   HL$@hYe HĈ   HT$UVWHPHD$ H$   H3ۉ\$pHAHpHt$0fWD$@HuH6HH;v H,    Hc HuHt HHwHt.HH;t~ ̄tt ̄tj HwHHH+HLMM~ (      Hf)HI;|LHHL$(HH$   HP_^]HT$VWATH0HD$ H\$PHl$hH3t$`M`0Il$HuH9HH;vH    HN HHuHtHHoI\$HHtH;taHtH;tL̄tBH;t Ht
HPHH7H_HHH+HLMM~!    I$f(Hf)HI;|LHIHH\$PHl$hH0A\_^Dʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ   +i+ȋH [At+;s
H|$0H [ÍU  H|$0H [LDA   H   Ip     AtlEtgAuE\3҃A=r#E   AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ   AA+iD+'EIMIIH+HHHHiɫL+IADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ  +i+ȋH [At+;s
H|$0H [Í  H|$0H [LDA   H   I   AtlEtgAuE\3҃A=r#E  AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ  AA+iD+'EIMIIH+HHHHiL+IAH\$Hl$VWATH0LHyHHHL$PH|$hAtH$IHD$hHL$ IAI;LD$ HMHHLE3H+HHH+HT$PHL$CI;}2HE HHI;fDf(Lf)DHE fLfL|HT$PLMHH\$XHl$`H0A\_^HWATAUAVAWH  HǄ$X  HXHp)p)xD)@D)HD)PIILfEWfA(3L$  I H$   H$   E3L$   L$   H$   -6f($  H$   6fD($P  AM Ht
HL$@HIHD$@Ll$XLl$`Ll$hMc   MI  fD  H$   5$   H\$XHuIHT$hH+HHL$`HH+HH;sHAHD$`   HH;v HL$`H\$XHT$@HH$@  H$H  HH+HuI'H;v HT$@HtH;t H+H($@  fD$0L$   A   HT$0HL$@Ht$XH;t$`vB H\$@Hu2 MLHI;K wHtHIH;Hs IH$   p4f(H D
x fAWfD.ztG f(AX$@      Ht
HL$pHIHD$pL$   L$   L$   McgDMX  H$   3$   H$   HuIH$   H+HH$   HH+HH;sHAH$      HH;v H$   H$   HT$pHHT$0H|$8HH+HuI'H;v HT$pHtH;t H+H(D$0f$   L$   A   H$   HL$pH$   H;$   vZ H\$pHuJ MLHI;K wHtHIH;Hs IIVHuIIN(H+HI^ HH+HH;s;HCIF    H;v I>H|$0H\$8IN IvHH+HuI"H;v HtI;>t H+H(D$0f$   L$  A   H$   IIvI;v vG I>Hu9 MLHI;K wHtHIH;Hs IVHuIIN(H+HI^ HH+HH;sDHCIF    H;v I>H|$0H\$8IN IvHH+HuI"H;v HtI;>t H+H(D$0f$   L$P  A   H$   IIvI;v v? I>Hu1 MLHI;K wHtHIH;Hs AA9   ~Eff     HcHD$`HL$XH+HH;r HL$XHISA;   |IVHuIIN(H+HI^ HH+HH;s3HCIF    H;vm I>H|$0H\$8IN IvHH+HuI"H;v: HtI;>t* H+H(D$0f$   L$@  A   H$   IwIvI;v v I>Hu MLHI;K wHtHIH;Hs AA9_D~FD  HcH$   H$   H+HH;r{ H$   HIwRA;_D|$   ubH$   Ht_ L$   L$   L$   HL$p= HL$XHt- Ll$XLl$`Ll$hHL$@ &     ) Ht
H$  HIH$  L$   L$(  L$0  H 8D$   Ic       Ht
H$   HIH$   L$   HH$   )* f(IH$   HH$   H+HHt:H;r! H$   4HH$   HH$   H+HH;rIH+HHt= H;r H$   <HH$   H$   H+HHH;r6	           A;     6	    HcH|$`Ld$XI+H  G;  LkL;rB Ld$XI   A   LaR H0CY4fAWH$   H$   H+H|)G;}"HH;r H$   4=   DBH$p   H H$  :   Hk H$   H$p   H$   N H
O HL$ LDËH
 讑   DBH$p  n H H$  :   H H$   H$p  M H$    H
N HL$ LDËH
k .E3AA9   ~DHcH$   H$   H+HH;r H$   HINA;   |D8$      H$   Htv L$   L$   L$   H$   Q H$   Ht> L$   L$(  L$0  H$   H$   Ht L$   L$   L$   HL$p HL$XHt Ll$XLl$`Ll$hHL$@    H$   Ht L$   L$   L$   H$    H$   Htl L$   L$(  L$0  H$  G H$   Ht4 L$   L$   L$   HL$p HL$XHt Ll$XLl$`Ll$hHL$@ L$  I[0Is8A(sA({E(CE(KE(SIA_A^A]A\_HPWH  HǄ$   HXHhHp IHH    3Ht
HL$@HHHD$@Hl$XHl$`Hl$h   DBH$   N H$   HD$8D$0D$(HD$@HD$ L$  LHHH$   H$    Hx H$    t7H$   H$    H$  LHAH$    H|$XHHL$`H;v_ HL$`H|$XHT$@HHT$pH\$xHH+HuH'H;v% HT$@HtH;t H+H(D$pfD$pL$  A   HT$pHL$@aHt$XH;t$`v H|$@Hu LLHI;K wHtHHH;Hs H$  HHT$@PH$    HL$XHt~ Hl$XHl$`Hl$hHL$@e L$  I[IkIs(I_HWH   HD$ HXHhHpIIH   = 3Ht
HL$PHHHD$PHl$hHl$pHl$xH6H HL$( HT$(HL$PsJHL$( HG HL$( HT$(HL$PEJHL$( LHT$PHASAEHT$PHvHHHT$PPH\$hHt,H|$pH;t H7 H(H;uH\$hH- Hl$hHl$pHl$xHL$P L$   I[IkIs I_HHPVWATH   HǄ$   HXHhIIHH    E3Ht
HL$ HIHD$ Ld$8Ld$@Ld$HHF H$   F H$   HL$ IH$   D HF H$    H$   HL$ HH$   
 LHT$ HAS   $ Ht
HL$PHIHD$PLd$hLd$pLd$xE3E3HT$PHLLD$ HT$PHAS(HMHHT$ PH\$hHt,H|$pH;t Hw H(H;uH\$hHm Ld$hLd$pLd$xHL$PT H\$8Ht,H|$@H;t H' H(H;uH\$8H Ld$8Ld$@Ld$HHL$  H HHN L$   I[ Ik0IA\_^LL$ LD$VWATHpHD$(H$   ILHH\$    赾 HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@HH;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt譽 Ht$XHt$`Ht$hHL$@蔽 HH$   HpA\_^@WHH$H\$ HH;   MH LR f     H0I0I0I0L;tcMHI LII;tHIHIMZIYI;tHIHIM;tI	III
MZIYI;tHIHIH;uIIH\$ H_H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,C4H;}8D$8f    HHH;Hf(Df^f)D|HL$ LLH~4H\$pHH@_^]H\$Hl$Ht$WATAUH I@ HMI+@IHHHH    H^K	 HHHQK	 H;BK	 rH
J	 HHHOH+K	 HLHHK	 H;K	 rH
J	 赧LLGLG HGHN E3H+NIHHHO(HF HoH+FHHt-H;r HFHHLHLHF H+FHH;rHV HOI$H+VHHHOHHH;tfL)HH;uH\$@Hl$HHt$PHH A]A\_H\$WH@HHHL$ HHBE3HAHBHAHBHAHHHzHHH+HLMM~AL\$0LL$( IIIM;fB(DHfBYDHHfBXDfB)D|HL$ LHcHH\$PH@_H\$Ht$WH IHHMuhHQ(HXI	 HHHHGI	 H;8I	 rH
H	 H3HH9W(v,@ HHHHDH;W(rH\$0Ht$8H _L
H\$0Ht$8H _H\$Ht$WH IHHMuhHH	 HQ(HLHHH	 H;H	 rH
'H	 BL3LH9K(v,I+JHIIAH;K(rH\$0Ht$8H _L
H\$0Ht$8H _HUVWATAUAVAWH   HD$8HX)p)xD)@MLLHA H+AH  Ix   fWLH H
!	 fAn.$  H      H$  H#H;u*Ht HD$ L
H MH H
 	 
9E3MIL$HtPI$D  Icf/v
IL;r/H HD$(H HD$ MH^ H
W 	 H=J 	 H$  L$(  ME M+EILD$0H$  H$(  HHDHD$0L;HBHLMH. HvLMH H!IIE I+EHHu I}I$Mm L+I   L;LFIt$L;LFH藶 Ht
HL$@HIHD$@$  L$  HHL$@It$   R Ht
HL$pHIHD$p$  L$  HHL$pIM9|$   D D  Hc<HD$`HL$XH+HH;r HL$XfA(^<H$   H$   H+HH;rb H$   f(ߴ D HI;t$rIM   D  Hc<fEnEHD$`H+D$XHH;r A\HD$XY<YX5-	 H$   H+$   HH;r H$   \4	 YXHD$`H+D$XHH;r HI;YH$   Ht蓴 L$   L$   L$   HL$pq HL$XHta L|$XL|$`L|$hHL$@H f(fWL$   I[HA(sA({E(CIA_A^A]A\_^]HATH   HD$ HXHhHpHx IHH    E3Ht
HL$PHIHD$PLd$hLd$pLd$xLOHD$0Ld$8(D$0fD$0LD$0HT$@HL$PHT$hHuIHL$xH+HH\$pHH+HH;sHG HHCHD$p=H;v HD$PHD$0H\$8(D$0fD$0LO LD$0HT$@HL$P$HHT$PHPLHT$PHAS0HMHHT$PPHL$hHtĲ Ld$hLd$pLd$xHL$P諲 L$   I[IkIs I{(IA\HWH  HD$PHXHp HH3LQM  L	E3HH      D  C$  H$  H#H;t,$  H$  H#H;wIHcI;|E      Ht
HL$ H3HD$ HD$8    HD$@    HD$H    AEHT$ H   DBH$    H?HcHL$@LD$8I+HgfffffffHHHH?HH;r5 LD$8HIH$    HH8 #Hu HH #H$   H$   ( HHL$X
 H HD$XHHL$p H HD$XHs9 HL$XŰ L$  I[Is(I_HL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;vH    H$ HHuHtbHHwI\$HHtH;t7HtH;t"̄tH;t Ht
H(HH/H_HHH+HLMM~I$f(Hf)HI;|LHIuHH\$XHl$`H0A\_^HHXWH   )p)xD)@AD)HD)PD)XfD(EYDY D)`fD(fA(\ D
 fE(L$   H$      f(fA(fA(EYY=, gkf(fD(fT
v f/
^ vH
! H
1 fA(AYí f(fA(Y- YXf;vT%  ff(AYA\DXfnf(fA(fD(YA^^XYf;r(|$pL$   f(A(sE(CE(KI[E(SE([E(cI_HWATAUAVAWH   HǄ$   HXHhHp IILLIX   蛭 E3Ht
HL$pHIHD$pfW$   L$   HHL$pEIH9_~GfH/H$   H$   H+HH;r H$   HD HAHIcH;G|    Ht
HL$@HIHD$@L|$XL|$`L|$h   Ѭ Ht
H$   HIH$   L$   L$   L$   H$@  HD$8$8  D$0$0  D$(HD$@HD$ L$   LD$pIIHl$`H+l$XHH;ntLH  Ht;HH;v?H    H HuHtHL>HnAIH~=fD  HD$`H+D$XHH;r HHD$XHHHHcH;F|H$   Hts L$   L$   L$   H$   N HL$XHt> L|$XL|$`L|$hHL$@% H$   Ht L$   L$   L$   HL$p L$   I[0Ik8IsHIA_A^A]A\_Ht$WLE3IsI{HP  H\$E3H   H_HtHBHtL@E3IK IA@IIYHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIIL;YDDL;}=HtHBHtL@E3IK IA@IIIL;Y|IL;H\$Ht$_H\$M;IML   HL MtIBHtH3HHHtHA3H	tL@E3HtHP3I@BYJ0HtH3CYI@IL;\CD|H\$HWATAUHPHD$ HXHhHp )p)xf(f(LLH HHyH|$pHr3HuH9HH;vrH    H HHuHtNHHwI\$HHtH;t#HtH;t̄tH;t Ht
H HH/H_HHH+HLMM~#f     I$f(Hf)HI;|LHIXA}Au IL\$PI[(Ik0Is8(t$@(|$0IA]A\_@VWATAUAVH0HD$ H\$hHl$pLLH HHyH|$`Hr3HuH9HH;vH    H HHuHtHHwI^HHtH;tHtH;t̄tH;t2 Ht
HHH/H_HHH+HLMM~%fff     IFf(Hf)HI;|LHINIFIEIF IE IH\$hHl$pH0A^A]A\_^HHHUVWATAUH`HD$ HX)pHHHPfWp3HuH6HH;vH,    H8 HuHtyHH~IHt$I;tS̄tĪt?H~HHH+HLMHM~"( ff     Hf)HI;|LHHL$(H|$0H|$8t$@HnH$   LLLLIH}Ht,IHHH;t̄t̄tLLIHwLMLMIHH+HLMM~(! HE f)HI;|HHL$(!~(HH$   (t$PH`A]A\_^]HL$VWATAUAVH0HD$ H\$pHl$xMLHHj3HuH9HH;vH4    H] HHuHtHHoIt$IHtI;tpHtI;t[̄tQH;t Ht
HHHHwHHH+HLMHM~ I$f(Hf)HI;|LHI訿HwHt$hMMMEIIH|MMMEMtMtIHIL;tMt:MtIHIL;t{MtIHIL;t^IIHNLNLNIHH+HLMM~IE f(Hf)HI;|HIʾID$G(MH
	 H?MH
	 HHH\$pHl$xH0A^A]A\_^HL$UVWATAUH0HD$ H\$pLHHj3HuH9HH;vxH4    H HHuHtTHHoIt$IHtI;t)HtI;t̄t
H;t Ht
HHHHwHHH+HLMHM~I$f(Hf)HI;|LHIdHwHt$hML$ MD$IIHyML$ MD$MtMtIHIL;tUMt:MtIHIL;t3MtIHIL;tIIHLNLNIHH+HLMM~"    ID$f(Hf)HI;|HIL$xAD$(G(HH\$pH0A]A\_^]HHHVWATAUAVH`HD$ HXHh )pHLHPfWp3IHuH,I;v5H4    Hӷ HuHtI$I\$IHt$I;t̄t̄tI\$HHH+HHHHH~( fI$f)HH;|LLIHL$({H\$0t$@It$H$   HuH,I;v^L,    I HuMt=HH^Ht$I;t!̄t̄t
H^H~$(̰ ffff     Hf)HH;|LLHHL$(A\$ IL\$`I[@IkH(t$PIA^A]A\_^HHHVWATAUAVHPHD$ HXHh LHHr3IHuH/I;vRH<    H HHuHt.HM HuI}IHtI;tHtI;t̄tH;t HtHkHE H] H}HHH+HLMHM~@ IE f(HE f)HI;|LHI7I}H|$0fWD$@HuH$   HuH,I;vCL$    I HuMt"HH~Ht$I;t̄t̄tH~HHH+HLMM~( Hf)HI;|LHHL$(IEE HL\$PI[@IkHIA^A]A\_^HL$UVWATAUAVAWH@HD$0H$   MLHHjH3HuH/H;v.H4    H̳ HHuHt
HHoIuIHtI;tHtI;t̄tH;t] Ht
HHHHHwHHH+HLMHM~ IE f(Hf)HI;|LHIHoH$   MfMuH9HL;v)J4    Hǲ HHuHtHM LeIvHtI;tHtI;t̄tI;ta HtHLHE H] HuHHH+HLMHM~D  If(HE f)HI;|LHIIMO HGHD$ L
& DH. H
	 LI      H9_vbH@ Ic$   H$   I#I;wIL;Or/HU HD$(H) HD$ LHj H
	 &HMHtaHU Hc$   H$   I#I;w
HH;r2H HD$(H HD$ LLH% H
9	 輈HH$   H@A_A^A]A\_^]HL$UVWATAUAVAWH0HD$ H$   LHHrH3HuH/H;vH    H HHuHtHM HuI^IHtI;tHtI;t}̄tsH;t HtHHE H} H]HHH+HLMHM~ If(HE f)HI;|LHIȳHuHt$xMfMuH9HL;vJ    Hz HHuHtHLfI^HtI;tHtI;t̄tyI;t Ht
H HH>H^HHH+HLMM~IFf(Hf)HI;|LHINղAF E HH$   H0A_A^A]A\_^]@SHPHD$ HHL$( L3H H HL$(D HT$(HHL$(J H7 HL$( HT$(HHL$( H HL$( HT$(HHL$( H HL$( HT$(HHL$(Ƭ HG HL$( HT$(HVHL$( H HL$(h HT$(H*HL$(n HP[@SH@L
E3MJL$0HILT$(HH+HLMM~,fI
Hf(HIfBXDM;fB)D|HL$ HHH@[HL$WATAUH@HD$0H\$hHt$xHHٹ   ߓ HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;vHHKHCHC HvHHHK(Hw H9wv
 LgL;g v 3D$(D$pD$ LKLCHI;HC HH\$hHt$xH@A]A\_@SH HHH [ @SH HH  D$0    HHH [@SH HH  D$0    HHH [H\$UVWH0Hq HH9qv! H_H;_ v H9_wH;_ v H/H9wwH;w v HtH;/tڪ H;tsDL$PHW 3D$(D$PLHΈD$ QHw HH;t?Ld$XHXE3HHt訑 HKL#LcLc蔑 H0HCH;uLd$XHo H\$`H0_^]HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ LtHHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYHd IKR HL$` H HD$`HT$8HL$xQ H HD$`H HL$`O HQ0D$( H$   HD$ LLiLHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ LHHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYHD IK2 HL$`v Hf HD$`HT$8HL$x1 H HD$`H HL$`/ HQ0D$( H$   HD$ LL٬LHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ v HHL$0H^HHE HHEHAH\$8H9_wH;_ v HHtH;tx LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$h	AHo LH;t2HXHHtH HKL+LkLk4 H0HCH;uLg Ld$hH\$pHl$xHH@A]_^D$HH)t$0f( f/vLD$PH+ H
 f.z+u)`  "   H  fW (t$0HH)|$ f(X=T f.=L zuf((|$ (t$0HHf(ʆ \=$ ^(|$ Y(t$0HHH\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,CcH;}:D$Hfffff     HHH;f(DfYf)D|HT$ HL$0LLH$   HHP_^]HL$WHPHD$ H\$hHt$xHH3t$pN HtHHHHsHs Hs(D$p   HH H=# HL$( HT$(HPHL$( HH\$hHt$xHP_@SH`HHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HLHIHH+3HLMM~\LT$@L\$8H|$pH|$(f     IIHI;f(Df\DHf(LHfYHfXLf)L|H|$pHL$ HT,HH`[HHPUVWATAUHPHD$ HXH3퉬$   Mh@LhM`L`It$HuH9HH;vH    H0 HHuHtnHHwI\$HHtH;tCHtH;t.̄t$H;t Ht
HHH/H_HHH+HLMM~,f     I$IE f(fYHf)HI;|LHHL$(HH$   HPA]A\_^]HL$ATAUAVH@HD$0H\$hHt$pH|$xMHH3HAHA HA(HtaHUUUUUUUH;v9HoHHCHC L$MJHK(3D$(D$`D$ LKMHHJHC H\$hHt$pH|$xH@A^A]A\HL$SUWAUAVH0A   LH  AM  A
e  E3AADEDE+t3AAAAD+u	AD+AHp     HiM  HHH+HHHHiH+A;u3IչN  o3ɍPSDǪH0A^A]_][3Ht$hM  Ld$(E3L|$ DAD|$pM  Ip     E   uD+;sD3D3U  uA`A;uW3҃=r!˸   +i+(ƋHIHHH+HHHHiH+ȋыuAAv+;s<U  A;uAU3҃=r#Ëظ   +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ   +i+,Ӌ蛨D؅t+D;sDE;U  AIqD|$pH|$`tV3Ҹ=r)D   DAAA+iD+֋=sDpDV  Ht$hEtAD3AAD_L|$ Ld$(H0A^A]_][HL$SUWAUAVH0A   LH'  A  A>  E3AADEDE+t3AAAAD+u	AD+AH   Hi  HHH+HHHHiH+A;u3Iչ  ?3ɍP#D藩H0A^A]_][3Ht$h  Ld$(E3L|$ DAD|$pM  I   E   uD+;sD3D3  uA`A;uW3҃=r!˸  +i+(ƋHIHHH+HHHHiH+ȋы豨uAAv+;s<  A;uAU3҃=r#Ëظ  +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ  +i+,ӋkD؅t+D;sDE;  AIqD|$pH|$`tV3Ҹ=r)D  DAAA+iD+֋=sDpD  Ht$hEtAD3A輦AD/L|$ Ld$(H0A^A]_][H\$Hl$WH HZHyHHHtH;tHtH;t̄tHt$03H;_tHj Ht
HUHH7HH_HH+HLMM~ HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _HWATAUAVAWH   HǄ$   HXHhHp )p)xD)@IHHHY    z E3Ht
H$   HIH$   fEWD$P  L$P  HH$   *Lt$pLt$xHt$HH^HHtH;tHtH;ts̄tiH;]t!HM   HtHHE Lu H]HHH+HLMIM~2(
 fffff     Hf(fWHE f)HI;|LHHL$@!H|$pIH\$xH$   H9$   v] H$   HD$0Ht$8(|$0)|$0L|$0Ld$8    H  uIHGH;  (D$pf$   HuHwH$   H$   H;0uHpf$   HuHGH$   H$   H;uHALpfD$`HuHGHD$hHL$`H;uHAHHD$HHl$PLmMufA(H$P  HL$@f(YvHl$ H$P  HD$(Lt$Ht$PIHH+HLM3M~9ffD  If(HE f(fYf\f)HI;|MHT$ HL$@gf$   MuÐ E3MME3M;cw It$H$   Hu MLI;s r} 6HuH_H;uH_H(H\$xMuS MMM;cw? LHt$8(|$0HW0HH  uIH_H$   HH;$   v H$   H$   HD$ Ht$((D$ fD$ HI  Hl$`H$P  HD$hLd$ Ht$(ffff     HCLkHD$HHl$PH} ufA(H$P  HL$@f(Y3Mu[ MM$I;s rF \Ll$HL$PLMIHH+HLMIM~>fff     IE f(fYHE f(fXf)HI;|HT$`HL$@H(H;_uHH;_IDMu MM$I;s r HHH$   Htu L$   L$   L$   H$   lu L$   I[8Ik@IsHA(sA({E(CIA_A^A]A\_D$SH`
 )t$P)|$@f/= HD)D$0D)L$ fEWf(fE(   f(\f(L$pf(At f(\f/
9 v
fA(\XfA.z%u#\LD$pH H
2 |$pD՟ AYf(s D^fA.zuLD$pHE H
2 f/5 rf(HytП f/v*ff     fA(f(\Xf/^DXwf/v*ff     f(fA(^Xf/\DXwf(H{(t$P(|$@D(L$ DXfA(D(D$0H`[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
y H LH1 L
 HD$ bfAn D$XHD$XH#H;u'H
3 H L
 Hn1 HD$ LA9 *H
 Hg L
X HY1 LHD$ H	 H
u	 Ht$PHHHj	 H;r"H
	    _H
E	 HHC	 LHH5	 H;rH
	    ^LHIPHIL;t3     HHH;ufnؓ HLD$ LIP^fnE \A YYf(Y\Y
 A A   X
 cHt$PH\$`IH0A\_]LD$SWATAVHxHB MIH+BHLHN  H
 )t$PfWLHG0 )|$@f(IH      fn+$   H$   H#H;u*H
G H L
 H0 LHD$ UA$f/w*H
 Hj L
[ H/ MHD$ $   H$   H#H;u*H
 H? L
 H/ MHD$ <LO H
 H$   L+OHt$pH/ LILl$hL|$`OHG H+GHHu HG H_   LL+IL;LFH
 H+HHD$0L,    H H$   IH H;r%H
- IE\H
 H$   H HIHr H;rH
 I\HHO E3H+OIHHtBL$   H;r1 L$   HGHHLILHO H+OHH;rE3L$   Ht$pIL- Ll$hHH;t LHH;u IA^$M   % L$   ff     fAn HcHP\f(f.f(fTY\XzuAf/v   D fnHY\D I;rLD$0f(IHl$ `L|$`(t$P(|$@H$   IHxA^A\_[fWj_IHxA^A\_[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
 HR LH- L
! HD$ \fAn D$XHD$XH#H;u'H
 H L
 H, HD$ Af/ w*H
u H L
 H, LHD$ H H
 Ht$PHHH H;r"H
E    [YH
 HH LHH H;rH
    &YLHIPHIL;t3HHH;ufnE 6 HLD$ LI^P\A YYf(Y\Y
n A A   X
 ]Ht$PH\$`IH0A\_]HHHUVWATAUAVAWH   HD$@HX)p)xD)@MMHHHB H+BH  Iy   fWLH+ H
 HfAn.$   H      H$   H#H;u*H HD$ L
Ѣ MH?+ H
 E3MIL$HtKI$Icf/v
IL;r/H HD$(H{ HD$ MH* H
- x[H=  H$   Ll$0LF L+FILD$8H$   HD$0HHDHD$8L;HBHLLH* H
JLMH* HHF H+FHHD$8H<    H LHH H
 H;r HH
 VLH H
 HHH H;rHH
P kVHIHN H+NHHt/@ H;r HFHIHHN H+NHH;rH/HH;tf     L(HH;uHF H+FHHu= H~I$Ln L+I   L;LFIt$L;LFHJi Ht
HL$HH3HD$H$   L$   HHL$H覻3I9t$vMD  Hc4HD$hHL$`H+HH;r HL$`fA(^HI;t$r3HM   HcHpfEnEHL$hHHT$`H+HH;r; HL$hHT$`A\Y4f(Y YXH+HH;r HT$`Y4D \D HI;g3Hl$ MLD$8f(H$   HYHL$`Htg Ht$`Ht$hHt$pHL$Hg HfWXHL$   I[PA(sA({E(CIA_A^A]A\_^]@UAUAVAWH   HB MIH+BLLH  I@ I+@H  H
 LH' )$   fW+H
t H' LMACf/w*H
O Hx L
i Hr' MHD$ VLE IU H$   L+EI+UH$   IHH$   H= L$   HT$@L$   HL$@E3)$   I;H$   Ld$HHCH%' MHHLEH& LLHEL$   H$   L\$0HD$(H$   HL$PMLIHD$ %IE I+EHHu~ HE I}H+EHHu~ Iu HM H]I+uHH+HHH;w
HH+H=N    H;HFI@^d f(HtyHT$xLD$pffffff      Ic\IHf(\HYf(YYYXf(\YAXAXL;rHD$`LL$XLD$Pf(IHD$ VL$   H$   ($   ($   H$   H$   IHĸ   A_A^A]]fWUIHĸ   A_A^A]]LL$ LD$VWATHpHD$(H$   ILHH\$    Ed HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@Hv*H;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt=c Ht$XHt$`Ht$hHL$@$c HH$   HpA\_^HAUAVAWH   HǄ$  HXHpHxL` )p)xD)@D)HD)PD)XIHLHx DfEWfE(й   b HtH$   HE3E3IH$   L$   L$   L$   H|$pH\$xL$   L$   HL$pfD(D$`HL$p$     8b Ht
H$   HIH$   L$   L$   L$   Mc   IH$   HM^   HL$p$   H$   HuIH$   H+HH$   HH+HH;sHAH$      HH;v2z H$   H$   H$   HHT$0H|$8HH+HuI*H;vy H$   HtH;ty H+H(D$0fD$PL$   A   HT$PH$   %H$   H;$   vy H$   Huzy MLHI;K wHtHIH;HsOy IHL$pHdw =ȋ fWfD.ztfD(EX_ AX$      4` Ht
H$  HIH$  L$   L$(  L$0  McoDIH$  FM]  fHL$pD$PH$   HuIH$0  H+HH$(  HH+HH;sHAH$(     HH;v5x H$(  H$   H$  HHT$0H|$8HH+HuI*H;vw H$  HtH;tw H+H(D$0f$p  LL$PA   H$p  H$  %H$   H;$(  vw H$  Huzw MLHI;K wHtHIH;HsOw IIc      t^ Ht
H$8  HIH$8  DD$PLD$PHH$8  ˰IH$X  HH$P  H+HHt;H;rv H$P  DHH$X  HH$P  H+HH;rIH+HHt;H;rv H$P  DHH$X  H$P  H+HHH;r       @ A;     i    HcH$   L$   I+H  G;  LsL;ru L$   I   A   L H8hCt Y0fWH$X  H$P  H+H|)G;}"HH;ru H$P  44   DBH$  s HE H$  (   Hs HT$pH$  ws LL$xH$   LCL$xH HD$ DËH
 U&   DBH$  s HŘ H$     Hr HT$pH$  r LL$xH$   LCL$xHs HD$ DËH
 %AA    ~4    HcH$X  H+$P  HH;r>t A;   |Ic_@   e[ Ht
HL$pHIHD$pDD$PLD$PHHL$pŭMĐH$   HH$   H+HL;sFII H+HH;sDHH$   H$    "   D$P   Dd$@D\$0HHD$0H#H      H;v+H+ HD$ L
 LD$`H, H
< DD$0HD$0H#H;u+H HD$ L
 LD$@H, H
 H|$`Ht$@H\$PfA(fA(M={ Isfnf(^?Y f(II5 % D  Hs0fn\YDXD\YYDXHDD$0H$   HuIH$   H+HH$   HH+HH;s,   H HtDHHHCH$   JH;vq H$   HD$`H\$h(D$`f$p  LL$0L$p  HT$`H$    #   D$P   Dd$@LD$PHT$@H$  wD$0H$   HuIH$   H+HH$   HH+HH;s)   HːHt
HHHCH$   JH;vq H$   HD$`H\$h(D$`f$p  LL$0L$p  HT$`H$    $   Dd$PMP  HT$PH$   D$0HT$0H$    %    D$0Dd$PLD$0HT$PH$   D$0HT$0H$   Jp &   Dd$PM@  HT$PH$  ҞD$0HT$0H$   
   D$  A;_@    *   HcA   L HI   cH$   Hf(IOHA   L HaLA   L HI   bH$8  H<f(I  A   L@ HbH$  HAXAYu AXXXA   L HHL$pja0% ,   IOxL$   HT$pD$0HT$0H$   H$   HtU L$   L$   L$   HL$pU DT$0HT$0H$   xH$   苴f(H$P  HtaU L$P  L$X  L$`  H$8  <U H$   Ht)U L$   L$(  L$0  H$  U H$   HtT L$   L$   L$   H$   T H$   HtT L$   L$   L$   H$   T f(L$   I[ Is(I{0Mc8A(sA({E(CE(KE(SE([IA_A^A]HL$VWATH0HD$ H\$XHl$`MIHHMHH6
f(HCH" HLc(3LL$pMueJ    H HHH H; rH
3 N@HHKHH9S(v7H+fff     HHHHH;S(rHSMILHwLL$xMumHS(HH> LHH1 H;" rH
 ?LLC H9{(v*fffffff     HK HD HHH;{(rHHHS MI LHMHH\$XHl$`H0A\_^LI E3L9A(v* KHAIBDYAXBBL;A(rHHq 3LL$XLD$`3)t$0)|$ D$XD$`_L5'n =~ fTf/vH H
' r) 3LL$XLD$`3҈D$XD$`LfTf/vHu H
 1 3LL$XLD$`3҈D$XD$`KfTf/vH4 H
  3LL$XLD$`3҈D$XD$`KfTf/vH H
d 诐N 3LL$XLD$`3҈D$XD$`KKfTf/vH H
# n 3LL$XLD$`3҈D$XD$`
KfTf/vHq H
 -(t$0(|$ HHH\$Hl$WH HZHHHHtH;tٗHtH;tė̄t躗Ht$03H;_tHKi Ht
H6HH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHHmHt$0H\$8Hl$@HH _H(Y~ 3LL$0LD$83҈D$0D$8If(fT
}k f/
e{ vH H
 ЎYz H(H(Y} 3LL$0LD$8D$0D$8YIf(fT
k f/
{ vH H
E pYz H(HATAUAVH`HD$ HXHhHpHx LHٹ   
O E3Ht
HL$(HIHD$(Ll$@Ll$HLl$PE3E3HT$(HaHL$(cIH|$HHH\$@H+IgfffffffIHHHH?H   IH;r?g H\$@H+I$IPt2HH(H|$HHH\$@H+IHHHH?HH;rRH\$@Ht+H|$HH;tfHe H(H;uH\$@HM Ll$@Ll$HLl$PHL$(M 2DHt$H;tHe H(H;uH\$@HM Ll$@Ll$HLl$PHL$(~M L\$`I[ Ik(Is0I{8IA^A]A\H\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$G@I;       HtHCHtL@E3ItIP3H	tHB3H@HfHtHB3H@Hff\MtIE3A@(HE HI;ffYf)ToLMHHH\$@Hl$XH A\_^|H;  WATAUAVAWH@HD$ H\$pHl$xH$   HLLi3MuH9HL;vՒJ<    Hsd HHuHt豒Ht$(Ll$0I|$IHtI;t胒HtI;tn̄tdI;t(Hc HtHHHD$(HH\$(H|$0HHH+HLMHM~     I$f(f)HI;|LMHT$(IgLuMtM;t͑MtM;t踑̄t讑M;t$t!I$Dc MtI/I$I$Mt$IHH+HLMHM~"    HE f(I$f)HI;|MIHfHt$I;t#̄t̄tH;}t!HM b HtHHE H] H}M~f(HE f)HI;|LMHHL$(tfHRb H\$pHl$xH$   H@A_A^A]A\_H\$Hl$WATAUH HZLLHHtH;tEHtH;t0̄t&Ht$@3I;\$t$IL$a HtHID$It$HI\$HH+HLMM~'     IEMT$HI;f(DfA)D|IT$IML`eM]Ht$@H\$HHl$PM\$IE ID$ IH A]A\_@SH HH      D$0HD$0H#H;uH H
@ Lf/i rHG /G f/ f(w f/w
,H [Hd H
M L草HHHVWATAUAVH  HǄ$   HXHhIILL   pG E3Ht
HL$@HIHD$@Lt$XLt$`Lt$hLNHD$pLt$x(D$pf$   L$   H$   HL$@HT$XHuIHL$hH+HH\$`HH+HH;sHF HHCHD$`FH;v_ HD$@HD$pH\$x(D$pf$   LN L$   H$   HL$@芖HE HT$@HPLt$pLt$x   DBH$   R] LFH$   HD$0D$(D$ LL$pIH$   IH$   H$   #] Hx H$   ] t3H$   H$   \ IMLHAH$   ] E3Lt$xMj  Hl$pHL$`H\$XfD  Hu3HT$hH+HHH+HH;sHE HHHL$`H\$X  HH;v^ HL$`H\$XHt$@H$   H$   HH+Hu3$H;v] HtH;t$@t] H+H($   f$   LA   H$   HL$@lH\$XLHL$`H;v{] HL$`H\$XHt$@Hua] E3HL$`H\$XHD$@LII;S wHtH3H;Ps(] HL$`H\$XAHIcI;H$   H	HHT$@PH$   >[ HL$p\ HL$XHtC E3Lt$XLt$`Lt$hHL$@C L$  I[8Ik@IA^A]A\_^HL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;v覊H    HD\ HHuHt肊HHwI\$HHtH;tWHtH;tB̄t8H;t[ Ht
H迻HH/H_HHH+HLMM~I$f(Hf)HI;|LHI_IT$HOHH\$XHl$`H0A\_^H   HLD$(I HAI@HAI@HAI@HA HL$PI@ HHHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@H|$X ufWHĨ   H$   HL$ 荴HĨ   HHXWH   )p)xD)@Af(f(f   fD)HD)PD)XD5c fD(fD(DYDYD)`fDW
l E^fD(f(YYl @ Y=\o 3L$   L$   3fD(f(DYƈ$   $   DY[o :f(fT
\ f/
l vH9 H
 Yl A^f(X5sb f;v5fD  ffnYfA(EY\AYXf;rDYl fA(? (|$pL$   I[E(CE(KYn YE(SE([E(cA(sI_LH   E)K3fD(Y"n E)SE)[MKMCACACfD(9f(fD(fT
{[ f/
ck vH H
 ~)t$p5j )|$`D)D$PDYD7a fA(A\EXfA(f(> E\fD(EYDYfWf.zt5AYAYY=j ^f(m> AYYnm \DX(|$`(t$pD(L$@fA(D(D$PD(T$0D(\$ HĈ   H\$H|$Lٍ   A   AHp     H   AEAAAHHiN  HHH+HHHHiH+HAEKMi  IIH+HHHHiL+EKD;sA+	A+ɁAEtAH;wH\$H|$A#H\$Hl$WH H*HHH]HtH;tHtH;t̄tڄHt$03H;_tHkV Ht
HVHH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHH&ZHt$0H\$8Hl$@HH _%0 f(LIp     I   \f     EIMiN  IIH+HHHHiL+IEAIHi  HHH+HHHHiH+AIA;sD+
D+AfAHH*^YXf/mH\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$GpUI;       HtHCHtL@E3ItIP3H	tHB3H@HfHtH3JffYMtIE3AH HE HI;ffYf)TkLMHHH\$@Hl$XH A\_^THH   )p)xD)@f(f(D)HD)PD)XD
Y\ fD(fE(DYD)`D)l$ fD(fD(DYf(E^YYe 9 Y=~h 3L$   L$   3fD(f(DYƈ$   $   DY}h  4f(fT
U f/
e vH[ H
̷ yY>e fe H    A^f(Y5 X5y[ AYHHDXA\EYAYf(YXuDY%e fA(8 D(l$ L$   A({E(CE(KYg YA(sE(SE([E(cIH\$UVWHPHBBJ HD$0HHD$8L$@HHxH|$ptH#HHD$pHL$xHڃH;HT$xHMHHHL$ LH+E3HH+HHH,CSH;}XD$8HT$0D$@ff HHH;fDHfYHfYfXDf)D|HL$ LLHqSH$   HHP_^]@UATAUH`Hl$PLaH]0HID$Hu8HH}@L)u A0H;v~I$HuLH<    H      H   HHH;w
HHH? H+HL$PHHID$HSLt$@3HD$8   LI94$HDHH=   IE HD$0HD$(   HL$ HK@-@t	HO H]0Hu8H}@(u HeA]A\]HO HHmHd}@UH`Hl$PH] HYHu(HCH}0H9Le8L)u qHAY0H;v}HHuLH4    H      H   HHH;w
HHH> H+HL$PHHHCHWLt$@3HD$8   LH93HDHH=   I$H HD$0HD$(   HL$ HOt	HN H] Hu(H}0(u Le8He]HzN HHnHe|HM;ML   HH$H MtIBHtHH3HtHA3HatL@E3HtHP3I@BYJpHtHA3H	tHP3HtHH3HBIM;BDYAPXBXDBD\H$HATHPHLLL MAvHPA\隉Hl$@HhH|$0Ll$(Lt$ LpH@ Hl$xHl$`HH3H+LIAMtH$IHD$`HL$pIAI;LD$pHMH8E3M;  H\$HHt$8    L3L+ILH   M$HwMtIAHtHX3IH I CIHYMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHHH;YDD!H;}AI$MtIAHtL@E3HK HA@IHHH;Y|I;H}ZfMtIAHtHH3II$IL@ HHH fHMf(LHI;fYfB)|L;}?M$MtIAHtHP3IH I BIIIL;Y|J/HL$xHH3H+HT$`H;HD$`HMIM;H9Ht$8H\$HLl$(H|$0Hl$@Lt$ HPA\@SH HID$8    HTHH [HL$UVWATAUHPHD$ H$   LHHj3HuH9HH;vUxH4    HI HHuHt1xHHoIt$IHtI;txHtI;tw̄twH;tI Ht
HnHHHwHHH+HLMM~I$f(Hf)HI;|LHIDMI\$H\$0H\$8HwH$   HHLLHH	HtWHtIHHH;t.wHtIHHH;twHtIHHH;tvLLHHHT$(H,ID$G(HH$   HPA]A\_^]H\$Hl$WH HLH, HPH]HHtH;tjvHtH;tUv̄tKvHt$03H;_tHG Ht
HǧHH7HH_HH+HLMM~!D  HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _KH\$WH HLHI HPLGLOHMt\MtHHIL;tnuMt:Mt5HHIL;tLuMtHHIL;t/uIHKILK E3LKIHH+HLMM~*ffff     HHKIM;fB(DfB)D|HSHH\$0H _|JHl$Ht$WHPHcq()t$@fWHHt$8Ht$(Ht$H;tht̄t^t̄tTtH\$`3H;qtH	E Ht
HХHHHHwHHH+HLMM~(? @ HHI;f)D|HL$ LHpLcG(t$8LD$(LD$0MtWMtHHIL;tsMtHHIL;tsMtHHIL;tosIHOMI[LO LOIHH+HLMM~(? D  HGHI;f)D|HWHL$ oH\$`Hl$h(t$@Ht$pHP_Hl$Ht$H|$ ATH0B(DA(HH
r HL
 HѾ D$  H}IHtI;trHtI;tyr̄torH\$@3H;~tH D Ht
HHHHH~HH+HHLMM~"fD  HE HHI;f(Df)D|LHHGLELM MtMtIHIL;tqMt:MtIHIL;tqMtIHIL;tqIHNI}LN LNIHH+HLMM~,ffffff     HELVHI;f(DfA)D|HVHMFH\$@Hl$HH|$XHHt$PH0A\H\$Ht$WH@B(DA(HH
 HL
 H D$ LOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0H肩LO L_MKHD$PL\$0HD$8IHNHH+HLMM~-ffff     HIHI;f(DfXDf)D|HT$0H\$XHt$`HH@_H\$Ht$ WH@B(DA(HH
x HL
 Hǻ D$ HD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$P9HNHD$XHD$0HL$XLIHD$PL_LIHD$8IL\$PHH+HLMM~,@ HIHI;f(Df^Df)D}HL$XHT$0HL$P蹯H\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ LO L_t$0MKIL\$`HL\$(H+HLMM~.ffD  IHI;f(DfXf)D|HT$`HL$ eH\$hH(t$@HP_H\$Hl$Ht$ WH0A LBHH
+ HL
9 H D$  H]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t5lH
 HRg H HD$(H] LHD$ *HtH;tlH;^tH=> Ht
H(HH>HH^HH+HLMM~"fD  HE HHI;f(Df)D|LHHH\$HHl$PHt$XH0_AH\$Hl$Ht$ WH0A LBHH
Î HL
Ɋ H D$ H]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t5ykH
9 He H; HD$(H[ LHD$ HtH;t5kH;^t!HN< HtH跜HFH~HH^HH+HLMM~  HE HNHI;f(Df)D|HVLHH\$HHl$PHt$XH0_p@Hl$Ht$WHPHcq )t$@fWHHt$8Ht$(Ht$H;thj̄t^j̄tTjH\$`3H;qtH	; Ht
HЛHHHHwHHH+HLMM~(5 @ HHI;f)D|HL$ LHfHcw t$8Ht$(Ht$H;tītītiH;wt!HO>; HtH)HGH_HHwHH+HLMM~(.5 HGHI;f)D|HWHL$ L*fH\$`Hl$h(t$@Ht$pHP_Hl$WATAUH0B DA HH
ы LL
' H D$ 7I|$IHtI;thHtI;th̄thH\$P3Ht$XH;}t!HM 0: HtHHE H] HH}HH+HHLMM~!@ I$HM HI;f(Df)D|LHI=It$HtI;thHtI;tḡtgH;ut!HM9 HtHoHEH]HHuHH+HLMM~*fff     ID$LUHI;f(DfA)D|HUIL$L0=H\$PHt$XHHl$`H0A]A\_H\$Ht$WH@B DA HH
 HL
V H7 D$ fLOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0HҟLOL_HD$PL\$0HNHD$8IHH+HLMM~"HIHI;f(DfXDf)D|HT$0uH\$XHt$`HH@_H\$Ht$ WH@B DA HH
  HL
F H' D$ VHD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$P虦HNHD$XHD$0HD$PHL$XLIHD$8L_IL\$PHH+HLMM~1f     HIHI;f(Df^Df)D}HL$XHT$0HL$PH\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ 5	LOL_t$0IL\$`L\$(HH+HLMM~3ffff     IHI;f(DfXf)D|HT$`HL$ H\$hH(t$@HP_HL$WATAUH@HD$0H\$hHt$xHHٹ    HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;vakHHK蔌HCHC HvHHHK(Hw H9wv4 LgL;g v4 3D$(D$pD$ LKLCHI[YHC HH\$hHt$xH@A]A\_Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?LuHH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ Mb|LG HHC<HN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ {LG HV 3LOHˈD$(D$@D$ dHG HMtMIHu;HO HN IH+NHHHHH?HtLOLF HVH;HG HmHHt$XH0_H\$Hl$Ht$H|$ ATHPHA0IIH(I LHHtH;t@2 H9kujHHn0HtH;t#2 H9ouMHV0HHR8L^0M[HF0HF8    H HF0H@HF0HHI$IL$   fD  HHtH;t1 HGH9CHt7HL$ HHCHAHLD$0HT$@(l$ fl$0H;2HL$0HHCHAHD$8HL$ HD$(HHD$ HI$HAID$H\$`Hl$hHt$pH|$xIHPA\H\$Ht$WH HY0HHR0HRLH视HCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _LSHPHHA0MKICH IS(D$ fD$ ISICMC(L$0fL$0ISHHK0 E3L[0L[8HP[H\$Ht$WH HY0HHR0HRLH臉HCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIH- tHH[    tIM HHL$0HD$8@tTIE0HHtH;tz. H;u)AHT$0LILd$ 譄EHH@HM :HL$0fHD$8HHI, tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIH`, tHH[    tIM HHL$0HD$8@tTIE0HHtH;tZ- H;u)AHT$0LILd$ 譇EHH@HM :HL$0dHD$8HHI+ tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$WH@)t$02)|$ 9HHf/vH\f/55 f(v!fW.?  HT$P蟋XXW HT$P膋XB\f/=L5 f(vfW>  HT$PWX HT$PBXH\$X(t$0(|$ H@_@SH   MH$   L$   )t$pf(IHLHT$@HD$ AR0LK Ht$`LH$   H\$0HD$8IL\$XHH+3HLMM~=f     IHf(HI;fYDf(Lf\f)L|HT$0HL$PȥHL$@5+ (t$pHĀ   [H\$UVWH0Hq HH9qv* H_H;_ v* H9_wH;_ v* H/H9wwH;w v* HtH;/t* H;tsDL$PHW 3D$(D$PLHΈD$ AHw HH;t?Ld$XHXE3HHtx HKL#LcLcd H0HCH;uLd$XHo H\$`H0_^]H\$
3 LH   Ip     ffff     MIEMiN  IIH+HHHHiL+HEAHHi  HHH+HHHHiH+AHA;sD+
D+AfAIH*AYBf/pH\$HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HHHSPH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKPHHf(X$   HH$   H#H      H;vH& (f($  \f/   vƃ   \$   H$   H$  HHf/51 vH$   X0  f(i H$  X  H;t/HVHOlL^(L_(HVHOkHV0HO0kL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   袎H$   LLH$   HAS(HHXHtHH;t@UHHtH;t!ŪtUH;]t!HM & HtH虆HE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHh*H$   A& HuHtHH;twTHHtH;tXT̄tNTH$  H;stH% Ht
HɅHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHH)H$      I  HY(HSH$   H$   Hl#  57 fW$   H$  H[H$   fW$   HLH$   H$   HHt$H;t)S̄tS̄tSH$   HHH+HLM3HM~*( ff     fA)HI;}
L$   LH$   H$   OF$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   # H$   # 2i  HSH$   )H!  fW$   H$  HXH$   $   A   LHHL$pBHt.HH;tcQ̄tYQ̄tOQH;\$xt$HL$p" HtHςHD$pH|$pH\$xHHH+HLMHM~( HD$pf)HI;|LHT$pH$   MH$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$p! H$   ! H$  ! H$   ! H$   ! H$   ! 2v  H$   H$   f($   H$   H$  H$   f/vH$   H/4\ f(H$  Hhf/vH$   HH$   H$   HD$pH$   A   HT$xLH$   H\$xHtHH;tNHHtH;tN̄tNH;$   t-H$   c  HtHNH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   Y`H$  H$   H$  H$   H$   H$   *H$  LL$   L$  HHASHH$   u HL$pi H$   Z H$  L H$   > H$   / H$     L$  I[8A(sA({E(CE(KI_^]@SH H      Hf.' H   zt9Hx
' Y\1 \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HXHS`H$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HK`HHf(X$   HH$   H#H      H;vH (f($  \f/   vƃ   \$   H$   H$  Hhf/5$& vH$   X&  f( H$  X  H;t/HVHO%aL^(L_(HVHOaHV0HO0aL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;t`JHHtH;tAJ̄t7JH;]t!HM  HtH{HE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$   a HuHtHH;tIHHtH;txĪtnIH$  H;stH Ht
HzHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHH$      I  HY(HszH$   H$   H  5, fW$   H$  H[H$   fW$   HzLH$   H$   HHt$H;tIH̄t?H̄t5HH$   HHH+HLM3HM~*( ff     fA)HI;}
L$   LH$   H$   DF$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$    H$    2i  HSH$   H  fW$   H$  HXH$   $   A   LHHL$pbHt.HH;tF̄tyF̄toFH;\$xt$HL$p HtHwHD$pH|$pH\$xHHH+HLMHM~( HD$pf)HI;|LHT$pH$   BH$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$p H$    H$   H$    H$    H$    2v  H$   H$   f($   H$   H$  H$   f/vH$   HO4\ f(H$  Hxf/vH$   HH$   H$   HD$pH$   A   HT$xLH$   H\$xHtHH;tDHHtH;tC̄tCH;$   t-H$    HtHnuH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   yUH$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$    HL$p H$   z H$  l H$   ^ H$   O H$   @ L$  I[8A(sA({E(CE(KI_^]@SH H      Hf. H   zt9H
 Y|& \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  H`HShH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKhHHf(X$   HH$   H#H      H;vH (f($  \f/   vƃ   \$   H$   H$  Hf/5D vH$   X&  f( H$  X  H;t/HVHOEVL^(L_(HVHO0VHV0HO0#VL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   xH$   LLH$   HAS(HHXHtHH;t?HHtH;ta?̄tW?H;]t!HM  HtHpHE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$    HuHtHH;t>HHtH;t>̄t>H$  H;stH Ht
H	pHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHH$      I  HY(HoH$   H$   H
  5" fW$   H$  H[H$   fW$   H:oLH$   H$   HHt$H;ti=̄t_=̄tU=H$   HHH+HLM3HM~*( ff     fA)HI;}
L$   LH$   H$   9F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   
 H$   
 2i  HSH$   H  fW$   H$  HXH$   $   A   LHHL$pHt.HH;t;̄t;̄t;H;\$xt$HL$p$
 HtHmHD$pH|$pH\$xHHH+HLMHM~( HD$pf)HI;|LHT$pH$   8H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$p$ H$    H$   H$    H$    H$    2v  H$   H$   f($   H$   H$  H$   f/vH$   Ho4\ f(H$  H/f/vH$   H9H$   H$   HD$pH$   A   HT$xLH$   !H\$xHtHH;t=9HHtH;t9̄t9H;$   t-H$   
 HtHjH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   JH$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   	 HL$p	 H$   	 H$  	 H$   ~	 H$   o	 H$   `	 L$  I[8A(sA({E(CE(KI_^]HHHWATAUAVAWH   HǄ$   HXHhHp )pMLHٹ    Ht
HL$ H3HD$ HD$8    HD$@    HD$H    IVHL$ {E3M9nt  E3HL$@H\$8II,Hu3HT$HH+HHH+HH;sHE HHHL$@H\$8  HH;v- HL$@H\$8Ht$ H$   H$   HH+Hu3$H;v HtH;t$ t H+H($   f$   LA   H$   HL$ ,H\$8HHL$@H;v HL$@H\$8Ht$ Huz E3HL$@H\$8HD$ LHT I;S wHtH3H;Ps@ HL$@H\$8AIIcI;FH$      P Ht
HL$PH3HD$PHD$h    HD$p    HD$x    MLD$PHT$ Hڊf(HL$hHt HD$h    HD$p    HD$x    HL$P HL$8Ht HD$8    HD$@    HD$H    HL$ y f(L$   I[8Ik@IsHA(sIA_A^A]A\_LVWATHPHD$@I[IkIHLI@ I+@HLJ L+JIICHM ICH8 ISLrM H
[M L| II0L| L;| r0   H
,| GHHt$pHt^H_ H+_HHE H+EHHug HmHG H+GHHuL 3HD$(HD$ LLHWH3I$IH\$xH$   HPA\_^HATAUAVH   HD$ HXHhHpHx )p)xD)@IMHLHHuHW H+WHfWHl:3HG H+GHHM  $   fD(DY. L$   fD  HD$HHL$@H+HH;rD HL$@f(XMMHT$(I.f(HG H+GHH;r HwHD$HHL$@H+HH;r HL$@\MMHT$(I͇\A^HE H+EHH;r HE4HG H+GHH;r} HwHD$HHL$@H+HH;r] HL$@HHHHG H+GHH;HL$@HtE HD$@    HD$H    HD$P    HL$(  L$   I[ Ik(Is0I{8A(s(|$pE(CIA^A]A\H\$Hl$Ht$H|$ ATH   Hj3MHHH   HtHS3HC HHtH3HHL$PLD$HHHBHt$8HAHBHAHBHVHAHHD$pHHHT$(HT$@HL$ HT$ I՛HH;nL$   I[IkIs I{(IA\H\$Hl$WH HZHHHHtH;t	0HtH;t/̄t/Ht$03H;_tH{ Ht
HfaHH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHH6HUHOYHt$0H\$8Hl$@HH _H\$D$WHp)t$`)|$PD)D$@fEWIHfD/f(D)L$0D
	 fA(;  % f.zuW   !   H    ~ f/   f(LHfW `f(f(Yf(fT
# fD/vqY
  f/v[fA.zu3(H       $      H$   E  "   Hd fnY %  5K} ^fA.zu
fA(  f(f(  fD/v ^AXfD/w$   f(D)T$  f.z3u1| f/v#H$   H"H
 Y<   f/v=| f/v  "   H 8D^D\
 AY4  H$   $   .DE fD(DX
? YE\fA(" 
| Yf/   AYf/v
fA.zZuX3|AYfA(\5tH f( f(fA(  f(^^Yf/v{fA.zu3(H       $      H$   E fn "   Hk Y -A\fA(f(J f(fA(* ^Yf(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_H\$D$WH`)t$P)|$@D)D$0D7 IHf(fA(D)L$ fEWfD/    f.zuH
VN LD$pH2 }Oz f/   f(LHfWx cf(f(Yf(fT
 fD/v*Y
  f/vH
M H "5z ^fA.zu
fA(  f(譀f(  fD/v#fffff     ^AXfD/wt$pf( f.z0u.y f/v HL$pHH
 Y<7   f/v:]y f/vH
M H	` "D^D\ AY   HL$pt$p+D
 fD(DX YE\fA( 
Q Yf/vzAYf/vH
L H& !AYfA(\5FE f( f(fA( 
 f(^^Yf/v9H
2L H >!A\fA(f(^ f(fA(> ^Yf(H\$x(t$P(|$@D(D$0D(L$ H`_HHXHpWHp)p5T )xHHp     H   D)@D)HD)PD Dr D
 HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\ f(AY^=2w ff     HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\j f(YAYAYf/X=pv (t$`L\$pE(CE(KE(Sf(I[Is(|$PI_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;t&Mt5HHIL;tl&MtHHIL;tO&IHI?XLK3LKIHH+HLMM~ (     HHI;f)D|HL$ H"LD$XH-q  l$XHӽH\$PH@_H\$Hl$Ht$WH@HH   H)t$0)|$ 菟4   =x fH*Y5x fff        HSHDfI*Xf(YH5rҺ   H%H\$Pn(|$ Hl$XfH*HX(t$0Y#	 Ht$`H@_H\$Hl$H|$ ATH H*HLH]HHtH;t$HtH;t$̄t$Ht$03H;_tH Ht
HUHH7HH_HH+HLMM~'fff     HE HHI;f(Df)D|LHHIT$HOȞHt$0H\$8Hl$@HH|$HH A\H( f(f(YYf(\f/w vY H(D
x f(f(H(7H\$Hl$Ht$H|$ ATHpHj3MHHH   HtHS3HCHHtH3HBBHVHHD$XHL$hD$`HHHT$(HT$@HL$ LD$HHT$ IHt$8WHH;|L\$pI[IkIs I{(IA\H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tI"Mt5HHIL;t,"MtHHIL;t"IHISLK3LKIHH+HLMM~ (     HHI;f)D|HL$ HLD$XH-1 l$XHcQH\$PH@_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;t)!Mt5HHIL;t!MtHHIL;t IHIRLK3LKIHH+HLMM~ (     HHI;f)D|HL$ HLD$XH- l$XHUH\$PH@_HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;t H;t!HI HtHQHEH]HHuHHH+HLMM~( HEHI;f)D|HUHL$ LLE LM(t$8LD$(LL$0MtWMtRIHIL;tcMt5IHIL;tFMtIHIL;t)IHMIQLM(LM IHH+HLMM~( fHEHI;f)D|HUHL$ H\$`Hl$h(t$@Ht$pH|$xHPA\HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;tLH;t!HI HtHOHEH]HHuHHH+HLMM~( HEHI;f)D|HUHL$ LHu t$8Ht$(HtI;tH;t!HMQ HtH<OHEH]HHu HH+HLMM~(A HEHI;f)D|HUHL$ L<H\$`Hl$h(t$@Ht$pH|$xHPA\HWATAUH   HD$`HXHhHp LLXz HPHiHhHu3HuL9HH;vH    HT LHuHtLD$ Ht$(H]HHtH;teHtH;tP̄tFH;t(I HtHMLHD$ LH|$ H\$(HHH+HHHLH~4ff     HM IE fB(fB\fC)IL;}LD$ LLHT$ HL$@A$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMM~3ffD  HD$ f(HE f^fXf)HI;|HT$0HL$@<yLl$HHl$PHD$ HD$pHT$xHL$@HHHAHBHAHBHAHBID$HD$0H$   HD$8HT$hHL$0MHL$ g L$   I[(Ik0Is8IA]A\_@WHP" )t$@1Hf/   H\$`HY Hl$h\t$0HiHHl$(HtH;t=HtH;t(̄tHt$p3H;ZtH
 Ht
HKHH7HH_HH+HLMM~,fHE HI;f(DHf^f)D|HL$ LH|Ht$pH\$`Hl$h(t$@HP_HL$VWATHPHD$ H\$xH$   HcL Hm I$H3HuH6HH;v!H4    H HuHt ID$@Il$HHl$0x D$@Ht.HH;t̄t̄tH;t$IL$@G HtH2JID$@I\$@Il$HHHH+HLMM~( @ ID$@f)HI;|LIT$@HL$(+IH\$xH$   HPA\_^HATHP  HD$HHXHhHpHx LHHl HL$ s I$HT$ IHL$ x    DƍVHL$P HE@HL$` H9uH~:~D  H]@Hk HL$`BH HHcH;EH|HT$ HL$P> M$HIAHL$  HL$P  L$P  I[IkIs I{(IA\H\$WH HH HO  H\$0L= LH _HWATAUAVAWH   HD$ HXHhHpHHHIHB H+BHH;tZHN6 HL$( HL$P? H/ HD$PHT$(HL$h HZ HD$PHvV HL$P HGH9GuZH HL$( HL$P H HD$PHT$(HL$h H HD$PHV HL$P 3H   HI*    HE H+EHH;r) LuHO@H+O8IHHHH?HH;r Lg8LoJD& J+D&HL;r JL&IJHH0H;_rHGL$   I[0Ik8Is@IA_A^A]A\_H\$Ht$WH HH HN  L+ L@tHn H\$0HHt$8H _H\$Ht$WH HZi HHH@   H  +H   H   Ht H   3H   H   H   H   H    H   Ht HOxH   H   H    HO`Ht HOHHw`HwhHwpm L*@ LHO(HtU HOHw(Hw0Hw8H\$0Ht$8H _1 H\$WH HtH HH\$0H _HL$WH0HD$ H\$HHHٹ    HtH3HHHC0ƀ   HC0H@HC0H HC0H@HC8    HHLHH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MCxHHͲHH\$`HP_HL$WH0HD$ H\$HHHٹ    HtH3HHѣHC0ƀ   HC0H@HC0H HC0H@HC8    HH|HH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MChHHHH\$`HP_Hl$ VWATHPHy8 IMHHuLL$ LI0A8  HA0H\$pHI HtH;tk IT$H;u2HH <  ML$AHHHl$ 8=  I$H_0HtH;t IT$H;u=HG0HHHH   LO0E3HMIHHl$ %8  HH tzI$HL$0HID$HAHL$0`H\$8HHKN tEHC    tLE3HHHl$ 7p  ML$AHHHl$ 7S  IL$HH   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?u H\$8    t WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0tr L$   I;Lt$xtHSH t?ML$IA    tE3HHHl$ z66LAHHHl$ b6HT$0LHHHH@HFH\$pHH$   HPA\_^Hl$ VWATHPHy8 IMHHuLL$ LI0A:  HA0H\$pHI HtH;t{ IT$H;u2HH$ <  ML$AHHHl$ 9=  I$H_0HtH;t' IT$H;u=HG0HHHH   LO0E3HMIHHl$ U9  HH tzI$HL$0HID$HAHL$0pH\$8HHK^ tEHC    tLE3HHHl$ 8p  ML$AHHHl$ 8S  IL$HH   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?u H\$8    t WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0t L$   I;Lt$xtHSH# t?ML$IA    tE3HHHl$ 76LAHHHl$ 7HT$0LH HHH@HFH\$pHH$   HPA\_^LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;s}L2I;l  HHH+H;sIHI;IBHIL$3HHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   H!yD$0   3D$($   D$ ML$LIVIL$D$0   HD$8HL@IL3D$($   D$ ML$IT$ INaML$IL$ I+IHHHH?HHMtMD$ IIgIL$ H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PHvHINL3D$($   D$ ML$IT$ MT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHIwI\$ I|$ H+I^H;tHT$PHsH0H;uHL$hHt Ll$hLl$pLl$xHL$P    IHL$P0I|$ H4vHHH+3ML$D$($   D$ LHHID$ LHINs   I^H<3H;tfD  HT$PHH0H;uHL$hHt' Ll$hLl$pLl$xHL$P HĀ   A_A^A]A\_^[H\$Ht$WH0DL$@3ID$(D$@HD$ H>H+H\$HH*HHHH?HHRHH+HHt$PH0_Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?LuHH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ MbwLG HH#HN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ vLG HV 3LOHˈD$(D$@D$ HG HMtMIHUHOؽ HN IH+NHHHHH?HhtLOLF HVHtHG HmHHt$XH0_@SH HAx   Hf.; H   zt9Hh
 Y \Y   XY      H [HL$WH0HD$ H\$HHt$PIHHHY HHRH HFXH^hH6 HF`H~pH~xH 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH H HHA`HIH$ HO8 HO  HO Lo LtH HH\$0H _HHPHHWATAUAVAWH@  HǄ$  HXHp )p)xIMLH 0H~K HHHpK H;aK r   H
J HHLK H$   Htf(6H3H*K 3HHHHK H;K r   H
J 諧HH$   HtfWf(ުLHD$8LHt$8fWL$       Ht
HL$pHHHD$pH$   H$   H$   L$x  H$  H$  H$  HT$HH$x  L\$HL$h  HT$HH$x  L\$HL$p     _ Ht
H$   HHH$   H$   H$   H$   Ic   H\$PHH$   ^H  \$0HT$@H$x  >L$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$@PIM]L$      MM;v5 L$   L$   H$   LHL$`Lt$hII+HuL*M;v H$   MtL;t M+I(D$`f$  LL$@A   H$  H$   L$   L;$   v L$   Muz LM$KL I;K wMtI$HH;HsL Hl$PLl$8L$p  HT$8H$x  HH\$HHB  = fWf.z   HG LH(HG H;G r(   H
\G wLL$   Mt*KAXMI褧Ml$I\$ H< I$LL$   HT$HHL$@胮Hf(HL$H"H\$HH\$H   获 Ht
H$   HHH$   H$   H$   H$   Ic_DH\$@HH$   H  \$0fHT$8H$x  nL$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$8PI$M]L$      MM;ve L$   L$   H$   LHL$`Lt$hII+HuL*M;v" H$   MtL;t
 M+I(D$`f$  LL$8A   H$  H$   L$   L;$   v L$   Mu LM$KL I;K wMtI$HH;Hs| Hl$@L$p  Ic      藵 Ht
H$  HHH$  Ht$8LD$8HH$  	HH$(  HH$   H+HHt9H;r H$   H<HH$(  HH$   H+HH;rHH+HHt>D  H;r H$   H<HH$(  H$   H+HHH;r"    A       E;     "    IcL$   H$   L+IE  AD$;8  LsM;r
 H$   JHD$8L$(  L$   M+I|rAD$;}iL{M;r L$   H$p  H   A   L= H	fWLD$8HL$@RH KAL$p     DBH$    H< H$0  &   H	 H$x  H$   k L$  H$  LC$  H; HD$ DAH
 B}   DBH$    H H$0  %   H H$8  H$    L$@  H$X  LC$@  HW: HD$ DAH
 |A       H$   LcH$(  H+HL;r" H$   J< tA;   |      DBH$   $ HlO H$0  $HȲ["Hȋ HȲ]"H$8  H$    HH$   Hi H$  HH$   H; H$  菱 Ic_@   茱 Ht
H$8  HHH$8  Ht$8LD$8HH$8  LƐH$X  HH$P  H+HL;s	J<IHD  H+HH;sH<HH$X  H$P   "   D$P   t$@LL$PLD$@H$h  HL$8=LH$   HuHH$   H+HH$   HH+HH;s83D$(D$0D$ L$   Mƺ   HǠHCH$      LH;v H$   H$   HL$pLHL$`Ld$hHH+HuL'H;v HL$pMtL;t L+I(D$`fD$`MA   HT$`HL$p
H$   H;$   vq H\$pHua LLJI;K wHtHHH;Hs6 l #   D$@   t$PLL$@LD$PH$p  HL$8;LH$   HuHH$   H+HH$   HH+HH;s83D$(D$0D$ L$   Mƺ   HBHCH$      LH;v H$   H$   HL$pLHL$`Ld$hHH+HuL'H;vC HL$pMtL;t. L+I(D$`fD$`MA   HT$`HL$p$H$   H;$   v H\$pHu LLJI;K wHtHHH;Hs  $   t$@MP  LD$@H$   HL$8<HHL$p %    D$8t$@LL$8LD$@HT$HHL$Ps?HHL$pfl &   t$@M@  LD$@H$   HL$8:AHHL$p-        A;@h   *   HcI  A   L= HL$   HHL$8xLL$p  M   A   L= HI޸L$  HHL$@9L$p  HHL$PdLIMHA   L@= H訷LA   L,= HI}L$   HH$  վL$h  HH$  AU HH$  נMHH$  ԞMHHL$`ĞLA   L< HH$8  I$HL$p   ,   IWxLL$HL$8  HL$`	DHHL$p|H$P  HtU H$P  H$X  H$`  H$8  0 H$   HL$p1HT$pH$x  ḤH$   Ht H$   H$(  H$0  H$  Ъ H$   Ht轪 H$   H$   H$   H$   蘪 H$   Ht腪 H$   H$   H$   H$   ` H$   HtM H$   H$   H$   HL$p+ HL$@  I[@IsHA(sA({IA_A^A]A\_HHPHHWATAUAVAWH@  HǄ$  HXHp )p)xIMLH 0H9 HHH9 H;q9 r   H
8 HH\9 H$   Htf(FH3H:9 3HHHH%9 H;9 r   H
8 軕HH$   HtfWf(HfWH$       Ht
HL$`HHHD$`Ht$xH$   H$   L$p  H$x  H$  H$  HT$HH$p  L\$HL$h  HT$HH$p  L\$HL$`      Ht
H$   HHH$   H$   H$   H$   Ic   H\$@HH$   ~H  \$0HT$8H$p  ^L$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$8PIM]L$      MM;vU L$   L$   H$   LHL$PLt$XII+HuL*M;v H$   MtL;t M+I(D$Pf$  LL$8A   H$  H$   L$   L;$   v L$   Mu LM$KL I;K wMtI$HH;Hsl Hl$@L$p  HT$8H$p  	H HD$HH
g = fWf.zt%HT$HHL$@ Hf(HL$H这HD$HHD$H   + Ht
H$   HHH$   H$   H$   H$   Ic_DH\$@HH$   -H  \$0HT$8H$p  
	L$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$8PIÕM]L$      MM;v L$   L$   H$   LHL$PLt$XII+HuL*M;v H$   MtL;t M+I(D$Pf$  LL$8A   H$  H$   L$   L;$   v\ L$   MuI LM$KL I;K wMtI$HH;Hs Hl$@L$p  Ic      6 Ht
H$   HHH$   Ht$8LD$8HH$   _HH$   HH$  H+HHt9H;r H$  H<HH$   HH$  H+HH;rHH+HHt=@ H;rE H$  H<HH$   H$  H+HHH;rM    A       E;     )    IcL$   H$   L+IE  AD$;8  LsM;r H$   JHD$8L$   L$  M+I|rAD$;}iL{M;re L$  H$p  H   A   Ly, H詭fWLD$8HL$@H KAL$p     DBH$   , H H$0     H H$p  H$    L$x  H$  LC$x  H1* HD$ DAH
 k   DBH$    HR H$0  5   H H$0  H$    L$8  H$P  LC$8  H( HD$ DAH
 XkA       H$  LcH$   H+HL;r¹ H$  J< tA;   |      DBH$   ķ H> H$0  WHȲ[}Hȋ: HȲ]hH$0  H$    HH$  q H	 H$  HH$  ( H) H$  / Ic_@   , Ht
H$0  HHH$0  Ht$8LD$8HH$0  ULƐH$P  HH$H  H+HL;s	J<IHD  H+HH;sH<HH$P  H$H  
 "   D$@   t$8LL$@LD$8H$h  H$   +LH|$xHuHH$   H+HH$   HH+HH;s53D$(D$0D$ LL$pMƺ   HjHCH$      LH;v H$   H|$xHL$`LHL$PLd$XHH+HuL'H;vn HL$`MtL;tY L+I(D$PfD$PMA   HT$PHL$`OH|$xH;$   v H\$`Hu
 LLJI;K wHtHHH;Hs߶  #   D$8   t$@LL$8LD$@H$`  H$   :*LH|$xHuHH$   H+HH$   HH+HH;s53D$(D$0D$ LL$pMƺ   HHCH$      LH;v/ H$   H|$xHL$`LHL$PLd$XHH+HuL'H;v HL$`MtL;tݵ L+I(D$PfD$PMA   HT$PHL$`H|$xH;$   v H\$`Hu LLJI;K wHtHHH;Hsc 
 $   t$8MP  LD$8H$   H$   *HHL$`W]
 %    D$@t$8LL$@LD$8HT$HH$   .HHL$`
 &   t$8M@  LD$8H$   H$   /HHL$`ֽ   A;@k  	 *   HcI  A   Lq, HͧL$   HH$   %LL$p  M   A   L:, HI苧L$   HHL$8L$`  HHL$@LIMHA   L+ HULA   L+ HI*L$   HH$  肭L$h  HH$  認AU HH$  脏MHH$  聍MHHL$PqLA   LI+ HH$0  豥I$HL$p  a ,   IWxLL$HL$0  HL$P2HHL$`)H$H  Ht H$H  H$P  H$X  H$0  ݙ H$   HL$`޻HT$`H$x  HyH$  Ht袙 H$  H$   H$(  H$   } H$   Htj H$   H$   H$   H$   E H$   Ht2 H$   H$   H$   H$   
 HL$xHt Ht$xH$   H$   HL$`ޘ HL$@  I[@IsHA(sA({IA_A^A]A\_H\$Hl$Ht$ WH`)t$P)|$@f(>6 IIH   f/D)D$0   f(Ǘ f.zu  !   H    f(ҨfWf( f/fWvfWW p E3LHfD(f(;D\f(K D\C   f/vwfWf.z^} 

. f(fTf/v  fD(fDW "J ^\F fTӖ fD(f/      v f/v7f(f(LD$(LL$pHT$ \ \
 f(PfD(yf/=y r#7 f/vf(خQ fD(LHL$p|$p5 5/ fD(f(X& \ \\i YDXHtfA((t$P(|$@L\$`I[Ik Is(E(CI_@SH0 LD$H3)t$ H 5 fTf/ vH H
' E LD$H3 fTf/ vHS H
\' H(t$ H0[HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;v; HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@H   L;   H;vح HHD$@H\$HHnH;n v HH\$0Hl$8(D$0fD$0Hu E3LKdHHI;k wHtH3H;hsg Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PH襲HOHtB HG    HG     HG(    HL\$`I[ Ik(IA\_^ @WH HAHLHHL@MtDHMtHHIL;t
MtHHIL;tIHOH\$0IHWHH\$0HGH _HHXHhHp @WH`)p)xf(0 IIH   f/D)@   f(腒 f.zuH
6 LD$pH` ]f(蓣fWf(c f/fWvfW 1 E3LHfD(f(<D\f( D\\  D f/   fWf.zuH
 LD$pH3` % 
( f(fTf/v訑 fD(fDW " ^\ fT{ fD(f/       f/v7f(f(LD$(LL$pHT$ \i \
 f(H/fD(yf/=! r# f/vf(  fD(LHL$p|$pDݐ 5׼ fD(f(Xΰ \軐 \\ YDXHt(t$P(|$@L\$`fA(I[Ik Is(E(CI_HSH@  HD$0)p)xD)@IfD(f(f(fWf.zuf( Y"   f.z  f.
i z5u3f(fW	 Af(f(@YY5ۻ f(j  f/
 rfT=  f(@J  f(H_EDJy J ȃ   H HLf(f(   H$P  HD$(H\$ fA(f(f(N   L$P  fA(f(f(T   f(f(   L$P  f(f(1   f(f(oOuH3 HL$x+ HL$8o H_ HD$8HT$xHL$P* HT$8H$   >H
. HHPH
l- HHX@`B  HL$@  A(sA({E(CI[˺  	 ( : T HLH HPHHUVWATAUAVAWH   HǄ$   HXIMHH   虎 Ht
HL$8H3HD$8HD$P    HD$X    HD$`    IWHL$8E3M9w  3\$0Ht$XH|$PIL,Hu3HL$`H+HHH+HH;s03D$(\$ LL$HMōPHT~HHt$XH|$P  HH;v Ht$XH|$PLd$8L$   H$   HH+Hu3$H;vW MtL;d$8tE H+H($   f$   MA   H$   HL$82H|$PLHt$XH;v Ht$XH|$PLd$8Mu E3Ht$XH|$PHD$8LIL I;K wMtI$3H;Hs Ht$XH|$PAIcI;OH$  H$(  H$     詌 Ht
HL$hH3HD$hHǄ$       HǄ$       HǄ$       H|$ LL$hLD$8HHEH$   Ht HǄ$       HǄ$       HǄ$       HL$h HL$PHt HD$P    HD$X    HD$`    HL$8軋 HH$   H   A_A^A]A\_^]HT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$Pt HL$HH+L$XI*IHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHUUUUUUUHH+I;sN"I;b  HHH+H;s3HI;IBHHNHH$   H$   3D$($   D$ LNLH$   HRHN%LH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$HqLH$   3D$($   D$ LNHV H$   HH;%LF LNII+H*HHHH?HLMtIHΪHNQ H[HHHF(KdHHHF H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$HH^ I}H;t  H0H;tHHH0H;uO$dIH^ I<H;tH0H;tHHjH0H;uHF II}H;tH0H;tHH<H0H;uLf H`A_A^A]A\_^[@UATAUAVAWH   Hl$@HE H   H   H   )u@HLqxAY0LBHL;vH>IHupJ    H=   w2J   HHH;wIHH H+H|$@HH.J    H[ HHuHtHHFE3ML96LDLeHEHH=   @@uIM8H;vUMM0MufH    H=   w2H   HHH;wIHHK H+LL$@II$H    H LHuHtIE8I}0 MDLu HE(HH=   È]0t$0H|$(HD$    ME IU IMKDt
I5 @t	I& H   H   H   (u@HePA_A^A]A\]H\$UVWHpHHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@HHHpH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}%HT$ fHHH;HfXDf)D|HL$ LLHlH$   HHp_^]H\$UVWHPHBB(HHL$(HHBHAHBHAHHHxD$HH|$ptH#HHD$pHT$xHكH;HL$xHMHHHL$ LH+E3HH+HHH,CH;}PD$HHT$(ffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLH1H$   HHP_^]H\$UVWH`HBB0J8HHL$0HHBHAHB HAHHHxD$PL$XH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}]D$PHT$0D$Xff@ fHf(HH;HfYfYf(Lf\f)L|HL$ LLH
H$   HH`_^]@UH`Hl$PHBH] Hu(H}0Le8L)u A0HHH;vH
HuLH    H      H   HHH;w
HHHy H+HL$PHHHFML$@M$t$@IT$3HD$8   H9>HL$0HD$(   HDIL$HH=   ID$HHD$ @t	H{ H] Hu(H}0(u Le8He]H` HHkHbHL$SH0HD$ HiHH0[# HL$WH0HD$ H\$PHH   Ht 3H   H  H  H   ̀ H   Ht輀 H   H   H   H   蛀 H   Ht芀 H   H   H   H   i H_HH\$HHhHO H_H\$HHhH4 H HH\$PH0_HHHUVWATAUH`HD$ HX)pLHcHXfWpHqHp3uH6HH;vH,    H HuHtHH^IHt$I;t̄t̄tH^HHH+HLMHM~(S  Hf)HI;|LHHL$(OH\$0H\$8t$@It$H$   HHLLHHiXHtWHtIHHH;tHtIHHH;tHtIHHH;tLLHHLNLNIHH+HLMM~(e D  Hf)HI;|HHL$(bI	IH$   (t$PH`A]A\_^]@SHP )t$@1Hf/   LA LI(H|$`\t$0HyHH|$(MtMtHHIL;tMt:MtHHIL;tMtHHIL;tIHILK3LKIHH+HLMM~0fD  HHI;f(DHf^f)D|HL$ HD'H|$`(t$@HP[HHHVWATAUAVH`HD$ HXHh )pLHcHxfWpHqHp3IuH,I;vH,    HL HuHtHH~IHt$I;tḡt]̄tSH~HHH+HLMHM~&( ffffff     Hf)HI;|LHHL$(H|$0t$@It$H$   HuH,I;vH,    Hp HuHtHH~Ht$I;t̄t̄tH~HHH+HLMM~(/ Hf)HI;|LHHL$(.I蕣IL\$`I[8IkH(t$PIA^A]A\_^HL$WHPHD$ H\$hHt$xHH! HL$(l HHD$pH HHNHu E3D^0D^4D^8D^<D^@D^HFDHB H  HHNPHH\$hHt$xHP_@SH A H  HHH2 HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HL$WHPHD$ H\$hHt$xHH?  HL$(< HHD$pH} HHNHE E3D^0D^4D^8D^<D^@D^HFDH H HHNP<HH\$hHt$xHP_@SH A H HHH HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;vHH4    H HHuHt$HL$@Ll$HLt$PHsHkIHtHtIHHH;tHt:HtIHHH;t迾HtIHHH;t袾LLMM;t%3 MtIHHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;t/I
IHt:HtIHHH;tHtIHHH;tڽLLM;t%o MtIZHHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;tuMt:HtIHHL;tSHtIHHL;t6IHI;t%ˎ HtHHHD$@HHL$@Ld$HHt$PHHH+HLMHM~Hf(fYf)HI;|LHT$@HL$($%IwHGLHD$(Ht$0I_HtI;t肼HtI;tm̄tcH;t(I HtHLHD$(LH|$(H\$0IwHtI;tHtI;t̄tH;t(I HtH}LHD$(LH|$(Ht$0I_HtI;t讻HtI;t虻̄t菻H;t(I( HtHLHD$(LH|$(H\$0HHH+HLMM~!fD  If(fYfA)HI;|LHT$(HL$X#LD$@HT$(H$   HHL$( HL$@ HH$   HpA_A^A]A\_^]HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;vXH4    H HHuHt4HL$@Ll$HLt$PHsHkIHtHtIHHH;tHt:HtIHHH;tϹHtIHHH;t貹LLMM;t%C MtI.HHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;t?I
IHt:HtIHHH;tHtIHHH;tLLM;t% MtIjHHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;t腸Mt:HtIHHL;tcHtIHHL;tFIHI;t%ۉ HtHHHD$@HHL$@Ld$HHt$PHHH+HLMHM~HfQf)HI;|LHT$@HL$("IwH[LHD$(Ht$0I_HtI;t薷HtI;t職̄twH;t(I HtHLHD$(LH|$(H\$0IwHtI;t,HtI;t̄t
H;t(I HtHLHD$(LH|$(Ht$0I_HtI;t¶HtI;t譶̄t裶H;t(I< HtH'LHD$(LH|$(H\$0HHH+HLMM~!ff     IfQfA)HI;|LHT$(HL$Xg LD$@HT$(H$   HHL$( HL$@ HH$   HpA_A^A]A\_^]HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;vsH,    H LHuHtOLD$@Ht$HHkIHtI;t"HtI;t
̄tH;t(I HtHLHD$@LH|$@Hl$HHsHtI;t踴HtI;t裴̄t虴H;t(I2 HtHLHD$@LH|$@Ht$HHkHtI;tNHtI;t9̄t/H;t(Iȅ HtHLHD$@LH|$@Hl$HHHH+HHHHH~ Hf(fYfA)HH;|LLHT$@HL$( It$HBLHD$(Ht$0I\$HtI;t|HtI;tḡt]H;t(I HtHLHD$(LH|$(H\$0It$HtI;tHtI;t̄tH;t(I HtHvLHD$(LH|$(Ht$0I\$HtI;t覲HtI;t葲̄t臲H;t(I  HtHLHD$(LH|$(H\$0HHH+HLMM~I$f(fYfA)HI;|LHT$(HL$PLD$@HT$(I}HL$( HL$@ IL\$pI[8Ik@IA^A]A\_^HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;vcH,    H LHuHt?LD$@Ht$HHkIHtI;tHtI;t̄tH;t(I HtHwLHD$@LH|$@Hl$HHsHtI;t訰HtI;t蓰̄t艰H;t(I" HtH
LHD$@LH|$@Ht$HHkHtI;t>HtI;t)̄tH;t(I HtHLHD$@LH|$@Hl$HHHH+HHHHH~ HfQfA)HH;|LLHT$@HL$(It$H6LHD$(Ht$0I\$HtI;tpHtI;t[̄tQH;t(I HtHLHD$(LH|$(H\$0It$HtI;tHtI;t̄tH;t(I HtHjLHD$(LH|$(Ht$0I\$HtI;t蚮HtI;t腮̄t{H;t(I HtHLHD$(LH|$(H\$0HHH+HLMM~fI$fQfA)HI;|LHT$(HL$PFLD$@HT$(IsHL$( HL$@ IL\$pI[8Ik@IA^A]A\_^H\$Ht$WH HH   HtIf H   3H   H   H   &f HOp1HOpf H H_PHO8Hte HO Hw8Hw@HwHe Ht$8HH\$0H _HL$WH0HD$ H\$PHHH
 HHBHAHBHAHBHAH H #,HOPHL$HH
 HHCXHAHC`HAHChHAHSpH HH   H   +HH\$PH0_LATH   HD$ I[IkIsI{ LHHB H+BHH;AtYH IK| HL$P} Hր HD$PHT$(HL$h| H HD$PH HL$Pd 3H9yvtfHC@H+C8HH;rI} HC8H,ID$ I+D$HH;r(} It$H   H+   HH;r} H   HHHH;{rHKPHH   L$   I[IkIs I{(IA\H`HL$WH0HD$ H\$PHt$XHH  Htc 3H  H   H(  H   xc H5 H  H  HO@H_H\$HHK6{ H3H7H\$PHt$XH0_H\$WH HtHb HH\$0H _HL$WH0HD$ H\$PHHH HHHL$HH  HHBHAHHz HS@HO@H  H  H  HL$HH HH  HAH  HAH  HAH   H (HH\$PH0_H\$WH0HAHH)t$ Hf(P@HC@HK@f(HP@H  Hf(HP@H  f(HHH\$@(t$ H0_H`@H\$Ht$WH HAHHAHP8HC@HK@DHP8H  DHHP8H  DHHH\$0Ht$8H _H`8H\$Ht$WH HAHHIHP0HC@HK@LHP0H  LHHP0H  LHHH\$0Ht$8H _H`0H\$Hl$Ht$WH HAHHAIHP(HC@HK@DLHP(H  DHLHP(H  DHLHH\$0Hl$8Ht$@H _H`(H\$Hl$Ht$H|$ ATH0HA\$`HHAIL\$ P HG@HO@DLIԉ\$ P H  DHLIԉ\$ P H  HDLIԉ\$ P H\$@Hl$HHt$PH|$XH0A\H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`@SH HAHHPHC@HK@PH  HPH  HH [H`H\$WH HAHHHHC@HK@HH  HHH  HHH\$0H _H HL$WH0HD$ H\$PHH   (v H   v H_pH\$HHFH^ H_0H\$HHFH] HOH\$PH0_H%u HL$WH0HD$ H\$HHH  IH  Ht] 3H  H  H  Hp  p] HX  Ht^] HX  H`  Hh  H@  =] H  DvH  $] H  軨H  vH  \ Hx  蕨H  蘏HH\$HH0_HL$SH0HD$ Hٹ   \ HtH3HH5HC0ƀ   HC0H@HC0H HC0H@HC8    HH0[HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKHs tH[HH    tH|$(I4$Ht$ Ml$0HtH;tt 3I;tHWHcs   (D$ f$      [ Ht
HL$0HHHD$0H\$HH\$PH\$X   [ Ht
HL$`HHHD$`H\$xH$   H$   HH$   .s H$   H$p  HT$0H$   !HT$`H$   !L$   L$   H$0  IHT$ HH
H@HBH$  HtZ H$  H$   H$(  H$   Z H$   HtZ H$   H$   H$   H$   ZZ H$   @r HL$xHt<Z H\$xH$   H$   HL$`Z HL$HHtZ H\$HH\$PH\$XHL$0Y H|$(Ht$ Hur HH;{0ur HG@HG@L$P  I[(Ik0Is8IA]A\_HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKHp tH[HH    tH|$(I4$Ht$ Ml$0HtH;tq 3I;tHWHp   (D$ f$      Y Ht
HL$0HHHD$0H\$HH\$PH\$X   X Ht
HL$`HHHD$`H\$xH$   H$   HH$   np H$   H$p  HT$0H$   |HT$`H$   L$   L$   H$0  I/HT$ HH
H@HBH$  HtW H$  H$   H$(  H$   W H$   HtW H$   H$   H$   H$   W H$   o HL$xHt|W H\$xH$   H$   HL$`]W HL$HHtNW H\$HH\$PH\$XHL$05W H|$(Ht$ Hup HH;{0uo HG@HG@L$P  I[(Ik0Is8IA]A\_H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;vVo HM HtH;tBo HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k vn HHl$(H\$ (D$ fD$ Hun LLH<HHI;{ wHtH3H;~sn H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\@WATAUAVAWH@HD$0H\$pH$   HHHUUUUUUUH;vrHAHu3I*%HI(H+I*IHHHH?HH;   HHK`HHD$xLk L9kvm LcL;c vm 3D$(D$xD$ LKLII7LC LKII+IHLIIH?LMtIHuHKTT HHHHC(KdHHHC HsH\$pH$   H@A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;s荢L2I;l  HHH+H;sIHI;IBHIL$HHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   H豴D$0   3D$($   D$ ML$LIVIL$!D$0   HD$8HL@IL3D$($   D$ ML$IT$ INML$IL$ I+IHHHH?HHMtMD$ IIwsIL$Q H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PEHvHINL3D$($   D$ ML$IT$ MT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHI(I\$ I|$ H+I^H;tHT$PHSH0H;uHL$hHtP Ll$hLl$pLl$xHL$PP    IHL$P`I|$ H4vHHH+3ML$D$($   D$ LHH'ID$ LHIN胐I^H<3H;tfD  HT$PH裙H0H;uHL$hHt7P Ll$hLl$pLl$xHL$PP HĀ   A_A^A]A\_^[HHPHHWATAUAVAWH  HǄ$  HXHp )pLLݽ    O HtH$p  H33HH$p  H$  H$  H$     O Ht
H$   HHH$   H$   H$   H$  H HL$hf H H$   f H H$  f HL$0kHD$ LL$hL$   H$  IHL$HHtN H\$HH\$PH\$XHL$0N H$  f H$   xf HL$hlf A^@He HL$h6f ILD$hHT$0IP(HH$p  sHL$HHt-N H\$HH\$PH\$XHL$0N HL$he L$  H$  L+IMuf H$   AF@H= H$  e H H$   e H HL$hne HL$03jHD$ L$  L$   HT$hIPHL$HHt\M H\$HH\$PH\$XHL$0CM HL$h+e H$   e H$  
e I~DH$  H HL$hd ILD$hHT$0IP(HH$p  XrHL$HHtL H\$HH\$PH\$XHL$0L HL$hd L$  H$  L+IMuae H$   Hk H$  0d H8 H$   d H" HL$hd IcV@HL$0h7HD$ L$  L$   HT$hIHL$HHtK H\$HH\$PH\$XHL$0K HL$hc H$   c H$  c EF@H H
 fWt$`Ic~@   K Ht
HL$0HHHD$0LD$`HHL$0
MfHHT$0I蘔HL$HHt4K H\$HH\$PH\$XHL$0K H HL$hb ILD$hHT$0IPHH$   8HL$HHtJ H\$HH\$PH\$XHL$0J HL$hb HIcF@HHt}HؐLL<    HID$ I+D$HH;rYc Ml$H$   H$   H+HL;r2c H$   J9ID HH;r3L$   L$  HPi H$  a H H$   a H HL$ha IcV@HL$05HD$ L$  L$   HT$hIHL$HHtI H\$HH\$PH\$XHL$0I HL$hra H$   ca H$  Ta EF@HM H
* t$`Ic~@   YI Ht
HL$0HHHD$0LD$`HHL$0MfxHT$0INHL$HHtH H\$HH\$PH\$XHL$0H H HL$h` ILD$hHT$0IPHH$   HL$HHtH H\$HH\$PH\$XHL$0qH HL$hY` HIcF@HH   H LL<    HID$ I+D$HH;r	a Ml$H$   H$   H+HL;r` H$   J9ID HH;r3L$   L$  H8 H$  _ H H$   |_ H HL$hi_ HL$0.dHD$ L$  L$   HT$hIKHL$HHtWG H\$HH\$PH\$XHL$0>G HL$h&_ H$   _ H$  _ A   H HL$h^ ILD$hHT$0IP(HH$p  ZlHL$HHtF H\$HH\$PH\$XHL$0F HL$h^ L$  H$  L+IMuc_ H$   A   He H$  -^ H9 H$   ^ H HL$h^ Mc   IcV@HL$01HD$ L$  L$   HT$hIHL$HHtE H\$HH\$PH\$XHL$0E HL$h] H$   ] H$  ] EF@H H
z E   HW H
` t$`Ic      E Ht
HL$hHHHD$hLD$`HHL$hIc~@   HE Ht
HL$0HHHD$0LD$hHHL$0I   HL$`HT$0hHL$HHtFHt$PH;t7HyHHtD HH_H_HOD H0HGH;uHL$HD H\$HH\$PH\$XHL$0zD H$   HtgD H$   H$   H$   HL$hED H& HL$h\ ILD$hHT$0IPHH$   bHL$HHtC H\$HH\$PH\$XHL$0C HL$h[ HIc   H$   LH  H*D  Mc~@LM   HH\$`     LH    H$8  HH$   HK H+KHHHHH?HL;r+\ HsHD7 H+D7HL;r\ Ht7H$   H$   H+HL;r[ H$   H$8  HJIH0M;H$   H*=3H$   L$   IL;L$  Ha H$  bZ H H$   LZ HT HL$h9Z Ic   HL$0-HD$ L$  L$   HT$hIHL$HHt B H\$HH\$PH\$XHL$0B HL$hY H$   Y H$  Y E   H H
 G
$   Ic      A Ht
HL$0HHHD$0L$   HHL$01M   HT$0I輊HL$HHtXA H\$HH\$PH\$XHL$0?A HT HL$hY ILD$hHT$0IPHH$   \HL$HHt@ H\$HH\$PH\$XHL$0@ HL$hX HIc   HHt~HfLL<    HID$ I+D$HH;ryY Ml$H$   H$   H+HL;rRY H$   J9ID HH;r3L$   L$  Hp_ H$  X H H$   W H HL$hW IvDLcIcV@HL$0+HD$ L$  L$   HT$hIHL$HHt? H\$HH\$PH\$XHL$0? HL$hW H$   |W H$  mW EF@Hf H
G 
DH8 H
1 
$   Hc>   Z? Ht
H$   HHH$   L$   HH$   赑Ic~@   ? Ht
HL$0HHHD$0L$   HHL$0zM  Ld$`HT$0I0HL$HHtQHt$PH;t>Hy    HHt> HH_H_HOk> H0HGH;uHL$HT> IvDH\$HH\$PH\$XHL$07> H$   Ht$> H$   H$   H$   H$   = H HL$hU ILD$hHT$0IPHH$   HL$HHt= H\$HH\$PH\$XHL$0= HL$hU HHcH$8  LH  fffff     IcF@HH   HHff     LL<    HH$   IL$ I+L$H*HHHH?HH;rU Md$JD' J+D'HL;rU Nd'H$   H$   H+HL;rU H$   J9KHH0H;H$   Ld$`H3L$   IL;$8  
L$  IvDDHC H
, Hc>HuHI9II;vpL$    IU HHuMtLH$   H$   M@  Ht.HH;t̄t̄tI;|$tEI$T Ht2I;vL,    IT HuMtI$I$I|$HHH+HLMHM~    f(I$f)HI;|LIH$   &XHT H H$  R H H$   R H HL$hR MnDIcU H$@  &HD$ L$  L$   HT$hIH$X  Ht: H$X  H$`  H$h  H$@  i: HL$hQR H$   BR H$  3R H HL$0R ILD$0H$@  IPHH$   YH$X  Ht9 H$X  H$`  H$h  H$@  9 HL$0Q HMc} HMtbfD  HL,    HM4$H$   L$   I+HH;r\R L$   K(IHI;rL$   L$  H}X H$   Q H HL$hP H HL$0P H$@  UHD$ L$   LD$hHT$0H$  HH$X  Ht8 H$X  H$`  H$h  H$@  8 HL$0P HL$hP H$   tP IP  H. H$  8P HL$  H$@  HPHH$   荁H$X  Ht&8 H$X  H$`  H$h  H$@  8 H$  O L$   H$   L+IMuP H$   H IP  Ǆ$      L$   MH H
 y$   L$   MP  H4 H
գ  I^IN"jMc   IcE ILINH$   Ht87 H$   H$   H$  H$   7 H$  Ht 7 H$  H$  H$  H$p  6 L$  I[@IsHA(sIA_A^A]A\_HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   6 Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$p蟍MH{   \$0ffff     IG I+GHL;rN IGB4H HHH H; r   H
5 P"HHL$8Htf(%IHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH%L_L$      H$   H9$   vM Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   vM HtH;t$ptM I+H(D$PfD$`LL$8A   HT$`HL$p蓒L$   L;$   v[M Ht$pHuKM MHD$pLIL I;K wHtHIH;HsM IH$   L;pHH$  HD$ L$  LD$pHT$8HxH p.H$   Ht3 L$   L$   L$   HL$p3 f(($   H   A_A^A]A\_^[HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   r3 Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$pMH{   \$0ffff     IG I+GHL;rK IGB4H HHH H; r   H
 0HHL$8Htf(j"IHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH"L_L$      H$   H9$   vJ Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   vJ HtH;t$ptJ I+H(D$PfD$`LL$8A   HT$`HL$psL$   L;$   v;J Ht$pHu+J MHD$pLIL I;K wHtHIH;HsI IH$   L;pHH$  HD$ L$  LD$pHT$8HۆH pH$   Ht0 L$   L$   L$   HL$p0 f(($   H   A_A^A]A\_^[HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   E0 Ht
HL$8H3HD$8HǄ$       L$   HHL$8n3I;^   IE I+EHH;rH IE4H HHH H;} r   H
 "HH$   Htf(YH3HD$XHL$PH+HH;r6H HL$PH<HZH$   HD$ MLD$8H$   I0sH$   qNHT$XH+T$PHfWI}3fHD$XH|$PH+HH;s/ID$ I+D$HH;rG HIL$H@HHHtH. HD$P    HD$X    HD$`    HL$8u. f(L$   I[ I{0Mc8(t$pIA_A^A]HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   . Ht
HL$8H3HD$8HǄ$       L$   HHL$8>3I;^   IE I+EHH;rzF IE4Hj HHH\ H;M r   H
׼ HH$   Htf()H3HD$XHL$PH+HH;rF HL$PH<HZH$   HD$ MLD$8H$   IH$   qHT$XH+T$PHfWIt{3fHD$XH|$PH+HH;s/ID$ I+D$HH;rqE HIL$H@HHHtHj, HD$P    HD$X    HD$`    HL$8E, f(L$   I[ I{0Mc8(t$pIA_A^A]HL$WH0HD$ H\$PHHYHH\$HHtH+ H_H\$@HYHH\$PH0_+ H\$WH HHBHAHC HS0HO0`HSpHOpaL   H   L      H      B D   D      H         H      B D  H   H   A   D  + H\$0HH _@WH HA HLHHAL@MtDHMtHHIL;tqMtHHIL;tqIHO(H\$8I艣LL$0LD$0HW(HC@H\$8HG(H _HL@HHWATAUAVAWHPHD$0HXHp )pMMLLfWHRH@x3HI9\$~Dff     M,$IF`I+FXHH;rB INXID HHI;\$|L$   I   MFIF8HD$ MNpIV@I"5T fWAE I   I+   HI;wtLIB Ht;HH;vVpL$    IA HuMt5pII?IwI   I+   HH   H       I   I+   HH;rA I   $   H$   H#H;tUI   I+   HH;rAA I   fWIHI   I+   HH;k6IN8HtH ԚHHr? t?    mH      AE $   H$   H#H;t3@IN8Ht+Hh {HH9 lHH
? ?       L\$PI[8IsH(t$@IA_A^A]A\_HWATAUAVAWH`  HǄ$  HXHhHp)p)xf(IHH   DBH2>    /' E3Ht
HL$`HIHD$`Lt$xL$   L$   H$0  HD$ LL$`LHHPf(HT$8H$   = Hx HL$8> L$  t,HT$8H$   = MHIAHL$8N>    t& Ht
H$   HIH$   L$   L$   L$   H$0  HD$(t$ L$   LHH9HT$8H$   = Hx HL$8= t,HT$8H$   < MHIAHL$8= ADt$0H^ HL$8V= HT$8H$   ; HL$8V= H/ H$0  Hf(< MIASHT$8H$   X< MHIAHL$8< MIASHl^ HL$8< HT$8H$   _; HL$8< 
   H$   : H$0  HcQH0  HP   H$   : HH H$0  <HHuI
H HcHHHW   H$   \: HHF HHHuI
H HcHHHW   H$   : HH H踖HHuI
H HcHHHW   H$   9 HH HvHHuI
H HcHHHWHv HJHT$8H$   : MHIAHL$8N; IHE H+EHH+  $  =? D  H\ HL$8: HT$8H$   9 HL$8: L$   L+\$xII;r; HD$xH$   H$   HH$   H+HH;r; H$   H$   HH$   H+HH;rb; H$   H$   H+D$xHH;r>; Ll$xHE H+EHH;r"; Lu
   H$   ;8 H$0  HcQH0  HP   H$   8 LHH$0  z8 HHu3
H HcHHIT$A$   H$   7 LAH8 HHuE3I
H HcHHE3IT$A$   H$0  }7 LAL H8 HHuI
H HcHHIT$A$   H$   77 LHn8 HHuI
H HcHHIT$A$L$   AH$   \H+8 HT$8H$   7 MHIAHL$88 L$   H|$xL+II;rh9 H|$xH$   H$   H+HH;rA9 H$   \fTf/vt$0Ɖt$0t$0HHE H+EHH;H$   Ht  L$   L$   L$   H$    HL$xHt Lt$xL$   L$   HL$` H$   6 L$`  I[0Ik8Is@A(sA({IA_A^A]A\_HL@HHUVWATAUAVAWH   HǄ$   HX )p)xMHH u  o uIj  2 
 
* z " 
b 
 H$H  HD$ pf(fW$(  HW H+WHHL$(  L$@  I臄H_ H+_H    E3Ht
H$   HIH$   $(  L$(  HH$   pH_ H9_v6 HHD$@H\$HH_H;_ v6 HHD$0H\$8    Ht
HL$PHIHD$P(D$@fD$@(L$0fL$0D$(  LD$@HT$0HL$PыIH_ H+_HH       HIE I+EHH;r56 IEL4fffff     HG H+GHH;r	6 H_HD$pHL$hH+HH;r5 HL$hH-A XHD$     L$   MHT$PH3HG H+GHH   L=ff     H$   H$   H+HH;r^5 H$   5Ϋ CY<H Y4f(AXAHw H+wHHHIE I+EHH;r5 IEX44HHG H+GHH;_L$0  H$   II HG H+GHH;r4 H_HD$pHL$hH+HH;r4 HL$hHHHH_ H+_HH;A    HL$hHtl Ld$hLd$pLd$xHL$PS H$   Ht@ L$   L$   L$   H$    f(L$   I[XA(sA({IA_A^A]A\_^]HHXHhHpWATAUH   DS )p)xHHHHD)@D)HD)P'<D\$(H-|$ AA| IcL    h AY)` f/U  D D
< DE Ip     I   E^      IHiN  HHH+HHHHiH+IŉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYfD/xA) A) \YXf(YAY f/wUDR HL$ H:D\$(|$ AA| IcL    h AY)` f/fnY(t$p(|$`L$   I[ Ik(Is0E(CE(KE(SIA]A\_HH7fnY@WH HAHLHHAL@MtDHMtHHIL;t_MtHHIL;t_IHO H\$8IyLL$0LD$0HW H;H\$8HG H _HHXHhHp L@WATAUAVAWH   )p)xD)@D)HD)PD)xD)hD)XD)t$pD)|$`L$  IA   MHLDD$ ADH`D@xDI3 fA(A\f(fATf/V  H$  L$X  =B DB D$  D$  D$  D$  gfffIH      AA+ufA(AXAYA$(  fA(fA(A\AXY&B ^fA(AY\f(Y\ fE/f(vfW-A f(Y-B fA(AXA\fA(\A\YXfA(^\$  A$H$  H#H;tRfE/H$  wH$  Y5 f(X f/w%fE/H$  wH$   \f/vfA(AXAYA$=,A IH]A4$Ll$0t$HHl$@Ht!I;  HtI;  H;^tTH;. Ht?HH;  H<    H. Hu	H|  H$@  HH    H3H^HH+HLMM~:fHE f(HI;fYLIE f(DHfXf)D|HL$(LHH$P  MLHl  @ fE/H$  wH$  fE/0H$  AX4$AYA4$wH$  A\fATf/  H]t$HLl$0Hl$@HHt!H;\  HtH;O  H;^tTH, Ht?HH;4  H<    H, Hu	H  H$@  HH    H3H^HH+HLMM~:fHE HI;f(LIE fYf(DHfXf)D|HL$(LHH$P  MLHHI4H$p  f(A$f(YH$`  Xf/wwfA/spH$x  f(fAT fWf/  fA(A\Yf/\4 rD$  fE(fE(fE(E$fD(fD(D$  $  fD(fD(fD(DD$ AfA(ADD$ A\f(fATf/   D(t$pD(|$`L$   I[0Ik8IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_XXXXXXXX3tH8V 3LD$PHT$HE3)t$ D$H}5- fTf/< vH H
+ ^P
t 3LD$PHT$HE3ɈD$H}fTf/< vH` H
 P 3LD$PHT$HE3ɈD$HK}fTf/o< vH H
 O(t$ H8@UATAUH   Hl$PHE H]PHuXH}`)u HL!LiA0HJHH;voWHHumH    H=   w9H   HHH;w
HHH_ H+HT$PHH$H    H( HHuHtVHG3H97HDHH=   IE IL$t$@HD$8   HT$0HD$(   HD$ LM$IT$Kt	H=( H]PHuXH}`(u He0A]A\]H\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,CCH;}:D$Hfffff     HHH;f(Df^f)D|HT$ HL$0LLH$   HHP_^]Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;t*Ūt ŪtUH\$P3H;tH
& Ht
H蓆HHHHwHH+HLMM~#(  ff     HHI;f)D|HL$ LHQLD$XH-/ l$XHPH\$PHl$`Ht$hH@_LI[IkIs WH   Hj3HHH   ICICICIC@ HtHS3HCHHtH3HBBHVHHD$hHL$xD$pHHHT$8HT$PHL$0HL$ HT$XHt$H\HH;|L$   I[Ik Is(I_H\$UVWH   HBBPHHL$(HHBHAHBHAHB HAHB(HA HB0HA(HB8HA0HB@HA8HBHHA@HHHxD$pH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}ID$pHT$(fffffff     fHHH;HfYfXDf)D|HL$ LLHH$   HHĀ   _^]LI[UVWH   HBBpHHL$(HHBHAHBHAHB IKHHB(HAHB0HAHB8IKHHB@HAHBHHAHBPICHB`ACICHBhICHHHhIktH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH4CH;}U$   HT$(ffffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLHqH$   HHĠ   _^]@UH   Hl$PHH   H   L   L   L)   A0HU0HHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@HAHHU HHAPHBHAXHBHA`HBHAhHB LeHL;vOH}     HM LMpLE0HU8t$@3HD$8   J    H9u HDH=   IE HD$0HD$(   HL$ HM@tt	H! H   H   L   (   L   H   ]J    H   w<J   HHH;w
HHHC H+HL$PHH$H  HHHNHL$VWATAUAVH@HD$ H\$xH$   MLHH HH}HOHsH      Q E3HtHIHLsLs Ls(H      ! HtHIHLsLs Ls(H       HtHIHLsLs Ls(IHO<;IHOH@<HH\$xH$   H@A^A]A\_^H\$Hl$Ht$H|$ ATH@Hy0MHH_H񀻡    u2ffff     HKI tH[HH    tHH^0H|$(HD$ HtH;t H;tHWI uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$Hl$Ht$ WATAUAVAWH0Li8LqHHHT$ 3HIt$`LH HtI;t M9l$tGHT$ HOLHHHu HHtH1HF0H9Gu HWHp*HHHP tHOHHT$ LJH   HYHl$pHt$xHH\$hH0A_A^A]A\_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ LHHHu HHtH1HF0H9Gu HWH@H   H(Hl$PHt$XHH\$HH0_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ L/HHHu~ HHtH1HF0H9Guc HWHpH   H
Hl$PHt$XHH\$HH0_H\$Hl$Ht$H|$ ATHPHHL$ L% 3ILHHE8H}HHu8HtH;}t H;   Hu E3LI;[0u HSIdHu     t HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\H\$Hl$Ht$H|$ ATHPHHL$ L 3ILHExH}HHHuxHtH;}Ht H;   Hu E3LI;[0u HSI4Hui     tZ HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\H\$WH HtH  HH\$0H _HL$WHPHD$ H\$hHt$xHcHHN HH~@H|$p3HHGHGLHMt:MtHHIL;tGMtHHIL;tjGIIMHWyLOLGLD$0LL$8MtWMtHHIL;t#GMtHHIL;tGMtHHIL;tFIIHxHT$(HHH\$hHt$xHP_HWATAUAVAWHP  HD$HHXHhHpLHHC HL$   IHT$ IHL$     DBHL$P E3IL9vH   H8 HL$  HT$ HL$PM HL$  HF@HL$` A   ML9fP~Kffffff     H~@IH^HHHҙ HL$`0qH AIIcH;FP|HT$ HL$Ps MHIAHL$  AHIcH;FH'HL$PD L$P  I[0Ik8Is@IA_A^A]A\_H\$ WH   HًI@H;K4rS0+C8;s;tHKPI'C@SD;  K0;  +K8H$   L$   )$   )$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPH)HwH|$05V D,[PHt$PfAnf(X^^ D$`|$8Y5 t$hHt.HH;tD̄tC̄tCH$   3H;tH} Ht
HhuHH/HHwHH+HLMM~JffY ffD  Hf(HI;fDfYfXf)L|HL$ LH\HKP$C@H$   ($   ($   L$   H$   H$   HĠ   _C@H$   2HĠ   _HHPWATAUAVAWH@  HǄ$   HXHhHp MMHH耉3E3E3HV H+VHgfffffffHHHH?Hd  HCHD$0Hl$ 3H|$(H*$x       IO I+OHHHH?HL;r IGHH$   gH_XLIt$I;t$ v I<$H|$pHt$x(D$pfD$`Huf E3LJ4I;s wHtH3H;ps< Ht$hIt$I;t$ v% I<$H|$@Ht$H(D$@fD$PHu E3LH4I;s wHtH3H;ps Ht$X    Ht
H$   H3H$   (D$`f$  (L$Pf$0  DL$  H$0  H$   gIO I+OH*HHHH?HL;r@ H|$(IH$   H$   HH$   ѿH$x  HN H+NHgfffffffHHHH?HL;r HT$ HVHL$0臜HH$   H$BHO0H$   BH$   Ht 3H$   H$   H$  H$    H$   Hts H$   H$   H$   H$   N IH$   Ht9 H$   H$   H$   H$    IH|$(H0H|$(HD$ (HN H+NHgfffffffHHHH?HL;H*L$@  I[0Ik@IsHIA_A^A]A\_H\$Hl$Ht$H|$ ATH0Hq8HiLHHLHT$ HH HtH;t1 H9wuHIHP tH\$@Hl$HHt$PH|$XH0A\H\$Ht$WH0HyxHqHHHLHT$ hHH HtH;t H9{Ht$HH\$@H0_HWATAUAVAWH   HD$ HXHhHp IHH3$   Li8LqHT$(HLH HtI;t* M9l$tULHT$(HKHHHu HHtH1HF0H9Cu HSH@H薼H  HHHP   HKHLHT$(IHHHu HHuHHH@0H9Cux HSH@HL$8H\$XH+\$PH    Ht
HL$hHHHD$hfW$   L$   HHL$hGHHD$XH|$PH+HHtaH;r
 H|$PH$   H$   H+HH;r
 H$   fnHHD$XH|$PH+HH;rHT$hHLH$   Ht H$   H$   H$   HL$hs HL$PHtc Ht$PHt$XHt$`HL$8J HH   HںHL$   I[8Ik@IsHIA_A^A]A\_HHPUVWATAUAVAWH   HD$PHX)pMHLE3D$   I@HD$ L
Y DA HY H
` KiMIVIHtgII      Ic$   H$   I#I;w
IL;r/H5 HD$(H* HD$ MHS H
,` I]H\$8Lt$`HT$hHL$0HHHAHBHAHBH$   HL$XHHHAHBHAHBHAHBHA HB HA(HB(L$   ImHuI9HH;v9H4    Hy HHuHt9HHoIuHtI;t9HtI;t9̄tx9H;t Ht
HjHL'HwImHtI;t;9HtI;t&9̄t9H;tH
 Ht
HjHL'HoIuHtI;t8HtI;t8̄t8H;tHV
 Ht
HAjHL'HwHHH+HHHH~JIE fB(4HfB(f)D$0HL$0Zf(IfB(fYfXHfB)IL;|LLHH$   HH$0  ($   H   A_A^A]A\_^]LD$HT$WH0HD$ H\$XIHD$@    LAHHQHD$@   HT HH\$XH0_LL$ LD$HT$HL$SUVWATAUAVH0HD$ IIHLH HHHL$(HG$ HHBHAHH IM@H	I  HI  HL$(HMV HL$   IFHAIFHAIFHAH IV %HOj H HHHIN8HtK 3IF8IF@IFHIN 4 IIH0A^A]A\_^][H\$WH H<tH HH\$0H _LIKVWATH`HD$ I[IkIHHHb HE3LaHyI{AL$ HtH8IHD$   D$   L$   3HBH HH{H   y HtH8IHLgLg Lg(H{x   O HtH8IHLgLg Lg(H      " HtH8IHLgLg Lg(H       HtH8IHLgLg Lg(H      HtH8IHLgLg Lg(L@  LH  LL$   HHhHL\$`I[(Ik0IA\_^HL$WH0HD$ H\$HHt$PHH   8H  H   H   H  Ht 3H  H  H  Hp   H   KH   >8HOpHOp HOPHtx HwPHwXHw`HO8c HO HtT Hw Hw(Hw0HOH\$HHt$PH0_0 HL$SH0HD$ HH HK06HKp,H    H    HH0[H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ 迡L_0L[ H\$hHt$pHP_L;v HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_HHPWH  HD$hHXHpIHH3t$0MHHL$pN Ht
HL$8HHHD$8Ht$PHt$XHt$`   x HtHHHHsHs Hs(D$0   H  H HD$ LLD$8HT$pHL$PHt Ht$PHt$XHt$`HL$8 HL$phHL$  I[Is I_HHPUVWATAUH@  HǄ$   HX)pEAHHHL$0HD$PH+D$HHH;         DBH$0  d  H   H\$PH+\$HHHϞ H$@  [HH HH [HH HHm` [H$  H$0    HH$    H H$   HH$     H H$   Hq H$    E3D$p  HH  H+@  HAMy Ht
HL$`HIHD$`L$p  HHL$`]=EQ  @   H  L
 LD$`HT$0Mf(HL$xHt Ll$xL$   L$   HL$` HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(H{ f(  H  L
 LD$`HT$0ɳf(HL$xHtB Ll$xL$   L$   HL$`# HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(H f(X      Ht
H$   HIH$   L$   L$   L$   @t0H  H0 HD$ L$   LD$`HT$0f(.H  H  HD$ L$   LD$`HT$0f(H$   Ht L$   L$   L$   H$    HL$xHt Ll$xL$   L$   HL$` HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(Hz f(H$  ($0  H@  A]A\_^]LD$HT$UVWATAUH  HǄ$   H$X  EIHHE3Dl$0IHL$8被HD$XH+D$PHH;      AUEEH$   H   H\$XH+\$PHHS H$   fWHH* HH( KWHH HH[ 0WH$   H$   HH$   i HY  H$   HH$     HP  H$   H1m H$    D$@  HH  H+@  H    Ht
HL$hHIHD$hL$@  HHL$h8    HtHIHLkLk Lk(D$0   Et'H  H! HD$ LLD$hHT$8&H  H HD$ LLD$hHT$8H$   Ht L$   L$   L$   HL$h HL$PHt Ll$PLl$XLl$`HL$8 HOHt LoLo Lo(H HH$X  H  A]A\_^]HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;v HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@Hэ   L;   H;v HHD$@H\$HHnH;n v HH\$0Hl$8(D$0fD$0Huh E3LKdHHI;k wHtH3H;hs7 Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PHWHOHt HG    HG     HG(    HL\$`I[ Ik(IA\_^ HT$HL$SUVWATAUAVAWH   HD$ HHH  HjH  <NL@  I,    Ht
HL$pH3HD$pHǄ$       HǄ$       HǄ$       H  H$   HT$pH]qLL; v L7H_ H9_v MtL;7t L;  Mu E3MM;{ r IHx  蓪LH  H+  HgfffffffHHHH?HL;  Muc E3MM;{ rO IH   hHN H+NH*HHHHH?HL;r K<dHHFHH  DMu E3MM;{ r H6e I] 1  HǄ$  IUHu3IM(H+HI] HH+HH;sHHCIE H$     H;v_ I} H|$0H\$8IM IuHH+Hu3#H;v, HtI;} t H+H(D$0fD$PL$  A   HT$PIIuI;u v I} Hu E3LHI;K wHtH3H;H   H$   H$     HN H+NHHHHH?HL;re Hn   3HL H+LHHt/    H;r5 HD4HHL H+HH;r؋H$   H$   H+HL;r H$   B,H$  L$+I;C   IUHu3IM(H+HI] HH+HH;sH+HCIE    H;v I} H|$@H\$HIM IuHH+Hu3#H;vW HtI;} tF H+H(D$@fD$`L$  A   HT$`I	IuI;u v	 I} Hu E3LHI;K wHtH3H;Hs HH$  I;H$   H$   H$   *H$   H$   H$   H$   H$   Mum E3MM;{ rY I(VHp  H  lIE I+EH  H$   Ht5 HǄ$       HǄ$       HǄ$       HL$p HĨ   A_A^A]A\_^][H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;vf HM HtH;tR HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k v HHl$(H\$ (D$ fD$ Hu LLH<HHI;{ wHtH3H;~s H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\@SH Hb: H      ?   Hǃ       ^   H   ,;L   H HHH [@SH HE3H     @@ǃ      D   H   H D   HD   L   HH [HL$WH0HD$ H\$HHt$PHHxH      ?H   Hǆ       4 ^   ,   ;L   HɎ HWH   ?_LR LHR H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHE3D   ǆ      H     @@H   D   D   L   Ho HWH   ^LR LHtR H   HH\$HHt$PH0_HATH   HD$ HXHhHpHx HHHZIHtI;tCHtI;t.̄t$H;Y@t%HI8 HtHOHE8HE8    H]@HHH+HLM3M~Hf(HE8f)HI;|LHU8HsHuLEhLHU8HM ;tNH HL$( HL$PY H HD$PHT$(HL$h H_ HL$P Ht$0H^HtI;t,HtI;t̄t
H;]Pt%HMH HtHNHEHHEH    H]PHHH+HLM3M~3fo
 fffff     Hf(HEHfWf)HI;|LHUHHL$(}Hǅ       H   HX L$   I[IkIs I{(IA\H% HL$WH0HD$ H\$HHt$PIHHH HHRH HF`H^pHv HFhH~xH   H 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH HW HHAhHIH HO8
 HO   HO L_ LtH HH\$0H _HH   )xHXD)@fD( ID)HD)PD)XfD(fDTfD(fDTfE(D)`EYD%N fE/r)H@fA(fA(LHD$ fA(WBf(    )$   fA/rWfA(Mf(fA(?=6 H$   E^LHD$ fA(YfA(\fA(A\]fA(Vf(fA(HH$   E^fA(LHD$ f(XY= YfA(\fA(A\($   fWD(d$0D(T$PH$   fA/D(\$@D(L$`D(D$pvfW= f(($   HĨ   HT$HL$UVWATAUAVAWH   HǄ$   H$   EHHLq L+qI    Ht
HL$PH3HD$PHD$h    HD$p    HD$x    LD$P3H;Hh&LH$   Hu4HMHtf HE    HE     HE(    HM E       Z Ht
HL$ H3HD$ 3H\$83HL$@3HT$HA   M;f  MM+L$(  Hu3H+HHH+HH;sLHHL$@H\$8	  HH;v HL$@H\$8Ht$ H$   H$   HH+Hu3$H;vS HtH;t$ tA H+H($   f$   L$(  A   H$   HL$ H\$8LHL$@H;v HL$@H\$8Ht$ Hu E3HL$@H\$8HD$ LII;S wHtH3H;Ps HL$@H\$8IM;w
HT$HL$   EtpE3IMthff     HH+HH;rK HL$@H\$8H4H+HH;r+ H\$8IH+HHHI;sHL$@H\$8E3D$(     0 Ht
HL$PHIHD$PL$(  IHL$P$HT$PL$  IHL$hHt L|$hL|$pL|$xHL$P I+  IIDHHL$PIM   fD  HD$@H\$8H+HH;r4 H\$8HHD$pHT$hH+HH;r HT$hH4HE H+EHH;r HT$hHE9r.HD$pH+HH;r HT$hD<HI;aHD$pH+HH;r HT$hHT$PIHL$hHt L|$hL|$pL|$xHL$Pv IHL$8Ht] L|$8L|$@L|$HHL$ D HMHt5 L}L} L}(HM   H$   H   A_A^A]A\_^]LD$HL$SVWATAUAVAWHPHD$ )t$@MLnI\$Hu3LI9II;vH<    H} LHu
Ht3Ll$(H\$0HcI;\$}_I$4H3\ HHH%\ H;\ r   H
[ 軸HH$   Htf(HID H$   LHLD$(H$   H#=H$   HCH$   HIt$I;wt@I Ht/I;vL4    I Hu
MtII?IwH赳D  HcI;T$}ID IH@HI1 (t$@HPA_A^A]A\_^[HLH HPHHUVWATAUAVAWH  HǄ$   HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(IHH$  HL$  LI|$ ufEWH$  H$   DfD(fE(H$  DY(D$  fE(H$   DYD$  H$(  D3H$  D HnHE3HuI/H;v%H    H HHuHtH$   H$   H^HHtH;tHtH;t̄tH;t+K HtH6BHH$   IH$   H$   HHH+HLMIM~Hf(f)HI;|LH$   HEL$   H$  D5W D= D%5 D  L$   L$   $   I\$HtHH;  
HHtH;    H;_tHH7 Ht7HH;  H4    H Hu	H[  HL/H_HHH+HLMIM~=f    I$f(fYIf(fXHf)HI;|LHH$   {LH$  LHH$  HbtAXAYIH[f(fA(H$  YH$  X	f/,  fA/r	E  f(fATfA(fAWf/   f/= sMfD(fD(HH$   zfD(Y5o A



 $  H$  H$   D$   DD$xDT$p|$hT$`t$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHH
D   0   ~ $  H$  H$   $   T$xt$pDL$hDD$`DT$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHHbDH$   I AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]H8
 3LD$PHT$HE3)t$ D$H',5 fTf/ vc  "   ' 3LD$PHT$HE3ɈD$H+fTf/I v)  "   Cv 3LD$PHT$HE3ɈD$H+fTf/ v  "   (t$ H8LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCIS8HxHWH`HD$ HXHp HHHzHxfW@Ht4HHHHt
̄t
̄t
H;t"H! Ht
H<HH    H{HHH+HLM3M~%(
 fffff     Hf)HI;|LHHL$(- l$xH$   HNHtH3HAAHNHL$(HD$8D$@HD$H    HD$P    LD$xH$   HL$(賋HL$HH\$pH$   H`_H%, HHX WATAUH`  LQH)p)xHCHHD$PHT$hIBHD$XHAHLRHBHAHBHA MHB HA(MHB(HA0HB0HA8HB8HA@HB@H$   H$   Iu
fWf(CH$   HT$PAh    H|$X fWuf(H$  H$   @f(z ;H$  H$  f/   f(Yf/   IE     A<$HoHt$@Hl$0H$  tH&HH$  HT$ HكH;HL$ HMHHHL$(LH+E3HH+HHH4CH;}$D$@fHHH;f)T|HL$(LLH-  f(YXտ f/A$rfW A$H$   HT$PAh   O HHwf(A\,$H$  $0  tH&HH$  HT$ HكH;HL$ HMHHH$   LH+E3HH+HHH,C詢H;}?$0  H$   f    fHHH;f^f)D|H$   LLHOA$\A^$AE H$  H$  L$`  I[8A(sA({IA]A\_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,CH;}(D$8f@ HHH;f)T|HL$ LLHkLD$hH- l$hI5H\$`Hl$xH@A\_^@UH   Hl$PH]PHuXH}`LehLHM )u0A0ID$(HHID$0HAID$8HAID$@HAID$HHA HBHH;vH
HuLH    H      H   HHH;w
HHH H+HL$PHHHFML$ M$t$@3HD$8   HL$0H9>HDIL$HH=   HEHPHE HT$(IT$HD$ zt	H H]PHuXH}`(u0LehHe@]H HHhH_@UH   Hl$PH]pHuxHHFHHM H   HHFPL   )uPA0HAHFXLHAHF`HAHFhHA HFpHA(HFxHA0H   HA8H   HA@HBHH;v$H
HuLH    H      H   HHH;w
HHH H+HL$PHHID$LN@Lt$@HV3HD$8   I9<$HL$0HDHNHH=   HE8HD$(HE HD$ t	H H]pHuxH   (uPL   He`]H HHhH_)H\$UVWHpHBB8J@HHL$0HHBHAHB HAHB(HAHB0HA HHHxD$XL$`H$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}aD$XHT$0D$`ff@ fHf(HH;HfYf(fYf(Lf\f)L|HL$ LLHYH$   HHp_^]LH   HD$ LL$(HIHBIAHBIAHT$HHA(HHA0HBHA8HBHA@HBHAHHB HAPHB(HAXHB0HA`HB8HAhHB@ISHHHAHBHAHBHAHBHA HB 3ICICHT$(HL$Hc3H   H% HHHWH`HD$ HXHp HHY   貸 3HtHHHHsHs Hs(H_8   膸 HtHHHHsHs Hs(H_p   \ HtHHHHsHs Hs(H      / HtHHHHsHs Hs(H   H\$xHK HK0[HKpZH    H    Hp     軷 HtHHHHsHs Hs(H  r H     耷 HtHHHHsHs Hs(H      S HtHHHHsHs Hs(HL\$`I[ Is(I_H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ oL_0L[ H\$hHt$pHP_L;v, HH|$8LD$0HD$0HT$@L(D$0HfD$0/H\$hHt$pHP_ATH@HD$ H\$PHl$XHt$`H|$hHL3HH\$(H\$0Hz H+zHHt3 H.HHD$(H|$0HN H+NHHt,H;r^ HFHHL HHN H+NHH;rHT$(I HL$(H\$PHl$XHt$`H|$hH@A\H% Ht$WH 3HH9q vGH\$0fD  H_HK HK HG(HGHH;GuHHGH;w rH\$0Ht$8H _HWATAUAVAWH  HD$`HXHhHpAMHLI>HC H+CHuII<     i E3Ht
HL$ HIHD$ L|$8L|$@L|$HHHL$hDHT$ HMD8$  AH\$8H;\$@v HD$ HD$PH\$X(D$PfD$PH|$PH\$XHt$@H9t$8v HtH;|$ ty H;     DBH$    IH$    HHI &Hu- MLI;[ r Hk H+kHHIti@ Hu MLI;[ r HC H+CHH;r HCIH$   b HHJ %HH;rHu MLI;[ r| HC H+CHH;re HCIH$    HHM %HT$hH$   { HI:HL$h# H$   \ Hu MLI;[ r H0?H\$8HtJHt$@H;t6H@ HHtϱ L;L{L{HK軱 H0HCH;uHL$8褱 L|$8L|$@L|$HHL$ 英 L$  I[0Ik8Is@IA_A^A]A\_HATHp  HD$XHXHpHxIIHL   DBHL$`7 Ld$HHD$pHD$PLLHHL$HHT$ HL$` Hx HL$  t/HT$ HL$` H$  LHAHL$  HL$` L$p  I[IsI{ IA\L$D$HXH      )t$@D$xHD$x)|$0f(H#f(H;u,H
: H L
 LD$`Hj HD$ >D$xHD$xHH#H;v,H
 H L
{ LD$`HOj HD$ >f/
 w,H
 HT L
E LD$hH	j HD$ g>L$`HD$`H#H;v,H
| H- L
 LD$hHi HD$ (>HL$`IZY(t$@X(|$0HXH\$Ht$WH 3IHt$8 HHH\$0HGHwHwHw Ht$@HH _@SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQHHC(HCH;CuHHCHCHCQHKHL$P3D$@HD$@HD$XHL$(HtIHIQHzjHC(HCH;CuHHCHC H0[H\$Ht$WH HAHHxHt HHHHtH;y(t%HI  HtH&HF HF     HV HH~(H\$0HF Ht$8H _HL@WATAUH   HD$0HXHpMHLH~H|$`fWD$pHu3L;HH;vJH    H LHuHt&3LD$HH|$PHt.HH;t̄t̄tH|$PLT$XHHH+HHHHH~5 MtIBHtHHHffA)HH;|LLHT$HIkLd$ LL$HL$   IH$   $   I      H$   I#I;   H5| HL$X I$HT$XIHL$X H(| HL$X} I$HT$XIHL$X H;| HL$XP I$HT$XIHL$XU M$IASHL$H6 2
  HHT$PH   H|$H$   H$   I#I;tHHcH;|   H{ HL$X I$HT$XIHL$X H{ HL$X I$HT$XIHL$X H{ HL$Xd I$HT$XIHL$Xi M$IASHL 2#H|$HH: HL$H+ 22L$   I[ Is(IA]A\_LD$VWATH@HD$ H\$xIHHH\$hE3@ HWH;VthH\$(3D$`HD$`HD$0H\$8HtHHHHKfHHG(HGH;AuHHGHHHH9OuLgH(H\$pHH\$xH@A\_^H\$UVWH   HBBXHHL$0HAh   HHBHhHAHBHAHBHAHBHA HBHA(HBHA0HBHA8HBHA@H$   D$x	 H   HHh$   H$   tH,HH$   H$(  HكH;H$(  HMHHHL$ LH+E3HH+HHH4CrH;}#ff     LD$!HHpHH;|HL$ LLHrH$0  HH   _^]HLH L@HPHHSUVWATAUAVAWH8  )p5 E3H0H8H@IMHHILt$hN,    ILL$`H$   HH$   LHT$pL;H
b Lt$xh  HH\$XHD$XHOL8L|$XK7H$   M  IBHIIML$  IA   H4IEM+@ ^H  H$  H$   H$  H$h  L$p  I.HH$   H$  HHHAHBHAH$h  HBHH$  HHAHBHAH$   HBHH$(  HHAHBHAH$   HBHCH$   $`  H$   H$   L$@  H$   HD$PL$P  H$   L$X  L$  IEHHIHILt$xL|$XH$   Ht$`H$  H$   Hl$hLd$pH$  L$  HH+H~8Mt$@HD$8   LL$0HMLIHD$(   Ht$ L$  H$  L$  HH@IIL$   H$   Ht$`Hl$hLd$p($   H8  A_A^A]A\_^][LI[IkIs WH   Hj3HHH   ICHD$ ICHD$(fHtHK3HC0HtH3HAA(HT$@HHAHBHAHN@HBHHHHFHT$0D$`L$hHD$xHHL$pH$   HHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   HH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,C;H;}(D$8f@ HHH;f)T|HL$ LLHLD$hH- l$hI H\$`Hl$xH@A\_^HWATAUH   HD$`HXHhHp LLX* HPHiHhHu3HuL9HH;vfH<    H LHuHtBLD$ Ht$(H}HHtH;tHtH;t ̄tH;t(I HtHzLHD$ LH\$ H|$(HHH+HLMHM~2ff     HM IE f(f\fA)HI;}LD$ LMHT$ HL$@3A$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMHM~6fАHD$ f(f^HE f(fXf)HI;|HT$0HL$@EL\$ L$   Ll$HHl$PL$   HT$hHL$ANI|$H|$0H$   HL$8HuLLOLOIHH+HLMM~&     IHf(fXf)HI;|HT$0IU H$   θ HL$ ¸ L$   I[(Ik0Is8IA]A\_H\$WH   HًI@H;K4rDK0A+C8;sA;tHKPIC@SD;r  K0;g  +K8H$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPH!LGLO<R D,[PHL$ LD$(LL$0fAnHHT$hH|$Pf(X^^L$XHHAHBHAHBHAYLL HB$   MtaHMtHHIL;tMtHHIL;tMtHHIL;tzIHIjHT$@H]KHKPC@H$   H$   HĠ   _C@H$   2HĠ   _HWATAUH   HD$ HXHhHp HL   輝 E3Ht
HL$pHIHD$pL$   L$   L$   LD$p3H˺   q Ht
HL$@HIHD$@Ll$XLl$`Ll$hE33HL$@\HT$@HE33HL$@@HT$@HE33HL$@$Mc$   L$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;vf HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;v, HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@Ht$XH;t$`vִ H|$@Huƴ MLHI;K wHtHIH;Hs HT$@HE33HL$@HT$@HE33HL$@Mc\$DL$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;vγ HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@JHt$XH;t$`vx H|$@Huh MLHI;K wHtHIH;Hs= HT$@HPE33HL$@Mc$   L$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;vò HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;v HT$@HtH;tt H+H(D$0fD$0L$   A   HT$0HL$@Ht$XH;t$`v3 H\$@Hu# MLHI;K wHtHIH;Hs HT$@HHL$XHt Ll$XLl$`Ll$hHL$@ޘ L$   I[ Ik(Is8IA]A\_HHHVWATH`HD$ HXHh HH.4 HE3LaHQLAHi AL$薘 HtH(IHE LeLe Le(HSHBIL9c   fW$    Hs   B Ht
HL$(HIHD$(L$   HHL$(HT$(HHL$@Htԗ Ld$@Ld$HLd$PHL$(軗 HH;{rHHL\$`I[0Ik8IA\_^DL$ HT$UVWATAUAVAWH   HǄ$   H$   AIHLI E3MT$ M+T$HgfffffffIHHH?H   E3E3$     % Ht
HL$0H3HD$03HD$HHD$PHD$XHO H+OH*HHHH?HL;r HGI<IL$ I+L$HgfffffffHHHH?HL;rX ID$ID$  DLD$0HH} H9}v) HE HD$`H|$hHD$PHH|$HH;v HD$PH|$HHL$0HL$pHt$xH;v߮ HL$0H$   H$   (D$pf$   ($   f$   (D$`f$   \$ L$   L$   H$   HH|$HHt-Ht$PH;t@ Hg H(H;uH|$HH] 3HD$HHD$PHD$XHL$0B II0I(IL$ I+L$HgfffffffHHHH?HL;H$  @$(  H$   H   A_A^A]A\_^]HHHVWATH   HǄ$   HXHh HHE3D`AL$Ô Ht
HL$ HIHD$ Ld$8Ld$@Ld$HHT$ H   膔 HtH(IHE LeLe Le(Ǆ$0     HL$8HHt$@H;v Ht$@HL$8HD$ HD$PH\$X(D$PfD$PH\$PH|$XH;vͬ HtH;\$ t H;   Hu MLI;{ r HH$   CZHH$   SHH跧H$   Htp L$   L$   L$   H$   K Hu$ MLI;{ r H0Ht$@HL$8%   3 Ht
HL$`HIHD$`Ld$xL$   L$   HT$`H
HL$xHtƒ Ld$xL$   L$   HL$`角 HL$8HtHH|$@H;t9HYfHHt L#LcLcHKk H0HCH;uHL$8T Ld$8Ld$@Ld$HHL$ ; HL$   I[(Ik8IA\_^H\$Hl$ WH03IHH9Z ~GHt$@)t$ fWHfHL$HHvHGHXDHcH;G |(t$ Ht$@H\$PHl$XH0_H\$Hl$ WH@3IHH9Z ~eHt$P)t$0)|$ fWHHL$XHpvHG@f(Xʐ HGH^tHcH;G |(|$ (t$0Ht$PH\$`Hl$hH@_@SH H H      ?   Hǃ       ^   H   ,;L   HL HHH [H\$WH H HHH HAhHIHJ HO8@ HO 6 HO, L LtH) HH\$0H _@SH HE3H     @@ǃ      D   H   H^L D   HD   L   HH [HL$WH0HD$ H\$HHt$PHH舺H      ?H   Hǆ       4 ^   ,   ;L   HyK HWH   L
 LH
 H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHعE3D   ǆ      H     @@H   D   D   L   HK HWH   eL
 LH
 H   HH\$HHt$PH0_HLH HPHHWH`HD$0HXHLJ0HL@LC(HIC(fW C(H\$xH0H\$HH{HtHH;tHHtH;t̄tH;t&H HtHjHE3E3LE3H{HHH+HHHH~)(
v fD  Hf(fBWfB)IL;|LLHHL$@q5H$   H`_H\$Hl$Ht$WH IIHHHHtڌ LHgfffffffH3L+HsIHHH?HHD Hl$8HHS H;HKHDHt$@H{H\$0H _HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q ~5L5 fWHMf(f(AAID;m |LHT$(HHHXHHtH;tHtH;t ̄tH;_tH Ht
HyHH7H_HHH+HLMM~!    HE f(Hf)HI;|LHHHHL$($ L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;t
̄t ̄tH\$P3H;tH
 Ht
HsHHHHwHH+HLMM~#(z ff     HHI;f)D|HL$ LHnLD$XH- l$XHyH\$PHl$`Ht$hH@_HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA D$ L
gH DB HDH H
 0 L[L\$ L
H EG H5H H
 Ic_ H\$hfWt$xHuE3IH<HH;v{H<    H HHuHtWE3H$   H$   Ht.II;t%̄t̄tIH$   HHH+HLMIM~( f)HI;}
H$   LH$   HL$`Ic_ H\$ht$xHuI/H;vH<    H+ HHuHtiHL$HH\$PHt$I;tJ̄t@̄t6H\$PHHH+HLMIM~( f)HI;}HL$HLHT$HHL$`Ic_ H\$ht$xHuI/H;vH<    Hc HHuHtH$   H$   Ht.HH;tr̄th̄t^HH$   HHH+HLMIM~*( fff     f)HI;}
H$   LH$   HL$`Ic_ H\$ht$xH{LH$   H$   Ht$H;t̄t̄tH$   HHH+HLMIM~'(G     fA)HI;}
L$   LH$   HL$`2Mcw Lt$ht$xA   MIHL$8_Mt$L;t̄t̄tL;t$@t,HL$8 MtIsLHD$8MLl$8Ld$8Lt$@IHH+HLMM~-(h IIHHHfff     f) HHuMHT$8HL$`PA݉\$0Dl$X=ۦ fff     $  ;/  AA  ~CIL$  ffff     H$   Mf(f(8HA;w |E3L$   HT$`IHHXHtHH;tHHtH;t̄tI;t(I HtHLHD$8MLl$8LH\$@HHH+HLMIM~fHf(fA)HI;|LHT$8HɠHL$`    DBH$    H$  H$   H$0  H$   L$   L$  HT$8H$   bH$   H$   | Hx H$   & t7H$   H$   L H$  LHAH$    L$   HTA H
%  L$   L$   H$  H$   L$   L$   IHH+HLMII;}I
If(fXf)HH$   IH$   H$   H$   H$   HD$HH$   H$   H$  H$  H$  H$   H$  \$0É\$0H$   * E3L$  Lt$@Ld$8fW= \$0fn$  H$  H$   lr$  H$  HL$HQrI_H\$hHD$HH$   H$   HL$`HHHAHBHAHBHD$HH$  Ht$PHHH+HHHH~7HfB(f)D$`HL$`HD$HfB(fYfB)IL;|LLH$  H$   ~$  HD$HH$  H$  H$  3H$   H$  H;ZHT$HH[I\ H$   M H$   > HL$H2 H$   # ($@  ($0  HP  A_A^A]A\_^[Hl$Ht$H|$ ATH@HqfWILHD$8Ht$(Ht.HH;t̄t̄tH\$P3H;tH	 Ht
HjHHHHwHH+HLMM~(q HHI;f)D|HL$ LHnLIHH\$PHl$XHt$`H|$hH@A\HATAUAVH  HD$ HXHhHpHx )p)xD)@D)HD)PD)XD)xD)hIMHfD(fD(fDW
 A   L$P  D9%    D- D D%	 3H9^~pfA(AYfA(AYfD(D\3fE/vf(f(H虡AYD
J fA(fA(HAHHHcH;F|MIHsuAD;% fD;%      DBH$      DBH$   fA(H$  Ҕ  H$   M] IASM] IASH$  H$  j HH$   H$  Q HHT$xH$  ; LH> H$h   L7 HHL$P LHH$@  w L= HH$   V LHH$   I L= HHL$(+ ME HIAHL$(Y H$   J H$   ; H$@  , HL$P  H$h   HL$x H$    H$   H = HL$( IE HT$(IHL$( H$   H$   2L$  I[ Ik(Is0I{8A(sA({E(CE(KE(SE([E(cE(kIA^A]A\@SH0
"6 6 LD$H)t$ HX5  fTf/ vH H
4 _
v  LD$HfTf/ vHW H
4 #H(t$ H0[HHHWATAUAVAWH  HǄ$  HXHp )p)xD)@D)HD)PD)xD)hD)XMMfD(f(fWϥ @HH$@  H$   H$   H$X  HHHAHB   'z HtH$   H33HH$   H$   H$   H$   E3E3H$   I踌H$   A   L$H  $   D$   fEWD
 D D
 ff     D;- s  I|$   dy Ht
HL$pHHHD$pD$(  L$(  HHL$pfff     HcI;|$   f(AYfA(AYf(\fA/vH$   3f(AY"D
 f(fA(H$   ;f(H$   H$   H+HH;rT H$   4H$   H$   H+HH;r% H$   I$HH*H$   H$   H$P  L	LH$0  A   x Ht
H$   HHH$   H$  H$  H$      w Ht
H$(  HHH$(  H$@  H$H  H$P  H\$8D$0 D$( H$   HD$ L$(  LD$pH$@  I   Yw Ht
HL$@HHHD$@H\$XH\$`H\$hHT$@I6Hv* H$  H$  H$(     v Ht
H$  HHH$  H$  OH$  ƀ   H$  H@H$  H H$  H@H$  H$  H$(     ~v Ht
H$  HHH$  H$  TOH$  ƀ   H$  H@H$  H H$  H@H$      v Ht
H$  HHH$  H$   H$(  H$0     u Ht
H$8  HHH$8  H$P  H$X  H$`     u Ht
H$h  HHH$h  H$  H$  H$  LL$@L$   H$   H$  {yH H$X  H$0  H$`  H$  H$h  E3MH$X  IMIIW  H@ H$X  H$  HL$XHt?Ht$`HH;t-HOHtyt H_H_ H_(Het H0HL$XUt H\$XH\$`H\$hHL$@<t H$@  Ht)t H$@  H$H  H$P  H$(  t H$  Hts H$  H$  H$   H$   s H$0  H$   Hts H$   H$   H$   HL$ps D;-   H$   Ht,H$   HH;tHJ H(H$   Cs H$   H$   H$   H$   s   H H$X  H$  HL$XHt?Ht$`HH;t-HOHtr H_H_ H_(Hr H0HL$Xr H\$XH\$`H\$hHL$@r H$@  Htr H$@  H$H  H$P  H$(  _r H$  HtLr H$  H$  H$   H$   'r H$0  H$   Htr H$   H$   H$   HL$pq A   DBH$0      DBH$  Ɉ fA(H$@    H$  A IIPIIPH$  H$   HHT$@H$0  { HHT$pH$0  e LHB H$    Lx6 HH$(   LHH$    LvB HH$  } LHH$X  p L8B HH$   O MHIAH$   { H$X  l H$  ] H$   N H$(  ? H$   0 HL$p$ HL$@ H$  	 HA H$   ԇ IH$   IH$   ԇ H$  
 H$0   H$   Ht,H$   HH;tH H(H$   o H$   H$   H$   H$   co 22L$  I[@IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_@UH@Hl$ HE H]0Hu8H}@LeHHLLBHL;vL
MumJ    H=   w9J   HHH;w
HHHv H+LL$ II$J    H\ LHuHt蚵HG3H97IDHH=   MD$I$IL$,t	H H]0Hu8H}@LeHHe ]HL$SUVWATH   HD$ IHH HHQLAIA I+AHHAH IQ4HOPLGHWLgH   H$      m 3HtH(HHE fW$   L$   IHH vfD  HHHOH9sHH;_rZH, HL$(߄ HL$P# H HD$PHT$(HL$hބ HV HD$PH HL$Pl HHĐ   A\_^][HHPWATAUH   HD$ HXHhHp LLHH	H$   HH$   H;v: H$   H$   HH;v H$   H$   Hl$hHl$0H\$8(D$0fD$0H;v Hl$hH;t*fffff     H1 HX u	H(H;uHD$0HtH;t H;u.H HL$@w HT$@HL$h7HL$@{ HT$hI螊M$  I$  I$  AH$   Ht2H$   H;t H' H(H;uH$   Hk 3H$   H$   H$   HL$hj I葶L$   I[ Ik0Is8IA]A\_HL$UVWATAUAVAWHpHD$ H$   LcLK II  {3ۃ LAǆt        AA+iɫA+Ap  utAp  Ap   uAǆp       AA+iD+Et  uEtAAt  At   uAǆt     I  Ix  I  I  I  A  Ix  I  I  I  I@     i 3HtHHHHsHs Hs(Mp     Wi HtL(HIE IuIu Iu(A  A  M     i HtL8HIIwIw Iw(LH$   A  -  fD  HSHuHHK(H+HH{ HH+HH;sL'HGHC    H;vY H+Hl$0H|$8HK LkHI+HuH"L;v& HtH;+t I+H(D$0fD$@L$   A   HT$@H評LkL;k vـ H+Huˀ LL] IL I;K wHtHE HH;Hs IL$   A  L;Mp  HǄ$   HSHuHHK(H+HH{ HH+HH;sHHGHC    H;v" H+Hl$0H|$8HK LcHI+HuH"L;v HtH;+t I+H(D$0fD$@L$   A   HT$@HrHkH;k v HHu LLHD I;C wHtH3H;Fsm II  AMI  I  IH$   HpA_A^A]A\_^]HT$WH0HD$ H\$@Ht$XHH3t$PN/f HtHHHHsHs Hs(D$P   H  H  ALBHH\$@Ht$XH0_H\$WHpI IHLHT$0H)t$`f(P(LOLWt$PLH$   LT$ HD$(IL\$HHH+3HLMM~;fff     II
f(HI;fYDfXDf)D|HT$ HL$@HL$0} L$   L$   HHH$   (t$`Hp_tH\$Ht$WH HHHxHtHH;tɫH;yt%HI`} HtHKHFHF    HVHH~=H\$0HFHt$8H _HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz Hu3H8HH;v	H    H| HuHt3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVI   DBH$   fz L$   HT$@Hrf(D$PHT$hH$   Kz Hx @HL$hz @t,HT$hH$   z MHIAHL$hz t$XHD$XI#I;u+Ht HD$ L
H LD$PHL# H
 hX|$8É\$0H$   y I      H$   L$  L$  |$8\$0fnF^IL$Hy ufW
H$  gWfAnt$ Y5t 
 X
ă YXXHL$@z f(($  ($  H  A^A]A\_^[HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0GGxfEWfA.zJ  D
" fA/6  HGPLG`HHOPP8MMHHOPs(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  IH$  I#H      H;vHw  \+" _ fD(f/v   HcD݋ D% @ HD$0H;t5HKHT$88l$Xk(HKHT$HHK0HT$`HGPLG`HHOPP8MMHHOP}s(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  H$  I#H      H;vHcv  \HufA/vEGxAYHufD/v,GxAYGxfA/   fA.tkHD$0H;t6HKHT$8l$Xk(HKHT$HHK0HT$`ڻHL$`w HL$Hw HL$8w    H H$   Nv HL$xw H*{ HD$xH$   H$   Gv H HL$xQ^ Hm H$   u HL$x;w Hz HD$xH$   H$   u Hx HL$x] HL$`v HL$Hv HL$8v L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HHHWATAUH  HD$pHXHpMIHHHHL$@:u L$  M$LH$   IA$   t`H$   H
uLLd$0H$  HD$(Ll$ LL$  HH$   Ht XE3LH$   HmH$   vL$  HHHft H$  Tt 2L$  I[(Is0IA]A\_HT$WH0HD$ H\$PHHD$@    HALHHL@IIH|5HGLHHL@HMtMtHHIL;tMt:MtHHIL;tߢMtHHIL;t¢IIHHH'HH\$PH0_LSVWATAUH  IXE3IILH  IkMsHD$0M{ L$@  HD$ A)sICL4   HHD$(HHGAH+Hl$XH$   f(BYHH$   Ah   H$   HGHHAHGH$  HAHGHAHG HA HG(HA(HG0HA0HG8HA8HG@HA@HH$   H$   HFBY4H+HHL$hHD$PHHHFHAHFHAHFHAHF HA H$   HL$PH$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@H$h  HB@H$   $X  Y H$   HL$ $  Ll$0Hl$8IMHL;q($  L$8  L$(  H$   H  A]A\_^[LI[IkIs WH   Hj3HHH  HD$0HD$ ICHD$(HtHK3HC8HtH3HAA0H$   HHAHBHAHBHA HBHA(HN@HB HHHHFH$   $   $   HD$8HHL$0HL$HHHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   HH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$0Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,CH;}(D$0f@ HHH;f)T|HL$ LLHˬLD$hH-x l$hI]H\$`Hl$xH@A\_^HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   HSHH_HGPLG`HHOPP8L$   MMHHOPHHL$@=us(HGPHHOPf(X9   ~7ff     HGHLt$(Ll$    LGPHHOH;   |s(HGPHHOPX$   HH$   H#H      H;vHl  \f(T f(5Lw f/vNHOh-Df/v?HD$@H;t5HKHT$Hol$hk(HKHT$XVHK0HT$pHf/vf(s(HGPHHOPX   W0fWs HWf(ICHL$pm HL$Xm HL$Hm IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      蜖HSI I|$ID$PMD$`HIL$PP8L$  MMHIL$PHH$   rH$   H$P  rH$   H$  rH$   H$  rID$PLH$   IL$PP(H$   HHHu33H;v臚HH)l HHuHtgH$   H$   H$   HHtH;t0HtH;t̄tH;t*k HtHHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   CoH$   HHu3=HH;vZHHj HHuHt:H$   H$   H$   HtH;t
HtH;t̄tH;t*j HtHuHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   !nIt$(Hu39HH;v>H    Hi HHuHtH$   H$   I\$(HtHH;tHHtH;tǗ̄t轗H;t*Yi HtHDHH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ lfEWfA($   w(ID$PHIL$PfD(DX3퉬$  D%uq D$   A$   A$   D-{ A9$   |  Dz D* fH$   H$  D$   HuH5HH;+  H4    Hh HHu	H  HL$pH\$xHt(HH;      H;t%g HtHHHD$pHHL$pH\$xHHH+HLMHM~(a f)HI;}HL$pLHT$pH$  膒H^e  fAW$  IL$h<fA/  H$   H;tAHOH$   )$   o(HOH$   
HO0H$   Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I<H$   H;Z  HWH$   ^o($   HWH$   ?HW0H$   .  H$P  H;tAHOH$X  $x  o(HOH$h  HO0H$  ۩Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I;H$P  H;tAHWH$X  Eo($x  HWH$h  &HW0H$    A$   $  f/vSH$  H$  $  $8  H$  H$(  躨H$  H$@  襨n\J f(IL$h,:f/vQH$  H$  q$  $8  H$  H$(  JH$  H$@  5H$  H$   7f($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$pM$L$   L$   H$   IASHt:HL$p/c E$   E9$   }=ke_YHL$pb HL$pb 9̋$  A$   fn$   ^H$  H;tAHOH$  Ԧ$8  o(HOH$(  赦HO0H$@  褦w(ID$PHIL$PXA$   AT$0fAWIT$f(H$  H蝠H$   b H$   b H$   a H$   a H$  a H$  a H$  a H$@  a H$(  a H$  a H$  a H$h  va H$X  ha H$   Ya H$   Ka H$   =a HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   AHSHH_HG`LGpHHO`P8L$   MMHHO`*HHL$@mfs(HG`HHO`f(X9   ~7ff     HGXLt$(Ll$    LG`HHOX;   |s(HG`HHO`X$   HH$   H#H      H;vH]  \f(F f(5|h f/vNHOx]5f/v?HD$@H;t5HKHT$H蟣l$hk(HKHT$X膣HK0HT$pxf/vf(s(HG`HHO`X   W0fWq HWf(IsHL$p^ HL$X^ HL$H^ IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      L?HSIPI|$ID$`MD$pHIL$`P8L$  MMHIL$`軶HH$   cH$   H$P  cH$   H$  cH$   H$  cID$`LH$   IL$`P(H$   HHHu33H;v跋HHY] HHuHt藋H$   H$   H$   HHtH;t`HtH;tK̄tAH;t*\ HtHȼHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   s`H$   HHu3=HH;v芊HH,\ HHuHtjH$   H$   H$   HtH;t=HtH;t(̄tH;t*[ HtH襻HH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   Q_It$(Hu39HH;vnH    H[ HHuHtJH$   H$   I\$(HtHH;tHHtH;t̄tH;t*Z HtHtHH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ ^fEWfA($   w(ID$`HIL$`fD(DX3퉬$  D%b D$   A$   A$   D-2l A9$   |  Dl DZu fH$   H$  D$   HuH5HH;+  H4    H8Y HHu	H  HL$pH\$xHt(HH;      H;t%X HtHȸHHD$pHHL$pH\$xHHH+HLMHM~(R f)HI;}HL$pLHT$pH$  趃HV  fAW$  IL$x".fA/  H$   H;tAHOH$   Y$   o(HOH$   :HO0H$   )Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I9H$   H;Z  HWH$   莛o($   HWH$   oHW0H$   ^  H$P  H;tAHOH$X  ;$x  o(HOH$h  HO0H$  Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I7H$P  H;tAHWH$X  uo($x  HWH$h  VHW0H$  E  A$   $  f/vSH$  H$  $  $8  H$  H$(  H$  H$@  ՙn\< f(IL$x\+f/vQH$  H$  衙$  $8  H$  H$(  zH$  H$@  eH$  H$   @(f($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$p	M$L$   L$   H$   IASHt:HL$p_T E$   E9$   }=蛂蕂菂艂HL$p%T HL$pT i̋$  A$   fn$   ^H$  H;tAHOH$  $8  o(HOH$(  HO0H$@  ԗw(ID$`HIL$`XA$   AT$0fAWIT$f(H$  H͑H$   FS H$   7S H$   (S H$   S H$  
S H$  R H$  R H$@  R H$(  R H$  R H$  R H$h  R H$X  R H$   R H$   {R H$   mR HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   =HSHH_HGhLGxHHOhP8L$   MMHHOhZHHL$@Ws(HGhHHOhf(X9   ~7ff     HG`Lt$(Ll$    LGhHHO`;   |s(HGhHHOhX$   HH$   H#H      H;vH	O  \f(J7 f(5Y f/vQH   &f/v?HD$@H;t5HKHT$H̔l$hk(HKHT$X賔HK0HT$p襔f/vf(s(HGhHHOhX   W0fWb HWf(I蠎HL$pP HL$XP HL$HP IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      \;HSI耺I|$ID$hMD$xHIL$hP8L$  MMHIL$hHH$   +UH$   H$P  UH$   H$  TH$   H$  TID$hLH$   IL$hP(H$   HHHu33H;v|HHN HHuHt|H$   H$   H$   HHtH;t|HtH;t{|̄tq|H;t*
N HtHHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   QH$   HHu3=HH;v{HH\M HHuHt{H$   H$   H$   HtH;tm{HtH;tX{̄tN{H;t*L HtHլHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   PIt$(Hu39HH;vzH    H<L HHuHtzzH$   H$   I\$(HtHH;tFzHHtH;t'z̄tzH;t*K HtH褫HH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ IOfEWfA($   w(ID$hHIL$hfD(DX3퉬$  D%S D$   A$   A$   D-b] A9$     D;] Df fH$   H$  D$   HuH5HH;;  H4    HhJ HHu	H  HL$pH\$xHt(HH;      H;t%
J HtHHHD$pHHL$pH\$xHHH+HLMHM~(C f)HI;}HL$pLHT$pH$  tHG  fAW$  I$   OfA/  H$   H;tAHOH$   膍$   o(HOH$   gHO0H$   VLt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I5H$   H;Z  HWH$   軌o($   HWH$   蜌HW0H$   苌  H$P  H;tAHOH$X  h$x  o(HOH$h  IHO0H$  8Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I3H$P  H;tAHWH$X  袋o($x  HWH$h  胋HW0H$  r  A$   $  f/vSH$  H$  >$  $8  H$  H$(  H$  H$@  q\9- f(I$   f/vQH$  H$  ˊ$  $8  H$  H$(  褊H$  H$@  菊H$  H$   jf($   H$   H$  H$  H$  L$   IHH+HLMHM~1ffff     HD$pH$   f(fXf)HI;|H$  HL$p)M$L$   L$   H$   IASHt:HL$pE E$   E9$   }=ssssHL$pEE HL$p8E s̋$  A$   fn$   ^H$  H;tAHOH$  $$8  o(HOH$(  HO0H$@  w(ID$hHIL$hXA$   AT$0fAWIT$f(H$  HH$   fD H$   WD H$   HD H$   9D H$  *D H$  D H$  D H$@  C H$(  C H$  C H$  C H$h  C H$X  C H$   C H$   C H$   C HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]Ht$WH0HD$`HHHD$ D$@    Y    t@W H   HVxH\$HH\$H   ^nx   ,;L   HHt$PH0_H\$WH0HD$`HHHD$ D$@        tS HWxH   ;HH\$HH0_LMK ECISIKSVWATAUAVAWH  HǄ$P  A)sA){MELHE+H` HD$ L
` MCH H
_ jH H$   @ IH$   IH$   @ -g $   C $  5jJ $  =f $  @ $   
? $   MIH $   HHPH$   HHPH$(  Έ$    $   $   fWL$HD$@E3D|$DH
a |$@   Ic   $      t$P A;  AAHHL$X`? H` H$   J? GLt$8HD$XHD$0H$   HD$(D$ E3ҋH$   )? HL$X? AE D$ L
 D$   H H
_ 蒝HGHHHL$ L
f EE H H
4 wLt$0HGHD$(GD$ LOLH$   I諜2H$P  L$h  D$`  L$X  D|$D$   t$Pu?HT$XH$   ϷHH$(  >HL$h*? HL$X?    H$X  H$   荷L$   H$   dTHH$(  H$  L$   H$  3TLHHL$XRHH$(  HL$h> HL$X> H$   t> H$   f> fn$ f(^H$  H$(  ԺL$   H$   +SHH$   H$  3Lf(H$X  oSLHHL$XRHIHL$h= HL$X= H$   = H$   = Ɖt$PH
] MIHoL] ;L] H$P  L$h  D$`  L$X  D$PD|$D$   $   f/   f/$         DBH$  9; H H$  ̖HH 轖HL$HF; HHF 蟖A}HZ H$  腖H< H$  oHT$XH$  : MHIAHL$Xs; MIASD$@ H$  :    A}$   |$H   f/$         DBH$  9: H H$  ̕HH 轕HL$HF: HH` 蟕HT$XH$  9 MHIAHL$X: MIAS|$HD$@ H$  9 H$(  AD|$DHWHL$X
HI HL$h=; HL$X2; H
s[ bLD$ L
b HC H
 诹H$8  : H$(  : H$   : H$   : D$H($   ($  H  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/HX HD$ L
X L$   H H
_ ¯fA/w/HX HD$ L
oX L$  H H
) 茯̋$  /HIX HD$ L
5X L$  HV H
 HHPH$  IE HPH$p  fE(D%  K $   fn=^ YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhH H$  7 H$  8 H; H$  H$  H$  7 H; H$  H$  +\Hu3HH$   aHD$pHHL$xH$   H$   H H$   6 L$  I$H$   IH$   6 HN H$   6 I$H$   IH$   6 97 $   AA   D=n: D5J D  G D$ L
2 D$0  H H
ċ M]ICHD$ L
 DG H H
 ܓLd$0IEHD$(AED$ MMME H$  HAuHH$   H$  cHH$p  H$   6 H$   6    H$  H$  Lf(H$   KHH$p  H$  菅L
D HL$@KLHH$   gJHH$p  fH$   6 H$   6 H$   6 H$   5 fAnf(z ^HT$@H$p  dL
> H$   JHH$  H$  ĄLf(H$   KLHH$   
JHHqH$   Z5 H$   L5 H$   =5 H$   /5 AƙA} &	  fA(MHIfD($  fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(HtD  DX HI;IDH;tHufH*HyX D^HT$pIfD(Ⱥ   DBH$  1    H$P  0 HH H$   WHHu3
H HcHHHW	   H$p  x0 HAH1 HH 
HH_/ HHu3
H HcHHHW   H$@  +1 LHu3
HHcHHISA   H$   / HfA(H"1 HH {HHu3
H HcHHHW   H$0  0 HH^H/ HHu3
H HcHHHW   H$`  Z/ HfA(H0 HH HHu3
H HcHHHW   H$  0 HHQ^H. HHu3
H HcHHHWfA(H0 81 +fn^5 $       Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHu=1 HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;v0 HL$`H\$XHt$@H$P  H$X  HH+Hu3$H;v0 HtH;t$@t0 H+H($P  f$  L$   A   H$  HL$@>H\$XHHL$`H;vC0 HL$`H\$XHt$@Hu)0 E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps/ HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;v/ HL$`H\$XHt$@H$`  H$h  HH+Hu3$H;v`/ HtH;t$@tN/ H+H($`  f$  L$   A   H$  HL$@=H\$XHHL$`H;v. HL$`H\$XHt$@Hu. E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps. HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;v[. HL$`H\$XHt$@H$@  H$H  HH+Hu3$H;v. HtH;t$@t
. H+H($@  f$  L$  A   H$  HL$@U<Ht$XH;t$`v- H\$@Hu- E3LHI;K wHtH3H;Hs- H$   HHT$@PfE/vH H$   ;E2fE/vH H$   E2AE D;~"fE/wfE/vH' H$   H$   H$  D+ M$HIAH$   + E   fA(A\A^fATf/ vmHI H$   + I$H$   IH$   + H H$   U+ I$H$   IH$   T+ HL$XHtP HD$X    HD$`    HD$h    HL$@+ H$  X* H$  $   D;$  uoH H$   * I$H$   IH$   * H: H$   * I$H$   IH$   * E2AE$   =P HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	I+ H$  + H$p  * H$   * H$  * L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H   C( H      Q H   H   H   H   H   H-C6?H   H?H   H-q=H  HMbP?H  Hǃ  '  H      ?H8  H:0yE>H   H(  H@  H     @H0  H     @@HH  HH\$HH0_HT$VWATH`HD$ H$   HHLAL+HgfffffffIHHH?HH;   HpHH$   HK H$   H$   H$   H;HCHLH\$(3HD$0H~LHSHiHD$0HyHHL$(,HD$0Ld$(H\$8HD$@    Ld$HHD$PLK(LHT$8HL$H4eLLHH3H$   H`A\_^HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0-   fEWfA.zU  D
s fA/A  HG`LGpHHO`P8MMHHO`$s(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  IH$  I#H      H;vH$  \ F
 fD(f/v   HcDW9 D%9 HD$0H;t5HKHT$8jl$Xk(HKHT$HjHK0HT$`jHG`LGpHHO`P8MMHHO`~s(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  H$  I#H      H;vH#  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$8sil$Xk(HKHT$HZiHK0HT$`LiHL$`% HL$H$ HL$8$    Hn H$   # HL$x% H( HD$xH$   H$   # HA HL$x H H$   i# HL$x$ HE( HD$xH$   H$   b# H HL$xl HL$`4$ HL$H)$ HL$8$ L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0)   fEWfA.zU  D
3 fA/A  HGhLGxHHOhP8MMHHOh{s(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  IH$  I#H      H;vH   \e 	 fD(f/v   HcD5 D%4 HD$0H;t5HKHT$8vfl$Xk(HKHT$H]fHK0HT$`OfHGhLGxHHOhP8MMHHOhzs(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  H$  I#H      H;vH  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$83el$Xk(HKHT$HeHK0HT$`eHL$`  HL$H  HL$8     H. H$    HL$x  H\$ HD$xH$   H$   y H HL$x H H$   ) HL$xm  H$ HD$xH$   H$   " H HL$x, HL$` HL$H HL$8 L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HL@HHUVWATAUAVAWH  HǄ$  HX)p)xILH    E3Ht
H$   HIH$   L$   L$  L$     F Ht
H$  HIH$  L$0  L$8  L$@      Ht
H$  HIH$  L$  L$  L$      Ht
H$  HIH$  L$  L$  L$       Ht
H$  HIH$  L$   L$(  L$0  Hu H$    H$   H$   詍H$    H+ H$    H$   H$   oH$    LH$  HASAEH$  IE3E3H$  ILL$  H$  HAS(L$8  L+$0  IgfffffffIILIIH?LH$  H+$   IHLIIH?LH$  H+$  IHHHHH?HIIO$Ld$`H$  HtHXIHh H$P  ~ Lc8  A+<  LcH$  HL$8Ld$0LD$(LT$ LLHH$  )   DBH$P  i H+= H$    H-{7 H$  H$`  H$   H$   H$   H$    H< H$   H$0  HY H$8  H$  H$@   H$   H$   HtHXIH7 H$   I LHH$  9H H$    H$  H H$  H$  H$   H$   L$  L$   H$  H$   H$  H$   H$       u<MLHH$   l?HH$   ZMLHH$   @ D$xHl; H$h  G Hy; H$   1 H$   H$P   H$   + ^H H$`  sHȋ HHǲ sHHh j H$  H$P   $  D$t0  D$p   t)tttA   A      D,  H7 H$   EL$0  E   H$   HD$PAA+@  H$  H$   , HH$h  H$    H$   HL$8H\$0HD$(D$ DL$tD3A,HH$0  HL$ L$  LH$   HPHHwH?` H$   H$    Aę|$pu.Lt$ LLIH$   LHH$   OKAE;H$   +D$xfn^= H$h  # @   1  H9 H$    H$   H$P  i H$    D$     L
;# Ld# 3H  HHRH* H$   l H$   H$  H$  H$   b LH$  HAS H$   H$P  z HH$h   H$    L$  IE3H$   H$h   HH$h  { H$    ^ D$|$  D$p0  D$t   t+tttE3D   E3D   D   ,  H
, H$   D+E3E  H$   HL$PfD   H$  H$   , HH$h  H$    H$   HL$8H\$0HD$(D$  DL$pED5 A*HH$0  HL$ L$  LH$   HPHHuH=] H$   H$    Aę|$tu.Lt$ LLIH$   LHH$   MHAE;H$   +D$|fn^5 L$  f(f(H$   "L$  f(f(H$   L$  f(f(H$   fW     HtH$H  HE3E3IH$H  L$`  L$h  L$p  L$  IT$ I+T$Hf(H$H  JD<  E"  fAn5 ^H$  H$  H+HHu H$  f(Y?IH$h  HL$`  I+HH   Ld$`J,    ffffff     H$  H+HJ#H;r H$  H$h  L$`  I+HH;rh L$`  f(Y/AHHH$h  HL$`  I+HH;s
H$  nL$      tm^H H
 lHȋ HHҫ lHH   M HH lHH< > H$  X    tH$   A H$  HMpH$  :E H   HHMIBHp  H$H  B  H  H$h   L$  IH$  I;v L$  H$  H$p  H\$`Ht$hI;v H$p  H\$PH|$X(D$PfD$PHu MLH0I;{ wHtHIH;xs H|$X     Ht
H$8  HIH$8  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$8  4H$  HH$   H;v H$  H$   H$   H\$`Ht$hH;v H$   H\$PH|$X(D$PfD$PHu MLH(I;{ wHtHIH;xs H|$X     Ht
H$x  HIH$x  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$x  %bH$  H9$  v H$x  H$   H$   H$8  HH$0  H;v H$8  H$0  H$  HL$PH|$XH;v H$  HL$`H\$h(D$PfD$P(L$`fL$`($   f$   D$@D$ LL$PLD$`H$   H$x  x/H  H$8  6H   H$x  H   H$(  |H$  Ht0H$  H;tH
 H(H;uH$  H  L$  L$  L$  H$x    H$P  HtLH$X  H;t:HYHHt  L+LkLkHK  H0HCH;uH$P  k  L$P  L$X  L$`  H$8  F  H$`  Ht3  L$`  L$h  L$p  H$H    H$h   H$   H$h   H$   Hv H$  H$   H$  H$@   H$0  H$  z H$  H$P   H$  Ht\  L$  L$  L$  H$  7  H$  H$   趍H$0  詍L$  L\$PH$   H$  H$  H$   Ht2H$(  H;t H H(H;uH$   H  L$   L$(  L$0  H$    H$  Ht/H$  H;tHU H(H;uH$  HH  L$  L$  L$   H$  #  H$  Ht/H$  H;tH
 H(H;uH$  H  L$  L$  L$  H$    H$0  Ht/H$8  H;tH
 H(H;uH$0  H  L$0  L$8  L$@  H$  _  H$   Ht7H$  H;t"     H'
 H(H;uH$   H  L$   L$  L$  H$     L$  I[HA(sA({IA_A^A]A\_^]HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxYH      fWf/v6 f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;t+8HHtH;t
8t8H;^t)HN	 HtHiHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL
L$   H$   H脎2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxYMF      fWf/vf f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;t[6HHtH;t=6t46H;^t)HN HtHgHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI|L$   H$   H贌2L$   I[IsI{ A(s(|$pE(CIA\HVWATH   HD$ HXHh)p)xD)@D)HAIHHHPL@fEWIx ufE(H$   HL$(gfD(= E3@t;H\$0L9cufA(H$   HL$(wf(A^H[8Lg f(A^$   H\$0L9cufA(H$   HL$(?wD^DO0DD$(Ld$0Ld$8Ld$@Ld$HHT$(H,>HL$@ HL$0 L$   L\$(H\$0Hl$8HOH;uHO$   IHHT$0f(L$   I[(Ik0A(s(|$pE(CE(KIA\_^HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YB      fWf/v
 f/v   fD/v	D   f/v   $   f/v  H   HL$   I\$HtHH;t2HHtH;t2t2H;^t)HNI HtH4dHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   Y@      fWf/v f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;t1HHtH;t0t0H;^t)HNy HtHdbHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI)L$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   Y*?      fWf/vC
 f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;t8/HHtH;t/t/H;^t)HN  HtH`HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIYL$   H$   HQ2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YZ= +     fWf/vs f/v   fD/v	D  f/v  $   f/v  H   HL$   I\$HtHH;th-HHtH;tJ-tA-H;^t)HN HtH^HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\H\$Hl$H|$ ATH HH
HHt
HEH;   LeHI|$HtH;t),HtH;t,̄t
,Ht$03H;{t Ht
H]HH3HH{HH+HLMM~#    I$HHI;f(Df)D|LHIVHt$0HMHH	H\$8Hl$@H|$HH A\uHL$WH0HD$ H\$HHH   .H   Ht  H    HOX HOH HO8 HO( HO HOH\$HH0_H%v HWATAUAVAWH0  HǄ$  HXHhHp)pAAf(LH H( H$  HH$   HH$    IUH$   E   L$  DH$   Ibf(H H$    L$  IH$   IH$       DBH$    H H$0  %UHf( H$   H$   r MHIAH$    H$   O L$  H|$0H$  Ht$($  D$ $  f(H$   I#I}HH$   HtH;t(HtH;t(̄t(H;_t"Hb Ht
HMZHH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   M]I[     Ht
HL$PH3HD$PfW$  L$  HHL$Pu3E3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;vU H\$PH\$@H|$H(D$@f$   Hu- E3LH<I;{ wHtH3H;xs L$   Mu E3MI;{ r I.HAHIEIcH;p=H$  .̹     Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM LHAS   DBH$   M HM H$0  QHAU$ HH QH$   H$    LHHAH$    E3E9}$I  D  MEIUH$   +RE3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;vE H\$PH\$@H|$H(D$@f$   Hu E3LH<I;{ wHtH3H;xs L$   Mu E3MI;{ r I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM AE;}$}M,H] H$   7 HH$   HH$   7 H$   p H$   Ht!  HǄ$       HǄ$       HǄ$       H$     HL$hHt  HD$h    HD$p    HD$x    HL$P  H$    H$    3L$0  I[0Ik8Is@A(sIA_A^A]A\_HHPVWATAUAVH@HD$0HXHh IHH@    H$   Hh+A   Dt$p       S H   H   }   ^   ,A;ALƉ   LGHWHH  t]LHH      ^,A;ALƉ   Y2      H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   Hh@D$p       tuS H   H   |LGHWHH  t@LHH   Y91 
     H   H   HHHH$   H@A]A\_^]HHPVWATAUAVH@HD$0HXHh IHH@    H$   HhA   Dt$p       S H   H   {   ^   ,A;ALƉ   LGHWHH  :t]LHH      ^,A;ALƉ   Y0      H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   Hh D$p       tuS H   H   wzLGHWHH   9t@LHH   Y)/      H   H   HHHH$   H@A]A\_^]HHXHhHpWH   )pp  )xX  IIHL
Q L D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ *h  Dd  D`  ,  H  Ht$(D$ +L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
 L D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
 L D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
 Lz D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ jh  Dd  D`  ,  H   Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   H ID EL   H I( H5> fWD E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMH HtHKHEHLmHH}PHHH+HLMIM~)(
 @ Hf(fWHEHf)HI;|LHUHH$   zH   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   SL$@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   L$0  H  HUxH$8  HL$(HD$ L$@  L$H  H$0  >.AY$0  $8  f/v
H$0  H$8  L    A$   L     A$   H  H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM t[Eu7A   H4 I HDHL$xo HL$hc G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;tHHtH;t̄tH;\$pt$HL$h9 HtH$HHD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   L$   L$   I^HtHH;tHHtH;t̄tH;$   t$HL$xO HtH:GHD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   L$   I|$ uf(H$0  H$   WD  fD(HD$hH$   H|$p tH$0  H$   Wf(f(  f(EtIH   ALD$hHT$xH3f($0  H$0  HMXY   ux'H   E3LD$hHT$xHL   L]xMHUHHQmp\mhfT- (  f/vA      @  fA/vA   x   f/vA
   bH  H9   rA(   JHH(0  5@ Yf/vA    H΃H  Yf/vA   HL$x# HL$h AL$   A(sA({E(CIA_A^A]A\_^][HWH`HD$ HXHhHpHHP"HgHHD$0HXHHtH;tHtH;t̄t3H;_tH[ Ht
HFDHH7H_HHH+HLMM~2(
] fffff     HE f(fWHf)HI;|LHHL$(RsHL$P H\$pHl$xH$   H`_LUVWATAUAVAWH  HǄ$X  I[A)sA){LHHAE3HxH,  II(IKI0. ACHL4I      ?=  LFHIIHHT$0LD$8Ht$HLD$PIH+HH$   H$   H$   HL$0HHHAHBHAHBHAHBHA HB L$   H$   HH$  HEH$  H$  H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$  L$  L$  H$  H$   LHFIIN|LFLIIIH$   L$   H$   IH$   IH+HH$   H$   L$   H$   HIHAIBHAIBHAIBHA IB H$   L$  H$   HIHAIBHAIBHAIBHA IB HA(IB(HA0IB0HA8IB8HA@IB@$  $P  HNH+IH+IHIHD$0Hl$8Hl$@Ht$HHT$PH$@  HL$0HHHAHBHAHBHAHBHA HB L$  H$  H$@  85IT$H+I$HHT$XHl$`Ld$pIL$HL$xHT$XHaH$0  : LFIIHHHT$XLD$`Ht$pMLD$xIH+HH$   H$  L$  HL$XHIHAIBHAIBHAIBHA IB L$@  IL$H+I$HH\$0Hl$8Ld$HID$HD$PH$   L$   H$   L$   L+JH$`  H$h  H$x  H$   HHHAHBHAHBHAHBHA HB L$  H$  H$`  HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$0nf(YY$   H$   H$   L$   ID$H$   H$  H$   ?IT$HH+I$HHL$XHl$`Ld$pHT$xHVLHIIH$   H$   H$   H$   HH+HH$   H$  L$  H$   HIHAIAHAIAHAIAHA IA H$@  HNH+HHHI+IH$  HD$ LL$XL$   GiML^HJ$  BDI$B4IIHL;L$  I[HA(sA({IA_A^A]A\_^]HVWATAUAVHP  HǄ$   HXHh )p)xLHq3H  H~fW= I.MfLkIHIHD HD$ H|$(Lt$8Ld$@HT HT$pH$   L$   HǄ$      HDHD$HH|$PH\$XLt$`Ld$hID$H\ H~iYҹ   H;}IHYXHA   I}&3ɐH;}IHYXHIf(\Xf/   f(^  $  ID$HD H   H   H$   HL$pHHHAHBHAHBHAHBHA HB L$   H$   HL$H'1$  L$  HT$ HHH$  ! H~H$  HL$ IHL;3HHL$P  I[@IkHA(sA({IA^A]A\_^HVWATAUAVH0  HD$ HXHh )p)xLHq3H  H~fW=[  IN LkI.HHIHD H$   H$   H$   H*IFHBIFHBIFHBHJ H$   H$   HD H$   H$   H$   H*IFHBIFHBIFHBHJ HǄ$     HDHD$0H|$8H\$@HT$HH*IFHBIFHBIFHBHJ HD$hHD$pLaLB\ H   L$   AYҹ   H$  H    J
 H;} YXHHA   I}(3ID  H;}YXHHIf(\Xf/   f(s  $h  BD H   H   H$   H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$   H$h  HL$0.$`  L$`  H$   HH$   H~H$h  H$   IHL;wHHL$0  I[@IkHA(sA({IA^A]A\_^HWH  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HAT A\ HD$8LT$@D$HHT$0HL$ ЉP  HQLL$0HT$8HI HHH$   H$   IBH$   H$   HHHQLQHCHAHC HA H$   H$   LH$   H$   7HT$0H:H$   LL\$PHCHD$XHL$hLHAHCHAHCHAHC HA H$   H$   HD$0HD$ H$  HD$(HT$PHL$ @7L$   HL$0HIHAICHAIC$  HHD$PHCHD$XHL$hHHHCHAHCHAHCHAHC HA H$   H$   HD$PHD$ H$  HD$(H$   HL$ 7L$   HIHFICHFICHFICHF IC HT$XHL$0HHHAHBHAHBD$xL$   H$   HL$Q6L$  L$  H$   HIH$x   L$  I[Is I_HHPVWATAUAVH   HD$0HXHh IHL3퉬$   A(D$ L
! M@H! H
) LHSIHtgHI      Ic$   H$   I#I;w
IL;r/H HD$(H HD$ LH:O H
( ƫIL$LHT$X#H:VLHD$@Ld$HIt$HuH9HH;v
H    H HHuHtHHwI\$HtI;tHtI;t̄tH;tB Ht
H-3HH/H_HHH+HLMM~.fff     I$IE f(fXHf)HI;|LHHL$8MHL$h HL$   I[@IkHIA^A]A\_^@SH HHP  HH [~HSH   HD$ )pHZHX @LB@HPHHHIHD$0H\$8H{ ufWH$   HL$(f(HL$h f(($   HĐ   [HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhD fAWA   DBHX Hg H$@  )+HM  HT$@H$0  x L$  MHIAHL$@ L$   $    t2H$  HD$0Lt$(H$  HD$ MU HH3$(  k2$  E3fW L   ~<EtACu,H1g HL$@f IHT$@IHL$@l HdDFhfAWE f(HV@IIH9^@~@f     H~8IE I+EHH;r IMHHHH;^@|Ћ$(  EuH    u2H     utA  H HL$@ HT$@H$0  ) HL$@ H      H$    HHif H$@  ,)HHuI
H HcHHHWHH HH%f (   H$   1 HHf H$@  (HHuI
H HcHHHW   H$    LHuI
HHcHHISAL$  AH HHe W(   H$    HHze H$@  -(HHuI
H HcHHHW   H$   ] LHuI
HHcHHISAH7lf(Hb HHd 'HFHD$HHx uf(H$  HL$@>N  f(   H$    HHd H$@  `'HHuI
H HcHHHW   HL$p LHuI
HHcHHISAf(H HHBd &
   H$  6 HH,d H$@  &HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H HHc a&
   H$    HHc H$@  7&HHuI
H HcHHHW   H$   g LHuI
HHcHHISA   Hp HH"c %H     H$    HHc H$@  %HHuI
H HcHHHWHH? HHb `%Hb H$@  L%HH    HHb -%HT$@H$0   MHIAHL$@1 H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  <E$  Ex.H b HL$@ IHT$@IHL$@ 2Ha HL$@g IHT$@IHL$@m AF   EH$0  HLHa HL$@ MHIAHL$@% H$0   H$0  O AL$  A(sA({E(CIA_A^A]A\_^][HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q(~5L5d fWHMf(f(AAID;m(|LHT$(HjHHXHHtH;tuHtH;t`̄tVH;_tH Ht
H(HH7H_HHH+HLMM~!    HE f(Hf)HI;|LHHHL$( L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA(D$ L
m DB(Hm H
 %L[L\$ L
xm EE(Hm H
f $Ic](H\$HfW|$XHu3H9HH;vH<    H HHuHtHL$hH\$pHt.II;t̄t̄tIH\$pHHH+HLM3M~(/ f)HI;}HL$hLHT$hHL$@(Ic](H\$HH\$P|$XHHHu3/H;v	L$    I HHuMtHL$xH$   H$   HtWHtIHHH;tHtIHHH;tHtIHHH;ttH$   H$   HHH+HLM3M~ ( @ f)HI;}HL$xLHT$xHL$@	Ic}(H|$H|$XHu3/H;vH4    H HHuHtH$   H$   Ht.HH;t̄t̄tHH$   HHH+HLMM~$(/ HIHHHff) HHuLH$   HL$@Ic}(H|$H|$XH$LH$   H$   Ht$H;t̄t̄tH$   HHH+HLM3M~"( ffA)HI;}
L$   LH$   HL$@rMcu(Lt$H|$XA   MIHL$0Mt$L;tḠt=̄t3L;t$8t,HL$0 MtI#LHD$0E3Ld$0Ld$0Lt$8IHH+HLMM~-( IIHHHfff     f) HHuMHT$0HL$@E3D$  D|$`5     $  D;9  3A9u(~I3L$  ffffff     H$   Mf(f(x;HA;u(|D$  L$   HT$@IHHXHtHH;tHHtH;t̄tI;t(IU HtH@"LHD$0E3Ld$0LH\$8HHH+HLM3M~Hf(fA)HI;|LHT$0HHL$@    DBH$    H$  H$   H$0  H$   L$   L$  HT$0H$   H$   H$    Hx H$   d t7H$   H$    H$  LHAH$   ) L$   Hf H
 >L\$hL$   H$  H$   L$   LL$pIHH+HLM3ҐI;}IIf(fXf)HH$   I(E3H$   D  E;](}QE3    E;=IcIcL$   LLHL$xH$   YBXBAAAD$  H$   h L$  H$   Lt$8Ld$0D$  fW5 fn$  H$  HL$h褗HD$xH$   H$  H$   H$   HD$HH$   HD$Pt$XHT$@H$   M]L\$@H$   HL$@HHHAHBHD$xHD$@(D$@fD$@HD$@H$   H$  H$   H$   H$   HHHAHBHAHBHAHBH$   H$   \HT$hH$  HgvHT$xHJwI H$    H HL$x HL$hw ($@  ($0  HP  A_A^A]A\_^[HT$UVWH0HD$ H\$`HHD$P    HHpHu39HH;vTH<    H HHuHt0HHsHE HxHHtH;tHtH;t̄tH;t Ht
HjHH    H{HH_HH\$`H0_^]HT$UVWHPHD$ H\$pIHǄ$       IH@HT$(3HHHqHu39HH;v,H    Hʼ HHuHtHHwHE HXHHtH;tHtH;t̄tH;tW Ht
HBHH    H_HH7HL$8# HH\$pHP_^]HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz(Hu3H8HH;vH    H HuHt3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVIv   DBH$   V L$   HT$@Hf(D$PHT$hH$   ; Hx @HL$h @t,HT$hH$    MHIAHL$h t$XHD$XI#I;u+Hd HD$ L
8 LD$PH<b H

 X0X|$8É\$0H$    I      H$   L$  L$  |$8\$0fnF^If(XHL$@ f(($  ($  H  A^A]A\_^[HWATAUH  HǄ$   HXHhHp )p)xD)@D)HEIHH3H\$@H\$HH\$PHT$(LD$0fWI9Xuf(H$8  HL$ }f(D  fE(D^H$8  Hl$(DL$0L$8  H$   HL$!LHNHL$(HL$0HT$`HD$ HH
HHHJHHHJH@HBI'H$   LHL@IMtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHL$@HT$XHL$@lH$    E   Ht$(H~ tH$8  HL$ )f(^D^HD$@H$8  HD$@HD$(DD$0L$8  HT$XHL$!tHHHLIHHLAMtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHHHHL$x 0  fA(LHT$XHL$@HL$@H$8  L$8  H$   HHT$ HAHLHL@MtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHLOLOIHH+HLMM~Hf(Hf)HI;|HHHL$  H$    HL$hݵ H$8  Hl$(DL$0L$8  HT$XHL$!zL$8  L$8  HH菏HL$x HL$@ f(L$  I[ Ik0Is8A(sA({E(CE(KIA]A\_HLH VWATAUH(  L$x  IE3LIMo  HXHhH$p  LpLxL$  )p(5 IHǀ@   LD$pHMHL$xIH+H$       H$   L)H$x  f)$   f)$   f)$   IL$x  H$x  f)$   f)$   f)$   HMH$   HH$  f)$   f)$   HD$hH$  LD$`LD$XHD$PHD$H D$@H\$8L|$0A   H\$(Hl$ pE3MH~JL    IPHIIfD  H;}JHĐ   XDDIIL;|H$h  H;MHL+ILHD$pHH$x  IT H$  HD$hH$  LT$`LT$XHD$PHD$H D$@H\$8L|$0LD$(LHl$ oHl$xH$   H    HIHD$pI;A    ($  L$   L$`  H$X  H$P  H(  A]A\_^HWHp  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HA4 A\ LT$8HD$@D$HHT$0HL$ d  HILL$0HL$@HHH$   IBH$   H$   H$   HHLQHCHAHCHAHC HA H$   H$   HL$PHHHBHAHBHAHBHAHB HA L$   H$   HL$P[HT$0H@H$`  V LL\$PHCHD$`HL$hLHCHAHCHAHCHAHC HA HǄ$      HD$0HD$ H$  HD$(H$   HL$PHHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$ 
/HH$   HCH$   H$  HHHCHAHCHAHCHAHC HA HǄ$0     H$   HD$ H$  HD$(HT$XHL$0HHHAHBHAHBl$xHT$PHL$ iL\$XHIHFICHFICHFICHF IC $   LD$0H$   HL$QL$  L$  H$   Hj=H$H  t L$p  I[Is I_LMK ECISIKSVWATAUAVAWHP  HǄ$p  A)sA){MELHE+H HD$ L
 MCHZ H
 jHZ H$    IH$   IH$    - $   C $   5j $   = $   @G $   
?Z $   MIH0$   HHPH$   HHPH$@  n$   Y $   $   fWL$HD$@E3D|$DH
 |$@   Icĸ   $      t$P A;  AAHHL$X` H H$  J GLt$8HD$XHD$0H$  HD$(D$ E3ҋhH$  ) HL$X AE(D$ L
R D$  HR H
 
HGHHHL$ L
fR EE(HR H
d w	Lt$0HGHD$(GD$ LOLH$   I;2H$  L$  D$  L$  D|$D$   t$Pu?HT$XH$   HH$@  iHL$h* HL$X    H$x  H$   L$   H$  DHH$@  H$  lL$   H$  LHHL$X賽HH$@  gHL$h HL$X H$   t H$  f fn  f(^H$  H$@  L$   H$  HH$   H$  Lf(H$x  OLHHL$X_HI3hHL$hϪ HL$XĪ H$    H$   Ɖt$PH
 MIHL ;L H$  L$  D$  L$  D$PD|$D$   $   f/   f/$         DBH$  9 HU H$   HHU HL$HF HH A}HZU H$   H<U H$   oHT$XH$  ̧ MHIAHL$Xs MIASD$@ H$      A}$   |$H   f/$         DBH$  9 HT H$   HHT HL$HF HH`T HT$XH$   MHIAHL$X MIAS|$HD$@ H$  Ȧ H$@  bAD|$DHWHL$X
^HIcHL$h= HL$X2 H
s bLD$ L
bS HCS H
 &H$P   H$@   H$   ۧ H$   ͧ D$H($@  ($0  HP  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/H HD$ L
 L$   HV H
 fA/w/H HD$ L
o L$(  HU H
Y ̋$0  /HI HD$ L
5 L$0  HVU H
 HHPH$   IE HPH$P  fE(D% R  $   fn= YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhH H$p   H$  Υ H H$  H$p  H$   H H$  H$  +Hu3HH$   aHD$pHHL$xH$   H$   HS H$    L$8  I$H$   IH$    HNS H$    I$H$   IH$    9 $   AA   D=n D5 D  G(D$ L
2J D$H  HJ H
 M]ICHD$ L
I DG(HI H
  Ld$0IEHD$(AED$ MMME H$   HAu?HT$@H$   HH$P  %aHL$P HL$@    H$  H$   DLf(H$   HH$P  H$  L
MO H$  谶LHHL$@PHH$P  ^HL$P+ HL$@  H$    H$    fAnf(艉  ^H$  H$P  pL
 H$   訵HH$   H$  @Lf(H$  LHHL$@HH_HL$Pl HL$@a H$   R H$   D AƙA} +	  fA(MHIfD($   fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(Ht$ff     DX HI;IDH;tHufH*HyX
 D^HT$pI;fD(Ⱥ   DBH$0      H$`  Ν HHO H$@  gHHu3
H HcHHHW	   H$    HAH! HHN HH HHu3
H HcHHHW   H$P  ; LHu3
HHcHHISA   H$    HfA(H2 HH(N HHu3
H HcHHHW   H$0   HHH) HHu3
H HcHHHW   H$  j HfA(H HHM HHu3
H HcHHHW   H$@  + HHaH HHu3
H HcHHHWfA(H& H +fn^5M $      Å  Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHuM HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;v HL$`H\$XHt$@H$  H$  HH+Hu3$H;v HtH;t$@t H+H($  f$  L$   A   H$  HL$@H\$XHHL$`H;vS HL$`H\$XHt$@Hu9 E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;v HL$`H\$XHt$@H$   H$   HH+Hu3$H;vp HtH;t$@t^ H+H($   f$  L$   A   H$  HL$@親H\$XHHL$`H;v HL$`H\$XHt$@Hu E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;vk HL$`H\$XHt$@H$   H$  HH+Hu3$H;v/ HtH;t$@t H+H($   f$  L$   A   H$  HL$@eHt$XH;t$`vӚ H\$@HuÚ E3LHI;K wHtH3H;Hs H$@  HHT$@PfE/vHH H$@  KE2fE/vHH H$@  -E2AE D;~"fE/wfE/vH7H H$@  H$   H$0  T M$HIAH$    E   fA(A\A^fATf/G vmHYG H$    I$H$   IH$    HF H$   e I$H$   IH$   d HL$XHt`  HD$X    HD$`    HD$h    HL$@;  H$0  h H$  $   D;$0  uoHE H$   җ I$H$   IH$   ї HJE H$    I$H$   IH$    E2AE$   = HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	I;  H$`   H$P  
 H$0   H$    L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   Hu I EL   HY Iȓ H5ޟ fWDJ E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMH HtHrHEHLmHH}PHHH+HLMIM~)(
 @ Hf(fWHEHf)HI;|LHUHH$   ~%H   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   $@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   $0  H   HUxH$8  HL$(HD$ L$@  L$H  H$0  AY$0  $8  f/v
H$0  H$8  L    A$   L      A$   H   H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM Rt[Eu7A   HG I# HDysHL$x HL$h G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;tmHHtH;tN̄tDH;\$pt$HL$hْ HtHHD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   舨L$   L$   I^HtHH;tHHtH;tḡt]H;$   t$HL$x HtHHD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   褧L$   I|$ uf(H$0  H$   iw  fD(HD$hH$   H|$p tH$0  H$   5f(f(w  f(EtIH   ALD$hHT$xH#f($0  H$0  HMXhY   ux'H   E3LD$hHT$xHL   L]xMHUHH蠫mp\mhfT-^   f/vA         fA/vA   x   f/vA
   bH   H9   rA(   JHX  5 Yf/vA    H.(  Yf/vA   HL$xÏ HL$h AL$   A(sA({E(CIA_A^A]A\_^][LD$SUVWATAUAVAWH   HǄ$   )$   IHHHHXE3I;XtI: Ht
H%HL7H_LnL$   HM H  HH;  Hl$HHUH$(  HEH$8  H$(  L$8  H;IMHHD$( D$8HT$ HL$H{L]L\$PHEHD$XfWt$`HT$HHMeM  L$0  fffff     LHN MSL+M+Ԁ~    HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$    HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$ LEIIHE HHT$ LD$(Hl$8LD$@HHxI+HIH+HHD$pH|$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H|$Pt$`H$0  L|$pAtH/IHHكH$(  H$0  H$(  H;HMHHH+HH+HL,CLE3HT$pHL$HtI;}=D$`fIIH+HHHff     f)HHuLMHT$pHL$HIsE3L$        HHXHI+L;  LEIIHE HHT$ LD$(Hl$8LD$@I+HIH+HHD$pH\$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H\$Pt$`H$0  Ll$pAtH/IHHكH$(  H$0  H$(  H;HMH8HH+HH+HL$GLE3HT$pHL$HI;}>D$`fIL IH+HHHff     f)HHuLMHT$pHL$H蝵IL$   HL@HMt:MtHHIL;tkMtHHIL;tNIIMH;LELD$(LMLL$0MtWMtHHIL;tMtHHIL;tMtHHIL;tηIIHHT$ HmI]H>  @ LHN MSL+L+D8v   HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$    HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$ H($   H   A_A^A]A\_^][HWATAUAVAWH@  HǄ$   HXHhHp)pAAf(LH$: H H$  HH$   HH$   w IUH$   =   L$  DH$   If(H9 H$   	 L$  IH$   IH$       DBH$0   H.9 H$@  Hf(0 H$   H$0   MHIAH$    H$0  τ L$  H|$0H$  Ht$($  D$ $  f(H$   II}HH$   HtH;tiHtH;tT̄tJH;_t"H Ht
HHH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   菉M]I[   l  Ht
HL$PH3HD$PfW$  L$  HHL$PE3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;vՄ H\$PH\$@H|$H(D$@f$   Hu E3LH<I;{ wHtH3H;xs L$   Mup E3MI;{ r\ I.HAHIEIcH;p=H$  ̹   ck  Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM &LHAS   DBH$0  ́ H5 H$@  `HAU$K HH5 DH$   H$0   LHHAH$   B E3E9}$I  D  MEIUH$   KE3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;vł H\$PH\$@H|$H(D$@f$   Hu E3LH<I;{ wHtH3H;xss L$   Mu` E3MI;{ rL I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM `AE;}$}ͷH3 H$    HH$   HH$    H$0   H$   Hth  HǄ$       HǄ$       HǄ$       H$   ph  HL$hHt`h  HD$h    HD$p    HD$x    HL$P;h  H$    H$   
 3L$@  I[0Ik8Is@A(sIA_A^A]A\_HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhD fAWA   DBHX~ H H$@  )HM ~ HT$@H$0  x~ L$  MHIAHL$@ L$   $    t2H$  HD$0Lt$(H$  HD$ MU HH3$(  k2$  E3fW L   ~<EtACu,HQ HL$@f~ IHT$@IHL$@l~ HDFhfAWE f(HV@IIH9^@~@f     H~8IE I+EHH;r IMHHHH;^@|Ћ$(  EuH    u2H     utA  H HL$@} HT$@H$0  )| HL$@} H      H$   { HH H$@  ,HHuI
H HcHHHWHH{ HHE    H$   1{ HH/ H$@  HHuI
H HcHHHW   H$   { LHuI
HHcHHISAL$  AH{ HH W   H$   z HH H$@  -HHuI
H HcHHHW   H$   ]{ LHuI
HHcHHISAH7f(Hb{ HH HFHD$HHx uf(H$  HL$@Nc  f(   H$   y HH H$@  `HHuI
H HcHHHW   HL$pz LHuI
HHcHHISAf(Hz HHb 
   H$  6y HHL H$@  HHuI
H HcHHHW   H$   y LHuI
HHcHHISA   Hz HH a
   H$   x HH H$@  7HHuI
H HcHHHW   H$   gy LHuI
HHcHHISA   Hpy HHB H     H$   w HH% H$@  HHuI
H HcHHHWHH?x HH `H H$@  LHH   x HH -HT$@H$0  x MHIAHL$@1y H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  <E$  Ex.H  HL$@x IHT$@IHL$@x 2H HL$@gx IHT$@IHL$@mx AF   EH$0  H贺LH HL$@x MHIAHL$@%x H$0  x H$0  Ow AL$  A(sA({E(CIA_A^A]A\_^][@USVWATAUAVAWH(  Hl$pHǅ   )   A0uxHA HE8HHE(HB HELzL}hLaHHE0L}XLeHL  MLx Mu    H_ A   LZ HI HHHH   H   H  I;HMH	HM H~H3IHHM 3I;}LII~IHL,IIH    H  HIHIHHH;vߥL4    HI   w9H   HHH;wHHHf  H+H\$pHHH  -I1w HH  HuMthHI     H   H      HH;v%H4    H   w2H   HHH;wHHH#f  H+Lt$pIIHv LHuHtƤH      H  MLU3M  3H}HE HLMIHU`HIHHUpLE0LEPfffff     HHU@HEXL]@L;IMH0H+3HD$8HD$0Ld$(Ht$ IH  3LHU MM  ff     3K</H  HEHH  L;HMHI+HEIHM0LHT$8HT$0H\$(Ht$ LMH  H  1HE HMHM;HMHM(JLt$h3HL$`HL$XHD$PHD$Ht$@H HD$8Ht$0H\$(HEHD$ L  LE8H  1MLHEJHU8H   LL}(Lt$@HMxHL$8Ht$0H\$(HD$ H  LLIH  3LH} I;H}HM@LEPLEpLEPH}`H}L}hI;HE LULM.    t
I$t    t	Ht (   H   A_A^A]A\_^[]@WH@HD$ H\$PHl$XHt$`HHHHXHu36HH;vH<    Hs HuHtסHD$(H\$0LD$(HHHL$(H\$PHl$XHt$`H@_H%Cs @VAVH(  HqLH }H(  A^^H$   H$  H$  HHǄ$H     L$  HL$   H$H  )$   HǄ$P     HHHHH$@  HHH$@  H$P  HMH9   HN3L(L$@  H  5= MHIMFH$@  H$H  I;H$H  HHMILt$8HI@LD$@HHH+HD$ I@H+HT$(HT$0HT$XHHHl$PLt$`HLD$hHl$xHD$HHH$   L$   L$   IHHHHL$ HD$pϖH   H   HL$ H$   HHHAHBHAHBHAHBHA H$   HB HT$HHL$pH$   $H  HL$H  HHAHBHAHBHAHBHA H$   HB HT$H"IIH;HL$   L$  H$  ($   H$  H$   H(  A^^HH\$Ht$WH LBHHHMtHHIL;t衞IMILGLOMt\MtHHIL;thMt:Mt5HHIL;tFMtHHIL;t)IHILK3LKIHH+HHLMM~ D  HHHI;f(Df)D|HHsHC.HH@ƉsH\$0Ht$8H _HL$WH0HD$ H\$HHHLJLB3HHAHAMtDHMtHHIL;tBMtHHIL;t%IIHC HH%HH\$HH0_@SH HHD$8    H4HH [HWATAUH   HD$(HXHhHp EIHHHYHu36HH;vnL$    In HuMtMHD$0H\$8HT$0H%Ht$@HNH$   HVHT$ H$   LD$ H;IML IMtM;tH$   HT$ H$   LD$ H;IMHHtI;t譛̄t裛H;]t%HM :m HtH%HE HE     H]HT$@HHt$@LFIHH$   HVHT$ H$   LL$ H;IMHHtI;tIHH$   HT$ H$   LD$ H;IMHHtI;t̄t֚H;_t"Hnl Ht
HYHH    H_HT$@HmE   HFHt$PHL$0HL$XD$` HHD$hHD$p   LFMtMtIHIL;tEMt:MtIHIL;t#MtIHIL;tIIMHHHL$PHL$0k L$   I[(Ik0Is8IA]A\_HVWATH   HD$ HXHh)pIHHZ IHu3,I;vfH<    Hk HuHtEHD$(H\$03H~;fWfffffff     HH$   6XHD$(HH;|$0|HM@HT$PH$   H$   HD$@HD$(HD$HH|$0Ht$HH;t觘̄t蝘H;} tIHM4j Ht2I;v}H4    Hj HuHt\HEHE    H} HUHL$8kHL$Pi HL$(i L$   I[ Ik0(t$pIA\_^HUVWATAUAVAWH   HD$0HX )p)xD)@HLA   AAHjHHtH;t蚗̄t萗3H;i t!HI%i HtHIEIuIm H  HIMH HE   HLLI1MELD$@MMLL$Hq D$PMtWMtHHIL;tMtHHIL;tӖMtHHIL;t趖IIIMMMMIHH+HLMHM~&(b fffff     IE f)HI;|IHL$8AAu8AE<E}=I  LKLCMtMtHHIL;tMt:MtHHIL;tMtHHIL;tԕIIILKLCMt:MtHHIL;t蛕MtHHIL;t~IIInHI3Ll$@H$  HL$8,<$   fWf.zuo $   Ll$@D$HHT$8INH}H$  HIM(6EME(IUI"E3IMH!  =Xi Dl H;  HH+H<  H   HH+HHHHf     ME(IEBTfTfTLfTDfTXfTAYf/rNLME(IEBTfTfTLfTfTXfTAYf/rNLME(IEBfTfTfTDfTXfTAYf/rNME(IEBTfTfTLfTDfTXfTAYf/rNLH HH;}GIM(IEfTfTLfTfTXfTAYf/rLHH;|H|]IE(HLAf.zyuwf.z8u6Af.z%u#Af.zuHH HH;H5H0H  IE(HLf.zuHHH   H   IHHkL;   H_H|]IE(HLAf.ztmf.zt*Af.zt"Af.ztHH H~H2H,H&H~!IE(HLf.ztHHHEtIE IHl$(HD$ LLIU(IMyE3HHkL;EM8AE8   A9u8   IH$  H       IEH
Iɸ   H;    f/vf(HHH;|H   LIEJHH;tHHEt^IUIM HIHHD$8HT$@Ll$PHT$XHHHHD$`HT$hLl$xH$   E3HT$8HL$`*vE3HHH;(H$   IMAE<E}=IL$   I[XA(sA({E(CIA_A^A]A\_^]HL$VWATAUAVH0HD$ H\$hHl$pELHLJLB3H1HqHqMtDHMtHHIL;tMtHHIL;tƏIIHI|$IHuH,I;v蒏H,    H0a HuHtqHCH{ I|$H~H   Ht/I;vDH,    H` HHuHt Hs(H{0C< EIHHH\$hHl$pH0A^A]A\_^HL@HPHHSVWATAUAVAWH`  HǄ$  )p)xD)@D)HMHL   nG  HtHL$8H33HHD$8H\$PH\$XH\$`   :G  Ht
HL$xHHHD$xH$   H$   H$   H\$(HD$xHD$ LL$8MHIY'fD($   H~ H+~HH$   H$   H$   HtNHt"HHHHH;t謍HHtHHHH;t腍LLMt3_ IH$   H$   H$   HH$   H$   H+HHtCH;r^ H$   HH$   HHH$   H$   H+HH;rH~ H+~HHuH6HH;vČL$    Ib^ HuMt裌HD$hH|$pHHD$XHL$PH+HHt6H;r^ HL$PHHD$hHHHD$XHL$PH+HH;rHT$hH$   bH~ H+~H   E  Ht
H$   HHH$   fWD$0LD$0HH$   U5<p D D$   = fD/  Y5o t$0fD/   H$   HtFD  H$   H$   H$   H$   !D  HL$h] H$   \ H$   HtC  H$   H$   H$   HL$xC  HL$PHtC  H\$PH\$XH\$`HL$8C  fA(  HHF H+FHHtlH;rc\ LfLl$hH$   H$   H+HH;r8\ H$   f(AYL A\HHF H+FHH;rH\$ LL$8MH$   If(|3L$  H$  L$  D$   t$0D$   $   :HHF H+FHHtgfD  H$   L$   I+HH;r^[ L$   HF H+FHH;r?[ HNIHHHF H+FHH;rH$   Ht)B  H$   H$   H$   H$   B  HL$hZ H$   Z H$   HtA  H$   H$   H$   HL$xA  HL$PHtA  H\$PH\$XH\$`HL$8A  f(L$`  A(sA({E(CE(KIA_A^A]A\_^[HL@UVWATAUAVAWHP
  HǄ$  HX )p)xD)@D)HD)xMMLH   DǸ   $
  H$ 	  X Hy H$  X Hu H$p  HpV H$x  H$  H$  X H$  X Hy H$0  NX H$P  HU H$X  H$0  H$`  HX H$0  1X D]    AA+iA+L$
  AM utAE A}  uA}   AA+iD+E]uEtAAEA} uA}]HL HIHIMUfW$
  I\$   ?  3Ht
H$   HHH$   L$
  HH$   I\$H$8  $H  HuH;HH;vMH4    HW HHuHt)3HL$`H\$hHHt$H;t̄t̄tH\$hHHH+HLMHM~ (Q @ f)HI;}HL$`LHT$`H$0  膂$
  I\$0I+\$(H   V>  Ht
H$   HHH$   L$
  HH$   1   >  Ht
H$`  HHH$`  H$x  H$  H$     =  Ht
H$  HHH$  H$  H$  H$  HUH$  hU H$  aT H$  H$
  HUpH$  OrH$  H$
  HU0H$  qL$  L$
  H H$  H$  H$  pH$  H$X  qH$  V%H$  <  H$  :%H$  <  H H$  S tH H$  R    H H$  S tH H$  Q mDǺ   H$  :S    H$  cS HT$pH$  (S HH$  nS HL$pS H$  S Ht H$0  S Ho H$  H$	  H$   H$0  H$(  xS H$0  aS       H$
  H$  RtG$
  f.zuL$  IHL$`iH$  HD$ MMHT$`JH$  HL$pR t$8\$0H$  HL$(H$  HL$ MMHT$`H8u[HT$pH$ 	  Q HH$  S HHW H$  HH$  gR H H$  n:  3H9\$h~VHD$`H$
  H$   H$   H+HH;rS H$   H$
  HHHHcH;D$h|H$(  Q HX H$  H$X  H$
  H$  H$  H$X  H$  H H$  H$  ($  f$0  ($  f$  L$0  L$  H$  H$X  H$  A9  3H$  H$  H$X  "9  H$  H$
  H$  !H$  8  H$  P N9  Ht
H$   HHH$   H$   H$   H$   Ht$8D$0D$(H$   HD$ L$   L$   IIf     HO H
N O HH HHO O    (  H/q H$  O HRl H$  HM H$  H$  H$  O H$  O L$  L\$(t$ f(L$   H$   I/HT$pH$ 	  N HH
/M N HHN N HL$pMO AAFINH$   蔀H$  %O H=U H$  H$   Ht7  H$   H$   H$   H$   6  H$  N H$  Ht6  H$  H$  H$  H$  6  H$x  Ht6  H$x  H$  H$  H$`  k6  H$  HtX6  H$  H$   H$(  H$   36  HL$`O H$   Ht6  H$   H$   H$   H$   5  H$`  M H$P  H$  M H$p  H$ 	  L 3/3  H$  K H$  J    X    tAD    DEH   r	H   H   A@   H$  J       t1H  r	H   H   A@   DH$  yJ H H$  L H,i H$  H$  H$  H$  H$  L H$  L D   A	  (  ,  $  At*AtAtAt3   3      DH  D8  D@  D  $
  0  $
  4  $
      t@H H$  详HH 蠦HH>K @K H$     t@H H$   fHH WHHJ J H$   K $   I\$H$8  $H  H/LH$  H$  Ht.HH;t^z̄tTz̄tJzH$  HHH+HLMM~*(E I@HHff     fA)IHuLH$  H$0  vL$0  HIH H$8  L$  L$  HT$`H$0  oeJ +$   fDnE= D^HI H
G I H H
G HI H
G I HqI H
G lI H H
G 詤HHo 蚤H;I H
|G 6I H'I H
hG "I H H
TG _HfA(H HH_ BHHH H fnYAYHr H
G Hf(H HH? HHH H Hk H
F ϣHpH H
F kH H\H H
F WH H H$  H He H$  HkF H$  H$  H$  H H$  ~H Hi H$0  IH H$  H$  H$   H$0  H$(  BH H$0  +H H H$  G LH$   H$  ng$  g            	0  Ht
HL$pH3HD$p3H$   H$   H$   H* H$  tG H$  HL$p1H$  rG AEHT$pInBHS H$  )G L$  H$  HL$p.H$  G HL$pz$
  D$8$
  D$0$  D$(t$ MLD$`IHL$p芓L$  L\$@H$  HD$8H$  HD$0|$(DL$ $
  DEfA(HL$p蛿$
  $  ^            .  Ht
HL$pH3HD$p3H$   H$   H$   H H$  E H$  HL$p趶H$  E AEHT$pI@H( H$0  E L$0  H$  HL$p賅H$0  E HL$pIy$
  D$8$
  D$0$  D$(t$ MLD$`IHL$pL$  L\$@H$  HD$8H$  HD$0|$(DL$ DEfA(HL$pII   HhH$  D H=K H$  H$(  D H$  H$  D H$  H$  E H$  D H$  H$  B H$  B H$   Htq,  3H$   H$   H$   H$   J,  H$  /D H$  Ht(,  H$  H$  H$  H$  ,  H$x  Ht+  H$x  H$  H$  H$`  +  H$  Ht+  H$  H$   H$(  H$   +  HL$`sD H$   Htt+  H$   H$   H$   H$   O+  H$`  4C H$P  H$  C H$p  H$ 	  NB 3(  A
  (  \
  Hw H
@ 裝HHAB CB H| H
u@ 耝HH$  B HH
B B     t3HG H
8@ CHH   A HHA A ,  H H
? 	H@ HHA A 0  H H
? ҜHf(]A HHcA eA 8  H H
? 蚜Hf(%A HH+A -A @  H H
W? bHf(@ HH@ @ H  H H
? *Hf(@ HH@ @ P  H^ H
> Hf(}@ HH@ @ X  H6 H
> 躛Hf(E@ HHK@ M@ `  H H
y> 脛Hȋq? HH@ @ ] H H
H> SHȋ ? HH? ?     >  H H$  HH HH? ? H$  KH` H$  ךHH ȚHHv 蹚HH I? HHG? I? H H$  腚HH[ vHHu gHH > HH> > H H$  3HH! $HHvu HH > HH> > H H$  HH ҙHH ÙHH$  R> HHP> R> ,  H H$  臙HH xHH iH== HH= = 0  H H$  1HHO "HHt Hf(= HH= = 8  HO H$  ژHH ˘HH% 輘Hf(G= HHM= O= @  H  H$  胘HH tHH eHf(< HH< < H  H H$  ,HHr HH Hf(< HH< < P  Hb H$  ՗HH+ ƗHH8 跗Hf(B< HHH< J< X  H H$  ~HH oHH `Hf(; HH; ; `  H H$  )HH HH Hȋ: HH; ; ] H~ H$  ٖHH_ ʖHHT 軖Hȋ: HHN; P; H$  H$  H H$0  ; H$0  H$  :H$0  {; AEH$  It6H HL$p2; LD$pH$  H$  7{HL$p+; H$  n$
  ,  $  H8 H$0  H$  [LL$   IH$0  WH$   H$  lHc`  H$  d0  $  8  $  P  $  @  $   X  $(  H  $   H&oHcH$  H[ HL$p9 HiV H$  H$  H$  HT$pH$  9 HL$p9 L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  Ih$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(II\H$  6 3Ht$8D$0D$(H$`  HD$ L$   L$   IININ8H$`  -jAvhH$  8 H=i? H$  H$0  H$  <    H H
36 >HH7 7 H H
6 HH$  7 HH7 7     t3H H
5 ޒHH   n7 HHl7 n7 ,  H H
5 褒Hx6 HH67 87 0  Hq H
b5 mHf(6 HH6  7 8  HI H
*5 5Hf(6 HH6 6 @  H! H
4 Hf(6 HH6 6 H  H H
4 őHf(P6 HHV6 X6 P  H H
4 荑Hf(6 HH6  6 X  H H
J4 UHf(5 HH5 5 ] H H
4 "Hȋ4 HH5 5       H H$  HH< אHHu5 w5 H$  L H4 H$  _L H1 H$  DL- H. H$  )L$  H& H$  }D,  D$
  L$
  H H$  象0  $
  L$
  H H$  8  $
  L$
  H̿ H$  @  $
  L$
  H H$  JH  $
  L$
  H H$  }P  $
  L$
  Hm H$  谢X  $
  L$
  HP H$  D] D$
  L$
  H8 H$  H$  >H$  AH HL$p3 HT$pH$  苤HL$p3 AEH$  I.H} H$0  3 L$0  H$  H$  sH$0  v3 H$  g$
  ,  $  H1 H$  H$  PLL$   IH$  PH$   H$  e0  $  8  $  P  $  @  $   X  $  H  $  HgHcH$  HS HL$pX2 HN H$  H$  H$  HT$pH$  M2 HL$p92 L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  I$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(IITH$  / 3Ht$8D$0D$(H$`  HD$ L$   L$   IIFIN8H$`  bAvhH$  1 H=7 H$  H$  [{H$  >KS  C  H H
. 蝋HH;0 =0       H] H$  lHHڻ ]HH/ / H$  L1 Hڻ H$  Ln H׻ H$  ʏL HԻ H$  诏L$  H̻ H$  D] D$
  L$
  H H$  ۞H$  H$  H HL$p/ HT$pH$  KHL$p/ AEH$  I*H H$0  C/ L$0  H$  H$  EoH$0  6/ H$  bH$  [Ht$ L$  L$   H$   If(f(\58 H H
, 袉Hf(-. HH3. 5. f(\f(D
2 fAT^D fA/  A   2 fD(E3L$   H$   If($      H? H
+ IH$0  B, HH
+ gHȋ, HH ɈHH$  , HH H
+ 袈HH7gHf("- f(A\Hڹ H
c+ nHf(, HH RH, H
4+ , H
'+ i, 
   ǀ       f(H$  , HȲ,1Ht$8D$0D$(H$`  HD$ L$   L$   IIBH HL$p, LD$pH$  H$`  mHL$p, f(A\f(fAT^fA/#L$
  Ht$8D$0D$(H$`  HD$ L$   L$   IIBIN8H$`  ]A~h    tdf(H$  + HȲ,%Hj HL$p+ LD$pH$  H$`  mHL$p+ H$  ) H$  Ht  H$  H$  H$  H$    H=W2 H=N2 H$  + H$  H$  ) H$  ( H$   Ht[  H$   H$   H$   H$   6  H$  + H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$     HL$`_+ H$   Ht`  H$   H$   H$   H$   ;  H$`   * H$P  H$  	* H$p  H$ 	  :) 3{  HH$   H$   H+HHt?H;r* H$   HHD$`HHH$   H$   H+HH;r   t,H   G' Hл   DK>DH$  &        t@H H$  HHl HH( ( H$  j   t@H H$   轃HHC 讃HHL( N( H$  !x  tuD(  I|$ u_tZH
 HL$pb( H$  ) H;- H$  HT$pH$  X( H H$  _  f(f(HT$`H$H  g  H1 H$
  ,   t-HǴ H
% 軂HHY' [' 3ۉ,  3Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$
  MIHH0 H$
  Ho H$H  H$P  9( H$  2' H=- H$  H$  $ H$  $ H$   Ht  H$   H$   H$   H$     H$  & H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`  Z  H$  HtG  H$  H$   H$(  H$   "  HL$`' H$   Ht  H$   H$   H$   H$   
  H$`  % H$P  H$  % H$p  H$ 	  $ 3  t(ttǄ$
  '  333ۉ$
  	$
  3ۍ$
  A@   tdy]
  HcHlH
 H
 HMIH$  赣HH$  TLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$    MIH$  HH$  lLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH[H$  ͠B  MIH$  e2HH$  dLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  腠  MIH$  =2HH$  |Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH+H$  M  MIH$  yHH$  tLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  z  MIH$  
zHH$  茔Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ݟ  MIH$  UHH$  脔p  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  MLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ~  MIH$  ƫHH$  Ep  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  .Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$    MIH$  .HH$  L$P  L\$ L$p  LD$`HH$  /Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH[ H$  蝫B  MIH$  .HH$  ԓL$P  L\$ L$p  LD$`HH$  j/Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ;  MIH$  svHH$  袓L$P  L\$ L$p  LD$`HH$  /Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  )   MIH$  avHH$  萓L$P  L\$ L$p  LD$`HH$  0Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  gH?e H$H  H$P   H$  z H=*# H$  H$   H$   H$   HtF  H$   H$   H$   H$   !  H$   H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$   j  HL$`J H$   HtK  H$   H$   H$   H$   &  H$`   H$P  H$   H$p  H$ 	  % 3iH HL$p H$   H H$  HT$pH$   H H$  HF H$    L$P
  I[XA(sA({E(CE(KE(SIA_A^A]A\_^]è=
 @>
 >
 p?
 @
 @
 8A
 'B
 C
 C
 D
 \E
 G
  	
H   HD$0LHp  L  L@  H  HD$(LT$ ItNH HL$8	 HL$`M H HD$`HT$8HL$x H HL$`  3HĨ   %T %F %8 %* % % %  % % % %` %R %D %6 %( % % % % % % H\$Ht$WH Ht*DAL
       @t	HK3   HCv  @tH   HH\$0Ht$8H _%L %6 %  %
 % % % % % %n %` %J %< @SH HH
đ  HD$8HuH ~     H
  HD$8H
|  HD$@H HLD$@HT$8<  HHL$8 HI HL$@~ H/      HH [H(GHH(@SH     HH/ H Hِ HuC#H#   H
  H
  3H [HHXHhHxL` AUAVAWH 3ML;8  A ;#  D. eH%0   HXH;t   3H$ uA    t   [    H
 3 LH;   H
  MLHHI;rZH9} t H9E tHM  H HE H
  H
 H L;uL;tLLIE  Hh Hi =C D;   H=;    3      eH%0   HXH;t  ] 3H u    ;t   3  >H5 H
4       ;uH4 H
       ;u
HH H9= t!H
   ;tMĺ   Im ?    H\$@Hl$HH|$PLd$XH A_A^A]HHXHpHxATH0IL   Xi u9 u
3ۉX   tu3H HtЋ؉D$ tLƋI4؉D$    LƋI  ؉D$ u5u1L3I  L3ILM MtL3IAӅtu7LƋI#ˋىL$ tH HtLƋIЋ؉D$ 3ۉ\$ i H\$@Ht$HH|$PH0A\H\$Ht$WH IHug  LǋHH\$0Ht$8H _H\$DD$HL$VWATH@IALHك|$pxI+H\$`H H\$hH@A\_^HLH D@HPSVWATH8MIcH` HHHHX|$pxH+H\$`HAD$    H8A\_^[% %r %d %N H
݋ 8  H\$WH Hw H=p HHtHH;rH\$0H _H\$WH HO H=H HHtHH;rH\$0H _HMZ  f9t3HcH<H39PE  u  f9QLcA<E3LLA@EXJL EtQL;r
AL;rAH(E;r3HH(LL
Ijt"M+IIHt@$Ѓ3H(% % % % H(uH=[  u
    H(H\$WH HWf Hd$0 H2-+  H;tHH@f vHL$0c
 H\$0`
 DI3\
 DI3X
 HL$8DI3O
 L\$8L3H  L#H3-+  L;LDLe ILe H\$@H _% %h % ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H@UH HHM@m H ]@UH HHM( H ]@UH HHM( H ]@UH HHM( H ]@UH HHM( H ]@UH HHM(} H ]@UH HHMh] H ]@UH HHM(= H ]@UH HHM( H ]@UH HHM(
 H ]@UH HHM(
 H ]HT$UH HHM0HPHH
 H	 H H ]HT$UH HHMpHPHH
 H	 H H ]HT$UH HHM@HPHH
G H	V HE H ]HT$UH HHM`HPHH
 H	 H H ]HT$UH HHM HPHH
 H	 H H ]HT$UH HHM(HPHH
 H	 H H ]HT$UH HHM8HPHH
_ H	V HE H ]HT$UH HHMHHPHH
' H	 H H ]HT$UH HHMXHPHH
 H	 Hſ H ]HT$UH HHMhHPHH
 H	 H H ]HT$UH HHMxHPHH
 H	V HE H ]HT$UH HH3 H
E H	 H H ]@UH HHMP
 H ]@UH HHM@n9H ]@UH HEHt
eHHM@>H ]@UH HHM@M
 H ]@UH HExtexHMp
 H ]@UH HHM(	 H ]@UH HH   	 H ]@UH HH   	 H ]@UH HHM(	 H ]@UH HHMP H ]@UH HHM(M	 H ]@UH HH   r H ]@UH HH   
	 H ]@UH HH    H ]@UH HHM  H ]@UH HHM  H ]@UH HHM  H ]@UH HHM 	 H ]@UH HHM 	 H ]@UH HHM }	 H ]@UH HHM ]	 H ]@UH HHM`=	 H ]@UH HHM 	 H ]@UH HHM  H ]@UH HHM  H ]@UH HHM` H ]@UH HHM M H ]@UH HHMpu H ]@UH HHMH
 H ]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH   j H ]@UH HHM(= H ]@UH HHMPm H ]@UH HHM( H ]@UH HHMP- H ]@UH HHMPH ]@UH HH   H ]@UH HHMh^GH ]@UH HHM`H ]@UH HHMP~H ]@UH HHMPFH ]@UH HH   ;H ]@UH Hꋅ   t   H   FH ]@UH HHMPH ]@UH HHMP^FH ]@UH HH   H ]@UH Hꋅ   t   H   FH ]@UH Hꋅ  t  H  GH ]@UH HHMPH ]@UH HHMPEH ]@UH HH   H ]@UH HH   KEH ]@UH HHM .EH ]@UH HHM EH ]@UH HH  DH ]@UH HHM DH ]@UH HH   DH ]@UH HH   FH ]@UH HHMPH ]@UH HHMP>DH ]@UH HH   {H ]@UH Hꋅ   t   H   CH ]@UH Hꋅ  t  H  EH ]@UH HHMPH ]@UH HHMPnCH ]@UH HH   H ]@UH HH   +CH ]@UH HHM CH ]@UH HHM BH ]@UH HH  BH ]@UH HHM BH ]@UH HH   BH ]@UH HH   {DH ]@UH HHMP螿H ]@UH HHMPBH ]@UH HH   [H ]@UH Hꋅ   t   H   AH ]HT$UH HH  HHEHHH H ]@UH HHM 达H ]@UH HHM 2H ]@UH HH   *  H ]@UH HH   
  H ]@UH HHM`2H ]@UH HHM`H ]@UH HH(    H ]@UH HHM ޽H ]@UH HHM 辽H ]@UH HHM 1H ]@UH HH   *  H ]@UH HH   
  H ]@UH HHM`1H ]@UH HHM`H ]@UH HH(    H ]@UH HHM ޼H ]@UH HHM 込H ]@UH HHM 0H ]@UH HH   *  H ]@UH HH   
  H ]@UH HHM`0H ]@UH HHM`H ]@UH HH(    H ]@UH HHM ޻H ]@UH HHM 辻H ]@UH HHM /H ]@UH HH   *  H ]@UH HH   
  H ]@UH HHM`/H ]@UH HHM`H ]@UH HH(    H ]@UH HHM ޺H ]@UH HHM 辺H ]@UH HHM .H ]@UH HH   {H ]@UH Hꋅ   t   H   .H ]@UH HHMX  H ]@UH HH     H ]@UH HH     H ]@UH HHM ιH ]@UH HHMH螨H ]@UH HHMH~H ]@UH HHMP^H ]@UH HH   ;H ]@UH HHMHH ]@UH HHMHH ]@UH HHMPΧH ]@UH HHMP讧H ]@UH HHMP螸H ]@UH HHMP^NH ]@UH HHM ^H ]@UH HHM NH ]@UH HH   MH ]@UH HHMPH ]@UH HHMPMH ]@UH HHM 讷H ]@UH HHM nMH ]@UH HH   KMH ]@UH HHMP>H ]@UH HHMP^H ]@UH Hꋅ0  t0  H   W^H ]@UH HH   ˶H ]@UH HH   K9H ]@UH HH  苶H ]@UH HH   ;H ]@UH HHh    H ]@UH HH  :H ]@UH HH    H ]@UH HHMPH ]@UH HHMPεH ]@UH HHMP]H ]@UH Hꋅ0  t0  H   \H ]@UH HH   [H ]@UH HH   7H ]@UH HH  H ]@UH HH   9H ]@UH HHh    H ]@UH HH  k9H ]@UH HH  J  H ]@UH HHMP~H ]@UH HH   [H ]@UH HH   [H ]@UH HH   H ]@UH HH   k[H ]@UH HH@    H ]@UH HHMhm  H ]@UH HHMh[H ]@UH HHMh~H ]@UH HHMhZH ]@UH HHMh>H ]@UH HHMh  H ]@UH HHMh  H ]@UH HH   ۲H ]@UH HH   軲H ]@UH HHM0莲H ]@UH HHM05H ]@UH HHM`NH ]@UH HHM`4H ]@UH HH   4H ]HT$UH H螦L LhK H   Q )3  H H ]@UH HH   蛱H ]@UH HH   4H ]@UH HH   [H ]@UH HH   3H ]@UH HHMhH ]@UH HHMh3H ]@UH HHM8ްH ]@UH HHM8^3H ]@UH HH   ;3H ]@UH HH   3H ]HT$UH HLW LI *G   \P 3  H H ]@UH HH   H ]@UH HH   2H ]@UH HH   ˯H ]@UH HH   WH ]@UH HH   苯H ]@UH HH   VH ]@UH HHM@VH ]@UH HHM@.H ]@UH HHM@~VH ]@UH HHM@H ]@UH HHM@n1H ]@UH HH   諮H ]@UH HH   苮H ]@UH HHM ^H ]@UH HHM DH ]@UH HH   H ]@UH Hꋅ  t  H   CH ]@UH HHMPέH ]@UH HHMPN0H ]@UH HH   +0H ]@UH HH   0H ]@UH HHM >H ]@UH HHM ~!H ]@UH HH   H ]@UH HH   ;!H ]@UH HH   軬H ]@UH HH   {BH ]@UH HH   *  H ]@UH HHM` H ]@UH HHM`>H ]@UH HHM`AH ]@UH HH   H ]@UH HHM ޫH ]@UH HH  j  H ]@UH HHMp>.H ]@UH HHM8~H ]@UH HHM8-H ]@UH HH   ;H ]@UH HH   -H ]@UH HH  {H ]@UH HH  H ]@UH HHP  mH ]@UH HH   lH ]@UH HH   H ]@UH HH   [H ]@UH HH   [H ]@UH HH   H ]@UH HH   H ]@UH HHM0^H ]@UH HHM0H Z,H ]@UH HH   H ]@UH HHM0HPzH ]@UH HHM0kH ]@UH HH0  H ]@UH HH0  H +H ]@UH HH   {H ]@UH HH0  HPH ]@UH HH0  kH ]@UH HH@  H ]@UH HH`  kmH ]@UH HEhtehH  =mH ]@UH HH`  H ]@UH HH   H ]@UH HH  kH ]@UH HH   軧H ]@UH HH   OH ]@UH HH   {H ]@UH HH   NH ]@UH HHM`NH ]@UH HHM`H ]@UH HHM`nNH ]@UH HHM`ަH ]@UH HHM0zH ]HT$UH HNL L@ j=   F ]$  Hv H ]@UH HH   KH ]@UH HH   +H ]@UH HHMPH ]@UH HHMP>H ]@UH HHM 辥H ]@UH HHM H ]@UH HH   H ]@UH HH   [H ]@UH HHM >H ]@UH HHMPH ]@UH HHM H ]@UH HHM >H ]@UH HH   j  H ]@UH HH   J  H ]@UH HHM`H ]@UH HHM`^H ]@UH HH(    H ]@UH HHM H ]@UH HHM`.H ]@UH HHM0NH ]@UH HHM0.H ]@UH HHMHH ]@UH HHMHH ]@UH HH   k	H ]@UH HHM 讍H ]@UH HHM 莍H ]@UH HH   	H ]@UH HH   KH ]@UH HHp  諢H ]@UH HHp  IH ]@UH HH  kH ]@UH HH  IH ]@UH HH  +H ]@UH HH  kH ]@UH HH   H ]HT$UH H~Lǟ LH; 8 v  A !  H H ]@UH HH   7H ]HT$UH HLW L: *8 w  \A !  H H ]@UH HH   {HH ]@UH HH   H ]@UH HH   ;HH ]@UH HH   諠H ]@UH HHM JH ]HT$UH HLg L9 :7   l@ "  H H ]@UH HH   {H ]HT$UH H讔L Lx9 6   ? (#  HA H ]@UH HH  諟H ]@UH HH  苟H ]@UH HHp  kH ]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH: H0]HT$UH0HHZ H0]HT$UH0HHz H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH: H0]HT$UH0HHZ H0]@UH HHM(]  H ]@UH HHM(=  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM@%  H ]@UH Hꋅ`  t`  HP    H ]@UH HHM@^H ]@UH HHM@.H ]@UH HHM(H ]@UH HHM(4H ]HT$UATH(HHUpHHcHHA     H57 H(A\]@UH HHM(H ]@UH HHM(nH ]@UH HHM(~3H ]HT$SUH(HHUpHHcHHA   F  H8 H(][@UH HHM(H ]@UH HH     H ]@UH HHMh  H ]@UH HHM(  H ]@UH HHMH  H ]@UH HH     H ]@UH HHM m  H ]@UH HHM M  H ]@UH HHM -  H ]@UH HHM 
  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]HT$UH HHMHHt
H   33{H ]HT$UH HHMHHt
H   33;H ]HT$UH H33H ]@UH HH     H ]@UH HHMh  H ]@UH HHM(  H ]@UH HH     H ]@UH HHM(M  H ]@UH HH   *  H ]@UH HHMP]  H ]@UH HHMH  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HHM m  H ]@UH HHM M  H ]@UH HH   r  H ]@UH HHMH
  H ]@UH HHM   H ]@UH HHMH  H ]@UH HHM   H ]@UH HHMH  H ]@UH HHM@H ]@UH HHM@e  H ]@UH HHM@
  H ]@UH HHM@H ]HT$UH HHMH33H ]@UH HH     H ]@UH HHM8  H ]@UH HH  R  H ]@UH HHM`]  H ]HT$UH H33^H ]@UH HHM`  H ]@UH HHM8  H ]@UH HHM@H ]@UH HHUXHM(H ]HT$SUWH HH]PH}`H;t@ H  H(H;u33虽H _][@UH HHM`  H ]@UH HHM8-  H ]@UH HHM0
  H ]@UH HH   HM(H ]HT$SUWH HH   H   H;tH  H(H;u33ǼH _][@UH HHM@H ]@UH HHM@  H ]@UH HHM@H ]@UH HHM@m  H ]@UH HHM@H ]@UH HHM@)H ]@UH HHMH)H ]@UH HEPtePHM@HxlH ]@UH Hꋅ   t   HM Hx6H ]@UH HHM   H ]@UH HHM H ]@UH HEXteXHM@Hx H ]@UH HHM@~H ]@UH HHU(HM0H ]HT$SUWH HH]XH}PH;t@ Hw  H(H;u33艺H _][@UH HEPtePHM@HP H ]@UH HEPtePHM@HxH ]@UH HHM@莗H ]@UH Hꋅ   t   HM(HPH ]@UH HHM(΂H ]@UH HEXteXHM@Hx<H ]@UH HHM@H ]@UH HEXteXHM@HxH ]@UH HHM@ޱH ]@UH HEPtePHM@H`H ]@UH HEPtePHM@HxlH ]@UH HHM@>H ]@UH HEPtePHM@HxH ]@UH HHM@H ]@UH Hꋅ   t   HM(H`H ]@UH HHM(.H ]@UH HEXteXHM@H`|H ]@UH HHM@H ]@UH HH     H ]@UH HH   RH ]@UH HHM0-  H ]HT$UH HH'? H ]@UH HEPtePHM@H`H ]@UH HHM@H ]@UH Hꋅ   t   HM HxVH ]@UH HHM   H ]@UH HHM H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEPtePHM@HxLH ]@UH HHM@^H ]@UH HEPtePHM@HxH ]@UH HHM@.H ]@UH HEXteXHM@HxH ]@UH HHM@nH ]@UH HEPtePHM@Hx\H ]@UH HHM@H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEPtePHM@HxH ]@UH HHM@H ]@UH HH     H ]@UH HH   z  H ]@UH HHMP  H ]@UH HH     H ]@UH HH     H ]@UH HHMPM  H ]@UH HHM H ]@UH HH     H ]@UH HH     H ]@UH HHMP  H ]@UH HH     H ]@UH HH   :  H ]@UH HHMPm  H ]@UH HHM@NH ]HT$UH HHM@蚉33H ]@UH HHM@H ]@UH HHM@~H ]@UH HHM(辈H ]@UH HHM@M  H ]@UH HH   kzH ]@UH HH   [H ]@UH Hꋅ0  t0  HM0HPH ]@UH HHM0yH ]@UH HHM0H ]@UH HH@  H ]@UH HH8  {H ]@UH HHM0NH ]@UH-8 $8 ]@UH HHH  H ]@UH Hꋅ0  t0  HH  HPH ]@UH HHM HH ]@UH HH   xH ]@UH HH   {H ]@UH Hꋅ@  t@  HM0HPH ]@UH HHM0NxH ]@UH HHM0H ]@UH HHX  H ]@UH HHH  H ]@UH HHM0NH ]@UH6 6 ]@UH HH   WH ]@UH Hꋅ@  t@  H   HPH ]@UH HHM H*H ]HT$UH HHMX֭33H ]@UH HHMP読H ]@UH HEHteHHMPHPLH ]@UH HHMP螂H ]@UH HHMP:H ]@UH HEHteHHMPHPH ]@UH HHMPH ]@UH HHMHʬH ]@UH HH   KH ]@UH HjpH  J&H ]@UH HjpH   *&H ]HT$UH HH   C33RH ]@UH HjpHMH%H ]@UH HjpHM`%H ]@UH HHM@H ]@UH HHMPHjmH ]@UH HHMPHJmH ]@UH HHM`H*mH ]@UH HHM`H
mH ]@UH HHM`H0lH ]@UH HHM@^H ]HT$UH HHM@誂33H ]HT$UH HHMpƪ33ժH ]HT$UH H33讪H ]HT$SUVWATH0HDe0A~$H}@HH]8LHH   HH   H]8H}@E~#H   HHLHHHH
33H0A\_^][@UH HHMP  H ]HT$UH0HH   LH   HA NH   HPJU33蠩H0]@UH HHMP]  H ]HT$UH HHM`F33UH ]HT$UH H33.H ]HT$UH HHM`33H ]HT$UH H33ިH ]@UH HHMPHH ]@UH HHM(H ]@UH HHMPH@JH ]@UH HHM0H ]@UH HHM@HiH ]@UH HHM@HiH ]@UH HHM@H(iH ]@UH HHM@H8ziH ]@UH HHM@HHZiH ]@UH HHM@HX:iH ]@UH HHM@H ]HT$SUH8HL   H   HH   H)338H8][@UH HH   軅H ]@UH HH   軟H ]@UH HH   ˵H ]@UH HHUXHM(H ]HT$SUVWH(HH]PH}`H;tHuhHHdH0H;u33fH(_^][@UH HHMH  H ]@UH HHM   H ]@UH HH   *  H ]@UH HH   KH ]@UH HH@  H ]@UH HH   [H ]@UH HHMp]  H ]@UH HHMH=  H ]@UH HHM   H ]@UH HH     H ]@UH HH   *  H ]@UH HH   KH ]@UH HH  [H ]@UH Hꋅ   t   HMXZH ]@UH Hꋅ   t   HM(*H ]@UH HHM`n{H ]HT$UH0HHM`
33H0]HT$UH HHM@{33H ]HT$UH0HHM`Z{33赣H0]HT$UH HHM@*{33腣H ]HT$UH0HHMhF33UH0]@UH HHMPU  H ]@UH HHM(  H ]HT$UH0HHMp֢33H0]HT$UH0H33辢H0]@UH HHM(}  H ]@UH HHMP  H ]@UH HHMPH ]@UH HHM(~H ]@UH HHU(HM0
H ]HT$SUVWH(HH]hH}`H;tHuxHHH0H;u33֡H(_^][@UH HHMh  H ]@UH HHM(  H ]@UH HHM(H ]@UH HH   ~H ]@UH HHUXHM(H ]HT$SUVWH(HH]PH}`H;tHuhHHH0H;u33H(_^][@UH HHMp  H ]@UH HHMH}  H ]@UH HHM ]  H ]@UH HH   :  H ]@UH HH   j  H ]@UH HH   H ]@UH HH  H ]HT$UH0HH   33ҟH0]HT$UH0HH   Gw33袟H0]@UH HHMp H ]@UH HHMpvH ]@UH HHMpH ]@UH HHMpNvH ]@UH HH   ڶ  H ]@UH HHM@  H ]@UH HHM`H ]@UH HH   µ  H ]@UH HHMh]  H ]@UH HHM   H ]@UH HHM H ]@UH HH  |H ]@UH HH   "  H ]@UH HHMh  H ]@UH HHM   H ]@UH HHM .H ]@UH HH  +|H ]@UH HHM(=  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(ݴ  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(}  H ]@UH HHM(]  H ]@UH HHM@n1H ]@UH HHM@1H ]@UH HHM@N2H ]@UH HHMP.sH ]@UH HHMPH ]@UH HHU(HM0誹H ]HT$SUVWH(HH]hH}`H;tHuxHHtH0H;u33vH(_^][@UH HHM8\H ]@UH HHM@H ]@UH HHM0nH ]@UH HH   rH ]@UH HH   H ]@UH HH   qH ]@UH HH   H0WH ]@UH HHM@qH ]@UH HH   HxH ]@UH HHMH^qH ]@UH HH   H   H ]@UH HHMPqH ]@UH HH   H   H ]@UH HHMP~H ]@UH HHM@^H ]@UH HHM`>H ]@UH HHMXH ]@UH HHM@.H ]@UH HHMH޶H ]@UH HHMP  H ]@UH HHM(  H ]@UH HHM(m  H ]@UH HHMPM  H ]@UH HH   H ]@UH HH   H ]@UH HH   ;oH ]@UH HH   H ]@UH HH   nH ]@UH HH   {H ]@UH HHP  j  H ]@UH HHM@M  H ]@UH HH   z  H ]@UH HHP  
  H ]@UH HHM@H ]@UH HHM@ͮ  H ]@UH HHx    H ]@UH HHP    H ]@UH HHMp^H ]HT$SUH8HH HM@!  HH0  HRLHHx  ֭  HH  >  Hֲ H  HH    H H  H8][@UH HHM@  H ]@UH HHx    H ]@UH HH  ʮ  H ]@UH HHM@]  H ]@UH HHM@=  H ]@UH HH`  j  H ]@UH HHM@  H ]@UH HHMpH ]@UH HHP    H ]@UH HHx    H ]@UH HHM@}  H ]@UH HHMpNH ]HT$SUH8HHk HM@  HH8  HRLHHx  ƫ  HH   .  Hư H   HH8    Ho H   H8][@UH HHM@  H ]@UH HHx    H ]@UH HH     H ]@UH HHM@M  H ]@UH HHM@-  H ]@UH HH  Z  H ]@UH HHM@  H ]@UH HHMpH ]@UH HHP    H ]@UH HHx    H ]@UH HHM@m  H ]@UH HHMp>H ]@UH HH  {iH ]@UH HH  H ]HT$SUH8HH HM@  HH@  HRLHHx  v  HH  ު  Hv H  HH    H H  蟑H8][@UH HHM@]  H ]@UH HHx  :  H ]@UH HH  j  H ]@UH HHM@  H ]@UH HHM@ݨ  H ]@UH HH`  
  H ]@UH HHM@  H ]@UH HHMpnH ]@UH HHP  Z  H ]@UH HHx  :  H ]@UH HHM@  H ]@UH HHMpH ]HT$SUH8HH HM@  HHP  HRLHHx  f  HH  Ψ  Hf H  HH    H H  菏H8][@UH HHM@M  H ]@UH HHx  *  H ]@UH HH  Z  H ]@UH HHM@  H ]@UH HHM@ͦ  H ]@UH HH`    H ]@UH HHM@  H ]@UH HHMp^H ]@UH HHP  J  H ]@UH HHx  *  H ]@UH HHM@
  H ]@UH HHMpH ]@UH HH  eH ]@UH HH  H ]HT$SUH8HHC HM@a  HHX  HRLHHx    HH  ~H H  _H8][@UH HHM@  H ]@UH HHx    H ]@UH HHM8.dH ]@UH HHM8H ]@UH HHMhcH ]@UH HHMhnH ]@UH HHMP  H ]@UH HHM =  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM ݣ  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM }  H ]@UH HHM ]  H ]@UH HHM =  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM ݢ  H ]@UH HHMXbH ]@UH HE t
e HMX@H ]@UH HHMxm  H ]@UH HHM8  H ]@UH HHU0HM@:H ]HT$UH0HHM033%H0]@UH HHU0HM@H ]HT$UH0HHM0Ɖ33ՉH0]@UH HHMxNKH ]@UH HHMX.KH ]@UH HHM@`H ]@UH HHM@H ]@UH HHMp^`H ]@UH HHMpH ]@UH HH  `H ]@UH HH  H ]@UH HH   _H ]@UH HH   [H ]@UH HHp    H ]@UH HH   *  H ]@UH HHp  R  H ]@UH HH     H ]HT$UH0H Hh  VH0]HT$UH0H H`  VH0]@UH HHM@^H ]@UH HHM@>H ]@UH HH   r  H ]@UH HH   
  H ]@UH HHMP>^H ]@UH HHMP~H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHMP]H ]@UH HH   HH ]@UH HHM ~]H ]@UH HHM H ]@UH HH     H ]@UH HH   ʝ  H ]@UH HHMP\H ]@UH HHMP>H ]@UH HHMP\H ]@UH HHM \H ]@UH HHM@~\H ]@UH HHM@H ]@UH HHU0HM8H ]HT$SUVWH(HH] H   H;t$H   f     HHH0H;u33跄H(_^][@UH HHM@[H ]@UH HHM@>H ]@UH HHMp~[H ]@UH HHMpH ]@UH HHM >[H ]@UH HHM ~H ]@UH HH     H ]@UH HH     H ]@UH HHMX  H ]@UH HHMPEH ]@UH HHMp~ZH ]@UH HHMpH ]@UH HHM@>ZH ]@UH HHM@H ]@UH HH   YH ]@UH HH   {H ]@UH HHMp.DH ]@UH HHM`DH ]@UH HH   CH ]@UH HH   CH ]@UH HH   CH ]@UH HHM`CH ]@UH HHM`nCH ]@UH HHMhNCH ]@UH HHM`H*CH ]@UH HHM`CH ]@UH HHM`BH ]@UH HHMhBH ]@UH HH   BH ]@UH HH   BH ]@UH HH   kBH ]@UH HH   KBH ]@UH HH   +BH ]@UH HH   BH ]@UH HH   HAH ]@UH HHMpAH ]@UH HHMpAH ]@UH HHMxAH ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(m  H ]@UH HHM(M  H ]@UH HHM(-  H ]@UH HHM(
  H ]@UH HHM`>VH ]HT$UH0HHM`33~H0]HT$UH0HHUxHM`&33~H0]HT$UH0HHUxHM`33~H0]@UH HHM8=  H ]@UH HHM`m  H ]@UH HHM`NUH ]@UH HEpt
epHM`H ]@UH HHM(  H ]@UH HH   K?H ]HT$UH0HHM`芖33}H0]@UH HH   TH ]@UH HH   H ]@UH HHMHNTH ]@UH HHMHH ]@UH HHM@TH ]@UH HHM@H ]@UH HHU0HM8芚H ]HT$SUVWH(HH] H   H;t$H   f     HHEH0H;u33G|H(_^][@UH HH   KSH ]@UH HH   H ]@UH HH   SH ]@UH HH   H ]@UH HH  RH ]@UH HH  KH ]@UH HH8  RH ]@UH HH8  H ]@UH HH  B  H ]@UH HHMpݒ  H ]@UH HH    H ]@UH HHMp  H ]HT$UH0H H  IH0]@UH HHMpQH ]@UH HHMpH ]HT$UH0H= H  !IH0]@UH HHMPH ]@UH HHM(QH ]@UH HHM(NH ]@UH HHM(PH ]@UH HHM(PH ]@UH HHM(:H ]@UH HHM(:H ]@UH HHM@NPH ]@UH HHM@H ]@UH HHMp~:H ]@UH HH     H ]@UH HH   z  H ]@UH HHMP:H ]@UH HHMP9H ]@UH HHM`nOH ]HT$UH0HHM`33xH0]@UH HH   9H ]@UH HH   k9H ]@UH HH   K9H ]@UH HH   +9H ]@UH HH   :H ]@UH HHMp8H ]@UH HHMp8H ]@UH HH   8H ]@UH HH   8H ]@UH HHM MH ]@UH HHM ~H ]@UH HHMPMH ]@UH HHMP>H ]@UH HHMp>H ]@UH HHM(H ]@UH HHM 7H ]@UH HHMp9H ]@UH HHMpH@j7H ]@UH HHM   H ]@UH HHMP  H ]@UH HHM M  H ]@UH HHM(-  H ]@UH HHMP]  H ]@UH HHM(  H ]@UH HHMP  H ]@UH HHM@KH ]HT$UH HHM@*]33tH ]@UH HHM@KH ]HT$UH HHM@\33UtH ]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   H_H   H]@H}8E~)H   HLRILHHHH Hs33sH0A\_^][@UH HHMP^H ]HT$UH0HH   L@IH   HA MH   HPI袔33=sH0]@UH HHMPH ]@UH HH   H ]@UH HH   ːH ]@UH HHMpIH ]@UH HHMpnH ]@UH HH   IH ]@UH HH   +H ]@UH HH   +H ]@UH HH   KIH ]@UH HH   H ]@UH HH  IH ]@UH HH  H ]@UH HH     H ]@UH HH8  Z  H ]@UH HH     H ]@UH HHx    H ]HT$UH0H- H  @H0]@UH HH     H ]@UH HH8    H ]@UH HH  ډ  H ]@UH HH8  GH ]@UH HH8  ;H ]HT$UH0H] H  A?H0]@UH HH   H ]@UH HH   H ]@UH HHM`GH ]@UH HHM`H ]@UH HH   FH ]@UH HH   KH ]@UH HH   FH ]@UH HH   H ]@UH HH   KFH ]@UH HH   H ]@UH HH     H ]@UH HH0    H ]@UH HH     H ]@UH HHp  Z  H ]HT$UH0Hm H  Q=H0]@UH HH   R  H ]@UH HH0    H ]@UH HH    H ]@UH HH0  DH ]@UH HH0  {H ]HT$UH0H H  <H0]@UH HHMx=  H ]@UH HHM8m  H ]@UH HHM8记H ]@UH HH   軼H ]HT$SUH8HL   H   HH   %Hl33lH8][@UH Hj@HM=H ]@UH Hj@HM H ]@UH HHM@nH ]@UH HHM@HH ]@UH HHMH>CH ]@UH HHMHCH ]@UH HH   k-H ]@UH HH   HG-H ]@UH HH   +-H ]@UH HH   H-H ]@UH HHMp-  H ]@UH HHM`~H ]@UH HHM@,H ]@UH HHM@,H ]@UH HHM(n,H ]@UH HHM(N,H ]@UH HHM@>H ]@UH HHM@H :H ]@UH HHMHH ]@UH HHM@HPZH ]@UH HHM@辰H ]@UH HHMH螰H ]@UH HHM@~H ]@UH HHMH^H ]@UH HHM@H躵H ]@UH HHM@H@H ]@UH HHM@H  H ]@UH HHMHޯH ]@UH HHM@H  H ]@UH HHM@H0H ]@UH HHM@HpjH ]@UH HHM@H     H ]@UH HHMH?H ]@UH HHMH?H ]@UH HHM@H ]@UH HHM@H  ǚH ]@UH HHM@Hx  藳H ]@UH HHM@H  H ]@UH HHM@H  WH ]@UH HHM@H  H ]@UH HHM@H@  WH ]@UH HHM@Hp  7H ]@UH HHM0~>H ]@UH HHM0H ]@UH HH@  ;>H ]@UH HHM0H ]@UH HH   ~  H ]@UH HHp  {H ]@UH HH   /H ]HT$UH0HHMxVf33efH0]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   HoH   H]@H}8E~)H   HLRILHHHH0He33eH0A\_^][@UH HHMPnH ]HT$UH0HH   L@IH   HA MH   HPI貆33MeH0]@UH HHMPH ]@UH HHp  ;<H ]@UH HHp  軾H ]@UH HH   ;H ]@UH HH   {H ]@UH HHMhm|  H ]@UH HH   J|  H ]@UH HH  *|  H ]@UH HHM0H ]@UH HHMh{  H ]@UH HHM0辽H ]@UH HH  {  H ]@UH HH   {  H ]@UH HHMhm{  H ]@UH HHM0>H ]@UH HHMh-{  H ]@UH HHM0H ]@UH HH  z  H ]@UH HH   z  H ]@UH HHMhz  H ]@UH HHM0~H ]@UH HHM09H ]@UH HHM0>H ]@UH HHMh-z  H ]@UH HHM0H ]@UH HH  y  H ]@UH HH   y  H ]@UH HHMhy  H ]@UH HHM0~H ]@UH HHM08H ]@UH HHM0>H ]@UH HHMh-y  H ]@UH HHM0H ]@UH HH  x  H ]@UH HH   x  H ]@UH HHMhx  H ]@UH HHM0~H ]@UH HHMhmx  H ]@UH HHM0>H ]@UH HH  *x  H ]@UH HH   
x  H ]@UH HHMhw  H ]@UH HHM0边H ]@UH HHMh6H ]@UH HHMh~H ]@UH HHM06H ]@UH HHM0~H ]@UH HHMh-w  H ]@UH HHM0H ]@UH HH  v  H ]@UH HH   v  H ]@UH HHMhv  H ]@UH HHM0~H ]@UH HHM05H ]@UH HHM0>H ]@UH HHMh-v  H ]@UH HHM0H ]@UH HH  u  H ]@UH HH   u  H ]@UH HHMhu  H ]@UH HHM0~H ]@UH HH   4H ]@UH HH   ;H ]@UH HHM0~4H ]@UH HHM0>H ]@UH HHMht  H ]@UH HHM0辶H ]@UH HH   kH ]@UH HH  t  H ]@UH HH   jt  H ]@UH HHMhMt  H ]@UH HH@  H ]@UH HHM0
t  H ]@UH HH@  ۵H ]@UH HH   s  H ]@UH HHMhs  H ]@UH HHM0s  H ]@UH HH@  [H ]@UH HH  Js  H ]@UH HH@  H ]HT$UH0H= H  !*H0]@UH HHMp.2H ]@UH HHMp讴H ]@UH HHM8xH ]HT$UH0HD33ZH0]@UH HHMp1H ]@UH HHMpH ]@UH HHM8xH ]HT$UH0H>D33	ZH0]@UH HHM81H ]@UH HHM8莳H ]@UH HH   wH ]HT$UH0HC33yYH0]@UH HHM8~0H ]@UH HHM8H ]@UH HH   vH ]HT$UH0HC33XH0]@UH HHM@HZH ]@UH HHMH/H ]@UH HHM@/H ]HT$SUH8HH   H{8 t'HM8HPHHK8HHo  o  H0 H8][@UH HH   "o  H ]@UH HHM`/H ]@UH HHM`莱H ]@UH HHM8}o  H ]@UH HH   .H ]@UH HH   +H ]@UH HHM8o  H ]@UH HHM8n  H ]@UH HHM8n  H ]@UH HHM8n  H ]@UH HHM8n  H ]@UH HHM8}n  H ]@UH HHM8]n  H ]@UH HH   -H ]@UH HH   H ]@UH HHMPN-H ]@UH HHMPίH ]@UH HjPHMH ]@UH HHMpޡH ]@UH HHMpH:H ]@UH HHMpHHH ]@UH HHM(,H ]@UH HHMpH   H ]@UH HHM0N,H ]@UH HHMpH   ǮH ]@UH HHM8,H ]@UH HHMpH   臮H ]@UH HHM`H ]@UH HHMpH ]@UH HHM`H@H ]@UH HHM l  H ]@UH HHMPEk  H ]@UH HHM k  H ]@UH HHM k  H ]@UH HH   *H ]@UH HH   kH ]@UH HH   KH ]@UH HH   ;H ]@UH HHM8H ]@UH HHMhN*H ]@UH HHMhάH ]@UH HH(  {H ]@UH HHMPj  H ]@UH HE@t
e@HMH`H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHMx>H ]@UH HHMp螘H ]@UH HHM(~H ]@UH HHMpHڝH ]@UH HHMpH@
H ]@UH HHMpH  H ]@UH HHM(H ]@UH HHMxޗH ]@UH HHM(>(H ]@UH HH   +H ]@UH HHM0'H ]@UH HH   HHwH ]@UH HHM8'H ]@UH HH   Hx7H ]@UH HHM@~'H ]@UH HH   H   4H ]@UH HHMH.'H ]@UH HH   H   褩H ]@UH HHMP&H ]@UH HH   H  蔼H ]@UH HH   H@  H ]@UH HHM@HH ]@UH HHM@H8ڨH ]@UH HHM@HpH ]@UH HHM@H   WH ]@UH HHM@H   7H ]@UH HHM@Hp  WH ]@UH HHM@H  Ff  H ]@UH HHM@H  WH ]@UH HHM@H	f  H ]@UH HHM@H0H ]@UH HHM@HpH ]@UH HHM@H   e  H ]@UH HHMp~H ]@UH HHM8$H ]@UH HHM8>H ]@UH HH  {$H ]@UH HE0te0H  H ]@UH HHx  ˦H ]@UH HHM0讦H ]@UH HH0  c  H ]@UH HH  zd  H ]@UH HH   e  H ]@UH HHM`#H ]@UH HHM`H ]@UH HH   K#H ]@UH HH   ˥H ]@UH HHP  諥H ]@UH HHM8莥H ]@UH HH  b  H ]@UH HH   Zc  H ]@UH HH   d  H ]@UH HHMhn"H ]@UH HHMhH ]@UH HHH  +"H ]@UH HE0te0HH  蝤H ]@UH HH   {H ]@UH HHMp!H ]@UH HHMp>H ]@UH HHM(-b  H ]@UH HHMP]c  H ]@UH HH  ۣH ]@UH HH   !H ]@UH HHM  H ]@UH HHM ~H ]@UH HHMP H ]@UH HHMP>H ]@UH HHMPH ]@UH HHM(
H ]@UH HH   fH ]HT$UH H433HH ]@UH HH   [
H ]@UH HH   ;
H ]HT$UH0HH   wa33rHH0]@UH HHM(~H ]@UH HHMHNH ]@UH HHM(>H ]@UH HHMpH躡H ]@UH HHM0H ]@UH HHMpH8zH ]@UH HHM8H ]@UH HHMpHpzH ]@UH HHM@~H ]@UH HHMpH   跒H ]@UH HHMxH^  H ]@UH HHMxH0H ]@UH HHMxHpjH ]@UH HHMxH   ^  H ]@UH HHMpH   H ]@UH HHMHH ]@UH HHMpHp  H ]@UH HHMpH  ^  H ]@UH HHMP>H ]@UH HHMpH  H ]@UH HHMXH ]@UH HHM(NH ]@UH HHM H ]@UH HHM ~H ]@UH HH   r\  H ]@UH HHMh
]  H ]@UH HHM`5\  H ]HT$SUH(HHU HM`\  Hx HM \  t*HU HM`[  H  LHAHM \  33DH(][@UH HHM ]\  H ]@UH HHM =\  H ]@UH HHEXD HUPHM("bH ]HT$SUH8HHM@HPHHMX[  H   HHUXHHMX[  LHASH{ H8][@UH HHMX[  H ]@UH HHMH.H ]@UH HHMHH ]HT$SUH8HHU8H   HH HMXZ  HHUXHHMXZ  H HMXZ  HHUXHHMXZ  LHASH} H8][@UH HHMXZ  H ]@UH HHMX}Z  H ]@UH HHMX]Z  H ]@UH HHMX=Z  H ]@UH HHMXZ  H ]@UH HHMXY  H ]@UH HHMXY  H ]@UH HHMXY  H ]@UH HHE0D HU(HM8_H ]HT$SUWH HH]hH}pH;t!@ HKNZ  HKDZ  H(H;u33^AH _][@UH HHM H ]@UH HHM H ]@UH HHMhH ]@UH HH   H ]@UH HHM@H ]@UH HHM@nH ]@UH HH   +H ]@UH HHMXH ]@UH HH   H GH ]@UH HHM(NH ]@UH HHM(ΙH ]@UH HHM0H ]@UH HHM0NH ]@UH HHM0H ]@UH HHM H ]@UH HHM nH ]@UH HH   kH ]@UH Hꋅ0  t0  H   H ]@UH HH   軘H ]@UH HHM`H ]@UH HHM`~H ]@UH HHM@^H ]HT$UH0HL   HU8HMp诓LXU  AHEx@(H4 H0]@UH HH   H ]@UH HH   H ]@UH HHMH~H ]@UH HHMH^H ]@UH HH   ;H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHM8H ]@UH HHM8H ]@UH HHM`~H ]@UH HH   S  H ]@UH HH   zT  H ]HT$UH0HMXMX  ;|4  Ho HD$ L
3 L  H H
n 虽H5 H0]@UH HH  2S  H ]@UH HH  S  H ]@UH HH  S  H ]@UH HH   S  H ]@UH HHMxmS  H ]@UH HHh  JS  H ]@UH HHMP-S  H ]@UH HH@  
S  H ]@UH HH   R  H ]@UH HH   R  H ]@UH HHM(R  H ]@UH HHM(R  H ]@UH HH   H ]@UH HH   H ]@UH HHMp~H ]@UH HHMpH ]@UH HH0  ۸H ]@UH HH   H ]@UH HH   蛓H ]@UH HH(  H ]@UH HH(  [H ]@UH HHM@H ]@UH HHM@^H ]@UH HH  KH ]@UH HH(  ;H ]@UH HH  H臷H ]@UH HH(  H ]@UH HH  HHGH ]@UH HHP  H ]@UH HH  H   4H ]@UH HHX  kH ]@UH HH  H   H ]@UH HH`  H ]@UH HH  H   蔑H ]@UH HH  kH ]@UH HHX  蛃H ]@UH HH0  N  H ]@UH HH  bN  H ]@UH HH  N  H ]@UH HHM@N  H ]@UH HHMpN  H ]@UH HH   N  H ]@UH HH(  zN  H ]@UH HH   ZN  H ]@UH HH  :N  H ]@UH HHX  N  H ]@UH HH   M  H ]@UH HH   M  H ]@UH HH   
H ]@UH HH   H ]HT$SUHHHH H   NM  HH  HH   HH   IM  H  HPHH   M  HH   HH   M  H HH][@UH HH   L  H ]@UH HH   L  H ]@UH Hj HMmH ]@UH HH   K{H ]@UH HH   H GH ]@UH HH   HPdH ]@UH HH   kH ]@UH HH   H   H ]@UH HHM(K  H ]@UH HHMPL  H ]@UH HH   ;H ]@UH HHMhH ]@UH HHM@MK  H ]@UH HHMh~
H ]@UH HH   H ]@UH HH   H  eH ]@UH HH   Hx  d~H ]@UH HH   H  负H ]@UH HH   H  ~H ]@UH HH   H  TH ]@UH HHMPN	H ]@UH HH   H@  ċH ]@UH HHMXH ]@UH HH   Hp  tH ]@UH HHM`H ]@UH HH   H  |H ]@UH HHMH^H ]@UH HEPt
ePHMH|H ]@UH HHM@~H ]@UH HH   G  H ]@UH HHMh}H  H ]HT$UH0Hꋍ    L   IA;|'Hn HD$ L
2 H H
 蟱H H0]@UH HH  G  H ]@UH HH   軮H ]HT$SUHHHHS  HM@G  H  HHU@HHM@G  HMhHPHHM@KG  HHU@HHM@SG  H HH][@UH HHM@-G  H ]@UH HHM@
G  H ]@UH HHMHH ]@UH HHM@H ]@UH HH   H ]@UH HHP  H ]@UH HH  H ]@UH HH  H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   kH ]@UH HH   KH ]@UH HH   +H ]@UH HHMpH ]@UH HHMpH ]@UH HH   
E  H ]HT$UH@HL,f LD$ L
 Hy H
B mH@]@UH HH   H ]@UH HH(  H ]@UH HHMXmD  H ]@UH HH   JD  H ]HT$UH@HH   H H@]@UH HHMX>H ]@UH HH   H ]@UH HHMXH ]@UH HH   H ]@UH HHMXH ]HT$UH@HC EPH H@]@UH HH  rB  H ]@UH HHMX
C  H ]@UH HH  2B  H ]@UH HHMXB  H ]@UH HHMXH ]@UH HH  H ]@UH HHp  H ]@UH HH  JB  H ]@UH HH  zC  H ]@UH HH  mH ]@UH HHMp.H ]@UH HH   A  H ]@UH HH   A  H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   kH ]@UH HH   KH ]@UH HH  2@  H ]@UH HHM@ H ]@UH HHM@螂H ]@UH HH   @  H ]@UH HH   j@  H ]@UH HH   J@  H ]@UH HH   *@  H ]@UH HH   
@  H ]@UH HHM@HH ]@UH HHM@HH ]@UH HHM@H(jH ]@UH HHM@H8JH ]@UH HHM@HH*H ]@UH HHM@HX
H ]@UH HHM@H   &?  H ]HT$UH HH   Ht'33'H ]@UH HHM0.H ]@UH HH   >  H ]@UH HHMx?  H ]@UH HH   z>  H ]@UH HHMx?  H ]@UH HH   H ]@UH HH   qH ]@UH HH  KH ]@UH HH  qH ]@UH HH  H ]@UH HH  KqH ]@UH HH  H ]@UH HH  qH ]@UH HH  H ]@UH HH  pH ]@UH HH   <  H ]@UH HH   <  H ]@UH HH  H ]@UH HHP  ;  H ]@UH HH   z<  H ]@UH HH  +kH ]@UH HH  pH ]@UH HH  <  H ]@UH HH0  jH ]@UH HH0  +pH ]@UH HH  pH ]@UH HH  ;  H ]@UH HH  KjH ]@UH HH  oH ]@UH HHh  :;  H ]@UH HH   ;  H ]@UH HH  :  H ]@UH HHMP:  H ]@UH HH   KH ]@UH HHh  :  H ]@UH HH   z:  H ]@UH HH   Z:  H ]@UH HH   ::  H ]@UH HH   :  H ]@UH HHMP9  H ]@UH HH   kH ]@UH HHH  H ]@UH HHH  {H ]@UH HH8  H ]@UH HH8  苎H ]@UH HHx  H ]@UH HHx  lH ]@UH HHx  KH ]@UH HH  gH ]@UH HH  gH ]@UH HH0  kgH ]@UH HH  KgH ]@UH HH  +gH ]@UH HHMPgH ]@UH HH  kH ]@UH HH  KH ]@UH HH  +H ]@UH HH  H ]@UH HH   H ]HT$SUH(HH  HM0Q7  H   HHU0HHM0R7  HM(HPHHM07  HHU0HHM0#7  H. H(][@UH HHM06  H ]@UH HHM06  H ]HT$SUH(HH  HM06  H   HHU0HHM06  HM(HPHHM0[6  HHU0HHM0c6  H0 H(][@UH HHM0=6  H ]@UH HHM06  H ]@UH HHM(~H ]HT$SUH(HH  HM05  H   HHU0HHM05  HM(HPHHM0{5  HHU0HHM05  H2 H(][@UH HHM0]5  H ]@UH HHM0=5  H ]HT$SUH(HH  HM04  H   HHU0HHM04  HM(HPHHM04  HHU0HHM04  H3 H(][@UH HHM04  H ]@UH HHM0}4  H ]HT$SUH(HH{  HM014  H   HHU0HHM024  HM(HPHHM03  HHU0HHM04  H4 H(][@UH HHM03  H ]@UH HHM03  H ]HT$SUH(HH  HM0q3  H   HHU0HHM0r3  HM(HPHHM0;3  HHU0HHM0C3  H5 H(][@UH HHM03  H ]@UH HHM02  H ]@UH HH   2  H ]@UH HH   H ]@UH HH   2  H ]@UH HH   1  H ]@UH HH   Z2  H ]@UH HHMPH ]@UH HHMPtH ]@UH HH   KH ]@UH HH   sH ]@UH HH   1  H ]@UH HH   1  H ]@UH HH   z1  H ]@UH HEpt
epHMxH ]@UH HHMhH ]@UH HHMxH ]@UH HHM@NVH ]@UH HH  WH ]@UH HH   WH ]@UH HHh  WH ]@UH HH   ]H ]@UH HHMXUH ]@UH HH   H ]@UH HHMH^UH ]@UH HH0  2/  H ]@UH HHM@/  H ]@UH HHM@/  H ]@UH HHM@/  H ]@UH HHM@m/  H ]@UH HHM@M/  H ]@UH HHM@-/  H ]@UH HH0  
/  H ]@UH HHM@.  H ]@UH HHMhH ]@UH HHMhnH ]@UH HHMxNH ]@UH HHMx.H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHM0H ]@UH HHM0nH ]@UH HHM@NH ]@UH HH   ,  H ]@UH HH   J-  H ]HT$UH0HM`M`  ;|4  H? HD$ L
 L  H H
v iHm H0]@UH HHM(RH ]@UH HHMx^H ]@UH HHM@>H ]@UH HH   +  H ]@UH HHMh=,  H ]HT$UH0Hꋍ    L   IA;|'H. HD$ L
 H H
t _Hr H0]@UH HHM@nH ]@UH HH   PH ]@UH HHMXPH ]@UH HHMXPH ]@UH HH   PH ]@UH HHM H ]@UH HH   +XH ]@UH HH   *  H ]HT$UH@HLK LD$ L
 H9 H
2 -H@]@UH HH   H ]@UH HH@  H ]@UH HHMX-*  H ]@UH HH  
*  H ]HT$UH@HH   HG~ H@]@UH HHMXH ]@UH HH  H ]@UH HHMXH ]@UH HH  H ]@UH HHMX~H ]HT$UH@H EPH H@]@UH HH  2(  H ]@UH HHMX(  H ]@UH HH  '  H ]@UH HHMX(  H ]@UH HHMXH ]@UH HH   H ]@UH HHP  kH ]@UH HHp  
(  H ]@UH HH  :)  H ]@UH HH  {SH ]@UH HHMpH ]@UH HH   '  H ]@UH HH   j'  H ]@UH HHM@H ]@UH HH   kH ]@UH HHM@NH ]@UH HH   +H ]@UH HHM@H ]@UH HH0  %  H ]@UH HHM@H ]@UH HHM@^hH ]@UH HH   J&  H ]@UH HH   *&  H ]@UH HH   
&  H ]@UH HH   %  H ]@UH HH   %  H ]@UH HH   %  H ]@UH HH   H ]@UH HH   j%  H ]@UH HH0  $  H ]@UH HH   *%  H ]@UH HHMP^H ]@UH HHMPfH ]@UH HH   H ]@UH HH   fH ]@UH HH0  #  H ]@UH HH   j$  H ]@UH HH   J$  H ]@UH HjpH   H ]@UH HHM@H ]@UH HHM@H ]@UH HHM0H ]@UH HHM(nH ]@UH HHMPNH ]@UH HHM`.H ]@UH HHM`H ]@UH HHM`HH ]@UH HHM`H(H ]@UH HHM8>H ]@UH HHM8dH ]@UH HHMxH ]@UH HHMx~dH ]@UH HH   +H ]@UH HH   H ]@UH HHMhH ]@UH HH   [H ]@UH HH   cH ]HT$UH0H    H H0]@UH HH 	     H ]@UH HH  z!  H ]@UH HHp  +PH ]@UH HHp  UH ]@UH HH0  !  H ]@UH HHP  OH ]@UH HHP  +UH ]@UH HH   H ]@UH HH   bH ]@UH HHM`>H ]@UH HHM`H ]@UH HH   H ]@UH HH   bH ]@UH HH`  KH ]@UH HH`  aH ]@UH HH  H ]@UH HH  aH ]@UH HH  z  H ]@UH HH  Z  H ]@UH HH
  H ]@UH HH
  ۅH ]@UH HH
  軅H ]@UH HH  H藅H ]@UH HH
  H ]@UH HH
  H ]@UH HH  {H ]@UH HH    H ]@UH HHMp=  H ]@UH HH0    H ]@UH HH  LH ]@UH HH  +RH ]@UH HHMp  H ]@UH HH    H ]@UH HH  KLH ]@UH HH  HH ]@UH HH
  H ]@UH HH
  kH ]@UH HH   KH ]@UH HH   ^H ]@UH HH    H ]@UH HH  kKH ]@UH HH  PH ]@UH HHMp]  H ]@UH HH  KH ]@UH HHP  JH ]@UH HHp  JH ]@UH HH  j  H ]@UH HH  J  H ]@UH HH    H ]@UH HH  KJH ]@UH HH  OH ]@UH HH  H ]@UH HH  H ]@UH HH    H ]@UH HH  IH ]@UH HH  OH ]@UH HH0    H ]@UH HH  KIH ]@UH HH  NH ]@UH HH  NH ]@UH HHMpnH ]@UH HHMpMH ]@UH HH    H ]@UH HH    H ]@UH HHMpH ]@UH HHMp.MH ]@UH HH  Z  H ]@UH HH0  :  H ]@UH HH  GH ]@UH HH  GH ]@UH HH  GH ]@UH HH  GH ]@UH HHP  kGH ]@UH HHp  KGH ]@UH HH  LH ]@UH HH0  :  H ]@UH HHMp  H ]@UH HH  H ]@UH HH  HP  4bH ]@UH HH  EH ]@UH HHMp  H ]@UH HH  ;FH ]@UH HH  KH ]@UH HH  EH ]@UH HH  JH ]@UH HHMp  H ]@UH HH0    H ]@UH HH  0H ]@UH HH  H0  `H ]@UH HH  UH ]@UH HHMp=  H ]@UH HH  DH ]@UH HH  KJH ]@UH HH  DH ]@UH HH  kIH ]@UH HHMp  H ]@UH HH0  z  H ]@UH HH  KWH ]@UH HHMp=  H ]@UH HHMp  H ]@UH HH  CH ]@UH HHP  CH ]@UH HHp  CH ]@UH HHMp  H ]@UH HH    H ]@UH HHH  H ]@UH HH
  GH ]@UH HH  BH ]@UH HHP  BH ]@UH HHp  BH ]@UH HH  KH ]@UH HH  {H ]@UH HH  諐H ]@UH HH  H ]@UH HH  +H ]@UH HH  kH ]@UH HH  ۝H ]@UH HH  +H ]@UH HH  kH ]@UH HH  諣H ]@UH HH  ;H ]@UH HH  H ]@UH HHMp=  H ]@UH HH  j  H ]@UH HH  @H ]@UH HHP  @H ]@UH HHp  @H ]@UH HH
 H ]@UH HH
 H ]@UH HH
H H ]@UH HH
 H ]@UH HH
@ kH ]@UH HH
 KH ]@UH H   H ]@UH HHHM(HM$3 H ]@UH Hf H ]@UH HHM8HM(HE(HHM0HE08csmtE     E  H ]@UH H}  uLMxDEpHUhHM`H ]@UH HH3Ɂ8  H ]H(H0  H
p   H
  H(H(H0  H
o   H
  H(H(H0  H
p X  H
  H(tH(# op H( ^Xp o H(" o H(H(M mp H(H
   p H
   fW=" o H   o (" 
P    tYtY
o H(! YGY n H(H(t! On H(@n Yo Xo ! ^n (o o fW@!  n H(L 
g ^
ko H(H(  7o H(H(m o H(H(fWn H(H(  }m H(H(d  ]n H(m fWP  m H(\ /fW"  m H(Xn fW   l H( fW :m H(0m Y pm m Xm m m fWp l H(HA-  H
^l   H
  H(H(H-  H
k h  H
  H(H(H-  H
m 8  H
  H(TH8HD$    Y3HtH
k HHH\ Hm Hn Ho H
  H8H8HD$    3HtH
C HHH4 HE HF HG H
P  H8H8HD$    3HtH
C HHH4 HE HF HG H
  H83H(H
    H
t  H(H8HD$    	3HtH
 HHH H H H H
  H8H8HD$    3HtH
 HHH| H H H H
0  H8CH8HD$    I3HtH
 HHH H H H H
  H8H(H
 耽H
y  H(H(H
e H
	  H(H8$+ LD$@3)t$ X5K fTf// v	   "   1S LD$@3WfTf/ v   "   (t$ H8HL$&HL$vHL$*H
Y tH
 YHL$V x 3h sX #H HT$^( HT$ HT$ HT$H
g H%  H
f H%  H
Ih H%  H
Yg H%  H
f H%  H
Ah H%  @SH HK Ht*H|$0CuHHPCu	HHPH|$0H [@SH H Ht*H|$0CuHHPCu	HHPH|$0H [@SH Hu Ht*H|$0CuHHPCu	HHPH|$0H [@SH Hu Ht*H|$0CuHHPCu	HHPH|$0H [H(H
} HtGH
} 3H} H} H} H( H(H
=~ HtH
~ 3H#~ H$~ H%~ H(H(H
~ HtH
|~ 3H~ H~ H~ H(H
	| ԬH(H
u} HtwH
L} 3H[} H\} H]} H(PH(H
} Ht7H
} 3H} H} H} H(H(H
]} HtH
4} 3HC} HD} HE} H(                                                                                                                                                                                                                                                                         |     f     V     <                        
     
     h
     ,
               :               ~     ,     
     
     :
     	     	     d	     (	                    v     (               R     
               @               z     r               R                    :          h                    L     *                 ^                            D          d     \                               @          F                    4          2          |               V               d                                      z     l     `     R     @     6     .                                                       l     `     N     <                                        |     p     L     0                                   z     t     l     f     `     Z     R     L     F     >     6     .                  j     P     @     "                                             l     ^     J     <     *     
                                             h     Z     F     2                                              z     d     L     &                                        |     l     X     J     0                                                  x     j     T     @     ,                                                  h     X     D     .                                        n     \     H     4                                                  h     T     F     2                                             r     V     :                                                  h     X     >     ,                                        6     z                                        p                     R    S   0S   `S   S   S   S   S    T    T   @T   pT   T   T   T    U    U   PU   pU   U   U   U   U   V   @V   `V   V   V   V   V    W   PW   W                                                                                                                                                                                                                                                                   W                                                                                                                                                                                                                                                                   @X                                                                                                                                                                                                                                                                   X                                                                                                                                                                                                                                                                   X                                                                                                                                                                                                                                                                   0Y                                                                                                                                                                                                                                                                   Y                                                                                                                                                                                                                                                                   Y                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   0Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                    [                                                                                                                                                                                                                                                                   [                                                                                                                                                                                                                                                                    [                                                                                                                                                                                                                                                                   0[                                                                                                                                                                                                                                                                   @[                                                                                                                                                                                                                                                                   P[                                                                                                                                                                                                                                                                   p[                                                                                                                                                                                                                                                                   [                                                                                                                                                                                                                                                                   [                                                                                                                                                                                                                                                                                   K
                   bad allocation  numpy.core.multiarray   numpy.core.multiarray failed to import  _ARRAY_API  2   _ARRAY_API not found    _ARRAY_API is not PyCObject object  14  _ARRAY_API is NULL pointer  0   module compiled against ABI version %x but this version of numpy is %x  numpy.core.umath    2   module compiled against API version %x but this version of numpy is %x  FATAL: module compiled as unknown endian    14  numpy.core.umath failed to import   0   FATAL: module compiled as little endian, but detected different endianness at runtime   _UFUNC_API      _UFUNC_API not found    _UFUNC_API is not PyCObject object      _UFUNC_API is NULL pointer      SSE, SSE2       empty_nested() must be true before calling recover_memory() .           empty_nested() must be false before calling recover_memory_nested()  /  :0yE>empty_nested() must be false before calling set_zero_all_adjoints_nested()      No free parameters for unit metric              Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        model =         stan_version_major =    stan_version_minor =    stan_version_patch =    Iteration:  %]   [       (Warmup)        (Sampling)  /  stan::services::variational::print_progress %]  Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   [   (Adaptation)    (Variational Inference)    #   stan_version_major      stan_version_minor      stan_version_patch      )       (   --  >   =<  :       Exception thrown at line        bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type           c:\users\appveyor\appdata\local\temp\1\tmp2glpnl\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.cpp F           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.pyx      __init__.pxd    stringsource    type.pxd        Unknown exception   T   n   lp__    np  HMC PY2 eta get ret sum __str__ zip BFGS    NUTS    args    ctrl    data    flat    init    iter        __main__    misc    name    pars    plot    seed    send        __test__    thin    upar    user    warn    LBFGS   OPTIM   array   ascii   close   error   flush   index   numpy   optim   order   plots   probs   range   shape   split   throw   utf-8   value   DIAG_E  Newton  UNIT_E  append  chains  data_i  data_r  decode  diag_e  dstack  encode  fitptr  format  holder      __import__  logger  method  metric  n_save  pystan  unit_e  update  vars_i  vars_r  warmup      DENSE_E argsptr asarray control dense_e dims_oi epsilon extract genexpr handler logging mean_lp__       newaxis pars_oi refresh reshape samples squeeze _summary        tol_obj warmup2 SAMPLING        adapt_t0        chain_id        (diag_e)        __getstate__    gradient        handlers        int_time        permuted        sampling        stepsize        tol_grad        (unit_e)        warnings        algorithm       data_args       (dense_e)       eval_elbo       flatnames       fnames_oi       getLogger       holderptr       init_list       iter_save       mean_pars       row_stack       sampler_t       test_grad       tol_param       traceplot       Metropolis      ValueError      adapt_iter      _check_pars get inc_warmup      init_alpha      model_code      _split_data get ImportError b   MemoryError B   OrderedDict h   VARIATIONAL H   adapt_delta i   adapt_gamma I   adapt_kappa l   collections L   _get_samples    init_radius q   pystan.misc Q   random_seed f   sample_file d   save_warmup g   tol_rel_obj Zf  variational Zd  RuntimeError    adapt_window    _call_sampler   column_stack    elbo_samples    grad_samples    history_size    optim_algo_t    pystan.plots    string_types    tol_rel_grad    TEST_GRADIENT   adapt_engaged   max_treedepth   pars_oi_bytes   _print_stanfit  AttributeError  append_samples  output_samples  pystan._compat  sampler_params  adaptation_info diagnostic_file sampling_algo_t save_iterations stepsize_jitter adjust_transform        _get_kept_samples       pystan.constants        sample_file_flag        tol_history_size        adapt_init_buffer       adapt_term_buffer       _call_sampler_star      _remove_empty_pars      sampling_metric_t       cline_in_traceback      enable_random_init      _pars_total_indexes Zg  stan_args_method_t      variational_algo_t      _verify_has_samples O   iter_save_wo_warmup par sampler_param_names sim diagnostic_file_flag    __getstate__.<locals>.genexpr   Variable name must be bytes.    ndarray is not C contiguous s   Stan model {} is of mode 'test_grad';
sampling is not conducted.        `inc_warmup` ignored when `permuted` is True.   numpy.core.multiarray failed to import  unknown dtype code in numpy.pxd (%d)    Couldn't allocate space for StanHolder. Couldn't allocate space for stan_fit.   Format string allocated too short, see comment in numpy.pxd s   Non-native byte order not supported %s  Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. int Stan model {} does not contain samples. c:\users\appveyor\appdata\local\temp\1\tmp2glpnl\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.pyx self        data sim model_name model_pars par_dims mode inits stan_args stanmodel date =   ndarray is not Fortran contiguous               num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names numpy.core.umath failed to import       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435  Couldn't allocate space for StanArgs.   Format string allocated too short.      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.__getitem__ genexpr stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.__getstate__.genexpr        attr_names              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.__getstate__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.__setstate__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.__reduce__          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.num_failed.__get__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.num_failed.__set__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.test_grad.__get__   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.test_grad.__set__   list    Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.inits.__set__   list        Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.par.__set__ dict    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.value.__get__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.value.__set__       Expected %.16s, got %.200s      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.args.__set__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.mean_lp__.__get__   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.mean_lp__.__set__   list    Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder.sampler_param_names.__set__ list    Expected %.16s, got %.200s  list        Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._pystanholder_from_stanholder    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._dict_from_stanargs      'NoneType' object has no attribute '%.30s'      'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._set_stanargs_from_dict          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._dict_to_vars_r  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._dict_to_vars_i  _call_sampler_star              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._call_sampler_star       _call_sampler   _call_sampler   _call_sampler   _call_sampler           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._call_sampler    dict    Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435._call_sampler    __cinit__       tuple index out of range        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__cinit__  __init__        __init__                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__init__           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__getstate__.genexpr       attr_names  self        genexpr plot    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__getstate__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__setstate__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__reduce__ plot    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.plot       'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.plot       traceplot       traceplot               stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.traceplot          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.traceplot  extract extract 'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.extract    'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.extract            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__unicode__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__str__            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__repr__           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.__getitem__        summary summary stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.summary            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.summary    log_prob        log_prob                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.log_prob           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.log_prob   grad_log_prob   grad_log_prob           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.grad_log_prob      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.grad_log_prob      'NoneType' object is not subscriptable          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_adaptation_info        get_logposterior        get_logposterior                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_logposterior   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_logposterior   get_sampler_params      get_sampler_params      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_posterior_mean stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.unconstrain_pars   list index out of range args    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_seed           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.get_stancode       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.flatnames.__get__  'NoneType' object has no attribute '%.30s'      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._verify_has_samples                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._update_param_oi   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._get_param_names   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._get_param_fnames_oi               stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._get_param_names_oi                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._get_param_dims    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._get_param_dims_oi stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.constrained_param_names            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.unconstrained_param_names          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model._call_sampler  dict        Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model.sim.__set__        numpy.ndarray.__getbuffer__ #   numpy.PyArray_MultiIterNew1 0   numpy.PyArray_MultiIterNew2 0   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 #   numpy.PyArray_MultiIterNew5 #   'NoneType' object is not iterable       'NoneType' object is not subscriptable  tuple   Expected %.16s, got %.200s      numpy._util_dtypestring numpy.import_array      numpy.import_array      numpy.import_umath      numpy.import_umath      numpy.import_ufunc      numpy.import_ufunc      vector.to_py.__pyx_convert_vector_to_py_double  string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string        string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string          string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string              vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___       string.from_py.__pyx_convert_string_from_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.from_py.__pyx_convert_vector_from_py_size_t      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ inits       vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__      num_failed      test_grad   value   chains  args        mean_pars       mean_lp__       adaptation_info sampler_params  sampler_param_names ,   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.PyStanHolder ,   Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  plot        traceplot       extract __unicode__ ,   summary log_prob        grad_log_prob   get_adaptation_info ,   get_logposterior        get_sampler_params      get_posterior_mean      unconstrain_pars        get_seed        get_inits       get_stancode    get_stanmodel   _verify_has_samples ,   _update_param_oi        _get_param_names        _get_param_fnames_oi    _get_param_names_oi .   _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames   data        model_name      model_pars      par_dims    mode    inits       stan_args       stanmodel   date                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.StanFit4Model    Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.__pyx_scope_struct____getstate__ stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.__pyx_scope_struct_1_genexpr .   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.__pyx_scope_struct_2___getstate__                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.__pyx_scope_struct_3_genexpr ,   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435  __builtin__ ,   cython_runtime  __builtins__    __name__        PyStanHolder    StanFit4Model   type    __builtin__ dtype   numpy       flatiter    numpy       broadcast   numpy       ndarray numpy   ufunc   numpy           init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435 throw       init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435 1.0 name '%.200s' is not defined            free variable '%s' referenced before assignment in enclosing scope       while calling a Python object   while calling a Python object  NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        need more than %zd value%.1s to unpack  at least        at most exactly %.200s() takes %.8s %zd positional argument%.1s (%zd given) 1.0 %s() got multiple values for keyword argument '%s'      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    '%.200s' object is unsliceable  Missing type object send        Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      'NoneType' object is not iterable       Missing type object 1.0 Cannot convert %.200s to %.200s cannot import name %.230s       %s (%s:%d)      value too large to convert to int       can't convert negative value to int 1.0 value too large to convert to unsigned int      can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t        can't convert negative value to pystan::stan_args_method_t      value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t       value too large to convert to pystan::optim_algo_t      can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t        can't convert negative value to pystan::variational_algo_t      value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long      can't convert negative value to long    _cython_0_27_3  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing 1.0 can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object [   _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections.abc collections ,   Cython module failed to register with collections.abc module    Cython module failed to register with collections module        backports_abc           send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.   throw               throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    close       close() -> raise GeneratorExit inside generator.        gi_running      gi_yieldfrom    object being iterated by 'yield from', or None  __name__        name of the generator   __qualname__    qualified name of the generator generator   %d.%d       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435  compiletime version %s of module '%.100s' does not match runtime version %s ]   %.200s.%.200s is not a type object              %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __%.4s__ returned non-%.4s (type %.200s)    long        an integer is required  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Argument n out of range: got %1%        boost::math::prime<%1%> is not converging       grad_reg_inc_gamma      is not converging       grad_reg_inc_gamma  lp__    user    user        TEST GRADIENT MODE              Sample generated by Stan (Automatic Differentiation Variational Inference)      Sample generated by Stan (Automatic Differentiation Variational Inference)      This is Automatic Differentiation Variational Inference.         procedure.)    (EXPERIMENTAL ALGORITHM: expect frequent updates to the  seconds        Gradient evaluation took         seconds.       1000 iterations under these settings should take        Adjust your expectations accordingly!   lp__    lp__    STAN OPTIMIZATION COMMAND (LBFGS)       init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  #   tol_param =     tol_rel_obj =   tol_rel_grad =  history_size =  seed =  Point Estimate Generated by Stan (LBFGS)        stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj #   tol_rel_grad    history_size    seed    lp__    STAN OPTIMIZATION COMMAND (BFGS)        init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  =   tol_param =     tol_rel_obj =   tol_rel_grad =  seed =  Point Estimate Generated by Stan (BFGS) stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj #   tol_rel_grad    seed    lp__    STAN OPTIMIZATION COMMAND (Newton)      Point Estimate Generated by Stan (Newton)       stan_version_major      stan_version_minor      stan_version_patch  init    seed    lp__        initial log joint probability =         Iteration       Log joint probability =         . Improved by   Sample generated by Stan        Sample generated by Stan        Must use algorithm="Fixed_param" for model that has no parameters.              Warning: warmup will be skipped for the fixed parameter sampler!        No sampler matching HMC specification!  boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.        boost::math::cbrt<%1%>(%1%) =   0.003379167095512573896158903121545171688       -0.000322780120964605683831 #   -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228          C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)    Log probability=   error       finite diff model   value       param idx   =   #   =   #   =   #   =   #   =   #   =   #   =   #   =   #       initial log joint probability =                     Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   initial log joint probability =             Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   #   #   #   #   )        (Chain     .    is written to file     Sample of chain         Exception initializing step size.       Exception initializing step size.       0.003379167095512573896158903121545171688       -0.000322780120964605683831 1.0 -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  1.0 1.0 0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  1.0 1.0 -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%) 1.0 -0.0020713321167745952  Argument a to the incomplete gamma function must be greater than zero (got a=%1%).              Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   0.9016312093258695918615325266959189453125e-19  -0.045251321448739056   -0.28919126444774784    -0.65031853770896507    -0.32555031186804491    0.25479851061131551 ,   -0.55789841321675513e-6 0.0021284987017821144   0.054151797245674225    0.43593529692665969 %1% 1.4606242909763515      2.0767117023730469      ibeta_derivative<%1%>(%1%,%1%,%1%)              The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).           Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)          Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable  attempts.  :   ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization from source failed.      Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% -0.324588649825948492091e-4 %1% -0.541009869215204396339e-3 :   -0.259453563205438108893e-3 %1% 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 :   -0.223352763208617092964e-6 %1% 0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 :   -0.240149820648571559892e-1 %1% -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 ,   0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 nan 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 NAN -0.827193521891290553639e-6 %1% -0.100666795539143372762e-2 :   0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. %1% Result of tgamma is too small to represent. %1% Result of tgamma is denormalized.       Result of tgamma is too large to represent. :   Result of tgamma is too large to represent. %1% Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)          The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)          Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                The argument a to the incomplete beta function must be >= zero (got a=%1%). 1.0 The argument b to the incomplete beta function must be >= zero (got b=%1%). 1.0 The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.          The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. 1.0 Result of tgamma is too small to represent. 1.0 Result of tgamma is denormalized.       Result of tgamma is too large to represent. )   Result of tgamma is too large to represent. %1% Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Rejecting initial value:          Error evaluating the log probability at the initial value.    Rejecting initial value:          Log probability evaluates to log(0), i.e. negative infinity.    Stan can't start sampling from this initial value.    Rejecting initial value:          Gradient evaluated at the initial value is not finite.          Stan can't start sampling from this initial value.     attempts.  :   ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization partially from source failed.    normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.324588649825948492091e-4 0.0 -0.541009869215204396339e-3 1.0 -0.259453563205438108893e-3 1.0 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 1.0 -0.223352763208617092964e-6 1.0 0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 0.0 -0.240149820648571559892e-1 1.0 -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 1.0 0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 0.0 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 1.0 -0.827193521891290553639e-6 0.0 -0.100666795539143372762e-2 1.0 0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   -5.2487866627945699800e-18      -1.5982226675653184646e-14      -2.6843448573468483278e-11      -3.0517226450451067446e-08      -2.5172644670688975051e-05      -1.5453977791786851041e-02      -7.0935347449210549190e+00      -2.4125195876041896775e+03      -5.9545626019847898221e+05      -1.0313066708737980747e+08      -1.1912746104985237192e+10      -8.4925101247114157499e+11      -3.2940087627407749166e+13      -5.5050369673018427753e+14      -2.2335582639474375249e+15      -4.8527560179962773045e+03      1.0377081058062166144e+07       -1.2207067397808979846e+10      7.8858692566751002988e+12       -2.2335582639474375245e+15      -9.6090021968656180000e+00      3.1611322818701131207e+01       -2.3517945679239481621e+01      5.5674518371240761397e+00       -4.4700805721174453923e-01      1.3067392038106924055e-02       -2.2210262233306573296e-04      -3.1446690275135491500e+01      8.5539563258012929600e+01       -6.0228002066743340583e+01      1.3982595353892851542e+01       -1.1151759188741312645e+00      3.2547697594819615062e-02       -5.5194330231005480228e-04      -1.9705291802535139930e-19      -6.5245515583151902910e-16      -1.1928788903603238754e-12      -1.4831904935994647675e-09      -1.3466829827635152875e-06      -9.1746443287817501309e-04      -4.7207090827310162436e-01      -1.8225946631657315931e+02      -5.1894091982308017540e+04      -1.0588550724769347106e+07      -1.4828267606612366099e+09      -1.3357437682275493024e+11      -6.9876779648010090070e+12      -1.7732037840791591320e+14      -1.4577180278143463643e+15      -5.1326864679904189920e+03      1.1594225856856884006e+07       -1.4386907088588283434e+10      9.7887501377547640438e+12       -2.9154360556286927285e+15      -6.0437159056137599999e-02      8.5591872901933459000e-01       -1.9746376087200685843e+00      1.3960118277609544334e+00       -3.4198728018058047439e-01      2.9204895411257790122e-02       -8.9359825138577646443e-04      1.4582087408985668208e-05       -3.8806586721556593450e+00      3.2593714889036996297e+00       -8.5017476463217924408e-01      7.4212010813186530069e-02       -2.2835624489492512649e-03      3.7510433111922824643e-05       boost::math::bessel_ik<%1%>(%1%,%1%)            Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.   initialized to invalid value ( Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::expm1<%1%>(%1%)    -1.2117036164593528341e-01      1.0344222815443188943e+02       -3.6629814655107086448e+04      6.6302997904833794242e+06       -6.2140700423540120665e+08      2.7282507878605942706e+10       -4.1298668500990866786e+11      9.3614022392337710626e+02       4.5612696224219938200e+05       1.3985097372263433271e+08       2.6328198300859648632e+10       2.3883787996332290397e+12       4.8591703355916499363e+01       7.4321196680624245801e+02       4.4176707025325087628e+03       1.1725046279757103576e+04       1.0341910641583726701e+04       -7.2879702464464618998e+03      -1.2254078161378989535e+04      -1.8319397969392084011e+03      -2.5258076240801555057e+01      3.3307310774649071172e+02       -2.9458766545509337327e+03      1.8680990008359188352e+04       -8.4055062591169562211e+04      2.4599102262586308984e+05       -3.5783478026152301072e+05      8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04       1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01      9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03 1.0 1.4130e+03      5.46860286310649596604e-04      -1.0767857011487300348e-02      1.0650724020080236441e+01       -4.4615792982775076130e+03      9.8062904098958257677e+05       -1.1548696764841276794e+08      6.6781041261492395835e+09       -1.4258509801366645672e+11      1.0742272239517380498e+03       5.9117614494174794095e+05       2.0228375140097033958e+08       4.2091902282580133541e+10       4.1868604460820175290e+12       4.6179191852758252278e+00       -7.5023342220781607561e+03      5.0793266148011179143e+06       -1.8113931269860667829e+09      3.5580665670910619166e+11       -3.6658018905416665164e+13      1.6608531731299018674e+15       -1.7527881995806511112e+16      1.3886978985861357615e+03       1.1267125065029138050e+06       6.4872502899596389593e+08       2.7622777286244082666e+11       8.4899346165481429307e+13       1.7128800897135812012e+16       1.7253905888447681194e+18       -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06      -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06      3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04       8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) -1.8402381979244993524e+01      1.0102532948020907590e+04       -2.1287548474401797963e+06      2.0422274357376619816e+08       -8.3716255451260504098e+09      1.0723538782003176831e+11       6.6475986689240190091e+02       2.3889393209447253406e+05       5.5662956624278251596e+07       8.1617187777290363573e+09       5.8873865738997033405e+11       1.7427031242901594547e+01       -1.4566865832663635920e+04      4.6905288611678631510e+06       -6.9590439394619619534e+08      4.3600098638603061642e+10       -5.5107435206722644429e+11      -2.2213976967566192242e+13  1.0 8.3030857612070288823e+02       4.0669982352539552018e+05       1.3960202770986831075e+08       3.4015103849971240096e+10       5.4266824419412347550e+12       4.3386146580707264428e+14       -1.7439661319197499338e+01      2.1363534169313901632e+04       -1.0085539923498211426e+07      2.1958827170518100757e+09       -1.9363051266772083678e+11      -1.2829912364088687306e+11      6.7016641869173237784e+14       -8.0728726905150210443e+15  1.0 8.7903362168128450017e+02       5.3924739209768057030e+05       2.4727219475672302327e+08       8.6926121104209825246e+10       2.2598377924042897629e+13       3.9272425569640309819e+15       3.4563724628846457519e+17       8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04   1.0 1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01  1.0 9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       boost::math::bessel_y0<%1%>(%1%,%1%)    Got x = %1% but x must be non-negative, complex result not supported.   -3.1714424660046133456e+02      2.2157953222280260820e+05       -5.9157479997408395984e+07      7.2144548214502560419e+09       -3.7595974497819597599e+11      5.4708611716525426053e+12       4.0535726612579544093e+13   1.0 8.2079908168393867438e+02       3.8136470753052572164e+05       1.2250435122182963220e+08       2.7800352738690585613e+10       4.1272286200406461981e+12       3.0737873921079286084e+14       -1.2337180442012953128e+03      1.9153806858264202986e+06       -1.1957961912070617006e+09      3.7453673962438488783e+11       -5.9530713129741981618e+13      4.0686275289804744814e+15       -2.3638408497043134724e+16      -5.6808094574724204577e+18      1.1514276357909013326e+19   1.0 1.2855164849321609336e+03       1.0453748201934079734e+06       6.3550318087088919566e+08       3.0221766852960403645e+11       1.1187010065856971027e+14       3.0837179548112881950e+16       5.6968198822857178911e+18       5.3321844313316185697e+20   0.0 -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06  1.0 -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06  0.0 3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04   1.0 8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%) 1.0 boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  5.8599221412826100000e-04       1.3166052564989571850e-01       1.1999463724910714109e+01       4.6850901201934832188e+02       5.9169059852270512312e+03       2.4708152720399552679e+03       -2.4994418972832303646e+02      2.1312714303849120380e+04       -1.6414452837299064100e+00      -2.9501657892958843865e+02      -1.7984434409411765813e+04      -3.7333769444840079748e+05      -1.6128136304458193998e+06  1.0 -2.5064972445877992730e+02      2.9865713163054025489e+04       -1.6128136304458193998e+06      1.1394980557384778174e+02       3.6832589957340267940e+03       3.1075408980684392399e+04       1.0577068948034021957e+05       1.7398867902565686251e+05       1.5097646353289914539e+05       7.1557062783764037541e+04       1.8321525870183537725e+04       2.3444738764199315021e+03       1.1600249425076035558e+02   1.0 2.0013443064949242491e+02       4.4329628889746408858e+03       3.1474655750295278825e+04       9.7418829762268075784e+04       1.5144644673520157801e+05       1.2689839587977598727e+05       5.8824616785857027752e+04       1.4847228371802360957e+04       1.8821890840982713696e+03       9.2556599177304839811e+01       boost::math::bessel_k0<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported   4.8127070456878442310e-01       9.9991373567429309922e+01       7.1885382604084798576e+03       1.7733324035147015630e+05       7.1938920065420586101e+05       -2.2149374878243304548e+06  1.0 -2.8143915754538725829e+02      3.7264298672067697862e+04       -2.2149374878243304548e+06      -2.2795590826955002390e-01      -5.3103913335180275253e+01      -4.5051623763436087023e+03      -1.4758069205414222471e+05      -1.3531161492785421328e+06  0.0 1.0 1.0 -3.0507151578787595807e+02      4.3117653211351080007e+04       -2.7062322985570842656e+06      6.4257745859173138767e-02       7.5584584631176030810e+00       1.3182609918569941308e+02       8.1094256146537402173e+02       2.3123742209168871550e+03       3.4540675585544584407e+03       2.8590657697910288226e+03       1.3319486433183221990e+03       3.4122953486801312910e+02       4.4137176114230414036e+01       2.2196792496874548962e+00       3.6001069306861518855e+01       3.3031020088765390854e+02       1.2082692316002348638e+03       2.1181000487171943810e+03       1.9448440788918006154e+03       9.6929165726802648634e+02       2.5951223655579051357e+02       3.4552228452758912848e+01       1.7710478032601086579e+00       boost::math::bessel_k1<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)              The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1% Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1%                       "   i
            i
            "   i
         	   ,j
            "   tj
            j
            "   j
            k
            "   Pk
    Pl
    4m
 P                                  +eG?+eG?            "~+@"~+@W6}+W6}+      ?      ?      ?      ?    @.?    @.?ʫy>ʫy>K͉ ?K͉ ?_6.>_6.>~,?~,?9d?9d?t	?t	?       @       @"   w
            x
            "   Px
            tx
            "   ~
            ~
            "   t
            
            "   
            $
            "   <
            |
            "   
            
          "   Љ
            
 @          "   T
            Ȋ
           "   <
            p
            "   
            ̋
            "   
            8
            "   P
            
            "   
            
            "   
            x
            "   
            
            "   H
            
 @         "   
            
            "   L
             
 @         "   
            
            "   
    
    
            "   
            
           "   $
            Ȕ
           "   8
            ܕ
           "   L
            
           "   `
            
 P          "   t
            
            "   
            Ԙ
            "   
            
            "   (
            T
            "   l
            
            "   
            ̙
            "   
            
            "    
            H
            "   Ț
         	   8
           "   
         	   
           "   8
            
           "   
            h
           "   (
            4
 h         "   
    @
    
           "   
    
    $
 @         "
   ԣ
            ̤
 P         "   l
            
           "   Ԧ
            
          "   \
         &   p
 (         "
   
    
    
 P         "   d
            
           "   h
            
           "   
            l
           "   
    
 (   L
          
   Ѝ   J
   
   0   J
     
          
         !
         !
         "
                 "   
            h
            "
   @       #
   @      #
   @      0$
   @              "   
            h
                    "   
            h
                    $
   p   J
   J
   J
   J
   J
   J
   J
   J
   0%
   J
   J
      %
   p   J
      J
   J
    &
   P   @           bad lexical cast: source type value could not be interpreted as target  bad cast                 '
   J
   J
   J
   J
   J
   J
   J
   J
   J
      x'
   PA   h   -q='
   @      double  long double             "   
            Ĵ
              E@'
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        "   
            
                    (
   0   J
   h   h   h   h   h   )
   0   @   h   h   h   h   h         ?        *
   p      Pk       `            p   "   
            D
                    "   
            p
                    "   
            
            ]        [origin:       *
   0      h+
         +
         bad exception   x,
   @      bad typeid      X-
         vector<T> too long      "    
            ĵ
            invalid vector<T> subscript             "    
            
                    "   dl    4
    \
 0                  "   dl    
    Ķ
 0                  "   dl    
    ,
 0                  "   dl    l
    
 0                  "   dl    Է
    
 0                  "   dl    <
    d
 0                  "   dl    
    ̸
 0                  "   dl    
    4
 0                  "   dl    t
    
 0                  "   dl    ܹ
    
 0                  "   dl    D
    l
 0                  "   dl    
    Ժ
 0                  "   dl    
    <
 0                  -
   J
   J
   J
   J
   J
   J
   J
   J
           P.
   J
   J
   J
   J
   J
   J
   J
   J
           .
   J
   J
   J
   J
   J
   J
   J
   J
           but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  "   p
         	   
            Unknown termination code                Line search failed to achieve a sufficient decrease, no more progress can be made       Maximum number of iterations hit, may not be at an optima               Convergence detected: absolute parameter change was below tolerance             Convergence detected: relative gradient magnitude is below tolerance    Convergence detected: gradient norm is below tolerance  Convergence detected: relative change in objective function was below tolerance Convergence detected: absolute change in objective function was below tolerance Successful step completed       -DT!	@Adaptation terminated         ?      @                    @      (@       @      @            P>      <     (@ox?00
   p               0
   p               "               
                                             
 
                     	               	               
                                                 ?   =
?   @33?   =
?      ?   ?    ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@"   
            ȼ
            kﴑ[?;f?     
   
                 m0_?Q63E?mBP
?        "   
            4
                          ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx01
      1
   P           2
      `      p            0      ж           "   
            
                  "   Ľ
            ̽
                    "   <
    
 
   d
                    "   
    
 
   4
                    "   |
            
                :   "   
            
 0          (       ) must match in size     (  ) and               "   
            4
 0                  3
             P   p    o   r              3
   `p         P   p       r   0           4
   @	         P   p   	   r   `	           "   |
            4
                    "   |
            
                    "   |
            
            is      , but must be > 0!      , but must be finite!   "   
            
 0          , but must be greater than or equal to  "   
            
 0                  "   |
            D
                    "   |
            
                    "
   
             
 p           seconds (Total)         seconds (Sampling)      seconds (Warm-up)       Elapsed Time:                  5
   i   I
   I
   I
   I
   I
   I
   J
   J
      p      J
   J
       ?1~ʉʐ|E~Pۆ,̿]g?~vt`2?A<?4`Bkʫ?}
|;¿ȼu??    ?kr	`?[}`?P=x:?/@V;0@{R=a? ZpPT*b!ezFĿp2ڿ2s"\ڿ1i5ϸaƯ?      ?    X?IWUQ{-?f/Ҁ? BN?R?׹^oyd?S?=QAV 1 Lé?]OL?̺?`w"   dl    0
    X
                    "   dl    
    
                    "   
            H
 0          [       "   dl    
    
            `6
   J
           "   (
            @
            invalid alignment to 8 bytes, ptr=      uninitialized   "   |
            
             and    expecting index to be between    out of range;  index   : accessing element out of range.       ; index position =              "   
            
            ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration           "   H
            
 p                     term_buffer =                   adapt_window =                  init_buffer =                 Defaulting to a 15%/75%/10% partition, ?333333?         overflow the total number of warmup iterations.                WARNING: The initial buffer, adaptation window, and terminal buffer              performed for num_warmup < 20   estimation is  WARNING: No           Y@ =  ,   "   $
            ,
                    "   X
            `
                    "   
            
                    "   
            
                    "   
            
                    "   
            
                    "   D
            L
            6
   p    7
   @!           "   dl    
    
                    "   
            
 0                  "   ,
            <
            (9
   `(   p8
         @:
    g       p)   :
   )   P9
   `      , but must not be nan!  , but must be >= 0!     h:
   )       ;
      7       7   ;
      7       7   <
      7       7   has dimension =         multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         "   
            |
 0                  "   
            
 0              d?Eĵ@oI+@P	6@"ܢ}/@^ʥ
&@`I2W@DNxR	x3j濍4c08˿ą@?A!y?    dL?      @[sS/k??~}?rJ󓉸?0"S?7¬?O~x>2Lf0?kFoa?@8?Ų"?Zf0h?      @    7?HS 	p?رo߬??Io?Ж}?/ēr.?Mj?DbjT?u`v`?TEvʣ?:8      @    ?H P>ئ8?ҍ?Uh?0?^бF?{]?i?tiY?K_n!r?\v?7<
w   @33@      <@    ?oN8?S(c?ng?`<?,7Z'5ICcaI`տж)[?      ?#6k?|="   
            
 0                  "   |
            
                    "   dl    T
    |
                    "   
            
 0                  "   
            
            <
   =   <
    =   J
   <
   0=   J
           "   
            4
            =
   =   =
         "   p
            x
                    "   p
            
                    "   
            
                    "   
            
            >
   f      0B   x>
   @B   =
         ?
   f      B   ?
   B   J
   >
       @
   `g      C   @
   C   J
   ?
   `   A
    g   P   D   xA
   D   @
         ^^^^^^ܿYY|?qAAp?UUUUUU?    ?   n?=  @cb?HO

oa?,aȹ?6(]?0ɗ^?AMg @7%l`x<rc.+ҿZ)nh/AԿxIiN?e;"   H
     
    `
                    "   
            
 0          []      "   
            
 0                  "   
    `
    
                    "   
            
            B
   PY   A
      @   "   
            0
            C
   @g   p   Z   C
   Z   B
   p   @   size of         C
   i   I
   I
   I
   I
   I
   I
   J
   J
      p      J
   J
   ?      .@{T4bU@
+/NW+@HM%;KZr?a7	Bu?u"7#?@&p7*E@wǛܿ&-DٔÊ?39e0!cAg?IBx.ȼ٥m4XL.Q$]WsAb`CF:ey_b
٢+8 ,"zYǣp0ih8vJU;È[1
@Y?4뿡i?6+Ab\ƖG?7pc?,xV?_տZ?:ղ>GHM]!_k;>fAδ>6
)%$Ç5=ΡB)r
@.ցǼ]?t	${?N`Ch6޿
NMfV|O102dQ*Cv=?	h@k}}Sų()%a5"   
            
 0                  "   
            
            D
    {   XD
   p      "   ,
            D
            E
   {   E
   0      F
   0g   `   |   F
   |   E
   0      G
   f      }   xG
    ~   F
                @      p?E6`     @JQ5     @Pr@	ouU@{@@ZG@FLHnAC&kĨ5A
B;AžѠ%A.A@wp@6Ґ@
b-(@M @O:8@u	2/Ʋ7wȳYXzbqw.`b YI?76O0Y)МbZFtP,811AMʲ@{aUA7oTPB[MBbzsFmNCZCRοx@MUNXG`SAF1TBU·J
&C3"OUFeȐ@5J
"AK5A)꾙#B$vBMu
TLm+M%@ÈIc⃼A)*-ANՎ]@"   ,
            \
            `H
   p   G
   `      "   
            
                    "   
            
            XI
   Pg   @      0I
      H
          I
                  _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?        $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?        "   
            (
            J
               "   
            \
                    "   
            
             K
   g   0   О   J
      8J
         "   
            
            Expecting a square matrix; rows of      columns of      "   
            
 0          ]=      is not lower triangular;        "   
             
 0          lb_free Lower bounded variable          "   P
            X
               "   
            
           Number of posterior samples for output  Evaluate ELBO at every eval_elbo iteration      Number of Monte Carlo samples for ELBO  Number of Monte Carlo samples for gradients     stan::variational::advi "   
            $
                  $@"   
    
    
                    "   P
             
                    "   H
            P
                    "   H
            x
               "   P
            
                    "   
            
                    "   
            
                   "   \
            l
                    "   \
            
                    "   
            
                   "   0
            @
                    "   x
            
                    "   
            
               "   
             
                    "   8
            H
                    "   |
            
                    "    
            
                    "   8
    
    `
                    "   
            
                    "   
            
 0                  "   P
            P
                    "   P
            x
                    "   
            
                   "   
            
                   "   @
            P
                    "   
            
                  ?ȅeA?     @&GVW     @@E.,[@@.=@/R V@hcjzB@,G`@ N@Nj֐W@
z=4L6}(e[ NV` l=gW/7c@14=]@)3M3@oַ@Zw?ub8c@L1@t@WY_,0@t>@1Ds+t@HB9M_L\?>@%_ qwV.8Ao+#LKH@1%9@xB)A@~@>F2@4bwI+1
  Z,h-A@VA!q髠AHps!BՉp³`BfTO)QwMY@!|l!hBGJYA(z-	X"   P
            P
                    "   
            
                    "   
            
                    "   
            $
                   "   t
            
                    "   P
            D
                    "   t
            
                    "   
            
                   "   
            (
                    "   `
            p
                    "
   
            H
           ; position=     mismatch in dimension declared and found in context     ; dims found=   ; dims declared=        mismatch in number dimensions declared and found in context     ; base type=    ; variable name=        ; processing stage=     variable does not exist int variable contained non-int values   int     dot_product v2  v1      (K
   p
           "   
    
    
                    "   0
            H
                    "   
            
                    "   
            
                    "   D
            
                    "   $
            
                   "   T
            
                   "   dl    
    $
                    "   D
            d
                    "   
            
                    "   
            
                    "   D
            L
                 @@      @      @      @      ?      ?        "   D
            
                    "   <
            D
                    "   
            
                  "   D
             
                    "   D
            H
                    "   D
            p
                    "   dl    
    
                    "   D
            X
                    "   
            
                   "   
            
                   "   
            d
                    "   
            
            K
   0D   E   h           "    
            8
            L
   0D   E   h           "   
            
            Mean vector     Dimension of input vector       Dimension of current vector     Dimension of mean vector        Dimension of Cholesky factor    Cholesky factor         L
   h   h   m   h   h   h   h   h   h   n           "    
            
            vector provided does not match the parameter length     "   
    d
    
                    "   
    p
 
   
                    "   
    t
    
 H                  "   
    
 
   
                    "   
    d
 
   
                    "   
            D
                    "   
            
                    "   
            `
                    "   8z            
                    M
      J
   h   h         `   p      "   4            
            Step size =             "   dl    H
    p
 0                  "   
            
                    "   
            
                    "    
            
                    "   l
    D
    
                    "   
            
 p                  "   $             ,                     "   p          	                       "   
                                "   
            `                    "   
                                "   d    <    | 0                  "   
                                "   dl                            "   dl    4    \ 0                  "   dl                            "   dl    <    d 0                  M
   0       0            `   @       N
      @                `   p                 "                                   N
   P   	   0             `         "   4                                O
   Ч   	                  `                    P
   @   	   0       p      `   0       "   4            D                    P
   P   	          p      `   0                  "   
     
    0                  "   L            d            circular_buffer         "                                   "           (                    "                                   C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     no more scalars to read "                           double __cdecl stan::io::reader<double>::scalar(void)   "   |	    T	    	                    "   	         	   (
                   "   
            
 p                  "   dl        0 0                  "   	         	   |           numeric overflow        "   dl         0          Value %1% can not be represented in the target integer type.            "                `                  "                `                  "                
 0                  "                 0          xQ
   `           "                0                  "                                   "                                   "
   L             `           is needed.      is found, but  array is not long enough for all elements:              C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\src\stan/io/array_var_context.hpp           void __cdecl stan::io::array_var_context::validate<double>(const class std::vector<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >,class std::allocator<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > > > &,const class std::vector<double,class std::allocator<double> > &,const class std::vector<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> >,class std::allocator<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> > > > &)   ).  should be no smaller than number of parameters (found   )       size of vector of dimensions (found             Q
   0       0            `   @      energy__        int_time__      stepsize__      R
      @                `   p         divergent__     n_leapfrog__    treedepth__             "   p                                "                           T
      p   S
       	   0            `   @      (U
                 0T
       !	                `   p                 "   |y                        W
      p   PU
      `n	   0             `         "   y                        X
         0W
   @   o	                  `                    "   Ї                        HZ
      p   X
   p   pp	   0       p      `   0       "                           [
         pZ
      q	          p      `   0                  "                                   "       `                        "                (            Overflow Error          "   \            d               6s?D?    ͜?{>MA?      ?Dݿf2	A?ʇƅȏD?{    ͜Vph?4W'ђ
cՇ?MA6;
>boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)              @!?     X@i4E?     @=Ը.h?     l@!X@VMS@Ը.?t AmqDx@3q&zA5X3=4BIB~Ӝ+C+/CD뤍p1o}/@L}<cn[P\AD
F
C9=£:CM%<<w@=JKAskPA-խBTB
胩BϚnsfQm1@_7QADT4jM$B?gx	`144o5Ƅ@cto)
AdˊA
q"aB"gAd[ag2"7D@yxl=@M/")8B%/bXAa۾     @!]?     @.N@CԾ@m@c/ALyo&AfdQBmbgoB5c[CvACt<DQ9=AFFFUB@ͷ1I/-U,CeawTïT]Cd@FAO'|5A)ÊB+EhBxBNsA?_5[A\At<U,o"B@4W=A1nBdAMi@OP@$@̴F@钳|A0U&@@<I;@	Ch@O'R#W@OQ|\@Ƭ@
R,X@@ n%=APnAT)Qx@jۧa@f\( ]@P@Topvm*@<!\C'"]I{f)DCprd
8`6>o}'-@c03C?@?I'@$H}@إ@9VkM@	# B@4t@<r@93@7V`c@gPUJ@n28p@z86V?BlFA@2s?
;@:goz`@b]W@O♿@"@!V@
o'iϔ@,Su@#1@4F@3!$sX7&D}
@Ny-Ϳ<MJr~)X7&4Sq`	2@T)#?rX@'#oˉ@?d=쩥A%f:%Aq@        "                          boost::math::trunc<%1%>(%1%)    boost::math::expm1<%1%>(%1%)            "   
                                "   
                                "
               \                    "                           \
   PA   <   0]
   PA   P=           "               @                    "               t            ]
   PA   @?   "                                   "                           ^
   PA   `A   _
   PA   `A   _
   PA   A   "               $            #B;      C        "   T            \             `
   PA   PC   "                           accept_stat__   lp__    "            	               g_  p_  "O   4    l     H         Error transforming variable beta:       Error transforming variable sigma_obs:  Error transforming variable delta:      Error transforming variable m:  Error transforming variable k:  variable beta missing   beta    variable sigma_obs missing      sigma_obs       variable delta missing  delta   variable m missing  m   initialization  variable k missing  k   :0yE>        "   X"            x" 0                  "
   "            D# H          gamma   "   $            $ (                  "   <%            L% 0          invalid map/set<T> iterator             "   4&    &    L& 8                  "   &    &    & 8                  "   '            '                    "   '            '                    "   '             (                    "   )    (     ) X         t_change                "   *            *                   "   P+         	   x+                    "	   +            (,                   "   ,    , 	   (- (          Evaluation of function at pole %1%      "   -            @. 8                  "               .                    "   .            . P                  "   X/            `/                    "   /         
   /                   "   0            0                    "   0            0                    "   L2            $1                    "   t1            1            stan::variational::normal_fullrank      "   1            1                    "   L2            d2                    "   2            2                    "   3            <3 0          Log std vector  Dimension of log std vector     stan::variational::normal_meanfield     "   3            3                    "   3         
   4                    "   4    4    4 0                  "   dl    h5    5 0                  "               5 0          map/set<T> too long     "   dl    ,6    T6 0                  "               6 0          log1p<%1%>(%1%) log1p(x) requires x > -1, but got x = %1%.              "   <7            T7                    "   7            7                    "   dl    8    D8 0                  "   49            D9                   "   `:            : @                  "   ;    X; 	   ; (                  "%   <    H<    =          Y   X   t   A           "   >            >            `
   PA       "   4?            T?             
   >"   ?            ?            boost::math::digamma<%1%>(%1%)  boost::math::itrunc<%1%>(%1%)           A        "   @         
   D@                   "   @            @              A?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?        "   2            DB            stan::variational::set_mu       stan::variational::set_L_chol   Dimension of lhs        Dimension of rhs        stan::variational::normal_fullrank::operator=   stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  Input vector    stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/=         "   TC    ,C    lC 0                  "	   E            D 0                 "	   E            E 0                 "	   E            F 0                 "   G            G                   "   (H            0H @                  "   |H            H                        @e@-DT!	      4        gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?              >      >"   I            I `                  "   4J            DJ             a
   0D   E   y           "   J            J H          ,       Diagonal elements of inverse mass matrix:       a
   h   h   P{   h   h   h   h   h   h    }           "    K         	    K             b
   ~           "   K    K    K                    "   PL    (L    hL                    "   M    M    N H                  "   8z            N                    b
   p   J
   h   h          `         "   O    DO (   tP          Undefined transformed parameter: gamma  "   @R    Q &    S                Pboost::math::tgamma<%1%>(%1%)   "   x            T            boost::math::lgamma<%1%>(%1%)           "   T         	   U 0                  C:\bld\fbprophet_1511479170951\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/math/special_functions/owens_t.hpp              long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed                         "   X"            U                   "   dl    U    V 0                  "   tV            V @                  "   
            V                    "   (W            HW                    "   ,X            W                    "   ,X            LX                    "   X            X            b
      covariance      Pc
          "   X            X            xc
      variance         d
          "   Y            ,Y                    "   Y            Y                    "   Y            Y                    "   Y            TZ            (d
    Z           "   Z            Z                    d
   h   h      h   h   h   h   h   h              "    
            [                    "   T[            d[                    "   [            [                    (e
                                  [           "   L\         
   |\                    "   \         
    ]                    "   
            ]                    "   0^         
   ]                   "   0^         
   h^                   "   dl    ^    _ 0                  "   _    _    ` H                  "S   `    `    lc          tau     vector_d    sigmas  S   y   K   data initialization T           anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97              "   h    hh 
   h @                  "   di    <i 
   i @                  "   8j    j    `j 0                  "   k    j    <k 0                  "   k            k                    "   dl    <l    tl 0          Non-finite function evaluation. Error evaluating model log probability:         Error evaluating model log probability: Non-finite gradient.            "
   l            <m                  "   0n            Pn           UUUUUU?UUUUUUUUUUUU?UUUUUUMb`?MbP?MbPMb`Mb@?        1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?{Gz?      ?        "   0o            8o P                  "	   o            $p                    e
   I   0S    T   @E   S   @F   F   G   H   "   p            p            (f
   0D   E   `K           "   0q         	   Pq H          Elements of inverse mass matrix:              @        "   r            $r                   f
   I   0S    T   @E   S   @F   F   G   H   "   r            r                    "   s            s P          stan::variational::normal_meanfield::transform          "   8s            Hs                    "   |s            s                    "
   Pt            t                    "   Hu         
   u                    "   u            v                    "   Tv         	   |v h                  "	   v            0w            vs     Number of unconstrained parameters does not match that of the model (           "	   x            Xx                   "   x            x                    "   4y            Dy                    (g
   P   	   0             `         Pg
   Ч   	                  `                    "   |y            y                    "   y            y                    "    
            y            Error evaluating initial BFGS point.    "   8z            @z                    xg
   v   J
   h   h   p      `   0       q=
ףp?        "   z            {                   "   {    { 
   |                    "   |            |           ؗҜ<"   dl    |     } 0                  "   h}            p}                   "   ~            $~                    "   T~            ~                    "   Ĳ                        boost::math::owens_t<%1%>(%1%,%1%)      "               8 `                  "   Ԁ         X          Scale parameter Location parameter      normal_rng      "                                 @      ?        "   4     "    0                  "           (                   "               Ԅ `                  "   \            t                    "                                   "   L            d                   "                                  g
   @   	   0       p      `   0       g
   P   	          p      `   0                  "   Ї            ؇                    "                                   "   dl    L    t 0                  "   Ĳ                                "   \    4    ԉ          The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.   Gradient of mu  Dimension of variables in model Dimension of elbo_grad  Dimension of variational q      stan::variational::normal_meanfield::calc_grad  "               l                    "*        M                     "                                   "   ؐ         
               filter is looking for elements out of range             "                                   "               d                    "                                   "       `     `          log_prob        stan::variational::advi::calc_ELBO      stan::variational::advi::calc_ELBO_grad         "               T p          Posterior is improper. Please check your model.         No acceptably small step size could be found. Perhaps the posterior is not continuous?  ?    cA        "           @ p                  "   ԕ            ܕ                    "                0                  "
   D                              "                0                  "
   D                              "                0                  "
   D                              "       D ,   d P                 Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.  ].  .        earlier than expected.  Found best value [eta =        Success!        ?Begin eta adaptation.   Number of adaptation iterations stan::variational::advi::adapt_eta      "            )                     This variational approximation is not guaranteed to be meaningful.              Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation may not have converged to a good optimum.        Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!       ?   MAY BE DIVERGING... INSPECT ELBO        MEDIAN ELBO CONVERGED           MEAN ELBO CONVERGED       @@          iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes    Begin stochastic gradient ascent.       Maximum iterations      Relative objective function tolerance   Eta stepsize    stan::variational::advi::stochastic_gradient_ascent     "
            	   d                    "   dl    Ԡ                        "               p p                  "               < p                  "9   Ȣ         Q                     "       X 
                       "   X    0 
   x                    "                                    "       X 
                       "   X    0 
   x                    "   0     
   P                    "        
   (                    "   
            Ĭ                    "   0                      COMPLETED.       from the approximate posterior...      Drawing a sample of size    eta =       Stepsize adaptation complete.   iter,time_in_seconds,ELBO               "               h 0                  "                0                  "               Į 0                  "                0                  "   X            h `          LS failed, Hessian reset        )\(?"   į            ̯                    "                X                 "   \            d                   "                                   "                                  "   $            4 0          stan::variational::normal_fullrank::transform           "   l            t                    "	                 h                  "   Ĳ            ̲                    "   D                  stan::variational::normal_fullrank::calc_grad           "   '                                "   ܴ                                "   h    @     `                  "   $         
   T                   "               $                   "       t ,    p                 "   @         )                     "   X            \ `                  "               D                   "	               ( h                  "                                  "   Ĳ            $                    "                                   "                (                  "   <            L                    "                                   "   t    L              }Ô%IJz5        "                                 "                0          Something went wrong after call_sampler.        -DT!@"   $            ,                    "   T            \                    "                                   "                                   "                                   "                           g
   \J
                      k 
 
                            
         
 0
                 k            @   
             k             @   X
                        p
         0
                        k 
 
                            
         
 0
                 k            @   
                         l ( 
   
                            @ 
         X 
 0
                  l            @   ( 
                        Hl  
  
                             
          
 X 
 0
                     Hl            @    
                        pl 0!
 !
                            H!
         h!
 X 
 0
                     pl            @   0!
                        l !
 !
                            !
         !
 X 
 0
                     l            @   !
                        l @"
 "
                            X"
         x"
 X 
 0
                     l            @   @"
                        l "
 "
                            "
         "
 0
                 l            @   "
                        m H#
  #
                            `#
         #
 "
 0
                     m            @   H#
                        Hm #
 #
                            #
         $
 "
 0
                     Hm            @   #
                        xm X$
 0$
                            p$
         $
 "
 0
                     xm            @   X$
                        m $
 $
                            $
         %
             m             @   $
                        m X%
 0%
                            p%
         %
             m             @   X%
                        n %
 %
                            %
         %
             n             @   %
                        @n H&
  &
                            `&
         &
 &
 0
                     @n            @   H&
             pn            @   &
                        &
         &
 0
                            n ('
  '
                            @'
         P'
             n             @   ('
                        n '
 x'
                            '
         '
             n             @   '
                        o (
 '
                            0(
         P(
 "
 0
                     o            @   (
                        (
         (
             @o             @   x(
                        po (
 (
                            )
         )
             po             @   (
                        X)
         h)
             o             @   @)
                        o )
 )
                            )
         )
 )
                 o            @   )
                        p 8*
 *
                            P*
         h*
 %
                 p            @   8*
                        *
         *
             p             @   *
                         q +
 *
                             +
         @+
 
 0
                      q            @   +
                        pq +
 h+
                            +
         +
 &
 0
                     pq            @   +
                        q ,
 +
                            0,
         P,
 
 0
                     q            @   ,
                        r ,
 x,
                            ,
         ,
  -
 0
                     r            @   ,
             @p            @   (-
                        @-
          -
 0
                            `r -
 X-
                            -
         -
 0
                 `r            @   -
                        r  .
 -
                            .
         (.
             r             @    .
                        t x.
 P.
                            .
         .
             t             @   x.
                        pu .
 .
                            /
         /
             pu             @   .
                        X/
         h/
             v             @   @/
                        /
         /
             0x             @   /
                        /
         0
             y             @   /
                        z X0
 00
                            p0
         0
 %
                 z            @   X0
                        { 0
 0
                            0
         1
 %
                 {            @   0
                        | X1
 01
                            p1
         1
 h)
                 |            @   X1
                        @| 1
 1
                            1
         2
 h)
                 @|            @   1
                        H2
         `2
 (
                 x|            @   02
                        | 2
 2
                            2
         2
 P'
                 |            @   2
                        } 03
 3
                            H3
         `3
 (.
                 }            @   03
                        P~ 3
 3
                            3
         3
 .
                 P~            @   3
                         04
 4
                            H4
         `4
 /
                             @   04
                        4
         4
 h/
                 Ѐ            @   4
                        4
         5
 /
                 0            @   4
                        P5
         h5
 0
                             @   85
                        @ 5
 5
                            5
         5
 6
                 @            @   5
                          @   86
                        P6
         6
                         6
 `6
                            6
         6
                          @   6
                           7
 6
                           7
         @7
 6
 h7
 7
                                      @    7
             k    (       @   
             k     (       @   X
                        X 7
 7
                           7
          8
 6
 H8
 7
                         X            @   7
             k    (       @   
                         8
 p8
                           8
         8
 "
 0
  9
                                     @   8
                  @       @   6
                @        8
 (9
                              x9
 P9
                           9
         9
 8
 "
 0
  9
 9
                                              @   x9
             m         h      P   X%
                @         x9
 :
                    x        x9
 @:
                             :
 h:
                           :
         :
 h!
 X 
 0
  9
                                         @   :
                          (;
  ;
                            @;
         `;
 4
 h/
                                  @   (;
                        ` ;
 ;
                            ;
         ;
 5
 /
                     `            @   ;
                         8<
 <
                            P<
         p<
 h5
 0
                                 @   8<
                @        :
 <
                    (          7
 <
                    (       X 7
 <
                              8=
 =
                           P=
         =
 !
 X 
 0
  9
                                          @   8=
                @         8=
 =
                             =
 =
                           >
         P>
 :
 h!
 X 
 0
  9
 9
                                                 @   =
                @        =
 x>
                    x       =
 >
                             >
 >
                           ?
         @?
 @7
 6
 h7
 7
 h?
                                             @   >
             m         @      P   X%
                (        >
 ?
                    P       >
 ?
                            p @
 ?
                            @
         X@
  8
 6
 H8
 7
 h?
                                 p            @   @
                (       p @
 @
                    P      p @
 @
                             @
 @
                           A
         PA
 =
 !
 X 
 0
  9
 9
                                                 @   @
                @        @
 xA
                    x       @
 A
                            ` A
 A
                           B
         8B
 &
 &
 0
 `B
                             `            @   A
                  (       @   6
                (       ` A
 B
                             B
 B
                           B
         0C
 8B
 &
 &
 0
 `B
 XC
                                                 @   B
             m         P      P   X%
                (        B
 C
                    `       B
 C
                            P C
 C
                            D
         0D
 5
 6
                     P            @   C
                         D
 XD
                           D
         D
  
 X 
 0
  9
                                         @   D
                @        D
 D
                              @E
 E
                           XE
         E
 #
 "
 0
  9
                                          @   @E
                @         @E
 E
                              F
 E
                           F
         XF
 D
  
 X 
 0
  9
 9
                                                 @    F
                @         F
 F
                    x        F
 F
                              F
 F
                           G
         PG
 E
 #
 "
 0
  9
 9
                                                  @   F
                @         F
 xG
                    x        F
 G
                             G
 G
                           H
         8H
 P(
 "
 0
  9
                                         @   G
                @        G
 `H
                             H
 H
                           H
         I
 8H
 P(
 "
 0
  9
 9
                                                 @   H
                @        H
 0I
                    x       H
 XI
                            p I
 I
                           I
         I
 X 
 0
  9
                         p            @   I
                @       p I
 J
                            С `J
 8J
                           xJ
         J
 I
 X 
 0
  9
 9
                                 С            @   `J
                @       С `J
 J
                    x      С `J
  K
                             PK
 (K
                            hK
         xK
                          @   PK
                         K
 K
                            K
         K
                          @   K
                        H @L
 L
                            XL
         pL
 K
                 H            @   @L
                        x L
 L
                            L
         L
 P'
                 x            @   L
                         @M
 M
                            XM
         pM
 )
                             @   @M
                         M
 M
                            M
         M
 pM
 )
                                 @   M
                         HN
  N
                            `N
         N
 pM
 )
                                 @   HN
                         N
 N
                            N
         O
 0O
 )
                                 @   N
             `            @   XO
                        pO
         0O
 )
                            Ъ O
 O
                            O
         O
 0O
 )
                     Ъ            @   O
                        @ 8P
 P
                            PP
         pP
 P
 )
                     @            @   8P
                         @   P
                        P
         P
 )
                              Q
 P
                            0Q
         PQ
 P
 )
                                  @   Q
                         Q
 xQ
                            Q
         Q
                          @   Q
                         R
 Q
                            0R
         XR
 M
 pM
 )
                                     @   R
                        0 R
 R
                            R
         R
 N
 pM
 )
                         0            @   R
                         8S
 S
                           PS
         S
 XR
 M
 pM
 )
 S
 S
                                                 @   8S
             x|           @   02
             @o            @   x(
                        8S
 T
                            Ѝ XT
 0T
                           pT
         T
 R
 N
 pM
 )
 T
  U
                                     Ѝ            @   XT
             x|           @   02
             @o            @   x(
                       Ѝ XT
 (U
                             xU
 PU
                           U
         U
 U
 O
 0O
 )
 `V
 V
                                                 @   xU
             p            @    V
                        8V
         U
 O
 0O
 )
                         (           @   V
                        V
         V
 (
                 (            @   V
             @o            @   x(
                        xU
 W
                            ` XW
 0W
                           pW
         W
 W
 O
 0O
 )
 @X
 hX
                                     `            @   XW
                         @    X
                        X
         W
 O
 0O
 )
                         (           @   V
             @o            @   x(
                       ` XW
 X
                             X
 X
                           X
         8Y
 `Y
 pP
 P
 )
 Y
 hX
                                                 @   X
                         @   Y
                        Y
         `Y
 pP
 P
 )
                         `           @   Y
                        Z
          Z
 (
                 `            @   Y
                        X
 HZ
                             Z
 pZ
                           Z
         Z
 [
 PQ
 P
 )
 [
 [
                                                 @   Z
             @            @   @[
                        X[
         [
 PQ
 P
 )
                         `           @   Y
             @o            @   x(
                        Z
 [
                            \
         (\
 '
                             @   [
                        h\
         \
 '
                             @   P\
                         \
 \
                            \
         ]
 (\
 '
                                 @   \
                        P X]
 0]
                            p]
         ]
 \
 '
                     P            @   X]
                         ]
 ]
                            ]
         ^
 \
 '
                                 @   ]
                        X^
         p^
 '
                 в            @   @^
                          ^
 ^
                            ^
         ^
 '
                              @   ^
                        8 @_
 _
                            X_
         p_
 '
                 8            @   @_
                        x _
 _
                            _
         _
 p^
 '
                     x            @   _
                         H`
  `
                            ``
         x`
 '
                             @   H`
                        P `
 `
                            `
         `
 '
                 P            @   `
                          Ha
  a
                            `a
         xa
 K
                              @   Ha
                        0 a
 a
                            a
         a
 P'
                 0            @   a
                         Hb
  b
                            `b
         xb
 Q
                             @   Hb
                        ` XO
 b
                              b
 b
                            c
         (c
 1
 h)
                                  @   b
                        ` Y
 Pc
                            8 c
 xc
                            c
         c
 1
 h)
                     8            @   c
                        ( V
  d
                            h Pd
 (d
                            hd
         d
 *
                 h            @   Pd
                         d
 d
                            d
          e
 P'
                             @   d
                         Pe
 (e
                            he
         e
 P'
                             @   Pe
                        8 e
 e
                            e
          f
 %
                 8            @   e
                        h Pf
 (f
                            hf
         f
 K
                 h            @   Pf
                         f
 f
                            f
          g
 %
                             @   f
                        p  V
 (g
                              X
 Pg
                             P
 xg
                             Y
 g
                            @ @[
 g
                             h
 g
                            0h
         @h
                          @   h
                                              4	 
RpJ
 `g       -  4	 
RpJ
 g       Ώ  4	 
RpJ
  h         2p! 4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 S
  0J
 ]  2P          S
 S
 T
 0T
  4 pJ
 8]  2P 2P 2P 2P                      )  G     U  PT
     pT
  4 
pJ
 `]  2P 2P                     T
 T
 T
  0J
 ]  2P 2P 2P        )  N     [          20        	   k 0   T
 8   	   pn p   0U
 8   	   @p @   pU
 8   	   Hl `   U
 8   	   pl     U
 8   	   hp (   0V
 8   	   l 8   pV
 8   	   m H   V
 8   	   xm X   V
 8   	   Hm h   0W
 8   	   k x   pW
 8   @           W
 8                 `k
   J
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ] 
 
2PJ
 ]                   T
     T
    U
     =U
    [U
     }U
    U
     U
    U
     U
    V
     =V
    [V
     }V
    V
     V
    V
     V
    W
     =W
    [W
     }W
    W
     W
    W
      20 20
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   d 4 2p 20
 
4 
2p d 4 2p 20
 
4 
2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p  
 
4 
2p d T 4 2p	 p`P0   d T 4 2p d 4 2p d 4 2p
 
0! t d T A  A  p
 !   t  d  T A  A  p
 !   A  A  p
  0! t d
 T B  B  q
 !   t  d
  T B  B  q
 !   B  B  q
  20 R0
 
4 
2p	 	r! 4
 F  F  |q
 !    t d T F  F  q
 !   t  d F  F  q
 !   t F  F  q
 !   F  F  q
 !   F  F  |q
     20
 T 4 R
p` B  ! 4	 K  L  4r
 ! t L  L  <r
 !   L  L  <r
 !   K  L  4r
  d	 4 Rp t 20
 
d 
2p! 4 0O  tO  r
 !   0O  tO  r
  d T 4 2p
 t d T 4 
 
4 
2p B  
 
4 
2p T 4 R
p`
 T 4 rp`!  0W  W  0s
 !   0W  W  0s
 
 
4 
2p d T 4
 2p 4  2p T	 4 2p!  d [  \  s
 !   [  \  s
  d T 4 pP Pd	 K4 t T
 2 B   B   B   B   B   B   B   B   B`0  !$
 $  
 
t	 T `  `  Lt
 !   t	 `  `  Lt
 !   `  `  Lt
 
 
4 
2p< <4 
d 
2p 4  2`P0! t	 Pd  yf  t
 
 
4 
2p B   t 
4 
2` 20!
 
t d i  i  u
 !   t i  i  u
 !   i  i  u
 
 
4 
2p 20 d	 T 4 2! t k  l  `u
 !   k  l  `u
  20
 
4 
2p! d m  m  u
 !   m  m  u
  R
pP0! d
 n  o  u
 !   d
 n  o  u
 !   d
 n  o  u
  4 p d 4 2p
 
4 
2p 20 20!! !	 t 
d T 0t  Qt  Hv
 !   0t  Qt  Hv
  B   B   20 d	 4 Rp B   B   ! " "t 20!
 !t) !d( !T' !4& !"    20
 
4 
2p B   R0 20! t  ~  *~  w
 !   t  ~  *~  w
 !    ~  *~  w
  B  ! 4 ~    Pw
 ! t  4 ~    Pw
 !   ~    Pw
 ) ) # x d 4 p! h   p  w
 !     p  w
 0X
     W
    X
  4 RpJ
 ^  2P 2P 2P0  S      [     w            d 4 2p`X
  4	 
RpJ
 ^  2P`           B   b
p`0  !   
 T Є    x
 !         T Є    x
  b	  !   t d
 T 4 `  o  x
 !   `  o  x
 !       t  d
  T  4 `  o  x
  d T 4 2p B   B  
 
4 
2p
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 d 4 2p
 d T
 4 rp b
p`0  !   
 T 0  ^  pz
 !         T 0  ^  pz
  b	  !   t d
 T 4   Ϣ  z
 !     Ϣ  z
 !       t  d
  T  4   Ϣ  z
    !` ` [T
 %  t 
d 4     ,{
 !       ,{
 h
 h cT ^4
 	Rp`K
 K FT
 
4 
R	p`   !Y Y TT
  t 
d 4   ȱ  {
 !     ȱ  {
  20!
 
t d    q  {
 !   t  d    q  {
  BP  !g gt
  d	 4     |
 !       |
 X XT t d 4
 r b  !k k f at \d T 4
 P  _  t|
 !   P  _  t|
 !       t  d  T  4
 P  _  t|
   	  ! T    t d 4     |
 !          |
 !        |
 !       |
 
 
4 
2p B   t d T
 4 rO
 OT d 4
 r
p
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 t	 d T 4 2 B   t d
 T	 4 2X
     X
  p0  J
  _  2P 2P                    T
 4 2p` t d
 T	 4 2
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p B   20
 
4 
2p
 
4 
2P! t d   
 !   t   
 !     
  20 t d
 T	 4 2 b   d T 4 2p B  ! 4  ' d
 ! t  4  ' d
 !    ' d
  B  ! 4  *
 
 ! t  4  *
 
  B  ! 4 
 
 ܀
 ! t  4 
 
 ܀
 !   
 
 ܀
  B  ! 4 p   
 ! t  4 p   
 !   p   
  B  ! 4 `  d
 ! t  4 `  d
 !   `  d
  B  ! 4 P  
 ! t  4 P  
 !   P  
  B  ! 4 @  
 ! t  4 @  
 !   @  
  B  ! 4 0  0
 ! t  4 0  0
  d	 4 RpX
     X
 ( (h #t d T
 4 J
 H_  2P 2P B           B   20 d 4 2p Y
 & &d !T
 4 
pJ
 p_  2P &     u @Y
     `Y
  	  d. T- 4, * p  J
 _  2P 2P 1               Y
     Y
    Y
    Y
     Z
     Z
    @Z
    `Z
    Z
    Z
    Z
    Z
     [
     [
    @[
    `[
  dH 4G D p  J
 _  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      w        4    W                    i                    -    M     	        
       #    C    y         
       %     E     j     
 t	 d T 4 2 T	 2! t d 4 p" " ȅ
 !   p" " ȅ
  B  
 
4 
2p B   B   . P  ! ( ) * + t, d- 40 ' ' $
 !   (  t,  d- ' ' $
 !   t,  d- ' ' $
 !   d- ' ' $
 !   ' ' $
 
 t	 d T 4 2 T	 2! t d 4 t "t ̆
 !   t "t ̆
   
  ! 
   t d T 4 0w Gw 
 !   
 0w Gw 
 !   0w Gw 
  T
 4 rp` >   ! 7 t: 8 9 d; T< 4= `  t
 !   `  t
 !   7  8  9  t:  d;  T<  4= `  t
 
 d T 4 p  	  !  d  
 t T 4    
 !   T    
 !      
 !       
  t  d  T  4    
   !    d  t T 4  " 
 !       " 
 !     " 
  b   2	p`P0 B   B   20 20 B   B   20 B   B   20 20 d	 4 Rp T
 4 rp` t d T 4  T
 4 rp` T
 4 rp` B  [
     [
 ( . p`P0  J
 _  2P 2PP       !    !     !  20
 d T 4
 Rp[
     [
     \
     \
    @\
 ' '48 0 
p`P  J
 `  2P 2P 2P 2P 2P # n#     }#    )    f)    ;.    .    0    0    2     2 ) )h t d T
 4 p\
     \
  	 0  J
 8`  2P 2P5 K5     W5    t5     5 \
     \
  	 0  J
 ``  2P 2P6 6     6    7     7 S Sd
 NT	 
4 
Rp\
 #
 #h d
 T 4 rpJ
 `  2P< =     G= ]
 : : 5 0 +x 'h #T 4 	p`J
 `  2Pp= A     CA @]
     `]
  Rp
`P0J
 `  2P 2PA A     A    A     aB ]
     ]
     ]
    ]
 . .x *h	 &4  
p	`P  J
  a  2P 2P 2P 2PB B     B    C    1C    IC    F     ^
      ^
     @^
    `^
 &
 &4 
p	`PJ
 (a  2P 2P 2P 2P@G lG     G    G    G    G    ?K     ^
     ^
     _
    0_
    P_
    p_
    _
    _
    _
    _
    `
 ) )43 * 
p	`P  J
 Pa  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2PK K     L    L    EL    ]L    N    N    O    O    O    O    O 	   O 
   O    lP    P    P    2Q     `
     @`
     ``
    `
 &
 &4 
p	`PJ
 xa  2P 2P 2P 2PQ Q     Q    Q    	R    !R    {U     `
     a
     0a
    Pa
    pa
    a
    a
    a
    a
    b
    0b
 ) )43 * 
p	`P  J
 a  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2PU V     OV    ^V    V    V    X    X    FY    WY    Y    Y    
Z 	   Z 
   =Z    Z    Z    :[    r[     b
     `b
     b
    b
 &
 &4 
p	`PJ
 a  2P 2P 2P 2P[ [     \    .\    I\    a\    _      t d 4 ! T  ` f` P
 !    ` f` P
         	   @n (    c
 8                 
  
R0J
 a 
 
2PJ
 a a a     a  c
     
c
    c
     @c
 `c
    c
    c
    c
    c
     d
  d
 & &T& "4$  	p`  J
 b  2P 2P 2P 2P 2P 2P 2P 2Pa =b     Lb    [b    jb    yb    b    b    d    od    ie    xe    e    e @d
 `d
    d
    d
    d
    d
     e
  e
 & &T& "4$  	p`  J
 @b  2P 2P 2P 2P 2P 2P 2P 2P f Mf     \f    kf    zf    f    f    f    $h    h    yi    i    i    i @e
 `e
    e
    e
    e
    e
     f
  f
 & &T& "4$  	p`  J
 hb  2P 2P 2P 2P 2P 2P 2P 2Pj ]j     lj    {j    j    j    j    j    4l    l    m    m    m    m @f
 `f
    f
    f
    f
    f
     g
  g
 & &T& "4$  	p`  J
 b  2P 2P 2P 2P 2P 2P 2P 2P n mn     |n    n    n    n    n    o    Dp    p    q    q    q    q g
     @g
     `g
    g
    g
    g
    h
     0h
 & &4  
p	`P  J
 b  2P 2P 2P 2P 2P 2P 2P 2P0r \r     r    r    r    r    r    s    	t    6t    Dt    5u    Au    u     Ph
  4
 
RpJ
 b  2Pu u     u ph
  4
 
RpJ
 c  2P0v Vv     mv h
  4	 
RpJ
 0c  2Pv v     v h
 ! !h d 4 pJ
 Xc  2Pw Fw     w h
  4
 
RpJ
 c  2Pw x     x  i
  4
 
RpJ
 c  2PPx vx     x  i
  4	 
RpJ
 c  2Px x     x @i
  d 4	 
RpJ
 c  2P0y [y     y U U
 M E = 5 - %  x h 3 
pP!E
 E 8/ (0 d1 42  z { `
 !    z { `
 `i
 i
    i
    i
    i
 #	 #d T 4  p  J
  d  2P 2P 2P 2P 2P 	         9    H    Z    h    C     j
 0j
    Pj
    pj
    j
 #	 #d T 4  p  J
 Hd  2P 2P 2P 2P 2PP          ɂ    ؂            Ӄ    B  k
     j
     j
    0k
    Pk
    pk
    k
    k
    k
    k
     l
 . .h ; p`
P0J
 pd  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P  4     [                )    A    P    \    ~     	        =    L     
   P     pl
     0l
     Pl
    l
    l
    l
     m
     m
    @m
    `m
     m
 . .h ; p`
P0J
 d  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      ې        j                Б    ܔ         	           ̙    > 
   Л      20w w ^ X R 0 + &	 !
 x h  m
 m
    m
     n
     n
    @n
    `n
    n
    n
    n
    n
     o
     o
 @o
 - -x )h %4: 2 
p`P  J
 d  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P  y     Ğ        5    S        ϡ        .    ȫ         	   n    P 
   b                    R    ` 
     20po
 o
    o
    o
    o
               @           p
 8               ,
 -	 ! p`0  J
 d  2P 2P 2P 2P 2P
 
2PJ
 d P                  ^    l            n
    
 p
     p
    Dp
     `p
 p
    p
    p
    p
     q
     q
    @q
    `q
        	   q
        @           q
 8   	   
         |
 -	 !0 p`0  J
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2PJ
 e 
 H     `                                    q 	    
    	                    q
     q
    q
     q
 r
    0r
    Pr
    pr
    r
    r
    r
    r
    s
    0s
    Ps
    ps
 -
 -h )47 . 
p	`P  J
 8e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P          #    j                u         !    ~! 	   "    (# 
   9#    &    (    (    ))    7)  t
     s
     s
    s
    0t
    Pt
    pt
    t
 ) )4!  
p	`P  J
 `e  2P 2P 2P 2P 2P 2P 2P 2P) )     )    *    "*    .*    Z*    i*    +    +    +    ,     -    I-     
 
4	 
2p 20 d T 4 p t d T 4  20t
 t
     u
     u
    @u
    `u
    u
    u
    u
    u
     v
  v
 ' '4, $ 
p`P  J
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2Pp4 4     4    
5    "5    I5    a5    p5    8    8    8    ?9 	   P9    =    =    b> 
   >    >    ? 
 
4	 
2py
     @v
    `v
    v
    v
    v
    v
     w
     w
    @w
 	   `w
 
   w
    w
 
   w
 
   w
 
    x
     x
    @x
    `x
    x
    x
    x
    x
     y
     y
    @y
    `y
 
   y
 
   y
    y
    z
 1 14 ! p`P  J
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P@ @    @    	A    A    C    C    6D    _D    D 	   D    E    "E 
   _E    E    F    F    gF    }F    F    F    )G    ?G    nG 
   G    G    $H    3H    ;H 
   CH 
   H 	   ~I    zJ    J    J    J    J    'K     @z
 `z
    z
    z
    z
    z
     {
     {
           @{
           {
 {
 @           `{
 8      	   
      
 + +h . 
p`0  J
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2PJ
 e  2P 2P`K K     L    )L    pL    R     S    T    T    NU    V    V    W 	   *W    X    Z    Z    
[ `{
     m{
 
   {
      |
  |
    @|
    `|
    |
    |
    |
 |
 + +4!  
p`P  J
  f  2P 2P 2P 2P 2P 2P 2P 2PP[ [     [    [    [    !_    /_    _    `    #a    .a    pa  }
  }
    @}
    `}
    }
    }
    }
 }
 & &T& "4$  	p`  J
 (f  2P 2P 2P 2P 2P 2P 2P 2Pa a     a    b    b    )b    7b    b    c    d    e    (e    7e    ~e  d 4 2p d 4 2p ~
      ~
     @~
    `~
    ~
    ~
    ~
    ~
    ~
     
 	    
 +
 +d' 'T% #4$  
p  J
 Pf  2P 2P 2P 2P 2P 2P 2P 2P 2P 2Pg "h     h    i    i    j    j    k    k    	l 	   l 
   l 	   l    l    l    l     
m P
 p
    
    
    
    
           
               	   
           
    
    0
    P
           p
           
                  P
    p
 
 @           0
 8   @           
 8   @           
 8   @            
 8               
 	   
         б
             
             
 3
 3h  /dI +4H B p  J
 xf  2P 2P 2P 2P 2P 2P 2P
 
2PJ
 xf  2P
 
2PJ
 xf  2P 2P 2P 2P 2P
 
2PJ
 xf  2P
 
2PJ
 xf  2P 2P 2P`m m      n    Gn    n    n    n    't    9t    ^t 	   pt 
   t    y    y 
   :{    \{    {    }    }    }    }    o                    z        )    7     0
     =
    d
     
    Ԁ
     
    ā
     
    4
      d T 4 p    4	 
RpJ
  j        !     A ! 4    A  "   4	 
RpJ
 k       Ε  
R0J
  m  &     1  4	 
RpJ
 0m P u       4	 
RpJ
 `m  5     N   J
 Pn  Ù     ϙ           J
 n  3     ?    \     
 
RPJ
 n 
   J
 n               H
 @           
 H   p }           
 
RPJ
  o 
   J
  o               
 @           Ђ
 H         ޜ      
 
RPJ
 0o 
   J
 0o               
 @           
 H                
 
RPJ
 `o 
   J
 `o               
 @           
 H   0 =     ^ `     
 
RPJ
 o 
   J
 o               
 @           0
 H   p }           
 
RPJ
 o 
   J
 o               P
 @           P
 H         ޝ      
 
RPJ
 o 
   J
 o               
 @           p
 H                
 
RPJ
  p 
   J
  p                
 @           
 H   0 =     ^ `     
 
RPJ
 Pp 
   J
 Pp               
 @           
 H   p }           
 
RPJ
 p 
   J
 p               
 @           Ѓ
 H         ޞ      
 
RPJ
 p 
   J
 p               X
 @           
 H                
 
RPJ
 p 
   J
 p               
 @           
 H   0 =     ^ `     
 
RPJ
 q 
   J
 q               (
 @           0
 H   p }            4 pJ
 s P
 p
 
 
 0 ]     k          ɠ      !    B  
 !
 
	 4  B  
  d T
 2
p!    A 8
 ! 4  A 8
  t	 d T 2G G A ; ( "x h  . .h )4 Rp 4+ ( p  J
 w      :      4	 
RpJ
 x S
        !     p 
 ! 
   	 
 
 T   p 
  p`0 4	 
RpJ
 `y  ų     ޳ !      
 ! t    
  h 
4 
Rp 4	 
RpJ
 p  
 ж        
R0J
  @
  ƹ     ڹ  BP  J
   4 r
	p`J
              (
 @           
 H   `
 
               
       D    ^        ?    S 
     
    ̅
      BP0  J
    4 r
	p`J
               
 @           @
 H    
  
               
  
     ;    I        #    7 @
     N
    k
      	  d4 T3 42 0 p  J
 0 p      )    5    P       d- T, * p  J
 ` 
     
 p          I    d- T, * p  J
  `          8 !     
 ! t d 
T 4
   
  B  * *4 B  ! !d
 !T !4
 !2p!   0  
 !   0  
  p
`P07 7x 2h t d T
 4  	  d4 T3 42 0 p  J
  @                    	  d4 T3 42 0 p  J
  
     
    
 @              !    : : x 	h   " "x h 
4 
p 	  d4 T3 42 0 p  J
 @       [    g        !     X
 !   
    X
  p
`P0!     
 !    
 
 T 4	 p` 	  d0 T/ 4. , p  J
   	     8    d  	  d0 T/ 4. , p  J
            A  	  d4 T3 42 0 p  J
   `          &    A     	  d4 T3 42 0 p  J
 P `          $    ?     x h 4 0  J
   
      
    @
    `
    
    
    
    
     
     
       2    N    b                        <    [    h                    
 	       -     < 1 14    !   `  
 !5 5 / ) #  	 `  
 
 
2PJ
   4 
RpJ
                D
 @           @
 8   @ e      @
     M
    j
     
 
2PJ
   4 
RpJ
                
 @           
 8          
     
    
     !     B A ! 4    B A 	 T/ 4. * p`  J
 @ 0 p         !   
   8
 !     8
 ! 
   8
 
 
2PJ
 p 
 b  J
 p               
 @           
 8          
     ͈
    ׈
     
 
t 4 !      d
 !  l c Z B 9 0  x h    d
 '
 '7  p`P0%
  y q i a Y ;x 4h -47 &#!, p`P!   0 : 
 !   : u 
 !  : u 
 ! d 4 0 : 
 
 
T	 
2p 	2 0  J
  
      
     
 @                    	  d4 T3 42 0 p  J
   R             )    % %d; !4: 8 
p  J
  @
     `
    
    
 P          +    7    W    u  d3 42 0 p  J
 p 
     
  
  
 @
 `
 
    
    
    
     
     
                     $ f    |           .    b    o             	        
       ^    k      h R0 d T 4 2p!      
 !     
 !    " 
 !   " 
 !
 
    
 ! 4
    
  Bp`
P   4	 
RpJ
   @
         4	 
RpJ
 P `
  5     N  4	 
RpJ
  
 `        4	 
RpJ
          4	 
RpJ
   5     N  4	 
RpJ
  p        4	 
RpJ
 @ 
        
 
2PJ
  
 b  J
                
 @           
 8   # $     2$ 
     ͋
    
        d- T, * p  J
  @% %     %    &  4	 
RpJ
  
 
 ' '     '    D(  	  d1 T/ 4. , p  J
 ` p* *     0+    u+    dQ TP N p  J
  
     
    0
    P
 + +     
,    %,    ,    , !               	  x
  - - 
 !    - - 
 !     - - 
 !B B < 6 ' !  	 x
  - - 
   h  0     dQ TP N p  J
  8 9     =9    U9    9    :  	  d4 T3 42 0 p  J
  0: s:     ;    ;    ,;    
 
2PJ
 @ 
 b  J
 @               h
 @           p
 8   P; `;     y; p
     }
    
     	 T/ 4. * p`  J
 p ; ;     	<     4	 
RpJ
  `< <     < <    <  4	 
RpJ
  @= e=     ~= =    =  4	 
RpJ
 ` Ќ
  > Q>     t>  4	 
RpJ
  > >     ?  4	 
RpJ
   ? E?     ^?  4	 
RpJ
  ? ?     ? !               	  x
 D E 
 !   D E 
 !    D E 
 !B B < 6 ' !  	 x
 D E 
 G G ; 5 / * %   	 x
 h 
 K K  @ : 4 / * %  x h	 
  2pP0J
   Rp`0J
               4
 @           
 H           
     U U     U    V     V 
     
    L
     % %t1 !d0 T/ 4. ,   J
    V V     V    V % %t1 !d0 T/ 4. ,   J
 P `
     
 W W     W    W  2pP0J
   p`0J
              t
 @           
 H   
            
          X RX    dX    xX    X 
     
    
      4	 
RpJ
  0
 X X     7Y  4	 
RpJ
   `Y Y     Y !   4 Z [ 
 !   Z [ 
 ! 4 Z [ 
  h R0!   \ \ 
 !5 5 / ) #  	 \ \ 
 ,
 , '	 x
 h 
  t 4 !     
 i j 
 !   i j 
 !
 
 
 i j 
 !   ;m n L
 !  ;m n L
 !  x
 j ;m d
 B B < + %   	 h 
 ! 	 x
 `p r 
 ? ? 9 - ' "   h 
 !    v 3v 
 !   3v Kv  
 ! h T	 3v Kv  
 ! 4  v 3v 
  d
 Rp!      d  4 w /w 
 !      t  d  4 w /w 
 !   gw w 
 ! t gw w 
 ! 4     d w /w 
 !	 	  d w /w 
  P	 T/ 4. * p`  J
   x 0y     yy     4	 
RpJ
 P Pz uz     z z    z  4	 
RpJ
  { 5{     N{ X{    { E E  x h 
4 
p!   # e 
 !	 	 # e 
 !
  x
  [h   # 
 #
 #   	 
 !   p d ,
 !s s j R I @ 7  x h p d ,
 8 8
 '/  p`P0 4	 
RpJ
 P            ^  4	 
RpJ
          4	 
RpJ
 М   %     > X X : 5 0 x h d 4 p 4	 
RpJ
 @ P
 p
 p            4	 
RpJ
  0 U     n  4	 
RpJ
   ՝      !    , A !	 	t  4  , A !    ˡ H
 ! t  ˡ H
  d 4
 RpJ
   Ў
     
           2      !     p
 !.
 .  x t d
 T   p
  h 0 d
 T	 4 Rp!     R 
 ! d   R 
  T
 4	 Rp)
 )t3 %d2 !T1 40 , 	  J
    ֩     Y      h 
/ J
 П  5     f      
R0J
   
 Ы 	     O   0  J
 P                e      !   t  4 Ю  
 !   Ю  
 !
 
t 4 Ю  
  b   d
 4	 
RpJ
 @ 
     
 p      ±     /
 / ) x h 0 2pP0J
 p  d
 4 
rpJ
 p              
 @            
 H            
            /    A     O  
     /
    \
      20 
R0J
  @ y       
R0J
 С p
  )     o  
R0J
    ٶ       
R0J
 0 P      Ϸ  d 4	 
RpJ
 ` 
     А
 `              0  J
    Y     p                  +  0J
  
      
 @ u         Ļ       0J
    U                 0  J
     9     P    l     x           d
 4	 
RpJ
 P @
     p
   d     r      d
 4	 
RpJ
  
     
  $     2      
R0J
  
       _  d 4	 
RpJ
  
     @
       "    p  d 4	 
RpJ
  `
     
           0   0  J
 @ 
     
 P               0 !   P e 
 ! 4 P e 
  p   4  d
 4	 
RpJ
 p  
     0
 p            d 4 2p h d x   !    - 
 ! x 4
 h  - 
  d T p h g    !   `  
 ! x t d
 {T j4 h `  
 
 

 
2PJ
   4$ " p  J
              $
 	   hp     
 8   P
 p
    
                          S    m              
      d 4	 
RpJ
 Ф Г
      
  T     b     !   
   8
 !     8
 ! 
   8
  4 Rp`P!     
   
 !     
 !
 
 
   
  4
 Rp`P 	  d1 T/ 4. , p  J
   0 {         " !   @ k 8
 !  d 
T 4 @ k 8
 !     8
 !  d 
T 4   8
  
p 
R0J
 0  )     o  
R0J
 `          0  J
                  (    q        0  J
   	          <     H           d
 4	 
RpJ
  
     
  4     B      d
 4	 
RpJ
   
     
           P !
   qx
 < 		   
 ! h      
    !     T 4
 ! d 
T 4   T 4
  t    
R0J
           d 4	 
RpJ
 0 0
     `
  $     2      d 4	 
RpJ
 ` 
     
           @   0  J
  @
     p
     
 `                   !     k  d
 4	 
RpJ
  Е
      
             !     X
 !  t 
T 4   X
 !   P { (
 !   {  
 !    T {  
 ! t P { (
  r`0 
R0J
    9       d 4	 
RpJ
    
     P
        "     p    0  J
 P  
     P
     p
                   E       d
 4	 
RpJ
  p
     
           P  d 4	 
RpJ
  
     
 p           !   0 I H
 !
 
t d 0 I H
 ,
 ,t? (d> $T=  4< 8 	  J
  
     0
    P
 p
    
    
 З
    
    
    0
    P
 
   p
    
  -                  +                     >    s     	           >	 
   
    
    
    
 
 
4 
2p!   p  0
 ! t
 
d	 T p  0
 
 
20!     h
 ! 
 
t	 d   h
 	 	2P0
 
2PJ
 p # #t d
 4	 RJ
 p             
 @           И
 8   
                 p          Q И
     ݘ
    
      d
 4	 
RpJ
   
  
    @
 p                R0J
 Ы 
   .     :  d T 4 pJ
   `
       o  R0J
 0        "
  
	p`P0J
 ` 
 
    
    
    
    0
    P
    p
    
    
 	   К
    
           !    n                     r             	    
   ( 	   -    P            '      P  "
  
	p`P0J
  0
 P
    p
    
    
    
     
     
    @
    `
 	   
    
  c                     ^    z                L    a 	   n 
    	           B            A  !   ! ! 
 !n n
 e N E
 <  x ! ! 
 ! h 0   ! 
 B
 B =  ( p`P0  
 
2PJ
   d 4
 
RpJ
                
 @           
 8   1 1     >2 
     
     
      R0J
  2 2     2  4 RpJ
   
     0
    `
 2 3     ,3    A3    3     3  4 RpJ
 P 
     
    Н
 3 3     3    4    X4     \4  R0J
  
 4 4     4 $ $x h   !   6 6 
 !  t 
T 4 6 6 
  
` R0J
  P= q=     = !   = = 
 !   t = = 
 !
    t 
d	 T = = 
    x h 0 # J
  
 C C     !   0H UH 
 ! 4 0H UH 
 >
u>h ,s'9  p`0P  J
 @ 0
     P
 `I J     wK    6S     MS !   S S  
 !
 
 4 S S  
  d	 T 2p R0J
 p @T aT     T  R0J
  T T     T  R0J
 Ю V 1V     TV 
 
2PJ
   !
 !d 4 
pJ
                 
 @           p
 8   V W     SX p
     }
    
     !   Y Y <
 ! 
 
t	 4 Y Y <
  2
`
P R0J
 0 Z Z     Z ;
u;h ,s'!  p`0P  J
 ` 
     
 Z 2\     \    l_     }_ ;
u;h ,s'!  p`0P  J
  _ 'a     a    jd     {d !   @e Ye H
 !
 
t d @e Ye H
  0   4
 RpJ
  pg g     g    T 4 
R	p`J
   
      
 g 9h     wh    h !   h )i 
 ! t h )i 
  T
 4	 R`* *d %T  4
 R
pJ
 @ @
     `
    
 i bj     j    j    $k  	  d T 4  p  J
  0
     `
 Pk k     k k    k     l 
 
4 
Rp d T 4
 rp 	  d T 4  p  J
          m n     )n    Fn     dn 
 
2PJ
   # #t d
 4	 RJ
               x
 @           
 8   
                 Po o     o    1p 
     ͟
    
     !   Pp q  ! 4 Pp q   4 2p!   q q 0
 ! d q q 0
 
 
4 
2p
 
2PJ
 P ) )h $d 4 r
pJ
 P               
             
 @            
 8   @           
 8                   0r r     cs s    s 
     
    
     -
    7
     
 
RPJ
   R	p`P0J
  / &p`0J
                
             
 @            
 H   @           @
 h           
               P
 t u     Qv v    w    iw    w w    Gx @
     R
    ɠ
     
    E
     
 
2PJ
  !
 !d 4
 R
pJ
                
             
 @           
 8   @           p
 8   px /y     y y    !z p
     }
    
     
    
     
 
2PJ
  !
 !d 4
 R
pJ
                
             
 @           
 8   @           
 8   z {     { D|    p| 
     ͡
    
     
    
      
R0J
  
     
    Т
    
    
    0
 } &}    A}    L}    W}    b}    m}     x} !   P~ ~ 
 !   ~ ~ 
 ! 
 ~ ~ 
 !
 
t T
 P~ ~ 
 
 
R	`0 d 4 
rpJ
 @ 
     0
     P
    p
           #    A    M    T  4	 
RpJ
 p p                           " "d T
 4	 
RpJ
   ˁ     <  h 4. , p  J
         +    8     Q  bP0  J
 ` " 
p`0J
 `               \
 @           p
 X    +      p
     ~
    
      # J
  
 P q      # J
  
         J
   
 0 Q     
 
B	p`P0  J
    R
p`0J
                X
 @           @
 X            
     p               ǈ @
     P
    
      48 	6 p  J
 P  U     h    %    H    W    m     # J
  0
       
 t d T 4  dC 4B @ p  J
  P
     p
    
    
    Х
    
    
  
         /    ٍ            Î    َ     	  d T 4  p  J
   B     P c    }       	  d T 4  p  J
    R     ` s           	  d T 4  p  J
 @  b     p          Γ !     Ք  ! 4   Ք  
 
d 
2p
 
RPJ
 p ! !d 4
 r
pJ
 p             P @           
 H   
                 `          V 
     
    Ц
      d
 4	 
RpJ
  p      ˖ !     
 !      ! 
    !
 
t T
   
 !     | !     d ! 
   d !
 
t T
   |  R
`0
 
2PJ
 ж  d
 4	 
RpJ
 ж                @           
 8          
     
     
     
 
RPJ
   ! !d 4
 r
pJ
                 H @           
 H   P       
     
    0
     
 
2PJ
 0  d
 4	 
RpJ
 0                @           @
 8     j      @
     M
    `
     
 
RPJ
 ` "
 "t d 4 
rJ
 `               P @           p
 H   @       p
     }
    
      4+ ( p  J
 @ 
     Є
      
      h 4. , p  J
    W                h 4. , p  J
  
     
 p      ަ          
 
RPJ
 0 (
 (d  4 r
pJ
 0                             @           
 H   @           
 H   Ш      
     Ū 
     
     
     
    '
       J
 ` 0
     P
     p
 p          ˫     ׫     
   J
  
   C     
 
B	p`P0  J
 к  r
p`0J
 к               @           Ш
 X           
     Ь               & Ш
     
    
     
 
4 
p d# 4"   p  J
    
     @
     `
    
 @              Ʈ      4" 	  p  J
   0 u                 ׯ 
 
B	p`P0  J
 `  R
p`0J
 `              h	 @           
 X           
      8     G    X     g 
     Щ
    
      dC 4B @ p  J
  
     0
    P
    p
    
    
    Ъ
  -     <    O            Գ             48 	6 p  J
  
     
    Ф
    
    
   e     x    5    X    g    }    
 
RPJ
     J
                 @           
 H    ӵ     ( 
     
    
      dC 4B @ p  J
   0 }             I        $    3    I    
 
RPJ
 `    J
 `                @            
 H    3       
     -
    C
      
"  !   @  p ! t  
T 4 @  p  `  *
 *h %t !d T 4    J
 н P
       # *
 *h %t !d T 4    J
    u      !   0 N A !	 	t  4 0 N A !   0 I X
 ! t 
T 4 0 I X
  `  !    7 
 ! t d 
T 4  7 
     	  d T 4  p  J
 0       +        J  	  d T 4  p  J
 ` p
 
 
 p                d T
 4	 Rp d 4
 rp$
 $T  4 
	p`J
  Ы
   -       d
 4	 RpJ
 о 
     
       (    6  d
 4	 RpJ
   `           )
 )tI %dH !TG 4F B 	  J
 0 0
     P
    p
    
    
 Ь
    
    
    0
    P
           %    @    L    _     
    m    y             	    !      H !
  	 
 
d T    H 	 	p0
 
4
 
r` 0J
  p
 
 
 0 U     c            0J
   Э
 
 
 0
 P
   E     S q                     d
 T 4 rp h 
4
 
p,
 , x h 
4 
p 
R0J
  p       !     K 8
 !  d 
T 4   K 8
  
R0J
        &  
R0J
 @        !   0 [ 
 !  t 
T 4 0 [ 
 !   P c A ! 4  P c A  t 
d 4  
R0J
          t
 d T 4
 R(
 (h $d  T 4  p  J
 p Ю
 
   K     `      
 
B	p`P0  J
   r
p`0J
               t @           0
 X           
     P x               0
     @
    o
      R0 r0 h 0' 'h #T 4 	p`J
  
  l       d 4  p  J
  
 P      < !k k ;x
  
   !   y   
    	 h  !` `     !
 x	  nh
 9     " "  
 !   		 P  4    ٸ &  x
 h  !  h # ]' p M M G ; 5 0  	 x
  -
 -h (t $d  T 4    J
  
 * *     3+ !   + +  !  t 
d T + +   
0!   - - L !
    d 
T 4 - - L  
p  !   3 3  !  t 
d T 3 3   4	 
RpJ
 ` 6 O6     k6  d
 4	 
RpJ
  6 6     7  d
 4 rp" "4 
p`PJ
  
  
     
    @
    `
    
    
    
    
    
 8 $9     :9    `9    v9    9    9    :    :    9:    E: 	   : !   : #;  !
 
 T : #;   Rp`0 h r0J
  @
 0< <     <  d T
 4	 RpJ
 P = >     Q>  h d 4
 rpJ
  p> >     ?  h d 4
 rpJ
  
 ? &@     V@  h d 4
 rpJ
  
 @ @     &A  d
 4	 RpJ
 ` `
 A B     FB  d
 4	 
RpJ
  
 `B B     0C  4 RpJ
  
 C C     D ) )t %d !T 4 	J
    
      
 @
    `
 0D D     D    D     D %E    BE    NE    ZE  bP0  J
 P 1 1hN ! p`0  J
 P                     !       -   -   1       ;   ;   ?       K   K   N       	   k X   
 X   	   k P  к
 X   	   k @  
 X   	   k 8  p
 X   	   k 0  `
 X   
 
    
    
     
     
    @
    `
    
    
 	   
    
     
     
 
   @
                  
    
    0
    P
    p
    
    
    е
    
    
    0
    P
                   
     
     @
    `
    
 #   
    
 %   
     
 '    
 (   @
 )   `
    
    
 ,       ,       .   P
 /   p
 0   
 ,   
 ,   й
 3   
 ,   
 5   0
 ,   P
 7   p
 8   
 9   
 ,       ,       <   `
 =   
 >   
 ,   
 ,   
 A    
 ,    
 C   @
 ,   `
 E   
 F   
 G   
 ,   
 ,    
 J       J       L   
 M   
 `F F     F    G    )G    PG    hG    ~G    G    G    G    G     H    H 	   -H 
   >H 	   gH    H    H    H 
   H    H 
   I    &I    5I    wI    J    J    J    K    #K    FK    [K    nK    K    K    K    K    K    L    L    @L    uL    L    L    L    *N    =N "   PN    rN #   N $   N #   N    N %   N &   N %   &O    JO '   `O (   sO )   O *   O )   O (   O '   O    AP +   ZP ,   P -   R ,   R 2   R ,   R 3   R 4   S 3   1S ,   DS 5   XS 6   iS 5   S ,   S 7   S 8   S 9   S :   T 9   KT 8   WT 7   fT ,   T ;   	V ,   V @   /V ,   QV A   `V B   V A   V ,   V C   V D   V C   W ,   )W E   ?W F   RW G   aW H   W G   W F   W E   W ,   X I   /X J   X K   jZ J   Z ,   Z    
[    E[    }[ `
     n
    
    
    
    Ҵ
    
     ~
    
    
     ö
 !   
     
     θ
 .   
 /   
 0   
 1   2
 0   F
     ޺
 <   
 =   
 >   #
 ?   B
 >   V
     .
 L   B
 M   c
 N   
     % %t !d T 4    J
  н
 
    
    0
 \ e\     t\    \    \    G]    |]  2P$ $d0  T/ 4. * p  J
   P
     p
     
     
     о
     
     
     0
     P
     p
     
     
     п
 ] ^     %^    4^     a^    m^     ^    ^     ^    ^     ^    ^     >_    J_     k_    z_     _    _     _ 	   _     "` 
   .`     J` Z`     o`    ~`     `    `     ` !    a :a $ !     T  4  a :a $ !	 	T    4  a :a $ !  4  a :a $  bp`     T 4
 
R	p`J
 P 
     
 @c nc     c    c     !   c c % ! d c c %  T 4 2p$ $d  T 4  p  J
  @
     `
 pd d     d    d     e !    i i % ! 
  i i %  T 4 rp`!   Pj uj % ! 4 Pj uj %  d T 2p
 
RPJ
   t d
 4 J
                & @           
 H           
      k Yk     ^k    k 
     
    
     
 
RPJ
    t d
 4 J
                & @           
 H           
     k k     k    l 
     
    
     !   @l Jl P' !
 
d 4 @l Jl P' 
 
2p d 4
 p   T
 4
 
R	p`J
 0 @
  o o     Ip    4 p`PJ
 `  
 p tq     q    T
 4
 
R	p`J
  r r     9s !   t s s 
 ! t s s 
 !   t u 
v 
 ! t u 
v 
  T 4 Rp`
 
RPJ
  > >' 9( 4) /x* +h+ 'd_ #4^ X 
p  J
               )             ( 	   k `  
 H   	   k h  
 H   `
 
    
    
    
     
     
    @
           `
 	   
    
    
        
                                          px Ky     Zy    {    6{    [                 ?    X    
        4    c    { 	    
       D    |             N         
     
 
    
     
    0
     (	 (d; $T9  48 6 	p  J
   @
 `
    
    
   t                 +    0    ?    d T 4 pJ
 0 
 
     
     
 @
  ̈     ۈ                ,    i     &	 &T "4  	p`  J
 ` `
     
     
    
    
     
     
    @
     `
       6    E    [    n                    )    n    y         ɋ 
 
B	p`P0  J
  # #4 p`J
              , @           
 X   
 
           
                 V     e    x         
     
    .
      4 p 4 rp`P
 d
 T	 4 2p
 
4
 
rp/ /
 *x &h "4#  
p`P  J
              @
 `
    
    
                                    
       p p            Ԕ    '    \ %
 %t !d T 4 J
        !      d= 4; 8 p  J
 @ 
 
     
     
    @
 @          B    ۙ                 T 4 
R	p`J
 p `
 @      \ G G / * %  x h 4  p  +
 +d% 'T# #4"  
p  J
  
 
    
    
     
     
  o                 <    T    G         !      p0 ! 4    p0  d p  ) )x %h !d T 4 pJ
  @
 0 ʢ     y  
  T 4
 
R	p`J
   `
  9      #
 #h 4 
p	`PJ
 0        "    W         $
 $T 4 R
	p`J
 ` 
  
     
    @
   }     )    J        4  4 R
p`PJ
  `
 
    
 P ĩ     m        Y    a ( (h $T  4 
	p`J
  
 
    
           ۬    E    J $
 $T  4 
	p`J
  
 
     
 p              b    i %
 %4 r
p`PJ
 @  
 @
    `
    
                   Ų %
 %4 R
p`PJ
  
 
    
  \     	    `          0J
   
  
 @
 `
 
 
   ]     k          õ      
     9    G 
 
RPJ
   ! !d 4
 r
pJ
               4 @           
 H   
                  '         ٷ 
     
     
     !   p  lD !  p  lD 
 
RPJ
 P  rp`0J
 P               |5 @           
 H   ` ɹ      
     
    4
      	  d T 4  p  J
    O     [    x      
 
RPJ
   rp`0J
                @6 @           @
 H         
 @
     M
    d
      	  d T 4  p  J
    o     {          !    ] % ! 
  ] % !   x  ; 7 ! x  ; 7  h 
   d 4
 
pJ
 ` 
     
      
                    !     !   @  7 ! t @  7  0 4 
p	`PJ
   
        d 
 
RPJ
  '
 't "d 4
 r	J
                08 @           @
 H         $ @
     M
    `
     !      @  8 !   d
 @  8  R
pP0!       i 8 !   d
  i 8 ] ]d T 4 2p8 8 3x /h +d- 'T, #4+ $ 
p  J
  p
 
  /     W    1 8
 8 2 x h 0 d
 
4 
R	pP!   @ v 9 !    p | 9 !  
 d p | 9 ! T v p 9 ! x h @ v 9  	p0  ! d
    : 
 
4 
R	pP3 3 .x	 *h
 &4   
p	`P  J
               
 
                                                  
                 !   `  ; ! x	  t d p4 h
 `  ;   P
 
B	p`P0  J
 P # #4 p`J
 P             l; @           P
 X   
 
           0
               p                   P
     `
    
     
 
RPJ
  H H* C+ >, 9- 4x. 0h/ ,g (tf $de  4d ` 	  J
              <    !   $      p< 	   k   
 H   	   k   0
 H   
 
    
    
    0
    P
    p
    
           
 	   
    
    
        
                                             `
    
                                                                                             "       #        T     l                            ]    T             	   
 
   <    }                /    Y             0
     =
 
   P
     
 "   
        T 4 
R	p`J
  
              \ \d T 4 2p& &t "d T 4 
	J
   
 
 0
 P
                     D 1 1d )T $4 r
pJ
 0 p
 
  j     +     ] `
 `d T
 4	 2
p* *TB &4A : 
	p`  J
  
 
    
    
    0
 @                                      T 4 
R	p`J
  P
 p
        <    K   d d B = 8  x h 4  p    x xh ( #  
 
 
t 4  T 4 2p`Q Q K . ) $  x h	 
 8
U8h 1t #d 4 S
P  -
U-h & t d 4 SP  !   p  A ! 4  p  A    !   @  B !
 
d 4	 @  B >
 > 9 4t +T ! !4 
p`PJ
  p              <    D k kd T 4 2p
 4 t d
 T	 R h 
4
 
pb
 b4 h d T
 p
 d 4
 T R
p d 4 rp d
 4 rp
 
RPJ
  ! !d 4
 r
pJ
              @C @           
 H   
                  . g.     .    / 
     
    
     !   0/ I/ C !   
  4	 0/ I/ C ! 
 4	 0/ I/ C 
 
d 
Rp
 t d T
 4  0
 d T
 4 rp x h 
4 
rp! !h 	0!   8 ;9 lD !  8 ;9 lD  4 Rp`P7 7 2 -x )h %47 0 p
`P  J
   `: <     i= m>    >    b?    
@    @ 1@    C@    @    ;A    A    A     B    B $B    B    C    5D    DD    PD    {D    D 7 7 2 -x )h %47 0 p
`P  J
 P 
  
     
    @
    `
    
    
    
    
 @E G     IH MI    I    BJ    J    J K    #K    oK    L    L    L    L    L M    M    N    O    $O    0O    [O    jO 7 7 2 -x )h %47 0 p
`P  J
   P nR     )S -T    T    "U    U    U U    V    OV    V    W    W    W    W W    X    Y    Y    Z    Z    ;Z    JZ 3 3h /d! +T  '4  
p  J
   
  
    @
    `
 Z Z     [    \    \    \    ]  T 4 p`J
  
 ] !^     ^ 6 6 1x -h )t %d !T 4  	  J
  
 ^ ^     x` 
 t d T 4 !   b Md H !  b Md H : :   x h 4 p> >   x h 4 pF F A <  x h d 4 p, ,x 'h d T 4
 rpe
 ed t	 T 4 2
 t d T 4  h t d T
 4 $ $d  T 4  p  J
  
 t u     `v !   pw w J !d dd T
 4 pw w J  h p# #T 4 
	p`J
  
      
 x x     y    y % %t/ !d. T- 4, *   J
    
 @
    `
 y .z     =z _z    z    z    z (
 (d $T  4  
p  J
  
     
 
    
 P{ {     {    {     { 
|    |    3|    Q| 
 
2PJ
    4	 
RpJ
               K @            
 8    
                 ~      9    E  
     -
    @
     
 
2PJ
 0  4	 
RpJ
 0             <L @           p
 8   P
                       I    U p
     }
    
      4 p!    * L !   *  L !# #  *  L ! 4  * L 
 
T 
	p`!     L !    ~ @M !# #   ~ @M ! 4   L 
 
RPJ
 `  R	p`P0J
 ` / &p`0J
 `               M             M @           `
 H   @           
 h           @
               
 І       <    n         !     
     
    2
     m
    
      d
 4	 Rp!   P i C !   
  4	 P i C ! 
 4	 P i C  d
 4	 
RpJ
        R 
 
RPJ
  7 7xB 3hC /d +4  p  J
              O             lO 	   k   
 H   	   k   
 H   
 
 
 0
    P
    p
    
    
    
    
    
 
          0
    P
    p
    
 
                     
   
     
     
 
          @
    `
 
                      l               )        Ɛ        &            v 	    
   9    ]        ϗ          
   Y 
   Ř             A    V            e     
   ş        5    m 
     
    
     
    
     
 
RPJ
 ` 7 7xB 3hC /d +4  p  J
 `             ,R             R 	   k   @
 H   	   k   p
 H   
 
 
 
    0
    P
           p
    
    
    
 
          
    
    0
    P
 
                     
   
    
    
 
           
     
 
                     Р \     }     ˡ     	                    צ 	    
               /    G     
    
   %    q                             
       P         p
     }
    
     M
    `
     B B x h d T 4 p h R0   T 4 	p`J
   9     | m m4 2pD D !x h d T 4 p!	 ! x h ( 0  J
   p
     
     
    
 й ɺ     ˺ v                 ػ      1 14$ ! p`P  J
   m         ]            ݾ  bP0  J
  " 
p`0J
                V @           
 X   0 {     6 
     
    -
     7E7h 3t ,d %4 C 
PJ
  @
     `
       P    v       4 p`P 4 p`P&
U&h  t d 4 SP   
R0J
 @         4
 
RpJ
 p 
     
    
     
      l    u    ~               #
 #h 4 
p	`PJ
   6                  !     W ! t   W  h 0( (h $T  4 
	p`J
   
  
    @
    `
            g          d 4
 
pJ
   
 
   <     u       d 4
 
pJ
 ` 0 l           #
 #4 
p	`PJ
  `      ]    v            % #
 #4 
p	`PJ
  
 
     
     
 P      I    b              
  T 4 	p`J
   @      a    {               
  T 4 	p`J
 P P      m                *  4
 
RpJ
  @
     `
    
    
        N    W         % %t !d T 4    J
             (     F  d 4
 
RpJ
 P 
     
                    4
 
RpJ
   
      
     @
    `
    
    
           2    @    T    `      h 
4 
Rp
 t d
 T	 4 R 4
 
RpJ
  
     
     
     
    @
     `
 p                                     4	 
RpJ
 @ 
     
    
    
     
     
    @
    `
       (    ]                           
R0J
 p   /     a ' 'd1 #T0 4/ * p  J
  p D     S    t                         ' 'd1 #T0 4/ * p  J
  
 
    
 
     
     
    @
 0          4    I    [    ~            A 
 
RPJ
   $
 $d 4 r
pJ
                 ^ @           `
 H   `      : `
     m
    
     
 
RPJ
 0  R	p`P0J
 0 / &p`0J
 0               _             _ @           P
 H   @           
 h           0
               
        ,    ^              
     
    "
     ]
    
     
 
RPJ
 ` 3
 3h /dC +4B : p  J
 ` O   O   R      ` 	   k   
 H   
 
     
     
    @
    `
    
    
    
    
     
 
    
    @
    `
    
    
    
    
     
     
    @
    `
    
    
    
    
     
     
    @
    `
    
    
    
     
 !    
 "    
    @
 $   `
    
 &   
 '   
 (   
     
     
 +   @
 +   `
    
 .   
    
 0   
 1    
 2    
    @
    `
    
 6   
    
 8   
 9    
 :    
    @
    `
 =   
 =   
    
 @   
     
     
 C   @
 D   `
 E   
    
 G   
    
 I    
 J    
 K   @
    `
 M   
               P       Q        >     V    }                            +    :    I    k     	           
 
        3    > 
   a         
                   "    q                                d    w                                                 C    O    ^                    "    3    \         % !   8 "   C #   f "    !             $    %    $        t &    '    (    )    (    '    &        *    +    ,    -    +   S     .    /    .       ? 0   U 1   h 2   z 3    2    1    0       :	 4   P	 5   e	    	 6   	 7   	 6   	    
 8   
 9   
 :   
 ;    :   * 9   6 8   E     <    =    >    ?   ! =        @    A   
 @   .
     B        C    D    E   	 F   , E   d D   p C        G    H    G         I    J    K    L    K   & J   2 I   >    i M    N    M            
     
 P   
     
 
RPJ
 @ . .h ! p`0  J
 @             |h    k    0
 H   
 
    
                 {             +         0
     =
    L
     
 
RPJ
 p . .h ! p`0  J
 p             Pi    k    
 H   `
 
    
               @          8    K         
     
    
     
 
RPJ
  ) )h % !t 4 	J
               $j 	   k h   P
 H           
     
    0
     `              I    ^    %     X P
     ]
    l
     
 
RPJ
  ) )h % !t 4 	J
                k 	   k h   
 H           
     
    
                   y        U      
     
    
      4
 
RpJ
   
     0
 P
                      n n4 2p bP0  J
 0 - -h )d %4 pJ
 0               Pl 	   k 8   p
 X             Q!     ! p
     ~
    
     3 3x$ /h% +dT 'TS #4R L 
p  J
  
     
     
    0
    P
    p
    
    
    
    
    
    0
    P
 `# #     #    #    Z$    g$    $    $    %    %%    K%    _%    %    %    % 	   %    Z' 
   g'    '    '    *    *    *    *     + 5 5x 1h
 -4'  p
`P  J
   p
 
    
    
 `+ ,     ,    -    @-    Q/    z/ D D ? : +x 'h d T 4 p^! ^ X R J	 B
 : 5 0
 +x 'h #d) #T' #4& #  p     h b  *
U*h &t "d 4 S
P  J
  
 P: 1;     n; ` `4
 d
 T rp d T 4 p 4 p`P 4  
p	`P  7U7h
 -! &  d 4 S	 P'
 'T 4 r
	p`J
  
     0
    P
    p
    
    
    
    
    
 @C pC     C    C    C    C    C    C    D    D    1D 
 t
 d T 4
 r d T 4
 Rp d 4
 
pJ
 ` 0
     P
     p
 J ;J     [J    J    EK (
 (d2 $T1  40 * 
p  J
  
 
    
    
 `K K     K K    K    L    L    L    L !   L CM q !
 T  x h	  d L CM q 
 
4 
 p  /
 /d1 +T0 '4. ( 
p  J
  
 0
    P
    p
 0O Q     BQ    Q    Q    R    R  d	 4 Rp(
 (d $T  4  
p  J
  
     
     
  T KU     zU    U    %V     ZV *
 *h
 &4&  
p	`P  J
  
 V aX     Y  4 RpJ
   0
     
  Z KZ    cZ     + "Rp`P0J
 P `
     
    
    
    
     
     
    @
    `
    
    
 Z Z    Z    Z    Z    [    [ 	   L[ 
   W[    a[    j[     s[    T 4 	p`J
  
 
     
     
    @
    `
    
    
    
    
 	    
 	   @
    p
 [ <\     _\    \    \    \    \    \    \    ]    ] 	   8] 
   D]    R]    i]  d
 4	 
RpJ
  
     
    
     
     
    @
    `
    
 ] ]    ]    ]    ]    ^    &^    3^    F^     j^  
R0J
  
     
    
     
 ^ ^     ^    ^    ^    ^    d6 44 2 p  J
  
 
      
    @
    `
    
  ` )`     @`    _`    n`    `    `    `    `     ) )h# %4P H 
p	`P  J
 @ 
 
     
    
    0
    P
    p
    
    
    
 a Ga     Ra    a    a    b    -b    Qb    b    b    b    c     /c Zc    {c    c     c c    %d    =d    d    d    e     0e ,	 ,4K B 
p`P  J
  
 
     
    
    0
    P
    p
    
    
    
 e e     e    e    f    yf    f    f    f    g    g    8g    Dg    g    g    g        T 4 	p`J
  
    @h ih     i &
  p
`P0J
  
 @  `  i cj     j    o  d
 4	 
RpJ
  
 p
  r r     r  d
 4	 
RpJ
 0
 
 r <s     cs % %t !d T 4    J
 `
 s t     t    t     t  d
 4	 
RpJ
 
 P
 u u     ev !   v v z !   v w z ! h	 v w z !F F ( #  	 4 v v z  x 
 0 04$  
p`P  J
 @
                        @    `     x x     y    1y     Xy y     y    y    {    {    |    N|    .}    `}     } 
 
2PJ
 p
 '
 'h 
p`0J
 p
              { 	   k      8                    } ~     a~    ~    ~    ~                    s s k c [ S K C > 9x 5h 14< !2 p`P  J
 
  0        ݁    a 
 
RPJ
 
    J
 
               } @           P H    Æ      P     ]    s      d 4 pJ
  
    V     n ! d2   } 
 T1 "x h 43 , 
p  )U)h  t d 4 S	 P:U:h
 6 (t d 4 S	 P 4 p`P 
 J
 0
  @        d 4 pJ
 `
                @    `                 	     
        @    `                       P     \    z                ђ    ݒ         	    
       $    E 
   Q    _                 #
 #t
 d T 4
 rJ
 
 Д       !    ŕ  ! 4  ŕ  (
 (d< $T;  4: 4 
p  J
 
 @ `                    X                Ԙ  BP0  J
 
 !	 !t2 d1 40 .   J
 
                 k `   H                       P     p p     ՙ     
         +          !    2    F     / /x h    d 4 2p R0J
 p
          d 4 2p bP0  J
 
 $ $d  4 
pJ
 
                              	   k 8    X   	   k @    X                @ `                      0    P    p                 `                    	       $ 
   3    Q    `    w              
       =    L    c p    u                                                 2pP0J
 
  4 
r	p`J
 
               @           @	 H           	      ٠              R @	     O	    	      4&   p`P  * *h" &G p`P0$ $d  T 4  p  J
 
 	 	    	 @ ٨         g    ܪ     !     v ( ! d   v ( 
 
4 
 p  $ $d  T 4  p  J
 @
 	 
 0
   N     f         Ʊ    T 4 	p`J
 p
 P
     p
     
    
    
  3     k    w    Ų    ۲         0 04$  
p`P  J
 
 
  0 @          8     &	 &T' "4%   	p`  J
 
      P     p                         D    S    {        >    J    Է            &     !    ͸ l !
 
h d  ͸ l  T 4
 Rp!   0 M  ! x 
h d
 0 M   T
 4 rp d
 4	 
RpJ
 
 @          d
 4	 
RpJ
 
 
 л <     c 
 
RPJ
 
 ! !4 pJ
 
               ` 	   k 8   ` H         ϼ `     m          d T 4 2p. .x *h &t "d T 4 
	J
 @
 P پ      
 
RPJ
 p
 5
 5x# 1h$ !J p`0  J
 p
    
         H 	   k    P H            
    0
    P
    p
    
    
    
 	   
 	              0 	             `        (            H             	   D 
    	       ,     
            	   S    ]    l    {     P     ]         i
 i4
 t
 d T rU U9 M: E; @< ;= 6> 1x? -h@ )t %d !T 4  	  J
 	
                    @    `                 	           +     C                        
    #    8 	   N 
   \ 	   h    w                                             h R0 P0  J
  

 Z ZG RH JI BJ =K 8L 3xM /hN +d '4  
p  J
  

     &   )       	   k   0 h           @     `                              @ 	   ` 	                             @    `                     0    P    p                        0    P     p !    "                      '    '     u                                 <    T 	    
            
   X                    <    T    {                         . 	                   P &                  	   6    n                     r                          !    "   * #   7 "   F !   U     d    s                     $                %   \     m o     > '   S (   j '    )    '        #%#
 t d 4
 #rP  J
 0

           	p`P0  J
 `

 0     P    p                             2    b                    	 ( (d $T  4  
p  J
 

       @    `        N     X    *    :    s          %
 %4 
p`PJ
 

                   P                       	   P 	   p   .     E    
        E    Y    |             	    
       l  d 4 
RpJ
  
                      # #h 
4 
p
 
RPJ
 P
 0 0x ,h 9 p`0J
 P
             t 	   Hl   P H                   0          5     k                H    W      P     ]         O O G ? : 5 0x ,h (d3 $T2  41 * 
p  J
 
         =     S    _                           P0  J
 
 $	 $d:  49 4 
p  J
 
              	   k h     h                                P             	     -    ;     Q                4    V    c    n      4
 
RpJ
 
        j !     $ !# #h G E TD   $  > 
p`0  	 d! T  4  p   T 4 rp`0 0x ,h	 (d $T  4  
p  J
 

         [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  J
 @

 @          2    H    a                     	    
       {    ~ 	 
    	     	 
   	    	    	    	    	    	    &	     Q	 0 0x ,h	 (d $T  4  
p  J
 p

 	 d	     	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  J
 

            @    `                              @ 
   ` 
    	 	     	    	    	    1	    	    ^	    	    	    	 	   		 
   
	    K	    N	 
   v	    	 
   d	    s	    	    	    	    	    	     !	 0 0x ,h	 (d $T  4  
p  J
 

  	 4	     	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  J
  
 	 	     	    	    	    	    b	    .	    	    P	    	 	   	 
   s	    	    .	 
   V	    h	 
   D	    S	    b	    q	    	    	    	      	 !    	  	  ! 4	  	  	  
 
d
 
Rp
 
4	 
Rp
 
rPJ
 0
 ;
 ;x/ 6h0 %b p`0  J
 0
                                        	   Hl   P X   	   Hl    X   	   Hl    X                      @    `                       
           0                                     `!	 !	     !	 r"	    "	 "	    "	    A#	    W#	    #	    #	    #	    &$	    r$	 	   $	    $	 
   %	    %	 
   6%	    %	    %	 
   %	    %	    #&	    2&	    &	    5'	    B'	    \'	    '	    (	    (	    2(	    d(	    p(	    (	    (	                        ]    j     u uA mB eC ]D UE MF EG @H ;xI 7hJ 34 # p`P  J
 
        @     `                          !     !    @! 	   `!    !    !    ! 
   ! 
    "     "    @"    `"    "    "  )	 d*	     z*	    +	    #+	    I+	    X+	    f+	    +	    +	    +	    +	    ,	    ,	    ,	    <-	 	   z-	 
   -	 	   -	    .	    D.	    P.	    m.	    0	 
   S2	    h2	    6	    6	    7	    (7	    L7	    ^7	    m7	 
   7	    7	    7	    8	    '8	    U8	    8	     8	  4	 
RpJ
  
 "     "     #     #    @#    `#    #                      09	 X9	     `9	    h9	    p9	    x9	    9	    9	    c:	 
 
2PJ
 P
  4 
	p`J
 P
                @           # 8   :	 :	     ;	 #     #    #     O O G ? : 5 0x ,h (d3 $T2  41 * 
p  J
 
 ;	 
<	     >	 >	     >	    >	    ?	    "?	     8?	    D?	    g?	    y?	 O O G ? : 5 0x ,h (d3 $T2  41 * 
p  J
 
 #     #    $     0$    P$ ?	 J@	     B	 C	     !C	    -C	    PC	    bC	     xC	    C	    C	    C	 5 5xx 1hy -4  p
`P  J
 
 p$ $    $    $    $    %    0%    P%    p%    % 	   % 	   % 	   %    & 
   0&    P&    p& 
   p&    &    &    &    &    &    '    0'    P'    P'    p'    '    '    '    '    (     0(     P(     p(     (     (     (     (     ) (   0) (   P) *   p) *   ) *   )    )    )    * 
   0* 	   P* 2   p*    *    *    *    * +  D	 D	     D	    D	    D	    E	    E	    EE	    ]E	    E	    E	 	   E	 
   E	 	   E	    F	 	   hG	    G	 
   G	    G	    G	    H	    kH	    H	    H	    ZI	    pI	    I	    I	    J	    J	    K	    K	    K	     K	 !   K	     5L	 "   PL	     L	 #   L	     L	 $   L	     M	 %   M	     N	 &   N	     )O	 '   AO	 (   ZR	 )   R	 *   XS	 +   S	 ,   T	 -   T	 *   U	 (   U	     U	    U	    U	    U	 .   U	    
V	 /   V	    !V	 0   0V	    8V	 1   GV	 
   OV	    ^V	 2   V	 3   V	 2   V	 	   V	 4   :W	    HW	 5   W	    W	 6   W	    X	 7   `X	    nX	 8   X	  BP0  J
 
 . . )x %h !t d 4    J
 
               l 	   k (   0+ H              +    +  Y	 Y	     Z	 0+     >+    P+    d+    +    +    +      BP0  J
 @
 . . )x %h !t d 4    J
 @
               D 	   k (   + H              p,    , Z	 [	     m\	 +     +    ,    $,    F,    S,    ^,     1 1 , 'x #h T 4  p`  J
 p
 , \	 ]	     ]	  BP0  J
 
 . . )x %h !t d 4    J
 
               l 	   k (   , H              P-    p- P^	 
_	     _	 ,     ,    ,    -    &-    3-    >-      BP0  J
 
 . . )x %h !t d 4    J
 
               D 	   k (   - H              .    0.  `	 `	     a	 -     -    -    -    -    -    -      BP0  J
  
 . . )x %h !t d 4    J
  
                	   k (   P. H              .    . a	 b	     c	 P.     ^.    p.    .    .    .    .      BP0  J
 0
 . . )x %h !t d 4    J
 0
                	   k (   / H              /    / c	 }d	     `e	 /     /    0/    D/    f/    s/    ~/     !   e	 f	  ! d e	 f	   t	 T 4 2 4	 
RpJ
 `
 f	 f	    f	    g	    g	    g	    "g	     -g	 / /h2 +dn 'Tm #4l f 
p  J
 
 / /    0    00    P0    p0    0    0    0    0 	   1 	   01 Pg	 g	     g	 g	    h	    1h	    Wh	    h	    h	    h	    i	    j	    )k	    Mk	    k	 	   k	 
   k	 	   jm	    {m	 	   m	    m	    m	    n	 $
 $T  4 r
	p`J
 `
 `n	 n	      4 r
p	`PJ
 
 o	 o	     $
 $T  4 r
	p`J
 
 pp	 p	      4 r
p	`PJ
 
 P1 q	 q	     Y Y K 'x h d T 4 p, , 'x #h
  
	p`P0J
  
 1     1 v	 v	     w	    >z	     Jz	 ]z	    ~	     ~	  d T 4 pJ
 p
 1 ~	 ~	     	 / /x' *h( %4[ R 
p`P  J
 
 1  	 9	     p	 . .x *h &T3 "42 * 	p`  J
 
  2 	 j	     	 + +x! 'h" #TO 4N F 	p`  J
  
  2 	 p	     	  d8 47 4 p  J
 0
 @2  	 	     	 '
 'T #4 
	p`J
 `
 `2     2 	 Ώ	     2	    	  h  0  J
 
 2 @	 	     	 8 8& 3x' /h( "S p`P0J
 
 2     2      3      3     @3     `3     3     3    3 	 S	     	    	     ;	    I	     	    (	     w	    	     	    	     :	    H	     m	    	    	    	     	 . .x *h &t "d T 4 
	J
  
   	 y	     )	 
 
RPJ
 P
 5
 5x# 1h$ !J p`0  J
 P
    
         0 	   k    5 H   3  4     4    @4    `4    4    4    4    4     5 	    5 	          @5    `5 	       `	 P	     ٜ	    A	    	    O	    	    	    	    	    q	 	   		 
   ʡ	 	   ֡	    	    w	 
   	    	    	 	   	    	     	    *	    6	 5     5    5      4 Rp`PJ
 
 p	 	     b	  4 p`PJ
 
 5     6 	 	     	    	 
 
RPJ
 
 0 0x ,h 9 p`0J
 
             T 	   Hl   6 H   06            P6    p6         	 E	     {	    	    	    	    X	    g	     	 6     6    6     9 9
 4 /x +h 'd) #T( 4& " p  J
 @
  7      7     @7     `7    7    7 	 G	     	    	     	    	     ì	    	    	    	    	    Э	     -	 !   p	 	  !$
 $h $ , T+ 4* p	 	   % 
	p` d2 41 . p  J
 p
 7  	 F	     T	 
 
rPJ
 
 ;
 ;x3 6h4 %j p`0  J
 
             ط             ķ              	   Hl    9 X   	   Hl   8 X   	   Hl    8 X   7         @8    `8    8    8                  8    9 
   09    P9    p9                  9    9     :     :    @: `	 	     	 r	    	 	    	    A	    W	    	    	    	    &	    r	 	   	    Ϸ	 
   	    	 
   6	    	    Ҹ	 
   ޸	    	    #	    2	    	    5	    B	    \	    	    	    	    2	    d	    p	    	    ϻ	  8     
8    48     8    8     9    9     u uC mD eE ]F UG MH EI @J ;xK 7hL 34 # p`P  J
 
 `:     :    :    :    :     ;     ;    @;    `;    ; 	   ;    ;    ;     < 
    < 
   @<    `<    <    <    <    <  	 d	     z	    	    #	    I	    X	    f	    	    	    ;	    	    	    ۿ	    	    3	 	   q	 
   	 	   	    	    5	    A	    X	    	 
   C	    X	    	    	    	    	    <	    N	    ]	 
   	    	    	    	    	    E	    	     	 , , 'x #h
  
	p`P0J
  
  	 \	     h	    	     	 	    	     	 , ,h  
	p`P0/ /h3 +dp 'To #4n h 
p  J
 0
  =  =    @=    `=    =    =    =    =     >     > 	   @> 	   `> 	 "	     ;	 [	    	    	    	    	    	    +	    i	    	    	    	    	 	   c	 
   p	 	   	    	 	   
	    	    ]	    	 8 8& 3x' /h( "S p`P0J
 `
 	 S	     	    	     ;	    I	     	    (	     w	    	     	    	     :	    H	     m	    	    	    	     	 +
u+h s% 
	p`0P  J
 
 > 	 	     	  d T 4
 rpJ
 
 	 D	     U	 !   h     !  t"  T#  4$ 	 	  !I Ih 9  /! t" T# 4$ 	 	   % ` 4	 
RpJ
 
 > > p	 	     	    	 $
 $d  T 4 pJ
  
 > P	 	     +	 #
 #h T 4 p`J
 P
  ?      ? `	 	     '	    	     	 / /	 *x
 &h "4#  
p`P  $
 $T 4
 R
	p`J
 
 @? `?    ?    ? 
 
     [
    
    
    
 
 
RPJ
 
 ? ? : 5x 1h !, p`0  J
 
 	   	   
      `    k   @ H   ? ?     @     @    @@    `@    @    @    @               0
 
     
    
    
    9
    
    x
    
    ,
    t
    
    
    
    
 .
    
 	   
    
    
    
    
    	
 @     @ 
   @     C C ; 6 1x -h )4UJ
p	`P  J
 
 A     0A    PA    pA     pA    A    A    A    A    A    B 
   0B 
   PB    pB    B    B    B    B    C    0C    PC    pC    C    C    C    C    D    0D    PD    pD    D    D    D    D !   D "   E    0E    PE %   pE    E    E    E )   E *   F *   0F )   0F -   PF )   pF    F     F )   F 2   F 3   G 4   0G 4   PG 3   PG 7   pG 7   G 9   G :   G :   G 9   G =   H >   0H >   PH =   PH A   pH B   H B   H D   H D   H B   I B   0I H   PI H   pI A   I =   I 9   I 3   I    J     0J 7   PJ Q   pJ Q   J 7   J T   J 7    K V    K W   @K W   `K V   `K V   K 7   K \   K \   K 7    L _    L 7   PL a   pL b   L b   L a   L a   L 7   L g   M g   0M 7   PM j   pM j   M 3   M    M     M 7   N p   0N 7   PN r   pN 3   N    N     N r   N r   O r   0O r   PO r   pO r   O r   O r   O r   O r   P r   0P r   PP r   pP    P 3   P    P     P p	
 	
     	
    /

    S

    

    v
 	   
 
   
    {
    
 
   
    
    
    6
    N
    a
    p
    
    
    
    
    
    
    '
    5
    
    
    
    
    
    Q
 !   2
 "   A
 #   b
 "   w
 !   
 $   
    
 %   
 &   
 %   
    
 '   
    
    

 (   "
 )   
 +   
 -   G
 .   h
 -   
 /   
 )   
    
    
    *
    b
    
 
   
    
 0   
    
 1   
     
 !
 )   2
 2   C
 3   
 5   
 7   
 8   (
 9   
 ;   4
 =   X
 ?   
 A   
 B   
 C   
 D   -
 E   @
 D   x
 F   
 D   
 B   x
 G   
 H   
 I   
 H   
 J   
 H   
 B   
 K   
 A   
 L   
 =   
 M   
 9   
 7   
 N   #
 3   +
 2   :
 )   I
    
    
    
    
    :
 
   F
    ~
 O   
    
 P   
     
 
 7   '
 Q   !'
 R   7'
 Q   o'
 S   '
 Q   '
 7   '
 T   '
 U   (
 V   (
 X   (
 Z   )
 [   *
 V   *
 7   .
 \   .
 ]   .
 \   /
 ^   </
 \   K/
 7   /
 _   /
 `   /
 a   I0
 c   |0
 e   1
 f   1
 a   1
 7    3
 g   3
 h   &3
 g   ^3
 i   |3
 g   3
 7   3
 j   5
 k   5
 j   6
 l   6
 j   6
 7   *7
 m   97
 3   A7
 2   P7
 )   _7
    7
    7
    7
    8
    N8
 
   Z8
    8
 n   8
    8
 o   8
     8
 8
 7   ?:
 p   N:
 q   q:
 p   :
 7   :
 r   :
 s   S;
 r   b;
 7   ;
 t   ;
 3   ;
 2   ;
 )   ;
    ;
    <
    ;<
    s<
    <
 
   <
    <
 u   <
    =
 v   =
     =
 2=
 r   =
     =
 r   =
 w   .>
 r   T>
 x   >
 r   >
 y   ^?
 r   ?
 z   ?
 r   @
 {   @
 r   @
 |   &A
 r   LA
 }   B
 r   ;B
 ~   C
 r   *C
    C
 r   C
    D
 r   D
    JE
 r   pE
    F
 r   F
 7   8F
    GF
 3   VF
 2   eF
 )   tF
    F
    F
    F
    +G
    cG
 
   oG
    G
    G
    G
    G
     G
 G
 r   G
    	H
    ,H
    PH
 H
       J
  
 p
     
 @I
 I
     I
    I
     I
  B  
 b  J
 
 Q W W     W 
 b  J
 
 0Q W X     )X 
 b  J
 
 PQ @X tX     X 
 b  J
 
 pQ X Y     Y 
 b  J
 @
 Q 0Y dY     yY 
 b  J
 p
 Q Y Y     Y  h b  !   0\ B\ 
 ! t 0\ B\ 
 !   \ \ 
 ! t \ \ 
 !   \ \ 
 ! t \ \ 
 !    ] 2] 
 ! t  ] 2] 
     20P
    SK
 K
 Q       t
 T	 4 2 t
 d	 4 RP
    N
 O
 Q O
 N
 O
 R     	 4
 rp`P
    ;P
 UP
 -R UP
  bp`0  P
    P
 P
 lR     	 B  P
    Q
 R
 R R
 
 
4 
2p                                  0                 k            Б                 k            J
                 p     x                      0                     l         @   P                  l         @                    p                         (  0                     l         @                    p     p                     0                 p                           0                     pl         @                    p                         0  0                     Hl         @                    P     x                     0                 l         @                    P     (                     P                          P                          P     P                                                     p                                                p                           0                      q         @                     H 0                     pq         @                    pn            J
                  0                     q         @                    k                              ( 0                     r         @   `                 @p            K
                p  0                     m         @                     0                     xm         @                      0                     Hm         @                   @ 0                 `r         @   p                                             0  8                                             Ы                          h   '                  @       (   !                 m     h                                                         0  8                                                @                          h   `<                 е     0                    h     0                                         X                              @    >                          (   !                 k (          Б                 k (          J
                 m     @                                x                          0                                p         X                    X         @   >                 k (                           0     H                        0  8                                                P                           h   @=                                          8 `  H 0                                               h                    `         P   X                 @n         (                     (       (   !                 m     P                                                     `  0  0  8                                                                          h   Pz                                           8 p  0  8                                                                            h   {                 p                             0  8                                                                          h                    o         @                         X                       0  8                                С                              p         h   p                   d          " @`           b @           `                          |     f     V     <                        
     
     h
     ,
               :               ~     ,     
     
     :
     	     	     d	     (	                    v     (               R     
               @               z     r               R                    :          h                    L     *                 ^                            D          d     \                               @          F                    4          2          |               V               d                                      z     l     `     R     @     6     .                                                       l     `     N     <                                        |     p     L     0                                   z     t     l     f     `     Z     R     L     F     >     6     .                  j     P     @     "                                             l     ^     J     <     *     
                                             h     Z     F     2                                              z     d     L     &                                        |     l     X     J     0                                                  x     j     T     @     ,                                                  h     X     D     .                                        n     \     H     4                                                  h     T     F     2                                             r     V     :                                                  h     X     >     ,                                        6     z                                        p              PyErr_Format  0 PyCObject_AsVoidPtr  PyExc_RuntimeError  6 PyCObject_Type   PyExc_AttributeError  	PyObject_GetAttrString   PyErr_SetString  PyExc_ImportError CPyImport_ImportModule  PyErr_CheckSignals  PyObject_GetAttr  _PyList_Append  PyExc_ArithmeticError  PyExc_OverflowError  PyExc_IndexError   PyExc_IOError  PyExc_ValueError   PyExc_TypeError  PyExc_MemoryError  PyErr_Occurred  _Py_NoneStruct   PyBaseObject_Type SPyInt_FromSsize_t PyObject_GC_Track PyObject_GC_UnTrack P PyCode_New  mPySlice_New PyTuple_Pack   PyExc_NameError  PyEval_EvalFrameEx  !PyFrame_New _PyThreadState_Current   PyEval_EvalCodeEx  PyDict_Next PyTuple_New _Py_CheckRecursiveCall  _Py_CheckRecursionLimit  PyDict_Size  PyExc_SystemError PyObject_Call / PyCFunction_Type  -PyFunction_Type PyUnicodeUCS2_Decode  PyUnicodeUCS2_FromUnicode } PyDict_GetItem  PyObject_CallMethodObjArgs  WPyInt_Type  ,PyUnicode_Type  PyString_Type 2PyGILState_Release   PyErr_WriteUnraisable PyString_FromString  PyErr_PrintEx 0PyGILState_Ensure uPyString_AsString  PyDict_SetItem  _PyString_Eq  PyUnicodeUCS2_Compare PyType_IsSubtype   PyExc_BaseException  PyErr_NormalizeException  PyTraceBack_Type  PyObject_GetItem   PyErr_Clear  PyErr_ExceptionMatches  PyTuple_Type  kPyList_Type PyObject_RichCompare  PyFloat_Type  PyLong_Type _Py_ZeroStruct  _Py_TrueStruct  PyMethod_Type PyObject_CallFunctionObjArgs  QPyInt_FromLong   PyDict_New  PyModule_GetDict  ePyList_New  PyObject_SetAttr  PyObject_Not  _PyObject_GetDictPtr  PyMem_Realloc PyMem_Malloc  ~PyString_FromFormat PyTraceBack_Here  ~PyLong_FromUnsignedLong PyObject_IsSubclass  PyErr_GivenExceptionMatches N PyClass_Type   PyObject_SetAttrString  PyType_Ready  7PyImport_AddModule  UPySequence_GetItem   PyExc_StopIteration  PyErr_SetNone _PyObject_CallFunction_SizeT   PyExc_GeneratorExit PyObject_CallObject 	 PyArg_UnpackTuple PyObject_GC_Del PyObject_ClearWeakRefs   PyErr_WarnEx   PyExc_RuntimeWarning  IPyRun_StringFlags  PyDict_SetItemString  PyObject_SelfIter PyObject_GenericGetAttr QPy_GetVersion PyOS_snprintf APyImport_Import PyObject_Hash PyString_FromStringAndSize  PyString_InternFromString PyUnicodeUCS2_DecodeUTF8  v_PyByteArray_empty_string vPyString_AsStringAndSize  & PyByteArray_Type  PyObject_IsTrue LPyInt_AsSsize_t PyNumber_Index  qPyLong_AsSsize_t  PyObject_GetIter  PyFloat_FromDouble  PyFloat_AsDouble   PyDict_Type aPySequence_Tuple   PyExc_AssertionError  "PyObject_Size `Py_OptimizeFlag 
 PyBaseString_Type mPyLong_AsLong rPyLong_AsUnsignedLong sPyLong_AsUnsignedLongLong _PyObject_GC_New  PyNumber_Add  PyObject_IsInstance !PyObject_SetItem  PyNumber_Subtract  PyExc_Exception  PyExc_NotImplementedError . PyCFunction_NewEx UPy_InitModule4_64 PyUnicodeUCS2_FromStringAndSize  PyErr_SetObject  PyErr_Restore  PyErr_Fetch python27.dll  o??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z  _??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 
?replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0PEBD@Z  	?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB ?find@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z  t??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z i ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBDAEBV10@@Z ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z  ?find_first_of@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z e ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@0@Z  g ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@PEBD@Z  ??$?MDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  ]?_Lock@_Mutex@std@@QEAAXXZ  ?_Unlock@_Mutex@std@@QEAAXXZ  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  , ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  - ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z  ?endl@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z   ??$?6DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@0@AEAV10@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z  ?swap@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEAV12@@Z \??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ O_LNan ??_D?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  Y?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??0?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z  G_Inf  v??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD_K@Z y??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 7?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?uncaught_exception@std@@YA_NXZ Z?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z  ??_D?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ ?str@?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z  d??0?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z $??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  #??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z z??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z N_LInf j??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ !
?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z +
?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  j?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ  ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ &?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z ?_Xsgetn_s@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_K_J@Z  )?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  :?flush@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z c?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z [_Nan  ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  L?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z ?exceptions@ios_base@std@@QEAAXH@Z  @??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z O?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z  `??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ^??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  J?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ  
?quiet_NaN@?$numeric_limits@N@std@@SANXZ  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  d?close@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?substr@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV12@_K0@Z  P?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??_D?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ  	?open@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXPEBDHH@Z  ??0?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAA@XZ MSVCP90.dll {atan  |atan2 ceil  cos exp floor log pow sin sqrt  <tan _time64  ??0exception@std@@QEAA@AEBQEBD@Z  E ?what@exception@std@@UEBAPEBDXZ  ??1exception@std@@UEAA@XZ  ??3@YAXPEAX@Z 	 ??0exception@std@@QEAA@AEBQEBDH@Z c __CxxFrameHandler3   ??0exception@std@@QEAA@XZ 
 ??0exception@std@@QEAA@AEBV01@@Z  _purecall 
 ??1bad_cast@std@@UEAA@XZ   ??0bad_cast@std@@QEAA@PEBD@Z  I _CxxThrowException  malloc  free  _invalid_parameter_noinfo  ??0bad_typeid@std@@QEAA@PEBD@Z   ??1bad_typeid@std@@UEAA@XZ  l __RTDynamicCast  ??2@YAPEAX_K@Z  memmove_s  ??0bad_cast@std@@QEAA@AEBV01@@Z =_errno  memcpy  memcmp  log10  ??0bad_typeid@std@@QEAA@AEBV01@@Z clock MSVCR90.dll Y __C_specific_handler  _unlock  __dllonexit 7_encode_pointer =_lock _onexit -_decode_pointer N_malloc_crt _initterm _initterm_e 8_encoded_null  _amsg_exit  Z __CppXcptFilter C ?terminate@@YAXXZ 8 ?_type_info_dtor_internal_method@type_info@@QEAAXXZ { __clean_type_info_names_internal  Sleep  DisableThreadLibraryCalls QueryPerformanceCounter GetTickCount  GetCurrentThreadId  GetCurrentProcessId GetSystemTimeAsFileTime KERNEL32.dll            EXZ                 @ 5   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435.pyd initstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435                                                                                                                                                    H   X   h      r                  Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

       X              P            Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest

        Note
        ----
        This is currently an alias for the `traceplot` method.
                  Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
                  Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
            parameter (or quantile) name(s)
        permuted : bool
            If True, returned samples are permuted. All chains are merged and
            warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are discarded. If
           `permuted` is True, `inc_warmup` is ignored.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

              
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                     Transform parameters from defined support to unconstrained space                    P                     p%                      %                                                  0   p                       @                                                      ,                          L      @                   T   0    P                    \                          h                             x      @                                                 `                                                                                                                          (                                                             !                                             p               @?                                                   P6   6                                                   E&        &    P'                                    3           @4                                                           %                                                                                       p                      w                      w                                   (              "   8   0           #   @   `                  P                     X   /          @'   h   2           -   x             .                p/      `          p0                 2      04          p3                            0                                                               0                     H   Pf                  `   y                  x   `f                     y                                                               y                     y                                                                          e                           $   0    P                    D                          0                             @                           P   `                        \       0                    d                           p   p                                @                                                                                                               +                                                                                                         h               -                                              =   @>                   p                           E&        0)     *                                    P8           <                                                       pf                                                                                                          0                   ,                                                                                                                    A&             -     .                                                                                                                    `,                                                                                                                               /                                                                                                                    A&             /                                                                                                                            p.                                                                                                                              0                                                                                                                    A&             P1    1                                                                                                                    0                                                                                                           `                   2                                                                                                                    A&             `3                                                                                                                             2                                                                                    4    k                 pq               l   m           x                                             l                                H                                                                      u     u               (   u    u    8                                                                                  X   p               s                                                                                                                    A             r                    8                m    0F   F   0G                                                                                                                           0t            iW
@      <                            `                               ċ                              (                             &                      Ƚ      &                                                 @                           P                              ؖ   <                         (   #                      x                                                         t                                                   X   x                           ̋                        8                           h      $                      0   |                                                   P                              @                               
                     ؿ      	                           (                            A                                                                            x                              (                        0                                                       X   8                        @                               H                                                                               (   X                        x      	                        (                              
                        H                        `                           p   x   
                        $                                                   й   ԋ                                                                              h                                                             t                                                    @                               	                        ,                                                   h                           ȿ                              h                           (   
                     8                              ܋                                                         
                     (   4                        `   <                              L                      P   D                                                    H      
                      p   L                           Ȏ   	                         X                            H                        h                           8   T                           8   
                                                   \                        0                                                      (                                 
                     p                              d                                                   8      
                                                   ȏ   
                     P   l                                                    x                               ؏   
                     `                              x   
                        ؎   
                     (   `                        غ   H   
                     8      	                        (                        о      	                     0   X   
                     (   t                        X      
                     ؽ                                                            .                                                                               Ȑ                        0      
                     H                                  	                     @                                 
                                                                               0                        @                           x      	                        Ȓ                        p   8   
                           
                     н                                                      ȹ                           p   ؐ                        `                           X                           X                           (                                  "                         H                                                   H       x                      `                              8   '                      0      "                                                     h   
                        Č                                                   Ⱦ   $                        @   P                           ؒ                                                         	                     (   ,                           ̌                                                   H   Ԍ                                                      (                        X   ȓ                                                      x   
                                                   ܌                            X                            X                        0   `                        8                              (   
                                                                               0                           8                        H   8   
                        h                        h   (   	                        h                        (   p                           x                        ع   ȑ                        H   4                           <                        h                           X                           H                              p                           Д                              ?                     @   8   	                                                p                                  
                     8                              x   	                     P   H   	                        H   
                        T                        0                              H   	                                                x                              X   
                            
                        ؑ                           h   
                                                   X   	                      h   `   %                      P   \                                                   @   d                                                     P                                                                                     č                           ̍                                                       ԍ                                                      l                           h   	                     к                                                                   
           .?AVbad_exception@std@@ 
           .?AVexception@std@@     
           .?AVbad_alloc@std@@     
           .?AVlogic_error@std@@   
           .?AVdomain_error@std@@  
           .?AVinvalid_argument@std@@      
           .?AVlength_error@std@@  
           .?AVout_of_range@std@@  
           .?AVruntime_error@std@@ 
           .?AVoverflow_error@std@@        
           .?AVunderflow_error@std@@       
           .?AVrange_error@std@@   
           .?AVvar_context@io@stan@@       
           .?AVclone_base@exception_detail@boost@@ 
           .?AVsp_counted_base@detail@boost@@      
           .?AVbad_lexical_cast@boost@@    
           .?AVbad_cast@std@@              
           .?AVbase_writer@writer@interface_callbacks@stan@@       
           .?AVvari@math@stan@@    
           .?AVrounding_error@math@boost@@ 
           .?AVbase_adapter@mcmc@stan@@    
           .?AVbase_mcmc@mcmc@stan@@       
           .?AVbase_adaptation@mcmc@stan@@ 
           .?AVfixed_param_sampler@mcmc@stan@@     
           .?AVchained_var_context@io@stan@@       
           .?AVbad_typeid@std@@    
           .?AVfailure@ios_base@std@@              
           .?AV?$var_context_factory@Vpy_var_context@io@pystan@@@var_context_factory@interface_callbacks@stan@@            
           .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@            
           .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@             
           .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@        
           .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@           
           .?AU?$located_exception@Vexception@std@@@lang@stan@@            
           .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         
           .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         
           .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@        
           .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      
           .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      
           .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@     
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@              
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@  
           .?AVwindowed_adaptation@mcmc@stan@@     
           .?AVstepsize_adaptation@mcmc@stan@@     
           .?AVstepsize_adapter@mcmc@stan@@        
           .?AVstream_writer@writer@interface_callbacks@stan@@                        
           .?AV?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     
           .?AV?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     
           .?AV?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    
           .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       
           .?AV?$unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                
           .?AV?$dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      
           .?AV?$adapt_unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           
           .?AV?$adapt_unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$adapt_diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           
           .?AV?$adapt_diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$adapt_dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@          
           .?AV?$adapt_dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                
           .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@         
           .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@     
           .?AVexception@boost@@   
           .?AUbad_alloc_@exception_detail@boost@@ 
           .?AUbad_exception_@exception_detail@boost@@     Ⱦ           Ⱦ   H           
           .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@         
           .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@  
           .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@      
           .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       
           .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@          
           .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@               
           .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@  
           .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@              
           .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@   
           .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@    
           .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@             
           .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@        
           .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@          
           .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@        
           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@   
           .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@ 
           .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@ 
           .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@          
           .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@           
           .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@    Ⱦ           Ⱦ                                       (   (         (            0         0   
           .?AVsample@mcmc@stan@@  Ј   
           .?AVps_point@mcmc@stan@@        
           .?AVunit_e_point@mcmc@stan@@    
           .?AVsum_values@pystan@@ 
           .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              
           .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              
           .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      
           .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    
           .N      
           .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@       
           .?AVprob_grad@model@stan@@      
           .?AVstepsize_var_adapter@mcmc@stan@@    
           .?AVstepsize_covar_adapter@mcmc@stan@@  H   U   Z   
           .?AVop_vv_vari@math@stan@@      
           .?AVop_vd_vari@math@stan@@      
           .?AVadd_vv_vari@?A0x0adf100e@math@stan@@        
           .?AVadd_vd_vari@?A0x0adf100e@math@stan@@        
           .?AVmultiply_vd_vari@?A0x0adf100e@math@stan@@   
           .?AVop_v_vari@math@stan@@       
           .?AVstored_gradient_vari@math@stan@@    
           .?AVpartials_vari@?A0x0adf100e@math@stan@@      
           .?AVexp_vari@?A0x0adf100e@math@stan@@   
           .?AVsum_v_vari@math@stan@@            ࿰               8	   	         @
         
         @           
           .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x0adf100e@math@stan@@             X            (   X            
           .?AVdiag_e_point@mcmc@stan@@    
           .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@     
           .?AVanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@ P   
           .?AVcovar_adaptation@mcmc@stan@@        
           .?AVvar_adaptation@mcmc@stan@@  
           .?AVpy_var_context_factory@io@pystan@@  
           .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@    
           .?AVpystan_sample_writer@pystan@@          
           .?AVpy_var_context@io@pystan@@  
           .?AVdense_e_point@mcmc@stan@@   
           .?AVarray_var_context@io@stan@@    `
   P   `   8           P   `           	
   d   d   
   
   
   
   
   x
   
   
   
   
             й   @           u      
           .?AVtype_info@@ 2-+  ] f                                                                                                                                                                                                                                                                                                          U  i
 U    i
     (i
   4  <i
 4  t  Pi
 t    di
     xi
     i
   $  i
   t  i
     j
     j
     Hk
     dl
    q  $n
     ,n
    m  4n
     @n
    Q  Hn
     Pn
   1  \n
 `    dn
     pn
 @    xn
     n
    q  n
     n
 @    n
     n
    q  n
     n
    Q  n
     n
   1   n
 `      n
    !  n
 @!  !  n
 !  !  o
  "  m"  o
 "  "  o
  #  M#   o
 `#  #  ,o
 #  -$  4o
 @$  $  @o
 $  
%  Ho
  %  q%  To
 %  o&  \o
 &  >'  do
 P'  (  to
 (  )  |o
 0)  *  o
  *  +  o
 +  L,  o
 `,  ,  o
 ,  -  o
 -  -  o
  .  g.  o
 p.  .  o
  /  /  o
 /  /  o
 0  0  o
 0  ;1  p
 P1  1  p
 1  2   p
  2  2  (p
 2  K3  0p
 `3  3  <p
 3  ;  Lp
 ;  <  Tp
 <  *=  `p
 0=  d?  tp
 p?  9@  p
 @@  @  p
  A  sA  p
 A  A  p
 A  B  p
 B  B  p
 B  B   q
 B  B  q
 B  RC  q
 RC  C  4q
 C  /D  Pq
 D  D  `q
  E  iE  hq
 E  LF  pq
 F  F  |q
 F  F  q
 F  kG  q
 kG  G  q
 G  G  q
 G  G  q
 G  G  q
  H  rH  r
 H  H  r
 H  K  r
 K  L  4r
 L  L  <r
 L  L  Pr
 L  L  dr
 L  M  tr
 M  N  r
 N  "O  r
 0O  tO  r
 tO  O  r
 O  O  r
 O  YQ  r
 R  S  r
 S  :T  r
 @T  T  s
  U  U  s
 U  %W  s
 0W  W  0s
 W  =X  Hs
 =X  X  \s
 X  Y  ls
 0Y  Z  xs
 Z  2[  s
 @[  [  s
 [  \  s
 \  \  s
 \  \  s
 ]  ^  s
  ^  J_  s
 P_  __  t
 p_  _  t
 _  _  t
 _  _  $t
 _  _  ,t
 _  _  4t
 `  `  <t
 0`  ?`  Dt
 `  `  Lt
 `  a  Xt
 a  a  |t
 a  a  t
 Pb  b  t
 b  c  t
  d  Ad  t
 Pd  yf  t
 yf  wg  t
 g  g  t
 @h  ^h  t
 ph  i  t
 i  i  u
 i  Dj  u
 Dj  Yj  (u
 Yj  bj  <u
 pj  j  Lu
  k  k  Xu
 k  l  `u
 l  l  tu
 l  l  u
  m  m  u
 m  m  u
 m  n  u
 n  n  u
 n  o  u
 o  o  u
 o  p  u
 p  [q  v
 pq  q  v
 r  r  $v
 r  s  4v
 s  "t  @v
 0t  Qt  Hv
 Qt  t  Pv
 t  t  pv
  u  }u  v
 u  
v  v
  v  v  v
 v  w  v
  x  x  v
  y  Ay  v
 Py  "z  v
 0z  yz  v
 z  |  v
 0|  |  v
 |  E}  v
 P}  }   w
 }  }  w
  ~  *~  w
 *~  ~  w
 ~  ~  ,w
 ~  ~  @w
 ~    Pw
     Xw
     lw
     w
   p  w
 p    w
   (  w
 0    w
   R  @x
 `  5  Xx
 @    x
 Є    x
     x
   P  x
 `  o  x
 o    x
     y
   %  (y
 0    Py
     dy
    q  ly
   6  ty
 `    y
 0    y
   k  y
   ђ  y
   2  y
 @  ߓ  y
   ]  y
 p    y
     y
     y
 @    y
     y
    R  y
 `     z
 0  }  z
     z
   ]   z
 p    ,z
     4z
     @z
      Hz
   )  Xz
 0  ^  pz
 ^    z
     z
   Ϣ  z
 Ϣ    z
     z
     {
     ,{
   '  8{
 '  C  `{
 P    p{
      {
   ȱ  {
 ȱ    {
     {
    q  {
 q  N  {
 N  ܸ  |
     |
   `  (|
 `  |  H|
   @  X|
 P  _  t|
 _    |
     |
   x  |
     |
     |
   D  }
 D  {  0}
 {    D}
   !  T}
 P    `}
      h}
     }
   
  }
    q  }
   [  }
 p    }
   =  }
 P    }
     }
 0    }
     }
   a  }
      ~
   A  ~
 p    ~
   !   ~
 P    (~
     4~
 0  }  <~
     H~
   ]  P~
 p    \~
   M  d~
 `    |~
     ~
     ~
     ~
      
 P    $
      0
   K  <
     H
 P    T
      `
   K  l
     x
 0    
   [  
     
 @    
   k 
  s 
   
   
   
   
    
   
  X $
 ` 
 ,
 
 
 H
 
 G P
  ' d
 ' F l
 F x 
 x  
  *
 
 *
 I
 
 I
 y
 Ā
 
 
 ܀
 
  
  8 
 8 \ 
 p   
   (
  ( <
 ( L T
 `  d
   l
   
  < 
 P  
   
   ā
  , ܁
 @  
   
   
    
 0  0
   8
   L
    d
   
   ؂
    
    
    
   L
    $
 ! i" 
 p" " ȅ
 " B% ԅ
 B% [% 
 % %  
 % k& 
 & ' 
 @' ' 
 ' ' $
 '  r 0
  r r \
 r :r x
 :r \r 
 \r r 
 r 	t 
 t "t ̆
 "t v ؆
 v v 
 0w Gw 
 Gw b 
 b  <
   P
  L `
 `  t
  	 
 	  
  S 
   
    
   
   8
  " L
 "   \
  " 
 "  
  / 
 /  ؈
   
  d  
 p    
    
   m 
    
  2 (
 @ q 0
   8
  2 @
 @ q H
   P
  - X
 @ > `
   p
 0  
  L 
 `  
  A ȉ
 P ! 
 " @" 4
 P" # <
  # 
3 |
 3 5  
 5 6 L
 6 ^8 
 p8 < 
 < g= 
 p= ~A X
 A B 
 B 0G ,
 @G K Ѝ
 K yQ 
 Q U ԏ
 U [ 
 [ ` ؑ
  ` f` P
 f` ` d
 ` a x
 a a 
 a e P
  f j d
 j n x
  n 'r 
 0r u 
 u v |
 0v v 
 v v 
 w w 0
 w >x t
 Px x 
 x y 
 0y y (
  z { `
 { k 
 k  
  = 
 P ̈́ 
   z 
   
   % 
 0  
    
   E 
 P 
 T
 
 l 
  ) <
 ) - 
 - Z/ 
 `/ / 
 / 1 
 2 !4 
 @4 e4 ̦
 p4 6? 4
 @? @ P
 @ OK T
 `K 5[ 0
 P[ a 
 a e 
 e Ff |
 pf g 
 g Om 
 `m  \
    
 Ѝ 
 
 0 j 
 p  
   
  ; h
 @  
  ܏ h
  , h
 p  
  ֐ 
    P  
  Ƒ 
 Б  
  J 
 P } 
  ֒ 
   A  v 
 v  ܴ
    
    
   
 `  
   
  A 4
 P  \
   
  f 
 p  
  ݘ 
   
   M 
 P } 
  
 
  z 
    p ( 
 0 k 
 p  $
   
  & 
 0 f \
 p  ķ
   ,
  & 
 0 f 
 p  d
   ̹
  & 4
 0 f 
 p  
    0  \
    
   
      B  
 B  
  ѣ ػ
  A 8
 A  $
   
   
    
 p  L
  ީ 
  r l
  Z |
  6 
 @ l 
   p 
 p ײ 
 ײ  
    
    
  8 \
 8 > L
 @  
  ) p
 0 V 
 `    ɶ 
 ж " 
 0  
  ط 
  2 
 @  
  ظ 
   
   
   
   c 
 p Ӻ 
  C 
 P  
   
  m Ⱦ
 p n 
 p ^ ̿
 ` M 
 P  
   
   d
   T
   
        . 
 0  
   
   
  d 
 p 7 
 @ > 
 @ ? \
 @     
   } 
   
  > 
 @  
   
   ^ 
 `  
   
    
  T 
 `  
   
  O 
 P  
   
   
    
  T 
 `  
   
   
   X
   <
   ,
   
   x
   h
  } 
  Z 
 ` _ $
 ` ] l
  ` 
   
 `  
   
  : 
 @  
   
   B A B 7 
 7 0 
 0  (
      8
  6 
 6 C t
 C m `
 p  
   
    
    d
   ,
   
  ( |
 0 : 
 : u 
 u  
   
   
   4 
 @  
  G p
 P w 
   ,
  # p
 0  
   
   |
    
   
  " 
 "  
   
   
   
   
  \ D
 `  x
   
  f 
 p  
    0
   c  
 p    
   3! 
 @! ! 
 ! " 
  " ~" 
 " " 
 " # 
 # r# 
 # # 
 # E$ t
 P$ $  $ <%  @% 0& 
 0& l& 
 p& & 
 & & 
 & ,' 
 0' k' 
 p' ' 
 ' R( 
 p( ( 
 ( f) 
 ) ) 
 ) h* 
 p* + \
 + , 
  - - 
 - =0 \
 =0 Q0 H
 Q0 k0 8
 k0 8 
 8 #: 
 0: J; 
 P; ~; D
 ; U< 
 `< = 
 @= =  
  > > \
 > ? 
  ? ? 
 ? @ 
 A &B 
 PB B 
  C C 
 C D 
 D D 
 D E 
 E 
H h
 
H !H T
 !H ;H D
 ;H P 
 P R 
 R U 
 U U 
 U V 
  V 	W 
 W X 
  X X L
 X EY 
 `Y Y 
 Y 2Z 
 @Z Z 
 Z [ 
 [ I[ l
 I[ N[ \
 N[ l[ H
 p[ \ 
 \ \ 
 \ c 
 c c 
 c g  g h 
 h i 
 i i 
 i j 
 j zj 
 zj j  
 j j 
 j ;m d
 ;m n L
 n p 8
 p ]p (
 `p r 
 r v 
  v 3v 
 3v Kv  
 Kv v 
 v v 
 v v 
 v w 
 w /w 
 /w gw 
 gw w 
 w x l
 x x \
 x x <
 x x  
 x y 
 Pz z 
 { { 0
 { ,| 
 0| | 
 | L} 
 P} } 
 ~  l
  # 
 # e 
 e ( 
 ( m 
 p d ,
 d U 
 U J 
  l H
   
   v 
  ܙ 
  v 
   
   x 
  h 
 p  
 0  H
  & t
 0 ƞ 
   
  , A ,  
   
  ˡ H
 ˡ  
  Ң 
   
   p
   L
   <
   
   |
  P |
 P  
   
   R 
 R ҧ 
 ҧ  
  e  p      
   
  ϫ 
 Ы X @
 `  
   
    
   p
 Ю  
  > 
 > C 
 C a 
 p f 
 p f 
 p # 
 0 O 
 P ³ D
 г  
  _ p
 ` ߴ    ? 
 @ ȵ 
 е  
  x 8
   
  ( h
 0 O 
 P ط 
   
   Z 
 `  
  ڸ 
  X 
 `  
   =  
 @  L
    
    
   Ӿ 
   `
   
  ߿ 
  h 
 p  
   
    |
   
  C  
 P B h
 P e 
 e  
   
  o 
 p # 
 0  0
   @
  - 
 -  d
   T
  V 
 `  
   
   
   
    
   
   8
  Z $
 Z g 
 g   
   
  . p
 . ; `
 ; e H
 p & 
 0 ; 
 @ k 8
 k $ 
 $  
   8
  d 
 d  
   
  x @
   
  ( h
 0 j 
 p  
  * 
 0  
   
   
   (
  c p
 p  
   
   
   
   
   T 4
 T  
   
 p  
   @
   Z 
 `  
   h
  S 
 ` } 
  3 \
 @ _ 
 `  
   X
   
  G 
 P { (
 {  
   
  > 
 > @ 
 @  
   
    4
   
    \
    
  c  
 p # H
 0 I H
 I  
   
  
 
     I
 T p
 
 
 
  
  = 
 @ l 
 p  0
   
   
   h
   L
   <
   " 
 0 n 
 p j 
 p  
   C p
 P % |p 0  
  W  `     
    
   C  P u 
   
    4
   ! 
 ! ! 
 ! - l
 - 1 \
 1 2 
 2 2 T
 2 3 |
 3 }4 
 4 4 4
 4 c6 d
 p6 6 
 6 6 
 6 6 
 6 8 
 8 8 t
 P= = 
 = = 
 = A 
 A @C 
 @C PC 
 PC uC 
 C C ,
 C -H 
 0H UH 
 UH UI d
 UI WI T
 `I ~S x
 S S  
 S 4T 
 4T 6T 
 @T T 
 T  U 8
  U U 
 U U 
 U V 
 V pV `
 pV V 
 V Y 
 Y Y <
 Y rZ  
 rZ tZ 
 Z Z H
 Z _ p
 _ _ 
 _ d 
 d >e 
 @e Ye H
 Ye e 0
 e !f  
 0f f 
 pg g P
 g h |
 h )i 
 )i i 
 i i 
 i Dk 
 Pk _l `
 `l m 
  m m 
 m n 
 n Jo 
 Po Jp H
 Pp q  q Cq 
 Cq q 
 q q  
 q q 0
 q r 
 r -r 
 0r t L
 t ex X
 px z t
 z } D
 } } 
 } J~  P~ ~ 
 ~ ~ 
 ~ B 
 B  
   
  g 
 p  L
  T 
  u 
  ݃ 
  B ,
 P  
  Ї 
 Ї  
 0 p 
 p ҈ 0
  ݉ 
   
       <    T    
        @      Ք  Ք    ^  ` m   p       ٗ 
  	 
   
        q  q z    |   d  s P s  @   0             O  P        ϡ   2 
 @ 8   *    إ  p (  P  
 Ч A 
 P  
 Ш g | p  <   N  P ά  Ь .  p ? h @ . t 0    r @	  ޱ h(   	    p
  - 
 0 n `     < < @  p  * T *  D  j | p  
  #  0 N A N  
  + 
 0 I X
 I  <
  ( ,
 0  
  7 
 7  p
  - `
  m 
 p  
   ] 
 `  
  g T p a X' p A @ P  T    d  [  `     $    H   $     B 
 P  
   
  F 
 P  
   
  f 
 p  
   
   a 
 p  
   P  . T 0  `   
        P   G 
 P  d   P  ~ 
  i t p  
   
    
   
  j 
 p     K 8
 K    \  `  
  s   #  0 [ 
 [  D  H 4 P c A c  t   d  )   #  0  
   
   
   
  ? 
 @ o 
 p  
   
      E  P  L     <  @    <  @ c 
 p    E  P r @     
  
    s |        B  P  4  #  # ]' p ]' * X * w+  + +  + Z-  Z- -  - - L - / ( / /  3 3  3 5 h 5 6 X 6 6  6 T7  `7 8  8 :  : #;  #; <  < #<  0< <  = m> $ p> 1? X ? q@  @ AA  A \B  `B HC < C !D t 0D E  E `F  `F \ H \ ] 4" ] a "  a :a $ :a a t$ a Gb X$ Gb .c <$ .c 8c ,$ @c c $ c c % c Id $ Id ed $ pd i %  i i % i .j % .j Dj t% Pj uj % uj k % k k %  k k % k 7l & @l Jl P' Jl l 8' l l (' l l  l m X' m n |- n o 
  o _p h' `p p ' p r ' r Os ' s s 
 s ,t ,( ,t Kt ( Kt ]t ( u 
v 
 
v Lv T( Lv kv @( kv }v @( w jx h( px  (    *  щ 4+   +   L , P  p-   |-  h - p " - 0 ȑ  Б h  p  -  ? x. @ 7 . @ r </   x/   /    p0  m \0 m t L0  ! 
 0  |0   0    1   N T1 P u 1  k (2 p  2   2   l3   X 3 ` ڶ    4   
  9 
 @ i 
 p  lD  J 05 J [  5 `  T5   q 5   6    6  ] % ]  6   6  ; 7 ; k 7 k  6   V  @ $7 @  7   7   7   { 7  > 7 @  8  O 8 O  t8  i 8 i  8   8   8    9  2 d9 @ ? |9 @ v 9 v p 9 p | 9 |  9   9   9    :   :  ` 0: `  ;  S : S n : p  @;  | <   > @  d
    >  N  P    o ? p  @A   ?   ?  4 
 @  ?   a @ p 	 @  	 
 @ 
 
 A   4A  
 >   @A   TA   V   |A   a A p  A  8 A 8 = A @  B   A  5 A @ e 
 p [ (B ` N tB P T 
 `  B   	! B ! ." B 0" z# B # ~$ B $ % @ % `' @ `' ( B ( * B * + B + - B  - . B  . 0/ C 0/ I/ C I/ / C / 1 C 1 *1 C 01 2 C 2 _3  `3 3 D 3 4  4 5 D 5 6 D 6 7 (D 7 8 <D 8 ;9 lD ;9 z9 XD z9 9 HD 9 V: 
 `: D |D D :E 
 @E O hE O P 
  P Z F Z }] G ] ^ H ^ ` HH ` a H a b > b Md H Md f H f >f H @f !i H 0i 'k I 0k Hl - Pl ,m 4I 0m 6n PI @n n  n lo hI po p - p q - q as I ps t I t nw I pw w J w x I x x I x y J y { dJ { D{ 
 P{ } J  } q}  } ~  ~ ~ 
 ~ S xK `  L  c L p  L  * L *  L  P L P Ã L Ã ׃ L   L  ~ @M ~ @ (M @  M  ǆ M І ъ |M  N N P i C i  N  < N < J N P  
  e N p ׎ 
  ˠ O Р  Q   q PT   pT   |T  Q T ` ɹ T й  T  / dU 0  U   HV   }   V   6 V @ { V   V   W   W   W   W   W    X    |X  . 
 0  X  ^ 
 ` K Y P 7 dY @ G Y P Q 4Z `      Z   Z    <[   
   [   \                \   t 
   
   
   p 
 p  8\    \   j p] p $ ] 0  ^  R  `  ^   h_   `   6 Dh @ V i `  i   j   k     
     k   _# l `# W+ l `+ / n /  2 n  2 2 k 2 [9 n `9 A: n P: ; o ; < V < = Po = > do > ? xo ? UA o `A 6C o @C ND o PD 7E |p @E 7F p @F F @ F ~G @ G H C H I C I J 
 J XK p `K L q L CM q CM O q O #O q 0O &S q 0S S  \ S T \r  T V lr V Z r  Z {Z $s Z [ `s [ [ 
 [ ] 4t ] ^ 0u ^ ^ u  _ _ X'  ` a 8v a ue v e 9h w @h i x i o y o Bq  Pq q 
 q r 
  r r dy r vs y s u y u xv  z v v 
 v v z v w z w Ux xz Ux x hz x x Xz x } z }  {  Ņ \| Ѕ  n   |    P}   }  Ƌ } Ћ ƌ P Ќ A } P  }  : } @  ~  Γ <~ Г  X' Д    ŕ  ŕ        b  p P  P  T   d  ǜ t М ^  `  ȁ  c Ѓ p ¢ h Т  |   > 8 @ 6 P @     v ( v ڬ  ڬ      8  7  @  (     ͸ l ͸  T  $ D 0 M  M    ¹ | й 1 
 @  
   
   ̻  л v    8  K  P     Po        p Ċ p  4   T   x       `       Ԓ          <   P  P  Ȕ  x    $         8    P   = d @ 	  	 
	  	 	   	 	 t 	 q 	 ę  	  	   	  	   	  	 К  !	 S!	   `!	 )	   )	 .9	 ĝ 09	 q:	   :	 ;	  ;	 ?	 , ?	 D	 С  D	 X	   Y	 Z	 , Z	 \	  \	 K^	 Ȩ P^	 `	 ,  `	 a	  a	 c	 ܪ c	 e	  e	 f	  f	 f	  f	 f	 x f	 Bg	  Pg	 Vn	  `n	 o	 H o	 np	 x pp	 q	  q	 ~r	 Ԯ r	 s	  s	 t	  t	 u	  u	 v	  v	 ~	 , ~	 	   	 	  	 	 0 	 	 |  	 ڎ	 Ȱ 	 	  	 2	 
 @	 ԑ	 T 	 	  	 ]	  `	 d	  p	 r	  	 	 Ĵ 	 	  	 m	  p	 	  	 	 ̶ 	 	   	 Y	   `	 	 L  	 	   	 +	 0 0	 	  	 	  	 	  	 	  	 u	  	 	  	 	 d 	 !	 < 0	 p	  p	 	   	 E	 
 P	 S	 ܿ `	 
	  	 
 t 
 &
  0
 p	
  p	
 2I
  @I
 I
  \J
 J
  K
 K
  K
 K
  K
 BL
 
 DL
 N
  N
 O
  O
 P
  P
 cP
 P dP
 P
 x P
  Q
 
  Q
 XQ
 
 Q
 !R
  <R
 _R
  `R
 S
  @S
 S
  S
 S
 " S
 S
 i
 S
 S
 j
 S
 	T
 j
 T
 )T
 j
 0T
 IT
 $j
 PT
 iT
 j
 pT
 T
 j
 T
 T
 j
 T
 T
  k
 T
 T
 k
 T
 +U
 tl
 0U
 kU
 l
 pU
 U
 l
 U
 U
 l
 U
 +V
 l
 0V
 kV
 l
 pV
 V
 l
 V
 V
 l
 V
 +W
 l
 0W
 kW
 m
 pW
 W
 m
 W
 W
 $m
 W
 	X
  x
 X
 (X
 x
 0X
 VX
 x
 `X
 yX
 lx
 X
 X
 ~
 X
 X
 ~
 X
 X
 
 X
 Y
 
  Y
 9Y
 
 @Y
 YY
 l
 `Y
 yY
 t
 Y
 Y
 @
 Y
 Y
 H
 Y
 Y
 P
 Y
 Y
 X
  Z
 Z
 `
  Z
 9Z
 h
 @Z
 YZ
 p
 `Z
 yZ
 x
 Z
 Z
 
 Z
 Z
 
 Z
 Z
 
 Z
 Z
 
  [
 [
 
  [
 9[
 
 @[
 Y[
 
 `[
 y[
 
 [
 [
 
 [
 [
 
 [
 [
 
 [
 [
 
  \
 \
 
  \
 <\
 
 @\
 \\
 
 p\
 \
 `
 \
 \
 h
 \
 \
 
 \
 \
 ċ
 \
 ]
 0
 ]
 +]
 
 @]
 X]
 Ԍ
 `]
 x]
 ܌
 ]
 ]
 X
 ]
 ]
 `
 ]
 ]
 h
 ]
 ^
 p
  ^
 8^
 
 @^
 X^
 
 `^
 {^
  
 ^
 ^
 
 ^
 ^
 Ď
 ^
 _
 ̎
 _
 (_
 Ԏ
 0_
 K_
 ܎
 P_
 k_
 
 p_
 _
 
 _
 _
 
 _
 _
 
 _
 _
 
 _
 `
 
 `
 +`
 
 @`
 X`
 
 ``
 x`
 
 `
 `
 
 `
 `
 
 `
 a
 Ȑ
 a
 (a
 А
 0a
 Ha
 ؐ
 Pa
 ka
 
 pa
 a
 
 a
 a
 
 a
 a
 
 a
 a
  
 a
 b
 
 b
 +b
 
 0b
 Kb
 
 `b
 xb
 
 b
 b
  
 b
 b
 
 b
 b
 
  c
 .c
 В
 @c
 Xc
 t
 `c
 xc
 |
 c
 c
 
 c
 c
 
 c
 c
 
 c
 c
 
  d
 d
 
  d
 8d
 
 @d
 Xd
 
 `d
 xd
 
 d
 d
 
 d
 d
 
 d
 d
 
 d
 d
 
  e
 e
 
  e
 8e
 
 @e
 Xe
 
 `e
 xe
 
 e
 e
 
 e
 e
 
 e
 e
 
 e
 e
 ĕ
  f
 f
 ̕
  f
 8f
 ԕ
 @f
 Xf
 
 `f
 xf
 
 f
 f
 
 f
 f
 Ȗ
 f
 f
 Ж
 f
 f
 ؖ
  g
 g
 
  g
 8g
 
 @g
 Xg
 ė
 `g
 xg
 ̗
 g
 g
 ԗ
 g
 g
 ܗ
 g
 g
 
 g
 h
 
 h
 ,h
 
 0h
 Hh
 
 Ph
 hh
 
 ph
 h
 ̘
 h
 h
 
 h
 h
 L
 h
 h
 
  i
 i
 ę
  i
 8i
  
 @i
 Xi
 @
 `i
 xi
 
 i
 i
 
 i
 i
  
 i
 i
 (
 i
 i
 0
 j
 (j
 ț
 0j
 Hj
 Л
 Pj
 hj
 ؛
 pj
 j
 
 j
 j
 
 j
 j
 
 j
 j
 
  k
 /k
 Ĝ
 0k
 Kk
 ̜
 Pk
 kk
 Ԝ
 pk
 k
 ܜ
 k
 k
 
 k
 k
 
 k
 k
 
 k
 l
 
 l
 (l
 
 0l
 Hl
 
 Pl
 hl
 
 pl
 l
  
 l
 l
 (
 l
 l
 0
 l
 l
 8
  m
 m
 @
  m
 <m
 H
 @m
 [m
 P
 `m
 |m
 X
 m
 m
 `
 m
 m
 ğ
 m
 m
 ̟
 m
 m
 ԟ
  n
 n
 ܟ
  n
 <n
 
 @n
 Yn
 
 `n
 xn
 
 n
 n
 
 n
 n
 
 n
 n
 
 n
 n
 
  o
 o
 
  o
 ;o
 $
 @o
 [o
 ,
 po
 o
 t
 o
 o
 |
 o
 o
 
 o
 o
 
 o
 p
 
 p
 Tp
 
 `p
 {p
 Ģ
 p
 p
 ̢
 p
 p
 Ԣ
 p
 p
 ܢ
 p
 p
 
  q
 q
 
  q
 8q
 
 @q
 Xq
 
 `q
 {q
 
 q
 q
 
 q
 q
 
 q
 r
 d
 r
 +r
 l
 0r
 Kr
 t
 Pr
 kr
 |
 pr
 r
 
 r
 r
 
 r
 r
 
 r
 r
 
 r
 s
 
 s
 (s
 
 0s
 Hs
 
 Ps
 ks
 
 ps
 s
 Ĥ
 s
 s
 Х
 s
 s
 إ
 s
 s
 
  t
 /t
 
 0t
 Ht
 
 Pt
 ht
 
 pt
 t
  
 t
 t
 
 t
 t
 X
 t
 t
 `
  u
 u
 h
  u
 ;u
 p
 @u
 [u
 x
 `u
 {u
 
 u
 u
 
 u
 u
 
 u
 u
 
 u
 u
 
  v
 v
 
  v
 8v
 
 @v
 \v
 x
 `v
 xv
 
 v
 v
 
 v
 v
 
 v
 v
 
 v
 v
 
  w
 w
 
  w
 ;w
 
 @w
 [w
 
 `w
 {w
 
 w
 w
 ȩ
 w
 w
 Щ
 w
 w
 ة
 w
 w
 
  x
 x
 
  x
 8x
 
 @x
 \x
 
 `x
 {x
  
 x
 x
 
 x
 x
 
 x
 x
 
 x
 x
  
  y
 y
 (
  y
 ?y
 0
 @y
 [y
 8
 `y
 {y
 @
 y
 y
 H
 y
 y
 P
 y
 y
 X
 y
 z
 `
 z
 +z
 h
 @z
 [z
 T
 `z
 {z
 \
 z
 z
 d
 z
 z
 l
 z
 z
 t
 z
 z
 |
  {
 {
 
  {
 8{
 
 @{
 X{
 
 `{
 {
 
 {
 {
 
 {
 {
 
  |
 |
 ȭ
  |
 8|
 Э
 @|
 X|
 ح
 `|
 x|
 
 |
 |
 
 |
 |
 
 |
 |
 
 |
 |
  
  }
 }
 ̮
  }
 8}
 Ԯ
 @}
 \}
 ܮ
 `}
 |}
 
 }
 }
 
 }
 }
 
 }
 }
 
 }
 }
 
  ~
 ~
 
  ~
 8~
 $
 @~
 X~
 ,
 `~
 x~
 4
 ~
 ~
 <
 ~
 ~
 D
 ~
 ~
 L
 ~
 ~
 T
  
 
 \
  
 ;
 d
 P
 k
 
 p
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 +
 
 0
 t
 
 
 
 ̲
 
 
 Բ
 
 
 
 
 +
 
 0
 K
 
 P
 k
 
 p
 
 
 
 ԁ
 
 
 
 
  
 D
 $
 P
 k
 4
 p
 
 <
 
 
 D
 
 ͂
 
 Ђ
 
 |
 
 
 
 
 -
 L
 0
 M
 
 P
 m
 
 p
 
 
 
 
 
 
 ̓
 T
 Ѓ
 
 
 
 
 $
 
 -
 
 0
 M
 
 P
 i
 " p
 
 " 
 
 " 
 Ʉ
 " Є
 
 " 
  
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 ޅ
 
 
 
 "  
 
 "  
 8
 " @
 |
 
 
 
 " 
 
 " 
 ن
 " 
 
 "  
 
 "  
 <
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 ه
 " 
 
 "  
 
 "  
 9
 " @
 q
 
 
 
 
 
 ވ
 
 
 
 "  
 
 "  
 9
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 ى
 " 
 
 "  
 
 "  
 9
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 ي
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 y
 " 
 
 " 
 
 " 
 
 d
 
 
 " 
 )
 " 0
 L
 " P
 i
 " p
 
 4
 
 
 " 
 Ɍ
 " Ќ
 
 " 
 
 " 
 U
 
 `
 y
 " 
 
 " 
 
 " 
 ߍ
 " 
 '
 8
 0
 H
 " P
 i
 " p
 
 " 
 
 " 
 Ȏ
 " Ў
 
 " 
 
 " 
 :
 " @
 p
 " p
 
 " 
 
 " 
 ڏ
 " 
 
 "  
 
 "  
 e
 \
 p
 
 " 
 ʐ
 " А
 
 " 
  
 "  
 8
 " @
 j
 " p
 
 " 
 
 " 
 ؑ
 " 
 

 " 
 :
 " @
 X
 " `
 
 " 
 
 " 
 
 " 
 
 "  
 *
 " 0
 H
 " P
 l
 " p
 
 " 
 
 " 
 ͓
 
 Г
 
 "  
 
 "  
 P
 " P
 i
 " p
 
 " 
 
 " 
 ؔ
 " 
 

 " 
 (
 " 0
 Z
 " `
 x
 " 
 
 " 
 ȕ
 " Е
 
 "  
 
 "  
 J
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 ,
 " 0
 L
 " P
 i
 " p
 
 " 
 
 " 
 ɗ
 " З
 
 " 
 
 " 
 ,
 " 0
 I
 " P
 l
 " p
 
 " 
 
 " 
 Ș
 " И
 
 t
  
 
 "  
 8
 " @
 X
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 (
 " 0
 K
 " P
 k
 " p
 
 " 
 
 ,
 
 ˚
 " К
 
 " 
 ,
 " 0
 K
 " P
 k
 " p
 
 " 
 
 " 
 ؛
 " 
 
 "  
 
 "  
 8
 " @
 V
 ,
 `
 {
 " 
 
 " 
 ܜ
 " 
 
 
 
 (
 " 0
 Z
 " `
 x
 " 
 
 " 
 ʝ
 " Н
 
 " 
 
 " 
 +
 " 0
 L
 " P
 l
 " p
 
 
 
 
 " 
 ٞ
 " 
 
 "  
 
 "  
 <
 " @
 \
 " `
 |
 " 
 
 " 
 
 " 
 
 8
 
 
 <
  
 >
 <
 @
 ՠ
 @
 
 
 "  
 L
 0
 P
 i
 " p
 
 d
 
 
 d
 
 
 4
 
 
 4
 
 ,
 " 0
 H
 " P
 l
 " p
 
 " 
 
 " 
 ̢
 " Т
 
 " 
 
 " 
 ,
 " 0
 L
 " P
 h
 " p
 
 
 
 ۣ
 " 
 
 "  
 
 "  
 <
 " @
 
 
 
 
 " 
 ɤ
 " Ф
 
 " 
 
 " 
 +
 " 0
 K
 " P
 i
 " p
 
 " 
 
 " 
 ̥
 " Х
 
 " 
 
 " 
 +
 " 0
 \
 " `
 
 " 
 
 " 
 צ
  
 
  
 7
  @
 g
  p
 
  
 
 " 
 ٧
 " 
 
 l 
 .
 l 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ̨
 " Ш
 
   
 9
 " @
 Y
 " `
 x
 " 
 
 " 
 
 " 
 	
 (	 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ˪
 " Ъ
 
 " 
 
 
  
 J
  P
 h
 " p
 
 " 
 
 " 
 ȫ
 " Ы
 
 " 
 	
 " 
 (
 " 0
 L
 " P
 i
 " p
 
 " 
 
 " 
 ˬ
 " Ь
 
 " 
 	
 " 
 )
 " 0
 H
 " P
 k
 " p
 
 " 
 
 " 
 ɭ
 " Э
 
 " 
 	
 " 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 Ȯ
 " Ю
 
 " 
 
 " 
 ,
 " 0
 y
 4 
 
 " 
 
 " 
 د
 " 
 
 "  
 
 "  
 ;
 " @
 _
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 2
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 ر
 " 
 
 "  
 
 "  
 9
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 ۲
 " 
 
 "  
 
 "  
 ;
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 س
 " 
 
 "  
 
 "  
 <
 " @
 X
 " `
 
 4 
 	
 " 
 ,
 " 0
 L
 " P
 i
 " p
 
 " 
 
 " 
 ɵ
 " е
 
 " 
 
 " 
 ,
 " 0
 I
 " P
 h
 " p
 
 4  
 
 "  
 <
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 ٷ
 " 
 
 "  
 
 "  
 <
 " @
 Y
 " `
 x
 " 
 
 " 
 
 " 
 N
 4 P
 i
 " p
 
 " 
 
 " 
 ɹ
 " й
 
 " 
 
 " 
 )
 " 0
 H
 " P
 l
 " p
 
 " 
 
 " 
 Ⱥ
 " к
 ^
 4 `
 y
 " 
 
 " 
 
 " 
 ٻ
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 ؼ
 " 
 
 "  
 
 "  
 
 4 
 
 " 
 ̽
 " н
 
 " 
 
 " 
 (
 " 0
 H
 " P
 i
 " p
 
 " 
 
 " 
 ɾ
 " о
 
 " 
 	
 " 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ɿ
 " п
 
 " 
 
 " 
 6
 " @
 Y
 " `
 y
 " 
 
 " 
 
 % 
 
 " 
 
 &  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 |( 
 7
 |( @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 8
 , @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 <
 " @
 Y
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 \
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 |4 
 ;
 D5 @
 k
 6 p
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 g
 7 p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 (
 " 0
 L
 " P
 
 (; 
 
 " 
 
 " 
 
 " 
 +
 " 0
 K
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 )
 " 0
 W
 ; `
 x
 " 
 
 " 
 
 ; 
 
 " 
 
 " 
 (
 " 0
 H
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 ,
 " 0
 L
 " P
 h
 " p
 
 " 
 
 " 
 
  C 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 G
 hK P
 h
 " p
 
 L 
 >
 dM @
 X
 " `
 
 TM 
 
 " 
 
 " 
 
 " 
 (
 " 0
 H
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 +
 " 0
 L
 " P
 l
 " p
 
 " 
 
 " 
 
 O 
 
 "  
 
 "  
 <
 " @
 [
 " `
 {
 " 
 
 O 
 
 " 
 
 " 
 
 " 
 (
 " 0
 K
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 ,
 " 0
 L
 " P
 l
 " p
 
 Q 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 g
 Q p
 
 " 
 
 " 
 
 " 
 
 " 
 5
 U @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ?
 " @
 [
 " `
 
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 \
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 @
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ?
 " @
 _
 " `
 
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 
 ^ 
 .
 P_ 0
 H
 " P
 
 @_ 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 Y
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 <
 " @
 Y
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 Y
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 [
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 <
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 [
 " `
 |
 " 
 
 " 
 
 t` 
 
 " 
 
 " 
 (
 " 0
 S
 4h `
 x
 " 
 
 " 
 
 " 
 
 i 
 
 " 
 (
 " 0
 K
 " P
 s
 i 
 
 " 
 
 " 
 
 " 
 
 j 
 ,
 " 0
 H
 " P
 h
 " p
 
 l 
 
 " 
 
 " 
 (
 " 0
 I
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 	
 " 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 	
 " 
 (
 " 0
 L
 " P
 l
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 /
 " 0
 H
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 	
 " 
 +
 " 0
 K
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 )
 " 0
 V
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 <
 " @
 \
 " `
 
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ?
 " @
 X
 " `
 
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 8
 " @
 b
 " p
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ?
 " @
 _
 " `
 
 " 
 
 " 
 
 " 
 
 " 
 
 "  
  
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 ,
 " 0
 L
 " P
 l
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 (
 " 0
 L
 " P
 l
 " p
 
 " 
 
 " 
 
 " 
 
 " 
   "    ;  " @  X  " `  x  "     "     "     "     "    "   8 " @ X " ` x "   "   "   "   {  + " 0 K " P z |   "   "   "   "    "   < " @ X " ` | "   "   "   "   "    "   @ " @ _ " ` x "   "   "   "   "    "   8 " @ X " ` x "   "   "   "  N x P i " p  "   "       9 " @ X " ` x "     ) " 0 I " P i " p  "   "   "   "  		 " 	 4	 " @	 	  	 	 " 	 	 " 	 	 " 	 
 " 
 (
 " 0
 H
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
  "  ( " 0 H " P h " p  "   "   "   "    "   8 " @ X " `  (   "   "  
 " 
 (
 " 0
 K
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
  "  , " 0 L " P     "   "    "   < " @ Y " ` | "   "   "   "   "    "   9 " @ [ " ` { "   "   "   "   "    "   ; " @ [ " ` x "   "   "   "   "    "   ? " @ [ " `  "   "   "   "   " " 0 K " P k " p  "   "   "   "  	 "  , " 0 L " P l " p  "   "   "   "   "  + " 0  @   "   "  ) " 0 K " P o " p  "   "   "   "    "   ; " @ X " ` y "   "   "   "   "   B " P r "   "   "   "    "   B " P h " p  "   "   "   "  , " 0 I " P  ,   "   "       "   "   "   "    "   ; " @ [ " ` { "   "   "   "   "    "   ; " @ [ " ` x "   "   "       "   ; " @ Y " ` | "      "   "   "  + " 0 H " P z    "   "   "   "      "    ;  " @  [  " `  |  "     "     "     "     "  ! ! "  ! ;! " @! [! " `! {! " ! ! " ! ! " ! ! " ! ! "  " " "  " <" " @" \" " `" |" " " " " " " " " " " " " "  # # "  # <# " @# \# " `# |# " # # " # #  # # " # $ " $ )$ " 0$ L$ " P$ i$ " p$ $ " $ $ " $ $ " $ $ " $ % " % +% " 0% K% " P% k% " p% % " % % " % % " % % " % & " & ,& " 0& L& " P& k& " p& & " & & " & & " & & " & ' " ' ,' " 0' K' " P' k' " p' ' " ' ' " ' ' " ' ' " ' ( " ( ,( " 0( L( " P( l( " p( ( " ( ( " ( ( " ( ( " ( ) " ) +) " 0) K) " P) k) " p) ) " ) ) " ) ) " ) ) " ) * " * +* " 0* K* " P* k* " p* * " * * " * * " * * " * + " + ++ " 0+ +  + + " + + " + o,  p, , " , , " , , " , O-  P- i- " p- - " - .  . ). " 0. I. " P. . Ȫ . . " . 	/ " / /  / / " / / " / / " / 0 " 0 ,0 " 00 L0 " P0 l0 " p0 0 " 0 0 " 0 0 " 0 0 " 0 1 " 1 ,1 " 01 L1 " P1 v1 " 1 1 " 1 1 " 1 1 " 1 1 "  2 2 "  2 ;2 " @2 [2 " `2 x2 " 2 2 " 2 2 " 2 2 " 2 2 "  3 3 "  3 93 " @3 Y3 " `3 y3 " 3 3 " 3 3 " 3 3 " 3 3 "  4 4 "  4 84 " @4 X4 " `4 {4 " 4 4 " 4 4 " 4 4 " 4 4 "  5 5 "  5 85 " @5 \5 " `5 |5 " 5 5  5 6 " 6 (6 " 06 H6 " P6 l6 " p6 6 " 6 6   7 7 "  7 ;7 " @7 X7 " `7 x7 " 7 7 " 7 7 " 7 7 " 7 7 "  8 ;8 < @8 [8 " `8 {8 " 8 8 " 8 8 " 8 8 < 8 9 " 9 +9 " 09 H9 " P9 k9 " p9 9 " 9 9 < 9 9 " 9 9 "  : : "  : 9: " @: X: " `: {: " : : " : : " : : " : : "  ; ; "  ; <; " @; \; " `; x; " ; ; " ; ; " ; ; " ; ; "  < < "  < 8< " @< X< " `< |< " < < " < < " < < " < < "  = = "  = ;= " @= \= " `= |= " = = " = = " = = " = = "  > > "  > <> " @> \> " `> |> " > > " > > " > > " > > "  ? ? "  ? 8? " @? X? " `? x? " ? ? " ? ? " ? ? " ? ? "  @ @ "  @ 8@ " @@ [@ " `@ {@ " @ @ " @ @ " @ @ " @ 
A  A ,A " 0A LA " PA kA " pA A " A A " A A " A A " A B " B +B " 0B HB " PB hB " pB B " B B " B B " B B " B C " C +C " 0C LC " PC lC " pC C " C C " C C " C C " C D " D +D " 0D KD " PD lD " pD D " D D " D D " D D " D 	E " E ,E " 0E KE " PE oE " pE E " E E " E E " E E " E F " F +F " 0F KF " PF iF " pF F " F F " F F " F F " F G " G ,G " 0G KG " PG kG " pG G " G G " G G " G G " G H " H ,H " 0H KH " PH kH " pH H " H H " H H " H H " H I " I (I " 0I HI " PI lI " pI I " I I " I I " I I " I J " J +J " 0J KJ " PJ kJ " pJ J " J J " J J " J J "  K K "  K 9K " @K [K " `K {K " K K " K K " K K " K K "  L L "  L BL " PL kL " pL L " L L " L L " L L " L M " M )M " 0M LM " PM kM " pM M " M M " M M " M M " M N " N )N " 0N LN " PN kN " pN N " N N " N N " N N " N O " O +O " 0O KO " PO kO " pO O " O O " O O " O O " O P " P +P " 0P KP " PP kP " pP P " P P " P P " P P " P Q " Q +Q " 0Q KQ " PQ kQ " pQ Q " Q Q " Q Q " Q Q " Q R " R -R " -R lR " lR R " R R " R R   S (S  0S XS  `S ~S  S S  S S  pT T  T T   U JU  PU nU  pU U  U U  U U  U U  V ;V  `V V  V W   W HW  PW xW  W W  W 9X D @X X t X X  X )Y  0Y Y  Y Y  Y Z  Z 0Z  0Z Z 4 0\ B\ 
 B\ l\ P l\ r\ @ \ \ 
 \ \ t \ \ d \ \ 
 \ ]  ] ]   ] 2] 
 2] \]  \] b]  p] ]  ] ]  ] ,^  @^ |^  ^ ^  ^ ^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ` T   8@HPX`hpxȩЩة  (08@HPX` p (   hpxȬЭخ        `    ȦЦئ  (08@HPȧЧاPX`hpxȨШب pxȩЩة (08@HPX`hpxȬЬجȭЭح  (0 p t   @HPX`hpxȡС  ȦЦئ   (08@HPX`       (0@HPX`hpxȡС (08@HPX`hpxhpx (08@HPX`hpxȬЬج  (08@    ȡСء 8@HPX (08@HPX`hpxȣУأ  (0إ(08@HPX`hȦЦئxȩЩة  (08@HPX`hpxx  (08@HPhpخ      X`      (0hpx`hpxУأ ȧЧا  (0px  (08@PX`hpxЩة       ȢТآ @HPX`hpx(08@HPX`hpxȤФؤ 8@HPX`hpxȥХإ  (0hpxȦ  (08@HPX` (08@    (    (08@HPXȠРؠ    @   إ`hpxȧЧا     |   (0HPXxȢТآ ȣУأ  (08@HPX@HPX`hpx  
 p   PX`hpxȡСء  (  (08@HPX`hpx 
             (08ȠР   0 \  ȣ @HPhpxȤ08@X`hХإ hئ(0pxPXpxȨШب08PXhpxȩЩة(08PXpxЪت08PXpxЫث8@H`hpج (08PX`xHxȮЮ HX   @    (8(@ȣУHФXإ08HPXhpxئ08@HX`hpȧh(pxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد P    (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp08X`Чا  (HPpxȨ8@`hة (0PXxȪЪ @Hhp08X`Ьج  (HPpxȭ8@`hخ (0PXxȯЯ ` \   @Hhp08X`Сء  (HPpxȢ8@`hأ (0PXxȤФ @Hhp08X`Цئ  (HPpxȧ8@`hب (0PXxȩЩ @Hhp08X`Ы HpȬHxЭ@p@pЯ p <   @h p`pЦ0𪀫@xP        Р00p@Э  @   `@ X  ` p`P   H    pСP`hpТHx`Ъ@        (`PТ 8x 0@PȤФؤ 0 8h08hȧЧا  (08@HPX`hx                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          q
Umodule_nameqU>stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1467332435qU
model_nameqU+anon_model_1988b9d517e3c16daf27a07f09e3de97qub.