     pystan.model	StanModel)}(
model_cppname+anon_model_047a6166bd9c6ecaed4dd3733fae7c6b
model_name+anon_model_047a6166bd9c6ecaed4dd3733fae7c6b
model_codeXN  data {
  int T;                                // Sample size
  int<lower=1> K;                       // Number of seasonal vectors
  real t[T];                            // Day
  real cap[T];                          // Capacities
  real y[T];                            // Time-series
  int S;                                // Number of changepoints
  real A[T, S];                   // Split indicators
  real t_change[S];                 // Index of changepoints
  real X[T,K];                    // season vectors
  vector[K] sigmas;              // scale on seasonality prior
  real<lower=0> tau;                  // scale on changepoints prior
}

parameters {
  real k;                            // Base growth rate
  real m;                            // offset
  real delta[S];                       // Rate adjustments
  real<lower=0> sigma_obs;               // Observation noise (incl. seasonal variation)
  real beta[K];                    // seasonal vector
}

transformed parameters {
  real gamma[S];                  // adjusted offsets, for piecewise continuity
  real k_s[S + 1];                 // actual rate in each segment
  real m_pr;

  // Compute the rate in each segment
  k_s[1] = k;
  for (i in 1:S) {
    k_s[i + 1] = k_s[i] + delta[i];
  }

  // Piecewise offsets
  m_pr = m; // The offset in the previous segment
  for (i in 1:S) {
    gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
    m_pr = m_pr + gamma[i];  // update for the next segment
  }
}

model {
  real Y[T];

  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.1);
  beta ~ normal(0, sigmas);

  // Likelihood
  for (i in 1:T) {
    Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta)) * (t[i] - (m + dot_product(A[i], gamma))))) + dot_product(X[i], beta);
  }
  y ~ normal(Y, sigma_obs);
}

model_cppcodeXz  // Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unkown file name");
    reader.add_event(57, 57, "end", "unkown file name");
    return reader;
}

class anon_model_047a6166bd9c6ecaed4dd3733fae7c6b : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<vector<double> > A;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
public:
    anon_model_047a6166bd9c6ecaed4dd3733fae7c6b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_047a6166bd9c6ecaed4dd3733fae7c6b(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 4;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("cap", "T", T);
            context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
            validate_non_negative_index("cap", "T", T);
            cap = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("cap");
            pos__ = 0;
            size_t cap_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
                cap[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 8;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            context__.validate_dims("data initialization", "A", "double", context__.to_vec(T,S));
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            vals_r__ = context__.vals_r("A");
            pos__ = 0;
            size_t A_limit_1__ = S;
            for (size_t i_1__ = 0; i_1__ < A_limit_1__; ++i_1__) {
                size_t A_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < A_limit_0__; ++i_0__) {
                    A[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            current_statement_begin__ = 7;
            current_statement_begin__ = 8;
            current_statement_begin__ = 9;
            current_statement_begin__ = 10;
            current_statement_begin__ = 11;
            current_statement_begin__ = 12;
            check_greater_or_equal(function__,"tau",tau,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 16;
            ++num_params_r__;
            current_statement_begin__ = 17;
            ++num_params_r__;
            current_statement_begin__ = 18;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 19;
            ++num_params_r__;
            current_statement_begin__ = 20;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_047a6166bd9c6ecaed4dd3733fae7c6b() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            T__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<T__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            T__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<T__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 24;
            validate_non_negative_index("gamma", "S", S);
            vector<T__> gamma(S);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma,DUMMY_VAR__);
            current_statement_begin__ = 25;
            validate_non_negative_index("k_s", "(S + 1)", (S + 1));
            vector<T__> k_s((S + 1));
            stan::math::initialize(k_s, DUMMY_VAR__);
            stan::math::fill(k_s,DUMMY_VAR__);
            current_statement_begin__ = 26;
            T__ m_pr;
            (void) m_pr;  // dummy to suppress unused var warning

            stan::math::initialize(m_pr, DUMMY_VAR__);
            stan::math::fill(m_pr,DUMMY_VAR__);


            current_statement_begin__ = 29;
            stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
            current_statement_begin__ = 30;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 35;
            stan::math::assign(m_pr, m);
            current_statement_begin__ = 36;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
                current_statement_begin__ = 38;
                stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < S; ++i0__) {
                if (stan::math::is_uninitialized(gamma[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < (S + 1); ++i0__) {
                if (stan::math::is_uninitialized(k_s[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: k_s" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(m_pr)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: m_pr";
                throw std::runtime_error(msg__.str());
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 24;
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;

            // model body
            {
            current_statement_begin__ = 43;
            validate_non_negative_index("Y", "T", T);
            vector<T__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);


            current_statement_begin__ = 46;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 47;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 48;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.10000000000000001));
            current_statement_begin__ = 50;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 53;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 54;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(cap,i,"cap",1) / (1 + exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))) + dot_product(get_base1(X,i,"X",1),beta)));
            }
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("k_s");
        names__.push_back("m_pr");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((S + 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 24;
            validate_non_negative_index("gamma", "S", S);
            vector<double> gamma(S, 0.0);
            stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma,DUMMY_VAR__);
            current_statement_begin__ = 25;
            validate_non_negative_index("k_s", "(S + 1)", (S + 1));
            vector<double> k_s((S + 1), 0.0);
            stan::math::initialize(k_s, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(k_s,DUMMY_VAR__);
            current_statement_begin__ = 26;
            double m_pr(0.0);
            (void) m_pr;  // dummy to suppress unused var warning

            stan::math::initialize(m_pr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(m_pr,DUMMY_VAR__);


            current_statement_begin__ = 29;
            stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
            current_statement_begin__ = 30;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 35;
            stan::math::assign(m_pr, m);
            current_statement_begin__ = 36;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
                current_statement_begin__ = 38;
                stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
            }

            // validate transformed parameters
            current_statement_begin__ = 24;
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < (S + 1); ++k_0__) {
            vars__.push_back(k_s[k_0__]);
            }
        vars__.push_back(m_pr);

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (S + 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "m_pr";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (S + 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "m_pr";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b stan_model;

module_nameFstanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332module_filenameYstanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.cp36-win_amd64.pydmodule_bytesB 
 MZ                @                                      	!L!This program cannot be run in DOS mode.

$       EG^S&0 &0 &0 ^ &0 l{1&0 :x3&0 :x4
&0 :x1&0 :x5&0 x1&0 &1 l'0 x9 &0 x0 &0 x  &0 x2 &0 Rich&0                 PE  d	 njY         "     2     <                                        `                                            p      j            P  0
                    
 (   P
              p
                          .text                           `.rdata                      @  @.data                        @  .pdata  j     l                @  @.gfids  <    @                  @  @.tls    	    P                  @  _RDATA      `                  @  @.rsrc       p                  @  @.reloc  P                     @  B                                                                                                                                        H(H
 P A   H    HD H     H
 ߑ  ' H
 H() H(H
U  A   HW    H H=     H
&   j' H
 H(( H(H
  A   H    H H}     H
f _  
' H
 H(B( H(
 =Z ǐ H(H(
 Z  H(
 ^ x H(
 Y  H(H(d
 Y ? H(0 W
 A H(ܦ
 }Y `Y W
 c H(8 X؎  H(H
   A   H    H H     H
֏ Ϗ  % H
3 H(& H(H
E  A   HG    H
 H-     H
   :% H
s H(r& H(H
 ` A   H    H
 H     H
 ߍ  $ H
 H(& H(H
   WH     H
  H(% H(H
  WH     H
[ ë H(% H(W" WH     H
  H(Y% H(2  H
 H(?% H(H

 0 WH
     H
  H(% H(H
  WH     H
 ۧ H($ H(H

  WH
     H
  H($ H( H
 H(_$ H( H
 H(?$ H(7  Ǣ
  TC
 f/{
 v  "     أ
 k T
 f/L
 v  "   H(H(x H(H( H(; 髲  H(gx H(ȡ
  
 	 H(
 O H(H(
  H(H
- #   @SH HHHSH
A H3H
HJHH HH [H HHH% HQH
 HHEH\$WH H HHH t
   HS" HH\$0H _3HAH;
 HAH HHH(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH(! @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ HG HHH0[@SH HHHSH
 H3H
HJHH H HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0 HT$0   HC   HsH{rHH  Hi$ @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" H HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HHL$pH3 L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtH
 HP uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIHO uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H} HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v H @H$   H3 L$   I[0Ik8IA^_^́aHI    ́aHI   HA HH\$Hl$Ht$WAVAWH HrE3HLH(IDIHV HGAH+HHt6@ Ht
,HU HHH HGHH+HH;rM)IDHH\$@Hl$HHt$PH A_A^_U @USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtH-
 L   H  HIHP   Hp  ) HIHPH
%
 HF
 HEH  R HH
 R HIV HH
 R HIV HH
 iR HHV Hp  Hp   HHxrHH_ HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ H HL$ % HIHP   Hp   HN
 H  Q HH
 Q HIU HH
 Q HIU HH
 wQ HHU Hp  Hp   HHxrHHm HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ H HL$ #$ HMHT$HHPHT$PLL$HI+HLHFI+HH;  HL$p Hh
 HMP HH
 P HIT HH
 ~P HIT HH	
 dP (HMyR 3ۋHFH+HHt9D  Ht,HMPR HHHM HHFH+HH;r̲)HM!R H
 HMO (HMR HD$PHL$HH+HHt<Ht,HMQ HL$HHHMm HHD$PHL$HH+HH;rĲ)HMQ Hp  HL$p8 HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8	 H HD$ H HL$ B" 3ۋH  IM+     HI9uHHH;r{  HMp- H
 H   N HH
 N HIR HH
 N HIR HH
 N HH: HH
 kN LHUp/HP
 H   LN (H   ^P HD$PHL$HH+HHtBHt,H   5P HL$HHH    HHD$PHL$HH+HH;r)H   O Hp  HMp HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8Y HB HD$ H HL$   MtLD$XM+IIB H  H3
 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H HHHH\$@H0_H\$Ht$WH0HD$        IH HHHH\$@HpHHt$HH0_@SH H{ HHt
   6 HH [@SH H   H+ HH [H% HL$UVWAVAWH0HD$ H\$pILHH HHqHt$hE3L>L~K HH_H\$hL;L{K HL(L0L8L@LHLPLXL`LhI;t8HHRHI HH@HH HH@L~DD$`IH H;t9HHRHF HH@HH HH@L{DD$`HH޿ HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP Hw yI^I;^u3HIN; HI;FtHP HH yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP Hh tHHH;t-IM载 HH;tHP H9 yHHS@   IM落 HI}H;tHP H tHH;   HIMY HH;tHP H tHHS@HL$H轶 H|$PH\$HH+HHHL$0 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH IU(I IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP H yHHH;t*IO HH;tHP H yHHSX?IO IHH;tHP Hi yHH;tHIO IWXH H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP H yI_I;_t/HIO* HI;GtHP H yI_HS@IW@H苴 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI虺 HI;GtHP H yI_I;_t/HIOj HI;GtHP H yI_HSXIWXH; H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3 HGHH;tiD  HS H { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3 HGHH;tiD  HS H { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   HB HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+IC H_@H_HH_PHW(HtLG8L+I H_(H_0H_8LGHT$0MHOM  HO LGHT$0MHOM  HO` H\$8H HH _@SH LHT$0MHM T HH [ @SH LHT$0MHM 4 HH [
 H H@SH H HHt
   
 HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH H HHt
   	 HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH HC HHt
    HH [@SH H# HHt
    HH [H(HID HHF H(H%v @SHPHD$ H H3HD$HHHHT$(H HHKD HHF  HD$@HrQHHL$(H=   r<ts HAH;rc H+HsS H'vF H HL$HH38  HP[H(HIC HH	F H(H% @SHPHD$ H H3HD$HHHHT$(H/ HHKC HHE * HD$@HrQHHL$(H=   r<t HAH;rs H+Hsc H'vV H HL$HH3H HP[H(HIC HHE H(H% @SHPHD$ H H3HD$HHHHT$(H? HHKB HHD : HD$@HrQHHL$(H=   r<t HAH;r H+Hss H'vf H HL$HH3X HP[H(HI B HH)D H(H% @SHPHD$ H H3HD$HHHHT$(HO HHK A HHC J HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vv H HL$HH3h HP[H(HI(#A HH9C H(H% @SHPHD$ H" H3HD$HHHHT$(H_ HHK(@ HHB Z HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3x HP[@SH HC HHt
0    HH [H HH H\$WH H HHH t
(   Hc HH\$0H _@SH HHHSH
 H3H
HJHH H\ HHH [H H@SH H HHt
    HH [@SH H HHH HE HH [KA A H(HQHI> HH@ H(H%R @SH HHQHI> HH> HH@ H [H% H\$WH H HHH H Ht
0   H HH\$0H _23HHBHBH@SH HHRHK HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+IQ WD$0Hl$@@tHT$HHtLD$XL+I" HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWHe HL$8Ht HT$@~ LD$HHT$8L+I H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWH HL$8Ht HT$@@~ LD$HHT$8L+I H\$`HP_@SH H[ HHt
    HH [H\$Ht$WH H HH3HIPH*Ht:HSX HK`HH+KPHHLI?LHSP H{PH{XH{`HS8HtLCHL+I H{8H{@H{HHK Ht:HS(~ HK0HH+K HHLI?LHS  H{ H{(H{0HKHt)HS| HSLCL+I H{H{H{Ht$8H' HH\$0H _@SH HYLHIHwx H;H [Hl$Ht$AVH0HHHQE3HIDt$ 5x H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHH蔶 Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ w H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQH顯 @SH0HD$     HQ8Hӵ HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0v I?HHD$0H;t?HHtLGL+Ih L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H HHHIVI+H*HHHH?HH;s(     IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   H2 HH\$0H _@SH  HD$HH H3H$p  ~ HH      HL$PG H HL$`- HH HH4  H$P  HL$Pw HxrH H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8J H3 HD$ Hh HL$   H$p  H3 HĀ  [HL$WH@Lx HH
Mx IL
Sx LL+1x ILVx M;s$K9<sIHH+
x HL2x L;rH\$XHt$hM;~  Hx HpHH;HBHHt$`hHw HHD$PHD$PH;sNH
w HD$PH;w=H\$PH+HH;w uH
w  H~w Ht;Hjw HH
$H;jw uH
Qw  HMw Ht
HH>w HH3w Hz    H
9w HD$`L
%w H;sLHD$`L;wBH\$`I+HH;
w u   H
v  H
v L
v HtGIH0H;
v u   H
v  H
v L
v HtH1H
v L
v Lv HH
v Hev Ht$hH\$XJH8H
v KHHvv H@_3Hc HD$0HL$ H HD$(H2 HD$  HT$HL$WH@HD$ H\$hHD$X   H=u H|$`   dHD$PWfu 3Hu LD$Pq Hu Wfu LD$XH
u ] Hu Hnu H
HL$XH
u HHu Hu Wfu fu Hu Hu fu H9u13HD$8H HD$0H& HD$(Hb HL$( HH\$hH@_H\$WH Ht 3H
t HH+HHt7D  HHtH Ht H
t HHH+HH;rHt HH   Ht H+HH;v H    H=   r<tg HBH;rW H+HsG H'v: HH H
s Wfdt H=Ut H6t H   H6t H+HH;v H    H=   r<t HBH;r H+Hs H'v HH H
Xs Wfs H=s Hs H   Hs H+HH;vU H    H=   r<t9 HBH;r) H+Hs H'v HHx H
r Wfs H=r Hr H   Hr H+HH;v H    H=   r<t HBH;r H+Hs H'vu HH H
*r Wf?r H=0r Ht}Hr H+HH;v2 H    H=   r<t HAH;r H+Hs H'v HX WH=q fq H\$0H _Lq L9q u0Hiq Hq     HHlq Hq H HHxq I@IHH
q H
q HHOq HH
}q H
q HHCq HH1q H
rq @SH HHHSH
 H3H
HJHHs H HHH [@SH H IHHHA    HD$0Ho HL$0H;sdHo HL$0H;wSH|$8H|$0H+HH;o u   H
o  Ho Ho HtHHH}o H|$80H;wo u   H
Yo  HUo Ht
HHFo HHH8o H [H) H@SH H HHـu
   ;HH [@SH@HD$ )t$0(HHo HHHo H;o r
   HHL$PHt
(3HH(t$0H@[HH3H\ HD$0HL$ H HD$(H HD$  H\$ WH H H3HD$3LA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HA,P  AO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3G H\$HH _kN  wN  N  N  N  N  N  AO  N  N  N  N  N  N  O  O  O  O  !O  *O  JO  SO  \O  eO  nO  uO   	
	
	
 	


	

@SH@eH%X   H)t$0(1
dN    )|$ (=/m
 Hȋ
9Rj    f]5Dn
 f_5s
 fYfX= l
 ffT=Ll
 f\(|$ ((fY
i
 fYk
 f\ff\fi (frfYfpc((fY%i
 fY
bi
 fX%j
 fX
i
 fYfYfX%k
 fX
*k
 fY(t$0fYfX
l
 f\f^fY%l
 fX%k
 fYf_H@[H
Xi  =Li foh
 H
7i fi  @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH H  HHـu
(   KHH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLHBg HH(H4g H;%g r
(   HHt$@Ht*H?HOXKHH^H~ HM HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^Hf HH(Hqf H;bf r
(   HH|$`Ht&H(XKHNH_w H~ HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(HWf.z
uI H^He HH(He H;e r
(   HH|$XHt&H(XKHH_w HΪ HH>HH\$PHt$`(t$0H@_HIHII      AD$HD$I#I;w]HB HL$HD$I#I;wAB^XAAHJ HBAHYJY^A\AI      LAHB L@HA IYI@Y^@\@AVH0HD$ H\$HHt$PH|$XIHLHRd HH(HDd H;5d r
(   HHt$@Ht*H?HK^OHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$XHt$`)t$0I(HHc HH(Hc H;c r
(   HH|$PHt&H(^KHqwH_ Ha HH>HH\$XHt$`(t$0H@_AID$I      HD$I#I;w,HQ BD$HD$I#I;wB\ABHA H      HH@WH@HD$ H\$XHt$`)t$0I(HHb HH(Hb H;ub r
(   HH|$PHt&H(\KHawH_ H HH>HH\$XHt$`(t$0H@_HIHII      AD$HD$I#I;wHHB @D$HD$I#I;w,YBXAAHBHJ @YBXAAI      LAHB L@AVH0HD$ H\$HHt$PH|$XIHLHRa HH(HDa H;5a r
(   HHt$@Ht*H?HOYKHH^H~ H HI6IH\$HHt$PH|$XH0A^HQIBD$HD$I#I      I;vH      HBB\AB@SH H HHـu
    軹HH [@WH0HD$ H\$HHt$PHHH*` HH H` H;
` r
    iHH|$@Ht%HKW
}e
 HH_H HH>HH\$HHt$PH0_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH H HHـu
0   軸HH [@SH HHHSH
 H3H
HJHH H HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3۵ H HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$HT HHoHH$   Hp_^]H	H%. @USVWAVAWH$xH  HD$PH H3HEpMADHH   D$     H/ HD$`HM  D$    E3E3HT$hHL$`ɳ HD$`HcHH HD`HD$`HcHDxDD\   HL$h HHL$` HH  HH  Hȋ HH  HH  HȺ   d HHr  HAI HI HH HUPHL$`U HxrH H
k HL$(3HL$0HL$8HD$@D$HHT$0HL$@ HQ HD$(HG HL$(! @SH H   H HH [H%< @SH HHHSH
ѻ H3H
HJHHc H̢ HHH [@SVWH  HD$8H͎ H3H$  IHHDL$0HL$@蒩 H HL$P0 HHU H$  HL$@ӧ H$  H$  HC$  HǄ$X     3H$P  $@  8uD
IIB8uH$@  ( HǄ$x     H$p  Ƅ$`   A"   H H$`   H$@  HD$ L$`  LD$0HH; @UVWH  HD$0H$  H H3H$  AAHH$  A|A@;   HL$@E H HL$P Hȋ$   H$`  HL$@聦 H$`  H$x  HC$`  HǄ$X     E3L$P  D$@  D8tIIB< uH$@   Hl$ L$@  DËHH$  H3 H$  HĐ  _^]@SVWH  HD$HHm H3H$p  AHHHL$P7 H HL$`
 HH 
 HH HHy 
 HH HHG 
 HȋW H$P  HL$P5 H$P  H$h  HC$P  H
{ HL$ 3HL$(HL$0HD$8D$@HT$(HL$8 H9 HD$ H]G HL$ 1 @SH HHHSH
 H3H
HJHH H HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu(@UVWHl$H   HEH$   HQ H3HE?HHHE7   3Hu/@uDFH HM& HE   Hu@uDFH HM HE   Hu@uDFH HM H|$ LMLHUHM HEHrPHHMH=   r<t HAH;ru H+Hse H'vX H HE   HuE HEHrPHHMH=   r<t HAH;r H+Hs H'v H] HE   HuE HE7HrPHHMH=   r<t HAH;r H+Hs H'v H HLCL+IHMHM?H3a H$   HĠ   _^]( (
 D$T$f (fYfYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
& fYfYfX& fX
. fYfYfX. fX(f^((Ŝ (
Μ D$T$f (fYfYfYfX fX
 fYfYfX fX
Ɯ fYfYfXƜ fX
Μ fYfYfXΜ fX
֜ fYfYfX֜ fX
ޜ fYfYfXޜ fX(f^(H8W)t$ f/(vbWY
  
P
 f/D$@   f.z$u"Y P
 X "   (t$ H8g X(t$ H8n 
\P
 f/D$@wHf.z u P
  "   (t$ H8(t$ H8H%
 LD$@H 艎 LD$@H w HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3r Hz HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHM IwHu@HH^H^uHtFHHHH;t?LLMt3 Iy HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHM I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHMG HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMH H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHXJ
 LqWMHHEIHEI~Ht3@ Hw HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM\ LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHMg L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;t<IHHt3 Hu HELuH}LE7HUHM& LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHMpg HMޣ HMӣ L$   I[(Is0I{8IA_A^]LWH   H
6G
 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tH Ht
H8t HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0; H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3ˡ Hs HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHMK I~H}@HH_uHt31 Hqr HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHM I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHM H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHXB
 LqWMHHEIHEI~Ht3 HPp HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM, LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHM` LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM>b HML L$   I[(Is0I{8IA_A^]LWH   H
@
 f/   HA\I[3IsHq ICD$hH9rt"H
՜ Ht
Hn HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0+ H$   HĀ   _@SH HHHSH
 H3H
HJHHC H HHH [AYAHAX@@@WH0HD$ H\$HHt$PHHHzD HH HlD H;]D r
    HH|$@Ht&HC
 (HDH_Hi HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HoH/ HHGH+HH    H:C HHH-C H;C rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDHXB HH(HJB H;;B r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHM HMHM j HELELEHM HMLHUNL+t	H
 HMi LHEHMHMHULL+t	H
 WD$PH}LHt3W Hi HHD$PH}HL$PLt$X3L;t-* HtHei HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$`v =;
    HEH   L   LD$PHH    H9V~EHE
 E
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3 HtHh HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$`$ HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HUG HD$@HD$`H|$HHFH;t'H;tH Ht
Hf HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM HL$@5 HL$P) I HM HM	 HM HM L$`  I[0A(sA({IA_A^_^]@SH HHI( HK HH [H% H\$Ht$WH@HY)t$0H H\$PHHHJ()|$ H(e HLGLCHLGIL+LtHE
 H\$XH~(|$ v Ht$`(t$0H@_H HHIH% @WHPHD$ H\$hHt$pHo H3HD$HHHD$@   3Ht$8@t$(DFHѴ HL$(苷 HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVHV HH;HKHtdHA   HqHyrHHH<H;Cu
   H HKHt(HA   HqHyrHHHT$(  貼 HC HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vr H HD$@   Ht$8D$( A
   H HL$(W HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H  HH;HKHtdHA   HqHyrHHH<H;Cu
   Hݪ HKHt(HA   HqHyrHHHT$(  | HC HL$(-z HL$HH3耯 H\$hHt$pHP_H\$WH H HHHIe t
(   H賶 HH\$0H _H1 H@SH H HHt
   f HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHHC H\$0HHHJa HLFLCHVLFIL+LtH
 HFH\$8HGHF Ht$@HG HH _HI HH H\$WH H HHH辚 t
(   HT HH\$0H _@SHPHD$ Hk H3HD$HHHD$@   HD$8    D$( A   H HL$(聳 HHHT$(PHD$@HrQHHL$(H=   r<t3 HAH;r# H+Hs H'v Hu HL$HH3 HP[HWH@H@HXHhHpIHHW@3HpVHH LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
  IPL+IIHL+IM;HCH;HCHL$( LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
B l IPL+IIHL+IM;HCH;HCHL$(\ LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+I藥 H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xHh H3Hp  I((Hǅh     Hǅ`      ƅP   A   H HP  艰 HHPH0  S HP  H@   H( HHɭ  H0  H0  聁 LHHAPHH  HrSHH0  H=   r<t HAH;rЌ H+Hs H'v H" HM0虂 HǅH     Hǅ@      ƅ0   A H`  H0  e H0  HM@4 H( HH  HH  HrSHH0  H=   r<t HAH;r H+Hs H'v HX H0  HM08 LHHAPHH  HrSHH0  H=   r<t HAH;r H+Hsw H'vj Hٯ HL$0O HǅH     Hǅ@      ƅ0   A H`  H0   XH0  HL$@ H(a HH  HH  HrSHH0  H=   r<tǊ HAH;r H+Hs H'v H	 H0  HL$0~ LHHAPHH  HrSHH0  H=   r<tG HAH;r7 H+Hs' H'v H艮 HHPHM~ HM H   ~ H    H  e~ H  ؇ Hh  HrSHHP  H=   r<t HAH;r H+Hsu H'vh H׭ Hp  H3X L$  I[A(sA({I]HUSWHHH  HD$ )p)xHd H3Hp  ((HHǅh     3H`  @P  DGHK HP  ϫ HǅH     H@  @0  E3HQ H0  蟫 HKHH0  P HH  HrSHH0  H=   r<tJ HAH;r: H+Hs* H'v H茬 H0   ~ HP  H@   H(H HHv  HKHH0  PHM0} HǅH     H@  ƅ0   A H`  H0  臩 H0  HM@V H(҄ HH  HH  HrSHH0  H=   r<t8 HAH;r( H+Hs H'v Hz HKHHU0PHL$0| HǅH     H@  ƅ0   A H`  H0  貨 XH0  HL$@| H( HHV 1 HH  HrSHH0  H=   r<t^ HAH;rN H+Hs> H'v1 H蠪 HKHHT$0PHǅH     H@  ƅ0   E3H H0   HKHH0  P HH  HrTHH0  H=   r<t HAH;r H+Hs H'v H HMz HM{ H   y H   a H  y H  G Hh  HrSHHP  H=   r<t HAH;r H+Hs H'vׄ HF Hp  H3ǡ ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHHp HHqHt$`3H.HnHcڅt3p HT HH^HwHt$`H.HnHt3D HT HH^Ho(Hw0Ht$`H.HnHt3 HTT HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHHo HHrHyH|$hE3L'LgHt3 HS HHwLu HsHt$hL&LfMt3` IS HLvHE(HC(L}8Ls0Lt$hM&MfMt3( IhS IM~HUH HUH HU0I HH\$pHl$xH0A_A^A\_^H\$WH HHHH HC(HSHOHG( HS0HO0 H\$0HH _@UVWATAUAVAWHpHD$ H$   HP] H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHn[ HcH;U|H
j |~ EL9e#  IIf     HD$@   Ld$8D$( A   Ht HL$(覤 IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH^ HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH HwHtoHF   LfH~rHH  H{sLCItHH~ 	HHL#HCHFHCHFHC   H{LcrH HG HL$Hg HL$(g AIcH;]}/H
v | H
h | H
: L| AH9u   I HD$@   Ld$8D$( A   HX HL$(膢 IIFH+HH;vJHLHT$(HL$H HH\ HL$Hf HL$(f HcH;]zH
 { HL$hH3 H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHHa HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC׽ HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;ICY HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC藼 HSHt
HHH
HB   H
$ Ny H
 @y LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
a x H
S }x HL$VWATAVAWH0HD$ H\$hHl$xHcLH/x II~@H|$pE3L'LgLgIHtIHHH;tǳHHHt3*z HjK HH_H_LHMI;~NL    

 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHy Mt
ITJ HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx HT H3HE`LHE3ADt$ HEX   LuP@}@EF H HM@ IE HU@IPHEXHrPHHM@H=   r<tx HAH;rx H+Hstx H'vgx H֜ Aމ\$$H9^H  ML=Kl Ht H
uw HL$@HT$PHMyv |$ E3HT$XHL$@>v HD$@HcHHp HD@HD$@HcHhT<HD$XHD$0HL$Xs L|$XLuDuHF@BHL$Pu A   EL9vP~S@ ff     H~@H^HIIH~ HL$P Ht AIIcH;FP|Ë\$$|$ HU@HL$@k ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   HO HD$@HcHHvo HD@HD$@HcHhT<L=j L|$XHL$X谤 HL$Xt HL$`s HMt É\$$IHcH;FH}$E3Xv Qv Jv Cv HM`H3> L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0u HKu HKH [H%t @SH HH   Zs H   HLcBADuluHT$0<s H [&s H   HLcBADuLt2H [H\$WH HH   HT$0/ L   I HcHBDuT$0@:tIr 2H\$8H _ðH\$8H _@SH HHT$0H    L   I HcPBDt2H [L$0Eu tT$0HK H|$8[ H   HT$0,r HHcQDu@fD  L$0t u8L$0t u)T$0_t$.tH   q H|$8H [T$0HK +[ H   HT$0q HHcQDtH|$8H [@SH HHT$0H    H   HHcPD
uT$0"tF9q H   HT$0 H   HHcPD
uT$0't2q HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33;s l$H,s ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @p Hv_H~HHfff     I   o HHu2Hv&H~HHfI   o HHu2j@SH   HD$@HL H3H$   HHL$0HA    HyrHH  H   HT$ @o HHcQDuAL$ q uL$  r T$ tHoX H   H   n HqH8 H$   H37 HĠ   [@SH HyHHA    rHH  HT$0H   n HHcQDufL$0Bq uL$0Cq T$0t6HW H   HT$08n HHcQDtH*   H [H   m H   H [H   HD$0HQK H3H$   HL$ D H$   H3# HĘ   @SH   HD$0)$   HJ H3H$   HHL$  (Wf.zu	H (H$   H3譌 ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5ۑ DH@ H   HUH0 HHcJD   UH:7   HD847uAH HEt
5
 5
 HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKXY HS`HtHCXHH
HB  H   l HvSHHHH   k HvHu.Hv(HHHD  H   k HvHuE3H Ht
 HKXHUHEHQ   @2LsH{rHHD0HU@H   ok HHcQDugH
     M@5n U@uB<:w2Hs,@HT H   HU@k HHcQDt
H   j @u<HC`H+CXHu,HEtHK@EHHUHK HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKXd HS`HtHCXHH
HB%H;Chu   HKX6 HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5
 BH;Chu   HKXͅ HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0vi HLcBAD u!L$04l uT$0H   6i H   HT$8} L   I HcHBDuT$8-tDIh H   HT$8@2@ H   HHcPD
uT$8+th @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(tYh 2H0A^H\$HHT$@Ht$XH|$( I   HHcPD
uT$@)   h IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@! IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINpR IVxHt:IFpHH
IFx   I;   u   INp IFxHtH0IFxkI;FPu	IN@g IFHHt0IFHHHl$PI   HT$@ I   HHcPD
uT$@)t#f 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INpA IVxHt7IFpHH
IFxI;   u   INp
 IFxHtL8IFxU@UH0HHT$@H    H   HHcPD
uT$@(te 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   Oe HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMX HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMp艀 HUxHt:HEpHH
HEx   H;   u   HMpR HExHtL0HExtH;Ehu   HMX) HE`HtL0HHE`HHt$PH   HT$@5 H   HHcPD
uT$@)t"c 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMpp HUxHt7HEpHH
HExH;   u   HMp< HExHtL8HExV@SH HHT$0H   F H   HHcPD
uT$0(tb 2H [HT$0H|$@
 H   HHcPD
uT$0)   b Ht$8HH   HT$0 H   HHcHDuT$0,tH   ?b Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKp} HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp} HSxHt@HCpHH|$@H
HCxH [H;   u   HKpP} HCxHtH8HCxH|$@H [H;   u   HKp} HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH    H   HHcPD
uU(t` 2H([]Ht$HHz AH|$PHH˄t
   AH? H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@A MM;~fHUHK@@ EȉE;}HCpHUHCxH    H   HHcPD
uU,t_ Ht$H2H|$PH([]ò.H~tAHh Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8A ,Ht'HrHUHEHKpA ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp@ HMHHMH;v)Hh뒐HUHKps@ HEHHEH;s)H9`@UH0HHT$@H   V H   HHcPD
uT$@ct)] AHǂ HḦ́tH0]HH0]AH~ Ḧ́t
H0]AH Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@7x HUHHt%HE@
H;EPu	HM@x HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@w HUHHt%HE@
H;EPu	HM@w HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@= Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+Iu H{pH{xH   HSXHtLChL+Imu H{XH{`H{hHS@HtLCPL+Id H{@H{HH{PHK CE HH\$0H _1E @SH0H3HQ D$ IE3HHC   HC蠁 HH0[@SH0HD$     HQpH> HH0[@SH0HD$     HQ@HS' HH0[@SH0HD$     HQXH> HH0[@SH   HD$@H7 H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H   % L   I HcHBD   T$ <tIY    -H   Hi   HǄ$      HǄ$       D$pA   Hh~ HL$p~ HD$pH$   HCD$pH
jc HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   Y HR HD$PA;  H~ HL$P 2H$   H34x H   [HUATAUAVAWHl$H  HEHXHpHx H5 H3HEpHLHMH}F HLiLl$03I} I} IE M|$L|$0I?I  II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIG* HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	i
 uH;s3H;t.LuLEI薢 LH HD$ LHT$0I H\$0HK@HT$8:/ HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  H} HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  H| HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  H| HT$hHtLD$xL+Iq^ WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$. HHT$8/ HM> HT$PHtLD$`L+Ian HT$8HtLD$HL+IFn HT$hHtLD$xL+I*n WD$hH|$xHUHQLEL+Im <\V UV NV GV @V 9V 2V +V $V V V V V V HMIHMpH3r L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+I(m H{H{ H{(HHtLCL+IT\ H;H{H{H\$0H _H\$WH HQ3HHtLA(L+Il H{H{ H{(HHtLCL+Il H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0J Hw HL$@8 Ht3HwHw HL$@ H;sHvu HL$@ HH;rHqw HL$@ HHQ HHIw ԰ HT$0HHD$0HcHHL HD0HD$0HcHhT,HG HD$HHL$H HL$HQ HL$P"Q H$   Q HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tߋHHHt3BR H# LHD$(Lt$(H\$0H\$8HH~AL    M
 HIH;u(WHHH;|HMH;|HL$PH Hu HL$`D Ht3HnAHL$`O H;sHs HL$` HH;rH}u HL$` HHO HHIs  HHO HH:u Ů HT$PIHD$PHcHHJ HDPHD$PHcHhTLHE HD$hHL$h HL$hO HL$pO H$   O IP IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   Hf, H3H$  ILHH$   LL$83ۉ\$0HHYMt3;P H{! HH~D$0   HǄ$      H$   Ƅ$    A   EHt H$   s HǄ$      H$   Ƅ$    EGHs H$   s HǄ$      H$   Ƅ$    EGHs H$   ys HHL$`_HD$ L$   L$   H$   IUYHT$`HtLD$pL+Ig WD$`H\$pH$   HrTHH$   H=   r<tO HAH;rO H+HsO H'vO Ht HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<tYO HAH;rIO H+Hs9O H'v,O Hs HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<tN HAH;rN H+HsN H'vN Hs HǄ$      H$   Ƅ$    A
   Hq H$   q IL$   HT$xIPH$   HrTHH$   H=   r<t+N HAH;rN H+HsN H'vM Hmr HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;v7M H    H=   r<tM HAH;rM H+HsL H'vL H]q HH$  H3i H  A_A^_^[LSVWAVH  IǃXH' H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFH
p IpIo HǄ$      L$   D$   EF
HIo H$   o HǄ$      L$   D$   EFHo H$   n LHHL$H[HD$ L$   L$   H$   HTHT$HHtLD$XL+Ic WD$HLt$XH$   HrTHH$   H=   r<t:K HAH;r*K H+HsK H'v
K H|o HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<tJ HAH;rJ H+HsJ H'vJ Hn HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t>J HAH;r.J H+HsJ H'vJ Hn HǄ$      L$   Ƅ$    A
   Hm H$   l HL$   HT$xHPH$   HrTHH$   H=   r<tI HAH;r~I H+HsnI H'vaI Hm HǄ$      L$   Ƅ$    DDHT$xHL$H蟻 HHHHHHJHCHBHKHJHCHBHKHL$H
H HT$xHtL$   L+If` HH$  H3e H  A^_^[LWH   ICI[H# H3H$   HHT$ IC   3I{@|$pDG
Hk IKhk HD$h   H|$`@|$PDGHQl HL$P?k LHT$pHL$P( HD$hHrQHHL$PH=   r<tG HAH;rG H+HsG H'vG H/l HD$h   H|$`D$P H$   HrQHHL$pH=   r<t{G HAH;rkG H+Hs[G H'vNG Hk HǄ$      H$   D$p A
   H_j HL$p-j HD$h   H|$`D$P A   H$k HL$Pj LHT$pHL$P% HD$hHrQHHL$PH=   r<tF HAH;rF H+HsF H'vF Hj HD$h   H|$`D$P H$   HrRHHL$pH=   r<t>F HAH;r.F H+HsF H'vF Hj H$   H3b H$   HĠ   _@SH   HD$HH  H3H$   HHT$ HD$h   HD$`    D$P A
   Hh HL$Ph HǄ$      HǄ$       D$p A   Hi HL$pah LHT$PHL$p辺 H$   HrQHHL$pH=   r<tE HAH;rD H+HsD H'vD HNi HǄ$      HǄ$       D$p HD$hHrRHHL$PH=   r<tD HAH;rD H+HssD H'vfD Hh H$   H3Ta HĠ   [AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ D AXA((yXA@^A(]\A(\YYAX(q
 K8W
 Ys ^C0\(љ
 D\YDYCDX(DC藙
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hH H3HD$0HHHT$(H< HHHA   3HqHyrHH@0IE3f Hs(Hs0s8s@C<H6* HHL$0H3_ H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH+ H3Hp  DHH  f  LAHf HP  L Ldf HH0   LHHAP HH  HrSHH0  H=   r<tA HAH;rA H+HstA H'vgA He HǅH     3H@  @0  Hh  HrSHHP  H=   r<tA HAH;r	A H+Hs@ H'v@ H[e HǅH     H@  ƅ0   A&   Hee H0  c HH0  HP HH  HrSHH0  H=   r<tu@ HAH;re@ H+HsU@ H'vH@ Hd HǅH     H@  ƅ0   E3H\ H0  (c HH0  HP HH  Hy  HH0  H=   r<t? HAH;r? H+Hs? H'v? Hd !  C  3A;  HǅH     H@  @0  DG9H*d H0  fb HH0  HP HH  HrSHH0  H=   r<t? HAH;r? H+Hs> H'v> HTc HǅH     H@  ƅ0   A   Hc H0  a L0  Hc HP  Ǭ LHHAP Hh  HrSHHP  H=   r<tV> HAH;rF> H+Hs6> H'v)> Hb Hǅh     H`  ƅP   HH  HrSHH0  H=   r<t= HAH;r= H+Hs= H'v= Hb Dv(WI*(Y H,ȉN,Y
p H,F0D+D+Dv4Hǅh     H`  ƅP   A9   Hb HP  T` HHP  HP HP  $ Hǅh     H`  ƅP   A/   Hb HP  ` HHP  HP HP  v$ H0  2 Hb H@  V HȋV,: HH0  HPHM02 Hib HM@  HȋV49 HHU0HPHL$0M2 HUb HL$@ HȋV09 HHT$0HPHǅh     H`  ƅP   E3HX HP  _ HHP  HP HP  # HMj0 HM9 H   S0 H   9 H  90 H  9 Dv(DF,DN0N4~8N@AAF<Hp  H3mX L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   H2a HH^ HT$(HH  HHOH6HH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHIK8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKH讕,CHE3L% fnHGLH(X^^Y%r L9G~    MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKH衐C8L|$ Lt$PHl$@H(_[ÍAC82H(_[H  @SH A HS HHH! HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLH! IIv@H$   3H>H~Ht3p7 H HH^ D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$Hg IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tH6 Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@i H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx H H3HEPLLHEH   HE@    E0 A)   H\ HM0zY IHU0IPHEHHrPHHM0H=   r<t/6 HAH;r6 H+Hs6 H'v6 HqZ HL$0+ IF@HL$@;3    I9vH~:~D  I^@HV HL$@[ H3 HHcI;FH|HU0HL$0) MHIAPHEHHrQHHM0H=   r<tU5 HAH;rE5 H+Hs55 H'v(5 HY HD$0HcHH- HD0HD$0HcHhT,H( HD$HHL$Hb HL$H2 HL$P"2 HM2 HMPH3Q L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   HT HHYW HT$(HHT4 HHOH&HH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHIvK8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKHo,CHLOLH|$H % fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^Y{ L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0謓 HKHC8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A HoN HHH HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pH H3HEHHE   3H}@}DG<HW HMnT HHUHP HEHrPHHMH=   r<t#1 HAH;r1 H+Hs1 H'v0 HeU HE   H}E A   HxW HMS HHUHP HEHrPHHMH=   r<t0 HAH;r0 H+Hst0 H'vg0 HT HE   H}E AC   H	W HMPS HHUHP HEHrPHHMH=   r<t0 HAH;r/ H+Hs/ H'v/ HGT HE   H}E A/   HV HMR HHUHP HEHrPHHMH=   r<tv/ HAH;rf/ H+HsV/ H'vI/ HS HE   H}E A<   HU HM2R HHUHP HEHrPHHMH=   r<t. HAH;r. H+Hs. H'v. H)S HE   H}E E3HUK HMQ HHUHP HEHrPHHMH=   r<t[. HAH;rK. H+Hs;. H'v.. HR HE   H}E E3HJ HMQ HHUHP HM HMH3J H\$hH|$pHP]@USVWATAVAWH$ H  HD$HH H3H   ىL$@DD$0DL$8LH  LP  HX  Hǅ      3H   @}pDGHT HMp[P HEh   H}`@}PkT MA!H[T HMP*P    Hǅ      H   @   DGHa H   O Hǅ      H   @   DGHa H   O H   HD$ L   LD$@HUpHMP& HEhHrPHHMPH=   r<t], HAH;rM, H+Hs=, H'v0, HP HEh   H}`EP H   HrPHHMpH=   r<t+ HAH;r+ H+Hs+ H'v+ H2P Hǅ      H   ƅ    A   HS H   N Hǅ      H   ƅ    R MA!HR H   cN H    H    HEh   H}`EP A   HR HMP#N Hǅ      H   Ep -R MA!HR HMpM LD$0HUPHMp HMp_ HMPU HEh   H}`EP A   H@R HMPM Hǅ      H   Ep Q MA!HQ HMphM LD$8HUPHMpU HMp HMP |$0fn|
 Y
 D,L$8  ;tCt
Ù   HL$P IHL$`誊 HQ HL$`i IcHMP& HHL$`ϡ Hȋ' HH^Q 5 Hȋ& kd   HMP;& HH5Q HL$` HHt Hȋ& HHQ څ HQ HL$`Ʌ IHL$` HHT$PHPHM HM
' H   H3E H  A_A^A\_^[]@UVWAVAWHl$H   HEH$   H H3HE/IHLHE   E3L}D}EGHWP HM~K HE   L}D}HD8?uE
LIB< uHHMFK LHUHM HEHrPHHMH=   r<t' HAH;r' H+Hs' H'v' H:L HE   L}E HEHrPHHMH=   r<t' HAH;r~' H+Hsn' H'va' HK HE'   L}E A   H3O HMJJ HE   L}E A   H,O HM#J HE   L}E ? u
I     HÀ< uLHHMI LFIcN(L;tL$ LMHUHM HEHrPHHMH=   r<t& HAH;rx& H+Hsh& H'v[& HJ HE   L}E HEHrPHHMH=   r<t& HAH;r& H+Hs% H'v% H`J HE   L}E HE'HrPHHMH=   r<t% HAH;r% H+Hs% H'v% HI HM/H3zB H$   HĠ   A_A^_^]@USVWAVHl$H   HEHF  H3HE/IHLHE   3H]]DCHBM HMH HE   H]߈]8uDIIB< uHHMG LHUHM՞ HEHrPHHMH=   r<t$ HAH;r$ H+Hsx$ H'vk$ HH HE   H]E HEHrPHHMH=   r<t.$ HAH;r$ H+Hs$ H'v$ HpH HE   H]E A   HL HMF HE   H]E ? uLIIB< uHHMF LHUHMT HEHrPHHMH=   r<tg# HAH;rW# H+HsG# H'v:# HG HE   H]E HEHrPHHMH=   r<t" HAH;r" H+Hs" H'v" H?G HE'   H]E A   HJ HME HE   H]E A   HJ HME HE   H]E ? uLI IB< uHHMZE HFEF(D;tHD$ LMHUHM膠 HUHrHA   HMi$HE   H]E HM	 HM	 HE   H]E A   HI HMD HE'   H]E ? tHfD  HÀ< uLHHMD LHUHM HM
	 HM	 HM/H3W> HĠ   A^_^[]HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt3  HE HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHMP LvLu@II^I^uHtFHHHH;tXLLMt3@ I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHMO ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+tYu
 II^H\$XH    HC    HC    HtFHHHH;tWHHHt3 H( HH{H{LHSE3L9C~JL    
] 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH0HD$ H\$`MHHHJs HHHFHGHHFLL+tt
 H_H\$XININ8 HHIFHCIFHCIIFIFLL+ts
 HFG(LHF HMHF HHH\$`H0A^_^H\$Ht$WH`HLHE HlHHs3HD$ HGH;t'H;tH/ Ht
Hj HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@	 H\$xH$   H`_H\$Hl$VWAVH`HLHE HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH Ht
H1 HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@Ȉ L\$`I[(Ik0IA^_^SH\$UVWHHpHcy(3H)t$`WuH9yt"H	 Ht
H? HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM{J Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tH Mt
IV HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHMxI H$   Hp_^]QHUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;teQLLMt3 I HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHMJ WEIHEIHt3 H\ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHMI LEHUI4HM HMv IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;tEOLLMt3 I HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHMI WEIHEIHt3 H> HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHM(I LEHUIHMd HMY IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HEHXHp H H3HE'LHHE   3H]]DCH= HM7 HE   H]׈]DCH= HM7 HE   H]]n= MA-H^= HM}7 AD$(DF(D;tD$ LMHUHM| HEHrPHHMH=   r<t HAH;r H+Hs H'v H^8 HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H7 HE   H]E HEHrPHHMH=   r<tH HAH;r8 H+Hs( H'v H7 I$HEI|$HFH;t'H;tH Ht
HI HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~HE(A)HH;}LEMHM H~ID$HEM|$L}Md$ HOI;uL9gt`Mt$MtHHIL;tJMMHOL;tH  Mt
I[ HHLLgHHMLGLEHEHEHEHEHEHEH}LGIHH+HHHH~ D  HE()HH;}HMHM~ HHM'H3m. L$   I[@IsHIA_A^A\_]@UVWHl$H   HEH$   H1 H3HE7HHHE/   3H]']DCH: HM4 HE   H]]DCH: HM3 HE   H]]: MA.H9 HM3 F(DG(D;tD$ LMHUHMQx HEHrPHHMH=   r<tT HAH;rD H+Hs4 H'v' H4 HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H,4 HE   H]E HE/HrPHHMH=   r<t HAH;rp H+Hs` H'vS H3 HHMLLEHEHEHEHEHEHE'H}/LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHMr HOLFLEHFHEL	LMHAHEHUHUHUHUHUHU'HM/LQLIHH+HHH~+     A(fAXA)HH;}
LELMMHHM HHM7H3/+ H$   Hİ   _^]@UVWHl$H   HEH$   H H3HE?HHHE7   3H]/]DCH6 HM0 HE   H]]DCH6 HM0 HE   H]]6 MA.H6 HMs0 F(DG(D;tD$ LMHUHMu HEHrPHHMH=   r<t
 HAH;r
 H+Hs H'v HV1 HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v} H0 HE   H]E HE7HrPHHMH=   r<t@ HAH;r0 H+Hs  H'v H0 H}HHMLLEHEHEHEHE'HEHE/HEHE7LOIHH+HHHHH~% A(f^A)HH;}
HMLEMHMr HOHMLFLEHFHEL	LMHAHEHEHEHEHE'HEHE/HEHE7LQLQIHH+HHH~2@ fff     A(fA^A)HH;}
LELMMHHM HHM?H3' H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM^ LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMH HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHMk HH\$xH`]H\$Ht$WHPeH%X   HC    )t$@HЋ9ܰ    HcF(3HfnY5y ~nHFHl$`Hn)|$0=; H4   D)D$ EWf     HH(TfA.zt	]
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
, ?& =  D H
 Xߩ YG  % @USVWAVHl$H   HEH H3HE/IHLHU3ۉ]HE   H]]DCH/ HM) HE   H]]DCH. HM) HE   H]]0 MA-H/ HM^) LFIcN(L;tL$ LMHUHM~ HEHrPHHMH=   r<t HAH;r H+Hs H'v H@* HE   H]E HEHrPHHMH=   r<t HAH;r H+Hst H'vg H) HE   H]E HEHrPHHMH=   r<t* HAH;r H+Hs
 H'v Hl) HE   H]E A   H. HM' HE   H]E f. MA-HV. HM' LHUHMt HEHrPHHMH=   r<tg HAH;rW H+HsG H'v: H( HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H?( IFHEHuEELuHH_IvHt3 H HHwHUHM3 IHEIvHGH;t'H;tHy Ht
H HHHwLLEHEHEHEHEHEHEH}LOIHH+HHHH~3fff     HEHHE(fXA)HH;}LEMHM6 HM HHM/H3 H   A^_^[]@SH HHI HH [H% HT$WH0HD$(H\$@HHD$     IHHH$   HKA H8 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJD HHHGHFHHGLL+tW
 H^H\$HHOHO 	 HHHGHCHG HCHWHGHG LL+tW
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHHHK!  H  HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHGHOd
 H[
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3
 I> HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHM{/ HwHu@HH^uMt3a
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHM. Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ HHIFHFIIFLL+tT
 InH~H$   3HH_WD$(Ht3N
 H HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$H- IFF HHpA^_^][@USVWAVHl$H   HEHv H3HE/IHHHMHJ HHHGHFHHGLL+tZS
 LvLuHK| HIHCIFHHCLL+t%S
 HGF HE   3H]]DCH& HM HE   H]߈]DCH% HM HE'   H]]y& MA#Hi& HM HFDF D;tHD$ LMHUHMz HE'HrPHHMH=   r<t'
 HAH;r
 H+Hs
 H'v
 Hi  HE'   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 H HE   H]E A   H" HM HE   H]E $ MA#H$ HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hsp
 H'vc
 H HE   H]E HEHrPHHMH=   r<t&
 HAH;r
 H+Hs
 H'v
 Hh HE   H]E A   H$ HM HE   H]E # MA#H# HM MHUHMp HM&  HM  HHM/H3l Hİ   A^_^[]@UVWHl$H   HEH$   H1 H3HE7HHHE   3H]]DCH  HM HE/   H]']DCH  HM HE   H]]" MA+H" HM LGHcN L;tL$ LMHUHMp HEHrPHHMH=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 H HE   H]E HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H+ HE/   H]'E HEHrPHHMH=   r<t
 HAH;ro
 H+Hs_
 H'vR
 H HE   H]E A   H! HM; HE   H]E S! MA+HC! HM
 LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tR
 HAH;rB
 H+Hs2
 H'v%
 H HHEHHFH;t'H;tH
 Ht
HU HHH~HHMHEHEHEHEHEHEHuLFIHH+HHHH~'@      HE()HH;}HMHMb HM7H3p H$   Hİ   _^]@UVWHl$H   HEH$   H1 H3HE7HHHE   3H]]DCH HM HE/   H]']DCH HM HE   H]], MA.H HM LFHcO L;tL$ LMHUHMl HEHrPHHMH=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 H HE   H]E HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H+ HE/   H]'E HEHrPHHMH=   r<t
 HAH;ro
 H+Hs_
 H'vR
 H HE   H]E A   H HM; HE   H]E  MA.Hs HM
 LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tR
 HAH;rB
 H+Hs2
 H'v%
 H HHHEHvHGH;t'H;tH
 Ht
HQ HHHwHHMHEHEHEHEHEHEH}LGIHH+HHHH~#     HE()HH;}HMHM^ HM7H3p H$   Hİ   _^]H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	,
 Ht
Hg HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHM  Hcw HuH9wt"H
 Ht
H HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHM (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 Hʿ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHMB! WEHHE'H~Ht3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHM  LEHUIHM1
 HM&
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHM  WEHHE'H~Ht3
 HL HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM8  LEHUIHMt
 HMi
 IL$   I[(Is0IA^_]HUWAVHhH   HEHXHp H H3HE7LHHE   3H]]DCH HM HE   H]]DCH HM HE/   H]']: MA.H* HM AF DF D;tD$ LMHUHM.S HE/HrPHHMH=   r<t1
 HAH;r!
 H+Hs
 H'v
 Hs HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H	 HE   H]E HEHrPHHMH=   r<t]
 HAH;rM
 H+Hs=
 H'v0
 H IHEI~HFH;t'H;tH%
 Ht
H` HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~ @ HE(A)HH;}LEMHMW H~IFHEMvHGI;t'L;tHy
 Mt
I费 HHLwHHMHEHEHEHEHEHEH}LGIHH+HHHH~&fff     HE()HH;}HMHM\V HHM7H3 L$   I[0Is8IA^_]@UVWHl$H   HEH$   H H3HE7HHHE   3H]]DCHx HMg HE   H]]DCHl HMC HE/   H]'] MA/H HM F DG D;tD$ LMHUHMO HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE/   H]'E HEHrPHHMH=   r<tJ
 HAH;r:
 H+Hs*
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H" HHMLLEHEHEHEHEHEHEH}LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHMҨ LGHNHMMLMHEHEHEHEHEHELEM@IHH+HHH~.@      (fAXA)HH;}
HMLMHHMR HHM7H3 H$   Hİ   _^]@UVWHl$H   HEH$   Hq H3HE?HHHE   3H]]DCHX HMG HE   H]]DCHL HM# HE7   H]/] MA/H HM F DG D;tD$ LMHUHML HE7HrPHHMH=   r<t
 HAH;r
 H+Hst
 H'vg
 H HE7   H]/E HEHrPHHMH=   r<t*
 HAH;r
 H+Hs

 H'v
 Hl HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H H}HHMLLEHEHEHEHEHEHEHEHELOIHH+HHHHH~% A(f^A)HH;}
HMLEMHM HGHEHNHML LEHUHUHUHUHUHUHUHULHIHH+HHH~&@ A(f^A)HH;}
HMLEMHHMo HHM?H3 H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHM{ HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM计 HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM+ HH\$xH`]@SH@Hy HQHuWHHL$ HD$ HT$0 (fnC 
hl X
h Y́ YXH@[HUVWAVAWHhH0  HD$PHX )pH[ H3HEMHHHT$@3|$4HE   H}@}DGH- HM$ HE   H}@}DGHX HM HE   H} @}
 MA.H	 HM IGDF D;tHD$ LMHUHM\ HEHrPHHMH=   r<tm
 HAH;r]
 H+HsM
 H'v@
 H HE   H} E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HE HE   H}E HEHrPHHMH=   r<t
 HAH;r
 H+Hsy
 H'vl
 H HE   H}E A   H& HMU  HE   H}E ] MA.HM HM$  MHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H}E HEHrPHHMH=   r<tl
 HAH;r\
 H+HsL
 H'v?
 H  H;H{LvMt3>
 I~ HLsIHD$pHFHEHHEHvL;t'I;tH
 Ht
H< HH;HsHHEHEHEHD$`HEHD$0HEH]LsIHH+HHHH~BHE(4HE()D$@HL$@!HD$p(fYfXHM)4HH;|MHHM HHMH30 H$x  ($   H0  A_A^_^]HT$WH0HD$(H\$@HHD$     IH/HH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+t0
 H_H\$HHN讪 HHHFHCHVHFLL+tV0
 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHH$HK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     I"HHHO
 H{
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHO$
 H
 HH\$@H0_HW  @SH0HD$     HQH胺  HH0[H\$WH HHQHtLAL+I  3HCHCHCH H@t
    H HH\$0H _@SH HQHHt.LAL+I  3HCHCHCH! HH [H HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXH_
 D$(HD$0HT$83HL$ HD$8HD$@H HD$ 
 H Hs HD$0HL$0 H\$WH HHQ HtLA0L+I  3HC HC(HC0H H@t
8   He HH\$0H _@SH HQ HHt.LA0L+I>  3HC HC(HC0H HH [H HH [@SH HHHSH
1
 H3H
HJHH
 H HHH [HAHH`HAHH`H\$WH H HHAH蝽  H HGHt
8   HU HH\$0H _@SH H3 HHAHC  H HCHH [@SUVWATAUAVAWHxHD$(Hg H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HH HHHL$ H HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ H
 HIFHAIFHAIFHAH IV   H HHN  L-Y L.H IGIOʻ  MoM/H  I  IV HtMF0L+I  3IF IF(IF0M.HHL$`H3 HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+I  H{pH{xH   HK8]  HS HtLC0L+IT  H{ H{(H{0H HH\$0H _H\$WH H,   t
  H HH\$0H _H\$Ht$WH H  HHt*L  L+I  3H  H  H  H5) H   H  HKpH=n HKPH{@聸  Hs@HKHs8H{l  HsH3H\$0Ht$8H _HL$SH0HD$ HH HLALD$HH  I HBI@HIHHA   HA    HyrHH  IE3  HH0[HL$WH0HD$ H\$PHHHk HHBHAHBHAHBHAH H 裱  HO8HL$HHz HHC@HAHCHHAHCPHAHSXH   HSpHOp\  HH\$PH0_@SH HHI HtCHS(y LC0H*L+C IHLI?LHS   3HC HC(HC0H< HH [H\$WH Ht
   Hb HH\$0H _H\$WH H<t
8   H" HH\$0H _H\$Ht$WH HHHHU
 + HH * HH
 * HHW/ HH(1 
 HG
 H* HH * HH
 * WPH0
 HH0 `
 H%
 Hy* HH j* HH
 [* H
 HH0 
 H
 H1* HHG "* HH
 * WH
 HHM0 
 O|tttt3   H
 H) HH ) HH
 ) Hȋn
 HH/ f
 O|  [  	  H
 Ha) HH R) HH
 C)    H
 HHz/ 
 H
 H) HHS ) HHH
 (    H
 HH./ 
 H
 H( HH ( HHD
 (    Hl
 HH. d
 Hy
 H}( HH n( HH(
 _(    H 
 HH. 
 H
 H1( HH "( HHT
 (    H
 HHH. 
 HO
 H' HHQ ' HHN
 '    Hl
 HH- |
    tB  H=
 H' HH r' HH
 c' H   H
 HH' HH 9' HH
 *' H W  L   H?K H|
 H ' HH & HHK
 &    Hj
 HH- 
           H H& HH  & HH
 t& HH e& HH, -
 L   H6K L   HK L   HH6 J L   HK L   HHy I L   HK L   HH$ GI #  HW  H% HHQ % HH6
 % HH % HH+ ^
 L   HgJ L   HJ L   HHg I L   HJ L   HH H L   H.K j  Hn
 H
% HH $ HH
 $ H   H
 H$ HH{ $ HH
 $    Ht
 HH* l
 H
 H$ HH; v$ HHh
 g$    H
 HH* 
 Ht
 H8$ HH )$ HH+
 $    H
 HHQ* 
 L   HH H
 H# HH # HH8
 #   Hf
 HH) v
 H[
 H# HHu # HH
 q#   H
 HH) (
 H%
 HA# HH7 2# HH,
 ##    H
 HHY) 
 H`
 H" HH " HH_
 "    H}
 HH) 
 H
 H" HH " HH
 "    H/
 HH( ?
 H
 HX" HH~ I" HH
 :"    H
 HHo( 
 H
 H
" HH@ ! HHe
 !    H
 HH!( 
          tB  H
 H! HH ! HH
 x! H9   H
 H]! HH N! HHx
 ?! H l  HH
 H$! HH ! HH
 ! HH   HH=' 
 L   HH~ aE   Ha
 H  HH   HH0
     H`
 HH& X
    tzt?   HL
 HX  HH I  HHK
 :  H jH&
 H"  HH   HH
   H} 4H
 H HHR  HH
  H' H H& H
 y tIH. H HH  HH | HHWX# HH% 8
     tLH HH HH 9 HH * HH   K# HHa% 
 H H HHj  HH  WxHi
 HH% 
 H
 H HH$ H\$0Ht$8H _H%j
 H%
 @WHPHD$ H\$hH͜ H3HD$HHHD$@   3H|$8@|$(E3HQ HL$(  HT$(H蓶  HD$@HrQHHL$(H=   r<tT
 HAH;rD
 H+Hs4
 H'v'
 H H   H   H  HHL$HH3 H\$hHP_@UVWATAUAVAWHl$H   HEH$   Hɛ H3HEA؉]HLHUE    A}NH^
 HE3HEHEH HEEHUHM۾
 Hĸ HEHX HM H    HB    HB    E   HE   HE    E A   Hp HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtH 
 u
HJ  H{rHHA   I;LBMtH c
 u
H  H{rHHA   I;LBMtH (
 uDHu>LFIH+HgfffffffHHHH?H  IHd  HF   H{H{rHH?A   I;LBMtH  H
    Hs	3Hu{A^HE   HE    EIE3HUHM{  ]HUH܂  HM¥  3IV(HEH;tIE3HMC  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHM  DmHUH  HM  HEHrPHHMH=   r<t+
 HAH;r
 H+Hs
 H'v
 Hm HNH
 HE3HEHEHt HEEHUHM6
 H HEHT HMq HMH3 H$   Hİ   A_A^A]A\_^]  @SH HH(  HKH [  @UVWATAUAVAWH$@H  HD$8H$  H% H3H   MH=G HL$@  HHPHH HL$P HHt }H HL$P^ z  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<Hr HL$P  HHS$ HHB  HHD$ T
 HL$(Lt$ I+IHHLI?LAxoIcH<HL@ ff     K4H HL$P{ HH HH a HBT7 #
 Md$HAxLt$ H HL$P, HHr 
 HL$ Ht2HT$(c HL$0H+L$ IHHLI?LHT$ O  HU`HL$@葮  H8= tSHEX   HEP    E@ A	   H+ HM@
  LE@HU`H   |  HQ H    H= tSHEX   HEP    E@ A   H HM@  LE@HU`H   z  HgI H   9 H< tSHEX   HEP    E@ A
   H HM@L  LE@HU`H   x  H@J H    H< tSHEX   HEP    E@ A
   H> HM@  LE@HU`H   v  HS H   { H< tXHE`H}xHCE`H
[
 HM@3HMHHMPHD$ D$(HUHHL$ ܶ
 H5 HE@HV HM@ H< tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ x
 H HE@HN HM@ Ht< tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H5 HE@HS HM@O HP< tXHE`H}xHCE`H
/
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H^J HM@ H,< tXHE`H}xHCE`H
˾
 HM@3HMHHMPHD$ D$(HUHHL$ L
 HE HE@H2M HM@ H< tXHE`H}xHCE`H
g
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H) HE@HN HM@# H; tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@HrI HM@ H; tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$  
 H9 HE@HVJ HM@[ H; tXHE`H}xHCE`H
;
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@HjM HM@ HEX   HEP    E@ A   Hw HM@  LE@HU`H   p  HrK H    HL$WH0HD$ H\$HHHHs
 HHQ3HHBHK
 H! HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHKq
 Ha
 HHSHOHA   HA    HyrHH  IE3   HH\$HH0_HL$WH0HD$ H\$HHHHS
 HHQ3HHBHK
 HY HHSHOHA   HA    HyrHH  IE3p  HH\$HH0_@SH HHHSH
Ѻ
 H3H
HJHHc
 HD HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 HQ HHSHOHA   HA    HyrHH  IE3  HH\$HH0_@SH HHHSH

 H3H
HJHH
 H4 HHH [@SH HHHSH
 H3H
HJHHS
 H HHH [@SH HHHSH
 H3H
HJHH
 H, HHH [@SH HHHSH
A
 H3H
HJHHӯ
 H HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 H! HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH HG HHH>  H_
 HOHj
 t
8   H HH\$0H _H\$WH H
 HHHޗ  H
 HOH

 t
8   H HH\$0H _H\$WH Hߨ HHH~  H
 HOH
 t
8   H0 HH\$0H _H\$WH HG HHH  H?
 HOHJ
 t
8   H HH\$0H _H\$WH HG HHH辖  H߶
 HOH
 t
8   Hp HH\$0H _@SH0HD$ HH HH
 HA(H0
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HH HH
 HA(H0(
 H HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH HH
 HA(H0
 H8 HHKHtHP tHC    H0[@WH0HD$ H\$@HH HH>
 HA(H0H
 Hѫ HHKHtHP tHC    @t
@   H HH\$@H0_H\$WH HH| HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   T L   H988L  M+IHLI?LI  3H   H   H  H   ؠ  H   H [H%E
 HL$SH0HD$ HH3 HE3LAHpH  HLC0LC8LC@LCHLCPLCXLC`LChLCpL   L   L   L   L   L   L   L   L   L   L   H   HH0[LWATAUAVAWH@  HD$hI[Is A)sHH H3H$(  HHT$0HWD$PE3Lt$`D$8Lt$H6    Iǃ8   M0D$  EFH I   HǄ$      L$  D$  EFH H$    HǄ$     L$  D$  EFHn H$  y  H$  ˹HD$ L$  L$  H$  HUH$  Ht(L$  L+I  W$  L$  H$  HrTHH$  H=   r<t˩
 HAH;r
 H+Hs
 H'v
 H
 HǄ$     L$  Ƅ$   H$   HrTHH$  H=   r<tM
 HAH;r=
 H+Hs-
 H'v 
 H HǄ$      L$  Ƅ$   H$  HrTHH$  H=   r<tϨ
 HAH;r
 H+Hs
 H'v
 H Ds(HǄ$     L$  Ƅ$   A   H H$  w  HL$  H$  HP(HHD$PH;t'H:H|$PHJHL$XHBHD$`L2LrLrH|$PH$  Ht(L$  L+IӮ  W$  L$  H$  r  C(3    HǄ$      3H$  @$  DGHV H$    HǄ$     H$  @$  DGHq H$  h  HǄ$     H$  @$  DGH( H$  3  H$  腶HD$ L$  L$  H$  HH$  Ht(L$  L+I]  W$  H$  H$  L  H$  >  H$  0  {,HǄ$     H$  Ƅ$   A   Hp H$  g  HL$  H$  HP(HHL$P`  H$  Ht(L$  L+I  W$  H$  H$  莍  HD$PK,1    HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H H$  }  DC(EyH$  H$  H$    H$  Ҍ  HǄ$      H$  Ƅ$   A   Hy H$    HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H H$    HcS(H$  HD$ L$  L$  H$  HvH$  Ht(L$  L+IĻ  W$  H$  H$  賋  H$  襋  H$  藋  HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H H$    DC(EyH$  H$  H$    H$    W$  HcS(W$  H$  L$  H$    H$  HK0蕇  H$  HtL$  L+It  HǄ$     H$  Ƅ$   A   H H$    HL$  H$  HPHHL$8  H$  Ht(L$  L+I  W$  H$  H$    LLcS(LL|$8A   IrqHC0HHPML+AH+MZIIN$    M@ f     IDHBIHIDHBH>IDHHR IuHt$03M;sHS0KHJIHIM;r[-    HǄ$     H$  Ƅ$   A   H H$  i  HǄ$     H$  Ƅ$   A   HC H$  2  DC(EyH$  H$  H$  蕈  H$  臈  HǄ$      H$  Ƅ$   A   H. H$    HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   HH H$  S  HcS(H$  HD$ L$  L$  H$  H+H$  Ht(L$  L+Iy  W$  H$  H$  h  H$  Z  H$  L  H$  H$  E33H$    A   H H$    H$  H$  E33H$  譻  A   HT H$  C  DC(EyH$  H$  H$  覆  H$  蘆  $  HcS(W$  H$  L$  H$  ¹  H$  HKHA  H$  HtL$  L+I   H$  H$  E33H$  κ  A   Hu H$  d  HL$  H$  HPHHL$8轂  H$  Ht(L$  L+I蜵  W$  H$  H$  苅  LLc[(LL|$8IrmHCHHHPML+IH+MSIIN$    Mf     IDHBIHIDHBHIDH1HR IuHt$03M;sHSHKHJIHIM;r)    H$  H$  E33H$  }  A   H@ H$    H$  H$  E33H$  @  A   H H$  ֿ  DC(EyH$  H$  'H$  9  H$  +  H$  H$   E33H$  ɸ  A   H̺ H$  _  H$  H$  E33H$  茸  A   HC H$  "  H$  H$  E33H$  O  A   H H$    HcS(H$  SHD$ L$  L$  H$  H轤H$  Ht(L$  L+I  W$  H$  H$    H$    H$  ނ  H$  H$  E33H$  |  A   H? H$    H$  H$  E33H$  ?  A   H H$  ս  DC(EyH$  H$  &H$  8  H$  *  $  HcS(W$  H$  L$  H$  T  H$  HK`~  H$  HtL$  L+I貱  H$  H$  E33H$  `  A   H H$    HL$  H$  HPHHL$8O~  H$  Ht(L$  L+I.  W$  H$  H$    LLc[(LL|$8IroHC`HHPML+IH+MSIIN$    Mfff     IDHBIHIDHBHIDH1HR IuHt$03M;sLK`KHKIHIM;r$    H$  H$   E33H$  
  A   H\ H$  裻  H$  H$  E33H$  д  A   H{ H$  f  H$  H$  E33H$  蓴  A   H H$  )  H$  {HD$ L$  L$  H$  HH$  Ht(L$  L+IS  W$  H$  H$  B  H$  4  H$  &  {xH$  H$  E33H$    A   Hl H$  W  HL$  H$  HP(HHL$PPv  H$  Ht(L$  L+Iߝ  W$  H$  H$  ~~  HD$PKx"    H$  H$  E33H$    A   H˶ H$  螹  H$  H$  E33H$  ˲  A   H H$  a  DC(EyH$  H$  H$  }  H$  }  H$  H$  E33H$  T  A   H H$    H$  H$  E33H$    A   H H$  譸  DCxEyH$  H$  H$  }  H$  }  H$  H$   E33H$  蠱  A   H H$  6  H$  H$  E33H$  c  A   H. H$    H$  H$  E33H$  &  A   H H$  輷  LcCxHcS(H$  fHD$ L$  L$  H$  H萝H$  Ht(L$  L+Iޫ  W$  H$  H$  {  H$  {  H$  {  H$  H$  E33H$  O  A   H H$    H$  H$  E33H$    A   Hݳ H$  訶  DC(EyH$  H$  H$  {  H$  z  H$  H$  E33H$  蛯  A   HF H$  1  H$  H$  E33H$  ^  A   H) H$    DCxEyH$  H$  EH$  Wz  H$  Iz  $  HcSxW$  H$  L$  H$  s  HcS(W$  H$  L$  H$  E  H$  H   c  H$  tc  H$  HtL$  L+I蒩  H$  H$  E33H$  @  A   H H$  ִ  HL$  H$  HPHHL$8/v  H$  Ht(L$  L+I  W$  H$  H$  x  LHc{xH$  E3H   L|$8@ f     LcC(3I   H   LHP0M_OA   L+IxHHH4    Lfff     HJICJHJICJH
IJJ"J1ICJM[ HR`HuH$  I;s+L   HvHL+IKJIHRIuIL;,Ht$0 	   3H$  H$  E33H$  艬  DGH6 H$  !  H$  H$  E33H$  N  DGH H$    DCxEyH$  H$  7H$  Iw  H$  ;w  H$  H$   E33H$  ٫  A   Hܭ H$  o  H$  H$  E33H$  蜫  A   HO H$  2  H$  H$  E33H$  _  A   H H$    HcSxH$  cHD$ L$  L$  H$  H͗H$  Ht(L$  L+I  W$  H$  H$  
v  H$  u  H$  u  H$  H$  E33H$  茪  A   H7 H$  "  H$  H$  E33H$  O  A   H H$    DCxEyH$  H$  6H$  Hu  H$  :u  $  HcSxW$  H$  L$  H$  d  H$  H   q  H$  HtL$  L+I迤  H$  H$  E33H$  m  A   H  H$    HL$  H$  HPHHL$8\q  H$  Ht(L$  L+I;  W$  H$  H$  *t  LLc[xLL|$8IrlH   HHPML+ȿ   H+MSIIN$    M IDHBIHIDHBH>IDHHR IuHt$03M;sH   KHJIHIM;r 
   H$  H$  E33H$    A   Hݫ H$  谮  H$  H$  E33H$  ݧ  A   H H$  s  DC(EyH$  H$  H$  r  H$  r  H$  H$  E33H$  f  A   H H$    H$  H$  E33H$  )  H H$  襭  DC,EyH$  H$  H$  (r  H$  r  H H$  Vs  H H$  As  HA H$  ,s  LcC,HcS(H$  HD$ L$  L$  H$  H H$  W  H$  q  H$  vq  H$  hq  H H$  r  Hع H$  r  DC(EyH$  H$   H$  q  H$  q  Hi H$  @r  Ht H$  +r  DC,EyH$  H$  H$  p  H$  p  $  HcS,L$  H$  m  HcS(LH$  [  HH   jZ  H$  Y  H$  V  Hĸ H$  {q  Ld$0I$L$  H$  IPHHL$8l  H$  QV  H$  o  LLc{,LMtFLt$8Hc{(E3Ht+ MIIH   KY  HKJIL;rIM;r3    H H$  p  H H$  p  DC,EyH$  H$  H$  .o  H$   o  H H$  \p  H H$  Gp  HG H$  2p  HcS,H$  HD$ L$  L$  H$  I*H$  T  H$  n  H$  n  H$  rn  H׶ H$  o  H H$  o  DC,EyH$  H$  
H$  n  H$  n  HcS,W$  H$  S  H$  H   T  H$  F
 HW H$  
o  I$L$  H$  IPHHL$8j  H$  S  H$  wm  LLc[,LLt$8IryH   HHPML+ȹ   H+H$  MSIIN<    M     IDHBIHIDHBHIDH9H IH$  uM;sL   KHKIHIM;r    H H$  m  H8 H$  m  H H$  m  H$  @HD$ L$  L$  H$  IʍH$  R  H$  .l  H$   l  H$  l  3H   H H$  Em  I$L$  H$  IPHHL$8h  H$   R  H$  k  HD$8HH       D$0   H H$  l  He H$  l  LL$0LC,H$  H$  	 H$  ;k  H$  -k  O    t$0H H$  [l  H H$  Fl  LL$0L   H$  H$  	 H$  j  H$  j  HsHCHCHC    H H$  k  H H$  k  DCxEyH$  H$  5H$  Gj  H$  9j  HcCxHHCP    H H$  `k  H H$  Kk  DC,EyH$  H$  H$  i  H$  i  HcC,HCHL$8P  HL$PL  H$(  H3 L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH H HHH   
 H   3H*HtNH   , L   HH   I+HHLI?LI覅  H   H   H   H   Ht(L   L+I貘  H   H   H   H   HtNH   + L   HH   I+HHLI?LI  H   H   H   HS`HtLCpL+I*  H{`H{hH{pHSHHtLCXL+I  H{HH{PH{XHS0HtLC@L+I  H{0H{8H{@H]y HKHH\$0Ht$8H _  @SVWATAUAVAWH  HǄ$  )$  HZ H3H$p  LL$8MLHIHL$`a  IHL$xJ    $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGHz H$0  Q  IH$0  IPH$H  HrTHH$0  H=   r<t~
 HAH;r~
 H+Hs~
 H'v~
 H8 tiH
 H$   3H$   H$   H HD$8D$@H$   HL$8|
 Hv H$   H H$   " HǄ$     H$   Ƅ$   A   H^ H$  5  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+ID  W$0  H$@  H$  HrTHH$  H=   r<tl}
 HAH;r\}
 H+HsL}
 H'v?}
 H计 HǄ$     H$  Ƅ$   A   H H$    HǄ$h     H$`  Ƅ$P   A   H
 H$P    HǄ$     H$   Ƅ$   A   H H$  誟  H$0  HD$ L$  L$P  H$  I膅H$0  Ht(L$@  L+Iԓ  W$0  H$@  H$  c  H$P  c  H$  c  D$0HT$0HL$`^  HǄ$     H$  Ƅ$   A   H H$  Ǟ  IH$  IPH$  3c  tiHP
 H$   3H$   H$   H HD$8D$@H$   HL$8y
 Hs H$   Hd H$    HǄ$     H$  Ƅ$   A   H% H$     IL$  H$0  IPHHL$HY_  H$0  Ht(L$@  L+I8  W$0  H$@  H$  'b  HǄ$     H$   Ƅ$   A   HΘ H$  a  HǄ$h     H$`  Ƅ$P   A   HO H$P  *  HǄ$     H$  Ƅ$   A   HX H$    H$0  EHD$ L$  L$P  H$  IςH$0  Ht(L$@  L+I  W$0  H$@  H$  a  H$P  `  H$  `  HD$H D$0HT$0HL$`2\  HǄ$     H$  Ƅ$   A   HD H$    IH$  IPH$  w`  tiH
 H$   3H$   H$   H{ HD$8D$@H$   HL$8v
 Hp H$   H H$   1 HǄ$     H$  Ƅ$   A   H} H$  D  IL$  H$0  IPHHL$H\  H$0  Ht(L$@  L+I|  W$0  H$@  H$  k_  HHǄ$h     H$`  $P  A   H H$P  裚  HǄ$     H$  Ƅ$   A   H H$  l  DFxEyH$P  H$  H$  ^  H$P  ^  HǄ$     H$   Ƅ$   A   Hh H$    HǄ$h     H$`  Ƅ$P   A   H H$P  ę  HǄ$     H$  Ƅ$   A   H H$  荙  HcVxH$0  HD$ L$  L$P  H$  IeH$0  Ht(L$@  L+I賍  W$0  H$@  H$  ]  H$P  ]  H$  ]  Wt$0HcVxW$0  H$@  LD$0H$0  賐  L$0  9Vx~)ILD$Hfff     IH[HHI;Vx|;^x}HcIHL$`bX  HǄ$     H$  Ƅ$   A	   HD H$  7  IH$  IPH$  \  tiH|
 H$   3H$   H$   H HD$8D$@H$   HL$8*s
 Hm H$   H H$   ] HǄ$     H$  Ƅ$   A	   H} H$  p  IL$  H$  IPHHL$HX  H$  Ht(L$   L+I訋  W$  H$   H$  [  H$   H$(  E33H$  5  A   H8 H$  ˖  H$`  H$h  E33H$P    A	   H H$P  莖  H$  H$  E33H$  軏  A   H H$  Q  H$  裂HD$ L$  L$P  H$  I-|H$  Ht(L$   L+I{  W$  H$   H$  jZ  H$P  \Z  H$  NZ  HD$H D$0LD$0(HL$`,  H$   H$(  E33H$  ʎ  A   H H$  `  IH$  IPH$  Y  tiHy
 H$   3H$   H$  Hh HD$8D$@H$   HL$8Sp
 H<j H$   H	 H$   膡 H$   H$(  E33H$    A   Hԡ H$  蓔  IL$  H$  IPHHL$HU  H$  Ht(L$   L+Iˈ  W$  H$   H$  X  HH$  H$  E33H$  U  A   H H$    H$   H$(  E33H$    A   H H$  讓  DF,EyH$  H$  H$  X  H$  X  H$`  H$h  E33H$P  行  A   H H$P  7  H$  H$  E33H$  d  A   H; H$    H$   H$(  E33H$  '  A   H" H$  轒  HcV,H$  +HD$ L$P  L$  H$  IxH$  Ht(L$   L+I  W$  H$   H$  V  H$  V  H$P  V  t$0HcV,W$  H$   LD$0H$    L$  L|$H9V,~IIH[HHI;V,|fD  ;^,}HcIHL$`Q  HT$`HL$8N  HT$xI97  MtL$   M+II  MtL$@  M+IIυ  H$@  HtH+HLu  MtLD$XM+II蘅  HL$`(  H$p  H3 ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xHH H3HEH3HH  HE   3Hu@uDFH HM  HCHMH;sTHHUH;wHH}H+H;CuVHM  HH;HKHtcHA   HqHyrHHH;H;Cu
   H
  HKHt'HA   HqHyrHHHU  誕  HC HEHrPHHMH=   r<tl
 HAH;rl
 H+Hsyl
 H'vll
 Hې HE   HuE A   Hv HMU  HCHMH;sVHLEI;wJH}H+H;Cu
   H!  HH;HKHtcHA   HqHyrHHH;H;Cu
   Hރ  HKHt'HA   HqHyrHHHU  ~  HC HM0S  HE   HuE A   H HMz  HUH=H  HMR  HE   HuE A	   HF HM=  HUH H  HMR  HE   HuE A   H= HM   HUHG  HMyR  HE   HuE A   H` HMÍ  HUHG  HM<R  HE   HuE A   H+ HM膍  HUHIG  HMQ  HE   HuE A   H HMI  HUHG  HMQ  HMH3 H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLHn>  WEE3LuHMI  HUHz=  HMI  HUHe=  HMI  IcxH} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
 e
 HQM+IIHHH+IMI;LCL;ICHMϨ  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
% Oe
 HQM+IIHHH+IMI;LCL;ICHM:  HMHtH9HHMHUH;  HMaH  HUH;  HMLH  Ic,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
D nd
 HQM+IIHHH+IMI;LCL;ICHMY  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
 c
 HQM+IIHHH+IMI;LCL;ICHMѦ  HMHtH9HHMHUH:  HMF  IcxH} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
 c
 HQM+IIHH+II;LCL;ICHM  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
r b
 HQM+IIHH+II;LCL;ICHM荥  HMHtH9HHMHUHM9  HME  AOxHcH] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM~  HMHEHt)HH H;Mu   HM~  HMHtHHHMHUH8  HME  HUH8  HUHtLEL+IE|  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HE HXHpHx Hc? H3H   EELHHL$ )Z  HL$8>  E3LmHL HL$0  HU(HL$ hX  HI@  HE@HrQHHM(H=   r<tc
 HAH;rc
 H+Hsc
 H'vc
 H HL$8覑  LmH HL$0!  HU(HL$ W  HIG@  HE@HrPHHM(H=   r<t:c
 HAH;r*c
 H+Hsc
 H'v
c
 H|    9_x   HL$8  LmH# HL$0}  HȲ.  Hȋ8`
 HU(HL$ W  HI?  HE@Hr4HHM(H=   r uAHAH;s1H+Hr!H'wH߆ ;_x!gUb
 Nb
 Gb
 @b
 HL$8M  LmHB HL$0Ⱦ  HU(HL$ zV  HI>  HM(I  9_,   f     HE@   Lm8E( HL$8  LmHM(iI  H HL$0X  HȲ.n  Hȋ_
 HU(HL$ U  HIi>  HM(I  ;_,~Eu	Es  9_x|{ HE@   Lm8E( HL$8V  LmHM(H  H֒ HL$0Ƚ  HȲ.޿  Hȋ^
 HU(HL$ eU  HI=  HM(H  ;_x~Gx   ff     HE@   Lm8E( HL$8Ǝ  LmHM(IH  HN HL$08  HȲ.N  Hȋ]
 HU(HL$ T  HII=  HM(G  ƋGx;~HE@   Lm8E( HL$8J  LmHM(G  H֑ HL$0輼  HU(HL$ nT  HI<  HM(G  HM~T  HM]
 H   H3| L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx H: H3H   LHHL$0TU  HL$Hi  E3L}Hw HL$@  HU0HL$0S  HI<  HEHHrQHHM0H=   r<t^
 HAH;r^
 H+Hs^
 H'v^
 H< HL$Hь  L}H~ HL$@L  HU0HL$0R  HIr;  HEHHrPHHM0H=   r<te^
 HAH;rU^
 H+HsE^
 H'v8^
 H观    9_x       HL$H&  L}HG HL$@衺  HȲ.跼  Hȋ\[
 HU0HL$0>R  HI:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH ;_x!gy]
 r]
 k]
 d]
 HL$Hq  L}Hf HL$@  HU0HL$0Q  HI:  HM0D  ,   @ ff     HEH   L}@E0 HL$H  L}HM0D  H& HL$@x  HȲ.莻  Hȋ3Z
 HU0HL$0Q  HI9  HM0?D  ;w,~     HMQ  HMZ
 H   H3ny L$  I[ Is0I{8IA_A^]H\$WH Hlt
   H袀 HH\$0H _H\$Ht$WH H3H  Ht;H  4 H  L   L+I
q  H  H  H   H  H*HtNH  # L  HH  I+HHLI?LI_  H  H  H  H  B  H  Ht(L  L+Ir  H  H  H  HKp   HKXHt)HS`F HSXLChL+I"p  H{XH{`H{hHK@Ht:HSHT HKPHH+K@HHLI?LHS@^  H{@H{HH{PHS HtLC0L+I
r  H{ H{(H{0HSHtLCL+Iq  H{H{H{H\$0Ht$8H _H\$WH HHA  HOXA  LG8HT$0MHO8M o  HO8`~ LG(HT$0MHO(M xp  HO(?~ HOH\$8H _\A  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hs  HH_8H\$HH3HsԴ  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"     H}| HH [H\$Ht$WH H3H  Ht;H    H  L  L+Il  H  H   H  H  Ht(L  L+IV^  H  H  H  H  Ht(L  L+In  H  H  H  H  H*HtNH  K L  HH  I+HHLI?LI.[  H  H  H  H  Ht;H   H  L  L+Ik  H  H  H  Hp  HtNHx   Lp  HH  I+HHLI?LIZ  Hp  Hx  H  HX  Ht;H`  ` HX  Lh  L+I6k  HX  H`  Hh  HKpHH\$0Ht$8H _nHT$SH0HD$(H3D$ HHBHBD$    H  H  L  HH0[@SH0HD$     H  H`[  HH0[@SH0HD$     Hp  H0[  HH0[@SH0HD$     H  H2  HH0[@SH0HD$     HX  H2  HH0[H   HD$0LH  L  HQpHD$ I^  tWH:\
 HD$P3HD$XHD$`H HD$@D$HHT$XHL$@R
 HL HD$PH]
 HL$P 3HĈ   @USVWATAVAWH$ H  HEH. H3H   EIHHHUH]E3Dd$4IHL$Ps5  Lt$XL+t$PIL;vx   HMI  H^xHu HM  HIP
 HHN   HHP
 HH/   H   HMG  HxrH H
Z
 HL$h3HL$pHL$xHEEHT$pHMlQ
 HR HD$hH
 HL$h襂 Dd$0H   H+   HWD$8Ld$HLD$0HL$8誟  L'LgLgD$4   HNpLLD$8HT$PEt    HT$8HtLD$HL+I8Y  WD$8Ld$HHT$PHtLD$`L+Ii  HHtLCL+Ii  L#LcLcHH   H3n H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH, H3H   EEHHHUHL$HK3  Ht$PH+t$HHH;wx   HMYG  H_xHM HM  HHN
 HH& ٭  HHN
 HH 辭  H   HMnE  HxrH H
X
 HL$h3HL$pHL$xHEEHT$pHMDO
 HP HD$hHi
 HL$h} 3t$`H   H+   HWD$0Ht$@LD$`HL$0聝  EuLHOpLD$0HT$HEt2#  (HT$0H   LD$@L+I!W  WL$0|!  WD$hHt$xHOpLL$hLD$0HT$HEt$  m  (HT$hHtLD$xL+Iog  HT$0HtLD$@L+IV  WD$0Ht$@HT$HHtLD$XL+I*g  HHtLCL+Ig  H3HsHs(H   H3dl H$   ($  H  A_A^_^]@SVWH  HD$pH-* H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   D  HxH^H+HH H$   M  HHL
 HH 2  HHK
 HH`   H$  H$   B  HxrH H
V
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`L
 HM HD$HH
 HL$H} H   H+   HHL$H  HOpD$0D$(H\$ L  HT$HHtLD$XL+IT  HH$  H3j Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E3HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK2]WD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`ZHT$8HtLD$HL+I>S  HL$`dHL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xH~\HHMp3L
 L   A   AA+iA+AD̉P    AA+iD+EDDT  HX   HUpHp   3DLx  Lp  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;r  HX  H  (  Hp  H  P  H  H;H{H{H  H  H      H  H   H  H|$      f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   Hc  HKHHt(HHH;Cu
   H~c  HCHtH8HCHH|$   H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hc  HHKHt,HH#H;Cu
   Hb  HCHtH HCH  H  Q L  H  H  w  HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H# H3HEHLHUHM&  H]HLuIـ E3H;  HE   LeDeED$Hh HMhk  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
z D
 HSM+IIHL+IIM;HCH;HCHM1  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
y D
 HSM+IIHL+IIM;HCH;HCHM聓  H]Ht*HC   LcH{rHHHU  Ho  H H]HEHrPHHMH=   r<tF
 HAH;rF
 H+HsF
 H'v}F
 Hj HUIpE  M  I  I    H]Ht HUH LEL+IHm[  HHt'HVk HLFL+IH[  L&LfLfHMH3b L\$pI[@IsHIA_A^A\_]L$SH0H)t$ IHT$H HKHD$@D$@(H;s\HHT$@H;wOH|$PH|$@H+HH;Ku
   H_  HSHt
HHH
H|$PHBHC(t$ H0[H;Ku
   H^  HCHt0(t$ HHCH0[H\$WH HQ3HHtLA(L+IK  H{H{ H{(HHtLCL+ID\  H;H{H{H\$0H _Hy0HArH @SH H. HHH,  H%L
 HKHH [H%*C
 H\$ WHpH7 H3HD$`3HHAIHAH(. HHL$@蓲  HHL$ L胯  HHOLv    HD$8HrQHL$ HH=   r<tC
 HAH;rC
 H+HsC
 H'vC
 Hg HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t?C
 HAH;r/C
 H+HsC
 H'vC
 Hg HHL$`H3` H$   Hp_@SH H; HHHt*  HJ
 HKHH [H%A
 H\$ WHpH H3HD$`3HHAIH,_ HAH1; HHL$@  HHL$ L  HHOLt i  HD$8HrQHL$ HH=   r<tB
 HAH;rB
 H+HsA
 H'vA
 H]f HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tA
 HAH;rA
 H+HsA
 H'v{A
 He HHL$`H3j^ H$   Hp_@SH H3: HHH(  HH
 HKHH [H%?
 H\$ WHpH H3HD$`3HHAIH\] HAH9 HHL$@\  HHL$ LL  HHOLr ɯ  HD$8HrQHL$ HH=   r<t{@
 HAH;rk@
 H+Hs[@
 H'vN@
 Hd HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t@
 HAH;r?
 H+Hs?
 H'v?
 HJd HHL$`H3\ H$   Hp_@SH HH
 HHH4'  HUG
 HKHH [H%Z>
 H\$ WHpHg H3HD$`3HHAIH[ HAHG
 HHL$@輭  HHL$ L謪  HHOLFq )  HD$8HrQHL$ HH=   r<t>
 HAH;r>
 H+Hs>
 H'v>
 Hc HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<th>
 HAH;rX>
 H+HsH>
 H'v;>
 Hb HHL$`H3*[ H$   Hp_@SH H1 HHH%  HE
 HKHH [H%<
 H\$ WHpH H3HD$`3HHAIH,Z HAH11 HHL$@  HHL$ L  HHOLo 艬  HD$8HrQHL$ HH=   r<t;=
 HAH;r+=
 H+Hs=
 H'v=
 H}a HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t<
 HAH;r<
 H+Hs<
 H'v<
 H
a HHL$`H3Y H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuH>  HKHL$@HHHHL$HHt賫 *H;KuH>  HKHL$@HL$HHt	H臫 HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LH|r  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH{>  HwHtlHHHF   HF     HHHc  C F ;H;OuH3>  H_Ht$HC   HHC    H lc  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	f HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIv HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI LGHVH pMt/HWIu HOH+IHHLI?LHb=  HNH+IHHHH?HH>  tLHVH蜁 HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LH<  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   H<  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   HZ<  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+HC5
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+4
 H[HI~H+LH4
 Ht$0H;H|$8IFIH\$@H A^HtH!=  HSIH+H>  t!HH[I>H+LHy4
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I<  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
g &2
 HH|$0q  HHFHHHNI~IHH+LH3
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
Xg 1
 Lq  HH    HGLH3HHOHFd H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXH;
 D$(HD$0HT$83HL$ HD$8HD$@H=_ HD$ B2
 Hc! H,
 HD$0HL$0{c Hu;
 D$(HD$0HT$83HL$ HD$8HD$@H<P HD$ 1
 HT" H
 HD$0HL$0$c HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`H:
 D$(HD$0HT$83HL$ HD$8HD$@H%^ HD$ *1
 HK  H
 HD$0HL$0cb H\$WH HHH;Qt>H	1
 HtH HH{H\$0H _H    H{H\$0H _HyH\$0H _HLHLHALBHBHLA@SH HHHtLAL+IoI  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
(d R.
 o  HL    HCHHIHKH LCHH\$0H _@SH L
 HL II+HH;sH+IH H [H;   L H+II+HH;s\IIH+H;sH
hc -
 HM+I3IHL+IM;HCH;HCn  L
o L` ILI+3HIL+I*` H
C HH+1 HH+HH' H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
ib ,
 HM+I3IHL+IM;HCH;HCHn  HOLH3H+HL+I5_ HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH:  HSHt7HHH
HCH\$0H _H;CuH9  HKHtHHHCH\$0H _HHRH@SH HH	Ht@HS& LCH*L+IHLI?LH2  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LHI2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
_ *
 Hg  HHCHHHHKLHVH$v HCHH\$XHt$`H@_@SH 3HHHAHA8  HH [H\$WH 3HHHHAHAHtNH
H;vH
_ B)
 f  HHHCHHL    IHKH$ LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   H8  HKHL$@HHHHL$HHtn
  /H;Ku
   HH8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHRu  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR  HH@HH HH@HC    DD$@HH(  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+IW0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I@  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@Hr LHD$ HT$@HLH u HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHRU  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHRՁ  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I>  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+If>  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H_>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HFJ  VH;Cu
   H >  HKHL$@HL$HHt03HA   HAHyrHH  IE3HI  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
W !
 HM+I3IHL+IM;HCH;HCHFq  HOHHH+HH+ HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LI  HSH] HGH+HH   HCH+HL;w'HILHI  LCHWHs LHtI HLCL+I8  HWH+HH0<  tLHWHs HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+Is8  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H:  HKHt@HH;H;Cu
   H:  HKHtHA   HHA     K  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I7  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
OT y
 H@d  HHCHH;H{LHVHq HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH::  HSHt3H
HCH\$0H _H;CuH:  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+I|'  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   H9  HSHt<HHH
HCH\$0H _H;Cu
   H9  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+A
 H[HI~H+LH'
 Ht$0H;H|$8IFIH\$@H A^HtH!6  HSIH+H8  t!HH[I>H+LH
 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
P 
 HH|$0x[  HHFHHHNI~IHH+LH
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
O 
 Z  HH    HGLH3HHOHL H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   He6  HSHt
HHH
HBHCH\$0H _H;Cu
   H,6  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
N 
 HM+I3IHL+IM;HCH;HCH[  HOLH3H+HL+IUK HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+I2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH 3HHHAHA5  HH [@SH0HE3HQ(DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH>=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH<  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	o	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ X=  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
K 
 H;sLHHf  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<t,
 HAH;r
 H+Hs
 H'v
 Hn< HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t
 HAH;rr
 H+Hsb
 H'vU
 H; HC   HC    H{rHH  HH@  HH\$@H0_@SH E3HA   LAHDD8tIIB< u9  HH [@SH HA   IHA    E3 H:  HH [H\$WH HH  HH
 tHCh    H\$0H _HH{hH\$0H _H% 
 @SH H    Ht'  tH   3
 y	H [3H [@SH HMH   Ht9HuMuEAE3
 uH   D@HA  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|>  tsH   HT$0Y
 u]HtH   D@Hd
 u@H   HT$0F
 u*IFHHGtj>  HOtHD$0HCH    HKHy
 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb=  tYHutH   DHs
 u8H   HT$0U
 u"H=  HKtHD$0HGH    HOH
 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   Z
 tl  d  HE/   E3Lu'DuH   %
   HU'HHH  HZH  LM/L;sLHHM`  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOh
    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+32  HUH}/r'HHu#Ey
     ]
 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   C
 H~LEHU]#H
C 
 H
C 
 HUHE/HrPHH=   r=Et
 HBH;r
 H+Hs
 H'v
 HH4 HM7H3{- L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@
 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp H
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   I
 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKh
       HELELM/IICH}H+t.HMIICL   LǺ   
 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHM2  3u#MH   
 ;ELM/LELM/LEIrQIAH=   r=Et
 I@I;r
 L+Is
 I'v
 LI0 HM7H3|) L$   I[0Is8IA^_]H   HtH%=
 H   HtH%%
 @SH0HD$ HHG
 HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H}8  HH0[H%	
 @SH0HD$     H:  HH0[H\$WH HhHHcPH H
hHhHcPH7
 DhD
dHAH+9  HO	
 HOH\$0H _H%L
 DL$ HL$SVWH0HD$ HHD$h    H	 HH' HAH   
 D$h   H^E3HH
 HHcHH# H1HHcHhT1H\$XH(
 HP
 HLGHrH?HCh    Cp    MtHH]  HH0_^[DD$HL$WH0HD$ H\$HHD$P    H	 HHG HAH   
 D$P   E3HWH
 HHcPHF H:HHcPDhDD:   HO:  HH\$HH0_@SH0HD$     Hv8  HH0[H\$WH HxHHcPH
 H
xHxHcPH
 DxD
tHAH6  HO
 HOH\$0H _H%<
 @SMPHMLLA@I Ht
H9AhsHAhH$
 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   H
 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjH>
 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
H
 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIHNZ	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI=5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH H
 HHHI
 HO 
 HO(
 H	 t
0   H' HH\$0H _H\$WH H\t
   H& HH\$0H _H\$Ht$WH HH> 
 @t   Hh& Ht$8HhH\$0H _H\$Ht$WH HH	 @t   Hx?& Ht$8HxH\$0H _H\$WH H
 HH/  H	 t
x   H% HH\$0H _H8HD$ HHHcHHLHHt+HHPHH;uH   Ht
 
 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLH  H\$ HSH HHCI  H$   HVHݥ HHFI  HHGWD$8HD$H    Ip  Hl$(HT$8H  ILl$8I;^F  MX  @ HI  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtH  U	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  H&  HGH+HA  MtwHD$HI+HH?H;v	 H    H=   r=At	 IEI;r	 L+Isy	 I'vl	 LI! HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
z/ 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
. 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [H(H
L;v	 K@HH=   r<ts	 HBH;rc	 H+HsS	 H'vF	 HHH( @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
\- 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _n5  H _H\$WH 3HHHHAHAHt:H
H;vH
, 	 4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
, B	 H3  HHCHHHHKLHVHB HCHH\$XHt$`H@_H(H?L;v	 J    H=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(LQLLAII+HH;s_H	I?L+III+H;sH
* &	 L+II3IHL+IM;HCH;HCIH(C5  H(H\$WH 3HHHHAHAHt6H?H;vH
x* 	 l4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHH
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
) 	 IHO uM  H    HHWHL$(bHHO E7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wH HH;_s%k	 d	 ]	 V	 O	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;v	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
' 	 L+II3IHL+IM;HCH;HCIH(#4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
Z' 	 L+HI3IHL+IM;HCH;HCIH(q4  H(@SH0WH,        f I1  LH HH HHH
 H@ HIH
ݛ H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
N& x	 ".  HHCHL4    HIHKHMHH裝 I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
|% 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _4  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uH&  AE3'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AD  3ҋm%  AD$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH`   AE3S!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEu   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ=  AD`  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v	 II   r<t	 HBH;rv	 H+Hsf	 H'vY	 HHH( LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRB  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRWC  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@HS0  LD$PL;D$XuLHH\$HH0_H(HL;vO	 J    H=   r<t3	 HBH;r#	 H+Hs	 H'v	 HHH(n H(LQLLAII+HH;s_H	IL+III+H;sH
L v	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
 	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
J t	 L+HI3IHL+IM;HCH;HCIH(#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
 	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
8 b	 ,#  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH> HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
` 	 T"  HLHCHHHHKLI MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHH;uH   Ht	 ҐH8@SH0HD$ H	 u
H	 HHHcHHLHHt+HHPL
 I;uH   Ht	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtH9	 HCHH=   r=@tM	 HGH;r=	 H+Hs-	 H'v 	 HH HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALH	 HHt8Ht!LIHv8	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1It7	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHH[7	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ :0  H\$hH0A_A\^HKI;sH
C 
	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
 
	 L+H|$XH;s;HCHrHHHrHHMtHMJ HH\	 LCIH+HHu	H   HvH
 	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HH	 H{rHHHtJ LIS5	 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH
 U	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JL	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH
 	 HvH
 	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L 
 H{H{rHH8 Ht$8HH\$0H _̀: uE3   IIB< u    H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH
$ 6	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLH2	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
W !	 I+H;HGH;u9I8H9AsH
0 	 HAHyrH	 3He   HvH

 	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6L0	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH

 *	 H|$0I<H   HvH
 	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
 	 H|$0I<0H   HvH
 	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLH.	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
 	 LAH+H;HGIHH;wH
 	 H|$0I<0H   HvH
z
 	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.L-	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBIta	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpHC
 H3HEHHyh   yq   u2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H
2 D	 H
$ 6	 ̳IrNIAH=   r=Et=	 HAH;r-	 H+Hs	 H'v	 H HMH3 L\$pI[(Is0IA^_]@SVWH AAq HHA|	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXH{ HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHDa	 HEHC| Cq 	 H
{{ HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   ID	 HtyA   HHHT$(H8	 HǠ  HH	 t
HCh    H{hH	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t	 HAH;r	 H+Hsu	 H'vh	 H HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPHǫ
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r	 H+Hs	 H'   	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t	 HAH;r
	 H+Hs	 H'v	 H\ HHL$HH3 H\$pHP_@WH0HD$ H\$HH	 H
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;w	 x HH'HHAHH(H\ HH(H(I   r<t	 HBH;r	 H+Hs	 H'v	 HHH( Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;v	 KHH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(H88L;vO	 KHH=   r<t3	 HBH;r#	 H+Hs	 H'v	 HHH(n H(Hu	3ɋH(H88H;vY	 HHH   r,HA'H;w8	 H HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH HH988LKHML+IHHLI?IHt+Io HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;v	 HHH   r&HA'H;w	 H HX'HHC HHVLHHl$@Lt$H HHgfffffffLNHML+ILIMI?MHt+I9o HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;v	 HRHH   r,HA'H;w	 H HH'HHAHH(n HH(H\$Hl$Ht$H|$ AVH0LH[HSLHHY HH*LKHML+IHHLI?IHt+Ii HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt/H;Ku
   HhHKHL$@HL$HHt	H͍HCH\$PH0_H(Hu	3ɋH(H?H;vɿ	 H    H   r,HA'H;w	 Hg HH'HHAHH(N HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;vɾ	 H    H   r,HA'H;w	 Hg HH'HHAHH(N HH(H\$WH HHu3UHH;vE	 H    H   r&HA'H;w$	 H HX'HHC HHFl HLDl L+Ht$0	 H'l H5(l H+HHtLl L+IHHk Hk HHt$0H\$8Hk H _H\$Ht$WH HHHu3UHH;vM	 H    H   r&HA'H;w,	 H HX'HHC HHHLGL+Hl$0;	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+C	 HH{H+HHtLCL+IHHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;vݺ	 HRHH   r&HA'H;w	 H{ HX'HHCh HHVLHHl$@Lt$H HH*LNHML+ILIMI?MHt+IIh HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;vɹ	 HH   r)HJ'H;w	 n HH'HHAHH(HR HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;vg	 H    H=   r<tK	 HAH;r;	 H+Hs+	 H'v	 H HoXHo`HohHO@Ht~HGPH?H+HH;v	 H    H=   r<tĸ	 HAH;r	 H+Hs	 H'v	 H Ho@HoHHoPHO !H HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;v	 H    H=   r<t	 HAH;r	 H+Hs{	 H'vn	 H HoXHo`HohHO@HttHGPH+HI;v:	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H` Ho@HoHHoPHO {HC HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHHO HHWHH+HtZ HLGL+IuHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
`
 	 THLHCHHHHKLI^ MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPL
 I;uH   Ht	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;w	 H Hp'HHF HH\$`Lt$pH|$hHt$xMtH{rHHMtMH1	 HCHrOHHH=   r<tڰ	 HAH;rʰ	 H+Hs	 H'v	 H HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH

 ̬	 IALd$XLd$pI;sH
 	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH
 	 Ll$`L+L,9M;sBIvH
g
 y	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HHj	 H~rH6H{rHHH6  J&LJ0	 !  H;suHCHrHHHrHHHtJ!LJ0	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HHx	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0	 HCHrHHHrHHMtJ1MJ0HHN	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   IvΨ	 H|$0H   r#IH'H;w	 r Hx'HHGH\ HLHH	 CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH
 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHH HH*LKHML+IHHLI?IHt+IS HKHH+HHLI?LHKHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   HC 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH   HxH\$0Hl$8Ht$@H _%	 	 	 	 		 	 	 	 	 	 ߥ	 إ	 ѥ	 ʥ	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH   HxH\$0Hl$8Ht$@H _	 	 	 	 ٣	 ң	 ˣ	 ģ	 	 	 	 	 	 	 H(p    HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL-&
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1H@	 tVHڅuVHHcHMIHL1Hr	 I;u0D  H~/HHcHT1XHL1H	 u
Hջ   \$xHHcHHD1(    L-
 Ht$p\$xLd$(HHcHHE3	 1	 u
I|	 I$HcHJL!HHt#HHPI;uH   Ht[	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%2
 Ht#HHPI;uH   Htǟ	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1H0	 ADމ$   HHHcHAHL1H	 ADމ$   u(H~#HHcHT1XHL1Hٛ	 ADHL%
 Ht$p$   L|$(HHcHHD1(    HHcHHE3	 	 u
Ij	 IHcHJL9HHt#HHPI;uH   HtJ	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;tx	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1H$	 u   \$x7Hυu.I~rM6HHcHMIHL1HA	 I;t   +Ht*HHcHT1XHL1H	 uHՉ\$xHHcHHD1(    L-
 Ht$p\$xL|$(HHcHHE3	 	 u
IN	 IHcHJL9HHt#HHPI;uH   Ht.	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHH
	 H	 Hؘ	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHHj
 %H H;uIVHNH;HHQә	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HM:	 HH
 sHH[H;uIFHMH	 HH	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PH`v
 H3HEpMMHHH   D$     H
 HD$`HMp	 D$    E3E3HT$hHL$`9	 HD$`HcHH
 HD`HD$`HcHDxDD\   HL$hHHL$`HHg
 JHHoHHu
 0HIUHA	 HH>HUPHL$` HxrH H
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 HԐ
 HD$(H0
 HL$( LSUVWAVH   ICHt
 H3H$   MIHHH$   IC   IC    D$h A   H
 IK觼HD$`   HD$X    D$H A   H
 HL$HxHCH+HLOL+IL;t%HD$0Lt$(HD$hHD$ LHT$HH(  HD$`HrQHHL$HH=   r<t	 HAH;r	 H+Hs٘	 H'v̘	 H; HD$`   HD$X    D$H H$   HrQHHL$hH=   r<t	 HAH;rs	 H+Hsc	 H'vV	 Hż H$   H3E HĐ   A^_^][@USVWAVH$PH  HD$@Hs
 H3H   ILHDD$8   D$0    HM
 HD$PHM	 D$0   E3E3HT$XHL$P	 HD$PHcHH.
 HDPHD$PHcHxTL   HL$XH
 HL$PHH*HH
 Hȋ	 HH
 H   HL$PH   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@ݹHEx   HEp    E` A   H
 HM`貹HE@HD$ LM`LD$8IHH\$WH 	HHf/v\XH\$0H _\(XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3	 He  HLsHsHuH{H|$hL?LHt3	 He  HHwHuH~H   H{(H|$hL?LHt3H	 He  HHwC< HH2  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H	ۓ	 t
He  HH    Hk~LFHHI H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3HC   HHC    H 	HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHH;uH   Ht	 Ґ3H	 D$0t/HHcHHLHڑ	 u   |$`	H\$P|$`HHcHHE3p	 HHcHHLHHt*HHPHH;uH   Ht	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$hP uB3HD$8Hv
 HD$0H
 HD$(H HD$@HB
 HD$HHL$({P HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHH$z  ? t
HHÀ< uLHHtIE3HH貹HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLH~  HC   HHC    H [HH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
y  IE3HHǸA
   H:
 HbHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHIHC   HHC    H gHH0[@WH   HD$ H$  AHHH$   谝  HX(H
d
 HH0x8HH$   -N HHL$(?N H 
 HL$(Ŀ @SH   HD$PHj
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$( ȋD$ -ut=   w2t=w2ɄuB3HD$8H
 HD$0H
 HD$(H HD$@H
 HD$HHL$(L HL$pH3 HĀ   [@SH   Hi
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`L u-HT$PHL$Xo t9C,+<:wH     HrD$PH$   H3+ HĐ   [  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(g  @USVWATAVAWHl$H   HEHrh
 H3HEMcIcHLHM3ۉ]ϋ
| eH%X      Hȋ
9
4 ~_H
4  3 uHH!6    H6 5 DCH٬
 H
5 H
	 1 H
3 h HE   H]E A   H
 HM趯HE   H]E A   H
 HM華LOL+IAA;tLEHM{  HEHrPHHMH=   r<t.	 HAH;r	 H+Hs	 H'v	 Hp HE   H]E HEHrPHHMH=   r<tċ	 HAH;r	 H+Hs	 H'v	 H H?LIII_I_MtDHEt5HHHL;tEtHHHL;tMMt3@	 I[  IMwIwH}LuIHMLuHEHEHEHEHEHEL}IHHH+HHH~)HH;}
H}HMLHHM% IHMH3蕧 HĐ   A_A^A\_^[]@USVWAVHl$H  HD$@Hee
 H3HE IHH  HE   E3LuDuEFHf
 HM1HCDLEHH&HEHrPHHMH=   r<tى	 HAH;rɉ	 H+Hs	 H'v	 H H{urH f/* waHE   LuE E3H/
 HM耬HE   LuE E3H
 HM\HEHD$ LMHHA HHM&  HT$PH({  HM%	 }    E   HL$`HL$0L\$XL\$8HD$0HT$8I;HMHMLD$PW IH~N   If/sEHIH;|II|LHHd  HM	 HL$p	 HL$P|	 aHE   LuE E3H
 HMOHE   LuE E3Hڤ
 HM+HEHD$ LMHH@ HM H3 H  A^_^[]@SH LHHuHRAHH [HHRHcHHAHH [@USVWAVH$PH  HD$@Hb
 H3H   ILHLD$8   D$0    H
 HD$PHM	 D$0   E3E3HT$XHL$PW	 HD$PHcHHp
 HDPHD$PHcHxTL   HL$XHS
 HL$PuHHHH0
 [Hȋ 	 HH
 AH   HL$P0}H   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@MHEx   HEp    E` A   HG
 HM`"HE@HD$ LM`LD$8IH  LSVWH   ICH`
 H3H$   IHHIC   IC    D$h A   H
 IK襨HD$`   HD$X    D$H A#   Hh
 HL$HvHCLKL;t%HD$0H|$(HD$hHD$ LHT$HH  HD$`HrQHHL$HH=   r<t	 HAH;r	 H+Hs	 H'v؄	 HG HD$`   HD$X    D$H H$   HrQHHL$hH=   r<t	 HAH;r	 H+Hso	 H'vb	 HѨ H$   H3Q HĐ   _^[@UVWATAUAVAWH$@H  HD$8H$  H_
 H3H   MLL3ۉ\$0A   MPM;  EWɋHE~0MNHcI;}$IIIHf.z uHI;|AIIcI;  H
 HD$PH
 HD$`HM	 D$0   E3HT$hHL$P	 HD$PHcHH{
 HDPHD$PHcHhTLHD$hHD$@HL$h~	 H	w
 HD$hH]Љ]H^
 HL$`HH¥
 }HIHH
 cHȍV'	 HH
 HHAW	 HH
 ,H   HL$PvH   H   HC   Hǅ      3H   @}p@8:uD
IIB8<uHMp;IcHcMINHHIHEh   H}`EP E3H
 HMPHEPHD$ LMpLIIs- H   H3Þ H$  H  A_A^A]A\_^]@USVWAVH$PH  HD$@H\
 H3H   ILHDD$8H   D$0    H}
 HD$PHM	 D$0   E3E3HT$XHL$PV	 HD$PHcHHj
 HDPHD$PHcHxTL   HL$XHR
 HL$PtHHHH/
 ZHH|	 HH
 ?H   HL$P.wH   H   HC   HEX   HEP    E@ : uE3I@ IB< uHM@MHEx   HEp    E` A   HG
 HM`"HE@HD$ LM`LD$8IHtH\$WH HIH	 tHHiHH	 ZH}	 HHH\$0H _H%}	 H\$WH HIH}	 HH	HH	 H|	 HH3H\$0H _H%|	 @SH H	 IHH
 HHޛ	 Hb|	 HHH [H%T|	 H\$WH HIH	 THHIHH	 :H{	 HHsH\$0H _H%{	 @SH H_	 IHH
 HH&	 H{	 HHH [H%{	 @SH H_	 IHH
 HH^	 }H({	 HHH [H%2{	 @SH H	 I;HHQ
 ,HH	 Hz	 HHVH [H%z	 @SH H	 IHH
 HHv	 Hhz	 HHH [H%rz	 HHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 Le
 3f 2HHHHHD$0D$    L

 L%
 3& 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L
,
 Le
 3f 2HHHHHD$0D$    L

 L%
 3& 2HHHHHD$0D$    L
t
 L
 3 2HHHHHD$0D$    L
D
 L
 3 2HHHHHD$0D$    L

 Le
 3f 2HHHHHD$0D$    L
d
 L%
 3& 2HHHHHD$0D$    L
|
 L
 3 2HHKS  ;Q  HWATAUAVAWHPH@HXHhHpMLHIPI  I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8G  Hl$@LH\$8LIT$Ik  HtZHH)  HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HH HII HFH+HH;s(:\x	 Ux	 Nx	 Gx	 @x	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@HR
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`Hi	 H  3H  H  H	 HEpExH  HMpu	 Ho
 H  H
 H   HQr
 HE@Hs	 HEHHEPHEXHs	 HE`HEhHp
 HEH   _  H  _  H  l
   ~y   A   ~x DEHVXHzrHH   E3HH   HcHH   uHAPr	 H3r	 F|uH;	 H   HT	 auHB	 H   H	 @uH1	 H   H	 u2H 	 H   H	 HHHYs	 H    H   H6      H   HzrHA   H  ֢E3HH  HcHH  uHAPq	 H3jq	 F|uH	 H  H0	 auH&	 H  H7	 @uH	 H  H>	 u2H	 H  H=	 HuHH=r	 H  ٯ H  HHǅ     E3L  D   EFHG	 H   臗Hh
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  gH  HrSHH   H=   r<ts	 HAH;rs	 H+Hss	 H'vs	 H6 L   HNHYHyrH	HA   I;LBMtH	  u1Hu+Klғ H   LF8HV(HHH      襓 HHSk
 HH   WELuAEHUIHn
 HEWELuAN   D.DvDu~HH
b
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHI  DGHUHM蛙HD$ IH    HOHVH  Ht)L  L+IˉW  Hǅ      HUHtLEL+I蜉Htm
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHI褗  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHI  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHIK  DHUH   HM1HQH}LL+3n	 HH}H}8HO HU"Pw8HUHtLEL+I$H  HtL  L+IH}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMHIHǅ     Hǅ      ƅ   A   H*	 H  貑LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   菪 LH  UH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHIZ  D    PHM-HA
   H@	 LuI贐IN A   H3	 螐IN@A   H-	 舐IN`A   H'	 rI   A   H	 YHǅ     Hǅ      ƅ   A   HC	 H  #LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H     LH  AT    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHII  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIb  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  Dq  d  PHMBA
   H	 LuIIN A
   H	 IN@A   H	 Hǅ     Hǅ      ƅp   A   H	 Hp  跊LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H   蔣 LHp  N          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI'  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIz  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$   D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ ?  DLupEWA(WEHE    DEHUH+UHLEHMH  HMH+M HLM L+MILɋ   ~gfn
 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@F  G HOpH6  H   HMHD$ IH  j  HOH>FH  Ht)L  L+IyW  Hǅ      H   HtL0  L+IxH  HUA  H   H  UHǅ     Hǅ      ƅ   A   E3H	 H   ~HEHtTA   LH	 H   }LEI+LH  H   rGHH  HH  7HD   D   A   E3H	 H   y}H  HHEL@A   Hv	 H   J}HLLEH  H   FHH  UH  GH   H  ,\	 A   LH0	 H   |HL@A   H	 H   |LLGH   H   VFHH  fH   GH   H  [	 Hx  SHx  []	 H}8H  H  H;tIE3H  aIP  HW  Hǅ      MX  H  } HU H W   Hǅ0      LEH    LM LEH(  H   bQ  H  H  /C  H  H   9HOXHUp9MtI   IH   Ht&H(  H L0  L+IHksH  Ht=H  H H  H+H*HHLI?LH2bH  uEH   hEHUHtLEL+I>uH}Ht HU H LE(L+IHrH} HtHUH LEL+IHrH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H	 Hp  H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H   謘 HHEpHp  CH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    u    DW   E3L0  L   H   H    H(  H   H+I*IHHHH?HHH  =EL  L  M+IMt ff     HHKIHM;rH}8H  H   ?  H  HUS6H  H  @;HOpH/  HU HMׁHD$ IHMU  HOH)?HUHtLEL+IrWELuHU HtLEL+IqHMpHtH   H  HtL  L+IqH   Ht:H(  H H0  H+IHHLI?LH6^E3H}HtH   HHUHtLEL+IAqWELuH5I
 HuH]HtHH  LEL+IHnHM
 H@  HP  @H@  Hx  MHx  HW	 H  -  H   -  AH  H3v L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHH&3fD  H;_s^I4H{  HHHm  H;^  r
   躇HH$   Ht
(RHHHD$8HHMLD$8H$   H  H$   pH      ?HHH=
 H
+
 H9

 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI&;HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v
W	 H    H=   r<tV	 HAH;rV	 H+HsV	 H'vV	 H3{ 
 (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH$3fD  H;_s^I4H+
 HHH
 H;
 r
   jHH$   Ht
(HHHD$8HHMLD$8H$   H  H$   pH      ?HHH=
 H

 H9

 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI8HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;vT	 H    H=   r<tT	 HAH;rT	 H+HsT	 H'vtT	 Hx 轞 (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH

 P	 HL$8@  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   HHL$@LD$8H$   Ht(HkHHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8?  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8
?  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
 N	 H
 N	 MLD$8H$   IV  H p	 HL$8Ht{HD$HH+HH;vQ	 H    H=   r<tsQ	 HAH;rcQ	 H+HsSQ	 H'vFQ	 Hu WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
O
 yM	 HL$8~=  3I9~  HL$@LD$8     I4Hq
 HHHc
 H;T
 r   HHL$@LD$8H$   Ht(H;HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8[<  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8;  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
c
 K	 H
U
 K	 MLD$8H$   If  H p٘ HL$8Ht{HD$HH+HH;v_N	 H    H=   r<tCN	 HAH;r3N	 H+Hs#N	 H'vN	 Hr WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HWATAUAVAWH  HǀHXHp)p)xD)@D)HD)PH(
 H3H$  MLHL$ H$@  3H1IU IEH+HHurH!U	 H$  3H$  H$  H 
 H$  Ƅ$  H$  H$  K	 HkE
 H$  H
 H$   DDT$pIEH+HHwrHT	 H$  3H$  H$  Hq
 H$  Ƅ$  H$  H$  J	 HD
 H$  H
 H$  @ A   DJDL$xWD$83H|$HMcFxLD$(DIM  HT$@fD  IEI+E HL;  IIIE 4t$0HD$0HL$8H;   HD$0H;   Lt$0L+IH;uyHH+HHsiH+HIIH+H   HH+HHHIH+HLH;LCL;ICHL$8?Ht$HHT$@HL$8LD$(HtJHItH;ufHH+HHsVH+HIH+HrtHH+HHHIH+HLH;LCL;ICHL$8跊Ht$HHT$@LD$(Ht2HHT$@IM;   H
.}
 XG	 H
 }
 JG	 H:R	 H$  3H$  H$  H
 H$  Ƅ$  H$  H$  H	 HB
 H$  H
 H$   IEI+E HL;rrHQ	 H$  3H$  H$  H
 H$  Ƅ$  H$  H$  H	 HB
 H$  H"
 H$  e IIIE 躟 (EWAX|$(WL$PLH|$`HD$ LcH,L$  LH|$hM4  HT$XfD  IEI+E HL;  IIIE 4t$0HD$0HL$PH;   HD$0H;   Lt$0L+II;   IH+HHsqH+HIIH+H
  HL+IIHIH+ILI;LCL;ICHL$PKLd$`HT$XHL$PLD$hL$  HtJHI   I;urIH+HHsbH+HIH+H   HL+IIHIH+ILI;LCL;ICHL$P贇Ld$`HT$XLD$hL$  Ht2HHT$XILD$hM;   eH
z
 HD	 H
z
 :D	 H*O	 H$  3H$  H$  H	}
 H$  Ƅ$  H$  H$  E	 Ht?
 H$  H|
 H$   HD$pH;C   LHD$pL;   L|$pM+IHCH9CuqH+CHHscHKI+HIH+HsH
5y
 _C	 HSI+HHLCM+IIHL+IHM;HCH;HCH@HKHHtJHA   )HCA   H9CuAH_HCHtDHCHD$xH;CsCHHL$xH;w6Lt$xL+IHCH9CuIHn_HKHHt,JH#HCH9CuIHD_HCHtDHCDHD$ L|$89xx~)H@      IcIHa(AD;wx|3HD$(H;CsCHHL$(H;w6Lt$(L+IHCH9CuIH^HKHHt+JH"HCH9CuIH^HCHt8HCDHD$ Ll$Px, ~2Lfff     IcH    IH'AE;w,|L|$8$H   u8MtM+IMI\M  I+HLI[  W$   H$   
    HǄ$     H$  Ƅ$   A   EH(t
 H$  gHǄ$     H$  Ƅ$   EEHu
 H$  fLt$ EFxEyH$  H$  *H$  <+H$  .+D$  IcVxW$  H$  L$  H$  W^HH$  L$  I+HI      HtM4HH;rHHtf     M4HH;r
    HǄ$     H$  Ƅ$   A   HYw
 H$  eHǄ$     H$  Ƅ$   A   HFt
 H$  eHD$ D@xAyH$  H$  H$  )H$  )D$  HD$ @xHcW$  H$  L$  H$  ]HH$   H$  H+HHtL4HH;rHHt     L4HH;r
    HǄ$     H$  Ƅ$   A   H=s
 H$  dL$  IH$  {  DH$  (EfD  HD$ D;pxI  
    HǄ$p     H$h  Ƅ$X   A   Hr
 H$X  dHǄ$P     H$H  Ƅ$8   A   Hq
 H$8  cIcL$X  HH$    H$  L$8  HHL$8  0H$  X0HǄ$0     H$(  Ƅ$   A   Hr
 H$  [cAIcL$  H$  ?  0H$  'H$8  'H$X  'Ht$HD$  =
 fD  D;hxL  
 %   HǄ$     H$  Ƅ$x   A   Ho
 H$x  bHǄ$0     H$(  Ƅ$   A   Hq
 H$  obHǄ$P     H$H  Ƅ$8   A   Hp
 H$8  8bMcHL$ H   L$x  I  HD$(L$  IH$    H$  E}IcL$8  H$    H$  ^ (\HD$(A\YHǄ$p     H$h  Ƅ$X   A   Hp
 H$X  xaL$X  IH$  _  0H$X  %H$8  %H$  %H$x  %
 &   HǄ$     H$  Ƅ$x   A   Ho
 H$x  `L$x  IH$    DXD$  H$x  ?%EL$  HD$ L
    DD;px}IcIHh AHD$ DL$   @xHD;}IcH    I0 AHD$ H$   $P      MtL$  M+II~TMtL$  M+IIaTH$   Ht#LL+IDTW$   H$   HT$PHtL+IMTWD$PH|$`L|$8Mt I+HLISWD$8H|$H{MtL$  M+IISMtL$  M+IISH$   HtH+HLSHT$PHtL+IMmSL|$8XH$  H3X L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_LWH`ICI[IsHi
 H3HD$XHIK3t$ H1HqHqD$    HaHD$P   Ht$H@t$8DFH_	 HL$8^HD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHRHH;HKHthHA   HqHyrHHH@HCH9Cu
   HRHKHt(HA   HqHyrHHHT$8  ;cHC HD$PHrQHHL$8H=   r<t(:	 HAH;r:	 H+Hs:	 H'v9	 Hj^ HHL$XH3V H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUHL?LLE   HuHI?LuI;   HHMHHMRs HH HMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHW] HI;{8	 8	 8	 8	 8	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   H'=HOHMPH[HHHMXHt2HGH9Gu
   H<HOHMPHMXHt
HURHGHMHtiHEH+HI;v7	 H    H=   r<t7	 HAH;r7	 H+Hs7	 H'v7	 H[ H   IH  HMH+IHHHH?HH
H;v>7	 HRHH=   r=@t!7	 HFH;r7	 H+Hs7	 H'v6	 HH`[ HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHH  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   H=HSHt(H
H;Cu
   H=HCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H<HSHt(H
H;Cu
   H<HCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_@WHpHD$ H$   H
 H3HD$hHH
f.
P
 zu	P  HD$`   HD$X    D$H A   H'i
 HL$HWHD$@   HD$8    D$( A   Hi
 HL$(nWLLHT$HHL$(h HD$@HrQHHL$(H=   r<t4	 HAH;r	4	 H+Hs3	 H'v3	 H[X HD$@   HD$8    D$( HD$`HrQHHL$HH=   r<t3	 HAH;r3	 H+Hs3	 H'vy3	 HW \ HL$hH3^P H$   Hp_H\$Ht$WH IHHH;t HHHHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HH	WH H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`.	 H5
 Ht$hH
/	 x/	 HHEH;xsHHHH   3ۀx$ t.	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8HN
 HD$0H$
 HD$(H HL$(a H\$hH
 HHRHN HL$` .	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$P-	 H
 HD$XH
.	 e.	 HHFH;xsHHHH   3ۀx$ t-	 H;xs
H@HHumH\$XHucHHL$X-	 Hu13HD$8HxM
 HD$0H#
 HD$(H HL$(` H\$XH
 HHPHM HL$P,	 HH\$`Ht$hH@_H\$WHPHw
 H3HD$@HHD$8   HL$ HD$0    ID$  E3|THLD$ HWHH HHD$8H+HHrQHL$ HH=   r<t/	 HAH;r/	 H+Hs/	 H'v/	 H2T HHL$@H3L H\$`HP_H(Hu3H(HH;w*H\$ H    Hs.	 HuHuH\$ H(gg@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0 t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHR  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHRu  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H  H"
 HCPH [HL$SH0HD$ HD$P    EtHF
 HA@HC"
 HAPD$P   J   H'
 HH	I
 HCHC@HcHH)
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH.4	 HHQ3HHBHK*	 H$
 HH{3HHDH^H\$HH*
 HHOHKHtHPHGHCHGHCG C H
 HH+
 HHH\$PHt$XH0_H!!
 HH@SH HHI0*	 HK *	 HH [H%*	 HY
 H@SH HH   H`HcPH>$
 HHHHHcPDHDDHhz(	 HH [H%+)	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3	OHo(Hs(H;t<HHRH݄HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHdHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3ONGxCxGyCyG|C|H   H   H;tIE3N                                                  HH\$HHl$PHt$XH0_H\$WH H  H}
 HGPt
X   HM HH\$0H _@WH0HD$ H\$@HH
 HHF'
 HAHI HtHP tHC     Hx0	 HHK'	 @t
@   HM HH\$@H0_H	HtH   H @UVWAVAWH$@H  HD$8H$  H9
 H3H   IILHE3D|$0AA fAn	ff/rHHrY  H'
 HD$PHI$
 HD$`HM&	 D$0   E3HT$hHL$P%	 HD$PHcHHE 
 HDPHD$PHcHhTLHD$hHD$@HL$h@#	 Hh
 HD$hL}D}H\
 HL$`HL$`$	 H   HL$PH   H   HC   HEh   L}`EP : uMIfD  IB< uHMPIHǅ      L   Ep A   H[
 HMpIHEPHD$ LMpLIH4  H   H3C H$  H  A_A^_^]@UVWAVAWH$@H  HD$8H$  H9
 H3H   IILHE3D|$0AA	A;|HHrU  H)%
 HD$PHU"
 HD$`HM&$	 D$0   E3HT$hHL$P#	 HD$PHcHHQ
 HDPHD$PHcHhTLHD$hHD$@HL$hL!	 Ht
 HD$hL}D}HZ
 HL$`HL$`"	 H   HL$PH   H   HC   HEh   L}`EP : uMIfIB< uHMPGHǅ      L   Ep A   HY
 HMpGHEPHD$ LMpLIH  H   H3A H$  H  A_A^_^]@UVWH   HD$8H$   HU H3H$   IHH3IHIPHHH   M II           HcAD$0HD$0I#I;wHHHH;r   HD$X   HD$P    D$@ A   HX
 HL$@FHD$x   HD$p    D$` A   HUX
 HL$`FHD$@HD$(HD$`HD$ LLHHm  H$   H3<@ H$   HĐ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   III       HcD$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HTW
 HL$@zEHD$x   HD$p    D$` A   HW
 HL$`KEHD$@HD$(HD$`HD$ LLHH5  H$   H3? H$   HĐ   _^]@SVWH   HD$0H H3HD$xIHHA8 |HD$P   HD$H    D$8 A   HV
 HL$8DHD$p   HD$h    D$X A   HCV
 HL$XqDHD$8HD$ LL$XLHHS  HL$xH35> HĀ   _^[@UVWH   HD$0H$   H H3HD$xIHH3IHH   IW    Hcf/v
HH;r   HD$P   HD$H    D$8 A   HU
 HL$8CHD$p   HD$h    D$X A   H:U
 HL$XhCHD$8HD$(HD$XHD$ LLHHR  HL$xH3$= H$   HĀ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   II      @ f     HcD$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HtT
 HL$@jBHD$x   HD$p    D$` A   H
T
 HL$`;BHD$@HD$(HD$`HD$ LLHH%  H$   H3; H$   HĐ   _^]@SH0HD$ HH
 HH-
 HAHI HtHP tHC     H_&	 HHKH0[H%d	 @SVWH   HD$8Hm H3H$   IHHA D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   HR
 HL$@AHD$x   HD$p    D$` A   HR
 HL$`@HD$@HD$ LL$`LHHJ  H$   H3: HĐ   _^[LH   ICAC    HQH
 ICH
 ICAC   IKH,
 HD$(Hh9
 HD$@HD$hHcHH
 HDhHD$hHcHDd    H HL$(L @SH0HD$ HٹX   = HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHo
 HH8
 HAHA@HcPHB
 HD
@HA@HcPDBDD
<H5
 HH
 HAHI HtHP tHC     H#	 HHKH0[H%	 @SH0HD$ HH
 HH=
 HAHI HtHP tHC     Ho#	 HHKH0[H%t	 HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf  HWH:  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHXc pMt/HWI  HOH+IHHLI?LHRHNH+IHHHH?HHtLHVHb HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+H2HH+HH4H+H2HOHHLH+HH+_  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   8 HH$   LCMu	H35
 
IP(HuIP0HL$(K	 HǄ$      3Hz	 H"
 HHH4  H>HL$(	    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
J
 	 H;s/LeHtH{HsrH3 H\$0Ht$8H _HsH;LƲLB3HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    Hj
 HH	 HAH   W	 D$H   H_E3HH	 HHcHH
 H9HHcHHT9H\$PH	 H
 HC| Cq H}	 Hǃ       H#
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH0	 HH
 HAHI HtHP tHC     H	 HHK	 @t
@   Hx: HH\$@H0_H\$WH HHHUt
  H;: HH\$0H _@SH HH		 HKH [H%	 LHXICLI@I+ HHQH;rQH	 IC3ICICHK
 ICD$0ISIK	 H
 HD$8HJ
 HL$8  HBHAI HXDD$HL$WH0HD$ H\$HHt$XHH3t$PH	 HA@H

 HAPD$P   H
 HHOH0
 HHG@HcPH_
 HD:@HG@HcPDBDD:<HSHHD!.HH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H		 HtHLHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
F
 4	 L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HHPHSLHH? HH{H+HHtLCL+I\*HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
D
 	 H|$@K<H   HvH
D
 	 H9{s#HH_H   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0	 H{rHHHtLHg H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%(	 HWAVAWH   HD$(HXHp H H3H$   LLHL$ H
	 HT$0I
	 3IFIF IF(HT$`I
	 H
?-
   IFI
	 HHHHǀ<8 uHǺ   Hs	 HHu	 HHtHRHvHuIN I-
	 HHÀ< uHú   H 	 HHu	 HHtff     HIHHuIV(fAF.,H$   H3, L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
/B
 	 LAI+H|$8H|$PH;HGIHH;wH
A
  	 Ht$0I48H  HvH
A
 	 H9qs H]H   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8
	 I;u>HKI?MIDHrHHHrHHHt8HL	 *I~rM6H{rHHHtK>LXd H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HHԯ HH0[@SH HHHSH
q	 H3H
HJHH	 3HC HC(HC0Hv	 C8HH
 HCHH [@SH0HD$     - HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH
a?
 		 I4L+IIHH+I3I;HCH;HCHt$@H&OLHD$8HD$0LHT$xHY` HD$0LH$   H$   \\ HD$0LHWHL$x&` HWHHH+HHHtg  HLGL+ID!HIHwHIH_L7%IH[ HHWLHL$x H_H\$pHPA^_^@SUVWH  HD$8H H3H$  IIHHI@I+ HL;A  HL$@OHB
 HL$PgHH	 HHA
 gHHpA
 gHH)A
 gHH@
 gH$  HL$@SH$  H$  HC$  HǄ$X     3H$P  @$@  @8:uD
IIB8<uH$@  -HǄ$x     H$p  Ƅ$`   A   HLA
 H$`  o-HCH+HHD$0H$@  HD$ L$`  LD$0HH虮 H$  H3' Hĸ  _^][@USVWATAUAVAWH$H  HD$@H H3H  IHLLL$8LP  LX  L`  3ۉ\$0H

 HD$PHM	 D$0   E3E3HT$XHL$P	 HD$PHcHH	 HDPHD$PHcHDxDDLSHL$Xd:HHL$PiHHiH  HL$PHr
 HE@H   A	 D$0   E3E3HUHHM@	 HE@HcHHT	 HD
@HE@HcHDxDD
<SHMH9H<
 HM@.eHISiHIHiHH;
 	eHI	 HH;
 dH  HM@H  H  HC  HǅH     H@  0  8uDIIB< uH0  *Hǅh     H`  ƅP   A   H5
 HP  *H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  u*H0  HD$ LP  LD$8Hp  I譫 Hx)t$`()|$PD)D$@DЩ
 D)L$0D
A
 fD/D)T$ EWA(r`A(\(,] (\f/
 vAXfA.zu	 
  !      =ܩ
 Y(] ^fA.ztf/5s
 r
(職 O
w
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(蠸 X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     H
 HD$`HM	 D$    E3E3HT$hHL$`	 HD$`HcHH	 HD`HD$`HcHDxDD\   HL$hg6HHL$`eHH!
 aHHeHH'
 aHIeHAY	 HHeHUPHL$`pHxrH H
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 H\
 HD$(H( HL$(<4 @SH`W)t$Pf/D)D$0D(   u+DWϱ
 3A(W
 (t$PD(D$0H`[L
 fA/DW
 A(v(

 \((t$PD(D$0H`[3bX
 (t$PD(D$0H`[5
 fA/)|$@D)L$ D
X
 !  r
 fA/vTfD.z  
 eH%X      HЋ9
   %
 AYDY
 AX  ]
 eH%X      HЋ9>
 
  A(AY(Y((Y%z
 (Y

 Y_
 X%O
 X

 X7
 YYYw
 X%
 X
O
 YXK
 XYX^X%S
 AY  3t
{
 	
 fA/  w
 eH%X   =(
 fA/   HЋ   9
   A(A(\AYW
 (Y0X ((Y(
 (Y
 (Y
j
 X
 X
 A^X
=
 YYYX
 X

 YYX(Y
 X

 X
 X
 YXΘ
 YX^XR
 Y  Y
 fA/   9h
 '  A(A(\AYW
 (Y8W ((YH
 (Y5
 (Y
ڥ
 X
 X

 A^X

 YYYX
 X

 YYX(Y
 X
 Xb
 YXX
B
 ^X
 Y  
 fA/   9
   A(A(\5f
 AY(W
 YHV ((Y
 (Y
 (Y
b
 X
 XҚ
 A^X
5
 YYYX
 X
	
 YYX(Y

 Xz
 X
 YXX
ʝ
 ^X
 Y   9ۨ
 Z  A(A(A^AY(YW
 nU ((Y
 (Y
 (Y

 X
 Xx
 A^X

 YYYXG
 XG
 X

 YYYX
 X

 X(Y
 X
 YXh
 YX^XĠ
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
n
 % =b
 
 H
M
 դ
  H
$
  =
 ([
 H

 (
 6
 Ƣ
 F
 (O
 h
 
 

 (
 Z
 
3
  qH
R
 i =F
 V(
 H
2
 (
 l
 (}
 ~
 (_
 
`
 (
Q
 
 2
 

 (
 
 

  H
4
  =(
 (
 H

 (
 
 (
 

 (
 
 (s
 
t
 (

 v
 

  [H
6
 ] =*
 .(
 H

 (
 0
 (!
 
2
 (
#
 4
 (
 
n
 (
7
 p
 
y
  H
t
  =h
 (
 H
T
 (
q
 *
 (
 <
 
 <
 (
 

 (

 p
 
 
Q
 (
J
 r
 
[
  @USVWATAUAVAWH$H  HD$@H, H3H  IHLLL$8LP  LX  L`  3ۉ\$0HZ	 HD$PHM+ D$0   E3E3HT$XHL$P HD$PHcHH;	 HDPHD$PHcHDxDDLSHL$X+HHL$PF[HH;[H  HL$PH	 HE@H    D$0   E3E3HUHHM@\ HE@HcHH	 HD
@HE@HcHDxDD
<SHMH+H[-
 HM@~VHIZHIZHH.-
 YVHI HH,
 >VH  HM@.H  H  HC  HǅH     H@  0  8uDIIB< uH0  JHǅh     H`  ƅP   A   H?'
 HP  H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  H0  HD$ LP  LD$8Hp  I
  @USVWAVAWH$xH  HD$PH` H3HEpIMHHL   D$     H	 HD$`HMp D$    E3E3HT$hHL$`9 HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h(HHL$`XHHg
 JTHHoXHHu
 0THHUXIHuH
 HTIH IH#XHUPHL$`HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@x H	 HD$(H HL$(& DD$USVWAUAWHl$H   LjLy3HHM;otI Mt
III7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH' Mt
IbHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMb HIH HHGHGHtHl    H
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM$ w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH? Mt
IzHH7LEwH_HUoLwH H}HEHHMLwH]LuHEh W(f.z
u5
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]Lu^ IUHO(LG(IHr HW(H|$ IQ G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM ($   L$   HL$   fG<Hĸ   A_A]_^[]F+@+:+@SH HHHSH
A H3H
HJHH 3HC HC(HC0H.	 C8HHe HCHH [LHXIC3ICH
 ICH	 ICHg
 ICH)
 ICIK趯 @USVWH$HH  HD$@H H3H   IIHT$8D$0    H	 HD$PHM D$0   E3E3HT$XHL$P HD$PHcHH	 HDPHD$PHcHDxDDL   HL$X^"H$
 HL$PMHHQHHw$
 MHHV HHD$
 MH   HL$PvH   H   HC   HEX   HEP    E@ : uE3IIB< uHM@HEx   HEp    E` A   H
 HM`nHE@HD$ LM`LD$8HH
A
 T@UVWATAUAVAWH$0H  HD$XH$(  H H3H  IH\$@HHT$8HL$HE3Dd$0iLKI  EM  
/
 
     M]MM;}UHN    IIIHIIIL@ f     A \Tf/rIHMM;|MM;  H	 HD$`HMk D$0   E3E3HT$hHL$`4 HD$`HcHH{	 HD`HD$`HcHxT\HD$hHD$PHL$h H	 HD$hLeE   H"
 HL$`5KHHZOHH"
 KHIU HHD!
 JHIW HH
 JH  HL$`H	 HEPH   i D$0   E3E3HUXHMP4 HEPHcHH|	 HD
PHEPHcHxT
LHEXHD$PHMX H	 HEXL   ǅ      H;H[IIH!
 HMP'JHHT$8JNHH!
 JHIW HH4 
 IHIUr HH
 IH} H  HMPH  H  HC  HǅX     LP  ƅ@   : uMIfD  IB< uH@  H  H  HC  Hǅx     Lp  ƅ`   : tIIB<" uMH`  wHD$@L H@IIMH@  HD$ L`  HT$8HL$H͗  H  H3	 H$(  H  A_A^A]A\_^]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;t1$IHHt3 HԻHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     H	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$hWHHL$`JHH
 FHHJHH
 FHIJHI	 HHJHUPHL$``HxrH H
v HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H4	 HD$(HX HL$(, HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH
 HEL%P	 LeH	 HEH:	 HEL57	 LuD$    L-<	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH] HE3HEHEHUHM H	 HD$0He	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP Hn	 HD$@H"n	 HD$HE   
q
 eH%X   A   HȾ   A9

 Z  H

 H =
 A  NW LHEwHy	 IF@Hv	 IFPD$    HT$0I  Hv	 IH	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw܆ HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHME
 fsfH~HtBHMH
 j
 H

  L5V	 G
 
 fsfH~HtpHM	 HD$0H	 HEHEHcHH~	 HD
HEHcHQT
Ld$0H^ H]HMh Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM- LmHMHtHR Hڍ
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH3
 HEL%	 LeH	 HEH	 HEL5	 LuD$    L-	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH
 HE3HEHEHUHM HQ 
 HD$0H	 HEHEHcHHZ	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP Hk	 HD$@Hj	 HD$HE   
dm
 eH%X   A   HȾ   A9
 Z  H

  =
 A  NW? LHEwH)	 IF@H&	 IFPD$    HT$0I蕱  H	 IHt	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHMYE
 fsfH~HtBHMH
w  H
^
 Q  L5	 g
 p
 fsfH~HtpH	 HD$0HI	 HEHEHcHH	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR H
 H$H  H   A_A^A]A\_^]@UVWATAUAVAWH$pH  HD$HH$  H H3H   MHHHL$(3Dt$ IPI谇  IIFHCH+HsHI豹[  WD$0Ht$@HHM`rHT$0He L|$0ILd$8M;  Hh	 H
)	 HL$`HT$pHM- ADl$ E3HT$xHL$` HD$`HcHHW	 HD`HD$`HcHhT\HD$xHD$PHL$xR Hz	 HD$xHuuHHL$p1@HH:	 ;HsH+3H3Ht(HHL$p HH:	 ;HH;rHHL$pf HH:	 ;HU`HL$`IHIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICI*HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICIZ*IvHtrHF   3HNH~rHHƈHsLGItHH
 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM] HI;t(H|$(39H

  H

  Mt6IIL  HL$@I+H*HHLI?LI1H   H3 H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHM(HHM<WE3H]Ll$8H|$0\$(L$ LMMHHM' HE   H]]DCH<d	 HMsHHUHP HEHrPHHMH=   r<t( HAH;r H+Hs H'v Hj L|$8H|$0Lt$(EwD$ ]oLEHUH諯 HUHt LEL+I@WEHE    HUHtLEL+IgHMH3y H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   HHT$PHtLD$`L+IHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xH H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`$HHL$d7W$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$x H$  XL$   HT$xI (D$@IH$  IPH$x  H$x  , E3|$@L$   L$   Ld$pH|$hH$  H`	 H$  t4H(  IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   Ha	 H$  H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH
	
  HQM+IIHL+IIM;HCH;HCHL$H4#HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH

  HQM+IIHL+IIM;HCH;HCHL$H"HL$PHt0HA   LqHyrHHH$    HL$PH HL$PH$  `AEHT$HIqI$H
	 H;tHT$HIP A$     D
 Dvv
 $     W$  L$  H$  /D$0D$(H$  HD$ LD$xI:H$   H$  eHXH$   蔼HtIH$  IPHD$@HD$ A   L$  HT$pH$  DO I$L@H
	 H$  H;uIL$IAАH$x  H$x  z H$  HtL$  L+I|$@HHHH;tHD(L$   HT$xI (D$@H$      H$    HH^	 H$   q0HHuI
H HcHHHW
   H$   i HƋH HH/	 "0HH^	 0HHuI
H HcHHHW(A\(H HH]	 /H( HHi/	 /IH$   IPATH$x  H$x   fD/s;$  H|$haW$  L$  H$  D$0D$(H$  HD$ LD$xI詄H$   H$  HXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  L I$L@H
	 H$  H;uIL$mIAАH$x  wH$x   H$  HtL$  L+IGHL$HHt.HT$Px  LD$XHT$HL+IWD$HLt$XH$x  H$x  s HT$xHt%L$   L+IWD$xL$   H$   HtL$   L+I3H$   H3  L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xH H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xYHHL$|lWEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`O H  H  H  n? H  HUH   ƙH  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#35 HuHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  i H      	    	    	    	     	    Hc(	  H  8  ={
 Wt$XH  HX	 H  *H(L IH  IPWD$@Ll$PHǅ     L  ƅ   A   HX	 H  H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@hHL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
	 G HQM+IIHL+IIM;HCH;HCHL$@HL$HHt/HA   LiHyrHHH    HL$HH HL$HH  薳AEHT$@HRgIH
H	 H;tHT$@IP 0	  @   WELmH  D$0D$(HEHD$ LD$`H}H  H  ̿HXH  HtIH  IPHD$XHD$ A   LEHUHME IL@H
	 HUH;uIOvIAАH(  聿H(   HUHtLEL+IZH
#Lc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HCU	 H  WIH  IP H  ɱH    D8  Wt$XH  HL$`蘭3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   tH`     HM5 HH&	 H   %HHu3
H HcHHHWHH HH%	 %   HM HH&	 H   %HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HHq%	 8%H(  <j (YH     HM: HH%	 H   $HHu3
H HcHHHW   HM	 LHu3
HHcHHIPA(H` HH*%	 $   HM( HH<%	 H   t$HHu3
H HcHHHW   HM8 LHu3
HHcHHIPAH  0i (H HH$	 $
   HMH HH$	 H   #HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H? HHI$	 x#
   HMh HHS*	 H   S#HHu3
H HcHHHW   HMx` LHu3
HHcHHIPAX  H HH(	 "HP     HM HH*	 H   "HHu3
H HcHHHWHHW HH)	 "H%+	 H   u"HHh  &HH*	 W"IH   IPH(  *H(   0	  HuH  H  ϹHXH  H   IH  IPHǅ     3H    E3HG H  &H  H  H  HC  H  L  Mt
H  cH  f@  W  H  H  菺D$0D$(H  HD$ LD$`HvH  H  ȸHXH  HtIH  IPHD$XHD$ A   L  HUH  > IL@H
~	 H  H;uIOiIAАH(  tH(   H  HtL  L+IGEH

@
  W  3H  H  nD$0D$(H  HD$ LD$`HzuH  H  觷HXH  תHtIH  IPHD$XHD$ A   L  HUH  = IL@H
]	 H  H;uIOHIAАH(  SH(   H  HtL  L+I&3Hǅ     H  ƅ   H  Ex4A"   HM	 kIH  IP H  ݩ5A$   HM	 7IH  IP H  詩F   EH  E  LH~'	 H  0MHIAP H  cH  VHL$@Ht.HT$Hh  LD$PHT$@L+IWD$@H|$PH(  H(  t H  7  H  軐  H(  εH(  A HT$`HtLD$pL+IWD$`H|$pHUHtLEL+IH`  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xH H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$x9HHL$|LWEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`/ H  rH  H  ~' H  HUH   覉H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3 HUHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  bY H Hc	  H  %  	    (	    0	    8	    @	    H	    HcP	  H  8  =k
 Wt$XH  ѳHyI	 H  mH( IH  IPWD$@Ll$PHǅ     L  ƅ   A   HAI	 H  H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	 ȹ HQM+IIHL+IIM;HCH;HCHL$@5	HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@HL$HHt/HA   LiHyrHHH    HL$HH HL$HH  cAEHT$@HWIH
	 H;tHT$@IP X	  @   WELmH  ]D$0D$(HEHD$ LD$`HlmH  H  虯HXH  ɢHtIH  IPHD$XHD$ A   LEHUHM5 IL@H
U	 HUH;uIOCIAАH(  NH(   HUHtLEL+I'H
Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HE	 H  'IH  IP H  虡H    D8  Wt$XH  HL$`h3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   DH`     HM HH	 H   HHu3
H HcHHHWHH_ HH	    HM HH	 H   kHHu3
H HcHHHW   HMx LHu3
HHcHHIPA(Hϵ HH	 H(  Z (YH     HM
 HH 	 H   HHu3
H HcHHHW   HMٴ LHu3
HHcHHIPA(H0 HHj	 i   HM( HH 	 H   DHHu3
H HcHHHW   HM8Q LHu3
HHcHHIPAH   Y (H HHF 	 
   HMH HH 	 H   HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H HH 	 H
   HMha HHs 	 H   #HHu3
H HcHHHW   HMx0 LHu3
HHcHHIPAX  H HH	 Hp     HMͲ HH 	 H   HHu3
H HcHHHWHH' HH	 XH 	 H   EHHh  fHH 	 'IH   IPH(  H(  m X	  HuH  H  蟩HXH  ϜH   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  3H  6@  W  H  H  _D$0D$(H  HD$ LD$`HkfH  H  蘨HXH  țHtIH  IPHD$XHD$ A   L  HUH  |. IL@H
N	 H  H;uIO9IAАH(  DH(   H  HtL  L+IEH
ݴ@
  W  3H  H  >D$0D$(H  HD$ LD$`HJeH  H  wHXH  觚HtIH  IPHD$XHD$ A   L  HUH  [- IL@H
-	 H  H;uIOIAАH(  #H(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H`>	 ;IH  IP H  譙5A$   HT>	 IH  IP H  yF   EH    LHN	 H  MHIAP H  3H  &HL$@Ht.HT$HX  LD$PHT$@L+IWD$@H|$PH(  ѥH(  D H    H  苁  H(  螥H(   HT$`HtLD$pL+IuWD$`H|$pHUHtLEL+I螷H  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pDHHL$tWWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHM(t H	 H   H   HuH   HEL}HEHHUH+HWEHt!3P HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%	 LeH1HEH]LL+tHH WED$xHE    HL$xHT$xH   H   PAEHT$xIIHHT$xHP HL$xHt|HUU  HEHL$xH+HHH;v HH=   r<t HAH;r H+Hs H'vح HG Ld$xHM)~HEHMHMHULL+tH EEfEML   HT$xHM  L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H   踧  +fn^5`Q
 LM(WLM(W(WHM#LeHMܫ Hҫ Hʞ	 H   HMHtsHEH+HHH;vz H    H=   r<t^ HAH;rN H+Hs> H'v1 H 3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHH%XH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHP H$   1L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHVH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHSH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHp H$   AL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHRH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   菾L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   贶HH   ŲWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$pi H{	 HEWHM; H	 HEHi	 HEH}H	 HEH   HEH   HE(L
 )E (
>J
 )ME        H
 E(E0    E4 WE8Hו	 HE   f/vM   f/vF
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM HW	 HEH	 HEHM HM HM H	 HEHT$pHtLEL+Iݺ3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   足HH  ǯW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$pf Hw	 HEWHM7H	 HEHe	 HEH}H	 HEH   HEH   HE(I
 )E (
:G
 )ME        E
 E(E0    E4 Wu8EH H	 HEPsC
 Ex(
I
 )    E
    uXW)E`HE	 HEH5	 Hu@P  f/vE=C
 X  f/vf/vM`  OȉM$Y	 Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM Hu@H	 HEH2	 HEHMܞ HMҞ HMȞ H	 HEHT$pHtLEL+I3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHKH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHl H$   荶L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHEJH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH* H$   ۴L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHUGH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH H$   蝳L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHFH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH: H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   HH   %WEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$p\ H}	 HEWHMH\	 HEHɁ	 HEH}H	 HEH   HEH   HE(y?
 )E (
=
 )M:
 ] WM0E(
   H	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHMH HX	 HEHU~	 HEHM HM HM H	 HEHT$pHtLEL+I>3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   HH  (W   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$pY Hz	 HEWHMHY	 HEH~	 HEH}H	 HEH   HEH   HE(v<
 )E (
:
 )M=7
 } Wu0E(
   E@ Hx}	 HEH(;
 )Ep(
Z>
 )   W)EPu`Hp	 HEH5m	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
 8
 (v Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMy Hu8H	 HEHz	 HEHML HMB HM8 H1	 HEHT$pHtLEL+I苪3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pHm H3HE AALL   L   H   L  H  HEI`   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$p^HHL$tqWE3H}Ht$8Ll$0D$(t$ LL$pMIHMZV WD$XH|$hHE   H}@} DGH	 HM 藴HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$XTHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
		 3 HQM+IIHL+IHM;HCH;HCHL$XHL$`Ht,HA   HyHyrHHHU   ߸HL$`H HL$`HEHrPHHM H=   r<tŏ HAH;r H+Hs H'v H AEHT$XI*IHT$XIP H}H]H+HWD$xHt3h H_HHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHMH    D$8   D$0   D$(   D$ LL$pLD$xIHMj  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM~n  HL$xJ HL$XHt2HT$`m5  LD$hHT$XL+IGWD$XHD$h    HUHtLEL+Il3HM H3ͪ H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHxh H3HE AALL   L   H   L  H  HEI}[   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$p.HHL$tAWE3H}Ht$8Ll$0D$(t$ LL$pMIHM*Q WD$XH|$hHE   H}@} DGH	 HM gHE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$X$HL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
ٽ	  HQM+IIHL+IHM;HCH;HCHL$XpHL$`Ht,HA   HyHyrHHHU   诳HL$`H HL$`HEHrPHHM H=   r<t HAH;r H+Hsu H'vh H׮ AEHT$XI%IHT$XIP H}H]H+HWD$xHt38 HxZHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMe  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM.\  HL$x HL$XHt2HT$`=0  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I<3HM H3蝥 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH  HǀpHXHp )pHGc H3H$  MMH$   LHL$0H0
 HHH	0
 H;/
 r   VHH/
 H$   Ht
,
 H3H/
 3HHH/
 H;/
 r
   HH$   WHt
(蔾HHW$   H$   L$  L$  H$  H$  H$   HT$ H$  N  HD$ H$   H$   HT$ H$  '  HD$ H$   WD$PHt$`McmxIMtM;v
H
m	  IHL$PsL    H$  M;[  HT$ 赩  HD$ HL$XLD$PH;   HD$ L;   Lt$ M+ILL$`I;uoIH+HHs_I+HIH+Hs
H
ϸ	  HQM+IIHIH+ILI;LCL;ICHL$PrHL$XLD$PH   K~LL$`I;ujIH+HHsZI+HIH+Hs
H
G	 q HQM+IIHIH+ILI;LCL;ICHL$PLrHL$XHt
HD$ HHL$XHHL$XIH$   HT$(R  LH(-
 LH(H-
 H;-
 r
(   gLL$   Mt+M} AOXKII^M~ H1	 ILL$   IH$   (HHL$ HD$ H$   WD$8Ht$HLl$0Mc},MtM;v
H
	 6 IHL$89qLfD  M;  HT$ H$  U  HD$ HL$@H;   HD$ LD$8L;   H\$ I+HLL$HI;uoIH+HHs_I+HIH+Hs
H
o	  HQM+IIHIH+ILI;LCL;ICHL$8tpHL$@LD$8Ht.I H;L$HuHL$8oHL$@Ht
HD$ HHL$@HHL$@I
    HǄ$     H$  Ƅ$   A   H+	 H$  HǄ$     H$  Ƅ$   A   H	 H$  ߥLl$0EExEyH$  H$  +H$  =jH$  /jIcUxH$   PHL$   IH$   H+HHt1fff     H<HL$   IH$   H+HH;rHL+IMt.fff     H<HH$   H$   H+HH;r

    HǄ$     H$  Ƅ$   A   HB	 H$  轤HǄ$     H$  Ƅ$   A   H/	 H$  膤EExAyH$  H$  H$  hH$  hAExHcHL$hgOHLD$pIHL$hH+HHt*ff     H<HLD$pIHL$hH+HH;rHL+IMtH<HHD$pHL$hH+HH;ru
    HǄ$     H$  Ƅ$   A   H,	 H$  胣L$     HL$hk#  HH$   HH$  g   A;]xC  
    HǄ$     H$  Ƅ$   A   H:	 H$  HǄ$     H$  Ƅ$   A   Hs	 H$  ʢHǄ$     H$  Ƅ$   A   H<	 H$  蓢LcL$  IHL$Pz"  LL$  IHL$hb"  MHH$   ϿLHcL$  HL$h5"  HIHH$  fH$  fH$  fH$   H\$ 

 $   A   5!
 f     E;uxc  x

 %   HǄ$     H$  Ƅ$   A   H/	 H$  膡HǄ$     H$  Ƅ$   A   H	 H$  OHǄ$     H$  Ƅ$   A   H5	 H$  HǄ$     H$  Ƅ$   A   H	 H$  EfIcL$  HL$h   LIcL$  HHL$h   MHH$   	L(HL$(LI   L$  Ho   LD$ HL$0MHH$   LL$  HH$   .   HIHH$  dH$  dH$  dH$  ~d
 &   HǄ$     H$  Ƅ$   A   HO	 H$  讟L$  HH$     LHT$ H$    HH\$ H$  cEDH$        E;ux   IcH<    H$p  rH	 H$  [HAH`y ]HH$   H$p  1pHxrH H
 H$   3H$   H$   H$  Ƅ$  H$   H$  y Hs	 H$   H H$   " ADHL$hfff     AExD;   IcH<    H$p  qH	 H$  [HAH[x ]HH$   H$p  ,oHxrH H
 H$  3H$  H$  H$  Ƅ$  H$  H$  x Hr	 H$  H H$   AH   H$p  (pH	 H$  H$   H$p  nnHxrH H
ā H$   3H$(  H$0  H$  Ƅ$  H$(  H$  ,x Hr	 H$   H H$   _ Z
 +   HǄ$     H$  Ƅ$   A   H	 H$  hHǄ$     H$  Ƅ$   A   Hb	 H$  1EE(EyH$  H$  H$  `H$  `IcU(H$  GHL$  IH$  H+HHt(fH<HL$  IH$  H+HH;rHL+IMt.fff     H<HH$  H$  H+HH;r
 .   D$0   t$ LL$0LD$ H$   HL$( HT$(H$   9- 
 /   D$    t$0LL$ LD$0H$   HL$(ǭ HT$(H$   , 
 0   t$ M   LD$ HT$PHL$(蜰 HT$(H$   , L
 1   `
 D$(t$ LL$(LD$ H$   HL$0肴 HT$0H$   p, 
 2   t$ M   LD$ HT$8HL$(g HT$(H$   5, A   E;}(?  
 6   HǄ$     H$  Ƅ$    A   H	 H$   řHǄ$x     H$p  Ƅ$`   A   HÖ	 H$`  莙HǄ$X     H$P  Ƅ$@   A   Hd	 H$@  WHǄ$8     H$0  Ƅ$    A   HU	 H$    HǄ$     H$  Ƅ$   A   H	 H$  H$  H$  E33H$  A   Hݕ	 H$  謘IcI   L$   H豩 LD$8HH$   \ LL$`  HI   肩 L$   HH$   * LH$   H$   貵LIM0L$@  H  MHL$(:LL$   HI    LD$PHHL$ 辪 LH$   HL$0IHH$@  YMHH$H  HH$P  L(H$X  cHIMHL$  Hl  LH$`  xMHH$  ŴHL$  HH$  *  HHHH$  [H$  [H$   [H$@  z[H$`  l[H$   ^[Ax 8   IU`L$   L$  HL$( HT$(H$   ( H$  HtL$  L+IHT$hHtLD$xL+IΊWD$hHt$xH$   Ht(L$   L+I蟊W$   H$   HT$8HtLD$HL+IpWD$8Ht$HHT$PHtLD$`L+IGH$   H$   ' H$   H$   HH$   HtL$   L+IHH$  H3T L$  I[@IsHA(sIA_A^A]A\_HWATAUAVAWH  HǀpHXHp )pHM H3H$  IMH$   LH
 HHH
 H;
 r   HH
 H$   Ht
l
 觨H3H
 3HHHw
 H;h
 r
   ĠHH$   WHt
(YHH$   W$   H$   L$  H$  H$  H$  H$   HT$ H$    HD$ H$   H$   HT$ H$    HD$ H$   WD$PHt$`McexIMtM;v
H
-	 Wm IHL$PZ]L    H$  M;[  HT$ u  HD$ HL$XLD$PH;   HD$ L;   H\$ I+HLL$`I;uoIH+HHs_I+HIH+Hs
H
	 l HQM+IIHIH+ILI;LCL;ICHL$P\HL$XLD$PH   I~LL$`I;ujIH+HHsZI+HIH+Hs
H
	 1l HQM+IIHIH+ILI;LCL;ICHL$P\HL$XHt
HD$ HHL$XHHL$XIH$   HT$(  HHL$0E(HHL$ HD$ H$   WD$8Ht$HMce,MtM;v
H
E	 ok IHL$8r[LM;   HT$ H$  蔑  HD$ HL$@H;sAHT$ HD$8H;w2H\$ H+HH;L$HuHL$8ZHL$@HD$8Ht.H H;L$HuHL$8cZHL$@Ht
HD$ HHL$@HHL$@I\    HǄ$     H$  Ƅ$   A   HН	 H$  軐HǄ$     H$  Ƅ$   A   H%	 H$  脐EExEyH$  H$  ջH$  TH$  TIcUxH$   h;HL$   IH$   H+HHt+D  H<HL$   IH$   H+HH;rHL+IMt.fff     H<HH$   H$   H+HH;r_    HǄ$     H$  Ƅ$   A   H	 H$  mHǄ$     H$  Ƅ$   A   Hߝ	 H$  6EExAyH$  H$  膺H$  SH$  SAExHcHL$h:HLD$pIHL$hH+HHt*ff     H<HLD$pIHL$hH+HH;rHL+IMtH<HHD$pHL$hH+HH;r%    HǄ$     H$  Ƅ$   A   Hܜ	 H$  3L$     HL$h  HH$   HH$  R   A;]x@      HǄ$     H$  Ƅ$   A   H	 H$  豍HǄ$     H$  Ƅ$   A   H#	 H$  zHǄ$     H$  Ƅ$   A   H	 H$  CLcL$  IHL$P*
  LL$  IHL$h
  MHHL$(肪LHcL$  HL$h  HIHH$  bQH$  TQH$  FQH$   H\$ V $   A   5<
 E;uxc  4 %   HǄ$     H$  Ƅ$   A   H	 H$  BHǄ$     H$  Ƅ$   A   H	 H$  HǄ$     H$  Ƅ$   A   H	 H$  ԋHǄ$     H$  Ƅ$   A   H>	 H$  蝋EfIcL$  HL$h  LIcL$  HHL$hh  MHHL$(ȫL(HL$0xLI   L$  H.  LD$ H$   HMHH$   uLL$  HH$   
  HIHH$  dOH$  VOH$  HOH$  :O\ &   HǄ$     H$  Ƅ$   A   H	 H$  jL$  HH$   Q
  LHT$ H$   輧HH\$ H$  NEDH$   @ E;ux   IcH<    H$p  \HC	 H$  f[H|AH d ]HfH$   H$p  ZHxrH H
Gn H$   3H$   H$   H$  Ƅ$  H$   H$  d H^	 H$   HY H$    ADHL$hfff     AExD;   IcH<    H$p  [Hf	 H$  a[HwAHc ]HaH$   H$p  YHxrH H
Bm H$  3H$  H$  H$  Ƅ$  H$  H$  c H]	 H$  HT H$  ݔ AH   H$p  ZH	 H$  H$   H$p  .YHxrH H
l H$   3H$(  H$0  H$  Ƅ$  H$(  H$  b H\	 H$   H H$     +   HǄ$     H$  Ƅ$   A   HU	 H$  (HǄ$     H$  Ƅ$   A   H"	 H$  EE(EyH$  H$  BH$  TKH$  FKIcU(H$  1HL$  IH$  H+HHt(fH<HL$  IH$  H+HH;rHL+IMt.fff     H<HH$  H$  H+HH;r .   D$0   t$ LL$0LD$ H$   HL$(˘ HT$(H$     /   D$    t$0LL$ LD$0H$   HL$(臘 HT$(H$    G 0   t$ M   LD$ HT$PHL$(\ HT$(H$   z  1    
 D$(t$ LL$(LD$ H$   HL$0B HT$0H$   0  2   t$ M   LD$ HT$8HL$(' HT$(H$    A   E;}(?  w 6   HǄ$     H$  Ƅ$    A   H	 H$   腄HǄ$x     H$p  Ƅ$`   A   H	 H$`  NHǄ$X     H$P  Ƅ$@   A   H$	 H$@  HǄ$8     H$0  Ƅ$    A   H	 H$   HǄ$     H$  Ƅ$   A   H	 H$  詃H$  H$  E33H$  |A   H	 H$  lIcI   L$   Hq LD$8HH$    LL$`  HI   B L$   HH$    LH$   H$   rLIM0L$@  H  MHL$(LL$   HI   Г LD$PHHL$ ~ LH$   HL$0	HH$@  MHH$H  ֥HH$P  L(H$X  #HIMHL$  H,  LH$`  8MHH$  腟HL$  HH$    HHHH$  dFH$  VFH$   HFH$@  :FH$`  ,FH$   FA8 8   IU`L$   L$  HL$(ޢ HT$(H$   l H$  HtL$  L+IuHT$hHtLD$xL+IuWD$hHt$xH$   Ht(L$   L+I_uW$   H$   HT$8HtLD$HL+I0uWD$8Ht$HHT$PHtLD$`L+IuH$   H$    H$   H$   HH$   HtL$   L+ItHH$  H3z L$  I[@IsHA(sIA_A^A]A\_@SVWH   HD$0H7 H3HD$xIHHHD$p   HD$h    D$X A   H|	 HL$XHD$P   HD$H    D$8 A   HY	 HL$8wLGL+IH\$(D$    DHL$8葩HD$PHrQHHL$8H=   r<t\ HAH;r\ H+Hs[ H'v[ HT HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<t[ HAH;r[ H+Hs[ H'vr[ H HHHHL$xH3Yx HĀ   _^[Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1H~ H3HsHsHH;uHl$0Ht$8H\$@H _Z Z Y Y Y DL$ LD$HT$HL$SVWH0HD$(HH9z ucH g HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH ' HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCH| H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _	X X W W H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   H{ H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weH{ HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _V V V V V V V V H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHz H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _U U U U HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHN7HHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hcy H3HsHsHH;uHl$0Ht$8H\$@H _T T T T T HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PH@/ H3HEpMMHHH   D$     HP	 HD$`HMPR D$    E3E3HT$hHL$`R HD$`HcHH`=	 HD`HD$`HcHDxDD\   HL$hׄHHL$`iHHGp	 *HHOHHUv	 HI5HAP HHHUPHL$`IHxrH H
Z HL$(3HL$0HL$8HD$@D$HHT$0HL$@qQ HR	 HD$(H HL$(誂 @UVWATAUAVAWH$pH  HD$@H$  H- H3H   MIHLL   H   HD$8E3D|$0HN	 HD$PHMP D$0   E3E3HT$XHL$PP HD$PHcHH;	 HDPHD$PHcHDxDDLAWHL$X>HHL$PвHH	 葮HIVDO HH	 uHU`HL$PgHHIcD$0HU`H}xHCU`HEX   L}PD}@D8:tIIB<: uMHM@tHD$8HD$ MLD$0HU@IH\$Ht$WH IHHH;t HH1HHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(IHf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IIHA(HWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   ;)HX(H
l	 HH0@8   HH$   蔋 HHL$(f)H HL$({f H\$WH HHHÀ< uHú   H5 HHu3 Ht!HH+fff     9HHuHH\$0H _@SH HQ  H+	 HCPH [HL$SH0HD$ HD$P    EtHF	 HA@HC+	 HAPD$P   J   H[ 	 HH'	 HCHC@HcHH)	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH.= HHQ3HHBHK3 H+	 HH{3HHDH^H\$HH3	 HHOHKHtHPHGHCHGHCG C H	 HH= HHH\$PHt$XH0_@SH HN  H*	 HCPH [HL$SH0HD$ HD$P    EtH	 HA@H)	 HAPD$P   z  H#	 HHY	 HC(HC@HcHH	 HD@HC@HcHD<    HH0[@SH HbL  Hc)	 HCPH [HL$SH0HD$ HD$P    EtH&	 HA@H#)	 HAPD$P     HO	 HHy*	 HC(HC@HcHH"	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH H(	 HHHV	 HAPHI8 2 HK 1 HK1 H$	 HH [@SH H	 HHH	 HAPHI81 HK 1 HK1 H$	 HH [H\$WH HN  H'	 HGPt
X   HV HH\$0H _H\$WH HLL  Hm'	 HGPt
X   HwV HH\$0H _H\$WH HHL0	 HHHJHKHtHPHGHS0HCHO0HGHCG C Hf9 HC(3HHB/ H-	 HHJ/	 HC(HH\$0H _H\$WH HI  H&	 HGPt
X   HU HH\$0H _H\$WH HH|/	 HHHJHKHtHPHGHS0HCHO0HGHCG C H8 HC(3HHB+/ H	 HH(	 HC(HH\$0H _@SH HH   / H   HKX|/ HKHr/ HK8h/ HK(^/ HKT/ HKH [H%D/ H\$WH HQ@3HHtLAPL+IGH{@H{HH{PHS(HtLC8L+IcGH{(H{0H{8HSHtLCL+I6H{H{H{H\$0H _H\$WH HH     L   HgfffffffL+   IHLI?LH     H   HOXD. HOH:. HO80. HO(&. HO. HOH\$0H _H%. @UVWAVAWH$@H  HD$8H$  H	 H3H   IILHE3D|$0AA A	fD  f/rHHrY  H-	 HD$PH*	 HD$`HM, D$0   E3HT$hHL$P^, HD$PHcHH&	 HDPHD$PHcHhTLHD$hHD$@HL$h) H!	 HD$hL}D}Hb	 HL$`jHL$`+ H   HL$P
"H   H   HC   HEh   L}`EP : uMI@ IB< uHMPmPHǅ      L   Ep A   Hb	 HMp@PHEPHD$ LMpLIHH   H3J H$  H  A_A^_^]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHEd	 H  YOHL@H
 	 H;u.HSHKHH  HH) H  HAАH  HrSHH  H=   r<t+ HAH;r+ H+Hs+ H'v+ H	P HWHL$x,@  MEHT$xH^  (Hǅ     L  ƅ   A   HUc	 H  INIH  IPH  HrSHH  H=   r<t* HAH;r* H+Hs* H'v* H7O H    Hb	 H   GH(' H  H   ILAHIAАH  HrTHH  H=   r<tD* HAH;r4* H+Hs$* H'v* HN HH  HH  ( H\$0Lt$(x  D$ p  (HT$xHM  H_HD$xH  HuHCH;t'H;tH( Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  聖 HGHPHL$`oEHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
![	 3% W  L  D$@Ll$PH'	 HEH$	 HEHMH& D$\   E3HUHMs& HEHcHH 	 HD
HEHcHhT
HEH  HM# H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HM"HXH  RHt
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
Y	 "$ IPL+IIHL+IIM;HCH;HCHL$@gLD$HMtM(LD$HILD$HIPHL$@H;t
I;t,M IHT$@IPHǅ     L  ƅ   E3HqC	 H  IIH  IP H  1H  uH^	 H  HȋW$# HH^	 IH  IPAD9o$Y  f     LGHWHL$xa EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  D$0D$(HD$@HD$ LD$`HH  H  HXH  %
HtIH  IPLD$HL;D$Pu   HL$@>LD$HMtM(LD$HILD$HIPHL$@H;t
I;tbK IHT$@IPHH  HH  
# ;w$}H
gW	 y! Hǅ     L  ƅ   A
   H:]	 H  GIH  IP H  0HH  HH  " HMHHMHr" HT$@HtLD$PL+I;WD$@Ll$PH  HtL  L+I*HT$`HtLD$pL+I;HM
# HL$x" 3H  H3@ H$`  ($   H  A_A^A]A\_^]HUWATAVAWHhH   HEHXHpH H3HEHHLALIEgAEoAEwA EA$HE   E3LeDeED$+H[	 HM>FHE   LeDe[	 MAH[	 HM
FD9ckHE   LeDeED$HW	 HMEHE   LeDeED$HW	 HMEHEHD$ LMLCHUHMHEHrPHHMH=   r<t_" HAH;rO" H+Hs?" H'v2" HF HE   LeE HEHrPHHMH=   r<t! HAH;r! H+Hs! H'v! H7F HE   LeE A&   HZ	 HMDHE   LeE Z	 MAH	Z	 HMD{ mHE   LeE A   HDV	 HMSDHE   LeE A   HU	 HM,DHEHD$ LMLCHUHM
HMHMHE   LeE A*   HY	 HMCHE   LeE ;Y	 MAH+Y	 HMCLC HUHMHMHMHE   LeE A&   HY	 HMVCHE   LeE X	 MAHX	 HM%CLC$HUHMHMHMHHMH3< L$   I[8Is@IA_A^A\_]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEH%W	 H  9BHL@H
	 H;u.HSHKHH  HH߁a H  HAАH  HrSHH  H=   r<t HAH;r H+Hs H'vz HB HWHL$x@  MEHT$xH~l  (Hǅ     L  ƅ   A   H5V	 H  )AIH  IPH  HrSHH  H=   r<t HAH;r H+Hs H'v HB H   HU	 H   'zH( H  H   ILAHIAАH  HrTHH  H=   r<t$ HAH;r H+Hs H'v HfA HH  yHH   H\$0Lt$(x  D$ p  (HT$xH0[  H_HD$xH  HuHCH;t'H;tH Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  a HGHPHL$`OEHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
N	  W  L  D$@Ll$PH	 HEH	 HEHMH D$\   E3HUHMS HEHcHH	 HD
HEHcHhT
HEH  HM H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMHXH  2Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
L	  IPL+IIHL+IIM;HCH;HCHL$@YLD$HMtM(LD$HILD$HIPHL$@H;t
I;t@ IHT$@IPHǅ     L  ƅ   E3HQ6	 H  <IH  IP H  H  UHQ	 H  uHȋW$ HHsQ	 uIH  IPAD9o$Y  f     LGHWHL$x.U EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  D$0D$(HD$@HD$ LD$`HH  H  HXH   HtIH  IPLD$HL;D$Pu   HL$@1LD$HMtM(LD$HILD$HIPHL$@H;t
I;tB> IHT$@IPHH  wHH   ;w$}H
GJ	 Y Hǅ     L  ƅ   A
   HP	 H  :IH  IP H  HH  HH  f HMHHMHR HT$@HtLD$PL+I.WD$@Ll$PH  HtL  L+IHT$`HtLD$pL+Im.HM HL$x 3H  H33 H$`  ($   H  A_A^A]A\_^]@SH A(HA l CH [Ht$WH0HD$     H      t@W H   HVxH\$@      ^FxH\$@,;L   HHt$HH0_@SH H	 HH   H	 HH HAPHI8 HK  HK H	 HH [Wf/v%      ^Ix,;L   H\$WH HHH   H1H   H"H   HH\$0H _	@UHHPHEH\$`Ht$pH|$xH H3HEHHE   3Hu@uDF
H
N	 HM7HKHEH;sTHHUH;wHH}H+H;KuVH,HH;HKHtcHA   HqHyrHHH;H;Ku
   HD,HKHt'HA   HqHyrHHHU  <HC HEHrPHHMH=   r<t HAH;r H+Hs H'v H8 HE   HuE A
   HL	 HM6HCHMH;sVHHUH;wJH}H+H;Cu
   H[+HH;HKHtcHA   HqHyrHHH;H;Cu
   H+HKHt'HA   HqHyrHHHU  ;HC HMjHE   HuE A   H%L	 HM5HUHwHM-HMH3/ H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3um  HSH2n  H_HGPLG`HHOPP8MHHOPk  HHMHCHEEWH9puA(H HD$8HEHEHL$0> (Y5ó	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0 YQ	 XC(EoHHEoH#H      H;v	 \(-g (5	 f/vIHOh	j  f/v:HEH;t1HKHU{EC(HKHU{HK0HU{]HCHEHx tH HD$8HEHEHL$0 D(DY	 DXC(D   0H
	 I$I\$H]oHO~HHHGHCHWHGLL+t&f W=	 A|$At$ HM HM HM IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA e CH [H\$WH0HD$     H      tS HWxH   HH\$@H0_@SH H
	 HH   H	 HHH HAPHI8
 HK 
 HK
 H 	 HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=	 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@o HL$0Y ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@ p HL$0m L$   HHH$   ($   HĠ   _:f  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Hq HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     HHK8HOHS0LC8IL+LtHa HH\$@H0_H\$WH0IH IHD$     HHK HOHSLC IL+LtH4a HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3	 HHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$P2: HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P` (Y%	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$   Ղ (X\(HĐ   [B(HhHBHD$(Hx uWYQ	 HhH HL$8HD$@HD$ HD$P Y(	 HhWf/v	 f/v   Wf/vIxHAHH H\$WH HHe  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs蜁 Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$Xh f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H HSHt
HHH
HB$H;Cu
   H HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   Hr HSHt
HHH
HJ$H;Cu
   HF HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HwHSHt
HHH
HB&H;Cu
   HKHKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xHQ H3HEHHE   3Hu@uDF
Hz>	 HM)(HCHMH;sTHHUH;wHH}H+H;CuVHHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  T-HC HEHrPHHMH=   r<tC HAH;r3 H+Hs# H'v H( HE   HuE A   H=	 HM&HCHMH;sVHHUH;wJH}H+H;Cu
   HHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  (,HC HMHE   HuE A   H<	 HM$&HUHHMHE   HuE A   H<	 HM%HUHHM`HE   HuE A   H<	 HM%HUHmHM#HMH3w H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    ]  HSH^  H~HFPLF`HHNPP8MHHNP[  HHM}HUH   }HUHM0}HUH   }HFPLHUHNPP(HMHE HMHM(HULL+tHlW HMHEHMHMHULL+t	HBW HN(lHD$xH^(H]HV LL+tHW H]EWA(HGH  Hx uE(H HEH   HEHMK D(D΢	 EYDXO(D$`    DEǆ       Ɔ          D	 D%	 D-	 @      WD$hHt3B HHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM/ D]HNhX  fA/  HEH;  LcuIL;wt%HO[ EtHHGHG    H_E~LEN    HUHO2U EG(Lcu IL;w t%HO EtH8HGHG    H_ E~LE N    HUHOT LcuIL;w8t%HO0 EtHHG0HG0    H_8E~LEN    HUHO0T Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      H9\  HEH;  HWHMhG(EHWHMhHM   H   H;t=HOH   h   G(HOH   hHO0H   hLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      HX[  H   H;t=HWH   	hG(   HWH   gH   HW0g     uf/w(\R (HNhU  f/v=H   HM8g   EXH   HMHxgH   HM`hgf/v\(PX(\(P(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM- HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  t fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  Pt fA/v"HL$h    9   }H]HL$h D$`   fnu^HE0H;t1HOHU8eEXG(HOHUHeHO0HU`weHU     V0Wۧ	 HV(IdHL$xH HM= HM 2 HM' H    H    H    HM` HMH HM8 H    H    H    HM HM HM IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5h	 EW=d	 E   I$HEI|$HFH;t'H;tH Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$`. H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMp    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMp EHSxHExHD$(H  HD$ L   L   HM3 YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(HL5 t0Eu"A   EEH/	 H   A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$`% M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$`$ I迕  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Aa  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`R Y   SxE3;a  H   HCxMHH\  [pSh(\%Y	 T   f/vA      8  f/vA        f/vA
      H  H9   rA(   ~TUpT]xH0  HMp f/HGHExf/HG^(  5	 Yf/vA   !Hn[  @  Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   HIcX$ 4$ HA   H?+	 vAO   HX+	 gAO   H+	 XA6   H+	 IAD   H,	 :AC   HL,	 +A9   H,	 AQ   H,	 
A   H-	 HC   HLKDHH0[ # # # # # # # # $  HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5	 EW=	 E   I$HEI|$HFH;t'H;tH Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
ڜ	 ff     HE(WA)HH;}LEMHL$`T% H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMh    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMg EHSxHExHD$(H   HD$ L   L   HM+ YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H, t0Eu"A   EEH*'	 H   A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHBHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   A|]  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`I Y   SxE3\  H   HCxMHH[  [pSh(\%	 T   f/vA        f/vA         f/vA
      H   H9   rA(   ~TUpT]xH  HMp f/HGHExf/HG^  58	 Yf/vA   !H>Z     Y   f/DGHMC HM8 AL$(  A(sA({E(CIA_A^A]A\_^[]LSH   ICHAC    H ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH> HD$P3HD$XHD$`HKHT$X H	 HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    Hz HL$( @SH0HD$ HٹX   < HD$@HSH^  HHtH@@HcHHB@HH0[@SH0HD$ HH	 HH] HA(HA@HcPH HD
@HA@HcPDBDD
<H HH HA(H0% H HHKHtHP tHC    H0[LSH   ICHAC    H; ICH8 ICAC   H= ICHIIKHtHPHCHD$8HCHD$@CЉD$HH^ HD$P3HD$XHD$`HKHT$X H HD$(Hc HD$PHD$hHcHH HDhHD$hHcHDd    Hv HL$( @SH0HD$ HٹX   \ HD$@HSH]  HHtH@@HcHHB@HH0[@SH0HD$ HH/ HH HA(HA@HcPHb HD
@HA@HcPDBDD
<H HH; HA(H0E H HHKHtHP tHC    H0[LH   ICAC    HQH[ ICHX ICAC   IK[Hl HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H~u HL$(b @SH0HD$ HٹX    HD$@HSH\  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPHZ HD
@HA@HcPDBDD
<H HHS HAHI HtHP tHC     H HHKH0[H% @SHpH H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8uZ @-H$   u	HHHtHL$`H3 Hp[2HL$`H3 Hp[@SVWH   HD$8Hͽ H3H$   IHHA D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   H{	 HL$@qHD$x   HD$p    D$` A   H	 HL$`BHD$@HD$ LL$`LHH贍H$   H3 HĐ   _^[@SVWH   HD$0Hݼ H3HD$xIHHAWf/w|HD$P   HD$H    D$8 A   H	 HL$8HD$p   HD$h    D$X A   H;	 HL$XiHD$8HD$ LL$XLHHیHL$xH3- HĀ   _^[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   诲H/ HHOHi HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_H H\$WH H HH   H HH HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH H HHH HAPHI8* HO   HO H Ht
   HZ HH\$0H _H\$WH H HH   Hd HH HAPHI8 HO  HO H Ht
  H HH\$0H _H\$WH H HHH HAPHI8: HO 0 HO& H Ht
   Hj HH\$0H _LHXICLL	IAI+HHIH;rQHx IC3ICICHc	 ICD$0ISIK H HD$8H	 HL$8GHAI@IHH
HHXHUSVWATAUAVAWHH  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)H׶ H3H@  D((UHHT$xLT$0\$8Hh  Lp  Hǅ     E3L  D   EFH=	 H   qHǅ     L  D  	 MA3H	 H  4EWfA/   Hǅ     L  D  EFH	 H  Hǅ8     L0  D   EFH	 H   H  HD$ L   LD$0H   H  'H  HrSHH  H=   r<tT HAH;rD H+Hs4 H'v' H Hǅ     L  ƅ   H  HrSHH   H=   r<t HAH;r H+Hs H'v H Hǅ     L  ƅ    A%   Hg	 H   Hǅ     L  ƅ   	 MA3H	 H  NfE/   Hǅ     L  ƅ   A   H	 H  Hǅ8     L0  ƅ    A   H
	 H   H  HD$ L   LD$8H   H  AH  4H   'Hǅ     L  ƅ    A   Hi	 H   eHǅ     L  ƅ   	 MA3H	 H  (L`  H   H  
H  萿H   胿I$HPHMI$HPHME(D-2}	 z	 T$0fn`  =xy	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`Hx  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   H3	 H  HH  HP H  艾Hǅ     L  ƅ   A=   H	 H  HH  HP H  9+ D$pAA   D=	 D5x	 @ LLEHIV  HMAu3H  HHMH  E H     HUXL(H  HHUHMFL
x	 HM0LHH  HHMH   H   H   H   fEnEA(+ ^HU0HMyL
x	 H  HHUHML(HMLHH  HHeH   H   H   H   AƙA|$   A(LHIX  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyXRx	 ^HT$@P  D(H   t   HMX< HH H   /HHu3
H HcHHHW	   HMh HAH HH /HHKU HHu3
H HcHHHW   HMx LHu3
HHcHHIPA   H   s HA(H HH ,/HHu3
H HcHHHW   H   6 HHtH HHu3
H HcHHHW   H    H(Hf HH .HHu3
H HcHHHW   H    HHH HHu3
H HcHHHWA(H ' +D$pfn^=u	 |$83H  H  H  WH  H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  H  H  HtHHH1H;  u   H  UH  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  H  H  Ht;HH+H;  u   H  H  HtD	H  HH  IE L@H
c H  H;Iu3AfD/vHD
	 H   P,E2fE/vH?
	 H   3,E2AD$ D;~!fE/wfA/vH,
	 H    ,HH   HPE   A(A\A^ATf/p	    Hǅ     H  D  Aa   H	 H  HH  HP H  wHǅ     H  D  AH   H
	 H  HH  HP H  'H  Ht%L  L+IW  H  HH  HH  L =p	 H|$xD;`     Hǅ     3H    DCiH	 H  HH  HP H  sHǅ     H    DCBH	 H  HH  HP H  &E2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHtHM5 HM+ HM  HM H@  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWHP  IǃA)sA){Hg H3H$(  MALHHL$`H$   HT$xDD$PL$   Iǃ    E3MEEGH	 IHǄ$     L$  D$  :	 MA"H*	 H$     HǄ$     L$  D$  EGH} 	 H$  HǄ$      L$  D$  EGH( 	 H$  SH$  HD$ L$  LD$PH$p  H$  #H$  HrTHH$  H=   r<t HAH;r H+Hs H'v H  HǄ$     L$  Ƅ$   H$  HrTHH$p  H=   r<t` HAH;rP H+Hs@ H'v3 H HǄ$     L$  Ƅ$p   A   H		 H$p  IH$p  IP H$  HrTHH$p  H=   r<t HAH;r H+Hs H'v H (@s	 $  (
q	 $  k	 $  
n	 $   MIHM  $   HHPH$   HHPH$   k	 $   
k	 $   j	 $   WL$hD$@ED|$X|$@   Ic  $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3H H$  [HǄ$     L$  Ƅ$p   E3H H$p  'DLt$8H$  HD$0H$p  HD$(D΋H$p  {H$  mML$   IHL$`tG  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  HH$   H$  _ H$     H$  mL$   H$p  HH$   H$  LL$   H$@  LHH$  HH$   H$   H$   H$   H$p   fn (^H$@  H$   lL$   H$p  HH$   H$  {L(H$  LHH$  HIIH$   H$   H$   H$p   &MIH\$`HI  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$p  7H	 H$  !HH	 !HL$hl HHB !H$  AHz	 |H	 !IH$p  IPHǄ$     L$  Ƅ$p   E3Hc H$p  IH$p  IP H$p   D$@ H$  H$  p   A}$      f/$   6  H$p  H	 H$   HHd	  HL$hP HH	  IH$p  IPHǄ$     L$  Ƅ$p   E3Hh H$p  IH$p  IP H$p  %D$@ H$  H$  u H$   $   D$hADd$XHSH$  HIH$  - H$   EHǄ$     L$  Ƅ$   AJ   H	 H$  HǄ$     L$  Ƅ$p   A   HJ	 H$p  HǄ$     L$  Ƅ$   	 MA"H	 H$  dHǄ$      L$  Ƅ$   E3H H$  0H$  HD$ L$  H$p  H$  uw  H$    H$    H$    H$    D$hH$(  H3 ($@  ($0  HP  A_A^A]A\_^[HUSVWATAUAVAWHH(  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)H H3Hp  D((UHHT$xLT$0\$8H  L  HǅH     E3L@  D0  EFH} H0  Hǅ     L  D   MA3H H  tEWfA/   Hǅ     L  D   EFH( H   4Hǅh     L`  DP  EFH HP  H   HD$ LP  LD$0H0  H  gkH  HrSHH  H=   r<t HAH;r H+Hst H'vg H Hǅ     L  ƅ   HH  HrSHH0  H=   r<t HAH;r H+Hs H'v H] HǅH     L@  ƅ0   A%   H H0  Hǅ     L  ƅ   2 MA3H" H  fE/   Hǅ     L  ƅ    A   HD H   PHǅh     L`  ƅP   A   H HP  H   HD$ LP  LD$8H0  H  iH  tH0  gHǅH     L@  ƅ0   A   H H0  Hǅ     L  ƅ    MA3H H  hL  H0  H  MH  ФH0  äI$HPHMқI$HPHME(D-rb	 _	 T$0fn  =^	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`H]  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   Hs H  WHH  HP H  ɣHǅ     L  ƅ   A=   HK H  HH  HP H  yk D$pAA   D==i	 D5]	 @ LLEHI~E  HMAu3H   8HHM+H   H      HUL(H  趺HHUHM &L
]	 HMP蒺LHH   蠸HHMH  
 H     H   H   fEnEA(( ^HUPHMyL
^]	 H  袹HHUHM rL(HMLHH   HHH  _ H   R H  D H  7 AƙA|$   A(LHIG  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyX]	 ^HT$@6  D(H   贮   H   y HH+ H   ;HHu3
H HcHHHW	   H   5 HAHε HH HH HHu3
H HcHHHW   H    LHu3
HHcHHIPA   H    HA(H* HHL cHHu3
H HcHHHW   H   m HHHҳ HHu3
H HcHHHW   HP   H(H HH HHu3
H HcHHHW   H0   HHHE HHu3
H HcHHHWA(H$ ^ +D$pfn^=[	 |$83H  H  H  WH  &H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  H  H  HtHHH1H;  u   H  H  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  "H  H  Ht;HH+H;  u   H  H  HtD	H  HH  IE L@H
 H  H;IuAfD/vH{ H   E2fE/vHv H   jE2AD$ D;~!fE/wfA/vHc H   7HH   HPE   A(A\A^ATf/4V	    Hǅ     H  D   Aa   H( H   <HH   HP H   讛Hǅ     H  D   AH   HH H   HH   HP H   ^H  Ht%L  L+I.W  H  Hh  Hh   =SU	 H|$xD;     Hǅ     3H     DCiH H   8HH   HP H   誚Hǅ     H     DCBH H   HH   HP H   ]E2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHtHMl HMb HMW HMM Hp  H3& L$(  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWH  IǃXA)sA){H H3H$`  MALHHL$`H$   HT$xDD$PL$   Iǃ   E3MEEGH IFHǄ$     L$  D$  z MA"Hj H$     HǄ$     L$   D$  EGH H$  HǄ$8     L$0  D$   EGHh H$   H$  HD$ L$   LD$PH$  H$  cH$  HrTHH$  H=   r<t HAH;r H+Hs H'v H` HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t HAH;r H+Hs H'vs H HǄ$     L$  Ƅ$   A   H H$  LIH$  IP H$  HrTHH$  H=   r<t HAH;r H+Hsծ H'vȮ H7 (X	 $   (
QV	 $0  AP	 $@  
T	 $   MIHy<  $   HHPH$   HHPH$   P	 $   
P	 $   P	 $   WL$hD$@ED|$X|$@   Ic   $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3HN H$  HǄ$     L$  Ƅ$   E3H H$  gDLt$8H$  HD$0H$  HD$(D΋YH$  軔H$  譔ML$   IHL$`6  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  WHH$   FH$    H$     H$  L$   H$  īHH$   H$(  ,L$   H$X  蓫LHH$  蠩HH$   ߖH$    H$   H$   H$  ݪ fn& (^H$X  H$   lL$   H$  蓪HH$   H$(  [L(H$  ȪLHH$  HIH$   B H$  4 H$  % H$   &MIH\$`H8  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$  wH H$  HH HL$h HH H$  AH |HI IH$  IPHǄ$     L$  Ƅ$   E3H H$  IH$  IP H$  `D$@ H$(  >H$(     A}$      f/$   6  H$  [H H$  HH HL$h HH IH$  IPHǄ$     L$  Ƅ$   E3H H$  IH$  IP H$  eD$@ H$(  CH$(   H$   x$   D$hADd$XHSH$  HIDH$   m H$  _ EHǄ$     L$   Ƅ$   AJ   H H$  HǄ$     L$  Ƅ$   A   H H$  HǄ$     L$  Ƅ$    MA"H	 H$  HǄ$8     L$0  Ƅ$    E3H# H$   pH$   HD$ L$  H$  H$  \  H$   > H$   0 H$   ! H$    D$hH$`  H3 ($  ($p  HĐ  A_A^A]A\_^[H\$
sI	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI;  C(W/S	 C(H$   H$   H0HHD$XHHCH;t/H;t"Hy Ht
HuH3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
{R	 fff     HD$X(WA)HH;}LD$@MHL$h HĐ   _^[@SH`HBHHD$(Hx uWYF	 XB(H`[H HL$8HD$@HD$ HD$P Y}F	 XC(H`[@SH    Wf.HAxHH   zt9HhPYG	 \F	 Y   XF	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
HsHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pH} H3H$P  HHHL$0袘sxH HL$@;H( H$0  HL$0ݖLHHAPH$H  HrUHH$0  H=   r<t: HAH;r* H+Hs H'v
 H| H$   莖H$     H$P  H3 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHM裈 (Y
(C	 XK(MHEHH#H      H;v
E	 (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   f/vH0   XC	 ( H0  X  H;t/HSHN)HC(HF(HSHNHS0HN0LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$hb HMHLHT$hP(HH   HHHHPHKHHHSHL$hJ HHEHsH   HCH;t'H;tH! Ht
H\oHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h H       D  HY(WEHt3d HnHEH] =C	 } H  H[WEHt3' HgnHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM0	}H  L@LEWEMt3Ǜ HMmHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHM' H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\((Xu \(XuuHUH(  HEf/w"\ (H   Hhnf/vHE0H;tHU0HSWEH]HHt3 HOkLHEH]LEHuHEHEHEHEH;t-Iԙ HtHkLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM+' LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM/\ LML   H   H   HM| HMq HM`f HMH\ HM8R HMG HM< L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   H2  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0/  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0T LLHHg0  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK    辷 HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_@SHpahHAHT%
D	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h f/0  s0  ^WC	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HM_xHHEH[IG3H;t'H;tIҔ Ht
H
fII?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
B	 f     HE(WA)HH;}LEMHMe HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM
 (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM` Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHM@T H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHM' Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM H(H;~uH>H;~IDHHMtLE'M+II茩L$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHM
 D(=4	 EtCH]H{ uA(HHEHEHEHMx (A^H*  HG     (A^}gH]H{ uA(HHEHEHEHMmx D^DG0DMWEWMHUH   HM HM HEgHEH]HuHOH;uHOMgIHHUM (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   @SHpahHAHT%z<	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h f/  s  ^W,<	 Hp[HWH   H@HXHpHHHHL@@@HPHH~ HsHG3H;t'H;tHL Ht
H^HHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
[;	 fff     HD$`(W)HH;}HL$(HL$8 HL$p L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$H: D(5/	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;tHHHt3j H\HD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0
 E   LuI~ tIHD$PHD$xHD$`HL$H<s (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"H/ Ht
Hj[HH    H_H_LEHT$xH%R   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;t!HHHt3 HZHD$HH\$PH\$XLEHT$xHL$HU H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;tIIHGHH;t"H Ht
H0ZHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$Hd ID$HEDMLeLeLEHT$xH HL$00 (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    Hn HA@H} HAPD$P   rWH HHP HG(HG@HcHHw HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    HNn HA@HK} HAPD$P   UHRw HHq HG(HG@HcHHq HD9@HG@HcHQT9<HHnHH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHm HA@H| HAPD$P   QHq HHOHx HHG@HcPHWz HD:@HG@HcPDBDD:<HSHHD豠HH\$HHt$XH0_HL$HH'	 LL$P)t$0LD$X3)|$ $54	 =D+	 Tf/vu  "   o(	 LL$PLD$X3Tf/vG  "   !)	 LL$PLD$X3踁Tf/v  "   +)	 LL$PLD$X3芁Tf/v  "   M)	 LL$PLD$X3\Tf/v  "   7)	 LL$PLD$X3.Tf/v  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
 Ł 3Ld$xM+L$3IIHH+II;HCI;LCI`H$   HH+LL$   HH/HIL$   L+ LGH3H$   IL+΂ HHGH+HHHtLGL+IЛKLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$pN HOLD$pHH+$   HH+H#/H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0 H$   ILkHGL+LI+H H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(RHt$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
 } H
 } LD$0H|$(IH+HHHDL$pHH: 3HthH+HI;v H    H=   r=@t HGH;r H+Hsz H'vm HH٤ (L\$PI[(Ik0Is8(t$@IA_A^_@USVWAVAWHl$H   HEH$[ H3HEMIHHHE   E3L}D}EGH3 HMHE   L}D}EGH. HM͢HE   L}D} MA'H HM蜢G DF D;tD$ LMHUHM:HEHrPHHMH=   r<t= HAH;r- H+Hs H'v H HE   L}E HEHrPHHMH=   r<t~ HAH;r~ H+Hs~ H'v~ H HE   L}E HEHrPHHMH=   r<ti~ HAH;rY~ H+HsI~ H'v<~ H諢 HE   L}E A   H HM%HE   L}E A   H? HMHE   L}E  MA'H HM͠HCHHDG D;tHL$ LMHUHMHEHrPHHMH=   r<th} HAH;rX} H+HsH} H'v;} H誡 HE   L}E HEHrPHHMH=   r<t| HAH;r| H+Hs| H'v| H@ HE   L}E HEHrPHHMH=   r<t| HAH;r| H+Hst| H'vg| H֠ Lt$0HCHD$(CD$ LKLHH  HMH33 Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HHV H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ Ht3z HKHD$@H\$HDt$8Aމ\$4D&	 fD  A;]  M}AA|$  ~1I@ H\$@MA(( HA;t$ |ڋ|$0LD$@H$   I聛HHL$@HHT$@HPHL$HHHHT$HH$   y Hz H$   H*w H$   H$8  x |$0E3H$   H$   x H$   HcHHs H   H$   HcHh   H$   HD$hH$   v L=+n L$   L$   D$(  HT$@IM   (D$hH$  H$   GnHXH$  HrTHH$  H=   r<ty HAH;ry H+Hsy H'vy H HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   H H$  @HǄ$     L$  Ƅ$    MA"H H$  t$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   H H$   觛HǄ$     L$  Ƅ$   A   HE H$  pH$   HD$ L$  LD$hH$  H$  #H$  HrTHH$  H=   r<tw HAH;rw H+Hsw H'vw H= HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t}w HAH;rmw H+Hs]w H'vPw H进 DXDL$P\$4É\$4H$   HcHHo H   H$   HcHh   L$   H$    H$   t H$   $t H$8  t `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I舖(AXHL$@}u (H$(  H3R L$p  A(sA({E(CE(KIA_A^A]A\_^[@USVWAVAWHl$H   HEHQ H3HEMIHHHE   E3L}D}EGH HMҘHE   L}D}EGH HM識HE   L}D} MA'H HM|G(DF(D;tD$ LMHUHMHEHrPHHMH=   r<tu HAH;r
u H+Hst H'vt H_ HE   L}E HEHrPHHMH=   r<tt HAH;rt H+Hst H'vt H HE   L}E HEHrPHHMH=   r<tIt HAH;r9t H+Hs)t H'vt H苘 HE   L}E A   H~ HMHE   L}E A   H HMޖHE   L}E ִ MA'Hƴ HM譖HCHHDG(D;tHL$ LMHUHMHEHrPHHMH=   r<tHs HAH;r8s H+Hs(s H'vs H芗 HE   L}E HEHrPHHMH=   r<tr HAH;rr H+Hsr H'vr H  HE   L}E HEHrPHHMH=   r<ttr HAH;rdr H+HsTr H'vGr H趖 Lt$0HCHD$(CD$ LKLHH  HMH3 Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HHL H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ(Ht3p HAHD$@H\$HDt$8Aމ\$4D	 fD  A;]  M}AA|$( ~1I@ H\$@MA(( HA;t$(|ڋ|$0LD$@H$   IiHHL$@HHT$@HPHL$HHHHT$HH$   o Ho H$   H
m H$   H$8  n |$0E3H$   H$   n H$   HcHHh H   H$   HcHh   H$   HD$hH$   k L=d L$   L$   D$(  HT$@IM e  (D$hH$  H$   'dHXH$  HrTHH$  H=   r<to HAH;ro H+Hsoo H'vbo Hѓ HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   H H$   HǄ$     L$  Ƅ$    MA"H| H$  ߑt$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   H H$   臑HǄ$     L$  Ƅ$   A   H% H$  PH$   HD$ L$  LD$hH$  H$  H$  HrTHH$  H=   r<tm HAH;rm H+Hsm H'vm H HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t]m HAH;rMm H+Hs=m H'v0m H蟑 DXDL$P\$4É\$4H$   HcHHe H   H$   HcHh   L$   H$   H$   j H$   j H$8  j `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I(d(AXHL$@]k (H$(  H32 L$p  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pHF H3HEIHHE   3Hu@uDFnH7 HM辎HHUHP@HEHrPHHMH=   r<tsk HAH;rck H+HsSk H'vFk H赏 HHPHE   HuE 8 uLIIB<  uHHMHHUHP@HEHrPHHMH=   r<tj HAH;rj H+Hsj H'vj H HE   HuE A   Hr HM艍HHUHP@HEHrPHHMH=   r<t>j HAH;r.j H+Hsj H'vj H耎 HE   HuE Ah   Hs HMHHUHP@HEHrPHHMH=   r<ti HAH;ri H+Hsi H'vi H HE   HuE E3H HMnHHUHP@HEHrPHHMH=   r<t#i HAH;ri H+Hsi H'vh He HMH3 H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ I  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HOe HOe HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;vZf KHH=   r<t>f HBH;r.f H+Hsf H'vf HHH(y H(LHXICHfffffffH;vJHm IC3ICICH ICD$0ISIKd H@S HD$8HL$8  Hu3KH;vb HHH   r&HA'H;wa H貅 HH'HHA蟅 HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"Hd Ht
HC5HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHM HLFhLNH     HFH^HHEH~HCH;t+H;t"H>c Ht
Hy4HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
R	 fHE(WA)HH;}LEMHMՙ H   Hǆ       H2 E3L\$pI[Is I{(I]oH k EHEHU3HMHEHEH7 HEa H[ HO
 HEHMؒ LALIIHQ I+HH;|
IH+HH+IHHAHtL+I\zH\$WH HJ HHAPHI8a HO a HOa HT Ht
   H HH\$0H _@SH HHIUa HKH [H%Ea @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(DE3EL9{~HN(HJJIL;S|HFXLFLN@HV(Hc
5{	 WAE H^HH+^@HI;^tI_ Ht
H1IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtHQ ļHH
]    cAE $   H$   H#H;t3@HN Ht+Hb uHH3 fHH.]       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [LHXICHH;vJHsf IC3ICICH ICD$0ISIK\ HL HD$8HL$8  Hu3	HXHXHhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$PE WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;t9IHHt3\ H-HLsHkHnH{ H|$hH|$hL?LHt3c\ H3 HHoHnH{0H|$hL?LHt33\ Hs-HHoC@   CD HH< HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	衲 uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
 X HH|$0胙HT$8HHFHHH\$@HNH+H>LHZ H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PHp6 H3HEpMMHHH   D$     HW HD$`HMY D$    E3E3HT$hHL$`IY HD$`HcHHD HD`HD$`HcHDxDD\   HL$hHHL$`虻HHww ZHHHH} @HIeHIW HHNHUPHL$`QHxrH H
&b HL$(3HL$0HL$8HD$@D$HHT$0HL$@X HP HD$(H
 HL$(܉ @SH`W)t$Pf/D)D$0D(   u+DWo	 3A(W]	 (t$PD(D$0H`[ fA/DW7	 A(v(
 \((t$PD(D$0H`[3bX* (t$PD(D$0H`[5 fA/)|$@D)L$ D
 !   fA/vTfD.z  D eH%X      HЋ9)    % AYDY AX   eH%X      HЋ9 
  A(AY(Y((Y% (Y
 Y X% X
 X YYY X%_ X
o YXk XYX^X% AY  3t
  fA/   eH%X   = fA/   HЋ   98   A(A(\AYW"	 (YЭ ((Y (Y (Y
 Xr Xb A^X
 YYYX9 X
 YYX(Y X
R X XZ YX> YX^X Y   fA/   9` '  A(A(\AYW*	 (Yج ((Y( (Y (Y
R X X A^X
% YYYX X
 YYX(Y X X YXX
 ^X& Y  U fA/   9   A(A(\5 AY(W7	 Y ((Y@ (Y- (Y
 X X A^X
u YYYX X
I YYX(YJ X X* YXX
 ^XN Y   9 Z  A(A(A^AY(YWY	  ((Y (Y (Y
 Xx Xh A^X
{ YYYX7 X7 X
G YYYX X
 X(Y4 X YX  YX^Xd Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
 r = D H
  <r H
 r = (	 H
 (
]	 ~ f  (   
a (
2 z 
S q qH
 	r = V( H
z (
K  (  ( 
 (
   
 (
T  
 ,q H
, {q =  ( H
 (
M  (_ 
 (
a  ( 
 (
  
 p [H
 p = .( H
 (
/ ` ( 
b (
 d (% 
 (
  
 0p H
x p =l (O H
X (
 	  (# 	 ,  , (% 
 (
   
 (
 
 
 o H\$D$WH`)t$PI)|$@H(D)D$0 f/   ( f.zuP g  !   t  ($: (Wf/ WvW 賦 D(E3(LHXD\(葦 D\  9 f/vfWf.zo (
 Tf/vI D(DWw     ^\6 T D(    f/v$((\ \
Y (9 D(of/= r! f/v(k? 輥 D(DHL$p觥 D((X \j 若 \ \=U YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
 )t$P)|$@   HD)D$0D)L$ D(ȋ
9    DX
 5Z D(A(AYD^A(A(AY̤  EX
 YYA^X X
 D(L$ X(t$PYYX} X
m YY(|$@XP AYXX7 AYD(D$0\HhH
 l = ( H
 (
 ) ( )
 (
9 ) )
 "l H8eH%X   
 A   )t$ (HB9%    (\5  \-( (\- Y\- ((Y%K (Y@ (Y
- X% X Y X
 YX YX% YX YX
 YYY(t$ XX X% X^YY-$ X(H8H
5 Xk =)  H
 (
  ( C (  (n 
 (
 !  
 (
  
 kj HH   )xD)@D(DT! D)HD(DT
 D)PE(D)XD9 fE/D)`D(EYrA(A(A(C (    fA/A()$   rA (A(A =  `A (A(TA (XY=% YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW=, (($   HĨ   @USVWAVHl$H  HD$PHe% H3HEpMHHH   D$     HF HD$`HMxH D$    E3E3HT$hHL$`AH HD$`HcHH3 HD`HD$`HcHDxDD\   HL$hzHHL$`葪HHof RHHwHH}l 8HI]HH9f HHCHUPHL$`@HxrH H
Q HL$(3HL$0HL$8HD$@D$HHT$0HL$@G HH HD$(H
 HL$(x H@Hx)p()xD)@D D)HD

 fD/D)PEWA(rPA(\(p (\f/
 vAXfA.z   = Y( ^fA.z   f/5L r
(ZX
P f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   HČ H
 D$   n L$   H H
 R @USVWAVHl$H  HD$PHe" H3HEpMHHH   D$     HC HD$`HMxE D$    E3E3HT$hHL$`AE HD$`HcHH0 HD`HD$`HcHDxDD\   HL$hwHHL$`葧HHoc RHHwHH}i 8HI]HHz HHCHUPHL$`=HxrH H
N HL$(3HL$0HL$8HD$@D$HHT$0HL$@D HE HD$(H
 HL$(u HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p5$ )xWD)@D? D)HD
Y H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4CF H;}&HEHM(HE)HH;|LHMH HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ s E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   ? HHL$(? H
 HL$(q @SH0HD$     JHH0[@SH0HD$       HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH  3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+IGe  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHM!LeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHMLeHEH}IHtHHHEIM;w!H
r =< H
r /< H]3MtyIrTIƃIH+foY f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHM賋HUHVH?HMHthHEH+HH;vt> H    H=   r<tX> HAH;rH> H+Hs8> H'v+> Hb A   L}XI;      HVHHMOE3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HHBHNHMKHHHMHt	H]L}X1L;Fu
   H
BHNHMXHMHt
HUpH]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH0a IL}XL;}s(< < < < < HtsL+IHL;vb< J    H=   r=@tE< HGH;r5< H+Hs%< H'v< HH` IM H   IEH+HH?H;v; H    H=   r<t; HAH;r; H+Hs; H'v; H` 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){H7 H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0 f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   _7 V  H$  H$   AeHL;   IM Ht~IEH+HHH;v49 H    H=   r<t9 HAH;r9 H+Hs8 H'v8 HZ] Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;v8 H    H=   r<tc8 HAH;rS8 H+HsC8 H'v68 H\   H9 H$  L$  H$   H$  H:7 H$   Hc4 H$0  H$  -6 AD|$4E3H$8  H$   5 H$   HcHHN0 H   H$   HcHh  H$8  HD$XH$8  :3 Hb+ H$8  H$  $  ML$   H$  HL$PH$  H$   x+HXH$  HrTHH$  H=   r<t6 HAH;r6 H+Hs6 H'v6 H"[ HtHH$   HPH$   HcHH0/ H   H$   HcHh  H`* H$8  H$8  [dH$8  E4 H$@  3 H$  14 HQ5 H$   Hz2 H$0  H$  D4 AD|$4E3H$8  H$   4 H$   HcHHe. H   H$   HcHh  H$8  HD$XH$8  Q1 Hy) H$8  H$  $  L$   IHL$P-: (H$  H$   )HXH$  HrTHH$  H=   r<t4 HAH;r4 H+Hs4 H'v4 H?Y HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   H H$  {WHH$  HP H$  HǄ$     H$  Ƅ$   A>   H H$  %WHH$  HP H$  HǄ$     H$  Ƅ$   A4   H| H$  VHH$  HP H$  ?H$  !(H$  1 H$   \  H$  S)W$  H$  A3 L$  L$   IHL$PF3 +fn^5m H$  H$  X'HXH$  HtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   H= H$  XUHH$  HP H$  HǄ$     H$  Ƅ$   A8   H H$  UHH$  HP H$  rHǄ$     H$  Ƅ$   A4   H H$  THH$  HP H$  E2HI;EulMtL$  M+IIHH$(  %H$(  @/ H$  %H$  $/ H$   vZLd$`4  $   J  HǄ$     H$  Ƅ$   E3H9 H$  SHH$  HP H$  ;H$  ~&H H$  H(- HH HH$  HPH$  0&Y5 H H$  ÌHH 贌HHƝ 襌H(Q- HH 芌HH$  HPHǄ$     H$  Ƅ$   A%   H H$  RHH$  HP H$  #HǄ$     H$  Ƅ$   E3H8 H$  `RHH$  HP H$  HǄ$     H$  Ƅ$   E3HI8 H$  
RHH$  HP H$  }H$(  _#H$(  , H$(  C#H$(  , MtL$  M+IIFH$(  
#H$(  |, H$  "H$  `, H$   WD$HL$@T$2   H$  "H$  %, H$   wW3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3H6 H$  cPHH$  HP H$  H$  #Hv H$  豉H(]* HH 薉H(B* HH( {HH lHȋT$@/* HH PHH$  HPHǄ$     H$  Ƅ$   Ae   H H$  yOHH$  HP H$  H$(   H$(  =* H3 H$   3H$   H$   H H$   Ƅ$   H$   H$   O* H+ H$   Hq
 H$   [ HL$pHIPH\$xHt(H$   HL$   L+IH@H$   HtL$   L+I92IH$  H3FH ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH H3H   (MLHT$`HL  L  H  3ۉ\$DH    WD$HH\$XLL$HMIH(H  H   HXH  HrSHH  H=   r<t8* HAH;r(* H+Hs* H'v* HzN H   IH   IPH  H   >HLAH H;t
HHAАH  HrSHH  H=   r<t) HAH;r~) H+Hsn) H'va) HM W  Hǅ      t$(H  HD$ MMIHWA H  H   tHXH  HrSHH  H=   r<t( HAH;r( H+Hs( H'v( H M H   IH   IPH  H   HLAH H;t
HHAАH  Hr\HH  H=   r<t4( HAH;r$( H+Hs( H'v( HvL H E3EDd$@H  H H  rH(% HH;tHPH  H  HLAH;t
HHAАH  HrSHH  H=   r<t\' HAH;rL' H+Hs<' H'v/' HK HH;tHPHǅ     L  ƅ   E3HH0 H  JIH  IP H  HrSHH  H=   r<t& HAH;r& H+Hs& H'v& HJ IH  IPHǅ     L  ƅ   E3H/ H  PIIH  IP H  HrSHH  H=   r<t% HAH;r% H+Hs% H'v% H>J H  
   HL$hy" H  HcQH  HHP   H   L" HH H  HHuI
H HcHHHW   HM
" HHl HЁHHuI
H HcHHHW   HM! HHV H蒁HHuI
H HcHHHW   HM! HH HTHHuI
H HcHHHWH H(H  H  HLAH~ H;t
HHAАH  HrSHH  H=   r<t%$ HAH;r$ H+Hs$ H'v# HgH IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
  = H8
 HEHp
 HEHMH! L$DE3HUHM! HEHcHH HD
HEHcHhT
HEH   HM H" HE3HE0E8IHHH   
   HM HMHcQHMHHP   HM LIHM"  HHu3
H HcHHIWA   HM^ LH   H HHu3
H HcHHIWA   H    LB+H HHu3
H HcHHIWA   H   LHW HHu3
H HcHHIWAB+\H' H   HMHLAH H;t
HHAАH   5	IHUIPB+\Tf/vD$@HMHHMHn IHL|$`IGI+HL;H|$hH
8Dl$@H  H\$HHX  HX   HX  HX   HtL  L+IHb8HtLD$XL+IHH8HX  ;HX   AH   H3= L$P  I[XA(sA({IA_A^A]A\_^]LWATAUAVAWHP  IǃPI[IsA)sA){E)CE)KE)SE)xE)hE)XH

 H3H$  HL= EWW$   Iǃ8    IMIǃ    Iǃ    H
HBH+HHueHX' Ip3IxIH:U HD$(D$0IxHL$( H H$  HT H$  HǄ$     D	D$   HBH+HHwiH& H$  3H$  H$  HT HD$(D$0H$  HL$(1 H H$  H;T H$  ~   H$  DAD$   D$8E3LL$HMcoxIMt$M;v
H
P  IHL$80^LL$HE3HT$@LD$8M;  HFH+HH;riH% H$  3H$  H$  HS HD$(D$0H$  HL$(@ H) H$  HJS H$  HHH$  H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
O  HM+IIHIH+IE3I;LCL;ICHL$8\LL$HHT$@LD$8H   IH   I;usIH+HHscI+HIH+Hs
H
LO v HM+IIHIH+IE3I;LCL;ICHL$8b\LL$HHT$@LD$8Ht2HHT$@IH$  r AXD$(WD$PE3Ll$`Mcg,MtM;v
H
N  IHL$P[MH\$XHt$PfD  M;   H$  J(D$ HD$ H;sDHD$ H;w:H|$ H+HH;\$`u   HL$P+5H\$XHt$PHt2HH)H;\$`u   HL$P4H\$XHt$PHt3HH\$XIY    HǄ$      L$  Ƅ$   A   HK H$  	>HǄ$      L$  Ƅ$   A   HsL H$  =EGxEyH$  H$  #iH$  5H$  'IcWxH$   IL$   IH$   H+HHt+LA<HL$   IH$   H+HH;rIL+IMt*f     <HH$   H+$   HH;r    HǄ$      L$  Ƅ$   A   HDN H$  <HǄ$      L$  Ƅ$   A   H1K H$  <EGxAyH$  H$  gH$   H$   AGxHcHL$pILD$xIHT$pH+HHt.Lf     A<HLD$xIHT$pH+HH;rIL+IMt<HHD$xH+D$pHH;rv    HǄ$      L$  Ƅ$   A   H-J H$  ;L$     HL$plDH$     D  A;_x0      HǄ$@     L$8  Ƅ$(   A   HI H$(  ;HǄ$      L$  Ƅ$   A   HH H$  :HcL$(  HHL$p趺HL$  HHL$8螺0X6HǄ$      L$  Ƅ$   A   H	I H$  `:HcL$  HL$pH0H$  H$  H$(     D%      A;x   %   HǄ$`     L$X  Ƅ$H   A   HF H$H  9HǄ$      L$  Ƅ$   A   H(H H$  9HǄ$      L$  Ƅ$   A   HG H$  H9HcI   L$H  H-LL$  HHL$pHHcL$  HL$p^ A(\AA\YHǄ$@     L$8  Ƅ$(   A   HHG H$(  8L$(  HH$   莸0H$(  
H$  H$  H$H   &   HǄ$`     L$X  Ƅ$H   A   HF H$H  8L$H  HH$   DX H$H  xAAOx;}A;}y +   HǄ$@     L$8  Ƅ$(   A   H4 H$(  7HǄ$`     L$X  Ƅ$H   A   H4 H$H  P7EG(EyH$(  H$H  bH$H  H$(  IcW(H$  tIL$  IH$  H+HHt+LA<HL$  IH$  H+HH;rIL+IMt(    <HH$  H+$  HH;r1 .   D$h   Dl$ LD$hHT$ H$   1 D$ HT$ H$   ) /   D$    Dl$hLD$ HT$hH$    D$ HT$ H$    0   Dl$ M   HT$ HL$8讶 D$ HT$ H$   h 1   | D$hDl$ LD$hHT$ HL$( D$ HT$ H$   ] 2   Dl$ M   HT$ HL$Pȼ D$ HT$ H$       D$   D$   D A;w(   6   HǄ$     L$  Ƅ$   A   HA H$  4HǄ$     L$  Ƅ$   A   H1 H$  4L$x  L$  E33H$h  -A   H]A H$h  P4L$  L$   E33H$  }-A   HH1 H$  4L$8  L$@  E33H$(  @-A   H@ H$(  3HcIOHL$  H辳LL$  HI   D  HT$8HaD(IO0L$h  HLL$  HI   D  H$   H`(I   L$(  H[D  HT$PH`(AXA\EXAYAWDf AXA4$^XL$X  L$`  E33H$H  %,A   H/ H$H  2L$H  HH$  袲0H$H  !H$(  H$  H$h  H$  H$  6 8   IO`LD$(H$   D$(HT$(H$   H$  HtL$  L+Ij&HT$pHt%L$   L+IK&WD$pL$   H$   Ht(L$   L+I&W$   L$   HT$PHtLD$`L+I%HT$8HtLD$HL+I%Dl$(HT$(H$   $H$   G| (H$   HtL$   L+I%(H$  H3* L$P  I[8Is@A(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@!' D($h  H^H+HWL$XLt$hHtHHHH;thEHHHt3 HHD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3R HHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$XqHVH+HHL$pG5ή Dm D$   =  fD/i  Y5 $   fD/  HL$pHHtmH$   H+HH;vC H    H=   r<t' HAH;r H+Hs H'v
 Hi/ HL$0
 HL$X	 HtqH$   H+HH;v
 H    H=   r=@t
 HGH;r
 H+Hs|
 H'vo
 HH. HtlHD$PH+HH;vF
 H    H=   r<t*
 HCH;r
 H+Hs

 H'v	 HHi. A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;v H    H=   r<t HAH;r H+Hs H'v{ H, HL$0 HL$Xz HtqH$   H+HH;v: H    H=   r=@t HGH;r
 H+Hs H'v HH\, HtlHD$PH+HH;v H    H=   r<t HCH;r H+Hs H'v~ HH+ (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(2rHHT$(HPAEHT$(HPHHHT$(P HL$(Ht HT$0
LD$8HT$(L+IH\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHH~qHHT$(HPWD$@Hl$PHT$@HuHLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$H>LD$PHT$@L+IWD$@Hl$PHL$(Ht.HT$0LD$8HT$(L+IWD$(Hl$8H; IIN L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
fLP  L8  L0  D  = HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn(Z Z ,H
hH8
 HD$@Hp
 HD$PHM H  E3HT$XHL$@[ HD$@HcHH HD@HD$@HcHhT<HD$XHD$0HL$X H HD$X3HEEH HL$Pf`HcHMh  HL$PHcQHL$PHHPAHL$P HHr %`Hȋ       HMx/  HD$0H7r HL$P_HHu3
H HcHHHD$0HPfAnY^,H  HHq _HT (   H6 HEHL$P_HX  HHT$@PHD$@HcHHe HD@HD$@HcHhT<H HD$XHL$X0HL$X  HL$` HM  HX  L0  HLMHU@HPHIo  H HE@HMHD     t5Ǚ  u(H@  HD$ LMI, LIIq;   D  D   H
1L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  +HH$  ;W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  rHL8HL$pHHLxHL$xHHLxH$   H$   HHL$pHg H$   WH$   /H0 H$   H$  H H$  H$  H$  H$  H$   y $(  (
 )$0  W$@  D$H  Ǆ$L      $P  D$X  Ƅ$\   $`  H H$   HT$pH$   $8  f/v	$0  $@  f/v f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H H$   H H$  H$    H$    H$    H$    H H$   HL$p H$   HtL$   L+I+33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p
HHL$t	W$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   sWD$xH$   LLGIH$   HHHL$xHHHXH$   HHHXH$   H$    HHL$x脵H H$   WH$   H H$P  H$`  H. H$X  HD$pH$h  HD$pH$p   $x  (
| )$  W$  $  Ǆ$      $  $  Ƅ$   $  H6 H$   WH$  NL5o L$   L= L$  HT$xH$   $X  f/v	$  $`  = f/vf/v	$  $  $h  Oȉ$  Y
 (<P $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   " L$   L$  H$p   H$`   H$  8H1 H$   HR H$X  H$8   H$(  v H$  h H$   Z HS H$   HL$x@ H$   HtL$   L+I33HL$x H$   HtL$   L+IdN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  HH$  +W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   WD$pLLGHH$h  誤HL8HL$pHHLxHL$xH$h   HHL$pGH H$   WH$   'H H$   H$  H H$   H$  H$  H$  H$  (
 )$   (
+ )$0  D$@  Ǆ$D      $H  D$P  Ƅ$T   W$X  H$ H$   HT$pH$   b$(  f/v	$(  $0  f/v f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     H1 H$   H H$   H$   , H$    H$    H$    H H$   HL$p H$   HtL$   L+I>33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xH)
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pHHL$tW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   胶WD$xLLFIH$   BHHHL$xHHHXH$   H$    HHL$xܨH| H$   VH$   輸Hm H$8  H$H  H^ H$@  HD$pH$P  HD$pH$X  ( )$`  (
Ɩ )$p  $  Ǆ$     T $  $  Ƅ$   W$  H H$   VH$  聾L5* L$   L= L$  HT$xH$   Ѹ$8  f/v	$h  $@  = f/vf/v	$x  $  $H  Oȉ$  Y
 (oF $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  &H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   e L$   L$  H$X   H$H   H$   kH H$   H5 H$@  H$(   H$   H$    H$    H H$   HL$xs H$   HtL$   L+I33HL$xA H$   HtL$   L+IN   H$x  H3
 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3P H落HHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHM)Z HQ H]HL$xHEHL$xHMHT$pLL+t
HB HT$pWEHs WEHE    HMrWHHUHPAEHUI蒇IE HUIP HMHtHUQLEHUL+I-H]HM@HEHMHMHULL+tHA EEfEMLHUHM
, D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H    +fDnED^^ HM5ZH   HIP w H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H     +fn^5Ȏ LM(A(h\LM(A(X\(A(HMaH HEHM: L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"IN Ht
H艹I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  V II谖  L$   H$   H$   L$   WD$xHt3a H衸HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   
U H2 H$   H$   ͷH$   H$   H$   HT$xLL+t
Hk= HT$xW$   H> H$   LMH$   H$   H$   FULMHH$   Pr D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I  +fDnED^ Aƅ    A   y< AExH$   \UH$   ICIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4& +fn^5܉ L$   (A(xWL$   (A(dW(A(H$   \H H$   H$   :  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  ]HH$  mW$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   -WD$pL$   LLFIH$  褖HL HL$pHHL`HL$xHHL`H$   H$  F HHL$pAH H$   VH$   agHb H$   H$  H H$  H$  H$  H$  H$    $(  (
3 )$0  W$@  =G $H  $X  Ǆ$P  
   H H$   HT$pH$   g$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H H$   H& H$  H$   X H$   J H$   < H$   . H' H$   HL$p H$   HtL$   L+Ij33HL$p H$   HtL$   L+I8N   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xHI
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$tW$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   藣WD$xH$   MLFIH$   HHHL$xHHHXH$   HHHXH$   H$    IHL$x記H  H$   VH$  bH H$`  H$p  HR H$h  HD$pH$x  HD$pH$   $  (
 )$  W$  = $  $  Ǆ$  
   H  H$   VH$  舤L= L$   L% L$  HT$xH$  c$X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y
 (k3 $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  "H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   i L$   L$  H$x   H$h   H$   _H  H$   Hy H$h  H$H   H$8   H$    H$   Hz H$   HL$xg H$   HtL$   L+I33HL$x5 H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  BHH$  RW$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pLLFIH$h  ЇHH     HL$pHHH@    HL$xH$h  : HHL$peH H$   VH$   EH H$   H$  H H$   H$  H$  H$  H$  (( )$   (
I~ )$0  =I{ $@  W$P  Ǆ$H  
   H H$   HT$pH$   蘠$8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H, H$   H H$   H$   W H$   I H$   ; H$   - H& H$   HL$p H$   HtL$   L+Ii33HL$p H$   HtL$   L+I7N   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xHI
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$tW$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   藙WD$xLMFIH$   VHHHL$xHHHXH$   H$    HHL$xH H$   AVH$   ϛH H$H  L$X  Hq H$P  HD$pH$`  HD$pH$h  ({ )$p  (
y )$  =v $  W$  Ǆ$  
   H: H$   AVH$  詡L=j L$   L% L$  HT$xH$   $8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
6w () $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   CH$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$    L$   L$  H$`   H$P   H$  耹H H$   HJ H$P  H$8   H$(   H$   H$    H H$   HL$x H$   HtL$   L+I33HL$xV H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I> Ht
HyI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  < II}  L$   H$   H$   L$   WD$xHt3Q H葟HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   ; H" H$   H$   轞H$   H$   H$   HT$xLL+t
H[$ HT$xW$   H. H$   LMH$   H$   H$   6<LMHH$   @b D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^q Aƅ    A   i# AExH$   L<H$   I*IMHH$   P| Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$ +fn^5p L$   (A(h>L$   (A(T>(A(H$    CH H$   H$   *  H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[@SVWH   HD$0H
 H3HD$xIHHHD$p   HD$h    D$X A   Hd HL$XHD$P   HD$H    D$8 A   H9 HL$8WHNH+H*HHLI?LH\$(D$    DHL$8ZHD$PHrQHHL$8H=   r<t HAH;r H+Hs H'v H HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<th HAH;rX H+HsH H'v; H HHHHHL$xH3 HĀ   _^[@USVWAVHl$H   HEH
 H3HE'MHHHE   3H]]DCH HMHE   H]]DCHr HMHE   H]׈]DCHR HMLt$ LMLHUHMW/HEHrPHHMH=   r<t* HAH;r H+Hs
 H'v Hl HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   H]E HEHrPHHMH=   r<tV HAH;rF H+Hs6 H'v) H H!p HH0Hp H;p r
0   `HHMHtHLNL+IMC  HHHHM'H3 Hİ   A^_^[]H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtH  uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
#Q I   LNB	9jn   HII9H3H-m HLL%m HL= m H;1HLH0  HEH?L   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
`l  =Tl H
j H
;l > Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05g f     IM(W Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05Yf f     IM(W_ Hv;}(|(t$0Ht$hH\$`MHT$ HPIHHIINHPHHHL$ IVA Hl$pH@A_A^_H   "A)(Yf ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YYf Y=Pf \A(Ye ^X^^A(\AX(YY\ H$   (D{e XDfd (\D H$   A(YA(^Wo (YA^A^XX^YWoo AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM9  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHKDHH@  HEHCHEHLL+t E3EH  D=6m D5a @ f     H   H HEuIHEI^HGH;t'H;tHs Ht
H讏HL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHME# LMHH   H=]tAXAY
HuLuI~ uA("HHEIHEHEHEHM7  (A$A(H   YH(  X	f/   fA/r	E   (T
k A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHFܼ D(Y5a A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(] H\$    LMHH_ DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(HY
 H3H$X  MMHHH$  H\$ HL$0H$0  HD$@H$8  MMHH$0  % H$0  HL$0DHxH$H  HrTHH$0  H=   r<t HAH;r H+Hs H'v H HtHHT$0HPH$   H$   _ H$X  H3? H`  A_A^_^[LMCSVWATAUAVAWH  IǃA)sA){H
 H3H$  ILH$   LH$   H$   L$x  L$   H$  H$   IǃP   3IH@$  DGH I8HǄ$X     H$P  @$@  DGH H$@  WHǄ$x     H$p  @$`  s MA.Hc H$`  EF AG D;t"D$ L$  H$@  H$`  !H$x  HrTHH$`  H=   r<t HAH;r H+Hs H'vu H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<t$ HAH;r H+Hs H'v Hf HǄ$X     H$P  Ƅ$@   H$  HrTHH$  H=   r<t HAH;r H+Hs H'vy H HǄ$     H$  Ƅ$   A   H H$  RHǄ$X     H$P  Ƅ$@   A   H` H$@  HǄ$x     H$p  Ƅ$`   7 MA.H' H$`  HCEG D;t#HD$ L$  H$@  H$`  5H$x  HrTHH$`  H=   r<te HAH;rU H+HsE H'v8 H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<t HAH;r׶ H+HsǶ H'v H) HǄ$X     H$P  Ƅ$@   H$  0Ic_ WD$`Ht3 HΆHHD$`HL$`H\$hW($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$`H$8  HHH+HHHHH~'fD  f)HH;}$  HL$8LH$    Ic_ WD$HHt3 HHHD$HHL$HH\$P($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$HH$8  HHH+HHHHH~(    f)HH;}$  HL$8LH$    Ic_ W$   Ht3 H)HH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$    Ic_ W$   Ht3	 HIHH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$   ? Ic_ WD$xHt3, HlHHD$xHL$xH$   ($   H$   H$   H$   H$   H$(  HD$0H$0  HD$xH$8  HHH+HHHHH~2@ ff     f)HH;}$   H$   LH$   \ D|$8|$p5T      $p  D;  DA  ~6H H$   M(( 3AHvE;w |H$   L$   H$`  IHHHL$xHHT$xHPH$   HHH$   H$`   H$   tH$`  H$   H$0  H$   L$   L$  HT$xH$   Q H$   H$   茥HXH$   軘HtHH$   HPH$0  H$8  E33H$   CA   HV H$   H$  H$  E33H$   MA.H H$  L$   H$   H$  TH$  H$   L$   L$   HL$`H$  H$  H$   H$   H$(  HD$XH$0  HD$`H$8  LL$hIHH+HHHHH~, (fAX)HH;}L$   H$  MH$   7r LD$HLD$8L$   L$  L$   L$  HL$HH$@  H$@  H$   H$  H$(  HD$1H$0  HD$8H$8  LT$PIHH+HHHHH~B     A(fAY(fX)HH;}L$  L$  H$@  MH$   f= ADd$8H$  1H$   ]3Dd$8WL$   H$   H$   L$   H$   fn($@  HL$`H$  H$  H$   H$@  H$(  HD$1H$0  HD$`H$8  LD$hIHH+HHHHH~<@ f     (f(f^)HH;}$@  H$  H$   
 $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  HD$HH$8  LD$PIHH+HHHHH~5fD  (f(f^)HH;}$@  H$  H$   T HD$HHD$8HL$HH$  IOH$  IWH9T$PtA   HL$8\ HD$8HH$@  H$@  H$   H$  H$(  HL$1H$0  HL$8H$8  LpIHH+HHHHH~FH$  ()$`  H$`  H$  (fYH$@  )HH;|MHH$   W HD$HH$   $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  H$   H$8  LD$PIHH+HHH~=@ ff     (f(fX)HH;}$@  H$  HH$   ap HT$`H$   迱HT$HH$   譵HL$x	 H$    H$    HL$Hߩ HL$`ө H$  H3 ($   ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
  HMLM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMaLMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMLMHMLEHtHHLMLEHMHHMHHcI;F}!H
P z H
B l WEHE    LEHUI[  (HMH   HEH+HH?H;vC H    H=   r<t' HAH;r H+Hs H'v Hi WEHE    HMHthHEH+HI;v§ H    H=   r<t HAH;r H+Hs H'vy H (L\$pI[ Is(I{0Mc8(t$`IA_A^]LMCSVWATAUAVAWH  IǃA)sA){H#
 H3H$  IHH$   LH$   H$   L$8  L$   H$@  H$   IC   3I{@$  DGH IxHǄ$8     H$0  @$   DGH H$   }HǄ$X     H$P  @$@   MA-H H$@  <DF(AG(D;t"D$ L$  H$   H$@  
H$X  HrTHH$@  H=   r<tȥ HAH;r H+Hs H'v H
 HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<tJ HAH;r: H+Hs* H'v H HǄ$8     H$0  Ƅ$    H$  HrTHH$  H=   r<t̤ HAH;r H+Hs H'v H HǄ$     H$  Ƅ$   A   H H$  xHǄ$8     H$0  Ƅ$    A   H H$   AHǄ$X     H$P  Ƅ$@    MA-H H$@   HCEG(D;t#HD$ L$  H$   H$@   "H$X  HrTHH$@  H=   r<t HAH;r{ H+Hsk H'v^ H HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<t
 HAH;r H+Hs H'v HO HǄ$8     H$0  Ƅ$    H$  VIc_(W$   Ht3 HrHH$   H$   H$   W($`  HL$PHD$PH$   H$`  H$  HD$0H$  H$   H$  HHH+HHHHH~.@ f     f)HH;}$`  HL$PLH$    Ic_(WD$8H|$HHHt5HHHH;t6HtHHHH;tLLLLIHL$8.|$PHD$@H;u
LD$HL;t:HtHHHH;tLLIHL$8LD$HHD$@HL$8H$`  H$h  H$`  H$   HT$PH$  HT$0H$  HT$8H$  LIHH+HHHHH~"D$Pf)HH;}
H$`  H$    Ic_(WD$`Ht3o HpHHD$`HL$`H\$h(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$`H$  HHH+HHHHH~+ff     f)HH;}D$PH$`  LH$    Ic_(WD$pHt3 HoHHD$pHL$pH\$x(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$pH$  HHH+HHHHH~(    f)HH;}D$PH$`  LH$    Ic_(W$   Ht3ɝ H	oHH$   H$   H$   (|$PH$   H$   H$   HD$PH$  HD$0H$  H$   H$  HHH+HHHHH~)     f)HH;}D$PH$   LH$    D|$4$   5@      $0  D;C  DA( ~+H H\$pM((}  AHvE;w(|LD$pH$@  IvHH$   HH$   HPH$   HHH$   H$@  R H$   H$   H$   H$  H$   LL$`L$`  H$   H$    H$   H$   4HXH$   cHtH$   HH$   PH$  H$  E33H$   A   H H$   |H$p  H$x  E33H$`  詸 MA-H H$`  5LD$`H$   H$`  {H$`  蜃H$   莃LD$`L$  H$   H$   H$   H$   H$  H$  HD$1H$  H$   H$  L$   IHH+HHHHH~, A(fX)HH;}L$  H$   MH$   ] A( U  L    LM0  MYICH   A   IHT$@IHL$8HD$`BHD$pBYXIRHT$@IHL$8HD$`BHD$pBYDXIHT$@IHL$8HD$pBDHD$`BYXIRHT$@IHL$8HD$pBDHD$`BYXIIM;&M;9IHT$@IHL$8HD$pBHD$`BYXIM;~IA;_(ADd$4H$  PH$   3Dd$4WL$   H$   H$   L$   fn($   H$   H$  H$  H$   H$   H$  HD$1H$  H$   H$  L$   IHH+HHHHH~:fff     (f(f^)HH;}$   H$  H$   $ $   HL$8H$`  HD$@H$h  H$`  H$   H$   H$  HT$1H$  HT$8H$  LD$HLIHH+HHHHH~4D  (f(f^)HH;}$   H$`  H$   d IwMwHT$8L\$@HD$HH$   L$   H$   L$   I;IMLL$   I   I@H$   MfIMkIO6OLHMIIHH$    (A^XJIHI(^DXDDJJ(^DXDDI>I(^DI;IXDDHJ    LJ    LIMH;$   H$   XL$   I;}BN   N4   HIHHIHL+(^X  IIIuH$   H$   xHT$8H$   yH$   K HL$p? HL$`3 HL$8' H$    H$  H3 ($  ($  H  A_A^A]A\_^[H   HD$ HH$    HHL$( H/
 HL$(G @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@r  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQHp HC(HCH;CuHHCHC H0[@SH H@  H HC`H [HL$SH0HD$ HD$P    EtH6 HAPH HA`D$P   J   H HH HC(HCPHcHHN HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHO H HHGHFHG HF H^(H\$HH HHO0HKHtHPHG8HCHG@HCGHC Hy HHU HHH\$PHt$XH0_H\$WH HHԚ HHQ3HHHKHB_ HЉ HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tH Ht
HbHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@v  IFL\$`I[(HEIF HE HIk0IA^_^@SH HS HHHv HAhHIH HK8 HK  HK H HH [@SH HK| HHHƍ HA`HIHP HK8F HK < HK2 H+ HH [@SH H[y HHH HAhHIH HK8 HK ܏ HKҏ H˂ HH [@SH H[ HHH HA`HIH HK8 HK | HKr Hk HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3"HW(HK(HA   HA    HyrHH  IE3HH\$HH0_@SH H  Hӄ HCPH [HL$SH0HD$ HD$P    EtHu HA@H HAPD$P   J   Hy HH HCHC@HcHH} HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH~ HHQ3HHBHK H-| HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C Hy HHv HHH\$PHt$XH0_H\$WH H<:  H] HG`t
h   Hg HH\$0H _@WH0HD$ H\$@HH8t HH& HA(HI0HtHP tHC0    HX HHKc @t
P   H HH\$@H0_H\$WH H  H HGPt
X   H觱 HH\$0H _@WH0HD$ H\$@HHPx HHf HAHI HtHP tHC     H HHK @t
@   H( HH\$@H0_LH   ICAC    HQHr ICHȁ ICAC   IK{Hv HD$(H HD$@HD$hHcHHz HDhHD$hHcHDd    HF&
 HL$(һ @SH0HD$ HٹX   < HD$@HSHD  HHtH@@HcHHB@HH0[@SH0HD$ HHv HH5 HAHA@HcPH:z HD
@HA@HcPDBDD
<Hv HHÉ HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HHGv HH] HAHI HtHP tHC     H HHKH0[H% HVWAVH`H@HXHhHe
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHK HD$( HHL$ 詏tHC    HL$ kWHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
r H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHC  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HB  HL$8pHL$(HtHPHtL    HA2HL$XH3ť L\$`I[(Ik0IA^_^HVWAVH`H@HXHhHc
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK  HD$( HHL$ 褍tHB    HL$ fUHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
p H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHB  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2HA  HL$8nHL$(HtHPHtL    HA2HL$XH3 L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH?  (HغH n HH_(H    H+ HHH+ H;+ rHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HHM+ HHH@+ H;1+ r蒲HHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   t>   ^   ,A;ALǉ   LCHSHH  ?NtUHH@        ^,A;ALǉ   Y& d    H   H   HH\$PHl$`Ht$hH0A_A^_@SH H[ HHH~o H   Hp   H`   H  )iHJv HH} HC`HKH HK8x HK n HKd H]s HH [Wf/v(      ^   ,;L   H\$WH HHH   HcH   HcH   HH\$0H _cHHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J>  HSH~H_HG`LGpHHO`P8LHHO`9HHL$@Ls(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;vQ$ \( (=2" f/vNHOxf/v?HD$@H;t5HKHT$HUD$hC(HKHT$X<HK0HT$p.]s(HHO`Y  X   w0H| I$I\$H$   HO7OHHHGHCHWHGLL+t W5<, At$A|$ HL$p} HL$X} HL$H} IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   9   ^   ,A;ALǉ   LCHSHH  BtUHH@J        ^,A;ALǉ   Yk!     H   H   HH\$PHl$`Ht$hH0A_A^_@SH H3d HHHvc H   Hx  | Hh  
| H   dHJe HH HChHKH{ HK8{ HK { HK{ Hn HH [Wf/v(      ^   ,;L   H\$WH HHH   H1_H   H"_H   HH\$0H _	_HUSVWATAUAVAWHhH(  HE)p)xD)@HV
 H3HEMILH3t$8G  HSHH_HGhLGxHHOhP8MHHOhHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PD< DD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(D$0HHD$0H#H      H;vl \( (=M f/vLH   f/v:HEH;t1HKHUoEC(HKHUXHK0HUK]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(   w0Hw IE I]H\$0HO#JHHHGHCHWHGLL+t W5(' AuA} HMx HMx HMx IHMH3_ L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   4LGHWHH  Dt8HH7     Y     H   H   HH\$PHl$`H0A^_^@SH Hx HHHj H   Hx  Jw Hh  =w H   _H
c HHt HC`HKHw HK8w HK v HKv Hi HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(Vi(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_iH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@  HL$0mu L$   HHH$   ($   HĠ   _:Hl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]X6 ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3Tt HEHHkHF@HD$hHFHD$xHv H;t'H;tHt Ht
HWEHH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@! HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Y H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWY H   H	H H$   HD$@H$   H$   H$   H$   ̴ YT H   Wf/v f/v   Wf/v   H\$WH HH5  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHwUfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HˋHSHt
HHH
HB$H;Cu
   H蟋HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HBHSHt
HHH
HJ$H;Cu
   HHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H越HSHt
HHH
HB$H;Ku
   H芊HCHt0HH   HCH;s;HH;w3H+HH;Cu
   HGHSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    -  HSII^IF`MFpHIN`P8MHIN`HHMHUH   HUHM0HUH   IF`LHUIN`P(HM?HE HMHM(HULL+tHH HMs?HEHMHMHULL+t	H IN(H?HD$xIN(HMIV LL+t	H EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      D D D% D- H}WD$hHt3Nm H>HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM袝 DUINxfA/  HEH;   HcuH;st$HKnl tH=HCHC    Hs~LEN    HUHKG EC(Hcu H;s t$HKl tHQ=HCHC    Hs ~LE N    HUHK HcuHH;s8t$HK0k tH<HC0HC0    Hs8~LEN    HUHK0 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I/  HEH;  HSHMC(EHSHMHM   H   H;t=HKH      C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I.  H   H;t=HSH   #C(   HSH   H   HS0@  A   uf/w(\	 (INxf/v=H   HM8   EXH   HMHH   HM`f/v\(达X(\(詾(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHMM, HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$hh A   A9   HL$hg Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0W IV(HHL$xRg HMGg HM <g HM1g H   #g H   g H   	g HM`f HMHf HM8f H   f H   f H   f HMf HMf HMf HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   "LGHWHH   +t8HH^3     Y
     H   H   HH\$PHl$`H0A^_^@SH H[b HHH_ H   H  Ze Hp  Me H(  MHa HH HChHKH"e HK8e HK e HKe HW HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(fW(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_!WH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@ HL$0}c L$   HHH$   ($   HĠ   _JHWH   H@HXHhHp )pIHHz W@Ht3c HF4HD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrC  H$   H$   HD$8HD$(HD$@HMHT$8 HL$Hb HL$(tb L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3b HB3HHoIvHH;t'H;tHa Ht
H3HHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   2 HIFHD$pHD$x   INHIF@H$   H$    D$0HT$ LL$pL$   IVP| HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   YP H$   \(t$pHĀ   _   LH   H<
 H3H$   HB LB IKICH@D$@ICISISMCMCICu  HD$h H$   H3} HĘ   Wf/v? f/v   Wf/v   H\$WH HH+1  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHBfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HKyHSHt
HHH
HB$H;Cu
   HyHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HxHSHt
HHH
HJ$H;Cu
   HxHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H6xHSHt
HHH
HB$H;Ku
   H
xHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HwHSHt
HHH
HB&H;Cu
   HwHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w)  HSIkI^IFhMFxHINhP8MHINh&HHM:HUH   )HUHM0HUH   
IFhLHUINhP(HM-HE HMHM(HULL+tHȲ HM,HEHMHMHULL+t	H螲 IN(,HD$xIN(HMIV LL+t	Hr EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      Ds D D% D- H}WD$hHt3Z H,HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM" DUI   ?fA/  HEH;   HcuH;st$HKY tH'+HCHC    Hs~LEN    HUHKİ EC(Hcu H;s t$HKY tH*HCHC    Hs ~LE N    HUHKk HcuHH;s8t$HK0@Y tH|*HC0HC0    Hs8~LEN    HUHK0 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I+  HEH;  HSHMC(EHSHMmHM   H   H;t=HKH   H   C(HKH   +HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I*  H   H;t=HSH   C(   HSH   H   HS0s@  A   uf/w!(\膮 (I   mf/v=H   HM8'   EXH   HMH
H   HM`f/v\(8X(\(#(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$hU A   A9   HL$hsU Hx  D$`A   fn}^HE0H;t1HKHU82EXC(HKHUHHK0HU`s(HINhXA   AV0Wc IV(HDHL$xT HMT HM T HMT H   T H   T H   T HM`|T HMHrT HM8hT H   ZT H   MT H   @T HM5T HM+T HM!T HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQH{T ICHI ICAC   IKH,p HD$(H(R HD$PHD$xHcHHE HDxHD$xHcHDt    H6	 HL$( @SH0HD$ Hٹh   \t HD$@HSH.  HHtH@PHcHHBPHH0[@SH0HD$ HHoo HHmQ HA(HAPHcPHD HD
PHAPHcPDBDD
LH9 HHQ HA(HI0HtHP tHC0    H[ HHKH0[H%R @SH0HD$ HH9 HH}Q HA(HI0HtHP tHC0    HZ HHKH0[H%Q @SVWH   HD$8H-
 H3H$   IHHI @D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   H. HL$@TuHD$x   HD$p    D$` A   H HL$`%uHD$@HD$ LL$`LHHwYH$   H3n HĐ   _^[HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  D fA/  HGPLG`HHOPP8MHHOP5H}(HGHLd$ _xLGPHHOHHWEPHHEPH#H      D H;vA(\A 
 D(ȃ   f/GLcD D  HD$pH;t2HKHT$x舻EC(HKHUqHK0HUdHGPLG`HHOPP8MHHOPCHsHt$8H~ u(HHD$PHD$0HD$`HL$H7 (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$HM7 AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$xEC(HKHUHK0HU   HV HD$03HD$8HD$@H HD$HD$PHT$8HL$HM HG HD$0H	 HL$0Q~ HKV HD$03HD$8HD$@H+ HD$HD$PHT$8HL$HL HF HD$0Hn	 HL$0} HMAM HM7M HL$x,M L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PH3 HA@HB HAPD$P   H7 HHOHA? HHG@HcPH@ HD:@HG@HcPDBDD:<HSHHDgHH\$HHt$XH0_H( Tx f/ w* TZ f/ w H
 H(Hu H
6 a? Ha H
" M? H(
$ L  T f/( w2
 f  T f/ wH
 H(H x3  Hؐ k3  HL$H(/ LD$0HT$8 Ti f/ vK  "    LD$0HT$8T5 f/m vK  "    LD$0HT$8T f/9 vqK  "   H
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H(H_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH6HSHt7HHH
HCH\$0H _H;CuH6HKHtHHHCH\$0H _H\$WH H\t
  Hn HH\$0H _H\$WH H> HHH`F HA`HIHH HO8H HO H HOH H; Ht
   Hn HH\$0H _H\$WH H<t
  Hm HH\$0H _H\$WH H1 HHHd HAhHIH*H HO8 H HO H HOH H; Ht
   HPm HH\$0H _H\$WH HLt
  Hm HH\$0H _H\$WH Hg3 HHHD HA`HIHjG HO8`G HO VG HOLG HE: Ht
   Hl HH\$0H _H\$WH H|t
  HRl HH\$0H _H\$WH HOC HHHpc HAhHIHF HO8F HO F HOF H9 Ht
   Hk HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PH[- HA@HX< HAPD$P   HW1 HHOHF HHG@HcPH5 HD:@HG@HcPDBDD:<HSHHDq`HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt3B H;HEH]WEHt3B HHEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軻(HMfA HM[A (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9HxY \ Y   X} Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`f   EWfA.z  D
 fA/  HG`LGpHHO`P8MHHO`s(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      D; H;vA(\ 诖 D(   f/GHcD%j HD$`H;t3HKHT$h2EC(HKHT$xHK0HU
HG`LGpHHO`P8MHHO`s(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$hEC(HKHT$xHK0HU   HF HD$H3HD$PHD$XH HD$8D$@HT$PHL$8= H6 HD$HH	 HL$H>n H8F HD$H3HD$PHD$XH HD$8D$@HT$PHL$8< H6 HD$HH[	 HL$Hm HM.= HL$x#= HL$h= L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pH
 H3H$P  HHHL$0b3   Hr~ HL$@H(: H$0  HL$01LHHAPH$H  HrUHH$0  H=   r<t< HAH;r< H+Hs< H'v< H9a H$   K1H$   : H$P  H3Y H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
w (  \f/   vƇ   \H(  f/v(\ΏH(  X \(赏XH(   Wf/vH0   X (j H0  X  H;t/HSHNHC(HF(HSHNHS0HN0LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h*9 HHEHsH   HCH;t'H;tH9 Ht
H<
HH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$hۦ  H       D  HY(WEHt3D8 H	HEH] = } H  H[WEHt38 HG	HHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hgh    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt36 HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMg H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(̊(Xu \蹊(XuuHUH(  H蹟Ef/w"\k (H   HxNf/vHE0H;tHU0H3WEH]HHt34 H/LHEH]LEHuHEHEHEHEH;t-I4 HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   +HM\3 HMQ3 HM`F3 HMH<3 HM823 HM'3 HM3 L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9H݌Y \M Y   X= Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH
 H3HELHHyHHL$@#   EWfA.z\  D
h fA/H  HFhLFxHHNhP8MHHNh贌w(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      D H;vA(D\ g (   fD/GLcD" fHD$@H;t5HOHT$HD$hG(HOHT$XϜHO0HT$pHFhLFxHHNhP8MHHNh蠋LGI@H_@HEDELEH]LEHEHEHUHM  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM軟  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H[D$hG(HOHT$XBHO0HT$p4   H7 HE3HEHEHu HD$0D$8HUHL$0Z. HC( HEH	 HM_ H7 HE3HEHEHru HD$0D$8HUHL$0	. H' HEH	 HMD_ HL$p. HL$X. HL$Ht. HMH3PL L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pH	
 H3H$P  HHHL$0$   Ho HL$@XH(, H$0  HL$0"LHHAPH$H  HrUHH$0  H=   r<tW. HAH;rG. H+Hs7. H'v*. HR H$   "H$   , H$P  H3J H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\.H(  X \(XH(   Wf/vH0   XJ (ʂ H0  X  H;t/HSHNoHC(HF(HSHNZHS0HN0MLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hR  HMHLHT$hP(HH   HHHHPHKHHHSHL$h* HHEHsH   HCH;t'H;tHa* Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h;  H       D  HY(WEHt3) HHEH] = } H  H[WEHt3g) HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hY    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0I}H  L@LEWEMt3( HMFHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMgX H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(,|(Xu \|(XuuHUH(  HEf/w"\} (H   H讀f/vHE0H;tHU0H蓤WEH]HHt3O& HLHEH]LEHuHEHEHEHEH;t-I& HtHOLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHMk LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHMo  LML   H   H   1HM$ HM$ HM`$ HMH$ HM8$ HM$ HM|$ L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH$ HAPHH HA`D$P   H@ HHO(H" HHGPHcPH HD:PHGPHcPDBDD:LHS(HHDa>HH\$HHt$XH0_HL$HH? LL$P)t$0LD$X3)|$ 45 = Tf/   ' LL$PLD$X3Tf/    LL$PLD$X3Tf/    LL$PLD$X3Tf/    LL$PLD$X3Tf/    LL$PLD$X3fTf/ws(t$0(|$ HHHh H
V  Hg H
V  Hg H
V  Hg H
V  Hg H
V  Hg H
V  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	! Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@虏  IVHO   L\$`HI[Is I{(IA^H\$WH H_ HHA`HIH  HO8  HO   HO  H Ht
   H
F HH\$0H _H\$WH H?= HHAhHIHt  HO8j  HO `  HOV  HO Ht
   HE HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	 Ht
H,HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@ɍ  H\$xHH$   H`_@SH0HD$     HHd  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH Ht
HHL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ U  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8 (fow IHFHMEHEUHMHME0HuMH] E H](M@fo
2 fEPU`Mp Xf/FvFHHI;L$8  IHN 踕  ID~DHN0LN@HLF0A   HV 
  H$@  FDHAD~HH   A_A^_^]pUH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _ HH HH} H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMH3 HHEHE   HE    E A   HN HM>HE0   HE(    E ; uE3IIB< uHHM>HEP   HEH    E8 A   H HM8~>3fff     H}H;   H+H   HHuH}HCuHH   LǺ%   H HH   :

 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
9 A   HHM9H)IE3HUHM85BA   H HM8@IHMXӪ  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   Hf HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM<8IIE3HUHM8@HE8H}PHCE8H
  HL$03HL$8HL$@HD$HD$PHT$8HL$H_ H HD$0HT$0HM% HHL$`w H	 HL$`|H HUAVAWHhH@  HD$XHXHpHx H	 H3HE8L=# HLEHE   E3LuDuEF"HO HMU;HE0   Lu(DuEFH HM0;A@      H}H;   H+H   HHuH}HCuHH   LǺ%   HF HH    :] uC:R uC:G uAtH+HHHsHEH}HCEH+Ht+HD$    L
5 A   HHM16H(IE3HUHM>A   H HM~=A? tI@ IC<7 uMIHMW=HEH}0HCEH
 HL$03HL$8HL$@HD$HD$PHT$8HL$H HX HD$0HT$0HM] HHL$` HP	 HL$`4F @SH0W)t$ f/Ȼ   (vW5 (l  (,t
Xʃ\
(\(f/
3 v\(Y
2 (Rl fnY(t$ YH0[Hx)t$`(| f/)|$PWD)D$@D(D)L$0D(v(k W   fD.z  f.zv  D)T$ D^ fA/L  D
r fA/r4Dj ff     AX(ik fA/XsD(E\-
 eH%X      HЋ9
   X5 A(AYAY((Y
 (Y
 Y
9
 XY
 XY
 X

 YYYX%
 X%
 X
ݯ
 AYYYX
 X
 X(Yɯ
 AYX
 YX
 YXX
p
 ^YY5 X  D fD/v(5j E(\D(AX
 eH%X    f/ƹ   HЋ   9/
 h  A(A(AYAY((Y
 (Y
 Y
z
 X´
 X´
 X
R
 YYYX
 X
 X

 AYYYXa
 X
 X(Y

 X
 YXֶ
 AYX^YY% X   9
 )  EYDW; A(AY((Yl
 (YY
 Y
 XA
 X1
 X
ɩ
 YYYX
 X
 AYYX(Y
 X
m
 Xղ
 Xu
 YXY
 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
r
 0 =f
 ( H
R
 (
k <
 (= N
 v N
 ( 
 
 (
 )ʬ
 ( )
 (
շ )ά
 )
 / UH
 0 =
 (M H
 (
 H
 (! Z
  Z
 ( 
,
 (
U 
 6 
 (
 
 
 0/ H
l
 / =`
 ( H
L
 (
 

 (s 
 ( 
 (
 
  
a
 (
ڽ 
 
k
 . IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
 A(.   f f.zu j  !     ߴ f/   (LW  Hh((Y(T
ϼ fD/vlY
  x f/vVfA.zu3(H       $   H$      E fn "   Y S  $ ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ d f.(   u~ f/vpH      $   H$   H#H;  fA/s(dd (f/ò   
} f/  ,H( Y<Z   f/v:~ f/v
 =  "   D^D\
 AY  H$   W`D D(DX
A YE\A(c 
 Yf/   AYf/wBAYA(\5E (c (A(sc  (^^Yf/vvfA.zu3*H       $   H$      EË fn "   Y (A\A((c (A(b ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   H&Q H
wC j L$   H
Q H
R N H\$D$WH`)t$PI)|$@H(D)D$0ǰ f/ro(1b f.z  (m(Wf/K WvW a D(E3(LHqD\(a D\   f/vfWf.z0  ո (
 Tf/va D(DW     ^\ Tea D(    f/v$((\ \
 (
  D(of/= r! f/v(d  a D(DHL$p/^` D((XK \ ` \6 \= YDXH\$xA(D(D$0(t$P(|$@H`_LD$pHj H
C   LD$pH H
*   H(Y| LL$0LD$83(T
i f/
 w
Y H(HN H
d= o  H(Y LL$0LD$8胯(T
	 f/
A w
Y H(H#N H
$=   H\$D$WH`)t$PI)|$@HD)D$0(Dޫ D)L$ A(EWfD/   P_ f.zZ  D f/ru(LWi H((fY(T
8 fD/vY
i  f/  ߭ ^fA.    A(  fD/v ff     ^AXfD/wt$p(^ f.(   u~S f/vpH      $   H$   H#H;  fA/s(-^ (f/   
F f/x  ,H Y<    f/v*G f/Z  D^D\ AY   HL$p3ZD
 D(DX YE\A(] 
 Yf/vVAYf/  AYA(\5! (s] (A(O]  (^^Yf/v&   A\A((4] (A(] ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pH. H
 R  HJ H
   LD$pH1K H
= u| LD$pHK H
L \| H,= H
   Hx H
   H H
   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3 HHD$(Hl$0HT$(H茞  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"HX Ht
HHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H@ Ht
H{HH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;t;HtHHHH;t;HHHHGH;t"H Ht
H$HH    H_H_HHL$8 HL$( H$   H`A_A^A]A\_^]@SH Hbz  HH [@SH0HD$     zy  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH9 HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIM7MwMwLuI誓HHoWD$@HD$P    E3E3HT$@H躜L\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uHHHF)L;t$HV. HHVHªH~H$`  H$P  HHHI$I$H;uIT$H;uHGI$ID$'H;t"LIT$. HIT$HI\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W-ʬ 3MtlA(Y5W (Y=L D(D\D
£ D HfE/v((+ AYA((X IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  袰LLD$XHT$pp*HH
L;   IH   IWըMIOI+H*HHHH?HH;v
 HRHH=   r=At I@I;r L+Is I'v LI/" I?IIHIHCIGHCIGH;H{H{HL$pH   HT$xH$   LD$pI+H*HHHH?HH;v= HRHH=   r=At  I@I;r L+Is  I'v LI_! H$   HtwH$   H+HH?H;v H    H=   r<t HAH;r H+Hsy H'vl H  HL$XHttHD$hH+HHH;v7 H    H=   r<t HAH;r H+Hs H'v H]  H   HT$HH&HD$PH+HHH;v HH=   r=@t HEH;r H+Hst H'vg HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]LWATAUAVAWHP  IǃPI[IsA)sA){E)CE)KE)SE)xE)hE)XH	 H3H$  HL=y EWE(W$   Iǃ8    IMIǃ    Iǃ    H
HBH+HHueH Ip3IxIH/ HD$0D$8IxHL$0 Hk H$  H/ H$  HǄ$     DD$   HBH+HHwiH H$  3H$  H$  Hb/ HD$0D$8H$  HL$0 H H$  H. H$  :   H$  DID$   D$@E3LL$PMc}xIMt$M;v
H
+  IHL$@8LL$PE3HT$HLD$@M;  HFH+HH;riH  H$  3H$  H$  Hq. HD$0D$8H$  HL$0 H H$  H. H$  IHHH$  H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
*  HM+IIHIH+IE3I;LCL;ICHL$@7LL$PHT$HLD$@H   IH   I;usIH+HHscI+HIH+Hs
H
* 2 HM+IIHIH+IE3I;LCL;ICHL$@7LL$PHT$HLD$@Ht2HHT$HIH$  xDX8M AXD$0WD$X3H|$hIcE,HD$(Ht)I;v
H
Y)  HHL$X6H|$hHD$(E3H\$`Ht$XL;  H$  (D$ HD$ H;   HD$ H;   Lt$ L+IH;utHH+HHsdH+HIH+Hs
H
(  HSH+HHHIH+HE3H;LCL;ICHL$X5H|$hH\$`Ht$XHt5JH,H;u   HL$XMH|$hH\$`Ht$XHt3HH\$`IHD$(A
    HǄ$      E3L$  D$  ED$Hb% H$  MHǄ$      L$  D$  ED$H& H$  EExEyH$  H$  hCH$  zH$  lIcUxH$   ;IL$   IH$   H+HHt0LD  A<HL$   IH$   H+HH;rIL+IMt*f     <HH$   H+$   HH;r
    HǄ$      L$  Ƅ$   A   H( H$  HǄ$      L$  Ƅ$   A   Hq% H$  EExAyH$  H$  BH$  *H$  AExHcHL$pILD$xIHT$pH+HHt.Lf     A<HLD$xIHT$pH+HH;rIL+IMt<HHD$xH+D$pHH;r~
    HǄ$      L$  Ƅ$   A   Hm$ H$  L$     HL$p謕DH$  *   D  A;]x0  8~
    HǄ$@     L$8  Ƅ$(   A   H# H$(  FHǄ$      L$  Ƅ$   A   HH" H$  HcL$(  HHL$pHL$  HHL$@ޔ0X6HǄ$      L$  Ƅ$   A   HI# H$  HcL$  HL$p舔0H$  H$  H$(     D%      A;}x  |
 %   HǄ$`     L$X  Ƅ$H   A   H! H$H  HǄ$      L$  Ƅ$   A   Hh" H$  HǄ$      L$  Ƅ$   A   H1" H$  HcI   L$H  HmLL$  HHL$pUHHcL$  HL$p;^ A(\AA\YHǄ$@     L$8  Ƅ$(   A   H! H$(  L$(  HH$   Β0H$(  MH$  ?H$  1H$H  #E{
 &   HǄ$`     L$X  Ƅ$H   A   H  H$H  SL$H  HH$   :DXH$H  AAMx;}A;}z
 +   HǄ$@     L$8  Ƅ$(   A   H H$(  HǄ$`     L$X  Ƅ$H   A   H H$H  EE(EyH$(  H$H  <H$H  H$(  IcU(H$  IL$  IH$  H+HHt+LA<HL$  IH$  H+HH;rIL+IMt(    <HH$  H+$  HH;rqy
 .   D$(   Dd$ LD$(HT$ H$   q  D$ HT$ H$   i+y
 /   D$    Dd$(LD$ HT$(H$   +  D$ HT$ H$   #x
 0   Dd$ M   HT$ HL$@  D$ HT$ H$   x
 1    D$(Dd$ LD$(HT$ HL$0E  D$ HT$ H$   _x
 2   Dd$ M   HT$ HL$X  D$ HT$ H$   `   D$   D$   DΙ A;u(  w
 6   HǄ$     L$  Ƅ$   A   H H$  HǄ$     L$  Ƅ$   A   H H$  L$x  L$  E33H$h  A   H H$h  L$  L$   E33H$  A   H H$  SL$8  L$@  E33H$(  A   H? H$(  HcIMHL$  HLL$  HI   HT$@HW;D(IM0L$h  H迍LL$  HI   H$   H;(I   L$(  HHT$XH:(AXA\EXAYAW@ AXA7^XL$X  L$`  E33H$H  fA   H-
 H$H  L$H  HH$  0H$H  bH$(  TH$  FH$h  8H$  *H$  77u
 8   IM`LD$0H$  %  D$0HT$0H$   =H$  HtL$  L+I HT$pHt%L$   L+I WD$pL$   H$   Ht(L$   L+IZ W$   L$   HT$XHtLD$hL+I+ HT$@HtLD$PL+I Dl$0HT$0H$   eH$   V  (H$   HtL$   L+I(H$  H3! L$P  I[8Is@A(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHFHVH+HL$   I
3HFH+HH   $   D(DXL%HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;vu H    H=   r<tY HAH;rI H+Hs9 H'v, H
 L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHL"(W$   LKL+IL$   IIGMH$   HD$ MH$   I_HSH+HHL$PWD$8HD$H    LCHHL$83HKH+HHT$8H  L	5I HIL43 HBX0 LL$PMHT$8I43HCH+HHl$PHtvMH
 YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8L'H -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;v H    H=   r<t HBH;r H+Hs H'v} HH HtmHD$`H+HH;vT H    H=   r=@t7 HEH;r' H+Hs H'v
 HHv (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  H	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@Z"HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
  HQM+IIHL+IHM;HCH;HCHL$@!HL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
 " HQM+IIHL+IHM;HCH;HCHL$@!HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   LFLL$`I{^  H$  H$   HXH$  DHtINHH$   PHt$hH\$`H~&Hfff     HHL$@bHcH;|IHHT$@PH$  H$  > H!H$  H$   HL$` HT$@HtLD$PL+IuH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HII3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  K  IIL$   H$   H$   L$   WD$xHt3! HaHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   J  H H$   H$   荭H$   H$   H$   HT$xLL+t
H+3 HT$xW$   H H$   LMH$   H$   H$   KLMHH$   2 D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^e Aƅ    A   92 A   H$   KH$   I蹬IMHH$   PI Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5 L$   (A(5ML$   (A(!M(A(H$   QH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHw	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H9I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  F  II萗L$   H$   H$   L$   WD$xHt3 HQHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   E  H H$   H$   }H$   H$   H$   HT$xLL+t
H. HT$xW$   H H$   LMH$   {H$   H$   ELMHH$    " D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^U{ Aƅ    A   )- A   H$   	FH$   I	IMHH$   P9 Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5z L$   (A(%HL$   (A(H(A(H$   LH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHg	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H)I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  A  IIL$   H$   H$   L$   WD$xHt3 HAHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   @  H H$   H$   mH$   H$   H$   HT$xLL+t
H) HT$xW$   H H$   LMH$   kH$   H$   @LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^Ev Aƅ    A   ( A   H$   @H$   I虢IMHH$   P) Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5yu L$   (A(CL$   (A(C(A(H$   GH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHW	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  <  IIpL$   H$   H$   L$   WD$xHt3 H1HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   ;  H H$   H$   ]H$   H$   H$   HT$xLL+t
H# HT$xW$   H H$   LMH$   [H$   H$   ;LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^5q Aƅ    A   	# A   H$   ;H$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5ip L$   (A(>L$   (A(=(A(H$   BHu H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
  HsHHCHHHHKLHT$`HL$X  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
 # HHHGHHH_LHT$`HL$X6  HGH\$hH@_@USVWAVAWHl$H   HEH	 H3HEIIHL
T
 eH%X      LE3B
9s
 ~^H
s
  =s
 uIHo
    L=o
 D=o
 EGHt H
ro
 }H
  H
as
  HE   L}E A   Hgt HM>LHUH
o
 JvHM谰HE   L}E A   H3t HMLHUH
n
   HMlHE   L}E A   Ht HM; oHE   L}E A   H{ HMHE   L}E A   H4 HMcHEHD$ LMLHUH
7n
 BHMȯHE   L}E A   Hss HMHE   L}E A   H\s HMHE   L}E A   HMs HMHMJHM@HM6WeHEHEH}fn2j ^HfnH\Y(YYwi (\Y\eIHMG:  IHMH3 H   A_A^_^[]HUSVWATAUAVAWHhH   HD$0)p)xH֡	 H3HEMMHH
P
 eH%X      L3B
97o
 ~]H
.o
  ="o
 uHH=m
    H.m
 m
 DCHq H
m
 aH
Z  H
n
  HGH+H  W(HE   H]E A   Hq HMLHUH
l
   HM}HE   H]E A   Hq HMMHUH
Xl
   HM9HE   H]E A   H\q HMA$f/woHE   H]E A   HA HMPHE   H]E A   H HM)HEHD$ LMMHUH
k
 pMHUH
k
 HMzHE   H]E A   Hp HMHE   H]E A   Hp HMHE   H]E A   Hp HMvLOL+ILHUH
j
 藸HMݫHMӫHMɫHGH+HA   I;IFEI;LGHHL$@f A^$HMt{LA%Tq @ HcIQfAn\(T(Y\f.zuAf/AGfnYHL$@\HI;r(HHL$@4  HL$@d CHCk
 HHH5k
 H;&k
 r
   HHL$8HtWHHHHMH3 ($   ($   H   A_A^A]A\_^[]@USVWAVAWHl$H   HE)$   H	 H3HEIIHL
L
 eH%X      LE3B
9Xk
 ~^H
Ok
 Z =Ck
 uIHj
    L=j
 D=j
 EGHYn H
j
 5H
 q H
j
  HE   L}E A   H'n HMLHUH
Gj
 oHMhHE   L}E A   Hm HMLHUH
j
 ΢  HM$HE   L}E A   Hm HMnWf/woHE   L}E A   H+ HM:HE   L}E A   H HMHEHD$ LMLHUH
Wi
 lHMxHE   L}E A   H+m HMHE   L}E A   Hm HMHE   L}E A   Hm HMtHMHMHMuHEHEH}b ^HfnH\Y(YY2b (\Y\uIHM3  IHMH3 ($   H   A_A^_^[]@USVWATAUAVAWHl$H   HD$8)$   H	 H3HEIMLL
I
 eH%X      L3B9d
 ~^H
d
 6 =d
 uIHe
    H=e
 @=e
 DGHk H
ve
 H
 M H
d
  ID$I+$H  H~   WHE   H}E A   Hbk HMMHUd  HM*HE   H}E A   H5k HMtMHUH
d
 萟  HMHE   H}E A   H	k HM0LHUH
d
 HM袥HE   H}E A   Hj HMHE   H}E A   Hj HMHE   H}E A   Hj HMHFHD$(H|$0MD$M+$ILD$ HT$(HL$0HHDHD$ L;HBHLMHUH
c
 臱LLHUH
c
   HM跤HM譤HM裤IHL$@Mt$M+4$I   L;LFHVL;LFHMHHH]H9Nv3H
o_ @ fff     Hc(^HH;NrMtcI$^ fD  HcHIfAnE \Y(YY\YHD$@\HI;r(IHL$@-  HtLEL+IHHL$@ CHc
 HHHc
 H;c
 r
    HHL$ HtWHI?IHMH3 ($   H   A_A^A]A\_^[]HUSVWATAUAVAWHhH(  HD$8)p)xHF	 H3HEMMLH
YE
 eH%X      L3B9{e
 ~^H
re
  =fe
 uIH-d
    H=d
 @=d
 DGHg H
c
 H
  H
 e
 C IGI+H  IFI+H  WHE   H}E A   Hg HMlMHUH
}c
 ؗ  HMޡHE   H}E A   Hig HM(MHUH
9c
   HM蚡HE   H}E A   H=g HMMHUw  HM]HE   H}E A   Hg HMHE   H}E A   Hf HMHE   H}E A   Hf HMYH|$0MFM+ILD$ IWI+HHT$(HD$ LL$(I;ICHLMHUH
.b
 ILMHUH
b
 3HMyHMoHMeIHL$Ht$hHD$hHD$pLl$xM'I_I+HM>IFI+HH;HFظ   H;HFIE @=#[ ^ (Htt%zZ ff     HcAI\PY(Y\(Y\(YHD$HX(Y\HL$pXHH;r(HHL$@'  HL$Hڶ CH_
 HHH_
 H;_
 r
   HHL$0HtWHH>HHMH3n ($  ($   H(  A_A^A]A\_^[]LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHNHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHH^HH|$`HHH0_^[H\$Ht$WH Ii/  HHX f@  Ht4HH3HC   Hs@3Hs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aqh  IB  H1H;>u=IP I  H$   HD$(LAII,h  I  H;uAH^HK I诛  H$   HD$(LE3IIg  I  IP Ir   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK ItCHCIIπx H$   HD$(tLE3(g  I   LAg  I   IHO 衚   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS I1t=HGIIπx H$   HD$(tLE3bf  I6LARf  I&H$   HD$ MHT$8I i  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I.,  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3HHs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Ai  IB  H1H;>u=IP I蕘  H$   HD$(LAIIi  I  H;uAH^HK IO  H$   HD$(LE3IIVi  I  IP I   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I藗tCHCIIπx H$   HD$(tLE3h  I   LAh  I   IHO A   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS Iіt=HGIIπx H$   HD$(tLE3g  I6LAg  I&H$   HD$ MHT$8Ipj  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HHH H|$`H HH\$XH0A^_^@WH0HD$ H\$XH4(  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@WH0HD$ H\$XH'  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSHG HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     ~HH0[HUVWHhH   HEHX)pH 	 H3HE'I(EM
5
 eH%X   A   H3A9Q
 ~^H
Q
  =Q
 uIHrS
    H=cS
 @=LS
 DG
H H
:S
 H
>  H
qQ
  HE   H}E A   H HMFuH      HEH#H;upHE   H}E A   H
 HMHE   H}E A   H HMHEHD$ LMLEHUH
pR
 KUHEHrPHHMH=   r<t~ HAH;rn H+Hs^ H'vQ H HE   H}E A   H HM:uHHEH#H;vpHE   H}E A   H HMHE   H}E A   H HMHEHD$ LMLEHUH
dQ
 ?THEHrPHHMH=   r<tr HAH;rb H+HsR H'vE H HE   H}E A   H HM.LEHUH
P
 HM蟏HE   H}E A   HR HMLEHUH
P
 DHMZHr
  YEXHM'H3 H$   ($   H   _^]HHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(DT A\D)xD)hD)XD)H(D)8ATD   f/  L   WDH D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXYpI ^A(\AY(Y\ fE/(vWS (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y5MG A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"HP Ht
HuHH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@	 H   MMH
C?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"H Ht
HRtHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@ H   MMHAL|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HEZ(H   A] (YH   Xf/wXfA/sQH   (AT W>P f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
+
 I   LNB	9I
   HII9H3H-G
 HLL%G
 HL=G
 H;1HLH0  HEHDL   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
G
 s =G
 H
E
 ~H
F
  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-D)@HD< Ip     D)HI   D
: D)PD: D)XEWD)d$@D%; D)l$0D-BG D)t$ D5: )pغ   H  W4   H*AYff        Hc  WHH*X(AYH5rԺ   H7  WH*LcXEFLcAYB@
 BY@
 f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zBp*
 B@
 fA/Bp*
 (\\YXr*((B\@
 Y\YYX\(((B\@
 Y\YYX\fD/&fD/w(YAYAW f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=: H  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLLZ I^WD$(Ht3 HfLHD$(L|$(H\$03HcI;^}UI4Hg>
 HHHY>
 H;J>
 r
   HH$   Ht
(>HILD$(H$   IM ;  H$   HCH$   HI~I;|$t!I$ HtH2fI$I4$I|$H      ?HCH=<
 H
<
 H9
<
 t	H<
  HH+<
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|I1 # L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH 3H$   HH$   HH$   H/{ H$   HLCL+H$   o{ A   E3H$   HL$0 HD$0HcHHD$0HȺ    HD$0HcHdHHD$0HcHHDP   HHL$0W HHcQDuHL$0 u2HL$0  H$    HL$0 H$    2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H@  HD$(H;wH
H\$ H;vHH+HH=   HH*  H\$@Ht$HH0_@SH HHHSH
 H3H
HJHHC 3HC HC(HC0H~ C8HH{ HCHH [@SH0HD$     
	  HH0[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$Xi  HL$8(Ï 3($   H   [HIH% H% H\$WH Hc t
h   H HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    H7
 LHH7
 H
7
 H;rHLH7
 H
7
 HHH7
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH6
 HH0H6
 H;6
 r
0   <HH\$`Ht!(HHx HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    H/6
 LHH"6
 H;6
 rHqLH6
 HHH5
 H;5
 rHIHH5
 3LCIHI+HHt2f     I HIHLCI@I+ HH;rH5
 3H9S~-L3ff     JH9HIHcH;C|Hb5
 HH0HT5
 H;E5
 r
0   衼HH\$`Ht!(H9H
w HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHH4
 LHH4
 H4
 H;r   LH4
 Hp4
 HHHj4
 H;r
   軻HHKHIHHH
A4
 HH0H
34
 H;
$4
 r
0   耻HH\$PHt%(HHu HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfo8 (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   W8 II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %7 ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PHo HA@H~ HAPD$P   OHs HHOH HHG@HcPHw HD:@HG@HcPDBDD:<HSHHD豢HH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHk HAPH} HA`D$P   H HHO(H HHGPHcPHy HD:PHGPHcPDBDD:LHS(HHDHH\$HHt$XH0_H\$WH HH HHQ3HHHKHB? H~ HHCHGHC H\$0HG 3HG0HG8HG@Hn GHHHs HG(HH _H\$WH HHH;Qt>H	i HtH]  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   E LHtHHHtHHIHHtHHIH [HL$H() LD$0HT$8pzT	4 f/A+ wU_) LD$0HT$8HzT3 f/+ wAO) LD$0HT$8 zT3 f/* w-H(H H
$ x  H H
 x  H H
 x  LVWATAWHh  H`	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  
8E3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XA	AX
	AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ _6L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3i Hh  A_A\_^HWH   H@HXHhHpIIHIPHHd3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`H3Hl$PH\$HH+HH;ntH Ht
HQHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;v H    H=   r<t HAH;r H+HsԀ H'vǀ H6 HHtmHD$XH+HH;v H    H=   r<t{ HCH;rk H+Hs[ H'vN HH躤 HL$`HtiHD$pH+HH;v  H    H=   r<t HAH;r H+Hs H'v HF L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHt3K~ HOHHkHsC  IH!t  HH\$`Hl$hH0A^_^@USVWATAWH$H  HY	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  =+ WD9# f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HE  HE H  IH B<L;~  HH+HNHfo" T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
l" foLu@MH  EhL  E   M  E  fo
#" f      t  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&u  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfoU IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   賴  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  ? LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3莑 H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     n  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  HN	 H3HExMH  HHEH  HHEHE   HE    E 8 uE3IIB<  uHHM趕HE0   HE(    E ; uE3I IB< uHHMzHEP   HEH    E8 A   Hx  HM8O3@      H}H;   H+H   HHuH}HCuHH   LǺ%   Hfp HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHMRH)IE3HUHM8A   Hl HM8蟗IHMXl  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H6o HH    :- uC:" uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8迗HE8H}PHCE8H
w HL$03HL$8HL$@HD$HD$PHT$8HL$H/n Ho HD$0HT$0HMk  HHL$`Gl  H		 HL$`L @WH@  HD$(H$P  HHD$     HL$@>e   HL$0l LD$PMcHHL$PIHPHL$Pol HHL$@jcH$   cH$   l HH$P  H@  _Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v( W   fD.z  f.zv  D)T$ Dn fA/L  D
 fA/r4Dz ff     AX(y fA/XsD(E\=	 eH%X      HЋ9
   X5 A(AYAY((Y	
 (Y	
 Y
Y

 Xa	
 Xa	
 X
1

 YYYX-	
 X-	
 X
	
 AYYYX 	
 X
	
 X(Y	
 AYX	
 YX	
 YXX
	
 ^YY5 X  D fD/v(E E(\D(AX	 eH%X    f/ƹ   HЋ   9
 h  A(A(AYAY((Yu
 (Yr
 Y

 XJ
 XJ
 X
Z
 YYYX
 X
 X
&
 AYYYX
 X

 X(Y
 X
 YX
 AYX^YY%% X   9.
 )  EYDWK A(AY((Y
 (Y
 Y

 X
 X
 X

 YYYX
 X

 AYYX(Y
 X
]
 XU
 Xe
 YXI
 AYX^AYDY
&
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
f
 ɉ =Z
 ( H
F
 (
{ D
 (M V
  V
 ( 
(
 (
 )
 ( )

 (
 )
 )

 ވ UH

 - =
 (] H

 (
 
 (1 
 
 
 (# 

 (
e 

 F 

 (
 

 

 @ H

 菈 =
 (/ H

 (
 
 ( 
 ( 
~
 (
 p
   
Q
 (
 r
 
[
 貇 IHHh  HD$X)p)x((Wf.zu( Y
   f.z  f.
{ z0u.(W= ^((^YY5
 (L  f/
A
 rT= (^.  (f  HYSDJ

 JP
 ȃw_Hܭ H(+g     (~h     ((^     (i     (     (j     Ho HD$03HD$8HD$@H{ HD$HD$PHT$8HL$Hf H[ HD$0HT$0H$   k  H
 HH(H
 HH0@8B  HH$   -  HHL$`?  H HL$` ($P  ($@  Hh  Ðͬ ڬ     HUVATAUAVAWHxHX  Li3ILLDM  	 
 HXH      ?HxI)p)x= D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E     IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C螓  H;}&f        HE(f)HH;|LHMHd  LM@L  HH  HM`* MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL   转  MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@f  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMH!  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  x~  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH        @   @   H
X HHxHHH\$PH0_HT$WH0HD$ H\$PHHH        @   @   H
O HHxHHH\$PH0_@USVWAVHl$H   HE)$   H9	 H3HEIHHD	 eH%X      NE3B	9	
 ~^H
	
 } =	
 uIH
    L5
 D5
 EFH H

 yH
T 赂 H
I	
 | HE   LuE A   H{ HM:LHUH
k
 ?HMEHE   LuE A   HG HMLHUH
'
 ?  HMhEHE   LuE A   H HM貀; oHE   LuE A   Hw HM膀HE   LuE A   H0 HM_HEHD$ LMLHUH

 >WHMDHE   LuE A   H HMHE   LuE A   Hp HMHE   LuE A   Ha HMHMFDHM<DHM2Dfn5B ^ϲ fn\Y	 WX\YYv \(HMH33y ($   Hİ   A^_^[]HUVWAVAWHhH   HEHX )p)xH6	 H3HEMLHD	 eH%X      N3B	9
 ~]H
z
 z =n
 uHHA
    H2
 
 DCH) H

 u~H
Q  H
)
 y HGH+H  WHE   H]E A   H HM"~LHUH

   HMBHE   H]E A   H HM}MHUH
_
 ;  HMPBHE   H]E A   H HM}Af/woHE   H]E A   HY HMh}HE   H]E A   H HMA}HEHD$ LMMHUH

 MHUH

 wHMAHE   H]E A   H HM|HE   H]E A   H HM|HE   H]E A   H HM|LOL+ILHUH

 MHM@HM@HM@H7HGH+H   H;HFH;HGA= ^` (HtOfAn		 %i f     (X(\Hc\TY\HH;r(WHMH3u L$   I[HA(sA({IA_A^_^]HUSVWAVHhH   HE)p)xHM3	 H3HEIHHDb	 eH%X      NE3B	9
 ~^H

 v =
 uIH%
    L5
 D5
 EFH H

 zH
N | H
L
 Kv HE   LuE A   H HMzLHUH

 8HM?HE   LuE A   H HMUzLHUH
V
 q8  HM>HE   LuE A   H HMzWf/woHE   LuE A   H΋ HMyHE   LuE A   H HMyHEHD$ LMLHUH
 
 %HM>HE   LuE A   H
 HMeyHE   LuE A   H
 HM>yHE   LuE A   H
 HMyHM=HM=HM=5 ^* fn\Y
 	 X\YY \(HMH3r ($   ($   H   A^_^[]HUVWATAUAVAWHhH   HEHX )p)xHD0	 H3HEMHHULHL$8D
P	 eH%X      N3B9	 ~^H
	 s =	 uIHD	    H=5	 @=	 DGH H
	 wH
J y H
;	 :s IFI+H  I|$   WHE   H}E A   H1 HMhwMHUH
	 1  HM;HE   H}E A   H HM$wLHUH
U	 @5  HM;HE   H}E A   H HMvMHUH
	 2HMR;HE   H}E A   H HMvHE   H}E A   H HMuvHE   H}E A   Hw HMNvID$HD$0H|$ MFM+ILD$(HT$0HL$ HHDHD$(L;HBHLMHUH
=	 8GLMHUH
'	 bs  HMh:HM^:HMT:I^I+H   H;HFIT$H;HFH\$(HM5IT$HM4HLmL}I9|$vOM4$IM+= Hc(A^B+A舨 HH[I;t$rLmH\$(Lt$8HteMHEfnIII+U	 % D  HcA\YY(X(\1Y\HHH;rMtLEM+II iMtLEM+IIi(WHMH3cn L$   I[XA(sA({IA_A^A]A\_^]HUSVWATAVAWHhH   HE)p)xH	,	 H3HEMLHD	 eH%X      N3B	90	 ~^H
'	 o =	 uIH	    H=	 @=	 DGH H
z	 sH
F t H
	 o HFH+H  IFI+H  WHE   H}E A   Hz HM1sLHUH
	 -  HM7HE   H}E A   HF HMrMHUH
	 ٖ  HM_7HE   H}E A   H HMrA$f/woHE   H}E A   Hg HMvrHE   H}E A   H  HMOrHEHD$ LMMHUH
	 HM6HE   H}E A   H HMqHE   H}E A   Hh HMqHE   H}E A   HY HMqH}IVI+HHT$0HNH+HHL$8HD$0LD$8H;ICHLLHUH
F	 BLMHUH
0	 BHM5HM5HM5L>H^I+HI6IFH+HH;HFظ   H;HFA$= ^- (HtD/	  HcA\Y(X(\YY\HH;r(WHMH3wj ($   ($   H   A_A^A\_^[]@SH HALHH$I$IHH;r6H|$0H|$XHO@^HO 4H}q H
> I H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMt uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK IZ/t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN V0Hm I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@HO /Hl H
n  E H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtJ uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I*t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN +HNh I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	A Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@xIVHOKg  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ H5 H+H= H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/L L+L
 L+A:tA:	uHr:IuL| L+L
 L+    B:tB:	uHr@-tH      <U @-tH       A D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;tpHIHKH;tH6 Ht
HHL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMQ  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]foE UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHM3    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5d      HG(Hx tL   LHH%a  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H	 H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vkHHE HHuxL4    I   w2IFHHH;wHHH襂 H+HD$`HHHE 1I1 HE HuMt3kHILuXE3L9?LDL  Lx  H  H    H=     I;vjHGHEHu`H    H   w2HCHHH;wHHH H+HD$`HHHEH0 HEHuHtoj3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX= 5 MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  IHUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  HHHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  L  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} HHHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t)    t	I( H  H3F H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    Hc( HuHuH\$ H(aa@SH Hb  Hs HCPH [HL$SH0HD$ HD$P    EtH6 HA@H3 HAPD$P   J   H HHa HCHC@HcHHV HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH0 HHQ3HHBHK& H( HH{3HHDH^H\$HH& HHOHKHtHPHGHCHGHCG C H HH  HHH\$PHt$XH0_@SH H  H HCPH [HL$SH0HD$ HD$P    EtH
 HA@H HAPD$P   J   H  HH HCHC@HcHH~ HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH. HHQ3HHBHK<% H}& HH{3HHDH^H\$HH% HHOHKHtHPHGHCHGHCG C H HH HHH\$PHt$XH0_HIH%]% H\$WH Hl  H} HGPt
X   HJ HH\$0H _@WH0HD$ H\$@HH HHF$ HAHI HtHP tHC     Hx- HHK$ @t
@   HJ HH\$@H0_H\$WH H  H HGPt
X   HI HH\$0H _@WH0HD$ H\$@HH` HH# HAHI HtHP tHC     H, HHK# @t
@   HHI HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJHHHFHGHHFLL+tz H_H\$HHNHHHFHCHVHFLL+tfz HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$LWH   ICI[H: H3HD$xIHI HWf/w}IC   IC    D$8 A   HW IKEHD$p   HD$h    D$X A   HW HL$XEHD$8HD$ LL$XLHH
	 *HL$xH3? H$   HĀ   _@UVWH   HD$8H$   HU H3H$   IHH3IIHH+HH   II      @      D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HV HL$@DHD$x   HD$p    D$` A   H`V HL$`DHD$@HD$(HD$`HD$ LLHHX  H$   H3G> H$   HĐ   _^]HWH   H@HXHp H H3H$   IH3IIHH+HH   II      H@D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HcU HL$@CHD$x   HD$p    D$` A   H,U HL$`ZCHD$@HD$(HD$`HD$ LLHH
	 PY  H$   H3= L$   I[Is(I_@UVWH   HD$8H$   H H3H$   IHH3IIHH+HH   I      fD  H@D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HST HL$@IBHD$x   HD$p    D$` A   HS HL$`BHD$@HD$(HD$`HD$ LLHHX  H$   H3; H$   HĐ   _^]@SVWH   HD$8H H3H$   IHHfAn D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   HWS HL$@MAHD$x   HD$p    D$` A   HR HL$`AHD$@HD$ LL$`LHH H$   H3: HĐ   _^[3HIHtH   H LH   ICAC    HQH ICH ICAC   IKKH HD$(H HD$@HD$hHcHH{
 HDhHD$hHcHDd    H HL$(L @SH0HD$ HٹX   <= HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPH HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     H# HHKH0[H% @SH0HD$ HH7 HH] HAHI HtHP tHC     H# HHKH0[H% LH   ICAC    HQH ICH ICAC   IKH HD$(H  HD$@HD$hHcHH HDhHD$hHcHDd    Hv HL$(J @SH0HD$ HٹX   L; HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HH HHE HAHA@HcPH: HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     H" HHKH0[H%
 @SH0HD$ HH HHm HAHI HtHP tHC     H! HHKH0[H% HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A    H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH H[ HHt
   : HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PHk HA@Hh HAPD$P   H? HHOHq	 HHG@HcPH HD:@HG@HcPDBDD:<HSHHD/HH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H
 HAPD$P   H_ HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHD.HH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vLHHMHHumJ    H   w2HCHHH;wHHHc H+HL$`HHHM*H HHEHuHt*LH3H9HDHEXH   L   J    H=      M;vKLnMu_J    H   w.HCHHH;wHHHb H+Ll$`IIH LHuHtKHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`H3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIL  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMX H   H3u- H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3 HSHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xe?  HIHD$hHD$p   INIHD$xH$    D$0HT$ LL$hLD$xIV跿  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v% HA    (|$@D(L$ H`[F HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    v A   m A   A((T T f/vOA^)t$P5 (YXTd fE/
i vW^3YWs(t$PJD^A(AYXc d fD/! vW
Ĳ ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H, H3HE8H HHEL= HLEHE   E3LuDuD80uE
IIF84 uHHM/HE0   Lu(E A   H HM/IH}H;   H+H   HHuH}HCuHH   LǺ%   H
 HH    : uC: uC: uAtH+HHHsHEH}HCEH+Ht+HD$    L
[* A   HHM*H(IE3HUHMt3A   HS HM2A? tI@ IC<7 uMIHM1HEH}0HCEH
* HL$03HL$8HL$@HD$HD$PHT$8HL$H	 H
 HD$0HT$0HM  HHL$`?  H HL$`: @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH		 Mt
IHL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH	 Mt
IRHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ vLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8s  (fo IHCHMEHEUHMHME0H]MH} E H}(M@fo
ҭ fEPU`Mp;Xf/CvCHIH;HC m  H$0  HL$H  HADc$L$@  H   A_A]^[]5@/@@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4Cؑ  H;}. HD$8HHD$ (HD$ )HH;|LHL$PH蕑  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1H"HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@   HL$0  LD$PMcHHL$PIHPHL$PO HHL$@JH$   lH$    HH$P  H@  _@SH HHHSH
a H3H
HJHH 3HC HC(HC0H C8HH- HCHH [@SH0HD$     JQ  HH0[@SH HHHSH
 H3H
HJHHs 3HC HC(HC0H. C8HH HCHH [@SH0HD$     
P  HH0[H(((T
 f/
Ǥ v6f/
ݦ rWf/    H(X \$ H(' f/v(H((Y((Y%d (Y
Q (Y~ X%ƣ Y^ X
 Xޣ YXʣ YX%& YX
 YYY\\\% Xv YY-z ^X(H(H8 H
 73Lw(DIDAf     A.
 f/sffA;uDA 
 f/sffA;uDAHkAHAR 
 HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DY A(V D
d (E(A(Y= A(»   EY(D(T
 f/
(    A(AYV (A(Y%E YXf;vM-@ (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_HeD H
2 QHHXWH   )pA)xfD)@(D)H(D)PD(D  fD)X   D(D)`DYD((DYYE^Y` DW
 eU Y= L$   L$   3D(DY(DY פ((T
Z f/
    Y WA^(Xf;v.ffnYA(EY\AYXf;rDY A(T Yx L$   I[(|$pE(CE(KE(SE([E(cYA(sI_HB H
1 H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
 EYW=N (A\AYYٟ S YWA(Y (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PYw L@D)XD(ۢ(D(T] f/    DY )|$`D)D$PDr A(A\EX(A(R E\Wf.EYD(DY zt1AYAYY= A^(R AYYJ D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxH@ H
/ H   eH%X   
	 )t$pWA   D)T$0D(HB9d	   fA/vDW? fD.zu^ (t$pD(T$0HĈ    fA/rfA(L$   AYH4	 H
U	 $   w  %	 (Y%Ԝ A(Ƞ	 AX\\
	 Y  D)\$ D fE/rz L$   A(H	 AYH
	 Y
 \$   /v  %_	 (Y%D A(h	 AX\\
	 Y(  %> E^)|$`A(D)D$PAYD)L$@f/   D((DY
	 Y	 DX
	 X	 DYYDX
b	 X	 DYYDX
@	 X	 DYYDX
	 X	 DYYDX
	 X|	 D^   	 (^D((DYfDXЗ	 DYDXfDYDX	 DYDXfDYDX
	 YfX	 YXfYX	 YXfYXD^f/   D((DYq	 Y	 DXX	 Xx	 DYYDX6	 XV	 DYYDX	 X4	 DYYDX	 X	 DYYDXМ	 X	 D^   	 ^D((DYfDX	 DYDXfDYDX	 DYDXfDYDX	 YfX~	 YXfYXs	 YXfYXD^A(N (A(M (A(N - (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
מ	 . =˞	 g( H
	 (
 	 (" 	 # 
	 (
U 	 (V 
	 (
 	 (
 
	 (
| )	 (^ )
	 (
 )	 ( )
	 (
t )-	 ( )
/	 (
H )1	 (Z )
3	 (
ܠ e	 ( 
g	 (
@ i	 (  
Ù	 (
 ř	 ( 
Ǚ	 (
 9	 ( 
;	 (
 =	 (N 
7	 (
0 9	 ɘ 
:	 
: "	 ʙ 
B	 
 	 ڙ 
ʞ	 
 	 5B	 
2	  rH   eH%X   
N	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D% B9	   fE.E(DTF zu	A(   fA/)|$prnA(L$   AYHe	 H
	 $   q  %`	 (Y% A(A(X=	 \AY\
d	 YY9  D)T$@D fE/rnA(L$   AYH9	 H
	 $   do  %	 (Y%y A(A(X	 \AY\
	 YY   E^)$   A(AY$   A(I (A(I (L$   H-	 H
V	 p  (L$   (AYHϔ	 XH
	 Yo  \YXA(I Y ($   D^AYD(T$@fE/vY=/ ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
	  =	 ( H
	 (
I 	 ([ ,	  

	 (
 	 ( 
0	 (
! 2	 (s 
4	 (
 ).	 ( )
0	 (
 )2	 (k )
4	 (
 )&	 ( )
(	 (
 )*	 ( )
,	 (
E 	 ( 
	 (
I 	 ( 
	 (
 	 ( 
 	 (
a Z	 (c 
\	 (
% ^	 ( 
 	 (
 	  
	 
 	 c 
	 
 	 k 
	 
ە 	 Dҍ	 Dш	 D%p	 DϏ	 D%	 
	 5 D$H   eH%X   
z	 )|$`=' A   HD)T$0D(B91	   WfA/	  fD.z(	  X fA/)t$pD)D$P  A(E(^b	 EYFF (A(fA/X(Y^%    A(A(Y	 Y	 Xv	 Xv	 AYAYXT	 XT	 AYAYX2	 X2	 AYAYX	 X	 AYAYX	 X	 ^   ֆ	 A^((YfXȆ	 YXfYX	 YXfYX	 YfX	 YXfYX|	 YXfYX^$	 A(Y \Ԕ	 AX\ߕ	 YYX   fA/   A(AY$   A(^ŗ	 nD (A((XL$   H	 H
?	 Y^-# ~j  %	 (Y%c A(g	 AX\\
	 YYX  D)\$ D~ fE/   A(AY$   A(^	 C (A(T(XL$   H	 H
W	 Y^-k h  %	 (Y% A(	 AX\\
	 YYX  E^D)L$@A(AYf/   D((DY
w	 Yg	 DX
^	 XN	 DYYDX
<	 X,	 DYYDX
	 X
	 DYYDX
	 X	 DYYDX
֎	 XƊ	 D^   	 (^D((DYfDX	 DYDXfDYDX	 DYDXfDYDXT	 YfXQ	 YXfYXF	 YXfYXD^f/   D((DYۋ	 YÇ	 DX	 X	 DYYDX	 X	 DYYDX~	 Xf	 DYYDX\	 XD	 DYYDX:	 X"	 D^   !	 ^D((DYfDX	 DYDXfDYDX	 DYDXfDYDX	 YfX	 YXfYX	 YXfYXD^A(@ (A([@ (A(y@ c (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
	  =	 R(n (
 0	 (i B	 ( ,	 (] 
	 (
 	 ( 
	 (
ӑ 	 4 
	 (
 	 (' 
`	 (
 	 ( 
	 (
= )	 ( 
 	 (
 )	 ( )
܍	 (
 )^	 (' )
	 (
) )b	 ( )
D	 (
 	 ( )
H	 (
 	 ( 
	 (
U Ά	 (7 
	 (
 b	 ( 
	 (
 f	 ( 
H	 (
 *	 b 
	 (
D $	  

	 
 5	  
5	 
 	 ݈ 

	 
͋ =	 =	 
	 
͋ H
&	 n 
	 ֎	  L$   H] H
 sH H
 D$HxeH%X   
p	 )t$`W)|$P(A   HD)T$ D^ B9	 >  f/~   f/D)D$@   (Y$   (^ɏ	 < (((XL$   H	 H
4	 Y^-X b  %ˋ	 D(Y% (l	 X\\
	 Y^DYDX^  D)L$0D
 fD/   (Y$   (^P	 ; ((X(XL$   H~	 H
}	 Y^- j_  %ڌ	 D(Y%ކ (	 X\\
ˋ	 Y^DYDX   D^A(AY$   (]; ((.; (L$   H	 H
1	 la  D(L$   (EYHɄ	 \H
&	 DY<a  XYD\(: Y D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
=	 @ =1	 (0 H
	 (
r +	 (T =	 e =	 ( 
	 (
Ȑ }	 ( 
{}	 (
 )5|	 ( 
}	 (
  )9|	 	 )
|	 (
s ;|	 ( )
|	 (
 )|	 ( )
|	 (
 )|	 (̒ )
|	 (
 ǀ	 (В 
	 (
b 3	 (D 
	 (
v 7	 ( 
	 (
 S	 ( 
5	 (
Ό 	 (0 
9	 (
" 	  
	 
$ 	 Ć 
4	 
 ,	 Ԇ 
4	 
D ԉ	 D|	 D{	 5	 Dq	 5	 D	 
	   xL$   H H
( nHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H)  HH   [A(f.- LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((Yށ Y
ց (\f/O vY H(((H(8  @SUVWH  HD$8H\ H3H$  IIHHM;H@  HL$@H HL$P;HHk HH ;HH: ;HH ~;HH o;H$  HL$@H$  H$  HC$  HǄ$X     3H$P  $@  8uDI     IB8uH$@  jHǄ$x     H$p  Ƅ$`   A   H H$`  3HGHD$0H$@  HD$ L$`  LD$0HHdH$  H3  Hĸ  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
 < HMBLM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHM#LMHELEHtHHLMLEHEHHEHHcI;N}!H
  H
  WEHE    LMLEIIUSHMH   HEH+HH?H;v H    H=   r<ts HAH;rc H+HsS H'vF H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;r H+Hs H'v H4  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	~ Ht
H蹪HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@YGH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHHm6  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHH 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3 HHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM>  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HM7  L;}:@      HMHEBEffYfBXB)IL;|LHHM6  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIK%H$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLG[C  HL$h HL$p L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH  HC   HkH{rHH  HH#H H H;t%    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AIK  AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  (0w I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@USVWATAUAVAWH$hH  HD$@H< H3H   MIHLL   H  HD$8E3D|$0Hl HD$PHM= D$0   E3E3HT$XHL$P HD$PHcHHM HDPHD$PHcHDxDDLAWHL$XHHL$PW(HH $HIV HH #HU`HL$PHBD$0HU`H}xHCU`HEX   L}PD}@D8:tI    IB<: uMHM@
HD$8HD$ MLD$0HU@I{r@USVWATAUAVAWH$hH  HD$@H H3H   MMHLL   H  HD$83ۉ\$0H HD$PHM D$0   E3E3HT$XHL$Px HD$PHcHH HDPHD$PHcHDxDDLSHL$X8HHL$P&HH "HIV> HH o"HU`HL$PaHU`H}xHCU`HEX   H]P]@8t
HHÀ< uLHM@I$JHT$0HD$8HD$ MLD$0HU@ILD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H
  H HCPH [HL$SH0HD$ HD$P    EtH֦ HA@Hӵ HAPD$P   J   H+ HH HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHKL Hݥ HH{3HHDH^H\$HH% HHOHKHtHPHGHCHGHCG C H2 HH HHH\$PHt$XH0_@SH HHHSH
 H3H
HJHH H4 HHH [H\$WH H\  H] HGPt
X   Hg  HH\$0H _@WH0HD$ H\$@HHp HH& HAHI HtHP tHC     HX HHKc @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$@UVWH   HD$8H$   HՓ H3H$   IHH3IIHH+HH   I      fD  D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HW HL$@MHD$x   HD$p    D$` A   H HL$`HD$@HD$(HD$`HD$ LLHHH$   H3  H$   HĐ   _^]HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HHϨ HHM HAHI HtHP tHC     H HHKH0[H% LH   ICAC    HQH˚ ICHȩ ICAC   IK;H HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H.H HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HH_ HH% HAHA@HcPH HD
@HA@HcPDBDD
<H
 HHñ HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HH HH] HAHI HtHP tHC     H HHKH0[H% DD$HL$WH0HD$ H\$HHt$XHH3t$PH˘ HA@Hȧ HAPD$P   OH HHOHѥ HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H HHOH1 HHG@HcPH' HD:@HG@HcPDBDD:<HSHHD!HH\$HHt$XH0_@WH0HD$ H\$@HH HHv HAHI HtHP tHC     H HHK @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH˖ HA@Hȥ HAPD$P   ?H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upH H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3g HHH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HMAwI_ HSHH;v9HHumH    H=   w9H   HHH;w
HHH9 H+HL$@HH$L<    I> HHuMtHCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
Iˬ HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
L f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CH;}D$`HD$Hf)HH;|LHL$ Hs	  (YX f/ArWX AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
 H3H
HJHHs 3HC HC(HC0H C8HH HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
AL D)PD(D)XD(DYD)`E(D)l$ D((DYYE^YvN  Y=K L$   L$   3D(DY(DYK N((T
xV f/
M    YK Hۥ    K WA^(Y5sK X    AYHDXA\EYAY(YXHuDYM A( YxJ L$   A({E(CE(KE(SE([E(cD(l$ YA(sIH H
 ̚HHXHpWH   )pH5)x3D)@WD)HD(D)PD(EY{
D)XD(DxJ DYDYL ff     A(Y3
 AX(AY Y3`
 H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
Ѯ H3H
HJHHc 3HC HC(HC0Hƚ C8HH
 HCHH [%XK (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-
D)@HDE Ip     D)HI   D
E D)PDG D)XD)d$PEWD)l$@E(D-H D)t$0D5(R D)|$ D=E )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcBP
 XY5 F YP
 f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/z`"
 P
 B`"
 BP
 (\YX(\\Y\fD/v\(YX\fD/w(AW f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5> MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  H HCPH [HL$SH0HD$ HD$P    EtH} HA@H HAPD$P   J   H HH1 HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK, H% HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C HJ HH HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE31H~ H|$HHS H+`HS8HOwHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3衹H~ H|$HHS HwHS8HOvHH\$PHt$XH0_H\$WH H,  H] HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfoB TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %A II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   @ ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQHx ICH ICAC   IKH̬ HD$(Hpz HD$@HD$hHcHH; HDhHD$hHcHDd    H" HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH HHy HAHA@HcPH~ HD
@HA@HcPDBDD
<Hu HH HAHI HtHP tHC     H% HHKH0[H%* H\$Hl$VHA3> HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PHu HA@H HAPD$P   oHOx HHOH HHG@HcPHߩ HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH;u HA@H8 HAPD$P   H HHOHv HHG@HcPH{ HD:@HG@HcPDBDD:<HSHHDQHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H"i H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;v3HHMHHumJ    H   w2HCHHH;wHHH/ H+HL$`HHHM*H8 HHEHuHtH3H9HDHEXH   L   J    H=      M;vuLnMu_J    H   w.HCHHH;wHHH~ H+Ll$`IIH LHuHtHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`Hw:3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpI;HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   1>HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H@     t
HMX, H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  Hd H3HExMH[c HHEHuc HHEHE   HE    E 8 uE3IIB<  uHHMfHE0   HE(    E ; uE3I IB< uHHM*HEP   HEH    E8 A   Hc HM83@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHMH)IE3HUHM8赯A   H HM8OIHMXsLuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H HH    :
 uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM輥IIE3HUHM8oHE8H}PHCE8H
b HL$03HL$8HL$@HD$HD$PHT$8HL$H߄ Hpl HD$0HT$0HM%HHL$`wHX HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[A( f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^AC' f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A& f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0H/] H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHH H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	IR HM H3.  H]`HuhH}p(u0He@A_A^]H HHXHO菹艹HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3 HPHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$ } L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3P} HNHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMkM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$ { L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D%D! HxEW@      IL$LkM4$Hfo! HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D=j HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  (6 C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;trHIHt3m H?HLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  HH H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   L   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;v IHU`HtLmH4    H   w.HFHHH;wIHH H+Ll$`II*H'k LHuHt譤HU`IHuX3HIDH   H  H  H    H=     M;v]HUhHtL_J    H   w.HCHHH;wIHHa H+Ld$`II Hnj LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   I3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   ILEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   UHIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
I:h    tH   #h HM`h HMhh H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKwLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH&4HL$@g HL$HL$   I[Is A(sI_H%f H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	5d Ht
Hp5HHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;tc Ht
H5HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"Hb Ht
H3HH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^覛DD$HL$WH0HD$ H\$HHt$XHH3t$PHI HA@HX HAPD$P   H| HHOHJ HHG@HcPH_O HD:@HG@HcPDBDD:<HSHHD1|HH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     A薣 AfYD HH;|Ld$PH;}3IGHp HhIL0 ` YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"HN Ht
HHH    H|$0HsH\$8H ^ LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0Hs H3HE MLHAp AY1LIIM;vpH9HHuzJ    H=   w2J   HHH;wHHHՇ H+H|$0HH8J    H6 HHuHt`pHIHFE3EL96LDL}HEH    H=   @@uIM0I;vpMM(MufH    H=   w2H   HHH;wHHH H+LL$0II$H    H6 LHuHtoIE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
I5 @t	I5 HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;tlIIHOH;tH2 Ht
H9HH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}fo UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HM1    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$85b    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht30 HHD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%n0 @UHPHl$ HE H]@HuHH}PH2 H3HE HHLBHL;viL
MumJ    H=   w9J   HHH;w
HHH襀 H+LL$ II$J<    H/ LHuHt0iHC3H9;IDH    H=   LFHHN1   t	Hk/ HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5 MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDX(YLXA(YD
XX

A(YL
YDXA(YL
X(YDXXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+A((YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YX(YLXA(AYD XXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;t\HtHtIHHH;t[LLMt#3W" ILHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;t|[HII;t$I! HtHHEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHM/[HMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM  HM  HM  H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$Iq  HtHIE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CHNI;} D$XHEf)HI;|LHL$ INIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CLI;}D$XHEf)HI;|LHL$ ILMIIII+L;  L@MtHHIL;  IMIH/HWE3LL9G~L
 L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]yS@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH  @ L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   fo f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G3H;}%ff     EHD$@f)HH;|MHL$XHE3HEPLM LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI   LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5 )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4GF-H;}EHEf)HH;|MHL$PH- L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;tz/HHHt3 HHHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3 H>HD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3Z HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$ N L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%HS Ht
H莿HL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfo> IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI Hfo IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMI~ 8    RL   L   IH!   H  A_A^[]#LWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK#H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLCqHL$hM HL$pB L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	H H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHHu8 H+HL$@HH	H HHH  AVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+HcAH+2HcAH+HcAH+HcAH+HPHcAH+2HcAH+tHcAH+H H?'HSHcAH+YHcAH+HPԴHcAH+HcAH+SHcAH+HHcAH+HP鴿H'HcAH+HcHcAH+HcAH+HcAH+HcAH+HP|PHSHcAH+T H[XH(WHcAH+`H7PH4H?HcAH+0YHcAH+H` WH(HcAH+HPĻH({6HcAH+RHcAH+HP\HcAH+HPlWHSHcAH+$ HcAH+HcAH+|H(sVH('H;HcAH+|HcAH+HP<%HcAH+HPHþHVH(6HWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtHg HHXHg H [%^ %P %B %4 %& % %
 % % % % % %> %0 ff     H;
 uHfuHS  H\$Ht$WH E3H
f   m  H
  HH   H H H HH H HH HHtnHtiHtdH%f  H
  H
f H@ @   ?+HH3HH3H=f Hf H
O   ^  H\$03Ht$8H _E3E33AQ H;f Hu     ̹   {  H(H
e  H
f Ht H(@SH HH
e > # H
e v H [   @SH HH
e  H H
qe ok 3 eH%X   A   LЋ C H [h   @SH HH
$e  ; u4d      ;teH%X   
j A   Hȋ AH
d H [H% @SH H
d Hu0H H3d ?HH  H
d HH [Hl H
d H [H%a H\$Ht$WH 3H9=d u8H% H3|d ?HH>  DH,d H
Md Ӆ3H
d  H
8d E3 H
c ~ H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
c u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
b H(%  Nu#  H(H(3%  H(  @SH b ɻ   DÈb 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
b u
  t2zH
b a
  gHe I¹@   ?+ȰIL3LELEELEMa LELEELE
a Ma 
a H\$PH@]ù     HLMZ  f9uyHcHH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuH` H [@SH =`  tu(  !  H [@SH H HًH3g` ?HHu
H  HH
G`   3ɅHDHH [H(HH(]  @SH H HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@=:_  t
   r  $_    tg	  H
	  5	  H
>	  P	  H- H
 
  u)0t H H
 ]
  ^    @2@N	  HH8 t$H2tHH?  Lƺ   I^    H\$0Ht$8H|$HH A^H\$Ht$WH @|^ 3ۅ3Pȉj^ =@D$8=^ t
   K  J] o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9] 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH H IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH%1 @SH H3 H  HȺ	 H [H% HL$H8   	  t   )H
\    HD$8H] HD$8HH>] H] H\ HD$@H] [ 	 [    [       Hk H
[ H      Hk H
 HL    HkH
 HL H
u  H8@SVWH@H H   3E3HT$`H Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$  ǃ|H@_^[H\$UH$@H  ٹ     t)%D`  HM3A    HMA H   H  HE3/ Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 3 H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T    HD$PHD$@HEHD$H3 HL$@~ u
!@_ H$  H  ]@SH HHH
 HHS3H
HJHHl  H HHH [3HAH HAH HHH] HH  H\$WH H? HHH  t
   HHH\$0H _HHHL$ vHi HL$   HHHL$ ZHgc HL$   H\$H|$UHH e 33    D    cAMDDDAentiAineIAntelEDD] AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
 A%?D] = t(=` t!=p t wH     HsADO] Eu  ` rAD1]    UDM;|$3E]MU]	sAD\ Asn̭    ƭ    AsSAsL3H HHUHE$<u2     E  t n    l H\$83H|$@H ]̸   39\ H\$ UHH He H2-+  H
 H;uoHM HEHE H1Et HM H1E\ E HMH H3E H3EH3H  H#H3-+  H;HDH H\$HHH H ]H(uH=  u    H(H
[ H% H
[   H[ H[ H(HHH(H	| H\$Ht$WH H
 H5 H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _% %D % % % % % % % % % %@ %* %, % % % % % % % % % % 33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D%{ D)xEWY5p fA.zuT={ D\   D)$P  (T{ (T
{ D(f/D)$0  D)$  EYv
D(^^D((fE.Dp zuA('YAX()$ L   (H   AYfE.D($  z.u,fA/w	Dr (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0ȽL(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3@SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
~ H9Ht6H HH [<    HuH
 HB H	 HH [@SH0HAH      t-H
` LIC LH   H	_ u/HH0[H
 LH@LHC HD$ H	 H+u
HCHP03H0[E3H;
 AAH;
F H;
 AAuH% H\$WH HHHIH H;t6* u,LHT$0H HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _@SH H=2     HE D  C
HKt1{ t 0HSLCHMtE3  
HSH HKHHCHHt%] Huy H(H{ u3H [ÃH [H\$ UVWAVAWH   Hޢ H3H$  ILLL HH1  H_ H/Hu
HWHR0H  I HH   HHr H.Hu
HVHR0H+u
HSHR0H   HG    |H
z H? MMH	t tHG H;vBHl$0L? HD$(HL$@MLt$      E3HT$@3 x.HJtH
6 H? Hl$(MMHD$ H	 H/uHGH
H+u
HCHP03H$  H3mH$h  H   A_A^_^]@SH  HHuH [HH|$0 H+Hu
HSHR0HH|$0H [H(  H H3H$  A   D$    L HL$4AQ  LJ    LHL$0 D$08D$4u%D$28D$6u3H$  H3{H(  HD$0   HD$(LL$4Hh= L= HD$ HL$@ A   HT$@3. H$  H3H(  H(H} H
F7 H H H [ HuH7O H(HH
   HO HuH(3H(H(=5h     H
8  Hu13 H
V H: A   H	H y/H(H   g    HHtH(uH@P0H
N: 0 Ht$HK   HtH(uHPHR03H(1 3H(   H\$WH0H HH   Lj H7 HB    LM H7 H#    LH7 H xoLY H6 H xTLHD$     LH
k7    Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0HT H
 H6 A   H	 yH/u
HGHP03HH\$@H0_@SH HQHLAMtI 3Al AhHA@HAHHA HA(HA0HA8HD$PHtH HAXMtIHD$XLIPHtH HA` HH [H\$Hl$Ht$H|$ AVH0H
L IH5uX HH-V L5,U  HtHt$(MLHl$ HHH\$@Hl$HHt$PH|$XH0A^H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
Y Hj4 H	 H(HAXHHD H H(LHt4HB      t$HIPHIPPHt
H)uHAP03H(H
 H3 H	 H(HAPHHD! H @SH yh H   Hl$0Ht$8H|$@Lt$Hk HHhPHpXLp`3HGPHGXHG`9ChuHt3H  HHuV HtHX 
H(uH@P0MLHHHI  Lt$HH|$@Ht$8Hl$0H [@SH H H{8 t	H {h |H
 HI u Hl H$   HH [H% H [H\$WH H3HIHtH{H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _LI[WHP3HIC H8 ICA   ICHICHIC ICEAICICR u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0yl HHYHHt!H
 HY/ H	0 3H0_][Ht$PHt  HH t$xL I;t5HB    }      @t3H
  IHA tetaHH  H+u
HSHR0HOHHtHGH    H)uHAP0   3H  HHt$PH0_][P  GlHHCH;F u(HD$pHLL$hLD$`t$(HD$ H'  L   HK MtAn HH   H+u
HCHP0H
 H	 uHt$PGl3H0_][v HOHHtHGH    H)uHAP0Gl LD$hHHT$`j=  3H  HHu': H9XPuH
Ż E3E3HHHaD  HHt$PH0_][HT$pHHtf LL$hHLD$`HD$     0 H.Hu
HFHP0Gl H+u
HCHP0Hu7HL  HHu' H9hPuH
! E3E3HHHC  HHt$PH0_][H\$WH yl HHYHt$H
J H, H	j 3H\$8H _HtIHHHt$0  HOHHtHGH    H)uHQR0H+u
HCHP0Ht$0uH
 H	 3H-  Ht4H(u
HPHR0H
 HJ, H	ɻ 3H\$8H _ Ht*L HHx M H	  #7 H H\$8H H H _@SH HHIH{l tH
 HW+ H	. 3H [HtGClHAH;B uH; u
3    Cl Hu!HH [B  H HH [  H [H\$Hl$Ht$ AVH HTB 3HLH9BuHHH      AlHHBH.F H|$0L   MtA HHu%H
; H	b u	H Ǹ '3Hr H/Hu
HGHP0HDH|$0AFl HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIH{l tH
^ H) H	~ 3H [H   ClHAH;A u\H;ֺ u3H;{ HD >H; u3H;] HDӷ  H;J u   LHVE q2  Cl HuDHP   H  HHu' H9XPuH
 E3E3HHH?  HH [H\$WH 3HHIHHD$0HtHGHH)uHAP0$ HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu'ĸ H9XPuH
O E3E3HHH>  HH [H\$VH AhHHمu2Ht-H;ݷ t$H
D H' H	 3H\$8H ^Ãu"HtH
Ƶ H	 3H\$8H ^H|$0
 H{  HtSHC0HtHHHGHtH HGHAHC LGhHWpHOxHGhHC(HGpHC0HGxLC HS(HK0DH   HGhHC HGpHC(HGxHC0HC HtH HC(HtH HC0HtH LClHHSH|$0Cl H\$8H ^HtH
Ĵ H	H% H
 H& H	H%@ H
 HJ& H	H%  H\$WH HQ 3Hy(HY0HA HA(HA0HtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWAVAWHH HqP3HYXLHy`LHu0H]@H}HHAPHAXHA`HuGHtH/u
HGHP0H]@HtH+u
HCHP0HW H HM I  H^ L I;   HuH& H H H}HHu0jHKI;u	H[@H-      t<H{|	H[HHݴ H HӴ HM@H)uHAP0H}HHu0I@     H   HtH/u
HGHP0Hu0H.  HFH  HF    }      @t3H  IHw H}HH]@Hu0u%LLHI:  H\$XH A_A^_^]LEHHU@HM0 HE@HHH	 HH;t2 u(LMHILE@HU0:  H\$XH A_A^_^]HMHHt
H)uHAP0HM0H)uHAP0HE@HX@HHM@H)uHAP0I3H\$XH A_A^_^]H\$HHYhLYpLQxHAhI HApIHAxHH\$MMH\$Ht$WH HHHQHHs HHttL@A      u	HC" HG H9C t-H`" H
! LGH	$ H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
8 H	_ tͰ Hܰ xHWLH xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _~    uHH  uH\$0H _ø   H\$0H _LH;u   HA    }      @t3   H% E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
h AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL; AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H; ø   Htfff     H   H;tHu3H;f ø   H(HA      tiHQHHtVHtHHt0Hy H
 H H	P HH(H(H% AIHHH(ËAH(3H(H\$0HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,Hi H3H(ËAH(ËAH(H(H%o H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(>i >i >i ,i %i 6i >i >i >i H(HA      tEHAHHw,Hxj H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(j j j j j j j j j H(HA      tEHAHHw,H'Xk H3H(ËAH(ËAH(H(H% H\$0=HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(j j j j j j j j j H(HA      tEHAHHw,HG8l H3H(ËAH(ËAH(H(H%Ϫ H\$0]HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(k k k k k k k k k H(HA      tEHAHHw,Hgm H3H(ËAH(ËAH(H(H% H\$0}HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(þl l l l l l l l l H(HA      tTHQHHtAHt3HHyH
r H H	 H(H(H%_ AH(3H(H\$0HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,HǑn H3H(ËAH(ËAH(H(H%O H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(^n ^n ^n Ln En Vn ^n ^n ^n H(N H(H(. H(H( H(H( H(H(Ψ H(H( H(H(f H(H(n H(Ht$WAVAWH L=c7 ALtx  tDADH\$@Hl$HEt8H-A0 Ht,.0 H  ; 0 }HHD9Du
H\ H,MDƋI   HHtntHЋ  Ƨ L5 E3HH HHtHȉp| HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH A_A^_H\$Hl$Ht$WH   HAIɋH HHtVtDL HH
 2 	H HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_H2 E3H
7 E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$       H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H=. HڋHuH    H  hHHH- - @   -    H\$@Hl$HH _Ht$0Dŋ5- HϋLt$83  LcD;}'IH9luHHH)   HAP0}j- ;u.p@HHcHw HHtX5E- 5;- H<- HcMI;~#HHHI+@ AHIAHuMƉ5, BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H=, Ht/, H9   ;, }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@UVWH H
2 ! 3HtH2 H* H   LD$HH\$@HT$PHL$X H
q2 H1 HAL   MtA HHt,H H= HE=
 H+uHCHP0HLD$HHT$PHL$X H\$@Hu%Lҡ Hc1 H
1 ޤ H _^]H EH _^]H\$WH HAHL   MtA0 HHu.H
ɡ H	 tH
 Hf
 LH	R HH\$0H _H\$Hl$VWAWH0333HLHu35 HH   HH
) Lt$Pl LHt~ HHtp.   H
  Ht<LD$    LII5 HHu7H
F H	 t#s LD$     LII HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^LI[IkVWAVH0HAP3ICIHAXMCICLHA`ISHi`HHiPIHiXIKIC) H9nP   HD$PHt(HL$(Hg    HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHVhLH~pHH^xIHNhLFpHFxHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP03QHL$ I.H/H+Ht
H)uHAP0HL$(Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIPLH;u   Hu3HB      2   HA    }      @t3BH%Ӡ H\$UH HjE3HH~HB H;|   IHL;|Ht$0H|$83H   HrfHH;   HC    }{      @toHX  Ht4L@3M~HH9tHHHI;|3H   H\$@H ]H     H   H;tHuH;8    	H۟ u'HHH;O3Ht$0H|$8H\$@H ]ø   H\$WH LQhHypHYxHQhLApLIxMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _HAhHHApI HAxIHHtH I HtH IHtH H\$WH   H3HH9HHDG<0 u#H$ H;HC8HC0H: HC@H{FDK$AtPH
כ H A   H	 H9;tH H9C@uH{@Hʝ H$   HĐ   _H$   HL$@  HS(HL$@  HtCH
 H;tbLCH HH¡ L
 HGIHD$0H H LOHL$(H
 H
 HD$ H	 7H9{@uH3 HC@3H$   HĐ   _3HHAH`# HA8HA0H HA@H9 tHӐ H9A@uHA@    H% H\$HT$UVWH HHL҂fHH}  AĀ 3A IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <9}4HÍv4p<0}H\$Hu,H
 H) DH	ܗ t*LpHcHG(H] H
Η H	 3H\$@H _^]H
 H AZ   H	 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]H cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]f X} 4  ~ b} p} p~ }} P~ ~ ~ @ %  







































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtH H
ݕ H	 3    t   LA       )   эB<       A<	  CDA0H<0|f<9}CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGH DHHH
Ӕ D@XH	    HGHcHLH
 MDH H	 gH
 H DH	c JH
r H DH	F 3+; uH& eHCGGHG(   IH H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
 LMH H	[ Ld$XH(A^[D8cGu+DAXH
 H
K H	* Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
T H% LH	) H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH LICHD$(IM HD$ GHuL
 L$ H L HL	AHDAP@  HD$(H; LT$ MH
l H	K H8H(DA@1wVL
xHAć A IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
 HK H	 2H( ^ y  W P e       H(DA@4wEHwH t H   H(ø   H(ø   H(ø   H(H
 H| H	 3H(. 8 B L V       H(DA@4wEHwHX D H   H(ø   H(ø   H(ø   H(H
K H H	# 3H(    &       H(DA@1wqL
HvHA\ A@ I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
O H H	' 3H(Љ ډ     "      H(DA@4   L
DuHA Ad I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
K H< H	k 3H(H
- H H	 3H(fԊ ފ     & D       Hs   L,tA  A IH H H H H H H H H H H ÅH
% H. HEÅH
( H9 HEÅH
; HL HEHP HX H` Hh HԘ Hh    
  *   :    W B l   "  2   	

DHU H
 H	H%ĉ @SH HDA@<	w<BHA؃0<0|<9}H[X<0}HtH [ÃHH H
c D H	> H [HDA@<	w7BHEA0<0|<9}GHE@F@<0}HAÃE3H LJL[ HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=p Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJH HHHL$ H
Ƈ H	͇ 3H8fD  H   H;tHuH; t   H8H\$Ht$WH LAHIxpHt[H tTH MtI	HLm HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
 H M@H	 H\$03Ht$8H _H(Hm H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H(z y,H(LH /   HHtH(uH@P03H(H\$WH HAIL   MtA HHt,HH5   HH+u
HCHP0HH\$0H _H\$0H _LI[IkIsI{ AVH0Hp 3LH9A   HiH   HYHCH;
 uISDGISIkH     H;G u=HKQ=   u*Hl$ Lt$(HA uH{E3HT$ HEA]    HHtMHE E3HhHIHLp H  H.Hu
HVHR0H+uHSHR0c  HH\$@HH|$XHl$HHt$PH0A^Ht$WH HA3H; HtVH;M u+H;QDƋAHDtJHDH Ht$8H _HHhHt.HAHt%HHt$8H _HH;W΋HuHHH\$0# HHtHHg H+Hu
HSHR0HH\$0Ht$8H _HGHt$8HH H _@SH HHu3H [H|$0 H+Hu
HSHR0HH|$0H [EH;uH H H HAH; uCLAIHH3H+HMtQ3ҋIEA;tHɂ H H H; uAfAnf.zuzA   H% H\$Ht$WH HB 3HH΋H9CH9G5  C u
H xG u H yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM @ƋH\$8Ht$@H _L I;uUI;@ƅuJA   HH HHHH+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HH t/HD$8HH      tJE3LD$8HT$HH] uLL$8MtLH
0 L! H H	) 3H [H
 L H H	 3H [ø   H [H\$Hl$Ht$ WH H3H
@ IHL;u3H;Lt$0HMHDߋ      Ht:H   MtH I9@tH
Y Hr H	 h  HHHH Ht(? HH`H;tHHp`Ht
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHI, t   IMMHC      tHHӹ    3~ HHtuE3HH H+Hu
HSHR0HtNLOHA      @H
~ H) LH	
~ Hy H
} H	9~ Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4IS}   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@%~ HLL$pH8G `<`uHH@Iy( uI} LL$pAA `<`uIAIA@H;u-HIH	} y} H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$ { q3H\$`H0A_A^_^]HY@%
} HLL$pHC `<`uH[H[@Iy( uI| LL$pAA @t
 tIAIA@H;u)HIH	| ؅y| HuqLL$pt@HI;H H
{ L$   H	{ H\$`H0A_A^_^]H{ H
z H L$   H	z H\$`H0A_A^_^]LLH
z H$ H	H%z HHLT$pH M;LT$0MLH
[z MML
 IML
- H H	LDIH& HDH HD$(L\$ z HHH\$Hl$Ht$H|$ ATAVAWH Hz HL`PLpXLx`3HEPHEXHE`MtI$MtIMtIMMIH      '| H{ HMPHHuXH}`LePLuXL}`Ht
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
y ey HZy H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAPHHAXI HA`I3HAPHAXHA`H\$WH LQPHyXHY`HQPLAXLI`MtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
+x HD A   H	w H(H(   H\$UH x HHXPH   H
Yv LI;tCHK    }      @t3HIH8z uH\$@H ]3Ht$0HuXH|$8H}`HE`HEPHEXH+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HHH} LL
 H
v H5 LDH	H%v H
v H A   H	H%v @SH H[u 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H  ËH [Lrv I;AuI;AuA   u HHu	H [HH|$0ЩH+u
HSHR0H|$0H [@SH I)v Huv Ht3H [HH H [@SH HHH
 s Ht	H H [HH [\  HH;}HH33H%u LL$8E3HMtIH%s HAH;-w u
E33)  H;zw uHA@t3/  H E3  HT$H(HAH;v uA   HT$8  H(H;w u>LAA@t
   H(Äy$MP t3HIE3HT$8EAAH(   H(H\$Ht$WH HH   (t HHuH\$0Ht$8H _HE3HHxH#  H+Hu
HSHR0H\$0HHt$8H _H\$Ht$WH HAH@ Hpt3HYu @ H Hu ;~#H
 s t3H\$0Ht$8H _HHH
u H؋   ~z<Ru H 9x }
u @$ Hu"s HuH
t H H	r Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Huut    t @ H Ht ;~H
b r t3lLHHH
t H   ~ZRt H 9X }
t @$ Hu"r HuH
s HT H	q HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyLLqHHY Ict @ DH Hs D;~H
 -q t3    uL CuFHu9wuLMIH   |u%Ht LCHcGI;uHSMH   UfHU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ p HH3s    ~YI s H 9X }
s @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHHp E3LHHL?r HHt\H~.Hx  fff     HHIH[H HCHAHu3Hq AF HH/u
HWHR0AN HH\$0Hl$8Ht$@H|$HH A^HA@ LPt3E3IHIE3ILHv H
wp H	H%n HB      tHAL   MtIH%^o H\$WH HH
 HHAL   MtA&o HHuH
o H LH	\n HH\$0H _H\$Ht$WH 3ȥy'Hu H     * _  [  3mn H> Hu'Hu H a     _     3H
t l H Hu'HHu H      _    3H
s o H Hu'Hu H_     k _    ɥy'Ht H/     ; _  l    H
Y $l H HuMHt H h     _  m H  H
pn H H	l m  H"l Hc Hu'H/t H      _    H0 H
 H hk H Hu'Hs H>     J _  {  H
N (k H Hu'Hs H |    
 _  ;  LF H H
 l y'H_s H 6     _      y'H/s H      _    95 tFLp H H
r 4l y'Hr H:     F _  w  j HHu'Hr H      `  B  Hm Hdi HuBL H H k y'HUr H ,     `    h  y'H%r H~      	`      y'Hq HN     Z `    HR H-i y'Hq H  E    `  P  H
 H< LH5R j y'Hqq H H E    `    H HL Hh y'H/q H     `    H
 H LH5L 9j y'Hp H?    K `  |  Hw Hr Hh y'Hp H { f   	 `  :  Hu H\ HH5r g y'H[p H 2 i    `  
  H HR HH5[ g y'Hp Hk    w `  
  HS HB HH5R <g y'Ho H"    . !`  _
  A`  H5B H5 H6 H
 芝H Hu'Ho H F 	    +`  
  A`   H^ H
' >H Hu'H+o H|      ,`    AH
  H H
 H Hu'Hn H0     < -`  m  A0  HJ H
 覜Ho Hu'Hn H b     .`  !  AP   Hn H
; ZH Hu'HGn H      /`    A   H H
 H_ Hu'Hm HL  u  X 0`    6y'Hm H     ( 5`  Y  g  u'Hm H i #    ?`  (  H
 3HHu'HUm H , &    H`  
  H LH
L >d y &    J`  
  H+u
HCHP0H
 3HHu'Hl H-  '   9 T`  j
  Hu LH
 c yw '    V`  
  H+u
HCHP0H
i 3HHu'HSl H * (    ``  	  H, LH
J <c y (    b`  	  H+u
HCHP0H
x 3	HHu'Hk H+  *   7 l`  h	  H LH
 b yu *    n`  	  H+u
HCHP0H
_ 3HHu'HQk H ( ,    x`    H LH
H :b y ,    z`    H+u
HCHP0H
 3HHu'Hj H)  -   5 `  f  H	 LH
 a ys -    `    H+u
HCHP0   a HHu'HRj H ) .    `    H3 HH HKH" HH H HKH HAH
G HHu'H
i H
<  .   H `  T  H+u
HCHP0H HLHHu'Hi H l .    `    Hv LH
 ~` y8 .    `    H+u
HCHP0H HʿHHu'Hi Hl  .   x `    H LH
 _ y .   D `  B  H+u
HCHP0H/u
HGHP0   ` HHu'Hh H \ /    `    H HH HOH HHc H HOHU HAH H HOH HAH H HOH HAHp H HOHb HA H
 HHu'Hg H$  /   0 `  L  H/u
HGHP0H H4HHub /    `    H LH
 t^ y. /    `    H/u
HGHP0H@ HHHu /   | `  z  H LH
  ^ y /   H `  F  H/u
HGHP0H HLHHuz /    `    H LH
 ] yF /    `    H/u
HGHP0H HؼHHu /    `    H LH
& ] y 0   ` `  ^  H/u
HGHP0H< HdHHu /     `    H LH
 \ y^ 0    `    H/u
HGHP0H+u
HCHP0H
 SHHu'H,e H  2    `    H@HH L   MtA] HHu 2   K `  I  H+u
HCHP0HW E3HHHu'Hd H l 2    `    H/u
HGHP0HV LH
| Hk[ y% 2    `    H+u
HCHP0L H
g 3] HHu'Hc HR  o  ^ `    Hj LH
 Z y o  * `  (  H+u
HCHP0LF H
C 3/] HHu'Hpc H G r   `    H LH
g YZ y r   `     H+u
HCHP0Z HHu'Hb HP     \ a     L HH Y y2 a  )H LH
 Y     a  e    Hvb H H+u
HCHP0HtH/u
HGHP0H
 HH95[ tD H
+ 3H
 H)uHQR0H5 HH\$0Ht$8H _H+u
HCHP0HW H\$0Ht$8H _H(y! w_  .   >Z H_ Hu x_    k Z H Hu y_      Y H Hu z_      Y H Hu} {_      Y Hk HuT |_  d3
Z H Hu4 }_  D   Y H Hu ~_  !   Y H5 Hu* _  Hg` H >    H(3H(H   H    Y H Hu |   a^     H    Y H Hu ~  H l^    H    Y HJ Hu    w^    H}    RY H HuL    ^  [  H~    Y Hd Hu    ^  $  H    X H
 Hu 3  l ^    H    X H Hu 5  5 ^    H
W LHV Hf Huo f   ^  ~  H
IW LHU H Hu7 f   ^  F  H    X H7 Hu  p   ^    H    L
 L H HD$(H HD$ W H Hu y  1 ^    H    rW H# Hul 3   ^  {  Hf    ;W H Hu5 5   ^  D  H/    W H Hu C   ^  
  H    V Hn Hu-H\ H;     G ^  HĘ   H    V H Hu-H\ H n     ^  HĘ   H    7V H` Hu-HT\ H #    	_  HĘ   H    U H- Hu-H	\ HZ  7  f _  HĘ   H    U H Hu-H[ H  ;   _  HĘ   H    VU Ho Hu-Hs[ H B O   *_  HĘ   H^    U H\ Hu-H([ Hy     5_  HĘ   H    T HA Hu-HZ H.    : @_  HĘ   H    uT H~ Hu-HZ H a    I_  HĘ   H    *T H Hu$ 2    T_  3  H6    S H$ HHu o  x __    H E3Hz HT$pD$ho  HD$`Hi HD$XHe HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    P Hh HuY o   b_  h  H    L
 LX H! H$   Hz HD$xH. HD$pHr HD$hH HD$`H: HD$XH HD$PH HD$HH> HD$@H2 HD$8H HD$0H HD$(H HD$ {R H HHu
 k_     H& E3H HT$pD$hr  HD$`EAH HD$XH HD$PHD$HHL$@HD$8HD$0HT$(3D$    JJO H[ Hu- n_   r  HW HL HĘ   3HĘ   H(H
m `H Hu*HW H |    
 I^  H(H
[ H Hu*HcW H : |   J^  H(H
 H] Hu*H!W Hz  W   K^  H(H
 H Hu*HV H8  _  D L^  H(H
 XH Hu*HV H t =   M^  H(H
 Ho Hu@     N^  ZH
 H Hu 7   O^  ,H
' H Hu*   r P^  HU HD H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HN HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
@ t=H Hc
" H3HHCHCLCH    K HH [3IA0  HHuH [@SH HL HHIHCHL H Ht
H)uHAP0HL HKHCHL H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H}L HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtHP H
 H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
v H3HHCHCLCH   I HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HJ HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
t t=HS Hc
V H3HHCHCLCH   pG HH [3IA0  HHuH [@SH HCI HHIHCH1I H Ht
H)uHAP0HI HKHCHI H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HH HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
R Hz  @ǅtHP H
, H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   `E HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _HF H HIhH)uHAP0HF HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _H_F H HI`H)uHAP0HDF HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _HE H HIXH)uHAP0HE HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _HE H HIPH)uHAP0HE HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _HD H HIHH)uHAP0HdD HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _HC H HI@H)uHAP0HC HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _H?C H HI8H)uHAP0H$C HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _HB H HI0H)uHAP0HB HC03H\$0H _HA0H HA0@SH HHt
H [O  H!B H HI(H)uHAP0HB HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _HA H HI H)uHAP0HtA HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _H@ H HIH)uHAP0H@ HC3H\$0H _HAH HA[{  H\$WH HHA HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H@ HHIHCH? H Ht
H)uHAP0H? HK HC H? H Ht
H)uHAP0H? HK(HC(H? H Ht
H)uHAP0H? HK0HC0Hp? H Ht
H)uHAP0HT? HK8HC8HE? H Ht
H)uHAP0H)? HK@HC@H? H Ht
H)uHAP0H> HKHHCHH> H Ht
H)uHAP0H> HKPHCPH> H Ht
H)uHAP0H> HKXHCXH> H Ht
H)uHAP0H}> HK`HC`Hn> H Ht
H)uHAP0HR> HKhHChHC> H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu;   HH|$H.= LD$0HT$8HL$@; HH{HtH  H0^LD$0HT$8HL$@H; HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  H= E3H 8  HH	  H: LHCHH: HH H: HC H: H H: HC(H: H H: HC0H: H H: HC8H: H Hy: HC@Hn: H Hd: HCHHY: H HO: HCPHD: H H:: HCXH/: H H%: HC`H: H H: HChH: H -{ y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [L H9 H HI`H)uHAP0Hv9 HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H8 H HIXH)uHAP0H8 HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H_8 H HIPH)uHAP0HD8 HCP3H\$0H _HAPH HAPH(Ht	H(N H
5 H H	7 H(H(AH7 Hu;H> H&  X   2     H
^ AX   胏3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H7 H HI@H)uHAP0H7 HC@3H\$0H _HA@H HA@@SH HHt
H [P H6 H HI8H)uHAP0H6 HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H6 H HI0H)uHAP0H5 HC03H\$0H _HA0H HA0H(Ht	H(Q H
g3 H H	O5 H(H(A(95 Hu;H}< H T T    z  z  H
Z AT   33H(@SH HHt
H [HS H4 H HI H)uHAP0H4 HC 3H [HA H HA @SH HHt
H [hT H4 H HIH)uHAP0Hf4 HC3H [HAH HAH(Ht	H(U H
1 H H	3 H(U H(Ht	H(V H
1 HX H	3 H(H(IL$03 Hu;H: H  P    
  
  H
U AP   a3H(H\$WH HH3 HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H2 HHIHCH2 H Ht
H)uHAP0H2 HK HC H2 H Ht
H)uHAP0Hj2 HK0HC0H[2 H Ht
H)uHAP0H?2 HK8HC8H02 H Ht
H)uHAP0H2 HK@HC@H2 H Ht
H)uHAP0H1 HKPHCPH1 H Ht
H)uHAP0H1 HKXHCXH1 H Ht
H)uHAP0H1 HK`HC`H1 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu. @  HH|$H0 LD$0HT$8HL$@!/ HH{hHtH5  HQLD$0HT$8HL$@H / HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  Ho1 E3H 8  HHuH(H. HAH. H H. HA H. H H. HA0H. H H. HA8H. H Hw. HA@Hl. H Hb. HAPHW. H HM. HAXHB. H H8. HA`H-. H HH(H\$Hl$Ht$WAVAWH L3, HHu'H5 H_ ݽ =   k `X     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHH+ u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_ gX  
 eX  H04 Hy  =   H/u
HGHP0HtH+u
HSHR0D˼ H
d V 蹄3tH\$Hl$VWAVH L3#+ HHu'H3 H c =    ,X     In3I+.HHtafIL$H`- HHtiHGH9G ~HHOHHHHOHH]* u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^Y 3X  
M 1X  H2 H  =   H/u
HGHP0HtH+u
HSHR0Dq H
r}  _3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H;( tgH;* t^IHe* HHu/H1 H A/   D W  ' H]_  H@L   MuSW    HLL Mu8H\( H9GuL;w1  HGJL;w  J\HIHAHHG  ILHt
H)uHQR0HHM]  HHEH;t?HUHtLEL+I-HH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPHJ) Hu`HUHMHHMHUHLEL+I,% % % % % A0   W  fd) H   H
& LI;   HH    }      @t3HwIH* uZW  A/   H]H/ Hη DO  HtH/uHGHP0D-  H
`| &{& H/u
HGHP0HUIH]MtIm uIEIP0HtlHEH+HH;v$ H    H=   r<t$ HCH;r$ H+Hs$ H'v$ HHHH]H   HUHHMH+H*HHHH?HH
H;v#$ HRHH=   r<t$ HCH;r# H+Hs# H'v# HHFHIL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;-$ toH;l% tfIH% LHu/H&- Ho A/   D KW  w Hu  H@H   HEPHuMW  Hu  HLHHMPH]HuHu8H# I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HzEHu% HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHM^L}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHM*^L}H]HuHt;HH]HEP7A0   xW  H}@H?   H
aS  H
SS } 6$ H   H
! LI;   HH    }      @t3HqIHq% udhW  H}@H?A/   HM* H D  MtI.uIFIP0D  H
v z8C! I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@tf HFH;rV H+HsF H'v9 HHCHH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH; twH;  tnIH	! HHu3Hz( Hð A/   D> V  ˩ H]L}9  H@H   HEHuV  H]L}  HLHHMH]L}Hu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  HAHE   HE    E HHMEHEHrDHHMH=   r0  HAH;  H+H  H'  H0AJ  H  HE   3H}@}IE3HUHM@HEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHMqhLuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHMgLuH]L}Ht*HC   H{H{rHHHU  HCH H]HMHE        H
cM  H
UM  A0   	W  H}c' HH   H L I;   HA    }      @t	3k	Ie uZV  H}A/   HK$ H D  HtH.uHFHP0D  H
.p t2A H.u
HFHP0HUH}H9LuH]L}MtIm uIEIP0HM=MtHIM+IMI.HHMH3k6H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H; 8  H< HHu     V    H@L   HEo    HAHHt[HEo   HAHHtEHAHnyH
K" H
  V  UH+9  HCHP0*  H+u
HCHP03pu	HMoSH! H= S V      HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   H| H
 H	 2Mx-H  L
c' ILDHw H
 H	x      pV    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+Id Ht V  eHHMQ  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I- Ht@ V      H  HX D٨ k H
\l p   HUHMHHUHMHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I,HUHtLEL+IHUHtLEL+IWELmHUHtLEL+I,MtI/u
IGIP0MtI.uIFIP0HUHtLEL+IA,HUHtLEL+IwIH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H; toH;< tfIH LHu/H H? A/   D U  G Hu  H@H   HEPHuU  Hu  HLHHMPH]HuHu8Hk I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H!lEHu HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMOL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMNL}H]HuHt;HH]HEP7A0   V  H}@H?   H
1D [ H
#D M  H   H
f LI;   HH    }      @t3HbIHA udV  H}@H?A/   H Hf D y MtI.uIFIP0Dţ W H
e k8 I.u
IFIP0HUH}@H[L}HuH?MtIm uIEIP0HthL+IL;vS J    H=   r=@t6 HFH;r& H+Hs H'v	 HHu4HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H;K 8  H HHu"     U    H@L   HEo    HAHHt[HEo   HAHHtEHAHyH
 H
4 J U  UH+9  HCHP0*  H+u
HCHP03u	HMoH Hݠ  U  Q    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hs H
m H	L 2Mx-H L
 ILDHn H
9 H	     , U    H;u
Hz HrHrH~H6HHE3LLHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I$ Ht U  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+IM$G Ht@0 U      H H Dy  H
<b gg   HUHM%HHUHMHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I|#HUHtLEL+Ic#HUHtLEL+IJ#WELmHUHtLEL+I%#MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I"HUHtLEL+I"IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH; toH; tfIH%
 LHu/H Hߜ A/   DZ U   Hu  H@H   HEPHu
U  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H\HHEHHu.
 HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHMHL}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHMeHL}H]HuHtH;HH]HEP1A0   5U  H}@H   H
:  H
:   H   H
 	 LI;   HH    }      @t3HQYIH ud%U  H}@HA/   H H  D  MtI.uIFIP0D_  H
[ Mb8 I.u
IFIP0HUH}@HL}HuHMtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hs H'v HH+HH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH; toH;6 tfIH HHu/H H9 A/   D T  A Lu  H@H   HEPHuT  Lu  HLHHMP= H]LuHu8H\ H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0H+ H9GuwuHH (EHf.zub HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHM+DL}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHMCL}H]LuHt3HH]HEPA0   T  H}@H   H
5 (  H
5    H   H
3 LI;   HH    }      @t3HTIH udT  H}@HA/   H H3 D F HtH.uHFHP0D $ H
U ]8 H.u
HFHP0HUH}@HL}LuHMtIm uIEIP0MthM+IL;v  J    H=   r=At IFI;r L+Is I'v LIB&HH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is H H3HD$hHHIK3t$ HA   HqHyrHH@0D$    HJH H;t-= u#LD$(HT$0H x,HT$0LD$(LGLD$(MtHW(H Hu>H
 H@     L \T  \T  A   H
2V [   HD$`   Ht$XD$H HL$H#HT$HHHD$`HrQHHL$HH=   r<tP  HAH;r@  H+Hs0  H'v#  H$HHL$hH3L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3] HHu'H	 H  =   + #T     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH  u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_s *T  
g (T  H H9  =   H/u
HGHP0HtH+u
HSHR0D H
S  yY3tH(HyHQrH	 Hu;Hd H + 2    S  S  H
-R A2   
Y3H(H\$Hl$Ht$H|$ AVH L3k HHu'H H-  =   9 R     In3I+.HHtgff     I:  HHtqHGH9G ~HHOHHHHOHH u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^ S  
 S  H HY ׏ =   H/u
HGHP0HtH+u
HSHR0D H
O 6 W3r@SUVWAUAVAWH 3H\$`H\$hH\$p LLxhLppHhxMtIMtIHtHE H   H9 H     Q  H/ IMPL I;tUH  I@      t
I*`*HA9   }      @t	39M	I     D H
I  }VLL$pILD$hHT$`]yX    Q  [H E3H
 FHHu Q  'E33H}H+u
HCHP0 Q     H
 H\$`Ht$hH|$pHL LMIIS`HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D} H
I  kUH A_A^A]_^][MtI/u
IGIP0MtI.u
IFIP0HtHm u
HEHP0H A_A^A]_^][@SH H HH HIhH)uHAP0H HCh3H [@SH H HH HIhH)uHAP0H HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH H HH HI`H)uHAP0H HC`3H [@SH Hc HH HI`H)uHAP0HE HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH Hc HH HIXH)uHAP0HE HCX3H [@SH H# HH HIXH)uHAP0H HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H# HH HIPH)uHAP0H HCP3H [@SH H HH HIPH)uHAP0H HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH H HH HIHH)uHAP0H HCH3H [@SH H HH HIHH)uHAP0H HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH H HH HI@H)uHAP0H HC@3H [@SH Hc HH HI@H)uHAP0HE HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH Hc HH HI8H)uHAP0HE HC83H [@SH H# HH HI8H)uHAP0H HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH H# HH HI0H)uHAP0H HC03H [@SH H HH HI0H)uHAP0H HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH H HH HI(H)uHAP0H HC(3H [@SH H HH HI(H)uHAP0H HC(3H [H\$WH LJHL;
 HtrH;L tiH
 L9 MIH@ H	 HI H     z E  E  H
@ A  IH\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH HS HH HI H)uHAP0H5 HC 3H [@SH H HH HI H)uHAP0H HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH H HH HIH)uHAP0H HC3H [@SH H HH HIH)uHAP0H HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HA@SVWAVAWH`H H3HD$PH=n~ LLHH
| 33 HHtH H_HH$   HHuw fD    H 3H9Au%HYHtHyHHH)uHAP0   HGH;6 uHIGHT$(HD$(DEHHH+H\$ Lt$0|HH   v wD  
  H;E    HOQ=   uwIGLT$@HD$@DEHL+H\$8Lt$HHA t3HOE3IHHuv D     H  H+  HCHP0   M< HHuH
] H
| u D  VHtHX3IGE3HH IGHDEIHLtzHHu~u D  H HT| | l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0D| H
e: u zD3#H.u
HVHR0H/u
HWHR0HH$   HL$PH3NH`A_A^_^[H\$WH0L
w E3H; HHRHA3I;At   KMuH
/ HP H	 +HBL2 H
 HP MIHD$ H	
 3u/H
 H
z |{ k  
t JD  3H\$@H0_HHH\$@H0_`HUATAUAVAWHhH   HEHXHpHx H& H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI薚HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUߎLEHUL+I3 HHu'Hl Hy Cz h  r D  -  IM;<       HEH;tIE3HHMTH IE3HUHM<HE   H}E IE3HUHMHQ HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pq D  
q D  HW 5y h  Hx H.u
HFHP0HtH/u
HGHP03D y q H
c6 @LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v H	HE   H}E HE'HrPHHMH=   r<tO HAH;r? H+Hs/ H'v" H	HE'   H}E MtzIIQM+IHL;v II   r=At IFI;r L+Is I'v LI	IHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI6HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUϊLEHUL+I3 HHu'H\ Hu 3v c  n C  -  IM;<       HEH;tIE3HHMDH IE3HUHM,HE   H}E IE3HUHMHA HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pm C  
m C  HG %u c  Ht H.u
HFHP0HtH/u
HGHP03Dt m H
1 <LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v| HHE   H}E HE'HrPHHMH=   r<t? HAH;r/ H+Hs H'v HHE'   H}E MtzIIAM+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3sL$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHI脊HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`HL$hH+L$XHHHLI?LHT$XHT$(HL$@ HL$@6Hu;Hb Hq 9r _  j `C  `C  A_  H
. :HH|$@Ht2HT$HHLHL$PH+HHHLI?LH8H|$(Ht1HT$0HHL$8H+HHHLI?LHHL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHIHL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`7HL$hH+L$XHHHLI?LHT$XHT$(HL$@PHL$@膲Hu;H Hp p Z  i C  C  AZ  H
m, h8HH|$@Ht2HT$HH蜂HL$PH+HHHLI?LHH|$(Ht1HT$0H`HL$8H+HHHLI?LHLHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIFHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU_LEHUL+I;3 HHu'H HEn n T  Qg B  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM# HHt[HNH9N ~H HFH<HAHFHH` u H/u
HGHP0I;ܿ    >pjf B  
^f B  H m T  H&m H.u
HFHP0HtH/u
HGHP03Dm f H
) n5LHH.uHFHP0HEHrPHHMH=   r<t9 HAH;r) H+Hs H'v H{HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIрM+IHL;v] II   r=AtC IFI;r3 L+Is# I'v LIIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI膂HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUOLEHUL+I+3s HHu'H H5j j O  Ac FB  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM
 HHt[HNH9N ~H HFH<HAHFHHP u H/u
HGHP0I;ܿ    >pZb PB  
Nb NB  H i O  Hi H.u
HFHP0HtH/u
HGHP03Dpi b H
$ ^1LHH.uHFHP0HEHrPHHMH=   r<t) HAH;r H+Hs	 H'v HkHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzII|M+IHL;vM II   r=At3 IFI;r# L+Is I'v LIrIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIVHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU?{LEHUL+I3c HHu'H H%f f J  1_ A  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMxH HD$(HM	 HHt[HNH9N ~H HFH<HAHFHH@ u H/u
HGHP0I;ܿ    >pJ^ A  
>^ A  H e J  He H.u
HFHP0HtH/u
HGHP03D`e ] H
 N-LHH.uHFHP0HEHrPHHMH=   r<t HAH;r	 H+Hs H'v H[HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIxM+IHL;v= II   r=At# IFI;r L+Is I'v LIbIHM/H3L$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHH   HEH$   HE3ELeWELeLeXAAELe3 LHu c C  [ CA  c  HFH; tLH;M tCIH HHut[ IA    H@L   MuUU[ KA    HMMMu8H H9FuL;v  HFJL;v  J\HIHAHH   HMXH]XHt
H)uHQR0HCL   HLc HMtA9 HH   E3Ha H_HHtgH+u
HSHR0IIOI9O ~HIGH<HAIGHI uH/ HGHP0.Z sA  |"Z pA  pZ nA  a H   H
v LI;   HH    }      @t3HIHQ u}Y fA  IH) a C  Hx` I/u
IGIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Lu  
 H.u
HFHP0MIHM胮HMH;t$HH]HHHMHHHML L`L`H]HMHtHUtLEHUL+I| Ht$H2 H_ 	` D  X A  aHUHMpHUHMHHM@HIȉMP HuA_ F  FX A  H H_ H]D_ 'X H
 'LH]MtI.u
IFIP0HMXHtH)uHAP0HHttHUHsHEH+HH;v% HH=   r<t
 HCH;r H+Hs H'v HHLH]HtsHUHsHEH+HH;v HH=   r<t HCH;r H+Hsp H'vc HHIH$   HĀ   A_A^A]A\_^]H\$Hl$Ht$H|$ ATAVAWH`Hs_ LHIHE333EFIHHu'H H6] ] :  BV 5@    3H;- 3H;- 3H;-t uHJ ؅yb] :  U 7@    Hm u
HEHP0  H\ H L5\ HR^ IIFL   MtA HHu'H
 Hf\ \ =  rU L@    H LcI9$  HsH  HkHHHHE H)uHAP0HELeH;~ uFIG0HT$ A   HD$(HHt$ cZHH   M\ =  T _@    H;    HMQ=      IG0HD$8Ht$0HA t3HME3HT$0EAHHu[ =  iT g@  q  H.u
HFHP03H+u
I$HP0    HH   [ =  3T y@  0     U HHu'H
v H
Z M[ =  S m@    HpE3IG0HH3H IG0HG +XHHu	[ =  S s@    H/6HGHP0'IW0HUHHZ =  MS Y@  U  H
1X E3HHhWHHuZ =  S ~@    H+u
HCHP0E33HIH/u
HGHP0H] 3HY 2Z =  R @    H\ A   IOH-FHHu'H HoY Y >  {R @  !  Hf؅yY >  TR @  o  Hm u
HEHP0   IO(L I;uEH
G L HA H	 H HX XY >  Q @    H[ -SHHu'HF HX Y >  Q @  Q  3H;
 H(uH@P0b  HY H L5Y HZ IIFL   MtA HHu'H HX X @  %Q @    H LcI9$  H{H  HkHHHHE H)uHAP0HELeH;1 u8IG0HT$@A   HD$HHH|$@VHHuwP @    H;P    HMQ=      IG0HD$XH|$PHA t3HME3HT$PEAHHu4P @  2  H/u
HGHP03H+u
I$HP0   R HH   TW @  3O @  HY HV Hm    HEH        HHuO @     HxE3IG0HH3H IG0HF SHHudO @  eH.;HFHP0,IW0HQHH'O @  (H
T E3HHhSHHuNN @  [V @  Hl HU HtH+u
HCHP0HtaH.u[HFHP0OH+u
HCHP0E33HEH.u
HFHP0H H^U U @  jN @  HtH/u
HGHP0DU H
_ AN MtI.u
IVIR03
Ht H L\$`I[ Ik(Is0I{8IA_A^A\;HUATAUAVAWHhH   HEHXHpHx H& H3HE/HHMWEE3LeELeEAAELeELeHE'   LeDe3W LHu'H HT T 3  %M ?    Ls8IFH; t`H; tWHI	 LHuOT 3  L ?  Z  H@L   Mu]&T 3  L ?  1  IIܐMu8H I9FuI;^   IFH4I;^   ItHHIAHH   ILHt
H)uHQR0HFL   HT HMtA HH   E3HU HvPHH   H.u
HVHR03IOI9O ~HIGH<HAIGHI} u$H/HGHP0E3A   R 3  yK ?  E3  R 3  ]K ?  E3  R 3  AK ?  E3  ; HtfH
 LI;tQHH    }      @t3HIH~ uHR 3  J ?  E3M   E3I.u
IFIP0ML}IHM
HMH;t$HH]HHHMHHHML L`L`H]HMHtHU'fLEHUL+IM Ht'H HQ Q 4  J ?     HUHR@HM HMH;t$H8H}HHHMHHHML L`L`H}HMHt5HU}cHMH+MH*HHLI?LHUa Ht'H H`P P 4  lI ?  R  LEHUHM>D3V LHu'H HP P 5  $I ?    H]H;]  HEH;tIE3HHMH HMH}'HCMHU HH   ILHt
H)uHQR0HGL   HS HMtA LH   E3HBN HLHHtwI.u
IFIP0MIOI9O ~HIGH<HAIGHI uH/u
HGHP0H;]  gO 5  G ?  uQO 5  G ?  _G ?  FHZ HN !O 2   G S  S  A2   H
  MG ?  N 5  IH HPN I/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0HtH/u
HGHP0LuH]H}DvN G H
 dMLuH]H}MtI.u
IFIP0MtIm uIEIP0HE'HrPHHMH=   r<t HAH;r H+Hs H'v޺ HMHE'   LeE H   HUH_HMH+H*HHHH?HH
H;vy HRHH=   r=@t\ HGH;rL H+Hs< H'v/ HHHt~HUHiaHEH+HHH;v HH=   r<tٹ HCH;rɹ H+Hs H'v HHH]HtHUH`LEL+IHIHM/H3pL$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`HL HAL   MtAλ Hu;H HK K &  'D ?  ?  H
 A&  x3H({HAPH HAPHAPH HAPH\$WH0HIX35HHu?H H
 A   HPJ >  DJ ^C 3H\$@H0_HK H HHu\H A   >  HI D|J C H+uHCHP0D_J B H
R M3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHl$H   HEH$   LWEE3L}L}L}L}L}HEL}L}HEAEL}wH=L HH
G o HHtH H"JHHuPI   A =    HCL   HoD HMtA4 HHu
I   A =    H+u
HCHP0HFL   H)K HMtA޸ HHu'HϿ H(H H   4A =  p  H.u
HFHP0ILkH I9E z  HsHm  H{HHHHH)uHAP0LoIE H;. u;HuLeA   HUHFHHu{H   @ =    H;J uqHOQ=   u^HuLeHA IuHOE3EAHUHHuG   4@ =  M  H.u
HFHP0I      \ LHu'H
} H
F TG   ? =  	  HpII$L` E3IH8DHHuG   ? =    I.u8IFIP0,IHAHHuF   f? =    H+u
IE HP0HGH H;   H;    H7 HHu? =     H/u
HGHP0HFH   MHHMHtTA   HLHtAHHj=yF   > =    L)&u
HFHP0I   H.u
HFHP0In=uIR>E   V> >  o  HOHtf~A   HH H
! H	  
Hx>> =  H MfE   HD H/.  HGH  H;u
Lw H_H_LsHHIH/u
HGHP0H]LuHHM HHEH;tJHUHRHM(HMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHMHEH@HEH HEH@L}H}HIHM HHEH;tJHUHRHM^	HMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUHM   DBoHM\LMLEHUHMgHIcHHMgHUHtLEL+INH
F =LHu'H HC C   < ,>  L  H@L   HB IMtAf HHu'HW HB .C   ; .>    I.u
IFIP0HMLHu; 1>    ILcH I9$b  HsHU  H{HHHHH)uHAP0LgI$H; uJHuLuA   HUH@HHu; E>    H.  HFHP0  H; uOHOQ=   u<HuLuHA IuHOE3EAHUHHu: N>        ױ LHEwHu'H
 H
MA A   Y: U>     HpILp ME3IH>HHu&: [>  8Im    IEI   IHz<HH   9 >>  JA   H[ H@ HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0HMwHt
H)uHAP0D@ r9 H
C #I.u
IFIP0H+u
I$HP0LHMHt
H)uHAP0HMHtH)uHAP0LEMM HUwHM%   DBoHMïLEMM HUwHM   DBoHM虯HUHtLEL+IIH$   Hİ   A_A^A]A\_^]HSVWATAUAVAWH   H@HLW@E3LPD$hLt$xD$PLt$`AAEL`LXH;T tJHtEH(HD$0H$   u]HP H> '?   7 <    L$   L$   H17 H$   H$   L% L$   HH$   rHL$hH;t%HHL$hHHHL$pHHHL$xL0LpLpH$   HtL$   L+I" Ht'H H= _>   6 =  O  LD$hH$   IM
\HL$PH;t%HHL$PHHHL$XHHHL$`L0LpLpH$   HtL$   L+IHT$PH$   WL%@ IH
<  HHtH Ik>HHu'H H
= =   6 =  '  HCL   H< HMtAo HHu'H` H< 7=   5 =    H+u
HCHP0H$   HHu'H Hm< <   y5 =    ILnH I9E   H~H  LnHIE HIH)uHAP0IEH$h  H H;{ u[H|$@H\$HA   HT$@Id:LHu'Hm H; D<   4 2=    H/_  P  H;w ujIMQ=   uWH|$@H\$HHA IuIME3EAHT$@LHuH HD; ;   P4 ;=  ^      LHu'H
 H
; ;   4 B=  $  HxIHX E3IIp8LHu'Hi H: @;   3 H=     I/uoIGIcHH'6LHu'H  Hy: :   3 +=     H+u.HCHP0"HGHP0H+u
HCHP0L$h  H.u
IE HP0H$    \  H$   H
V H;IDH$   H$    +  E3AAAEHtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0MtI/u
IGIP0H=ʟ l HLxPL`XLh`LpPLpXLp`H$    t%H$   H;IDH$   H$   Y HKPHsXH{`L{PLcXLk`Ht
H)uHAP0HtH.u
HFHP0HtH/u
HGHP0DN9 1 H
A <MHT$PHtLD$`L+I辽HT$hHtLD$xL+I袽H$   HtL$   L+I耽IH   A_A^A]A\_^[H\$WH0LRHH00 HL;u   ^HuH
 H
 H	5 >It   -H
 L IBLJH{
 HD$ H	 3u/H
H H
7 8   0 <  3H\$@H0_HHH\$@H0_#HL$USVWATAUAVAWHl$H   HAE3HE7 LLmALmoAL   LmLmwMtA HHu'H H6 e7   / 	;    HCMH;x    LsM   L{HIIIH)uHAP0II2LHu6   / ;    I.u
IFIP0MH+u
HCHP0I/u
IGIP0ID$IH7 L   MtsAtH; uE33H41H;Ҩ uHC@t3H2H3 E3H`3LHk:6   . ;  %  = Hu'H1 H5 6   . &;    L=8 H
+4 IHE֣ HHtH I6HHu5 	  E. 2;    HCHH
4 L   MtA LHuq5 	  - 4;  \  H+u
HCHP03 HHu'HS H4 *5 	  - 7;  8  IL$(H;
 u0H
f H' H	 4 	  z- ;;    H6 Q HHu4 	  M- =;    H@IH; t_H; tVHM2 HHux4 	  - C;  c  H@L   Mu'O4 	  , E;  :  HH3DDH/uHGHP0fMu>H H9FuL;~   HFJ<HI)L;~   J|HIHAHHA  HMwH}wHt
H)uHAP0HB6 H HH   HKH9K ~H HCH<HAHCAHHǡ -U3 	  + k;  @  3H.u
HFHP0H] Mf3I9$A  IvH4  M~IHMIH)uHAP0IGMgH;ܤ   A   HuHUH]I0LHu{2 	  @+ ;  
  2 	  '+ i;  
  $ H7H HHtǠ P2 	  * a;  ;
  H.u
HFHP03H+u
HCHP0I.u
I$IP0H
 5 L}o/,LHG  H H]1 1 
  i* ;  
  H; u^IOQ=   uKHuH]HA t3IOE3HUEALH=t1 	  * ;  _     B HHuH1 	  ) ;  3  HpE3HHX I31.LHu'H* H0 1 	  ) ;    H/HGHHI+LH0 	  I) z;    H@IH/ L   MtA HHu'H H/ g0 
  ( ;  u  I.u
IFIP03 LHu'HI H/  0 
  ( ;  C  HMgHI(H;
 u>H
Y HB H	 H HS/ / 
  _( ;  
  H1 6 HHu'H H/ / 
  $( ;  
  H@H; t\H;Þ tSH HHuV/ 
  ' ;  A
  H@L   Mu'-/ 
  ' ;  
  HH3DDH+u
HCHP0Mu>H H9FuL;n  HFJHI)L;n   J\HIHAHH   HMwH]wHt
H)uHAP0H) Hq HHtOINI9N ~H IFHHAIFGHI 39. 
  & ;  $	  H; H- . 
  & ;   	   Ht H HH6   @ H.u
HFHP0H LgE3AI9$&  HwH  LHHIIH)uHAP0IGMgH;l    A   HuHULuIT+LHuNH] H, 4- 
  % ;  B  H6 H, 
- 
  % ;    H.u
HFHP0II.u
IFIP0H/u
I$HP0H
/ L}&HHf  H H, ,   %% <    H;ٞ ukIOQ=   uXHuLuHAI uIOE3HUEALH=HL H+ #, 
  $ ;  1      HHu'H Hk+ + 
  w$ <    HpE3Lp HIIM(LHu+ 
  :$ <    H+HCHIH&LHH H* X+ 
  # ;  f  H@HH. L   MtA< HHu'H- H* +   # <  '  H/u
HGHP0H LcII9$  H{H  L{HHIIH)uHAP0IGMgH; uFLuoHUA   LuIH}t(LH   ^*   M" 2<  F  H;    IOQ=      LuoLuH}HAI uIOE3HUEALHu)   Mx" :<    H/u
HGHP0IH+u
I$HP0I.IL}ouIFP0H D9(m  HM2 HH   H H( e)   ! X<       3 LHu9)   ! @<  $  HxE3HEoIIIH IF &LHu(   ! F<    I.u
IFIP0LuoLuoHI#LH(   M6! ,<    I8 Hu'H H' r(    ! Y<    H;t7H
 H	 H_ H' 6(     \<  Y  H
+ K"HHu'H$ H}' ' 
    h<    H@HH# L   MtAߗ LHuM  j<    H+u
HCHP0   5 HHu'H H& u' 
    m<    IMfH@IHML8HHCHHHo I9$  I~H  M~IHMIH)uHAP0IGMgH;    A   H}HUH]I$LHub <    H/u
HGHP0H+u
HCHP0I.u
I$IP0IMHMHt
H)uHAP0HMoHt
H)uHAP0HMHt
H)uHAP0MtIm u
IEIP0HEwHtH(u
HPHR0IHĸ   A_A^A]A\_^[]H;X uSIOQ=   u@H}H]HAI uIOE3HUEALHH <         HHu& <  |HxE3HHX II"LHu$H| H$ S% 
   <  dH.HFHHI6 LHe <  % 
  H Hp$ HtH+u
HCHP0MtI.u
IFIP0HtH/u
HGHP0HtH.u
HFHP0E3D$ H
# % HHPHHUH   H# 3HXHxL`DLhDLpDLxDHAH$   Hl$hHl$XL   Hl$xH$   H$@  Hl$PMtA H$  HHu'Hؚ H1# #   = 8  t  HGH;Œ H$H     HOH$H  H   HwHHHHH)uHAP0H$H  HUHHu'HN H" %#    9    H$H  H)uHAP0H$H  H/u
HGHP0H.Hu
HFHP03n HH   "   F 9    H; uE33H 1H; uHG@t3HH+ E3HpHH[He H! <"    9    H$0  HI(H;
 u0H
q H H	 !    9    H# \ HHu!   X 9  a  H@H; toH; tfHHD$`; H$H  Hu|!   
 9    H@H   HL$pHu3N!    !9    HLH$H  H\$`Hl$pH\$`LL$H  H/uHGHP0D  MuHH I9GuI;_  IGH<HHH\$`.I;_  I|HHH\$`IAHH  H$   LH$   Ht
H)uHAP0H
! HLH6  HHH6" H   IHtU HH  I/u
IGIP0H
 I LH  H
" )LHt  HHHR H   IHt H$@  LH   I.u
IFIP0H I LH  H MeHl$PI9$  MELD$PMn  MmH$@  I HL$@  IE H(uH@P0LD$PIEMeH; L$   uQL$   H$   A   L$   ILH  HD$PH(u
HPHR0Hl$P   H; uiIMQ=   uVL$   L$   HAH uIME3H$   EALH  HL$PH)uHAP0Hl$Py   . LH  HT$PE3HPILp HHl$PL'LH]  I,$uID$IP0L$   'IILH  I.u
IFIP0H$@  H)uI$P0    H$@  LH  H
 E3LxHLLh LHo  I.u
IFIP0H LcH$@  I9$h  LCL$@  MS  LsHI IIH)uHAP0L$@  IFMfH; uTL$   H$   A   L$   IHHH  H$@  H)uHAP0H$@     H; ueINQ=   uRL$   L$   HAH uINE3H$   EAHHu@    9  	      LH  H$@  E3Mo IIIGH$@  LHH  I/u1IGI%IHHH  Im u
IEIP0H+u
I$HP0HNHH9N ~HHFH<HAHFHHЉ :  H/H\$`Lt$pL$H  LHGHP0=HI/u
IGIP0H$8  LH$   袾G  H LHq    } 9  l
     d e9  j     K n9  Q     2 {9  ;     L u9    o    9     V    9    =    9    $    9        9        9       g 9  j     N ^9  T     L2 Q9  8     L N9    o   L L9     S    J9    :    G9    !   H E9     HH	 HH>tL    H` =9  ]  tH  H$0  HH(H;
 uAH
 H. H	E H LH r     9    HT ׺ HHu*H` LH 4    9        H$H  HHu 9  H  IE3H
 HLxHp HHua 9  H  H+u
HCHP0HFH; tZH; tQHI6 H$H  LHu 9  H  H@L   Mu& 9  H  HLH$H  LLH.u
HFHP0INHH$       Mu<H I9FuM;f
  HJ4HI(M;f  J4HIIAHH  HFH H;   H; t~H? LH2  H.u
HFHP0IGILH   HH  IA   HH  IHx
S  M)7uGIGI;HNHo  H;u
H^ H~H~H_H?HHH.u
HFHP0HL$hLH|$hHt
H)uHAP0HL$XHH\$XH$0  Ht
H)uHAP0IGHH; tKH;ׄ tBII  HH,  H@L   Mu,R   
 e:    IILL    Mu>H, H9FuL;v   H^JHI)L;v   J\HIHAHH   HL$xH\$xHt
H)uHAP0HL$hH HH  L$0  HuHHx  H+u
HCHP0HT$xLHL$hH˅ 4  H/!HGHP0H+ׄ Ht H; HHp3  z H.u
HFHP0H$0  HL$H  H$   HD$XH LHD L   LJ H:  v  I/u
IGIP0L%uI	H LH Lk   L P:  "  O    @:     6    c:  *      :  C    :  -    :     i :  HH߉ LH5 LH$0  LHD$XLY~H
$ H= A   H	 
Hx
 +:  f   LLLLHk H HtH.u
HFHP0HK  H/A  HGHP02   Ht H HHH   R I.u
IFIP0L$   IIL$   L$   L$   H$  H$  H$  MtI/u
IGIP0HL$hL$   Ht
H)uHAP0HL$XHt
H)uHAP0HL$xHt
H)uHAP0H$   HtH(u
HPHR0HH   ]	 :     LLLLH H[ H$H  Ht
H)uHAP0MtI/u
IGIP0HtH+u
HCHP0MtIm u
IEIP0MtI.u
IFIP0H$@  Ht
H)uHAP0HL$PHt
H)uHAP0MtI,$uID$IP0D% H
  L$   :H\$Hl$VWAVH@H/ IHzLH\$pHM   HtH   HZH\$pH{ HHu)H  Hs H} HtHHD$pHH   HB HHD$(LL$pH6 H|$  y
8     H\$p   H   H   H H|$0HHg H?L
 HL HHDHHD$(H HL$ LIH
.~ H H	.~ 8  Hʅ H# =    A  H
 3HZHIH\$`Hl$hH@A^_^HHPHHATH   H
 E3HXAHpAHxLhELpEHALd$XLd$hLd$pL   L$   L$   MtA} H$   HL$   Hu'Hф H*
 
   6 7  
  HGIH;|    HoH   LwHHE IIH)uHAP0HI_LHu=
    7  	  Hm u
HEHP0IH/u
HGHP0I.Iu
IFIP03{ LH   H HM    Y 7  	  H;~ uE33H
1H;~ uHG@t3HH>	 E3H	LHM]    7  
	  H$   HI(H;
+| u&H
{ Hs H	{  7  W  H
 臮 HHu 7  4  H@IH;y Lt$PtMH;#{ tDHp{ HHuN 7    H@H   HL$`Hu* 7    HHMLd$`H/u
HGHP0HD$`Hu>Hfy H9EuL;u4  HEJ<HI(L;u  J|HIHHH   HL$hH|$hHt
H)uHAP0H Hx HH   H
 Hx HHtgH/u
HWHR0IOII9O ~HIGHHAIGHIx uH+HCH 7      7      7     z HtH?x HHttWx Hm u
HEHP0H$   ML|$X脭yeH HZ	 	   f 7     W 7  IH̀ H&	 	   I/g  IGIP0X  tIIs  3x HHu'H H V	    7    H$   HH(H;
$y uAH
x Hl H	x H, IH  	    7    H e HHu'H HG    S 7       x HHu'H H
     8  ^  IE3H
o
 HLxHX oHHu  	8    H/u
HGHP0HCH;5v teH;tw t\Hw HHu'H" H{      8    H@L   Lt$`Mu$c  8  {  HHLd$PMLd$`HH+u
HCHP0MuHHu H9GuH;wa  HGHHHHt$P.H;wB  H\HHHt$PHAHH  HCHv H;+  H;+u   Hv HH  H+u
HSHR0HNIML   HAH$   MH  HA   ALHm  HAHH  L)>u
HFHP0Lt$`HL$pL$   L|$pHt
H)uHAP0H$   L$   L$   Ht
H)uHAP0L$   IM
HHR  HMH9M ~eH HEHHAHEdHKH_  H;u
Lk HCHCLhH H$   H IE H+3HCHP0$HHt    H+tL$   Ht$PL$   HCHP0L$   Ht$PL$    [8    H.u
HFHP0IuI c8     S8    H| IHm H$   H$      i l8    H{ IH3 H$   H$      / j8  _  ~,H
t H* A   H	s  >8    Hx >8     t Ht HIr HH~   r H/u
HGHP0Lt$XLL$   L$   H$   H$   H$   H$   MtI.u
IFIP0HL$hL$   Ht
H)uHAP0HL$pHt
H)uHAP0H$   HtH(u
HPHR0IH   A\ .8  IL$   MA   HRz H HtH/u
HGHP0HtHm u
HEHP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtH.u
HFHP0Lt$XD H
 - H\$Hl$VWAVH@Hs IHzLH\$pHM   HtH   HZH\$pHq HHu)H  H Hp HtHHD$pHH   Hr HHD$(LL$pH6 H|$ ly
[7     H\$p   H   H   Huw H|$0HH~ H?L
X HL= HHDHHD$(HV HL$ LIH
p H/ H	p i7  HJx H      A  H
 	3HZHIH\$`Hl$hH@A^_^ATAWH(HAE3HJ  EH\$@Hl$HHL   MtAp Ht$PHH|$XLt$ Hu'Hw H d     6    HCIH;wo    H{H   HsHHHHH)uHAP0HHHHu'Hw Hn    z 6  O  H/u
HGHP0IH+u
HCHP0H.Iu
HFHP03?n HH   Hv H {   	 6    H;]q uE33HV1H;q uHC@t3HWH E3H3HHMH(v H     6  b  HM(H;
n u&H
<n H= H	n Z 6    H  1 HHu7 6    H@H;l tLH;m tCHHn HHu 6    H@L   Mu 6    HHIMH+uHCHP0D  Mu>Hl H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0H Hk HHtEHNH9N ~H HFHHAHFDHHk 0 7      	7     m HtHEk HHztfk H/u
HGHP0HLH.u
HFHP0Lt$ H|$XHt$PHl$HH\$@MtI/u
IWIR0IH(A_A\N 7  Hs H     H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D] H
Ư  KLkHL@HPHHSVWATAUAVAWH   H@HWhE3LxPL`AED$pLHD$XL|$hEL% IH
 i HHtH ISHHu'Hr H s    5    HCL   H HMtAWk HHu'HHr H     5  h  H+u
HCHP0IH$X  LfHj I9$  H^H$X  H  H~HHHHH)uHAP0LgI$H;l uaH$   H$H  H$   A   H$   HoHH   Htq H K    6    H;l    HOQ=      H$   H$H  H$   HA IuHOE3EAH$   HHu'Hp HA    M 6    H+u
HCHP0IH$X        mi LHu'H
p H
 e    6    HXIH$X  H$H  H IF E3IH:HHu'H3p H 
    6  h  I.uFIFIP0:HHHHu'Ho H@    L 6    H.u
I$HP0HGL   H HMtAh HHu'Ho H Z    "6    H/u
HGHP0HHL$ ^HHL$pIHT$ HtLD$0L+I|h Ht*Ho He    q %6  M)  H.u
HFHP0IHT$pH$   ,EH$P  /@@u5-h Ht*Hn H p    06  M  H$   H$   FDLHT$ H$@  HI,HHL$XHHT$ HtLD$0L+I{HT$XH$   qDH
 HHu*Hm HG    S A6  M  H@L   H HMtAf LHu'Hm H n    C6    H/u
HGHP0H$   ReHHu'HKm H "    F6  k  IMfH5e I9$  I^H  MfHI$IMH)uHAP0ID$H$X  HH;
g u[H\$8H|$@A   HT$8IHHu'Hl H z    Z6    H+\  M  H;
g ulIL$Q=   uXH\$ H|$(HA IuIL$E3EAHT$ HHuHl Hx     c6  *     d LHu'H
k H
>    J j6     HXHx E3IIHHu'Hk H w    p6     Im ulIEI`HI]HHu$HVk H -    S6  dH/u.HGHP0"HCHP0H/u
HGHP0L$X  I.   I$IP0   E3AH$X  AEMHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0MtIm u
IEIP0DL  H
 :IHT$XHtLD$hL+IwHT$pHtL$   L+IwH$   HtL$   L+I{wH$   HtL$   L+IYwHH   A_A^A]A\_^[H\$Hl$Ht$WATAUAVAWHPH=c E3H|$HAH\$@MHLM   LzIMt"HtH   Hz H|$HHZH\$@Ia HIMtHt&MH I_ HD$@HH   HH(  H] I_ HtHHD$HHH   H IHD$(LL$@HP L|$ &y
5     H|$HH\$@   HBH   H   HNH!g HHL$0Hn HLL
 AHD$(IH HLd$ H
h` Ly LMH H	]` 5  Hg HR l    A  H
 踸3Hz HZLHInL\$PI[0Ik8Is@IA_A^A]A\_HLH L@HHVWATAUAVH   H@HXLW@H@    33D$@Ht$PL5 IH
S ^ HHtH IHHu'Hg HZ    f /5    HCL   H' HMtA_ HHu'Hf H     15  g  H+u
HCHP03H\$ LgH^ I9$  H_H\$ H  LwHIHIH)uHAP0MfI$H;a uYH$   L$   A   H$   ILH   He HA    M E5    H;a    INQ=   u}H$   L$   HA t3INE3EAH$   LHu'Hge H >    M5  !  H+u
HCHP03H\$       ] HHu'H
e H
j    v S5    HX3H\$ IE Lh E3HILHu'Hd H    & Y5    H.uFHFHP0:IH|LHu'Hud H L    ?5  /  H/u
I$HP0IFL   HK IMtA ] HHu)Hd Hj    v _5  3  I.u
IFIP0HD$0    HHL$pQSHHL$@D>HT$pHtL$   L+I&q ] Ht)Hc H c    b5  3D  H/u
HGHP03HT$@HL$X9H$   贏AAu4\ Ht)Hc Hw     n5  3   H$   g@@u4e\ Ht)Hb H*    6 o5  3   HT$XHL$pX:DEHH$   HI-[ HH   Hjb H A    v5  3%Lt$0H\$ IIMtI.u
IFIP0HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D Z H
 趲3HT$@HtLD$PL+I9oHT$XHtLD$hL+IoHH$   Hİ   A^A]A\_^H\$ UVWATAUAVAWH`HM2 H3HD$XL5n[ 3H-eY MHt$@HLt$HLHl$PM%  LbIMt1Ht"HtH%  Hj(Hl$PLr Lt$HHrHt$@IY HIMtHt,HtOvH6 IW HD$@HH   HHo  H IXW HtLHD$HHHF  H I/W HtHHD$PHH  Hg IHD$(LL$@H# Ld$ y
4     Hl$PLt$HHt$@   HBH   H   H   HWH^ HHT$0A   H
e HLL
a HL$(   H
W H;AMLb HHD$ H	H? MML W 
5  HR_ H  #   A  H
 3Hj(Lr HrLMHIHL$XH3qH$   H`A_A^A]A\_^]@SUVWATAVAWHpH/ H3HD$`H- LLHH
 M33vU HHtH H)HHu q4  Q  HGHH L   MtAEW HHu s4    H/u
HGHP0HCHHh L   MtAV HHu'H] HC    O v4    H+u
HCHP0HU 33H9Gu+H_Ht"HGHHHH H)uHAP0   HGH;SX uIHT$(HDEH+H\$ HLt$(L|$0Ld$8+HH    4    H;aX    HOQ=   uxLT$HHDEL+H\$@Lt$HL|$PLd$XHA t3HOE3IHHu7 4     H  H+
  HCHP0   MWU HHuH
x\ H
  4  ZHtHX3IE3HHLtEIL|EI$Ld#HHu~ 4  H\ Hk    HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0D H
 . 葬3#H.u
HVHR0H/u
HWHR0HHL$`H3mnHpA_A^A\_^][H\$Hl$Ht$WAVAWHPHT MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@IS HHHtHt+RHJ  HS IQ HtHHD$@HH!  H IqQ HtHHD$HHH   H IHD$(LL$@He Hl$ y
A4     H|$HH\$@   H   H   H   H
 Hl$0HL
õ H?LȒ HH HHLIH
` HL$(H
R HD$ H	R R4  HY H (    A  H
	 t3Hz HZLHIH\$pHl$xH$   HPA_A^_H\$Hl$Ht$H|$ ATAVAWH H5 LHHH
; MM3O HHtH HHHu^ 3    HGHH L   MtAQ HHu" 3  D  H/u
HGHP0HCHHo L   MtAhQ HHu'HYX H 0    3  
  H+u
HCHP0;O HHu 3     H LHO yk 3     Ho MHN yE 3  jH MHN y" 3  GH1 MHN y 3  $H LHcHHui 3  HRW H )   HtH/u
HGHP0HtH+u
HSHR0D H
  3#H/u
HWHR0H+u
HSHR0HH\$@Hl$HHt$PH|$XH A_A^A\@SUVWATAVAWH`H' H3HD$XH=[O MH- LH5' LrH|$@IHl$HHt$PM#  Mt1Ht"HtH/  Hr(Ht$PHj Hl$HHzH|$@IN HIMtHt1HtT{H  Hx IL HtHHD$@HHl  H IL HtHHD$HHHC  H. ImL HtHHD$PHH  H} IHD$(LL$@H} Lt$ y
3     Ht$PHl$HH|$@   M   H   H   H   HS Lt$0IH4[ H?L
 HL2 HHHDMHD$(H HL$ LIH
L Hx H	L 3  HT H  d y  Ay  H
׌ R3Hr(Hj HzLLHIHL$XH34gH`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   Hs MtAL H|$PHHu v  2 F3  D  J HHu H3        UL HHuH
vS H
  J3  lILLxHH iJ y O3  4H+u
HCHP0H LHHHu^ Q3  HR HW  v  H.u
HFHP0HtH/u
HGHP0HthH+ubHCHP0VH.u
HFHP0H/u
HGHP0IHHZI Hu=[ w   `3  HbR H D< H
5  *LL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAH L   MtAJ Ht$0HH|$8Hu'HQ H  ~ s   2  '  HC3H;I u{H{HtrHsHHHHH)uHAP0HH?HHu 3     H/u
HGHP0H+u
HSHR0HH|$8Ht$0H [H;K uE33H1H;L uHC@t3HHg E3HHHu" 3  HP H r s  HtH+u
HCHP0HtH/u
HWHR0DA H
ڇ  /H|$83Ht$0H [;HAVAWHXHXE3HhEH-X HpHHxALhALH
 F HHtH HfHLd$HHu o   f2    HCHH L   MtAsH HHuI o   h2  Z  H+u
HCHP0HGHH$ L   MtAH HHu'HO Hg  o  s k2    H/u
HGHP0HF LcII9$  H{H  HkHHHHE H)uHAP0HELeH;lI uBA   H|$ HT$ Ll$(HUHH   ? o   2  P  H;I    HMQ=      H|$0Ll$8HAI uHME3HT$0EAHHu o  ` 2    H/u
HGHP0IH+u
I$HP0H
 LHH   HM IH j p   2       8F HHu'H
YM H
 0 o   2  O  HxE3IE HHLh IHHu o   2    H.)HFHP0IHHH o  7 y2     H"yy 2  I   H+u
HCHP0   HEHHl L   MtAUE HHu'HFL IH  p   2  QH/ E3HHHu| 2   p  HK HJ HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D H
ł  zH+u
HCHP0HHE LLl$@Ld$HH|$PH$   Hl$xH\$pMtI/u
IWIR0IHXA_A^H\$Hl$VWAWH@H-_ LH
 H33A HHtH H{HLt$`Hu< 1  c  HGHH L   MtAC HHu  1  '  H/u
HGHP0HCHHM L   MtAFC HHu'H7J H  l   1    H+u
HCHP0HB Lw3I9|  H_Ho  HoHHHHE H)uHAP0HELuH;D u4A   H\$ HT$ L|$(HHHuo 2  -  H;D    HMQ=   uzH\$0L|$8HA t3HME3HT$0EAHHu 2     H+u
HCHP0H/u	IHR0HLt$`H\$hHl$pH@A__^ù   A HHuH
H H
& < 2  tHXE3IHHLx 3HHu
 2  7H.pHFHaIHbHHM 2  HMH H $ l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0D H
~ i ̘3@USVWATAUAVAWH$H  H H3H  E3HT$`HLEHp  MAHULMEH AHHAH HL$XLeL   LeLeH\$PLd$hLeLd$pLd$xLe LeLeLeLeLeLeLeLd$HMtA? HHu'HF H5  1  A *  <L  HGH;>    H_H   LwHHIIH)uHAP0HInLHu*HgF MH ; 1   +  ?K  H+u
HCHP0IH/u
HGHP0I.Iu
IFIP0H
7@ H9M  L;A  L5 H
 I< HD$8H   H    H;@ uE33H1H;@ uHG@t3HH) E3HnLH9HcE MH 7 1   	+  ;J  IHD$8LHu	 3  M *+  I  IFIH L   MtA= HHu 3  MK ,+  I  I.u
IFIP0H E3HLHu*HD MH i 3   /+  mI  H/u
HGHP0I.u
IFIP0H
#= H9M  L;-j< A  H
 8LHu*HD MHg  5  s X+  H  H@IH L   MtA< HHu 5  M* Z+  |H  Im u
IEIP0HE E3HzLHu*HsC MH G 5   ]+  KH  H/u
HGHP0I.u
IFIP0H
< Ll$`L;   Lt$XIF(H;uAH
N; H?v H	; HB MHE  8  Q +  G  HM H%n Hu*HB MH  8   +  G  Im IHD$`   IEP0   H
  {LHu*HTB MH ( 9   +  AG  Lt$`II 9 u 9  I +  MF  Im u
IEIP0t\   b9 HHu*HA MH!  :  - +  F  IIH@HT$`L0I.uIFP0Lt$XH
 HHu*HiA MH = ;   +  VF  H@HH` L   MtA!: HHu*HA MHh  ;  t +  E  H/u
HGHP0HCHH L   MtA9 HHu*H@ MH  ;  
 +  E  H+u
HCHP0IN(IH;
B9 uAH
8 H"t H	8 HJ@ MH  ;   +  "E  H k HHu*H@ MHb  ;  n +  D  IN(H;
8 uAH
8 Hs H	e8 H? MH  ;    +  D  H j LHu*H
? MH
 T ;   +  XD  Hn7 MELd$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;9 )  HD$`H0  H0  EFAHHH+L(  H8  L@  LHu*2 +  H> MH  ;  C  MtIm u
IEIP0H+Ld$Hu
HCHP0I/u
IGIP0Ll$`H/u
HGHP0Im IILt$`MuIEP0H]H;6   '5 H  H= MHU I =  ^ ,  C  H;9 u|HOQ=   uiHD$`LP  HP  EFAHL+LH  HX  L`  HAI uHOE3ILHپ +  AN6 HD$0HHu*H
6= LH
 
 ;   +  B  Mt	LhLd$HLl$`E3AHIE LlAFH\AFL|IMLHu,H< Lt$0H  ;  " ,  A  HL$0H)<HAP00H+HHEuHCP0H\$XHK(H;
65 uDH
4 Hfp H	4 H>< MH I ?   2,  WA  H tg LHu-H; MHS I ?  \ 4,  A  HK(H;
4 u9H
4 Ho H	S4  ?  M 8,  MIh@  H f HHu"[ ?  M :,  MI2@  HI3 LHu% ?  M <,  I?  Im u
IEIP0H/u
HGHP0H
` LuMHHu*H: IH;  @  G J,  @  H@HHܾ L   MtA3 LHu-H: MH I_ @   L,  c?  H/u
HGHP0IEIH L   MtA33 HHu	 @  M O,  I>  Im u
IEIP0H2 MAH9Gu,LoMt#HGHIE HH H)uHAP0   HGH;4 u`LEH   L   HϋDCHH+L   L   bLH   L @  M׺ a,  I&>  H;4    HOQ=      LEL   L   DCHL+L   L   HAI uHOE3ILHu @  MG i,  I=  MtIm u
IEIP0M   Kh1 LHun @  I o,  K=  MtLhMHME3HT$`HILCHHITI4LHu @  I z,  <  I/u
IGIP0H/u
HGHP0I.u
IFIP0H
A MHHu B  I: ,  M<  H@HH̻ L   MtA0 LHuc B  I ,  @<  H/u
HGHP0IGIH L   MtA40 HHu
 B  I ,  ;  I/u
IGIP0H\$XMHK(H;
/ u3H
,/ HEk H	t/  B  I= ,  ;  H9 b LHu B  I
 ,  _;  HK(H;
U/ u3H
. Hj H	/ B C  Iͷ ,  ;  Hɿ a HD$8LHu*H(6 IH~  C   ,   ;  HK(H;
. u3H
9. Hj H	.  D  IJ ,  :  H !a HHu D   ,  o:  H- MLd$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;&0    HD$8H  H  EFHD$`HH  AHH+L  L  H  ޻LHud ,  ½ B  9  MtIm u
IEIP0I/Ld$Hu
IGIP0HL$8H)uHAP0H+}  HCHn  H;/    HOQ=   uHD$8L  H  EFHD$`H  AHL+L  L  H  HAI uHOE3ILH'r ,  м B  8  AN, HHu/H
3 MLl$8H
  B  ' ,  8  Mt	LhLd$HHT$`ANAE3L|MHD$8HDAFHH\AFHIHTHHLHu'HA3 H  B   ,  8  H.u
HFHP0H/u
HGHP03Lu}* HD$0LHu-H2 IH7 I G  @ ,  7  L|$XIO(H;
+ uDH
* H{g H	2+ H2 IH I\ G   -  7  H. ] HHu-HJ2 IH I G   -  c7  IO(H;
* uGH
X* Hg H	* H1 IHO Mʺ G  IU -  6  H ,] HHu-H1 IH M G   	-  6     T* HHu*Hu1 MH˹ I G  ײ -  M6  H
3 E3HHxHp 0HHu*H)1 MH  G   -  6  H+u
HCHP0HFH;'    H;) t}HI_) HHu*H0 IH  G  " -  5  H@H   H}Hu:H0 MHظ V G   -  o5  HHMLeIH.uHFHP0    Hu>H' H9CuL;k  HCJ4HI(L;k  JtHIHHH  HFH( H;,  H;&   HJ( HD$@LH  H.u
HFHP0IGIHL$@ML   ALd$8HH  HL$@A   AHD$8H  L|$@IAHhM  I/u
IGIP0Lt$8HL$xH|$xHt
H)uHAP0HMIHEHtH)u
HAP0IHH& Lt$0HH  INI9N ~cH IFH}H4HAIFUHNH{  H;u
Lv H~H~LwH?HIH.IHFHP0:HI%    H}IH+u
HCHP0HMLuMZ  H. IHd  I  p -  *3  ɶ G  W e-  2  HL$@H)uHAP03uI G   m-  `2  H- H f G   ]-  2  Hh- MH < G  ʮ v-  U2  H>- MH  G   t-  +2  ~H
% H A   H	T% 
HxXH, MH?  G  K H-  1  H& HzH# HHst# YH, MH c G   8-  |1  "  H
׵ rHHu*HK, IH  J   -  g1  H@HH L   MtA% HHu*H+ MHJ ȴ J  V -  0  H+u
HCHP0H# IH9F   H^H   H~HHHHH)uHAP0HHpLHu*Hi+ MH = J  ˬ -  V0  H+u
HCHP0IH.u
HFHP0Ll$`ILt$PIEH;!    H;6#    IHEw# HD$0LHuhH* MH)  K  5 -  /  HPLHiH* MH i J   -  /  H@H   HEHuFHW* MH + K   -  D/  IE IIHMHEMLl$0HMMLd$@IMHuFH  I9FuI;N?  IFH4HHHM,I;N!  ItHHHMIHH  HD$hHt$hHHt
H(uH@P03! HH  HT$hHM@  HHT  H@H;A  t]H;! tTIHLu! HD$8LH   H@H   HMHu4Lt$0 M  w -  -  HLH\$8MLeLeH+uHCHP0@ HEHuFH I9EuM;u7  IEJHILu,M;u  K\HILuIHH  HMH]Ht
H)uHAP0H
 IWHH  H@HHM L   MtA! LH  H/u
HGHP0IGIH L   MtA  HH7  I/u
IGIP0H MALd$@MH9Gu3LL|$@Mt%HGHIHH H)uHAP0   DHGH;8" uhHEDAH   H   HD$XL   H@(H  HHH+ HH   Lt$0 L  s 5.  +  H;'"    HWDBA=      HEL  H  DYHD$XL  H@(H   IHL+HBA uHOE3MIHHr  MtI/u
IGIP0MLd$@    HD$HLH  MtLxMLd$@HEE3HL$XIH KDHA(H HA(HKD HH&  Im u
IEIP0Ll$8Ld$HH/u
HGHP0HNIH9N ~HHFLuHHAHFHH   LuI+ Ht HR HHl   Im u
IEIP0HMLHuHt
H)uHAP0H
 ILH  H@IHZ L   MtA HHu  Im u
IEIP0H L{MLd$8I9S  LkLl$8MA  LsHIE IIH)uHAP0IFM~H;; uIHEHU(A   HE0ILm(#HHutL|$@Lt$0 N   .  (  H;I ucINQ=   uPHEHE@Lm8HAI uINE3HU8EAHH  Im u
IEIP0MLd$8t   i HH  LhE3HEHILd$8MH HG `HHm  H/u
HGHP0IIH4HH  H+u	IHP0HL$pHt$pHt
H)uHAP0HMIHo HAL   MtA HH8  H IH9CuRH{HtIHsHHHHH)uHAP0HH臦HH  H/u
HGHP0IHHH  H+u
HCHP0L|$hHII Dx
AADE;  H.u
HFHP0IE8  Lt$pH	 IIFL   MtA HH  HMI HH  H L{MLd$8I9  LkLl$8M  LsHIE IIH)uHAP0IFM~H;3    A   LmHHUHH}PIHH
  Im u
IEIP0H/Ld$8u
HGHP0Lt$pH+u	IHP0I.HH\$pIIuIFP0L|$h  H; ugINQ=   uTLmXH}`HAI uINE3HUXEAHHTL|$@Lt$0O P  ݡ .  /%      HD$HLH
  HD$8E3IIEILd$8I} HH  Im u
IEIP0Ld$HHHHH  H/HGHP0H\$p HH  LIH w  HL$xLHt$xHt
H)uHAP0HL$PIH HAL   MtAN HH  LxLd$HHJ I9T  LkLl$HM=  LsHIE IIH)uHAP0IFM~H; uEHD$xHUhA   HEpILmh豥HHusL|$@ R  ( (/  p#  H; udINQ=   uQHD$xH   LmxHAI uINE3HUxEAHH  Im u
IEIP0Ld$Hx    HH  LhE3Ll$xHILd$HIE Lh HHp  H/u
HGHP0ILl$xIH¡HHb  H+u	IHP0H.Iu
HFHP0Lt$XIIN(H;
a   H H HH  H@HH
 L   MtAF HHm  H+u
HCHP0H; LII9k  H_H^  LwHHIIH)uHAP0IFM~H; uUHD$hH   A   H   IH   蘣HHa
  H+   HCHP0Lt$XI   H; ulINQ=   uYHD$hH   H   HAI uINE3H   EAHH
  H+u
HCHP0Lt$XI    HD$HLH	
  HXE3HD$hIIIH IE ɡHH	  Im u
IEIP0Lt$XLd$HHT$hH蓟HH
  H/u	IHP0HM IHu LHt
H)uHAP0IN(IH;
* ,
  Hͤ F HH  IH  HH  H.u
HFHP0HMLH}Ht
H)uHAP03Il HH^  A   HI HD$HLH  H.u
HFHP0IIGD  Im u
IUIR0Et/    HD$HLH  H
Ƥ HH@HIMI/IMLmuIGP0    HH=  HEE3H
8 HH HGHD$HLH
  H/u
HGHP0   U HH
  H@IHL(6 HD$HLHj
  H/u
HGHP0HMILmHt
H)uHAP0L|$hLt$PII2 HD$HLH	  H@IH{ L   MtA$ HH	  Im u
IEIP0    HD$HLH^	  HEH IE HH#	  L HH-    LIH虞HH  H/u
HGHP0Im Iu
IEIP0H.Ld$Hu
HFHP0LIII =  H+u
HCHP0LmII H  HEAE     I迋HHz  HT A   HތHH;  H+u
HCHP0HI'DD  H.u
HVHR0EC  H
d 藚HH/  H@HH L   MtAN HD$HLH  H+u
HCHP0HL$PI
 HH  H$ MuI9R  I}HE  IuIHLHt$HHH)uHAP0HFLvH; uGA   H   H   H   H脝HH=  H/u
HGHP0I   H; ubHNQ=   uOH   H   HAI uHNE3H   EAHH  H/uHGHP0Iw    HD$8LH  HxE3HX HHII͛HH  I/u
IGIP0L|$hLd$8'HI蚙HH  H+u
HCHP0Im u	IIP0HL$PLILd$H   H.u
HFHP0L|$@ILl$8Lt$0HMHELd$HH Lt$0Hq  M  } -    Lt$0ѝ L  _ =.    Lt$0 L  A S.     L  ( N.  p   L   C.  W  Lt$0c L   #.  C  Lt$0E L  ӕ  .  %  Lt$0' L   .    Lt$0	 M   .    L|$@Lt$0 N  t .    H L|$@Lt$0H7  N  C .    L|$@Lt$0 N    .  r  L|$@Lt$0o O   .  O  L|$@Lt$0L P  ڔ .  ,  HN L|$@Lt$0H  P   .  4  L|$@ P   .    L|$@Lt$0ڛ P  h .    L|$@Lt$0 P  E .    L|$@Lt$0 P  " .  t  L|$@v R   0/  L  L|$@X R   </  .  L|$@: R  ȓ 6/    L|$@ S   e/    L|$@ S   m/    L|$@ S  n y/    L|$@ S  P s/    L|$@ V  2 /  z  L|$@ [   /  \  L|$@h [   /  >  L|$@J [  ؒ /     L|$@, \    0    L|$@ \   )0    L|$@ \  ~ 60    H IL|$@Lt$0H>  \  J 00    L|$@I \  ) <0  q  L|$@} \   0  S  L|$@I\ \   0  2  L|$@I; \  ɑ 	0    L|$@I \   0    L|$@ [   /    L|$@ޘ Y  l /    L|$@ Y  N /    L|$@ Y  0 /  x  L|$@ Y   /  Z  L|$@f Y   /  <  L|$@H Y  ֐ /    L|$@* Y   /     L|$@ W   /    L|$@ W  | /    L|$@З W  ^ /    L|$@ W  @ /  Ld$H  L|$@ V   /  e  L|$@q V   /  G  L|$@S V   /  )  L|$@5 T  Ï /    L|$@ T   /    H
a HjC H	 L|$@ T  p /    L|$@Ė S  R _/    L|$@ S  4 Q/  |  L|$@ S   O/  ^  H
 HB H	 L|$@S S   M/  )  L|$@5 R  Î "/    L|$@ R   /    L|$@I Q   
/    L|$@IՕ Q  c /    L|$@Lt$0 O  @ .    L|$@Lt$0 O   .  o  L|$@Lt$0l O   .  L  L|$@Lt$0I N  ׍ y.  )  Lt$0+ N   k.    H- Lt$0H  N   i.     M  t -    ͔ L  [ -    X Ht H HHR   I.u
IFIP0H\$PHLHMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HtH+u
HCHP0HL$hHt
H)uHAP0HMHt
H)uHAP0HL$pHt
H)uHAP0HL$xHt
H)uHAP0HM Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$`Ht
H)uHAP0HEHtH(u
HPHR0IH  H3H  A_A^A]A\_^[] K  D -    3? LHu*H	 IH | ^  
 d0    HHD$PHD$XMHH(H;
B u>H
 H> H	 HJ	 H ! _   r0  i  H 4 LHu'H	 Hh  _  t t0  .  Iv HEHHu'H H+  _  7 v0  
  I.u
IFIP0Ld$0MLd$8MMH
  H
ߔ 蒋HH
  H@HH L   MtAI HD$HLHY
  H.u
HFHP0IEIH L   MtA HH	  Im u
IEIP0I] HD$HLIH	  H MALd$8H9Fu2LvLt$8Mt$HFHIHH H)uHAP0   HFH;T 
  HD$XDAHp  Lh  Lp  H@(Hx  HEH  HHH+HD$0HH  MtI.u
IFIP0Im Ld$8u
IEIP0Ll$XLuH.u
HFHP0HMIH}Ht
H)uHAP0IM(H;
 $  Ho 2 HD$0HH  3HGzHH  H+u
HCHP0HMHH]Ht
H)uHAP0II2V     IM(H;
   H x1 HH[  3HyLH  H.u
HFHP0IH HH  I.u
IFIP0H+HHuuHCP0H
{ 讈LH  H@IHԌ L   M:  A8  H;     HVDBA=      HD$XL  L  DYL  H@(H  HEH  IHL+HBA uHNE3MIHD$0HH `  I= 0  	   HHj  Mt	LpLd$8LuE3LlHLl$XHLd$HIE(H IE(HD ILt(THD$0HH  H+]HCHP0N, HH  I.u
IFIP0H! LsLd$0I9P  LkLl$0M>  H{HIE HHH)uHAP0HGLwH; uDHEHUA   HE HLm耊HHuon e   1  Ld$H9  H; u`HOQ=   uMHEHELmHAI uHOE3HUEAHH  Im u
IEIP0Ld$0y    HD$HLH  HL$0E3HHIHEHLd$0H IE 辈HH|  Im u#IEIP0HH蔆HHD  H+u	IHP0HFHH L   MtA\ HH  H.u
HFHP0HMIH]HHt
H)uHAP0H
 ,HH  H@HHR L   MtA HH1  H+u
HCHP0    HH  Hy HHH HCHM H HC Hs(\ HH  H+u
HCHP0H|$PHHIrL  H.u
HFHP0Lt$0IILd$HL;}Ll$8Ld$H}   `  I| 0    Չ d  I` 0  MILd$H   d  I9 0  MILd$H{   0  } d  ILd$HMIMQ  H
 Hq6 H	 ށ 0  : e  ȁ #1  Ld$H   e  M /1  IM   e  I )1    ވ f  l U1  Ld$H   f  N R1  Ld$H   f  0 G1  Ld$Hm   f   D1  Ld$HO  f f   B1  Ld$H1  H e  ր 51  Ld$H  * e   1  Ld$H   e  I 1  IMLd$H   e  Ip 1  IMLd$HI   c  I 0  / b  I- 0  Ld$Hj   b  I 0  Ld$HI  H
 H44 H	 I b   0  0 `   0      `   0     `  M 0  I  ߆ `  Ij 0  MI   `  IH 0  MI   `  I& 0  MIm  H|$PH
o 袀HHu` g  I~ `1  M:  H@HH L   MtA> HD$HLHu g  I~ b1  M  H+u
HCHP0H MuII9  I]Hz  I}IHLH|$HHH)uHAP0HGLwH; uwHD$PHUA   HEHH]tHHu} v1  2  H+u
HCHP0H|$PIm u	IIP0H/HHHGP0H;m uXHOQ=   uEHD$PHEH]HAI uHOE3HUEAHHmX} ~1         HD$0LHu1} 1  lHXE3HD$PIHIH IG 膁HHu| 1  7I/IGIHIQHH| p1  ! g  IMLt$0Ll$8H" H{ MtIm u
IEIP0HtH/u
HGHP0HtH+u
HCHP0MtI/u
IGIP0H\$PHL$HHt
H)uHAP0MtI.u
IFIP0HtH.u
HFHP0Da H
0 { OKH\$ UVWATAUAVAWHpH= H3HD$`H= MH5T HL5J LLzH|$@IHt$HLt$PH|$XMm  Mt@Ht1Ht"HtH}  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@I] HIMtHt>HtaH      H  Hy IF HtHHD$@HH  Hz I HtHHD$HHHp  Hy I HtLHD$PHHG  Hy I HtHHD$XHH  H* IHD$(LL$@H! L|$ 5sy
*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
.Q L|$0IL
S H?Ll+ HHS HMLIH
[ HL$(H
S HD$ H	U *  H HJ dy    A  H
5+ H3&Hj0Lr(Hr HzMHl$ LHIHL$`H3
H$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMHz L   MtA) H|$0HHu'H Hn    zx 8*         HHuXx :*  sHE Hh HHuH
 H
 (x ?*  QHOw MH yx A*   LHHm|HHuyw B*  H\ H~ 3   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0D~ H
( }w F33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPHQ MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt+RHJ  Hu I HtHHD$@HH!  Hu I HtHHD$HHH   H	' IHD$(LL$@H Hl$ oy
	*     H|$HH\$@   H   H   H   H
2M Hl$0HL
P H?L& HHO HHLIH
_ HL$(H
W HD$ H	Y *  H HN| hu |   A  H
I& D3Hz HZLHIJH\$pHl$xH$   HPA_A^_LATAVH   Hs H3H$   HE3H;3 LI[ AIkIsAI{AMkEM{ELD$8HT$ HL$0Ld$(  3 HHu'H  HY{ {   et (  8  HD$0HH(H;
 u0H
 H8$ H	W {   #t (    Ht  HHu'H
 H
z Z{   s (  m  H@H;H tsH; tjHI HHu'H
1 H
z {   s (    H@H   HL$@Hu'z   hs (    HHMLd$@H/u
HGHP0HD$@Hu>H H9CuL;s  HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0Huy IL;tIfxVnHMH9M ~IE HEL,HAHEKIHL 7y   hr (     y   Or (     L HtH HH7t% H+u
HCHP0HL$ Hl$   by   q (  jL5z H
w I7 HHtH IyHHuq 	)   HL$ H  DuEq )  x   H HVx H(  Hm   HEHP0  Hm u
HEHP0Et`   : HHu,H Lt$ Hw ux   q )     HL$ HT$ HH@HH)uHAP0H={ H
wv H& HHtH HxHH   H Hww w   p 0)  Lt$ HtH+u
HCHP0MtI/u
IGIP0HL$(Ht
H)uHAP0HtH.u
HFHP0Dw H
  p w?  HCHHr L   MtAe HHu'HV Hv -w   o 2)  3H+u
HCHP0HGHHx L   MtA HHuH HKv ao 5)  
  H/u
HGHP0Hl$0HM(H;
 u>H
 HL H	C H Hu sv   o :)  yHn  HHu'Ha Hu 8v   n <)  >HM(H;
 u4H
u H H	 H Hou n @)  1  Hv \ LHubn B)     H IELd$(H9Cu2HkHl$(Ht$HCHHE HH H)uHAP0A   HCH;h    HD$ HT$PHD$PEFAHHH+Hl$HH|$XL|$`6sLHuH? Ht m S)  Z  HtHm u
HEHP0H/Ld$(u
HGHP0I/u
IGIP0Hl$ H+u
HCHP0Hm HuHEP0H
!x nHH  H IHs }t    m )  H;    HKQ=   umHD$ LT$pHD$pEFAHL+Hl$hH|$xL$   HAI uHKE3ILHH Hes {l ])  *AN HHuD]l e)  H
 H
/s s   HH/HGHP0Ht	HhLd$(Hl$ E3AHHHE HlAFH|AFL|MYpLHu*HR LHr &s   k s)  1H.<HFHP0-H@HHo L   MtA HHu*H MH8r r    Dk )  H+u
HCHP0HFHHm L   MtA HHu'H{ Hq Rr    j )  H.u
HFHP0H\ IAH9Cu+HsHt"HCHHHH H)uHAP0   HCH;    HD$0H$   H$   DGHD$8HH$   HH+H$   L$   oHHu*H MHp zq    j )  H  H.x  HFHi  H;    HKQ=      HD$0L$   H$   DGHD$8H$   HL+H$   L$   HAI uHKE3IHHZH MH,p p    8i )  Oz LHu'H Ho rp     i )  }HtHpIHL$0E3HT$8HILGIHMtGHITI/mHHu'H( Ho o    h )  
I/u
IGIP0H+u
HCHP0LL$   H$   H$   H$   H$(  MtIm u
IEIP0L$   MtI.u
IVIR0IH$   H3oH   A^A\H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt+RHJ  HSf I HtHHD$@HH!  HJf Iq HtHHD$HHH   H IHD$(LL$@H
 Hl$ _y
{(     H|$HH\$@   H   H   H   H
= Hl$0HL
@ H?L HH@ HHLIH
 HL$(H
 HD$ H	 (  H Hm (f m   A  H
 t53Hz HZLHIH\$pHl$xH$   HPA_A^_HUAWHXHX3HpHxLhLH
Fk LpH{n H L5	j L=jn I HHtH ImHLd$PHu'H H)l l   5e '    HCHHBp L   MtA HHu'H| Hk Sl   d '    H+u
HCHP0H] LfHI9$  H^H  LvHHIIH)uHAP0IFMfH; uPA   H\$ HT$ L|$(IiLH   H H"k k   .d '    H;    INQ=      H\$0L|$8HAH uINE3HT$0EALHu'HN Hj %k   c '  v  H+u
HCHP0HH.u
I$HP0I.Hu
IFIP0    LH  H HH0j j   <c (       | HHu'H
 H
i tj   c '    HXE3IHILx HYgLHu'HR Hi )j   b '    H/
HGHP0IHeLHH HTi i   `b '  #  IEIH IEIFIE H IE IF IEHwe L   MtA HHub (     H HH9G  H_H  HwHHHHH)uHAP0HH0dHHua (  DH+u
HCHP0HH/u
HGHP0    HH   `a (  H H2h h   I.u
IFIP0HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0DZh H
# ` H0fHbHH9` (  [H_ HH HGLw Hw(H H H HG0H H H HG8Lt$@Ll$HLd$PH$   Ht$xH\$pMtI/u
IWIR0HHXA_][@UAVH8HBE3H;r AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH; t[HH HHu'H1 Hf g   _ F'    H@L   Mu^w_ H'  J  HIIMMu>H H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HIE HHtFLHI tH+aHCHP0Rf   ^ u'     e   ^ s'  k H   H
 LI;   HHD9   }      @t3H<$IH ug(^ c'  e   H Hd HtH/u
HGHP0HtH+u
HCHP0DGe H
 ] 5-  H/u
HGHP0L5 IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH H^a E3H\$0E3HHt$8H
] H|$@HHu2H-[ H| Hc Sd   HE \ &    HXHH
f Hsa HAL   MtA( HHu'H Hrc c   ~\ &  H  H
 IH9C   H{H   HsHHHHH)uHAP0HH^HHu\ &  uH/u
HGHP0IH+u
HCHP0HHue  HHu]H^ Hb 5c   [ &  {H]HHu[ &  H  Hyb b   HtD2HHHHubH HJb b   V[ &  H+u
HCHP0HtH/u
HGHP0Db H
{	 [ *&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*H E3HCa a   OZ a&     LHu'H Ha a   Z b&  Z  IFHHHu-H
Q L H;3 H	 Y d&    HAH;@ tWH; tNH HHuH
, H
` Y i&  ~  H@L   Mua|Y k&  Q  H3E3H@ Mu>H H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA1 HHtNH+u
HSHR0IVLI3' uH/HGHP0`X &  5  QX &  &  H
 L H1 H	 $X &     ! Ht H HH    H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$hILl$`H A^A\_^[(W &  3H H] v^   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D^ H
 V 
&H\$Hl$Ht$H|$ AVH HZ HH
U E3HHuH 7&  H   H
U HxHH5\a L5^ H-^  HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw` H+u
HCHP0HG?&  H H_\ yU \   A  H
J $H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtHq  HH [H [@SH HYHtHIq  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@M?  LbIMt4HtH*  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@I HIMtHt&DHR I HD$@HH   HHR I HD$HHHtNHH  H  IHD$(LL$@H9 Ld$ /Ly
%     H\$HH|$@   H
 H HD$0   L
* HD$(L(  H)- HD$    H	 %  OHzt}HFL
^* H
o L  HD$0H, HQ HD$(H	HD$    N %  H HCY Y   SR A  H
 !:HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HǄ$   HE3Lt$0Lt$8x"HD$0Lt$ Lt$(d"HD$ ELt$XAL$  ELt$@AEHCHu'H H.X X   :Q s$    H  LcL$  HC HD$XI$H Ld$hHD$pIL=[ IH
V K HHtH IXHHu'HG HW X   P $    HCL   H=S HMtA HHu'H HLW W   XP $  u  H+u
HCHP0HFL   HY HMtA HHu*H HV fW   O $  ME  H.u
HFHP0IL$  LcH^ I9$  HsH$  H  L{HIHIH)uHAP0MgI$H; uaH$   H$  H$   A   H$   ITHH   H HV V   O $  :  H;    IOQ=      H$   H$  H$   HA IuIOE3EAH$   HHu'H, HU V   N $    H.u
HFHP0IL$         LHu'H H+U U   7N $  T  HpIL$  H$  H IE E3II~RHHu'Hw HT NU   M $    Im uKIEIP0?H$  H,PHHu'H% H~T T   M $    H+u
I$HP0HGH" H;1  H; $  H[ HHu*H HT T   !M $  MP  H/u
HGHP0IHFL   MHAHMHtlA   HALHtXHAHmKy'H: HS T   L $    L)&u
HFHP0IL$     H.u
HFHP0I[KuI?LH H)S S   5L %  R  HOHtU~A   H'& H
  H	 
HxKHt HR KS   K $  M  H;u
Lo H_H_LkHHIE H/u
HGHP0H$  H\$@L$   MLl$xMHHL$H&  HHD$0H;tTHT$0HRHL$0HD$0H@HD$0H HD$0H@Lt$8HL$0HHD$0HHL$8HCHD$8HKH|$HHWHL$HHD$HH@HD$HH HD$HH@Lt$PH|$HHIHL$H  HHD$ H;tTHT$ HRHL$ HD$ H@HD$ H HD$ H@Lt$(HL$ HHD$ HHL$(HCHD$(HKLD$HMM HT$`HL$Hs   DBoHL$HHL$Xu2+ Ht'H HP nQ   I %%  H    HD$`LD$ HT$0HrH$   HAH   E3H^S H
L "NHHu'H HtP P   I ?%     E33Hf@H+u
HCHP0H H0P P   <I C%     L$  H$     HD$hH$  HL$pHL$XH\$@H$  HD$xHD$@H$   HH$  LHtH+u
HCHP0HtH/u
HGHP0L|$@L$  HtH.u
HFHP0MtIm u
IEIP0H$  DO gH H
H AMtI,$uID$IP0HL$XHt
H)uHAP0HtH/u
HGHP0MtI/uIGIP0LD$ MM H$  HL$ 	   DBoHL$ 覾LD$0MM H$  HL$0   DBoHL$0uAH   A_A^A]A\_^[H\$Ht$WH IHHMt-I H~Hm=uH\$0Ht$8H _HHHHH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH   H@LE3L|$`L|$hL$   L$   L|$HL|$PhHD$HL|$8L|$@THD$8L$   L|$(L$   EAW$   L$   H!Q HH
K  HHtH HDNHHu'H HL dM x  E !    HGL   HH HMtAH LHu'H9 HL M x  E !    H/u
HGHP0IFL   H/O IMtA HHu'H H.L L x  :E !  =  I.u
IFIP0ML$`  LgH I9$  LwL$`  M  H_IHHHH)uHAP0LcI$H;$ uYL$   L$   A   H$   HJHH   H	 HbK K x  nD !  \  H;"    HKQ=      L$   L$  HA IuHKE3EAH$   HHu'H HJ \K x  C "    I.u
IFIP0ML$`        
 HHu'H+ HJ K x  C 	"  ~  LpML$`  IE Lh E3HHGHHu'H H0J J x  <C "  *  H.uFHFHP0:IHEHHu'H HI bJ x  B !    H/u
I$HP0IHCH H;(  H;-   H LHu'H HxI I x  B 4"  Z  H+u
HCHP0IFH   MIHIHtjA   IHHtWIH@y'H HH }I x  B <"    M)&u
IFIP0ML$`     I.u
IFIP0M@uIAH< HH I x  A D"    HKHtR~A   H H
l H	K 
HxOAH H9H H x  EA "    H;u
Hs H{H{HwH?HHH+u
HCHP0HHD$`H$   IHt$hH$   I  HH$   3A  H H[LH$   (  {HH$   3A(  HH \H$   M   E3HH H
C DHHu'HҾ H+G G |  7@ {"  :
  E33H7H+u
HCHP0H HF eG |  ? "    H   E3HH H
C GDHHu'H@ HF G ~  ? "    E33H6H+u
HCHP0H HUF F ~  a? "  d  H5H H$p   Hu'H HF F    ? "  #  H$   H
F @HHu'Hx HE OF   > "    H@L   H6F HMtA3 HHu'H$ H}E E   > "  b  H+u
HCHP0HFH;ٳ    H; t~HH$   LHR HHu'H HE E   > "    H@L   Mu?H| HD SE   = "  
  HHMMHǄ$   H.u
HFHP0Mu?H IL|$0H9CuL;c   HCJ4L;c}zJtHI  HAHHD$0H  [ HtHH HHt *H HD D   = "  I	  H+u
HCHP0H$p  LHL;
 tRH;2 tIMIL
 H H
 H	 H/ HC D   < #  	  HH$      HT$`HL$p  HHD$HH;tTHT$HHRHL$H
HL$HHIHL$HH	HD$HH@L|$PHL$HHHD$HHHL$PHCHD$PHKH|$pHWHL$p
HD$pH@HD$pH HD$pH@L|$xH|$pHHT$hHL$p  HHD$8H;tTHT$8HRHL$8HL$8HIHL$8H	HD$8H@L|$@HL$8HHD$8HHL$@HCHD$@HKLD$pMM HT$ HL$pn   DBoHL$p  HD$ LD$8HT$HHYcLM   E3HE H
$> g?HHu'H` HA 7B   : P#    E33H1H+u
HCHP0H HuA A   : T#    IL|$ L$x  L;%   3_ HHu'Hȸ H!A A   -: q#  0  ID$H; t~H;˰ tuI HHu*Hy H@ PA   9 w#  I  H@L   MuAH? H@ A   9 y#  Iz  II$IH$   MHMu@H H9FuH;N   HFH<H;N   H|HHH$   HAHHD$ H9  H$   H$   Ht
H)uHAP0HGL   HqA HMtA^ HH   E3H@ H8=LHt~H/u
HGHP0IIH  u5I.u
IFIP0ML$`  H$   IL|$    Hڶ H3? ?   ?8 #    H H? ?   8 #    H H> c?   7 #     HtEHR HHt 'H< H> ?   7 #  z  H.u
HFHP0IL|$0H$   LcIu'H HD> >   P7 #  S  HT$pIVHXH+HHL$pAL;t|H$   HL$pzHH$   HL$p Ht'Hf H= =>   6 #    H$   HL$pHIAbL$   H$   HIUVDH$   U  Hu'H HJ= =   V6 #  Y  HD$(Hu  HHu'H H= =   6 #    HD$(HH8H)uHAP0HD$(HX8H$   HtH)P(  HMtIRD$`  Av HHu'H' H< <   5 $       ̬ HHu'H HF< <   R5 $  +  HXH\$(HHX   E3H$   HL$`L$   Ld$hL|$(AH|$ L$`  Ht$0  E3H$   HL$`L$   Ld$hL|$(AAL$`  Ht$0  H$   LH$   HtH)u
HAP0LIIAL   H; IMtA HHu'H H<; ;   H4 "  !  ML$`  Hɪ H9G   LwL$`  MttHwIHHHH)uHAP0IHf6HHu'H_ H: 6;   3 #     I.u
IFIP0ML$`  4H5HHu$H Hd: :   p3 #  LH/HGHP0H$   HT$`E3H$   L$`  AAL|$(HT$hIHtH+u
HCHP0HtH/u
HGHP0MtI.u
IFIP0HtH.u
HFHP0D/: 2 H
" IH\$(HL$`Ht
H)uHAP0HL$hHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0HtH+u
HCHP0H$   HtH)uHAP0H$   Ht(H$   HML$   L+IH腻LD$8MM H$`  HL$8׻   DBoHL$8tLD$HMM H$`  HL$H薼   DBoHL$HCHH   A_A^A]A\_^[H\$UVWAVAWH`H H3HD$XH5z WHt$PMHD$@Me  LzIMt3Ht"HtH[  Hr(Ht$PHB HD$HHjHl$@Hl$@I HIMtHt,HtCjH/ I HD$@HH   HH0 I˥ HD$HHtwHHr  HV0 I HtHHD$PHHI  H IHD$(LL$@H L|$ )y
!     Ht$PHl$@  H
 H HD$0   L

 HD$(Lx H	
 HD$    H	 !  xHBH   H   HCH 3HD$0HL
	 L< HHH HD$(HL$ LMH
 H	 H	 !  H H5 x6 r  
/ Ar  H
 `3!Hr(HB HjHD$HLD$HLHHL$XH3>H$   H`A_A^_^]H\$Ht$WH H55 HH
04 Hߣ HHtH H6HHu'H۬ H45 5 p  @. D!     H H9CuHHP HHuH
 H
4  . F!  .E3HHh2HHurHa H4 - H!  .5 p  H/u
HGHP0HtH+u
HCHP0D5 H
 - 3H\$0Ht$8H _H/u
HWHR0H+u
HSHR0HH\$0Ht$8H _@UVWATAUAVAWHl$H0  HEH$  Hy| H3HE(LHUHHL$pHME3D|$PL|$8L|$@HD$8EL|$HL;L{HD$P   AAAWEWMEHE   L}D}ID$H;ڡ tsH; tjIL|$XI] LHD$`Hu'H H3 3 i  ,      H@H   HD$hHun+      MLd$`I$L|$X3HD$hD  Hu=H< I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03Hȣ 98uIE        II HH  H@L   H.2 HMtA HH|  H/u
HGHP0HCL   Hu1 HMtAJ HH   H+u
HCHP0II HH  H@L   Ht2 HMtA HH  H+u
HCHP0    HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM=HHMtHUHtLE L+IWEH] HUHtLEL+I H  IHMxHHM<HM装 H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
h  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8H]HUHK@eHKXHUU}Lt$`L|$XLmLeHD$hyH3 H
 H	ҡ / j  &(    33B  {/ l  	(    )  b/ l  '      I/ k  '       0/ k  '       / k  '    3   . k  '    3   . k  o'    3   . k  T'    33sP H   H
 LI;   HH    }      @t3HIH    &    33C. i  HT H- MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
Z 5#H\$pc0 I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8HkMtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t! HAH;r H+Hs H'v HcHE   HE    E HUHtLEL+IVHUHtLEL+I荠LD$8MM HUHL$8C   DBoHL$8HHM(H3qH$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  Ht H3HE(LHUHHL$pHME3D|$PL|$8L|$@@HD$8EL|$HL;L{'HD$P   AAAWEWMEHE   L}D}ID$H;z tsH; tjIL|$XI LHD$`Hu'HY H* 0+ W  #     H@H   HD$hHun#     MLd$`I$L|$X3HD$hD  Hu=Hܘ I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03Hh 98uIE        II4 HH  H@L   H) HMtA+ HH|  H/u
HGHP0HCL   H) HMtA HH   H+u
HCHP0II HH  H@L   H* HMtA HH  H+u
HCHP0   : HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM=HHMnHUHtLE L+I舭WEH] HUHtLEL+Ic] H  IHMHHM}HMC}- H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
a  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8mLH HD$ LHUHL$8H]HUHK@uHKXHUtLt$`L|$XLmLeHD$hyH*+ H
 H	r 8' X      33B  ' Z   @   )  ' Z   ?     & Y  w -      & Y  ^ *      & Y  E (   3   & Y  * %   3   & Y   "   3   f& Y       33s H   H
P LI;   HH    }      @t3HIH+       33% W  H HM% MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
 H\$pcГ I.u
IFIP0HD$8H\$pH;t>HHRHzHH@HH HH@HC    DD$0HT$8H+dMtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   HE    E HUHtLEL+IHUHtLEL+IݨLD$8MM HUHL$8ӧ   DBoHL$8耓HHM(H3H$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH  HEHX)p)xHk H3HELL3H|$PH|$XHD$PH|$@H|$HHD$@H|$`H|$hHE   H}@}DH|$0L;=( uEL H8 H
 H	 H) H"  # 	   m  VY  L-:  H I HHu7l HuI'Hә H," " 	  8 o   Y  HHDu$" Hts" 	   q  tI  H/u
HGHP0E,$L;=9 u>H H
 H	 HA H! " 
   ~  nX  Hz# Iz  HHu'H H\! ! 
  h   0X  H#Du$U Ht! 
  4   H  H/u
HGHP0El$L;=k u>HZ H
ː H	 Hs H  J!      W  Hl I  HHu'H5 H  !      bW  HHMaHHM%vHMuv Ht    U   G  H/u
HGHP0IL$HEH;tIE3HUڱL;=s u>H H
ӏ H	" H{ H R       V  Ht I  HHu'H= H        jV  H H;uA   (HDy   f   F  H/u
HGHP0E  H
!# HHu'H H  
     U  H@L   H HMtAh LHu> 
     0U  H+u
HCHP0IFL   H]! IMtA HHu'H H\  
  h   T  I.u
IFIP0E3L;= u0H H
 H	P  
     T  H  I  LHu^ 
     PT  3HL$0LkHm I9E   LCLD$0M  H{I HHHH)uHAP0LD$0LoIE H; u\LD$pLt$xA   HT$pHHHu 
  M   S  HL$0H)uHAP03HL$0  H; uZHOQ=   uGLELuHA t3HOE3EAHUHHu> 
     0S      HHu'H
- H
  
     S  HL$0HH3HL$0Lp E3E3HHHHu 
  L   R  H.uEHFH9IHHHu 
     uR  I.u
IFIP0H+u
IE HP03HGH H;   H;?    HЋ LHu 
   
  3C  H/u
HGHP0IFH   E3IH3HtPDnIHHt?IHy 
  :   Q  M).   IFI   I.u
IFIP0E3 uIZ 
     LQ  HOHtF~A   H H
 H	 
Hx 
     3B  H;u
Hw H_H_HsHHHH/u
HGHP0H\$`Ht$hHHMHHL$Ph_LEMM HT$8HM@   DBoHMHHMHHL$@\LEMM HT$8HM
   DBoHM諉IL$(HT$Pl_IL$8HT$@
]L;= u@H H
f H	 H Hg    s X  3
P  H IE  HHu)Hΐ H'    3 Z  3O  Hň H9GuwH (=+ f.z*u( HtO    \  33I@  H/u
HGHP0At$HL;= u@H} H
n H	 H Ho    { i  3O  H IM  HHu)H֏ H/    ; k  3N  HHM HHMmHM+m Htf    m  33`?  H/u
HGHP0IL$XHEH;tIE3HUuL;= u@H H
n H	 H Ho    { z  3N  H IM  HHu)H֎ H/    ; |  3M  H$Àu($ Htu    ~  33o>  H/u
HGHP0A\$xL;=6 u@H} H
 H	 H> H       3=M  H Iu  HHu)H HW    c   3L  HLÀu(L Ht   +   33=  H/u
HGHP0A\$yL;=^ u@HͰ H
 H	
 Hf H =      3eL  H] I蝸  HHu)H& H       3%L  H@L   H HMtA߅ HHu   C   3<  H/u
HGHP0H$ Ht'H H g   
   K  H.u
HFHP03A\$|L;=* u>H H
 H	ل H2 H 	   
   3K  H3 Ik  HHu'H HM    Y
   J  HHM HHMiHMKi5 Ht'H H x   
   J  H.u
HFHP03I$   HEH;tIE3HU膥L;= u>Hޮ H
 H	΃ H' H       (J  H I`  HHu'H HB    N   I  H9Àu29 Ht'H H |   
   I  H.u
HFHP03A$   L;=< u>H# H
 H	 HD H       EI  H= I}  HHu'H H_    k   I  H
W HHu'Hˉ H$    0   H  H@L   H! HMtA HHu\   
   Z9  H/u
HGHP0A   HH HHu   
   H  H.u
HFHP03H+u
HCHP03HnDy   [
   8  H/u
HGHP0E!  L;= u>H H
 H	= H H m   	   G  H Iϳ  HHu'HX H /   	   YG  H! H  HHu   	   7  H/u
HGHP0H
 H~ HHu   K	   F  H+u
HCHP03HDu$& Htw   	   u7  H/u
HGHP0E$   L;=9 u>Hp H
 H	 HA H       BF  H Iz  HHu'H H\    h   F  H H} HHu   7   6  H/u
HGHP0H; Hj} HHuh    	  WE  H+u
HCHP03H_Du$ Ht"       6  H/u
HGHP0E$   L;=~ u>HC H
D~ H	~ H HE    Q   D  HM I%  HHu'H H       D  Hw HV| HHuT      R5  H/u
HGHP0H H| HHu       D  H+u
HCHP0HGL   H
 HMtA} HHu
   K #  4  H/u
HGHP0H6.~ Ht
   
 &  nC  H+u
HCHP0A$   L;=A} u>HȨ H
| H	| HI H  
    3  JC  H I肯  HHu'H Hd    p 5  C  H Hz HHu   ? 7  B  H+u
HCHP0Hc Hrz HHup    :  n3  H/u
HGHP0Hiu$| Ht-    =  B  H+u
HCHP0A$   L;={ u>H H
O{ H	{ H HP    \ J  A  HX
 I0  HHu'H H     L  A  H
 Hay HHu_    N  NA  H+u
HCHP0H
 H y HHu    Q  2  H/u
HGHP0Hu${ Ht
   i T  @  H+u
HCHP0A$   L;=z u>Ht H
y H	Lz H H	 |
   
 a  @  H Iެ  HHu'Hg H	 >
    c  h@  H0 Hx HHu
    e  ?  H+u
HCHP0H Hw HHu	   Z h  0  H/u
HGHP0H5@@u$3z Ht	    k  s?  H+u
HCHP0A$   L;=Fy u>HE H
x H	x HN H %	     x  O?  H
 I臫  HHu'H Hi     u z  ?  H
 Hv HHu    D |  >  H+u
HCHP0H Hwv HHuu       s/  H/u
HGHP0Hnu$x Ht2        !>  H+u
HCHP0A$   L;=w u>H H
Tw H	w H~ HU  !  a    =  H]	 I5  HHu'H~ H  !  #    =  H	 Hfu HHud !     S=  H+u
HCHP0H H%u HHu# !     !.  H/u
HGHP0Hu$w Ht !  n   <  H+u
HCHP0A$   L;=v u>H H
v H	Qv H} H  "     <  H I  HHu'Hl} H C "     m<  H5 Ht HHu "     <  H+u
HCHP0H  Hs HHu "  _   ,  H/u
HGHP0H:@@u$8v Ht "     x;  H+u
HCHP0A$   L;=Ku u>H¡ H
t H	t HS| H * #     T;  H I茧  HHu'H| Hn  #  z   ;  H Hr HHu #  I   :  H+u
HCHP0H
  H|r HHuz #     x+  H/u
HGHP0Hs H9CusHNt (f.z&u$t Ht #     
:  H+u
HCHP0A$   L;=s u>H} H
>s H	s Hz H?  $  K   9  HG I  HHu'Hz H  $  
   9  Hq HPq HHuN $     =9  H+u
HCHP0H Hq HHu
 $     *  H/u
HGHP0Hr H9CusHr (f.z&u$`s Ht $  ?   8  H+u
HCHP0A$   L;=qr u>H8 H
q H	 r Hyy H P %     z8  H I貤  HHu'H;y H  %     <8  H Ho HHu %  o   7  H+u
HCHP0Hs Ho HHu %  .   (  H/u
HGHP0Hp H9CusHtq (f.z&u$q HtD %     37  H+u
HCHP0A$   L;=q u>H H
dp H	p Hx He    &  q   
7  Hm IE  HHu'Hw H'    &  3   6  H Hvn HHut  &     c6  H+u
HCHP0HV H5n HHu3  &   	  1'  H/u
HGHP0Hlu$p Ht &  ~   5  H+u
HCHP0A$   L;=o u>Hɜ H
o H	ao Hv H  '     5  H I  HHu'H|v H S '     }5  HE H$m HHu" '     5  H+u
HCHP0H Hl HHu '  o    %  H/u
HGHP0Hu$Mo Ht '  , #  4  H+u
HCHP0A$   L;=`n u>H H
m H	n Hhu H ? (   0  i4  H I衠  HHu'H*u H  (   2  +4  H Hk HHu (  ^ 4  3  H+u
HCHP0Hj Hk HHu (   7  $  H/u
HGHP0Hu$m HtL (   :  ;3  H+u
HCHP0A$   L;=m u>Hu H
nl H	l Ht Ho  )  { G  3  Hw IO  HHu'Hs H1  )  = I  2  H Hj HHu~ )   K  m2  H+u
HCHP0H` H?j HHu= )   N  ;#  H/u
HGHP0HOk H9CusHl (f.z&u$l Ht )  o Q  1  H+u
HCHP0A$   L;=k u>H0 H
k H	Pk Hr H  *   ^  1  H
 I  HHu'Hkr H B *   `  l1  H4 Hi HHu *   b   1  H+u
HCHP0H# Hh HHu *  ^ e  !  H/u
HGHP0HCL   HO HMtAj HHuz *   h  i0  H+u
HCHP03HDj Ht9 *   k  7!  H/u
HGHP0E$   L;=i u>H H
[i H	i Hq H\  +  h x  0  Hd I<  HHu'Hp H  +  * z  /  H Hmg HHuk +   |  i   H/u
HGHP0H H,g HHu* +     /  H+u
HCHP03H:h H9GuwHh (f.z&u${i Ht +  Z     H/u
HGHP0A$  L;=h u>Hk H
g H	;h Ho H k ,     .  H I͚  HHu'HVo H - ,     W.  H He HHu ,       H/u
HGHP0H He HHu ,  I   -  H+u
HCHP03Hf H9GuwHg (f.z&u$h Ht] ,     [  H/u
HGHP0A$  L;=g u>H$ H
}f H	f H%n H~  -     &-  H I^  HHu'Hm H@  -  L   ,  H Hd HHu -       H/u
HGHP0H HNd HHuL -     ;,  H+u
HCHP0H
 QHHu -     
  H@L   H HMtAe HHu -  W     H+u
HCHP0A   HHd HHu -       H/u
HGHP0H.u
HFHP03Hݘy= -     ,+  H+u
HCHP0g  L;=d u>H. H
_d H	d Hl H`  .  l   +  Hh I@  HHu'Hk H"  .  .   *  H Hqb HHuo .     ^*  H+u
HCHP0H H0b HHu'HIk H   .     J*  H.u
HFHP03Hu$d Ht .  i   )  H+u
HCHP0A$  :*  L;=c u>H H
b H	Gc Hj H w /     )  H Iٕ  HHu'Hbj H 9 /     c)  H+ H
a HHu /     (  H+u
HCHP0H H` HHu'Hi H;  /  G   (  H.u
HFHP0H
 HHu| /  
   k(  H@L   H HMtA`b HHu6 /     %(  H.u
HFHP0A   HH]a HHu /       H+u
HCHP03H/u
HGHP0HJy'Hh H  /  *   '  H.u
HFHP03'  L;=\a u>Hۏ H
` H	a Hdh H ; 0     e'  H I蝓  HHu'H&h H  0     ''  H H^ HHu'Hg H@  0  L 	  &  H.u
HFHP0H` H^ HHu} 0     {  H/u
HGHP0H_ H9FuvHQ` (f.z4u2` Ht'H<g H  0     =&  H.u
HFHP0A$   p&  L;=_ u>Hu H
._ H	}_ Hf H/  1  ; 0  %  H I  HHu'Hf H o 1   2  %  H
 HHu'H]f H 4 1   4  ^%  H@L   HK HMtA_ HHu 1  | 6    H/u
HGHP0A   HH^ HHu 1  9 9  $  H.u
HFHP03H+u
HCHP03H Dy_ 1   <  ]  H/u
HGHP0E  L;= ^ u>H H
] H	] H(e H  2   I  )$  H Ia  HHu'Hd HC  2  O K  #  H H[ HHu 2   M    H/u
HGHP0H HQ[ HHuO 2   P  >#  H+u
HCHP03HFDu$] Ht	 2   S    H/u
HGHP0E$   L;=\ u>H H
+\ H	z\ Hc H,  3  8 `  "  H4 I  HHu'Hc H l 3   b  "  Hf H=Z HHu; 3   d  9  H/u
HGHP0H HY HHu 3   g  !  H+u
HCHP03HDu$c\ Ht 3  B j    H/u
HGHP0E$   L;=v[ u>H H
Z H	%[ H~b H U 4   w  !  H I跍  HHu'H@b H  4   y  A!  H HX HHu 4  t {    H/u
HGHP0Hp HX HHu 4  3 ~     H+u
HCHP0HGL   H$ HMtAyZ HHuO 4     M  H/u
HGHP0HZ Ht 4         H+u
HCHP0A$   L;=Y u>H H
3Y H	Y H` H4  5  @     H< I  HHu'H` H t 5       Hn HEW HHuC 5     2  H+u
HCHP0Hu HW HHu 5        H/u
HGHP0Hk@@u$iY Ht 5  H     H+u
HCHP0A$   L;=|X u>H H
W H	+X H_ H [ 6       H I轊  HHu'HF_ H  6     G  H HU HHu 6  z     H+u
HCHP0H HU HHu 6  9     H/u
HGHP0HV H9CusHW (f.z&u$W HtO 6     >  H+u
HCHP0A$   L;=W u>H H
oV H	V H^ Hp  7  |     Hx IP  HHu'H] H2  7  >     H HT HHu 7  
   n  H+u
HCHP0H H@T HHu> 7     <
  H/u
HGHP0HPU H9CusHV (f.z&u$V Ht 7  p     H+u
HCHP0A$   L;=U u>Ha H
U H	QU H\ H  8       H I  HHu'Hl\ H C 8     m  H= HS HHu 8       H+u
HCHP0H, HR HHu 8  _     H/u
HGHP0HS H9CusHT (f.z&u$$U Htu 8     d  H+u
HCHP0A$   L;=5T u>H H
S H	S H=[ H  9     >  H Iv  HHu'HZ HX  9  d      H HQ HHu 9  3     H+u
HCHP0H HfQ HHud 9     b
  H/u
HGHP0HvR H9CusH8S (f.z&u$S Ht 9       H+u
HCHP0A$   L;=R u>Hׂ H
(R H	wR HY H)  :  5     H1 I	  HHu'HY H i :       Hc H:P HHu8 :     '  H+u
HCHP0H HO HHu :       H/u
HGHP0H	Q H9CusHQ (f.z&u$JR Ht :  )     H+u
HCHP0A$   L;=[Q u>H H
P H	
Q HcX H : ;     d  H I蜃  HHu'H%X H~  ;     &  H HN HHu ;  Y     H+u
HCHP0HU HN HHu ;   "    H/u
HGHP0HO H9CusH^P (f.z&u$P Ht. ;   %    H+u
HCHP0A$   L;=O u>HM H
NO H	O HV HO  <  [ 2    HW I/  HHu'HV H  <   4    H H`M HHu^ <   6  M  H+u
HCHP0H HM HHu <   9    H/u
HGHP0Hu$O Ht <  h <    H+u
HCHP0A$   9  L;=N u>H H
M H	FN HU H v =   S    H I؀  HHu'HaU H 8 =   U  b  H
 MHHu =   W    H@L   H* HMtAM HHu =  S Y    H/u
HGHP0A   HHL HHu =   \  q  H+u
HCHP03H.u
HFHP03H׀Dy6 =   _  4  H/u
HGHP0E  L;=L u>H} H
WL H	L HS HX  >  d l     H` I8  HHu'HS H  >  & n    HJ HiJ HHug >   p  e  H/u
HGHP0H H(J HHu'HAS H  >   s  B  H.u
HFHP03H(K H9GuwHK (f.z&u$iL Ht >  H v    H/u
HGHP0A$   L;=zK u>HQ| H
J H	)K HR H Y ?       H I}  HHu'HDR H  ?     E  H HH HHu ?  x     H/u
HGHP0H HH HHu'HQ H  ?  )     H.u
HFHP03HI H9GuwHmJ (f.z&u$J Ht= ?     ;  H/u
HGHP0A$     L;=I u>Hz H
XI H	I H Q HY  @  e     H I9|  HHu'HP H  @  '     H
 HHu   mH@L   H HMtA]I HHu   4H.u
HFHP0A   HHgH HHuG    @  E3HP HZ H  H/  HGHP0  H/u
HGHP0H+u
HCHP0H(|؅y'HO H z @       H.u
HFHP03  L;=:H u>Hay H
G H	G HBO H  A     C  H I{z  HHu'HO H]  A  i     H HE HHu'HN H  A  *   
  H.u
HFHP0H& H]E HHu[ A     J
  H+u
HCHP0HFL   H HMtA/G HHu'H N Hy  A     !
  H.u
HFHP03HΗfG Ht A  E     H+u
HCHP0A$   L;=yF u>Hw H
E H	(F HM H X B       H Ix  HHu'HCM H  B     D  H HC HHu B  w     H+u
HCHP0H HC HHu'HL H  B  (     H.u
HFHP03H葛u$F HtU B     D  H+u
HCHP0A$   L;=E u>Hv H
wD H	D HL Hx  C        H IXw  HHu'HK H:  C  F   
  Hz HB HHu C     v
  H+u
HCHP0H HHB HHu'HaK H 8 C     b
  H.u
HFHP03H/u$D Ht C     	  H+u
HCHP0A$   L;=C u>HTu H
C H	dC HJ H  D  "   	  H Iu  HHu'HJ H V D     	  H H'A HHu% D   	  	  H+u
HCHP0HO H@ HHu'HI HX  D  d    	  H.u
HFHP03H͘u$@C Ht D       H+u
HCHP0A$   L;=SB u>Ht H
A H	B H[I H 2 E     \  H It  HHu'HI Hv  E       H H? HHu E  Q      H+u
HCHP0H H? HHu'HH H t E   #    H.u
HFHP03Hku$A Ht/ E   &    H+u
HCHP0A$   L;=@ u>Hr H
Q@ H	@ HG HR  F  ^ 3    HZ I2s  HHu'HG H  F    5    HT Hc> HHua F   7  P  H+u
HCHP0H3 H"> HHu'H;G H  F   :  <  H.u
HFHP03H	u$|@ Ht F  [ =    H+u
HCHP0A$   L;=? u>Hq H
> H	>? HF H n G   J    H Iq  HHu'HYF H 0 G   L  Z  H H= HHu G   N    H+u
HCHP0Hq H< HHu'HE H2  G  > Q    H.u
HFHP03H= H9CusH> (f.z&u$? HtR G   T  A  H+u
HCHP0A$   L;=> u>HQp H
r= H	= HE Hs  H   a    H{ ISp  HHu'HD H5  H  A c    Hu H; HHu H   e  q  H+u
HCHP0HL HC; HHu'H\D H 3 H   h  ]  H.u
HFHP03Hp@@u$= Ht H  w k    H+u
HCHP0A$   L;=< u>Ho H
< H	Z< HC H  I   x    H In  HHu'HuC H L I   z  v  H H: HHu I   |  
  H+u
HCHP0H H9 HHu'HB HN  I  Z     H.u
HFHP03H: H9CusH; (f.z&u$< Htn I     ]  H+u
HCHP0A$   L;=.; u>Hm H
: H	: H6B H 
 J     7  H Iom  HHu'HA HQ  J  ]      H H8 HHu6      H+u
HCHP0H2 Hi8 HHu'HA H Y J        H.u
HFHP03HP   : H       J  E3HA Hi HtH+u
HCHP0MtI.u
IFIP0HL$0Ht
H)uHAP0HtH.u
HFHP0H
Dl H+u
HCHP0A$   HL$`Ht
H)uHAP0HL$hHtH)uHAP0HMLD$@MM HT$8HL$@K   DBoHL$@8LD$PMM HT$8HL$PL   DBoHL$PQ8HMH3RL$  I[PA(sA({IA_A^A]A\_^]HL$USVWATAUAVAWHl$HX  3LHt$(Ht$pDHt$0DHt$xD6 Hu'He? H <       h>  HD$(R6 Hu'H.? H        1>  A$H؉   HD$ 9 HHu'H> H@     L (  =     7 HHu      *  ;  HxE3H
5 H}HHu[     /  <  H+u
HCHP0H\$(LHM H\5 y     2  :  H/u
HGHP0AL$   8 HHu,H= H\$ HC     O <  <  H# LH4 y     >  :  H/u
HGHP0IL$5HHu,Hq= H\$ H C    Ѿ H  o<  He LHY4 y     J  9  H/u
HGHP0AD$H5 HHu,H< H\$ HD     P T  ;  H LH3 y      V  9  H/u
HGHP0A8t$PtH6 H H=6 H4 H H=4 Hu,HT< H\$ H &     `  R;  H LH<3 y     b  8  H/u
HGHP0A8t$xtH6 H H=6 H3 H H=3 Hu,H; H\$ H      l  :  Hl LH2 yZ     n  7  H/u
HGHP0A8t$yt~IL$X2HHu,H3; H\$ H        1:  H LH2 y    c   `7  H/u
HGHP0A8$      I$   ;2HHu,H: H\$ H v       9  H LH1 yF    Ի   6  H/u
HGHP0H
 KHHu,H$: H\$ Hx        "9  AL$|   .3 LHu'H
9 H
8     D   .8  H1 LcI9$  LkM  H{HIE HHH)uHAP0HGLgH;P4    A   LmHUL}H8HHu&       7  Im u
IEIP0LI/u
IGIP0H+u
I$HP0H
l LH|$pHHA  H\$     B   7  H;3 u]HOQ=   uJLmL}HAH uHOE3HUEAHHAN    ܹ   6     1 LHu'H
=8 H
        6  LhE3Lx IHLLHHu    e   A6  I.IFIIH跻HH       5  H@HH L   MtAu0 HHuK    ٸ   3  H/u
HGHP0A   HIr/ HHu       l5  H+u
HCHP0Hqc؅yѿ    _   V3  H/u
HGHP0l  IFIH L   MtA/ HHuH\$ n       ^5  Ld$(LH I- y9    Ƿ   2  H/u
HGHP0L   A   L$8Z/ HHuH\$     y   4  H LI- y    I   @2  H/u
HGHP0A   L$@. HHuH\$ t       d4  H6 LI, yD    Ҷ   1  H/u
HGHP0A   L$Hl. HHuH\$      (  3  H/ LI, yͽ    [ *  R1  H/u
HGHP0A   L$P- HHuH\$      4  v3  H( LI+ yV     6  0  H/u
HGHP0Lx, IH X+ yH\$ 
     @  2  A8   tH6. H H=,. H#, H H=, H\$ Hu    K I  2  H LH* y    L K  L0  H/u
HGHP0A   !, HHuG    մ U  72  H LH]* y    L W  L/  H/u
HGHP0A   + HHuѻ    _ a  1  H LH) y    L, c  L+/  H/u
HGHP0A   5+ HHu[     m  K1  H LHq) y+    L o  L.  H/u
HGHP0A   L$X%, HHu    q y  0  Hջ LH( y    L> {  L=.  H/u
HGHP0A   L$`+ HHuk       [0  HU LH( y;    LƲ   L-  H/u
HGHP0A   L$h5+ HHu       /  H LH	( yù    LN   LM-  H/u
HGHP0A   W) HHu}       m/  Ho LH' yM    Lر   L,  H/u
HGHP0A  ( HHu       .  HI LH' y׸    Lb   La,  H/u
HGHP0A  k( HHu       .  H LH& ya    L   L+  H/u
HGHP0H
 `HHuH\$        	.  A   MR( LLHu    s   O-  H& LcI9$  L{M  H{HIHHH)uHAP0HGLgH;)    A   L}HULuHhHHuV       ,  I/u
IGIP0LI.u
IFIP0H+u
I$HP0HGHH L   M   A  H;?) u]HOQ=   uJL}LuHAH uHOE3HUEAHHZ    %   ,     e& LHuk       +  LxE3Lp IHLLPHHu.       +  Im u
IEIP0LIHHH    s   O+  % HHu    L   F)  H/u
HGHP0H LHL$(# y|    
   *  HLH\$0HHu
HCHP0H
ɵ tHHu*HM, LH !       *  H@HH L   MtA% HHu۴    i   B*  H+u
HCHP0A   HI$ HHu    &    (  H/u
HGHP0HXya     	  )  H+u
HCHP0   L   A$  Mz$ HHu*H++ LH        )  Hy LHL$ " yͳ    [   4)  H+  HCHP0  H
 ɭHHu*H* LH v     *  )  H@HH L   MtAZ# HHu0     ,  (  H+u
HCHP0A   HIW" HHu    { /  u&  H/u
HGHP0HVVy    D 1  (  H+u
HCHP0tL   A$   D" HHu*H) LH۱ Y     <  '  H LHL$ m  o#     >  '  H
 8HHu*H) LHg     s R  r'  H@HH L   MtA! HHu    - T  '  H+u
HCHP0A   HI  HHu\     W  $  H/u
HGHP0HTy'     Y  &  H+u
HCHP0L   H
z %HHu*H' LHT Ұ    ` q  _&  H@HH L   MtA  HHu     s  %  H+u
HCHP0A   HI HHuI    ר v  #  H/u
HGHP0HSy     x  y%  H+u
HCHP0L^	  H
 HHu'H& H>     J   I%  A$   M LHu       #  H LgI9$  LwM  H_HIHHH)uHAP0HCLcH;%!    A   LuHULmH
HHu       "  I.u
IFIP0LIm u
IEIP0H/u
I$HP0HCHH¬ L   M  A  H;  u]HKQ=   uJLu LmHAH uHKE3HU EAHHY;    ɦ   !     	 LHu       !  LpE3Lh IHLLHHuҭ    `   ]!  I/u
IGIP0LIH谨HH       !   HHuc    L   "  H+u
HCHP0H
 LH|$x]HHu*H6$ LH 
       "  H@HH L   MtA HHuĬ    LO   L   H/u
HGHP0A   HI HHu~    L	   !  H+u
HCHP0HO؅yD    LϤ     H/u
HGHP0  H\$ LV HH< 6 y*H# LHa ߫    m   q!  Ld$(HD I<N  HHu*H" LH     '   +!  H H HHuh    L     H/u
HGHP0H LIk y%    L      H+u
HCHP0Lv  H
 HHu*H! LHN ̪    Z   Y   H@HH L   MtA HHu    L     H+u
HCHP0A   HI HHu@    Lˢ     H/u
HGHP0HMy    L   m  H+u
HCHP0#  H\$ L0 HH  y*H  LH#     /   3  Ld$(H IK  HHu*H  LHݨ [         H H HHu*    L     H+u
HCHP0H LI- y    Lr   o  H/HGHP0L4  H
r ݢHHu*H LH      *    H@HH L   MtAn HHuD    LϠ ,    H/u
HGHP0A   HIh HHu    L /  e  H+u
HCHP0HdK؅yħ    LO 1  L  H/u
HGHP0L
  H\$ L HH  y'H H _     <    Ld$(HĢ II  HHu'HE H      E    H H HHu    y G  v  H/u
HGHP0HE LI y    9 J    H+uHCHP0Ld$(H\$ IHV L   Hv Hϥ M    ۞ g    H
ǣ bHHuH\$      z    H@HH L   MtA HHuե    c |  9  H+u
HCHP0A   HI HHu          H/u
HGHP0HHy[         H+u
HCHP0M  IFIH> L   MtA' HHuH\$          Ld$(LH I	 yä    Q   '  H+u
HCHP0L   A   L$h HHuH\$ u       e  H LI yE    Ӝ     H+u
HCHP0A   L$`m HHuH\$          HH LI yΣ    \   2  H+u
HCHP0A   L$X HHuH\$        w  H LI yW         H+u
HCHP0A   L$P HHuH\$           H LI& y    n   D  H+u
HCHP0A   L$H HHuH\$     '     H{ LI yi         H+u
HCHP0A    HHuH\$ $         H LI: y       X  H+u
HCHP0A8   tH
 H H H H H HuH\$     "     Hn LI yd         H+u
HCHP0A   L$@ HHuH\$        
  H LI3 y    {   Q  H+u
HCHP0A    HHuH\$     6     H LI yx         H+u
HCHP0H
Ҟ }HHuH\$ 6    Ę   &  A   Mo LHu         H LgLI9$  LoM  H_HIE HHH)uHAP0HCLcH;    A   LmHUL}H脝HHur          Im u
IEIP0LI/u
IGIP0H/u
I$HP0HCHH9 H\$0L   M  A  H;U u]HKQ=   uJLm L}(HAH uHKE3HU EAHHT    ; #  5     { LHu     *    LhE3Lx IHLLfHHuD    Җ 0    I.IFIIH$HH          HHuH\$ ҝ    ` @    Ld$(LHd I y    + B    H+u
HCHP0H\$ I$IMtI,$uID$IP0HtH+u
HCHP0HL$pHt
H)uHAP0HL$0Ht
H)uHAP0HD$xHtH(u
HPHR0HHX  A_A^A]A\_^[]H
p HHuH\$ Ĝ    R V    H@HHߝ L   MtA HHu~     X    H+u
HCHP0A   HI HHu;    ɔ [    H/u
HGHP0H?y     ]  h  H+u
HCHP0  IFIH L   MtA HHuH\$     / h    H|$(LH H	 yl     j    H+u
HCHP0L   A$   L$8 HHuH\$      t  
  H' LH3	 y    { v  Q  H+u
HCHP0A$   M HHuH\$     4     HH LH yv         H+u
HCHP0A8$   tH H H H{	 H Hq	 HuH\$          HW LH+ y    s   I  H+u
HCHP0H
 HHuH\$     1     A$   M	 LLHun         H LgI9$  LM  H_HIHHH)uHAP0HCLcH;	    A   L}0HU0Lu8HHHuߘ    m   j  I/u
IGIP0LI.u
IFIP0H/u
I$HP0HCLH HH\$0L   M   A  H;
 u]HKQ=   uJL}@LuHHAH uHKE3HU@EAHHR             LHu    z   w  LxE3Lp IHLLєHHu    =   :  Im u
IEIP0LIH茒HHf       
  i HHu*HZ LH .         Ld$(LH I? y       `  H+u
HCHP0H
 HHu*H
 LH-     9   8  H@HH L   MtA HHue         H+u
HCHP0A   HI HHu"       	  H/u
HGHP0H9y    y   R  H+u
HCHP0FH
 HHu*H LH     #   "  H@HH L   MtAy HHuO    ݍ   
  H+u
HCHP0A   HIv HHu         H/u
HGHP0Hu8yՔ    c   <
  H+u
HCHP0{  H      a HHu*H LH v       
  HX LI yF    Ԍ   	  H+u
HCHP0    HHu*H" LHx        	  Hx LI yƓ    T   -	  H+u
HCHP0   a HHu*H
 LH v       	  H LI yF    ԋ      H+u
HCHP0    HHu*H"
 LHx      *    H  LI yƒ    T ,  -  H+u
HCHP0   a HHu*H	 LH v     6    H` LI  yF    Ԋ 8    H+u
HCHP0    HHu*H"	 LHx      B    H LI  yƑ    T D  -  H+u
HCHP0   a HHu*H LH v     N    H  LI  B    Љ P    H
d WHHu*H0 LH      d    H@HH L   MtA  HHu    L f  %  H+u
HCHP0A   HI  HHu{    	 i    H/u
HGHP0H3yD    ҈ k    H+u
HCHP0H        HHu*H LHg     s v  r  Hǌ LI  y    C x    H+u
HCHP0   P  HHu*H LH e         H LI{  y5    Ç     H+u
HCHP0     HHu*H LHg     s   r  HO LI  y    C     H+u
HCHP0   P  HHu*H LH e         H LI{  y5    Æ     H+u
HCHP0     HHu*H LHg     s   r  Hϐ LI  y    C     H+u
HCHP0   P  HHu*H LH e         H LI{  1         H
 FHHuH\$          H@HH" L   MtA  HHu    G     H+u
HCHP0A   HI  HHuOv       LLH\$ Hr Hˋ H  H/  HGHP0  H/u
HGHP0H/y	       m  H+u
HCHP0Ld$(_L IH   yH\$     A     L  IH[   yH\$ z       j  L   A$     HHuH\$ =    ˃   -  H|$ LH HN  y       oH+u
HCHP0A$     HHuʊ    HU      H LH  yY    %   LLH H HtH+u
HCHP0H\$ MtjI/udIGIP0XH+u
HCHP0Ld$(HH	 LIU         H LHh MtIm u
IEIP0MtI.u
IFIP0D H
g# I QLd$(0HUATAUAVAWHhHP  HEHXHpHx Hv H3HEHL3HL$XHL$PHL$`HL$hHE@   HM8M(HE    HMMDDDE3H˅ H
 HHu'H  Ha ߈ y   m o  d
  HHL$XL`hA$AAD$AIL$HHu'H  H  }      
  LHL;
x  t;MIL; H H
  H	  B }   Ѐ   T	  HKH)uHAP0HsIL$ $HHu'H  Hv  ~      y	  LHL;
  t;MIL H  H
  H	&   ~   :     HK H)uHAP0Hs AD$8C(3  HHu'H}  Hֆ T         H|$PI\$@I;\$H7  IE3ff     HCH+HHHD$xHLT$@D$8  DT$0HD$(LT$ A   LD$xAQH HH  H   HHHD$`Ht
H)uHAP0LLGHG HE3AL;AL9G tHHGJ4I@HGHI  tE3HI;\$H)NHX  H /    ~ 	    H1  H     ~     3  HHu'H  HS х    _~   V  I\$XI;\$`   fHEH;tIE3HHMH IE3HUHM(HE   LmDmIE3HU(HMH  HD$(HM3(  HHteHVH9V ~H HNHHJHNHHp  uH/u
HGHP0I;\$`A2    s} '    ̄    Z} %    Ht$hH
A ~HHu'H  H     } 4    H@L   HK HMtAp  LHu'Ha  H 8    | 6  h  H/u
HGHP0     HHu'H  Hp     || 9  3  HHpHD$PH HG E3HH
 ʀLHu'H
  H
     (| A    H/u
HGHP03IvH  H9  I~H  I^HHILH)uHAP0HsHH;%  u`H}L}A   HUHHHu'H  Hs     { V  !  H/u
HGHP03?  H;  uhHKQ=   uUH}L}HA t3HKE3EAHUHHuH  H i    z _       7  LHu'H
X  H
 /    z f  _  Hx3Lx E3E3IHHHu'H  Hg     sz l  *  Im uSIEIGII|HHu'H  H     )z O    I/u
IGIP0I.u	HIP0E3L|$XIO0H)uHAP0I_0I$  SHHu-HL  H #    y   E3E3M  IO@H)uHAP0I_@A$  AGHI$  HMH
a  HL$(H#  HHu-H  H&     2y   E3E3  IOPH)uHAP0I_PI$  HHu-Hv  H M    x   E3E3w  IOXH)uHAP0I_X3  HHu-H$  H}     x   E3E3%  I$  I;$    HEH;tIE3HHMH IE3HUHM(HE   HE    E IE3HU(HMH  HD$(HMO"  LHt^HNH9N ~H HFL4HAHFIH  u#I.u
IFIP0I;$  :   w   
w   E3E3~    H  HI~ H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0MtI/u
IGIP0MtIm u
IEIP0De~ v H
x SF3L|$XIO`H)uHAP0Iw`IIMtI/u
IGIP0HL$PHt
H)uHAP0HL$`Ht
H)uHAP0HL$hHtH)uHAP0LE IrIHUHE    HE    E HM(QHHMHH3L$P  I[8Is@I{HIA_A^A]A\]@SH HC  HH HI`H)uHAP0H%  HC`3H [@SH H  HH HI`H)uHAP0H  HC`3H [H\$WH LJHL;
  HtrH;  tiH
  L MIH H	  H  H| | [   u     H
 A[   _DH\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH H  HH HIXH)uHAP0H  HCX3H [@SH Hs  HH HIXH)uHAP0HU  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH Hs  HH HIPH)uHAP0HU  HCP3H [@SH H3  HH HIPH)uHAP0H  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0H{  H)t$ H9BurH5  (f.5j zTuR  HtGH  Hux x X   q     H
 AX   @(t$ H0[sH3(t$ H0[KH(AHI  Hu;H  Hw dx X   p     H
 AX   C@3H(H(AH  Hu;H-  Hw x X   p     H
^ AX   ?3H(@SH H  HH HI@H)uHAP0H  HC@3H [@SH Hs  HH HI@H)uHAP0HU  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH Hs  HH HI8H)uHAP0HU  HC83H [@SH H3  HH HI8H)uHAP0H  HC83H [H\$WH LJHL;
`  HtrH;  tiH
C  L MIH H	8  H  H2u u V   >n A  A  H
Z AV   =H\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H  HH HI0H)uHAP0H  HC03H [@SH H  HH HI0H)uHAP0H  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H  H)t$ H9BurH  (f.5څ zTuR   HtGH  Hr cs T   k     H
]	 AT   B;(t$ H0[s(3(t$ H0[KH(A(  Hu;H  HVr r T   bk z  z  H
 AT   :3H(H(A(Y  Hu;H  Hq tr T   k z  z  H
 AT   S:3H(@SH H#  HH HI H)uHAP0H  HC 3H [@SH H  HH HI H)uHAP0H  HC 3H [H\$WH LJHL;
  HtrH;  tiH
  L MIH9 H	  H  Hp `q S   i -  -  H
J AS   ?9H\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH H  HH HIH)uHAP0Hu  HC3H [@SH HS  HH HIH)uHAP0H5  HC3H [H\$WH LJHL;
   HtrH;  tiH
c  L MIH H	X  H  HRo o R   ^h 
  
  H
 AR   7H\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;Q  AE3H;  A3H;6  DEuH  DEEtRf  HtGH  H+n n Q   7g 
  
  H
s AQ   6H\$0H _È_3H\$0H _;H(y tH  H H}  Ht  H Hj  Hu;H.  Hm n Q   f \
  \
  H
_ AQ   53H({H\$WH HH3؃uO>  HtDH  Hm m P   f 3
  3
  DCQH
g  b5H\$0H _É_3H\$0H _kH(IL$0g  Hu;H  Htl l P   e 
  
  H
l  AP   43H(H(IL$0  Hu;H  Hl l P    e 
  
  H
  AP   q43H(H\$Hl$Ht$WH Hi HH
  E333?iHHu'H8  Hk l q   d   O  HCHHg L   MtA  HHuad      H  H9C  H{H  HsHHHHH)uHAP0HHfHHuH
  H
j c   QH/u
HGHP03H+u
HCHP0     HH   c   H*  Hj k q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HWHR0Dj H
  5c 23cHLeHH6c   XH
Rb HHHHh Hp(H
D  HH
:  HH0H
/  HH
%  HH8H\$0Hl$8Ht$@H _@UAVH8HBE3H;  AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH;  t[HHP  HHu'H  H
i i m   b ;    H@L   Mu^a =  J  HIIMMu>HJ  H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HI  HHtFLHI&  tH+aHCHP0Rh n   $a j     }h n   a h  k  H   H
k  LI;   HHD9   }      @t3H&IHF  ug` X  h m   H  Hpg HtH/u
HGHP0HtH+u
HCHP0Dg H
`  R` /   H/u
HGHP0L5  IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH Hc E3H\$0E3HHt$8H
_ H|$@HHu2H-  H  HUf f f   HE ]_     HXHH
i Hc HAL   MtA  HHu'H  He pf h   ^   H  H  IH9C   H{H   HsHHHHH)uHAP0HH(aHHu^   uH/u
HGHP0IH+u
HCHP0HHue  HHu]H  H7e e i   C^   {Ha`HHu'^   H  Hd we h   HtD2HHHubHq  Hd He i   ]   H+u
HCHP0HtH/u
HGHP0De H
;  ]  -&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*Hm  E3Hc Ad i   \ V    \  LHu'H5  Hc d i   \ W  Z  IFHHHu-H
  L  H5 H	B  `\ Y    HAH;  tWH;  tNHK  HHuH
  H
c \ ^  ~  H@L   Mua[ `  Q  H3E3H@ Mu>HL  H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA  HHtNH+u
HSHR0IVLI3  uH/HGHP0Z   5  Z   &  H
  Lj  H3 H	  Z        Ht H  HH:    D  H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$h>ILl$`H A^A\_^[Y {  3H  Hx` ` i   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D` H
  'Y (H\$Hl$Ht$H|$ AVH H] HH
EX E3MHHuH  ,  H   H
W HxHH5c L5ua H-` h  HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`g  H+u
HCHP0HG4  H  H^ W W_ i   Ai   H
  E'H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtHo  HH [_H [@SH HYhHtHo  HH [H [H(HB      tHAL   MtAi  Hu;H]  H] 4^ `   V 
  
  H
^  A`   &3H({H   HD$ z  Ht
33HĈ   H(HHH}  ȅx3H(@SH H  HuJ  Hu7HӍHE  HHt#H
  HH	j  H+u
HSHR03H [H H [@WH@HD$ H\$XH
 H3HD$0HHL$(LL$xHAHyrH	HH;}HH33  E3MtA  HHAHHL$0H3H\$XH@_LAL9A ~HHAJI@HA3H%  LYE3HA EHL;AL9Y AEtHHAJICHA3H%^  HAL   MtIH%    HUHhH   HEHXHpHx H H3HEGHHM3uE   HE   Hu@uDFHD  HMsHE   Hu@uDFHs  HMNHuHE   Hu@uIE3HUHMUHE7   Hu/@uIE3HUHM0HUH   oHMuHMlHEHrPHHMH=   r<t  HAH;r  H+Hs  H'vr  HHE   HuE HEHrPHHMH=   r<t5  HAH;r%  H+Hs  H'v  HwHE   HuE A   H  HMHE   HuE A   H  HME9   E9   HE   HuE IE3HUHMHE7   Hu/E IE3HUHMHUH   HMHMޭHMԭHMʭHHMGH3L$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+HǐHCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;vQ  H    H=   r<t5  HAH;r%  H+Hs  H'v  HwH3HsHsHH\$@Ht$PH0_@SH H Hk!HHQ  \!HHn M!HHQ n%HH'  H[ H!HH  !HH" !HHQ "%HH8'  H H HH   HH  HHkP $HH&H [H%h  H(H  p HH&H(H%3  @UVWATAUAVAWH$H@  Hǅx  H$  H H3H8  LD$pHT$PHMH  L  ML  MLt$hHMWD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8MH|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
1 [  H
# M  3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM谣3H]Mt`IrAfof IHfHnflfHAfHnflfLHH;rI;s     HHI;rL%= L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH  Hӭ H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  RHj H   L   L  L   L   HUH   藡L   H   H   H   H   (E3AL}H   H   HMI+HL   H;vdM9s
HH;rbH'  HD$x3HEHEH HD$XD$`HUHL$X  H	 HD$xHMR HL$xH
   H] HE Lu(Le0HEH+HHE8HUHM@蕠LE0HU8HMX#HU8H   2ILuHU8H   HMI+HLE(H;vdM9s
HH;rbH:  HD$x3HEHEH HD$XD$`HUHL$X  H HD$xH`Q HL$xH
   L%H  LeHT$hHULmH  HEWD$PWM LmLD$PHM   HHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  H H  HE(H  HE0H  HE8H  HU@H  ˞H  HD$XL% L  HE`H   HEhH  HEpH  HUxH  H   H0  kH HH  H   HP  H   HX  H   H`  H   Hh  H  HD$XL  H   H  H   H  H   H  H  H  ^H   H  躝HZ H@  HH  HD$XL%X LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX  Ld$xH  HEHE   LmE IE3H  HMH  HD$(H  HD$ LH  L@  HT$xHHHU HtLEL+IH   Ht%L   L+IxWf   L   HMXMHU@HtLEPL+IDWfE@LmPL% Le H   Ht%L0  L+IWf   L0  H   H   Ht%L   L+IWf   L   L   L- L  H  计L  L  L  H  荡L  MtLEM+II^HtH+HLHFMtLEM+II-HH8  H3H$  H@  A_A^A]A\_^]@SH Hs` HD$0H+_` H
` HH\$0H;sSHc` HT$0H;wBH\$0H+HH;
V` u   H
8` H
4` H%` Ht9HH)H;
 ` u   H
` eH
_ Ht
HH
_ H0c HD$0H+c HHH
_ H
_ H\$0H;sSH_ HT$0H;wBH\$0H+HH;
_ u   H
_ H
_ H_ Ht9HH)H;
_ u   H
|_ H
x_ Ht
HH
i_ Hb HD$0H+b HHH
G_ H
a H\$0H;sSHwa HT$0H;wBH\$0H+HH;
ja u   H
La /H
Ha H9a Ht9HH)H;
4a u   H
a H
a Ht
HH
a HH(_ H
` H
2_ ՖH_ H
7_ H_ H
<_ H [骇HXH%^ H9^    HRH
] H\$P胆H,^ H
5a H-] HRdH-^ Lua H
N` IH\a H+HHYH;s>@ HHtH   L6a H'a IHH+HH;rH
_ HQH-_ H\$PHXWHؽ  D$(HD$0HT$83HL$ HD$8HD$@H  HD$ N  HG H8L HD$0HL$0HXH\ H9\    H\ Lj` H[` H\ H_ H_ IH+H\$PH3Ht;     HHtH   L` H` IHH+HH;rH\ H\$PH_ H\     HH\ H\ H HH\ HXH  D$(HD$0HT$83HL$ HD$8HD$@H^  HD$   H HJ HD$0HL$0LH\$WH H      ?HAH
[ H9
[ Hc[ u	H=R[ HIHH+B[ HHkHH<H;sfD  HKHHPH;wH\$0H _HZ H+Z H
[ HH+AHZ H9Z @WH H
    HHu H
  H  H	  H _H  H\$0H  H/Hu
HWHR0Hu%H
ѵ  H  H	  H\$0H _H  H9Ct9H
O  Hh  H	  H+  HCHP0H\$0H _3H  H+H_> uHCHP0HL> Hu%H
  H)  H	   H\$0H _=	  H> tA	  H+  %  
H= s4  A
   HT  H
}  DH	q  H\$0H _  u	Hr  t%H  H
=  H	4  H\$0H _3H\$0H _3H%G  H(Hu      u     H(HtIw  3H(3HtIvO   "   3  "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[HHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHHH\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=ъ      Hh)|$@)t$Pf(Z f(" fYf(%6 f(
 f\ ff(fXf~Ё  fYf@  fY fff\L$      ??f\f( fsA~$@     f(W f(fYfs4fA$fYfYfX$ fX fYfYfYfXfX ffXfY(t$P(|$@Hhf     ??f\f( fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0L9 f(5 f(fYfs4fA$fYfYfX5n fXV fYfYfYfXfX5. ffXfYf( ff ff(5 ff5 fffffff< fsA~   fA   ffs4ffYA~  fA  fYff(=. ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$P(|$@Hh     HH)|$ )t$0f(j f(R fYff(%1 f(
 fXf:	 f(f~Ё  fYf@  fY fff\L6      ??f\f( fsA~$@     f(i f(fYfs4fA$fYfYfX6 fX fYfYfYfXfX ffXfY(t$0(|$ HHfff     ??f\f( fsA~$ Li f(5 f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5^ ffXfYf( ff
 ff(5 ff5 fffffff\ fsA~   fA   ffs4ffYA~  fA  fYff(=^ ff=A fA~   fA   ff(5- ff5  A~0  fA0  fff(5L ffffYf(t$0(|$ HH     %  %  %  %  %R  %  %  %  %
  %  %  %  %  %  %  ff     @UH HE t
e HMPH ]@UH HE t
e HMp谐H ]@UH HE t
e HMP芐H ]Hp  $Hp  hHp  Hp  PHH   vHp   Hp  ,Hp  иHp  H`   İH`   HH`   HH`   H(4vH`   H@4rH`   HXvHH   rH@   }HH   }H(   t@UH HE t
e HMHuH ]@UH HE t
e HMHqH ]H8   @UH HE te H   xH ]HP   tHP  鸎H`   uH`   HtH`   HHtH`   H`tH`   HxtHP   H@   H`   HX   H   T@UH HE te HM`H   X  H ]H`   HH%  H`   HP  鸍H@   TH  阍H@  錍H`  逍H@   $H`  hH@  \Hx   DHX   8H8   ,H   TH   HDH   8H   H(H0   H0   HP   H    H@   HH   DH   $H   H   HP   HP   H@   xH@   lH(   H(   H(   TrHP  H0  鈴H0  ̋H0  pH0  鴋H0  騋H0   LH0  鐋H0  鄋HP  tH0  hH0  H0   H0  DH0   H0  ,H0   H`   THP   HDH`   8HP   H(H`   Hh   H`   HHh   H`   HHh   H`   H0H(   dHH   XH(   LHH   @H`   ,Hp   hH`   H@XH@  @UH HE te HM@H   L  H ]H@   H H%t  H0   H%  H@   ZH@  鞉HT$UH HLE0H  HMH/L HHMhHMHQHEhH   HCEhH
a  HMH3HMPHMXHE0E8HUPHM0  H& HEHA   H HMHHH   Hh   ۈHH   ߢHT$UH HLE H0 HM8_L HHMXHM8聈HEXH}pHCEXH
  HM83HM@HMHHE E(HU@HM   HY HE8A  Hx HM8H8   HX   H8   HT$UH HLE Hp HM8
LW HHMXKHM8HEXH}pHCEXH
ԧ  HM83HM@HMHHE E(HU@HM X  H HE8A  H HM8WH8   ZHX   NH8   RHp   4HP   8HT$SUH(HHMHHHPH8H;uHAH HHEHLE0I H H   L HHMP;LHHMp+HMP衆H   蔆HEpH   HCEpH
  HMP3HMXHM`H   ƅ   HUXH     H` HEPA@  HG HMPH   !HP   Hp   	HP   
H   餦H   HdH   H鄷H   H(lH   H@hH   HXkH   ?H   kHh   gH8   HH   XH   kHh   kH8   DHH   (H0   ĭH(   DH(   8HP   霭H   @UH HE0te0H   H ]H   韄H   铄H   釄H`   jH   oHT$SUH8HHǅ      Hǅ       ƅ    A4   H H   蛿H]8HH   HP@H   	Hǅ      Hǅ       ƅ    A   H׿ H   CHH   HP@H   赃H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   ԾHH   HP@H   FHg  HEH3HEPHEXH: HE8E@HUPHM8  H= HEHH
9 HMHH   H   H   Ԃ@UH HE0te0H   H ]H   雂H   鏂H   郂HH   hH   kHx   hHT$SUH8HHǅ      Hǅ       ƅ    A*   Ho H   苽H]8HH   HP@H   Hǅ      Hǅ       ƅ    A   Hǽ H   3HH   HP@H   襁H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   ļHH   HP@H   6HW  HE`3HEhHEpH* HE8E@HUhHM8ԗ  H- HE`H6 HM`H   ܀H   ЀH   ĀHp   鴀HP   騀Hp   需HP   鐀HT$UH HHǅ      Hǅ       Ep A/   H HMpûHM HHUpP@HMp:H[  HE03HE8HE@H. HE E(HU8HM ؖ  H1 HE0H5 HM0Hp   HP   Hp   HT$UH HHEh   HE`    EP A/   H2 HMPHM HHUPP@HMPxH  HE03HE8HE@Hl HE E(HU8HM   Ho HE0H<5 HM0QHP   H(   HP  ~H0  ~H0  ~H0  ~H0  ~H0  ~HP  ~HP  ~HP  ~H0  8H0  ,H0    HP  d~H`   t]H    H   xH   H@hH0  ~H0   鸦H0  }H(   }H(   }H(   }H(   }H(   }H(   }H(   }Hp  }HP  x}H  l}H  `}H  T}H  H}HP  <}Hp  0}HP  $}Hp  }HP   鼥HX   |H8   |Hx   |HX   |H8   |HX   |H8   |HX   |H8   |Hx   |HX   x|H8   l|HX   `|Hx   T|H   H   xH   lHP   THX   HHP   4HP   H$H@   H@   H    H    H   {H@   {H`   {H   t{HH   h{Hh   \{HH   D{H   8{Hp   ,{HH    {H   {H@   HH   mHH   餐H@   HP   鄐H   H   H@   H@   HHh   xzHH   lzH   `zHh   TzHH   HzHH   <zHh   0zH`   $zH   zH@   zH`    zH@   yH0   $H0   H    H     H@   yH`   yH   yHH   yHh   xyH   lyH   TyH   HyH   <yH   0yH   $yH@   XHH   锺H@   8H8   ,HX   逻HP   H0   防H    録H0   H鼲H0   H8<H0   Hp̾H0   H   鹾H    =H@   $HH   H@   H@   H ^HH   H@   H8@UH HE$t
e$HMPTH ]H   wHX   HX   H@   TH    HTH`  wH@  wH@  twH@  hwH@  \wH@  PwH@   TH@   dH@   H0]H@   HHt]H@   H`d]H@   H   `H@   H   >]H@   H   {`H@   H   HP   YH8   \H  vH  vH  tvH  \H  \vH  PvH  DvH  8vH  \H   vH  vH  vH  uH  uH  uH  8\H  uH  uH  uH  uH  uH  uH  uH  xuH  [H  `uH  TuH  HuH  <uH  0uH  $uH  uH  uH  `[H  tH  tH  tH  tH  tH  tH  [H  tH  tH  tH  |tH  ptH  dtH  XtH  LtH  ZH  4tH  (tH  tH  tH  dZH  sH  sH  sH  sH  sH  sH  ZH  sH  sH  sH  sH  tsH  hsH  \sH  PsH  DsH  8sH  YH   sH  sH  sH  rH  PYH  rH  rH  rH  rH  rH  rH  XH  rH  rH  H  lrH  `rH  TrH  HrH  XH  0rH  $rH  rH  rH   rH  qH  qH  qH  qHT$UH0HHMxJLHMpHx   @H`   WH`   DHH   WH@  SH0  dqH  XqH  LqHP  @qH  4qH0  WHT$UH0HHǅ(     Hǅ       ƅ   A   Hɹ H  UH8  HPLH  H  AHH  H:! H  ĸH  pH  pH  ypH  mpH  apHP  UpH  IpH0  VHT$UH0HHǅ(     Hǅ       ƅ   A   H H  jH0  HPLH  H  VHH  HO  H  ٷH  oH  oH  oH  oHP  voH  joH  ^oHP  RoH  FoH0  UH0  UHT$UH0HHǅ       Hǅ(      E33H  躣A#   H5 H  QH  HPLH  H  =HHX  ݉H6 HX  H  nH  nH  unH  inH  ]nHP  QnH  EnH  THT$UH0HHǅ       Hǅ(      E33H  ŢA'   H H  \H(  HPLH  H  HHH  HA H  ˵H  mH  mH  mH  tmH  hmH  \mHP  PmH  DmH  8mH  SH  SHT$SUH8HH H  OnHH   HRLHH  ]HHp  HV Hp  H  lH  lH(   lH(   lH(   |lH(   plH(   dlH(   XlH(   LlH(   @lH    HH  (lH(  lHh  lH(  lH  kH(  kH  kH(  kH(  kH(  kH(  kH(  kH(  kH(  kH(  kH(  tkH0   HP  XkH0  LkHp  @kH0  4kH  (kH0  kH  kH0  kH0  jH0  jH@   H0QH@   H  QH@   H@`TH@   HX_H@   HjH@   H(@UH HE t
e HMH`_H ]HT$UH0HHM8HPH
Z  HMh3HMpHMxHE@EHHUpHM@ހ  Hz HEhH HMhH   DPHP   8PH   |H  iH8   $L@UH HE4te4H   OH ]H   OHH   OH   H  PiH0   KHh   O@UH HE@t
e@HMxpOH ]H   鮑H  hHH   VKH`   鄙H8   8K@UH HE0te0H   OH ]H`   4H`   HpH`   HX  a]H`   Hp  GH`   H  ;]H`   H  GH`   H  uNH`   H  rJH`   H  \H@   \H    \HH   g@UH HHU@HMHZH ]@UH HHU@HMH>H ]HT$SUH8HH]PHHtJHS$HKH+H*HHLI?LHӃH    HC    HC    33)HT$SUH8HH]PHHtJHS)HKH+H*HHLI?LHcH    HC    HC    33蹮HT$SUH8HH]PHHt3HS&HLCL+IH    HC    HC    33`HT$SUH8HH]PHHt3HS%HLCL+I蚓H    HC    HC    33 H`   e@UH HEhtehHMPH   |  H ]HP   H H%0{  HX   H%{  @UH HEPtePHM@H   {  H ]H@   H H%z  H8   GHT$SUH8HH]PHHtJHS"HKH+H*HHLI?LH胁H    HC    HC    33٬HP   tHP   H DNH(   JHT$SUH8HH]`HHtJHSM'HKH+H*HHLI?LHH    HC    HC    339H@   dH(   H@   H%Jz  HT$UH HHUhHUhHӭHExHH ]HT$SUH(HH]`HCHr\HHHv{  H=   r<t{  HAH;r{  H+Hs{  H'v{  H	HC   HC    H{rH 339H(   H(   HHT$UH HHUpHHcHHA   ?w  HMH ]H(   H(   HT$UH HHUpHHcHHA   v  HH ]H(   TH(   騖HT$UH HHUpHHcHHA   v  HH ]Hh   bHH   b@UH HE0te0HMPH   Hx  H ]HP   HH%w  HP   H  aH@  aH`  aHh   H`   Hh   H`   HHh   H`   H(H(   $H(   (xHT$UH HHUPHHcHHA   ou  HH ]H(   z@UH HE t
e HM@`H ]H   $ZH   ZH
 PHh   x`HH   l`H(   H   T`H   H`H   <`H   pHP   LH   `H   `@UH HE0te0HMPH   Hv  H ]HP   H H%pu  H@   H%v  HP   VH  _Hp  _HP  _HT$UH0HH
H0]HT$UH0HH*H0]HT$UH0HHJH0]HT$UH0HHjH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH
H0]HT$UH0HH*H0]HT$UH0HHJH0]HT$UH0HHjH0]HT$UH0HHH0]H  H   JH  JH  JH0  THP  ]H  \H  鐗H  TM@UH Hp   H  2H ]H8  HRH  \H    H   CHP  8H   lCHP   RHh  QH   \H   \H  \H   $CHp  CHP  \H  \H0  \H0  8Hp  |\H0   FHp  dQH  X\Hp  EH0  BHP  BH8   BH   uHT$UH0H趾33#H8   DBH   uHT$UH0Hv33H8   BH   XuHT$UH0H633裣H8   AH   uHT$UH0H33cH  4uH  (uH8   lAH  uH  uHP   HAH  tH   0AH  ZH  ZH  AH  ZH  ZH  @H  |ZHX  pZH8  dZH  XZHx  LZH  @ZH8  4ZHX  (ZHx  ZHT$UH HH   蓩LH   H   @UH HE t
e HM0NH ]H8   YHH   DC@UH HE te H   !9H ]H0   ;H0   ;@UH HH   H   rH ]@UH HH   H   rH ]HH   XH(   XH`   H%m  HP   H%zm  @UH HEPtePHM@HP茊H ]@UH HE0te0HMPH   n  H ]HP   H H% n  H@   H%n  HP   H  *XHP  XHp  XH@   XH`   WH8   WHX   W@UH Hꋅ   t   HM(HP薉H ]@UH HX   HM@aH ]HT$SUH8HH]PHHtJHSMHKH+H*HHLI?LHsH    HC    HC    339@UH H0   H   ΓH ]@UH Hꋅ   t   HM(l  H ]H   H%Ml  @UH HEHteHHM@H   l  H ]H@   H H% l  HP   H%l  H8   dp@UH HEPtePHM@HPH ]H@   RHT$SUH(HH] HKlm  HK bm  HK(Xm  33HT$SUH8HHU0HM8eLE@HU8H33ŝ@UH HE0te0HMPH   k  H ]HP   HH%0k  HP   TH  8U@UH HE0te0H@  H   }k  H ]H@  HH%j  H@  H  TH0  THP  THp  T@UH HE0te0HM`H   j  H ]H`   HH%Pj  HP   H%j  H`   fH  JT@UH HE0te0HP  H   j  H ]HP  HH%i  HP   H%aj  HP  H  SH@  SH`  SHP   H   $@UH HE te HM0HPpH ]H0   H8  @H0  @H0   6H
O 
@UH HX   H@  H ]@UH HE te H@  HPH ]H   H1H   4@UH HE te HM0HP蠄H ]H0   H8  @H0  @H0   6H
w :@UH HX   H@  ,H ]@UH HE te H@  HPH ]H   HaH0   1@UH HE te HM`H   Lh  H ]H`   H H%tg  HP   H%h  H`   ZzH`  QH`   3HH   7H   lQHP   3@UH HE@te@H   7H ]H   3Hx   h7H  yHT$SUHHHHǅ     Hǅ      ƅ   E3H:r  H  +H   HH  HP H  PHǅ     Hǅ      ƅ   An   H  H  ЋHH  HP H  BPH   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  aHH  HP H  OHǅ     Hǅ      ƅ   A   H  H  
HH  HP H  OHǅ     Hǅ      ƅ   Ah   H  H  蹊HH  HP H  +O
 E@H^HH][H  OH  NH  NH  NH  NH  wwHH   CH  NH  5H  GwH   ;wH  4H  #wH   0H`   4H  vH  6H  H(  m6H   aH  3H  vH@   BH  MH   E4H  vH  MH  qvH  MH  	4H  MvH  3H  5vH  yMH  mMH  aMH  UMH   /H`   3H  uH  5H  HH  M5H   AH  2H  uH@   AH  LH   %3H  iuH  LH  QuH  LH  2H  -uH  2H  uH  YLH  MLH  ALH  5LH  .H   x2H  LH   @H   4H   XHx   @H   t|H   d|HP  .Hp   1H   H   0H  -Hp   1H   H   THP  -Hp   1H   lH   0H  -Hp   h1H   <H   pMH   T-H   81HX   ?H   JHx   Hx   H   TdH   HdH   0HP   0H   $dH8   0H  LJH  @JH   0H  (JH  JHh   p0H  JH  IH  IH  IH  IH  IH  IH  IH  IHp  HrH   IHp  0rH   tIHp  rH   \IH  PIH  DIH  /H   ,IH`   IH@  IH   IH  HH  HHT$UH HHp  gLHh  פHp  ZH   dbH   XbH   .HP   .H8   .H  hHH  \HH   .H  DHH  8HHh   .H   HH  HH  HH  GH  GH  GH  GH  GH  GHp  dpH   GHp  LpH   GHp  4pH   xGH  lGH  `GH  -H   HGH`  <GH@  0GH   $GH  GH  GHT$UH HHp  胖LHh  Hp  vHX   FH8   FHT$UH HHU HMP33賎HT$UH HHU HMP33胎@UH HHUPHMX_H ]HT$UH HHUPHMh
	337@UH HE0te0HMPH   X\  H ]HP   HH%[  HP   ԩH`  EH@  EH   BH   AH  tEHx   ([H  \EH   nH  DEH`   +H  'H@   +@UH HE\te\H   H   e[  H ]H   H H%Z  H  H%7[  H   smH  DH  [mH  OmH  DHX   DH8   xDHx   lDH   `DH8   TDHX   HDH   <DHx   0DH8   $DHX   DH8   DHX    DH(   CH(   CH(   CHp   H   H(   CH(   CH(   CH(   CH(   tCH   H  H0  H  H   tH   hH   \Hx   PHh   DHh   8H   $H   H   BH  BH  BH   BH   BH  BH  |BH   pBH   dBH  XBH   XH    XH@   H  (BH  BH  WH  WH  WH  WH  WH  jH  ((H  AH  AH  AH  AHp  AH  xAH  lAH  `AHp  TAHT$UH@HHǅ     Hǅ      ƅ   AB   H H  |Hǅ     Hǅ      ƅp   A?   H Hp  J|Hǅ     Hǅ      ƅ   } MA"Hm H  	|Hǅ      Hǅ      ƅ   E3Hu H  {H  HD$ L  Hp  H  H  1@Hp  %@H  @H  
@H   UH   UH  ?Hp  ?HT$UH@HH   fHkH@]H  iUHp  ]UH  QUHp  EUH  9UHT$UH@HD EpHH@]Hp  gHp  9?Hp  gHp  !?H  ?Hp  	?H  >H  >H  TH0  >H  >H   >HP  >H0  >H  >H   >HP  >H0  t>H  h>H   TH   TH@   H  8>H  ,>H   SH  SH   SH  SH   SH  fH  8$H   =H   =H   =H   =H  =H  =H  |=H   p=H  d=HT$UH@HHǅ     Hǅ       ƅ   AB   H H  xHǅ     Hǅ      ƅ   A?   H& H  ZxHǅ     Hǅ      ƅ    MA"H} H  xHǅ8     Hǅ0      ƅ    E3Hq H   wH   HD$ L  H  H  .
H  A<H  5<H  )<H   <H   QH   QH  ;H  ;HT$UH@HH   9H;H@]H  yQH  mQH  aQH  UQH  IQHT$UH@HT EpHH@]H  dH  I;H  cH  1;H  %;H  ;H  
;H   ;H  PHT$UH0HL   HU83H      H   HH(HH0]H0   TcH0  :H  ĜH  鸜H  鬜H  頜H0  H   鈜H   |H   pHT$UH HL   H   33-H@   H0H@   H H@   H(H@   H8 H@   HHH@   HXH@   H   9H   HH   tHX   d+H0   鄛HH   xHH   l@UH HEPtePHM@HPjH ]H@   J@UH HEPtePHM@HPjH ]H@   *@UH HEPtePHM@HPljH ]H@   1H   T8Hh   H8HH   <8H   08HH   $8Hh   8H@   DH@   8@UH HE0te0H   H   =N  H ]H   H H%eM  Hh   H%N  H   K`H  7H  7H   w7H  k7HT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   H H  rHǅ     Hǅ      ƅ    A    HG H   KrHǅ     Hǅ      ƅ   A!   H H  rHǅ     Hǅ      ƅ    MA"Ho H  qH  HD$ L   LCH  H  HHH8][H  6H   6H  6H  5H@   $H@   @UH HE0te0H   H   L  H ]H   H H%EK  Hh   H%K  H   +^H  o5H  c5H   W5H  K5HT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   H H  bpHǅ     Hǅ      ƅ    A    H' H   +pHǅ     Hǅ      ƅ   A!   HȎ H  oHǅ     Hǅ      ƅ   _ MA"HO H  oH  HD$ L   LCH  H  FHH8][H  3H   3H  3H  3HT$SUH8HH   H{  t'HM8HPHHK 螨HHfI  H7H8][Hh   餕H`   阕Hh   錕H`   H |Hh   pH`   H0`H   DH   tH@   XHX   \HX   P@UH HHU0HM8LH ]@UH HH   HM8kLH ]@UH HE4te4H   H ]H   Hx   _'H   #tH  S@UH HE4te4H   H   H  H ]H   H H%G  HX   H%^H  H   ZHT$SUH8HH  H   >Hx H  1H]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  lHH  HP H  )133FyH  1@UH HE4te4H   H   XG  H ]H   H H%F  HX   H%*G  H   fYHT$SUH8HH  H   U=Hx H  0H]8tHH   HPHǅ     Hǅ      ƅ   A   H7  H  kHH  HP H  0Hǅ     Hǅ      ƅ   A<   H  H  OkHH  HP H  /H  HHPHIH;uHAH\d HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  jHH  HP H  ,/HTH8][H  /H  /H  .HT$SUH8HH  H   ;Hx H  .H]8tHH   HPHǅ     Hǅ      ƅ   AH   H  H  iHH  HP H  W.H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  viHH  HP H  -33vH  -H  -H  -H  -H  -H  FVH  HT$SUH8HH  H  ):Hx H  U-H]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  WhHH  HP H  ,33tH  ,H  ,H  ,H  ,H  ,H  'UH  UH  _,H  S,H  G,H  ;,H  TH  #,H  THH   hH  +H  PH  +H  TH  +H  +H  +H  XTH  +@UH HEDteDH   H   A  H ]H   H H%	A  H   H%A  H   SH   3+H   H  (EH  EH8   `H  EHP   HH  *H  *H   $H  *H  *Hp    H  *H(  *H  |*H  p*HH  d*H  X*H  L*H(  @*HH  4*H(  (*HH  *H  pH  *H  )Hh  )H  )H(  )HH  )HT$UH HH   ?yLH   诅H   2H@   H   HX   鬋HX   頋H0   锋H0   鈋Hp   HT$UH0H    H7H0]H(   H   dH(   H@   @UH HꋅH  tH  HM@H   ?  H ]H@   H H%:>  H0   H%>  H@    QH@  ԫHx  
H   Hp   |HT$UHpHHBHp]H   UH   驮H   d
H   HHx   HT$UHpHH'HHp]H   H   IH   Hx  	H   
Hp   鬉HT$UHpHHLHp]H   酭H   9H   	H   x
Hx   LHT$UHpHH$QHp]H   %H   ٭H   Hp   Hp   H   H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H   H0  aH   HH0  HP H0  '&H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  FaHH0  HP H0  %HXHx][H0  %H0  %Hx   ćHx   鸇H   ܨHh  H   Hp   |HT$UHpHH\Hp]H   UH   iH   dH   HHx   HT$UHpHH bHp]H   H   	H   ͿHx  H   
Hp   鬆HT$UHpHHeHp]H   酪H   H   H   x
Hx   LHT$UHpHHkHp]H   %H   陫H   ]HT$SUHxHHǅH     Hǅ@      ƅ0   A!   Hx  H0  ^H   HH0  HP H0  W#H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  v^HH0  HP H0  "H0oHx][H0  "H0  "Hx   Hx   H   H   "H`   x"H@   l"H8    <H   锄H0   JHT$SUH(HH0  HM0.HXH0  "HtHM HHU0P33 jH  !H@  !H`  !H  !H@  !H`  !H`   ܃H`   ЃHH   ăHH   鸃H   鬃H   頃H   锃H   鈃Hx   |Hx   pH   IH   !H  !HT$UH0HMpMpp  ;|~U8Hn{ H   ""H*{ H`  "Hz H@  !HR~ H  !H   HD$ L`  LE8H@  H  2H6H0]H   P H`  D H@  8 H  , H(   tH@   xH  H   H@  H  H   H@  H   H   H8   ԁH8   ȁH`   鼁H`   鰁Hp   餁Hp   阁H   錁H   送H   GH   (H`  HT$UH0Hꋍ      0  ;|~U4Hxy H   , H4y H@   Hx H    H| H  H   HD$ L@  LE4H   H  0H!H0]H   ZH@  NH   BH  6H   t@UH HHEXD HUPHM(7H ]@UH HEPtePHM@H`OH ]H@   HH    t9H8   @UH HE t
e HMXH ]H@   餿H   锿H   tH(   dH(   XHH   LH   4@UH Hꋅ   t   HM(H`NH ]@UH Hh   HM@YH ]@UH HEPtePHM@HPlNH ]H@   麩H8   ~H8   ~H(   |~H`   tH  T~H  H~H  <~H  0~H0  4H   ~H   ~H    ~@UH HEPtePHM@H`MH ]H@   H   tH  hH8  \HX  PH0   T5H   xH   $H  H0   5H   PH(   4}H(   (}HP  ;HP  HHP  H dHP  H8HP  HPDH@   HX    H   H    H  h4H  \4H@    H  D4HX    H  H  H   d H  H  Hp   @ H  H(  H  H  HH  H  H  H(  HH  tH(  hHH  \H  H  DH  8Hh  ,H   H(  HH  HT$UH HH   hLH   tH   rHP   $H8   H@   H`   zH   <AHT$SUHHHH  H   +%Hx H  WH]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  WSHKHH  P H  HOHH][H  HT$SUHxHHǅH     Hǅ@      ƅ0   A!   HH  H0  RH   HH0  HP H0  7H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  VRHH0  HP H0  HCTHx][H0  H0  Hx   xHx   xH   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H@  H0  QH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  &QHH0  HP H0  H#XHx][H0  |H0  pHx   wHx   wH   鼘HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H8  H0  lPH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  OHH0  HP H0  hH\Hx][H0  LH0  @Hx   tvHx   hvH   錗HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H0  H0  <OH   HH0  HP H0  H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  NHH0  HP H0  8H_Hx][H0  H0  Hx   DuHx   8uH   \HT$SUH8HH]PHHtJHSHKH+H*HHLI?LHC/H    HC    HC    33ZHT$SUH8HH]PHHt3HSHLCL+I?H    HC    HC    33@ZH
q HHX   HX   HX   Hx   H   HX   Hx   H   H
 `HH8   H+Hh   |Hh   pHh   dH   XH   LH   @H   4Hh   (H@   \sH
U GHX   HX   HX   Hx   H   HX   Hx   H   H
 `GH    H*Hh   |Hh   pHh   dH   XH   LHh   @H@   trHh   H
 FH0   )H   H   H   H   H   H   H@   鄗@UH HHU`HMPZ)H ]HT$UH HHU`HMh33W@UH HHU`HMP)H ]HT$UH HHU`HMh*33WWHT$SUWH0HH   HO@HO HK33W@UH HHUXHMP(H ]HT$UH HHMhK33VHT$SUWH0HH   HO@HO HPK33V@UH HHU`HMP(H ]HT$UH HHU`HMh33WV@UH HHUHHMP'H ]HT$UH HHM@J33V@UH HHUHHMP'H ]HT$UH HHM@J33UH
 pDHP   
Hp   
H   
HP   t
H   h
Hp   \
HP   P
HP   D
H(   toH(   hoH   &HT$UH Hzn33'UH   ԔH0   H%^#  HT$UH HH^H ]H`   HH   Hx   HX   nHP   nH@   5H0   d&H   oH   oHT$UH HHMHHt
H   33-THT$UH HHMHHt
H   33SH
 BH8   H8   H8   HX   Hx   H8   |HX   pHx   dH
  BH8   HH8   <H8   0HX   $Hx   HX   Hx    H8   
H
 AH8   
H8   
H8   
HX   
Hx   
H8   
HX   
Hx   
H
q @AHP   h
HP   \
HP   P
Hp   D
H   8
HP   ,
Hp   HP   tH
 @HP   	HP   	HP   	Hp   	H   	H   	Hp   	HP   	HT$SUWH0HH   HO@!HO x	H@F33QHT$SUWH0HH   HO@QHO 8	H F33MQ@UH HHE(D HUxHM0"H ]HT$SUWH HH]pH   H;t-Hf     HK>   H5   H[(HCH;u33PH  @UH HEPtePHM@HP\:H ]H@   @UH HEPtePHM@HP:H ]H@   ZH   DH   4jH   H$jH8   4HP   8Hh   d
@UH HEPtePHM@HP|9H ]H@   lHH   iH   HiH@   DHH   H@   $HH   x@UH HEPtePHM@HP8H ]H@   :jH   H  H8  HX  H0    H   kH   $	Hh  
H@   	H8   
H   thH(   d
Hh   ThHh   HhH   @UHH3Ɂ8  ]@UH HM@H ]A@UH H@M8H ]A@UH0HHHL$(T$ L
BLEpUhHM`??H0]HH   @UH HE te H   H ]H0   H`   H0   @UH HE te H   dH ]H    @UH HE8t
e8HMXH ]H`   H   @UH HE te H   !H ]HX   H@   H   H0   @UH HE te H   H ]@UH HE te H   H ]HX   MH@   AH   5H0   )@UH HE te H   H ]H0   @UH HE te H   H ]@UH HE t
e HM@KH ]HP   9H   -Hx   !HP   H   	Hx   H(   H@   H(   H@   }HP   H   Hx   HP   H   Hx   HP   yH   mHx   aHH   UH0   IHp   =H@   1H    H   Hp   mH0   3H    3H   IHh   =HP   1HT$UH@HOH $  Hy     
=  HrH@]H   H   Hp   HX   HT$UH HNH#  H     56  HH ]HX   qH@   eHT$UH HSNHT#  H +    t5  HH ]H0   G2H    k2@UH H  HM`l=H ]HT$UH HMH"  H6    B *%  H[H ]HH   1H8   1H   (@UH H  H   <H ]HT$UH HVMHW"  H . y   W"  H`pH ]@UH H(  H   <H ]HT$UH HLH!  HN ̪ z  Z f"  HoH ]@UH H  HM %<H ]HT$UH HLH!  H m    ;#  HmH ]HT$UH HSLHT!  H +    #  HzmH ]H8   w0@UH HEPtePH   T0H ]H   "H   vH8   /@UH HEPtePH   /H ]H   EH   )HP   /H@   /H   H(  H  HT$UH HHM(HPHH
L  H	  HBKH ]HT$UH HHM0HPHH
C  H	  H	KH ]HT$UH HHM8HPHH
  H	Y  HJH ]HT$UH HHM@HHPHSH;uHAH1 HHEHH
  H	  HtJH ]HT$UH HHMHHHPHH;uHAHw1 HHEHH
z  H	  HJH ]HT$UH HHMPHPHH
!  H	h  HIH ]HT$UH HHMXHHPLr I;uHAH0 HHEHH
}  H	  HIH ]HT$UH HHM`HHPHH;uHAH0 HHEHH
	  H	  H'IH ]HT$UH HHMhHHPLj  I;uHAH*0 HHEHH
  H	T  HHH ]HT$UH HHMpHHPL
 I;uHAH/ HHEHH
9  H	  HoHH ]HT$UH HHMxHPHH
  H	  H6HH ]HT$UH HH6  H
M  H	  HHH ]H(   i@UH HE t
e HM0eH ]HX   7H8   +H   HH   UH8   HX   H   HH   UHH   /H   #H8   H   H  o3H  3H  W3Hp   K3H  <H  33H  H H  H8#BH  HpH  g?H   2H   H kH   H8AH   HpKH   ?H   2H   W:@UH H꺸  HMP5H ]Hp   n2Hp   ":H   V2H   H HX   :2H   H8:AH   >Hh   2Hh   H HX   1Hh   H8@Hh   J>H0   1HX   1H0   :H  1H(H=\ r_H
; vHG HH=   r<t  HAH;r  H+Hs  H'v  H34H    Hݜ     Ɯ  H(H(H=\ r_H
; HG HH=   r<tQ  HAH;rA  H+Hs1  H'v$  H3H    Hݛ     ƛ  H(]H(H=\ r_H
; 6HG HH=   r<t  HAH;r  H+Hs  H'v  H2H    Hݚ     ƚ  H(H(H= r_H
{ H HH=   r<t  HAH;r  H+Hs
  H'v
  HS2H0    H       H(H(H= r_H
{ H HH=   r<tq
  HAH;ra
  H+HsQ
  H'vD
  H1H0    H       H(}H(H=, r_H
 VH HH=   r<t  HAH;r  H+Hs  H'v  H1H    H       H(
H
A T'H
	 D'H
I H(H=  t:

L Hҵ L+I#WHȵ      H(H(H=L  t:=
8
LI H2 L+IN#WH(      H(H(H=̲  t:Lɲ H L+I"WH      H(+>H(H=  t:L	 H L+I"WH     е H(H(H=d  t:=8La HJ L+IN"WH@     ( H(H(H=  t:L H L+I!WH     p H(H
 4%H
 $%H
 H
I H
y H
i H
 H
ٯ tH
 dH
	 TH
ɳ DH
9 4H
ٳ $H(H   H B%H
 HuH(                                                                                              2     J     b     n     |                                        (     F     Z     n                                                                    R     H               b                    z     8               j          0     J     f                    &     H     b                         .     V     |                              h     B                              `     4                    N               v     <               p     4               X                    D               t     2                    D               0          X                            X     b     z                                         
     |           r     `     >                                              Z                                                                                      h     \     R     D     ,                                   L                  R     ,     v                    @          r                       "     l     6                  d                  t     b     F     2                                             j     X     J     8                                                  ~     p     \     N     8                                              t     `     F     0                                                             \     L     >     
                                        h     R     D     ,                                             t     Z     F     6     &                                        t     Z     B     ,                                                       &     6     R          d     x               $                                        $          j     8     L     b     x                                   
     \          j     J     :     "                                   ~     j     Z     F     (                        `    k           H         `             @    `                        0            P                      `                                                           0                    $2                                                           "   h\            r            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        
   9              `   (
           0           
   x@       bad array new length    0
   40   
   =   `    `    =   `    P
   d   p           OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np  7   7   7    8   ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  ImportError 0   __getstate__.<locals>.genexpr   reshape misc    num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  0   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    Stan model {} is of mode 'test_grad';
sampling is not conducted.    shape   UNIT_E  get pystan._compat  iter_save_wo_warmup upar        adapt_window    7   data sim model_name model_pars par_dims mode inits stan_args stanmodel date     stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332  init_alpha  get stan_args_method_t  b   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  B   warmup2 __str__ traceplot   method  h   int_time    range   fitptr  H   pystan.plots    _summary    NUTS    lp__    array   append  i   (dense_e)   pystan  I   stansummary l   AttributeError  gradient    order   DIAG_E  L   sampling_algo_t pars    data_args   unit_e  q   ndarray is not C contiguous Q   adapt_t0    error   vars_i  f   pars_oi_bytes   epsilon adapt_iter  d   handler tol_rel_obj user    probs   chains  g   warnings    index   metric  Zf  __import__  Zd  collections Zg  stepsize    split   holder  O   extract grad_samples    (diag_e)    OPTIM   dstack  par _get_kept_samples   format  sim _pars_total_indexes s   chain_id    utf-8   double  s   ndarray is not Fortran contiguous   chains  end model_code  end TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   'char'  '   Couldn't allocate space for StanHolder. _verify_has_samples name    LBFGS   'long'  s   Metropolis  s   output_samples  dims_oi samples pystan.constants    flush   %s  _check_pars int string_types    _remove_empty_pars  =   _call_sampler_star  #   adapt_kappa keys    send    throw   =   row_stack   #   SAMPLING    start   =   MemoryError #   squeeze seed    init_list   =   variational #   save_iterations `inc_warmup` ignored when `permuted` is True.   data    
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          =   tol_rel_grad    BFGS    init_radius #   __test__    tuple   =   `dtypes` ignored when `permuted` is False.  #   sampling    inits   =   adjust_transform    value   #   _split_data =   RuntimeError    __getstate__    VARIATIONAL #   genexpr Format string allocated too short, see comment in numpy.pxd =   variational_algo_t  #   elbo_samples    tol_param   thin    inits   =   DENSE_E refresh adapt_term_buffer       Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. #   newaxis flatnames   flat    dtype   =   getLogger   #   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    Couldn't allocate space for stan_fit.   init    sampler_params  pystan.misc warn    numpy   =   numpy.core.multiarray failed to import  digits_summary  column_stack    adapt_delta #   stepsize_jitter fnames_oi   =   sampler_t   #   control random_seed =   numpy.core.umath failed to import   #   handlers    numpy   =   (unit_e)    numpy   #   logging adapt_init_buffer   =   Non-native byte order not supported #   diagnostic_file argsptr adapt_engaged   numpy.core.multiarray   C:\Users\appveyor\AppData\Local\Temp\1\tmphq2o0npn\stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.pyx   adapt_gamma =   history_size    _call_sampler   numpy.core.multiarray failed to import  _ARRAY_API  #   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  =   _ARRAY_API is NULL pointer      numpy.core.umath        module compiled against ABI version 0x%x but this version of numpy is 0x%x      module compiled against API version 0x%x but this version of numpy is 0x%x  #   FATAL: module compiled as unknown endian        FATAL: module compiled as little endian, but detected different endianness at runtime   numpy.core.umath failed to import   =   _UFUNC_API  #   _UFUNC_API not found    _UFUNC_API is not PyCapsule object  =   _UFUNC_API is NULL pointer  #   SSE, SSE2   =   empty_nested() must be true before calling recover_memory()     empty_nested() must be false before calling recover_memory_nested() self        empty_nested() must be false before calling set_zero_all_adjoints_nested()  #   stan_version_major  =   stan_version_minor  #   stan_version_patch  =   unkown file name    numpy   #   unkown file name        C:\Users\appveyor\AppData\Local\Temp\1\tmphq2o0npn\stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.cpp   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.pyx  =   __init__.pxd    stringsource    type.pxd    ufunc   #   Unknown exception       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.__getitem__ stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.__getstate__.genexpr    numpy   =   attr_names  #   genexpr stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.__getstate__    list        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.__setstate__        Expected %.16s, got %.200s  list        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.__reduce__  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.num_failed.__get__  dict    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.num_failed.__set__  list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.test_grad.__get__   list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.test_grad.__set__   list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.inits.__set__   =   Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.par.__set__ stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.value.__get__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.value.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.args.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.mean_lp__.__get__   'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.mean_lp__.__set__   'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder.sampler_param_names.__set__ Expected %.16s, got %.200s      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._pystanholder_from_stanholder    'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._dict_from_stanargs  #   'NoneType' object has no attribute '%.30s'  =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._set_stanargs_from_dict  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._dict_to_vars_r  _call_sampler_star      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._dict_to_vars_i  dict    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._call_sampler_star   #   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._call_sampler    Expected %.16s, got %.200s  self        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332._call_sampler    __cinit__       attr_names      genexpr stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__cinit__  __init__    'int'   =   __init__    throw   #   __init__        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__init__   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__getstate__.genexpr       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__getstate__   plot        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__setstate__   plot        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__reduce__ stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.plot   =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  extract stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.plot   #   traceplot   =   traceplot       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.traceplot  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.traceplot  extract 'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.extract    'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range summary stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.extract    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__unicode__        stansummary upar        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__str__    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__repr__   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.__getitem__    throw   #   stansummary     stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.stansummary        summary stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.stansummary        grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.summary    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.summary    log_prob    close   =   log_prob        grad_log_prob   get_logposterior        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.log_prob   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.log_prob   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.grad_log_prob      get_logposterior        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.grad_log_prob      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_adaptation_info        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_logposterior   'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_logposterior   get_sampler_params  #   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_posterior_mean args    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.constrain_pars dict        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.unconstrain_pars   'NoneType' object is not iterable       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_seed   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.get_stancode       'NoneType' object has no attribute '%.30s'      numpy.ndarray.__getbuffer__ args        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.flatnames.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._verify_has_samples        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._update_param_oi   numpy._util_dtypestring stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._get_param_names   numpy.import_array      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._get_param_fnames_oi       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._get_param_names_oi        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._get_param_dims    numpy.import_array      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._get_param_dims_oi numpy.import_umath      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.constrained_param_names    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.unconstrained_param_names  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model._call_sampler  =   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew1 plot        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model.sim.__set__    %d.%d   #   numpy.PyArray_MultiIterNew2 =   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 =   numpy.PyArray_MultiIterNew5 #   Expected %.16s, got %.200s  =   numpy.import_umath  #   numpy.import_ufunc  =   numpy.import_ufunc  #   vector.to_py.__pyx_convert_vector_to_py_double  vector.from_py.__pyx_convert_vector_from_py_double      string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    #   string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  vector.from_py.__pyx_convert_vector_from_py_size_t      string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   #   string.from_py.__pyx_convert_string_from_py_std__in_string      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ data        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  #   num_failed  #   test_grad   # 
 mean_pars   #   mean_lp__   #   adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.PyStanHolder mode        Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  1.0 traceplot   1.0 extract __unicode__ 1.0 stansummary 1.0 summary log_prob    1.0 grad_log_prob   get_adaptation_info [   get_logposterior    ,   get_sampler_params  ]   get_posterior_mean  #   constrain_pars  unconstrain_pars    #   get_seed    #   get_inits   #   get_stancode    get_stanmodel   _verify_has_samples .   _update_param_oi    .   _get_param_names        _get_param_fnames_oi    _get_param_names_oi     _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel   date        cython_runtime  type    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.StanFit4Model    StanFit4Model   ndarray Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.__pyx_scope_struct____getstate__ need more than %zd value%.1s to unpack  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.__pyx_scope_struct_1_genexpr send        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.__pyx_scope_struct_2___getstate__        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.__pyx_scope_struct_3_genexpr user        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332  builtins        __builtins__    __name__        PyStanHolder     while calling a Python object  at most stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332  exactly stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332  builtins        flatiter        broadcast        while calling a Python object  %s() got multiple values for keyword argument '%U'      init stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332     init stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332     name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope      NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        at least        %.200s() takes %.8s %zd positional argument%.1s (%zd given)     %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       calling %R should have returned an instance of BaseException, not %R    %s() got an unexpected keyword argument '%U'    '%.200s' object is unsliceable  Missing type object     Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'      Expected a dimension of size %zu, got %zu       Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected     Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d    1.0 Expected a comma in format string, got '%c' 1.0 Expected %d dimension(s), got %d    1.0 Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler   1.0 Big-endian buffer not supported on little-endian compiler   1.0 Buffer acquisition: Expected '{' after 'T'  1.0 Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)       'NoneType' object is not iterable       Missing type object ,   Cannot convert %.200s to %.200s stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332  cannot import name %S   %s (%s:%d)   /  value too large to convert to int   %]  can't convert negative value to int  [  value too large to convert to unsigned int  %1% can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    error   :   can't convert negative value to pystan::stan_args_method_t  %1% value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   %1% value too large to convert to pystan::optim_algo_t  :   can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    model   %1% can't convert negative value to pystan::variational_algo_t  :   value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  %1% can't convert negative value to long    _cython_0_27_1  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing :   can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object %1% _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   collections.abc close() -> raise GeneratorExit inside generator.        if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections nan Cython module failed to register with collections.abc module    Cython module failed to register with collections module    value   NAN backports_abc   send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    0.1e1   %1% gi_running  :   gi_yieldfrom    object being iterated by 'yield from', or None  __name__    0.1e1   %1% name of the generator   __qualname__    qualified name of the generator generator       %.200s.%.200s is not a type object      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332  an integer is required  compiletime version %s of module '%.100s' does not match runtime version %s     %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    0.1e1   %1% boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.   :   grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    %1% Argument n out of range: got %1%    0.1e1   %1% boost::math::prime<%1%> is not converging   :   grad_reg_inc_gamma  1.0 is not converging   0.0 grad_reg_inc_gamma  1.0  iterations, gamma function gradient did not converge.  exceeded    1.0 k (internal counter)    grad_reg_inc_gamma  1.0 grad_2F1         iterations, hypergeometric function gradient did not converge. exceeded    1.0 k (internal counter)    grad_2F1        Output generated by Stan (test_grad)    Must use algorithm="Fixed_param" for model that has no parameters.  0.0 Point Estimate Generated by Stan    0.1e1   1.0 Sample generated by Stan    0.1e1   0.0 Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    1.0 Sample generated by Stan    0.0 Sample generated by Stan (Variational Bayes)    stepsize__  1.0 treedepth__ 1.0 n_leapfrog__    divergent__ 1.0 energy__    1.0 stepsize__  1.0 int_time__  1.0 energy__    1.0 # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    1.0 boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    0.0 boost::math::cbrt<%1%>(%1%) 1.0 0.003379167095512573896158903121545171688   0.0 0.0834305892146531832907    1.0 -0.338165134459360935041    %1% -0.0509990735146777432841   :   -0.00772758345802133288487  %1% -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    :   0.00858571925074406212772   %1% 0.000370900071787748000569      -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   TEST GRADIENT MODE      Initial log joint probability =         Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  lp__    but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        . Improved by    Log joint probability =        Iteration       Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated normally:       Optimization terminated with error:     Initial log joint probability =     lp__            Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated normally:       Optimization terminated with error:     lp__    lp__    0.003379167095512573896158903121545171688       0.0834305892146531832907        -0.338165134459360935041        -0.0509990735146777432841       -0.00772758345802133288487      -0.000322780120964605683831     0.455004033050794024546 0.0875222600142252549554        0.00858571925074406212772       0.000370900071787748000569      -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)             Argument a to the incomplete gamma function must be greater than zero (got a=%1%).              Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   0.9016312093258695918615325266959189453125e-19  0.25479851061131551     -0.32555031186804491    -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).           Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)          Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.            Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:          Log probability evaluates to log(0), i.e. negative infinity.    Stan can't start sampling from this initial value.    Rejecting initial value:          Gradient evaluated at the initial value is not finite.          Stan can't start sampling from this initial value.     seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps        Adjust your expectations accordingly!    attempts.      ) failed after  Initialization between (-                Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization failed.   Log probability=       finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       Exception initializing step size.       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)          The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)          Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.          The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function               boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04               Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       -3.7595974497819597599e+11      7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "                @ (          "                (          "               0 P          "   ́                       "   T            d (          "               Ђ           "   8            H (          "                (          "                8          "   X            p h          "   Ԇ             h          "   <            L            "                           "                h          "   l             h          "                 h          "   X            h (          "   ؉         	              "   x         
              "   0    X              "   Ѝ         (           "        
   ,           "   `        ȓ           "                       "   l         
              "            
   <           "   Ę            ܘ           "   X            h           "   4    D    H            "                           "	   T             (          "   <            D (          "%            '    x                               
   @      Н                    ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx   @   D   `    `    P   @   >   0      
          
       h
           
    M    `    Mb`MbPMbP?Mb`?   
       p          5          1   1   1   1   1   1   1   1   1   P         1   1                       @   >   p   p      D   D   D   D   D   D   D   D   h
    %    D   D   D   D   D   D   D   D   
   /             P   @         
      P	      `
   |/   @
                     @   >   p   p   `
       p
   U             1   1   @   0         @                         0       E   `    `       `    h
   /   
   P            
   .   H/   0   H   ]    @]       /       0
   e   p   p   `g   
   ]       X
   T    Y    p          h
             @   @            @   >      p                  `   0   @   >            `          X
   0            P           h
   -    &    '    @)    @'    0*    *    +    `,    H
           
   /    
            `    (
   \    0\    8
   6              P   @   >         
   0F   `    `       `     
   .   0   T/   `
            `   0   @   >            X
   T     U    p
   >   >   >   `    `    
           
    V       8
       p   
   0    `    `    `    `    `    `    `    `    `    `    
   p               1      @   1   1   `    p         p      /   .   $0    
           8
                
   	   P	      P
          (   .   4.   .    
      
   -    &    '    @)    @'    0*    *    +    `,          @   /    0   0   
   /   (
   6    `    `    `    `    
   L.   </   0   E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        
   X0   /   /                            7         0
   P   @   >   0         
   $/   
   /    D   /    D   D   0
       D   `    `    `    `    `    p       p   P    C    ?    ?    @@    7    7    7    @    7                  T    0z    
   T    W    
            P   
   б   P	   а   X   @0   p/   d.   
           (
   0   
   @d   p   
   X.   L0   .   
   `    0    0
   c       x   P   1   1      `   1       1   1   1   `
   P   1   1   1   
   p7    07     7    6    6    H
                  `           0   @   >   Г           
   
                    \    @x    
   D   D   .    x            `    `    `    `    `       7         0
   P   @   >   0         h
   T    PX    `
   .   (
   07         0
   P   @   >   0         
           
   d/   
            
   p0           5    5                                     
 
                     	               	               
                                              
   0       x
    %    7    7    7    7    7    7    7    7    x
           
      @   /    0   0      .   
   `e   p   
   .      0   
    e   p   
   S   0    
       @       p   
                  _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?       
   @6              P   @   >         @
                     @   >   p   p   
      D   `    `       @   >      p           UUUUUU?UUUUUUUUUUUU?UUUUUU          8
   5    1    0     2    1    2    2    3    3    4    4    
   P<   `    `    <   `       @   @            @   >      p      H
                   @   >      p         f   
   T    `T           x   D   D   D   D   D   D   D   D   
                
   0/   .   /   ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?(
          d0   P
   /       p
       p              ?   =
?   @33?   =
?      ?   ?    ?
   /           
              D           $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?`
       p            T    Z    X
   /          8
       `           0   @   >   Г      
   .   
   0   
           
              
   `C    B   B   A   @A   8
       `
   6              P   @   >         
   @   Л      `   0   @   >            
   @>    p8    8    :     8    9    ;     =    =    (
            `    gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@
      D   `    `    0   @   >         
                     X   t.   @.   0   
                 0   @   >   Г      '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        H
      5    x
   D   D   D   D   D   D   D   D                     0
   |0   
           Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context     bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product x   to_matrix(array)        vector size     rows * columns  .   y   m   k   T   Y   A       variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =             anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b      data initialization K   t   cap S       t_change    X   sigmas  tau delta   beta        variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   gamma   k_s m_pr    Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        (S + 1) Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!           C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      Undefined transformed parameter: gamma  Undefined transformed parameter: k_s    Undefined transformed parameter: m_pr   []      iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed               Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.         iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes       MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "   \            q `          "   T/            Xq           "   T/            q           "   @            p            "   n            n `          "   m            m            "   D'            `m            "   $m            0m           "   l            l 0          "   f            pj            "   i            i x          "   i            i          "   l            Hi            "   T/            8h           "   T/            g           "   4g            pg X          "   V            f          "   f            f            "   b            `f            "   h\            e            "               e            "               e            "   he            xe            "    e            0e            "   t[            d            "   8            d            "   pb            b           "   b             b            "   h\            a            "   pV            a            "   (V            pa            "   h\            @a            "   h\            a            "               `            "               `            "   h\            `            "   8             ` 8          "   h\            _            "   t[            _            "   8            _            "   P            ^ @          "   P            x^ @          "   h\            0]            "   \            \ `          "   T/            \           "   [            [ 0          "   ,            x[ 8          "   F            X (          "   &            W X          "   W            0W @          "   V            V          "   pV            V            "   (V            8V            "   h\            U            "   h\            U            "               xU            "               PU            "   h\            (U            "   h\             U            "               T            "               T            "   8            T 8          "   8            @T 8          "   8             T 8          "   8            S 8          "               S 0          "   P            PS            "   h\             S            "   h\            R            "   t[            R            "   8            R            "   t[            hR            "   8            8R            "   Q            Q          "   tQ            Q          "   O    O    O            "   s    8O    `O 8          "   s    N    N 8          "
   dM            M @          "
   8L            L H          "   J            K 0          "   I            0J 0          "   LH             I 0          "   s    G    G            "   s    LG    xG            "   F            F X          "   F             F (          "   l%            E X          "   D            E            "   D            D @          "   $             D            "   4!            C            "   0)            C            "   )            `C            "   )             C            "   8B    XB 	   B            "   lA    A 
   A            "	   ?            ? H          "   D>    \>    >            "   =    =    =            "   =    $=    P=            "   s    <    < 0          "   ;     <    (<            "   s    l;    ; 0          "   :    :     ;            "   :    4:    `:            "
   9            p9 8          "   7            08 8          "   d6             7 P          "   4            5 0          "   3            P4 P          "   s    3    83 0          "   s    2    2 0          "   1    1     2           "   p0    0    0           "   P/    /    /           "   8.    x.    .           "   -    L-    - p          "   ,            , 0          "   2            x,            "*   (     * A   0*           "   '         
    (           "   D'            X'            "   &            0& X          "   l%            % X          "   $            $            "   "            @$ p         "               #            "   <            #           "   "             # p         "               h"            "   $"            0" 0          "   !            !            "   4!            H!            "   8                         "                           "   8            @  8          "   h\                         "   h\                        "                           "                           "
                p         "   H            X H          "                           "                (          "
                p         "   l            x (          "                 (          "                          "                (          "   <            H 8          "                 (          "   0                        "               ` 0          "                0          "   h\                        "   h\            h            "               @            "                           "   h\                        "   h\                        "   t[                        "   8            `            "   ,            8            "   t[                         "                           "                           "   h            x            "        +              "                           "        +              "   X    p     (          "                         "   x         	    0          "               0 0          "       \               "       4
    `
           "           @ `         "   
    
                "   	    	     
 `         "   |                   "                         "           0           "            `         "                      "   d         p         "                 8          "   T            p            "                            "	             0           "*       H A   p           "   <             x          "+   D     Y   0           "   l             (          "   $            8            "   +             P          "   +             P          "   +             P          "                            "                           "   s        @ 0          "                           "                           "   L                    "   0         
    @          "       |               "   0         
   ` @          "   2                        "   8            H            "                            "                           "   H            `           "                           "                           "   h            p           "            	               "   s    4    `            "   l             p         "                           "   s    x     0          "!        :              "   l         1   @           "!        :   @          "   ,         1               "                           "   H                        "               ` 0          "   8            ( 8          "   h\                        "                           "               p            "   h\            H            "                            "                           "   h\                        "                           "                           "               H           "                          "
                x         "                            "   x             (          "                          "   @            X            "                           "                 0          "                          "   $         	    8          "   8            X            "   8            0            "   t[                        "   8                        "                           "   P            x @          "   +              P          "       ,    X            "   s          (          "   s    `     (          "                0          "'       4 H   ` 8         "'       D J   p 8         "                          "                          "   (            P          "                @         "                h           "               0           "                           "                          "   8            `          "               л @         "                x           "               @           "                           "               Ⱥ           "               0          "            -   `           "   L         -              "   (     %              "               в H          "   `            x x          "                H          "   <                       "   ̮            P           "   +             P          "   @            H (          "   H             X          "   p             @          "   P                        "   +            @ P          "                @          "   +              P          "                @          "   ,            ȩ 8          "   s    D    p H          "   s        ب (          "   H            X            "                           "   h\                        "                           "   (            H            "   s        Ц 0          "   h\            p            "   h\            H            "                            "                           "   8             8          "   h\                        "   8            P 8          "                0          "               Ф 0          "   8             8          "   8            H 8          "   $         	   У 8          "   $         	   ` 8          "   h\                        "   h\                        "   t[            p            "   8            @            "   h            p            "   0            8            "                           "               0 (          "                (          "       | :              "   ԛ          0          "       ,    ` 0          "   <    \ 	    0          "   l     	    0          "$   (         ?   P          "   '             0          "   s    `     0          "   s          0          "   s         0          "   s    (    P 0          "   s         0          "   s    X     0          "   s         0          "   s         0          "   s         H 0          "   s         0          "   s    P    x 0          "   s         0          "   s         0          "   p            8 @          "            	   Џ 8          "               @ @          "   p             @          "            
   ` @          "            	    @          "   P            8 P          "                           "                (          "                (          "   P            X            "        
               "               0            "   p             @          "               ( @          "   +            Љ P          "                       "   ؇        0            "            P            "       8                "                               "   Xx            X            "                           "                           "   X            ` 8          "   h\                        "                               "   h\            X            "   h\            (            "   s    D    p 0          "                           "   s    `     0          "   (            0 0          "   h\                        "               (            "   ~            ~            "                   ~            "   ~            x~ X          "   ~            ~ X          "                   }            "   s    |    | 0          "   s    {    | 0          "   Xx            {            "   h\            {            "   h\            P{            "   h\             {            "   h\            z            "                   z            "   Xx            Hz            "   s    y    y 0          "   s    x    x 0          "   Xx            hx            "   w            w 8          "	   v            0w (          "   tv            v P          "   s            Hv (          "   s            (v (          "   u            u p          "    u            0u           "   Lt            t           "   s    s    s 0          "   s            s (          "   Ps            `s            "   r            s            "   q             r            "   o         "   `p           "   2            o            "   n            n            "<   8h    j n   j          "k   ]    4a    `a h          "    ]         
   `]            "   h\            \            "   h\            \            "   h\            \            "   h\            p\            "   t[            @\            "   t[            \            "   t[            [            "   t[            [            "   t[            [            "   Z            Z 8          "   Z         
   0Z H          "   \%            Y            "   \Y            Y            "   Y            (Y            "   4X         
   X (          "   Q            W (          "   Q            W (          "   lP            W (          "   P            `W            "   lP            0W (          "   V         
   V P          "    V            V @          "   4U            U 8          "   4U            PU 8          "   `T            T           "   `T            T           "    S            S 8          "    S            PS 8          "	    R            pR 8          "   Q            Q            "   K            Q            "   Q            HQ (          "   Q            Q (          "   lP            P (          "   P            P            "   lP            xP (          "   O            O 8          "   N            N @          "   N            N 8          "   N            (N 8          "   0M            M           "   0M            PM           "   pL            L            "   L            0L            "   K            K            "	   J             K 0          "   J            @J 0          "
   H            PI H          "    H            @H            "   F            G            "   0G            HG            "   F            F            "   F            (F            "
   D            0E            "   |D            D            "   C    C    C H          "   B    B    B H          "
   A    A    A           "   ?     @    0@           "   4?            P? @          "   >            > (          "   p=            =           "
   P<    <    < @          "   <9    l9    9 0          "   t8    8    8 0          "   7    7    8 @          "   6             7 (          "   (6            @6            "   T5            5            "   4            4            "   @4            h4            "   \3            3            "	   L2            2            "   2            2            "   \%            1            "   l1            1            "   0         
   0 0         "   D0            P0            "   0            0            "   )            /            "   T/            `/           "   -             /            "   .            8.           "   -            -            "   -            0- 0          "   @(            , H          "   ,            , 0          "   ,            8, 8          "   +            + P          "   p+            x+            "   )            @+            "   )            +            "   0)            *            "   0)            *            "   )            h*            "   $*            0*            "   )            )            "   )            )            "   0)            8)            "   (            (            "   @(            P( H          "   (            ( (          "   '            ' 0          "   '            ' 0          "   \&            H' (          "   \&             ' (          "   &            & (          "   \&            h& (          "   \%            (&            "   \%            %            "   \%            %            "   \%            %            "   \%            h%            "                   @%            "   $            $            "   H$            P$ (          "   X#            #            "	   `"            " `          "   !             " (          "   !            ! (          "                   h!                          Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                 ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    njY    
   p   
                                                                                                               p   x                           P   P   4            0            pH 8
 
                            P
         `
             pH             @   8
                        H 
 
                            
         
 
 
                     H            @   
                        x
                	             m            @   p
                      `p 
 h
                 M            @   P
               
 8                        `      d 
 
                 g            @   0
                         p
 (
                            M P
 P
                              x
                  f            @    
                       ` x 
                            
         m            @   
                        0 
 0
                         p
  
   
 
   
                                                             @    
                                          0 
 
                 T             @                           
                      @                x            @    
             8b            @   @                (       0 0 
                            8b @  
                             
 (
                 X
 8                                      @
 
                                 
 
                            h
                    h                    
         K            @    
                        ` p
 8
                 8
 
  
 
 x 
                                     T     (       @                           
                    @ 
 
                                         pk 
 
                            P
                    x  
 X
                 Ѓ             @   
              q            @   h
                          @   p
                                 Hd            @   X
              
                             
                                          @   
                       h
                    g 0
 
                           0 
 
                           	                   p
                    h 
 @
                            P{ 
 h
                 P            @   
             @
 
 @
 
 x                             P 
 
                                
            (         
  
                  
 8                     
  p
  8 
 p
                                     {            @   
                P      ` x 
                 H
 @
 
                                Pa 
 
                             
                    `| 
 X
                  
                        `q 
 
                  X            @   H
             L             @   x             `
  
                                Hd X
 (
                 h`            @   
             `
 
   
 8 X
 h                                     Pa         P      P   
             
 
                 
  @
 
 x                                        0 p (
                 pk             @   
                        M  x
                  P
                           p 
 
                           p
                    
                     
 
                 `q            @   
                        
 `
                   8                                @
                                        Px 
 
                 
 P
                            I @
 
                 e            @   
              u            @                 @            @   
             h            @   
                        p 
 
                              @   P
                          0
                 0            @                                    
 
                 P
                        P 
 
                             @   
                         O @ 
                 
 (
                    (       8e 
 P
                 `
 H
                 
 P
                 `
              
 P
                                P
                    
         
  
                 q            @   
             
 
 
 x                                    
                   
                    (
         
 
                  a             @   h
                        Z  
                 @
   8                          \            @   
             
 x 
 
 
 x 
                                                H                    x         M            @                
 
 
                               `q 
 (
                 
 H                 	                   a            @   h
             
 @
 
 x                                    x            P         
                 v            @                            
                
   `
          [            @   
                        a 
 
                            P                             (
 h
 
                                          `
 
 
 
 x 
                                             	 X
                 0            @   
                       (         f               @                           P	         H 	           @   P                         
 (
                 
 @
 
                     N 	           @   P
                        f X 
                  
                          @   
                P      `q 
 
                            	                     ` 8
                 `K            @                           
                    PV 
 
                 l             @   H                        `K  
                 pe             @   
             0j            @   
                        Ё X
 h
                            
         
 h 
                                
         HO            @                (u            @   8             Ph            @   
             h 
                             N (
 p
                            
         H
 P
                 Pa             @   
             
 (
                             
                              
 
                             
         
             
   
                         pm            @   
                        
         
 
 
                     (	 X
 P
                     Z            @                           PM 
 H
                 ]            @                           S 8 
                 [           @   8
             PV            @   
              
 
                 @
 
                             @   X
                                  N            @   (
             `s            @                                    0 
 P
                     U            @   
                        
                    x  H
                            
         PM            @   
             f            @   
                          @   
                                 0 (
                            K  
 0
                            
                                         { 	 
                 x           @   
                        0 
 
                            @
                     X
 
                             @   
                        l 
 h
                           o  
                            [ 
 
                 `p            @   
             H            @   X                                0\             @   h
                       `K  p
                 @            @   
             
 
 
                                Ȗ P
 
                            0                    
                    (u 8 8
                 h
 
                 
                                  
 0
 
 8                            (       Ph 
 
                             [ 
 
                 
   
                         
  
 
 x                                        x
                    P                             X
 P
                            8 
 
                           e 
 
                 x            @                            @                 a            @   h
             
 8                 @
 
                 p            @   
             0            @   
             l            @   
             
 (
                           PM 
 X
                 
                                8b    (       @   @             8            @   
             ȇ            @                
                        P
                    d 
 H
                              p
                            
                    x 
 
                  
 
                                
                    z  
                 0            @   
                         X H
 `
                 `            @   x                         @    
                         @   
                        Pf 
  
                 ؍            @   
                                            v 
 h
                 m            @   
             
   
 8                                     @                            0 
                             @   @                        (                    
         c            @   
                        L x 
                             \ 
 
                 }             @   
                        @ 
 (
                            0l 
 P
                            Ћ 
 x
                           H
                                      8
                     @   0                          
                            pO 0
 8
                 Ћ             @   
                       
                   `
                    
                     @   H
                P      m 
 
                            ȇ   
                             
                    0j 
 `
                            
                    p 
 
                 
 (
                 v            @   
                        X         
 
                              @                `|            @   
                       P{ 
 
                 [            @   8
                       { 
 
                 
 8
                            PI 
 
                 
 
 P
                               0l 
 `
                           (         k            @                
 
                           h
         Pa         @      P   
                        m 
  
                 z            @   p
                        (
                    X                    @   p                          @   
                        N (
 
                  O            @   @                          
 @
                 
 p
                      xd            @                                     Z            @                            
 
                             
 
                  
                 h            @   0
             `[            @                            @                h
 X
 P
                                x
         Ȗ            @   P
                       z  0
                            h         X            @   
                        
                    h` 
 
                             @   p             H             
  
 0
 
 8 
 X                                      8                 
 
  @
 
 x 
                                                
                     M 
 
                             
         X                        `s  
                 
                        e 
 H
                   
 
 
                                    m p
 
                           
         pO            @   0
             
 h
 
                        P      0 
  
                 H
 
                            X  `
                 8             
 
                              
                 HO    (       @                 8
 
 
                         
             
 
 
                     [           @   8
             
 @
 
                                
         
 X
 P
                     ( 
                 0l            @   
              
                             h
 0
                 
                        X 
 h
                 f             @                             
                    8T 
 
                 pT            @   
              `
                            P 
 8
                 `            @   p
             X 
                           @
                    X
                                       
                             W            @    
             z            @                           
         
 
 8                                h
                    
                    
                    
                    @
                    e 
                               @   
             @  
                 
 P
                          
   
 
   
                                                        `
         8e            @   
                        HO  0                 
 P
                  
  
   
 
   
                                                 `Y            @   
                         _ 
                  
 
 P
                      
 P  
 8  
                                     p            @   
              
 @
   8 0                                                  H X                  x 
 
 
 x                                          @   h
                         
 `                           
                    
                     u                    `b            @   x                        
         f             @   
             d            @   
                        { 
 p                  
 
                     o            @                
   
 
 
 
                                            
                     @   
                        8
                    Ph 
 p                            H
                    
                    P
                     @                           `b x                  f            @   X                          (
                        W  
 x                                                @                  I            @   @
             pz            @   @             P
 
 
                      p
  8                         T            @                           ` x                  Ѕ             @   p
                      H P                             0 0                             
         PI            @   
                        T                   Px            @   
                        
         a            @   
                        
         t            @   @
             
 0
  
 
 
 
                                             @   
                        
         
 
                 @
 H
 @
 
 x                             `R             @                           
 8
                           @ 
 `
                   @
 
 @
 
 x 
                                                 
 
                 8
              M            @   
             
 
 @
 
 x 
                                            
                    0  x                 
 
                    (       d 
                              j `                  
 8                 
 @  
                                P
          a            @   h
             
 
                                 P   
                P      { 
                               
                                      Ё             @   X
             0
 
 8                     `u            @                
                       (       @   
                        
                      
                            
                   p         8T             @   
                        
         H  (
 h
 
 
 
                                      s            @   
                        8
                     p
                  x           @   
             0             @   p             a            @   (
                        t @
                             ]                              
          j            @   `             p
                  S            @   8                           
             
                        
                    c 
                             
         P            @   
             
                                         P      P{ 
 X                            O 
                             
          
 
                       
                  _            @   
                        ؍ 
                              X
                    P          
                           8                    8                    pT 
                  
 @
 H
 @
 
 x 
                                     x            @   
                    
   p          a            @   h
             
 
 
 8                         0            @   0                        8
         [            @   
             H
             
                       x  @                 e            @   
                        
                    m 
                     (       m 
                  Z               @                            
                    
         P  
 8                                      @   
                      N P
                              @   
                        z p
                  
             0
  
 
 
                         O            @   
                        H
                    8         H           @   X             H           @   X             Pf             @   
                        0         p
  8                        P       N (
 X                             @   	             
             8
 
 
                     
 
                 f            @                              
                             
                    
                     
                     @   `                         @   p
                        0\ h
                  P{            @   
                P        
 (                            xd    P                                              x
                    q 
                                                            8
                    U 
                             
                    `[  P                            h
                     q h
                  X            @                           o                              pz @                             
                     s 
 H                  (
 h
 
 
                                                            k                               
         @
 
                  
 
 
 8                                        x 
                                g 0
 p                            8e 
                  p
 
 P
                      {            @   	             
 
                  a            @   h
             
 
   
                                        } 
 x             GCTL   `  .text$di    `   U .text$mn    k     .text$mn$00 k 0  .text$x    .text$yd      p
  .idata$5    p    .00cfg      .CRT$XCA        .CRT$XCL       .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ        .CRT$XPA        .CRT$XPZ        .CRT$XTA        .CRT$XTZ      .rdata  
 (   .rdata$T    
 W  .rdata$r     t  .rdata$zzzdbg   !    .rtc$IAA    !    .rtc$IZZ     !    .rtc$TAA    (!    .rtc$TZZ    0!   .xdata  0   .xdata$x        .edata      .idata$2    x    .idata$3     p
  .idata$4      %  .idata$6      pX  .data   pH P  .data$r   &  .bss      j  .pdata   @ <   .gfids$y     P    .tls    P    .tls$   P    .tls$ZZZ     `    _RDATA   p `   .rsrc$01    `p    .rsrc$02                                         20
 
4 
2p B   R0
 b  D 
     p  * d 4 pDd X
 r   k               Q         2P1	 T 4  p`  Dd 0
    k     k             &     
        
 d
 T	 4 2p2  	p`0PDd 
    l     ,l 8l    Dl Pl    \l    hl    tl    l                  X            J                     +"     "     "     #     5$  
 
4 
Rp d	 4 Rp 4 R
p`PD 
 l     l    l    l    l    l    D    D         %  %      %     %     %     %     &     
&     4&     J&     q&     &   d T 4 2 T 4 2`% %t !d T 4 
	ЮD 
 l '  (      (  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 RpD 
  m     m     D D     .  .      /     "/     3/      w/     /   4 RpD h
     /   0Dd @
 J    m     1  B1      _1   0Dd 
 J        2  22      O2   0Dd 
 J       2  "3      ?3   0Dd ȳ
 J       3  4      /4   0Dd 
 J       4  5      5   d T 4 pD x
 0m     8  9      9  ,9      9   d T 4 pD P
 `m     9   :      %:  <:      :   d T 4 pD (
     :  0;      5;  L;      ;   d T 4 pD  
     ;  @<      E<  \<      <   4 pD ز
 m      =  6=      \=   4 pD 
     =  =      =   d	 T R( (d $T  4 
pD 
 m      A  1A      $ 	0 0  Dd `
 r  m     m `C  C      C     DD  m md
 h4 
rp 4
 rpD 8
 m     m    n    n    ,n     F   G      DG     }G     G     G     G  ! t L  WL  0! !   L  WL  0!  h r0D 
 @n 0M  zM      M      
4	 
2pc    * *x h r0 Rp`P0 t d
 4	 RD 
 Pn U  U      V   h d 4
 rpD 
 `n     @V  V      V   h d 4
 rpD 
 pn     V  ZW      W   t d
 4	 RD p
     X  X      Y   h d 4 rpD H
     0Y  Y      Y   h d 4 rpD  
     @Z  Z      Z   t d
 4	 RD 
     [  [      \   d
 4	 RpD а
 \  \      )]   4 
p	`PD 
 n ]  (^      ^  / 1 	p`0PDd 
 r  n     n n    n ^  Q_      p_     _     L`     & 6 p`0  Dd X
   n     n    o    o      a  _a      a     a      b     . 47 2 p`P  Dd 0
    o     ,o    8o Pb  b      b     :c     Uc  & 0 p`0  Dd 
 r      c  c      ,d     .  4  p`P  Dd 
    Po     \o    ho e  e      f     5f     Of     f      #g   h b  +
 +h &4 
p`PD 
 o o    o    o     Pj  j      &k     9k     k     l   t 4 P' 't# #d" 4!  P  D 
 o o    o     pm  m      en     -o     o     ;p    p  !  
T 4 pp  p  h. ! d p  p  t. !   p  p  t. !   pp  p  h. !     T  4 pp  p  h. " "h 	p`0PD h
      r  9r      r     r     Ys     bs  ' 't #d 4  P  D @
 o     t  t      u   p! 4 v  w  x/ ! d w  "w  / !   w  "w  / !   v  w  x/  d
 4	 RpD 
 `x  x      x   4	 
RpD 
  p     py  y      z   4 RpD Ȯ
 p     pz  z      z  *
 *x &h "42 , 
p`P  D 
  p     ,p    8p    Dp    Pp    \p           hp  {  :{      v{     {     {     |     '}     2~     ~     ~     ~     ~        6
 6x h d 4 rp( d 4
 pDd x
 J   p p     0        3       i   d 4 2p 0Dd P
 J       @           d T 4
 rpD (
 p       C      ކ  8	 'x8 #h9 4v t P  Dd  
 r  p     p    p    p    p    p    p    q    q                                    X               )     7          ։          y                          9  6	 %x8 !h9 t p0P  Dd ح
 r   q     ,q     8q    Dq    Pq    \q    hq    tq     Ћ  B      r                :     j               ?     p          !                     ʏ   4 Rp`PD 
 q q    q    q    q `             ǐ                 $
 $T 4 R
	p`D 
 q q    q    q    r    r 0  {                Ǒ               $  0
 !4 
p`PDd `
 j   0r     <r Hr    Tr               k                   #     ?      M                 ͕         R
 R T
 4	 2p`$
 $T 4
 R
	p`D 8
 `r     lr     xr `                  ]   4 p`P!      h6 !       h6 ;
 -t7 )d6 %44 . 
P  Dd 
 b  r r    r    r r    r           1      @  ؜          1     >     ĝ     ӝ     "         ! t    P  0! !   t    P  0! 
 d T
 4 2p$ 	 0  Dd 
               s    s    s    s               7 	   ؍    s 8              s     s    2s    Fs    s    
 
2PD 
 "  Dd 
               zt    t    t    t               8 	   ؍ x   s 8         Ǥ      ͤ  s     s    t    t    ct    
 
2PD 
 , h	 	 0  Dd 
               :u    Fu    Fu    Ru               9 	   ؍ x   t 8                 $      @  t     t    t    t    #u    
 
2PD 
 
 h 4 R
p`P
 
4 
2p R! t d 4	   8  : !" "T
  8  }  : !   8  }  : !     T
 8  }  : !    8  }  : !     t  d  4	   8  :  RP!  t 4	     : !# #d
    <  : !     <  : !     d
   <  : !      <  : !       t  4	     : ! t   ̯  0! ! d ̯    D; !   ̯    D; !   t   ̯  0! !   t  d   ̯  0! 
 
B0P  ! t
 d	     ; !9 9  t
  d	     ; !     t
  d	     ; ! 4	 p  F  : !  t 	d
  4	 p  F  : $ 	 0  Dd p
            `u    lu        sv    v    v    v    v    v        	      < 	   8 H   xu H           @        C            xu     u    u    u    u     v    \v 	    BP0  D p
 :
 ,t9 (d8 $47 0 
P  Dd H
 r  v     v    v    v    v    v    w    w    $w    0w 	   <w    Hw    Tw    `w 
   lw           $      J     c     r               Һ               ^  	   n  
     	   w     T     }                 
        
  
        K     t       	                	  d* T) 4( & p  D  
 w    W        $ $d0  T/ 4. * p  D 
 w w    w     `             K          L  - " p`0  Dd Ы
   w     w            w    x    
x    x    %x            y    y    y             @ 	       1x X                                   .     c                         s                          ?x    vx 	   x    x 
   x    =y    Ny     bP0  D Ы
 , # p`0Dd 
   y            y    z    z    z    )z    5z    5z         	   { 	   { 	   {             A 	       Az X           @  u                     2     C     i                    '     >          +      Oz 	   z 
   z 	   z    z 	   M{    ^{ 	    bP0  D 
 ) 4  p  Dd 
            {    {     {    |        |              B 	    \    | 8   P                       T                "             |     |    N|    ]|    
 
2PD 
 $ 	 0  Dd X
            |    |        v}              C 	    \    | 8      L      {               ?        |     |    }    }    
 
2PD X
 *
 * x h 
4 
p( d
 4 rpDd 0
 2   }             b  7	 &dv "4u p pP  Dd 
 r  }     } } } } }    } }  ~ ~ 	   ~ 
   $~    0~             ,     :        H     Y                O     j     x              
       7  	   p  
                    
   1  	   K   4
 pD 
 @~                Bp0  !  

 T 0    @F ! d	     LF !       LF !   0    @F  4 
	p`D 
 P~     \~     h~     P  |                <   d 4 p6 (t3 $d2  40 , P  Dd 
 R  ~ ~    ~ 0          
     q             4
 pD h
     p          
 
4 
 p  ! d   F  G !     F  G ) t 4
 	PDd @
 J   ~ ~ ~ ~ ~ ~ ~         P          2     @         P     ^         k     y         4	 < 	p`0P  Dd 
            (    4 @    L               X    d p 
   |              0                   Q     w        q            %  	   8     B  r  
          
            2	 $4  p`P  Dd 
                               0                   F            )     L             )  p`0P  Dd ȩ
                       ( 4    @         +     <        '     \     m       X                           A     y            +
 +h &4 
p`PD 
 P \    h                   Z     ]  ! !d
 4 R
pD x
                                 4 
R	p`D P
               Y        T 4 p` 4 p`P! h     L !       L !      L !       L & &d "4  	pP  D (
  ̀    ؀                       |            & &d "4  	pP  D  
                                   4 &d "4  	pP  Dd ب
                @      d               "      .  4  p`P  Dd 
     
     .    ^             T .  4  p`P  Dd 
          ,    8  J     n            *      
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T  /
 @O !    /
 @O )  p`0P  Dd `
    P     \    h t                    _                 @      +    \    m     P        5    @  4 
RpD 8
              d 4
 
RpD 
   @       4 
RpD 
             4 
RpD 
 Ё      6     J  4 
RpD 
     p       " "h 	p`0PD p
                   )    -  	p`P0D H
       P          L     S )  p`0P  Dd  
                  (    4    @    L    X    d         p          5    Y                        3    D        /    `    q    {     .  4  p`P  Dd 
    p     |                   
     .    ^             U              .  4  p`P  Dd Ц
             
      .     ^                U! !    "    "    " %
 %h t d 4 P"	 "d 4  pP  D 
      Ȃ    Ԃ @% u%     &    '&    &    &    & "	 "d 4  pP  D 
 ' E'     '    '    (    (    ( 0	 "d 4  pP  Dd X
                  ( ,)     P)    )    )    
*     w* .  4  p`P  Dd 0
    P, ,     ,    ,     -    -     - .  4  p`P  Dd 
             ( p/ /     /    0    @0    0     1  r04 &h "4/ & 
p`P  Dd 
   @     L    X d    p | 5 5     6    C6    g6    6     ;7 7    7    7    h8 8    9  4 
RpD 
     9 :     -:  d 4
 
RpD 
 P: :     :  4 
RpD h
     : ;     -;  4 
RpD @
     P; v;     ;  4 
RpD 
     ; ;     ;    )	 
	p`P0  Dd 
 b                        ̃    ؃             	    
   '             ? ?    ?    ?@    L@    Y@ 	   i@ 
   u@    @    @    @    @     @  
R0D Ȥ
 @     L PD fD     yD    D  4
 
RpD 
 `     l    |         D D     E    'E    WE    eE # 4
 pDd x
 J    S pS     ~S 6 (4   
p`P  Dd P
         Ƅ    ҄    ބ         T RT     T    V    V    W    W    W     X    VX     = ,4A 8 
p`P  Dd (
                          ,    8    D         X Y     XY    Z     Z    [    /[    f[    [    [    [    $\    L\    _     4	 
RpD  
 P     0` p`     `  4	 
RpD أ
     `  a     Aa  4	 
RpD 
     Pa a     a  4	 
RpD 
      b `b     b  4	 
RpD `
     c c     1d  R0D 8
 D  f [f     vf  4 RpD 
     f f     f  R0D 
  g ;g     Vg  4 RpD 
     `g g     g  
R0D 
 `     l    |                    Յ h i     i    #i    /i    Di    Yi    ni    |i    i ;
 )h# $dQ  4P H 
p  Dd p
 +                               ,    8    D    P 	   \ 
   h    t     
                       Ȇ    Ԇ                            (    4    @    L    X    d    p !   | "    #        %           ć (   Ї )   ܇ *             -        /   $    0 1   < 2   H 3   T    ` 5   l    x 7                ;        =   ̈ >   ؈ ?        A            D        , F   8    D H   P I   \ J   h    t L        N                R   ȉ    ԉ T    U    V        X           (    4 \   @ ]   L ^   X    d    p a   |     c        e        g   Ċ        i       h   j      Ha 	    p   Њ H       i i     i    .j    cj    j    j    j    k    k    k    l    !m    tm    m 	   m 
   m    n 
   Gn 	   Un    cn    n    o    ]o 
   o    o 
   o    p    <p    sp    p    p    p    p    p    @q    wq    q    q    Sr    r    s    s    s    t    Pt    t    t    t    t    +u    9u    Gu    u    u    u    u    v    w    w    ;x     Zx    hx    x !   x "   ,y #   >y $   dy #   y "   y !   y    y %   <z &   [z %   iz    { '   v{    n| (   | )   | *   | +   } *   Q} )   _} (   m}    } ,   ~    s~ -   ~ .   ~ -   ~    ' /   d 0    /        1    2   U 3   k 4    3   ƀ 2   Ԁ 1       , 5   i 6    5        7    8   < 7   J     9   ݂    ; :        ;   + <   J ;   X     =   ߅ >    ?   . @   T ?    >    =        A   , B   K A   Y     C   i    a D    E    D   ˉ     F   L G   k F   y     H    I   Ŋ J   ۊ K    J    I    H   +    M L   b M    L        N   Ƌ O    N       # P   T    v Q       1 R   F S   e R   s     T    U    V   э W    V    U    T   !    C X   X Y   w X        Z        [        \    ]   # ^   1 _   W ^   e ]   s \        `       $ a   9 b   X a   f     c    d   ͑ c   ۑ     e   - f   L e   Z     g    h   Œ g   Ӓ          Њ     ݊ i    j   
 
RPD p
 9 'h( R 
p`0  Dd H
 s            $    0    <    H    T    `    l                              '    3    ?    K    W                                      *    6    B    N    Z    f                 "    #             +     7 '   C (   O )   [                 ,    -                   , 1   8     D 3   P 4   \ 5   h     t 7       7       9    :    
   
   
      |j             j !   !   $      j +   +   .      j 8   8   ;      j 	    8  x H   	    0  c H   	      r H   	    (  g H   	        X    5     j    z            ֕    ܖ    `        0    g    u 	       И    ޘ         
       J    `        l                ,    R                    ϛ            ͜    (    n        ĝ    ҝ        M                        
    N      !        ڟ %         &        F '    (    )   Ρ *    )   ) (   7 '   E     a +   t      /   Ǣ     ~ 0   ٣     & 1   c 2    1        ڤ 3    4   T 5   f 6    5    4   ϥ 3   ݥ      7   U 8   g 7            ¦    ߦ     x              
   c     p        ˌ    r      "    #    $   g     t ,    -   َ .         9    :   ď ;   
 
RPD H
  bP0  D H
 .  t d 4 	PDd  
 J       $ 0 < H T             0      ;     g      ԩ          N    [      Ȫ    ժ $
 $t d 4
 
rPD 
   A     2 ?
 .tC *dB &4@ : 
P  Dd С
   `     l     x                                   ̐     ؐ                                            p Ȱ    ٰ              `    n                       G    S         ǲ                	   .     l 
   x                       @ 
   N                  ʴ              	 < +tC 'dB #4@ < P  Dd 
   0     <     H     T     `     l     x                                                                     P          ε    ڵ     5    C     c    o              #    /              ÷    Ϸ       	        L 
   X     p  4	 
RpD 
      Б             P y                   d 4
 
RpD X
          _     w    ̼  
R0D 0
   @ V       D 
                       s 	    8   P H   P c      P     ]    
 
RPD 
 3	 < 	p`0P  Dd 
                Ȓ    Ԓ          0     @    N    p        "    W                 9 (h $4D < 
p`P  Dd 
         ,    8    D    P    \   k     v            J                        "    K     g & 6 p`0  Dd 
   p                         0                 2      
R0D h
 p       
R0D @
          d 4  p  D 
 ؓ         ̓      9     O    ]             * *d %T  4
 R
pD 
          ,    ?    R    e    x                               I    ]    o             0
 "d 4 	pPDd ȟ
 j        ̔    ؔ       Z     d        *           h R0! t
 0 t  x !   0 t  x  
4 
pc `    4
 RpD 
          ,    : # #t
 d 4 rD x
               x @           0 X             ( 0     >     bP0  D x
  4 2! d t  Q y !   t  Q y !    Q y  d 4 2! t P  \y !   P  \y ! d   $ !     $  d 4 
rpD P
               y @            X       P                  bP0  D P
  4
 RpD (
  H     S v      2p! 4   pz !     pz  R0D  
        4 RpD ؞
     `        4	 RpD 
           '  d T 4 2p d
 4	 Rp 4 RpD 
         4	 RpD `
     0 O     w  4
 RpD 8
     p           S  d 4 
rpD 
               | @            X   p t                bP0  D 
 ! d p  $ !   p  $  d 4 
rpD 
               | @           p X    r      p     ~     bP0  D 
 ! d 0 H $ !   0 H $ ! d t p  y !   t p  y !   p  y ! t   \y !     \y ! d   $ !     $  4 RpD 
 0  t	 d 4 2 d	 T 4 2p0	 "d 4  pP  Dd 
    Ж     @ &      ! t   0! !   t   0! 0	 "d 4  pP  Dd p
                R0D H
   R
p`0D  
                
 [
     w
    
    
  4	 RpD 
 0     ^     
 ;     T      0  ! t P  H !   P  H + +d 4 p   BP0  ! t	  F  !  

 d  t	  F  !   
  t	  F  
 b  D М
            #	 p
`P0  D 
 p          d 4 
rpD 
               t @            X                    bP0  D 
 " "d
 T 4 
rpD X
           `              ,     ! !d 4
 r
pD 0
               X @             X        ! |!     !       .     bP0  D 0
  T 4
 2
`! 	 t " D#  !   " D#  ! 	 t `& $'  !   `& $'   4	 RpD 
     * *     +  4	 RpD 
     + +     + 
 b  D 
 0  R0D 
 0 1     V1 >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pPDd h
 b    > "?     @  2p`0 4
 rpD @
  D @B B     B    B  
4 
pc H    4	 RpD 
  0F PF     F 
 t d
 T	 4 R
 	 T d 4
 Rp 4
 RpD 
     P HQ     SQ vQ    Q  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b  D Ț
     b ! bp`0  D 
                                     `             t @            8   @            H           c ~c     c      ͘    ՘             
 
2PD 
  BP0  D 
 
  ` St
 6 
B`P0   T 4 2`! t h h  !   h h   4  d T 2p! 4  m "m P !    m "m P !   4  m "m P ! 4 0o Ro P !   0o Ro P !   4 0o Ro P $
 $d  4 r
pD x
                 D    D             4 @            8           q Br     xr    r    $s    Qs    es    s          ҙ     
 
2PD x
 $
 $d  4 r
pD P
                 D    D              @            8   s 6t     lt    t    #u    cu    wu    u          "     
 
2PD P
 $
 $d  4 r
pD (
 0 <               D    D              @           H 8   u ]v     v    v    Rw    w    w    w H     U    r     
 
2PD (
  T	 4 2! t d x x x !   x x x / 1 	p`0PDd  
 r  y y      z    :z    z    *  	p`P0  Dd ؙ
           { j{     {    {     L| 0 6 p`0P  Dd 
        Κ              | 3}     R}    }    }    4~    _~     4 R
p`PD 
      (    4    D    P             ~      o                      d
 4 
rpD `
 ` l               D             ċ @           x 8            I     X    \            ܁ x              
 
2PD `
 
   D 8
   K     V " "d T
 4	 
RpD 
      `       4	 
RpD 
            4" 	  p  D 
                             ! 	0Dd 
 r               	 0  c    -	  	p`0P  Dd p
         ( 4         p      ( [             ~    \ * " p`0P  Dd H
   @ L    X d    p p    |                            ΋ ۋ        |              0 6 p`0P  Dd  
   ` Í             q    Ď        ' 
 p`0  Dd 
         l         ͏     @ = ,4B 8 
p`P  Dd З
        Μ                                                ֒        . 0 6 p`0P  Dd 
   ` ē             s    Ĕ        
   D 
                @             H         > @     
 
RPD 
 
   D X
                @           @ H   P ]     ~      
 
RPD X
 
   D 0
               d @           ` H               
 
RPD 0
 
   D 
               ̑ @            H   И ݘ            
 
RPD 
 
   D 
               4 @            H         > @     
 
RPD 
 
   D 
                @            H   P ]     ~      
 
RPD 
 
   D 
                @            H               
 
RPD 
 
   D h
               l @             H   Й ݙ            
 
RPD h
 
   D @
               ԓ @             H         > @     
 
RPD @
 
   D 
               < @           @ H   P ]     ~      
 
RPD 
 
   D 
                @           ` H               
 
RPD 
 
   D ȕ
                @            H   К ݚ            
 
RPD ȕ
 
   D 
               t @            H         > @     
 
RPD 
 $ $d  T 4 
pD x
     p       F 5u 0xv ,hw  
	p`0PDd P
 B       ̞    ؞                              	   , 	   L    X    d 
   p    |                        ğ    П    ܟ                             $    0    <    H !   T "   `                       
            ڠ    A 	    
    	   ӡ        / 
       ۢ 
       %        S    m            _    Ħ        S    Z        R    2        ҳ                k    {            C        ֶ        ,    9    S    |    W         z !    "   J #    "    !   ٺ    6    f 	           ɻ    ֻ     % %h !t d 4 
	D (
         p    |                   	    P    H                 Q     f        Ƽ    Ž     >          
 
RPD (
 % %h !t d 4 
	D  
                               p 	    P   Ƞ H               p                        Ƞ     ՠ    
 
RPD  
 ) )h %t !d 4 
	D ؔ
                                   @     P    H                              "    H          
 
RPD ؔ
 ) )h %t !d 4 
	D 
 0     <                                  P   H H        2              R    x H     U    
 
RPD 
 O =* 8+ 3, .x- *h. &df "4e ^ 
p  Dd 
   p |                     ġ           С 	   ܡ                         $    0    <    H    T    `    l    x                         	        8                                        g    |            	    n              	   3 
   W 	   e        =    t 
               }             7                    k                                -    T            0    `                 
    $              
 
2PD 
 ' d 4 pDd `
 Z                            ! 
	p`0PD 8
           5    A    M    o     0 W     j            T                        v      d 4
 2
p! T	 0   !   0   & 4 pDd 
 j           t              ,  4 rp`PD 
  `      M  d
 4 rpD 
 У p      a  
4 
pc @   ! 4 `  D! !   `  D! !   4 `  D! 	 	2`0! 
 t	 T   ԡ !     ԡ !   
  t	  T   ԡ  
R0D 
        _  d 4
 
RpD p
 p        d T
 4	 RpD H
      D     o        4 RpD  
       .     I 9	 (4A 8 p`P  Dd 
        >    P ^    j    v          7     S                $    Q    m 9	 (4A 8 p`P  Dd В
        +     G                    A    ] . 4  p`P  Dd 
           _          . 4  p`P  Dd 
               # p`0Dd X
 z          q          + 4 p`PDd 0
 z        z          . 4  p`P  Dd 
                R0D 
   G     b &  p`0  Dd 
         
     9    W  
 D 
 Ф         R0D h
     A     P  R0D @
 p        R0D 
  7     R # #t
 d 4 rD 
                @             X        %     8       .     bP0  D 
  d 4  p  D Ȑ
          ݥ  0 s                   4 R
pD 
          0               H      4 RpD x
               D P
 @        " "d 4	 RpD (
 P     z   T      b        t T
 4	 R`2	  d 4  p  Dd  
                  Ĩ @            H     b     7           BP0  D  
 f
 fd <t 	 4 2% %4 p`D ؏
               X @           Ц X              Ц     ަ     bP0  D ؏
 ' 7 p`P0Dd 
   P	 	     
    k
    
    
 6
 ] 
	p`0PDd 
        > P    \    h                ç    ϧ 	   ۧ               v                     -    b        
    J
 	   
 
   : : &  x 	h   / 1 	p`0PDd `
 r       q             1      h 0!  x  T H !     T H !     x  T H 6
 ] 
	p`0PDd 8
    &     E    }                    s         	   L 
   / 1 	p`0PDd 
 r             :        ] ] U  
	p`0P! h
     h !       h    D 
 " #     . 7 p`0PDd 
        # z#     #    #    +$    x$    $    = ,4e Z 
p`P  Dd 
            0 >    J    V                 	    
   ˨         $ %     &    C&    Z&    &    &    '    ?'    ['    ' 	   G( 
   (    ( &
 &d
 !T 4 R
pD p
   ) G)     ) / 1 	p`0PDd H
 r   * *     *    *    A+    , ,4)  
p`P  D  
          &    2    >    D    D     J    V    b 	           D     D D             + ,     %,    ,    ,    ,    ,    -    L-    [-    -    - 	   - 
   1.    H.    b.    .    .    .    $/     }/ 
   /     / /    / , ,4)  
p`P  D 
      ̩                D    D         &    2 	   R        D     D D             / _0     u0    0    1    -1    C1    `1    1    1    2     2 	   62 
   2    2    2    2    3    ?3    t3     3 
   3     3 4    4 = ,4= 2 
p`P  Dd Ѝ
            ʪ    ܪ          @4 4     $5    A5    5    5    6    7    7     7    7 6 (4   
p`P  Dd 
             ( P8 R9     z9    9    9    7:     `:  
0D 
 L     @ : :     :    
;     L :c 2d -e (xf $hg  
p`0  Dd X
 #                                                 ͭ 
   ٭         
       	        !       	      ̳ 	        h   @; `<     <    <    <    <    = 
   W=    =    3?    ? 
   ?    {@ 
   @    A    A    EB    SB    C    (C    JC 
   C    C     C                  A    R                    X 	   i          P0  D X
 A 0x ,h (4<2
p`P  Dd 0
 b	  0     <    H    T    `    s                     
       Ǯ    Ӯ    ߮                        '    3    ?             0D #E     RE    _E    sE    E    E    OF    YF    F    *G    ]G 	   H    TI 
   aI    J 
   J    J    J    }K 
   ZO    O    .P    UP    bP    Q    *Q    vQ    Q    1R    KR    R    R    R    R    S    #S    1S    >S    KS    S    S    S    S     S A 0x ,h (4@6
p`P  Dd 
 	  P     \    h    t                        ï    ϯ 
   ۯ                        #    /    ;    G    S    _ PT CU     rU    U    U    U    U    oV    yV     W    ]W    W 	   1Y    Y 
   Y    6Z 
   PZ    Z    Z    [ 
   _    `    ^`    `    `    @a    Za    a    a    ab    {b    b    b    
c    c    <c    Sc    ac    nc    {c    c    c    c     d     )d / /h +/ 't. #d- 4, ( P  D 
 p     |                         d 9e     ye    e    e    e    Rf    `f    f    .h    =h    Gh    Uh     h "	 "d( T' 4& $ p  D 
 а  i <i     j "	 "d. T- 4, * p  D 
  @j |j     k "	 "d( T' 4& $ p  D h
 k ,l     m "	 "d. T- 4, * p  D @
 0m lm     n #	 #t3 d2 41 . P  D 
               n o     p    vp    p    Zq    q     q 1
 1x -h )tC %dB !4A > P  D 
       ,    8    D         q r     s    zs    t    u    [u     vu "	 "d( T' 4& $ p  D ȋ
 u u     v "	 "d. T- 4, * p  D 
 v w     hx "	 "d( T' 4& $ p  D x
 x x     y "	 "d. T- 4, * p  D P
 y z     X{ #	 #d4 43 . pP  D (
 P     \    h    t { k|     |    }    =}    }    8~     S~ 0
 0x ,h (dB $4A < pP  D  
                       p~ n                           7
 )h %42 ( 
p`P  Dd ؊
 "           ȱ    Ա             0      G    U    z            9    Æ    φ         % 7
 )h %42 ( 
p`P  Dd 
 "      ` M     w            ?    ӊ    i            ;     U <
 *hi &d "4  
p  Dd 
                 $    0    <    H    T    ` 	   l 
   x 	                           ̲    ز                             ,    8    D    P    \    h    t      !    "    #           %   ڳ    $   &      X 	    h   8             @ l                 7    z        2    V    d     	   T 
        
    	   ړ     
           G    ~                             0                    c            0            5        ɚ        h                
    ,    L          !    "   ( #   e $    #    "    !        '    5         	   С        .    J    x       %   ʳ &   
 
2PD 
 <
 *hi &d "4  
p  Dd `
                                ,    8    D 	   P 
   \ 	   h    t                            ȴ    Դ                            (    4    @    L    X     d !   p "   | #           %       $   &      H 	    h   8       Т W     {      أ    T    F    V                ٧ 	    
   ۨ     
   	 	   *    ީ 
       `        Ϊ    1    ?    M    ϫ        =    t    /    =    K    Y        ܭ    &    p        +    u        	    3                 ?    M    l        ó      !   1 "   h #    $   / #   = "   K !   Y     g    u    Ŷ     	       E    n               %    &   
 
2PD `
 # p`0Dd 8
 z   е     ܵ  k              3  4 2p!
 
d T @ S   !   @ S   !   d  T @ S   $ Rp`0D 
               t @            8    n               
 
2PD 
 $ Rp`0D 
                @             8             C       -    
 
2PD 
  2
p!
 
d 4 P ^ 8 !   P ^ 8 !   d  4 P ^ 8 !
 
d 4   8 !     8 !   d  4   8 !
 
d 4 ` n 8 !   ` n 8 !   d  4 ` n 8  R
p`0D 
         P                  @ @           l 8       0 X     b    s      l     y    
 
2PD 
 !
 
d T     !       !   d  T     / 1 	p`0PDd 
 r             Z        = ,4< 2 
p`P  Dd p
         ж    ܶ                    :        	 t d T 4    d 4 
p  !
 
 T    !          zx dh &% p`P0!  
  0  !  	 	
 0  ( !   0  ( !    0   	  0  D H
                          -     
R0D  
       _  d 4
 
RpD 
 p        
R0D Ј
 P        
R0D 
   9      9	 (4A 8 p`P  Dd 
                              %    W             =
 ,hP (4  
p`P  Dd X
     ,    8    D    P    \    h    t         	   ÷    ѷ    ݷ     
    
                        v            F    y                x             	    
   
    R    c    | 
   7     
   S    d 
   q                     4 &d  "4  	pP  Dd 0
             (    4 @    L    X    d p    |  
            P          0    V    u      `                     >    o 	         
        
    =
 ,hP (4  
p`P  Dd 
               @      '             f                2                 	    
   -    r         
   W    
 
   s     
                       $ 
 
d	 
Rp! 4    !      .  t d 4 	PDd 
 J         X           - ]    j < < 7x
 3h /t' +d& '4$  
P  D 
 и      0      , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t   ( !     (  d 4 pD 
  
 D
     
 	 	 0      d 4 p h d
 4	 Rp.  t d 4 	PDd h
 J                                  *    7 g    t ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P  D @
 0     <    H    T    `    l    x                  S     d    r                             	                               9     a / / *x &h % 
	p`0PD 
            
         #     # / / *x &h % 
	p`0PD 
     $ $     $    +     +  0D Ȇ
 , D,     ,  R0D 
  - !-     0-  R0D x
 P- -     -  0D P
 - $.     .  R0D (
 . /     /  R0D  
 0/ /     /  
 D ؅
 / 0     S0  R0D 
 p0 0     0  R0D 
 0 !1     <1  0c `   ! t `1 1  !   `1 1  &  p`0  Dd `
     2 2     2    2 # p`0Dd 8
 z   3 y3     3    3 " "d 4	 RpD 
 p5 5     5    6    D 
  8 8     8 { j5 b6 Z7 R8 J9 B: :; 2< -x= )h>  
	p`0PDd 
 B  й     ܹ                      $ 0    < H 
   T    `    l    x                            ̺    غ                 8 9     9    :    N:    z:     : ;    ;    <    4<    `<    m< <    < 	   =    = /= 
   A=    =    = 
   >    J>    [>    >    >    >    1?    >?    Y?    ?    ?    ?    @    }A    C    F    F    \F    mF    zF    F    G    !G    ]G    nG    G    G 
   G <
 *xC %hD  
p`0  Dd 
 +           (    4 @            c    o    { 	             
                                                       O    [    g    s                           
                                  	    \   L X   	    \   ü X   	    \    ' X               pH I     LI    I    I    I     lJ K    K K    K K    K    L 
   L    M 
   &M    4M    MM    M    M    M    1N    BN    _N    N    N    O    %O    HO    \O    O    aP    sP    P    P    \Q    nQ    Q    Q     Q    5R    lR    R    R    S    )S L     Y        ǻ     	   < 
   ü     м    ݼ     4    A     
 
rPD 
 { j8 b9 Z: R; J< B= :> 2? -x@ )hA  
	p`0PDd p
 r       ̽    ؽ                       , 8 
   D    P    \    h    t                            Ⱦ    Ծ             S `T     T    T    U    :U     U FV    V    V    V     W    -W lW    W 	   W    W W 
   X    X    X 
   X    
Y    Y    yY    Y    Y    Y    Y    Z    qZ    Z    Z    Z    =\    d^    `    `    %a    6a    Ca    ta    a    a    &b    7b    Wb    b 
   b <
 *xG %hH  
p`0  Dd H
 c                $ 0            S    _    k 	   w          
                                                       ?    K    W    c    o    {                   
      8             L             ` 	    \ H  < X   	    \ P   X   	    \ X   X               0c c     d    Id    ~d    d     ,e e    e yf    f f    f    vg 
   g    g 
   g    g    
h    Zh    kh    h    h    i    i    i    i    i    i    j    j    zj    !k    3k    Ek    k    l    .l    @l    l     l    l    ,m    mm    m    m    m <     I             	   , 
                 $    1     
 
rPD H
   
p`0  D  
                	    8    H   o 0o     fo               
 
RPD  
  0. h 42 . p  Dd 
 R        r Or     r    r     r = = 8 3x /h +4> 8 p`P  D Ѓ
      (    4    @    L    X    d     @s v     v    v    w    (x    Dx    x    y    z    {    {    {    {  p`0D 
               H @           p 8       | w|     | p     }    
 
2PD 
  4
 
RpD 
                                       } 8}     @}    H}    P}    X}    `}    }    Q~  0+
 +t# 'd" #4!  
P  D X
   ~ "      4 4 /	 *x
 &h "d 4  pP  D 0
 0 0 T     a  d 4 pD 
 @ p      k > > 9 4x 0h ,5 (t4 $d3  42 . P  D 
 P     \     h       W             ݋  4	 RpD 
             a     o      4	 RpD 
           Ќ          c " "d 4	 RpD h
       *  č     ҍ      ' 'x h 	   4 r
p`P!    x !     x ! h ݐ   !   ݐ   ( (h $d  T 4 
pD @
 @ y     * +  	p`0PDd 
    @     L    X d    p    |       D    u             k         D    l    ֗    @ D 2# -$ (x% $h& N 
p`0  Dd 
 +                                       	   )           x     
           
          	    \    5 X                b         0    ]    ~    Κ        ћ        j 	    
   ќ    O    ǝ    ;     5     C         
       >    i      bP0  D 
 +  	p`0PDd ȁ
                 ?     d            !          3    d            ` D 2# -$ (x% $h& N 
p`0  Dd 
 +                              %    1    = 	   I                
           
          	    \    U X                          P    }            
        2     	    
       o        [     U     c         
       ^          bP0  D 
 & 4 p`PDd x
 J     S     a               %      
 t	 d T 4 2
 
4 
2`! t  % ` !    % `    D P
   ]     h  t d 4 P! t   0! !     0! ( (h $d  4 
pD (
               ( 	    8    X                             bP0  D (
 ! t   0! !     0!    D  
 0        4 R
p`PD ؀
 0 <    H    T    d    p       ?             ķ    ط         	 	2P0! 
 t	 d   7 ` !     7 `  4	 2`! t    !      / 1 	p`0PDd 
 r  p ѹ         *        !  x   H !      H !     x   H )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '   @ N  ! h	 N   !   N   !   @ N  * 0 p`0P  Dd 
 r                2        = = *  x h   * 0 p`0P  Dd `
 r                2        % %4) %  p`P  !& & 
 x h   P  !     P  !     
  x  h   P    D 8
                0 0h ,4  p
`PD 
                           P                N    [                            u      <
 *x %h 
p`0  Dd 
         )    5    A    M    Y                           
            
                                                             
                                       #   ) $   5 $   A $   M    Y    e )   q 	   	                                    	        X       \    X           X   	       X                 s        r        $    G         	       e        
    0 
           H                    B    T    b    ~                                     !    e !   w                        F "   X    s #    $   ^ %   p $    &    $    '    $   $ #   @    \    y                     (        )    *    )       T          
   Z    k 
            n                W    h    u         ,    =                 $             bP0  D 
 B 1xS -hT )4  
p`P  Dd 
 "                                        	    	       5    G 	   U    a      [     i    #    @        }            \    r        !            ? 	    
    	            
       B    _     	               /     I i W- O. G/ ?0 :1 52 0x3 +h4 &dr "4q j 
p  Dd 
   p                   |                               	    
    	        
                        $    0    <    H    T    `                                              l    x     !    "    #    $    %    &            (       '   )      \ 	        8    2            N    c        ?    T     	    
   ?    ^ 
   l 	       R 
        
                       B                    [            j                                                  
 !   M "    #    $    %   ; &   V '   r &    %    $    #    "    !       '    V 	                       (    )   
 
2PD 
 @ @
 ; 6x 2h ## p`0D p
          (    4    @    L    X                                   d H               p              d            :	    	    
    
     
     
     _    w                     
 d     q         
 
RPD p
  d 4
 rpD H
  
 
     /  T 4 	p`D  
               p                  6     n D Dx @h <4> /6 !p`P  D ~
           $ 0                   )    3      $ $h d> 4= 8 p  D ~
 @     L    X                                    	    \   d                ` \                             8    D     f j    v      d     
 
PD ~
 :
 (x* $h+ X 
p`0  Dd ~
                                                    	    \                  .    ?        (    r        /                       -      
 
PD ~
 $ $h d< 4; 6 p  D ~
          (                  O    [              	    \   4                p l             
                 %!    1!     S! W!    c!     ! 4     
 
PD ~
 :
 (x( $h) T 
p`0  Dd X~
 {  p     |                                            	    \ p          ! "     #    '#    u#    #    ?$    m$    %    &    &     & &    &     &      
 
PD X~
 : : 5h 142 %( p`P  D 0~
                @' '     X(    (    (    (    * <
 * %h 0 
p`0  Dd ~
 S                       ( (                	    (                  + +     , ,    w-    -    /          U    m                  P0  D ~
 . .x )h $t?  d> 4= 8 	  D }
 @     L    X                                   	 	    \   d     0 *1     t1    1    1    q2    2    3    3    4     '4 +4    74     Y4 d     
 
PD }
 :
 (x* $h+ X 
p`0  Dd }
                                                    	    \           4 5     
6    6    y6    7    87    f7    9    9    9     9 9    9     :      
 
PD }
 )
 )x $h d> 4= 8 p  D }
          (                  O    [             $ 	    \   4            @: F;     ;    ;    ;    o<    <    =    =    >     (> ,>    8>     Z> 4     
 
PD }
 :
 (x( $h) T 
p`0  Dd h}
 {  p     |                                           H
 	    \ p          > ?     
@    @    a@    @    A    EA    B    C    C     C C    C     C      
 
PD h}
 <
 * %h 0 
p`0  Dd @}
 S                                       p 	    (                   D D     E E    F    F    H          %    =                  P0  D @}
 # p`0Dd }
 z       0I I     I    I     jJ )  p`0P  Dd |
             ( 4         J HK     lK    K    K    L     ~L M    %M ! t PM eM ` !   PM eM `  t d
 T	 4 2 T r
p! h 
d
 4 pP P ( !   pP P ( ! h 
d
 4 0Q NQ ( !   0Q NQ ( Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P  D |
 @     D      T DU     W    
W     $X * , p`0  Dd |
 [  P                                  P  \ H   X X    
Y     Y \     j     BP0  D |
 @
 .x/ )h0 b 
p	`0  Dd x|
                                	   ( 	   4    @    L 
   X 
   d           p    |               D    P    \    h              	       H           Y Z     Z    Z    *[    [     &\ \    \    7]    g]    ]    c^ }^    B_    O_    ` 	   "` 
   `    a    a 
   a    b    oc    }c    8d    d    d    d    Rf    nf    j 
   j    j 	   .j    :j                          6     
 
RPD x|
 + +h ' #t d 4 PD P|
       j j     ul    l     m @
 .x+ )h, Z 
p	`0  Dd (|
                                 	    	   $    0    < 
   H 
   T           `    l    x           :    F    R    ^              	       H               m _n     n    n    o    o      p p    p    q    Aq    q    =r Zr    2s    Ds    t 	   t 
   bu    ou    2v 
   Bv    w    w    w    x    x    x    y    3{    O{    ~ 
   ~    ~ 	   ~    ~                          ,     
 
RPD (|
   D  |
 p     @ a      R0D {
        1  
R0D {
          d 4
 
RpD {
  n       4	 
RpD `{
            V  
R0D 8{
  Ʌ       d 4
 
RpD {
   n     ˆ  4 RpD z
       N     i  4 RpD z
           )  
 D z
 `        R0D pz
   !     0  R0D Hz
 P      ̉  R0D  z
       2 * T 4 p`Dd y
 Z   D                          P      Ċ                 ' * T 4 p`Dd y
 Z   P      Ɍ                 , 
 
t 4 # #t d
 4	 RD y
  9      &
 &d
 !T 4
 R
pD y
   ?     / /x +h	 'T #4  
	p`  D Xy
 @     `      b &
 &d
 !T 4
 R
pD 0y
  ߖ     = / *x &h % 
	p`0PDd y
    P        t    T 4
 
R	p`D x
     Л       d
 T r! x h 
t 4
    !         4  p`P  D x
 `             h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  D x
      w                             ;        o 	           Ǭ    Ҭ    ݬ            /     W    T 4
 
R	p`D hx
           #
 #h d T 4 pD @x
 p |     а      $    _         "	 "T 4  	p`  D x
          б      5  
 c    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  D w
             @              '    :    h            =     	   y    =    I    T    _    j             ٿ  
 D w
  @ t       R0D w
          R0D xw
 0        R0D Pw
        &  p`0  Dd (w
        0          
 J J B
 = 8 3x /h +t- 'd, #4+ $ 
P  D  w
 0       " "d 4	 RpD v
 0 t          	 	B  ! 4   pz !     pz " "d 4	 RpD v
       *               ` / /h
 + 't #d 4  P  D v
 @ L    X           -    5    R     S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P  D `v
 p     `       . h 42 . p  Dd 8v
 R  P               8 = = 8 3x /h +4> 8 p`P  D v
                                                 H    d    
                         V H @ 8 3 .x *h &44 * 
p`P  Dd u
           . h 42 . p  Dd u
 R   /     g    u      = = 8 3x /h +4> 8 p`P  D u
       g             J                        ]    h         " "d 4	 RpD pu
      
       "    p  t d 4 	 4H @ 
p`P  ! G   ; % !     ; % 3	 %46 0 p`P  Dd Hu
 z        ,    8    D    P    \             /     h                ,    6 (t/ $d.  4, ( P  Dd  u
 :  p     |                P          e    t     h R00	 0 & x 	h   !  @  d& !   @  d& !    @  d& / / & x h 4 p!    | & !     | & !      | & 8 8 & x h 4 p"
 "4 
p	`PD t
        G     g    ^ R R J B
 = 8x 4h 04- !" p`P  D t
                              $              0     O    ^    o    z        I    Z                 i W- O. G/ ?0 :1 52 0x3 +h4 &dr "4q j 
p  Dd t
   0            <           H           T    `           l 	   x 
    	        
                                                                                          ,    8    D !   P "   \ #   h $   t %    &            (       '   )      * 	        8            v                                - 	    
         
   '  	   F     ! 
   I!    i! 
   w!    !    M"    i"    "    #    q#    #    #    #    $    R$    $    *%    F%    T%    b%    p%    %    %    J&    &     &    &    & !   
) "   D) #   ) $   ) %   ) &   + '   1+ &   ?+ %   M+ $   [+ #   i+ "   w+ !   +    +    , 	   J,    f,    ,     ,       (    )   
 
2PD t
 2 2 -x )h %t !d T 4 
	D t
 0- {-     X. 0 0x ,h (d $T  4  
p  D Xt
       / /     /    1     1 3	 !4= 6 	p`  Dd 0t
                                           `- 	    x    h               02 2     4    $4    64    4    4     4    4      5      "                  P0  D 0t
 <
 * %h 0 
p`0  Dd t
 S                                        . 	    (       P5 5     6 6    7    8    :           E    ]                  P0  D t
 <
 * %h 0 
p`0  Dd s
 S                 $ 0 <    H H               / 	    (  0            `: :     ; ;    <    !=    ? 0     >    u                	      P0  D s
 <
 * %h 0 
p`0  Dd s
 S             H    T ` l    x x               0 	    (  `            p? @     @ 
A    A    1B    $D `     n                ,    9      P0  D s
 <
 * %h 0 
p`0  Dd s
 S             x                          1 	    (              D E     E F    F    AG    4I                  K    \    i      P0  D s
 " "4
 rpD hs
               2 @            X   I #J     9J           bP0  D hs
 " "4
 rpD @s
               $3 @           0 X   PJ J     J 0     >     bP0  D @s
 +  	p`0PDd s
                             	       
                     	                            	                                        J cK     K K    K L    +L [L    L    L    L L    &M    WM    aM 9 +x
 'h  
	p`0PDd r
        $ 0    <    H T    `    l 	       
                     	                            x      N N     N O    O JO    ^O O    O    O    	P    P MP    tP    P 	   P    P    P Q    Q Q    Q 3
 %h  	p`0PDd r
                             	       
                     	                            	                                        0R R     R S    /S _S    sS S    S    S    T OT    vT    T    T 8 *h
  
	p`0PDd r
        $ 0 <    H    T               	       
       `    l PU U     V `V    mV V    V V    V %W    LW    sW    W    W    W X    9X 
   X    Y HY    XY 9 +x 'h % 
	p`0PDd xr
                                	       
            Y Z     MZ Z    Z Z    Z -[    :[ j[    [    [    \    (\    2\ ]\    3] p]    ]  R
p`0D Pr
                           H: @            8       ] ]     ]    ^     ^          
 
2PD Pr
  R
p`0D (r
         0                  : @           L 8        ^ H^     R^    c^     r^ L     Y    
 
2PD (r
 % % !t d 4 
	ЮD  r
               ; @           p X       ^ !_     ca a          RpP0D  r
  R
p`0D q
                           < @            8   a a     a    =b          
 
2PD q
 % % !t d 4 
	ЮD q
               < @            X       Pb b     d d          RpP0D q
    4 Rp`D q
         0                  8= @           L 8       e >e     Ke    e     e L     Y    
 
2PD q
  4 RpD `q
         p                  = @            8       e e     e    e          
 
2PD `q
  4 RpD 8q
                           p> @            8       f :f     Hf    Vf          
 
2PD 8q
  T 2`! 	 t 4 pf f > !   pf f >  d 2p! T 4 g g  ? !   g g  ? ! T 4 h 
i  ? !   h 
i  ? /	 !h 4   p`P  Dd q
                   ,    8 D P         i [j     j j    
k    4k    Vk k    l    @l    bl l    l (m    =m ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P   T 4 p`!   u u @ !   u u @ 
 d T 4 p!  x x @ !   x x @  h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
pD p
         `     l    x                  A 	         8       ~ G~     T~    }~    ~    ~                   
 
2PD p
  4& $ p  D p
                                 lB 	   I      8    i             
      ,     8      
 
2PD p
  d	 4 RpY Yh  0  ' 'h "d T 4
 
rpD p
     Є ,     R ' 'h "d T 4
 
rpD pp
      Ǉ      #
 #h t
 d 4 rD Hp
         " "d 4	 RpD  p
  ċ     ҋ      " "d 4	 RpD o
 @           " - 	p`c @  !C
 Ch 8, &4 T3 42     D !       D 	 d T 4  p  D o
                     )    7        ;         T
 4 
R	p`D o
       P           )  	p`0Pc   !/
 /< &x= h> ~ Ԉ   0E !     0E ! 
  <  x=  h>  ~  Ԉ   0E 3	 %49 0 p`P  Dd o
 z  С [         ¢    ޣ    M    \     4* 	( p  D Xo
 0        !  0  d& !   0  d& !    0  d&  x h 
- D 0o
 @     L    X                 ˬ     ͬ c     v        í ܭ      k 
	`P!*
 *2 x3 h4 tj 4s   F F !     F F  4
 
RpD o
               `G @           p 8       0 U     ~ p     }    
 
2PD o
  4
 
RpD n
               G @            8             ޵          
 
2PD n
 1	 #h
  p`0P  Dd n
                     $    0        	       
                     
                                                              g      ׶         / _            ӷ     *    [    e 7
 )x
 %h !4!  
p`P  Dd n
    @ L X d    p    |                 	       
                     
                          l           3    G w        к         5    \                 2 $x
  h  	p`0P  Dd hn
                                	       
                     
                                                       E x         н      4    [    |     Ӿ         ; -x )h
 %4'  
p`P  Dd @n
      , 8 D P    \    h                      	       t           V           1    E u            /    9    C ~        X    q 6
 (x $h
  
	p`0P  Dd n
                                	       
                   K           $    8 h                 :    a             ! t   0! !     0! $
 $d  4 r
pD m
               N @             X                  RpP0D m
 ! t   0! !     0! $
 $d  4 r
pD m
               LO @           @ X   P }     O     RpP0D m
  
p`0  D m
                           O @            H                      /           2pP0D m
  `  ! T 0 E 4P ! t 4  T 0 E 4P !   t  T  4 0 E 4P    ! 4    P !     P ! 4  P q P !   P q P !
 
t d   H !     H !
 
t  4   0 P !     0 P !
 
t d   H !     H . .4= 4 
p`P  D xm
 @     @      = UeDx  =h! 6tL /dK (4J cD 
PDd Pm
         0       ! 4 p  D! !   p  D! !   4 p  D!  
R0D (m
  )     o  d 4
 
RpD  m
       +  
R0D l
 `        d 4
 
RpD l
  >       4 RpD l
       .     I  4 RpD `l
           	  d 4
 
RpD 8l
 @       & 4 pDd l
 z         H    j . 4  p`P  Dd k
     T          - d 4  p  Dd k
               . 4  p`P  Dd k
               &  p`0  Dd pk
        @            
 D Hk
 `        R0D  k
   !     0  R0D j
 P        R0D j
       2  
 D j
 P        R0D j
          R0D Xj
 @        R0D 0j
       " s st 
 ! 4 @  U !   @  U " "d 4	 RpD j
      :           P " "d 4	 RpD i
 P     z p            Pe?h 841 &c!& p`PDd i
        0       i ' 'd #T 4  
p  D i
                         } }  x 0! h    PW !      PW 3	 %40 ( p`P  Dd hi
 :       6     ]    	    	     @ `0P  ! I H tF 
 _
 W !   
 _
 W !   I  H  tF 
 _
 W  "p0  !    d T
 
 
 4X !   
 
 4X  d 4 p! t d 4   ) D! !     ) D!  4* 	( p  D @i
        = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x  : TY !    : TY * * h  !     Y !   x   Y !     Y !      Y @
 @ , "   ! x  T  Y !  T    Z ! h   R! Z !     R! Z !   T    Z !    T  Y 9 9 !x 
 !  h p$ $ tZ !  $ c' Z !  c'  ( Z !   c'  ( Z !   $ c' Z !   p$ $ tZ 9 9 &x h 
  !   . . Z !  . 3/ [ !   . 3/ [ !    . . Z   0  ' 7 p`P0Dd i
   5 5     D6    6    6    
7 ' 't #d 4 
PD h
           07 o7     (9    <9     9  d Rp! T	 ? #? \ ! h 
 4 #? ;? \ !   #? ;? \ !   ? #? \ /
 /t" +d! '4   
P  D h
     ? 1@     @ )
 )h
 $t  d T 4    D h
  0B B     FC ! T C C 1 !   C C 1  d
 T	 4 RpD xh
  D RD     D D     D !" "t  d 
T 4 E E P !   E E P ! t  
d 4 `G G P !   `G G P !" "t  d 
T 4  I 'I P !    I 'I P  Bp
`  !$
 $  
 
T	 4 J J ] !   J J ] ! t  
d 4 @K qK P !   @K qK P 6
 3 
	p`0PDd Ph
       L M     3M    lM    M    N    6
 3 
	p`0PDd (h
       0N N     N    N    @O    {O     2pP!
     
d 4	 O O  _ !   O O  _   P!   t d 4 R @S @_ !   R @S @_  
R0D  h
 PT T     T  d 4
 
RpD g
 T .U     U  4 RpD g
      V NV     iV . 4  p`P  Dd g
    \ \     \    ]  @ 
	`P  ! > t? 4F @] v] @` !   @] v] @`  " P   R0D `g
      ` '`     B`  
 D 8g
 `` `     `  R0D g
  a !a     0a  R0D f
 Pa a     a  R0D f
 a b     2b " "d 4	 RpD f
 Pb b     b    b " "d 4	 RpD pf
 c Tc     bc    c  4 RpD Hf
     c c     d " "d 4	 RpD  f
       Pd d     d    d IE;h 7t! 0d  )4 C 
PDd e
    0 < e |e     e    Ng W
 Wx 8h  4J B 
p	`P  ! I g g b !   g g b U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4  r r P !   r r P !  t d u <u H !   u <u H !  t d 0v \v H !   0v \v H  p  ! 4 y y c !' '  d y y c !   y y c !   y y c  . `P  !p ph :* /+ $, t- 44 z { Ld !   h  *  +  ,  t-  44 z { Ld  
R0D e
     p} }     }  d 4
 
RpD e
  ~ N~     ~  d 4
 
RpD e
 P     \ ~      &    4  d 4
 
RpD Xe
 p     | P            
 D 0e
 0 d       R0D e
 Ђ         R0D d
          T 4 `  ! t   f !     f " "d 4	 RpD d
       d     r     " "d 4	 RpD d
        $     2     Pe?h 841 &c!& p`PDd hd
        !     ي 3	 %49 0 p`P  Dd @d
 z                                                   .            0
E"h t d 4 C
P  c `   /
 /t" +d! '4   
P  D d
   a     # /
 /t" +d! '4   
P  D c
 `      V O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4  7 P !    7 P ! t  d 
T 4  ݣ P !    ݣ P " "4 
p	`PD c
  ٥      Ne=h 6t< /d; (4: c4 
PDd c
         , @      9    ߫       	  h d 4  p  D xc
 @ P ׬       t d 4  t T 4 ! d  a j !    a j " "d 4	 RpD Pc
       D     R     
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h  e j !    e j 	 	2p0!  
d	 T   j ! 
  6 j !    6 j !     j !" "t  d 
T 4   G P !     G P  T `  !
 
t 4   |k !     |k ! t   S ` !     S ` 9 9 "% p`P0!{ {	 m
 X I =
 1   x h   k !     k !   	  
      
      x  h   k 
 
0!,
 ,  ( t d T   hl !     hl <5.h *t #d 4 3
P  Dd (c
 R   P `      L    ) )d: %49 2 	pP  D  c
 `     @      A  d 4
 rpD b
 0 _     ~     -	%t d
 4 #P  Dd b
 B   p            , ,1 pP!I Ih :+ ', #- . 
d/ 40   m !     m L L 7 " p`P0!| | g C 9 	 x
 h   m n !     m n 1
 1h -4# ! p
`P  D b
            S     p        ,    A p
 ph hd+   
p0P  !  t d 0 \ H !   0 \ H !d d	 [
 O B 9
 0 $ x h P  k !   P  k !   	  
      
      x  h P  k ! !dK !4J !B pP  ! h  I @ w o !   h  @ w o !   @ w o '
 'tK 'dJ '4I 'B P  !* * ! x h    o !     o !  t d `  H !   `  H      T 4 
R	p`D `b
           ^  T p  !
 
d 4   p !     p /
 /t0 +d/ '4. ( 
P  D 8b
             /
 /t0 +d/ '4. ( 
P  D b
 P" "     i#  9 
0P! 5 6 t7 d8 $ K% pq !   $ K% pq !   6  t7  d8 $ K% pq  	  h
 d 4  p  D a
     ) p*     * BE1h *+ #* d) 4( C	& Pc      ! t d 4 , , 0r !   , , 0r  d
 T	 4 RpD  0 0     51    	 "  D    #8 8  8  P  
 
4
 
rP t	 d 4 2D    7: :       d 4 2pD    ^; |;      	 4 rp`D    ; <  < 	 	b   rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!  @F F s !. . 	 F F s !	 	 F F s !   F F s !   F F s != =2 *3 4 4= 	J 1J 4t !   @F F s  20 R0
 
4 
2p 20%	 4- $ 
p`P  c   " "t 20 % c    B   B  
 
4 
Rp 20
 t d
 T	 4 R B   B   20! 	 t 
d T T T t !   T T t  20
 
4 
2p d 4 2p 4 p R
pP0! d
 @X X Xu !   d
 @X X Xu !   d
 @X X Xu !   d
 @X X Xu 
 
4 
2p! d [ V[ u !   [ V[ u  20 d	 T 4 2! t \ J] u !   \ J] u  20
 
4 
2p 20u ut 
4 
2`
 
4 
2p 4 2
p`P 4  d 4 2p
 
4 
2p B  ! 4 h h v ! t  4 h h v  B  ! 4 h Ii v ! t  4 h Ii v !   h Ii v  B  ! 4 i )j w ! t  4 i )j w !   i )j w  B  ! 4 j 	k Pw ! t  4 j 	k Pw !   j 	k Pw  B  ! 4 k k w ! t  4 k k w !   k k w  B  ! 4 pl l w ! t  4 pl l w !   pl l w  B  ! 4 Pm m x ! t  4 Pm m x  B  ! 4 n in Px ! t  4 n in Px !   n in Px  B   B   B   B   B   B   B   B  C
 CT	 >4 d
 2
p d T 4 p T	 4 2p!  d Pr r  y !   Pr r  y  2p 4  2p`P! 4 t t Hy !   t t Hy 
 
4 
2p T 4 Rp`! 
 0v qv y !   0v qv y  T 4 R
p`
 
4 
2P!
 
t d Py y y !   Py y y !   t  d Py y y !   t  d Py y y 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !  p  xz !    p  xz !H
 HT : 5t
 0d	   p  xz  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p
 t d
 T	 4 R
 
d 
2p! 4 В Z L{ !   В Z L{  t 20 d 4 2p! T  ~ { !    ~ { 
 
20 d	 T 4 2p!    { !     { !      { !     {  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d   l| !   t   l| !     l|  t 20 20 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p d 4 2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	   ~ !     ~  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	 P   !   P    B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
PD  <     0    e    q                                 2P'
 '4 
p`PD       } `          ^      2P6 (4   
p`P  Dd                  D      0     H    l    z        v                6    R    Z    d      2P, ,4"  
p`P  D 0      %    1    =       )    2    >        6 	    P 	      2P'
 '4 
p`PD X U     I  	  	      	    	      2P, ,4"  
p`P  D  ~               	 O	     	    	    	    R		    		    		      2P'
 '4 
p`PD        		 
	     1
	    
	      2P- -x )h %4 
p	`PD         	 	     	    	      2P' d 4 pDd  j   5 `	 	      2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p\ \T p`0c P   
 
4 
Rp9
 +t! 'd  #4  
P  Dd      [     g    s ,	 ,	     
-	    -	    /	    /	     /	 9
 +t! 'd  #4  
P  Dd H              0	 
1	     1	    -1	    +3	    3	     3	  d 4 pD p       4	 4	     4	    5	     6	  d 4 pD        6	 6	     6	    7	     7	 9
 +t! 'd  #4  
P  Dd               08	 z8	     8	    8	    :	    ;	     o;	 9
 +t! 'd  #4  
P  Dd               @<	 <	     <	    <	    >	    ?	     ?	 9
 +t! 'd  #4  
P  Dd          '    3 P@	 @	     @	    @	    B	    %C	     C	 *
 *4 
p`PD 8 ?     K `D	 D	     D	    H	     %I	  t d T 4 9
 +t! 'd  #4  
P  Dd `    W     c    o    { R	 R	     S	    !S	    1S	    Y	    3Z	    Z	     Y[	  B  
 
4 
Rp, ,4  
p`P  D               D    D    D ]	 .^	     G^	    X^	    b	    #c	    Ec	    mc	    c	    c	    tg	    g	     g	 	 $ 
p`0  D                                      l @            X    h	 Xh	     ch	    nh	    i	    j	    n	    n	     n	               
 
rPD  
 
4 
Rp
  
	p`0P $ P  !u ud" #     
t! 4# 	 	  !    	 	  !   	 	  !            t!  d"  4# 	 	   T
 4 rp`  
  !m m bT   t d 4 	 	  !    	 	  !   	 	  !         t  d  T  4 	 	   T
 4 rp` B  !6
 6 1t )d
 
T	 4  	 9	 L !    	 9	 L ! 
    t  d
  T	  4  	 9	 L )	 !  p`0  D           )    5                            @           A 8   	 	     	    #	    .	    	    	    	    մ	    	     	 A     N    u     
 
2PD   d T 4 p*	 *4  p`  D                                    @            8   	 	     ̷	    Y	    	    <	     X	               
 
2PD   #
 4 
p`Pc X    	p`P0c `   
 d T 4 p t d
 T	 4 2 	p`P0c X    BP  !; ;t
  
d	 4 	 	  !   	 	   20!
 
t d  	 H	 T !   t  d  	 H	 T    !W W	 '  t
 d T 4 	 	  !   	 	  M
 M T 4
 rp`-
 a 
	p`0Pc   #
 4 
p`Pc `   D
 Dt d	 T 4 2
 d T 4 p   c    !$ $  t d T 4% +
 +
 X !    +
 +
 X !   +
 +
 X 
 d T 4 p
 
P  !b b
 $ 	 t 
d 4 :
 :
 Б !   :
 :
 Б  bP  !' '   t 
d 4
 p@
 @
  !   p@
 @
   T	 2! t d 4 @C
 UC
 X !   @C
 UC
 X  2
p`0! 
 
 T
 E
  F
  !    E
  F
  !   
    T
 E
  F
  
 t	 d T 4 2 20 20 d 4 2p t d T 4 #	  
p`0  D (          D    D    D                                @            8   N
 N
     O
    "U
    TU
    {U
    U
    U
    V
    V
    V
    V
    X
     X
          F      2P
 
2PD (  d 4 2p)	 !$ p`0  D P T     `    l           x                             D    D    D           <                                  p                 
                       @            8   @            8   @           Y 8   @            8   Y
 Y
     Z
    @Z
    _
    _
    _
    _
    `
    %d
 	   Wd
    ~d
 
   d
    d
    e
    Ve
    ee
 
   ze
    i
    i
    n
    n
     n
                   .     f                   2P
 
2PD P  2P
 
2PD P  2P
 
2PD P 
 
2PD P  4 
p`Pc X    d 4 2p6 (40 & 
p`P  Dd x *                   D `s
 s
     s
    t
    t
    Gz
    rz
    z
    !{
    T{
      2P6 (40 & 
p`P  Dd  *  6     *    _    k    D {
 |
     %|
    b|
    r|
    
    ҂
    
    
    
      2P; -x )h %4, " 
p`P  Dd     w           
 w
     
    
    
    
     
 
 + 
	p`0P9
 +t3 'd2 #41 * 
P  Dd  J        `          *     F*  20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   d T 4 2p bP  !' '   t 
d 4
 = 	>  !   = 	>   T	 2! t d 4 @ @ ` !   @ @ `  2
p`0! 
 
 T
 PC C  !    PC C  !   
    T
 PC C  
 t	 d T 4 2 20 20 B    D                        X 	   HO (    8   	    u 0    8   	   e 8   % 8   	    \ @   ^ 8   	   8 H    8   	   I P     8   	   ȇ X   O  8   	    `     8   	   `[ h    8   	   Px p   c 8   	    x    8   @            8    J J     'J                        2    P     k                   #     A      \                          U     p                           
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD   B   20# 4 rpDd @ 2   + J K     WK 1	 #t! d  4  P  Dd h    7     ]    i    u                      0L dL     L    L    L    M    "M    5M    M      N    GN    zN    N    N    N    N      2P d
 4 
RpD   O 9O     O  20 B  ? .4  
p`P  Dd  :                       
        %    1    = 	   M 
   ]    m    y 
                                               *    6    F    R    ^    n    z          !         #    PQ Q     Q    S    <T    T    T    T    *U 	   EU 
   YU    U 
   ,V    >V    OV    V    0W    BW    }W    W    W    X    BX    VX    X    X    X    Y !   !Y "   qY $   Y    Y    Y    cZ    Z     [    [    3[     K[  2P 20   ! 4
 ^ 3^  !   ^ 3^     ! 4
 P_ _ 0 !   P_ _ 0 
 
4 
2p 2p! 4 pa a h !   4 pa a h !   4 pa a h !   4 pa a h !   4 pa a h !   4 pa a h  B  
 t	 d T 4 2    h 	x    h 	x                   p                  d@     x                       0                     H            @                 M         8   `                 P                             0                                      HO (          K                  P}     p                     0     0                     ؍         (                         `                     v            U                      `                    ( P 0                     8b (          a                          X                    d         h                    @     ȧ                      P 0  Ȱ                                 8b            a                 z         @   p                                           S         8   Pa                 0 x P 0  Ȱ                                     0         P                          Ȭ                     Ȳ 0                           @                     8e         @                     0                      0                 Pa     P         0                 0T                          N         X   PT                 0 0                      د `  Ȱ                                       @                     8            d                 HO            K                  `[            0c                0         X   p}                       ب                      {         8   0`                 0         @    ~                @ 0                {         X                       Ȳ 0  Ȱ                                           p                                              ȭ Ȳ 0                                                     @                     p         @   T                 0l         @                    e            b                m         X   P                                           x Ȳ 0                    `q         X   `                      Ȯ                           X                     M            0                              b                  u            06                   \             x                 `         X                     O         8    b                ة Ȳ 0                     0                 ȇ            `                  [            >                   0                           `                     T        (   g                 p     (                                              Ȳ 0                          X                     (          p                  T         (   g                 `                               8                     P 0                    ȱ X ة Ȳ 0  Ȱ                                     PM         @   p                 Pa     @         0                 Px            pc                 Ph         @                    K         8   c                       P                    8   P 0  Ȱ                                    P{         X                   x P 0                     T (       (   g                 X 0                    P 0                P  Ȳ 0  Ȱ                                                            m            ]                  h ȭ Ȳ 0  Ȱ                                      د H  Ȱ                                 e         @                             @                             OjY                   L   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332.cp36-win_amd64.pyd PyInit_stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_477312813315038332   @         "  `                    0            @ h          v             (                      p           0 0                    :                               2     J     b     n     |                                        (     F     Z     n                                                                    R     H               b                    z     8               j          0     J     f                    &     H     b                         .     V     |                              h     B                              `     4                    N               v     <               p     4               X                    D               t     2                    D               0          X                            X     b     z                                         
     |           r     `     >                                              Z                                                                                      h     \     R     D     ,                                   L                  R     ,     v                    @          r                       "     l     6                  d                  t     b     F     2                                             j     X     J     8                                                  ~     p     \     N     8                                              t     `     F     0                                                             \     L     >     
                                        h     R     D     ,                                             t     Z     F     6     &                                        t     Z     B     ,                                                       &     6     R          d     x               $                                        $          j     8     L     b     x                                   
     \          j     J     :     "                                   ~     j     Z     F     (                         PyBaseObject_Type rPyObject_SetAttr  PyUnicode_InternFromString  ? PyCFunction_Type  5PyOS_snprintf PyThreadState_Get W_Py_CheckRecursionLimit  PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches _PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  PyExc_RuntimeWarning   PyErr_PrintEx \PyFunction_Type KPyFrame_New  PyExc_DeprecationWarning  PyExc_KeyError  {PyImport_ImportModule }PyImport_ImportModuleLevelObject   PyErr_NormalizeException  RPyUnicode_AsUnicode pPyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  rPyUnicode_DecodeUTF8  TPyObject_GenericGetAttr PyTraceBack_Here  _PyThreadState_UncheckedGet PyExc_RuntimeError   PyExc_IOError sPyObject_SetAttrString  PyLong_FromLong SPyObject_GC_UnTrack PyUnicode_FromUnicode `PyObject_Hash  PyErr_SetNone 
PyExc_MemoryError  PyDict_GetItemWithError Py_GetVersion YPyObject_GetAttr  :PyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags * PyBytes_AsStringAndSize k_Py_NoneStruct  PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size =PyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable ]PyObject_GetIter  PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx *PyExc_ValueError  X_Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError nPyObject_RichCompare  PyTuple_Type  a_Py_FalseStruct u PyCoro_Type BPyFloat_Type  PyMethod_Type PyLong_Type  PyType_IsSubtype  PyNumber_Subtract  PyErr_Restore PyExc_OverflowError wPyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  F PyCapsule_GetPointer  QPyObject_GC_Del  PyErr_Fetch DPyObject_CallFunctionObjArgs  PyLong_AsLong JPyObject_ClearWeakRefs  jPyObject_Not  PyUnicode_FromFormat  [PyObject_GetBuffer  PyList_New  PyModule_Create2  PySlice_New jPyImport_AddModule  "PyType_Ready  ZPyObject_GetAttrString  r_PyGen_Send  PyErr_Clear PyList_Append 6 PyBytes_Type  `PyUnicode_Decode  W PyCode_New  3PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  BPyObject_CallFinalizerFromDealloc dPyObject_IsInstance PyExc_StopIteration PyList_Type  PyDict_GetItemString   PyDict_GetItem  \PyObject_GetItem  GPyObject_CallObject  PyErr_CheckSignals  RPyObject_GC_Track 3 PyBytes_FromStringAndSize xPyImport_Import PyExc_NotImplementedError ZPyUnicode_Compare ePyObject_IsSubclass "PyExc_TypeError PyMem_Realloc > PyCFunction_NewEx N PyCapsule_Type  fPyObject_IsTrue PyExc_NameError PyTuple_Pack  _PyByteArray_empty_string Py_OptimizeFlag @_PyUnicode_Ready  PyMem_Malloc  PyExc_IndexError  PyExc_ImportError gPyGen_Type  r_Py_TrueStruct  
 PyArg_UnpackTuple PyExc_SystemError  PyExc_AssertionError  tPyObject_SetItem  _PyObject_GC_New  PyTraceBack_Type   PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  uPyObject_Size  PyBuffer_Release  @PyObject_Call ' PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python36.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 1EnterCriticalSection  LeaveCriticalSection  
DeleteCriticalSection SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  vGetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  iSetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  ~IsProcessorFeaturePresent wIsDebuggerPresent AQueryPerformanceCounter GetCurrentProcessId GetCurrentThreadId  GetSystemTimeAsFileTime DisableThreadLibraryCalls aInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                          2-+  ] f      /                              Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
                                      v                                                                                                                                       @             @                                                                                                                           P                                                                                   Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                     I                                                                                      Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
                   	                   o   `K
                  o   0C
                   p   `@
                  tf   8
          `   p   p)
              p   $
          p   (p   @	                  8p   `	             Hp   	                  Pp   	             `p   `	             pp   	          0   p   p	          @   p   	          p   p   	             p   0o	             p   h	          "   p   ]	                  q   \	                  q   \	                  (q   [	                  8q   R	                  Pq   I	                  hq   PD	                  q   @@	                  q   0<	                  q    8	                  q   p6	                  q   4	                  q   0	                  r   +	                                                                         r   p                                                  	           `   `                   	                            D      s                                                    `                                           PL
                                                                                              Transform parameters from unconstrained space to defined support                 r   P                           l   0                      0r                         %                         @r                          Pr      `                   `r   @                      m                          /                          pr   `                      r      @                   r                                                                          (          l                      8          H              H                                                   l   H                  m   @                  m   =                                                  0L   @o
          #   Tv    ^          P   TW   W             LY   [          (                                                          m   p               P                                                   P   8                                                    D      n                                                                                                                                                                                                                          `v                                                                                                                                       @             P                                                                                                                      `                                                                                   Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.                                                     @w                                                                              `                                                   
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
                                     u                   P                                                                                                                    @                                                                                                                                                                                                                                                   ،   p               U                                                                                                                   @              W                   8               P\      p                                                                                                                                               T   x   T   @T                  T   S                                                              
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              D%                                                                                      R                   Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
           Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                  Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       (m   @                       8m                         ,.      @                   $                          L.   p   0                   t%                         a   p                       Hm                          Xm                          hm      @                   xm                          m      0                                                                                          `u                   `                                                                                                                    @                                                                                                                                                                                                                       XK   Ps
                  Transform parameters from defined support to unconstrained space                Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

               P   h#                           -                           2   ~                         %   (                      آ   %   &                      8   0   &                         (/                        H   #                        ȧ                           ئ   .   <                            #                                                                               4&                           8'                           H&                           #                        p                            @   2   $                      (   $                        Щ                                                      p   P/                         H   h.   
                         '   	                     `      %                      ب   `0   (                      P   !   A                         '                           l                        0   %                           \!                           .                        0   "                        ȫ   @0                         Х   H1                           X2                        h    3                            2                            $                           &                           #   	                        8/                           !   
                        H                            8.                           @   
                        4#                           (                           0                        h   P2                        `   ,#                        `    !                                                        D                            3                           &                        h   0%   	                        T$                        X   &                        Ц                           x                              $                        x   81   
                     Ф   1                           (                           '                           #   
                                                 P                           ة   !   L                                                  `   p                           @#   
                      P   d                           $   	                      0   @2                        ؤ                               (1                           h&                        h   $                                                      -   +                      @   .   
                                                                             X   $                        Ȩ   #                                                         
                        $                        Ш                           Ȧ   "                            0                        `   0   
                        &                            h1   
                         %                           .                        أ                              00   
                        $                              
                     У   x.   
                     `                           P   $   
                     ȟ   x#   	                        0$                           1   	                     Ȥ   3   
                     P   $                        H      
                        $                        П   `                        p   '   .                         l$                        (   0                           H"                        h   X'   
                     @   -                           "   	                        !                               
                     h   x!                           &                                                    Ч   1                        0   $#                        x   X    	                        "                        X   8   
                        P   
                     (   "                        (   t$                        0                              %                        H   |                        ا                              ,&                           #                             P%   "                      `   0                                                          x                         \                        (    1   '                          1   "                                                  (   0   
                     x   #                           X&                           #                           x                         `   $                           %                               	                                                   %                        `   L$                        h   L#                        X   h!                           x&                            0                            #   
                        1                           "                           0/                           &                        H                                                         '   
                                                                                                       إ   0                        p   x1   
                     ȩ   p&                            .   	                     p   #                                                    H   x'                           p                        8   P'                            &                        x   T!                        8   $                        @   X.                        @   H'                           X"                            "   G                        X#                        H   $   	                        X1                           "                           &   
                     X   L                        `   #   	                        -   	                        x   
                     8   /                            '                        0   P   	                        %                        p   0                           /   
                        -   
                        8$                            "   
                     8   #                        x   1   	                         p"   %                         !                                                      D$                            <%                            d                         ȣ   h'                        p   .                           #                        @   l                            &                        Ȣ   8                           "                           0                           `$   	                        L                                                                              ȟ                                    `                                                                           П                 П                         `                                         П           u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                         .?AUPyErr_CheckSignals_Functor@?A0x5c459da2@pystan@@                       .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AU?$located_exception@Vexception@std@@@lang@stan@@                       .?AV?$adapt_unit_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                         .?AV?$dense_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVlogger@callbacks@stan@@                        .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                       .?AV?$unit_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                 .?AVdivide_vv_vari@?A0x5c459da2@math@stan@@                .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AVlength_error@std@@             .?AVdomain_error@std@@                     .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                    .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVcovar_adaptation@mcmc@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .H                 .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                 .?AVbad_exception@std@@            .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                       .?AVanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@                      .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@             .?AVbad_typeid@std@@               .?AVop_dv_vari@math@stan@@                 .?AVps_point@mcmc@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@                     .?AV?$adapt_diag_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AUbad_exception_@exception_detail@boost@@                .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$numpunct@D@std@@                     .?AV?$diag_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVvari@math@stan@@                       .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AVdump@io@stan@@                         .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@                      .?AV?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AV?$adapt_dense_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                     .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AVexp_vari@?A0x5c459da2@math@stan@@                      .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AV?$unit_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVmultiply_vv_vari@?A0x5c459da2@math@stan@@              .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@                     .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVrounding_error@math@boost@@            .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVunderflow_error@std@@                  .?AVsubtract_dv_vari@?A0x5c459da2@math@stan@@              .?AV?$adapt_dense_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                           .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@               .?AVsum_v_vari@math@stan@@                         .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVempty_var_context@io@stan@@                    .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                  .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AVadd_vv_vari@?A0x5c459da2@math@stan@@                   .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AVchained_var_context@io@stan@@                          .?AV?$adapt_diag_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AVfacet@locale@std@@             .?AVdivide_dv_vari@?A0x5c459da2@math@stan@@                .?AVdiag_e_point@mcmc@stan@@                       .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVfixed_param_sampler@mcmc@stan@@                        .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x5c459da2@math@stan@@                  .?AVout_of_range@std@@             .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                   .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVneg_vari@?A0x5c459da2@math@stan@@              .?AVbase_mcmc@mcmc@stan@@                  .?AVdense_e_point@mcmc@stan@@                      .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                 .?AVsum_values@pystan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@                       .?AV?$dense_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                           .?AV?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@                     .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AVprob_grad@model@stan@@                 .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AVexception@std@@                .?AV?$adapt_unit_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$diag_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                .?AVwindowed_adaptation@mcmc@stan@@                .?AVvalue@pystan@@                 .?AVadd_vd_vari@?A0x5c459da2@math@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AV?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                                                                                                                                                                                                                       V  D! `    D!     D!    >  D! @  ^  D!     D!     D!   
  D! 0    D!     D!   F  D! P    D!     D!     D!      D!    V  D! `    D!     D!     D!      D!      D!     D!     D!     D!   &  D! 0  F  D! p    0!   3  8! `    D!   %  L! 0  p  0! p    T!   y  p!     ! p    ("    m$  @" $  $   # $  %  ,#  %  K%  0! P%  t%  0! %  &  <# &  2'   $ @'  '  $ '  4)  $$ @)  )*  h$ 0*  *  $ *  +  $ +  T,  $ `,  -  $ -  D-  8! P-  %.  $ 0.  Y.  0! `.  .  0! .  .  0! .  /  $ /  /  0! /  [0  (% 0  0  0! 0  0  0! 0  1  D! 1  1  H% 1  1  D!  2  2  % 2  2  D! 2  3  % 3  3  D! 3  4  % 4  4  D! 4  5  & 5  5  0! 5  #6  8! 06  p6  0! 6  6  0! 6  6  0!  7  &7  D! 07  g7  0! p7  7  8! 7  8  0!  8  g8  8! p8  8  8! 8  9  @& 9  :  & :  ;  & ;  <  ('  =  =  p' =  1>  ' @>  k>  0! p>  ?  $ ?  ?  0! ?  @@  ' @@  @  ' @  @  L!  A  C  '  C  TC  8! `C  ]D  (( `D  F  p( F  G  ( G  5K  8! K  L  0! L  WL  0! WL  L  ( L  L  )  M  .M  0! 0M  M  ) M  M  P) M  P  X) P  R  l)  R  _T  |) T  U  0! U  2V  ) @V  V  ) V  W  * X  "Y  H* 0Y  Y  * @Z  Z  * [  "\  * \  \  0! \  ?]  (+ ]  ]  0! ]  ]  0! ]  ^  X+ ^  `  + `  `  0! `   a  0!  a  Fb  + Pb  xc  `, c  d  , d  d  0! e  g  , `i  Jj  h- Pj  !l  t- 0l  bm  - pm  bp  - pp  p  h. p  p  t. p  @q  . @q  q  . q  q  . q  q  .  r  xs  . s  t  - t  v  0/ v  w  x/ w  "w  / "w  w  / w  w  / w  w  /  x  @x  0! `x  x  / py  &z  / pz  z  00  {  D  h0 P  |  0!     81 0    P1   ӂ  8!     0!    E  L! P  ˃  1   2  8! @    1     1   Ë  (2 Ћ  T  83 `  #  (4 0  >  4 @    8!     05    T  5 `  w  6     h6   $  x6 $    6     6     0!      0!     $    P  0! P  Ǡ  `7 Ǡ    t7   ɡ  0! С    7    ң  7     0!     `8   d   9 p    9      :   8  : 8  }  : }  
  8: 
    P:   ȫ  `: ȫ    x:     P:     :     :   <  : <  ѭ  : ѭ  c  : c    :   ׮  ; ׮    :   |  $;   ̯  0! ̯    D;   Ͱ  X; Ͱ  9  l; 9  n  |; n    ;     ;     ;   ׳  ; ׳  a  ; p  F  : F  x  < x  ж  < ж  o  8! p    L!   ַ  L!     L!   6  L! @  չ  8<   2  D= @    8!     8!    X  > `  u  ?   7  ? @  L  @ P    tB      xC     HD     `D     D   )  F 0    @F     LF     hF     |F     F   N  0! P  P  F P  *  F 0  a  G p    G   F  G F    G     G   N  0! P  *  G 0  '  H 0    I     J   |  K      L     XL     F     L     L     L     L   "  L "    L     M     M    M   `N  4
 N @
  (O   4O  /
 @O /
 
 TO 
 
 pO   ] O `  0!   XP   P   P  k P p  0Q  C `Q P a Q p   R    S  # S # 3% (T @% 
' @T ' ( T ( K, U P, p/ U p/ 2 U 2 3 (O 3 5 4O 5 r5 PV 5 9 XV 9 N: W P: : HW : N; xW P; ; W ; < W  < F< L! P< < 8! < = 0! = = X = !> 8! 0> > 0! > > 0! > 1? 8! @? q? 0! ? :A X @A A 8! A B 8!  B B 8! B B 0! B ]C 8! `C C 8! C KD $ PD D Y D sE HY E E 0! E $F 8! 0F dF 8! pF S $  S 
T Y T ~X Y X X 0! X #` Z 0` ` `[ ` Oa [ Pa a [ a  b 0!  b b [ b b 0! b 0c 0! 0c pc 0! pc c 0! c ?d (\ @d d 8! d d 8!  e Ve 8! `e e 8! e f 8!  f |f X\ f f \  g \g \ `g g \ g 1h 8! @h h 0! h i ] i / ] 0 ޔ $  . h 0  tn   d ho p L o P  pq   8!  Ǻ $ к D $ P  r   ߼ 8s   0!  ? $ @  s   L!   L!   L!   I L! P  s   (t    t  l u p  v   8v   Xv   v   * w 0 t  x t  x    x   b 8!   0!  
 0x  F 0! P  0x   0!  D 0x P  0!   0x  & 0! 0  0x  J Dx P  0!   $  G x P  0!   8!  Q y Q   y   8y   Ly  D 0! P  \y   ly   y   8!   X  d X p  8!   4 0! @  8!   0!   8!  6 8! P  0!   $  8 y 8 F y P  y   D 0! P  8!   4z   pz   xz   z   R z `  z  F z P  {    ,{  " <{ 0  h{  n { p c { p d 8! p  {   0!  p 8! p  $   T|   h|   x|  " 8! 0 H $ H  |   }  @ 8! p  y  b } b  0}   D}   \y  ` T} ` t h}   8!    8!   8!   $   x}   }  4 0! @  L!   L!  + L! P  8!   L!    $  % 0! 0  }  , 0! 0 a 0! p  8!   0!  i 0! p T  } `  < } @  }   0!   (~   <~   8!   P~  S	 ~ `	 	 L! 	 
 8! 
 
 ~ 
      L!  D 8! P  H  D
 P D
 Z
 d `
  t  F  F          p 8! p  8!    $   P $ P  8!         z 0!  J 0! P  D!   pz   8!   H  R D! `  D!  S 8! `  Ā  f 0! p  D!      D!     L!  ! ! ( ! x" pz " D#  D# :&  :& Q& ؁ `& $'  $' *  * 1*   @* * D! * +  + , @ , - D! - - D! - . 8! . . D! . "/ D! 0/ / 8! / /  #  0 0 ,# 0 0 p 0 \1  `1 2 $ 2 2   3 3 $ 3 6 Ȃ  6 6 8! 6 7 $ 8 =9 $ @9 e:  p: p;  p; <  < =   = a> 8! > A 8  A A x A ?B $ @B C  C C 0! C &D 8! 0D /F ȃ 0F F ܃ F G D! G eG D! L L D! L M D! M M D! M [N  `N O ( O O D!  P P  P Q @ Q R D!  R R { R S D!  S T  T T  T pU { pU sV 8! V W ( W X D! X \  \ aa  pa a Є  b b ,# b b  b c L! c d   d h  h h  h i $ i i 8 i j H  j j H j jk 0! pk ;l   m "m P "m n ` n n t n /o  0o Ro P Ro p  p p  p _q  `q q D! q s І s u  u w  w )x 0! 0x x  x x x x fy  fy wy  y z   { |  | }~ P ~ ~ 8! ~  ؊   {   L!   p  ` @ ` ' p 0  L!       L!   Ќ  $   0  P  j D! p } d      [ 0! ` 
 Ȏ      X h ` 
   l 8! p Ε 8! Е $ 0! 0  8!   0!  F 0! P  0!   0!  F p P  ؐ  Ƙ @ И    F  P  x  ƙ  Й  H  F  P    ƚ  К    F P p ל       f H p            t p  *  0 &  0            Ƞ   $   W $ ` h  p  P  Y  `  D!            ԡ  F  F R  R _  `  $   $   0!  h ( p . X @ l 0!   0!      8!   ~ Т             h         0   | p  r    إ   j  p  8  l `  W  p , Є 0      $   x   Ч  K 8! P r 0!          0   O { P  D!  \ Є `  x   g  p 	   5 L! @  0!   L!  J	 , P	 
    
  
       T H T  X   p     t          h   ,"  ," g"  p" " 0! " #   # $ Ȭ $ (    ) *    * + ` + /  / 94  @4 I8  P8 : 8 : 2;  @; 0D  0D HT  PT xd x d h ȹ  i :j  @j k  k *m   0m n X n q  q u  u v  v x ؼ x y  y { H { m~  p~ *   0 V  `  P  ΢  Т      @ S   S     $  	 4   L  N  P ^ 8 ^  @   X   h   8  "  " #  # [  ` n 8 n         0         5  5 6  6 Y        (   $               0  0  (   @   \   l  L | P  8!   0!  h  p .  0 O 0! P      0!    H   0!   0!  < 0! @  0!   8!   8!   8!   8!  h 8! p  0!  i 8! p  8!    p   M  P <  @ m  p  0!            z 0!   8!        l  p  0!    #  J 0! P           (  >	 8 >	 N	 P P	 	  # 	 
  # 
 
 `      
  P ~ 8!  &
  0
        x  J#  P# $ L! $ 
,  , , p  - J-  P- -  - .  . */  0/ / 8 / e0 ` p0 0  0 V1  `1 1  1 1  1  2   2 3  3 3 H 3 m5 H p5 #6  @6 6 8! 6 ,7 8! 07 7 8! 7 8 8!  8 8  8 dH  pH ~S  S -c   0c >n  @n o H o Yp ` `p p  p &q 0! 0q 
r F r 9s  @s | @ | }   } _~  `~ ~ 8 ~ % @ 0 ؄   j 8 p           Ќ q   3   @  h   x  ݐ  ݐ       >  @    ݘ   ٞ           $  0 T  # `  H  % ` % l l l w    D!   į  Я   @  8!  Ӳ 0!   0!  p  p    u    0!     %  0            7 ` 7  l        X  X c  p     H     + ( +  <   T   l  6  @ N  N    5  5 ]  ] w        @   \   P  P 4  4 O  O          / L! 0 O L! P  H        e  p 
   
 i   p  8  Z  `  @  e X p !  ! 2'  @' +  + 0 P  0 4 t	 4 >: 
 @: >  > D   D $I 
 0I J  J EM X PM eM ` eM M  M M  M cP  pP P ( P P 8 P &Q T 0Q NQ ( NQ Q d Q Q  Q S   T X  X Y 8 Y xj  j m h m 3  @  X  Q  `  0!     с   9 8! @ 2 L @  0!   0!   V 0! `  0!  d  p  0!   P   ކ x   8!      ߇ 8!  ^  `     J 0 P  X  L  P P  P U @ `       '  0 ē 0!  W 8! `    Ǘ ` З d 0!   8!   ț  Л    4 0! @ ϝ  Н ֞      d   d u @   P  :  P   0 ^ 8! `          $ 0! 0    ư  а ±  б P ( P ڳ   l p  ޴ 8!  1  @ =  @  p  *  0    ,  0 %    0 + `  0     d D! p  D!       pz  !   ! ' ! 0  8!   8!   v 8!   8!  6 8! @ t 8!   8!   4 8! @  8!  s !  O H   h!  Y 0! ` D ! P | H"  & " 0  0!   p#   #    $   $   h    $  | 8!   8!   F   L!   ; % ;  $%  1 8% @  $  K H% P  %  1 X& @  d&   |&  7 & 7  &   | & | w & w  &   &  
 T 
 B D! P  D!   '   $'   0!   L!   x'  $- h( 0- / H, / (2 , 02 C5 , P5 W: . `: g? $/ p? wD D0 D I d1 I DJ 2 PJ J 2 J M t3  N ,R 4 0R EU @6 PU Y 7 Y ] 8 ] ^ :  ^ }^ : ^ ^ $ ^ a H; a Hb ; Pb 	e h< e e < e f = f df 0> pf f > f g > g g > g g  ? g h ? h h $? h 
i  ? 
i i 4? i i L? i i L! i ~m \? m )s H@ 0s u  u u @ u w @ w x @ x x @ x y @ y z @ z ~ A ~  HA  Y  B `  B   ` 0! `  L!  j B  ń 8! Є v B   8C   3 xC @  H  3 C @  C    8!   8!   E 0! P        D   8D   \D  C lD P  D   0E  c LE c  pE  ǡ E С { E  &  F 0  d&  	 8F 	 ' LF '  \F   pF   F F F  G  ! (G 0  8G   G   (H   xI   J   L   8M   0!   XN  w lN  { |N   0!   N  G O P K O  < O @ / $ 0 E 4P E l <P l  PP   lP   P  3 P 3 P P P q P q 	 P 	  P   H  M P M  P   0 P 0   Q  ; Q   H   (Q  ; @Q @ & PQ 0 i Q p  D!   Q   R   R   0!  x (R  > PR @ _ 0! `  R   R   8!   ~ R   8!  > S @  8S   H   hS   S   S  @  T @ , `T `  T   J T P  T  L U P  @U  : hU @  U  < U @  U  R U R   V  s H   0!  c V p #  XV 0   V   V    PW  G dW G  xW  
 W 
 _
 W _
 f
 W f
 l
 X l
 r
 X 
 
 4X 
  DX   dX   tX   ) D! )  X   X  F X P  0!   L!  0 0! 0 O L! P z D!   ` X `  Y   8Y  : TY :  hY   Y    Y   Y   Y   Y   Y  T  Y T    Z   R! Z R! ! 0Z ! " DZ " " TZ " l$ dZ p$ $ tZ $ c' Z c'  ( Z  ( ++ Z ++ 1+ Z 1+ R+ Z R+ . Z  . . Z . 3/ [ 3/ 0 [ 0 0 0[ 0 3 @[  3 3 P[ @5 5 D! 5 )7 \[ 07 ]: [ `: =; F @; ; H ; ?  ? #? \ #? ;? \ ;? ? (\ ? ? D\ ? ? T\ ? %B d\ 0B C \ C C 1 C C \ C D ]  D E ] E E H E E P E F X] F `G x] `G G P G H ] H H ]  I 'I P 'I I ] I J ] J J ] J 5K ] 5K 6K ^ @K qK P qK K $^ K L @^ L &N P^ 0N O ^ O O  _ O Q _ Q R 0_ R @S @_ @S S L_ S 0T h_ 0T OT 0! PT T x_ T U _ U U 0! U V 8!  V V _ V Y  Y \  \ <]  ` @] v] @` v] _ T` _ +_ p` 0_ _ `  ` \` ` `` ` `  a Ja ` Pa a a a Lb 0a Pb c Xa c c a c Nd a Pd e a e g @b g g b g h b h j b j 0k 0! 0k Ok L! Pk l b l m c m @n 0!  o o  o r 4c r r P r s xc s et c u <u H <u u c u )v c 0v \v H \v ]w c ]w w c y y c y y c y z d z z ,d z z <d z { Ld { B} \d B} G} d P} o} 0! p} } d  ~ ~ d ~ G e P  Pe   8!   ( H 0 ł e Ђ  e    e   f  ӄ  f ӄ  4f   Ӆ Df   f   f   ˎ g Ў  L!   L!   g   X g `  h  A Ph P 9 h  7 P 7  h   h  ݣ P ݣ  h   i  3 ,i @ F `i P ; i @     j  a j a  0j   Dj    Tj  e j e b j b  j   j  6 j 6  k  
 ,k 
  <k   G P G  Lk   lk   |k   k   k   S ` S  k   k   k   k  s $l s  4l   $l   hl   tl  D l P X H `  l   l @ '  m 0  Hm   m   m   m    n   m n m  0n   \n  n ln p ( n 0 \ H \   o  I o P  k  j ,o j  `o  r
 po r
 1 `o @ w o w  o   o  } o   o   p  X <p `  H  L Lp L y hp  2  @  xp   p   p   p   p  K" p P" $ 0q $ K% pq K% ( q ( ) q ) ) q ) * q * , r , , 0r , - 8r - - Tr - 1.  0 a1 dr d1 1 0!  2 !2 r $2 B3 $ D3 l3 D! l3 3 0! 3 3 0! 3 c4 0! d4 4 0! 4 W5 $ X5 5 0! 5 5 D! 5 6 D! 6 6 D! 6 D6 D! D6 Y6 D! \6 6 { 6 6 D! 6 7 D! 7 M7 0! P7 8 r 8 8 r 8 8 0! 8 9 0! 9 W9 0! X9 o9 D! 9 9 0! 9 9 D! 9 '; r (; ; r ; < $s < < { < 5= $ @= t= 0! t= E> Ls H> > Ts > @ `s @ C@ 0! x@ @ 8! @ @ P) @ @ P) @ B ps B C s C C D! C C D! C BD $ DD D $ @F F s F F s F F s F kG s kG G s G G t G 	J t 	J 1J 4t PJ J Dt J tK Lt K EL Tt PL L `t M N ht N N t  O O t O [P t pP .Q t PQ R t R S t  S S t S T t @T T t T T t T |U t |U U u U U (u  V V 0u  W W <u W .X Lu @X X Xu X @Y du @Y Y xu Y _Z u _Z [ u [ V[ u V[ [ u [ =\ u P\ \ u \ J] u J] ]  v ] ] v  ^ _ $v _ _ ,v _ _ 8v _  a @v a a Pv b d \v d d pv d e xv e 7f v h h v h h v h h v h Ii v Ii hi v hi i v i i v i )j w )j Hj w Hj xj (w xj j @w j 	k Pw 	k (k Xw (k Xk lw Xk |k w k k w k l w l 8l w 8l \l w pl l w l l w l m w m <m x Pm m x m m $x m n 8x n in Px in n Xx n n lx n n x n n x o o x 0o ?o x Po _o x po o x o o x o o x o o x o q x  q Cr x Pr r  y r s y s s (y s  t 8y t t @y t t Hy t Zu Ty Zu u hy u v xy 0v qv y qv w y w Gw y Pw x y Py y y y y y y z y z hz z hz oz z z z 4z @{ | @z } B Pz P d `z p  xz   z  F z F e z p  z    z    z Ј  z   z   z  *  {   ɏ { Џ w {  
  {    ({   4{ В Z L{ Z  X{   l{   |{  ~ { ~ ƕ { ƕ  {  p {   {  ޗ { ޗ  {  t { t  |    | М F 4| P u <|   X| 0 t d|   l|  A x| A V | V c |  ϡ |   |   T |   | |   |   |    |  G } P  $}   <}   A H} P  X} о 1 `} @ 3 h} @  p}  ; } P  }  G } P  }  K } `  }  > } P  }   { }   }   N } `  }   ~  
 ~ @  ~  M (~   4~    @~  - L~ `  X~   m d~   p~  } x~   ~ `  ~   ~   ~   ~   ~   ~   ~ 0 v ~  
 ~ @        t        f ,   4 0 a @ p  H   P @  X   `   1 h @  p   x  y   >  P             >  P    O  `        	   	 	 4  	 		  		 }	  	 T	 p `	 	 Ѓ 	 ~	  	 	 $  	 ^	 , p	 	 D 	 '	 X 0	 g	 ` p	 	 h 	 	 t 0	 g	  p	 	  	 	  	 %	  p	 	  	 	  	 %	  0	 e	 Ą 	 	 Є 	 '	 ؄ 0	 e	  p	 	  	 ' 	  0 	 g 	   p 	  	   	  	  0!	 g!	   p!	 !	 ( !	 !	 0 !	 %"	 < p"	 "	 H "	 "	 P "	 %#	 X 0#	 e#	 d #	 #	 p #	 '$	 x 0$	 e$	  p$	 $	  $	 '%	  0%	 g%	  p%	 $&	  &	 &	  &	 &	   '	 5'	 ą @'	 u'	 Ѕ '	 '	 ܅  (	 7(	  @(	 u(	  (	 (	   )	 +	  +	 ,	   ,	 0	 , 0	 4	  4	 i6	 $ 6	 8	 t 08	 <	 ć @<	 .@	 @ P@	 >D	  `D	 I	 8 I	 R	  R	 [	  \	 \	 @ \	 ]	 H ]	 g	 T  h	 &o	  0o	 o	  p	 m	  	 	  	 Y	   Y	 {	 L {	 ߖ	 ` ߖ	 	 p 	 	  	 	  	 	  	 ?	  ?	 	  	 e	  p	 
	 8  	 9	 L 9	 	 X 	 0	 | 0	 	  	 M	  `	 p	  	 	 Ď 	 %	  0	 	  	 	 ȏ 	 P	  `	 	  	 	  	 	 $ 	  	 D  	 H	 T H	 	 \ 	 	 t 	 	  	 	  	 	  	 +	 А P	 $
  $
 '
  '
 b)
 ( p)
 r+
 @ +
 +
 X +
 P8
 l P8
 n8
  n8
 8
  8
 :
  :
 :
 Б :
 6@
 ܑ 6@
 Q@
  p@
 @
  @
  C
    C
 C
 H @C
 UC
 X UC
 E
 d E
 E
  E
  F
   F
 H
  H
 VI
  VI
 I
 В  J
 XK
  pK
 K
  K
 K
  K
 JL
  PL
 N
 $ N
 Y
 @ Y
 Y
 h Y
 3o
 x @o
 q
  q
 Es
 4 `s
 {
 D {
 
   
 @
  P
 N  ` * , * *  * +  + +   , W,  `, ,  , ,  , - ș `- - ԙ - - ܙ - .   . U.  . >/  `/ /  / 0   0 W0  `0 0   0 0 ( 0 1 4 `1 1 @ 1 1 H 1 2 P 2 '3 \ 03 g3 d p3 3 l 3 3 x 04 4  4 D5  P5 5  5 5  5 '6  06 6  @7 w7  7 7 Ě 7 t8 ̚ 8 9 ؚ 9 :  0: :  : &;  0; ;   ; =  = 	>  	> @ ( @ @ P @ @ ` @ .C l .C GC  PC C  C _F  _F F ě F kG ؛ G H  H I  0I _I  pI I   J /J $ @J fJ  pJ J  J zK  0L N 0 O P $  P Q \  Q EQ d PQ [ l [ ^  ^ 3^  3^ ^  ^ @_   P_ _ 0 _ $` 8 $` {` L ` a \ pa a h a a p a Cb  Cb b  b b  b :c  :c Gc ԣ `c c  c c D! c Ad H Dd d  d 1e  `e Ph  Ph  k   k k s k k ! k k ! k l ! 0m Vm ! `m m ! m m ! n n ! r r ! s s P8 s zt 9 t :u 9 xu sv 0= w w ! 1x y @ y y ! Az { `B | | hC | v} 8D  Ƅ ! Њ   h x  Pn c  Pn r  Pn g  Pn   `n   F ! P  t   ! p  ! ؓ  !   !  ( ! 0   y    z  g @| p ǖ |   ! 0 ^ !          Ѕ        0  H  h  Κ ! x  0   !  Μ !   ; Ȑ @ [ 0 ` {        h  ۝ В   8       ;  @ [ p ` { ؔ   @    , L !    Ƞ  ؚ  $  H d `      !  5 ! M o ! o  !  
 !  > ! Ф   !    !       !  ݥ !   ! P z !  ʦ   Ц    > ! h  !   ! V  !  & ! b  !   ! ̩  ! 2 R ! R  !  ʪ ! L u !     ڳ          D ( P l ! l     !   ! L c  ü   ' O  < S P   P  ? P    p     !   !   * !   ! 5 x p   ! U    " p   !   !   ) ! Y  !      !           5 !   x  d     ! d  H   p 4 O       `	 d  x
    4 O    
     \    D X  : H   !   !  6 !   !   !   * !  
 !   8,   -    / 0  00 ` H P1  x p2  . 2 0  `3   !  0 : 0 L ! L p 8; p  ;   !   X<  * < 0 L ! L p = p  !    >   !   >   B   B p  G   H   : N @ z xO   !    P  : ! P z !   !   !   r   !   !  % : < e    ؀     % , U ~  ~      h  5 ȃ 5 [     A     |   P  T X x     Ȗ   ؖ  <  < Y  Y         6 _    (  % 8 % ^ H ^  X    h   O  x O          c  c     Ȟ  + ؞ 7 ]      c D! p  D!   D!  C D! P  D!   D!  
	 D! 	 ]	 D! `	 	 D! 	 
 D! 
 ]
 D! `
 
 D! |  D!                                                                                                                                                                                                                                                                                                                                                 1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `p                    <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                    pxȪЪت  (08@HPX`hpxȬЬج  (08@HPX`hp           d    ȪЪت  (X`hpxȫЫث  (08@HPX`hpxȬЬج (08@HPX`hpxȭЭح  (08@HPX`hpxȮЮخ  (08@HPX`hpxȯЯد  
 \    (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء  (08@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPX`hpxȤФؤ  (08@HPX08@HxȦЦئ  (08@HPX`hpxȧЧا  (08@HPX`hpxȨШب  (08@HPX`hpxȩЩة 8@HPX`hpxȪЪت  (08@HPX`hpxȫЫث  (08@HPX`hpxȭЭح  (08@HPȮЮخ  (08@HPX`hpx 
 <    (08@HPX`hpxȠРؠ  (08@HPX`hxȡСءȢТآ8@PX`hp  (0@HPX`hpxȤФؤ  (08@HPX`hpxȥХإ  (08    
 D     (08@HPX`hpxȯЯد 0
 4   ȠРؠ  (08@HPX 
    ȥ     4  Xpx@hhȦ  (8@H`hxȧا  (8@HX`hxȨ  (@H`hȩ  (@Hت08@hx`hج (08PX`xȭЭح  (p08pxȯЯد   T   (@xȠРHСX`آ0xЪXثH` ( (08@  4    (08PX`xȯЯد     x    (@HPhpxȠ(@ȡСH08X`Фؤ  (HPpxȥ8@`hئ (0PXxȧЧ @Hhp08X`Щة  (HPpxȪ8@`hث (0PXxȬЬ @Hhp08X`Юخ  (HPpxȯ   0   8@`hؠ (0PXxȡС @Hhp08X`Уأ  (HPpxȤ8@`hإ (0PXxȦЦ @Hhp08X`Шب  (HPpxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد @    (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp 08PX`pxЧ08PpP` PЭ  Hp   P 4   `8pP ` `ث 0  ` T   h P8`УHx8p PئP 0p0pЭ   p <   ` ` ` (`PpȪ P`P  T   0С @У0XХ0pȧxH 8hЫ0ح`    ,    @0XȦ0                                                                                                                                                                                                                                                                                                                                                                                                                                                  ub.