@     pystan.model	StanModel)}(
model_cppname+anon_model_1988b9d517e3c16daf27a07f09e3de97
model_name+anon_model_1988b9d517e3c16daf27a07f09e3de97
model_codeX  data {
  int T;                                // Sample size
  int<lower=1> K;                       // Number of seasonal vectors
  real t[T];                            // Day
  real y[T];                            // Time-series
  int S;                                // Number of changepoints
  real A[T, S];                   // Split indicators
  real t_change[S];                 // Index of changepoints
  real X[T,K];                // season vectors
  vector[K] sigmas;              // scale on seasonality prior
  real<lower=0> tau;                  // scale on changepoints prior
}

parameters {
  real k;                            // Base growth rate
  real m;                            // offset
  real delta[S];                       // Rate adjustments
  real<lower=0> sigma_obs;               // Observation noise (incl. seasonal variation)
  real beta[K];                    // seasonal vector
}

transformed parameters {
  real gamma[S];                  // adjusted offsets, for piecewise continuity

  for (i in 1:S) {
    gamma[i] = -t_change[i] * delta[i];
  }
}

model {
  real Y[T];

  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  for (i in 1:T) {
    Y[i] = (dot_product(A[i], delta) + k) * t[i] + (dot_product(A[i], gamma) + m) + dot_product(X[i], beta);
  }
  y ~ normal(Y, sigma_obs);
}

model_cppcodeXg  // Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unkown file name");
    reader.add_event(45, 45, "end", "unkown file name");
    return reader;
}

class anon_model_1988b9d517e3c16daf27a07f09e3de97 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> y;
    int S;
    vector<vector<double> > A;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
public:
    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 4;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 7;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            context__.validate_dims("data initialization", "A", "double", context__.to_vec(T,S));
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            vals_r__ = context__.vals_r("A");
            pos__ = 0;
            size_t A_limit_1__ = S;
            for (size_t i_1__ = 0; i_1__ < A_limit_1__; ++i_1__) {
                size_t A_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < A_limit_0__; ++i_0__) {
                    A[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            current_statement_begin__ = 7;
            current_statement_begin__ = 8;
            current_statement_begin__ = 9;
            current_statement_begin__ = 10;
            current_statement_begin__ = 11;
            check_greater_or_equal(function__,"tau",tau,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 15;
            ++num_params_r__;
            current_statement_begin__ = 16;
            ++num_params_r__;
            current_statement_begin__ = 17;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 18;
            ++num_params_r__;
            current_statement_begin__ = 19;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_1988b9d517e3c16daf27a07f09e3de97() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            T__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<T__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            T__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<T__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 23;
            validate_non_negative_index("gamma", "S", S);
            vector<T__> gamma(S);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma,DUMMY_VAR__);


            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < S; ++i0__) {
                if (stan::math::is_uninitialized(gamma[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 23;

            // model body
            {
            current_statement_begin__ = 31;
            validate_non_negative_index("Y", "T", T);
            vector<T__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);


            current_statement_begin__ = 34;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 35;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 36;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 37;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
            current_statement_begin__ = 38;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 41;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((((dot_product(get_base1(A,i,"A",1),delta) + k) * get_base1(t,i,"t",1)) + (dot_product(get_base1(A,i,"A",1),gamma) + m)) + dot_product(get_base1(X,i,"X",1),beta)));
            }
            current_statement_begin__ = 44;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("gamma");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 23;
            validate_non_negative_index("gamma", "S", S);
            vector<double> gamma(S, 0.0);
            stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma,DUMMY_VAR__);


            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }

            // validate transformed parameters
            current_statement_begin__ = 23;

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_1988b9d517e3c16daf27a07f09e3de97";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97 stan_model;

module_nameGstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392module_filenameZstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.cp36-win_amd64.pydmodule_bytesB  MZ                @                                      	!L!This program cannot be run in DOS mode.

$       EG^S&0 &0 &0 ^ &0 l{1&0 :x3&0 :x4
&0 :x1&0 :x5&0 x1&0 &1 l'0 x9 &0 x0 &0 x  &0 x2 &0 Rich&0                 PE  d	 <jY         "     $     X                               P         `                                       |     0      hj           @ ,  
                    H
 (   
              p
                          .text                           `.rdata                     @  @.data                        @  .pdata  hj     l   H             @  @.gfids  <                       @  @.tls    	                      @  _RDATA                         @  @.rsrc       0                  @  @.reloc  ,   @                  @  B                                                                                                                                        H(H
` P A   H`    HD H`     H
` `  J H
 H(b H(H
_  A   H_    H H_     H
_ _   H
 H( H(H
5_  A   H7_    H H_     H
_ ^   H
 H( H(D
 3 g_ H(H(T
 }3 O^ H(
 ^8^ ^ H(
 %3 W^ H(H(Ą
 3 ] H(] W!
 ^ H(<
 2 2 W
 _ H(] Xx] 0^ H(H
^   A   H^    H H^     H
v^ o^   H
C H(2  H(H
]  A   H]    H H]     H
] ]   H
 H( H(H
\ ` A   H\    H H\     H
\ \  Z H
 H(r H(H
]w   WHZw     H
 ;w H(2 H(H
z  WHz     H
k cz H( H( WHz     H
 z H( H(2  H
 H( H(H
v 0 WHv     H
+ v H(b H(H
v  WHv     H
 {v H(" H(H
x  WHx     H
 x H( H( H
 H( H( H
 H( H(7  '
  T
 f/ۂ
 v  "     8
 k Tt
 f/
 v  "   H(H([ H(H(7 H(鋑  k H(Q H((
 c 
 # H(
  H(H(
 ? H(H
= d   @SH HHHSH
A H3H
HJHH HH [H HHH% HQH HHEH\$WH H HHH t
   H HH\$0H _3HAH HAH HHH(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH( @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ H7 HHH0[@SH HHHSH
 H3H
HJHH H HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0I HT$0   HC   HsH{rHH  H @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" H HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H| HHL$pH3 L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtH Hy) uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIH
) uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v Hb HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v H @H$   H3c L$   I[0Ik8IA^_^́aHI    ́aHI   Hq HH\$Hl$Ht$WAVAWH HrE3HLH(IDIHK HGAH+HHt6@ Ht
,HqK HHH HGHH+HH;rM)IDHH\$@Hl$HHt$PH A_A^_%K @USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtH %   H  HIHP   Hp   HIHPH
 H HEH  ,H HHZ H HIBL HH( H HI(L HH G HHL Hp  Hp   HHxrHH_ HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ Hia HL$ u HIHP   Hp   H H  :G HHh +G HIPK HH6 G HI6K HH F HHK Hp  Hp   HHxrHHm HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ Hw` HL$  HMHT$HHPHT$PLL$HI+HLHFI+HH;  HL$p H HM'F HHU F HI=J HH# E HI#J HHy E (HMG 3ۋHFH+HHt9D  Ht,HMG HHHM HHFH+HH;r̲)HMG Hb HMqE (HMG HD$PHL$HH+HHt<Ht,HM`G HL$HHHMm HHD$PHL$HH+HH;rĲ)HM)G Hp  HL$p HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8	 H HD$ H^ HL$  3ۋH  IM+     HI9uHHH;r{  HMp H] H   ID HHw :D HI_H HHE  D HIEH HH D HH: HH C LHUp/H H   C (H   E HD$PHL$HH+HHtBHt,H   E HL$HHH    HHD$PHL$HH+HH;r)H   xE Hp  HMp( HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8Y H2 HD$ H\ HL$  MtLD$XM+II H  H3 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H HHHH\$@H0_H\$Ht$WH0HD$        IHV HHHH\$@HpHHt$HH0_@SH H HHt
    HH [@SH H   H HH [H% HL$UVWAVAWH0HD$ H\$pILHH HHqHt$hE3L>L~A HH_H\$hL;L{@ HL(L0L8L@LHLPLXL`LhI;t8HHRH> HH@HH HH@L~DD$`IH˱ H;t9HHRH'< HH@HH HH@L{DD$`HHް HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP H yI^I;^u3HINͯ HI;FtHP H yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H~ yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP H tHHH;t-IM轮 HH;tHP H yHHS@   IM萮 HI}H;tHP H tHH;   HIMY HH;tHP Hu tHHS@HL$Hͬ H|$PH\$HH+HHHL$0 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH| IU(I~ IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP Hc yHHH;t*IO HH;tHP H7 yHHSX?IO IHH;tHP H	 yHH;tHIO IWXH H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP Ht yI_I;_t/HIO* HI;GtHP HE yI_HS@IW@H蛪 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI虫 HI;GtHP H yI_I;_t/HIOj HI;GtHP H yI_HSXIWXH H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3q HGHH;tiD  HS HT { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3 HGHH;tiD  HS H褷 { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   H HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+I H_@H_HH_PHW(HtLG8L+In H_(H_0H_8LGHT$0MHOM j HO LGHT$0MHOM 9 HO H\$8H HH _@SH LHT$0MHM  HH [w @SH LHT$0MHM  HH [G Hq H@SH H[ HHt
    HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH Hs HHt
    HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH HC HHt
   6 HH [@SH H HHt
    HH [H(HIc: HHy< H(H%v @SHPHD$ H H3HD$HHHHT$(H HHK: HH<  HD$@HrQHHL$(H=   r<ts HAH;rc H+HsS H'vF H HL$HH3 HP[H(HIs9 HH; H(H% @SHPHD$ H H3HD$HHHHT$(H HHK9 HH(; * HD$@HrQHHL$(H=   r<t HAH;rs H+Hsc H'vV H% HL$HH3 HP[H(HI8 HH: H(H% @SHPHD$ H H3HD$HHHHT$(H HHK"8 HH8: : HD$@HrQHHL$(H=   r<t HAH;r H+Hss H'vf H5 HL$HH3 HP[H(HI 7 HH9 H(H% @SHPHD$ H H3HD$HHHHT$(H HHK 27 HHH9 J HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vv HE HL$HH3 HP[H(HI(6 HH8 H(H% @SHPHD$ H" H3HD$HHHHT$(H HHK(B6 HHX8 Z HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v HU HL$HH3 HP[@SH Hӫ HHt
0   & HH [H HH H\$WH H HHHݽ t
(   H HH\$0H _@SH HHHSH
 H3H
HJHH H HHH [H H@SH H HHt
   6 HH [@SH Hñ HHHt HM HH [6 K7 H(HQHI?4 HHU6 H(H%R @SH HHQHI
4 HH3 HH6 H [H% H\$WH H HHH论 H Ht
0   H* HH\$0H _23HHBHBH@SH HHRH{g HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+Ib HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+IR HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWHe HL$8Ht HT$@b LD$HHT$8L+IZ H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWHź HL$8Ht HT$@pa LD$HHT$8L+I H\$`HP_@SH H HHt
   v HH [H\$Ht$WH H* HH3HIPH*Ht:HSXd HK`HH+KPHHLI?LHSP! H{PH{XH{`HS8HtLCHL+I< H{8H{@H{HHK Ht:HS(c HK0HH+K HHLI?LHS  H{ H{(H{0HKHt)HS+` HSLCL+Iw H{H{H{Ht$8HW HH\$0H _@SH HYLHIH[ H;H [Hl$Ht$AVH0HHHQE3HIDt$ e[ H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHHd Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ Z H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQHq @SH0HD$     HQ8H裫 HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI軜 D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0Y I?HHD$0H;t?HHtLGL+I L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H- HHHIVI+H*HHHH?HH;s(     IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   H HH\$0H _@SH  HD$HH| H3H$p  ~ HH      HL$P H HL$`e# HH HH)  H$P  HL$P HxrH H
͸ HL$ 3HL$(HL$0HD$8D$@HT$(HL$8J H# HD$ H< HL$  H$p  H3 HĀ  [HL$WH@LG HH
F IL
F LL+F ILF M;s$K9<sIHH+F HLF L;rH\$XHt$hM;~  HF HpHH;HBHHt$`hHiF HHD$PHD$PH;sNH
HF HD$PH;w=H\$PH+HH;;F uH
"F ] HF Ht;H
F HH
$H;
F uH
E , HE Ht
HHE HHE Hz    H
E HD$`L
E H;sLHD$`L;wBH\$`I+HH;
E u   H
E X H
E L
E HtGIH0H;
}E u   H
_E " H
[E L
LE HtH1H
EE L
6E LGE HH
,E HE Ht$hH\$XJH8H
,E KHHE H@_3H7 HD$0HL$ HV HD$(H2 HD$ n HT$HL$WH@HD$ H\$hHD$X   H=sD H|$`   dHD$PWfTD 3H[D LD$P HQD WfND LD$XH
:D  HED HD H
HL$XH
7D HH5D H6D Wf3D f;D HDD HED fED H9u13HD$8HJ HD$0H& HD$(H6 HL$(V HH\$hH@_H\$WH HwC 3H
fC HH+HHt7D  HHtH H?C H
0C HHH+HH;rHC HH   HC H+HH;v H    H=   r<tg HBH;rW H+HsG H'v: HH H
B WfC H=B HB H   HB H+HH;v H    H=   r<tЫ HBH;r H+Hs H'v HHo H
A WfMB H=VB H'B H   H'B H+HH;vU H    H=   r<t9 HBH;r) H+Hs H'v HH H
aA WfA H=A H`A H   H`A H+HH;v H    H=   r<t HBH;r H+Hs H'vu HHA H
@ Wf@ H=@ Ht}H@ H+HH;v2 H    H=   r<t HAH;r H+Hs H'v H WH=N@ f6@ H\$0H _Li@ L9Z@ u0H	@ H.@     HH@ H-@ H HH@ I@IHH
!@ H
2@ HH? HH
@ H
.@ HH? HH? H
@ @SH HHHSH
 H3H
HJHHs Hܰ HHH [@SH H IHHHA    HD$0H> HL$0H;sdHk> HL$0H;wSH|$8H|$0H+HH;Y> u   H
;>  H7> H(> HtHHH> H|$80H;> u   H
= L H= Ht
HH= HHH= H [H1 H@SH H HHـu
   ;HH [@SH@HD$ )t$0(HHO> HHHA> H;2> r
   HHL$PHt
(3HH(t$0H@[HH3H0 HD$0HL$ H: HD$(H HD$ R H\$ WH Hr H3HD$3LA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HA,P  AO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3觻 H\$HH _kN  wN  N  N  N  N  N  AO  N  N  N  N  N  N  O  O  O  O  !O  *O  JO  SO  \O  eO  nO  uO   	
	
	
 	


	

@SH@eH%X   H)t$0(1
    )|$ (=K
 Hȋ
98    f]5L
 f_5|Q
 fYfX=`J
 ffT=J
 f\(|$ ((fY
G
 fY]J
 f\ff\fy8 (frfYfpc((fY%G
 fY
G
 fX%H
 fX
BH
 fYfYfX%2J
 fX
I
 fY(t$0fYfX
K
 f\f^fY%J
 fX%I
 fYf_H@[H
7 o =7 foF
 H
7 f7  @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH H( HHـu
(   KHH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH5 HH(H5 H;5 r
(   HHt$@Ht*H?HOXKHH^H~ H] HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^H5 HH(H5 H;5 r
(   HH|$`Ht&H(XKHNH_w H HH>HH\$PHt$X(t$0H@_HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH      HB@WH@HD$ H\$PHt$X)t$0(HHf.>
 z
uHH^H3 HH(H3 H;3 r
(   HH|$`Ht&H(YKH-H_w H͸ HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(Hf.
=
 z
uI H^H>3 HH(H03 H;!3 r
(   HH|$XHt&H(YKHmH_w H
 HH>HH\$PHt$`(t$0H@_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH H HHـu
0   HH [@SH HHHSH
a H3H
HJHH H̍ HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3; H{| HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$H HHoHH$   Hp_^]H	H% @USVWAVAWH$xH  HD$PHPe H3HEpMADHH   D$     H HD$`HM` D$    E3E3HT$hHL$`) HD$`HcHHh HD`HD$`HcHDxDD\   HL$hg HHL$` HH׷  HH  Hȋ HH  HHg  HȺ   Ė HHB e HA HI~ HHs HUPHL$`U HxrH H
ˠ HL$(3HL$0HL$8HD$@D$HHT$0HL$@H H HD$(H HL$( @SH H   H HH [H% @SH HHHSH
1 H3H
HJHHÖ H< HHH [@SVWH  HD$8H-c H3H$  IHHDL$0HL$@蒣 HZ HL$P
 HH5 H$  HL$@ӡ H$  H$  HC$  HǄ$X     3H$P  $@  8uD
IIB8uH$@   HǄ$x     H$p  Ƅ$`   A"   Hε H$`   H$@  HD$ L$`  LD$0HH @UVWH  HD$0H$  Ha H3H$  AAHH$  A|A@;   HL$@E HU HL$P Hȋ$   H$`  HL$@聠 H$`  H$x  HC$`  HǄ$X     E3L$P  D$@  D8tIIB< uH$@   Hl$ L$@  DËHH$  H3[ H$  HĐ  _^]@SVWH  HD$HH` H3H$p  AHHHL$P7 H HL$` HH  HH HHI  HH HH r Hȋ H$P  HL$P5 H$P  H$h  HC$P  H
ۜ HL$ 3HL$(HL$0HD$8D$@HT$(HL$8X Hɉ HD$ H HL$  @SH HHHSH
q H3H
HJHH Ht HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu(@UVWHl$H   HEH$   H^ H3HE?HHHE7   3Hu/@uDFH HM HE   Hu@uDFH HM HE   Hu@uDFH} HM H|$ LMLHUHM HEHrPHHMH=   r<t HAH;rՒ H+HsŒ H'v H臰 HE   HuE HEHrPHHMH=   r<t{ HAH;rk H+Hs[ H'vN H HE   HuE HE7HrPHHMH=   r<t HAH;r H+Hs H'v H賯 HLCL+IHMHM?H3! H$   HĠ   _^]( (
 D$T$f (fYfYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX(f^((Հ (
ހ D$T$f (fYfYfYfXƀ fX
΀ fYfYfX΀ fX
ր fYfYfXր fX
ހ fYfYfXހ fX
 fYfYfX fX
 fYfYfX fX(f^(H8W)t$ f/(vbW;
 
 
w3
 f/D$@   f.z$u" 3
 X "   (t$ H8ǎ X(t$ H8.
 
3
 f/D$@wHf.z ub B3
  "   (t$ H8(t$ H8H%j LD$@Hv 9q LD$@Hd 'q HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3ҍ Hp HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHM諷 IwHu@HH^H^uHtFHHHH;tLLMt3 IBo HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHMض I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMH聵 H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHX,
 LqWMHHEIHEI~Ht3 Hl HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHME L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;tIHHt3 H?k HELuH}LE7HUHM LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHM0E HM> HM3 L$   I[(Is0I{8IA_A^]LWH   H
)
 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tH] Ht
Hi HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0 H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3+ Hkh HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHM I~H}@HH_uHt3 Hg HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHMx I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM跮 HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHME H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHX%
 LqWMHHEIHEI~Ht3p He HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHMS> LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM? HM L$   I[(Is0I{8IA_A^]LWH   H
v#
 f/   HA\I[3IsHq ICD$hH9rt"H
5 Ht
Hpc HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0 H$   HĀ   _@SH HHHSH
 H3H
HJHH H\ HHH [AYAHAX@@@SH Hg HHـu
    ;HH [@WH0HD$ H\$HHt$PHHHJ HH H< H;- r
    HH|$@Ht&HC
 (HtH_Hj HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HHq HHGH+HH    H
 HHH H; rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDH( HH(H H; r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHMW HMHM H_ HELELEHM HMLHUNL+t	HG
 HM_ LHEHMHMHULL+t	H
 WD$PH}LHt3| H^ HHD$PH}HL$PLt$X3L;t-Z| HtH^ HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$` =
    HEH   L   LD$PHH   p H9V~EH<(
 $(
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3{ HtHK] HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$`贤 HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HU% HD$@HD$`H|$HHFH;t'H;tHy Ht
H+\ HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM9 HL$@ey HL$PYy IOy HMDy HM9y HM/y HM%y L$`  I[0A(sA({IA_A^_^]@SH HHI(x HKx HH [H%x H\$Ht$WH@HY)t$0Hqv H\$PHHHJ()|$ H(Z HLGLCHLGIL+LtH
 H\$XH~(|$ v Ht$`(t$0H@_Hu HHIH%#x @WHPHD$ H\$hHt$pHC H3HD$HHHD$@   3Ht$8@t$(DFHq HL$(; HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVH& HH;HKHtdHA   HqHyrHHH<H;Cu
   H HKHt(HA   HqHyrHHHT$(  b HC HD$@HrQHHL$(H=   r<tw HAH;rw H+Hsw H'vw Hq HD$@   Ht$8D$( A
   HI HL$( HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H HH;HKHtdHA   HqHyrHHH<H;Cu
   H譤 HKHt(HA   HqHyrHHHT$(  , HC HL$(s HL$HH3 H\$hHt$pHP_H\$WH Hos HHHIu t
(   HC HH\$0H _Hg H@SH Hg HHt
    HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHHr H\$0HHHJW HLFLCHVLFIL+LtH
 HFH\$8HGHF Ht$@HG HH _HYn HH齔 H\$WH H/n HHH莔 t
(   H HH\$0H _@SHPHD$ H? H3HD$HHHD$@   HD$8    D$( A   H HL$(1 HHHT$(PHD$@HrQHHL$(H=   r<tct HAH;rSt H+HsCt H'v6t H HL$HH3舊 HP[HWH@H@HXHhHpIHHW@3HpVHHQ LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
b ,p IPL+IIHL+IM;HCH;HCHL$( LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
Ҥ o IPL+IIHL+IM;HCH;HCHL$( LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+Ig H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xH< H3Hp  I((Hǅh     Hǅ`      ƅP   A   H HP  9 HHPH0  #} HP  H@   H(n HHi  H0  H0  Q{ LHHAPHH  HrSHH0  H=   r<tq HAH;r q H+Hsp H'vp H貎 HM0i| HǅH     Hǅ@      ƅ0   A H`  H0  5 H0  HM@ H(m HH  HH  HrSHH0  H=   r<tFp HAH;r6p H+Hs&p H'vp H H0  HM0z LHHAPHH  HrSHH0  H=   r<to HAH;ro H+Hso H'vo Hi HL$0{ HǅH     Hǅ@      ƅ0   A H`  H0   XH0  HL$@ H(l HH_ J HH  HrSHH0  H=   r<tn HAH;rn H+Hsn H'vn H虌 H0  HL$0x LHHAPHH  HrSHH0  H=   r<twn HAH;rgn H+HsWn H'vJn H HHPHMfx HM<l H   Ox H   "l H  5x H  l Hh  HrSHHP  H=   r<tm HAH;rm H+Hsm H'vm Hg Hp  H3 L$  I[A(sA({I]HUSWHHH  HD$ )p)xH<8 H3Hp  ((HHǅh     3H`  @P  DGH HP   HǅH     H@  @0  E3H H0  O HKHH0  P HH  HrSHH0  H=   r<tzl HAH;rjl H+HsZl H'vMl H H0  w HP  H@  | H(xi HH 1 HKHH0  PHM0w HǅH     H@  ƅ0   A H`  H0  W H0  HM@ H(i HH  HH  HrSHH0  H=   r<thk HAH;rXk H+HsHk H'v;k H
 HKHHU0PHL$0v HǅH     H@  ƅ0   A H`  H0  肢 XH0  HL$@, H((h HH  HH  HrSHH0  H=   r<tj HAH;r~j H+Hsnj H'vaj H0 HKHHT$0PHǅH     H@  ƅ0   E3HT H0  貢 HKHH0  P HH  HrTHH0  H=   r<ti HAH;ri H+Hsi H'vi H HMs HMg H   s H   g H  s H  wg Hh  HrSHHP  H=   r<t4i HAH;r$i H+Hsi H'vi Hֆ Hp  H3W ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHHTS HHqHt$`3H.HnHcڅt3g HI HH^HwHt$`H.HnHt3tg HI HH^Ho(Hw0Ht$`H.HnHt3Dg HI HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHHwR HHrHyH|$hE3L'LgHt3f H I HHwLu HsHt$hL&LfMt3f IH HLvHE(HC(L}8Ls0Lt$hM&MfMt3Xf IH IM~HUH HUH HU0I HH\$pHl$xH0A_A^A\_^H\$WH HHHHc HC(HSHOHG(N HS0HO0A H\$0HH _@UVWATAUAVAWHpHD$ H$   H1 H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHnU HcH;U|H
 b EL9e#  IIf     HD$@   Ld$8D$( A   H HL$(V IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH HwHtoHF   LfH~rHH  H{sLCItHHb 	HHL#HCHFHCHFHC   H{LcrH HG HL$Hia HL$(^a AIcH;]}/H
 ` H
 ` H
ʕ |` AH9u   I HD$@   Ld$8D$( A   H HL$(6 IIFH+HH;vJHLHT$(HL$H HHV HL$H` HL$(` HcH;]zH
! _ HL$hH3y H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHH[ HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC臷 HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;IC	 HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;ICG HSHt
HHH
HB   H
 ~] H
 p] LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC誵 HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
 \ H
 \ HL$VWATAVAWH0HD$ H\$hHl$xHcLH[ II~@H|$pE3L'LgLgIHtIHHH;tHHHt3Z^ H@ HH_H_LHMI;~NL    
1 
 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHI] Mt
I? HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@i H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx HD( H3HE`LHE3ADt$ HEX   LuP@}@EF HY} HM@萕 IE HU@IPHEXHrPHHM@H=   r<t\ HAH;r\ H+Hs\ H'v\ Hfz Aމ\$$H9^H  ML={O HTX H
U[ HL$@HT$PHMZ |$ E3HT$XHL$@nZ HD$@HcHHS HD@HD$@HcHhT<HD$XHD$0HL$XW L|$XLuDuHF@BHL$P5Y A   EL9vP~S@ ff     H~@H^HIIH| HL$P HX AIIcH;FP|Ë\$$|$ HU@HL$@me ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   Hx HD$@HcHHR HD@HD$@HcHhT<L=M L|$XHL$X` HL$XX HL$`
X HMX É\$$IHcH;FH}$E3Z Z zZ sZ HM`H3p L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0EY HK;Y HKH [H%+Y @SH HH   W H   HLcBADuluHT$0lW H [VW H   HLcBADuLt2H [H\$WH HH   HT$0 L   I HcHBDuT$0@:tIV 2H\$8H _ðH\$8H _@SH HHT$0H   v L   I HcPBDt2H [L$0uY tT$0HK H|$8vU H   HT$0\V HHcQDu@fD  L$0-Y u8L$0Y u)T$0_t$.tH   U H|$8H [T$0HK T H   HT$0U HHcQDtH|$8H [@SH HHT$0H   f H   HHcPD
uT$0"tFiU H   HT$00 H   HHcPD
uT$0't23U HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33kW l$H\W ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @3T Hv_H~HHfff     I   T HHu2Hv&H~HHfI   S HHu2j@SH   HD$@H! H3H$   HHL$0HA    HyrHH  H   HT$ pS HHcQDuAL$ /V uL$ 0V T$ tH?R H   H   S HqH H$   H3k HĠ   [@SH HyHHA    rHH  HT$0H   R HHcQDufL$0rU uL$0sU T$0t6HQ H   HT$0hR HHcQDtH*   H [H   /R H   H [H   HD$0H H3H$   HL$  H$   H3j HĘ   @SH   HD$0)$   H' H3H$   HHL$  (Wf.zu	Ha (H$   H3=j ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5{u DH@ H   HUH HHcJD   UH:7   HD847uAH2u HEt
5! 5W HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKX) HS`HtHCXHH
HB  H   GP HvSHHHH   (P HvHu.Hv(HHHD  H   O HvHuE3HHt Htx HKXHUHEHK   @2LsH{rHHD0HU@H   O HHcQDugH
     M@eR U@uB<:w2Hs,@HeN H   HU@LO HHcQDt
H   O @u<HC`H+CXHu,HEtHK@EHHUHE HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKX4 HS`HtHCXHH
HB%H;Chu   HKX HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5f BH;Chu   HKX HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0M HLcBAD u!L$0dP uT$0H   fM H   HT$8- L   I HcHBDuT$8-tDI,M H   HT$8@2 H   HHcPD
uT$8+tL @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(tL 2H0A^H\$HHT$@Ht$XH|$(? I   HHcPD
uT$@)   >L IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@| IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINp"} IVxHt:IFpHH
IFx   I;   u   INp| IFxHtH0IFxkI;FPu	IN@7| IFHHt0IFHHHl$PI   HT$@ I   HHcPD
uT$@)t#J 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INp| IVxHt7IFpHH
IFxI;   u   INp{ IFxHtL8IFxU@UH0HHT$@H    H   HHcPD
uT$@(tI 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   I HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMXz HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMpYz HUxHt:HEpHH
HEx   H;   u   HMp"z HExHtL0HExtH;Ehu   HMXy HE`HtL0HHE`HHt$PH   HT$@ H   HHcPD
uT$@)t"G 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMp@y HUxHt7HEpHH
HExH;   u   HMpy HExHtL8HExV@SH HHT$0H    H   HHcPD
uT$0(tF 2H [HT$0H|$@ H   HHcPD
uT$0)   F Ht$8HH   HT$0s H   HHcHDuT$0,tH   oF Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKpw HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp]w HSxHt@HCpHH|$@H
HCxH [H;   u   HKp w HCxHtH8HCxH|$@H [H;   u   HKpv HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH    H   HHcPD
uU(tD 2H([]Ht$HHi AH|$PHH˄t
   AHd H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@; MM;~fHUHK@: EȉE;}HCpHUHCxH    H   HHcPD
uU,tC Ht$H2H|$PH([]ò.H~tAHh Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8; ,Ht'HrHUHEHKp; ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp: HMHHMH;v)Hh뒐HUHKps: HEHHEH;s)H9`@UH0HHT$@H    H   HHcPD
uT$@ct)	B AHgf HḦ́tH0]HH0]AH'b Ḧ́t
H0]AH'f Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@r HUHHt%HE@
H;EPu	HM@q HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@q HUHHt%HE@
H;EPu	HM@fq HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@7 Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+Ieo H{pH{xH   HSXHtLChL+I=o H{XH{`H{hHS@HtLCPL+Ih^ H{@H{HH{PHK ? HH\$0H _? @SH0H3HQ D$ IE3HHC   HCP{ HH0[@SH0HD$     HQpH8 HH0[@SH0HD$     HQ@H! HH0[@SH0HD$     HQXH8 HH0[@SH   HD$@H H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H    L   I HcHBD   T$ <tI=    -H   Hi   HǄ$      HǄ$       D$pA   Hb HL$p~x HD$pH$   HCD$pH
G HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   > H4 HD$PA;  Ha HL$P 2H$   H3U H   [HUATAUAVAWHl$H  HEHXHpHx H%
 H3HEpHLHMH
) HLiLl$03I} I}ʰ IE M|$L|$0I?I谰 II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIw HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	
 uH;s3H;t.LuLEI& LH HD$ LHT$0I} H\$0HK@HT$8:) HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  HZ HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  HZ HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  HY HT$hHtLD$xL+IAX WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$( HHT$8) HM]8 HT$PHtLD$`L+I1h HT$8HtLD$HL+Ih HT$hHtLD$xL+Ig WD$hH|$xHUHQLEL+Ig <: : ~: w: p: i: b: [: T: M: F: ?: 8: 1: HMIHMpH3P L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+If H{H{ H{(HHtLCL+I$V H;H{H{H\$0H _H\$WH HQ3HHtLA(L+If H{H{ H{(HHtLCL+Idf H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0jD H2[ HL$@ Ht3HwH4[ HL$@Ϊ H;sHY HL$@踪 HH;rH[ HL$@蟪 HH5 HHZ 脪 HT$0HHD$0HcHH/ HD0HD$0HcHhT,H'+ HD$HHL$H{ HL$H6 HL$PR5 H$   6 HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tHHHt3r6 H LHD$(Lt$(H\$0H\$8HH~AL    M
> HIH;u(WHHH;|HMH;|HL$PvB H>Y HL$` Ht3HnAHL$`4 H;sH"W HL$`Ĩ HH;rHY HL$`諨 HH3 HHV 萨 HH3 HHX u HT$PIHD$PHcHH- HDPHD$PHcHhTLH) HD$hHL$hy HL$h4 HL$pC3 H$   3 I4 IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   H  H3H$  ILHH$   LL$83ۉ\$0HHYMt3k4 H HH~D$0   HǄ$      H$   Ƅ$    A   EHW H$   m HǄ$      H$   Ƅ$    EGHW H$   ^m HǄ$      H$   Ƅ$    EGH^W H$   )m HHL$`dHD$ L$   L$   H$   I]HT$`HtLD$pL+Iya WD$`H\$pH$   HrTHH$   H=   r<t4 HAH;r3 H+Hs3 H'v3 HQ HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t3 HAH;ry3 H+Hsi3 H'v\3 H+Q HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t3 HAH;r2 H+Hs2 H'v2 HP HǄ$      H$   Ƅ$    A
   H\U H$   7k IL$   HT$xIPH$   HrTHH$   H=   r<t[2 HAH;rK2 H+Hs;2 H'v.2 HO HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;vg1 H    H=   r<tK1 HAH;r;1 H+Hs+1 H'v1 HN HH$  H3iG H  A_A^_^[LSVWAVH  IǃXH H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFHS Iph HǄ$      L$   D$   EF
HR H$   h HǄ$      L$   D$   EFHLS H$   h LHHL$H_HD$ L$   L$   H$   HXHT$HHtLD$XL+I\ WD$HLt$XH$   HrTHH$   H=   r<tj/ HAH;rZ/ H+HsJ/ H'v=/ HM HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t. HAH;r. H+Hs. H'v. HL HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<tn. HAH;r^. H+HsN. H'vA. HL HǄ$      L$   Ƅ$    A
   HP H$   f HL$   HT$xHPH$   HrTHH$   H=   r<t- HAH;r- H+Hs- H'v- H`K HǄ$      L$   Ƅ$    DDHT$xHL$HO HHHHHHJHCHBHKHJHCHBHKHL$H=, HT$xHtL$   L+I6Z HH$  H3RC H  A^_^[LWH   ICI[H H3H$   HHT$ IC   3I{@|$pDG
H9O IKe HD$h   H|$`@|$PDGHO HL$Pd LHT$pHL$P< HD$hHrQHHL$PH=   r<t, HAH;r
, H+Hs+ H'v+ HI HD$h   H|$`D$P H$   HrQHHL$pH=   r<t+ HAH;r+ H+Hs+ H'v~+ HMI HǄ$      H$   D$p A
   HM HL$pc HD$h   H|$`D$P A   HN HL$Pc LHT$pHL$P HD$hHrQHHL$PH=   r<t* HAH;r* H+Hs* H'v* HH HD$h   H|$`D$P H$   HrRHHL$pH=   r<tn* HAH;r^* H+HsN* H'vA* HH H$   H3@ H$   HĠ   _@SH   HD$HH H3H$   HHT$ HD$h   HD$`    D$P A
   HhL HL$PFb HǄ$      HǄ$       D$p A   HcM HL$pb LHT$PHL$pn H$   HrQHHL$pH=   r<t<) HAH;r,) H+Hs) H'v) HF HǄ$      HǄ$       D$p HD$hHrRHHL$PH=   r<t( HAH;r( H+Hs( H'v( HeF H$   H3> HĠ   [AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ D- AXA((yXA@^A(]\A(\YYAX(qw
 K8W
 Ys ^C0\(aw
 D\YDYCDX(DC'w
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hH8 H3HD$0HHHT$(H  HHHA   3HqHyrHH@0IE3` Hs(Hs0s8s@C<H$ HHL$0H3= H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH[ H3Hp  DHH  f  LAH(J HP   LJ HH0  襪 LHHAP HH  HrSHH0  H=   r<t% HAH;r% H+Hs% H'v% HfC HǅH     3H@  @0  Hh  HrSHHP  H=   r<tI% HAH;r9% H+Hs)% H'v% HB HǅH     H@  ƅ0   A&   HI H0  y] HH0  HP HH  HrSHH0  H=   r<t$ HAH;r$ H+Hs$ H'vx$ HGB HǅH     H@  ƅ0   E3Hz@ H0  \ HH0  HP HH  Hy  HH0  H=   r<t $ HAH;r# H+Hs# H'v# HA !  C  3A;  HǅH     H@  @0  DG9HG H0  \ HH0  HP HH  HrSHH0  H=   r<tB# HAH;r2# H+Hs"# H'v# H@ HǅH     H@  ƅ0   A   HfG H0  r[ L0  H[G HP  w LHHAP Hh  HrSHHP  H=   r<t" HAH;rv" H+Hsf" H'vY" H(@ Hǅh     H`  ƅP   HH  HrSHH0  H=   r<t
" HAH;r! H+Hs! H'v! H? Dv(WI*(Y H,ȉN,Y
  H,F0D+D+Dv4Hǅh     H`  ƅP   A9   H@F HP  Z HHP  HP HP   Hǅh     H`  ƅP   A/   H0F HP  Y HHP  HP HP  F H0  , H"F H@   HȋV,B HH0  HPHM0Q, H	F HM@В HȋV4 HHU0HPHL$0, HE HL$@蛒 HȋV0 HHT$0HPHǅh     H`  ƅP   E3Hd< HP  X HHP  HP HP  T HM:* HM H   #* H    H  	* H   Dv(DF,DN0N4~8N@AAF<Hp  H35 L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   HD HHW HT$(HH HHOHHH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHIܒK8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKH~,CHE3L%; fnHGLH(X^^Y% L9G~   @ MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKHqC8L|$ Lt$PHl$@H(_[ÍAC82H(_[H @SH A Ho6 HHH HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLH IIv@H$   3H>H~Ht3 H HH^ D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$HeE IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tH Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx H H3HEPLLHEH   HE@    E0 A)   HC@ HM0*S IHU0IPHEHHrPHHM0H=   r<t_ HAH;rO H+Hs? H'v2 H8 HL$0% IF@HL$@k    I9vH~:~D  I^@Hi: HL$@ H5 HHcI;FH|HU0HL$0# MHIAPHEHHrQHHM0H=   r<t HAH;ru H+Hse H'vX H'7 HD$0HcHH HD0HD$0HcHhT,H' HD$HHL$H\ HL$H HL$PR HM HMPH3L/ L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   H28 HH	Q HT$(HH4 HHOHHH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHIFK8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKH?,CHLOLH|$Hv % fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^Y L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0<q HKHÐC8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A HW1 HHH HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pH H3HEHHE   3H}@}DG<Hg; HMN HHUHP HEHrPHHMH=   r<tS HAH;rC H+Hs3 H'v& H2 HE   H}E A   H; HMM HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v Hf2 HE   H}E AC   H: HM M HHUHP HEHrPHHMH=   r<t5 HAH;r% H+Hs H'v H1 HE   H}E A/   Hb: HMqL HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'vy HH1 HE   H}E A<   H+9 HMK HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H0 HE   H}E E3H. HMVK HHUHP HEHrPHHMH=   r<t HAH;r{ H+Hsk H'v^ H-0 HE   H}E E3Hi. HMJ HHUHP HMb HMH3v( H\$hH|$pHP]@USVWATAVAWH$ H  HD$HH H3H   ىL$@DD$0DL$8LH  LP  HX  Hǅ      3H   @}pDGHT8 HMpJ HEh   H}`@}P8 MA!H7 HMPI    Hǅ      H   @   DGHmE H   I Hǅ      H   @   DGHE H   pI H   HD$ L   LD$@HUpHMP HEhHrPHHMPH=   r<t HAH;r} H+Hsm H'v` H/. HEh   H}`EP H   HrPHHMpH=   r<t  HAH;r H+Hs  H'v H- Hǅ      H   ƅ    A   H6 H   PH Hǅ      H   ƅ    G6 MA!H76 H   H H    H    HEh   H}`EP A   HT6 HMPG Hǅ      H   Ep 5 MA!H5 HMpG LD$0HUPHMp	 HMp/ HMP% HEh   H}`EP A   H5 HMPOG Hǅ      H   Ep I5 MA!H95 HMpG LD$8HUPHMp HMp HMP |$0fn^
 ]
 D,L$8  ;tCt
Ù   HL$P IHL$`Z H+5 HL$` IcHMP
 HHL$` HȋD HH4  Hȋ* kd   HMPk
 HH4 HL$` HH$ Hȋ
 HH4  H4 HL$`y IHL$`蜃 HHT$PHPHMd HM: H   H3{# H  A_A^A\_^[]@UVWAVAWHl$H   HEH$   H H3HE/IHLHE   E3L}D}EGH3 HM.E HE   L}D}HD8?uE
LIB< uHHMD LHUHM5 HEHrPHHMH=   r<t( HAH;r H+Hs H'v H) HE   L}E HEHrPHHMH=   r<t HAH;r H+Hs H'v H`) HE'   L}E A   H2 HMC HE   L}E A   H2 HMC HE   L}E ? u
I     HÀ< uLHHMC LFIcN(L;tL$ LMHUHMŘ HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HZ( HE   L}E HEHrPHHMH=   r<tN
 HAH;r>
 H+Hs.
 H'v!
 H' HE   L}E HE'HrPHHMH=   r<t	 HAH;r	 H+Hs	 H'v	 H' HM/H3
  H$   HĠ   A_A^_^]@USVWAVHl$H   HEHv H3HE/IHLHE   3H]]DCH0 HMA HE   H]߈]8uDIIB< uHHMA LHUHM腘 HEHrPHHMH=   r<t HAH;r H+Hs H'v Hj& HE   H]E HEHrPHHMH=   r<t^ HAH;rN H+Hs> H'v1 H & HE   H]E A   H/ HM@ HE   H]E ? uLIIB< uHHMe@ LHUHM HEHrPHHMH=   r<t HAH;r H+Hsw H'vj H9% HE   H]E HEHrPHHMH=   r<t- HAH;r H+Hs
 H'v  H$ HE'   H]E A   H. HMi? HE   H]E A   H. HMB? HE   H]E ? uLI IB< uHHM
? HFEF(D;tHD$ LMHUHM6 HUHrHA   HM(HE   H]E HM` HMV HE   H]E A   H- HM> HE'   H]E ? tHfD  HÀ< uLHHMH> LHUHM7 HM HM HM/H3 HĠ   A^_^[]HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt35 Hu HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHM. LvLu@II^I^uHtFHHHH;t
]LLMt3p I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHMG- ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+tR
 II^H\$XH    HC    HC    HtFHHHH;t[HHHt3 HX HH{H{LHSE3L9C~JL    
 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH0HD$ H\$`MHHHJ HHHFHGHHFLL+tQ
 H_H\$XININh HHIFHCIFHCIIFIFLL+tdQ
 HFG(LH) HMH) HHH\$`H0A^_^H\$Ht$WH`HLH) HlHHs3HD$ HGH;t'H;tH_  Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@g H\$xH$   H`_H\$Hl$VWAVH`HLH( HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH&
 Ht
Ha HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@Xf L\$`I[(Ik0IA^_^WH\$UVWHHpHcy(3H)t$`WuH9yt"H	4
 Ht
Ho HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM( Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tHK
 Mt
I HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHM' H$   Hp_^]#VHUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;tULLMt3
 I8 HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHM( WEIHEIHt3L
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHMu' LEHUI4HM
 HM
 IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;tuSLLMt3
 I HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHMW' WEIHEIHt3.
 Hn HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHM& LEHUIHM
 HM
 IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HEHXHp H+ H3HE'LHHE   3H]]DCH! HM1 HE   H]׈]DCHv! HM]1 HE   H]]! MA-H  HM-1 AD$(DF(D;tD$ LMHUHMu HEHrPHHMH=   r<tL
 HAH;r<
 H+Hs,
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tx
 HAH;rh
 H+HsX
 H'vK
 H I$HEI|$HFH;t'H;tH>
 Ht
Hy HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~HE(A)HH;}LEMHM] H~ID$HEM|$L}Md$ HOI;uL9gt`Mt$MtHHIL;tNMMHOL;tHP
 Mt
I HHLLgHHMLGLEHEHEHEHEHEHEH}LGIHH+HHHH~ D  HE()HH;}HMHM\ HHM'H3 L$   I[@IsHIA_A^A\_]@UVWHl$H   HEH$   Ha H3HE7HHHE/   3H]']DCH HM- HE   H]]DCH HM- HE   H]] MA.H HMc- F(DG(D;tD$ LMHUHMr HEHrPHHMH=   r<t
 HAH;rt
 H+Hsd
 H'vW
 H& HE   H]E HEHrPHHMH=   r<t
 HAH;r

 H+Hs
 H'v
 H HE   H]E HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HR HHMLLEHEHEHEHEHEHE'H}/LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHM HOLFLEHFHEL	LMHAHEHUHUHUHUHUHU'HM/LQLIHH+HHH~+     A(fAXA)HH;}
LELMMHHMn HHM7H3 H$   Hİ   _^]@UVWHl$H   HEH$   H! H3HE?HHHE7   3H]/]DCHx HMw* HE   H]]DCHl HMS* HE   H]] MA.H HM#* F(DG(D;tD$ LMHUHMn HEHrPHHMH=   r<tD
 HAH;r4
 H+Hs$
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H| HE   H]E HE7HrPHHMH=   r<tp
 HAH;r`
 H+HsP
 H'vC
 H H}HHMLLEHEHEHEHE'HEHE/HEHE7LOIHH+HHHHH~% A(f^A)HH;}
HMLEMHM HOHMLFLEHFHEL	LMHAHEHEHEHEHE'HEHE/HEHE7LQLQIHH+HHH~2@ fff     A(fA^A)HH;}
LELMMHHM^ HHM?H3o H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMHX HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM莧 HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHM HH\$xH`]H\$Ht$WHPeH%X   He    )t$@HЋ9    HcF(3HfnY5I ~nHFHl$`Hn)|$0=˗ H4   D)D$ EWf     HH(TfA.zt	i;
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
  = Df H
ۂ Xo Y׋  6 @USVWAVHl$H   HEH H3HE/IHLHU3ۉ]HE   H]]DCH HMb# HE   H]]DCH7 HM># HE   H]] MA-H HM# LFIcN(L;tL$ LMHUHM;x HEHrPHHMH=   r<t.
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 Hf HE   H]E HEHrPHHMH=   r<tZ
 HAH;rJ
 H+Hs:
 H'v-
 H HE   H]E A   HW HM! HE   H]E  MA-H HMe! LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hsw
 H'vj
 H9 HE   H]E HEHrPHHMH=   r<t-
 HAH;r
 H+Hs
 H'v 
 H IFHEHuEELuHH_IvHt3
 H' HHwHUHM IHEIvHGH;t'H;tH
 Ht
H HHHwLLEHEHEHEHEHEHEH}LOIHH+HHHH~3fff     HEHHE(fXA)HH;}LEMHM\ HM	
 HHM/H3A H   A^_^[]@SH HHI
 HH [H%
 HT$WH0HD$(H\$@HHD$     IHHH$   HKq
 Hh
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJt HHHGHFHHGLL+t}5
 H^H\$HHOHO 9 HHHGHCHG HCHWHGHG LL+t45
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHHHKQ
 HH
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHGHO
 H
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3.
 In HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHM
 HwHu@HH^uMt3
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHMx Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ HHIFHFIIFLL+t"2
 InH~H$   3HH_WD$(Ht3~
 H HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$HU IFF HHpA^_^][@USVWAVHl$H   HEH H3HE/IHHHMHJ HHHGHFHHGLL+t0
 LvLuHK HIHCIFHHCLL+t0
 HGF HE   3H]]DCH
 HM HE   H]߈]DCH HMh HE'   H]]
 MA#H	
 HM8 HFDF D;tHD$ LMHUHMdt HE'HrPHHMH=   r<tW
 HAH;rG
 H+Hs7
 H'v*
 H HE'   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;rs
 H+Hsc
 H'vV
 H% HE   H]E A   H HM HE   H]E o MA#H_ HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 Hb HE   H]E HEHrPHHMH=   r<tV
 HAH;rF
 H+Hs6
 H'v)
 H HE   H]E A   H HM HE   H]E B MA#H2 HMa MHUHM HM  HM  HHM/H3 Hİ   A^_^[]@UVWHl$H   HEH$   Ha H3HE7HHHE   3H]]DCH HM HE/   H]']DCH HM HE   H]] MA+H HMc LGHcN L;tL$ LMHUHMj HEHrPHHMH=   r<t
 HAH;rs
 H+Hsc
 H'vV
 H% HE   H]E HE/HrPHHMH=   r<t
 HAH;r	
 H+Hs
 H'v
 H HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HQ HE   H]E A   H HM HE   H]E  MA+H HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;rr
 H+Hsb
 H'vU
 H$ HHEHHFH;t'H;tHJ
 Ht
H腻 HHH~HHMHEHEHEHEHEHEHuLFIHH+HHHH~'@      HE()HH;}HMHM@ HM7H3  H$   Hİ   _^]@UVWHl$H   HEH$   Ha H3HE7HHHE   3H]]DCH  HM HE/   H]']DCH  HM HE   H]] MA.H HMc LFHcO L;tL$ LMHUHMf HEHrPHHMH=   r<t
 HAH;rs
 H+Hsc
 H'vV
 H% HE   H]E HE/HrPHHMH=   r<t
 HAH;r	
 H+Hs
 H'v
 H HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HQ HE   H]E A   H  HM HE   H]E # MA.H HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;rr
 H+Hsb
 H'vU
 H$ HHHEHvHGH;t'H;tHF
 Ht
H職 HHHwHHMHEHEHEHEHEHEH}LGIHH+HHHH~#     HE()HH;}HMHM< HM7H3  H$   Hİ   _^]H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	\
 Ht
H藶 HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHM+ Hcw HuH9wt"H
 Ht
H HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHM (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHM WEHHE'H~Ht3	
 HI HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHM% LEHUIHMa
 HMV
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H* HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHMe WEHHE'H~Ht3<
 H| HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM LEHUIHM
 HM
 IL$   I[(Is0IA^_]HUWAVHhH   HEHXHp H? H3HE7LHHE   3H]]DCH HM HE   H]]DCH HMq HE/   H]'] MA.H HMA AF DF D;tD$ LMHUHML HE/HrPHHMH=   r<ta
 HAH;rQ
 H+HsA
 H'v4
 H HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r}
 H+Hsm
 H'v`
 H/ IHEI~HFH;t'H;tHU
 Ht
H萯 HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~ @ HE(A)HH;}LEMHM4 H~IFHEMvHGI;t'L;tH
 Mt
I HHLwHHMHEHEHEHEHEHEH}LGIHH+HHHH~&fff     HE()HH;}HMHM3 HHM7H3] L$   I[0Is8IA^_]@UVWHl$H   HEH$   H H3HE7HHHE   3H]]DCH HM HE   H]]DCH HM HE/   H]'] MA/H| HM F DG D;tD$ LMHUHMaI HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE/   H]'E HEHrPHHMH=   r<tz
 HAH;rj
 H+HsZ
 H'vM
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r 
 H+Hs
 H'v
 H HHMLLEHEHEHEHEHEHEH}LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHMb LGHNHMMLMHEHEHEHEHEHELEM@IHH+HHH~.@      (fAXA)HH;}
HMLMHHM HHM7H33 H$   Hİ   _^]@UVWHl$H   HEH$   H H3HE?HHHE   3H]]DCH HM HE   H]]DCH HM HE7   H]/] MA/H HM F DG D;tD$ LMHUHMAF HE7HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 Hf HE7   H]/E HEHrPHHMH=   r<tZ
 HAH;rJ
 H+Hs:
 H'v-
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H H}HHMLLEHEHEHEHEHEHEHEHELOIHH+HHHHH~% A(f^A)HH;}
HMLEMHM肆 HGHEHNHML LEHUHUHUHUHUHUHUHULHIHH+HHH~&@ A(f^A)HH;}
HMLEMHHM HHM?H3 H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM莄 LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHM HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM> HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM~ HH\$xH`]@SH@Hy HQHuWHHL$ HD$ HT$0  (fnC 
8? X
d Y\d YXH@[HUVWAVAWHhH0  HD$PHX )pH H3HEMHHHT$@3|$4HE   H}@}DGH HM  HE   H}@}DGH HM  HE   H} @} MA.H HM~  IGDF D;tHD$ LMHUHMV HEHrPHHMH=   r<t
 HAH;r
 H+Hs}
 H'vp
 H? HE   H} E HEHrPHHMH=   r<t3
 HAH;r#
 H+Hs
 H'v
 H HE   H}E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 Hk HE   H}E A   H HM  HE   H}E  MA.H HM  MHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H}E HEHrPHHMH=   r<t
 HAH;r
 H+Hs|
 H'vo
 H> H;H{LvMt3n
 I计 HLsIHD$pHFHEHHEHvL;t'I;tH1
 Ht
Hl HH;HsHHEHEHEHD$`HEHD$0HEH]LsIHH+HHHH~BHE(4HE()D$@HL$@QHD$p(fYfXHM)4HH;|MHHMp HHMH3 H$x  ($   H0  A_A^_^]HT$WH0HD$(H\$@HHD$     IH/HH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+t
 H_H\$HHNޟ HHHFHCHVHFLL+t
 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHH$HK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     I"HHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHOT
 HK
 HH\$@H0_HW  @SH0HD$     HQH胴  HH0[H\$WH HHQHtLAL+I  3HCHCHCHë H@t
    He HH\$0H _@SH HQHHt.LAL+I~  3HCHCHCHY HH [HI HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXH
 D$(HD$0HT$83HL$ HD$8HD$@Hp HD$ 
 HΧ HK HD$0HL$0 H\$WH HHQ HtLA0L+Ix  3HC HC(HC0HS H@t
8   H HH\$0H _@SH HQ HHt.LA0L+I  3HC HC(HC0H HH [H٩ HH [@SH HHHSH
a
 H3H
HJHH
 H HHH [HAHH`HAHH`H\$WH H HHAHm  HF HGHt
8   H HH\$0H _@SH Hc HHAH  H HCHH [@SUVWATAUAVAWHxHD$(H H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HH HHHL$ H HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ H
 HIFHAIFHAIFHAH IV   H HHN踵  L- L.H IGIO蚵  MoM/H  I  IV HtMF0L+IX  3IF IF(IF0M.HHL$`H3g HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+IU  H{pH{xH   HK8]  HS HtLC0L+I$  H{ H{(H{0H HH\$0H _H\$WH H,   t
  H HH\$0H _H\$Ht$WH H  HHt*L  L+I  3H  H  H  H5a H   H  HKpH= HKPH{@Q  Hs@HKHs8H{<  HsH3H\$0Ht$8H _HL$SH0HD$ HHӠ HLALD$HH0 I HBI@HIHHA   HA    HyrHH  IE3/  HH0[HL$WH0HD$ H\$PHHH HHBHAHBHAHBHAH H 裫  HO8HL$HHʞ HHC@HAHCHHAHCPHAHSXH *  HSpHOp\  HH\$PH0_@SH HHI HtCHS(Ua LC0H*L+C IHLI?LHS Y  3HC HC(HC0Ht HH [H\$WH Ht
   H HH\$0H _H\$WH H<t
8   H HH\$0H _H\$Ht$WH HHHHm
 $ HH $ HH'
 $ HHW( HH* گ
 Hg
 Hs$ HHY d$ HH
 U$ WPH`
 HH* 
 HE
 H)$ HH# $ HH
 $ HH
 HHF* H
 H5
 H# HH # HH
 # WH
 HH) 
 O|tttt3   H
 Hw# HH h# HH
 Y# Hȋ
 HH) 
 O|  [  	  H
 H# HH/ # HH
 "    H4
 HH*) ,
 H
 H" HH " HHp
 "    H
 HH( 
 H
 Hy" HH j" HHl
 ["    H
 HH( 
 H
 H-" HH{ " HHX
 "    HP
 HHF( H
 H
 H! HH; ! HHL
 !    H
 HH' 
 H
 H! HH ! HH^
 u!    H
 HH' 
    tB  H%
 H1! HH "! HHD
 ! H   H
 H  HHv   HH
   HK W  L   HD HL
 H  HHn   HH
      H
 HH& ʫ
           HF
 HB  HH 3  HH
 $  HHJ   HH[& ]
 L   HD L   H7E L   HH aD L   HrE L   HH |C L   HE L   HH B #  H
 Hs HH d HH
 U HH+ F HH% 
 L   HD L   HhD L   HH C L   HD L   HHJ B L   HD j  H
 H HH8  HH
  Hm   H
 H HH r HH
 c    H
 HH$ 
 H
 H5 HH & HH
     H
 HHM$ O
 H
 H HH  HH+
     H
 HH$ 
 L   HA H
 H HHS ~ HHX
 o   H
 HH# 
 HC
 H? HH 0 HHR
 !   HH
 HHV# X
 H
 H HH  HH,
     Hۦ
 HH	# 
 H
 H HH  HHo
     H
 HH" 
 Hr
 HV HH\ G HH!
 8    H_
 HHm" o
 H$
 H HH  HH
     H
 HH" !
 H
 H HH  HH
     Hæ
 HH! Ӧ
          tB  H
 HF HH 7 HH
 ( H   H
 H
 HHc  HH
  H l  Hp
 H HH*  HH7
  HH<  HH  
 L   HH ?   H
 Hm HH ^ HH
 O   H
 HH  
    tzt?   H
 H HH^  HH{
  Hc jHF
 H HH(  HH
  H 4H
 H HH  HH
 ~ H Ho H H
 y tIH
 HJ HH ; HH
 , HHWXP HHf h
     tLH$
 H HHF  HHS
  HH    HH 
 H
 H HH
  HH
  WxH
 HH ɣ
 H&
 Hb HH H\$0Ht$8H _H%
 H%
 @WHPHD$ H\$hHp H3HD$HHHD$@   3H|$8@|$(E3H HL$(Q  HT$(Hc  HD$@HrQHHL$(H=   r<t
 HAH;rt
 H+Hsd
 H'vW
 H& H   H   H  HHL$HH3葻 H\$hHP_@UVWATAUAVAWHl$H   HEH$   Ho H3HEA؉]HLHUE    A}NH
 HE3HEHEHQ HEEHUHM
 H HEH0 HM H    HB    HB    E   HE   HE    E A   H HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtH .	 u
HJ  H{rHHA   I;LBMtHb 	 u
H  H{rHHA   I;LBMtH/ 	 uDHu>LFIH+HgfffffffHHHH?H  IH4  HF   H{H{rHH?A   I;LBMtH H>	    Hs	3Hu{A^HE   HE    EIE3HUHM+  ]HUH}  HM蒟  3IV(HEH;tIE3HM  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHMb  DmHUHR|  HMȞ  HEHrPHHMH=   r<t[
 HAH;rK
 H+Hs;
 H'v.
 H HNH
 HE3HEHEH HEEHUHMf
 H? HEH, HM HMH3. H$   Hİ   A_A^A]A\_^]  @SH HH(Ν  HKH [  @UVWATAUAVAWH$@H  HD$8H$  HUk H3H   MH= HL$@轫  HHPHHI HL$P/ HH$ }H8 HL$P z  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<H HL$P HHS HH  HHD$ TӜ
 HL$(Lt$ I+IHHLI?LAxoIcH<HL@ ff     K4H HL$P+ HHP HH^  HBT7 S
 Md$HAxLt$ H^ HL$P HH" $
 HL$ Ht2HT$('K HL$0H+L$ IHHLI?LHT$   HU`HL$@a  H6 tSHEX   HEP    E@ A	   H HM@  LE@HU`H   Uv  H) H   ( H6 tSHEX   HEP    E@ A   H| HM@[  LE@HU`H   Vt  Hw! H    H6 tSHEX   HEP    E@ A
   H- HM@  LE@HU`H   Wr  HP" H   j H6 tSHEX   HEP    E@ A
   H HM@  LE@HU`H   Xp  H+ H    Hl6 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 Hś HE@H. HM@ HH6 tXHE`H}xHCE`H
'
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H& HM@C H$6 tXHE`H}xHCE`H
ã
 HM@3HMHHMPHD$ D$(HUHHL$ D
 H
 HE@H
, HM@ H 6 tXHE`H}xHCE`H
_
 HM@3HMHHMPHD$ D$(HUHHL$ 
 HY HE@Hn" HM@{ H5 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ |
 HU HE@HB% HM@ H5 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H& HM@ H5 tXHE`H}xHCE`H
3
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H- HE@H! HM@O Hp5 tXHE`H}xHCE`H
ϡ
 HM@3HMHHMPHD$ D$(HUHHL$ P
 H HE@Hf" HM@ HL5 tXHE`H}xHCE`H
k
 HM@3HMHHMPHD$ D$(HUHHL$ 
 HŐ HE@Hz% HM@ HEX   HEP    E@ A   H HM@  LE@HU`H   j  H# H   4 HL$WH0HD$ H\$HHHH
 HHQ3HHBHK1
 HQ HHSHOHA   HA    HyrHH  IE3@  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 H
 HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 H1 HHSHOHA   HA    HyrHH  IE3   HH\$HH0_@SH HHHSH

 H3H
HJHH
 H̔ HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHKA
 Hq HHSHOHA   HA    HyrHH  IE3P  HH\$HH0_@SH HHHSH
1
 H3H
HJHHÔ
 H HHH [@SH HHHSH
 H3H
HJHH
 H$ HHH [@SH HHHSH
 H3H
HJHHC
 H HHH [@SH HHHSH
q
 H3H
HJHH
 HL HHH [HL$WH0HD$ H\$HHHH#
 HHQ3HHBHK
 Hy~ HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH Hw HHH  H
 HOH
 t
8   H耲 HH\$0H _H\$WH H
 HHH讑  H/
 HOH:
 t
8   H  HH\$0H _H\$WH H HHHN  Hϛ
 HOHڒ
 t
8   H HH\$0H _H\$WH Hg HHH  Ho
 HOHz
 t
8   H` HH\$0H _H\$WH H| HHH莐  H
 HOH
 t
8   H  HH\$0H _@SH0HD$ HH HH
 HA(H0
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HH@ HHN
 HA(H0X
 H9 HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH{ HHՙ
 HA(H0ߐ
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HH0{ HHn
 HA(H0x
 HY HHKHtHP tHC    @t
@   H8 HH\$@H0_H\$WH HH HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   < L   H988L  M+IHLI?LI  3H   H   H  H   訚  H   H [H%u
 HL$SH0HD$ HHC HE3LAH蠿Hh HLC0LC8LC@LCHLCPLCXLChLCpLCxL   L   L   L   L   L   L   L   H   HH0[LWATAUAVAWH@  IǃI[Is A)sHZ H3H$   HHT$HHWD$hE3Lt$xD$PLt$`	    IǃP   MHD$  EFHI I8  HǄ$     L$  D$  EFH H$  l  HǄ$     L$  D$  EFH H$  7  HL$0HD$ L$  L$  H$  H薷HT$0HtLD$@L+I芻  WD$0Lt$@H$  HrTHH$  H=   r<t
 HAH;r
 H+Hs
 H'v
 H身 HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t
 HAH;r
 H+Hsz
 H'vm
 H< HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t
 HAH;r
 H+Hs
 H'v
 H辪 Dv(HǄ$     L$  Ƅ$   A   Ha H$  D  HL$  HT$0HP(HHD$hH;t'HH\$hHJHL$pHBHD$xL2LrLrH\$hHT$0HtLD$@L+Iɨ  WD$0Lt$@H$  n  F(    HǄ$     3H$  $  DCH# H$  z  HǄ$     H$  $  DCH? H$  F  HǄ$     H$  $  DCH H$    HL$0HD$ L$  L$  H$  HqHT$0HtLD$@L+Ie  WD$0H\$@H$  Z  H$  L  H$  >  ^,HǄ$     H$  Ƅ$   A   HN H$  U  HL$  HT$0HP(HHL$h  HT$0HtLD$@L+I  WD$0H\$@H$  談  HD$hN,    HǄ$     H$  Ƅ$   A   HΩ H$    HǄ$     H$  Ƅ$   A   Hw H$  z  DF(EyH$  H$  H$    H$    HǄ$     H$  Ƅ$   A   Hf H$  	  HǄ$     H$  Ƅ$   A   Hϸ H$    HǄ$     H$  Ƅ$   A   H H$    HcV(HL$0茸HD$ L$  L$  H$  HHT$0HtLD$@L+I  WD$0H\$@H$  ߅  H$  х  H$  Å  HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H H$    DF(EyH$  H$  H$  )  H$    W$  HcV(WD$0H\$@L$  HL$0K  HT$0HN0  HT$0HtLD$@L+I貴  HǄ$     H$  Ƅ$   A   Hٶ H$  ܿ  HL$  HT$0HPHHL$P舁  HT$0HtLD$@L+I=  WD$0H\$@H$  2  LLcV(LL|$PA   IrnHF0HHPML+AH+MZIIN$    Mff     IDHBIHIDHBHIDHHR IuH|$H3M;sHV0KHJIHIM;r     HǄ$     H$  Ƅ$   A   H H$  虾  HǄ$     H$  Ƅ$   A   Hs H$  b  DF(EyH$  H$  H$    H$  ׂ  HǄ$     H$  Ƅ$   A   HN H$    HǄ$     H$  Ƅ$   A   Hˤ H$  躽  HǄ$     H$  Ƅ$   A   Hh H$  能  HcV(HL$0tHD$ L$  L$  H$  HޭHT$0HtLD$@L+Iұ  WD$0H\$@H$  ǁ  H$  蹁  H$  諁  H$  H$  E33H$  I  A   Hܣ H$  迼  H$  H$  E33H$    A   H H$  肼  DF(EyH$  H$  H$    H$    $  HcV(WD$0H\$@L$  HL$0*  HT$0HNH}  HT$0HtLD$@L+I葰  H$  H$  E33H$  ?  A   HƢ H$  赻  HL$  HT$0HPHHL$Pa}  HT$0HtLD$@L+I  WD$0H\$@H$    LLcV(LL|$PIrmHFHHHPML+IH+MZIIN$    Mf     IDHBIHIDHBHIDHHR IuH|$H3M;sLNHKHKIHIM;r    H$  H$  E33H$    A   H H$  s  H$  H$  E33H$    A   H7 H$  6  H$  H$  E33H$  胳  A   Hް H$    HL$0ΰHD$ L$  L$  H$  HXHT$0HtLD$@L+IL  WD$0H\$@H$  A~  H$  3~  H$  %~  ^`H$  H$  E33H$    A   H7 H$  6  HL$  HT$0HP(HHL$hu  HT$0HtLD$@L+I  WD$0H\$@H$  }  HD$hN`    H$  H$  E33H$    A   H H$  茸  H$  H$  E33H$  ٱ  A   Ht H$  O  DF(EyH$  H$  H$  |  H$  |  H$  H$  E33H$  b  A   Hٮ H$  ط  H$  H$  E33H$  %  A   H H$  蛷  DF`EyH$  H$  H$  |  H$  |  H$  H$  E33H$  记  A   H H$  $  H$  H$  E33H$  q  A   H H$    H$  H$  E33H$  4  A   H H$  誶  LcF`HcV(HL$0׭HD$ L$  L$  H$  HHT$0HtLD$@L+I  WD$0H\$@H$  z  H$  z  H$  z  H$  H$  E33H$  l  A   H H$    H$  H$  E33H$  /  A   Hʜ H$  襵  DF(EyH$  H$  H$  (z  H$  z  H$  H$  E33H$  踮  A   H/ H$  .  H$  H$  E33H$  {  A   H H$    DF`EyH$  H$  bH$  ty  H$  fy  $  HcV`WD$0H\$@L$  HL$0虬  HcV(W$  H$  LD$0H$  n  H$  HNhmc  H$   c  HT$0HtLD$@L+IĨ  H$  H$  E33H$  r  A   H
 H$    HL$  HT$0HPHHL$Pu  HT$0HtLD$@L+II  WD$0H\$@H$  >x  LHc^`H$  E3H   L|$PLcF(3IrzHFhLHP0M_OA   L+IXHHH<    LHJICJHJICJH
IJIJ!ICJM[ HR`HuH$  I;s(L^hHHL+JKJIHRIuIL;AH|$H|    3H$  H$  E33H$    DCHe H$  d  H$  H$  E33H$  豫  DCH. H$  )  DF`EyH$  H$  H$  v  H$  v  H$  H$  E33H$  <  A   H H$  貱  H$  H$  E33H$    A   Hz H$  u  H$  H$  E33H$  ª  A   H H$  8  HcV`HL$0)HD$ L$  L$  H$  H蓡HT$0HtLD$@L+I臥  WD$0H\$@H$  |u  H$  nu  H$  `u  H$  H$  E33H$    A   Hu H$  t  H$  H$  E33H$    A   H< H$  7  DF`EyH$  H$  H$  t  H$  t  $  HcV`WD$0H\$@L$  HL$0ߧ  HT$0H   q  HT$0HtLD$@L+IC  H$  H$  E33H$    A   Hl H$  g  HL$  HT$0HPHHL$Pq  HT$0HtLD$@L+Iȣ  WD$0H\$@H$  s  LLcV`HLt$PIroH   HL@ML+Ȼ   H+MZIIN$    IfD  KDI@KI KDI@JKDH9M@ IuH|$H3I;sL   KHIHHII;r8 	   H$  H$  E33H$  誧  A   H= H$     H$  H$  E33H$  m  A   H H$    DF(EyH$  H$  TH$  fr  H$  Xr  H$  H$  E33H$    A   He H$  l  H$  H$  E33H$  蹦  A   H@ H$  /  Lv,EEyH$  H$  H$  q  H$  q  H$  H$  E33H$  ?  A   H H$  赬  H$  H$  E33H$    A   H H$  x  H$  H$  E33H$  ť  A   H  H$  ;  McHcV(HL$0iHD$ L$  L$  H$  H蓜HT$0HtLD$@L+I臠  WD$0H\$@H$  |p  H$  np  H$  `p  H$  H$  E33H$    A   H H$  t  H$  H$  E33H$    A   HH H$  7  DF(EyH$  H$  H$  o  H$  o  H$  H$  E33H$  J  A   H H$    H$  H$  E33H$  
  A   H H$  胪  EEyH$  H$  H$  o  H$  n  $  IcWD$0H\$@L$  HL$0-  HcV(W$  H$  LD$0H$    H$  H   X  H$  X  HT$0HtLD$@L+IU  H$  H$  E33H$    A   H H$  y  HL$  HT$0HPHHL$P%k  HT$0HtLD$@L+Iڝ  WD$0H\$@H$  m  LIcH$  E3H   L|$PLcN(3I   H   LHP0M_OA   L+IYHHH<    Lfff     HJICJHJICJH
IJK4HICJM[ HR`HuH$  I;s+L   HHL+IKJIHRIuIL;,H|$HLv, 
   H H$  n  H H$  m  EEyH$  H$  bH$  tl  H$  fl  H H$  m  H H$  m  H] H$  xm  IcHL$0jHD$ L$  L$  H$  HԗHL$0R  H$  k  H$  k  H$  k  H H$   l  H H$  l  EEyH$   H$  XH$  jk  H$   \k  IcW$  H$  Q  H$  H   Q  H$  l
 Hn H$   Yl  Ld$HI$L$   HT$0IPHHL$Pg  HL$0Q  H$   j  E3EMcELt$PIrwH   HHPML+ȹ   H+H$  MSIIN<    MfD  IDHBIHIDHBHIDHHR IH$  uM;sL   KHKIHIM;r8    H H$  Hk  HP H$  3k  H H$   k  HL$0HD$ L$  L$  H$   I}HL$0bP  H$   i  H$  vi  H$  hi  L   H H$  j  I$L$  HT$0IPHHL$PHf  HL$0O  H$  i  HD$PHH   #    D$H   H$ H$  +j  H H$   j  LL$HLF,H$  H$   7 H$   h  H$  h      Dl$HH՚ H$  i  H  H$   i  LL$HL   H$  H$    H$   #h  H$  h  LnHFHFHF&    H7 H$  6i  HB H$   !i  DF`EyH$  H$   H$   g  H$  g  HcF`HHF    H H$  h  Hљ H$   h  DF,EyH$  H$   H$   +g  H$  g  HcF,HFHL$PM  HL$hI  H$   H3 L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH Hd HHH   oh
 H   3H*HtNH    L   HH   I+HHLI?LI  H   H   H   H   Ht(L   L+I  H   H   H   HKhHt:HSpk HKxHH+KhHHLI?LHShv  H{hH{pH{xHSHHtLCXL+I葕  H{HH{PH{XHS0HtLC@L+Il  H{0H{8H{@H)a HKHH\$0Ht$8H _~  @SVWATAUAVAWH  HǄ$  )$  H2 H3H$p  LL$8MLHIHL$`<_  IHL$xG   $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGHʆ H$0  豟  IH$0  IPH$H  HrTHH$0  H=   r<tf
 HAH;rf
 H+Hsf
 H'vf
 Hx tiHen
 H$   3H$   H$   H4 HD$8D$@H$   HL$8d
 H] H$   HY
 H$   b HǄ$     H$   Ƅ$   A   H H$  蕞  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+IĒ  W$0  H$@  H$  HrTHH$  H=   r<tLe
 HAH;r<e
 H+Hs,e
 H've
 H HǄ$     H$  Ƅ$   A   HՂ H$  x  HǄ$h     H$`  Ƅ$P   A   HZ H$P  A  HǄ$     H$   Ƅ$   A   HW H$  
  H$0  ܓHD$ L$  L$P  H$  IfH$0  Ht(L$@  L+IT  W$0  H$@  H$  Ca  H$P  5a  H$  'a  D$0HT$0HL$`\  HǄ$     H$  Ƅ$   A   H< H$  '  IH$  IPH$  `  tiH0k
 H$   3H$   H$   HG HD$8D$@H$   HL$8a
 HsZ H$   H$
 H$   - HǄ$     H$  Ƅ$   A   Hu H$  `  IL$  H$0  IPHHL$H	]  H$0  Ht(L$@  L+I踏  W$0  H$@  H$  _  HǄ$     H$   Ƅ$   A   H H$    HǄ$h     H$`  Ƅ$P   A   H H$P  芚  HǄ$     H$  Ƅ$   A   H H$  S  H$0  %HD$ L$  L$P  H$  I诊H$0  Ht(L$@  L+I蝎  W$0  H$@  H$  ^  H$P  ~^  H$  p^  HD$H D$0HT$0HL$`Y  HǄ$     H$  Ƅ$   A   H H$  k  IH$  IPH$  ]  tiHth
 H$   3H$   H$   HÐ HD$8D$@H$   HL$8^
 HW H$   Hh
 H$   q HǄ$     H$  Ƅ$   A   Hŏ H$  褘  IL$  H$0  IPHHL$HMZ  H$0  Ht(L$@  L+I  W$0  H$@  H$  \  HHǄ$h     H$`  $P  A   H H$P    HǄ$     H$  Ƅ$   A   H H$  ̗  DF`EyH$P  H$  =H$  O\  H$P  A\  HǄ$     H$   Ƅ$   A   H| H$  [  HǄ$h     H$`  Ƅ$P   A   HE H$P  $  HǄ$     H$  Ƅ$   A   H: H$    HcV`H$0  ۍHD$ L$  L$P  H$  IEH$0  Ht(L$@  L+I3  W$0  H$@  H$  "[  H$P  [  H$  [  Wt$0HcV`W$0  H$@  LD$0H$0  3  L$0  9V`~)ILD$Hfff     IH[HHI;V`|;^`}HcIHL$`V  HǄ$     H$  Ƅ$   A	   H H$  藕  IH$  IPH$  #Z  tiHd
 H$   3H$   H$   H? HD$8D$@H$   HL$8
[
 HS H$   H
 H$   蝅 HǄ$     H$  Ƅ$   A	   HŌ H$  Д  IL$  H$  IPHHL$HyV  H$  Ht(L$   L+I(  W$  H$   H$  Y  H$   H$(  E33H$  赍  A   Hy H$  +  H$`  H$h  E33H$P  x  A	   H H$P    H$  H$  E33H$  ;  A   H H$  豓  H$  胊HD$ L$  L$P  H$  I
H$  Ht(L$   L+I  W$  H$   H$  W  H$P  W  H$  W  HD$H D$0LD$0(HL$`*  H$   H$(  E33H$  J  A   H H$    IH$  IPH$  LW  tiHa
 H$   3H$   H$  H HD$8D$@H$   HL$83X
 HQ H$   H
 H$   Ƃ H$   H$(  E33H$  }  A   H H$    IL$  H$  IPHHL$HS  H$  Ht(L$   L+IK  W$  H$   H$  :V  HH$  H$  E33H$  Պ  A   HD H$  K  H$   H$(  E33H$  蘊  A   H7 H$    DF,EyH$  H$  H$  U  H$  U  H$`  H$h  E33H$P  !  A   Hu H$P  藐  H$  H$  E33H$    A   H H$  Z  H$   H$(  E33H$  觉  A   Hj H$    HcV,H$  HD$ L$P  L$  H$  IuH$  Ht(L$   L+Ic  W$  H$   H$  RT  H$  DT  H$P  6T  t$0HcV,W$  H$   LD$0H$  f  L$  L|$H9V,~IIH[HHI;V,|fD  ;^,}HcIHL$`JO  HT$`HL$8L  HT$xI)5  MtL$   M+IIl  MtL$@  M+IIO  H$@  HtH+HLr  MtLD$XM+II  HL$`&  H$p  H3-l ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xH  H3HEH3HE  HE   3Hu@uDFHt HMߍ  HCHMH;sTHHUH;wHH}H+H;CuVH͂  HH;HKHtcHA   HqHyrHHH;H;Cu
   H节  HKHt'HA   HqHyrHHHU  
  HC HEHrPHHMH=   r<tyT
 HAH;riT
 H+HsYT
 H'vLT
 Hr HE   HuE A   Hs HM赌  HCHMH;sVHLEI;wJH}H+H;Cu
   H衁  HH;HKHtcHA   HqHyrHHH;H;Cu
   H^  HKHt'HA   HqHyrHHHU  ޑ  HC HMP  HE   HuE A   H HMڋ  HUHE  HMsP  HE   HuE A	   H HM蝋  HUHE  HM6P  HE   HuE A   H HM`  HUHsE  HMO  HE   HuE A   H HM#  HUH6E  HMO  HMH3h H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLH<  WEE3LuHMH  HUH;  HMH  HUH;  HMG  Ic`H} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
j 4N
 HQM+IIHHH+IMI;LCL;ICHM蟦  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
Ղ M
 HQM+IIHHH+IMI;LCL;ICHM
  HMHtH9HHMHUH:  HMF  HUH:  HMlF  Ic,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
 L
 HQM+IIHHH+IMI;LCL;ICHM)  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
l 6L
 HQM+IIHHH+IMI;LCL;ICHM衤  HMHtH9HHMHUH8  HME  Ic`H} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
 jK
 HQM+IIHH+II;LCL;ICHMۣ  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
" J
 HQM+IIHH+II;LCL;ICHM]  HMHtH9HHMHUHm7  HUHtLEL+Iz  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HD$ HXHpHx Hb H3H   EELHHL$0X  HL$H轐  E3LmHl HL$@5  HU0HL$0W  HI?  HEHHrQHHM0H=   r<tL
 HAH;rL
 H+HsL
 H'vL
 Hpj HL$H%  LmH"l HL$@蠾  HU0HL$0rV  HI?  HEHHrPHHM0H=   r<t9L
 HAH;r)L
 H+HsL
 H'vL
 Hi    9_`   HL$H聏  LmH{ HL$@  HȲ.  Hȋ7I
 HU0HL$0U  HI]>  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH>i ;_`!gTK
 MK
 FK
 ?K
 HL$H̎  LmH{ HL$@G  HU0HL$0U  HI=  HM0CH  9_,        HEH   Lm@E0 HL$Hf  LmHM0	H  Hnz HL$@ؼ  HȲ.  HȋH
 HU0HL$0T  HI9=  HM0G  ;_,~Eu	E   `x   HEH   Lm@E0 HL$H֍  LmHM0yG  H>{ HL$@H  HȲ.^  HȋG
 HU0HL$0T  HI<  HM0/G  ;w`~HMT  HMG
 H   H3&` L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx Hv H3H   LHHL$0T  HL$Hٌ  E3L}Hh HL$@Q  HU0HL$0#S  HI;  HEHHrQHHM0H=   r<tH
 HAH;rH
 H+HsH
 H'vH
 Hf HL$HA  L}H>h HL$@輺  HU0HL$0R  HI2;  HEHHrPHHM0H=   r<tUH
 HAH;rEH
 H+Hs5H
 H'v(H
 He    9_`       HL$H薋  L}Hw HL$@  HȲ.'  HȋLE
 HU0HL$0Q  HIr:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wHSe ;_`!giG
 bG
 [G
 TG
 HL$H  L}Hw HL$@\  HU0HL$0.Q  HI9  HM0XD  ,   @ ff     HEH   L}@E0 HL$Hv  L}HM0D  H~v HL$@  HȲ.  Hȋ#D
 HU0HL$0P  HII9  HM0C  ;w,~     HMP  HM}D
 H   H3\ L$  I[ Is0I{8IA_A^]H\$WH Ht
   Hc HH\$0H _H\$Ht$WH H3H  Ht;H  T H  L   L+Ip  H  H  H   H  H*HtNH  C L  HH  I+HHLI?LIF_  H  H  H  H  uB  H  Ht(L  L+IFr  H  H  H  HKp   HKXHt)HS`f HSXLChL+Io  H{XH{`H{hHK@Ht:HSHt HKPHH+K@HHLI?LHS@^  H{@H{HH{PHS HtLC0L+Iq  H{ H{(H{0HSHtLCL+Iuq  H{H{H{H\$0Ht$8H _H\$WH HHJA  HOXAA  LG8HT$0MHO8M 9o  HO8a LG(HT$0MHO(M p  HO(a HOH\$8H _@  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hs\  HH_8H\$HH3HsD  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"     H_ HH [H\$Ht$WH H3H  Ht;H  4 H  L  L+Izl  H  H  H  H  Ht(L  L+I]  H  H  H  H  Ht(L  L+Ibn  H  H  H  H  H*HtNH  k L  HH  I+HHLI?LIZ  H  H  H  Hx  Ht;H  ! Hx  L  L+Igk  Hx  H  H  HX  HtNH`   LX  HHh  I+HHLI?LIZ  HX  H`  Hh  H@  Ht;HH   H@  LP  L+Ij  H@  HH  HP  HKpHHH\$0Ht$8H _xHT$SH0HD$(H3D$ HHBHBD$    H  Hx  L[  HH0[@SH0HD$     H  HZ  HH0[@SH0HD$     HX  HZ  HH0[@SH0HD$     Hx  H2  HH0[@SH0HD$     H@  Hp2  HH0[H   HD$0LH  L  HQpHD$ I  tWH*F
 HD$P3HD$XHD$`Hbo HD$@D$HHT$XHL$@<
 Hy5 HD$PH-
 HL$P9g 3HĈ   @USVWATAVAWH$ H  HEH H3H   EIHHHUH]E3Dd$4IHL$P35  Lt$XL+t$PIL;vx   HMI  H^xHn HM茯  HI:
 HHn q  HH:
 HHn V  H   HM&G  HxrH H
D
 HL$h3HL$pHL$xHEEHT$pHM\;
 H< HD$hHa
 HL$he Dd$0H   H+   HWD$8Ld$HLD$0HL$8  L'LgLgD$4   HNpLLD$8HT$PEt  T  HT$8HtLD$HL+IX  WD$8Ld$HHT$PHtLD$`L+IOi  HHtLCL+I6i  L#LcLcHH   H3IR H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH H3H   EEHHHUHL$H3  Ht$PH+t$HHH;wx   HMF  H_xHl HMd  HH8
 HHvl I  HH}8
 HHWl .  H   HMD  HxrH H
B
 HL$h3HL$pHL$xHEEHT$pHM49
 H9 HD$hH9
 HL$hc 3t$`H   H+   HWD$0Ht$@LD$`HL$0  EuLHOpLD$0HT$HEt2  (HT$0H   LD$@L+IV  WL$0|  WD$hHt$xHOpLL$hLD$0HT$HEt    (HT$hHtLD$xL+If  HT$0HtLD$@L+I3V  WD$0Ht$@HT$HHtLD$XL+If  HHtLCL+If  H3HsHs(H   H3O H$   ($  H  A_A^_^]@SVWH  HD$pH H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   QD  HxH^H+HHi H$   轪  HH5
 HHi 袪  HH5
 HHi 自  H$  H$   RB  HxrH H
@
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`6
 H>7 HD$HH
 HL$Ha H   H+   HHL$H  HOpD$0D$(H\$ L_  HT$HHtLD$XL+I#T  HH$  H3M Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E3HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK"gWD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`jHT$8HtLD$HL+IR  HL$`nHL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xHnfHHMp聥3x6
 L   A   AA+iA+AD̉8    AA+iD+EDD<  H@  
 HUpHX   3DL`  LX  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;rp  H@  Hx  h(  HX  H  DP  H  H;H{H{H  H  H  p    H  H  H  H|$      f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   H6c  HKHHt(HHH;Cu
   Hc  HCHtH8HCHH|$   H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hb  HHKHt,HH#H;Cu
   Hyb  HCHtH HCH  H  A
 L  H  Hx    HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H
 H3HEHLHUHMM&  H]HLuIi E3H;  HE   LeDeED$H
R HMj  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
c .
 HSM+IIHL+IIM;HCH;HCHM術  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
9c .
 HSM+IIHL+IIM;HCH;HCHM  H]Ht*HC   LcH{rHHHU  H.o  H H]HEHrPHHMH=   r<t0
 HAH;r0
 H+Hsz0
 H'vm0
 H<N HUI E  M  I  Ix  6  H]Ht HUH LEL+IHZ  HHt'HV HLFL+IZ  L&LfLfHMH3?F L\$pI[@IsHIA_A^A\_]L$SH0H)t$ IHT$H HKHD$@D$@(H;s\HHT$@H;wOH|$PH|$@H+HH;Ku
   H^  HSHt
HHH
H|$PHBHC(t$ H0[H;Ku
   HZ^  HCHt0(t$ HHCH0[H\$WH HQ3HHtLA(L+IHK  H{H{ H{(HHtLCL+I[  H;H{H{H\$0H _Hy0HArH @SH H HHH+  H6
 HKHH [H%-
 H\$ WHpH'
 H3HD$`3HHAIHAH@ HHL$@  HHL$ L  HHOLm_ p  HD$8HrQHL$ HH=   r<t-
 HAH;r-
 H+Hs-
 H'vu-
 HDK HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t/-
 HAH;r-
 H+Hs-
 H'v-
 HJ HHL$`H3QC H$   Hp_@SH H{$ HHH*  H4
 HKHH [H%+
 H\$ WHpH
 H3HD$`3HHAIHH HAH$ HHL$@l  HHL$ L\  HHOL] ٰ  HD$8HrQHL$ HH=   r<t,
 HAH;r+
 H+Hs+
 H'v+
 HI HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t+
 HAH;r+
 H+Hsx+
 H'vk+
 H:I HHL$`H3A H$   Hp_@SH H# HHHd(  H2
 HKHH [H%)
 H\$ WHpH
 H3HD$`3HHAIHF HAHa# HHL$@̮  HHL$ L輫  HHOL6\ 9  HD$8HrQHL$ HH=   r<tk*
 HAH;r[*
 H+HsK*
 H'v>*
 H
H HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t)
 HAH;r)
 H+Hs)
 H'v)
 HG HHL$`H3@ H$   Hp_@SH H1
 HHH&  HE1
 HKHH [H%J(
 H\$ WHpHW
 H3HD$`3HHAIH<E HAH1
 HHL$@,  HHL$ L  HHOLZ 虭  HD$8HrQHL$ HH=   r<t(
 HAH;r(
 H+Hs(
 H'v(
 HmF HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tX(
 HAH;rH(
 H+Hs8(
 H'v+(
 HE HHL$`H3z> H$   Hp_@SH H HHH$%  H/
 HKHH [H%&
 H\$ WHpH
 H3HD$`3HHAIHC HAH! HHL$@茫  HHL$ L|  HHOLX   HD$8HrQHL$ HH=   r<t+'
 HAH;r'
 H+Hs'
 H'v&
 HD HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t&
 HAH;r&
 H+Hs&
 H'v&
 HZD HHL$`H3< H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuHV>  HKHL$@HHHHL$HHt *H;KuH">  HKHL$@HL$HHt	HǓ HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LHq  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH>  HwHtlHHHF   HF     HHHc  C F ;H;OuH=  H_Ht$HC   HHC    H b  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	 HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHXe pMt/HWI HOH+IHHLI?LH<  HNH+IHHHH?HH>  tLHVHd HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LHL<  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   HS<  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   H;  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H3
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+
 H[HI~H+LH
 Ht$0H;H|$8IFIH\$@H A^HtH<  HSIH+H=  t!HH[I>H+LHi
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I?<  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
LQ 
 HH|$0Xq  HHFHHHNI~IHH+LHu
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
P r
 p  HH    HGLH3HHOHG H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXH%
 D$(HD$0HT$83HL$ HD$8HD$@HH HD$ 2
 H	 H
 HD$0HL$0F He%
 D$(HD$0HT$83HL$ HD$8HD$@H9 HD$ 
 HT Hm
 HD$0HL$0tF HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`H$
 D$(HD$0HT$83HL$ HD$8HD$@HG HD$ 
 H H
 HD$0HL$0E H\$WH HHH;Qt>H	y
 HtH  HH{H\$0H _H    H{H\$0H _HyH\$0H _HLHLHALBHBHLA@SH HHHtLAL+IH  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
xM B
 n  HL    HCHHIHKH8 LCHH\$0H _@SH L
 HL II+HH;sH+IH| H [H;   Ln H+II+HH;s\IIH+H;sH
L 
 HM+I3IHL+IM;HCH;HC&n  L
 L ILI+3HIL+IzC H
ӳ HH+ HH+HH H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
K 
 HM+I3IHL+IM;HCH;HCHn  HOLH3H+HL+IB HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH9  HSHt7HHH
HCH\$0H _H;CuHy9  HKHtHHHCH\$0H _@SH HH	Ht@HSV LCH*L+IHLI?LH\2  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LH1  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
8I 
 H)g  HHCHHHHKLHVHY HCHH\$XHt$`H@_H\$WH 3HHHHAHAHtNH
H;vH
H r
 f  HHHCHHL    IHKH脾 LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HQ8  HKHL$@HHHHL$HHtn
  /H;Ku
   H8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHR%  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR襁  HH@HH HH@HC    DD$@HHX  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I'0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I@  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@HU LHD$ HT$@HLH OY HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR腁  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I>  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I6>  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H/>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HI  VH;Cu
   H=  HKHL$@HL$HHt03HA   HAHyrHH  IE3HI  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
;A 
 HM+I3IHL+IM;HCH;HCHp  HOHHH+HH+- HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LII  HSH轸 HGH+HH   HCH+HL;w'HILHI  LCHWHeW LHtIf HLCL+I8  HWH+HH <  tLHWHW HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+IC8  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H:  HKHt@HH;H;Cu
   H:  HKHtHA   HHA     0K  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I`7  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
= 
 Hc  HHCHH;H{LHVHU HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH
:  HSHt3H
HCH\$0H _H;CuH9  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+IL'  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   H9  HSHt<HHH
HCH\$0H _H;Cu
   HO9  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+q
 H[HI~H+LHW
 Ht$0H;H|$8IFIH\$@H A^HtH5  HSIH+H~8  t!HH[I>H+LH
 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
: 
 HH|$0([  HHFHHHNI~IHH+LHE
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
x9 B
 Z  HH    HGLH3HHOHf0 H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   H56  HSHt
HHH
HBHCH\$0H _H;Cu
   H5  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
8 
 HM+I3IHL+IM;HCH;HCHT[  HOLH3H+HL+I. HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+I2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH0HE3HQ(DD$ HC   LCDD8tI IB< uHn=  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH<  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	VS	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ 8=  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
B5 	 H;sLHHf  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<t
 HAH;r|
 H+Hsl
 H'v_
 H.  HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t
 HAH;r
 H+Hs
 H'v
 H HC   HC    H{rHH  HH?  HH\$@H0_@SH E3HA   LAHDD8tIIB< u9  HH [@SH HA   IHA    E3 H:  HH [H\$WH HHK  HH	 tHCh    H\$0H _HH{hH\$0H _H%	 @SH H    Ht'  tH    
 y	H [3H [@SH HMH   Ht9HuMuEAE3O 
 uH   D@HA  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|>  tsH   HT$0	 u]HtH   D@H	 u@H   HT$0	 u*IFHHGtJ>  HOtHD$0HCH    HKH	 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb=  tYHutH   DH	 u8H   HT$0	 u"Ha=  HKtHD$0HGH    HOH	 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   	 tl  d  HE/   E3Lu'DuH   	   HU'HHH  HZH  LM/L;sLHHMx`  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOhn	    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+32  HUH}/r'HHu#E	     	 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   	 H~LEHU]#H
w- )	 H
i- 	 HUHE/HrPHH=   r=Et	 HBH;r
	 H+Hs	 H'v	 HH HM7H3; L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@	 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp HO
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   	 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKh&	       HELELM/IICH}H+t.HMIICL   LǺ   	 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHMm2  3u#MH   n	 ;ELM/LELM/LEIrQIAH=   r=Et	 I@I;r	 L+Is	 I'v	 LI HM7H3<
 L$   I[0Is8IA^_]H   HtH%	 H   HtH%	 @SH0HD$ HH7
 HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H]8  HH0[H%	 @SH0HD$     H:  HH0[H\$WH HhHHcPHI
 H
hHhHcPH
 DhD
dHAH9  HOy	 HOH\$0H _H%	 DL$ HL$SVWH0HD$ HHD$h    H	
 HH
 HAH   V	 D$h   H^E3HH	 HHcHHs
 H1HHcHhT1H\$XH	 H
 HLGHrH?HCh    Cp    MtHH]  HH0_^[DD$HL$WH0HD$ H\$HHD$P    H)
 HH
 HAH   v	 D$P   E3HWH=	 HHcPH
 H:HHcPDhDD:   HO:  HH\$HH0_@SH0HD$     HV8  HH0[H\$WH HxHHcPH
 H
xHxHcPHW
 DxD
tHAH6  HO9	 HOH\$0H _H%	 @SMPHMLLA@I Ht
H9AhsHAhH	 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   HU	 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjH	 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
H/	 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIH>	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH H
 HHHIE	 HO ;	 HO(1	 HH	 t
0   H
 HH\$0H _H\$WH H\t
   H
 HH\$0H _H\$Ht$WH HH	 @t   HhO
 Ht$8HhH\$0H _H\$Ht$WH HHN	 @t   Hx	 Ht$8HxH\$0H _H\$WH H
 HH/  H	 t
x   H	 HH\$0H _H8HD$ HHHcHHLHHt+HHPHH;uH   Htj	 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLHx  H\$ HSH蟕 HHCI  H$   HVHm HHFI  HHGWD$8HD$H    IX  Hl$(HT$8H  ILl$8I;^F  M@  @ HI  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtH	 9	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  H  HGH+HA  MtwHD$HI+HH?H;v	 H    H=   r=At	 IEI;r	 L+Is	 I'v	 LI HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
: 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [4  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
j 4	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [4  H [H(H
L;v	 K@HH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH(n @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _N5  H _H\$WH 3HHHHAHAHt:H
H;vH
 R	 |4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
 	 H3  HHCHHHHKLHVH% HCHH\$XHt$`H@_H(H?L;v_	 J    H=   r<tC	 HBH;r3	 H+Hs#	 H'v	 HHH(  H(LQLLAII+HH;s_H	I?L+III+H;sH
 	 L+II3IHL+IM;HCH;HCIH(#5  H(H\$WH 3HHHHAHAHt6H?H;vH
8 	 L4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHH
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
x B	 IHO UM  H    HHWHL$(HHO %7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wH HH;_s%	 	 	 	 	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;vW	 H    H=   r<t;	 HAH;r+	 H+Hs	 H'v	 H 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
 v	 L+II3IHL+IM;HCH;HCIH(4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
 	 L+HI3IHL+IM;HCH;HCIH(Q4  H(@SH0WH,u        fu I1  LHt HHt HHH
t HЋ HIH
t H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
 	 .  HHCHL4    HIHKHMHH3 I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
< 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _3  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uHp&  AE3c'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AC  3ҋM%  ADp$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH@   AE33!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEU   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ  AD@  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v	 II   r<t	 HBH;r	 H+Hs	 H'v	 HHH( LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRA  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@Hs,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HR7C  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H30  LD$PL;D$XuLHH\$HH0_H(HL;v	 J    H=   r<t	 HBH;r	 H+Hss	 H'vf	 HHH(. H(LQLLAII+HH;s_H	IL+III+H;sH
 	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
 R	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
 	 L+HI3IHL+IM;HCH;HCIH(q#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
| F	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
 	 #  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH| HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
  	 4"  HLHCHHHHKLI} MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHH;uH   Htz	 ҐH8@SH0HD$ H	 u
H*	 HHHcHHLHHt+HHPL
 I;uH   Ht 	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtH\	 HCHH=   r=@t	 HGH;r	 H+Hs	 H'v	 HHL HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALHK	 HHt8Ht!LIH6	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1It	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHH	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ 0  H\$hH0A_A\^HKI;sH

 m	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
 m	 L+H|$XH;s;HCHrHHHrHHMtHMJ HH	 LCIH+HHu	H   HvH
D
 	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HH	 H{rHHHtJ LI	 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH
K
 	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JL	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH
b
 	 HvH
N
  	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L H{H{rHH8 Ht$8HH\$0H _H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH

 	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLH	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
7
 	 I+H;HGH;u9I8H9AsH

 z	 HAHyrH	 3H   HvH
 }	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6L	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH
 	 H|$0I<H   HvH
 	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL_ H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
 M	 H|$0I<0H   HvH
u
 '	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLH	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
 !	 LAH+H;HGIHH;wH
 2	 H|$0I<0H   HvH
Z
 	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.Lf	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBIt	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpHË
 H3HEHHyh   yq   $u2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H

 Ļ	 H

 	 ̳IrNIAH=   r=Et	 HAH;r	 H+Hs	 H'v	 H_ HMH3 L\$pI[(Is0IA^_]@SVWH AAq HHA|	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH`	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXHU HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHD	 HEHC| Cq J	 H
T HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   IĹ	 HtyA   HHHT$(H	 HG  HH	 t
HCh    H{hH	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t	 HAH;r	 H+Hs	 H'v	 H HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPHG
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r~	 H+Hsn	 H'   ]	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(<   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t	 HAH;r	 H+Hsz	 H'vm	 H< HHL$HH3 H\$pHP_@WH0HD$ H\$HH	 H)
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;w6	 X HH'HHAHH(H< HH(H(I   r<tP	 HBH;r@	 H+Hs0	 H'v#	 HHH( Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;vO	 KHH=   r<t3	 HBH;r#	 H+Hs	 H'v	 HHH( H(H88L;vϲ	 KHH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH(N H(Hu	3ɋH(H88H;vٮ	 HHH   r,HA'H;w	 H HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH HH988LKHML+IHHLI?IHt+I\ HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;v}	 HHH   r&HA'H;w\	 H{ HX'HHCh HHVLHHl$@Lt$H HHgfffffffLNHML+ILIMI?MHt+I\ HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;vi	 HRHH   r,HA'H;wH	 Hg HH'HHAHH(N HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH9 HH*LKHML+IHHLI?IHt+I~W HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt莎/H;Ku
   HHKHL$@HL$HHt	H]HCH\$PH0_H(Hu	3ɋH(H?H;vI	 H    H   r,HA'H;w(	 HG HH'HHAHH(. HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;vI	 H    H   r,HA'H;w(	 HG HH'HHAHH(. HH(H\$WH HHu3UHH;vŨ	 H    H   r&HA'H;w	 H HX'HHC HHfE HLdE L+Ht$0>	 HGE H5HE H+HHtL=E L+IHHE HE HHt$0H\$8HE H _H\$Ht$WH HHHu3UHH;vͧ	 H    H   r&HA'H;w	 H HX'HHC HHHLGL+Hl$0M	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+è	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;v]	 HRHH   r&HA'H;w<	 H[ HX'HHCH HHVLHHl$@Lt$Hd HH*LNHML+ILIMI?MHt+IU HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;vI	 HH   r)HJ'H;w,	 N HH'HHAHH(H2 HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;v	 H    H=   r<tˣ	 HAH;r	 H+Hs	 H'v	 Hm HoXHo`HohHO@Ht~HGPH?H+HH;v`	 H    H=   r<tD	 HAH;r4	 H+Hs$	 H'v	 H Ho@HoHHoPHO AH HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;v7	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H轼 HoXHo`HohHO@HttHGPH+HI;v	 H    H=   r<t	 HAH;r	 H+Hs~	 H'vq	 H@ Ho@HoHHoPHO 蛛H# HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHH/ HHWHH+HtHH HLGL+IHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
@
 
	 THLHCHHHHKLIK MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPL
 I;uH   Ht	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;wm	 H荵 Hp'HHFz HH\$`Lt$pH|$hHt$xMtH{rHHMtMH HCHrOHHH=   r<tZ	 HAH;rJ	 H+Hs:	 H'v-	 H HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH
 L	 IALd$XLd$pI;sH
 +	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH
l
 	 Ll$`L+L,9M;sBIvH
G
 	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HH	 H~rH6H{rHHH6  J&LJ0 !  H;suHCHrHHHrHHHtJ!LJ0x	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HHz	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0
	 HCHrHHHrHHMtJ1MJ0HHΕ	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   IvN	 H|$0H   r#IH'H;w0	 R Hx'HHGH< HLHH CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH
j
 4	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHH HH*LKHML+IHHLI?IHt+I^A HKHH+HHLI?LHkHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H衯 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   H# 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   HȮ 3HC   H{HSrHH 襮  HxH\$0Hl$8Ht$@H _	 	 	 	 	 	 {	 t	 m	 f	 _	 X	 Q	 J	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  Hq 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H蘬 3HC   H{HSrHH u  HxH\$0Hl$8Ht$@H _u	 n	 g	 `	 Y	 R	 K	 D	 =	 6	 /	 (	 !	 	 H(p   ʧ HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL-6z
 Ht#HHPI;uH   Ht;	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1H	 tVHڅuVHHcHMIHL1H	 I;u0D  H~/HHcHT1XHL1Ht	 u
Hջ   \$xHHcHHD1(    L-#y
 Ht$p\$xLd$(HHcHHE3@	 	 u
I	 I$HcHJL!HHt#HHPI;uH   Htۊ	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%Bx
 Ht#HHPI;uH   HtG	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1H	 ADމ$   HHHcHAHL1H	 ADމ$   u(H~#HHcHT1XHL1HY	 ADHL%$w
 Ht$p$   L|$(HHcHHD1(    HHcHHE3.	 	 u
I	 IHcHJL9HHt#HHPI;uH   Htʈ	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-v
 Ht#HHPI;uH   Ht 	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1H	 u   \$x7Hυu.I~rM6HHcHMIHL1H	 I;t   +Ht*HHcHT1XHL1HA	 uHՉ\$xHHcHHD1(    L-t
 Ht$p\$xL|$(HHcHHE3	 	 u
I΄	 IHcHJL9HHt#HHPI;uH   Ht	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHH	 H	 HX	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHHJ
 %H H;uIVHNH;HHQS	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HM	 HH
 sHH[H;uIFHMH	 HH	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PHP
 H3HEpMMHHH   D$     H
 HD$`HM	 D$    E3E3HT$hHL$`	 HD$`HcHHm
 HD`HD$`HcHDxDD\   HL$hHHL$`HHW
 JHHoHHe
 0HIUHAi	 HH>HUPHL$` HxrH H
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 Hy
 HD$(HX
 HL$(謭 LSUVWAVH   ICHiO
 H3H$   MIHHH$   IC   IC    D$h A   H
 IK觼HD$`   HD$X    D$H A   Hz
 HL$HxHCH+HLOL+IL;t%HD$0Lt$(HD$hHD$ LHT$HH訊  HD$`HrQHHL$HH=   r<ty	 HAH;ri	 H+HsY	 H'vL	 H HD$`   HD$X    D$H H$   HrQHHL$hH=   r<t	 HAH;r	 H+Hs	 H'vւ	 H襠 H$   H3% HĐ   A^_^][@USVWAVH$PH  HD$@HM
 H3H   ILHDD$8   D$0    H=~
 HD$PHM	 D$0   E3E3HT$XHL$Pg	 HD$PHcHHj
 HDPHD$PHcHxTL   HL$XHô
 HL$PHH*HH
 Hȋ0	 HHn
 H   HL$PH   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@ݹHEx   HEp    E` A   HǮ
 HM`貹HE@HD$ LM`LD$8IHH\$WH 	HHf/v\XH\$0H _\(XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tIHHt3<	 H|a  HLsHsHuH{H|$hL?LHt3	 HHa  HHwHuH~H   H{(H|$hL?LHt3~	 Ha  HHwC< HH貙  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H	[~	 t
H`  HH    Hk~LFHHI H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3HC   HHC    H 	HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHH;uH   Ht4}	 Ґ3Hz	 D$0t/HHcHHLHZ|	 u   |$`	H\$P|$`HHcHHE3y	 HHcHHLHHt*HHPH H;uH   Ht|	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$h  uB3HD$8Hf
 HD$0Hjr
 HD$(Hf
 HD$@Hz
 HD$HHL$(+> HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHHu  ? t
HHÀ< uLHHtIE3HH貹HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLHyz  HC   HHC    H [HH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
t  IE3HHǸA
   H
 HbHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHIHC   HHC    H gHH0[@WH   HD$ H$  AHHH$   0  HX(H
T
 HH0x8HH$   ; HHL$(; H@ HL$(褣 @SH   HD$PH_E
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$( ȋD$ -ut=   w2t=w2ɄuB3HD$8H
 HD$0Hn
 HD$(H
 HD$@H*
 HD$HHL$(s: HL$pH3ŏ HĀ   [@SH   HHD
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`0 u-HT$PHL$XO t9C,+<:wH     HrD$PH$   H3 HĐ   [m  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(  @USVWATAVAWHl$H   HEHB
 H3HEMcIcHLHM3ۉ]ϋ

 eH%X      Hȋ
9-
 ~_H
$
  
 uHHA    H2  DCHɖ
 H
 H
a	  H
 H HE   H]E A   H
 HM趯HE   H]E A   H
 HM華LOL+IAA;tLEHM  HEHrPHHMH=   r<tv	 HAH;rv	 H+Hsv	 H'vv	 HP HE   H]E HEHrPHHMH=   r<tDv	 HAH;r4v	 H+Hs$v	 H'vv	 H H?LIII_I_MtDHEt5HHHL;twEtHHHL;tZMMt3t	 I W  IMwIwH}LuIHMLuHEHEHEHEHEHEL}IHHH+HHH~)HH;}
H}HMLHHM IHMH3u HĐ   A_A^A\_^[]@USVWAVHl$H  HD$@H?
 H3HE IHH蘕  HE   E3LuDuEFHF
 HM1HCDLEHHFHEHrPHHMH=   r<tYt	 HAH;rIt	 H+Hs9t	 H'v,t	 H H{urH f/} waHE   LuE E3H
 HM耬HE   LuE E3H
 HM\HEHD$ LMHHc/ HHM覘  HT$PHv  HMr	 }    E   HL$`HL$0L\$XL\$8HD$0HT$8I;HMHMLD$PW IH~N   If/sEHIH;|II|LHH_  HMr	 HL$pr	 HL$Pq	 aHE   LuE E3H
 HMOHE   LuE E3Hʎ
 HM+HEHD$ LMHH2. HM H3Ո H  A^_^[]@SH LHHuHRAHH [HHRHcHHAHH [@USVWAVH$PH  HD$@H=
 H3H   ILHLD$8   D$0    Hm
 HD$PHMp	 D$0   E3E3HT$XHL$Po	 HD$PHcHHZ
 HDPHD$PHcHxTL   HL$XH3
 HL$PuHHHH
 [Hȋn	 HHޣ
 AH   HL$PP}H   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@MHEx   HEp    E` A   H7
 HM`"HE@HD$ LM`LD$8IH蔖  LSVWH   ICH\;
 H3H$   IHHIC   IC    D$h A   Hf
 IK襨HD$`   HD$X    D$H A#   HH
 HL$HvHCLKL;t%HD$0H|$(HD$hHD$ LHT$HHd  HD$`HrQHHL$HH=   r<to	 HAH;ruo	 H+Hseo	 H'vXo	 H' HD$`   HD$X    D$H H$   HrQHHL$hH=   r<to	 HAH;rn	 H+Hsn	 H'vn	 H豌 H$   H31 HĐ   _^[@UVWATAUAVAWH$@H  HD$8H$  H9
 H3H   MLL3ۉ\$0A   MPM;  EWɋHE~0MNHcI;}$IIIHf.z uHI;|AIIcI;  Hl
 HD$PHi
 HD$`HM;l	 D$0   E3HT$hHL$Pk	 HD$PHcHHVe
 HDPHD$PHcHhTLHD$hHD$@HL$hai	 H`
 HD$hH]Љ]H>
 HL$`HH
 }HIHHĠ
 cHȍVj	 HHm
 HHAWj	 HHՠ
 ,H   HL$PvH   H   HC   Hǅ      3H   @}p@8:uD
IIB8<uHMp;IcHcMINHHIHEh   H}`EP E3H
 HMPHEPHD$ LMpLII# H   H3裂 H$  H  A_A^A]A\_^]@USVWAVH$PH  HD$@H7
 H3H   ILHDD$8H   D$0    Hg
 HD$PHM
j	 D$0   E3E3HT$XHL$Pi	 HD$PHcHHT
 HDPHD$PHcHxTL   HL$XH2
 HL$PtHHHH
 ZHH^g	 HHܝ
 ?H   HL$PNwH   H   HC   HEX   HEP    E@ : uE3I@ IB< uHM@MHEx   HEp    E` A   H7
 HM`"HE@HD$ LM`LD$8IHtH\$WH HIHU	 tHHiHH#	 ZHg	 HHH\$0H _H%g	 H\$WH HIH-	 HH	HH	 H%g	 HH3H\$0H _H%*g	 @SH H	 IHHy
 HHV	 Hf	 HHH [H%f	 H\$WH HIH]	 THHIHH#	 :Hef	 HHsH\$0H _H%jf	 @SH H	 IHHٕ
 HH	 Hf	 HHH [H%f	 @SH H	 IHH
 HH	 }He	 HHH [H%e	 @SH H	 I;HHA
 ,HH	 HHe	 HHVH [H%Re	 @SH HG	 IHH
 HH&	 Hd	 HHH [H%d	 HHHD$0D$    L

 L
 3ƶ 2HHHHHD$0D$    L
ܲ
 L]
 3膶 2HHHHHD$0D$    L
t
 L
 3F 2HHHHHD$0D$    L
<
 L
 3 2HHHHHD$0D$    L
L
 L
 3Ƶ 2HHHHHD$0D$    L

 L]
 3膵 2HHHHHD$0D$    L

 L
 3F 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L
 3ƴ 2HHHHHD$0D$    L

 L]
 3膴 2HHHHHD$0D$    L

 L
 3F 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L

 L
 3Ƴ 2HHN  L  HWATAUAVAWHPH@HXHhHpMLHIPIW I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8Ǔ  Hl$@LH\$8LIT$I*g  HtZHH
 HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HHڀ HII HFH+HH;s(:b	 b	 b	 b	 b	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@Hl-
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`Hi	 H  3H  H  HC	 HEpExH  HMpZ`	 H3Y
 H  H H   H[
 HE@H^	 HEHHEPHEXHK^	 HE`HEhHz
 HEH   4[  H  '[  H  l
   ~y   A   ~x DEHVXHzrHH   E3HH   HcHH   uHAP]	 H3]	 F|uH	 H   Hd	 auH	 H   Hk	 @uH	 H   Hz	 u2H	 H   Hy	 HHH]	 H   Ք H   H膭      H   HzrHA   H  ֢E3HH  HcHH  uHAP[	 H3[	 F|uHw	 H  H	 auH~	 H  H	 @uHu	 H  H	 u2Hl	 H  H	 HuHH\	 H  蹓 H  HjHǅ     E3L  D   EFH߱	 H   臗HoR
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  gH  HrSHH   H=   r<tt^	 HAH;rd^	 H+HsT^	 H'vG^	 H| L   HNHYHyrH	HA   I;LBMtH	 蒭 u1Hu+Klw H   LF8HV(HcHH      w HHT
 HH   WELuAEHUI
HX
 HEWELuAN   D.DvDu~HH
L
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHIa  DGHUHMHD$ IH  薓  HOH:WH  Ht)L  L+IW  Hǅ      HUHtLEL+I載HW
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHI$  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHIf  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHI˪  DHUH   XHM1HQH}LL+X	 HH}H}8HO HUrPw8HUHtLEL+IDH  HtL  L+I$H}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMIHǅ     Hǅ      ƅ   A   H"	 H  貑LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   o LH  UH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHIڸ  D    PHM}HA
   H	 LuI贐IN A   H	 螐IN@A   H	 舐IN`A   H	 rI   A   H	 YHǅ     Hǅ      ƅ   A   H	 H  #LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H    LH  aT    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIu  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIɻ  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI6  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ ES  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  Dq  d  PHMBA
   H	 LuIIN A
   H	 IN@A   H	 Hǅ     Hǅ      ƅp   A   HW	 Hp  跊LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H   t LHp  N          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIe  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$   D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$   DLupEWA(WEHE    DEHUH+UHLEHMD  HMH+M HLM L+MILɋ   ~gfn
 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@B  G HOpHO2  H   HM?HD$ IH    HOHFH  Ht)L  L+I?yW  Hǅ      H   HtL0  L+I
yH  HU
B  H   H  UHǅ     Hǅ      ƅ   A   E3H	 H   %~HEHtTA   LHo	 H   }LEI+LH  H   GHH  HH  WHD   D   A   E3H]	 H   }H  HHEL@A   H>	 H   j}HLLEH  H   FHH  =UH  GH   H  F	 A   LH(	 H    }HL@A   H	 H   |LLGH   H   vFHH  fH   9GH   H  %F	 Hx  THx  G	 H}8H  H  H;tIE3H  aIP  HW  Hǅ      MX  H  ]w HU H W   Hǅ0      LEH   w LM LEH(  H   L  H  H  >  H  H   <:HOXHUp/:MtI   IH   Ht&H(  HA  L0  L+IHsH  Ht=H  HO  H  H+H*HHLI?LHRbH  EH   EHUHtLEL+I^uH}Ht HU H  LE(L+IHrH} HtHUHo  LEL+IHrH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H	 Hp  H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H   | HHEpHp  	DH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    up    DW   E3L0  L   H   H   s H(  H   H+I*IHHHH?HHH  >EL  L  M+IMt ff     HHKIHM;rH}8H  H   ;  H  HU6H  H  ;HOpH4+  HU HM'HD$ IHM{  HOHy?HUHtLEL+I0rWELuHU HtLEL+IrHMpHtH   H  HtL  L+IqH   Ht:H(  HL  H0  H+IHHLI?LHV^E3H}HtH   HHUHtLEL+IaqWELuH5>3
 HuH]HtHH  LEL+IHnHk7
 H@  HP  AH@  Hx  MHx  A	 H  +)  H   )  AH  H3Y L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHHk'3fD  H;_s^I4H
 HHH
 H;~
 r
   :HH$   Ht
(ҙHHHD$8HHMLD$8H$   H$  H$   pH      ?HHH=2
 H
K
 H9
<
 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HIv;HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;vA	 H    H=   r<tqA	 HAH;raA	 H+HsQA	 H'vDA	 H_  (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH%3fD  H;_s^I4HK
 HHH=
 H;.
 r
   HH$   Ht
(肗HHHD$8HHMLD$8H$   H$  H$   pH      ?HHH=
 H

 H9

 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI&9HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v=?	 H    H=   r<t!?	 HAH;r?	 H+Hs?	 H'v>	 H\ 蝂 (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
_p
 );	 HL$8.<  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   `HHL$@LD$8H$   Ht(HHHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8;  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8:  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
sn
 =9	 H
en
 /9	 MLD$8H$   I  H p HL$8Ht{HD$HH+HH;v<	 H    H=   r<t;	 HAH;r;	 H+Hs;	 H'v;	 HY WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
/m
 7	 HL$88  3I9~  HL$@LD$8     I4H
 HHH
 H;t
 r   0HHL$@LD$8H$   Ht(H軑HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$87  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8]7  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
Ck
 
6	 H
5k
 5	 MLD$8H$   I  H p| HL$8Ht{HD$HH+HH;v8	 H    H=   r<t8	 HAH;r8	 H+Hs8	 H'v8	 HeV WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HWATAUAVAWH  HǀHXHp)p)xD)@D)HD)PH$
 H3H$H  ILD$ LHL$(H$  3H_1HFH+HHurH?	 H$  3H$  H$  Hl
 H$  Ƅ$  H$  H$  6	 H.
 H$  H[l
 H$  ~ HD	DL$xHwrH?	 H$  3H$  H$  HHl
 H$  Ƅ$  H$  H$  z5	 HS.
 H$  Hk
 H$   A   DQD$   WD$@E3AH\$PMcN`LL$8ELt$@M%  IHT$H HFH+HL;  IIH4t$0HD$0H;   HD$0L;   Ht$0I+HH;uyHH+HHsiI+HIH+H	  HI+HHHIH+HMH;LCL;ICHL$@PH\$PHT$HLt$@ILL$8HtIHHt$    H;uyHH+HHsiI+HIH+H   HI+HHHIH+HMH;LCL;ICHL$@輊H\$PHT$HLt$@ILL$8Ht2HHT$HIM;   {H
g
 1	 H
f
 1	 H<	 H$  3H$  H$  Hi
 H$  Ƅ$  H$  H$  3	 H+
 H$  Hki
 H$    HFH+HL;rrH.<	 H$  3H$  H$  H]i
 H$  Ƅ$  H$  H$  2	 Hh+
 H$  Hh
 H$    IIH蒃 (EWAX|$8WL$XILd$hHD$(LcP,L$   MLd$pLl$XMN  HT$`LD$ @ I@I+ HL;  IIL$  I 4t$0HD$0H;   HD$0L;   L|$0M+IH;   HH+HHssI+HHHH+H   HI+HHHH+HMH;LCL;ICHL$X=Ht$hHT$`Ll$XLD$ LL$pL$   HtKD HL$     H;   HH+HHssI+HHHH+H   HI+HHHH+HMH;LCL;ICHL$X藇Ht$hHT$`Ll$XLD$ LL$pL$   Ht2HHT$`ILL$pM;   NH
c
 .	 H
c
 .	 H9	 H$  3H$  H$  Hf
 H$  Ƅ$  H$  H$  /	 H(
 H$  H>f
 H$  a  HOHD$xH;   LHD$xL;   L|$xM+ILOI;ukIH+HHs[I+HIIH+HsH
b
 -	 HQM+IIHL+IIM;HCH;HCHHOHHtJHA   L|$ *A   L|$ H;OuAH_HGHtDHGHOH$   H;sUHH$   H;wEH$   H+HH$  H;OuIHU_H$  HOHHt(HHH;OuIH'_HGHtDHGEHD$(D9``~#L IcIH(AE;}`|Ll$XHGHL$8H;sAHHT$8H;w4L|$8L+IH;Gu
   H^HOHHt)JH H;Gu
   H^HGHt8HGEHD$(D9`,~'LIcH    IH'AE;~,|Lt$@$   u8MtI+HLI	\M  I+HLI[  W$   L$   
    HǄ$      L$  Ƅ$   A   H]
 H$  fHǄ$     L$  Ƅ$   A   HF_
 H$  fL|$(EG`EyH$  H$  )H$  ;+H$  -+D$  IcW`W$  L$  L$  H$  V^IH$  L$  I+HH      HtIHH;rIHt     IHH;r=L
 @      HD$ HL$(;A`W  
    HǄ$@     L$8  Ƅ$(   A   H\
 H$(  eHǄ$      L$  Ƅ$   A   Hw\
 H$  VeH\$ LcHL$(HL$(  I  LL$  IHL$@  A7Y0WHǄ$      L$  Ƅ$   A   Hc]
 H$  dL$  IH$  q  0H$  `)H$  R)H$(  D)H\$ H\$PLt$@L$  H
    D;a`}IcIH$AHL$(ြ$       MtL$  M+IIXH$   3Ht#DL+IXW$   H$   Mt I+HLIyXWD$XH|$hMt I+HLITXWD$@H|$PDMtL$  M+II(XH$   H3H+HLXH$H  H3 A L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_LWH`ICI[IsHi H3HD$XHIK3t$ H1HqHqD$    HHD$P   Ht$H@t$8DFH	 HL$8bHD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHWHH;HKHthHA   HqHyrHHH@HCH9Cu
   H<WHKHt(HA   HqHyrHHHT$8  gHC HD$PHrQHHL$8H=   r<t()	 HAH;r)	 H+Hs)	 H'v(	 HF HHL$XH3J? H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUH:L?LLE   HuHI?LuI;   HHMHHM[ HHHMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHE HI;{'	 '	 '	 '	 '	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   HAHOHMPH[HHHMXHt2HGH9Gu
   HAHOHMPHMXHt
HUbHGHMHtiHEH+HI;v&	 H    H=   r<t&	 HAH;r&	 H+Hs&	 H'v&	 H[D H   IH6  HMH+IHHHH?HH
H;v>&	 HRHH=   r=@t!&	 HFH;r&	 H+Hs&	 H'v%	 HHC HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHH  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   HoBHSHt(H
H;Cu
   HIBHCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H}AHSHt(H
H;Cu
   HWAHCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_@WHpHD$ H$   H H3HD$hHH
f.
 zu	P  HD$`   HD$X    D$H A   HW
 HL$H\HD$@   HD$8    D$( A   HhW
 HL$([LLHT$HHL$(  HD$@HrQHHL$(H=   r<t#	 HAH;r	#	 H+Hs"	 H'v"	 H@ HD$@   HD$8    D$( HD$`HrQHHL$HH=   r<t"	 HAH;r"	 H+Hs"	 H'vy"	 HH@ \!r HL$hH38 H$   Hp_H\$Ht$WH IHHH;t HH HHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HH[H H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`	 H5B
 Ht$hH
	 x	 HHEH;xsHHHH   3ۀx$ t	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8H<
 HD$0H
 HD$(H HL$(I H\$hH
 HHRHx6 HL$` 	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$P	 H'
 HD$XH
	 e	 HHFH;xsHHHH   3ۀx$ t	 H;xs
H@HHumH\$XHucHHL$X	 Hu13HD$8H;
 HD$0H
 HD$(H HL$(H H\$XHy
 HHPHd5 HL$P	 HH\$`Ht$hH@_H\$WHPHw H3HD$@HHD$8   HL$ HD$0    ID$  E3XHLD$ HWHx HHD$8H+HHrQHL$ HH=   r<t	 HAH;r	 H+Hs	 H'v	 H< HHL$@H35 H\$`HP_H(Hu3H(HH;w*H\$ H    Hs	 HuHuH\$ H(vv@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0_m t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHR  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHR  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H  H3
 HCPH [HL$SH0HD$ HD$P    EtHV
 HA@H
 HAPD$P   J   H
 HH6
 HCHC@HcHH
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH.#	 HHQ3HHBHK	 H
 HH{3HHDH^H\$HH
 HHOHKHtHPHGHCHGHCG C HJ
 HHp
 HHH\$PHt$XH0_H
 HH@SH HHI0	 HK 	 HH [H%	 HY
 H@SH HH   H`HcPH
 HHHHHcPDHDD#Hhz	 HH [H%+	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3SHo(Hs(H;t<HHRH]HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3RGxCxGyCyG|C|H   H   H;tIE3R                                                  HH\$HHl$PHt$XH0_H\$WH H  H-
 HGPt
X   H5 HH\$0H _@WH0HD$ H\$@HH8
 HH
 HAHI HtHP tHC     Hx	 HHK	 @t
@   Hh5 HH\$@H0_H	HtH   H @UVWAVAWH$@H  HD$8H$  H9 H3H   IILHE3D|$0AA fAn	ff/rHHrY  H
 HD$PH
 HD$`HM	 D$0   E3HT$hHL$P	 HD$PHcHH5
 HDPHD$PHcHhTLHD$hHD$@HL$h@	 Hh	
 HD$hL}D}H\J
 HL$`jHL$`	 H   HL$P, H   H   HC   HEh   L}`EP : uMIfD  IB< uHMPmNHǅ      L   Ep A   HI
 HMp@NHEPHD$ LMpLIHd  H   H3+ H$  H  A_A^_^]@UVWAVAWH$@H  HD$8H$  H9 H3H   IILHE3D|$0AA	A;|HHrU  H
 HD$PH
 HD$`HM&	 D$0   E3HT$hHL$P	 HD$PHcHHA
 HDPHD$PHcHhTLHD$hHD$@HL$hL	 Ht
 HD$hL}D}HhH
 HL$`vHL$`	 H   HL$P8H   H   HC   HEh   L}`EP : uMIfIB< uHMP}LHǅ      L   Ep A   HG
 HMpPLHEPHD$ LMpLIH  H   H3) H$  H  A_A^_^]@UVWH   HD$8H$   HU H3H$   IHH3IHIPHHH   M II           HcAD$0HD$0I#I;wHHHH;r   HD$X   HD$P    D$@ A   HF
 HL$@2KHD$x   HD$p    D$` A   HF
 HL$`KHD$@HD$(HD$`HD$ LLHH  H$   H3( H$   HĐ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   III       HcD$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HE
 HL$@IHD$x   HD$p    D$` A   HuE
 HL$`IHD$@HD$(HD$`HD$ LLHHe  H$   H3d' H$   HĐ   _^]@SVWH   HD$0H H3HD$xIHHA8 |HD$P   HD$H    D$8 A   HD
 HL$8 IHD$p   HD$h    D$X A   HD
 HL$XHHD$8HD$ LL$XLHHS  HL$xH3& HĀ   _^[@UVWH   HD$0H$   H H3HD$xIHH3IHH   IW    Hcf/v
HH;r   HD$P   HD$H    D$8 A   HC
 HL$8HHD$p   HD$h    D$X A   HC
 HL$XGHD$8HD$(HD$XHD$ LLHH肿  HL$xH3% H$   HĀ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   II      @ f     HcD$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HB
 HL$@FHD$x   HD$p    D$` A   HeB
 HL$`FHD$@HD$(HD$`HD$ LLHHU  H$   H3T$ H$   HĐ   _^]@SH0HD$ HHG	 HH
 HAHI HtHP tHC     H_	 HHKH0[H%d	 @SVWH   HD$8Hm H3H$   IHHA D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   H9A
 HL$@EHD$x   HD$p    D$` A   HA
 HL$`XEHD$@HD$ LL$`LHHz  H$   H3" HĐ   _^[LH   ICAC    HQH	 ICHX 
 ICAC   IKH,
 HD$(H'
 HD$@HD$hHcHH#
 HDhHD$hHcHDd    H HL$(5 @SH0HD$ HٹX   |% HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHo
 HHM&
 HAHA@HcPHj
 HD
@HA@HcPDBDD
<H	 HH
 HAHI HtHP tHC     H	 HHKH0[H%		 @SH0HD$ HH/	 HH
 HAHI HtHP tHC     Ho	 HHKH0[H%t		 HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	ַ  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFII薻  HWHj  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI(  LGHVHK pMt/HWI  HOH+IHHLI?LH"HNH+IHHHH?HH$tLHVHLK HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+Hv7HH+HH4H+H[7HOHHLH+HH+菶  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   P! HH$   LCMu	H#
 
IP(HuIP0HL$(K	 HǄ$      3Hz	 H	 HHH4  H>HL$(	    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
8
 	 H;s/LHjHtH{HsrH3 H\$0Ht$8H _HsH;LƲLBz8HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    H
 HH	 HAH   W	 D$H   H_E3HH	 HHcHHd	 H9HHcHHT9H\$PH	 H	 HC| Cq H}	 Hǃ       HÜ
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH	 HH
 HAHI HtHP tHC     H	 HHK	 @t
@   H" HH\$@H0_H\$WH HHHUt
  H" HH\$0H _@SH HH		 HKH [H%	 LHXICLI@I+ HHQH;rQH	 IC3ICICHV9
 ICD$0ISIK	 Hp	 HD$8H8
 HL$8  HBHAI HXDD$HL$WH0HD$ H\$HHt$XHH3t$PH	 HA@H	 HAPD$P   H	 HHOHi
 HHG@HcPH	 HD:@HG@HcPDBDD:<HSHHD!=HH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H		 HtHLHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
j4
 4 L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HH!UHSLHH蟷 HH{H+HHtLCL+I.HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
(3
  H|$@K<H   HvH
3
  H9{s#HHbdH   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0 H{rHHHtLHO H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%( HWAVAWH   HD$(HXHp H H3H$   LLHL$ H HT$0I 3IFIF IF(HT$`I H

   IFI HHHHǀ<8 uHǺ   Hs HHu HHtHRHvHuIN I- HHÀ< uHú   H  HHu HHtff     HIHHuIV(fAF.,H$   H3 L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
0
  LAI+H|$8H|$PH;HGIHH;wH
N0
   Ht$0I48H  HvH
(0
  H9qs HaH   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8 I;u>HKI?MIDHrHHHrHHHt8HL *I~rM6H{rHHHtK>LL H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HH HH0[@SH HHHSH
q	 H3H
HJHH 3HC HC(HC0H	 C8HH	 HCHH [@SH0HD$      HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH
-
  I4L+IIHH+I3I;HCH;HCHt$@HSLHD$8HD$0LHT$xHH HD$0LH$   H$   D HD$0LHWHL$xH HWHHH+HHHt藥  HLGL+I%HIHwHIH_L7%IHND HHWLHL$xX H_H\$pHPA^_^@SUVWH  HD$8H H3H$  IIHHI@I+ HL;A  HL$@Hg0
 HL$PmlHH HH0
 RlHH/
 ClHHy/
 4lHH:/
 %lH$  HL$@H$  H$  HC$  HǄ$X     3H$P  @$@  @8:uD
IIB8<uH$@  &2HǄ$x     H$p  Ƅ$`   A   H/
 H$`  1HCH+HHD$0H$@  HD$ L$`  LD$0HHɠ H$  H3x Hĸ  _^][@USVWATAUAVAWH$H  HD$@H H3H  IHLLL$8LP  LX  L`  3ۉ\$0Hz	 HD$PHM D$0   E3E3HT$XHL$P HD$PHcHH	 HDPHD$PHcHDxDDLSHL$X>HHL$PvnHHknH  HL$PJH	 HE@H   A D$0   E3E3HUHHM@ HE@HcHHL	 HD
@HE@HcHDxDD
<SHMHO>Hk*
 HM@iHImHImHH>*
 iHI HH*
 niH  HM@~H  H  HC  HǅH     H@  0  8uDIIB< uH0  z/Hǅh     H`  ƅP   A   H_$
 HP  G/H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  .H0  HD$ LP  LD$8Hp  Iݝ Hx)t$`()|$PD)D$@D0
 D)L$0D
 fD/D)T$ EWA(r`A(\(E (\f/
]
 vAXfA.zu ߘ
  !      =<
 Y(dE ^fA.ztf/5ӗ
 r
(豩 O
ז
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(Ъ X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PHп H3HEpMMHHH   D$     H	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h:HHL$`yjHHG
 :fHH_jHHU
  fHIEjHAY HH.jHUPHL$` HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H	 HD$(H HL$( @SH`W)t$Pf/D)D$0D(   u+DW/
 3A(W
 (t$PD(D$0H`[
 fA/DW
 A(v(
a
 \((t$PD(D$0H`[3bX
 (t$PD(D$0H`[5A
 fA/)|$@D)L$ D
 !  ґ
 fA/vTfD.z  Dk
 eH%X      HЋ95
   %
 AYDYy
 AX  j
 eH%X      HЋ9އ
 
  A(AY(Y((Y%
 (Y
O}
 Y
 X%
 X
'}
 Xׂ
 YYY}
 X%
 X
|
 YX|
 XYX^X%
 AY  3t
ۓ
 i
 fA/  j
 eH%X   =
 fA/   HЋ   9
   A(A(\AYW
 (Y@ ((Yz
 (Yz
 (Y
w
 Xz
 Xz
 A^X
v
 YYYXaz
 X
v
 YYX(Yv
 X
v
 X*z
 Xv
 YXnv
 YX^X
 Y  
 fA/   9
 '  A(A(\AYW
 (Y? ((Yv
 (Yv
 (Y
z
 Xv
 Xv
 A^X
M
 YYYXv
 X
!
 YYX(Y"
 XRv
 X
 YXX

 ^X
 Y  
 fA/   9
   A(A(\5Ɛ
 AY(W
 Y> ((Yx
 (Yx
 (Y
|
 Xx
 Xrx
 A^X
{
 YYYXIx
 X
{
 YYX(Y{
 Xx
 X{
 YXX
j{
 ^X
 Y   9{
 Z  A(A(A^AY(YW
 = ((YV|
 (YC|
 (Y
|
 X(|
 X|
 A^X
|
 YYYX{
 X{
 X
O|
 YYYX{
 X
#|
 X(Y<|
 X$|
 YX|
 YX^X$
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H

  =
 
 H

 u
  H
Ă
 K =
 (
 H

 (

 }
 &
 }
 (
 x
 @
 
}
 (
 w
 
w
 z qH

  =
 V(y
 H
Ҁ
 (

 v
 (ݐ
 v
 (
 
 v
 (
 Br
 
 
#r
 (

 Dr
 
-r
  H
ԁ
 ; =ȁ
 (K
 H

 (

 r
 (
 
r
 (
!
 r
 (ӑ
 

 (
e
 
 

 n [H

  =
 .(m
 H

 (
 t
 (
 
t
 (
 t
 (
 
x
 (
 x
 
x
  H

 ? =
 (
 H

 (
ї
 x
 (
 x
 L
 x
 (
 
x
 (
g
 y
 p
 
x
 (
 y
 
x
 R @USVWATAUAVAWH$H  HD$@H, H3H  IHLLL$8LP  LX  L`  3ۉ\$0H	 HD$PHM+ D$0   E3E3HT$XHL$P HD$PHcHH3	 HDPHD$PHcHDxDDLSHL$X40HHL$P_HH_H  HL$PH2	 HE@H    D$0   E3E3HUHHM@\ HE@HcHH	 HD
@HE@HcHDxDD
<SHMH/H
 HM@ZHI#_HI_HH
 ZHI HH[
 ZH  HM@H  H  HC  HǅH     H@  0  8uDIIB< uH0   Hǅh     H`  ƅP   A   H
 HP   H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  E H0  HD$ LP  LD$8Hp  I
  @USVWAVAWH$xH  HD$PH` H3HEpIMHHL   D$     H	 HD$`HMp D$    E3E3HT$hHL$`9 HD$`HcHHx	 HD`HD$`HcHDxDD\   HL$hw-HHL$`	]HH
 XHH\HH
 XHH\IHuHF
 HXIH IH\HUPHL$`HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@x H1	 HD$(H}w HL$( DD$USVWAUAWHl$H   LjLy3HHM;otI Mt
III7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH' Mt
IbHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMXK HIH HHGHGHtHl    H_
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM
 w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH? Mt
IzHH7LEwH_HUoLwHJx H}HEHHMLwH]LuHEvP W(f.z
u5
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]Lu辷 IUHO(LG(IH HW(H|$ I聟 G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM\ ($   L$   HL$   fG<Hĸ   A_A]_^[]F:@:::@SH HHHSH
A H3H
HJHH 3HC HC(HC0H	 C8HHe HCHH [LHXIC3ICH	 ICH!	 ICHC
 ICH#
 ICIK @USVWH$HH  HD$@Hī H3H   IIHT$8D$0    Hv	 HD$PHM D$0   E3E3HT$XHL$P HD$PHcHH	 HDPHD$PHcHDxDDL   HL$X&H
 HL$P<RHHaVHH
 "RHHV HH
 RH   HL$PH   H   HC   HEX   HEP    E@ : uE3IIB< uHM@HEx   HEp    E` A   H
 HM`HE@HD$ LM`LD$8HH
v
 <Y@UVWATAUAVAWH$0H  HD$XH$(  H H3H  IH\$@HHT$8HL$HE3Dd$0anLKI  EM  
 ~
     M]MM;}UHN    IIIHIIIL@ f     A \Tf/rIHMM;|MM;  H
	 HD$`HMk D$0   E3E3HT$hHL$`4 HD$`HcHHs	 HD`HD$`HcHxT\HD$hHD$PHL$h H	 HD$hLeE   H
 HL$`OHHSHH
 OHIU HH
 OHIW HH8
 cOH  HL$`rH
	 HEPH   i D$0   E3E3HUXHMP4 HEPHcHHt	 HD
PHEPHcHxT
LHEXHD$PHMX H	 HEXL   ǅ      H;H[IIH$
 HMPNHHT$8RHH
 NHIW HH
 oNHIUr HH(
 SNH} H  HMPUH  H  HC  HǅX     LP  ƅ@   : uMIfD  IB< uH@  JH  H  HC  Hǅx     Lp  ƅ`   : tIIB<" uMH`  HD$@L H@IIMH@  HD$ L`  HT$8HL$H  H  H3} H$(  H  A_A^A]A\_^]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;t13IHHt3 HԻHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     Ho	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$hHHL$`iOHH7	 *KHHOOHHE	 KHI5OHI	 HHOHUPHL$` HxrH H
v HL$(3HL$0HL$8HD$@D$HHT$0HL$@ Hd	 HD$(H8c HL$( HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH	 HEL%	 LeH	 HEHJ	 HEL5	 LuD$    L-	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH] HE3HEHEHUHM H	 HD$0H	 HEHEHcHHB	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP H^	 HD$@H]	 HD$HE   
TO
 eH%X   A   HȾ   A9j
 Z  H
j
  =j
 A  NW LHEwH	 IF@H&	 IFPD$    HT$0IE  H>	 IH	 IF(IF@HcHHѾ	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw<o HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHME-l
 fsfH~HtBHMH
  H
Vi
  L5	 k
 8l
 fsfH~HtpH	 HD$0H	 HEHEHcHH	 HD
HEHcHQT
Ld$0H^ H]HMh Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM- LmHMHtHR Hzk
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH	 HEL%0	 LeH	 HEH	 HEL5	 LuD$    L-D	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH
 HE3HEHEHUHM H	 HD$0H	 HEHEHcHH"	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP HZ	 HD$@HRZ	 HD$HE   
K
 eH%X   A   HȾ   A9Rh
 Z  H
Eh
 X =9h
 A  NW LHEwH9	 IF@H	 IFPD$    HT$0Iţ  H~	 IH	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMwLk HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHMYEMj
 fsfH~HtBHMH
 z H
f
  L5	 j
 i
 fsfH~HtpHU	 HD$0Hy	 HEHEHcHH	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR HRh
 H$H  H   A_A^A]A\_^]@UVWATAUAVAWH$pH  HD$HH$  H H3H   MHHHL$(3Dt$ IPIy  IIFHCH+HsHI聾[  WD$0Ht$@HHM`肯HT$0H蕐 L|$0ILd$8M;  H	 H
	 HL$`HT$pHM- ADl$ E3HT$xHL$` HD$`HcHHG	 HD`HD$`HcHhT\HD$xHD$PHL$xR Hz	 HD$xHuuHHL$pDHH)	 r@HsH+3H3Ht(HHL$p HH)	 ?@HH;rHHL$pf HH)	 @HU`HL$`HIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICIR/HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICI.IvHtrHF   3HNH~rHHƈHsLGItHH
 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM] HI;t(H|$(39H
1	  H
#	  Mt6II|t  HL$@I+H*HHLI?LIH   H32 H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHMHHMWE3H]Ll$8H|$0\$(L$ LMMHHMW HE   H]]DCHDQ	 HMHHUHP HEHrPHHMH=   r<t( HAH;r H+Hs H'v H L|$8H|$0Lt$(EwD$ ]oLEHUHۡ HUHt LEL+IWEHE    HUHtLEL+IHMH3 H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   H蔐HT$PHtLD$`L+IXHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xH H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`HHL$dW$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$xF H$  L$   HT$xI" (D$@IH$  IPH$x  ZH$x  , E3|$@L$   L$   Ld$pH|$hH$  yH	Q	 H$  8H(  IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   H<Q	 H$  H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$H'HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH
I	  HQM+IIHL+IIM;HCH;HCHL$H 'HL$PHt0HA   LqHyrHHH$    ;HL$PH HL$PH$   AEHT$HIwI$H
	 H;tHT$HIP A$     D
Wp
 Dc
 $     W$  L$  H$  D$0D$(H$  HD$ LD$xI躋H$   H$  HXH$   4HtIH$  IPHD$@HD$ A   L$  HT$pH$  tA I$L@H
	 H$  H;uIL$ιIAАH$x  H$x  z H$  HtL$  L+Ix|$@HHHH;tHD(L$   HT$xIҳ (D$@H$      H$    HHM	 H$   4HHuI
H HcHHHW
   H$   i HƋH HH	 4HHPM	 4HHuI
H HcHHHW(A\(H HH M	 S4H( HH1	 84IH$   IPATH$x  &H$x   fD/s;$  H|$haW$  L$  H$  >D$0D$(H$  HD$ LD$xI)H$   H$  tHXH$   裾HtIH$  IPHD$@HD$ A   L$  HT$pH$  > I$L@H
$	 H$  H;uIL$=IAАH$x  H$x   H$  HtL$  L+IHL$HHt.HT$P"k  LD$XHT$HL+IlWD$HLt$XH$x  H$x  s HT$xHt%L$   L+ItWD$xL$   H$   HtL$   L+I3H$   H3` L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xH H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$` H  2H  H  1 H  HUH   ֞H  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#35 HuHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  [ H      	    	    	    	     	    Hc(	  H  8  =i
 Wt$XH  HH	 H   /H(L IH  IPWD$@Ll$PHǅ     L  ƅ   A   HG	 H  4H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
1	  HQM+IIHL+IIM;HCH;HCHL$@HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
}	 G HQM+IIHL+IIM;HCH;HCHL$@4HL$HHt/HA   LiHyrHHH    pHL$HH HL$HH  6AEHT$@HRmIH
	 H;tHT$@IP 0	  @   WELmH  0D$0D$(HEHD$ LD$`HH  H  lHXH  蜷HtIH  IPHD$XHD$ A   LEHUHM7 IL@H
(	 HUH;uIOFIAАH(  !H(   HUHtLEL+IH
#Lc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HD	 H  IH  IP H  iH    D8  Wt$XH  HL$`h3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HM5 HH	 H   w*HHu3
H HcHHHWHH HHq	 @*   HMٴ HH	 H   *HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HH1	 )H(  l\ (YH     HM: HH\	 H   |)HHu3
H HcHHHW   HM	 LHu3
HHcHHIPA(H` HH	 )   HM( HH4	 H   (HHu3
H HcHHHW   HM8 LHu3
HHcHHIPAH  `[ (H̳ HH	 (
   HMH HH	 H   `(HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H? HHQ	 '
   HMh HHc	 H   'HHu3
H HcHHHW   HMx` LHu3
HHcHHIPAX  H HH	 k'HP     HM HH	 H   ?'HHu3
H HcHHHWHHW HH	 'H%	 H   &HHh  +HH	 &IH   IPH(  ʾH(   0	  HuH  H  oHXH  蟱H   IH  IPHǅ     3H    E3HG H  H  H  H  HC  H  L  Mt
H  H  @  W  H  H  /D$0D$(H  HD$ LD$`H{H  H  hHXH  蘰HtIH  IPHD$XHD$ A   L  HUH  0 IL@H
	 H  H;uIO9IAАH(  H(   H  HtL  L+IEH

@
  W  3H  H  D$0D$(H  HD$ LD$`HyH  H  GHXH  wHtIH  IPHD$XHD$ A   L  HUH  / IL@H
	 H  H;uIOIAАH(  H(  Ư H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H<	 IH  IP H  }5A$   H<	 IH  IP H  IF   EH  u  LH>	 H  4MHIAP H  H  HL$@Ht.HT$H![  LD$PHT$@L+IkWD$@H|$PH(  衺H(  t H  g  H    H(  nH(  A HT$`HtLD$pL+IEWD$`H|$pHUHtLEL+InH`  H3= L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xHz H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`_v H  H  H   H  HUH   趎H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3 HUHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  K H Hc	  H    	    (	    0	    8	    @	    H	    HcP	  H  8  =X
 Wt$XH  qH8	 H  H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   H8	 H  H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	 Ȩ HQM+IIHL+IIM;HCH;HCHL$@
HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
J	  HQM+IIHL+IIM;HCH;HCHL$@
HL$HHt/HA   LiHyrHHH    =HL$HH HL$HH  AEHT$@H]IH
	 H;tHT$@IP X	  @   WELmH  D$0D$(HEHD$ LD$`HqH  H  9HXH  iHtIH  IPHD$XHD$ A   LEHUHM' IL@H
	 HUH;uIOIAАH(  H(   HUHtLEL+IH
Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   Hc5	 H  IH  IP H  9H    D8  Wt$XH  HL$`83H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HM HHG	 H   GHHu3
H HcHHHWHH_ HH
	    HM HH+	 H   HHu3
H HcHHHW   HMx LHu3
HHcHHIPA(HϤ HH
	 H(  <L (YH     HM
 HH	 H   LHHu3
H HcHHHW   HM٣ LHu3
HHcHHIPA(H0 HHJ
	    HM( HH	 H   HHu3
H HcHHHW   HM8Q LHu3
HHcHHIPAH  0K (H HH	 U
   HMH HH	 H   0HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H HH	 
   HMha HH{	 H   HHu3
H HcHHHW   HMx0 LHu3
HHcHHIPAX  H HH	 ;Hp     HM͡ HH?	 H   HHu3
H HcHHHWHH' HH	 H	 H   HHh  HH	 IH   IPH(  蚮H(  m X	  HuH  H  ?HXH  oH   IH  IPHǅ     3H    E3H H  vH  iH  H  HC  H  L  Mt
H  H  ֠@  W  H  H  D$0D$(H  HD$ LD$`HjH  H  8HXH  hHtIH  IPHD$XHD$ A   L  HUH    IL@H
	 H  H;uIO	IAАH(  H(   H  HtL  L+IEH
@
  W  3H  H  ޭD$0D$(H  HD$ LD$`HiH  H  HXH  GHtIH  IPHD$XHD$ A   L  HUH   IL@H
͜	 H  H;uIOIAАH(  ëH(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   HH-	 IH  IP H  M5A$   H-	 IH  IP H  F   EH  E  LH&	 H  ^$MHIAP H  ӝH  ƝHL$@Ht.HT$HJ  LD$PHT$@L+I;WD$@H|$PH(  qH(  D H  7s  H  s  H(  >H(   HT$`HtLD$pL+IWD$`H|$pHUHtLEL+I>H  H3
 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pHHL$tWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHMXf H	 H   H   HuH   HEL}HEHHUH+HWEHt!3P HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%	 LeH1HEH]LL+tHHA WED$xHE    HL$x$HT$xH   H   PAEHT$xIOHHT$xHP HL$xHt|HUG  HEHL$xH+HHH;v HH=   r<t HAH;r H+Hs H'v؜ H觺 Ld$xHM)~HEHMHMHULL+tH4 EEfEML   HT$xHM>  L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H     +fn^5>
 LM(W)LM(W)(WHMs.LeHMܚ HҚ H"	 H   HMHtsHEH+HHH;vz H    H=   r<t^ HAH;rN H+Hs> H'v1 H  3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHHbH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH蠖 H$   1L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHaH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHN H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHH^H$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH H$   AL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH]H$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHN H$   L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   THH   eWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$p[ H	 HEWHM+H	 HEH!}	 HEH}Hz	 HEH   HEH   HE(y9
 )E (
7
 )ME        66
 E(E0    E4 WE8H	 HE   f/vM   f/vJ4
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM7 H	 HEH	 HEHM HM HM Hۃ	 HEHT$pHtLEL+I}3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   VHH  gW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$pX H	 HEWHM(H 	 HEHz	 HEH}Hw	 HEH   HEH   HE(u6
 )E (
4
 )ME        23
 E(E0    E4 Wu8EH Hw	 HEP0
 Ex(
6
 )   2
    uXW)E`Hx	 HEH5w	 Hu@P  f/vE=1
 X  f/vf/vM`  OȉM$Yi Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMI Hu@H-~	 HEH"	 HEHM܍ HMҍ HMȍ H	 HEHT$pHtLEL+I軻3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHUVH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH輦 H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHUH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHz H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHH%RH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHPH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH芰 H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   贮HH   ŪWEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$p#O Hk	 HEWHMkHd	 HEHp	 HEH}HBn	 HEH   HEH   HE(,
 )E (
*
 )M(
 ] WM0E(
   Hf	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM蘖 Hk	 HEHE	 HEHM HM HM H<w	 HEHT$pHtLEL+I޲3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   跫HH  ȧW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$p L Hh|	 HEWHMhHa	 HEH~m	 HEH}H?k	 HEH   HEH   HE()
 )E (
'
 )M=$
 } Wu0E(
   E@ HXk	 HEH(E)
 )Ep(
+
 )   W)EPu`HXs	 HEH5v	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
%
 ( Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMɯ Hu8H
h	 HEH}	 HEHML HMB HM8 Hs	 HEHT$pHtLEL+I+3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pHL H3HE AALL   L   H   L  H  HEI}k   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pHHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHMH WD$XH|$hHE   H}@} DGHX
	 HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	 | HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
i	 3| HQM+IIHL+IHM;HCH;HCHL$X HL$`Ht,HA   HyHyrHHHU   _HL$`H HL$`HEHrPHHM H=   r<t~ HAH;r~ H+Hs~ H'v~ Hg AEHT$XI0IHT$XIP H}H]H+HWD$xHt3h} H_HHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHM	]  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM`  HL$xJ| HL$XHt2HT$`'  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I3HM H3- H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHxG H3HE AALL   L   H   L  H  HEIMf   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$p΢HHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHMZC WD$XH|$hHE   H}@} DGH0	 HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	 w HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
9	 w HQM+IIHL+IHM;HCH;HCHL$XHL$`Ht,HA   HyHyrHHHU   /HL$`H HL$`HEHrPHHM H=   r<ty HAH;ry H+Hsuy H'vhy H7 AEHT$XI+IHT$XIP H}H]H+HWD$xHt38x HxZHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHMx    D$8   D$0   D$(   D$ LL$pLD$xIHMW  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM^N  HL$xw HL$XHt2HT$`m"  LD$hHT$XL+I跢WD$XHD$h    HUHtLEL+Iܤ3HM H3 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH   HǀHXHp )pHGB H3H$   MMH$   LH

 HHH

 H;

 r   [HH

 HL$hHt

 H3Hn

 3HHHZ

 H;K

 r
   HHL$hWHt
(HHW$   H$   L$   L$(  H$0  H$8  H$   HT$ H$   艜  HD$ H$   H$   HT$ H$   b  HD$ H$   WD$PHt$`IcE`HD$0IHt$I;v
H
ӧ	 r HHL$PsHD$0L     H$   L;`  HT$   HD$ HL$XLD$PH;   HD$ L;   Lt$ M+ILL$`I;uoIH+HHs_I+HIH+Hs
H
/	 q HQM+IIHIH+ILI;LCL;ICHL$PrHL$XLD$PH   K~LL$`I;ujIH+HHsZI+HIH+Hs
H
	 qq HQM+IIHIH+ILI;LCL;ICHL$PLrHL$XHt
HD$ HHL$XHHL$XIHD$0H$   HT$(}  HHD$ H

 LH(H

 H;

 r(   ]LHL$ Lt$hMt*L9AOXKII^M~ H6l	 ILLt$hHT$ HL$0(HHL$ HD$ H$   WD$8Ht$HMc},MtM;v
H
j	 4p IHL$87qL@ M;  HT$ H$   腙  HD$ HL$@H;   HD$ LD$8L;   H\$ I+HLL$HI;uoIH+HHs_I+HIH+Hs
H
Ϥ	 o HQM+IIHIH+ILI;LCL;ICHL$8tpHL$@LD$8Ht.I H;L$HuHL$8oHL$@Ht
HD$ HHL$@HHL$@I    HǄ$X     H$P  Ƅ$@   A   H	 H$@  薪HǄ$8     H$0  Ƅ$    A   H	 H$   _EE`EyH$@  H$   H$   nH$@  nIcU`HL$pUHLD$xIHL$pH+HHt)f     H<HLD$xIHL$pH+HH;rHL+IMtH<HHD$xHL$pH+HH;ru    A   5
 E;u`L  S    HǄ$x     H$p  Ƅ$`   A   Hb	 H$`  AHǄ$X     H$P  Ƅ$@   A   H	 H$@  
HǄ$8     H$0  Ƅ$    A   H\	 H$   ӨIcL$`  HHL$Pj  LI   L$@  HP  WMHL$(LL$   HHL$p$  HIHH$   mH$@   mH$`  lAHL$p A;]`   HcH<    H$  {H3	 H$   [HHl ]HH$  H$  2yHxrH H
v H$   3H$   H$   H$@  Ƅ$H  H$   H$@  Pm H)f	 H$   H H$        HǄ$X     H$P  Ƅ$@   A   H"	 H$@  HǄ$x     H$p  Ƅ$`   A   H	 H$`  ΦEE(EyH$@  H$`  ?H$`  QkH$@  CkIcU(H$   BRHL$(  IH$   H+HHt&H<HL$(  IH$   H+HH;rHL+IMt-ff     H<HH$(  H$   H+HH;r "   D$0   t$ LL$0LD$ H$   HL$(苜 HT$(H$      #   D$    t$0LL$ LD$0H$   HL$(G HT$(H$   e  G $   t$ M   LD$ HT$PHL$( HT$(H$   *   %   (
 D$(t$ LL$(LD$ H$   HL$0 HT$0H$     &   t$ M   LD$ HT$8HL$( HT$(H$    A   E;u(  w *   HǄ$     H$  Ƅ$   A   Hv	 H$  eHǄ$     H$  Ƅ$   A   HS	 H$  .HǄ$     H$  Ƅ$   A   H	 H$  HǄ$     H$  Ƅ$   A   H	 H$  HǄ$x     H$p  Ƅ$`   A   H	 H$`  艣IcI   L$  H^ LD$8HHL$  HD$(L$  HIMh3 LD$pHHL$0 L$   HH$   LIM0L$  H  LL$  HIMhۜ LD$PHH$   膞 L$   HH$   AHH$   yMHH$   LD$(HH$@  HL$`  HH$     HHHH$`   gH$  fH$  fH$  fH$  fAa ,   IUHL$   L$   HL$(H HT$(H$    H$   HtL$0  L+ITHT$pHt%L$   L+I5WD$pH$   HT$8HtLD$HL+I	WD$8Ht$HHT$PHtLD$`L+IHT$hH$    H$   H$   HH$   HtL$   L+I蓕HH$   H3~ L$   I[@IsHA(sIA_A^A]A\_HWATAUAVAWH   HǀHXHp )pH2 H3H$   IMH$   LHl HHH^ H;O r   HHA H$   Ht

 藾H3H 3HHH H; r
   贶HH$   WHt
(IHH$   W$   H$   L$   H$(  H$0  H$8  H$   HT$ H$   .  HD$ H$   H$   HT$ H$     HD$ H$   WD$PH|$`Mce`IMtM;v
H
}	 Gc IHL$PJdL    H$   M;[  HT$ 蕌  HD$ HL$XLD$PH;   HD$ L;   Ht$ I+HLL$`I;uoIH+HHs_I+HIH+Hs
H
ߗ	 b HQM+IIHIH+ILI;LCL;ICHL$PcHL$XLD$PH   I~LL$`I;ujIH+HHsZI+HIH+Hs
H
W	 !b HQM+IIHIH+ILI;LCL;ICHL$PbHL$XHt
HD$ HHL$XHHL$XIH$   HT$(2  HHL$0(HHL$ HD$ H$   WD$8H|$HMce,MtM;v
H
	 _a IHL$8bbLM;   HT$ H$   贊  HD$ HL$@H;sAHT$ HD$8H;w2Ht$ H+HH;L$HuHL$8yaHL$@HD$8Ht.H H;L$HuHL$8SaHL$@Ht
HD$ HHL$@HHL$@I\=    HǄ$X     H$P  Ƅ$@   A   H,	 H$@  +HǄ$8     H$0  Ƅ$    A   H}	 H$   EE`EyH$@  H$   eH$   w`H$@  i`IcU`HL$hkGHLD$pIHL$hH+HHt.@ ff     HHLD$pIHL$hH+HH;rHL+IMtHHHD$pHL$hH+HH;r    A   5{
 E;u`L      HǄ$x     H$p  Ƅ$`   A   H	 H$`  њHǄ$X     H$P  Ƅ$@   A   H	 H$@  蚚HǄ$8     H$0  Ƅ$    A   H	 H$   cIcL$`  HHL$P  LI   L$@  H  WMHL$(LL$   HHL$h  HIHH$   ^H$@  ^H$`  ^AHL$h A;u`   HcH<    H$  lH×	 H$   [H,HQ^ ]HH$  H$  jHxrH H
xh H$   3H$   H$   H$@  Ƅ$H  H$   H$@  ^ HW	 H$   Hj H$   s     HǄ$X     H$P  Ƅ$@   A   H	 H$@  蕘HǄ$x     H$p  Ƅ$`   A   H	 H$`  ^EE(EyH$@  H$`  H$`  \H$@  \IcU(H$   CHL$(  IH$   H+HHt&HHL$(  IH$   H+HH;rHL+IMt-ff     HHH$(  H$   H+HH;r_ "   D$0   |$ LL$0LD$ H$   HL$( HT$(H$   9  #   D$    |$0LL$ LD$0H$   HL$(׍ HT$(H$     $   |$ M   LD$ HT$PHL$(謐 HT$(H$     %   	 D$(|$ LL$(LD$ H$   HL$0蒔 HT$0H$   p R &   |$ M   LD$ HT$8HL$(w HT$(H$   5 A   E;u(   *   HǄ$     H$  Ƅ$   A   H	 H$  HǄ$     H$  Ƅ$   A   H|	 H$  辕HǄ$     H$  Ƅ$   A   H	 H$  臕HǄ$     H$  Ƅ$   A   Hu|	 H$  PHǄ$x     H$p  Ƅ$`   A   H:|	 H$`  IcI   L$  H LD$8HHL$ 蜐 HD$(L$  HIMhÎ LD$hHHL$0q L$   HH$   詼LIM0L$  HB  LL$  HIMhk LD$PHH$    L$   HH$   NAHH$   	MHH$   &LD$(HH$@  HL$`  HH$     HHHH$`  XH$  XH$  tXH$  fXH$  XXAar ,   IUHL$   L$   HL$(ؘ HT$(H$   V H$   HtL$0  L+IHT$hHtLD$xL+IȇWD$hH|$xHT$8HtLD$HL+I蟇WD$8H|$HHT$PHtLD$`L+IvH$   H$   
 H$   H$   HXH$   HtL$   L+I&HH$   H3Cp L$   I[@IsHA(sIA_A^A]A\_@SVWH   HD$0H$ H3HD$xIHHHD$p   HD$h    D$X A   Hx	 HL$XHD$P   HD$H    D$8 A   H)	 HL$8ǑLGL+IH\$(D$    DHL$8HD$PHrQHHL$8H=   r<tX HAH;rX H+HsX H'vX Hv HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<toX HAH;r_X H+HsOX H'vBX Hv HHHHL$xH3n HĀ   _^[Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Ht H3HsHsHH;uHl$0Ht$8H\$@H _V V V V V DL$ LD$HT$HL$SVWH0HD$(HH9z ucH 藠 HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH W HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHr H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _T T T T H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   H"r H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weHq HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _S S S S S |S uS nS H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHp H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _R R R R HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHIHHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Ho H3HsHsHH;uHl$0Ht$8H\$@H _Q Q ~Q wQ pQ HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     HL	 HD$`HM O D$    E3E3HT$hHL$`N HD$`HcHH(9	 HD`HD$`HcHDxDD\   HL$h'HHL$`HHl	 zHHHHr	 `HIHAM HHlHUPHL$`N\HxrH H
W HL$(3HL$0HL$8HD$@D$HHT$0HL$@AN HN	 HD$(HF HL$(x @UVWATAUAVAWH$pH  HD$@H$  H H3H   MIHLL   H   HD$8E3D|$0H%K	 HD$PHMM D$0   E3E3HT$XHL$POM HD$PHcHH7	 HDPHD$PHcHDxDDLAWHL$X莕HHL$P HHB	 HIVL HHB	 HU`HL$PZHIcD$0HU`H}xHCU`HEX   L}PD}@D8:tIIB<: uMHM@؆HD$8HD$ MLD$0HU@IH\$Ht$WH IHHH;t HH5DHHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(IHf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IIHA(HWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   7HX(H
?h	 HH0@8   HH$   ā HHL$(67H7 HL$(\ H\$WH HHHÀ< uHú   Hu2 HHu/ Ht!HH+fff     9HHuHH\$0H _@SH HQ  H'	 HCPH [HL$SH0HD$ HD$P    EtH&%	 HA@H&	 HAPD$P   J   HK	 HH#	 HCHC@HcHH$	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH9 HHQ3HHBHK0 H&	 HH{3HHDH^H\$HH/	 HHOHKHtHPHGHCHGHCG C HB	 HH9 HHH\$PHt$XH0_@SH HN  H%	 HCPH [HL$SH0HD$ HD$P    EtH#	 HA@HS%	 HAPD$P   z  Hs	 HHQ	 HC(HC@HcHH	 HD@HC@HcHD<    HH0[@SH HbL  H$	 HCPH [HL$SH0HD$ HD$P    EtH#	 HA@H$	 HAPD$P     HSK	 HHy%	 HC(HC@HcHH	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH H#	 HHH+	 HAPHI8. HK . HK. H
!	 HH [@SH HC	 HHH*	 HAPHI8. HK v. HKl. H 	 HH [H\$WH HN  H-#	 HGPt
X   HL HH\$0H _H\$WH HLL  H"	 HGPt
X   HL HH\$0H _H\$WH HHt,	 HHHJHKHtHPHGHS0HCHO0HGHCG C H66 HC(3HHB, H*	 HHJ+	 HC(HH\$0H _H\$WH HI  H"	 HGPt
X   HK HH\$0H _H\$WH HH+	 HHHJHKHtHPHGHS0HCHO0HGHCG C Hf5 HC(3HHB+ H	 HH#	 HC(HH\$0H _@SH HH   b, H   ~*HKXL, HKHB, HK88, HK(., HK$, HKH [H%, H\$WH HQ@3HHtLAPL+IYH{@H{HH{PHS(HtLC8L+IYH{(H{0H{8HSHtLCL+IHH{H{H{H\$0H _H\$WH HH     L   HgfffffffL+   IHLI?LH     H   F)HOX+ HOH
+ HO8 + HO(* HO* HOH\$0H _H%* @UVWAVAWH$@H  HD$8H$  H H3H   IILHE3D|$0AA A	fD  f/rHHrY  H*	 HD$PH	'	 HD$`HMj) D$0   E3HT$hHL$P.) HD$PHcHH"	 HDPHD$PHcHhTLHD$hHD$@HL$h& H	 HD$hL}D}H^	 HL$`躜HL$`' H   HL$Pz4H   H   HC   HEh   L}`EP : uMI@ IB< uHMPbHǅ      L   Ep A   H9^	 HMpbHEPHD$ LMpLIHH   H34@ H$  H  A_A^_^]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEH`	 H  aHL@H
	 H;u.HSHKHHH  9HHOQ& H  HAАH  HrSHH  H=   r<t( HAH;r( H+Hsw( H'vj( H9F HWHL$x{E@  MEHT$xH^  (Hǅ     L  ƅ   A   H%_	 H  `IH  IPH  HrSHH  H=   r<t' HAH;r' H+Hs' H'v' HgE H   3H^	 H   藙H($ H  H   X1ILAHIAАH  HrTHH  H=   r<t' HAH;r' H+Hs& H'v& HD HH  	1HH  $ H\$0Lt$(x  D$ p  (HT$xHM  H_HD$xH  HuHCH;t'H;tH% Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  豌 HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
QW	 " W  L  D$@Ll$PH.$	 HEH!	 HEHMH}# D$\   E3HUHMC# HEHcHH	 HD
HEHcHhT
HEH  HM  H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HBH  HM.HXH  !Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
(V	   IPL+IIHL+IIM;HCH;HCHL$@_yLD$HMtM(LD$HILD$HIPHL$@H;t
I;t\C IHT$@IPHǅ     L  ƅ   E3H?	 H  \IH  IP H   H  .HZ	 H  aHȋW$  HHcZ	 FIH  IPAD9o$Y  f     LGHWHL$x\ EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  *.D$0D$(HD$@HD$ LD$`HH  H  e,HXH  HtIH  IPLD$HL;D$Pu   HL$@eQLD$HMtM(LD$HILD$HIPHL$@H;t
I;tA IHT$@IPHH  ,HH   ;w$}H
S	 I Hǅ     L  ƅ   A
   H
Y	 H  ZIH  IP H  HH  +HH  V HMHl+HMHB HT$@HtLD$PL+IFNWD$@Ll$PH  HtL  L+Ii=HT$`HtLD$pL+IMHM HL$x 3H  H37 H$`  ($   H  A_A^A]A\_^]HUWATAVAWHhH   HEHXHpH[ H3HEHHLALIEgAEoAEwA EA$HE   E3LeDeED$+HW	 HMXHE   LeDevW	 MAHfW	 HM]XD9ckHE   LeDeED$HS	 HM1XHE   LeDeED$HS	 HMXHEHD$ LMLCHUHMl*HEHrPHHMH=   r<t/ HAH;r H+Hs H'v H< HE   LeE HEHrPHHMH=   r<t HAH;r H+Hs H'v Hg< HE   LeE A&   HRV	 HMWHE   LeE U	 MAHU	 HMV{ mHE   LeE A   HlR	 HMVHE   LeE A   H%R	 HM|VHEHD$ LMLCHUHM(HMHMHE   LeE A*   HU	 HM#VHE   LeE U	 MAHT	 HMULC HUHM`HMHM|HE   LeE A&   HOU	 HMUHE   LeE T	 MAH~T	 HMuULC$HUHMHM	HMHHMH33 L$   I[8Is@IA_A^A\_]HUVWATAUAVAWHH  HEHX)pHe H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHR	 H  THL@H
j	 H;u.HSHK(HH  HH/1 H  HAАH  HrSHH  H=   r<tw HAH;rg H+HsW H'vJ H9 HWHL$x@  MEHT$xH~l  (Hǅ     L  ƅ   A   HR	 H  ySIH  IPH  HrSHH  H=   r<t HAH;r H+Hs H'vx HG8 H   %HQ	 H   wH( H  H   8$ILAHIAАH  HrTHH  H=   r<t HAH;r H+Hs H'v H7 HH  #HH   H\$0Lt$(x  D$ p  (HT$xH0[  H_HD$xH  HuHCH;t'H;tHm Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH   HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
1J	  W  L  D$@Ll$PH	 HEH	 HEHMH] D$\   E3HUHM# HEHcHH{	 HD
HEHcHhT
HEH  HM H
	 HELm0Dm8D$0D$(HD$@HD$ LD$`H"H  HMr!HXH  Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
I	  IPL+IIHL+IIM;HCH;HCHL$@?lLD$HMtM(LD$HILD$HIPHL$@H;t
I;t<6 IHT$@IPHǅ     L  ƅ   E3H2	 H  NIH  IP H  H  !HM	 H  AHȋW$ HHCM	 &IH  IPAD9o$Y  f     LGHWHL$xNP EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  
!D$0D$(HD$@HD$ LD$`HH  H  EHXH  uHtIH  IPLD$HL;D$Pu   HL$@EDLD$HMtM(LD$HILD$HIPHL$@H;t
I;tr4 IHT$@IPHH  HH   ;w$}H
wF	 ) Hǅ     L  ƅ   A
   HK	 H  LIH  IP H  HH  cHH  6 HMHLHMH" HT$@HtLD$PL+I&AWD$@Ll$PH  HtL  L+II0HT$`HtLD$pL+I@HM HL$x 3H  H3) H$`  ($   H  A_A^A]A\_^]@SH A(HA b CH [Ht$WH0HD$     H      t@W H   HVxH\$@      ^FxH\$@,;L   HHt$HH0_@SH H#	 HH   HR HH
	 HAPHI8 HK  HK~ H	 HH [Wf/v%      ^Ix,;L   H\$WH HHH   H
H   H
H   HH\$0H _
@UHHPHEH\$`Ht$pH|$xH H3HEHHE   3Hu@uDF
HI	 HM	JHKHEH;sTHHUH;wHH}H+H;KuVH>HH;HKHtcHA   HqHyrHHH;H;Ku
   H>HKHt'HA   HqHyrHHHU  4OHC HEHrPHHMH=   r<t HAH;r H+Hs H'vv HE. HE   HuE A
   HH	 HMHHCHMH;sVHHUH;wJH}H+H;Cu
   H=HH;HKHtcHA   HqHyrHHH;H;Cu
   H=HKHt'HA   HqHyrHHHU  NHC HMHE   HuE A   HG	 HMHHUHHMHMH3% H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3um  HSH2n  H_HGPLG`HHOPP8MHHOPk  HHM衦HCHEEWH9puA(H HD$8HEHEHL$0n (Y5	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0 Y	 XC(EoHHEoH#H      H;v	 \(]] (5Ȯ	 f/vIHOh	j  f/v:HEH;t1HKHU
EC(HKHUHK0HU]HCHEHx tH HD$8HEHEHL$0, D(DY	 DXC(D   0H		 I$I\$H]oHONHHHGHCHWHGLL+tV\ W=	 A|$At$ HM HM HM IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA [ CH [H\$WH0HD$     H      tS HWxH   HH\$@H0_@SH H{ HH   H HH	 HAPHI8
 HK 
 HK
 H HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=ѫ	 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@f HL$0)	 ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@0f HL$0= L$   HHH$   ($   HĠ   _:f  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Hg HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     HHK8HOHS0LC8IL+LtHW HH\$@H0_H\$WH0IH IHD$     _HHK HOHSLC IL+LtHdW HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3 HHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$Pb0 HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P (Y%	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$   } (X\(HĐ   [B(HhHBHD$(Hx uWY	 HhH HL$8HD$@HD$ HD$P YX	 HhWf/vϦ	 f/v   Wf/vIxHAHH H\$WH HHe  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs| Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$X| f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHGfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   Hk3HSHt
HHH
HB$H;Cu
   H?3HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   H2HSHt
HHH
HJ$H;Cu
   H2HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HV2HSHt
HHH
HB$H;Ku
   H*2HCHt0HH   HCH;s;HH;w3H+HH;Cu
   H1HSHt
HHH
HB&H;Cu
   H1HKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xH! H3HEHHE   3Hu@uDF
HJ:	 HMy:HCHMH;sTHHUH;wHH}H+H;CuVHg/HH;HKHtcHA   HqHyrHHH;H;Cu
   H$/HKHt'HA   HqHyrHHHU  ?HC HEHrPHHMH=   r<t HAH;r H+Hs  H'v  H HE   HuE A   HP9	 HMO9HCHMH;sVHHUH;wJH}H+H;Cu
   H;.HH;HKHtcHA   HqHyrHHH;H;Cu
   H-HKHt'HA   HqHyrHHHU  x>HC HMJHE   HuE A   H8	 HMt8HUHHM
HE   HuE A   HX8	 HM78HUHJHMHE   HuE A   H7	 HM7HUH
HMHMH3 H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    ]  HSH^  H~HFPLF`HHNPP8MHHNP[  HHM~HUH   mHUHM0_HUH   NHFPLHUHNPP(HMHE HMHM(HULL+tHM HMgHEHMHMHULL+t	HrM HN(<HD$xH^(H]HV LL+tHFM H]EWA(HGH  Hx uE(H HEH   HEHM{ D(D	 EYDXO(D$`    DEǆ       Ɔ          D	 D%E	 D-	 @      WD$hHt3 HRHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM% D]HNhX  fA/  HEH;  LcuIL;wt%HO+ EtHfHGHG    H_E~LEN    HUHObK EG(Lcu IL;w t%HO EtHHGHG    H_ E~LE N    HUHOK LcuIL;w8t%HO0y EtHHG0HG0    H_8E~LEN    HUHO0J Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      H9\  HEH;  HWHM<{G(EHWHM%{HM   H   H;t=HOH    {   G(HOH   zHO0H   zLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      HX[  H   H;t=HWH   YzG(   HWH   <zH   HW0,z     uf/w(\!I (HNhU  f/v=H   HM8y   EXH   HMHyH   HM`yf/v\(iX(\(i(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM] HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  o fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  po fA/v"HL$h    9   }H]HL$h D$`   fnu^HE0H;t1HOHU8wEXG(HOHUHwHO0HU`wHU     V0W	 HV(I\}HL$x HM
 HM  HM H    H    H    HM` HMH HM8 H    H    H    HM} HMs HMi IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH    .LcHsHH{Lsp5	 EW=	 E   I$HEI|$HFH;t'H;tHW Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
ʠ	 ff     HE(WA)HH;}LEMHL$`D$ H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMk    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMk EHSxHExHD$(H  HD$ L   L   HM. YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(Hl0 t0Eu"A   EEH+	 H   .A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HMc HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I迕  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Aa  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`H Y   SxE3;a  H   HCxMHH\  [pSh(\%	 T   f/vA      8  f/vA        f/vA
      H  H9   rA(   ~TUpT]xH0  HMp f/HGHExf/HG^(  5(	 Yf/vA   !Hn[  @  Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   H[Ic d HA   H'	 vAO   H('	 gAO   Hi'	 XA6   H'	 IAD   H'	 :AC   H(	 +A9   HU(	 AQ   H(	 
A   H(	 HC   HLKD8&HH0[ %        4  HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H		 H   EotEH   `%LcHsHH{Lsp5؍	 EW=ԍ	 E   I$HEI|$HFH;t'H;tH Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$` H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHM5c    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMb EHSxHExHD$(H   HD$ L   L   HM=& YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H' t0Eu"A   EEH"	 H   &&A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$`G I  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   A|]  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`@ Y   SxE3\  H   HCxMHH[  [pSh(\%ɒ	 T   f/vA        f/vA         f/vA
      H   H9   rA(   ~TUpT]xH  HMp f/HGHExf/HG^  5h	 Yf/vA   !H>Z     Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]LSH   ICHAC    H ICH ICAC   HE ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$X H HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    HAk HL$(
 @SH0HD$ HٹX   l HD$@HSH^  HHtH@@HcHHB@HH0[@SH0HD$ HH7 HH] HA(HA@HcPHj HD
@HA@HcPDBDD
<H HH HA(H0 H HHKHtHP tHC    H0[LSH   ICHAC    H ICH ICAC   He ICHIIKHtHPHCHD$8HCHD$@CЉD$HH. HD$P3HD$XHD$`HKHT$X H HD$(H[ HD$PHD$hHcHH HDhHD$hHcHDd    Hqg HL$( @SH0HD$ HٹX    HD$@HSH]  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HA(HA@HcPHZ HD
@HA@HcPDBDD
<H HH HA(H0 H HHKHtHP tHC    H0[LH   ICAC    HQH; ICH ICAC   IK[H\ HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H.f HL$(
 @SH0HD$ HٹX    HD$@HSH\  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPH
 HD
@HA@HcPDBDD
<H= HH{ HAHI HtHP tHC     HU HHKH0[H%Z @SHpHk H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8U @-H$   u	HHHtHL$`H3+ Hp[2HL$`H3 Hp[@SVWH   HD$8H H3H$   IHHA D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   H	 HL$@HD$x   HD$p    D$` A   H<	 HL$`HD$@HD$ LL$`LHH贍H$   H33 HĐ   _^[@SVWH   HD$0H H3HD$xIHHAWf/w|HD$P   HD$H    D$8 A   H	 HL$8HD$p   HD$h    D$X A   Hc	 HL$XHD$8HD$ LL$XLHHیHL$xH3] HĀ   _^[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H( HAPD$P   H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_Hu H\$WH H HH   H, HH HAPHI8l HO b HOX H Ht
   H HH\$0H _H\$WH H HHH@ HAPHI8 HO  HO H7 Ht
   H HH\$0H _H\$WH H7 HH   H HH HAPHI8| HO r HOh H Ht
  H HH\$0H _H\$WH H_ HHHP HAPHI8
 HO   HO HG Ht
   H HH\$0H _LHXICLL	IAI+HHIH;rQHH IC3ICICH	 ICD$0ISIK H HD$8H	 HL$8GHAI@IHH
HHXHUSVWATAUAVAWHH  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)H H3H@  D((UHHT$xLT$0\$8Hh  Lp  Hǅ     E3L  D   EFH
	 H   Hǅ     L  D  	 MA3H	 H  EWfA/   Hǅ     L  D  EFH	 H  DHǅ8     L0  D   EFH	 H   H  HD$ L   LD$0H   H  'H  HrSHH  H=   r<t$ HAH;r H+Hs H'v H Hǅ     L  ƅ   H  HrSHH   H=   r<t HAH;r H+Hs H'v~ HM Hǅ     L  ƅ    A%   H7	 H   Hǅ     L  ƅ   	 MA3H	 H  fE/   Hǅ     L  ƅ   A   H,
	 H  `Hǅ8     L0  ƅ    A   H		 H   -H  HD$ L   LD$8H   H  AH  H   Hǅ     L  ƅ    A   H9	 H   
Hǅ     L  ƅ   	 MA3H	 H  x
L`  H   H  H   H   I$HPHMBI$HPHM0E(D-bx	 u	 T$0fn`  =t	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`Hx  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   H	 H  gHH  HP H  Hǅ     L  ƅ   A=   H	 H  HH  HP H   D$pAA   D=-	 D5s	 @ LLEHIV  HMAu3H  (HHM+H   H     HUL(H  VHHUHML
s	 HM02LHH  `HHM3H   H   H   H  u fEnEA(" ^HU0HM L
Ns	 H  BHHUHM2L(HMLHH  HHH   H   H   H   AƙA|$   A(LHIX  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyXs	 ^HT$@P  D(H      HMX HH. H   NBHHu3
H HcHHHW	   HMh HAHd HH BHH% HHu3
H HcHHHW   HMx LHu3
HHcHHIPA   H   C HA(H HHU |AHHu3
H HcHHHW   H    HHDHk HHu3
H HcHHHW   H    H(H6 HH @HHu3
H HcHHHW   H   y HHH HHu3
H HcHHHWA(H  +D$pfn^=q	 |$83H  H  H  WH  _H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  H  H  HtHHH1H;  u   H  H  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  [H  H  Ht;HH+H;  u   H  %H  HtD	H  HH  IE L@H
3 H  H;IuEAfD/vH		 H   >E2fE/vH		 H   >E2AD$ D;~!fE/wfA/vH	 H   P>HH   HPE   A(A\A^ATf/-l	    Hǅ     H  D  Aa   H	 H  UHH  HP H  Hǅ     H  D  AH   H	 H  HH  HP H  H  Ht%L  L+IgW  H  HH  IHH   =Lk	 H|$xD;`     Hǅ     3H    DCiH}	 H  QHH  HP H  Hǅ     H    DCBH	 H  HH  HP H  E2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHt(HM HM HM HM H@  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWHP  IǃA)sA){H7 H3H$(  MALHHL$`H$   HT$xDD$PL$   Iǃ    E3MEEGHb	 IVHǄ$     L$  D$  
	 MA"H	 H$     HǄ$     L$  D$  EGH H$   HǄ$      L$  D$  EGHP H$   H$  HD$ L$  LD$PH$p  H$  H$  HrTHH$  H=   r<t HAH;r H+Hs H'v HP HǄ$     L$  Ƅ$   H$  HrTHH$p  H=   r<t0 HAH;r  H+Hs H'v H HǄ$     L$  Ƅ$p   A   H	 H$p  \IH$p  IP H$  HrTHH$p  H=   r<t HAH;ru H+Hse H'vX H' (pn	 $  (
Al	 $  1f	 $  
 j	 $   MIHM  $   HHPH$   HHPH$   wf	 $   
f	 $   e	 $   WL$hD$@ED|$X|$@   Ic  $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3HN H$  HǄ$     L$  Ƅ$p   E3H H$p  wDLt$8H$  HD$0H$p  HD$(D΋蹲H$p  H$  ML$   IHL$`tG  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  GHH$   FH$  / H$     H$  
L$   H$p  dHH$   H$  L$   H$@  3LHH$  `HH$   /H$   H$   H$  { H$p  m fn (^H$@  H$   L$   H$p  3HH$   H$  L(H$  hLHH$  HIH$   H$   H$   H$p   &MIH\$`HI  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$p  H	 H$  "4HHP	 4HL$h< HHr 3H$  AHJ	 |HI 3IH$p  IPHǄ$     L$  Ƅ$p   E3H H$p   IH$p  IP H$p  萾D$@ H$  nH$  @   A}$      f/$   6  H$p  Hk 	 H$  3HH4 	 2HL$h  HH^ 	 2IH$p  IPHǄ$     L$  Ƅ$p   E3H H$p  IH$p  IP H$p  蕽D$@ H$  sH$  E H$   $   D$hADd$XHSH$   HIH$   H$   EHǄ$     L$  Ƅ$   AJ   Hi H$  ,HǄ$     L$  Ƅ$p   A   H H$p  HǄ$     L$  Ƅ$    MA"H H$  HǄ$      L$  Ƅ$   E3H# H$  H$  HD$ L$  H$p  H$  uw  H$   ν H$    H$    H$    D$hH$(  H3 ($@  ($0  HP  A_A^A]A\_^[HUSVWATAUAVAWHH(  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)H H3Hp  D((UHHT$xLT$0\$8H  L  HǅH     E3L@  D0  EFHM H0  Hǅ     L  D   MA3H H  EWfA/   Hǅ     L  D   EFHP H   Hǅh     L`  DP  EFH HP  SH   HD$ LP  LD$0H0  H  gkH  HrSHH  H=   r<td HAH;rT H+HsD H'v7 H Hǅ     L  ƅ   HH  HrSHH0  H=   r<t HAH;rۻ H+Hs˻ H'v H HǅH     L@  ƅ0   A%   Hw H0  Hǅ     L  ƅ    MA3H H  fE/   Hǅ     L  ƅ    A   Hl H   Hǅh     L`  ƅP   A   H HP  mH   HD$ LP  LD$8H0  H  iH  H0  ׷HǅH     L@  ƅ0   A   Hy H0  Hǅ     L  ƅ    MA3H H  L  H0  H  H  @H0  3I$HPHMrI$HPHM`E(D-]	 *[	 T$0fn  =Y	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`H]  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   HC H  HH  HP H  9Hǅ     L  ƅ   A=   H H  WHH  HP H  ; D$pAA   D=md	 D5Y	 @ LLEHI~E  HMAu3H   غHHMH  U H      HU診L(H  VHHUHM L
X	 HMP2LHH   @HHM胾H  ݶ H   ж H  ¶ H   fEnEA(X ^HUPHML
X	 H  BHHUHM L(HMLHH   HHH  / H   " H   H   AƙA|$   A(LHIG  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyXX	 ^HT$@6  D(H   $   H   I HHk H   'HHu3
H HcHHHW	   H    HAH HH ?'HHU_ HHu3
H HcHHHW   H    LHu3
HHcHHIPA   H   z HA(H HH &HHu3
H HcHHHW   H   = HH{H HHu3
H HcHHHW   HP   H(Hm HH &&HHu3
H HcHHHW   H0   HHH HHu3
H HcHHHWA(H . +D$pfn^=BV	 |$83H  H  H  WH  H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  2H  H  HtHHH1H;  u   H  H  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  H  H  Ht;HH+H;  u   H  \H  HtD	H  HH  IE L@H
j H  H;Iu+AfD/vHK H   #E2fE/vHF H   #E2AD$ D;~!fE/wfA/vH3 H   #HH   HPE   A(A\A^ATf/dQ	    Hǅ     H  D   Aa   H H   HH   HP H   Hǅ     H  D   AH   H H   <HH   HP H   έH  Ht%L  L+IW  H  Hh  耺Hh  S =P	 H|$xD;     Hǅ     3H     DCiH H   HH   HP H   Hǅ     H     DCBH H   ;HH   HP H   ͬE2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHt_HM< HM2 HM' HM Hp  H3V L$(  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWH  IǃXA)sA){Hwy H3H$`  MALHHL$`H$   HT$xDD$PL$   Iǃ   E3MEEGH IHǄ$     L$  D$  J MA"H: H$  U   HǄ$     L$   D$  EGH H$  HǄ$8     L$0  D$   EGH H$   H$  HD$ L$   LD$PH$  H$  3H$  HrTHH$  H=   r<t HAH;rެ H+Hsά H'v H HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<tp HAH;r` H+HsP H'vC H HǄ$     L$  Ƅ$   A   H H$  IH$  IP H$  HrTHH$  H=   r<tū HAH;r H+Hs H'v Hg (S	 $   (
Q	 $0  qK	 $@  
@O	 $   MIHy<  $   HHPH$   輥HHPH$   觥.L	 $   
K	 $   4K	 $   WL$hD$@ED|$X|$@   Ic   $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3H H$  HǄ$     L$  Ƅ$   E3HZ H$  DLt$8H$  HD$0H$  HD$(D΋H$  +H$  ML$   IHL$`6  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  HH$   H$   o H$     H$  轫L$   H$  dHH$   H$(  L$   H$X  3LHH$  @HH$   H$   ا H$  ʧ H$   H$   fnV (^H$X  H$   L$   H$  3HH$   H$(  L(H$  hLHH$  HI色H$    H$   H$   H$   &MIH\$`H8  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$  H H$  bHH SHL$h| HH 5H$  AH |H IH$  IPHǄ$     L$  Ƅ$   E3H H$  @IH$  IP H$  УD$@ H$(  记H$(     A}$      f/$   6  H$  ˱H H$  FHHt 7HL$h` HH IH$  IPHǄ$     L$  Ƅ$   E3H H$  EIH$  IP H$  բD$@ H$(  賯H$(   H$   $   D$hADd$XHSH$  萡HIH$   = H$  / EHǄ$     L$   Ƅ$   AJ   H H$  lHǄ$     L$  Ƅ$   A   HZ H$  5HǄ$     L$  Ƅ$    MA"H H$  HǄ$8     L$0  Ƅ$    E3Hc H$   H$   HD$ L$  H$  H$  \  H$    H$     H$    H$    D$hH$`  H3 ($  ($p  HĐ  A_A^A]A\_^[H\$
D	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI[  C(W_N	 C(H$   H$   H0HHD$XHHCH;t/H;t"HI Ht
H脃H3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
M	 fff     HD$X(WA)HH;}LD$@MHL$h" HĐ   _^[@SH`HBHHD$(Hx uWYA	 XB(H`[H HL$8HD$@HD$ HD$P% YA	 XC(H`[@SH    Wf.HAxHH   zt9HhPYHB	 \A	 Y   XA	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
H軁HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pHj H3H$P  HHHL$0sxH HL$@H( H$0  HL$0MLHHAPH$H  HrUHH$0  H=   r<t
 HAH;r H+Hs H'vݞ H謼 H$   H$   М H$P  H3 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHM~ (Y
X>	 XK(MHEHH#H      H;v
@	 (  \f/   vƇ   \H(  f/v(\U
H(  X \(<
XH(   f/vH0   X4>	 ( H0  X  H;t/HSHNyHC(HF(HSHNdHS0HN0WLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$hBX HMHLHT$hP(HH   HHHHPHKHHHSHL$h HHEHsH   HCH;t'H;tH Ht
H,}HH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h+ H       D  HY(WEHt34 Ht|HEH] =>	 } H  H[WEHt3 H7|HHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM01}H  L@LEWEMt3 HMzHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMW H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(\(Xu \I(XuuHUH(  H)Ef/w"\ (H   Hhnf/vHE0H;tHU0H0WEH]HHt3ߖ HyLHEH]LEHuHEHEHEHEH;t-I HtHxLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM[ LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM_R LML   H   H   HML HMA HM`6 HMH, HM8" HM HM L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   H2  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0/  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0J LLHHg0  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK     HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_@SHpahHAHT%:?	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h
 f/0  s0  ^W>	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HMHHEH[IG3H;t'H;tI Ht
HsII?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
>	 f     HE(WA)HH;}LEMHM HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHMpJ H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHMG Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM H(H;~uH>H;~IDHHMtLE'M+IIL$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHM D(=;/	 EtCH]H{ uA(HHEHEHEHMn (A^H*  HG     (A^}gH]H{ uA(HHEHEHEHMn D^DG0DMWEWMHUH@  HM} HMs HEgHEH]HuHOH;uHOMgIHHUC (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   @SHpahHAHT%7	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h9 f/  s  ^W\7	 Hp[HWH   H@HXHpHHHHL@@@HPHH2t HsHG3H;t'H;tH Ht
HWlHHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
6	 fff     HD$`(W)HH;}HL$(HL$8 HL$pr L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$HZ D(5*	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;tHHHt3: HzjHD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0 E   LuI~ tIHD$PHD$xHD$`HL$Hli (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"H Ht
H:iHH    H_H_LEHT$xHUH   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;tHHHt3T HhHD$HH\$PH\$XLEHT$xHL$HK H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;tkIIHGHH;t"HŅ Ht
H hHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$H4 ID$HEDMLeLeLEHT$xHD HL$0  (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    Hw HA@H{y HAPD$P   rWH* HHPz HG(HG@HcHH]s HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    H.w HA@Hx HAPD$P   UHr HHm HG(HG@HcHH}m HD9@HG@HcHQT9<HH>HH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH{v HA@Hx HAPD$P   QHm HHOHu HHG@HcPHv HD:@HG@HcPDBDD:<HSHHD聽HH\$HHt$XH0_HL$HH"	 LL$P)t$0LD$X3)|$ 5</	 =t&	 Tf/vE  "   #	 LL$PLD$X3趏Tf/v  "   Q$	 LL$PLD$X3舏Tf/v  "   [$	 LL$PLD$X3ZTf/v  "   }$	 LL$PLD$X3,Tf/v  "   g$	 LL$PLD$X3Tf/v_  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
˳ ~ 3Ld$xM+L$3IIHH+II;HCI;LCIH$   HH+LL$   HH/HIL$   L+ LGH3H$   IL+ HHGH+HHHtLGL+I@KLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$p HOLD$pHH+$   HH+H#/H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0x~ H$   ILkHGL+LI+HR~ H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(!Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
 z H
ݯ z LD$0H|$(IH+HHHDL$pHHj 3HthH+HI;v} H    H=   r=@tj} HGH;rZ} H+HsJ} H'v=} HH	 (L\$PI[(Ik0Is8(t$@IA_A^_@USVWAVAWHl$H   HEHG H3HEMIHHHE   E3L}D}EGH HMBHE   L}D}EGH HMHE   L}D} MA'H HMG DF D;tD$ LMHUHMHEHrPHHMH=   r<t
| HAH;r{ H+Hs{ H'v{ H诙 HE   L}E HEHrPHHMH=   r<t{ HAH;r{ H+Hs{ H'vv{ HE HE   L}E HEHrPHHMH=   r<t9{ HAH;r){ H+Hs{ H'v{ Hۘ HE   L}E A   Hn HMuHE   L}E A   H HMNHE   L}E ƺ MA'H HMHCHHDG D;tHL$ LMHUHMEHEHrPHHMH=   r<t8z HAH;r(z H+Hsz H'vz Hڗ HE   L}E HEHrPHHMH=   r<ty HAH;ry H+Hsy H'vy Hp HE   L}E HEHrPHHMH=   r<tdy HAH;rTy H+HsDy H'v7y H Lt$0HCHD$(CD$ LKLHH/  HMH3c Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HHC H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ Ht3uw HYHD$@H\$HDt$8Aމ\$4DV	 fD  A;]  M}AA|$  ~1I@ H\$@MA((< HA;t$ |ڋ|$0LD$@H$   I!HHL$@HHT$@HPHL$HHHHT$HH$   v Hv H$   Hjs H$   H$8  u |$0E3H$   H$   u H$   HcHHn H   H$   HcHh   H$   HD$hH$   r L=i L$   L$   D$(  HT$@IM   (D$hH$  H$   跀HXH$  HrTHH$  H=   r<tv HAH;rov H+Hs_v H'vRv H! HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   Hն H$  萮HǄ$     L$  Ƅ$   | MA"Hl H$  Ot$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   Hܩ H$   HǄ$     L$  Ƅ$   A   Hm H$  H$   HD$ L$  LD$hH$  H$  #H$  HrTHH$  H=   r<tt HAH;rt H+Hst H'vt Hm HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<tMt HAH;r=t H+Hs-t H'v t H DXDL$P\$4É\$4H$   HcHHk H   H$   HcHh   L$   H$   PH$   q H$   p H$8  q `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I((AXHL$@Mr (H$(  H3肉 L$p  A(sA({E(CE(KIA_A^A]A\_^[@USVWAVAWHl$H   HEH= H3HEMIHHHE   E3L}D}EGH HM"HE   L}D}EGH޲ HMHE   L}D}u MA'He HM̪G(DF(D;tD$ LMHUHMjHEHrPHHMH=   r<tq HAH;rq H+Hsq H'vq H菏 HE   L}E HEHrPHHMH=   r<tq HAH;rsq H+Hscq H'vVq H% HE   L}E HEHrPHHMH=   r<tq HAH;r	q H+Hsp H'vp H軎 HE   L}E A   HN HMUHE   L}E A   H HM.HE   L}E  MA'H HMHCHHDG(D;tHL$ LMHUHM%HEHrPHHMH=   r<tp HAH;rp H+Hso H'vo H躍 HE   L}E HEHrPHHMH=   r<to HAH;ro H+Hso H'vo HP HE   L}E HEHrPHHMH=   r<tDo HAH;r4o H+Hs$o H'vo H Lt$0HCHD$(CD$ LKLHH  HMH3C Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HH9 H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ(Ht3Um HOHD$@H\$HDt$8Aމ\$4D6	 fD  A;]  M}AA|$( ~1I@ H\$@MA(( HA;t$(|ڋ|$0LD$@H$   I聂HHL$@HHT$@HPHL$HHHHT$HH$   l Hal H$   HJi H$   H$8  k |$0E3H$   H$   ck H$   HcHHd H   H$   HcHh   H$   HD$hH$   h L=_ L$   L$   D$(  HT$@IM   (D$hH$  H$   vHXH$  HrTHH$  H=   r<t_l HAH;rOl H+Hs?l H'v2l H HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   H H$  pHǄ$     L$  Ƅ$   \ MA"HL H$  /t$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   H H$   ףHǄ$     L$  Ƅ$   A   HM H$  蠣H$   HD$ L$  LD$hH$  H$  H$  HrTHH$  H=   r<tj HAH;rj H+Hsj H'v~j HM HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t-j HAH;rj H+Hs
j H'v j Hχ DXDL$P\$4É\$4H$   HcHHna H   H$   HcHh   L$   H$   0H$   g H$   f H$8  g `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I|(AXHL$@-h (H$(  H3b L$p  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pH3 H3HEIHHE   3Hu@uDFnH HMHHUHP@HEHrPHHMH=   r<tCh HAH;r3h H+Hs#h H'vh H HHPHE   HuE 8 uLIIB<  uHHMhHHUHP@HEHrPHHMH=   r<tg HAH;rg H+Hs}g H'vpg H? HE   HuE A   HB HMٟHHUHP@HEHrPHHMH=   r<tg HAH;rf H+Hsf H'vf H谄 HE   HuE Ah   HC HMJHHUHP@HEHrPHHMH=   r<tf HAH;rof H+Hs_f H'vRf H! HE   HuE E3H] HM辞HHUHP@HEHrPHHMH=   r<te HAH;re H+Hse H've H蕃 HMH3| H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ I  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HOb HOb HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;v*c KHH=   r<tc HBH;rb H+Hsb H'vb HHH(驀 H(LHXICHfffffffH;vJHsj IC3ICICH ICD$0ISIK` HN HD$8HL$8  Hu3KH;v^ HHH   r&HA'H;w^ H{ HH'HHA{ HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"H` Ht
HCHH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHM HLFhLNH     HFH^HHEH~HCH;t+H;t"H` Ht
HIBHH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
	 fHE(WA)HH;}LEMHM H   Hǆ       Hr| E3L\$pI[Is I{(I]鿘Hg EHEHU3HMHEHEH HEm^ HFW H
 HEHM LALIIHQ I+HH;|
IH+HH+IHHAHtL+I̌H\$WH HZ HHAPHI8^ HO z^ HOp^ HP Ht
   H} HH\$0H _@SH HHI%^ HKH [H%^ @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(oWE3EL9{~HN(HJJIL;S|HFXLFLN@HV(H5		 WAE H^HH+^@HI;^tI\ Ht
H>IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtH! HHZ\Z    cAE $   H$   H#H;t3@HN Ht+H2 HH HHY       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [LHXICHH;vJHCc IC3ICICHV ICD$0ISIKY HG HD$8HL$8  Hu3	HXFHXHhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$P; WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;t	IHHt3lY H;HLsHkHnH{ H|$hH|$hL?LHt33Y H) HHoHnH{0H|$hL?LHt3Y HC;HHoC@   CD HH8 HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	Ѩ uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
Ǌ U HH|$0ӫHT$8HHFHHH\$@HNH+H>LHV H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PH@# H3HEpMMHHH   D$     HS HD$`HMPV D$    E3E3HT$hHL$`V HD$`HcHHX@ HD`HD$`HcHDxDD\   HL$hWHHL$`HHs HHHHy HIHIT HHHUPHL$`cHxrH H
^ HL$(3HL$0HL$8HD$@D$HHT$0HL$@sU HK HD$(H
 HL$( @SH`W)t$Pf/D)D$0D(   u+DW	 3A(W	 (t$PD(D$0H`[ fA/DWg	 A(v(
 \((t$PD(D$0H`[3bXZ (t$PD(D$0H`[5 fA/)|$@D)L$ D
( !  B fA/vTfD.z   eH%X      HЋ9   % AYDY AX  m eH%X      HЋ9~ 
  A(AY(Y((Y%2 (Y
? Y X% X
 X YYY X% X
 YX XYX^X%# AY  3t
K  fA/   eH%X   = fA/   HЋ   9   A(A(\AYWR 	 (Y  ((Y (Y (Y
J X X A^X
 YYYX X
 YYX(Y X
 Xr X YX YX^X" Y  ) fA/   9 '  A(A(\AYWZ (Y ((Y (Y (Y
 Xj XZ A^X
 YYYX1 X
i YYX(Yj X XJ YXX
* ^XV Y   fA/   9P   A(A(\56 AY(Wg Y ((Y (Y (Y
 X Xr A^X
 YYYXI X
 YYX(Y X X YXX
z ^X~ Y   9O Z  A(A(A^AY(YW > ((Y (Y (Y
 X X A^X
 YYYX X X
 YYYX{ X
 X(Y X YXp YX^X Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
r h =f t H
Q = lh H
d h =X (+ H
D (
    (   
 (
b  
 g qH
 9h = V( H
 (
{ T (M f (/ 
H (
!   
c (
  
m \g H
 g = ( H
| (
} F ( 
H (
 J (C 
\ (
 ^ 
g f [H
 -g =~ .( H
j (
_  ( 
 (
  (U 
 (
   
) `f H
 f = ( H
 (
A  (S    (U 
n (
 x  
Y (
 z 
c e H\$D$WH`)t$PI)|$@H(D)D$0 f/   (- f.zuoM   !   t  (D5 (Wf/2 WvW  D(E3(LHXD\( D\  i f/vfWf.zo (
 Tf/vy D(DW     ^\f TL D(    f/v$((\ \
 (4 D(of/= r! f/v(:  D(DHL$pVכ D((X2 \ 軛 \ \= YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
 )t$P)|$@   HD)D$0D)L$ D(ȋ
9    DX
 5 D(A(AYD^A(A(AY V EX
A YYA^X$ X
 D(L$ X(t$PYYX X
 YY(|$@X AYXX AYD(D$0\HhH
( c = ( H
 (
 )^ ( )
` (
i )b )
k Rb H8eH%X   
 A   )t$ (HB9    (\50 \-X (\-M Y\-! ((Y% (Y (Y
 X% X Y X
m YXa YX%M YXA YX
- YYY(t$ XX X% X^YY-T X(H8H
 a = 7 H
 (
 1 (  (  ( 
 (
    
 (
  
\ ` HH   )xD)@D(DTQ D)HD(DT
@ D)PE(D)XDi fE/D)`D(EYrA(A(A(s (    fA/A()$   r;< (A(/< =O  < (A(t< (XY=U YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW=\ (($   HĨ   @USVWAVHl$H  HD$PH5 H3HEpMHHH   D$     HB HD$`HMHE D$    E3E3HT$hHL$`E HD$`HcHHP/ HD`HD$`HcHDxDD\   HL$hOHHL$`HHb 袸HHǼHHh 舸HI譼HHyb nHH蓼HUPHL$`uRHxrH H
M HL$(3HL$0HL$8HD$@D$HHT$0HL$@hD H!E HD$(Hm
 HL$(o H@Hx)p()xD)@D D)HD
= fD/D)PEWA(rPA(\(p$ (\f/
 vAXfA.z   = Y( ^fA.z   f/5| r
(ZX
 f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   H H
U D$    L$   Hn H
  @USVWAVHl$H  HD$PH5 H3HEpMHHH   D$     H? HD$`HMHB D$    E3E3HT$hHL$`B HD$`HcHHP, HD`HD$`HcHDxDD\   HL$hOHHL$`HH_ 袵HHǹHHe 舵HI譹HHv nHH蓹HUPHL$`uOHxrH H
J HL$(3HL$0HL$8HD$@D$HHT$0HL$@hA H!B HD$(Hm
 HL$(l HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p5T )xWD)@Do D)HD
 H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4Cv H;}&HEHM(HE)HH;|LHMH< HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ i E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   : HHL$(: H
 HL$(g @SH0HD$     JHH0[@SH0HD$     
  HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH.  3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+INZe  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHMqLeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHMLeHEH}IHtHHHEIM;w!H
Cn 
9 H
5n 8 H]3MtyIrTIƃIH+fo f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHMHUH6H?HMHthHEH+HH;vD; H    H=   r<t(; HAH;r; H+Hs; H'v: HX A   L}XI;      HVHHM/E3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HTHNHMKHHHMHt	H]L}X1L;Fu
   HzTHNHMXHMHt
HUPH]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH`W IL}XL;}s(p9 i9 b9 [9 T9 HtsL+IHL;v29 J    H=   r=@t9 HGH;r9 H+Hs8 H'v8 HHV IM H   IEH+HH?H;v8 H    H=   r<t8 HAH;r8 H+Hsr8 H've8 H4V 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){H H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0 f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   2 V  H$  H$   HL;   IM Ht~IEH+HHH;v6 H    H=   r<t5 HAH;r5 H+Hs5 H'v5 HS Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;vO5 H    H=   r<t35 HAH;r#5 H+Hs5 H'v5 HR   H4 H$  L$  H$   H$  H3 H$   H0 H$0  H$  2 AD|$4E3H$8  H$   2 H$   HcHH, H   H$   HcHh  H$8  HD$XH$8  
0 H2' H$8  H$  $  ML$   H$  HL$PH$  H$   =HXH$  HrTHH$  H=   r<t3 HAH;r3 H+Hs3 H'v3 HRQ HtHH$   HPH$   HcHH* H   H$   HcHh  H0& H$8  H$8  vH$8  1 H$@  O0 H$  1 H1 H$   H. H$0  H$  1 AD|$4E3H$8  H$   0 H$   HcHH%* H   H$   HcHh  H$8  HD$XH$8  !. HI% H$8  H$  $  L$   IHL$PM5 (H$  H$   <HXH$  HrTHH$  H=   r<t1 HAH;r1 H+Hs1 H'v1 HoO HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   H H$  iHH$  HP H$  [.HǄ$     H$  Ƅ$   A>   H H$  uiHH$  HP H$  .HǄ$     H$  Ƅ$   A4   H H$  iHH$  HP H$  -H$  :H$  c. H$   y  H$  ;W$  H$  A0 L$  L$   IHL$P0 +fn^5 H$  H$  9HXH$  ,HtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   H H$  gHH$  HP H$  8,HǄ$     H$  Ƅ$   A8   H H$  RgHH$  HP H$  +HǄ$     H$  Ƅ$   A4   Hq H$  fHH$  HP H$  +E2HI;EulMtL$  M+IIL[H$(  >8H$(  , H$  "8H$  + H$   FwLd$`4  $   J  HǄ$     H$  Ƅ$   E3H6 H$  fHH$  HP H$  *H$  8Hv H$  iH(* HHC NHH$  HPH$  8Y5 Hp H$  HH9 HHF H(!* HH ڞHH$  HPHǄ$     H$  Ƅ$   A%   H8 H$  eHH$  HP H$  )HǄ$     H$  Ƅ$   E3Hd5 H$  dHH$  HP H$  @)HǄ$     H$  Ƅ$   E3H5 H$  ]dHH$  HP H$  (H$(  5H$(  ) H$(  5H$(  ) MtL$  M+IIXH$(  z5H$(  L) H$  ^5H$  0) H$   tD$HL$@T$2   H$  #5H$  ( H$   Gt3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3Hz3 H$  bHH$  HP H$  C'H$  5H H$  H(-' HH H(' HH` ˛HH 輛HȋT$@& HH% 蠛HH$  HPHǄ$     H$  Ƅ$   Ae   H& H$  aHH$  HP H$  Y&H$(  ;3H$(  
' H0 H$   3H$   H$   H= H$   Ƅ$   H$   H$   ' H' H$   H!
 H$   Q HL$pHIPH\$xHt(H$   HL$   L+IH+SH$   HtL$   L+IDIH$  H3v> ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH
 H3H   (MLHT$`HL  L  H  3ۉ\$DH   3WD$HH\$XLL$HMIH(H  H   >1HXH  HrSHH  H=   r<t' HAH;r& H+Hs& H'v& HD H   IH   IPH  H   0HLAH H;t
HHAАH  HrSHH  H=   r<t^& HAH;rN& H+Hs>& H'v1& H D W  Hǅ      t$(H  HD$ MMIH7 H  H   /HXH  HrSHH  H=   r<t% HAH;r% H+Hs% H'v% HPC H   IH   IPH  H   T/HLAHe H;t
HHAАH  Hr\HH  H=   r<t% HAH;r$ H+Hs$ H'v$ HB H E3EDd$@H  F0H H  H(! HH;tHPH  H  u.HLAH;t
HHAАH  HrSHH  H=   r<t,$ HAH;r$ H+Hs$ H'v# HA HH;tHPHǅ     L  ƅ   E3H- H  Q\IH  IP H  HrSHH  H=   r<t}# HAH;rm# H+Hs]# H'vP# HA IH  IPHǅ     L  ƅ   E3Hu, H  [IH  IP H  HrSHH  H=   r<t" HAH;r" H+Hs" H'v" Hn@ H  ".
   HL$hI H  HcQH  HHP   H    HH H  ^HHuI
H HcHHHW   HM HH| H HHuI
H HcHHHW   HM HHf HHHuI
H HcHHHW   HM^ HHԽ H褓HHuI
H HcHHHWH HxH  H  E+HLAHV H;t
HHAАH  HrSHH  H=   r<t  HAH;r  H+Hs  H'v  H> IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
}+  =M H HEH HEHMH L$DE3HUHMf HEHcHH HD
HEHcHhT
HEH   HM H HE3HE0E8IHHH   
   HM HMHcQHMHHP   HMj LIHM HHu3
H HcHHIWA   HM. LH   H HHu3
H HcHHIWA   H    LB+Hf HHu3
H HcHHIWA   H   LH' HHu3
H HcHHIWAB+\H H   HM(HLAH
 H;t
HHAАH   IHUIPB+\Tf/vD$@HMHh(HMH> IHL|$`IGI+HL;H|$hH
)Dl$@H  H\$HHX  (HX   HX  'HX   HtL  L+IHJHtLD$XL+IHJHX  'HX  ~ AH   H33 L$P  I[XA(sA({IA_A^A]A\_^]LWATAUAVAWH  IǃI[IsA)sA){E)CE)KE)SH
 H3H$  HLD  EWW$   Iǃ    IMIǃ    Iǃ    H
HBH+HHueH?$ I3IIHqQ HD$(D$0IHL$( H H$  HQ H$  *HǄ$      $   HBH+HHwiH# H$  3H$  H$  HP HD$(D$0H$  HL$( H H$  HtP H$     H$   A$   WL$8E3LL$HMce`IMt$M;v
H
;M  IHL$8pLL$HE3HT$@LD$8fD  M;  HFH+HH;riH" H$  3H$  H$  HO HD$(D$0H$  HL$(" H H$  H|O H$  HHH$   H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
L  HM+IIHIH+IE3I;LCL;ICHL$8QoLL$HHT$@LD$8H   IH   I;usIH+HHscI+HIH+Hs
H
K X HM+IIHIH+IE3I;LCL;ICHL$8nLL$HHT$@LD$8Ht2HHT$@IH$  h AXD$(WD$PE3Ld$`Mc},MtM;v
H
J  IHL$PEnMH\$XHt$P     M;   H$  *(D$ HD$ H;sDHD$ H;w:H|$ H+HH;\$`u   HL$PGH\$XHt$PHt2HH)H;\$`u   HL$P}GH\$XHt$PHt3HH\$XIY{    HǄ$     L$  Ƅ$   A   HjG H$  iPHǄ$     L$   Ƅ$   A   HH H$  2PEE`EyH$  H$  裁H$  H$  IcU`HL$pILD$xIHT$pH+HHt.Lf     EHLD$xIHT$pH+HH;rIL+IMtDHHD$xH+D$pHH;r   = fD  A;]`5  (    HǄ$(     L$   Ƅ$   A   HF H$  OHǄ$     L$  Ƅ$   A   H F H$  NHcI   L$  HtHL$  HHL$8\6Y0WHǄ$     L$   Ƅ$   A   HF H$  kNL$  HHL$p0H$  H$  H$  AAM`;}    HǄ$     L$   Ƅ$   A   H4 H$  MHǄ$(     L$   Ƅ$   A   H4 H$  MEE(EyH$  H$  H$  H$  IcU(H$  
IL$  IH$  H+HHt+LEHL$  IH$  H+HH;rIL+IMt$fDHH$  H+$  HH;r "   D$h   Dd$ LD$hHT$ H$   ` D$ HT$ H$   Z #   D$    Dd$hLD$ HT$hH$    D$ HT$ H$    $   Dd$ M   HT$ HL$8ݰ D$ HT$ H$   E׍ %    D$hDd$ LD$hHT$ HL$(4 D$ HT$ H$    &   Dd$ M   HT$ HL$P D$ HT$ H$      D$   D$   fD  A;}("  ( *   HǄ$     L$  Ƅ$p   A   H;2 H$p  KHǄ$h     L$`  Ƅ$P   A   HA H$P  JHǄ$H     L$@  Ƅ$0   A   H1 H$0  JHǄ$     L$   Ƅ$   A   HA H$  qJHcL$p  HIMhID  HT$8H}(IM0L$P  HLL$0  HIMhD  HT$pH}(I   L$  HC  HT$PH}AXAY6AXXXHǄ$(     L$   Ƅ$   A   H0 H$  IL$  HH$  40H$  #H$  H$0  H$P  
H$p  
 ,   IMHLD$(H$  贸 D$(HT$(H$   <	H$  HtL$  L+Iz=HT$pHt%L$   L+I[=WD$pL$   HT$PHtLD$`L+I/=HT$8HtLD$HL+I=DT$(HT$(H$   H$   Lw (H$   HtL$   L+I<(H$  H3% L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@1" D($h  H^H+HWL$XLt$hHtHHHH;tgHHHt3{
 HHD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3
 HBHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$X\HVH+HHL$p5ޮ D} D$   =+  fD/i  Y5ͭ $   fD/  HL$pHHtmH$   H+HH;v H    H=   r<t HAH;r H+Hs H'v Hy* HL$0 HL$X HtqH$   H+HH;vi H    H=   r=@tL HGH;r< H+Hs, H'v HH) HtlHD$PH+HH;v H    H=   r<t HCH;r H+Hs H'v HHy) A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI,(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;vt
 H    H=   r<tX
 HAH;rH
 H+Hs8
 H'v+
 H' HL$06	 HL$X*	 HtqH$   H+HH;v	 H    H=   r=@t	 HGH;r	 H+Hs	 H'v	 HHl' HtlHD$PH+HH;vw	 H    H=   r<t[	 HCH;rK	 H+Hs;	 H'v.	 HH& (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(貏HHT$(HPAEHT$(H HHHT$(P HL$(Ht HT$0LD$8HT$(L+I73H\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHHHHT$(HPWD$@Hl$PHT$@H5HLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$HLD$PHT$@L+Ih2WD$@Hl$PHL$(Ht.HT$0LD$8HT$(L+I02WD$(Hl$8H IINF L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
(LP  L8  L0  D  = HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn(U U ,H
H HD$@H HD$PHMF H  E3HT$XHL$@ HD$@HcHHb HD@HD$@HcHhT<HD$XHD$0HL$Xm H HD$X3HEEH HL$PwHcHMh1 HL$PHcQHL$PHHPAHL$P HHvs UwHȋ      HMx HD$0Hs HL$P!wHHu3
H HcHHHD$0HPfAnY^,H2 HHs vH4 (   H HEHL$PvHX  HHT$@PHD$@HcHH HD@HD$@HcHhT<HN HD$XHL$XGHL$X< HL$`y HM/ HX  L0  HLMHU@HPHIo  H  HE@HMH     t5Ǚ  u(H@  HD$ LMI< LII~;   D  D   H
$L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  {)HH$  %W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  HL8HL$pHHLxHL$xHHLxH$   H$    HHL$pHW H$   WH$   诡Hp H$   H$  H H$  H$  H$  H$  H$    $(  (
 )$0  W$@  D$H  Ǆ$L      $P  D$X  Ƅ$\   $`  Ha H$   HT$pH$   $8  f/v	$0  $@  f/v f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H H$   H H$  H$    H$    H$    H$    H H$   HL$p H$   HtL$   L+I{,33HL$pS H$   HtL$   L+II,N   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p$HHL$t W$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   SWD$xH$   LLGIH$   jHHHL$xHHHXH$   HHHXH$   H$   9 HHL$xH H$   WH$   $H H$P  H$`  H H$X  HD$pH$h  HD$pH$p   $x  (
 )$  W$  $  Ǆ$     . $  $  Ƅ$   $  H H$   WH$  L5 L$   L= L$  HT$xH$   N$X  f/v	$  $`  = f/vf/v	$  $  $h  Oȉ$  Y
 (LK $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  sH$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   2 L$   L$  H$p  { H$`  m H$  H H$   H H$X  H$8  4 H$(  & H$   H$   
 H[ H$   HL$x H$   HtL$   L+I&33HL$x H$   HtL$   L+I&N   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  kHH$  {W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   ˿WD$pLLGHH$h  *HL8HL$pHHLxHL$xH$h   HHL$pH H$   WH$   H@ H$   H$  H H$   H$  H$  H$  H$  ( )$   (
; )$0  D$@  Ǆ$D     ș $H  D$P  Ƅ$T   W$X  H H$   HT$pH$   $(  f/v	$(  $0  f/v f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     H H$   H: H$   H$    H$    H$    H$    H H$   HL$p H$   HtL$   L+I"33HL$pf H$   HtL$   L+I\"N   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHٿ
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pHHL$tW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   cWD$xLLFIH$   ½HHHL$xHHHXH$   H$   a HHL$x\H H$   VH$   <H H$8  H$H  Hv H$@  HD$pH$P  HD$pH$X  ( )$`  (
֖ )$p  $  Ǆ$     d $  $  Ƅ$   W$  H! H$   VH$  L5 L$   L= L$  HT$xH$   Q$8  f/v	$h  $@  =( f/vf/v	$x  $  $H  Oȉ$  Y
) (A $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   u L$   L$  H$X   H$H   H$   H H$   H H$@  H$(  g H$  Y H$   K H$   = H H$   HL$x# H$   HtL$   L+I33HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3  H@HHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHM9U H1 H]HL$xHEHL$xHMHT$pLL+t
H= HT$pWEH# WEHE    HMtHHUHPAEHUIBIE HUIP HMHtHU1LEHUL+I}H]HMHEHMHMHULL+tH< EEfEMLHUHM
 D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H   [ +fDnED^n HMwH   HIP ' H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H     +fn^5؎ LM(A(yLM(A(y(A(HM~H HEHM L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CHw
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H9I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  Q II谖  L$   H$   H$   L$   WD$xHt3 HQHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   P H H$   H$   }H$   H$   H$   HT$xLL+t
H{8 HT$xW$   H H$   LMH$   H$   H$   rLMHH$   P" D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I  +fDnED^ Aƅ    A   7 AExH$   rH$   IGIMHH$   P< Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4 +fn^5 L$   (A(tL$   (A(t(A(H$   yH H$   H$     H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   
WD$pL$   LLFIH$  $HL HL$pHHL`HL$xHHL`H$   H$   HHL$pH H$   VH$   H H$   H$  H H$  H$  H$  H$  H$    $(  (
C )$0  W$@  =W $H  $X  Ǆ$P  
   HS H$   HT$pH$   I$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H] H$   H H$  H$    H$    H$    H$    H/ H$   HL$p H$   HtL$   L+I33HL$p H$   HtL$   L+IN   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t
W$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   wWD$xH$   MLFIH$   莯HHHL$xHHHXH$   HHHXH$   H$   ] IHL$x(H H$   VH$  HH	 H$`  H$p  H: H$h  HD$pH$x  HD$pH$  ( $  (
 )$  W$  =Ā $  $  Ǆ$  
   H H$   VH$  L= L$   L% L$  HT$xH$  舀$X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y
% ({. $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  袷H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   y L$   L$  H$x   H$h   H$   H H$   H! H$h  H$H  [ H$8  M H$   ? H$  1 H H$   HL$x H$   HtL$   L+I
33HL$x H$   HtL$   L+I	N   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pLLFIH$h  PHH     HL$pHHH@    HL$xH$h   HHL$pH- H$   VH$   ŽH^ H$   H$  H H$   H$  H$  H$  H$  (8 )$   (
Y~ )$0  =Y{ $@  W$P  Ǆ$H  
   H
 H$   HT$pH$   $8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H H$   He H$   H$    H$    H$    H$    H. H$   HL$p H$   HtL$   L+I33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t
W$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   wWD$xLMFIH$   ֠HHHL$xHHHXH$   H$   u HHL$xpH H$   AVH$   OH H$H  L$X  H H$P  HD$pH$`  HD$pH$h  ({ )$p  (
y )$  =v $  W$  Ǆ$  
   H H$   AVH$  )L= L$   L%C L$  HT$xH$   y$8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
Fw ($ $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   íH$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$     L$   L$  H$`   H$P   H$  H9 H$   H H$P  H$8  | H$(  n H$  ` H$   R H H$   HL$x8 H$   HtL$   L+I. 33HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHg
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H)I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  8 II}  L$   H$   H$   L$   WD$xHt3 HAHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   
7 H H$   H$   mH$   H$   H$   HT$xLL+t
Hk HT$xW$   H H$   LMH$   H$   H$   YLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^q Aƅ    A   y AExH$   YH$   I.IMHH$   P, Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$ +fn^5p L$   (A([L$   (A([(A(H$   `H H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[@SVWH   HD$0Hm
 H3HD$xIHHHD$p   HD$h    D$X A   H HL$XHD$P   HD$H    D$8 A   H HL$8HNH+H*HHLI?LH\$(D$    DHL$85HD$PHrQHHL$8H=   r<t HAH;r{ H+Hsk H'v^ H- HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<t HAH;r H+Hs H'v H HHHHHL$xH3. HĀ   _^[@USVWAVHl$H   HEH
 H3HE'MHHHE   3H]]DCH HMHE   H]]DCH HMHE   H]׈]DCHr HMLt$ LMLHUHMFHEHrPHHMH=   r<t HAH;r H+Hs H'v H| HE   H]E HEHrPHHMH=   r<tp HAH;r` H+HsP H'vC H HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H Hq` HH0Hc` H;T` r
0   HHMHtHLNL+IMC  HHHHM'H3 Hİ   A^_^[]H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtH  uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
sA I   LNB	9^   HII9H3H-U] HLL%R] HL=P] H;1HLH0  HEH?L   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
\  =\ H
K[ ~#H
\ N Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05)g f     IM(W/ Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05if f     IM(Wo Hv;}(|(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_H   "A)(Yf ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YYf Y=`f \A(Y f ^X^^A(\AX(YY\ H$   (De XDvd (\D H$   A(YA(^Wo (YA^A^XX^YWo AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM9  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHKHH@  HEHCHEHLL+t E3EH  D=Fm D5a @ f     H   H HEuIHEI^HGH;t'H;tH# Ht
H^HL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHMU LMHH   HbtAXAY
HuLuI~ uA("HHEIHEHEHEHM7  (A$A(H   YH(  X	f/   fA/r	E   (T
k A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHF D(Y5a A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(] H\$    LMHHo DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(H	
 H3H$X  MMHHH$  H\$ HL$0cH$0  HD$@H$8  MMHH$0    H$0  HL$0HxH$H  HrTHH$0  H=   r<t\ HAH;rL H+Hs< H'v/ H HtHHT$0HPH$   =H$    H$X  H3O H`  A_A^_^[LMCSVWATAUAVAWH  IǃA)sA){H
 H3H$  ILH$   LH$   H$   L$x  L$   H$  H$   IǃP   3IH@$  DGH I8HǄ$X     H$P  @$@  DGHl H$@  HǄ$x     H$p  @$`  #  MA.H  H$`  FEF AG D;t"D$ L$  H$@  H$`  8H$x  HrTHH$`  H=   r<tR HAH;rB H+Hs2 H'v% H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<tԺ HAH;rĺ H+Hs H'v Hv HǄ$X     H$P  Ƅ$@   H$  HrTHH$  H=   r<tV HAH;rF H+Hs6 H'v) H HǄ$     H$  Ƅ$   A   H H$  HǄ$X     H$P  Ƅ$@   A   H H$@  KHǄ$x     H$p  Ƅ$`    MA.H H$`  
HCEG D;t#HD$ L$  H$@  H$`  *MH$x  HrTHH$`  H=   r<t HAH;r H+Hs H'v H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<t HAH;r H+Hsw H'vj H9 HǄ$X     H$P  Ƅ$@   H$  耵Ic_ WD$`Ht3> H~HHD$`HL$`H\$hW($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$`H$8  HHH+HHHHH~'fD  f)HH;}$  HL$8LH$    Ic_ WD$HHt3l H謘HHD$HHL$HH\$P($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$HH$8  HHH+HHHHH~(    f)HH;}$  HL$8LH$    Ic_ W$   Ht3 HٗHH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$   / Ic_ W$   Ht3 HHH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$   O Ic_ WD$xHt3ܳ HHHD$xHL$xH$   ($   H$   H$   H$   H$   H$(  HD$0H$0  HD$xH$8  HHH+HHHHH~2@ ff     f)HH;}$   H$   LH$   l D|$8|$p5U      $p  D;  DA  ~6H H$   M(( 3AHvE;w |H$   L$   H$`  IHHL$xHHT$xHPH$   HHH$   H$`  Z H$   ľH$`  H$   H$0  H$   L$   L$  HT$xH$   a H$   H$   ܼHXH$   HtHH$   HPH$0  H$8  E33H$   A   H H$   	H$  H$  E33H$  V MA.H H$  L$   H$   H$  H$  FH$   8L$   L$   HL$`H$  H$  H$   H$   H$(  HD$XH$0  HD$`H$8  LL$hIHH+HHHHH~, (fAX)HH;}L$   H$  MH$   Gm LD$HLD$8L$   L$  L$   L$  HL$HH$@  H$@  H$   H$  H$(  HD$1H$0  HD$8H$8  LT$PIHH+HHHHH~B     A(fAY(fX)HH;}L$  L$  H$@  MH$   v8 ADd$8H$  聺H$  S ]3Dd$8WL$   H$   H$   L$   H$   fn($@  HL$`H$  H$  H$   H$@  H$(  HD$1H$0  HD$`H$8  LD$hIHH+HHHHH~<@ f     (f(f^)HH;}$@  H$  H$    $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  HD$HH$8  LD$PIHH+HHHHH~5fD  (f(f^)HH;}$@  H$  H$   d HD$HHD$8HL$HH$  IOH$  IWH9T$PtA   HL$8W HD$8HH$@  H$@  H$   H$  H$(  HL$1H$0  HL$8H$8  LpIHH+HHHHH~FH$  ()$`  H$`  ~	H$  (fYH$@  )HH;|MHH$   R HD$HH$   $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  H$   H$8  LD$PIHH+HHH~=@ ff     (f(fX)HH;}$@  H$  HH$   qk HT$`H$   ?HT$HH$   -HL$x H$    H$    HL$H HL$` H$  H3 ($   ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
  HM1LM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHM LMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHM LMHMLEHtHHLMLEHMHHMHHcI;F}!H
` * H
R  WEHE    LEHUI[  (HMH   HEH+HH?H;v H    H=   r<tש HAH;rǩ H+Hs H'v Hy WEHE    HMHthHEH+HI;vr H    H=   r<tV HAH;rF H+Hs6 H'v) H (L\$pI[ Is(I{0Mc8(t$`IA_A^]LMCSVWATAUAVAWH  IǃA)sA){Hs
 H3H$  IHH$   LH$   H$   L$8  L$   H$@  H$   IC   3I{@$  DGH IxHǄ$8     H$0  @$   DGH H$   HǄ$X     H$P  @$@   MA-Hy H$@  lDF(AG(D;t"D$ L$  H$   H$@  $H$X  HrTHH$@  H=   r<tx HAH;rh H+HsX H'vK H HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<t HAH;r H+Hsڦ H'vͦ H HǄ$8     H$0  Ƅ$    H$  HrTHH$  H=   r<t| HAH;rl H+Hs\ H'vO H HǄ$     H$  Ƅ$   A   H H$  HǄ$8     H$0  Ƅ$    A   H6 H$   qHǄ$X     H$P  Ƅ$@   M MA-H= H$@  0HCEG(D;t#HD$ L$  H$   H$@  P9H$X  HrTHH$@  H=   r<t; HAH;r+ H+Hs H'v H HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<t HAH;r H+Hs H'v H_ HǄ$8     H$0  Ƅ$    H$  覡Ic_(W$   Ht3a H衅HH$   H$   H$   W($`  HL$PHD$PH$   H$`  H$  HD$0H$  H$   H$  HHH+HHHHH~.@ f     f)HH;}$`  HL$PLH$    Ic_(WD$8H|$HHHt5HHHH;tHtHHHH;tLLLLIHL$8ޟ|$PHD$@H;u
LD$HL;t:HtHHHH;txLLIHL$8蔟LD$HHD$@HL$8H$`  H$h  H$`  H$   HT$PH$  HT$0H$  HT$8H$  LIHH+HHHHH~"D$Pf)HH;}
H$`  H$    Ic_(WD$`Ht3 H_HHD$`HL$`H\$h(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$`H$  HHH+HHHHH~+ff     f)HH;}D$PH$`  LH$    Ic_(WD$pHt3L H茂HHD$pHL$pH\$x(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$pH$  HHH+HHHHH~(    f)HH;}D$PH$`  LH$    Ic_(W$   Ht3y H蹁HH$   H$   H$   (|$PH$   H$   H$   HD$PH$  HD$0H$  H$   H$  HHH+HHHHH~)     f)HH;}D$PH$   LH$    D|$4$   5@      $0  D;C  DA( ~+H H\$pM((  AHvE;w(|LD$pH$@  IHH$   HH$   HPH$   HHH$   H$@   H$   lH$   H$   H$  H$   LL$`L$`  H$   H$   	 H$   H$   脨HXH$   賛HtH$   HH$   PH$  H$  E33H$   6A   H H$   H$p  H$x  E33H$`   MA-Hr H$`  eLD$`H$   H$`  誎H$`  H$   ޚLD$`L$  H$   H$   H$   H$   H$  H$  HD$1H$  H$   H$  L$   IHH+HHHHH~, A(fX)HH;}L$  H$   MH$   X A( U  L    LM0  MYICH   A   IHT$@IHL$8HD$`BHD$pBYXIRHT$@IHL$8HD$`BHD$pBYDXIHT$@IHL$8HD$pBDHD$`BYXIRHT$@IHL$8HD$pBDHD$`BYXIIM;&M;9IHT$@IHL$8HD$pBHD$`BYXIM;~IA;_(ADd$4H$  蠥H$  r 3Dd$4WL$   H$   H$   L$   fn($   H$   H$  H$  H$   H$   H$  HD$1H$  H$   H$  L$   IHH+HHHHH~:fff     (f(f^)HH;}$   H$  H$   4 $   HL$8H$`  HD$@H$h  H$`  H$   H$   H$  HT$1H$  HT$8H$  LD$HLIHH+HHHHH~4D  (f(f^)HH;}$   H$`  H$   t IwMwHT$8L\$@HD$HH$   L$   H$   L$   I;IMLL$   I   I@H$   MfIMkIO6OLHMIIHH$    (A^XJIHI(^DXDDJJ(^DXDDI>I(^DI;IXDDHJ    LJ    LIMH;$   H$   XL$   I;}BN   N4   HIHHIHL+(^X  IIIuH$   H$   tHT$8H$   RH$    HL$p HL$` HL$8ז H$   Ȗ H$  H3  ($  ($  H  A_A^A]A\_^[H   HD$ HH$     HHL$(  HK%
 HL$(W @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@r  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQH k HC(HCH;CuHHCHC H0[@SH H@  HC HC`H [HL$SH0HD$ HD$P    EtH HAPH HA`D$P   J   H HHɒ HC(HCPHcHH HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHH> HHQ3HHBHO̓ Hm HHGHFHG HF H^(H\$HH HHO0HKHtHPHG8HCHG@HCGHC H?{ HHe HHH\$PHt$XH0_H\$WH HH HHQ3HHHKHB H HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tHF Ht
HuHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@  IFL\$`I[(HEIF HE HIk0IA^_^@SH H HHH HAhHIH` HK8V HK L HKB H HH [@SH H HHHV HA`HIH  HK8 HK  HK H3 HH [@SH H HHH^ HAhHIH HK8 HK  HK HӃ HH [@SH H HHH HA`HIH@ HK86 HK , HK" Hs HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3RHW(HK(HA   HA    HyrHH  IE3HH\$HH0_@SH H  H3 HCPH [HL$SH0HD$ HD$P    EtHV HA@H HAPD$P   J   Hcz HHя HCHC@HcHH.~ HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH. HHQ3HHBHK H| HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C Hy HHpw HHH\$PHt$XH0_H\$WH H<:  H HG`t
h   Hw HH\$0H _@WH0HD$ H\$@HHu HH. HA(HI0HtHP tHC0    H HHK @t
P   H HH\$@H0_H\$WH H  H HGPt
X   H跬 HH\$0H _@WH0HD$ H\$@HHx HHn HAHI HtHP tHC     HH HHKS @t
@   H8 HH\$@H0_LH   ICAC    HQH ICH( ICAC   IK{Hw HD$(H  HD$@HD$hHcHH[{ HDhHD$hHcHDd    H
 HL$( @SH0HD$ HٹX   L HD$@HSHD  HHtH@@HcHHB@HH0[@SH0HD$ HHv HHE HAHA@HcPHz HD
@HA@HcPDBDD
<Hv HHˊ HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HHv HHe HAHI HtHP tHC     H? HHKH0[H%D HVWAVH`H@HXHhHFW
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHKi HD$(f HHL$ YtHC    HL$ jHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
Gs H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHC  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HB  HL$8HL$(HtHPHtL    HA2HL$XH3ՠ L\$`I[(Ik0IA^_^HVWAVH`H@HXHhHFU
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK d HD$(a HHL$ TtHB    HL$ hHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
Bq H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHB  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2HA  HL$8HL$(HtHPHtL    HA2HL$XH3О L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH?  (HHk HH_(H    H HHH H; rHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HH HHH H; rBHHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   [   ^   ,A;ALǉ   LCHSHH  ktUHH@        ^,A;ALǉ   Y& t    H   H   HH\$PHl$`Ht$hH0A_A^_@SH H HHH6r H   Hp  j H`  ] H  yH{ HH HC`HKH2 HK8( HK  HK Het HH [Wf/v(      ^   ,;L   H\$WH HHH   HQ{H   HB{H   HH\$0H _){HHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J>  HSH^H_HG`LGpHHO`P8LHHO`HHL$@s(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;va$ \( (=B" f/vNHOxf/v?HD$@H;t5HKHT$HD$hC(HKHT$XlHK0HT$p^]s(HHO`Y  X   w0H} I$I\$H$   HOaHHHGHCHWHGLL+t W5L, At$A|$ HL$p[ HL$XP HL$HE IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   TW   ^   ,A;ALǉ   LCHSHH  _`tUHH@J        ^,A;ALǉ   Y{!     H   H   HH\$PHl$`Ht$hH0A_A^_@SH H;j HHH^z H   Hx  } Hh  } H   {H} HHPy HChHKH} HK8} HK ~} HKt} Ho HH [Wf/v(      ^   ,;L   H\$WH HHH   HvH   HvH   HH\$0H _vHUSVWATAUAVAWHhH(  HE)p)xD)@HH
 H3HEMILH3t$8G  HSHH_HGhLGxHHOhP8MHHOhkHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PDL DD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(D$0HHD$0H#H      H;v| \( (=] f/vLH   f/v:HEH;t1HKHUEC(HKHUHK0HU{]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(   w0Hix IE I]H\$0HO\HHHGHCHWHGLL+t W58' AuA} HMJz HM@z HM6z IHMH3o L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   ARLGHWHH  -bt8HH7     Y     H   H   HH\$PHl$`H0A^_^@SH Hst HHHm H   Hx  x Hh  x H   	wHbs HHw HC`HKHx HK8x HK x HKx Hj HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(6n(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_mH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@ HL$0w L$   HHH$   ($   HĠ   _Hl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]XF ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3v HDXHHkHF@HD$hHFHD$xHv H;t'H;tHu Ht
HXHH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@ HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Y  H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWY H   H	H H$   HD$@H$   H$   H$   H$   ܯ Yd H   Wf/v f/v   Wf/v   H\$WH HH5  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHlfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   H蒢HSHt
HHH
HJ$H;Cu
   HfHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HڡHCHt0HH   HCH;s;HH;w3H+HH;Cu
   H藡HSHt
HHH
HB&H;Cu
   HkHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    -  HSII^IF`MFpHIN`P8MHIN`HHM:	HUH   )	HUHM0	HUH   
	IF`LHUIN`P(HMMRHE HMHM(HULL+tHX HM#RHEHMHMHULL+t	H. IN(QHD$xIN(HMIV LL+t	H EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      D D D%) D- H}WD$hHt3n H>QHHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM貘 DUINxfA/  HEH;   HcuH;st$HKn tHZPHCHC    Hs~LEN    HUHKW EC(Hcu H;s t$HKm tHPHCHC    Hs ~LE N    HUHK HcuHH;s8t$HK0sm tHOHC0HC0    Hs8~LEN    HUHK0謽 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I/  HEH;  HSHM7C(EHSHM HM   H   H;t=HKH      C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I.  H   H;t=HSH   SC(   HSH   6H   HS0&@  A   uf/w(\ (INxf/v=H   HM8   EXH   HMHH   HM`f/v\(X(\((XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHM]' HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$hi A   A9   HL$hi Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0W IV(HFHL$xi HMh HM h HMh H   h H   h H   h HM`h HMHh HM8h H   h H   h H   rh HMgh HM]h HMSh HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   Q@LGHWHH   }It8HH^3     Y
     H   H   HH\$PHl$`H0A^_^@SH HU HHH H   H  
g Hp  f H(  eH HHb HChHKHf HK8f HK f HKf HY HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(F\(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_\H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@  HL$0-e L$   HHH$   ($   HĠ   _*HWH   H@HXHhHp )pIHHz W@Ht3d HFHD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrC  H$   H$   HD$8HD$(HD$@HMHT$8$ HL$H0d HL$($d L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3c HEHHoIvHH;t'H;tHc Ht
HEHHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   B HIFHD$pHD$x   INHIF@H$   H$    D$0HT$ LL$pL$   IVP
 HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   Y` H$   \(t$pHĀ   _   LH   H-
 H3H$   HB LB$ IKICH@D$@ICISISMCMCIC  HD$h H$   H3x HĘ   Wf/vO f/v   Wf/v   H\$WH HH+1  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHwZfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H蛐HSHt
HHH
HB$H;Cu
   HoHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HJ$H;Cu
   HHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H膏HSHt
HHH
HB$H;Ku
   HZHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HHSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w)  HSIKI^IFhMFxHINhP8MHINhHHMHUH   HUHM0HUH   IFhLHUINhP(HM?HE HMHM(HULL+tHح HM?HEHMHMHULL+t	H训 IN(x?HD$xIN(HMIV LL+t	H肭 EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      D D" D% D-  H}WD$hHt3~\ H>HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM2 DUI   fA/  HEH;   HcuH;st$HK[ tH=HCHC    Hs~LEN    HUHKԫ EC(Hcu H;s t$HKB[ tH~=HCHC    Hs ~LE N    HUHK{ HcuHH;s8t$HK0Z tH,=HC0HC0    Hs8~LEN    HUHK0) Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I+  HEH;  HSHMC(EHSHMHM   H   H;t=HKH   x   C(HKH   [HK0H   KLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I*  H   H;t=HSH   C(   HSH   H   HS0@  A   uf/w!(\薩 (I   Mf/v=H   HM8W   EXH   HMH:H   HM`*f/v\(X(\(s(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$hDW A   A9   HL$h#W Hx  D$`A   fn}^HE0H;t1HKHU8bEXC(HKHUHKHK0HU`>s(HINhXA   AV0Ws IV(HHL$xV HMuV HM jV HM_V H   QV H   DV H   7V HM`,V HMH"V HM8V H   
V H   U H   U HMU HMU HMU HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQHU ICHHJ ICAC   IKHp HD$(HS HD$PHD$xHcHHF HDxHD$xHcHDt    H	 HL$( @SH0HD$ Hٹh   lo HD$@HSH.  HHtH@PHcHHBPHH0[@SH0HD$ HHp HHMR HA(HAPHcPH2F HD
PHAPHcPDBDD
LHm; HHR HA(HI0HtHP tHC0    H\ HHKH0[H%S @SH0HD$ HH; HHR HA(HI0HtHP tHC0    H_\ HHKH0[H%dS @SVWH   HD$8Hm
 H3H$   IHHI @D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   H6 HL$@脌HD$x   HD$p    D$` A   H HL$`UHD$@HD$ LL$`LHH'lH$   H3i HĐ   _^[HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  D fA/  HGPLG`HHOPP8MHHOPH](HGHLd$ _xLGPHHOHH7EPHHEPH#H      D H;vA(\Q  D(ȃ   f/GLcD D  HD$pH;t2HKHT$xEC(HKHUHK0HUHGPLG`HHOPP8MHHOP#HsHt$8H~ u(HHD$PHD$0HD$`HL$H2 (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$H]2 AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$xJEC(HKHU3HK0HU&   HRX HD$03HD$8HD$@Hb HD$HD$PHT$8HL$HN HG HD$0HU	 HL$0ay HW HD$03HD$8HD$@H۔ HD$HD$PHT$8HL$HqN HJG HD$0H	 HL$0
y HMN HMN HL$xN L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PHA HA@HHC HAPD$P   H8 HHOHI@ HHG@HcPH7A HD:@HG@HcPDBDD:<HSHHD豈HH\$HHt$XH0_H( T f/ w*. Tj f/ w HB
 H(H% H
F q: H H
2 ]: H(
4 \ T  f/8 w2
 v qT f/ wH
 H(H x3  H k3  HL$H(? LD$0HT$8Ty f/ vM  "    LD$0HT$8TE f/} vUM  "    LD$0HT$8xT f/I v!M  "   H
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuHIHSHt7HHH
HCH\$0H _H;CuHiIHKHtHHHCH\$0H _H\$WH H\t
  Hi HH\$0H _H\$WH HOD HHHH HA`HIHJ HO8J HO J HO|J H< Ht
   H i HH\$0H _H\$WH H<t
  Hh HH\$0H _H\$WH H'J HHHE HAhHIHI HO8I HO I HOI H
< Ht
   H`h HH\$0H _H\$WH HLt
  H"h HH\$0H _H\$WH HC HHHpG HA`HIHI HO8I HO I HOH HM; Ht
   Hg HH\$0H _H\$WH H|t
  Hbg HH\$0H _H\$WH Hc HHHD HAhHIHZH HO8PH HO FH HO<H H: Ht
   Hf HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PH; HA@H< HAPD$P   H'2 HHOHG HHG@HcPH5 HD:@HG@HcPDBDD:<HSHHD!HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt3D H&HEH]WEHt3D H&HEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軻(HMC HMC (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9HxY \ Y   X Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`   EWfA.z  D
 fA/  HG`LGpHHO`P8MHHO`ןs(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      DK H;vA(\ 近 D(   f/GHcD%z HD$`H;t3HKHT$hbEC(HKHT$xJHK0HU=HG`LGpHHO`P8MHHO`̞s(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$h8EC(HKHT$x HK0HU   H?H HD$H3HD$PHD$XHO HD$8D$@HT$PHL$8> H7 HD$HHB	 HL$HNi HG HD$H3HD$PHD$XHȄ HD$8D$@HT$PHL$8^> H77 HD$HH	 HL$Hh HM> HL$x> HL$h> L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pHE

 H3H$P  HHHL$0J   H" HL$@(H(T< H$0  HL$0HLHHAPH$H  HrUHH$0  H=   r<t> HAH;r> H+Hs> H'vz> HI\ H$   HH$   m< H$P  H3T H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   Wf/vH0   X (z H0  X  H;t/HSHN?HC(HF(HSHN*HS0HN0LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h: HHEHsH   HCH;t'H;tH: Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h  H       D  HY(WEHt39 H4HEH] = } H  H[WEHt39 HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hwc    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0i}H  L@LEWEMt3W8 HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMb H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\((Xu \	(XuuHUH(  HEf/w"\{ (H   Hx.f/vHE0H;tHU0HWEH]HHt36 HLHEH]LEHuHEHEHEHEH;t-Id6 HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   0HM5 HM5 HM`4 HMH4 HM84 HM4 HM4 L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9H轑Y \] Y   XM Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH	 H3HELHHyHHL$@   EWfA.z\  D
x fA/H  HFhLFxHHNhP8MHHNh蔑w(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      D H;vA(D\ w (   fD/GLcD2 fHD$@H;t5HOHT$HD$hG(HOHT$XHO0HT$pHFhLFxHHNhP8MHHNh耐LGI@H_@HEDELEH]LEHEHEHUHM)  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM˚  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H苲D$hG(HOHT$XrHO0HT$pd   H9 HE3HEHEHv HD$0D$8HUHL$0
0 H( HEH	 HMZ H?9 HE3HEHEH"v HD$0D$8HUHL$0/ H( HEHG	 HMTZ HL$p:0 HL$X/0 HL$H$0 HMH3`G L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pH	 H3H$P  HHHL$0<   Hp HL$@舢H(- H$0  HL$0J:LHHAPH$H  HrUHH$0  H=   r<t0 HAH;r/ H+Hs/ H'v/ HM H$   9H$   - H$P  H3
F H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\~H(  X \(eXH(   Wf/vH0   XZ (} H0  X  H;t/HSHN蟮HC(HF(HSHN芮HS0HN0}LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hb  HMHLHT$hP(HH   HHHHPHKHHHSHL$h:, HHEHsH   HCH;t'H;tH, Ht
HLHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$hK  H       D  HY(WEHt3T+ H
HEH] = } H  H[WEHt3+ HW
HHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hT    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt3) HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMwS H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(|(Xu \i(XuuHUH(  HIEf/w"\x (H   H莅f/vHE0H;tHU0HWEH]HHt3' H?
LHEH]LEHuHEHEHEHEH;t-I' HtH	LHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM{ LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   "HMl& HMa& HM`V& HMHL& HM8B& HM7& HM,& L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH;& HAPH HA`D$P   H'A HHO(Hi# HHGPHcPHO HD:PHGPHcPDBDD:LHS(HHD`HH\$HHt$XH0_HL$HHO LL$P)t$0LD$X3)|$ 5 = Tf/   7 LL$PLD$X3Tf/    LL$PLD$X3Tf/    LL$PLD$X3Tf/   - LL$PLD$X3lTf/    LL$PLD$X3FTf/ws(t$0(|$ HHHh H
 X  Hh H
W  Hh H
W  Hh H
W  Hoh H
W  H[h H
W  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	h# Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@詊  IVHO   L\$`HI[Is I{(IA^H\$WH H  HHA`HIH" HO8" HO " HOv" H Ht
   HA HH\$0H _H\$WH H HHAhHIH$" HO8" HO " HO" HW Ht
   H@ HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	! Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@و  H\$xHH$   H`_@SH0HD$     HHt  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH?  Ht
HzHL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ e  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8 (fo IHFHMEHEUHMHME0HuMH] E H](M@fo
B fEPU`Mp  Xf/FvFHHI;L$8  IHN Ȑ  ID~DHN0HLN@HLF0A   HV   H$@  FDHAD~HH   A_A^_^] wH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _ HH HH H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMH HHEHE   HE    E A   HP HMVHE0   HE(    E ; uE3IIB< uHHMUHEP   HEH    E8 A   H HM8U3fff     H}H;   H+H   HHuH}HCuHH   LǺ%   HF HH   :
͋ uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
4: A   HHMPH)IE3HUHM8eYA   Hd HM8WIHMX  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H HH    :E uC:: uC:/ u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMOIIE3HUHM8XHE8H}PHCE8H
" HL$03HL$8HL$@HD$HD$PHT$8HL$H H HD$0HT$0HM5 HHL$` H	 HL$`C HUAVAWHhH@  HD$XHXHpHx H9	 H3HE8L=۷ HLEHE   E3LuDuEF"HP HMRHE0   Lu(DuEFH HM`RA@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH    :e uC:Z uC:O uAtH+HHHsHEH}HCEH+Ht+HD$    L
6 A   HHMMH(IE3HUHMVA   H HMTA? tI@ IC<7 uMIHMTHEH}0HCEH
J  HL$03HL$8HL$@HD$HD$PHT$8HL$H Hh HD$0HT$0HMm HHL$` H	 HL$`DA @SH0W)t$ f/Ȼ   (vW5 (g  (,t
Xʃ\
(\(f/
C v\(Y
B (bg fnY(t$ YH0[Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v(f W   fD.z  f.zv  D)T$ Dn fA/L  D
 fA/r4Dz ff     AX(yf fA/XsD(E\}
 eH%X      HЋ9ު
   X5 A(AYAY((YԤ
 (YѤ
 Y
 X
 X
 X
a
 YYYXu
 Xu
 X
-
 AYYYXH
 X
 
 X(Y
 AYX
 YX
 YXX
 ^YY5 X  D fD/v(Ee E(\D(AXL
 eH%X    f/ƹ   HЋ   9
 h  A(A(AYAY((Y=
 (Y:
 Y
ʧ
 X
 X
 X
 YYYXޤ
 Xޤ
 X
n
 AYYYX
 X
A
 X(YZ
 XB
 YX&
 AYX^YY%% X   9
 )  EYDWK A(AY((Y
 (Y
 Y
A
 X
 X
 X

 YYYX]
 X
 AYYX(Y
 X
 X%
 Xř
 YX
 AYX^AYDY
& AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
§
 + =
 ( H
 (
{ 
 (M 
  
 ( 
p
 (
 )
 ( )
 (
 )
 )

 * UH

 -+ =
 (] H
 (
 
 (1 
 
 
 (# 
|
 (
e 
 F 
 (
 
 
 @* H
 * =
 (/ H
 (
 Z
 ( l
 ( 
N
 (
 З
   
 (
 җ
 
 ) IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
 A(.  a f.zuR z  !      f/   (LW Hh((Y(T
߼ fD/vlY
  f/vVfA.zu3(H       $   H$      E fn "   Y S  4 ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ _ f.(   u~ f/vpH      $   H$   H#H;  fA/s(t_ (f/Ӳ   
 f/  ,H Y<Z   f/v: f/vz =  "   D^D\
& AY  H$   }Dί D(DX
Q YE\A(^ 
Ǳ Yf/   AYf/wBAYA(\5U (^ (A(^  (^^Yf/vvfA.zu3*H       $   H$      EË fn "   Y (A\A((^ (A(] ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   HQ H
wD z} L$   HQ H
cS ^} H\$D$WH`)t$PI)|$@H(D)D$0װ f/ro(A] f.z  (m(Wf/[ WvW ] D(E3(LHqD\(\ D\   f/vfWf.z0   (
 Tf/v\ D(DWи     ^\ Tu\ D(    f/v$((\
 \
 (  D(of/= r! f/v(d  \ D(DHL$p{ \ D((X[ \ì [ \F \= YDXH\$xA(D(D$0(t$P(|$@H`_LD$pHR H
+   LD$pH H
   H(Y LL$0LD$83ô(T
y f/
 w
Y H(H3O H
t>   H(Y, LL$0LD$8c(T
 f/
Q w
Y H(HN H
4>   H\$D$WH`)t$PI)|$@HD)D$0(D D)L$ A(EWfD/   `Z f.zZ  T f/ru(LWy H((fY(T
H fD/vY
y  f/   ^fA.    A(  fD/v ff     ^AXfD/wt$p(Y f.(   u~c f/vpH      $   H$   H#H;  fA/s(=Y (f/   
V f/x  ,H Y<   ͨ f/v*W f/Z  D^D\ AY   HL$pwD
 D(DX- YE\A(X 
 Yf/vVAYf/  AYA(\51 (X (A(_X ͫ (^^Yf/v&   A\A((DX (A( X ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pH H
/ b  HB H
 .  LD$pHK H
> w LD$pHK H
qM lw H,> H
հ   HH H
   Hd H
   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3s HHD$(Hl$0HT$(H蜙  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"H Ht
HCHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H Ht
H+HH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;t\]HtHHHH;t?]HHHHGH;t"H Ht
HHH    H_H_HHL$8 HL$(_ H$   H`A_A^A]A\_^]@SH Hru  HH [@SH0HD$     t  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH) HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIM7MwMwLuIzHHϰWD$@HD$P    E3E3HT$@HjL\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uHȯHHF)L;t$HV) HHVH袯H~H$`  H$P  HHHI$I$H;uIT$H;uH'I$ID$'H;t"LIT$
* HIT$HI\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W-ڬ 3MtlA(Y5g (Y=\ D(D\D
ң D! HfE/v((; AYA(((S IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  LLD$XHT$p LHH
L;   IH   IW赭MIOI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'vs LI? I?IIHIHCIGHCIGH;H{H{HL$pH   HT$xH$   LD$pI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'v LIo H$   HtwH$   H+HH?H;ve H    H=   r<tI HAH;r9 H+Hs) H'v H HL$XHttHD$hH+HHH;v H    H=   r<t HAH;r H+Hs H'v Hm H   HT$HHHD$PH+HHH;v] HH=   r=@tD HEH;r4 H+Hs$ H'v HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]LWATAUAVAWH  IǃI[IsA)sA){E)CE)KE)SH	 H3H$  HLHL$(D WD(W$   E3MIMMMH
HBH+HHueH I3IIH1 HD$0D$8IHL$0N H' H$  H0 H$  HǄ$      $   HBH+HHwiHQ H$  3H$  H$  H0 HD$0D$8H$  HL$0 H H$  H0 H$  8   H$   A$   WL$@MLl$PMcz`IMt$M;v
H
,  IHL$@9PLL$PMHT$HLD$@    M;  HFH+HH;riHX H$  3H$  H$  H/ HD$0D$8H$  HL$0 H H$  H/ H$  ?HHH$   H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
+  HM+IIHIH+IMI;LCL;ICHL$@NLL$PHT$HLD$@H   IH   I;usIH+HHscI+HIH+Hs
H
.+  HM+IIHIH+IMI;LCL;ICHL$@dNLL$PHT$HLD$@Ht2HHT$HIH$  >DX^H XD$0WD$XILl$hLT$(Mcj,Mt$M;v
H
* I IHL$XMH|$hE3H\$`Ht$XM;  H$  (D$ HD$ H;   HD$ H;   Lt$ L+IH;utHH+HHsdH+HIH+Hs
H
)  HSH+HHHIH+HE3H;LCL;ICHL$XMH|$hH\$`Ht$XHt5JH,H;u   HL$X&H|$hH\$`Ht$XHt3HH\$`Iq
    HǄ$     E3L$  D$  ED$H& H$  /HǄ$     L$   D$  ED$H' H$  g/Lt$(EF`EyH$  H$  `H$  H$  IcV`HL$pILD$xIHT$pH+HHt.Lf     EHLD$xIHT$pH+HH;rIL+IMtDHHD$xH+D$pHH;r   = fD  A;^`5  Xp
    HǄ$(     L$   Ƅ$   A   HK% H$  F.HǄ$     L$  Ƅ$   A   H0% H$  .HcI   L$  H褛HL$  HHL$@茛6Y0WHǄ$     L$   Ƅ$   A   H$& H$  -L$  HHL$p50H$  $H$  H$  AAN`;}o
    HǄ$     L$   Ƅ$   A   H H$  -HǄ$(     L$   Ƅ$   A   H H$  ,EF(EyH$  H$  <^H$  NH$  @IcV(H$  ?IL$  IH$  H+HHt+LEHL$  IH$  H+HH;rIL+IMt$fDHH$  H+$  HH;rm
 "   D$(   Dd$ LD$(HT$ H$   萍  D$ HT$ H$   m
 #   D$    Dd$(LD$ HT$(H$   J  D$ HT$ H$   Dm
 $   Dd$ M   HT$ HL$@
  D$ HT$ H$   um
 %   # D$(Dd$ LD$(HT$ HL$0d  D$ HT$ H$   ,l
 &   Dd$ M   HT$ HL$X'  D$ HT$ H$      D$   D$   fD  A;~("  Xl
 *   HǄ$     L$  Ƅ$p   A   Hk H$p  F*HǄ$h     L$`  Ƅ$P   A   H! H$P  *HǄ$H     L$@  Ƅ$0   A   H H$0  )HǄ$     L$   Ƅ$   A   H  H$  )HcL$p  HINhy#HT$@H](IN0L$P  HLL$0  HINh>#HT$pH\(I   L$  H#HT$XH\AXAY7AXXXHǄ$(     L$   Ƅ$   A   H H$  (L$  HH$  d0H$  SH$  EH$0  7H$P  )H$p  6j
 ,   INHLD$0H$    D$0HT$0H$   lH$  HtL$  L+IHT$pHt%L$   L+IWD$pL$   HT$XHtLD$hL+I_HT$@HtLD$PL+ICDT$0HT$0H$   H$   |V  (H$   HtL$   L+I(H$  H3 L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHHVH+HL$   Iz3HFH+HH   $   D(DXL%;HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;v H    H=   r<t HAH;r H+Hs H'v H
 L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHLB(W$   LKL+IL$   IIGMH$   HD$ MH$   IiHSH+HHL$P@WD$8HD$H    LCHHL$8輒3HKH+HHT$8H  L5I HIL43 HBX LL$PMHT$8IT3HCH+HHl$PHtvMHCP YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8LH -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;vf H    H=   r<tJ HBH;r: H+Hs* H'v HH HtmHD$`H+HH;v H    H=   r=@t HEH;r H+Hs H'v HHv (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  HP	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@z>HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
 U HQM+IIHL+IHM;HCH;HCHL$@=HL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
  HQM+IIHL+IHM;HCH;HCHL$@/=HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   
LFLL$`I{^  H$  H$   UHXH$  HtINHH$   PHt$hH\$`H~&Hfff     HHL$@HcH;|IHHT$@PH$  H$   H!H$  H$   HL$` HT$@HtLD$PL+IH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH'	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  K  IIЯL$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   J  H H$   H$   -H$   H$   H$   HT$xLL+t
H+3 HT$xW$   H H$   LMH$   {H$   H$   vmLMHH$     D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IR +fDnED^e Aƅ    A   92 A   H$   mH$   I話IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5 L$   (A(oL$   (A(o(A(H$   =tHu H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  F  II耜L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   E  H H$   H$   H$   H$   H$   HT$xLL+t
H. HT$xW$   H H$   LMH$   kH$   H$   fhLMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IB +fDnED^U Aƅ    A   )- A   H$   yhH$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIs +fn^5 L$   (A(jL$   (A(j(A(H$   -oHe H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HɼI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  A  II谥L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   @  H H$   H$   
H$   H$   H$   HT$xLL+t
H) HT$xW$   H~ H$   LMH$   [H$   H$   VcLMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^E{ Aƅ    A   ( A   H$   icH$   I艧IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIc +fn^5yz L$   (A(eL$   (A(qe(A(H$   jHU H$   H$   w  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I~ Ht
H蹷I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  <  II`L$   H$   H$   L$   WD$xHt3 HѶHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   ;  H H$   H$   H$   H$   H$   HT$xLL+t
H# HT$xW$   Hn H$   LMH$   KH$   H$   F^LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I" +fDnED^5v Aƅ    A   	# A   H$   Y^H$   IٓIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIS +fn^5iu L$   (A(u`L$   (A(a`(A(H$   
eHE H$   H$   g  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
 l H!HHCHHHHKLHT$`HL$X  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
  H
)HHGHHH_LHT$`HL$X6  HGH\$hH@_@USVWAVAWHl$H   HEH	 H3HEIIHL
GI
 eH%X      LE3B
9h
 ~^H
h
  =h
 uIHd
    L=d
 D=d
 EGH{ H
d
 H
6  H
h
  HE   L}E A   Hz HM^LHUH
_d
 :{HMHE   L}E A   Hz HMLHUH
d
   HMHE   L}E A   Hz HM; oHE   L}E A   Hs HMHE   L}E A   H, HMHEHD$ LMLHUH
wc
 HMHE   L}E A   Hy HM2HE   L}E A   Hy HMHE   L}E A   Hy HMHMHMHMvWeHEHEH}fn2o ^HfnH\Y(YYwn (\Y\eIHMG:  IHMH3 H   A_A^_^[]HUSVWATAUAVAWHhH   HD$0)p)xHv	 H3HEMMHH
)F
 eH%X      L3B
9wd
 ~]H
nd
  =bd
 uHH}b
    Hnb
 Xb
 DCH}x H
Fb
 H
  H
d
  HGH+H  W(HE   H]E A   H<x HM+LHUH
a
   HMHE   H]E A   Hx HMMHUH
a
   HMyHE   H]E A   Hw HMA$f/woHE   H]E A   H9  HMpHE   H]E A   H HMIHEHD$ LMMHUH
`
 hzMHUH
`
 HMHE   H]E A   H-w HMHE   H]E A   Hw HMHE   H]E A   Hw HMLOL+ILHUH
<`
 7HMHMHM	HGH+HA   I;IFEI;LGHHL$@*/k A^$HMt{LA%Tv @ HcIQfAn\(T(Y\f.zuAf/AGfnYHL$@\HI;r(HHL$@4  HL$@ CH`
 HHHu`
 H;f`
 r
   "HHL$8HtW HHHHMH3 ($   ($   H   A_A^A]A\_^[]@USVWAVAWHl$H   HE)$   HL	 H3HEIIHL
A
 eH%X      LE3B
9`
 ~^H
`
 Z =`
 uIH`
    L=`
 D=_
 EGHt H
_
 UH
δ q H
=`
  HE   L}E A   Ht HMLHUH
_
 sHMHE   L}E A   Hst HM LHUH
C_
 ΢  HMdHE   L}E A   HGt HM Wf/woHE   L}E A   H# HMZ HE   L}E A   H HM3 HEHD$ LMLHUH
^
 RvHMHE   L}E A   Hs HMHE   L}E A   Hs HMHE   L}E A   Hs HMHM:HM0HM&uHEHEH}g ^HfnH\Y(YY2g (\Y\uIHM3  IHMH3 ($   H   A_A^_^[]@USVWATAUAVAWHl$H   HD$8)$   H'	 H3HEIMLL
>
 eH%X      L3B90Z
 ~^H
'Z
 6 =Z
 uIHZ
    H=Z
 @=Z
 DGH5r H
Z
 1H
 M H
Y
  ID$I+$H  H~   WHE   H}E A   Hq HMMHUd  HMjHE   H}E A   Hq HMMHUH
Z
 萟  HM&HE   H}E A   Hq HMPLHUH
Y
 茴HMHE   H}E A   HUq HMHE   H}E A   H>q HMHE   H}E A   H/q HMHFHD$(H|$0MD$M+$ILD$ HT$(HL$0HHDHD$ L;HBHLMHUH
X
 'LLHUH
X
   HMHMHMIHL$@&(Mt$M+4$I   L;LFHVL;LFHM踻HH]H9Nv3H
od @ fff     Hc(^HH;NrMtcI$c fD  HcHIfAnE \Y(YY\YHD$@\HI;r(IHL$@-  HtLEL+IHHL$@ CH!Y
 HHHY
 H;Y
 r
   HHL$ HtW[HI?IHMH3 ($   H   A_A^A]A\_^[]HUSVWATAUAVAWHhH(  HD$8)p)xH	 H3HEMMLH
:
 eH%X      L3B9Z
 ~^H
Z
  =Z
 uIHmY
    H=^Y
 @=GY
 DGHtn H
5Y
 H
I  H
`Z
 C IGI+H  IFI+H  WHE   H}E A   Hn HMMHUH
X
 ؗ  HMHE   H}E A   Hm HMHMHUH
yX
   HMڽHE   H}E A   Hm HMMHUw  HM蝽HE   H}E A   Hm HMHE   H}E A   Hym HMHE   H}E A   Hjm HMyH|$0MFM+ILD$ IWI+HHT$(HD$ LL$(I;ICHLMHUH
nW
 LMHUH
XW
 HM蹼HM诼HM襼IHL$H#t$hHD$hHD$pLl$xM'I_I+HM>IFI+HH;HFظ   H;HFIE @=#` ^ (Htt%z_ ff     HcAI\PY(Y\(Y\(YHD$HX(Y\HL$pXHH;r(HHL$@'  HL$Hz CHT
 HHHT
 H;T
 r
   
HHL$0HtW3HH>HHMH3n ($  ($   H(  A_A^A]A\_^[]LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHδHH|$`HHH0_^[H\$Ht$WH Ii/  HHX f@  Ht4HH3HC   Hs@3;Hs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aqh  IB  H1H;>u=IP I5  H$   HD$(LAII,h  I  H;uAH^HK I  H$   HD$(LE3IIg  I  IP I買   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I7tCHCIIπx H$   HD$(tLE3(g  I   LAg  I   IHO    H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS Iqt=HGIIπx H$   HD$(tLE3bf  I6LARf  I&H$   HD$ MHT$8I i  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I.,  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3H;Hs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Ai  IB  H1H;>u=IP Iմ  H$   HD$(LAIIi  I  H;uAH^HK I菴  H$   HD$(LE3IIVi  I  IP IR   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I׳tCHCIIπx H$   HD$(tLE3h  I   LAh  I   IHO 聳   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS It=HGIIπx H$   HD$(tLE3g  I6LAg  I&H$   HD$ MHT$8Ipj  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HHH H|$`H HH\$XH0A^_^@WH0HD$ H\$XH4(  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@WH0HD$ H\$XH'  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS$ HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSH HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     :HH0[HUVWHhH   HEHX)pH|	 H3HE'I(EM
O*
 eH%X   A   H3A9G
 ~^H
G
  =F
 uIHH
    H=H
 @=H
 DG
Hi H
zH
 H
  H
F
  HE   H}E A   H7 HMfuH      HEH#H;upHE   H}E A   H HM$HE   H}E A   H HMHEHD$ LMLEHUH
G
 _HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   H}E A   H+ HMZuHHEH#H;vpHE   H}E A   H HMHE   H}E A   H HMHEHD$ LMLEHUH
F
 ^HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   H}E A   H7 HMNLEHUH
F
 HM߫HE   H}E A   H HM	LEHUH
E
 HM蚫Hr
  YEXHM'H3 H$   ($   H   _^]HHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(DY A\D)xD)hD)XD)H(D)8ATD   f/  L   WDM D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXYpN ^A(\AY(Y\ fE/(vWX (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y5ML A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"H Ht
H+HH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@	 H   MMHL?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"H Ht
HHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@ H   MMHKL|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HEJ!(H   A] (YH   Xf/wXfA/sQH   (AT W>U f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
!
 I   LNB	9Z>
   HII9H3H-<
 HLL%<
 HL=<
 H;1HLH0  HEHDL   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
P<
 s =D<
 H
:
 H
+<
  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-D)@HDA Ip     D)HI   D
? D)PD? D)XEWD)d$@D%@ D)l$0D-BL D)t$ D5? )pغ   H  W4   H*AYff        Hc  WHH*X(AYH5rԺ   H7  WH*LcXEFLcAYBP BYP f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zBՀ	
 BP fA/B̀	
 (\\YXr*((B\P Y\YYX\(((B\P Y\YYX\fD/&fD/w(YAYAW f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=? H  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLLZ I^WD$(Ht3W H~LHD$(L|$(H\$03HcI;^}UI4H3
 HHH3
 H;3
 r
   FHH$   Ht
(HILD$(H$   IM ;  H$   HCH$   HI~I;|$t!I$ HtH}I$I4$I|$H      ?HCH=2
 H
'2
 H9
2
 t	H1
  HH+1
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|Iњ # L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH8 3H$   HH$   HH$   H H$   HLCL+H$   ׁ A   E3H$   HL$0C HD$0HcHHD$0HȺ   . HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQDuHL$0> u2HL$0 H$    HL$0 H$   b 2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H@  HD$(H;wH
H\$ H;vHH+HH=   HH*  H\$@Ht$HH0_@SH HHHSH
Q H3H
HJHH 3HC HC(HC0H6 C8HHՀ HCHH [@SH0HD$     
	  HH0[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$Xi  HL$8(c 3($   H   [HIH%= H%! H\$WH H t
h   H HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    H-
 LHH-
 H
,
 H;rHLH,
 H
,
 HHH,
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH=,
 HH0H/,
 H; ,
 r
0   HH\$`Ht!(HtHm~ HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    Ho+
 LHHb+
 H;S+
 rHLHG+
 HHH:+
 H;++
 rHHH+
 3LCIHI+HHt2f     I HIHLCI@I+ HH;rH*
 3H9S~-L3ff     JH9HIHcH;C|H*
 HH0H*
 H;*
 r
0   AHH\$`Ht!(HH| HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHH)
 LHH)
 H)
 H;r   LH)
 H)
 HHH)
 H;r
   [HHKHIHHH
)
 HH0H
s)
 H;
d)
 r
0    HH\$PHt%(HH{ HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfo= (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   W= II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %< ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PHK HA@H HAPD$P   ?HWy HHOH HHG@HcPH} HD:@HG@HcPDBDD:<HSHHDQHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HAPH( HA`D$P   oH HHO(H HHGPHcPH HD:PHGPHcPDBDD:LHS(HHDHH\$HHt$XH0_H\$WH HHT HHQ3HHHKHBߌ H HHCHGHC H\$0HG 3HG0HG8HG@H{t GHHHx HG(HH _H\$WH HHH;Qt>H		 HtH]  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   E LHtHHHtHHIHHtHHIH [HL$H(. LD$0HT$8`T	9 f/A0 wU_. LD$0HT$88T8 f/0 wAO. LD$0HT$8T8 f// w-H(H{ H
 x  Hg H
  x  HS H
 x  LVWATAWHh  HqW	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  AE3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XA	AX
	AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ /@L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3i Hh  A_A\_^HWH   H@HXHhHpIIHIPHH3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`HOHl$PH\$HH+HH;ntH@ Ht
H{iHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;v H    H=   r<t HAH;r H+Hst H'vg H6 HHtmHD$XH+HH;v7 H    H=   r<t HCH;r H+Hs H'v HH躤 HL$`HtiHD$pH+HH;v H    H=   r<t HAH;r H+Hs H'vw HF L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHt3 H+gHHkHsC  IH!t  HH\$`Hl$hH0A^_^@USVWATAWH$H  HyP	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  =0 WD9( f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HE  HE H  IH B<L;~  HH+HNHfo' T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
l' foLu@MH  EhL  E   M  E  fo
#' f      t  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&u  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfoU$ IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   賴  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  ? LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3莑 H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     n  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  HD	 H3HExMH;' HHEHU' HHEHE   HE    E 8 uE3IIB<  uHHMֱHE0   HE(    E ; uE3I IB< uHHM蚱HEP   HEH    E8 A   H& HM8o3@      H}H;   H+H   HHuH}HCuHH   LǺ%   Hw HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHM蒬H)IE3HUHM8%A   H< HM8迳IHMXl  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   Hu HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMLIIE3HUHM8߳HE8H}PHCE8H
R~ HL$03HL$8HL$@HD$HD$PHT$8HL$Ht Hu HD$0HT$0HMk  HHL$`Gl  H`	 HL$`L @WH@  HD$(H$P  HHD$     HL$@~   HL$0r LD$PMcHHL$PIHPHL$Ps HHL$@H$   H$   s HH$P  H@  _Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v( W!   fD.z  f.zv  D)T$ Dn fA/L  D
 fA/r4Dz ff     AX(y fA/XsD(E\}	 eH%X      HЋ9
   X5 A(AYAY((Y	 (Y	 Y
	 X	 X	 X
q	 YYYXm	 Xm	 X
=	 AYYYX@	 X
	 X(Y)	 AYX	 YX	 YXX
	 ^YY5 X  D fD/v(E E(\D(AXL	 eH%X    f/ƹ   HЋ   9

 h  A(A(AYAY((Y
 (Y
 Y

 X
 X
 X

 YYYXV
 XV
 X
f
 AYYYX)
 X
9
 X(YR
 X:
 YX
 AYX^YY%% X   9n
 )  EYDWK A(AY((Y,	 (Y	 Y
!
 X	 X	 X

 YYYX	 X

 AYYX(Y
 X

 X	 X
 YX
 AYX^AYDY
& AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
	
 ɉ =	
 ( H
	
 (
{ 	 (M 	  	 ( 
h	 (
 )*	 ( )
	 (
 ).	 )
	 ވ UH
^
 - =R
 (] H
>
 (
 
 (1 "
 
 "
 (# 

 (
e 	 F 
	 (
   
 
	 @ H
8
 菈 =,
 (/ H

 (
 	 ( 	 ( 
	 (
 
   

 (
 
 

 貇 IHHh  HD$X)p)x((Wf.zu( Y   f.z  f.
{ z0u.(W= c((cYY5 (L  f/
A rT= (c.  (f  HyDJ J  ȃw_H< H(+g     (~h     ((^     (i     (     (j     HCv HD$03HD$8HD$@H HD$HD$PHT$8HL$Hl H` HD$0HT$0H$   k  H
S HH(H
 HH0@8B  HH$   -  HHL$`?  H8 HL$` ($P  ($@  Hh  Ð- : G W d q HUVATAUAVAWHxHX  Li3ILLDM   
 HXH      ?HxI)p)x= D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E     IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C螓  H;}&f        HE(f)HH;|LHMHd  LM@L  HH  HM`* MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL   转  MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@f  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMH!  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  x~  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH        @   @   H
] HHxHHH\$PH0_HT$WH0HD$ H\$PHHH        @   @   H
lT HHxHHH\$PH0_@USVWAVHl$H   HE)$   H0	 H3HEIHHDC	 eH%X      NE3B	9	 ~^H
	 } =	 uIH6	    L5'	 D5	 EFH H
	 虝H
Q 赂 H
	 | HE   LuE A   H HMZLHUH
	 6WHMaHE   LuE A   H HMLHUH
g	 ?  HMaHE   LuE A   H HMҜ; oHE   LuE A   Ho HM覜HE   LuE A   H( HMHEHD$ LMLHUH
	 nHMaHE   LuE A   H HM.HE   LuE A   H HMHE   LuE A   H HMHM`HM|`HMr`fn5B ^ϲ fn\Y	 WX\YYv \(HMH33y ($   Hİ   A^_^[]HUVWAVAWHhH   HEHX )p)xH-	 H3HEMLHD=	 eH%X      N3B	9	 ~]H
	 z =	 uHH	    Hr	 \	 DCH H
J	 蕚H
nN  H
i	 y HGH+H  WHE   H]E A   H[ HMBLHUH
	   HM^HE   H]E A   H' HMMHUH
	 ;  HM^HE   H]E A   H HM躙Af/woHE   H]E A   HQ HM舙HE   H]E A   H
 HMaHEHD$ LMMHUH
	 MHUH
	 HM]HE   H]E A   HM HMHE   H]E A   H6 HM՘HE   H]E A   H' HM讘LOL+ILHUH
D	 OeHM5]HM+]HM!]H7HGH+H   H;HFH;HGA=  ^` (HtOfAnI	 %i f     (X(\Hc\TY\HH;r(WHMH3u L$   I[HA(sA({IA_A^_^]HUSVWAVHhH   HE)p)xH)	 H3HEIHHD	 eH%X      NE3B	9	 ~^H
	 v =	 uIHe	    L5V	 D5?	 EFH H
-	 H
J | H
	 Kv HE   LuE A   HR HM蹖LHUH
	 PHMK[HE   LuE A   H HMuLHUH
	 q8  HM[HE   LuE A   H HM1Wf/woHE   LuE A   HƑ HMHE   LuE A   H HM֕HEHD$ LMLHUH
	 HM[ZHE   LuE A   HV HM腕HE   LuE A   H? HM^HE   LuE A   H0 HM7HMYHMYHMY5 ^* fn\Y
`	 X\YY \(HMH3r ($   ($   H   A^_^[]HUVWATAUAVAWHhH   HEHX )p)xH&	 H3HEMHHULHL$8D
	 eH%X      N3B9	 ~^H
	 s =	 uIH	    H=u	 @=^	 DGH H
L	 H
G y H
{	 :s IFI+H  I|$   WHE   H}E A   H HM舓MHUH
	 1  HMXHE   H}E A   Hm HMDLHUH
	 @5  HMWHE   H}E A   HA HM MHUH
Q	 <JHMWHE   H}E A   H
 HM輒HE   H}E A   H HM蕒HE   H}E A   H HMnID$HD$0H|$ MFM+ILD$(HT$0HL$ HHDHD$(L;HBHLMHUH
}	 ^LMHUH
g	 bs  HMVHMVHMVI^I+H   H;HFIT$H;HFH\$(HMsQIT$HMdQHLmL}I9|$vOM4$IM+= Hc(A^B+A舨 HH[I;t$rLmH\$(Lt$8HteMHEfnIII+	 % D  HcA\YY(X(\1Y\HHH;rMtLEM+II`MtLEM+IIG(WHMH3cn L$   I[XA(sA({IA_A^A]A\_^]HUSVWATAVAWHhH   HE)p)xH"	 H3HEMLHD^	 eH%X      N3B	9p	 ~^H
g	 o =[	 uIH	    H=	 @=	 DGHA H
	 赏H
^C t H
	 o HFH+H  IFI+H  WHE   H}E A   H HMQLHUH
B	 -  HMSHE   H}E A   H HM
MHUH
	 ٖ  HMSHE   H}E A   H HMɎA$f/woHE   H}E A   H_ HM薎HE   H}E A   H HMoHEHD$ LMMHUH
S	 HMRHE   H}E A   H
 HMHE   H}E A   H
 HMHE   H}E A   H
 HMЍH}IVI+HHT$0HNH+HHL$8HD$0LD$8H;ICHLLHUH
	 AZLMHUH
p	 +ZHMRHMRHMQL>H^I+HI6IFH+HH;HFظ   H;HFA$= ^- (HtDo	  HcA\Y(X(\YY\HH;r(WHMH3wj ($   ($   H   A_A^A\_^[]@SH HALHH$I$IHH;r6H|$0H|$XHO@HO PH}q H
ޗ pP H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMt uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK IKt3H$   HD$(MDHT$pHH I$AD$I/H$   HN@oHN LHm I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@nHO %LHl H
 K H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtJ uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK IFt3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN GHNh I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	5H Ht
Hp*HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@xIVHOKg  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ H H+H= H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/L1 L+L
7 L+A:tA:	uHr:IuL L+L
 L+    B:tB:	uHr@-tH      <U @-tH       A D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;t!HIHKH;tH~= Ht
HHL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMQ  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]foE UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHMq:    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5d      HG(Hx tL   LHH%a  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H-	 H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vIHHE HHuxL4    I   w2IFHHH;wHHH襂 H+HD$`HHHE 1IN8 HE HuMtӑHILuXE3L9?LDL  Lx  H  H    H=     I;v|HGHEHu`H    H   w2HCHHH;wHHH H+HD$`HHHEH7 HEHuHt3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX= 5 MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  I~HUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  HHHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  dL  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} HHHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t/    t	I/ H  H3F H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    H/ HuHuH\$ H(肈|@SH Hb  H# HCPH [HL$SH0HD$ HD$P    EtH! HA@H# HAPD$P   J   H HH1$ HCHC@HcHH! HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH6 HHQ3HHBHKL- H. HH{3HHDH^H\$HH}, HHOHKHtHPHGHCHGHCG C H2" HH& HHH\$PHt$XH0_@SH H  HS" HCPH [HL$SH0HD$ HD$P    EtHv  HA@H" HAPD$P   J   H' HHY  HCHC@HcHH~ HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHHN5 HHQ3HHBHK+ H}, HH{3HHDH^H\$HH
+ HHOHKHtHPHGHCHGHCG C H HHp! HHH\$PHt$XH0_HIH%+ H\$WH Hl  H  HGPt
X   HJ HH\$0H _@WH0HD$ H\$@HH0  HH>* HAHI HtHP tHC     H4 HHK#+ @t
@   HJ HH\$@H0_H\$WH H  H
  HGPt
X   HI HH\$0H _@WH0HD$ H\$@HH HH~) HAHI HtHP tHC     HX3 HHKc* @t
@   HHI HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJHHHFHGHHFLL+tz H_H\$HHN^HHHFHCHVHFLL+tfz HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$LWH   ICI[H H3HD$xIHI HWf/w}IC   IC    D$8 A   H] IKbHD$p   HD$h    D$X A   H] HL$XaHD$8HD$ LL$XLHH
	 AHL$xH3? H$   HĀ   _@UVWH   HD$8H$   H H3H$   IHH3IIHH+HH   II      @      D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   H\ HL$@`HD$x   HD$p    D$` A   HX\ HL$``HD$@HD$(HD$`HD$ LLHHX  H$   H3G> H$   HĐ   _^]HWH   H@HXHp H H3H$   IH3IIHH+HH   II      H@D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   H[[ HL$@_HD$x   HD$p    D$` A   H$[ HL$`z_HD$@HD$(HD$`HD$ LLHH
ջ	 PY  H$   H3= L$   I[Is(I_@UVWH   HD$8H$   Hu H3H$   IHH3IIHH+HH   I      fD  H@D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HKZ HL$@i^HD$x   HD$p    D$` A   HY HL$`:^HD$@HD$(HD$`HD$ LLHHX  H$   H3; H$   HĐ   _^]@SVWH   HD$8HM H3H$   IHHfAn D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   HOY HL$@m]HD$x   HD$p    D$` A   HX HL$`>]HD$@HD$ LL$`LHH/H$   H3: HĐ   _^[3HIHtH   H LH   ICAC    HQH{ ICH ICAC   IKKH HD$(HX HD$@HD$hHcHH{ HDhHD$hHcHDd    Hn HL$(L @SH0HD$ HٹX   <= HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHG HH HAHA@HcPH HD
@HA@HcPDBDD
<H HH  HAHI HtHP tHC     H* HHKH0[H%! @SH0HD$ HH HHU  HAHI HtHP tHC     H/* HHKH0[H%4! LH   ICAC    HQH ICH( ICAC   IKH$
 HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H HL$(J @SH0HD$ HٹX   L; HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HHg	 HH HAHA@HcPH HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     H( HHKH0[H% @SH0HD$ HHW HHe HAHI HtHP tHC     H?( HHKH0[H%D HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A    H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH HS HHt
   : HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHD!VHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH[ HA@H HAPD$P   H HHOH HHG@HcPHg HD:@HG@HcPDBDD:<HSHHDaUHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H2 H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vCsHHMHHumJ    H   w2HCHHH;wHHHc H+HL$`HHHM*HH HHEHuHtrH3H9HDHEXH   L   J    H=      M;vrLnMu_J    H   w.HCHHH;wHHHb H+Ll$`IIH LHuHt!rHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`H3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIL  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   qHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
HP     t
HMX< H   H3u- H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3 HHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xe?  HIHD$hHD$p   INIHD$xH$    D$0HT$ LL$hLD$xIV跿  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v% HA    (|$@D(L$ H`[F HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    v A   m A   A((T T f/vOA^)t$P5 (YXTd fE/
i vW^3YWs(t$PJD^A(AYXc d fD/! vW
ķ ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H H3HE8HF HHEL=` HLEHE   E3LuDuD80uE
IIF84 uHHMKHE0   Lu(E A   H HMKIH}H;   H+H   HHuH}HCuHH   LǺ%   Hv HH    :u uC:j uC:_ uAtH+HHHsHEH}HCEH+Ht+HD$    L
k0 A   HHMGH(IE3HUHMOA   H HM.NA? tI@ IC<7 uMIHMNHEH}0HCEH
 HL$03HL$8HL$@HD$HD$PHT$8HL$HG H HD$0HT$0HM  HHL$`?  H` HL$`: @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH	) Mt
IdHL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH Mt
IHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ vLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8s  (fo IHCHMEHEUHMHME0H]MH} E H}(M@fo
Ҳ fEPU`Mp;Xf/CvCHIH;HC m  H$0  HL$H  HADc$L$@  H   A_A]^[]ff@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4Cؑ  H;}. HD$8HHD$ (HD$ )HH;|LHL$PH蕑  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1H>HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@^   HL$0 LD$PMcHHL$PIHPHL$P HHL$@H$   H$   ~ HH$P  H@  _@SH HHHSH
 H3H
HJHH 3HC HC(HC0H C8HH
 HCHH [@SH0HD$     JQ  HH0[@SH HHHSH
 H3H
HJHH 3HC HC(HC0H C8HH HCHH [@SH0HD$     
P  HH0[H(((T
 f/
ǩ v6f/
ݫ rWf/    H(X \$ H(' f/v(H((Y((Y%d (Y
Q (Y~ X%ƨ Y^ X
 Xި YXʨ YX%& YX
 YYY\\\% Xv YY-z ^X(H(H{> H
\ 73L(DIDAf     A

 f/sffA;uDA f/sffA;uDAHkAHAR0 HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DY A(V D
d (E(A(Y= A(»   EY(D(T
 f/
(    A(AYV (A(Y%E YXf;vM-@ (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_HJ H
8 QHHXWH   )pA)xfD)@(D)H(D)PD(D  fD)X   D(D)`DYD((DYYE^Y` DW
 eU Y= L$   L$   3D(DY(DY 觮((T
Z f/
    Y WA^(Xf;v.ffnYA(EY\AYXf;rDY A(T Yx L$   I[(|$pE(CE(KE(SE([E(cYA(sI_HH H
7 H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
 EYW=N (A\AYY٤ S YWA(Y (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PYw L@D)XD(諬(D(T] f/    DY )|$`D)D$PDr A(A\EX(A(R E\Wf.EYD(DY zt1AYAYY= A^(R AYYJ D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxHpF H
5 H   eH%X   
^{	 )t$pWA   D)T$0D(HB9	   fA/vDW? fD.zu^ (t$pD(T$0HĈ    fA/rfA(L$   AYHt	 H
	 $   w  %ߗ	 (Y%ԡ A(	 AX\\
ϙ	 Y  D)\$ D fE/rz L$   A(H	 AYH
	 Y
 \$   /v  %	 (Y%D A(	 AX\\
ǚ	 Y(  %> E^)|$`A(D)D$PAYD)L$@f/   D((DY
ݍ	 Y]	 DX
č	 XD	 DYYDX
	 X"	 DYYDX
	 X 	 DYYDX
^	 Xޒ	 DYYDX
<	 X	 D^   #	 (^D((DYfDX	 DYDXfDYDX	 DYDXfDYDXJ	 YfXG	 YXfYX<	 YXfYXD^f/   D((DY	 Yю	 DX	 X	 DYYDXv	 X	 DYYDXT	 Xt	 DYYDX2	 XR	 DYYDX	 X0	 D^   	 ^D((DYfDX	 DYDXfDYDXؑ	 DYDXfDYDX	 YfX	 YXfYX	 YXfYXD^A(N (A(M (A(N - (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
	 . =	 g( H
	 (
 A	 (" S	 # 
4	 (
U E	 (V 
߂	 (
 	 (
 
	 (
| )Ņ	 (^ )
ǅ	 (
 )Ʌ	 ( )
˅	 (
t )m	 ( )
o	 (
H )q	 (Z )
s	 (
ܥ 	 ( 
	 (
@ 	 (¥ 
	 (
 	 ( 
	 (
 y	 ( 
{	 (
 }	 (N 
w	 (
0 y	 ɝ 
z	 
: b	 ʞ 
	 
 	 ڞ 
	 
 2	 5	 
r	  rH   eH%X   
t	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D% B9	   fE.E(DTF zu	A(   fA/)|$prnA(L$   AYH	 H
N	 $   q  %	 (Y% A(A(X}	 \AY\
	 YY9  D)T$@D fE/rnA(L$   AYHy	 H
B	 $   do  %<	 (Y%y A(A(X	 \AY\
 	 YY   E^)$   A(AY$   A(I (A(I (L$   Hm	 H
	 p  (L$   (AYH	 XH
\	 Yo  \YXA(I Y ($   D^AYD(T$@fE/vY=/ ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
	  =Ԑ	 ( H
	 (
I Z	 ([ l	  
M	 (
 ^	 ( 
p	 (
! r	 (s 
t	 (
 )n	 ( )
p	 (
 )r	 (k )
t	 (
 )f	 ( )
h	 (
 )j	 ( )
l	 (
E ~	 ( 
~	 (
I ~	 ( 
\	 (
 ^	 ( 
`	 (
a 	 (c 
	 (
% 	 ( 
@	 (
 B	  
C	 
 ;	 c 
	 
 #	 k 
C	 
ۚ #	 D	 D~	 D%	 D	 D%ր	 
ޏ	 5 D$H   eH%X   
o	 )|$`=' A   HD)T$0D(B9q	   WfA/	  fD.z(	  X fA/)t$pD)D$P  A(E(^	 EYFF (A(fA/X(Y^%    A(A(Y|	 YΉ	 X|	 X	 AYAYX|	 X	 AYAYXr|	 Xr	 AYAYXP|	 XP	 AYAYX.|	 X.	 ^   |	 A^((YfX|	 YXfYX{	 YXfYXʈ	 YfXǈ	 YXfYX	 YXfYX^d	 A(Y \	 AX\	 YYX   fA/   A(AY$   A(^	 nD (A((XL$   HN	 H
}	 Y^-# ~j  %	 (Y%c A(	 AX\\
Ό	 YYX  D)\$ D~ fE/   A(AY$   A(^=	 C (A(T(XL$   H>	 H
	 Y^-k h  %ދ	 (Y% A(߉	 AX\\
	 YYX  E^D)L$@A(AYf/   D((DY
	 Y	 DX
	 X	 DYYDX
|	 Xl	 DYYDX
Z	 XJ	 DYYDX
8	 X(	 DYYDX
	 X	 D^   	 (^D((DYfDX	 DYDXfDYDXۃ	 DYDXfDYDX	 YfX	 YXfYX	 YXfYXD^f/   D((DY	 Y}	 DX	 X|	 DYYDX	 X|	 DYYDX	 X|	 DYYDX	 X|	 DYYDXz	 Xb|	 D^   a	 ^D((DYfDXQ	 DYDXfDYDXB	 DYDXfDYDX{	 YfX{	 YXfYX{	 YXfYXD^A(@ (A([@ (A(y@ c (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
ψ	  =È	 R(n (
 pv	 (i v	 ( l	 (] 
Vv	 (
 x	 ( 
2	 (
Ӗ x	 4 
5	 (
 x	 (' 
x	 (
 Z	 ( 
<	 (
= )6	 ( 
@	 (
 ):	 ( )
	 (
 ){	 (' )
 	 (
) ){	 ( )
{	 (
 >	 ( )
{	 (
 B	 ( 
$	 (
U |	 (7 
{	 (
 }	 ( 
{	 (
 }	 ( 
}	 (
 jy	 b 
Ky	 (
D d	  
My	 
 u	  
u	 
 =	 ݍ 
M	 
͐ }	 =}	 
]	 
͐ H
f	 n 
	 	  L$   HM H
 sH# H
 D$HxeH%X   
;f	 )t$`W)|$P(A   HD)T$ D^ B9Ȅ	 >  f/~   f/D)D$@   (Y$   (^		 < (((XL$   Hu	 H
tx	 Y^-X b  %	 D(Y% (	 X\\
	 Y^DYDX^  D)L$0D
 fD/   (Y$   (^	 ; ((X(XL$   Ht	 H
s	 Y^- j_  %	 D(Y%ދ (3	 X\\
	 Y^DYDX   D^A(AY$   (]; ((.; (L$   HPy	 H
q	 la  D(L$   (EYH	z	 \H
fw	 DY<a  XYD\(: Y D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
}	 @ =q	 (0 H
]	 (
r kv	 (T }v	 e }v	 ( 
Ov	 (
ȕ r	 ( 
r	 (
 )uq	 ( 
r	 (
  )yq	 	 )
Zq	 (
s {q	 ( )
]q	 (
 )r	 ( )
r	 (
 )#r	 (̗ )
r	 (
 v	 (З 
u	 (
b sx	 (D 
u	 (
v wx	 ( 
Yx	 (
 }	 ( 
u}	 (
Α ?w	 (0 
y}	 (
" Cw	  
$w	 
$ D	 ċ 
t}	 
 l}	 ԋ 
t}	 
D 	 D[q	 Dq	 5"u	 Dw	 5|	 Dv	 
}	   xL$   Hϸ H
 nHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H)  HH   [A(f.- LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((Yކ Y
ֆ (\f/O vY H(((H(8  @SUVWH  HD$8H H3H$  IIHHM;H@  HL$@YH HL$PWHH HHy WHH* WHH WHH WH$  HL$@]H$  H$  HC$  HǄ$X     3H$P  $@  8uDI     IB8uH$@  HǄ$x     H$p  Ƅ$`   A   H  H$`  SHGHD$0H$@  HD$ L$`  LD$0HH4H$  H3  Hĸ  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
  HMLM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMALMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEHtHHLMLEHEHHEHHcI;N}!H
 g H
 Y WEHE    LMLEIIjHMH   HEH+HH?H;v/ H    H=   r<t HAH;r H+Hs H'v H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;r H+Hsr H've H4  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	 Ht
HYHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@YGH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHHm6  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHH 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3a H衼HD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM>  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HM7  L;}:@      HMHEBEffYfBXB)IL;|LHHM6  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIKH$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLG[C  HL$hg HL$p\ L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH  HC   HkH{rHH  HHCH H H;t    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AIK  AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  (0| I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@USVWATAUAVAWH$hH  HD$@Hܙ H3H   MIHLL   H  HD$8E3D|$0H| HD$PHM D$0   E3E3HT$XHL$P HD$PHcHH HDPHD$PHcHDxDDLAWHL$XHHL$PwDHH 8@HIVk HH @HU`HL$P.HBD$0HU`H}xHCU`HEX   L}PD}@D8:tI    IB<: uMHM@*HD$8HD$ MLD$0HU@IK|@USVWATAUAVAWH$hH  HD$@HL H3H   MMHLL   H  HD$83ۉ\$0H HD$PHMO D$0   E3E3HT$XHL$P HD$PHcHHW HDPHD$PHcHDxDDLSHL$XXHHL$PBHH  >HIV HH >HU`HL$PHU`H}xHCU`HEX   H]P]@8t
HHÀ< uLHM@I$JHT$0HD$8HD$ MLD$0HU@IzLD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H
  Hc HCPH [HL$SH0HD$ HD$P    EtH HA@H# HAPD$P   J   Hî HH HCHC@HcHH6 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH^ HHQ3HHBHK H HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C Hz HH  HHH\$PHt$XH0_@SH HHHSH
 H3H
HJHHC Hܫ HHH [H\$WH H\  H HGPt
X   Hg  HH\$0H _@WH0HD$ H\$@HH HH HAHI HtHP tHC     H HHK @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$@UVWH   HD$8H$   Hu H3H$   IHH3IIHH+HH   I      fD  D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HO HL$@mHD$x   HD$p    D$` A   H HL$`>HD$@HD$(HD$`HD$ LLHHH$   H3  H$   HĐ   _^]HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HHo HHE HAHI HtHP tHC     H HHKH0[H%$ LH   ICAC    HQH{ ICH ICAC   IK;H HD$(H HD$@HD$hHcHH# HDhHD$hHcHDd    HB HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HH HH% HAHA@HcPHj HD
@HA@HcPDBDD
<HU HH HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HH HHU HAHI HtHP tHC     H/ HHKH0[H%4 DD$HL$WH0HD$ H\$HHt$XHH3t$PH{ HA@H HAPD$P   OH HHOHY HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@HX HAPD$P   HW HHOH HHG@HcPHǪ HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_@WH0HD$ H\$@HH HHn HAHI HtHP tHC     HH HHKS @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH{ HA@H HAPD$P   ?H HHOH HHG@HcPH' HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upHV H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3 HGHH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HMAwI_ HSHH;v
HHumH    H=   w9H   HHH;w
HHH9 H+HL$@HH$L<    I޳ HHuMtd
HCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
Ik HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
Q f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CH;}D$`HD$Hf)HH;|LHL$ Hs	  (YX f/ArW] AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
 H3H
HJHH 3HC HC(HC0H C8HHe HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
AQ D)PD(D)XD(DYD)`E(D)l$ D((DYYE^YvS  Y=P L$   L$   3D(DY(DYP X((T
x[ f/
R    YP H    P WA^(Y5sP X    AYHDXA\EYAY(YXHuDYR A( YxO L$   A({E(CE(KE(SE([E(cD(l$ YA(sIH H
 ̚HHXHpWH   )pH5)x3D)@WD)HD(D)PD(EY{
D)XD(DxO DYDYQ ff     A(Y3 AX(AY Y3  H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
q H3H
HJHH 3HC HC(HC0Hf C8HH HCHH [%XP (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-D)@HDJ Ip     D)HI   D
J D)PDL D)XD)d$PEWD)l$@E(D-M D)t$0D5(W D)|$ D=J )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcB` XY5 K Y` f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zp
 ` Bp
 B` (\YX(\\Y\fD/v\(YX\fD/w(AW f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5C MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  HC HCPH [HL$SH0HD$ HD$P    EtHf HA@H HAPD$P   J   H HHI HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH> HHQ3HHBHK̛ H HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H HHH HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3QH~ H|$HHS H|HS8HOHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3H~ H|$HHS H{HS8HOmHH\$PHt$XH0_H\$WH H,  H HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfoG TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %F II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   E ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQH ICHH ICAC   IKH, HD$(H HD$@HD$hHcHHK HDhHD$hHcHDd    H6 HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHo HH HAHA@HcPH HD
@HA@HcPDBDD
<H HH HAHI HtHP tHC     Hş HHKH0[H%ʖ H\$Hl$VHA3C HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@HH HAPD$P   oH} HHOH HHG@HcPHW HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   Ho HHOH| HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H_ H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vHHMHHumJ    H   w2HCHHH;wHHH/ H+HL$`HHHM*Hؒ HHEHuHtZH3H9HDHEXH   L   J    H=      M;vLnMu_J    H   w.HCHHH;wHHH~ H+Ll$`IIH+ LHuHtHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HGD3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpIEHP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMX̏ H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  H\[ H3HExMH{i HHEHi HHEHE   HE    E 8 uE3IIB<  uHHMHE0   HE(    E ; uE3I IB< uHHMJHEP   HEH    E8 A   Hi HM83@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHMBH)IE3HUHM8A   Hl HM8oIHMXsLuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H Hs HD$0HT$0HM%HHL$`wH HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[A- f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^AC, f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A+ f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0HS H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHH H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	I HM H3.  H]`HuhH}p(u0He@A_A^]H HHXHO/)HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt31 HqhHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$  L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3 H0fHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMkM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$ L L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D%D& HxEW@      IL$LkM4$Hfo& HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D=j" HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  (6 C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;tHIHt3ut HVHLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  H$? H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   L   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;vIHU`HtLmH4    H   w.HFHHH;wIHH H+Ll$`II*Hq LHuHtMHU`IHuX3HIDH   H  H  H    H=     M;vHUhHtL_J    H   w.HCHHH;wIHHa H+Ld$`II Hq LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   IR%3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   I"LEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   %'HIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
In    tH   n HM`n HMhn H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKwLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH&4HL$@m HL$HL$   I[Is A(sI_H%}m H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	j Ht
HMHHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;tj Ht
HLHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"H9i Ht
HtKHH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^FDD$HL$WH0HD$ H\$HHt$XHH3t$PH[ HA@Hh] HAPD$P   HO HHOHP HHG@HcPHoT HD:@HG@HcPDBDD:<HSHHDѢHH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     A薣 AfYD HH;|Ld$PH;}3IGHp HhIL0 ` YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"HJU Ht
H7HH    H|$0HsH\$8H ^蠮LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0H
 H3HE MLHAp AY1LIIM;vxH9HHuzJ    H=   w2J   HHH;wHHHՇ H+H|$0HH8J    Hz= HHuHt HIHFE3EL96LDL}HEH    H=   @@uIM0I;v讖MM(MufH    H=   w2H   HHH;wHHH H+LL$0II$H    H< LHuHt?IE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
Im< @t	I^< HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;tAIIHOH;tH9 Ht
HHH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}fo UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HMm8    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$85b    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht3L7 HHD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%7 @UHPHl$ HE H]@HuHH}PH H3HE HHLBHL;vEL
MumJ    H=   w9J   HHH;w
HHH襀 H+LL$ II$J<    HJ6 LHuHtЏHC3H9;IDH    H=   LFHHN1   t	H6 HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5 MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDX(YLXA(YD
XX

A(YL
YDXA(YL
X(YDXXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+A((YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YX(YLXA(AYD XXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;t趂HtHtIHHH;t蔂LLMt#3( I7LHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;tHII;t$I~( HtH
HEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHM`HMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM' HMx' HMm' H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$I' HtHL	IE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CHNI;} D$XHEf)HI;|LHL$ INIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CLI;}D$XHEf)HI;|LHL$ ILMIIII+L;  L@MtHHIL;  IMIHHWE3LL9G~L
 L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]z@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH  @ L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   fo f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G3H;}%ff     EHD$@f)HH;|MHL$XHE3HEPLM LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI   LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5 )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4GF-H;}EHEf)HH;|MHL$PH- L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;tVHHHt3} HHHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3 HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3 H:HD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%H Ht
H.HL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfo> IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI Hfo IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMI~ 8    RL   L   IH!   H  A_A^[]~JLWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK(H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLCqHL$h HL$p L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	H H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHHu8 H+HL$@HH	H HHHGGAVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+HcAH+2HcAH+HcAH+HcAH+HPHcAH+2HcAH+DHcAH+
H?'HSHcAH+^HcAH+HP餾HcAH+ HcAH+SHcAH+0HHcAH+HP鴿H'HcAH+H3HcAH+HcAH+HcAH+lHcAH+HP|PHSHcAH+$
HK]H(\HcAH+H7PH4HHcAH+ ^HcAH+H`[H(鷼HcAH+HPdH(XHcAH+RHcAH+HP\HcAH+HP\\HHcAH+	HcAH+HcAH+lH(c[H(HHcAH+HcAH+HP<%HcAH+HPHþH[H(XHWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtH\ HHXH\ H [% % % % % % % % % % %r %d % % ff     H;
 uHfuHS  H\$Ht$WH E3H
3\   m  H
j  HH   Hq Hp H HH] H HHJ HHtnHtiHtdH%[  H
  H
[ H @   ?+HH3HH3H=[ H[ H
O   ^  H\$03Ht$8H _E3E33AQ H{[ Hu     ̹   {  H(H
![ [ H
D[ Ht9 H(@SH HH
Z  # H
Z  H [   @SH HH
Z   H
Z ` Ӳ eH%X   A   LЋ C H [h   @SH HH
dZ N ; u4d      ;teH%X   
8` A   HȋT AH
Z H [H%E @SH H
/Z Hu0H+ H3*Z ?HH  H
Y HH [H H
Y H [H% H\$Ht$WH 3H9=Y u8Hű H3Y ?HH>  DHlY H
Y Ӆ3H
UY  H
xY E3 H
6Y  H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
 Y u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
W H(%  Nu#  H(H(3%  H(  @SH W ɻ   DÈW 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
LW u
  t2zH
PW a
  gH I¹@   ?+ȰIL3LELEELEMV LELEELE
V MV 
V H\$PH@]ù     HLMZ  f9quyHcHaH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuHU H [@SH =V  tu(  !  H [@SH H HًH3U ?HHu
H  HH
U   3ɅHDHH [H(HH(]  @SH H HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@=zT  t
   r  dT    tg	  H
	  5	  H
>	  P	  H H
 
  u)0t H H
n ]
  S    @2@N	  HH8 t$H2tHH?  Lƺ   IS    H\$0Ht$8H|$HH A^H\$Ht$WH @S 3ۅ3PȉS =@D$8=SS t
   K  J<S o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9$S 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH H IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH% @SH H3 H  HȺ	 H [H% HL$H8   	  t   )H
R    HD$8HR HD$8HH~R HR HHQ HD$@HLR "Q 	 Q    &Q       Hk H
Q H      Hk H
 HL    HkH
 HL H
  H8@SVWH@H H   3E3HT$`H} Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$ N ǃ|H@_^[H\$UH$@H  ٹ     t)%U  HM3A    HM H   H  HE3 Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 3 H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T   r HD$PHD$@HEHD$H31 HL$@ u
!T H$  H  ]@SH HHH
Q HHS3H
HJHHl  Ha HHH [3HAHW HAH< HHH HH  H\$WH H HHH  t
   HHH\$0H _HHHL$ H'd HL$   HHHL$ ZH] HL$   H\$H|$UHH e 33    D    cAMDDDAentiAineIAntelEDDS AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
! A%?DR = t(=` t!=p t wH     HsADR Eu  ` rADqR    UDM;|$3E]MU]	sAD=R Asnl    f    AsSAsL3H HHUHE$<u28 '    E ! t      H\$83H|$@H ]̸   39 H\$ UHH He H2-+  H H;uoHM> HEHE( H1E HM H1E E HMH H3E H3EH3H  H#H3-+  H;HDH9 H\$HHH2 H ]H(uH=  u    H(H
P H% H
P   HP HP H(HHH(HIq H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH HN H5G H;Ht
HHH;rH\$0Ht$8H _% % %n %p %z % % % % % % % % % % % % %t %f %X %J %< %. %  33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D% D)xEWY5u fA.zuT= D\   D)$P  (T (T
 D(f/D)$0  D)$  EYv
D(^^D((fE.Du zuA('YAX()$ L   (H   AYfE.D($  z.u,fA/w	Dw (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0ȽL(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3@SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
 H9Ht6H} HH [<   v HuH
* HkI H	r HH [@SH0HAH      t-H
  L)J LH   H	 u/HH0[H
 LH@LHJ HD$ H	 H+u
HCHP03H0[E3H;
N AAH;
 H;
4 AAuH% H\$WH HHHIHu H;t6 u,LHT$0H HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _HN H\$8H _@SH H=     H D  C
HKt1{ th 0HSLCHMtE3=  
HSH HKHHCHHt% Hu H(H{ u3H [ÃH [H\$ UVWAVAWH   H~ H3H$  ILL HH1  H H/Hu
HWHR0H  I HH   HH H.Hu
HVHR0H+u
HSHR0H   HG    |H
 HE MMH	 tHG H;vBHl$0LF HD$(HL$@MLt$     E3HT$@3p x.HJtH
 HF Hl$(MMHD$ H	 H/uHGH
H+u
HCHP03H$  H3mH$h  H   A_A^_^]@SH t HHuH [HH|$0 H+Hu
HSHR0HH|$0H [H(  H H3H$  A   D$    L HL$4AQ m L    LHL$0 D$08D$4u%D$28D$6u3H$  H3{H(  HD$0   HD$(LL$4HHD LD HD$ HL$@! A   HT$@3 H$  H3H(  H(H H
&> H7 H( Hq  HuHwD H(HH
u   HYD HuH(3H(H(=u]     H
p? : Hu13 H
 H@ A   H	 y/H(H   ]    HHtH(uH@P0H
.A  Ht$HK   HtH(uHPHR03H( 3H(   H\$WH0H] HH   L
 H= H    LC H= H    LH= H xoL
N H= H xTLHD$     LH
K>    Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0H H
E Hf= A   H	7 yH/u
HGHP03HH\$@H0_@SH HQHLAMtI 3Al AhHA@HAHHA HA(HA0HA8HD$PHtH HAXMtIHD$XLIPHtH HA`Z HH [H\$Hl$Ht$H|$ AVH0H
_A IH5-L HH-K L5I  HtHt$(MLHl$ HHH\$@Hl$HHt$PH|$XH0A^H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
 HJ; H	A H(HAXHHDQ H H(LHt4HB      t$HIPHIPPHt
H)uHAP03H(H
i H: H	 H(HAPHHD H @SH yh H   Hl$0Ht$8H|$@Lt$H HHhPHpXLp`3HGPHGXHG`9ChuHt3H  HHu HtH 
H(uH@P0MLHHHI  Lt$HH|$@Ht$8Hl$0H [@SH HA H{8 t	H {h |H H u H H$   HH [H% H [H\$WH H3HIHtH{H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _LI[WHP3HIC H ICA   ICHICHIC ICEAICIC u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0yl HHYHHt!H
 H96 H	 3H0_][Ht$PHt  HH t$xL I;t5HB    }      @t3H
  IH tetaHH  H+u
HSHR0HOHHtHGH    H)uHAP0   3H  HHt$PH0_][P  GlHHCH;N; u(HD$pHLL$hLD$`t$(HD$ H'  L   H@ MtA HH   H+u
HCHP0H
 H	 uHt$PGl3H0_][ HOHHtHGH    H)uHAP0Gl LD$hHHT$`j=  3H  HHu' H9XPuH
e E3E3HHHaD  HHt$PH0_][HT$pHHt LL$hHLD$`HD$      H.Hu
HFHP0Gl H+u
HCHP0Hu7HL  HHu'6 H9hPuH
 E3E3HHHC  HHt$PH0_][H\$WH yl HHYHt$H
 Hs3 H	
 3H\$8H _HtIHHHt$0  HOHHtHGH    H)uHQR0H+u
HCHP0Ht$0uH
 H	 3H-  Ht4H(u
HPHR0H
1 H*3 H	i 3H\$8H _> Ht*L HH M H	  # HX H\$8H HI H _@SH HHIH{l tH
 H72 H	 3H [HtGClHAH;
8 uH;* u
3P    Cl Hu!HH [B  H HH [  H [H\$Hl$Ht$ AVH H7 3HLH9BuHHH      AlHHBHn; H|$0L   MtAB HHu%H
 H	 u	H g '3H H/Hu
HGHP0HDH|$0AFl HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIH{l tH
 H0 H	 3H [H   ClHAH;V6 u\H;v u3H; HD >H;X u3H; HDs  H; u   LH: q2  Cl HuDHP   H  HHu'0 H9XPuH
 E3E3HHH?  HH [H\$WH 3HHIHHD$0HtHGHH)uHAP0Ŀ HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu'd H9XPuH
 E3E3HHH>  HH [H\$VH AhHHمu2Ht-H;} t$H
 H. H	, 3H\$8H ^Ãu"HtH
f H	 3H\$8H ^H|$0 H{  HtSHC0HtHHHGHtH HGHAHC LGhHWpHOxHGhHC(HGpHC0HGxLC HS(HK0DH   HGhHC HGpHC(HGxHC0HC HtH HC(HtH HC0HtH LClHHSH|$0Cl H\$8H ^HtH
d H	H% H
 Hj- H	H% H
 H*- H	H% H\$WH HQ 3Hy(HY0HA HA(HA0HtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWAVAWHH HqP3HYXLHy`LHu0H]@H}HHAPHAXHA`HuGHtH/u
HGHP0H]@HtH+u
HCHP0H H H I  H L I;   HuHƻ H H H}HHu0jHKI;u	H[@H-      t<H{|	H[HH} H Hs HM@H)uHAP0H}HHu0I@     H   HtH/u
HGHP0Hu0H.  HFH  HF    }      @t3H  IH H}HH]@Hu0u%LLHI:  H\$XH A_A^_^]LEHHU@HM0 HE@HHH HH;t2 u(LMHILE@HU0:  H\$XH A_A^_^]HMHHt
H)uHAP0HM0H)uHAP0HE@HX@HHM@H)uHAP0I3H\$XH A_A^_^]H\$HHYhLYpLQxHAhI HApIHAxHH\$MMH\$Ht$WH HHHQHH HHttL@A      u	H#) HG H9C t-H@) H
 LGH	ĸ H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
ظ H	 tm H| xHWLHH xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _~    uHH uH\$0H _ø   H\$0H _LH;u   HA    }      @t3   H%C E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
 AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL; AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H;B ø   Htfff     H   H;tHu3H; ø   H(HA      tiHQHHtVHtHHt0Hy H
P Ha% H	 HH(H(H%, AIHHH(ËAH(3H(H\$0HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,HB H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(ÞB B B B B B B B B H(HA      tEHAHHw,HC H3H(ËAH(ËAH(H(H%/ H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(~C ~C ~C lC eC vC ~C ~C ~C H(HA      tEHAHHw,HǻD H3H(ËAH(ËAH(H(H%O H\$0=HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(^D ^D ^D LD ED VD ^D ^D ^D H(HA      tEHAHHw,HE H3H(ËAH(ËAH(H(H%o H\$0]HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(>E >E >E ,E %E 6E >E >E >E H(HA      tEHAHHw,HxF H3H(ËAH(ËAH(H(H% H\$0}HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(F F F F F F F F F H(HA      tTHQHHtAHt3HHyH
 Hc H	 H(H(H% AH(3H(H\$0HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,HgH H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(þG G G G G G G G G H( H(H(ί H(H( H(H( H(H(n H(H(N H(H( H(H( H(Ht$WAVAWH L=+ ALtx  tDADH\$@Hl$HEt8H-q% Ht,^% H  ;P% }HHD9Du
H\ H,MDƋI   HHtntHЋ  f LG* E3HH HHtHȉp|D HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH A_A^_H\$Hl$Ht$WH   HAIɋ HHtVtDLb HH
 ҫ 	H HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_H' E3H
, E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$      H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H=B# HڋHuH   % H  hHHH# # @   "    H\$@Hl$HH _Ht$0Dŋ5" HϋLt$83  LcD;}'IH9luHHH)   HAP0}" ;u.p@HHcH HHtX5u" 5k" Hl" HcMI;~#HHHI+@ AHIAHuMƉ5+" BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H=! Ht/! H9   ;! }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@UVWH H
7'  3HtH& Hʧ H   LD$HH\$@HT$PHL$X H
& Hb& HAL   MtA HHt,H. H= HE= H+uHCHP0HLD$HHT$PHL$XK H\$@Hu%Lr H% H
d& ~ H _^]H EH _^]H\$WH HAHL   MtAШ HHu.H
i H	 tH
 HF LH	 HH\$0H _H\$Hl$VWAWH0333HLHu3զ HH   HH
_ Lt$P LHt~6 HHtp.   H
b  Ht<LD$    LIIը HHu7H
 H	 t# LD$     LII HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^LI[IkVWAVH0HAP3ICIHAXMCICLHA`ISHi`HHiPIHiXIKICɧ H9nP   HD$PHt(HL$(H    HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHVhLH~pHH^xIHNhLFpHFxHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP03QHL$ I.H/H+Ht
H)uHAP0HL$(Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIPLH;u   Hu3HB      2   HA    }      @t3BH%s H\$UH HjE3HH~HB H;|   IHL;|Ht$0H|$83H   HrfHH;   HC    }{      @toHX  Ht4L@3M~HH9tHHHI;|3H   H\$@H ]H     H   H;tHuH;ئ    	H{ u'HHH;O3Ht$0H|$8H\$@H ]ø   H\$WH LQhHypHYxHQhLApLIxMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _HAhHHApI HAxIHHtH I HtH IHtH H\$WH   H3HH9HHDG<С u#H H;HC8HC0H HC@H{FDK$AtPH
w Hh
 A   H	I H9;tH} H9C@uH{@Hj H$   HĐ   _H$   HL$@  HS(HL$@  HtCH
ǋ H;tbLCH HHb L
\ HGIHD$0H Hz LOHL$(H H
 HD$ H	 7H9{@uH HC@3H$   HĐ   _3HHAH HA8HA0Hq HA@H9 tHS H9A@uHA@    H%> H\$HT$UVWH HHLrfHH}  A$Z 3AY IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <9}4HÍv4p<0}H\$Hu,H
 H	 DH	| t*LHcHG(H=	 H
n H	 3H\$@H _^]H
O H AZ   H	! 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]He cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]fNY V Y eX >X V V W V W  X sW Y X  







































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtH H
} H	 3    t   LA       )   эB<       A<	  CDA0H<0|f<9}CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGHs DHHH
s D@XH	N    HGHcHLH
M MDH H	  gH
/ H DH	 JH
 Hs DH	 3+; uH eHCGGHG(   IH7 H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
) LMH H	 Ld$XH(A^[D8cGu+DAXH H
 H	ʙ Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
 H LH	ɗ H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH LICHD$(IM HD$ GHuL
 Lĝ H L HL	AHDAP@  HD$(H LT$ MH
 H	 H8H(DA@1wVL
hHA$a Aa IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
 H+ H	b 2H( ` ` ` ` ` ` `      H(DA@4wEHHa a H   H(ø   H(ø   H(ø   H(H
 H\ H	 3H(Îa a a a a       H(DA@4wEHHb b H   H(ø   H(ø   H(ø   H(H
 H H	Ô 3H(^b hb rb |b b       H(DA@1wqL
HAc Ac I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
 H H	Ǔ 3H(0c :c Dc Nc nc Xc c      H(DA@4   L
HAd Ad I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
 H H	 3H(H
͒ Hn H	 3H(f4d >d Hd Rd rd \d d d       Hs   L̚A df Af IHK H_ Hg Ho H H H H H H H ÅH
 H HEÅH
 H HEÅH
 H, HEH0 H8 H@ HH H HH  f Ze je ze e e e e e Re Je e e e be re e e e 	f  	

DH5 H
 H	H%d @SH HDA@<	w<BHA؃0<0|<9}H[X<0}HtH [ÃHHr H
 D H	ޏ H [HDA@<	w7BHEA0<0|<9}GHE@F@<0}HAÃE3H LJL;y HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=Py Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJH HHHL$ H
f H	m 3H8fD  H   H;tHuH;H t   H8H\$Ht$WH LAHIxpHt[H tTH MtI	HL
 HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
 Hp M@H	 H\$03Ht$8H _H(H
 H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H( y,H(LH /   HHtH(uH@P03H(H\$WH HAIL   MtA` HHt,HH5   HH+u
HCHP0HH\$0H _H\$0H _LI[IkIsI{ AVH0H 3LH9A   HiH   HYHCH; uISDGISIkH     H; u=HKQ=   u*Hl$ Lt$(HA uH{E3HT$ HEA]   - HHtMHE E3HhHIHLp H  H.Hu
HVHR0H+uHSHR0c  HH\$@HH|$XHl$HHt$PH0A^Ht$WH HA3H; HtVH; u+H;QDƋAHDtJHDH Ht$8H _HHhHt.HAHt%HHt$8H _HH;W΋HuHHH\$0Ë HHtHH H+Hu
HSHR0HH\$0Ht$8H _HGHt$8HH H _@SH HHu3H [H|$0 H+Hu
HSHR0HH|$0H [EH;uH H H HAH; uCLAIHH3H+HMtQ3ҋIEA;tHi H H_ H;G uAfAnf.zuzA   H%= H\$Ht$WH H 3HH΋H9CH9G5  C u
H xG u H yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM @ƋH\$8Ht$@H _LL I;uUI;@ƅuJA   HH HHHH+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HH, t/HD$8HH      tJE3LD$8HT$HH uLL$8MtLH
І L Hj H	Ɇ 3H [H
 L˼ H H	 3H [ø   H [H\$Hl$Ht$ WH H3H
 IHL;u3H;Lt$0HMHDߋ      Ht:H   MtH. I9@tH
 HR H	A h  HHHH Ht(߆ HH`H;tHHp`Ht
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHI̇ t   IMMHC      tHHӹ    3 HHtuE3HH? H+Hu
HSHR0HtNLOHA      @H
 H	 LH	 HY H
 H	ل Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4IS-   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@% HLL$pH8G `<`uHH@Iy( uI LL$pAA `<`uIAIA@H;u-HIH	f y: H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$  q3H\$`H0A_A^_^]HY@% HLL$pHC `<`uH[H[@Iy( uI{ LL$pAA @t
 tIAIA@H;u)HIH	T ؅y( HuqLL$pt@HI;H H
 L$   H	 H\$`H0A_A^_^]H H
 H L$   H	 H\$`H0A_A^_^]LLH
C H H	H%B HHLT$pH M;LT$0MLH
 MML
X IML
 HW H	LDIH^ HDH HD$(L\$  HHH\$Hl$Ht$H|$ ATAVAWH H HL`PLpXLx`3HEPHEXHE`MtI$MtIMtIMMIH      ǂ H^ HMPHHuXH}`LePLuXL}`Ht
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
K  H H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAPHHAXI HA`I3HAPHAXHA`H\$WH LQPHyXHY`HQPLAXLI`MtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
~ Hd A   H	~ H(H(   H\$UH x HHXPH   H
| LI;tCHK    }      @t3HIH؀ uH\$@H ]3Ht$0HuXH|$8H}`HE`HEPHEXH+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HH LL
 H
} H LDH	H%_} H
a} H A   H	H%2} @SH H{ 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H  ËH [L} I;AuI;AuA   V| HHu	H [HH|$0ЩH+u
HSHR0H|$0H [@SH I| Hu6} Ht3H [HH H [@SH HHH
 Oz Ht	H H [HH [\  HH;}HH33H%V| LL$8E3HMtIH%Dz HAH;} u
E33)  H;~ uHA@t3/  H E3  HT$H(HAH;t} uA   HT$8  H(H;} u>LAA@t
   H(Äy$MP t3HIE3HT$8EAAH(   H(H\$Ht$WH HH   z HHuH\$0Ht$8H _HE3HHxH#  H+Hu
HSHR0H\$0HHt$8H _H\$Ht$WH HAH@ Hpt3HY| @ H H| ;~#H
 y t3H\$0Ht$8H _HHH
O| H؋   ~z<R9| H 9x }
+| @$ Hu"tz HuH
 { H H	py Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Hu{    { @ H H{ ;~H
 x t3lLHHH
Z{ H   ~ZRD{ H 9X }
6{ @$ Hu"y HuH
+z HD H	{x HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyLLqHHY Icz @ DH Hz D;~H
 w t3    uL CuFHu9wuLMIH   |u%Ht LCHcGI;uHSMH   UfHU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ -w HHy    ~YIy H 9X }
y @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHHw E3LHHLx HHt\H~.Hx  fff     HHIH[H HCHAHu3HQx AF HH/u
HWHR0AN HH\$0Hl$8Ht$@H|$HH A^HA@ LPt3E3IHIE3ILH H
w H	H%u HB      tHAL   MtIH%u H\$WH HH
 HHAL   MtAu HHuH
v H( LH	t HH\$0H _H\$Ht$WH 3ȥy'He| H \    6 _  [  3
u H> Hu'H*| Hc !     _     3H
z r H Hu'H{ H!      _    3H
rz qv H Hu'H{ H     w _    ɥy'Hv{ H m    G _  l    H
Q r He HuMH1{ Hj (     _  t H  H
u H! H	s m  Hr H# Hu'Hz H      _    H H
 H r H Hu'Hz H |    V _  {  H
. q H Hu'HEz H~ <     _  ;  LN H' H
8 Rs y'Hy H8      _      y'Hy H      _    95 tFL H H
 r y'Hy H x    R _  w  Cq HHu'HLy H C     `  B  H Hp HuBL8 H Hq y'Hx H.      `    h  y'Hx H      	`      y'Hx H     f `    HA Ho y'HZx H Q E   + `  P  H
[ H\ LH5A dq y'Hx HJ  E    `    HB H[N HBo y'Hw H     `    H
 H LH5GN p y'Hw H }   W `  |  H H0< Hn y'HDw H} ; f    `  :  H
 H9 HH5< nn y'Hv H4  i    `  
  H H8 HH59 %n y'Hv H     `  
  H HY HH57 m y'Hiv H `   : !`  _
  A`  H5Y H H> H
W 芝H# Hu'H'v HH  	    +`  
  A`   H6 H
 >H Hu'Hu H      ,`    AH
  H H
 H Hu'Hu H n    H -`  m  A0  H H
? 覜H Hu'H3u Hd "     .`  !  AP   H> H
Ӈ ZH Hu'Ht H      /`    A   H H
 H Hu'Ht H  u  d 0`    6y'Hct H Z    4 5`  Y  g  u'H2t Hk ) #    ?`  (  H
 3HHu'Hs H.  &    H`  
  Hf LH
 j y &    J`  
  H+u
HCHP0H
r 3HHu'Hts H k '   E T`  j
  H5 LH
 ]j y7 '    V`  
  H+u
HCHP0H
i 3HHu'Hr H,  (    ``  	  H, LH
 i y (    b`  	  H+u
HCHP0H
8 3	HHu'Hrr H i *   C l`  h	  H LH
 [i y5 *    n`  	  H+u
HCHP0H
 3HHu'Hq H*  ,    x`    H LH
 h y ,    z`    H+u
HCHP0H
 3HHu'Hpq H g -   A `  f  HQ LH
 Yh y3 -   
 `    H+u
HCHP0   h HHu'Hp H+  .    `    H HH HKH HH H HKH HAH
G HHu'H
p H
 z .   T `  T  H+u
HCHP0H4 HLHHu'H5p Hn , .    `    H LH
L g y .    `    H+u
HCHP0H HʿHHu'Ho H  .    `    H LH
 f yv .   P `  B  H+u
HCHP0H/u
HGHP0   f HHu'H%o H^  /    `    H HH HOHu HH H HOH HAHR H HOHD HAH9 H HOH+ HAHp H HOHb HA H
 HHu'Hkn H b /   < `  L  H/u
HGHP0H H4HHu" /    `    H LH
B e y /    `    H/u
HGHP0H HHHu /    `  z  HP LH
 d yz /   T `  F  H/u
HGHP0H HLHHu: /    `    H LH
Z ,d y /    `    H/u
HGHP0H` HؼHHu /    `    H0 LH
 c y 0   l `  ^  H/u
HGHP0H< HdHHuR /   , `    H LH
r Dc y 0    `    H/u
HGHP0H+u
HCHP0H
 SHHu'Hk H  2    `    H@HH L   MtAd HHu} 2   W `  I  H+u
HCHP0H_ E3HHHu'H5k Hn , 2    `    H/u
HGHP0H LH
< Hb y 2    `    H+u
HCHP0L H
W 3Xd HHu'Hj H  o  j `    Hr LH
 a y\ o  6 `  (  H+u
HCHP0L H
0 3c HHu'Hj HI  r   `    HQ LH
' ` y r   `     H+u
HCHP0` HHu'Hi H     h a     L HH ` y> a  )H LH
 Y`     a  %    Hi HO H+u
HCHP0HtH/u
HGHP0H
 HH95 tD H
 3H
 H)uHQR0H5 HH\$0Ht$8H _H+u
HCHP0H H\$0Ht$8H _H(y- w_  .   ` H Hu x_    k ` H Hu y_      ` H= Hu z_      c` H Hu {_      :` H Hu` |_  d3` H Hu@ }_  D   ` H Hu ~_  !   d` H= Hu* _  Hg H@     H(3H(H   H    ` H Hu |   a^     H    `` HY Huz ~  T l^    H,    )` HR HuC    w^    H}    _ Hs Hu    ^  [  H    _ Hd Hu    ^  $  H    _ HM Hu 3  x ^    H    M_ H Hug 5  A ^    H
!^ LH\ Hn Hu/ f  	 ^  ~  H
] LH}\ H Hu f   ^  F  H	    ^ H? Hu p   ^    H    L
 L H HD$(H HD$ I^ H
 Huc y  = ^    H    ^ H# Hu, 3   ^  {  Hf    ] Hd Hu 5   ^  D  H/    ] H
 Hu C   ^  
  H    m] H Hu-Hc H y    S ^  HĘ   H    "] H Hu-H?c Hp .     ^  HĘ   H    \ H  Hu-Hb H%     	_  HĘ   Ho    \ H Hu-Hb H  7  r _  HĘ   H    A\ H Hu-H^b H M ;  ' _  HĘ   HQ    [ Ho Hu-Hb HD  O   *_  HĘ   H^    [ H Hu-Ha H     5_  HĘ   H    `[ H Hu-H}a H l   F @_  HĘ   H    [ H> Hu-H2a Hc !    I_  HĘ   H    Z H Hu 2    T_  3  Hv    Z H HHu o   __    H E3H HT$pD$ho  HD$`H) HD$XHe HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    WW H Hu o   b_  h  H[    L
 L HY H$   Hz HD$xH6 HD$pHr HD$hH HD$`Hz HD$XH6 HD$PHj HD$HH> HD$@H2 HD$8H HD$0H HD$(H HD$ Y H HHu k_     H& E3H| HT$pD$hr  HD$`EAH HD$XH HD$PHD$HHL$@HD$8HD$0HT$(3D$    JU H[ Hu- n_   r  H^ H HĘ   3HĘ   H(H
 `H Hu*HE^ H~ <     I^  H(H
 H_ Hu*H^ H<  |   J^  H(H
I H Hu*H] H  W   K^  H(H
 H Hu*H] H v _  P L^  H(H
= XH Hu*H=] Hv 4 =   M^  H(H
 Ho Hu      N^  ZH
 HI Hu 7   O^  ,H
' H Hu*   ~ P^  H\ H H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H-U HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH0 H
 H\$0H _HH\$0H _H@  @SH 3LHy  
P t=H Hc
2 H3HHCHCLCH   Q HH [3IA0  HHuH [@SH HS HHIHCHS H Ht
H)uHAP0HeS HKHCHVS H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HS HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH0 H
d H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   O HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H}Q HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
F Hz  @ǅtH  H
  H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   N HH [3IA0  HHuH [@SH HO HHIHCHO H Ht
H)uHAP0HO HKHCHO H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HmO HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
2 Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H# Hc
 H3HHCHCLCH    L HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _HM H HIhH)uHAP0HM HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _HL H HI`H)uHAP0HL HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H_L H HIXH)uHAP0HDL HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _HK H HIPH)uHAP0HK HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _HK H HIHH)uHAP0HK HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _HJ H HI@H)uHAP0HdJ HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _HI H HI8H)uHAP0HI HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H?I H HI0H)uHAP0H$I HC03H\$0H _HA0H HA0@SH HHt
H [O  HH H HI(H)uHAP0HH HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _H/H H HI H)uHAP0HH HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _HG H HIH)uHAP0HtG HC3H\$0H _HAH HA[{  H\$WH HHG HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH HF HHIHCHF H Ht
H)uHAP0HuF HK HC HfF H Ht
H)uHAP0HJF HK(HC(H;F H Ht
H)uHAP0HF HK0HC0HF H Ht
H)uHAP0HE HK8HC8HE H Ht
H)uHAP0HE HK@HC@HE H Ht
H)uHAP0HE HKHHCHHE H Ht
H)uHAP0HsE HKPHCPHdE H Ht
H)uHAP0HHE HKXHCXH9E H Ht
H)uHAP0HE HK`HC`HE H Ht
H)uHAP0HD HKhHChHD H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAuA   HH|$HC LD$0HT$8HL$@AB HH{HtH  H0^LD$0HT$8HL$@H@B HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  H.D E3HԼ 8  HH	  HA LHCHHzA HH HmA HC HbA H HXA HC(HMA H HCA HC0H8A H H.A HC8H#A H HA HC@HA H HA HCHH@ H H@ HCPH@ H H@ HCXH@ H H@ HC`H@ H H@ HChH@ H -{ y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [L H1@ H HI`H)uHAP0H@ HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H? H HIXH)uHAP0H? HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H> H HIPH)uHAP0H> HCP3H\$0H _HAPH HAPH(Ht	H(N H
W< H H	?> H(H(AH)> Hu;HmE H d X   >     H
e AX   胏3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H= H HI@H)uHAP0H= HC@3H\$0H _HA@H HA@@SH HHt
H [P HA= H HI8H)uHAP0H&= HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H< H HI0H)uHAP0H< HC03H\$0H _HA0H HA0H(Ht	H(Q H
: H H	; H(H(A(; Hu;HC HV  T    z  z  H
a AT   33H(@SH HHt
H [HS H; H HI H)uHAP0Hv; HC 3H [HA H HA @SH HHt
H [hT H!; H HIH)uHAP0H; HC3H [HAH HAH(Ht	H(U H
8 H  H	o: H(U H(Ht	H(V H
78 HH H	: H(H(IL$0: Hu;HKA H B P    
  
  H
\ AP   a3H(H\$WH HHr: HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH Hc9 HHIHCHQ9 H Ht
H)uHAP0H59 HK HC H&9 H Ht
H)uHAP0H
9 HK0HC0H8 H Ht
H)uHAP0H8 HK8HC8H8 H Ht
H)uHAP0H8 HK@HC@H8 H Ht
H)uHAP0H8 HKPHCPHz8 H Ht
H)uHAP0H^8 HKXHCXHO8 H Ht
H)uHAP0H38 HK`HC`H$8 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu45 @  HH|$HN7 LD$0HT$8HL$@5 HH{hHtH  HQLD$0HT$8HL$@H5 HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  H8 E3H 8  HHuH(Hk5 HAH`5 H HV5 HA HK5 H HA5 HA0H65 H H,5 HA8H!5 H H5 HA@H5 H H5 HAPH4 H H4 HAXH4 H H4 HA`H4 H HH(H\$Hl$Ht$WAVAWH L3=3 HHu'H; H߱  =   w `X     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHHa2 u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_ gX  
 eX  H: H  =   H/u
HGHP0HtH+u
HSHR0D H
T b 蹄3tH\$Hl$VWAVH L31 HHu'H<: He # =    ,X     In3I+.HHtafIL$H 4 HHtiHGH9G ~HHOHHHHOHH0 u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^e 3X  
Y 1X  Hv9 H ] =   H/u
HGHP0HtH+u
HSHR0D1 H
b  _3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H;}/ tgH;0 t^IH1 HHu/Hv8 H A/   DZ W  3 H]_  H@L   MuSW    HLL Mu8H. H9GuL;w1  HGJL;w  J\HIHAHHG  ILHt
H)uHQR0HHM]  HHEH;t?HUHtLEL+IIHH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPHJ|0 Hu`HUHM:
HHM
HUHLEL+I/I, , , , , A0   W  f0 H   H
d- LI;   HH    }      @t3HwIH?1 uZW  A/   H]H%6 HN D  HtH/uHGHP0D ˥ H
P &- H/u
HGHP0HUIGH]MtIm uIEIP0HtlHEH+HH;vi+ H    H=   r<tM+ HCH;r=+ H+Hs-+ H'v + HHHH]H   HUHrHMH+H*HHHH?HH
H;v* HRHH=   r<t* HCH;r* H+Hs* H'vz* HHFHIL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;* toH;, tfIHU, LHu/H3 H A/   D KW   Hu  H@H   HEPHuMW  Hu  HLHHMPH]HuHu8H;* I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HzEHua, HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMzL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMJzL}H]HuHt;HH]HEP7A0   xW  H}@H?   H
aY +$ H
SY $ * H   H
6( LI;   HH    }      @t3HqIH, udhW  H}@H?A/   H0 H Dק  MtI.uIFIP0D  H
} z8' I.u
IFIP0HUH}@H;L}HuH?MtIm uIEIP0HthL+IL;v#& J    H=   r=@t& HFH;r% H+Hs% H'v% HHCHH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH;!& twH;`' tnIH' HHu3H/ HC A/   D V  מ H]L}9  H@H   HEHuV  H]L}  HLHHMH]L}Hu8H% H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  HAHE   HE    E HHMbHEHrDHHMH=   r0  HAH;  H+H  H'  H0A& H  HE   3H}@}IE3HUHM\HEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHM葄LuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHMLuH]L}Ht*HC   H{H{rHHHU  H`H H]HMHE! ! ! ! x! q! j! c! H
cS - H
US  A0   	W  H}c$ HH   H$" L I;   HA    }      @t	3k	I& uZV  H}A/   H* H Dա  HtH.uHFHP0D  H
w t2! H.u
HFHP0HUH}HLuH]L}MtIm uIEIP0HM}MtHIM+IMIJHHMH3k6H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
! H;E  H;K  8  H! HHuB     V    H@L   HEo    HAHHt[HEo   HAHHtEHAHnyH
( H
  V  UH+9  HCHP0*  H+u
HCHP03pu	HMoSH( H _ V  q    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   H H
m  H	L  2Mx-H& L
- ILDH` H
9  H	       pV    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I9  Ht V  eHHMQ  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+IIG  Ht@ V      H& H؜ D w H
Ls p   HUHMHHUHMHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUI%HUHtLEL+IIHUHtLEL+IS8HUHtLEL+I:8WELmHUHtLEL+IHMtI/u
IGIP0MtI.uIFIP0HUHtLEL+IHHUHtLEL+I7IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H; toH; tfIH% LHu/H$ H A/   Dz U  S Hu  H@H   HEPHuU  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H!lEHu1 HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMkL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMkL}H]HuHt;HH]HEP7A0   V  H}@H?   H
1J  H
#J   H   H
 LI;   HH    }      @t3HbIH udV  H}@H?A/   H! H D  MtI.uIFIP0D c H
l k8 I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hs H'v HHu4HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
C H;E  H; 8  H| HHu     U    H@L   HEo    HAHHt[HEo   HAHHtEHAHyH
 H
 V U  UH+9  HCHP0*  H+u
HCHP03u	HMoH4 H]  U      HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hz H

 H	 2Mx-HA L
C$ ILDH v H
 H	 ^    8 U    H;u
Hz HrHrH~H6HHE3LLHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I@N Ht U  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I@ Ht@< U  N    HO Hx D9  H
,i gg   HUHM
HHUHM
HHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I?HUHtLEL+I?HUHtLEL+I?WELmHUHtLEL+Ie?MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I!?HUHtLEL+I?IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH;= toH;| tfIH LHu/H6 H_ A/   D U   Hu  H@H   HEPHu
U  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H\HHEHHu HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHMeL}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHMdL}H]HuHtH;HH]HEP1A0   5U  H}@H   H
@  H
@  @ H   H
 LI;   HH    }      @t3HQYIH{ ud%U  H}@HA/   HW H DA  MtI.uIFIP0D  H
b Mb8M I.u
IFIP0HUH}@HL}HuHMtIm uIEIP0HthL+IL;v
 J    H=   r=@tp
 HFH;r`
 H+HsP
 H'vC
 HH+HH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH;
 toH; tfIH HHu/H H A/   Dt T  M Lu  H@H   HEPHuT  Lu  HLHHMP= H]LuHu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0H
 H9GuwuHH (EHf.zu HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHMK`L}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHM_L}H]LuHt3HH]HEPA0   T  H}@H   H
;  H
;  s
 H   H
 LI;   HH    }      @t3HTIH udT  H}@HA/   H H Dt R HtH.uHFHP0DR 0 H
\ ]8
 H.u
HFHP0HUH}@HHL}LuHMtIm uIEIP0MthM+IL;v J    H=   r=At IFI;r L+Is I'vv LIB&HH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is H) H3HD$hHHIK3t$ HA   HqHyrHH@0D$    HJH H;t-	 u#LD$(HT$0H
 x,HT$0LD$(LGLD$(MtHW(Hs Hu>H H ~    X \T  \T  A   H
"] [   HD$`   Ht$XD$H HL$H?HT$HHHD$`HrQHHL$HH=   r<t HAH;r H+Hs H'v H$HHL$hH3L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3 HHu'Hv H ] =   7 #T     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH! u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_ *T  
s (T  H H w =   H/u
HGHP0HtH+u
HSHR0DK H
Z " yY3tH(HyHQrH	 Hu;H H-  2   ~ S  S  H
Y A2   
Y3H(H\$Hl$Ht$H|$ AVH L3 HHu'H H k =   E~ R     In3I+.HHtgff     I HHtqHGH9G ~HHOHHHHOHH? u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^} S  
} S  H
 Hك  =   H/u
HGHP0HtH+u
HSHR0Dk H
|V B} W3r@SUVWAUAVAWH 3H\$`H\$hH\$pn LLxhLppHhxMtIMtIHtHE H   H H
 ȃ   | Q  H IMPL I;tUH  I@      t
I*`*HA9   }      @t	39M	If    DO H
P &| }VLL$pILD$hHT$`]y   { Q  [HM E3H
 FHHu{ Q  'E33H}H+u
HCHP0{ Q     H H\$`Ht$hH|$pH́ LMIIS`HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D= H
P { kUH A_A^A]_^][MtI/u
IGIP0MtI.u
IFIP0HtHm u
HEHP0H A_A^A]_^][@SH H HH HIhH)uHAP0He HCh3H [@SH HC HH HIhH)uHAP0H% HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH HC HH HI`H)uHAP0H% HC`3H [@SH H HH HI`H)uHAP0H HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH H HH HIXH)uHAP0H  HCX3H [@SH H  HH HIXH)uHAP0H  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H HH HIPH)uHAP0H HCP3H [@SH H HH HIPH)uHAP0He HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH H HH HIHH)uHAP0He HCH3H [@SH HC HH HIHH)uHAP0H% HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH HC HH HI@H)uHAP0H% HC@3H [@SH H HH HI@H)uHAP0H HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H HH HI8H)uHAP0H HC83H [@SH H HH HI8H)uHAP0H HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH H HH HI0H)uHAP0H HC03H [@SH H HH HI0H)uHAP0He HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH H HH HI(H)uHAP0He HC(3H [@SH HC HH HI(H)uHAP0H% HC(3H [H\$WH LJHL;
p HtrH; tiH
S L; MIHG H	H H H"v v   o E  E  H
G A  IH\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH H HH HI H)uHAP0H HC 3H [@SH H HH HI H)uHAP0H HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH H HH HIH)uHAP0H HC3H [@SH Hs HH HIH)uHAP0HU HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HA@SVWAVAWH`H H3HD$PH=r LLHH
q 33L HHtH H_HH$   HHu&l fD    HF 3H9Au%HYHtHyHHH)uHAP0   HGH; uHIGHT$(HD$(DEHHH+H\$ Lt$0|HH   k wD  
  H;    HOQ=   uwIGLT$@HD$@DEHL+H\$8Lt$HHA t3HOE3IHHu(k D     H  H+  HCHP0   M HHuH
 H
6q j D  VHtHX3IGE3HH IGHDEIHLtzHHu~j D  H Hp q l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0DLq H
eA #j zD3#H.u
HVHR0H/u
HWHR0HH$   HL$PH3NH`A_A^_^[H\$WH0L
 E3H; HHRHA3I;At   KMuH
 HW H	 +HBL1 H
 HW MIHD$ H	 3u/H
E H
~o <p k  i JD  3H\$@H0_HHH\$@H0_`HUATAUAVAWHhH   HEHXHpHx Hƹ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIFHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU诘LEHUL+I3 HHu'H HEn o h  g D  -  IM;<       HEH;tIE3HHMt'H IE3HUHM\'HE   H}E IE3HUHM8'H HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pf D  
f D  H m h  H&m H.u
HFHP0HtH/u
HGHP03Dm f H
c= @LHH.uHFHP0HEHrPHHMH=   r<tY HAH;rI H+Hs9 H'v, H	HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v H	HE'   H}E MtzII!M+IHL;v} II   r=Atc IFI;rS L+IsC I'v6 LI	IHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU蟔LEHUL+I3 HHu'H H5j j c  c C  -  IM;<       HEH;tIE3HHMd#H IE3HUHML#HE   H}E IE3HUHM(#H HD$(HM HHt[HNH9N ~H HFH<HAHFHHp u H/u
HGHP0I;ܿ    >pb C  
b C  H i c  Hi H.u
HFHP0HtH/u
HGHP03Di b H
8 <LHH.uHFHP0HEHrPHHMH=   r<tI HAH;r9 H+Hs) H'v HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIM+IHL;vm II   r=AtS IFI;rC L+Is3 I'v& LIIHM/H3sL$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHI4HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`跎HL$hH+L$XHHHLI?LHT$X HT$(HL$@HL$@6Hu;H H;f f _  _ `C  `C  A_  H
5 :HH|$@Ht2HT$HHHL$PH+HHHLI?LHxH|$(Ht1HT$0HHL$8H+HHHLI?LH<HL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHI败HL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`HL$hH+L$XHHHLI?LHT$X_HT$(HL$@ HL$@膲Hu;HR Hd Ie Z  #^ C  C  AZ  H
}3 h8HH|$@Ht2HT$HHlHL$PH+HHHLI?LHH|$(Ht1HT$0H0HL$8H+HHHLI?LHHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx HF H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU/LEHUL+I{
3# HHu'H Hb c T  ]\ B  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMHq HD$(HM# HHt[HNH9N ~H HFH<HAHFHH  u H/u
HGHP0I;ܿ    >pv[ B  
j[ B  Hw ub T  Ha H.u
HFHP0HtH/u
HGHP03D@b [ H
0 n5LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v H{HE   H}E HE'HrPHHMH=   r<to HAH;r_ H+HsO H'vB HHE'   H}E MtzII衊M+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H6 H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI6HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+Ik	3 HHu'H| H^ s_ O  MX FB  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMHa HD$(HM
 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pfW PB  
ZW NB  Hg e^ O  H] H.u
HFHP0HtH/u
HGHP03D0^ W H
+ ^1LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HkHE   H}E HE'HrPHHMH=   r<t_ HAH;rO H+Hs? H'v2 HHE'   H}E MtzII葆M+IHL;v II   r=At IFI;r L+Is I'v LIrIHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H& H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+I[3 HHu'Hl HZ c[ J  =T A  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMHQ HD$(HM	 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pVS A  
JS A  HW UZ J  HY H.u
HFHP0HtH/u
HGHP03D Z R H
' N-LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v H[HE   H}E HE'HrPHHMH=   r<tO HAH;r? H+Hs/ H'v" HHE'   H}E MtzII聂M+IHL;v II   r=At IFI;r L+Is I'v LIbIHM/H3L$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHH   HEH$   HE3ELeWELeLeXAAELe3r LHuW C  P CA  c  HFH; tLH; tCIH6 HHuP IA    H@L   MuUaP KA    HMMMu8HK H9FuL;v  HFJL;v  J\HIHAHH   HMXH]XHt
H)uHQR0HCL   HLX HMtA HH   E3HV H_HHtgH+u
HSHR0IIOI9O ~HIGH<HAIGHI uH/ HGHP0:O sA  |.O pA  p"O nA  a H   H
 LI;   HH    }      @t3HIH u}N fA  IH U C  HT I/u
IGIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Lu   H.u
HFHP0MIHM胮HMH;t$HH]HHHMHHHML L`L`H]HMHtHUp~LEHUL+If Ht$H HT T D  M A  aHUHMHUHMSHHM@HI賠ȉMP HuAxT F  RM A  H_ HS H]DUT 3M H
  'LH]MtI.u
IFIP0HMXHtH)uHAP0HHttHUHc}HEH+HH;v HH=   r<t HCH;r H+Hs H'v HHLH]HtsHUH|HEH+HH;vH HH=   r<t0 HCH;r  H+Hs H'v HHIH$   HĀ   A_A^A]A\_^]H\$Hl$Ht$H|$ ATAVAWH`HsT LHIHE333EFIHHu'H} HQ tR :  NK 5@    3H;- 3H;-x 3H;- uH ؅y"R :  J 7@    Hm u
HEHP0  HQ H L5	Q HRS IIFL   MtA HHu'H HP Q =  ~J L@    H LcI9$  HsH  HkHHHHE H)uHAP0HELeH; uFIG0HT$ A   HD$(HHt$ cZHH   
Q =  I _@    H;/    HMQ=      IG0HD$8Ht$0HA t3HME3HT$0EAHHuP =  uI g@  q  H.u
HFHP03H+u
I$HP0   ' HH   IP =  3!I y@  0      HHu'H
 H
OO 
P =  H m@    HpE3IG0HH3H IG0HG +XHHuO =  H s@    H/6HGHP0'IW0HUHHO =  YH Y@  U  H
1M E3HHhWHHuHO =  "H ~@    H+u
HCHP0E33HIH/u
HGHP0H 3H4N N =  G @    HQ A   IOH-FHHu'H HM N >  G @  !  Hf؅yN >  `G @  o  Hm u
HEHP0   IO(L# I;uEH
 L, H H	 H! HZM N >  F @    HP -SHHu'H HM M >  F @  Q  3H;
 H(uH@P0b  HN H L5N HO IIFL   MtAo HHu'H` HL WM @  1F @    HQ LcI9$  H{H  HkHHHHE H)uHAP0HELeH; u8IG0HT$@A   HD$HHH|$@VHHuwE @    H;    HMQ=      IG0HD$XH|$PHA t3HME3HT$PEAHHu@E @  2  H/u
HGHP03H+u
I$HP0    HH   L @  3D @  H H2K Hm    HEH       HHuD @     HxE3IG0HH3H IG0HF SHHupD @  eH.;HFHP0,IW0HQHH3D @  (H
I E3HHhSHHuN	D @  K @  H HEJ HtH+u
HCHP0HtaH.u[HFHP0OH+u
HCHP0E33HEH.u
HFHP0H HI J @  vC @  HtH/u
HGHP0DvJ H
o MC MtI.u
IVIR03
H H L\$`I[ Ik(Is0I{8IA_A^A\;HUATAUAVAWHhH   HEHXHpHx HƓ H3HE/HHMWEE3LeELeEAAELeELeHE'   LeDe3 LHu'H` HH WI 3  1B ?    Ls8IFH;! t`H;` tWHI LHuI 3  A ?  Z  H@L   Mu]H 3  A ?  1  IIܐMu8H I9FuI;^   IFH4I;^   ItHHIAHH   ILHt
H)uHQR0HFL   HI HMtA< HH   E3HJ HvPHH   H.u
HVHR03IOI9O ~HIGH<HAIGHI u$H/HGHP0E3A   G 3  @ ?  E3  G 3  i@ ?  E3  sG 3  M@ ?  E3   HtfH
? LI;tQHH    }      @t3HIH uG 3  ? ?  E3M  8 E3I.u
IFIP0ML}IHM
HMH;t$HH]HHHMHHHML L`L`H]HMHtHUoLEHUL+IC Ht'HY HE PF 4  *? ?     HUHR@HM HMH;t$H8H}HHHMHHHML L`L`H}HMHt5HUMmHMH+MH*HHLI?LHU; Ht'H HD E 4  x> ?  R  LEHUHM^`3 LHu'H_ HD VE 5  0> ?    H]H;]  HEH;tIE3HHMH HMH}'HCMHU HH   ILHt
H)uHQR0HGL   H#H HMtA LH   E3HC HLHHtwI.u
IFIP0MIOI9O ~HIGH<HAIGHI uH/u
HGHP0H;]  'D 5  = ?  uD 5  < ?  _< ?  FH H#C C 2   < S  S  A2   H

  M< ?  C 5  IH HB I/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0HtH/u
HGHP0LuH]H}D6C < H
i dMLuH]H}MtI.u
IFIP0MtIm uIEIP0HE'HrPHHMH=   r<t HAH;r H+Hs H'v~ HMHE'   LeE H   HUHiHMH+H*HHHH?HH
H;v HRHH=   r=@t HGH;r H+Hs H'v HHHt~HUH9kHEH+HHH;v HH=   r<ty HCH;ri H+HsY H'vL HHH]HtHUHjLEL+IHIHM/H3pL$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`HA HAL   MtAn Hu;Hb H? Y@ &  39 ?  ?  H
 A&  x3H({HAPH HAPHAPH HAPH\$WH0HIX35HHu?H H
	 A   H> >  D? j8 3H\$@H0_H@ H4 HHu\HM A   >  H{> D<? 8 H+uHCHP0D? 7 H
b	 M3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHl$H   HEH$   LWEE3L}L}L}L}L}=/HEL}L},/HEAEL}wH=GB HH
}<  HHtH H"JHHu>   6 =    HCL   H9 HMtAԿ HHu=   6 =    H+u
HCHP0HFL   H)@ HMtA~ HHu'Ho H< f=   @6 =  p  H.u
HFHP0ILkHI I9E z  HsHm  H{HHHHH)uHAP0LoIE H; u;HuLeA   HUHFHHu{<   5 =    H; uqHOQ=   u^HuLeHA IuHOE3EAHUHHuf<   @5 =  M  H.u
HFHP0I       LHu'H
 H
V; <   4 =  	  HpII$L` E3IH8DHHu;   4 =    I.u8IFIP0,IHAHHu;   r4 =    H+u
IE HP0HGH H;   H;F    H׼ HHu!4 =     H/u
HGHP0HFH   MHHMHtTA   HLHtAHHj=y:   3 =    L)&u
HFHP0I   H.u
HFHP0In=uIR>:   b3 >  o  HOHtf~A   Hh H
 H	 
Hx>3 =  H+ M&:   HW9 H/.  HGH  H;u
Lw H_H_LsHHIH/u
HGHP0H]LuHHM HHEH;tJHUHRHMH(HMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHM'HEH@HEH HEH@L}H}HIHM HHEH;tJHUHRHM~%HMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUHM   DBoHMLMLEHUHMgHI裀HHMױHUHtLEL+IH
; =LHu'HK H7 B8   1 ,>  L  H@L   HQ7 IMtA HHu'H H07 7   0 .>    I.u
IFIP0HMLHu0 1>    ILcH I9$b  HsHU  H{HHHHH)uHAP0LgI$H;6 uJHuLuA   HUH@HHu0 E>    H.  HFHP0  H;C uOHOQ=   u<HuLuHA IuHOE3EAHUHHu/ N>        w LHEwHu'H
 H
5 6   e/ U>     HpILp ME3IH>HHu2/ [>  8Im    IEI   IHz<HH   . >>  
6   H H45 HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0HMwHt
H)uHAP0D5 ~. H
S #I.u
IFIP0H+u
I$HP0LHMHt
H)uHAP0HMHtH)uHAP0LEMM HUwHMe   DBoHMcLEMM HUwHM+   DBoHM9HUHtLEL+IIH$   Hİ   A_A^A]A\_^]HSVWATAUAVAWH   H@HLW@E3LPD$hLt$xD$PLt$`AAEL`LXH; tJHtEH(HD$0H$   u]H H)3 3   , <    L$   L$   HQ, H$   H$   L%: L$   HH$   rHL$hH;t%HHL$hHHHL$pHHHL$xL0LpLpH$   HtL$   L+Ib Ht'H( Ha2 3   + =  O  LD$hH$   IMxHL$PH;t%HHL$PHHHL$XHHHL$`L0LpLpH$   HtL$   L+IHT$PH$   ǧL%5 IH
0 X HHtH Ik>HHu'HT H1 K2   %+ =  '  HCL   HZ1 HMtA HHu'H  H91 1   * =    H+u
HCHP0H$   HHu'H H0 1   * =    ILnH I9E   H~H  LnHIE HIH)uHAP0IEH$h  H H; u[H|$@H\$HA   HT$@Id:LHu'H
 HF0 1   ) 2=    H/_  P  H; ujIMQ=   uWH|$@H\$HHA IuIME3EAHT$@LHuH H/ 0   \) ;=  ^     0 LHu'H
Q H
/ H0   ") B=  $  HxIHX E3IIp8LHu'H	 HB/  0   ( H=     I/uoIGIcHH'6LHu'H H. /   ( +=     H+u.HCHP0"HGHP0H+u
HCHP0L$h  H.u
IE HP0H$    \  H$   H
֑ H;IDH$   H$    +  E3AAAEHtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0MtI/u
IGIP0H=J  HLxPL`XLh`LpPLpXLp`H$    t%H$   H;IDH$   H$    HKPHsXH{`L{PLcXLk`Ht
H)uHAP0HtH.u
HFHP0HtH/u
HGHP0D. & H
1 <MHT$PHtLD$`L+IHT$hHtLD$xL+IH$   HtL$   L+IIH   A_A^A]A\_^[H\$WH0LRHHx% HL;u   ^HuH
 H~ H	ծ >It   -H
a L^ IBLJH[ HD$ H	M 3u/H
 H
!, ,   % <  3H\$@H0_HHH\$@H0_#HL$USVWATAUAVAWHl$H   HAE3H+ LLmALmoAL   LmLmwMtA= HHu'H. Hg+ %,   $ 	;    HCMH;    LsM   L{HIIIH)uHAP0II2LHu+   $ ;    I.u
IFIP0MH+u
HCHP0I/u
IGIP0ID$IH+ L   MtsAtH;* uE33H41H;r uHC@t3H2H( E3H`3LHk*   # ;  %  ݬ Hu'Hѳ H
* *   # &;    L=- H
( IHEv HHtH I6HHuw* 	  Q# 2;    HCHH( L   MtA; LHu1* 	  # 4;  \  H+u
HCHP03 HHu'H H,) ) 	  " 7;  8  IL$(H;
 u0H
 H H	N ) 	  " ;;    H+ Q HHu) 	  Y" =;    H@IH;I t_H; tVHMҪ HHu8) 	  " C;  c  H@L   Mu') 	  ! E;  :  HH3DDH/uHGHP0fMu>H H9FuL;~   HFJ<HI)L;~   J|HIHAHHA  HMwH}wHt
H)uHAP0HJ+ H1 HH   HKH9K ~H HCH<HAHCAHHg -( 	    k;  @  3H.u
HFHP0H Mf3I9$A  IvH4  M~IHMIH)uHAP0IGMgH;|   A   HuHUH]I0LHu{r' 	  L  ;  
  Y' 	  3  i;  
  ĩ H7H$ HHtg ' 	   a;  ;
  H.u
HFHP03H+u
HCHP0I.u
I$IP0H
* L}o/,LHG  H H% & 
  u ;  
  H; u^IOQ=   uKHuH]HA t3IOE3HUEALH=4& 	   ;  _      HHu& 	   ;  3  HpE3HHX I31.LHu'Hʮ H% % 	   ;    H/HGHHI+LH{% 	  U z;    H@IH# L   MtA? HHu'H0 Hi$ '% 
   ;  u  I.u
IFIP03 LHu'H H"$ $ 
   ;  C  HMgHI(H;
 u>H
 H2 H	A H H# $ 
  k ;  
  H& 6 HHu'H_ H# V$ 
  0 ;  
  H@H;$ t\H;c tSH HHu$ 
   ;  A
  H@L   Mu'# 
   ;  
  HH3DDH+u
HCHP0Mu>H H9FuL;n  HFJHI)L;n   J\HIHAHH   HMwH]wHt
H)uHAP0H2 H HHtOINI9N ~H IFHHAIFGHIK 3" 
   ;  $	  H۫ H" " 
   ;   	  = Ht H HH6    H.u
HFHP0H LgE3AI9$&  HwH  LHHIIH)uHAP0IGMgH;    A   HuHULuIT+LHuNH H6! ! 
   ;  B  H֪ H! ! 
   ;    H.u
HFHP0II.u
IFIP0H/u
I$HP0H
$ L}&HHf  H` H  W!   1 <    H;y ukIOQ=   uXHuLuHAI uIOE3HUEALH=H H%    
   ;  1      HHu'H H   
   <    HpE3Lp HIIM(LHul  
  F <    H+HCHIH&LHH! HZ   
   ;  f  H@HH$ L   MtAܡ HHu'Hͨ H     <  '  H/u
HGHP0H LcII9$  H{H  L{HHIIH)uHAP0IGMgH;, uFLuoHUA   LuIH}t(LH      M 2<  F  H;=    IOQ=      LuoLuH}HAI uIOE3HUEALHu   M :<    H/u
HGHP0IH+u
I$HP0I.IL}ouIFP0H= D9(m  HMҡ HH   H. Hg %    X<       ӟ LHu    @<  $  HxE3HEoIIIH IF &LHu    F<    I.u
IFIP0LuoLuoHI#LHk   MB ,<    Iؠ Hu'H; Ht 2    Y<    H;t7H
W H	& H H8     \<  Y  H
   K"HHu'Hĥ H  
   h<    H@HH> L   MtA LHuY j<    H+u
HCHP0   ՜ HHu'H> Hw 5 
   m<    IMfH@IHML8HHCHHH I9$  I~H  M~IHMIH)uHAP0IGMgH;    A   H}HUH]I$LHun <    H/u
HGHP0H+u
HCHP0I.u
I$IP0IMHMHt
H)uHAP0HMoHt
H)uHAP0HMHt
H)uHAP0MtIm u
IEIP0HEwHtH(u
HPHR0IHĸ   A_A^A]A\_^[]H; uSIOQ=   u@H}H]HAI uIOE3HUEALHT <        ( HHu2 <  |HxE3HHX II"LHu$H HU  
   <  dH.HFHHI6 LHe <   
  H H HtH+u
HCHP0MtI.u
IFIP0HtH/u
HGHP0HtH.u
HFHP0E3DZ H
 1 HHPHHUH   HV 3HXHxL`DLhDLpDLxDHAH$   Hl$hHl$XL   Hl$xH$   H$@  Hl$PMtA H$  HHu'Hx H o   I 8  t  HGH;e H$H     HOH$H  H   HwHHHHH)uHAP0H$H  HUHHu'H H'     9    H$H  H)uHAP0H$H  H/u
HGHP0H.Hu
HFHP03 HH   x   R 9    H;: uE33H 1H; uHG@t3HH+ E3HpHH[H H>     9    H$0  HI(H;
 u0H
 H H	Y     9    H \ HHu   d 9  a  H@H;X toH; tfHHD$`ۗ H$H  Hu<    9    H@H   HL$pHu3    !9    HLH$H  H\$`Hl$pH\$`LL$H  H/uHGHP0D  MuHH I9GuI;_  IGH<HHH\$`.I;_  I|HHH\$`IAHH  H$   LH$   Ht
H)uHAP0H
 HLH6  HHH6 H   IHt HH  I/u
IGIP0H I LH  H
 )LHt  HHH H   IHt H$@  LH   I.u
IFIP0HF I% LH  HR MeHl$PI9$  MELD$PMn  MmH$@  I HL$@  IE H(uH@P0LD$PIEMeH; L$   uQL$   H$   A   L$   ILH  HD$PH(u
HPHR0Hl$P   H; uiIMQ=   uVL$   L$   HAH uIME3H$   EALH  HL$PH)uHAP0Hl$Py   Δ LH  HT$PE3HPILp HHl$PL'LH]  I,$uID$IP0L$   'IILH  I.u
IFIP0H$@  H)uI$P0   0 H$@  LH  H
 E3LxHLLh LHo  I.u
IFIP0H$ LcH$@  I9$h  LCL$@  MS  LsHI IIH)uHAP0L$@  IFMfH; uTL$   H$   A   L$   IHHH  H$@  H)uHAP0H$@     H; ueINQ=   uRL$   L$   HAH uINE3H$   EAHHu    	 9  	      LH  H$@  E3Mo IIIGH$@  LHH  I/u1IGI%IHHH  Im u
IEIP0H+u
I$HP0HNHH9N ~HHFH<HAHFHHp :  H/H\$`Lt$pL$H  LHGHP0=HI/u
IGIP0H$8  LH$   袾G  H LH     9  l
     p e9  j  }   W n9  Q  d   > {9  ;  K   L" u9    /   	 9         9        9        9        9        9       s 9  j     Z ^9  T  g   L> Q9  8  K   L" N9    /   L L9         J9    
    G9    
   H E9    I HH HH>t 
   Hl =9  ]  tH  H$0  HH(H;
6 uAH
 H H	 H> LHt 2
    9    H ׺ HHu*H  LH6     9        H$H  HHu 9  H  IE3H
 HLxHp HHum 9  H  H+u
HCHP0HFH;N tZH; tQHI֍ H$H  LHu 9  H  H@L   Mu& 9  H  HLH$H  LLH.u
HFHP0INHH$       Mu<H I9FuM;f
  HJ4HI(M;f  J4HIIAHH  HFH H;   H;J t~Hߌ LH2  H.u
HFHP0IGILH   HH  IA   HH  IHx
S  M)7uGIGI;HNHo  H;u
H^ H~H~H_H?HHH.u
HFHP0HL$hLH|$hHt
H)uHAP0HL$XHH\$XH$0  Ht
H)uHAP0IGHH;8 tKH;w tBII HH,  H@L   Mu,
    e:    IILL    Mu>H̉ H9FuL;v   H^JHI)L;v   J\HIHAHH   HL$xH\$xHt
H)uHAP0HL$hHA HH  L$0  HuHHx  H+u
HCHP0HT$xLHL$hHk 4  H/!HGHP0H+w Ht Hۈ HHp3   H.u
HFHP0H$0  HL$H  H$   HD$XH LH L   LV H:  v  I/u
IGIP0L%uI	H: LHp L+   L P:  "       @:          c:  *       :  C     :  -     :     u  :  HH LH LH$0  LHD$XLY~H
Ĉ H] A   H	 
Hx
  +:  &   LLLLH HD HtH.u
HFHP0HK  H/A  HGHP02  O Ht H HHH    I.u
IFIP0L$   IIL$   L$   L$   H$  H$  H$  MtI/u
IGIP0HL$hL$   Ht
H)uHAP0HL$XHt
H)uHAP0HL$xHt
H)uHAP0H$   HtH(u
HPHR0HH   ] :     LLLLH H H$H  Ht
H)uHAP0MtI/u
IGIP0HtH+u
HCHP0MtIm u
IEIP0MtI.u
IFIP0H$@  Ht
H)uHAP0HL$PHt
H)uHAP0MtI,$uID$IP0D H
  L$   :H\$Hl$VWAVH@Hχ IHzLH\$pHM   HtH   HZH\$pH HHu)H  H H" HtHHD$pHH   H" HHD$(LL$pH H|$  y
8     H\$p   H   H   H H|$0HH H?L
 HL HHDHHD$(HF HL$ LIH
΄ H H	΄ 8  Hj H I [   A  H
 3HZHIH\$`Hl$hH@A^_^HHPHHATH   HE E3HXAHpAHxLhELpEHALd$XLd$hLd$pL   L$   L$   MtA H$   HL$   Hu'Hq H h   B 7  
  HGIH;[    HoH   LwHHE IIH)uHAP0HI_LHu    7  	  Hm u
HEHP0IH/u
HGHP0I.Iu
IFIP03/ LH   H H     e 7  	  H;M uE33H
1H; uHG@t3HH> E3H	LHM    7  
	  H$   HI(H;
˂ u&H
2 H H	z  7  W  H 臮 HHu 7  4  H@IH; Lt$PtMH;Á tDH HHuZ 7    H@H   HL$`Hu6 7    HHMLd$`H/u
HGHP0HD$`Hu>H H9EuL;u4  HEJ<HI(L;u  J|HIHHH   HL$hH|$hHt
H)uHAP0H Hz HH   H H^ HHtgH/u
HWHR0IOII9O ~HIGHHAIGHI uH+HCH 7      7      7     { HtH~ HHttW" Hm u
HEHP0H$   ML|$X脭yeH H    r 7     c 7  IHm H d   I/g  IGIP0X  tIIs  3~ HHu'H HX     7    H$   HH(H;
 uAH
+ HL H	s H̆ IH     7    Hb e HHu'H H    _ 7       3 HHu'HT H K   % 8  ^  IE3H
o HLxHX oHHu 	8    H/u
HGHP0HCH;| teH;~ t\Ha~ HHu'H H     8    H@L   Lt$`Mu$o 8  {  HHLd$PMLd$`HH+u
HCHP0MuHH9| H9GuH;wa  HGHHHHt$P.H;wB  H\HHHt$PHAHH  HCH#} H;+  H;{   H\} HH  H+u
HSHR0HNIML   HAH$   MH  HA   ALHm  HAHH  L)>u
HFHP0Lt$`HL$pL$   L|$pHt
H)uHAP0H$   L$   L$   Ht
H)uHAP0L$   IM
HHR  HMH9M ~eH HEHHAHEdHKH_  H;u
Lk HCHCLhH H$   H IE H+3HCHP0$HHz    H+tL$   Ht$PL$   HCHP0L$   Ht$PL$    [8    H.u
HFHP0IuI c8     S8    H IH H$   H$      u l8    H} IH H$   H$   a   ; j8  _  ~,H
z HJ A   H	z 
 >8    Hx >8     { Ht Hx HH~   (y H/u
HGHP0Lt$XLL$   L$   H$   H$   H$   H$   MtI.u
IFIP0HL$hL$   Ht
H)uHAP0HL$pHt
H)uHAP0H$   HtH(u
HPHR0IH   A\ .8  IL$   M   H H+ HtH/u
HGHP0HtHm u
HEHP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtH.u
HFHP0Lt$XDb H
 9 H\$Hl$VWAVH@HOz IHzLH\$pHM   HtH   HZH\$pHx HHu)H  H+ Hv HtHHD$pHH   HB HHD$(LL$pH֗ H|$ ly
[7     H\$p   H   H   H~ H|$0HH H?L
x HL HHDHHD$(H HL$ LIH
Nw H H	Nw i7  H~ H#     A  H
λ 	3HZHIH\$`Hl$hH@A^_^ATAWH(HAE3H EH\$@Hl$HHL   MtAKw Ht$PHH|$XLt$ Hu'H-~ Hf $    6    HCIH;v    H{H   HsHHHHH)uHAP0HHHHu'H} H     6  O  H/u
HGHP0IH+u
HCHP0H.Iu
HFHP03t HH   HD} H} ;    6    H;w uE33HV1H;Ex uHC@t3HWH E3H3HHMH| H     6  b  HM(H;
uu u&H
t H
 H	$u f 6    H 1 HHuC 6    H@H;7s tLH;vt tCHHt HHu	 6    H@L   Mu 6    HHIMH+uHCHP0D  Mu>Hr H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0Hd H3r HHtEHNH9N ~H HFHHAHFDHHmr 0 7      	7     t HtHq HHztf(r H/u
HGHP0HLH.u
HFHP0Lt$ H|$XHt$PHl$HH\$@MtI/u
IWIR0IH(A_A\Z 7  Hgz H ^   H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D H
f  KLkHL@HPHHSVWATAUAVAWH   H@HWhE3LxPL`AED$pLHD$XL|$hEL% IH
 @p HHtH ISHHu'H<y Hu 3   
 5    HCL   HB HMtAq HHu'Hx H!     5  h  H+u
HCHP0IH$X  LfHp I9$  H^H$X  H  H~HHHHH)uHAP0LgI$H;7s uaH$   H$H  H$   A   H$   HoHH   Hx HM     6    H;-s    HOQ=      H$   H$H  H$   HA IuHOE3EAH$   HHu'Hw H    Y 6    H+u
HCHP0IH$X        
p LHu'H
.w H
g %    6    HXIH$X  H$H  H IF E3IH:HHu'Hv H     6  h  I.uFIFIP0:HHHHu'Hv H ~   X 6    H.u
I$HP0HGL   H= HMtA2o HHu'H#v H\     "6    H/u
HGHP0HHL$ ^HHL$p1fHT$ HtLD$0L+I@o Ht*Hu H    } %6  M)  H.u
HFHP0IHT$pH$   aH$P  /@@u5n Ht*H9u Hr 0   
 06  M  H$   H$   bDLHT$ H$@  HI,HHL$X/eHT$ HtLD$0L+IHT$XH$   `H
 HHu*Ht H    _ A6  M  H@L   H HMtAFm LHu'H7t Hp .    C6    H/u
HGHP0H$   ReHHu'Hs H$     F6  k  IMfHk I9$  I^H  MfHI$IMH)uHAP0ID$H$X  HH;
Qn u[H\$8H|$@A   HT$8IHHu'HCs H| :    Z6    H+\  M  H;
Mn ulIL$Q=   uXH\$ H|$(HA IuIL$E3EAHT$ HHuHr H     c6  *     dk LHu'H
r H
 |   V j6     HXHx E3IIHHu'H@r Hy 7    p6     Im ulIEI`HI]HHu$Hq H/     S6  dH/u.HGHP0"HCHP0H/u
HGHP0L$X  I.   I$IP0   E3AH$X  AEMHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0MtIm u
IEIP0D  H
߬ :IHT$XHtLD$hL+IHT$pHtL$   L+IݓH$   HtL$   L+I軓H$   HtL$   L+I虓HH   A_A^A]A\_^[H\$Hl$Ht$WATAUAVAWHPH=Uj E3H|$HAH\$@MHLM   LzIMt"HtH   Hz H|$HHZH\$@Ih HIMtHt&MH If HD$@HH   HH(  H I\f HtHHD$HHH   H̨ IHD$(LL$@H L|$ &y
5     H|$HH\$@   HBH   H   HNHm HHL$0Ht HLL
# AHD$(IH HLd$ H
g LI LMH> H	f 5  Hn H x    A  H
 踸3Hz HZLHInL\$PI[0Ik8Is@IA_A^A]A\_HLH L@HHVWATAUAVH   H@HXLW@H@    33D$@Ht$PL5 IH
 d HHtH IHHu'Hm H    r /5    HCL   H HMtA\f HHu'HMm H D    15  g  H+u
HCHP03H\$ LgH#e I9$  H_H\$ H  LwHIHIH)uHAP0MfI$H;g uYH$   L$   A   H$   ILH   Hl H    Y E5    H;g    INQ=   u}H$   L$   HA t3INE3EAH$   LHu'Hl H@     M5  !  H+u
HCHP03H\$       d HHu'H
k H
     S5    HX3H\$ IE Lh E3HILHu'Hak H X   2 Y5    H.uFHFHP0:IH|LHu'Hk HN     ?5  /  H/u
I$HP0IFL   H IMtAc HHu)Hj H     _5  3  I.u
IFIP0HD$0    HHL$pQSHHL$@ZHT$pHtL$   L+Ifc Ht)H,j He #    b5  3D  H/u
HGHP03HT$@HL$X!VH$   贏AAu4Rc Ht)Hi H     n5  3   H$   g@@u4c Ht)Hqi H h   B o5  3   HT$XHL$pVDEHH$   HIL#a HH   H
i HC     v5  3%Lt$0H\$ IIMtI.u
IFIP0HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D f H
 趲3HT$@HtLD$PL+IyHT$XHtLD$hL+I]HH$   Hİ   A^A]A\_^H\$ UVWATAUAVAWH`H( H3HD$XL5b 3H-` MHt$@HLt$HLHl$PM%  LbIMt1Ht"HtH%  Hj(Hl$PLr Lt$HHrHt$@I&` HIMtHt,HtOvH~ I%^ HD$@HH   HHo  HA I] HtLHD$HHHF  HP I] HtHHD$PHH  H7 IHD$(LL$@H Ld$ y
4     Hl$PLt$HHt$@   HBH   H   H   HWH%e HHT$0A   H
(l HLL
 HL$(   H
x^ H;AMLҾ HHD$ H	H MML V^ 
5  He H+     A  H
 3Hj(Lr HrLMHIHL$XH3qH$   H`A_A^A]A\_^]@SUVWATAVAWHpHb& H3HD$`H-[ LLHH
 M33\ HHtH H)HHu q4  Q  HGHH L   MtA] HHu s4    H/u
HGHP0HCHH L   MtA] HHu'Hd H    [ v4    H+u
HCHP0Hk\ 33H9Gu+H_Ht"HGHHHH H)uHAP0   HGH;^ uIHT$(HDEH+H\$ HLt$(L|$0Ld$8+HH    4    H;_    HOQ=   uxLT$HHDEL+H\$@Lt$HL|$PLd$XHA t3HOE3IHHuC 4     H  H+
  HCHP0   M[ HHuH
c H
Q  4  ZHtHX3IE3HHLtEIL|EI$Ld#HHu~ 4  Hb H    HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0Dc H
\ : 葬3#H.u
HVHR0H/u
HWHR0HHL$`H3mnHpA_A^A\_^][H\$Hl$Ht$WAVAWHPHZ MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I>Z HHHtHt+RHJ  H I:X HtHHD$@HH!  H IX HtHHD$HHH   H IHD$(LL$@H%y Hl$ y
A4     H|$HH\$@   H   H   H   H
b Hl$0HL
 H?L HH HHLIH
Wf HL$(H
X HD$ H	X R4  HU` H 4 F   A  H
ٙ t3Hz HZLHIH\$pHl$xH$   HPA_A^_H\$Hl$Ht$H|$ ATAVAWH H5 LHHH
 MM3V HHtH HHHuj 3    HGHH3 L   MtATX HHu. 3  D  H/u
HGHP0HCHH L   MtAX HHu'H^ H2     3  
  H+u
HCHP0U HHu 3     H LHU yw 3     H MHU yQ 3  jH< MHpU y. 3  GH MHMU y 3  $H LHcHHui 3  H] H+    HtH/u
HGHP0HtH+u
HSHR0D H
  3#H/u
HWHR0H+u
HSHR0HH\$@Hl$HHt$PH|$XH A_A^A\@SUVWATAVAWH`H2 H3HD$XH=U MH- LH5/ LrH|$@IHl$HHt$PM#  Mt1Ht"HtH/  Hr(Ht$PHj Hl$HHzH|$@IiU HIMtHt1HtT{H  H I_S HtHHD$@HHl  H? I6S HtHHD$HHHC  H~ I
S HtHHD$PHH  HM IHD$(LL$@Ht Lt$ y
3     Ht$PHl$HH|$@   M   H   H   H   HbZ Lt$0IHla H?L
ŷ HL HHHDMHD$(H HL$ LIH
S Hص H	S 3  H3[ Hl  $ y  Ay  H
 R3Hr(Hj HzLLHIHL$XH34gH`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   H MtAsS H|$PHHud v  > F3  D  _Q HHu! H3        R HHuH
Z H
O  J3  lILLxHH' 	Q y O3  4H+u
HCHP0H LHHHu^ Q3  HY H  v  H.u
HFHP0HtH/u
HGHP0HthH+ubHCHP0VH.u
HFHP0H/u
HGHP0IHHO Hu= w   `3  HY H; D H
  *LL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAH L   MtA`Q Ht$0HH|$8Hu'HGX H > s   2  '  HC3H;2P u{H{HtrHsHHHHH)uHAP0HH?HHu 3     H/u
HGHP0H+u
HSHR0HH|$8Ht$0H [H;vR uE33H1H;R uHC@t3HHg E3HHHu. 3  H;W Ht 2 s  HtH+u
HCHP0HtH/u
HWHR0D H
  /H|$83Ht$0H [;HAVAWHXHXE3HhEH- HpHHxALhALH
 SM HHtH HfHLd$HHuO o  ) f2    HCHH L   MtAO HHu	 o   h2  Z  H+u
HCHP0HGHH L   MtAN HHu'HU H  o   k2    H/u
HGHP0HM LcII9$  H{H  HkHHHHE H)uHAP0HELeH;P uBA   H|$ HT$ Ll$(HUHH    o   2  P  H;!P    HMQ=      H|$0Ll$8HAI uHME3HT$0EAHHu o  l 2    H/u
HGHP0IH+u
I$HP0H
9 LHH   H6T IHl * p   2       L HHu'H
S H
2  o   2  O  HxE3IE HHLh IHHu o   2    H.)HFHP0IHHHi o  C y2     H"yy& 2  I   H+u
HCHP0   HEHHl L   MtAK HHu'HR IH  p   2  QH7 E3HHHu| 2   p  HR H HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0DL H
 # zH+u
HCHP0HHE LLl$@Ld$HH|$PH$   Hl$xH\$pMtI/u
IWIR0IHXA_A^H\$Hl$VWAWH@H- LH
 H33hH HHtH H{HLt$`HuH 1  c  HGHH L   MtA2J HHu 1  '  H/u
HGHP0HCHH L   MtAI HHu'HP H  l   1    H+u
HCHP0HH Lw3I9|  H_Ho  HoHHHHE H)uHAP0HELuH;7K u4A   H\$ HT$ L|$(HHHuo 2  -  H;ZK    HMQ=   uzH\$0L|$8HA t3HME3HT$0EAHHu 2     H+u
HCHP0H/u	IHR0HLt$`H\$hHl$pH@A__^ù   LH HHuH
mO H
 H 2  tHXE3IHHLx 3HHu 2  7H.pHFHaIHbHHM 2  HN H&  l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0D H
g u ̘3@USVWATAUAVAWH$H  H5 H3H  E3HT$`HLEHp  MAHULMEH AHHAHH HL$XLeL   LeLeH\$PLd$hLeLd$pLd$xLe LeLeLeLeLeLeLeLd$HMtAF HHu'H|M H s 1  M *  <L  HGH;iE    H_H   LwHHIIH)uHAP0HInLHu*HM MH=  1  ռ +  ?K  H+u
HCHP0IH/u
HGHP0I.Iu
IFIP0H
F H9M  L;A  L5m H
 IUC HD$8H   H    H;8G uE33H1H;G uHG@t3HH) E3HnLH9HL MH9  1  ѻ 	+  ;J  IHD$8LHu 3  M *+  I  IFIH L   MtAD HHu 3  MW ,+  I  I.u
IFIP0H E3HLHu*H5K MHk ) 3   /+  mI  H/u
HGHP0I.u
IFIP0H
C H9M  L;-
C A  H
 8LHu*HJ MH  5   X+  H  H@IH L   MtAiC HHu_ 5  M6 Z+  |H  Im u
IEIP0Hſ E3HzLHu*HJ MHI  5   ]+  KH  H/u
HGHP0I.u
IFIP0H
B Ll$`L;   Lt$XIF(H;uAH
A H} H	6B HI MHſ  8  ] +  G  H} H%n Hu*HQI MH E 8   +  G  Im IHD$`   IEP0   H
  {LHu*HH MH*  9  ¸ +  AG  Lt$`II? u 9  I +  MF  Im u
IEIP0t\   @ HHu*HkH MH _ :  9 +  F  IIH@HT$`L0I.uIFP0Lt$XH
% HHu*H	H MH?  ;  ׷ +  VF  H@HH L   MtA@ HHu*HG MH  ;   +  E  H/u
HGHP0HCHH L   MtAZ@ HHu*HKG MH ? ;   +  E  H+u
HCHP0IN(IH;
? uAH
I? Hz H	? HF MH  ޽ ;   +  "E  Hض k HHu*HF MH  ;  z +  D  IN(H;
V? uAH
> Hz H	? H^F MH R ;  , +  D  Hܽ j LHu*H
 F MH
V  ;   +  XD  H> MELd$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;@ )  HD$`H0  H0  EFAHHH+L(  H8  L@  LHu*> +  HKE MH ? ;  C  MtIm u
IEIP0H+Ld$Hu
HCHP0I/u
IGIP0Ll$`H/u
HGHP0Im IILt$`MuIEP0H]H;=   ; H  HD MHպ I =  j ,  C  H;? u|HOQ=   uiHD$`LP  HP  EFAHL+LH  HX  L`  HAI uHOE3ILH +  AN< HD$0HHu*H
C LH
 ʺ ;   +  B  Mt	LhLd$HLl$`E3AHIE LlAFH\AFL|IMLHu,HbC Lt$0H T ;  . ,  A  HL$0H)<HAP00H+HHEuHCP0H\$XHK(H;
; uDH
=; H6w H	; HB MH IϹ ?   2,  WA  Hɲ tg LHu-HB MHӸ I ?  h 4,  A  HK(H;
D; u9H
: Hv H	: Q ?  M( 8,  MIh@  H f HHu" ?  M :,  MI2@  HIw: LHu ?  M <,  I?  Im u
IEIP0H/u
HGHP0H
 LuMHHu*HA IH y @  S J,  @  H@HH L   MtA=: LHu-H.A MHd I @   L,  c?  H/u
HGHP0IEIH L   MtA9 HHuɷ @  M O,  I>  Im u
IEIP0H8 MAH9Gu,LoMt#HGHIE HH H)uHAP0   HGH;1; u`LEH   L   HϋDCHH+L   L   bLH    @  M a,  I&>  H;(;    HOQ=      LEL   L   DCHL+L   L   HAI uHOE3ILHu| @  MS i,  I=  MtIm u
IEIP0M   K8 LHu. @  I o,  K=  MtLhMHME3HT$`HILCHHITI4LHuҵ @  I z,  <  I/u
IGIP0H/u
HGHP0I.u
IFIP0H
 MHHuo B  IF ,  M<  H@HH L   MtA-7 LHu# B  I ,  @<  H/u
HGHP0IGIHC L   MtA6 HHuʴ B  I ,  ;  I/u
IGIP0H\$XMHK(H;
e6 u3H
5 Hr H	6 r B  II ,  ;  Hi b LHuB B  I ,  _;  HK(H;
5 u3H
\5 Hq H	5  C  I٬ ,  ;  H a HD$8LHu*H< IH  C   ,   ;  HK(H;
r5 u3H
4 Hrq H	!5  D  IV ,  :  H6 !a HHuO D  ) ,  o:  HI4 MLd$HH9Gu2LoLl$HMt$HGHIE HH H)uHAP0A   HGH;6    HD$8H  H  EFHD$`HH  AHH+L  L  H  ޻LHup ,   B  9  MtIm u
IEIP0I/Ld$Hu
IGIP0HL$8H)uHAP0H+}  HCHn  H;[6    HOQ=   uHD$8L  H  EFHD$`H  AHL+L  L  H  HAI uHOE3ILH'~ ,   B  8  ANI3 HHu/H
j: MLl$8H
 Y B  3 ,  8  Mt	LhLd$HHT$`ANAE3L|MHD$8HDAFHH\AFHIHTHHLHu'H9 H ذ B   ,  8  H.u
HFHP0H/u
HGHP03Lu1 HD$0LHu-H9 IH Ir G  L ,  7  L|$XIO(H;
#2 uDH
1 HKn H	1 H+9 IHa I G   -  7  H ] HHu-H8 IH  Iۯ G   -  c7  IO(H;
1 uGH
0 Hm H	@1 H8 IHϮ M G  Ia -  6  H) ,] HHu-HU8 IH MF G    	-  6     0 HHu*H8 MHK 	 G   -  M6  H
3 E3HHxHp 0HHu*H7 MH  G   -  6  H+u
HCHP0HFH;{.    H;/ t}HI/ HHu*H`7 IH T G  . -  5  H@H   H}Hu:H"7 MHX  G   -  o5  HHMLeIH.uHFHP0    Hu>H- H9CuL;k  HCJ4HI(L;k  JtHIHHH  HFH. H;,  H;Y-   H. HD$@LH  H.u
HFHP0IGIHL$@ML   ALd$8HH  HL$@A   AHD$8H  L|$@IAHhM  I/u
IGIP0Lt$8HL$xH|$xHt
H)uHAP0HMIHEHtH)u
HAP0IHH{- Lt$0HH  INI9N ~cH IFH}H4HAIFUHNH{  H;u
Lv H~H~LwH?HIH.IHFHP0:HI9,    H}IH+u
HCHP0HMLuMZ  H4 IH  I  | -  *3   G  c e-  2  HL$@H)uHAP03uIM G  ' m-  `2  H/4 Hh & G    ]-  2  H4 MH>  G  ֣ v-  U2  H3 MH Ҫ G   t-  +2  ~H
", H A   H	+ 
HxXH3 MH } G  W H-  1  , HzHH* HHst* YH/3 MHe # G   8-  |1  "  H
 rHHu*H2 IH! ߩ J   -  g1  H@HH L   MtA+ HHu*H2 MHʨ  J  b -  0  H+u
HCHP0Hr* IH9F   H^H   H~HHHHH)uHAP0HHpLHu*H	2 MH?  J  ס -  V0  H+u
HCHP0IH.u
HFHP0Ll$`ILt$PIEH;(    H;)    IHE* HD$0LHuhHs1 MH g K  A -  /  HPLHiH51 MHk ) J   -  /  H@H   HEHuFH0 MH-  K  Š -  D/  IE IIHMHEMLl$0HMMLd$@IMHuFH' I9FuI;N?  IFH4HHHM,I;N!  ItHHHMIHH  HD$hHt$hHHt
H(uH@P03' HH  HT$hHM& HHT  H@H;& t]H; ( tTIHLue( HD$8LH   H@H   HMHu4Lt$0 M   -  -  HLH\$8MLeLeH+uHCHP0@ HEHuFHH& I9EuM;u7  IEJHILu,M;u  K\HILuIHH  HMH]Ht
H)uHAP0H
 IWHH  H@HH L   MtA' LH  H/u
HGHP0IGIH$ L   MtAm' HH7  I/u
IGIP0Hb& MALd$@MH9Gu3LL|$@Mt%HGHIHH H)uHAP0   DHGH;( uhHEDAH   H   HD$XL   H@(H  HHH+ HH   Lt$0 L   5.  +  H;(    HWDBA=      HEL  H  DYHD$XL  H@(H   IHL+HBA uHOE3MIHHr  MtI/u
IGIP0MLd$@   % HD$HLH  MtLxMLd$@HEE3HL$XIH KDHA(H HA(HKD HH&  Im u
IEIP0Ll$8Ld$HH/u
HGHP0HNIH9N ~HHFLuHHAHFHHj#   LuI+% Ht H" HHl  1# Im u
IEIP0HMLHuHt
H)uHAP0H
 ILH  H@IH L   MtAs$ HHu  Im u
IEIP0Hg# L{MLd$8I9S  LkLl$8MA  LsHIE IIH)uHAP0IFM~H;% uIHEHU(A   HE0ILm(#HHutL|$@Lt$0ǡ N   .  (  H;% ucINQ=   uPHEHE@Lm8HAI uINE3HU8EAHH  Im u
IEIP0MLd$8t   	# HH  LhE3HEHILd$8MH HG `HHm  H/u
HGHP0IIH4HH  H+u	IHP0HL$pHt$pHt
H)uHAP0HMIH HAL   MtA|" HH8  H! IH9CuRH{HtIHsHHHHH)uHAP0HH臦HH  H/u
HGHP0IHHH  H+u
HCHP0L|$hHII! Dx
AADE;  H.u
HFHP0IE8  Lt$pHI IIFL   MtAs! HH  HMI2 HH  H_  L{MLd$8I9  LkLl$8M  LsHIE IIH)uHAP0IFM~H;"    A   LmHHUHH}PIHH
  Im u
IEIP0H/Ld$8u
HGHP0Lt$pH+u	IHP0I.HH\$pIIuIFP0L|$h  H;" ugINQ=   uTLmXH}`HAI uINE3HUXEAHHTL|$@Lt$0 P   .  /%      HD$HLH
  HD$8E3IIEILd$8I} HH  Im u
IEIP0Ld$HHHHH  H/HGHP0H\$pr HH  LIH_ w  HL$xLHt$xHt
H)uHAP0HL$PIH HAL   MtA HH  LxLd$HH I9T  LkLl$HM=  LsHIE IIH)uHAP0IFM~H;j  uEHD$xHUhA   HEpILmh豥HHusL|$@Z R  4 (/  p#  H;|  udINQ=   uQHD$xH   LmxHAI uINE3HUxEAHH  Im u
IEIP0Ld$Hx    HH  LhE3Ll$xHILd$HIE Lh HHp  H/u
HGHP0ILl$xIH¡HHb  H+u	IHP0H.Iu
HFHP0Lt$XIIN(H;
   H4 H HH  H@HH L   MtA HHm  H+u
HCHP0H LII9k  H_H^  LwHHIIH)uHAP0IFM~H;Z uUHD$hH   A   H   IH   蘣HHa
  H+   HCHP0Lt$XI   H;\ ulINQ=   uYHD$hH   H   HAI uINE3H   EAHH
  H+u
HCHP0Lt$XI   s HD$HLH	
  HXE3HD$hIIIH IE ɡHH	  Im u
IEIP0Lt$XLd$HHT$hH蓟HH
  H/u	IHP0HM IHu LHt
H)uHAP0IN(IH;
 ,
  H F HH  IH HH  H.u
HFHP0HMLH}Ht
H)uHAP03I HH^  A   HI HD$HLH  H.u
HFHP0IIGD  Im u
IUIR0Et/    HD$HLH  H
ƙ HH@HIMI/IMLmuIGP0    HH=  HEE3H
 HH HGHD$HLH
  H/u
HGHP0    HH
  H@IHL( HD$HLHj
  H/u
HGHP0HMILmHt
H)uHAP0L|$hLt$PII HD$HLH	  H@IH L   MtA HH	  Im u
IEIP0   l HD$HLH^	  HEH IE HH#	  LG HH w   LIH虞HH  H/u
HGHP0Im Iu
IEIP0H.Ld$Hu
HFHP0LIII: =  H+u
HCHP0LmIIR H  HEAE     I迋HHz  HT A   HތHH;  H+u
HCHP0HI'DD  H.u
HVHR0EC  H
l 藚HH/  H@HH L   MtA HD$HLH  H+u
HCHP0HL$PI HH  H MuI9R  I}HE  IuIHLHt$HHH)uHAP0HFLvH;A uGA   H   H   H   H脝HH=  H/u
HGHP0I   H;Q ubHNQ=   uOH   H   HAI uHNE3H   EAHH  H/uHGHP0Iw   r HD$8LH  HxE3HX HHII͛HH  I/u
IGIP0L|$hLd$8'HI蚙HH  H+u
HCHP0Im u	IIP0HL$PLILd$HP   H.u
HFHP0L|$@ILl$8Lt$0HMHELd$HH Lt$0H  M   -    Lt$0 L  k =.    Lt$0s L  M S.    Z L  4 N.  p  A L   C.  W  Lt$0# L   #.  C  Lt$0 L  ߊ  .  %  Lt$0 L   .    Lt$0ɑ M   .    L|$@Lt$0 N   .    H L|$@Lt$0H u N  O .    L|$@Lt$0R N  , .  r  L|$@Lt$0/ O  	 .  O  L|$@Lt$0 P   .  ,  H L|$@Lt$0H ې P   .  4  L|$@ P   .    L|$@Lt$0 P  t .    L|$@Lt$0w P  Q .    L|$@Lt$0T P  . .  t  L|$@6 R   0/  L  L|$@ R   </  .  L|$@ R  Ԉ 6/    L|$@܏ S   e/    L|$@ S   m/    L|$@ S  z y/    L|$@ S  \ s/    L|$@d V  > /  z  L|$@F [    /  \  L|$@( [   /  >  L|$@
 [   /     L|$@ \  Ƈ  0    L|$@Ύ \   )0    L|$@ \   60    H IL|$@Lt$0H | \  V 00    L|$@I[ \  5 <0  q  L|$@= \   0  S  L|$@I \   0  2  L|$@I \  Ն 	0    L|$@Iڍ \   0    L|$@ [   /    L|$@ Y  x /    L|$@ Y  Z /    L|$@b Y  < /  x  L|$@D Y   /  Z  L|$@& Y    /  <  L|$@ Y   /    L|$@ Y  ą /     L|$@̌ W   /    L|$@ W   /    L|$@ W  j /    L|$@r W  L /  Ld$H  L|$@O V  ) /  e  L|$@1 V   /  G  L|$@ V   /  )  L|$@ T  τ /    L|$@׋ T   /    H

 H:J H	I
 L|$@ T  | /    L|$@ S  ^ _/    L|$@f S  @ Q/  |  L|$@H S  " O/  ^  H
r HI H	 L|$@ S   M/  )  L|$@ R  σ "/    L|$@׊ R   /    L|$@I Q   
/    L|$@I Q  o /    L|$@Lt$0r O  L .    L|$@Lt$0O O  ) .  o  L|$@Lt$0, O   .  L  L|$@Lt$0	 N   y.  )  Lt$0 N  ł k.    H Lt$0H  N   i.     M   -     L  g -     Ht H\	 HHR  	 I.u
IFIP0H\$PHLHMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HtH+u
HCHP0HL$hHt
H)uHAP0HMHt
H)uHAP0HL$pHt
H)uHAP0HL$xHt
H)uHAP0HM Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$`Ht
H)uHAP0HEHtH(u
HPHR0IH  H3H  A_A^A]A\_^[]v K  P -    3 LHu*HH IH~ < ^   d0    HHD$PHD$XMHH(H;
 u>H
I HE H	 H H#  _   r0  i  H 4 LHu'H H  _   t0  .  I
 HEHHu'Hr H i _  C v0  
  I.u
IFIP0Ld$0MLd$8MMH
  H
' 蒋HH
  H@HHȁ L   MtA HD$HLHY
  H.u
HFHP0IEIHB L   MtA HH	  Im u
IEIP0I HD$HLIH	  Hz MALd$8H9Fu2LvLt$8Mt$HFHIHH H)uHAP0   HFH; 
  HD$XDAHp  Lh  Lp  H@(Hx  HEH  HHH+HD$0HH  MtI.u
IFIP0Im Ld$8u
IEIP0Ll$XLuH.u
HFHP0HMIH}Ht
H)uHAP0IM(H;
$ $  H/ 2 HD$0HH  3HGzHH  H+u
HCHP0HMHH]Ht
H)uHAP0II2V     IM(H;
   Hu x1 HH[  3HyLH  H.u
HFHP0IHr HH  I.u
IFIP0H+HHuuHCP0H
 讈LH  H@IH L   M:  A8  H;=    HVDBA=      HD$XL  L  DYL  H@(H  HEH  IHL+HBA uHNE3MIHD$0HHr `  II{ 0  	   HHj  Mt	LpLd$8LuE3LlHLl$XHLd$HIE(H IE(HD ILt(THD$0HH  H+]HCHP0N HH  I.u
IFIP0H LsLd$0I9P  LkLl$0M>  H{HIE HHH)uHAP0HGLwH;8 uDHEHUA   HE HLm耊HHuo. e  z 1  Ld$H9  H;K u`HOQ=   uMHEHELmHAI uHOE3HUEAHH  Im u
IEIP0Ld$0y   n HD$HLH  HL$0E3HHIHEHLd$0H IE 辈HH|  Im u#IEIP0HH蔆HHD  H+u	IHP0HFHH L   MtA HH  H.u
HFHP0HMIH]HHt
H)uHAP0H
 ,HH  H@HH{ L   MtA HH1  H+u
HCHP0   , HH  H HHH HCHM| H HC Hs( HH  H+u
HCHP0H|$PHHIrL  H.u
HFHP0Lt$0IILd$HL;}Ll$8Ld$H}  ~ `  Iw 0    ~ d  Ilw 0  MILd$H  n~ d  IEw 0  MILd$H{  +w 0  =~ d  ILd$HMIMQ  H
` HA= H	 v 0  } e  v #1  Ld$H  } e  Mv /1  IM  } e  Iv )1    } f  xv U1  Ld$H  } f  Zv R1  Ld$H  b} f  <v G1  Ld$Hm  D} f  v D1  Ld$HO  &} f   v B1  Ld$H1  } e  u 51  Ld$H  | e  u 1  Ld$H  | e  Iu 1  IMLd$H  | e  I|u 1  IMLd$HI  {| c  Uu 0  /b| b  I9u 0  Ld$Hj  A| b  Iu 0  Ld$HI  H
c H; H	 	| b  t 0  { `  t 0     { `  t 0    { `  Mt 0  I  { `  Ivt 0  MI  }{ `  ITt 0  MI  [{ `  I2t 0  MIm  H|$PH
w~ 袀HHu { g  Is `1  M:  H@HHw L   MtA HD$HLHuz g  Is b1  M  H+u
HCHP0H MuII9  I]Hz  I}IHLH|$HHH)uHAP0HGLwH;- uwHD$PHUA   HEHH]tHHus v1  2  H+u
HCHP0H|$PIm u	IIP0H/HHHGP0H;
 uXHOQ=   uEHD$PHEH]HAI uHOE3HUEAHHmdr ~1        8 HD$0LHu=r 1  lHXE3HD$PIHIH IG 膁HHur 1  7I/IGIHIQHHq p1  x g  IMLt$0Ll$8H Hw MtIm u
IEIP0HtH/u
HGHP0HtH+u
HCHP0MtI/u
IGIP0H\$PHL$HHt
H)uHAP0MtI.u
IFIP0HtH.u
HFHP0D!x H
7 p OKH\$ UVWATAUAVAWHpH H3HD$`H= MH5 HL5 LLzH|$@IHt$HLt$PH|$XMm  Mt@Ht1Ht"HtH}  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@I HIMtHt>HtaH      H  HGo I HtHHD$@HH  H6p I HtHHD$HHHp  Ho I HtLHD$PHHG  Hn Ik HtHHD$XHH  H1 IHD$(LL$@H L|$ 5sy
*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
W L|$0IL
[ H?L<2 HHYY HMLIH
 HL$(H
 HD$ H	 *  H Ht pn u   A  H
2 H3&Hj0Lr(Hr HzMHl$ LHIHL$`H3
H$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMH8p L   MtA H|$0HHu'H Hs t   m 8*        Z HHudm :*  sHE Hh HHuH
Y H
s 4m ?*  QHl MHS ym A*   LHHm|HHuyl B*  H H5s s   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0Ds H
/ l F33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I~ HHHtHt+RHJ  Hj Iz HtHHD$@HH!  Hj IQ HtHHD$HHH   H- IHD$(LL$@HE Hl$ oy
	*     H|$HH\$@   H   H   H   H
S Hl$0HL
#W H?Lp- HH]U HHLIH
  HL$(H
 HD$ H	 *  H Hp tj q   A  H
- D3Hz HZLHIJH\$pHl$xH$   HPA_A^_LATAVH   H H3H$   HE3H; LI[ AIkIsAI{AMkEM{ELD$8HT$ HL$0Ld$(  37 HHu'H Ho p   qi (  8  HD$0HH(H;
H u0H
 H@* H	 Up   /i (    HOi  HHu'H
# H
\o p   h (  m  H@H; tsH;' tjHIp HHu'H
 H
o o   h (    H@H   HL$@Hu'o   th (    HHMLd$@H/u
HGHP0HD$@Hu>HD H9CuL;s  HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0Hm IL;tIfxVnHMH9M ~IE HEL,HAHEKIH 7n   tg (     n   [g (      HtHP HH7t% H+u
HCHP0HL$ Hl$   "n   f (  jL5o H
Hl I HHtH IyHHuf 	)   HL$ H DuEf )  m   H Hl H(  Hm   HEHP0  Hm u
HEHP0Et`    HHu,HC Lt$ Hwl 5m   f )     HL$ HT$ HH@HH)uHAP0H=p H
7k H HHtH HxHH   H Hk l   e 0)  Lt$ HtH+u
HCHP0MtI/u
IGIP0HL$(Ht
H)uHAP0HtH.u
HFHP0DIl H
b'  e w?  HCHHg L   MtA HHu'H H/k k   d 2)  3H+u
HCHP0HGHHm L   MtA HHuH Hj md 5)  
  H/u
HGHP0Hl$0HM(H;
4 u>H
 H% H	 H< Huj 3k   
d :)  yH-d  HHu'H H:j j   c <)  >HM(H;
 u4H
 H% H	] H Hi c @)  1  HAk \ LHunc B)     H IELd$(H9Cu2HkHl$(Ht$HCHHE HH H)uHAP0A   HCH;    HD$ HT$PHD$PEFAHHH+Hl$HH|$XL|$`6sLHuH Hi b S)  Z  HtHm u
HEHP0H/Ld$(u
HGHP0I/u
IGIP0Hl$ H+u
HCHP0Hm HuHEP0H
im nHH  HI IHh =i    b )  H;_    HKQ=   umHD$ LT$pHD$pEFAHL+Hl$hH|$xL$   HAI uHKE3ILHH Hg a ])  *AN_ HHuDia e)  H
v H
g mh   HH/HGHP0Ht	HhLd$(Hl$ E3AHHHE HlAFH|AFL|MYpLHu*H LH(g g   ` s)  1H.<HFHP0-H@HHd L   MtA HHu*H MHf vg    P` )  H+u
HCHP0HFHHb L   MtA* HHu'H HTf g    _ )  H.u
HFHP0H IAH9Cu+HsHt"HCHHHH H)uHAP0   HCH;    HD$0H$   H$   DGHD$8HH$   HH+H$   L$   oHHu*HF MH|e :f    _ )  H  H.x  HFHi  H;=    HKQ=      HD$0L$   H$   DGHD$8H$   HL+H$   L$   HAI uHKE3IHHZHv MHd je    D^ )  O LHu'H; Htd 2e    ^ )  }HtHpIHL$0E3HT$8HILGIHMtGHITI/mHHu'H Hd d    ] )  
I/u
IGIP0H+u
HCHP0LL$   H$   H$   H$   H$(  MtIm u
IEIP0L$   MtI.u
IVIR0IH$   H3oH   A^A\H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I> HHHtHt+RHJ  H[ I: HtHHD$@HH!  H[ I HtHHD$HHH   H IHD$(LL$@H Hl$ _y
{(     H|$HH\$@   H   H   H   H
bD Hl$0HL
G H?L HHF HHLIH
W HL$(H
 HD$ H	 (  HU Ha 4[ Fb   A  H
 t53Hz HZLHIH\$pHl$xH$   HPA_A^_HUAWHXHX3HpHxLhLH
` LpH{c H L5	_ L=jc Iy HHtH ImHLd$PHu'Hp H` ga   AZ '    HCHHe L   MtA+ HHu'H HU` a   Y '    H+u
HCHP0H LfHI9$  H^H  LvHHIIH)uHAP0IFMfH;{ uPA   H\$ HT$ L|$(IiLH   Hi H_ ``   :Y '    H;    INQ=      H\$0L|$8HAH uINE3HT$0EALHu'H H'_ _   X '  v  H+u
HCHP0HH.u
I$HP0I.Hu
IFIP0   ] LH  Hz HH^ n_   HX (        HHu'H
= H
v^ 4_   X '    HXE3IHILx HYgLHu'H H+^ ^   W '    H/
HGHP0IHeLHH H] ^   lW '  #  IEIH IEIFIE H IE IF IEHZ L   MtA8 HHuW (     H2 HH9G  H_H  HwHHHHH)uHAP0HH0dHHuV (  DH+u
HCHP0HH/u
HGHP0   f HH   lV (  Hy H\ p]   I.u
IFIP0HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D] H
 U H0fHbHH9U (  [HDU HH HGLw Hw(H H H HG0H~ H Ht HG8Lt$@Ll$HLd$PH$   Ht$xH\$pMtI/u
IWIR0HHXA_][@UAVH8HBE3H; AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH;' t[HHp HHu'H H
[ [   T F'    H@L   Mu^T H'  J  HIIMMu>Hj H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HI HHtFLHIF tH+aHCHP0RZ   S u'     Z   S s'  k+ H   H
 LI;   HHD9   }      @t3H<$IHf ug4S c'  FZ   H7 HpY HtH/u
HGHP0HtH+u
HCHP0DZ H
p R 5- 5 H/u
HGHP0L5 IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH H^V E3H\$0E3HHt$8H
Q H|$@HHu2H- H HUX Y   HE Q &    HXHH
[ HsV HAL   MtA HHu'H HW X   Q &  H  H IH9C   H{H   HsHHHHH)uHAP0HH^HHu*Q &  uH/u
HGHP0IH+u
HCHP0HHue  HHu]H H7W W   P &  {H]HHuP &  H HV W   HtD2HHHHubH HV W   bP &  H+u
HCHP0HtH/u
HGHP0DRW H
K )P *&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*H E3HU V   [O a&    | LHu'HU HU LV   &O b&  Z  IFHHHu-H
 L
 H: H	b N d&    HAH; tWH; tNHk HHuH
 H
U N i&  ~  H@L   MuaN k&  Q  H3E3H@ Mu>Hl H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA HHtNH+u
HSHR0IVLI3 uH/HGHP0lM &  5  ]M &  &  H
5 LN
 H8 H	 0M &      Ht H% HH   d H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$hILl$`H A^A\_^[4L &  3H? HxR 6S   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0DR H
	 K 
&H\$Hl$Ht$H|$ AVH HO HH
J E3HHuH> 7&  H   H
JJ HxHH5U L5S H-R  HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw` H+u
HCHP0HG?&  H HP J Q   A  H

 $H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtH9  HH [H [@SH HYHtH  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@M?  LbIMt4HtH*  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@I HIMtHt&DH*H I HD$@HH   HHH Ie HD$HHHtNHH  Hu IHD$(LL$@H Ld$ /Ly
%     H\$HH|$@   H
k H HD$0   L
l1 HD$(L H2 HD$    H	? %  OHzt}HFL
.1 H
 L HD$0HD2 H HD$(H	HD$     %  H HM N   _G A  H
 !:HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HǄ$   HE3Lt$0Lt$8>HD$0Lt$ Lt$(>HD$ ELt$XAL$  ELt$@AEHCHu'Hu HL lM   FF s$    H  LcL$  HC HD$XI$H Ld$hHD$pIL=#Q IH
YK  HHtH IXHHu'H H L L   E $    HCL   H}H HMtA HHu'H HK L   dE $  u  H+u
HCHP0HFL   HN HMtA> HHu*H/ HhK &L    E $  ME  H.u
HFHP0IL$  LcH I9$  HsH$  H  L{HIHIH)uHAP0MgI$H;{ uaH$   H$  H$   A   H$   ITHH   HX HJ OK   )D $  :  H;q    IOQ=      H$   H$  H$   HA IuIOE3EAH$   HHu'H HJ J   C $    H.u
HFHP0IL$        Q LHu'Hr HI iJ   CC $  T  HpIL$  H$  H IE E3II~RHHu'H HPI J   B $    Im uKIEIP0?H$  H,PHHu'H HH I   B $    H+u
I$HP0HGH H;1  H;j $  H HHu*H\ HH SI   -B $  MP  H/u
HGHP0IHFL   MHAHMHtlA   HALHtXHAHmKy'H HH H   A $    L)&u
HFHP0IL$     H.u
HFHP0I[KuI?LHp HG gH   AA %  R  HOHtU~A   HG- H
 H	 
HxKH HMG H   @ $  M  H;u
Lo H_H_LkHHIE H/u
HGHP0H$  H\$@L$   MLl$xMHHL$H&  HHD$0H;tTHT$0HRHL$06HD$0H@HD$0H HD$0H@Lt$8HL$0HHD$0HHL$8HCHD$8HKH|$HHWHL$H5HD$HH@HD$HH HD$HH@Lt$PH|$HHIHL$H  HHD$ H;tTHT$ HRHL$ >3HD$ H@HD$ H HD$ H@Lt$(HL$ HHD$ HHL$(HCHD$(HKLD$HMM HT$`HL$H   DBoHL$HHL$Xu2 Ht'H7 HpE .F   ? %%  H    HD$`LD$ HT$0HΎH$   HAH   E3H^H H
B "NHHu'H HD E   > ?%     E33Hf@H+u
HCHP0Hw HD nE   H> C%     L$  H$     HD$hH$  HL$pHL$XH\$@H$  HD$xHD$@H$   HH$  LHtH+u
HCHP0HtH/u
HGHP0L|$@L$  HtH.u
HFHP0MtIm u
IEIP0H$  DD s= H
 AMtI,$uID$IP0HL$XHt
H)uHAP0HtH/u
HGHP0MtI/uIGIP0LD$ MM H$  HL$ I   DBoHL$ FLD$0MM H$  HL$0   DBoHL$0AH   A_A^A]A\_^[H\$Ht$WH IHHMt-I* H~Hm=uH\$0Ht$8H _HHHHH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH   H@LE3L|$`L|$hL$   L$   L|$HL|$P3HD$HL|$8L|$@t3HD$8L$   L|$(L$   EAW$   L$   HiF HH
@ 1 HHtH HDNHHu'H- HfA $B x  : !    HGL   H= HMtA LHu'H HA A x  : !    H/u
HGHP0IFL   H/D IMtA HHu'Hu H@ lA x  F: !  =  I.u
IFIP0ML$`  LgHG I9$  LwL$`  M  H_IHHHH)uHAP0LcI$H; uYL$   L$   A   H$   HJHH   H H? @ x  z9 !  \  H;    HKQ=      L$   L$  HA IuHKE3EAH$   HHu'H% H^? @ x  8 "    I.u
IFIP0ML$`         HHu'H H? ? x  8 	"  ~  LpML$`  IE Lh E3HHGHHu'Hw H> n? x  H8 "  *  H.uFHFHP0:IHEHHu'H+ Hd> "? x  7 !    H/u
I$HP0IHCH% H;(  H;;   H^ LHu'H H= > x  7 4"  Z  H+u
HCHP0IFH   MIHIHtjA   IHHtWIH@y'HF H= => x  7 <"    M)&u
IFIP0ML$`     I.u
IFIP0M@uIAH H= = x  6 D"    HKHtR~A   H" H
 H	 
HxOAH H< w= x  Q6 "    H;u
Hs H{H{HwH?HHH+u
HCHP0HHD$`H$   IHt$hH$   I  HH$   3A  H H8xLH$   (  {HH$   3A(  HHxH$   M   E3H]= H
8 DHHu'Hr H; i< |  C5 {"  :
  E33H7H+u
HCHP0H. Hg; %< |  4 "    H   E3H< H
D8 GDHHu'H H; ; ~  4 "    E33H6H+u
HCHP0H H: ; ~  m4 "  d  H5= H$p  ? Hu'H[ H: R;   ,4 "  #  H$   H
D; @HHu'H HQ: ;   3 "    H@L   H: HMtAӼ HHu'H H9 :   3 "  b  H+u
HCHP0HFH;y    H; t~HH$   LH HHu'HS H9 J:   $3 "    H@L   Mu?H HU9 :   2 "  
  HHMMHǄ$   H.u
HFHP0Mu?H IL|$0H9CuL;c   HCJ4L;c}zJtHI  HAHHD$0H   HtHH_ HHt *HI H8 @9   2 "  I	  H+u
HCHP0H$p  LHL;
S tRH;Һ tIMIL} H H
' H	. H H8 8   1 #  	  HH$      HT$`HL$p  HHD$HH;tTHT$HHRHL$H'HL$HHIHL$HH	HD$HH@L|$PHL$HHHD$HHHL$PHCHD$PHKH|$pHWHL$p&HD$pH@HD$pH HD$pH@L|$xH|$pHHT$hHL$p  HHD$8H;tTHT$8HRHL$89$HL$8HIHL$8H	HD$8H@L|$@HL$8HHD$8HHL$@HCHD$@HKLD$pMM HT$ HL$p   DBoHL$p  HD$ LD$8HT$HH	LM   E3H#: H
d3 g?HHu'H  H96 6   / P#    E33H1H+u
HCHP0H H5 6   / T#    IL|$ L$x  L;%]   3 HHu'Hh H5 _6   9/ q#  0  ID$H;, t~H;k tuI HHu*H HR5 6   . w#  I  H@L   MuAH߾ H5 5   . y#  Iz  II$IH$   MHMu@H H9FuH;N   HFH<H;N   H|HHH$   HAHHD$ H9  H$   H$   Ht
H)uHAP0HGL   Hq6 HMtA HH   E3HH5 H8=LHt~H/u
HGHP0IIH  u5I.u
IFIP0ML$`  H$   IL|$    Hz H3 q4   K- #    HS H3 J4   $- #    H, He3 #4   , #     HtEH HHt5 'Hܼ H3 3   , #  z  H.u
HFHP0IL|$0H$   LcIu'H H2 3   \, #  S  HT$pIVsHXH+HHL$p豤L;t|H$   HL$pzHH$   ZHL$p耤 Ht'H H?2 2   + #    H$   HL$p茥HI~L$   H$   HIsDH$   U  Hu'H H1 2   b+ #  Y  HD$(Hu  HHu'HU H1 L2   &+ #    HD$(HH8H)uHAP0HD$(HX8H$   HtHl(  HMtInD$`  A HHu'HǺ H 1 1   * $       l HHu'H H0 1   ^* $  +  HXH\$(HHX   E3H$   HL$`L$   Ld$hL|$(AH|$ L$`  Ht$0  E3H$   HL$`L$   Ld$hL|$(AAL$`  Ht$0  H$   LH$   HtH)u
HAP0LIIAL   H%0 IMtA HHu'H H/ z0   T) "  !  ML$`  Hi H9G   LwL$`  MttHwIHHHH)uHAP0IHf6HHu'H H8/ /   ( #     I.u
IFIP0ML$`  4H5HHu$H H. /   |( #  LH/HGHP0H$   HT$`E3H$   L$`  AAL|$(HT$hIHtH+u
HCHP0HtH/u
HGHP0MtI.u
IFIP0HtH.u
HFHP0D. ' H
 IH\$(HL$`Ht
H)uHAP0HL$hHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0HtH+u
HCHP0H$   HtH)uHAP0H$   Ht(H$   H|WL$   L+IHLD$8MM H$`  HL$8   DBoHL$8LD$HMM H$`  HL$H   DBoHL$HHH   A_A^A]A\_^[H\$UVWAVAWH`HQw H3HD$XH5 WHt$PMHD$@Me  LzIMt3Ht"HtH[  Hr(Ht$PHB HD$HHjHl$@Hl$@I HIMtHt,HtCjH0% I HD$@HH   HHl% Ik HD$HHtwHHr  H% IE HtHHD$PHHI  H IHD$(LL$@H L|$ )y
!     Ht$PHl$@  H
K Hغ HD$0   L
, HD$(LH Hi HD$    H	 !  xHBH   H   HCHM
 3HD$0HL
 L HHHN HD$(HL$ LMH
 H H	 !  HA Hz* 8+ r  $ Ar  H
 `3!Hr(HB HjHD$HLD$HLHHL$XH3>H$   H`A_A^_^]H\$Ht$WH H5* HH
( H HHtH H6HHu'H{ H) r* p  L# D!     H H9CuHH HHuH
1 H
j) # F!  .E3HHh2HHurH H:) " H!  ) p  H/u
HGHP0HtH+u
HCHP0D) H
 " 3H\$0Ht$8H _H/u
HWHR0H+u
HSHR0HH\$0Ht$8H _@UVWATAUAVAWHl$H0  HEH$  Hs H3HE(LHUHHL$pHME3D|$PL|$8L|$@HD$8EL|$HL;L{HD$P   AAAWEWMEHE   L}D}ID$H;z tsH; tjIL|$XI LHD$`Hu'HY H' P( i  *!      H@H   HD$hHun!      MLd$`I$L|$X3HD$hD  Hu=Hܧ I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03Hh 98uIE        II4 HH  H@L   H& HMtA+ HH|  H/u
HGHP0HCL   H% HMtA HH   H+u
HCHP0II HH  H@L   H4' HMtA HH  H+u
HCHP0   : HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM=HHM1HUHtLE L+I(WEH] HUHtLEL+IS] H  IHMxHHM|HM- H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
h  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8H]HUHK@bHKXHUřLt$`L|$XLmLeHD$hyH( H
 H	r X$ j  2    33B  ;$ l      )  "$ l        	$ k         # k         # k      3   # k      3   # k  {    3   # k  `    33s H   H
P LI;   HH    }      @t3HIH+        33# i  H H-" MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
* 5#H\$pcТ I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8H{MtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HcHE   HE    E HUHtLEL+IHUHtLEL+IͼLD$8MM HUHL$8   DBoHL$8HHM(H3qH$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  Hj H3HE(LHUHHL$pHME3D|$PL|$8L|$@`HD$8EL|$HL;L{GHD$P   AAAWEWMEHE   L}D}ID$H; tsH;Y tjIL|$XI LHD$`Hu'H H2  W       H@H   HD$hHun     MLd$`I$L|$X3HD$hD  Hu=H| I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03H 98uIE        IIԞ HH  H@L   HN HMtAˠ HH|  H/u
HGHP0HCL   H HMtA HH   H+u
HCHP0II: HH  H@L   H HMtA1 HH  H+u
HCHP0   ڟ HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM=HHM!HUHtLE L+IWEH] HUHtLEL+I H  IHMHHMHM胙͟ H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
a  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8mLH HD$ LHUHL$8H]HUHK@rHKXHUeLt$`L|$XLmLeHD$hyHj  H
K H	  X      33B   Z   @   )   Z   ?      Y   -       Y  j *      w Y  Q (   3   \ Y  6 %   3   A Y   "   3   & Y        33s H   H
 LI;   HH    }      @t3HIH˞       33 W  H H MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
j H\$pcp I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8H{MtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<ta HAH;rQ H+HsA H'v4 HHE   HE    E HUHtLEL+I6HUHtLEL+ILD$8MM HUHL$8   DBoHL$8 HHM(H3H$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH  HEHX)p)xHTb H3HELL3H|$PH|$X	HD$PH|$@H|$HHD$@H|$`H|$hHE   H}@}DH|$0L;=ș uELC H( H
 H	( Hɠ H  	   m  VY  L-: H# I HHu7 HuI'Hs H j 	  D o   Y  HHDu$ Ht3 	  
 q  tI  H/u
HGHP0E,$L;=٘ u>HȽ H
9 H	 H H  
   ~  nX  Hz Iz  HHu'H H  
  t   0X  H#Du$ Htf 
  @   H  H/u
HGHP0El$L;= u>H H
k H	 H HL 
      W  Hl I  HHu'H՞ H       bW  HHMaHHMeHM̑ Ht   a   G  H/u
HGHP0IL$HEH;tIE3HUL;= u>HB H
s H	 H HT    
   V  Ht I  HHu'Hݝ H    
   jV  HF H;uA   (HDy   r
   F  H/u
HGHP0E  H
i HHu'HM H D 
  
   U  H@L   H HMtA LHu 
     0U  H+u
HCHP0IFL   H] IMtA HHu'H H  
  t   T  I.u
IFIP0E3L;=A u0H  H
 H	 N 
  (   T  H I  LHu 
     PT  3HL$0LkH
 I9E   LCLD$0M  H{I HHHH)uHAP0LD$0LoIE H; u\LD$pLt$xA   HT$pHHHu 
  Y   S  HL$0H)uHAP03HL$0  H; uZHOQ=   uGLELuHA t3HOE3EAHUHHu 
  
   0S      HHu'H
͚ H
  
  
   S  HL$0HH3HL$0Lp E3E3HHHHu~ 
  X
   R  H.uEHFH9IHHHuC 
  
   uR  I.u
IFIP0H+u
IE HP03HGH7 H;   H;ߐ    Hp LHu 
  	 
  3C  H/u
HGHP0IFH   E3IH3HtPDnIHHt?IHyl 
  F	   Q  M).   IFI   I.u
IFIP0E3 uI 
     LQ  HOHtF~A   H H
S H	2 
Hx 
     3B  H;u
Hw H_H_HsHHHH/u
HGHP0H\$`Ht$hHHMHHL$P{LEMM HT$8HM耺   DBoHM莰HHMHHL$@EyLEMM HT$8HMM   DBoHMKIL$(HT$P{IL$8HT$@}yL;= u@H H
 H	U H H
     X  3
P  H IE  HHu)Hn H
 e   ? Z  3O  He H9GuwH' (=0 f.z*u( Ht    \  33I@  H/u
HGHP0At$HL;= u@H H
 H	] H H 
    i  3O  He
 IM  HHu)Hv H m
   G k  3N  HHM HHMHMk Ht&
     m  33`?  H/u
HGHP0IL$XHEH;tIE3HUL;= u@H= H
 H	] H H     z  3N  H
	 IM  HHu)Hv H m   G |  3M  H$Àu(Ď Ht5    ~  33o>  H/u
HGHP0A\$xL;=֍ u@H H
6 H	 Hޔ H       3=M  H Iu  HHu)H H
    o   3L  HLÀu( Ht]   7   33=  H/u
HGHP0A\$yL;= u@H H
^ H	 H H?
 
      3eL  H	 I蝸  HHu)HƓ H	 
      3%L  H@L   H

 HMtA HHuu
   O   3<  H/u
HGHP0HČ Ht'H0 Hi	 '
      K  H.u
HFHP03A\$|L;=ʋ u>H H
* H	y HҒ H	 	      3K  H	 Ik  HHu'H H 	   e   J  HHM HHM$HM苅Ջ Ht'HA Hz 8	      J  H.u
HFHP03I$   HEH;tIE3HUL;= u>H H
 H	n HǑ H        (J  H I`  HHu'H H    Z   I  H9Àu2ي Ht'HE H~ <      I  H.u
HFHP03A$   L;=܉ u>H H
< H	 H H        EI  H I}  HHu'H H    w    I  H
W HHu'Hk H b   <    H  H@L   Ha HMtA& HHu      Z9  H/u
HGHP0A   HH# HHu      H  H.u
HFHP03H+u
HCHP03HnDy   g   8  H/u
HGHP0E!  L;=. u>He H
 H	݇ H6 Ho -      G  H Iϳ  HHu'H H1       YG  H! H HHu      7  H/u
HGHP0H H_ HHu}   W   F  H+u
HCHP03HDu$Ƈ Ht7      u7  H/u
HGHP0E$   L;=ن u>H8 H
9 H	 H H       BF  H Iz  HHu'H H    t   F  H HK HHui   C   6  H/u
HGHP0H{  H
 HHu(    	  WE  H+u
HCHP03H_Du$q Ht       6  H/u
HGHP0E$   L;= u>H H
 H	3 H H    ]   D  HM I%  HHu'HN H E      D  Hw H HHu      R5  H/u
HGHP0H H HHu       D  H+u
HCHP0HGL   H HMtA HHu}   W #  4  H/u
HGHP0H6΄ Ht?    &  nC  H+u
HCHP0A$   L;= u>H H
A H	 H H"     3  JC  H I肯  HHu'H H     | 5  C  H HS HHuq   K 7  B  H+u
HCHP0H H HHu0   
 :  n3  H/u
HGHP0Hiu$| Ht     =  B  H+u
HCHP0A$   L;= u>Hf H
 H	> H H     h J  A  HX I0  HHu'HY H P    * L  A  H H HHu     N  NA  H+u
HCHP0H H HHu    Q  2  H/u
HGHP0Hu$* Ht   u T  @  H+u
HCHP0A$   L;== u>H< H
 H	 HE H~ <    a  @  H Iެ  HHu'H H@     c  h@  H0 H~ HHu    e  ?  H+u
HCHP0H Hn~ HHu   f h  0  H/u
HGHP0H5@@u$Ӏ HtD    k  s?  H+u
HCHP0A$   L;= u>H
 H
F H	 H H'      x  O?  H I臫  HHu'H H      z  ?  H HX} HHuv    P |  >  H+u
HCHP0H  H} HHu5       s/  H/u
HGHP0Hnu$ Ht       !>  H+u
HCHP0A$   L;=~ u>H H
} H	C~ H H  !  m   =  H] I5  HHu'H^ H U !  /   =  H H| HHu$ !     S=  H+u
HCHP0Hv H{ HHu !     !.  H/u
HGHP0Hu$/~ Ht !  z   <  H+u
HCHP0A$   L;=B} u>H H
| H	| HJ H A "     <  H I  HHu'H HE  "     m<  H5 Hz HHu "     <  H+u
HCHP0H Hsz HHu "  k   ,  H/u
HGHP0H:@@u$| HtI "  #   x;  H+u
HCHP0A$   L;={ u>H H
K{ H	{ H H,  #     T;  H I茧  HHu'H H  #     ;  H H]y HHu{ #  U   :  H+u
HCHP0HM Hy HHu: #     x+  H/u
HGHP0H,z H9CusHz (f.z&u$m{ Ht #     
:  H+u
HCHP0A$   L;=~z u>HE H
y H	-z H H } $  W   9  HG I  HHu'HH H ? $     9  Hq Hw HHu $     =9  H+u
HCHP0H Hw HHu $     *  H/u
HGHP0Hx H9CusHy (f.z&u$ z Htq $  K   8  H+u
HCHP0A$   L;=y u>H  H
qx H	x H HR  %     z8  H I貤  HHu'H H  %     <8  H Hv HHu %  {   7  H+u
HCHP0Hs HBv HHu` %  :   (  H/u
HGHP0HRw H9CusHx (f.z&u$x Ht %     37  H+u
HCHP0A$   L;=w u>H H
w H	Sw H~ H  &  }   
7  Hm IE  HHu'Hn~ H e &  ?   6  H Hu HHu4 &     c6  H+u
HCHP0H Ht HHu &   	  1'  H/u
HGHP0Hlu$?w Ht &     5  H+u
HCHP0A$   L;=Rv u>H H
u H	v HZ} H Q '  +   5  H I  HHu'H} HU  '     }5  HE Hs HHu '     5  H+u
HCHP0H Hs HHu '  {    %  H/u
HGHP0Hu$u Ht^ '  8 #  4  H+u
HCHP0A$   L;= u u>Hg H
`t H	t H| HA  (   0  i4  H I衠  HHu'H{ H  (   2  +4  H Hrr HHu (  j 4  3  H+u
HCHP0H H1r HHuO (  ) 7  $  H/u
HGHP0Hu$t Ht (   :  ;3  H+u
HCHP0A$   L;=s u>H= H
s H	]s Hz H  )   G  3  Hw IO  HHu'Hxz H o )  I I  2  H H q HHu> )   K  m2  H+u
HCHP0H` Hp HHu )   N  ;#  H/u
HGHP0Hq H9CusHr (f.z&u$0s Ht )  { Q  1  H+u
HCHP0A$   L;=Ar u>H H
q H	q HIy H @ *   ^  1  H
 I  HHu'Hy HD  *   `  l1  H4 Ho HHu *   b   1  H+u
HCHP0H Hro HHu *  j e  !  H/u
HGHP0HCL   H HMtADq HHu: *   h  i0  H+u
HCHP03HDq Ht *   k  7!  H/u
HGHP0E$   L;=p u>Hz H
o H	Jp Hw H  +  t x  0  Hd I<  HHu'Hew H \ +  6 z  /  H H
n HHu+ +   |  i   H/u
HGHP0H Hm HHu +     /  H+u
HCHP03Hn H9GuwHo (f.z&u$p Ht +  f     H/u
HGHP0A$  L;=,o u>H3 H
n H	n H4v Hm + ,     .  H I͚  HHu'Hu H/  ,     W.  H Hl HHu ,       H/u
HGHP0H H]l HHu{ ,  U   -  H+u
HCHP03Hkm H9GuwH-n (f.z&u$n Ht ,     [  H/u
HGHP0A$  L;=m u>H H
m H	lm Ht H  -     &-  H I^  HHu'Ht H ~ -  X   ,  H H/k HHuM -  '     H/u
HGHP0HW Hj HHu -     ;,  H+u
HCHP0H
f QHHu -     
  H@L   H HMtAl HHu -  c     H+u
HCHP0A   HHk HHuF -        H/u
HGHP0H.u
HFHP03Hݘy -     ,+  H+u
HCHP0g  L;=k u>H H
j H	Nk Hr H  .  x   +  Hh I@  HHu'Hir H ` .  :   *  H Hi HHu/ .  	   ^*  H+u
HCHP0H! Hh HHu'Hq H"  .     J*  H.u
HFHP03Hu$*k Ht .  u   )  H+u
HCHP0A$  :*  L;=8j u>H H
i H	i H@q Hy 7 /     )  H Iٕ  HHu'Hq H;  /     c)  H+ Hg HHu /     (  H+u
HCHP0H Hig HHu'Hp H y /  S   (  H.u
HFHP0H
 HHu< /     k(  H@L   Hc HMtA i HHu /     %(  H.u
HFHP0A   HHg HHu /       H+u
HCHP03H/u
HGHP0HJy'Heo H \ /  6   '  H.u
HFHP03'  L;=g u>H H
\g H	g Ho H=  0     e'  H I蝓  HHu'Hn H  0     ''  H Hne HHu'Hn H ~ 0  X 	  &  H.u
HFHP0H` He HHu= 0     {  H/u
HGHP0H/f H9FuvHf (f.z4u2pg Ht'Hm H  0     =&  H.u
HFHP0A$   p&  L;=nf u>H= H
e H	f Hvm H m 1  G 0  %  HO I  HHu'H8m Hq / 1  	 2  %  H
 HHu'Hl H6  1   4  ^%  H@L   HK HMtAe HHu 1   6    H/u
HGHP0A   HHd HHuk 1  E 9  $  H.u
HFHP03H+u
HCHP03H Dy 1   <  ]  H/u
HGHP0E  L;=d u>H H
 d H	od Hk H  2   I  )$  H Ia  HHu'Hk H  2  [ K  #  H H2b HHuP 2  * M    H/u
HGHP0H Ha HHu 2   P  >#  H+u
HCHP03HFDu$Xd Ht 2   S    H/u
HGHP0E$   L;=kc u>H H
b H	c Hsj H j 3  D `  "  H4 I  HHu'H5j Hn , 3   b  "  Hf H` HHu 3   d  9  H/u
HGHP0H
 H` HHu 3   g  !  H+u
HCHP03HDu$c Htt 3  N j    H/u
HGHP0E$   L;=b u>H] H
va H	a Hi HW  4   w  !  H I跍  HHu'Hh H  4   y  A!  H H_ HHu 4   {    H/u
HGHP0H HG_ HHue 4  ? ~     H+u
HCHP0HGL   H HMtAa HHu 4     M  H/u
HGHP0H`a Ht 4         H+u
HCHP0A$   L;=s` u>H H
_ H	"` H{g H r 5  L     H< I  HHu'H=g Hv 4 5       Hn H] HHu 5     2  H+u
HCHP0Hu H] HHu 5        H/u
HGHP0Hk@@u$	` Htz 5  T     H+u
HCHP0A$   L;=_ u>H H
|^ H	^ H$f H]  6       H I轊  HHu'He H  6     G  H H\ HHu 6       H+u
HCHP0H HM\ HHuk 6  E     H/u
HGHP0H]] H9CusH^ (f.z&u$^ Ht 6     >  H+u
HCHP0A$   L;=] u>Hn H
] H	^] Hd H  7       Hx IP  HHu'Hyd H p 7  J     H H![ HHu? 7     n  H+u
HCHP0H HZ HHu 7     <
  H/u
HGHP0H[ H9CusH\ (f.z&u$1] Ht 7  |     H+u
HCHP0A$   L;=B\ u>H) H
[ H	[ HJc H A 8       H I  HHu'Hc HE  8     m  H= HY HHu 8       H+u
HCHP0H4 HsY HHu 8  k     H/u
HGHP0HZ H9CusHE[ (f.z&u$[ Ht5 8     d  H+u
HCHP0A$   L;=Z u>H H
5Z H	Z Ha H  9     >  H Iv  HHu'Ha H  9  p      H HGX HHue 9  ?     H+u
HCHP0H HX HHu$ 9     b
  H/u
HGHP0HY H9CusHY (f.z&u$WZ Ht 9       H+u
HCHP0A$   L;=hY u>H H
X H	Y Hp` H g :  A     H1 I	  HHu'H2` Hk ) :       Hc HV HHu :     '  H+u
HCHP0H HV HHu :       H/u
HGHP0HW H9CusHkX (f.z&u$X Ht[ :  5     H+u
HCHP0A$   L;=W u>HZ H
[W H	W H_ H<  ;     d  H I蜃  HHu'H^ H  ;     &  H HmU HHu ;  e     H+u
HCHP0H H,U HHuJ ;  $ "    H/u
HGHP0H<V H9CusHV (f.z&u$}W Ht ;   %    H+u
HCHP0A$   L;=V u>H H
U H	=V H] H  <  g 2    HW I/  HHu'HX] H O <  ) 4    H H T HHu <   6  M  H+u
HCHP0H HS HHu <   9    H/u
HGHP0Hu$)V Ht <  t <    H+u
HCHP0A$   9  L;=7U u>H H
T H	T H?\ Hx 6 =   S    H I؀  HHu'H\ H:  =   U  b  H
 MHHu =   W    H@L   H* HMtAT HHu =  _ Y    H/u
HGHP0A   HHS HHuB =   \  q  H+u
HCHP03H.u
HFHP03H׀Dy =   _  4  H/u
HGHP0E  L;=S u>Hn H
R H	FS HZ H  >  p l     H` I8  HHu'HaZ H X >  2 n    H H	Q HHu' >   p  e  H/u
HGHP0H HP HHu'HY H  >   s  B  H.u
HFHP03HQ H9GuwHR (f.z&u$	S Htz >  T v    H/u
HGHP0A$   L;=R u>H H
zQ H	Q H"Y H[  ?       H I}  HHu'HX H  ?     E  H HO HHu ?       H/u
HGHP0H\ HKO HHu'HdX H [ ?  5     H.u
HFHP03HKP H9GuwH
Q (f.z&u$Q Ht ?     ;  H/u
HGHP0A$     L;=P u>H H
O H	GP HW H  @  q     Hy I9|  HHu'HbW H Y @  3     H
 HHu   mH@L   HX HMtAO HHu   4H.u
HFHP0A   HHO HHuG    @  E3HV H H  H/  HGHP0  H/u
HGHP0H+u
HCHP0H(|؅y'HCV H| : @       H.u
HFHP03  L;=N u>H) H
:N H	N HU H  A     C  H I{z  HHu'HU H  A  u     H HLL HHu'HeU H \ A  6   
  H.u
HFHP0Hf HK HHu A     J
  H+u
HCHP0HFL   HZ HMtAM HHu'HT H  A     !
  H.u
HFHP03HΗN Htw A  Q     H+u
HCHP0A$   L;=M u>H~ H
yL H	L H!T HZ  B       H Ix  HHu'HS H  B     D  H HJ HHu B       H+u
HCHP0H HJJ HHu'HcS H Z B  4     H.u
HFHP03H葛u$L Ht B     D  H+u
HCHP0A$   L;=K u>HV} H
K H	fK HR H  C        H IXw  HHu'HR H x C  R   
  H H)I HHuG C  !   v
  H+u
HCHP0H HH HHu'HR H:  C     b
  H.u
HFHP03H/u$BK Ht C     	  H+u
HCHP0A$   L;=UJ u>H| H
I H	J H]Q H T D  .   	  H Iu  HHu'HQ HX  D     	  HX HG HHu D   	  	  H+u
HCHP0H HG HHu'HP H  D  p    	  H.u
HFHP03H͘u$I HtQ D  +     H+u
HCHP0A$   L;=H u>Hz H
SH H	H HO H4  E  ̿   \  H It  HHu'HO H  E       H HeF HHu E  ]      H+u
HCHP0H H$F HHu'H=O Hv 4 E   #    H.u
HFHP03Hku$~H Ht E  ɾ &    H+u
HCHP0A$   L;=G u>Hy H
F H	@G HN H  F  j 3    HZ I2s  HHu'H[N H R F  , 5    H HE HHu! F   7  P  H+u
HCHP0H HD HHu'HM H  F   :  <  H.u
HFHP03H	u$G Ht F  g =    H+u
HCHP0A$   L;=/F u>Hnx H
E H	E H7M Hp . G   J    H Iq  HHu'HL H2  G  ʼ L  Z  H2 HC HHu G   N    H+u
HCHP0H H`C HHu'HyL H p G  J Q    H.u
HFHP03H`D H9CusH"E (f.z&u$E Ht G   T  A  H+u
HCHP0A$   L;=D u>Hw H
D H	aD HK H  H   a    H{ ISp  HHu'H|K H s H  M c    H H$B HHuB H   e  q  H+u
HCHP0H HA HHu'HJ H5  H  ͺ h  ]  H.u
HFHP03Hp@@u$8D Ht H   k    H+u
HCHP0A$   L;=KC u>Hu H
B H	B HSJ H J I  $ x    H In  HHu'HJ HN  I   z  v  HN H@ HHu I   |  
  H+u
HCHP0H H|@ HHu'HI Hο  I  f     H.u
HFHP03H|A H9CusH>B (f.z&u$B Ht. I     ]  H+u
HCHP0A$   L;=A u>Ht H
.A H	}A HH H Ϳ J     7  H Iom  HHu'HH HѾ  J  i      Hѻ H@? HHuB      H+u
HCHP0H H	? HHu'H"H H[  J        H.u
HFHP03HP   _A H      ¾ J  E3HG H HtH+u
HCHP0MtI.u
IFIP0HL$0Ht
H)uHAP0HtH.u
HFHP0H
$s H+u
HCHP0A$   HL$`Ht
H)uHAP0HL$hHtH)uHAP0HM-:LD$@MM HT$8HL$@"h   DBoHL$@_LD$PMM HT$8HL$Ph   DBoHL$P^HMH3RL$  I[PA(sA({IA_A^A]A\_^]HL$USVWATAUAVAWHl$HX  3LHt$(Ht$pDHt$0DHt$xD)= Hu'HF H>     ֵ   h>  HD$(< Hu'HE H ż       1>  A$H؉   HD$ ? HHu'HE H ~    X (  =     ,> HHuR    , *  ;  HxE3H
=< H}HHu     /  <  H+u
HCHP0H\$(LHm H; yֻ     2  :  H/u
HGHP0AL$   > HHu,HD H\$ Hú     [ <  <  H# LHw; yQ    + >  :  H/u
HGHP0IL$5HHu,HD H\$ HE     ݳ H  o<  He LH: yӺ     J  9  H/u
HGHP0AD$HO< HHu,HC H\$ HĹ     \ T  ;  H LHx: yR    , V  9  H/u
HGHP0A8t$PtHM= H H=C= H:; H H=0; Hu,HB H\$ H(      `  R;  H LH9 y     b  8  H/u
HGHP0A8t$xtH< H H=< H: H H=: Hu,HXB H\$ H J    $ l  :  H LH@9 y     n  7  H/u
HGHP0A8t$yt~IL$X2HHu,HA H\$ H Ÿ       1:  H LH8 y    o   `7  H/u
HGHP0A8$      I$   ;2HHu,HDA H\$ Hx 6       9  H` LH,8 y       6  H/u
HGHP0H
 KHHu,H@ H\$ H        "9  AL$|   9 LHu'H
@ H
 v    P   .8  Hp8 LcI9$  LkM  H{HIE HHH)uHAP0HGLgH;:    A   LmHUL}H8HHu       7  Im u
IEIP0LI/u
IGIP0H+u
I$HP0H
l LH|$pHHA  H\$ t    N   7  H;: u]HOQ=   uJLmL}HAH uHOE3HUEAHHA       6     7 LHu'H
> H
 Ե       6  LhE3Lx IHLLHHu    q   A6  I.IFIIH跻HHQ    +   5  H@HHT L   MtA7 HHu       3  H/u
HGHP0A   HI6 HHuȴ       l5  H+u
HCHP0Hqc؅y    k   V3  H/u
HGHP0l  IFIHt L   MtA=6 HHuH\$ .       ^5  Ld$(LH I4 y    Ӭ   2  H/u
HGHP0L   A   L$85 HHuH\$        4  H LI3 y{    U   @2  H/u
HGHP0A   L$@5 HHuH\$ 4       d4  Hv LI*3 y    ޫ   1  H/u
HGHP0A   L$H5 HHuH\$      (  3  H LI2 y    g *  R1  H/u
HGHP0A   L$P4 HHuH\$ F      4  v3  Hh LI<2 y     6  0  H/u
HGHP0L3 IH6 1 yH\$ ͱ     @  2  A8   tH4 H H=4 H2 H H=2 H\$ Hu}    W I  2  H׬ LHs1 yM    L$ K  L0  H/u
HGHP0A   2 HHu     U  72  H LH0 yװ    L W  L/  H/u
HGHP0A   K2 HHu    k a  1  H[ LH0 ya    L8 c  L+/  H/u
HGHP0A   1 HHu     m  K1  H LH0 y    L¨ o  L.  H/u
HGHP0A   L$X2 HHu    } y  0  H LH/ ys    LJ {  L=.  H/u
HGHP0A   L$`M2 HHu+       [0  HU LH!/ y    Lҧ   L-  H/u
HGHP0A   L$h1 HHu       /  Hݩ LH. y    LZ   LM-  H/u
HGHP0A   / HHu=       m/  Ho LH3. y
    L   L,  H/u
HGHP0A  / HHuǭ       .  H LH- y    Ln   La,  H/u
HGHP0A  / HHuQ    +   .  H LHG- y!    L   L+  H/u
HGHP0H
u `HHuH\$ ٬       	.  A   M. LLHu       O-  H- LcI9$  L{M  H{HIHHH)uHAP0HGLgH; 0    A   L}HULuHhHHu       ,  I/u
IGIP0LI.u
IFIP0H+u
I$HP0HGHHީ L   M   A  H;/ u]HOQ=   uJL}LuHAH uHOE3HUEAHHZW    1   ,     - LHu+       +  LxE3Lp IHLLPHHu    ȣ   +  Im u
IEIP0LIHHH       O+  , HHu~    X   F)  H/u
HGHP0HX LHL$(b* y<       *  HLH\$0HHu
HCHP0H
 tHHu*H2 LH#        *  H@HH$ L   MtA+ HHu    u   B*  H+u
HCHP0A   HI* HHuX    2    (  H/u
HGHP0HXy!     	  )  H+u
HCHP0   L   A$  M+ HHu*H1 LH        )  H LHL$ ( y    g   4)  H+  HCHP0  H
ި ɭHHu*HB1 LHx 6     *  )  H@HHa L   MtA) HHu    ʠ ,  (  H+u
HCHP0A   HI( HHu     /  u&  H/u
HGHP0HVVyv    P 1  (  H+u
HCHP0tL   A$   ( HHu*H%0 LH[      <  '  H LHL$ 
' o     >  '  H
M 8HHu*H/ LH      R  r'  H@HH L   MtAi( HHu_    9 T  '  H+u
HCHP0A   HIf' HHu     W  $  H/u
HGHP0HTy     Y  &  H+u
HCHP0L   H
: %HHu*H. LHԤ     l q  _&  H@HH L   MtAV' HHuL    & s  %  H+u
HCHP0A   HIS& HHu	     v  #  H/u
HGHP0HSyҤ     x  y%  H+u
HCHP0L^	  H
! HHu'H- H |    V   I%  A$   M& LHuJ    $   #  HD% LgI9$  LwM  H_HIHHH)uHAP0HCLcH;'    A   LuHULmH
HHu       "  I.u
IFIP0LIm u
IEIP0H/u
I$HP0HCHH L   M  A  H;' u]HKQ=   uJLu LmHAH uHKE3HU EAHHY    ՛   !     $ LHuϢ       !  LpE3Lh IHLLHHu    l   ]!  I/u
IGIP0LIH谨HHJ    $   !  -$ HHu#    L   "  H+u
HCHP0H
z LH|$x]HHu*H* LH ʡ       "  H@HH L   MtA# HHu    L[   L   H/u
HGHP0A   HI" HHu>    L   !  H+u
HCHP0HO؅y    Lۙ     H/u
HGHP0  H\$ L^ HH   y*H) LH     y   q!  Ld$(H I<N  HHu*He) LH Y    3   +!  H H! HHu(    L     H/u
HGHP0H LI  y    L      H+u
HCHP0Lv  H
4 HHu*H( LHΞ     f   Y   H@HH L   MtAP! HHuF    L     H+u
HCHP0A   HIJ  HHu     Lח     H/u
HGHP0HMyƞ    L   m  H+u
HCHP0#  H\$ Lx HH  y*Hm' LH a    ;   3  Ld$(HF IK  HHu*H'' LH]          H= H| HHu    L     H+u
HCHP0H LI y    L~   o  H/HGHP0L4  H
 ݢHHu*HV& LH J    $ *    H@HH՘ L   MtA HHu    Lە ,    H/u
HGHP0A   HI HHu    L /  e  H+u
HCHP0HdK؅y    L[ 1  L  H/u
HGHP0L
  H\$ LC HHy S y'H(% Ha      <    Ld$(H II  HHu'H$ H ܛ     E    HN H= HHu     G  v  H/u
HGHP0H LI yk    E J    H+uHCHP0Ld$(H\$ IHV LE   H$ HO 
     g    H
ǘ bHHuH\$ ۚ     z    H@HH L   MtA HHu    o |  9  H+u
HCHP0A   HI HHuR    ,     H/u
HGHP0HHy         H+u
HCHP0M  IFIH L   MtA HHuH\$          Ld$(LH I y    ]   '  H+u
HCHP0L   A   L$h HHuH\$ 5       e  H LI+ y    ߑ     H+u
HCHP0A   L$`
 HHuH\$          H LI y    h   2  H+u
HCHP0A   L$X HHuH\$ G    !   w  H LI= y         H+u
HCHP0A   L$P HHuH\$ З          HR LI y    z   D  H+u
HCHP0A   L$H HHuH\$ Y    3     H; LIO y)         H+u
HCHP0A    HHuH\$          H LI y       X  H+u
HCHP0A8   tH H H H H H HuH\$ T    .     H LIJ y$         H+u
HCHP0A   L$@, HHuH\$ ݕ       
  Hw LI y       Q  H+u
HCHP0A   ' HHuH\$ h    B     H LI^ y8         H+u
HCHP0H
 }HHuH\$     Ѝ   &  A   M LHuŔ         H LgLI9$  LoM  H_HIE HHH)uHAP0HCLcH;<    A   LmHUL}H脝HHu2         Im u
IEIP0LI/u
IGIP0H/u
I$HP0HCHH H\$0L   M  A  H; u]HKQ=   uJLm L}(HAH uHKE3HU EAHHTm    G #  5      LHuA     *    LhE3Lx IHLLfHHu    ދ 0    I.IFIIH$HH          HHuH\$     l @    Ld$(LH I y]    7 B    H+u
HCHP0H\$ I$IMtI,$uID$IP0HtH+u
HCHP0HL$pHt
H)uHAP0HL$0Ht
H)uHAP0HD$xHtH(u
HPHR0HHX  A_A^A]A\_^[]H
p HHuH\$     ^ V    H@HHߒ L   MtAH HHu>     X    H+u
HCHP0A   HIE HHu    Չ [    H/u
HGHP0H?yĐ     ]  h  H+u
HCHP0  IFIH L   MtAp HHuH\$ a    ; h    H|$(LH; HR y,     j    H+u
HCHP0L   A$   L$8, HHuH\$ ݏ     t  
  H' LH y     v  Q  H+u
HCHP0A$   M HHuH\$ f    @     H LH\ y6         H+u
HCHP0A8$   tH. H H$ H H H HuH\$ Վ         HW LH y       I  H+u
HCHP0H
7 HHuH\$ c    =     A$   M{ LLHu.         H( LgI9$  LM  H_HIHHH)uHAP0HCLcH;    A   L}0HU0Lu8HHHu    y   j  I/u
IGIP0LI.u
IFIP0H/u
I$HP0HCLHg HH\$0L   M   A  H;` u]HKQ=   uJL}@LuHHAH uHKE3HU@EAHHR،             LHu       w  LxE3Lp IHLLєHHuo    I   :  Im u
IEIP0LIH茒HH&        
  	 HHu*H LH0     Ȅ     Ld$(LH  I y       `  H+u
HCHP0H
K HHu*Hw LH k    E   8  H@HHV L   MtA/
 HHu%         H+u
HCHP0A   HI, HHu       	  H/u
HGHP0H9y       R  H+u
HCHP0FH
5 HHu*Ha LH U    /   "  H@HH L   MtA HHu       
  H+u
HCHP0A   HI HHu̉         H/u
HGHP0Hu8y    o   <
  H+u
HCHP0{  H       HHu*HB LHx 6       
  HX LI,	 y       	  H+u
HCHP0   
 HHu*H LH        	  H LI y    `   -	  H+u
HCHP0   
 HHu*HB LHx 6       	  H LI, y          H+u
HCHP0   	 HHu*H LH      *    H( LI y    ` ,  -  H+u
HCHP0   	 HHu*HB LHx 6     6    Hh LI, y     8    H+u
HCHP0    HHu*H LH      B    H؊ LI y    ` D  -  H+u
HCHP0    HHu*HB LHx 6     N    H LI,     ~ P    H
 WHHu*H LH ą    ~ d    H@HH L   MtA HHu~    X~ f  %  H+u
HCHP0A   HI HHu;    ~ i    H/u
HGHP0H3y    } k    H+u
HCHP0H      p HHu*H
 LH     } v  r  Hǁ LI yu    O} x    H+u
HCHP0    HHu*H1
 LHg %    |     Hg LI y    |     H+u
HCHP0   p HHu*H LH     |   r  HO LI yu    O|     H+u
HCHP0    HHu*H1 LHg %    {     H LI y    {     H+u
HCHP0   p HHu*H LH     {   r  Hׅ LI yu    O{     H+u
HCHP0    HHu*H1 LHg %    z     HG LI     z     H
 FHHuH\$     z     H@HH" L   MtA HHuy    Sz     H+u
HCHP0A   HI HHuO6    z   LLH\$ H
 HK H  H/  HGHP0  H/u
HGHP0H/yɀ    y   m  H+u
HCHP0Ld$(_L IH   yH\$ s    My     L IH e  yH\$ :    y   j  L   A$    HHuH\$     x   -  H|$ LHσ H  y    x   oH+u
HCHP0A$   D HHu    Hax      HI LH}  yYW    1x   LLH8 Hq~ HtH+u
HCHP0H\$ MtjI/udIGIP0XH+u
HCHP0Ld$(HH	| LI  ~    w   H LH} MtIm u
IEIP0MtI.u
IFIP0D~~ H
W* Uw QLd$(0HUATAUAVAWHhHP  HEHXHpHx H H3HEHL3HL$XHL$PHL$`HL$hHE@   HM8M(HE    HMMDDDE3Hz H
w HHu'H H| } y   yv o  d
  HHL$XL`hA$AAD$AIL$HHu'HS H| J} }   $v   
  LHL;
  t;MIL" H,( H
U  H	\  } }   u   T	  HKH)uHAP0HsIL$ $HHu'H H{ | ~   u   y	  LHL;
  t;MIL" H' H
  H	  l| ~   Fu     HK H)uHAP0Hs AD$8C(3  HHu'H HV{ |    t     H|$PI\$@I;\$H7  IE3ff     HCH+HHHD$xHLT$@D$8  DT$0HD$(LT$ A   LD$xAQHt HH  H   HHHD$`Ht
H)uHAP0LLGHG HE3AL;AL9G tHHGJ4I@HGHI`  tE3HI;\$H)NH H1z z    s 	    H H
z z    s     31  HHu'H Hy z    ks   V  I\$XI;\$`   fHEH;tIE3HHM3H IE3HUHM(2HE   LmDmIE3HU(HM2H  HD$(HM3(  HHteHVH9V ~H HNHHJHNHH  uH/u
HGHP0I;\$`A2y    r '    y    fr %    Ht$hH
z ~HHu'HU Hx Ly    &r 4    H@L   HK{ HMtA  LHu'H H:x x    q 6  h  H/u
HGHP0     HHu'H Hw x    q 9  3  HHpHD$PH HG E3HH
z ʀLHu'H
c H
w Zx    4q A    H/u
HGHP03IvH>  H9  I~H  I^HHILH)uHAP0HsHH;  u`H}L}A   HUHHHu'H  Hv w    p V  !  H/u
HGHP03?  H;  uhHKQ=   uUH}L}HA t3HKE3EAHUHHuH2  Hkv )w    p _         LHu'H
  H
1v v    o f  _  Hx3Lx E3E3IHHHu'H  Hu v    o l  *  Im uSIEIGII|HHu'Hd  Hu [v    5o O    I/u
IGIP0I.u	HIP0E3L|$XIO0H)uHAP0I_0I$  SHHu-H  H%u u    n   E3E3M  IO@H)uHAP0I_@A$  AGHI$  HMXH
  HL$(H#  HHu-Hm  Ht du    >n   E3E3  IOPH)uHAP0I_PI$  HHu-H  HOt 
u    m   E3E3w  IOXH)uHAP0I_X3[  HHu-H  Hs t    m   E3E3%  I$  I;$    HEH;tIE3HHM$-H IE3HUHM(-HE   HE    E IE3HU(HM,H  HD$(HMO"  LHt^HNH9N ~H HFL4HAHFIH,  u#I.u
IFIP0I;$  :   l   
l   E3E3s    H  Hr H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0MtI/u
IGIP0MtIm u
IEIP0D%s l H
h SF3L|$XIO`H)uHAP0Iw`IIMtI/u
IGIP0HL$PHt
H)uHAP0HL$`Ht
H)uHAP0HL$hHtH)uHAP0LE IrIHU8HE    HE    E HM(HHMHH3L$P  I[8Is@I{HIA_A^A]A\]@SH H  HH HI`H)uHAP0H  HC`3H [@SH H  HH HI`H)uHAP0H  HC`3H [H\$WH LJHL;
p  HtrH;L  tiH
  L MIH H	  HI  Hp @q [   j     H
 A[   _DH\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH HS  HH HIXH)uHAP0H5  HCX3H [@SH H  HH HIXH)uHAP0H  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H  HH HIPH)uHAP0H  HCP3H [@SH H  HH HIPH)uHAP0H  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0H  H)t$ H9BurH  (f.5j zTuRP  HtGH  Hl m X   f     H
 AX   @(t$ H0[sH3(t$ H0[KH(AH  Hu;H-  Hfl $m X   e     H
~ AX   C@3H(H(AH  Hu;H  Hl l X   e     H
 AX   ?3H(@SH HS  HH HI@H)uHAP0H5  HC@3H [@SH H  HH HI@H)uHAP0H  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H  HH HI8H)uHAP0H  HC83H [@SH H  HH HI8H)uHAP0H  HC83H [H\$WH LJHL;
   HtrH;|  tiH
  L MIH H	  Hy  Hi pj V   Jc A  A  H
 AV   =H\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H  HH HI0H)uHAP0He  HC03H [@SH HC  HH HI0H)uHAP0H%  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H  H)t$ H9BurHE  (f.5ڊ zTuR  HtGH,  Heg #h T   `     H
= AT   B;(t$ H0[s(3(t$ H0[KH(A(Y  Hu;H  Hf g T   n` z  z  H
 AT   :3H(H(A(  Hu;H=  Hvf 4g T   ` z  z  H
 AT   S:3H(@SH H  HH HI H)uHAP0H  HC 3H [@SH H  HH HI H)uHAP0He  HC 3H [H\$WH LJHL;
P  HtrH;,  tiH
  L`
 MIH H	  H)  Hbe  f S   ^ -  -  H
 AS   ?9H\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH H3  HH HIH)uHAP0H  HC3H [@SH H  HH HIH)uHAP0H  HC3H [H\$WH LJHL;
  HtrH;  tiH
  L@ MIH H	  H  Hc d R   j] 
  
  H
 AR   7H\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;  AE3H;  A3H;  DEuHR  DEEtR  HtGHr  Hb ic Q   C\ 
  
  H
#	 AQ   6H\$0H _È_3H\$0H _;H(y tH'  H H  H  H H
  Hu;H  Hb b Q   [ \
  \
  H
 AQ   53H({H\$WH HH3؃uO  HtDHJ  Ha Ab P   [ 3
  3
  DCQH
 b5H\$0H _É_3H\$0H _kH(IL$0  Hu;H  H` a P   Z 
  
  H
 AP   43H(H(IL$0  Hu;H[  H` Ra P   ,Z 
  
  H
 AP   q43H(H\$Hl$Ht$WH H^ HH
+  E333?iHHu'H  H` ` q   Y   O  HCHH] L   MtA  HHumY      H  H9C  H{H  HsHHHHH)uHAP0HHfHHuH
'  H
`_ Y   QH/u
HGHP03H+u
HCHP0     HH   X   H  H_ _ q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HWHR0Dj_ H
 AX 23cHLeHH6X   XH
zX HHHHh Hp(H
  HH
  HH0H
  HH
  HH8H\$0Hl$8Ht$@H _@UAVH8HBE3H;  AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH;  t[HH  HHu'HQ  H] H^ m   "W ;    H@L   Mu^W =  J  HIIMMu>H  H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HIe  HHtFLHI  tH+aHCHP0RV] n   0V j     =] n   V h  k  H   H
  LI;   HHD9   }      @t3H&IH  ugU X  \ m   H  H[ HtH/u
HGHP0HtH+u
HCHP0D\ H
  ^U /   H/u
HGHP0L5&  IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH HX E3H\$0E3HHt$8H
T H|$@HHu2H-{  H  HZ [ f   HE iT     HXHH
^ HX HAL   MtAH  HHu'H9  HrZ 0[ h   
T   H  H*  IH9C   H{H   HsHHHHH)uHAP0HH(aHHuS   uH/u
HGHP0IH+u
HCHP0HHue  HHu]H~  HY uZ i   OS   {Ha`HHu3S   H@  HyY 7Z h   HtD2HHHubH  HJY Z i   R   H+u
HCHP0HtH/u
HGHP0DY H
  R  -&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*H
  E3HCX Y i   Q V      LHu'H  HX X i   Q W  Z  IFHHHu-H
q  L:  H+= H	  lQ Y    HAH;`  tWH;  tNH  HHuH
L  H
W 'Q ^  ~  H@L   MuaQ `  Q  H3E3H@ Mu>H  H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtAQ  HHtNH+u
HSHR0IVLI3G  uH/HGHP0O   5  O   &  H
  L  Ho; H	&  O      A  Ht H  HH:      H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$h>ILl$`H A^A\_^[N {  3H  HT U i   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D\U H
  3N (H\$Hl$Ht$H|$ AVH HR HH
=N E3MHHuH  ,  H   H
L HxHH5W L5uV H-VU   HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`  H+u
HCHP0HG4  H&  H_S M T i   Ai   H
  E'H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtH虌  HH [_H [@SH HYhHtHY  HH [H [H(HB      tHAL   MtA	  Hu;H  H6R R `   K 
  
  H
  A`   &3H({H   HD$   Ht
33HĈ   H(HHH  ȅx3H(@SH H9  HuJ  Hu7HӍH  HHt#H
^  HH	
  H+u
HSHR03H [H H [@WH@HD$ H\$XH H3HD$0HHL$(LL$xHAHyrH	HH;}HH33  E3MtA  HHHHL$0H3H\$XH@_LAL9A ~HHAJI@HA3H%I  LYE3HA EHL;AL9Y AEtHHAJICHA3H%  HAL   MtIH%    HUHhH   HEHXHpHx HN H3HEGHHM3u)E   HE   Hu@uDFH  HMHE   Hu@uDFH  HMnHuHE   Hu@uIE3HUHMuHE7   Hu/@uIE3HUHMPHUH   HMHMHEHrPHHMH=   r<t?  HAH;r/  H+Hs  H'v  HHE   HuE HEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  HwHE   HuE A   H  HMHE   HuE A   H_  HME-   E-   HE   HuE IE3HUHMHE7   Hu/E IE3HUHMHUH   葦HM'HMHMHM
HHMGH3L$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+HwHCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;v  H    H=   r<t  HAH;r  H+Hs  H'v  HwH3HsHsHH\$@Ht$PH0_@SH H7 H=HH  |=HH m=HHG AHHC  H H?=HH  0=HH !=HHWF BAHHXCZ  H H<HH  <HH^ <HHE @HHCH [H%  H(HQ  <HHBH(H%  @UVWATAUAVAWH$H@  Hǅx  H$  H# H3H8  LD$pHT$PHMH  L  ML  MLt$hHMjWD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8mH|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
1   H
#   3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM 3H]Mt`IrAfok IHfHnflfHAfHnflfLHH;rI;s     HHI;rL%ݺ L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH   H H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  r H H   L   L  L   L   HUH   L   H   H   \H   H   蘾E3AL}H   H   HMI+HL   H;vdM9s
HH;rbH  HD$x3HEHEH HD$XD$`HUHL$X@  H HD$xHL HL$xH
 =  H HE Lu(Le0HEH+HHE8HUHM@LE0HU8HMXcHU8H   袽ILuHU8H   HMI+HLE(H;vdM9s
HH;rbH  HD$x3HEHEH HD$XD$`HUHL$XS  H̲ HD$xHK HL$xH
 P  L%  LeHT$hHULmH  HEWD$PWM LmLD$PHM   HHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  {H; H  HE(H  HE0H  HE8H  HU@H  ;H  HD$XL%_ L  HE`H   HEhH  HEpH  HUxH  诫H   H0  ۺH HH  H   HP  H   HX  H   H`  H   Hh  菺H  HD$XL  H   H  H   H  H   H  H  H  H   H  *H H@  HH  HD$XL% LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX  Ld$xH  HEHE   LmE IE3H  HMH  HD$(H  HD$ LH  L@  HT$xHHHU HtLEL+IH   Ht%L   L+IWf   L   HMX
HU@HtLEPL+IWfE@LmPL%a Le H   Ht%L0  L+INWf   L0  H   P
H   Ht%L   L+IWf   L   L   L-A L  H  L  L  L  H  ͽL  MtLEM+IIHtH+HLHMtLEM+IImHH8  H3H$  H@  A_A^A]A\_^]@SH HU HD$0H+U H
U HH\$0H;sSHU HT$0H;wBH\$0H+HH;
U u   H
xU H
tU HeU Ht9HH)H;
`U u   H
BU H
>U Ht
HH
/U HpX HD$0H+\X HHH

U H
6U H\$0H;sSHU HT$0H;wBH\$0H+HH;
U u   H
T %H
T HT Ht9HH)H;
T u   H
T H
T Ht
HH
T HX HD$0H+W HHH
T H
V H\$0H;sSHV HT$0H;wBH\$0H+HH;
V u   H
V oH
V HyV Ht9HH)H;
tV u   H
VV 9H
RV Ht
HH
CV HHhT H
1V H
rT EH^T H
wT rHCT H
|T H [ZHXHeS H9VS    HRH
%S H\$P3HlS H
uV H--S HRH-LS LV H
U IHV H+HHYH;s>@ HHtH   LvV HgV IHH+HH;rH
6U HQ蝡H-%U H\$PHXHx  D$(HD$0HT$83HL$ HD$8HD$@H  HD$   HǮ HF HD$0HL$0HXH%R H9R    HQ LU HU HQ H5U H6U IH+H\$PH3Ht;     HHtH   LVU HGU IHH+HH;rHR H\$PH*U H/R     HH
R H.R H HHR HXH=  D$(HD$0HT$83HL$ HD$8HD$@H  HD$   H H}E HD$0HL$0LH\$WH H      ?HAH
P H9
P HP u	H=P HIHH+P HHkHH<H;sfD  HKHHPH;wH\$0H _H9P H+*P H
KP HH+AH)P H9P @WH H
  E  HHu H
&  HG  H	  H _HV  H\$0HH  H/Hu
HWHR0Hu%H
q  H2  H	Y  H\$0H _H\  H9Ct9H
  H  H	'  H+  HCHP0H\$0H _3H*  H+H3 uHCHP0H3 Hu%H
  H  H	  H\$0H _=	  HL3 tA	  H  %  
H)3 s4  A
   H  H
  DH	  H\$0H _  u	H"  t%HD  H
ݻ  H	Ժ  H\$0H _3H\$0H _3H%  H(Hu1           H(HtIw  3H(3HtIv   "   ӷ  "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[HHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHHH\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=q      Hh)|$@)t$Pf( f( fYf(% f(
 f\ ff(fXf~Ё  fYf@  fYh fff\L      ??f\f(& fsA~$@     f( f(fYfs4fA$fYfYfX fX fYfYfYfXfX ffXfY(t$P(|$@Hhf     ??f\f( fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0L f(5A f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(j ff} ff(5Q ff5T fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$P(|$@Hh     HH)|$ )t$0f(
 f( fYff(% f(
 fXf:	 f(f~Ё  fYf@  fYz fff\L      ??f\f(8 fsA~$@     f(	 f(fYfs4fA$fYfYfX fX fYfYfYfXfX ffXfY(t$0(|$ HHfff     ??f\f( fsA~$ L	 f(5q f(fYfs4fA$fYfYfX5> fX& fYfYfYfXfX5 ffXfYf( ff ff(5 ff5 fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$0(|$ HH     %R  %D  %.  %  %  %  %  %  %  %  %  %  %  %  %^  ff     @UH HE t
e HMP H ]@UH HE t
e HMpH ]@UH HE t
e HMPʬH ]Hp  Hp  騬Hp  Hp  鐬HH   THp   Hp  lHp  pHp  TH`   dH`   H$H`   HDH`   H(H`   H@H`   HXĒHH   ĎH@   鄙HH   xH(   鴫@UH HE t
e HMH`H ]@UH HE t
e HMH@H ]H8   t@UH HE te H   -H ]HP   HP  H`   鴑H`   H餑H`   HH锑H`   H`鄑H`   HxtHP   H@   H`   HX   H   @UH HE te HM`H     H ]H`   HH%P  H`   HP  H@   H  ةH@  ̩H`  H@   H`  騩H@  霩Hx   鄩HX   xH8   lH   H   HH   xH   HhH0   TH0   HHP   <H    $H@   HH   H   1H   H   HP   HP   H@   H@   H(   TH(   HH(   HP  $H0  (H0  H0  H0  H0  H0   H0  ЧH0  ħHP  鴧H0  騧H0  H0  H0  鄧H0   H0  lH0  `H`   HP   HH`   xHP   HhH`   \Hh   DH`   H4Hh   (H`   HHh   H`   H0H(   餦HH   阦H(   錦HH   逦H`   NHp   H`   H@H@  D@UH HE te HM@H     H ]H@   H H%  H0   H%  H@   H@  ޥHT$UH HLE0H HMHO+L HHMh,HMH葥HEhH   HCEhH
  HMH3HMPHMXHE0E8HUPHM0  H HEHA   H HMH-HH   'Hh   HH   HT$UH HLE H@ HM8*L HHMX+,HM8HEXH}pHCEXH
4  HM83HM@HMHHE E(HU@HM   H) HE8A  H HM87,H8   ZHX   NH8   HT$UH HLE H HM8)Lg HHMXk+HM8HEXH}pHCEXH
t  HM83HM@HMHHE E(HU@HM   Hi HE8A  H HM8w+H8   隣HX   鎣H8   Hp   tHP   HT$SUH(HHMHHHPHH;uHAH HHEHLE0I H/ H   (L HHMP[*LHHMpK*HMPH   ԢHEpH   HCEpH
D  HMP3HMXHM`H   ƅ   HUXH     H0 HEPA@  HW HMP>*H   aHP   UHp   IHP   H   DH   HH   H$H   H(ĈH   H@ĄH   HX餈H   (bH   錈Hh   鐄H8   tjH   阡H   \Hh   PH8   jH   hH0   dH(   	H(   x	HP   <H   T	@UH HE0te0H   1	H ]H   ߠH   ӠH   ǠH`   鋇H   鯠HT$SUH8HHǅ      Hǅ       ƅ    A4   H H   H]8HH   HP@H   IHǅ      Hǅ       ƅ    A   H H   cHH   HP@H   H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   膟H  HEH3HEPHEXHJ HE8E@HUPHM8  H= HEHH3 HMHH   ,H    H   @UH HE0te0H   -H ]H   ۞H   ϞH   ÞHH   釅H   髞Hx   oHT$SUH8HHǅ      Hǅ       ƅ    A*   H H   H]8HH   HP@H   9Hǅ      Hǅ       ƅ    A   H H   SHH   HP@H   H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   vH  HE`3HEhHEpH: HE8E@HUhHM8t  H- HE`Hz1 HM`H   H   H   Hp   HP   Hp   ܜHP   МHT$UH HHǅ      Hǅ       Ep A/   H HMpHM HHUpP@HMpzH  HE03HE8HE@H> HE E(HU8HM x  H1 HE0H~0 HM0Hp    HP   Hp   HT$UH HHEh   HE`    EP A/   HB HMP!HM HHUPP@HMP踛H9  HE03HE8HE@H| HE E(HU8HM   Ho HE0H/ HM0QHP   ^H(   DHP  4H0  (H0  H0  H0  H0  HP  HP  HP  ԚH0  H0  H0   HP  餚H`   H   CH   H   H@H0  TH0   XH0  <H(   $H(   H(   H(    H(   H(   H(   ܙHp  ęHP  鸙H  鬙H  頙H  错H  鈙HP  |Hp  pHP  dHp  XHP   \HX   4H8   (Hx   HX   H8   HX   H8   HX   ܘH8   ИHx   ĘHX   鸘H8   鬘HX   領Hx   锘H    H    H    HP    HX    HP   t HP   Hd H@   T H@   H H    < H    0 H   H@   ؗH`   ̗H   鴗HH   騗Hh   霗HH   鄗H   xHp   lHH   `H   TH@   H   mHH   H@   THP   H   4H   (H@   H@   HHh   鸖HH   鬖H   頖Hh   锖HH   鈖HH   |Hh   pH`   dH   XH@   LH`   @H@   4H0   dH0   XH    LH    @H@   H`   H   ܕHH   ĕHh   鸕H   鬕H   锕H   鈕H   |H   pH   dH@   HH   H@   H8   HX   HP   H0   8H    ,H0   H\H0   H8H0   Hp<H0   H   )H    H@   HH   H@   H@   H 4{HH   H@   H8X@UH HE$t
e$HMP@qH ]H   HX   HX   H@   H    pH`  ̓H@  H@  鴓H@  験H@  霓H@  鐓H@   H@    H@   H04zH@   HH$zH@   HhT}H@   H   zH@   H   .}H@   H   KHh   uHP   yH  ܒH  ВH  ĒH0   yH  鬒H  頒H  锒H  鈒H0   LyH  pH  dH  XH  LH  @H  4H0   xH  H  H  H  H  H  H  ԑH  ȑH0   xH  鰑H  餑H  阑H  錑H  逑H  tH0   8xH  \H  PH  DH  8H  ,H   H  H  H0   wH  H  H  ؐH  ̐H0   wH  鴐H  騐H  霐H  鐐H  鄐H  xH0   <wH  `H  TH  HH  <H  0H  $H  H  H   H  H0   vH  ܏H  ЏH  ďH  鸏H0   |vH  頏H  锏H  鈏H  |H  pH  dH0   (vH   LH  @H  tH   (H  H  H   H0   uH  H  H   ԎH  ȎH   鼎H  鰎H   餎H  阎H   錎HT$UH0HH   LH   H   & H`   uH`   bHH   tH@   qH0  H  H  HP  H  H0  tHT$UH0HHǅ(     Hǅ       ƅ   A   HA H  H8  HPLH  H  HH  H* H  4H  AH  5H  )H  H  HP  H  H0  sHT$UH0HHǅ(     Hǅ       ƅ   A   H H  H0  HPLH  H  HH  H? H  IH  VH  JH  >H  2HP  &H  H  HP  H  H0  rH0  rHT$UH0HHǅ       Hǅ(      E33H  jA#   H H  H  HPLH  H  HHX  H& HX  0H  =H  1H  %H  H  
HP  H  H  qHT$UH0HHǅ       Hǅ(      E33H  uA'   H H  H(  HPLH  H  HH  H1 H  ;H  HH  <H  0H  $H  H  HP   H  H  H  pH  pHT$SUH8HHc H  HH   HRLHH  HHp  
HF Hp  PH  ]H  QH(   DH(   8H(   ,H(    H(   H(   H0   HP  H0  ܈Hp  ЈH0  ĈH  鸈H0  鬈H  須H0  锈H0  鈈H0  |H0  pH0  dH0   dHP  HH0  <Hp  0H0  $H  H0  H   H0  H0  H0  ܇H@   HnH@   H nH@   H@qH@   HX|H@   H逇H@   H(`@UH HE t
e HMH|H ]HT$UH0HHM8HPH
  HMh3HMpHMxHE@EHHUpHM@.  H HEhH HMhɲH   mHP   mH   ̹H  鰆H8   i@UH HE4te4H   QmH ]H   4mHH   (mH   \H  @H0   iHh   l@UH HE@t
e@HMxlH ]H   H  HH   hH`   H8   h@UH HE0te0H   elH ]H`   H`   HpH`   H@  zH`   HX  ^eH`   Hx  [zH`   H  8eH`   H  kH`   H  gH`   H  zH@   yH    yHH   鬄@UH HHU@HMH誨H ]@UH HHU@HMH莨H ]HT$SUH8HH]PHHtJHSm/HKH+H*HHLI?LHàH    HC    HC    33ٯHT$SUH8HH]PHHtJHSM4HKH+H*HHLI?LHSH    HC    HC    33iHT$SUH8HH]PHHt3HS0HLCL+IH    HC    HC    33HT$SUH8HH]PHHt3HS=0HLCL+I芰H    HC    HC    33谮H`   鴂@UH HEhtehHMPH   X  H ]HP   H H%  HX   H%*  @UH HEPtePHM@H     H ]H@   H H%0  H8   dHT$SUH8HH]PHHtJHS-HKH+H*HHLI?LHsH    HC    HC    33艭HP   HP   H kH(   HhHT$SUH8HH]`HHtJHS1HKH+H*HHLI?LHӝH    HC    HC    33H@   H(   H@   H%  HT$UH HHUhHUhHHExHH ]HT$SUH(HH]`HCHr\HHHv+  H=   r<t  HAH;r  H+Hs  H'v  H蹠HC   HC    H{rH 33H(   H(   8HT$UH HHUpHHcHHA   ~  HH ]H(   tH(   HT$UH HHUpHHcHHA   ?~  HH ]H(   $H(   阳HT$UH HHUpHHcHHA   }  HH ]Hh   HH   ~@UH HE0te0HMPH     H ]HP   HH%~  HP   H  ~H@  ~H`  ~Hh   H`   Hh   H`   HHh   H`   H(pH(   H(   HT$UH HHUPHHcHHA   |  HH ]H(   D@UH HE t
e HM@}H ]H   trH   hrH
  Hh   h}HH   \}H(   H   D}H   8}H   ,}H   `HP   eH   }H   |@UH HE0te0HMPH   }  H ]HP   H H%|  H@   H%j}  HP   馯H  |Hp  ~|HP  r|HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH:H0]HT$UH0HHZH0]HT$UH0HHzH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH:H0]HT$UH0HHZH0]H  DH   bH  bH  bH0  餭HP  zH  鬾H  H  e@UH Hp   H  H ]H8  hoH  |H   PH   `HP  XH   `HP   oHh  oH   yH   yH  yH   `Hp  x`HP  yH  yH0  yH0  鈬Hp  lyH0  pcHp  nH  HyHp  LcH0   `HP  _H8   _H   (HT$UH0Hf33ӤH8   _H   HT$UH0H&33蓤H8   d_H   騜HT$UH0H33SH8   $_H   hHT$UH0H覾33H  鄜H  xH@   ^H  `H  THX   ^H  <H   ^H  wH  wH  l^H(  wH  wH  xwHT$UH HH   诪LH   H   @UH HE t
e HM0PlH ]H8   wHH   a@UH HE te H   VH ]H0   YH0   Y@UH HH   H   跚H ]@UH HH   H   蕚H ]HH   TvH(   HvH`   H%Ju  HP   H%:u  @UH HEPtePHM@HPLH ]@UH HE0te0HMPH   v  H ]HP   H H%u  H@   H%jv  HP   馨H  uHP  ~uHp  ruH@   duH`   XuH8   DuHX   8u@UH Hꋅ   t   HM(HPVH ]@UH HX   HM@聕H ]HT$SUH8HH]PHHtJHS=%HKH+H*HHLI?LHCH    HC    HC    33Y@UH H0   H   H ]@UH Hꋅ   t   HM(s  H ]H   H%
t  @UH HEHteHHM@H   t  H ]H@   H H%s  HP   H%t  H8   $@UH HEPtePHM@HPܯH ]H@   JkHT$SUH(HH] HK,u  HK "u  HK(u  33HT$SUH8HHU0HM8U LE@HU8訠33@UH HE0te0HMPH   s  H ]HP   HH%r  HP   H  r@UH HE0te0H@  H   =s  H ]H@  HH%r  H@  YH  =rH0  1rHP  %rHp  r@UH HE0te0HM`H   r  H ]H`   HH%r  HP   H%r  H`   H  q@UH HE0te0HP  H   Or  H ]HP  HH%q  HP   H%!r  HP  ]H  AqH@  5qH`  )qHP   TH   @UH HE te HM0HP0H ]H0   ~H8  r^H0  f^H0   AH
 *@UH HX   H@  H ]@UH HE te H@  HP觬H ]H   HH   @UH HE te HM0HP`H ]H0   H8  ]H0  ]H0   AH
 Z@UH HX   H@  LH ]@UH HE te H@  HP׫H ]H   H!H0   O@UH HE te HM`H   p  H ]H`   H H%4o  HP   H%o  H`   H`  nH`   QHH   UH   nHP   Q@UH HE@te@H   aUH ]H   TQHx   8UH  lHT$SUHHHHǅ     Hǅ      ƅ   E3Hy  H  kH   HH  HP H  mHǅ     Hǅ      ƅ   An   H  H  HH  HP H  mH   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  表HH  HP H  3mHǅ     Hǅ      ƅ   A   Hi  H  MHH  HP H  lHǅ     Hǅ      ƅ   Ah   H  H  HH  HP H  l+ E@HHH][H  clH  WlH  KlH  ?lH  3lH  7HH   KaH  lH  RH  H   H  RH  H   NH`   RH  鼞H   AH  H(  ]AH   H  =H  yH@   `H  QkH   RH  IH  -kH  1H  kH  QH  
H  QH  H  jH  jH  jH  jH   MH`   hQH  霝H  @H  HH  =@H   H  =H  YH@   m_H  1jH   PH  )H  
jH  H  iH  PH  H  PH  ՜H  iH  iH  iH  iH  dLH   HPH  H   H   H   Hx   l^H   4H   $HP  KHp   OH   \H   ;H  KHp   OH   ,H   _HP  KHp   hOH   H   ;H  TKHp   8OH   H   `XH   $KH   OHX   \]H    hHx   THx   HHh   Hh   H   NHP   NHh   H8   NH@  gH   gHp   dNH`  gH@  |gH   pgH  tH  XgH@  LgH`  @gH   NH  (gH  gH  gH  gH`  fHT$UH HH  /LH  H  H   ԊH   ȊH   lMHP   `MH8   TMH@  xfH   lfHh   0MH`  TfH@  HfH   <fH  @H  $fH@  fH`  fH   LH  eH  eH  eH  eH`  eHT$UH HH  LH  H  ^HX   teH8   heHT$UH HHU HMP33#HT$UH HHU HMP33@UH HHUPHMX
H ]HT$UH HHUPHMhJ33觐@UH HE0te0HMPH   he  H ]HP   HH%d  HP   H`  hdH@  \dH   \H   \H  $dHx   H  dH  H  cH`   JH  FH@   J@UH HE\te\H   H   ud  H ]H   H H%c  H  H%Gd  H   郖H  gcH  kH  _H  CcHX   4cH8   (cHx   cH   cH8   cHX   bH   bHx   bH8   bHX   bH8   bHX   bH(   bH(   bH(   bHp   
H   H(   TbH(   HbH(   <bH(   0bH(   $bH   
H  
H0  |
H  p
H   $H   H   Hx    Hh   Hh   H   H   H   taH  haH  \aH   PaH   DaH  8aH  ,aH    aH   aH  aH   |H   |H@   H  `H  `H  |H  |H  |H  |H  |H  锓H  HGH  l`H  ``H  T`H  H`Hp  4`H  (`H  `H  `Hp  `HT$UH@HHǅ     Hǅ      ƅ   AB   H H  Hǅ     Hǅ      ƅp   A?   H& Hp  ښHǅ     Hǅ      ƅ    MA"H} H  虚Hǅ      Hǅ      ƅ   E3H~ H  eH  HD$ L  Hp  H  ^H  ^Hp  ^H  ^H  ^H   zH   zH  ^Hp  ^HT$UH@HH   贋HH@]H  IzHp  =zH  1zHp  %zH  zHT$UH@H EpHVH@]Hp  Hp  ]Hp  Hp  ]H  ]Hp  ]H  ]H  ]H  yH0  ]H  x]H   l]HP  `]H0  T]H  H]H   <]HP  0]H0  $]H  ]H   xH   xH@   H  \H  \H   xH  xH   xH  xH   xH  餏H  XCH   |\H   p\H   d\H   X\H  D\H  8\H  ,\H    \H  \HT$UH@HHǅ     Hǅ       ƅ   AB   H H  !Hǅ     Hǅ      ƅ   A?   H6 H  Hǅ     Hǅ      ƅ    MA"H H  詖Hǅ8     Hǅ0      ƅ    E3Hz H   uH   HD$ L  H  H  nH  ZH  ZH  ZH   ZH   vH   vH  ZH  ZHT$UH@HH   ]H{H@]H  YvH  MvH  AvH  5vH  )vHT$UH@H  EpH&H@]H  H  YH  H  YH  YH  YH  YH   YH  uHT$UH0HL   HU8sH      H   HH(HH0]H0   dH0  HYH  tH  hH  \H  PH0  H   8H   ,H    HT$UH HL   H   033蝄H@   HH@   HH@   H(H@   H8H@   HHH@   HXH@   H   =XH   >HH   HX   -H0   4HH   (HH   @UH HEPtePHM@HPH ]H@   *@UH HEPtePHM@HP輓H ]H@   
@UH HEPtePHM@HP|H ]H@   KH   WHh   VHH   VH   VHH   VHh   VH@   H@   @UH HE0te0H   H   MW  H ]H   H H%uV  Hh   H%W  H   [H  ?VH  3VH   'VH  VHT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   H H  Hǅ     Hǅ      ƅ    A    HW H   ېHǅ     Hǅ      ƅ   A!   H H  褐Hǅ     Hǅ      ƅ    MA"H H  cH  HD$ L   LCH  H  bHH8][H  TH   TH  TH  TH@   ԼH@   ȼ@UH HE0te0H   H   -U  H ]H   H H%UT  Hh   H%T  H   ;H  TH  TH   TH  SHT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   H H  Hǅ     Hǅ      ƅ    A    H7 H   軎Hǅ     Hǅ      ƅ   A!   Hؖ H  脎Hǅ     Hǅ      ƅ   o MA"H_ H  CH  HD$ L   LCH  H  `HH8][H  RH   RH  RH  RHT$SUH8HH   H{  t'HM8HPHHK .HHtvR  HwH8][Hh   TH`   HHh   <H`   H ,Hh    H`   H0H   H   4H@   x8HX   |4HX   p4@UH HHU0HM8uH ]@UH HH   HM8{uH ]@UH HE4te4H   7H ]H   3Hx   ?FH   3H  |@UH HE4te4H   H   Q  H ]H   H H%P  HX   H%nQ  H   骃HT$SUH8HH  H   9]Hx H  ePH]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  GHH  HP H  O33{H  O@UH HE4te4H   H   hP  H ]H   H H%O  HX   H%:P  H   vHT$SUH8HH  H   \Hx H  1OH]8tHH   HPHǅ     Hǅ      ƅ   A   H'  H  3HH  HP H  NHǅ     Hǅ      ƅ   A<   H  H  ߉HH  HP H  qNH  HHPHrH;uHAHl HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  JHH  HP H  MH%H8][H  MH  MH  MHT$SUH8HH  H   GZHx H  sMH]8tHH   HPHǅ     Hǅ      ƅ   AH   H1  H  uHH  HP H  MH   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  HH  HP H  L33uxH  LH  vLH  jLH  ^LH  RLH  VH  
3HT$SUH8HH  H  XHx H  LH]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  HH  HP H  yK33VwH  cKH  WKH  KKH  ?KH  3KH  7~H  +~H  KH  KH  JH  JH  }H  JH  }HH   1H  JH  p1H  JH  }H  |JH  pJH  dJH  h}H  LJ@UH HEDteDH   H   J  H ]H   H H%J  H   H%J  H   |H   IH   0H  8nH  ,nH8   0H  nHP   h0H  IH  IHp   D0H  hIH  \IH  PIH  DIH  8IH  /Hp   IHP  IH0  IH  HH  HHT$UH HH   '|LH   H   銺H@   t/H   h/HX   ̰HX   H0   鴰H0   騰Hp   ,/HT$UH0H    H?H0]H(   T=H   H(   8=H@   ,=@UH HꋅH  tH  HM@H   H  H ]H@   H H%G  H0   H%dH  H@   zH@  $Hx  T*H   8.Hp   霯HT$UHpHHJHp]H   H   yH   )H   -Hx   <HT$UHpHHOHp]H   EH   H   ]Hx  )H   h-Hp   ̮HT$UHpHHSHp]H   H   	H   $)H   -Hx   lHT$UHpHHXHp]H   uH   驵H   Hp   Hp   H   \H   :HT$SUHxHHǅH     Hǅ@      ƅ0   A!   HP  H0  輀H   HH0  HP H0  GEH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  FHH0  HP H0  DH`Hx][H0  DH0  DHx   Hx   جH   ,Hh  T'H   8+Hp   霬HT$UHpHHdHp]H   H   9H   &H   *Hx   <HT$UHpHHiHp]H   EH   ٳH   Hx  &H   h*Hp   ̫HT$UHpHHmHp]H   H   ɳH   $&H   *Hx   lHT$UHpHHrHp]H   uH   iH   -HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H   H0  }H   HH0  HP H0  wBH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  v}HH0  HP H0  BH wHx][H0  AH0  AHx   Hx   H   \H   AH`   AH@   AH8   eH   鴩H0   ttHT$SUH(HH0  HM0NHXH0  6AHtHM HHU0P33 mH  AH@  @H`  @H  @H@  @H`  @H`   H`   HH   HH   بH   ̨H   H   鴨H   騨Hx   霨Hx   鐨H   TsH   8@H  ,@HT$UH0HMpMpp  ;|~U8H H   BAH H`  .AHn H@  AH҆ H  AH   HD$ L`  LE8H@  H  [MHH0]H   p?H`  d?H@  X?H  L?H(   &H@   "H  ?H   ?H@  >H  >H   >H@  >H   H    H8   H8   H`   ܦH`   ЦHp   ĦHp   鸦H   鬦H   頦H   dqH   H>H`  <>HT$UH0Hꋍ      0  ;|~U4H H   L?H H@  8?Hx H   $?H H  ?H   HD$ L@  LE4H   H  eKHH0]H   z=H@  n=H   b=H  V=H   D@UH HHEXD HUPHM(BaH ]@UH HEPtePHM@H`<yH ]H@   H<H    bH8   <@UH HE t
e HMX0H ]H@   H   H   锤H(   鄤H(   xHH   lH   T@UH Hꋅ   t   HM(H`6xH ]@UH Hh   HM@a\H ]@UH HEPtePHM@HPwH ]H@   銱H8   鴣H8   騣H(   霣H`   H  tH  hH  \H  PH0  H   8H   ,H    @UH HEPtePHM@H`wH ]H@   H   :H  :H8  |:HX  p:H0   ^H   XH   D:H  8:H0   ^H   0H(   TH(   HHP  eHP  H/HP  H #HP  H8 HP  HP#H@   .HX   l H   pH   T H  ]H  ]H@   0 H  ]HX    H  <9H  09Hp   H  9H  9H   9H  8H  8H  Hp  8HP  8H0  8H  8H  8HT$UH HH   kLH   跚H   :HP   $H8   H@   H`   hH   ,kHT$SUHHHH  H   DHx H  7H]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  rHKHH  P H  X7HHSHH][H  <7HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  <rH   HH0  HP H0  6H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  qHH0  HP H0  X6HWHx][H0  <6H0  06Hx   dHx   XH   鬿HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  qH   HH0  HP H0  5H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  pHH0  HP H0  (5Hs[Hx][H0  5H0   5Hx   4Hx   (H   |HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  oH   HH0  HP H0  g4H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  foHH0  HP H0  3HS_Hx][H0  3H0  3Hx   Hx   H   LHT$SUHxHHǅH     Hǅ@      ƅ0   A!   H   H0  nH   HH0  HP H0  73H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  6nHH0  HP H0  2H3cHx][H0  2H0  2Hx   ԚHx   ȚH   HT$SUH8HH]PHHtJHSHKH+H*HHLI?LHNH    HC    HC    33]HT$SUH8HH]PHHt3HSHLCL+Ij_H    HC    HC    33]H
  LHX   1HX   |1HX   p1Hx   d1H   X1HX   L1Hx   @1H   41H
) KH8   8UHh   1Hh    1Hh   0H   0H   0H   0H   0Hh   0H@   H
  KHX   0HX   |0HX   p0Hx   d0H   X0HX   L0Hx   @0H   40H
1 JH    8THh   0Hh    0Hh   /H   /H   /Hh   /H@   Hh   H
} 0JH0   SH   /H   /H   t/H   h/H   \/H   P/H@   Ԛ@UH HHU`HMPJSH ]HT$UH HHU`HMh:33Z@UH HHU`HMP
SH ]HT$UH HHU`HMhJ33ZHT$SUWH0HH   HO@qHO .H O33mZ@UH HHUXHMPRH ]HT$UH HHMhN33+ZHT$SUWH0HH   HO@aHO .HN33Y@UH HHU`HMP
RH ]HT$UH HHU`HMh
33Y@UH HHUHHMPQH ]HT$UH HHM@N33kY@UH HHUHHMPQH ]HT$UH HHM@M33+YH
 GHP   (-Hp   -H   -HP   -H   ,Hp   ,HP   ,HP   ,H(   H(   H   PHT$UH Hq33wXH   $H0   H%N-  HT$UH HHH ]H`   HH   Hx   HX   THP   HH@   _H0   TPH   rH   rHT$UH HHMHHt
H   33}WHT$UH HHMHHt
H   33MWH
 EH8   H+H8   <+H8   0+HX   $+Hx   +H8   +HX    +Hx   *H
! pEH8   *H8   *H8   *HX   *Hx   *HX   *Hx   *H8   *H
q  EH8   h*H8   \*H8   P*HX   D*Hx   8*H8   ,*HX    *Hx   *H
 DHP   )HP   )HP   )Hp   )H   )HP   )Hp   HP   tH
]  DHP   )HP   |)HP   p)Hp   d)H   X)H   L)Hp   @)HP   4)HT$SUWH0HH   HO@HO )HI33THT$SUWH0HH   HO@HO (HPI33T@UH HHE(D HUxHM0LH ]HT$SUWH HH]pH   H;t-Hf     HK.*  H%*  H[(HCH;u33TH  *@UH HEPtePHM@HPLdH ]H@   @UH HEPtePHM@HPdH ]H@   	H   4*H   ďH   H鴏H8   4HP   8
Hh   T%@UH HEPtePHM@HPlcH ]H@   pHH   4H   H$H@   &HH   	H@   &HH   x
@UH HEPtePHM@HPbH ]H@   mH   T&H  H&H8  <&HX  0&H0   JH   (oH   $Hh  (H@   #H8   t(H   H(   T(Hh   Hh   ؍H   #@UHH3Ɂ8  ]@UH HM@H ]6E@UH H_CM8H ]E@UH0HHHL$(T$ L
ELEpUhHM`BH0]HH   @UH HE te H   H ]H0   H`   H0   @UH HE te H   dH ]H    @UH HE8t
e8HMXH ]H`   @$H   4$@UH HE te H   H ]HX   H@   
H   
H0   @UH HE te H   H ]@UH HE te H   H ]HX   M
H@   A
H   5
H0   )
@UH HE te H   
H ]H0   	@UH HE te H   	H ]@UH HE t
e HM@"H ]HP   H   "Hx   "HP   H   "Hx   "H(   H@   H(   H@   }HP   H   E"Hx   9"HP   ]H   !"Hx   "HP   9H   !Hx   !HH   H0   	Hp   H@   H    H   !Hp   mH0   ]H    ]H   IHh   =HP   1HT$UH@HoRH.  HI     
=  HuH@]H   H   Hp   HX   HT$UH HQH-  Hף    o 56  HH ]HX   qH@   eHT$UH HQHD-  H} ;    t5  H7H ]H0   7\H    [\@UH H  HM`@H ]HT$UH H,QH,  H ģ    *%  Hi^H ]HH   [H8   [H   @UH H  H   6@H ]HT$UH HPHG,  H > y   W"  HsH ]@UH H(  H   ?H ]HT$UH HDPH+  H ܢ z   f"  HNsH ]@UH H  HM u?H ]HT$UH HOH+  H }   W ;#  HHqH ]HT$UH HOHD+  H} ;    #  HpH ]H8   gZ@UH HEPtePH   DZH ]H   H   H8   Y@UH HEPtePH   YH ]H   H   HP   YH@   YH   H(  H  }HT$UH HHM(HPHH
<#  H	"  HNH ]HT$UH HHM0HPHH
3"  H	"  HYNH ]HT$UH HHM8HPHH
!  H	I"  H NH ]HT$UH HHM@HHPHCAH;uHAH3; HHEHH
!  H	!  HMH ]HT$UH HHMHHHPH@H;uHAH: HHEHH
j!  H	!  HhMH ]HT$UH HHMPHPHH
"  H	X!  H/MH ]HT$UH HHMXHHPLr I;uHAHB: HHEHH
m"  H	   HLH ]HT$UH HHM`HHPH?H;uHAH9 HHEHH
  H	   HwLH ]HT$UH HHMhHHPL I;uHAH9 HHEHH
"  H	D   HLH ]HT$UH HHMpHHPL. I;uHAH.9 HHEHH
)"  H	  HKH ]HT$UH HHMxHPHH
p   H	  HKH ]HT$UH HH@  H
=   H	|  HSKH ]H(   @UH HE t
e HM0詋H ]HX   H8   H   HH   {H8   HX   H   HwH   {HH   / H   # H8    H    H  _]H  ]H  G]Hp   ;]H  aH  #]H  H H  H8gH  HpH  'eH   \H   H kH   H8gH   HpKH   dH   \H   `@UH H꺸  HMP8H ]Hp   ^\Hp   _H   F\H   H HX   *\H   H8fH   NdHh   \Hh   H HX   [Hh   H8fHh   
dH0   [HX   [H0   F`H  [H(H= r_H
˕ f;Hו HH=   r<t  HAH;r  H+Hs  H'v  H7H    Hm     V  H(:H(H= r_H
˔ :Hה HH=   r<tA  HAH;r1  H+Hs!  H'v  H6H    Hm     V  H(M:H(H= r_H
˓ &:Hד HH=   r<t  HAH;r  H+Hs  H'vt  HC6H    Hm     V  H(9H(H=, r_H
 9H HH=   r<t  HAH;r  H+Hs  H'v  H5H    H       H(
9H(H=, r_H
 8H HH=   r<ta  HAH;rQ  H+HsA  H'v4  H5H    H       H(m8H(H= r_H
 F8H HH=   r<t  HAH;r  H+Hs  H'v  Hc4HP    H=     &  H(7H
Ѯ DQH
 4QH
٭ tH(H=|  t:}7x7Ly Hb L+I.CWHX     @ H(H(H=ܫ  t:-7(7L٫ H« L+IBWH      H(H(H=\  t:66LY HB L+IBWH8       H(hH(H=  t:}6x6L H L+I.BWHx     ` H(H(H=  t:-6(6L Hڭ L+IAWHЭ      H(H(H=<  t:55L9 H" L+IAWH       H(H
 $OH
! OH
y TH
٫ DH
	 4H
 $H
) H
i H
I H
 H
Y H
ɬ H
i H(H   H (H
 HuH(                                                                                   *     B     N     \     t                         س               &     :     N     j     ~               Ĵ     ޴                       j               2     (               B                    Z          ֣          J               *     F                         (     B     d     z          ܡ          6     \     ~     t               v     H     "          ޱ               `     @                    p     .               V          Ԯ          P          ƭ          8               h     $     ޫ          T          Ҫ          `     $     Щ     |               8                            8     B     Z     f     p                    ȵ               \           R     @                                    p     z          :             j          f     v     ~                                        n             H     <     2     $               Է                         ,     ȶ             2          V          ܶ     Ҷ                R     |     `                  L          r             D                  T     B     &                    Ҝ                         n     J     8     *                    ڛ     ʛ                         t     ^     P     <     .                     ֚     ƚ                    n     T     @     &                     ؙ     ʙ                         z     b          <     ,               ֘                         r     `     H     2     $                    ֗                    x     d     T     :     &                    ؖ     Ɩ                    h     T     :     "                         Е     p          Н                              2          D     X     h     |          x                    Ğ     ؞               f     J          ,     B     X     p                         ̟          <          J     *                    ڔ                    x     ^     J     :     &                            `    D           H         `             @    `                        0            P                      `                                                           0                                                                               "   x7            `F            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        p
              `h    i    
           
           
          bad array new length    
   	   
   9   `    `    8   `    
   p`              OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np               ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  __getstate__.<locals>.genexpr   ImportError 0   reshape misc    num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  0   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    Stan model {} is of mode 'test_grad';
sampling is not conducted.    shape   UNIT_E  get pystan._compat  iter_save_wo_warmup upar        adapt_window        data sim model_name model_pars par_dims mode inits stan_args stanmodel date get init_alpha  b   stan_args_method_t  B   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  h   warmup2 __str__ traceplot   method  H   int_time    range   fitptr  i   pystan.plots    _summary    NUTS    lp__    array   append  I   (dense_e)   pystan  l   stansummary L   AttributeError  gradient    order   DIAG_E  q   sampling_algo_t pars    data_args   unit_e  Q   ndarray is not C contiguous f   adapt_t0    error   vars_i  d   pars_oi_bytes   epsilon adapt_iter  g   handler tol_rel_obj user    probs   chains  Zf  warnings    index   metric  Zd  __import__  Zg  collections O   stepsize    split   holder  par extract grad_samples    (diag_e)    OPTIM   dstack  sim _get_kept_samples   format  s   _pars_total_indexes s   chain_id    utf-8   double  end ndarray is not Fortran contiguous   chains  end model_code  '   TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   'char'  s   Couldn't allocate space for StanHolder. stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392 _verify_has_samples name    LBFGS   'long'  s   Metropolis  %s  output_samples  dims_oi samples _check_pars int pystan.constants    throw   =   string_types    _remove_empty_pars  #   _call_sampler_star  =   adapt_kappa keys    send    flush   #   row_stack   =   SAMPLING    start   #   squeeze MemoryError seed    tuple   =   variational #   init_list   =   save_iterations `inc_warmup` ignored when `permuted` is True.   
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          data    inits   #   tol_rel_grad    BFGS    init_radius =   __test__    value   #   `dtypes` ignored when `permuted` is False.  =   sampling    inits   #   adjust_transform    dtype   =   _split_data #   RuntimeError    __getstate__    VARIATIONAL =   genexpr Format string allocated too short, see comment in numpy.pxd #   variational_algo_t  =   elbo_samples    tol_param   thin    numpy   #   DENSE_E refresh adapt_term_buffer       Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. =   newaxis flatnames   flat    numpy   #   getLogger   =   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    Couldn't allocate space for stan_fit.   init    sampler_params  pystan.misc warn    numpy   #   digits_summary  numpy.core.multiarray failed to import  column_stack    adapt_delta =   stepsize_jitter fnames_oi   #   sampler_t   =   control random_seed #   numpy.core.umath failed to import   =   handlers    numpy   #   (unit_e)    ufunc   =   logging adapt_init_buffer   #   Non-native byte order not supported =   diagnostic_file argsptr adapt_engaged   numpy.core.multiarray   C:\Users\appveyor\AppData\Local\Temp\1\tmpl8oxck3d\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.pyx  adapt_gamma #   history_size    _call_sampler   numpy.core.multiarray failed to import  _ARRAY_API  =   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  #   _ARRAY_API is NULL pointer      numpy.core.umath        module compiled against ABI version 0x%x but this version of numpy is 0x%x      module compiled against API version 0x%x but this version of numpy is 0x%x  =   FATAL: module compiled as unknown endian        FATAL: module compiled as little endian, but detected different endianness at runtime   numpy.core.umath failed to import   #   _UFUNC_API  =   _UFUNC_API not found    _UFUNC_API is not PyCapsule object  #   _UFUNC_API is NULL pointer  =   SSE, SSE2   #   empty_nested() must be true before calling recover_memory()     empty_nested() must be false before calling recover_memory_nested() self        empty_nested() must be false before calling set_zero_all_adjoints_nested()  =   stan_version_major  #   stan_version_minor  =   stan_version_patch  #   unkown file name    numpy   =   unkown file name        C:\Users\appveyor\AppData\Local\Temp\1\tmpl8oxck3d\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.cpp  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.pyx #   __init__.pxd    stringsource    type.pxd    'int'   =   Unknown exception       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.__getitem__        attr_names      genexpr stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.__getstate__.genexpr       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.__getstate__   list        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.__setstate__       Expected %.16s, got %.200s  list        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.__reduce__ stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.num_failed.__get__ dict    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.num_failed.__set__ list    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.test_grad.__get__  list    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.test_grad.__set__  list    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.inits.__set__  #   Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.par.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.value.__get__      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.value.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.args.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.mean_lp__.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.mean_lp__.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder.sampler_param_names.__set__    throw   =   Expected %.16s, got %.200s  #   Expected %.16s, got %.200s      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._pystanholder_from_stanholder   'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._dict_from_stanargs =   'NoneType' object has no attribute '%.30s'  #   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  _call_sampler_star      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._set_stanargs_from_dict stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._dict_to_vars_r dict    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._dict_to_vars_i self    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._call_sampler_star  =   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._call_sampler   Expected %.16s, got %.200s      genexpr stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392._call_sampler   __cinit__       attr_names  plot        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__cinit__ __init__    throw   #   __init__    close   =   __init__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__init__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__getstate__.genexpr      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__getstate__  plot        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__setstate__      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__reduce__        'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.plot  #   'NoneType' object is not subscriptable  extract stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.plot  =   traceplot   #   traceplot       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.traceplot stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.traceplot extract 'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.extract   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range summary stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.extract   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__unicode__       stansummary upar        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__str__   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__repr__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.__getitem__   =   stansummary args        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.stansummary       summary stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.stansummary       grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.summary   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.summary   log_prob    %d.%d   #   log_prob        grad_log_prob   get_logposterior        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.log_prob  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.log_prob  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.grad_log_prob dict        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.grad_log_prob args        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_adaptation_info   =   get_logposterior        'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_logposterior  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_logposterior  get_sampler_params  #   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_sampler_params    =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_sampler_params    #   'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_posterior_mean        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.constrain_pars    'NoneType' object is not iterable       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.unconstrain_pars  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_seed  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.get_stancode      numpy.ndarray.__getbuffer__ plot        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.flatnames.__get__ 'NoneType' object has no attribute '%.30s'      numpy.PyArray_MultiIterNew1 data        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._verify_has_samples       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._update_param_oi  numpy._util_dtypestring stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._get_param_names  numpy.import_array      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._get_param_fnames_oi      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._get_param_names_oi       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._get_param_dims   numpy.import_array      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._get_param_dims_oi        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.constrained_param_names   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.unconstrained_param_names stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model._call_sampler =   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew2 mode        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model.sim.__set__   #   numpy.PyArray_MultiIterNew3 =   numpy.PyArray_MultiIterNew4 #   numpy.PyArray_MultiIterNew5 =   Expected %.16s, got %.200s  #   numpy.import_umath  #   numpy.import_umath  #   numpy.import_ufunc  #   numpy.import_ufunc  #   vector.to_py.__pyx_convert_vector_to_py_double  vector.from_py.__pyx_convert_vector_from_py_double      string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    # 
 string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  vector.from_py.__pyx_convert_vector_from_py_size_t      string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   #   string.from_py.__pyx_convert_string_from_py_std__in_string      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ date        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  #   num_failed  1.0 test_grad   1.0 mean_pars   1.0 mean_lp__   1.0 adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.PyStanHolder    extract Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  1.0 traceplot   [   __unicode__ ,   stansummary ]   summary log_prob    #   grad_log_prob   get_adaptation_info #   get_logposterior    #   get_sampler_params  #   get_posterior_mean  .   constrain_pars  unconstrain_pars    .   get_seed        get_inits       get_stancode    get_stanmodel   _verify_has_samples     _update_param_oi        _get_param_names        _get_param_fnames_oi    _get_param_names_oi     _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel       cython_runtime  type    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.StanFit4Model   ndarray Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.__pyx_scope_struct____getstate__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.__pyx_scope_struct_1_genexpr    StanFit4Model    while calling a Python object  need more than %zd value%.1s to unpack  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.__pyx_scope_struct_2___getstate__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.__pyx_scope_struct_3_genexpr     while calling a Python object  at most stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392 builtins        __builtins__    __name__        PyStanHolder     while calling a Python object  exactly stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392 %s() got multiple values for keyword argument '%U'      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392 builtins        flatiter        broadcast       NULL result without error in PyObject_Call      %.200s() takes %.8s %zd positional argument%.1s (%zd given) send        init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392    init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392    name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope      NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        at least        %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       calling %R should have returned an instance of BaseException, not %R    %s() got an unexpected keyword argument '%U'    '%.200s' object is unsliceable  Missing type object     Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'      Expected a dimension of size %zu, got %zu       Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected 1.0 Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d    1.0 Expected a comma in format string, got '%c' 1.0 Expected %d dimension(s), got %d    1.0 Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler   1.0 Big-endian buffer not supported on little-endian compiler   1.0 Buffer acquisition: Expected '{' after 'T'      Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)       'NoneType' object is not iterable   ,   Missing type object  /  Cannot convert %.200s to %.200s stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392 cannot import name %S   %s (%s:%d)  %]  value too large to convert to int    [  can't convert negative value to int %1% value too large to convert to unsigned int  :   can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    error   %1% can't convert negative value to pystan::stan_args_method_t  %1% value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   :   value too large to convert to pystan::optim_algo_t  %1% can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    model   :   can't convert negative value to pystan::variational_algo_t  %1% value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  :   can't convert negative value to long    _cython_0_27_1  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing %1% can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object nan _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   collections.abc close() -> raise GeneratorExit inside generator.        if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections NAN Cython module failed to register with collections.abc module    Cython module failed to register with collections module    value   %1% backports_abc   send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    0.1e1   :   gi_running  %1% gi_yieldfrom    object being iterated by 'yield from', or None  __name__    0.1e1   %1% name of the generator   __qualname__    qualified name of the generator generator       %.200s.%.200s is not a type object      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392 an integer is required  compiletime version %s of module '%.100s' does not match runtime version %s     %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    0.1e1   :   boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.   %1% grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    0.1e1   %1% Argument n out of range: got %1%    0.1e1   :   boost::math::prime<%1%> is not converging   1.0 grad_reg_inc_gamma  0.0 is not converging   1.0 grad_reg_inc_gamma  1.0  iterations, gamma function gradient did not converge.  exceeded    1.0 k (internal counter)    grad_reg_inc_gamma  1.0 grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1        Must use algorithm="Fixed_param" for model that has no parameters.  0.0 Output generated by Stan (test_grad)    Point Estimate Generated by Stan    0.1e1   1.0 Sample generated by Stan    0.0 Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    1.0 Sample generated by Stan    0.0 Sample generated by Stan (Variational Bayes)    user    stepsize__  1.0 treedepth__ 1.0 n_leapfrog__    divergent__ 1.0 energy__    1.0 stepsize__  1.0 int_time__  1.0 energy__    1.0 # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    1.0 boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    0.0 boost::math::cbrt<%1%>(%1%) 1.0 0.003379167095512573896158903121545171688   0.0 0.0834305892146531832907    1.0 -0.338165134459360935041    %1% -0.0509990735146777432841   :   -0.00772758345802133288487  %1% -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    :   0.00858571925074406212772   %1% 0.000370900071787748000569      -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  TEST GRADIENT MODE      C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  Initial log joint probability =         but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.    lp__        . Improved by    Log joint probability =        Iteration       Initial log joint probability =     lp__        Optimization terminated normally:           Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated with error:     Initial log joint probability =     lp__        Optimization terminated normally:           Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated with error:     lp__    lp__    0.003379167095512573896158903121545171688       0.0834305892146531832907        -0.338165134459360935041        -0.0509990735146777432841       -0.00772758345802133288487      -0.000322780120964605683831     0.455004033050794024546 0.0875222600142252549554        0.00858571925074406212772       0.000370900071787748000569      -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)     Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      0.9016312093258695918615325266959189453125e-19  0.25479851061131551     Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   -0.32555031186804491    -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument a to the incomplete beta function must be greater than zero (got a=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Adjust your expectations accordingly!   Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Initialization failed.  Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::digamma<%1%>(%1%)   Log probability=       Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.      Log probability evaluates to log(0), i.e. negative infinity.  Exception initializing step size.       Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:        Rejecting initial value:          Gradient evaluated at the initial value is not finite.         seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps         attempts.      ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)  The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%)  Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Result of tgamma is denormalized.       The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.  Evaluation of tgamma at a negative integer %1%. Unknown function operating on type %1%  The argument a to the incomplete beta function must be greater than zero (got a=%1%).   Error in function       The argument b to the incomplete beta function must be greater than zero (got b=%1%).   Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Cause unknown: error caused by bad argument with value %1%      Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    boost::math::bessel_kn<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       -3.7595974497819597599e+11      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      Unknown function operating on type %1%  The binomial coefficient is undefined for k > n, but got k = %1%.       Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "    T             T (          "   T            T (          "   T            U P          "   U            U           "   4V            DV (          "   V            V           "   W            (W (          "   xW            W (          "   W            W 8          "   8Z            PZ h          "   Z            Z h          "   [            ,[            "   l[            |[            "   [            [ h          "   L\            d\ h          "   \            \ h          "   8]            H] (          "   ]         	   ]           "   X^         
   ^           "   _    8_    `_          "   a    a    b           "   b    b 
   c           "   @g    g    g           "   xh     i     i          "   Lk         
   tk           "   k         
   l           "   l            l           "   8m            Hm           "   p    $p    (q            "   r            r            "	   4s            |s (          "   t            $t (          "%   tt         '   u x                               
         0         p   :      @                 ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx
          
    Y     o   `
   `    
         0         p   :      @   
           p
    M    `    
   pe   5    p
   ]   
                      &   ,      @       8   >   
    %                             
            0   @            0
    	          ȱ
      
       
          
   @/       
      J   D            0      H
           
   `             
   A   `    `       `    ȥ
      
   `         `      p   :   `   @      
         
   X
    Y    X    p
   @	       
   a      `
                
   0c   
   e       
          ة
    t    s    
   0f       
           (
   -    &    '    @)    @'    0*    *    +    `,    
           Ш
              Mb`MbPMbP?Mb`?
   `        `    
    B   `    `       `    
   P   r   0   `r      p   :    r   @   @
   8   h	      H
   Щ    u   0    w       p   :   v      е
            `      p   :   `   @      8
   :   :   :   `    `    h
           
   /       H
   0    `    `    `    `    `    `    `    `    `    `    
      `   @            @      &   ,             `              UUUUUU?UUUUUUUUUUUU?UUUUUU
   $	      	   ظ
   P         0       p   :            
           x
           `
            
       
   -    &    '    @)    @'    0*    *    +    `,    0
         /          
          
   l   
               h
   6    `    `    `    `    
            `      p   :   `   @      (
         t	   `
   p      0         p   :      @   E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        
   	   x   0	                         
      (
   /       /          
   ~       `    `    `    `    `    
    C    ?    ?    @@    7    7    7    @    7    
           h
   T     v    8
   	         
              h
   
   
          
   `      
      	   \   
   `    0    p
   0=       
      
      P                 &   ,          2   8   >    
   p7    07     7    6    6    P
   `       @
               
   
                 X
         .    H
   ~    ~    `    `    `    `    `    
   P   X
                @   }      0}   
           
      
           p
   	       
   5    5                                     
 
                     	               	               
                                              (
   ,
       
      Pw   0    w       p   :   v      
   T     U    
   Ъ               p   :   `   @      
    %    7    7    7    7    7    7    7    7    Ȱ
           
         /          p
   ,   
   0a       
         `    `        p   :         0
      p
   p      `    `       p   :   `   @   p
   T    `T    
   	   
   `      
   P   r   0   `r      p   :    r   @   
       
          _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?
   `    
   Ъ               p   :   `   @      
          
   5    1    0     2    1    2    2    3    3    4    4    
       z            p   :   `   @       
                           0
    8   `    `    7   `    з
      8
                           
          
   Pb   h
   {       |             
   `            x
      D   L	           ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?x
   `~    
   	   ش
   \	          ?   =
?   @33?   =
?      ?   ?    ?x
   	   
                                  
           
      $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?X
   @   0         @              (
   	   h
            0       p   :                   
      `
    
   @
           P
           
      Pw   0    w       p   :   v          
   0?   =   `>   =   =   
   `    H
   @>    p8    8    :     8    9    ;     =    =    8
   `        `            gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@`
   @Y        
           
   N   0    X
         	           '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        `
            0       p   :            
   0e   5    p
           
      
   	   
          x
           
      `p   0   `r      p   :    r   @   
   `      `    `       p   :   `   @   
   T    V    Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context     bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product x   to_matrix(array)        vector size     rows * columns  .   y   m   k   T   Y   A       variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =             anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97      data initialization K   t   S   t_change    X   sigmas  tau delta   beta        variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   gamma       Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!   C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      Undefined transformed parameter: gamma  []      iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed               Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.         iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes       MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   C:\bld\fbprophet_1508469129692\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "   0            E `          "   \
            8E           "   \
            D           "   І            D            "   tB            B `          "   A            A            "   D            @A            "   A            A           "   @            @ 0          "   x:            P>            "   =            = x          "   p=            =          "   l            (=            "   \
            <           "   \
            ;           "   ;            P; X          "   *            :          "   x:            :            "   5            @:            "   x7            9            "   ~            9            "   x~            9            "   H9            X9            "    9            9            "   6            8            "   z            8            "   P6            `6           "   5             6            "   x7            5            "   P*            5            "   *            P5            "   x7             5            "   x7            4            "   ~            4            "   x~            4            "   x7            4            "   |             4 8          "   x7            3            "   6            3            "   z            h3            "   `            2 @          "   `            X2 @          "   x7            1            "   0            0 `          "   \
            p0           "   /            / 0          "               X/ 8          "               , (          "               + X          "   *            + @          "   *            *          "   P*            `*            "   *            *            "   x7            )            "   x7            )            "   ~            X)            "   x~            0)            "   x7            )            "   x7            (            "   ~            (            "   x~            (            "   |            `( 8          "   |             ( 8          "   |            ' 8          "   |            ' 8          "   P}            `' 0          "   +            0'            "   x7             '            "   x7            &            "   6            &            "   z            p&            "   6            H&            "   z            &            "   %            %          "   T%            `%          "   #    #    #            "   8M    #    @# 8          "   8M    |"    " 8          "
   D!            ! @          "
                  H          "               p 0          "                0          "   ,             0          "   8M                    "   8M    ,    X            "   h             X          "                 (          "   l             X          "                           "   l             @          "                           "   4                        "               x            "               @            "                            "       8 	   `            "   L    t 
               "	   `             H          "   $    <    h            "                       "           0            "   8M    l     0          "                       "   8M    L    x 0          "                       "   
        @            "
               P
 8          "                8          "   D
              P          "               p	 0          "   t            0 P          "   8M         0          "   8M    x     0          "   p                   "   P                   "   0    p               "       X               "        ,    ` p          "                  0          "   
            X             "        -              "            
               "   D            X            "               0 X          "   l             X          "                           "               @ p         "                           "   <                       "                 p         "               h            "   $            0 0          "                           "   4            H            "   H                        "   Ԩ                       "   |            @ 8          "   x7                        "   x7                        "                           "                           "
   ̪             p         "   H            X H          "                           "                (          "
   ̪             p         "   l            x (          "                 (          "                          "                (          "   <            H 8          "                 (          "                           "               ` 0          "                0          "   x7                        "   x7            h            "   ~            @            "   x~                        "   x7                        "   x7                        "   6                        "   z            `            "   ,            8            "   6                         "                           "                           "   h            x            "        +              "                           "        +              "   X    p     (          "                         "   x         	    0          "   ؝            0 0          "       \               "       4    `           "           @ `         "                       "             `         "   |                   "                         "           0           "            `         "                      "   d         p         "                 8          "   T            p            "                            "	           0           "        -              "   L             x          "+   T     Y   @           "   |             (          "   4            H            "                P          "               ( P          "                P          "               0            "                           "   8M    $    P 0          "                           "                             "   \                   "   @         
    @          "                      "   @         
   p @          "   
                        "   H            X            "                           "               ȿ            "   X            p           "                            "   Ⱦ            о            "   x                       "            	                "   8M    D    p            "   |             p         "               (            "   8M         0          "!        :              "   |         1   P           "!   ı    ̲ :   P          "   <         1              "               خ            "   ؀                        "   P}            p 0          "   |            8 8          "   x7            Э            "   ~                        "   x~                        "   x7            X            "   ~            0            "   x~                        "   x7                        "   ~                        "   x~                        "               X           "                           "
   ̪              x         "                0            "                (          "   Ԩ                       "   P            h            "   $                       "   ȥ            0 0          "   $                       "   {         	    8          "   z            h            "   z            @            "   6                        "   z                        "                           "   `             @          "                P          "   $    <    h            "   8M         (          "   8M    p     (          "   ؝             0          "   L     .   @           "       d 0              "   L                       "   L                       "                         "   0            P @         "                          "   P                       "                          "   P            P           "   Ȕ                      "   @            ` @         "                          "   P            Г           "                          "   P            X           "                         "   8         -              "   ܍         -              "       H %   p           "   P            ` H          "                x          "   @            p H          "   ̈            P           "   \                       "                P          "   І            ؆ (          "   ؅            @ X          "   c            x @          "   e            H            "               Є P          "               P @          "                P          "                @          "               X 8          "   8M    ԁ      H          "   8M    @    h (          "   ؀                        "                           "   x7            x            "               8            "                           "   8M    4    ` 0          "   x7                         "   x7            ~            "   ~            ~            "   x~            ~            "   |            H~ 8          "   x7            ~            "   |            } 8          "   P}            } 0          "   P}            `} 0          "   |            } 8          "   |            | 8          "   {         	   `| 8          "   {         	   { 8          "   x7            x{            "   x7            8{            "   6             {            "   z            z            "   y             z            "   y            y            "   py            y            "   x            x (          "   <x            Px (          "   ,v    v &   v           "   Tu    tu    u 0          "   t    t    t 0          "   s    s 	   t 0          "   r    s 	   @s 0          "$   o         ?   p          "   d            `o 0          "   8M    n    o 0          "   8M    xn    n 0          "   8M    n    8n 0          "   8M    m    m 0          "   8M    @m    hm 0          "   8M    l     m 0          "   8M    pl    l 0          "   8M    l    0l 0          "   8M    k    k 0          "   8M    8k    `k 0          "   8M    j    j 0          "   8M    hj    j 0          "   8M     j    (j 0          "   c            i @          "   i         	   Pi 8          "   c            h @          "   c            hh @          "   g         
   g @          "   g         	   0g @          "   e            f P          "   hf            f            "   f            @f (          "   f            f (          "   e            e            "   e    0e 
   `e            "   td            d            "   c             d @          "   c            c @          "               Pc P          "   8b    hb    b            "   Xa    a    a            "   p`    `    `            "   ^    ^    _            "                   x^            "   Q            ]            "   p]            x]            "   ]            (]            "   \            \ 8          "   x7            \            "                    \            "   x7            [            "   x7            [            "   8M    Z    Z 0          "   `Z            xZ            "   8M    Y    Z 0          "   Y            Y 0          "   x7            pY            "   X            X            "   <X            XX            "                    X            "   W            W X          "   W            W X          "                   0W            "   8M    V    8V 0          "   8M    pU    U 0          "   Q            0U            "   x7             U            "   x7            T            "   x7            T            "   x7            PT            "                   0T            "   Q            S            "   8M    LS    xS 0          "   8M    ,R    XR 0          "   Q            Q            "   ,Q            HQ 8          "	   dP            P (          "   O            P P          "   M            O (          "   M            O (          "   <O            `O p          "   N            N           "   M             N           "   8M    HM    pM 0          "   M            M (          "   L            L            "   dL            L            "
   8K            K            "
   I            @J            "   
            I            "   H         
    I            "<   hB    HD n   E          "b   8    ;     <           "   08         	   p8            "   x7            8            "   x7            7            "   x7            7            "   x7            7            "   6            P7            "   6             7            "   6            6            "   6            6            "   6            6            "   5             6 8          "   5         
   @5 H          "   <            4            "   l4            4            "   (4            84            "   D3         
   3 (          "   ,             3 (          "   ,            2 (          "   |+            2 (          "   +            p2            "   |+            @2 (          "   1         
   1 P          "   1            (1 @          "   D0            0 8          "   D0            `0 8          "   p/            /           "   p/            /           "   0.            . 8          "   0.            `. 8          "	   0-            - 8          "   ,            ,            "   &            ,            "   ,            X, (          "   ,            (, (          "   |+            + (          "   +            +            "   |+            + (          "   *            * 8          "   )             * @          "    )            ) 8          "    )            8) 8          "   @(            (           "   @(            `(           "   '            '            "   ,'            @'            "   &            &            "	   %            & 0          "   %            P% 0          "
   #            `$ H          "   #            P#            "   ,!            "            "   @"            X"            "   !            !            "   ,!            8!            "
               @             "                           "            H          "             H          "
   (                   "           @           "   D            ` @          "                 (          "                           "
   `         @          "   L    |     0          "            0          "             @          "                (          "   8            P            "   d                        "                            "   P            x            "   l                        "	   \
            
            "   
             
            "   <                        "   |                        "            
    0         "   L            X            "                            "               
            "   \
            h
           "               
            "   $	            @	           "                           "                8 0          "                 H          "                0          "               @ 8          "                P          "   x                        "   <            H            "                           "                           "                           "                           "   t                        "                0 H          "                (          "   d             0          "   d            p 0          "   <            ( (          "   <             (          "                (          "   <            H (          "   <                        "   <                        "   <                        "   <            x            "   <            H            "                                "                             "   (             0  (          "   8
            
            "	   @
            
 `          "   
            
 (          "   l
            x
 (          "                   H
                          Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                 ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    <jY    
   p  |
 |
                                                                                                               p   x                                 m            0            p 
 p
                            
         
             p             @   
                         
 
                            (
         H
  
 غ
                                 @   
                        
                	   
         =            @   8
                      = 
 ȥ
                 `            @    
                `      0. 0
 
                 PM             @   
                        _ 
 h
                            `  
 
                            H 8
 
                           * 
 
                            
         P            @   
              =            @   
                        X 
 p
                            b 
 
                 x
 0
 
 x
 
 
 h
 x
 
 
                                                           
                   d 
 0
                 "             @   
             \            @   `
             -            @    
                (       L 
 Ш
                            -  
 
                            P` x
  
                 
 X
                            `2 P
 `
                 f            @   
              
 
 @
 X
                                    `# 
 ة
                 
 
 غ
                                `  
  
                            
                    
                     @   h
                        @
         
 
 @
 
 غ
  
 
                                                ^ P
 
                 "     (       @   
                        N 
 H
                            x7 `
 p
                 _             @   
             -            @   
             
 
                            
          L            @   p
             
 
 
                               
                   X 
 x
                           
         0
 
 
 X
                                   p
                     G 
 
                 
 
 
 غ
  
                             
 
 غ
                        (       `V 
 p
                            . X
 
                 G            @   `
                P      * 
 
                 H
 
 غ
                      4            @   0
                        p+ 
 X
                            
                    > P
 
                              @   
             
                         
                    5 h
 
                            - 
 8
                 
 x
 
 X
                         *            @   
                        
         p+         P      P   
             
 
                 p
 
 
 غ
  
                                        \ 
 8
                            0
                    ` 
 x
                 x7             @   `
                        8 
 Ȱ
                 
 
                           @> `
 
                           x
                    8
                    @; 
 `
                 >            @   P
                        x
                   [ 8
 ȱ
                            @e 
 
                 @
                        
                   I 
 @
                            f 
 h
                            
                    
                    D 0
 
                 
 
                 0            @   
             @            @   0
             N            @   
                        `
         HL             @   @
                        B 
 
                           \ `
 
                 P            @   (
                        
          
 غ
                 
             [            @   8
                         
 
                 P
 0
                    (       00 0
 ش
                            X
                    
                    x
         x
 
 غ
  
                                    
                    
                    p
         x
 
                            ' `
 е
                 @+             @   
                        h%  
  
                 (            @   
             
 
 P
 
 غ
  
 
                                                
                    
         8            @   
                         : 0
 
                            (
         (
 p
 
                               > P
 h
                 
 
                 @e            @   
                        p_ 
 з
                 
 
                 @+            @   
             
 
 غ
  
                                    
            P      \ `
 x
                 
 
 X
                                
                     ^ P
 ظ
                        
   
                    + (
 
                 
 (
 غ
                                 
         
 x
 
 غ
  
 
                                 d            @   
                       
         x5               @   @
                       
          	           @   X
             
 
 غ
                     @ 	           @    
                        5 H
 
                 X
             P`             @   x
                        @Z H
  
                    P      > P
 (
                            `
                    h
         `
 
 X
                                 4 0
 
                            @
                   `, 
 
                 <             @    
              
 @
 X
                     h0             @   
             
 
 
 X
                                    L 
 
                 
 0
 غ
                                
         8             @   H
             @            @   
             7            @   ع
             0
 غ
                             
 
                 
 
                 p+             @   
             
 0
                            
         
 
                            
         
                         ) 
 h
                 @O            @   
             
 x
 
 
                         =            @   
             P
 
 غ
                     0
 `
 
 X
                                   
         h%            @    
                        P 
 
                             
 
                            @" 
 
                 X'           @   
             h
 
                 
 غ
                 
 X
                 p_            @   
             @Q            @   
                        
                     @   
                        
                    X
         "            @   `
                        
                     @   
             H5            @   ȶ
             W             @   8
                        
         
 
 
 
 X
 8
 
                                               
         `
 
  
 @
 X
 
 
                                     @
 0
                             h
 
                            
                    H
                    F (
 
                 T           @   
                        d 
 `
                 0            @   
              $            @   
                        @Q 
 
                 `            @    
                        <  
 (
                            (
                    ( h
 h
                 =            @   
                       h
         hU            @   x
                        @
         8
 
 غ
                                c  
 0
                            J 
 X
                              @   
                        
                    
                    @ 
 
                 (
 غ
                 غ
                (       7 ع
 (
                           `
         
 x
 
 
                         
 @
 
 غ
  
                                        p
                    
         
 
                            xW  
 
                           0 
 0
                 e            @   
             @+            @   
             
 
                 X            @   
             <            @    
             
 0
                            
 (
                 
                       (
         x
                        X 
 
                 -    (       @    
             xW            @    
                        PM 
  
                 X
  
 
 @
 X
 
  
                                     
 0
 
 
 X
 
 H
                                     Q            @   
             
                        
         
 
                            0. 0
 
                            e 
 8
                            `
                    T 
 x
                 
  
 غ
                                PD 
 
                            0 
 
                 N            @    
             
             *            @   
             b            @   
                        3 P
 
                            H
         X            @   Ȼ
                        
                    C 
 
                 Q            @   
                        
         H            @   8
                        V @
 
                            
                    
         8            @   
                         
 (
                            ( 
 P
                            08 
 x
                           H
         
 
                            
         V            @   @
                        `  
 
                           
                   
                     
         V            @   
                P       = 
 
                            Q 
 
                            
                    @> `
 
                 
 0
                 C            @   
              A            @   P
                        
                    
                    
         ]             @   X
                        G 
 
                 X'            @   
                       G `
 `
                 p
 
 x
 
 X
 
 
                                                `
                   08 
 
                           
                    (
         7            @   X
                         A P
 `
                 8
 
                 p+         @      P   
                         = 
 
                 F            @   
             
 
 
                                H
                    h
         pX           @   8
             `V            @   
                        
 
                             @   
             -            @   X
                       P
         
 
 
                     %            @   
                        (V H
 
                            p
                    W 8
 
                 `
 
                 W            @   `
             '            @   
             8
 
                            
         c            @    
                       PD 
 
                            x
         
 X
                            x` 
 
                 0c            @   P
                        * 
 `
                 pX            @   8
             
             
 p
 
 
 غ
  
 
                                     @
 x
                            P 
 
                 
                        0 
 P
                 p
 X
  
 
                                    = 8
 
                           8
         `             @   
             
 (
 غ
                     @
 X
                    P      d 
 @
                 X
 
                            ` 
 
                 X
                        E H
 
                 8
 
                            ] X
 
                 8     (       @   H
             p
 
 P
 
                         н
             X'           @   
             
 
 غ
                                
         0
 
                 08            @   
                        @H `
  
                 
 
                 
 @
 X
                                
                   `2 P
 
                            U 
 
                 
                       % H
 
                 x5             @   @
                        " 
 H
                  ^            @   P
                          @   
                        0
         
 
                           
                    x
                   
                    P
                     @   
             #            @   
             PD            @   
                        
         @Z            @   H
                        x
                    
         
 
 X
                                
                    3 
 p
                  U            @   `
             
 
                         0
 
 x
 
 
 h
 x
 
 
                                                         
         b            @   
             00            @   0
                        8  H
 
                 @;            @   
             
 
                 0
 0
 
 x
 
 
 h
 x
 
 
                                                            
                     " 
 p
                            
                    U 
 
                 @>            @   `
                        hU x
  
                 
 P
 
 غ
  
                             U             @   
                        [ 8
 
                            
                    
                    @ 0
 
                            0
         H5             @   ȶ
             `?            @    
             0.            @   0
                        G `
 
                  
 
 غ
                     H
 p
 X
  
 
 
                                            8 
 
                            8
         %            @   H
                        (
                    7 ع
 
                            
                    h
                   X 
 
                            Ⱥ
                    H
         5            @   H
             
             0
                        # 
 
                 D            @   0
             
 p
 
                     I            @   
             "            @   
                        * 
 H
                           X
 p
                            L 
 
                            ȼ
                    " 
 
                 D            @   0
             x
 
 X
                                H
         +            @   (
             X            @   
             
 P
 X
 
 
 
                                 (V            @   H
                        
                    
         
  
 @
 X
                         x
 غ
                            I 
 
                  
 H
 
 غ
  
                             `#            @   
             8
 
 
 
 غ
  
 
                                                T 
 @
                 
             P            @   
             x
 
                 P
 0
 `
 
 X
 
 H
                                     
 
 
 غ
  
 
                                           H
                    P (
 H
                            `?  
 p
                 
 
                    (       0. 0
 
                            P7 0
 
                 8
 
 
                     @+            @   
                        
         
 غ
                 M               P   
                P      G `
 
                 U            @   
                        `V 
 
                            
         L             @   
             
 8
 
                     0S             @   
             h
 
                 P`     (       @   x
                        
                   
         "             @   
                        h
         h
 
 
 (
 غ
  
 ȯ
                                      ?            @   
                        O p
 
                 T           @   
             `             @   
             ,            @   
                        h
         P7            @   0
             @"            @   
             
             
             E            @   H
                        8
         '            @   `
             
                         
 X
                            X
                    
                    
          a            @   x
                        p
         
 
                            0
            P       G 
 8
                           x
         8
 
                 @
 
 غ
                     x
 
                           (
                    
                    X Ȼ
 
                            
         J            @   
             .            @   X
              
 
 
                      )            @   
             
 @
 x
                     H
  
 H
 
 غ
  
 
                                     T            @   
                    
    
         
             B             @   
             @+            @   
             L            @   
             (            @   h
              
             3            @   
                        
            (        = 
 p
                 %               @   
                        P
         P
 @
                 M            @   
                      @  
 
                 T            @   
                        F 
 h
                 
             P
 X
 
 
                         hU           @   x
             hU           @   x
             3             @   P
                         
            P       
 X
                            `
         P
             
 P
 
                     p
 
                 x5            @   @
                        b 
 
                            H
                    
         `2            @   P
                        `, 
 
                            @
         
 
 
                     O            @   p
                         a x
 
                  G            @   
                P      `V 
 `
                            - X
 
                           
                      
 
                            \ `
 
                            
         
 
                            % H
 H
                            " `
 p
                            H
                    ' 
 
                            X
         `            @   
                        D 0
 
                            
                     ? 
 X
                           
         x`            @   
             @H            @   `
             
 
 (
 غ
  
                                        `
                    7 X
 0
                  
 
                 
 h
 
                     P             @   
                        00 0
 
                 F            @   (
                         $ 
 
                 
 غ
                 @+            @   
             H
 
                 
 
 x
 
 
                              :            @   0
             \             @   
              "            @   
             5            @   h
             `,            @   
         GCTL   `  .text$di    `  . .text$mn    D     .text$mn$00  E   .text$x    .text$yd      p
  .idata$5    p    .00cfg      .CRT$XCA        .CRT$XCL       .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ        .CRT$XPA        .CRT$XPZ        .CRT$XTA        .CRT$XTZ     X .rdata  H
 (   .rdata$T    p
 U  .rdata$r    |
 t  .rdata$zzzdbg   
    .rtc$IAA    
    .rtc$IZZ     
    .rtc$TAA    
    .rtc$TZZ    
  { .xdata  x   .xdata$x        .edata  |    .idata$2    X    .idata$3    p p
  .idata$4     %  .idata$6      pX  .data   p PO  .data$r g &  .bss      hj  .pdata     <   .gfids$y         .tls        .tls$       .tls$ZZZ          _RDATA   0 `   .rsrc$01    `0    .rsrc$02                                         20
 
4 
2p B   R0
 b   
     p  * d 4 p= 
 r    E               Q         2P1	 T 4  p`  = 
    0E     VE             &     
        
 d
 T	 4 2p2  	p`0P= h
   E     E E    E E    E    E    E    E                  X            J                     +"     "     "     #     5$  
 
4 
Rp d	 4 Rp 4 R
p`P @
 E     E    F    F    ,F    <F                 %  %      %     %     %     %     &     
&     4&     J&     q&     &   d T 4 2 T 4 2`% %t !d T 4 
	 
 PF '  (      (  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 Rp 
 `F     lF           .  .      /     "/     3/      w/     /   4 Rp Ȓ
     /   0= 
 J   F     1  B1      _1   0= x
 J        2  22      O2   0= P
 J       2  "3      ?3   0= (
 J       3  4      /4   0=  
 J       4  5      5   d T 4 p ؑ
 F     8  9      9  ,9      9   d T 4 p 
 F     9   :      %:  <:      :   d T 4 p 
     :  0;      5;  L;      ;   d T 4 p `
     ;  @<      E<  \<      <   4 p 8
 F      =  6=      \=   4 p 
     =  =      =   d	 T R( (d $T  4 
p 
  G      A  1A      $ 	0 0  = 
 r  0G     <G `C  C      C     DD  m md
 h4 
rp 4
 rp 
 PG     \G    lG    |G    G     F   G      DG     }G     G     G     G  ! t L  WL  
 !   L  WL  
  h r0 p
 G 0M  zM      M      
4	 
2p(=    * *x h r0 Rp`P0 t d
 4	 R H
 G U  U      V   h d 4
 rp  
 G     @V  V      V   h d 4
 rp 
     `W  W      W   h d 4
 rp Џ
 G      X  X      X   4 
p	`P 
 G Y  Y      ]Z  / 1 	p`0P= 
 r  G     H 0H    <H Z  Z      [     J[     [     & 6 p`0  = X
   PH     \H    hH    tH     \  \      .]     ]     ]     . 47 2 p`P  = 0
   H     H    H ]  L^      ^     ^     ^  & 0 p`0  = 
 r       _  Z_      _     .  4  p`P  = 
    H     H    H 0a  a      a     a     a     Yb      b   h b  +
 +h &4 
p`P 
 H H    H    I     e  2f      f     f     g     g   t 4 P' 't# #d" 4!  P   
  I ,I    8I     i  Yi      j     j     ?k     k    p  !  
T 4 l  <l  p	 ! d <l  l  |	 !   <l  l  |	 !   l  <l  p	 !     T  4 l  <l  p	 " "h 	p`0P h
     m  m      fn     un     n     o  ' 't #d 4  P   @
 PI     @p  p      5q   p! 4 r  r  
 ! d r  r  
 !   r  r  
 !   r  r  
  d
 4	 Rp 
 0t  t      t   4	 
Rp 
 `I     @u  ru      u   4 Rp ȍ
 pI     @v  v      v  *
 *x &h "42 , 
p`P   
 I     I    I    I    I    I           I         v  
w      Fw     tw     }w     x     x     z     z     z     z     z      z  6
 6x h d 4 rp( d 4
 p= x
 J   I I      |  V|      }  }     9~   d 4 2p 0= P
 J         `      o   d T 4
 rp (
  J               8	 'x8 #h9 4v t P  =  
 r  J     J    (J    4J    @J    LJ    XJ    dJ    pJ               X      n               (     \                    r          ׅ     I     W          Ն           	  6	 %x8 !h9 t p0P  = ،
 r  J     J     J    J    J    J    J    J             B     T           
     :     f     ߉          @     ߊ          R     f              4 Rp`P 
 J J    J    K    K 0  i                     ǌ       $
 $T 4 R
	p` 
 0K <K    LK    XK    hK    tK    K      g     {               ύ       0
 !4 
p`P= `
 j   K     K K    K             `  ;      l     ͐      ؐ               [                      Ƒ  R
 R T
 4	 2p`$
 $T 4
 R
	p` 8
 K     K     K 0  b           ѕ     -   4 p`P!  P    x !   P    x ;
 -t7 )d6 %44 . 
P  = 
 b  K K    *L    <L JL    VL                        Ø                           j       ! t Л     
 !   t Л     
 
 d T
 4 2p$ 	 0  = 
               
M    M    M    %M                	   X    pL 8   О          pL     }L    L    L    L    
 
2P 
 "  = 
               M    M    M    M                	   X x   @M 8       p          @M     MM    bM    vM    M    
 
2P 
 , h	 	 0  = 
               N    N    N    N                	   X x    N 8                          N     
N    "N    6N    N    
 
2P 
 
 h 4 R
p`P
 
4 
2p R! t d 4	     $ !" "T
    M  , !     M  , !     T
   M  , !      M  , !     t  d  4	     $  RP!  t 4	   Ǩ   !# #d
  Ǩ     !   Ǩ     !     d
 Ǩ     !    Ǩ     !       t  4	   Ǩ   ! t P    
 ! d   ϫ  T !     ϫ  T !   t P    
 !   t  d P    
 
 
B0P  ! t
 d	   ʭ   !9 9  t
  d	   ʭ   !     t
  d	   ʭ   ! 4	 @     !  t 	d
  4	 @     $ 	 0  = p
            N    N        O    O    O    O    O    O        	       	   xW H   N H             ϴ           n       N     N    2O    FO    VO    `O    O 	    BP0   p
 :
 ,t9 (d8 $47 0 
P  = H
 r  P     P    ,P    <P    LP    \P    lP    xP    P    P 	   P    P    P    P 
   P                      3     B     Q     `          ն          .  	   >  
     	   G     $     M     Z     i       
        ڹ  
             D     f  	        Ⱥ     Һ   	  d* T) 4( & p    
 P   '        $ $d0  T/ 4. * p   
 P P    Q     0  n      ǽ                 - " p`0  = Њ
   ,Q      Q            UQ    aQ    mQ    yQ    Q            S    S     S             $ 	   P`    Q X           P                   Ŀ          3     h     v               C          Z     q           Q    Q 	   Q    .R 
   ?R    R    R     bP0   Њ
 , # p`0= 
   0S            YS    eS    qS    }S    S    S    S         	   U 	   $U 	   0U              	   P`    S X             E      l                         9     b          ^                          S 	   S 
   S 	   >T    OT 	   T    T 	    bP0   
 ) 4  p  = 
            @U    LU     XU    dU        V               	   (    pU 8      Q      y               $                     a        pU     }U    U    U    
 
2P 
 $ 	 0  = X
             V    ,V        V               	   (    8V 8           K                     l  8V     EV    pV    V    
 
2P X
 *
 * x h 
4 
p( d
 4 rp= 0
 2   V             2  7	 &dv "4u p pP  = 
 r   W     W W $W 0W <W    HW TW `W lW 	   xW 
   W    W                  
             )         {            :     H                       	   @  
   t                 
     	      4
 p 
 W                Bp0  !  

 T    P  P! ! d	 P    \! !   P    \! !      P  P!  4 
	p` 
 W     W     W        L      k             d 4 p6 (t3 $d2  40 , P  = 
 R  W W    W    g      u       A     O        4
 p h
     @          
 
4 
 p  ! d     " !       " ) t 4
 	P= @
 J   X X (X 4X @X LX XX            s                            .         ;     I         4	 < 	p`0P  = 
   pX     |X    X    X X    X               X    X X 
   X X                                !     G        A              	          B  
   y       
            2	 $4  p`P  = 
     Y     Y Y    $Y    0Y                c                                              )  p`0P  = Ȉ
    @Y     LY XY    dY pY    |Y    Y Y    Y p                   v       ,     =       (     O                           I     Z     d  +
 +h &4 
p`P 
 Y Y    Y         X     k     *     -  ! !d
 4 R
p x
 Y     Y     P             m      u   4 
R	p` P
  Z     Z         )     U   T 4 p` 4 p`P! h     ' !       ' !      ' !       ' & &d "4  	pP   (
  Z ,Z    8Z    DZ                   L     ]     h  & &d "4  	pP    
                       i     z       4 &d "4  	pP  = ؇
    PZ     \Z    hZ         4     d                \  .  4  p`P  = 
                 .     P           $ .  4  p`P  = 
    Z     Z    Z       >    n             d 
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T   P* !     P* )  p`0P  = `
    Z     Z    Z Z    Z Z    Z         	 /
     S
    
    
         z     ,    =      
    T
          4 
Rp 8
 [     `        d 4
 
Rp 
  [       ^  4 
Rp 
             4 
Rp 
 0[             4 
Rp 
     @ f     z " "h 	p`0P p
           f    u          	p`P0 H
 @[     L[   k              # )  p`0P  =  
    `[     l[    |[    [    [    [    [    [    [         @              )    Y    }        Q                ~        0    A    K    U .  4  p`P  = 
    [     [    [ [     \                   .    Q         %             R .  4  p`P  = Ѕ
                      .    Q         %             R %
 %h t d 4 P"	 "d 4  pP   
 \ \    (\    4\ ! E!     !    !    "    "    " "	 "d 4  pP   
 " #     #    #    Y$    j$    u$ 0	 "d 4  pP  = X
    @\     L\    X\     $ $      %    P%    s%    %     G& .  4  p`P  = 0
     ( z(     (    (    (    Z)     ) .  4  p`P  = 
    p\     |\    \ @+ +     +    +    ,    z,     ,  r04 &h "4/ & 
p`P  = 
   \     \    \ \    \ \ P1 1     1    2    72    2     3 3    3    3    84 4    5  4 
Rp 
     5 5     5  d 4
 
Rp 
  6 p6     6  4 
Rp h
     6 6     6  4 
Rp @
      7 F7     Z7  4 
Rp 
     7 7     7    )	 
	p`P0  = 
 b   \     \    ]    ]     ]    ,]    8]    D]    T]    d] 	   t] 
   ]             P; ;    ;    <    <    )< 	   9< 
   E<    u<    <    <    <     <  
R0 ȃ
 ]     ]  @ 6@     I@    @  4
 
Rp 
 ]     ]    ]    ]     @ @     @    @    'A    5A # 4
 p= x
 J   N @O     NO 6 (4   
p`P  = P
     ^     &^    2^    >^         O "P     P    R    R    bS    oS    yS     S    &T     = ,4A 8 
p`P  = (
   P^     \^     h^    t^    ^    ^    ^    ^         T T     (U    UV     V    V    V    6W    ^W    W    W    W    X    [     4	 
Rp  
 ^      \ @\     \  4	 
Rp ؂
     \ \     ]  4	 
Rp 
      ] `]     ]  4	 
Rp 
     ] 0^     q^  4	 
Rp `
     _ _     `  R0 8
  a +b     Fb  4 Rp 
     Pb b     b  R0 
 b c     &c  4 Rp 
     0c rc     c  
R0 
 ^     ^    ^    ^    ^    _    "_         d d     d    d    d    e    )e    7e    @e =
 +h# &dQ "4P H 
p  = p
 #  @_     L_           X_    d_    p_    |_    _    _    _ 	   _ 
   _    _    _ 
   _    _    _     `    `    `    $`    0`    <`    H`    T`    ``    l`    x`    `    `    `    `    `     ` !   `    `    ` $   `    ` &   a    a (    a )   ,a *   8a    Da ,   Pa    \a .   ha    ta    a    a 2   a    a 4   a 5   a 6   a    a 8   a    a    a ;   b    b =   b    (b ?   4b @   @b A   Lb    Xb C   db    pb E   |b    b    b    b I   b    b K   b L   b M   b    b O   b     c    c    c S   $c T   0c U   <c    Hc    Tc X   `c    lc Z   xc    c \   c    c ^   c        `   c    _   a      < 	   P`    c H       Pe e     e    e    %f    Zf    ef    f    f    2g    g    Mh    h    i    Ki 	   i 
   i    i 
   i 	   i    i    <j    j    j 
   k    6k 
   Dk    k    k    k    l    +l    Tl    bl    pl    l    l    
m    m    m    n    n    /o    No    \o    o    o    p    p    Cp    lp    zp    p    p    q    .q    <q    q    (r    s    [s     s !   s "   s !   s      t    t    [t #   t    u $   Bu %   au $   ou    u &   u '   v &   #v    mv (   v )   v *   v +    w *   Iw )   Ww (   ew    w ,   w -   x ,   x    cx .   x /   x .   x    y 0   Qy    y 1   y    -{ 2   h{ 3   { 2   {    { 4   | 5   Y| 6   h| 7   | 6   | 5   | 4   |    } 8   Z} 9   y} 8   }    *~ :   v~    q ;    <    ;       % =   b >    =       ܀ ?    @   V A   h B    A    @   Ł ?   Ӂ     C   Z D   y C       т E    F   , E   :    t G        H   d     I    J    I   ͅ     K    L    M   ' N   M M   X L   f K   t     O    P   Ɇ O   ׆     Q       8 R   l    I S   ^ T   s U   ~ V    U    T    S   ˈ     W   #    f X   { Y    X       ى Z    [    Z       [ \   p ]    \       Ԋ ^    _    ^       +     6 c     c `   c a   
 
RP p
 9 'h( R 
p`0  = H
 s  c c    d    d     d    ,d    8d    Dd    Pd    \d                  d    d    e    e    #e    /e    ;e    Ge                  e    e    e    f    f    f    &f    2f    >f    Jf    Vf                 "   f #   g     g     g     'g '   3g (   ?g )   Kg                 ,   g -   g     h     h     h 1   (h     4h 3   @h 4   Lh 5   Xh     dh 7       7       9   h :   h 
   
   
      D             D !   !   $      D +   +   .      D 8   8   ;      D 	   P` 8  hd H   	   P` 0  Se H   	   P`   bf H   	   P` (  Wg H   	   P`    ph X     U                                     P         	                   # 
   3    j        1        В        >    L    r            Ó    ߓ        &    <        H        ŕ            6    m            ܖ            -    n      !         %         &        f '    (    )    *    )   I (   W '   e      +        њ /         0        F 1    2    1         3   7 4   t 5    6    5    4    3        ; 7   u 8    7        Ş             hd     ud    d    d 
   Se     `e    e    e    bf     of "   f #   f $   Wg     dg ,   g -   g .   ph     ~h 9   h :   h ;   
 
RP H
  bP0   H
 .  t d 4 	P=  
 J   h h i i  i ,i             P      [ ܠ         ġ      1    > n    { $
 $t d 4
 
rP 
       4 @
 /tE +dD '4B < 
P  = Ѐ
   @i     Li     Xi     di     pi     |i     i     i     i     i     i     i     i             p ɧ    ڧ              a    o                       H    T         ȩ                	   .     l 
   x                        < +tC 'dB #4@ < P  = 
   i     i     i     j     j     j     (j     4j     @j     Lj     Xj                 `          ޫ         E    S     s                  3    ?              ӭ    ߭      	        \ 
   h       4	 
Rp 
 pj     j    j    j     `                    d 4
 
Rp X
 j     j 0 o         ܲ  
R0 0
 j P f        
                       \M 	   P` 8    k H   ` s       k     
k    
 
RP 
 3	 < 	p`0P  = 
   k     `k    lk    xk    k    k       @     P    ^        ۷    2    g        Ƹ         9 (h $4D < 
p`P  = 
   k     k    k    k     l    l 0 {                 Z            ں            2    [     w & 6 p`0  = 
    l     Fl    Rl     ^l     л      @        	     &    B      
R0 h
        
R0 @
 н         d 4  p   
 l     pl    |l       I     _    m             * *d %T  4
 R
p ~
 l     l    l    l    m    m    (m    ;m    Nm                        Y    m                
 0
 "d 4 	pP= ~
 j   pm     |m    m     0 j     t        :           h R0! t
 @  Q !   @  Q  
4 
p(= `    4
 Rp ~
 m m        <    J # #t
 d 4 r x~
               @R @           m X        %     8 m     m     bP0   x~
  4 2! d t  a R !   t  a R !    a R  d 4 2! t `  R !   `  R ! d     !        d 4 
rp P~
               `S @           Pn X       P        Pn     ^n     bP0   P~
  4
 Rp (~
       # F    T  2p! 4 p  S !   p  S  R0  ~
       4 Rp }
     0 O     x  4	 Rp }
             d T 4 2p d
 4	 Rp 4 Rp }
         4	 Rp `}
            G  4
 Rp 8}
     @           #  d 4 
rp }
               U @           n X   @ D     W n     n     bP0   }
 ! d @ X   !   @ X    d 4 
rp |
               $V @            o X    B     U  o     .o     bP0   |
 ! d      !        ! d t @  R !   t @  R !   @  R ! t   R !     R ! d ` x   !   ` x    4 Rp |
   t	 d 4 2 d	 T 4 2p0	 "d 4  pP  = |
    o            ! t @ n 
 !   t @ n 
 0	 "d 4  pP  = p|
                R0 H|
   R
p`0  |
 o     o    o                I        4	 Rp {
 o     p                  (  0  ! t  ( X !    ( X + +d 4 p   BP0  ! t	 P  Y !  

 d  t	 P  Y !   
  t	 P  Y 
 b   {
     @	 M	     	 #	 p
`P0   {
  p 	 *
       d 4 
rp {
               Y @           0p X    M     ` 0p     >p     bP0   {
 " "d
 T 4 
rp X{
 p     p    p   %     I            J ! !d 4
 r
p 0{
               Z @           p X             5 p     p     bP0   0{
  T 4
 2
`! 	 t    ,[ !      ,[ ! 	 t    ,[ !      ,[  4	 Rp {
     P           4	 Rp z
     @! p!     ! 
 b   z
 0&  R0 z
 & &     & >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pP= hz
 b   @q  4 4     6  2p`0 4
 rp @z
 Pq  7 !8     Q8    u8  
4 
p(= H    4	 Rp z
 `q ; ;     < 
 t d
 T	 4 R
 	 T d 4
 Rp 4
 Rp y
     PF F     F F    G  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b   y
     X ! bp`0   y
                                     ^             ^ @           pq 8   @           q H           X X     AY pq     }q    q    q     q    
 
2P y
  BP0   y
 
  ` St
 6 
B`P0   T 4 2`! t ^ C^ _ !   ^ C^ _  4  d T 2p! 4 b b _ !   b b _ !   4 b b _ ! 4 d d _ !   d d _ !   4 d d _ $
 $d  4 r
p xy
 @r Lr                                ` @           Xr 8            g g     g    h    h    h    h    i Xr     er    r     
 
2P xy
 $
 $d  4 r
p Py
 r r                                a @           r 8   @i i     i    j    j    j    j    +k r     r    r     
 
2P Py
 $
 $d  4 r
p (y
 r r                                |b @           r 8   Pk k     l    !l    l    l    m    Gm r     s    "s     
 
2P (y
  T	 4 2! t d @n fn b !   @n fn b / 1 	p`0P=  y
 r   o ao     o    o    !p    *  	p`P0  = x
    0s     <s p p     q    Yq     q 0 6 p`0P  = x
   Ps     ~s s    s    s    s Pr r     r    
s    as    s    s     4 R
p`P x
 s s    s    s    s     t             `t t     t    u    u    Cu    _u    ou  d
 4 
rp `x
 t t                            De @           (t 8           `v v     v    v     w    !w    \w (t     5t    Rt     
 
2P `x
 
    8x
 `t pw w     w " "d T
 4	 
Rp x
 pt     w x      4	 
Rp w
     y .y      4" 	  p   w
 t     t             z Az     dz    ! 	0= w
 r       z {     {  	 0  (=    -	  	p`0P  = pw
    t t    t t         | l}     } }    ~    &~    ~ ~     * " p`0P  = Hw
   t t    u u     u  u    ,u    8u           `     {     5    N [    i         B    f     0 6 p`0P  =  w
    C     b            D    o    ' 
 p`0  = v
                  M      = ,4B 8 
p`P  = v
   Pu     ~u    u u    u    u    u         @      2    p            V         0 6 p`0P  = v
    D     c            D    o    
    v
               j @           u H               
 
RP v
 
    Xv
               |j @           u H   Ѝ ݍ            
 
RP Xv
 
    0v
               j @           v H         > @     
 
RP 0v
 
    v
               Lk @           0v H   P ]     ~      
 
RP v
 
    u
               k @           Pv H               
 
RP u
 
    u
               l @           pv H   Ў ݎ            
 
RP u
 
    u
               l @           v H         > @     
 
RP u
 
    hu
               l @           v H   P ]     ~      
 
RP hu
 
    @u
               Tm @           v H               
 
RP @u
 
    u
               m @           v H   Џ ݏ            
 
RP u
 
    t
               $n @           w H         > @     
 
RP t
 
    t
               n @           0w H   P ]     ~      
 
RP t
 
    t
               n @           Pw H               
 
RP t
 $ $d  T 4 
p xt
      b      F 5u 0xv ,hw  
	p`0P= Pt
 B  pw     |w    w    w    w    w    w    w    w    w 	   w 	   w    x    x 
    x    ,x    8x    Dx    Px    \x    hx    tx    x    x    x    x    x    x    x    x    x    x    x    x !   y "   y         ` e     p    }            
    Z     	   
 
     	   S    }     
       [ 
   u            Ӛ        (    =    ߛ    D    n    ӝ    ڢ    ?    ҧ            R    o    d    t                    ë    $    V                Ӭ        ׭     +     !   9 "   ʯ #    "   9 !   Y         	       /    I    V    c % %h !t d 4 
	 (t
          y    ,y                   s 	   P` P   8y H                ѱ         1    F    E      8y     Ey    
 
RP (t
 % %h !t d 4 
	  t
         `y    ly                  s 	   P` P   xy H                !     6                  xy     y    
 
RP  t
 ) )h %t !d 4 
	 s
 y     y                             t    P` P   y H               @          6         ȸ y     y    
 
RP s
 ) )h %t !d 4 
	 s
 y     y                             u    P` P   y H       p      E    f     һ     y     z    
 
RP s
 O =% 8& 3' .x( *h) &d\ "4[ T 
p  = s
 K   z ,z 8z    Dz    Pz    \z    hz    tz           z 	   z    z    z    z 
   z           z             v 	   P`    z 8        ~           D    n                ;                ( H    \     	    
    	       K        ; 
        
           C    n             	    0 z     z    z    
 
2P s
 ' d 4 p= `s
 Z    {     &{                    ! 
	p`0P 8s
 L{     @{    u{    {    {    {     0 W     j            T                        v      d 4
 2
p! T	 0   y !   0   y & 4 p= s
 j   {     {   t              ,  4 rp`P r
  | `      M  d
 4 rp r
 | p      a  
4 
p(= @   ! 4 `  $
 !   `  $
 !   4 `  $
 	 	2`0! 
 t	 T   dz !     dz !   
  t	  T   dz  
R0 r
  |       _  d 4
 
Rp pr
 p        d T
 4	 Rp Hr
      D     o        4 Rp  r
       .     I 9	 (4A 8 p`P  = q
   P|     ~|    | |    |    |    |      7     S                $    Q    m 9	 (4A 8 p`P  = q
        +     G                    A    ] . 4  p`P  = q
    |     |  _          . 4  p`P  = q
               # p`0= Xq
 z   |     |  q          + 4 p`P= 0q
 z        z          . 4  p`P  = q
                R0 p
   G     b &  p`0  = p
         
     9    W  
  p
 }         R0 hp
 @}   A     P  R0 @p
 p        R0 p
  7     R # #t
 d 4 r o
               H @           `} X        %     8 `}     n}     bP0   o
  d 4  p   o
 }     }    ~ } 0 s                   4 R
p o
 0~     ^~    p~               H      4 Rp xo
                Po
 ~        " "d 4	 Rp (o
 ~     ~  T     b      t T
 4	 R`2	  d 4  p  =  o
                  T @           ~ H     b     7 ~     ~     BP0    o
 f
 fd <t 	 4 2% %4 p` n
                @            X                        bP0   n
 ' 7 p`P0= n
   P          k         6
 ] 
	p`0P= n
   P     ~                              	                  v                     -    b            J 	    
   : : &  x 	h   / 1 	p`0P= `n
 r        q                1      h 0!  x  T ؃ !     T ؃ !     x  T ؃ 6
 ] 
	p`0P= 8n
   
 &     E    }                    s         	   L
 
   / 1 	p`0P= n
 r  
 
          :        ] ] U  
	p`0P! h
     !           m
       . 7 p`0P= m
         z             +    x        = ,4e Z 
p`P  = m
   0     ^    p ~            ǀ    ـ         	    
                      C    Z                ?    [     	   G 
        &
 &d
 !T 4 R
p pm
     G      / 1 	p`0P= Hm
 r                 A    , ,4)  
p`P    m
 0     <    f    r    ~                      	                                    %                        L    [         	    
   1    H    b                $      }  
                  , ,4)  
p`P   l
           6    B    N             Z    f    r 	                                _!     u!    !    "    -"    C"    `"    "    "    #     # 	   6# 
   #    #    #    #    $    ?$    t$     $ 
   $     $ %    % = ,4= 2 
p`P  = l
   Ђ     ܂    
         *    6 @% %     $&    A&    &    &    '    (    (     (    ( 6 (4   
p`P  = l
    P     \    h P) R*     z*    *    *    7+     `+  
0 l
       + +     +    
,     L :c 2d -e (xf $hg  
p`0  = Xl
 #       ̃           ؃           х    ݅                
 
       %    1 
   =    I    U    a       	      \ 	   P`     h   @, `-     -    -    -    -    . 
   W.    .    30    0 
   0    {1 
   1    2    2    E3    S3    4    (4    J4 
   4    4     4          &    >                    D    U     	             P0   Xl
 A 0x ,h (4<2
p`P  = 0l
 b	  p     |                        ˆ    ׆         
                   +    7    C    O    [    g    s                 05 #6     R6    _6    s6    6    6    O7    Y7    7    *8    ]8 	   9    T: 
   a:    ; 
   ;    ;    ;    }< 
   Z@    @    .A    UA    bA    B    *B    vB    B    1C    KC    C    C    C    C    D    #D    1D    >D    KD    D    D    D    D     D A 0x ,h (4@6
p`P  = l
 	                       Ӈ    ߇                 
       '    3    ?    K    W    c    o    {             PE CF     rF    F    F    F    F    oG    yG     H    ]H    H 	   1J    J 
   J    6K 
   PK    K    K    L 
   P    Q    ^Q    Q    Q    @R    ZR    R    R    aS    {S    S    S    
T    T    <T    ST    aT    nT    {T    T    T    T     U     )U / /h +/ 't. #d- 4, ( P   k
          Ȉ    Ԉ                 U 9V     yV    V    V    V    RW    `W    W    .Y    =Y    GY    UY     Y "	 "d( T' 4& $ p   k
   Z <Z     [ "	 "d. T- 4, * p   k
   @[ |[     \ "	 "d( T' 4& $ p   hk
 \ ,]     ^ "	 "d. T- 4, * p   @k
 0^ l^     _ #	 #t3 d2 41 . P   k
 0     <    H    T _ `     a    va    a    Zb    b     b 1
 1x -h )tC %dB !4A > P   j
 `     l    x             b c     d    zd    e    f    [f     vf "	 "d( T' 4& $ p   j
 f f     g "	 "d. T- 4, * p   j
 g h     hi "	 "d( T' 4& $ p   xj
 i i     j "	 "d. T- 4, * p   Pj
 j k     Xl #	 #d4 43 . pP   (j
               l km     m    n    =n    n    8o     So 0
 0x ,h (dB $4A < pP    j
      ̉    ؉             po np     p    q    q    r    r     s 7
 )h %42 ( 
p`P  = i
 "                        ,     0s t     Gt    Ut    zt    v    v    9w    w    w    x     %x 7
 )h %42 ( 
p`P  = i
 "      `x My     wy    y    y    ?{    {    i|    |    |    ;}     U} <
 *hA &d "4  
p  = i
   @ L X           d    p    |             	    
       Ċ 	   Њ 
   ܊ 	        	                $    0    <           r             x 	   P`   H 8       } ~     8~ a~    y~ ~    	        B            2    Q    _    { 	   P 
           %    3 
   A 	    
   υ    D 	       Æ         	       ,    c        щ        3    A    O    ]    k     	   ݋        5    Q    | H     U    b    
 
2P i
 <
 *hA &d "4  
p  = `i
                                   ȋ    ԋ 	    
        	    
    	       ( 	   4    @    L    X    d    p                        ( 	   P`   | 8        g          ̍     d    V    f            ʑ     	    
       .         
    	    
   ?     	       3    R    ` 	           ӗ    
    A    x                ͙    ۙ    + 	   M    v             |             
 
2P `i
 # p`0= 8i
 z        ̌ @      ʛ         c  4 2p!
 
d T p   !   p   !   d  T p   $ Rp`0 i
                @            8   @      Ӟ          
 
2P i
 $ Rp`0 h
                @            8        >     s          
 
2P h
  2
p!
 
d 4   H !     H !   d  4   H !
 
d 4 @ N H !   @ N H !   d  4 @ N H !
 
d 4   H !     H !   d  4   H  R
p`0 h
         @                  P @           \ 8       `                \     i    
 
2P h
 !
 
d T  Ӣ  !    Ӣ  !   d  T  Ӣ  / 1 	p`0P= h
 r  У 1     P            = ,4< 2 
p`P  = ph
             ̍    ؍ P ˥         #    j        	 t d T 4    d 4 
p  !
 
 T  H С !    H С     zx dh &% p`P0!  
  `  !  	 	
 `  8 !   `  8 !    `   	  0   Hh
                    6     ]     
R0  h
  I       d 4
 
Rp g
       K  
R0 g
         
R0 g
 0 i      9	 (4A 8 p`P  = g
               P          A    U                 =
 ,hP (4  
p`P  = Xg
        (    4    @    L    X    d    p     	           ͎    َ 
    
                P      7         	    v                B                 	   * 
   =             
   g     
        
                       4 4 &d  "4  	pP  = 0g
                  $ 0    <    H    T `    l x 
                  4    `                              4    > n     	         
       . 
   8 =
 ,hP (4  
p`P  = g
               p      W         )                ;    b                 	   J 
   ]             
       = 
        
                   8    T 
 
d	 
Rp! 4     !       .  t d 4 	P= f
 J      0      1     ]      < < 7x
 3h /t' +d& '4$  
P   f
       `     K , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t  - 8 !    - 8  d 4 p f
 Џ @ t      	 	 0      d 4 p h d
 4	 Rp.  t d 4 	P= hf
 J                       B         * Z    g      ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P   @f
       ,    8    D    P    \    h    t                                           J         	   G                    "    J    i      / / *x &h % 
	p`0P f
             :     ?    ;     F / / *x &h % 
	p`0P e
                      0 e
 @ t       R0 e
 0 Q     `  R0 xe
         0 Pe
   T       R0 (e
  1     @  R0  e
 `        
  d
   4       R0 d
         R0 d
  Q     l  0(= `   ! t    !      &  p`0  = `d
    P           # p`0= 8d
 z   @           " "d 4	 Rp d
           @     c
 P       { j5 b6 Z7 R8 J9 B: :; 2< -x= )h>  
	p`0P= c
 B       ̐    ؐ                       , 8 
   D    P    \    h    t                            ȑ    ԑ                   
    M    ~         #         1    d               	   4     A  _  
   q          *! 
   ;!    z!    !    !    !    -"    a"    n"    "    "    #    #    7#    $    &    <)    M)    )    )    )    )    @*    Q*    *    *    *    	+ 
   + <
 *xC %hD  
p`0  = c
 +                $ 0            S    _    k 	   w          
                     ۓ                                  ?    K    W    c    o    {                   
                                0 	   (   < X   	   (    X   	   (     X               + ;,     |,    ,    ,    -     - 5.    G. .     / /    */    / 
   0    H0 
   V0    d0    }0    0    0    1    a1    r1    1    1    ,2    82    U2    x2    2    2    3    3    3    4    4    4    4    5     
5    e5    5    5    6    <6    Y6 <     I             	   , 
            ͓     $    1     
 
rP c
 { j8 b9 Z: R; J< B= :> 2? -x@ )hA  
	p`0P= pc
 r           Ȕ    Ԕ                   ( 
   4    @    L    X    d    p    |                        ĕ    Е    ܕ     6 7     7    
8    >8    j8     8 v9    9    9    $:    P:    ]: :    : 	   :    ; ; 
   1;    ;    ; 
   ;    :<    K<    <    <    <    !=    .=    I=    =    =    =    =    m?    A    D    D    UD    fD    sD    D    	E    E    VE    gE    E    E 
   E <
 *xG %hH  
p`0  = Hc
 c                             C    O    [ 	   g s         
                     ˗    ח                              /    ;    G    S    _    k    w               
      H             \             p 	   ( H  , X   	   ( P   X   	   ( X   X               `F F     <G    yG    G    G     \H H    I I    I I    I    J 
   J    K 
   K    $K    =K    K    K    K    !L    2L    OL    L    L    L    M    8M    LM    M    QN    cN    uN    N    LO    ^O    pO    O     O    %P    \P    P    P    P    Q ,     9    p         	    
                     !     
 
rP Hc
   
p`0    c
                	   P` 8    H   @R `R     R          Ҙ     
 
RP  c
  0. h 42 . p  = b
 R        @U U     U    U     %V = = 8 3x /h +4> 8 p`P   b
           $    0    <    H    T     pV Y     Y    Z    Z    X[    t[    \    %]    ^    ^    ^    ^    _  p`0 b
               X @           ` 8       @_ _     *` `     m    
 
2P b
  4
 
Rp b
                  Й                    @` h`     p`    x`    `    `    `    `    a  0+
 +t# 'd" #4!  
P   Xb
  b Rb     f 4 4 /	 *x
 &h "d 4  pP   0b
   `f g     g  d 4 p b
 0 i i     j > > 9 4x 0h ,5 (t4 $d3  42 . P   a
 @     L     X j k     m    m    n     
o  4	 Rp a
 p          Po o     o    o  4	 Rp a
      ښ      p Ap     Op    p " "d 4	 Rp ha
       p p     q    Pq ' 'x h 	   4 r
p`P!  r >s  !   r >s  ! h 
t t  !   
t t  ( (h $d  T 4 
p @a
 pu u     Zw +  	p`0P= a
    0     <    H T    `    l w Ox     tx    x    x    1y     y z    Cz    tz    z    {    p{ D 2# -$ (x% $h& N 
p`0  = `
 +                  ɛ    ۛ                
 	              h    t 
           
          	   (    % X               | |     |    `}    }    }    }    ~        B     	    
               k     %     3         
       .    Y      bP0   `
 +  	p`0P= `
                 o         ł        Q      <    c            &     D 2# -$ (x% $h& N 
p`0  = `
 +                          	        !    - 	   9                
           
          	   (    E X               0      Ն            ·        =    !    b     	    
   !                 E     S        ֞ 
   
    N    y      bP0   `
 & 4 p`P= x`
 J   0       )    7     ƍ G    U ӎ     
 t	 d T 4 2
 
4 
2`! t @ U p !   @ U p     P`
 0        t d 4 P! t  % 
 !    % 
 ( (h $d  4 
p (`
               8 	   P` 8    X        )     N      Ο          bP0   (`
 ! t  Ș 
 !    Ș 
      `
 `      ș  4 R
p`P _
   ,    8    D    T    `     0 o         ؚ            $    ; 	 	2P0! 
 t	 d P g p !   P g p  4	 2`! t  C  !    C  / 1 	p`0P= _
 r             Z        !  x    ؃ !       ؃ !     x    ؃ )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '   p ~  ! h	 ~   !   ~   !   p ~  * 0 p`0P  = _
 r       	     (    b    ̮    = = *  x h   * 0 p`0P  = `_
 r       	     (    b    ̱    % %4) %  p`P  !& & 
 x h 0   !   0   !     
  x  h 0      8_
 p           !     0 0h ,4  p
`P _
                      ̠            7     F    ~        2    Ϻ    ݺ                      <
 *x %h 
p`0  = ^
            %    1    =    I    z                       
   q    }     
       ΢                  t                    ʥ    ֥                              Ѧ    ݦ                
 #    $   % $   1 $   =    I    U )   a 	   	                                   $ 	   P`     X      (   ڢ X      P`     X   	   P`    X           м &                 '    T    w         	               =    ` 
           x                .    r                                            ?     Q     !                       4    v "        #    $    %    $    &    $   4 '   F $   T #   p                              (        )    *    )                 
   J    [ 
   ڢ         ^    o        ã    G    X    e             -                              bP0   ^
 B 1xS -hT )4  
p`P  = ^
 "  p     |                        ħ    Ч    ܧ 	    	       %    7 	   E    Q               S    p                K            @    Q            o 	    
    	            
       r         	       )    C    _     y Q ?* :+ 5, 0x- +h. &df "4e ^ 
p  = ^
   `                   l           x                    	    
    	       ̨ 
   ب                                           ,    8    D            z              	   P`    P 8                K            e    z        ]    r     	   ( 
   _    ~ 
    	       { 
       &    ?    M 
   [                #    B    {                             ,    :    H         	                G P     ]    j    
 
2P ^
 @ @
 ; 6x 2h ## p`0 p^
                      ̩    ة                               P`     H                     )    e        	    (            X    d    p      `            [                 e               
 
RP p^
  d 4
 rp H^
   D       T 4 	p`  ^
       ,    8                   N          D Dx @h <4> /6 !p`P   ]
 P                      &    d    y          $ $h d> 4= 8 p   ]
      ̪    ت                                    	   (                                 b        ?    #                             
 
P ]
 :
 (x* $h+ X 
p`0  = ]
         ,    8                  _    k    w              	   (   D         P     ~            x                    )     K O    [     } D     
 
P ]
 $ $h d< 4; 6 p   ]
                            ϫ    ۫              	   (                                 Z        ,        u                         
 
P ]
 :
 (x( $h) T 
p`0  = X]
 {                             /    ;    G              	   ( p             @     n    w        B            L                  (     J      
 
P X]
 : : 5h 142 %( p`P   0]
 ` l    x x                           =    	 <
 * %h 0 
p`0  = ]
 S             x                           	   P` (                  `	 	     
 
        !              լ        K    \    i      P0   ]
 . .x )h $t?  d> 4= 8 	   \
      ̭    ح                                    	   (       p z             0                I    U     w {               
 
P \
 :
 (x* $h+ X 
p`0  = \
         ,    8                  _    k    w              	   (   D         ,     Z    k        T            X             $ (    4     V D     
 
P \
 )
 )x $h d> 4= 8 p   \
                            Ϯ    ۮ             $ 	   (                             <                J    V     x |               
 
P \
 :
 (x( $h) T 
p`0  = h\
 {                             /    ;    G             H 	   ( p           ,     Z    c        /    f        7!    !    !     " "    "     5"      
 
P h\
 <
 * %h 0 
p`0  = @\
 S             H    T ` l    x x               p 	   P` (  `                p" #     # 
$    $    1%    !' `     n                ,    9      P0   @\
 # p`0= \
 z       ' '     
(    G(     ( )  p`0P  = [
                       @) )     )    )    )    d*     * W+    u+ ! t + + p !   + + p  t d
 T	 4 2 T r
p! h 
d
 4 . . ( !   . . ( ! h 
d
 4 / / ( !   / / ( Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P   [
           P2 3     R5    Z5     t6 * , p`0  = [
 [  а                                 P` P  ܰ H   6 .7    Z7     7 ܰ          BP0   [
 @
 .x/ )h0 b 
p	`0  = x[
   0     <    H T    `    l x          	    	           ̱ 
   ر 
                                 Ĳ    в    ܲ                  	   P`    H            8 8     
9    K9    z9    9     v: ;    F;    ;    ;    5<    < <    =    =    b> 	   r> 
   B?    R?    "@ 
   /@    A    A    A    B    B    B    B    D    D    TH 
   `H    oH 	   ~H    H      !    O    c    w             
 
RP x[
 + +h ' #t d 4 P P[
        H I     J    J     gK @
 .x+ )h, Z 
p	`0  = ([
         ,    8 D    P    \ h t         	    	            
   ȳ 
   Գ                                  ƴ    Ҵ    ޴              	   P`    H                L L     L    %M    TM    M     PN N     O    aO    O    P    P P    Q    Q    R 	   R 
   S    S    T 
   T    bU    V    %V    V    ,W    GW    UW    Y    Y    ] 
   ]    *] 	   6]    B]          E    Y    m             
 
RP ([
     [
      ] ]      R0 Z
   ] h^     ^  
R0 Z
 0 ^ 	_     O_  d 4
 
Rp Z
 `_ _     `  4	 
Rp `Z
 `     c oc     c  
R0 8Z
 c d     _d  d 4
 
Rp Z
 pd d     e  4 Rp Y
     pe e     e  4 Rp Y
     0f ^f     yf  
  Y
 f f     3g  R0 pY
 Pg qg     g  R0 HY
 g h     h  R0  Y
 @h gh     h * T 4 p`= X
 Z    p        |                 h i     i    Vi    Hj    Sj     wj * T 4 p`= X
 Z   j k     k    [k    Ml    Xl     |l 
 
t 4 # #t d
 4	 R X
 @o o     Ep &
 &d
 !T 4
 R
p X
  `p p     / /x +h	 'T #4  
	p`   XX
      r 5s     t &
 &d
 !T 4
 R
p 0X
  u /u     = / *x &h % 
	p`0P= X
    е Pw w     y    T 4
 
R	p` W
      z Iz      d
 T r! x h 
t 4
 0} N}  !   0} N}     4  p`P   W
      } ~     ~  h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P   W
      ǃ     ؃            
    8    _        
     	   G            "    -    8    `             T 4
 
R	p` hW
      9     #
 #h d T 4 p @W
         U     t        ݏ     "	 "T 4  	p`   W
             U       
 (=    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P   V
              G     X    f    w            ߖ            ? 	   ɜ                                 )  
  V
 0  Ğ       R0 V
 ` 0 Q     `  R0 xV
         R0 PV
   G     b &  p`0  = (V
         
     <    Z J J B
 = 8 3x /h +t- 'd, #4+ $ 
P    V
        " "d 4	 Rp U
  ĥ     ҥ      	 	B  ! 4   9 S !     9 S " "d 4	 Rp U
            T     b     / /h
 + 't #d 4  P   U
  ̶    ض       `     }             S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P   `U
            0 . h 42 . p  = 8U
 R   ߵ         %      = = 8 3x /h +4> 8 p`P   U
           $    0    <    H    T     ж      4    T                Z    e    V    
        7    B V H @ 8 3 .x *h &44 * 
p`P  = T
     ^      . h 42 . p  = T
 R  @               ( = = 8 3x /h +4> 8 p`P   T
     p                  8    T                             " "d 4	 Rp pT
 `        d     r      t d 4 	 4H @ 
p`P  ! G P   !   P   3	 %46 0 p`P  = HT
 z               ķ    з    ܷ                              m    |    6 (t/ $d.  4, ( P  =  T
 :                             1             h R00	 0 & x 	h   !    d !     d !      d / / & x h 4 p!  P   !   P   !    P   8 8 & x h 4 p"
 "4 
p	`P S
   ,     `           R R J B
 = 8x 4h 04- !" p`P   S
 @     L    \    l    |                                                            b        d     Q ?* :+ 5, 0x- +h. &df "4e ^ 
p  = S
                          ȸ           Ը                	    
    	        
   (    4                  @    L    X    d    p    |                    ʹ              	   P`     8       0     1    F                        g 	    
   *    N 
   \ 	   x    K 
                  
   +                             K                                
        e     	                              
 
2P S
 2 2 -x )h %t !d T 4 
	 S
        0 0x ,h (d $T  4  
p   XS
       p 	     5	    l
     
 3	 !4= 6 	p`  = 0S
                                            @ 	   P` x   $ h                     v
    
    
        3     8    T     ` $     2    ʺ    ܺ          P0   0S
 <
 * %h 0 
p`0  = S
 S                       ( (               l 	   P` (       A     ! J        q    d          U    m    ˻    ܻ          P0   S
 <
 * %h 0 
p`0  = R
 S             (    4 @ L    X X                	   P` (  @             Q     1 Z    '        t @     N                          P0   R
 <
 * %h 0 
p`0  = R
 S             X    d p |                     	   P` (  p             a     A j    7         p     ~        ͽ    +    <    I      P0   R
 <
 * %h 0 
p`0  = R
 S                                        	   P` (               q     Q z    G          "                  [    l    y      P0   R
 " "4
 rp hR
                @           п X   " #     # п     ޿     bP0   hR
 " "4
 rp @R
                @           @ X   # ($     >$ @     N     bP0   @R
 +  	p`0P= R
                              	       
                     	                            	                                        P$ $      % 3%    G% w%    % %    %    &    /& _&    &    &    & 9 +x
 'h  
	p`0P= Q
      ( 4 @    L    X d    p    | 	       
                     	                                 `' '     ( f(    z( (    ( (    !)    H)    i)    }) )    )    ) 	   *    $*    .* g*    	+ F+    V+ 3
 %h  	p`0P= Q
                              	       
                     	                            	                                        + ,     H, {,    , ,    , -    7-    ^-    - -    -    .    . 8 *h
  
	p`0P= Q
      ( 4 @ L    X    d               	       
       p    | . //     l/ /    / /    0 A0    U0 0    0    0    @1    J1    T1 k1    1 
   R2    k2 2    2 9 +x 'h % 
	p`0P= xQ
                                	       
            2 p3     3 4    4 I4    ]4 4    4 4    4    5    ~5    5    5 5    6 6    6  R
p`0 PQ
                            ( @            8        7 H7     R7    c7     r7      )    
 
2P PQ
  R
p`0 (Q
         @                   @           \ 8       7 7     7    7     7 \     i    
 
2P (Q
 % % !t d 4 
	  Q
               ` @            X       P8 8     : :          RpP0  Q
  R
p`0 P
                            @            8   ; @;     N;    ;          
 
2P P
 % % !t d 4 
	 P
                @             X       ; ;     #> I>          RpP0 P
    4 Rp` P
         @                   @           \ 8       p> >     >    >     > \     i    
 
2P P
  4 Rp `P
                            @            8       ? :?     H?    V?          
 
2P `P
  4 Rp 8P
                           P @            8       p? ?     ?    ?          
 
2P 8P
  T 2`! 	 t 4 ? ?  !   ? ?   d 2p! T 4  A :A  !    A :A  ! T 4 PB jB  !   PB jB  /	 !h 4   p`P  = P
              $ 0    <    H T `         @C C     C +D    mD    D    D 7E    yE    E    E CF    XF F    F ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P   T 4 p`!    O ^O p !    O ^O p 
 d T 4 p!  Q  R  !   Q  R   h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
p O
         p     |                       	   P`      8       pW W     W    W    %X    7X    >Y     HY          
 
2P O
  4& $ p   O
                                 L 	         8   pY Y     Y    Z    mZ     yZ Z     Z      
 
2P O
  d	 4 RpY Yh  0  ' 'h "d T 4
 
rp O
     0^ _     _ ' 'h "d T 4
 
rp pO
     _ 'a     Ma #
 #h t
 d 4 r HO
 a Hb     rb " "d 4	 Rp  O
 d $e     2e    e " "d 4	 Rp N
 e e     e    @f " - 	p`(= @  !C
 Ch 8, &4 T3 42 h h   !   h h   	 d T 4  p   N
               l Fl     l    l    m    m     n    T
 4 
R	p` N
   ,     n n     @o    Po )  	p`0P(=   !/
 /< &x= h> ~ Ԉ po p  !   po p  ! 
  <  x=  h>  ~  Ԉ po p  3	 %49 0 p`P  = N
 z  0{ {     {    "|    >}    ~    ~     4* 	( p   XN
 @ ~      W !    d !     d !      d  x h 
-  0N
 P     \    h                P +     - Æ     ֆ        # <      k 
	`P!*
 *2 x3 h4 tj 4s `   !   `    4
 
Rp N
               @ @            8             ގ          
 
2P N
  4
 
Rp M
                @            8             >          
 
2P M
 1	 #h
  p`0P  = M
                (    4    @        	       
                     
                                                             P Ǐ      7    K {                 3 c            ő 7
 )x
 %h !4!  
p`P  = M
    P \ h t                         	       
                     
                         P ̒      O    c      ד    	    0    Q    e                      2 $x
  h  	p`0P  = hM
                                 	       
                     
                                                  h      ؖ         0 `            ܗ     3    d    n ; -x )h
 %4'  
p`P  = @M
    0 < H T `    l    x                      	             y      	     M    a      ՚        #             ޛ            ќ 6
 (x $h
  
	p`0P  = M
                                 	       
                  0       @    T      Ȟ        "    C s            &    0    : ! t  / 
 !    / 
 $
 $d  4 r
p L
               " @            X        
          RpP0 L
 ! t   
 !     
 $
 $d  4 r
p L
               ,# @           P X    ݨ     _     RpP0 L
  
p`0   L
                           # @            H             A    Z                2pP0 L
  `  ! T   $ ! t 4  T   $ !   t  T  4   $    ! 4  @ T h$ !   @ T h$ ! 4   Ѯ h$ !    Ѯ h$ !
 
t d   ( X !     ( X !
 
t  4 `  h$ !   `  h$ !
 
t d @ h X !   @ h X . .4= 4 
p`P   xL
       5      UeDx  =h! 6tL /dK (4J cD 
P= PL
              t ! 4   $
 !     $
 !   4   $
  
R0 (L
 P        d 4
 
Rp  L
  .       
R0 K
       ?  d 4
 
Rp K
 P        4 Rp K
     `        4 Rp `K
       N     i  d 4
 
Rp 8K
       ' & 4 p= K
 z    y          . 4  p`P  = J
              	 - d 4  p  = J
    0          A . 4  p`P  = J
    p (     W    } &  p`0  = pJ
         $     S    q  
  HJ
       C  R0  J
 `        R0 I
       ,  R0 I
 P w       
  I
       3  R0 I
 P q       R0 XI
         R0 0I
 @ g      s st 
 ! 4  : ) !    : ) " "d 4	 Rp I
       J  T     b     " "d 4	 Rp H
 `            "    p Pe?h 841 &c!& p`P= H
               ' 'd #T 4  
p   H
               X     t    Z } }  x 0! h  ] 0+ !    ] 0+ 3	 %40 ( p`P  = hH
 :                5    D     @ `0P  ! I H tF p  + !   p  + !   I  H  tF p  +  "p0  !    d T
   , !     ,  d 4 p! t d 4   $
 !     $
  4* 	( p   @H
   3     w = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x @  4- !   @  4- * * h  !  ` J p- !   x J  - !   J  - !   ` J p- @
 @ , "   ! x 0  - !   ) - ! h )  - !   )  - !    ) - !   0  - 9 9 !x 
 !  h  E T. !  E   d. !     |. !      |. !   E   d. !    E T. 9 9 &x h 
  !    . !    . !     . !     .   0  ' 7 p`P0= H
    8             >    m ' 't #d 4 
P G
                          +  d Rp! T	 p  / ! h 
 4   / !     / !   p  / /
 /t" +d! '4   
P   G
     P      S )
 )h
 $t  d T 4     G
   E      ! T    !       d
 T	 4 Rp xG
        -     I !" "t  d 
T 4   G h$ !     G h$ ! t  
d 4     h$ !       h$ !" "t  d 
T 4 `" " h$ !   `" " h$  Bp
`  !$
 $  
 
T	 4  $ $ 1 !    $ $ 1 ! t  
d 4 $ $ h$ !   $ $ h$ 6
 3 
	p`0P= PG
        & t&     &    &    '    g'    6
 3 
	p`0P= (G
       ' (     !(    Y(    (    (     2pP!
     
d 4	 ) N) 2 !   ) N) 2   P!   t d 4 + ,  3 !   + ,  3  
R0  G
 - -     /.  d 4
 
Rp F
 @. .     .  4 Rp F
     / /     / . 4  p`P  = F
    p5 $6     S6    y6  @ 
	`P  ! > t? 4F 6 6  4 !   6 6  4  " P   R0 `F
     `9 9     9  
  8F
 9 9     C:  R0 F
 `: :     :  R0 E
 : ;     ,;  R0 E
 P; w;     ; " "d 4	 Rp E
 ; ;     <    P< " "d 4	 Rp pE
 p< <     <    =  4 Rp HE
     0= ^=     y= " "d 4	 Rp  E
       * = =     >    P> IE;h 7t! 0d  )4 C 
P= D
    @ L p> >      ?    @ W
 Wx 8h  4J B 
p	`P  ! I @ GA 6 !   @ GA 6 U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4   L %L h$ !    L %L h$ !  t d pN N X !   pN N X !  t d O O X !   O O X  p  ! 4 R R 7 !' '  d R S 7 !   R S 7 !   R R 7  . `P  !p ph :* /+ $, t- 44 PT ~T ,8 !   h  *  +  ,  t-  44 PT ~T ,8  
R0 D
     V 	W     OW  d 4
 
Rp D
 `W W     X  d 4
 
Rp D
 `     l  X pX     X    X  d 4
 
Rp XD
       X  Y     Y    $Y  
  0D
 [ [     \  R0 D
 0\ Q\     `\  R0 C
 \ \     \  T 4 `  ! t  ] {] 9 !    ] {] 9 " "d 4	 Rp C
     ^ ^     ^     _ " "d 4	 Rp C
       @_ _     _    _ Pe?h 841 &c!& p`P= hC
        ` a     9d 3	 %49 0 p`P  = @C
 z                                   d e     Ge    re    f    g    h    0
E"h t d 4 C
P  (= `   /
 /t" +d! '4   
P   C
 m m     n /
 /t" +d! '4   
P   B
 o p     p O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4 p{ { h$ !   p{ { h$ ! t  d 
T 4 } =} h$ !   } =} h$ " "4 
p	`P B
   9     C Ne=h 6t< /d; (4: c4 
P= B
   0     <  d         ?     V  	  h d 4  p   xB
 P  7     k  t d 4  t T 4 ! d P  = !   P  = " "d 4	 Rp PB
     `            
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h   ō p> !     ō p> 	 	2p0!  
d	 T P q > ! 
 q  > !   q  > !   P q > !" "t  d 
T 4   h$ !     h$  T `  !
 
t 4   < \? !     < \? ! t   p !     p 9 9 "% p`P0!{ {	 m
 X I =
 1   x h  5 ? !    5 ? !   	  
      
      x  h  5 ? 
 
0!,
 ,  ( t d T 0 z H@ !   0 z H@ <5.h *t #d 4 3
P  = (B
 R   `           ) )d: %49 2 	pP    B
 p             d 4
 rp A
       ޼     -	%t d
 4 #P  = A
 B                , ,1 pP!I Ih :+ ', #- . 
d/ 40 0 \ A !   0 \ A L L 7 " p`P0!| | g C 9 	 x
 h `  A !   `  A 1
 1h -4# ! p
`P   A
           P          *         p
 ph hd+   
p0P  !  t d   X !     X !d d	 [
 O B 9
 0 $ x h   ? !     ? !   	  
      
      x  h   ? ! !dK !4J !B pP  ! h  I   C !   h    C !     C '
 'tK 'dJ '4I 'B P  !* * ! x h   R C !    R C !  t d   X !     X      T 4 
R	p` `A
      H       T p  !
 
d 4  - D !    - D /
 /t0 +d/ '4. ( 
P   8A
      N     ) /
 /t0 +d/ '4. ( 
P   A
         9 
0P! 5 6 t7 d8 P  PE !   P  PE !   6  t7  d8 P  PE  	  h
 d 4  p   @
     0        BE1h *+ #* d) 4( C	& P(=      ! t d 4  H F !    H F  d
 T	 4 Rp  8
 Y
     
    	 "           P  
 
4
 
rP t	 d 4 2     $       d 4 2p           	 4 rp`    A    	 	b   rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!    tG !. . 	  )  G !	 	 )  W  G !   )  W  G !    )  G != =2 *3 4 4= i# # H !     tG  20 R0
 
4 
2p 20%	 4- $ 
p`P  (=   " "t 20 % (=    B   B  
 
4 
Rp 20
 t d
 T	 4 R B   B   20! 	 t 
d T 0. C. H !   0. C. H  20
 
4 
2p d 4 2p 4 p R
pP0! d
 1 1 8I !   d
 1 1 8I !   d
 1 1 8I !   d
 1 1 8I 
 
4 
2p! d p4 4 I !   p4 4 I  20 d	 T 4 2! t P6 6 I !   P6 6 I  20
 
4 
2p 20u ut 
4 
2`
 
4 
2p 4 2
p`P 4  d 4 2p
 
4 
2p B  ! 4 pA A tJ ! t  4 pA A tJ  B  ! 4 PB B J ! t  4 PB B J !   PB B J  B  ! 4 0C C J ! t  4 0C C J !   0C C J  B  ! 4 D iD 0K ! t  4 D iD 0K !   D iD 0K  B  ! 4 D IE tK ! t  4 D IE tK !   D IE tK  B  ! 4 E )F K ! t  4 E )F K !   E )F K  B  ! 4 F G K ! t  4 F G K  B  ! 4 pG G 0L ! t  4 pG G 0L !   pG G 0L  B   B   B   B   B   B   B   B  C
 CT	 >4 d
 2
p d T 4 p T	 4 2p!  d K  L L !   K  L L  2p 4  2p`P! 4 M +N (M !   M +N (M 
 
4 
2p T 4 Rp`! 
 O O dM !   O O dM  T 4 R
p`
 
4 
2P!
 
t d R R M !   R R M !   t  d R R M !   t  d R R M 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !  \ \ XN !    \ \ XN !H
 HT : 5t
 0d	   \ \ XN  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p
 t d
 T	 4 R
 
d 
2p! 4 0l l ,O !   0l l ,O  t 20 d 4 2p! T  n n hO !    n n hO 
 
20 d	 T 4 2p!  p q O !   p q O !    p q O !   p q O  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d x Ty LP !   t x Ty LP !   x Ty LP  t 20 20 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p d 4 2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	 0 g R !   0 g R  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	   |S !     |S  B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
P  L     @    u       4     E    f    '    4    t          2P'
 '4 
p`P                        2P6 (4   
p`P  =                        P                  R        L    ^    z                      2P, ,4"  
p`P         5    A    M   O                 R              2P'
 '4 
p`P   e     Y       1          2P, ,4"  
p`P   H                                               2P'
 '4 
p`P p       P }         T      2P- -x )h %4 
p	`P         #     7    !      2P' d 4 p=  j   E        2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p\ \T p`0(= P   
 
4 
Rp9
 +t! 'd  #4  
P  =     k     w     	 Z	     m	    }	    {	    	     O		 9
 +t! 'd  #4  
P  =                
	 j
	     }
	    
	    	    	     _
	  d 4 p 8       0	 V	     _	    =	     y	  d 4 p `       	 	     	    	     )	 9
 +t! 'd  #4  
P  =               	 	     	    	    	    e	     	 9
 +t! 'd  #4  
P  =               	 	     	    
	    	    u	     	 9
 +t! 'd  #4  
P  =     +     7    C 	 	     
	    	    	    	     	 *
 *4 
p`P   O     [ 	 	     	    "	     "	  t d T 4 9
 +t! 'd  #4  
P  = (    g     s         ,	 _,	     x,	    ,	    ,	    )3	    3	    64	     4	  B  
 
4 
Rp, ,4  
p`P   P                       P7	 7	     7	    7	    W<	    <	    <	    <	    <	    =	    @	    @	     (A	 	 $ 
p`0   x                                     L_ @            X   A	 A	     A	    A	     C	    gC	    H	    3H	     OH	               
 
rP x 
 
4 
Rp
  
	p`0P $ P  !u ud" #     
t! 4# \	 ]	 _ !    \	 ]	 _ !   \	 ]	 _ !            t!  d"  4# \	 ]	 _  T
 4 rp`  
  !m m bT   t d 4  s	 s	 ` !     s	 s	 ` !    s	 s	 ` !         t  d  T  4  s	 s	 `  T
 4 rp` B  !6
 6 1t )d
 
T	 4 	 	 ,a !   	 	 ,a ! 
    t  d
  T	  4 	 	 ,a )	 !  p`0    !     -    9    E                           a @           Q 8    	 a	     p	    	    	    	    M	    	    5	    T	     v	 Q     ^         
 
2P   d T 4 p*	 *4  p`                                    b @            8   	 	     ,	    	    	    	     	               
 
2P  #
 4 
p`P(= X    	p`P0(= `   
 d T 4 p t d
 T	 4 2 	p`P0(= X    BP  !; ;t
  
d	 4 P	 _	 c !   P	 _	 c  20!
 
t d 	 	 4d !   t  d 	 	 4d    !W W	 '  t
 d T 4 P	 [	 ld !   P	 [	 ld M
 M T 4
 rp`-
 a 
	p`0P(=   #
 4 
p`P(= `   D
 Dt d	 T 4 2
 d T 4 p   (=    !$ $  t d T 4% 
 
 8e !    
 
 8e !   
 
 8e 
 d T 4 p
 
P  !b b
 $ 	 t 
d 4  
 *
 e !    
 *
 e  bP  !' '   t 
d 4
 
 
 e !   
 
 e  T	 2! t d 4 
 
 8f !   
 
 8f  2
p`0! 
 
 T
 0
 `
 pf !    0
 `
 pf !   
    T
 0
 `
 pf 
 t	 d T 4 2 20 20 d 4 2p t d T 4 #	  
p`0                                                    g @           " 8   (
 M(
     a(
    .
    .
    .
    /
    //
    a/
    /
     0
    0
    1
     2
 "     /    V      2P
 
2P   d 4 2p)	 !$ p`0    d     p    |                                                           L                                  Pi             di    
         xi             i @            8   @           
 8   @           i 8   @            8    3
 ]3
     q3
    3
    8
    9
    39
    H9
    h9
    =
 	   =
    =
 
   >
    4>
    f>
    >
    >
 
   >
    @C
    ^C
    G
    H
     MH
                   >     v                   2P
 
2P   2P
 
2P   2P
 
2P  
 
2P   4 
p`P(= X    d 4 2p6 (40 & 
p`P  = @ *           "    .     L
 M
     %M
    bM
    rM
    S
    S
    T
    T
    T
      2P6 (40 & 
p`P  = h *  F     :    o    {      U
 eU
     U
    U
    U
    \
    2\
    s\
    \
    ]
      2P; -x )h %4, " 
p`P  =               ]
 ]
     ]
    ^
    

    
     B
 
 + 
	p`0P9
 +t3 'd2 #41 * 
P  =  J        
 !
     0
    |       20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   d T 4 2p bP  !' '   t 
d 4
 P i n !   P i n  T	 2! t d 4   5 @o !     5 @o  2
p`0! 
 
 T
   xo !      xo !   
    T
   xo 
 t	 d T 4 2 20 20 B                            8p 	   8  (    8   	   @ 0    8   	   3 8   5 8   	   ( @   n 8   	   xW H    8   	    P   & 8   	   Q X   _ 8   	   T `    8   	   ' h    8   	   D p   s 8   	   P` x    8   @            8   `# p#     #               	    '     B    `     {                  3    Q     l             	     $    e                           -     
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P   B   20# 4 rp=  2   ; @$ p$     $ 1	 #t! d  4  P  = 0    G     m    y                          % %     %    #&    L&    q&    &    &    &     '    '    '    '    (    #(    -(      2P d
 4 
Rp X  p( (     (  20 B  ? .4  
p`P  =  :                           )    5    A    M 	   ] 
   m    }     
                                           *    :    F    V    b    n    ~              !         #    * '+     7+    1-    -    -    .    O.    . 	   . 
   .    \/ 
   /    /    /    I0    0    0    0    1    V1    b1    1    1    2    2    S2    g2 !   2 "   2 $   	3    ?3    Y3    3    84    `4    z4    4     4  2P 20   ! 4
 p7 7 v !   p7 7 v    ! 4
 8 8 w !   8 8 w 
 
4 
2p 2p! 4 : ; Hw !   4 : ; Hw !   4 : ; Hw !   4 : ; Hw !   4 : ; Hw !   4 : ; Hw  B  
 t	 d T 4 2    h 	x    h 	x       P`            p                       Xx                    xx } x                                 d                 `         8   \                 `     |                    z { y  x  |                                    8  (          K                  V     P                     `                          X         (   0`                      @                     C             /                      @}                    ~ 0 x                     - (          ]                `V         X   0                0.         h   ^                      {                    h  0 x                                   -            ]                 PD         @                         `}                     @"         8    ]                Ȁ  X 0 x                                       L         P   `_                                             x                            z                     00         @   @                x  x                    } x                 p+     P         0                 -     h                             X   -                { { x                    hz   @z                                                               xW            @`                 8             K                  '             _                d         X   V                       |                     F         8    \                 X         @   `W                  x                G         X   c                ~ p   x                                             P                          ~                      x                          z                                                 @>         @   @.                 08         @   P                 3            ^                 =         X                          Ѕ                    X  x                    >         X                                                     8                     8            0                  T            ^                 @            06                  (            s                 *         X   P                          8   ]                }  x                     x                 Q            \                  (            P:                x~ } x                           @                     "        (   c                 c                          0     І                     x                \         X                    P` (          p                  "         (   c                 ^     x                                               Є 0 x                     8{ }  x                                                @   p                 p+     @         0                 D            @_                 7         @                             8   _                       0|                    }  y 0 x                                       G         X                   X 0 x                     " (       (   c                 8 x                    0 x                0~ ~  x                                                              =            PY                 Ё H   x                                      ` p|  (y                                   0         @                    [         @   pd                         jY    ҇          ȇ ̇ Ї  -   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392.cp36-win_amd64.pyd PyInit_stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_4329073966977269392             @         ޲  p            ،           h          V  x         v                       p          ظ 0            `                                             *     B     N     \     t                         س               &     :     N     j     ~               Ĵ     ޴                       j               2     (               B                    Z          ֣          J               *     F                         (     B     d     z          ܡ          6     \     ~     t               v     H     "          ޱ               `     @                    p     .               V          Ԯ          P          ƭ          8               h     $     ޫ          T          Ҫ          `     $     Щ     |               8                            8     B     Z     f     p                    ȵ               \           R     @                                    p     z          :             j          f     v     ~                                        n             H     <     2     $               Է                         ,     ȶ             2          V          ܶ     Ҷ                R     |     `                  L          r             D                  T     B     &                    Ҝ                         n     J     8     *                    ڛ     ʛ                         t     ^     P     <     .                     ֚     ƚ                    n     T     @     &                     ؙ     ʙ                         z     b          <     ,               ֘                         r     `     H     2     $                    ֗                    x     d     T     :     &                    ؖ     Ɩ                    h     T     :     "                         Е     p          Н                              2          D     X     h     |          x                    Ğ     ؞               f     J          ,     B     X     p                         ̟          <          J     *                    ڔ                    x     ^     J     :     &                             PyBaseObject_Type rPyObject_SetAttr  PyUnicode_InternFromString  ? PyCFunction_Type  5PyOS_snprintf PyThreadState_Get W_Py_CheckRecursionLimit  PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches _PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  PyExc_RuntimeWarning   PyErr_PrintEx \PyFunction_Type KPyFrame_New  PyExc_DeprecationWarning  PyExc_KeyError  {PyImport_ImportModule }PyImport_ImportModuleLevelObject   PyErr_NormalizeException  RPyUnicode_AsUnicode pPyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  rPyUnicode_DecodeUTF8  TPyObject_GenericGetAttr PyTraceBack_Here  _PyThreadState_UncheckedGet PyExc_RuntimeError   PyExc_IOError sPyObject_SetAttrString  PyLong_FromLong SPyObject_GC_UnTrack PyUnicode_FromUnicode `PyObject_Hash  PyErr_SetNone 
PyExc_MemoryError  PyDict_GetItemWithError Py_GetVersion YPyObject_GetAttr  :PyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags * PyBytes_AsStringAndSize k_Py_NoneStruct  PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size =PyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable ]PyObject_GetIter  PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx *PyExc_ValueError  X_Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError nPyObject_RichCompare  PyTuple_Type  a_Py_FalseStruct u PyCoro_Type BPyFloat_Type  PyMethod_Type PyLong_Type  PyType_IsSubtype  PyNumber_Subtract  PyErr_Restore PyExc_OverflowError wPyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  F PyCapsule_GetPointer  QPyObject_GC_Del  PyErr_Fetch DPyObject_CallFunctionObjArgs  PyLong_AsLong JPyObject_ClearWeakRefs  jPyObject_Not  PyUnicode_FromFormat  [PyObject_GetBuffer  PyList_New  PyModule_Create2  PySlice_New jPyImport_AddModule  "PyType_Ready  ZPyObject_GetAttrString  r_PyGen_Send  PyErr_Clear PyList_Append 6 PyBytes_Type  `PyUnicode_Decode  W PyCode_New  3PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  BPyObject_CallFinalizerFromDealloc dPyObject_IsInstance PyExc_StopIteration PyList_Type  PyDict_GetItemString   PyDict_GetItem  \PyObject_GetItem  GPyObject_CallObject  PyErr_CheckSignals  RPyObject_GC_Track 3 PyBytes_FromStringAndSize xPyImport_Import PyExc_NotImplementedError ZPyUnicode_Compare ePyObject_IsSubclass "PyExc_TypeError PyMem_Realloc > PyCFunction_NewEx N PyCapsule_Type  fPyObject_IsTrue PyExc_NameError PyTuple_Pack  _PyByteArray_empty_string Py_OptimizeFlag @_PyUnicode_Ready  PyMem_Malloc  PyExc_IndexError  PyExc_ImportError gPyGen_Type  r_Py_TrueStruct  
 PyArg_UnpackTuple PyExc_SystemError  PyExc_AssertionError  tPyObject_SetItem  _PyObject_GC_New  PyTraceBack_Type   PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  uPyObject_Size  PyBuffer_Release  @PyObject_Call ' PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python36.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 1EnterCriticalSection  LeaveCriticalSection  
DeleteCriticalSection SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  vGetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  iSetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  ~IsProcessorFeaturePresent wIsDebuggerPresent AQueryPerformanceCounter GetCurrentProcessId GetCurrentThreadId  GetSystemTimeAsFileTime DisableThreadLibraryCalls aInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                                                          2-+  ] f      /                                                     V                                                                                                                                       @                @                                                                                                                                                                                                                              V                                                                                                                                       @             P                                                                                                                           `                                                                                   HM   @"                  XM                     hM   @                                                                         U                                                                                                                                       @             `                                                                                                                      p                                                                                   `,   H
             Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              P#                                                                                               p	                   Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                                            M   p                                                                  `   H                                                    D     PN      p                                   `                                                                      0                                                                                   hl          l                      xl          H              l                                                   hR                              B                         xR      p                      P                       R      `                   R   @                      R                          F                          <   `                      R      @                   R                          L                                                                          Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       Y   `7          k   .    1          k   $.   p4          hi                                   Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                  Transform parameters from unconstrained space to defined support                Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
                                                      W           (o                                                                                                                                             R   p               0                                   @	           0                      @	                            D     PS       0                                   p           P                                           %
                                                                                                                      m   p               .                                                                                                                   @             `0                   8               5                                                                                                                                                    0.   Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
           l   .   -   l           l   -   -   l                                                           0P   $
                  @P   
                  PP   
                  DA   
             `P   
          p   HN   	          p   pP   	                  P   	             P   	                  P    	             P   	              P   	             P   ~	             P   Pq	          `    Q   \	             Q   H	          p   (Q   pA	          0   @Q   @7	                  PQ    6	                  `Q   5	                  pQ   P5	                  Q    ,	                  Q   0#	                  Q   	                  Q   	                  Q   	                  Q   	                  R   	                   R    	                  8R   
	                  XR   0	                                                  Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
                                                                                                 R                                          0W                                                                                                                                        @                                                                                                                                                                                                                           Transform parameters from defined support to unconstrained space                Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

               
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              *   L
                  xM      `                   M   P                      
                         t      0                   
   л                      ,   p                      T;   к                      M   `                      M      @                   M                          M                          M                                                                         
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
              q                            `y   
                        v                            w      (                      xq   X   &                      q      &                      q   8                        w   D                        u                           t      <                      0q      #                      Xz                           xx                           hx   4                        q   @                        r   H                        py                           z                            w   (   $                      w                           0x                           t                           w   `                         x   x   
                     0r       	                     s      %                      v   p   (                      0u      A                       x                           xu   l                        s   H                        t   \                        Pr                           w   `                        hz   P                         s   X                        q   h                        r                           w                           v                           x                           Xs      	                     Ps   H                        Pq      
                     w   H                         (n   H                        @q   @   
                     v                           r   (                        n                           s   `                        t                           @u                            `w                           q   D                        pu   0                        y                           w      	                     @r                           x   x                        t                           r                           v   H                         z   H   
                     0s                           w   (                        n   
                        r   h   
                     x                           w                           8x      L                      hy                           z   p                        r      
                      y   d                        Hq      	                      Pv   P                        8s                            Pn                           v   h                        s                           Xn                           x       +                      `v      
                     x                            hw                             z                           v                           0z                           r      
                     8q   x                        v                           t                            u   ,                        v       
                     u                           t   x   
                     w                           v                           xr                           Hx   @   
                     q                           r      
                     pr      
                     w                           pv      
                     `n   0   	                     t                           v      	                     (s       
                     x   l                        (u      
                     8v   8                        hn   `                        x      .                      u   $                        s                           Hs                            x   p   
                     `t   
                        s      	                     ps                           t       
                     t   x                         r                            v                           u                           u                           Xu   X    	                     (z   P                        q   8   
                     x   P   
                     u                           Hv   ,                        q                            w   8                        ht   |                        u                           (t   ,                        @z                            @t      "                       r                           Py                           y      x                      v   \                        x       '                      @v      "                      `s                           q      
                     t   <                        t   X                        @n   `                         o   x                         x                           `r                           Xo       	                     `q                           @s                           n                           z                           w   h                        w                            t                           t      
                     n                            y                           Hr   @                        @x                           q                           xy                           r      
                     u                           x                            t                            s                           r      
                     (x   p                        Xx   0   	                     v   P                        u                            s                           s   p                        w   L                        r                           v   T                        s   d                        x   h                         u   8                        s                           x      H                     t                           y   X   	                     xs   h                         y   x                         x      
                     xt   L                         s      	                     t   
   	                     `z   x   
                     u   $                        s                           y   P   	                     v                           s   0                        hu      
                     Hz   
   
                     Xy                           q      
                     y   t                        x      	                      (q   (   %                      8n                           w                           q                            8r                            u   d                         hr   `                        t                           px                           q   l                         `u                           hq   8                        t   p                        Pz                           hs      	                     Xq   L                                                                        @n   n   Pn           @n   n                   hn           n   n                   hn           n   n    o           @n   Xn                   8n   (n                   8n   (n   `n           @n   Xn                   @n   Xo   hn   Xn                   u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                         .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AU?$located_exception@Vexception@std@@@lang@stan@@               .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AV?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                         .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AVadd_vv_vari@?A0x8826f8fc@math@stan@@                   .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVlogger@callbacks@stan@@                        .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AVexp_vari@?A0x8826f8fc@math@stan@@                      .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                       .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                         .?AV?$adapt_dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AV?$unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVlength_error@std@@             .?AVdomain_error@std@@             .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVcovar_adaptation@mcmc@stan@@                           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .H                 .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                         .?AV?$adapt_unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVbad_exception@std@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                        .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@              .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@                     .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$adapt_unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVbad_typeid@std@@               .?AVps_point@mcmc@stan@@                   .?AV?$dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@             .?AV?$diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AUbad_exception_@exception_detail@boost@@                .?AV?$numpunct@D@std@@             .?AVvari@math@stan@@               .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVdump@io@stan@@                         .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@                      .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@             .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                       .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVrounding_error@math@boost@@            .?AVunderflow_error@std@@                          .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                       .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVsum_v_vari@math@stan@@                 .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVempty_var_context@io@stan@@            .?AV?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AV?$adapt_diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                  .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVchained_var_context@io@stan@@                  .?AVfacet@locale@std@@             .?AVdiag_e_point@mcmc@stan@@               .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AVadd_vd_vari@?A0x8826f8fc@math@stan@@                   .?AVfixed_param_sampler@mcmc@stan@@                .?AVout_of_range@std@@             .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                         .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                           .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVbase_mcmc@mcmc@stan@@                  .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x8826f8fc@math@stan@@                  .?AVdense_e_point@mcmc@stan@@                      .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                 .?AVsum_values@pystan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@                       .?AV?$adapt_diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@                     .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVprob_grad@model@stan@@                         .?AV?$adapt_dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                           .?AVanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@            .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AVexception@std@@                .?AVmultiply_vd_vari@?A0x8826f8fc@math@stan@@              .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                        .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVwindowed_adaptation@mcmc@stan@@                .?AUPyErr_CheckSignals_Functor@?A0x8826f8fc@pystan@@               .?AVvalue@pystan@@                 .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AV?$unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                                                         V  $
 `    $
     $
    >  $
 @  ^  $
     $
     $
   
  $
 0    $
     $
   F  $
 P    $
     $
     $
      $
    V  $
 `    $
     $
     $
      $
      $
     $
     $
     $
   &  $
 0  F  $
 p    
   3  
 `    $
   %  ,
 0  p  
 p    4
   y  P
     
 p    
    m$   
 $  $   
 $  %  
  %  K%  
 P%  t%  
 %  &  
 &  2'  
 @'  '  
 '  4)    @)  )*  H  0*  *  `  *  +  `  +  T,  x  `,  -  x  -  D-  
 P-  %.    0.  Y.  
 `.  .  
 .  .  
 .  /    /  /  
 /  [0   0  0  
 0  0  
 0  1  $
 1  1  ( 1  1  $
  2  2  ` 2  2  $
 2  3   3  3  $
 3  4   4  4  $
 4  5   5  5  
 5  #6  
 06  p6  
 6  6  
 6  6  
  7  &7  $
 07  g7  
 p7  7  
 7  8  
  8  g8  
 p8  8  
 8  9    9  :  p :  ;   ;  <    =  =  P =  1>   @>  k>  
 p>  ?  x  ?  ?  
 ?  @@   @@  @   @  @  ,
  A  C    C  TC  
 `C  ]D   `D  F  P F  G  ` G  5K  
 K  L  
 L  WL  
 WL  L   L  L    M  .M  
 0M  M   M  M  0 M  P  8 P  R  L  R  _T  \ T  U  
 U  2V  l @V  V   `W  X    X  X     Y  NY  
 PY  Y  
 Y  xZ  ` Z  F\   P\  t\  
 \  \  
 \  ]    ]  _  h  _  6`   @`  `  
 0a  Rc     e  e  p e  g  | g  i   i  l   	 l  <l  p	 <l  l  |	 l  l  	 l  m  	 m  m  	 m  m  	 m  o  	  o  >p   @p  r  8
 r  r  
 r  r  
 r  Ps  
 Ps  s  
 s  s  
 s  s  
  t  .t  
 0t  t  
 @u  u    @v  v  8 v  {  p  {  L{  
 P{  {  H  |  `~  ` `~  ~  
 ~  ~  
 ~    ,
           
   ހ     ނ       8
   $  H 0    8         ]  
 `    @   $    0  G   P    x                    
   ]  
 `  ě    Л     
      p   Ҝ       
      О       g  
 p    p   4  0 @  Τ    Ф         $   M  , M  ڦ  H ڦ  j  ` j    p   է   է    `   {     Ǩ   Ǩ            3   3  j   j             L  4 P    
   ϫ  T ϫ    h   	  | 	  >   >       ʭ   ʭ  خ   خ       1   @       H   H    (   ?  
 @  y  ,
     ,
   ֳ  ,
     ,
     H     T   r  
     
   (   0  E    P                         X   Z  p   {       !    P  P! P    \!   V  x! V  z  ! z    !     
       !      "    1  " @    "     "   {  " {    "     
      "      #    m  $ p    %   L  & P    '   f  h' p  Z  " `    '     '     '     '     '   ~  (     (     (     (    p)   )  Y 8* `  D*   P*  i	 d* i	 	 * 	 - * 0 R 
 `  h+  q +   +  ; , @  @,   p,   1 , @ r -  s .  s .  ! 8/ ! " P/ " $ / $ (  0  ( @+ 0 @+ c. 0 p. / 8* / 0 D* 0 B1 `1 P1 5 h1 5 6 (2  6 6 X2 6 7 2  7 {7 2 7 7 2 7 8 ,
  8 8 
 8 8 
 8 9 3 9 9 
  : P: 
 P: : 
 : ; 
 ; A; 
 P; 
=  3 = r= 
 = = 
 = R> 
 `> > 
 > -? 
 0? d? 
 p? @ x   @ @ 4 @ CA X4 PA A 
 A A 
  B 4B 
 @B N x  N O 4 O NT 4 `T T 
 T [ 5  \ \ p6 \ ] 6  ] ] 6 ] ] 
 ] ^ 7 ^ ^ 
 ^  _ 
  _ @_ 
 @_ _ 
 _ ` 87 ` f` 
 p` ` 
 ` &a 
 0a a 
 a a 
 a Lb h7 Pb b 7 b ,c 7 0c c 7 c d 
 d d 
 d Ie  8 Pe r 8   x    N @B P  H  f hI p [ I `  K   
   װ x   T   ` # PL 0  L   
   O x  P   M  ɵ ,
 е  ,
   ) ,
 0 Y ,
 `  (M   * M 0 ˻ XN л |  O  Ƚ O н  O   ־ O  * @P 0 : Q @  Q   Q   Q  r 
   
   Q   V 
 `  Q   
   T Q `  
   Q   6 
 @  Q  Z Q `  
   x   W R `  
   
  a R a  R   R   R   T 
 `  R    R     S    
   3  t 3   
  D 
 P  
   
   
  F 
 P  
      8 S 8 F $S P  4S    
  d S p  S   S   T  " T 0  8T   hT    T  z T   T   f T p > T @ 3 U @ 4 
 @ p XU p  
  @ 
 @ X   X  U   U  h U p  
       e tV e s V   
 @  R  2 V 2 | V |  V   R  0 V 0 D V P  
  f 
 p \ 
 ` x   x  V   W  + ,
 0 { ,
   ,
  Z 
 `  ,
  7 x  @  
   W   
   
  ` 
 `  
  	 
   8W    LW  = `W @ n 
 n  W   W   
  < W   X   # ,
 0  
    (X   6 X @ c ,
 p  
  ( X (  X   X    X P  Y  F Y F h $Y h  DY   
  D 
 P  x    x   7	 
 @	 	 \Y 	 I
 Y P
  
    
  b $
 p 8 S @  
  s Y   $
    $
   
   b DZ p  
   $
  $ $
 0  ,
  I Z P  S    ,[   @[   X[    ,[   h[   [  O  $
 P  :! [ @! *" [ 0" " $
 " 2# $
 @# # 
 # 4$ $
 @$ $ $
 $ 3% 
 @% %  
 % '& 
 0& & [ & & \  ' ' x  ' ( 0\ ( ) x  ) + H\ + , 
 , - x  - . x  . / d\ / 0 x\ 0 22 \ @2 [3 \ `3 3 
  4 6 \ 6 57 \ @7 7 x  7 8 ] 8 Q9 
 `9 9 
 9 ; H] ; '< \] 0< < $
 < < $
 A B $
 B B $
 B C $
 C C ] C D ]  E rE $
 E KF ] PF G ]  G G $
 G  H T  H H $
 H I  ^ I fJ ^ pJ J T J K 
  L M ]  M M $
 M 5R $^ @R V 8^ V yW P^ W X 
 X aX d^ pX X ,
 X Z ^  Z ^ t_ ^ C^ _ C^ _ _ _ _ _  _ _ _ _ ` _  ` ` 
 ` a ] b b _ b =d _ =d Md _ Md d ` d d _ d mf ` mf }f ,` }f f <` f g $
  g 7i P` @i Ik 8a Pk dm b pm m 
 m ;n d\ @n fn b fn n c n n  c  o {p 0c p Ir xc Pr s c  t Qt 
 `t u Xd u v T v `v ,
 `v ow d pw w e w x e x y ,
 y y (f y z ,
 z z Pf z { f { d| f p| | $
 |  f    xg  ۂ 
   Hh  : h @ ؈ h   i   
  N 
 P  
   
  f 
 p ƌ 
 Ќ & 
 0  
  ƍ i Ѝ  Xj  F j P  (k  Ǝ k Ў  k  F `l P  l  Ə 0m Џ  m  F  n P  hn  Ɛ n  W 8o `  xo   r  6 s @ p ht p  0u  v u  *  x 0 & px 0   y   4y   Hy    Xy   x    W x  ` h y p  y  Y z `  $
   ,z   @z   Pz   dz  F pz F R z R _ z `  x    x    
  h z p . z @ l 
   
   {   
   ~ `{   {   8|   |   |   8}   }   }   |  ~  r (~   h~   j ~ p  ~  l ~  W  p , P^ 0      x       `  K 
 P r 
        O T P  $
  \ P^ `     g  p 	   5 ,
 @  
   ,
  J  P  <        p      T ؃ T        
  
 t
 , 
        ,  , g ( p  
   8    X               8   9%  @% I)  P) + Ȋ + 2, @ @, 05  05 HE  PE xU  U Y X  Z :[ 0 @[ \ p \ *^  0^ _  _ b   b f  f g 0 g i h i j  j l ؕ l mo  po *s  0s Vx   `x }  } Ҍ p  ?   @   p        4  9 D @ ޞ \  ~ О   H   P   h  5 x @ N H N R  R S  S     H  ( П ( )  ) E  `    Ӣ  Ӣ e  e f Ƞ f  ؠ У M  P ئ 8  + x  0    H С H Ϫ  Ϫ    `  `  8   P   l   |  |    
   
   آ  ^   `  
   0  / 
 0  X   
   
   l 
 p  
   
   ? 
 @  
   
   
   
   
  A 
 P C  P }   l  p  ئ   
      6  6 D   P  
  ' 
 0  0      
    
   z 
           $  - 8 - n H n ~ `    
  6  
 @ $ p 0    =    
  V  `  ̩         z    ,
  : ( @ *  0 z    Ь   
   Z   `  H    p              P  P 8  @  X   _  S  p  
  \ 
 `  
  L 
 P  Ȯ  +  + 6  6 ]F 0 `F nQ ط pQ 5R _ @R S p S S  S VT 
 `T :U " @U iV  pV 6_ P @_ 2` 0 @` a  a 
b H b Uf P `f h   i i H i j  j Po   Po o   p p  p cq 0 pq r x r >s  >s 
t  
t t  t Mu  Mu nu  pu w  w 
|   | 	   -  0 ) ( 0 T  `   
  ? X @ U p U  |     , $
 0       p ҕ 
   
  % 
 %           Ș 
 Ș .  . U  ` ߙ   /  0 O  P g p g  |     C  C            ؃  8   8 [ 8 [ ? L @ 3 d @  |  f  p ~  ~    e  e       &  0  P  & l 0    d  d    ۵  ۵     @ $ @ _ ,
 `  ,
  ʼ X м  (                8      @   X          S	  `	 d P p  t        m"  p" t'  ' =)  @) + X + + p + ,  , %,  0, .  . . ( . 0/ 8 0/ v/ T / / ( / / d / 60  @0 A2  P2 6  6  8 8  8 H  H K h  L ]  ] ] X ] ^  ^ ^ 
 ^ X_  `_ !`  0` ` 
 ` a ' a a 
 a Fb 
 Pb b 
 b c 
 c c  c c 
 c hd P pd .e x 0e oe 
 pe e  e /f 
 0f f  f Eg  Pg g 0 g 6h X @h h  h j  j l @ l n  @o ^p  `p wq  q r 
 `r r 
 r t   u v `  v v 
  w Gw 
 Pw z   z z  z { 
 { |   | &} $ 0} N}  N} }   } } @ } ~ P      4    
   ̩     ֌   t 
      $        (  *  @  p   . 
 0  ̩     % p 0 z       |   u    { `  3  @  $
  6 $
 @     9 S 9 q  q w    
  D 
 P Ʃ 
 Щ  
   
  Ī 
 Ъ F 
 P  
   
  ì    _   6 h @  
     ̶ H ж v    
  9 p @ l  p        j x p ^  `  
  < 
 @  "   E ,
 P     $   8   x    H      X   d  i | i    O  P          #  0 < d @  $
   $
   Q  `  $   
    ,
   / x 0  h  c (  p  p              $  " D " # d # I$  P$ X' T `' +  + .  
 . 2 x 2 7   7 }7 
 7 7  7 P8 x  P8 	; ( ; ;  ; i> H p> ?  ? d? x p? ?  ? ?  ? A  A A   A :A  :A A  A A  PB jB  jB C  C C ,  C ?C ,
 @C F < F L ( L O   O ^O p ^O P  P Q  Q  R   R 0S  0S  T   T cW  pW lY ( pY Z   Z V[  `[ [ 
 [ [ ,
  ] ]  ] %^ 
 0^ _  _ qa  a b X b d _ d e  e Sf  `f f 
 f Sg 
 `g g 
 g rh  h h   h k  k l < l n L n fo  po p  p y , y y P y '{ ` 0{ ~  ~     d  i  i  ,  O < P T P `    o  o       L  P C  P  X     "  0  !  / 
 / e 8" e ף L"  ۥ \"   
  5 " 5  "   "   l#      $  ̬ $ ̬ J 0$ J  L$ @ T h$ T  p$   $  Ѯ h$ Ѯ i $ i  $   ( X (  $  [ $ `  h$  V $ V  $ @ h X h  %    %   0%   x%   $
   %   %  % % 0 O 
 P  &   0&   
  H `& P  &   _ 
 `  &   
    &  : ' @  _   H'  , ' 0 f ' p   (   @(  U ( `  (  F ( P  (  E  ) P  H)  6 p) @  )  : ) :  )   )    _   
   )   8*   *  z *  ] 0+ ]  D+   X+  c h+ p  +   +   +   +   ,   $,  > D, @  T,   $
   d,   ,    ,   
  / ,
 0  
   ,
   $
 `  ,  D , P ; - @  4-  A H- A U `- ` J p- J  -   -   -  0 - 0  -  ) - )  -  \ . \ b $. b y 4. y  D.  E T. E   d.    |.   .   .   .  t .   .   .  	 . 	 
 / 
 v  /  $
 0/   $
   </   /   "  A _ P k d\ p  /   /  6 0 6 E $0 E F 40 P  D0   0     _ 0 _ r 0  a 0 p  _   G h$ G   81     X1     h$   u! h1 u! " 1 `" " h$ " E# 1 E#  $ 1  $ $ 1 $ $ 1 $ $ 1 $ $ h$ $ S% 2 S% %  2  & ' 02 ' ) 2 ) N) 2 N) 5+ 2 5+ + 3 + ,  3 , L- ,3 L- - H3 - - 
 - 8. X3 @. . 3  / @/ 
 @/ / 
 / / 3  0 
3  3 l5  p5 6 3 6 6  4 6 {8 44 {8 8 P4 8 W9 `4 `9 9 l4 9 U: 4 `: : 4 : F; 4 P; ; 5 ; c< 85 p< #= p5 0= = 5 = c> 5 p> @  6 @ GA 6 GA BB 6 BB ,D 6 0D D 
 D D ,
 D EF 6 PF 5G 6 @G G 
 `H -I  0I K 7  L %L h$ %L L X7 L M l7 pN N X N \O |7 \O O 7 O O X O P 7 P P 7 R R 7 R S 7 S S 7 S CT 8 CT ET 8 PT ~T ,8 ~T V <8 V V d8 V V 
 V XW 8 `W X 8  X X 8 X 7Y 09 @Y Y 
 Y [ _ [ %\ x9 0\ z\ 9 \ ] 9  ] {] 9 {] 3^  : 3^ ~^ : ^ 3_ $: @_ _ `:  ` |d : d +h : 0h Oh ,
 Ph oh ,
 l xm ; m o ; o q ; q u 0< u z h< p{ { h$ { U| < U| } < } =} h$ =} ~ < ~ ~ <    =   @=   =      J = P  =   >  [ $> `  4>   ō p> ō  >  E > P q > q  >  & > & m ? m v ?   h$  e ,? e   L?   < \? < t h? t { ?   p   ?   ?  5 ? 5 Z ? Z Ӧ @ Ӧ a @ a + @ 0 z H@ z P T@ P  x@   _   @  A @   @  
 (A  + `A 0 \ A \ P A P Q A `  A   B  D <B P  LB   B   X  | B |  B   ?   C  K @C K  PC   @C   C   C   C   C  R C R d C d  D   X   ,D   HD 0    
 XD  
 `D  - D -   D    D   D  K E P  PE  H `E H  E  # E 0 P E P  E  H F H  F   4F     8
 
 DF 
 
 
 `  xF   x    $
   
  \
 
 \
 
 
 
  
    x    
  - $
 0 d $
 d y $
 |  $
   $
   T   P $
 P d $
 d  
  y F |  |F  < 
 < g 
 h  
   $
   
  \ $
 \  F  
 F   G  X T X  x    
   ,G   4G  a @G d  
   
  < 0 < \ 0 \ " PG 8  `G   $
 4 O $
 X  x    x    tG  )  G )  W  G W    G   $! G $! Z! G Z! i# G i# # H # ?$ $H P$ $ ,H  % % 4H % [& @H p& 
( HH ( Y( hH `( J) tH P) ) H ) * H * + H  , w, H , , H - o- H - - H 0. C. H C. . H . . H . Q/ I `/ L0 I `0 0 I  1 1 ,I 1 1 8I 1 2 DI 2 <3 XI <3 3 lI 3 c4 I p4 4 I 4 4 I 4 5 I 5 H6 I P6 6 I 6 )7 I )7 Q7 I `7 b8 J p8 8 J 8 .9 J @9 :  J : ^; 0J p; = <J = %> PJ 0> ? XJ  ? ? hJ pA A tJ A 
B |J 
B ?B J PB B J B B J B B J B C J 0C C J C C J C C K C C  K D iD 0K iD D 8K D D LK D D dK D IE tK IE hE |K hE E K E E K E )F K )F HF K HF xF K xF F K F G K G 7G L 7G gG L pG G 0L G G 8L G H LL H <H dL PH _H tL pH H |L H H L H H L H H L H H L I I L 0I ?I L PI oJ L J K L K  L L  L L L L M M M `M M pM M  M M +N (M +N N 4M N N HM O |O XM O O dM O lP xM lP P M P >R M R R M R US M US eS M eS S M S S M S LT N T V  N pV Z 0N Z \ @N \ \ XN \ u] dN u] ] xN ] _ N _ z` N ` Va N `a b N 0b b N  c c N  d e N g g N h )i N 0i i N i mj  O j j O j l O 0l l ,O l l 8O l m LO  m bm \O  n n hO n &o xO &o 
p O p p O p q O q >q O >q lq O lq r O r r O r u  P 0v v P v w P x |x 8P x x DP x Ty LP Ty y XP y y pP y y P @z /{ P @{ s{ P { { P `| | P | c} P p} K~ P `~ E P P  P  p Q  r Q   (Q  ! 8Q 0  @Q   HQ   PQ    `Q  + lQ @  tQ   |Q   Q  ; Q P  Q  K Q ` ۧ Q  W Q `  Q  [ Q p  Q   m Q  
 Q @  R  M R    R    ,R  - 8R ` ͮ DR   F PR p ݯ XR  } dR   pR 0  |R     R 0 g R g  R   R   | R  ַ R   m R  
 R @ q R  Թ R  M  S  ƺ S  ] S    S л $ (S 0 v 0S   8S  A @S `  HS   PS   \ XS p ٿ dS   lS   |S  $ S $ * S 0  S 0  S   S    S  G hT P  T    U  w V  H lV P  V   PW  a W p  W  M X `  X  H $X P  8X   @X   HX  E TX   `X   hX  E pX P  |X   X  G X P  X   X  G X P  X   X   X P  X   X   X  E X    Y   Y  E Y P  Y   (Y  G 0Y P  8Y   DY  G PY P  XY   `Y   lY P  xY   Y   Y   	 Y   	 W 	 Y ` 	  	 Y  	  	 Y  	 W	 Y `	 	 Y 	 	 Y 	 	 Y `	 	 Y 0	  	  Z 	 		 Z  
	 	 Z 0	 	 [ 	 y	 T[ 	 ~	 [ 	 	  \ 	 	 \ 	 #	 ] @#	 +	 p] ,	 5	 ] p5	 5	  ^ @6	 .7	 (^ P7	 _A	 4^ A	 H	 ^ H	 ]I	 _ pI	 \	 _ \	 ]	 _ ]	 o	  ` o	 o	 ,` o	 ?p	 @` ?p	 Jq	 P` Pq	 r	 |`  s	 s	 ` s	 }}	 ` }}	 }	 ` }	 }	 ` }	 ~	 ` ~	 m	 a 	 	 ,a 	 t	 8a t	 	 \a 	 
	 la  	 	 a 	 А	 b 	 	 b  	 	 lc 	 	 c 	 	 c  	 	 c 	 ;	 c P	 _	 c _	 D	 d D	 `	 $d 	 	 4d 	 k	 <d k	 3	 Td P	 [	 ld [	 	 xd 	 6	 d P	 	 d 	 	 d 	  
 d  
 
 e 
 
  e 
 
 8e 
 
 Le 
 
 te 
 
 e 
 
 e  
 *
 e *
 
 e 
 
 e 
 
 e 
 `
  f `
 |
 (f 
 
 8f 
 
 Df 
 '
 `f 0
 `
 pf `
 ?"
 f ?"
 "
 f "
 K#
 f `#
 $
 f $
 $
 f %
 ?%
 f P%
 %
 f %
 (
 g (
 a2
  g p2
 2
 Hh  3
 H
 Xh H
 6K
 j @K
 L
 k L
 U
 $k  U
 k]
 k ]
 
 tl 
 
 l 
  m  ' pm 0 g xm p $ m   m   m   5 m @ u m   m   7 m @ u m   m    m  	 m  	 t	 m 	 	 m 	 	  n  
 5
 n @
 u
 n 
 
  n   7 (n @  0n P  <n   Dn  
 Ln 
 E
 Xn 
 . dn P  pn   xn  G n P  n  D n   n   n    n 0  n   s n   n 0  n   n  4 n P i n i  o   0o   5 @o 5  Lo   ho   xo   o  6  o 6    o   8" o P" " o " " o " D# o `# # p # # r # 7$ r @$ $ r % _( s p( w) t ) p* <t * * Dt * 4 Lt  5 f7 v p7 7 v 7 I8 v I8 8  w 8 8 w 8 9 w 9 9 ,w 9 n: <w : ; Hw ; ]; Pw ]; ; dw ; ; xw ; ]< w ]< < w < < w < '= w (= E= $
 H= = X = #> w @> > w > A w A D  x D D pG  E &E 
 0E VE 
 VE |E 
 F F 
 F F 
  G )G 
 G H 
 K *L 
 pL 
M ` @M M    N N  N O @ ,Q UQ 
 Q S  0S YS 
 S U p pU V x 8V V H  ^ &^ 
 c c 0B hd d H Se e H bf f H Wg g H ph h H j j 
  k ^k M k k 
  l Fl 
 l l 
 m m 
 m m 
 m Nn R Pn n S n o U  o wo `V o o 
 o p 
 0p p 0Z p >q [ pq q P_ q >r `_ Xr r (a r r b r 0s b Ps ~s 
 (t `t e pt t 
 Pu ~u 
 u u Hj u v j v +v k 0v Kv k Pv kv k pv v Pl v v l v v  m v v m v w m w +w Xn 0w Kw n Pw kw (o w w 
 8y Ty s xy y Xt y y  u y z u z z x  { &{ 
 L{ u{ 
 { { 
 { { 
  | J| 
 P| ~| 
 } @} 
 @} ]} 
 `} }  } } 
 } ~ 
 0~ ^~ 
 ~ ~ 
 ~ 
   B ( P ~ 
   
 0 ^ 
  ǀ 
 < f 
   
   
  6 
 r  
   
 ܂ 
 
   
  х  H r  |       4 8 @ \ 
 \     
 p  
 < S    ۓ    ?   , C `  ˗ `  / `    `   p  
  ښ 
   
  ɛ 
 % h    
 E       ̠ 
 ̠  
   
 I z 
  q  }  
 ڢ t      Ѧ   % 
 P z x    P  
   H D _ p  ϫ   /   x `   x D _   Ϯ   /  ` H   ܰ '   Ĳ X   H   $ 
 0 Z 
   
 0 ` 
 ` } 
   
 `  
  ʹ   $      @ (  p X 0   P п >  @  @    
  @ x @ \ 
 \        
   8   :  @ \ 
 \  h   
       
                 J " P  X#   
  
  $   J 
 `  
   * 
   
   F   
   
  5  L u `T   T   U  5 V e  dV   V   HW  E W E k W  ! _ Q  xb   \c  " 0h " d 8h   j   j  
 j 
 L j L i j i  j   j  " k F o ll   r  5 r 5 n (r n  8r  & Hr & _ Xr _  hr   xr  s r s  r   r  ; r G m s   v  s $
   $
    $
  S $
 `  $
    $
   $
   m $
 p  $
   $
   m $
 p  $
   $
                                                                                                                                                                                                                                                                                                                                                                                                                         1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `0                    <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                    pxȪЪت  (08@HPX`hpxȬЬج  (08@HPX`hp           t  ȤФؤ xȪЪت  (08@HPX`hpxȫЫث  (08@HPX`hpȬЬج  (08@HPX`hpxȭЭح  (08@HPX`hpxȮЮخ  (08@HPX`hpȯЯد    \    (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء  (08@pxȢТآ  (08@HPX`hpxȣУأ  (08@HPX`hpxȤФؤ (08@HPX`hpxȦЦئ  (08@HPXhpxȧЧا  (08@HPX`hpxȨШ  (08@HPX`hpxȩЩة   (08@HPX`hpxȫЫث  (08@HPX`hpxȬЬج  (08@HPX`hpxȭЭح ȮЮخ  (08@HPX`hpxȯЯد       (08@HPX`hpxȠРؠ  ء HPX`hpxȢ8@HPX`hpxȣУأ  (08@HPX`hpxȤФؤ  (08@    
 T     (08@HPX`@HPX`hpxȯЯد   
 <     (08@HPX`hpxȠ 
     (HPX`       Xp x `hpxPxXp (8xЩPXxȪЪت  (@HPhpxȫ(08H        Hإ08@hx(@ȧ   (0pxЫث(08PXhpxȬЬج(08HPXhpxЭح08PXpxЮخ08  `   0СXآpxȫ08@X`hЬج  (0HPX    H  08X`Фؤ  (HPpxȥ8@`hئ (0PXxȧЧ @Hhp08X`Щة  (HPpxȪ8@`hث (0PXxȬЬ @Hhp08X`Юخ  (HPpxȯ     8@`hؠ (0PXxȡС @Hhp08X`Уأ  (HPpxȤ8@`hإ (0PXxȦЦ @Hhp08X`Шب  (HPpxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد     (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp 08P`hЧا 08@HpP0P8`@   L   8` @` hХ@XШ @p`ȭ0 0 D   0h`У HxХPx0 @Ь @ ` @ @   Ƞ P @ HP@   P H   @С0Ȥ hХ(`Ȧ xاp@ p ` $   Px 0@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ub.