     pystan.model	StanModel)}(
model_codeXN  data {
  int T;                                // Sample size
  int<lower=1> K;                       // Number of seasonal vectors
  real t[T];                            // Day
  real cap[T];                          // Capacities
  real y[T];                            // Time-series
  int S;                                // Number of changepoints
  real A[T, S];                   // Split indicators
  real t_change[S];                 // Index of changepoints
  real X[T,K];                    // season vectors
  vector[K] sigmas;              // scale on seasonality prior
  real<lower=0> tau;                  // scale on changepoints prior
}

parameters {
  real k;                            // Base growth rate
  real m;                            // offset
  real delta[S];                       // Rate adjustments
  real<lower=0> sigma_obs;               // Observation noise (incl. seasonal variation)
  real beta[K];                    // seasonal vector
}

transformed parameters {
  real gamma[S];                  // adjusted offsets, for piecewise continuity
  real k_s[S + 1];                 // actual rate in each segment
  real m_pr;

  // Compute the rate in each segment
  k_s[1] = k;
  for (i in 1:S) {
    k_s[i + 1] = k_s[i] + delta[i];
  }

  // Piecewise offsets
  m_pr = m; // The offset in the previous segment
  for (i in 1:S) {
    gamma[i] = (t_change[i] - m_pr) * (1 - k_s[i] / k_s[i + 1]);
    m_pr = m_pr + gamma[i];  // update for the next segment
  }
}

model {
  real Y[T];

  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.1);
  beta ~ normal(0, sigmas);

  // Likelihood
  for (i in 1:T) {
    Y[i] = cap[i] / (1 + exp(-(k + dot_product(A[i], delta)) * (t[i] - (m + dot_product(A[i], gamma))))) + dot_product(X[i], beta);
  }
  y ~ normal(Y, sigma_obs);
}

model_cppname+anon_model_047a6166bd9c6ecaed4dd3733fae7c6b
model_name+anon_model_047a6166bd9c6ecaed4dd3733fae7c6bmodule_nameGstanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902module_filenameZstanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.cp35-win_amd64.pyd
model_cppcodeXz  // Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unkown file name");
    reader.add_event(57, 57, "end", "unkown file name");
    return reader;
}

class anon_model_047a6166bd9c6ecaed4dd3733fae7c6b : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> cap;
    vector<double> y;
    int S;
    vector<vector<double> > A;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
public:
    anon_model_047a6166bd9c6ecaed4dd3733fae7c6b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_047a6166bd9c6ecaed4dd3733fae7c6b(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 4;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("cap", "T", T);
            context__.validate_dims("data initialization", "cap", "double", context__.to_vec(T));
            validate_non_negative_index("cap", "T", T);
            cap = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("cap");
            pos__ = 0;
            size_t cap_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < cap_limit_0__; ++i_0__) {
                cap[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 8;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            context__.validate_dims("data initialization", "A", "double", context__.to_vec(T,S));
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            vals_r__ = context__.vals_r("A");
            pos__ = 0;
            size_t A_limit_1__ = S;
            for (size_t i_1__ = 0; i_1__ < A_limit_1__; ++i_1__) {
                size_t A_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < A_limit_0__; ++i_0__) {
                    A[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            current_statement_begin__ = 7;
            current_statement_begin__ = 8;
            current_statement_begin__ = 9;
            current_statement_begin__ = 10;
            current_statement_begin__ = 11;
            current_statement_begin__ = 12;
            check_greater_or_equal(function__,"tau",tau,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 16;
            ++num_params_r__;
            current_statement_begin__ = 17;
            ++num_params_r__;
            current_statement_begin__ = 18;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 19;
            ++num_params_r__;
            current_statement_begin__ = 20;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_047a6166bd9c6ecaed4dd3733fae7c6b() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            T__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<T__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            T__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<T__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 24;
            validate_non_negative_index("gamma", "S", S);
            vector<T__> gamma(S);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma,DUMMY_VAR__);
            current_statement_begin__ = 25;
            validate_non_negative_index("k_s", "(S + 1)", (S + 1));
            vector<T__> k_s((S + 1));
            stan::math::initialize(k_s, DUMMY_VAR__);
            stan::math::fill(k_s,DUMMY_VAR__);
            current_statement_begin__ = 26;
            T__ m_pr;
            (void) m_pr;  // dummy to suppress unused var warning

            stan::math::initialize(m_pr, DUMMY_VAR__);
            stan::math::fill(m_pr,DUMMY_VAR__);


            current_statement_begin__ = 29;
            stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
            current_statement_begin__ = 30;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 35;
            stan::math::assign(m_pr, m);
            current_statement_begin__ = 36;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
                current_statement_begin__ = 38;
                stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < S; ++i0__) {
                if (stan::math::is_uninitialized(gamma[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < (S + 1); ++i0__) {
                if (stan::math::is_uninitialized(k_s[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: k_s" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(m_pr)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: m_pr";
                throw std::runtime_error(msg__.str());
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 24;
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;

            // model body
            {
            current_statement_begin__ = 43;
            validate_non_negative_index("Y", "T", T);
            vector<T__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);


            current_statement_begin__ = 46;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 47;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 48;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.10000000000000001));
            current_statement_begin__ = 50;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 53;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 54;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((get_base1(cap,i,"cap",1) / (1 + exp((-((k + dot_product(get_base1(A,i,"A",1),delta))) * (get_base1(t,i,"t",1) - (m + dot_product(get_base1(A,i,"A",1),gamma))))))) + dot_product(get_base1(X,i,"X",1),beta)));
            }
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("k_s");
        names__.push_back("m_pr");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((S + 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 24;
            validate_non_negative_index("gamma", "S", S);
            vector<double> gamma(S, 0.0);
            stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma,DUMMY_VAR__);
            current_statement_begin__ = 25;
            validate_non_negative_index("k_s", "(S + 1)", (S + 1));
            vector<double> k_s((S + 1), 0.0);
            stan::math::initialize(k_s, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(k_s,DUMMY_VAR__);
            current_statement_begin__ = 26;
            double m_pr(0.0);
            (void) m_pr;  // dummy to suppress unused var warning

            stan::math::initialize(m_pr, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(m_pr,DUMMY_VAR__);


            current_statement_begin__ = 29;
            stan::math::assign(get_base1_lhs(k_s,1,"k_s",1), k);
            current_statement_begin__ = 30;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(k_s,(i + 1),"k_s",1), (get_base1(k_s,i,"k_s",1) + get_base1(delta,i,"delta",1)));
            }
            current_statement_begin__ = 35;
            stan::math::assign(m_pr, m);
            current_statement_begin__ = 36;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 37;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), ((get_base1(t_change,i,"t_change",1) - m_pr) * (1 - (get_base1(k_s,i,"k_s",1) / get_base1(k_s,(i + 1),"k_s",1)))));
                current_statement_begin__ = 38;
                stan::math::assign(m_pr, (m_pr + get_base1(gamma,i,"gamma",1)));
            }

            // validate transformed parameters
            current_statement_begin__ = 24;
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < (S + 1); ++k_0__) {
            vars__.push_back(k_s[k_0__]);
            }
        vars__.push_back(m_pr);

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_047a6166bd9c6ecaed4dd3733fae7c6b";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (S + 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "m_pr";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (S + 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "m_pr";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b stan_model;

module_bytesB  MZ                @                                       	!L!This program cannot be run in DOS mode.

$       EG^&0&0&0^&0l{1&0:x3&0:x4
&0:x1&0:x5&0x1&0&1h'0x9 &0x0 &0x &0x2 &0Rich&0        PE  d	 RhY         "     2     <                               p         `                                       \     P      Lk           ` L  
                    h
 (   д
               P
                          .text                           `.rdata  2                    @  @.data                        @  .pdata  Lk     l   r             @  @.gfids  <                       @  @.tls    	    0                  @  _RDATA      @                  @  @.rsrc       P                  @  @.reloc  L   `                  @  B                                                                                                                                                H(H
 P A   H    H$ H݁     H
Ɓ   ' H
 H() H(H
5  A   H7    H H     H
   j' H
 H(( H(H
u  A   Hw    H H]     H
F ?  
' H
S H(B( H(d
 J  H(H(t
 mJ  H((
 ^x X H(4
 J  H(H(
 I  H( WA
 ! H(\
 I I W
 C H( X~ p H(H
   A   H    H H     H
   % H
 H(& H(H
%  A   H'    H H
     H
~ ~  :% H
 H(r& H(H
} ` A   H}    Ht H}     H
} }  $ H
 H(& H(H
   WH     H
; { H(% H(H
ś  WH     H
  H(% H(W" WH     H
"  H(Y% H(2  H
 H(?% H(H
 0 WH     H
k ˗ H(% H(H
ݗ  WHڗ     H
  H($ H(H
  WH     H
K ˙ H($ H( H
  H(_$ H( H
 H(?$ H(7  G
  TÜ
 f/
 v  "     X
 k T
 f/̓
 v  "   H(H(x H(H( H(; 髲  H(gx H(H
  8
 	 H($
 O H(H(
  H(H
} #   @SH HHHSH
! H3H
HJHH HH [H HHH% HQH	
 HHEH\$WH H HHH t
   HS" HH\$0H _3HAH	
 HAHh HHH(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH(! @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ H HHH0[@SH HHHSH
a H3H
HJHH Hl HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0 HT$0   HC   HsH{rHH  Hi$ @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" H HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HHL$pH3 L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtH'
 Hi@ uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIH? uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H} HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v H @H$   H3 L$   I[0Ik8IA^_^́aHI    ́aHI   H HH\$Hl$Ht$WAVAWH HrE3HLH(IDIHV HGAH+HHt6@ Ht
,HU HHH HGHH+HH;rM)IDHH\$@Hl$HHt$PH A_A^_U @USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtH
 <   H  HIHP   Hp  ) HIHPH

 H
 HEH  R HHb
 R HIV HH0
 R HIV HH
 iR HHV Hp  Hp   HHxrHH? HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H5 HD$ HQ~ HL$ % HIHP   Hp   H
 H  Q HHp
 Q HIU HH>
 Q HIU HH
 wQ HHU Hp  Hp   HHxrHHM HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 HC HD$ H_} HL$ #$ HMHT$HHPHT$PLL$HI+HLHFI+HH;  HL$p H 
 HMP HH] 
 P HIT HH+ 
 ~P HIT HH 
 dP (HMyR 3ۋHFH+HHt9D  Ht,HMPR HHHM HHFH+HH;r̲)HM!R Hj 
 HMO (HMR HD$PHL$HH+HHt<Ht,HMQ HL$HHHMm HHD$PHL$HH+HH;rĲ)HMQ Hp  HL$p8 HHxrHHl HD$ 3HD$(HD$0HL$8D$@HT$(HL$8	 Hb HD$ H~{ HL$ B" 3ۋH  IM+     HI9uHHH;r{  HMp- He H   N HH N HIR HHM N HIR HH N HH: HH kN LHUp/H H   LN (H   ^P HD$PHL$HH+HHtBHt,H   5P HL$HHH    HHD$PHL$HH+HH;r)H   O Hp  HMp HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8Y H HD$ Hy HL$   MtLD$XM+IIB H  H3
 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H HHHH\$@H0_H\$Ht$WH0HD$        IH HHHH\$@HpHHt$HH0_@SH H HHt
   6 HH [@SH H   H+ HH [H% HL$UVWAVAWH0HD$ H\$pILHHJ HHqHt$hE3L>L~K HH_H\$hL;L{K HL(L0L8L@LHLPLXL`LhI;t8HHRHI HH@HH HH@L~DD$`IH H;t9HHRHF HH@HH HH@L{DD$`HH޿ HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP Hw yI^I;^u3HIN; HI;FtHP HH yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP Hh tHHH;t-IM载 HH;tHP H9 yHHS@   IM落 HI}H;tHP H tHH;   HIMY HH;tHP H tHHS@HL$H轶 H|$PH\$HH+HHHL$0 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH IU(I IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP H yHHH;t*IO HH;tHP H yHHSX?IO IHH;tHP Hi yHH;tHIO IWXH H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP H yI_I;_t/HIO* HI;GtHP H yI_HS@IW@H苴 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI虺 HI;GtHP H yI_I;_t/HIOj HI;GtHP H yI_HSXIWXH; H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3 HGHH;tiD  HS H { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3 HGHH;tiD  HS H { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   HB HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+IC H_@H_HH_PHW(HtLG8L+I H_(H_0H_8LGHT$0MHOM  HO LGHT$0MHOM  HO` H\$8H HH _@SH LHT$0MHM T HH [ @SH LHT$0MHM 4 HH [
 HI H@SH H3 HHt
   
 HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH H HHt
   	 HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH H HHt
    HH [@SH H HHt
    HH [H(HID HHF H(H%v @SHPHD$ H H3HD$HHHHT$(H HHKD HHF  HD$@HrQHHL$(H=   r<ts HAH;rc H+HsS H'vF H HL$HH38  HP[H(HIC HH	F H(H% @SHPHD$ H H3HD$HHHHT$(H/ HHKC HHE * HD$@HrQHHL$(H=   r<t HAH;rs H+Hsc H'vV H HL$HH3H HP[H(HIC HHE H(H% @SHPHD$ H H3HD$HHHHT$(H? HHKB HHD : HD$@HrQHHL$(H=   r<t HAH;r H+Hss H'vf H HL$HH3X HP[H(HI B HH)D H(H% @SHPHD$ H H3HD$HHHHT$(HO HHK A HHC J HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vv H HL$HH3h HP[H(HI(#A HH9C H(H% @SHPHD$ H" H3HD$HHHHT$(H_ HHK(@ HHB Z HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v H HL$HH3x HP[@SH H HHt
0    HH [H HH H\$WH H HHH t
(   Hc HH\$0H _@SH HHHSH
a H3H
HJHH H HHH [H H@SH H HHt
    HH [@SH Hc HHH H HH [KA A H(HQHI> HH@ H(H%R @SH HHQHI> HH> HH@ H [H% H\$WH H HHH H Ht
0   H HH\$0H _23HHBHBH@SH HHRHK HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+IQ WD$0Hl$@@tHT$HHtLD$XL+I" HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWHe HL$8Ht HT$@~ LD$HHT$8L+I H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWH HL$8Ht HT$@@~ LD$HHT$8L+I H\$`HP_@SH H HHt
    HH [H\$Ht$WH HZ HH3HIPH*Ht:HSX HK`HH+KPHHLI?LHSP H{PH{XH{`HS8HtLCHL+I H{8H{@H{HHK Ht:HS(~ HK0HH+K HHLI?LHS  H{ H{(H{0HKHt)HS| HSLCL+I H{H{H{Ht$8H HH\$0H _@SH HYLHIHwx H;H [Hl$Ht$AVH0HHHQE3HIDt$ 5x H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHH蔶 Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ w H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQH顯 @SH0HD$     HQ8Hӵ HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0v I?HHD$0H;t?HHtLGL+Ih L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H HHHIVI+H*HHHH?HH;s(     IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   H2 HH\$0H _@SH  HD$HH H3H$p  ~ HH      HL$PG H HL$`- HH HH4  H$P  HL$Pw HxrH H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8J H HD$ HY HL$   H$p  H3 HĀ  [HL$WH@L_h HH
-h IL
3h LL+h IL6h M;s$K9<sIHH+g HLh L;rH\$XHt$hM;~  Hg HpHH;HBHHt$`hHg HHD$PHD$PH;sNH
g HD$PH;w=H\$PH+HH;{g uH
bg  H^g Ht;HJg HH
$H;Jg uH
1g  H-g Ht
HHg HHg Hz    H
g HD$`L
g H;sLHD$`L;wBH\$`I+HH;
f u   H
f  H
f L
f HtGIH0H;
f u   H
f  H
f L
f HtH1H
f L
vf Lf HH
lf HEf Ht$hH\$XJH8H
lf KHHVf H@_3HT HD$0HL$ H^ HD$(H HD$  HT$HL$WH@HD$ H\$hHD$X   H=e H|$`   dHD$PWfe 3He LD$Pq He Wfe LD$XH
ze ] He HNe H
HL$XH
we HHue Hve Wfse f{e He He fe H9u13HD$8HR HD$0H HD$(HzS HL$( HH\$hH@_H\$WH Hd 3H
d HH+HHt7D  HHtH Hd H
pd HHH+HH;rHd HH   Hd H+HH;v H    H=   r<tg HBH;rW H+HsG H'v: HH H
c WfDd H=5d Hd H   Hd H+HH;v H    H=   r<tл HBH;r H+Hs H'v HH H
8c Wfc H=c Hgc H   Hgc H+HH;vU H    H=   r<t9 HBH;r) H+Hs H'v HHx H
b Wfb H=b Hb H   Hb H+HH;v H    H=   r<t HBH;r H+Hs H'vu HH H
b Wfb H=b Ht}Ha H+HH;v2 H    H=   r<t HAH;r H+Hs H'v HX WH=a fva H\$0H _La L9a u0HIa Hna     HHLa Hma H HHXa I@IHH
aa H
ra HH/a HH
]a H
na HH#a HHa H
Ra @SH HHHSH
 H3H
HJHHs H HHH [@SH H IHHHA    HD$0H_ HL$0H;sdH_ HL$0H;wSH|$8H|$0H+HH;_ u   H
{_  Hw_ Hh_ HtHHH]_ H|$80H;W_ u   H
9_  H5_ Ht
HH&_ HHH_ H [H H@SH H HHـu
   ;HH [@SH@HD$ )t$0(HH_ HHH_ H;r_ r
   HHL$PHt
(3HH(t$0H@[HH3HM HD$0HL$ HB HD$(H HD$  H\$ WH H H3HD$3LA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HA,P  AO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3G H\$HH _kN  wN  N  N  N  N  N  AO  N  N  N  N  N  N  O  O  O  O  !O  *O  JO  SO  \O  eO  nO  uO   	
	
	
 	


	

@SH@eH%X   H)t$0(1
D>    )|$ (=\
 Hȋ
92Z    f]5]
 f_5b
 fYfX=[
 ffT=[
 f\(|$ ((fY
Y
 fY}[
 f\ff\fY (frfYfpc((fY%
Y
 fY
X
 fX%
Z
 fX
bY
 fYfYfX%R[
 fX
Z
 fY(t$0fYfX
%\
 f\f^fY%\
 fX%[
 fYf_H@[H
8Y  =,Y foX
 H
Y fX  @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH H HHـu
(   KHH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH"W HH(HW H;W r
(   HHt$@Ht*H?HOXKHH^H~ H5 HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^H_V HH(HQV H;BV r
(   HH|$`Ht&H(XKHNH_w HN HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(HWf.z
uI H^HU HH(HU H;U r
(   HH|$XHt&H(XKHH_w H HH>HH\$PHt$`(t$0H@_HIHII      AD$HD$I#I;w]HB HL$HD$I#I;wAB^XAAHJ HBAHYJY^A\AI      LAHB L@HA IYI@Y^@\@AVH0HD$ H\$HHt$PH|$XIHLH2T HH(H$T H;T r
(   HHt$@Ht*H?HK^OHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$XHt$`)t$0I(HHS HH(HtS H;eS r
(   HH|$PHt&H(^KHqwH_ H HH>HH\$XHt$`(t$0H@_AID$I      HD$I#I;w,HQ BD$HD$I#I;wB\ABHA H      HH@WH@HD$ H\$XHt$`)t$0I(HHrR HH(HdR H;UR r
(   HH|$PHt&H(\KHawH_ H! HH>HH\$XHt$`(t$0H@_HIHII      AD$HD$I#I;wHHB @D$HD$I#I;w,YBXAAHBHJ @YBXAAI      LAHB L@AVH0HD$ H\$HHt$PH|$XIHLH2Q HH(H$Q H;Q r
(   HHt$@Ht*H?HOYKHH^H~ HE HI6IH\$HHt$PH|$XH0A^HQIBD$HD$I#I      I;vH      HBB\AB@SH H  HHـu
    軹HH [@WH0HD$ H\$HHt$PHHH
P HH HO H;O r
    iHH|$@Ht%HKW
T
 HH_Hʚ HH>HH\$HHt$PH0_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH H  HHـu
0   軸HH [@SH HHHSH
 H3H
HJHH H HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3ۥ H HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$HT HHoHH$   Hp_^]H	H%. @USVWAVAWH$xH  HD$PH H3HEpMADHH   D$     H HD$`HM  D$    E3E3HT$hHL$`ɣ HD$`HcHH HD`HD$`HcHDxDD\   HL$h HHL$` HH  HHp  Hȋ HHF  HH  HȺ   d HH  HAI HI HH HUPHL$`U HxrH H
K HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H HD$(H]8 HL$(! @SH H   H HH [H%< @SH HHHSH
 H3H
HJHHc H< HHH [@SVWH  HD$8H~ H3H$  IHHDL$0HL$@蒩 H
 HL$P0 HHU H$  HL$@ӧ H$  H$  HC$  HǄ$X     3H$P  $@  8uD
IIB8uH$@  ( HǄ$x     H$p  Ƅ$`   A"   H~ H$`   H$@  HD$ L$`  LD$0HH; @UVWH  HD$0H$  H} H3H$  AAHH$  A|A@;   HL$@E H HL$P Hȋ$   H$`  HL$@聦 H$`  H$x  HC$`  HǄ$X     E3L$P  D$@  D8tIIB< uH$@   Hl$ L$@  DËHH$  H3 H$  HĐ  _^]@SVWH  HD$HHm| H3H$p  AHHHL$P7 HW HL$`
 HH3 
 HH HH 
 HH HHǿ 
 HȋW H$P  HL$P5 H$P  H$h  HC$P  H
[ HL$ 3HL$(HL$0HD$8D$@HT$(HL$8 H HD$ H%8 HL$ 1 @SH HHHSH
 H3H
HJHH HT HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu(@UVWHl$H   HEH$   HQz H3HE?HHHE7   3Hu/@uDFHo HM& HE   Hu@uDFHN HM HE   Hu@uDFH- HM H|$ LMLHUHM HEHrPHHMH=   r<t HAH;ru H+Hse H'vX H HE   HuE HEHrPHHMH=   r<t HAH;r H+Hs H'v H] HE   HuE HE7HrPHHMH=   r<t HAH;r H+Hs H'v H HLCL+IHMHM?H3a H$   HĠ   _^]( (
 D$T$f (fYfYfYfXv fX
~ fYfYfX~ fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX
 fYfYfX fX(f^((5 (
> D$T$f (fYfYfYfX& fX
. fYfYfX. fX
6 fYfYfX6 fX
> fYfYfX> fX
F fYfYfXF fX
N fYfYfXN fX(f^(H8W)t$ f/(vbWH
 
 
7@
 f/D$@   f.z$u"Y Y@
 X "   (t$ H8g X(t$ H8
 
?
 f/D$@wHf.z u @
  "   (t$ H8(t$ H8H%
 LD$@H6 艎 LD$@H$ w HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3r Hz HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHM IwHu@HH^H^uHtFHHHH;t?LLMt3 Iy HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHM I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHMG HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMH H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHX9
 LqWMHHEIHEI~Ht3@ Hw HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM\ LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHMg L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;t<IHHt3 Hu HELuH}LE7HUHM& LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHMpg HMޓ HMӓ L$   I[(Is0I{8IA_A^]LWH   H
6
 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tH Ht
H8t HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0; H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3ˑ Hs HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHMK I~H}@HH_uHt31 Hqr HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHM I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHM H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHXg2
 LqWMHHEIHEI~Ht3 HPp HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM, LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHM` LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM>b HML L$   I[(Is0I{8IA_A^]LWH   H
60
 f/   HA\I[3IsHq ICD$hH9rt"H
Ռ Ht
Hn HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0+ H$   HĀ   _@SH HHHSH
 H3H
HJHHC H HHH [AYAHAX@@@WH0HD$ H\$HHt$PHHHZ4 HH HL4 H;=4 r
    HH|$@Ht&HC
 (HDH_H HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HoH} HHGH+HH    H3 HHH
3 H;2 rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDH82 HH(H*2 H;2 r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHM HMHM j HELELEHM HMLHUNL+t	H
 HMi LHEHMHMHULL+t	H
 WD$PH}LHt3W Hi HHD$PH}HL$PLt$X3L;t-* HtHei HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$`v =*
    HEH   L   LD$PHH    H9V~EH,5
 5
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3 HtHh HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$`$ HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HUG HD$@HD$`H|$HHFH;t'H;tH Ht
Hf HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM HL$@5 HL$P) I HM HM	 HM HM L$`  I[0A(sA({IA_A^_^]@SH HHI( HK HH [H% H\$Ht$WH@HY)t$0Ha H\$PHHHJ()|$ H(e HLGLCHLGIL+LtH
 H\$XH~(|$ v Ht$`(t$0H@_H HHIH% @WHPHD$ H\$hHt$pH_ H3HD$HHHD$@   3Ht$8@t$(DFHQ HL$(苷 HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVHV HH;HKHtdHA   HqHyrHHH<H;Cu
   H HKHt(HA   HqHyrHHHT$(  貼 HC HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vr H HD$@   Ht$8D$( A
   H) HL$(W HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H  HH;HKHtdHA   HqHyrHHH<H;Cu
   Hݪ HKHt(HA   HqHyrHHHT$(  | HC HL$(-z HL$HH3耯 H\$hHt$pHP_H\$WH H_ HHHIe t
(   H賶 HH\$0H _Hs H@SH Hs HHt
   f HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHH~ H\$0HHHJa HLFLCHVLFIL+LtH
 HFH\$8HGHF Ht$@HG HH _Hy HH H\$WH Hwy HHH辚 t
(   HT HH\$0H _@SHPHD$ H[ H3HD$HHHD$@   HD$8    D$( A   Hc HL$(聳 HHHT$(PHD$@HrQHHL$(H=   r<t3 HAH;r# H+Hs H'v Hu HL$HH3 HP[HWH@H@HXHhHpIHHW@3HpVHH LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
R { IPL+IIHL+IM;HCH;HCHL$( LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
° D{ IPL+IIHL+IM;HCH;HCHL$(\ LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+I藥 H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xHX H3Hp  I((Hǅh     Hǅ`      ƅP   A   H HP  艰 HHPH0  S HP  H@   H(z HHI  H0  H0  聁 LHHAPHH  HrSHH0  H=   r<t| HAH;r| H+Hs| H'v| H" HM0虂 HǅH     Hǅ@      ƅ0   A H`  H0  e H0  HM@4 H(y HHv  HH  HrSHH0  H=   r<t| HAH;r| H+Hs{ H'v{ HX H0  HM08 LHHAPHH  HrSHH0  H=   r<t{ HAH;r{ H+Hsw{ H'vj{ Hٯ HL$0O HǅH     Hǅ@      ƅ0   A H`  H0   XH0  HL$@ H(ax HH?  HH  HrSHH0  H=   r<tz HAH;rz H+Hsz H'vz H	 H0  HL$0~ LHHAPHH  HrSHH0  H=   r<tGz HAH;r7z H+Hs'z H'vz H艮 HHPHM~ HMx H   ~ H   w H  e~ H  w Hh  HrSHHP  H=   r<ty HAH;ry H+Hsuy H'vhy H׭ Hp  H3X L$  I[A(sA({I]HUSWHHH  HD$ )p)xHT H3Hp  ((HHǅh     3H`  @P  DGH˘ HP  ϫ HǅH     H@  @0  E3Hɔ H0  蟫 HKHH0  P HH  HrSHH0  H=   r<tJx HAH;r:x H+Hs*x H'vx H茬 H0   ~ HP  H@   H(Hu HH  HKHH0  PHM0} HǅH     H@  ƅ0   A H`  H0  臩 H0  HM@V H(t HH  HH  HrSHH0  H=   r<t8w HAH;r(w H+Hsw H'vw Hz HKHHU0PHL$0| HǅH     H@  ƅ0   A H`  H0  貨 XH0  HL$@| H(s HH֖ 1 HH  HrSHH0  H=   r<t^v HAH;rNv H+Hs>v H'v1v H蠪 HKHHT$0PHǅH     H@  ƅ0   E3H, H0   HKHH0  P HH  HrTHH0  H=   r<tu HAH;ru H+Hsu H'vu H HMz HM{s H   y H   as H  y H  Gs Hh  HrSHHP  H=   r<tu HAH;rt H+Hst H'vt HF Hp  H3ǡ ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHH$` HHqHt$`3H.HnHcڅt3ps HT HH^HwHt$`H.HnHt3Ds HT HH^Ho(Hw0Ht$`H.HnHt3s HTT HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHHG_ HHrHyH|$hE3L'LgHt3r HS HHwLu HsHt$hL&LfMt3`r IS HLvHE(HC(L}8Ls0Lt$hM&MfMt3(r IhS IM~HUH HUH HU0I HH\$pHl$xH0A_A^A\_^H\$WH HHHH HC(HSHOHG( HS0HO0 H\$0HH _@UVWATAUAVAWHpHD$ H$   HPM H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHn[ HcH;U|H
 Tn EL9e#  IIf     HD$@   Ld$8D$( A   H HL$(覤 IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH^ HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH HwHtoHF   LfH~rHH  H{sLCItHHn 	HHL#HCHFHCHFHC   H{LcrH HG HL$Hg HL$(g AIcH;]}/H
 xl H
 jl H
 $l AH9u   I HD$@   Ld$8D$( A   H؏ HL$(膢 IIFH+HH;vJHLHT$(HL$H HH\ HL$Hf HL$(f HcH;]zH
 {k HL$hH3 H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHHa HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC׽ HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;ICY HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC藼 HSHt
HHH
HB   H
 &i H
 i LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
 ch H
ӝ Uh HL$VWATAVAWH0HD$ H\$hHl$xHcLHg II~@H|$pE3L'LgLgIHtIHHH;tǳHHHt3*j HjK HH_H_LHMI;~NL    
!

 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHi Mt
ITJ HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx HD H3HE`LHE3ADt$ HEX   LuP@}@EF H9 HM@ IE HU@IPHEXHrPHHM@H=   r<th HAH;rh H+Hsth H'vgh H֜ Aމ\$$H9^H  ML=[ Hd H
f HL$@HT$PHMyf |$ E3HT$XHL$@>f HD$@HcHH` HD@HD$@HcHhT<HD$XHD$0HL$Xc L|$XLuDuHF@BHL$Pe A   EL9vP~S@ ff     H~@H^HIIH HL$P Hd AIIcH;FP|Ë\$$|$ HU@HL$@k ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   HO HD$@HcHH^ HD@HD$@HcHhT<L=OZ L|$XHL$X谤 HL$Xd HL$`c HMd É\$$IHcH;FH}$E3Xf Qf Jf Cf HM`H3> L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0e HKe HKH [H%d @SH HH   Zc H   HLcBADuluHT$0<c H [&c H   HLcBADuLt2H [H\$WH HH   HT$0/ L   I HcHBDuT$0@:tIb 2H\$8H _ðH\$8H _@SH HHT$0H    L   I HcPBDt2H [L$0Ee tT$0HK H|$8[ H   HT$0,b HHcQDu@fD  L$0d u8L$0d u)T$0_t$.tH   a H|$8H [T$0HK +[ H   HT$0a HHcQDtH|$8H [@SH HHT$0H    H   HHcPD
uT$0"tF9a H   HT$0 H   HHcPD
uT$0't2a HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33;c l$H,c ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @` Hv_H~HHfff     I   _ HHu2Hv&H~HHfI   _ HHu2j@SH   HD$@H< H3H$   HHL$0HA    HyrHH  H   HT$ @_ HHcQDuAL$ a uL$  b T$ tHoX H   H   ^ HqH8 H$   H37 HĠ   [@SH HyHHA    rHH  HT$0H   ^ HHcQDufL$0Ba uL$0Ca T$0t6HW H   HT$08^ HHcQDtH*   H [H   ] H   H [H   HD$0HQ; H3H$   HL$ D H$   H3# HĘ   @SH   HD$0)$   H: H3H$   HHL$  (Wf.zu	H (H$   H3譌 ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5[ DH@ H   HUH0 HHcJD   UH:7   HD847uAH HEt
5
 5G
 HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKXY HS`HtHCXHH
HB  H   \ HvSHHHH   [ HvHu.Hv(HHHD  H   [ HvHuE3H( Hth
 HKXHUHEHQ   @2LsH{rHHD0HU@H   o[ HHcQDugH
     M@5^ U@uB<:w2Hs,@HT H   HU@[ HHcQDt
H   Z @u<HC`H+CXHu,HEtHK@EHHUHK HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKXd HS`HtHCXHH
HB%H;Chu   HKX6 HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5V	
 BH;Chu   HKXͅ HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0vY HLcBAD u!L$04\ uT$0H   6Y H   HT$8} L   I HcHBDuT$8-tDIX H   HT$8@2@ H   HHcPD
uT$8+tX @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(tYX 2H0A^H\$HHT$@Ht$XH|$( I   HHcPD
uT$@)   X IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@! IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINpR IVxHt:IFpHH
IFx   I;   u   INp IFxHtH0IFxkI;FPu	IN@g IFHHt0IFHHHl$PI   HT$@ I   HHcPD
uT$@)t#V 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INpA IVxHt7IFpHH
IFxI;   u   INp
 IFxHtL8IFxU@UH0HHT$@H    H   HHcPD
uT$@(tU 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   OU HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMX HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMp艀 HUxHt:HEpHH
HEx   H;   u   HMpR HExHtL0HExtH;Ehu   HMX) HE`HtL0HHE`HHt$PH   HT$@5 H   HHcPD
uT$@)t"S 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMpp HUxHt7HEpHH
HExH;   u   HMp< HExHtL8HExV@SH HHT$0H   F H   HHcPD
uT$0(tR 2H [HT$0H|$@
 H   HHcPD
uT$0)   R Ht$8HH   HT$0 H   HHcHDuT$0,tH   ?R Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKp} HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp} HSxHt@HCpHH|$@H
HCxH [H;   u   HKpP} HCxHtH8HCxH|$@H [H;   u   HKp} HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH    H   HHcPD
uU(tP 2H([]Ht$HHt AH|$PHH˄t
   AHp H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@A MM;~fHUHK@@ EȉE;}HCpHUHCxH    H   HHcPD
uU,tO Ht$H2H|$PH([]ò.H~tAHs Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8A ,Ht'HrHUHEHKpA ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp@ HMHHMH;v)Hh뒐HUHKps@ HEHHEH;s)H9`@UH0HHT$@H   V H   HHcPD
uT$@ct)M AHGr HḦ́tH0]HH0]AHn Ḧ́t
H0]AHr Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@7x HUHHt%HE@
H;EPu	HM@x HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@w HUHHt%HE@
H;EPu	HM@w HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@= Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+Iu H{pH{xH   HSXHtLChL+Imu H{XH{`H{hHS@HtLCPL+Id H{@H{HH{PHK CE HH\$0H _1E @SH0H3HQ D$ IE3HHC   HC蠁 HH0[@SH0HD$     HQpH> HH0[@SH0HD$     HQ@HS' HH0[@SH0HD$     HQXH> HH0[@SH   HD$@H' H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H   % L   I HcHBD   T$ <tII    -H   Hi   HǄ$      HǄ$       D$pA   Hm HL$p~ HD$pH$   HCD$pH
JS HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   I HA HD$PA;  Hm HL$P 2H$   H34x H   [HUATAUAVAWHl$H  HEHXHpHx H% H3HEpHLHMH6 HLiLl$03I} I} IE M|$L|$0I?I  II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIG* HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	蹟
 uH;s3H;t.LuLEI薢 LH HD$ LHT$0I H\$0HK@HT$8:/ HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  H} HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  H| HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  H| HT$hHtLD$xL+Iq^ WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$. HHT$8/ HM> HT$PHtLD$`L+Ian HT$8HtLD$HL+IFn HT$hHtLD$xL+I*n WD$hH|$xHUHQLEL+Im <\F UF NF GF @F 9F 2F +F $F F F F F F HMIHMpH3r L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+I(m H{H{ H{(HHtLCL+IT\ H;H{H{H\$0H _H\$WH HQ3HHtLA(L+Il H{H{ H{(HHtLCL+Il H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0J Hg HL$@8 Ht3HwHg HL$@ H;sHd HL$@ HH;rHf HL$@ HHA HHf ԰ HT$0HHD$0HcHH.< HD0HD$0HcHhT,H7 HD$HHL$H HL$HA HL$P"A H$   A HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tߋHHHt3BB H# LHD$(Lt$(H\$0H\$8HH~AL    M
. HIH;u(WHHH;|HMH;|HL$PH He HL$`D Ht3HnAHL$`? H;sHc HL$` HH;rHd HL$` HH? HHb  HH? HHd Ů HT$PIHD$PHcHH: HDPHD$PHcHhTLH5 HD$hHL$h HL$h? HL$p? H$   ? I@ IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   Hf H3H$  ILHH$   LL$83ۉ\$0HHYMt3;@ H{! HH~D$0   HǄ$      H$   Ƅ$    A   EHc H$   s HǄ$      H$   Ƅ$    EGHcc H$   s HǄ$      H$   Ƅ$    EGH>c H$   ys HHL$`_HD$ L$   L$   H$   IUYHT$`HtLD$pL+Ig WD$`H\$pH$   HrTHH$   H=   r<t? HAH;r? H+Hs? H'v? Ht HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<tY? HAH;rI? H+Hs9? H'v,? Hs HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t> HAH;r> H+Hs> H'v> Hs HǄ$      H$   Ƅ$    A
   H<a H$   q IL$   HT$xIPH$   HrTHH$   H=   r<t+> HAH;r> H+Hs> H'v= Hmr HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;v7= H    H=   r<t= HAH;r= H+Hs< H'v< H]q HH$  H3i H  A_A^_^[LSVWAVH  IǃXH H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFH_ IpIo HǄ$      L$   D$   EF
H^ H$   o HǄ$      L$   D$   EFH,_ H$   n LHHL$H[HD$ L$   L$   H$   HTHT$HHtLD$XL+Ic WD$HLt$XH$   HrTHH$   H=   r<t:; HAH;r*; H+Hs; H'v
; H|o HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t: HAH;r: H+Hs: H'v: Hn HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t>: HAH;r.: H+Hs: H'v: Hn HǄ$      L$   Ƅ$    A
   H\ H$   l HL$   HT$xHPH$   HrTHH$   H=   r<t9 HAH;r~9 H+Hsn9 H'va9 Hm HǄ$      L$   Ƅ$    DDHT$xHL$H蟻 HHHHHHJHCHBHKHJHCHBHKHL$H
8 HT$xHtL$   L+If` HH$  H3e H  A^_^[LWH   ICI[H H3H$   HHT$ IC   3I{@|$pDG
H[ IKhk HD$h   H|$`@|$PDGH[ HL$P?k LHT$pHL$P( HD$hHrQHHL$PH=   r<t7 HAH;r7 H+Hs7 H'v7 H/l HD$h   H|$`D$P H$   HrQHHL$pH=   r<t{7 HAH;rk7 H+Hs[7 H'vN7 Hk HǄ$      H$   D$p A
   HY HL$p-j HD$h   H|$`D$P A   HZ HL$Pj LHT$pHL$P% HD$hHrQHHL$PH=   r<t6 HAH;r6 H+Hs6 H'v6 Hj HD$h   H|$`D$P H$   HrRHHL$pH=   r<t>6 HAH;r.6 H+Hs6 H'v6 Hj H$   H3b H$   HĠ   _@SH   HD$HH H3H$   HHT$ HD$h   HD$`    D$P A
   HHX HL$Ph HǄ$      HǄ$       D$p A   HCY HL$pah LHT$PHL$p辺 H$   HrQHHL$pH=   r<t5 HAH;r4 H+Hs4 H'v4 HNi HǄ$      HǄ$       D$p HD$hHrRHHL$PH=   r<t4 HAH;r4 H+Hss4 H'vf4 Hh H$   H3Ta HĠ   [AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ D AXA((yXA@^A(]\A(\YYAX(qS
 K8W
 Ys ^C0\(!
 D\YDYCDX(DC
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hH H3HD$0HHHT$(H, HHHA   3HqHyrHH@0IE3f Hs(Hs0s8s@C<H6* HHL$0H3_ H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH+
 H3Hp  DHH  f  LAHV HP  L LU HH0   LHHAP HH  HrSHH0  H=   r<t1 HAH;r1 H+Hst1 H'vg1 He HǅH     3H@  @0  Hh  HrSHHP  H=   r<t1 HAH;r	1 H+Hs0 H'v0 H[e HǅH     H@  ƅ0   A&   HT H0  c HH0  HP HH  HrSHH0  H=   r<tu0 HAH;re0 H+HsU0 H'vH0 Hd HǅH     H@  ƅ0   E3HRL H0  (c HH0  HP HH  Hy  HH0  H=   r<t/ HAH;r/ H+Hs/ H'v/ Hd !  C  3A;  HǅH     H@  @0  DG9HS H0  fb HH0  HP HH  HrSHH0  H=   r<t/ HAH;r/ H+Hs. H'v. HTc HǅH     H@  ƅ0   A   HFS H0  a L0  H;S HP  Ǭ LHHAP Hh  HrSHHP  H=   r<tV. HAH;rF. H+Hs6. H'v). Hb Hǅh     H`  ƅP   HH  HrSHH0  H=   r<t- HAH;r- H+Hs- H'v- Hb Dv(WI*(Y H,ȉN,Y
 H,F0D+D+Dv4Hǅh     H`  ƅP   A9   H R HP  T` HHP  HP HP  $ Hǅh     H`  ƅP   A/   HR HP  ` HHP  HP HP  v$ H0  2 HR H@  V HȋV,* HH0  HPHM02 HQ HM@  HȋV4) HHU0HPHL$0M2 HQ HL$@ HȋV0) HHT$0HPHǅh     H`  ƅP   E3H<H HP  _ HHP  HP HP  # HMj0 HM) H   S0 H   ) H  90 H  ) Dv(DF,DN0N4~8N@AAF<Hp  H3mX L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   HP HH^ HT$(HH| HHOH6HH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHIK8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKH讕,CHE3L%+ fnHGLH(X^^Y% L9G~   0 MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKH衐C8L|$ Lt$PHl$@H(_[ÍAC82H(_[H  @SH A HB HHHR HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLHE IIv@H$   3H>H~Ht3p' H HH^ D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$Hg IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tH& Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@i H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx H H3HEPLLHEH   HE@    E0 A)   H#L HM0zY IHU0IPHEHHrPHHM0H=   r<t/& HAH;r& H+Hs& H'v& HqZ HL$0+ IF@HL$@;#    I9vH~:~D  I^@HIF HL$@[ H# HHcI;FH|HU0HL$0) MHIAPHEHHrQHHM0H=   r<tU% HAH;rE% H+Hs5% H'v(% HY HD$0HcHH. HD0HD$0HcHhT,H HD$HHL$Hb HL$H" HL$P"" HM" HMPH3Q L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   HD HHYW HT$(HH# HHOH&HH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHIvK8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKHo,CHLOLH|$Hf % fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^Y L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0謓 HKHC8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A H= HHHR
 HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pH H3HEHHE   3H}@}DG<HGG HMnT HHUHP HEHrPHHMH=   r<t#! HAH;r! H+Hs! H'v  HeU HE   H}E A   HF HMS HHUHP HEHrPHHMH=   r<t  HAH;r  H+Hst  H'vg  HT HE   H}E AC   HF HMPS HHUHP HEHrPHHMH=   r<t  HAH;r H+Hs H'v HGT HE   H}E A/   HBF HMR HHUHP HEHrPHHMH=   r<tv HAH;rf H+HsV H'vI HS HE   H}E A<   HE HM2R HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H)S HE   H}E E3H: HMQ HHUHP HEHrPHHMH=   r<t[ HAH;rK H+Hs; H'v. HR HE   H}E E3HA: HMQ HHUHP HM HMH3J H\$hH|$pHP]@USVWATAVAWH$ H  HD$HH H3H   ىL$@DD$0DL$8LH  LP  HX  Hǅ      3H   @}pDGH4D HMp[P HEh   H}`@}PC MA!HC HMP*P    Hǅ      H   @   DGHeQ H   O Hǅ      H   @   DGHQ H   O H   HD$ L   LD$@HUpHMP& HEhHrPHHMPH=   r<t] HAH;rM H+Hs= H'v0 HP HEh   H}`EP H   HrPHHMpH=   r<t HAH;r H+Hs H'v H2P Hǅ      H   ƅ    A   HB H   N Hǅ      H   ƅ    'B MA!HB H   cN H    H    HEh   H}`EP A   H4B HMP#N Hǅ      H   Ep A MA!HA HMpM LD$0HUPHMp HMp_ HMPU HEh   H}`EP A   HA HMPM Hǅ      H   Ep )A MA!HA HMphM LD$8HUPHMpU HMp HMP |$0fnp
 p
 D,L$8  ;tCt
Ù   HL$P IHL$`誊 HA HL$`i IcHMP\ HHL$`ϡ Hȋ HH@ 5 Hȋ kd   HMP HH@ HL$` HHt Hȋ HH@ څ H@ HL$`Ʌ IHL$` HHT$PHPHM HM
 H   H3E H  A_A^A\_^[]@UVWAVAWHl$H   HEH$   H H3HE/IHLHE   E3L}D}EGH? HM~K HE   L}D}HD8?uE
LIB< uHHMFK LHUHM HEHrPHHMH=   r<t HAH;r H+Hs H'v H:L HE   L}E HEHrPHHMH=   r<t HAH;r~ H+Hsn H'va HK HE'   L}E A   H> HMJJ HE   L}E A   H> HM#J HE   L}E ? u
I     HÀ< uLHHMI LFIcN(L;tL$ LMHUHM HEHrPHHMH=   r<t HAH;rx H+Hsh H'v[ HJ HE   L}E HEHrPHHMH=   r<t HAH;r H+Hs H'v H`J HE   L}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HI HM/H3zB H$   HĠ   A_A^_^]@USVWAVHl$H   HEHF H3HE/IHLHE   3H]]DCH< HMH HE   H]߈]8uDIIB< uHHMG LHUHM՞ HEHrPHHMH=   r<t HAH;r H+Hsx H'vk HH HE   H]E HEHrPHHMH=   r<t. HAH;r H+Hs H'v HpH HE   H]E A   H; HMF HE   H]E ? uLIIB< uHHMF LHUHMT HEHrPHHMH=   r<tg HAH;rW H+HsG H'v: HG HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H?G HE'   H]E A   Hr: HME HE   H]E A   Hk: HME HE   H]E ? uLI IB< uHHMZE HFEF(D;tHD$ LMHUHM膠 HUHrHA   HMi$HE   H]E HM	 HM	 HE   H]E A   Hy9 HMD HE'   H]E ? tHfD  HÀ< uLHHMD LHUHM HM
	 HM	 HM/H3W> HĠ   A^_^[]HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt3 HE HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHMP LvLu@II^I^uHtFHHHH;tXLLMt3@ I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHMO ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+te
 II^H\$XH    HC    HC    HtFHHHH;tWHHHt3
 H( HH{H{LHSE3L9C~JL    
ݰ 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH0HD$ H\$`MHHHJs HHHFHGHHFLL+tld
 H_H\$XININ8 HHIFHCIFHCIIFIFLL+t$d
 HFG(LH5 HMH5 HHH\$`H0A^_^H\$Ht$WH`HLHl5 HlHHs3HD$ HGH;t'H;tH/ Ht
Hj HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@	 H\$xH$   H`_H\$Hl$VWAVH`HLH4 HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH
 Ht
H1 HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@Ȉ L\$`I[(Ik0IA^_^SH\$UVWHHpHcy(3H)t$`WuH9yt"H	
 Ht
H? HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM{J Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tH	 Mt
IV HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHMxI H$   Hp_^]QHUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;teQLLMt3 I HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHMJ WEIHEIHt3 H\ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHMI LEHUI4HM HMv IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;tEOLLMt3 I HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHMI WEIHEIHt3 H> HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHM(I LEHUIHMd HMY IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HEHXHp H H3HE'LHHE   3H]]DCHb- HM7 HE   H]׈]DCHV- HM7 HE   H]], MA-H, HM}7 AD$(DF(D;tD$ LMHUHM| HEHrPHHMH=   r<t HAH;r H+Hs H'v H^8 HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H7 HE   H]E HEHrPHHMH=   r<tH HAH;r8 H+Hs( H'v H7 I$HEI|$HFH;t'H;tH Ht
HI HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~HE(A)HH;}LEMHM H~ID$HEM|$L}Md$ HOI;uL9gt`Mt$MtHHIL;tJMMHOL;tH  Mt
I[ HHLLgHHMLGLEHEHEHEHEHEHEH}LGIHH+HHHH~ D  HE()HH;}HMHM~ HHM'H3m. L$   I[@IsHIA_A^A\_]@UVWHl$H   HEH$   H1 H3HE7HHHE/   3H]']DCH) HM4 HE   H]]DCH) HM3 HE   H]]) MA.Ht) HM3 F(DG(D;tD$ LMHUHMQx HEHrPHHMH=   r<tT  HAH;rD  H+Hs4  H'v'  H4 HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H,4 HE   H]E HE/HrPHHMH=   r<t
 HAH;rp
 H+Hs`
 H'vS
 H3 HHMLLEHEHEHEHEHEHE'H}/LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHMr HOLFLEHFHEL	LMHAHEHUHUHUHUHUHU'HM/LQLIHH+HHH~+     A(fAXA)HH;}
LELMMHHM HHM7H3/+ H$   Hİ   _^]@UVWHl$H   HEH$   H H3HE?HHHE7   3H]/]DCHX& HM0 HE   H]]DCHL& HM0 HE   H]]t& MA.Hd& HMs0 F(DG(D;tD$ LMHUHMu HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HV1 HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v}
 H0 HE   H]E HE7HrPHHMH=   r<t@
 HAH;r0
 H+Hs 
 H'v
 H0 H}HHMLLEHEHEHEHE'HEHE/HEHE7LOIHH+HHHHH~% A(f^A)HH;}
HMLEMHMr HOHMLFLEHFHEL	LMHAHEHEHEHEHE'HEHE/HEHE7LQLQIHH+HHH~2@ fff     A(fA^A)HH;}
LELMMHHM HHM?H3' H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM^ LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMH HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHMk HH\$xH`]H\$Ht$WHPeH%X   H#    )t$@HЋ9    HcF(3HfnY5Y ~nHFHl$`Hn)|$0= H4   D)D$ EWf     HH(TfA.zt	)N
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
 ?& =  Dƃ H
 X_ Yǘ  % @USVWAVHl$H   HEH H3HE/IHLHU3ۉ]HE   H]]DCH HM) HE   H]]DCH HM) HE   H]] MA-H HM^) LFIcN(L;tL$ LMHUHM~ HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H@* HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hst
 H'vg
 H) HE   H]E HEHrPHHMH=   r<t*
 HAH;r
 H+Hs

 H'v
 Hl) HE   H]E A   H7 HM' HE   H]E  MA-H HM' LHUHMt HEHrPHHMH=   r<tg
 HAH;rW
 H+HsG
 H'v:
 H( HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H?( IFHEHuEELuHH_IvHt3
 H HHwHUHM3 IHEIvHGH;t'H;tHy
 Ht
H HHHwLLEHEHEHEHEHEHEH}LOIHH+HHHH~3fff     HEHHE(fXA)HH;}LEMHM6 HM
 HHM/H3 H   A^_^[]@SH HHI
 HH [H%
 HT$WH0HD$(H\$@HHD$     IHHH$   HKA
 H8
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJD HHHGHFHHGLL+t=H
 H^H\$HHOHO 	 HHHGHCHG HCHWHGHG LL+tG
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHHHK!
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHGHOd
 H[
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3
 I> HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHM{/ HwHu@HH^uMt3a
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHM. Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ HHIFHFIIFLL+tD
 InH~H$   3HH_WD$(Ht3N
 H HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$H- IFF HHpA^_^][@USVWAVHl$H   HEHv H3HE/IHHHMHJ HHHGHFHHGLL+tC
 LvLuHK| HIHCIFHHCLL+tuC
 HGF HE   3H]]DCHe HM HE   H]߈]DCH HM HE'   H]] MA#H HM HFDF D;tHD$ LMHUHMz HE'HrPHHMH=   r<t'
 HAH;r
 H+Hs
 H'v
 Hi  HE'   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 H HE   H]E A   Hh HM HE   H]E O MA#H? HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hsp
 H'vc
 H HE   H]E HEHrPHHMH=   r<t&
 HAH;r
 H+Hs
 H'v
 Hh HE   H]E A   H HM HE   H]E " MA#H HM MHUHMp HM&  HM  HHM/H3l Hİ   A^_^[]@UVWHl$H   HEH$   H1 H3HE7HHHE   3H]]DCHp HM HE/   H]']DCHl HM HE   H]]| MA+Hl HM LGHcN L;tL$ LMHUHMp HEHrPHHMH=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 H HE   H]E HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H+ HE/   H]'E HEHrPHHMH=   r<t
 HAH;ro
 H+Hs_
 H'vR
 H HE   H]E A   H HM; HE   H]E  MA+H HM
 LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tR
 HAH;rB
 H+Hs2
 H'v%
 H HHEHHFH;t'H;tH
 Ht
HU HHH~HHMHEHEHEHEHEHEHuLFIHH+HHHH~'@      HE()HH;}HMHMb HM7H3p H$   Hİ   _^]@UVWHl$H   HEH$   H1 H3HE7HHHE   3H]]DCHp HM HE/   H]']DCHl HM HE   H]] MA.H HM LFHcO L;tL$ LMHUHMl HEHrPHHMH=   r<tS
 HAH;rC
 H+Hs3
 H'v&
 H HE   H]E HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H+ HE/   H]'E HEHrPHHMH=   r<t
 HAH;ro
 H+Hs_
 H'vR
 H HE   H]E A   H HM; HE   H]E 
 MA.H HM
 LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tR
 HAH;rB
 H+Hs2
 H'v%
 H HHHEHvHGH;t'H;tH
 Ht
HQ HHHwHHMHEHEHEHEHEHEH}LGIHH+HHHH~#     HE()HH;}HMHM^ HM7H3p H$   Hİ   _^]H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	,
 Ht
Hg HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHM  Hcw HuH9wt"H
 Ht
H HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHM (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 Hʿ HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHMB! WEHHE'H~Ht3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHM  LEHUIHM1
 HM&
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHM  WEHHE'H~Ht3
 HL HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM8  LEHUIHMt
 HMi
 IL$   I[(Is0IA^_]HUWAVHhH   HEHXHp H H3HE7LHHE   3H]]DCHv HM HE   H]]DCHj HM HE/   H]'] MA.H HM AF DF D;tD$ LMHUHM.S HE/HrPHHMH=   r<t1
 HAH;r!
 H+Hs
 H'v
 Hs HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H	 HE   H]E HEHrPHHMH=   r<t]
 HAH;rM
 H+Hs=
 H'v0
 H IHEI~HFH;t'H;tH%
 Ht
H` HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~ @ HE(A)HH;}LEMHMW H~IFHEMvHGI;t'L;tHy
 Mt
I费 HHLwHHMHEHEHEHEHEHEH}LGIHH+HHHH~&fff     HE()HH;}HMHM\V HHM7H3 L$   I[0Is8IA^_]@UVWHl$H   HEH$   H H3HE7HHHE   3H]]DCH  HMg HE   H]]DCH  HMC HE/   H]']l MA/H\ HM F DG D;tD$ LMHUHMO HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE/   H]'E HEHrPHHMH=   r<tJ
 HAH;r:
 H+Hs*
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H" HHMLLEHEHEHEHEHEHEH}LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHMҨ LGHNHMMLMHEHEHEHEHEHELEM@IHH+HHH~.@      (fAXA)HH;}
HMLMHHMR HHM7H3 H$   Hİ   _^]@UVWHl$H   HEH$   Hq H3HE?HHHE   3H]]DCH HMG HE   H]]DCH HM# HE7   H]/]| MA/Hl HM F DG D;tD$ LMHUHML HE7HrPHHMH=   r<t
 HAH;r
 H+Hst
 H'vg
 H HE7   H]/E HEHrPHHMH=   r<t*
 HAH;r
 H+Hs

 H'v
 Hl HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H H}HHMLLEHEHEHEHEHEHEHEHELOIHH+HHHHH~% A(f^A)HH;}
HMLEMHM HGHEHNHML LEHUHUHUHUHUHUHUHULHIHH+HHH~&@ A(f^A)HH;}
HMLEMHHMo HHM?H3 H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHM{ HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM计 HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM+ HH\$xH`]@SH@Hy HQHuWHHL$ HD$ HT$0 (fnC 
H\ X
q YLq YXH@[HUVWAVAWHhH0  HD$PHX )pH[ H3HEMHHHT$@3|$4HE   H}@}DGH HM$ HE   H}@}DGH HM HE   H} @} MA.Hw HM IGDF D;tHD$ LMHUHM\ HEHrPHHMH=   r<tm
 HAH;r]
 H+HsM
 H'v@
 H HE   H} E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HE HE   H}E HEHrPHHMH=   r<t
 HAH;r
 H+Hsy
 H'vl
 H HE   H}E A   H HMU  HE   H}E  MA.H HM$  MHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H}E HEHrPHHMH=   r<tl
 HAH;r\
 H+HsL
 H'v?
 H  H;H{LvMt3>
 I~ HLsIHD$pHFHEHHEHvL;t'I;tH
 Ht
H< HH;HsHHEHEHEHD$`HEHD$0HEH]LsIHH+HHHH~BHE(4HE()D$@HL$@!HD$p(fYfXHM)4HH;|MHHM HHMH30 H$x  ($   H0  A_A^_^]HT$WH0HD$(H\$@HHD$     IH/HH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+t 
 H_H\$HHN讪 HHHFHCHVHFLL+t 
 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHH$HK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     I"HHHO
 H{
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHO$
 H
 HH\$@H0_HW  @SH0HD$     HQH胺  HH0[H\$WH HHQHtLAL+I  3HCHCHCH H@t
    H HH\$0H _@SH HQHHt.LAL+I  3HCHCHCH HH [H HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXH?
 D$(HD$0HT$83HL$ HD$8HD$@HP HD$ 
 Hf Hd HD$0HL$0 H\$WH HHQ HtLA0L+I  3HC HC(HC0H H@t
8   He HH\$0H _@SH HQ HHt.LA0L+I>  3HC HC(HC0H! HH [H HH [@SH HHHSH

 H3H
HJHH
 HT HHH [HAHH`HAHH`H\$WH H/ HHAH蝽  H~ HGHt
8   HU HH\$0H _@SH Hӹ HHAHC  H$ HCHH [@SUVWATAUAVAWHxHD$(Hg H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HHf HHHL$ H# HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ H
 HIFHAIFHAIFHAH IV   Ht HHN  L-ɳ L.HW IGIOʻ  MoM/H  I  IV HtMF0L+I  3IF IF(IF0M.HHL$`H3 HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+I  H{pH{xH   HK8]  HS HtLC0L+IT  H{ H{(H{0H9 HH\$0H _H\$WH H,   t
  H HH\$0H _H\$Ht$WH H  HHt*L  L+I  3H  H  H  H5 H   H  HKpH= HKPH{@聸  Hs@HKHs8H{l  HsH3H\$0Ht$8H _HL$SH0HD$ HHk HLALD$HH I HBI@HIHHA   HA    HyrHH  IE3  HH0[HL$WH0HD$ H\$PHHH HHBHAHBHAHBHAH H 裱  HO8HL$HH HHC@HAHCHHAHCPHAHSXH   HSpHOp\  HH\$PH0_@SH HHI HtCHS(y LC0H*L+C IHLI?LHS   3HC HC(HC0H HH [H\$WH Ht
   Hb HH\$0H _H\$WH H<t
8   H" HH\$0H _H\$Ht$WH HHHH5
 + HHv * HH
 * HHW/ HH(1 
 H'
 H* HH9 * HH
 * WPHP
 HH0 `
 H
 Hy* HH j* HH
 [* H
 HH0 
 H
 H1* HH "* HH
 * WHϺ
 HHM0 Ϻ
 O|tttt3   H
 H) HHi ) HH
 ) Hȋn
 HH/ f
 O|  [  	  H
 Ha) HH R) HHt
 C)    H
 HHz/ 
 Hy
 H) HH ) HH(
 (    H
 HH./ 
 He
 H( HH ( HH$
 (    Hl
 HH. d
 HY
 H}( HH[ n( HH
 _(    H 
 HH. 
 Hm
 H1( HH "( HH4
 (    H
 HHH. ʸ
 H/
 H' HH ' HH.
 '    Hl
 HH- |
    tB  H
 H' HH r' HH
 c' H   H
 HH' HHV 9' HH
 *' H+ W  L   H?K H
 H ' HHN & HHS
 &    H
 HH- 
           H H& HH & HH= t& HH* e& HH, -
 L   H6K L   HK L   HH J L   HK L   HH I L   HK L   HH GI #  H
 H% HH % HH
 % HH % HH+ ^
 L   HgJ L   HJ L   HH I L   HJ L   HH* H L   H.K j  HF
 H
% HH $ HHm
 $ HM   H
 H$ HH $ HHl
 $    Ht
 HH* l
 H
 H$ HH v$ HHH
 g$    H
 HH* 
 HT
 H8$ HHz )$ HH
 $    H۴
 HHQ* Ӵ
 L   HH Ha
 H# HH3 # HH
 #   Hf
 HH) v
 H;
 H# HH # HH
 q#   H
 HH) (
 H
 HA# HH 2# HH
 ##    H˴
 HHY) ۳
 H@
 H" HHz " HH?
 "    H}
 HH) 
 H
 H" HH< " HH
 "    H/
 HH( ?
 H
 HX" HH I" HH
 :"    H
 HHo( 
 H
 H
" HH ! HHE
 !    H
 HH!( 
          tB  H
 H! HH| ! HH
 x! H   H9
 H]! HHC N! HH
 ?! Hp l  H8
 H$! HH
 ! HH/
 ! HH   HH=' 
 L   HH aE   H
 H  HH   HHp
     H`
 HH& X
    tzt?   Hd
 HX  HH> I  HH+
 :  HC jH
 H"  HH   HH
   H 4H
 H HH  HH
  H H H& H
 y tIHV H HHh  HH | HHWX# HH% 8
     tLHD HH HH& 9 HH * HH   K# HHa% 
 H( H HH  HH  WxH
 HH% 
 Hֽ
 H HH$ H\$0Ht$8H _H%j
 H%
 @WHPHD$ H\$hH͌ H3HD$HHHD$@   3H|$8@|$(E3H HL$(  HT$(H蓶  HD$@HrQHHL$(H=   r<tT
 HAH;rD
 H+Hs4
 H'v'
 H H   H   H  HHL$HH3 H\$hHP_@UVWATAUAVAWHl$H   HEH$   Hɋ H3HEA؉]HLHUE    A}NH>
 HE3HEHEH1 HEEHUHMۮ
 H4 HEHQI HM H    HB    HB    E   HE   HE    E A   H HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtHu 
 u
HJ  H{rHHA   I;LBMtHB 
 u
H  H{rHHA   I;LBMtH x
 uDHu>LFIH+HgfffffffHHHH?H  IHd  HF   H{H{rHH?A   I;LBMtH H
    Hs	3Hu{A^HE   HE    EIE3HUHM{  ]HUH܂  HM¥  3IV(HEH;tIE3HMC  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHM  DmHUH  HM  HEHrPHHMH=   r<t+
 HAH;r
 H+Hs
 H'v
 Hm HNH
 HE3HEHEH HEEHUHM6
 H HEHE HMq HMH3 H$   Hİ   A_A^A]A\_^]  @SH HH(  HKH [  @UVWATAUAVAWH$@H  HD$8H$  H% H3H   MH=7 HL$@  HHPHH) HL$P HHt }H HL$P^ z  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<H HL$P  HHS$ HH  HHD$ T
 HL$(Lt$ I+IHHLI?LAxoIcH<HL@ ff     K4Hu HL$P{ HH HH> a HBT7 #
 Md$HAxLt$ H> HL$P, HHr 
 HL$ Ht2HT$(c HL$0H+L$ IHHLI?LHT$ O  HU`HL$@葮  H8= tSHEX   HEP    E@ A	   H HM@
  LE@HU`H   |  HB H    H= tSHEX   HEP    E@ A   H\ HM@  LE@HU`H   z  H: H   9 H< tSHEX   HEP    E@ A
   H
 HM@L  LE@HU`H   x  H; H    H< tSHEX   HEP    E@ A
   H HM@  LE@HU`H   v  HD H   { H< tXHE`H}xHCE`H
;
 HM@3HMHHMPHD$ D$(HUHHL$ ܦ
 H HE@HF HM@ H< tXHE`H}xHCE`H
ׯ
 HM@3HMHHMPHD$ D$(HUHHL$ x
 H) HE@H? HM@ Ht< tXHE`H}xHCE`H
s
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@HD HM@O HP< tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H&; HM@ H,< tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ L
 H HE@H= HM@ H< tXHE`H}xHCE`H
G
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H> HM@# H; tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H
 HE@H:: HM@ H; tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$  
 H HE@H; HM@[ H; tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H2> HM@ HEX   HEP    E@ A   H HM@  LE@HU`H   p  H:< H    HL$WH0HD$ H\$HHHHS
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHHë
 HHQ3HHBHKq
 HA
 HHSHOHA   HA    HyrHH  IE3   HH\$HH0_HL$WH0HD$ H\$HHHH3
 HHQ3HHBHK
 Hɛ HHSHOHA   HA    HyrHH  IE3p  HH\$HH0_@SH HHHSH
 H3H
HJHHc
 H HHH [HL$WH0HD$ H\$HHHHc
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_@SH HHHSH
 H3H
HJHH
 H HHH [@SH HHHSH
 H3H
HJHHS
 H HHH [@SH HHHSH
a
 H3H
HJHH
 H HHH [@SH HHHSH
!
 H3H
HJHHӟ
 H\ HHH [HL$WH0HD$ H\$HHHHӨ
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH H HHH>  H?
 HOHj
 t
8   H HH\$0H _H\$WH H
 HHHޗ  Hߧ
 HOH

 t
8   H HH\$0H _H\$WH HO HHH~  H
 HOH
 t
8   H0 HH\$0H _H\$WH H HHH  H
 HOHJ
 t
8   H HH\$0H _H\$WH Hψ HHH辖  H
 HOH
 t
8   Hp HH\$0H _@SH0HD$ HH HHe
 HA(H0
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HH HH
 HA(H0(
 H HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH HH
 HA(H0
 H HHKHtHP tHC    H0[@WH0HD$ H\$@HH8 HH
 HA(H0H
 H9 HHKHtHP tHC    @t
@   H HH\$@H0_H\$WH HH HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   T L   H988L  M+IHLI?LI  3H   H   H  H   ؠ  H   H [H%E
 HL$SH0HD$ HH HE3LAHpH` HLC0LC8LC@LCHLCPLCXLC`LChLCpL   L   L   L   L   L   L   L   L   L   L   H   HH0[LWATAUAVAWH@  HD$hI[Is A)sHHv H3H$(  HHT$0HWD$PE3Lt$`D$8Lt$H&    Iǃ8   M0D$  EFH I   HǄ$      L$  D$  EFH[ H$    HǄ$     L$  D$  EFH H$  y  H$  ˹HD$ L$  L$  H$  HUH$  Ht(L$  L+I  W$  L$  H$  HrTHH$  H=   r<t˙
 HAH;r
 H+Hs
 H'v
 H
 HǄ$     L$  Ƅ$   H$   HrTHH$  H=   r<tM
 HAH;r=
 H+Hs-
 H'v 
 H HǄ$      L$  Ƅ$   H$  HrTHH$  H=   r<tϘ
 HAH;r
 H+Hs
 H'v
 H Ds(HǄ$     L$  Ƅ$   A   H$ H$  w  HL$  H$  HP(HHD$PH;t'H:H|$PHJHL$XHBHD$`L2LrLrH|$PH$  Ht(L$  L+IӮ  W$  L$  H$  r  C(o#    HǄ$      3H$  @$  DGHγ H$    HǄ$     H$  @$  DGH H$  h  HǄ$     H$  @$  DGH H$  3  H$  腶HD$ L$  L$  H$  HH$  Ht(L$  L+I]  W$  H$  H$  L  H$  >  H$  0  {,HǄ$     H$  Ƅ$   A   H H$  g  HL$  H$  HP(HHL$P`  H$  Ht(L$  L+I  W$  H$  H$  莍  HD$PK,!    HǄ$     H$  Ƅ$   A   Ha H$    HǄ$     H$  Ƅ$   A   H
 H$  }  DC(EyH$  H$  H$    H$  Ҍ  HǄ$      H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   Hb H$    HǄ$     H$  Ƅ$   A   H H$    HcS(H$  HD$ L$  L$  H$  HvH$  Ht(L$  L+IĻ  W$  H$  H$  賋  H$  襋  H$  藋  HǄ$     H$  Ƅ$   A   H~ H$    HǄ$     H$  Ƅ$   A   H' H$    DC(EyH$  H$  H$    H$    W$  HcS(W$  H$  L$  H$    H$  HK0蕇  H$  HtL$  L+It  HǄ$     H$  Ƅ$   A   HK H$    HL$  H$  HPHHL$8  H$  Ht(L$  L+I  W$  H$  H$    LLcS(LL|$8A   IrqHC0HHPML+AH+MZIIN$    M@ f     IDHBIHIDHBH>IDHHR IuHt$03M;sHS0KHJIHIM;r;    HǄ$     H$  Ƅ$   A   H H$  i  HǄ$     H$  Ƅ$   A   H H$  2  DC(EyH$  H$  H$  蕈  H$  臈  HǄ$      H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   Hȿ H$  S  HcS(H$  HD$ L$  L$  H$  H+H$  Ht(L$  L+Iy  W$  H$  H$  h  H$  Z  H$  L  H$  H$  E33H$    A   H- H$    H$  H$  E33H$  譻  A   HԾ H$  C  DC(EyH$  H$  H$  覆  H$  蘆  $  HcS(W$  H$  L$  H$  ¹  H$  HKHA  H$  HtL$  L+I   H$  H$  E33H$  κ  A   H H$  d  HL$  H$  HPHHL$8轂  H$  Ht(L$  L+I蜵  W$  H$  H$  苅  LLc[(LL|$8IrmHCHHHPML+IH+MSIIN$    Mf     IDHBIHIDHBHIDH1HR IuHt$03M;sHSHKHJIHIM;r    H$  H$  E33H$  }  A   H H$    H$  H$  E33H$  @  A   Hw H$  ֿ  DC(EyH$  H$  'H$  9  H$  +  H$  H$   E33H$  ɸ  A   HL H$  _  H$  H$  E33H$  茸  A   Hë H$  "  H$  H$  E33H$  O  A   HZ H$    HcS(H$  SHD$ L$  L$  H$  H轤H$  Ht(L$  L+I  W$  H$  H$    H$    H$  ނ  H$  H$  E33H$  |  A   H H$    H$  H$  E33H$  ?  A   Hv H$  ս  DC(EyH$  H$  &H$  8  H$  *  $  HcS(W$  H$  L$  H$  T  H$  HK`~  H$  HtL$  L+I貱  H$  H$  E33H$  `  A   H H$    HL$  H$  HPHHL$8O~  H$  Ht(L$  L+I.  W$  H$  H$    LLc[(LL|$8IroHC`HHPML+IH+MSIIN$    Mfff     IDHBIHIDHBHIDH1HR IuHt$03M;sLK`KHKIHIM;r{    H$  H$   E33H$  
  A   HԤ H$  裻  H$  H$  E33H$  д  A   H H$  f  H$  H$  E33H$  蓴  A   H H$  )  H$  {HD$ L$  L$  H$  HH$  Ht(L$  L+IS  W$  H$  H$  B  H$  4  H$  &  {xH$  H$  E33H$    A   H H$  W  HL$  H$  HP(HHL$PPv  H$  Ht(L$  L+Iߝ  W$  H$  H$  ~~  HD$PKxv    H$  H$  E33H$    A   HK H$  螹  H$  H$  E33H$  ˲  A   H H$  a  DC(EyH$  H$  H$  }  H$  }  H$  H$  E33H$  T  A   H H$    H$  H$  E33H$    A   Hb H$  譸  DCxEyH$  H$  H$  }  H$  }  H$  H$   E33H$  蠱  A   H# H$  6  H$  H$  E33H$  c  A   H H$    H$  H$  E33H$  &  A   H1 H$  輷  LcCxHcS(H$  fHD$ L$  L$  H$  H萝H$  Ht(L$  L+Iޫ  W$  H$  H$  {  H$  {  H$  {  H$  H$  E33H$  O  A   H H$    H$  H$  E33H$    A   H] H$  訶  DC(EyH$  H$  H$  {  H$  z  H$  H$  E33H$  蛯  A   HƲ H$  1  H$  H$  E33H$  ^  A   H H$    DCxEyH$  H$  EH$  Wz  H$  Iz  $  HcSxW$  H$  L$  H$  s  HcS(W$  H$  L$  H$  E  H$  H   c  H$  tc  H$  HtL$  L+I蒩  H$  H$  E33H$  @  A   H H$  ִ  HL$  H$  HPHHL$8/v  H$  Ht(L$  L+I  W$  H$  H$  x  LHc{xH$  E3H   L|$8@ f     LcC(3I   H   LHP0M_OA   L+IxHHH4    Lfff     HJICJHJICJH
IJJ"J1ICJM[ HR`HuH$  I;s+L   HvHL+IKJIHRIuIL;,Ht$0 	   3H$  H$  E33H$  艬  DGH H$  !  H$  H$  E33H$  N  DGH H$    DCxEyH$  H$  7H$  Iw  H$  ;w  H$  H$   E33H$  ٫  A   H\ H$  o  H$  H$  E33H$  蜫  A   HϮ H$  2  H$  H$  E33H$  _  A   Hj H$    HcSxH$  cHD$ L$  L$  H$  H͗H$  Ht(L$  L+I  W$  H$  H$  
v  H$  u  H$  u  H$  H$  E33H$  茪  A   H H$  "  H$  H$  E33H$  O  A   H H$    DCxEyH$  H$  6H$  Hu  H$  :u  $  HcSxW$  H$  L$  H$  d  H$  H   q  H$  HtL$  L+I迤  H$  H$  E33H$  m  A   H H$    HL$  H$  HPHHL$8\q  H$  Ht(L$  L+I;  W$  H$  H$  *t  LLc[xLL|$8IrlH   HHPML+ȿ   H+MSIIN$    M IDHBIHIDHBH>IDHHR IuHt$03M;sH   KHJIHIM;r 
   H$  H$  E33H$    A   H] H$  谮  H$  H$  E33H$  ݧ  A   H H$  s  DC(EyH$  H$  H$  r  H$  r  H$  H$  E33H$  f  A   H H$    H$  H$  E33H$  )  Hn H$  襭  DC,EyH$  H$  H$  (r  H$  r  Hc H$  Vs  H
 H$  As  H H$  ,s  LcC,HcS(H$  HD$ L$  L$  H$  H H$  W  H$  q  H$  vq  H$  hq  Hq H$  r  HX H$  r  DC(EyH$  H$   H$  q  H$  q  H H$  @r  H H$  +r  DC,EyH$  H$  H$  p  H$  p  $  HcS,L$  H$  m  HcS(LH$  [  HH   jZ  H$  Y  H$  V  HD H$  {q  Ld$0I$L$  H$  IPHHL$8l  H$  QV  H$  o  LLc{,LMtFLt$8Hc{(E3Ht+ MIIH   KY  HKJIL;rIM;r3    Hi H$  p  Hx H$  p  DC,EyH$  H$  H$  .o  H$   o  H! H$  \p  H H$  Gp  HǦ H$  2p  HcS,H$  HD$ L$  L$  H$  I*H$  T  H$  n  H$  n  H$  rn  HW H$  o  Hf H$  o  DC,EyH$  H$  
H$  n  H$  n  HcS,W$  H$  S  H$  H   T  H$  Fu
 Hץ H$  
o  I$L$  H$  IPHHL$8j  H$  S  H$  wm  LLc[,LLt$8IryH   HHPML+ȹ   H+H$  MSIIN<    M     IDHBIHIDHBHIDH9H IH$  uM;sL   KHKIHIM;r     H H$  m  H H$  m  Hc H$  m  H$  @HD$ L$  L$  H$  IʍH$  R  H$  .l  H$   l  H$  l  3H   H H$  Em  I$L$  H$  IPHHL$8h  H$   R  H$  k  HD$8HH       D$0   Hv H$  l  H H$  l  LL$0LC,H$  H$  	 H$  ;k  H$  -k  /    t$0H0 H$  [l  Hs H$  Fl  LL$0L   H$  H$  	 H$  j  H$  j  HsHCHCHC    H H$  k  H H$  k  DCxEyH$  H$  5H$  Gj  H$  9j  HcCxHHC0    H	 H$  `k  H, H$  Kk  DC,EyH$  H$  H$  i  H$  i  HcC,HCHL$8P  HL$PL  H$(  H3 L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH H"p HHH   p
 H   3H*HtNH   , L   HH   I+HHLI?LI覅  H   H   H   H   Ht(L   L+I貘  H   H   H   H   HtNH   + L   HH   I+HHLI?LI  H   H   H   HS`HtLCpL+I*  H{`H{hH{pHSHHtLCXL+I  H{HH{PH{XHS0HtLC@L+I  H{0H{8H{@Hh HKHH\$0Ht$8H _  @SVWATAUAVAWH  HǄ$  )$  HJ H3H$p  LL$8MLHIHL$`a  IHL$xJ  > $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGH H$0  Q  IH$0  IPH$H  HrTHH$0  H=   r<tn
 HAH;rn
 H+Hsn
 H'vn
 H8 tiHev
 H$   3H$   H$   Hl HD$8D$@H$   HL$8l
 HHf H$   Ha H$   " HǄ$     H$   Ƅ$   A   Hލ H$  5  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+ID  W$0  H$@  H$  HrTHH$  H=   r<tlm
 HAH;r\m
 H+HsLm
 H'v?m
 H计 HǄ$     H$  Ƅ$   A   H H$    HǄ$h     H$`  Ƅ$P   A   H H$P    HǄ$     H$   Ƅ$   A   H H$  誟  H$0  HD$ L$  L$P  H$  I膅H$0  Ht(L$@  L+Iԓ  W$0  H$@  H$  c  H$P  c  H$  c  D$0HT$0HL$`^  HǄ$     H$  Ƅ$   A   Hl H$  Ǟ  IH$  IPH$  3c  tiH0s
 H$   3H$   H$   H HD$8D$@H$   HL$8i
 Hc H$   H, H$    HǄ$     H$  Ƅ$   A   H H$     IL$  H$0  IPHHL$HY_  H$0  Ht(L$@  L+I8  W$0  H$@  H$  'b  HǄ$     H$   Ƅ$   A   HN H$  a  HǄ$h     H$`  Ƅ$P   A   Hω H$P  *  HǄ$     H$  Ƅ$   A   Hؙ H$    H$0  EHD$ L$  L$P  H$  IςH$0  Ht(L$@  L+I  W$0  H$@  H$  a  H$P  `  H$  `  HD$H D$0HT$0HL$`2\  HǄ$     H$  Ƅ$   A   HĘ H$    IH$  IPH$  w`  tiHtp
 H$   3H$   H$   H HD$8D$@H$   HL$8f
 HW` H$   Hp H$   1 HǄ$     H$  Ƅ$   A   H H$  D  IL$  H$0  IPHHL$H\  H$0  Ht(L$@  L+I|  W$0  H$@  H$  k_  HHǄ$h     H$`  $P  A   H8 H$P  裚  HǄ$     H$  Ƅ$   A   H% H$  l  DFxEyH$P  H$  H$  ^  H$P  ^  HǄ$     H$   Ƅ$   A   H H$    HǄ$h     H$`  Ƅ$P   A   H} H$P  ę  HǄ$     H$  Ƅ$   A   Hr H$  荙  HcVxH$0  HD$ L$  L$P  H$  IeH$0  Ht(L$@  L+I賍  W$0  H$@  H$  ]  H$P  ]  H$  ]  Wt$0HcVxW$0  H$@  LD$0H$0  賐  L$0  9Vx~)ILD$Hfff     IH[HHI;Vx|;^x}HcIHL$`bX  HǄ$     H$  Ƅ$   A	   Hĕ H$  7  IH$  IPH$  \  tiHl
 H$   3H$   H$   Hw HD$8D$@H$   HL$8*c
 H\ H$   H
 H$   ] HǄ$     H$  Ƅ$   A	   H H$  p  IL$  H$  IPHHL$HX  H$  Ht(L$   L+I訋  W$  H$   H$  [  H$   H$(  E33H$  5  A   H H$  ˖  H$`  H$h  E33H$P    A	   H H$P  莖  H$  H$  E33H$  軏  A   H6 H$  Q  H$  裂HD$ L$  L$P  H$  I-|H$  Ht(L$   L+I{  W$  H$   H$  jZ  H$P  \Z  H$  NZ  HD$H D$0LD$0(HL$`,  H$   H$(  E33H$  ʎ  A   H! H$  `  IH$  IPH$  Y  tiHi
 H$   3H$   H$  H HD$8D$@H$   HL$8S`
 HY H$   H
 H$   膡 H$   H$(  E33H$    A   HT H$  蓔  IL$  H$  IPHHL$HU  H$  Ht(L$   L+Iˈ  W$  H$   H$  X  HH$  H$  E33H$  U  A   Ht H$    H$   H$(  E33H$    A   Ho H$  讓  DF,EyH$  H$  H$  X  H$  X  H$`  H$h  E33H$P  行  A   H$~ H$P  7  H$  H$  E33H$  d  A   H H$    H$   H$(  E33H$  '  A   H H$  轒  HcV,H$  +HD$ L$P  L$  H$  IxH$  Ht(L$   L+I  W$  H$   H$  V  H$  V  H$P  V  t$0HcV,W$  H$   LD$0H$    L$  L|$H9V,~IIH[HHI;V,|fD  ;^,}HcIHL$`Q  HT$`HL$8N  HT$xI97  MtL$   M+II  MtL$@  M+IIυ  H$@  HtH+HLu  MtLD$XM+II蘅  HL$`(  H$p  H3 ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xH8 H3HEH3HH  HE   3Hu@uDFH$} HM  HCHMH;sTHHUH;wHH}H+H;CuVHM  HH;HKHtcHA   HqHyrHHH;H;Cu
   H
  HKHt'HA   HqHyrHHHU  誕  HC HEHrPHHMH=   r<t\
 HAH;r\
 H+Hsy\
 H'vl\
 Hې HE   HuE A   H{ HMU  HCHMH;sVHLEI;wJH}H+H;Cu
   H!  HH;HKHtcHA   HqHyrHHH;H;Cu
   Hރ  HKHt'HA   HqHyrHHHU  ~  HC HM0S  HE   HuE A   H/ HMz  HUH=H  HMR  HE   HuE A	   HƋ HM=  HUH H  HMR  HE   HuE A   H HM   HUHG  HMyR  HE   HuE A   H HMÍ  HUHG  HM<R  HE   HuE A   H HM膍  HUHIG  HMQ  HE   HuE A   Hr HMI  HUHG  HMQ  HMH3 H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLHn>  WEE3LuHMI  HUHz=  HMI  HUHe=  HMI  IcxH} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
: U
 HQM+IIHHH+IMI;LCL;ICHMϨ  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
 'U
 HQM+IIHHH+IMI;LCL;ICHM:  HMHtH9HHMHUH;  HMaH  HUH;  HMLH  Ic,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
ĉ FT
 HQM+IIHHH+IMI;LCL;ICHMY  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
< S
 HQM+IIHHH+IMI;LCL;ICHMѦ  HMHtH9HHMHUH:  HMF  IcxH} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
p R
 HQM+IIHH+II;LCL;ICHM  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
 tR
 HQM+IIHH+II;LCL;ICHM荥  HMHtH9HHMHUHM9  HME  AOxHcH] HE HMH;sBHU HEH;w5H] H+HH;Mu   HM~  HMHEHt)HH H;Mu   HM~  HMHtHHHMHUH8  HME  HUH8  HUHtLEL+IE|  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HE HXHpHx Hc/ H3H   EELHHL$ )Z  HL$8>  E3LmHs HL$0  HU(HL$ hX  HI@  HE@HrQHHM(H=   r<tS
 HAH;rS
 H+HsS
 H'vS
 H HL$8覑  LmH3s HL$0!  HU(HL$ W  HIG@  HE@HrPHHM(H=   r<t:S
 HAH;r*S
 H+HsS
 H'v
S
 H|    9_x   HL$8  LmH HL$0}  HȲ.  Hȋ8P
 HU(HL$ W  HI?  HE@Hr4HHM(H=   r uAHAH;s1H+Hr!H'wH߆ ;_x!gUR
 NR
 GR
 @R
 HL$8M  LmH HL$0Ⱦ  HU(HL$ zV  HI>  HM(I  9_,   f     HE@   Lm8E( HL$8  LmHM(iI  H HL$0X  HȲ.n  HȋO
 HU(HL$ U  HIi>  HM(I  ;_,~Eu	Es  9_x|{ HE@   Lm8E( HL$8V  LmHM(H  HV HL$0Ƚ  HȲ.޿  HȋN
 HU(HL$ eU  HI=  HM(H  ;_x~Gx   ff     HE@   Lm8E( HL$8Ǝ  LmHM(IH  H΁ HL$08  HȲ.N  HȋM
 HU(HL$ T  HII=  HM(G  ƋGx;~HE@   Lm8E( HL$8J  LmHM(G  HV HL$0輼  HU(HL$ nT  HI<  HM(G  HM~T  HMM
 H   H3| L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx H* H3H   LHHL$0TU  HL$Hi  E3L}Hn HL$@  HU0HL$0S  HI<  HEHHrQHHM0H=   r<tN
 HAH;rN
 H+HsN
 H'vN
 H< HL$Hь  L}H^n HL$@L  HU0HL$0R  HIr;  HEHHrPHHM0H=   r<teN
 HAH;rUN
 H+HsEN
 H'v8N
 H观    9_x       HL$H&  L}H} HL$@衺  HȲ.跼  Hȋ\K
 HU0HL$0>R  HI:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH ;_x!gyM
 rM
 kM
 dM
 HL$Hq  L}H} HL$@  HU0HL$0Q  HI:  HM0D  ,   @ ff     HEH   L}@E0 HL$H  L}HM0D  H| HL$@x  HȲ.莻  Hȋ3J
 HU0HL$0Q  HI9  HM0?D  ;w,~     HMQ  HMJ
 H   H3ny L$  I[ Is0I{8IA_A^]H\$WH Hlt
   H袀 HH\$0H _H\$Ht$WH H3H  Ht;H  4 H  L   L+I
q  H  H  H   H  H*HtNH  # L  HH  I+HHLI?LI_  H  H  H  H  B  H  Ht(L  L+Ir  H  H  H  HKp   HKXHt)HS`F HSXLChL+I"p  H{XH{`H{hHK@Ht:HSHT HKPHH+K@HHLI?LHS@^  H{@H{HH{PHS HtLC0L+I
r  H{ H{(H{0HSHtLCL+Iq  H{H{H{H\$0Ht$8H _H\$WH HHA  HOXA  LG8HT$0MHO8M o  HO8`~ LG(HT$0MHO(M xp  HO(?~ HOH\$8H _\A  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hs  HH_8H\$HH3HsԴ  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"     H}| HH [H\$Ht$WH H3H  Ht;H    H  L  L+Il  H  H   H  H  Ht(L  L+IV^  H  H  H  H  Ht(L  L+In  H  H  H  H  H*HtNH  K L  HH  I+HHLI?LI.[  H  H  H  H  Ht;H   H  L  L+Ik  H  H  H  Hp  HtNHx   Lp  HH  I+HHLI?LIZ  Hp  Hx  H  HX  Ht;H`  ` HX  Lh  L+I6k  HX  H`  Hh  HKpHH\$0Ht$8H _nHT$SH0HD$(H3D$ HHBHBD$    H  H  L  HH0[@SH0HD$     H  H`[  HH0[@SH0HD$     Hp  H0[  HH0[@SH0HD$     H  H2  HH0[@SH0HD$     HX  H2  HH0[H   HD$0LH  L  HQpHD$ I^  tWHL
 HD$P3HD$XHD$`Hu HD$@D$HHT$XHL$@B
 H	< HD$PH%
 HL$P 3HĈ   @USVWATAVAWH$ H  HEH H3H   EIHHHUH]E3Dd$4IHL$Ps5  Lt$XL+t$PIL;vx   HMI  H^xHt HM  HI@
 HHt   HH@
 HHt   H   HMG  HxrH H
J
 HL$h3HL$pHL$xHEEHT$pHMlA
 H%B HD$hHY
 HL$h襂 Dd$0H   H+   HWD$8Ld$HLD$0HL$8誟  L'LgLgD$4   HNpLLD$8HT$PEt    HT$8HtLD$HL+I8Y  WD$8Ld$HHT$PHtLD$`L+Ii  HHtLCL+Ii  L#LcLcHH   H3n H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH H3H   EEHHHUHL$HK3  Ht$PH+t$HHH;wx   HMYG  H_xHr HM  HH>
 HHr ٭  HH>
 HHr 辭  H   HMnE  HxrH H
H
 HL$h3HL$pHL$xHEEHT$pHMD?
 H? HD$hH1
 HL$h} 3t$`H   H+   HWD$0Ht$@LD$`HL$0聝  EuLHOpLD$0HT$HEt2#  (HT$0H   LD$@L+I!W  WL$0|!  WD$hHt$xHOpLL$hLD$0HT$HEt$  m  (HT$hHtLD$xL+Iog  HT$0HtLD$@L+IV  WD$0Ht$@HT$HHtLD$XL+I*g  HHtLCL+Ig  H3HsHs(H   H3dl H$   ($  H  A_A^_^]@SVWH  HD$pH- H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   D  HxH^H+HH*p H$   M  HH<
 HHo 2  HH;
 HHo   H$  H$   B  HxrH H
E
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`<
 HN= HD$HH
 HL$H} H   H+   HHL$H  HOpD$0D$(H\$ L  HT$HHtLD$XL+IT  HH$  H3j Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E3HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK2]WD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`ZHT$8HtLD$HL+I>S  HL$`dHL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xH~\HHMp3<
 L   A   AA+iA+AD̉P    AA+iD+EDDT  HX   HUpHp   3DLx  Lp  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;r  HX  H  (  Hp  H  P  H  H;H{H{H  H  H      H  H   H  H|$      f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   Hc  HKHHt(HHH;Cu
   H~c  HCHtH8HCHH|$   H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hc  HHKHt,HH#H;Cu
   Hb  HCHtH HCH  H  Q L  H  H  w  HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H H3HEHLHUHM&  H]HLuIـ E3H;  HE   LeDeED$H-X HMhk  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
j 4
 HSM+IIHL+IIM;HCH;HCHM1  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
ii 3
 HSM+IIHL+IIM;HCH;HCHM聓  H]Ht*HC   LcH{rHHHU  Ho  H H]HEHrPHHMH=   r<t6
 HAH;r6
 H+Hs6
 H'v}6
 Hj HUIpE  M  I  I    H]Ht HUH LEL+IHm[  HHt'HVk HLFL+IH[  L&LfLfHMH3b L\$pI[@IsHIA_A^A\_]L$SH0H)t$ IHT$H HKHD$@D$@(H;s\HHT$@H;wOH|$PH|$@H+HH;Ku
   H_  HSHt
HHH
H|$PHBHC(t$ H0[H;Ku
   H^  HCHt0(t$ HHCH0[H\$WH HQ3HHtLA(L+IK  H{H{ H{(HHtLCL+ID\  H;H{H{H\$0H _Hy0HArH @SH H HHH,  H<
 HKHH [H%*3
 H\$ WHpH7 H3HD$`3HHAIHAH HHL$@蓲  HHL$ L胯  HHOLe    HD$8HrQHL$ HH=   r<t3
 HAH;r3
 H+Hs3
 H'v3
 Hg HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t?3
 HAH;r/3
 H+Hs3
 H'v3
 Hg HHL$`H3` H$   Hp_@SH H+ HHHt*  Hu:
 HKHH [H%1
 H\$ WHpH
 H3HD$`3HHAIHN HAH* HHL$@  HHL$ L  HHOLd i  HD$8HrQHL$ HH=   r<t2
 HAH;r2
 H+Hs1
 H'v1
 H]f HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t1
 HAH;r1
 H+Hs1
 H'v{1
 He HHL$`H3j^ H$   Hp_@SH H) HHH(  H8
 HKHH [H%/
 H\$ WHpH H3HD$`3HHAIHL HAH9) HHL$@\  HHL$ LL  HHOLfb ɯ  HD$8HrQHL$ HH=   r<t{0
 HAH;rk0
 H+Hs[0
 H'vN0
 Hd HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t0
 HAH;r/
 H+Hs/
 H'v/
 HJd HHL$`H3\ H$   Hp_@SH H7
 HHH4'  H57
 HKHH [H%Z.
 H\$ WHpHg
 H3HD$`3HHAIHTK HAH7
 HHL$@輭  HHL$ L謪  HHOL` )  HD$8HrQHL$ HH=   r<t.
 HAH;r.
 H+Hs.
 H'v.
 Hc HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<th.
 HAH;rX.
 H+HsH.
 H'v;.
 Hb HHL$`H3*[ H$   Hp_@SH H! HHH%  H5
 HKHH [H%,
 H\$ WHpH H3HD$`3HHAIHI HAH  HHL$@  HHL$ L  HHOL&_ 艬  HD$8HrQHL$ HH=   r<t;-
 HAH;r+-
 H+Hs-
 H'v-
 H}a HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t,
 HAH;r,
 H+Hs,
 H'v,
 H
a HHL$`H3Y H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuH>  HKHL$@HHHHL$HHt賫 *H;KuH>  HKHL$@HL$HHt	H臫 HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LH|r  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH{>  HwHtlHHHF   HF     HHHc  C F ;H;OuH3>  H_Ht$HC   HHC    H lc  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	f HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIv HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI LGHVH pMt/HWIu HOH+IHHLI?LHb=  HNH+IHHHH?HH>  tLHVH蜁 HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LH<  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   H<  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   HZ<  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+HC%
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+$
 H[HI~H+LH$
 Ht$0H;H|$8IFIH\$@H A^HtH!=  HSIH+H>  t!HH[I>H+LHy$
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I<  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
|W !
 HH|$0q  HHFHHHNI~IHH+LH#
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
V Z!
 Lq  HH    HGLH3HHOHFd H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXH+
 D$(HD$0HT$83HL$ HD$8HD$@HN HD$ B"
 H H
 HD$0HL$0{c HU+
 D$(HD$0HT$83HL$ HD$8HD$@H? HD$ !
 H He
 HD$0HL$0$c HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`H*
 D$(HD$0HT$83HL$ HD$8HD$@HM HD$ *!
 H Hܿ
 HD$0HL$0cb H\$WH HHH;Qt>H	!
 HtH HH{H\$0H _H    H{H\$0H _HyH\$0H _HLHLHALBHBHLA@SH HHHtLAL+IoI  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
S *
 o  HL    HCHHIHKH LCHH\$0H _@SH L
 HL II+HH;sH+IH H [H;   L H+II+HH;s\IIH+H;sH
R j
 HM+I3IHL+IM;HCH;HCn  L
O L@ ILI+3HIL+I*` H
# HH+ HH+HH H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
Q k
 HM+I3IHL+IM;HCH;HCHn  HOLH3H+HL+I5_ HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH:  HSHt7HHH
HCH\$0H _H;CuH9  HKHtHHHCH\$0H _HHRH@SH HH	Ht@HS& LCH*L+IHLI?LH2  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LHI2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
XO 
 Hg  HHCHHHHKLHVH$v HCHH\$XHt$`H@_@SH 3HHHAHA8  HH [H\$WH 3HHHHAHAHtNH
H;vH
N 
 f  HHHCHHL    IHKH$ LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   H8  HKHL$@HHHHL$HHtn
  /H;Ku
   HH8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHRu  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR  HH@HH HH@HC    DD$@HH(  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+IW0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I@  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@Hr LHD$ HT$@HLH u HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHRU  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHRՁ  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I>  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+If>  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H_>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HFJ  VH;Cu
   H >  HKHL$@HL$HHt03HA   HAHyrHH  IE3HI  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
+G 
 HM+I3IHL+IM;HCH;HCHFq  HOHHH+HH+ HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LI  HSH] HGH+HH   HCH+HL;w'HILHI  LCHWHs LHtI HLCL+I8  HWH+HH0<  tLHWHs HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+Is8  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H:  HKHt@HH;H;Cu
   H:  HKHtHA   HHA     K  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I7  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
C Q
 H@d  HHCHH;H{LHVHq HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH::  HSHt3H
HCH\$0H _H;CuH:  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+I|'  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   H9  HSHt<HHH
HCH\$0H _H;Cu
   H9  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+A
 H[HI~H+LH'
 Ht$0H;H|$8IFIH\$@H A^HtH!6  HSIH+H8  t!HH[I>H+LH
 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
@ 

 HH|$0x[  HHFHHHNI~IHH+LH
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
h? 	
 Z  HH    HGLH3HHOHL H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   He6  HSHt
HHH
HBHCH\$0H _H;Cu
   H,6  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
	> 
 HM+I3IHL+IM;HCH;HCH[  HOLH3H+HL+IUK HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+I2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH 3HHHAHA5  HH [@SH0HE3HQ(DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH>=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH<  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	_	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ X=  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
; l
 H;sLHHf  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<t,
 HAH;r
 H+Hs
 H'v
 Hn< HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t
 HAH;rr
 H+Hsb
 H'vU
 H; HC   HC    H{rHH  HH@  HH\$@H0_@SH E3HA   LAHDD8tIIB< u9  HH [@SH HA   IHA    E3 H:  HH [H\$WH HH  HH
 tHCh    H\$0H _HH{hH\$0H _H%
 @SH H    Ht'  tH   3
 y	H [3H [@SH HMH   Ht9HuMuEAE3
 uH   D@HA  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|>  tsH   HT$0Y
 u]HtH   D@Hd
 u@H   HT$0F
 u*IFHHGtj>  HOtHD$0HCH    HKHQ
 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb=  tYHutH   DHs
 u8H   HT$0U
 u"H=  HKtHD$0HGH    HOHh 
 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   Z
 tl  d  HE/   E3Lu'DuH   %
   HU'HHH  HZH  LM/L;sLHHM`  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOh 
    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+32  HUH}/r'HHu#Ey
     ]
 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   C
 H~LEHU]#H
73 	 H
)3 	 HUHE/HrPHH=   r=Et 
 HBH;r 
 H+Hs 
 H'v 
 HH4 HM7H3{- L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@	 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp H
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   I	 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKh	       HELELM/IICH}H+t.HMIICL   LǺ   	 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHM2  3u#MH   	 ;ELM/LELM/LEIrQIAH=   r=Et	 I@I;r	 L+Is	 I'v	 LI0 HM7H3|) L$   I[0Is8IA^_]H   HtH%=	 H   HtH%%	 @SH0HD$ HH
 HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H}8  HH0[H%	 @SH0HD$     H:  HH0[H\$WH HhHHcPHi
 H
hHhHcPH
 DhD
dHAH+9  HO	 HOH\$0H _H%L	 DL$ HL$SVWH0HD$ HHD$h    HY
 HHw
 HAH   	 D$h   H^E3HH	 HHcHH
 H1HHcHhT1H\$XH(	 H
 HLGHrH?HCh    Cp    MtHH]  HH0_^[DD$HL$WH0HD$ H\$HHD$P    Hy
 HH
 HAH   	 D$P   E3HWH	 HHcPH
 H:HHcPDhDD:   HO:  HH\$HH0_@SH0HD$     Hv8  HH0[H\$WH HxHHcPH)
 H
xHxHcPH
 DxD
tHAH6  HO	 HOH\$0H _H%<	 @SMPHMLLA@I Ht
H9AhsHAhH	 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   H	 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjH	 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
H	 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIHJ	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI=5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH HG
 HHHI	 HO 	 HO(	 H	 t
0   H' HH\$0H _H\$WH H\t
   H& HH\$0H _H\$Ht$WH HH>	 @t   Hh& Ht$8HhH\$0H _H\$Ht$WH HH	 @t   Hx?& Ht$8HxH\$0H _H\$WH H?
 HH/  H	 t
x   H% HH\$0H _H8HD$ HHHcHHLHHt+HHPHH;uH   Ht
	 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLH  H\$ HSH HHCI  H$   HVHݥ HHFI  HHGWD$8HD$H    Ip  Hl$(HT$8H  ILl$8I;^F  MX  @ HI  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtH 9F	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  H&  HGH+HA  MtwHD$HI+HH?H;v	 H    H=   r=At	 IEI;r	 L+Isy	 I'vl	 LI! HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
 |	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
* 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [5  H [H(H
L;v	 K@HH=   r<ts	 HBH;rc	 H+HsS	 H'vF	 HHH( @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
 ^	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _n5  H _H\$WH 3HHHHAHAHt:H
H;vH
H 	 4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
 	 H3  HHCHHHHKLHVHB HCHH\$XHt$`H@_H(H?L;v	 J    H=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(LQLLAII+HH;s_H	I?L+III+H;sH
| 	 L+II3IHL+IM;HCH;HCIH(C5  H(H\$WH 3HHHHAHAHt6H?H;vH
 z	 l4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHH
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
8 	 IHO uM  H    HHWHL$(bHHO E7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wH HH;_s%k	 d	 ]	 V	 O	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;v	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
l 	 L+II3IHL+IM;HCH;HCIH(#4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
 \	 L+HI3IHL+IM;HCH;HCIH(q4  H(@SH0WH        f I1  LH݋ HHۋ HHH
؋ H@ HIH
 H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
 P	 ".  HHCHL4    HIHKHMHH裝 I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
 ~	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _4  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uH&  AE3'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AD  3ҋm%  AD$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH`   AE3S!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEu   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ=  AD`  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v	 II   r<t	 HBH;rv	 H+Hsf	 H'vY	 HHH( LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRB  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRWC  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@HS0  LD$PL;D$XuLHH\$HH0_H(HL;vO	 J    H=   r<t3	 HBH;r#	 H+Hs	 H'v	 HHH(n H(LQLLAII+HH;s_H	IL+III+H;sH
	 N	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
H	 	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
 L	 L+HI3IHL+IM;HCH;HCIH(#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
< 	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
 :	 ,#  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH> HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
 b	 T"  HLHCHHHHKLI MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHH;uH   Ht	 ҐH8@SH0HD$ HX	 u
H	 HHHcHHLHHt+HHPLw
 I;uH   Ht	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtH)	 HCHH=   r=@tM	 HGH;r=	 H+Hs-	 H'v 	 HH HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALH	 HHt8Ht!LIH(	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1It+(	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHH'	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ :0  H\$hH0A_A\^HKI;sH
 	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
{ 	 L+H|$XH;s;HCHrHHHrHHMtHMJ HH\	 LCIH+HHu	H   HvH
 n	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HH	 H{rHHHtJ LI%	 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH
 -	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JL	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH
"  	 HvH
  x	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L 
 H{H{rHH8 Ht$8HH\$0H _̀: uE3   IIB< u    H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH
 	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLHi"	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
 	 I+H;HGH;u9I8H9AsH
 	 HAHyrH	 3He   HvH
k
 	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6LG!	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH
 	 H|$0I<H   HvH
r
 	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
;
 	 H|$0I<0H   HvH

 	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLH	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
W
 y	 LAH+H;HGIHH;wH
 
 	 H|$0I<0H   HvH
 d	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.L	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBIta	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpHC
 H3HEHHyh   yq   u2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H
 	 H
 	 ̳IrNIAH=   r=Et=	 HAH;r-	 H+Hs	 H'v	 H HMH3 L\$pI[(Is0IA^_]@SVWH AAq HHA|	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXHk HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHDa	 HEHC| Cq ¾	 H
[k HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   I	 HtyA   HHHT$(H@	 HǠ  HH	 t
HCh    H{hH	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t	 HAH;r	 H+Hsu	 H'vh	 H HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPHǛ
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r	 H+Hs	 H'   ݿ	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t	 HAH;r
	 H+Hs	 H'v	 H\ HHL$HH3 H\$pHP_@WH0HD$ H\$HH	 HI
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;w	 x HH'HHAHH(H\ HH(H(I   r<tн	 HBH;r	 H+Hs	 H'v	 HHH( Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;vϸ	 KHH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH( H(H88L;vO	 KHH=   r<t3	 HBH;r#	 H+Hs	 H'v	 HHH(n H(Hu	3ɋH(H88H;v1	 HHH   r,HA'H;w	 H HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH HH988LKHML+IHHLI?IHt+Io HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;vղ	 HHH   r&HA'H;w	 H HX'HHC HHVLHHl$@Lt$H HHgfffffffLNHML+ILIMI?MHt+I9o HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;v	 HRHH   r,HA'H;w	 H HH'HHAHH(n HH(H\$Hl$Ht$H|$ AVH0LH[HSLHHY HH*LKHML+IHHLI?IHt+Ii HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt/H;Ku
   HhHKHL$@HL$HHt	H͍HCH\$PH0_H(Hu	3ɋH(H?H;v	 H    H   r,HA'H;w	 Hg HH'HHAHH(N HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;v	 H    H   r,HA'H;w	 Hg HH'HHAHH(N HH(H\$WH HHu3UHH;v	 H    H   r&HA'H;w	 H HX'HHC HH&\ HL$\ L+Ht$0	 H\ H5\ H+HHtL[ L+IHH[ H[ HHt$0H\$8H[ H _H\$Ht$WH HHHu3UHH;v%	 H    H   r&HA'H;w	 H HX'HHC HHHLGL+Hl$0ͮ	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+C	 HH{H+HHtLCL+IHHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;v	 HRHH   r&HA'H;w	 H{ HX'HHCh HHVLHHl$@Lt$H HH*LNHML+ILIMI?MHt+IIh HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;v	 HH   r)HJ'H;w	 n HH'HHAHH(HR HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;vg	 H    H=   r<tK	 HAH;r;	 H+Hs+	 H'v	 H HoXHo`HohHO@Ht~HGPH?H+HH;v	 H    H=   r<tĨ	 HAH;r	 H+Hs	 H'v	 H Ho@HoHHoPHO !H HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;v	 H    H=   r<t	 HAH;r	 H+Hs{	 H'vn	 H HoXHo`HohHO@HttHGPH+HI;v:	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H` Ho@HoHHoPHO {HC HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHHO HHWHH+HtZ HLGL+IuHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
 b	 THLHCHHHHKLI^ MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPL
 I;uH   Ht	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;wŝ	 H Hp'HHF HH\$`Lt$pH|$hHt$xMtH{rHHMtMH HCHrOHHH=   r<tڠ	 HAH;rʠ	 H+Hs	 H'v	 H HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH
 	 IALd$XLd$pI;sH
a
 	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH

 v	 Ll$`L+L,9M;sBIvH
 Q	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HHj	 H~rH6H{rHHH6  J&LJ0L !  H;suHCHrHHHrHHHtJ!LJ0	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HHx	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0	 HCHrHHHrHHMtJ1MJ0HHN	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   Iv	 H|$0H   r#IH'H;w	 r Hx'HHGH\ HLHHo CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH

 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHH HH*LKHML+IHHLI?IHt+IS HKHH+HHLI?LHKHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   HC 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH   HxH\$0Hl$8Ht$@H _%	 	 	 	 		 	 	 	 	 	 ߕ	 ؕ	 ѕ	 ʕ	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H 3HC   H{HSrHH   HxH\$0Hl$8Ht$@H _	 	 	 	 ٓ	 ғ	 ˓	 ē	 	 	 	 	 	 	 H(p    HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL-
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1H8	 tVHڅuVHHcHMIHL1H	 I;u0D  H~/HHcHT1XHL1H	 u
Hջ   \$xHHcHHD1(    L-
 Ht$p\$xLd$(HHcHHE3	 		 u
It	 I$HcHJL!HHt#HHPI;uH   Ht[	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%~
 Ht#HHPI;uH   HtǏ	 ҐHHcH|1 uHL1PHtH;t	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1H(	 ADމ$   HHHcHAHL1H	 ADމ$   u(H~#HHcHT1XHL1Hы	 ADHL%}
 Ht$p$   L|$(HHcHHD1(    HHcHHE3	 	 u
Ib	 IHcHJL9HHt#HHPI;uH   HtJ	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-{|
 Ht#HHPI;uH   Ht	 ҐHHcH|1 uHL1PHtH;tp	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1H	 u   \$x7Hυu.I~rM6HHcHMIHL1H	 I;t   +Ht*HHcHT1XHL1H	 uHՉ\$xHHcHHD1(    L-U{
 Ht$p\$xL|$(HHcHHE3	 ۉ	 u
IF	 IHcHJL9HHt#HHPI;uH   Ht.	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHH	 H		 HЈ	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHH
 %H H;uIVHNH;HHQӉ	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HM:	 HH8
 sHH[H;uIFHMH	 HH	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PH`f
 H3HEpMMHHH   D$     H
 HD$`HMp	 D$    E3E3HT$hHL$`9	 HD$`HcHHt
 HD`HD$`HcHDxDD\   HL$hHHL$`HHߦ
 JHHoHH
 0HIUHA	 HH>HUPHL$` HxrH H
	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@	 HD
 HD$(H!
 HL$( LSUVWAVH   ICHd
 H3H$   MIHHH$   IC   IC    D$h A   HH
 IK觼HD$`   HD$X    D$H A   H
 HL$HxHCH+HLOL+IL;t%HD$0Lt$(HD$hHD$ LHT$HH(  HD$`HrQHHL$HH=   r<t	 HAH;r	 H+Hsو	 H'v̈	 H; HD$`   HD$X    D$H H$   HrQHHL$hH=   r<t	 HAH;rs	 H+Hsc	 H'vV	 Hż H$   H3E HĐ   A^_^][@USVWAVH$PH  HD$@Hc
 H3H   ILHDD$8   D$0    H
 HD$PHM	 D$0   E3E3HT$XHL$P	 HD$PHcHHp
 HDPHD$PHcHxTL   HL$XHc
 HL$PHH*HH@
 Hȋ	 HH
 H   HL$PH   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@ݹHEx   HEp    E` A   HW
 HM`貹HE@HD$ LM`LD$8IHH\$WH 	HHf/v\XH\$0H _\(XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tYIHHt3	 He  HLsHsHuH{H|$hL?LHt3	 He  HHwHuH~H   H{(H|$hL?LHt3H	 He  HHwC< HH2  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H	ۃ	 t
He  HH    Hk~LFHHI H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3HC   HHC    H 	HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHH;uH   Ht	 Ґ3H	 D$0t/HHcHHLHځ	 u   |$`	H\$P|$`HHcHHE3h	 HHcHHLHHt*HHPHH;uH   Ht	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$hP uB3HD$8H
 HD$0H*y
 HD$(H
 HD$@HR
 HD$HHL$({P HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHH$z  ? t
HHÀ< uLHHtIE3HH貹HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLH~  HC   HHC    H [HH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
y  IE3HHǸA
   H
 HbHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHIHC   HHC    H gHH0[@WH   HD$ H$  AHHH$   谝  HX(H
 HH0x8HH$   -N HHL$(?N H
 HL$(Ŀ @SH   HD$PHZ
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$( ȋD$ -ut=   w2t=w2ɄuB3HD$8H6
 HD$0Hru
 HD$(H>
 HD$@H
 HD$HHL$(L HL$pH3 HĀ   [@SH   HY
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`L u-HT$PHL$Xo t9C,+<:wH     HrD$PH$   H3+ HĐ   [  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(g  @USVWATAVAWHl$H   HEHrX
 H3HEMcIcHLHM3ۉ]ϋ
\ eH%X      Hȋ
9# ~_H
#  # uHH&    H% % DCHY
 H
% H
p	 1 H
# h HE   H]E A   H/
 HM趯HE   H]E A   H
 HM華LOL+IAA;tLEHM{  HEHrPHHMH=   r<t.|	 HAH;r|	 H+Hs|	 H'v|	 Hp HE   H]E HEHrPHHMH=   r<t{	 HAH;r{	 H+Hs{	 H'v{	 H H?LIII_I_MtDHEt5HHHL;tEtHHHL;tMMt3@z	 I[  IMwIwH}LuIHMLuHEHEHEHEHEHEL}IHHH+HHH~)HH;}
H}HMLHHM% IHMH3蕧 HĐ   A_A^A\_^[]@USVWAVHl$H  HD$@HeU
 H3HE IHH  HE   E3LuDuEFH
 HM1HCDLEHH&HEHrPHHMH=   r<ty	 HAH;ry	 H+Hsy	 H'vy	 H H{urH f/ waHE   LuE E3H
 HM耬HE   LuE E3H
 HM\HEHD$ LMHHA HHM&  HT$PH({  HM%x	 }    E   HL$`HL$0L\$XL\$8HD$0HT$8I;HMHMLD$PW IH~N   If/sEHIH;|II|LHHd  HMw	 HL$pw	 HL$P|w	 aHE   LuE E3Hv
 HMOHE   LuE E3HR
 HM+HEHD$ LMHH@ HM H3 H  A^_^[]@SH LHHuHRAHH [HHRHcHHAHH [@USVWAVH$PH  HD$@HR
 H3H   ILHLD$8   D$0    H
s
 HD$PHMu	 D$0   E3E3HT$XHL$PWu	 HD$PHcHH&`
 HDPHD$PHcHxTL   HL$XHө
 HL$PuHHHH
 [Hȋ t	 HH~
 AH   HL$P0}H   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@MHEx   HEp    E` A   Hǣ
 HM`"HE@HD$ LM`LD$8IH  LSVWH   ICHP
 H3H$   IHHIC   IC    D$h A   H
 IK襨HD$`   HD$X    D$H A#   H
 HL$HvHCLKL;t%HD$0H|$(HD$hHD$ LHT$HH  HD$`HrQHHL$HH=   r<tu	 HAH;rt	 H+Hst	 H'vt	 HG HD$`   HD$X    D$H H$   HrQHHL$hH=   r<tt	 HAH;rt	 H+Hsot	 H'vbt	 HѨ H$   H3Q HĐ   _^[@UVWATAUAVAWH$@H  HD$8H$  HO
 H3H   MLL3ۉ\$0A   MPM;  EWɋHE~0MNHcI;}$IIIHf.z uHI;|AIIcI;  Hr
 HD$PH:o
 HD$`HMq	 D$0   E3HT$hHL$Pq	 HD$PHcHHVk
 HDPHD$PHcHhTLHD$hHD$@HL$hn	 Hf
 HD$hH]Љ]Hަ
 HL$`HHB
 }HIHHd
 cHȍV'p	 HH
 HHAWp	 HHu
 ,H   HL$PvH   H   HC   Hǅ      3H   @}p@8:uD
IIB8<uHMp;IcHcMINHHIHEh   H}`EP E3H&
 HMPHEPHD$ LMpLIIs- H   H3Þ H$  H  A_A^A]A\_^]@USVWAVH$PH  HD$@HL
 H3H   ILHDD$8H   D$0    Hm
 HD$PHMo	 D$0   E3E3HT$XHL$PVo	 HD$PHcHH%Z
 HDPHD$PHcHxTL   HL$XHң
 HL$PtHHHH
 ZHHl	 HH|
 ?H   HL$P.wH   H   HC   HEX   HEP    E@ : uE3I@ IB< uHM@MHEx   HEp    E` A   Hǝ
 HM`"HE@HD$ LM`LD$8IHtH\$WH HIHՈ	 tHHiHH	 ZHm	 HHH\$0H _H%m	 H\$WH HIH]	 HH	HHc	 Hl	 HH3H\$0H _H%l	 @SH H	 IHH	
 HH	 Hbl	 HHH [H%Tl	 H\$WH HIHՋ	 THHIHH	 :Hk	 HHsH\$0H _H%k	 @SH H	 IHHi
 HH	 Hk	 HHH [H%k	 @SH HG	 IHH
 HH&	 }H(k	 HHH [H%2k	 @SH H	 I;HHњ
 ,HH	 Hj	 HHVH [H%j	 @SH Hw	 IHH
 HH	 Hhj	 HHH [H%rj	 HHHD$0D$    L

 Lu
 36 2HHHHHD$0D$    L

 L5
 3 2HHHHHD$0D$    L

 L
 3 2HHHHHD$0D$    L
ܽ
 L
 3v 2HHHHHD$0D$    L

 Lu
 36 2HHHHHD$0D$    L

 L5
 3 2HHHHHD$0D$    L
<
 L
 3 2HHHHHD$0D$    L
l
 L
 3v 2HHHHHD$0D$    L
D
 Lu
 36 2HHHHHD$0D$    L

 L5
 3 2HHHHHD$0D$    L
İ
 L
 3 2HHHHHD$0D$    L

 L
 3v 2HHHHHD$0D$    L
l
 Lu
 36 2HHKS  ;Q  HWATAUAVAWHPH@HXHhHpMLHIPI  I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8G  Hl$@LH\$8LIT$Ik  HtZHH)  HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HH HII HFH+HH;s(:\h	 Uh	 Nh	 Gh	 @h	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@HB
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`HIo	 H  3H  H  H	 HEpExH  HMpe	 H3_
 H  HM 
 H   Ha
 HE@Hvc	 HEHHEPHEXHc	 HE`HEhH,R
 HEH   _  H  _  H  l
   ~y   A   ~x DEHVXHzrHH   E3HH   HcHH   uHAPb	 H3~b	 F|uHS	 H   H	 auHZ	 H   H	 @uHI	 H   H	 u2H8	 H   H	 HHHYc	 H   E H   H6      H   HzrHA   H  ֢E3HH  HcHH  uHAPwa	 H3ba	 F|uH7	 H  H8	 auH>	 H  H?	 @uH-	 H  HN	 u2H	 H  HM	 HuHH=b	 H  ) H  HHǅ     E3L  D   EFHg	 H   臗HX
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  gH  HrSHH   H=   r<tc	 HAH;rc	 H+Hsc	 H'vc	 H6 L   HNHYHyrH	HA   I;LBMtH1	  u1Hu+Klғ H   LF8HV(HHH      襓 HHZ
 HH   WELuAEHUIH]
 HEWELuAN   D.DvDu~HH
nR
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHI  DGHUHM蛙HD$ IH    HOHVH  Ht)L  L+IˉW  Hǅ      HUHtLEL+I蜉H\
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHI褗  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHI  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHIK  DHUH   HM1HQH}LL+3^	 HH}H}8HO HU"Pw8HUHtLEL+I$H  HtL  L+IH}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMHIHǅ     Hǅ      ƅ   A   HJ	 H  貑LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   ߚ LH  UH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHIZ  D    PHM-HA
   HX	 LuI贐IN A   HK	 螐IN@A   HE	 舐IN`A   H?	 rI   A   H6	 YHǅ     Hǅ      ƅ   A   Hc	 H  #LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   P LH  AT    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHII  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIb  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  Dq  d  PHMBA
   H
	 LuIIN A
   H 	 IN@A   H	 Hǅ     Hǅ      ƅp   A   H	 Hp  跊LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H    LHp  N          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI'  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIz  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$   D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ ?  DLupEWA(WEHE    DEHUH+UHLEHMH  HMH+M HLM L+MILɋ   ~gfn
 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@F  G HOpH6  H   HMHD$ IH  j  HOH>FH  Ht)L  L+IyW  Hǅ      H   HtL0  L+IxH  HUA  H   H  UHǅ     Hǅ      ƅ   A   E3H)	 H   ~HEHtTA   LH?	 H   }LEI+LH  H   rGHH  HH  7HD   D   A   E3H	 H   y}H  HHEL@A   H	 H   J}HLLEH  H   FHH  UH  GH   H  L	 A   LHP	 H   |HL@A   H	 H   |LLGH   H   VFHH  fH   GH   H  5L	 Hx  SHx  [M	 H}8H  H  H;tIE3H  aIP  HW  Hǅ      MX  H  } HU H W   Hǅ0      LEH    LM LEH(  H   bQ  H  H  /C  H  H   9HOXHUp9MtI   IH   Ht&H(  H L0  L+IHksH  Ht=H  H H  H+H*HHLI?LH2bH  uEH   hEHUHtLEL+I>uH}Ht HU H LE(L+IHrH} HtHUH LEL+IHrH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H:	 Hp  H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H    HHEpHp  CH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    u    DW   E3L0  L   H   H    H(  H   H+I*IHHHH?HHH  =EL  L  M+IMt ff     HHKIHM;rH}8H  H   ?  H  HUS6H  H  @;HOpH/  HU HMׁHD$ IHMU  HOH)?HUHtLEL+IrWELuHU HtLEL+IqHMpHtH   H  HtL  L+IqH   Ht:H(  H H0  H+IHHLI?LH6^E3H}HtH   HHUHtLEL+IAqWELuH5&9
 HuH]HtHH  LEL+IHnH=
 H@  HP  @H@  Hx  MHx  HG	 H  -  H   -  AH  H3v L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHH&3fD  H;_s^I4H[
 HHHM
 H;>
 r
   躇HH$   Ht
(RHHHD$8HHMLD$8H$   H  H$   pH      ?HHH=
 H

 H9

 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI&;HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v
G	 H    H=   r<tF	 HAH;rF	 H+HsF	 H'vF	 H3{ ] (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH$3fD  H;_s^I4H
 HHH
 H;
 r
   jHH$   Ht
(HHHD$8HHMLD$8H$   H  H$   pH      ?HHH=
 H

 H9

 t	H~
 $HH+r
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI8HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;vD	 H    H=   r<tD	 HAH;rD	 H+HsD	 H'vtD	 Hx 
 (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
u
 @	 HL$8@  3I9~  HL$@LD$8     I4H
 HHHs
 H;d
 r   HHL$@LD$8H$   Ht(HkHHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8?  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8
?  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
t
 >	 H
t
 >	 MLD$8H$   IV  H pY HL$8Ht{HD$HH+HH;vA	 H    H=   r<tsA	 HAH;rcA	 H+HsSA	 H'vFA	 Hu WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
r
 Q=	 HL$8~=  3I9~  HL$@LD$8     I4HQ
 HHHC
 H;4
 r   HHL$@LD$8H$   Ht(H;HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8[<  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8;  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
p
 e;	 H
p
 W;	 MLD$8H$   If  H p) HL$8Ht{HD$HH+HH;v_>	 H    H=   r<tC>	 HAH;r3>	 H+Hs#>	 H'v>	 Hr WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HWATAUAVAWH  HǀHXHp)p)xD)@D)HD)PH
 H3H$  MLHL$ H$@  3H1IU IEH+HHurHE	 H$  3H$  H$  Hr
 H$  Ƅ$  H$  H$  ;	 H4
 H$  Hr
 H$   DDT$pIEH+HHwrHrD	 H$  3H$  H$  Hq
 H$  Ƅ$  H$  H$  :	 HL4
 H$  H}q
 H$  @ A   DJDL$xWD$83H|$HMcFxLD$(DIM  HT$@fD  IEI+E HL;  IIIE 4t$0HD$0HL$8H;   HD$0H;   Lt$0L+IH;uyHH+HHsiH+HIIH+H   HH+HHHIH+HLH;LCL;ICHL$8?Ht$HHT$@HL$8LD$(HtJHItH;ufHH+HHsVH+HIH+HrtHH+HHHIH+HLH;LCL;ICHL$8跊Ht$HHT$@LD$(Ht2HHT$@IM;   H
l
 07	 H
l
 "7	 HB	 H$  3H$  H$  Ho
 H$  Ƅ$  H$  H$  8	 H1
 H$  H%o
 H$   IEI+E HL;rrHA	 H$  3H$  H$  Ho
 H$  Ƅ$  H$  H$  8	 Hq1
 H$  Hn
 H$  e IIIE 
 (EWAX|$(WL$PLH|$`HD$ LcH,L$  LH|$hM4  HT$XfD  IEI+E HL;  IIIE 4t$0HD$0HL$PH;   HD$0H;   Lt$0L+II;   IH+HHsqH+HIIH+H
  HL+IIHIH+ILI;LCL;ICHL$PKLd$`HT$XHL$PLD$hL$  HtJHI   I;urIH+HHsbH+HIH+H   HL+IIHIH+ILI;LCL;ICHL$P贇Ld$`HT$XLD$hL$  Ht2HHT$XILD$hM;   eH
i
  4	 H
i
 4	 H
?	 H$  3H$  H$  Hl
 H$  Ƅ$  H$  H$  5	 H.
 H$  Hl
 H$   HD$pH;C   LHD$pL;   L|$pM+IHCH9CuqH+CHHscHKI+HIH+HsH
h
 73	 HSI+HHLCM+IIHL+IHM;HCH;HCH@HKHHtJHA   )HCA   H9CuAH_HCHtDHCHD$xH;CsCHHL$xH;w6Lt$xL+IHCH9CuIHn_HKHHt,JH#HCH9CuIHD_HCHtDHCDHD$ L|$89xx~)H@      IcIHa(AD;wx|3HD$(H;CsCHHL$(H;w6Lt$(L+IHCH9CuIH^HKHHt+JH"HCH9CuIH^HCHt8HCDHD$ Ll$Px, ~2Lfff     IcH    IH'AE;w,|L|$8$H   u8MtM+IMI\M  I+HLI[  W$   H$   
    HǄ$     H$  Ƅ$   A   EHc
 H$  gHǄ$     H$  Ƅ$   EEHd
 H$  fLt$ EFxEyH$  H$  *H$  <+H$  .+D$  IcVxW$  H$  L$  H$  W^HH$  L$  I+HI      HtM4HH;rHHtf     M4HH;r
    HǄ$     H$  Ƅ$   A   Hf
 H$  eHǄ$     H$  Ƅ$   A   Hc
 H$  eHD$ D@xAyH$  H$  H$  )H$  )D$  HD$ @xHcW$  H$  L$  H$  ]HH$   H$  H+HHtL4HH;rHHt     L4HH;rf
    HǄ$     H$  Ƅ$   A   Hb
 H$  dL$  IH$  {  DH$  (EfD  HD$ D;pxI  
    HǄ$p     H$h  Ƅ$X   A   H:b
 H$X  dHǄ$P     H$H  Ƅ$8   A   H`
 H$8  cIcL$X  HH$    H$  L$8  HHL$8  0H$  X0HǄ$0     H$(  Ƅ$   A   Ha
 H$  [cAIcL$  H$  ?  0H$  'H$8  'H$X  'Ht$HD$  =&
 fD  D;hxL  x
 %   HǄ$     H$  Ƅ$x   A   HC_
 H$x  bHǄ$0     H$(  Ƅ$   A   H`
 H$  obHǄ$P     H$H  Ƅ$8   A   Ha`
 H$8  8bMcHL$ H   L$x  I  HD$(L$  IH$    H$  E}IcL$8  H$    H$  ^ (\HD$(A\YHǄ$p     H$h  Ƅ$X   A   H_
 H$X  xaL$X  IH$  _  0H$X  %H$8  %H$  %H$x  %
 &   HǄ$     H$  Ƅ$x   A   H_
 H$x  `L$x  IH$    DXD$  H$x  ?%EL$  HD$ ,
    DD;px}IcIHh AHD$ DL$   @xHD;}IcH    I0 AHD$ H$   $P      MtL$  M+II~TMtL$  M+IIaTH$   Ht#LL+IDTW$   H$   HT$PHtL+IMTWD$PH|$`L|$8Mt I+HLISWD$8H|$H{MtL$  M+IISMtL$  M+IISH$   HtH+HLSHT$PHtL+IMmSL|$8XH$  H3X L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_LWH`ICI[IsHi
 H3HD$XHIK3t$ H1HqHqD$    HaHD$P   Ht$H@t$8DFHw	 HL$8^HD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHRHH;HKHthHA   HqHyrHHH@HCH9Cu
   HRHKHt(HA   HqHyrHHHT$8  ;cHC HD$PHrQHHL$8H=   r<t(*	 HAH;r*	 H+Hs*	 H'v)	 Hj^ HHL$XH3V H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUHL?LLE   HuHI?LuI;   HHMHHMc HH HMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHW] HI;{(	 (	 (	 (	 (	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   H'=HOHMPH[HHHMXHt2HGH9Gu
   H<HOHMPHMXHt
HURHGHMHtiHEH+HI;v'	 H    H=   r<t'	 HAH;r'	 H+Hs'	 H'v'	 H[ H   IH  HMH+IHHHH?HH
H;v>'	 HRHH=   r=@t!'	 HFH;r'	 H+Hs'	 H'v&	 HH`[ HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHH  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   H=HSHt(H
H;Cu
   H=HCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H<HSHt(H
H;Cu
   H<HCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_@WHpHD$ H$   H H3HD$hHH
f.
 zu	P  HD$`   HD$X    D$H A   HX
 HL$HWHD$@   HD$8    D$( A   HX
 HL$(nWLLHT$HHL$(h HD$@HrQHHL$(H=   r<t$	 HAH;r	$	 H+Hs#	 H'v#	 H[X HD$@   HD$8    D$( HD$`HrQHHL$HH=   r<t#	 HAH;r#	 H+Hs#	 H'vy#	 HW \z HL$hH3^P H$   Hp_H\$Ht$WH IHHH;t HHHHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HH	WH H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`	 H5
 Ht$hH
	 x	 HHEH;xsHHHH   3ۀx$ tz	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8H>
 HD$0H
 HD$(H HL$(a H\$hH
 HHRHN HL$`	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$P	 Hg
 HD$XH
	 e	 HHFH;xsHHHH   3ۀx$ tg	 H;xs
H@HHumH\$XHucHHL$X	 Hu13HD$8H<
 HD$0H
 HD$(Hx HL$(` H\$XH
 HHPHM HL$P	 HH\$`Ht$hH@_H\$WHPHw H3HD$@HHD$8   HL$ HD$0    ID$  E3|THLD$ HWHH HHD$8H+HHrQHL$ HH=   r<t	 HAH;r	 H+Hs	 H'v	 H2T HHL$@H3L H\$`HP_H(Hu3H(HH;w*H\$ H    Hs	 HuHuH\$ H(gg@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0Ou t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHR  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHRu  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H  H
 HCPH [HL$SH0HD$ HD$P    EtH8
 HA@H
 HAPD$P   J   H3
 HHy8
 HCHC@HcHH
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH$	 HHQ3HHBHK	 H
 HH{3HHDH^H\$HH
 HHOHKHtHPHGHCHGHCG C Hr
 HHx
 HHH\$PHt$XH0_H
 HH@SH HHI0	 HK 	 HH [H%	 H
 H@SH HH   H`HcPH
 HHHHHcPDHDDHhz	 HH [H%+	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3	OHo(Hs(H;t<HHRH݄HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHdHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3ONGxCxGyCyG|C|H   H   H;tIE3N                                                  HH\$HHl$PHt$XH0_H\$WH H  H
 HGPt
X   HM HH\$0H _@WH0HD$ H\$@HH`
 HH
 HAHI HtHP tHC     HX 	 HHK	 @t
@   HM HH\$@H0_H	HtH   H @UVWAVAWH$@H  HD$8H$  H9 H3H   IILHE3D|$0AA fAn	ff/rHHrY  H}
 HD$PH
 HD$`HM	 D$0   E3HT$hHL$P	 HD$PHcHH
 HDPHD$PHcHhTLHD$hHD$@HL$h@	 H
 HD$hL}D}HK
 HL$`HL$`	 H   HL$PH   H   HC   HEh   L}`EP : uMIfD  IB< uHMPIHǅ      L   Ep A   HK
 HMpIHEPHD$ LMpLIH4  H   H3C H$  H  A_A^_^]@UVWAVAWH$@H  HD$8H$  H9 H3H   IILHE3D|$0AA	A;|HHrU  H
 HD$PH
 HD$`HM&	 D$0   E3HT$hHL$P	 HD$PHcHH
 HDPHD$PHcHhTLHD$hHD$@HL$hL	 H	
 HD$hL}D}HI
 HL$`HL$`	 H   HL$PH   H   HC   HEh   L}`EP : uMIfIB< uHMPGHǅ      L   Ep A   H!I
 HMpGHEPHD$ LMpLIH  H   H3A H$  H  A_A^_^]@UVWH   HD$8H$   HU H3H$   IHH3IHIPHHH   M II           HcAD$0HD$0I#I;wHHHH;r   HD$X   HD$P    D$@ A   HH
 HL$@FHD$x   HD$p    D$` A   HG
 HL$`FHD$@HD$(HD$`HD$ LLHHm  H$   H3<@ H$   HĐ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   III       HcD$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HF
 HL$@zEHD$x   HD$p    D$` A   HF
 HL$`KEHD$@HD$(HD$`HD$ LLHH5  H$   H3? H$   HĐ   _^]@SVWH   HD$0H H3HD$xIHHA8 |HD$P   HD$H    D$8 A   HF
 HL$8DHD$p   HD$h    D$X A   HE
 HL$XqDHD$8HD$ LL$XLHHS  HL$xH35> HĀ   _^[@UVWH   HD$0H$   H H3HD$xIHH3IHH   IW    Hcf/v
HH;r   HD$P   HD$H    D$8 A   H	E
 HL$8CHD$p   HD$h    D$X A   HD
 HL$XhCHD$8HD$(HD$XHD$ LLHHR  HL$xH3$= H$   HĀ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   II      @ f     HcD$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HC
 HL$@jBHD$x   HD$p    D$` A   HC
 HL$`;BHD$@HD$(HD$`HD$ LLHH%  H$   H3; H$   HĐ   _^]@SH0HD$ HH7	 HH
 HAHI HtHP tHC     H?	 HHKH0[H%d
	 @SVWH   HD$8Hm H3H$   IHHA D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   HaB
 HL$@AHD$x   HD$p    D$` A   H*B
 HL$`@HD$@HD$ LL$`LHHJ  H$   H3: HĐ   _^[LH   ICAC    HQH+)
 ICH0
 ICAC   IKH
 HD$(H(
 HD$@HD$hHcHHK	
 HDhHD$hHcHDd    H HL$(L @SH0HD$ HٹX   = HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH
 HH(
 HAHA@HcPH
 HD
@HA@HcPDBDD
<H	 HH

 HAHI HtHP tHC     H	 HHKH0[H%
	 @SH0HD$ HHW	 HH	
 HAHI HtHP tHC     HO	 HHKH0[H%t
	 HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf  HWH:  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHXc pMt/HWI  HOH+IHHLI?LHRHNH+IHHHH?HHtLHVHb HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+H2HH+HH4H+H2HOHHLH+HH+_  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   8 HH$   LCMu	H$
 
IP(HuIP0HL$(K	 HǄ$      3Hz	 H	 HHH4  H>HL$(	    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
:
 n	 H;s/LeHtH{HsrH3 H\$0Ht$8H _HsH;LƲLB3HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    H
 HH	 HAH   W	 D$H   H_E3HH	 HHcHH,	 H9HHcHHT9H\$PH	 Ha	 HC| Cq Hu	 Hǃ       H
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH	 HH
 HAHI HtHP tHC     H
	 HHK	 @t
@   Hx: HH\$@H0_H\$WH HHHUt
  H;: HH\$0H _@SH HH		 HKH [H%	 LHXICLI@I+ HHQH;rQH	 IC3ICICH:
 ICD$0ISIK	 H	 HD$8H$:
 HL$8  HBHAI HXDD$HL$WH0HD$ H\$HHt$XHH3t$PH 
 HA@H	 HAPD$P   H	 HHOH9 
 HHG@HcPH 
 HD:@HG@HcPDBDD:<HSHHD!.HH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H		 HtHLHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
5
  	 L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HHPHSLHH? HH{H+HHtLCL+I\*HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
H4
  H|$@K<H   HvH
"4
  H9{s#HH_H   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0 H{rHHHtLHW H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%( 	 HWAVAWH   HD$(HXHp H H3H$   LLHL$ H HT$0I 3IFIF IF(HT$`I H

   IFI HHHHǀ<8 uHǺ   Hs HHu HHtHRHvHuIN I- HHÀ< uHú   H  HHuZ HHtff     HIHHuIV(fAF.,H$   H3, L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
1
  LAI+H|$8H|$PH;HGIHH;wH
n1
  Ht$0I48H  HvH
H1
  H9qs H]H   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8 I;u>HKI?MIDHrHHHrHHHt8HL *I~rM6H{rHHHtK>LT H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HHԯ HH0[@SH HHHSH
Q	 H3H
HJHH 3HC HC(HC0H	 C8HH	 HCHH [@SH0HD$     - HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH
.
 c I4L+IIHH+I3I;HCH;HCHt$@H&OLHD$8HD$0LHT$xHY` HD$0LH$   H$   \\ HD$0LHWHL$x&` HWHHH+HHHtg  HLGL+ID!HIHwHIH_L7%IH[ HHWLHL$x H_H\$pHPA^_^@SUVWH  HD$8H H3H$  IIHHI@I+ HL;A  HL$@OH1
 HL$PgHH HH?1
 gHH0
 gHH0
 gHHj0
 gH$  HL$@SH$  H$  HC$  HǄ$X     3H$P  @$@  @8:uD
IIB8<uH$@  -HǄ$x     H$p  Ƅ$`   A   H0
 H$`  o-HCH+HHD$0H$@  HD$ L$`  LD$0HH虮 H$  H3' Hĸ  _^][@USVWATAUAVAWH$H  HD$@H H3H  IHLLL$8LP  LX  L`  3ۉ\$0HZ	 HD$PHM D$0   E3E3HT$XHL$P HD$PHcHHs	 HDPHD$PHcHDxDDLSHL$Xd:HHL$PiHHiH  HL$PH	 HE@H   A D$0   E3E3HUHHM@ HE@HcHH	 HD
@HE@HcHDxDD
<SHMH9H+
 HM@.eHISiHIHiHH^+
 	eHI HH++
 dH  HM@H  H  HC  HǅH     H@  0  8uDIIB< uH0  *Hǅh     H`  ƅP   A   Ho%
 HP  *H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  u*H0  HD$ LP  LD$8Hp  I譫 Hx)t$`()|$PD)D$@DP
 D)L$0D
 fD/D)T$ EWA(r`A(\(|M (\f/
}
 vAXfA.zu 
  !      =\
 Y(TM ^fA.ztf/5
 r
(職 O
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(蠸 X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     H_	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHHx	 HD`HD$`HcHDxDD\   HL$hg6HHL$`eHHO
 aHHeHHe
 aHIeHAY HHeHUPHL$`pHxrH H
f HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H	 HD$(H HL$(<4 @SH`W)t$Pf/D)D$0D(   u+DWO
 3A(W=
 (t$PD(D$0H`[̘
 fA/DW
 A(v(
 \((t$PD(D$0H`[3bX

 (t$PD(D$0H`[5a
 fA/)|$@D)L$ D
ؕ
 !  
 fA/vTfD.z  }
 eH%X      HЋ9u
   %
 AYDY
 AX  =}
 eH%X      HЋ9
 
  A(AY(Y((Y%Z
 (Y

 Y?
 X%/
 X
g
 X
 YYYW
 X%
 X
/
 YX+
 XYX^X%Ӕ
 AY  3t

 
 fA/  W|
 eH%X   =
 fA/   HЋ   9З
   A(A(\AYW
 (YH ((Y
 (Y
 (Y
J
 Xڌ
 Xʌ
 A^X

 YYYX
 X

 YYX(Y
 X

 Xj
 Xʈ
 YX
 YX^XҒ
 Y  ٓ
 fA/   9H
 '  A(A(\AYW

 (YG ((Y(
 (Y
 (Y

 X
 X
 A^X

 YYYX
 X
a
 YYX(Yb
 X
 XB
 YXX
"
 ^X
 Y  5
 fA/   9ܕ
   A(A(\5
 AY(W
 YF ((Y
 (Y݊
 (Y
B
 X
 X
 A^X

 YYYX
 X

 YYX(Y
 XZ
 Xʍ
 YXX

 ^X.
 Y   9
 Z  A(A(A^AY(YW9
 E ((Y
 (Y
 (Y

 Xh
 XX
 A^X
Î
 YYYX'
 X'
 X

 YYYX
 X
c
 X(Y|
 Xd
 YXH
 YX^XD
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
N
 % =B
 $
 H
-
 
  H

  =
 (ۛ
 H

 (
=
 
 F
 &
 (ϓ
 H
 `
 

 (

 :
 

  qH
2
 i =&
 V(
 H

 (
+
 L
 (
 ^
 (ߔ
 
@
 (
ѕ
 
 
 
c
 (
4
 
 
m
  H

  =
 (k
 H

 (
-
 ք
 (?
 
؄
 (
A
 ڄ
 (
 
T
 (
 V
 
_
  [H

 ] =

 .(
 H

 (

 
 (
 

 (
 
 (
 
N
 (
 P
 
Y
  H
T
  =H
 (/
 H
4
 (
 

 (
 
 l
 
 (
 

 (
 P
 
 
1
 (
ʔ
 R
 
;
  @USVWATAUAVAWH$H  HD$@H, H3H  IHLLL$8LP  LX  L`  3ۉ\$0H	 HD$PHM+ D$0   E3E3HT$XHL$P HD$PHcHH	 HDPHD$PHcHDxDDLSHL$X+HHL$PF[HH;[H  HL$PH	 HE@H    D$0   E3E3HUHHM@\ HE@HcHH,	 HD
@HE@HcHDxDD
<SHMH+H
 HM@~VHIZHIZHH
 YVHI HH{
 >VH  HM@.H  H  HC  HǅH     H@  0  8uDIIB< uH0  JHǅh     H`  ƅP   A   H
 HP  H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  H0  HD$ LP  LD$8Hp  I
  @USVWAVAWH$xH  HD$PH` H3HEpIMHHL   D$     H	 HD$`HMp D$    E3E3HT$hHL$`9 HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h(HHL$`XHH
 JTHHoXHH	
 0THHUXIHuHV
 HTIH IH#XHUPHL$`HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@x H1	 HD$(He HL$(& DD$USVWAUAWHl$H   LjLy3HHM;otI Mt
III7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH' Mt
IbHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMb HIH HHGHGHtHl    H
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM$ w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH? Mt
IzHH7LEwH_HUoLwH H}HEHHMLwH]LuHEh W(f.z
u5 
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]Lu^ IUHO(LG(IHr HW(H|$ IQ G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM ($   L$   HL$   fG<Hĸ   A_A]_^[]F+@+:+@SH HHHSH
! H3H
HJHH 3HC HC(HC0H	 C8HHE HCHH [LHXIC3ICH$	 ICHa	 ICH.W
 ICH
 ICIK趯 @USVWH$HH  HD$@Hļ H3H   IIHT$8D$0    HV	 HD$PHM D$0   E3E3HT$XHL$P HD$PHcHHo	 HDPHD$PHcHDxDDL   HL$X^"H
 HL$PMHHQHH
 MHHV HH
 MH   HL$PvH   H   HC   HEX   HEP    E@ : uE3IIB< uHM@HEx   HEp    E` A   H
 HM`nHE@HD$ LM`LD$8HH
!
 T@UVWATAUAVAWH$0H  HD$XH$(  H H3H  IH\$@HHT$8HL$HE3Dd$0iLKI  EM  
 /
     M]MM;}UHN    IIIHIIIL@ f     A \Tf/rIHMM;|MM;  H	 HD$`HMk D$0   E3E3HT$hHL$`4 HD$`HcHH	 HD`HD$`HcHxT\HD$hHD$PHL$h HV	 HD$hLeE   H?
 HL$`5KHHZOHH
 KHIU HH
 JHIWz HHH
 JH  HL$`H	 HEPH   i D$0   E3E3HUXHMP4 HEPHcHH	 HD
PHEPHcHxT
LHEXHD$PHMX HZ	 HEXL   ǅ      H;H[IIHD
 HMP'JHHT$8JNHH
 JHIW HH
 IHIUj HH8
 IH} H  HMPH  H  HC  HǅX     LP  ƅ@   : uMIfD  IB< uH@  H  H  HC  Hǅx     Lp  ƅ`   : tIIB<" uMH`  wHD$@L H@IIMH@  HD$ L`  HT$8HL$H͗  H  H3	 H$(  H  A_A^A]A\_^]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;t1$IHHt3 HԻHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     HO	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHHh	 HD`HD$`HcHDxDD\   HL$hWHHL$`JHH?	 FHHJHHU	 FHIJHI HHJHUPHL$``HxrH H
V HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H	 HD$(H q HL$(, HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH	 HEL%	 LeH	 HEH	 HEL5	 LuD$    L-	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH= HE3HEHEHUHM HY	 HD$0H	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP H^	 HD$@HR^	 HD$HE   
a
 eH%X   A   HȾ   A9|
 Z  H
|
 H =|
 A  NW LHEwH	 IF@H	 IFPD$    HT$0I  H	 IH|	 IF(IF@HcHH1	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw܆ HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHMEm~
 fsfH~HtBHMH
' j
 H
{
  L5	 '~
 x~
 fsfH~HtpH	 HD$0HQ	 HEHEHcHH	 HD
HEHcHQT
Ld$0H> H]HMh Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM- LmHMHtHR H}
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH	 HEL%h	 LeH
	 HEHj	 HEL5o	 LuD$    L-T	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH HE3HEHEHUHM H	 HD$0HU	 HEHEHcHH	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP H[	 HD$@H"[	 HD$HE   
D]
 eH%X   A   HȾ   A9z
 Z  H
z
  =yz
 A  NW? LHEwH	 IF@H	 IFPD$    HT$0I蕱  HN	 IH	 IF(IF@HcHHY	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHMYE|
 fsfH~HtBHMH
  H
>y
 Q  L5	 G|
 P{
 fsfH~HtpH%	 HD$0H	 HEHEHcHH.	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM LmHMHtHR Hz
 H$H  H   A_A^A]A\_^]@UVWATAUAVAWH$pH  HD$HH$  H H3H   MHHHL$(3Dt$ IPI谇  IIFHCH+HsHI豹[  WD$0Ht$@HHM`rHT$0He L|$0ILd$8M;  H	 H
	 HL$`HT$pHM- ADl$ E3HT$xHL$` HD$`HcHH	 HD`HD$`HcHhT\HD$xHD$PHL$xR H	 HD$xHuuHHL$p1@HH*	 ;HsH+3H3Ht(HHL$p HH*	 ;HH;rHHL$pf HH*	 ;HU`HL$`IHIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICI*HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICIZ*IvHtrHF   3HNH~rHHƈHsLGItHH
 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM] HI;t(H|$(39H
Q	  H
C	  Mt6IIL  HL$@I+H*HHLI?LI1H   H3 H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHM(HHM<WE3H]Ll$8H|$0\$(L$ LMMHHM' HE   H]]DCHR	 HMsHHUHP HEHrPHHMH=   r<t( HAH;r H+Hs H'v Hj L|$8H|$0Lt$(EwD$ ]oLEHUH諯 HUHt LEL+I@WEHE    HUHtLEL+IgHMH3y H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   HHT$PHtLD$`L+IHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xH H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`$HHL$d7W$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$x H$  XL$   HT$xI (D$@IH$  IPH$x  H$x  , E3|$@L$   L$   Ld$pH|$hH$  HQ	 H$  t4H(  IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   HR	 H$  H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$H4#HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH
i	  HQM+IIHL+IIM;HCH;HCHL$H"HL$PHt0HA   LqHyrHHH$    HL$PH HL$PH$  `AEHT$HIqI$H
y	 H;tHT$HIP A$     D
wr
 De
 $     W$  L$  H$  /D$0D$(H$  HD$ LD$xI:H$   H$  eHXH$   蔼HtIH$  IPHD$@HD$ A   L$  HT$pH$  DO I$L@H
}	 H$  H;uIL$IAАH$x  H$x  z H$  HtL$  L+I|$@HHHH;tHD(L$   HT$xI (D$@H$      H$    HHN	 H$   q0HHuI
H HcHHHW
   H$   A HƋH HH 	 "0HH N	 0HHuI
H HcHHHW(A\(H HHM	 /H( HH	 /IH$   IPATH$x  H$x   fD/s;$  H|$haW$  L$  H$  D$0D$(H$  HD$ LD$xI詄H$   H$  HXH$   HtIH$  IPHD$@HD$ A   L$  HT$pH$  L I$L@H
	 H$  H;uIL$mIAАH$x  wH$x   H$  HtL$  L+IGHL$HHt.HT$Px  LD$XHT$HL+IWD$HLt$XH$x  H$x  s HT$xHt%L$   L+IWD$xL$   H$   HtL$   L+I3H$   H3  L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xH H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xYHHL$|lWEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`O H  H  H  n? H  HUH   ƙH  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#35 HuHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  i H      	    	    	    	     	    Hc(	  H  8  =9k
 Wt$XH  HH	 H  *H(L IH  IPWD$@Ll$PHǅ     L  ƅ   A   HH	 H  H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
Q	 ӹ HQM+IIHL+IIM;HCH;HCHL$@hHL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@HL$HHt/HA   LiHyrHHH    HL$HH HL$HH  薳AEHT$@HRgIH
	 H;tHT$@IP 0	  @   WELmH  D$0D$(HEHD$ LD$`H}H  H  ̿HXH  HtIH  IPHD$XHD$ A   LEHUHME IL@H
	 HUH;uIOvIAАH(  聿H(   HUHtLEL+IZH
#Lc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   HE	 H  WIH  IP H  ɱH    D8  Wt$XH  HL$`蘭3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   tH`     HM
 HH'	 H   %HHu3
H HcHHHWHH HH	 %   HM HH+	 H   %HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HH	 8%H(  <j (YH     HM HH	 H   $HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H` HHB	 $   HM( HHT	 H   t$HHu3
H HcHHHW   HM8Y LHu3
HHcHHIPAH  0i (H̴ HH	 $
   HMH HH	 H   #HHu3
H HcHHHW   HMXų LHu3
HHcHHIPAP  H? HHa	 x#
   HMhi HH	 H   S#HHu3
H HcHHHW   HMx8 LHu3
HHcHHIPAX  H HH4	 "HP     HMղ HH	 H   "HHu3
H HcHHHWHHW HH	 "H	 H   u"HHh  &HH	 W"IH   IPH(  *H(   0	  HuH  H  ϹHXH  H   IH  IPHǅ     3H    E3H' H  &H  H  H  HC  H  L  Mt
H  cH  f@  W  H  H  菺D$0D$(H  HD$ LD$`HvH  H  ȸHXH  HtIH  IPHD$XHD$ A   L  HUH  > IL@H
	 H  H;uIOiIAАH(  tH(   H  HtL  L+IGEH

@
  W  3H  H  nD$0D$(H  HD$ LD$`HzuH  H  觷HXH  תHtIH  IPHD$XHD$ A   L  HUH  = IL@H
ŭ	 H  H;uIOHIAАH(  SH(  ư H  HtL  L+I&3Hǅ     H  ƅ   H  Ex4A"   Hh=	 kIH  IP H  ݩ5A$   H=	 7IH  IP H  詩F   EH  E  LH	 H  0MHIAP H  cH  VHL$@Ht.HT$Hh  LD$PHT$@L+IWD$@H|$PH(  H(  t H  7  H  軐  H(  εH(  A HT$`HtLD$pL+IWD$`H|$pHUHtLEL+IH`  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xH H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$x9HHL$|LWEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`/ H  rH  H  ~' H  HUH   覉H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3 HUHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  bY H Hc	  H  %  	    (	    0	    8	    @	    H	    HcP	  H  8  =[
 Wt$XH  ѳH9	 H  mH( IH  IPWD$@Ll$PHǅ     L  ƅ   A   HY9	 H  H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@5	HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
j	  HQM+IIHL+IIM;HCH;HCHL$@HL$HHt/HA   LiHyrHHH    HL$HH HL$HH  cAEHT$@HWIH
}	 H;tHT$@IP X	  @   WELmH  ]D$0D$(HEHD$ LD$`HlmH  H  虯HXH  ɢHtIH  IPHD$XHD$ A   LEHUHM5 IL@H
	 HUH;uIOCIAАH(  NH(   HUHtLEL+I'H
Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   H36	 H  'IH  IP H  虡H    D8  Wt$XH  HL$`h3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   DH`     HMݥ HH	 H   HHu3
H HcHHHWHH_ HHA	    HM HH	 H   kHHu3
H HcHHHW   HMP LHu3
HHcHHIPA(Hϥ HH	 H(  Z (YH     HM HH	 H   HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H0 HH	 i   HM(Z HHl	 H   DHHu3
H HcHHHW   HM8) LHu3
HHcHHIPAH   Y (H HH	 
   HMHƣ HH0	 H   HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H HH	 H
   HMh9 HH	 H   #HHu3
H HcHHHW   HMx LHu3
HHcHHIPAX  H HHD	 Hp     HM HH	 H   HHu3
H HcHHHWHH' HH	 XH	 H   EHHh  fHH	 'IH   IPH(  H(  m X	  HuH  H  蟩HXH  ϜH   IH  IPHǅ     3H    E3H H  H  H  H  HC  H  L  Mt
H  3H  6@  W  H  H  _D$0D$(H  HD$ LD$`HkfH  H  蘨HXH  țHtIH  IPHD$XHD$ A   L  HUH  |. IL@H
	 H  H;uIO9IAАH(  DH(   H  HtL  L+IEH
ݴ@
  W  3H  H  >D$0D$(H  HD$ LD$`HJeH  H  wHXH  觚HtIH  IPHD$XHD$ A   L  HUH  [- IL@H
	 H  H;uIOIAАH(  #H(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H.	 ;IH  IP H  譙5A$   Hl.	 IH  IP H  yF   EH    LH	 H  MHIAP H  3H  &HL$@Ht.HT$HX  LD$PHT$@L+IWD$@H|$PH(  ѥH(  D H    H  苁  H(  螥H(   HT$`HtLD$pL+IuWD$`H|$pHUHtLEL+I螷H  H3 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pDHHL$tWWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHM(t H	 H   H   HuH   HEL}HEHHUH+HWEHt!3P HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%ݛ	 LeH1HEH]LL+tHH1 WED$xHE    HL$xHT$xH   H   PAEHT$xIIHHT$xHP HL$xHt|HUU  HEHL$xH+HHH;v HH=   r<t HAH;r H+Hs H'v؝ HG Ld$xHM)~HEHMHMHULL+tH$ EEfEML   HT$xHM  L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H   踧  +fn^5@
 LM(WLM(W(WHM#LeHMܛ Hқ H:	 H   HMHtsHEH+HHH;vz H    H=   r<t^ HAH;rN H+Hs> H'v1 H 3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHH%XH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHP H$   1L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHVH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHSH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHp H$   AL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHRH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH H$   菾L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   贶HH   ŲWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$pi Hz	 HEWHM; H\	 HEH}	 HEH}H"	 HEH   HEH   HE(;
 )E (
9
 )ME        V8
 E(E0    E4 WE8HG	 HE   f/vM   f/vj6
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM H߈	 HEH|z	 HEHM HM HM H	 HEHT$pHtLEL+Iݺ3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   足HH  ǯW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$pf Hw	 HEWHM7HX	 HEHz	 HEH}H	 HEH   HEH   HE(8
 )E (
6
 )ME        R5
 E(E0    E4 Wu8EH Hy	 HEP2
 Ex(
9
 )   4
    uXW)E`H	 HEH5R	 Hu@P  f/vE=#3
 X  f/vf/vM`  OȉM$YY Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHM Hu@H	 HEHv	 HEHM܎ HMҎ HMȎ H1	 HEHT$pHtLEL+I3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHKH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HHl H$   荶L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHEJH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH* H$   ۴L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHHUGH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH H$   蝳L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHFH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH: H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   HH   %WEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$p\ Hkm	 HEWHMH	 HEHQq	 HEH}Hv	 HEH   HEH   HE(.
 )E (
-
 )M"*
 ] WM0E(
   HW	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHMH Hr	 HEHm	 HEHM HM HM HTx	 HEHT$pHtLEL+I>3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   HH  (W   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$pY Hhj	 HEWHMH	 HEHNn	 HEH}Hs	 HEH   HEH   HE(+
 )E (
*
 )M='
 } Wu0E(
   E@ H m	 HEH(e+
 )Ep(
-
 )   W)EPu`H}	 HEH5	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
'
 ( Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMy Hu8Ho	 HEH*j	 HEHML HMB HM8 Ht	 HEHT$pHtLEL+I苪3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pH] H3HE AALL   L   H   L  H  HEI`   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$p^HHL$tqWE3H}Ht$8Ll$0D$(t$ LL$pMIHMZV WD$XH|$hHE   H}@} DGH(	 HM 藴HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
=	 } HQM+IIHL+IHM;HCH;HCHL$XTHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
	 } HQM+IIHL+IHM;HCH;HCHL$XHL$`Ht,HA   HyHyrHHHU   ߸HL$`H HL$`HEHrPHHM H=   r<t HAH;r H+Hs H'v H AEHT$XI*IHT$XIP H}H]H+HWD$xHt3h~ H_HHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHMH    D$8   D$0   D$(   D$ LL$pLD$xIHMj  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM~n  HL$xJ} HL$XHt2HT$`m5  LD$hHT$XL+IGWD$XHD$h    HUHtLEL+Il3HM H3ͪ H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHxX H3HE AALL   L   H   L  H  HEI}[   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$p.HHL$tAWE3H}Ht$8Ll$0D$(t$ LL$pMIHM*Q WD$XH|$hHE   H}@} DGH 		 HM gHE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH

	 x HQM+IIHL+IHM;HCH;HCHL$X$HL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
Y	 w HQM+IIHL+IHM;HCH;HCHL$XpHL$`Ht,HA   HyHyrHHHU   诳HL$`H HL$`HEHrPHHM H=   r<tz HAH;rz H+Hsuz H'vhz H׮ AEHT$XI%IHT$XIP H}H]H+HWD$xHt38y HxZHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHMe  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM.\  HL$xx HL$XHt2HT$`=0  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I<3HM H3蝥 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH  HǀpHXHp )pHGS H3H$  MMH$   LHL$0H
 HHH
 H;
 r   VHH
 H$   Ht
'
 H3H
 3HHH
 H;
 r
   HH$   WHt
(蔾HHW$   H$   L$  L$  H$  H$  H$   HT$ H$  N  HD$ H$   H$   HT$ H$  '  HD$ H$   WD$PHt$`McmxIMtM;v
H
	 os IHL$PsL    H$  M;[  HT$ 赩  HD$ HL$XLD$PH;   HD$ L;   Lt$ M+ILL$`I;uoIH+HHs_I+HIH+Hs
H
O	 r HQM+IIHIH+ILI;LCL;ICHL$PrHL$XLD$PH   K~LL$`I;ujIH+HHsZI+HIH+Hs
H
ǧ	 Ir HQM+IIHIH+ILI;LCL;ICHL$PLrHL$XHt
HD$ HHL$XHHL$XIH$   HT$(R  LH
 LH(H
 H;
 r
(   gLL$   Mt+M} AOXKII^M~ Ha	 ILL$   IH$   (HHL$ HD$ H$   WD$8Ht$HLl$0Mc},MtM;v
H
	 q IHL$89qLfD  M;  HT$ H$  U  HD$ HL$@H;   HD$ LD$8L;   H\$ I+HLL$HI;uoIH+HHs_I+HIH+Hs
H
	 qp HQM+IIHIH+ILI;LCL;ICHL$8tpHL$@LD$8Ht.I H;L$HuHL$8oHL$@Ht
HD$ HHL$@HHL$@I    HǄ$     H$  Ƅ$   A   H	 H$  HǄ$     H$  Ƅ$   A   H 	 H$  ߥLl$0EExEyH$  H$  +H$  =jH$  /jIcUxH$   PHL$   IH$   H+HHt1fff     H<HL$   IH$   H+HH;rHL+IMt.fff     H<HH$   H$   H+HH;r    HǄ$     H$  Ƅ$   A   H¥	 H$  轤HǄ$     H$  Ƅ$   A   H	 H$  膤EExAyH$  H$  H$  hH$  hAExHcHL$hgOHLD$pIHL$hH+HHt*ff     H<HLD$pIHL$hH+HH;rHL+IMtH<HHD$pHL$hH+HH;rU    HǄ$     H$  Ƅ$   A   H	 H$  胣L$     HL$hk#  HH$   HH$  g   A;]xC      HǄ$     H$  Ƅ$   A   H	 H$  HǄ$     H$  Ƅ$   A   H	 H$  ʢHǄ$     H$  Ƅ$   A   H	 H$  蓢LcL$  IHL$Pz"  LL$  IHL$hb"  MHH$   ϿLHcL$  HL$h5"  HIHH$  fH$  fH$  fH$   H\$  $   A   5	
 f     E;uxc  X %   HǄ$     H$  Ƅ$   A   H	 H$  膡HǄ$     H$  Ƅ$   A   Hx	 H$  OHǄ$     H$  Ƅ$   A   H	 H$  HǄ$     H$  Ƅ$   A   H	 H$  EfIcL$  HL$h   LIcL$  HHL$h   MHH$   	L(HL$(LI   L$  Ho   LD$ HL$0MHH$   LL$  HH$   .   HIHH$  dH$  dH$  dH$  ~d &   HǄ$     H$  Ƅ$   A   Hϝ	 H$  讟L$  HH$     LHT$ H$    HH\$ H$  cEDH$        E;ux   IcH<    H$p  rH	 H$  [HAH`i ]HH$   H$p  1pHxrH H
gs H$   3H$   H$   H$  Ƅ$  H$   H$  i HHc	 H$   Ha H$   " ADHL$hfff     AExD;   IcH<    H$p  qH&	 H$  [HAH[h ]HH$   H$p  ,oHxrH H
br H$  3H$  H$  H$  Ƅ$  H$  H$  h HCb	 H$  H\ H$   AH   H$p  (pHp	 H$  H$   H$p  nnHxrH H
q H$   3H$(  H$0  H$  Ƅ$  H$(  H$  ,h Ha	 H$   H H$   _ : +   HǄ$     H$  Ƅ$   A   H	 H$  hHǄ$     H$  Ƅ$   A   H	 H$  1EE(EyH$  H$  H$  `H$  `IcU(H$  GHL$  IH$  H+HHt(fH<HL$  IH$  H+HH;rHL+IMt.fff     H<HH$  H$  H+HH;r .   D$0   t$ LL$0LD$ H$   HL$( HT$(H$   9-  /   D$    t$0LL$ LD$0H$   HL$(ǭ HT$(H$   , g 0   t$ M   LD$ HT$PHL$(蜰 HT$(H$   , , 1   
 D$(t$ LL$(LD$ H$   HL$0肴 HT$0H$   p,  2   t$ M   LD$ HT$8HL$(g HT$(H$   5, A   E;}(?   6   HǄ$     H$  Ƅ$    A   Hn	 H$   řHǄ$x     H$p  Ƅ$`   A   HC	 H$`  莙HǄ$X     H$P  Ƅ$@   A   H	 H$@  WHǄ$8     H$0  Ƅ$    A   HՅ	 H$    HǄ$     H$  Ƅ$   A   Hz	 H$  H$  H$  E33H$  A   H]	 H$  謘IcI   L$   H豩 LD$8HH$   \ LL$`  HI   肩 L$   HH$   * LH$   H$   貵LIM0L$@  H  MHL$(:LL$   HI    LD$PHHL$ 辪 LH$   HL$0IHH$@  YMHH$H  HH$P  L(H$X  cHIMHL$  Hl  LH$`  xMHH$  ŴHL$  HH$  *  HHHH$  [H$  [H$   [H$@  z[H$`  l[H$   ^[AX 8   IU`L$   L$  HL$( HT$(H$   ( H$  HtL$  L+IHT$hHtLD$xL+IΊWD$hHt$xH$   Ht(L$   L+I蟊W$   H$   HT$8HtLD$HL+IpWD$8Ht$HHT$PHtLD$`L+IGH$   H$   ' H$   H$   HH$   HtL$   L+IHH$  H3T L$  I[@IsHA(sIA_A^A]A\_HWATAUAVAWH  HǀpHXHp )pH= H3H$  IMH$   LH	
 HHH	
 H;	
 r   HH	
 H$   Ht

 觨H3Hk	
 3HHHW	
 H;H	
 r
   ĠHH$   WHt
(YHH$   W$   H$   L$  H$  H$  H$  H$   HT$ H$    HD$ H$   H$   HT$ H$    HD$ H$   WD$PHt$`McexIMtM;v
H
	 /] IHL$PZ]L    H$  M;[  HT$ u  HD$ HL$XLD$PH;   HD$ L;   H\$ I+HLL$`I;uoIH+HHs_I+HIH+Hs
H
	 \ HQM+IIHIH+ILI;LCL;ICHL$P\HL$XLD$PH   I~LL$`I;ujIH+HHsZI+HIH+Hs
H
	 	\ HQM+IIHIH+ILI;LCL;ICHL$P\HL$XHt
HD$ HHL$XHHL$XIH$   HT$(  HHL$0E(HHL$ HD$ H$   WD$8Ht$HMce,MtM;v
H
Ő	 G[ IHL$8r[LM;   HT$ H$  蔑  HD$ HL$@H;sAHT$ HD$8H;w2H\$ H+HH;L$HuHL$8ZHL$@HD$8Ht.H H;L$HuHL$8cZHL$@Ht
HD$ HHL$@HHL$@I\    HǄ$     H$  Ƅ$   A   HP	 H$  軐HǄ$     H$  Ƅ$   A   H	 H$  脐EExEyH$  H$  ջH$  TH$  TIcUxH$   h;HL$   IH$   H+HHt+D  H<HL$   IH$   H+HH;rHL+IMt.fff     H<HH$   H$   H+HH;r?    HǄ$     H$  Ƅ$   A   Hr	 H$  mHǄ$     H$  Ƅ$   A   H_	 H$  6EExAyH$  H$  膺H$  SH$  SAExHcHL$h:HLD$pIHL$hH+HHt*ff     H<HLD$pIHL$hH+HH;rHL+IMtH<HHD$pHL$hH+HH;r    HǄ$     H$  Ƅ$   A   H\	 H$  3L$     HL$h  HH$   HH$  R   A;]x@      HǄ$     H$  Ƅ$   A   Hj	 H$  豍HǄ$     H$  Ƅ$   A   H	 H$  zHǄ$     H$  Ƅ$   A   Hl	 H$  CLcL$  IHL$P*
  LL$  IHL$h
  MHHL$(肪LHcL$  HL$h  HIHH$  bQH$  TQH$  FQH$   H\$ 6 $   A   5	 E;uxc   %   HǄ$     H$  Ƅ$   A   Hk	 H$  BHǄ$     H$  Ƅ$   A   H4	 H$  HǄ$     H$  Ƅ$   A   Hq	 H$  ԋHǄ$     H$  Ƅ$   A   H	 H$  蝋EfIcL$  HL$h  LIcL$  HHL$hh  MHHL$(ȫL(HL$0xLI   L$  H.  LD$ H$   HMHH$   uLL$  HH$   
  HIHH$  dOH$  VOH$  HOH$  :O< &   HǄ$     H$  Ƅ$   A   H	 H$  jL$  HH$   Q
  LHT$ H$   輧HH\$ H$  NEDH$   @ E;ux   IcH<    H$p  \HÍ	 H$  f[H|AH T ]HfH$   H$p  ZHxrH H
'^ H$   3H$   H$   H$  Ƅ$  H$   H$  T HN	 H$   H! H$    ADHL$hfff     AExD;   IcH<    H$p  [H	 H$  a[HwAHS ]HaH$   H$p  YHxrH H
"] H$  3H$  H$  H$  Ƅ$  H$  H$  S HM	 H$  H H$  ݔ AH   H$p  ZH0	 H$  H$   H$p  .YHxrH H
d\ H$   3H$(  H$0  H$  Ƅ$  H$(  H$  R HEL	 H$   H^ H$     +   HǄ$     H$  Ƅ$   A   Hs	 H$  (HǄ$     H$  Ƅ$   A   Hs	 H$  EE(EyH$  H$  BH$  TKH$  FKIcU(H$  1HL$  IH$  H+HHt(fH<HL$  IH$  H+HH;rHL+IMt.fff     H<HH$  H$  H+HH;r .   D$0   t$ LL$0LD$ H$   HL$(˘ HT$(H$    k /   D$    t$0LL$ LD$0H$   HL$(臘 HT$(H$    ' 0   t$ M   LD$ HT$PHL$(\ HT$(H$   z  1   	 D$(t$ LL$(LD$ H$   HL$0B HT$0H$   0  2   t$ M   LD$ HT$8HL$(' HT$(H$    A   E;}(?  W 6   HǄ$     H$  Ƅ$    A   H.	 H$   腄HǄ$x     H$p  Ƅ$`   A   Hq	 H$`  NHǄ$X     H$P  Ƅ$@   A   H	 H$@  HǄ$8     H$0  Ƅ$    A   Hp	 H$   HǄ$     H$  Ƅ$   A   H:	 H$  詃H$  H$  E33H$  |A   Hp	 H$  lIcI   L$   Hq LD$8HH$    LL$`  HI   B L$   HH$    LH$   H$   rLIM0L$@  H  MHL$(LL$   HI   Г LD$PHHL$ ~ LH$   HL$0	HH$@  MHH$H  ֥HH$P  L(H$X  #HIMHL$  H,  LH$`  8MHH$  腟HL$  HH$    HHHH$  dFH$  VFH$   HFH$@  :FH$`  ,FH$   FA 8   IU`L$   L$  HL$(ޢ HT$(H$   l H$  HtL$  L+IuHT$hHtLD$xL+IuWD$hHt$xH$   Ht(L$   L+I_uW$   H$   HT$8HtLD$HL+I0uWD$8Ht$HHT$PHtLD$`L+IuH$   H$    H$   H$   HH$   HtL$   L+ItHH$  H3z L$  I[@IsHA(sIA_A^A]A\_@SVWH   HD$0H' H3HD$xIHHHD$p   HD$h    D$X A   Hl	 HL$XHD$P   HD$H    D$8 A   Hك	 HL$8wLGL+IH\$(D$    DHL$8葩HD$PHrQHHL$8H=   r<tL HAH;rL H+HsK H'vK HT HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<tK HAH;rK H+HsK H'vrK H HHHHL$xH3Yx HĀ   _^[Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1H~ H3HsHsHH;uHl$0Ht$8H\$@H _J J I I I DL$ LD$HT$HL$SVWH0HD$(HH9z ucH g HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH ' HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCH| H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _	H H G G H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   H{ H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weH{ HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _F F F F F F F F H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHz H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _E E E E HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHN7HHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Hcy H3HsHsHH;uHl$0Ht$8H\$@H _D D D D D HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PH@ H3HEpMMHHH   D$     H?	 HD$`HMPB D$    E3E3HT$hHL$`B HD$`HcHH,	 HD`HD$`HcHDxDD\   HL$hׄHHL$`iHH_	 *HHOHHe	 HI5HA@ HHHUPHL$`IHxrH H
J HL$(3HL$0HL$8HD$@D$HHT$0HL$@qA H*B	 HD$(H^ HL$(誂 @UVWATAUAVAWH$pH  HD$@H$  H H3H   MIHLL   H   HD$8E3D|$0H5>	 HD$PHM@ D$0   E3E3HT$XHL$P@ HD$PHcHHN+	 HDPHD$PHcHDxDDLAWHL$X>HHL$PвHHu	 葮HIVD? HHs	 uHU`HL$PgHHIcD$0HU`H}xHCU`HEX   L}PD}@D8:tIIB<: uMHM@tHD$8HD$ MLD$0HU@IH\$Ht$WH IHHH;t HH1HHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(IHf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IIHA(HWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   ;)HX(H
[	 HH0@8   HH$   蔋 HHL$(f)HO HL$({f H\$WH HHHÀ< uHú   H% HHu" Ht!HH+fff     9HHuHH\$0H _@SH HQ  H	 HCPH [HL$SH0HD$ HD$P    EtHA	 HA@H	 HAPD$P   J   H	 HH	 HCHC@HcHH^	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH- HHQ3HHBHK# Hm	 HH{3HHDH^H\$HH"	 HHOHKHtHPHGHCHGHCG C Hb
	 HH, HHH\$PHt$XH0_@SH HN  H	 HCPH [HL$SH0HD$ HD$P    EtHV@	 HA@H[	 HAPD$P   z  HK	 HH
	 HC(HC@HcHH
	 HD@HC@HcHD<    HH0[@SH HbL  H	 HCPH [HL$SH0HD$ HD$P    EtH?	 HA@H	 HAPD$P     HS?	 HH	 HC(HC@HcHH^	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH HC	 HHH		 HAPHI8 " HK ! HK! HU	 HH [@SH H{	 HHH		 HAPHI8! HK ! HK! H	 HH [H\$WH HN  H5	 HGPt
X   HV HH\$0H _H\$WH HLL  H	 HGPt
X   HwV HH\$0H _H\$WH HH	 HHHJHKHtHPHGHS0HCHO0HGHCG C HF) HC(3HHB H<	 HH	 HC(HH\$0H _H\$WH HI  H%	 HGPt
X   HU HH\$0H _H\$WH HH	 HHHJHKHtHPHGHS0HCHO0HGHCG C Hv( HC(3HHB+ Hl
	 HH	 HC(HH\$0H _@SH HH    H   HKX| HKHr HK8h HK(^ HKT HKH [H%D H\$WH HQ@3HHtLAPL+IGH{@H{HH{PHS(HtLC8L+IcGH{(H{0H{8HSHtLCL+I6H{H{H{H\$0H _H\$WH HH     L   HgfffffffL+   IHLI?LH     H   HOXD HOH: HO80 HO(& HO HOH\$0H _H% @UVWAVAWH$@H  HD$8H$  H H3H   IILHE3D|$0AA A	fD  f/rHHrY  H	 HD$PH	 HD$`HM D$0   E3HT$hHL$P^ HD$PHcHH5	 HDPHD$PHcHhTLHD$hHD$@HL$h H	 HD$hL}D}HR	 HL$`jHL$` H   HL$P
"H   H   HC   HEh   L}`EP : uMI@ IB< uHMPmPHǅ      L   Ep A   HQ	 HMp@PHEPHD$ LMpLIHH   H3J H$  H  A_A^_^]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHS	 H  YOHL@H
Z	 H;u.HSHKHH  HH H  HAАH  HrSHH  H=   r<t HAH;r H+Hs H'v H	P HWHL$x,@  MEHT$xH^  (Hǅ     L  ƅ   A   HR	 H  INIH  IPH  HrSHH  H=   r<t HAH;r H+Hs H'v H7O H    HcR	 H   GH( H  H   ILAHIAАH  HrTHH  H=   r<tD HAH;r4 H+Hs$ H'v HN HH  HH   H\$0Lt$(x  D$ p  (HT$xHM  H_HD$xH  HuHCH;t'H;tH Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  聖 HGHPHL$`oEHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
J	  W  L  D$@Ll$PH	 HEH+	 HEHMH D$\   E3HUHMs HEHcHHK	 HD
HEHcHhT
HEH  HM H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HM"HXH  RHt
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
xI	  IPL+IIHL+IIM;HCH;HCHL$@gLD$HMtM(LD$HILD$HIPHL$@H;t
I;t,M IHT$@IPHǅ     L  ƅ   E3H2	 H  IIH  IP H  1H  uH]N	 H  HȋW$ HHN	 IH  IPAD9o$Y  f     LGHWHL$xa EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  D$0D$(HD$@HD$ LD$`HH  H  HXH  %
HtIH  IPLD$HL;D$Pu   HL$@>LD$HMtM(LD$HILD$HIPHL$@H;t
I;tbK IHT$@IPHH  HH  
 ;w$}H
F	 Q Hǅ     L  ƅ   A
   HL	 H  GIH  IP H  0HH  HH   HMHHMHr HT$@HtLD$PL+I;WD$@Ll$PH  HtL  L+I*HT$`HtLD$pL+I;HM
 HL$x 3H  H3@ H$`  ($   H  A_A^A]A\_^]HUWATAVAWHhH   HEHXHpH H3HEHHLALIEgAEoAEwA EA$HE   E3LeDeED$+H_K	 HM>FHE   LeDe&K	 MAHK	 HM
FD9ckHE   LeDeED$HRG	 HMEHE   LeDeED$HG	 HMEHEHD$ LMLCHUHMHEHrPHHMH=   r<t_ HAH;rO H+Hs? H'v2 HF HE   LeE HEHrPHHMH=   r<t HAH;r H+Hs H'v H7F HE   LeE A&   HJ	 HMDHE   LeE I	 MAHI	 HMD{ mHE   LeE A   HE	 HMSDHE   LeE A   H}E	 HM,DHEHD$ LMLCHUHM
HMHMHE   LeE A*   HLI	 HMCHE   LeE H	 MAHH	 HMCLC HUHMHMHMHE   LeE A&   HH	 HMVCHE   LeE >H	 MAH.H	 HM%CLC$HUHMHMHMHHMH3< L$   I[8Is@IA_A^A\_]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHF	 H  9BHL@H
:	 H;u.HSHKHH  HH߁a H  HAАH  HrSHH  H=   r<t HAH;r H+Hs H'vz HB HWHL$x@  MEHT$xH~l  (Hǅ     L  ƅ   A   HE	 H  )AIH  IPH  HrSHH  H=   r<t
 HAH;r
 H+Hs
 H'v
 HB H   HCE	 H   'zH(
 H  H   ILAHIAАH  HrTHH  H=   r<t$
 HAH;r
 H+Hs
 H'v HfA HH  yHH  
 H\$0Lt$(x  D$ p  (HT$xH0[  H_HD$xH  HuHCH;t'H;tH Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  a HGHPHL$`OEHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
=	  W  L  D$@Ll$PH		 HEH	 HEHMH	 D$\   E3HUHMS	 HEHcHH+	 HD
HEHcHhT
HEH  HM H HELm0Dm8D$0D$(HD$@HD$ LD$`HH  HMHXH  2Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
X<	  IPL+IIHL+IIM;HCH;HCHL$@YLD$HMtM(LD$HILD$HIPHL$@H;t
I;t@ IHT$@IPHǅ     L  ƅ   E3H%	 H  <IH  IP H  H  UH=A	 H  uHȋW$ HH@	 uIH  IPAD9o$Y  f     LGHWHL$x.U EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  D$0D$(HD$@HD$ LD$`HH  H  HXH   HtIH  IPLD$HL;D$Pu   HL$@1LD$HMtM(LD$HILD$HIPHL$@H;t
I;tB> IHT$@IPHH  wHH   ;w$}H
9	 1 Hǅ     L  ƅ   A
   H?	 H  :IH  IP H  HH  HH  f HMHHMHR HT$@HtLD$PL+I.WD$@Ll$PH  HtL  L+IHT$`HtLD$pL+Im.HM HL$x 3H  H33 H$`  ($   H  A_A^A]A\_^]@SH A(HA ] CH [Ht$WH0HD$     H      t@W H   HVxH\$@      ^FxH\$@,;L   HHt$HH0_@SH H	 HH   H HH HAPHI8 HK  HK H HH [Wf/v%      ^Ix,;L   H\$WH HHH   H1H   H"H   HH\$0H _	@UHHPHEH\$`Ht$pH|$xH H3HEHHE   3Hu@uDF
H=	 HM7HKHEH;sTHHUH;wHH}H+H;KuVH,HH;HKHtcHA   HqHyrHHH;H;Ku
   HD,HKHt'HA   HqHyrHHHU  <HC HEHrPHHMH=   r<t HAH;r H+Hs H'v H8 HE   HuE A
   Hp<	 HM6HCHMH;sVHHUH;wJH}H+H;Cu
   H[+HH;HKHtcHA   HqHyrHHH;H;Cu
   H+HKHt'HA   HqHyrHHHU  ;HC HMjHE   HuE A   H;	 HM5HUHwHM-HMH3/ H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3um  HSH2n  H_HGPLG`HHOPP8MHHOPk  HHMHCHEEWH9puA(H HD$8HEHEHL$0> (Y5C	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0 YѢ	 XC(EoHHEoH#H      H;v7	 \(}W (5	 f/vIHOh	j  f/v:HEH;t1HKHU{EC(HKHU{HK0HU{]HCHEHx tH HD$8HEHEHL$0 D(DY	 DXC(D   0H4 I$I\$H]oHO~HHHGHCHWHGLL+tvV W=	 A|$At$ HM HM HM IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA V CH [H\$WH0HD$     H      tS HWxH   HH\$@H0_@SH HS HH   H2 HH HAPHI8 HK  HK HG HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=!	 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@o HL$0Y ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@ p HL$0m L$   HHH$   ($   HĠ   _:f  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Hq HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     HHK8HOHS0LC8IL+LtHQ HH\$@H0_H\$WH0IH IHD$     HHK HOHSLC IL+LtHQ HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3 HHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$P2: HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P` (Y%e	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$   Ղ (X\(HĐ   [B(HhHBHD$(Hx uWYњ	 HhH HL$8HD$@HD$ HD$P Y	 HhWf/v	 f/v   Wf/vIxHAHH H\$WH HHe  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs蜁 Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$Xh f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H HSHt
HHH
HB$H;Cu
   H HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   Hr HSHt
HHH
HJ$H;Cu
   HF HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HwHSHt
HHH
HB&H;Cu
   HKHKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xHQ H3HEHHE   3Hu@uDF
H-	 HM)(HCHMH;sTHHUH;wHH}H+H;CuVHHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  T-HC HEHrPHHMH=   r<tC HAH;r3 H+Hs# H'v H( HE   HuE A   H -	 HM&HCHMH;sVHHUH;wJH}H+H;Cu
   HHH;HKHtcHA   HqHyrHHH;H;Cu
   HHKHt'HA   HqHyrHHHU  (,HC HMHE   HuE A   H5,	 HM$&HUHHMHE   HuE A   H,	 HM%HUHHM`HE   HuE A   H+	 HM%HUHmHM#HMH3w H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    ]  HSH^  H~HFPLF`HHNPP8MHHNP[  HHM}HUH   }HUHM0}HUH   }HFPLHUHNPP(HMHE HMHM(HULL+tHG HMHEHMHMHULL+t	HG HN(lHD$xH^(H]HV LL+tHfG H]EWA(HGH  Hx uE(H HEH   HEHMK D(DN	 EYDXO(D$`    DEǆ       Ɔ          Df	 D%	 D-	 @      WD$hHt3B HHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM/ D]HNhX  fA/  HEH;  LcuIL;wt%HO[ EtHHGHG    H_E~LEN    HUHOE EG(Lcu IL;w t%HO EtH8HGHG    H_ E~LE N    HUHO$E LcuIL;w8t%HO0 EtHHG0HG0    H_8E~LEN    HUHO0D Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      H9\  HEH;  HWHMhG(EHWHMhHM   H   H;t=HOH   h   G(HOH   hHO0H   hLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      HX[  H   H;t=HWH   	hG(   HWH   gH   HW0g     uf/w(\AC (HNhU  f/v=H   HM8g   EXH   HMHxgH   HM`hgf/v\(PX(\(P(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM- HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  t fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  Pt fA/v"HL$h    9   }H]HL$h D$`   fnu^HE0H;t1HOHU8eEXG(HOHUHeHO0HU`weHU     V0W[	 HV(IdHL$xH HM= HM 2 HM' H    H    H    HM` HMH HM8 H    H    H    HM HM HM IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH   LcHsHH{Lsp5	 EW=	 E   I$HEI|$HFH;t'H;tH Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$`. H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMp    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMp EHSxHExHD$(H  HD$ L   L   HM3 YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(HL5 t0Eu"A   EEHj	 H   A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$`% M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$`$ I迕  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Aa  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`R Y   SxE3;a  H   HCxMHH\  [pSh(\%ُ	 T   f/vA      8  f/vA        f/vA
      H  H9   rA(   ~TUpT]xH0  HMp f/HGHExf/HG^(  5x	 Yf/vA   !Hn[  @  Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   HIcX$ 4$ HA   H	 vAO   H	 gAO   H	 XA6   HZ	 IAD   H	 :AC   H	 +A9   H	 AQ   H>	 
A   H	 HC   HLKDHH0[ # # # # # # # # $  HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3HK H   EotEH   LcHsHH{Lsp5(	 EW=$	 E   I$HEI|$HFH;t'H;tH Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
Z	 ff     HE(WA)HH;}LEMHL$`T% H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMh    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMg EHSxHExHD$(H   HD$ L   L   HM+ YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H, t0Eu"A   EEH	 H   A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHBHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   A|]  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`I Y   SxE3\  H   HCxMHH[  [pSh(\%	 T   f/vA        f/vA         f/vA
      H   H9   rA(   ~TUpT]xH  HMp f/HGHExf/HG^  5y	 Yf/vA   !H>Z     Y   f/DGHMC HM8 AL$(  A(sA({E(CIA_A^A]A\_^[]LSH   ICHAC    H ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$X H HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    HYk HL$( @SH0HD$ HٹX   < HD$@HSH^  HHtH@@HcHHB@HH0[@SH0HD$ HH7 HH HA(HA@HcPHB HD
@HA@HcPDBDD
<H HH HA(H0% H HHKHtHP tHC    H0[LSH   ICHAC    H ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH> HD$P3HD$XHD$`HKHT$X HW HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    Hag HL$( @SH0HD$ HٹX   \ HD$@HSH]  HHtH@@HcHHB@HH0[@SH0HD$ HH HH5 HA(HA@HcPH HD
@HA@HcPDBDD
<H5 HH HA(H0E H6 HHKHtHP tHC    H0[LH   ICAC    HQH ICH ICAC   IK[Hܾ HD$(H  HD$@HD$hHcHHk HDhHD$hHcHDd    HFf HL$(b @SH0HD$ HٹX    HD$@HSH\  HHtH@@HcHHB@HH0[@SH0HD$ HH HHe HAHA@HcPH HD
@HA@HcPDBDD
<H] HH HAHI HtHP tHC     He HHKH0[H% @SHpH H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8uZ @-H$   u	HHHtHL$`H3 Hp[2HL$`H3 Hp[@SVWH   HD$8Hͭ H3H$   IHHA D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   H	 HL$@qHD$x   HD$p    D$` A   H	 HL$`BHD$@HD$ LL$`LHH贍H$   H3 HĐ   _^[@SVWH   HD$0Hݬ H3HD$xIHHAWf/w|HD$P   HD$H    D$8 A   H
	 HL$8HD$p   HD$h    D$X A   H	 HL$XiHD$8HD$ LL$XLHHیHL$xH3- HĀ   _^[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PH+ HA@H0 HAPD$P   诲H HHOH HHG@HcPHO HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_Hy H\$WH H HH   Hd HHz HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH H HHH HAPHI8* HO   HO H Ht
   HZ HH\$0H _H\$WH H HH   H HH HAPHI8 HO  HO H Ht
  H HH\$0H _H\$WH H HHH HAPHI8: HO 0 HO& H Ht
   Hj HH\$0H _LHXICLL	IAI+HHIH;rQHX IC3ICICH	 ICD$0ISIK HM HD$8H1	 HL$8GHAI@IHH
HHXHUSVWATAUAVAWHH  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)Hצ H3H@  D((UHHT$xLT$0\$8Hh  Lp  Hǅ     E3L  D   EFH	 H   qHǅ     L  D  X	 MA3HH	 H  4EWfA/   Hǅ     L  D  EFHh H  Hǅ8     L0  D   EFH H   H  HD$ L   LD$0H   H  'H  HrSHH  H=   r<tT HAH;rD H+Hs4 H'v' H Hǅ     L  ƅ   H  HrSHH   H=   r<t HAH;r H+Hs H'v H Hǅ     L  ƅ    A%   H	 H   Hǅ     L  ƅ   r	 MA3Hb	 H  NfE/   Hǅ     L  ƅ   A   H H  Hǅ8     L0  ƅ    A   H1 H   H  HD$ L   LD$8H   H  AH  4H   'Hǅ     L  ƅ    A   H	 H   eHǅ     L  ƅ   L	 MA3H<	 H  (L`  H   H  
H  萿H   胿I$HPHMI$HPHME(D-l	 :j	 T$0fn`  =h	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`Hx  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   H	 H  HH  HP H  艾Hǅ     L  ƅ   A=   H	 H  HH  HP H  9+ D$pAA   D=}s	 D5$h	 @ LLEHIV  HMAu3H  HHMH  E H     HUXL(H  HHUHMFL
h	 HM0LHH  HHMH   H   H   H   fEnEA(8 ^HU0HMyL
g	 H  HHUHML(HMLHH  HHeH   H   H   H   AƙA|$   A(LHIX  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyXg	 ^HT$@P  D(H   t   HMX HHn H   /HHu3
H HcHHHW	   HMhӿ HAH HH /HHKſ HHu3
H HcHHHW   HMx LHu3
HHcHHIPA   H   K HA(H HH ,/HHu3
H HcHHHW   H    HHtH HHu3
H HcHHHW   H    H(Hf HH .HHu3
H HcHHHW   H    HHH~ HHu3
H HcHHHWA(H ' +D$pfn^=[e	 |$83H  H  H  WH  H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  H  H  HtHHH1H;  u   H  UH  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  H  H  Ht;HH+H;  u   H  H  HtD	H  HH  IE L@H
 H  H;Iu3AfD/vH H   P,E2fE/vH H   3,E2AD$ D;~!fE/wfA/vH H    ,HH   HPE   A(A\A^ATf/}`	    Hǅ     H  D  Aa   Hq H  HH  HP H  wHǅ     H  D  AH   H H  HH  HP H  'H  Ht%L  L+IW  H  HH  HH  L =_	 H|$xD;`     Hǅ     3H    DCiH- H  HH  HP H  sHǅ     H    DCBHP H  HH  HP H  &E2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHtHM5 HM+ HM  HM H@  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWHP  IǃA)sA){Hg H3H$(  MALHHL$`H$   HT$xDD$PL$   Iǃ    E3MEEGH IHǄ$     L$  D$   MA"H H$     HǄ$     L$  D$  EGH H$  HǄ$      L$  D$  EGH H$  SH$  HD$ L$  LD$PH$p  H$  #H$  HrTHH$  H=   r<t޺ HAH;rκ H+Hs H'v H  HǄ$     L$  Ƅ$   H$  HrTHH$p  H=   r<t` HAH;rP H+Hs@ H'v3 H HǄ$     L$  Ƅ$p   A   H9 H$p  IH$p  IP H$  HrTHH$p  H=   r<t HAH;r H+Hs H'v H (b	 $  (
`	 $  Z	 $  
P^	 $   MIHM  $   HHPH$   HHPH$   >[	 $   
[	 $   DZ	 $   WL$hD$@ED|$X|$@   Ic  $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3H H$  [HǄ$     L$  Ƅ$p   E3HR H$p  'DLt$8H$  HD$0H$p  HD$(D΋H$p  {H$  mML$   IHL$`tG  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  HH$   H$  _ H$     H$  mL$   H$p  HH$   H$  LL$   H$@  LHH$  HH$   H$  ȵ H$   H$   H$p   fn6
 (^H$@  H$   lL$   H$p  HH$   H$  {L(H$  LHH$  HIIH$   H$   H$   H$p  ״ &MIH\$`HI  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$p  7H7 H$  !HH  !HL$hl HH !H$  AH |H !IH$p  IPHǄ$     L$  Ƅ$p   E3H H$p  IH$p  IP H$p   D$@ H$  H$  p   A}$      f/$   6  H$p  H H$   HH  HL$hP HH  IH$p  IPHǄ$     L$  Ƅ$p   E3H H$p  IH$p  IP H$p  %D$@ H$  H$  u H$   $   D$hADd$XHSH$  HIH$  - H$   EHǄ$     L$  Ƅ$   AJ   H H$  HǄ$     L$  Ƅ$p   A   H H$p  HǄ$     L$  Ƅ$   Y MA"HI H$  dHǄ$      L$  Ƅ$   E3H[ H$  0H$  HD$ L$  H$p  H$  uw  H$    H$    H$    H$   Ӱ D$hH$(  H3 ($@  ($0  HP  A_A^A]A\_^[HUSVWATAUAVAWHH(  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)H H3Hp  D((UHHT$xLT$0\$8H  L  HǅH     E3L@  D0  EFH H0  Hǅ     L  D   MA3H H  tEWfA/   Hǅ     L  D   EFH H   4Hǅh     L`  DP  EFHW HP  H   HD$ LP  LD$0H0  H  gkH  HrSHH  H=   r<t HAH;r H+Hst H'vg H Hǅ     L  ƅ   HH  HrSHH0  H=   r<t HAH;r H+Hs H'v H] HǅH     L@  ƅ0   A%   H' H0  Hǅ     L  ƅ    MA3H H  fE/   Hǅ     L  ƅ    A   H H   PHǅh     L`  ƅP   A   Hq HP  H   HD$ LP  LD$8H0  H  iH  tH0  gHǅH     L@  ƅ0   A   H) H0  Hǅ     L  ƅ    MA3H| H  hL  H0  H  MH  ФH0  äI$HPHMқI$HPHME(D-Q	 zO	 T$0fn  =8N	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`H]  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   H H  WHH  HP H  ɣHǅ     L  ƅ   A=   H H  HH  HP H  yk D$pAA   D=X	 D5dM	 @ LLEHI~E  HMAu3H   8HHM+H   H      HUL(H  趺HHUHM &L
CM	 HMP蒺LHH   蠸HHMH  
 H     H   H   fEnEA(x ^HUPHMyL
L	 H  袹HHUHM rL(HMLHH   HHH  _ H   R H  D H  7 AƙA|$   A(LHIG  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyXM	 ^HT$@6  D(H   贮   H   Q HH H   ;HHu3
H HcHHHW	   H   
 HAHΥ HHX HH HHu3
H HcHHHW   H    LHu3
HHcHHIPA   H    HA(H* HH cHHu3
H HcHHHW   H   E HHHB HHu3
H HcHHHW   HP   H(H HH? HHu3
H HcHHHW   H0   HHH HHu3
H HcHHHWA(H$ ^ +D$pfn^=J	 |$83H  H  H  WH  &H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  H  H  HtHHH1H;  u   H  H  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  "H  H  Ht;HH+H;  u   H  H  HtD	H  HH  IE L@H
: H  H;IuAfD/vH H   E2fE/vH H   jE2AD$ D;~!fE/wfA/vH H   7HH   HPE   A(A\A^ATf/E	    Hǅ     H  D   Aa   H H   <HH   HP H   讛Hǅ     H  D   AH   H H   HH   HP H   ^H  Ht%L  L+I.W  H  Hh  Hh   =D	 H|$xD;     Hǅ     3H     DCiHd H   8HH   HP H   誚Hǅ     H     DCBH H   HH   HP H   ]E2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHtHMl HMb HMW HMM Hp  H3& L$(  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWH  IǃXA)sA){H| H3H$`  MALHHL$`H$   HT$xDD$PL$   Iǃ   E3MEEGHR IFHǄ$     L$  D$   MA"H H$     HǄ$     L$   D$  EGH= H$  HǄ$8     L$0  D$   EGH H$   H$  HD$ L$   LD$PH$  H$  cH$  HrTHH$  H=   r<t HAH;r H+Hs H'v H` HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t HAH;r H+Hs H'vs H HǄ$     L$  Ƅ$   A   Hy H$  LIH$  IP H$  HrTHH$  H=   r<t HAH;r H+Hs՞ H'vȞ H7 ( H	 $   (
E	 $0  ?	 $@  
C	 $   MIHy<  $   HHPH$   HHPH$   ~@	 $   
E@	 $   ?	 $   WL$hD$@ED|$X|$@   Ic   $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3Hƹ H$  HǄ$     L$  Ƅ$   E3H H$  gDLt$8H$  HD$0H$  HD$(D΋YH$  軔H$  譔ML$   IHL$`6  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  WHH$   FH$    H$     H$  L$   H$  īHH$   H$(  ,L$   H$X  蓫LHH$  蠩HH$   ߖH$    H$   H$   H$  ݚ fnv (^H$X  H$   lL$   H$  蓪HH$   H$(  [L(H$  ȪLHH$  HIH$   B H$  4 H$  % H$   &MIH\$`H8  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$  wHw H$  HH@ HL$h HH H$  AH: |Hɹ IH$  IPHǄ$     L$  Ƅ$   E3H H$  IH$  IP H$  `D$@ H$(  >H$(     A}$      f/$   6  H$  [H[ H$  HH$ HL$h HHN IH$  IPHǄ$     L$  Ƅ$   E3H  H$  IH$  IP H$  eD$@ H$(  CH$(   H$   x$   D$hADd$XHSH$  HIDH$   m H$  _ EHǄ$     L$   Ƅ$   AJ   HY H$  HǄ$     L$  Ƅ$   A   H
 H$  HǄ$     L$  Ƅ$    MA"H H$  HǄ$8     L$0  Ƅ$    E3H H$   pH$   HD$ L$  H$  H$  \  H$   > H$   0 H$   ! H$    D$hH$`  H3 ($  ($p  HĐ  A_A^A]A\_^[H\$
8	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI;  C(WB	 C(H$   H$   H0HHD$XHHCH;t/H;t"Hy Ht
HuH3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
A	 fff     HD$X(WA)HH;}LD$@MHL$h HĐ   _^[@SH`HBHHD$(Hx uWY,6	 XB(H`[H HL$8HD$@HD$ HD$P Y5	 XC(H`[@SH    Wf.HAxHH   zt9HhPY6	 \@6	 Y   X06	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
HsHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pHm H3H$P  HHHL$0袘sxH5 HL$@;H( H$0  HL$0ݖLHHAPH$H  HrUHH$0  H=   r<t: HAH;r* H+Hs H'v
 H| H$   莖H$     H$P  H3 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHM裈 (Y
2	 XK(MHEHH#H      H;v
5	 (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   f/vH0   X2	 ( H0  X  H;t/HSHN)HC(HF(HSHNHS0HN0LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$hb HMHLHT$hP(HH   HHHHPHKHHHSHL$hJ HHEHsH   HCH;t'H;tH! Ht
H\oHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h H       D  HY(WEHt3d HnHEH] =<3	 } H  H[WEHt3' HgnHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM0	}H  L@LEWEMt3ǋ HMmHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHM' H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\((Xu \(XuuHUH(  HEf/w"\ (H   Hhnf/vHE0H;tHU0HSWEH]HHt3 HOkLHEH]LEHuHEHEHEHEH;t-Iԉ HtHkLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM+' LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM/\ LML   H   H   HM| HMq HM`f HMH\ HM8R HMG HM< L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   H2  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0/  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0T LLHHg0  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK    辷 HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_@SHpahHAHT%3	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h f/0  s0  ^W<3	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HM_xHHEH[IG3H;t'H;tI҄ Ht
H
fII?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
i2	 f     HE(WA)HH;}LEMHMe HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM
 (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM` Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHM@T H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHM' Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM H(H;~uH>H;~IDHHMtLE'M+II茩L$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHM
 D(=#	 EtCH]H{ uA(HHEHEHEHMx (A^H*  HG     (A^}gH]H{ uA(HHEHEHEHMmx D^DG0DMWEWMHUH   HM HM HEgHEH]HuHOH;uHOMgIHHUM (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   @SHpahHAHT%+	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h f/  s  ^W+	 Hp[HWH   H@HXHpHHHHL@@@HPHH~ HsHG3H;t'H;tHL} Ht
H^HHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
*	 fff     HD$`(W)HH;}HL$(HL$8 HL$p| L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$H: D(5	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;tHHHt3j{ H\HD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0
 E   LuI~ tIHD$PHD$xHD$`HL$H<s (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"H/z Ht
Hj[HH    H_H_LEHT$xH%R   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;t!HHHt3y HZHD$HH\$PH\$XLEHT$xHL$HU H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;tIIHGHH;t"Hx Ht
H0ZHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$Hdx ID$HEDMLeLeLEHT$xH HL$00x (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    H~ HA@Hm HAPD$P   rWH* HHn HG(HG@HcHH5g HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    HΓ HA@Hl HAPD$P   UHf HHXa HG(HG@HcHH
a HD9@HG@HcHQT9<HHnHH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H l HAPD$P   QHa HHOHah HHG@HcPHi HD:@HG@HcPDBDD:<HSHHD豠HH\$HHt$XH0_HL$HH	 LL$P)t$0LD$X3)|$ $5#	 =	 Tf/vuv  "   	 LL$PLD$X3Tf/vGv  "   	 LL$PLD$X3踁Tf/vv  "   	 LL$PLD$X3芁Tf/vu  "   	 LL$PLD$X3\Tf/vu  "   	 LL$PLD$X3.Tf/vu  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
 q 3Ld$xM+L$3IIHH+II;HCI;LCI`H$   HH+LL$   HH/HIL$   L+r LGH3H$   IL+r HHGH+HHHtLGL+IЛKLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$pNr HOLD$pHH+$   HH+H#/H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0q H$   ILkHGL+LI+Hq H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(RHt$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
; m H
- m LD$0H|$(IH+HHHDL$pHH: 3HthH+HI;vp H    H=   r=@tp HGH;rp H+Hszp H'vmp HH٤ (L\$PI[(Ik0Is8(t$@IA_A^_@USVWAVAWHl$H   HEH$K H3HEMIHHHE   E3L}D}EGH HMHE   L}D}EGH HM͢HE   L}D}E MA'H5 HM蜢G DF D;tD$ LMHUHM:HEHrPHHMH=   r<t=o HAH;r-o H+Hso H'vo H HE   L}E HEHrPHHMH=   r<tn HAH;rn H+Hsn H'vn H HE   L}E HEHrPHHMH=   r<tin HAH;rYn H+HsIn H'v<n H諢 HE   L}E A   H HM%HE   L}E A   H HMHE   L}E v MA'Hf HM͠HCHHDG D;tHL$ LMHUHMHEHrPHHMH=   r<thm HAH;rXm H+HsHm H'v;m H誡 HE   L}E HEHrPHHMH=   r<tl HAH;rl H+Hsl H'vl H@ HE   L}E HEHrPHHMH=   r<tl HAH;rl H+Hstl H'vgl H֠ Lt$0HCHD$(CD$ LKLHH  HMH33 Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HHF H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ Ht3j HKHD$@H\$HDt$8Aމ\$4D
	 fD  A;]  M}AA|$  ~1I@ H\$@MA(( HA;t$ |ڋ|$0LD$@H$   I聛HHL$@HHT$@HPHL$HHHHT$HH$   i Hai H$   Hzf H$   H$8  h |$0E3H$   H$   h H$   HcHHb H   H$   HcHh   H$   HD$hH$   f L=] L$   L$   D$(  HT$@IM   (D$hH$  H$   GnHXH$  HrTHH$  H=   r<ti HAH;ri H+Hsi H'vi H HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   H H$  @HǄ$     L$  Ƅ$   , MA"H H$  t$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   H4 H$   觛HǄ$     L$  Ƅ$   A   HŜ H$  pH$   HD$ L$  LD$hH$  H$  #H$  HrTHH$  H=   r<tg HAH;rg H+Hsg H'vg H= HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t}g HAH;rmg H+Hs]g H'vPg H进 DXDL$P\$4É\$4H$   HcHH>_ H   H$   HcHh   L$   H$    H$   d H$   $d H$8  d `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I舖(AXHL$@}e (H$(  H3R L$p  A(sA({E(CE(KIA_A^A]A\_^[@USVWAVAWHl$H   HEHA H3HEMIHHHE   E3L}D}EGH HMҘHE   L}D}EGH HM識HE   L}D}% MA'H HM|G(DF(D;tD$ LMHUHMHEHrPHHMH=   r<te HAH;r
e H+Hsd H'vd H_ HE   L}E HEHrPHHMH=   r<td HAH;rd H+Hsd H'vd H HE   L}E HEHrPHHMH=   r<tId HAH;r9d H+Hs)d H'vd H苘 HE   L}E A   H HMHE   L}E A   H HMޖHE   L}E V MA'HF HM譖HCHHDG(D;tHL$ LMHUHMHEHrPHHMH=   r<tHc HAH;r8c H+Hs(c H'vc H芗 HE   L}E HEHrPHHMH=   r<tb HAH;rb H+Hsb H'vb H  HE   L}E HEHrPHHMH=   r<ttb HAH;rdb H+HsTb H'vGb H趖 Lt$0HCHD$(CD$ LKLHH  HMH3 Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HH< H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ(Ht3` HAHD$@H\$HDt$8Aމ\$4D	 fD  A;]  M}AA|$( ~1I@ H\$@MA(( HA;t$(|ڋ|$0LD$@H$   IiHHL$@HHT$@HPHL$HHHHT$HH$   _ HA_ H$   HZ\ H$   H$8  ^ |$0E3H$   H$   ^ H$   HcHHgX H   H$   HcHh   H$   HD$hH$   [ L=S L$   L$   D$(  HT$@IM e  (D$hH$  H$   'dHXH$  HrTHH$  H=   r<t_ HAH;r_ H+Hso_ H'vb_ Hѓ HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   He H$   HǄ$     L$  Ƅ$    MA"H H$  ߑt$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   H H$   臑HǄ$     L$  Ƅ$   A   H H$  PH$   HD$ L$  LD$hH$  H$  H$  HrTHH$  H=   r<t] HAH;r] H+Hs] H'v] H HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t]] HAH;rM] H+Hs=] H'v0] H蟑 DXDL$P\$4É\$4H$   HcHHU H   H$   HcHh   L$   H$   H$   Z H$   Z H$8  Z `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I(d(AXHL$@][ (H$(  H32 L$p  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pH6 H3HEIHHE   3Hu@uDFnH HM辎HHUHP@HEHrPHHMH=   r<ts[ HAH;rc[ H+HsS[ H'vF[ H赏 HHPHE   HuE 8 uLIIB<  uHHMHHUHP@HEHrPHHMH=   r<tZ HAH;rZ H+HsZ H'vZ H HE   HuE A   H HM艍HHUHP@HEHrPHHMH=   r<t>Z HAH;r.Z H+HsZ H'vZ H耎 HE   HuE Ah   H HMHHUHP@HEHrPHHMH=   r<tY HAH;rY H+HsY H'vY H HE   HuE E3Hu HMnHHUHP@HEHrPHHMH=   r<t#Y HAH;rY H+HsY H'vX He HMH3 H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ I  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HOU HOU HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;vZV KHH=   r<t>V HBH;r.V H+HsV H'vV HHH(y H(LHXICHfffffffH;vJH] IC3ICICH6 ICD$0ISIKT HB HD$8HL$8  Hu3KH;vQ HHH   r&HA'H;wQ H貅 HH'HHA蟅 HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"HT Ht
HC5HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHM HLFhLNH     HFH^HHEH~HCH;t+H;t"H>S Ht
Hy4HH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
 	 fHE(WA)HH;}LEMHMՙ H   Hǆ       Ho E3L\$pI[Is I{(I]oH [ EHEHU3HMHEHEH HEQ HJ H
 HEHMؒ LALIIHQ I+HH;|
IH+HH+IHHAHtL+I\zH\$WH H9 HHAPHI8Q HO Q HOQ H	D Ht
   H HH\$0H _@SH HHIUQ HKH [H%EQ @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(DE3EL9{~HN(HJJIL;S|HFXLFLN@HV(Hc
5 WAE H^HH+^@HI;^tIO Ht
H1IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtHѓ ļHH
M    cAE $   H$   H#H;t3@HN Ht+H uHH fHH.M       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [LHXICHH;vJHSV IC3ICICH ICD$0ISIKL H; HD$8HL$8  Hu3	HXHXHhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$PE WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;t9IHHt3L H-HLsHkHnH{ H|$hH|$hL?LHt3cL H3 HHoHnH{0H|$hL?LHt33L Hs-HHoC@   CD HH< HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	 uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
~ H HH|$0胙HT$8HHFHHH\$@HNH+H>LHJ H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PHp& H3HEpMMHHH   D$     HF HD$`HMI D$    E3E3HT$hHL$`II HD$`HcHH4 HD`HD$`HcHDxDD\   HL$hHHL$`虻HHf ZHHHHm @HIeHIG HHNHUPHL$`QHxrH H
R HL$(3HL$0HL$8HD$@D$HHT$0HL$@H HT@ HD$(H
 HL$(܉ @SH`W)t$Pf/D)D$0D(   u+DW 3A(W (t$PD(D$0H`[l fA/DW A(v(
! \((t$PD(D$0H`[3bX (t$PD(D$0H`[5 fA/)|$@D)L$ D
x !   fA/vTfD.z  $ eH%X      HЋ9	   % AYDY9 AX   eH%X      HЋ9 
  A(AY(Y((Y% (Y
 Y X%w X
 X_ YYYw X%? X
O YXK XYX^X%s AY  3t
 ) fA/   eH%X   =H fA/   HЋ   9   A(A(\AYW (Y  ((Y (Ym (Y
 XR XB A^X
 YYYX X
a YYX(Yb X
2 X X: YX YX^Xr Y  y fA/   9@ '  A(A(\AYW (Y( ((Y (Y (Y
2 X X A^X
 YYYX X
 YYX(Y Xr X YXX
 ^X Y   fA/   9   A(A(\5 AY(W Y8 ((Y  (Y
 (Y
 X X A^X
U YYYX X
) YYX(Y* X X
 YXX
 ^X Y   9 Z  A(A(A^AY(YW ^ ((Y (Ys (Y
 XX XH A^X
[ YYYX X X
' YYYX X
 X(Y X YX YX^X Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
 r =  H
  <r H
 r = ({ H
 (
 ^  n (o h   
A (
 Z 
3 q qH
z 	r =n V(9 H
Z (
  (  ( 
 (
q  R 
 (
  
 ,q H
 {q =  ( H
 (
  ( 
 (
  ( 
 (
%  
 p [H
 p = .(- H
 (
 @ (A 
B (
C D ( 
 (
W  
 0p H
X p =L ( H
8 (
  (    ( 
 (
'  0 
 (
j  
 o H\$D$WH`)t$PI)|$@H(D)D$0 f/   (M f.zu@   !   t  ($: (Wf/ WvW"  D(E3(LHXD\( D\   f/vfWf.zo (
) Tf/v虖 D(DW     ^\ Tl D(   = f/v$((\1 \
 (9 D(of/=; r! f/v(k?  D(DHL$p D((X \ ە \m \= YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
 )t$P)|$@   HD)D$0D)L$ D(ȋ
9m    DX
b 5 D(A(AYD^A(A(AY  EX
 YYA^X X
 D(L$ X(t$PYYX] X
M YY(|$@X0 AYXX AYD(D$0\HhH
 l = (C H
x (
 ) (G )
 (
 ) )
 "l H8eH%X   
 A   )t$ (HB9    (\5 \- (\- Y\- ((Y%+ (Y  (Y

 X% X Y X
 YX YX% YX YX
 YYY(t$ XXx X%x X^YY- X(H8H
 Xk =	  H
 (
)  (
 # (  ( 
 (
P  Q 
 (
S  
 kj HH   )xD)@D(DT D)HD(DT
 D)PE(D)XD fE/D)`D(EYrA(A(A(C (   3 fA/A()$   rA (A(A =  `A (A(TA (XY= YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW= (($   HĨ   @USVWAVHl$H  HD$PHe H3HEpMHHH   D$     H5 HD$`HMx8 D$    E3E3HT$hHL$`A8 HD$`HcHH# HD`HD$`HcHDxDD\   HL$hzHHL$`葪HHU RHHwHH[ 8HI]HHU HHCHUPHL$`@HxrH H
@ HL$(3HL$0HL$8HD$@D$HHT$0HL$@7 HQ8 HD$(H
 HL$(x H@Hx)p()xD)@D D)HD
 fD/D)PEWA(rPA(\(pD (\f/
E vAXfA.z   =9 Y(1 ^fA.z   f/5 r
(ZX
 f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   HD| H
U D$   n L$   H| H
 R @USVWAVHl$H  HD$PHe H3HEpMHHH   D$     H2 HD$`HMx5 D$    E3E3HT$hHL$`A5 HD$`HcHH  HD`HD$`HcHDxDD\   HL$hwHHL$`葧HHR RHHwHHX 8HI]HHKj HHCHUPHL$`=HxrH H
= HL$(3HL$0HL$8HD$@D$HHT$0HL$@4 HQ5 HD$(H
 HL$(u HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p5 )xWD)@D D)HD
 H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4CF H;}&HEHM(HE)HH;|LHMH HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ s E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   ? HHL$(? H
 HL$(q @SH0HD$     JHH0[@SH0HD$       HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH  3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+IGe  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHM!LeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHMLeHEH}IHtHHHEIM;w!H
a , H
a , H]3MtyIrTIƃIH+fo f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHM賋HUHVH?HMHthHEH+HH;vt. H    H=   r<tX. HAH;rH. H+Hs8. H'v+. Hb A   L}XI;      HVHHMOE3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HHBHNHMKHHHMHt	H]L}X1L;Fu
   H
BHNHMXHMHt
HUpH]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH0a IL}XL;}s(, , , , , HtsL+IHL;vb, J    H=   r=@tE, HGH;r5, H+Hs%, H'v, HH` IM H   IEH+HH?H;v+ H    H=   r<t+ HAH;r+ H+Hs+ H'v+ H` 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){H7 H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0# f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   _7 V  H$  H$   AeHL;   IM Ht~IEH+HHH;v4) H    H=   r<t) HAH;r) H+Hs( H'v( HZ] Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;v( H    H=   r<tc( HAH;rS( H+HsC( H'v6( H\   Ha( H$  L$  H$   H$  H& H$   H# H$0  H$  -& AD|$4E3H$8  H$   % H$   HcHH H   H$   HcHh  H$8  HD$XH$8  :# H H$8  H$  $  ML$   H$  HL$PH$  H$   x+HXH$  HrTHH$  H=   r<t& HAH;r& H+Hs& H'v& H"[ HtHH$   HPH$   HcHH H   H$   HcHh  H  H$8  H$8  [dH$8  E$ H$@  # H$  1$ H$ H$   H! H$0  H$  D$ AD|$4E3H$8  H$   $ H$   HcHH H   H$   HcHh  H$8  HD$XH$8  Q! H H$8  H$  $  L$   IHL$P-: (H$  H$   )HXH$  HrTHH$  H=   r<t$ HAH;r$ H+Hs$ H'v$ H?Y HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   Hؾ H$  {WHH$  HP H$  HǄ$     H$  Ƅ$   A>   Hʽ H$  %WHH$  HP H$  HǄ$     H$  Ƅ$   A4   HԹ H$  VHH$  HP H$  ?H$  !(H$  ! H$   \  H$  S)W$  H$  A# L$  L$   IHL$PF# +fn^5 H$  H$  X'HXH$  HtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   Hռ H$  XUHH$  HP H$  HǄ$     H$  Ƅ$   A8   H H$  UHH$  HP H$  rHǄ$     H$  Ƅ$   A4   Hq H$  THH$  HP H$  E2HI;EulMtL$  M+IIHH$(  %H$(  @ H$  %H$  $ H$   vZLd$`4  $   J  HǄ$     H$  Ƅ$   E3H) H$  SHH$  HP H$  ;H$  ~&Hv H$  H( HHC HH$  HPH$  0&Y5G Hp H$  ÌHH9 贌HH 襌H(Q HH 芌HH$  HPHǄ$     H$  Ƅ$   A%   H8 H$  RHH$  HP H$  #HǄ$     H$  Ƅ$   E3Ht( H$  `RHH$  HP H$  HǄ$     H$  Ƅ$   E3H)( H$  
RHH$  HP H$  }H$(  _#H$(   H$(  C#H$(   MtL$  M+IIFH$(  
#H$(  | H$  "H$  ` H$   WD$HL$@T$2   H$  "H$  % H$   wW3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3H& H$  cPHH$  HP H$  H$  #H H$  豉H(] HH 薉H(B HH` {HH lHȋT$@/ HH% PHH$  HPHǄ$     H$  Ƅ$   Ae   H& H$  yOHH$  HP H$  H$(   H$(  = H# H$   3H$   H$   H= H$   Ƅ$   H$   H$   O H H$   H9
 H$   [ HL$pHIPH\$xHt(H$   HL$   L+IH@H$   HtL$   L+I92IH$  H3FH ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH
 H3H   (MLHT$`HL  L  H  3ۉ\$DH    WD$HH\$XLL$HMIH(H  H   HXH  HrSHH  H=   r<t8 HAH;r( H+Hs H'v HzN H   IH   IPH  H   >HLAHW	 H;t
HHAАH  HrSHH  H=   r<t HAH;r~ H+Hsn H'va HM W  Hǅ      t$(H  HD$ MMIHWA H  H   tHXH  HrSHH  H=   r<t HAH;r H+Hs H'v H M H   IH   IPH  H   HLAH H;t
HHAАH  Hr\HH  H=   r<t4 HAH;r$ H+Hs H'v HvL H E3EDd$@H  H H  rH( HH;tHPH  H  HLAH;t
HHAАH  HrSHH  H=   r<t\ HAH;rL H+Hs< H'v/ HK HH;tHPHǅ     L  ƅ   E3H(  H  JIH  IP H  HrSHH  H=   r<t HAH;r H+Hs H'v HJ IH  IPHǅ     L  ƅ   E3H H  PIIH  IP H  HrSHH  H=   r<t HAH;r H+Hs H'v H>J H  
   HL$hQ H  HcQH  HHP   H   $ HH H  HHuI
H HcHHHW   HM HH| HЁHHuI
H HcHHHW   HM HHf H蒁HHuI
H HcHHHW   HMf HH԰ HTHHuI
H HcHHHWH H(H  H  HLAH H;t
HHAАH  HrSHH  H=   r<t% HAH;r H+Hs H'v HgH IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
  = H
 HEH 
 HEHMH L$DE3HUHM HEHcHHn HD
HEHcHhT
HEH   HM H HE3HE0E8IHHH   
   HM HMHcQHMHHP   HMr LIHM" HHu3
H HcHHIWA   HM6 LH   H HHu3
H HcHHIWA   H    LB+H HHu3
H HcHHIWA   H   LHW HHu3
H HcHHIWAB+\H' H   HMHLAH8 H;t
HHAАH   5	IHUIPB+\Tf/vD$@HMHHMHn IHL|$`IGI+HL;H|$hH
8Dl$@H  H\$HHX  HX   HX  HX   HtL  L+IHb8HtLD$XL+IHH8HX  ;HX   AH   H3= L$P  I[XA(sA({IA_A^A]A\_^]LWATAUAVAWHP  IǃPI[IsA)sA){E)CE)KE)SE)xE)hE)XH

 H3H$  HL=9 EWW$   Iǃ8    IMIǃ    Iǃ    H
HBH+HHueH8 Ip3IxIHD HD$(D$0IxHL$(
 H H$  HPD H$  HǄ$     D	D$   HBH+HHwiH H$  3H$  H$  H&D HD$(D$0H$  HL$(1
 H H$  HC H$  ~   H$  DAD$   D$8E3LL$HMcoxIMt$M;v
H
s@ 
 IHL$80^LL$HE3HT$@LD$8M;  HFH+HH;riH H$  3H$  H$  H5C HD$(D$0H$  HL$(@ H H$  HB H$  HHH$  H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
Y? 	 HM+IIHIH+IE3I;LCL;ICHL$8\LL$HHT$@LD$8H   IH   I;usIH+HHscI+HIH+Hs
H
> N	 HM+IIHIH+IE3I;LCL;ICHL$8b\LL$HHT$@LD$8Ht2HHT$@IH$  b AXD$(WD$PE3Ll$`Mcg,MtM;v
H
&>  IHL$P[MH\$XHt$PfD  M;   H$  J(D$ HD$ H;sDHD$ H;w:H|$ H+HH;\$`u   HL$P+5H\$XHt$PHt2HH)H;\$`u   HL$P4H\$XHt$PHt3HH\$XIYۖ    HǄ$      L$  Ƅ$   A   H: H$  	>HǄ$      L$  Ƅ$   A   H; H$  =EGxEyH$  H$  #iH$  5H$  'IcWxH$   IL$   IH$   H+HHt+LA<HL$   IH$   H+HH;rIL+IMt*f     <HH$   H+$   HH;r    HǄ$      L$  Ƅ$   A   H= H$  <HǄ$      L$  Ƅ$   A   H: H$  <EGxAyH$  H$  gH$   H$   AGxHcHL$pILD$xIHT$pH+HHt.Lf     A<HLD$xIHT$pH+HH;rIL+IMt<HHD$xH+D$pHH;rV    HǄ$      L$  Ƅ$   A   H9 H$  ;L$     HL$plDH$     D  A;_x0  ؓ    HǄ$@     L$8  Ƅ$(   A   H/9 H$(  ;HǄ$      L$  Ƅ$   A   H7 H$  :HcL$(  HHL$p趺HL$  HHL$8螺0X6HǄ$      L$  Ƅ$   A   H8 H$  `:HcL$  HL$pH0H$  H$  H$(     D%8      A;x   %   HǄ$`     L$X  Ƅ$H   A   HS6 H$H  9HǄ$      L$  Ƅ$   A   H7 H$  9HǄ$      L$  Ƅ$   A   Hq7 H$  H9HcI   L$H  H-LL$  HHL$pHHcL$  HL$p^ A(\AA\YHǄ$@     L$8  Ƅ$(   A   H6 H$(  8L$(  HH$   莸0H$(  
H$  H$  H$H   &   HǄ$`     L$X  Ƅ$H   A   H46 H$H  8L$H  HH$   DX H$H  xAAOx;}A;}Y +   HǄ$@     L$8  Ƅ$(   A   H4$ H$(  7HǄ$`     L$X  Ƅ$H   A   H$ H$H  P7EG(EyH$(  H$H  bH$H  H$(  IcW(H$  tIL$  IH$  H+HHt+LA<HL$  IH$  H+HH;rIL+IMt(    <HH$  H+$  HH;r .   D$h   Dl$ LD$hHT$ H$   1 D$ HT$ H$   )ˎ /   D$    Dl$hLD$ HT$hH$    D$ HT$ H$    0   Dl$ M   HT$ HL$8讶 D$ HT$ H$   H 1    D$hDl$ LD$hHT$ HL$( D$ HT$ H$   ] 2   Dl$ M   HT$ HL$Pȼ D$ HT$ H$       D$   D$   D A;w(   6   HǄ$     L$  Ƅ$   A   HU1 H$  4HǄ$     L$  Ƅ$   A   HB! H$  4L$x  L$  E33H$h  -A   H0 H$h  P4L$  L$   E33H$  }-A   H  H$  4L$8  L$@  E33H$(  @-A   H0 H$(  3HcIOHL$  H辳LL$  HI   D  HT$8HaD(IO0L$h  HLL$  HI   D  H$   H`(I   L$(  H[D  HT$PH`(AXA\EXAYAWV AXA4$^XL$X  L$`  E33H$H  %,A   Hl H$H  2L$H  HH$  袲0H$H  !H$(  H$  H$h  H$  H$  6֊ 8   IO`LD$(H$   D$(HT$(H$   H$  HtL$  L+Ij&HT$pHt%L$   L+IK&WD$pL$   H$   Ht(L$   L+I&W$   L$   HT$PHtLD$`L+I%HT$8HtLD$HL+I%Dl$(HT$(H$   $H$   G| (H$   HtL$   L+I%(H$  H3* L$P  I[8Is@A(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@!' D($h  H^H+HWL$XLt$hHtHHHH;thEHHHt3 HHD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3R HHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$XqHVH+HHL$pG5N D D$   =  fD/i  Y5= $   fD/  HL$pHHtmH$   H+HH;vC H    H=   r<t' HAH;r H+Hs H'v Hi/ HL$0 HL$X HtqH$   H+HH;v H    H=   r=@t HGH;r H+Hs| H'vo HH. HtlHD$PH+HH;vF H    H=   r<t* HCH;r H+Hs
 H'v HHi. A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;v H    H=   r<t HAH;r H+Hs H'v{ H, HL$0 HL$Xz HtqH$   H+HH;v: H    H=   r=@t HGH;r
 H+Hs H'v HH\, HtlHD$PH+HH;v H    H=   r<t HCH;r H+Hs H'v~ HH+ (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(2rHHT$(HPAEHT$(HPHHHT$(P HL$(Ht HT$0
LD$8HT$(L+IH\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHH~qHHT$(HPWD$@Hl$PHT$@HuHLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$H>LD$PHT$@L+IWD$@Hl$PHL$(Ht.HT$0LD$8HT$(L+IWD$(Hl$8H IIN L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
fLP  L8  L0  D  = HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn($K K ,H
hH
 HD$@H 
 HD$PHM H  E3HT$XHL$@[ HD$@HcHH2 HD@HD$@HcHhT<HD$XHD$0HL$X H HD$X3HEEH HL$Pf`HcHMhY HL$PHcQHL$PHHPAHL$P HHb %`Hȋ      HMx HD$0H/c HL$P_HHu3
H HcHHHD$0HPfAnY^,H HHb _HT (   H6 HEHL$P_HX  HHT$@PHD$@HcHH HD@HD$@HcHhT<H> HD$XHL$X0HL$X HL$` HM HX  L0  HLMHU@HPHIo  H: HE@HMHD     t5Ǚ  u(H@  HD$ LMI, LIIq;   D  D   H
1L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  +HH$  ;W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  rHL8HL$pHHLxHL$xHHLxH$   H$   HHL$pH H$   WH$   /H H$   H$  H H$  H$  H$  H$  H$    $(  (
 )$0  W$@  D$H  Ǆ$L     " $P  D$X  Ƅ$\   $`  H) H$   HT$pH$   $8  f/v	$0  $@  f/v f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H. H$   HW	 H$  H$    H$    H$    H$    HX H$   HL$p H$   HtL$   L+I+33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p
HHL$t	W$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   sWD$xH$   LLGIH$   HHHL$xHHHXH$   HHHXH$   H$    HHL$x脵H, H$   WH$   H H$P  H$`  H H$X  HD$pH$h  HD$pH$p  t $x  (
 )$  W$  $  Ǆ$      $  $  Ƅ$   $  H H$   WH$  NL5 L$   L= L$  HT$xH$   $X  f/v	$  $`  =e f/vf/v	$  $  $h  Oȉ$  Y
f (@ $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  H$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   " L$   L$  H$p   H$`   H$  8H H$   H H$X  H$8   H$(  v H$  h H$   Z H H$   HL$x@ H$   HtL$   L+I33HL$x H$   HtL$   L+IdN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  HH$  +W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   WD$pLLGHH$h  誤HL8HL$pHHLxHL$xH$h   HHL$pGHW H$   WH$   'Hp H$   H$  HQ H$   H$  H$  H$  H$  ( )$   (
 )$0  D$@  Ǆ$D     8 $H  D$P  Ƅ$T   W$X  H H$   HT$pH$   b$(  f/v	$(  $0  f/v# f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     H H$   H H$   H$   , H$    H$    H$    Hk H$   HL$p H$   HtL$   L+I>33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xH)
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pHHL$tW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   胶WD$xLLFIH$   BHHHL$xHHHXH$   H$    HHL$xܨH H$   VH$   輸H H$8  H$H  H H$@  HD$pH$P  HD$pH$X  (% )$`  (
F )$p  $  Ǆ$     Ԅ $  $  Ƅ$   W$  HI H$   VH$  聾L5 L$   L=c L$  HT$xH$   Ѹ$8  f/v	$h  $@  = f/vf/v	$x  $  $H  Oȉ$  Y
 (6 $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  &H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   e L$   L$  H$X   H$H   H$   kH, H$   H H$@  H$(   H$   H$    H$    H H$   HL$xs H$   HtL$   L+I33HL$xA H$   HtL$   L+IN   H$x  H3
 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3P H落HHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHM)Z H H]HL$xHEHL$xHMHT$pLL+t
H2 HT$pWEHs WEHE    HMrWHHUHPAEHUI蒇IE HUIP HMHtHUQLEHUL+I-H]HM@HEHMHMHULL+tH;2 EEfEMLHUHM
, D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H    +fDnED^~ HM5ZH   HIP w H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H     +fn^5H~ LM(A(h\LM(A(X\(A(HMaH0 HEHM: L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CHǴ
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"IN Ht
H艹I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  V II谖  L$   H$   H$   L$   WD$xHt3a H衸HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   
U H H$   H$   ͷH$   H$   H$   HT$xLL+t
H- HT$xW$   H> H$   LMH$   H$   H$   FULMHH$   Pr D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I  +fDnED^%z Aƅ    A   , AExH$   \UH$   ICIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4& +fn^5\y L$   (A(xWL$   (A(dW(A(H$   \H8 H$   H$   :  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  ]HH$  mW$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   -WD$pL$   LLFIH$  褖HL HL$pHHL`HL$xHHL`H$   H$  F HHL$pAH H$   VH$   agHҽ H$   H$  HC H$  H$  H$  H$  H$   +s $(  (
y )$0  W$@  =t $H  $X  Ǆ$P  
   H H$   HT$pH$   g$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   HU H$   H H$  H$   X H$   J H$   < H$   . H H$   HL$p H$   HtL$   L+Ij33HL$p H$   HtL$   L+I8N   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xHI
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$tW$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   藣WD$xH$   MLFIH$   HHHL$xHHHXH$   HHHXH$   H$    IHL$x記HP H$   VH$  bH9 H$`  H$p  H H$h  HD$pH$x  HD$pH$  n $  (
 u )$  W$  =4p $  $  Ǆ$  
   HP H$   VH$  舤L=I L$   L% L$  HT$xH$  c$X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y
p (# $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  "H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   i L$   L$  H$x   H$h   H$   _H H$   H H$h  H$H   H$8   H$    H$   H H$   HL$xg H$   HtL$   L+I33HL$x5 H$   HtL$   L+IN   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  BHH$  RW$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pLLFIH$h  ЇHH     HL$pHHH@    HL$xH$h  : HHL$peHu H$   VH$   EH H$   H$  Ho H$   H$  H$  H$  H$  (o )$   (
m )$0  =j $@  W$P  Ǆ$H  
   H
 H$   HT$pH$   蘠$8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H̻ H$   H% H$   H$   W H$   I H$   ; H$   - H H$   HL$p H$   HtL$   L+Ii33HL$p H$   HtL$   L+I7N   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xHI
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$tW$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   藙WD$xLMFIH$   VHHHL$xHHHXH$   H$    HHL$xH  H$   AVH$   ϛH H$H  L$X  H H$P  HD$pH$`  HD$pH$h  (8k )$p  (
Yi )$  =Yf $  W$  Ǆ$  
   H H$   AVH$  詡L= L$   L% L$  HT$xH$   $8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
f ( $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   CH$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$    L$   L$  H$`   H$P   H$  耹HA H$   H H$P  H$8   H$(   H$   H$    H H$   HL$x H$   HtL$   L+I33HL$xV H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I> Ht
HyI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  < II}  L$   H$   H$   L$   WD$xHt3Q H葟HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   ; Hr H$   H$   轞H$   H$   H$   HT$xLL+t
H HT$xW$   H. H$   LMH$   H$   H$   6<LMHH$   @b D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^a Aƅ    A    AExH$   L<H$   I*IMHH$   P| Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$ +fn^5L` L$   (A(h>L$   (A(T>(A(H$    CH( H$   H$   *  H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[@SVWH   HD$0H
 H3HD$xIHHHD$p   HD$h    D$X A   H HL$XHD$P   HD$H    D$8 A   H HL$8WHNH+H*HHLI?LH\$(D$    DHL$8ZHD$PHrQHHL$8H=   r<tۺ HAH;r˺ H+Hs H'v H HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<th HAH;rX H+HsH H'v; H HHHHHL$xH3 HĀ   _^[@USVWAVHl$H   HEH
 H3HE'MHHHE   3H]]DCH HMHE   H]]DCH HMHE   H]׈]DCH HMLt$ LMLHUHMW/HEHrPHHMH=   r<t* HAH;r H+Hs
 H'v Hl HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   H]E HEHrPHHMH=   r<tV HAH;rF H+Hs6 H'v) H H` HH0H_ H;_ r
0   `HHMHtHLNL+IMC  HHHHM'H3 Hİ   A^_^[]H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtH0 
 uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
A I   LNB	9J^   HII9H3H-\ HLL%\ HL=\ H;1HLH0  HEH?L   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
@\  =4\ H
Z H
\ > Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05V f     IM(W Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05U f     IM(W_ Hv;}(|(t$0Ht$hH\$`MHT$ HPIHHIINHPHHHL$ IVA Hl$pH@A_A^_H   "A)(Y-V ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YY V Y=U \A(YpU ^X^^A(\AX(YY\	 H$   (DT XDS (\D H$   A(YA(^W_ (YA^A^XX^YW^ AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM9  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHKDHH@  HEHCHEHLL+t9 E3EH  D=\ D5MQ @ f     H   H HEuIHEI^HGH;t'H;tHs Ht
H讏HL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHME# LMHH   H=]tAXAY
HuLuI~ uA("HHEIHEHEHEHM7  (A$A(H   YH(  X	f/   fA/r	E   (T
[ A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHFܬ D(Y50Q A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(EM H\$    LMHH_ DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(HY
 H3H$X  MMHHH$  H\$ HL$0H$0  HD$@H$8  MMHH$0  % H$0  HL$0DHxH$H  HrTHH$0  H=   r<t HAH;r H+Hs H'v H HtHHT$0HPH$   H$   _ H$X  H3? H`  A_A^_^[LMCSVWATAUAVAWH  IǃA)sA){H
 H3H$  ILH$   LH$   H$   L$x  L$   H$  H$   IǃP   3IH@$  DGHP I8HǄ$X     H$P  @$@  DGH< H$@  WHǄ$x     H$p  @$`   MA.H H$`  EF AG D;t"D$ L$  H$@  H$`  !H$x  HrTHH$`  H=   r<t HAH;r H+Hs H'vu H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<t$ HAH;r H+Hs H'v Hf HǄ$X     H$P  Ƅ$@   H$  HrTHH$  H=   r<t HAH;r H+Hs H'vy H HǄ$     H$  Ƅ$   A   HO H$  RHǄ$X     H$P  Ƅ$@   A   H H$@  HǄ$x     H$p  Ƅ$`    MA.H H$`  HCEG D;t#HD$ L$  H$@  H$`  5H$x  HrTHH$`  H=   r<te HAH;rU H+HsE H'v8 H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<t HAH;rצ H+HsǦ H'v H) HǄ$X     H$P  Ƅ$@   H$  0Ic_ WD$`Ht3 HΆHHD$`HL$`H\$hW($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$`H$8  HHH+HHHHH~'fD  f)HH;}$  HL$8LH$    Ic_ WD$HHt3 HHHD$HHL$HH\$P($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$HH$8  HHH+HHHHH~(    f)HH;}$  HL$8LH$    Ic_ W$   Ht3 H)HH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$    Ic_ W$   Ht3	 HIHH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$   ? Ic_ WD$xHt3, HlHHD$xHL$xH$   ($   H$   H$   H$   H$   H$(  HD$0H$0  HD$xH$8  HHH+HHHHH~2@ ff     f)HH;}$   H$   LH$   \ D|$8|$p5xD      $p  D;  DA  ~6H H$   M(( 3AHvE;w |H$   L$   H$`  IHHHL$xHHT$xHPH$   HHH$   H$`   H$   tH$`  H$   H$0  H$   L$   L$  HT$xH$   Q H$   H$   茥HXH$   軘HtHH$   HPH$0  H$8  E33H$   CA   H H$   H$  H$  E33H$  o MA.H_ H$  L$   H$   H$  TH$  H$   L$   L$   HL$`H$  H$  H$   H$   H$(  HD$XH$0  HD$`H$8  LL$hIHH+HHHHH~, (fAX)HH;}L$   H$  MH$   7r LD$HLD$8L$   L$  L$   L$  HL$HH$@  H$@  H$   H$  H$(  HD$1H$0  HD$8H$8  LT$PIHH+HHHHH~B     A(fAY(fX)HH;}L$  L$  H$@  MH$   f= ADd$8H$  1H$   ]3Dd$8WL$   H$   H$   L$   H$   fn($@  HL$`H$  H$  H$   H$@  H$(  HD$1H$0  HD$`H$8  LD$hIHH+HHHHH~<@ f     (f(f^)HH;}$@  H$  H$   
 $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  HD$HH$8  LD$PIHH+HHHHH~5fD  (f(f^)HH;}$@  H$  H$   T HD$HHD$8HL$HH$  IOH$  IWH9T$PtA   HL$8\ HD$8HH$@  H$@  H$   H$  H$(  HL$1H$0  HL$8H$8  LpIHH+HHHHH~FH$  ()$`  H$`  H$  (fYH$@  )HH;|MHH$   W HD$HH$   $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  H$   H$8  LD$PIHH+HHH~=@ ff     (f(fX)HH;}$@  H$  HH$   ap HT$`H$   迱HT$HH$   譵HL$x	 H$    H$    HL$Hߙ HL$`ә H$  H3 ($   ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
A Ö HMLM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMaLMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHMLMHMLEHtHHLMLEHMHHMHHcI;F}!H
 R H
 D WEHE    LEHUI[  (HMH   HEH+HH?H;vC H    H=   r<t' HAH;r H+Hs H'v Hi WEHE    HMHthHEH+HI;v H    H=   r<t HAH;r H+Hs H'vy H (L\$pI[ Is(I{0Mc8(t$`IA_A^]LMCSVWATAUAVAWH  IǃA)sA){H#r
 H3H$  IHH$   LH$   H$   L$8  L$   H$@  H$   IC   3I{@$  DGHv IxHǄ$8     H$0  @$   DGHb H$   }HǄ$X     H$P  @$@  Y MA-HI H$@  <DF(AG(D;t"D$ L$  H$   H$@  
H$X  HrTHH$@  H=   r<tȕ HAH;r H+Hs H'v H
 HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<tJ HAH;r: H+Hs* H'v H HǄ$8     H$0  Ƅ$    H$  HrTHH$  H=   r<t̔ HAH;r H+Hs H'v H HǄ$     H$  Ƅ$   A   Hu H$  xHǄ$8     H$0  Ƅ$    A   H H$   AHǄ$X     H$P  Ƅ$@    MA-H
 H$@   HCEG(D;t#HD$ L$  H$   H$@   "H$X  HrTHH$@  H=   r<t HAH;r{ H+Hsk H'v^ H HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<t
 HAH;r H+Hs H'v HO HǄ$8     H$0  Ƅ$    H$  VIc_(W$   Ht3 HrHH$   H$   H$   W($`  HL$PHD$PH$   H$`  H$  HD$0H$  H$   H$  HHH+HHHHH~.@ f     f)HH;}$`  HL$PLH$    Ic_(WD$8H|$HHHt5HHHH;t6HtHHHH;tLLLLIHL$8.|$PHD$@H;u
LD$HL;t:HtHHHH;tLLIHL$8LD$HHD$@HL$8H$`  H$h  H$`  H$   HT$PH$  HT$0H$  HT$8H$  LIHH+HHHHH~"D$Pf)HH;}
H$`  H$    Ic_(WD$`Ht3o HpHHD$`HL$`H\$h(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$`H$  HHH+HHHHH~+ff     f)HH;}D$PH$`  LH$    Ic_(WD$pHt3 HoHHD$pHL$pH\$x(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$pH$  HHH+HHHHH~(    f)HH;}D$PH$`  LH$    Ic_(W$   Ht3ɍ H	oHH$   H$   H$   (|$PH$   H$   H$   HD$PH$  HD$0H$  H$   H$  HHH+HHHHH~)     f)HH;}D$PH$   LH$    D|$4$   50      $0  D;C  DA( ~+H H\$pM((}  AHvE;w(|LD$pH$@  IvHH$   HH$   HPH$   HHH$   H$@  R H$   H$   H$   H$  H$   LL$`L$`  H$   H$    H$   H$   4HXH$   cHtH$   HH$   PH$  H$  E33H$   A   Hy H$   |H$p  H$x  E33H$`  詸R MA-HB H$`  5LD$`H$   H$`  {H$`  蜃H$   莃LD$`L$  H$   H$   H$   H$   H$  H$  HD$1H$  H$   H$  L$   IHH+HHHHH~, A(fX)HH;}L$  H$   MH$   ] A( U  L    LM0  MYICH   A   IHT$@IHL$8HD$`BHD$pBYXIRHT$@IHL$8HD$`BHD$pBYDXIHT$@IHL$8HD$pBDHD$`BYXIRHT$@IHL$8HD$pBDHD$`BYXIIM;&M;9IHT$@IHL$8HD$pBHD$`BYXIM;~IA;_(ADd$4H$  PH$   3Dd$4WL$   H$   H$   L$   fn($   H$   H$  H$  H$   H$   H$  HD$1H$  H$   H$  L$   IHH+HHHHH~:fff     (f(f^)HH;}$   H$  H$   $ $   HL$8H$`  HD$@H$h  H$`  H$   H$   H$  HT$1H$  HT$8H$  LD$HLIHH+HHHHH~4D  (f(f^)HH;}$   H$`  H$   d IwMwHT$8L\$@HD$HH$   L$   H$   L$   I;IMLL$   I   I@H$   MfIMkIO6OLHMIIHH$    (A^XJIHI(^DXDDJJ(^DXDDI>I(^DI;IXDDHJ    LJ    LIMH;$   H$   XL$   I;}BN   N4   HIHHIHL+(^X  IIIuH$   H$   xHT$8H$   yH$   K HL$p? HL$`3 HL$8' H$    H$  H3 ($  ($  H  A_A^A]A\_^[H   HD$ HH$    HHL$( H 
 HL$(G @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@r  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQHp HC(HCH;CuHHCHC H0[@SH H@  Hky HC`H [HL$SH0HD$ HD$P    EtH HAPH+y HA`D$P   J   H[ HH9 HC(HCPHcHHt HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHHn HHQ3HHBHO Hy HHGHFHG HF H^(H\$HHZ HHO0HKHtHPHG8HCHG@HCGHC HOi HHn HHH\$PHt$XH0_H\$WH HH HHQ3HHHKHB_ H@y HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tH Ht
HbHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@v  IFL\$`I[(HEIF HE HIk0IA^_^@SH H| HHH HAhHIH HK8 HK  HK Hr HH [@SH Hk HHH} HA`HIHP HK8F HK < HK2 Hr HH [@SH Hh HHH& HAhHIH HK8 HK  HK H;r HH [@SH Ht HHHV| HA`HIH HK8 HK | HKr Hq HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3"HW(HK(HA   HA    HyrHH  IE3HH\$HH0_@SH H  H[t HCPH [HL$SH0HD$ HD$P    EtH HA@Ht HAPD$P   J   Hi HH!~ HCHC@HcHH6m HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH^ HHQ3HHBHK} Hk HH{3HHDH^H\$HHM| HHOHKHtHPHGHCHGHCG C Hi HHf HHH\$PHt$XH0_H\$WH H<:  Hr HG`t
h   Hg HH\$0H _@WH0HD$ H\$@HHc HH{ HA(HI0HtHP tHC0    H8 HHKc| @t
P   H HH\$@H0_H\$WH H  H%r HGPt
X   H觱 HH\$0H _@WH0HD$ H\$@HHg HHz HAHI HtHP tHC     Hx HHK{ @t
@   H( HH\$@H0_LH   ICAC    HQHK ICHPq ICAC   IK{H4f HD$(HP{ HD$@HD$hHcHHcj HDhHD$hHcHDd    H
 HL$(һ @SH0HD$ HٹX   < HD$@HSHD  HHtH@@HcHHB@HH0[@SH0HD$ HHwe HHz HAHA@HcPHi HD
@HA@HcPDBDD
<Hf HH+y HAHI HtHP tHC     HՂ HHKH0[H%y @SH0HD$ HHe HHx HAHI HtHP tHC     Ho HHKH0[H%y HVWAVH`H@HXHhHU
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHKv HD$(v HHL$ 詏tHC    HL$ kWHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
'b H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHC  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HB  HL$8pHL$(HtHPHtL    HA2HL$XH3ť L\$`I[(Ik0IA^_^HVWAVH`H@HXHhHS
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK t HD$(t HHL$ 褍tHB    HL$ fUHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
"` H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHB  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2HA  HL$8nHL$(HtHPHtL    HA2HL$XH3 L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH?  (HغH8r HH_(H    H HHH} H;n rHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HH- HHH  H; r蒲HHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   t>   ^   ,A;ALǉ   LCHSHH  ?NtUHH@        ^,A;ALǉ   Y     H   H   HH\$PHl$`Ht$hH0A_A^_@SH Hˋ HHH^ H   Hp  p H`  p H  )iHe HHHm HC`HKHp HK8xp HK np HKdp Hb HH [Wf/v(      ^   ,;L   H\$WH HHH   HcH   HcH   HH\$0H _cHHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J>  HSH~H_HG`LGpHHO`P8LHHO`9HHL$@Ls(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;v \( (= f/vNHOxf/v?HD$@H;t5HKHT$HUD$hC(HKHT$X<HK0HT$p.]s(HHO`Y  X   w0Hk I$I\$H$   HO7OHHHGHCHWHGLL+t/ W5 At$A|$ HL$pm HL$Xm HL$Hm IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   9   ^   ,A;ALǉ   LCHSHH  BtUHH@J        ^,A;ALǉ   Y     H   H   HH\$PHl$`Ht$hH0A_A^_@SH HS HHHR H   Hx  l Hh  
l H   dHT HH HChHKHk HK8k HK k HKk H-^ HH [Wf/v(      ^   ,;L   H\$WH HHH   H1_H   H"_H   HH\$0H _	_HUSVWATAUAVAWHhH(  HE)p)xD)@HF
 H3HEMILH3t$8G  HSHH_HGhLGxHHOhP8MHHOhHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PD DD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(D$0HHD$0H#H      H;v \(2 (= f/vLH   f/v:HEH;t1HKHUoEC(HKHUXHK0HUK]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(   w0Hf IE I]H\$0HO#JHHHGHCHWHGLL+t W5 AuA} HMh HMh HMh IHMH3_ L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   4LGHWHH  Dt8HH7     Y ?    H   H   HH\$PHl$`H0A^_^@SH H3h HHHZ H   Hx  Jg Hh  =g H   _HzR HHc HC`HKHg HK8g HK f HKf H]Y HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=1	 H(Vi(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_iH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@  HL$0me L$   HHH$   ($   HĠ   _:Hl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]X膼 ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3Td HEHHkHF@HD$hHFHD$xHv H;t'H;tHd Ht
HWEHH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@! HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Yp H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWY H   H	H H$   HD$@H$   H$   H$   H$   ̴ Y H   Wf/v? f/v   Wf/v   H\$WH HH5  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHwUfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HˋHSHt
HHH
HB$H;Cu
   H蟋HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HBHSHt
HHH
HJ$H;Cu
   HHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H越HSHt
HHH
HB$H;Ku
   H芊HCHt0HH   HCH;s;HH;w3H+HH;Cu
   HGHSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    -  HSII^IF`MFpHIN`P8MHIN`HHMHUH   HUHM0HUH   IF`LHUIN`P(HM?HE HMHM(HULL+tH蘵 HMs?HEHMHMHULL+t	Hn IN(H?HD$xIN(HMIV LL+t	HB EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      Ds D  D%  D- H}WD$hHt3N] H>HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM袝 DUINxfA/  HEH;   HcuH;st$HKn\ tH=HCHC    Hs~LEN    HUHK藳 EC(Hcu H;s t$HK\ tHQ=HCHC    Hs ~LE N    HUHK> HcuHH;s8t$HK0[ tH<HC0HC0    Hs8~LEN    HUHK0 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I/  HEH;  HSHMC(EHSHMHM   H   H;t=HKH      C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I.  H   H;t=HSH   #C(   HSH   H   HS0@  A   uf/w(\Y (INxf/v=H   HM8   EXH   HMHH   HM`f/v\(达X(\(詾(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHMM, HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$hX A   A9   HL$hW Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0We IV(HHL$xRW HMGW HM <W HM1W H   #W H   W H   	W HM`V HMHV HM8V H   V H   V H   V HMV HMV HMV HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   "LGHWHH   +t8HH^3     Y& O    H   H   HH\$PHl$`H0A^_^@SH HQ HHHN H   H  ZU Hp  MU H(  MH*Q HHXq HChHKH"U HK8U HK U HKU HmG HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=A H(fW(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_!WH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@ HL$0}S L$   HHH$   ($   HĠ   _JHWH   H@HXHhHp )pIHHz W@Ht3S HF4HD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrC  H$   H$   HD$8HD$(HD$@HMHT$8 HL$HR HL$(tR L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3R HB3HHoIvHH;t'H;tHQ Ht
H3HHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   2 HIFHD$pHD$x   INHIF@H$   H$   - D$0HT$ LL$pL$   IVP| HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   Y H$   \(t$pHĀ   _   LH   H,
 H3H$   HB LB IKICH@D$@ICISISMCMCICu  HD$h H$   H3} HĘ   Wf/v f/v   Wf/v   H\$WH HH+1  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHBfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HKyHSHt
HHH
HB$H;Cu
   HyHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HxHSHt
HHH
HJ$H;Cu
   HxHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H6xHSHt
HHH
HB$H;Ku
   H
xHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HwHSHt
HHH
HB&H;Cu
   HwHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w)  HSIkI^IFhMFxHINhP8MHINh&HHM:HUH   )HUHM0HUH   
IFhLHUINhP(HM-HE HMHM(HULL+tH HM,HEHMHMHULL+t	H IN(,HD$xIN(HMIV LL+t	H¢ EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      D D D% D- H}WD$hHt3J H,HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM" DUI   ?fA/  HEH;   HcuH;st$HKI tH'+HCHC    Hs~LEN    HUHK EC(Hcu H;s t$HKI tH*HCHC    Hs ~LE N    HUHK軠 HcuHH;s8t$HK0@I tH|*HC0HC0    Hs8~LEN    HUHK0i Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I+  HEH;  HSHMC(EHSHMmHM   H   H;t=HKH   H   C(HKH   +HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I*  H   H;t=HSH   C(   HSH   H   HS0s@  A   uf/w!(\֞ (I   mf/v=H   HM8'   EXH   HMH
H   HM`f/v\(8X(\(#(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$hE A   A9   HL$hsE Hx  D$`A   fn}^HE0H;t1HKHU82EXC(HKHUHHK0HU`s(HINhXA   AV0W IV(HDHL$xD HMD HM D HMD H   D H   D H   D HM`|D HMHrD HM8hD H   ZD H   MD H   @D HM5D HM+D HM!D HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQHC ICHp9 ICAC   IKH_ HD$(HxA HD$PHD$xHcHH4 HDxHD$xHcHDt    H	 HL$( @SH0HD$ Hٹh   \t HD$@HSH.  HHtH@PHcHHBPHH0[@SH0HD$ HH^ HH@ HA(HAPHcPHB4 HD
PHAPHcPDBDD
LH}) HHKA HA(HI0HtHP tHC0    HJ HHKH0[H%B @SH0HD$ HH) HH@ HA(HI0HtHP tHC0    HJ HHKH0[H%A @SVWH   HD$8H
 H3H$   IHHI @D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   Hv HL$@TuHD$x   HD$p    D$` A   Hwv HL$`%uHD$@HD$ LL$`LHHwYH$   H3n HĐ   _^[HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  Di fA/  HGPLG`HHOPP8MHHOP5H}(HGHLd$ _xLGPHHOHHWEPHHEPH#H      D H;vA(\ Z D(ȃ   f/GLcDE D  HD$pH;t2HKHT$x舻EC(HKHUqHK0HUdHGPLG`HHOPP8MHHOPCHsHt$8H~ u(HHD$PHD$0HD$`HL$H7 (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$HM7 AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$xEC(HKHUHK0HU   HF HD$03HD$8HD$@H2 HD$HD$PHT$8HL$H= Hq6 HD$0H	 HL$0Q~ H+F HD$03HD$8HD$@H HD$HD$PHT$8HL$H< H6 HD$0H6	 HL$0} HMA= HM7= HL$x,= L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PHkY HA@Hp2 HAPD$P   Ho' HHOH. HHG@HcPH/ HD:@HG@HcPDBDD:<HSHHDgHH\$HHt$XH0_H(| T f/0 w* T f/ w H
 H(H H
o a? H H
o M? H(
   Tp f/ w2
   TJ f/ wH
 H(He x3  HX k3  HL$H( LD$0HT$8 T f/! v;  "   3 LD$0HT$8T f/ v;  "    LD$0HT$8T f/ vq;  "   Hd
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H(H_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH6HSHt7HHH
HCH\$0H _H;CuH6HKHtHHHCH\$0H _H\$WH H\t
  Hn HH\$0H _H\$WH HW. HHH5 HA`HIH8 HO88 HO 8 HO8 H5+ Ht
   Hn HH\$0H _H\$WH H<t
  Hm HH\$0H _H\$WH H! HHH`T HAhHIH*8 HO8 8 HO 8 HO8 Hu* Ht
   HPm HH\$0H _H\$WH HLt
  Hm HH\$0H _H\$WH H" HHH04 HA`HIHj7 HO8`7 HO V7 HOL7 H) Ht
   Hl HH\$0H _H\$WH H|t
  HRl HH\$0H _H\$WH H2 HHHR HAhHIH6 HO86 HO 6 HO6 H( Ht
   Hk HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PHR HA@H+ HAPD$P   H  HHOH5 HHG@HcPH$ HD:@HG@HcPDBDD:<HSHHDq`HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt32 H;HEH]WEHt32 HHEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軻(HMf1 HM[1 (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9HxYe \
 Y   X Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`f   EWfA.z  D
+ fA/  HG`LGpHHO`P8MHHO`s(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      D H;vA(\f  D(   f/GHcD% HD$`H;t3HKHT$h2EC(HKHT$xHK0HU
HG`LGpHHO`P8MHHO`s(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$hEC(HKHT$xHK0HU   Ho6 HD$H3HD$PHD$XHt HD$8D$@HT$PHL$8- H^& HD$HHz	 HL$H>n H6 HD$H3HD$PHD$XHs HD$8D$@HT$PHL$8, H& HD$HH#	 HL$Hm HM.- HL$x#- HL$h- L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pH
 H3H$P  HHHL$0b3   Hm HL$@H(* H$0  HL$01LHHAPH$H  HrUHH$0  H=   r<t, HAH;r, H+Hs, H'v, H9a H$   K1H$   * H$P  H3Y H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\ΏH(  X \(赏XH(   Wf/vH0   Xj (躁 H0  X  H;t/HSHNHC(HF(HSHNHS0HN0LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h*) HHEHsH   HCH;t'H;tH) Ht
H<
HH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$hۦ  H       D  HY(WEHt3D( H	HEH] = } H  H[WEHt3( HG	HHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hgh    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt3& HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMg H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(̊(Xu \蹊(XuuHUH(  H蹟Ef/w"\| (H   HxNf/vHE0H;tHU0H3WEH]HHt3$ H/LHEH]LEHuHEHEHEHEH;t-I$ HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   +HM\# HMQ# HM`F# HMH<# HM82# HM'# HM# L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9H݌Y% \ Y   X Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH	 H3HELHHyHHL$@#   EWfA.z\  D
 fA/H  HFhLFxHHNhP8MHHNh贌w(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      Dt H;vA(D\ x (   fD/GLcD fHD$@H;t5HOHT$HD$hG(HOHT$XϜHO0HT$pHFhLFxHHNhP8MHHNh蠋LGI@H_@HEDELEH]LEHEHEHUHM  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM軟  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H[D$hG(HOHT$XBHO0HT$p4   H' HE3HEHEHse HD$0D$8HUHL$0Z H HEHи	 HM_ Ho' HE3HEHEHd HD$0D$8HUHL$0	 Hb HEH	 HMD_ HL$p HL$X HL$Ht HMH3PL L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pH	 H3H$P  HHHL$0$   HR_ HL$@XH( H$0  HL$0"LHHAPH$H  HrUHH$0  H=   r<tW HAH;rG H+Hs7 H'v* HR H$   "H$    H$P  H3J H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
W (  \f/   vƇ   \H(  f/v(\.H(  X \(XH(   Wf/vH0   Xʾ (s H0  X  H;t/HSHNoHC(HF(HSHNZHS0HN0MLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hR  HMHLHT$hP(HH   HHHHPHKHHHSHL$h HHEHsH   HCH;t'H;tHa Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h;  H       D  HY(WEHt3 HHEH] =| } H  H[WEHt3g HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hY    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0I}H  L@LEWEMt3 HMFHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMgX H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(,|(Xu \|(XuuHUH(  HEf/w"\n (H   H讀f/vHE0H;tHU0H蓤WEH]HHt3O HLHEH]LEHuHEHEHEHEH;t-I HtHOLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHMk LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHMo  LML   H   H   1HM HM HM` HMH HM8 HM HM| L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH; HAPH	 HA`D$P   H/ HHO(H HHGPHcPH_ HD:PHGPHcPDBDD:LHS(HHDa>HH\$HHt$XH0_HL$HH LL$P)t$0LD$X3)|$ 45< =t Tf/    LL$PLD$X3Tf/   a LL$PLD$X3Tf/   s LL$PLD$X3Tf/    LL$PLD$X3Tf/    LL$PLD$X3fTf/ws(t$0(|$ HHHW H
pF  H{W H
\F  HgW H
HF  HSW H
4F  H?W H
 F  H+W H
F  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	 Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@虏  IVHO   L\$`HI[Is I{(IA^H\$WH H
 HHA`HIH HO8 HO  HO H/ Ht
   H
F HH\$0H _H\$WH H, HHAhHIHt HO8j HO ` HOV H Ht
   HE HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	 Ht
H,HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@ɍ  H\$xHH$   H`_@SH0HD$     HHd  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH Ht
HHL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ U  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8 (fo IHFHMEHEUHMHME0HuMH] E H](M@fo
 fEPU`Mp Xf/FvFHHI;L$8  IHN 踕  ID~DHN0LN@HLF0A   HV 
  H$@  FDHAD~HH   A_A^_^]pUH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _ HH HH} H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMH HHEHE   HE    E A   Hs> HM>HE0   HE(    E ; uE3IIB< uHHM>HEP   HEH    E8 A   H HM8~>3fff     H}H;   H+H   HHuH}HCuHH   LǺ%   H	 HH   :
{ uH:
{ uH:
{ u3tH+HHHsHEH}HCEH+Ht+HD$    L
( A   HHM9H)IE3HUHM85BA   H\{ HM8@IHMXӪ  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   Hf HH    :E{ uC::{ uC:/{ u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM<8IIE3HUHM8@HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H_ H HD$0HT$0HM% HHL$`w Hأ	 HL$`|H HUAVAWHhH@  HD$XHXHpHx H	 H3HE8L= HLEHE   E3LuDuEF"H? HMU;HE0   Lu(DuEFH HM0;A@      H}H;   H+H   HHuH}HCuHH   LǺ%   HF HH    :ey uC:Zy uC:Oy uAtH+HHHsHEH}HCEH+Ht+HD$    L
C% A   HHM16H(IE3HUHM>A   HCy HM~=A? tI@ IC<7 uMIHMW=HEH}0HCEH
z HL$03HL$8HL$@HD$HD$PHT$8HL$H H HD$0HT$0HM] HHL$` H	 HL$`4F @SH0W)t$ f/Ȼ   (vW5M (\ m (,t
Xʃ\
(\(f/
 v\(Y
 (\ fnY(t$ YH0[Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v((\ W   fD.z  f.zv  D)T$ Dާ fA/L  D
 fA/r4D ff     AX([ fA/XsD(E\
 eH%X      HЋ9n
   X5 A(AYAY((Yd
 (Ya
 Y

 X9
 X9
 X
 YYYX
 X
 X
 AYYYXأ
 X
 X(Y
 AYX
 YXp
 YXX
P
 ^YY5x X  D. fD/v(Z E(\D(AX܍
 eH%X   / f/ƹ   HЋ   9
 h  A(A(AYAY((Yͤ
 (Yʤ
 Y
Z
 X
 X
 X
2
 YYYXn
 Xn
 X
 AYYYXA
 X
Ѧ
 X(Y
 XҦ
 YX
 AYX^YY% X   9
 )  EYDW A(AY((YL
 (Y9
 Y
љ
 X!
 X
 X
 YYYX
 X
}
 AYYX(Y}
 X
M
 X
 XU
 YX9
 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
R
 0 =F
 () H
2
 (
 
 ( .
  .
 ( 
 
 (
1 )
 (s )
 (
U )
 )
 / UH
 0 =
 (ͮ H
z
 (
 (
 ( :
 z :
 ( 

 (
թ 
  
w
 (
x 
 
 0/ H
L
 / =@
 ( H
,
 (
! 
 ( 
 ( 
ޠ
 (
w `
  
A
 (
Z b
 
K
 . IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
 A(.  PV f.zu   !     _ f/   (LW Hh((Y(T
O fD/vlY
  f/vVfA.zu3(H       $   H$      E fn "   Y) S   ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ U f.(   u~
 f/vpH      $   H$   H#H;  fA/s(T (f/C   
 f/  ,H Y<Z  t f/v: f/v =
  "   D^D\
 AY  H$   W`D> D(DX
 YE\A(T 
7 Yf/   AYf/wBAYA(\5Ş (S (A(S a (^^Yf/vvfA.zu3*H       $   H$      EË fn "   Y (A\A((XS (A(4S ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   H@ H
2 j L$   H@ H
3B N H\$D$WH`)t$PI)|$@H(D)D$0G f/ro(R f.z  (m(Wf/˨ WvWk LR D(E3(LHqD\(*R D\   f/vfWf.z0  U (
r Tf/vQ D(DW@    c ^\ TQ D(    f/v$((\z \
" (
  D(of/= r!b f/v(d  UQ D(DHL$p/^@Q D((X˝ \3 $Q \ \= YDXH\$xA(D(D$0(t$P(|$@H`_LD$pHr H
K   LD$pHɢ H
2   H(Y LL$0LD$83(T
 f/
! w
Y H(H> H
, o  H(Y LL$0LD$8胯(T
 f/
 w
Y' H(H= H
,   H\$D$WH`)t$PI)|$@HD)D$0(D^ D)L$ A(EWfD/   O f.zZ  ĝ f/ru(LW H((fY(T
 fD/vY
 a f/  _ ^fA.    A(  fD/v ff     ^AXfD/wt$p(N f.(   u~ӛ f/vpH      $   H$   H#H;  fA/s(}N (f/   
Ɯ f/x  ,H Y<   = f/v*Ǘ f/Z  D^D\o AY   HL$p3ZD
 D(DX YE\A(M 
 Yf/vVAYf/  AYA(\5 (M (A(M = (^^Yf/v&   A\A((M (A(`M ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pH H
O R  Hb H
;   LD$pH: H
- u| LD$pH: H
A< \| H, H
   Hh H
   H H
͞   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3 HHD$(Hl$0HT$(H茞  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"HX Ht
HHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H@ Ht
H{HH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;t;HtHHHH;t;HHHHGH;t"H Ht
H$HH    H_H_HHL$8 HL$( H$   H`A_A^A]A\_^]@SH Hbz  HH [@SH0HD$     zy  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIM7MwMwLuI誓HHoWD$@HD$P    E3E3HT$@H躜L\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uHHHF)L;t$HV. HHVHªH~H$`  H$P  HHHI$I$H;uIT$H;uHGI$ID$'H;t"LIT$. HIT$HI\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W-J 3MtlA(Y5א (Y=̐ D(D\D
B D HfE/v((+ AYA((X IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  袰LLD$XHT$pp*HH
L;   IH   IWըMIOI+H*HHHH?HH;v
 HRHH=   r=At I@I;r L+Is I'v LI/" I?IIHIHCIGHCIGH;H{H{HL$pH   HT$xH$   LD$pI+H*HHHH?HH;v= HRHH=   r=At  I@I;r L+Is  I'v LI_! H$   HtwH$   H+HH?H;v H    H=   r<t HAH;r H+Hsy H'vl H  HL$XHttHD$hH+HHH;v7 H    H=   r<t HAH;r H+Hs H'v H]  H   HT$HH&HD$PH+HHH;v HH=   r=@t HEH;r H+Hst H'vg HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]LWATAUAVAWHP  IǃPI[IsA)sA){E)CE)KE)SE)xE)hE)XH	 H3H$  HL= EWE(W$   Iǃ8    IMIǃ    Iǃ    H
HBH+HHueH Ip3IxIHv HD$0D$8IxHL$0 H H$  H H$  HǄ$     DD$   HBH+HHwiHc H$  3H$  H$  H HD$0D$8H$  HL$0 HF H$  Hw H$  :   H$  DID$   D$@E3LL$PMc}xIMt$M;v
H
/  IHL$@8LL$PE3HT$HLD$@M;  HFH+HH;riHr H$  3H$  H$  H HD$0D$8H$  HL$0 HU H$  H H$  IHHH$  H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
  HM+IIHIH+IE3I;LCL;ICHL$@7LL$PHT$HLD$@H   IH   I;usIH+HHscI+HIH+Hs
H
 
 HM+IIHIH+IE3I;LCL;ICHL$@7LL$PHT$HLD$@Ht2HHT$HIH$  xDX= AXD$0WD$X3H|$hIcE,HD$(Ht)I;v
H
 [ HHL$X6H|$hHD$(E3H\$`Ht$XL;  H$  (D$ HD$ H;   HD$ H;   Lt$ L+IH;utHH+HHsdH+HIH+Hs
H
9  HSH+HHHIH+HE3H;LCL;ICHL$X5H|$hH\$`Ht$XHt5JH,H;u   HL$XMH|$hH\$`Ht$XHt3HH\$`IHD$(!q
    HǄ$      E3L$  D$  ED$H H$  MHǄ$      L$  D$  ED$H8 H$  EExEyH$  H$  hCH$  zH$  lIcUxH$   ;IL$   IH$   H+HHt0LD  A<HL$   IH$   H+HH;rIL+IMt*f     <HH$   H+$   HH;ro
    HǄ$      L$  Ƅ$   A   H H$  HǄ$      L$  Ƅ$   A   H H$  EExAyH$  H$  BH$  *H$  AExHcHL$pILD$xIHT$pH+HHt.Lf     A<HLD$xIHT$pH+HH;rIL+IMt<HHD$xH+D$pHH;rn
    HǄ$      L$  Ƅ$   A   H H$  L$     HL$p謕DH$  *   D  A;]x0  n
    HǄ$@     L$8  Ƅ$(   A   Ho H$(  FHǄ$      L$  Ƅ$   A   H H$  HcL$(  HHL$pHL$  HHL$@ޔ0X6HǄ$      L$  Ƅ$   A   H H$  HcL$  HL$p舔0H$  H$  H$(     D%x      A;}x  l
 %   HǄ$`     L$X  Ƅ$H   A   H H$H  HǄ$      L$  Ƅ$   A   H H$  HǄ$      L$  Ƅ$   A   H H$  HcI   L$H  HmLL$  HHL$pUHHcL$  HL$p;^ A(\AA\YHǄ$@     L$8  Ƅ$(   A   H H$(  L$(  HH$   Β0H$(  MH$  ?H$  1H$H  #%k
 &   HǄ$`     L$X  Ƅ$H   A   Ht H$H  SL$H  HH$   :DXH$H  AAMx;}A;}j
 +   HǄ$@     L$8  Ƅ$(   A   Ht H$(  HǄ$`     L$X  Ƅ$H   A   HA H$H  EE(EyH$(  H$H  <H$H  H$(  IcU(H$  IL$  IH$  H+HHt+LA<HL$  IH$  H+HH;rIL+IMt(    <HH$  H+$  HH;rQi
 .   D$(   Dd$ LD$(HT$ H$   q  D$ HT$ H$   ii
 /   D$    Dd$(LD$ HT$(H$   +  D$ HT$ H$   #h
 0   Dd$ M   HT$ HL$@  D$ HT$ H$   h
 1   <~ D$(Dd$ LD$(HT$ HL$0E  D$ HT$ H$   ?h
 2   Dd$ M   HT$ HL$X  D$ HT$ H$   `   D$   D$   DN A;u(  g
 6   HǄ$     L$  Ƅ$   A   H H$  HǄ$     L$  Ƅ$   A   H H$  L$x  L$  E33H$h  A   H H$h  L$  L$   E33H$  A   H H$  SL$8  L$@  E33H$(  A   H
 H$(  HcIMHL$  HLL$  HI   HT$@HW;D(IM0L$h  H迍LL$  HI   H$   H;(I   L$(  HHT$XH:(AXA\EXAYAW0 AXA7^XL$X  L$`  E33H$H  fA   H H$H  L$H  HH$  0H$H  bH$(  TH$  FH$h  8H$  *H$  7e
 8   IM`LD$0H$  %  D$0HT$0H$   =H$  HtL$  L+I HT$pHt%L$   L+I WD$pL$   H$   Ht(L$   L+IZ W$   L$   HT$XHtLD$hL+I+ HT$@HtLD$PL+I Dl$0HT$0H$   eH$   V  (H$   HtL$   L+I(H$  H3! L$P  I[8Is@A(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHFHVH+HL$   I
3HFH+HH   $   D(DXL%HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;vu H    H=   r<tY HAH;rI H+Hs9 H'v, H
 L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHL"(W$   LKL+IL$   IIGMH$   HD$ MH$   I_HSH+HHL$PWD$8HD$H    LCHHL$83HKH+HHT$8H  L	5u HIL43 HBX LL$PMHT$8I43HCH+HHl$PHtvMH  YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8L'H -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;v H    H=   r<t HBH;r H+Hs H'v} HH HtmHD$`H+HH;vT H    H=   r=@t7 HEH;r' H+Hs H'v
 HHv (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  H	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@Z"HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
  HQM+IIHL+IHM;HCH;HCHL$@!HL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
x  HQM+IIHL+IHM;HCH;HCHL$@!HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   LFLL$`I{^  H$  H$   HXH$  DHtINHH$   PHt$hH\$`H~&Hfff     HHL$@bHcH;|IHHT$@PH$  H$  > H!H$  H$   HL$` HT$@HtLD$PL+IuH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HII3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  K  IIL$   H$   H$   L$   WD$xHt3! HaHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   J  HB H$   H$   荭H$   H$   H$   HT$xLL+t
H{# HT$xW$   H H$   LMH$   H$   H$   KLMHH$   2 D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^o Aƅ    A   " A   H$   KH$   I蹬IMHH$   PI Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5o L$   (A(5ML$   (A(!M(A(H$   QH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHw	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H9I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  F  II萗L$   H$   H$   L$   WD$xHt3 HQHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   E  H2 H$   H$   }H$   H$   H$   HT$xLL+t
Hk HT$xW$   H H$   LMH$   {H$   H$   ELMHH$    " D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^j Aƅ    A   y A   H$   	FH$   I	IMHH$   P9 Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5	j L$   (A(%HL$   (A(H(A(H$   LH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHg	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H)I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  A  IIL$   H$   H$   L$   WD$xHt3 HAHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   @  H" H$   H$   mH$   H$   H$   HT$xLL+t
H[ HT$xW$   H H$   LMH$   kH$   H$   @LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^e Aƅ    A   i A   H$   @H$   I虢IMHH$   P) Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5d L$   (A(CL$   (A(C(A(H$   GHս H$   H$   ׿  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHW	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I޾ Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  <  IIpL$   H$   H$   L$   WD$xHt3 H1HHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   ;  H H$   H$   ]H$   H$   H$   HT$xLL+t
HK HT$xW$   Hμ H$   LMH$   [H$   H$   ;LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^` Aƅ    A   Y A   H$   ;H$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5_ L$   (A(>L$   (A(=(A(H$   BHŸ H$   H$   Ǻ  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
"  HsHHCHHHHKLHT$`HL$X  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
y  HHHGHHH_LHT$`HL$X6  HGH\$hH@_@USVWAVAWHl$H   HEH	 H3HEIIHL
C
 eH%X      LE3B
9c
 ~^H
c
  =c
 uIH_
    L={_
 D=d_
 EGHId H
R_
 }H
֯  H
Ac
  HE   L}E A   Hd HM>LHUH
^
 JvHM谰HE   L}E A   Hc HMLHUH
^
   HMlHE   L}E A   Hc HM; oHE   L}E A   H HMHE   L}E A   H HMcHEHD$ LMLHUH
^
 BHMȯHE   L}E A   H#c HMHE   L}E A   Hc HMHE   L}E A   Hb HMHMJHM@HM6WeHEHEH}fnY ^HfnH\Y(YYX (\Y\eIHMG:  IHMH3 H   A_A^_^[]HUSVWATAUAVAWHhH   HD$0)p)xH֑	 H3HEMMHH
@
 eH%X      L3B
9_
 ~]H
_
  =_
 uHH]
    H]
 \
 DCHa H
\
 aH
  H
^
  HGH+H  W(HE   H]E A   Hla HMLHUH
|\
   HM}HE   H]E A   H8a HMMHUH
8\
   HM9HE   H]E A   Ha HMA$f/woHE   H]E A   H HMPHE   H]E A   Hz HM)HEHD$ LMMHUH
[
 pMHUH
y[
 HMzHE   H]E A   H]` HMHE   H]E A   HF` HMHE   H]E A   H7` HMvLOL+ILHUH
Z
 藸HMݫHMӫHMɫHGH+HA   I;IFEI;LGHHL$@1V A^$HMt{LA%` @ HcIQfAn\(T(Y\f.zuAf/AGfnYHL$@\HI;r(HHL$@4  HL$@d CH#[
 HHH[
 H;[
 r
   HHL$8HtWHHHHMH3 ($   ($   H   A_A^A]A\_^[]@USVWAVAWHl$H   HE)$   H	 H3HEIIHL
<
 eH%X      LE3B
98[
 ~^H
/[
 Z =#[
 uIHZ
    L=Z
 D=Z
 EGH	^ H
zZ
 5H
n q H
Z
  HE   L}E A   H] HMLHUH
'Z
 oHMhHE   L}E A   H] HMLHUH
Y
 ΢  HM$HE   L}E A   Hw] HMnWf/woHE   L}E A   H HM:HE   L}E A   Hd HMHEHD$ LMLHUH
7Y
 lHMxHE   L}E A   H\ HMHE   L}E A   H\ HMHE   L}E A   H\ HMtHMHMHMuHEHEH}mR ^HfnH\Y(YYQ (\Y\uIHM3  IHMH3 ($   H   A_A^_^[]@USVWATAUAVAWHl$H   HD$8)$   H	 H3HEIMLL
z9
 eH%X      L3B9T
 ~^H
T
 6 =T
 uIHU
    H=U
 @=hU
 DGHe[ H
VU
 H
: M H
uT
  ID$I+$H  H~   WHE   H}E A   H[ HMMHUd  HM*HE   H}E A   HZ HMtMHUH
T
 萟  HMHE   H}E A   HZ HM0LHUH
aT
 HM袥HE   H}E A   HZ HMHE   H}E A   HnZ HMHE   H}E A   H_Z HMHFHD$(H|$0MD$M+$ILD$ HT$(HL$0HHDHD$ L;HBHLMHUH
S
 臱LLHUH
vS
   HM跤HM譤HM裤IHL$@Mt$M+4$I   L;LFHVL;LFHMHHH]H9Nv3H
N @ fff     Hc(^HH;NrMtcI$&N fD  HcHIfAnE \Y(YY\YHD$@\HI;r(IHL$@-  HtLEL+IHHL$@ CHS
 HHHS
 H;S
 r
    HHL$ HtWHI?IHMH3 ($   H   A_A^A]A\_^[]HUSVWATAUAVAWHhH(  HD$8)p)xHF	 H3HEMMLH
95
 eH%X      L3B9[U
 ~^H
RU
  =FU
 uIH
T
    H=S
 @=S
 DGHW H
S
 H
  H
 U
 C IGI+H  IFI+H  WHE   H}E A   HMW HMlMHUH
]S
 ؗ  HMޡHE   H}E A   HW HM(MHUH
S
   HM蚡HE   H}E A   HV HMMHUw  HM]HE   H}E A   HV HMHE   H}E A   HV HMHE   H}E A   HV HMYH|$0MFM+ILD$ IWI+HHT$(HD$ LL$(I;ICHLMHUH
R
 ILMHUH
Q
 3HMyHMoHMeIHL$Ht$hHD$hHD$pLl$xM'I_I+HM>IFI+HH;HFظ   H;HFIE @=J ^  (Htt%I ff     HcAI\PY(Y\(Y\(YHD$HX(Y\HL$pXHH;r(HHL$@'  HL$Hڦ CHO
 HHHO
 H;|O
 r
   HHL$0HtWHH>HHMH3n ($  ($   H(  A_A^A]A\_^[]LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHNHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHH^HH|$`HHH0_^[H\$Ht$WH Ii/  HHX f@  Ht4HH3HC   Hs@3Hs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aqh  IB  H1H;>u=IP I  H$   HD$(LAII,h  I  H;uAH^HK I诛  H$   HD$(LE3IIg  I  IP Ir   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK ItCHCIIπx H$   HD$(tLE3(g  I   LAg  I   IHO 衚   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS I1t=HGIIπx H$   HD$(tLE3bf  I6LARf  I&H$   HD$ MHT$8I i  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I.,  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3HHs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Ai  IB  H1H;>u=IP I蕘  H$   HD$(LAIIi  I  H;uAH^HK IO  H$   HD$(LE3IIVi  I  IP I   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I藗tCHCIIπx H$   HD$(tLE3h  I   LAh  I   IHO A   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS Iіt=HGIIπx H$   HD$(tLE3g  I6LAg  I&H$   HD$ MHT$8Ipj  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HHH H|$`H HH\$XH0A^_^@WH0HD$ H\$XH4(  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@WH0HD$ H\$XH'  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSHG HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     ~HH0[HUVWHhH   HEHX)pH v	 H3HE'I(EM
$
 eH%X   A   H3A9A
 ~^H
A
  =A
 uIHRC
    H=CC
 @=,C
 DG
HI H
C
 H
  H
QA
  HE   H}E A   H HMFuH      HEH#H;upHE   H}E A   H HMHE   H}E A   H. HMHEHD$ LMLEHUH
PB
 KUHEHrPHHMH=   r<t~ HAH;rn H+Hs^ H'vQ H HE   H}E A   H HM:uHHEH#H;vpHE   H}E A   HQ HMHE   H}E A   H" HMHEHD$ LMLEHUH
DA
 ?THEHrPHHMH=   r<tr HAH;rb H+HsR H'vE H HE   H}E A   H HM.LEHUH
@
 HM蟏HE   H}E A   H HMLEHUH
i@
 DHMZHr
  YEXHM'H3 H$   ($   H   _^]HHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(DD A\D)xD)hD)XD)H(D)8ATD   f/  L   WD`8 D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXY8 ^A(\AY(Y\ fE/(vWC (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y56 A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"HP Ht
HuHH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@	 H   MMH
C?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"H Ht
HRtHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@ H   MMHAL|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HEZ(H   A] (YH   Xf/wXfA/sQH   (AT W? f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$H|$ ATAVAWH eH%X   HD

 I   LNB	98
   HII9H3H-7
 HLL%7
 HL=7
 H;1HLH0  HEHDL   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
6
 s =6
 H
5
 ~H
6
  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-D)@HDI, Ip     D)HI   D
g* D)PDQ* D)XEWD)d$@D%q+ D)l$0D-6 D)t$ D5;* )pغ   H  W4   H*AYff        Hc  WHH*X(AYH5rԺ   H7  WH*LcXEFLcAYB͠
 BYՠ
 f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zB
 Bՠ
 fA/B
 (\\YXr*((B\͠
 Y\YYX\(((B\͠
 Y\YYX\fD/&fD/w(YAYAWC f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=* H  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLL I^WD$(Ht3 HfLHD$(L|$(H\$03HcI;^}UI4HG.
 HHH9.
 H;*.
 r
   HH$   Ht
(>HILD$(H$   IM ;  H$   HCH$   HI~I;|$t!I$ HtH2fI$I4$I|$H      ?HCH=,
 H
,
 H9
,
 t	H,
  HH+~,
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|I1 s L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH 3H$   HH$   HH$   Hj H$   HLCL+H$   j A   E3H$   HL$0 HD$0HcHHD$0HȺ    HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQDuHL$0 u2HL$0  H$    HL$0 H$    2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H@  HD$(H;wH
H\$ H;vHH+HH=   HH*  H\$@Ht$HH0_@SH HHHSH
 H3H
HJHHC 3HC HC(HC0H~m C8HHj HCHH [@SH0HD$     
	  HH0[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$Xi  HL$8( 3($   H   [HIH% H%~ H\$WH Hc~ t
h   H HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    H'
 LHH'
 H
'
 H;rHLH'
 H
'
 HHH|'
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH&
 HH0H&
 H;&
 r
0   <HH\$`Ht!(HH-h HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    H&
 LHH&
 H;%
 rHqLH%
 HHH%
 H;%
 rHIHH%
 3LCIHI+HHt2f     I HIHLCI@I+ HH;rHw%
 3H9S~-L3ff     JH9HIHcH;C|HB%
 HH0H4%
 H;%%
 r
0   衼HH\$`Ht!(H9Hf HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHH$
 LHH$
 Hp$
 H;r   LH_$
 HP$
 HHHJ$
 H;r
   軻HHKHIHHH
!$
 HH0H
$
 H;
$
 r
0   耻HH\$PHt%(HHqe HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfoj( (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   ' II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %&' ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H n HAPD$P   OHc HHOH!x HHG@HcPH7g HD:@HG@HcPDBDD:<HSHHD豢HH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHw HAPH`m HA`D$P   H HHO(Hiu HHGPHcPHh HD:PHGPHcPDBDD:LHS(HHDHH\$HHt$XH0_H\$WH HH HHQ3HHHKHB?v H n HHCHGHC H\$0HG 3HG0HG8HG@H] GHHH"c HG(HH _H\$WH HHH;Qt>H	iv HtH]  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   E LHtHHHtHHIHHtHHIH [HL$H(O LD$0HT$8pzT# f/ wU LD$0HT$8HzTa# f/ wA LD$0HT$8 zT9# f/q w-H(H[ H
 x  HG H
 x  H3 H
| x  LVWATAWHh  HP	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  
8E3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XA	AX
	AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ _6L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3i Hh  A_A\_^HWH   H@HXHhHpIIHIPHHd3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`H3Hl$PH\$HH+HH;ntHp Ht
HQHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;vq H    H=   r<tp HAH;rp H+Hsp H'vp H6 HHtmHD$XH+HH;vp H    H=   r<t{p HCH;rkp H+Hs[p H'vNp HH躤 HL$`HtiHD$pH+HH;v p H    H=   r<tp HAH;ro H+Hso H'vo HF L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHt3Kn HOHHkHsC  IH!t  HH\$`Hl$hH0A^_^@USVWATAWH$H  HI	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  = WD f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HE  HE H  IH B<L;~  HH+HNHfoU T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
 foLu@MH  EhL  E   M  E  fo
 f      t  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&u  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfo IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   賴  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  ? LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3莑 H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     n  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  H>	 H3HExMHk HHEH HHEHE   HE    E 8 uE3IIB<  uHHM趕HE0   HE(    E ; uE3I IB< uHHMzHEP   HEH    E8 A   H( HM8O3@      H}H;   H+H   HHuH}HCuHH   LǺ%   Hf` HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
l A   HHMRH)IE3HUHM8A   H HM8蟗IHMXl  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H6_ HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8迗HE8H}PHCE8H
g HL$03HL$8HL$@HD$HD$PHT$8HL$H/^ H^ HD$0HT$0HMk  HHL$`Gl  H HL$`L @WH@  HD$(H$P  HHD$     HL$@>e   HL$0[ LD$PMcHHL$PIHPHL$Po\ HHL$@jcH$   cH$   \ HH$P  H@  _Hx)t$`( f/)|$PWD)D$@D(D)L$0D(v(8 W   fD.z  f.zv  D)T$ D  fA/L  D
 fA/r4D ff     AX(ɴ fA/XsD(E\	 eH%X      HЋ9b
   X5   A(AYAY((Yl	 (Yi	 Y
9	 XA	 XA	 X
	 YYYX
	 X
	 X
	 AYYYX	 X
	 X(Y	 AYX	 YX	 YXX
p	 ^YY5 X  D> fD/v(蕳 E(\D(AX	 eH%X   ? f/ƹ   HЋ   9s
 h  A(A(AYAY((YU	 (YR	 Y
b	 X*	 X*	 X
:	 YYYX	 X	 X
	 AYYYX	 X
	 X(Y	 X	 YX	 AYX^YY% X   9
 )  EYDW A(AY((Y	 (Y	 Y
	 X	 X	 X
	 YYYXm	 X
m	 AYYX(Ym	 X
=	 X5	 XE	 YX)	 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
F
 ɉ =:
 (9 H
&
 (
  $	 ( 6	  6	 ( 
	 (
A )	 ( )
	 (
e  )	 )
	 ވ UH

 - =
 ( H

 (
 	 ( 	  	 ( 
	 (
 	  
	 (
  	 
	 @ H
 
 菈 = 
 (  H
 
 (
1  j	 ( |	 (% 
^	 (
 P	  
1	 (
j R	 
;	 貇 IHHh  HD$X)p)x((Wf.zu(^ YT   f.z  f.
 z0u.(W ^((^YY5A (L  f/
 rT=x (^.  (f  HYSDJ J ȃw_Hܭ H(+g     (~h     ((^     (i     (     (j     H_ HD$03HD$8HD$@H HD$HD$PHT$8HL$HV HjJ HD$0HT$0H$   k  H
3 HH(H
 HH0@8B  HH$   -  HHL$`?  HX HL$` ($P  ($@  Hh  Ðͬ ڬ     HUVATAUAVAWHxHX  Li3ILLDM   
z HXH      ?HxI)p)x=M D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E     IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C螓  H;}&f        HE(f)HH;|LHMHd  LM@L  HH  HM`* MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL   转  MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@f  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMH!  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  x~  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH        @   @   H
tG HHxHHH\$PH0_HT$WH0HD$ H\$PHHH        @   @   H
t> HHxHHH\$PH0_@USVWAVHl$H   HE)$   H)	 H3HEIHHD	 eH%X      NE3B	9	 ~^H
{	 } =o	 uIH	    L5	 D5	 EFHM H
	 yH
"E 赂 H
)	 | HE   LuE A   H HM:LHUH
K	 ?HMEHE   LuE A   H HMLHUH
	 ?  HMhEHE   LuE A   H HM貀; oHE   LuE A   H HM膀HE   LuE A   H HM_HEHD$ LMLHUH
c	 >WHMDHE   LuE A   H' HMHE   LuE A   H HMHE   LuE A   H HMHMFDHM<DHM2Dfn5 ^ fn\Y	 WX\YY \(HMH33y ($   Hİ   A^_^[]HUVWAVAWHhH   HEHX )p)xH&	 H3HEMLHD	 eH%X      N3B	9c	 ~]H
Z	 z =N	 uHH!	    H	 	 DCH H
	 u~H
B  H
		 y HGH+H  WHE   H]E A   H HM"~LHUH
	   HMBHE   H]E A   HW HM}MHUH
?	 ;  HMPBHE   H]E A   H+ HM}Af/woHE   H]E A   H~ HMh}HE   H]E A   H~ HMA}HEHD$ LMMHUH
	 MHUH
	 wHMAHE   H]E A   H}  HM|HE   H]E A   Hf  HM|HE   H]E A   HW  HM|LOL+ILHUH
	 MHM@HM@HM@H7HGH+H   H;HFH;HGA=S ^谟 (HtOfAn	 % f     (X(\Hc\TY\HH;r(WHMH3u L$   I[HA(sA({IA_A^_^]HUSVWAVHhH   HE)p)xHM#	 H3HEIHHDB	 eH%X      NE3B	9	 ~^H
~	 v =r	 uIH	    L5	 D5	 EFH H
	 zH
a> | H
,	 Kv HE   LuE A   H HMzLHUH
z	 8HM?HE   LuE A   HN HMUzLHUH
6	 q8  HM>HE   LuE A   H" HMzWf/woHE   LuE A   HN{ HMyHE   LuE A   H{ HMyHEHD$ LMLHUH
	 %HM>HE   LuE A   H HMeyHE   LuE A   Ho HM>yHE   LuE A   H` HMyHM=HM=HM=5 ^z fn\Y
 	 X\YYT \(HMH3r ($   ($   H   A^_^[]HUVWATAUAVAWHhH   HEHX )p)xHD 	 H3HEMHHULHL$8D
0	 eH%X      N3B9v	 ~^H
m	 s =a	 uIH$	    H=	 @=	 DGH# H
	 wH
@; y H
	 :s IFI+H  I|$   WHE   H}E A   H HMhwMHUH
y	 1  HM;HE   H}E A   H HM$wLHUH
5	 @5  HM;HE   H}E A   Hq HMvMHUH
	 2HMR;HE   H}E A   H= HMvHE   H}E A   H& HMuvHE   H}E A   H HMNvID$HD$0H|$ MFM+ILD$(HT$0HL$ HHDHD$(L;HBHLMHUH
	 8GLMHUH
	 bs  HMh:HM^:HMT:I^I+H   H;HFIT$H;HFH\$(HM5IT$HM4HLmL}I9|$vOM4$IM+= Hc(A^B+Aؘ HH[I;t$rLmH\$(Lt$8HteMHEfnIII+5	 % D  HcA\YY(X(\1Y\HHH;rMtLEM+II iMtLEM+IIi(WHMH3cn L$   I[XA(sA({IA_A^A]A\_^]HUSVWATAVAWHhH   HE)p)xH		 H3HEMLHD	 eH%X      N3B	9	 ~^H
	 o =	 uIH	    H=	 @=l	 DGHq H
Z	 sH
6 t H
	 o HFH+H  IFI+H  WHE   H}E A   H HM1sLHUH
	 -  HM7HE   H}E A   H HMrMHUH
	 ٖ  HM_7HE   H}E A   H HMrA$f/woHE   H}E A   Hs HMvrHE   H}E A   Hs HMOrHEHD$ LMMHUH
	 HM6HE   H}E A   H HMqHE   H}E A   H HMqHE   H}E A   H HMqH}IVI+HHT$0HNH+HHL$8HD$0LD$8H;ICHLLHUH
&	 BLMHUH
	 BHM5HM5HM5L>H^I+HI6IFH+HH;HFظ   H;HFA$=  ^} (HtD	 o HcA\Y(X(\YY\HH;r(WHMH3wj ($   ($   H   A_A^A\_^[]@SH HALHH$I$IHH;r6H|$0H|$XHO@^HO 4H}q H
 9 H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtj uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK IZ/t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN V0Hm I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@HO /Hl H
| 4 H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMt蚋 uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK I*t3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN +HNh I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	1 Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@xIVHOKg  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ HŨ H+H= H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/La L+L
g L+A:tA:	uHr:IuL, L+L
2 L+    B:tB:	uHr@-tH      < @-tH        D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;tpHIHKH;tH& Ht
HHL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}fo% UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMQ  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHM#    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5d  ]    HG(Hx tL   LHH%a  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vkHHE HHuxL4    I   w2IFHHH;wHHHr H+HD$`HHHE 1I! HE HuMt3kHILuXE3L9?LDL  Lx  H  H    H=     I;vjHGHEHu`H    H   w2HCHHH;wHHH1r H+HD$`HHHEH  HEHuHtoj3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX= 5 MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  IHUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  HHHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  L  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} HHHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t    t	I H  H3F H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    Hc HuHuH\$ H(aa@SH Hb  H
 HCPH [HL$SH0HD$ HD$P    EtH4 HA@H
 HAPD$P   J   Hs HH HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK He HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H2 HH HHH\$PHt$XH0_@SH H  H HCPH [HL$SH0HD$ HD$P    EtHF3 HA@HK HAPD$P   J   H HH)
 HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK< H HH{3HHDH^H\$HH} HHOHKHtHPHGHCHGHCG C H" HH  HHH\$PHt$XH0_HIH%] H\$WH Hl  H HGPt
X   HJ HH\$0H _@WH0HD$ H\$@HH0
 HH HAHI HtHP tHC     HX HHK @t
@   HJ HH\$@H0_H\$WH H  HE
 HGPt
X   HI HH\$0H _@WH0HD$ H\$@HH HH HAHI HtHP tHC     H HHK @t
@   HHI HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJHHHFHGHHFLL+tj H_H\$HHNHHHFHCHVHFLL+tj HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$LWH   ICI[H: H3HD$xIHI HWf/w}IC   IC    D$8 A   HiG IKEHD$p   HD$h    D$X A   HG HL$XEHD$8HD$ LL$XLHH
	 *HL$xH3? H$   HĀ   _@UVWH   HD$8H$   HU H3H$   IHH3IIHH+HH   II      @      D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HF HL$@DHD$x   HD$p    D$` A   HE HL$`DHD$@HD$(HD$`HD$ LLHHX  H$   H3G> H$   HĐ   _^]HWH   H@HXHp H H3H$   IH3IIHH+HH   II      H@D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HD HL$@CHD$x   HD$p    D$` A   HD HL$`ZCHD$@HD$(HD$`HD$ LLHH
u	 PY  H$   H3= L$   I[Is(I_@UVWH   HD$8H$   H H3H$   IHH3IIHH+HH   I      fD  H@D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HC HL$@IBHD$x   HD$p    D$` A   HlC HL$`BHD$@HD$(HD$`HD$ LLHHX  H$   H3; H$   HĐ   _^]@SVWH   HD$8H H3H$   IHHfAn D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   HB HL$@MAHD$x   HD$p    D$` A   HpB HL$`AHD$@HD$ LL$`LHH H$   H3: HĐ   _^[3HIHtH   H LH   ICAC    HQHK) ICHP ICAC   IKKH HD$(H(  HD$@HD$hHcHH HDhHD$hHcHDd    H HL$(L @SH0HD$ HٹX   <= HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH7 HHm HAHA@HcPH2 HD
@HA@HcPDBDD
<H
 HH+
 HAHI HtHP tHC     H HHKH0[H%
 @SH0HD$ HH HH	 HAHI HtHP tHC     Ho HHKH0[H%
 LH   ICAC    HQH[' ICH`  ICAC   IKH HD$(Hp HD$@HD$hHcHH{ HDhHD$hHcHDd    H> HL$(J @SH0HD$ HٹX   L; HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HHW HH  HAHA@HcPH HD
@HA@HcPDBDD
<H HH; HAHI HtHP tHC     H HHKH0[H%
	 @SH0HD$ HHW HH HAHI HtHP tHC     H HHKH0[H% HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A   U H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH H HHt
   : HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH! HA@H HAPD$P   H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHD/HH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH+! HA@H0 HAPD$P   H HHOHA HHG@HcPHO HD:@HG@HcPDBDD:<HSHHD.HH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vLHHMHHumJ    H   w2HCHHH;wHHHS H+HL$`HHHM*H HHEHuHt*LH3H9HDHEXH   L   J    H=      M;vKLnMu_J    H   w.HCHHH;wHHH>S H+Ll$`IIH LHuHtKHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`H3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIL  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMX H   H3u- H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3 HSHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xe?  HIHD$hHD$p   INIHD$xH$   e D$0HT$ LL$hLD$xIV跿  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v%k HA    (|$@D(L$ H`[Ơ HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    v A    A   A((T T f/vOA^)t$P56 (YXT fE/
 vW^3YWs(t$PJD^A(AYX \T fD/ vW
D ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H, H3HE8Hv HHEL= HLEHE   E3LuDuD80uE
IIF84 uHHM/HE0   Lu(E A   HE HM/IH}H;   H+H   HHuH}HCuHH   LǺ%   H HH    :%x uC:x uC:x uAtH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHM*H(IE3HUHMt3A   Hw HM2A? tI@ IC<7 uMIHM1HEH}0HCEH
 HL$03HL$8HL$@HD$HD$PHT$8HL$H HH HD$0HT$0HM  HHL$`?  H HL$`: @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH	 Mt
IHL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH Mt
IRHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ vLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8s  (fo IHCHMEHEUHMHME0H]MH} E H}(M@fo
R fEPU`Mp;Xf/CvCHIH;HC m  H$0  HL$H  HADc$L$@  H   A_A]^[]5@/@@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4Cؑ  H;}. HD$8HHD$ (HD$ )HH;|LHL$PH蕑  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1H"HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@   HL$0 LD$PMcHHL$PIHPHL$P HHL$@JH$   lH$    HH$P  H@  _@SH HHHSH
A H3H
HJHH 3HC HC(HC0H C8HH HCHH [@SH0HD$     JQ  HH0[@SH HHHSH
 H3H
HJHHs 3HC HC(HC0H C8HHu HCHH [@SH0HD$     
P  HH0[H(((T
 f/
G v6f/
] rWf/   6 H(I \ H( f/v(H((Y((Y% (Y
ђ (Y X%F Yޒ X
. X^ YXJ YX% YX
 YYY\\\% X YY- ^X(H(H( H
 73Lw(DIDAf     A
 f/sffA;uDAP
 f/sffA;uDAHkAHARp HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DYn A(GG D
 (E(A(Y= A(»   EY(D(T
p f/
    A(AYF (A(Y%ő YXf;vM- (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_H3 H
^" QHHXWH   )pA)xfD)@(D)H(D)PD(D fD)X   D(D)`DYD((DYYE^Y DW
0 E Y= L$   L$   3D(DY(DY| פ((T
ڛ f/
    Yt WA^(Xf;v.ffnYA(EY\AYXf;rDY1 A(
E Y L$   I[(|$pE(CE(KE(SE([E(cYA(sI_Ha2 H
B! H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
 EYW=Κ (A\AYYY >D YWA(Y (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PY L@D)XD(ۢ(D(Tݙ f/    DYv )|$`D)D$PD A(A\EX(A( C E\Wf.EYD(DY* zt1AYAYY= A^(B AYYʍ D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxHP0 H
Q H   eH%X   
u	 )t$pWA   D)T$0D(HB9D	   fA/vDW fD.zuލ (t$pD(T$0HĈ   k fA/rfA(L$   AYH	 H
5	 $   w  %	 (Y%T A(	 AX\\
o	 Y  D)\$ Dw fE/rz8 L$   A(H	 AYH
	 Y
	 \$   /v  %?	 (Y%ċ A(H	 AX\\
g	 Y(  % E^)|$`A(D)D$PAYD)L$@f/   D((DY
}	 Y	 DX
d	 X	 DYYDX
B	 X	 DYYDX
 	 X	 DYYDX
	 X~	 DYYDX
܇	 X\	 D^   Ç	 (^D((DYfDX	 DYDXfDYDX	 DYDXfDYDX	 YfX	 YXfYX܌	 YXfYXD^f/   D((DYQ	 Yq	 DX8	 XX	 DYYDX	 X6	 DYYDX	 X	 DYYDXҌ	 X	 DYYDX	 XЈ	 D^   	 ^D((DYfDX	 DYDXfDYDXx	 DYDXfDYDXa	 YfX^	 YXfYXS	 YXfYXD^A(i> (A(9> (A(W> -q (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
	 . =	 g( H
	 (
 	 ( 	  
Ԉ	 (
Ւ 	 (֑ 
}	 (
 }	 ( 
}	 (
 )e	 (ސ )
g	 (
  )i	 (b )
k	 (
 )
	 ( )
	 (
Ȏ )	 (ڐ )
	 (
\ E	 ( 
G	 (
 I	 (B 
	 (
 	 ( 
	 (
h 	 (j 
	 (
, 	 (Ώ 
	 (
 	 I 
	 
 	 J 
"	 
 	 Z 
	 
* Ҍ	 5"|	 
	  rH   eH%X   
.o	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D%' B9	   fE.E(DTƑ zu	A(   fA/)|$prnA(L$   AYHE	 H
~	 $   q  %@	 (Y%} A(A(X	 \AY\
D	 YY9  D)T$@D fE/rnA(L$   AYH	 H
	 $   do  %܍	 (Y% A(A(Xa	 \AY\
	 YY   E^)$   A(AY$   A(C: (A(: (L$   H
~	 H
6	 p  (L$   (AYH	 XH
z	 Yo  \YXA(9 Y ($   D^AYD(T$@fE/vY= ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
	  =t	 (g H
`	 (
ɍ |	 (ۋ }	 $ 
|	 (
~ |	 ( 
	 (
 	 ( 
	 (
u )	 ( )
	 (
9 )	 ( )
	 (
- )	 (/ )
	 (
A )
	 ( )
	 (
Ő ~y	 (w 
y	 (
ɐ y	 ( 
	 (
= 	 (/ 
 	 (
 :	 ( 
<	 (
 >	 (7 
{	 (
) {	  
{	 
s ۆ	  
	 
 Ê	  
	 
[ Ê	 D}	 Dx	 D%P	 D	 D%v{	 
~	 5 D$H   eH%X   
j	 )|$`= A   HD)T$0D(B9	   WfA/	  fD.z(	  ؂ fA/)t$pD)D$P  A(E(^B	 EY6 (A(fA/X(Y^%    A(A(Ynw	 Yn	 XVw	 XV	 AYAYX4w	 X4	 AYAYXw	 X	 AYAYXv	 X	 AYAYXv	 X΃	 ^   v	 A^((YfXv	 YXfYXv	 YXfYXj	 YfXg	 YXfYX\	 YXfYX^	 A(Y \	 AX\	 YYX  f fA/   A(AY$   A(^	 4 (A((XL$   H~	 H
x	 Y^- ~j  %	 (Y%~ A(G	 AX\\
n	 YYX  D)\$ D fE/   A(AY$   A(^݄	 4 (A(T(XL$   Hz	 H
7	 Y^- h  %~	 (Y%+~ A(	 AX\\
	 YYX  E^D)L$@A(AYf/   D((DY
W	 YG{	 DX
>	 X.{	 DYYDX
	 X{	 DYYDX
~	 Xz	 DYYDX
~	 Xz	 DYYDX
~	 Xz	 D^   ~	 (^D((DYfDX~	 DYDXfDYDX{~	 DYDXfDYDX4z	 YfX1z	 YXfYX&z	 YXfYXD^f/   D((DY{	 Yw	 DX{	 Xw	 DYYDX{	 Xhw	 DYYDX^{	 XFw	 DYYDX<{	 X$w	 DYYDX{	 Xw	 D^   {	 ^D((DYfDXz	 DYDXfDYDXz	 DYDXfDYDXv	 YfXv	 YXfYXv	 YXfYXD^A(0 (A(0 (A(0 { (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
o	  =c	 R( (
 q	 ( "q	 (; ~	 (݈ 
p	 (
/ xs	 (! 
}	 (
S |s	 | 
}	 (
f ns	 ( 
@s	 (
i y	 ( 
y	 (
 )}	 ( 
y	 (
1 )}	 (s )
}	 (
 )>v	 ( )
}	 (
 )Bv	 ( )
$v	 (
 z	 (? )
(v	 (
q z	 (s 
z	 (
Ղ v	 ( 
v	 (
) Bx	 ( 
v	 (
} Fx	 ( 
(x	 (
A 
t	 y 
s	 (
 ~	 { 
s	 
z 	 x 
	 
5{ ~	 ]x 
	 
M{ 	 =}x	 
	 
M{ H
	 w 
	 ~	  L$   H} H
6 sHq
 H
" D$HxeH%X   
`	 )t$`W)|$P(A   HD)T$ Dx B9h	 >  f/~  dy f/D)D$@   (Y$   (^	 , (((XL$   Ho	 H
s	 Y^-x b  %{	 D(Y%w (L	 X\\
{	 Y^DYDX^  D)L$0D
.y fD/   (Y$   (^0{	 9, ((X(XL$   Hn	 H
m	 Y^-x j_  %|	 D(Y%^v (z	 X\\
{	 Y^DYDX   D^A(AY$   (+ ((~+ (L$   Hs	 H
z	 la  D(L$   (EYHt	 \H
r	 DY<a  XYD\(E+ Yw D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
}	 @ =}	 ( H
|	 (
 q	 (~ q	 x q	 ( 
p	 (
H ym	 (j 
[m	 (
} )l	 ( 
_m	 (
 )l	 x )
k	 (
~ l	 ( )
k	 (
f )l	 (h} )
l	 (
 )l	 (L )
l	 (
n p	 (P 
p	 (
 s	 (ā 
p	 (
 s	 (h} 
r	 (
} 3x	 (,~ 
x	 (
N| q	 (| 
x	 (
} q	 ;u 
q	 
u {	 Dv 
x	 
ls x	 Tv 
x	 
v y	 Dk	 Dk	 5o	 DQr	 5w	 D`q	 
x	   xL$   H H
8 nHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H)  HH   [A(f.-cs LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((Y^q Y
Vq (\f/s vYr H(((H(8  @SUVWH  HD$8H\ H3H$  IIHHM;H@  HL$@Ha HL$P;HHk HH	 ;HH ;HHs ~;HH4 o;H$  HL$@H$  H$  HC$  HǄ$X     3H$P  $@  8uDI     IB8uH$@  jHǄ$x     H$p  Ƅ$`   A   H H$`  3HGHD$0H$@  HD$ L$`  LD$0HHdH$  H3  Hĸ  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
  HMBLM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHM#LMHELEHtHHLMLEHEHHEHHcI;N}!H
  H
  WEHE    LMLEIIUSHMH   HEH+HH?H;v H    H=   r<ts HAH;rc H+HsS H'vF H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;r H+Hs H'v H4  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	~ Ht
H蹪HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@YGH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHHm6  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHH 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3 HHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM>  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HM7  L;}:@      HMHEBEffYfBXB)IL;|LHHM6  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIK%H$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLG[C  HL$h HL$p L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH  HC   HkH{rHH  HH#H H H;t%    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AI AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  (f I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@USVWATAUAVAWH$hH  HD$@H< H3H   MIHLL   H  HD$8E3D|$0H HD$PHM= D$0   E3E3HT$XHL$P HD$PHcHHՠ HDPHD$PHcHDxDDLAWHL$XHHL$PW(HH $HIV˴ HH #HU`HL$PHBD$0HU`H}xHCU`HEX   L}PD}@D8:tI    IB<: uMHM@
HD$8HD$ MLD$0HU@I{r@USVWATAUAVAWH$hH  HD$@H H3H   MMHLL   H  HD$83ۉ\$0H. HD$PHM D$0   E3E3HT$XHL$Px HD$PHcHHG HDPHD$PHcHDxDDLSHL$X8HHL$P&HH "HIV> HH o"HU`HL$PaHU`H}xHCU`HEX   H]P]@8t
HHÀ< uLHM@I$JHT$0HD$8HD$ MLD$0HU@ILD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H
  H HCPH [HL$SH0HD$ HD$P    EtHV HA@H[ HAPD$P   J   H HHQ HCHC@HcHH. HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHKL Hm HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H HH HHH\$PHt$XH0_@SH HHHSH
 H3H
HJHH HĔ HHH [H\$WH H\  H HGPt
X   Hg  HH\$0H _@WH0HD$ H\$@HH HH HAHI HtHP tHC     H8 HHKc @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$@UVWH   HD$8H$   HՃ H3H$   IHH3IIHH+HH   I      fD  D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   H HL$@MHD$x   HD$p    D$` A   Hp HL$`HD$@HD$(HD$`HD$ LLHHH$   H3  H$   HĐ   _^]HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HHo HH HAHI HtHP tHC     H_ HHKH0[H% LH   ICAC    HQHK ICHP ICAC   IK;H HD$(H@ HD$@HD$hHcHH HDhHD$hHcHDd    H8 HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPHb HD
@HA@HcPDBDD
<H} HH+ HAHI HtHP tHC     Hժ HHKH0[H% @SH0HD$ HH HHŠ HAHI HtHP tHC     Ho HHKH0[H% DD$HL$WH0HD$ H\$HHt$XHH3t$PHK HA@HP HAPD$P   OH HHOH) HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   HG HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHD!HH\$HHt$XH0_@WH0HD$ H\$@HH HHޞ HAHI HtHP tHC     H HHK @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHK HA@HP HAPD$P   ?H HHOHA HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upHz H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3g HHH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HMAwI_ HSHH;v9HHumH    H=   w9H   HHH;w
HHH H+HL$@HH$L<    I> HHuMtHCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
I˜ HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
e< f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CH;}D$`HD$Hf)HH;|LHL$ Hs	  (YX f/ArWLH AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
 H3H
HJHHs 3HC HC(HC0H C8HHU HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
; D)PD(D)XD(DYD)`E(D)l$ D((DYYE^Y=  Y=); L$   L$   3D(DY(DY: N((T
E f/
0=    Y: H+    ^; WA^(Y5: X    AYHDXA\EYAY(YXHuDY1= A(
 Y9 L$   A({E(CE(KE(SE([E(cD(l$ YA(sIH` H
A ̚HHXHpWH   )pH5)x3D)@WD)HD(D)PD(EY{
D)XD(D9 DYDYb< ff     A(Y3
 AX(AY Y3 H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
 H3H
HJHHc 3HC HC(HC0Hf C8HH] HCHH [%: (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-
D)@HDy5 Ip     D)HI   D
O5 D)PD	7 D)XD)d$PEWD)l$@E(D-8 D)t$0D5A D)|$ D=!5 )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcBհ	
 XY55 Y	
 f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/z
 	
 B
 Bհ	
 (\YX(\\Y\fD/v\(YX\fD/w(AWj f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5. MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  H{| HCPH [HL$SH0HD$ HD$P    EtH6 HA@H;| HAPD$P   J   H HHn HCHC@HcHHs HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH~ HHQ3HHBHK, H}y HH{3HHDH^H\$HHm HHOHKHtHPHGHCHGHCG C Hy HH HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE31H~ H|$HHS H+`HS8HOwHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3衹H~ H|$HHS HwHS8HOvHH\$PHt$XH0_H\$WH H,  Hy HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfo1 TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %1 II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   h0 ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQH{ ICHw ICAC   IKH< HD$(Hi HD$@HD$hHcHHn HDhHD$hHcHDd    HV HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH HH=i HAHA@HcPH
n HD
@HA@HcPDBDD
<Hu HH[ HAHI HtHP tHC     H HHKH0[H%* H\$Hl$VHA3'. HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PH{ HA@Ht HAPD$P   oHg HHOHq~ HHG@HcPHO HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@Hs HAPD$P   H HHOH9f HHG@HcPHk HD:@HG@HcPDBDD:<HSHHDQHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H"Y H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;v3HHMHHumJ    H   w2HCHHH;wHHH H+HL$`HHHM*H8| HHEHuHtH3H9HDHEXH   L   J    H=      M;vuLnMu_J    H   w.HCHHH;wHHH H+Ll$`IIH{ LHuHtHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`Hw:3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpI;HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   1>HH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H@y     t
HMX,y H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  HT H3HExMHR HHEH
S HHEHE   HE    E 8 uE3IIB<  uHHMfHE0   HE(    E ; uE3I IB< uHHM*HEP   HEH    E8 A   HR HM83@      H}H;   H+H   HHuH}HCuHH   LǺ%   Hw HH   :
 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHMH)IE3HUHM8赯A   H4 HM8OIHMXsLuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   Hu HH    : uC: uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHM輥IIE3HUHM8oHE8H}PHCE8H
B~ HL$03HL$8HL$@HD$HD$PHT$8HL$Ht H \ HD$0HT$0HM%HHL$`wH  HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[A# f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^A f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0H/M H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHH H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	IRp HM H3.  H]`HuhH}p(u0He@A_A^]Hp HHXHO菹艹HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3o HPHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$ m L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3Pm HNHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMkM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$ k L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D% HxEW@      IL$LkM4$Hfo HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D= HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  (膼 C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;trHIHt3] H?HLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  H8 H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   L   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;v IHU`HtLmH4    H   w.HFHHH;wIHHj H+Ll$`II*H'[ LHuHt譤HU`IHuX3HIDH   H  H  H    H=     M;v]HUhHtL_J    H   w.HCHHH;wIHH豫 H+Ld$`II HnZ LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   I3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   ILEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   UHIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
I:X    tH   #X HM`X HMhX H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKwLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH&4HL$@W HL$HL$   I[Is A(sI_H%V H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	5T Ht
Hp5HHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;tS Ht
H5HHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"HR Ht
H3HH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^覛DD$HL$WH0HD$ H\$HHt$XHH3t$PHn HA@HG HAPD$P   H_l HHOH: HHG@HcPH> HD:@HG@HcPDBDD:<HSHHD1|HH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     A AfYD HH;|Ld$PH;}3IGHp HhIL0 谙 YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"H> Ht
HHH    H|$0HsH\$8H ^ LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0Hs H3HE MLHAp AY1LIIM;vpH9HHuzJ    H=   w2J   HHH;wHHH%x H+H|$0HH8J    H& HHuHt`pHIHFE3EL96LDL}HEH    H=   @@uIM0I;vpMM(MufH    H=   w2H   HHH;wHHHdw H+LL$0II$H    H& LHuHtoIE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
I% @t	I% HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;tlIIHOH;tH" Ht
H9HH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}fo UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HM!    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$85b]    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht3  HHD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%n  @UHPHl$ HE H]@HuHH}PH2 H3HE HHLBHL;viL
MumJ    H=   w9J   HHH;w
HHHp H+LL$ II$J<    H LHuHt0iHC3H9;IDH    H=   LFHHN1   t	Hk HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5n MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDX(YLXA(YD
XX

A(YL
YDXA(YL
X(YDXXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+A((YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YX(YLXA(AYD XXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;t\HtHtIHHH;t[LLMt#3W ILHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;t|[HII;t$I HtHHEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHM/[HMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM HM HM H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$Iq HtHIE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CHNI;} D$XHEf)HI;|LHL$ INIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CLI;}D$XHEf)HI;|LHL$ ILMIIII+L;  L@MtHHIL;  IMIH/HWE3LL9G~L
 L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]yS@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH   L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   fo f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G3H;}%ff     EHD$@f)HH;|MHL$XHE3HEPLMe LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI  z LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5 )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4GF-H;}EHEf)HH;|MHL$PH-> L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;tz/HHHt3 HHHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3 H>HD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3Z HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$ N L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%HS Ht
H莿HL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfo IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI Hfo IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMI~ }    RL   L   IH!   H  A_A^[]#LWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK#H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLCqHL$hM HL$pB L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	H H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHH( H+HL$@HH	H HHH  AVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+HcAH+2HcAH+HcAH+HcAH+HPHcAH+2HcAH+tHcAH+H H?'HSHcAH+YHcAH+HPԴHcAH+HcAH+SHcAH+HHcAH+HP鴿H'HcAH+HcHcAH+HcAH+HcAH+HcAH+HP|PHSHcAH+T H[XH(WHcAH+`H7PH4H?HcAH+0YHcAH+H` WH(HcAH+HPĻH({6HcAH+RHcAH+HP\HcAH+HPlWHSHcAH+$ HcAH+HcAH+|H(sVH('H;HcAH+|HcAH+HP<%HcAH+HPHþHVH(6HWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtHxW HHXHjW H [%^ %P %B %4 %& % %
 % % % % % %> %0 ff     H;
 uHfuHS  H\$Ht$WH E3H
V   m  H
  HH   H H H HH H HH HHtnHtiHtdH%V  H
  H
yV H@ @   ?+HH3HH3H=aV HbV H
O   ^  H\$03Ht$8H _E3E33AQ HV Hu     ̹   {  H(H
U  H
U Ht H(@SH HH
U > # H
U v H [   @SH HH
dU  H H
QU O[ 3 eH%X   A   LЋ C H [h   @SH HH
U  ; u4d      ;teH%X   
Z A   Hȋ AH
T H [H% @SH H
T Hu0H H3T ?HH  H
T HH [Hl H
T H [H%a H\$Ht$WH 3H9=fT u8H% H3\T ?HH>  DHT H
-T Ӆ3H
S  H
T E3 H
S ~ H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
S u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
R H(%  Nu#  H(H(3%  H(  @SH R ɻ   DÈwR 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
Q u
  t2zH
Q a
  gHe I¹@   ?+ȰIL3LELEELEMQ LELEELE
Q MQ 
Q H\$PH@]ù     HLMZ  f9uyHcHH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuHP H [@SH =P  tu(  !  H [@SH H HًH3GP ?HHu
H  HH
'P   3ɅHDHH [H(HH(]  @SH H HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@=O  t
   r  O    tg	  H
	  5	  H
>	  P	  H
 H
 
  u)0t H H
 ]
  N    @2@N	  HH8 t$H2tHH?  Lƺ   IN    H\$0Ht$8H|$HH A^H\$Ht$WH @\N 3ۅ3PȉJN =@D$8=M t
   K  JM o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9M 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH H IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH% @SH H3 H  HȺ	 H [H% HL$H8   	  t   )H
L    HD$8HM HD$8HHM HwM HK HD$@HL K 	 K    K       Hk H
K H      Hk H
 HL    HkH
 HL H
U  H8@SVWH@H H   3E3HT$`H Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$  ǃ|H@_^[H\$UH$@H  ٹ     t)%$P  HM3A    HMA H   H  HE3/ Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 3 H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T    HD$PHD$@HEHD$H3 HL$@~ u
! O H$  H  ]@SH HHH
 HHS3H
HJHHl  H HHH [3HAH HAH| HHH= HH  H\$WH H HHH  t
   HHH\$0H _HHHL$ vHoZ HL$   HHHL$ ZHT HL$   H\$H|$UHH e 33    D    cAMDDDAentiAineIAntelEDDM AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
 A%?DiM = t(=` t!=p t wH     HsAD/M Eu  ` rADM    UDM;|$3E]MU]	sADL Asn̝    Ɲ    AsSAsL3H HHUHE$<u2     E  t n    l H\$83H|$@H ]̸   39\ H\$ UHH He H2-+  H
 H;uoHM HEHE H1Et HM H1E\ E HMH H3E H3EH3H  H#H3-+  H;HDH H\$HHH H ]H(uH=  u    H(H
qK H% H
aK   HeK HeK H(HHH(Hk H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH HN H5G H;Ht
HHH;rH\$0Ht$8H _% %D %ξ %о %ھ % % % % % % %@ %* %, % % % %Կ %ƿ % % % % % 33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D%uk D)xEWY5` fA.zuT=Ak D\   D)$P  (T$k (T
k D(f/D)$0  D)$  EYv
D(^^D((fE.D` zuA('YAX(y L   (H   AYfE.D($  z.u,fA/w	DCb (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0ȽL(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3@SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
n H9Ht6H HH [<    HuH
½ H2 H	¼ HH [@SH0HAH      t-H
@ LY3 LH   H	O u/HH0[H
K LH@LH3 HD$ H	 H+u
HCHP03H0[E3H;
 AAH;
6 H;
| AAuH% H\$WH HHHIH H;t6 u,LHT$0Hݻ HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H H\$8H _@SH H=2     HE D  C
HKt1{ t 0HSLCHMtE3  
HSH HKHHCHHt%M Huq H(H{ u3H [ÃH [H\$ UVWAVAWH   Hޒ H3H$  ILL, HH1  HW H/Hu
HWHR0H  I HH   HHb H.Hu
HVHR0H+u
HSHR0H   HG    |H
 H/ MMH	\ tHG H;vBHl$0L/ HD$(HL$@MLt$      E3HT$@3 x.HJtH
& H/ Hl$(MMHD$ H	 H/uHGH
H+u
HCHP03H$  H3mH$h  H   A_A^_^]@SH  HHuH [HH|$0ض H+Hu
HSHR0HH|$0H [H(  H H3H$  A   D$    L HL$4AQ  L*    LHL$0ú D$08D$4u%D$28D$6u3H$  H3{H(  HD$0   HD$(LL$4Hx- L- HD$ HL$@a A   HT$@3 H$  H3H(  H(He H
V' Hw Hp H K HuH? H(HH
 @  H> HuH(3H(H(=X     H
( z Hu13 H
6 H* A   H	( y/H(H   W    HHtH(uH@P0H
^*  Ht$HK   HtH(uHPHR03H() 3H(   H\$WH0H HH   LZ H+' H2    L= H$' H    LH!' H xoLH H' Hݵ xTLHD$     LH
{'    Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0HD H
 H& A   H	w yH/u
HGHP03HH\$@H0_@SH HQHLAMtI 3Al AhHA@HAHHA HA(HA0HA8HD$PHtH HAXMtIHD$XLIPHtH HA` HH [H\$Hl$Ht$H|$ AVH0H
; IH5H HH-E L5D ޵ HtHt$(MLHl$ HHH\$@Hl$HHt$PH|$XH0A^H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
 Hz$ H	 H(HAXHHD H H(LHt4HB      t$HIPHIPPHt
H)uHAP03H(H
 H# H	 H(HAPHHD H @SH yh H   Hl$0Ht$8H|$@Lt$H HHhPHpXLp`3HGPHGXHG`9ChuHt3H  HHu> HtHH 
H(uH@P0MLHHH  Lt$HH|$@Ht$8Hl$0H [@SH H H{8 t	H {h |H HA u H\ H$   HH [H%հ H [H\$WH H3HIHtH{H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _LI[WHP3HIC H( ICA   ICHICHIC ICEAICIC2 u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0yl HHYHHt!H
  Hi H	  3H0_][Ht$PHt  HHư t$xL I;t5HB    }      @t3Hg
  IH! tetaHH  H+u
HSHR0HOHHtHGH    H)uHAP0   3Hd  HHt$PH0_][   GlHHCH;5 u(HD$pHLL$hLD$`t$(HD$ H'  L   H; MtA^ HH   H+u
HCHP0H
 H	
 uHt$PGl3H0_][n HOHHtHGH    H)uHAP0Gl LD$hHHT$`
=  3Hp  HHu' H9XPuH
 E3E3HHHD  HHt$PH0_][HT$pHHt^ LL$hHLD$`HD$       H.Hu
HFHP0Gl H+u
HCHP0Hu7H  HHu'F H9hPuH
 E3E3HHH]C  HHt$PH0_][H\$WH yl HHYHt$H
: H H	Z 3H\$8H _HtIHHHt$0  HOHHtHGH    H)uHQR0H+u
HCHP0Ht$0uH
 H	o 3H  Ht4H(u
HPHR0H
 HZ H	 3H\$8H _ Ht*L HHX M H]	  #/ H H\$8H H H _@SH HHIH{l tH
 Hg H	 3H [Ht4ClHAH;2 u   Cl Hu!HH [  H HH [  H [H\$Hl$Ht$ AVH HD2 3HLH9BuHHH      AlHHBH6 H|$0L   MtA HHu%H
; H	b u	H Ϩ '3Hb H/Hu
HGHP0HDH|$0AFl HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIH{l tH
^ H H	~ 3H [HtKClHAH;
1 u H; u   LHF6 q2  Cl HuDHP   H  HHu' H9XPuH
c E3E3HHH?  HH [H\$WH 3HHIHHD$0HtHGHH)uHAP0$ HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu'Ī H9XPuH
 E3E3HHH>  HH [H\$VH AhHHمu2Ht-H; t$H
̨ H5 H	̧ 3H\$8H ^Ãu"HtH
 H	% 3H\$8H ^H|$0
 H{  HtSHC0HtHHHGHtH HGHAHC LGhHWpHOxHGhHC(HGpHC0HGxLC HS(HK0DH   HGhHC HGpHC(HGxHC0HC HtH HC(HtH HC0HtH LClHHSH|$0Cl H\$8H ^HtH
 H	H%" H
 H H	H% H
A H H	H%` H\$WH HQ 3Hy(HY0HA HA(HA0HtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWAVAWHH HqP3HYXLHy`LHu0H]@H}HHAPHAXHA`HuGHtH/u
HGHP0H]@HtH+u
HCHP0H H H I  H L I;   HuHf H H\ H}HHu0jHKI;u	H[@H-      t<H{|	H[HH H H HM@H)uHAP0H}HHu0I@     H   HtH/u
HGHP0Hu0H.  HFH  HF    }      @t3H  IH H}HH]@Hu0u%LLHI:  H\$XH A_A^_^]LEHHU@HM0 HE@HHHQ HH;t2K u(LMHILE@HU0:  H\$XH A_A^_^]HMHHt
H)uHAP0HM0H)uHAP0HE@HX@HHM@H)uHAP0I3H\$XH A_A^_^]H\$HHYhLYpLQxHAhI HApIHAxHH\$MMH\$Ht$WH HHHQHH HHttL@A      u	H HG H9C t-H H
 LGH	\ H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
x H	 t H xHWLH xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _~   @ uHH0 uH\$0H _ø   H\$0H _LH;u   HA    }      @t3   H%ӣ E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
 AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL;8 AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H;Ң ø   Htfff     H   H;tHu3H; ø   H(HA      tiHQHHtVHtHHt0Hy H
 H H	 HH(H(H%̟ AIHHH(ËAH(3H(H\$0	HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,H7Hi H3H(ËAH(ËAH(H(H% H\$0MHHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(h h h h h h h h h H(HA      tEHAHHw,HW(j H3H(ËAH(ËAH(H(H%Ϝ H\$0mHHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(i i i i i i i i i H(HA      tEHAHHw,Hwk H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(îj j j j j j j j j H(HA      tEHAHHw,Hk H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(Îk k k |k uk k k k k H(HA      tEHAHHw,Hl H3H(ËAH(ËAH(H(H%/ H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(nl nl nl \l Ul fl nl nl nl H(HA      tTHQHHtAHt3HHyH
 H H	R H(H(H% AH(3H(H\$0HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,Hhn H3H(ËAH(ËAH(H(H% H\$0-HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(n n n m m n n n n H( H(H(n H(H(N H(H(. H(H( H(H( H(H( H(H( H(Ht$WAVAWH L=S' ALtx  tDADH\$@Hl$HEt8H-i  Ht,V  H  ;H  }HHD9Du
H\ H,MDƋI   HHtntHЋ  ƙ L% E3HHH HHtHȉp|ܗ HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH A_A^_H\$Hl$Ht$WH   HAIɋx HHtVtDLҵ HH
x r 	HG HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_HX# E3H
' E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$     h H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H=: HڋHuH    H  hHHH  @       H\$@Hl$HH _Ht$0Dŋ5 HϋLt$83  LcD;}'IH9luHHH)   HAP0} ;u.p@HHcH HHtX5m 5c Hd HcMI;~#HHHI+@ AHIAHuMƉ5# BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H= Ht/ H9   ; }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@UVWH H
" Q 3HtH" Hr H   LD$HH\$@HT$PHL$X( H
a" H! HAL   MtA? HHt,HΑ H=G HE=E H+uHCHP0HLD$HHT$PHL$X H\$@Hu%L
 HS! H
!  H _^]H[ EH _^]H\$WH HAHL   MtAp HHu.H
	 H	0 tH
e H LH	 HH\$0H _H\$Hl$VWAWH0333HLHu3u HH   HH
W Lt$P LHt~ޏ HHtp.   H
 < Ht<LD$    LIIe HHu7H
 H	E t# LD$     LII) HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^LI[IkVWAVH0HAP3ICIHAXMCICLHA`ISHi`HHiPIHiXIKICY H9nP   HD$PHt(HL$(H    HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHVhLH~pHH^xIHNhLFpHFxHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP03QHL$ I.H/H+Ht
H)uHAP0HL$(Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIPLH;u   Hu3HB      2   HA    }      @t3BH% H\$UH HjE3HH~HB H;|   IHL;|Ht$0H|$83H   HrfHH;   HC    }{      @toHX  Ht4L@3M~HH9tHHHI;|3H   H\$@H ]H     H   H;tHuH;h    	H u'HHH;O3Ht$0H|$8H\$@H ]ø   H\$WH LQhHypHYxHQhLApLIxMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _HAhHHApI HAxIHHtH I HtH IHtH H\$WH   H3HH9HHDG<p u#H H;HC8HC0H HC@H{FDK$AtPH
 H A   H	 H9;tH H9C@uH{@H H$   HĐ   _H$   HL$@  HS(HL$@  HtCH
 H;tbLCHK HH L
 HGIHD$0H5 H: LOHL$(Hj H
K HD$ H	 7H9{@uH~ HC@3H$   HĐ   _3HHAHp HA8HA0H~ HA@H9 tHs~ H9A@uHA@    H%Ό H\$HT$UVWH HHL"fHH}  At 3A< IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLOH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <9}4HÍv4p<0}H\$Hu,H
H H DH	 t*LHcHG(H H
 H	5 3H\$@H _^]H
 Hp AZ   H	 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]H cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]f }  ~ ~ }  }  ~ -}  ~ P~ }  ~  







































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtHd H
 H	D 3    t   LA       )   эB<       A<	  CDA0H<0|f<9}CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGH DHHH
 D@XH	    HGHcHLH
 MDHQ H	 gH
τ Hh DH	 JH
 H DH	~ 3+; uH eHCGGHG(   IHׄ H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
Ƀ LMHd H	 Ld$XH(A^[D8cGu+DAXHj H
 H	b Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
 H LH	a H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH{ LICHD$(IM HD$ GHuL
 LT H L? HL	AHDAP@  HD$(H LT$ MH
 H	 H8H(DA@1wVL
yHAt AX IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
* H H	 2H(  ) 0     7      H(DA@4wEH8xH8 $ H   H(ø   H(ø   H(ø   H(H
[ H H	+ 3H(އ           H(DA@4wEHhwH  H   H(ø   H(ø   H(ø   H(H
~ H H	[~ 3H(î   ̈ ֈ       H(DA@1wqL
vHA A I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
} H H	_} 3H(À      ҉      H(DA@4   L
uHA4 A I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
| H H	| 3H(H
m| H H	=| 3H(f      ֊        Hs   L|tA  Ad IH# H H H H_ H Hg HC Hg Ho Hw ÅH
 H HEÅH
 H HEÅH
 H HEH H H H H H  Q   ʋ ڋ 9 A  1        ҋ I  Y  	

DH H
&z H	H%y @SH HDA@<	w<BHA؃0<0|<9}H[X<0}HtH [ÃHH H
y D H	vy H [HDA@<	w7BHEA0<0|<9}GHE@F@<0}HAÃE3H> LJL{ HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=| Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJH HHHL$ H
Ny H	x 3H8fD  H   H;tHuH;z t   H8H\$Ht$WH LAHIxpHt[H tTH#x MtI	HLv HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
x H M@H	3w H\$03Ht$8H _H(Hu H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H(u y,H(LH /   HHtH(uH@P03H(H\$WH HAIL   MtA w HHt,HH5   HH+u
HCHP0HH\$0H _H\$0H _H\$Hl$VWAVH0HA3H;u H   LqM   HYHHx H9Cu HT$(DFHT$ Lt$ H        v HH   IE3LpHHHHx H  Hm Hu
HUHR0H+u
HSHR0HEH;w H|$PuA   HT$P=  H;w uHA@tC    HHH\$XHl$`H0A^_^Ht$WH HA3H;is HtVH;t u+H;QDƋAHDtJHDH Ht$8H _HHhHt.HAHt%HHt$8H _HH;W΋HuHHH\$0ku HHtHHr H+Hu
HSHR0HH\$0Ht$8H _HGHt$8HH H _@SH HHu3H [H|$0Wr H+Hu
HSHR0HH|$0H [EH;uHYu H HOu HAH;3s uCLAIHH3H+HMtQ3ҋIEA;tHs H Hs H;r uAfAnf.zuzA   H%r H\$Ht$WH Hq 3HH΋H9CH9G5  C u
HAt xG u H.t yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM @ƋH\$8Ht$@H _Lq I;uUI;@ƅuJA   HH3q HHHoH+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HHp t/HD$8HH      tJE3LD$8HT$HHp uLL$8MtLH
q Lq H H	qp 3H [H
q LK Hd H	Kp 3H [ø   H [H\$Hl$Ht$ WH H3H
p IHL;u3H;Lt$0HMHDߋ      Ht:H7   MtHq I9@tH
p H H	o h  HHHHBr Ht(Or HH`H;tHHp`Ht
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHIn t   IMMHC      tHHӹ   @p 36o HHtuE3HHp H+Hu
HSHR0HtNLOHA      @H
o H LH	Un H H
o H	n Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4ISm   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@%cn HLL$pH8G `<`uHH@Iy( uI4n LL$pAA `<`uIAIA@H;u-HIH	.o ym H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$ 9l q3H\$`H0A_A^_^]HY@%Rm HLL$pHC `<`uH[H[@Iy( uI#m LL$pAA @t
 tIAIA@H;u)HIH	n ؅yl HuqLL$pt@HI;H H
l L$   H	fk H\$`H0A_A^_^]H H
l H L$   H	*k H\$`H0A_A^_^]LLH
;l H4 H	H%j HHLT$pH M;LT$0MLH
k MML
 IML
 Hp H	LDIHfx HDH HD$(L\$ gj HHH\$Hl$Ht$H|$ ATAVAWH Hm HL`PLpXLx`3HEPHEXHE`MtI$MtIMtIMMIH      gl Hk HMPHHuXH}`LePLuXL}`Ht
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
i i Hi H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAPHHAXI HA`I3HAPHAXHA`H\$WH LQPHyXHY`HQPLAXLI`MtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
{h H A   H	Eh H(H(   H\$UH j HHXPH   H
f LI;tCHK    }      @t3HIHxj uH\$@H ]3Ht$0HuXH|$8H}`HE`HEPHEXH+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HHm LL
t H
<g H5 LDH	H%g H
g H A   H	H%f @SH He 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H | ËH [Lf I;AuI;AuA   e HHu	H [HH|$00H+u
HSHR0H|$0H [@SH Iyf Huf Ht3H [HH H [@SH HHH
= d Ht	H H [HH [  HH;}HH33H%f LL$8E3HMtIH%c HAH;mg u
E33  H;g uHA@t3   HH E3  HT$H(HAH;g uA   HT$8  H(H;Vg uHA@t
   H(   H(H\$Ht$WH HH   d HHuH\$0Ht$8H _HE3HHxH#  H+Hu
HSHR0H\$0HHt$8H _H\$Ht$WH HAH@ Hpt3HYjf @ H HUf ;~#H
R 4e t3H\$0Ht$8H _HHH
f H؋   ~z<R	f H 9x }
e @$ Hu"Ld HuH
d Hy H	Pc Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Hud    je @ H HUe ;~H
 4d t3lLHHH
*e H   ~ZRe H 9X }
e @$ Hu"Wc HuH
c H H	[b HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyLLqHHY Icd @ DH Hod D;~H
 Mc t3    uL CuFHu9wuLMIH   |u%Ht LCHcGI;uHSMH   UfHU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ 
a HHc    ~YIc H 9X }
c @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHH,c E3LHHLb HHt\H~.Hx  fff     HHIH[H HCHAHu3H!b AF HH/u
HWHR0AN HH\$0Hl$8Ht$@H|$HH A^LH H
a H	H%_ HB      tHAL   MtIH%` H\$WH HH
l HHAL   MtA_ HHuH
` H LH	_ HH\$0H _H\$Ht$WH 3舦y'Hef H~      _  [  3_ H Hu'H*f HC      _     3H
d \ H\ Hu'He H     E _    3H
rd q` Hz Hu'He H =     _    艦y'Hve H 
     _  l    H
K \ H HuMH1e HJ      _  ^ H  H
(_ H H	] m  H\ H Hu'Hd H f    , _    H H
 H \ H Hu'Hd H      _  {  H
 [ Ha Hu'HEd H^      _  ;  L H H
 b] y'Hc H     \ _      y'Hc H f    , _    95 tFL H H
" \ y'Hc H      _  w  S[ HHu'HLc He      `  B  H} HZ HuBL H H[ y'Hb H     R `    h  y'Hb H \    " 	`      y'Hb H ,     `    H&R HY y'HZb Hs  E    `  P  H
 HL LH5R t[ y'Hb H*  E   n `    H HH HRY y'Ha H f   , `    H
8 H LH5H Z y'Ha H     `  |  H Hpd HX y'HDa H]  f    `  :  H H3 HH5\d ~X y'H` H  i   X `  
  H HeK HH53 5X y'H` H I    `  
  H H\5 HH5JK W y'Hi` H      !`  _
  A`  H5L5 H H~ H
G JH Hu'H'` H(  	   l +`  
  A`   Hp H
q H/ Hu'H_ H Z      ,`    AH
  Hƹ H
[r 貝Hk Hu'H_ H      -`  m  A0  H H
'r fH Hu'H3_ HD      .`  !  AP   H. H
v Hc Hu'H^ H v    < /`    A   Hw H
 ΜH Hu'H^ H * u   0`    y'Hc^ H|      5`  Y  g  u'H2^ HK  #    ?`  (  H
C 3HHu'H] H  &   R H`  
  H LH
 T yX &    J`  
  H+u
HCHP0H
 3{HHu'Ht] H  '    T`  j
  H LH
k uT y '    V`  
  H+u
HCHP0H
I 3HHu'H\ H  (   P ``  	  H LH
 S yV (    b`  	  H+u
HCHP0H
 3yHHu'Hr\ H 	 *    l`  h	  H LH
i sS y *    n`  	  H+u
HCHP0H
 3HHu'H[ H
  ,   N x`    H LH
 R yT ,    z`    H+u
HCHP0H
v 3wHHu'Hp[ H  -    `  f  Hi LH
g qR y -    `    H+u
HCHP0   R HHu'HZ H  .   O `    H HH HKH HH H HKH HAH
 HHu'H
Z H
  .    `  T  H+u
HCHP0H HHHu'H5Z HN  .    `    H LH
, 6Q y .   ^ `    H+u
HCHP0H" H:HHu'HY H J .    `    H LH
 P y .    `  B  H+u
HCHP0H/u
HGHP0   P HHu'H%Y H>  /    `    H& HH HOH HH H HOHu HAH2 H HOH$ HAH H HOH HAHP H HOHB HA H
' rHHu'HkX H  /    `  L  H/u
HGHP0H\ H褾HHu /    `    H, LH
" ,O y /   T `    H/u
HGHP0H` H0HHuN /    `  z  H0 LH
 N y /    `  F  H/u
HGHP0H H輽HHu /    `    H LH
: DN y /   l `    H/u
HGHP0H@ HHHHuf /   , `    H LH
 M y2 0    `  ^  H/u
HGHP0H HԼHHu /    `    H LH
R \M y 0    `    H/u
HGHP0H+u
HCHP0H
h HHu'HU H c 2   ) `    H@HH> L   MtAN HHu 2    `  I  H+u
HCHP0H E3HHHu'H5U HN  2    `    H/u
HGHP0H LH
 H#L y 2   K `    H+u
HCHP0L/ H
x+ 3`N HHu'HT H 0 o   `    H LH
 K y o   `  (  H+u
HCHP0L H
WQ 3M HHu'HT H)  r  m `    H1 LH
 K ys r  9 `     H+u
HCHP0J HHu'HS H .     a     L HH J y a  )H LH
g qJ     a      HS H/ H+u
HCHP0HtH/u
HGHP0H
s HH95 tDr H
 3tH
E H)uHQR0H51 HH\$0Ht$8H _H+u
HCHP0H H\$0Ht$8H _H(跏y w_  .   J H Hu x_     J H Hug y_      J H Hu> z_      sJ H| Hu {_      JJ H Hu |_  d3J H Hu }_  D   J Hp Hu ~_  !   tJ H Hu* _  HQ H      H(3H(H   H    J H( HuQ |   a^     H    hJ H Hu ~   l^    H    1J H Hu    w^    H    I H Hu   r ^  [  H    I H Huu   ; ^  $  H    I H- Hu> 3   ^    H    UI H Hu 5   ^    H
1H LHF H Hu f   ^  ~  H
G LHF H Hu f  ] ^  F  H    H H Hu` p  & ^    H    L
. L HX HD$(H HD$ QH Hb Hu y   ^    H    H H Hu 3   ^  {  H    G HD Hu 5  [ ^  D  H    G H Hu^ C  $ ^  
  H    uG H Hu-HM H      ^  HĘ   Hm    *G H Hu-H?M HP      ^  HĘ   H    F H  Hu-HL H    I 	_  HĘ   HO    F H Hu-HL H 8 7   _  HĘ   Hl    IF H" Hu-H^L Ho  ;   _  HĘ   H1    E H Hu-HL H$  O  h *_  HĘ   H    E H Hu-HK H W    5_  HĘ   Hk    hE H Hu-H}K H     @_  HĘ   H     E H Hu-H2K HC     I_  HĘ   H    D HS Hu 2   J T_  3  H    D H HHuJ o   __    H E3H HT$pD$ho  HD$`H HD$XHE HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    oA H Hu o   b_  h  H;    L
o L  H H$   H HD$xH HD$pH HD$hHv HD$`HZ HD$XH HD$PHJ HD$HH HD$@H HD$8Hf HD$0H2 HD$(HV HD$ #C H HHu k_     H E3H\ HT$pD$hr  HD$`EAHW HD$XH HD$PHD$HHL$@HD$8HD$0HT$(3D$    J@ H; Hu- n_  B r  HH H HĘ   3HĘ   H(H
 `H Hu*HEH H^      I^  H(H
{ H Hu*HH H  |  ` J^  H(H
) H Hu*HG H X W   K^  H(H
 H# Hu*HG H  _   L^  H(H
 XH Hu*H=G HV  =   M^  H(H
 H Hu    f N^  ZH
 H Hur 7  8 O^  ,H
 H+ Hu*D   
 P^  HF H H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H=? HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH  H
 H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   ; HH [3IA0  HHuH [@SH H= HHIHCH= H Ht
H)uHAP0Hu= HKHCHf= H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H-= HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtHP H
 H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
j H3HHCHCLCH   9 HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H; HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
j Hz  @ǅtHp H
D H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   (8 HH [3IA0  HHuH [@SH H9 HHIHCH9 H Ht
H)uHAP0H9 HKHCH9 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H}9 HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
n Hz  @ǅtH  H
H H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   6 HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _H7 H HIhH)uHAP0H7 HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _H7 H HI`H)uHAP0H6 HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _Ho6 H HIXH)uHAP0HT6 HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H5 H HIPH)uHAP0H5 HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _H/5 H HIHH)uHAP0H5 HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H4 H HI@H)uHAP0Ht4 HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _H3 H HI8H)uHAP0H3 HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _HO3 H HI0H)uHAP0H43 HC03H\$0H _HA0H HA0@SH HHt
H [O  H2 H HI(H)uHAP0H2 HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _H?2 H HI H)uHAP0H$2 HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _H1 H HIH)uHAP0H1 HC3H\$0H _HAH HAy  H\$WH HH1 HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H0 HHIHCH0 H Ht
H)uHAP0H0 HK HC Hv0 H Ht
H)uHAP0HZ0 HK(HC(HK0 H Ht
H)uHAP0H/0 HK0HC0H 0 H Ht
H)uHAP0H0 HK8HC8H/ H Ht
H)uHAP0H/ HK@HC@H/ H Ht
H)uHAP0H/ HKHHCHH/ H Ht
H)uHAP0H/ HKPHCPHt/ H Ht
H)uHAP0HX/ HKXHCXHI/ H Ht
H)uHAP0H-/ HK`HC`H/ H Ht
H)uHAP0H/ HKhHChH. H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu+   HH|$H- LD$0HT$8HL$@Q, HH{HtH  H^LD$0HT$8HL$@HP, HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  H.. E3H 8  HH	  H+ LHCHH+ HH H}+ HC Hr+ H Hh+ HC(H]+ H HS+ HC0HH+ H H>+ HC8H3+ H H)+ HC@H+ H H+ HCHH	+ H H* HCPH* H H* HCXH* H H* HC`H* H H* HChH* H =l y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [= HA* H HI`H)uHAP0H&* HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H) H HIXH)uHAP0H) HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H) H HIPH)uHAP0H( HCP3H\$0H _HAPH HAPH(Ht	H(? H
'( H} H	O( H(H(AH9( Hu;Hm/ H  X   ʰ     H
O AX   3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H' H HI@H)uHAP0H' HC@3H\$0H _HA@H HA@@SH HHt
H [A HQ' H HI8H)uHAP0H6' HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H& H HI0H)uHAP0H& HC03H\$0H _HA0H HA0H(Ht	H(B H
% Hx{ H	% H(H(A(% Hu;H- H6  T   z z  z  H
~K AT   裍3H(@SH HHt
H [XD H% H HI H)uHAP0H% HC 3H [HA H HA @SH HHt
H [xE H1% H HIH)uHAP0H% HC3H [HAH HAH(Ht	H(F H
W$ Hy H	$ H(F H(Ht	H(.G H
$ H8x H	/$ H(H(IL$0$ Hu;HK+ Hd  P    
  
  H
F AP   ы3H(H\$WH HHz$ HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH Hs# HHIHCHa# H Ht
H)uHAP0HE# HK HC H6# H Ht
H)uHAP0H# HK0HC0H# H Ht
H)uHAP0H" HK8HC8H" H Ht
H)uHAP0H" HK@HC@H" H Ht
H)uHAP0H" HKPHCPH" H Ht
H)uHAP0Hn" HKXHCXH_" H Ht
H)uHAP0HC" HK`HC`H4" H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAuL @  HH|$H^! LD$0HT$8HL$@ HH{hHtH  HpRLD$0HT$8HL$@H HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  H" E3H 8  HHuH(H{ HAHp H Hf HA H[ H HQ HA0HF H H< HA8H1 H H' HA@H H H HAPH H H HAXH H H HA`H H HH(H\$Hl$Ht$WAVAWH L3M HHu'H% H = =    `X     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHHy u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_K gX  
? eX  H$ H٬ W =   H/u
HGHP0HtH+u
HSHR0D+ H
Dr  )3tH\$Hl$VWAVH L3 HHu'H<$ HE ì =    ,X     In3I+.HHtafIL$HX HHtiHGH9G ~HHOHHHHOHH u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^ 3X  
 1X  Hv# H  =   H/u
HGHP0HtH+u
HSHR0Dѫ H
Rn  σ3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H; tgH; t^IH HHu/Hv" H A/   D W   H]_  H@L   MuSW    HLL Mu8H H9GuL;w1  HGJL;w  J\HIHAHHG  ILHt
H)uHQR0HHM]  HHEH;t?HUHtLEL+Ix.HH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPHK Hu`HUHMJHHMHUHLEL+I-     A0   W  f H   H
| LI;   HH    }      @t3HwIH? uZW  A/   H]H%  H. D y HtH/uHGHP0D W H
@m 苀&3 H/u
HGHP0HUIWH]MtIm uIEIP0HtlHEH+HH;v H    H=   r<tm HCH;r] H+HsM H'v@ HHIH]H   HUHbHMH+H*HHHH?HH
H;v HRHH=   r<t HCH;r H+Hs H'v HHIIL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H; toH; tfIHe LHu/H Hϥ A/   DJ KW   Hu  H@H   HEPHuMW  Hu  HLHHMPH]HuHu8HS I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H{EHui HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMz_L}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHM^L}H]HuHt;HH]HEP7A0   xW  H}@H?   H
C # H
C   H   H
N LI;   HH    }      @t3HWrIH udhW  H}@H?A/   H H Dw A MtI.uIFIP0DU  H
g S{8 I.u
IFIP0HUH}@HKL}HuH?MtIm uIEIP0HthL+IL;vC J    H=   r=@t& HFH;r H+Hs H'v HHeDHH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH;9 twH;h tnIH HHu3H H# A/   D V  c H]L}9  H@H   HEHuV  H]L}  HLHHMH]L}Hu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  H_BHE   HE    E HHMFHEHrDHHMH=   r0  HAH;  H+H  H'  HA H  HE   3H}@}IE3HUHMAHEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHM1iLuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHMhLuH]L}Ht*HC   H{H{rHHHU  HDH H]HMkHE        H
= % H
=  A0   	W  H}c HH   H< L I;   HA    }      @t	3Hl	I uZV  H}A/   H H Du ? HtH.uHFHP0DS  H
a Qu2 H.u
HFHP0HUH}HLuH]L}MtIm uIEIP0HMMtHIM+IMIz/HHMH3+7H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H;c
 8  H HHu     V    H@L   HEo    HAHHt[HEo   HAHHtEHAH΢yH
 H
 B V  UH+9  HCHP0*  H+u
HCHP03Тu	HMo賣H H  V      HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hn H
}
 H	T
 2Mx-H L
 ILDHPi H
I
 H	 
 ^    $ pV    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I$
 Ht V  eHHMQ  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+Im.O
 Ht@( V  N    H H D9  H
<] 7q   HUHMEHHUHMHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIuHUHtLEL+I-HUHtLEL+IHUHtLEL+IWELmHUHtLEL+IE-MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I-HUHtLEL+I7IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H; toH; tfIH5 LHu/H H A/   D U  ߏ Hu  H@H   HEPHuU  Hu  HLHHMPH]HuHu8H# I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HlEHu9 HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMJPL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMOL}H]HuHt;HH]HEP7A0   V  H}@H?   H
q4  H
c4   H   H
 LI;   HH    }      @t3H'cIH udV  H}@H?A/   H HƓ DG  MtI.uIFIP0D%  H
pV #l8 I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t  HFH;r  H+Hs  H'v  HH55HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
K H;E  H; 8  H HHu    H U    H@L   HEo    HAHHt[HEo   HAHHtEHAHnyH
	 H
  U  UH+9  HCHP0*  H+u
HCHP03pu	HMoSH4	 H=  U      HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Hd H
 H	  2Mx-HA L
 ILDH_ H
  H	      ĉ U    H;u
Hz HrHrH~H6HHE3LLHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+It%V Ht/ U  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+I
%  Ht@Ȉ U      HO HX Dُ  H
S g   HUHMHHUHMHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIeHUHtLEL+I<$HUHtLEL+I#$HUHtLEL+I
$WELmHUHtLEL+I#MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I#HUHtLEL+I#IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH;U toH; tfIH LHu/H6 H? A/   D U   Hu  H@H   HEPHu
U  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H1]HHEHHu HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHMIL}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHM%IL}H]HuHtH;HH]HEP1A0   5U  H}@H   H
+  H
*  H H   H
 LI;   HH    }      @t3HYIH{ ud%U  H}@HA/   HW H` D  MtI.uIFIP0D  H
L b8e I.u
IFIP0HUH}@HeL}HuHMtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hsp H'vc HH+HH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH; toH; tfIH/ HHu/H  H A/   D T  ف Lu  H@H   HEPHuT  Lu  HLHHMP= H]LuHu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0H H9GuwuHH (EHf.zu
 HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHMDL}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHMYDL}H]LuHt3HH]HEPA0   T  H}@H   H
>&  H
0&  { H   H
 LI;   HH    }      @t3HTIH udT  H}@HA/   H H D ~ HtH.uHFHP0D ~ H
}F ]8 H.u
HFHP0HUH}@HL}LuHMtIm uIEIP0MthM+IL;v J    H=   r=At IFI;r L+Is I'v LI'HH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is HI H3HD$hHHIK3t$ HA   HqHyrHH@0D$    HJH H;t- u#LD$(HT$0H x,HT$0LD$(LGLD$(MtHW(H{ Hu>H H     | \T  \T  A   H
G 
\   HD$`   Ht$XD$H HL$H[$HT$HHnHD$`HrQHHL$HH=   r<t HAH;r  H+Hs H'v HR%HHL$hH3L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3
 HHu'Hv H  =   { #T     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH9 u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_{ *T  
z (T  H H  =   H/u
HGHP0HtH+u
HSHR0D H
D z Y3tH(HyHQrH	 Hu;H H
  2   Qz S  S  H

C A2   zY3H(H\$Hl$Ht$H|$ AVH L3 HHu'H H  =   y R     In3I+.HHtgff     I HHtqHGH9G ~HHOHHHHOHHW u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^+y S  
y S  H H 7 =   H/u
HGHP0HtH+u
HSHR0D H
l@ x 	X3r@SUVWAUAVAWH 3H\$`H\$hH\$p> LLxhLppHhxMtIMtIHtHE 9   H H~ h   .x Q  H IMPL I;tUH  I@      t
I`*HA9   }      @t	3M	If    D~ H
: w VLL$pILD$hHT$`6^y~   ~w Q  [H~ E3H
s vHHuTw Q  'E33H~H+u
HCHP0+w Q  Q~   H H\$`Ht$hH|$pH} LMII`HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D} H
: v UH A_A^A]_^][MtI/u
IGIP0MtI.u
IFIP0HtHm u
HEHP0H A_A^A]_^][@SH H HH HIhH)uHAP0Hu HCh3H [@SH HS HH HIhH)uHAP0H5 HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH HS HH HI`H)uHAP0H5 HC`3H [@SH H HH HI`H)uHAP0H HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH H HH HIXH)uHAP0H HCX3H [@SH H HH HIXH)uHAP0H HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H HH HIPH)uHAP0H HCP3H [@SH H HH HIPH)uHAP0Hu HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH H HH HIHH)uHAP0Hu HCH3H [@SH HS HH HIHH)uHAP0H5 HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH HS HH HI@H)uHAP0H5 HC@3H [@SH H HH HI@H)uHAP0H HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H HH HI8H)uHAP0H HC83H [@SH H HH HI8H)uHAP0H HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH H HH HI0H)uHAP0H HC03H [@SH H HH HI0H)uHAP0Hu HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH H HH HI(H)uHAP0Hu HC(3H [@SH HS HH HI(H)uHAP0H5 HC(3H [H\$WH LJHL;
 HtrH; tiH
 L% MIHy1 H	P H Hr r   Fk E  E  H
1 A  oJH\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH H HH HI H)uHAP0H HC 3H [@SH H HH HI H)uHAP0H HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH H HH HIH)uHAP0H HC3H [@SH H HH HIH)uHAP0He HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HA@SVWAVAWH@H H3HD$8H=n LLHH
m 33d HHtH H_HH$   HHug fD    HV 3H9Au%HYHtHyHHH)uHAP0   H H9GufIGHT$(HD$(DEHHH+H\$ Lt$0?|HHu-g wD     H  H+  HCHP0   Me HHuH
v H
m f D  VHtHX3IGE3HH IGHDEIHLtzHHu~f D  H H-m m l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0Dem H
+ (f cE3#H.u
HVHR0H/u
HWHR0HH$   HL$8H3H@A_A^_^[H\$WH0L
 E3H;% HHRHA3I;At   KMuH
O H8B H	 +HBL^ H
 H,B MIHD$ H	2 3u/H
 H
k \l k  "e JD  3H\$@H0_HHH\$@H0_HUATAUAVAWHhH   HEHXHpHx Hf H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI֛HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+I33 HHu'H Hj #k h  c D  -  IM;<       HEH;tIE3HHMH IE3HUHM|HE   H}E IE3HUHMXHy HD$(HM3 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pc D  
b D  Hw j h  Hi H.u
HFHP0HtH/u
HGHP03Di b H
' ALHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v H;HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hso H'vb H
HE'   H}E MtzII葍M+IHL;v II   r=At IFI;r L+Is I'v LIB
IHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx HV H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIvHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+I3# HHu'H| Hf g c  _ C  -  IM;<       HEH;tIE3HHMH IE3HUHMlHE   H}E IE3HUHMHHi HD$(HM#
 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >p^ C  
^ C  Hg f c  Hve H.u
HFHP0HtH/u
HGHP03De ^ H
S# =LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v H+HE   H}E HE'HrPHHMH=   r<t HAH;ro H+Hs_ H'vR HHE'   H}E MtzII聉M+IHL;v
 II   r=At IFI;r L+Is I'v LI2IHM/H3L$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHIċHL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`'HL$hH+L$XHHHLI?LHT$XHT$(HL$@@HL$@趴Hu;H Hb c _  [ `C  `C  A_  H
  ;HH|$@Ht2HT$HH茅HL$PH+HHHLI?LHxH|$(Ht1HT$0HPHL$8H+HHHLI?LH<HL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHIDHL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`wHL$hH+L$XHHHLI?LHT$X_HT$(HL$@萤HL$@Hu;H H` ia Z  /Z C  C  AZ  H
 X9HH|$@Ht2HT$HH܃HL$PH+HHHLI?LHH|$(Ht1HT$0H蠃HL$8H+HHHLI?LHHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI膈HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU蟄LEHUL+I{3 HHu'H H%_ _ T  iX B  -  IM;<       HEH;tIE3HHMH IE3HUHM HE   H}E IE3HUHM H HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pW B  
vW B  H ^ T  H^ H.u
HFHP0HtH/u
HGHP03D`^ *W H
 ^6LHH.uHFHP0HEHrPHHMH=   r<ty HAH;ri H+HsY H'vL HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HQHE'   H}E MtzIIM+IHL;v II   r=At IFI;rs L+Isc I'vV LIIHM/H3CL$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H֤ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIƃHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU菀LEHUL+Ik3 HHu'H H[ [ O  YT FB  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >prS PB  
fS NB  H Z O  HY H.u
HFHP0HtH/u
HGHP03DPZ S H
 N2LHH.uHFHP0HEHrPHHMH=   r<ti HAH;rY H+HsI H'v< HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HAHE'   H}E MtzII~M+IHL;v II   r=Ats IFI;rc L+IsS I'vF LIIHM/H33L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx HƠ H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI薀HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU|LEHUL+I[3 HHu'H HW W J  IP A  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMH HD$(HM HHt[HNH9N ~H HFH<HAHFHHx u H/u
HGHP0I;ܿ    >pbO A  
VO A  H uV J  HU H.u
HFHP0HtH/u
HGHP03D@V 
O H
s >.LHH.uHFHP0HEHrPHHMH=   r<tY HAH;rI H+Hs9 H'v, HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v H1HE'   H}E MtzIIyM+IHL;v} II   r=Atc IFI;rS L+IsC I'v6 LIIHM/H3#L$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHH   HEH$   HE3ELeWELeLeXAAELe3 LHu T C  L CA  c  HFH;F tLH;u tCIH HHuL IA    H@L   MuUmL KA    HMMMu8H H9FuL;v  HFJL;v  J\HIHAHH   HMXH]XHt
H)uHQR0HCL   H,T HMtAi HH   E3HkR H_HHtgH+u
HSHR0IIOI9O ~HIGH<HAIGHIU uH/ HGHP0FK sA  |:K pA  p.K nA  a> H   H
 LI;   HH    }      @t3H IHq u}J fA  IHI Q C  HXQ I/u
IGIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Lu  B H.u
HFHP0MIHMHMH;t$HH]HHHMHHHML L`L`H]HMHtHUuLEHUL+I Ht$HR HkP P D  I A  aHUHM谩HUHM#HHM@HICȉMPO HuAP F  ^I A  H HO H]DuP ?I H
( s(LH]MtI.u
IFIP0HMXHtH)uHAP0HHttHUHtHEH+HH;ve HH=   r<tM HCH;r= H+Hs- H'v  HHH]HtsHUHVtHEH+HH;v HH=   r<tм HCH;r H+Hs H'v HHIH$   HĀ   A_A^A]A\_^]H\$Hl$Ht$H|$ AUAVAWH@HSP LHIHE333EFJHHu'H HN N :  ZG 5@    3H;= 3H;=  3H;= uHz ؅yBN :  G 7@  /  H/u
HGHP0  HtM H L5jM H3O IIFL   MtAM HHu'H. HGM M =  F L@  @  H/ L{I9l  HkH_  H{HHE HHH)uHAP0H LI9   IE0HT$ A   HD$(HHl$ [HHu0M =  E _@    Hm u
HEHP03H+u	IHP0   , HH   L =  3E y@        HHu'H
 H
$L L =  hE m@    HhE3IE0HH3H IE0HF PYHHu^L =  $E s@  :  H.7HFHP0(IU0H:WHHL =  D Y@    H
J E3HHxXHHuK =  3D ~@    H+u
HCHP0E33H?KH/u
HGHP0H 3HK K =  KD @    H?N A   IMHGHHu'H HJ @K >  D @    H؅yK >  C @    H/u
HGHP0   IM(L' I;uEH
 Lx H H	| H H.J J >  rC @  '  HnL THHu'H HI qJ >  7C @    3H;
 H(uH@P0  H"K H L5K HYK IIFL   MtAs HHu'HT HmI I @  B @  f  HU L{I9[  HsHN  H{HHHHH)uHAP0Hϻ LI9   IE0HT$0A   HD$8HHt$09WHHu'B @  3  H.u
HFHP03H+u	IHP0   ^ HH   I @  3A @  HU HnH H/   HGH      
 HHuA @     HpE3IE0HH3H IE0HE {UHHuYA @  hHm <HEHP0-IU0HqSHHA @  *H
JF E3HHxUHHuQ@ @  3H @  Hf HG HtH+u
HCHP0HtbHm u[HEHP0OH+u
HCHP0E33HMGH/u
HGHP0H HG G @  [@ @  HtH.u
HFHP0DoG H
 2@ mMtI.u
IVIR03
H} H H\$`Hl$hHt$pH|$xH@A_A^A]HUATAUAVAWHhH   HEHXHpHx HF H3HE/HHMWEE3LeELeEAAELeELeHE'   LeDe3g LHu'H HE WF 3  ? ?    Ls8IFH; t`H;ȵ tWHI LHuF 3  > ?  Z  H@L   Mu]E 3  > ?  1  IIܐMu8H$ I9FuI;^   IFH4I;^   ItHHIAHH   ILHt
H)uHQR0HFL   HoF HMtA HH   E3HF HRHH   H.u
HVHR03IOI9O ~HIGH<HAIGHI u$H/HGHP0E3A   D 3  q= ?  E3  D 3  U= ?  E3  sD 3  9= ?  E3  C HtfH
 LI;tQHH    }      @t3HIH~ uD 3  < ?  E3M   E3I.u
IFIP0ML}IHMjHMH;t$HH]HHHMHHHML L`L`H]HMHtHUGhLEHUL+I#U Ht'H HB PC 4  < ?     HUHR@HM耗HMH;t$H8H}HHHMHHHML L`L`H}HMHt5HUeHMH+MH*HHLI?LHU Ht'H H B B 4  d; ?  R  LEHUHM^F3f LHu'H HA VB 5  ; ?    H]H;]  HEH;tIE3HHMH HMH}'HCMHU) HH   ILHt
H)uHQR0HGL   HD HMtA  LH   E3HB@ HzNHHtwI.u
IFIP0MIOI9O ~HIGH<HAIGHI uH/u
HGHP0H;]  'A 5  9 ?  uA 5  9 ?  _9 ?  FHZ Hc@ @ 2   9 S  S  A2   H
] M9 ?  @ 5  IH H@ I/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0HtH/u
HGHP0LuH]H}D6@  9 H
 4MLuH]H}MtI.u
IFIP0MtIm uIEIP0HE'HrPHHMH=   r<t+ HAH;r H+Hs H'v HmHE'   LeE H   HUHbHMH+H*HHHH?HH
H;v HRHH=   r=@t| HGH;rl H+Hs\ H'vO HHHt~HUHcHEH+HHH;v HH=   r<t HCH;r H+Hs٫ H'v̫ HH8H]HtHUHcLEL+IHIHM/H3L$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`H> HAL   MtAޭ Hu;H´ H< Y= &  6 ?  ?  H
C A&  H3H({HAPH HAPHAPH HAPH\$WH0HIX37HHu?H H
E A   H< >  D< V5 3H\$@H0_H= H HHu\H A   >  H; D<< 5 H+uHCHP0D< 4 H
 3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHl$H   HEH$   LWEE3L}L}L}L}L}=HEL}L},HEAEL}wH=> HH
9  HHtH HKHHu;   3 =  =  HCL   H6 HMtAD HHu:   3 =    H+u
HCHP0HFL   H< HMtA HHu'Hϱ H9 f:   ,3 =    H.u
HFHP0ILcH I9$  HsH  H{HHHHH)uHAP0LgH2 I9$uSHuLmA   HUHGHHu9   2 =    H.u
HFHP0I      Ω LHu'H
߰ H
8 v9   <2 =    HpIIE Lh E3IH*FHHu89   1 =  e  I.u8IFIP0,IHDHHu8   1 =  '  H+u
I$HP0HGHh H;   H;     H HHuo1 =     H/u
HGHP0HFH   MHHMHtTA   HLHtAHH?y>8   1 =  k  L)&u
HFHP0I   H.u
HFHP0I?uIt@7   0 >    HOHtf~A   H H
 H	j 
Hx&@l0 =  H M7   H6 H/  HGH  H;u
Lw H_H_LsHHIH/u
HGHP0H]LuHHM' HHEH;tJHUHRHMHMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHM`HEH@HEH HEH@L}H}HyIHM- HHEH;tJHUHRHMHMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUHM@   DBoHM޵LMLEHUHMgHIufHHMHUHtLEL+IH
8 ?LHu'H
 H&5 5   j. ,>    H@L   H4 IMtAإ HHu'H H4 P5   . .>    I.u
IFIP0HMسLHu- 1>  C  ILcH I9$
  HsH   H{HHHHH)uHAP0LgH I9$uJHuLuA   HUHtBHHub- E>     H.=  HFHP0.      LHEwHu'H
 H
3 E4   - U>     HpILp ME3IH@HHu, [>  8Im    IEI   IH>HH   , >>  3   H H.3 HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0HMwHt
H)uHAP0DZ3 $, H
] X#I.u
IFIP0H+u
I$HP0LHMHt
H)uHAP0HMHtH)uHAP0LEMM HUwHM   DBoHM蝲LEMM HUwHM   DBoHMsHUHtLEL+IIH$   HĠ   A_A^A]A\_^]HSVWATAUAVAWH   H@HLW@E3LPD$XLt$hD$@Lt$PAAEL`LXH;$ tJHtEH(HD$0H$   $u]H H)1 1   m* <    L$   L$   H) H$   H$   L% L$   HH$   蒧HL$XH;t%HHL$XHHHL$`HHHL$hL0LpLpH$   HtL$   L+I Ht'HH Ha0 0   ) =    LD$XH$   IM^HL$@H;t%HHL$@HHHL$HHHHL$PL0LpLpH$   HtL$   L+IjHT$@H$   7L%H3 IH
.  HHtH I@HHu'Ht H/ 0   ( =    HCL   HZ/ HMtA? HHu'H  H9/ /   }( =  ]  H+u
HCHP0H$   ;HHu'HԦ H. k/   1( =  &  ILoHΞ I9E F  HwH9  LoHIE HIH)uHAP0IMH$h  H> H9urHt$pH\$xA   HT$pI<LHu'H- HF. .   ' 2=  j  H.u
HFHP0H+   HCH       LHu'H
ͥ H
- d.   *' B=  
  HpIHX E3II;LHu'H H- .   & H=     I/uUIGIIHH9LHu$H< HU- -   & +=  |H+uHCHP0P0L$h  H/u
IE HP0H$    \  H$   H
 H;IDH$   H$   O +  E3AAAEHtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0MtI/u
IGIP0H=p r HLxPL`XLh`LpPLpXLp`H$    t%H$   H;IDH$   H$    HKPHsXH{`L{PLcXLk`Ht
H)uHAP0HtH.u
HFHP0HtH/u
HGHP0DD, % H
 BMHT$@HtLD$PL+IHT$XHtLD$hL+IH$   HtL$   L+IIH   A_A^A]A\_^[H\$WH0LRHHh# HL;u   ^HuH
 H  H	u >It   -H
I L IBLJH  HD$ H	 3u/H
x H
* +   # <  3H\$@H0_HHH\$@H0_HHHAUH   HI* E3HXHhAHxAL`LLpHAL$   L$   Ll$ L   L$   MtAɚ H$   HL|$xHu'H H) 4*   " 	;    HCL{H; I   HsH   LsHHIIH)uHAP0IFM~H; Ht$(uA   HT$(I7+H;I uIF@t
HI5HI4LHu{)   A" ;    H.u
HFHP0IH+u	IHP0I.u
IFIP0ID$IH) L   MtsAtH;K uE33H61H; uHC@t3H4H& E3H5LHl(   ! ;     Hu'H H( (   O! &;    L5k+ H
& IH$    HHtH I8HHu4( 	    2;  f  HCHH& L   MtAh HHu' 	    4;     H+u
HCHP03 HHu'H H)' ' 	  m  7;    IL$(H;
̗ u0H
{ H$ H	{ i' 	  /  ;;    H+) ~ HHu<' 	    =;  n  H@IH;~ t_H; tVHM HHu& 	   C;  '  H@L   Mu%& 	   E;  
  HHMMH/uHGHP0Mu>H H9EuL;u   HEJ<HI)L;u   J|HIHAHHN  H$   H$   Ht
H)uHAP0H( Ha HH   HKH9K ~H HCH<HAHC:HH &% 	   k;    IHm u
HEHP0H# L~II9  HnH  LvHHE IIH)uHAP0H M~I9  A   Hl$(HT$(H\$0I3LHu{%% 	   ;  W  % 	   i;  >  ߕ H3HO HH<t $ 	   a;    Hm u
HEHP0IH+u
HCHP0H.u	IHP0H
r' L$   .HH   H H# I$ 
   ;       g HHu$ 	   ;  O  HhE3HHX II0LHu'H> HW# # 	   ;  *  H/,HGHHH.LH# 	  U z;  
  H@HH"" L   MtAÓ HHu'H H" ;# 
   ;  
  H.u
HFHP03 HHu'H] Hv" " 
   ;  ^
  H$   HI(H;
 u>H
 H H	 H
 H#" " 
  g ;  	  Hc$  HHu'Hϙ H! f" 
  , ;  	  H@H; t\H;ۑ tSH0 HHu&" 
   ;  X	  H@L   Mu%! 
   ;  /	  HHMMH+uHCHP0fMu>H$ H9EuL;e  HEJHI)L;e   J\HIHAHH   H$   H$   Ht
H)uHAP0Hz H HHtOHNH9N ~H HFHHAHF=HHˏ )! 
   ;  3  HC H\    
   ;  /   Ht H! HH   ` Hm u
HEHP0H LII9  HoH  LwHHE IIH)uHAP0H~ M~I9   A   Hl$8HT$8Ht$@I-LHuNHe H~  
   ;  Q  H> HW  
   ;  *  Hm u
HEHP0IH.u
HFHP0H/u	IHP0H
" Lt$ )HH   Hǖ H ^   $ <       | HHu'H H $ 
   <  y  HhE3Hp HIII+LHu 
   <    H+,HCHHH)LHH H  
  Y ;    H@HH! L   MtAǎ HHu'H H ?    <    H/u
HGHP0H L{II9  H{H  LsHHIIH)uHAP0H M~I9   L$   HT$HA   Ld$PIH|$Hv+LHu   IW 2<    H/u
HGHP0IH+u	IHP0IL$   MH)uHAP0H D9(z  H$    HH   Hk H     X<  l       HHu    @<    L$   E3HxHIII$L` )LHu   V F<    H.HFHP0L$   HIe'LH?   I ,<  n  I Hu'Ho H     Y<  p  H;t7H
 H	j H3 HL     \<  4  H
 %HHu'H H  
  U h<    H@HH L   MtAË HHu j<  {  H+u
HCHP0    HHu'Hr H 	 
   m<  ^  IL~H@IHL$ L0HHCHHHR I9  H~H  LvHHIIH)uHAP0HЌ M~I9&  A   H|$XHT$XH\$`I>(LHu, <    H/u
HGHP0H+u
HCHP0H.u	IHP0IMH$   L|$xL$   H$   H$   H$   H$   Ht
H)uHAP0MtI,$uID$IP0HL$ L$   Ht
H)uHAP0MtIm u
IEIP0H$   HtH(u
HPHR0IHİ   A]ù    HHu <  }HxE3HHX II
&LHu$Hv H 
 
   <  eHm HEHHH#LH <   
  H H) HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0HtHm u
HEHP0DU H
^  SL$   [HHPHHUH   H 3HXHxL`DLhDLpDLxDHAH$   Hl$pHl$XL   Hl$xH$   H$(  Hl$PMtA H$   HHu'H؎ H o   5 8    HGH$   HD$`H H;ņ 4  HWH$   H  HwHHHHH)uHAP0H$   HFH$   HD$`H H;" uA   H$   H$%H;a uHF@t
H"H"HHu'H H
    Q 9    H$   H)uHAP0H$   H/uHD$`HH P0H.Hu
HFHP03  HH       9    H;< uE33H#1H; uHG@t3H!H
 E3H"HHWH H     d 9    H$  HI(H;
 u0H
k H H	k Y    9    H n HHu,   
 9  c  H@H;r toH; tfHHD$h H$   Hu   
 9    H@H   HL$`Hu3   v
 !9  
  HLH$   H\$hHl$`H\$hLL$   H/uHGHP0    MuHH I9GuI;_  IGH<HHH\$h.I;_  I|HHH\$hIAHH  H$   LH$   Ht
H)uHAP0H
e HLH;  HHH H   IHt HH  I.u
IFIP0H I LH  H
V LHy  HHH H   IHt H$(  LH%  I/u
IGIP0H& I= LH  Hb Ml$Hl$PI9E 
  IT$HT$PH   Md$H$(  HHL$(  I$H(uH@P0HT$PH Ml$L$   I9E uNH$   A   H$   L$   I LH  HD$PH(u
HPHR0Hl$Px   O LH  HT$PE3HPILx HHl$PLLH  Im u
IEIP0L$   'IILH  I/u
IGIP0H$(  H)uIE P0    H$(  LH(  H
_ E3LpHLL` )LH  I/u
IGIP0H LkH$(  I9E    HSH$(  H   L{HHIIH)uHAP0H$(  H MoI9E uQH$   A   H$   L$   IoHH  H$(  H)uHAP0H$(  r    LH  H$(  E3Mf IIIFH$(  LHHm  I.u2IFI&IHHH  I,$uID$IP0H+u
IE HP0HNHH9N ~HHFH<HAHFHHj~ !  H/H\$hLt$`L$   .HGHP0HI/u
IGIP0H$  LH$   D.  H LH 1    9  O
      e9  L      {9  6     L u9        9       w 9       ^ 9       E 9    f   , 9    M    9  ~  4    9  e      ^9  O     L Q9  3  
   L N9    
   L L9    
   t J9    
   [ G9    |
   H? E9    L~ HH{ HHt{ 0
   H =9  X  tH  H$  HH(H;
A} uAH
} H H	| H9 LHO     9    H  HHu*H LH    U 9       | H$   HHu+ 9  H  IE3H
F HLxHp HHu 9  H  H+u
HCHP0HFH;az tZH;{ tQHI{ H$   LHu 9  H  H@L   Mu&} 9  H  HLH$   LLH.u
HFHP0INHH$   fMu<Hy I9FuM;f
  HJ4HI(M;f  J4HIIAHH  HFHz H;   H;by t~Hz LH2  H.u
HFHP0IFILH   HH  IA   HH  IHS  M)>uGIFI;HNHo  H;u
H^ H~H~H_H?HHH.u
HFHP0HL$pLH|$pHt
H)uHAP0HL$XHH\$XH$  Ht
H)uHAP0IGHH;Px tKH;y tBIIy HH,  H@L   Mu,	   x e:    IILL    Mu>Hw H9FuL;v   H^JHI)L;v   J\HIHAHH   HL$xH\$xHt
H)uHAP0HL$pHYw HH  L$  H HHx  H+u
HCHP0HT$xLHL$pHkz 4  H/!HGHP0H+y Ht Hv HH3  2w H.u
HFHP0H$  HL$   H$   HD$XH LH L   L  H:  v  I.u
IFIP0LuIiH: LHP L   L  P:  "     u  @:        \  c:  *  }   C  :  Cg   -  :  -Q     :  ;     :  HH~ LH LH$  LHD$XLY~H
v HM A   H	v 
HxZ +:     LLLLH~ H$ HtH.u
HFHP0HK  H/A  HGHP02  Ww Ht Ht HH   
u I.u
IFIP0L$   IIL$   L$   L$   H$   H$   H$   MtI/u
IGIP0HL$pL$   Ht
H)uHAP0HL$XHt
H)uHAP0HL$xHt
H)uHAP0H$   HtH(u
HPHR0HH   ]7 :  ]   LLLLH| H H$   Ht
H)uHAP0MtI.u
IFIP0HtH+u
HCHP0MtI,$uID$IP0MtI/u
IGIP0H$(  Ht
H)uHAP0HL$PHt
H)uHAP0MtIm u
IEIP0D H
 H L$   :H\$Hl$VWAVH@Hu IHzLH\$pHM   HtH   HZH\$pH+t HHu)H  H H:r HtHHD$pHH   H HHD$(LL$pH H|$ Ly
8     H\$p   H   H   Hy H|$0HH H?L
 HL HHDHHD$(H6 HL$ LIH
&t H H	r 8  Hjz H     A  H
~ 3HZHIH\$`Hl$hH@A^_^HHPHHATH   H% E3HXAHpAHxLhELpEHALd$XLd$hLd$pL   L$   L$   MtAr H$   HL$   Hu'Hqy H     7  ?  HGLH;jq I  HoH  LwHHE IIH)uHAP0IFM~H;s Hl$xuA   HT$xI]+H;t uIF@t
HI]
HILHuN    7  	  Hm u
HEHP0IH/u	IHP0I.Iu
IFIP03o LH   HFx H_       7  	  H;r uE33H1H;Gs uHG@t3HH E3He
LHNo    5 7  	  H$   HI(H;
p u&H
<q HU H	<p  7  X  H I HHu 7  5  H@IH;Sn Lt$PtMH;}o tDHo HHu 7    H@H   HL$`Hut 7    HHMLd$`H/uHGHP0HD$`Hu>Hm H9EuL;u4  HEJ<HI(L;u  J|HIHHH   HL$hH|$hHt
H)uHAP0Ht HCm HH   H( H'm HHtgH/u
HWHR0IOII9O ~HIGHHAIGHIQm uH+HCHE 7     6 7     ' 7     4o HtHl HHtWl Hm u
HEHP0H$   ML|$XyeHRu Hk     7      7  IHu H7    I/g  IGIP0X  tIIs  3wl HHu'Ht H g   - 7    H$   HH(H;
m uAH
4n Hݱ H	4m H}t IH     7    H & HHu'H?t HX     7       l HHu'Ht H    b 8  ^  IE3H
 HLxHX P	HHu. 	8    H/u
HGHP0HCH;j teH;k t\H"l HHu'Hss H 
    8    H@L   Lt$`Mu$ 8  {  HHLd$PMLd$`HH+u
HCHP0MuHHj H9GuH;wa  HGHHHHt$P.H;wB  H\HHHt$PHAHH  HCHj H;+  H;i   Hk HH  H+u
HSHR0HNIML   HAH$   MH  HA   ALHm  HAHH  L)>u
HFHP0Lt$`HL$pH$   H\$pHt
H)uHAP0H$   L$   L$   Ht
H)uHAP0L$   HM+HHR  HMH9M ~eH HEHHAHEdHKH_  H;u
Lk HCHCLhH H$   H IE H+3HCHP0$HHlh    H+tH$   Ht$PH$   HCHP0H$   Ht$PH$   . [8    H.u
HFHP0I uI c8     S8    Hhp IH~ H$   H$       l8    H.p IHD H$   H$      x j8  _  ~,H
rh H A   H	<h J >8    Hx 1 >8     >i Ht Hf HH   f H/u
HGHP0Lt$XLL$   L$   H$   H$   H$   H$   MtI.u
IFIP0HL$hL$   Ht
H)uHAP0HL$pHt
H)uHAP0H$   HtH(u
HPHR0IH   A\: .8  IL$   MR   Hn H HtH/u
HGHP0HtHm u
HEHP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtH.u
HFHP0Lt$XD H
| v H\$Hl$VWAVH@Hg IHzLH\$pHM   HtH   HZH\$pH[f HHu)H  HC Hjd HtHHD$pHH   Hҧ HHD$(LL$pH H|$ |y
[7     H\$p   H   H   Hk H|$0HH7s H?L
 HL HHDHHD$(Hf HL$ LIH
Vf H/ H	e i7  Hl H  +   A  H
^ )3HZHIVH\$`Hl$hH@A^_^ATAWH8HAE3HZ EH\$XHl$`HL   MtAe Ht$0HH|$(Lt$ Hu'Hk H t   : 6  A  HCLsH;c I  H{H  HsHHHHH)uHAP0HFLvH;Lf H|$PuA   HT$PH+H;f uHF@t
HHHH=HHu'Hk H/    s 6  P  H/u
HGHP0IH+u	IHP0H.Iu
HFHP03Qb HH   Hj H =    6    H;_e uE33H 1H;e uHC@t3HH0 E3HHHNH*j HC     6  d  HM(H;
b u&H
c HO H	b T 6  	  HP 裕 HHu1 6    H@H;` tLH;a tCHH1b HHu 6    H@L   Mu 6    HHIMH+uHCHP0    Mu>H4` H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0Hd H_ HHtEHNH9N ~H HFHHAHFBHH_ . 7      	7     a HtH]_ HHJtf_ H/u
HGHP0HLH.u
HFHP0Lt$ H|$(Ht$0Hl$`H\$XMtI/u
IWIR0IH8A_A\F 7  Hg H ^   H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D H
  LHL@HPHHSVWATAUAVAWH   H@HWhE3LxD$xL`AED$`Ld$pD$HLd$XEL-t IH
 ] HHtH IHHu'Hf H 7    5    HCL   H HMtAk_ HHu'HLf He     5  m  H+u
HCHP0IH$H  LnH.^ I9E g  H^H$H  HR  H~HHHHH)uHAP0LoH` I9E u}H$   H$8  H$   A   H$   HHHu'H|e H     6    H+u
HCHP0IH$H        ^ LHu'H
"e H
;     6  C  HXIH$H  H$8  H IF E3IH^HHu'Hd H ^   $ 6    I.uFIFIP0:HHBHHu'H{d H     6    H.u
IE HP0HGL   H HMtA6] HHu'Hd H0    t "6     H/u
HGHP0HH$   bHHL$`rNH$   HtL$   L+IQ3] Ht*Hc H .    %6  M  H.u
HFHP0IHT$`H$   IH$@  ڟ@@u5\ Ht*H$c H=     06  MB  H$   H$   JDLH$   H$0  HIHHL$HgMH$   HtL$   L+IFHT$HHL$xIH
' ZHHu*Hsb H 
    A6  M  H@L   HV HMtA;[ LHu'Hb H5    y C6  (  H/u
HGHP0HL$x:iHHu'Ha H j   0 F6    IMnHY I9E C  I^H6  MnHIE IMH)uHAP0IMH$H  H=\ H9urH\$(H|$0A   HT$(IHHu'H,a HE     Z6  8  H+u
HCHP0H/   HGH      Y LHu'H
` H
 c   ) j6     HXHx E3IIHHu'H` H     p6     I/uUIGIIHIHHu$H>` HW     S6  MH/uHGHP0P0L$H  I.   IE IP0   E3AH$H  AEMHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0MtI/u
IGIP0D  H
 
IHT$HHtLD$XL+I|HT$`HtLD$pL+I|HT$xHtL$   L+I|H$   HtL$   L+I|HH   A_A^A]A\_^[H\$Hl$Ht$WATAUAVAWHPH=X E3H|$HAH\$@MHLM   LzIMt"HtH   Hz H|$HHZH\$@IW HIMtHt&MH IU HD$@HH   HH(  Hu IT HtHHD$HHH   H IHD$(LL$@H L|$ y
5     H|$HH\$@   HBH   H   HNH1\ HHL$0Hc HLL
 AHD$(IH HLd$ H
V L LMH H	uU 5  H	] H" t    A  H
= 蘽3Hz HZLHI~L\$PI[0Ik8Is@IA_A^A]A\_HLH L@HHVWATAUAVH   H@HXLW@H@    33D$@HXL5 IH
d .S HHtH I)HHu'H\ H+    o /5  6  HGL   H HMtAT HHu'H[ H U    15    H/u
HGHP03H|$ LcHS I9$M  H{H|$ H;  LsHIHIH)uHAP0MfHV I9$uqH$   L$   A   H$   ILHu'HZ H    Z E5  !  H/u
HGHP03H|$       S HHu'H
Z H
 >    S5    Hx3H|$ IE Lh E3HILHu'HWZ Hp     Y5    H.uFHFHP0:IHLHu'HZ H$    h ?5  /  H+u
I$HP0IFL   H IMtAR HHu)HY H >    _5  3  I.u
IFIP0HD$0    HHL$pGXHHL$@CHT$pHtL$   L+IvR Ht)H"Y H;     b5  3D  H+u
HCHP03HT$@HL$Xg?H$   jAAu4PR Ht)HX H K    n5  3   H$   @@u4R Ht)HgX H     o5  3   HT$XHL$p@DEHH$   HIRP HH   H X H    ] v5  3%Lt$0H|$ IIMtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0D  H
a 3HT$@HtLD$PL+ItHT$XHtLD$hL+ItHH$   HĠ   A^A]A\_^H\$ UVWATAUAVAWH`H
( H3HD$XL5Q 3H-
O MHt$@HLt$HLHl$PM%  LbIMt1Ht"HtH%  Hj(Hl$PLr Lt$HHrHt$@I6O HIMtHt,HtOvH I=M HD$@HH   HHo  H IM HtLHD$HHHF  H IL HtHHD$PHH  H IHD$(LL$@H~ Ld$ y
4     Hl$PLt$HHt$@   HBH   H   H   HWH%T HHT$0A   H
[ HLL
q HL$(   H
N H;AML­ HHD$ H	H MMLd ^M 
5  HT H ]    A  H
f 聵3Hj(Lr HrLMHIHL$XH3wH$   H`A_A^A]A\_^]@SUVWATAVAWHPH% H3HD$@H-s LLHH
k M33.K HHtH H)HHu q4    HCHH L   MtAL HHuK s4    H+u
HCHP0HGHH L   MtAL HHu'HS H !    v4  d  H/u
HGHP0H{K 33H9Cu+H{Ht"HCHHHH H)uHAP0   HM H9CugHT$(HDEH+H|$ HLt$(L|$0Ld$8[HHuI 4     H  H/
  HGHP0   MK HHuH
R H
  4  ZHtHx3IE3HHLtEIL|EI$LdHHu~ 4  H,R HE    HtH+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0D} H
 @ {3#H.u
HVHR0H+u
HSHR0HHL$@H3tHPA_A^A\_^][H\$Hl$Ht$WAVAWHPHAJ MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@II HHHtHt+RHJ  H IG HtHHD$@HH!  H IG HtHHD$HHH   H IHD$(LL$@Huy Hl$ y
A4     H|$HH\$@   H   H   H   H
Ҩ Hl$0HL
S H?L HH HHLIH
?V HL$(H
I HD$ H	AH R4  HO H @ f   A  H
9 d3Hz HZLHIH\$pHl$xH$   HPA_A^_H\$Hl$Ht$H|$ ATAVAWH H5c LHHH
[ MM3F HHtH HHHuv 3    HGHH L   MtAG HHu: 3  D  H/u
HGHP0HCHHO L   MtAG HHu'HyN H     3  
  H+u
HCHP0sE HHu 3     H LHQE y 3     H MH+E y] 3  jH MHE y: 3  GHi MHD y 3  $H~ LHHHui 3  HrM H 	   HtH/u
HGHP0HtH+u
HSHR0D H
  ֭3#H/u
HWHR0H+u
HSHR0HH\$@Hl$HHt$PH|$XH A_A^A\@SUVWATAVAWH`H H3HD$XH=E MH- LH5 LrH|$@IHl$HHt$PM#  Mt1Ht"HtH/  Hr(Ht$PHj Hl$HHzH|$@ID HIMtHt1HtT{H  H IB HtHHD$@HHl  H IB HtHHD$HHHC  Hf IB HtHHD$PHH  H IHD$(LL$@Hs Lt$ y
3     Ht$PHl$HH|$@   M   H   H   H   HI Lt$0IHTQ H?L
5 HLZ HHHDMHD$(H HL$ LIH
oD HH H	C 3  HJ H  D y  Ay  H
 B3Hr(Hj HzLLHIHL$XH3tmH`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   H MtAC H|$PHHu v  J F3  D  @ HHu- H3        B HHuH
I H
  J3  lILLxHH @ y O3  4H+u
HCHP0H* LHHHu^ Q3  HI H7  v  H.u
HFHP0HtH/u
HGHP0HthH+ubHCHP0VH.u
HFHP0H/u
HGHP0IHH? Hu=; w   `3  HH H D H
e  LL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAHg L   MtA@ Ht$8HH|$@Lt$HHu'HG H Y s   2    HCLs3H;?    H{H   HsHHHHH)uHAP0HFLvH;2B H|$0uA   HT$0H+H;oB uHF@t
HHHH#HHuq 3     H/u
HGHP0H+u	IHR0HLt$HH|$@Ht$8H [H;A uE33H1H;A uHC@t3H Hg E3HHHu 3  H[F Ht  s  HtH+u	IHP0HtH/u
HWHR0D H
}  3/AVAWHHH\$`E3Hl$hEH- Ht$pHH|$@ALl$0ALH
 < HHtH HHLd$8Hu o   f2  3  HCHH  L   MtAQ> HHu o   h2    H+u
HCHP0HGHH L   MtA= HHu'HD H s o  9 k2    H/u
HGHP0H< LcII9$w  H{Hj  HkHHHHE H)uHAP0HB? LeI9$   A   H|$ HT$ Ll$(HHHu o   2    H/u
HGHP0IH+u
I$HP0H
 LHH   HC IH e p  + 2       < HHu'H
C H
 + o   2  O  HxE3IE HHLh IHHu o   2    H.)HFHP0IHHH o  j y2     H}yM 2  I   H+u
HCHP0   HEHHg L   MtA; HHu'HB IH  p   2  QH* E3HHHu| 2   p  H,B HE HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D H
y J 腢H+u
HCHP0HHE LLl$0Ld$8H|$@Ht$pHl$hH\$`MtI/u
IWIR0IHHA_A^{H\$Hl$VWAWH0H-_ LH
] H33 8 HHtH HHLt$PHut 1    HCHH L   MtA9 HHu8 1    H+u
HCHP0HGHHM L   MtA9 HHu'Hw@ H  l   1    H/u
HGHP0Hh8 Ls3I9  H{H  HkHHHHE H)uHAP0H: LuI9unA   H|$ HT$ L|$(HQHHu? 2     H/u
HGHP0H+u	IHR0HLt$PH\$XHl$`H0A__^ù   ]8 HHuH
n? H
  2  tHxE3IHHLx 3HHu 2  7H.pHFHaIHHHMm 2  H> H  l  HtH+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0D? H
Hu  =3LUAUIHH  Hm H3H   HE3H  I[AIsAI{H HEHALD$hMcM{EL   HT$XH. LMHL$PLmLmLmH\$HLl$`LmLl$pLl$xLmLmLmLmLmLmLmLmLl$8Ll$@MtA6 L$   HHu'Hx= H  1  վ *  E  HGLgH;q5 5  H_H(  LwHHIIH)uHAP0IFMfH;7 H]uA   HUIj+H;)8 uIF@t
HIjHILHu'H< H M 1   +  fD  H+u
HCHP0IH/u
I$HP0I.Iu
IFIP0H
6 HT$hH9M  H;A  L5 H
S I3 LH   H    H;6 uE33Hp1H;/7 uHG@t3HqH E3HMLH6H; H I 1   	+  bC  ILMu  3   *+  C  ID$IH L   MtAS4 HHu 3   ,+  B  I,$uID$IP0H E3HLHu'H: H  3  L /+  B  H/u
HGHP0I.u
IFIP0HT$hH
3 H9M  H;2 A   H
 PLHu*Hi: LH  5  û X+  0B  H@IH L   MtA13 HHu 5  } Z+  A  I,$uID$IP0H_ E3HdLHu'H9 H d 5  * ]+  }A  H/u
HGHP0I.u
IFIP0H
n2 Ld$XL;   Lt$PIF(H;uAH
3 Hl H	2 HL9 LHb  8   +  A  H Hd Hu*H9 LH$  8  h +  @  I,$IHD$X   ID$P0   H
 LHu*H8 LH D 9  
 +  w@  Lt$XII/ u 9  ٹ +  @  I,$uID$IP0t\   / HHu*H,8 LHB  :   +  ?  IIH@HT$XL0I.uIFP0Lt$PH
 HHu*H7 LH ^ ;  $ +  ?  H@HHA L   MtA0 HHu'Hs7 H 
 ;  и +  #?  H/u
HGHP0HCHH L   MtA.0 HHu*H7 LH%  ;  i +  >  H+u
HCHP0IN(IH;
/ u>H
e0 Hj H	e/ H6 HǾ E ;   +  ^>  H Zb HHu'Hs6 H 
 ;  з +  #>  IN(H;
0/ u>H
/ H8j H	. H(6 HA  ;   +  =  HI a HD$8LHu'H
5 H
  ;  E +  =  H- EH9Gu,LMt#HGHIHH H)uHAP0A   He0 H9G   HD$XH   H   EFAHHH+L   H   L   LHu'H.5 HG Ž ;   +  <  MtI/u
IGIP0H+Mu
HCHP0I,$   ID$I   AN- HD$@HHu'H
4 H
ɼ G ;  
 +  `<  MtLxMHL$XE3ALl$8HHLAFH\HAFILdLHu'H@4 HY ׼ ;   ,  ;  HL$@H)uHAP0H/u
HGHP0HL$XILt$XH)uHAP0LuL;5, uL+ Hu-H3 MHۻ HV =   ,  ;  I.IHEuIFP0H\$PHK(H;
c, uDH
- Hg H	, H[3 MHq H ?   2,  S;  H _ LHu-H3 MH0 H ?  q 4,  ;  HK(H;
+ u=H
, H)g H	+ n ?  I1 8,  Ll$8Ll$@U:  H[ v^ HHu&4 ?  I :,  Ll$8Ll$@:  HI* HD$@LHu! ?  I <,  Ll$89  I,$uID$IP0H/u
HGHP0H
- LuMLl$@HHu*H1 HH  @  G J,  9  H@HHd L   MtA* LHu/H1 IH * @   L,  Ll$8>9  H/u
HGHP0ID$IH_ L   MtAH* HHu!ι @  I O,  Ll$88  I,$uID$IP0H) MALl$0H9Gu1LgLd$0Mt#HGHI$HH H)uHAP0   H+ H9G   HD$XHUpHMDCHExHMpHϋHH+LehHD$@LHu! @  Iɱ a,  Ll$87  MtI,$uID$IP0MLl$0   K( HD$8LHu!Ld$0I @  i o,  7  HD$0Ht
ID$Ll$0HME3HT$XHILCHHITI4HD$@LHu!Ld$0I5 @   z,  )7  I,$uID$IP0Ld$0H/u
HGHP0I.u
IFIP0H
` Ll$@HHu!̷ B  I ,  Ll$86  H@HH L   MtA' HD$8LHu!Ld$0Iq B  7 ,  e6  H/u
HGHP0ID$IH L   MtA' HHu!Ld$0I B  د ,  6  I,$uID$IP0H\$PLl$8HK(H;
' u8H
' Hb H	& Ld$0I B  w ,  5  Hs Y HD$8LHu!Ld$0Iw B  = ,  k5  HK(H;
& u8H
L' HEb H	L& Ld$0I2 C   ,  &5  H GY HD$0Hu*H^- IHt  C   ,  5  HK(H;
& u8H
& Ha H	% Ld$0I D  s ,  4  H X HHuLd$0{ D  A ,  o4  H$ MEH9Gu,LMt#HGHIHH H)uHAP0A   H^' H9G   HD$0H   H   EFHD$XHH   AHH+L   L   H   HD$@LHuLd$0 B  | ,  3  MtI/u
IGIP0I,$MuID$IP0HL$0H)uHAP0H+   HCH   AN$ HHu,H
+ Ld$0H
 & B   ,  (3  MtLxMHT$XANAE3Ll$8LdHD$0HDAFHH\AFHIHTHHD$@LHu'H	+ H"  B  f ,  2  H.u
HFHP0H/u
HGHP03LuU" HD$@LHu-H* IH I: G    ,  2  H\$PHK(H;
[# uDH
$ HS_ H	
# HS* IHi I G   -  K2  H U HHu-H* IH( I G  i -  
2  HK(H;
" uIH
x# H^ H	x" H) IHױ IR G   -  Ll$8f1  H/ bU HHu/H{) IH  G  ժ 	-  Ll$8#1     (" HHu,H9) HR б G   -  Ll$80  H
 E3HHxHp 肾HHu*H( MH  G  E -  0  H+u
HCHP0HFH;    H;  twHI1! HHu'H( H  G  ߩ -  {0  H@L   LuMu8HG( H` ް G   -  0  HH3DH}3H.u
HFHP0Ld$@    Mu>H H9CuL;k  HCJ4HI)L;k  JtHIHAHH  HFH H;3  H; &  H  HD$8LH  H.u
HFHP0IFHHL$8LL   AHD$0    HHq  HL$8A   AHD$0HU  Ld$8IAH  I,$uID$IP0Ld$0LuHL$xH|$xHt
H)uHAP0HMIHEHtH)u
HAP0IHH HHf  Ld$@IL$I9L$ ~_H ID$H4HAID$\HNHZ  H;u
Lf H~H~LgH?HI$H.KHFHP0<HIh    H.    HFHP0E3Ab  Ld$0p G  6 e-  d-  HL$8H)uHAP0HD$8    ѵuI赶Ld$0& G   m-  -  Hh% H  G  Ŧ ]-  2-  HA% E3HW խ G   v-  -  H% E3H-  G  q t-  ,  ~H
k H A   H	5 
HxH$ LHج V G   H-  ,  ) HtH HH{tZ E3H+u
HCHP0HL$hMLeLl$@`yQHD$ H] ۬ I   -  =,  H$ LH3  G  w 8-  +    H
% HHu'H# H p J  6 -  +  H@HH3 L   MtA HHu'H# H  J   -  O+  H+u
HCHP0Hv IH9F   H^H   H~HHHHH)uHAP0HHĶHD$@HHu'H" H  J  U -  *  H+u
HCHP0IH.u
HFHP0Ld$XIH|$HID$H;    H;    IHE HD$@LHujHd" MHz  K   -  +*  H衵HD$@HHcH!" H:  J  ~ -  )  H@H   HE HuFH! MH z K  @ -  )  I$IIHMHE MLd$@HMMLl$8IHuFH I9FuI;N}  IFH4HHHM,I;N_  ItHHHMIHH  HT$`LHt$`HHt
H*uHBP03 HH  HMI HH  H@H; t[H; tRIHLt$he HD$0H  H@L   LeMu5Ld$0< M   -  0(  HMH\$0MLl$hLmH+uHCHP0fD  MuQLd$0HO I9D$u!M;t$  ID$JHILt$h6M;t$  K\HILt$hHL$0AHHf  Ld$0HMH]Ht
H)uHAP0H
 I蘲HH  H@HHN L   MtA HD$8LHj  H/u
HGHP0ID$IHߣ L   MtAX HH
  I,$uID$IP0HK MALl$8MH9Gu4LgLd$8Mt&HGHI$HH H)uHAP0   DH H9GuhHEDAH   H   HD$PL   H@(H   HHH+HH  MtI,$uID$IP0Ll$8q= LH  Mt	L`Ll$8HEE3HL$PIH KDHA(H HA(HKD 蜳HH  I/u
IGIP0MH/u
HGHP0HNIH9N ~HHFHHAHFHH #  H+Lt$hLeDHCHP05I0 Ht H HHst   Ld$0I,$uID$IP0HMLHuHt
H)uHAP0H
¨ ILH  H@IH0 L   MtA HHA  I,$uID$IP0H LcLl$0I9$   HSHT$0H   LsHHIIH)uHAP0HT$0HV MfI9$uCHEA   HUIHUHE ƲHH
  HL$0H)uHAP0Ll$0v    HH
  HD$0E3HGHHEILl$0H HG sHH>
  H/u
HGHP0IIHwHH  H+u
I$HP0HL$pHt$pHt
H)uHAP0LuIHq IIFL   MtAk HHw  Hp IH9CuRH{HtIHsHHHHH)uHAP0HHƮHH  H/u
HGHP0IHMHH  H+u
HCHP0Ld$`HII Dx
AADE  H.u
HFHP0EILt$p/  IFIH L   MtAb HH  HMI) HHp  HN LcLl$0I9$  HSHT$0H  LsHHIIH)uHAP0HT$0H MfI9$   HU(A   HU(H}0I(HHf  HL$0H)uHAP0H/Ll$0u
HGHP0Lt$pH+u
I$HP0IHt$pLIH)uHAP0Ld$`r HH  MIH_   HL$xLHt$xHt
H)uHAP0HL$HIH1 HAL   M   A       LH
  HD$0E3IIGILl$0I &HHr
  I/u
IGIP0MHH'HH
  H/HGHP0T HH  L`MHR I9$   L{M   LsHIIIH)uHAP0H MfI9$u@HD$xHU8A   HE@IL}8>HH9
  I/u
IGIP0Mp   z HHI
  LxE3HD$xHIMH HG HH	  H/u
HGHP0IIHHH  H+u
I$HP0H.Iu
HFHP0Lt$PIIN(H;
 2  Hr B HH
  H@HHC L   MtA HH
  H+u
HCHP0H LgII9$   H_H   LwHHIIH)uHAP0H7 MfI9$uEHT$`A   HUPIHUHH]H覬HH  H+u
HCHP0Lt$PIw    LH	  HXE3HD$`IIIH IG XHH  I/u
IGIP0Lt$PMHT$`HUHHp  H/u
I$HP0HMIHuLHt
H)uHAP0IN(IH;
;   H A HH  IH HH  H.u
HFHP0HMLH}Ht
H)uHAP03I} HH)  A   HI
 LH
  H.u
HFHP0II8QD
  I/u
IWIR0Et*   
 LH  H
 HH@HI$MI,$IML}uID$P0   
 HH
  HEE3H
A HH HG芩LH	  H/u
HGHP0   s HH	  H@IHL8T LHI	  H/u
HGHP0HMIL}Ht
H)uHAP0Lt$`Ld$HII]
 LH  H@IH L   MtAL HH  I/u
IGIP0    LHH  HEH IG(
 HH
  Le HHK 
   LIHGHH  H/u
HGHP0I/Iu
IGIP0H.Mu
HFHP0LIII *  H+u
HCHP0HMI H  HEAE:  HM   袕HH  H7 A   HHH\  H+u
HCHP0HIjND  H.u
HVHR0E  H
G zHH  H@HH L   MtA
 LH  H+u
HCHP0HT$`I7 HH  H\	 MwI9   IH   IwIHLHH)uHAP0H LvI9u;A   H}XHUXH]`HKHHr  H/u
HGHP0Ir   	 LH}  HxE3HX HHIIHH<  I,$uID$IP0MLl$0,HIHHh  H+u
HCHP0Ld$0I/u	IIP0HT$`LHL$HMV
 
  H.u
HFHP0Ld$0MLt$@IHMHE 9H H a M  ' -  z  Ld$0C L  	 5.  7  Ld$0% L   S.    Ld$0 L  ͐ N.    Ld$0 L   C.    Ld$0˗ L   #.    Ld$0 L  s  .     L  Z .    Ld$0v M  < .  j  Ld$0X N   .  L  H H 1 N   .  J  Ld$0 N  ُ .    Ld$0 O   .    Ld$0ז P   .    H H2  P  v .    Ld$0 P  X .    Ld$0t P  : .  h  Ld$0V P   .  J  Ld$08 P   .  ,  Ld$0 R   (/    Ld$0 R   </    Ld$0ޕ R   6/    Ld$0 S   e/    Ld$0 S  h y/    Ld$0 S  J s/  x  Ld$0f V  , /  Z  Ld$0H [   /  <  Ld$0* [   /    Ld$0 [  ҍ /     Ld$0 \    0    Ք \   60    H IH-  \  q 00     \  IU <0    Ld$0q \  7 0  e  Ld$0IP \   0  D  Ld$0I/ \   	0  #  Ld$0I \  Ԍ 0    Ld$0 [   /    Ld$0ғ Y   /    Ld$0 Y  z /    Ld$0 Y  \ /    Ld$0x Y  > /  l  Ld$0Z Y    /  N  Ld$0< Y   /  0  Ld$0 Y   /    Ld$0  W  Ƌ /    Ld$0 W   /    Ld$0Ē W   /    Ld$0M W  i /    Ld$0 V  K /  y  Ld$0g V  - /  [  Ld$0I V   /  =  Ld$0+ T   /    Ld$0
 T  ӊ /    H
 H> H	 Ld$0ؑ T   /    Ld$0 S   _/    Ld$0 S  b Q/    Ld$0~ S  D O/  r  H
` H= H	` Ld$0I S   M/  =  Ld$0+ R   "/    Ld$0
 R  Ӊ /    Ld$0I Q   
/    Ld$0Iː Q   /    Ld$0 O  s .    Ld$0 O  U .    Ld$0q O  7 .  e  Ld$0S N   y.  G  : N    k.  .  H| H  N  و i.  ,   M   -     L   -      Ht H( HH^   g I.u
IFIP0H\$HHLHML$  L$   L$(  H$0  H$8  Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HtH+u
HCHP0HL$`H$@  Ht
H)uHAP0HMHt
H)uHAP0HL$pHt
H)uHAP0HL$xHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$XHt
H)uHAP0HEHtH(u
HPHR0IH   H3((HH  A]] K  i -    3| LHu'H H l ^  2 d0    HHD$HHD$PMHH(H;
 u>H
1 H2: H	1 Hz H  _  ׅ r0  x  H &0 LHu'H? HX ֌ _   t0  =  I HE HHu'H H  _  _ v0    I.u
IFIP0Ll$@MLl$0H	  @ H
я 脖HHJ	  H@HH: L   MtA LH  H.u
HFHP0IGIH L   MtAJ HH  I/u
IGIP0I IILHR  H$ AH\$0H9Fu2H^H\$0Ht$HFHHHH H)uHAP0   H H9F   HD$PDALuH   H   L   H@(H   HHH+L   ޘHD$@HH  HtH+u
HCHP0I/Ll$0   IGI} HHI  HD$0Ht	HCLl$0HL$PE3LuHL|MHA(H HA(HHD ILt(QHD$@HH  H+u
HCHP0H.u
HFHP0HMIH}Ht
H)uHAP0H|$PLl$@HO(H;
N G  H ,- HD$@HH  3HHH  H+u
HCHP0HMHLl$@H]Ht
H)uHAP0II=r     HO(H;
   Hj , HH  3H7HD$@LH^  H.u
HFHP0IH HH  I.u
IFIP0H+HHuuHCP0H
 HD$@LH  H@IH L   MtA  HHM  I.u
IFIP0H LsLl$@I9   L{L|$@M   H{HIHHH)uHAP0H LwI9uAHEHUA   HEHL}HH  I/u
IGIP0Ll$@t   0 LH  HL$@E3HHIHEHLl$@H IG 襔HHa  I/u$IGIP0HUH諒HH  H+u	IHP0HFHH L   MtA HH  H.u
HFHP0HMIH]HHt
H)uHAP0H
 CHHT  H@HH) L   MtAJ HH  H+u
HCHP0    HH  H HHH HCH H HC Hs( HHp  H+u
HCHP0H|$HHHI~(  H.u
HFHP0IIML;e F   `  I~ 0     d  I~ 0  M  ޅ d  I~ 0  M   d  I~ 0  M  H
 H3 H	  d  IL~ 0  Mj  j e  M-~ 1  N  N e  ~ /1  5  5 e  I} )1     f  M} U1     f  M} R1     f  M} G1    ń f  M} D1     f  Ml} B1     e  MP} 51  q  q e  M4} 1  U  U e  I} 1  M6  6 e  I| 1  IM   c  I| 0  M   b  I| 0  M  փ b  I| 0  M  H
 H0 H	  b  Ic| 0  M   `  G| 0  h  h `  .| 0  O  Ld$0J `  | 0  Ll$89  , `  I{ 0     `  I{ 0     `  I{ 0    H|$HH
΅ HHu{ `1    H@HH L   MtA LHuS{ b1  j  H+u
HCHP0H MwII9"  I_H  IIHLHH)uHAP0H^ LwI9uvHD$HHU A   HEHH] ΏHHuz v1     H+u
HCHP0H|$HI/u	IIP0H/HH!HGP0    HD$@LHuUz 1  oHXE3HD$HIHIH ID$ AHHuz 1  9I,$kID$I[HI:HHLy p1  
 g  Ld$0Ll$8IHN Hg MtI,$uID$IP0HtH/u
HGHP0Lt$8HtH+u
HCHP0MtI.u
IFIP0Lt$@H\$HMtI/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0E3DA H
- y ?XH\$ UVWATAUAVAWHpH} H3HD$`H=6 MH5t HL5r LLzH|$@IHt$HLt$PH|$XMm  Mt@Ht1Ht"HtH}  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@I HIMtHt>HtaH      H  H/w I~ HtHHD$@HH  Hx IU HtHHD$HHHp  Hw I, HtLHD$PHHG  Hv I HtHHD$XHH  H' IHD$(LL$@H L|$ y
*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
N L|$0IL
Q H?L( HHO HMLIH
{ HL$(H
 HD$ H	} *  H H*} |v }   A  H
e( U3&Hj0Lr(Hr HzMHl$ LHIVHL$`H3H$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMHx L   MtAY H|$0HHu'H5 HN| |   u 8*         HHupu :*  sHE Hh HHuH
 H
{ @u ?*  QHwt MH yu A*   LHHHHuyt B*  H| H{ |   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0D{ H
& t S33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt+RHJ  Hr I HtHHD$@HH!  Hr I HtHHD$HHH   H9$ IHD$(LL$@H Hl$ {y
	*     H|$HH\$@   H   H   H   H
J Hl$0HL
M H?L# HHK HHLIH
 HL$(H
 HD$ H	 *  H H.y r y   A  H
y# Q3Hz HZLHIJH\$pHl$xH$   HPA_A^_LATAVH   H H3H$   HE3H;c LI[ AIkIsAI{AMkEM{ELD$@HT$ HL$0Ld$(  3 HHu'H  H9x x   }q (  L  HD$0HH(H;
 u0H
 H  H	 ux   ;q (    H7q  HHu'H
 H
w :x    q (    H@H; tsH; tjHI  HHu'H
Q H
jw w   p (  .  H@H   HL$8Hu'w   p (    HHMLd$8H/u
HGHP0HD$8Hu>H H9CuL;s   HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0HUv IL;tIsxUnHMH9M ~IHEL<HAHELIH 8v   o (     v   ho (     u HtH HHDt9, H+u
HCHP0HL$ LHl$ H)3  HAP0'  /v   n (  jL5w H
t I\ HHtH IWHHun 	)   HL$ HE DuEn )  u   H
 H#u H5  Hm *  HEHP0  Hm u
HEHP0Et[   W HHu,H Lt$ Ht Bu   n )     HL$ LHT$ HH@HLt$ H=x H
s HK HHtH HFHH   H+ HDt t   m 0)  Lt$ HtH+u
HCHP0MtIm u
IEIP0HL$(Ht
H)uHAP0HtH.u
HFHP0DUt H
 m SLG  HCHH0p L   MtA HHu'Hb H{s s   l 2)  2H+u
HCHP0HGHHu L   MtA HHuH Hs el 5)    H/u
HGHP0Hl$0HM(H;
 u>H
_ H H	_ H Hr ?s   l :)  xHl T HHu'Hm Hr s   k <)  =HM(H;
* u4H
 H
 H	 H" H;r k @)  =  HMs  LHufk B)    H
 IAHL$(H9Cu5HKHL$(Ht'HCHHHH H)uHAP0HL$(   Hu H9C   HL$HHT$PDEHHH+Lt$PH|$XLl$`HHuHN Hgq j S)  lHL$(Ht
H)uHAP0H/Ld$(u
HGHP0Im    IEI   M HHuDUj e)  H
 H
p mq   HH/HGHP0HL$(Ht	HHLd$(IE3HHLtEH|ELlM}HHu'HV Hop p   i s)  &H.u
HFHP0H+u
HCHP0ILH)uHAP0H
t zHHu*H IHo |p    Bi )  H@HHm L   MtA HHu*H MHo %p    h )  cH+u
HCHP0HFHHk L   MtAI HHu'H* HCo o    h )  *H.u
HFHP0H IAH9Cu+HsHt"HCHHHH H)uHAP0   H H9C   HD$0HT$pHD$pDGHD$@HH$   HH+Ht$hHl$x|HHu*Ha MHwn n    g )  3H   H.   HFH   O LHu'H H n n    dg )  HtHpIHL$0E3HT$@HILGHE HIlGHITI*{HHu'H Hm *n    f )  hIm u
IEIP0H+u
HCHP0LL$   H$   H$   H$   H$   MtI/u
IGIP0L$   MtI.u
IVIR0IH$   H3Hĸ   A^A\H\$Hl$Ht$WAVAWHPH MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt+RHJ  Hd I" HtHHD$@HH!  Hd I HtHHD$HHH   HM IHD$(LL$@H Hl$ ny
{(     H|$HH\$@   H   H   H   H
"< Hl$0HL
? H?L HH= HHLIH
 HL$(H
 HD$ H	 (  H% H>k d k   A  H
y C3Hz HZLHI:H\$pHl$xH$   HPA_A^_@UAWHHHl 3H\$`Ht$hH|$pH L=l Ll$8LH
i Lt$0L5h I^ HHtH IY{HLd$@Hu'H= HVj j   c '  }  HCHHon L   MtA HHu'H Hj j   Fc '  )  H+u
HCHP0H LfHI9$  H^H  LvHHIIH)uHAP0HP MfI9$   A   H\$ HT$ L|$(IwLHu'H6 HOi i   b '  v  H+u
HCHP0HH.u
I$HP0I.Hu
IFIP0    LH  H HHh Vi   b (       t HHu'H
 H
h i   a '    HXE3IHILx HuLHu'H: HSh h   a '    H/
HGHP0IHsLHH Hg zh   @a '  #  IEIH IEIFIE H IE IF IEHe L   MtA HHu` (     H HH9G  H_H  HwHHHHH)uHAP0HHrHHu` (  DH+u
HCHP0HH/u
HGHP0    HH   @` (  H Hf Xg   I.u
IFIP0HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0Dg H
; _  ?fHqHH9_ (  [Hd_ HH HGLw Hw(H H H HG0H H H HG8Lt$0Ll$8Ld$@H|$pHt$hH\$`MtI/u
IWIR0HHHA_]@UAVH8HBE3H;z AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH; t[HH HHu'H! H:e e   ~^ F'    H@L   Mu^_^ H'  J  HIIMMu>H H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HIM HHtFLHI tH+aHCHP0Rd   ] u'     d   s] s'  k H   H
 LI;   HHD9   }      @t3H2IH ug] c'  6d   H Hc HtH/u
HGHP0HtH+u
HCHP0Dc H
 \ ;  H/u
HGHP0L5 IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH H` E3H\$0E3HHt$8H
[ H|$@:HHu2H-[ Hl Hb c   HE [ &    HXHH
d H` HAL   MtA( HHu'H	 H"b b   f[ &  H  H
 IH9C   H{H   HsHHHHH)uHAP0HHXmHHu[ &  uH/u
HGHP0IH+u
HCHP0HHue  HHu]HN Hga a   Z &  {HlHHuZ &  H H)a a   HtD2HX&HHubH H` xa   >Z &  H+u
HCHP0HtH/u
HGHP0DBa H
{ Z @9&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*H E3H_ q`   7Y a&     LHu'H H_ <`   Y b&  Z  IFHHHu-H
I L H2 H	 X d&    HAH;H tWH;w tNH HHuH
 H
5_ X i&  ~  H@L   MuadX k&  Q  H3E3H@ Mu>H H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA1 HHtNH+u
HSHR0IVLI3/ uH/HGHP0HW &  5  9W &  &  H
 L~ H/1 H	 W &      Ht H HHz,    H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$hILl$`H A^A\_^[V &  3H H\ &]   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D\ H

 U 4H\$Hl$Ht$H|$ AVH HY HH
U E3mHHuH 7&  H   H
S HxHH5` L5] H-\  HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw` H+u
HCHP0HG?&  H H[ aT [   A  H
J 3H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtH虀  HH [H [@SH HYHtHY  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@M?  LbIMt4HtH*  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@I HIMtHt&DHQ I HD$@HH   HHQ I HD$HHHtNHH  H IHD$(LL$@HY Ld$ Zy
%     H\$HH|$@   H
 H HD$0   L
) HD$(L( H* HD$    H	 %  OHzt}HFL
n) H
 L HD$0H* HA HD$(H	HD$    F %  H HW qX   ;Q A  H
 i0:HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HǄ$   HE3L|$@L|$H1HD$@L|$0L|$8t1HD$0AL|$PEL|$ EL$   AEHCHu'H HV \W   "P s$     H3  LkL$   HC HD$PIE H Ll$`HD$hIL%Z IH
U S HHtH INgHHu'H7 HPV V   O $  )  HCL   HR HMtA HHu'H HU zV   @O $    H+u
HCHP0HFL   HX HMtA HHu-H HU V   N $  MM  H.u
HFHP0IL$   LcH[ I9$h  HsH$   HS  LkHIE HIH)uHAP0MeH I9$u}H$   H$   H$   A   H$   I/cHHu'H HT ?U   N $    H.u
HFHP0IL$         = LHu'HN HgT T   M $  @  HpIL$   H$   H IF E3IIaHHu'H HT T   PM $    I.uFIFIP0:IHn_HHu'H HS >T   M $    H+u
I$HP0HGH H;1  H;d $  H HHu*H> HWS S   L $  MB  H/u
HGHP0IHFL   MHAHMHtlA   HALHtXHAHZy'H HR SS   L $    L).u
HFHP0IL$      H.u
HFHP0IZuI[HR HkR R   K %  D  HOHtU~A   H& H
 H	i 
Hx%[H HR R   SK $  M  H;u
Lw H_H_LsHHIH/u
HGHP0LH$   L|$xMLt$pMHHL$ #&  HHD$@H;tTHT$@HRHL$@)HD$@H@HD$@H HD$@H@L|$HHL$@HHD$@HHL$HHCHD$HHKH|$ HWHL$ O)HD$ H@HD$ H HD$ H@L|$(H|$ HcIHL$   HHD$0H;tTHT$0HRHL$0&HD$0H@HD$0H HD$0H@L|$8HL$0HHD$0HHL$8HCHD$8HKLD$ MM HT$XHL$    DBoHL$ HL$PN&u2 Ht'H H8P P   |I %%  H    eHD$XLD$0HT$@HƁH$   HAH   E3HR H
'M :]HHu'H HO :P    I ?%     E33HOH+u
HCHP0H_ HxO O   H C%     H$      HD$`H$   HL$hHL$PH$   HD$ HD$pH$   H\$xHH$   LHtH+u
HCHP0HtH/u
HGHP0Ld$ L$   HtH.u
HFHP0MtI.u
IFIP0H$   D&O G H
 $'AHtH/u
HGHP0HL$PHt
H)uHAP0MtI,$uID$IP0MtIm uIEIP0LD$0MM H$   HL$0   DBoHL$0VLD$@MM H$   HL$@x   DBoHL$@%AHĠ   A_A^A]A\_^[H\$Ht$WH IHHMt-I* H~HLuH\$0Ht$8H _HHHH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH  H@LE3L|$`L|$hL$   L$   L|$HL|$P'HD$HL|$8L|$@'HD$8L$   L|$(L$   EAW$   L$   HqP HH
oK 9 HHtH H4]HHu'H H6L L x  zE !  \  HGL   HH HMtA LHu'H HK `L x  &E !    H/u
HGHP0IFL   HN IMtA HHu'He H~K K x  D !    I.u
IFIP0ML$P  LgHG I9$X  LwL$P  MC  H_IHHHH)uHAP0LcH I9$uuL$   L$   A   H$   H$YHHu'H HJ 4K x  C !    I.u
IFIP0ML$P        2 HHu'HC H\J J x  C 	"    LpML$P  IE Lh E3HHWHHu'H HJ J x  LC "  .  H.uFHFHP0:IHjUHHu'H HI :J x   C !    H/u
I$HP0IHCH H;(  H;]   H LHu'H7 HPI I x  B 4"  ^  H+u
HCHP0IFH   MIHIHtjA   IHHtWIHPy'H HH UI x  B <"    M)&u
IFIP0ML$P     I.u
IFIP0MPuIQHT HmH H x  A D"    HKHtR~A   H H
 H	k 
Hx'QH HH H x  UA "    H;u
Hs H{H{HwH?HHH+u
HCHP0HHD$`H$   IHt$hH$   I  HH$   3A  H8HkLH$   (  HH$   3A(  H HXlH$   M   E3HuH H
nD THHu'H HG G |  G@ {"  >
  E33HFH+u
HCHP0H HF =G |  @ "    H   E3HG H
C SHHu'HX HqF F ~  ? "    E33HcFH+u
HCHP0H H-F F ~  q? "  h  H
H H$`  ϴ Hu'Hӽ HE jF   0? "  '  H$   H
\F wPHHu'H HE 'F   > "    H@L   HF HMtA[ HHu'H< HUE E   > "  f  H+u
HCHP0HFH;	    H;4 t~HH$   LHz HHu'H˼ HD bE   (> "    H@L   Mu?H HD +E   = "  
  HHMMHǄ$   H.uHFHP0@ Mu?HD IL|$0H9CuL;c   HCJ4L;c}zJtHI  HAHHD$0H  w HtHH HHt. *H HC TD   = "  I	  H+u
HCHP0H$`  LHL;
O tRH;V tIMIL H* H
 H	 HC H\C C   < #  	  HH$      HT$`HL$p  HHD$HH;tTHT$HHRHL$H,HL$HHIHL$HH	HD$HH@L|$PHL$HHHD$HHHL$PHCHD$PHKH|$pHWHL$pHD$pH@HD$pH HD$pH@L|$xH|$pHHT$hHL$p  HHD$8H;tTHT$8HRHL$8MHL$8HIHL$8H	HD$8H@L|$@HL$8HHD$8HHL$@HCHD$@HKLD$pMM HT$ HL$p   DBoHL$p?  ,HD$ LD$8HT$HHsLM   E3HD H
> OHHu'Ht HA B   : P#    E33HAH+u
HCHP0H0 HIA A   : T#    IL|$ L$h  L;%   3 HHu'Hܸ H@ sA   9: q#  0  ID$H; t~H; tuI< HHu*H H@ $A   9 w#  I  H@L   MuAHS Hl@ @   9 y#  Iz  II$IH$   MHMu@H H9FuH;N   HFH<H;N   H|HHH$   HAHHD$ H9  H$   H$   Ht
H)uHAP0HGL   HEA HMtA HH   E3H\@ HLLHt~H/u
HGHP0IIH  u5I.u
IFIP0ML$P  H$   IL|$    H H? ?   K8 #    HǶ H> ^?   $8 #    H H> 7?   7 #    
 HtEH~ HHk
t 'HP Hi> >   7 #  z  H.u
HFHP0IL|$0H$   LcIu'H H> >   \7 #  S  HT$pIfHXH+HHL$puL;t|H$   HL$pHH$   HL$pD Ht'Hz H= >   6 #    H$   HL$pPHIurL$   H$   HIfDH$   	  Hu'H H= =   b6 #  Y  HD$(Ht  HHu'Hɴ H< `=   &6 #    HD$(HH8H)uHAP0HD$(HX8H$   HtH]`(  HMtISbD$P  A HHu'H; HT< <   5 $        HHu'H H< <   ^5 $  +  HXH\$(HHX   E3H$   HL$`L$   Ld$hL|$(AH|$ L$P  Ht$0  E3H$   HL$`L$   Ld$hL|$(AAL$P  Ht$0  H$   LH$   HtH)u
HAP0LIIAL   Hy; IMtA HHu'H H; ;   T4 "  !  ML$P  H H9G   LwL$P  MttHwIHHHH)uHAP0IH:FHHu'Hs H: 
;   3 #     I.u
IFIP0ML$P  4HEHHu$H H8: :   |3 #  LH/HGHP0H$   HT$`E3H$   L$P  AAL|$(HT$hIHtH+u
HCHP0HtH/u
HGHP0MtI.u
IFIP0HtH.u
HFHP0D: 2 H
F IH\$(HL$`Ht
H)uHAP0HL$hHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0HtH+u
HCHP0H$   HtH)uHAP0H$   Ht(H$   H]L$   L+IHLD$8MM H$P  HL$8   DBoHL$8訸LD$HMM H$P  HL$H   DBoHL$HwHH  A_A^A]A\_^[H\$UVWAVAWH`H H3HD$XH5 WHt$PMHD$@Me  LzIMt3Ht"HtH[  Hr(Ht$PHB HD$HHjHl$@Hl$@I HIMtHt,HtCjH0 I HD$@HH   HH<0 I HD$HHtwHHr  H^0 Iͥ HtHHD$PHHI  H
 IHD$(LL$@H L|$ 8y
!     Ht$PHl$@  H
 H HD$0   L
 HD$(L H HD$    H	 !  xHBH   H   HCH 3HD$0HL
+
 L\ HHH& HD$(HL$ LMH
m HF H	 !  H H5 H6 r  / Ar  H
 @3!Hr(HB HjHD$HLD$HLHkHL$XH3nH$   H`A_A^_^]H\$Ht$WH H5j5 HH
@4 H HHtH HFHHu'H H5 5 p  H. D!     H H9CuHH` HHuH
 H
4 . F!  .E3HHBHHurHq H4 - H!  4 p  H/u
HGHP0HtH+u
HCHP0D4 H
 - 3H\$0Ht$8H _H/u
HWHR0H+u
HSHR0HH\$0Ht$8H _@UVWATAUAVAWHl$H0  HEH$  H| H3HE(LHUHHL$pHME3D|$PL|$8L|$@
HD$8EL|$HL;L{
HD$P   AAAWEWMEHE   L}D}ID$H; tsH;1 tjIL|$XI} LHD$`Hu'Hɪ H2 `3 i  &,      H@H   HD$hHun,      MLd$`I$L|$X3HD$hD  Hu=Hd I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03H 98uIE        II HH  H@L   H1 HMtA HH|  H/u
HGHP0HCL   HE1 HMtAj HH   H+u
HCHP0II" HH  H@L   HD2 HMtA HH  H+u
HCHP0    HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM譔HHMHUHtLE L+IWEH] HUHtLEL+ICա H  IHMHHMlHMӕ H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
A  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8#H]HUHK@uHKXHU腍Lt$`L|$XLmLeHD$hyHZ3 H
 H	 h/ j  .(    33B  K/ l  (    )  2/ l  '      / k  '        / k  '       . k  '    3   . k  '    3   . k  w'    3   . k  \'    33sh H   H
؜ LI;   HH    }      @t3HIH    &    33. i  Hd H}- MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
z 3H\$pcX I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8H|MtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<tQ HAH;rA H+Hs1 H'v$ HHE   HE    E HUHtLEL+IHUHtLEL+I轰LD$8MM HUHL$8s   DBoHL$8HHM(H3H$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  HIt H3HE(LHUHHL$pHME3D|$PL|$8L|$@pHD$8EL|$HL;L{WHD$P   AAAWEWMEHE   L}D}ID$H; tsH;њ tjIL|$XI LHD$`Hu'Hi H*  + W  #     H@H   HD$hHun#     MLd$`I$L|$X3HD$hD  Hu=H I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03H 98uIE        II\ HH  H@L   H) HMtAK HH|  H/u
HGHP0HCL   H( HMtA
 HH   H+u
HCHP0II HH  H@L   H) HMtA HH  H+u
HCHP0   Z HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM譕HHM~HUHtLE L+I踽WEH] HUHtLEL+I蓽u H  IHM舣HHMHMsE H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8#H]HUHK@2HKXHU%Lt$`L|$XLmLeHD$hyH* H
 H	 ' X      33B  & Z   @   )  & Z   ?     & Y   -      & Y  f *      & Y  M (   3   l& Y  2 %   3   Q& Y   "   3   6& Y       33s H   H
x LI;   HH    }      @t3HIH;       33% W  H H% MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
 *H\$pc I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8H[tMtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+Hsё H'vđ H3HE   HE    E HUHtLEL+I&HUHtLEL+I
LD$8MM HUHL$8   DBoHL$8谣HHM(H3AH$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH   HEHX)p)xHk H3HELL3H|$PH|$XHD$PH|$@H|$H
HD$@H}H}HE   H}@}DH|$0L;=J uEL Hz H
 H	 H; HT" " 	   m  X  L-  H I$ HHu7 HuI'H H! |" 	  B o  X  HHDu$< HtE" 	   q  I  H/u
HGHP0E,$L;=[ u>H H
 H	
 HS Hl! ! 
   ~  X  HL# I  HHu'H H.! ! 
  r   W  HDu$o Htx! 
  >   ?H  H/u
HGHP0El$L;= u>H H
5 H	< H H  !      8W  H I.  HHu'HG H`         V  HHMӛHHMWHM辅 Ht    _   `G  H/u
HGHP0IL$HEH;tIE3HUL;= u>H H
= H	D H H $       @V  H I6  HHu'HO Hh       V  H H;uA   (H(Dy   p   qF  H/u
HGHP0E+  H
" )HHu'H H V 
     rU  H@L   H5 HMtA LHu 
     T  H+u
HCHP0IFL   H/! IMtA4 HHu'H H.  
  r   T  I.u
IFIP0E3L;=Î u0HR H
k H	r ` 
  &   T  H  Ir  LHu0 
     S  3HL$0LkH I9E -  HSHT$0H  H{HHHHH)uHAP0HT$0LoH I9E uYHULuA   HUHv+HHu 
  Z   LS  HL$0H)uHAP03HL$0       HHu'H
 H
 < 
     S  HL$0HH3HL$0Lp E3E3HH)HHu 
     R  H.uEHFH9IH'HHu 
     sR  I.u
IFIP0H+u
IE HP03HGH H;   H;ϊ    HX LHuN 
   
  3C  H/u
HGHP0IFH   E3IH3HtPDnIHHt?IH2#y 
     Q  M).   IFI   I.u
IFIP0E38#uI$ 
  X   JQ  HOHtF~A   H H
; H	 
Hx#D 
  
   3B  H;u
Hw H_H_HsHHHH/u
HGHP0H]HuHHMHHL$PpLEMM HT$8HMڮ   DBoHM舚HHMLHHL$@omLEMM HT$8HM觭   DBoHMEIL$(HT$PpIL$8HT$@mL;= u@Hϱ H
8 H	? H H     X  3
P  H I/  HHu)HH Ha     Z  3O  HO H9GuwH (=+ f.z*u( Ht   O \  33I@  H/u
HGHP0At$HL;= u@Hg H
@ H	G H H '    i  3O  H I7  HHu)HP Hi     k  3N  HHMړHHM^~HM} Ht   f m  33`?  H/u
HGHP0IL$XHEH;tIE3HUL;= u@H H
@ H	G H H '    z  3N  H I7  HHu)HP Hi     |  3M  HÀu( Ht   u ~  33o>  H/u
HGHP0A\$xL;= u@Ho H
h H	o H H O      3=M  H I_  HHu)Hx H       3L  HÀu(· Ht      33=  H/u
HGHP0A\$yL;= u@HO H
 H	 H H w   =   3eL  H I臹  HHu)H H 7      3%L  H@L   H HMtAi HHu      3<  H/u
HGHP0HV Ht'H
 H#    g   K  H.u
HFHP03A\$|L;= u>HC H
\ H	c H H C   	   3K  Hm IU  HHu'Hn H    
   J  HHMHHM~zHMy Ht'H H4    x
   J  H.u
HFHP03I$   HEH;tIE3HU L;= u>H` H
Q H	X H H 8      (J  H IJ  HHu'Hc H|       I  HÀu2 Ht'H H8    |   I  H.u
HFHP03A$   L;=ƃ u>H H
n H	u H H U      EI  Hw Ig  HHu'H H       I  H
 ,HHu'HE H^       H  H@L   H HMtA HHu   \   Z9  H/u
HGHP0A   HH HHuS      H  H.u
HFHP03H+u
HCHP03HDy   
   8  H/u
HGHP0E!  L;= u>H H
 H	ǁ H H)    m
   G  H1 I蹴  HHu'H҈ H i   /
   YG  H[ H HHu8   	   7  H/u
HGHP0H HQ HHu   	   F  H+u
HCHP03HDu$ Ht   w	   u7  H/u
HGHP0E$   L;=À u>H H
k H	r H H R   	   BF  H Id  HHu'H} H       F  H H=~ HHu      6  H/u
HGHP0H5 H} HHu   h 	  WE  H+u
HCHP03HDu$S Ht\   "    6  H/u
HGHP0E$   L;=n u>HŪ H
 H	 Hf H       D  H I  HHu'H( HA       D  H H| HHu   T   R5  H/u
HGHP0H	 H| HHuM       D  H+u
HCHP0HGL   H
 HMtAq~ HHu
    #  4  H/u
HGHP0H~ Ht
    &  nC  H+u
HCHP0A$   L;=} u>HJ H
s~ H	z} HÄ H Z
     3  JC  H Il  HHu'H H 
    5  C  H HE{ HHu    7  B  H+u
HCHP0H] H{ HHu   p :  n3  H/u
HGHP0Hu$^} Htg   - =  B  H+u
HCHP0A$   L;=y| u>H  H
!} H	(| Hq H     J  A  H
 I  HHu'H3 HL     L  A  H
 Hy HHu   _ N  NA  H+u
HCHP0H
 Hy HHuX    Q  2  H/u
HGHP0Hau$| Ht    T  @  H+u
HCHP0A$   L;='{ u>H H
{ H	z H H8
 
   | a  @  H@ Iȭ  HHu'H H	 x
   > c  h@  Hj Hx HHuG
   
 e  ?  H+u
HCHP0H9 H`x HHu
    h  0  H/u
HGHP0HϽ@@u$z Ht	    k  s?  H+u
HCHP0A$   L;=y u>Hǥ H
xz H	y HȀ H _	    % x  O?  H
 Iq  HHu'H H !	     z  ?  H HJw HHu     |  >  H+u
HCHP0H H	w HHu    u   s/  H/u
HGHP0Hu$cy Htl    2   !>  H+u
HCHP0A$   L;=~x u>H H
&y H	-x Hv H 
 !      =  H	 I  HHu'H8 HQ  !      =  H	 Hu HHu !  d    S=  H+u
HCHP0H0 Hu HHu] !  #    !.  H/u
HGHP0Hfu$x Ht !     <  H+u
HCHP0A$   L;=,w u>Hs H
w H	v H$~ H=  "     <  HE Iͩ  HHu'H} H } "  C   m<  Ho Ht HHuL "     <  H+u
HCHP0H Het HHu "     ,  H/u
HGHP0HԹ@@u$v Ht "     x;  H+u
HCHP0A$   L;=u u>HD H
}v H	u H| H d #  *   T;  H Iv  HHu'H| H & #     ;  H HOs HHu #     :  H+u
HCHP0H Hs HHu #  z   x+  H/u
HGHP0Ht H9CusHt (f.z&u$Ou HtX #     
:  H+u
HCHP0A$   L;=ht u>H H
u H	t H`{ Hy  $     9  H I	  HHu'H"{ H;  $     9  H Hq HHu $  N   =9  H+u
HCHP0H Hq HHuG $  
   *  H/u
HGHP0Hr H9CusHks (f.z&u$s Ht $     8  H+u
HCHP0A$   L;=r u>H H
s H	r Hy H  %  P   z8  H I蜥  HHu'Hy H L %     <8  H> Hup HHu %     7  H+u
HCHP0H H4p HHu %     (  H/u
HGHP0H<q H9CusHq (f.z&u$ur Ht~ %  D   37  H+u
HCHP0A$   L;=q u>Hu H
6r H	=q Hx H   &     
7  H I/  HHu'HHx Ha    &     6  H Ho HHu  &  t   c6  H+u
HCHP0H Hn HHum  &  3 	  1'  H/u
HGHP0Hu$!q Ht*  &     5  H+u
HCHP0A$   L;=<p u>HK H
p H	o H4w HM  '     5  HU Iݢ  HHu'Hv H  '  S   }5  H Hm HHu\ '  "   5  H+u
HCHP0H Hum HHu '      %  H/u
HGHP0Hdu$o Ht '   #  4  H+u
HCHP0A$   L;=n u>H! H
o H	n Hu H y (  ? 0  i4  H  I苡  HHu'Hu H ; (   2  +4  H-  Hdl HHu
 (   4  3  H+u
HCHP0Hd H#l HHu (   7  $  H/u
HGHP0Hu$}n Ht (  L :  ;3  H+u
HCHP0A$   L;=m u>H H
@n H	Gm Ht H ' )   G  3  H I9  HHu'HRt Hk  )   I  2  H Hk HHu )  ~ K  m2  H+u
HCHP0H Hj HHuw )  = N  ;#  H/u
HGHP0Hk H9CusHl (f.z&u$m Ht )   Q  1  H+u
HCHP0A$   L;=+l u>H H
l H	k H#s H<  *   ^  1  HD I̞  HHu'Hr H | *  B `  l1  Hn Hi HHuK *   b   1  H+u
HCHP0H] Hdi HHu
 *   e  !  H/u
HGHP0HCL   H HMtA.k HHu *  z h  i0  H+u
HCHP03H[Djk Hts *  9 k  7!  H/u
HGHP0E$   L;=j u>H4 H
-k H	4j H}q H  +   x  0  H I&  HHu'H?q HX  +   z  /  H Hg HHu +  k |  i   H/u
HGHP0H Hg HHud +  *   /  H+u
HCHP03Hh H9GuwHi (f.z&u$i Ht +       H/u
HGHP0A$  L;=i u>H H
i H	h Hp H'  ,  k   .  H/ I跛  HHu'Ho H g ,  -   W.  HY Hf HHu6 ,       H/u
HGHP0H HOf HHu ,     -  H+u
HCHP03HUg H9GuwHh (f.z&u$h Ht ,  ]   [  H/u
HGHP0A$  L;=g u>H H
Oh H	Vg Hn H 6 -     &-  H IH  HHu'Han Hz  -     ,  H H!e HHu -       H/u
HGHP0H Hd HHu -  L   ;,  H+u
HCHP0H
  HHuI -     
  H@L   H@ HMtA}f HHu -       H+u
HCHP0A   HHre HHu -       H/u
HGHP0H.u
HFHP03Hwyw -  =   ,+  H+u
HCHP0g  L;=e u>H H
1f H	8e Hl H  .     +  H I*  HHu'HCl H\  .     *  H Hc HHu .  o   ^*  H+u
HCHP0H Hb HHu'Hk H Z .      J*  H.u
HFHP03Hau$e Ht .     )  H+u
HCHP0A$  :*  L;="d u>Hq H
d H	c Hk H3  /  w   )  H; IÖ  HHu'Hj H s /  9   c)  He Ha HHuB /     (  H+u
HCHP0H H[a HHu'H\j Hu  /     (  H.u
HFHP0H
M HHu /  |   k(  H@L   HU HMtAb HHup /  6   %(  H.u
HFHP0A   HHa HHu- /       H+u
HCHP03H/u
HGHP0Hy'H?i HX  /     '  H.u
HFHP03'  L;=a u>H] H
b H	a Hh H u 0  ;   e'  H I臔  HHu'Hh H 7 0     ''  H) H`_ HHu'Hah Hz  0   	  &  H.u
HFHP0H H_ HHu 0  }   {  H/u
HGHP0H` H9FuvH` (f.z4u2Ra Ht'Hg H M 0     =&  H.u
HFHP0A$   p&  L;=X` u>H H
 a H	` HPg Hi  1   0  %  H	 I  HHu'Hg H+  1  o 2  %  H
 HHu'Hf H n 1  4 4  ^%  H@L   H HMtA_ HHu( 1   6    H/u
HGHP0A   HH^ HHu 1   9  $  H.u
HFHP03H+u
HCHP03H蚢Dy 1  _ <  ]  H/u
HGHP0E  L;=^ u>Hq H
R_ H	Y^ He H 9 2   I  )$  H IK  HHu'Hde H}  2   K  #  Hu H$\ HHu 2   M    H/u
HGHP0HD H[ HHu 2  O P  >#  H+u
HCHP03HDu$:^ HtC 2  	 S    H/u
HGHP0E$   L;=U] u>HD H
] H	] HMd Hf  3   `  "  Hn I  HHu'Hd H(  3  l b  "  H  HZ HHuu 3  ; d  9  H/u
HGHP0H HZ HHu4 3   g  !  H+u
HCHP03H;Du$\ Ht 3   j    H/u
HGHP0E$   L;= \ u>H H
\ H	[ Hb H  4  U w  !  H I衎  HHu'Hb H Q 4   y  A!  H HzY HHu  4   {    H/u
HGHP0Hj H9Y HHu 4   ~     H+u
HCHP0HGL   H^ HMtA[ HHu 4  O   M  H/u
HGHP0HRB[ HtK 4         H+u
HCHP0A$   L;=]Z u>H H
[ H	Z HUa Hn  5       Hv I  HHu'Ha H0  5  t     H( HW HHu} 5  C   2  H+u
HCHP0H/ HW HHu< 5        H/u
HGHP0H@@u$Y Ht 5       H+u
HCHP0A$   L;=Y u>Hm H
Y H	X H_ H  6  [     H I觋  HHu'H_ H W 6     G  H HV HHu& 6       H+u
HCHP0Hx H?V HHu 6       H/u
HGHP0HGW H9CusH	X (f.z&u$X Ht 6  O   >  H+u
HCHP0A$   L;=W u>H( H
AX H	HW H^ H ( 7       H I:  HHu'HS^ Hl  7       Hd HU HHu 7     n  H+u
HCHP0H HT HHux 7  >   <
  H/u
HGHP0HU H9CusHV (f.z&u$W Ht 7       H+u
HCHP0A$   L;=,V u>H H
V H	U H$] H=  8       HE I͈  HHu'H\ H } 8  C   m  H HS HHuL 8       H+u
HCHP0Hf HeS HHu 8       H/u
HGHP0HmT H9CusH/U (f.z&u$U Ht 8  u   d  H+u
HCHP0A$   L;=T u>H H
gU H	nT H[ H N 9     >  H I`  HHu'Hy[ H  9        H H9R HHu 9       H+u
HCHP0HQ HQ HHu 9  d   b
  H/u
HGHP0H S H9CusHS (f.z&u$9T HtB 9       H+u
HCHP0A$   L;=RS u>HY H
S H	S HJZ Hc  :       Hk I  HHu'HZ H%  :  i     H HP HHur :  8   '  H+u
HCHP0HL HP HHu1 :       H/u
HGHP0HQ H9CusHUR (f.z&u$R Ht :       H+u
HCHP0A$   L;=Q u>H H
R H	Q HX H t ;  :   d  H I膄  HHu'HX H 6 ;     &  H H_O HHu ;       H+u
HCHP0H HO HHu ;   "    H/u
HGHP0H&P H9CusHP (f.z&u$_Q Hth ;  . %    H+u
HCHP0A$   L;=xP u>Hπ H
 Q H	'P HpW H  <   2    H I  HHu'H2W HK  <   4    HC HM HHu <  ^ 6  M  H+u
HCHP0H HM HHuW <   9    H/u
HGHP0H`u$P Ht <   <    H+u
HCHP0A$   9  L;=!O u>H H
O H	N HV H2  =  v S    H I  HHu'HU H r =  8 U  b  H
l HHuE =   W    H@L   H HMtAyN HHu =   Y    H/u
HGHP0A   HHnM HHu =   \  q  H+u
HCHP03H.u
HFHP03HqDyp =  6 _  4  H/u
HGHP0E  L;=M u>H(~ H
)N H	0M HyT H  >   l     H I"  HHu'H;T HT  >   n    H HJ HHu >  g p  e  H/u
HGHP0H HJ HHu'HS H R >   s  B  H.u
HFHP03HK H9GuwHtL (f.z&u$L Ht >   v    H/u
HGHP0A$   L;=L u>H| H
L H	K HR H  ?  Y     H I~  HHu'HR H U ?     E  H H~I HHu$ ?       H/u
HGHP0H H=I HHu'H>R HW  ?       H.u
HFHP03H5J H9GuwHJ (f.z&u$nK Htw ?  =   ;  H/u
HGHP0A$     L;=J u>Hy{ H
*K H	1J HzQ H  @       H3 I#}  HHu'H<Q HU  @       H
 HHuv   mH@L   HR HMtAI HHu=   4H.u
HFHP0A   HHH HHuG   - @  E3H{P H H  H/  HGHP0  H/u
HGHP0H+u
HCHP0H؅y'HP H6  @  z     H.u
HFHP03  L;=H u>Hy H
lI H	sH HO H S A     C  H Ie{  HHu'H~O H  A       H H>F HHu'H?O HX  A     
  H.u
HFHP0H  HE HHu A  [   J
  H+u
HCHP0HFL   H HMtAG HHu'HN H 1 A     !
  H.u
HFHP03HG Ht A       H+u
HCHP0A$   L;=G u>HJx H
G H	F HM H  B  X     H Iy  HHu'HM H T B     D  H H}D HHu# B       H+u
HCHP0H H<D HHu'H=M HV  B       H.u
HFHP03H۫u$F Ht B  U   D  H+u
HCHP0A$   L;=E u>Hw H
IF H	PE HL H 0 C        H IBx  HHu'H[L Ht  C     
  H HC HHu C     v
  H+u
HCHP0H HB HHu'HK H r C  8   b
  H.u
HFHP03Hyu$$E Ht- C     	  H+u
HCHP0A$   L;=?D u>Hu H
D H	C H7K HP  D     	  HX Iv  HHu'HJ H  D  V   	  HR HA HHu_ D  % 	  	  H+u
HCHP0H HxA HHu'HyJ H  D      	  H.u
HFHP03Hu$C Ht D       H+u
HCHP0A$   L;=B u>Ht H
C H	B HI H l E  2   \  H I~u  HHu'HI H . E       H HW@ HHu E        H+u
HCHP0H H@ HHu'HI H0  E  t #    H.u
HFHP03H赧u$`B Hti E  / &    H+u
HCHP0A$   L;={A u>Hbs H
#B H	*A HsH H 
 F   3    H It  HHu'H5H HN  F   5    H H> HHu F  a 7  P  H+u
HCHP0H H> HHu'HG H L F   :  <  H.u
HFHP03HSu$@ Ht F   =    H+u
HCHP0A$   L;=@ u>H(r H
@ H	? HG H*  G  n J    H2 Ir  HHu'HF H j G  0 L  Z  H, H= HHu9 G   N    H+u
HCHP0H HR= HHu'HSF Hl  G   Q    H.u
HFHP03HJ> H9CusH? (f.z&u$? Ht G  R T  A  H+u
HCHP0A$   L;=> u>Hp H
D? H	K> HE H + H   a    H I=q  HHu'HVE Ho  H   c    H H< HHu H   e  q  H+u
HCHP0HF H; HHu'HD H m H  3 h  ]  H.u
HFHP03H4@@u$> Ht# H   k    H+u
HCHP0A$   L;=5= u>Ho H
= H	< H-D HF  I   x    HN Io  HHu'HC H  I  L z  v  HH H: HHuU I   |  
  H+u
HCHP0H/ Hn: HHu'HoC H  I       H.u
HFHP03Hf; H9CusH(< (f.z&u$< Ht I  n   ]  H+u
HCHP0A$   L;=; u>H?n H
`< H	g; HB H G J  
   7  H IYn  HHu'HrB H 	 J        H H29 HHu      H+u
HCHP0Hl H8 HHu'HA H  J  Y      H.u
HFHP03H蚠   A; H      < J  E3HA H HtH+u
HCHP0MtI.u
IFIP0HL$0Ht
H)uHAP0HtH.u
HFHP0H
l )H+u
HCHP0A$   HMHt
H)uHAP0HMHtH)uHAP0HM.LD$@MM HT$8HL$@~\   DBoHL$@ILD$PMM HT$8HL$P@]   DBoHL$PHHMH3cL$   I[PA(sA({IA_A^A]A\_^]HUVHhH8  3HXHxL`LLhDLpDLxDHt$xHt$8HuHt$(7 Hu'H? H r    8     LHD$06 Hu'H? H 8         A$H؉MXHD$ 7 HHu'H]? Hv      (  M     8 HHu     *  ><  HxE3H
+6 HHHu    W /  &>  H+u
HCHP0H LI5 yQ     2  ;  H/u
HGHP0AL$M`6 HHu,Hm> H\$ H     ſ <  X  Ha LIm5 y     >  E;  H/u
HGHP0IL$DHHu,H= H\$ H     G H    H# LI4 yQ     J  :  H/u
HGHP0AD$H=6 HHu,Hn= H\$ H      ƾ T  Y  Hz LIn4 y     V  F:  H/u
HGHP0A8t$PtH+7 H H=!7 H 5 H H=5 Hu,H< H\$ H d    * `    H LI3 y4     b  9  H/u
HGHP0A8t$xtH6 H H=6 H4 H H=z4 Hu,H6< H\$ HJ      l  !  H LI63 y    ^ n  9  H/u
HGHP0A8t$yt~IL$XBHHu,H; H\$ H C    	     H LI2 y    ټ   8  H/u
HGHP0A8$      I$   BHHu,H"; H\$ H6     z   
  H LI"2 y    J   7  H/u
HGHP0H
n HHu,H: H\$ H 4         AL$|Mh3 LHu'H
`: H
y        9  Ha2 LkHt$(I9E   HSHT$(H  H{HHHHH)uHAP0HT$(H4 LoI9E   HUA   HUL}H;HHuY       8  HL$(H)uHAP0Ht$(I/u
IGIP0H+u
IE HP0H
 LH|$x/HH=  HD9 H]        H\$ LLl$0HL$(Ht
H)uHAP0MtI.u
IFIP0D H
[ T 菙$     1 LHu'H
8 H
 O       7  HL$(E3HHILx HHt$(LHHu    ѹ   7  I.IFIIHHH       Z7  H@HH L   MtA0 HHu    E   4  H/u
HGHP0A   HI/ HHu<       6  H+u
HCHP0Ht؅y    ˸   u4  H/u
HGHP0  IFIH( L   MtA!0 Ll$0HHu/H6 LH\$ H     R   H LI- y\    "   3  H/u
HGHP0A$   L$@/ HHu/Ht6 LH\$ H     ɷ   0H LIq- yӾ       C3  H/u
HGHP0A$   L$HJ/ HHu/H5 LH\$ H z    @   H LI, yJ       2  H/u
HGHP0A$   L$P. HHu/Hb5 LH\$ Hs      (  H# LI_, y     *  12  H/u
HGHP0A$   L$X8. HHu/H4 LH\$ H h    . 4  Hʹ LI+ y8     6  1  H/u
HGHP0L, IH + y/HO4 LH\$ H` ޼     @  A8$   tHF. H H=<. H;, H H=1, H\$ Hu*H3 LH |    B I  H LH* yL    L K  L0  H/u
HGHP0A$   /, HHu*H`3 LHv      U  !H LHb* yĻ    L W  L90  H/u
HGHP0A$   + HHu*H2 LH l    2 a  Hv LH) y<    L c  L/  H/u
HGHP0A$   + HHu*HP2 LHf      m  H LHR) y    Lw o  L)/  H/u
HGHP0A$   L$`E* HHu*H1 LHܹ Z      y  HL LH( y*    L {  L.  H/u
HGHP0A$   L$h) HHu*H<1 LHR й       H: LH>( y    Lc   L.  H/u
HGHP0A$   L$p1) HHu*H0 LHȸ F       sH LH' y    Lٱ   L-  H/u
HGHP0A$   ( HHu*H*0 LH@        H0 LH,' y    LQ   L-  H/u
HGHP0A$  q( HHu*H/ LH 6       cHx LH& y    Lɰ   L{,  H/u
HGHP0A$  ' HHu*H/ LH0     t   H@ LH& y~    LA   L+  H/u
HGHP0H
ҷ }HHu/H. LH\$ H %       RA$   M' LLHu       -  HZ& LkI9E Z  L{MM  H{HIHHH)uHAP0H( LoI9E    A   L}HULuHCHHua    '   ,  I/u
IGIP0LI.u
IFIP0H+u
IE HP0HGHHi L   M   A      && HD$(Huڵ       o,  LxE3Lp HHLLHHu    c   2,  HL$(H)uHAP0Ht$(CIHwHHQ       +  % HHu*       )  H/u
HGHP0Ll$0LH< I# y       w+  HLH\$8HHu
HCHP0H
2 ݾHHu*H+ LH     P   B+  H@HH L   MtA$ HHuD    
   *  H+u
HCHP0A   HI# HHu    Ǭ   t(  H/u
HGHP0Hgyʳ     	  \*  H+u
HCHP0tyA$  M>$ HHu*H* LH s    9   +*  H LHL$ !   =       )  H
 RHHu*Hk* LH     ū *  )  H@HH L   MtA3# HHu     ,  K)  H+u
HCHP0A   HI(" HHuv    < /  &  H/u
HGHP0H?fy?     1  (  H+u
HCHP0txA$   $" HHu*HU) LHk      <  (  H LHL$ U        y >  E(  H
 ȻHHu*H( LH u    ; R  -(  H@HHH L   MtA! HHu/     T  '  H+u
HCHP0A   HI  HHu     W  _%  H/u
HGHP0Hdy    } Y  I'  H+u
HCHP0H
 輺HHu*H' LH i    / q  !'  H@HH< L   MtA  HHu#     s  &  H+u
HCHP0A   HI HHu     v  S$  H/u
HGHP0Hcy    o x  ;&  H+u
HCHP0L9	  H
8 裹HHu'H& Hծ S       &  A$   M HD$(LHu       #  H LgI9$W  LwMJ  H_HIHHH)uHAP0H  LcI9$   A   LuHULmHoHHu    S   #  I.u
IFIP0LIm u
IEIP0H/u
I$HP0HCHH L   M   A      Q LHu    ͦ   }"  LpE3ILh HHt$(L躺HHuȭ       >"  I/u
IGIP0LGIH覸HH    F   !   HHuY       Ht$(#  H+u
HCHP0H
 LH}RHHu,Hk$ H     ȥ   Ht$(#  H@HH L   MtA1 HHu    }   Ht$((!  H/u
HGHP0A   HI! HHuo    5   Ht$("  H+u
HCHP0H3`؅y3       Ht$(   H/u
HGHP0)  H\$ LC HH) { y,H8# HQ ϫ       Ht$("  Ll$0H IN  HHu,H" H	     M   Ht$(?"  H HS HHuQ       Ht$(  H/u
HGHP0Hf LI y    ң   Ht$(!  H+u
HCHP0Ht$(  H
 HHu,H" H4     x   Ht$(e!  H@HH L   MtA HHug    -   Ht$(   H+u
HCHP0A   HI HHu       Ht$(  H/u
HGHP0H]y       Ht$(s   H+u
HCHP0-  H\$ L HH٩ + y,H  H     E   Ht$(7   Ll$0H IL  HHu,H  H 7       Ht$(  H H HHu    ǡ   Ht$(  H+u
HCHP0H LIZ y       Ht$(-  H/HGHP0Ht$(D  H
C 讲HHu,H H ^    $ *  Ht$(  H@HH$ L   MtA HHu    ٠ ,  Ht$(  H/u
HGHP0A   HI} HHu˧     /  Ht$([  H+u
HCHP0H[؅y    U 1  Ht$(   H/u
HGHP0Ht$(  H\$ Lª HH  y,H H &     <  Ht$(  Ll$0HF I.J  HHu,HG H` ަ     E  Ht$(  Hˣ H HHu    n G  Ht$(  H/u
HGHP0H LI q_    % J  Ht$(  Ll$0H\$ IH L i	  Hw H     Ԟ g    H
 #HHu'H< HU ӥ     z  H@HHv L   MtA HHu    S |    H+u
HCHP0A   HI HHuJ         H/u
HGHP0HYy    ٝ     H+u
HCHP0  IFIH6 L   MtA/ Ll$0HHu/H LH\$ H     `   H LI yj    0     H+u
HCHP0A$   L$p HHu/H LH\$ H     ל   >H LI y       p  H+u
HCHP0A$   L$hX HHu/H LH\$ H
     N   Hң LI yX         H+u
HCHP0A$   L$` HHu/Hp LH\$ H     ś   ,H9 LIm yϢ       ^  H+u
HCHP0A$   L$XF HHu/H LH\$ H v    <   Hx LI yF         H+u
HCHP0A$   L$P HHu/H^ LH\$ Ho        H LI[ y       L  H+u
HCHP0A$    HHu/H LH\$ H f    ,   H LI y6         H+u
HCHP0A8$   tH H H H H Hy Hu/H5 LH\$ HF Ġ       H^ LI2 y    Z   #  H+u
HCHP0A$   L$H HHu/H LH\$ H ;       hHՠ LI y    ј     H+u
HCHP0A$    HHu/H% LH\$ H6     z   H LI" y    J     H+u
HCHP0H
 艩HHu/H LH\$ H 1       ^A$   M LHu    ŗ   r  Hi LgHt$(I9$b  LoLl$(MP  H_HIE HHH)uHAP0H LcI9$   A   LmHUL}HGHHue    +     Im u
IEIP0Ht$(I/u
IGIP0H/u
I$HP0HCHHj H\$8L   M   A      " LHu؝     *  N  Lx E3ILhHHt$(L苪HHu    _ 0    I.PIFIAIHyHHS         
 Ll$0HHu/H LH\$ H     ו @  >Hk LI y     B  p  H+u
HCHP0H\$ IE IL$  L$  L$(  H$0  MtIm u
IEIP0L$   HtH+u
HCHP0HL$xH$P  Ht
H)uHAP0HL$8Ht
H)uHAP0HEHtH(u
HPHR0HH8  ^]H
 +HHu'HD H] ۛ     V  H@HH L   MtA HHu    [ X  $  H+u
HCHP0A   HI HHuR     [    H/u
HGHP0HOy     ]    H+u
HCHP0  IFIH> L   MtA7 Ll$0HHu/H LH\$ H$     h h  Hę LI	 yr    8 j    H+u
HCHP0A$   L$@
 HHu/H LH\$ H     ߒ t  FH LI y     v  x  H+u
HCHP0A$   Ma
 HHu/H LH\$ H     W   H LI ya    '     H+u
HCHP0A8$   tH
 H H
 H H H Hu/H` LH\$ Hq        H LI] y       N  H+u
HCHP0H
 ĢHHu/H LH\$ H l    2   A$   M LLHu7         H LoI9E b  LMU  H_HIHHH)uHAP0H
 LkI9E    A   L}HULu H芥HHu    n     I/u
IGIP0LI.u
IFIP0H/u
IE HP0HCLH HH\$8L   M   A      e HD$(Hu    ߏ     LxE3Lp HHLLΣHHuܖ       R  HL$(H)uHAP0Ht$(;IH趡HH    V      HHu*H
 LHڕ X       
  Ll$0LH I y#         H+u
HCHP0H
 (HHu*HA
 LHW Օ         H@HH8 L   MtA	 HHu    U   !  H+u
HCHP0A   HI HHuL       	  H/u
HGHP0HIy    ۍ     H+u
HCHP0,H
ߐ HHu*H+ LHA        w  H@HH L   MtA HHuy    ?     H+u
HCHP0A   HI HHu6         H/u
HGHP0HGy    Ō   
  H+u
HCHP0  A$    HHu*H LH'     k   ]
  H LI yu    ;   
  H+u
HCHP0A$   ^ HHu*H
 LH #       	  H LI y       	  H+u
HCHP0A$    HHu*H
 LH#     g   Y	  H LI yq    7    	  H+u
HCHP0A$   Z HHu*H	 LH      *    HI LI  y     ,    H+u
HCHP0A$    HHu*H		 LH     c 6  U  H LI  ym    3 8    H+u
HCHP0A$   V HHu*H LH      B    H LI  y     D  }  H+u
HCHP0A$     HHu*H LH     _ N  Q  HC LI  e    + P    H
G zHHu*H LH '     d    H@HH L   MtA[  HHu     f  s  H+u
HCHP0A   HIP  HHu    d i    H/u
HGHP0HgCyg    - k    H+u
HCHP0~A$   H  HHu*Hy LH 
    Ӈ v    Ho LI{  yݎ     x  o  H+u
HCHP0A$     HHu*H LH
     Q   C  H
 LI  y[    !     H+u
HCHP0A$   D  HHu*Hu LH 	    φ     H LIw  yٍ       k  H+u
HCHP0A$     HHu*H LH	     M   ?  H LI  yW         H+u
HCHP0A$   @  HHu*Hq LH     ˅     H LIs  yՌ       g  H+u
HCHP0A$     HHu*H LH     I   ;  H LI  O         H
I dHHu'H} H     ڄ   4H@HH L   MtAH  HHu΋       ]  H+u
HCHP0A   HI=  HHuO    Q   LLH\$ H H H+  H/!  HGHP0  H/u
HGHP0H?y         H+u
HCHP0Ll$00L IH k  y/H( LH\$ H9     }   L)  IH_ !  y/H LH\$ H m    3   A$   f  HHu/H LH\$ H &       SH|$ LHp H  y          H+u
HCHP0A$     HHu-H LH! H    b   H^ LH
  ydl    2   LLH  Hƈ HtH+u
HCHP0H\$ MbI/XIGIP0IH+u
HCHP0H[ HLI|  'H5  LHK Ɉ       HUATAUAVAWHhH@  HEHXHpHx H H3HE8L3HL$XHL$`HL$hHL$pHE0   HM(MHE   HMMDDDE3Hk H
$ HHu'Hh  H  y   ŀ o  	  HHL$XL`hA$AAD$AIL$zHHu'H  H,  }   p   	  LHL;
  t;MIL H  H
m  H	$  b }   (     HKH)uHAP0HsIL$ HHu'H}  H  ~      		  LHL;
Z  t;MILe HV  H
  H	  ̆ ~      N  HK H)uHAP0Hs AD$8C(3  Hu'H  H w    =   l  HHD$`I\$@I;\$H4  IE3ff     HCH+HHHD$xHLL$@D$8  DL$0HD$(LL$ A   LD$xAQH~ HH  H   HHHD$hHt
H)uHAP0LGHG HE3AL;AL9G tHHGJ4I@HGHH;  tE3HI;\$H,NH  HԄ R    ~ 	  G  H  H +    }      3  HHu'H]  Hv     }     I\$XI;\$`   D  HEH;tIE3HHMd&H IE3HUHML&HE   LmDmIE3HUHM(&HI  HD$(HM(  HHteHVH9V ~H HNHHJHNHH  uH/u
HGHP0I;\$`A2    | '        | %  n  Ht$pH
a HHu'H  H.     r| 4    H@L   Hk HMtA  LHu'H  Hڂ X    | 6    H/u
HGHP0   f  HHu'Hw  H     { 9    HHpHD$`H HG E3HH
߄ 躏LHu'H
#  H
<     { A  Z  H/u
HGHP03IvH  H9.  I~H!  I^HHILH)uHAP0HsH  H9u`H}L}A   HUHHHu'Hz  H     z V    H/u
HGHP03        LHu'H
)  H
B     z f  `  Hx3Lx E3E3IHvHHu'H  H v    <z l  +  Im uSIEIGII\HHu'H  H ,    y O    I/u
IGIP0I.u	HIP0E3L|$XIO0H)uHAP0I_0I$  HHu-H  H6     zy   E3E3N  IO@H)uHAP0I_@A$  AGHI$  HM	H
:  HL$(H#  HHu-H  H 5    x   E3E3  IOPH)uHAP0I_PI$  HHu-HG  H`     x   E3E3x  IOXH)uHAP0I_X3  HHu-H  H     Rx   E3E3&  I$  I;$    HEH;tIE3HHM H IE3HUHM HE   HE    E IE3HUHM H  HD$(HM"  LHt^HNH9N ~H HFL4HAHFIHt  u#I.u
IFIP0I;$  :   [w   
Ow   E3E3o~    H  H} H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0MtI/u
IGIP0MtIm u
IEIP0D} v H
x U3L|$XIO`H)uHAP0Iw`IIMtI/u
IGIP0HL$`Ht
H)uHAP0HL$hHt
H)uHAP0HL$pHtH)uHAP0HEHrPHHMH=   r<t  HAH;r  H+Hs  H'v{  HHE   HE    E HMHHM8H3NL$@  I[8Is@I{HIA_A^A]A\]@SH H  HH HI`H)uHAP0H  HC`3H [@SH H  HH HI`H)uHAP0H  HC`3H [H\$WH LJHL;
x  HtrH;L  tiH
  L MIHY H	  H9  HR{ { [   t     H
 A[   SH\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH HS  HH HIXH)uHAP0H5  HCX3H [@SH H  HH HIXH)uHAP0H  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H  HH HIPH)uHAP0H  HCP3H [@SH H  HH HIPH)uHAP0H  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0H  H)t$ H9BurH  (f.5 zTuRH  HtGH  Hw Cx X   	q     H
m AX   2P(t$ H0[sH3(t$ H0[KH(AH  Hu;H  H6w w X   zp     H
N AX   O3H(H(AH  Hu;H  Hv Tw X   p     H
 AX   CO3H(@SH HS  HH HI@H)uHAP0H5  HC@3H [@SH H  HH HI@H)uHAP0H  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H  HH HI8H)uHAP0H  HC83H [@SH H  HH HI8H)uHAP0H  HC83H [H\$WH LJHL;
x  HtrH;|  tiH
+  LT MIH
 H	  Hi  Ht  u V   m A  A  H
 AV   LH\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H  HH HI0H)uHAP0He  HC03H [@SH HC  HH HI0H)uHAP0H%  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H  H)t$ H9BurHE  (f.5
 zTuR  HtGH  H5r r T   yk     H

	 AT   J(t$ H0[s(3(t$ H0[KH(A(Y  Hu;H  Hq $r T   j z  z  H
 AT   J3H(H(A(  Hu;H-  HFq q T   j z  z  H
 AT   I3H(@SH H  HH HI H)uHAP0H  HC 3H [@SH H  HH HI H)uHAP0He  HC 3H [H\$WH LJHL;
X  HtrH;,  tiH
  L0 MIH H	  H  H2p p S   vi -  -  H
 AS   HH\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH H3  HH HIH)uHAP0H  HC3H [@SH H  HH HIH)uHAP0H  HC3H [H\$WH LJHL;
  HtrH;  tiH
K  L MIHy H	  H  Hn  o R   g 
  
  H
 AR   GH\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;  AE3H;  A3H;  DEuHR  DEEtR  HtGHb  H{m m Q   f 
  
  H
 AQ   EH\$0H _È_3H\$0H _;H(y tH  H H
  H  H H  Hu;H  Hl Um Q   f \
  \
  H
  AQ   DE3H({H\$WH HH+C؃uO  HtDH:  HSl l P   e 3
  3
  DCQH
  DH\$0H _É_3H\$0H _kH(IL$0  Hu;H  Hk Bl P   e 
  
  H
  AP   1D3H(H(IL$0  Hu;HK  Hdk k P   d 
  
  H
  AP   C3H(H\$Hl$Ht$WH Hh HH
#  E333_xHHu'H  Hj _k q   %d   O  HCHH"h L   MtA  HHuc      H  H9C  H{H  HsHHHHH)uHAP0HHuHHuH
  H
0j ~c   QH/u
HGHP03H+u
HCHP0     HH   9c   H  Hi Qj q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HWHR0Di H
S  b A3cHtHH6b   XH
a HHHHh Hp(H
  HH
  HH0H
  HH
  HH8H\$0Hl$8Ht$@H _@UAVH8HBE3H;  AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH;  t[HH  HHu'HA  HZh h m   a ;    H@L   Mu^a =  J  HIIMMu>H  H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HIm  HHtFLHI  tH+aHCHP0Rg n   ` j     g n   ` h  k  H   H
  LI;   HHD9   }      @t3H6IH  ug0` X  Vg m   H  Hf HtH/u
HGHP0HtH+u
HCHP0Dg H
  _ ?   H/u
HGHP0L5&  IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH Hc E3H\$0E3HHt$8H
d_ H|$@
HHu2H-{  H  He #f f   HE ^     HXHH
2i Hc HAL   MtAH  HHu'H)  HBe e h   ^   H  H*  IH9C   H{H   HsHHHHH)uHAP0HHxpHHu&^   uH/u
HGHP0IH+u
HCHP0HHue  HHu]Hn  Hd e i   ]   {HoHHu]   H0  HId d h   HtD2Hx)HHubH  Hd d i   ^]   H+u
HCHP0HtH/u
HGHP0Dbd H
  %] `<&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*H  E3Hc c i   W\ V      LHu'H  Hb \c i   "\ W  Z  IFHHHu-H
i  L
  H6 H	  [ Y    HAH;h  tWH;  tNH  HHuH
<  H
Ub [ ^  ~  H@L   Mua[ `  Q  H3E3H@ Mu>H  H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtAQ  HHtNH+u
HSHR0IVLI3O  uH/HGHP0hZ   5  YZ   &  H
  L  HO4 H	  ,Z      9  Ht H  HH/     H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$hILl$`H A^A\_^[0Y {  3H  H_ F` i   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D_ H
  X 7H\$Hl$Ht$H|$ AVH H\ HH
W E3=HHuH  ,  H   H
W HxHH5,c L5` H-_   HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`  H+u
HCHP0HG4  H  H/^ W ^ i   Ai   H
  6H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtH  HH [ H [@SH HYhHtHY  HH [H [H(HB      tHAL   MtA	  Hu;H  H] ] `   JV 
  
  H
  A`   s53H({H   HD$   Ht
33P
HĈ   H(HHH  ȅx3H(@SH H9  HuJ  Hu7HӍH  HHt#H
N  HH	  H+u
HSHR03H [H H [@WH@HD$ H\$XH H3HD$0HHL$(LL$xHAHyrH	HH;}HH33  E3MtA  HHHHL$0H3AH\$XH@_LAL9A ~HHAJI@HA3H%Q  LYE3HA EHL;AL9Y AEtHHAJICHA3H%  HAL   MtIH%    HUHhH   HEHXHpHx H^ H3HEGHHM3u^E   HE   Hu@uDFH  HM#HE   Hu@uDFH  HMHuHE   Hu@uIE3HUHMHE7   Hu/@uIE3HUHMHUH   HM%HMHEHrPHHMH=   r<tO  HAH;r?  H+Hs/  H'v"  HHE   HuE HEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  H'HE   HuE A   Hb  HMHE   HuE A   HO  HMzE9   E9   HE   HuE IE3HUHMwHE7   Hu/E IE3HUHMRHUH   葙HM藽HM莽HM脽HMzHHMGH3L$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+HwHCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;v  H    H=   r<t  HAH;r  H+Hs  H'v  H'H3HsHsHH\$@Ht$PH0_@SH Hw H1HH  1HH> 0HHSQ 5HH47  H+ H0HH  0HH 0HHP 4HH6j  H H0HHi  t0HH e0HHO 4HH6H [H%  H(HA   0HHf6H(H%  @UVWATAUAVAWH$H@  Hǅx  H$  H3 H3H8  LD$pHT$PHMH  L  ML  MLt$hHM誴WD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8H|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8tH|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
a   H
S ս  3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM`3H]Mt`IrAfof IHfHnflfHAfHnflfLHH;rI;s     HHI;rL% L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH  cH H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  H H   L   L  L   L   HUH   GL   H   H   H   H   رE3AL}H   H   HMI+HL   H;vdM9s
HH;rbH  HD$x3HEHEH HD$XD$`HUHL$XP  H) HD$xHR HL$xH
 %  H HE Lu(Le0HEH+HHE8HUHM@ELE0HU8HMXHU8H   ILuHU8H   HMI+HLE(H;vdM9s
HH;rbH  HD$x3HEHEH HD$XD$`HUHL$Xc  H< HD$xHQ HL$xH
 8  L%  LeHT$hHULmH  HEWD$PWM LmLD$PHM   HHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  軮Hۥ H  HE(H  HE0H  HE8H  HU@H  {H  HD$XL% L  HE`H   HEhH  HEpH  HUxH  连H   H0  H; HH  H   HP  H   HX  H   H`  H   Hh  ϭH  HD$XL  H   H  H   H  H   H  H  H  H   H  jHz H@  HH  HD$XL% LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX  Ld$xH  HEHE   LmE IE3H  HMHH  HD$(H  HD$ LH  L@  HT$xHTHHU HtLEL+IHH   Ht%L   L+I(Wf   L   HMXHU@HtLEPL+IWfE@LmPL%٩ Le H   Ht%L0  L+IWf   L0  H   H   Ht%L   L+IWf   L   L   L- L  H  ^L  L  L  H  =L  MtLEM+IIHtH+HLHMtLEM+IIHH8  H3;H$  H@  A_A^A]A\_^]@SH H` HD$0H+_ H
` HH\$0H;sSH_ HT$0H;wBH\$0H+HH;
_ u   H
_ KH
_ H_ Ht9HH)H;
_ u   H
_ H
_ Ht
HH
_ Hb HD$0H+b HHH
]_ H
_ H\$0H;sSHm_ HT$0H;wBH\$0H+HH;
`_ u   H
B_ H
>_ H/_ Ht9HH)H;
*_ u   H
_ _H
_ Ht
HH
^ Hbb HD$0H+Nb HHH
^ H
 a H\$0H;sSHa HT$0H;wBH\$0H+HH;
` u   H
` H
` H` Ht9HH)H;
` u   H
` H
` Ht
HH
` HH^ H
` H
^ 腦H^ H
^ rH^ H
^ H [ZHXH] H9]    HRH
u] H\$P3H] H
` H-}] HRH-] La H
_ IH` H+HHYH;s>@ HHtH   L` H` IHH+HH;rH
_ HQ蝔H-u_ H\$PHXHh  D$(HD$0HT$83HL$ HD$8HD$@HY  HD$   HO HL HD$0HL$07HXHu\ H9f\    H9\ L_ H_ H,\ H_ H_ IH+H\$PH3Ht;     HHtH   L_ H_ IHH+HH;rHf\ H\$PHz_ H\     HH]\ H~\ H HHi\ HXH-  D$(HD$0HT$83HL$ HD$8HD$@H  HD$ ò  H HuK HD$0HL$0H\$WH H      ?HAH
![ H9
[ HZ u	H=Z HIHH+Z HHkHH<H;sfD  HKHHPH;wH\$0H _HZ H+zZ H
Z HH+AHyZ H9jZ @WH H
{  5  HHu H
.  H'  H	  H _H6  H\$0HH  H/Hu
HWHR0Hu%H
q  H  H	Y  H\$0H _HT  H9Ct9H
  H  H	'  H+  HCHP0H\$0H _3H*  H+H= uHCHP0H= Hu%H
  H  H	  H\$0H _=	  H= tA	  H  %  
Hy= s4  A
   H  H
  DH		  H\$0H _  u	H  t%Hd  H
ݴ  H	̳  H\$0H _3H\$0H _3H%  H(HuA      %     H(HtIw  3H(3HtIv   "     "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[oHHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHHH\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=      Hh)|$@)t$Pf(
 f( fYf(% f(
 f\ ff(fXf~Ё  fYf@  fYx fff\L      ??f\f(6 fsA~$@     f( f(fYfs4fA$fYfYfX fX fYfYfYfXfX ffXfY(t$P(|$@Hhf     ??f\f( fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0L f(5Q f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(z ff ff(5a ff5d fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$P(|$@Hh     HH)|$ )t$0f( f( fYff(% f(
 fXf:	 f(f~Ё  fYf@  fY fff\L      ??f\f(H fsA~$@     f( f(fYfs4fA$fYfYfX fX fYfYfYfXfX ffXfY(t$0(|$ HHfff     ??f\f( fsA~$ L f(5 f(fYfs4fA$fYfYfX5N fX6 fYfYfYfXfX5 ffXfYf( ff ff(5 ff5 fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5 ff5  A~0  fA0  fff(5 ffffYf(t$0(|$ HH     %b  %T  %.  %  %  %  %  %  %  %  %  %  %¨  %Ĩ  %n  ff     @UH HE t
e HMP萠H ]@UH HE t
e HMp`H ]@UH HE t
e HMP:H ]Hp  Hp  Hp  Hp   HH   THp   Hp  ܟHp  Hp  ğH`   tH`   H4H`   HTH`   H(H`   H@H`   HXąHH   āH@   ČHH   鸌H(   $@UH HE t
e HMH`H ]@UH HE t
e HMH@H ]H8   鴓@UH HE te H   =H ]HP   $HP  hH`   鴄H`   H餄H`   HH锄H`   H`鄄H`   HxtHP   ķH@   鴷H`   餷HX   锷H    @UH HE te HM`H     H ]H`   HH%`  H`   HP  hH@   H  HH@  <H`  0H@   H`  H@  Hx   HX   H8   ܜH   H   HH   H   HH0   H0   HP   H    H@   HH   H   H   XH   LHP   @HP   4H@   (H@   H(   ěH(   鸛H(   HP  锛H0  8H0  |H0   H0  dH0  XH0   H0  @H0  4HP  $H0  H0  H0  H0  H0   H0  ܚH0  КH`   HP   HH`   HP   HH`   Hh   H`   HHh   H`   HHh   |H`   H0lH(   HH   H(   HH   H`   4<Hp   H`   H@H@  鴙@UH HE te HM@H     H ]H@   H H%$  H0   H%Ο  H@   
H@  NHT$UH HLE0H0 HMHL HHMh HMHHEhH   HCEhH
  HMH3HMPHMXHE0E8HUPHM0  HF HEHA   H HMH HH   闘Hh   鋘HH   鏲HT$UH HLE H` HM8L HHMXHM81HEXH}pHCEXH
$  HM83HM@HMHHE E(HU@HM Ȟ  Hy HE8A  H HM8H8   ʗHX   龗H8   ±HT$UH HLE H HM8OL HHMXHM8qHEXH}pHCEXH
d  HM83HM@HMHHE E(HU@HM   H HE8A  H8 HM8H8   
HX   H8   Hp   HP   HT$SUH(HHMHHHPHH;uHAH HHEHLE0I HO H   ?L7 HHMPLHHMpHMPQH   DHEpH   HCEpH
4  HMP3HMXHM`H   ƅ   HUXH   Ϝ  H HEPA@  Hw HMPH   ѕHP   ŕHp   鹕HP   齯H   TH   HH   H4H   H({H   H@wH   HX{H   hOH   {Hh   wH8   WH   H   \{Hh   P{H8   WH   ؔH0   tH(   H(   HP   LH   @UH HE0te0H   H ]H   OH   CH   7H`   zH   HT$SUH8HHǅ      Hǅ       ƅ    A4   H' H   KH]8HH   HP@H   蹓Hǅ      Hǅ       ƅ    A   H H   HH   HP@H   eH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   H  HEH3HEPHEXHj HE8E@HUPHM8  HM HEHH9 HMHH   霒H   鐒H   鄒@UH HE0te0H   H ]H   KH   ?H   3HH   xH   Hx   oxHT$SUH8HHǅ      Hǅ       ƅ    A*   H H   ;H]8HH   HP@H   詑Hǅ      Hǅ       ƅ    A   H H   HH   HP@H   UH   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   tHH   HP@H   H  HE`3HEhHEpHZ HE8E@HUhHM8  H= HE`Hr7 HM`H   錐H   逐H   tHp   dHP   XHp   LHP   @HT$UH HHǅ      Hǅ       Ep A/   H$ HMpsHM HHUpP@HMpH  HE03HE8HE@H^ HE E(HU8HM   HA HE0Hv6 HM0Hp   鐏HP   鄏Hp   xHT$UH HHEh   HE`    EP A/   Hb HMPHM HHUPP@HMP(H)  HE03HE8HE@H HE E(HU8HM ƕ  H HE0H5 HM0HP   ΎH(   鴎HP  餎H0  阎H0  錎H0  逎H0  tH0  hHP  \HP  PHP  DH0  H0  ܶH0   жHP  H`   $mH   D0H   (H   H@H0  čH0   hH0  鬍H(   锍H(   鈍H(   |H(   pH(   dH(   XH(   LHp  4HP  (H  H  H  H  HP  Hp  HP  ԌHp  ȌHP   lHX   餌H8   阌Hx   錌HX   逌H8   tHX   dH8   XHX   LH8   @Hx   4HX   (H8   HX   Hx   H   4H   (H   HP   HX   HP   HP   HH@   H@   H    H    H   TH@   HH`   <H   $HH   Hh   HH   H   Hp   ܊HH   ЊH   ĊH@   H   |HH   TH@   HP   4H   H   H@   H@   HtHh   (HH   H   Hh   HH   HH   Hh   H`   ԉH   ȉH@   鼉H`   鰉H@   餉H0   H0   H    H    H@   dH`   XH   LHH   4Hh   (H   H   H   H   H   H   ԈH@   HH   DH@   H8   HX   0HP   H0   HH    <H0   HlH0   H8H0   Hp|H0   H   iH    H@   HH   H@   H@   H 4nHH   H@   H8@UH HE$t
e$HMP@dH ]H   ~HX   RHX   FH@   H    cH`  <H@  0H@  $H@  H@  H@   H@   H@   H@   H04mH@   HH$mH@   H`mH@   H   QpH@   H   lH@   H   +pH@   H   HP   hH8   lH  <H  0H  $H  xlH  H   H  H  H  <lH  ЅH  ąH  鸅H  鬅H  項H  锅H  kH  |H  pH  dH  XH  LH  @H  4H  (H  |kH  H  H  H  H  H  ԄH  ȄH  鼄H  kH  餄H  阄H  錄H  逄H  tH  hH  jH  PH  DH  8H  ,H   H  H  H  H  PjH  H  ؃H  ̃H  H  jH  騃H  霃H  鐃H  鄃H  xH  lH  iH  TH  HH  <H  0H  $H  H  H   H  H  H  <iH  ЂH  ĂH  鸂H  鬂H   iH  锂H  鈂H  |H  pH  dH  XH  hH  @H  4H  hH  H  H  H  H  LhH  H  ԁH  ȁH  鼁H  鰁H  餁H  阁H  錁H  送HT$UH0HHMxJLHMpmHx   H`   gH`   THH   gH@  cH0  H  H  HP  H  H0  8gHT$UH0HHǅ(     Hǅ       ƅ   A   H H  H8  HPLH  H  HH  葛H! H  tH  AH  5H  )H  H  HP  H  H0  MfHT$UH0HHǅ(     Hǅ       ƅ   A   HF H  H0  HPLH  H  HH  覚H  H  H  VH  JH  >H  2HP  &H  H  HP  H  ~H0  JeH0  >eHT$UH0HHǅ       Hǅ(      E33H  jA#   He H  H  HPLH  H  HHX  荙H HX  pH  =~H  1~H  %~H  ~H  
~HP  ~H  }H  IdHT$UH0HHǅ       Hǅ(      E33H  uA'   Hȶ H  H(  HPLH  H  HH  蘘H H  {H  H}H  <}H  0}H  $}H  }H  }HP   }H  |H  |H  <cH  0cHT$SUH8HH H  }HH   HRLHH  
HHp  譗H Hp  H  ]|H  Q|H(   D|H(   8|H(   ,|H(    |H(   |H(   |H(   {H(   {H    锤HH  {H(  {Hh  {H(  {H  {H(  {H  {H(  {H(  x{H(  l{H(  `{H(  T{H(  H{H(  <{H(  0{H(  ${H0   ģHP  {H0  zHp  zH0  zH  zH0  zH  zH0  zH0  zH0  zH@   H`H@   H `H@   H@dH@   HXPoH@   H@zH@   H(@UH HE t
e HMHoH ]HT$UH0HHM8HPH
  HMh3HMpHMxHE@EHHUpHM@  Hy HEhH HMhH   _HP   _H   ,H  pyH8   [@UH HE4te4H   _H ]H   _HH   x_H   鼡H   yH0   d[Hh   H_@UH HE@t
e@HMx _H ]H   ^H  xHH   [H`   4H8   Z@UH HE0te0H   ^H ]H`   H`   HpH`   HX  mH`   Hp  WH`   H  lH`   H  WH`   H  %^H`   H  "ZH`   H  lH@   lH    xlHH   lw@UH HHU@HMH
H ]@UH HHU@HMHH ]HT$SUH8HH]PHHtJHS4HKH+H*HHLI?LH胓H    HC    HC    33پHT$SUH8HH]PHHtJHS}9HKH+H*HHLI?LHH    HC    HC    33iHT$SUH8HH]PHHt3HS5HLCL+I誣H    HC    HC    33HT$SUH8HH]PHHt3HSm5HLCL+IJH    HC    HC    33谽H`   tu@UH HEhtehHMPH   {  H ]HP   H H%z  HX   H%{  @UH HEPtePHM@H   h{  H ]H@   H H%z  H8   DWHT$SUH8HH]PHHtJHSM2HKH+H*HHLI?LH3H    HC    HC    33艼HP   $HP   H ]H(   ZHT$SUH8HH]`HHtJHS6HKH+H*HHLI?LH蓐H    HC    HC    33H@   sH(   tH@   H%y  HT$UH HHUhHUhH能HExHH ]HT$SUH(HH]`HCHr\HHHv{  H=   r<tw{  HAH;rg{  H+HsW{  H'vJ{  H蹯HC   HC    H{rH 33H(   H(   HT$UH HHUpHHcHHA   v  HH ]H(   TH(   騦HT$UH HHUpHHcHHA   v  HH ]H(   H(   XHT$UH HHUpHHcHHA   Gv  HH ]Hh   qHH   q@UH HE0te0HMPH   w  H ]HP   HH%Pw  HP   tH  XqH@  LqH`  @qHh   tH`   hHh   \H`   HLHh   @H`   H(0H(   ԤH(   ؇HT$UH HHUPHHcHHA   u  HH ]H(   養@UH HE t
e HM@ppH ]H   iH   iH
Y  Hh   (pHH   pH(   PH   pH   oH   oH    HP   t\H   oH   o@UH HE0te0HMPH   u  H ]HP   H H% u  H@   H%u  HP   H  JoHp  >oHP  2oHT$UH0HH
H0]HT$UH0HH
H0]HT$UH0HH
H0]HT$UH0HHH0]HT$UH0HH:H0]HT$UH0HHZH0]HT$UH0HHzH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HHH0]HT$UH0HH:H0]H  餦H   HZH  LZH  @ZH0  HP  HmH  H  @H  ]@UH Hp   H  H ]H8  aH  H   鰦H   4SHP  H   SHP  aHh  aH   lH   lH  lH   RHp  RHP  \lH  PlH0  DlH0  Hp  ,lH0  UHp  aH  lHp  UH0  PRHP  DRH8   4RH   鈅HT$UH0H趾33ӳH8   QH   HHT$UH0Hv33蓳H8   QH   HT$UH0H633SH8   tQH   ȄHT$UH0H33H  H  ؄H8   QH  H  鴄HP   PH  霄H   PH  tjH  hjH  PH  PjH  DjH  PH  ,jHX   jH8  jH  jHx  iH  iH8  iHX  iHx  iHT$UH HH   蓩LH   H   6@UH HE t
e HM0p^H ]H8   ^iHH   R@UH HE te H   HH ]H0   KH0   sK@UH HH   H   观H ]@UH HH   H   腂H ]HH   hH(   hH`   H%m  HP   H%m  @UH HEPtePHM@HP<H ]@UH HE0te0HMPH   n  H ]HP   H H%m  H@   H%Zn  HP   閐H  gHP  gHp  gH@   gH`   gH8   gHX   g@UH Hꋅ   t   HM(HPFH ]@UH HX   HM@H ]HT$SUH8HH]PHHtJHS)HKH+H*HHLI?LH蓃H    HC    HC    33@UH H0   H   ~H ]@UH Hꋅ   t   HM(k  H ]H   H%k  @UH HEHteHHM@H   l  H ]H@   H H%k  HP   H%zl  H8   @UH HEPtePHM@HP̗H ]H@   :bHT$SUH(HH] HKm  HK m  HK(m  33譭HT$SUH8HHU0HM8%LE@HU833u@UH HE0te0HMPH   k  H ]HP   HH%j  HP   H  d@UH HE0te0H@  H   -k  H ]H@  HH%j  H@  H  dH0  dHP  udHp  id@UH HE0te0HM`H   j  H ]H`   HH% j  HP   H%zj  H`   H  c@UH HE0te0HP  H   ?j  H ]HP  HH%i  HP   H%j  HP  H  cH@  cH`  ycHP   H   @UH HE te HM0HP H ]H0   H8  PH0  PH0   FH
 麙@UH HX   H@  謟H ]@UH HE te H@  HP藔H ]H   HH   @UH HE te HM0HPPH ]H0   H8  OH0  OH0   jFH
 @UH HX   H@  ܞH ]@UH HE te H@  HPǓH ]H   HH0   dA@UH HE te HM`H   g  H ]H`   H H%$g  HP   H%g  H`   
H`  NaH`   CHH   GH   aHP   tC@UH HE@te@H   AGH ]H   4CHx   GH  \HT$SUHHHHǅ     Hǅ      ƅ   E3Hq  H  ۛH   HH  HP H  F`Hǅ     Hǅ      ƅ   An   H|  H  耛HH  HP H  _H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  HH  HP H  _Hǅ     Hǅ      ƅ   A   H)  H  轚HH  HP H  /_Hǅ     Hǅ      ƅ   Ah   H  H  iHH  HP H  ^; E@HHH][H  ^H  ^H  ^H  ^H  ^H  'HH   kSH  _^H  DH  H   H  DH  ӆH   @H`   hDH  鬆H  EH  H(  FH   H  BH  iH@   RH  ]H   CH  9H  }]H  !H  e]H  CH  H  CH  H  )]H  ]H  ]H  ]H   d?H`   HCH  錅H  EH  HH  DH   H  AH  IH@   QH  \H   BH  H  ]\H  H  E\H  BH  ݄H  BH  ńH  	\H  [H  [H  [H  D>H   (BH  H   H   H   Hx   PH   $H   HP  =Hp   AH   |H   @H  =Hp   xAH   LH   PdHP  d=Hp   HAH   H   p@H  4=Hp   AH   H    ]H   =H   @HX   |OH   pZHx   餼Hx   阼H   tH   sH   @HP   @H   sH8   h@H  YH  YH   D@H  YH  YHh    @H  YH  YH  YH  YH  YH  xYH  lYH  `YH  TYHp  H   <YHp  H   $YHp  ȁH   YH   YH  XH  H?H   XH`  XH@  XH   XH  XH  XHT$UH HHp  gLHh  致Hp  
H   rH   rH   >HP   >H8   >H  XH  XH   `>H  WH  WHh   <>H  WH  WH  WH  WH  WH  WH  WH  |WH  pWHp  H   XWHp  H   @WHp  H   (WH  WH  WH  d=H   VH`  VH@  VH   VH  VH  VHT$UH HHp  胖LHh  裲Hp  &HX   tVH8   hVHT$UH HHU HMP33cHT$UH HHU HMP333@UH HHUPHMXoH ]HT$UH HHUPHMh33@UH HE0te0HMPH   \  H ]HP   HH%`[  HP   鄹H`  hUH@  \UH   QH   QH  $UHx   jH  UH  }H  TH`   H;H  L7H@   0;@UH HE\te\H   H   [  H ]H   H H%=Z  H  H%Z  H   #}H  gTH  }H  |H  CTHX   4TH8   (THx   TH   TH8   THX   SH   SHx   SH8   SHX   SH8   SHX   SH(   SH(   SH(   SHp   H   餵H(   TSH(   HSH(   <SH(   0SH(   $SH   dH  XH0  LH  @H   $H   H   Hx    Hh   Hh   H   ԴH   ȴH   tRH  hRH  \RH   PRH   DRH  8RH  ,RH    RH   RH  RH   gH   gH@   4H  QH  QH  gH  tgH  hgH  \gH  PgH  4zH  7H  lQH  `QH  TQH  HQHp  4QH  (QH  QH  QHp  QHT$UH@HHǅ     Hǅ      ƅ   AB   H H  1Hǅ     Hǅ      ƅp   A?   HF Hp  Hǅ     Hǅ      ƅ    MA"H H  蹋Hǅ      Hǅ      ƅ   E3Ht H  腋H  HD$ L  Hp  H  H  OHp  OH  OH  OH   qeH   eeH  OHp  OHT$UH@HH   vHH@]H  eHp  
eH  eHp  dH  dHT$UH@Ht EpHơH@]Hp  wHp  NHp  wHp  NH  NHp  NH  NH  NH  UdH0  NH  xNH   lNHP  `NH0  TNH  HNH   <NHP  0NH0  $NH  NH   cH   cH@   DH  MH  MH   cH  cH   xcH  lcH   `cH  DvH  3H   |MH   pMH   dMH   XMH  DMH  8MH  ,MH    MH  MHT$UH@HHǅ     Hǅ       ƅ   AB   H͔ H  AHǅ     Hǅ      ƅ   A?   HV H  
Hǅ     Hǅ      ƅ    MA"H H  ɇHǅ8     Hǅ0      ƅ    E3Hp H   蕇H   HD$ L  H  H  H  KH  KH  KH   KH   aH   uaH  KH  KHT$UH@HH   HHH@]H  )aH  aH  aH  aH  `HT$UH@H EpHH@]H  sH  JH  sH  JH  JH  JH  JH   JH  e`HT$UH0HL   HU8H      H   HH(H/H0]H0   sH0  HJH  tH  hH  \H  PH0  TH   8H   ,H    HT$UH HL   H   33ݑH@   HH@   HЫH@   H(H@   H8鰫H@   HH頫H@   HX鐫H@   H   =IH   /HH   $HX   ;H0   4HH   (HH   @UH HEPtePHM@HPzH ]H@   @UH HEPtePHM@HP\zH ]H@   ڱ@UH HEPtePHM@HPzH ]H@   AH   HHh   GHH   GH   GHH   GHh   GH@   H@   @UH HE0te0H   H   M  H ]H   H H%M  Hh   H%M  H   oH  ?GH  3GH   'GH  GHT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   Hސ H  2Hǅ     Hǅ      ƅ    A    Hw H   Hǅ     Hǅ      ƅ   A!   H H  āHǅ     Hǅ      ƅ    MA"H H  胁H  HD$ L   LCH  H  XXHH8][H  EH   EH  EH  EH@   ԧH@   ȧ@UH HE0te0H   H   K  H ]H   H H%J  Hh   H%K  H   mH  EH  EH   EH  DHT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   H H  Hǅ     Hǅ      ƅ    A    HW H   Hǅ     Hǅ      ƅ   A!   H H  Hǅ     Hǅ      ƅ    MA"H H  cH  HD$ L   LCH  H  8VHH8][H  CH   CH  CH  CHT$SUH8HH   H{  t'HM8HPHHK NHHI  HH8][Hh   TH`   HHh   <H`   H ,Hh    H`   H0H   H   $%H@   )HX   %HX    %@UH HHU0HM8:\H ]@UH HH   HM8\H ]@UH HE4te4H   (H ]H   $Hx   7H   ӃH  b@UH HE4te4H   H   <H  H ]H   H H%dG  HX   H%H  H   JjHT$SUH8HH  H   9NHx H  eAH]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  g|HH  HP H  @33H  @@UH HE4te4H   H   G  H ]H   H H%0F  HX   H%F  H   iHT$SUH8HH  H   MHx H  1@H]8tHH   HPHǅ     Hǅ      ƅ   A   H  H  S{HH  HP H  ?Hǅ     Hǅ      ƅ   A<   Hc  H  zHH  HP H  q?H  HHPHYH;uHAHc HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  jzHH  HP H  >H)H8][H  >H  >H  >HT$SUH8HH  H   GKHx H  s>H]8tHH   HPHǅ     Hǅ      ƅ   AH   H  H  yHH  HP H  >H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  &yHH  HP H  =33赅H  =H  v=H  j=H  ^=H  R=H  eH  #HT$SUH8HH  H  IHx H  =H]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  xHH  HP H  y<33薄H  c<H  W<H  K<H  ?<H  3<H  dH  dH  <H  <H  ;H  ;H  dH  ;H  tdHH   "H  ;H   "H  ;H  8dH  |;H  p;H  d;H  dH  L;@UH HEDteDH   H   A  H ]H   H H%@  H   H%cA  H   cH   :H   4!H  TH  TH8   !H  THP    H  :H  :H    H  h:H  \:Hp    H  D:H(  8:H  ,:H   :HH  :H  :H  9H(  9HH  9H(  9HH  9H    H  9H  9Hh  9H  9H(  9HH  x9HT$UH HH   ?yLH   _H   H@   H   HX   \HX   PH0   DH0   8Hp   LHT$UH0H/    HGH0]H(   -H   H(   -H@   -@UH HꋅH  tH  HM@H   >  H ]H@   H H%=  H0   H%>  H@   `H@  鄻Hx  tH   XHp   ,HT$UHpHHRHp]H   H   YH   H   Hx   ̙HT$UHpHHWHp]H   饽H   H   =Hx  H   Hp   \HT$UHpHH[Hp]H   5H   H   DH   (Hx   HT$UHpHH`Hp]H   ռH   鉽H   }Hp   餘Hp   阘H   鼹H   @+HT$SUHxHHǅH     Hǅ@      ƅ0   A!   HP  H0  lqH   HH0  HP H0  5H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  pHH0  HP H0  h5HhHx][H0  L5H0  @5Hx   tHx   hH   錸Hh  tH   XHp   ,HT$UHpHHclHp]H   H   H   H   Hx   ̖HT$UHpHHqHp]H   饺H   鹻H   }Hx  H   Hp   \HT$UHpHHuHp]H   5H   驻H   DH   (Hx   HT$UHpHHzHp]H   չH   IH   
HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H   H0  nH   HH0  HP H0  3H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  &nHH0  HP H0  2H~Hx][H0  |2H0  p2Hx   餔Hx   阔H   鼵H   42H`   (2H@   2H8   KH   DH0   ZHT$SUH(HH0  HM0>HXH0  1HtHM HHU0P33yH  1H@  1H`  |1H  p1H@  d1H`  X1H`   錓H`   逓HH   tHH   hH   \H   PH   DH   8Hx   ,Hx    H   YH   0H  0HT$UH0HMpMpp  ;|~U8Hz H   1HZz H`  1Hz H@  1H} H  1H   HD$ L`  LE8H@  H  BHH0]H    0H`  /H@  /H  /H(   $H@   (H  /H   /H@  /H  /H   t/H@  h/H   霑H   鐑H8   鄑H8   xH`   lH`   `Hp   THp   HH   <H   0H   WH   .H`  .HT$UH0Hꋍ      0  ;|~U4Hx H   /Hdx H@  /H(x H   /H{ H  /H   HD$ L@  LE4H   H  @HѬH0]H   
.H@  -H   -H  -H   $@UH HHEXD HUPHM(rGH ]@UH HEPtePHM@H`l_H ]H@   H`-H    $IH8   H-@UH HE t
e HMX萰H ]H@   TH   DH   $H(   H(   HH   H   @UH Hꋅ   t   HM(H`f^H ]@UH Hh   HM@1iH ]@UH HEPtePHM@HP^H ]H@   jH8   DH8   8H(   ,H`   $H  H  H  H  H0  H   ȍH   鼍H   鰍@UH HEPtePHM@H`<]H ]H@   jH   $+H  +H8  +HX   +H0   EH   ()H   *H  *H0   DH    'H(   H(   ،HP  DKHP  HtHP  H HP  H8HP  HPH@   8HX   H   H   tH  DH  DH@   PH  CHX   8H  )H  )H   H  )H  )Hp   H  )H(  x)H  l)H  `)HH  T)H  H)H  <)H(  0)HH  $)H(  )HH  )H  `H  (H  (Hh  (H  (H(  (HH  (HT$UH HH   hLH   蟄H   "HP   H8   H@   H`   鈊H   PHT$SUHHHH  H   4Hx H  (H]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  cHKHH  P H  x'H_HH][H  \'HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  |bH   HH0  HP H0  &H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  bHH0  HP H0  x&HcHx][H0  \&H0  P&Hx   鄈Hx   xH   霩HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  LaH   HH0  HP H0  %H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  `HH0  HP H0  H%HgHx][H0  ,%H0   %Hx   THx   HH   lHT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  `H   HH0  HP H0  $H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  _HH0  HP H0  $HkHx][H0  #H0  #Hx   $Hx   H   <HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  ^H   HH0  HP H0  W#H(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  v^HH0  HP H0  "HoHx][H0  "H0  "Hx   Hx   H   HT$SUH8HH]PHHtJHS]HKH+H*HHLI?LH>H    HC    HC    33IjHT$SUH8HH]PHHt3HSHLCL+IOH    HC    HC    33iH
 XHX   !HX   !HX   !Hx   !H   x!HX   l!Hx   `!H   T!H
) XH8   :Hh   ,!Hh    !Hh   !H   !H    H    H    Hh    H@   H
 WHX    HX    HX    Hx    H   x HX   l Hx   ` H   T H
1 WH    9Hh   , Hh     Hh    H    H   Hh   H@   $Hh   8H
} VH0   x9H   H   H   H   H   |H   pH@   4@UH HHU`HMP
9H ]HT$UH HHU`HMh33Gg@UH HHU`HMP8H ]HT$UH HHU`HMh33gHT$SUWH0HH   HO@aHO H[33f@UH HHUXHMPJ8H ]HT$UH HHMh>[33fHT$SUWH0HH   HO@QHO 8H [33Mf@UH HHU`HMP7H ]HT$UH HHU`HMh33f@UH HHUHHMP7H ]HT$UH HHM@~Z33e@UH HHUHHMPJ7H ]HT$UH HHM@>Z33eH
  THP   HHp   <H   0HP   $H   Hp   HP    HP   H(   $H(   H   6HT$UH Hzn33dH   鄤H0   H%#  HT$UH HHH ]H`   HH   Hx   HX   t~HP   h~H@   DH0   6H   XH   LHT$UH HHMHHt
H   33cHT$UH HHMHHt
H   33cH
 @RH8   hH8   \H8   PHX   DHx   8H8   ,HX    Hx   H
! QH8   H8   H8   HX   Hx   HX   Hx   H8   H
q `QH8   H8   |H8   pHX   dHx   XH8   LHX   @Hx   4H
 PHP   HP   HP    Hp   H   HP   Hp   0 HP   $ H
] PHP   HP   HP   Hp   H   xH   lHp   `HP   THT$SUWH0HH   HO@HO (HU33=aHT$SUWH0HH   HO@HO HU33`@UH HHE(D HUxHM0r2H ]HT$SUWH HH]pH   H;t-Hf     HK  H  H[(HCH;u33}`H  @UH HEPtePHM@HPJH ]H@   Z@UH HEPtePHM@HPIH ]H@   
H   H   yH   HyH8   HP   Hh   @UH HEPtePHM@HP,IH ]H@   z|HH   TyH   HDyH@   HH   XH@   HH   (@UH HEPtePHM@HPHH ]H@   yH   tH  hH8  \HX  PH0   T0H   {H   Hh  XH@   H8   4H   $xH(   Hh   xHh   wH   \@UHH3Ɂ8  ]@UH HM@H ]Q@UH HOM8H ]zQ@UH0HHHL$(T$ L
ORLEpUhHM`NH0]HH   @UH HE te H   H ]H0   OH`   CH0   7@UH HE te H   H ]H    	@UH HE8t
e8HMXr	H ]H`   `H   T@UH HE te H   H ]HX   H@   sH   gH0   k@UH HE te H   HH ]@UH HE te H   H ]HX   H@   H   H0   @UH HE te H   H ]H0   @UH HE te H   H ]@UH HE t
e HM@H ]HP   H   Hx   HP   H   Hx   H(   QH@   EH(   9H@   -HP   qH   eHx   YHP   MH   AHx   5HP   )H   Hx   HH   H0   Hp   H@   H    H   Hh   H0   ACH    eCH   HX   H@   HT$UH@HOH#  Hɫ G   
 
=  H~H@]H   Hx   H`   {HH   oHT$UH HNH>#  HW ի    56  H1H ]HX   !H@   HT$UH HSNH"  H {   A t5  HH ]H@   AH0   B@UH H  HMXMH ]HT$UH HMHm"  H    ʣ *%  H[H ]HH   AH8   AH   @UH H  H   LH ]HT$UH HVMH!  H  ~ y  D W"  HoH ]@UH H(  H   4LH ]HT$UH HLH!  H  z   f"  HzoH ]@UH H  HM KH ]HT$UH HLH&!  H?     ;#  HtmH ]HT$UH HSLH   H {   A #  HlH ]H8   '@@UH HEPtePH   @H ]H   H   &H8   ?@UH HEPtePH   ?H ]H   H   
HP   ]?H@   ?Hx   
H  
H   
HT$UH HHM(HPHH
  H	k  HBKH ]HT$UH HHM0HPHH
+  H	2  H	KH ]HT$UH HHM8HPHH
  H	  HJH ]HT$UH HHM@HHPH'H;uHAH0 HHEHH
v  H	  HtJH ]HT$UH HHMHHHPH&H;uHAH0 HHEHH
  H	A  HJH ]HT$UH HHMPHPHH
  H	  HIH ]HT$UH HHMXHHPL I;uHAH
0 HHEHH
  H	  HIH ]HT$UH HHM`HHPH%H;uHAH/ HHEHH
  H	P  H'IH ]HT$UH HHMhHHPL  I;uHAHR/ HHEHH
  H	  HHH ]HT$UH HHMpHHPL.	 I;uHAH. HHEHH
A  H	  HoHH ]HT$UH HHMxHPHH
   H	_  H6HH ]HT$UH HH5  H
  H	,  HHH ]H(   
@UH HE t
e HM0uH ]HX   	H8   	H   H	H   eH8   	HX   	H   H	H   {eHH   H   H8   H   H  CH  SCH  CHp   BH  KH  BH  H cH  H8QH  HpCH  OH   BH   H H   H8QH   HpH   NH   SBH   J@UH H꺸  HMP8EH ]Hp   BHp   IH   BH   H HX   AH   H8PH   >NHh   AHh   H BHX   AHh   H8PHh   MH0   ~AHX   rAH0   6JH  ZAH(H= r_H
˜ &!Hל HH=   r<t  HAH;r  H+Hs  H'vt  HCH    Hm     V  H( H(H= r_H
˛  Hכ HH=   r<t  HAH;r  H+Hs  H'v  HCCH    Hm     V  H(
 H(H= r_H
˚ Hך HH=   r<ta  HAH;rQ  H+HsA  H'v4  HBH    Hm     V  H(mH(H=, r_H
 FH HH=   r<t
  HAH;r
  H+Hs
  H'v
  HBH    H       H(H(H=, r_H
 H HH=   r<t!
  HAH;r
  H+Hs
  H'v  HcAH    H       H(-H(H= r_H
 H HH=   r<t  HAH;rq  H+Hsa  H'vT  H@HP    H=     &  H(H
ѵ 7H
 6H
ٴ H(H=|  t:=8Ly Hb L+IN3WHX     @ H(H(H=ܲ  t:Lٲ H² L+I2WH      H(H(H=\  t:LY HB L+I2WH8       H(MH(H=  t:=8L H L+IN2WHx     ` H(H(H=  t:L Hڴ L+I1WHд      H(H(H=<  t:L9 H" L+I1WH       H(H
 4H
! 4H
y tH
ٲ dH
	 TH
 DH
) 4H
i $H
I H
 H
Y  H
ɳ  H
i  H(H   H 4H
 HuH(         d                                             "     6     P     d                                        &     <     V     r     r                  j               *     n               d                                        .     Z     ~               ܽ          .     T               Ծ          $     f     ¿     
               6                         t     V     0                         f     *               d     "               L                    >               h                     V                    J                    H                         n     8     N                                                     @          X     b     x                                 (                       h                       ,                              
                    $                                           h     L     *                         @                            p     T     J          6                            z                                 ^             ȹ                    l     X     F     .           
          и                         t     `     P     @     2                         з     ·                    j     Z     :     ,                    Զ                         l     ^     N     >     ,                    
     ε               ڹ     x     d     P     @     ,                    Դ     ƴ                    x     ^     J     .                    ܳ     ȳ                    z     h     N     >     (                    ̲                          2     B     V     t     h     z               P          ʺ     ޺               8               (     <     P     h     |     &     
                    л                         0     D     b               ޵          ڱ     ±               z     \     J     8          
               Ȱ                       `    [           H         `             @    `                        0            P                      `                                                           0                    $2                                                           "   K             b            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        
   9              @   
           
           
   x@       bad array new length    
   40   `
   =   `    `    =   `    з
   d   p           OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np  `'   '   '   '   ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  ImportError 0   __getstate__.<locals>.genexpr   reshape misc    num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  0   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    Stan model {} is of mode 'test_grad';
sampling is not conducted.    shape   UNIT_E  get pystan._compat  iter_save_wo_warmup upar        adapt_window    &   data sim model_name model_pars par_dims mode inits stan_args stanmodel date     stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902 init_alpha  get stan_args_method_t  b   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  B   warmup2 __str__ traceplot   method  h   int_time    range   fitptr  H   pystan.plots    _summary    NUTS    lp__    array   append  i   (dense_e)   pystan  I   stansummary l   AttributeError  gradient    order   DIAG_E  L   sampling_algo_t pars    data_args   unit_e  q   ndarray is not C contiguous Q   adapt_t0    error   vars_i  f   pars_oi_bytes   epsilon adapt_iter  d   handler tol_rel_obj user    probs   chains  g   warnings    index   metric  Zf  __import__  Zd  collections Zg  stepsize    split   holder  O   extract (diag_e)    OPTIM   dstack  par grad_samples    _get_kept_samples   format  sim _pars_total_indexes s   chain_id    utf-8   double  s   ndarray is not Fortran contiguous   chains  end model_code  end TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   'char'  '   Couldn't allocate space for StanHolder. _verify_has_samples name    LBFGS   'long'  s   Metropolis  s   output_samples  dims_oi samples pystan.constants    throw   %s  _check_pars int string_types    _remove_empty_pars  =   _call_sampler_star  #   adapt_kappa keys    send    flush   =   row_stack   #   SAMPLING    start   =   MemoryError #   squeeze seed    variational =   init_list   #   save_iterations `inc_warmup` ignored when `permuted` is True.   data    
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          =   tol_rel_grad    BFGS    init_radius #   __test__    tuple   =   `dtypes` ignored when `permuted` is False.  #   sampling    inits   =   adjust_transform    value   #   _split_data =   RuntimeError    __getstate__    VARIATIONAL #   genexpr Format string allocated too short, see comment in numpy.pxd =   variational_algo_t  #   elbo_samples    tol_param   thin    inits   =   DENSE_E refresh adapt_term_buffer       Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. #   newaxis flatnames   flat    dtype   =   getLogger   #   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    Couldn't allocate space for stan_fit.   init    sampler_params  pystan.misc warn    numpy   =   digits_summary  numpy.core.multiarray failed to import  column_stack    adapt_delta #   stepsize_jitter fnames_oi   =   sampler_t   #   control random_seed =   numpy.core.umath failed to import   #   handlers    numpy   =   (unit_e)    numpy   #   logging adapt_init_buffer   =   Non-native byte order not supported #   diagnostic_file argsptr adapt_engaged   numpy.core.multiarray   C:\Users\appveyor\AppData\Local\Temp\1\tmpkyfodnd1\stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.pyx  adapt_gamma =   history_size    _call_sampler   numpy.core.multiarray failed to import  _ARRAY_API  #   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  =   _ARRAY_API is NULL pointer      numpy.core.umath        module compiled against ABI version %x but this version of numpy is %x  numpy.core.umath failed to import       module compiled against API version %x but this version of numpy is %x  FATAL: module compiled as unknown endian        _UFUNC_API      _UFUNC_API not found    FATAL: module compiled as little endian, but detected different endianness at runtime   _UFUNC_API is not PyCapsule object  #   _UFUNC_API is NULL pointer  =   SSE, SSE2   #   empty_nested() must be true before calling recover_memory()     empty_nested() must be false before calling recover_memory_nested() self        empty_nested() must be false before calling set_zero_all_adjoints_nested()  =   stan_version_major  #   stan_version_minor  =   stan_version_patch  #   unkown file name    numpy   =   unkown file name        C:\Users\appveyor\AppData\Local\Temp\1\tmpkyfodnd1\stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.cpp  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.pyx #   __init__.pxd    stringsource    type.pxd    ufunc   =   Unknown exception       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.__getitem__        attr_names      genexpr stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.__getstate__.genexpr       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.__getstate__   list        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.__setstate__       Expected %.16s, got %.200s  list        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.__reduce__ stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.num_failed.__get__ dict    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.num_failed.__set__ list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.test_grad.__get__  list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.test_grad.__set__  list    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.inits.__set__  #   Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.par.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.value.__get__      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.value.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.args.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.mean_lp__.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.mean_lp__.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder.sampler_param_names.__set__    numpy   =   Expected %.16s, got %.200s  #   Expected %.16s, got %.200s      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._pystanholder_from_stanholder   'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._dict_from_stanargs =   'NoneType' object has no attribute '%.30s'  #   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  _call_sampler_star      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._set_stanargs_from_dict stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._dict_to_vars_r dict    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._dict_to_vars_i self    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._call_sampler_star  =   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._call_sampler   Expected %.16s, got %.200s      genexpr stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902._call_sampler   __cinit__       attr_names  plot        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__cinit__ __init__    'int'   #   __init__    throw   =   __init__        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__init__  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__getstate__.genexpr      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__getstate__  plot        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__setstate__      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__reduce__        'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.plot  #   'NoneType' object is not subscriptable  extract stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.plot  =   traceplot   #   traceplot       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.traceplot stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.traceplot extract 'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.extract   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range summary stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.extract   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__unicode__       stansummary upar        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__str__   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__repr__  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.__getitem__   =   stansummary args        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.stansummary       summary stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.stansummary       grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.summary   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.summary   log_prob    throw   #   log_prob        grad_log_prob   get_logposterior        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.log_prob  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.log_prob  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.grad_log_prob dict        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.grad_log_prob args        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_adaptation_info   =   get_logposterior        'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_logposterior  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_logposterior  get_sampler_params  #   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_sampler_params    close   =   'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_sampler_params    %d.%d   #   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_posterior_mean        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.constrain_pars    'NoneType' object is not iterable       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.unconstrain_pars  'NoneType' object is not subscriptable  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_seed  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.get_stancode      numpy.ndarray.__getbuffer__ plot        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.flatnames.__get__ 'NoneType' object has no attribute '%.30s'      numpy.PyArray_MultiIterNew1 data        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._verify_has_samples       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._update_param_oi  numpy._util_dtypestring stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._get_param_names  numpy.import_array      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._get_param_fnames_oi      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._get_param_names_oi       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._get_param_dims   numpy.import_array      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._get_param_dims_oi        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.constrained_param_names   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.unconstrained_param_names stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model._call_sampler =   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew2 mode        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model.sim.__set__   #   numpy.PyArray_MultiIterNew3 =   numpy.PyArray_MultiIterNew4 #   numpy.PyArray_MultiIterNew5 =   Expected %.16s, got %.200s  #   numpy.import_umath  =   numpy.import_umath  #   numpy.import_ufunc  =   numpy.import_ufunc  #   vector.to_py.__pyx_convert_vector_to_py_double  vector.from_py.__pyx_convert_vector_from_py_double      string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    #   string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  vector.from_py.__pyx_convert_vector_from_py_size_t      string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   #   string.from_py.__pyx_convert_string_from_py_std__in_string      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ date        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  #   num_failed  #   test_grad   # 
 mean_pars   #   mean_lp__   #   adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.PyStanHolder    extract Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  1.0 traceplot   1.0 __unicode__ 1.0 stansummary 1.0 summary log_prob    1.0 grad_log_prob   get_adaptation_info [   get_logposterior    ,   get_sampler_params  ]   get_posterior_mean  #   constrain_pars  unconstrain_pars    #   get_seed    #   get_inits   #   get_stancode    get_stanmodel   _verify_has_samples .   _update_param_oi    .   _get_param_names        _get_param_fnames_oi    _get_param_names_oi     _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel       cython_runtime  type    stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.StanFit4Model   ndarray Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.__pyx_scope_struct____getstate__        stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.__pyx_scope_struct_1_genexpr    StanFit4Model    while calling a Python object  need more than %zd value%.1s to unpack  stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.__pyx_scope_struct_2___getstate__       stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.__pyx_scope_struct_3_genexpr     while calling a Python object  at most stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902 builtins        __builtins__    __name__        PyStanHolder     while calling a Python object  exactly stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902 %s() got multiple values for keyword argument '%U'      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902 builtins        flatiter        broadcast       NULL result without error in PyObject_Call      %.200s() takes %.8s %zd positional argument%.1s (%zd given) send        init stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902    init stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902    name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope      NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        at least        %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       calling %R should have returned an instance of BaseException, not %R    %s() got an unexpected keyword argument '%U'    '%.200s' object is unsliceable  Missing type object     Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'      Expected a dimension of size %zu, got %zu       Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected     Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d        Expected a comma in format string, got '%c'     Expected %d dimension(s), got %d        Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler   1.0 Big-endian buffer not supported on little-endian compiler   1.0 Buffer acquisition: Expected '{' after 'T'  1.0 Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)   1.0 'NoneType' object is not iterable   1.0 Missing type object 1.0 Cannot convert %.200s to %.200s stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902 cannot import name %S   %s (%s:%d)      value too large to convert to int       can't convert negative value to int ,   value too large to convert to unsigned int   /  can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    error   %]  can't convert negative value to pystan::stan_args_method_t   [  value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   %1% value too large to convert to pystan::optim_algo_t  :   can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    model   %1% can't convert negative value to pystan::variational_algo_t  %1% value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  :   can't convert negative value to long    _cython_0_27_1  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing %1% can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object :   _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   collections.abc close() -> raise GeneratorExit inside generator.        if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections %1% Cython module failed to register with collections.abc module    Cython module failed to register with collections module    value   :   backports_abc   send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    0.1e1   %1% gi_running  nan gi_yieldfrom    object being iterated by 'yield from', or None  __name__    0.1e1   NAN name of the generator   __qualname__    qualified name of the generator generator       %.200s.%.200s is not a type object      stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902 an integer is required  compiletime version %s of module '%.100s' does not match runtime version %s     %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    0.1e1   %1% boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.   :   grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    %1% Argument n out of range: got %1%    %1% boost::math::prime<%1%> is not converging   :   grad_reg_inc_gamma  %1% is not converging   %1% grad_reg_inc_gamma  :    iterations, gamma function gradient did not converge.  exceeded    1.0 k (internal counter)    grad_reg_inc_gamma  0.0 grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1        Must use algorithm="Fixed_param" for model that has no parameters.  1.0 Output generated by Stan (test_grad)    Point Estimate Generated by Stan    0.1e1   1.0 Sample generated by Stan    0.1e1   1.0 Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    0.1e1   1.0 Sample generated by Stan    0.0 Sample generated by Stan (Variational Bayes)    user    stepsize__  1.0 treedepth__ 0.0 n_leapfrog__    divergent__ 1.0 energy__    0.0 stepsize__  1.0 int_time__  1.0 energy__    1.0 # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    1.0 boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    1.0 boost::math::cbrt<%1%>(%1%) 1.0 0.003379167095512573896158903121545171688   1.0 0.0834305892146531832907    1.0 -0.338165134459360935041    0.0 -0.0509990735146777432841   1.0 -0.00772758345802133288487  0.0 -0.000322780120964605683831 1.0 0.455004033050794024546 0.0875222600142252549554    %1% 0.00858571925074406212772   :   0.000370900071787748000569  %1% -0.098090592216281240205    %1% 0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    :   0.0195049001251218801359    %1% 0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  TEST GRADIENT MODE      C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  Initial log joint probability =         but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.    lp__        . Improved by    Log joint probability =        Iteration       Initial log joint probability =     lp__        Optimization terminated normally:           Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated with error:     Initial log joint probability =     lp__        Optimization terminated normally:           Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated with error:     lp__    lp__    0.003379167095512573896158903121545171688       0.0834305892146531832907        -0.338165134459360935041        -0.0509990735146777432841       -0.00772758345802133288487      -0.000322780120964605683831     0.455004033050794024546 0.0875222600142252549554        0.00858571925074406212772       0.000370900071787748000569      -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)     Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      0.9016312093258695918615325266959189453125e-19  0.25479851061131551     Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   -0.32555031186804491    -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument a to the incomplete beta function must be greater than zero (got a=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Adjust your expectations accordingly!   Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Initialization failed.  Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::digamma<%1%>(%1%)   Log probability=       Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.      Log probability evaluates to log(0), i.e. negative infinity.  Exception initializing step size.       Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:        Rejecting initial value:          Gradient evaluated at the initial value is not finite.         seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps         attempts.      ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)  The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%)  Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Result of tgamma is denormalized.       The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.  Evaluation of tgamma at a negative integer %1%. Unknown function operating on type %1%  The argument a to the incomplete beta function must be greater than zero (got a=%1%).   Error in function       The argument b to the incomplete beta function must be greater than zero (got b=%1%).   Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Cause unknown: error caused by bad argument with value %1%      Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    boost::math::bessel_kn<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       -3.7595974497819597599e+11      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      Unknown function operating on type %1%  The binomial coefficient is undefined for k > n, but got k = %1%.       Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "   o            o (          "   $p            4p (          "   p            p P          "   Hq            hq           "   q            q (          "   ,r            Lr           "   r            r (          "   s            $s (          "   hs            ps 8          "   u            u h          "   Pv            hv h          "   v            v            "   w            w            "   lw            w h          "   w             x h          "   dx            |x h          "   x            x (          "   Ty         	   ty           "   y         
   $z           "   z    z    z          "   }    }    ~           "   ~    ~ 
              "       ܃               "   Ԅ    \                "            
   Ї           "   P         
   x           "                 p          "               ,           "                       "   ԏ            ܏            "	               ` (          "                 (          "%   X         '    x                               x
   @      Н            ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx0   @   D   `    `    P   @   >   0      P
          
       
           
    M    `    Mb`MbPMbP?Mb`?
       p   
       5    x	      1   1   1   1   1   1   1   1   1   P         1   1    
                    @   >   p   p   @   D   D   D   D   D   D   D   D   
    %    D   D   D   D   D   D   D   D   x
   /             P   @         
      P	      @
   |/   
                     @   >   p   p   
       
   U       @
      1   1   @   0         @   P
          p
            0    H
   E   `    `       `    
   /   @
   P            
   .   H/   0   
   ]    @]    @   /       p
   e   p   
   `g   
   T    PX    
          о
              @   @            @   >      p      
            `   0   @   >            
          
   0            	           
   S   0    
   -    &    '    @)    @'    0*    *    +    `,    
           0
   /   @
            `    
   6              P   @   >         
   0F   `    `       `    
   T    `T    x
   .   0   T/   
            `   0   @   >            
   >   >   >   `    `    
           P
    V       
       p   h
   0    `    `    `    `    `    `    `    `    `    `    
   p               1      @   1   1   `    p         p   @
   /   .   $0   
           
                
   	   P	      
             .   4.   .   
      
   -    &    '    @)    @'    0*    *    +    `,          @   /    0   0   
   /   
   6    `    `    `    `    H
   L.   </   0   E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        X
   X0   /   /                         	   7         0
   P   @   >   0         8
   $/    
   /    D   /    D   D   
       D   `    `    `    `    `           p       C    ?    ?    @@    7    7    7    @    7    @
           `   T    0z    X
            P   
   б   P	   а       @0   p/   d.   
           
   0   
   \    0\    
   @d   p   
   T     U    8
   X.   L0   .   
   `    0    x
   \    @x    
   c       (
   P   1   1      `   1       1   1   1   `
   P   1   1   1   x
   p7    07     7    6    6    x
           
       `           0   @   >   Г           
   
                 
   D   D   .    
            `    `    `    `    `    h
   7         0
   P   @   >   0         
   .   
   07         0
   P   @   >   0         
           H
   d/   8
           
   p0       p   5    5                                     
 
                     	               	               
                                              0
   0       
    %    7    7    7    7    7    7    7    7    @
           X
      @   /    0   0   
   .   
   `e   p   `
   .      0   
    e   p   H
              p   
          _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?`       @
   @6              P   @   >         
                     @   >   p   p   
      D   `    `       @   >      p           UUUUUU?UUUUUUUUUUUU?UUUUUU
   T    Z    8	          
   5    1    0     2    1    2    2    3    3    4    4    H
   P<   `    `    <   `    
   @   @            @   >      p      
                   @   >      p         f             D   D   D   D   D   D   D   D   
                h
   0/   .   /   ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?
       
   d0   
   /       
       p              ?   =
?   @33?   =
?      ?   ?    ?P
   /           
   T    W    X
           
   D   $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?
       p   
      
   ]       
   /          
       `           0   @   >   Г      
   .   
   0   (
           H
              
   `C    B   B   A   @A   
       
   6              P   @   >         (
   @   Л      `   0   @   >            P
   @>    p8    8    :     8    9    ;     =    =    
            `    gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?0
   T    Y       @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@
      D   `    `    0   @   >         
          h
              t.   @.   0   
                 0   @   >   Г      '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        
      5    
   D   D   D   D   D   D   D   D   
           h
      
   |0   
              Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context             bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product x   to_matrix(array)        vector size     rows * columns  .   y   m   k   T   Y   A       variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =             anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace::anon_model_047a6166bd9c6ecaed4dd3733fae7c6b      data initialization K   t   cap S       t_change    X   sigmas  tau delta   beta        variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   gamma   k_s m_pr    Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        (S + 1) Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!           C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      Undefined transformed parameter: gamma  Undefined transformed parameter: k_s    Undefined transformed parameter: m_pr   []      iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed               Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.         iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes       MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "   PL            pa `          "               `           "               `           "                `            "   ^            0^ `          "   $]            0]            "               \            "   \            \           "   X\            `\ 0          "   V            Y            "   hY            pY x          "   Y             Y          "               X            "               W           "               xW           "   V            V X          "   LF            xV          "   V            (V            "   Q            U            "   K            xU            "               PU            "   h            (U            "   T            T            "   T            T            "   J            pT            "               @T            "   Q             R           "   Q            Q            "   K            `Q            "   E            (Q            "   E            P            "   K            P            "   K            P            "               pP            "   h            HP            "   K             P            "               O 8          "   K            hO            "   J            8O            "               O            "   к            PN @          "   к            M @          "   K            L            "   PL            XL `          "               L           "   LK            `K 0          "               J 8          "   5            HH (          "               0G X          "   F            F @          "   LF            XF          "   E             F            "   E            E            "   K            HE            "   K             E            "               D            "   h            D            "   K            D            "   K            D            "               XD            "   h            0D            "                D 8          "               C 8          "               C 8          "               @C 8          "   @             C 0          "   (@            B            "   K            B            "   K            pB            "   J            @B            "               B            "   J            A            "               A            "   LA            XA          "   @             A          "   $?    <?    h?            "   8c    >    > 8          "   8c    >    H> 8          "
   <            P= @          "
   ;             < H          "   h:            ; 0          "   $9            9 0          "   7            8 0          "   8c    D7    p7            "   8c    6    6            "   6            06 X          "   5            5 (          "               H5 X          "   |4            4            "   4            (4 @          "   H            3            "               H3            "               3            "   d            2            "   d            2            "   1    1 	    2            "   0    1 
   @1            "	    /            P/ H          "   -    -    .            "   ,-    D-    p-            "   ,    ,    ,            "   8c    ,    8, 0          "   h+    +    +            "   8c    *    + 0          "   <*    T*    *            "   )    )    )            "
   (            ( 8          "   @'            ' 8          "   %            & P          "   t$            % 0          "   #            # P          "   8c    "    " 0          "   8c    "    @" 0          "   !    P!    !           "       0     `            "           @           "                       "             p          "   @            P 0          "   !                        "*   0     A              "   4         
              "                           "                X          "               ( X          "   H            X            "   <             p         "               h            "   
            0           "   <             p         "                           "                0          "               0            "                           "               P            "   D                        "                8          "   K                        "   K            `            "   0            8            "                            "
   <            P p         "   
            
 H          "   `
            x
            "   x
            0
 (          "
   <            p p         "                (          "   x
             (          "   @            H           "   x
              (          "   
            
 8          "   x
            
 (          "               @
            "   H	            	 0          "   H	            	 0          "   K            	            "   K                        "                           "   h                        "   K            p            "   K            @            "   J                        "                           "                           "   J                        "   H            P            "                            "                           "   t    < +   p           "                            "       P +             "              (          "   |                        "            	     0          "   H             0          "                      "   t                   "   X         `         "   4    t               "        X     `         "       <    p           "   l                      "   D                   "   $    \     `         "       D    p           "           P p         "   T             8          "                           "                           "	   4    |               "*   x     A              "               @ x          "+        Y              "                 (          "                           "   0              P          "   0             P          "   0            h P          "   l                        "               8            "   8c         0          "                            "   p            p            "       L               "            
   0 @          "   |        0           "            
    @          "   !            x            "                           "   l                        "   $            8            "                          "   p            x            "   8            @            "                          "   ,         	   p            "   8c                    "               0 p         "                           "   8c          0          "!   t    | :               "            1              "!   4    < :             "            1              "               H            "   ȗ                        "   @             0          "                8          "   K            @            "                           "   h                        "   K                        "                           "   h            x            "   K            P            "               (            "   h                         "   \                       "   \            p           "
   <             x         "   p                        "                 (          "   D            P           "                           "                          "   8             0          "                           "            	     8          "               ؼ            "                           "   J                        "               X            "               0            "   к             @          "   0             P          "           ع            "   8c    T     (          "   8c         (          "   H            X 0          "'   |     H    8         "'       İ J    8         "   <                        "   <            p           "               Э          "                @ @         "                          "   @                       "               x           "   @            @           "                         "   0            P @         "                          "   @                       "                          "   @            H           "   t                      "   (         -              "   ̤         -              "       8 %   `           "   @            P H          "                x          "   0            ` H          "               @           "   L            О           "   0              P          "               ȝ (          "   Ȝ            0 X          "   y            h @          "   {            8            "   0             P          "               @ @          "   0             P          "                 @          "               H 8          "   8c    Ę     H          "   8c    0    X (          "   ȗ            ؗ            "                           "   K            h            "               (            "               Ȗ            "   8c    $    P 0          "   K                        "   K            ȕ            "                           "   h            p            "               8 8          "   K                         "               Д 8          "   @             0          "   @            P 0          "                8          "               ȓ 8          "            	   P 8          "            	    8          "   K            h            "   K            (            "   J                        "                           "                           "                           "   `            p            "   |             (          "   ,            @ (          "   ,     :   0           "   T    t     0          "            0          "       ܉ 	    0          "        	   @ 0          "$            ?   І          "               ` 0          "   8c         0          "   8c    x     0          "   8c        8 0          "   8c        Ѓ 0          "   8c    @    h 0          "   8c    ؂      0          "   8c    p     0          "   8c        0 0          "   8c        ȁ 0          "   8c    8    ` 0          "   8c    Ѐ     0          "   8c    h     0          "   8c         ( 0          "   y             @          "            	   P 8          "   y            ~ @          "   y            h~ @          "   }         
   } @          "   }         	   0} @          "   {            | P          "   h|            |            "   |            @| (          "   |            | (          "   {            {            "   {    0{ 
   `{            "   tz            z            "   y             z @          "   y            y @          "   0            Py P          "   8x    hx    x            "   Xw    w    w            "   pv    v    v            "   t    t    u            "                   xt            "   g            s            "   ps            xs            "   s            (s            "   r            r 8          "   K            r            "                    r            "   K            q            "   K            q            "   8c    p    p 0          "   `p            xp            "   8c    o    p 0          "   o            o 0          "   K            po            "   n            n            "   <n            Xn            "                    n            "   m            m X          "   m            m X          "                   0m            "   8c    l    8l 0          "   8c    pk    k 0          "   g            0k            "   K             k            "   K            j            "   K            j            "   K            Pj            "                   0j            "   g            i            "   8c    Li    xi 0          "   8c    ,h    Xh 0          "   g            g            "   ,g            Hg 8          "	   df            f (          "   e            f P          "   c            e (          "   c            e (          "   <e            `e p          "   d            d           "   c             d           "   8c    Hc    pc 0          "   c            c (          "   b            b            "   db            b            "   a            a            "   L_         "   _           "   !            _            "   ^            `^            "<   W    Y n   `Z          "k   \M    P    P h          "   L         
   L            "   K            xL            "   K            HL            "   K             L            "   K            K            "   J            K            "   J            K            "   J            `K            "   J            0K            "   J             K            "   (J            pJ 8          "   I         
   I H          "               HI            "   H             I            "   H            H            "   G         
    H (          "   @            pG (          "   @            @G (          "   ?            G (          "   (@            F            "   ?            F (          "    F         
   0F P          "   E            E @          "   D            (E 8          "   D            D 8          "   C            XD           "   C             D           "   B            PC 8          "   B            B 8          "	   A            A 8          "   HA            XA            "   8;             A            "   @            @ (          "   @            @ (          "   ?            `@ (          "   (@            0@            "   ?            ? (          "    ?            `? 8          "   X>            p> @          "   =             > 8          "   =            = 8          "   <            0=           "   <            <           "   ;             <            "   ;            ;            "   8;            P;            "	   8:            : 0          "   9            9 0          "
   \8            8 H          "   7            7            "   5            7            "   6            6            "   46            P6            "   5            5            "
   D4            4            "   3            4            "   3    83    `3 H          "   2    H2    p2 H          "
   0     1    01           "    /    /    /           "   .            . @          "   p.            x. (          "   ,            p-           "
   +     ,    P, @          "   (    (     ) 0          "   '    $(    P( 0          "   8'    h'    ' @          "   H&            & (          "   %            %            "   $             %            "   @$            p$            "   #            #            "   "             #            "	   !             "            "   !            !            "               P!            "                 !            "             
   P  0         "                           "                           "   (            `            "                          "                           "                          "               8            "                0          "               ` H          "                 0          "                8          "   0            P P          "                           "   (                        "   (                        "               X            "                            "   (                        "                           "   d            p            "   (            0            "                           "               @            "                H          "                (          "               @ 0          "                0          "                (          "                (          "   ,            8 (          "                (          "                           "               x            "               H            "                           "                           "                               "   L            p            "                (          "                            "	               0 `          "   l             (          "                (          "                                             Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                 ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    RhY    
   p  
 
                                                                                                               P
   X
                           0   0               0            p8 
 
                            е
         
             p8             @   
                        8 0
 
                            H
         h
 
  
                     8            @   0
                        
                	   0
         p^            @    
                      0a 0
 
                 =            @   
             P  
 
                        `       U h
 X
                 W            @   p
                        @ 
 
                            = 
 з
                            o 
 
                 V            @   X
                       P  H
                            P
         ]            @   `
                        | 
 
                         
 
 
 
 h 
 0
 
 h 
                                                 `}            @   
                       h
                    
 x
                 0D             @   8
                        
                     @                 HR            @                    (       q 
 0
                            HR   X
                             `
 
                 
 
                 h 
  
                      
                            p 0
 
                             
                    
                    
                   X
          ;            @   p
                        ~ 
 
                 
 
 8 `
  
 (
 
                                     0D     (       @   8
                        8
                    pr @
 P
                 x
                        @\ 
 
                            
          t             @   
             HV            @    
             @             @   
                        h
         XT            @   
             	 
                            X
         P
 
 
                                          q            @   
                       
                    W p
 (
                           | 
 P
                           (
                   
                    `Y 
 
                            k 
 о
                 o            @   H
             
 
 
  
 (
                             
 
  
                                 
            (       py  
 
                 h
  
 
                     
  
 
 
 
 
                                     Pl            @   
                P      P  8
                 
 
  
                                `Q  
 
                            l 8
 
                 p
                        a 
 
                 pH            @   ȹ
             <             @   	             
 X
 ȼ
                                ?  
 x
                            XT 
 
                 xP            @   p
             
 
 P  
 
 
                                                 H 
 0
                 `Q         P      P    
                        T  
 
                 X
 
                 
 h 
  
 (
                                        P  
                 @\             @   
                        = 
 @
                 0
 
                           a 
 
                           
                    
                    r p
 
                            
         a            @   
                        
 @
                 H 
 
                                
                                        h 8
 
                 h
 
                            9 
 
                 U            @   x
             Pe            @   
             pr            @   @
             `Y            @   
             hq             @   
                          
                  w            @   P
                         
         
  
                 
                        o H
 x
                             @   
                        > 
 
                 p
 
                    (       U 
 
                 
 
                 
                        x
                    `
         
 p
                 pb            @    
             
 `
  
 (
                                    (
                   
                    
         
 
                 0Q             @   
                        K 
 x
                 
 H 
 
                         L            @   p
             
  
 
 `
  
 (
 
                                                                    
         =            @   
             @
 
 
                               a 
 
                 
 
                 
 h                 0Q            @   
             0
 
  
 (
                                                P         h
                 @g            @                           
                
   
                    Q 
 
                                     (
 
 
                     h
 H
  
                                
         
 
 `
  
 (
 
                                             @   
                                W               @                          
                    @          9 	           @                
 
  
                                8 
 
                 > 	           @   
                        W  
                 
                          @   `
                P      a 
 H
                            
                      
                 P;            @                           H
                    F @
 
                 ]             @                           P;  @
                 U             @   
              [            @   P
                         r 
 
                 
   
                                
         8?            @   X
             xe            @   	              Y            @   
               
                            > 
 
                            (
         
 
                 `Q             @    
             X
 
                            H
                    
         H
 P
                            `
         0
             
 
 h 
                         @^            @   
                        
         
 `
  
                     h
  
 
                     K            @   
                        @= 
 
                 M            @                            C  
                 K           @   
             F            @   @
             X
 
                 
  
                 w            @   
                                 >            @   
             XD            @   8
             c            @   P                        P         0F            @   h
                         
                    h  
                            x
         @=            @   
             PW            @   H
             z             @   
                                  
 
                             ; p
 p
                            
                    
                    pk 
 
                 x           @   p
                         
 
                   
                            w 
 X
                 p            @   0
                        `] `
 
                           _ P
 
                            K P
 
                 0a            @   0
             x            @   
                       (
         @L             @   н
                       P;  
                 Ё            @   h
             8
 `
  
                                 
  
                             
 H
                            
                    8
                    xe 	 
                 H
  
                  
                        
         
 
 
 
                            (        Y 
 0
                  
 
 h 
                         
 8 `
  
 (
                                         8
 
                            0
                                                 
 
                            z X
 8
                           U x
 `
                 h            @                            @    
             0Q            @   
             
 
                 x
 0
                 |            @   
             `]            @   `
             @
 
                           @= 
 
                 
                       
         HR    (       @                 z            @   X
             Xw            @   (
             
                        
                     U h
 
                              
 
                            h
                    x p
 
                  
  
                                X
                     j 
 P
                 `u            @   x
                        pH ȹ
 
                 P            @                            @   @
             r            @   p
                         W 
 @
                 (}            @   
                         
                    g  
 
                 ^            @   
             
 P  
 
                                    (
         o            @   
                        y p
 `
                            8
         P            @   
                        x                     
         S            @   
                        < 	  
                            L p
 H
                 0n             @    
                        Ё h
 
                             ]  
 
                             { x
 
                           
          h                            
         y            @   p
                        V 0
 
                            `? p
 
                  {             @   x
                       
                   л
         T            @    
                        
          z            @   
                P      ] `
 
                            Xw (
 
                            
                     [ P
 
                            
                    
                    a 
 P
                 8
 
                 g            @    
                        
         
 X
                              @   8
             l            @   8
                       k 
 8
                 K            @   
             H            @   
                       Pl 
 
                 
 
                            ]  
 
                           
         p\            @                 0
 0
                           п
         `Q         @      P    
                        ] `
 
                 8k            @   
                        `
                    
         |           @   
             py            @    
                       > 
 
                 >            @   
                        `} 
 
                            j 
 
                 
 
 x
                     T            @   
                       
         HK            @   8                         @y 8
 
                            z 
 
                 p
 
                 z            @   p
             pK            @   
                        
                     @   
                        j 
 
                            
                    h
                    xP p
 
                 |            @   
             
             
 
 
 
 
 
 
                                     
 
                 
 
 h 
  
 (
 
                                                < 
 
                            
         
                        c P @
                 X
                        U x
 x
                 
 
 p
 0
                                    p^  
 
                           (
         `?            @   p
             V            @   0
             
 H
  
                        P       
 x
                 
 
                            HV  
 
                            x `	 
                 
             `
 P
                                                 8
 H
                 8?    (       @   X
             P
 x
 h
 
                          
             
 
 X
                     K           @   
             8
 
  
                                h
          P
                 8            @   
              ]            @    
             
 
                            y 
 
                 
             
 
 
                     W             @                           
                    D @
 h
                 D            @   p
             h
 
                            A 8
 
                 ~            @   
                       
                    
         ?            @    
                                            
                              H            @   
              j            @   
                        
         
  
 
                                 
                    (
                    H
                    
                    V 8
 
                 px            @   P
             
 
                  
 
                         
 
 
 h 
 0
 
 h 
                                                        
         U            @   
                        8? X
 
                 
 
                 P
 
 
 
 h 
 0
 
 h 
                                                 I            @   P
                        O 
 
                            
         
  h
  
 
   
                                     a            @   
             
 
 H 
 
 
 x                                                x 
 h
                  
 
 `
  
 (
                             y             @   
                         
 
                            
                    
                    Pe 
 @
                 pR            @                           H
         PW             @   H
              U            @   h
                        Pl 
 
                 0
 `
  
                     _            @   P
             
 
 
 p
 0
 
                                             @   
                        x
                    p
                     Y 
 
                            
                    
                    
                     @   8                        pR  
                 W            @                h                        XD 8
 
                 
                        H 
 (
                           h                    P 
 h
                 9            @   
             j            @                
 
 
                      
 
 
                         0D            @   8
                        P  P
                 u             @   
                       9  
                            q 
 
                            
                    0D 8
 
                 h            @   8
                        P
         Q            @   
             X
 h
 
 
 0
 
                                 @y            @   8
                        
         
  
                  
 
 
  
 (
                             B             @   X
                                           r p
 
                           Ё h
 
                 h 
 
 
  
 (
 
                                                @x 
 (
                 
             <            @   
             
 0
 
  
 (
 
                                           
                     w P
 
                 x
 
                    (        U h
 
                            Z 
 @
                  
 
                 H
 
 
                                
         0Q            @   
             `
  
                 0r               P   
             
 
 
                        P      Pl 
 @
                            py  
 h
                            0          r             @   
             
 
 
                     e            @                
 8                      (       @   `
                         8 X
                             
                   
         D             @   @
                        X
         
 ( h
 H
  
 
 X
                                     c            @   8
                        h
                    u 
 p
                 x           @   p
             P             @                 R            @   
                        M   
                            P
         Z            @   
             
 x
                 C            @                
             ȼ
             
                        S 
 
                 j            @   
                        
         A            @   8
             X
 h                            `            P      k 
                              ? 
                             
         8 `
  
                     `
 
                 O            @   
                        (} 
 p                            
                     
         X
 ȼ
                           
                    x
         0
 h
 
                                D p
 0                 
  
 
 
  
 (
 
                                     x            @   p
                    
    
         0Q            @   
             8
 
  
 
                         q            @   
                        
         K            @   P
             
             (
                       h                   V            @   8
                        X
                    ^ 
                     (       ] `
 @                 HK               @   8                         
                    P
          h
  
 
                         0r            @   
                      > 
                  @x            @   
                        8k 
 `                 P
             h
 
 
 0
                         ?            @   
                        
                             x           @   
             x           @   
              W             @   
                                 
 
 
                        P      > 
                  h
             x
 h
 
                     
 
                 W            @                            @
 `                 
  
 
                                
                    X
                    0
                     @                u            @   
                        @L н
 @                 k            @   
                P      py  
                             T 
                            X                   
                    pb  
 	                               8	                            
                    0F h
 x	                            
                    pK 
 	                            
         x            @   `	                        _ P
  
                            j  H
                            
                    c 8
 
                 ( h
 H
  
 
                                        
                    @
                    p\                               
         
 
                 @
 8
 
  
 
 @ x                                      
 8                               W p
                             U 
                  pk            @   
             
 
 
                     
  
                 0Q            @   
              
  
 
 h 
                                         @   8
                        0n  
              GCTL   `  .text$di    `  pE .text$mn    [     .text$mn$00 [ 0  .text$x     .text$yd       P
  .idata$5    P
    .00cfg  `
    .CRT$XCA    h
    .CRT$XCL    p
   .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ        .CRT$XPA        .CRT$XPZ        .CRT$XTA        .CRT$XTZ      .rdata  h
 (   .rdata$T    
 W  .rdata$r    
 t  .rdata$zzzdbg       .rtc$IAA        .rtc$IZZ        .rtc$TAA        .rtc$TZZ     H .xdata     .xdata$x        .edata  \    .idata$2    8    .idata$3    P P
  .idata$4     %  .idata$6      pX  .data   p8 P  .data$r   &  .bss      Lk  .pdata     <   .gfids$y     0    .tls    0    .tls$   0    .tls$ZZZ     @    _RDATA   P `   .rsrc$01    `P    .rsrc$02                                         20
 
4 
2p B   R0
 b  D  
     p  * d 4 pT ؤ
 r   [               Q         2P1	 T 4  p`  T 
     \     F\             &     
        
 d
 T	 4 2p2  	p`0PT 
   p\     |\ \    \ \    \    \    \    \                  X            J                     +"     "     "     #     5$  
 
4 
Rp d	 4 Rp 4 R
p`PD `
 \     \    \    ]    ]    ,]    D    D         %  %      %     %     %     %     &     
&     4&     J&     q&     &   d T 4 2 T 4 2`% %t !d T 4 
	ЮD 8
 @] '  (      (  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 RpD 
 P]     \]     D D     .  .      /     "/     3/      w/     /   4 RpD 
     /   0T 
 J   p]     1  B1      _1   0T 
 J        2  22      O2   0T p
 J       2  "3      ?3   0T H
 J       3  4      /4   0T  
 J       4  5      5   d T 4 pD 
 ]     8  9      9  ,9      9   d T 4 pD Т
 ]     9   :      %:  <:      :   d T 4 pD 
     :  0;      5;  L;      ;   d T 4 pD 
     ;  @<      E<  \<      <   4 pD X
 ]      =  6=      \=   4 pD 0
     =  =      =   d	 T R( (d $T  4 
pD 
 ]      A  1A      $ 	0 0  T 
 r   ^     ,^ `C  C      C     DD  m md
 h4 
rp 4
 rpD 
 @^     L^    \^    l^    |^     F   G      DG     }G     G     G     G  ! t L  WL   !   L  WL    h r0D 
 ^ 0M  zM      M      
4	 
2pT    * *x h r0 Rp`P0 t d
 4	 RD h
 ^ U  U      V   h d 4
 rpD @
 ^     @V  V      V   h d 4
 rpD 
 ^     V  ZW      W   t d
 4	 RD 
     X  X      Y   h d 4 rpD Ƞ
     0Y  Y      Y   h d 4 rpD 
     @Z  Z      Z   t d
 4	 RD x
     [  [      \   d
 4	 RpD P
 \  \      )]   4 
p	`PD (
 ^ ]  (^      ^  / 1 	p`0PT  
 r  ^     _  _    ,_ ^  Q_      p_     _     L`     & 6 p`0  T ؟
   @_     L_    X_    d_      a  _a      a     a      b     . 47 2 p`P  T 
   p_     |_    _ Pb  b      b     :c     Uc  & 0 p`0  T 
 r      c  c      ,d     .  4  p`P  T `
    _     _    _ e  e      f     5f     Of     f      #g   h b  +
 +h &4 
p`PD 8
 _ _    _    _     Pj  j      &k     9k     k     l   t 4 P' 't# #d" 4!  P  D 
 ` `    (`     pm  m      en     -o     o     ;p    p  !  
T 4 pp  p   ! d p  p   !   p  p   !   pp  p   !     T  4 pp  p   " "h 	p`0PD 
      r  9r      r     r     Ys     bs  ' 't #d 4  P  D 
 @`     t  t      u   p! 4 v  w   ! d w  "w    !   w  "w    !   v  w    d
 4	 RpD 
 `x  x      x   4	 
RpD p
 P`     py  y      z   4 RpD H
 ``     pz  z      z  *
 *x &h "42 , 
p`P  D  
 p`     |`    `    `    `    `           `  {  :{      v{     {     {     |     '}     2~     ~     ~     ~     ~        6
 6x h d 4 rp( d 4
 pT 
 J   ` `     0        3       i   d 4 2p 0T Н
 J       @           d T 4
 rpD 
 `       C      ކ  8	 'x8 #h9 4v t P  T 
 r   a     a    a    $a    0a    <a    Ha    Ta    `a                                    X               )     7          ։          y                          9  6	 %x8 !h9 t p0P  T X
 r  pa     |a     a    a    a    a    a    a     Ћ  B      r                :     j               ?     p          !                     ʏ   4 Rp`PD 0
 a a    a    a    b `             ǐ                 $
 $T 4 R
	p`D 
  b ,b    <b    Hb    Xb    db 0  {                Ǒ               $  0
 !4 
p`PT 
 j   b     b b    b               k                   #     ?      M                 ͕         R
 R T
 4	 2p`$
 $T 4
 R
	p`D 
 b     b     b `                  ]   4 p`P!      % !       % ;
 -t7 )d6 %44 . 
P  T 
 b  b b    c    ,c :c    Fc           1      @  ؜          1     >     ĝ     ӝ     "         ! t    P   !   t    P   
 d T
 4 2p$ 	 0  T h
               c    	d    	d    d               |' 	   (}    `c 8              `c     mc    c    c    c    
 
2PD h
 "  T @
               d    d    d    d               8( 	   (} x   0d 8         Ǥ      ͤ  0d     =d    Rd    fd    d    
 
2PD @
 , h	 	 0  T 
               e    e    e    e                ) 	   (} x   d 8                 $      @  d     d    e    &e    se    
 
2PD 
 
 h 4 R
p`P
 
4 
2p R! t d 4	   8  ) !" "T
  8  }  ) !   8  }  ) !     T
 8  }  ) !    8  }  ) !     t  d  4	   8  )  RP!  t 4	     ,* !# #d
    <  4* !     <  4* !     d
   <  4* !      <  4* !       t  4	     ,* ! t   ̯   ! d ̯    * !   ̯    * !   t   ̯   !   t  d   ̯   
 
B0P  ! t
 d	     (+ !9 9  t
  d	     (+ !     t
  d	     (+ ! 4	 p  F  ,* !  t 	d
  4	 p  F  ,* $ 	 0  T 
            e    e        f    f    f    f    f    f        	      4, 	   z H   e H           @        C            e     e    "f    6f    Ff    Pf    f 	    BP0  D 
 :
 ,t9 (d8 $47 0 
P  T ț
 r   g     g    g    ,g    <g    Lg    \g    hg    tg    g 	   g    g    g    g 
   g           $      J     c     r               Һ               ^  	   n  
     	   w     T     }                 
        
  
        K     t       	                	  d* T) 4( & p  D 
 g    W        $ $d0  T/ 4. * p  D x
 g g    g     `             K          L  - " p`0  T P
   h     h            Eh    Qh    ]h    ih    uh            i    j    j             / 	       h X                                   .     c                         s                          h    h 	   h    i 
   /i    i    i     bP0  D P
 , # p`0T (
    j            Ij    Uj    aj    mj    yj    j    j         	   l 	   l 	    l             1 	       j X           @  u                     2     C     i                    '     >          +      j 	   j 
   j 	   .k    ?k 	   k    k 	    bP0  D (
 ) 4  p  T  
            0l    <l     Hl    Tl        m              \2 	   L    `l 8   P                       T                "             `l     ml    l    l    
 
2PD  
 $ 	 0  T ؚ
            m    m        m              L3 	   L    (m 8      L      {               ?        (m     5m    `m    om    
 
2PD ؚ
 *
 * x h 
4 
p( d
 4 rpT 
 2   m             b  7	 &dv "4u p pP  T 
 r  m     m n n  n ,n    8n Dn Pn \n 	   hn 
   tn    n             ,     :        H     Y                O     j     x              
       7  	   p  
                    
   1  	   K   4
 pD `
 n                Bp0  !  

 T 0    5 ! d	     5 !       5 !   0    5  4 
	p`D 8
 n     n     n     P  |                <   d 4 p6 (t3 $d2  40 , P  T 
 R  n n    n 0          
     q             4
 pD 
     p          
 
4 
 p  ! d   F  07 !     F  07 ) t 4
 	PT 
 J    o o o $o 0o <o Ho         P          2     @         P     ^         k     y         4	 < 	p`0P  T 
   `o     lo    xo    o o    o               o    o o 
   o o             0                   Q     w        q            %  	   8     B  r  
          
            2	 $4  p`P  T p
    o     o p    p     p             0                   F            )     L             )  p`0P  T H
    0p     <p Hp    Tp `p    lp    xp p    p         +     <        '     \     m       X                           A     y            +
 +h &4 
p`PD  
 p p    p                   Z     ]  ! !d
 4 R
pD 
 p     p                           4 
R	p`D И
 p     p         Y        T 4 p` 4 p`P! h     4< !       4< !      X< !       X< & &d "4  	pP  D 
 q q    (q    4q                   |            & &d "4  	pP  D 
                                   4 &d "4  	pP  T X
    @q     Lq    Xq   @      d               "      .  4  p`P  T 0
     
     .    ^             T .  4  p`P  T 
    pq     |q    q  J     n            *      
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T  /
 > !    /
 > )  p`0P  T 
    q     q    q q    q q    q           _                 @      +    \    m     P        5    @  4 
RpD 
  r             d 4
 
RpD 
 r  @       4 
RpD h
             4 
RpD @
  r      6     J  4 
RpD 
     p       " "h 	p`0PD 
                   )    -  	p`P0D Ȗ
 0r     <r P          L     S )  p`0P  T 
    Pr     \r    lr    xr    r    r    r    r    r         p          5    Y                        3    D        /    `    q    {     .  4  p`P  T x
    r     r    r r    r          
     .    ^             U              .  4  p`P  T P
             
      .     ^                U! !    "    "    " %
 %h t d 4 P"	 "d 4  pP  D (
  s s    s    $s @% u%     &    '&    &    &    & "	 "d 4  pP  D  
 ' E'     '    '    (    (    ( 0	 "d 4  pP  T ؕ
    0s     <s    Hs     ( ,)     P)    )    )    
*     w* .  4  p`P  T 
    P, ,     ,    ,     -    -     - .  4  p`P  T 
    `s     ls    xs p/ /     /    0    @0    0     1  r04 &h "4/ & 
p`P  T `
   s     s    s s    s s 5 5     6    C6    g6    6     ;7 7    7    7    h8 8    9  4 
RpD 8
     9 :     -:  d 4
 
RpD 
 P: :     :  4 
RpD 
     : ;     -;  4 
RpD 
     P; v;     ;  4 
RpD 
     ; ;     ;    )	 
	p`P0  T p
 b   s     s    s    t    t    t    (t    4t    Dt    Tt 	   dt 
   wt             ? ?    ?    ?@    L@    Y@ 	   i@ 
   u@    @    @    @    @     @  
R0D H
 t     t PD fD     yD    D  4
 
RpD  
 t     t    t    t     D D     E    'E    WE    eE # 4
 pT 
 J    S pS     ~S 6 (4   
p`P  T Г
    t     u    "u    .u         T RT     T    V    V    W    W    W     X    VX     = ,4A 8 
p`P  T 
   @u     Lu     Xu    du    pu    |u    u    u         X Y     XY    Z     Z    [    /[    f[    [    [    [    $\    L\    _     4	 
RpD 
 u     0` p`     `  4	 
RpD X
     `  a     Aa  4	 
RpD 0
     Pa a     a  4	 
RpD 
      b `b     b  4	 
RpD 
     c c     1d  R0D 
 D  f [f     vf  4 RpD 
     f f     f  R0D h
  g ;g     Vg  4 RpD @
     `g g     g  
R0D 
 u     u    u    u    u    u    v    %v h i     i    #i    /i    Di    Yi    ni    |i    i ;
 )h# $dQ  4P H 
p  T 
 +  @v     Lv           Xv    dv    pv    |v    v    v    v 	   v 
   v    v    v 
   v    v    v     w    w    w    $w    0w    <w    Hw    Tw    `w    lw    xw    w    w    w    w    w    w !   w "   w #   w    w %   w    x    x (    x )   ,x *   8x    Dx    Px -   \x    hx /   tx    x 1   x 2   x 3   x    x 5   x    x 7   x    x    x    x ;   y    y =   y >   (y ?   4y    @y A   Ly    Xy    dy D   py    |y F   y    y H   y I   y J   y    y L   y    y N   y    y     z    z R   z    $z T   0z U   <z V   Hz    Tz X   `z    lz    xz    z \   z ]   z ^   z    z    z a   z    z c   z    z e   z    { g   {        i   D{    h   j      P 	    p    { H       i i     i    .j    cj    j    j    j    k    k    k    l    !m    tm    m 	   m 
   m    n 
   Gn 	   Un    cn    n    o    ]o 
   o    o 
   o    p    <p    sp    p    p    p    p    p    @q    wq    q    q    Sr    r    s    s    s    t    Pt    t    t    t    t    +u    9u    Gu    u    u    u    u    v    w    w    ;x     Zx    hx    x !   x "   ,y #   >y $   dy #   y "   y !   y    y %   <z &   [z %   iz    { '   v{    n| (   | )   | *   | +   } *   Q} )   _} (   m}    } ,   ~    s~ -   ~ .   ~ -   ~    ' /   d 0    /        1    2   U 3   k 4    3   ƀ 2   Ԁ 1       , 5   i 6    5        7    8   < 7   J     9   ݂    ; :        ;   + <   J ;   X     =   ߅ >    ?   . @   T ?    >    =        A   , B   K A   Y     C   i    a D    E    D   ˉ     F   L G   k F   y     H    I   Ŋ J   ۊ K    J    I    H   +    M L   b M    L        N   Ƌ O    N       # P   T    v Q       1 R   F S   e R   s     T    U    V   э W    V    U    T   !    C X   X Y   w X        Z        [        \    ]   # ^   1 _   W ^   e ]   s \        `       $ a   9 b   X a   f     c    d   ͑ c   ۑ     e   - f   L e   Z     g    h   Œ g   Ӓ           {     -{ i   7{ j   
 
RPD 
 9 'h( R 
p`0  T ȑ
 s  P{ \{    h{    t{    {    {    {    {    {    {                  S|    _|    k|    w|    |    |    |    |                  >}    J}    V}    b}    n}    z}    }    }    }    }    }                 "   W~ #   c~     o~     {~     ~ '   ~ (   ~ )   ~                 ,   L -   X     d     p     | 1         3    4    5         7       7       9   7 :   C 
   
   
      Y             Z !   !   $      $Z +   +   .      8Z 8   8   ;      LZ 	    8  { H   	    0  | H   	      } H   	    (  ~ H   	        X    5     j    z            ֕    ܖ    `        0    g    u 	       И    ޘ         
       J    `        l                ,    R                    ϛ            ͜    (    n        ĝ    ҝ        M                        
    N      !        ڟ %         &        F '    (    )   Ρ *    )   ) (   7 '   E     a +   t      /   Ǣ     ~ 0   ٣     & 1   c 2    1        ڤ 3    4   T 5   f 6    5    4   ϥ 3   ݥ      7   U 8   g 7            ¦    ߦ     {     {    |    0| 
   |     |    |    }    }     } "   ~ #   4~ $   ~     ~ ,    -   ) .         9    :    ;   
 
RPD ȑ
  bP0  D ȑ
 .  t d 4 	PT 
 J   P \ h t                 0      ;     g      ԩ          N    [      Ȫ    ժ $
 $t d 4
 
rPD x
   A     2 ?
 .tC *dB &4@ : 
P  T P
             Ȁ     Ԁ                                   (     4     @     L     X     d     p             p Ȱ    ٰ              `    n                       G    S         ǲ                	   .     l 
   x                       @ 
   N                  ʴ              	 < +tC 'dB #4@ < P  T (
                                 ȁ     ԁ                                                                P          ε    ڵ     5    C     c    o              #    /              ÷    Ϸ       	        L 
   X     p  4	 
RpD  
           0    @     P y                   d 4
 
RpD ؐ
 P     `   _     w    ̼  
R0D 
 p @ V       D 
                       \c 	    8    H   P c               
 
RPD 
 3	 < 	p`0P  T `
   <                  $    0      0     @    N    p        "    W                 9 (h $4D < 
p`P  T 8
   p     |                   k     v            J                        "    K     g & 6 p`0  T 
                            0                 2      
R0D 
 p       
R0D 
          d 4  p  D 
 (               9     O    ]             * *d %T  4
 R
pD p
 `     l    |                Ȅ    ۄ                           I    ]    o             0
 "d 4 	pPT H
 j            (       Z     d        *           h R0! t
 0 t g !   0 t g  
4 
pT `    4
 RpD  
 @ \        ,    : # #t
 d 4 rD 
               @h @            X             (           bP0  D 
  4 2! d t  Q h !   t  Q h !    Q h  d 4 2! t P  h !   P  h ! d   ( !     (  d 4 
rpD Ў
               `i @            X       P                  bP0  D Ў
  4
 RpD 
  H     S v      2p! 4   i !     i  R0D 
        4 RpD X
     `        4	 RpD 0
           '  d T 4 2p d
 4	 Rp 4 RpD 
         4	 RpD 
     0 O     w  4
 RpD 
     p           S  d 4 
rpD 
               k @           ` X   p t      `     n     bP0  D 
 ! d p  ( !   p  (  d 4 
rpD h
               $l @            X    r           Ά     bP0  D h
 ! d 0 H ( !   0 H ( ! d t p  h !   t p  h !   p  h ! t   h !     h ! d   ( !     (  4 RpD @
 0  t	 d 4 2 d	 T 4 2p0	 "d 4  pP  T 
          @ &      ! t    !   t    0	 "d 4  pP  T 
                R0D Ȍ
   R
p`0D 
 0     ^    p     
 [
     w
    
    
  4	 RpD x
           
 ;     T      0  ! t P  n !   P  n + +d 4 p   BP0  ! t	  F o !  

 d  t	  F o !   
  t	  F o 
 b  D P
            #	 p
`P0  D (
           d 4 
rpD  
               o @           Ї X          Ї     އ     bP0  D  
 " "d
 T 4 
rpD ؋
 @     L    \ `              ,     ! !d 4
 r
pD 
               p @           p X        ! |!     ! p     ~     bP0  D 
  T 4
 2
`! 	 t " D# ,q !   " D# ,q ! 	 t `& $' ,q !   `& $' ,q  4	 RpD 
     * *     +  4	 RpD `
     + +     + 
 b  D 8
 0  R0D 
 0 1     V1 >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pPT 
 b    > "?     @  2p`0 4
 rpD 
  D @B B     B    B  
4 
pT H    4	 RpD 
   0F PF     F 
 t d
 T	 4 R
 	 T d 4
 Rp 4
 RpD p
     P HQ     SQ vQ    Q  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b  D H
     b ! bp`0  D  
                                     t             t @            8   @           ? H           c ~c     c          %    1     M    
 
2PD  
  BP0  D  
 
  ` St
 6 
B`P0   T 4 2`! t h h u !   h h u  4  d T 2p! 4  m "m u !    m "m u !   4  m "m u ! 4 0o Ro u !   0o Ro u !   4 0o Ro u $
 $d  4 r
pD 
                 D    D             v @            8           q Br     xr    r    $s    Qs    es    s          "     
 
2PD 
 $
 $d  4 r
pD Љ
 0 <               D    D             w @           H 8   s 6t     lt    t    #u    cu    wu    u H     U    r     
 
2PD Љ
 $
 $d  4 r
pD 
                 D    D             |x @            8   u ]v     v    v    Rw    w    w    w               
 
2PD 
  T	 4 2! t d x x x !   x x x / 1 	p`0PT 
 r  y y      z    :z    z    *  	p`P0  T X
    Њ     ܊  { j{     {    {     L| 0 6 p`0P  T 0
         0    <    H    T | 3}     R}    }    }    4~    _~     4 R
p`PD 
 ` l    x                         ~      o                      d
 4 
rpD 
                 D             D{ @           ȋ 8            I     X    \            ܁ ȋ     Ջ         
 
2PD 
 
   D 
    K     V " "d T
 4	 
RpD 
      `       4	 
RpD h
            4" 	  p  D @
 @     L                       ! 	0T 
 r               	 0  T    -	  	p`0P  T 
    ` l    x          p      ( [             ~    \ * " p`0P  T ȇ
                  ̌    ،                        ΋ ۋ        |              0 6 p`0P  T 
   ` Í             q    Ď        ' 
 p`0  T x
         l         ͏     @ = ,4B 8 
p`P  T P
            0 >    J    V    b                               ֒        . 0 6 p`0P  T (
   ` ē             s    Ĕ        
   D  
                @           p H         > @     
 
RPD  
 
   D ؆
               | @            H   P ]     ~      
 
RPD ؆
 
   D 
                @            H               
 
RPD 
 
   D 
               L @           Ѝ H   И ݘ            
 
RPD 
 
   D `
                @            H         > @     
 
RPD `
 
   D 8
                @            H   P ]     ~      
 
RPD 8
 
   D 
                @           0 H               
 
RPD 
 
   D 
                @           P H   Й ݙ            
 
RPD 
 
   D 
               T @           p H         > @     
 
RPD 
 
   D 
                @            H   P ]     ~      
 
RPD 
 
   D p
               $ @            H               
 
RPD p
 
   D H
                @           Ў H   К ݚ            
 
RPD H
 
   D  
                @            H         > @     
 
RPD  
 $ $d  T 4 
pD 
     p       F 5u 0xv ,hw  
	p`0PT Є
 B           (    4    @    L    X    d    d    p 	   | 	            
       ̏    ؏                             ,    8    D    P    \    \    h    t             !    "                          
            ڠ    A 	    
    	   ӡ        / 
       ۢ 
       %        S    m            _    Ħ        S    Z        R    2        ҳ                k    {            C        ֶ        ,    9    S    |    W         z !    "   J #    "    !   ٺ    6    f 	           ɻ    ֻ     % %h !t d 4 
	D 
             ̐                    	    P   ؐ H                 Q     f        Ƽ    Ž     > ؐ         
 
RPD 
 % %h !t d 4 
	D 
                                 	    P    H               p                             %    
 
RPD 
 ) )h %t !d 4 
	D X
 @     L                                  P   X H                              "    H X     e    
 
RPD X
 ) )h %t !d 4 
	D 0
                                        P    H        2              R    x          
 
RPD 0
 O =* 8+ 3, .x- *h. &df "4e ^ 
p  T 
    ̑ ؑ                                 	   ,    8    D    P    \    h    t                            Ȓ                         	       Ԓ 8                                        g    |            	    n              	   3 
   W 	   e        =    t 
               }             7                    k                                -    T            0    `                 
    $ Ԓ             
 
2PD 
 ' d 4 pT 
 Z        6                    ! 
	p`0PD 
 \     P                     0 W     j            T                        v      d 4
 2
p! T	 0   !   0   & 4 pT 
 j           t              ,  4 rp`PD h
  `      M  d
 4 rpD @
   p      a  
4 
pT @   ! 4 `   !   `   !   4 `   	 	2`0! 
 t	 T   T !     T !   
  t	  T   T  
R0D 
 0       _  d 4
 
RpD 
 p        d T
 4	 RpD Ȃ
      D     o        4 RpD 
       .     I 9	 (4A 8 p`P  T x
   `                  Ɣ    Ҕ      7     S                $    Q    m 9	 (4A 8 p`P  T P
        +     G                    A    ] . 4  p`P  T (
           _          . 4  p`P  T  
               # p`0T ؁
 z           q          + 4 p`PT 
 z        z          . 4  p`P  T 
                R0D `
   G     b &  p`0  T 8
         
     9    W  
 D 
           R0D 
 P   A     P  R0D 
 p        R0D 
  7     R # #t
 d 4 rD p
               8 @           p X        %     8 p     ~     bP0  D p
  d 4  p  D H
           -   0 s                   4 R
pD  
 @     n                   H      4 RpD 
               D 
         " "d 4	 RpD 
      ʖ   T      b        t T
 4	 R`2	  d 4  p  T 
                  D @            H     b     7           BP0  D 
 f
 fd <t 	 4 2% %4 p`D X
               ؘ @             X                    .     bP0  D X
 ' 7 p`P0T 0
   P	 	     
    k
    
    
 6
 ] 
	p`0PT 
   `                                   	   +               v                     -    b        
    J
 	   
 
   : : &  x 	h   / 1 	p`0PT ~
 r       q             1      h 0!  x  T Ț !     T Ț !     x  T Ț 6
 ] 
	p`0PT ~
    &     E    }                    s         	   L 
   / 1 	p`0PT ~
 r             :        ] ] U  
	p`0P! h
      !           D h~
 " #     . 7 p`0PT @~
        # z#     #    #    +$    x$    $    = ,4e Z 
p`P  T ~
   @     n                 ט             	    
            $ %     &    C&    Z&    &    &    '    ?'    ['    ' 	   G( 
   (    ( &
 &d
 !T 4 R
pD }
 0  ) G)     ) / 1 	p`0PT }
 r   * *     *    *    A+    , ,4)  
p`P  D }
 @     L    v            D    D              	   ҙ        D     D D             + ,     %,    ,    ,    ,    ,    -    L-    [-    -    - 	   - 
   1.    H.    b.    .    .    .    $/     }/ 
   /     / /    / , ,4)  
p`P  D x}
          F    R    ^    D    D     j    v     	       Ϛ    D     D D             / _0     u0    0    1    -1    C1    `1    1    1    2     2 	   62 
   2    2    2    2    3    ?3    t3     3 
   3     3 4    4 = ,4= 2 
p`P  T P}
                ,     :    F @4 4     $5    A5    5    5    6    7    7     7    7 6 (4   
p`P  T (}
    `     l    x P8 R9     z9    9    9    7:     `:  
0D  }
       : :     :    
;     L :c 2d -e (xf $hg  
p`0  T |
 #  Л     ܛ                                           
   )    5    A 
   M    Y    e    q       	      L 	        h   @; `<     <    <    <    <    = 
   W=    =    3?    ? 
   ?    {@ 
   @    A    A    EB    SB    C    (C    JC 
   C    C     C          6    N                     T    e     	       ҝ      P0  D |
 A 0x ,h (4<2
p`P  T |
 b	                       Þ    Ϟ    ۞             
           #    /    ;    G    S    _    k    w                     0D #E     RE    _E    sE    E    E    OF    YF    F    *G    ]G 	   H    TI 
   aI    J 
   J    J    J    }K 
   ZO    O    .P    UP    bP    Q    *Q    vQ    Q    1R    KR    R    R    R    R    S    #S    1S    >S    KS    S    S    S    S     S A 0x ,h (4@6
p`P  T |
 	               ğ    П                         
   +    7    C    O    [    g    s                     PT CU     rU    U    U    U    U    oV    yV     W    ]W    W 	   1Y    Y 
   Y    6Z 
   PZ    Z    Z    [ 
   _    `    ^`    `    `    @a    Za    a    a    ab    {b    b    b    
c    c    <c    Sc    ac    nc    {c    c    c    c     d     )d / /h +/ 't. #d- 4, ( P  D `|
      ̠    ؠ                     d 9e     ye    e    e    e    Rf    `f    f    .h    =h    Gh    Uh     h "	 "d( T' 4& $ p  D 8|
    i <i     j "	 "d. T- 4, * p  D |
 0 @j |j     k "	 "d( T' 4& $ p  D {
 k ,l     m "	 "d. T- 4, * p  D {
 0m lm     n #	 #t3 d2 41 . P  D {
 @     L    X    d n o     p    vp    p    Zq    q     q 1
 1x -h )tC %dB !4A > P  D p{
 p     |                 q r     s    zs    t    u    [u     vu "	 "d( T' 4& $ p  D H{
 u u     v "	 "d. T- 4, * p  D  {
 v w     hx "	 "d( T' 4& $ p  D z
 x x     y "	 "d. T- 4, * p  D z
 y z     X{ #	 #d4 43 . pP  D z
              ġ { k|     |    }    =}    }    8~     S~ 0
 0x ,h (dB $4A < pP  D z
 С     ܡ                 p~ n                           7
 )h %42 ( 
p`P  T Xz
 "                $    0    <     0      G    U    z            9    Æ    φ         % 7
 )h %42 ( 
p`P  T 0z
 "      ` M     w            ?    ӊ    i            ;     U <
 *hi &d "4  
p  T z
   P \ h           t                     	    
   Ȣ 	   Ԣ                            (    4    @    L    X    d    p    |                        ģ     У !   ܣ "    #           %   *    $   &      ذ 	    h    8             @ l                 7    z        2    V    d     	   T 
        
    	   ړ     
           G    ~                             0                    c            0            5        ɚ        h                
    ,    L          !    "   ( #   e $    #    "    !        '    5         	   С        .    J    x       
 %    &   
 
2PD z
 <
 *hi &d "4  
p  T y
   @ L X           d           p    |         	    
    	       Ĥ    Ф    ܤ                         $    0    <    H    T    `    l    x                      !    "   ̥ #   إ        %       $   &      ȴ 	    h   8       Т W     {      أ    T    F    V                ٧ 	    
   ۨ     
   	 	   *    ީ 
       `        Ϊ    1    ?    M    ϫ        =    t    /    =    K    Y        ܭ    &    p        +    u        	    3                 ?    M    l        ó      !   1 "   h #    $   / #   = "   K !   Y     g    u    Ŷ     	       E    n               %    &   
 
2PD y
 # p`0T y
 z         ,  k              3  4 2p!
 
d T @ S  !   @ S  !   d  T @ S  $ Rp`0D y
                @           @ 8    n      @     M    
 
2PD y
 $ Rp`0D hy
               h @           p 8             C p     }    
 
2PD hy
  2
p!
 
d 4 P ^  !   P ^  !   d  4 P ^  !
 
d 4    !      !   d  4    !
 
d 4 ` n  !   ` n  !   d  4 ` n   R
p`0D @y
                            @            8       0 X     b    s           ɦ    
 
2PD @y
 !
 
d T    !      !   d  T    / 1 	p`0PT y
 r             Z        = ,4< 2 
p`P  T x
              ,    8                :        	 t d T 4    d 4 
p  !
 
 T   @ !     @     zx dh &% p`P0!  
  0 | !  	 	
 0   !   0   !    0 |  	  0  D x
 P     \                   -     
R0D x
       _  d 4
 
RpD xx
 p        
R0D Px
 P        
R0D (x
   9      9	 (4A 8 p`P  T  x
                              %    W             =
 ,hP (4  
p`P  T w
   p |                        ħ    Ч     	       !    -    9 
   E 
   Q                     v            F    y                x             	    
   
    R    c    | 
   7     
   S    d 
   q                     4 &d  "4  	pP  T w
    `     l    x                      ̨ ب 
            P          0    V    u      `                     >    o 	         
        
    =
 ,hP (4  
p`P  T w
               @      '             f                2                 	    
   -    r         
   W    
 
   s     
                       $ 
 
d	 
Rp! 4   p !     p .  t d 4 	PT `w
 J         X           - ]    j < < 7x
 3h /t' +d& '4$  
P  D 8w
        0      , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t    !       d 4 pD w
 0 
 D
     
 	 	 0      d 4 p h d
 4	 Rp.  t d 4 	PT v
 J   @ L X d p                          *    7 g    t ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P  D v
                          ȩ    ԩ              S     d    r                             	                               9     a / / *x &h % 
	p`0PD v
             
         #     # / / *x &h % 
	p`0PD pv
     $ $     $    +     +  0D Hv
 , D,     ,  R0D  v
  - !-     0-  R0D u
 P- -     -  0D u
 - $.     .  R0D u
 . /     /  R0D u
 0/ /     /  
 D Xu
 / 0     S0  R0D 0u
 p0 0     0  R0D u
 0 !1     <1  0T `   ! t `1 1 X !   `1 1 X &  p`0  T t
     2 2     2    2 # p`0T t
 z   3 y3     3    3 " "d 4	 RpD t
 p5 5     5    6    D ht
  8 8     8 { j5 b6 Z7 R8 J9 B: :; 2< -x= )h>  
	p`0PT @t
 B        ,    8    D P    \    h    t       
               Ȫ    Ԫ                            (    4    @    L     8 9     9    :    N:    z:     : ;    ;    <    4<    `<    m< <    < 	   =    = /= 
   A=    =    = 
   >    J>    [>    >    >    >    1?    >?    Y?    ?    ?    ?    @    }A    C    F    F    \F    mF    zF    F    G    !G    ]G    nG    G    G 
   G <
 *xC %hD  
p`0  T t
 +  `     l    x                         ˬ 	   ׬          
                     ;    G    S    _    k                              í    ϭ    ۭ                   
      x                           	   L    X   	   L    X   	   L    w X               pH I     LI    I    I    I     lJ K    K K    K K    K    L 
   L    M 
   &M    4M    MM    M    M    M    1N    BN    _N    N    N    O    %O    HO    \O    O    aP    sP    P    P    \Q    nQ    Q    Q     Q    5R    lR    R    R    S    )S                  X 	    
             -              
 
rPD t
 { j8 b9 Z: R; J< B= :> 2? -x@ )hA  
	p`0PT s
 r           (    4 @    L    X    d p    |  
                   Į    Ю    ܮ                         $    0    <     S `T     T    T    U    :U     U FV    V    V    V     W    -W lW    W 	   W    W W 
   X    X    X 
   X    
Y    Y    yY    Y    Y    Y    Y    Z    qZ    Z    Z    Z    =\    d^    `    `    %a    6a    Ca    ta    a    a    &b    7b    Wb    b 
   b <
 *xG %hH  
p`0  T s
 c  P     \    h    t                      	   ǰ Ӱ    ߰     
                     +    7    C    O    [                                      ˱    ױ               
                                 	   L H   X   	   L P   X   	   L X  g X               0c c     d    Id    ~d    d     ,e e    e yf    f f    f    vg 
   g    g 
   g    g    
h    Zh    kh    h    h    i    i    i    i    i    i    j    j    zj    !k    3k    Ek    k    l    .l    @l    l     l    l    ,m    mm    m    m    m          Я        H 	   | 
                 t         
 
rPD s
   
p`0  D s
                	    8     H   o 0o     fo       
    2     
 
RPD s
  0. h 42 . p  T xs
 R  @     L r Or     r    r     r = = 8 3x /h +4> 8 p`P  D Ps
 ` l    x                         @s v     v    v    w    (x    Dx    x    y    z    {    {    {    {  p`0D (s
                @            8       | w|     |      Ͳ    
 
2PD (s
  4
 
RpD  s
                    0    @    P            } 8}     @}    H}    P}    X}    `}    }    Q~  0+
 +t# 'd" #4!  
P  D r
 p ~ "      4 4 /	 *x
 &h "d 4  pP  D r
  0 T     a  d 4 pD r
  p      k > > 9 4x 0h ,5 (t4 $d3  42 . P  D `r
                  W             ݋  4	 RpD 8r
 г            a     o      4	 RpD r
      :     Ќ          c " "d 4	 RpD q
 P     z  č     ҍ      ' 'x h 	   4 r
p`P!     !      ! h ݐ    !   ݐ    ( (h $d  T 4 
pD q
 @ y     * +  	p`0PT q
                      ̴       D    u             k         D    l    ֗    @ D 2# -$ (x% $h& N 
p`0  T pq
 +                  )    ;    I    U    a    m 	   y           ȶ    Զ 
           
          	   L     X                b         0    ]    ~    Κ        ћ        j 	    
   ќ    O    ǝ    ;              ߵ     
   M              bP0  D pq
 +  	p`0PT Hq
                 ?     d            !          3    d            ` D 2# -$ (x% $h& N 
p`0  T  q
 +                   I    [    i    u         	                   
            
         ` 	   L     X                          P    }            
        2     	    
       o        [                  6 
   m        ٸ      bP0  D  q
 & 4 p`PT p
 J     S     a               %      
 t	 d T 4 2
 
4 
2`! t  %  !    %     D p
   ]     h  t d 4 P! t    !      ( (h $d  4 
pD p
                	    8     X                    .    c      bP0  D p
 ! t    !         D p
 0        4 R
p`PD Xp
                         ?             ķ    ط         	 	2P0! 
 t	 d   7  !     7   4	 2`! t    !      / 1 	p`0PT 0p
 r  p ѹ         *        !  x   Ț !      Ț !     x   Ț )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '   @ N  ! h	 N   !   N   !   @ N  * 0 p`0P  T p
 r                2        = = *  x h   * 0 p`0P  T o
 r                2        % %4) %  p`P  !& & 
 x h   P ( !     P ( !     
  x  h   P (   D o
 й               0 0h ,4  p
`PD o
                      ,     P                N    [                            u      <
 *x %h 
p`0  T ho
   P     y                    ں                       
   ѻ    ݻ     
        .                  Խ                    *    6    B    N    Z                  1    =    I    U    a    m #   y $    $    $            )    	   	         X             l              	        X      L   : X           X   	      f X                 s        r        $    G         	       e        
    0 
           H                    B    T    b    ~                                     !    e !   w                        F "   X    s #    $   ^ %   p $    &    $    '    $   $ #   @    \    y                     (        )    *    )       T          
        
   :     H        ϼ        #            Ž         |                f     t    
         bP0  D ho
 B 1xS -hT )4  
p`P  T @o
 "                                $    0    < 	   H 	   T         	             [     i    #    @        }            \    r        !            ? 	    
    	            
       B    _     	               /     I i W- O. G/ ?0 :1 52 0x3 +h4 &dr "4q j 
p  T o
                                                     	    
    	        , 
   8    D    P    \    h    t                                                                           !    "    #    $    %    &            (   R    '   )       	       ( 8    2            N    c        ?    T     	    
   ?    ^ 
   l 	       R 
        
                       B                    [            j                                                  
 !   M "    #    $    %   ; &   V '   r &    %    $    #    "    !       '    V 	                 (     5 (   B )   
 
2PD o
 @ @
 ; 6x 2h ## p`0D n
 `     l    x                                                    H               p              d            :	    	    
    
     
     
     _    w                     
               
 
RPD n
  d 4
 rpD n
  
 
     /  T 4 	p`D n
               p                  6     n D Dx @h <4> /6 !p`P  D xn
       T    f t                    )    3      $ $h d> 4= 8 p  D Pn
                                             0 	   L                   ` \                             8    D     f j    v           
 
PD Pn
 :
 (x* $h+ X 
p`0  T (n
                              /    ;    G             X 	   L                  .    ?        (    r        /                       -      
 
PD (n
 $ $h d< 4; 6 p  D  n
 `     l    x                                   p 	   L                   p l             
                 %!    1!     S! W!    c!     !      
 
PD  n
 :
 (x( $h) T 
p`0  T m
 {                                                   	   L p          ! "     #    '#    u#    #    ?$    m$    %    &    &     & &    &     &      
 
PD m
 : : 5h 142 %( p`P  D m
 0 <    H H    T     @' '     X(    (    (    (    * <
 * %h 0 
p`0  T m
 S             H    T ` l    x x               P 	    (  `                + +     , ,    w-    -    / `     n                ,    9      P0  D m
 . .x )h $t?  d> 4= 8 	  D `m
                                             l 	   L        0 *1     t1    1    1    q2    2    3    3    4     '4 +4    74     Y4      
 
PD `m
 :
 (x* $h+ X 
p`0  T 8m
                              /    ;    G              	   L           4 5     
6    6    y6    7    87    f7    9    9    9     9 9    9     :      
 
PD 8m
 )
 )x $h d> 4= 8 p  D m
 `     l    x                                    	   L               @: F;     ;    ;    ;    o<    <    =    =    >     (> ,>    8>     Z>      
 
PD m
 :
 (x( $h) T 
p`0  T l
 {                                                   	   L p          > ?     
@    @    a@    @    A    EA    B    C    C     C C    C     C      
 
PD l
 <
 * %h 0 
p`0  T l
 S                 $ 0 <    H H                	    (  0                 D D     E E    F    F    H 0     >    u                	      P0  D l
 # p`0T l
 z       0I I     I    I     jJ )  p`0P  T pl
    `     l    x          J HK     lK    K    K    L     ~L M    %M ! t PM eM  !   PM eM   t d
 T	 4 2 T r
p! h 
d
 4 pP P  !   pP P  ! h 
d
 4 0Q NQ  !   0Q NQ  Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P  D Hl
      D      T DU     W    
W     $X * , p`0  T  l
 [                                    P   H   X X    
Y     Y           BP0  D  l
 @
 .x/ )h0 b 
p	`0  T k
              $    0    < H T    `    l 	   x 	            
    
                                                          d 	       H           Y Z     Z    Z    *[    [     &\ \    \    7]    g]    ]    c^ }^    B_    O_    ` 	   "` 
   `    a    a 
   a    b    oc    }c    8d    d    d    d    Rf    nf    j 
   j    j 	   .j    :j              3    G    [         
 
RPD k
 + +h ' #t d 4 PD k
       j j     ul    l     m @
 .x+ )h, Z 
p	`0  T k
                      , 8 D    P    \ 	   h 	   t         
    
                                                          P 	       H               m _n     n    n    o    o      p p    p    q    Aq    q    =r Zr    2s    Ds    t 	   t 
   bu    ou    2v 
   Bv    w    w    w    x    x    x    y    3{    O{    ~ 
   ~    ~ 	   ~    ~              )    =    Q    |     
 
RPD k
   D k
      @ a      R0D Xk
        1  
R0D 0k
           d 4
 
RpD k
  n       4	 
RpD j
 0           V  
R0D j
  Ʌ       d 4
 
RpD j
   n     ˆ  4 RpD hj
       N     i  4 RpD @j
           )  
 D j
 `        R0D i
   !     0  R0D i
 P      ̉  R0D i
       2 * T 4 p`T xi
 Z   D @        L                 P      Ċ                 ' * T 4 p`T Pi
 Z   P      Ɍ                 , 
 
t 4 # #t d
 4	 RD (i
  9      &
 &d
 !T 4
 R
pD  i
 `  ?     / /x +h	 'T #4  
	p`  D h
      `      b &
 &d
 !T 4
 R
pD h
  ߖ     = / *x &h % 
	p`0PT h
            t    T 4
 
R	p`D `h
     Л       d
 T r! x h 
t 4
    !         4  p`P  D 8h
              h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  D h
      w                             ;        o 	           Ǭ    Ҭ    ݬ            /     W    T 4
 
R	p`D g
           #
 #h d T 4 pD g
       а      $    _         "	 "T 4  	p`  D g
          б      5  
 T    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P  D pg
             @              '    :    h            =     	   y    =    I    T    _    j             ٿ  
 D Hg
   @ t       R0D  g
 0         R0D f
 0        R0D f
        &  p`0  T f
        0          
 J J B
 = 8 3x /h +t- 'd, #4+ $ 
P  D f
 0       " "d 4	 RpD Xf
 0 t          	 	B  ! 4   i !     i " "d 4	 RpD 0f
 P     z               ` / /h
 + 't #d 4  P  D f
                 -    5    R     S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P  D e
      `       . h 42 . p  T e
 R  P               8 = = 8 3x /h +4> 8 p`P  D e
                           $                       H    d    
                         V H @ 8 3 .x *h &44 * 
p`P  T he
           . h 42 . p  T @e
 R   /     g    u      = = 8 3x /h +4> 8 p`P  D e
       g             J                        ]    h         " "d 4	 RpD d
 0     Z       "    p  t d 4 	 4H @ 
p`P  ! G   ;  !     ;  3	 %46 0 p`P  T d
 z  p     |                             /     h                ,    6 (t/ $d.  4, ( P  T d
 :                       P          e    t     h R00	 0 & x 	h   !  @   !   @   !    @   / / & x h 4 p!    | 4 !     | 4 !      | 4 8 8 & x h 4 p"
 "4 
p	`PD xd
        G     g    ^ R R J B
 = 8x 4h 04- !" p`P  D Pd
          ,    <    L    \    h    t              0     O    ^    o    z        I    Z                 i W- O. G/ ?0 :1 52 0x3 +h4 &dr "4q j 
p  T (d
                                                     	    
    	        
                   (    4    @    L    X    d    p                                              |         !    "    #    $    %    &            (       '   )       	        8            v                                - 	    
         
   '  	   F     ! 
   I!    i! 
   w!    !    M"    i"    "    #    q#    #    #    #    $    R$    $    *%    F%    T%    b%    p%    %    %    J&    &     &    &    & !   
) "   D) #   ) $   ) %   ) &   + '   1+ &   ?+ %   M+ $   [+ #   i+ "   w+ !   +    +    , 	   J,    f,    ,     ,       (    )   
 
2PD (d
 2 2 -x )h %t !d T 4 
	D  d
 0- {-     X. 0 0x ,h (d $T  4  
p  D c
       , / /     /    1     1 3	 !4= 6 	p`  T c
   @     L    X                  8              	    x   d h               02 2     4    $4    64    4    4     4    4      5 d     r    
        )      P0  D c
 <
 * %h 0 
p`0  T c
 S             8    D P \    h h                	    (  P    P5 5     6 6    7    8    : P     ^                    )      P0  D c
 <
 * %h 0 
p`0  T `c
 S             h    t                      $ 	    (              `: :     ; ;    <    !=    ?                  ;    L    Y      P0  D `c
 <
 * %h 0 
p`0  T 8c
 S                                       D  	    (              p? @     @ 
A    A    1B    $D              
    k    |          P0  D 8c
 <
 * %h 0 
p`0  T c
 S                                       d! 	    (              D E     E F    F    AG    4I          %    =                  P0  D c
 " "4
 rpD b
               ," @            X   I #J     9J           bP0  D b
 " "4
 rpD b
               " @            X   PJ J     J           bP0  D b
 +  	p`0PT b
                    (    4    @ 	       
                     	                            	                                        J cK     K K    K L    +L [L    L    L    L L    &M    WM    aM 9 +x
 'h  
	p`0PT pb
    P \ h t                   	       
                     	                                  N N     N O    O JO    ^O O    O    O    	P    P MP    tP    P 	   P    P    P Q    Q Q    Q 3
 %h  	p`0PT Hb
                    (    4    @ 	       
                     	                            	                                        0R R     R S    /S _S    sS S    S    S    T OT    vT    T    T 8 *h
  
	p`0PT  b
    P \ h t                         	       
            PU U     V `V    mV V    V V    V %W    LW    sW    W    W    W X    9X 
   X    Y HY    XY 9 +x 'h % 
	p`0PT a
                  $               	       
       0     Y Z     MZ Z    Z Z    Z -[    :[ j[    [    [    \    (\    2\ ]\    3] p]    ]  R
p`0D a
         @                  ) @           \ 8       ] ]     ]    ^     ^ \     i    
 
2PD a
  R
p`0D a
                           h* @            8        ^ H^     R^    c^     r^          
 
2PD a
 % % !t d 4 
	ЮD a
                + @            X       ^ !_     ca a          RpP0D a
  R
p`0D Xa
                            + @            8   a a     a    =b      )    
 
2PD Xa
 % % !t d 4 
	ЮD 0a
                , @           @ X       Pb b     d d     O     RpP0D 0a
    4 Rp`D a
                           , @            8       e >e     Ke    e     e          
 
2PD a
  4 RpD `
                           X- @            8       e e     e    e          
 
2PD `
  4 RpD `
                            - @            8       f :f     Hf    Vf      )    
 
2PD `
  T 2`! 	 t 4 pf f H. !   pf f H.  d 2p! T 4 g g . !   g g . ! T 4 h 
i . !   h 
i . /	 !h 4   p`P  T `
    @ L    X    d p    |               i [j     j j    
k    4k    Vk k    l    @l    bl l    l (m    =m ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P   T 4 p`!   u u 0 !   u u 0 
 d T 4 p!  x x L0 !   x x L0  h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
pD h`
                                    (1 	         8       ~ G~     T~    }~    ~    ~                   
 
2PD h`
  4& $ p  D @`
                                 1 	   X9     
 8    i             
      ,     8 
     
 
2PD @`
  d	 4 RpY Yh  0  ' 'h "d T 4
 
rpD `
     Є ,     R ' 'h "d T 4
 
rpD _
      Ǉ      #
 #h t
 d 4 rD _
         " "d 4	 RpD _
  ċ     ҋ      " "d 4	 RpD x_
 @           " - 	p`T @  !C
 Ch 8, &4 T3 42    3 !      3 	 d T 4  p  D P_
 0     <    H           )    7        ;         T
 4 
R	p`D (_
 ` l     P           )  	p`0PT   !/
 /< &x= h> ~ Ԉ   4 !     4 ! 
  <  x=  h>  ~  Ԉ   4 3	 %49 0 p`P  T  _
 z  С [         ¢    ޣ    M    \     4* 	( p  D ^
         !  0   !   0   !    0    x h 
- D ^
                           ˬ     ͬ c     v        í ܭ      k 
	`P!*
 *2 x3 h4 tj 4s   F p6 !     F p6  4
 
RpD ^
               6 @            8       0 U     ~          
 
2PD ^
  4
 
RpD `^
               X7 @            8             ޵          
 
2PD `^
 1	 #h
  p`0P  T 8^
      , 8 D    P    \ h    t            	       
                     
                                                              g      ׶         / _            ӷ     *    [    e 7
 )x
 %h !4!  
p`P  T ^
                                	       
                     
                          l           3    G w        к         5    \                 2 $x
  h  	p`0P  T ]
        $    0    < H    T    `        	       
                     
                                                       E x         н      4    [    |     Ӿ         ; -x )h
 %4'  
p`P  T ]
    p |                                 	                  V           1    E u            /    9    C ~        X    q 6
 (x $h
  
	p`0P  T ]
                (    4    @        	       
                   K           $    8 h                 :    a             ! t    !      $
 $d  4 r
pD p]
               0> @           P X             _     RpP0D p]
 ! t    !      $
 $d  4 r
pD H]
               > @            X   P }          RpP0D H]
  
p`0  D  ]
                           P? @            H                      /           2pP0D  ]
  `  ! T 0 E ? ! t 4  T 0 E ? !   t  T  4 0 E ?    ! 4    @ !     @ ! 4  P q @ !   P q @ !
 
t d   n !     n !
 
t  4   0 @ !     0 @ !
 
t d   n !     n . .4= 4 
p`P  D \
      @      = UeDx  =h! 6tL /dK (4J cD 
PT \
   P     0       ! 4 p   !   p   !   4 p    
R0D \
  )     o  d 4
 
RpD \
       +  
R0D X\
 `        d 4
 
RpD 0\
  >       4 RpD \
       .     I  4 RpD [
           	  d 4
 
RpD [
 @       & 4 pT [
 z         H    j . 4  p`P  T h[
     T          - d 4  p  T @[
               . 4  p`P  T [
               &  p`0  T Z
        @            
 D Z
 `        R0D Z
   !     0  R0D xZ
 P        R0D PZ
       2  
 D (Z
 P        R0D  Z
          R0D Y
 @        R0D Y
       " s st 
 ! 4 @  `E !   @  `E " "d 4	 RpD Y
 `                P " "d 4	 RpD `Y
       p            Pe?h 841 &c!& p`PT 8Y
        0       i ' 'd #T 4  
p  D Y
                         } }  x 0! h    F !      F 3	 %40 ( p`P  T X
 :       6     ]    	    	     @ `0P  ! I H tF 
 _
 XG !   
 _
 XG !   I  H  tF 
 _
 XG  "p0  !    d T
 
 
 G !   
 
 G  d 4 p! t d 4   )  !     )   4* 	( p  D X
        = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x  : H !    : H * * h  !     I !   x    I !      I !      I @
 @ , "   ! x  T  pI !  T    I ! h   R! I !     R! I !   T    I !    T  pI 9 9 !x 
 !  h p$ $ I !  $ c' J !  c'  ( J !   c'  ( J !   $ c' J !   p$ $ I 9 9 &x h 
  !   . . tJ !  . 3/ J !   . 3/ J !    . . tJ   0  ' 7 p`P0T X
   5 5     D6    6    6    
7 ' 't #d 4 
PD pX
           07 o7     (9    <9     9  d Rp! T	 ? #? K ! h 
 4 #? ;? K !   #? ;? K !   ? #? K /
 /t" +d! '4   
P  D HX
     ? 1@     @ )
 )h
 $t  d T 4    D  X
 0 0B B     FC ! T C C (! !   C C (!  d
 T	 4 RpD W
  D RD     D D     D !" "t  d 
T 4 E E @ !   E E @ ! t  
d 4 `G G @ !   `G G @ !" "t  d 
T 4  I 'I @ !    I 'I @  Bp
`  !$
 $  
 
T	 4 J J dM !   J J dM ! t  
d 4 @K qK @ !   @K qK @ 6
 3 
	p`0PT W
       L M     3M    lM    M    N    6
 3 
	p`0PT W
       0N N     N    N    @O    {O     2pP!
     
d 4	 O O N !   O O N   P!   t d 4 R @S N !   R @S N  
R0D W
 PT T     T  d 4
 
RpD XW
 T .U     U  4 RpD 0W
      V NV     iV . 4  p`P  T W
    \ \     \    ]  @ 
	`P  ! > t? 4F @] v] O !   @] v] O  " P   R0D V
      ` '`     B`  
 D V
 `` `     `  R0D V
  a !a     0a  R0D hV
 Pa a     a  R0D @V
 a b     2b " "d 4	 RpD V
 Pb b     b    b " "d 4	 RpD U
 c Tc     bc    c  4 RpD U
     c c     d " "d 4	 RpD U
 @     j Pd d     d    d IE;h 7t! 0d  )4 C 
PT xU
      e |e     e    Ng W
 Wx 8h  4J B 
p	`P  ! I g g  R !   g g  R U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4  r r @ !   r r @ !  t d u <u n !   u <u n !  t d 0v \v n !   0v \v n  p  ! 4 y y tS !' '  d y y |S !   y y |S !   y y tS  . `P  !p ph :* /+ $, t- 44 z { S !   h  *  +  ,  t-  44 z { S  
R0D PU
     p} }     }  d 4
 
RpD (U
  ~ N~     ~  d 4
 
RpD  U
       ~      &    4  d 4
 
RpD T
       P            
 D T
 0 d       R0D T
 Ђ         R0D `T
          T 4 `  ! t   U !     U " "d 4	 RpD 8T
       d     r     " "d 4	 RpD T
      
  $     2     Pe?h 841 &c!& p`PT S
        !     ي 3	 %49 0 p`P  T S
 z        ,    8    D    P    \                           .            0
E"h t d 4 C
P  T `   /
 /t" +d! '4   
P  D S
   a     # /
 /t" +d! '4   
P  D pS
 `      V O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4  7 @ !    7 @ ! t  d 
T 4  ݣ @ !    ݣ @ " "4 
p	`PD HS
  ٥      Ne=h 6t< /d; (4: c4 
PT  S
   p     | @      9    ߫       	  h d 4  p  D R
  P ׬       t d 4  t T 4 ! d  a Y !    a Y " "d 4	 RpD R
       D     R     
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h  e Z !    e Z 	 	2p0!  
d	 T   pZ ! 
  6 |Z !    6 |Z !     pZ !" "t  d 
T 4   G @ !     G @  T `  !
 
t 4   Z !     Z ! t   S  !     S  9 9 "% p`P0!{ {	 m
 X I =
 1   x h   T[ !     T[ !   	  
      
      x  h   T[ 
 
0!,
 ,  ( t d T   [ !     [ <5.h *t #d 4 3
P  T R
 R    `      L    ) )d: %49 2 	pP  D R
      @      A  d 4
 rpD XR
 0 _     ~     -	%t d
 4 #P  T 0R
 B               , ,1 pP!I Ih :+ ', #- . 
d/ 40   H] !     H] L L 7 " p`P0!| | g C 9 	 x
 h   m ] !     m ] 1
 1h -4# ! p
`P  D R
            S     p        ,    A p
 ph hd+   
p0P  !  t d 0 \ n !   0 \ n !d d	 [
 O B 9
 0 $ x h P  T[ !   P  T[ !   	  
      
      x  h P  T[ ! !dK !4J !B pP  ! h  I @ w $_ !   h  @ w $_ !   @ w $_ '
 'tK 'dJ '4I 'B P  !* * ! x h    |_ !     |_ !  t d `  n !   `  n      T 4 
R	p`D Q
           ^  T p  !
 
d 4   8` !     8` /
 /t0 +d/ '4. ( 
P  D Q
             /
 /t0 +d/ '4. ( 
P  D Q
 P" "     i#  9 
0P! 5 6 t7 d8 $ K% ` !   $ K% ` !   6  t7  d8 $ K% `  	  h
 d 4  p  D hQ
     ) p*     * BE1h *+ #* d) 4( C	& PT      ! t d 4 , , a !   , , a  d
 T	 4 RpD  0 0     51    	 "  D    #8 8  8  P  
 
4
 
rP t	 d 4 2D    7: :       d 4 2pD    ^; |; #     	 4 rp`D    ; < ? < 	 	b   rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!  @F F c !. . 	 F F 4c !	 	 F F Hc !   F F Hc !   F F 4c != =2 *3 4 4= 	J 1J c !   @F F c  20 R0
 
4 
2p 20%	 4- $ 
p`P  T   " "t 20 % T    B   B  
 
4 
Rp 20
 t d
 T	 4 R B   B   20! 	 t 
d T T T pd !   T T pd  20
 
4 
2p d 4 2p 4 p R
pP0! d
 @X X d !   d
 @X X d !   d
 @X X d !   d
 @X X d 
 
4 
2p! d [ V[ 4e !   [ V[ 4e  20 d	 T 4 2! t \ :] le !   \ :] le  20
 
4 
2p 20u ut 
4 
2`
 
4 
2p 4 2
p`P 4  d 4 2p
 
4 
2p B  ! 4 g =h f ! t  4 g =h f  B  ! 4 h h Hf ! t  4 h h Hf !   h h Hf  B  ! 4 i i f ! t  4 i i f !   i i f  B  ! 4 `j j f ! t  4 `j j f !   `j j f  B  ! 4 @k k g ! t  4 @k k g !   @k k g  B  ! 4  l yl Xg ! t  4  l yl Xg !    l yl Xg  B  ! 4  m hm g ! t  4  m hm g  B  ! 4 m n g ! t  4 m n g !   m n g  B   B   B   B   B   B   B   B  C
 CT	 >4 d
 2
p d T 4 p T	 4 2p!  d  r pr h !    r pr h  2p 4  2p`P! 4 @t {t h !   @t {t h 
 
4 
2p T 4 Rp`! 
 u !v i !   u !v i  T 4 R
p`
 
4 
2P!
 
t d  y 5y Pi !    y 5y Pi !   t  d  y 5y Pi !   t  d  y 5y Pi 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !    I i !      I i !H
 HT : 5t
 0d	     I i  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p T 4 Rp`
 
d 
2p! 4 p  j !   p  j  t 20 d 4 2p! T `  k !   `  k 
 
20 d	 T 4 2p!    P @k !     P @k !      P @k !     P @k  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d    k !   t    k !      k  t 20 20 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p d 4 2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	  G 0n !    G 0n  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	   o !     o  B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
PD P                     %    F            T          2P'
 '4 
p`PD x                       2P6 (4   
p`P  T              4    D    @ 0 p                 2        ,    >    Z    v                  2P, ,4"  
p`P  D  L     u           /     i    r    ~    2    v          2P'
 '4 
p`PD               	    	      2P, ,4"  
p`P  D                `	 	     	    	    	    	    	    	      2P'
 '4 
p`PD @ '      0		 ]		     q		    4
	      2P- -x )h %4 
p	`PD h \     P 
	 	     	    	      2P' d 4 pT  j    	 	      2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p\ \T rp`0T 8   
 
4 
Rp9
 +t! 'd  #4  
P  T               p+	 +	     +	    +	    -	    E.	     .	 9
 +t! 'd  #4  
P  T               /	 /	     /	    /	    1	    U2	     2	  d 4 pD        3	 3	     3	    4	     4	  d 4 pD 0       @5	 f5	     o5	    M6	     6	 9
 +t! 'd  #4  
P  T X    #     /    ; 6	 :7	     M7	    ]7	    [9	    9	     /:	 9
 +t! 'd  #4  
P  T     G     S    _  ;	 J;	     ];	    m;	    k=	    =	     ?>	 9
 +t! 'd  #4  
P  T     k     w     ?	 Z?	     m?	    }?	    {A	    A	     OB	 *
 *4 
p`PD         C	 cC	     vC	    bG	     G	  t d T
 4 r9
 +t! 'd  #4  
P  T                   P	 P	     P	    Q	    Q	    W	    X	    X	     9Y	  B  
 
4 
Rp, ,4  
p`P  D                D    D    D [	 \	     '\	    8\	    u`	    `	    `	    `	    a	    ;a	    d	    d	     d	 	 $ 
p`0  D H                                     z @            X   @e	 xe	     e	    e	    f	    'g	    ak	    }k	     k	      ,    S     
 
rPD H 
 
4 
Rp  	  !e e ]d   t T 4 l	 l	 x{ !    l	 l	 x{ !   l	 l	 x{ !         t  d  T  4 l	 l	 x{    P  !u ud #    
t 4 p	 	  | !    p	 	  | !   p	 	  | !           t  d  4 p	 	  |  T
 4 rp`  
  !m m bT   t d 4 	 	 | !    	 	 | !   	 	 | !         t  d  T  4 	 	 |  T
 4 rp` b  !6
 6 1t )d 
T 4 	 ɢ	 8} !   	 ɢ	 8} ! 
    t  d  T  4 	 ɢ	 8} )	 ! p`0  D p a     m    y                                ~ @            8   	 	     	    	    
	    	    K	    	    	    ѯ	     	               
 
2PD p  d T 4 p*	 *4  p`  D                                   @            8   P	 	     	    	    ϶	    	     	               
 
2PD  #
 4 
p`PT X    	p`P0T @   
 d T 4 p t d
 T	 4 2 	p`P0T X    BP  !; ;t
  
d	 4 	 	  !   	 	  : :	 5t -d 20   !\ \ , $t d 
T
 4  	 	 T !    	 	 T M
 M
 T 4 Rp`% I PT    ! 4H 	 	  !
 D #C E tF dG 	 	 Ā !   	 	 Ā !   	 	  !   C  D  E  tF  dG  4H 	 	  #
 4 
p`PT `   D
 Dt d	 T 4 2
 d T 4 p   T    !$ $  t d T 4 @
 p
  !    @
 p
  !   @
 p
  
 d T 4 p P  !^ ^ 1 " t 
d
 4 0,
 A,
  !   0,
 A,
   bP  !' '   t 
d 4
 `1
 y1
 P !   `1
 y1
 P  T	 2! t d 4 04
 E4
  !   04
 E4
   2
p`0! 
 
 T
 6
 6
 ̂ !    6
 6
 ̂ !   
    T
 6
 6
 ̂ 
 t	 d T 4 2 20 20 d 4 2p t d T 4 #	  
p`0  D  -     9    D    D    D           E                     @           b 8   ?
 ?
     ?
    zE
    E
    E
     F
    'F
    YF
    F
    F
    G
    H
     I
 b     o          2P
 
2PD   d 4 2p)	 !" p`0  D                                        *           D    D    D                                                              
         ԅ              @            8   @           J 8   @            8   @            8   I
 MJ
     aJ
    J
    cO
    xO
    O
    O
    O
    S
 	   #T
    JT
 
   wT
    T
    T
    "U
    1U
 
   FU
    Y
    Y
    S^
    ^
     ^
               W    ~                        2P
 
2PD   2P
 
2PD   2P
 
2PD  
 
2PD   4 
p`PT X    d 4 2p6 (40 & 
p`P  T  *  9     -    b    n    D 0c
 uc
     c
    c
    c
    j
    Bj
    j
    j
    $k
      2P6 (40 & 
p`P  T 8 *       z            D k
 k
     k
    2l
    Bl
    wr
    r
    r
    Qs
    s
      2P; -x )h %4*   
p`P  T `              s
 Gt
     [t
    st
    
    
     F
  ' `P! 4* 
 
 P !
 " # $ 
% t& 
 
 \ !   $ 
 
 \ !   
 
 \ !   
 
 P !   "  #  $  %  t&  4* 
 
 P 9
 +t1 'd0 #4/ ( 
P  T  :         A     P    ,       20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   d T 4 2p bP  !' '   t 
d 4
 @. Y.  !   @. Y.   T	 2! t d 4 1 %1 $ !   1 %1 $  2
p`0! 
 
 T
 3 3 \ !    3 3 \ !   
    T
 3 3 \ 
 t	 d T 4 2 20 20 B    D                         	   8? (    8   	   Pe 0   < 8   	   V 8   u 8   	   L @    8   	   z H   
 8   	   X9 P   f 8   	   Xw X    8   	   @x `    8   	   pK h   W 8   	   h p    8   	    x    8   @           H 8   P: `:     w:          .     I    g                           X     s                      I     d                      :     U    m     
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD  
 
2PD   B   20# 4 rpT  2   { 0; `;     ; 1	 #t! d  4  P  T                                        	 < <     <    =    <=    a=    r=    =    =     p>    >    >    >     ?    ?    ?      2P d
 4 
RpD (  `? ?     ?  20 B  ? .4  
p`P  T P :  !     -    9    E    Q    ]    i    u         	    
            
                           )    F    R    ^    j    z                                  !         #   
 A B     'B    !D    D    D    D    ?E    zE 	   E 
   E    LF 
   |F    F    F    9G    G    G    G    H    FH    RH    H    H    H    H    CI    WI !   qI "   I $   I    /J    IJ    J    (K    PK    jK    K     K  2P 20   ! 4
 `N N ȓ !   `N N ȓ    ! 4
 O O  !   O O  
 
4 
2p 2p! 4 Q R , !   4 Q R , !   4 Q R , !   4 Q R , !   4 Q R , !   4 Q R ,  B  
 t	 d T 4 2        h 	x    h 	x       d@                         8 Ț x                     8            @                 =         8   `                 P                         x И P h x آ                                     8? (          K                  P}     8                     0                          (}         (                                p                       (                     g            U                      (                      x                     HR (          a                py         X                     U         h                    @                         P h  x П                                  HR            a                  j         @   p                      H                     C         8   Pa                  @  x П                                      q         P                                              h  x                                                U         @                   ` h x                    Ț x                 `Q     P         0                 0T     P                    >         X   PT                h  x                    P   ( x                                                             z            d                 8?            K                  pK            0c                         X   p}                                            pk         8   0`                 |         @    ~                 x                Pl         X                   ț X h  x П                                            8                                                x                                                                          a         @   T                  ]         @                    V            b                ]         X   P                                           @  x                    a         X   `                                                                       =            0                  @x            b                 Pe            06                  L             x                 P         X                    >         8    b                  x                    h x                 Xw            `                  K            >                ` Ț x                           (                     0D        (   g                 p                                                    x                         X                     (          p                  0D         (   g                 `                                                      x                         x П                                      @=         @   p                 `Q     @         0                 h            pc                  Y         @                     ;         8   c                                             М   x П                                     k         X                   @  x                     0D (       (   g                   x                     x                   x П                                        p                     p^            ]                  0   x П                                     H X   x                                  U         @                             @                     3hY                 ` 
   stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902.cp35-win_amd64.pyd PyInit_stanfit4anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_5412090644529571902           z            V   P                       h `           X                               . p          P 0          p  @                                   d                                             "     6     P     d                                        &     <     V     r     r                  j               *     n               d                                        .     Z     ~               ܽ          .     T               Ծ          $     f     ¿     
               6                         t     V     0                         f     *               d     "               L                    >               h                     V                    J                    H                         n     8     N                                                     @          X     b     x                                 (                       h                       ,                              
                    $                                           h     L     *                         @                            p     T     J          6                            z                                 ^             ȹ                    l     X     F     .           
          и                         t     `     P     @     2                         з     ·                    j     Z     :     ,                    Զ                         l     ^     N     >     ,                    
     ε               ڹ     x     d     P     @     ,                    Դ     ƴ                    x     ^     J     .                    ܳ     ȳ                    z     h     N     >     (                    ̲                          2     B     V     t     h     z               P          ʺ     ޺               8               (     <     P     h     |     &     
                    л                         0     D     b               ޵          ڱ     ±               z     \     J     8          
               Ȱ                        PyBaseObject_Type kPyObject_SetAttr  PyUnicode_InternFromString  < PyCFunction_Type  .PyOS_snprintf PyThreadState_Get _Py_CheckRecursionLimit  PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches v_PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  PyExc_RuntimeWarning   PyErr_PrintEx VPyFunction_Type EPyFrame_New  PyExc_DeprecationWarning  PyExc_KeyError  uPyImport_ImportModule wPyImport_ImportModuleLevelObject   PyErr_NormalizeException  KPyUnicode_AsUnicode iPyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  kPyUnicode_DecodeUTF8  MPyObject_GenericGetAttr PyTraceBack_Here  PyExc_RuntimeError   PyExc_IOError lPyObject_SetAttrString  PyLong_FromLong LPyObject_GC_UnTrack PyUnicode_FromUnicode YPyObject_Hash  PyErr_SetNone PyExc_MemoryError  PyDict_GetItemWithError Py_GetVersion RPyObject_GetAttr  4PyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags ' PyBytes_AsStringAndSize #_Py_NoneStruct  
PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size 7PyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable VPyObject_GetIter  PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx $PyExc_ValueError  _Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError gPyObject_RichCompare  PyTuple_Type  _Py_FalseStruct <PyFloat_Type  PyMethod_Type PyLong_Type PyType_IsSubtype  PyNumber_Subtract  PyErr_Restore 
PyExc_OverflowError qPyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  C PyCapsule_GetPointer  JPyObject_GC_Del  PyErr_Fetch =PyObject_CallFunctionObjArgs  PyLong_AsLong CPyObject_ClearWeakRefs  cPyObject_Not  PyUnicode_FromFormat  TPyObject_GetBuffer  PyList_New  PyModule_Create2  PySlice_New dPyImport_AddModule  PyType_Ready  SPyObject_GetAttrString   PyErr_Clear PyList_Append 3 PyBytes_Type  YPyUnicode_Decode  T PyCode_New  -PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  ;PyObject_CallFinalizerFromDealloc ]PyObject_IsInstance PyExc_StopIteration PyList_Type  PyDict_GetItemString   PyDict_GetItem  UPyObject_GetItem  @PyObject_CallObject  PyErr_CheckSignals  KPyObject_GC_Track 0 PyBytes_FromStringAndSize rPyImport_Import PyExc_NotImplementedError SPyUnicode_Compare ^PyObject_IsSubclass PyExc_TypeError PyMem_Realloc ; PyCFunction_NewEx K PyCapsule_Type  _PyObject_IsTrue PyExc_NameError PyTuple_Pack  _PyByteArray_empty_string Py_OptimizeFlag _PyUnicode_Ready  PyMem_Malloc   PyExc_IndexError   PyExc_ImportError *_Py_TrueStruct  
 PyArg_UnpackTuple PyExc_SystemError  PyExc_AssertionError  mPyObject_SetItem  _PyObject_GC_New  PyTraceBack_Type   PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  nPyObject_Size  PyBuffer_Release  9PyObject_Call $ PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python35.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 1EnterCriticalSection  LeaveCriticalSection  
DeleteCriticalSection SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  vGetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  iSetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  ~IsProcessorFeaturePresent wIsDebuggerPresent AQueryPerformanceCounter GetCurrentProcessId GetCurrentThreadId  GetSystemTimeAsFileTime DisableThreadLibraryCalls aInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  2-+  ] f      /                              ]   09                  (]    1                  8]   0.                                                  Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
                                      e                                                                                                                                       @             0                                                                                                                           @                                                                                           @:                                                                                                                      g                                                                                                                                       @                                                                                                                                                                                                                           Transform parameters from defined support to unconstrained space                	           :    c
                  8|          l                      H|          H              X|                                                   Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                  
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         Transform parameters from unconstrained space to defined support                i   ]          `{   <I   W          {   M   [          8y                                   Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

                                                     g           p                                                                                                                                             b   p                                                  	                                 	                            D      c                                                      0                                            @=
                                                                                              Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

                                      |   p               U                                                                                                                   @              W                   8               P\   0      P                                                                                                                                           T                          f                                                                                                                                       @                                                                                                                                                                                                                       |   T   @T   |           |    T   S   |                                                           H]      @                   X]   0                                                  `                      ,      p                   T   P                      K      `                   h]   @                      x]   `                       ]                          ]   `                      ]      p                                                                   Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.                                     ]   p                                                                  p   P                                                    D      ^      P                                   @                                                                                                                                                         8b                              Q   p                      Hb      P                      0                      Xb      @                   hb                          xb                          V      `                      @                      b                          b                          \   `                                                                      
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
              Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
           $                                                                                      R                   Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
              <   _
          p           Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
            `   P<
                  `    4
                   `   P1
                  Q    *
          0   0`   0
          @   ^   p
          P   @`   p	                  P`    	          @   ``   p	                  h`   	          @   x`   0	          P   `   	             `    	             `   0	             `   `	          
   `   k	             `   0e	          P   a   [	                   a   Z	                  0a   pZ	                  @a   Y	                  Pa   P	                  ha   H	                  a   C	                  a    ?	                  a   :	                  a   6	                  a   05	                  a   3	                  b   p/	                  (b   *	                                                                         `e                                                                                                                                       @             @                                                                                                                      P                                                                                      H                                                   H   `"                                (                      8      &                             &                      x                              l                        h                           x      <                            #                      P   
                           p                                                   H                              (                                                                                 !   $                      Ș                           p   `
                                                      0                            H   
                            	                        
   %                      x   @    (                            A                      `                           8   L                        P   p                           <                        P   h                        И                           h                                 (!                        @   8"                        ȓ   "                           !                        @                            H                                 	                                                   x   
                        (                        h                                   
                                                                               x                            0"                        @                                                                                     $                        0    #                        @                                 	                         4                           x                        p   `                        ؓ   
                            p                           !   
                        h!                        0                           ȏ                                 
                                                   
                        x      L                         
                            P                               
                         D                              	                      З    "                                                                               0   H                        Ȕ                                                      X      +                            
                     0                                                                                 h                           (   
                           x   
                                                p   
                        h                                                             
                     H                              H!   
                                                (   x                        x   t                               
                     h                              
   
                     p   X   
                                                       
                        X   	                                                   !   	                        "   
                                                      
                        `                           @                           h   .                      X   L                        H                               (                           H   
                                                 ؔ      	                     0                              x   
                     H   X                                                      d                        p   !                        Ж                              8   	                         x                              
                     (   0   
                     Ȗ                           ȗ   T                                                      `                        (   \                        x                                                      8                                0   "                                                                                  x                      8   <                        ș       '                         !   "                          l
                           h    
                     X   d                        ȕ   8                                                   h   X                                                    `                              
   	                                                                             (   ,                           ,                           H                           X                                                    ؕ      
                     ؏   p!                        8                                                                                                               t
                              
                     `   x
                            
                           `                                                    Г   X!   
                     h   P                               	                        x                        P                           h   X                           P                        ؘ   0                                                      4                        X                              8                           (                           8                        `      H                        8                              	                     8   8!                        X                           @      
                     8   ,                              	                           	                     X   X   
                     ؖ                           @   l                        К   0   	                     P                                                      (      
                     @      
                                                `      
                     ؚ                              !   	                      h   P   %                         l                        (   
                        X   $                                                     @   D                        h   8                        P                                                         L                                                    (                                                      H                            (   @   	                        ,                                                                                                                             (                                    ȏ   ؏                      h                      (                                            h              ȏ       h           u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AVdivide_dv_vari@?A0xabc9ee0f@math@stan@@                .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                         .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AU?$located_exception@Vexception@std@@@lang@stan@@                       .?AV?$adapt_unit_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                 .?AVexp_vari@?A0xabc9ee0f@math@stan@@              .?AV?$dense_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVneg_vari@?A0xabc9ee0f@math@stan@@              .?AVlogger@callbacks@stan@@                .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                         .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AV?$base_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                       .?AV?$unit_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                 .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AVlength_error@std@@             .?AVdomain_error@std@@                     .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                    .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVcovar_adaptation@mcmc@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .H                 .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                 .?AVbad_exception@std@@            .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                       .?AVanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                   .?AVmultiply_vv_vari@?A0xabc9ee0f@math@stan@@              .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@                      .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@             .?AVadd_vv_vari@?A0xabc9ee0f@math@stan@@                   .?AVadd_vd_vari@?A0xabc9ee0f@math@stan@@                   .?AVbad_typeid@std@@               .?AVop_dv_vari@math@stan@@                 .?AVps_point@mcmc@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@                     .?AV?$adapt_diag_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AUbad_exception_@exception_detail@boost@@                .?AV?$base_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AV?$numpunct@D@std@@                     .?AV?$diag_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVvari@math@stan@@                       .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AVdump@io@stan@@                         .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@                      .?AV?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AV?$adapt_dense_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                     .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AV?$unit_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@                     .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVrounding_error@math@boost@@            .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVunderflow_error@std@@                  .?AV?$adapt_dense_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                           .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$dot_product_vari@NVvar@math@stan@@@?A0xabc9ee0f@math@stan@@                          .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@               .?AVsum_v_vari@math@stan@@                         .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVempty_var_context@io@stan@@                    .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                  .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AVchained_var_context@io@stan@@                          .?AV?$adapt_diag_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AVfacet@locale@std@@             .?AVdiag_e_point@mcmc@stan@@                       .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVfixed_param_sampler@mcmc@stan@@                .?AVout_of_range@std@@             .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                   .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVbase_mcmc@mcmc@stan@@                  .?AVdense_e_point@mcmc@stan@@              .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                 .?AVsum_values@pystan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AV?$base_hamiltonian@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@                       .?AV?$dense_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                           .?AV?$unit_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@             .?AVsubtract_dv_vari@?A0xabc9ee0f@math@stan@@                      .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AVprob_grad@model@stan@@                 .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AVexception@std@@                .?AV?$adapt_unit_e_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVdivide_vv_vari@?A0xabc9ee0f@math@stan@@                .?AV?$base_nuts@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AUPyErr_CheckSignals_Functor@?A0xabc9ee0f@pystan@@                       .?AV?$diag_e_static_hmc@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                .?AVwindowed_adaptation@mcmc@stan@@                .?AVvalue@pystan@@                 .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AV?$dense_e_metric@Vanon_model_047a6166bd9c6ecaed4dd3733fae7c6b@anon_model_047a6166bd9c6ecaed4dd3733fae7c6b_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                                                                                                                                                                                                                                                       V   `             >   @  ^               
   0            F   P                        V   `                                            &   0  F   p       3   `       %   0  p   p       y       H p        m$   $  $   $  %    %  K%   P%  t%   %  &   &  2'   @'  '   '  4)   @)  )*   0*  *    *  +    +  T,   `,  -   -  D-   P-  %.  ( 0.  Y.   `.  .   .  .   .  /  4 /  /   /  [0   0  0   0  0   0  1   1  1   1  1    2  2    2  2   2  3  0 3  3   3  4  ` 4  4   4  5   5  5   5  #6   06  p6   6  6   6  6    7  &7   07  g7   p7  7   7  8    8  g8   p8  8   8  9   9  :   :  ;  ` ;  <    =  =   =  1>  ( @>  k>   p>  ?   ?  ?   ?  @@  X @@  @  X @  @    A  C  h  C  TC   `C  ]D   `D  F   F  G    G  5K   K  L   L  WL   WL  L  x L  L    M  .M   0M  M   M  M   M  P   P  R    R  _T   T  U   U  2V   @V  V  H V  W   X  "Y   0Y  Y    @Z  Z  8 [  "\  p \  \   \  ?]   ]  ]   ]  ]   ]  ^   ^  `   `  `   `   a    a  Fb  x Pb  xc   c  d  @ d  d   e  g  x `i  Jj   Pj  !l   0l  bm  h pm  bp  x pp  p   p  p   p  @q   @q  q  $ q  q  4 q  q  D  r  xs  ` s  t  h t  v   v  w   w  "w    "w  w   w  w  ( w  w  8  x  @x   `x  x  H py  &z  x pz  z    {  D   P  |         0        ӂ           E   P  ˃  (!   2   @    8!     h!   Ë  ! Ћ  T  " `  #  # 0  >   $ @         $    T  p% `  w  %     %   $  % $    &     &                (    P   P  Ǡ  & Ǡ    &   ɡ   С    '    ң   '          '   d  ( p    p)      )   8  ) 8  }  ) }  
  ) 
    )   ȫ  ) ȫ    )     )     *     ,*   <  4* <  ѭ  P* ѭ  c  h* c    x*   ׮  * ׮    h*   |  *   ̯   ̯    *   Ͱ  * Ͱ  9  * 9  n  * n    +     (+     4+   ׳  L+ ׳  a  h+ p  F  ,* F  x  + x  ж  + ж  o   p       ַ          6   @  չ  +   2  , @             X  P. `  u  .   7   / @  L  |0 P    1      2     3     3      4   )  5 0    5     5     5     5     6   N   P  P  6 P  *  x6 0  a  6 p     7   F  07 F    @7     T7   N   P  *  d7 0  '  88 0    h9     :   |  ;     ;     ;     x6      <     4<     D<     X<   "  h< "    |<     <     =    h=   =  4
 8> @
  >   >  /
 > /
 
 > 
 
 >   ]  ? `     ?   @   H@  k x@ p  @  C @ P a 0A p  A   B  # (C # 3% C @% 
' C ' ( 8D ( K, D P, p/ E p/ 2 `E 2 3 > 3 5 > 5 r5 E 5 9 E 9 N: F P: : F : N; F P; ; (G ; < XG  < F<  P< <  < =  = = G = !>  0> >  > >  > 1?  @? q?  ? :A G @A A  A B   B B  B B  B ]C  `C C  C KD  PD D H D sE H E E  E $F  0F dF  pF S   S 
T 0I T ~X `I X X  X #`  J 0` ` J ` Oa K Pa a HK a  b   b b xK b b  b 0c  0c pc  pc c  c ?d K @d d  d d   e Ve  `e e  e f   f |f K f f L  g \g 8L `g g `L g 1h  @h h  h i L i / 0M 0 ޔ   . W 0  ]   d ^ p L  _ P  `     Ǻ  к D ( P  Pb   ߼ b     ?  @   c            I  P  (c   c    Xd  l  e p  e   e   e   @f   * g 0 t g t  g   g   b      
 g  F  P  g     D g P     g  &  0  g  J g P       G h P       Q h Q  h   h   h  D  P  h   h    i      G  d G p     4  @          6  P     (  8 i 8 F $i P  4i   D  P     i   i   i   j   R j `  8j  F hj P  j    j  " j 0  j  n j p c k p d  p  Xk     p  p  (   k   k   k  "  0 H ( H  tl   l  @  p  h  b l b  l   l   h  ` l ` t l             (   l   m  4  @       +  P           %  0  m  ,  0 a  p       i  p T  8m `  < Lm @  `m      m   m      m  S	 n `	 	  	 
  
 
 (n 
  n     D  P  n  D
 n D
 Z
 n `
  n  F o F  o   $o   Do  p  p         P  P     \o    o  z   J  P     i      o  R  `    S  `  Dp  f  p               ! ! p ! x" i " D# ,q D# :& @q :& Q& Xq `& $' ,q $' * hq * 1* q @* *  * + q + , q , -  - -  - .  . .  . "/  0/ /  / /   0 0  0 0 q 0 \1 r `1 2  2 2 0r  3 3  3 6 Hr  6 6  6 7  8 =9  @9 e: dr p: p; xr p; < r < = r = a>  > A r  A A r A ?B  @B C s C C  C &D  0D /F Hs 0F F \s F G  G eG  L L  L M  M M  M [N s `N O s O O   P P s P Q s Q R   R R j R S   S T  t T T t T pU j pU sV  V W s W X  X \ $t \ aa 8t pa a Pt  b b  b b dt b c  c d t d h tu h h u h i u i i u i j u  j j u j jk  pk ;l s  m "m u "m n u n n u n /o v 0o Ro u Ro p v p p ,v p _q <v `q q  q s Pv s u 8w u w x w )x  0x x dr x x x x fy y fy wy  y y z 0y  { | xy | }~ y ~ ~  ~  Xz   j      z  ` { ` ' { 0     (|       P|  $ | 0  |  j  p } |   x}   [  ` 
 H~   ~  X ~ ` 
   l  p Ε  Е $  0       F  P       F  P  X  Ƙ  И  (  F  P    ƙ ` Й  Ȃ  F 0 P    ƚ   К  h  F Є p ל 8   x   f Ȉ p     h    0   t   *  0 & ` 0     $   8    H      W  ` h  p  А  Y  `        0   @   T  F ` F R | R _  `          h  p . ؑ @ l             ~ P      (         (   p      |   r    X   j  p    l   W  p , Pt 0            P  K  P r             O j P    \ Pt `     g  p 	   5  @       J	  P	 
 ,   
 x 
  `   |  T Ț T  ؚ        t            ,"  ," g"  p" "  " # (  # $ H $ (   ) *   * +  + / ( / 94  @4 I8  P8 :  : 2; 0 @; 0D p 0D HT  PT xd  d h H  i :j   @j k ` k *m  0m n ت n q  q u  u v   v x X x y  y { Ȭ { m~   p~ *  0 V  `  Ю  ΢ ` Т  P   0 @ S  S       	    ̷  N @ P ^  ^     ظ        "   " #  # [ ( ` n  n  @   X   h 0       5   5 6 8 6 Y H   `           (   @   T   l  0 | 0        ܻ     L  P       h H p . p 0 O  P         ȼ        <  @                h  p    i  p         M h P <  @ m H p     p   |      z           l  p       J  P  h           >	  >	 N	  P	 	  	 
  
 
       
 $ P ~   &
 , 0
  <   P     J# 0 P# $  $ 
,  , ,   - J-  P- - @ - . h . */  0/ /  / e0  p0 0  0 V1 0 `1 1 X 1 1 h 1  2 |  2 3  3 3  3 m5 u p5 #6   @6 6  6 ,7  07 7  7 8   8 8 8 8 dH ` pH ~S  S -c  0c >n H @n o u o Yp  `p p ` p &q  0q 
r x6 r 9s h @s |  | }  } _~  `~ ~  ~ %  0 ؄   j  p  X         Ќ q X  3  @       ݐ  ݐ      0  > D @  T  ݘ   ٞ H          $ T 0 T  `    %  % l  l w        į  Я  8 @    Ӳ      p L p  `  u p        %  0  (   $    P   7  7          X $ X c 8 p  H   Ț     +  +          6  @ N  N    5 @ 5 ] T ] w d   t          P ( P 4 D 4 O d O  t   d     /  0 O  P          e 0 p 
  
 i  p    Z ( `    e  p !   ! 2'  @' + @ + 0   0 4  4 >:  @: > 0 > D H  D $I p 0I J  J EM  PM eM  eM M h M M | M cP  pP P  P P  P &Q  0Q NQ  NQ Q  Q Q    Q S    T X 0  X Y   Y xj \ j m  m 3 H @    Q  `     8  с h  9  @ 2  < @        V  `    d  p        ކ        (  ߇   ^ X `     J  P    L  	 P P (	 P U 	 `  
   $
  ' X
 0 ē   W  `  
  Ǘ 
 З d       ț  Л  `  4  @ ϝ h Н ֞      d  d u      :  P    0 ^  `  <   (   
  $  0  h  ư  а ± @
 б P 
 P ڳ   l 
  ޴   1 < @ =   @    *   0  P  , x 0 %  0 +  0  8  d  p     p   i  ! x ! '  0        v      6  @ t       4  @    s   O u     Y  ` D ` P |   &  0        H       0       x  |       x6      ;  ;    1  @    K  P  `  1  @       7  7      | 4 | w P w  d   t  
  
 B  P                   $-  0- /  / (2  02 C5 x P5 W:  `: g?  p? wD  D I   I DJ " PJ J |" J M "  N ,R H$ 0R EU % PU Y ' Y ] X( ] ^ )  ^ }^ (* ^ ^  ^ a * a Hb T+ Pb 	e + e e t, e f - f df - pf f H. f g T. g g p. g g . g h . h h . h 
i . 
i i . i i . i i  i ~m . m )s / 0s u  u u 0 u w $0 w x <0 x x L0 x y d0 y z x0 z ~ 0 ~  0  Y 1 `  X2   `  `    j h2  ń  Є v x2   2   3 2 @  u  3 03 @  h3          E  P  p    3   3   3  C 3 P  `4   4  c 4 c  4  ǡ  5 С { $5  & 5 0    	 5 	 ' 5 '  5   5   F p6 F  6  ! 6 0  6   07   7   8   @:   ;   <      =  w =  { =      t>  G > P K >  < ? @ / x 0 E ? E l ? l  ?   ?   @  3 @ 3 P $@ P q @ q 	 4@ 	  H@   n  M X@ M  p@   0 @ 0  @  ; @   n   @  ; @ @ & @ 0 i A p     pA   A   A     x A  > A @ _  `   B   (B      ~ XB     > B @  B   u   B    C   `C  @ C @ , C `   D   J HD P  pD  L D P  D  : D @  E  < 8E @  `E  R lE R  E  s u     c E p #  E 0    F   pF    F  G F G  F  
 G 
 _
 XG _
 f
 lG f
 l
 G l
 r
 G 
 
 G 
  G   G   G   )  )  H    H  F 0H P       0  0 O  P z    ` `H `  H   H  : H :  H    I    I    I   4I   PI   `I  T  pI T    I   R! I R! ! I ! " I " " I " l$ I p$ $ I $ c' J c'  ( J  ( ++ 0J ++ 1+ DJ 1+ R+ TJ R+ . dJ  . . tJ . 3/ J 3/ 0 J 0 0 J 0 3 J  3 3 J @5 5  5 )7 J 07 ]: (K `: =; x6 @; ; u ; ? dr ? #? K #? ;? K ;? ? K ? ? K ? ? K ? %B K 0B C (L C C (! C C pL C D L  D E L E E u E E @ E F L F `G L `G G @ G H M H H $M  I 'I @ 'I I 4M I J TM J J dM J 5K pM 5K 6K M @K qK @ qK K M K L M L &N M 0N O (N O O N O Q N Q R N R @S N @S S N S 0T N 0T OT  PT T N T U  O U U  U V   V V PO V Y ( Y \ 
 \ <] O @] v] O v] _ O _ +_ O 0_ _  P  ` \` P `` ` 8P  a Ja `P Pa a P a Lb P Pb c P c c Q c Nd HQ Pd e xQ e g Q g g  R g h @R h j TR j 0k  0k Ok  Pk l dR l m R m @n   o o 
 o r R r r @ r s R s et S u <u n <u u S u )v 8S 0v \v n \v ]w HS ]w w dS y y tS y y |S y z S z z S z z S z { S { B} S B} G} T P} o}  p} } ,T  ~ ~ XT ~ G T P  T      ( u 0 ł U Ђ  @U    hU   U  ӄ U ӄ  U   Ӆ U    V   HV   ˎ V Ў        (W   X PW `  W  A W P 9 X  7 @ 7  LX   lX  ݣ @ ݣ  |X   X  3 X @ F X P ; HY @  
   Y  a Y a  Y   Y    Y  e Z e b (Z b  `Z   pZ  6 |Z 6  Z  
 Z 
  Z   G @ G  Z   Z   Z   [    [   S  S  0[   D[   T[   p[  s [ s  [   [   [   [  D \ P X u `  (\   x\ @ ' \ 0  \    ]   H]   T]   ]   m ] m  ]   ]  n ] p ( `^ 0 \ n \  ^  I ^ P  T[  j ^ j  ^  r
 ^ r
 1 ^ @ w $_ w  @_   X_  } l_   |_   _  X _ `  n  L _ L y _  2   @  _    `   8`   D`   \`  K" l` P" $ ` $ K% ` K% (  a ( )  a ) ) 0a ) * La * , a , , a , - a - - a - 1. 
 0 a1 a d1 1   2 !2 b $2 B3  D3 l3  l3 3  3 3  3 c4  d4 4  4 W5  X5 5  5 5  5 6  6 6  6 D6  D6 Y6  \6 6 j 6 6  6 7  7 M7  P7 8 Db 8 8 b 8 8  8 9  9 W9  X9 o9  9 9  9 9  9 '; Pb (; ; |b ; < b < < j < 5=  @= t=  t= E> b H> > b > @ b @ C@  x@ @  @ @  @ @  @ B b B C  c C C  C C  C BD  DD D  @F F c F F 4c F F Hc F kG `c kG G tc G G c G 	J c 	J 1J c PJ J c J tK c K EL c PL L c M N c N N d  O O d O [P $d pP .Q ,d PQ R 4d R S @d  S S Hd S T `d @T T hd T T pd T |U xd |U U d U U d  V V d  W W d W .X d @X X d X @Y d @Y Y d Y _Z e _Z [  e [ V[ 4e V[ [ @e [ =\ Te P\ \ de \ :] le :] ] e ] ] e ] ^ e ^ 7_ e @_ ~_ e _ ` e @a a e a :d e @d ud e d de e pe e f g =h f =h ]h f ]h h 0f h h Hf h i Pf i Hi df Hi li |f i i f i i f i (j f (j Lj f `j j f j j f j k f k ,k g @k k g k k g k k 0g k l Hg  l yl Xg yl l `g l l tg l l g  m hm g hm m g m m g m n g n 8n g 8n hn g hn n h n n h n n h n n $h  o o ,h  o /o 4h @o Oo <h `o oo Dh o o Lh o p Th p q lh  r pr h pr Cs h Cs Ss h `s s h s 3t h @t {t h {t 
u h 
u Lu h `u u h u !v i !v v i v v ,i  w x <i  y 5y Pi 5y y \i y y ti y z i z z i 0z z i z T| i |  i    i   I i I Ń j Ń  j   ,j   ʆ Pj І  Xj  m `j  = hj P > pj P i xj ` ڍ j Ў y j  ' j 0  j А 7 j @ ] j p  j  ? j ? U j `  j `  k  f k f J (k P  8k   P @k P ~ Tk ~  hk   xk  ) k 0 2 k p  k   k P  k О  k    k   k   l    l  o 0l   <l   Dl   Ll   s Tl  [ dl p U tl `  l   l  R l `  l   l  q l  s l   l  { l   m    m   m   (m   4m 0 ~ <m  + Lm @  Xm  7 `m @  hm  ; xm P  m  M m   m    m  - m `  m   m m  
 m @  m  & m P  m  ]  n   n   n      n  G 0n G  8n   Ln  \ \n p  ln  M tn   n   Q n `  n  - n `  n  = n p  n   n  V n   n  ! n @ q n   n  < n P   o  ~ o   o    o  
 4o   Do  ~ Lo   do   xo  ' p 0  \p    $q  W	 q `	 (		 r 0		 
	 r 
	 	 r 	 A	 Ls P	 	 s 	 -	 s @	 	 s 	 (	 s 0	 g	 s p	 	 s 	 	 s 	 %	 s p	 	 s 	 	 t 	 %	 t 0	 e	 t 	 	 $t 	 '	 ,t 0	 e	 4t p	 	 @t 	 '	 Lt 0	 g	 Tt p	 	 \t 	 	 ht 0	 g	 tt p	 	 |t 	 	 t 	 % 	 t p 	  	 t  	  	 t  	 %!	 t 0!	 e!	 t !	 !	 t !	 '"	 t 0"	 e"	 t p"	 "	 t "	 '#	 t 0#	 g#	 t p#	 #	 t #	 #	 u 0$	 g$	 u p$	 $	 u $	 d%	 $u %	 %	 0u  &	 7&	 8u @&	 u&	 @u &	 &	 Lu  '	 7'	 Xu @'	 w'	 `u '	 '	 hu '	 '	 tu @(	 *	 u *	 `+	 u p+	 ^/	 u /	 n3	 $v 3	 )5	 v @5	 6	 v 6	 :	 @w  ;	 >	 w ?	 B	 8x  C	 H	 x H	 uP	 y P	 Y	 (y Y	 _Z	 y Z	 [	 y [	 %e	 y @e	 k	 z k	 l	 l{ l	 l	 x{ l	 }	 { }	 }	 { }	 +~	 { +~	 Z	 { p	 	  | 	 	 | 	 	 8| 	 	 L| 	 *	 \| 0	 ͔	 | 	 	 | 	 	 | 	 Ο	 | Ο	 	 | 	 	 |  	 	 $} 	 ɢ	 8} ɢ	 	 D} 	 	 h} 	 	 x} 	 '	 } 0	 @	 ~ P	 ط	 ~ 	 e	 x p	 h	  p	 r	  	 	   	 	  	 	  	 	  	 	 0 	 	 @  	 	 T 	 \	 ` \	 x	  	 j	  	 	  	 	 Ā 	 5
 ؀ 5
 
  
 	
  	
 f
  p
 O
 D `
 "
 d 0
 2
 | @
 p
  p
 )
  )
 )
 Ё )
 *
   *
 ",
  0,
 A,
  A,
 +1
  +1
 F1
 @ `1
 y1
 P y1
 3
 \ 3
 4
  04
 E4
  E4
 6
  6
 6
  6
 6
 ̂ 6
 9
 ܂ 9
 F:
  F:
 :
  :
 H<
 ( `<
 <
 @ <
 <
 H <
 :=
 P @=
 ?
 ` ?
 QI
 | `I
 I
  I
 ^
  _
 a
 T a
 c
 p 0c
 {k
  k
 s
 ( s
 
 Ј 
 
 P 
 
 \ 
 
 p 
 
  
 ?
  ?
 
  
  ȉ      T   W \ `  d p  p   x  %  0 e      '  0 e  p         ̊   d  Ԋ p    ܊        %!  0! e!  ! !  ! '"  0" "  @# w#   # # ( # # 0  $ 5$ < $ % H @% % T % % \  & 7& d @& w& l & 4' t ' '  ' (  ( (   ) )  ) c*  * *   + v+  + + ċ + $. ̋ @. Y.  Y. 0  0 0  1 %1 $ %1 ~3 0 ~3 3 L 3 3 \ 3 6 l 6 &7  &7 7  7 (9  @9 o9 Ќ 9 9 ، 9 4:  P: :  : :  : ';  0; ;  < O?  `? g@  p@ `A   pA A ( A K 0 K VN  `N N ȓ N 9O Г 9O O  O O  O tP  tP P  P ^Q   Q R , R MR 4 MR R H R R \ R MS p MS S  S S  S T  T 5T  8T T n T U  0U U Д U X ؔ X p[  [ [ c [ \ @  \ F\ @ F\ l\ @ ] ] @ ] ] @ ] ^ @ ^ _ @ b c @ `c c ' 0d d ( d e `) e f , h Eh @ h i h0  j Ij @ j l 1 `l m 2 (m m 3 t u @  { D{ W { S| ] | >} ] } W~ ] ~ L ]  7 ] p  @   c < e @   @ ( Q @ @ \ @ \ x @   h  ^ i `  k   `l 0 ^ @   @ Ї > 0p p ވ q  ? Pu ? މ `u  0 (w H  x  Њ x   @ ȋ   {  6 @   @ p  H     ˍ  Ѝ       + P 0 K  P k   p       ˎ X Ў     ( |  @ ؐ    4 X X t      Ԓ     6 @ \  @   @   @ 0 Z @ `  @   P @ P m @ p ޕ x    @   - @ @ n @  ʖ @      R  `  @   @ @ n @  ט @ L v @  ҙ @ ҙ  @  F @   @  Ϛ @   @  ś @      * @     @ d 0 p     @      @ Ч  @     ;  w       +  g     @ P    г  @  : @ P z @  ) @  ȶ   I @   @   r   , @ , K @ P y @  ں @  ѻ x ݻ  @ : Խ x   x f 1 x T  @ ( R    p   T @     /       0 ` H      /     8   ` 0     H         @   * @ `  @   0 @ 0 M @ P z @ 0 Z @    d 8 x P 8   h        !  ~ h"   " @ \ @ \  *   @   *   @+    @  < + @ z `,   @   -   @   -    @  < 8.   1 
 % H2    7   7 P  `>   >   @  J ? `  @   @ @ j @  
 @   <b  # @ # ? @ ? u ,*   o   Tp  4 q L u q    r   r ' P r \  Ds   s  a \{   ~  - h E b  b       *  * J  J     ,   4  - D 9 b     Ȉ  <  < u  u    
  
 f , f  <   L  W \ W  l   |  H  H {     ) F       S  `        3  @    ]  `       ]  `                                                                                                                                                                                             1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `P                    <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                     PXhpxȪЪت  (08@HPX`hpxxȬЬج  (08@HP             (08@HPX`hpx  (08@HPX`hpxȫЫث  (08@HPX`hpxȬЬج  (08@HPX`hpxȭЭح  (08@HPX`hpxȮЮخ  (08@HPX`hpxȯЯد    `    (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء  (08@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPX`hpxȤ  (08@HPX`hpxȦЦئ  (08@HPX`hpxȧЧا  (08@HPX`hpxȨШب  (08@HPX`hpxة  (08@HPX`hpxȪЪت  (08@HPX``hpxȬЬج  (08@HPX`hpx (08@HPX`hpxȮЮخ @HPX`hpxȯЯد    
     (08@HPX`hpxȠРؠ  (08@H  (08@ȢТآHPX`hpxȣУأ  (08HPX`hpxȤФؤ  (08@HPX`hpx 
 L   ح`hpxȮЮخ  (08@H    
 4    (08@HPX`hpxȠ 
    (@Hhpx    H   @H`hءxXأxХ08HPXhpx       H`8HPhȦئ Шبx8@PX`hxЫث  (0HPXpxȬЬ 8@H`hpЮPX`د        08X`hРؠ  (0HPXpxȡС@ 0  (@H`hxȮ  (8@HX`hxȯد      (@H`hȠ  (@H`hȡ0808X`Фؤ  (HPpxȥ8@`hئ (0PXxȧЧ @Hhp08X`Щة  (HPpxȪ8@`hث (0PXxȬЬ @Hhp08X`Юخ  (HPpxȯ     8@`hؠ (0PXxȡС @Hhp08X`Уأ  (HPpxȤ8@`hإ (0PXxȦЦ @Hhp08X`Шب  (HPpxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد 0    (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp (@H`hpȧ  (0@HPp X PЬ@8`Я @ 4   0X0pHp@ P X   x0` HpX HȦ P `Ъ @p `@p ` 8   0pPx@Ш 8pPЬ0 p L    h 0p ` X@pب@pة 0 (`  ,   H@pСPPx                                                                                                                                                                                                                                                                                                                                                                                                                                                    ub.