4     pystan.model	StanModel)}(
model_codeX  data {
  int T;                                // Sample size
  int<lower=1> K;                       // Number of seasonal vectors
  real t[T];                            // Day
  real y[T];                            // Time-series
  int S;                                // Number of changepoints
  real A[T, S];                   // Split indicators
  real t_change[S];                 // Index of changepoints
  real X[T,K];                // season vectors
  vector[K] sigmas;              // scale on seasonality prior
  real<lower=0> tau;                  // scale on changepoints prior
}

parameters {
  real k;                            // Base growth rate
  real m;                            // offset
  real delta[S];                       // Rate adjustments
  real<lower=0> sigma_obs;               // Observation noise (incl. seasonal variation)
  real beta[K];                    // seasonal vector
}

transformed parameters {
  real gamma[S];                  // adjusted offsets, for piecewise continuity

  for (i in 1:S) {
    gamma[i] = -t_change[i] * delta[i];
  }
}

model {
  real Y[T];

  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  for (i in 1:T) {
    Y[i] = (dot_product(A[i], delta) + k) * t[i] + (dot_product(A[i], gamma) + m) + dot_product(X[i], beta);
  }
  y ~ normal(Y, sigma_obs);
}

model_cppname+anon_model_1988b9d517e3c16daf27a07f09e3de97
model_name+anon_model_1988b9d517e3c16daf27a07f09e3de97module_nameGstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200module_filenameZstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.cp35-win_amd64.pyd
model_cppcodeXg  // Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "unkown file name");
    reader.add_event(45, 45, "end", "unkown file name");
    return reader;
}

class anon_model_1988b9d517e3c16daf27a07f09e3de97 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> y;
    int S;
    vector<vector<double> > A;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
public:
    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 4;
            validate_non_negative_index("t", "T", T);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
            validate_non_negative_index("t", "T", T);
            t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
                t[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("y", "T", T);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
            validate_non_negative_index("y", "T", T);
            y = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            current_statement_begin__ = 7;
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            context__.validate_dims("data initialization", "A", "double", context__.to_vec(T,S));
            validate_non_negative_index("A", "T", T);
            validate_non_negative_index("A", "S", S);
            A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
            vals_r__ = context__.vals_r("A");
            pos__ = 0;
            size_t A_limit_1__ = S;
            for (size_t i_1__ = 0; i_1__ < A_limit_1__; ++i_1__) {
                size_t A_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < A_limit_0__; ++i_0__) {
                    A[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("t_change", "S", S);
            context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
            validate_non_negative_index("t_change", "S", S);
            t_change = std::vector<double>(S,double(0));
            vals_r__ = context__.vals_r("t_change");
            pos__ = 0;
            size_t t_change_limit_0__ = S;
            for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
                t_change[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
            validate_non_negative_index("X", "T", T);
            validate_non_negative_index("X", "K", K);
            X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_limit_1__ = K;
            for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
                size_t X_limit_0__ = T;
                for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                    X[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("sigmas", "K", K);
            context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
            validate_non_negative_index("sigmas", "K", K);
            sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            vals_r__ = context__.vals_r("sigmas");
            pos__ = 0;
            size_t sigmas_i_vec_lim__ = K;
            for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
                sigmas[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            check_greater_or_equal(function__,"K",K,1);
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            current_statement_begin__ = 7;
            current_statement_begin__ = 8;
            current_statement_begin__ = 9;
            current_statement_begin__ = 10;
            current_statement_begin__ = 11;
            check_greater_or_equal(function__,"tau",tau,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 15;
            ++num_params_r__;
            current_statement_begin__ = 16;
            ++num_params_r__;
            current_statement_begin__ = 17;
            validate_non_negative_index("delta", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 18;
            ++num_params_r__;
            current_statement_begin__ = 19;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~anon_model_1988b9d517e3c16daf27a07f09e3de97() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "S", S);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_constrain(lp__);
            else
                k = in__.scalar_constrain();

            T__ m;
            (void) m;  // dummy to suppress unused var warning
            if (jacobian__)
                m = in__.scalar_constrain(lp__);
            else
                m = in__.scalar_constrain();

            vector<T__> delta;
            size_t dim_delta_0__ = S;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_constrain(lp__));
                else
                    delta.push_back(in__.scalar_constrain());
            }

            T__ sigma_obs;
            (void) sigma_obs;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_obs = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_obs = in__.scalar_lb_constrain(0);

            vector<T__> beta;
            size_t dim_beta_0__ = K;
            beta.reserve(dim_beta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
                if (jacobian__)
                    beta.push_back(in__.scalar_constrain(lp__));
                else
                    beta.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            current_statement_begin__ = 23;
            validate_non_negative_index("gamma", "S", S);
            vector<T__> gamma(S);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma,DUMMY_VAR__);


            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < S; ++i0__) {
                if (stan::math::is_uninitialized(gamma[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 23;

            // model body
            {
            current_statement_begin__ = 31;
            validate_non_negative_index("Y", "T", T);
            vector<T__> Y(T);
            stan::math::initialize(Y, DUMMY_VAR__);
            stan::math::fill(Y,DUMMY_VAR__);


            current_statement_begin__ = 34;
            lp_accum__.add(normal_log<propto__>(k, 0, 5));
            current_statement_begin__ = 35;
            lp_accum__.add(normal_log<propto__>(m, 0, 5));
            current_statement_begin__ = 36;
            lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
            current_statement_begin__ = 37;
            lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
            current_statement_begin__ = 38;
            lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
            current_statement_begin__ = 41;
            for (int i = 1; i <= T; ++i) {

                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((((dot_product(get_base1(A,i,"A",1),delta) + k) * get_base1(t,i,"t",1)) + (dot_product(get_base1(A,i,"A",1),gamma) + m)) + dot_product(get_base1(X,i,"X",1),beta)));
            }
            current_statement_begin__ = 44;
            lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("gamma");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(sigma_obs);
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 23;
            validate_non_negative_index("gamma", "S", S);
            vector<double> gamma(S, 0.0);
            stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma,DUMMY_VAR__);


            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }

            // validate transformed parameters
            current_statement_begin__ = 23;

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_1988b9d517e3c16daf27a07f09e3de97";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}

typedef anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97 stan_model;

module_bytesB  MZ                @                                       	!L!This program cannot be run in DOS mode.

$       EG^&0&0&0^&0l{1&0:x3&0:x4
&0:x1&0:x5&0x1&0&1h'0x9 &0x0 &0x &0x2 &0Rich&0        PE  d	 hY         "     &     X                               @         `                                   x    |y            k           0 0  P
                    
 (   p
              P
                          .text                           `.rdata  R                   @  @.data                        @  .pdata  k     l   <             @  @.gfids  <                      @  @.tls    	                       @  _RDATA                        @  @.rsrc                          @  @.reloc  0   0                  @  B                                                                                                                                                H(H
P P A   HP    H$ HP     H
P P  J H
 H(b H(H
P  A   HP    H HO     H
O O   H
# H( H(H
UO  A   HWO    H H=O     H
&O O   H
c H( H(u
 # O H(H(u
 # oN H(t
 ^XN 8N H(t
 u# wN H(H(t
 U# M H(M W~
 O H(t
 -# # W~
 #O H(M XM PN H(H
N   A   HN    H HN     H
N N   H
 H(2  H(H
N  A   HN    H HM     H
M M   H
Ӻ H( H(H
L ` A   HL    Ht HL     H
L L  Z H
 H(r H(H
}g   WHzg     H
K [g H(2 H(H
j  WHj     H
 j H( H( WHj     H
2 j H( H(2  H
  H( H(H
f 0 WHf     H
{ f H(b H(H
f  WHf     H
 f H(" H(H
h  WHh     H
[ h H( H( H
 H( H( H
 H( H(7  p
  Tc{
 f/r
 v  "     q
 k T4{
 f/lr
 v  "   H(H([ H(H(7 H(鋑  k H(Q H(o
 c o
 # H(o
  H(H(o
 ? H(H
 d   @SH HHHSH
! H3H
HJHH HH [H HHH% HQH HHEH\$WH H HHH t
   H HH\$0H _3HAHk HAHh HHH(LH3IL;v} MI   r<td HAH;rT H+HsD H'v7 HH( @SH0HzHHrHHSHD$ H
 D$(H3H
HJHL$ ^ H HHH0[@SH HHHSH
a H3H
HJHH H HHH [H8HD$ HIHtHPHtL    HH8I H8LWH   ICI[Is H6 H3HD$pH3t$ HAHuIC   Is@t$PISȍ~KHP(HuHP0HD$H   Ht$@@t$0@82uL
IIB84uHL$0I HT$0   HC   HsH{rHH  H @trHD$HHrQHHL$0H=   r<tO HAH;r? H+Hs/ H'v" H HD$H   Ht$@D$0 @t\HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v H| HHL$pH3 L$   I[ Is(I_LVWAVH   HD$(I[Ik Hb H3H$   HH3ۉ\$ HBH9A   IS   \$ HxHxrH H?LH;LBMtH H uH;tqHT$PHLD$    HT$0Hu   I~I~rM6HpHxrH H?H6LH;LBMtIHZ uH;rv@2@tvHD$HHrQHHL$0H=   r<t; HAH;r+ H+Hs H'v H HD$H   HD$@    D$0 tvHD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v Hb HD$h   HD$`    D$P t_H$   HrQHHL$pH=   r<tE HAH;r5 H+Hs% H'v H @H$   H3c L$   I[0Ik8IA^_^́aHI    ́aHI   H9 HH\$Hl$Ht$WAVAWH HrE3HLH(IDIHK HGAH+HHt6@ Ht
,HqK HHH HGHH+HH;rM)IDHH\$@Hl$HHt$PH A_A^_%K @USVWATAVH$XH  HD$`H H3H  IMLHH   IyrI	HA   M9AMBAMtH] B   H  HIHP   Hp   HIHPH
U Hv HEH  ,H HH H HIBL HH H HI(L HH G HHL Hp  Hp   HHxrHH? HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H} HD$ HqR HL$ u HIHP   Hp   H~ H  :G HH( +G HIPK HH G HI6K HH F HHK Hp  Hp   HHxrHHM HD$ 3HD$(HD$0HL$8D$@HT$(HL$8 H HD$ HQ HL$  HMHT$HHPHT$PLL$HI+HLHFI+HH;  HL$p H HM'F HH F HI=J HH E HI#J HH9 E (HMG 3ۋHFH+HHt9D  Ht,HMG HHHM HHFH+HH;r̲)HMG H" HMqE (HMG HD$PHL$HH+HHt<Ht,HM`G HL$HHHMm HHD$PHL$HH+HH;rĲ)HM)G Hp  HL$p HHxrHHl HD$ 3HD$(HD$0HL$8D$@HT$(HL$8	 H HD$ HO HL$  3ۋH  IM+     HI9uHHH;r{  HMp H H   ID HH7 :D HI_H HH  D HIEH HH D HH: HH@ C LHUp/H H   C (H   E HD$PHL$HH+HHtBHt,H   E HL$HHH    HHD$PHL$HH+HH;r)H   xE Hp  HMp( HHxrHH HD$ 3HD$(HD$0HL$8D$@HT$(HL$8Y H HD$ HM HL$  MtLD$XM+II H  H3 HĨ  A^A\_^[]3HHAHAHH\$WH0HD$        H HHHH\$@H0_H\$Ht$WH0HD$        IHV HHHH\$@HpHHt$HH0_@SH Hs HHt
    HH [@SH H   H HH [H% HL$UVWAVAWH0HD$ H\$pILHHj HHqHt$hE3L>L~A HH_H\$hL;L{@ HL(L0L8L@LHLPLXL`LhI;t8HHRH> HH@HH HH@L~DD$`IH˱ H;t9HHRH'< HH@HH HH@L{DD$`HHް HH\$pH0A_A^_^]H\$Hl$Ht$AVH LHH HI;FtHP H yI^I;^u3HINͯ HI;FtHP H yI^I;^u2H\$0Hl$8Ht$@H A^H\$Hl$VH HqHHb HH;tHP H~ yHH;H\$0Hl$8H ^HAUAVAWH`H@HXHhHpHx ILL3t$ IH HI}H;tHP H tHHH;t-IM轮 HH;tHP H yHHS@   IM萮 HI}H;tHP H tHH;   HIMY HH;tHP Hu tHHS@HL$Hͬ H|$PH\$HH+HHHL$0 HD$0Ht@ fnHH;rIHD$8IFHD$@IFHt"LD$XL+IH| IU(I~ IL\$`I[ Ik(Is0I{8IA_A^A]H\$Hl$Ht$WAVAWH0HD$     LIHIK IHH;tHP Hc yHHH;t*IO HH;tHP H7 yHHSX?IO IHH;tHP H	 yHH;tHIO IWXH H\$PHHt$`Hl$XH0A_A^_H\$Hl$Ht$Lt$ AWH0HD$     LIHIY HI;GtHP Ht yI_I;_t/HIO* HI;GtHP HE yI_HS@IW@H蛪 H\$@HHt$PHl$HLt$XH0A_H\$Hl$Ht$Lt$ AWH0HD$     LIHI虫 HI;GtHP H yI_I;_t/HIOj HI;GtHP H yI_HSXIWXH H\$@HHt$PHl$HLt$XH0A_H\$Ht$WH HHH3q HGHH;tiD  HS HT { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$Ht$WH HHH3 HGHH;tiD  HS H褷 { uLHCx u"HH x u6     HH x t HCx uH;Xu
HH@x tHH;_uH\$0Ht$8H _H\$WH H,   t
p   H HH\$0H _H\$WH HQX3HHtLAhL+I H_XH_`H_hHW@HtLGPL+I H_@H_HH_PHW(HtLG8L+In H_(H_0H_8LGHT$0MHOM j HO LGHT$0MHOM 9 HO H\$8H HH _@SH LHT$0MHM  HH [w @SH LHT$0MHM  HH [G HQ H@SH H; HHt
    HH [@WH0HD$ H\$PHt$XHH3H\$@HJHt4HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt
HHP H\$PHt$XH0_HtH   H @SH HC HHt
    HH [@WH0HD$ H\$@HHtDCu5HHP{u!LI@H
cH;HuAАH\$@H0_HL$HT$LD$LL$ @SH H HHt
   6 HH [@SH Hc HHt
    HH [H(HIc: HHy< H(H%v @SHPHD$ H~ H3HD$HHHHT$(H HHK: HH<  HD$@HrQHHL$(H=   r<ts HAH;rc H+HsS H'vF H HL$HH3 HP[H(HIs9 HH; H(H% @SHPHD$ H} H3HD$HHHHT$(H HHK9 HH(; * HD$@HrQHHL$(H=   r<t HAH;rs H+Hsc H'vV H% HL$HH3 HP[H(HI8 HH: H(H% @SHPHD$ H} H3HD$HHHHT$(H HHK"8 HH8: : HD$@HrQHHL$(H=   r<t HAH;r H+Hss H'vf H5 HL$HH3 HP[H(HI 7 HH9 H(H% @SHPHD$ H| H3HD$HHHHT$(H HHK 27 HHH9 J HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'vv HE HL$HH3 HP[H(HI(6 HH8 H(H% @SHPHD$ H"{ H3HD$HHHHT$(H HHK(B6 HHX8 Z HD$@HrQHHL$(H=   r<t HAH;r H+Hs H'v HU HL$HH3 HP[@SH H HHt
0   & HH [HY HHI H\$WH H HHHݭ t
(   H HH\$0H _@SH HHHSH
a H3H
HJHH Hl HHH [Hq H@SH H[ HHt
   6 HH [@SH H HHHt H HH [6 K7 H(HQHI?4 HHU6 H(H%R @SH HHQHI
4 HH3 HH6 H [H% H\$WH Hߠ HHH论 HO Ht
0   H* HH\$0H _23HHBHBH@SH HHRH{g HHCH [H\$WH HHHIHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHHIHPuHOHHPuH\$0H _ðH\$0H _HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIP LǄtHNHHT$HP(Hȍ}HNHHT$0P(Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+I HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HPHȍ}HNHHT$0PHȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+Ib HH\$pHl$xH$   H`_HWH`H@HXHhHpIHH3hHIHIPLǄtHNHHT$HP0Hȍ}HNHHT$0P0Hȿ   H+HkHkHHHAHCHAHCH)HiHi@t,HT$0HtLD$@L+I WD$0Hl$@@tHT$HHtLD$XL+IR HH\$pHl$xH$   H`_@WHPHD$0H\$`HHHIHP8WD$8HD$H    HKHHT$8P8LL$@LD$8HWHe HL$8Ht HT$@b LD$HHT$8L+IZ H\$`HP_@WHPHD$0H\$`HHHIHP@WD$8HD$H    HKHHT$8P@LL$@LD$8HWHź HL$8Ht HT$@pa LD$HHT$8L+I H\$`HP_@SH HS HHt
   v HH [H\$Ht$WH H HH3HIPH*Ht:HSXd HK`HH+KPHHLI?LHSP! H{PH{XH{`HS8HtLCHL+I< H{8H{@H{HHK Ht:HS(c HK0HH+K HHLI?LHS  H{ H{(H{0HKHt)HS+` HSLCL+Iw H{H{H{Ht$8H HH\$0H _@SH HYLHIH[ H;H [Hl$Ht$AVH0HHHQE3HIDt$ e[ H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HEPHHd Hl$@HHt$HH0A^Hl$Ht$AVH0HHHQE3HIDt$ Z H;EuL6HLvLvHl$@Ht$HH0A^H+EHH@HE HH Hl$@HHt$HH0A^HHQHq @SH0HD$     HQ8H裫 HH0[HHPWATAUAVAWHPH@HXHhHp MILE3D`III+	H*HHHHH?HI軜 D$    HAIVI+HHHHH?Hh  AI@ fff     IA   IL2LL2M+IMt
MHI;rJWD$0Ld$@LHHL$0Y I?HHD$0H;t?HHtLGL+I L'LgLgHD$0HHD$8HGHD$@HGTHL$0HtJHD$@H+HI;   H    H=   r ukHAH;s[H+HrKH'w>H- HHHIVI+H*HHHH?HH;s(     IL\$PI[0Ik@IsHIA_A^A]A\_H\$WH H<t
h   H HH\$0H _@SH  HD$HHl H3H$p  ~ HH      HL$P H HL$`e# HH HH)  H$P  HL$P HxrH H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8J H HD$ H- HL$  H$p  H3 HĀ  [HL$WH@L?7 HH

7 IL
7 LL+6 IL7 M;s$K9<sIHH+6 HL6 L;rH\$XHt$hM;~  H6 HpHH;HBHHt$`hH6 HHD$PHD$PH;sNH
h6 HD$PH;w=H\$PH+HH;[6 uH
B6 ] H>6 Ht;H*6 HH
$H;*6 uH
6 , H
6 Ht
HH5 HH5 Hz    H
5 HD$`L
5 H;sLHD$`L;wBH\$`I+HH;
5 u   H
5 X H
5 L
5 HtGIH0H;
5 u   H
5 " H
{5 L
l5 HtH1H
e5 L
V5 Lg5 HH
L5 H%5 Ht$hH\$XJH8H
L5 KHH65 H@_3H( HD$0HL$ H HD$(H HD$ n HT$HL$WH@HD$ H\$hHD$X   H=4 H|$`   dHD$PWft4 3H{4 LD$P Hq4 Wfn4 LD$XH
Z4  He4 H.4 H
HL$XH
W4 HHU4 HV4 WfS4 f[4 Hd4 He4 fe4 H9u13HD$8H
 HD$0H HD$(H' HL$(V HH\$hH@_H\$WH H3 3H
3 HH+HHt7D  HHtH H_3 H
P3 HHH+HH;rH3 HH   H3 H+HH;v H    H=   r<tg HBH;rW H+HsG H'v: HH H
2 Wf$3 H=3 H2 H   H2 H+HH;v H    H=   r<tЛ HBH;r H+Hs H'v HHo H
2 Wfm2 H=v2 HG2 H   HG2 H+HH;vU H    H=   r<t9 HBH;r) H+Hs H'v HH H
1 Wf1 H=1 H1 H   H1 H+HH;v H    H=   r<t HBH;r H+Hs H'vu HHA H
0 Wf0 H=0 Ht}H0 H+HH;v2 H    H=   r<t HAH;r H+Hs H'v H WH=n0 fV0 H\$0H _L0 L9z0 u0H)0 HN0     HH,0 HM0 H HH80 I@IHH
A0 H
R0 HH0 HH
=0 H
N0 HH0 HH/ H
20 @SH HHHSH
 H3H
HJHHs H HHH [@SH H~ IHHHA    HD$0H. HL$0H;sdH. HL$0H;wSH|$8H|$0H+HH;y. u   H
[.  HW. HH. HtHHH=. H|$80H;7. u   H
. L H. Ht
HH. HHH- H [H} H@SH H} HHـu
   ;HH [@SH@HD$ )t$0(HHo. HHHa. H;R. r
   HHL$PHt
(3HH(t$0H@[HH3H! HD$0HL$ H HD$(H HD$ R H\$ WH Hb H3HD$3LA8Lщ:Lʉ9   3H|$H<$\$2ۉT$׉$L$@      D=   "  HA,P  AO  IA      A      A      A       A`      A       A       A       A      A      A      A  }A   tA9oA   fA   ]A     TA   KA99t	A    =A   A    +A    "A  0  A  @  A   A    HHtA A9uA8A
AA
AA 
A HL$H3觻 H\$HH _kN  wN  N  N  N  N  N  AO  N  N  N  N  N  N  O  O  O  O  !O  *O  JO  SO  \O  eO  nO  uO   	
	
	
 	


	

@SH@eH%X   H)t$0(1
$
    )|$ (=O;
 Hȋ
9)    f]5d<
 f_5<A
 fYfX= :
 ffT=l:
 f\(|$ ((fY
7
 fY:
 f\ff\f( (frfYfpc((fY%7
 fY
7
 fX%8
 fX
8
 fYfYfX%9
 fX
J9
 fY(t$0fYfX
:
 f\f^fY%:
 fX%9
 fYf_H@[H
( o =( fo6
 H
' f'  @SUVWAVH0LHHA3HA3Genu   ineI  ntel  E3AAAEf   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AE$  A|  Authuentiu^cAMDAMDiuEsbetuFter!u>3ɸ    3
  
      E3AAAEѸ   ADDAASuLAÁ  Ё  ÍAAAtAt
Au
AEt(A| LD$`HT$hHL$p|$`t$hl$pHcŹ   HNI   HcHNIF    HcHNIFIH0A^_^][HQII      BD$HD$I#I;w?HA @D$HD$I#I;w#BXABHA @XA@I      LBHA L@@SH Hu HHـu
(   KHH [HQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH      HBAVH0HD$ H\$HHt$PH|$XIHLH& HH(H% H;% r
(   HHt$@Ht*H?HOXKHH^H~ H HI6IH\$HHt$PH|$XH0A^@WH@HD$ H\$PHt$X)t$0(HHWf.z
uHH^H?% HH(H1% H;"% r
(   HH|$`Ht&H(XKHNH_w Hހ HH>HH\$PHt$X(t$0H@_HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH      HB@WH@HD$ H\$PHt$X)t$0(HHf.Q.
 z
uHH^H$ HH(H$ H;$ r
(   HH|$`Ht&H(YKH-H_w Hl HH>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0I(Hf.
-
 z
uI H^H^# HH(HP# H;A# r
(   HH|$XHt&H(YKHmH_w Hk HH>HH\$PHt$`(t$0H@_3LH9Qv/D  I@ HI@(HAY@XAAI;Pr@SH Hq HHـu
0   HH [@SH HHHSH
A H3H
HJHH H} HHH [HHHUVWHpH@HXHHHrH+2HHH3HHYW@Ht3; H{| HHwHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~D$(f)HH;}HL$8HHL$H HHoHH$   Hp_^]H	H% @USVWAVAWH$xH  HD$PHPU H3HEpMADHH   D$     H HD$`HM` D$    E3E3HT$hHL$`) HD$`HcHH0r HD`HD$`HcHDxDD\   HL$hg HHL$` HH  HH  Hȋ HHV  HH'  HȺ   Ć HH e HA HI~ HHs HUPHL$`U HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@H Hqv HD$(H HL$( @SH H   H HH [H% @SH HHHSH
 H3H
HJHHÆ Hu HHH [@SVWH  HD$8H-S H3H$  IHHDL$0HL$@蒣 H HL$P
 HH5 H$  HL$@ӡ H$  H$  HC$  HǄ$X     3H$P  $@  8uD
IIB8uH$@   HǄ$x     H$p  Ƅ$`   A"   H H$`   H$@  HD$ L$`  LD$0HH @UVWH  HD$0H$  HQ H3H$  AAHH$  A|A@;   HL$@E H HL$P Hȋ$   H$`  HL$@聠 H$`  H$x  HC$`  HǄ$X     E3L$P  D$@  D8tIIB< uH$@   Hl$ L$@  DËHH$  H3[ H$  HĐ  _^]@SVWH  HD$HHP H3H$p  AHHHL$P7 Hg HL$` HHC  HH HH	  HH HHף r Hȋ H$P  HL$P5 H$P  H$h  HC$P  H
 HL$ 3HL$(HL$0HD$8D$@HT$(HL$8X Hy HD$ H HL$  @SH HHHSH
Q H3H
HJHH HTy HHH [E3LWIrlHBLL+IPHHL    @ ALYHAY X(ALYHXADY@H XXHuM;s!I+KM+YHXIu(@UVWHl$H   HEH$   HN H3HE?HHHE7   3Hu/@uDFH HM HE   Hu@uDFH^ HM HE   Hu@uDFH= HM H|$ LMLHUHM HEHrPHHMH=   r<t HAH;rՂ H+Hsł H'v H臰 HE   HuE HEHrPHHMH=   r<t{ HAH;rk H+Hs[ H'vN H HE   HuE HE7HrPHHMH=   r<t HAH;r H+Hs H'v H賯 HLCL+IHMHM?H3! H$   HĠ   _^](Ś (
Κ D$T$f (fYfYfYfX fX
 fYfYfX fX
ƚ fYfYfXƚ fX
Κ fYfYfXΚ fX
֚ fYfYfX֚ fX
ޚ fYfYfXޚ fX(f^((p (
p D$T$f (fYfYfYfXp fX
p fYfYfXp fX
p fYfYfXp fX
p fYfYfXp fX
p fYfYfXp fX
p fYfYfXp fX(f^(H8W)t$ f/(vbW+
 
 
7#
 f/D$@   f.z$u" Y#
 X "   (t$ H8~ X(t$ H8~
 
"
 f/D$@wHf.z ub #
  "   (t$ H8(t$ H8H%j~ LD$@H6 9q LD$@H$ 'q HL$UVWAVAWHH   HEH$   )t$pLHcHqHu@3HH^Wut3} Hp HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~'fff     Ef)HH;}HMHM諷 IwHu@HH^H^uHtFHHHH;tLLMt3} IBo HH~H~HHMHFHEHUHUHUHUHU8HUHuLFLIHH+HHH~Ef)HH;}HMHHMض I/   IH$   (t$pHĀ   A_A^_^]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM HO HGLHHUL HEHUHULMHUHUIHUHLEH+HMHHH~(     (fA)HH;}MLEMHMH聵 H\$xH$   H`]HUAVAWHhH   HEHXHpHx LHX
 LqWMHHEIHEI~Ht3z Hl HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEEIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     fA(f^(fX)HH;}ELEHMMHME L}LuEEMM'HEHE7L~WEH]MvH}MuHtN$HtHHHL;tIHHt3x H?k HELuH}LE7HUHM LELEHEHEIHMIGHEHUHUHUHUHUgHUL}MOLIHH+HHH~,fff     (fAX)HH;}
LEHMMHHM0E HM>x HM3x L$   I[(Is0I{8IA_A^]LWH   H

 f/Y  HA\I[3IkHi MsLq(HJICIkD$hH;uL9rtqHt"MtHHIH;   HGH$   IHHH;tH]w Ht
Hi HHH$   HoLwHGHT$ HHD$(HT$0HT$PHT$8H$   HT$@HL$ LGLH|$HIHH+HHHH~6fff     HD$XD$hf(f^)HH;}HL$ HL$0 H$   H$   L$   HĐ   _HL$USVWAVHH   HE)t$pLHcHyH}@3HH_Wut3+v Hkh HHwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~ @ Ef)HH;}HMHM I~H}@HH_uHt3u Hg HHwHHMHEHEHEHEHE8HEH}LGIHH+HHH~Ef)HH;}HMHHMx I   I(t$pHĀ   A^_^[]H\$H|$UHH`HAHHE3HWL HMHM(HMMHMHMHMHHHLEHH+HHЋHH~%     fA)HH;}ELELHM跮 HOHGL@HUHEIHUHUHUHUHUHH+MHHHMH~" (f)HH;}MHMHHME H\$xH$   H`]HUAVAWHhH   HE7HXHpHx LHXg
 LqWMHHEIHEI~Ht3ps He HEH}H}LELEHEHEHEHEHEgHEHEHEHHH+HLM3ۋM~%HEHM(f\A)HI;}LELIHM LELEUIHMHEHEHEHEHEgHELuMNIHH+HHHHH~;ff     A((ff^fX)HH;}ULEHMMHMS> LFLMLMMLUML]'IHMHEHEHEHEHEgHELEM@IHH+HHH~5A(fA\fAYfX)HH;}L]'LULMHMHHM? HMq L$   I[(Is0I{8IA_A^]LWH   H
6
 f/   HA\I[3IsHq ICD$hH9rt"H
5q Ht
Hpc HHHwHHD$ H$   HD$0HD$PHD$8H$   HD$@HL$ LGIH|$HHH+HHHH~/@ HD$XD$hf(f^)HH;}HL$ HL$0 H$   HĀ   _@SH HHHSH
x H3H
HJHHo H$p HHH [AYAHAX@@@SH HV HHـu
    ;HH [@WH0HD$ H\$HHt$PHHHj HH H\ H;M r
    HH|$@Ht&HCi
 (HtH_HY^ HH>HH\$HHt$PH0_LE3HQWI+HHrDLBIIJIN    HAX@HAX@HX@HAH X@IuL;sKI+HHX@HuHL$WH0HD$ H\$HHHHZ(HHoa HHGH+HH    H* HHH H; rHHKHGH+HHC 3HtfHHKHHHH;S rHH\$HH0_E3L9A v'    HAJIBXABL;A r@WH0HD$ H\$@HHHBH+Hs
WDHH HH(H: H;+ r
(   HHL$HHt
H3HHH\$@H0_HUVWAVAWHl$H`  HE0HX)p)xHHHMW HMHM H_ HELELEHM HMLHUNL+t	H藽
 HM_ LHEHMHMHULL+t	Hi
 WD$PH}LHt3l H^ HHD$PH}HL$PLt$X3L;t-Zl HtH^ HHD$PHH\$PLH|$XW(t$@HMHEHD$`HD$@HD$hH   HD$pHD$PHD$xIHH+HHHHH~&f     f)HH;}D$@HMMHL$` =n

    HEH   L   LD$PHH   p H9V~EH
 
 @ HD$PAT^WHIHcH;F|WD$@H}Ht.3k HtHK] HHD$@HH\$@H|$H
H|$HHL$@uHMHEHD$`HEHD$hH   HD$pHD$@HD$xHHH+HHHHH~-@ ff     (f)HH;}uHMLHL$`贤 HD$PHEHE   HEHD$`HMHL$h|$0HD$@HD$ LMLD$`HU% HD$@HD$`H|$HHFH;t'H;tHi Ht
H+\ HHH~HHMHEHEHD$`HEH   HEHuLFIHH+HHHH~HD$`()HH;}HMHM9 HL$@ei HL$PYi IOi HMDi HM9i HM/i HM%i L$`  I[0A(sA({IA_A^_^]@SH HHI(h HKh HH [H%h H\$Ht$WH@HY)t$0H!f H\$PHHHJ()|$ H(Z HLGLCHLGIL+LtH%
 H\$XH~(|$ v Ht$`(t$0H@_He HHIH%#h @WHPHD$ H\$hHt$pH3 H3HD$HHHD$@   3Ht$8@t$(DFH1 HL$(; HCHL$(H;sVHHT$(H;wIH|$(H+H;CuVH& HH;HKHtdHA   HqHyrHHH<H;Cu
   H HKHt(HA   HqHyrHHHT$(  b HC HD$@HrQHHL$(H=   r<tg HAH;rg H+Hsg H'vg Hq HD$@   Ht$8D$( A
   H	 HL$( HCHL$(H;sXHHT$(H;wKH|$(H+H;Cu
   H HH;HKHtdHA   HqHyrHHH<H;Cu
   H譤 HKHt(HA   HqHyrHHHT$(  , HC HL$(s HL$HH3 H\$hHt$pHP_H\$WH Hc HHHIe t
(   HC HH\$0H _HW H@SH HsW HHt
    HH [@SH0HD$     HI   HH0[H\$Ht$WH HYHHSb H\$0HHHJW HLFLCHVLFIL+LtHd
 HFH\$8HGHF Ht$@HG HH _H	^ HH齔 H\$WH H] HHH莔 t
(   H HH\$0H _@SHPHD$ H/ H3HD$HHHD$@   HD$8    D$( A   HC HL$(1 HHHT$(PHD$@HrQHHL$(H=   r<tcd HAH;rSd H+HsCd H'v6d H HL$HH3舊 HP[HWH@H@HXHhHpIHHW@3HpVHHQ LD$0MtHCI LD$0ILD$0H HL$(I;   H;   H+HLL$8M;utII+HHsdL+IIII+HsH
" ` IPL+IIHL+IM;HCH;HCHL$( LD$0HL$(M   H   LL$8M;uoII+HHs_L+IIII+HsH
 t_ IPL+IIHL+IM;HCH;HCHL$( LD$0MtHI LD$0ILD$0HHT$(HPHHT$(HP0HMHHT$(PHT$(HtLD$8L+Ig H\$PHl$XHt$`H@_HUHXH  HD$ HX)p)xH, H3Hp  I((Hǅh     Hǅ`      ƅP   A   He HP  9 HHPH0  #} HP  H@   H(^ HH)  H0  H0  Q{ LHHAPHH  HrSHH0  H=   r<ta HAH;r a H+Hs` H'v` H貎 HM0i| HǅH     Hǅ@      ƅ0   A H`  H0  5 H0  HM@ H(] HHV  HH  HrSHH0  H=   r<tF` HAH;r6` H+Hs&` H'v` H H0  HM0z LHHAPHH  HrSHH0  H=   r<t_ HAH;r_ H+Hs_ H'v_ Hi HL$0{ HǅH     Hǅ@      ƅ0   A H`  H0   XH0  HL$@ H(\ HH J HH  HrSHH0  H=   r<t^ HAH;r^ H+Hs^ H'v^ H虌 H0  HL$0x LHHAPHH  HrSHH0  H=   r<tw^ HAH;rg^ H+HsW^ H'vJ^ H HHPHMfx HM<\ H   Ox H   "\ H  5x H  \ Hh  HrSHHP  H=   r<t] HAH;r] H+Hs] H'v] Hg Hp  H3 L$  I[A(sA({I]HUSWHHH  HD$ )p)xH<( H3Hp  ((HHǅh     3H`  @P  DGH| HP   HǅH     H@  @0  E3Hx H0  O HKHH0  P HH  HrSHH0  H=   r<tz\ HAH;rj\ H+HsZ\ H'vM\ H H0  w HP  H@  | H(xY HH{ 1 HKHH0  PHM0w HǅH     H@  ƅ0   A H`  H0  W H0  HM@ H(Y HHx{  HH  HrSHH0  H=   r<th[ HAH;rX[ H+HsH[ H'v;[ H
 HKHHU0PHL$0v HǅH     H@  ƅ0   A H`  H0  肢 XH0  HL$@, H((X HHz  HH  HrSHH0  H=   r<tZ HAH;r~Z H+HsnZ H'vaZ H0 HKHHT$0PHǅH     H@  ƅ0   E3Hv H0  貢 HKHH0  P HH  HrTHH0  H=   r<tY HAH;rY H+HsY H'vY H HMs HMW H   s H   W H  s H  wW Hh  HrSHHP  H=   r<t4Y HAH;r$Y H+HsY H'vY Hֆ Hp  H3W ($  ($  HĠ  _[]HL$UVWH0HD$ H\$XHHC HHqHt$`3H.HnHcڅt3W HI HH^HwHt$`H.HnHt3tW HI HH^Ho(Hw0Ht$`H.HnHt3DW HI HH^HH\$XH0_^]HL$VWATAVAWH0HD$ H\$pHl$xHHH'B HHrHyH|$hE3L'LgHt3V H I HHwLu HsHt$hL&LfMt3V IH HLvHE(HC(L}8Ls0Lt$hM&MfMt3XV IH IM~HUH HUH HU0I HH\$pHl$xH0A_A^A\_^H\$WH HHHHc HC(HSHOHG(N HS0HO0A H\$0HH _@UVWATAUAVAWHpHD$ H$   H! H3HD$hILHE3AH9Y~HA     IIFH+HH;vHHHnU HcH;U|H
 R EL9e#  IIf     HD$@   Ld$8D$( A   Hu HL$(V IIFH+HH;  HLHT$(HL$H HHWH;svHH;wnH+LOI;uYIH+HHsIH+HIH+HC  HL+IIHIH+IMI;LCL;ICH HHeLOI;u\IH+HHsLHH+HIH+H   HL+IIHIH+IMI;LCL;ICH HwHtoHF   LfH~rHH  H{sLCItHHR 	HHL#HCHFHCHFHC   H{LcrH HG HL$Hia HL$(^a AIcH;]}/H
ƅ P H
 P H
 TP AH9u   I HD$@   Ld$8D$( A   Hs HL$(6 IIFH+HH;vJHLHT$(HL$H HHV HL$H` HL$(` HcH;]zH
 O HL$hH3y H$   HpA_A^A]A\_^]H\$Hl$VWAWH 3HHH9y~+3@ ff     HFHH[ HcH;N|3Lt$@IH9n;  E3    H~HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;IC臷 HSHt
HHH
HBxLKI;u\IH+HHsLHIH+HH+H  L+HIE3IIHH+II;HLCL;IC	 HKHtHHHAHCHcIH;F3H9nS  E3H~0HSIH;   HH;   LKH+HI;uYIH+HHsIH+IHH+H  L+HIE3IIHH+II;HLCL;ICG HSHt
HHH
HB   H
t VM H
f HM LKI;u\IH+HHsLHIH+HH+H   L+HIE3IIHH+II;HLCL;IC誵 HKHtHHHAHCHcIH;FLt$@H\$HHl$PH A__^H
 L H
 L HL$VWATAVAWH0HD$ H\$hHl$xHcLH7K II~@H|$pE3L'LgLgIHtIHHH;tHHHt3ZN H@ HH_H_LHMI;~NL    
 IH~)ID  I;u(WHHHWH;|IML;G|IH\$hHl$xH0A_A^A\_^H\$UVWH`HrHy@HIH3HHjHD$ Ht$(H;uH9otnHt"HtHHHH;   HOL$   LLL;tHIM Mt
I? HHL$   HwHoLGHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LGH|$XIHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@i H$   H`_^]HUATAUAVAWHl$Hp  HD$(HXHpHx HD H3HE`LHE3ADt$ HEX   LuP@}@EF Hm HM@萕 IE HU@IPHEXHrPHHM@H=   r<tL HAH;rL H+HsL H'vL Hfz Aމ\$$H9^H  ML=[? HH H
K HL$@HT$PHMJ |$ E3HT$XHL$@nJ HD$@HcHHC HD@HD$@HcHhT<HD$XHD$0HL$XG L|$XLuDuHF@BHL$P5I A   EL9vP~S@ ff     H~@H^HIIHk HL$P HH AIIcH;FP|Ë\$$|$ HU@HL$@me ME HIAPHEXHrEHHM@H=   r0   HAH;   H+H   H'   Hx HD$@HcHH^B HD@HD$@HcHhT<L== L|$XHL$X` HL$XH HL$`
H HMH É\$$IHcH;FH}$E3J J zJ sJ HM`H3p L$p  I[0Is@I{HIA_A^A]A\]@SH HHI0EI HK;I HKH [H%+I @SH HH   G H   HLcBADuluHT$0lG H [VG H   HLcBADuLt2H [H\$WH HH   HT$0 L   I HcHBDuT$0@:tIF 2H\$8H _ðH\$8H _@SH HHT$0H   v L   I HcPBDt2H [L$0uI tT$0HK H|$8vU H   HT$0\F HHcQDu@fD  L$0-I u8L$0I u)T$0_t$.tH   E H|$8H [T$0HK T H   HT$0E HHcQDtH|$8H [@SH HHT$0H   f H   HHcPD
uT$0"tFiE H   HT$00 H   HHcPD
uT$0't23E HsHit"Hu2H [HGt'ܰH [H\$Hl$Ht$ WAVAWH 3EHL8ta     I   HT$H HHcJD   Etl$H@:,33kG l$H\G ;u$HÀ<3 uH\$@Hl$PHt$XH A_A^_I   @3D Hv_H~HHfff     I   D HHu2Hv&H~HHfI   C HHu2j@SH   HD$@H H3H$   HHL$0HA    HyrHH  H   HT$ pC HHcQDuAL$ /F uL$ 0F T$ tH?R H   H   C HqH H$   H3k HĠ   [@SH HyHHA    rHH  HT$0H   B HHcQDufL$0rE uL$0sE T$0t6HQ H   HT$0hB HHcQDtH*   H [H   /B H   H [H   HD$0H H3H$   HL$  H$   H3j HĘ   @SH   HD$0)$   H' H3H$   HHL$  (Wf.zu	Ha (H$   H3=j ($   HĠ   [H\$UVWAVAWHH0E3)t$ AH5;e DH@ H   HUH HHcJD   UH:7   HD847uAHd HEt
5 5 HC`HMHuHH;  HKXHUHH;  H}HH+HH;Chu   HKX) HS`HtHCXHH
HB  H   G@ HvSHHHH   (@ HvHu.Hv(HHHD  H   ? HvHuE3Hd Ht8 HKXHUHEHK   @2LsH{rHHD0HU@H   ? HHcQDugH
     M@eB U@uB<:w2Hs,@HeN H   HU@L? HHcQDt
H   ? @u<HC`H+CXHu,HEtHK@EHHUHE HK  HCHH+C@HH   HC@HMHfBn4HC`uHH;sFHKXHUHH;w9HuHH+HH;Chu   HKX4 HS`HtHCXHH
HB%H;Chu   HKX HC`Ht0HHC`IHCHH+C@HL;YHC@HHCHI(ENW5& BH;Chu   HKX HC`Ht0HHC`(t$ H\$`H0A_A^_^]H\$WH H H   HT$0= HLcBAD u!L$0d@ uT$0H   f= H   HT$8- L   I HcHBDuT$8-tDI,= H   HT$8@2 H   HHcPD
uT$8+t< @@HH\$@H _AVH0LHT$@H    I   HHcPD
uT$@(t< 2H0A^H\$HHT$@Ht$XH|$(? I   HHcPD
uT$@)   >< IL|$ YLcl  0  3Hl$Pt$@Aff     IFHHL$@H;   IN@HT$@H;   H|$@H+HI;FPu	IN@| IVHH   IF@
   IFxHL$@3Ht$@H;sOINpHT$@H;wAH|$@H+HI;   uVINp"} IVxHt:IFpHH
IFx   I;   u   INp| IFxHtH0IFxkI;FPu	IN@7| IFHHt0IFHHHl$PI   HT$@ I   HHcPD
uT$@)t#: 2L|$ Ht$XH\$HH|$(H0A^IFxHL$@L|$@H;sNINpHT$@H;w@H|$@H+HI;   u   INp| IVxHt7IFpHH
IFxI;   u   INp{ IFxHtL8IFxU@UH0HHT$@H    H   HHcPD
uT$@(t9 2H0]H\$HHT$@H|$XLt$( H   HHcPD
uT$@)   9 HL|$ Lc  C  WHt$PD$@E3AD  HE`HL$@H;   HMXHT$@H;   H|$@H+HH;Ehu   HMXz HU`HtHEXHH
HB   HExHL$@E3Lt$@H;sPHMpHT$@H;wBH|$@H+HH;   u
AVHMpYz HUxHt:HEpHH
HEx   H;   u   HMp"z HExHtL0HExtH;Ehu   HMXy HE`HtL0HHE`HHt$PH   HT$@ H   HHcPD
uT$@)t"7 2L|$ H|$XH\$HLt$(H0]HExHL$@L|$@H;sNHMpHT$@H;w@H|$@H+HH;   u   HMp@y HUxHt7HEpHH
HExH;   u   HMpy HExHtL8HExV@SH HHT$0H    H   HHcPD
uT$0(t6 2H [HT$0H|$@ H   HHcPD
uT$0)   6 Ht$8HH   HT$0s H   HHcHDuT$0,tH   o6 Hs`H+sXHCHH+C@HKxHHHHD$0Ht$0H;   HCpHT$0H;   Ht$0H+HH;   u   HKpw HSxH   HCpHH
   HCxHL$03H|$0H;sWHKpHT$0H;wIH|$0H+HH;   u   HKp]w HSxHt@HCpHH|$@H
HCxH [H;   u   HKp w HCxHtH8HCxH|$@H [H;   u   HKpv HCxHtH0HCx)HHt$8H|$@H [@USHH(HHUH    H   HHcPD
uU(t4 2H([]Ht$HHX AH|$PHH˄t
   AHT H˄tnucEH˄t)`:Hˋ&   Hfu;HUHK@; MM;~fHUHK@: EȉE;}HCpHUHCxH    H   HHcPD
uU,t3 Ht$H2H|$PH([]ò.H~tAHW Htɲ=HZtcLt$ HGH˄   (5t`HHUHEHKp8; ,Ht'HrHUHEHKp; ,Huٲ)H   2Lt$ Ht$HH|$PH([]$:HLtHLuHL;s/HUHKp: HMHHMH;v)Hh뒐HUHKps: HEHHEH;s)H9`@UH0HHT$@H    H   HHcPD
uT$@ct)	2 AH'V HḦ́tH0]HH0]AHQ Ḧ́t
H0]AHU Ḧ́t
H0]:HbuH0]HEHH+E@HH\$HHuHHEHH+E@HHt
2H\$HH0]HE@Ht$PH|$(Lt$ 8DpHEH|$@A;~   HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@r HUHHt%HE@
H;EPu	HM@q HEHHt8HEHǉ|$@A;~y   @ HEHHL$@H;s=HM@HT$@H;w/Ht$@H+HH;EPu	HM@q HUHHt%HE@
H;EPu	HM@fq HEHHt8HEHω|$@A;}HEHHMpH+E@HT$@HHD$@7 Lt$ H|$(Ht$PH\$HH0]H\$WH HQp3HHt"L   L+Ieo H{pH{xH   HSXHtLChL+I=o H{XH{`H{hHS@HtLCPL+Ih^ H{@H{HH{PHK ? HH\$0H _? @SH0H3HQ D$ IE3HHC   HCP{ HH0[@SH0HD$     HQpH8 HH0[@SH0HD$     HQ@H! HH0[@SH0HD$     HQXH8 HH0[@SH   HD$@H H3H$   HHL$0HAXHA`HA@HAHHApHAxHA H@    HxrH   n  HT$ H    L   I HcHBD   T$ <tI-    -H   Hi   HǄ$      HǄ$       D$pA   HQ HL$p~x HD$pH$   HCD$pH
z7 HL$P3HL$XHL$`H$   Ƅ$   HT$XH$   . H_$ HD$PA;  HeQ HL$P 2H$   H3U H   [HUATAUAVAWHl$H  HEHXHpHx H% H3HEpHLHMH HLiLl$03I} I}ʰ IE M|$L|$0I?I谰 II|$(I|$0I|$8I|$@I|$HI|$PI|$XI|$`I|$hHE   H}@}HE   H}@} WfE WfM0fE@fMPH}`H]hHMe  HE@H+E8HUHMH  HHT$hHMHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMLHIw HI;tYHP HzHzrHI~rIIH?IvLH;LBMt	I}
 uH;s3H;t.LuLEI& LH HD$ LHT$0I} H\$0HK@HT$8:) HEHrDHHMH=   r0r  HAH;^  H+HJ  H'9  HZ HE   3H}@}HL$PHtdHD$`H+HHH;.  H    H=   r0  HAH;  H+H  H'  HZ HL$8HteHD$HH+HH?H;  H    H=   r0  HAH;  H+H  H'  HY HT$hHtLD$xL+IAX WD$hH|$x   )HHT$hHMxHHL$8HHHL$@HHHL$HH8HxHxHHD$PHCHD$XHCHD$`H;H{H{HUHMHI$( HHT$8) HM]8 HT$PHtLD$`L+I1h HT$8HtLD$HL+Ih HT$hHtLD$xL+Ig WD$hH|$xHUHQLEL+Ig <* * ~* w* p* i* b* [* T* M* F* ?* 8* 1* HMIHMpH3P L$  I[8Is@I{HIA_A^A]A\]H\$WH HQ3HHtLA(L+If H{H{ H{(HHtLCL+I$V H;H{H{H\$0H _H\$WH HQ3HHtLA(L+If H{H{ H{(HHtLCL+Idf H;H{H{H\$0H _HWH0  HD$(HXHhHpHH3ۉ\$ HL$0jD HJ HL$@ Ht3HwHJ HL$@Ϊ H;sHH HL$@踪 HH;rHJ HL$@蟪 HH% HHJ 脪 HT$0HHD$0HcHH HD0HD$0HcHhT,H HD$HHL$H{ HL$H& HL$PR% H$   & HL$0  I[IkIs I_HWAVAWHP  HD$@HXHhHpHL3|$ WD$(H|$8HtHHHH;tHHHt3r& H LHD$(Lt$(H\$0H\$8HH~AL    M
 HIH;u(WHHH;|HMH;|HL$PvB HH HL$` Ht3HnAHL$`$ H;sHF HL$`Ĩ HH;rHH HL$`諨 HH# HHF 萨 HH# HHH u HT$PIHD$PHcHH HDPHD$PHcHhTLH HD$hHL$hy HL$h$ HL$pC# H$   # I$ IL$P  I[ Ik(Is0IA_A^_@SVWAVAWH  HǄ$   H H3H$  ILHH$   LL$83ۉ\$0HHYMt3k$ H HH~D$0   HǄ$      H$   Ƅ$    A   EHhG H$   m HǄ$      H$   Ƅ$    EGHCG H$   ^m HǄ$      H$   Ƅ$    EGHG H$   )m HHL$`dHD$ L$   L$   H$   I]HT$`HtLD$pL+Iya WD$`H\$pH$   HrTHH$   H=   r<t$ HAH;r# H+Hs# H'v# HQ HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t# HAH;ry# H+Hsi# H'v\# H+Q HǄ$      H$   Ƅ$    H$   HrTHH$   H=   r<t# HAH;r" H+Hs" H'v" HP HǄ$      H$   Ƅ$    A
   HE H$   7k IL$   HT$xIPH$   HrTHH$   H=   r<t[" HAH;rK" H+Hs;" H'v." HO HrmLLL$xIRMIM+IM+LGIIJ    D  K1HHBHDHBKHH
II	JHR IuH;sHL$xHHHHH;rHL$xHtwH$   H+HHH;vg! H    H=   r<tK! HAH;r;! H+Hs+! H'v! HN HH$  H3iG H  A_A^_^[LSVWAVH  IǃXH H3H$  IHHI`LL$8E3Dt$0L1LqLqD$0   IC   MsD$   EFHmC Iph HǄ$      L$   D$   EF
HB H$   h HǄ$      L$   D$   EFHC H$   h LHHL$H_HD$ L$   L$   H$   HXHT$HHtLD$XL+I\ WD$HLt$XH$   HrTHH$   H=   r<tj HAH;rZ H+HsJ H'v= HM HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<t HAH;r H+Hs H'v HL HǄ$      L$   Ƅ$    H$   HrTHH$   H=   r<tn HAH;r^ H+HsN H'vA HL HǄ$      L$   Ƅ$    A
   H@ H$   f HL$   HT$xHPH$   HrTHH$   H=   r<t HAH;r H+Hs H'v H`K HǄ$      L$   Ƅ$    DDHT$xHL$HO HHHHHHJHCHBHKHJHCHBHKHL$H= HT$xHtL$   L+I6Z HH$  H3RC H  A^_^[LWH   ICI[H H3H$   HHT$ IC   3I{@|$pDG
H> IKe HD$h   H|$`@|$PDGH? HL$Pd LHT$pHL$P< HD$hHrQHHL$PH=   r<t HAH;r
 H+Hs H'v HI HD$h   H|$`D$P H$   HrQHHL$pH=   r<t HAH;r H+Hs H'v~ HMI HǄ$      H$   D$p A
   H= HL$pc HD$h   H|$`D$P A   H> HL$Pc LHT$pHL$P HD$hHrQHHL$PH=   r<t HAH;r H+Hs H'v HH HD$h   H|$`D$P H$   HrRHHL$pH=   r<tn HAH;r^ H+HsN H'vA HH H$   H3@ H$   HĠ   _@SH   HD$HH H3H$   HHT$ HD$h   HD$`    D$P A
   H(< HL$PFb HǄ$      HǄ$       D$p A   H#= HL$pb LHT$PHL$pn H$   HrQHHL$pH=   r<t< HAH;r, H+Hs H'v HF HǄ$      HǄ$       D$p HD$hHrRHHL$PH=   r<t HAH;r H+Hs H'v HeF H$   H3> HĠ   [AA 3HAHAHAH\$WHP)t$@Hq(H)|$0yD)D$ D AXA((yXA@^A(]\A(\YYAX(qg
 K8W
i Ys ^C0\(g
 D\YDYCDX(DCwg
 H\$`(t$@(|$0D(D$ HP_@WH@HD$ H\$`Ht$hH8 H3HD$0HHHT$(HV HHHA   3HqHyrHH@0IE3` Hs(Hs0s8s@C<H$ HHL$0H3= H\$`Ht$hH@_̋Q4Q@Q,Q<A8    HUWAVHhH  HD$ HXHpH[ H3Hp  DHH  f  LAH9 HP   L9 HH0  襪 LHHAP HH  HrSHH0  H=   r<t HAH;r H+Hs H'v HfC HǅH     3H@  @0  Hh  HrSHHP  H=   r<tI HAH;r9 H+Hs) H'v HB HǅH     H@  ƅ0   A&   H8 H0  y] HH0  HP HH  HrSHH0  H=   r<t HAH;r H+Hs H'vx HGB HǅH     H@  ƅ0   E3H:0 H0  \ HH0  HP HH  Hy  HH0  H=   r<t  HAH;r H+Hs H'v HA !  C  3A;  HǅH     H@  @0  DG9H7 H0  \ HH0  HP HH  HrSHH0  H=   r<tB HAH;r2 H+Hs" H'v H@ HǅH     H@  ƅ0   A   H&7 H0  r[ L0  H7 HP  w LHHAP Hh  HrSHHP  H=   r<t HAH;rv H+Hsf H'vY H(@ Hǅh     H`  ƅP   HH  HrSHH0  H=   r<t
 HAH;r H+Hs H'v H? Dv(WI*(Yر H,ȉN,Y
 H,F0D+D+Dv4Hǅh     H`  ƅP   A9   H 6 HP  Z HHP  HP HP   Hǅh     H`  ƅP   A/   H5 HP  Y HHP  HP HP  F H0  , H5 H@   HȋV,B HH0  HPHM0Q, H5 HM@В HȋV4 HHU0HPHL$0, H5 HL$@蛒 HȋV0
 HHT$0HPHǅh     H`  ƅP   E3H$, HP  X HHP  HP HP  T HM:* HM H   #* H   
 H  	* H  
 Dv(DF,DN0N4~8N@AAF<Hp  H35 L$  I[(Is0IA^_]HHHWHPH@HXHH@   H@    @ A
   H4 HHW HT$(HH HHOHHH\$hHP_@SWH(HHI8;K,rDK(A+C0;sA;tHKHIܒK8C<;8  S(;-  +S0Hl$@Lt$PL|$ DBA;tC@ȉC@K<A;tA;ACȉK<HHKH~,CHE3L% fnHGLH(X^^Y%­ L9G~     MHt$HH4    3H~NMIL+MIM+MfI;u(W((AYHYX
HHGH;|ILL;G|Ht$HHKHqC8L|$ Lt$PHl$@H(_[ÍAC82H(_[H @SH A HO& HHH HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HXkHH [HL$VWAVHpHD$ H$   HcLH IIv@H$   3H>H~Ht3 H HH^Q D$(HHL$8HD$8HD$HHD$(HD$PH$   HD$XHt$`LHHH+HHH~%    f)HH;}
D$(HL$8HHL$HeE IH$   HpA^_^H\$Ht$WH`HHy@Hr3HD$ HGH;t'H;tH
 Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HUAVAWHhH`  HD$ HXHpHx H H3HEPLLHEH   HE@    E0 A)   H0 HM0*S IHU0IPHEHHrPHHM0H=   r<t_
 HAH;rO
 H+Hs?
 H'v2
 H8 HL$0% IF@HL$@k    I9vH~:~D  I^@H)* HL$@ H5 HHcI;FH|HU0HL$0# MHIAPHEHHrQHHM0H=   r<t	 HAH;ru	 H+Hse	 H'vX	 H'7 HD$0HcHH  HD0HD$0HcHhT,H HD$HHL$H\ HL$H HL$PR HM HMPH3L/ L$`  I[ Is0I{8IA_A^]HHHWHPH@HXHH@   H@    @ A   H' HH	Q HT$(HH HHOHHH\$hHP_H\$WH   HHI8;K,rDK(A+C0;sA;tHKHIFK8C<;s  S(;h  +S0H$   DBA;tC@ȉC@K<A;tA;ACȉK<HHKH?,CHLOLH|$H6 %n fnHD$ HD$0HD$PHD$8H$   HD$@IHH+HH3H(X^^Y˦ L$`H$   $   HL$pLD$ H~X((f(fY(fffYfXA)HH;}$$   $   HL$pL$`LD$ MHL$0<q HKHÐC8H$   H$   Hİ   _ÍAC82H$   Hİ   _@SH A H/! HHH HAH      ?HA0HA8H?HA@H      ?HAHH      $@HAP3HAHA HA(HX+HH [@UHHPHEH\$hH|$pH H3HEHHE   3H}@}DG<H'+ HMN HHUHP HEHrPHHMH=   r<tS HAH;rC H+Hs3 H'v& H2 HE   H}E A   H* HMM HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v Hf2 HE   H}E AC   Hi* HM M HHUHP HEHrPHHMH=   r<t5 HAH;r% H+Hs H'v H1 HE   H}E A/   H"* HMqL HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'vy HH1 HE   H}E A<   H( HMK HHUHP HEHrPHHMH=   r<t HAH;r H+Hs H'v H0 HE   H}E E3H HMVK HHUHP HEHrPHHMH=   r<t HAH;r{ H+Hsk H'v^ H-0 HE   H}E E3H) HMJ HHUHP HMb HMH3v( H\$hH|$pHP]@USVWATAVAWH$ H  HD$HH H3H   ىL$@DD$0DL$8LH  LP  HX  Hǅ      3H   @}pDGH( HMpJ HEh   H}`@}P' MA!H' HMPI    Hǅ      H   @   DGH-5 H   I Hǅ      H   @   DGH4 H   pI H   HD$ L   LD$@HUpHMP HEhHrPHHMPH=   r<t  HAH;r}  H+Hsm  H'v`  H/. HEh   H}`EP H   HrPHHMpH=   r<t   HAH;r  H+Hs   H'v
 H- Hǅ      H   ƅ    A   H|& H   PH Hǅ      H   ƅ    & MA!H% H   H H    H    HEh   H}`EP A   H& HMPG Hǅ      H   Ep % MA!H}% HMpG LD$0HUPHMp	 HMp/ HMP% HEh   H}`EP A   H% HMPOG Hǅ      H   Ep 	% MA!H$ HMpG LD$8HUPHMp HMp HMP |$0fn\N
 9N
 D,L$8  ;tCt
Ù   HL$P IHL$`Z H$ HL$` IcHMP
 HHL$` HȋD
 HH$  Hȋ*
 kd   HMPC
 HH$ HL$` HH$ Hȋ
 HHg$  Hc$ HL$`y IHL$`蜃 HHT$PHPHMd HM:
 H   H3{# H  A_A^A\_^[]@UVWAVAWHl$H   HEH$   H H3HE/IHLHE   E3L}D}EGH# HM.E HE   L}D}HD8?uE
LIB< uHHMD LHUHM5 HEHrPHHMH=   r<t(
 HAH;r
 H+Hs
 H'v
 H) HE   L}E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H`) HE'   L}E A   H" HMC HE   L}E A   H" HMC HE   L}E ? u
I     HÀ< uLHHMC LFIcN(L;tL$ LMHUHMŘ HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HZ( HE   L}E HEHrPHHMH=   r<tN
 HAH;r>
 H+Hs.
 H'v!
 H' HE   L}E HE'HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H' HM/H3
  H$   HĠ   A_A^_^]@USVWAVHl$H   HEHv H3HE/IHLHE   3H]]DCH  HMA HE   H]߈]8uDIIB< uHHMA LHUHM腘 HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 Hj& HE   H]E HEHrPHHMH=   r<t^
 HAH;rN
 H+Hs>
 H'v1
 H & HE   H]E A   Hs HM@ HE   H]E ? uLIIB< uHHMe@ LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hsw
 H'vj
 H9% HE   H]E HEHrPHHMH=   r<t-
 HAH;r
 H+Hs
 H'v 
 H$ HE'   H]E A   HR HMi? HE   H]E A   HK HMB? HE   H]E ? uLI IB< uHHM
? HFEF(D;tHD$ LMHUHM6 HUHrHA   HM(HE   H]E HM` HMV HE   H]E A   HY HM> HE'   H]E ? tHfD  HÀ< uLHHMH> LHUHM7 HM HM HM/H3 HĠ   A^_^[]HL$UVWAVAWHH   HEH$   )t$pHHHM@3HHYWuHt35
 Hu HH~HHMHEHEHEHEHE8HEHuLFIHH+HHHHH~Ef)HH;}HMHM. LvLu@II^I^uHtFHHHH;t
]LLMt3p
 I II~I~IHMIFHEHUHUHUHUHU8HULuMFLIHH+HHH~Ef)HH;}HMHHMG- ~(HH$   (t$pHĀ   A_A^_^]HL$WAVAWH0HD$ H\$`Ht$hLLHJ HIIGIFIIGLL+t9C
 II^H\$XH    HC    HC    HtFHHHH;t[HHHt3
 HX HH{H{LHSE3L9C~JL    
 3H~'I I;u(WHHHSH;|IML;C|IGAF(IH\$`Ht$hH0A_A^_HL$VWAVH0HD$ H\$`MHHHJ HHHFHGHHFLL+tA
 H_H\$XININh HHIFHCIFHCIIFIFLL+tA
 HFG(LHv HMHd HHH\$`H0A^_^H\$Ht$WH`HLHL HlHHs3HD$ HGH;t'H;tH_
 Ht
H HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~&f     HD$ ()HH;}HL$0HL$@g H\$xH$   H`_H\$Hl$VWAVH`HLHy HLwHH3HoHD$ HNLt$(I;uH9nt^Mt"HtHHHL;   HNHIH;tH&
 Ht
Ha HHLvHnLFHD$0HHD$@HD$ HD$HH$   HD$PHL$0LD$8LFHt$XIHH+HHHH~HD$ ()HH;}HL$0HL$@Xf L\$`I[(Ik0IA^_^WH\$UVWHHpHcy(3H)t$`WuH9yt"H	4
 Ht
Ho HHH~HHEHEHEHEHE HEHMLFIHuHH+HHHHH~ Ef)HH;}HMHM( Hc~(Hu(t$`HNH;uH9~tlHtHHHH;   HFL$   LLHL;tHK
 Mt
I HHL$   H~H~HFHUHHEHUHUHUHU HMLFLHUIHuHH+HHH~$     Ef)HH;}HMHHM' H$   Hp_^]#VHUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;tULLMt3
 I8 HEHuLH}HMHMHuHEHEHEHEHEgHEHEHELIHH+HLMHM~HE(fY)HI;}HMIHM( WEIHEIHt3L
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE(fY)HH;}HMLHMu' LEHUI4HM
 HM
 IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HE/HXHpLL3ۉ]'WEDH]HAHEHAHEHqHy HuHu*HuOHtHHHH;tuSLLMt3
 I HEHuLH}LELEHuHEHEHEHEHEgHEHEHELIHH+HHHHH~HEfQA)HH;}LEMHMW' WEIHEIHt3.
 Hn HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~fHEfQ)HH;}HMLHM& LEHUIHM
 HM
 IL$   I[8Is@IA_A^A\_]HUWATAVAWHhH   HEHXHp H+ H3HE'LHHE   3H]]DCHB HM1 HE   H]׈]DCH6 HM]1 HE   H]] MA-H HM-1 AD$(DF(D;tD$ LMHUHMu HEHrPHHMH=   r<tL
 HAH;r<
 H+Hs,
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<tx
 HAH;rh
 H+HsX
 H'vK
 H I$HEI|$HFH;t'H;tH>
 Ht
Hy HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~HE(A)HH;}LEMHM] H~ID$HEM|$L}Md$ HOI;uL9gt`Mt$MtHHIL;tNMMHOL;tHP
 Mt
I HHLLgHHMLGLEHEHEHEHEHEHEH}LGIHH+HHHH~ D  HE()HH;}HMHM\ HHM'H3 L$   I[@IsHIA_A^A\_]@UVWHl$H   HEH$   Ha H3HE7HHHE/   3H]']DCHx
 HM- HE   H]]DCHl
 HM- HE   H]]d
 MA.HT
 HMc- F(DG(D;tD$ LMHUHMr HEHrPHHMH=   r<t
 HAH;rt
 H+Hsd
 H'vW
 H& HE   H]E HEHrPHHMH=   r<t
 HAH;r

 H+Hs
 H'v
 H HE   H]E HE/HrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HR HHMLLEHEHEHEHEHEHE'H}/LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHM HOLFLEHFHEL	LMHAHEHUHUHUHUHUHU'HM/LQLIHH+HHH~+     A(fAXA)HH;}
LELMMHHMn HHM7H3 H$   Hİ   _^]@UVWHl$H   HEH$   H! H3HE?HHHE7   3H]/]DCH8
 HMw* HE   H]]DCH,
 HMS* HE   H]]T
 MA.HD
 HM#* F(DG(D;tD$ LMHUHMn HEHrPHHMH=   r<tD
 HAH;r4
 H+Hs$
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H| HE   H]E HE7HrPHHMH=   r<tp
 HAH;r`
 H+HsP
 H'vC
 H H}HHMLLEHEHEHEHE'HEHE/HEHE7LOIHH+HHHHH~% A(f^A)HH;}
HMLEMHM HOHMLFLEHFHEL	LMHAHEHEHEHEHE'HEHE/HEHE7LQLQIHH+HHH~2@ fff     A(fA^A)HH;}
LELMMHHM^ HHM?H3o H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM LCULEIHMI@HEHEMHMHHEHEHEHEHEHEHEIHH+HHH~/fD  B((ffXB)IL;}UHMMHMHX HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM莧 HCLCIHUHEHUHULEHUHUHMUM@LHUIHH+HHH~8@ fff     B((ffYB)IL;}UHMHHM HH\$xH`]H\$Ht$WHPeH%X   H3U    )t$@HЋ9s    HcF(3HfnY5ip ~nHFHl$`Hn)|$0= H4   D)D$ EWf     HH(TfA.zt	+
 XHH;|D(D$ (|$0Hl$`H\$h((t$@Ht$pHP_H
s  =s DV H
r X/| Y{ o 6 @USVWAVHl$H   HEH H3HE/IHLHU3ۉ]HE   H]]DCHk HMb# HE   H]]DCH HM># HE   H]]o MA-H_ HM# LFIcN(L;tL$ LMHUHM;x HEHrPHHMH=   r<t.
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 Hf HE   H]E HEHrPHHMH=   r<tZ
 HAH;rJ
 H+Hs:
 H'v-
 H HE   H]E A   H HM! HE   H]E  MA-H HMe! LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hsw
 H'vj
 H9 HE   H]E HEHrPHHMH=   r<t-
 HAH;r
 H+Hs
 H'v 
 H IFHEHuEELuHH_IvHt3
 H' HHwHUHM IHEIvHGH;t'H;tH
 Ht
H HHHwLLEHEHEHEHEHEHEH}LOIHH+HHHH~3fff     HEHHE(fXA)HH;}LEMHM\ HM	
 HHM/H3A H   A^_^[]@SH HHI
 HH [H%
 HT$WH0HD$(H\$@HHD$     IHHH$   HKq
 Hh
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJt HHHGHFHHGLL+t%
 H^H\$HHOHO 9 HHHGHCHG HCHWHGHG LL+t%
 G(F(HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHHHHKQ
 HH
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHGHO
 H
 HH\$@H0_HL$USVWAVHH   HE)t$pLHHM@3HHYWuHt3.
 In HLwHHMHEHEHEHEHE8HEH}LGIHH+HHHHH~#    Ef)HH;}HMHM
 HwHu@HH^uMt3
 I HLvHHMHEHEHEHEHE8HEHuLFIHH+HHH~Ef)HH;}HMHHMx Dw H(t$pHĀ   A^_^[]HL$SUVWAVHpHD$ LHHJ HHIFHFIIFLL+tr"
 InH~H$   3HH_WD$(Ht3~
 H HHoHHL$8HD$8HD$HHD$(HD$PH$   HD$XH|$`LGIHH+HHH~ fD$(f)HH;}HL$8HHL$HU IFF HHpA^_^][@USVWAVHl$H   HEH H3HE/IHHHMHJ HHHGHFHHGLL+t:!
 LvLuHK HIHCIFHHCLL+t!
 HGF HE   3H]]DCHE HM HE   H]߈]DCHq HMh HE'   H]] MA#H HM8 HFDF D;tHD$ LMHUHMdt HE'HrPHHMH=   r<tW
 HAH;rG
 H+Hs7
 H'v*
 H HE'   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;rs
 H+Hsc
 H'vV
 H% HE   H]E A   HH HM HE   H]E / MA#H HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 Hb HE   H]E HEHrPHHMH=   r<tV
 HAH;rF
 H+Hs6
 H'v)
 H HE   H]E A   Hk HM HE   H]E  MA#H HMa MHUHM HM  HM  HHM/H3 Hİ   A^_^[]@UVWHl$H   HEH$   Ha H3HE7HHHE   3H]]DCHP HM HE/   H]']DCHL HM HE   H]]\ MA+HL HMc LGHcN L;tL$ LMHUHMj HEHrPHHMH=   r<t
 HAH;rs
 H+Hsc
 H'vV
 H% HE   H]E HE/HrPHHMH=   r<t
 HAH;r	
 H+Hs
 H'v
 H HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HQ HE   H]E A   Hl HM HE   H]E  MA+H HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;rr
 H+Hsb
 H'vU
 H$ HHEHHFH;t'H;tHJ
 Ht
H腻 HHH~HHMHEHEHEHEHEHEHuLFIHH+HHHH~'@      HE()HH;}HMHM@ HM7H3  H$   Hİ   _^]@UVWHl$H   HEH$   Ha H3HE7HHHE   3H]]DCHP HM HE/   H]']DCHL HM HE   H]] MA.H| HMc LFHcO L;tL$ LMHUHMf HEHrPHHMH=   r<t
 HAH;rs
 H+Hsc
 H'vV
 H% HE   H]E HE/HrPHHMH=   r<t
 HAH;r	
 H+Hs
 H'v
 H HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 HQ HE   H]E A   Hl HM HE   H]E  MA.H HM LHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'v
 H HE   H]E HEHrPHHMH=   r<t
 HAH;rr
 H+Hsb
 H'vU
 H$ HHHEHvHGH;t'H;tHF
 Ht
H職 HHHwHHMHEHEHEHEHEHEH}LGIHH+HHHH~#     HE()HH;}HMHM< HM7H3  H$   Hİ   _^]H\$Ht$H|$ UHHpHcq 3H)t$`WuH9qt"H	\
 Ht
H藶 HHHwHHEHEHEHEHEHEHMLGIH}HH+HHHHH~'fff     Ef)HH;}HMHM+ Hcw HuH9wt"H
 Ht
H HHHwHHEHEHEHEHEHEHMLGIH}HH+HHH~(@      Ef)HH;}HMHHM (t$`L\$pI[Is I{(I]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~*fff     HE'(fY)HI;}HMLIHM WEHHE'H~Ht3	
 HI HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~,@ f     HE'(fY)HH;}HMLHM% LEHUIHMa
 HMV
 IL$   I[(Is0IA^_]HUWAVHhH   HE7HXHpLH3ۉ]WEHAHE'HyHt3
 H* HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HLMHM~'fff     HE'fQ)HI;}HMLIHMe WEHHE'H~Ht3<
 H| HEH}H}HMHMHEHEHEHEHEgHEHEHEHHH+HHHH~HE'fQ)HH;}HMLHM LEHUIHM
 HM
 IL$   I[(Is0IA^_]HUWAVHhH   HEHXHp H? H3HE7LHHE   3H]]DCHV HM HE   H]]DCHJ HMq HE/   H]'] MA.H HMA AF DF D;tD$ LMHUHML HE/HrPHHMH=   r<ta
 HAH;rQ
 H+HsA
 H'v4
 H HE/   H]'E HEHrPHHMH=   r<t
 HAH;r
 H+Hs׾
 H'vʾ
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r}
 H+Hsm
 H'v`
 H/ IHEI~HFH;t'H;tHU
 Ht
H萯 HHH~LLEHEHEHEHEHEHEHuLNIHH+HHHHH~ @ HE(A)HH;}LEMHM4 H~IFHEMvHGI;t'L;tH
 Mt
I HHLwHHMHEHEHEHEHEHEH}LGIHH+HHHH~&fff     HE()HH;}HMHM3 HHM7H3] L$   I[0Is8IA^_]@UVWHl$H   HEH$   H H3HE7HHHE   3H]]DCH HM HE   H]]DCH HM HE/   H]']L MA/H< HM F DG D;tD$ LMHUHMaI HE/HrPHHMH=   r<t
 HAH;rԻ
 H+HsĻ
 H'v
 H HE/   H]'E HEHrPHHMH=   r<tz
 HAH;rj
 H+HsZ
 H'vM
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r 
 H+Hs
 H'v
 H HHMLLEHEHEHEHEHEHEH}LOIHH+HHHHH~-fff     (fAXA)HH;}
HMLEMHMb LGHNHMMLMHEHEHEHEHEHELEM@IHH+HHH~.@      (fAXA)HH;}
HMLMHHM HHM7H33 H$   Hİ   _^]@UVWHl$H   HEH$   H H3HE?HHHE   3H]]DCH HM HE   H]]DCH HM HE7   H]/]\ MA/HL HM F DG D;tD$ LMHUHMAF HE7HrPHHMH=   r<tĸ
 HAH;r
 H+Hs
 H'v
 Hf HE7   H]/E HEHrPHHMH=   r<tZ
 HAH;rJ
 H+Hs:
 H'v-
 H HE   H]E HEHrPHHMH=   r<t
 HAH;r
 H+Hsз
 H'v÷
 H H}HHMLLEHEHEHEHEHEHEHEHELOIHH+HHHHH~% A(f^A)HH;}
HMLEMHM肆 HGHEHNHML LEHUHUHUHUHUHUHUHULHIHH+HHH~&@ A(f^A)HH;}
HMLEMHHM HHM?H3 H$   Hİ   _^]H\$UHH`HEMHEE3HEHMLHHE(HELEHI(HEHEHEHHH+HHAHH~0ff     A(ffXA)HH;}ELELHM莄 LCUHELEIHEHEHEHEHEHEHEHMM@IHH+HHH~, B((ffXB)IL;}UHMHHM HH$   H`]H\$UHH`LHEHEE3HEMHEHHELEHE(HM(HIHHH+HHAHH~(fA(ffYA)HH;}ELELHM> HKLCHEUHEHEHEHEHEHMLEM@IHH+HHH~3ff     B((ffYB)IL;}UHMHHM~ HH\$xH`]@SH@Hy HQHuWHHL$ HD$ HT$0  (fnC 
X/ X
T YT YXH@[HUVWAVAWHhH0  HD$PHX )pH~ H3HEMHHHT$@3|$4HE   H}@}DGH HM  HE   H}@}DGH HM  HE   H} @}g MA.HW HM~  IGDF D;tHD$ LMHUHMV HEHrPHHMH=   r<t
 HAH;r
 H+Hs}
 H'vp
 H? HE   H} E HEHrPHHMH=   r<t3
 HAH;r#
 H+Hs
 H'v
 H HE   H}E HEHrPHHMH=   r<tɱ
 HAH;r
 H+Hs
 H'v
 Hk HE   H}E A   H HM  HE   H}E  MA.H HM  MHUHM HEHrPHHMH=   r<t
 HAH;r
 H+Hs
 H'vٰ
 H HE   H}E HEHrPHHMH=   r<t
 HAH;r
 H+Hs|
 H'vo
 H> H;H{LvMt3n
 I计 HLsIHD$pHFHEHHEHvL;t'I;tH1
 Ht
Hl HH;HsHHEHEHEHD$`HEHD$0HEH]LsIHH+HHHH~BHE(4HE()D$@HL$@QHD$p(fYfXHM)4HH;|MHHMp HHMH3 H$x  ($   H0  A_A^_^]HT$WH0HD$(H\$@HHD$     IH/HH$   HK
 H
 HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJ HHHFHGHHFLL+tm	 H_H\$HHNޟ HHHFHCHVHFLL+t6	 F G HH\$PHt$XH0_HT$WH0HD$(H\$@HHD$     IHOHH$HK
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     I"HHHO
 H
 HH\$@H0_LD$WH0HD$(H\$@IHD$     IHHgHOT
 HK
 HH\$@H0_HW  @SH0HD$     HQH胴  HH0[H\$WH HHQHtLAL+I  3HCHCHCH H@t
    He HH\$0H _@SH HQHHt.LAL+I~  3HCHCHCH! HH [H HH [HXLHBLII+HL;u7HAH9Ar$3MtHQ AXHH;ArHAHXHo
 D$(HD$0HT$83HL$ HD$8HD$@H0 HD$ 
 H~ H< HD$0HL$0 H\$WH HHQ HtLA0L+Ix  3HC HC(HC0H H@t
8   H HH\$0H _@SH HQ HHt.LA0L+I  3HC HC(HC0H HH [H HH [@SH HHHSH
A
 H3H
HJHH
 Hl HHH [HAHH`HAHH`H\$WH H HHAHm  H HGHt
8   H HH\$0H _@SH HC HHAH  H HCHH [@SUVWATAUAVAWHxHD$(Ht H3HD$`IMHHHL$0HT$PLD$XLL$8L$   Ld$@L$   Lt$HH HHHL$ H HHBHAHHA   HA    HyrHH  IE3H  HK8I  HKpHx  H   Ih  H  HL$ H̰
 HIFHAIFHAIFHAH IV   H HHN踵  L-Y L.HǛ IGIO蚵  MoM/H  I  IV HtMF0L+IX  3IF IF(IF0M.HHL$`H3g HxA_A^A]A\_^][H\$WH HAHHHP HC8HK8HP HCpHKpHP H   HHP H  HHH\$0H _H` H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`H\$WH HAHHHPHC8HK8HPHCpHKpHPH   HHPH  HHH\$0H _H`@SH HAHHPHC8HK8PHCpHKpPH   HPH  HH [H`H\$WH HQp3HHt"L   L+IU  H{pH{xH   HK8]  HS HtLC0L+I$  H{ H{(H{0Hɔ HH\$0H _H\$WH H,   t
  H HH\$0H _H\$Ht$WH H  HHt*L  L+I  3H  H  H  H5) H   H  HKpH=~ HKPH{@Q  Hs@HKHs8H{<  HsH3H\$0Ht$8H _HL$SH0HD$ HH HLALD$HH I HBI@HIHHA   HA    HyrHH  IE3/  HH0[HL$WH0HD$ H\$PHHH[ HHBHAHBHAHBHAH H 裫  HO8HL$HHz HHC@HAHCHHAHCPHAHSXH *  HSpHOp\  HH\$PH0_@SH HHI HtCHS(Ua LC0H*L+C IHLI?LHS Y  3HC HC(HC0H< HH [H\$WH Ht
   H HH\$0H _H\$WH H<t
8   H HH\$0H _H\$Ht$WH HHHHM
 $ HHV $ HH
 $ HHW( HH* ڟ
 HG
 Hs$ HH d$ HH
 U$ WPH
 HH* 
 H%
 H)$ HH $ HH
 $ HH
 HHF* H
 H
 H# HH # HH̳
 # WH
 HH) 
 O|tttt3   H
 Hw# HHI h# HH
 Y# Hȋ
 HH) 
 O|  [  	  HŹ
 H# HH # HH
 "    H4
 HH*) ,
 Hy
 H" HH " HH@
 "    H
 HH( 
 Hu
 Hy" HHw j" HH<
 ["    H
 HH( 
 HY
 H-" HH; " HH(
 "    HP
 HHF( H
 H
 H! HH ! HH
 !    H
 HH' 
 H
 H! HH ! HH>
 u!    H
 HH' 
    tB  H
 H1! HHo "! HH
 ! Hd   H
 H  HH6   HH
   H W  L   HD H
 H  HH.   HHs
      H
 HH& ʛ
           H
 HB  HH 3  HH=
 $  HH
   HH[& ]
 L   HD L   H7E L   HH aD L   HrE L   HH |C L   HE L   HH B #  HG
 Hs HH d HH
 U HH F HH% 
 L   HD L   HhD L   HH C L   HD L   HH
 B L   HD j  H
 H HH  HH
  H-   H
 H HH r HH|
 c    H
 HH$ 
 H
 H5 HH & HH`
     H?
 HHM$ O
 H\
 H HHZ  HH
     H
 HH$ 
 L   HA Hi
 H HH ~ HH(
 o   H
 HH# 
 H
 H? HH 0 HH"
 !   HH
 HHV# X
 H]
 H HH  HH
     H
 HH	# 
 H
 H HHZ  HHO
     H
 HH" 
 HB
 HV HH G HH
 8    H_
 HHm" o
 H
 H HH  HH
     H
 HH" !
 H
 H HH  HHU
     HÖ
 HH! Ӗ
          tB  H

 HF HH\ 7 HH
 ( H   Hٻ
 H
 HH#  HH
  HP l  H
 H HH  HH?
  HH  HH  
 L   HH ?   H
 Hm HHc ^ HH
 O   H
 HH  
    tzt?   H|
 H HH  HHC
  H# jH
 H HH  HH
  H 4H
 H HH  HH߷
 ~ H Ho H H
 y tIHf
 HJ HHH ; HH%
 , HHWXP HHf h
     tLHT
 H HH  HH
  HH    HH 
 H@
 H HH  HH
  WxH
 HH ɓ
 H
 Hb HH H\$0Ht$8H _H%
 H%
 @WHPHD$ H\$hH` H3HD$HHHD$@   3H|$8@|$(E3H HL$(Q  HT$(Hc  HD$@HrQHHL$(H=   r<t
 HAH;rt
 H+Hsd
 H'vW
 H& H   H   H  HHL$HH3葻 H\$hHP_@UVWATAUAVAWHl$H   HEH$   H_ H3HEA؉]HLHUE    A}NHn
 HE3HEHEH HEEHUHM
 H HEH! HM H    HB    HB    E   HE   HE    E A   H HM  AEDEHE    I   I+   H988HHHH?H  E3M   MA;
  I^H{rHHH{A   I;LBMtHU ~	 u
HJ  H{rHHA   I;LBMtH" C	 u
H  H{rHHA   I;LBMtH 	 uDHu>LFIH+HgfffffffHHHH?H  IH4  HF   H{H{rHH?A   I;LBMtH H	    Hs	3Hu{A^HE   HE    EIE3HUHM+  ]HUH}  HM蒟  3IV(HEH;tIE3HM  I   ElEDEDELMILMIHI   I+   H988HHHH?HL;ʋ]   E+DHE   HE    E IE3HUHMb  DmHUHR|  HMȞ  HEHrPHHMH=   r<t[
 HAH;rK
 H+Hs;
 H'v.
 H HNHɘ
 HE3HEHEHԾ HEEHUHMf
 H HEH HM HMH3. H$   Hİ   A_A^A]A\_^]  @SH HH(Ν  HKH [  @UVWATAUAVAWH$@H  HD$8H$  HU[ H3H   MH=
 HL$@轫  HHPHH	 HL$P/ HH$ }H HL$P z  DHT$ IHL$(LD$ I+IgfffffffIHHHH?HHIH<Hҽ HL$P HHS HH  HHD$ Tӌ
 HL$(Lt$ I+IHHLI?LAxoIcH<HL@ ff     K4HU HL$P+ HHP HH  HBT7 S
 Md$HAxLt$ H HL$P HH" $
 HL$ Ht2HT$('K HL$0H+L$ IHHLI?LHT$   HU`HL$@a  H6 tSHEX   HEP    E@ A	   H HM@  LE@HU`H   Uv  H H   ( H6 tSHEX   HEP    E@ A   H< HM@[  LE@HU`H   Vt  H H    H6 tSHEX   HEP    E@ A
   H HM@  LE@HU`H   Wr  HX H   j H6 tSHEX   HEP    E@ A
   H HM@  LE@HU`H   Xp  H H    Hl6 tXHE`H}xHCE`H
k
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H HM@ HH6 tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H HM@C H$6 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ D
 Hw HE@H HM@ H 6 tXHE`H}xHCE`H
?
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H	y HE@Hv HM@{ H5 tXHE`H}xHCE`H
ے
 HM@3HMHHMPHD$ D$(HUHHL$ |
 H%} HE@HJ HM@ H5 tXHE`H}xHCE`H
w
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H& HM@ H5 tXHE`H}xHCE`H

 HM@3HMHHMPHD$ D$(HUHHL$ 
 Hs HE@H HM@O Hp5 tXHE`H}xHCE`H
 HM@3HMHHMPHD$ D$(HUHHL$ P
 Hy~ HE@Hn HM@ HL5 tXHE`H}xHCE`H
K
 HM@3HMHHMPHD$ D$(HUHHL$ 
 H HE@H HM@ HEX   HEP    E@ A   H׷ HM@  LE@HU`H   j  H H   4 HL$WH0HD$ H\$HHHH
 HHQ3HHBHK1
 H{ HHSHOHA   HA    HyrHH  IE3@  HH\$HH0_HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 Hq
 HHSHOHA   HA    HyrHH  IE3  HH\$HH0_HL$WH0HD$ H\$HHHHc
 HHQ3HHBHK
 H HHSHOHA   HA    HyrHH  IE3   HH\$HH0_@SH HHHSH
 H3H
HJHH
 H| HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHKA
 H9~ HHSHOHA   HA    HyrHH  IE3P  HH\$HH0_@SH HHHSH

 H3H
HJHHÄ
 Hܠ HHH [@SH HHHSH
э
 H3H
HJHH
 H HHH [@SH HHHSH
 H3H
HJHHC
 Hlo HHH [@SH HHHSH
Q
 H3H
HJHH
 H,z HHH [HL$WH0HD$ H\$HHHH
 HHQ3HHBHK
 HAn HHSHOHA   HA    HyrHH  IE3  HH\$HH0_H\$WH H?w HHH  Ho
 HOH
 t
8   H耲 HH\$0H _H\$WH Hǌ
 HHH讑  H
 HOH:
 t
8   H  HH\$0H _H\$WH Hg| HHHN  H
 HOHڂ
 t
8   H HH\$0H _H\$WH H/{ HHH  HO
 HOHz
 t
8   H` HH\$0H _H\$WH Hgl HHH莐  H
 HOH
 t
8   H  HH\$0H _@SH0HD$ HHW~ HH
 HA(H0
 HP HHKHtHP tHC    H0[@WH0HD$ H\$@HH} HH.
 HA(H0X
 H HHKHtHP tHC    @t
@   H HH\$@H0_@SH0HD$ HH_k HH
 HA(H0߀
 Hp HHKHtHP tHC    H0[@WH0HD$ H\$@HHj HHN
 HA(H0x
 H	 HHKHtHP tHC    @t
@   H8 HH\$@H0_H\$WH HH~ HHHJHKHtHPHGHCHGHCG C HH\$0H _@SH HH   HtWH   < L   H988L  M+IHLI?LI  3H   H   H  H   訚  H   H [H%u~
 HL$SH0HD$ HHx HE3LAH蠿H{ HLC0LC8LC@LCHLCPLCXLChLCpLCxL   L   L   L   L   L   L   L   H   HH0[LWATAUAVAWH@  IǃI[Is A)sHJ H3H$   HHT$HHWD$hE3Lt$xD$PLt$`    IǃP   MHD$  EFH	 I8  HǄ$     L$  D$  EFHI H$  l  HǄ$     L$  D$  EFHܭ H$  7  HL$0HD$ L$  L$  H$  H薷HT$0HtLD$@L+I芻  WD$0Lt$@H$  HrTHH$  H=   r<t~
 HAH;r~
 H+Hs}
 H'v}
 H身 HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t}
 HAH;r}
 H+Hsz}
 H'vm}
 H< HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t}
 HAH;r}
 H+Hs|
 H'v|
 H辪 Dv(HǄ$     L$  Ƅ$   A   H! H$  D  HL$  HT$0HP(HHD$hH;t'HH\$hHJHL$pHBHD$xL2LrLrH\$hHT$0HtLD$@L+Iɨ  WD$0Lt$@H$  n  F(    HǄ$     3H$  $  DCH H$  z  HǄ$     H$  $  DCH H$  F  HǄ$     H$  $  DCH H$    HL$0HD$ L$  L$  H$  HqHT$0HtLD$@L+Ie  WD$0H\$@H$  Z  H$  L  H$  >  ^,HǄ$     H$  Ƅ$   A   H H$  U  HL$  HT$0HP(HHL$h  HT$0HtLD$@L+I  WD$0H\$@H$  談  HD$hN,    HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H7 H$  z  DF(EyH$  H$  H$    H$    HǄ$     H$  Ƅ$   A   H& H$  	  HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H@ H$    HcV(HL$0茸HD$ L$  L$  H$  HHT$0HtLD$@L+I  WD$0H\$@H$  ߅  H$  х  H$  Å  HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   Hc H$    DF(EyH$  H$  H$  )  H$    W$  HcV(WD$0H\$@L$  HL$0K  HT$0HN0  HT$0HtLD$@L+I貴  HǄ$     H$  Ƅ$   A   H H$  ܿ  HL$  HT$0HPHHL$P舁  HT$0HtLD$@L+I=  WD$0H\$@H$  2  LLcV(LL|$PA   IrnHF0HHPML+AH+MZIIN$    Mff     IDHBIHIDHBHIDHHR IuH|$H3M;sHV0KHJIHIM;r    HǄ$     H$  Ƅ$   A   Hv H$  虾  HǄ$     H$  Ƅ$   A   H3 H$  b  DF(EyH$  H$  H$    H$  ׂ  HǄ$     H$  Ƅ$   A   H H$    HǄ$     H$  Ƅ$   A   H H$  躽  HǄ$     H$  Ƅ$   A   H( H$  能  HcV(HL$0tHD$ L$  L$  H$  HޭHT$0HtLD$@L+Iұ  WD$0H\$@H$  ǁ  H$  蹁  H$  諁  H$  H$  E33H$  I  A   H H$  迼  H$  H$  E33H$    A   HS H$  肼  DF(EyH$  H$  H$    H$    $  HcV(WD$0H\$@L$  HL$0*  HT$0HNH}  HT$0HtLD$@L+I葰  H$  H$  E33H$  ?  A   H H$  赻  HL$  HT$0HPHHL$Pa}  HT$0HtLD$@L+I  WD$0H\$@H$    LLcV(LL|$PIrmHFHHHPML+IH+MZIIN$    Mf     IDHBIHIDHBHIDHHR IuH|$H3M;sLNHKHKIHIM;r    H$  H$  E33H$    A   H܍ H$  s  H$  H$  E33H$    A   H H$  6  H$  H$  E33H$  胳  A   H H$    HL$0ΰHD$ L$  L$  H$  HXHT$0HtLD$@L+IL  WD$0H\$@H$  A~  H$  3~  H$  %~  ^`H$  H$  E33H$    A   H H$  6  HL$  HT$0HP(HHL$hu  HT$0HtLD$@L+I  WD$0H\$@H$  }  HD$hN`    H$  H$  E33H$    A   Hi H$  茸  H$  H$  E33H$  ٱ  A   H4 H$  O  DF(EyH$  H$  H$  |  H$  |  H$  H$  E33H$  b  A   H H$  ط  H$  H$  E33H$  %  A   H H$  蛷  DF`EyH$  H$  H$  |  H$  |  H$  H$  E33H$  记  A   HA H$  $  H$  H$  E33H$  q  A   H̍ H$    H$  H$  E33H$  4  A   HO H$  誶  LcF`HcV(HL$0׭HD$ L$  L$  H$  HHT$0HtLD$@L+I  WD$0H\$@H$  z  H$  z  H$  z  H$  H$  E33H$  l  A   H H$    H$  H$  E33H$  /  A   H H$  襵  DF(EyH$  H$  H$  (z  H$  z  H$  H$  E33H$  踮  A   H H$  .  H$  H$  E33H$  {  A   H֋ H$    DF`EyH$  H$  bH$  ty  H$  fy  $  HcV`WD$0H\$@L$  HL$0虬  HcV(W$  H$  LD$0H$  n  H$  HNhmc  H$   c  HT$0HtLD$@L+IĨ  H$  H$  E33H$  r  A   H͊ H$    HL$  HT$0HPHHL$Pu  HT$0HtLD$@L+II  WD$0H\$@H$  >x  LHc^`H$  E3H   L|$PLcF(3IrzHFhLHP0M_OA   L+IXHHH<    LHJICJHJICJH
IJIJ!ICJM[ HR`HuH$  I;s(L^hHHL+JKJIHRIuIL;AH|$H    3H$  H$  E33H$    DCH% H$  d  H$  H$  E33H$  豫  DCH H$  )  DF`EyH$  H$  H$  v  H$  v  H$  H$  E33H$  <  A   Hφ H$  貱  H$  H$  E33H$    A   H: H$  u  H$  H$  E33H$  ª  A   Hݗ H$  8  HcV`HL$0)HD$ L$  L$  H$  H蓡HT$0HtLD$@L+I臥  WD$0H\$@H$  |u  H$  nu  H$  `u  H$  H$  E33H$    A   H5 H$  t  H$  H$  E33H$    A   H H$  7  DF`EyH$  H$  H$  t  H$  t  $  HcV`WD$0H\$@L$  HL$0ߧ  HT$0H   q  HT$0HtLD$@L+IC  H$  H$  E33H$    A   H, H$  g  HL$  HT$0HPHHL$Pq  HT$0HtLD$@L+Iȣ  WD$0H\$@H$  s  LLcV`HLt$PIroH   HL@ML+Ȼ   H+MZIIN$    IfD  KDI@KI KDI@JKDH9M@ IuH|$H3I;sL   KHIHHII;rX 	   H$  H$  E33H$  誧  A   H H$     H$  H$  E33H$  m  A   H H$    DF(EyH$  H$  TH$  fr  H$  Xr  H$  H$  E33H$    A   H% H$  l  H$  H$  E33H$  蹦  A   H  H$  /  Lv,EEyH$  H$  H$  q  H$  q  H$  H$  E33H$  ?  A   Hҁ H$  赬  H$  H$  E33H$    A   HI H$  x  H$  H$  E33H$  ť  A   H H$  ;  McHcV(HL$0iHD$ L$  L$  H$  H蓜HT$0HtLD$@L+I臠  WD$0H\$@H$  |p  H$  np  H$  `p  H$  H$  E33H$    A   HQ H$  t  H$  H$  E33H$    A   H H$  7  DF(EyH$  H$  H$  o  H$  o  H$  H$  E33H$  J  A   Hy H$    H$  H$  E33H$  
  A   HT H$  胪  EEyH$  H$  H$  o  H$  n  $  IcWD$0H\$@L$  HL$0-  HcV(W$  H$  LD$0H$    H$  H   X  H$  X  HT$0HtLD$@L+IU  H$  H$  E33H$    A   HJ H$  y  HL$  HT$0HPHHL$P%k  HT$0HtLD$@L+Iڝ  WD$0H\$@H$  m  LIcH$  E3H   L|$PLcN(3I   H   LHP0M_OA   L+IYHHH<    Lfff     HJICJHJICJH
IJK4HICJM[ HR`HuH$  I;s+L   HHL+IKJIHRIuIL;,H|$HLv, 
   H H$  n  HŎ H$  m  EEyH$  H$  bH$  tl  H$  fl  Hw H$  m  Hb H$  m  H H$  xm  IcHL$0jHD$ L$  L$  H$  HԗHL$0R  H$  k  H$  k  H$  k  H H$   l  H H$  l  EEyH$   H$  XH$  jk  H$   \k  IcW$  H$  Q  H$  H   Q  H$  \
 H. H$   Yl  Ld$HI$L$   HT$0IPHHL$Pg  HL$0Q  H$   j  E3EMcELt$PIrwH   HHPML+ȹ   H+H$  MSIIN<    MfD  IDHBIHIDHBHIDHHR IH$  uM;sL   KHKIHIM;rX    Hez H$  Hk  H H$  3k  HË H$   k  HL$0HD$ L$  L$  H$   I}HL$0bP  H$   i  H$  vi  H$  hi  L   Hz H$  j  I$L$  HT$0IPHHL$PHf  HL$0O  H$  i  HD$PHH   C    D$H   H H$  +j  HS H$   j  LL$HLF,H$  H$   7 H$   h  H$  h      Dl$HH H$  i  H H$   i  LL$HL   H$  H$    H$   #h  H$  h  LnHFHFHFF    H H$  6i  H H$   !i  DF`EyH$  H$   H$   g  H$  g  HcF`HHF    Hv H$  h  H H$   h  DF,EyH$  H$   H$   +g  H$  g  HcF,HFHL$PM  HL$hI  H$   H3 L$@  I[@IsHA(sIA_A^A]A\_H\$Ht$WH HZT HHH   oX
 H   3H*HtNH    L   HH   I+HHLI?LI  H   H   H   H   Ht(L   L+I  H   H   H   HKhHt:HSpk HKxHH+KhHHLI?LHShv  H{hH{pH{xHSHHtLCXL+I葕  H{HH{PH{XHS0HtLC@L+Il  H{0H{8H{@HP HKHH\$0Ht$8H _~  @SVWATAUAVAWH  HǄ$  )$  H" H3H$p  LL$8MLHIHL$`<_  IHL$xG   $   HD$`HD$hHD$xH$   WD$H3H|$X$@  H$P  HǄ$H     H$@  @$0  DGHv H$0  豟  IH$0  IPH$H  HrTHH$0  H=   r<tV
 HAH;rV
 H+HsV
 H'vV
 Hx tiHE^
 H$   3H$   H$   H HD$8D$@H$   HL$8T
 HpM H$   Ha
 H$   b HǄ$     H$   Ƅ$   A   Hnu H$  蕞  IL$  H$0  IPHL$HH;t'HH\$HHHHL$PHHHL$XH8HxHxH\$HH$0  Ht(L$@  L+IĒ  W$0  H$@  H$  HrTHH$  H=   r<tLU
 HAH;r<U
 H+Hs,U
 H'vU
 H HǄ$     H$  Ƅ$   A   Hr H$  x  HǄ$h     H$`  Ƅ$P   A   Ht H$P  A  HǄ$     H$   Ƅ$   A   H H$  
  H$0  ܓHD$ L$  L$P  H$  IfH$0  Ht(L$@  L+IT  W$0  H$@  H$  Ca  H$P  5a  H$  'a  D$0HT$0HL$`\  HǄ$     H$  Ƅ$   A   Hr H$  '  IH$  IPH$  `  tiH[
 H$   3H$   H$   H HD$8D$@H$   HL$8Q
 H;J H$   H,
 H$   - HǄ$     H$  Ƅ$   A   H5r H$  `  IL$  H$0  IPHHL$H	]  H$0  Ht(L$@  L+I踏  W$0  H$@  H$  _  HǄ$     H$   Ƅ$   A   Ho H$    HǄ$h     H$`  Ƅ$P   A   H_q H$P  芚  HǄ$     H$  Ƅ$   A   H` H$  S  H$0  %HD$ L$  L$P  H$  I诊H$0  Ht(L$@  L+I蝎  W$0  H$@  H$  ^  H$P  ~^  H$  p^  HD$H D$0HT$0HL$`Y  HǄ$     H$  Ƅ$   A   HL H$  k  IH$  IPH$  ]  tiHTX
 H$   3H$   H$   H HD$8D$@H$   HL$8N
 HG H$   Hp
 H$   q HǄ$     H$  Ƅ$   A   H H$  褘  IL$  H$0  IPHHL$HMZ  H$0  Ht(L$@  L+I  W$0  H$@  H$  \  HHǄ$h     H$`  $P  A   H~ H$P    HǄ$     H$  Ƅ$   A   H~ H$  ̗  DF`EyH$P  H$  =H$  O\  H$P  A\  HǄ$     H$   Ƅ$   A   Hxl H$  [  HǄ$h     H$`  Ƅ$P   A   H~ H$P  $  HǄ$     H$  Ƅ$   A   H} H$    HcV`H$0  ۍHD$ L$  L$P  H$  IEH$0  Ht(L$@  L+I3  W$0  H$@  H$  "[  H$P  [  H$  [  Wt$0HcV`W$0  H$@  LD$0H$0  3  L$0  9V`~)ILD$Hfff     IH[HHI;V`|;^`}HcIHL$`V  HǄ$     H$  Ƅ$   A	   HL} H$  藕  IH$  IPH$  #Z  tiHT
 H$   3H$   H$   H| HD$8D$@H$   HL$8
K
 HC H$   H
 H$   蝅 HǄ$     H$  Ƅ$   A	   H| H$  Д  IL$  H$  IPHHL$HyV  H$  Ht(L$   L+I(  W$  H$   H$  Y  H$   H$(  E33H$  赍  A   HHi H$  +  H$`  H$h  E33H$P  x  A	   H{ H$P    H$  H$  E33H$  ;  A   Hz H$  豓  H$  胊HD$ L$  L$P  H$  I
H$  Ht(L$   L+I  W$  H$   H$  W  H$P  W  H$  W  HD$H D$0LD$0(HL$`*  H$   H$(  E33H$  J  A   Hy H$    IH$  IPH$  LW  tiHQ
 H$   3H$   H$  Hpz HD$8D$@H$   HL$83H
 H@ H$   H
 H$   Ƃ H$   H$(  E33H$  }  A   Hx H$    IL$  H$  IPHHL$HS  H$  Ht(L$   L+IK  W$  H$   H$  :V  HH$  H$  E33H$  Պ  A   Hx H$  K  H$   H$(  E33H$  蘊  A   Hw H$    DF,EyH$  H$  H$  U  H$  U  H$`  H$h  E33H$P  !  A   He H$P  藐  H$  H$  E33H$    A   HCw H$  Z  H$   H$(  E33H$  觉  A   H*w H$    HcV,H$  HD$ L$P  L$  H$  IuH$  Ht(L$   L+Ic  W$  H$   H$  RT  H$  DT  H$P  6T  t$0HcV,W$  H$   LD$0H$  f  L$  L|$H9V,~IIH[HHI;V,|fD  ;^,}HcIHL$`JO  HT$`HL$8L  HT$xI)5  MtL$   M+IIl  MtL$@  M+IIO  H$@  HtH+HLr  MtLD$XM+II  HL$`&  H$p  H3-l ($  HĐ  A_A^A]A\_^[@UHHPHEH\$`Ht$pH|$xH H3HEH3HE  HE   3Hu@uDFHd HMߍ  HCHMH;sTHHUH;wHH}H+H;CuVH͂  HH;HKHtcHA   HqHyrHHH;H;Cu
   H节  HKHt'HA   HqHyrHHHU  
  HC HEHrPHHMH=   r<tyD
 HAH;riD
 H+HsYD
 H'vLD
 Hr HE   HuE A   Hc HM赌  HCHMH;sVHLEI;wJH}H+H;Cu
   H衁  HH;HKHtcHA   HqHyrHHH;H;Cu
   H^  HKHt'HA   HqHyrHHHU  ޑ  HC HMP  HE   HuE A   Hr HMڋ  HUHE  HMsP  HE   HuE A	   HNs HM蝋  HUHE  HM6P  HE   HuE A   HEr HM`  HUHsE  HMO  HE   HuE A   Hhs HM#  HUH6E  HMO  HMH3h H\$`Ht$pH|$xHP]@UAVAWHH@HEH\$hHt$pH|$xHLH<  WEE3LuHMH  HUH;  HMH  HUH;  HMG  Ic`H} HE LEHMH;   HE L;   H} I+HHLMI;umIH+HHs]I+HHH+HsH
*s >
 HQM+IIHHH+IMI;LCL;ICHM蟦  HMLEH   IH   HLMI;uiIH+HHsYI+HHH+HsH
r w=
 HQM+IIHHH+IMI;LCL;ICHM
  HMHtH9HHMHUH:  HMF  HUH:  HMlF  Ic,H} HE LEHMH;   HE L;   H} I+HLMI;umIH+HHs]I+HHH+HsH
q <
 HQM+IIHHH+IMI;LCL;ICHM)  HMLEH   IHzLMI;uiIH+HHsYI+HHH+HsH
,q <
 HQM+IIHHH+IMI;LCL;ICHM衤  HMHtH9HHMHUH8  HME  Ic`H} HE LEHMH;   HE L;   H} I+HLMI;ugIH+HHsWI+HHH+HsH
`p B;
 HQM+IIHH+II;LCL;ICHMۣ  HMLEHt}IHtLMI;ucIH+HHsSI+HHH+HsH
o :
 HQM+IIHH+II;LCL;ICHM]  HMHtH9HHMHUHm7  HUHtLEL+Iz  H\$hHt$pH|$xH@A_A^]HUATAUAVAWHH  HD$ HXHpHx Hb H3H   EELHHL$0X  HL$H轐  E3LmH{\ HL$@5  HU0HL$0W  HI?  HEHHrQHHM0H=   r<t<
 HAH;r<
 H+Hs<
 H'v<
 Hpj HL$H%  LmH[ HL$@蠾  HU0HL$0rV  HI?  HEHHrPHHM0H=   r<t9<
 HAH;r)<
 H+Hs<
 H'v<
 Hi    9_`   HL$H聏  LmHJk HL$@  HȲ.  Hȋ79
 HU0HL$0U  HI]>  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wH>i ;_`!gT;
 M;
 F;
 ?;
 HL$H̎  LmHik HL$@G  HU0HL$0U  HI=  HM0CH  9_,        HEH   Lm@E0 HL$Hf  LmHM0	H  H.j HL$@ؼ  HȲ.  Hȋ8
 HU0HL$0T  HI9=  HM0G  ;_,~Eu	E   `x   HEH   Lm@E0 HL$H֍  LmHM0yG  Hj HL$@H  HȲ.^  Hȋ7
 HU0HL$0T  HI<  HM0/G  ;w`~HMT  HM7
 H   H3&` L$  I[0Is@I{HIA_A^A]A\]HUAVAWHH  HD$ HXHpHx Hv H3H   LHHL$0T  HL$Hٌ  E3L}HX HL$@Q  HU0HL$0#S  HI;  HEHHrQHHM0H=   r<t8
 HAH;r8
 H+Hs8
 H'v8
 Hf HL$HA  L}HW HL$@輺  HU0HL$0R  HI2;  HEHHrPHHM0H=   r<tU8
 HAH;rE8
 H+Hs58
 H'v(8
 He    9_`       HL$H薋  L}H_g HL$@  HȲ.'  HȋL5
 HU0HL$0Q  HIr:  HEHHr4HHM0H=   r uAHAH;s1H+Hr!H'wHSe ;_`!gi7
 b7
 [7
 T7
 HL$H  L}H~g HL$@\  HU0HL$0.Q  HI9  HM0XD  ,   @ ff     HEH   L}@E0 HL$Hv  L}HM0D  H>f HL$@  HȲ.  Hȋ#4
 HU0HL$0P  HII9  HM0C  ;w,~     HMP  HM}4
 H   H3\ L$  I[ Is0I{8IA_A^]H\$WH Ht
   Hc HH\$0H _H\$Ht$WH H3H  Ht;H  T H  L   L+Ip  H  H  H   H  H*HtNH  C L  HH  I+HHLI?LIF_  H  H  H  H  uB  H  Ht(L  L+IFr  H  H  H  HKp   HKXHt)HS`f HSXLChL+Io  H{XH{`H{hHK@Ht:HSHt HKPHH+K@HHLI?LHS@^  H{@H{HH{PHS HtLC0L+Iq  H{ H{(H{0HSHtLCL+Iuq  H{H{H{H\$0Ht$8H _H\$WH HHJA  HOXAA  LG8HT$0MHO8M 9o  HO8a LG(HT$0MHO(M p  HO(a HOH\$8H _@  HL$WH0HD$ H\$HH3HyHyHyHy Hy(Hy0Hy@HyHHyPHyXHy`HyhHpz   H  H  H  H  H@   HxHxrH   H  H  H  H  H  H   HH\$HH0_HL$WH0HD$ H\$PHt$XHHAH@   3HpHxrH @0HY(H\$HH3Hs\  HH_8H\$HH3HsD  HHGXH@   HpHxrH   H   H@   HpHxrH   HH\$PHt$XH0_@SH H"     H_ HH [H\$Ht$WH H3H  Ht;H  4 H  L  L+Izl  H  H  H  H  Ht(L  L+I]  H  H  H  H  Ht(L  L+Ibn  H  H  H  H  H*HtNH  k L  HH  I+HHLI?LIZ  H  H  H  Hx  Ht;H  ! Hx  L  L+Igk  Hx  H  H  HX  HtNH`   LX  HHh  I+HHLI?LIZ  HX  H`  Hh  H@  Ht;HH   H@  LP  L+Ij  H@  HH  HP  HKpHHH\$0Ht$8H _xHT$SH0HD$(H3D$ HHBHBD$    H  Hx  L[  HH0[@SH0HD$     H  HZ  HH0[@SH0HD$     HX  HZ  HH0[@SH0HD$     Hx  H2  HH0[@SH0HD$     H@  Hp2  HH0[H   HD$0LH  L  HQpHD$ I  tWH
6
 HD$P3HD$XHD$`H"_ HD$@D$HHT$XHL$@,
 HA% HD$PH5
 HL$P9g 3HĈ   @USVWATAVAWH$ H  HEH
 H3H   EIHHHUH]E3Dd$4IHL$P35  Lt$XL+t$PIL;vx   HMI  H^xH^ HM茯  HI*
 HH^^ q  HH*
 HH?^ V  H   HM&G  HxrH H
4
 HL$h3HL$pHL$xHEEHT$pHM\+
 H+ HD$hHi
 HL$he Dd$0H   H+   HWD$8Ld$HLD$0HL$8  L'LgLgD$4   HNpLLD$8HT$PEt  T  HT$8HtLD$HL+IX  WD$8Ld$HHT$PHtLD$`L+IOi  HHtLCL+I6i  L#LcLcHH   H3IR H  A_A^A\_^[]HUVWAVAWHH  HEHX)pH
 H3H   EEHHHUHL$H3  Ht$PH+t$HHH;wx   HMF  H_xH]\ HMd  HH(
 HH6\ I  HH}(
 HH\ .  H   HMD  HxrH H
2
 HL$h3HL$pHL$xHEEHT$pHM4)
 H) HD$hHA
 HL$hc 3t$`H   H+   HWD$0Ht$@LD$`HL$0  EuLHOpLD$0HT$HEt2  (HT$0H   LD$@L+IV  WL$0|  WD$hHt$xHOpLL$hLD$0HT$HEt    (HT$hHtLD$xL+If  HT$0HtLD$@L+I3V  WD$0Ht$@HT$HHtLD$XL+If  HHtLCL+If  H3HsHs(H   H3O H$   ($  H  A_A^_^]@SVWH  HD$pH
 H3H$  IHHHT$x3D$@HHBHBD$@   I@I+ HH;Ax   H$   QD  HxH^H+HHY H$   轪  HH%
 HHY 袪  HH%
 HHpY 自  H$  H$   RB  HxrH H
/
 HL$H3HL$PHL$XHD$`D$hHT$PHL$`&
 H' HD$HH
 HL$Ha H   H+   HHL$H  HOpD$0D$(H\$ L_  HT$HHtLD$XL+I#T  HH$  H3M Hİ  _^[HT$SH0HD$(H3D$ HHBHBD$    HpE3E3HH0[HT$SH0HD$(H3D$ HHBHBD$    HpXHH0[LISWH   HD$PI[IsIHH3t$0MHIK"gWD$8Ht$HH7HwHwD$0   HKpLLD$8HT$`jHT$8HtLD$HL+IR  HL$`nHL$   I[Is I_HL$WATAUAVAWH0HD$(H\$hHl$pHt$xHnfHHMp聥3x&
 L   A   AA+iA+AD̉8    AA+iD+EDD<  H@  
 HUpHX   3DL`  LX  II+I*IHHHH?HtdM+IIHHHH?Hfff     EHIRM
HI+HHtI+HEHH;rAIIL;rp  H@  Hx  h(  HX  H  DP  H  H;H{H{H  H  H  p    H  H  H  H|$      f     HCHL$ H;sAHHT$ H;w4Ht$ H+HH;Cu
   H6c  HKHHt(HHH;Cu
   Hc  HCHtH8HCHH|$   H;tHD$ HCHL$ H;sAHLD$ I;w4H|$ H+HH;Cu
   Hb  HHKHt,HH#H;Cu
   Hyb  HCHtH HCH  H  A
 L  H  Hx    HH\$hHl$pHt$xH0A_A^A]A\_HUWATAVAWHHpHEHXHp H
 H3HEHLHUHMM&  H]HLuIi E3H;  HE   LeDeED$HA HMj  HEH;   HEL;   H}I+LEI;utIH+HHsdI+HIIH+HsH
S 
 HSM+IIHL+IIM;HCH;HCHM術  H]LuHIH   HC   LcH{rHHH   LEI;upIH+HHs`I+HIIH+HsH
R 
 HSM+IIHL+IIM;HCH;HCHM  H]Ht*HC   LcH{rHHHU  H.o  H H]HEHrPHHMH=   r<t 
 HAH;r 
 H+Hsz 
 H'vm 
 H<N HUI E  M  I  Ix  6  H]Ht HUH LEL+IHZ  HHt'HV HLFL+IZ  L&LfLfHMH3?F L\$pI[@IsHIA_A^A\_]L$SH0H)t$ IHT$H HKHD$@D$@(H;s\HHT$@H;wOH|$PH|$@H+HH;Ku
   H^  HSHt
HHH
H|$PHBHC(t$ H0[H;Ku
   HZ^  HCHt0(t$ HHCH0[H\$WH HQ3HHtLA(L+IHK  H{H{ H{(HHtLCL+I[  H;H{H{H\$0H _Hy0HArH @SH Hk HHH+  H%
 HKHH [H%
 H\$ WHpH'
 H3HD$`3HHAIHAH HHL$@  HHL$ L  HHOL-O p  HD$8HrQHL$ HH=   r<t
 HAH;r
 H+Hs
 H'vu
 HDK HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t/
 HAH;r
 H+Hs
 H'v
 HJ HHL$`H3QC H$   Hp_@SH HC HHH*  He$
 HKHH [H%
 H\$ WHpH
 H3HD$`3HHAIHL8 HAH HHL$@l  HHL$ L\  HHOLM ٰ  HD$8HrQHL$ HH=   r<t
 HAH;r
 H+Hs
 H'v
 HI HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t
 HAH;r
 H+Hsx
 H'vk
 H:I HHL$`H3A H$   Hp_@SH H{ HHHd(  H"
 HKHH [H%
 H\$ WHpH
 H3HD$`3HHAIH|6 HAH HHL$@̮  HHL$ L輫  HHOLK 9  HD$8HrQHL$ HH=   r<tk
 HAH;r[
 H+HsK
 H'v>
 H
H HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t
 HAH;r
 H+Hs
 H'v
 HG HHL$`H3@ H$   Hp_@SH H!
 HHH&  H%!
 HKHH [H%J
 H\$ WHpHW
 H3HD$`3HHAIH4 HAHq!
 HHL$@,  HHL$ L  HHOLVJ 虭  HD$8HrQHL$ HH=   r<t
 HAH;r
 H+Hs
 H'v
 HmF HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<tX
 HAH;rH
 H+Hs8
 H'v+
 HE HHL$`H3z> H$   Hp_@SH HS
 HHH$%  H
 HKHH [H%
 H\$ WHpH
 H3HD$`3HHAIHL3 HAH	 HHL$@茫  HHL$ L|  HHOLH   HD$8HrQHL$ HH=   r<t+
 HAH;r
 H+Hs
 H'v
 HD HD$XHD$8   HD$0    D$  HrQHL$@HH=   r<t
 HAH;r
 H+Hs
 H'v
 HZD HHL$`H3< H$   Hp_@WH0HD$ H\$PHHHIH;s]HH;wUH+H988HHHHH?HH;KuHV>  HKHL$@HHHHL$HHt *H;KuH">  HKHL$@HL$HHt	HǓ HCHH\$PH0_@SH HH	Ht@HS LCHgfffffffL+IHLI?LHq  3HHCHCH [H\$Ht$WH HHHIH;sqHH;wiH+HgfffffffHHHHH?HH;OuH>  HwHtlHHHF   HF     HHHc  C F ;H;OuH=  H_Ht$HC   HHC    H b  F C HG(H\$0Ht$8H _HL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	 HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFIIf HWH HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI  LGHVHXe pMt/HWI HOH+IHHLI?LH<  HNH+IHHHH?HH>  tLHVHd HGHGHH\$XHt$`H|$hH@A_@SH HH	Ht@HS LCH*L+IHLI?LHL<  3HHCHCH [H\$WH HHHIH;   HH;   H+H*HHHHH?HH;Ku
   HS<  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;Ku
   H;  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H3
 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+
 H[HI~H+LH
 Ht$0H;H|$8IFIH\$@H A^HtH<  HSIH+H=  t!HH[I>H+LHi
 H;IFH|$8IH\$@H A^@SH HHHtLAL+I?<  3HHCHCH [H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbH?H;vH
A 
 HH|$0Xq  HHFHHHNI~IHH+LHu
 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLH?H;vH
h@ J
 p  HH    HGLH3HHOHG H_HH\$0H _HXLLHBHII+HH;uGI@I9@   E3Ht(MP      I
MRKIIPHM;HrI@HXH
 D$(HD$0HT$83HL$ HD$8HD$@H]8 HD$ 2
 H
 H
 HD$0HL$0F HE
 D$(HD$0HT$83HL$ HD$8HD$@H\) HD$ 
 H
 Hu
 HD$0HL$0tF HXLLHBI+HH;AuBE3L9Av%LY HQpL+ڐIHRIIHJM;ArIA8II8IQpHXH`H
 D$(HD$0HT$83HL$ HD$8HD$@HE7 HD$ 
 H
 H
 HD$0HL$0E H\$WH HHH;Qt>H	y
 HtH  HH{H\$0H _H    H{H\$0H _HyH\$0H _HLHLHALBHBHLA@SH HHHtLAL+IH  3HHCHCH [H\$WH 3HHHHAHAHtJHH;vH
8= 
 n  HL    HCHHIHKH8 LCHH\$0H _@SH L
ä HL II+HH;sH+IH H [H;   L H+II+HH;s\IIH+H;sH
x< Z
 HM+I3IHL+IM;HCH;HC&n  L
 L ILI+3HIL+IzC H
 HH+ HH+HHף H [H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
y; [
 HM+I3IHL+IM;HCH;HCHn  HOLH3H+HL+IB HGH+HH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuH9  HSHt7HHH
HCH\$0H _H;CuHy9  HKHtHHHCH\$0H _@SH HH	Ht@HSV LCH*L+IHLI?LH\2  3HHCHCH [H\$WH HHH;tsH	Ht$03Ht>HS HKH*H+HHLI?LH1  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
8 
 H)g  HHCHHHHKLHVHY HCHH\$XHt$`H@_H\$WH 3HHHHAHAHtNH
H;vH
h8 J
 f  HHHCHHL    IHKH脾 LCHH\$0H _@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HQ8  HKHL$@HHHHL$HHtn
  /H;Ku
   H8  HKHL$@HL$HHt	H=
  HCH\$PH0_@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+H H_H\$0H _@SH0HD$ HH	HtHP tH    H0[@WH0HD$ H\$@HHH;tEHHR%  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR襁  HH@HH HH@HC    DD$@HHX  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I'0  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I@  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _H\$Ht$WH0HH  HH;t$HP H  xHC@H\$HHt$PH0_LD$@Ht$@HU LHD$ HT$@HLH OY HD$@H\$HH@Ht$PH0_@WH0HD$ H\$@HHH;tEHHR  HH@HH HH@HC    HHHHHKHGHCHOHH\$@H0_@WH0HD$ H\$HHHH;t9HHR腁  HH@HH HH@HC    DD$@HH  HH\$HH0_H\$Hl$Ht$WH 3HHH;tDHHtLAL+I>  H+HkHkHHHGHCHGHCH/HoHoHwH{H;tDHHtLGL+I6>  H/HoHoHHHFHGHFHGH.HnHnHl$8HH\$0Ht$@H _@WH0HD$ H\$PHHHAH;sjH	H;wbH+H;Cu
   H/>  HKHL$@HH;HL$HHt03HA   HAHyrHH  IE3HI  VH;Cu
   H=  HKHL$@HL$HHt03HA   HAHyrHH  IE3HI  HC H\$PH0_H\$WH LAHLHII+HH;s$H+IHIH H_H\$0H _H;   LOH+II+HH;sQIIH+H;sH
0 	 HM+I3IHL+IM;HCH;HCHp  HOHHH+HH+- HGH+HH+HH_H\$0H _HL$WH@HD$0H\$XHt$`HHH;   L
HRL;uHQH	 H   LM+ILQH	IH+HL;w*LII  HSH轸 HGH+HH   HCH+HL;w'HILHI  LCHWHeW LHtIf HLCL+I8  HWH+HH <  tLHWHW HCHCHH\$XHt$`H@_@SH HH	Ht)HS HLCL+IC8  3HHCHCH [H\$WH HAHHH;s0H	H;w(H+H;Cu
   H:  HKHt@HH;H;Cu
   H:  HKHtHA   HHA     0K  HC H\$0H _H\$WH HHH;t\H	Ht$03Ht'HS HLCL+I`7  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _HL$WH@HD$0H\$XHt$`HH3HHAHAHzH+:HHHAHAHtJHH;vH
- 	 Hc  HHCHH;H{LHVHU HCHH\$XHt$`H@_H\$WH HAHHH;s>H	H;w6H+HH;CuH
:  HSHt3H
HCH\$0H _H;CuH9  HKHtHCH\$0H _H\$WH HHH;tPHHt$03HtLAL+IL'  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _H\$WH HAHHH;sEH	H;w=H+HH;Cu
   H9  HSHt<HHH
HCH\$0H _H;Cu
   HO9  HKHtHHHCH\$0H _HQHH+HHtH    H+HQH\$AVH HLH;"  HLCI;uHHAHH\$@H A^IIMNH+L+HII;w1L+H	 IHKH+HHIINH\$@H A^MFL+H|$8II;wSHt$0HJ4LL+q	 H[HI~H+LHW	 Ht$0H;H|$8IFIH\$@H A^HtH5  HSIH+H~8  t!HH[I>H+LH	 H;IFH|$8IH\$@H A^H\$Ht$AVH 3LHHHAHAHZH+HHHAHAHtbHH;vH
) 	 HH|$0([  HHFHHHNI~IHH+LHE	 HH|$0HFH\$8HHt$@H A^H\$WH 3HHHHAHAHtLHH;vH
8) 	 Z  HH    HGLH3HHOHf0 H_HH\$0H _H\$WH HAHHH;sHH	H;w@H+HH;Cu
   H56  HSHt
HHH
HBHCH\$0H _H;Cu
   H5  HKHtHHHAHCH\$0H _H\$WH LAHLHII+HH;sH+IHGH\$0H _H;   LOH+II+HH;sQIIH+H;sH
' 	 HM+I3IHL+IM;HCH;HCHT[  HOLH3H+HL+I. HGH+HH+HH_H\$0H _H\$WH HHH;tPHHt$03HtLAL+I2  H3HsHsHHHGHCHGHCH7HwHwHt$0HH\$8H _@SH0HE3HQ(DD$ HC   LCDD8tI IB< uHn=  HH0[@SH0HE3HQ DD$ HC   LCDD8tI IB< uH=  HH0[@SH0HE3HQDD$ HC   LCDD8tI IB< uH<  HH0[AAH\$WH HzHZrHHyHyrH	HH?LH;LBMt	C	 uH;sH\$0H _3H;H\$0H _@SH03HB   HBHڈHHˉD$ 8=  HH0[H\$Ht$WH HAHyHHIH;uFHHvH
% 	 H;sLHHf  HuH{HrHH  H{rHH@4HHHt$8 H\$0H _@SH HAHHrOH	HH=   r<t	 HAH;r|	 H+Hsl	 H'v_	 H.  HC   H{HC    rH H [@WH0HD$ H\$@HHH;   HAHrPHH	H=   r<t	 HAH;r	 H+Hs	 H'v	 H HC   HC    H{rHH  HH?  HH\$@H0_@SH E3HA   LAHDD8tIIB< u9  HH [@SH HA   IHA    E3 H:  HH [H\$WH HHK  HH	 tHCh    H\$0H _HH{hH\$0H _H%x	 @SH H    Ht'  tH   	 y	H [3H [@SH HMH   Ht9HuMuEAE3O	 uH   D@HA  HH [3H [H\$Ht$H|$ AVH H    MI@HI0HHD$0t|>  tsH   HT$0	 u]HtH   D@H	 u@H   HT$0	 u*IFHHGtJ>  HOtHD$0HCH    HKH	 H3HHC    HCHt$@HH\$8H|$HH A^H\$Hl$Ht$ WH LQ8HApAIHHI9uAu
Hyh uHH    tb=  tYHutH   DH	 u8H   HT$0	 u"Ha=  HKtHD$0HGH    HOH	 H3HHG    HGH\$8HHl$@Ht$HH _HUWAVHhH   HEHXHpH
 H3HE7HHA8HHt,HWPLcJH;sA@HO8HHBH  H    u  LGHGpI9 u H   H   IHG8H+HGPHh u"H   	 tl  d  HE/   E3Lu'DuH   	   HU'HHH  HZH  LM/L;sLHHMx`  Hu Lu'HEIHCEHU'LM/Ht/HEIHCE@4H]'HEH}/HCE LM/HU'HMIHCMLELCEL
HWtHEHD$8HEHD$0HEHD$(HEHD$ HOhn	    ~   H}'s4HELEHMH9Eu^HEH}/HCEL+32  HUH}/r'HHu#E	     	 HUE
HE EqHUH}/HCʋE'A+Hc؅~,     HBH   	 H~LEHU]#H
7 	 H
) 	 HUHE/HrPHH=   r=Et	 HBH;r
	 H+Hs	 H'v	 HH HM7H3; L$   I[(Is0IA^_]@SH HA8HL MtHAPHcIL;s
A H [H|$0hu
H|$0H [ËH   H|$0H [H\$WH HA8HًHHt6HCH9s-tA;u HCP HC8H3EH\$0H _H   HtstnH{h u@	 uKLC8HSpI9tKLK@:IH;tH   HCPHcIH   IHC8+ʃqHHCPH\$0H _ÃH\$0H _HUWAVHhH   HEHXHp HO
 H3HE7Hكu3;EB  HA@HHt.HAXLc JH;sAHHS@LIHH
A0  H    u  LCHCpI9 u H   H   IHC8H+HCPH{h u@H   	 ;E  @u   HU/E 3HMHE'   HEHHCHLELM/fD  HMIICHUICHM'HEHD$8HL$0HT$(HEHD$ LMLEHStHKh&	       HELELM/IICH}H+t.HMIICL   LǺ   	 LM/LEH;ufCqHEH9Eu$HCH}' sHE3WHMm2  3u#MH   n	 ;ELM/LELM/LEIrQIAH=   r=Et	 I@I;r	 L+Is	 I'v	 LI HM7H3<
 L$   I[0Is8IA^_]H   HtH%	 H   HtH%	 @SH0HD$ HH
 HH    t/HIHCpH9u"L   H   HHC8HD+HCPD {| t	H]8  HH0[H%	 @SH0HD$     H:  HH0[H\$WH HhHHcPH
 H
hHhHcPHw
 DhD
dHAH9  HOy	 HOH\$0H _H%	 DL$ HL$SVWH0HD$ HHD$h    H
 HH
 HAH   V	 D$h   H^E3HH	 HHcHH;
 H1HHcHhT1H\$XH	 H
 HLGHrH?HCh    Cp    MtHH]  HH0_^[DD$HL$WH0HD$ H\$HHD$P    H
 HH
 HAH   v	 D$P   E3HWH=	 HHcPH^
 H:HHcPDhDD:   HO:  HH\$HH0_@SH0HD$     HV8  HH0[H\$WH HxHHcPH
 H
xHxHcPH7
 DxD
tHAH6  HO9	 HOH\$0H _H%	 @SMPHMLLA@I Ht
H9AhsHAhH\	 HL;   H|$AtnI{8H? tdM   ISIChH+L;   +ICPA)IK8HcHAthMC@IHt\ICXHcIC8HHI+ICX>At5I8 t/Mx*ISIChH+L;ICXA+A)IK@HcHLH|$3LHC    HCH[H\$WHy@LLHHt
H9AhsHAh\$0Ht$   Hq8HH   H-	 AuIBIJhH+LAuuIBH+LEtLM   IJIBhH+L;   +IBPA)IJ8HcH   MJ@I	H   IBXHcIB8HHI	+IBX   trHHtjHv	 AuIBIJhH+LAuIBH+LEtLMx)IJIBhH+L;IBX+A)IJ@HcHLMt
H	 L Ht$3H\$MIC    ICI_LI8IHtOLQPIcHH;sApu6HA@L Mt*L;wH9QhvL9AhsLAhHAhA+AHA8HÃHA8L Mt=HAL; v4tA:PtApu#HAP HA8HtHA8H3ҋÃ@SUH(ApH٨t
H(][Ãu	3H(][èt+LI@IHtLAhI;sHAXHcMHHCXA+ȉHC@HHt0HSXLcJH;s A@HK@HHBH@*H(][H|$HHu3HCXHc8HCH+8HHHH s    Ht H+H;sHuHuH|$HH(][Ht$@Lt$PL|$ L<9I5  HKHL1HtLIH^.	 HuNHC HshH0HC@H0HCXD8HCCpH0HC8tH     HCP0   H0HCP       HK HI+HChHC@HHI+I+HHHC@+AHHCXCptHCH0HC8H     HCP0/HC@LHC8HHCI+HD+AH0HC8HHCPDCpL|$ Ht$@tLI5  HCXKpLt$PH|$HHK@HHBH@*H(][H\$WH H
 HHHIE	 HO ;	 HO(1	 HH	 t
0   H
 HH\$0H _H\$WH H\t
   H
 HH\$0H _H\$Ht$WH HH	 @t   HhO
 Ht$8HhH\$0H _H\$Ht$WH HHN	 @t   Hx	 Ht$8HxH\$0H _H\$WH H
 HH/  H	 t
x   H	 HH\$0H _H8HD$ HHHcHHLHHt+HHPHH;uH   Htj	 ҐH8HT$HL$SUVWATAUAVAWHXHD$0LLHx  H\$ HSH蟕 HHCI  H$   HVHm HHFI  HHGWD$8HD$H    IX  Hl$(HT$8H  ILl$8I;^F  M@  @ HI  LIL$I+$HH;  HHL$ KvL<    HU IH;  H{rHHHsA   I;LBMtH
 )	    H   HǄ$   HGH$   H;sOHH$   H;w?H$   H+HH;Gu
   H  HHOHtHHHG  H;Gu
   H  HGHtH HG   HE    3MDMII+HHtM+IAHI;rCt H$   L4I;   D  HGH$   H;sGHH$   H;w7H$   H+HH;Gu
   H  HOHHt(HHH;Gu
   H  HGHtH0HGHH$   I;pHl$(H$   H H$   H;XL$   I  H  HGH+HA  MtwHD$HI+HH?H;v	 H    H=   r=At	 IEI;r	 L+Is	 I'v	 LI HXA_A^A]A\_^][@SH LH988HIHHMAI+HHHH?HH   MHM+I88IHHH?HIH+HsH
 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [4  H [@SH LHgfffffffHIHHMAI+HHHH?HH   MHM+IfffffffIHHH?HIH+HsH
* 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [4  H [H(H
L;v	 K@HH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH(n @WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _N5  H _H\$WH 3HHHHAHAHt:H
H;vH
H *	 |4  HHHCHHȰHKH\$0H _HL$WH@HD$0H\$XHt$`HH3HHKHKLBL+H*IHHHH?HHHKHKtNH
H;vH
 z	 H3  HHCHHHHKLHVH% HCHH\$XHt$`H@_H(H?L;v_	 J    H=   r<tC	 HBH;r3	 H+Hs#	 H'v	 HHH(  H(LQLLAII+HH;s_H	I?L+III+H;sH
| ^	 L+II3IHL+IM;HCH;HCIH(#5  H(H\$WH 3HHHHAHAHt6H?H;vH
 	 L4  HHCHHHKH\$0H _HL$WH@HD$ H\$XHl$`Ht$hHHL
 H3HYHQLAHY HY(HY0LAH+H*HHHH?HI;s)H
L;vH
8 	 IHO UM  H    HHWHL$(HHO %7  HL$(HtFHD$8H+HH;w\H    H=   r u@HAH;s0H+Hr H'wH HH;_s%	 	 	 	 	 HH\$XHl$`Ht$hH@_@SH HH	HtHCHH+HH;vW	 H    H=   r<t;	 HAH;r+	 H+Hs	 H'v	 H 3HHCHCH [H(LQLLAII+HH;s_H	IL+III+H;sH
l N	 L+II3IHL+IM;HCH;HCIH(4  H(H(LILHQIH+HHs`H	IH+IHH+HsH
  	 L+HI3IHL+IM;HCH;HCIH(Q4  H(@SH0WHLe        f/e I1  LHe HHe HHH
e HЋ HIH
d H0[HL$WAVAWH@HD$0H\$hHt$pMHH3HHAHAHtYH
H;vH
 	 .  HHCHL4    HIHKHMHH3 I6HCH\$hHt$pH@A_A^_@WH LLHIH*LHMJM+IHHH?HI;   M+
HII
HHH?HIH+I;sH
 	 I+
NHH3HHH?HHHL+HL;HCI;LCIIH _3  H _H\$Hl$ VATAWH    HDL'  A  A>  3AADEDE+t3AAAAD+u	AD+AI   Hi  IHHH+HHHHiH+;uHp&  AE3c'    3H|$@  Lt$H3DDDH      @   EuEA+D;sG
E  EEufD;uA\3҃A=r#A˸  A+i+*AAHIHHH+HHHHiH+ȋE&  DEuD|CA+D;rB]  D;uDY3҃A=r#E۸  AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸  DAA+iD+t3҃=r#D۸  AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rA  DH   3Ҹ=r$A  +i+k3҃=r#Dø  AA+iD+&ILIIH+HHHHiL+ApArA  Et
AC  3ҋM%  ADp$  Lt$HH|$@H\$PHl$XAH A_A\^H\$Hl$ VATAWH    HDL  AM  A
e  3AADEDE+t3AAAAD+u	AD+AIp     HiM  IHHH+HHHHiH+;uH@   AE33!    3H|$@M  Lt$H3DDDH      @   EuEA+D;sG
EU  EEufD;uA\3҃A=r#A˸   A+i+*AAHIHHH+HHHHiH+ȋEU   DEuD|CA+D;rB]U  D;uDY3҃A=r#E۸   AA+iD+'EIMIIH+HHHHiL+؅uD   3ҋ=r&D۸   DAA+iD+t3҃=r#D۸   AA+iD+)EۋLIIIH+HHHHiL+؅t+D;rAU  DH   3Ҹ=r$A   +i+k3҃=r#Dø   AA+iD+&ILIIH+HHHHiL+ApArAV  Et
A?  3ҋ  AD@  Lt$HH|$@H\$PHl$XAH A_A\^H(HL;v	 II   r<t	 HBH;r	 H+Hs	 H'v	 HHH( LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HRA  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@Hs,  LD$PL;D$XuLHH\$HH0_LL$ LD$WH0HD$ H\$HHHHL;u5L;u0HR7C  HH@HH HH@HC    HHH|M;ttIAx uNIPz uH
y uHH	y tHT$P(IHy uL;AuLHL$PHIy tHL$PLHT$@H30  LD$PL;D$XuLHH\$HH0_H(HL;v	 J    H=   r<t	 HBH;r	 H+Hss	 H'vf	 HHH(. H(LQLLAII+HH;s_H	IL+III+H;sH
 	 L+II3IHL+IM;HCH;HCIH(3  H(H\$WH 3HHHHAHAHt6HH;vH
H
 *	 )  HHGHHH_H\$0H _H(LILHQIH+HHs`H	I?H+IHH+HsH
 	 L+HI3IHL+IM;HCH;HCIH(q#  H(H(LQLLAII+HH;s_H	IL+III+H;sH
<
 	 L+II3IHL+IM;HCH;HCIH(%  H(H\$WH 3HHHHAHAHt6HH;vH
 	 #  HHCHHHKH\$0H _H\$WH03IHHHAHAP"  HLHGHHHGH| HHOH\$@H0_H\$Ht$WH03IHHHAHHAHtMHH;vH
 »	 4"  HLHCHHHHKLI} MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPHH;uH   Htz	 ҐH8@SH0HD$ H	 u
H"	 HHHcHHLHHt+HHPL
 I;uH   Ht 	 ҐH0[H\$Ht$WH IHلtkHyrdH9MtH
	 HCHH=   r=@t	 HGH;r	 H+Hs	 H'v	 HHL HC   H{HsrH3 H\$0Ht$8H _@UAVAWH ILLMuL;Aw
IH A_A^]H\$@HYHt$HH|$PL;~   I+H;wv   H+HHyrHIJ4  HtPALHK	 HHt8Ht!LIH	 tH+HHHwI~rM6I+HHHt$HH\$@H|$PH A_A^]H\$Ht$WH HyHHrHHzrHH	HH
H\$0Ht$8H _LBH1It	 H7H\$0Ht$8H _HzsNH;tdHA   3H;GwQLIH+@ H[IH;uH\$0Ht$8H _LAH2ItHHk	 H3H\$0Ht$8H _H\$ VATAWH0MILHMtfLAIrHHL;rOIrH	HKI;v=IrHHL+LHD$pLHD$(HL|$ 0  H\$hH0A_A\^HKI;sH
 E	 Hl$PHl$pLt$`HLHM+I;IGH+H;wH
{
 E	 L+H|$XH;s;HCHrHHHrHHMtHMJ HH	 LCIH+HHu	H   HvH

 ζ	 H9{s(HH-  H   H;s\HCHr%H#HuH{H{rH@8oH gHHrHHMtJ!MJ HH	 H{rHHHtJ LIc		 H{H{rHH8 H|$XHH\$hHl$PLt$`H0A_A\^H\$WH HyHH;sH

 	 HH+I;w2HQHyrH HH\$0H _H H\$0H _MtRHyrHHI+HHH+t
JL	 H{H{rH8 HH\$0H _H; HH\$0H _H\$Ht$WH AHHHuH
"
 	 HvH

 ش	 H9ys'LA+  H   HuVH{rGH@0bHuHyHyrH@8HH\$0Ht$8H _H H\$0Ht$8H _H@3H{rHH@L H{H{rHH8 Ht$8HH\$0H _H\$Ht$WH IHHHtZHQHrHHH;rCHrH	HKH;v1HrHHH+LLHHH\$0Ht$8H _   HvH
 	 H9{s LCHH`*  HtuH{rDHBHuH{H{rH@8HH\$0Ht$8H _H H\$0Ht$8H _HHtLHI	 H{H{rHH8 Ht$8HH\$0H _H\$Ht$H|$AVH HBIMHHI;sH
 y	 I+H;HGH;u9I8H9AsH
 R	 HAHyrH	 3H   HvH
 U	 H9ys'LAH*)  HtaH~rH6H{r%H#HuHyHyrH@83H +HHtJ6L'	 H{H{rHH8 Ht$8HH\$0H|$@H A^H\$Hl$VH HALAHI+HH;wH
 	 H|$0I<H   HvH
 \	 H9ys'H5(  HtxHKHu9H{r)H@,GHuHyHyrH@8FH >H@,H{rHH@HL_ H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$VH IHHHtZLIIrHHH;rCIrH	HKH;v1IrHHH+LLHHH\$8Hl$@H ^   LCIHH;wH
[
 %	 H|$0I<0H   HvH
5
 	 H9{sHH&  HtZH{r%H#HuH{H{rH@86H .HHtHKLH	 H{H{rHH8 H|$0HH\$8Hl$@H ^H\$Hl$Ht$ AVH HBIILHI;sH
w
 	 LAH+H;HGIHH;wH
@
 
	 H|$0I<0H   HvH

 	 H9ys#H%  HteI~rM6H{r%H#HuHyHyrH@87H /HHtHKI.L	 H{H{rHH8 H|$0HH\$8Hl$@Ht$HH A^H\$WH HzHHsLBIt	 HtHHH    HCHGHCHGHC   H{HC    rH  H\$0H _ H\$0H _LIHApI9u"H   L   ID+HA8HHAPD HUWAVHHpHEHXHpH{
 H3HEHHyh   yq   $u2      HUE 3HMHE   HEHHCHE3LMHM HUIHCLELCLMLHEHD$ HWtHOh	 t   DwqHEHMLMIHCH]H+t5HEIHCL   Lú   H	 LMHMH;   D8wq   HVHLEI+H   IXH   L;sHHM#  LMHMHu!LuHEIHCD0HHUIHCHE3HH]HEH}HCEЈLMHMt 2H
 	 H
 	 ̳IrNIAH=   r=Et	 HAH;r	 H+Hs	 H'v	 H_ HMH3 L\$pI[(Is0IA^_]@SVWH AAq HHA|	 3HtNLL$XHt$@LD$HHt$HHT$@Ht$XH`	 HD$@HCHC HD$HHC8HC@HD$XHCPHCXH:E HCtH   HshH _^[H\$Ht$WH H    Hu3#H   3HHD	 HEHC| Cq B	 H
D HHt$8HKtH   H{hH\$0H _@WH@HD$ H\$PALHH       A@   I	 HtyA   HHHT$(H	 HG  HH	 t
HCh    H{hH	 HL$0HtHPHtL    HAH3H\$PH@_@SH ApHtzHA@HHtHCXHcHHCPHcHC8HHCHH+H   r<t	 HAH;r	 H+Hs	 H'v	 H HC3HHC8HHCPHC HHC@HHCXcpHKhH [H\$WH HHH{LCrHHGh    MtHHu$  H\$0H _H\$WHPHGv
 H3HD$H3HڋQp|$    HA@LM   LAhHA M;HL$(MBHL+HD$@   H|$8@|$(pHC   HT$(H{H@;$HD$@HI  HL$(HH=   0  t	 HAH;r~	 H+Hsn	 H'   ]	 uhHA8HHt\HAPLc HALHL$(HL+HD$@   H|$8@|$(HC   HT$(H{H@;fHL$(<   HD$@   HT$(H|$8H@|$(HC   H{@;(HD$@HrQHL$(HH=   r<t	 HAH;r	 H+Hsz	 H'vm	 H< HHL$HH3 H\$pHP_@WH0HD$ H\$HH	 H	
 HD    AAAȃ$AEȋËу$DHGh    DGpHH\$HH0_H(Hu	3ɋH(H   r)HJ'H;w	 X HH'HHAHH(H< HH(H(I   r<tP	 HBH;r@	 H+Hs0	 H'v#	 HHH( Lʹ   AN  H   Ip     AtetauAW3҃=r Aȸ   +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E   AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ   A+i+ȋÃt`3҃A;r$Aɸ   D+iD+0Hp     IHHH+HHHHiH+LEtE+E;rAU  EADʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+ALʹ   A  H   I   AtetauAW3҃=r Aȸ  +i+)AHIHHH+HHHHiH+Et_AtY3҃A=r#E  AA+iD+'EIMIIH+HHHHiL+I(DA   3AA;r$Aɸ  A+i+ȋÃt`3҃A;r$Aɸ  D+iD+0H   IHHH+HHHHiH+LEtE+E;rA  EADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+AH(HfffffffL;vO	 KHH=   r<t3	 HBH;r#	 H+Hs	 H'v	 HHH( H(H88L;vϢ	 KHH=   r<t	 HBH;r	 H+Hs	 H'v	 HHH(N H(Hu	3ɋH(H88H;v	 HHH   r,HA'H;w	 H HH'HHAHH( HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH HH988LKHML+IHHLI?IHt+I\ HKHH+HHLI?LHkHl$HKHHKHH|$XHHKH3H\$@Ht$PH0A^H\$Ht$ WH0HHHu3UHfffffffH;vU	 HHH   r&HA'H;w4	 H{ HX'HHCh HHVLHHl$@Lt$H HHgfffffffLNHML+ILIMI?MHt+I\ HNHH+HHLI?LHHl$@HHHNKLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(H
H;vA	 HRHH   r,HA'H;w 	 Hg HH'HHAHH(N HH(H\$Hl$Ht$H|$ AVH0LH[HSLHH9 HH*LKHML+IHHLI?IHt+I~W HKHH+HHLI?LHHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^@WH0HD$ H\$PHHHIH;sbHH;wZH+H*HHHHH?HH;Ku
   HHKHL$@HHHHL$HHt莎/H;Ku
   HHKHL$@HL$HHt	H]HCH\$PH0_H(Hu	3ɋH(H?H;v!	 H    H   r,HA'H;w 	 HG HH'HHAHH(. HH(H\$Hl$Ht$WH HHaHHLCHL+	 HH{H+HHtLCL+IHHl$8HCHHCH3H\$0Ht$@H _H(Hu	3ɋH(HH;v!	 H    H   r,HA'H;w 	 HG HH'HHAHH(. HH(H\$WH HHu3UHH;v	 H    H   r&HA'H;w|	 H HX'HHC HH5 HL5 L+Ht$0>	 Hg5 H5h5 H+HHtL]5 L+IHH65 H?5 HHt$0H\$8H"5 H _H\$Ht$WH HHHu3UHH;v	 H    H   r&HA'H;w	 H HX'HHC HHHLGL+Hl$0M	 HHoH+HHtLGL+IHHt$@HGHHl$0HGHH\$8H _H\$Hl$Ht$WH HHHHLCHL+Ø	 HH{H+HHtLCL+IhHHl$8HCHHCH3H\$0Ht$@H _H\$WH HHHIH;   HH;   H+H*HHHHH?HH;KuH  LCM   HHH3IIHIHHI HBI@HBI@H
HJHJHCH\$0H _H;KuHt  HSHt.3H
HJHJHHHGHBHGHBHHOHOHCH\$0H _H\$Ht$ WH0HHHu3UH
H;v5	 HRHH   r&HA'H;w	 H[ HX'HHCH HHVLHHl$@Lt$Hd HH*LNHML+ILIMI?MHt+IU HNHH+HHLI?LHHl$@HHHNKvLt$HHHNHH\$PHt$XH0_H(Hu	3ɋH(HH;v!	 HH   r)HJ'H;w	 N HH'HHAHH(H2 HH(H\$Hl$LD$VWAVH Ax LHIuYI@x u"LH x u LH x tLD$P-I@x u L;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@     z uBHIAA T  Iz uHBxu#HxuB HLMIL;X?HxuHBH@B a  IAAHΈBAAHI@  ABHOX3Ht~HGhHH+HH;v	 H    H=   r<t˓	 HAH;r	 H+Hs	 H'v	 Hm HoXHo`HohHO@Ht~HGPH?H+HH;v`	 H    H=   r<tD	 HAH;r4	 H+Hs$	 H'v	 H Ho@HoHHoPHO AH HFHtHHFHD$PH\$@Hl$HIIH A^_^H\$Hl$Ht$ LD$WAVAWH Ax LHIuSI@x uLH x uLH x tLD$P*I@x uL;@uHD$PLH@x tLHD$PHy tLWHGx tL
MPL;   Az LOuMJHH9xuLPI99uMMQHH9:u0Az tI!IIʀx uf     HH x tH
HH9z   Az tIHJ   IBIʀx u@ HH@x tHJpLAHI L;GuM"Az MHuMJMHGI@HGL@HH9xuL@HGH98uL L@HGI@GAHA@O  HL;Pw  fD  AzMII]  IL;   IQz uUBIIAA HIAHx uLHIAHAHL;HuHHIAL;uHHHL	IQIIz    Hxu
HBxt|HBxuHH@B   IQAAHΈBAAHBI@#
     z uBHIAA   Iz uHBxu#HxuB HLMIL;X?HxuHBH@B   IAAHΈBAAHI@/  ABHOX3IHttHGhH+HI;v7	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H轼 HoXHo`HohHO@HttHGPH+HI;v	 H    H=   r<t	 HAH;r	 H+Hs~	 H'vq	 H@ Ho@HoHHoPHO 蛛H# HFHtHHFHD$PH\$@Hl$HHt$XIIH A_A^_H\$Hl$Ht$WH0HHHWLHH/ HHWHH+HtHH HLGL+IHHHHHwHt$PH_H\$@H/Hl$HH0_H\$Ht$WH03IHHHAHHAHtMH?H;vH
 
 	 THLHCHHHHKLIK MLCH\$@Ht$HH0_H8HD$ HHHcHHLHHt+HHPLAy
 I;uH   Ht	 ҐH8@SH0HHD$     P(HH0[LD$HT$HL$SVWAVH8HD$ MHHHHvH5LAIHHHHH;vHHH+L;wJ<HOHu36H   r%HA'H;wE	 H荵 Hp'HHFz HH\$`Lt$pH|$hHt$xMtH{rHHMtMHa HCHrOHHH=   r<tZ	 HAH;rJ	 H+Hs:	 H'v-	 H HC   HC    H{rHH  H3H{LsH{rHB3 H8A^_^[@SUVAVH(IILALHL;sH
 $	 IALd$XLd$pI;sH
 	 H|$PIH|$xL|$ MM+I;IGI+H;HGH+HHH;wH
,
 	 Ll$`L+L,9M;sBIvH

 ц	 L9ks
IHMuLkH{rHH  H;u2H~rH6H{rHHH  J&LJ0  H;tsHCHrHHHrHHMtJ1MJ0HH	 H~rH6H{rHHH6  J&LJ0, !  H;suHCHrHHHrHHHtJ!LJ0x	 HCHrHHHrHHM  J1MHJ0H  M;wuHCHrHHHrHHMtJ1MJ0HH	 HCHrHHHrHHH=  J!LJ0'  I.I;HCwvHrHHHrHHMtJ1MJ0HHz	 HCHrHHHrHHH   H+J0ILH   HrHHHrHHHtJ!LJ0
	 HCHrHHHrHHMtJ1MJ0HH΅	 HCHrHHHrHHLL+tJ!HJ0H	 H{LkrHHH|$PL|$ Ld$XB( HLl$`H(A^^][H\$Hl$VH ApIHH<   Iv&	 H|$0H   r#IH'H;w	 R Hx'HHGH< HLHHO CpL7LChuHKH9HC8H8HCP0CpuEHHC IE+H8HC@HHCXHC8H8 uHCH8HC8H     HCP8KpH|$0H\$8Hl$@H ^H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$H\$3һDDDZDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ڋH\$@SH LH*HIHHMAI+HHHH?HH   MHM+I
IHHH?HIH+HsH
*
 	 I+LBHH3HHH?HHHL+HL;HCI;LCIIH [   H [H\$Hl$Ht$H|$ AVH0LHHSLHH HH*LKHML+IHHLI?IHt+I^A HKHH+HHLI?LHkHl$HKvHHKHH|$XHHKH3H\$@Ht$PH0A^LI@HI@x uHPHBI@HH;Pu
L@IPLBHBH;Pu
L@IPLBL IPLBLBI HBI x uHPHBI@HH;PuL@ILBHBH;uL ILBL@ILBHl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  H衯 3HS8HS@HSH3HK HtqHC0H?H+HH;$  H    H=   r0  HAH;   H+H   H'   H# 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   HȮ 3HC   H{HSrHH 襮  HxH\$0Hl$8Ht$@H _	 	 	 	 	 	 {	 t	 m	 f	 _	 X	 Q	 J	 Hl$Ht$WH z HHH  H\$0f     HWHHNXH^ H?HtsHCHHH+HH;  H    H=   r0_  HAH;K  H+H7  H'&  Hq 3HS8HS@HSH3HK HtqHC0HH+HH;$  H    H=   r0  HAH;   H+H   H'   H 3HS HS(HS0HCHrEHHH=   r0   HAH;   H+H   H'   H蘬 3HC   H{HSrHH u  HxH\$0Hl$8Ht$@H _u~	 n~	 g~	 `~	 Y~	 R~	 K~	 D~	 =~	 6~	 /~	 (~	 !~	 ~	 H(p   ʧ HtH HHHtHHHHtHf@H(HHHWATAUAVAWH@H@HXHp LH3ۉ\$x8uE3I IB82uHHcHH|1(H~
I;~I+3LHt$(HL1HL-i
 Ht#HHPI;uH   Ht;|	 ҐHHcH|1 uHL1PHtH;ty	 HHcH|1 D$0u
      D1%  @t*H~!HHcHT1XHL1Hx	 tVHڅuVHHcHMIHL1Hry	 I;u0D  H~/HHcHT1XHL1Hlx	 u
Hջ   \$xHHcHHD1(    L-h
 Ht$p\$xLd$(HHcHHE38x	 x	 u
Ix	 I$HcHJL!HHt#HHPI;uH   Htz	 ҐHL\$@I[@IsHIA_A^A]A\_HHHWATAUAVAWH@H@HXHp DH3ۉ$   LHHHLc@ILHL%g
 Ht#HHPI;uH   HtGz	 ҐHHcH|1 uHL1PHtH;tw	 HHcH|1 D$0   H|1(H3HϋD1%  A   @t9fD  uH~*HHcHT1XHL1Hv	 ADމ$   HHHcHAHL1Hv	 ADމ$   u(H~#HHcHT1XHL1HQv	 ADHL%f
 Ht$p$   L|$(HHcHHD1(    HHcHHE3&v	 wv	 u
Iv	 IHcHJL9HHt#HHPI;uH   Htx	 ҐHH\$xH$   H@A_A^A]A\_HHHWATAUAVAWH@H@HXHp LH3ۉ\$xLbHLc@I|(H~
I;vI+3LHt$(ILHL-e
 Ht#HHPI;uH   Ht x	 ҐHHcH|1 uHL1PHtH;tt	 HHcH|1 D$0u
      D1%  @t6Ht,HHcHT1XHL1Ht	 u   \$x7Hυu.I~rM6HHcHMIHL1HAu	 I;t   +Ht*HHcHT1XHL1H9t	 uHՉ\$xHHcHHD1(    L-d
 Ht$p\$xL|$(HHcHHE3
t	 [t	 u
It	 IHcHJL9HHt#HHPI;uH   Htv	 ҐHL\$@I[@IsHIA_A^A]A\_@SH HHٲ
HcHHs	 Hs	 HPs	 HH [H\$Ht$H|$AVH HLHzHH;tNHH;t$HNHdHH

 %H H;uIVHNH;HHQSt	 H\$0Ht$8H|$@H A^H\$Hl$ AVH HLHBHH;   Ht$0HHH|$8H+3HHH;HGHt)HMs	 HHX
 sHH[H;uIFHMHs	 HHs	 H|$8Ht$0H\$@Hl$HH A^@USVWAVAWH$xH  HD$PH@
 H3HEpMMHHH   D$     H?q
 HD$`HMs	 D$    E3E3HT$hHL$`s	 HD$`HcHH]
 HD`HD$`HcHDxDD\   HL$hHHL$`HH
 JHHoHH%
 0HIUHAir	 HH>HUPHL$` HxrH H
v|	 HL$(3HL$0HL$8HD$@D$HHT$0HL$@s	 Hdi
 HD$(H` 
 HL$(謭 LSUVWAVH   ICHi?
 H3H$   MIHHH$   IC   IC    D$h A   Hh
 IK觼HD$`   HD$X    D$H A   H:
 HL$HxHCH+HLOL+IL;t%HD$0Lt$(HD$hHD$ LHT$HH訊  HD$`HrQHHL$HH=   r<tys	 HAH;ris	 H+HsYs	 H'vLs	 H HD$`   HD$X    D$H H$   HrQHHL$hH=   r<ts	 HAH;rr	 H+Hsr	 H'vr	 H襠 H$   H3% HĐ   A^_^][@USVWAVH$PH  HD$@H=
 H3H   ILHDD$8   D$0    Hm
 HD$PHMp	 D$0   E3E3HT$XHL$Pgp	 HD$PHcHHnZ
 HDPHD$PHcHxTL   HL$XH
 HL$PHH*HH`
 Hȋ0o	 HH.
 H   HL$PH   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@ݹHEx   HEp    E` A   H
 HM`貹HE@HD$ LM`LD$8IHH\$WH 	HHf/v\XH\$0H _\(XH\$0H _HL$UVWAVAWH0HD$ H\$pHHHrLrHL$hE3L9LyLyMt$HtHHHL;tIHHt3<o	 H|a  HLsHsHuH{H|$hL?LHt3o	 HHa  HHwHuH~H   H{(H|$hL?LHt3n	 Ha  HHwC< HH貙  HH\$pH0A_A^_^]H\$Hl$Ht$WH HcjHHH;it!H	[n	 t
H`  HH    Hk~LFHHI H\$0Hl$8Ht$@H _@SH0ID$     LHHIIE3HC   HHC    H 	HH0[HL$WH@HD$ H\$XHt$hHH3|$`HL$(HLc@ILHHt*HHPHH;uH   Ht4m	 Ґ3Hj	 D$0t/HHcHHLHZl	 u   |$`	H\$P|$`HHcHHE3i	 HHcHHLHHt*HHPH H;uH   Htl	 ҐHH\$XHt$hH@_HXHD$ HD$h    HT$h  uB3HD$8H&
 HD$0HJb
 HD$(H
 HD$@H
 HD$HHL$(+> HD$hHXHL$WH0HD$(H\$HHl$PHt$XIHH3ۉ\$ HA   HYHyrHHƈD$    : uH
HH<
 uIPHHu  ? t
HHÀ< uLHHtIE3HH貹HH\$HHl$PHt$XH0_@SH0: IHD$     uE3IIB<
 uLHyz  HC   HHC    H [HH0[HL$WH0HD$(H\$HHH3D$ HA   HAHyrHH  D$    HRH
t  IE3HHǸA
   Hڜ
 HbHH\$HH0_@SH0A8 ILD$     HuE3IIB<  uHIHC   HHC    H gHH0[@WH   HD$ H$  AHHH$   0  HX(H

 HH0x8HH$   ; HHL$(; HH HL$(褣 @SH   HD$PH_5
 H3HD$pHyrHHHT$`HIHHL$hH;tvD$     CըuHD$( D$,   HD$ HD$0HT$8HL$@HL$( ȋD$ -ut=   w2t=w2ɄuB3HD$8Hn
 HD$0H^
 HD$(HN
 HD$@HZ
 HD$HHL$(s: HL$pH3ŏ HĀ   [@SH   HH4
 H3H$   HyWD$PrL	LHYLD$PILL$pHH\$xILL$XH\$`0 u-HT$PHL$XO t9C,+<:wH     HrD$PH$   H3 HĐ   [m  H(LI3Mt`HQHrLLA< etGHrLLA< Et2HrLLA< 1|HrLLA< 9~
HI;rH(  @USVWATAVAWHl$H   HEH2
 H3HEMcIcHLHM3ۉ]ϋ

 eH%X      Hȋ
9M
 ~_H
D
  9
 uHHa
    HR
 <
 DCH
 H
*
 H
nQ	  H

 H HE   H]E A   H_
 HM趯HE   H]E A   HH
 HM華LOL+IAA;tLEHM  HEHrPHHMH=   r<tf	 HAH;rf	 H+Hsf	 H'vf	 HP HE   H]E HEHrPHHMH=   r<tDf	 HAH;r4f	 H+Hs$f	 H'vf	 H H?LIII_I_MtDHEt5HHHL;twEtHHHL;tZMMt3d	 I W  IMwIwH}LuIHMLuHEHEHEHEHEHEL}IHHH+HHH~)HH;}
H}HMLHHM IHMH3u HĐ   A_A^A\_^[]@USVWAVHl$H  HD$@H/
 H3HE IHH蘕  HE   E3LuDuEFH
 HM1HCDLEHHFHEHrPHHMH=   r<tYd	 HAH;rId	 H+Hs9d	 H'v,d	 H H{urH f/= waHE   LuE E3H
 HM耬HE   LuE E3H
 HM\HEHD$ LMHHc/ HHM覘  HT$PHv  HMb	 }    E   HL$`HL$0L\$XL\$8HD$0HT$8I;HMHMLD$PW IH~N   If/sEHIH;|II|LHH_  HMb	 HL$pb	 HL$Pa	 aHE   LuE E3H~
 HMOHE   LuE E3H~
 HM+HEHD$ LMHH2. HM H3Ո H  A^_^[]@SH LHHuHRAHH [HHRHcHHAHH [@USVWAVH$PH  HD$@H-
 H3H   ILHLD$8   D$0    H]]
 HD$PHM`	 D$0   E3E3HT$XHL$P_	 HD$PHcHHI
 HDPHD$PHcHxTL   HL$XH
 HL$PuHHHHГ
 [Hȋ^	 HH
 AH   HL$PP}H   H   HC   HEX   HEP    E@ : uE3IfD  IB< uHM@MHEx   HEp    E` A   H
 HM`"HE@HD$ LM`LD$8IH蔖  LSVWH   ICH\+
 H3H$   IHHIC   IC    D$h A   H&
 IK襨HD$`   HD$X    D$H A#   H
 HL$HvHCLKL;t%HD$0H|$(HD$hHD$ LHT$HHd  HD$`HrQHHL$HH=   r<t_	 HAH;ru_	 H+Hse_	 H'vX_	 H' HD$`   HD$X    D$H H$   HrQHHL$hH=   r<t_	 HAH;r^	 H+Hs^	 H'v^	 H豌 H$   H31 HĐ   _^[@UVWATAUAVAWH$@H  HD$8H$  H)
 H3H   MLL3ۉ\$0A   MPM;  EWɋHE~0MNHcI;}$IIIHf.z uHI;|AIIcI;  H\
 HD$PHY
 HD$`HM;\	 D$0   E3HT$hHL$P[	 HD$PHcHHU
 HDPHD$PHcHhTLHD$hHD$@HL$haY	 HiP
 HD$hH]Љ]H
 HL$`HHr
 }HIHH
 cHȍVZ	 HH-
 HHAWZ	 HH
 ,H   HL$PvH   H   HC   Hǅ      3H   @}p@8:uD
IIB8<uHMp;IcHcMINHHIHEh   H}`EP E3H^x
 HMPHEPHD$ LMpLII# H   H3裂 H$  H  A_A^A]A\_^]@USVWAVH$PH  HD$@H'
 H3H   ILHDD$8H   D$0    H\W
 HD$PHM
Z	 D$0   E3E3HT$XHL$PY	 HD$PHcHHC
 HDPHD$PHcHxTL   HL$XH
 HL$PtHHHHύ
 ZHHVW	 HH
 ?H   HL$PNwH   H   HC   HEX   HEP    E@ : uE3I@ IB< uHM@MHEx   HEp    E` A   H
 HM`"HE@HD$ LM`LD$8IHtH\$WH HIH%s	 tHHiHHr	 ZHW	 HHH\$0H _H%W	 H\$WH HIHs	 HH	HHs	 H%W	 HH3H\$0H _H%*W	 @SH H_v	 IHH9
 HH&v	 HV	 HHH [H%V	 H\$WH HIH-v	 THHIHHu	 :HeV	 HHsH\$0H _H%jV	 @SH H/	 IHH
 HH~	 HV	 HHH [H%V	 @SH Hǚ	 IHHI
 HH	 }HU	 HHH [H%U	 @SH H	 I;HH
 ,HHF	 HHU	 HHVH [H%RU	 @SH HW	 IHH
 HH~	 HT	 HHH [H%T	 HHHD$0D$    L

 L=
 3 2HHHHHD$0D$    L

 L
 3֦ 2HHHHHD$0D$    L

 L
 3薦 2HHHHHD$0D$    L
l
 L}
 3V 2HHHHHD$0D$    L
|
 L=
 3 2HHHHHD$0D$    L
,
 L
 3֥ 2HHHHHD$0D$    L
ԉ
 L
 3薥 2HHHHHD$0D$    L

 L}
 3V 2HHHHHD$0D$    L
t
 L=
 3 2HHHHHD$0D$    L
L
 L
 3֤ 2HHHHHD$0D$    L

 L
 3薤 2HHHHHD$0D$    L
\
 L}
 3V 2HHHHHD$0D$    L
|
 L=
 3 2HHN  L  HWATAUAVAWHPH@HXHhHpMLHIPIW I$ID$3HFH+HH   E3E3fWD$8HD$H    IU IHILD$8Ǔ  Hl$@LH\$8LIT$I*g  HtZHH
 HD$HH+HHH;wpHH=   r uXHCH;sHH+Hr8H'w+HHڀ HII HFH+HH;s(:R	 R	 R	 R	 R	 L\$PI[0Ik8Is@IA_A^A]A\_HUSVWATAUAVAWHH  Hǅ   )p)xD)@Hl
 H3H  LM0ILE8LHH  HEpy|upHz ui   t`HY	 H  3H  H  H	 HEpExH  HMpZP	 HH
 H  H H   HK
 HE@HM	 HEHHEPHEXH#N	 HE`HEhH<P
 HEH   4[  H  '[  H  l
   ~y   A   ~x DEHVXHzrHH   E3HH   HcHH   uHAPM	 H3L	 F|uH	 H   H$	 auH	 H   H+	 @uH	 H   H:	 u2H	 H   HA	 HHHM	 H   % H   H膭      H   HzrHA   H  ֢E3HH  HcHH  uHAPK	 H3K	 F|uH	 H  H	 auH	 H  H	 @uH	 H  H	 u2H	 H  H	 HuHHL	 H  	 H  HjHǅ     E3L  D   EFH	 H   臗HOB
 H@  H  HH  Hǅh     L`  DP  IE3H   HP  gH  HrSHH   H=   r<ttN	 HAH;rdN	 H+HsTN	 H'vGN	 H| L   HNHYHyrH	HA   I;LBMtH	  u1Hu+Klw H   LF8HV(HcHH      w HHD
 HH   WELuAEHUI
HSH
 HEWELuAN   D.DvDu~HH
N<
 ~|      HMHEHD$PHEHD$HHE@HD$@HEHD$8D$(|$ EEHIa  DGHUHMHD$ IH  薓  HOH:WH  Ht)L  L+IW  Hǅ      HUHtLEL+I載HDG
 N|  H   W  Hǅ         Utttt3      uMH   HD$PHEHD$HHE@HD$@HEHD$8T$0|$(|$ EEHI$  DU                        H   H$   HMH$   HM@HL$xHMHL$pD$hT$`|$XD$PL$HT$@\$8d$(|$ EEHIf  D                           H   H$   HUH$   HU@H$   HUHT$xD$pED$h|$`D$XL$PT$H\$@d$0L$(|$ EEHI˪  DHUH   XHM1HQH}LL+H	 HH}H}8HO HUrPw8HUHtLEL+IDH  HtL  L+I$H}~|  WE 3H}HM WEH}(   UN|tt
tu   +   E   E   EDD+   Du     3HMIHǅ     Hǅ      ƅ   A   H	 H  貑LEL+EIHU H+UHLML+M IIcHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   ~ LH  UH@  HD$`Lt$XHEHD$PHE@HD$HHEHD$@ED$8ED$0|$(|$ DMEHIڸ  D    PHM}HA
   H	 LuI贐IN A   H	 螐IN@A   H	 舐IN`A   H	 rI   A   H	 YHǅ     Hǅ      ƅ   A   H;	 H  #LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ L  H  H   0} LH  aT    D     z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIu  D'	                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIɻ  D;  z         H@  H$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D                       L@  L$   L$   LML$   LM@L$   LML$   $   $   $   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI6  D    H@  DMHIπ    upH$   L$   HEHD$xHE@HD$pHEHD$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ ES  D%              H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$hDD$`l$Xd$PED$HD$@ED$8|$0ED$(|$ E  Dq  d  PHMBA
   H	 LuIIN A
   H	 IN@A   Hz	 Hǅ     Hǅ      ƅp   A   Hw	 Hp  跊LEL+EIHU I+HLML+M IHcEHcMLU0LT$@HD$8HL$0LD$(HT$ Lp  H  H   w LHp  N          |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D  |         H@  H$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHI  D4                       L@  L$   L$   LEL$   LE@L$   LEL$   $   $   $   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$ DMEHIe  DG  >  H@  DMEHIπ    tnH$   L$   HEHD$xHE@HD$pHEHD$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$   D               H$   L$   HEH$   HE@H$   HEH$   $   L$xT$p\$ht$`l$Xd$PED$HD$@ED$8|$0ED$(|$   DLupEWA(WEHE    DEHUH+UHLEHMD  HMH+M HLM L+MILɋ   ~gfn
 ^I  (Y03LEHML+IMt/LN    L+@ I	(BYHHII;rI   H}8HO@B  G HOpHO2  H   HM?HD$ IH    HOHFH  Ht)L  L+I?yW  Hǅ      H   HtL0  L+I
yH  HU
B  H   H  UHǅ     Hǅ      ƅ   A   E3H	 H   %~HEHtTA   LH	 H   }LEI+LH  H   GHH  HH  WHD   D   A   E3H-	 H   }H  HHEL@A   H	 H   j}HLLEH  H   FHH  =UH  GH   H  <7	 A   LH	 H    }HL@A   H	 H   |LLGH   H   vFHH  fH   9GH   H  6	 Hx  THx  7	 H}8H  H  H;tIE3H  aIP  HW  Hǅ      MX  H  ]w HU H W   Hǅ0      LEH   w LM LEH(  H   L  H  H  >  H  H   <:HOXHUp/:MtI   IH   Ht&H(  HA  L0  L+IHsH  Ht=H  HO  H  H+H*HHLI?LHRbH  EH   EHUHtLEL+I^uH}Ht HU H  LE(L+IHrH} HtHUHo  LEL+IHrH}DuN|d     E   EttttE3D      D      E   E   E   EHǅ     Hǅ      ƅp   A   H	 Hp  H+}HEHcHE0HD$@3HD$8HL$0H|$(HD$ DHLp  H  H   l HHEpHp  	DH@  EEHIH$   H$   HEH$   HE@HD$xED$hED$`ED$XED$PDD$HEt$@Dd$8D$0ED$(|$    up    DW   E3L0  L   H   H   s H(  H   H+I*IHHHH?HHH  >EL  L  M+IMt ff     HHKIHM;rH}8H  H   ;  H  HU6H  H  ;HOpH4+  HU HM'HD$ IHM{  HOHy?HUHtLEL+I0rWELuHU HtLEL+IrHMpHtH   H  HtL  L+IqH   Ht:H(  HL  H0  H+IHHLI?LHV^E3H}HtH   HHUHtLEL+IaqWELuH5#
 HuH]HtHH  LEL+IHnHK'
 H@  HP  AH@  Hx  MHx  1	 H  +)  H   )  AH  H3Y L$  A(sA({E(CIA_A^A]A\_^[]HATAVAWHpH@HXHpHx )pMMLHHRI+HHHk'3fD  H;_s^I4H
 HHH
 H;
 r
   :HH$   Ht
(ҙHHHD$8HHMLD$8H$   H$  H$   pH      ?HHH=R
 H
k
 H9
\
 t	H.
 $HH+"
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HIv;HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v1	 H    H=   r<tq1	 HAH;ra1	 H+HsQ1	 H'vD1	 H_ =u (L\$pI[ Is0I{8(t$`IA_A^A\HATAVAWHpH@HXHpHx )pMMLHHRI+HHH%3fD  H;_s^I4Hk
 HHH]
 H;N
 r
   HH$   Ht
(肗HHHD$8HHMLD$8H$   H$  H$   pH      ?HHH=
 H

 H9

 t	H
 $HH+
 HH+AH    HH+@ H;sHHHPHT$@H+T$8HI&9HD$@HL$8H+HHt5HM$f     HHHIHHD$@HL$8H+HH;rHttHD$HH+HHH;v=/	 H    H=   r<t!/	 HAH;r/	 H+Hs/	 H'v.	 H\ r (L\$pI[ Is0I{8(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
`
 +	 HL$8.<  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   `HHL$@LD$8H$   Ht(HHHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$8;  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8:  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
3^
 )	 H
%^
 )	 MLD$8H$   I  H p9p HL$8Ht{HD$HH+HH;v,	 H    H=   r<t+	 HAH;r+	 H+Hs+	 H'v+	 HY WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HLH ATAVAWHpH@HXHpHx)pMLLW@H@    HQHHtH;vH
\
 '	 HL$88  3I9~  HL$@LD$8     I4H
 HHH
 H;
 r   0HHL$@LD$8H$   Ht(H軑HHL$@LD$83H$   H$   H;   H$   L;   H$   I+HLL$HI;ufIH+HHsVI+HHH+H   HQM+IIHHH+IE3I;LCL;ICHL$87  HL$@LD$8H   IHtLL$HI;ubIH+HHsRI+HHH+HrvHQM+IIHHH+IE3I;LCL;ICHL$8]7  HL$@LD$8Ht
HHL$@LD$8HHL$@HI;~s!JH
[
 %	 H
Z
 %	 MLD$8H$   I  H p	m HL$8Ht{HD$HH+HH;v(	 H    H=   r<t(	 HAH;r(	 H+Hs(	 H'v(	 HeV WL$8HD$H    (L\$pI[ Is(I{0(t$`IA_A^A\HWATAUAVAWH  HǀHXHp)p)xD)@D)HD)PH$ H3H$H  ILD$ LHL$(H$  3H_1HFH+HHurH/	 H$  3H$  H$  H\
 H$  Ƅ$  H$  H$  &	 H
 H$  H\
 H$  ~ HD	DL$xHwrH.	 H$  3H$  H$  H\
 H$  Ƅ$  H$  H$  z%	 H
 H$  H[
 H$   A   DQD$   WD$@E3AH\$PMcN`LL$8ELt$@M%  IHT$H HFH+HL;  IIH4t$0HD$0H;   HD$0L;   Ht$0I+HH;uyHH+HHsiI+HIH+H	  HI+HHHIH+HMH;LCL;ICHL$@PH\$PHT$HLt$@ILL$8HtIHHt$    H;uyHH+HHsiI+HIH+H   HI+HHHIH+HMH;LCL;ICHL$@輊H\$PHT$HLt$@ILL$8Ht2HHT$HIM;   {H
V
 !	 H
V
 !	 H,	 H$  3H$  H$  HY
 H$  Ƅ$  H$  H$  #	 H
 H$  H+Y
 H$    HFH+HL;rrH,	 H$  3H$  H$  HY
 H$  Ƅ$  H$  H$  "	 H0
 H$  HX
 H$    IIHs (EWAX|$8WL$XILd$hHD$(LcP,L$   MLd$pLl$XMN  HT$`LD$ @ I@I+ HL;  IIL$  I 4t$0HD$0H;   HD$0L;   L|$0M+IH;   HH+HHssI+HHHH+H   HI+HHHH+HMH;LCL;ICHL$X=Ht$hHT$`Ll$XLD$ LL$pL$   HtKD HL$     H;   HH+HHssI+HHHH+H   HI+HHHH+HMH;LCL;ICHL$X藇Ht$hHT$`Ll$XLD$ LL$pL$   Ht2HHT$`ILL$pM;   NH
S
 y	 H
S
 k	 Hc)	 H$  3H$  H$  HrV
 H$  Ƅ$  H$  H$  	 H
 H$  HU
 H$  a  HOHD$xH;   LHD$xL;   L|$xM+ILOI;ukIH+HHs[I+HIIH+HsH
R
 	 HQM+IIHL+IIM;HCH;HCHHOHHtJHA   L|$ *A   L|$ H;OuAH_HGHtDHGHOH$   H;sUHH$   H;wEH$   H+HH$  H;OuIHU_H$  HOHHt(HHH;OuIH'_HGHtDHGEHD$(D9``~#L IcIH(AE;}`|Ll$XHGHL$8H;sAHHT$8H;w4L|$8L+IH;Gu
   H^HOHHt)JH H;Gu
   H^HGHt8HGEHD$(D9`,~'LIcH    IH'AE;~,|Lt$@$   u8MtI+HLI	\M  I+HLI[  W$   L$   &
    HǄ$      L$  Ƅ$   A   HM
 H$  fHǄ$     L$  Ƅ$   A   HO
 H$  fL|$(EG`EyH$  H$  )H$  ;+H$  -+D$  IcW`W$  L$  L$  H$  V^IH$  L$  I+HH      HtIHH;rIHt     IHH;r=
 @      HD$ HL$(;A`W  
    HǄ$@     L$8  Ƅ$(   A   HRL
 H$(  eHǄ$      L$  Ƅ$   A   H7L
 H$  VeH\$ LcHL$(HL$(  I  LL$  IHL$@  A7Y0WHǄ$      L$  Ƅ$   A   H#M
 H$  dL$  IH$  q  0H$  `)H$  R)H$(  D)H\$ H\$PLt$@L$  h
    D;a`}IcIH$AHL$(ြ$       MtL$  M+IIXH$   3Ht#DL+IXW$   H$   Mt I+HLIyXWD$XH|$hMt I+HLITXWD$@H|$PDMtL$  M+II(XH$   H3H+HLXH$H  H3 A L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_LWH`ICI[IsHi H3HD$XHIK3t$ H1HqHqD$    HHD$P   Ht$H@t$8DFHw	 HL$8bHD$8H;CsZHHL$8H;wMH|$8H+HCH9CuVHWHH;HKHthHA   HqHyrHHH@HCH9Cu
   H<WHKHt(HA   HqHyrHHHT$8  gHC HD$PHrQHHL$8H=   r<t(	 HAH;r	 H+Hs	 H'v	 HF HHL$XH3J? H\$xH$   H`_HL$USVWATAVAWHH   HEHHE3D}WEL}HUH:L?LLE   HuHI?LuI;   HHMHHML HHHMHtEHEH+HI;w]H    H=   r uAHAH;s1H+Hr!H'wHE HI;{	 	 	 	 	 WEL}HEI*H;GseHHMH;wYHMH+IHHHHH?HHGH9Gu
   HAHOHMPH[HHHMXHt2HGH9Gu
   HAHOHMPHMXHt
HUbHGHMHtiHEH+HI;v	 H    H=   r<t	 HAH;r	 H+Hs	 H'v	 H[D H   IH6  HMH+IHHHH?HH
H;v>	 HRHH=   r=@t!	 HFH;r	 H+Hs	 H'v	 HHC HHĀ   A_A^A\_^[]H\$Ht$ WAVAWH LHH  HA3HL$@|$@H;s?HHL$@H;w2H|$@H+HH;Cu
   HoBHSHt(H
H;Cu
   HIBHCHt8HCI*INII+   HHHH?HH;   Hl$H   @      IA   HL(HT(H+HHtDHIHuHHT$@HC|A|$@H;s<HT$@H;w2H|$@H+HH;Cu
   H}AHSHt(H
H;Cu
   HWAHCHt8HCIINHI+HHHHH?HH;,Hl$HH\$PHt$XH A_A^_@WHpHD$ H$   H H3HD$hHH
f.
p
 zu	P  HD$`   HD$X    D$H A   H?G
 HL$H\HD$@   HD$8    D$( A   H(G
 HL$([LLHT$HHL$(  HD$@HrQHHL$(H=   r<t	 HAH;r		 H+Hs	 H'v	 H@ HD$@   HD$8    D$( HD$`HrQHHL$HH=   r<t	 HAH;r	 H+Hs	 H'vy	 HH@ \qb HL$hH38 H$   Hp_H\$Ht$WH IHHH;t HH HHH;uH\$0HHt$8H _H\$Ht$WH IHHH;t' H;tIE3HH[H H H;uH\$0HHt$8H _@UVWH@HD$ H\$pH3HL$`
	 H5b
 Ht$hH

	 x	 HHEH;xsHHHH   3ۀx$ tz
	 H;xs
H@HHulHtHbHHL$h8  Hu13HD$8H,
 HD$0H
 HD$(H HL$(I H\$hH
 HHRHx6 HL$`	 HH\$pH@_^]@WH@HD$ H\$`Ht$hH3HL$P	 HG
 HD$XH
	 e
	 HHFH;xsHHHH   3ۀx$ tg	 H;xs
H@HHumH\$XHucHHL$X	 Hu13HD$8H+
 HD$0H
 HD$(H HL$(H H\$XH
 HHPHd5 HL$P	 HH\$`Ht$hH@_H\$WHPHw H3HD$@HHD$8   HL$ HD$0    ID$  E3XHLD$ HWHx HHD$8H+HHrQHL$ HH=   r<t	 HAH;r	 H+Hs	 H'v	 H< HHL$@H35 H\$`HP_H(Hu3H(HH;w*H\$ H    Hs
	 HuHuH\$ H(vv@SVAVH L1HI^{ umHl$@HjH|$HL|$PLzHK IrHHHyHyrH	H?LH;LBMt0] t'y*H[{ tL|$PH|$HHl$@IH A^^[H;rLHH\$Ht$WH HHHELHHR  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _H\$Ht$WH HHHELHHR  HCHGHFHHJy uMHx u HH x tH
HHJHAx u
HH@x tHJH\$0Ht$8H _H\$0HHHt$8H@H _@SH H  H 
 HCPH [HL$SH0HD$ HD$P    EtH^	 HA@H	 HAPD$P   J   H{
 HH&
 HCHC@HcHHv
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH	 HHQ3HHBHK		 H]
 HH{3HHDH^H\$HH
 HHOHKHtHPHGHCHGHCG C H	 HH 	
 HHH\$PHt$XH0_H	 HH@SH HHI0		 HK 		 HH [H%		 H!	 H@SH HH   H`HcPH
 HHHHHcPDHDD#Hhz	 HH [H%+	 @WH0HD$ H\$HHl$PHt$XHHًBAHHH;tIE3SHo(Hs(H;t<HHRH]HH@HH HH@HF    DD$@HHHo8Hs8H;t<HHRHHH@HH HH@HF    DD$@HHHGHHCHGPCPHWXHKXH;tIE3RGxCxGyCyG|C|H   H   H;tIE3R                                                  HH\$HHl$PHt$XH0_H\$WH H  H
	 HGPt
X   H5 HH\$0H _@WH0HD$ H\$@HH	 HHN
 HAHI HtHP tHC     HX	 HHK	 @t
@   Hh5 HH\$@H0_H	HtH   H @UVWAVAWH$@H  HD$8H$  H9 H3H   IILHE3D|$0AA fAn	ff/rHHrY  H}
 HD$PHi
 HD$`HM	 D$0   E3HT$hHL$P	 HD$PHcHH	 HDPHD$PHcHhTLHD$hHD$@HL$h@	 HH	 HD$hL}D}H:
 HL$`jHL$`	 H   HL$P, H   H   HC   HEh   L}`EP : uMIfD  IB< uHMPmNHǅ      L   Ep A   H9
 HMp@NHEPHD$ LMpLIHd  H   H3+ H$  H  A_A^_^]@UVWAVAWH$@H  HD$8H$  H9 H3H   IILHE3D|$0AA	A;|HHrU  H
 HD$PHu 
 HD$`HM&	 D$0   E3HT$hHL$P	 HD$PHcHH		 HDPHD$PHcHhTLHD$hHD$@HL$hL 	 HT	 HD$hL}D}H(8
 HL$`vHL$`	 H   HL$P8H   H   HC   HEh   L}`EP : uMIfIB< uHMP}LHǅ      L   Ep A   H7
 HMpPLHEPHD$ LMpLIH  H   H3) H$  H  A_A^_^]@UVWH   HD$8H$   HU H3H$   IHH3IHIPHHH   M II           HcAD$0HD$0I#I;wHHHH;r   HD$X   HD$P    D$@ A   H6
 HL$@2KHD$x   HD$p    D$` A   Hm6
 HL$`KHD$@HD$(HD$`HD$ LLHH  H$   H3( H$   HĐ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   III       HcD$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   Hl5
 HL$@IHD$x   HD$p    D$` A   H55
 HL$`IHD$@HD$(HD$`HD$ LLHHe  H$   H3d' H$   HĐ   _^]@SVWH   HD$0H H3HD$xIHHA8 |HD$P   HD$H    D$8 A   H4
 HL$8 IHD$p   HD$h    D$X A   H[4
 HL$XHHD$8HD$ LL$XLHHS  HL$xH3& HĀ   _^[@UVWH   HD$0H$   H H3HD$xIHH3IHH   IW    Hcf/v
HH;r   HD$P   HD$H    D$8 A   H3
 HL$8HHD$p   HD$h    D$X A   HR3
 HL$XGHD$8HD$(HD$XHD$ LLHH肿  HL$xH3% H$   HĀ   _^]@UVWH   HD$8H$   H H3H$   IHH3IHH   II      @ f     HcD$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   H2
 HL$@FHD$x   HD$p    D$` A   H%2
 HL$`FHD$@HD$(HD$`HD$ LLHHU  H$   H3T$ H$   HĐ   _^]@SH0HD$ HH'	 HH5	 HAHI HtHP tHC     H?	 HHKH0[H%d @SVWH   HD$8Hm H3H$   IHHA D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   H0
 HL$@EHD$x   HD$p    D$` A   H0
 HL$`XEHD$@HD$ LL$`LHHz  H$   H3" HĐ   _^[LH   ICAC    HQH	 ICH8	 ICAC   IKH	 HD$(H
 HD$@HD$hHcHH	 HDhHD$hHcHDd    H HL$(5 @SH0HD$ HٹX   |% HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH	 HH%
 HAHA@HcPH	 HD
@HA@HcPDBDD
<HE	 HH	 HAHI HtHP tHC     H	 HHKH0[H% @SH0HD$ HH	 HHE	 HAHI HtHP tHC     HO	 HHKH0[H%t HQHH+HHtH    H+HQHL$AWH@HD$0H\$XHt$`H|$hHHH;l  L
LRM;uHQH	ַ  HH  II+I*IHHHHH?HLHOI+IHLIIH?LI;wFII薻  HWHj  HNH+IHHHH?HHRHHHO   HOI+IHHHH?HH;w%K[IHI(  LGHVHK pMt/HWI  HOH+IHHLI?LH"HNH+IHHHH?HH$tLHVHLK HGHGHH\$XHt$`H|$hH@A_HH\$Hl$Ht$WH0HIHIHHH/H+HH;s
H+HHGgH;sbH;s H;wH+Hv7HH+HH4H+H[7HOHHLH+HH+菶  HGH+HH+HH_H\$@Hl$HHt$PH0_HWH   H@HXHp HH@    H9 u}0   P! HH$   LCMu	Hc
 
IP(HuIP0HL$(K HǄ$      3Hz H	 HHH4  H>HL$(    L$   I[Is(I_H\$Ht$WH HqHHH;wAHAH;t8HvH
(
 n H;s/LHjHtH{HsrH3 H\$0Ht$8H _HsH;LƲLBz8HuHyHrHHt$8 H\$0H _̉T$HL$WH0HD$ H\$XHD$H    Hr	 HHX	 HAH   W D$H   H_E3HH HHcHH	 H9HHcHHT9H\$PH H1	 HC| Cq Hu Hǃ       H
 HCtHCh    HH\$XH0_@WH0HD$ H\$@HH	 HH	 HAHI HtHP tHC     H HHK @t
@   H" HH\$@H0_H\$WH HHHUt
  H" HH\$0H _@SH HH	 HKH [H% LHXICLI@I+ HHQH;rQH IC3ICICH)
 ICD$0ISIK H8	 HD$8H(
 HL$8  HBHAI HXDD$HL$WH0HD$ H\$HHt$XHH3t$PH#	 HA@H	 HAPD$P   H?	 HHOHA
 HHG@HcPH7	 HD:@HG@HcPDBDD:<HSHHD!=HH\$HHt$XH0_H\$Hl$Ht$WH HAIHAIHHH;t4H	 HtHLHHsH{H    HsH{HqHyH\$0Hl$8Ht$@H _H(LILHQIH+HHs`H	IH+IHH+HsH
*$
  L+HI3IHL+IM;HCH;HCIH(   H(H\$Hl$Ht$WH0HH!UHSLHH蟷 HH{H+HHtLCL+I.HHl$HHCHHCH3H\$@Ht$PH0_H\$Hl$VH0IIHMt]HQHrHHH;rFHrH	HKH;v4HrHHH+Ht$ LLH  H\$HHl$PH0^LCIHH;wH
"
  H|$@K<H   HvH
"
  H9{s#HHbdH   HCHr%H#HuH{H{rH@8bH ZHHrHHLCMt
H0 H{rHHHtLH3@ H{H{rHH8 H|$@HH\$HHl$PH0^̀y t
H	H%( HWAVAWH   HD$(HXHp H H3H$   LLHL$ H HT$0I 3IFIF IF(HT$`I H
o
   IFI HHHHǀ<8 uHǺ   Hs HHu HHtHRHvHuIN I- HHÀ< uHú   H  HHuZ HHtff     HIHHuIV(fAF.,H$   H3 L$   I[0Is8IA_A^_H\$Lt$ AWH I@MMHI;sH
O 
  LAI+H|$8H|$PH;HGIHH;wH
 
  Ht$0I48H  HvH

  H9qs HaH   HCHr+H)HuHqHyrH@0   H    HHrHHLCMt
H8 I;u>HKI?MIDHrHHHrHHHt8HL *I~rM6H{rHHHtK>L= H{HsrHH0 Ht$0HH\$@H|$8Lt$HH A_@SH0HD$     HH HH0[@SH HHHSH
Q H3H
HJHH 3HC HC(HC0H	 C8HH	 HCHH [@SH0HD$      HH0[LL$ LD$HT$VWAVHPHD$HH\$pIHII+HH>  LQLAII+HH;   H	L+IHHI+H;sH

 c I4L+IIHH+I3I;HCH;HCHt$@HSLHD$8HD$0LHT$xHH HD$0LH$   H$   D HD$0LHWHL$xH HWHHH+HHHt藥  HLGL+I%HIHwHIH_L7%IHND HHWLHL$xX H_H\$pHPA^_^@SUVWH  HD$8H H3H$  IIHHI@I+ HL;A  HL$@H' 
 HL$PmlHH HH
 RlHH
 ClHH9
 4lHH
 %lH$  HL$@H$  H$  HC$  HǄ$X     3H$P  @$@  @8:uD
IIB8<uH$@  &2HǄ$x     H$p  Ƅ$`   A   H\
 H$`  1HCH+HHD$0H$@  HD$ L$`  LD$0HHɠ H$  H3x Hĸ  _^][@USVWATAUAVAWH$H  HD$@Hܳ H3H  IHLLL$8LP  LX  L`  3ۉ\$0H*	 HD$PHM D$0   E3E3HT$XHL$P HD$PHcHH	 HDPHD$PHcHDxDDLSHL$X>HHL$PvnHHknH  HL$PJH	 HE@H   A D$0   E3E3HUHHM@ HE@HcHH	 HD
@HE@HcHDxDD
<SHMHO>H+
 HM@iHImHImHH
 iHI HH
 niH  HM@~H  H  HC  HǅH     H@  0  8uDIIB< uH0  z/Hǅh     H`  ƅP   A   H
 HP  G/H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  .H0  HD$ LP  LD$8Hp  Iݝ Hx)t$`()|$PD)D$@D
 D)L$0D
a
 fD/D)T$ EWA(r`A(\(5 (\f/

 vAXfA.zu 
  !      =
 Y(5 ^fA.ztf/5
 r
(豩 O
 f/vAXA(f/^XwfD/vfA(^AX\fD/w(Ъ X((t$`(|$PD(D$@D(L$0D(T$ Hx@USVWAVAWH$xH  HD$PHЯ H3HEpMMHHH   D$     H/	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$h:HHL$`yjHH 
 :fHH_jHH
  fHIEjHAY HH.jHUPHL$` HxrH H
f HL$(3HL$0HL$8HD$@D$HHT$0HL$@ H	 HD$(Hv HL$( @SH`W)t$Pf/D)D$0D(   u+DW
 3A(Wݎ
 (t$PD(D$0H`[l
 fA/DW
 A(v(
!
 \((t$PD(D$0H`[3bX
 (t$PD(D$0H`[5
 fA/)|$@D)L$ D
x
 !  
 fA/vTfD.z  d[
 eH%X      HЋ9U{
   %w
 AYDY9
 AX  [
 eH%X      HЋ9w
 
  A(AY(Y((Y%:s
 (Y
om
 Ys
 X%s
 X
Gm
 Xr
 YYY7m
 X%r
 X
m
 YXm
 XYX^X%s
 AY  3t

 )
 fA/  7Z
 eH%X   =H
 fA/   HЋ   9u
   A(A(\AYW
 (Y0 ((Yj
 (Yj
 (Y
*g
 Xj
 Xj
 A^X
f
 YYYXj
 X
f
 YYX(Yf
 X
f
 XJj
 Xf
 YXf
 YX^Xr
 Y  y
 fA/   9(v
 '  A(A(\AYW
 (Y/ ((Yg
 (Yf
 (Y
s
 Xf
 Xf
 A^X
ms
 YYYXf
 X
As
 YYX(YBs
 Xrf
 X"s
 YXX
s
 ^X
 Y  Հ
 fA/   9s
   A(A(\5
 AY(W
 Y. ((Yh
 (Yh
 (Y
"l
 Xh
 Xh
 A^X
k
 YYYXih
 X
k
 YYX(Yk
 X:h
 Xk
 YXX
k
 ^X~
 Y   9v
 Z  A(A(A^AY(YWى
 . ((Yvl
 (Ycl
 (Y
l
 XHl
 X8l
 A^X
l
 YYYXl
 Xl
 X
ol
 YYYXk
 X
Cl
 X(Y\l
 XDl
 YX(l
 YX^X}
 Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
.v
  ="v
 |
 H

v
 r
  H
r
 K =r
 ({
 H
r
 (
݈
 m
 
 n
 (o
 (h
  |
 
m
 (
 h
 
g
 z qH
q
  =q
 V(9
 H
p
 (
ˁ
 ,f
 (
 >f
 (
 
 f
 (
q
 bb
 R{
 
Cb
 (
Ԁ
 db
 
Mb
  H
q
 ; =q
 (
 H
q
 (
̀
 b
 (
 
b
 (
 b
 (
 
4o
 (
%
 6o
 
?o
 n [H
o
  =o
 .(-
 H
o
 (

 d
 (A
 
d
 (
C
 d
 (
 
.h
 (
W
 0h
 
9h
  H
4s
 ? =(s
 (
 H
s
 (
 h
 (
 h
 ~
 h
 (
 
h
 (
'
 0i
 0|
 
i
 (
j
 2i
 
i
 R @USVWATAUAVAWH$H  HD$@H, H3H  IHLLL$8LP  LX  L`  3ۉ\$0Hz	 HD$PHM+ D$0   E3E3HT$XHL$P HD$PHcHH	 HDPHD$PHcHDxDDLSHL$X40HHL$P_HH_H  HL$PH	 HE@H    D$0   E3E3HUHHM@\ HE@HcHHd	 HD
@HE@HcHDxDD
<SHMH/H{
 HM@ZHI#_HI_HHN
 ZHI HH
 ZH  HM@H  H  HC  HǅH     H@  0  8uDIIB< uH0   Hǅh     H`  ƅP   A   Ho
 HP   H  H  HC  Hǅ     H  ƅp   : t
HHÀ< uLHp  E H0  HD$ LP  LD$8Hp  I
  @USVWAVAWH$xH  HD$PH` H3HEpIMHHL   D$     H	 HD$`HMp D$    E3E3HT$hHL$`9 HD$`HcHH@	 HD`HD$`HcHDxDD\   HL$hw-HHL$`	]HH	 XHH\HH	 XHH\IHuH	 HXIH IH\HUPHL$`HxrH H
 HL$(3HL$0HL$8HD$@D$HHT$0HL$@x H	 HD$(Hh HL$( DD$USVWAUAWHl$H   LjLy3HHM;otI Mt
III7L$   L$   MoI  LsHLGH[HELuM;uH9_taMt"HtHHHL;  HGLMIL;tH' Mt
IbHH7LwH_HGHMLHEHMHMHMHMwLELOLHMHIH}HH+HHHH~"fD  HE(A)HH;}LEMHMXK HIH HHGHGHtHl    Hu
 HUHUHUHUHUwHUHG   HGHEHG   LGHLEHMIH}HH+HHHHH~*@ ff     f)HH;}EHMHM
 w8  LsHH]oH[Ht;MtHHIH;  HtMtHHIH;  HGLHGM)$   L;tH? Mt
IzHH7LEwH_HUoLwHJx H}HEHHMLwH]LuHEvP W(f.z
u5s
 HEuHEHMHEH}oHEHEwHEHEoHEH]LuH]Lu辷 IUHO(LG(IH HW(H|$ I聟 G8HEIHEHEHEHEwHEuHMMGIL}HH+HHH~'((ffY)HH;}uHMHHM\ ($   L$   HL$   fG<Hĸ   A_A]_^[]F:@:::@SH HHHSH
! H3H
HJHH 3HC HC(HC0H	 C8HHE HCHH [LHXIC3ICH	 ICH	 ICH3
 ICH3 ICIK @USVWH$HH  HD$@Hě H3H   IIHT$8D$0    H&	 HD$PHM D$0   E3E3HT$XHL$P HD$PHcHH	 HDPHD$PHcHDxDDL   HL$X&H
 HL$P<RHHaVHH
 "RHHV HHd
 RH   HL$PH   H   HC   HEX   HEP    E@ : uE3IIB< uHM@HEx   HEp    E` A   H	 HM`HE@HD$ LM`LD$8HH
g
 <Y@UVWATAUAVAWH$0H  HD$XH$(  H H3H  IH\$@HHT$8HL$HE3Dd$0anLKI  EM  
Oz
 m
     M]MM;}UHN    IIIHIIIL@ f     A \Tf/rIHMM;|MM;  H	 HD$`HMk D$0   E3E3HT$hHL$`4 HD$`HcHH;	 HD`HD$`HcHxT\HD$hHD$PHL$h H	 HD$hLeE   H 
 HL$`OHHSHH 
 OHIU HHd	 OHIWz HH	 cOH  HL$`rH	 HEPH   i D$0   E3E3HUXHMP4 HEPHcHH<	 HD
PHEPHcHxT
LHEXHD$PHMX H	 HEXL   ǅ      H;H[IIH	 HMPNHHT$8RHH	 NHIW HHT	 oNHIUj HH	 SNH} H  HMPUH  H  HC  HǅX     LP  ƅ@   : uMIfD  IB< uH@  JH  H  HC  Hǅx     Lp  ƅ`   : tIIB<" uMH`  HD$@L H@IIMH@  HD$ L`  HT$8HL$H  H  H3} H$(  H  A_A^A]A\_^]HL$WAVAWH0HD$(H\$XHl$`Ht$hHHE3D|$ HrLrL9LyLyMt$HtHHHL;t13IHHt3 HԻHLwHwAH9s~cMHKf     EMH~:D  LHIHIIHOIIHAIHKIcH;|IHcH;C|HH\$XHl$`Ht$hH0A_A^_@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     H	 HD$`HM D$    E3E3HT$hHL$` HD$`HcHH	 HD`HD$`HcHDxDD\   HL$hHHL$`iOHH	 *KHHOOHH	 KHI5OHI HHOHUPHL$` HxrH H
V HL$(3HL$0HL$8HD$@D$HHT$0HL$@ HD	 HD$(H@T HL$( HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEH	 HEL%`	 LeH	 HEHR	 HEL5ǻ	 LuD$    L-D	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH= HE3HEHEHUHM Ha	 HD$0HU	 HEHEHcHH
	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP HM	 HD$@HRM	 HD$HE   
t?
 eH%X   A   HȾ   A9Z
 Z  H
Z
  =Z
 A  NW LHEwH	 IF@H	 IFPD$    HT$0IE  H	 IH	 IF(IF@HcHH	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMw<o HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHMEM\
 fsfH~HtBHMH
7  H
vY
  L5	 \
 X\
 fsfH~HtpHŲ	 HD$0H	 HEHEHcHHn	 HD
HEHcHQT
Ld$0H> H]HMh Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HM- LmHMHtHR H[
 H$H  H   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$H  E3D|$ L}WfEωM3HEHc	 HEL%	 LeH	 HEH	 HEL5w	 LuD$    L-	 Ll$0L|$8MtIAPMHEHD$@HEHD$HMH HE3HEHEHUHM H	 HD$0H	 HEHEHcHHҰ	 HD
HEHcHQT
IH]oHMHt>HHUgP(HH]oHt
HHPHMgHtHP HMgIEHMgHEHD$HEEHEHD$@HL$8HtHP H\$8Ht
HHPHt
HHP HJ	 HD$@H"J	 HD$HE   
$;
 eH%X   A   HȾ   A9rX
 Z  H
eX
 X =YX
 A  NW LHEwHA	 IF@H	 IFPD$    HT$0Iţ  HV	 IH	 IF(IF@HcHHa	 JD1@IF@HcHF|1<IF@Hc@H@IHEL}IHMwLk HUHHMHH]wHt=C;u2HHP{;u LI@H
H;HuAАMIHMYEmZ
 fsfH~HtBHMH
׬ z H
W
  L5	 'Z
 0Y
 fsfH~HtpH-	 HD$0HY	 HEHEHcHH6	 HD
HEHcHQT
Ld$0H H]HM Ll$0HL$8HtHP HL$8IEHL$8LuLeH]HMݾ LmHMHtHR HrX
 H$H  H   A_A^A]A\_^]@UVWATAUAVAWH$pH  HD$HH$  H H3H   MHHHL$(3Dt$ IPIy  IIFHCH+HsHI聾[  WD$0Ht$@HHM`肯HT$0H蕐 L|$0ILd$8M;  H	 H
	 HL$`HT$pHM- ADl$ E3HT$xHL$` HD$`HcHH	 HD`HD$`HcHhT\HD$xHD$PHL$xR HZ	 HD$xHuuHHL$pDHH	 r@HsH+3H3Ht(HHL$p HH	 ?@HH;rHHL$pf HH	 @HU`HL$`HIVH;   IH;wxH+MNI;ucIH+HHsSH+HIIH+H\  HL+IIHIH+IE3I;LCL;ICIR/HI>oMNI;ufIH+HHsVIH+HIIH+H   HL+IIHIH+IE3I;LCL;ICI.IvHtrHF   3HNH~rHHƈHsLGItHH
 3	HHHHGHFHGHFHG   HHOrH? IF HM`HMHM] HI;t(H|$(39H
	 Ӹ H
	 Ÿ Mt6II|t  HL$@I+H*HHLI?LIH   H32 H$  HĐ  A_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   H H3HELHMgLuH   L   L      AA+iA+ȉMu
t
MuE     AA+iD+DEuEtADEEuE   AH2HHMHHMWE3H]Ll$8H|$0\$(L$ LMMHHMW HE   H]]DCHA	 HMHHUHP HEHrPHHMH=   r<t( HAH;r H+Hs H'v H L|$8H|$0Lt$(EwD$ ]oLEHUHۡ HUHt LEL+IWEHE    HUHtLEL+IHMH3 H$   Hİ   A_A^A]A\_^]HL$SHpHD$HH3D$@WD$PHD$`HHAHAD$@   D$0D$(HL$ L$   H蔐HT$PHtLD$`L+IXHHp[HSVWATAUAVAWH  Hǀ)p)xD)@D)HD)xH H3H$   HLH$   $  H$  HD$hL$   L$   H$  L$  Ld$p   AA+iA+A   ADʉL$`  AA+iD+EDDD$dAH2HHL$`HHL$dW$   E3L$   H|$8L|$0Dt$(L$ LL$`LIHL$xF H$  L$   HT$xI" (D$@IH$  IPH$x  ZH$x  , E3|$@L$   L$   Ld$pH|$hH$  yH@	 H$  8H(  IH$  IPWD$HLt$XHǄ$     L$  Ƅ$   A   HA	 H$  H$  HL$PLD$HH;   H$  L;   H$  I+LL$XI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$H'HL$PLD$HHIH   HA   LqHyrHHH   LL$XI;urIH+HHsbI+HIIH+HsH
		  HQM+IIHL+IIM;HCH;HCHL$H 'HL$PHt0HA   LqHyrHHH$    ;HL$PH HL$PH$   AEHT$HIwI$H
a	 H;tHT$HIP A$     D
`
 DS
 $     W$  L$  H$  D$0D$(H$  HD$ LD$xI躋H$   H$  HXH$   4HtIH$  IPHD$@HD$ A   L$  HT$pH$  tA I$L@H
e	 H$  H;uIL$ιIAАH$x  H$x  z H$  HtL$  L+Ix|$@HHHH;tHD(L$   HT$xIҳ (D$@H$      H$    HH=	 H$   4HHuI
H HcHHHW
   H$   A HƋH HH	 4HH =	 4HHuI
H HcHHHW(A\(H HH<	 S4H( HHI	 84IH$   IPATH$x  &H$x   fD/s;$  H|$haW$  L$  H$  >D$0D$(H$  HD$ LD$xI)H$   H$  tHXH$   裾HtIH$  IPHD$@HD$ A   L$  HT$pH$  > I$L@H
ԫ	 H$  H;uIL$=IAАH$x  H$x   H$  HtL$  L+IHL$HHt.HT$P"k  LD$XHT$HL+IlWD$HLt$XH$x  H$x  s HT$xHt%L$   L+ItWD$xL$   H$   HtL$   L+I3H$   H3` L$  A(sA({E(CE(KE(SIA_A^A]A\_^[HUVWATAUAVAWH8H	  HEHX)p)xHz H3H`  HHM  L@	  LeLH	  HP	  LX	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$` H  2H  H  1 H  HUH   ֞H  H  Wf   Wf0  f@  LP  EHD$hHHT$`H+HHt#35 HuHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  [ H      	    	    	    	     	    Hc(	  H  8  =X
 Wt$XH  H7	 H   /H(L IH  IPWD$@Ll$PHǅ     L  ƅ   A   H7	 H  4H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	 Ө HQM+IIHL+IIM;HCH;HCHL$@HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
=	  HQM+IIHL+IIM;HCH;HCHL$@4HL$HHt/HA   LiHyrHHH    pHL$HH HL$HH  6AEHT$@HRmIH
	 H;tHT$@IP 0	  @   WELmH  0D$0D$(HEHD$ LD$`HH  H  lHXH  蜷HtIH  IPHD$XHD$ A   LEHUHM7 IL@H
ؤ	 HUH;uIOFIAАH(  !H(   HUHtLEL+IH
#Lc8	  ff     LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   H4	 H  IH  IP H  iH    D8  Wt$XH  HL$`h3H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HM
 HH	 H   w*HHu3
H HcHHHWHH HH	 @*   HM HH	 H   *HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H HHa	 )H(  l\ (YH     HM HH	 H   |)HHu3
H HcHHHW   HM LHu3
HHcHHIPA(H` HH"	 )   HM( HHD	 H   (HHu3
H HcHHHW   HM8Y LHu3
HHcHHIPAH  `[ (H̣ HH	 (
   HMH HH	 H   `(HHu3
H HcHHHW   HMXŢ LHu3
HHcHHIPAP  H? HHQ	 '
   HMhi HH	 H   'HHu3
H HcHHHW   HMx8 LHu3
HHcHHIPAX  H HH	 k'HP     HMա HHO		 H   ?'HHu3
H HcHHHWHHW HH		 'H
	 H   &HHh  +HHp
	 &IH   IPH(  ʾH(   0	  HuH  H  oHXH  蟱H   IH  IPHǅ     3H    E3H' H  H  H  H  HC  H  L  Mt
H  H  @  W  H  H  /D$0D$(H  HD$ LD$`H{H  H  hHXH  蘰HtIH  IPHD$XHD$ A   L  HUH  0 IL@H
Ν	 H  H;uIO9IAАH(  H(   H  HtL  L+IEH

@
  W  3H  H  D$0D$(H  HD$ LD$`HyH  H  GHXH  wHtIH  IPHD$XHD$ A   L  HUH  / IL@H
	 H  H;uIOIAАH(  H(  Ɵ H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   Hh,	 IH  IP H  }5A$   H,	 IH  IP H  IF   EH  u  LH	 H  4MHIAP H  H  HL$@Ht.HT$H![  LD$PHT$@L+IkWD$@H|$PH(  衺H(  t H  g  H    H(  nH(  A HT$`HtLD$pL+IEWD$`H|$pHUHtLEL+InH`  H3= L$	  I[PA(sA({IA_A^A]A\_^]HUVWATAUAVAWHH	  HEHX)p)xHj H3H  HHM	  Lh	  LeLp	  Hx	  L	     AA+iA+A   ADʉL$x  AA+iD+EDDD$|AH2HHL$xHHL$|WEE3LmH|$8Lt$0Dl$(L$ LL$xLHuHHL$`_v H  H  H   H  HUH   趎H  H8  Wf@  WfP  f`  Lp  EHD$hHHT$`H+HHt#3 HUHHEHD$hHT$`H]H}IH+HHt)fff     HHHHD$hH+D$`HH;rHUH  K H Hc	  H    	    (	    0	    8	    @	    H	    HcP	  H  8  =H
 Wt$XH  qH(	 H  H( IH  IPWD$@Ll$PHǅ     L  ƅ   A   HY(	 H  H  LT$@HL$HH;   H  L;   H  I+LD$PI;uwIH+HHsgI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@
HL$HLT$@HIH   HA   LiHyrHHH   LD$PI;urIH+HHsbI+HIIH+HsH
	  HQM+IIHL+IIM;HCH;HCHL$@
HL$HHt/HA   LiHyrHHH    =HL$HH HL$HH  AEHT$@H]IH
e	 H;tHT$@IP X	  @   WELmH  D$0D$(HEHD$ LD$`HqH  H  9HXH  iHtIH  IPHD$XHD$ A   LEHUHM' IL@H
	 HUH;uIOIAАH(  H(   HUHtLEL+IH
Lc`	      LeI$HH;tIE~mH`  Ht
H3IHuTHǅ     Hǅ      ƅ   A[   H3%	 H  IH  IP H  9H    D8  Wt$XH  HL$`83H9  ~(LD$`     H  HIHH;  |E:  Eu'Hx   uH`  HtH3IH  H   H`     HMݔ HH H   GHHu3
H HcHHHWHH_ HH    HM HHK 	 H   HHu3
H HcHHHW   HMP LHu3
HHcHHIPA(Hϔ HH H(  <L (YH     HM HHl 	 H   LHHu3
H HcHHHW   HM LHu3
HHcHHIPA(H0 HH    HM(Z HH\ 	 H   HHu3
H HcHHHW   HM8) LHu3
HHcHHIPAH  0K (H HH U
   HMHƒ HH 	 H   0HHu3
H HcHHHW   HMX LHu3
HHcHHIPAP  H HHi 
   HMh9 HH H   HHu3
H HcHHHW   HMx LHu3
HHcHHIPAX  H HH4 ;Hp     HM HH7 	 H   HHu3
H HcHHHWHH' HH H 	 H   HHh  HH0 	 IH   IPH(  蚮H(  m X	  HuH  H  ?HXH  oH   IH  IPHǅ     3H    E3H H  vH  iH  H  HC  H  L  Mt
H  H  ֠@  W  H  H  D$0D$(H  HD$ LD$`HjH  H  8HXH  hHtIH  IPHD$XHD$ A   L  HUH    IL@H
	 H  H;uIO	IAАH(  H(   H  HtL  L+IEH
@
  W  3H  H  ޭD$0D$(H  HD$ LD$`HiH  H  HXH  GHtIH  IPHD$XHD$ A   L  HUH   IL@H
}	 H  H;uIOIAАH(  ëH(   H  HtL  L+I3Hǅ     H  ƅ   H  Ex4A"   H	 IH  IP H  M5A$   Hl	 IH  IP H  F   EH  E  LH H  ^$MHIAP H  ӝH  ƝHL$@Ht.HT$HJ  LD$PHT$@L+I;WD$@H|$PH(  qH(  D H  7s  H  s  H(  >H(   HT$`HtLD$pL+IWD$`H|$pHUHtLEL+I>H  H3
 L$	  I[PA(sA({IA_A^A]A\_^]HUAVAWHhH@  HEHXHpHxL` )pHL   AA+iA+A   ADʉL$p  AA+iD+EDDD$tAH2HHL$pHHL$tWEHE     H   HD$8L   L|$0D$(    D$ LL$pLIHMXf H	 H   H   HuH   HEL}HEHHUH+HWEHt!3P HHHEHEHUH}H] 3H+HHt%f     HHHHEH+EHH;rL%m	 LeH1HEH]LL+tHH WED$xHE    HL$x$HT$xH   H   PAEHT$xIOHHT$xHP HL$xHt|HUG  HEHL$xH+HHH;v HH=   r<t HAH;r H+Hs H'v، H觺 Ld$xHM)~HEHMHMHULL+tH EEfEML   HT$xHM>  L|$hH   HL$`Lt$PHEHD$HHEHD$@D$8 D$0   L$(   L$    DE3H     +fn^5.
 LM(W)LM(W)(WHMs.LeHM܊ HҊ H|	 H   HMHtsHEH+HHH;vz H    H=   r<t^ HAH;rN H+Hs> H'v1 H  3L$@  I[ Is(I{0Mc8A(sIA_A^]HWH   HǀxHXHhHpAAHHHQHHbH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH蠖 H$   1L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHaH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHN H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHH^H$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  D$`$  L$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH H$   AL$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHH]H$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  D$`$  L$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHN H$   L$P  I[IkIs I_HUHhHp  HE@HXHpHx HH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D   uEtAD   Eu
ǅ      AH2HH   THH   eWEPHE`    H   HD$8H   H\$0D$(   D$ L   LHHL$p[ H{	 HEWHM+H	 HEHl	 HEH}Hj	 HEH   HEH   HE(9)
 )E (
^'
 )ME        %
 E(E0    E4 WE8Hn	 HE   f/vM   f/v
$
 f/vM   OȉM$H  HD$`H   HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM7 Hq	 HEH}	 HEHM HM HM Hs	 HEHT$pHtLEL+I}3L$p  I[Is I{(I]HUHH  Hǅ   HXHpHx )p)xHH   AA+iA+ȉ   ut   u
ǅ        AA+iD+D  uEtAD  Eu
ǅ     AH2HH   VHH  gW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$pX Hx	 HEWHM(H	 HEHi	 HEH}Hg	 HEH   HEH   HE(5&
 )E (
Z$
 )ME        "
 E(E0    E4 Wu8EH Hg	 HEP 
 Ex(
&
 )   @"
    uXW)E`Hmh	 HEH5rg	 Hu@P  f/vE= 
 X  f/vf/vM`  OȉM$Y Eph  f/vf/vExp  f/v   x  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMI Hu@Hm	 HEHy	 HEHM} HM} HM} Ho	 HEHT$pHtLEL+I軻3L$  I[Is I{(A(sA({I]HWH   HǀxHXHhHpAAHHHQHHUVH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH輦 H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHUH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HHz H$   L$P  I[IkIs I_HWH   HǀxHXHhHpAAHHHQHH%RH$  H$   H$  H$   H$  H$   H$  HD$xH$  HD$p$  D$h$  L$`$  D$X$x  D$P$p  D$H$h  D$@$`  D$8$X  D$0$P  D$(\$ DL$   HH H$   L$   I[IkIs I_HWHP  HǀxHXHhHpAAHHHQHHPH$   H$   H$  H$   H$  H$   H$  H$   H$   H$   $  $   $  $   $  $   $  $   $  $   $  D$x$  L$p$  D$h$  L$`$  D$X$  D$P$  D$H$  D$@$  D$8$  D$0$  D$(\$ DL$   HH芰 H$   L$P  I[IkIs I_HUWAVHl$Hp  HE@HXHpHH   AA+iAA   +ȉ   ut   uD     AA+iD+D   uEtAD   EuD   AH2HH   贮HH   ŪWEPHE`    H  HD$8H   H\$0D$(   D$ L   LHHL$p#O H3o	 HEWHMkHDw	 HEHI`	 HEH}H
^	 HEH   HEH   HE(
 )E (

 )M
 ] WM0E(
   HV	 HE   f/v*   f/vUE ^,ALƉE(   f/vf/vEH  HD$`H  HD$XH\$PH   HD$H   D$8   D$0   D$(   D$ D   LD$pHHM蘖 H[	 HEHp	 HEHMt HMt HMt Hg	 HEHT$pHtLEL+I޲3L$p  I[(Is0IA^_]HUWAVHH  Hǅ   HXHp)p)xHH   AA+iAA   +ȉ   ut   uD     AA+iD+D  uEtAD  EuD  AH2HH   跫HH  ȧW   Hǅ       H  HD$8H  H\$0D$(   D$ L   LHHL$p L H0l	 HEWHMhHAt	 HEHF]	 HEH}H[	 HEH   HEH   HE(
 )E (

 )M=
 } Wu0E(
   E@ H [	 HEH(
 )Ep(
z
 )   W)EPu`H(c	 HEH5e	 Hu8P  f/v*`  f/vME ^,ALƉE(X  f/vf/vEY
@
 (& Ehh  f/vf/vEpp  f/vExx  f/v     f/v   H  HD$`H  HD$XH\$PH  HD$H@  D$8H  D$08  D$(0  D$ D(  LD$pHHMɯ Hu8HW	 HEHBm	 HEHMLq HMBq HM8q HYc	 HEHT$pHtLEL+I+3L$  I[(Is0A(sA({IA^_]HUVWATAUAVAWHhH@  HEHX)pH< H3HE AALL   L   H   L  H  HEI}k   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$pHHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHMH WD$XH|$hHE   H}@} DGH( HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
ݡ	 l HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
)	 l HQM+IIHL+IHM;HCH;HCHL$X HL$`Ht,HA   HyHyrHHHU   _HL$`H HL$`HEHrPHHM H=   r<tn HAH;rn H+Hsn H'vn Hg AEHT$XI0IHT$XIP H}H]H+HWD$xHt3hm H_HHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHM    D$8   D$0   D$(   D$ LL$pLD$xIHM	]  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM`  HL$xJl HL$XHt2HT$`'  LD$hHT$XL+IWD$XHD$h    HUHtLEL+I3HM H3- H$  ($0  H@  A_A^A]A\_^]HUVWATAUAVAWHhH@  HEHX)pHx7 H3HE AALL   L   H   L  H  HEIMf   +i+A   ADȉL$p  +i+AD؉\$tH2HHL$p΢HHL$tWE3H}Ht$8Ll$0D$(t$ LL$pMIHMZC WD$XH|$hHE   H}@} DGH  HM HE LT$XHL$`H;   HE L;   H] I+LD$hI;uwIH+HHsgI+HIIH+HsH
	 g HQM+IIHL+IHM;HCH;HCHL$XHL$`LT$XHIH   HA   HyHyrHHH   LD$hI;urIH+HHsbI+HIIH+HsH
	 f HQM+IIHL+IHM;HCH;HCHL$XHL$`Ht,HA   HyHyrHHHU   /HL$`H HL$`HEHrPHHM H=   r<ti HAH;ri H+Hsui H'vhi H7 AEHT$XI+IHT$XIP H}H]H+HWD$xHt38h HxZHHD$xHL$xH}H] H}HMHEHEHE HEHD$PHEHD$xHEHHH+HHH3H~)HH;}
H] HMLHMx    D$8   D$0   D$(   D$ LL$pLD$xIHMW  HEHD$@L|$8Ll$0   D$(   D$ D   D      HM^N  HL$xg HL$XHt2HT$`m"  LD$hHT$XL+I跢WD$XHD$h    HUHtLEL+Iܤ3HM H3 H$  ($0  H@  A_A^A]A\_^]HWATAUAVAWH   HǀHXHp )pHG2 H3H$   MMH$   LH HHH H; r   [HH HL$hHt
	
 H3H 3HHHz H;k r
   HHL$hWHt
(HHW$   H$   L$   L$(  H$0  H$8  H$   HT$ H$   艜  HD$ H$   H$   HT$ H$   b  HD$ H$   WD$PHt$`IcE`HD$0IHt$I;v
H
	 ub HHL$PsHD$0L     H$   L;`  HT$   HD$ HL$XLD$PH;   HD$ L;   Lt$ M+ILL$`I;uoIH+HHs_I+HIH+Hs
H
	 a HQM+IIHIH+ILI;LCL;ICHL$PrHL$XLD$PH   K~LL$`I;ujIH+HHsZI+HIH+Hs
H
g	 Ia HQM+IIHIH+ILI;LCL;ICHL$PLrHL$XHt
HD$ HHL$XHHL$XIHD$0H$   HT$(}  HHD$ H LH(H H; r(   ]LHL$ Lt$hMt*L9AOXKII^M~ Hnc	 ILLt$hHT$ HL$0(HHL$ HD$ H$   WD$8Ht$HMc},MtM;v
H
*	 ` IHL$87qL@ M;  HT$ H$   腙  HD$ HL$@H;   HD$ LD$8L;   H\$ I+HLL$HI;uoIH+HHs_I+HIH+Hs
H
	 q_ HQM+IIHIH+ILI;LCL;ICHL$8tpHL$@LD$8Ht.I H;L$HuHL$8oHL$@Ht
HD$ HHL$@HHL$@I    HǄ$X     H$P  Ƅ$@   A   HW	 H$@  薪HǄ$8     H$0  Ƅ$    A   H	 H$   _EE`EyH$@  H$   H$   nH$@  nIcU`HL$pUHLD$xIHL$pH+HHt)f     H<HLD$xIHL$pH+HH;rHL+IMtH<HHD$xHL$pH+HH;r    A   5
 E;u`L  s    HǄ$x     H$p  Ƅ$`   A   H"	 H$`  AHǄ$X     H$P  Ƅ$@   A   HϏ	 H$@  
HǄ$8     H$0  Ƅ$    A   H	 H$   ӨIcL$`  HHL$Pj  LI   L$@  HP  WMHL$(LL$   HHL$p$  HIHH$   mH$@   mH$`  lAHL$p A;]`   HcH<    H$  {H	 H$   [HH\ ]HH$  H$  2yHxrH H
f H$   3H$   H$   H$@  Ƅ$H  H$   H$@  P] HU	 H$   H H$    7    HǄ$X     H$P  Ƅ$@   A   H}	 H$@  HǄ$x     H$p  Ƅ$`   A   H}	 H$`  ΦEE(EyH$@  H$`  ?H$`  QkH$@  CkIcU(H$   BRHL$(  IH$   H+HHt&H<HL$(  IH$   H+HH;rHL+IMt-ff     H<HH$(  H$   H+HH;r "   D$0   t$ LL$0LD$ H$   HL$(苜 HT$(H$      #   D$    t$0LL$ LD$0H$   HL$(G HT$(H$   e  g $   t$ M   LD$ HT$PHL$( HT$(H$   *  , %   	 D$(t$ LL$(LD$ H$   HL$0 HT$0H$     &   t$ M   LD$ HT$8HL$( HT$(H$    A   E;u(   *   HǄ$     H$  Ƅ$   A   H6	 H$  eHǄ$     H$  Ƅ$   A   H{	 H$  .HǄ$     H$  Ƅ$   A   H	 H$  HǄ$     H$  Ƅ$   A   Hz	 H$  HǄ$x     H$p  Ƅ$`   A   Hjz	 H$`  艣IcI   L$  H^ LD$8HHL$  HD$(L$  HIMh3 LD$pHHL$0 L$   HH$   LIM0L$  H  LL$  HIMhۜ LD$PHH$   膞 L$   HH$   AHH$   yMHH$   LD$(HH$@  HL$`  HH$     HHHH$`   gH$  fH$  fH$  fH$  fAa ,   IUHL$   L$   HL$(H HT$(H$    H$   HtL$0  L+ITHT$pHt%L$   L+I5WD$pH$   HT$8HtLD$HL+I	WD$8Ht$HHT$PHtLD$`L+IHT$hH$    H$   H$   HH$   HtL$   L+I蓕HH$   H3~ L$   I[@IsHA(sIA_A^A]A\_HWATAUAVAWH   HǀHXHp )pH" H3H$   IMH$   LH HHH~ H;o r   HHa H$   Ht
|	 藾H3H; 3HHH' H; r
   贶HH$   WHt
(IHH$   W$   H$   L$   H$(  H$0  H$8  H$   HT$ H$   .  HD$ H$   H$   HT$ H$     HD$ H$   WD$PH|$`Mce`IMtM;v
H
=	 S IHL$PJdL    H$   M;[  HT$ 蕌  HD$ HL$XLD$PH;   HD$ L;   Ht$ I+HLL$`I;uoIH+HHs_I+HIH+Hs
H
	 R HQM+IIHIH+ILI;LCL;ICHL$PcHL$XLD$PH   I~LL$`I;ujIH+HHsZI+HIH+Hs
H
	 Q HQM+IIHIH+ILI;LCL;ICHL$PbHL$XHt
HD$ HHL$XHHL$XIH$   HT$(2  HHL$0(HHL$ HD$ H$   WD$8H|$HMce,MtM;v
H
U	 7Q IHL$8bbLM;   HT$ H$   贊  HD$ HL$@H;sAHT$ HD$8H;w2Ht$ H+HH;L$HuHL$8yaHL$@HD$8Ht.H H;L$HuHL$8SaHL$@Ht
HD$ HHL$@HHL$@I\]    HǄ$X     H$P  Ƅ$@   A   H	 H$@  +HǄ$8     H$0  Ƅ$    A   H=	 H$   EE`EyH$@  H$   eH$   w`H$@  i`IcU`HL$hkGHLD$pIHL$hH+HHt.@ ff     HHLD$pIHL$hH+HH;rHL+IMtHHHD$pHL$hH+HH;r%    A   5;	 E;u`L      HǄ$x     H$p  Ƅ$`   A   H	 H$`  њHǄ$X     H$P  Ƅ$@   A   H_	 H$@  蚚HǄ$8     H$0  Ƅ$    A   H	 H$   cIcL$`  HHL$P  LI   L$@  H  WMHL$(LL$   HHL$h  HIHH$   ^H$@  ^H$`  ^AHL$h A;u`   HcH<    H$  lH	 H$   [H,HQN ]HH$  H$  jHxrH H
XX H$   3H$   H$   H$@  Ƅ$H  H$   H$@  N HG	 H$   Hr H$   s     HǄ$X     H$P  Ƅ$@   A   Hro	 H$@  蕘HǄ$x     H$p  Ƅ$`   A   H?o	 H$`  ^EE(EyH$@  H$`  H$`  \H$@  \IcU(H$   CHL$(  IH$   H+HHt&HHL$(  IH$   H+HH;rHL+IMt-ff     HHH$(  H$   H+HH;r "   D$0   |$ LL$0LD$ H$   HL$( HT$(H$   9 ; #   D$    |$0LL$ LD$0H$   HL$(׍ HT$(H$     $   |$ M   LD$ HT$PHL$(謐 HT$(H$     %   x	 D$(|$ LL$(LD$ H$   HL$0蒔 HT$0H$   p r &   |$ M   LD$ HT$8HL$(w HT$(H$   5 A   E;u(  ' *   HǄ$     H$  Ƅ$   A   H|	 H$  HǄ$     H$  Ƅ$   A   Hl	 H$  辕HǄ$     H$  Ƅ$   A   HD|	 H$  臕HǄ$     H$  Ƅ$   A   H5l	 H$  PHǄ$x     H$p  Ƅ$`   A   Hk	 H$`  IcI   L$  H LD$8HHL$ 蜐 HD$(L$  HIMhÎ LD$hHHL$0q L$   HH$   詼LIM0L$  HB  LL$  HIMhk LD$PHH$    L$   HH$   NAHH$   	MHH$   &LD$(HH$@  HL$`  HH$     HHHH$`  XH$  XH$  tXH$  fXH$  XXAa ,   IUHL$   L$   HL$(ؘ HT$(H$   V H$   HtL$0  L+IHT$hHtLD$xL+IȇWD$hH|$xHT$8HtLD$HL+I蟇WD$8H|$HHT$PHtLD$`L+IvH$   H$   
 H$   H$   HXH$   HtL$   L+I&HH$   H3Cp L$   I[@IsHA(sIA_A^A]A\_@SVWH   HD$0H H3HD$xIHHHD$p   HD$h    D$X A   Hh	 HL$XHD$P   HD$H    D$8 A   H	 HL$8ǑLGL+IH\$(D$    DHL$8HD$PHrQHHL$8H=   r<tH HAH;rH H+HsH H'vH Hv HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<toH HAH;r_H H+HsOH H'vBH Hv HHHHL$xH3n HĀ   _^[Ht3HtHHHuHt3HtHHAHAHHuHt3HtHA   HAH HuH;   H\$WH Hl$0HHt$8H3H?HHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Ht H3HsHsHH;uHl$0Ht$8H\$@H _F F F F F DL$ LD$HT$HL$SVWH0HD$(HH9z ucH 藠 HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[DL$ LD$HT$HL$SVWH0HD$(HH9z ucH W HHD$`HCHL$XAC HEH|$ DL$hLHHHDL$hLHT$XHRHqHCHH0_^[H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHr H   H;HsrHCHCH @0HCH;uH\$0Ht$8H _D D D D H;	  WH H\$0HHt$8HY@3HHrDHKHH=   r0   HAH;   H+H   H'   H"r H   H;HsrHCHC@0HCHr<HKHH=   r(   HAH;   H+HrrH'weHq HC   H{HsrHCHCHH@0HCH;H\$0Ht$8H _C C C C C |C uC nC H;   WH H\$0HHt$8HY3HHr4HKHH=   r upHAH;s`H+HrPH'wCHp H   H;HsrHCHCH(@0HCH;uH\$0Ht$8H _B B B B HtI HLL$ HL$SVWH0HD$ IHHHL$hHt$H|$XHtHHIHHH|$PH0_^[H;   H\$WH Hl$0HHt$8H3HHHtPHCH+HH;wzH    H=   r u^HAH;sNH+Hr>H'w1Ho H3HsHsHH;uHl$0Ht$8H\$@H _A A ~A wA pA HtHtI HHHuHtHtA HHu@USVWAVAWH$xH  HD$PH H3HEpMMHHH   D$     Ho<	 HD$`HM ? D$    E3E3HT$hHL$`> HD$`HcHH(	 HD`HD$`HcHDxDD\   HL$h'HHL$`HHG\	 zHHHHUb	 `HIHA= HHlHUPHL$`N\HxrH H
G HL$(3HL$0HL$8HD$@D$HHT$0HL$@A> H>	 HD$(HN HL$(x @UVWATAUAVAWH$pH  HD$@H$  H
 H3H   MIHLL   H   HD$8E3D|$0H:	 HD$PHM= D$0   E3E3HT$XHL$PO= HD$PHcHHV'	 HDPHD$PHcHDxDDLAWHL$X莕HHL$P HHr	 HIV< HHp	 HU`HL$PZHIcD$0HU`H}xHCU`HEX   L}PD}@D8:tIIB<: uMHM@؆HD$8HD$ MLD$0HU@IH\$Ht$WH IHHH;t HH5DHHH;uH\$0HHt$8H _H\$Hl$Ht$H|$ AVLt$0HIE3HMكH<IHHH+3HHHH~N@ 3M~:ND  I MI IHIHHHLA)AA)II;|HH;|H;}<E3M~*JOZIHH[I IIH)CM;|HH;|I;   @      E3I   IkHEHH^JAyMI I H[ IHIIHHHKHOIHI HHHKI IHHHHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|HI;3H\$Hl$Ht$ H|$(A^H\$Ht$ WATAVLd$@LIE3H3ILIM  Hl$ L|$(3H  LIGHMNHOHkLIM   HHIPHHIpHDIxHDIAHDHUIAIPIHHIAHDIAHDIAHDHIAIPIHHIAHDIAHDIAHDHUIAHIIPHHIAHDIAHDIAHDIAI;H;}OHMNH+OMIMI HHIPHHIAHDIAHDIAHDIAH;|HI;L|$(Hl$ M;        3H   HwHFHMNOэZMID  I MI HHIHIHIIHKIHI IHIIHIHI IHIIHKIHI HIHIIH;|H;}!I HIHHIHKIH;|IM;3H\$0Ht$8A^A\_HLH L@HPHHSUVWATAUAVAWH(  H$  LH$  ML$  LLE$  HH$  H)pA   HE$  I)xLD)@ID)xD)HD$  D)hD)XIHHL\$`L$  H$p  HD$P    HH$  HHH$  L<H$  HIH+L|$H3HH$  HkH  H   I;HD$XHT$LO3IL$H$  M	  D)$   D)$   D)$   fD  JL;HD$0LHD$hMLL$  H  HLHLHD$D  HI;  IA(HWHD$(IHf)D$p)d$@M$     IA$IFMWIM_LLD(D(D(D(D(D(D(D(HIIHLLHHBL BL L L IAM M7  MEPLD$ MALt$ IIfD  A0  (1(yfpfApfD(fApnfpDfYfYfDX((fYfYfDXfYfY(fY(q fDXfY(y0fDXfAp^fDXfApVD(fYfDXfApfDfDXfDXfApn(fYfDXfDXfY((fYfYfDXfY(q@fYfY(yPfDXfApVDfDXfAp^fDXfAp&D(fYfDXfAp.fDXfDX((fYfYfDX(fYfY(q`fYfYfY(ypfDXfApVDfDXfDXfDXfDXfDXfAp^(fApf D(fApn fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXA  (   (   fAp^0fApf@D(fApn@fApV0DfYfYfDX((fYfYfDXfYfY(fY(   fDXfY(   fDXfAp^PfDXfApf`D(fYfDXfApn`fDXfDXfApVPD(fYfDXfDXfYfY((fYfYfDXA(   fY(   fY(   fDXfAp^pfDXfpDfDXfp(fYfDXfApVpDfDXfDX((fYfYfDX(fY(   fYfYfYfY(   fDXfDXfDXfDXfDXfDXA(   H   fpDH   fp(A(   I   fpDfp(fYfYfDX(fYfYfDX(fYfYfYfYfDXfDXfDXfDXfDXfDXI(d$@L$x  L;   H+LM+fD  (y(1(fpD(fpfpdDfplH fYfYfDX(fYfDXfDX(fYfDX(fYfYfDX(fYfYfDXfDXfDXIw(d$@BLd$(HB\BBDfDYfDYfDXfAXFB\fDYfDYfAXfAXBBD\DfDYfDYfDYfDYfDXfAXDfAXfAX\D(D$pH;$  D$  L$  H$  H$  L$  HD$L$  LIIGH;HD$UL|$L$  H$p  HI;n  H$  L,    HHL<H$  HI;
  IIHA(HWfM    IAMF(M(LLCL IM-  IQHH     f(fYXfY fXYfXf(fYX0fY@ fXYfXf(fYXPfY@@fXYfXf(fYXpfY@`fXY fXf(fY   fY   fXY(fXf(fY   fY   fXY0fXf(fY   fY   fXY8H@fXf(fY   fY   H   fXfXHL;};HI+fff     Hf(fY fYXH fXfXHuCDHL(CfYfX(fYfXCCTI;*H$  H$  L$  HL$  MH;L|$H$  L$  HL$0   L$  L$  H$p  L$H$  H$  I;GD($   D($   D($   L;$    MIIIL$$ML$  @ ff     H$p  H$  H  LE(IEWL$  LfELD  IAIFM]MI]LHA(A(E(E(IImHHMIIICL AL AL AL IA$MX  MQIID$PI@ ff     0  ()fp
DfpXDfpfp`fYfYfYfY(ifXfpHDfDXfpXDfXfpPfDXfp`fYfYfYfY(i fXfpHDfDXfpDfXfpPfDXfp fYfYfYfY(i0fXfpHD(fDXfpXfXfpP DfDXfp` fYfYfYfYfDXfXfXfDX  (i@H   fp`@(fpP@DfpH0DfpX0fYfYfYfpP`DfDXfYfp``fDX(iPfXfpHPD(fYfYfXfpXPfYfDX(   fYfpfpDfDX(i`fXfpHpD(fXfpXpfYfYfYfDX(   fYfXfpDfXfp(   H   fDX(ipHfpfpD(fYfYfYfYfDXfXfXfDXIL$  L;}]HI+fff     ()Hfp
D(fpfpRDfpbH fYfYfYfYfDXfXfXfDXHuAIMCA(fYIEfXA(fYfXCL$  AH$  A(AAfAYfXA(fAYfXAAH;VL$$L$  LI;X  H$p  A(H$  WfH,    HH IAI>MMF(HMM   IQHH	ffYfXIffYHfXIffYH fXIffYH0fXI ffYH@fXI(ffYHPfXI0ffYH`fXI8H@ffYHpHfXH`L;})HI+D  	HffYHfXHuBIH(fYfXBM;H$  MI   L$  L;$  L$  H$  D($   D($   I;  L$  EWH  H$  J<    H$p  IL$  LIHL<fH\$MMD  A	3IA(A(A(E(H  LFIIIIJ    fD  Ya HPYYYX@YXDXH(P8XY@ YYXHHXY@0DXPXYaXHhH YXY@@YDXPxXYX@PYDXX@`YX@pYHXIL$  H;}JHAH@HPYYYX YXH DXXH;|IHKINAYAYAYLIEYX,,HKINIIX44HINIIX<<HKINIIIDXDM;HLH\$HCH$  H;L$  H$  I;2  H$  J<    H$  LN<H$p  L$  H,    HLLMf     AE3A(H|cIHVI+HHIBL    fHYLY@XHYLYDH XXXHuL;}'IKI+HI+Y HXHuIHINAYLIIXM;4H$  HLI;L$(  A(sA({E(CE(KE(cIA_A^A]A\_^][@SH   HD$ HHH$   7HX(H
W	 HH0@8   HH$   ā HHL$(67H? HL$(\ H\$WH HHHÀ< uHú   Hu" HHu Ht!HH+fff     9HHuHH\$0H _@SH HQ  H	 HCPH [HL$SH0HD$ HD$P    EtH.	 HA@H	 HAPD$P   J   H	 HH	 HCHC@HcHH	 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH) HHQ3HHBHK  H	 HH{3HHDH^H\$HHm	 HHOHKHtHPHGHCHGHCG C H"	 HH) HHH\$PHt$XH0_@SH HN  Hs	 HCPH [HL$SH0HD$ HD$P    EtH	 HA@H3	 HAPD$P   z  H#	 HH
	 HC(HC@HcHH		 HD@HC@HcHD<    HH0[@SH HbL  H	 HCPH [HL$SH0HD$ HD$P    EtH	 HA@H	 HAPD$P     H+;	 HHY	 HC(HC@HcHH6	 HD@HC@HcHD<    HH0[@SH HH(  ;  HH [  @SH HHH    HH [  @SH H	 HHH	 HAPHI8 HK  HK H	 HH [@SH H	 HHHv	 HAPHI8 HK v HKl H	 HH [H\$WH HN  H
	 HGPt
X   HL HH\$0H _H\$WH HLL  H	 HGPt
X   HL HH\$0H _H\$WH HH$	 HHHJHKHtHPHGHS0HCHO0HGHCG C H& HC(3HHB H	 HH	 HC(HH\$0H _H\$WH HI  H	 HGPt
X   HK HH\$0H _H\$WH HHT	 HHHJHKHtHPHGHS0HCHO0HGHCG C HF% HC(3HHB H	 HH	 HC(HH\$0H _@SH HH   b H   ~*HKXL HKHB HK88 HK(. HK$ HKH [H% H\$WH HQ@3HHtLAPL+IYH{@H{HH{PHS(HtLC8L+IYH{(H{0H{8HSHtLCL+IHH{H{H{H\$0H _H\$WH HH     L   HgfffffffL+   IHLI?LH     H   F)HOX HOH
 HO8  HO( HO HOH\$0H _H% @UVWAVAWH$@H  HD$8H$  H H3H   IILHE3D|$0AA A	fD  f/rHHrY  H	 HD$PH	 HD$`HMj D$0   E3HT$hHL$P. HD$PHcHHM	 HDPHD$PHcHhTLHD$hHD$@HL$h H
	 HD$hL}D}HlN	 HL$`躜HL$` H   HL$Pz4H   H   HC   HEh   L}`EP : uMI@ IB< uHMPbHǅ      L   Ep A   HM	 HMpbHEPHD$ LMpLIHH   H34@ H$  H  A_A^_^]HUVWATAUAVAWHH  HEHX)pH H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHO	 H  aHL@H
j	 H;u.HSHKHHH  9HHOQ H  HAАH  HrSHH  H=   r<t HAH;r H+Hsw H'vj H9F HWHL$x{E@  MEHT$xH^  (Hǅ     L  ƅ   A   HN	 H  `IH  IPH  HrSHH  H=   r<t HAH;r H+Hs H'v HgE H   3HsN	 H   藙H( H  H   X1ILAHIAАH  HrTHH  H=   r<t HAH;r H+Hs H'v HD HH  	1HH   H\$0Lt$(x  D$ p  (HT$xHM  H_HD$xH  HuHCH;t'H;tH Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH  豌 HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
G	  W  L  D$@Ll$PH	 HEH	 HEHMH} D$\   E3HUHMC HEHcHHc	 HD
HEHcHhT
HEH  HM H	 HELm0Dm8D$0D$(HD$@HD$ LD$`HBH  HM.HXH  !Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
E	  IPL+IIHL+IIM;HCH;HCHL$@_yLD$HMtM(LD$HILD$HIPHL$@H;t
I;t\C IHT$@IPHǅ     L  ƅ   E3Hq/	 H  \IH  IP H   H  .HmJ	 H  aHȋW$ HH#J	 FIH  IPAD9o$Y  f     LGHWHL$x\ EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  *.D$0D$(HD$@HD$ LD$`HH  H  e,HXH  HtIH  IPLD$HL;D$Pu   HL$@eQLD$HMtM(LD$HILD$HIPHL$@H;t
I;tA IHT$@IPHH  ,HH   ;w$}H
WC	 ! Hǅ     L  ƅ   A
   HH	 H  ZIH  IP H  HH  +HH  V HMHl+HMHB HT$@HtLD$PL+IFNWD$@Ll$PH  HtL  L+Ii=HT$`HtLD$pL+IMHM HL$x 3H  H37 H$`  ($   H  A_A^A]A\_^]HUWATAVAWHhH   HEHXHpH[ H3HEHHLALIEgAEoAEwA EA$HE   E3LeDeED$+HoG	 HMXHE   LeDe6G	 MAH&G	 HM]XD9ckHE   LeDeED$HC	 HM1XHE   LeDeED$HtC	 HMXHEHD$ LMLCHUHMl*HEHrPHHMH=   r<t/ HAH;r H+Hs H'v H< HE   LeE HEHrPHHMH=   r<t HAH;r H+Hs H'v Hg< HE   LeE A&   HF	 HMWHE   LeE E	 MAHE	 HMV{ mHE   LeE A   H,B	 HMVHE   LeE A   HA	 HM|VHEHD$ LMLCHUHM(HMHMHE   LeE A*   H\E	 HM#VHE   LeE D	 MAHD	 HMULC HUHM`HMHM|HE   LeE A&   HE	 HMUHE   LeE ND	 MAH>D	 HMuULC$HUHMHM	HMHHMH33 L$   I[8Is@IA_A^A\_]HUVWATAUAVAWHH  HEHX)pHe H3H  EA(HL  L  H  E3Dl$\Hǅ     L  D  EEHB	 H  THL@H
J H;u.HSHK(HH  HH/1	 H  HAАH  HrSHH  H=   r<tw HAH;rg H+HsW H'vJ H9 HWHL$x@  MEHT$xH~l  (Hǅ     L  ƅ   A   HA	 H  ySIH  IPH  HrSHH  H=   r<t
 HAH;r
 H+Hs
 H'vx
 HG8 H   %HSA	 H   wH( H  H   8$ILAHIAАH  HrTHH  H=   r<t	 HAH;r	 H+Hs	 H'v	 H7 HH  #HH   H\$0Lt$(x  D$ p  (HT$xH0[  H_HD$xH  HuHCH;t'H;tHm Ht
HHL+HsLLD$`HD$`H  H  H  HD$XH  H  LKIHH+HHHIH~*ff     H  (A)HH;}LD$`MH   HGHPHL$`EHWL9B~GILL$hLT$`M+IHL;vHIAHHWIcH;B|H
9	  W  L  D$@Ll$PH	 HEH	 HEHMH] D$\   E3HUHM# HEHcHHC HD
HEHcHhT
HEH  HM H HELm0Dm8D$0D$(HD$@HD$ LD$`H"H  HMr!HXH  Ht
IHUIPLD$HLL$PM;uwII+HHsgHL$@L+IIII+HsH
8	  IPL+IIHL+IIM;HCH;HCHL$@?lLD$HMtM(LD$HILD$HIPHL$@H;t
I;t<6 IHT$@IPHǅ     L  ƅ   E3HQ"	 H  NIH  IP H  H  !HM=	 H  AHȋW$ HH=	 &IH  IPAD9o$Y  f     LGHWHL$xNP EIHWH9J~8LL$hLT$`M+IHL;  HIAHHWIcH;B|H  
!D$0D$(HD$@HD$ LD$`HH  H  EHXH  uHtIH  IPLD$HL;D$Pu   HL$@EDLD$HMtM(LD$HILD$HIPHL$@H;t
I;tr4 IHT$@IPHH  HH   ;w$}H
76	  Hǅ     L  ƅ   A
   H;	 H  LIH  IP H  HH  cHH  6 HMHLHMH" HT$@HtLD$PL+I&AWD$@Ll$PH  HtL  L+II0HT$`HtLD$pL+I@HM HL$x 3H  H3) H$`  ($   H  A_A^A]A\_^]@SH A(HA CS CH [Ht$WH0HD$     H      t@W H   HVxH\$@      ^FxH\$@,;L   HHt$HH0_@SH H HH   H HH HAPHI8 HK  HK~ H HH [Wf/v%      ^Ix,;L   H\$WH HHH   H
H   H
H   HH\$0H _
@UHHPHEH\$`Ht$pH|$xH H3HEHHE   3Hu@uDF
H9	 HM	JHKHEH;sTHHUH;wHH}H+H;KuVH>HH;HKHtcHA   HqHyrHHH;H;Ku
   H>HKHt'HA   HqHyrHHHU  4OHC HEHrPHHMH=   r<t  HAH;r  H+Hs  H'vv  HE. HE   HuE A
   H8	 HMHHCHMH;sVHHUH;wJH}H+H;Cu
   H=HH;HKHtcHA   HqHyrHHH;H;Cu
   H=HKHt'HA   HqHyrHHHU  NHC HMHE   HuE A   H7	 HMHHUHHMHMH3% H\$`Ht$pH|$xHP]HHPUATAUAVAWHhH   HEHXHpHx )p)xD)@MILH3um  HSH2n  H_HGPLG`HHOPP8MHHOPk  HHM衦HCHEEWH9puA(H HD$8HEHEHL$0n (Y5	 Xs(    ~-D  HGHLl$    LGPHHOH;   |HCHEHx uA(H HD$8HEHEHL$0 YA	 XC(EoHHEoH#H      H;v	 \(M (5	 f/vIHOh	j  f/v:HEH;t1HKHU
EC(HKHUHK0HU]HCHEHx tH HD$8HEHEHL$0, D(DYo	 DXC(D   0H I$I\$H]oHONHHHGHCHWHGLL+tL W=s	 A|$At$ HM HM HM IL$   I[0Is@I{HA(sA({E(CIA_A^A]A\]@SH A(HA CL CH [H\$WH0HD$     H      tS HWxH   HH\$@H0_@SH HC HH   H HH HAPHI8 HK  HK H HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=	 H(F   (H\$ LHH   (LHHH\$`Hl$hHt$p(t$@(|$0HP_   @SH   L$   IL)$   H(HT$0A  HKHt$hH\$XL HD$ HD$@HD$`HD$HH$   HD$PLD$xHL$ LKIHH+HH3HH~;@ A(((ffYf\)HH;}LD$xt$hHL$ MHL$@f HL$0) ($   HĠ   [H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@0f HL$0= L$   HHH$   ($   HĠ   _:f  H\$Hl$VH03IHH9Z ~AH|$@)t$ W@ Hg HFXHHcH;F |(t$ H|$@H\$HHl$PH0^H\$WH0IH8IHD$     HHK8HOHS0LC8IL+LtHH HH\$@H0_H\$WH0IH IHD$     _HHK HOHSLC IL+LtHG HH\$@H0_HHPWHpH@HXHpH3ۉ\$ HAHpHHZHt3 HHHwWD$0HHL$@HD$@HD$PHD$0HD$XH$   HD$`H|$hHHH+HHH~$fD  f)HH;}
D$0HL$@LHHL$Pb0 HL\$pI[Is I_@SH   HBHHD$(WHx u(H HL$8HD$@HD$ HD$P (Y%Ֆ	 HCH0HD$@H\$HH{ t*H HL$XHD$`HHD$pHD$8H$   } (X\(HĐ   [B(HhHBHD$(Hx uWYA	 HhH HL$8HD$@HD$ HD$P Y	 HhWf/v	 f/v   Wf/vIxHAHH H\$WH HHe  HCHKHH\$0H _H`LI[IsWHpIMCI[HIy tmI IKI1ICICICIs| Wf/vEH|$(HL$@H\$0HHD$HHD$ HD$hHt$X| f/vL\$pI[IsI_L\$p2I[IsI_H\$Ht$WH0H)t$ H   HHGfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   Hk3HSHt
HHH
HB$H;Cu
   H?3HCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   H2HSHt
HHH
HJ$H;Cu
   H2HKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HV2HSHt
HHH
HB$H;Ku
   H*2HCHt0HH   HCH;s;HH;w3H+HH;Cu
   H1HSHt
HHH
HB&H;Cu
   H1HKHtHHHAHt$P(t$ HCH\$HH0_@UHHPHEH\$`Ht$pH|$xH! H3HEHHE   3Hu@uDF
H
*	 HMy:HCHMH;sTHHUH;wHH}H+H;CuVHg/HH;HKHtcHA   HqHyrHHH;H;Cu
   H$/HKHt'HA   HqHyrHHHU  ?HC HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   HuE A   H)	 HMO9HCHMH;sVHHUH;wJH}H+H;Cu
   H;.HH;HKHtcHA   HqHyrHHH;H;Cu
   H-HKHt'HA   HqHyrHHHU  x>HC HMJHE   HuE A   HE(	 HMt8HUHHM
HE   HuE A   H(	 HM78HUHJHMHE   HuE A   H'	 HM7HUH
HMHMH3 H\$`Ht$pH|$xHP]HUVWATAUAVAWHH0  Hǅx  HX)p)xD)@D)HD)xD)hD)XD)HMILHEp    ]  HSH^  H~HFPLF`HHNPP8MHHNP[  HHM~HUH   mHUHM0_HUH   NHFPLHUHNPP(HMHE HMHM(HULL+tH= HMgHEHMHMHULL+t	H= HN(<HD$xH^(H]HV LL+tH= H]EWA(HGH  Hx uE(H HEH   HEHM{ D(D	 EYDXO(D$`    DEǆ       Ɔ          D֐	 D%	 D-|	 @      WD$hHt3 HRHHD$hHL$hH\$pD  H(  H(  HEH  HEHp  HEHD$hHEHHH+HHH3H~.@        f)HH;}	H(  LHM% D]HNhX  fA/  HEH;  LcuIL;wt%HO+ EtHfHGHG    H_E~LEN    HUHO; EG(Lcu IL;w t%HO EtHHGHG    H_ E~LE N    HUHOT; LcuIL;w8t%HO0y EtHHG0HG0    H_8E~LEN    HUHO0 ; Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L      H9\  HEH;  HWHM<{G(EHWHM%{HM   H   H;t=HOH    {   G(HOH   zHO0H   zLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L      HX[  H   H;t=HWH   YzG(   HWH   <zH   HW0,z     uf/w(\q9 (HNhU  f/v=H   HM8y   EXH   HMHyH   HM`yf/v\(iX(\(i(XLD$hL8  HL$xH   H   HEH8  HEH  HEHD$xHELMIHH+HHH3H~3@      (fAX)HH;}L8  H   MHM] HEHEHD$xHELt$xH]HuA()HEHP  L`  HEHp  HH  o fA/vqHEHP  HD$xHX  HtUHEH  L  HH  H  H  po fA/v"HL$h    9   }H]HL$h D$`   fnu^HE0H;t1HOHU8wEXG(HOHUHwHO0HU`wHU     V0W˒	 HV(I\}HL$x HM
 HM  HM H    H    H    HM` HMH HM8 H    H    H    HM} HMs HMi IL$0  I[HA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H	 H   EotEH    .LcHsHH{Lsp5X	 EW=T	 E   I$HEI|$HFH;t'H;tHW Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
	 ff     HE(WA)HH;}LEMHL$`D$ H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHMk    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMk EHSxHExHD$(H  HD$ L   L   HM. YEx   HExH   f/HF H{Lsp   H      H  HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(Hl0 t0Eu"A   EEHz	 H   .A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HMc HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$` I迕  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   Aa  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`H Y   SxE3;a  H   HCxMHH\  [pSh(\%I	 T   f/vA      8  f/vA        f/vA
      H  H9   rA(   ~TUpT]xH0  HMp f/HGHExf/HG^(  5}	 Yf/vA   !Hn[  @  Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]@SH0E3HADL$ A)   H[Ic d HA   H	 vAO   H	 gAO   H)	 XA6   Hj	 IAD   H	 :AC   H	 +A9   H	 AQ   HN	 
A   H	 HC   HLKD8&HH0[ %        4  HUSVWATAUAVAWHhH(  HE)p)xD)@HWEEH   E3E3H H   EotEH   `%LcHsHH{Lsp5}	 EW=}	 E   I$HEI|$HFH;t'H;tH Ht
HHL>H~LLEHEHD$`HEHD$hHEpHD$pHt$xLNIHH+HHHIH~1fo
ʇ	 ff     HE(WA)HH;}LEMHL$` H{H     A   uxLd$hH{XH|$pLwMuA(!I$HEHHEHD$`HEHM5c    Ch\Cp   HKHL$hH|$pMuA( HHEHHEHD$`HEHMb EHSxHExHD$(H   HD$ L   L   HM=& YEx   HExH   f/HF H{Lsp   H      H   HD$XH   HD$PH   HD$HLd$@HChHD$8HC8HD$0Ht$(H|$ MLC(H' t0Eu"A   EEH	 H   &&A#  ChIHChAHK8HC(HC8HK(HK@HC0HC@HK0I$HI$HIL$HGID$HOLsXHIHIHNIFHFINHC8HEHC(HEH{0LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~-     HEHM(f\A)HI;}LEMIHL$` M$LEHCHEH{ LUL;t-I;t!HM HtHHEL}LH}LELEHEHD$`HEHD$hHEpHD$pHEHD$xIHH+HLMIM~%HEHM(f\A)HI;}LEMIHL$`G I  (HEHEL9}t HEHD$hHEHD$xHL$` D(A(WfQH   LEHUHE   A|]  ((EIHMHEHD$`HEHD$hHEpHD$pLt$xMFIHH+HHHIH~1@ f     f(f^)HH;}MHMHL$`@ Y   SxE3\  H   HCxMHH[  [pSh(\%	 T   f/vA        f/vA         f/vA
      H   H9   rA(   ~TUpT]xH  HMp f/HGHExf/HG^  5(u	 Yf/vA   !H>Z     Y   f/DGHM HM AL$(  A(sA({E(CIA_A^A]A\_^[]LSH   ICHAC    H ICHx ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$X H HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    HI\ HL$(
 @SH0HD$ HٹX   l HD$@HSH^  HHtH@@HcHHB@HH0[@SH0HD$ HH HH= HA(HA@HcPH HD
@HA@HcPDBDD
<Hu HH HA(H0 H HHKHtHP tHC    H0[LSH   ICHAC    H# ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HH HD$P3HD$XHD$`HKHT$X H/ HD$(H# HD$PHD$hHcHHֻ HDhHD$hHcHDd    HyX HL$( @SH0HD$ HٹX    HD$@HSH]  HHtH@@HcHHB@HH0[@SH0HD$ HHw HHm HA(HA@HcPH" HD
@HA@HcPDBDD
<H HH HA(H0 H HHKHtHP tHC    H0[LH   ICAC    HQHC ICH ICAC   IK[H$ HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H6W HL$(
 @SH0HD$ HٹX    HD$@HSH\  HHtH@@HcHHB@HH0[@SH0HD$ HHg HH HAHA@HcPH HD
@HA@HcPDBDD
<H HH+ HAHI HtHP tHC     H5 HHKH0[H%Z @SHpHk H3HD$`HyHrLLHALD$PI HL$XL;tmH$   A8GըuIHL$@HL$ D$  HD$(   H\$0LD$8U @-H$   u	HHHtHL$`H3+ Hp[2HL$`H3 Hp[@SVWH   HD$8H H3H$   IHHA D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   Hc	 HL$@HD$x   HD$p    D$` A   H	 HL$`HD$@HD$ LL$`LHH贍H$   H33 HĐ   _^[@SVWH   HD$0H H3HD$xIHHAWf/w|HD$P   HD$H    D$8 A   Hr	 HL$8HD$p   HD$h    D$X A   H#	 HL$XHD$8HD$ LL$XLHHیHL$xH3] HĀ   _^[H\$HALL@IHH+HLIHHHHH    M   I(
I~M(BH~1HCHLR HLZ0fD  fAX
I fAXI HufXL;~	HfX(fXM;}mII+H|GIHBI+JHHHM@ f     XHXHXXHH HuM;}JM+XHIu(H\$M
   AL;~UI~5IHHIAHH   X@X@X X@H HuI;}IL+X HIuH\$DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_H1e H\$WH Hǽ HH   H HHb HAPHI8l HO b HOX Hy Ht
   H HH\$0H _H\$WH H HHH HAPHI8 HO  HO H Ht
   H HH\$0H _H\$WH H HH   H HHr HAPHI8| HO r HOh H Ht
  H HH\$0H _H\$WH H' HHH  HAPHI8
 HO   HO H Ht
   H HH\$0H _LHXICLL	IAI+HHIH;rQH( IC3ICICHC ICD$0ISIK He HD$8HA	 HL$8GHAI@IHH
HHXHUSVWATAUAVAWHH  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)H H3H@  D((UHHT$xLT$0\$8Hh  Lp  Hǅ     E3L  D   EFH	 H   Hǅ     L  D  h	 MA3HX	 H  EWfA/   Hǅ     L  D  EFH H  DHǅ8     L0  D   EFH H   H  HD$ L   LD$0H   H  'H  HrSHH  H=   r<t$ HAH;r H+Hs H'v H Hǅ     L  ƅ   H  HrSHH   H=   r<t HAH;r H+Hs H'v~ HM Hǅ     L  ƅ    A%   H	 H   Hǅ     L  ƅ   	 MA3Hr	 H  fE/   Hǅ     L  ƅ   A   H H  `Hǅ8     L0  ƅ    A   H H   -H  HD$ L   LD$8H   H  AH  H   Hǅ     L  ƅ    A   H 	 H   
Hǅ     L  ƅ   \ 	 MA3HL 	 H  x
L`  H   H  H   H   I$HPHMBI$HPHM0E(D-"h	 e	 T$0fn`  =hd	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`Hx  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   H H  gHH  HP H  Hǅ     L  ƅ   A=   H H  HH  HP H   D$pAA   D=n	 D5c	 @ LLEHIV  HMAu3H  (HHM+H   H     HUL(H  VHHUHML
sc	 HM02LHH  `HHM3H   H   H   H  u fEnEA(h ^HU0HM L
c	 H  BHHUHM2L(HMLHH  HHH   H   H   H   AƙA|$   A(LHIX  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyXBc	 ^HT$@P  D(H      HMX HH H   NBHHu3
H HcHHHW	   HMh HAHd HH BHH HHu3
H HcHHHW   HMxZ LHu3
HHcHHIPA   H    HA(Hü HH |AHHu3
H HcHHHW   H   ޻ HHDHۻ HHu3
H HcHHHW   H    H(H6 HH @HHu3
H HcHHHW   H   Q HHHN HHu3
H HcHHHWA(H  +D$pfn^=`	 |$83H  H  H  WH  _H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  H  H  HtHHH1H;  u   H  H  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  [H  H  Ht;HH+H;  u   H  %H  HtD	H  HH  IE L@H
 H  H;IuEAfD/vH H   >E2fE/vH H   >E2AD$ D;~!fE/wfA/vH H   P>HH   HPE   A(A\A^ATf/[	    Hǅ     H  D  Aa   H H  UHH  HP H  Hǅ     H  D  AH   H H  HH  HP H  H  Ht%L  L+IgW  H  HH  IHH   =[	 H|$xD;`     Hǅ     3H    DCiH= H  QHH  HP H  Hǅ     H    DCBH` H  HH  HP H  E2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHt(HM HM HM HM H@  H3 L$  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWHP  IǃA)sA){H7 H3H$(  MALHHL$`H$   HT$xDD$PL$   Iǃ    E3MEEGH" IVHǄ$     L$  D$   MA"H H$     HǄ$     L$  D$  EGHe H$   HǄ$      L$  D$  EGH H$   H$  HD$ L$  LD$PH$p  H$  H$  HrTHH$  H=   r<t HAH;r H+Hs H'v HP HǄ$     L$  Ƅ$   H$  HrTHH$p  H=   r<t0 HAH;r  H+Hs H'v H HǄ$     L$  Ƅ$p   A   HI H$p  \IH$p  IP H$  HrTHH$p  H=   r<t HAH;ru H+Hse H'vX H' (0^	 $  (
\	 $  U	 $  
Y	 $   MIHM  $   HHPH$   HHPH$   wV	 $   
uV	 $   U	 $   WL$hD$@ED|$X|$@   Ic  $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3H H$  HǄ$     L$  Ƅ$p   E3H H$p  wDLt$8H$  HD$0H$p  HD$(D΋蹲H$p  H$  ML$   IHL$`tG  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  GHH$   FH$  / H$     H$  
L$   H$p  dHH$   H$  L$   H$@  3LHH$  `HH$   /H$   H$   H$  { H$p  m fnf (^H$@  H$   L$   H$p  3HH$   H$  L(H$  hLHH$  HIH$  ұ H$  ı H$   H$p   &MIH\$`HI  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$p  HG H$  "4HH 4HL$h< HH2 3H$  AH
 |H	 3IH$p  IPHǄ$     L$  Ƅ$p   E3Hc H$p   IH$p  IP H$p  萾D$@ H$  nH$  @   A}$      f/$   6  H$p  H+ H$  3HH 2HL$h  HH 2IH$p  IPHǄ$     L$  Ƅ$p   E3Hh H$p  IH$p  IP H$p  蕽D$@ H$  sH$  E H$   $   D$hADd$XHSH$   HIH$   H$   EHǄ$     L$  Ƅ$   AJ   H) H$  ,HǄ$     L$  Ƅ$p   A   H H$p  HǄ$     L$  Ƅ$   i MA"HY H$  HǄ$      L$  Ƅ$   E3H H$  H$  HD$ L$  H$p  H$  uw  H$   έ H$    H$    H$    D$hH$(  H3 ($@  ($0  HP  A_A^A]A\_^[HUSVWATAUAVAWHH(  HE)p)xD)@D)xD)hD)XD)HD)8D)(D)Hx H3Hp  D((UHHT$xLT$0\$8H  L  HǅH     E3L@  D0  EFH
 H0  Hǅ     L  D   MA3H H  EWfA/   Hǅ     L  D   EFH H   Hǅh     L`  DP  EFH HP  SH   HD$ LP  LD$0H0  H  gkH  HrSHH  H=   r<td HAH;rT H+HsD H'v7 H Hǅ     L  ƅ   HH  HrSHH0  H=   r<t HAH;r۫ H+Hs˫ H'v H HǅH     L@  ƅ0   A%   H7 H0  Hǅ     L  ƅ    MA3H H  fE/   Hǅ     L  ƅ    A   H, H   Hǅh     L`  ƅP   A   H HP  mH   HD$ LP  LD$8H0  H  iH  H0  ׷HǅH     L@  ƅ0   A   H9 H0  Hǅ     L  ƅ    MA3H H  L  H0  H  H  @H0  3I$HPHMrI$HPHM`E(D-bM	 J	 T$0fn  =I	 YfAnD$ ^L$8HD$0HL$8f/HF, HcLt$`H]  HD$@HHL$HHD$XHD$PHǅ     L  ƅ   A!   H H  HH  HP H  9Hǅ     L  ƅ   A=   H H  WHH  HP H  ; D$pAA   D=-T	 D5H	 @ LLEHI~E  HMAu3H   غHHMH  U H      HU診L(H  VHHUHM L
H	 HMP2LHH   @HHM胾H  ݦ H   Ц H  ¦ H   fEnEA( ^HUPHML
NH	 H  BHHUHM L(HMLHH   HHH  / H   " H   H   AƙA|$   A(LHIG  D(D$0(A_D(\^ATLL$HILT$@I+HLD$`I;tHMu2HD$X0HT$XHLT$@LL$HI;IDHHT$PLD$`FHT$XHL$P?HT$XHt2LD$`HT$XLL$HLT$@HI;IDILD$`HL$PHT$XMA(u+Ht&@ f     X1HI;IDH;tHuWI*MyXH	 ^HT$@6  D(H   $   H   ! HH+ H   'HHu3
H HcHHHW	   H   ݡ HAH HH ?'HHUϡ HHu3
H HcHHHW   H    LHu3
HHcHHIPA   H   R HA(H HHL &HHu3
H HcHHHW   H    HH{H HHu3
H HcHHHW   HP  Ġ H(Hm HH &&HHu3
H HcHHHW   H0   HHH HHu3
H HcHHHWA(H . +D$pfn^=F	 |$83H  H  H  WH  H  HtDH  HH  HT$8H  H;sLHT$8H;wBH\$8H+HH;  u   H  2H  H  HtHHH1H;  u   H  H  H  Ht9H  H  HH  HT$0H;sLHT$0H;wBH\$0H+HH;  u   H  H  H  Ht;HH+H;  u   H  \H  HtD	H  HH  IE L@H
J H  H;Iu+AfD/vH H   #E2fE/vH H   #E2AD$ D;~!fE/wfA/vH H   #HH   HPE   A(A\A^ATf/$A	    Hǅ     H  D   Aa   H H   HH   HP H   Hǅ     H  D   AH   H H   <HH   HP H   έH  Ht%L  L+IW  H  Hh  耺Hh  S =C@	 H|$xD;     Hǅ     3H     DCiHt H   HH   HP H   Hǅ     H     DCBH H   ;HH   HP H   ͬE2AEuLD$HILL$PI+HHT$@HL$`H;|
IH+HH+IHD$PL+IHt_HM< HM2 HM' HM Hp  H3V L$(  A(sA({E(CE(KE(SE([E(cE(xE(hE(XIA_A^A]A\_^[]LSVWATAUAVAWH  IǃXA)sA){Hwi H3H$`  MALHHL$`H$   HT$xDD$PL$   Iǃ   E3MEEGHb IHǄ$     L$  D$  
 MA"H H$  U   HǄ$     L$   D$  EGH H$  HǄ$8     L$0  D$   EGHP H$   H$  HD$ L$   LD$PH$  H$  3H$  HrTHH$  H=   r<t HAH;rޜ H+HsΜ H'v H HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<tp HAH;r` H+HsP H'vC H HǄ$     L$  Ƅ$   A   H H$  IH$  IP H$  HrTHH$  H=   r<tś HAH;r H+Hs H'v Hg (pC	 $   (
AA	 $0  1;	 $@  
 ?	 $   MIHy<  $   HHPH$   輥HHPH$   觥;	 $   
;	 $   :	 $   WL$hD$@ED|$X|$@   Ic   $   |$p   |$H;  AHǄ$     L$  Ƅ$   E3HN H$  HǄ$     L$  Ƅ$   E3H H$  DLt$8H$  HD$0H$  HD$(D΋H$  +H$  ML$   IHL$`6  0E3Dd$X|$p|$HLl$xH$   HD$`t$PL$   H$   u:H$  HH$   H$   o H$     H$  轫L$   H$  dHH$   H$(  L$   H$X  3LHH$  @HH$   H$   ؗ H$  ʗ H$   H$   fn (^H$X  H$   L$   H$  3HH$   H$(  L(H$  hLHH$  HI色H$    H$   H$   H$   &MIH\$`H8  ,E3D$pDd$XLl$xH$   H\$`t$PL$   $   f/  f/$      H$  H H$  bHHP SHL$h| HHr 5H$  AHJ |HI IH$  IPHǄ$     L$  Ƅ$   E3H H$  @IH$  IP H$  УD$@ H$(  记H$(     A}$      f/$   6  H$  ˱Hk H$  FHH4 7HL$h` HH^ IH$  IPHǄ$     L$  Ƅ$   E3H H$  EIH$  IP H$  բD$@ H$(  賯H$(   H$   $   D$hADd$XHSH$  萡HIH$   = H$  / EHǄ$     L$   Ƅ$   AJ   Hi H$  lHǄ$     L$  Ƅ$   A   H H$  5HǄ$     L$  Ƅ$    MA"H H$  HǄ$8     L$0  Ƅ$    E3H# H$   H$   HD$ L$  H$  H$  \  H$    H$     H$    H$    D$hH$`  H3 ($  ($p  HĐ  A_A^A]A\_^[H\$
c4	 LH   Ip     @      MA LiN  IIIH+HHHHiL+EA@Hi  HHHH+HHHHiH+AHA;sD+
D+AWAIH*AYBf/qH\$LD$HT$SVWH   HD$0HHz0H$   HLD$ LLC(HI[  C(W>	 C(H$   H$   H0HHD$XHHCH;t/H;t"HI Ht
H脃H3H3H{3LLD$@HD$@HD$hHD$PHD$pH$   HD$xH$   LKIHH+HHHH~4fo
k=	 fff     HD$X(WA)HH;}LD$@MHL$h" HĐ   _^[@SH`HBHHD$(Hx uWY1	 XB(H`[H HL$8HD$@HD$ HD$P% Ym1	 XC(H`[@SH    Wf.HAxHH   zt9HhPY2	 \1	 Y   X1	 Y      H [H\$Ht$WH`HHyHr3HD$ HGH;t'H;tH Ht
H軁HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~'ff     HD$ ()HH;}HL$0HL$@ H\$xH$   H`_HWHp  HD$ HX)pHZ H3H$P  HHHL$0sxHE HL$@H( H$0  HL$0MLHHAPH$H  HrUHH$0  H=   r<t
 HAH;r H+Hs H'vݎ H謼 H$   H$   Ќ H$P  H3 H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HHHWPHUH_L  Y   H8  HD$ LHAH    HCHD$pWHx u(H HEHD$hHEHM~ (Y
.	 XK(MHEHH#H      H;v
~0	 (  \f/   vƇ   \H(  f/v(\U
H(  X \(<
XH(   f/vH0   X-	 ( H0  X  H;t/HSHNyHC(HF(HSHNdHS0HN0WLG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~"A(fX)HH;}
LEHMMHL$hBX HMHLHT$hP(HH   HHHHPHKHHHSHL$h HHEHsH   HCH;t'H;tH Ht
H,}HH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h+ H       D  HY(WEHt34 Ht|HEH] =.	 } H  H[WEHt3 H7|HHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$h    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   H1u2  HSHM01}H  L@LEWEMt3 HMzHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMW H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(\(Xu \I(XuuHUH(  H)Ef/w"\ (H   Hhnf/vHE0H;tHU0H0WEH]HHt3߆ HyLHEH]LEHuHEHEHEHEH;t-I HtHxLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM[ LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM_R LML   H   H   HML HMA HM`6 HMH, HM8" HM HM L$  I[0A(sA({E(CE(KI_^]HT$SVWH`HD$ HHLAL+HgfffffffIHHH?HH;   H2  HH$   H\$0HD$8    HK H$   L$   H$   H;LCM HT$PHL$0/  HHL$0H@HD$8H\$@HD$H    (D$0fD$0LHT$@HL$0J LLHHg0  H`_^[HL$WH0HD$ H\$PHH3HOHOHOHO HO(HO0HO8HO@HOHHOPHOXHO`H   H@   HHHxrH   H   H\$HHK     HH   HKHCHCH-C6?H   H?H   H-q=H  HMbP?H   HǇ  '  H      ?H0  H:0yE>H  H   H8  H     @H(  H     @@H@  HH\$PH0_@SHpahHAHT%.	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h
 f/0  s0  ^W.	 Hp[HUATAUAVAWHhH   HE/HXHpHx ILHHQ HMHHEH[IG3H;t'H;tI Ht
HsII?I_MLEHEHEHEHEHEgHEL}MOIHH+HHHHH~0fo
-	 f     HE(WA)HH;}LEMHM HuHLmIH]H~  HtHFH;`  (EfEHuH~H}HEH;8uHxfEHuLvLuHEL;0uLpfEHuHFHEHMH;uHAHHEL}MgMuW"H HEIHEHEHEHM (Yg(eMFLEIHMHEHEHEHEHEgHEL}IHH+HHH3H~:fD  (A((ffYf\)HH;}LE]HMMHM Ae HuH^H;uH^H(IF0EIHMHEHEHEHEHEgHEL}MGIHH+HHHHH~((f(fY)HH;}EHMHMpJ H~  tH~LeIH   E3fHGHEL}MwMuWH HEIHEHEHEHMG Y\MLGLEIHMHEHEHEHEHEgHEL}IHH+HHHIH~0fffAY(fX)HH;}LEMHMMHM H(H;~uH>H;~IDHHMtLE'M+IIL$   I[8Is@I{HIA_A^A]A\]HUWAVHhH   HEHXHp)p)xD)@D)HEIHHHULEEWIx uE(#HHEI HEHEHEHM D(=	 EtCH]H{ uA(HHEHEHEHMn (A^H*  HG     (A^}gH]H{ uA(HHEHEHEHMn D^DG0DMWEWMHUH@  HM}| HMs| HEgHEH]HuHOH;uHOMgIHHUC (L$   I[(Is0A(sA({E(CE(KIA^_]H3HAH-q=HAHAHA HA(HA0HA8HA@HAHHAPHAXHA`H   Hǁ         H   H   H   H-C6?H   H?H   HMbP?H   H      ?H   H  H:0yE>H   H  H     @H  H     @@H   HHǁ   '  H   @SHpahHAHT%j'	 HHHD$(HL$0Hy uW$H HD$HHHL$@HD$XHD$ HD$h9 f/  s  ^W'	 Hp[HWH   H@HXHpHHHHL@@@HPHH2t HsHG3H;t'H;tHz Ht
HWlHHHwHHL$(HD$(HD$8HD$XHD$@H$   HD$HH|$PLGIHH+HHHH~3fo
K&	 fff     HD$`(W)HH;}HL$(HL$8 HL$pry L$   I[Is I_HUAVAWHl$Hp  HEHXHpHxL` )p)xD)@D)HEMLHWD$03Ht$@HULEWI9puD((HHD$PI HD$`HD$xHD$pHL$HZ D(5~	 D(E^ID$I^H]H]D$xEMMHEDMLeLu HHuH\$8CHHH;tHHHt3:x HzjHD$0H\$8HH\$@3H~SL    LD$0@ 3H~0IfD  H;u((HHH\$8H;|Ht$@HMH;|LE HUHL$0 E   LuI~ tIHD$PHD$xHD$`HL$Hli (A^^H\$8H]HD$@HEuHD$0HEHD$0HEHOH;uH9_tbHtHHHH;tHHHGHH;t"Hv Ht
H:iHH    H_H_LEHT$xHUH   (HD$0HD$HH|$PD$HD$xHD$0HEWD$HHD$X    H\$8HtJHHHH;tHHHt3Tv HhHD$HH\$PH\$XLEHT$xHL$HK H\$HL|$XLt$PHOI;uL9tgMt$MtHHIL;tkIIHGHH;t"Hu Ht
H hHH    LwLLHGE3L9W~UH4    @ E3H~1N    IHff     HHIHIIHGL;|ILHL;W|HL$H4u ID$HEDMLeLeLEHT$xHD HL$0 u (L$p  I[ Is(I{0Mc8A(sA({E(CE(KIA_A^]DD$HL$WH0HD$ H\$HHHD$P    Hd HA@H[i HAPD$P   rWH HH0j HG(HG@HcHH
c HD9@HG@HcHQT9<HHHH\$HH0_DD$HL$WH0HD$ H\$HHHD$P    H6d HA@Hh HAPD$P   UHb HH] HG(HG@HcHHE] HD9@HG@HcHQT9<HH>HH\$HH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHc HA@Hg HAPD$P   QHg] HHOHd HHG@HcPHe HD:@HG@HcPDBDD:<HSHHD聽HH\$HHt$XH0_HL$HH	 LL$P)t$0LD$X3)|$ 5	 =4	 Tf/vEs  "   _	 LL$PLD$X3趏Tf/vs  "   	 LL$PLD$X3舏Tf/vr  "   	 LL$PLD$X3ZTf/vr  "   =	 LL$PLD$X3,Tf/vr  "   '	 LL$PLD$X3Tf/v_r  "   (t$0(|$ HHH\$ LD$UVWAVAWH@IILHI+LHHMV  LIHYIH+HH;   I+HHHH+H;sH
 mn 3Ld$xM+L$3IIHH+II;HCI;LCIH$   HH+LL$   HH/HIL$   L+o LGH3H$   IL+o HHGH+HHHtLGL+I@KLd$xHGIHGL7@  LL+IHH;   H$   H    HHD$po HOLD$pHH+$   HH+H#/H_3H$   HGH+LL+IIH;LGM   D$pff     HHII;u   H$   L4    H)t$0I+MH0xn H$   ILkHGL+LI+HRn H$   IH;t!f     2HH$   IH;u(t$0HH$   HIIH@A_A^_^]HHHWAVAWHPH@HXHhHp )pLW@3HpIH9r m  HZH`  L@HxI;   H;   HH+HL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(!Ht$8LD$0H|$(M   HxL;ukHI+HHs[L+III+H   IPH+HHHIH+HE3H;LCL;ICHL$(Ht$8LD$0H|$(MtHI ILD$0HI;^uII;^t0Ht+H
 j H
 j LD$0H|$(IH+HHHDL$pHHj 3HthH+HI;vm H    H=   r=@tjm HGH;rZm H+HsJm H'v=m HH	 (L\$PI[(Ik0Is8(t$@IA_A^_@USVWAVAWHl$H   HEH7 H3HEMIHHHE   E3L}D}EGHì HMBHE   L}D}EGH HMHE   L}D}U MA'HE HMG DF D;tD$ LMHUHMHEHrPHHMH=   r<t
l HAH;rk H+Hsk H'vk H诙 HE   L}E HEHrPHHMH=   r<tk HAH;rk H+Hsk H'vvk HE HE   L}E HEHrPHHMH=   r<t9k HAH;r)k H+Hsk H'vk Hۘ HE   L}E A   H. HMuHE   L}E A   HϪ HMNHE   L}E  MA'Hv HMHCHHDG D;tHL$ LMHUHMEHEHrPHHMH=   r<t8j HAH;r(j H+Hsj H'vj Hڗ HE   L}E HEHrPHHMH=   r<ti HAH;ri H+Hsi H'vi Hp HE   L}E HEHrPHHMH=   r<tdi HAH;rTi H+HsDi H'v7i H Lt$0HCHD$(CD$ LKLHH/  HMH3c Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HH3 H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ Ht3ug HYHD$@H\$HDt$8Aމ\$4D		 fD  A;]  M}AA|$  ~1I@ H\$@MA((< HA;t$ |ڋ|$0LD$@H$   I!HHL$@HHT$@HPHL$HHHHT$HH$   f H1f H$   Hc H$   H$8  e |$0E3H$   H$   e H$   HcHH^ H   H$   HcHh   H$   HD$hH$   b L=Y L$   L$   D$(  HT$@IM   (D$hH$  H$   跀HXH$  HrTHH$  H=   r<tf HAH;rof H+Hs_f H'vRf H! HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   H H$  萮HǄ$     L$  Ƅ$   < MA"H, H$  Ot$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   H H$   HǄ$     L$  Ƅ$   A   H- H$  H$   HD$ L$  LD$hH$  H$  #H$  HrTHH$  H=   r<td HAH;rd H+Hsd H'vd Hm HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<tMd HAH;r=d H+Hs-d H'v d H DXDL$P\$4É\$4H$   HcHHV[ H   H$   HcHh   L$   H$   PH$   a H$   ` H$8  a `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I((AXHL$@Mb (H$(  H3肉 L$p  A(sA({E(CE(KIA_A^A]A\_^[@USVWAVAWHl$H   HEH- H3HEMIHHHE   E3L}D}EGH HM"HE   L}D}EGH HMHE   L}D}5 MA'H% HM̪G(DF(D;tD$ LMHUHMjHEHrPHHMH=   r<ta HAH;ra H+Hsa H'va H菏 HE   L}E HEHrPHHMH=   r<ta HAH;rsa H+Hsca H'vVa H% HE   L}E HEHrPHHMH=   r<ta HAH;r	a H+Hs` H'v` H軎 HE   L}E A   H HMUHE   L}E A   H HM.HE   L}E f MA'HV HMHCHHDG(D;tHL$ LMHUHM%HEHrPHHMH=   r<t` HAH;r` H+Hs_ H'v_ H躍 HE   L}E HEHrPHHMH=   r<t_ HAH;r_ H+Hs_ H'v_ HP HE   L}E HEHrPHHMH=   r<tD_ HAH;r4_ H+Hs$_ H'v_ H Lt$0HCHD$(CD$ LKLHH  HMH3C Hĸ   A_A^_^[]HSVWATAUAVAWHp  Hǀ)p)xD)@D)HH) H3H$(  LD$`LLHL$XHT$xL$   E3ADt$0WD(|$PWD$@HcZ(Ht3U] HOHD$@H\$HDt$8Aމ\$4D fD  A;]  M}AA|$( ~1I@ H\$@MA(( HA;t$(|ڋ|$0LD$@H$   I聂HHL$@HHT$@HPHL$HHHHT$HH$   \ H\ H$   HX H$   H$8  [ |$0E3H$   H$   c[ H$   HcHHT H   H$   HcHh   H$   HD$hH$   X L=O L$   L$   D$(  HT$@IM   (D$hH$  H$   vHXH$  HrTHH$  H=   r<t_\ HAH;rO\ H+Hs?\ H'v2\ H HtHt$`HH$   HPHǄ$     L$  Ƅ$   A   Hu H$  pHǄ$     L$  Ƅ$    MA"H H$  /t$pHD$pH      H#H;   HǄ$     L$  Ƅ$    A   H| H$   ףHǄ$     L$  Ƅ$   A   H
 H$  蠣H$   HD$ L$  LD$hH$  H$  H$  HrTHH$  H=   r<tZ HAH;rZ H+HsZ H'v~Z HM HǄ$     L$  Ƅ$   H$  HrTHH$  H=   r<t-Z HAH;rZ H+Hs
Z H'v Z Hχ DXDL$P\$4É\$4H$   HcHH6Q H   H$   HcHh   L$   H$   0H$   W H$   V H$8  W `E3DL$PWLl$XLd$xL$   LD$`|$0\$4 fAnED^I|(AXHL$@-X (H$(  H3b L$p  A(sA({E(CE(KIA_A^A]A\_^[@UVWHHPHEH\$pH# H3HEIHHE   3Hu@uDFnHǙ HMHHUHP@HEHrPHHMH=   r<tCX HAH;r3X H+Hs#X H'vX H HHPHE   HuE 8 uLIIB<  uHHMhHHUHP@HEHrPHHMH=   r<tW HAH;rW H+Hs}W H'vpW H? HE   HuE A   H HMٟHHUHP@HEHrPHHMH=   r<tW HAH;rV H+HsV H'vV H谄 HE   HuE Ah   H HMJHHUHP@HEHrPHHMH=   r<tV HAH;roV H+Hs_V H'vRV H! HE   HuE E3Hr HM辞HHUHP@HEHrPHHMH=   r<tU HAH;rU H+HsU H'vU H蕃 HMH3| H\$pHP_^]H\$WH0LHLILT$ LL$(M~cMuMJI:IH+IgfffffffIHHHH?HL;~IJIH+HHHH?HL+KHL+      IM~_IzIgfffffffHII+HHHH?HL;|I+:IHHHH?HL+KMLL$(M;Ju!E3yIHL$ I  LL$(LT$ LHLKH\$@H0_H\$Hl$Ht$H|$ AVH IIHH   LVIgfffffffL+IIHLI?LH   HH>H+H~IHHHH?HHH\$0HH;HV HNHDH|$HHnHl$8Ht$@H A^H\$VH 3HH9q vGH|$0fD  H{HOR HOR HC(HHCH;CuHHCH;s rH|$0H\$8H ^H(HtnHfffffffL;v*S KHH=   r<tS HBH;rR H+HsR H'vR HHH(驀 H(LHXICHfffffffH;vJHSZ IC3ICICHF ICD$0ISIKP Hh> HD$8HL$8  Hu3KH;vN HHH   r&HA'H;wN H{ HH'HHA{ HHHXH\$Ht$H|$ UHHpHHY8HzHHEHCH;t+H;t"HP Ht
HCHH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~ @ HE(A)HH;}LEMHM HLFhLNH     HFH^HHEH~HCH;t+H;t"HP Ht
HIBHH    H{LHEHE3HELELKHEHEHEIHH]H+HHHH~)fo
B fHE(WA)HH;}LEMHM H   Hǆ       H2l E3L\$pI[Is I{(I]鿘HW EHEHU3HMHEHEHǒ HEmN HG H
 HEHM LALIIHQ I+HH;|
IH+HH+IHHAHtL+I̌H\$WH HJ HHAPHI8N HO zN HOpN H@ Ht
   H} HH\$0H _@SH HHI%N HKH [H%N @SH LHH~LIH|$0MuHLHLHgfffffffIHMI+HHHH?HL;~IJHI+HHHH?HL+H|$0KHL+HLKH [MyII   HH [HHHWATAUAVAWHPH@HXHp)pMMHHHRH(oWE3EL9{~HN(HJJIL;S|HFXLFLN@HV(H5k WAE H^HH+^@HI;^tIL Ht
H>IM>I^HFHH+F@HH      H   LF@MID  A $   H$   H#H;t)IWKIIHFHH+F@HL;r,HN HtH HHZ\J    cAE $   H$   H#H;t3@HN Ht+H HHÏ HHI       L\$PI[8Is@(t$@IA_A^A]A\_@SH LHH~{LYLH|$0HgfffffffHIJLM+IHHH?HL;|I+
HHHHH?HL+H|$0KIHHKI;Ju!HC    H [MyIIHH [LHXICHH;vJH#S IC3ICICH ICD$0ISIKI H87 HD$8HL$8  Hu3	HXFHXHhHL$(Hy uWWfQHhHHL$8HD$@HD$ HD$P; WfQHhHL$UVWAVAWH0HD$ H\$pHHHjLrHL$hE3L9LyLyMt$HtHHHL;t	IHHt3lI H;HLsHkHnH{ H|$hH|$hL?LHt33I H) HHoHnH{0H|$hL?LHt3I HC;HHoC@   CD HH8 HH\$pH0A_A^_^]@SUAVH MHHH;t}Ht$@IpH|$HL|$PMxfIrIIH{rHHH{LH;LBMt	! uH;rv	H H;uH|$HHHt$@L|$PH A^][HH A^][H\$ LD$HT$VH 3IH+HHHHAHAHteHH;vH
z iE HH|$0ӫHT$8HHFHHH\$@HNH+H>LHF H;H|$0HFH\$HH ^@USVWAVAWH$xH  HD$PH@ H3HEpMMHHH   D$     HC HD$`HMPF D$    E3E3HT$hHL$`F HD$`HcHH 0 HD`HD$`HcHDxDD\   HL$hWHHL$`HHwc HHHHi HIHID HHHUPHL$`cHxrH H
N HL$(3HL$0HL$8HD$@D$HHT$0HL$@sE H; HD$(H
 HL$( @SH`W)t$Pf/D)D$0D(   u+DW_ 3A(WM (t$PD(D$0H`[ fA/DW' A(v(
 \((t$PD(D$0H`[3bX (t$PD(D$0H`[5q fA/)|$@D)L$ D
 !   fA/vTfD.z  Ծ eH%X      HЋ9   % AYDY AX   eH%X      HЋ9 
  A(AY(Y((Y%R (Y
_ Y7 X%' X
7 X YYY' X% X
 YX XYX^X% AY  3t
  fA/   eH%X   = fA/   HЋ   9   A(A(\AYW (YP ((Y0 (Y (Y
j X X A^X
= YYYX X
 YYX(Y X
 X X YX YX^X Y   fA/   9 '  A(A(\AYW (YX ((Y (Y (Y
 X Xz A^X
 YYYXQ X
 YYX(Y X" Xj YXX
J ^X Y  E fA/   9p   A(A(\5 AY(W' Yh ((Y (Y (Y
2 X X A^X
 YYYXi X
 YYX(Y X: X YXX
 ^X> Y   9o Z  A(A(A^AY(YWI 莑 ((Y6 (Y# (Y
8 X X A^X
 YYYX X X
 YYYX X
 X(Y X YX YX^XT Y(|$@t	D\A(D(L$ ((t$PD(D$0H`[H
 h = 4 H
q ] lh H
 h =x ( H
d (
M  V  (  p 
 (
" 
 
 g qH
* 9h = V( H
 (
; t (
  ( 
h (
   
 (
D  
 \g H
 g = ({ H
 (
= f (O 
h (
Q j ( 
| (
 ~ 
 f [H
 -g = .( H
 (
  ( 
 (
  ( 
> (
 @ 
I `f H
 f = (? H
 (
  (  |  ( 
 (
   
y (
  
 e H\$D$WH`)t$PI)|$@H(D)D$0 f/   (} f.zuo= W  !   t  (D5 (Wf/ WvW 3 D(E3(LHXD\( D\  ) f/vfWf.zo| (
 Tf/vɌ D(DWg     ^\& T蜌 D(    f/v$((\ \
I (4 D(of/= r! f/v(: < D(DHL$pV' D((X \Z  \ \=E YDXA(H\$x(t$P(|$@D(D$0H`_HheH%X   
 )t$P)|$@   HD)D$0D)L$ D(ȋ
9    DX
 5J D(A(AYD^A(A(AYL v EX
a YYA^XD X
4 D(L$ X(t$PYYX
 X
 YY(|$@X AYXX AYD(D$0\HhH
H c =< ( H
( (
 )~ ( )
 (
) ) )
 Rb H8eH%X   
1 A   )t$ (HB9    (\5 \- (\-
 Y\-A ((Y% (Yп (Y
 X% X Y X
 YX YX%m YXa YX
M YYY(t$ XX( X%( X^YY- X(H8H
 a =  H
 (
 Q (z  (|  (^ 
 (
   
 (
  
| ` HH   )xD)@D(DT D)HD(DT
  D)PE(D)XD) fE/D)`D(EYrA(A(A(s (    fA/A()$   r;< (A(/< =  < (A(t< (XY= YA(E^\A(A( ($   \D(\$@WD(T$PD(L$`D(D$pfA/D(d$0vW= (($   HĨ   @USVWAVHl$H  HD$PH5 H3HEpMHHH   D$     H2 HD$`HMH5 D$    E3E3HT$hHL$`5 HD$`HcHH HD`HD$`HcHDxDD\   HL$hOHHL$`HHoR 袸HHǼHH}X 舸HI譼HH9R nHH蓼HUPHL$`uRHxrH H
= HL$(3HL$0HL$8HD$@D$HHT$0HL$@h4 H4 HD$(Hu
 HL$(o H@Hx)p()xD)@D D)HD
 fD/D)PEWA(rPA(\(pt (\f/
 vAXfA.z   = Y(a ^fA.z   f/5< r
(ZX
@ f/v!ff     AXA(f/^XwfD/vfA(^AX\fD/w(p(t$`XD(D$@D(L$0D(T$ ((|$PHxD\L$   HTx H
% D$    L$   H.x H
  @USVWAVHl$H  HD$PH5
 H3HEpMHHH   D$     H/ HD$`HMH2 D$    E3E3HT$hHL$`2 HD$`HcHH HD`HD$`HcHDxDD\   HL$hOHHL$`HHoO 袵HHǹHH}U 舵HI譹HHf nHH蓹HUPHL$`uOHxrH H
: HL$(3HL$0HL$8HD$@D$HHT$0HL$@h1 H1 HD$(Hu
 HL$(l HHXDH L@UVWATAUAVAWHhH   LqE3LLAAINHM_HH   Le)p5 )xWD)@D/ D)HD
I H;}gMLIIL+fff     IM J
T(LTTTXTAYf/sfD/rLHIuIDf.O  I  HHHM_D($   D($   ($   ($   IkE   H;DODeoZ  MHN  Le@ fff     MU IOLt$8LD$0Ll$HL|$PIEHD$`   A L;  I~fMNIH    If/v(HIf/v(HP	f/v(HPIf/v(HPHH I;|HM_I;}Af/v(HHI;|H   CIIKAI|$I$HIHH|$8HLd$HL\$PL|$XH|$`H}H}LHLEHT$0HEHEHEHEHEwHEHD$0HEHUuHHڃH;HLHH+yHHHML3H4Cv H;}&HEHM(HE)HH;|LHMH< HM_E3IIL;&Eo_IkHH;H_H~     Df.ztHHI$LIM LLt$(HD$ i E3AH$H  H   A_A^A]A\_^]H   HD$ HH$   : HHL$(: H
 HL$(g @SH0HD$     JHH0[@SH0HD$     
  HH0[HD@HHUVWATAUAVAWHH   HEHX)pHLLqL+1IfInflH.  3DAIU IEH+HHt!IEH+Hf     DHH;rAH]EuH  MEL+INZe  WEE3LeA   IH}M;s  HEf     II+H]XHMXH;   HMXH;   H]XH+HI;uqIH+HHsaH+HIH+H   HPL+IIHIH+IE3I;LCL;ICHMqLeHEH}IH   HHzI;umIH+HHs]H+HIH+HruHPL+IIHIH+IE3I;LCL;ICHMLeHEH}IHtHHHEIM;w!H
^ ( H
] ( H]3MtyIrTIƃIH+foI f     ofoffoDfoffLHH;rI;s@ IH+HHHI;rEP    WEHE    LEPIHMHUH6H?HMHthHEH+HH;vD+ H    H=   r<t(+ HAH;r+ H+Hs+ H'v* HX A   L}XI;      HVHHM/E3AH]Mt&LIE BB9rFHI;rBLFHEI;soHHMH;wcHMH+H*HLIIH?LL;Fu
   HTHNHMKHHHMHt	H]L}X1L;Fu
   HzTHNHMXHMHt
HUPH]HFHtRHEH+HH?H;wfH    H=   r uJHCH;s:H+Hr*H'wHH`W IL}XL;}s(p) i) b) [) T) HtsL+IHL;v2) J    H=   r=@t) HGH;r) H+Hs( H'v( HHV IM H   IEH+HH?H;v( H    H=   r<t( HAH;r( H+Hsr( H've( H4V 3IE IEIEH$   (t$pHĀ   A_A^A]A\_^]LSVWATAUAVAWH   IǃA)sA){H
 H3H$  LL$hMLD$`HT$PLHL$@I`H$   L$   L$   $  $   H$  H|$HH|$8H$  HL$p3t$4Iu IuIuD$4   W$   IXD$12ۈ\$0D$xI0HT$xDL$   HD$xL+IMtTHADl$1fI$HIPD"I$HIP@
IH M;r@|$0Dl$1H|$HLl$@\$0 f/T$2|$1 uud   D|$4D|$4AωL$@I      D$H;  T$ (LD$hHT$PH$   2 V  H$  H$   HL;   IM Ht~IEH+HHH;v& H    H=   r<t% HAH;r% H+Hs% H'v% HS Iu IuIuHIE HCIEHCIEH3HsHsH$  H  H$  H+HHH;vO% H    H=   r<t3% HAH;r#% H+Hs% H'v% HR   H$ H$  L$  H$   H$  Hj# H$   HS  H$0  H$  " AD|$4E3H$8  H$   " H$   HcHH H   H$   HcHh  H$8  HD$XH$8  
  H H$8  H$  $  ML$   H$  HL$PH$  H$   =HXH$  HrTHH$  H=   r<t# HAH;r# H+Hs# H'v# HRQ HtHH$   HPH$   HcHH H   H$   HcHh  H H$8  H$8  vH$8  ! H$@  O  H$  ! H! H$   Hj H$0  H$  ! AD|$4E3H$8  H$     H$   HcHH H   H$   HcHh  H$8  HD$XH$8  ! H) H$8  H$  $  L$   IHL$PM5 (H$  H$   <HXH$  HrTHH$  H=   r<t! HAH;r! H+Hs! H'v! HoO HtHH$   HPt$XHD$XI#I;1  HǄ$     H$  Ƅ$   A   H H$  iHH$  HP H$  [.HǄ$     H$  Ƅ$   A>   H H$  uiHH$  HP H$  .HǄ$     H$  Ƅ$   A4   H H$  iHH$  HP H$  -H$  :H$  c H$   y  H$  ;W$  H$  A  L$  L$   IHL$P  +fn^5] H$  H$  9HXH$  ,HtHH$  HPHL$  L$  M+IM  E,  AD$XHD$XH      H#H;  HǄ$     H$  Ƅ$   A   H H$  gHH$  HP H$  8,HǄ$     H$  Ƅ$   A8   Ho H$  RgHH$  HP H$  +HǄ$     H$  Ƅ$   A4   HA H$  fHH$  HP H$  +E2HI;EulMtL$  M+IIL[H$(  >8H$(   H$  "8H$   H$   FwLd$`4  $   J  HǄ$     H$  Ƅ$   E3H& H$  fHH$  HP H$  *H$  8HF H$  iH( HH NHH$  HPH$  8Y5 H@ H$  HH	 HH H(! HHϷ ڞHH$  HPHǄ$     H$  Ƅ$   A%   H H$  eHH$  HP H$  )HǄ$     H$  Ƅ$   E3HD% H$  dHH$  HP H$  @)HǄ$     H$  Ƅ$   E3H$ H$  ]dHH$  HP H$  (H$(  5H$(   H$(  5H$(   MtL$  M+IIXH$(  z5H$(  L H$  ^5H$  0 H$   tD$HL$@T$2   H$  #5H$   H$   Gt3L$   H$   HD$PL$   Ld$`H$   HD$h$   H|$8D|$4I      D$H\$0L$@T$2;  |$1 `  X  HǄ$     H$  $  E3HZ# H$  bHH$  HP H$  C'H$  5H~ H$  H(- HH H( HH0 ˛HH= 輛HȋT$@ HH 蠛HH$  HPHǄ$     H$  Ƅ$   Ae   H H$  aHH$  HP H$  Y&H$(  ;3H$(  
 H  H$   3H$   H$   H
 H$   Ƅ$   H$   H$    H H$   H)
 H$   Q HL$pHIPH\$xHt(H$   HL$   L+IH+SH$   HtL$   L+IDIH$  H3v> ($  ($   H   A_A^A]A\_^[HUVWATAUAVAWHxHP  HD$xHX )p)xH
 H3H   (MLHT$`HL  L  H  3ۉ\$DH   3WD$HH\$XLL$HMIH(H  H   >1HXH  HrSHH  H=   r<t HAH;r H+Hs H'v HD H   IH   IPH  H   0HLAH H;t
HHAАH  HrSHH  H=   r<t^ HAH;rN H+Hs> H'v1 H D W  Hǅ      t$(H  HD$ MMIH7 H  H   /HXH  HrSHH  H=   r<t HAH;r H+Hs H'v HPC H   IH   IPH  H   T/HLAH- H;t
HHAАH  Hr\HH  H=   r<t HAH;r H+Hs H'v HB H E3EDd$@H  F0Hv H  H( HH;tHPH  H  u.HLAH;t
HHAАH  HrSHH  H=   r<t, HAH;r H+Hs H'v HA HH;tHPHǅ     L  ƅ   E3H H  Q\IH  IP H  HrSHH  H=   r<t} HAH;rm H+Hs] H'vP HA IH  IPHǅ     L  ƅ   E3HU H  [IH  IP H  HrSHH  H=   r<t HAH;r H+Hs H'v Hn@ H  ".
   HL$h! H  HcQH  HHP   H    HHr H  ^HHuI
H HcHHHW   HM HHL H HHuI
H HcHHHW   HMt HH6 HHHuI
H HcHHHW   HM6 HH H褓HHuI
H HcHHHWH HxH  H  E+HLAH  H;t
HHAАH  HrSHH  H=   r<t HAH;r H+Hs H'v H> IH  IPIGI+HH\$HH  H  HLl$HL+HH|$hH
}+  =
 H HEH HEHMH L$DE3HUHMf HEHcHH HD
HEHcHhT
HEH   HM H HE3HE0E8IHHH   
   HMf HMHcQHMHHP   HMB LIHM HHu3
H HcHHIWA   HM LH   H HHu3
H HcHHIWA   H    LB+Hf HHu3
H HcHHIWA   H   LH' HHu3
H HcHHIWAB+\H H   HM(HLAHh H;t
HHAАH   IHUIPB+\Tf/vD$@HMHh(HMH> IHL|$`IGI+HL;H|$hH
)Dl$@H  H\$HHX  (HX   HX  'HX   HtL  L+IHJHtLD$XL+IHJHX  'HX  ~ AH   H33 L$P  I[XA(sA({IA_A^A]A\_^]LWATAUAVAWH  IǃI[IsA)sA){E)CE)KE)SH
 H3H$  HLD EWW$   Iǃ    IMIǃ    Iǃ    H
HBH+HHueH I3IIH1A HD$(D$0IHL$(
 HN H$  H@ H$  *HǄ$      $   HBH+HHwiH H$  3H$  H$  H@ HD$(D$0H$  HL$(
 H H$  H4@ H$     H$   A$   WL$8E3LL$HMce`IMt$M;v
H
<  IHL$8pLL$HE3HT$@LD$8fD  M;  HFH+HH;riH H$  3H$  H$  H? HD$(D$0H$  HL$("	 H H$  H<? H$  HHH$   H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
;  HM+IIHIH+IE3I;LCL;ICHL$8QoLL$HHT$@LD$8H   IH   I;usIH+HHscI+HIH+Hs
H
N; 0 HM+IIHIH+IE3I;LCL;ICHL$8nLL$HHT$@LD$8Ht2HHT$@IH$  Y AXD$(WD$PE3Ld$`Mc},MtM;v
H
:  IHL$PEnMH\$XHt$P     M;   H$  *(D$ HD$ H;sDHD$ H;w:H|$ H+HH;\$`u   HL$PGH\$XHt$PHt2HH)H;\$`u   HL$P}GH\$XHt$PHt3HH\$XIY    HǄ$     L$  Ƅ$   A   H*7 H$  iPHǄ$     L$   Ƅ$   A   H{8 H$  2PEE`EyH$  H$  裁H$  H$  IcU`HL$pILD$xIHT$pH+HHt.Lf     EHLD$xIHT$pH+HH;rIL+IMtDHHD$xH+D$pHH;r   = fD  A;]`5  H    HǄ$(     L$   Ƅ$   A   H5 H$  OHǄ$     L$  Ƅ$   A   H5 H$  NHcI   L$  HtHL$  HHL$8\6Y0WHǄ$     L$   Ƅ$   A   H6 H$  kNL$  HHL$p0H$  H$  H$  AAM`;}    HǄ$     L$   Ƅ$   A   H$ H$  MHǄ$(     L$   Ƅ$   A   H|$ H$  MEE(EyH$  H$  H$  H$  IcU(H$  
IL$  IH$  H+HHt+LEHL$  IH$  H+HH;rIL+IMt$fDHH$  H+$  HH;r~ "   D$h   Dd$ LD$hHT$ H$   ` D$ HT$ H$   z~ #   D$    Dd$hLD$ HT$hH$    D$ HT$ H$   4~ $   Dd$ M   HT$ HL$8ݰ D$ HT$ H$   E} %    D$hDd$ LD$hHT$ HL$(4 D$ HT$ H$   } &   Dd$ M   HT$ HL$P D$ HT$ H$      D$   D$   fD  A;}("  H} *   HǄ$     L$  Ƅ$p   A   H! H$p  KHǄ$h     L$`  Ƅ$P   A   H1 H$P  JHǄ$H     L$@  Ƅ$0   A   H! H$0  JHǄ$     L$   Ƅ$   A   HB1 H$  qJHcL$p  HIMhID  HT$8H}(IM0L$P  HLL$0  HIMhD  HT$pH}(I   L$  HC  HT$PH}AXAY6AXXXHǄ$(     L$   Ƅ$   A   H~  H$  IL$  HH$  40H$  #H$  H$0  H$P  
H$p  
&{ ,   IMHLD$(H$  贸 D$(HT$(H$   <	H$  HtL$  L+Iz=HT$pHt%L$   L+I[=WD$pL$   HT$PHtLD$`L+I/=HT$8HtLD$HL+I=DT$(HT$(H$   H$   Lw (H$   HtL$   L+I<(H$  H3% L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_HLH L@HPHHSVWATAVAWH  Hǀp)p)xD)@D)HMHLWD$@E3Lt$P@LPH@HD$ LL$@1" D($h  H^H+HWL$XLt$hHtHHHH;tgHHHt3{ HHD$XH\$`H\$hIL$   H$   L+IMt"@ f     HHD$XHHI;rH^H+HWD$0Ht3 HBHD$0H\$8ILD$HH\$@L+IMt$@ fff     HHD$0HHI;rHT$0HL$X\HVH+HHL$p5 D= D$   =  fD/i  Y5 $   fD/  HL$pHHtmH$   H+HH;v H    H=   r<t HAH;r H+Hs H'v Hy* HL$0 HL$X HtqH$   H+HH;vi H    H=   r=@tL HGH;r< H+Hs, H'v HH) HtlHD$PH+HH;v H    H=   r<t HCH;r H+Hs H'v HHy) A(y  IHHFH+HHt9LD$pD  (HD$0Y\AHHFH+HH;rLL$@MHT$pI,(H\$@E3L$`  H$X  L$P  H\$@H$   D$h  $   D$   $   HHFH+HHL$pHt@ JJIHFH+HL;rHHtmH$   H+HH;vt H    H=   r<tX HAH;rH H+Hs8 H'v+ H' HL$06 HL$X* HtqH$   H+HH;v H    H=   r=@t HGH;r H+Hs H'v HHl' HtlHD$PH+HH;vw H    H=   r<t[ HCH;rK H+Hs; H'v. HH& (L$  A(sA({E(CE(KIA_A^A\_^[@WH@HD$ H\$PHt$XIIHWD$(HD$8    HL$(貏HHT$(HPAEHT$(H HHHT$(P HL$(Ht HT$0LD$8HT$(L+I73H\$PHt$XH@_HHPVWAVH`H@HXHhIILHW@3HhHHHHT$(HPWD$@Hl$PHT$@H5HLD$(HT$@HP(HOHHT$(P HL$@Ht.HT$HLD$PHT$@L+Ih2WD$@Hl$PHL$(Ht.HT$0LD$8HT$(L+I02WD$(Hl$8H IINF L\$`I[ Ik0IA^_^̅  HDH D@PUVWATAUAVAWHH  HD$8HX)p)xHǅH      3H
(LP  L8  L0  D  =Ҙ HX  fff     I$HH;tID  D   EG  ExDE;ttGA!  fAn(4F F ,H
H HD$@H HD$PHMF H  E3HT$XHL$@ HD$@HcHH* HD@HD$@HcHhT<HD$XHD$0HL$Xm Hu HD$X3HEEH HL$PwHcHMh	 HL$PHcQHL$PHHPAHL$P HH&d UwHȋ      HMx HD$0Hd HL$P!wHHu3
H HcHHHD$0HPfAnY^,H2 HHc vH (   H HEHL$PvHX  HHT$@PHD$@HcHH HD@HD$@HcHhT<H. HD$XHL$XGHL$X< HL$`y HM/ HX  L0  HLMHU@HPHIo  Hz HE@HMH     t5Ǚ  u(H@  HD$ LMI< LII~;   D  D   H
$L$  I[@A(sA({IA_A^A]A\_^]LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $   H2HH$  {)HH$  %W$x  E3L$  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pL$   LLGHH$  HL8HL$pHHLxHL$xHHLxH$   H$   HHL$pH H$   WH$   诡H8 H$   H$  HQ H$  H$  H$  H$  H$   I $(  (
і )$0  W$@  D$H  Ǆ$L     r $P  D$X  Ƅ$\   $`  H H$   HT$pH$   $8  f/v	$0  $@  f/v` f/v	$@  $L  $H  Oȉ$L  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   n  H	 H$   H? H$  H$    H$    H$    H$    H H$   HL$p H$   HtL$   L+I{,33HL$pS H$   HtL$   L+II,N   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHɹ
 H3H$  MLH$(  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$p$HHL$t W$   3H$   Ld$8Ht$0D$(L$ LL$pMHH$   SWD$xH$   LLGIH$   jHHHL$xHHHXH$   HHHXH$   H$   9 HHL$xH H$   WH$   $H H$P  H$`  H H$X  HD$pH$h  HD$pH$p  ċ $x  (
L )$  W$  $  Ǆ$      $  $  Ƅ$   $  H H$   WH$  L5o L$   L= L$  HT$xH$   N$X  f/v	$  $`  = f/vf/v	$  $  $h  Oȉ$  Y
 (; $  $p  f/vf/v	$  $x  f/v	$  $  f/v	$   $  f/v	$  Ht$($  D$ D$  D$  $0  H$  sH$   HD$`H$   HD$XHt$PLl$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   2 L$   L$  H$p  { H$`  m H$  HI H$   H H$X  H$8  4 H$(  & H$   H$   
 H+ H$   HL$x H$   HtL$   L+I&33HL$x H$   HtL$   L+I&N   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sILH   AA+iA+AKutAKuǄ$       AA+iD+D$  uEtAD$  EuǄ$     $  H2HH$  kHH$  {W$x  E3L$  H$P  HD$8H$H  H\$0D$($  D$ L$  MHH$   ˿WD$pLLGHH$h  *HL8HL$pHHLxHL$xH$h   HHL$pH H$   WH$   H H$   H$  H H$   H$  H$  H$  H$  (ڌ )$   (
 )$0  D$@  Ǆ$D      $H  D$P  Ƅ$T   W$X  HL H$   HT$pH$   $(  f/v	$(  $0  f/vs f/v	$8  $D  $8  Oȉ$D  H$`  HD$`H$X  HD$XH\$PH$@  HD$H$  D$8$   D$0$  D$($  D$ D$   L$   HH$     H9 H$   H H$   H$    H$    H$    H$    H H$   HL$p H$   HtL$   L+I"33HL$pf H$   HtL$   L+I\"N   L$  I[(Is0A(sIA_A^_HSVWATAUAVAWH  Hǀ)p)xHٯ
 H3H$x  MLH$  L$  H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$puD$p     AA+iD+DL$tuEtADL$tEuD$t   $   H2HHL$pHHL$tW$   3H$   Ld$8H|$0D$(L$ LL$pMHH$   cWD$xLLFIH$   ½HHHL$xHHHXH$   H$   a HHL$x\H| H$   VH$   <H H$8  H$H  HV H$@  HD$pH$P  HD$pH$X  (u )$`  (
 )$p  $  Ǆ$     $ $  $  Ƅ$   W$  H H$   VH$  L5z L$   L= L$  HT$xH$   Q$8  f/v	$h  $@  = f/vf/v	$x  $  $H  Oȉ$  Y
 (1 $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  H|$($  D$ D$x  D$p  $  H$  H$   HD$`H$   HD$XH|$PLl$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   u L$   L$  H$X   H$H   H$   H H$   Hu H$@  H$(  g H$  Y H$   K H$   = H^ H$   HL$x# H$   HtL$   L+I33HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[HDH HPHHUVWATAUAVAWHhH@  HEHX)pD)@ELHIIxH+HL   LmH   HEH   HEWD$pHt3  H@HHD$pHL$pH|$xH] H}HMHEHEHE HEH   HEHD$pHEHHH+HHH3H~@ )HH;}
H] HMLHM9U H H]HL$xHEHL$xHMHT$pLL+t
H- HT$pWEH# WEHE    HMtHHUHPAEHUIBIE HUIP HMHtHU1LEHUL+I}H]HMHEHMHMHULL+tHK- EEfEMLHUHM
 D   H   HD$hL   Lt$`H   HD$PHEHD$HHEHD$@D$8   L$0   t$(   |$ EE3   H   [ +fDnED^. HMwH   HIP ' H   HD$hLt$`H   HD$PHEHD$HHEHD$@D$8 D$0t$(|$ ED      H     +fn^5~ LM(A(yLM(A(y(A(HM~Hp HEHM L$@  I[PA(sE(CIA_A^A]A\_^]LSVWATAUAVAWH  IǃhA)sE)CHw
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H9I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  Q II谖  L$   H$   H$   L$   WD$xHt3 HQHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   P H H$   H$   }H$   H$   H$   HT$xLL+t
H( HT$xW$   H H$   LMH$   H$   H$   rLMHH$   P" D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I  +fDnED^uz Aƅ    A   ' AExH$   rH$   IGIMHH$   P< Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI4 +fn^5y L$   (A(tL$   (A(t(A(H$   yHx H$   H$     H$P  H3  ($p  D($`  HĀ  A_A^A]A\_^[LATAVAWH  ICI[IsI{ A)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$h  E3L$x  H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   
WD$pL$   LLFIH$  $HL HL$pHHL`HL$xHHL`H$   H$   HHL$pHQ H$   VH$   Hj H$   H$  H H$  H$  H$  H$  H$   {s $(  (
z )$0  W$@  =u $H  $X  Ǆ$P  
   H3 H$   HT$pH$   I$8  f/v6$H  f/v'$0  $H  ^,Lǉ$P  $@  f/vf/v	$@  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   H% H$   H~ H$  H$    H$    H$    H$    H H$   HL$p H$   HtL$   L+I33HL$p H$   HtL$   L+IN   L$  I[(Is0I{8A(sA({IA_A^A\HSVWATAUAVAWH  Hǀ)p)xH
 H3H$  MLH$(  H$  H$   L$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t
W$   3H$   Ll$8Lt$0D$(L$ LL$pMHH$   wWD$xH$   MLFIH$   莯HHHL$xHHHXH$   HHHXH$   H$   ] IHL$x(H H$   VH$  HHѾ H$`  H$p  H H$h  HD$pH$x  HD$pH$  n $  (
pu )$  W$  =p $  $  Ǆ$  
   H H$   VH$  L=y L$   L% L$  HT$xH$  舀$X  f/v6$h  f/v'$  $  ^,Lǉ$  $`  f/vf/v	$  Y
p ( $  $p  f/vf/v	$  $x  f/v	$   $  f/v	$  $  f/v	$  Lt$($  D$ D$  D$  $0  H$  袷H$   HD$`H$   HD$XLt$PH$   HD$H$H  D$8$P  D$0$@  D$($8  D$ D$0  L$   HH$   y L$   L$  H$x   H$h   H$   Hx H$   H H$h  H$H  [ H$8  M H$   ? H$  1 HR H$   HL$x H$   HtL$   L+I
33HL$x H$   HtL$   L+I	N   H$  H3 ($  ($  H  A_A^A]A\_^[LWAVAWH  ICI[IsA)sA){MLH   AA+iA+AKutAKu   $       AA+iD+D$  uEtAD$  Eu$  $   H2HH$  HH$  W$x  HǄ$      H$`  HD$8H$X  H\$0D$($  D$ L$  MHH$   WD$pLLFIH$h  PHH     HL$pHHH@    HL$xH$h   HHL$pH H$   VH$   ŽH H$   H$  H߾ H$   H$  H$  H$  H$  (o )$   (
n )$0  =k $@  W$P  Ǆ$H  
   H H$   HT$pH$   $8  f/v6$H  f/v'$(  $@  ^,Lǉ$H  $@  f/vf/v	$8  H$p  HD$`H$h  HD$XH\$PH$P  HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   HH$   Ht H$   H H$   H$    H$    H$    H$    H H$   HL$p H$   HtL$   L+I33HL$p H$   HtL$   L+IN   L$  I[(Is0A(sA({IA_A^_HSVWATAUAVAWH  Hǀ)p)xH
 H3H$x  MLL$  H$  H$   H$  L$  H$  H$   H$  H$      AA+iA+ȉL$putL$pu   |$p     AA+iD+DL$tuEtADL$tEu|$t$   H2HHL$pHHL$t
W$   3H$   Ll$8Ht$0D$(L$ LL$pMIH$   wWD$xLMFIH$   ֠HHHL$xHHHXH$   H$   u HHL$xpH H$   AVH$   OH H$H  L$X  Hi H$P  HD$pH$`  HD$pH$h  (k )$p  (
i )$  =f $  W$  Ǆ$  
   HJ H$   AVH$  )L=z L$   L% L$  HT$xH$   y$8  f/v6$H  f/v'$x  $  ^,Lǉ$  $@  f/vf/v	$  Y
g ( $  $P  f/vf/v	$  $X  f/v	$  $`  f/v	$  $h  f/v	$  Ht$($  D$ D$x  D$p  $  H$   íH$   HD$`H$   HD$XHt$PH$   HD$H$(  D$8$0  D$0$   D$($  D$ D$  L$   IH$     L$   L$  H$`   H$P   H$  H H$   H H$P  H$8  | H$(  n H$  ` H$   R Hs H$   HL$x8 H$   HtL$   L+I. 33HL$x H$   HtL$   L+IN   H$x  H3 ($  ($  HĠ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CHg
 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
H)I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  8 II}  L$   H$   H$   L$   WD$xHt3 HAHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   
7 H H$   H$   mH$   H$   H$   HT$xLL+t
H HT$xW$   H޾ H$   LMH$   H$   H$   YLMHH$   @ D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I +fDnED^ea Aƅ    A    AExH$   YH$   I.IMHH$   P, Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI$ƾ +fn^5` L$   (A([L$   (A([(A(H$   `Hh H$   H$   ڼ  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[@SVWH   HD$0Hm
 H3HD$xIHHHD$p   HD$h    D$X A   HD HL$XHD$P   HD$H    D$8 A   H HL$8HNH+H*HHLI?LH\$(D$    DHL$85HD$PHrQHHL$8H=   r<t HAH;r{ H+Hsk H'v^ H- HD$P   HD$H    D$8 HD$pHrQHHL$XH=   r<t HAH;r H+Hs H'v H HHHHHL$xH3. HĀ   _^[@USVWAVHl$H   HEH
 H3HE'MHHHE   3H]]DCHr HMHE   H]]DCHR HMHE   H]׈]DCH2 HMLt$ LMLHUHMFHEHrPHHMH=   r<tں HAH;rʺ H+Hs H'v H| HE   H]E HEHrPHHMH=   r<tp HAH;r` H+HsP H'vC H HE   H]E HEHrPHHMH=   r<t HAH;r H+Hs H'vٹ H HP HH0HP H;tP r
0   HHMHtHLNL+IMC  HHHHM'H3 Hİ   A^_^[]H\$VH HHH;tbH|$0fD  H{rHHH{A   I;LBMtH  uHt	H H;uHH|$0H\$8H ^HH\$8H ^H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
1 I   LNB	9N   HII9H3H-uM HLL%rM HL=pM H;1HLH0  HEH?L   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
L  =L H
kK ~#H
L N Hl$WAVAWH@3MLH9y ~RH\$`Ht$h)t$05V f     IM(W/ Hv;} |(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_Hl$WAVAWH@3MLH9y(~RH\$`Ht$h)t$05)V f     IM(Wo Hv;}(|(t$0Ht$hH\$`MHT$ HIHHIINHPHHHL$ IV Hl$pH@A_A^_H   "A)(Y}V ()t$p()|$`XA8D)D$PD)L$@D	AXYD)T$0D)\$ Y((YYpV Y= V \A(YU ^X^^A(\AX(YY\% H$   (DKU XD6T (\D H$   A(YA(^Wg_ (YA^A^XX^YW?_ AYAYAYAXAXYAYf/v((fA/v4f/v.(YA^XYAYAXYf/v((fA/v3f/v-(YA^XYAYAXYf/v(((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   HHPHHUVWATAUAVAWHH  HE HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(MIHH0  H]L  LuEWI~ uE(#HHEIHEHEHEHM9  D(E(H8  DY D8  E(H@  DY(D  HH  D6H(  DHKHH@  HEHCHEHLL+tI E3EH  D=] D5Q @ f     H   H HEuIHEI^HGH;t'H;tH# Ht
H^HL?H_HHMHEHEHEHEH0  HEH}LGIHH+HLMIM~.HEEffYHEfX)HI;}HMIHMU LMHH   HbtAXAY
HuLuI~ uA("HHEIHEHEHEHM7  (A$A(H   YH(  X	f/   fA/r	E   (T
o[ A(AWf/   fA/sVD(D((E)EHH@  L>HEHFL~HEHfHEHF D(Y5Q A H   H$   D$   DL$xDT$p|$hT$`t$XB0   H   H$   $   T$xt$pD\$hDL$`DT$XLt$PH  HT$HH8  HT$@HL$0H   HL$(M H\$    LMHHo DH@   AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]@SVWAVAWH`  HD$(H	y
 H3H$X  MMHHH$  H\$ HL$0cH$0  HD$@H$8  MMHH$0    H$0  HL$0HxH$H  HrTHH$0  H=   r<t\ HAH;rL H+Hs< H'v/ H HtHHT$0HPH$   =H$    H$X  H3O H`  A_A^_^[LMCSVWATAUAVAWH  IǃA)sA){Hw
 H3H$  ILH$   LH$   H$   L$x  L$   H$  H$   IǃP   3IH@$  DGH@ I8HǄ$X     H$P  @$@  DGH, H$@  HǄ$x     H$p  @$`   MA.H H$`  FEF AG D;t"D$ L$  H$@  H$`  8H$x  HrTHH$`  H=   r<tR HAH;rB H+Hs2 H'v% H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<tԪ HAH;rĪ H+Hs H'v Hv HǄ$X     H$P  Ƅ$@   H$  HrTHH$  H=   r<tV HAH;rF H+Hs6 H'v) H HǄ$     H$  Ƅ$   A   H? H$  HǄ$X     H$P  Ƅ$@   A   H H$@  KHǄ$x     H$p  Ƅ$`    MA.H H$`  
HCEG D;t#HD$ L$  H$@  H$`  *MH$x  HrTHH$`  H=   r<t HAH;r H+Hs H'v H HǄ$x     H$p  Ƅ$`   H$X  HrTHH$@  H=   r<t HAH;r H+Hsw H'vj H9 HǄ$X     H$P  Ƅ$@   H$  耵Ic_ WD$`Ht3> H~HHD$`HL$`H\$hW($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$`H$8  HHH+HHHHH~'fD  f)HH;}$  HL$8LH$    Ic_ WD$HHt3l H謘HHD$HHL$HH\$P($  HL$8HD$8H$   H$  H$(  HD$0H$0  HD$HH$8  HHH+HHHHH~(    f)HH;}$  HL$8LH$    Ic_ W$   Ht3 HٗHH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$   / Ic_ W$   Ht3 HHH$   H$   H$   ($  HL$8HD$8H$   H$  H$(  HD$0H$0  H$   H$8  HHH+HHHHH~)     f)HH;}$  HL$8LH$   O Ic_ WD$xHt3ܣ HHHD$xHL$xH$   ($   H$   H$   H$   H$   H$(  HD$0H$0  HD$xH$8  HHH+HHHHH~2@ ff     f)HH;}$   H$   LH$   l D|$8|$p5D      $p  D;  DA  ~6H H$   M(( 3AHvE;w |H$   L$   H$`  IHHL$xHHT$xHPH$   HHH$   H$`  Z H$   ľH$`  H$   H$0  H$   L$   L$  HT$xH$   a H$   H$   ܼHXH$   HtHH$   HPH$0  H$8  E33H$   A   H H$   	H$  H$  E33H$  V_ MA.HO H$  L$   H$   H$  H$  FH$   8L$   L$   HL$`H$  H$  H$   H$   H$(  HD$XH$0  HD$`H$8  LL$hIHH+HHHHH~, (fAX)HH;}L$   H$  MH$   Gm LD$HLD$8L$   L$  L$   L$  HL$HH$@  H$@  H$   H$  H$(  HD$1H$0  HD$8H$8  LT$PIHH+HHHHH~B     A(fAY(fX)HH;}L$  L$  H$@  MH$   v8 ADd$8H$  聺H$  S ]3Dd$8WL$   H$   H$   L$   H$   fn($@  HL$`H$  H$  H$   H$@  H$(  HD$1H$0  HD$`H$8  LD$hIHH+HHHHH~<@ f     (f(f^)HH;}$@  H$  H$    $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  HD$HH$8  LD$PIHH+HHHHH~5fD  (f(f^)HH;}$@  H$  H$   d HD$HHD$8HL$HH$  IOH$  IWH9T$PtA   HL$8W HD$8HH$@  H$@  H$   H$  H$(  HL$1H$0  HL$8H$8  LpIHH+HHHHH~FH$  ()$`  H$`  ~	H$  (fYH$@  )HH;|MHH$   R HD$HH$   $@  HL$HH$  H$  H$   H$@  H$(  HD$1H$0  H$   H$8  LD$PIHH+HHH~=@ ff     (f(fX)HH;}$@  H$  HH$   qk HT$`H$   ?HT$HH$   -HL$x H$    H$    HL$H HL$` H$  H3 ($   ($  H  A_A^A]A\_^[HUAVAWHHpHEHXHpHxL` )pLLWEE3LMHRIHt I;vH
 s HM1LM3I9vf  3HMLE    IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHM LMHMLEH   ItI;ugIH+HHsWI+HIH+H   HQM+IIHIH+IE3I;LCL;ICHM LMHMLEHtHHLMLEHMHHMHHcI;F}!H
   H
  WEHE    LEHUI[  (HMH   HEH+HH?H;v H    H=   r<tי HAH;rǙ H+Hs H'v Hy WEHE    HMHthHEH+HI;vr H    H=   r<tV HAH;rF H+Hs6 H'v) H (L\$pI[ Is(I{0Mc8(t$`IA_A^]LMCSVWATAUAVAWH  IǃA)sA){Hc
 H3H$  IHH$   LH$   H$   L$8  L$   H$@  H$   IC   3I{@$  DGHf IxHǄ$8     H$0  @$   DGHR H$   HǄ$X     H$P  @$@  I MA-H9 H$@  lDF(AG(D;t"D$ L$  H$   H$@  $H$X  HrTHH$@  H=   r<tx HAH;rh H+HsX H'vK H HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<t HAH;r H+Hsږ H'v͖ H HǄ$8     H$0  Ƅ$    H$  HrTHH$  H=   r<t| HAH;rl H+Hs\ H'vO H HǄ$     H$  Ƅ$   A   He H$  HǄ$8     H$0  Ƅ$    A   H H$   qHǄ$X     H$P  Ƅ$@   
 MA-H H$@  0HCEG(D;t#HD$ L$  H$   H$@  P9H$X  HrTHH$@  H=   r<t; HAH;r+ H+Hs H'v H HǄ$X     H$P  Ƅ$@   H$8  HrTHH$   H=   r<t HAH;r H+Hs H'v H_ HǄ$8     H$0  Ƅ$    H$  覡Ic_(W$   Ht3a H衅HH$   H$   H$   W($`  HL$PHD$PH$   H$`  H$  HD$0H$  H$   H$  HHH+HHHHH~.@ f     f)HH;}$`  HL$PLH$    Ic_(WD$8H|$HHHt5HHHH;tHtHHHH;tLLLLIHL$8ޟ|$PHD$@H;u
LD$HL;t:HtHHHH;txLLIHL$8蔟LD$HHD$@HL$8H$`  H$h  H$`  H$   HT$PH$  HT$0H$  HT$8H$  LIHH+HHHHH~"D$Pf)HH;}
H$`  H$    Ic_(WD$`Ht3 H_HHD$`HL$`H\$h(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$`H$  HHH+HHHHH~+ff     f)HH;}D$PH$`  LH$    Ic_(WD$pHt3L H茂HHD$pHL$pH\$x(|$PH$`  H$`  H$   HD$PH$  HD$0H$  HD$pH$  HHH+HHHHH~(    f)HH;}D$PH$`  LH$    Ic_(W$   Ht3y H蹁HH$   H$   H$   (|$PH$   H$   H$   HD$PH$  HD$0H$  H$   H$  HHH+HHHHH~)     f)HH;}D$PH$   LH$    D|$4$   5h0      $0  D;C  DA( ~+H H\$pM((  AHvE;w(|LD$pH$@  IHH$   HH$   HPH$   HHH$   H$@   H$   lH$   H$   H$  H$   LL$`L$`  H$   H$   	 H$   H$   脨HXH$   賛HtH$   HH$   PH$  H$  E33H$   6A   Hi H$   H$p  H$x  E33H$`  B MA-H2 H$`  eLD$`H$   H$`  誎H$`  H$   ޚLD$`L$  H$   H$   H$   H$   H$  H$  HD$1H$  H$   H$  L$   IHH+HHHHH~, A(fX)HH;}L$  H$   MH$   X A( U  L    LM0  MYICH   A   IHT$@IHL$8HD$`BHD$pBYXIRHT$@IHL$8HD$`BHD$pBYDXIHT$@IHL$8HD$pBDHD$`BYXIRHT$@IHL$8HD$pBDHD$`BYXIIM;&M;9IHT$@IHL$8HD$pBHD$`BYXIM;~IA;_(ADd$4H$  蠥H$  r 3Dd$4WL$   H$   H$   L$   fn($   H$   H$  H$  H$   H$   H$  HD$1H$  H$   H$  L$   IHH+HHHHH~:fff     (f(f^)HH;}$   H$  H$   4 $   HL$8H$`  HD$@H$h  H$`  H$   H$   H$  HT$1H$  HT$8H$  LD$HLIHH+HHHHH~4D  (f(f^)HH;}$   H$`  H$   t IwMwHT$8L\$@HD$HH$   L$   H$   L$   I;IMLL$   I   I@H$   MfIMkIO6OLHMIIHH$    (A^XJIHI(^DXDDJJ(^DXDDI>I(^DI;IXDDHJ    LJ    LIMH;$   H$   XL$   I;}BN   N4   HIHHIHL+(^X  IIIuH$   H$   tHT$8H$   RH$    HL$p HL$` HL$8׆ H$   Ȇ H$  H3  ($  ($  H  A_A^A]A\_^[H   HD$ HH$     HHL$(  HS
 HL$(W @SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQH@r  HC(HCH;CuHHCHCHCKHKHL$PHD$@HD$XHL$(HtIHIQH k HC(HCH;CuHHCHC H0[@SH H@  H#z HC`H [HL$SH0HD$ HD$P    EtH^ HAPHy HA`D$P   J   HC HHy HC(HCPHcHH~v HDPHCPHcHDL    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHO̃ HMz HHGHFHG HF H^(H\$HH HHO0HKHtHPHG8HCHG@HCGHC Hk HHo HHH\$PHt$XH0_H\$WH HHd HHQ3HHHKHB Hy HHCHGHC H\$0HG HH _H\$Hl$VWAVH`HBHyHr3HD$ LHGHH;t'H;tHF Ht
HuHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@  IFL\$`I[(HEIF HE HIk0IA^_^@SH Hk HHH} HAhHIH` HK8V HK L HKB Hct HH [@SH HS| HHH HA`HIH  HK8 HK  HK Ht HH [@SH H HHH} HAhHIH HK8 HK  HK Hs HH [@SH Hz HHHF HA`HIH@ HK86 HK , HK" HCs HH [HL$WH0HD$ H\$HHHًBAHHHA   HA    HyrHH  IE3RHW(HK(HA   HA    HyrHH  IE3HH\$HH0_@SH H  Hu HCPH [HL$SH0HD$ HD$P    EtH^p HA@Ht HAPD$P   J   H+j HH HCHC@HcHHm HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK~ H5l HH{3HHDH^H\$HH} HHOHKHtHPHGHCHGHCG C Hzi HH8g HHH\$PHt$XH0_H\$WH H<:  Hs HG`t
h   Hw HH\$0H _@WH0HD$ H\$@HHxe HH| HA(HI0HtHP tHC0    H HHK~ @t
P   H HH\$@H0_H\$WH H  Hr HGPt
X   H跬 HH\$0H _@WH0HD$ H\$@HH8h HH| HAHI HtHP tHC     H( HHKS} @t
@   H8 HH\$@H0_LH   ICAC    HQHm ICHr ICAC   IK{H\g HD$(H| HD$@HD$hHcHHk HDhHD$hHcHDd    H
 HL$( @SH0HD$ HٹX   L HD$@HSHD  HHtH@@HcHHB@HH0[@SH0HD$ HHf HH
| HAHA@HcPHRj HD
@HA@HcPDBDD
<Hf HH{z HAHI HtHP tHC     H HHKH0[H%{ @SH0HD$ HH/f HHz HAHI HtHP tHC     H HHKH0[H%D{ HVWAVH`H@HXHhHFG
 H3HD$XHHIHA     HAH9A  A<	  Ƀ0HCHKAx HD$(>x HHL$ YtHC    HL$ jHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
c H;uoHP LT$PLL$8HL$8IIC9@HKH9Krm@tHC  tX@LT$PLL$8;HC@8(uHH9Ct:MF@֍F@I;CHD$8IIC<HKHCH;C2HB  HL$8HL$(HtHPHtL    HA2HL$XH3ՠ L\$`I[(Ik0IA^_^HVWAVH`H@HXHhHFE
 H3HD$XHHI HAH     HA H9A  A<	  0HcHCHHK <v HD$(9v HHL$ TtHB    HL$ hHHT$8HLt$HM   HL$8LL$8LT$PIICɀ9    @2HH
a H;uoHP LT$PLL$8HL$8IIC9@HKH9K rm@tHB  tX@LT$PLL$8;HC @8(uHH9Ct:MF@֍F@I;CHD$8IIC<HK HC H;C2HA  HL$8HL$(HtHPHtL    HA2HL$XH3О L\$`I[(Ik0IA^_^H\$H|$HA(LIHPLBIHH+HLIHHHHH<    MA  LYA(fAYI~hA(I   fAYKH;~7II+    A(IfAYHfX(DfY@fXH;|fXL;~HB(fBYfX(fXM;   II+H|qIICI+JHIHI+HM    TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$LI E3L9A(v) KHABIYAXBBL;A(rHL$AVH0HD$ H\$HHt$PH|$XIMHHMIH?  (HH HH_(H    H HHH
 H; rHHO3ۋH9_(v"H+fff     HHHHIH;W(rHW(HH HHH H; rBHHO H9_(vD  HO IHHH;_(rHH\$HHt$PH|$XH0A^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   [   ^   ,A;ALǉ   LCHSHH  ktUHH@        ^,A;ALǉ   Y     H   H   HH\$PHl$`Ht$hH0A_A^_@SH Hk HHHa H   Hp  jr H`  ]r H  yHk HH8p HC`HKH2r HK8(r HK r HKr H5d HH [Wf/v(      ^   ,;L   H\$WH HHH   HQ{H   HB{H   HH\$0H _){HHPVWATAVAWH   HD$8HXHh)p)xIILH3t$0J>  HSH^H_HG`LGpHHO`P8LHHO`HHL$@s(HHO`Z  (X9   ~(HGXHl$    LG`HHOX;   |s(HHO`  X$   HH$   H#H      H;v! \(' (= f/vNHOxf/v?HD$@H;t5HKHT$HD$hC(HKHT$XlHK0HT$p^]s(HHO`Y  X   w0H1m I$I\$H$   HOaHHHGHCHWHGLL+t? W5 At$A|$ HL$p[o HL$XPo HL$HEo IL$   I[0Ik@A(sA({IA_A^A\_^HT$WAVAWH0HD$(H\$PHl$`Ht$hIHHD$       A   D|$        W H   H   TW   ^   ,A;ALǉ   LCHSHH  _`tUHH@J        ^,A;ALǉ   Y; $    H   H   HH\$PHl$`Ht$hH0A_A^_@SH HY HHHj H   Hx  m Hh  m H   {Hm HH i HChHKHm HK8m HK ~m HKtm H_ HH [Wf/v(      ^   ,;L   H\$WH HHH   HvH   HvH   HH\$0H _vHUSVWATAUAVAWHhH(  HE)p)xD)@H8
 H3HEMILH3t$8G  HSHH_HGhLGxHHOhP8MHHOhkHHMs(HHOhM  (X9   ~(HG`Ld$    LGhHHO`;   |LCI@HK@HD$PD
 DD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(D$0HHD$0H#H      H;v< \(B (=
 f/vLH   f/v:HEH;t1HKHUEC(HKHUHK0HU{]LCI@HK@HD$PDD$XLD$`HL$pLD$xHEHEHT$@HM  HE XC(   w0Hh IE I]H\$0HO\HHHGHCHWHGLL+t+ W5 AuA} HMJj HM@j HM6j IHMH3o L$(  A(sA({E(CIA_A^A]A\_^[]HT$VWAVH0HD$(H\$PHl$`IHHD$       D$        thS H   H   ARLGHWHH  -bt8HH7     Yf O    H   H   HH\$PHl$`H0A^_^@SH H#d HHH] H   Hx  h Hh  h H   	wHc HHf HC`HKHh HK8h HK h HKh HZ HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y=	 H(6n(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_mH\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@ HL$0g L$   HHH$   ($   HĠ   _Hl$Ht$ AVH@3MHH9r ~fH\$PH|$X)t$0)|$ WI  HE@(H]X薷 ^Hc4HH;E |(|$ (t$0H|$XH\$PHl$`Ht$hH@A^HT$UVWH   HD$(H$   IH3|$ H:HzIh Ht3f HDXHHkHF@HD$hHFHD$xHv H;t'H;tHe Ht
HXHH;HsLLD$0HD$0HD$@HD$`HD$HH$   HD$PH\$XLKIHH+HHHH~. HD$xHHD$h(fYA)HH;}LD$0MHL$@ HH$   HĐ   _^]H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$hV(HH8   Y H$   \(t$pHĀ   _   H   HJHB@HL$0L$0HD$(D$ HL$HL$`D$PHy uWYl H   H	H H$   HD$@H$   H$   H$   H$   ܯ Y$ H   Wf/v f/v   Wf/v   H\$WH HH5  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHlfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HB$H;Cu
   HHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   H蒢HSHt
HHH
HJ$H;Cu
   HfHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   HHSHt
HHH
HB$H;Ku
   HڡHCHt0HH   HCH;s;HH;w3H+HH;Cu
   H藡HSHt
HHH
HB&H;Cu
   HkHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    -  HSII^IF`MFpHIN`P8MHIN`HHM:	HUH   )	HUHM0	HUH   
	IF`LHUIN`P(HMMRHE HMHM(HULL+tH訰 HM#RHEHMHMHULL+t	H~ IN(QHD$xIN(HMIV LL+t	HR EWA(s(HIN`D(DXD$`    DEAǆ       AƆ    A      D Db  D%  D-` H}WD$hHt3^ H>QHHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM貘 DUINxfA/  HEH;   HcuH;st$HK^ tHZPHCHC    Hs~LEN    HUHK觮 EC(Hcu H;s t$HK] tHPHCHC    Hs ~LE N    HUHKN HcuHH;s8t$HK0s] tHOHC0HC0    Hs8~LEN    HUHK0 Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I/  HEH;  HSHM7C(EHSHM HM   H   H;t=HKH      C(HKH   HK0H   Ld$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I.  H   H;t=HSH   SC(   HSH   6H   HS0&@  A   uf/w(\i (INxf/v=H   HM8   EXH   HMHH   HM`f/v\(X(\((XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~+@ (fAX)HH;}L   H0  MHM]' HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  pfA/v!HL$hY A   A9   HL$hY Hx  D$`A   fn}^HE0H;t1HKHU8EXC(HKHUHHK0HU`s(HIN`XA   AV0W IV(HFHL$xY HMX HM X HMX H   X H   X H   X HM`X HMHX HM8X H   X H   X H   rX HMgX HM]X HMSX HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HT$VWAVH0HD$(H\$PHl$`IHHD$     J	  D$        thS H   H   Q@LGHWHH   }It8HH^3     Yv _    H   H   HH\$PHl$`H0A^_^@SH H[E HHHr H   H  
W Hp  V H(  eHq HH@R HChHKHV HK8V HK V HKV HH HH [H\$Hl$Ht$WHPH$   I)t$@H)|$0((H\$ Y= H(F\(H\$ LHH0   (LHHH\$`Hl$hHt$p(t$@(|$0HP_\H\$WH   I)$   LHHT$0H(  LKHKt$hHL$XLHD$ HD$@HD$`HD$HH$   HD$PLT$xLL$ LAIHH+HH3HH~;D  A((ffYfAXA)HH;}LT$xt$hLL$ HL$@  HL$0-U L$   HHH$   ($   HĠ   _*HWH   H@HXHhHp )pIHHz W@Ht3T HFHD$(H|$03H~%WfH  XHD$(HH;\$0|HM@HT$HrC  H$   H$   HD$8HD$(HD$@HMHT$8$ HL$H0T HL$($T L$   I[Ik Is((t$pI_HHPVWAVH   H@HXHhMH3ۉ\$@HHZIhHHt3S HEHHoIvHH;t'H;tHS Ht
HEHHHwWD$PHHL$`HD$`H$   HD$PH$   H$   H$   H$   LGIHH+HHH~f)HH;}
D$PHL$`HH$   B HIFHD$pHD$x   INHIF@H$   H$   } D$0HT$ LL$pL$   IVP
 HL$   I[ Ik0IA^_^H\$WH   HB)t$pHHD$(H0HHT$0Hz uW'H HL$@HD$HHHD$XHD$ HD$h(HH8   Y  H$   \(t$pHĀ   _   LH   H
 H3H$   HB LB IKICH@D$@ICISISMCMCIC  HD$h H$   H3x HĘ   Wf/v f/v   Wf/v   H\$WH HH+1  HCHKHH\$0H _H`H\$Ht$WH0H)t$ H   HHwZfn   HL$@HCt$@H;sEHHL$@H;w8H|$@H+HH;Cu
   H蛐HSHt
HHH
HB$H;Cu
   HoHCHt0HHCHL$@fn   t$@H;sEHHT$@H;w8H|$@H+HH;Cu
   HHSHt
HHH
HJ$H;Cu
   HHKHt1HHK   fnHD$@t$@H;sEHHT$@H;w8H|$@H+HH;Ku
   H膏HSHt
HHH
HB$H;Ku
   HZHCHt0HH   HCH;s;HH;w3H+HH;Cu
   HHSHt
HHH
HB&H;Cu
   HHKHtHHHAHt$P(t$ HCH\$HH0_HHPUVWATAUAVAWHH0  Hǅp  HX )p)xD)@D)HD)xD)hD)XD)HMIHLEp    w)  HSIKI^IFhMFxHINhP8MHINhHHMHUH   HUHM0HUH   IFhLHUINhP(HM?HE HMHM(HULL+tH( HM?HEHMHMHULL+t	H IN(x?HD$xIN(HMIV LL+t	Hҝ EWA(s(HINhD(DXD$`    DEAǆ       AƆ    A      DC D D%i D- H}WD$hHt3~L H>HHD$hHL$hH|$pD   H  H  HEH   HEHp  HEHD$hHEHHH+HHH3H~*        f)HH;}	H  LHM2 DUI   fA/  HEH;   HcuH;st$HKK tH=HCHC    Hs~LEN    HUHK$ EC(Hcu H;s t$HKBK tH~=HCHC    Hs ~LE N    HUHK˛ HcuHH;s8t$HK0J tH,=HC0HC0    Hs8~LEN    HUHK0y Ld$XHEHD$PHEHD$HHD$`HD$@Dd$8DL$0HD$hHD$(HEHD$ LM L   A   I+  HEH;  HSHMC(EHSHMHM   H   H;t=HKH   x   C(HKH   [HK0H   KLd$XHEHD$PHEHD$HHD$`HD$@Dl$8DL$0HD$hHD$(HEHD$ LM L   A   I*  H   H;t=HSH   C(   HSH   H   HS0@  A   uf/w!(\ (I   Mf/v=H   HM8W   EXH   HMH:H   HM`*f/v\(X(\(s(XLD$hL   HL$xH0  H0  HEH   HEH  HEHD$xHELMIHH+HHH3H~'(fAX)HH;}L   H0  MHM HEHEHD$xHEHt$xH}HuA()HEHH  HX  HEHh  H@  =fA/vpHEHH  HD$xHP  HtTHEH  H  H@  H  Hx  fA/v!HL$hDG A   A9   HL$h#G Hx  D$`A   fn}^HE0H;t1HKHU8bEXC(HKHUHKHK0HU`>s(HINhXA   AV0W3 IV(HHL$xF HMuF HM jF HM_F H   QF H   DF H   7F HM`,F HMH"F HM8F H   
F H   E H   E HME HME HME HL$0  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]LH   ICAC    HQHE ICH(: ICAC   IKH` HD$(HB HD$PHD$xHcHH6 HDxHD$xHcHDt    H	 HL$( @SH0HD$ Hٹh   lo HD$@HSH.  HHtH@PHcHHBPHH0[@SH0HD$ HH_ HHA HA(HAPHcPH6 HD
PHAPHcPDBDD
LH5+ HHB HA(HI0HtHP tHC0    HL HHKH0[H%C @SH0HD$ HH* HH5B HA(HI0HtHP tHC0    H?L HHKH0[H%dC @SVWH   HD$8Hm
 H3H$   IHHI @D$0HHD$0H#H      H;v|HD$X   HD$P    D$@ A   Hw HL$@脌HD$x   HD$p    D$` A   Hw HL$`UHD$@HD$ LL$`LHH'lH$   H3i HĐ   _^[HUATAUAVAWHhH   HEHXHpHx )p)xD)@D)HD)PD)xLHHYHHL$pGxWf.z'  D fA/  HGPLG`HHOPP8MHHOPH](HGHLd$ _xLGPHHOHH7EPHHEPH#H      Df H;vA(\ j D(ȃ   f/GLcD D  HD$pH;t2HKHT$xEC(HKHUHK0HUHGPLG`HHOPP8MHHOP#HsHt$8H~ u(HHD$PHD$0HD$`HL$H2 (AYXs(HGHLd$ _xLGPHHOHHt$8H~ u(HHD$PHD$0HD$`HL$H]2 AYXG0EPHEPHH#H      H;vA(\IufA/vCGxXIufD/v+GxAYGxfA/   f.tJHD$pH;   HKHT$xJEC(HKHU3HK0HU&   H2H HD$03HD$8HD$@H" HD$HD$PHT$8HL$H> Hi7 HD$0H]	 HL$0ay HG HD$03HD$8HD$@H HD$HD$PHT$8HL$Hq> H7 HD$0H	 HL$0
y HM> HM> HL$x> L$   I[8Is@I{HA(sA({E(CE(KE(SE([IA_A^A]A\]DD$HL$WH0HD$ H\$HHt$XHH3t$PH. HA@H(3 HAPD$P   H( HHOH0 HHG@HcPH1 HD:@HG@HcPDBDD:<HSHHD豈HH\$HHt$XH0_H( TH f/ w* T* f/b w Hb
 H(H H
q q: Hс H
p ]: H(
  T f/ w2
^ 6 qT f/ wH9
 H(HU x3  HH k3  HL$H( LD$0HT$8T9 f/q v=  "    LD$0HT$8T f/= vU=  "   g LD$0HT$8xT f/	 v!=  "   H
 H(@WH HI*HIILL+ILIIH?Lt;IH\$0IHHHH?HHRHHH+HH_H\$0H _H\$WH HAHHH;s@H	H;w8H+HH;CuHIHSHt7HHH
HCH\$0H _H;CuHiIHKHtHHHCH\$0H _H\$WH H\t
  Hi HH\$0H _H\$WH H3 HHH8 HA`HIH: HO8: HO : HO|: H, Ht
   H i HH\$0H _H\$WH H<t
  Hh HH\$0H _H\$WH H9 HHHH5 HAhHIH9 HO89 HO 9 HO9 H+ Ht
   H`h HH\$0H _H\$WH HLt
  H"h HH\$0H _H\$WH Ho3 HHH 7 HA`HIH9 HO89 HO 9 HO8 H+ Ht
   Hg HH\$0H _H\$WH H|t
  Hbg HH\$0H _H\$WH HgS HHH3 HAhHIHZ8 HO8P8 HO F8 HO<8 H]* Ht
   Hf HH\$0H _DD$HL$WH0HD$ H\$HHt$XHH3t$PH#( HA@H, HAPD$P   H! HHOHY7 HHG@HcPH% HD:@HG@HcPDBDD:<HSHHD!HH\$HHt$XH0_HAH9A   9 uywE3A   ADDHAEDYEDJЀ0Eр	w<EtEu23҃AA;r%HQA;rHADHIHAH;Az2ð̀9 Lu
yw3   ADHAEDYEDQЀ0Eʀ	w-Etu$3҃AA;rIHA;r
I@D2H\$HAH9A    H 9 uH9YwE3A   HADLHA MLYMBЀ0LcMʀ	wCt"Eu:3HII;r,HQIHH;rHALHI HA H;AsH\$H\$2̀9 LuHH9Aw3   HALHA MLYMAЀ0LcMʀ	w/t!u'3HII;rIHIHH;r
I@L2HUAVAWHhH   HEHXHpHxL` )pIHHWEMt34 H&HEH]WEHt34 H&HEH]E3H   LOLL+A   L+A   L+IL+LSIIN         KKLHEHIAHHHEHKHEHLIHHHEHLKKLHEHIAHHHEHCDKHEIA@HEMI ImL;s0H+JHEBHHHEBIL;rHEHEHEHEH} uW$HEHEHEHEHEHE'HM軻(HM3 HM3 (L$   I[ Is(I{0Mc8A(sIA_A^]@SH    Wf.H   HH   zt9HxY \] Y   XM Y      H [HUATAUAVAWHhH  HD$0HXHpHx )p)xD)@D)HD)PD)xD)hLHHYHHL$`   EWfA.z  D
{ fA/  HG`LGpHHO`P8MHHO`ןs(HHO`&(XHGXL|$    LG`HHOXs(HHO`XE@IHE@I#H      D H;vA(\  D(   f/GHcD%: HD$`H;t3HKHT$hbEC(HKHT$xJHK0HU=HG`LGpHHO`P8MHHO`̞s(HHO`(XHGXL|$    LG`HHOXs(HHO`XE@HE@I#H      H;vA(\HufA/vM   XHufD/v2   AY   fA/   fA.tKHD$`H;   HKHT$h8EC(HKHT$x HK0HU   H8 HD$H3HD$PHD$XHu HD$8D$@HT$PHL$8. HV' HD$HHJ	 HL$HNi H7 HD$H3HD$PHD$XHt HD$8D$@HT$PHL$8^. H& HD$HH	 HL$Hh HM. HL$x. HL$h. L$  I[8Is@I{HA(sA({E(CE(KE(SE([E(cIA_A^A]A\]HWHp  HD$ HX)pHE	 H3H$P  HHHL$0J   Hn HL$@(H(T, H$0  HL$0HLHHAPH$H  HrUHH$0  H=   r<t. HAH;r. H+Hs. H'vz. HI\ H$   HH$   m, H$P  H3T H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  HXHW`HUH_L  Y   H8  HD$ LHAH    s(HHO`3(XMHEHH#H      H;v
G (  \f/   vƇ   \H(  f/v(\H(  X \(XH(   Wf/vH0   X (| H0  X  H;t/HSHN?HC(HF(HSHN*HS0HN0LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$h  HMHLHT$hP(HH   HHHHPHKHHHSHL$h* HHEHsH   HCH;t'H;tH* Ht
HHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$h  H       D  HY(WEHt3) H4HEH] =l } H  H[WEHt3) HHHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hwc    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0i}H  L@LEWEMt3W( HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMb H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\((Xu \	(XuuHUH(  HEf/w"\w (H   Hx.f/vHE0H;tHU0HWEH]HHt3& HLHEH]LEHuHEHEHEHEH;t-Id& HtHLHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   0HM% HM% HM`$ HMH$ HM8$ HM$ HM$ L$  I[0A(sA({E(CE(KI_^]@SH    Wf.H   HH   zt9H轑Yu \ Y   X
 Y      H [HUVWATAUAVAWHl$HP  HEHX)p)xD)@D)HD)xD)hH	 H3HELHHyHHL$@   EWfA.z\  D
8 fA/H  HFhLFxHHNhP8MHHNh蔑w(HHNhD(DXHF`Ld$    LFhHHN`w(HHNhKXD$0HHD$0H#H      D H;vA(D\n s (   fD/GLcD fHD$@H;t5HOHT$HD$hG(HOHT$XHO0HT$pHFhLFxHHNhP8MHHNh耐LGI@H_@HEDELEH]LEHEHEHUHM)  HE0Xw(HF`Ld$    LFhHHN`LGI@HEDELEH]LEHEHEHUHM˚  HE XG(D$0HD$0HH#H      H;vA(\Iuf/vL   XIuf/v2   AY   fA/   fA.~tMwHD$@H;   HOHT$H苲D$hG(HOHT$XrHO0HT$pd   Hp) HE3HEHEHcf HD$0D$8HUHL$0
  H HEH	 HMZ H) HE3HEHEHe HD$0D$8HUHL$0 HZ HEHO	 HMTZ HL$p:  HL$X/  HL$H$  HMH3`G L$P  I[PA(sA({E(CE(KE(SE([IA_A^A]A\_^]HWHp  HD$ HX)pH	 H3H$P  HHHL$0<   HB` HL$@舢H( H$0  HL$0J:LHHAPH$H  HrUHH$0  H=   r<t  HAH;r H+Hs H'v HM H$   9H$    H$P  H3
F H$  ($`  Hp  _HLH PHHUVWH(H  HEpHX)p)xD)@D)HIH  H`HWhHUH_L  Y   H8  HD$ LHAH    s(HHOh3(XMHEHH#H      H;v
 (  \f/   vƇ   \H(  f/v(\~H(  X \(eXH(   Wf/vH0   X (*n H0  X  H;t/HSHN蟮HC(HF(HSHN芮HS0HN0}LG LEH  HHMHUHT$hHUHT$pH   HT$xHELHIHH+HHH3H~(    A(fX)HH;}
LEHMMHL$hb  HMHLHT$hP(HH   HHHHPHKHHHSHL$h: HHEHsH   HCH;t'H;tH Ht
HLHH;HsHHMHEHD$hHEHD$pH   HD$xH]LCIHH+HHHH~(@ f     HE()HH;}HMHL$hK  H       D  HY(WEHt3T H
HEH] =̿ } H  H[WEHt3 HW
HHEHMH]W(uHMHEHD$hHEHD$pHD$`HD$xHEHEHHH+HHH3H~%f     f)HH;}EHMLHL$hT    ȉEH8  HL$XH0  HL$PHM HL$HH   HL$@D  DD$8D  DL$0HMHL$(HMHL$ L   LƋH   HQu2  HSHM0}H  L@LEWEMt3 HMHHELEHMLEuHL$hHD$hHEHEHEH   HEHEHEIHH+HHHHH~*ff     (f)HH;}uHL$hHMwS H8  HD$XH0  HD$PHEHD$HH   HD$@DD$8DL$0HEHD$(H   HD$ LMLE0UHu2E  E Mf/v\(|(Xu \i(XuuHUH(  HIEf/w"\+i (H   H莅f/vHE0H;tHU0HWEH]HHt3 H?
LHEH]LEHuHEHEHEHEH;t-I HtH	LHELH}HH]LD$hHD$hHEHEHEH   HEHEHEHHH+HLMHM~,fD  HEHM(fXA)HI;}LD$hLIHM{ LELD$hH  HHMHUHUHT$hHUH   HUHELHIHH+HHH~.@      (fAX)HH;}LD$hHMMHHM  LML   H   H   "HMl HMa HM`V HMHL HM8B HM7 HM, L$  I[0A(sA({E(CE(KI_^]DD$HL$WH0HD$ H\$HHt$XHH3t$PH HAPH
 HA`D$P   H0 HHO(H HHGPHcPH HD:PHGPHcPDBDD:LHS(HHD`HH\$HHt$XH0_HL$HH LL$P)t$0LD$X3)|$ 5 =ĸ Tf/    LL$PLD$X3Tf/    LL$PLD$X3Tf/   ö LL$PLD$X3Tf/    LL$PLD$X3lTf/   ߶ LL$PLD$X3FTf/ws(t$0(|$ HHHX H
G  HkX H
G  HWX H
G  HCX H
G  H/X H
pG  HX H
\G  H\$Ht$H|$ AVH`H3HrLHD$ HHAH;t'H;tH	h Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~fHD$ ()HH;}HL$0HL$@詊  IVHO   L\$`HI[Is I{(IA^H\$WH H HHA`HIH HO8 HO  HOv H Ht
   HA HH\$0H _H\$WH H
 HHAhHIH$ HO8 HO  HO H' Ht
   H@ HH\$0H _H\$Ht$WH`H3HrHHD$ HAH;t'H;tH	 Ht
HHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~(fff     HD$ ()HH;}HL$0HL$@و  H\$xHH$   H`_@SH0HD$     HHt  HH0[H\$UVWAVAWH$ H   LrHHIE3HHZHD$XLt$`I;uH9^taMt"HtHHHL;  HFHIHH;tH? Ht
HzHL>LvH^HFHL$hLHD$pHL$ HL$XHL$(H0  LD$hLNLHL$0IIHt$8HH+HHHH~! HD$X(A)HH;}LD$hMHL$ e  L~IM  L$8  Iff     HVL&HHHT$(Ht$8L$0L|$@IH\$HMHHL$ D$ I+HT$PL$PHMH}HEHULLD$xED$@MED$x   M   E   M   E      E   HuW#H   LD$(HL$ HD$@HT$8 (foG IHFHMEHEUHMHME0HuMH] E H](M@fo
 fEPU`Mp  Xf/FvFHHI;L$8  IHN Ȑ  ID~DHN0HLN@HLF0A   HV   H$@  FDHAD~HH   A_A^_^] wH\$Ht$WH IHHH;uHH\$0Ht$8H _H;uHH\$0Ht$8H _ HH HH H+Ht$8HHH\$0H _@UVWAVAWHl$H  HD$XH$  H	 H3HExMH HHEHE   HE    E A   H? HMVHE0   HE(    E ; uE3IIB< uHHMUHEP   HEH    E8 A   Ho HM8U3fff     H}H;   H+H   HHuH}HCuHH   LǺ%   HF HH   :
| uH:
z| uH:
o| u3tH+HHHsHEH}HCEH+Ht+HD$    L
) A   HHMPH)IE3HUHM8eYA   H| HM8WIHMX  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H
 HH    :u| uC:j| uC:_| u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMOIIE3HUHM8XHE8H}PHCE8H
r HL$03HL$8HL$@HD$HD$PHT$8HL$H	 H	 HD$0HT$0HM5 HHL$` H	 HL$`C HUAVAWHhH@  HD$XHXHpHx H9	 H3HE8L= HLEHE   E3LuDuEF"HV@ HMRHE0   Lu(DuEFHq HM`RA@      H}H;   H+H   HHuH}HCuHH   LǺ%   H HH    :z uC:z uC:z uAtH+HHHsHEH}HCEH+Ht+HD$    L
& A   HHMMH(IE3HUHMVA   H{z HMTA? tI@ IC<7 uMIHMTHEH}0HCEH
* HL$03HL$8HL$@HD$HD$PHT$8HL$H H0 HD$0HT$0HMm HHL$` H	 HL$`DA @SH0W)t$ f/Ȼ   (vW5 (W  (,t
Xʃ\
(\(f/
 v\(Y
 (W fnY(t$ YH0[Hx)t$`(L f/)|$PWD)D$@D(D)L$0D(v(8W W۲   fD.z  f.zv  D)T$ D. fA/L  D
B fA/r4D: ff     AX(V fA/XsD(E\
 eH%X      HЋ9
   X5` A(AYAY((Y
 (Y
 Y
 Xɔ
 Xɔ
 X
 YYYX
 X
 X
M
 AYYYXh
 X
 
 X(Y9
 AYX
 YX 
 YXX
 ^YY5ȥ X  D~ fD/v(U E(\D(AXl~
 eH%X    f/ƹ   HЋ   9
 h  A(A(AYAY((Y]
 (YZ
 Y
 X2
 X2
 X

 YYYX
 X
 X
 AYYYXє
 X
a
 X(Yz
 Xb
 YXF
 AYX^YY% X   9
 )  EYDW A(AY((Yܓ
 (Yɓ
 Y
a
 X
 X
 X
9
 YYYX}
 X

 AYYX(Y
 X
݉
 XE
 X
 YXɉ
 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
 + =֗
 (y H

 (
; 
 (
 
 F 
 (_ 
 (
 ):
 (î )

 (
 )>
 )
'
 * UH
*
 -+ =
 ( H

 (
_ 
 ( ʒ
 ʥ ʒ
 ( 
 (
% &
  

 (
ȧ (
 

 @* H
ܖ
 * =Ж
 ( H
 (
q z
 (C 
 (e 
n
 (
Ǯ 
  
ч
 (
 
 
ۇ
 ) IH\$D$WHp)t$`I)|$PHD)D$@(D)L$0EWfD/D
O A(.  `Q f.zuR :  !      f/   (LWЬ Hh((Y(T
 fD/vlY
У H f/vVfA.zu3(H       $   H$      E  fn "   Yy S   ^fA.<  6  A(-  fD/v(@ fff     ^AXfD/w$   (D)T$ )P f.(   u~Z f/vpH      $   H$   H#H;  fA/s(O (f/   
M f/  ,H Y<Z  Ğ f/v:N f/vz =Z  "   D^D\
 AY  H$   }D D(DX
 YE\A(%O 
 Yf/   AYf/wBAYA(\5 (N (A(N  (^^Yf/vvfA.zu3*H       $   H$      EË fn "   YQ (A\A((hN (A(DN ^Y(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_L$   HA H
74 z} L$   HzA H
#C ^} H\$D$WH`)t$PI)|$@H(D)D$0 f/ro(M f.z  (m(Wf/ WvW \M D(E3(LHqD\(:M D\  R f/vfWf.z0   (
 Tf/vL D(DW     ^\O TL D(   ֞ f/v$((\ʝ \
r (  D(of/=ԝ r! f/v(d  eL D(DHL$p{PL D((X \ 4L \ \=n YDXH\$xA(D(D$0(t$P(|$@H`_LD$pH" H
   LD$pHy H
   H(YL LL$0LD$83ô(T
9 f/
q w
Yכ H(H> H
4.   H(Y LL$0LD$8c(T
٦ f/
 w
Yw H(H> H
-   H\$D$WH`)t$PI)|$@HD)D$0(D D)L$ A(EWfD/   J f.zZ   f/ru(LW9 H((fY(T
 fD/vY
9  f/   ^fA.    A(  fD/v ff     ^AXfD/wt$p(I f.(   u~# f/vpH      $   H$   H#H;  fA/s(I (f/\   
 f/x  ,Hq Y<    f/v* f/Z  D^D\ AY   HL$pwD
j D(DX YE\A(I 
c Yf/vVAYf/  AYA(\5 (H (A(H  (^^Yf/v&   A\A((H (A(pH ^Y(H\$x(t$P(|$@D(D$0D(L$ H`_LD$pHƟ H
 b  H H
 .  LD$pH; H
B. w LD$pH; H
1= lw H- H
   H H
   H4 H
}   HL@UVWATAUAVAWH`H@HX IHHHiW@Ht3s HHD$(Hl$0HT$(H蜙  L?LwHOH$   L$   H$   H$   I;HMH(HCH;t+H;t"H Ht
HCHH    HkLLC3I|sMhInHO6IMKMIJ4    HIAKHIDIAIILI	K2HIDIAHLHMI I;|H$   I;}$N   IHIHIHII;|L7H_HSH$   HGH$   H$   L$   H;IMH)HFH;t+H;t"H Ht
H+HH    HnLLN3I|rMaL,    LHkHMCIvLIfD  HI@IIIDI@IILIIHID I@HMHM@ I;|I;})L   HKHHIHIHII;|H_H|$8HD$(HD$@D$H HCHD$PHD$X   HHt5HHHH;t\]HtHHHH;t?]HHHHGH;t"H Ht
HHH    H_H_HHL$8 HL$(_ H$   H`A_A^A]A\_^]@SH Hru  HH [@SH0HD$     t  HH0[HL@HPHHUVWATAUAVAWH  HǀXHX )p)xD)@D)HD)xD)hD(IHLyPH HLaE3M4$Mt$Mt$Hq L6LvLvLi8HRIM7MwMwLuIzHHϰWD$@HD$P    E3E3HT$@HjL\$HHl$@L+IE33HNH+H*HHHH?H   E3H*3DBHILI+HHt(ILI+H    HILHH;rMM;w'HIHNH+HHHHH?HH;rH$`  H$P  HI(HH[LL;uHVH;uHȯHHF)L;t$HV) HHVH袯H~H$`  H$P  HHHI$I$H;uIT$H;uH'I$ID$'H;t"LIT$
* HIT$HI\$$p   tv3IrNIE LHHA   L+MFIIJ    ff     HyHyH9K
H<HI IuI;   IE H<HI;r   A(W- 3MtlA(Y5' (Y= D(D\D
 D HfE/v((; AYA(((S IE HI;r3WD$XH|$h$   H$   D$0 D$( HD$XHD$ MH$X  LLD$XHT$p LHH
L;   IH   IW赭MIOI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'vs LI? I?IIHIHCIGHCIGH;H{H{HL$pH   HT$xH$   LD$pI+H*HHHH?HH;v HRHH=   r=At I@I;r L+Is I'v LIo H$   HtwH$   H+HH?H;ve H    H=   r<tI HAH;r9 H+Hs) H'v H HL$XHttHD$hH+HHH;v H    H=   r<t HAH;r H+Hs H'v Hm H   HT$HHHD$PH+HHH;v] HH=   r=@tD HEH;r4 H+Hs$ H'v HH H$P  L$  I[XA(sA({E(CE(KE(SE([IA_A^A]A\_^]LWATAUAVAWH  IǃI[IsA)sA){E)CE)KE)SH	 H3H$  HLHL$(D[ WD(W$   E3MIMMMH
HBH+HHueH I3IIH  HD$0D$8IHL$0N H H$  Hh  H$  HǄ$      $   HBH+HHwiH1 H$  3H$  H$  H@  HD$0D$8H$  HL$0 H\ H$  H H$  8   H$   A$   WL$@MLl$PMcz`IMt$M;v
H
 ~ IHL$@9PLL$PMHT$HLD$@    M;  HFH+HH;riH8 H$  3H$  H$  HG HD$0D$8H$  HL$0 Hc H$  H H$  ?HHH$   H4t$ HD$ H;   HD$ L;   H\$ I+HI;usIH+HHscI+HIH+Hs
H
{ ] HM+IIHIH+IMI;LCL;ICHL$@NLL$PHT$HLD$@H   IH   I;usIH+HHscI+HIH+Hs
H
  HM+IIHIH+IMI;LCL;ICHL$@dNLL$PHT$HLD$@Ht2HHT$HIH$  >DX8 XD$0WD$XILl$hLT$(Mcj,Mt$M;v
H
? ! IHL$XMH|$hE3H\$`Ht$XM;  H$  (D$ HD$ H;   HD$ H;   Lt$ L+IH;utHH+HHsdH+HIH+Hs
H
  HSH+HHHIH+HE3H;LCL;ICHL$XMH|$hH\$`Ht$XHt5JH,H;u   HL$X&H|$hH\$`Ht$XHt3HH\$`Ia
    HǄ$     E3L$  D$  ED$H^ H$  /HǄ$     L$   D$  ED$H H$  g/Lt$(EF`EyH$  H$  `H$  H$  IcV`HL$pILD$xIHT$pH+HHt.Lf     EHLD$xIHT$pH+HH;rIL+IMtDHHD$xH+D$pHH;r   = fD  A;^`5  x`
    HǄ$(     L$   Ƅ$   A   H H$  F.HǄ$     L$  Ƅ$   A   H H$  .HcI   L$  H褛HL$  HHL$@茛6Y0WHǄ$     L$   Ƅ$   A   H H$  -L$  HHL$p50H$  $H$  H$  AAN`;}4_
    HǄ$     L$   Ƅ$   A   H H$  -HǄ$(     L$   Ƅ$   A   H H$  ,EF(EyH$  H$  <^H$  NH$  @IcV(H$  ?IL$  IH$  H+HHt+LEHL$  IH$  H+HH;rIL+IMt$fDHH$  H+$  HH;r]
 "   D$(   Dd$ LD$(HT$ H$   萍  D$ HT$ H$   ]
 #   D$    Dd$(LD$ HT$(H$   J  D$ HT$ H$   d]
 $   Dd$ M   HT$ HL$@
  D$ HT$ H$   u']
 %    D$(Dd$ LD$(HT$ HL$0d  D$ HT$ H$   ,\
 &   Dd$ M   HT$ HL$X'  D$ HT$ H$      D$   D$   fD  A;~("  x\
 *   HǄ$     L$  Ƅ$p   A   H+ H$p  F*HǄ$h     L$`  Ƅ$P   A   H H$P  *HǄ$H     L$@  Ƅ$0   A   H  H$0  )HǄ$     L$   Ƅ$   A   Hr H$  )HcL$p  HINhy#HT$@H](IN0L$P  HLL$0  HINh>#HT$pH\(I   L$  H#HT$XH\AXAY7AXXXHǄ$(     L$   Ƅ$   A   H H$  (L$  HH$  d0H$  SH$  EH$0  7H$P  )H$p  VZ
 ,   INHLD$0H$    D$0HT$0H$   lH$  HtL$  L+IHT$pHt%L$   L+IWD$pL$   HT$XHtLD$hL+I_HT$@HtLD$PL+ICDT$0HT$0H$   H$   |V  (H$   HtL$   L+I(H$  H3 L$  I[8Is@A(sA({E(CE(KE(SIA_A^A]A\_HATAVAWHpH@HXHhHpHx )p)xD)@IIHLIHHHVH+HL$   Iz3HFH+HH   $   D(DXL%;HHI;tHHD$((XLHT$(I(H\HD$(LHT$(I\A^I4HHHD$(HHHFH+HH;mHL$(HtsHD$8H+HHH;v H    H=   r<t HAH;r H+Hs H'v H
 L\$pI[ Ik(Is0I{8(t$`(|$PE(CIA_A^A\HWATAUAVAWH   HD$0HXHhHp )p)xMHLB(W$   LKL+IL$   IIGMH$   HD$ MH$   IiHSH+HHL$P@WD$8HD$H    LCHHL$8輒3HKH+HHT$8H  L5	{ HIL43 HBX0 LL$PMHT$8IT3HCH+HHl$PHtvMHC  YILM+@ f     (AY	(XHCH+HHHAXAHHHCH+HH;rHHT$8LH -HHHHHKH+HH;Hl$PHHtmHD$HH+HH;vf H    H=   r<tJ HBH;r: H+Hs* H'v HH HtmHD$`H+HH;v H    H=   r=@t HEH;r H+Hs H'v HHv (L$   I[0Ik@IsHA(s(|$pIA_A^A]A\_@VWATAVAWH  HD$pH$  HP	 H3H$  MILHL$XL$   WD$@3H|$PWHL$@z>HL$HHtHFHHL$HHHL$HH^ LD$@H;   L;   I+HLL$PI;uwIH+HHsgI+HIIH+HsH
K
 - HQM+IIHL+IHM;HCH;HCHL$@=HL$HLD$@H   I   LL$PI;urIH+HHsbI+HIIH+HsH
	  HQM+IIHL+IHM;HCH;HCHL$@/=HL$HHtHHHL$HHHL$HIHT$@IPWD$`H$   
LFLL$`I{^  H$  H$   UHXH$  HtINHH$   PHt$hH\$`H~&Hfff     HHL$@HcH;|IHHT$@PH$  H$   H!H$  H$   HL$` HT$@HtLD$PL+IH$  H3 H$  Hİ  A_A^A\_^LSVWATAUAVAWH  IǃhA)sE)CH'	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  K  IIЯL$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   J  Hr H$   H$   -H$   H$   H$   HT$xLL+t
H{# HT$xW$   H H$   LMH$   {H$   H$   vmLMHH$     D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IR +fDnED^%u Aƅ    A   " A   H$   mH$   I話IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAI +fn^5Yt L$   (A(oL$   (A(o(A(H$   =tH% H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  F  II耜L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   E  Hb H$   H$   H$   H$   H$   HT$xLL+t
Hk HT$xW$   H H$   LMH$   kH$   H$   fhLMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3IB +fDnED^p Aƅ    A   y A   H$   yhH$   IIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIs +fn^5Io L$   (A(jL$   (A(j(A(H$   -oH H$   H$     H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I Ht
HɼI3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  A  II谥L$   H$   H$   L$   WD$xHt3 HHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   @  HR H$   H$   
H$   H$   H$   HT$xLL+t
H[ HT$xW$   H~ H$   LMH$   [H$   H$   VcLMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I2 +fDnED^k Aƅ    A   i A   H$   icH$   I艧IMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIc +fn^59j L$   (A(eL$   (A(qe(A(H$   jH H$   H$   w  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LSVWATAUAVAWH  IǃhA)sE)CH	 H3H$P  DL$tH$   LH$  H$   L$  L$   L$  L$   I0IxH+HƁ   LqIIIFH;t/H;t"I~ Ht
H蹷I3I3I~3MLD$xHD$xH$0  H$   H$8  HD$pH$@  L$H  MNIHH+HHHHH~!H$   A)HH;}LD$xMH$0  <  II`L$   H$   H$   L$   WD$xHt3 HѶHHD$xHL$xH$   H$0  H$@  H$   H$   H$   H$0  H$   HD$pH$  HD$xH$  HHH+HHH~(D  )HH;}H$0  H$   LHH$   ;  HB H$   H$   H$   H$   H$   HT$xLL+t
HK HT$xW$   Hn H$   LMH$   KH$   H$   F^LMHH$    D$  D$tF48Ld$hH$   HL$`H|$PH$   HL$HH$   HL$@D$8$  L$0$  t$($  |$ EE3I" +fDnED^e Aƅ    A   Y A   H$   Y^H$   IٓIMHH$   P Ld$hH$   HD$`H$   HT$PH$   HD$HH$   HD$@D$8 D$0t$(|$ EDD$tAIS +fn^5)e L$   (A(u`L$   (A(a`(A(H$   
eH H$   H$   g  H$P  H3 ($p  D($`  HĀ  A_A^A]A\_^[LD$HT$HL$WH@HD$0H\$hHL+H*IHHHH?H    HHAHAtQH
H;vH
b D H!HHCHHHHKLHT$`HL$X  HCH\$hH@_LD$HT$HL$WH@HD$0H\$hIHH+H3HHAHAHtMHH;vH
  H
)HHGHHH_LHT$`HL$X6  HGH\$hH@_@USVWAVAWHl$H   HEH	 H3HEIIHL
g9
 eH%X      LE3B
9Y
 ~^H
Y
  =Y
 uIH
U
    L=T
 D=T
 EGHj H
T
 H
  H
X
  HE   L}E A   Hj HM^LHUH
T
 :{HMHE   L}E A   Hj HMLHUH
;T
   HMHE   L}E A   HWj HM; oHE   L}E A   H3 HMHE   L}E A   H HMHEHD$ LMLHUH
S
 HMHE   L}E A   Hi HM2HE   L}E A   Hi HMHE   L}E A   Hi HMHMHMHMvWeHEHEH}fn^ ^HfnH\Y(YY7^ (\Y\eIHMG:  IHMH3 H   A_A^_^[]HUSVWATAUAVAWHhH   HD$0)p)xHv	 H3HEMMHH
I6
 eH%X      L3B
9T
 ~]H
T
  =T
 uHHR
    HR
 xR
 DCHMh H
fR
 H
Z  H
=T
  HGH+H  W(HE   H]E A   Hh HM+LHUH
Q
   HMHE   H]E A   Hg HMMHUH
Q
   HMyHE   H]E A   Hg HMA$f/woHE   H]E A   H HMpHE   H]E A   H HMIHEHD$ LMMHUH

Q
 hzMHUH
P
 HMHE   H]E A   Hf HMHE   H]E A   Hf HMHE   H]E A   Hf HMLOL+ILHUH
\P
 7HMHMHM	HGH+HA   I;IFEI;LGHHL$@*/q[ A^$HMt{LA%f @ HcIQfAn\(T(Y\f.zuAf/AGfnYHL$@\HI;r(HHL$@4  HL$@ CHP
 HHHP
 H;P
 r
   "HHL$8HtW HHHHMH3 ($   ($   H   A_A^A]A\_^[]@USVWAVAWHl$H   HE)$   HL	 H3HEIIHL
2
 eH%X      LE3B
9P
 ~^H
P
 Z =P
 uIH2P
    L=#P
 D=P
 EGHd H
O
 UH
 q H
]P
  HE   L}E A   Hwd HMLHUH
O
 sHMHE   L}E A   HCd HM LHUH
cO
 ΢  HMdHE   L}E A   Hd HM Wf/woHE   L}E A   H HMZ HE   L}E A   H HM3 HEHD$ LMLHUH
N
 RvHMHE   L}E A   H{c HMHE   L}E A   Hdc HMHE   L}E A   HUc HMHM:HM0HM&uHEHEH}W ^HfnH\Y(YYV (\Y\uIHM3  IHMH3 ($   H   A_A^_^[]@USVWATAUAVAWHl$H   HD$8)$   H'	 H3HEIMLL
.
 eH%X      L3B9PJ
 ~^H
GJ
 6 =;J
 uIHK
    H=J
 @=J
 DGHb H
J
 1H
 M H
I
  ID$I+$H  H~   WHE   H}E A   Ha HMMHUd  HMjHE   H}E A   Ha HMMHUH
%J
 萟  HM&HE   H}E A   HYa HMPLHUH
I
 茴HMHE   H}E A   H%a HMHE   H}E A   Ha HMHE   H}E A   H` HMHFHD$(H|$0MD$M+$ILD$ HT$(HL$0HHDHD$ L;HBHLMHUH
I
 'LLHUH
H
   HMHMHMIHL$@&(Mt$M+4$I   L;LFHVL;LFHM踻HH]H9Nv3H
/T @ fff     Hc(^HH;NrMtcI$fS fD  HcHIfAnE \Y(YY\YHD$@\HI;r(IHL$@-  HtLEL+IHHL$@ CHAI
 HHH3I
 H;$I
 r
   HHL$ HtW[HI?IHMH3 ($   H   A_A^A]A\_^[]HUSVWATAUAVAWHhH(  HD$8)p)xH|	 H3HEMMLH
*
 eH%X      L3B9J
 ~^H
J
  =J
 uIHI
    H=~I
 @=gI
 DGHD^ H
UI
 H
  H
J
 C IGI+H  IFI+H  WHE   H}E A   H] HMMHUH
H
 ؗ  HMHE   H}E A   H] HMHMHUH
H
   HMڽHE   H}E A   H] HMMHUw  HM蝽HE   H}E A   H`] HMHE   H}E A   HI] HMHE   H}E A   H:] HMyH|$0MFM+ILD$ IWI+HHT$(HD$ LL$(I;ICHLMHUH
G
 LMHUH
xG
 HM蹼HM诼HM襼IHL$H#t$hHD$hHD$pLl$xM'I_I+HM>IFI+HH;HFظ   H;HFIE @=O ^  (Htt%:O ff     HcAI\PY(Y\(Y\(YHD$HX(Y\HL$pXHH;r(HHL$@'  HL$Hz CHE
 HHHE
 H;D
 r
   
HHL$0HtW3HH>HHMH3n ($  ($   H(  A_A^A]A\_^[]LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHHH|$`HHH0_^[LL$ LD$SVWH0HD$ IHHLD$hH;t%H|$PHtHHδHH|$`HHH0_^[H\$Ht$WH Ii/  HHX f@  Ht4HH3HC   Hs@3;Hs Hs(Hs0Hs8Hs@HsHH\$0HHt$8H _LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Aqh  IB  H1H;>u=IP I5  H$   HD$(LAII,h  I  H;uAH^HK I  H$   HD$(LE3IIg  I  IP I買   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I7tCHCIIπx H$   HD$(tLE3(g  I   LAg  I   IHO    H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS Iqt=HGIIπx H$   HD$(tLE3bf  I6LARf  I&H$   HD$ MHT$8I i  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ HT$SVWH0HD$ I.,  HHD$hf@  HX H\$XH\$PHtJHHC   3HsH{rHH@0IE3H;Hs Hs(Hs0Hs8Hs@HsHHH0_^[LAUAVAWHPICI[IsI{Mc MILLHy uH$   ICL	Ai  IB  H1H;>u=IP Iմ  H$   HD$(LAIIi  I  H;uAH^HK I菴  H$   HD$(LE3IIVi  I  IP IR   Hǀ tH_UH{ uHCx uBD  HH@x t.HOy u    H;u
HHIy tH؀x HDHK I׳tCHCIIπx H$   HD$(tLE3h  I   LAh  I   IHO 聳   H߀ uKHGx u!HH x u5    HH x t HGx uH;Xu
HH@x tHH;tHS It=HGIIπx H$   HD$(tLE3g  I6LAg  I&H$   HD$ MHT$8Ipj  HIIL\$PI[ Is(I{0Mc8IA_A^A]LL$ LD$VWAVH0HD$ H\$XIHHLD$hE3H;tJH|$PHt1HG   LwHrHH  IE3HHH H|$`H HH\$XH0A^_^@WH0HD$ H\$XH4(  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@WH0HD$ H\$XH'  HHD$@f@  HH HL$HHL$PHt	H HH\$XH0_@VH Hl$8HIH;&  H\$0HY H|$@Ix Lt$HE3H   CHOCGH   LwD1H;sLCItHS$ HCHLsHCHGHHH   H;LsrHCHCD0HOHG    LwD1H{ sLCItHS HCHLsHCHGHC HG HC    H{ LsrHCHCD0HHHHHHHCH;Lt$HH|$@H\$0Hl$8HH ^@WH Ht$@HIH;   H\$0HYHl$83fD  HtlHG   Ho@/H;sLCItHSH HCHHkHCHGHHGH   H;HkrHCHC@(CG H(H(HCH;zHl$8H\$0Ht$@HH _H;tMHE3@ Mt,MMHMHHAI HAI@HI@LILIL	HIHAH;uI@WH Ht$@HIH;   H\$0HYHl$83fD  HtfHG   Ho@/H;sLCItHSH HCHHkHCHGHHGH   H;HkrHCHC@(H H HCH;uHl$8H\$0Ht$@HH _@SH0HD$     :HH0[HUVWHhH   HEHX)pHl	 H3HE'I(EM
o
 eH%X   A   H3A9,7
 ~^H
#7
  =7
 uIH8
    H=8
 @=8
 DG
H) H
8
 H
>  H
6
  HE   H}E A   H HMfuH      HEH#H;upHE   H}E A   H HM$HE   H}E A   Hf HMHEHD$ LMLEHUH
7
 _HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   H}E A   H HMZuHHEH#H;vpHE   H}E A   H HMHE   H}E A   HZ HMHEHD$ LMLEHUH
6
 ^HEHrPHHMH=   r<t HAH;r H+Hs H'v H HE   H}E A   H HMNLEHUH
.6
 HM߫HE   H}E A   H HM	LEHUH
5
 HM蚫Hr
  YEXHM'H3 H$   ($   H   _^]HHXHpHxUATAUAVAWHhH@  L   M)pA   )xMD)@HD   HA$D)HD   D)PA(DHI A\D)xD)hD)XD)H(D)8ATD   f/  L   WD= D   D   D   D   gfffH      AЍD;uA(AXAY   A(A(A\AXY0> ^A(\AY(Y\ fE/(vWVH (A(AXA(A\XA\\XYA(^\   H   H#H;t.Y5
< A(A]Xf/wA(A_\f/vA(AXAYWH   I^H HD$hEIHEHGH;t+H;t"H Ht
H+HH    H_LHD$ HD$@3HD$`LD$ LOHD$HH   HD$PIHH|$XH+HHHH~6fHEEf(HD$hfYfXA)HH;}LD$ MHL$@	 H   MMHL?  A(A]f     ((XAY\A$ATf/  H   I^H HD$hUIHEHGH;t+H;t"H Ht
HHH    H_HHD$0HD$@HD$`HD$HH   HD$PHL$0LGIH|$XHH+3HLMM~<f     HEEf(HD$hfYfX)HI;}HL$0IHL$@ H   MMHKL|$HLt$PI~ u(&IHL$`HD$hIHD$xHD$@HEJ!(H   A] (YH   Xf/wXfA/sQH   (AT WD f/   A(A\Yf/rE(E(E(DD(D(D(D(D(D   A(A$A\AD   (ATf/   L$@  I[0Is8I{@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\]3H\$Hl$Ht$H|$ ATAVAWH eH%X   HD
3
 I   LNB	9z.
   HII9H3H--
 HLL%-
 HL=-
 H;1HLH0  HEHDL   IIL;LLI;~8HHIHHuI H   IH+HHHIHH+HLLIIHHI3Hŀ   L+L;|J    IHI  H IL3IA   HAHL;LHMLII;~/HIHHtIH   H+HHHL+L   I;   ILHH=   LMtH=   @  MH;HLL3KIHIHL;LMLI~IHHH+L+Mt*HHIHtH   IH+HHHL+MH\$@Hl$HHt$PH|$XH A_A^A\H
p,
 s =d,
 H
+
 H
K,
  H\$Hl$ VWAUAVLl$HLHl$PIHIE33LIM  Ld$(LL+L|$0I3H  LIGHMVHOHkLIM   IPHHHHIpHDIxHDIBHDHUIBIPIHHIBHDIBHDIBHDIBIIPHHHIBHDIBHDIBHDHUIBHIIPHHIBHDIBHDIBHDIBI;H;}OHMVH+OMIMR IPHHHHIBHDIBHDIBHDIBH;|MHI;Hl$PL|$0Ld$(M;   3H   HwHFHMVOʍZMID  I MR IHHHIHIJHKIHI IHIJI IHHIHIJHKIHI HIHIJH;|H;}!IHI HHIHKIH;|HIH+LM;*H\$8Hl$@A^A]_^H\$Hl$Ht$ WATAUAVLl$HHLd$XILt$PHL|$(E3MH,IHHH+3HLMH~gH|$PN4    I+I+HM3M~5NI MI IHIHHHLA)AA)II;|LHH;|Lt$PI;}gIK,$I+I+Hf     LE3M~7JOZ@ f     IHH[I IIH)CM;|LHI;|L|$(I;   @ ME3I   IkHEHH^JAyMII H[ IHIIHHHKHOIHI HHHKHIHI HHHKHOIHI HHHHKL;|M;}!IHI IIHHJIM;|IHI+I+LI;'H\$0Hl$8Ht$@A^A]A\_HHXHhHpWAVAWH   )xH-D)@HD1 Ip     D)HI   D
/ D)PD/ D)XEWD)d$@D%0 D)l$0D-< D)t$ D5{/ )pغ   H  W4   H*AYff        Hc  WHH*X(AYH5rԺ   H7  WH*LcXEFLcAYB0 BY0 f/O    fD  HiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zB` B0 fA/B` (\\YXr*((B\0 Y\YYX\(((B\0 Y\YYX\fD/&fD/w(YAYAWC f/ fnY($   L$   I[ Ik(Is0A({E(CE(KE(SE([E(cE(kD(t$ IA_A^_=E/ H  (H^  (XYf/vXfnY(jHL@WATAUAVAWHPH@HXHp )pMLL I^WD$(Ht3W H~LHD$(L|$(H\$03HcI;^}UI4H#
 HHH#
 H;#
 r
   FHH$   Ht
(HILD$(H$   IM ;  H$   HCH$   HI~I;|$t!I$ HtH}I$I4$I|$H      ?HCH=."
 H
G"
 H9
8"
 t	H
"
  HH+!
 HH+AH    HH+H;sHHHPI~ ~3M$H@ ff     J:@BHRHcI;F|Iъ s L\$PI[0IsH(t$@IA_A^A]A\_HWH   HD$ HXHHHH8 3H$   HH$   HH$   H_q H$   HLCL+H$   q A   E3H$   HL$0C HD$0HcHHD$0HȺ   . HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQDuHL$0> u2HL$0 H$    HL$0 H$   b 2H$0  H   _I;   H\$Ht$WH0IHHHH+HH=   ~H@ f     LHL$ H@  HD$(H;wH
H\$ H;vHH+HH=   HH*  H\$@Ht$HH0_@SH HHHSH
1 H3H
HJHH 3HC HC(HC0Hr C8HHp HCHH [@SH0HD$     
	  HH0[LLI;   IH+H|aHALHIJHL+HII+HHHM     ID	HAI	HID	HAID	HAHI HuM;}(ICLIHL+M+JJ
HHRIuL	HQI+HHuWAA   I;v`HBHr<HJHIAHL        X@X@X X@H HuL;sKI+X HHuLSH   HBHBLJ HR0ISACICMKMCIx uWH   [HT$h)$   HL$(  H$   HHD$`HL$HHL$ HD$Xi  HL$8(c 3($   H   [HIH%= H%! H\$WH H t
h   H HH\$0H _@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHA L@L+ IA@HcH4    H;
 LHH.
 H

 H;rHLH
 H

 HHH
 H;rHH3LC IHI+HHt(fD  I HIHLC I@I+ HH;r3H9S~LC3JH9HIHcH;C|HC HHH+HHcHC8HIHC(HH]
 HH0HO
 H;@
 r
0   HH\$`Ht!(HtH5n HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_@WAVAWH@HD$ H\$hHl$pHt$x)t$0(LHHAL@L+ IIcH4    H
 LHH
 H;s
 rHLHg
 HHHZ
 H;K
 rHHH?
 3LCIHI+HHt2f     I HIHLCI@I+ HH;rH
 3H9S~-L3ff     JH9HIHcH;C|H
 HH0H
 H;
 r
0   AHH\$`Ht!(HHl HHkLs H{(IIH\$hHl$pHt$x(t$0H@A_A^_AVH@HD$ H\$XHt$`H|$h)t$0(HHH

 LHH
 H
 H;r   LH
 H
 HHH
 H;r
   [HHKHIHHH

 HH0H

 H;

 r
0    HH\$PHt%(HHyk HHC   Ls Hs(HHH\$XHt$`H|$h(t$0H@A^H\$HALHPLBLBIHH+HLIHHHHH    M?  IRfo- (
TI~k(RTH~FHCHLR HLZ0@ ff     A(MR M[ Tf_A(CTf_Huf_L;~H(Tf_(f_M;   - II+H|gIHBI+JHHHM@ ff     @T_HH@ TT_@T__(HuM;}JM+ H@T_(Iu(H\$MJ   %f, ATL;   I~XIHHIAHH        @HT_XTH@ TT___HuI;}(IL+H@T_(Iu(H\$H\$(DD$HL$WH0HD$ H\$HHt$XHH3t$PHSo HA@Hs HAPD$P   ?Hi HHOH~ HHG@HcPHl HD:@HG@HcPDBDD:<HSHHDQHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH~ HAPHs HA`D$P   oHg HHO(H{ HHGPHcPHo HD:PHGPHcPDBDD:LHS(HHDHH\$HHt$XH0_H\$WH HH4 HHQ3HHHKHB| H`s HHCHGHC H\$0HG 3HG0HG8HG@HCd GHHHJh HG(HH _H\$WH HHH;Qt>H		} HtH]  HH{H\$0H _H    H{H\$0H _HyH\$0H _@SH Hٹp   E LHtHHHtHHIHHtHHIH [HL$H( LD$0HT$8`T( f/  wU LD$0HT$88T( f/ wA LD$0HT$8Ty( f/ w-H(H; H
Բ x  H' H
 x  H H
 x  LVWATAWHh  HqG	 H3H$@  H$  E3H$  IL$  L$   HD$pHT$`H|$xH  I0I8I[J    H$   HIkHHMkLH$   IMsE3I+A)sH$   WIIǃ    Lt$hHD$HN8H$  H$   HD$@   L;)$   M)$    ILD$8H\$0H|$(H\$ )$   )$   )$   )$  )$   )$0  AE3H(  HD$p3HL4    MNMLL$`ML;   H   HH$   I+L$   HH$   LIHHIHI+HHHMD  D
XA	AX
	AXAAXIIH HuL;}2HH$   I+KHHI+
XHHuIMHH L;H|$xH$  Lt$hHl$`HD$HJ#IHD$@H    MHHHH$   HH+H$   LH$  H$    D$8H\$0H|$(HL$ /@L$   IL$   IH$   Lt$hL;($P  L$`  L$  H$  H$  H$@  H3i Hh  A_A\_^HWH   H@HXHhHpIIHIPHH3DH9{~*LD$`     HHIAHRIcH;C|WD$HH|$XD$xH$   D$0D$(HD$HHD$ LD$`HOHl$PH\$HH+HH;ntH@w Ht
H{iHH>HnH~$H    HHH
HRHcH;F|HL$xHtwH$   H+HH?H;vw H    H=   r<tw HAH;rw H+Hstw H'vgw H6 HHtmHD$XH+HH;v7w H    H=   r<tw HCH;rw H+Hsv H'vv HH躤 HL$`HtiHD$pH+HH;vv H    H=   r<tv HAH;rv H+Hsv H'vwv HF L$   I[IkIs I_HL$VWAVH0HD$ H\$`Hl$hLHHrHjHL$X3HHAHAHt$HtHHHH;tHHHt3t H+gHHkHsC  IH!t  HH\$`Hl$hH0A^_^@USVWATAWH$H  Hy@	 H3H  HyE3LEALMLHU HHM H}D$! Dd$ HNAH9J~ A    I HRLHcI;@|HW f/wf/AAE9	  L$@  HL$  M)$  )$  D)$  HC	  =E  WD f     HNLHHM+H  H9N  HLVI+Ll$0D$@HHT$PL$8L|$`HP  L$XH  p  LLD$(HMD$(LE@  D$H`  HFHHEH8  HE  HE H  IH B<L;~  HH+HNHfo T$PHHL$8fHD$(D$(HMH  UxEHHE0JHEHU0Ht$@L$8H|$HD$HHuMXLufo
, foLu@MH  EhL  E   M  E  fo
 f      t  LNLIHILMH+HuML}IH}HHMEH  II  ELM  H   IMIH  HL$(  L    LL$0Ht$@L|$HLt$PLL$XD$(H+H]8L$8H   EHHL   D$HH  HE0MXHM0L$XEhMx&u  HFMVH   HHIHHHHL;b  HI+H
  H_MZfD  HMCHFHIIHHIHIHNHHIHFLHVHIIIADIDLFHLBMCHHFHIIHHIDHDIHNHIHIHFLHVHIIIIADIDLFHLBL;L;}@HFHHIIHHIHIHNHIHL;|HMeLNMnfo IIEJLeILmHM(ML   H   L   HH   JH   L   L   H\$hLt$xHuLuL  L  H  L   L(  L0  M  LmMQIMm I   IM^HMEHEIHIHUIL}IHHHMIIHIHHHUIHuHHHIJ    M@ YA@BYAH YA@BIBYHMAHIuHu E3HM(LeH\$hI;}=N    LN    LJJ IYIAD HI;|D$hLmLEhL$xH~HU0HH  IE HE0HD$(EIEM@HD$XH  MEPLt$0D$(Ll$@M`L$8L|$HEhH  D$HMxL$X   I   賴  H  \M      IE LM  HD$hL   IEH(  `  HEH`     Lt$pp  Lm0    L}D$h  L$x(  E8  MH  DEX  ? LmH   L   HNHHI(Tf/@Mu	@  M   @   H   MH  H  HEH  HEHD$"HEH   HE  H  uHHڃI;LLII+yHHHM3I@  L;}.@ H    fB(f^B)IL;|MHMH  |$! t@tE2Dd$ @uD$!Dd$ H]uf/v7   /uf/v$   uf/vD;f/v   H]ML;A($  ($  L$  L$@  D($  H  H3莑 H  A_A\_^[]HEMH}    H_f     |$  HE H F   LFHII   LD$pLEL  HuL$xHL}HT$hID$hH+L]`  H  MP  HH@  EHM0H8    H  H   p  8  MHh  E8X  Mh  EXx     Ex     n  t2IÈD$ HL;s@UVWAVAWHl$H  HD$XH$  H4	 H3HExMH HHEH% HHEHE   HE    E 8 uE3IIB<  uHHMֱHE0   HE(    E ; uE3I IB< uHHM蚱HEP   HEH    E8 A   H HM8o3@      H}H;   H+H   HHuH}HCuHH   LǺ%   Hg HH   :

 uH:
 uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
 A   HHM蒬H)IE3HUHM8%A   H$ HM8迳IHMXl  LuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   He HH    : uC:
 uC: u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMLIIE3HUHM8߳HE8H}PHCE8H
2n HL$03HL$8HL$@HD$HD$PHT$8HL$Hd HPe HD$0HT$0HMk  HHL$`Gl  Hh HL$`L @WH@  HD$(H$P  HHD$     HL$@~   HL$0b LD$PMcHHL$PIHPHL$Pc HHL$@H$   H$   c HH$P  H@  _Hx)t$`(L f/)|$PWD)D$@D(D)L$0D(v(8 W   fD.z  f.zv  D)T$ D. fA/L  D
B fA/r4D: ff     AX(ɴ fA/XsD(E\	 eH%X      HЋ9	   X5` A(AYAY((Y	 (Y	 Y
	 X	 X	 X
	 YYYX	 X	 X
]	 AYYYX`	 X
0	 X(YI	 AYX,	 YX	 YXX
	 ^YY5 X  D~ fD/v(蕳 E(\D(AXl	 eH%X    f/ƹ   HЋ   9	 h  A(A(AYAY((Y	 (Y	 Y
	 X	 X	 X
	 YYYXv	 Xv	 X
	 AYYYXI	 X
Y	 X(Yr	 XZ	 YX>	 AYX^YY% X   9	 )  EYDW A(AY((YL	 (Y9	 Y
A	 X!	 X	 X
	 YYYX	 X
	 AYYX(Y	 X
	 X	 X	 YX	 AYX^AYDY
 AXD(T$ X((t$`(|$PD(D$@D(L$0HxH
	 ɉ =	 (y H
	 (
; 	 (

 	 F 	 (_ 
	 (
 )J	 ( )
,	 (
 )N	 )
7	 ވ UH
~	 - =r	 (
 H
^	 (
_
 0	 ( B	  B	 ( 
	 (
% 	   
	 (
  	 
		 @ H
X	 菈 =L	 ( H
8	 (
q 	 (C 	 (e 
	 (
 	  
	 (
 	 
	 貇 IHHh  HD$X)p)x((Wf.zu(^ Y   f.z  f.
;  z0u.(W
 c((cYY5 (L  f/
 rT=
 (c.  (f  HyDJ J ȃw_H< H(+g     (~h     ((^     (i     (     (j     H#f HD$03HD$8HD$@H۩ HD$HD$PHT$8HL$H\ HbP HD$0HT$0H$   k  H
 HH(H
x HH0@8B  HH$   -  HHL$`?  H@ HL$` ($P  ($@  Hh  Ð- : G W d q HUVATAUAVAWHxHX  Li3ILLDM  B 
  HXH      ?HxI)p)x=  D)@EWE@MHfMFLMPIIILD$(LD$PLEH|$`HL   HT$ ID$ H+Lt$8L$0HEL  D$pHHt$@MHAHL$XL$PHU`MHL$XL$hHE`HGL|$HD$@HEh   Hǅ      ED$XMExD$x   M   E      E     IIINLuMHuL}HH|$`J\MNMIIMLMIH+LMMMIHUHMHEHD$XD$pEEIVI  H+H+HL$@HHT$HIT$HI  D   H|$(HH|$0Lt$8HL$0H+LL$PILMHD$ D$ I$X  H  L$PLx  LE`HE(HEH   HEH  HEHE`H}hLexH   H   LE(HU8HEL$hH  D$@  Mh  D$X  M  D$x    E  E  AuIIAL;ILHH+yHHHML3H4C螓  H;}&f        HE(f)HH;|LHMHd  LM@L  HH  HM`* MF3IIILD$(LD$PLE Lt$8L$0HHt$@HT$ IMD$H+D$ HMMHIL$PH+HEI$EH   L|$HD$@HH}HM`HUHM`MEH}hLexL   转  MN(IIIYH|$`YLd$pLL$HHIH+D$(LIT$I$HH+HUHL$xLD$8HU8LHE(LT$XHEHD$ HEH  HELU(HD$XLHEAuIIAL;MLHI+yHHHM3I@f  L;}1HD$8D$(HM(fBfYfBXB)IL;|LHMH!  MNMD$I$IH+LEMHT$xLMHLMHL$XIIILL$PH+L   H   LuMIHuHHMEIVIHE`H+H+HT$HExHHL$@I   M   L}LMHEHH|$(H|$0HU`   Lt$8H  L$0IH|$`HD$ LD$XD$ Ld$p   H}hL$P  D$@@  0  x~  IIINEPHH      ?HBDI$B4IM;D($   ($0  ($@  H$P  H$  HX  A_A^A]A\^]HT$WH0HD$ H\$PHHH        @   @   H
\M HHxHHH\$PH0_HT$WH0HD$ H\$PHHH        @   @   H
4D HHxHHH\$PH0_@USVWAVHl$H   HE)$   H 	 H3HEIHHDc	 eH%X      NE3B	9	 ~^H
	 } =	 uIHV	    L5G	 D50	 EFH
 H
	 虝H
A 赂 H
	 | HE   LuE A   H
 HMZLHUH
	 6WHMaHE   LuE A   H
 HMLHUH
	 ?  HMaHE   LuE A   H[
 HMҜ; oHE   LuE A   H/ HM覜HE   LuE A   H HMHEHD$ LMLHUH
	 nHMaHE   LuE A   H	 HM.HE   LuE A   H	 HMHE   LuE A   H	 HMHM`HM|`HMr`fn5 ^ fn\Y%	 WX\YY6 \(HMH33y ($   Hİ   A^_^[]HUVWAVAWHhH   HEHX )p)xH	 H3HEMLHD]	 eH%X      N3B	9	 ~]H
	 z =	 uHH	    H	 |	 DCHi H
j	 蕚H
>  H
	 y HGH+H  WHE   H]E A   H+ HMBLHUH
	   HM^HE   H]E A   H HMMHUH
	 ;  HM^HE   H]E A   H HM躙Af/woHE   H]E A   H HM舙HE   H]E A   Hʄ HMaHEHD$ LMMHUH
	 MHUH
	 HM]HE   H]E A   H HMHE   H]E A   H HM՘HE   H]E A   H HM讘LOL+ILHUH
d	 OeHM5]HM+]HM!]H7HGH+H   H;HFH;HGA= ^谟 (HtOfAni	 %) f     (X(\Hc\TY\HH;r(WHMH3u L$   I[HA(sA({IA_A^_^]HUSVWAVHhH   HE)p)xH	 H3HEIHHD	 eH%X      NE3B	9	 ~^H
	 v =	 uIH	    L5v	 D5_	 EFHT H
M	 H
; | H
	 Kv HE   LuE A   H" HM蹖LHUH
	 PHMK[HE   LuE A   H HMuLHUH
	 q8  HM[HE   LuE A   H HM1Wf/woHE   LuE A   H HMHE   LuE A   H? HM֕HEHD$ LMLHUH
	 HM[ZHE   LuE A   H& HM腕HE   LuE A   H HM^HE   LuE A   H  HM7HMYHMYHMY5] ^z fn\Y
	 X\YY \(HMH3r ($   ($   H   A^_^[]HUVWATAUAVAWHhH   HEHX )p)xH	 H3HEMHHULHL$8D
	 eH%X      N3B9	 ~^H
	 s =	 uIH	    H=	 @=~	 DGH H
l	 H
7 y H
	 :s IFI+H  I|$   WHE   H}E A   Hq HM舓MHUH
	 1  HMXHE   H}E A   H= HMDLHUH
	 @5  HMWHE   H}E A   H HM MHUH
q	 <JHMWHE   H}E A   H HM輒HE   H}E A   H HM蕒HE   H}E A   H HMnID$HD$0H|$ MFM+ILD$(HT$0HL$ HHDHD$(L;HBHLMHUH
	 ^LMHUH
	 bs  HMVHMVHMVI^I+H   H;HFIT$H;HFH\$(HMsQIT$HMdQHLmL}I9|$vOM4$IM+= Hc(A^B+Aؘ HH[I;t$rLmH\$(Lt$8HteMHEfnIII+	 % D  HcA\YY(X(\1Y\HHH;rMtLEM+II`MtLEM+IIG(WHMH3cn L$   I[XA(sA({IA_A^A]A\_^]HUSVWATAVAWHhH   HE)p)xH	 H3HEMLHD~	 eH%X      N3B	9	 ~^H
	 o ={	 uIH	    H=	 @=	 DGH H
	 赏H
3 t H
5	 o HFH+H  IFI+H  WHE   H}E A   H HMQLHUH
b	 -  HMSHE   H}E A   H HM
MHUH
	 ٖ  HMSHE   H}E A   HZ HMɎA$f/woHE   H}E A   Hz HM薎HE   H}E A   Hy HMoHEHD$ LMMHUH
s	 HMRHE   H}E A   H HMHE   H}E A   H HMHE   H}E A   H HMЍH}IVI+HHT$0HNH+HHL$8HD$0LD$8H;ICHLLHUH
	 AZLMHUH
	 +ZHMRHMRHMQL>H^I+HI6IFH+HH;HFظ   H;HFA$=` ^} (HtD	  HcA\Y(X(\YY\HH;r(WHMH3wj ($   ($   H   A_A^A\_^[]@SH HALHH$I$IHH;r6H|$0H|$XHO@HO PH}q H
 H@ H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMtj uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK IKt3H$   HD$(MDHT$pHH I$AD$I/H$   HN@oHN LHm I$AD$ IH\$xH$   H@A_A^A]A\_@SH HALHH$I$IHH;r6H|$0H|$XHO@nHO %LHl H
΂ x; H|$0L\$XHIBMKIL;uLXILI"EtMIL;uLMYIL;HuLXIKIÀy   @ f     HHLAIH;   IPz u!ABHHHQB HHHA  H;AuKHQHH
HHH
y uHAHHHJI
H;AuHQHHH;uHHQHHPHHAHHHQB HHHQLIHH
IHy uHQHJIHI
H;Qu
LAIP   HJH;Qu
LAIP   LIP   z u!ABHHHQB HHHA   H;uMHHHJHHJy uHAHHHJI
H;AuHQHHH;AuHQHHBHPHHAHHHQB HHHQLBIHJIy uHQHJIHI
H;QuLAHJH;uLLAILBHHy ILHHHAH [HHHWATAUAVAWH@H@HXHpMLHHHD$0HXL@{ }   My LHS HrHzrHI}rIM IH6LL;MBMt蚋 uL;s	3L;@@tHH[{ tHD$0Ht$pI@   L;0u5H$   HD$(MAHT$pH9H I$AD$I   A~ tI^QIx uHH@x u;HH@x t+IFx u    H;u
HH@x t{ HDHK IFt3H$   HD$(MDHT$pHH I$AD$I/H$   HN@HN GHNh I$AD$ IH\$xH$   H@A_A^A]A\_E3LL+IIH;MGMtI+MtJI IIM;uILL$ LD$SVWAVHHHD$ IHHH\$pE3 HWH;VteH\$xH$   HD$(H\$0HtHHHHKG  HHG(HGH;AuHHGHIH9OuLwH(H$   HHHA^_^[H\$Ht$H|$ AVH`L3LHI IpHD$ HAH;t'H;tH	58 Ht
Hp*HHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~HD$ ()HH;}HL$0HL$@xIVHOKg  L\$`HI[Is I{(IA^LL$ VILH;u2^Hl$)EըuHML+I}	2Hl$^H\$3H|$ HU H+H=[ H+DHDD:tD:uHAHArHL;   IH+H|9(uAz)   H\$2H|$ Hl$^Iu/L L+L
 L+A:tA:	uHr:IuL L+L
 L+    B:tB:	uHr@-tH      < @-tH        D$(H       HD$(H3H\$H|$ Hl$H^HAHHA8HHAPD HHMLAuCHAH$HY8L HAPIKMLLcM+LM;KHD+IBPED H$3HHB    HBHHHD$0MLtH   HAH$HHA8HICPLc L+LH+Et5AtAuKMxYM;THI+I"JHx@I;;HMx0M;+JIC8D+DHICPD IK8ICH	H+H
HH$3HB    HBHHLI;   IH+H|]HLHAIHAY ALAYADALALY ADYALHH;|I;} IHIBY HI;|LI;   IH+H   HLIIHLfD  IAA^AAXAIADA^AAXDADIADA^AAXDADIADA^AAXDADHH;|I;},IIKLHA^AAXAHI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+CBfXCBLCDfXCLIL;|Ht$H|$M;   II+H|kIHICHI@BBXBBLBXLBLBDBXDBDBLBXLBLIL;|M;}'IHICHBBXBIM;|[HMLI;#  IH+H   LIHIH+H\$HH<$IYL H   Iy MI0HHHD8B\DYDBXD BD L8B\LYLBXL BL 8B\YBX B D8B\DYDBXD BD H HsH<$H\$I;};IIKL HALI LY0AA\YAXAHI;|HLI;   IH+H|]HLHAIHAX ALAXADALALX ADXALHH;|I;} IHIBX HI;|@SILH+LI;B  H   HHIHt$H|$LI@H9IHIH4IHH;wH;sIHIHHH+H+BCf^CCLBDf^CLIL;|Ht$H|$M;   II+H|kIHICHI@BB^BLBB^LBDBLB^DBLBDB^LBLIL;|M;}'IHICHBB^BIM;|[@UVWATAUAVAWH$`H  Hǅ   H$  IHHMIJHSLKLLI  H  HGHD$xHGHEG EHG(HELUHT$hHM  HELpHEHpHKE3I;uH9st`Mt$HtHHHL;t!HIHKH;tH~- Ht
HHL#LsHsH3LkL   HKHL$XIHH3H+H؃H   MMH       II+HIIM       HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH}foe UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HMQ  HI;0ML;}vWD  (HMH~THEL    HEL    HENHEJ@      fAfYfXIMHuB)IL;|I;   f     HULBHJHL$ LD$(HT$8Ld$@L|$HHD$P   HEHHL$hHEHD$xHEHEH]fo UD$hEL$xM(EE8fUHD$ EPL$0M`D$@EpL$P   MuW	HM  HI;0H   IHH3H+H   H   H   L;HML1IJ    HL;|$XcHMq*    WE HHL$XHT$`HD$XHD$ HE HD$(H   HD$0H\$8LCLIHH+HHE3H~+@ f     fB)IL;}E HL$XHHL$ 5d      HG(Hx tL   LHH%a  H$  HĠ  A_A^A]A\_^]@UATAUAVAWH   Hl$`Hǅ  H  H  H   )  )  H- H3H  LMMLEPH   LH  HU0H   Lw LuXHGHE8LU8HM0H;LMIH   HIIIII;vIHHE HHuxL4    I   w2IFHHH;wHHHr H+HD$`HHHE 1IN( HE HuMtӑHILuXE3L9?LDL  Lx  H  H    H=     I;v|HGHEHu`H    H   w2HCHHH;wHHH1r H+HD$`HHHEH' HEHuHt3H9OH}HDH   H    H=   E 3HE(M  HEh3HM`IL  IH  MHULL   MIL   MLe8DX=G 5 MM;MLL   ML   M+L   IILL   M~>J	H    IH(  H0  LD$ ML(  I~HUA   3M   IMIHuL}(    H~KHBIHH    IH8  H@  HHIOLd$(HD$ LL8  HHHII;HUA   |L  H}LuX3HUH   H  L   IHH   LHM0fD  IM;IL3HupL  M  L  L`  IHMxIHH   HE`HE@LH   LMJ    H   IHH   HEhHMLMHIL   HH   HOH   H~OLH  LP  Ld$HLd$@|$8H|$0Ht$(H\$ MLE HH  dL  HULMHE3H@  N<    LEN,    M]HM(HH   I@HLEPM$MH   I+H+   MIIL   M  HIHH  LHE@HIHMPLIfff     A#(f3Hd  HryHSIHCIL;wI;s_HHHH+HH+I@M2ff     HBDfYf\HBfYf\HH H;|H;   HH+H   HQIMM+HH+HHHH@ ff     (BYL
B\B(BY
\(BYL
B\B(BYL
B\BH HuH;}/IMM+HH+(AY \ HHuMMHuH   L   L  M](A^$f(f3H   HrAHHHH+HH+AfYAAD(fYALHH;|H;}mHH+H|EHAIHH+HHHH     @fY@ fY H@ HuH;}(AYAHH;|IMMIL;H   HU&HupL   HE(HIHEL  IHX  Ht$0Ld$(H\$ LLX  H} HHHupHMxHHMxH   HE@LMHL   LMHL   L   L   I;L  HUMLm0H   H} H   H~hH   IHIHh  Lp  HD$HHD$@|$8HL$0Ld$(H\$ L   LHh  HUH   L   IHULLm0H;   H}nLmPLuXHE(IHE(LE8L   LE8HM`H   HM`H  HUhH;  HUH}A   L  H   }  t    t	I H  H3F H  H  H   (  (  H  A_A^A]A\]H(Hu3H(H?H;w*H\$ H    H HuHuH\$ H(肈|@SH Hb  H HCPH [HL$SH0HD$ HD$P    EtH HA@Hc HAPD$P   J   HK HH HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH& HHQ3HHBHKL H HH{3HHDH^H\$HH- HHOHKHtHPHGHCHGHCG C H HHP HHH\$PHt$XH0_@SH H  H3 HCPH [HL$SH0HD$ HD$P    EtH~
 HA@H HAPD$P   J   H HH! HCHC@HcHHN
 HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH.% HHQ3HHBHK HE HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H
 HHP HHH\$PHt$XH0_HIH% H\$WH Hl  H HGPt
X   HJ HH\$0H _@WH0HD$ H\$@HH HH HAHI HtHP tHC     H# HHK# @t
@   HJ HH\$@H0_H\$WH H  H HGPt
X   HI HH\$0H _@WH0HD$ H\$@HHx	 HH. HAHI HtHP tHC     H8# HHKc @t
@   HHI HH\$@H0_HL$WH0HD$ H\$PHt$XHHHJHHHFHGHHFLL+tj H_H\$HHN^HHHFHCHVHFLL+tj HH\$PHt$XH0_H\$HAE3HLM9S   @ ICMI;LLL;}6HSLHBHJHI^BIHI HIIM;K}FHSLff     HBHJIIIIH^BI IIM;K|IM;S^H\$LWH   ICI[H H3HD$xIHI HWf/w}IC   IC    D$8 A   HM IKbHD$p   HD$h    D$X A   HSM HL$XaHD$8HD$ LL$XLHH
,	 AHL$xH3? H$   HĀ   _@UVWH   HD$8H$   H H3H$   IHH3IIHH+HH   II      @      D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HOL HL$@`HD$x   HD$p    D$` A   HL HL$``HD$@HD$(HD$`HD$ LLHHX  H$   H3G> H$   HĐ   _^]HWH   H@HXHp H H3H$   IH3IIHH+HH   II      H@D$0HD$0I#I;w
HH;r   HD$X   HD$P    D$@ A   HK HL$@_HD$x   HD$p    D$` A   HJ HL$`z_HD$@HD$(HD$`HD$ LLHH
	 PY  H$   H3= L$   I[Is(I_@UVWH   HD$8H$   Hu H3H$   IHH3IIHH+HH   I      fD  H@D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   HJ HL$@i^HD$x   HD$p    D$` A   HI HL$`:^HD$@HD$(HD$`HD$ LLHHX  H$   H3; H$   HĐ   _^]@SVWH   HD$8HM H3H$   IHHfAn D$0H      HD$0H#H;u|HD$X   HD$P    D$@ A   HI HL$@m]HD$x   HD$p    D$` A   HH HL$`>]HD$@HD$ LL$`LHH/H$   H3: HĐ   _^[3HIHtH   H LH   ICAC    HQH ICH ICAC   IKKH HD$(H  HD$@HD$hHcHHK HDhHD$hHcHDd    Hv HL$(L @SH0HD$ HٹX   <= HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HH HHe HAHA@HcPH HD
@HA@HcPDBDD
<H  HHk HAHI HtHP tHC     Hu HHKH0[H% @SH0HD$ HHO  HH HAHI HtHP tHC     H HHKH0[H%4 LH   ICAC    HQH ICH ICAC   IKH HD$(H HD$@HD$hHcHH[ HDhHD$hHcHDd    H HL$(J @SH0HD$ HٹX   L; HD$@HSHS  HHtH@@HcHHB@HH0[@SH0HD$ HH/ HH HAHA@HcPH HD
@HA@HcPDBDD
<H HH{ HAHI HtHP tHC     H HHKH0[H% @SH0HD$ HH7 HH HAHI HtHP tHC     H HHKH0[H%D HH   I0Q@A HIP@A@P@A`fH~@HHuWHĈ   HD$8A    H$   H|$L@TI;   H|   K@H$   HMIHAMHIIHMHL   BTXTTXBITXXHuH$   L;}'J    MI+JHTXHu(H$   HĈ   H\$HAHIHPLJIHH+HLIHHHHH    M  (fYI~l(IfYH~EHCHLQ HLY0@      A(I fYfXA(I fYfXHufXL;~H(
fYfX(fXM;}pII+H|IIABBLYYXBDYXBLYIXXL;|M;}BIYXM;|(H\$   YL;~pI~PIQ@      LYYXDYXLYHXXH;|I;}HYXI;|H\$(@SH H# HHt
   : HH [DD$HL$WH0HD$ H\$HHt$XHH3t$PH# HA@H  HAPD$P   HW HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHD!VHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHc HA@H HAPD$P   H HHOH  HHG@HcPH/ HD:@HG@HcPDBDD:<HSHHDaUHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   H2 H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vCsHHMHHumJ    H   w2HCHHH;wHHHS H+HL$`HHHM*HH	 HHEHuHtrH3H9HDHEXH   L   J    H=      M;vrLnMu_J    H   w.HCHHH;wHHH>S H+Ll$`IIH LHuHt!rHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`H3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8HH@  HIH8  HHEpHMxH|$ MLEpIL  HP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   qHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
HP     t
HMX< H   H3u- H(  (   H   A_A^A]A\_^]LIKWAVAWH   ICI[IkIs LH3HHHhHyI{HH_Ht3 HHHoHHM~M6WD$HHHL$XHD$XHD$xHD$HH$   H$   H$   H$   LGIHH+HHH~&     f)HH;}
D$HHL$XHHL$xe?  HIHD$hHD$p   INIHD$xH$    D$0HT$ LL$hLD$xIV跿  HL$   I[(Ik0Is8IA_A^_@SH`)|$@HA8D)L$ EWfA.zSuQfD/
v% HA    (|$@D(L$ H`[ HA    (|$@D(L$ H`[D)D$0DfE.z4u2fD/H    v A   - A   A((TU TN f/vOA^)t$P5v (YXT fE/
) vW^3YWs(t$PJD^A(AYX# \T fD/ vW
 ^KAYWD(D$0(|$@D(L$ H`[@UVWAVAWHl$H@  HD$XH$  H H3HE8H HHEL=0 HLEHE   E3LuDuD80uE
IIF84 uHHMKHE0   Lu(E A   H HMKIH}H;   H+H   HHuH}HCuHH   LǺ%   Hv HH    :~ uC:~ uC:~ uAtH+HHHsHEH}HCEH+Ht+HD$    L
+  A   HHMGH(IE3HUHMOA   H+~ HM.NA? tI@ IC<7 uMIHMNHEH}0HCEH
	 HL$03HL$8HL$@HD$HD$PHT$8HL$HG  H  HD$0HT$0HM  HHL$`?  Hh HL$`: @USVAUAWH$ H   HrLHIHtIHHH;  HAHAH$0  L$@  E3L$H  LLL;tH	)  Mt
IdHL#HsHsI}IE MmHD$XH|$`H;uI;tRHtMtIHIH;  MLM;tH Mt
IHL#H{LkLKHD$hLIHD$ HD$XHD$(H8  HD$0LD$hLL$pLKH\$8IHH+HHHH~HD$X(A)HH;}LD$hMHL$ vLcIHw  LHSL;HHHT$(H\$8L$0Ld$@IH|$HMHHL$ D$ H+HT$PL$PHMLuHEHULLD$xED$@MED$x   M   E   M   E      E   MuW#H   LD$(HL$ HD$@HT$8s  (foע IHCHMEHEUHMHME0H]MH} E H}(M@fo
 fEPU`Mp;Xf/CvCHIH;HC m  H$0  HL$H  HADc$L$@  H   A_A]^[]ff@SWATAWHHB03LAL!L:LXHA0Ld$HHXI   Hl$PMHHt$HLl$HL4$HHIHIMIILLIHIIIHIHMILJ<    JHBHBJHHJHIBIIuLd$HL4$Ll$Ht$Hl$PI;}CHL    HN    IHIL+IHHIIIuHA_A\_[LI[IsWHpHICHB`HICHA`ICICICICICICISHyICHIKuHHڃH;HLHHL$PH+LHH+3HH4Cؑ  H;}. HD$8HHD$ (HD$ )HH;|LHL$PH蕑  L\$pI[Is I_HAhE3LI   HQxL    3H~!IfD   f.zuHHH;|IMI|̰2H(H;thH\$0HZHt$8H|$ HyH[HsHOH;t1H>HOHCHGHKHHHH HHGH;uHt$8H\$0H|$ H(@WH@  HD$(H$P  HHD$     HL$@^   HL$0m LD$PMcHHL$PIHPHL$PO HHL$@H$   H$   ~ HH$P  H@  _@SH HHHSH
 H3H
HJHH 3HC HC(HC0H C8HH HCHH [@SH0HD$     JQ  HH0[@SH HHHSH
a H3H
HJHH 3HC HC(HC0HF C8HH HCHH [@SH0HD$     
P  HH0[H(((T
ߤ f/
 v6f/
 rWf/   v H(I \ H( f/v(H((Y((Y%$ (Y
 (Y> X% Y X
n X YX YX% YX
 YYY\\\%F X6 YY-: ^X(H(H;. H
, 73L(DIDAf     Ap f/sffA;uDA f/sffA;uDAHkAHAR HHXWH   )pA)xD)@D)HD)PD(EYD)XD)`D(DY A(GG D
$ (E(A(Y=Q A(»   EY(D(T
 f/
    A(AYF (A(Y% YXf;vM-  (AYfA\DXA(fn(D(YA^^XYf;r(|$pL$   I[(A(sE(CE(KE(SE([E(cI_H9 H
( QHHXWH   )pA)xfD)@(D)H(D)PD(D fD)X   D(D)`DYD((DYYE^Y  DW
p E Y=K L$   L$   3D(DY(DY 觮((T
 f/
R    Y WA^(Xf;v.ffnYA(EY\AYXf;rDYq A(
E Y8 L$   I[(|$pE(CE(KE(SE([E(cYA(sI_HA8 H
' H\$WH`)t$PA)|$@f(D)D$0D(Yfǻ   D)L$ (D
J EYW= (A\AYY >D YWA(YQ (Xf;v<D  (YfAYA(\fn^(YXf;rH\$p((t$P(|$@D(D$0D(L$ H`_HHxD)HLHD(D)PY7 L@D)XD(諬(D(T f/U    DY )|$`D)D$PD2 A(A\EX(A( C E\Wf.EYD(DYj zt1AYAYY=\ A^(B AYY
 D\(|$`A(D(D$PD(L$@D(T$0D(\$ HxH06 H
% H   eH%X   
~k	 )t$pWA   D)T$0D(HB9Ĉ	   fA/vDW fD.zu (t$pD(T$0HĈ    fA/rfA(L$   AYHw	 H
	 $   w  %	 (Y% A((	 AX\\
	 Y  D)\$ D fE/rzx L$   A(Hy	 AYH
z	 Y
I \$   /v  %	 (Y% A(ȅ	 AX\\
	 Y(  % E^)|$`A(D)D$PAYD)L$@f/   D((DY
}	 Y}	 DX
}	 Xd	 DYYDX
}	 XB	 DYYDX
}	 X 	 DYYDX
~}	 X	 DYYDX
\}	 X܂	 D^   C}	 (^D((DYfDX0}	 DYDXfDYDX!}	 DYDXfDYDXj	 YfXg	 YXfYX\	 YXfYXD^f/   D((DYт	 Y~	 DX	 X~	 DYYDX	 X~	 DYYDXt	 X~	 DYYDXR	 Xr~	 DYYDX0	 XP~	 D^   	 ^D((DYfDX	 DYDXfDYDX	 DYDXfDYDX}	 YfX}	 YXfYX}	 YXfYXD^A(i> (A(9> (A(W> - (XEY\^AYD(D$PAYD(L$@\(|$`D(\$ (t$pD(T$0Y(HĈ   H
7	 . =+	 g(^ H
	 (
З a~	 ( s~	  
T~	 (
 e~	 ( 
r	 (
H s	 (ʚ 
s	 (
< )u	 ( )
u	 (
` )u	 ( )
u	 (
4 )t	 (V )
t	 (
 )t	 ( )
t	 (
 y	 (N 
y	 (
  y	 ( 
#	 (
T %	 (ƙ 
'	 (
 	 ( 
	 (
l 	 ( 
{	 (
 {	  
{	 
 	  
	 
R "	  
*	 
j R	 5q	 
	  rH   eH%X   
d	 D)D$`D)L$PD(D)\$0EWHA   D)d$ D%g B9	   fE.E(DT zu	A(  ٌ fA/)|$prnA(L$   AYHv	 H
nt	 $   q  %	 (Y% A(A(X	 \AY\
Ă	 YY9  D)T$@D، fE/rnA(L$   AYH{	 H
b|	 $   do  %\	 (Y%9 A(A(X	 \AY\
 	 YY   E^)$   A(AY$   A(C: (A(: (L$   Hs	 H
w	 p  (L$   (AYH/z	 XH
|p	 Yo  \YXA(9 Yފ ($   D^AYD(T$@fE/vY= ((|$pD(D$`D(L$PD(\$0D(d$ HĘ   H
 	  =	 ( H
	 (
	 zr	 ( r	 d 
mr	 (
 ~r	 ( 
t	 (
 t	 (3 
t	 (
 )z	 (ג )
z	 (
y )z	 (+ )
z	 (
m )y	 (o )
y	 (
 )y	 (C )
y	 (
 n	 ( 
 o	 (
	 o	 (˕ 
|x	 (
} ~x	 (o 
x	 (
! u	 (# 
u	 (
 u	 (w 
`q	 (
i bq	 B 
cq	 
 [|	 # 
	 
ˊ C	 + 
c	 
 C	 D2s	 D1n	 D%w	 D/u	 D%p	 
	 5 D$H   eH%X   
`	 )|$`= A   HD)T$0D(B9	   WfA/	  fD.z(	   fA/)t$pD)D$P  A(E(^{	 EY6 (A(fA/X(Y^%̇    A(A(Yl	 Yy	 Xl	 Xy	 AYAYXl	 Xy	 AYAYXl	 Xy	 AYAYXpl	 Xpy	 AYAYXNl	 XNy	 ^   6l	 A^((YfX(l	 YXfYXl	 YXfYXx	 YfXx	 YXfYXx	 YXfYX^}	 A(YЄ \4z	 AX\?{	 YYX   fA/   A(AY$   A(^%}	 4 (A((XL$   Hnt	 H
m	 Y^- ~j  %~	 (Y%# A(|	 AX\\
|	 YYX  D)\$ D> fE/   A(AY$   A(^]z	 4 (A(T(XL$   H^p	 H
w	 Y^-+ h  %{	 (Y%k A(y	 AX\\
z	 YYX  E^D)L$@A(AYf/   D((DY
t	 Yp	 DX
t	 Xp	 DYYDX
t	 Xp	 DYYDX
zt	 Xjp	 DYYDX
Xt	 XHp	 DYYDX
6t	 X&p	 D^   t	 (^D((DYfDX
t	 DYDXfDYDXs	 DYDXfDYDXo	 YfXo	 YXfYXo	 YXfYXD^f/   D((DY;q	 Y#m	 DX"q	 X
m	 DYYDX q	 Xl	 DYYDXp	 Xl	 DYYDXp	 Xl	 DYYDXp	 Xl	 D^   p	 ^D((DYfDXqp	 DYDXfDYDXbp	 DYDXfDYDXl	 YfXl	 YXfYXl	 YXfYXD^A(0 (A(0 (A(0 # (XEY^\DYAYD(L$@DXAYD(\$ D(D$P((t$p(|$`D(T$0HĈ   H
x	  =x	 R(. (
׍ f	 () f	 ({ s	 ( 
vf	 (
o h	 (a 
Rs	 (
 h	  
Us	 (
 h	 ( 
h	 (
 zo	 (ˊ 
\o	 (
 )Vs	 (O 
`o	 (
q )Zs	 ( )
<s	 (
E )k	 ( )
@s	 (
 )k	 (K )
k	 (
݅ ^p	 ( )
k	 (
 bp	 ( 
Dp	 (
 .l	 ( 
l	 (
i m	 (ۊ 
l	 (
 m	 (? 
m	 (
 i	 " 
ki	 (
 s	 T 
mi	 
 t	 } 
v	 
u ]t	 } 
mv	 
 v	 =m	 
}w	 
 H
v	 .} 
v	 6t	  L$   H H
֤ sH H
¤ D$HxeH%X   
[V	 )t$`W)|$P(A   HD)T$ D~ B9t	 >  f/~  ~ f/D)D$@   (Y$   (^)u	 , (((XL$   H3e	 H
h	 Y^-~ b  %+q	 D(Y%W| (t	 X\\
q	 Y^DYDX^  D)L$0D
n~ fD/   (Y$   (^p	 9, ((X(XL$   H2d	 H
;c	 Y^-_} j_  %:r	 D(Y%{ (Sp	 X\\
+q	 Y^DYDX   D^A(AY$   (+ ((~+ (L$   Hpi	 H
o	 la  D(L$   (EYH)j	 \H
g	 DY<a  XYD\(E+ YG| D^EYD(L$0(t$`A(D(D$@(|$PD(T$ HxH
r	 @ =r	 ( H
}r	 (
2 f	 ( f	 %~ f	 (Ƅ 
of	 (
 b	 ( 
b	 (
܂ )a	 (N 
b	 (
 )a	 } )
za	 (
3 a	 (T )
}a	 (
 )?b	 ( )
!b	 (
J )Cb	 ( )
%b	 (
 'f	 ( 
	f	 (
" h	 ( 

f	 (
6 h	 ( 
yh	 (
ڂ m	 (l 
m	 (
 _g	 ( 
m	 (
 cg	 {z 
Dg	 
z dq	 { 
m	 
x m	 { 
m	 
| 4o	 D{a	 D:a	 5Be	 Dg	 5m	 Df	 
n	   xL$   H H
ب nHSH   AH@H@A LL$0HD$ AHD$0A@ L$@AH0LD$hD$PHJ@B HJ0@B@HJP@B`HQ0H	@H)  HH   [A(f.-x LIHH
A`zuWf.z;  E3I   IQHHL    ((YYYYX\PY((YYYYX\HYPY((YYYYX\HYPY((YYYYX\HH YH H*M;}@H+M+((YYYYX\HIuH(((Yv Y
v (\f/y vYXw H(((H(8  @SUVWH  HD$8H H3H$  IIHHM;H@  HL$@YH HL$PWHH HH9 WHH
 WHH
 WHHd
 WH$  HL$@]H$  H$  HC$  HǄ$X     3H$P  $@  8uDI     IB8uH$@  HǄ$x     H$p  Ƅ$`   A   H
 H$`  SHGHD$0H$@  HD$ L$`  LD$0HH4H$  H3  Hĸ  _^][HUATAUAVAWHHpHEHXHpHxMLLWEE3LMIPIHt I;vH
  HMLM3I9vj  3HELE     IHH;   L;   I+HI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMALMHELEIH   H	tI;ugIH+HHsWI+HIH+H   HPM+IIHIH+IE3I;LCL;ICHMLMHELEHtHHLMLEHEHHEHHcI;N}!H
] ? H
O 1 WEHE    LMLEIIjHMH   HEH+HH?H;v/ H    H=   r<t HAH;r H+Hs H'v H  WEHE    HMHthHEH+HI;v H    H=   r<t HAH;r H+Hsr H've H4  IL\$pI[0Is8I{@IA_A^A]A\]H\$Ht$WH`L3HI IpHD$ HAH;t'H;tH	 Ht
HYHHHwHHD$0HD$@HD$ HD$HHD$pHD$PHL$0LGIH|$XHH+HHHH~%     HD$ ()HH;}HL$0HL$@YGH\$xHH$   H`_H\$LHLLH;t"IM;tAIIIAM;uIM;t HH;tHHHH;uIHI;t%D  HH;tHHHH;uM+IJH\$H\$Ht$H|$AVH HIH+IHLHIH+HHHHm6  LCH;s%@ CHCf/wf/wHH;rL;s$fD  A f/wf/w	IL;rMLL;X  HI+HHH    IIfff     A	f/w'f/  III;tA@AHAIHQf/w&f/j  IIH;tA@AH	f/w&f/?  IIH;tA@AHIHQf/w&f/  IIH;tA@AHI HGH L;L;s;A	f/w#f/w&III;tA@AHAIL;rL;vCIBfD  f/wf/w"HH;t IHI;rL;u]L;   M;tI HA IHIHIHHIkIbIYIL;u1HL;tHAII@IHA AIIIAHt$8IH|$@IH\$0MFH A^H;   Ht$ WH0Hl$HHHiHH;   H\$@LELt$PA   L+)t$ f     ApIXHf/vMHH 7/A f/v f      IA@If/w0HCLH;u(t$ Lt$PH\$@Hl$HHt$XH0_HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt3a H衼HD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHM>  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HM7  L;}:@      HMHEBEffYfBXB)IL;|LHHM6  HI;
HL$  L$   I[0Is8I{@IA_A^A]A\]LAVH   ICI[IkIsI{ A)sIHLHz(H    IH{    r AY1HWHIIFWD$hICIKISMCISIKH$   HHD$xH$   H$   H$   HHPHE(HHHuHSMLHD$hHD$Pt$HIFHD$@LT$8HCHD$0L\$(HGHD$ LLG[C  HL$hg HL$p\ L$   I[IkIs I{(A(sIA^H\$Ht$WH IHHH;tbHl$03H;tDHHtLCL+IH+HkHkHHHGHCHGHCH/HoHoHHH;uHl$0Ht$@HH\$8H _@WH0HD$ H\$@Hl$HHt$PIHHH;   3H;tgHCHr3HHH=   r unHAH;s^H+HrNH'wAH  HC   HkH{rHH  HHCH H H;t    HH\$@Hl$HHt$PH0_H\$MLHI;   IH+H|SHHLQII+HL HHIMfD  IHBHR IHBIHBIHBHuM;}!HM+LCHJI HHRIuH\$HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCf\BCLBDf\BLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BB\CBLB\LCLBDB\DCDBLB\LCLIL;|M;},ICHHHPILBB\CIM;|HHMLL+LI;A  I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;sFIIHHH+H+     BfYBBDfYBDIL;|Ht$H\$H<$M;   II+H|eICHHIHI@@ BYBBDYBDBDYBDBLYBLIL;|M;}&ICHHIHBYBIM;|HI;}4HALHHHL+L+H AH@fQ@IuHLLII+M;  H   HAH\$Hl$Ht$ IpHXLP(HH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHH(HPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHH(HPILBBXCIM;|HI;   VWH(LIIHHH\$@Hl$HIi8Ld$PMaLt$XL0L|$ I+My(f     AI AYHX+H;|L|$ Lt$XLd$PHl$HH\$@H(_^HMLL+LI;<  (k I   HAH	H\$Ht$HXI@H<$H9IHH4HHHH;wH;s=IIHHH+H+ȐBWBBDWBDIL;|Ht$H\$H<$M;   II+H|cICHHIHI@fD  BWBBLWBLBDWBDBLWBLIL;|M;}%ICHHIHBWBIM;|H@USVWATAUAVAWH$hH  HD$@H܉ H3H   MIHLL   H  HD$8E3D|$0H, HD$PHMݼ D$0   E3E3HT$XHL$P HD$PHcHH HDPHD$PHcHDxDDLAWHL$XHHL$PwDHHY 8@HIVk HHY @HU`HL$P.HBD$0HU`H}xHCU`HEX   L}PD}@D8:tI    IB<: uMHM@*HD$8HD$ MLD$0HU@IK|@USVWATAUAVAWH$hH  HD$@HL H3H   MMHLL   H  HD$83ۉ\$0H HD$PHMO D$0   E3E3HT$XHL$P HD$PHcHH HDPHD$PHcHDxDDLSHL$XXHHL$PBHH >HIV޹ HH >HU`HL$PHU`H}xHCU`HEX   H]P]@8t
HHÀ< uLHM@I$JHT$0HD$8HD$ MLD$0HU@IzLD$HL$UWAVH LT$`LIE3HIH,HHl$XH  H\$HHt$   Ld$Ll$L<$D  MHHNMHFIIHVE3MIHIIIIH   LLM+ILL$@I^Hl$@JIMPMLILM+M+MN    LL$h OL"MR LKH   MJLxOL*LKML*LKOLLKMJLKOL*LKML*LKOLLKMJLKOL*LKML*LKOL"LKMJLKOL*LKML*LKI\Hl$XL|$hL;}OI+MVI+OI+OHI+MNMIMBMR MAMBND	MBND
MBHuLD$PHHFH;XLT$`L<$Ll$Ld$Ht$H\$HI;   fIHE3I HHH|`LWIIVIJL@N    MfD  IHM@ HJHR IHHJIHHJIHHJIuLD$PLT$`L;}JIKIL;|HI;dH A^_]HUH   AHJHJ0HAH@B PHAH0@A@ fsfI~H@MuWHĀ   ]HD$ LT$@L$   Lt$LH   AAYL;   I   H$   KIH$   MXH$   IIIHIJIIHHHIJ    YAYIXYXBYIHH XXIuH$   H$   H$   I;})J    LKAHYHXI;|U L$   HĀ   ]@SH H
  HC HCPH [HL$SH0HD$ HD$P    EtH HA@H HAPD$P   J   H HH HCHC@HcHH HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH> HHQ3HHBHK HM HH{3HHDH^H\$HHͳ HHOHKHtHPHGHCHGHCG C H* HHȤ HHH\$PHt$XH0_@SH HHHSH
 H3H
HJHHC H HHH [H\$WH H\  H HGPt
X   Hg  HH\$0H _@WH0HD$ H\$@HHh HHβ HAHI HtHP tHC     Hؼ HHK @t
@   H  HH\$@H0_H\$Hl$Ht$H|$ AVHA@LHyHP LRIHH+HLIHHHHL    M  HI0(II fYfYI   IA0(HHfYI   fYOL;~:IY0fD  (fYfYfX(DfYDfYDHfXI;|fXM;~IA0H(IA fYfY:fX(fXM;   II+H   MY0HOIY JILI+о   HHHIH+H+HM     H)AYALYLJ1YAYIXAYH1XYAYXYIH XHuM;}&IA0II BBYBYIXM;|(   HA0HI Y   YL;   I   MY IZLH   HWHIH+H+HLH   @ H*B BYBL BYLJ2YBYJXBBY H2XBYBY XYJH XHuI;}#IA0IQ YYHXI;|(H\$Hl$Ht$ H|$(A^H\$H|$HA8HP@LBIHH+HLIHHHHH<    MH  LY(HI(fAYI~hA(K   fYIH;~9ML+f     (HfAYHfXB(DfY@fXH;|fXL;~H(fBYfX(fXM;   II+H|vIICI+JHLHM+HM     ATYPAY ALXYHXADY@H XX(HuM;}!I+KM+YHXIu(H\$H|$LQ(A   LIAAYM;   I~qIIPI+HHIBL   @ f     LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$@UVWH   HD$8H$   Huz H3H$   IHH3IIHH+HH   I      fD  D$0HD$0I#I;t
HH;r   HD$X   HD$P    D$@ A   H HL$@mHD$x   HD$p    D$` A   H HL$`>HD$@HD$(HD$`HD$ LLHHH$   H3  H$   HĐ   _^]HLH UVATAVAWHH   MxE3MMHM  HXIHxLhL,    M$I
ID$AJ0H+AD$`   EhMHt$@HP  LMH\$PIB(CYH+LBYHuH]HH   HEHEhHEHD$@HD$ HD$`HD$(H@  HD$0HEHD$8T$p]HU@uHHH؃H;LLHI+yHHHL$ 3I<@r  L;}W@ f     HEEHL$@fBHEfYBD$pffYfXfBXB)IL;|LHL$ H  LH  IHIM;L$  H$  H$0  H   A_A^A\^]@UHl$H  ID$hA L$xI0MJEB MJ0EB@UMJPfsEB`fH~E MHuWH  ]HD$hHL$ HD$(HEHD$8HEHD$@HE HD$PHD$`HD$XRM  H  ]@SH0HD$ HHO HH HAHI HtHP tHC     H HHKH0[H%$ LH   ICAC    HQH ICH ICAC   IK;H| HD$(H HD$@HD$hHcHH HDhHD$hHcHDd    H3 HL$(  @SH0HD$ HٹX   <  HD$@HSH#  HHtH@@HcHHB@HH0[@SH0HD$ HH HH HAHA@HcPH2 HD
@HA@HcPDBDD
<H HHk HAHI HtHP tHC     Hu HHKH0[H% @SH0HD$ HH HH HAHI HtHP tHC     H HHKH0[H%4 DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   OH HHOH! HHG@HcPHO HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH× HA@H8 HAPD$P   H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_@WH0HD$ H\$@HHx HH HAHI HtHP tHC     H( HHKS @t
@   H8  HH\$@H0_DD$HL$WH0HD$ H\$HHt$XHH3t$PH HA@H HAPD$P   ?H HHOH HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_HL$UATAUAVAWH   Hl$@HEXH   H   H   )upHVq H3HE`LHE3L1HB0HXHyH}L7LwIHt1IHHHtHt3 HGHH_HHMg0WEHHM8HE8HEHEHE HE HE(H}0LGIHH+HHHIH~*@ ff     f)HH;}EHM8HMAwI_ HSHH;v
HHumH    H=   w9H   HHH;w
HHH H+HL$@HH$L<    Iޣ HHuMtd
HCH; LDH    H=   LHMHHEP   IT$I$HEHU t$0HD$(   LD$ LMHLEIL$K  t
Ik HHM`H3  H   H   H   (upH   A_A^A]A\]HHXUVWATAVHH  HMIMHE   )pWEA MI0EA@)xLxHAL9EA`HPEIHuHu H|$pHT$xMIPMHu(   (D$p(MEH(EMX(MEh(EMx(M   (E   (M   (E   M       Hu( HE@H|$(HL$ HD$@Ht$8q  (
A f/A?L$H     H   HHD$XHD$HHD$ HD$`HD$(H@  t$`HL$HHsH\$8HHD$0A>I$    uHHكH;HLHHL$ H+LHH+3HH<CH;}D$`HD$Hf)HH;|LHL$ Hs	  (YX f/ArWM AH   (HHD$XHD$HHD$ HEHD$(H@  H}Hu(HL$HH\$8HD$0A\E0HsHuHHكH;HLHHL$ H+LHH+3HH<C  H;}.    HEE0HL$Hff^)HH;|LHL$ Hɰ  A\A^A$L$  I[@A(sA({IA^A\_^]@SH HHHSH
a H3H
HJHH 3HC HC(HC0H C8HH- HCHH [@SH0HD$       HH0[HLH H   )p()x(D)@D)HD
A D)PD(D)XD(DYD)`E(D)l$ D((DYYE^Y6C  Y=i@ L$   L$   3D(DY(DY? X((T
8K f/
pB    Y? H[    @ WA^(Y53@ X    AYHDXA\EYAY(YXHuDYqB A(
 Y8? L$   A({E(CE(KE(SE([E(cD(l$ YA(sIH@ H
 ̚HHXHpWH   )pH5)x3D)@WD)HD(D)PD(EY{
D)XD(D8? DYDYA ff     A(Y3 AX(AY Y3 H^XHu(t$pL$   I[IsE(CE(KE([AYE(S((|$`I_@SH HHHSH
Q H3H
HJHH 3HC HC(HC0HF C8HHm HCHH [%@ (\LIp     I   ff     AHiN  IHHH+HHHHiH+A	AALi  IIIH+HHHHiL+EAD;sA+	A+ȁWH*^YXf/qH\$H|$LA      Hp     AH   AEAAAHiN  HHHH+HHHHiH+AACLi  HIIH+HHHHiL+ECD;sA+	A+ȁAEtAI;wH\$A#H|$HHXHhHpWAVAWH   )pH-D)@HD: Ip     D)HI   D
: D)PDI< D)XD)d$PEWD)l$@E(D-O= D)t$0D5F D)|$ D=a: )xD     HsW4   H*AYfff        HCWHH*X(AYH5rԺ   HWH*FLcB@ XY5: Y@ f/  u
EXOHiN  IHHH+HHHHiH+ȉGLi  IIIH+HHHHiL+DGD;sA+	A+ȁWH*AYfD/zP @ BP B@ (\YX(\\Y\fD/v\(YX\fD/w(AWj f/F($   L$   I[ AXIk(Is0E(CE(KE(S(A(sE([E(cE(kD(t$0D(|$ IA_A^_HIH+MHLH(a  HH$HHHHHH    
f/v	
	
f/v H
H
f/v	
	A	ML+A f/v
AAB
Af/v!IJ
A	A f/v
AAMML+L+H$AAf/v
A AA
A f/v I IAAf/v
A AA	
f/v
A
AAf/vbII A	
f/vLA
H
f/v	Af/vHI 
f/v	HLI;   IH+H|]HLHAIHA^ ALA^ADAL^ ALAD^ALHH;|I;} IHIB^ HI;|@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^BAAIBLA^JAIIBHBDA^BAAIBHBDA^BAAIuLt$ H|$Ht$I;}&HHKL HA^AAHI;|[@SMHI;U  IH+H  HLZLIHt$   H|$L ILt$ I+IM+HOML+IIIJIA KAAHAYA8AYIXAKIA AAHAYA8TAYQXASAAHAYA8IA HBAYIXAIA AAHHAYA8BAYIXAKI IRLt$ H|$Ht$I;}4HHKL HA AHYA8YIXAHI;|[LI;   IH+H   HLIIHLfD  IAAAYI\AIAADLAYI\ADIAADLAYI\ADADIALAYI\ADHH;nI;}0IIKLAHAYI\AHI;|LI;   IH+H   HLIIHLfD  IAAYAAXAIADAYAAXDADIADAYAAXDADIADAYAAXDADHH;|I;},IIKLHAYAAXAHI;|@WLHI;R  IH\$H+H   HMKLQHt$   Lt$ A   HIZH+H+L|$(L+INL+II+HHHMfIB0KAYB BXDAAIB0LAYJ BXA	IB0HBAYB BXDAAIJ0IB	AYB BXDAAI HwL|$(Lt$ Ht$M;}AHLOLIYI+KIM+IA0IAYA XHIuH\$_@UVAUHl$Hp  HqLH }Hp  A]^]r  H$  H   H$h  HHL$`  L$X  HL$P  HH   HHH      Hǅ      HM)$@  L9L;LO3H_  5U3 MIH@      MMI;ME IHLLl$8LHT$(IAHT$0HHH\$@L+HML+HL$xHMIH\$HHD$ HILL$PHLuHULmH]ILMHEHILt$`HLt$hHL$ Ll$pLMIHD$X  H   M~tD$ HUL$0HMED$@ML$PEM/  D$XL   L$hHUE HM D$xMME    M0M*  IIH;HL$P  L$X  L$`  H$h  H$  ($@  Hp  A]^]H@SH H  H# HCPH [HL$SH0HD$ HD$P    EtHn} HA@H HAPD$P   J   H˦ HHu HCHC@HcHHx HD@HC@HcHD<    HH0[HL$WH0HD$ H\$PHt$XHHH HHQ3HHBHK̋ Hu HH{3HHDH^H\$HH HHOHKHtHPHGHCHGHCG C H HH HHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3QH~ H|$HHS H|HS8HOHH\$PHt$XH0_HL$WH0HD$ H\$PHt$XHH3HA   HAHyrHH  IE3H~ H|$HHS H{HS8HOmHH\$PHt$XH0_H\$WH H,  H HGPt
X   Hg  HH\$0H _H\$HA LL@IHH+HLIHHHHH    M&  IRfo6 TI~cJTH~>HCHLR HLZ0    AI TfXAI TfXHufXL;~HTfX(fXM;   %H6 II+H|YIHBI+JHHHMP@TXTTX@TH XX(HuM;}JM+HTXIu(H\$MJ   5 ATL;~zI~SIHHIAHH   H@TXT(XT@H TXXHuI;}IL+HTXIuH\$(LH   ICAC    HQHx ICH(} ICAC   IKH HD$(HPp HD$@HD$hHcHHs HDhHD$hHcHDd    H> HL$(  @SH0HD$ HٹX   l  HD$@HSH  HHtH@@HcHHB@HH0[@SH0HD$ HHO HHo HAHA@HcPHBs HD
@HA@HcPDBDD
<Hz HH HAHI HtHP tHC     H HHKH0[H%ʆ H\$Hl$VHA3g3 HH*Hj HA T¹   BHXH;
  H   LVDEL^H|$H{@      IHATf/v
(H
HjMHIIATf/v
(L
HjIIATf/v
(LHjMHIIATf/v
(L
HjHIH;gH|$BH;}:LFLNJIHATf/v
(H
HjHH;|JH\$Hl$ ^DD$HL$WH0HD$ H\$HHt$XHH3t$PHu HA@H(z HAPD$P   oHm HHOHل HHG@HcPH HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_DD$HL$WH0HD$ H\$HHt$XHH3t$PHt HA@Hhy HAPD$P   HO HHOHl HHG@HcPH?p HD:@HG@HcPDBDD:<HSHHDHH\$HHt$XH0_LD$HT$HL$UVWATAUAVAWH0  Hl$`Hǅ   H(  )   HO H3H   LM@HLH`  HV HUHFHE(LU(H  I;LMIHE8HFHE HM L  H;IMHHEM2LLLIM;vHHMHHumJ    H   w2HCHHH;wHHH H+HL$`HHHM*H؂ HHEHuHtZH3H9HDHEXH   L   J    H=      M;vLnMu_J    H   w.HCHHH;wHHH H+Ll$`IIH+ LHuHtHM3H9VIDHUPJ    H=   EHE8L   LEHuI;tM;u	H;E tE  E3M  X  @ ff     IHU(H  LU(L;IMHI+HU E3Mq  L0  LUhD  MLE0H   L]0M;IML8M+IIILE@IHE`HT$ MLE`HGD3H   HP  H   HHuHH  HMHH;HMH8H+}  tMu8IH@  HHH8  HHEpHMxH|$ MLEpIEHP  IHH  HH   HD$HHD$@t$8H|$0L|$(HE HD$ MLEH   HHH  H;Hu,Le0L   M;HMHU HuL0  LELu(L  M;HMHuLEHE8;HUP} t
H     t
HMX H   H3  H(  (   H   A_A^A]A\_^]@UVWAVAWHl$H  HD$XH$  H\K H3HExMHKY HHEHY HHEHE   HE    E 8 uE3IIB<  uHHMHE0   HE(    E ; uE3I IB< uHHMJHEP   HEH    E8 A   HPY HM83@      H}H;   H+H   HHuH}HCuHH   LǺ%   H} HH   :
  uH:
  uH:
 u3tH+HHHsHEH}HCEH+Ht+HD$    L
l A   HHMBH)IE3HUHM8A   H HM8oIHMXsLuXH}pLCuX3IMC8>u@ H}(H;   H+H   HHuH}0HCuHH   LǺ%   H| HH    := uC:2 uC:' u3tH+HHHsHEH}0HCEH+HtAA> u3HfD  HA< uHD$ MA   HHMIIE3HUHM8HE8H}PHCE8H
 HL$03HL$8HL$@HD$HD$PHT$8HL$H{ Hb HD$0HT$0HM%HHL$`wH HL$`  @SH0HD$     HH0[@SH0HD$     "  HH0[Ac f/   ((YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^A f/   ((YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A f/rw((YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^((YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^@UAVAWH   Hl$@H]`HuhH}p)u0HC H3HE HMHBHA1HH;  H
HuLH<    H      H   HHH;w
HHH H+HL$@HHHFLM HSLEE3t$0L96HM LDHD$(   HKHH=   HE   HHE@IHD$ HU  @t	Iv HM H3.  H]`HuhH}p(u0He@A_A^]Hv HHXHO/)HLH UATAUAVAWHhH   HEHXHpHxLI L WD$ B EHR(HHEHZHt31v HqhHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HHHE3AH~2@      HEEffYA)HH;}LELHMe  MwIM   AI_HHIHHUH]L}LmHuH]'EHD$ HEHUH]HEHEHEHEHEwHEHEHELuHHڃH;LLHI+yHHI<@3HML;}=@      HMB(HEBEffYf\B)IL;|LHHMHI;HL$ t L$   I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH   HEHXHpHxLI L(WD$ HBL LEHRHHEHZHt3s H0fHD$ H]H]LD$ LEHEHEHEHEHEwHEHD$ HEHHH+HLM3M~%HEHM(f\A)HI;}LELIHMkM|$E3M   f     CD I|$HII$HHUH}LeHE    LuH}'EHD$ HEHUH}HEHEHEHEHEwHEHEHEHuHHڃH;HLHH+yHHH4CL3HMb  H;}+D  HMHEEffY)HH;|LHHMa  IM;HL$ Lr L$   I[0Is8I{@IA_A^A]A\]HHX UVWATAUAVAWHH   )p3)xLD)@D)HD)xD)hD)XHAHp  H  D% HxEW@      IL$LkM4$HfoX HE}LyH|$`ILd$pLLl$xIHD$XIFH]I4HMHCHuH]LeH]HD$ H|$(H\$0Ld$8Ll$@HD$H    HL$PDEDMDUH   DUhA      DMxD   YI;   H~uHILHIIELLHIIMHL   fD  BBYYXYXYIXXHuL;}.IH    HHHI+	HYXHu\fD/  ( C(H~eH  L$ Lh  T$0LD$XD$@HUM(HM(L$PMXDh  U8EHDUDM DE}   H   HEHL$XH\$`HEHEHD$ HEHD$(H`  HD$0HD$XHD$8LuHMuHHكH;LLHI+yHHHL$ 3M@M;}$HEEfB(f^B)IM;|LHL$ IHIL;p  HL$   I[XA(sA({E(CE(KE(SE([E(cIA_A^A]A\_^]HHHX UVWATAUAVAWHH  )p3)xLD)@D)HD)xD)hD)XD)HD)8D)(HAH  H  D=* HxEWfM4$LkIL$0A$HH}XAL$LyL   HEhAD$ MxI4IAL$0   AL$IH      HEPA$H   MH   IFAL$0HEHD$PAD$ HuD(] D(mEH]A$H]0D(UD(eM(AL$HU8D(E0D(M LL$xAL$0D$hHE@   }@MHECHEH|$XH\$`LmHUAD$ EH  D  A     D  D  D  D  D  YI;   HU(H~vHRLHIIELLHIIMHL       BBYYXYXYIXXHuL;}.IL    HHHI+	IYXHu\fD/  (膼 C(H   Hr  (L$PL  (D$pLEP(T$`H   )0  H0  (M)P  (E)`  (M)p  E)    D  )@  D)   D)   D)   D)   D)   D)     |  H   H   HMPH]XHEHEHD$0HD$ HD$8H   HD$@HEPHD$HLt$ HMuHHكH;LLHI+yHHHL$03M@M;}'fHED$ fB(f^B)IM;|LHL$0IHIݺ    L;  HL$  I[XA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HMLI;   IH+H|zHAL HIIL@ IAIIDAALIDIDALADIDIDADALIDALHH;|I;}(ICHIL HAIHI;|HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfXBCLBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBXCBLBXLCLBDBXDCDBLBXLCLIL;|M;},ICHHHPILBBXCIM;|HHLMILI+M;  H   LAHH\$Hl$Ht$ IrHIBH<$IxM@J,H4IKH;wH;sxIJHJH;wH;sbHIHHH+H+fD  CBfYBfXBCDBLfYBDfXBLIL;|Ht$ Hl$H\$H<$M;   II+H   IKILAHHAIJf     BCYBXBCLBYLBXLBLBDCYDBXDBDBLCYLBXLBLIL;|M;}2IIKHHALABCYBXBIM;|HLIKUVWAVAWH   HD$ I[LHIK3H9HyHyB D$`HJ(HICHAICLqHqMuHtM$HtHHHL;tHIHt3ud HVHLsHsHHL$(HCHD$0HT$(HT$8HT$XHT$@H$   HT$HH\$PLCLIHH+HHHH~-D  HD$pD$`ffY)HH;}HL$(HL$8NS  IG8HCHHC HCHC(HKHHC0HAHC8IG(HHHK@HH$   HĀ   A_A^_^]@UATAUAVAWH  Hl$`Hǅ   Hp  Hx  H  )0  H$/ H3H(  HHA0   LyHrHuXWE`L}pL}xH   L}LEHUpH   L   IHMpHH   IHExH   HC0HE@HHE8HG0HE(HHE0H   L}HMHEHUI;HMH8H}H~HHH<HH}IHMII;vIHU`HtLmH4    H   w.HFHHH;wIHHj H+Ll$`II*Ha LHuHtMHU`IHuX3HIDH   H  H  H    H=     M;vHUhHtL_J    H   w.HCHHH;wIHH豫 H+Ld$`II Ha LHuHtHUhE3HMDL   J    H=   E 3H  LE(L   3H] H   HIH   HIHH   LE0LEHHUPH   LMPH;IML0L+L   L|$ ML   IR%3HuHM'  HE(H   HE@H   H   H   HH   HEH   L;HMHH+HE HHM0HH   H\$ ML   I"LEHHEI;LMHE8HH   HD$HHD$@t$8I HD$0Lt$(H\$ MMH   %'HIIH   Hu8H   HD$8Lt$0H\$(HL$ MLE@HHH}HI;H}H] HMPLEL   LEH   H] HuXH;H   [L   E t
I^    tH   ^ HM`^ HMh^ H(  H3  Hp  Hx  H  (0  H@  A_A^A]A\]LWH   ICI[IsA)sH1I0AKHyHZHBWD$@H\$PICI{ICMCHT$PIKwLD$`IHD$PHD$hLD$XLD$pHF0HL$@HL$0HD$(HHD$ L$   fI~HH&4HL$@] HL$HL$   I[Is A(sI_H%}] H\$H|$HA8LI L@HIHH+HLIHHHHH<    MU  LYAAfYI~rAQ   ACfYH;~;II+D  AIAHfY@fXLfYfXH;|fXL;~HBBfYfX(fXM;   II+H|xIICI+JHIHI+HM@ ff     TYPY LXYHXDY@H XX(HuM;}"M+KM+BYHXIu(H\$H|$LQA   AAYM;   I~hIIPI+HHIBL   @ LYHY X(LYHXDY@H XXHuM;}"M+KM+AYHXIuH\$(H|$H\$Ht$H|$ LD$AVH`H3LHL HAIpH;t'H;tH	Z Ht
HMHHHwIvHM6HH;uHFH9G   HvHGHT$ H;t$H;tZ Ht
HLHHHwHHD$0HD$@HD$ HD$HH$   HD$PHL$0LGIH|$XHH+HHHH~#fD  HD$ ()HH;}HL$0HL$@IHH\$pHt$xH$   H`A^2  H\$Hl$H|$ AVH`L
HHIMIHD$0IAHD$8IiIyH;uH9{toHt"HtHHHH;   HCHt$pHHHH;t"H9Y Ht
HtKHH    Ht$pHkH{HHL$@HD$ HCHD$(HD$ HD$@HD$0HD$HLt$PH\$X  L\$`I[Ik I{(IA^FDD$HL$WH0HD$ H\$HHt$XHH3t$PHH HA@HHM HAPD$P   H/r HHOHq@ HHG@HcPHD HD:@HG@HcPDBDD:<HSHHDѢHH\$HHt$XH0_LD$SUVWATAUAVAWHH  IHL$xM	HIMHLtLLAuIHH؃H;LLLM+IMICHD$(I@HH3H+IL    IAH$  tHHHHڃH;HLHuIAuIIAM;ILE3Lt$EnHxRH;tMHxHI;tCfD  HHH3H+L;tIII|Iu
E3Lt$M;MLLt$E3E3L$  $  J,E   MA   IMDI+HA#HHM,Ll$M;
  H$  INH$  M.)$0  H    )$   LL+D)$  MD)$   LD)$   WD)$   D)$   D)$   HD$HHLd$XML+HD$hMD)$   L+D)$   LLL+LD$8HLt$PHHLL$@Ld$`Hl$pHHT$0fMOI(I7ILD$@EWIIEWD$  WD$MEWD(D(D(D(HHL$ HL$HIE3NHL$  IY  H3MbHILLHMH+H+L+L+IN,    L$  Ll$@ BTB(AYA(AYL)X(CYDCYTDX(AY)DX(DXAYBTDX(AYL)X(CYCYDXDX(AYADXB\(AYL)X(CYDCYTDXDX(AYADXX(CYDCY\I DXDXIL$  D$D$  M;}zH+NLLMH+L+L+L+IH+$  A)((AYCY1X(CY9CY!DXIDXDXHuD$D$  M;  L$  M6  I  I   M;  H+NILI+LHMHH+L+L+L+HfD  A()AfYfDXC1fYfDXC9fYfDXC!IfYfDXHu  IB(DC(LF(|)$   )$   L$  L;T$([  L$  IjLL$ H,L3MLL+I7L+HML+D(D(NLL$HLL+LL$ LL$(Ll$ M+IIIK4H$  Ht$H     A(t.A(.(B(l-A(\,A(,fYfYEDfDYfAXD((EA(D(>H fYfAYD(U fAYE(L/fAXD(AA(D/H fAXfAXD(fYfYD(fDXfDXfDXfDXIHD$  D$$  Ll$H$  I;  H+LILH+$  LHMHH+L+L+L+Hf     A()A(fYfDXC1fYfDXC9fYfDXC!IfYfDXHu   M;   H+NILI+LHMHH+L+L+L+HƐA()A(fYfDXC1fYfDXC(9fYfDXC!IfYfDXHu~M;}yH+NILI+LHMHH+L+L+L+H     A()A(fYfDXC(1fYfDXC(9fYfDXC(!IfYfDXHuA(fADXA(fADXA(fADXA(fAAXDXEXEXEXIL;  LM+IK  H+MKHNI+LHLMHH+L+L+L+HM,L$  Ll$AT)A)(AYA(CYL1X(CYD9CYT!DX(CY1DX(DXAYAT)DX(CYL1X(CY9CY!DXDX(AYADXA\)(CYL1X(CYD9CYT!DXDX(AYADXX(CYD9CY\!I DXDXHH$  H;}\H3LH+H+H+L+HH+A1((AYAYX(AY	CYDXIDXDXHuHl$0WHD$PLD$8HD$ IL$  YLD$8DYDYX| DY| HD$XDXD DD DXM HD$`DM DXT DT Hl$hHl$0Hl$pI(I;0Lt$Ld$xD($   D($   D($   D($   D($   D($   D($   D($  ($   ($0  M;S  H$  IHWH,    H$  H4IIIOW(E3HI|hHMBH+IIHHN    @ L
YI
YX(L
YIXD
YAH XXIuM;}(LJL+II+BYHXHuM;   Ai   u;M;}wLJIL+I+HHH@ B(fYHfXHuAM;}<LJIL+I+HHHf     B(HfYfXHu(fXXML;   HI+H|vHIKLHM+H+IIIO@      LYIYX(LYIXDYAH XXIuL;}'HJH+HI+
YHXHuYIXHM;MtE3ME3HH  A_A^A]A\_^][@SWAWH HIILH+I;   Hl$@Ht$HLt$XH   HAL    Ld$PNL`Lp HIH(HGILLL;wL;sTHOIIL;wL;s>HHHH3H+H+f     A AfYD HH;|Ld$PH;}3IGHp HhIL0 谙 YD AHH;|Ht$HHl$@Lt$XH A__[HLLII+M;  H   HAH\$Hl$Ht$ IpHXLPHH<$JH8I@HJ,H4H;wH;shIHIKH;wH;sRHIHHH+H+f     BCfYBCLBDfYBLIL;|Ht$ Hl$H\$H<$M;   II+H|pICHHHPILI@BBYCBLBYLCLBDBYDCDBLBYLCLIL;|M;},ICHHHPILBBYCIM;|HHl$VLY3HDI9k8  H\$H|$ff     M9SMLMLCI|_HIX@ HIHJIH,IHJHIHlIHJHIHlIHJHIIHlL;|M;}HHIHJIIH,M;|M;K}qHFHL@HQIH HH	MIJIHM;K}=H^H>f     LCHWHHMIMJIIHM;K|IM;SH|$H\$Hl$ ^H\$VH HHHtMtHHIH;uHH|$0HIH;{t"HJE Ht
H7HH    H|$0HsH\$8H ^蠮LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   HT$0LHHAuHHH؃H;HLA    H$x  HH+HHH$  HFHD$XI@HH3H+IU LIAALL$8A     E3Ld$ 33H$  H$x  LL$8D$  K MA   EIMDI+HA#HHM<L|$(M;,  )$  Lq)$   MD)$   N$   D)$   L+D)$   L+D)$   HH+D)$   HD$`HH+D)$   HD$PD)$   Lt$@Ld$HL\$pLT$h@      MEMH$  E(E(E(E(HQH	HIDYIHfEDYKMZHfEMIDYIIfEDYIU MMfELIIMLE3HNH2  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+L|$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfXBB(fYfX
 fYfXB8fYfX
(fYfXH M;bH$  H$x  H$  H$p  L|$(L;  HI+H  LIVM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4ff     J"A(BYD*A(A(XBBBYL"XA(JBYT:XA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJBYD"XA(BBYL:XA(JYDXBH IH$  H$x  H$  H$p  L|$(L;   JIH+MHD$MHL+H+L+LHM+Lt$HA(BY A(A(XYXA(
BY(XBY0XHIuH$  H;  HD$8HR  H  H   H;  HHH+MHMLHML+L+L+L+H BB0B(fAYfAYfAYfXB fAYfXfXfX)HHu;  HHڃH;HLE3Ld$ H^H;UMLfHHH3H+H;tIII|Iu
E3Ld$ ,M;MLLd$  HT$XLD(dE(lE(tH|$H;  H+LwHN4HHI+MH$MH,$IH+L+HD$L+L|$HH+HHLL\$C(L>K4(|(C($>(pJ6A(C(l.fAYEfAXNDA(D(dfEYfEYA(AG(,.fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)NG(t&A)>I HPH$  H$p  L|$(L;w  JHH+T$MHMLHML+L+L+L+HD  BB0B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAA(B((fAYfAYfAYfXAfAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B(0B(B( fAYfAYfAYfXB((fAYfXfXfX)HHuLH;(  Ll$`I  HEA(IfLA(fA(fA(fHUHM$L;w	I;r  HEIM$L;w	I;X  HEHL$L;w	I;>  HEIM$L;w	I;$  HIHLMHLكL+H+IL+HH+IH+IHD$H+L|$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfX(BB(fYfX fYfX
B8fYfX8fYfXH M;_H$  H$x  H$  H$p  L|$(L;X  HI+H  LIVM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO4f     J"A(BYD*A(A(XBBBYL"XA(JYTXA(RBYD:XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJBYD"XA(BYLXA(JBYD:XBH IH$  H$x  H$  H$p  L|$(L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuLt$@Ld$HIHD$PI LT$hIL\$pI;HD$PL$  Lt$@Ld$HLd$ D($   D($   D($   D($   D($   D($   D($   ($   ($  LT$0M;  L$  LLkL+@ fff     I$A(IL$E3IYIIE IMfHH=  HrxHG(HfHWHH;wH;sWHLHHH+HL+HCH+f@ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    B( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;J  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|LT$0L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$ MtE3Ld$0ME3Ld$ XD($   H(  A_A^A]A\_^][@SATAUHHA    Li@LaHQHLHHAXAU AY$LPH;'  H   Hl$0KIHt$8IH|$@KRL    Lt$L<$HBMHIIHIIHMHMMIIMHHH        CYBCYXA YXBCYHLXXHuL<$Lt$H|$@Ht$8Hl$0H;}BN    LN    LJ    IH+K	IYIXHu(HA]A\[H\$HA LL@IHH+HLIHHHHH    M'  IRfYI~mJfYH~FHCHLR HLZ0@ f     AI fYfXAI fYfXHufXL;~HfYfX(fXM;   II+H|^IHBI+JHHHM@ @HYYX YXHYH XXHuM;}JM+HYXIu(H\$MJ   AYL;|   I~TIHHIAHH   @HYYX YXHYH XXHuI;}IL+HYXIuH\$(@UATAUAVAWHpHl$0HE H]pHuxH   )u0H H3HE MLHAp AY1LIIM;vxH9HHuzJ    H=   w2J   HHH;wHHH%x H+H|$0HH8J    Hz- HHuHt HIHFE3EL96LDL}HEH    H=   @@uIM0I;v讖MM(MufH    H=   w2H   HHH;wHHHdw H+LL$0II$H    H, LHuHt?IE0I}( MDH    H=   t$(H|$ MD$0I$IL$	  t
Im, @t	I^, HM H3S  H]pHuxH   (u0He@A_A^A]A\]LHhHAMKHQICHICHA0HIICI MCD$0ICIC   HhLI;8  IH+H   HLIIHLfD  IA AYIIAPAYA@XAXAIA LAYIIAPDAYA@XAXLALIAPLAYI@IA DAYAXAXLALIAPLAYI@IA DAYAXAXLALHH;/I;}>IIKLHA YIHAPYA@XAXAHI;|HUWATAVAWHHH  HEHXHpMHHIHJLGIHGH  H  D$ HT$0HT$ HM<  HD$ LxHD$0LpHO3I;uL9wt`Mt$MtHHIL;tAIIHOH;tH) Ht
HHH7LLwL7HGLH9w   L$    HH   HUHHHL$8LBLD$@HT$PHt$XH\$`HD$h   HEJHMHEHEHEHEL}fo UEEMM(EE8fUHD$8EPL$HM`D$XEpL$h   MuW	HMAHHGH;/IML;HMm(    WD$ HHL$pLD$xHD$pHD$8HD$ HD$@H   HD$HH|$PLGIHH+HH3H~)fff     f)HH;}
D$ HL$pHHL$85b    HCHx tL   MHH
  L$  I[8Is@IA_A^A\_]@WH@HD$ H\$PHt$XHHHHXWD$(Ht3L' HHD$(H\$0LD$(HH  HL$(H\$PHt$XH@_H%' @UHPHl$ HE H]@HuHH}PH H3HE HHLBHL;vEL
MumJ    H=   w9J   HHH;w
HHHp H+LL$ II$J<    HJ& LHuHtЏHC3H9;IDH    H=   LFHHN1   t	H& HM H3GM  H]@HuHH}PHe0]H  LMK MCISIKUWIhH  I[3IsMMcMHHL$`HMkMsIHJ    M{LHMDA)s   5 MH\$HLH|$XH|$pLT$hHT$xHLLOJ/HUM  HCILHD$PHD$HI]HL$PLIMMMHHU@ ff     GA^GH   HEEHEJ:HEH} HEHH](HD$@HEHE HELHMLMH}H]@uHHH؃H;LLHI+yHHHM3I4@9L;}5@ HEEHMfBB(fYf\B)IL;|LHMHHD$HHL$PHUL   LHLHIH|$XH\$HHt$`L|$hHULt$pLd$xH   L   L   HH+H~BILMMt$0ILELEL}LMHE   IHD$   H   LeHL   HL   I@L   LH|$X   Ht$`L|$hLt$pLd$xH;($@  L$X  L$`  L$h  L$p  H$x  H$  HĈ  _]LMK MCISSUVWATAUAVAWH   H$0  HAHD)d$PD$8  3HD)t$0MMHOEWH#HL$(  A)sH_A){HE)CIHLEHD$MJ    E)xL<D)T$pISL+L+$  HH   H+D)\$`HD$IL+D)l$@HL$8  I+HT$L+H$HLt$ HEWHA   H$  @ f     A(IAYtE(HIDY
HA(A(D(E(fEE(fEۨuHH؃I;HLMHI+yHH(A(MBJ3MYXCC(AYLXYDXdY"AXM;  H9  H$MH|$M+IHIHIO4I?(H>A(YLYD
XXJJAL(YL
YDX(YLXA(YD
XX

A(YL
YDXA(YL
X(YDXXJJAL(YL
YDX(YXA(Y
XXJJAL(Y
YH XXIH$0  M;}XHJIH+H+MM+A((YYXXB(YYHXXIuJM;}kIII+H+HLHHM+Hf     B(B H(fYfAYfYfXfAYfXfXfDX)HHuL;  HI+H>  ICHI+HHHMHH+L+HMff     (A(YLAYD XXHHAL(AYL YDXA(AY X(YXXA(AY YX(YLXA(AYD XXHHAL(AYL YDXA(AYL X(YDXXHHAL(AYL YDH XXHL;}XHJIH+H+LM+(A(YYXXA(YYHXXIuL$8  (Ht$IL|$ILl$H$Lt$ fXL$8  A(fADXXDXAYEYX{DX{DHH$  HL$(L$(  L$   H$  D(l$@D(\$`D(T$pD($   D($   ($   ($   H;/  J    LL+H$  LqL$8  LLIIMkIL$   LM+H    H4IH+и   H+$  H+HHD$(ILD$ fIA(BYTJMA((BY AXAL;6  I   HMLMM+IIHIIO$     (IYAXDDD
YAX(YXDDD
YX(YAAX
A

YAX(YAAXDADD
YAH XIcL$8  H$  L$(  L;}BHJHLL8HI+(YAXAA
YHXHuH$   IHD$(HLD$ IL$(  AYAX	A	IIL$8  LD(d$PD(t$0H   A_A^A]A\_^][HLH HHUVWATAUAVAWHhH   HEHX)pMLH:H   I Hx   WEHE    HBHXHIHt?HtIHHH;t趂HtHtIHHH;t蔂LLMt#3 I7LHEILEH}H]I$LpIL$HqI;uH;tZMtHtIHHL;tHII;t$I~ HtH
HEHE    LuHuMD$I$HM2  I] HE0H}gHGHOWEHEHMHEHELEHUHM`HMHHEHEHMHMIE HHI$HPHuHKHGLLSLMLL$Pt$HHD$@LD$8HEHD$0HEHD$(LT$ LLEuHM HMx HMm H$  ($   H   A_A^A]A\_^]@USWATAUAVAWHl$H   HMHLHXI;Xt$I HtHL	IE IE     I]IL7MgH$X  )$   LeoL;0|  LGL;@n  L9GIH      ?HLW3H|~IINHMHHIIJ    L+IHBL+HI      ?HH4         M$M$
L!LdIHuLeoH      ?H;}!N   HIIH+HIHuH}wHL$ WuHHD$XHGHEHD$XHD$ HEHD$(HEgHD$0HEwHD$8)  I  @ ff     MIG LMLeMYHPL]IH|$8HUIIMMLGHL+LD$PIM+LOL+M+LT$(ILL$HHLT$0HI+HMIMM IHT$@HL]A HUHIGHL$ HNHL$ tm    LGHIIt$XLD$(H|$8L$0HD$@    HLd$HIHT$ D$ LD$PHpII+LEHLEH+HuHEHED$@HHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CHNI;} D$XHEf)HI;|LHL$ INIME3LmoIII+H  @ ff     I1LGI+HHLD$(IIt$XH|$8HL$0HD$@    Ld$HHLD$PHT$ ID$ H+HuHEELED$@HLEHMHEHD$ HD$XHD$(HEgHD$0HEHD$8HMML$PMEuHHكH;HLHH+yHHHL$ L3L4CLI;}D$XHEf)HI;|LHL$ ILMIIII+L;  L@MtHHIL;  IMIHHWE3LL9G~L
ǳ L    3H~)ID  I;u(WHHWHH;|IML;G|I\$H   D  MIG LMH]MYHPL]HH|$8IHUHMMLGL+IL+LOHL+LT$(M+LT$0IL]I+LL$HA HHHMHT$@LD$Pt2IIMM HHUHIGHL$ HLHL$ }  0IMM IHHUHIGHL$ HLHL$   H($   H$X  H   A_A^A]A\_[]z@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI AYBAAIBLAYJAIIBHBDAYBAAIBHBDAYBAAIuLt$ H|$Ht$I;}&HHKL HAYAAHI;|[LL$ LD$HL$SUVWATAUAVAWH(  H$  MLD)$   H$x  MHHAuHHH؃H;HLA    H$  HA   H+HHHt$ HFHD$PI@HH3H+IU LIAALL$8X  E3LL$(L$x  33Ht$ H$  Lt$8D$  O$ MA   IMDI+HL|$hA#HIHHT$@M4Lt$0M;
  )$  N   )$   HD)$   H+D)$   D)$   D)$   ID)$   M+D)$   D)$   HD$XLL$HLD$`Ld$p@ IE(M] E(E(E(FYD	JMEFYLJFY\IFY	HfEfEfEfEIE3MMID$MHIIIMH0  H  HGA(IfHWA(fA(fA(fHH;w	I;a  HGIH;w	I;K  HGHH;w	H;5  HGIH;w	I;  HLHMIHH+LH+L+L+HSIIH+H+HD$L+Lt$IH+HD$IHl$H+HBIILfYfXJADfYfXBLfYfXJDfYfX(BB(fYfX fYfX
B0fYfX(fYfXH M;_H$  H$  Ht$ H$p  Lt$0L;~  HI+H  LIWM+HIIH+IHD$MHl$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<fff     J"A(BYD*A(A(XBBAYLXA(JAYTXA(RYDXBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BAYLXA(JYDXA(BA(BYL*XJJAYDXA(BAYLXA(JYDXBH IH$  H$  Ht$ H$p  Lt$0L;   JIH+MHD$MHL+H+L+LHM+L|$HA(BY A(A(XYXA(
BY(XBY8XHIuH$  H;  HD$8He  H  H  H;  HHH+MHMLHML+L+L+L+HfD  B(B BfAYfAYfAYfXB8fAYfXfXfX)HHuK  HHڃH;HLE3LL$(HH;M|fHHH3H+H;tIII|L$x  Iu
E3LL$(YM;MLLL$(MHT$PLD(dE(lE(tH|$H;  H+LHN<HHI+MH$MH,$IH+L+HD$L+Lt$HH+HHLL\$     C(L7K<(|(C($7(pJ>A(C(l/fAYEfAXODA(D(dfEYfEYA(AG(,/fAYfAYfAYfXfXfXfAYfAYfXfXfAXfXA)OG(t'A)?I HPHt$ H$p  Lt$0L;z  JHH+T$MHMLHML+L+L+L+H     BB8B((fAYfAYfAYfXB fAYfXfXfX)HHu   H;   HHH+MHMLHML+L+L+L+HfAB((AfAYfAYfAYfXA(fAYfXfXfX)HHu~H;}yHHH+LHMMHML+L+L+L+Hf     B( B((B(8fAYfAYfAYfXB(fAYfXfXfX)HHuLH;  Ll$XI  HEA(IfLA(fA(fA(fHUHM$L;w	I;l  HEIM$L;w	I;R  HEHL$L;w	I;8  HEIM$L;w	I;  HIHLMHLكL+H+IL+HH+IH+IHD$H+Lt$IH+L+H$IH<$H+HBJIL2fYfXJBDfYfXBL*fYfXJDfYfXBB(fYfX
 fYfXB0fYfX
8fYfXH M;bH$  H$  Ht$ H$p  Lt$0L;L  HI+H  LIWM+HIIH+IH$MH,$L+ILH+L+HD$MHt$L+IH+HD$IH|$H+IHO<J"A(BYD*A(A(XBBAYLXA(JYTXA(RBYD2XBA(Y(X

Y XA(Y0XA(
Y8XA(A(BYL*XJJAYDXA(BYLXA(JAYDXA(BA(BYL*XJJAYDXA(BYLXA(JAYDXBH IH$  H$  Ht$ H$p  Lt$0L;}jL+JL+L+H+LM+H
A(BYA(A(XYXA(
BYXBY XHIuHT$@LL$HHLD$`I L|$hLd$pL$  L$  HT$@LL$HI;L$x  D($   D($   D($   D($   D($   D($   D($   ($   ($  Ld$(M;t  L$  LLkL+I$A(IE3IMBYIE fHHC  Hz   HG(HfHWHH;wH;sYHLHHH+HL+HCH+@ @ILfYfXH fYfXH M;|L;   HI+H|zI@LM+HIHIH+IO@ ((YDX@@(YX(YDX@@YLXHHH IuL;}+LJL+HI+(BYX  HHuAuAH;}zHHH+LHL+HH    A( fYfX ) HHu>H;}9HHH+LHL+HHfD  A fYfX ) HHuLH;M  I   HU(HfHLMNLH;wM;s[ILHHH+HL+HFHH+f@ILfYfXH fYfXH M;|L$x  L;   HI+H|vI@LM+HIHIH+IO((YDX@@(YX(YDX@@YLXHHH IuL;}'H+JHI+(YX  HHuIM;Ld$(MtE3L$x  ME3Ld$(cD($   H(  A_A^A]A\_^][H\$Ht$ UWATAVAWH$H  LMHQHH    L	Ly0IA\f҃vFHSN    E33H~I(HY H@@HSH;|IML;C|  L[IHH3H+IHHރHuIHHكI;HL3N$    IDsff     ME3L+ILH|IHJHHHL    @  H@ (fY@(Y@@YHHHuL;}%JIHI+HI(YAAHuI;}7H(IfIH+HHH@ (HIfY)AHuM;}-JIII+     HI(YAAHuH2HH3H+L;HILIII  A Wf.z  LqHIHI0L$H  U)$   LL$xL,LuHBH   L   L   LL$@Lt$PK   C    K0   H   H   HD$@HD$XHEHD$`H@  HD$hHD$xHD$pAO   foS f   AM`AO0   EPAG EpAuIIAM;ILIHL$XH+LHH+3HH4G3H;}%ff     EHD$@f)HH;|MHL$XHE3HEPLM LD$@H   IHE   HEH   HD$HHD$xD$0HD$ Ll$@蓳KHHL$@HuL$H  LHL$XHMHEHL$`H@  MHL$hHL$xK0M0HE0E HEHD$xHD$@Ht$PHL$pC E uHH؃H;LLHHL$XI+HH+3HI<@L;}&@ HEHL$@BfBXB)IL;|LHL$XHEHUA$Ht$xE]	  fufsfuHH`H($   HL$PHL$@HL$XHMHL$`H@  UHT$@HxHL$hLHD$puHHڃH;LLHHL$XI+HH+3HI@cL;}>@      HEEHL$@fBB(fYf\B)IL;|LHL$XHcD$xLE8HEMHUA$H   EHEAM AOE8AG MHAO0EXUMh
  L$  I[@IsHIA_A^A\_]H\$Ht$H|$ UATAUAVAWH$H  LQMLHI   LLy0IA\f҃vPE3AL9KI  N    IM~I(HY H@@LSI;|HMH;S|	  HsA   IHA#H3H+ALIE#HuIHHA#I;LH  E3N$    AI@      MML+ILH|HHJHHHL    @  H@ (fY@(Y@@YHHI+uL;}$IIHI+HI(YAAI+uI;}8H(IfIH+HHHfD  (HIfY)AI+uM;}-IIII+f     HI(YAAI+uJ2HA#H3H+I;HIOIII+  A Wf.zp  LyIHIHLL$0Z0HE IBHE()$   fo5N )$  D)$  D)$  UL|$@L}0fupLML}:DBDJ MHI0MhHEhH   HEHD$PHEHD$XH@  HD$`HD$0HD$hE8A EXAuIIAM;ILIHL$PH+LHH+3HH4GF-H;}EHEf)HH;|MHL$PH-~ L@  L$@LD$P@  H   D$0HL$pL$`(M0D$P(E D$p(E@E(E`E   M(MPE   D   D      MuZ  Ht$@E3L#AL\$0D($  MD($  ($  ($   L@  KEC MK0MH}EH   ICHHLFIILLILIIMIJ    D  BX@@BXHH X IXHHH IuL\$0L@  H;}3HL    HIIAXAHH;|L\$0H{A] L;KEC MK0MHUEH   HLGHIKLIIHHHIMHIN    B(YI(\(BYI\( Y\ YIH \HIuL;}0H    II (CYI\ HL;|AE LEANIFHT$pEHM AHEMAN0EAF ML$@ED$0MEy  L$  I[8Is@I{HIA_A^A]A\]@SMHI;  IH+H   HLJLQHt$   H|$L ILt$ I+IM+HOML+IIIJIBKMI A^B AAIBLA^J AIIBHBDA^B AAIBHBDA^B AAIuLt$ H|$Ht$I;}&HHKL HA^A AHI;|[HLAH3LBBIJ(A B8I0JHHBPHBXHBHHB`HH   HR@HD$PHA`HQALL$@HIHD$XI LD$PfsD$0HD$ f\$@fT$H膨H   H   ZLALL$@IRfsfH~D$0fT$@HHIHD$PIB0HD$XI LD$PHL$HIJHD$ HĨ   HL$VWAVH0HD$ H\$XHl$`LHHL$P3HHAHAHHhHBHxHuHtM$HtHHHH;tVHHHt3} HHHkH{MFIH  IFHCHHC HCHC(HKHHC0HAHC8IFHHHK@HH\$XHl$`H0A^_^Hl$WHAE3HH(L9M   H\$Ht$f     L9MMLLUE3I|kLIrH_ISIHIIHISIHIIHDISIHIIHDISIHIIIHDL;|M;}$LH_ISIHIIIHM;|IL;MJHt$H\$Hl$ _HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHBXHEHZ0Ht3 HHD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~8@ f     HEL$pffYA)HH;}LD$PLHL$0hM~IMF      AIN`HIHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$0UL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0UHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]HLH UATAUAVAWHhH@  HEHXHpHxLM WD$ B D$pHB(HEHB0HEHHt!Ht3 H:HD$ H\$(H\$(LD$ LD$PHD$PHD$0HD$hHD$8H   HD$@HD$ HD$HHHH+HHHE3AH~4f     HEL$pffYA)HH;}LD$PLHL$0M~IMF      AHIN`IHHUI~H}AEANMAF EAN0MAF@EANPMAF`ELm Hu(HMHM0T$pHD$ HEHT$PHL$`HD$PHD$0HD$hHD$8H   HD$@HEHD$HLuHHڃH;LLHI+yHHI@3HL$06SL;}4HL$PB(HEBD$pffYf\B)IL;|LHHL$0RHI;HL$  L$@  I[0Is8I{@IA_A^A]A\]LMCISUSAVAWIH  LQMLAHLIIJIH  H  HE3HEIIsI{HzHE HBMcMaHEHULMH}HML;uM;tdHt"MtHHIH;  IHMI;t%H Ht
H.HL;L   H{LcH{ILCHHHL$  H3H  H+H}HLD$ MHD$hM  ILH   @ fff     HIH+HHH       IQIHfo IUfH}LuHT$8LL$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHM  L   AHH;0H   H  HH;}9HL4 MHULHMM  HMv( A)FH;|L   H}H;   L   IPI Hfoˇ IUfH]LuHT$8LD$HL|$PHIHL$0Ll$XHT$`HIFHL$xHEUPD$xME EM0L$@E@D$0MhL$`   EXD$PExHuWHMV  L   AHH;0HD$hL   HH  HH3H+H    H;HH   HLHIH   LL;l$ L$  H$  H$  L$  H  A_A^[]HHD$ HEE3HD$hLD$(HEWMD$hH   HL$ HEIHH]H+HHH~(f     fB)IL;}
D$hHL$ HHMI~     RL   L   IH!   H  A_A^[]~JLWH   ICI[IsA)sIHHHz    Ix    A1HRHIHFWD$hICIKISMCISIK(H$   HHD$xH$   H$   H$   HWHKHLLHD$hHD$Pt$HHFHD$@LT$8HGHD$0L\$(HL$ LLCqHL$h HL$p L$   I[IsA(sI_@UH0  Hl$@H   H  L  L  )   H H3H   HMIA1U fsfI~)E`A`)Mp   L;&  H}     HM HUhJ    3t$0H9u LM HM LEHDHD$(   HMpH=   HE`HEH   HEIHD$ HE   цt	H H   H3  H   H  L  L  (   H   ]J    H   w8HCHHH;w
HHH( H+HL$@HH	H HHHGGAVHA LqLY@LIHL@   AAYL;   I   H\$K@Ht$MQH|$ IIIHIKIIHHHIJ   @ YAYIXYXBYIHH XXIuH|$ Ht$H\$I;})J    LKAHY	HXI;|(A^H\$H|$LY0IIWM~DHALI(LQHI LL    JIIHffYfXIuH\$HH|$)HcAH+HcAH+2HcAH+HcAH+HcAH+HPHcAH+2HcAH+DHcAH+
H?'HSHcAH+^HcAH+HP餾HcAH+ HcAH+SHcAH+0HHcAH+HP鴿H'HcAH+H3HcAH+HcAH+HcAH+lHcAH+HP|PHSHcAH+$
HK]H(\HcAH+H7PH4HHcAH+ ^HcAH+H`[H(鷼HcAH+HPdH(XHcAH+RHcAH+HP\HcAH+HP\\HHcAH+	HcAH+HcAH+lH(c[H(HHcAH+HcAH+HP<%HcAH+HPHþH[H(XHWH0H@HXHhHpHHyHHXH,  HӐHHtHHH     HӐ@t   H0  HH\$@Hl$HHt$PH0_@SH Hٹ     HD$8HtHL HHXHL H [% % % % % % % % % % %r %d % % ff     H;
 uHfuHS  H\$Ht$WH E3H
SL   m  H
J  HH   HQ Hp Ha HH] Hn HHJ HHtnHtiHtdH%L  H
  H
K H @   ?+HH3HH3H=K HK H
O   ^  H\$03Ht$8H _E3E33AQ HK Hu     ̹   {  H(H
AK [ H
dK Ht9 H(@SH HH
K  # H
K  H [   @SH HH
J   H
J P Ӣ eH%X   A   LЋ C H [h   @SH HH
J N ; u4d      ;teH%X   
XP A   HȋT AH
9J H [H%E @SH H
OJ Hu0H+ H3JJ ?HH  H
J HH [H H

J H [H% H\$Ht$WH 3H9=I u8Hš H3I ?HH>  DHI H
I Ӆ3H
uI  H
I E3 H
VI  H\$0Ht$8H _@SH H!Hs  uHub  ;  HO  HtH [H(/
  t!eH%0   HHH;t3H
 I u2H(ðH(  t      t2  H(H(3A  H(H(  u2  u  H(H(    H(H\$Hl$Ht$WH IIHL  uuH  L3HHT$XL$PH\$0Hl$8Ht$@H _'  H(  tH
H H(%  Nu#  H(H(3%  H(  @SH H ɻ   DÈG 	  
  u2
  u	3
  H [H\$UHH@ك   _  t+u'H
lG u
  t2zH
pG a
  gH I¹@   ?+ȰIL3LELEELEMG LELEELE
	G MG 

G H\$PH@]ù     HLMZ  f9quyHcHaH9PE  u_  f9AuTL+AHQHAHLH$I;tJL;r
BL;rH(3Hu2z$ }2
22H@SH 
  3҅tuH
F H [@SH =/F  tu(  !  H [@SH H HًH3E ?HHu
H  HH
E   3ɅHDHH [H(HH(]  @SH H HHt
   HH [H(t9t(tt
   H(rCH(IH(   MH(,  H\$Ht$H|$ AVH HL3u3   f؈D$@@=D  t
   r  D    tg	  H
	  5	  H
>	  P	  H H
 
  u)0t Hu H
N ]
  D    @2@N	  HH8 t$H2tHH?  Lƺ   ID    H\$0Ht$8H|$HH A^H\$Ht$WH @C 3ۅ3PȉC =@D$8=sC t
   K  J\C o@/3@IËH\$0Ht$@H _HHX L@PHHVWAVH@ILu9DC 3   Bw*   ؉D$0   LƋI؉D$0tvLƋId  ؉D$0u+u'L3IH  L3IcL3IN   tu*LƋI@؉D$0tLƋI!   ؉D$03ۉ\$0H\$xH@A^_^H\$Hl$Ht$WH Hi IHHuCH_   LǋHH\$0Hl$8Ht$@H _H\$Ht$WH IHu  LǋHH\$0Ht$8H _wH% @SH H3 H  HȺ	 H [H% HL$H8   	  t   )H
'B    HD$8HC HD$8HHB HB HhA HD$@HlB BA 	 <A    FA       Hk H
>A H      Hk H
 HL    HkH
 HL H
  H8@SVWH@H H   3E3HT$`H} Ht9Hd$8 HL$hHT$`LHL$0LHL$pHL$(3H\$ N ǃ|H@_^[H\$UH$@H  ٹ     t)%E  HM3A    HM H   H  HE3 Ht<Hd$8 H  H  LHL$0LH  HL$(HMHL$ 3 H  HL$PH   3H  A   HH   ,  H  HD$`D$P  @D$T   r HD$PHD$@HEHD$H31 HL$@ u
!D H$  H  ]@SH HHH
1 HHS3H
HJHHl  HA HHH [3HAH7 HAH HHH HH  H\$WH H HHH  t
   HHH\$0H _HHHL$ H/U HL$   HHHL$ ZHN HL$   H\$H|$UHH e 33    D    cAMDDDAentiAineIAntelEDD;C AAuthEًDفGenu3ɋDҸ   EDDMȉ]UEuRH
! A%?DB = t(=` t!=p t wH     HsADB Eu  ` rADB    UDM;|$3E]MU]	sAD]B Asnl    f    AsSAsL3H HHUHE$<u28 '    E ! t      H\$83H|$@H ]̸   39 H\$ UHH He H2-+  H H;uoHM> HEHE( H1E HM H1E E HMH H3E H3EH3H  H#H3-+  H;HDH9 H\$HHH2 H ]H(uH=  u    H(H
@ H% H
@   H@ H@ H(HHH(Hia H\$Ht$WH HB H5; H;Ht
HHH;rH\$0Ht$8H _H\$Ht$WH H H5 H;Ht
HHH;rH\$0Ht$8H _% % %n %p %z % % % % % % % % % % % % %t %f %X %J %< %. %  33333333333333333HL@HHUVWAUH8H  )pMBtH)xB|D)@FD)XA\D%p D)xEWY5Ae fA.zuT=p D\   D)$P  (Tdp (T
Zp D(f/D)$0  D)$  EYv
D(^^D((fE.DVe zuA('YAX(y L   (H   AYfE.D($  z.u,fA/w	Dg (DX^A^YD\fA/wAWXD^E\D($P  D($0  BIB4A\D($@        M;  H$  IL$  IXL   HL$  L   IL$  H+M<fL   H   HL$0ȽL(DD$0|$8[((AYYYAY\YAYXAY\(XA(YYY\X(Y[A(Y\\H;   ~A((YLY\LIE   H;}"(AYYAW   M   3Ld$PKHUHD$pLD$@HGHULt$XHT$pL$PLt$`HMD$`AWMHEML}DD$@|$HLuEH} LuLt$xELuJ    HLHI;WL$  L$  L$  H$  L$  A(sA({E(CE(xIA]_^]3@SH HA3      tHHH [H@`Ht7H   Ht+HHt!H
 H9Ht6Hm HH [<   ^ HuH
b H;9 H	b HH [@SH0HAH      t-H
 L9 LH   H	 u/HH0[H
 LH@LHj: HD$ H	 H+u
HCHP03H0[E3H;
. AAH;
 H;
 AAuH% H\$WH HHHIHU H;t6 u,LHT$0H} HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H6 H\$8H _@SH H=     H D  C
HKt1{ tH 0HSLCHMtE35  
HSH HKHHCHHt% Hu H(H{ u3H [ÃH [H\$ UVWAVAWH   H~ H3H$  ILL HH1  H H/Hu
HWHR0H  I HH   HH H.Hu
HVHR0H+u
HSHR0H   HG    |H
R H5 MMH	 tHG H;vBHl$0Lm6 HD$(HL$@MLt$     E3HT$@3P x.HJtH
ƿ Hw6 Hl$(MMHD$ H	 H/uHGH
H+u
HCHP03H$  H3mH$h  H   A_A^_^]@SH T HHuH [HH|$0x H+Hu
HSHR0HH|$0H [H(  H H3H$  A   D$    L HL$4AQ ] L    LHL$0c D$08D$4u%D$28D$6u3H$  H3{H(  HD$0   HD$(LL$4H4 Lq4 HD$ HL$@ A   HT$@3 H$  H3H(  H(H H
- H H HA  HuH4 H(HH
E @  Hy4 HuH(3H(H(=M     H
@/  Hu13 H
ֿ H0 A   H	ȿ y/H(H   :M    HHtH(uH@P0H
0  Ht$HK   HtH(uHPHR03H(ɻ 3H(   H\$WH0HU HH   L H- HҼ    L+3 H- H    LH- H xoLm> H- H} xTLHD$     LH
.    Ht.H(u
HPHR0H+udHCHP0HH\$@H0_H+u
HCHP0H H
% H6- A   H	 yH/u
HGHP03HH\$@H0_@SH HQHLAMtI 3Al AhHA@HAHHA HA(HA0HA8HD$PHtH HAXMtIHD$XLIPHtH HA`R HH [H\$Hl$Ht$H|$ AVH0H
1 IH5< HH-k; L5L: ~ HtHt$(MLHl$ HHH\$@Hl$HHt$PH|$XH0A^H(LHt4HB      t$HIXHIPXHt
H)uHAP03H(H
1 H+ H	1 H(HAXHHDA H H(LHt4HB      t$HIPHIPPHt
H)uHAP03H(H
 Hb* H	 H(HAPHHD H @SH yh H   Hl$0Ht$8H|$@Lt$H HHhPHpXLp`3HGPHGXHG`9ChuHt3H  HHu޹ HtH 
H(uH@P0MLHHH  Lt$HH|$@Ht$8Hl$0H [@SH H1 H{8 t	H {h |H H u H H$   HH [H%u H [H\$WH H3HIHtH{H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP03H\$0H _H\$Ht$WH HIHIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _LI[WHP3HIC H ICA   ICHICHIC ICEAICICҷ u
3H\$`HP_LL$pHLD$xHT$@D$(   H\$    H\$`HP_LL$ LD$SUWH0yl HHYHHt!H
 H	& H	 3H0_][Ht$PHt  HHf t$xL I;t5HB    }      @t3Hg
  IH tetaHH  H+u
HSHR0HOHHtHGH    H)uHAP0   3Hd  HHt$PH0_][   GlHHCH;n+ u(HD$pHLL$hLD$`t$(HD$ H'  L   Hv0 MtA HH   H+u
HCHP0H
 H	 uHt$PGl3H0_][ HOHHtHGH    H)uHAP0Gl LD$hHHT$`
=  3Hp  HHu' H9XPuH
] E3E3HHHD  HHt$PH0_][HT$pHHt LL$hHLD$`HD$      H.Hu
HFHP0Gl H+u
HCHP0Hu7H  HHu' H9hPuH
 E3E3HHH]C  HHt$PH0_][H\$WH yl HHYHt$H
ڲ HC# H	 3H\$8H _HtIHHHt$0  HOHHtHGH    H)uHQR0H+u
HCHP0Ht$0uH
` H	 3H  Ht4H(u
HPHR0H
! H" H	Y 3H\$8H _& Ht*L HH M H]	  #ϰ HH H\$8H H9 H _@SH HHIH{l tH
 H" H	 3H [Ht4ClHAH;*( u   Cl Hu!HH [  H HH [  H [H\$Hl$Ht$ AVH H' 3HLH9BuHHH      AlHHBH+ H|$0L   MtAB HHu%H
۰ H	 u	H o '3H H/Hu
HGHP0HDH|$0AFl HtH+u
HSHR0H\$8Hl$@Ht$HH A^@SH HHIH{l tH
 Hg  H	 3H [HtKClHAH;& u H;* u   LH+ q2  Cl HuDHP   H  HHu'0 H9XPuH
 E3E3HHH?  HH [H\$WH 3HHIHHD$0HtHGHH)uHAP0ı HHT$0  H\$0HH   HHtH+u
HSHR0HH\$8H _@SH HHu'd H9XPuH
7 E3E3HHH>  HH [H\$VH AhHHمu2Ht-H; t$H
l H H	l 3H\$8H ^Ãu"HtH
 H	Ů 3H\$8H ^H|$0 H{  HtSHC0HtHHHGHtH HGHAHC LGhHWpHOxHGhHC(HGpHC0HGxLC HS(HK0DH   HGhHC HGpHC(HGxHC0HC HtH HC(HtH HC0HtH LClHHSH|$0Cl H\$8H ^HtH
 H	H%­ H
! H H	H%  H
 HJ H	H%  H\$WH HQ 3Hy(HY0HA HA(HA0HtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H\$UVWAVAWHH HqP3HYXLHy`LHu0H]@H}HHAPHAXHA`HuGHtH/u
HGHP0H]@HtH+u
HCHP0H7 H H- I  HF L I;   HuH H H H}HHu0jHKI;u	H[@H-      t<H{|	H[HH H H HM@H)uHAP0H}HHu0I@     H   HtH/u
HGHP0Hu0H.  HFH  HF    }      @t3H  IHG H}HH]@Hu0u%LLHI:  H\$XH A_A^_^]LEHHU@HM0 HE@HHH HH;t2 u(LMHILE@HU0:  H\$XH A_A^_^]HMHHt
H)uHAP0HM0H)uHAP0HE@HX@HHM@H)uHAP0I3H\$XH A_A^_^]H\$HHYhLYpLQxHAhI HApIHAxHH\$MMH\$Ht$WH HHHQHHS HHttL@A      u	HC HG H9C t-H` H
I LGH	 H+u
HCHP03H.u
HFHP0Ht$8HH\$0H _H
 H	? t H xHWLH xHHH\$WH IHH;tRI;tMHA    }      @tH\$0H _~    uHHЪ uH\$0H _ø   H\$0H _LH;u   HA    }      @t3   H%s E3LHt9H;u   0HX  Ht7LXIM~HL9tHHI;|A   I;u,   H H   I;tHuL;
8 AHX  Ht4HPIH~NH@ L9 tHHH;|Afff     H   I;tHuL;ة AAA   AH;tMLX  Mt#MA3M~IIH9t-HHI;|3H   H;tHu3H;r ø   Htfff     H   H;tHu3H;6 ø   H(HA      tiHQHHtVHtHHt0Hy H
 H H	0 HH(H(H%l AIHHH(ËAH(3H(H\$0	HHuHH\$0H(HH|$ VH+Hu
HSHR0H\$0HH|$ H(H(HA      tEHAHHw,H׽B H3H(ËAH(ËAH(H(H%O H\$0MHHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(NB NB NB <B 5B FB NB NB NB H(HA      tEHAHHw,HC H3H(ËAH(ËAH(H(H%o H\$0mHHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(.C .C .C C C &C .C .C .C H(HA      tEHAHHw,HhD H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(D D D C C D D D D H(HA      tEHAHHw,H7HE H3H(ËAH(ËAH(H(H% H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(D D D D D D D D D H(HA      tEHAHHw,HW(F H3H(ËAH(ËAH(H(H%Ϡ H\$0HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(E E E E E E E E E H(HA      tTHQHHtAHt3HHyH
R H
 H	 H(H(H%/ AH(3H(H\$0HHu
H\$0H(HH|$ lH+u
HSHR0H\$0H|$ H(H(HA      tEHAHHw,HG H3H(ËAH(ËAH(H(H%/ H\$0-HHu
H\$0H(HH|$ {H+u
HSHR0H\$0H|$ H(nG nG nG \G UG fG nG nG nG H(. H(H( H(H( H(H(Ο H(H( H(H( H(H( H(H(N H(Ht$WAVAWH L= ALtx  tDADH\$@Hl$HEt8H- Ht, H  ; }HHD9Du
H\ H,MDƋI   HHtntHЋ  f L7 E3HH HHtHȉp|| HtH+u
HCHP0HtH/u
HGHP0Hl$HH\$@Ht$PH A_A^_H\$Hl$Ht$WH   HAIɋ HHtVtDLr HH
	  	H HHu@H/u
HGHP0HtH+u
HCHP03L$   I[IkIs I_H E3H
 E3HL$p3҉l$hH\$`H|$XHD$PHD$HHD$@HD$8HD$0HL$(3D$      H/Hu
HWHR0H+u
HSHR0He̅J  H\$Hl$ WH H= HڋHuH   ] H  hHHH v @   h    H\$@Hl$HH _Ht$0Dŋ5J HϋLt$83  LcD;}'IH9luHHH)   HAP0}
 ;u.p@HHcH_ HHtX5 5 H HcMI;~#HHHI+@ AHIAHuMƉ5 BlJHHt$0Lt$8H\$@Hl$HH _@WH Dt;H=\ Ht/I H9   ;; }HHD9Du
HH H _3H _H\$E3DRHAExMcMF;D~H\$E~-AA+Ù+AHcHɋTD;}D~DXE;|HcHD;D~H\$@UVWH H
'  3HtH H H   LD$HH\$@HT$PHL$XȘ H
 HR HAL   MtAߙ HHt,Hn H= HE= H+uHCHP0HLD$HHT$PHL$X H\$@Hu%L H H
T  H _^]H EH _^]H\$WH HAHL   MtA HHu.H
 H	З tH
 Hf LH	* HH\$0H _H\$Hl$VWAWH0333HLHu3 HH   HH
 Lt$PL LHt~~ HHtp.   H
 ܓ Ht<LD$    LII HHu7H
. H	 t#[ LD$     LIIɘ HLt$PHtH/u
HGHP0HtH+u
HCHP0H\$XHHl$`H0A__^LI[IkVWAVH0HAP3ICIHAXMCICLHA`ISHi`HHiPIHiXIKIC H9nP   HD$PHt(HL$(HO    HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHVhLH~pHH^xIHNhLFpHFxHtH*u
HBHP0HtH/u
HGHP0HtH+u
HCHP03QHL$ I.H/H+Ht
H)uHAP0HL$(Ht
H)uHAP0HL$PHt
H)uHAP0H\$XHl$`H0A^_^HIPLH;u   Hu3HB      2   HA    }      @t3BH% H\$UH HjE3HH~HB H;|   IHL;|Ht$0H|$83H   HrfHH;   HC    }{      @toHX  Ht4L@3M~HH9tHHHI;|3H   H\$@H ]H     H   H;tHuH;    	H u'HHH;O3Ht$0H|$8H\$@H ]ø   H\$WH LQhHypHYxHQhLApLIxMtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _HAhHHApI HAxIHHtH I HtH IHtH H\$WH   H3HH9HHDG< u#HL
 H;HC8HC0Hq HC@H{FDK$AtPH
 H A   H	 H9;tHq H9C@uH{@H H$   HĐ   _H$   HL$@  HS(HL$@  HtCH
' H;tbLCHK HH L
 HGIHD$0HŠ Hڄ LOHL$(H
 H
 HD$ H	 7H9{@uHp HC@3H$   HĐ   _3HHAH 	 HA8HA0Hp HA@H9 tHp H9A@uHA@    H%n H\$HT$UVWH HHL©fHH}  AY 3AY IHH\$HHGE=H\$HHÈWEH\$HHo(HG8HG(   {{HD$P   H    3GD HG0    HCHG8    Ht!@ HSH4H  HH;uHHD$HHD$PLH&HG8HU    HG(HG GEHH\$HHG(   Ho0@oDGFSHý   B[  eR  8WDu+;o@u&GE8GFuHG(HG0HHG(   H\$HH    HG(HG0GEGFHH\$HGDo@HG(   IHÀ;:nfD  HÀ;:uHH\$H+HT$HH>  H   H\$H0	w9CH<0|D  <9}4HÍv4p<0}H\$Hu,H
 H) DH	 t*L`HcHG(H] H
 H	Վ 3H\$@H _^]H
 H AZ   H	Y 3H\$@H _^]@8oDtH9ouHn  3H\$@H _^]HW  tH9ouHH\$@H _^]H cHw8H$  ^@oDHtHO 3HHHt
H+HHO HCH\$@H _^]fX hV DY X W rV V W V `W W #W PY 5X  







































































	




















H\$Hl$Ht$H|$ AVH HA3HLHHHy(L I HchXtH H
 H	 3    t   LA       )   эB<       A<	  CDA0H<0|f<9}CHDIFH<0}A   L;}HGHIcHI;uh,t	)   HCII,HEHN;   HGH DHHH
 D@XH	    HGHcHLH
 MDH H	X gH
o H DH	; JH
R H DH	 3+; uH& eHCGGHG(   IHw H\$0Hl$8Ht$@H|$HH A^@SAVH(DADHA   Eu
3H(A^[HQLd$XE3HHL9aHA   EAstApuQD9qXECGHHS0HLQHAI;t-H
i LMH H	3 Ld$XH(A^[D8cGu+DAXH
 H
+ H	 Ld$XH(A^[ËQX~ L0H@HuDcGHC0   S@AHt$HH|$PL|$   DHl$@fHKH9KFH7@t^tS@KD  S@KD  {F@HuCKD  LHa  HK 3HIHt
H+IHK L9c8u
KD  HC8HNH;uD8~\tMF\<Cu.L9ft(HKHQHWHHKHFHHCHP   <Ht
AH   H;   HCLOLHHC I;   H(HK MtIFHHHC HK0H;tUHCHH8HHuHCHCH8ڀy\Su8HCHWHPHAL9 tHCHHCHHCHP
LcL9c0u2L9c0DcD3Dc@'H
4 H% LH	 H/   Hl$@H|$PHt$HL|$ Ld$XH(A^[H8HALHtCLL;t6H@Q@IDL%  MH LICHD$(IM HD$ GHuL
: L H L7 HL	AHDAP@  HD$(H; LT$ MH
L H	# H8H(DA@1wVL
HA` A` IHH(ðIH(ðUH(ÅҸR   C   EH(ðOH(ðPH(H
ʆ HK H	 2H( n` ` ` g` `` u` `      H(DA@4wEH؞Ha a H   H(ø   H(ø   H(ø   H(H
 H| H	˅ 3H(>a Ha Ra \a fa       H(DA@4wEHHhb Tb H   H(ø   H(ø   H(ø   H(H
+ H H	 3H(b b "b ,b 6b       H(DA@1wqL
8HAlc APc I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
/ H H	 3H(b b b b c c 2c      H(DA@4   L
4HAd Atd I   H(ø   H(ø   H(ø   H(ø   ҹ   EȋH(ÅҸ      EH(H
+ H< H	K 3H(H

 H H	݂ 3H(fc c c d "d d 6d Td       Hs   LA f Ae IH{ H H H H H H H H H H ÅH
% H. HEÅH
( H9 HEÅH
; HL HEHP HX H` Hh H, Hh  e 
e e *e :e e e Je e e d ge Re |e e "e 2e e Be e  	

DHU H
ƀ H	H% @SH HDA@<	w<BHA؃0<0|<9}H[X<0}HtH [ÃHH H
C D H	 H [HDA@<	w7BHEA0<0|<9}GHE@F@<0}HAÃE3H LJLr HAHQLLIH
HALI LHfAE@@HA(   LI0DIDDI@DIGLI8=r Su(fHAI@HQHHALHI@L Ax\St̸   H8MLEu9HAH;   HX  HtXLA3M~HH9tcHHI;|IBMLJH HHHL$ H
 H	~ 3H8fD  H   H;tHuH;x t   H8H\$Ht$WH LAHIxpHt[H tTH~ MtI	HLM} HHtJHHWH+Hu
HSHR0HH\$0Ht$8H _H
' H M@H	} H\$03Ht$8H _H(HU| H9AuQLYE3HA EHL;AL9Y AEtHHAJICHA3H(b| y,H(LHl /   HHtH(uH@P03H(H\$WH HAIL   MtA} HHt,HH5   HH+u
HCHP0HH\$0H _H\$0H _H\$Hl$VWAVH0HA3H;Q| H   LqM   HYH~ H9Cu HT$(DFHT$ Lt$ H        | HH   IE3LpHHHHx H  Hm Hu
HUHR0H+u
HSHR0HEH;\~ H|$PuA   HT$P=  H;~ uHA@tC    HHH\$XHl$`H0A^_^Ht$WH HA3H;	z HtVH;5{ u+H;QDƋAHDtJHDH Ht$8H _HHhHt.HAHt%HHt$8H _HH;W΋HuHHH\$0| HHtHH_y H+Hu
HSHR0HH\$0Ht$8H _HGHt$8HH H _@SH HHu3H [H|$0x H+Hu
HSHR0HH|$0H [EH;uH{ H H{ HAH;y uCLAIHH3H+HMtQ3ҋIEA;tHy H Hy H;y uAfAnf.zuzA   H%y H\$Ht$WH H:x 3HH΋H9CH9G5  C u
Hz xG u Hz yH\$8Ht$@H _LSL;WV  HCHOH;tHt
H9  DC AD_ A;  Hl$0H   jA tA@DDELLKHA t
A@HEHHWHHl$0u
ADu
ADADA;   Iu3H\$8Ht$@H _DIM @ƋH\$8Ht$@H _Lx I;uUI;@ƅuJA   HHw HHHoH+u
HSHR0H\$8Ht$@H _H\$8   Ht$@H _HT$SH 3LD$8E3HD$8HT$HHD$HHtw t/HD$8HH      tJE3LD$8HT$HHEw uLL$8MtLH
hx L H H	w 3H [H
Bx L H H	v 3H [ø   H [H\$Hl$Ht$ WH H3H
0w IHL;u3H;Lt$0HMHDߋ      Ht:H   MtHnx I9@tH
w H H	v h  HHHHx Ht(x HH`H;tHHp`Ht
H)uHAP0H  H/  HGHP0           @   Ht`LsA      @t*L;tHIu t   IMMHC      tHHӹ   v 3u HHtuE3HHw H+Hu
HSHR0HtNLOHA      @H
Hv H9 LH	t H H
"v H	)u Lt$0H\$8Hl$@Ht$HH _LI[MCUVWAVAWH03MCICMICMKICHH$   HL4ISut   @ f     IILL$pHtfHL9t^HAHHuIAI      3  H$  fff     HH	I;   Hy( t1A `<`u!HyFH9 tHD$hH+HI   Hy@%u HLL$pH8G `<`uHH@Iy( uIt LL$pAA `<`uIAIA@H;u-HIH	u yt H  LL$pt>HH; *I;  HHI;'  Hy( tbA `<`uRHYwHD$hHH+HIH; tLL$hHLD$pHT$ r q3H\$`H0A_A^_^]HY@%s HLL$pHC `<`uH[H[@Iy( uIs LL$pAA @t
 tIAIA@H;u)HIH	t ؅yps HuqLL$pt@HI;H& H
Ws L$   H	r H\$`H0A_A^_^]H+ H
"s H L$   H	q H\$`H0A_A^_^]LLH
r H H	H%q HHLT$pH8 M;LT$0MLH
r MML
 IML
- Hw H	LDIH~ HDH7 HD$(L\$ q HHH\$Hl$Ht$H|$ ATAVAWH Hs HL`PLpXLx`3HEPHEXHE`MtI$MtIMtIMMIH      s Hr HMPHHuXH}`LePLuXL}`Ht
H)uHQR0HtH.u
HFHP0HtH/u
HGHP0HuH
p Up HJp H+u
HCHP0H\$@Hl$HHt$PH|$XH A_A^A\HAPHHAXI HA`I3HAPHAXHA`H\$WH LQPHyXHY`HQPLAXLI`MtI*u
IBIP0HtH/u
HGHP0HtH+u
HCHP0H\$0H _H(Ht2H)uHAP0H
o H A   H	n H(H(   H\$UH q HHXPH   H
Qm LI;tCHK    }      @t3HIHq uH\$@H ]3Ht$0HuXH|$8H}`HE`HEPHEXH+u
HCHP0HtH.u
HFHP0Ht$0HtH/u
HGHP0H|$83H\$@H ]HH(t LL
'{ H
m H LDH	H%m H
m H* A   H	H%zm @SH HSl 3H9ADDAH9BAEt]LAL;Bt3H [B 8A uIu	AH [LIHBL;tItHuH H | ËH [Lbm I;AuI;AuA   l HHu	H [HH|$00H+u
HSHR0H|$0H [@SH Im Hu~m Ht3H [HH H [@SH HHH
 j Ht	H H [HH [  HH;}HH33H%l LL$8E3HMtIH%j HAH;
n u
E33  H;Zn uHA@t3   H E3  HT$H(HAH;m uA   HT$8  H(H;m uHA@t
   H(   H(H\$Ht$WH HH   Hk HHuH\$0Ht$8H _HE3HHxH#  H+Hu
HSHR0H\$0HHt$8H _H\$Ht$WH HAH@ Hpt3HY
m @ H Hl ;~#H
 k t3H\$0Ht$8H _HHH
l H؋   ~z<Rl H 9x }
l @$ Hu"j HuH
k H H	i Ht$8HH\$0H _H\$Hl$Ht$WH HAIHHH   Huk    
l @ H Hk ;~H
B j t3lLHHH
k H   ~ZRk H 9X }
k @$ Hu"i HuH
j H H	h HH\$0Hl$8Ht$@H _H\$Hl$Ht$WAVAWH`HyLLqHHY Ic%k @ DH Hk D;~H
; i t3    uL CuFHu9wuLMIH   |u%Ht LCHcGI;uHSMH   UfHU0E3LE(Ht
HKHCIIHT$PILD$HE3L$@HHD$8DL$0LL$(Mωt$ g HHCj    ~YI0j H 9X }
"j @$ HL\$`I[ Ik(Is0IA_A^_H\$Hl$Ht$H|$ AVH IIHHi E3LHHLOi HHt\H~.Hx  fff     HHIH[H HCHAHu3Hh AF HH/u
HWHR0AN HH\$0Hl$8Ht$@H|$HH A^LHv H
g H	H%=f HB      tHAL   MtIH%f H\$WH HH
4 HHAL   MtAvf HHuH
/g H LH	e HH\$0H _H\$Ht$WH 3舦y'Hm H |     _  [  3e H Hu'Hl H A     _     3H
Sk kc H Hu'Hl H     I _    3H
k g H Hu'HFl H?      _    艦y'Hl H      _  l    H
= tc HU HuMHk H H     _  @e H  H
e H H	@d m  Hrc H Hu'Hok Hh     0 _    HP H
1 H b H Hu'H%k H      _  {  H
 xb H Hu'Hj H \     _  ;  Ln H H
( d y'Hj H     ` _      y'Hoj Hh     0 _    95 tFLP HI H
 c y'H!j H      _  w  a HHu'Hi H c     `  B  H H` HuBL( H Hpb y'Hi H     V `    h  y'Hei H^     & 	`      y'H5i H.      `    HFZ H}` y'Hh H q E    `  P  H
K H LH52Z b y'Hh H ( E   r `    H HKR H_ y'Hoh Hh    0 `    H
 H LH57R a y'H&h H     `  |  Ho HPW Hg_ y'Hg H [ f    `  :  HE HJ HH5<W _ y'Hg H  i   \ `  
  H H5S HH5J ^ y'HRg HK     `  
  H H|T HH5S ^ y'H	g H     !`  _
  A`  H5lT H H^ H
 JH Hu'Hf H & 	   p +`  
  A`   Hw H
gx H Hu'Hkf H\     $ ,`    AH
  Hf H
x 貝H Hu'Hf H      -`  m  A0  H* H
x fH Hu'He H B     .`  !  AP   Hι H
k} H Hu'He Hx     @ /`    A   HF~ H
7 ΜH Hu'H;e H,  u   0`    y'He H z     5`  Y  g  u'Hd H I #    ?`  (  H
 3HHu'Hd H  &   V H`  
  H LH
l [ y &   " J`  
  H+u
HCHP0H
 3{HHu'Hd H
  '    T`  j
  HU LH
 [ yW '    V`  
  H+u
HCHP0H
	 3HHu'Hc H 
 (   T ``  	  H LH
j Z y (     b`  	  H+u
HCHP0H
X 3yHHu'Hc H  *    l`  h	  H LH
 Z yU *    n`  	  H+u
HCHP0H
 3HHu'Hb H  ,   R x`    H LH
h Y y ,    z`    H+u
HCHP0H
 3wHHu'Hb H	  -    `  f  H1 LH
 Y yS -    `    H+u
HCHP0   9Y HHu'Ha H 	 .   S `    H HH HKH HH H HKH HAH
g HHu'H
#a H
  .    `  T  H+u
HCHP0H HHHu'H` H L .    `    HV LH
 W y .   b `    H+u
HCHP0H H:HHu'HS` HL  .    `    H LH
* TW y .    `  B  H+u
HCHP0H/u
HGHP0   lW HHu'H_ H < /    `    H HH HOH HH H HOHu HAH H HOH HAH H HOH HAH H HOH HA H
 rHHu'H_ H  /    `  L  H/u
HGHP0H H褾HHuB /    `    H LH
 U y /   X `    H/u
HGHP0H` H0HHu /    `  z  H0 LH
. XU y /    `  F  H/u
HGHP0H4 H輽HHuZ /    `    H LH
 T y& /   p `    H/u
HGHP0H HHHHu /   0 `    H LH
F pT y 0    `  ^  H/u
HGHP0H\ HԼHHur /    `    H, LH
 S y> 0    `    H/u
HGHP0H+u
HCHP0H
 HHu'Hl\ He  2   - `    H@HH L   MtA7U HHu 2    `  I  H+u
HCHP0H E3HHHu'H[ H L 2    `    H/u
HGHP0H6 LH
 HR y 2   O `    H+u
HCHP0L H
P+ 3 U HHu'H9[ H2  o   `    H LH
 :R y| o   `  (  H+u
HCHP0L H
I 3wT HHu'HZ H ' r  q `    H LH
 Q y r  = `     H+u
HCHP0vQ HHu'H7Z H0      a     L HH> 8Q y a  )Hq LH
 Q     a  E    HY H H+u
HCHP0HtH/u
HGHP0H
 HH95{ tD H
+ 3tH
 H)uHQR0H5 HH\$0Ht$8H _H+u
HCHP0H H\$0Ht$8H _H(跏y w_  .  < Q H? Hu x_     eQ H Huk y_     : <Q H HuB z_     Q Q H< Hu {_      P H Hu |_  d3ZQ H Hu }_  D   7Q H0 Hu ~_  !   Q H] Hu* _  HW H     H(3H(H   H    ?Q H Hu |   a^     H    Q Hy Hu ~   l^    H    P Hr Huc    w^    H    P H Hu,   v ^  [  H    cP H Hu   ? ^  $  H    ,P H- Hu 3   ^    H    O Hf Hu 5   ^    H
N LHeM H HuO f   ^  ~  H
N LH-M H Hu f  a ^  F  H    NO H_ Hu p  * ^    H    L
 L? H HD$(H HD$ N H* Hu y   ^    H    N HC HuL 3   ^  {  H    N H Hu 5  _ ^  D  HO    LN Hm Hu C  ( ^  
  H    N H Hu-H*T H      ^  HĘ   H    M H Hu-HS H N     ^  HĘ   H    M H Hu-HS H    M 	_  HĘ   H    4M HM Hu-HIS H:  7   _  HĘ   H,    L H Hu-HR H m ;   _  HĘ   H1    L H Hu-HR H " O  l *_  HĘ   H~    SL H< Hu-HhR HY    ! 5_  HĘ   H    L H! Hu-HR H     @_  HĘ   H    K H Hu-HQ H A    I_  HĘ   H    rK H Hu 2   N T_  3  HV    ;K HD HHu o   __    H E3H HT$pD$ho  HD$`HI HD$XH HD$PHD$HHL$@   HD$8DHD$0HT$(3D$    H H Hu9 o   b_  h  H    L
 L HI H$   H HD$xHV HD$pH HD$hH6 HD$`HZ HD$XH HD$PH HD$HH^ HD$@HR HD$8H HD$0H HD$(H HD$ I H HHu k_     HF E3H HT$pD$hr  HD$`EAH HD$XH HD$PHD$HHL$@HD$8HD$0HT$(3D$    JF H{ Hu-  n_   r  H3O H, HĘ   3HĘ   H(H
 `H Hu*HN H \     I^  H(H
{ H? Hu*HN H  |  d J^  H(H
 H} Hu*HaN HZ  W  " K^  H(H
 H Hu*HN H  _   L^  H(H
 XH9 Hu*HM H T =   M^  H(H
 H Hu     j N^  ZH
 Hi Hu 7  < O^  ,H
G H Hu*    P^  H3M H$ H(3H(H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HE HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
μ Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
\ t=H3 Hc
> H3HHCHCLCH   xB HH [3IA0  HHuH [@SH HCD HHIHCH1D H Ht
H)uHAP0HD HKHCHD H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH HC HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH H
 H\$0H _HH\$0H _H@  @SH 3LHy  
H t=H Hc
* H3HHCHCLCH   h@ HH [3IA0  HHuH [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H-B HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
z Hz  @ǅtH  H
T H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
 H3HHCHCLCH   > HH [3IA0  HHuH [@SH H@ HHIHCH@ H Ht
H)uHAP0He@ HKHCHV@ H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H\$WH H@ HK3HtH{H)uHAP0HKHtH{H)uHAP0HSHc
 Hz  @ǅtH  H
ص H\$0H _HH\$0H _H@  @SH 3LHy  
 t=H Hc
n H3HHCHCLCH   < HH [3IA0  HHuH [H\$WH HHHt%HHIhH)uHAP0H{h3H\$0H _HO> H HIhH)uHAP0H4> HCh3H\$0H _HAhH HAhH\$WH HHHt%HHI`H)uHAP0H{`3H\$0H _H= H HI`H)uHAP0H= HC`3H\$0H _HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _H= H HIXH)uHAP0H< HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _Ho< H HIPH)uHAP0HT< HCP3H\$0H _HAPH HAPH\$WH HHHt%HHIHH)uHAP0H{H3H\$0H _H; H HIHH)uHAP0H; HCH3H\$0H _HAHH HAHH\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _H/; H HI@H)uHAP0H; HC@3H\$0H _HA@H HA@H\$WH HHHt%HHI8H)uHAP0H{83H\$0H _H: H HI8H)uHAP0Ht: HC83H\$0H _HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H9 H HI0H)uHAP0H9 HC03H\$0H _HA0H HA0@SH HHt
H [O  Hq9 H HI(H)uHAP0HV9 HC(3H [HA(H HA(H\$WH HHHt%HHI H)uHAP0H{ 3H\$0H _H8 H HI H)uHAP0H8 HC 3H\$0H _HA H HA H\$WH HHHt%HHIH)uHAP0H{3H\$0H _H?8 H HIH)uHAP0H$8 HC3H\$0H _HAH HAy  H\$WH HHZ8 HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH HS7 HHIHCHA7 H Ht
H)uHAP0H%7 HK HC H7 H Ht
H)uHAP0H6 HK(HC(H6 H Ht
H)uHAP0H6 HK0HC0H6 H Ht
H)uHAP0H6 HK8HC8H6 H Ht
H)uHAP0Hy6 HK@HC@Hj6 H Ht
H)uHAP0HN6 HKHHCHH?6 H Ht
H)uHAP0H#6 HKPHCPH6 H Ht
H)uHAP0H5 HKXHCXH5 H Ht
H)uHAP0H5 HK`HC`H5 H Ht
H)uHAP0H5 HKhHChH5 H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht
Hօ   HK8Ht	HօunHK@Ht	Hօu\HKHHt	HօuJHKPHt	Hօu8HKXHt	Hօu&HK`Ht	HօuHKhHt	Hօu3H\$0Ht$8H _@SH HAH   tH   tAul2   HH|$H~4 LD$0HT$8HL$@2 HH{HtHE  H^LD$0HT$8HL$@H2 HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK(HtH{(H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKHHtH{HH)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HKhHtH{hH)uHAP0HCH@  H|$HH [H\$Ht$WH       IHu
30  H4 E3Ht 8  HH	  H;2 LHCHH*2 HH H2 HC H2 H H2 HC(H1 H H1 HC0H1 H H1 HC8H1 H H1 HC@H1 H H1 HCHH1 H H1 HCPH1 H H1 HCXH1 H Hu1 HC`Hj1 H H`1 HChHU1 H =l y"H+u
HCHP03H\$0Ht$8H _Ht$8HH\$0H _@SH HHt
H [= H0 H HI`H)uHAP0H0 HC`3H [HA`H HA`H\$WH HHHt%HHIXH)uHAP0H{X3H\$0H _HO0 H HIXH)uHAP0H40 HCX3H\$0H _HAXH HAXH\$WH HHHt%HHIPH)uHAP0H{P3H\$0H _H/ H HIPH)uHAP0H/ HCP3H\$0H _HAPH HAPH(Ht	H(? H
. Hp H	. H(H(AH. Hu;H
6 H  X   Υ     H
>V AX   3H(H\$WH HHHt%HHI@H)uHAP0H{@3H\$0H _Ho. H HI@H)uHAP0HT. HC@3H\$0H _HA@H HA@@SH HHt
H [A H- H HI8H)uHAP0H- HC83H [HA8H HA8H\$WH HHHt%HHI0H)uHAP0H{03H\$0H _H_- H HI0H)uHAP0HD- HC03H\$0H _HA0H HA0H(Ht	H(B H
w, H H	, H(H(A(, Hu;H3 H 4 T   ~ z  z  H
R AT   裍3H(@SH HHt
H [XD HA, H HI H)uHAP0H&, HC 3H [HA H HA @SH HHt
H [xE H+ H HIH)uHAP0H+ HC3H [HAH HAH(Ht	H(F H
* H H	+ H(F H(Ht	H(.G H
* H~ H	* H(H(IL$0G+ Hu;H1 H b P    
  
  H
,M AP   ы3H(H\$WH HH+ HHuH\$0H _HGHHL@pAPH+Hu
HSHR0HH\$0H _@SH H* HHIHCH* H Ht
H)uHAP0H) HK HC H) H Ht
H)uHAP0H) HK0HC0H) H Ht
H)uHAP0H) HK8HC8H) H Ht
H)uHAP0Hd) HK@HC@HU) H Ht
H)uHAP0H9) HKPHCPH*) H Ht
H)uHAP0H) HKXHCXH( H Ht
H)uHAP0H( HK`HC`H( H Ht
H)uHAP03H [H\$Ht$WH HIHIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH HAH   tH   tAu% @  HH|$H' LD$0HT$8HL$@q& HH{hHtH  HpRLD$0HT$8HL$@Hp& HK3HtH{H)uHAP0HK HtH{ H)uHAP0HK0HtH{0H)uHAP0HK8HtH{8H)uHAP0HK@HtH{@H)uHAP0HKPHtH{PH)uHAP0HKXHtH{XH)uHAP0HK`HtH{`H)uHAP0HCH@  H|$HH [H(      u
30  H( E3HU 8  HHuH(H& HAH& H H& HA H% H H% HA0H% H H% HA8H% H H% HA@H% H H% HAPH% H H% HAXH% H H% HA`H}% H HH(H\$Hl$Ht$WAVAWH L3# HHu'HV, H?  =    `X     IOH*I+    HHHHH?HtaE3II   HHtsHOH9O ~H HGHHAHGHH# u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_O gX  
C eX  Hp+ HY ע =   H/u
HGHP0HtH+u
HSHR0D H
x  )3tH\$Hl$VWAVH L3s" HHu'H* Hš C =    ,X     In3I+.HHtafIL$H" HHtiHGH9G ~HHOHHHHOHH! u.H+u
HCHP0HH;rHH\$@Hl$PH A^_^ 3X  
 1X  H* H } =   H/u
HGHP0HtH+u
HSHR0DQ H
t  σ3zHHHUATAUAVAWHH   HEHXHpHx HL3ɉMWEHMDI$IL$IL$E   EHMHBH?H;5  tgH;d! t^IH! HHu/H) H A/   Dz W  Ø H]_  H@L   MuSW    HLL Mu8H H9GuL;w1  HGJL;w  J\HIHAHHG  ILHt
H)uHQR0HHM]  HHEH;t?HUHtLEL+IJHH]HFHEHFHE3HHFHFH]HMH?HtIHEH+HH;   H    H=   r u}HAH;smH+Hr]H'wPHK$! Hu`HUHM
HHMMHUHLEL+II\ U N G @ A0   W  f  H   H
 LI;   HH    }      @t3HwIH! uZW  A/   H]H& H D/ } HtH/uHGHP0D
 [ H
s 苀& H/u
HGHP0HUIH]MtIm uIEIP0HtlHEH+HH;v) H    H=   r<t
 HCH;r H+Hs H'v HHIH]H   HUH2HMH+H*HHHH?HH
H;v HRHH=   r<tg HCH;rW H+HsG H'v: HHIIL$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H; toH; tfIH LHu/Hf$ HO A/   Dʛ KW   Hu  H@H   HEPHuMW  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H{EHu	 HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHM{L}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHM
{L}H]HuHt;HH]HEP7A0   xW  H}@H?   H
I  H
I  ~ H   H
 LI;   HH    }      @t3HWrIH udhW  H}@H?A/   H! Hv D E MtI.uIFIP0D՘ # H
hn S{8 I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hs H'v HHeDHH$   HPA_A^A]A\_^]@UVWATAUAVAWHl$H   HEH$   HI H3HEHHHMHM3ɉMWEDHMDHHOHOE   HE   HMMHBH; twH; tnIHY HHu3H H A/   D V  g H]L}9  H@H   HEHuV  H]L}  HLHHMH]L}Hu8H? H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHAP0HHM  HHEH;toHEHrDHHMH=   r0n  HAH;Z  H+HF  H'5  H_BHE   HE    E HHMbHEHrDHHMH=   r0  HAH;  H+H  H'  HA H  HE   3H}@}IE3HUHM]HEH;   HEL;   H}I+I;uoIH+HHs_I+HHHH+Hi  HM+IIHH+I3I;HCH;HCHHMQLuH]L}HIH   3HC   HCH{rHHH   I;upIH+HHs`I+HHHH+H   HM+IIHH+IHI;HCH;HCHHM规LuH]L}Ht*HC   H{H{rHHHU  H`H H]HMHET M F ? 8 1 * # H
C  H
C  A0   	W  H}co HH   H L I;   HA    }      @t	3Hl	I uZV  H}A/   H Ht D C HtH.uHFHP0DӒ ! H
g Qu2 H.u
HFHP0HUH}HiLuH]L}MtIm uIEIP0HM=MtHIlM+IMIKHHMH3+7H$   Hİ   A_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
K H;E  H; 8  H HHub     V    H@L   HEo    HAHHt[HEo   HAHHtEHAH΢yH
 H
t F V  UH+9  HCHP0*  H+u
HCHP03Тu	HMo賣H4 H  V      HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   Ht H
 H	 2Mx-HA L
C ILDHo H
 H	 ޏ    ( pV    H;u
Hz HrHrH~H6HHE3LLHHMX  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+Id:V Ht V  eHHMQ  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+IJ Ht@, V  Ύ    HO H8 D  H
c 7q   HUHMHHUHMuHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+IIHUHtLEL+I9HUHtLEL+I8WELmHUHtLEL+IIMtI/u
IGIP0MtI.uIFIP0HUHtLEL+IAIHUHtLEL+Iw8IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBH?H;U toH;
 tfIH
 LHu/H6 H A/   D U   Hu  H@H   HEPHuU  Hu  HLHHMPH]HuHu8H I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0HlEHu
 HB  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HH?HH+H  LCL+IIHH+I3I;HCI;LCIHMjlL}H]HuHtHH]HEPI;upIH+HHs`H+HH?HH+H   LCL+IIHH+I3I;HCI;LCIHMkL}H]HuHt;HH]HEP7A0   V  H}@H?   H
:  H
:  N H   H
	 LI;   HH    }      @t3H'cIH
 udV  H}@H?A/   H] HF Dǉ  MtI.uIFIP0D  H
] #l8k	 I.u
IFIP0HUH}@HL}HuH?MtIm uIEIP0HthL+IL;v J    H=   r=@t HFH;r H+Hsv H'vi HH55HH$   HPA_A^A]A\_^]HL$UVWATAUAVAWHl$H   HEH$  LE3DmEEL)LiLiLiLi Li(E   AWELmELmHBH
 H;E  H; 8  H,	 HHu    L U    H@L   HEo    HAHHt[HEo   HAHHtEHAHnyH
+ H
  U  UH+9  HCHP0*  H+u
HCHP03pu	HMoSH H  U  1    HtH.u
HFHP0HtH/u
HGHP0H  H+  HCHP0  LBItl~A   HDk H
 H	 2Mx-H
 L
 ILDHf H
 H	` ~    ~ U    H;u
Hz HrHrH~H6HHE3LLHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+IA Ht3~ U  eHHM  HMH;t"HHMHHHMHHHML(LhLhHUHtLEL+IMA Ht@} U  n    H
 H؄ DY } H
Y g   HUHMUHHUHMEHHMHHHMHHHML(LhLhHHEHCHEHCHEL+LkLkHUIHUHtLEL+I|@HUHtLEL+Ic@HUHtLEL+IJ@WELmHUHtLEL+I%@MtI/u
IGIP0MtI.uIFIP0HUHtLEL+I?HUHtLEL+I?IH$  H   A_A^A]A\_^]HL$UVWATAUAVAWHHPHEH$   LH3ɉMWEDHMDHHOHOE   HBHH; toH;$ tfIHu LHu/H H A/   D: U  { Hu  H@H   HEPHu
U  Hu  HLHHMPH]HuHu8Hc I9FuM;f  IFJ<M;f  K|HIIHH  ILHt
H)uHQR0H1]HHEHHuv HE  HEHH;   HEHH;   H}HH+HI;upIH+HHs`H+HHHH+H  LCL+IIHH+I3I;HCI;LCIHMeL}H]HuHtHHHH]HEPI;upIH+HHs`H+HHHH+H   LCL+IIHH+I3I;HCI;LCIHMEeL}H]HuHtH;HH]HEP1A0   5U  H}@H   H
K1 - H
=1   H   H
X  LI;   HH    }      @t3HYIH ud%U  H}@HA/   H H Da x MtI.uIFIP0D? x H
*S b8  I.u
IFIP0HUH}@HL}HuHMtIm uIEIP0HthL+IL;vM J    H=   r=@t0 HFH;r  H+Hs H'v HH+HH$   HPA_A^A]A\_^]HHHUVWATAUAVAWHHpHEHX )p)xHH3ɉMWEDHMDHHOHOE   HBHH;O toH;~ tfIH HHu/H0 H~ A/   D~ T  v Lu  H@H   HEPHuT  Lu  HLHHMP=9 H]LuHu8H H9FuL;f  HFJ<L;f  J|HIHHH  ILHt
H)uHQR0H{ H9GuwuHH8 (EHf.zu HF  HEHH;   HEHL;   H}HI+HI;upIH+HHs`I+HHHH+H	  LCM+IIHH+I3I;HCI;LCIHMaL}H]LuHtIHHH]HEPI;upIH+HHs`I+HHHH+H   LCM+IIHH+I3I;HCI;LCIHMy`L}H]LuHt3HH]HEPA0   T  H}@H   H
~, ` H
p, R  H   H
 LI;   HH    }      @t3HTIHN udT  H}@HA/   H* H{ D{ s HtH.uHFHP0Dr{ s H
M ]88 H.u
HFHP0HUH}@H L}LuHMtIm uIEIP0MthM+IL;v J    H=   r=Atc IFI;rS L+IsC I'v6 LI'HH$   (t$`(|$PHpA_A^A]A\_^]LWHpICI[Is H H3HD$hHHIK3t$ HA   HqHyrHH@0D$    HJH( H;t- u#LD$(HT$0HN x,HT$0LD$(LGLD$(MtHW(H Hu>H7 H y y    q \T  \T  A   H
M 
\   HD$`   Ht$XD$H HL$H{@HT$HHHD$`HrQHHL$HH=   r<t HAH;r H+Hs H'v HR%HHL$hH3L\$pI[ Is(I_H\$Hl$Ht$WAVAWH L3 HHu'H Hw }x =   p #T     IOH*I+    HHHHH?HtaE3IId  HHtsHOH9O ~H HGHHAHGHH u8H+u
HCHP0HIH;rHH\$@Hl$HHt$PH A_A^_p *T  
p (T  H0  Hw w =   H/u
HGHP0HtH+u
HSHR0Dkw H
DK o Y3tH(HyHQrH	p Hu;H Hv w 2   Uo S  S  H
I A2   zY3H(H\$Hl$Ht$H|$ AVH L3 HHu'H$ H
v v =   n R     In3I+.HHtgff     I HHtqHGH9G ~HHOHHHHOHH u6H+u
HCHP0HH;rHH\$0Hl$8Ht$@H|$HH A^/n S  
#n S  HP H9u u =   H/u
HGHP0HtH+u
HSHR0Du H
G m 	X3r@SUVWAUAVAWH 3H\$`H\$hH\$p LLxhLppHhxMtIMtIHtHE 9   Hy Hjt t   2m Q  Ho IMPL I;tUH  I@      t
I`*HA9   }      @t	3M	I    Dot H
0A l VLL$pILD$hHT$`6^y8t   l Q  [Hmt E3H
;w vHHuXl Q  'E33H~H+u
HCHP0/l Q  s   HJ H\$`Ht$hH|$pH,s LMII`HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D]s H
~A k UH A_A^A]_^][MtI/u
IGIP0MtI.u
IFIP0HtHm u
HEHP0H A_A^A]_^][@SH H3 HH HIhH)uHAP0H HCh3H [@SH H HH HIhH)uHAP0H HCh3H [H\$WH HHHIhHH)uHAP0H_h3H\$0H _H\$WH HHHIhHH)uHAP0H_h3H\$0H _HAhH HAhHAhH HAh@SH H HH HI`H)uHAP0H HC`3H [@SH H HH HI`H)uHAP0H HC`3H [H\$WH HHHI`HH)uHAP0H_`3H\$0H _H\$WH HHHI`HH)uHAP0H_`3H\$0H _HA`H HA`HA`H HA`@SH H HH HIXH)uHAP0H HCX3H [@SH Hs HH HIXH)uHAP0HU HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH Hs HH HIPH)uHAP0HU HCP3H [@SH H3 HH HIPH)uHAP0H HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH H3 HH HIHH)uHAP0H HCH3H [@SH H HH HIHH)uHAP0H HCH3H [H\$WH HHHIHHH)uHAP0H_H3H\$0H _H\$WH HHHIHHH)uHAP0H_H3H\$0H _HAHH HAHHAHH HAH@SH H HH HI@H)uHAP0H HC@3H [@SH H HH HI@H)uHAP0H HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H HH HI8H)uHAP0H HC83H [@SH Hs HH HI8H)uHAP0HU HC83H [H\$WH HHHI8HH)uHAP0H_83H\$0H _H\$WH HHHI8HH)uHAP0H_83H\$0H _HA8H HA8HA8H HA8@SH Hs HH HI0H)uHAP0HU HC03H [@SH H3 HH HI0H)uHAP0H HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH H3 HH HI(H)uHAP0H HC(3H [@SH H HH HI(H)uHAP0H HC(3H [H\$WH LJHL;
 HtrH; tiH
K L`, MIH8 H	 H Hg  h   J` E  E  H
*8 A  oJH\$0H _HHI(H)uHAP0H_(3H\$0H _;HA(H HA(HA(H HA(@SH H HH HI H)uHAP0H HC 3H [@SH Hc HH HI H)uHAP0HE HC 3H [H\$WH HHHI HH)uHAP0H_ 3H\$0H _H\$WH HHHI HH)uHAP0H_ 3H\$0H _HA H HA HA H HA @SH Hc HH HIH)uHAP0HE HC3H [@SH H# HH HIH)uHAP0H HC3H [H\$WH HHHIHH)uHAP0H_3H\$0H _H\$WH HHHIHH)uHAP0H_3H\$0H _HAH HAHAH HA@SVWAVAWH@HU H3HD$8H=Nd LLHH
c 33 HHtH H_HH$   HHu\ fD    H 3H9Au%HYHtHyHHH)uHAP0   Hz H9GufIGHT$(HD$(DEHHH+H\$ Lt$0?|HHu1\ wD     H  H+  HCHP0   M HHuH
 H
c [ D  VHtHX3IGE3HH IGHDEIHLtzHHu~[ D  H Hb +c l  HtH/u
HGHP0HtH+u
HCHP0HtH.u
HVHR0Db H
n2 ,[ cE3#H.u
HVHR0H/u
HWHR0HH$   HL$8H3H@A_A^_^[H\$WH0L
 E3H; HHRHA3I;At   KMuH
 HH H	O +HBL" H
+ HH MIHD$ H	 3u/H
e H
^a a k  &Z JD  3H\$@H0_HHH\$@H0_HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI膸HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHULEHUL+I;3 HHu'H, H%` ` h  X D  -  IM;<       HEH;tIE3HHM(H IE3HUHM(HE   H}E IE3HUHMx(H HD$(HM3 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pX D  
W D  H _ h  H_ H.u
HFHP0HtH/u
HGHP03D`_ W H
s. ALHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hsy H'vl H;HE   H}E HE'HrPHHMH=   r<t/ HAH;r H+Hs H'v H
HE'   H}E MtzIIaM+IHL;v II   r=At IFI;r L+Is I'vv LIB
IHM/H3L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI&HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUߕLEHUL+I+3 HHu'H H\ \ c  T C  -  IM;<       HEH;tIE3HHM$H IE3HUHM$HE   H}E IE3HUHMh$H	 HD$(HM#
 HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pS C  
S C  H [ c  HZ H.u
HFHP0HtH/u
HGHP03DP[ S H
) =LHH.uHFHP0HEHrPHHMH=   r<t HAH;ry H+Hsi H'v\ H+HE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HHE'   H}E MtzIIQM+IHL;v II   r=At IFI;r L+Iss I'vf LI2IHM/H3L$   I[8Is@I{HIA_A^A]A\]HWHpH@HXHpW@3HX@HXHPHItHL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`HL$hH+L$XHHHLI?LHT$XOHT$(HL$@HL$@趴Hu;H" HX X _  P `C  `C  A_  H
& ;HH|$@Ht2HT$HH\HL$PH+HHHLI?LH H|$(Ht1HT$0H HL$8H+HHHLI?LH| HL\$pI[IsI_[HWHpH@HXHpW@3HX@HXHPHIHL$(H;t%HHL$(HHHL$0HHHL$8HHXHXH*HL$XHt2HT$`GHL$hH+L$XHHHLI?LHT$XHT$(HL$@@HL$@Hu;Hr HkV V Z  3O C  C  AZ  H
$ X9HH|$@Ht2HT$HH謍HL$PH+HHHLI?LHH|$(Ht1HT$0HpHL$8H+HHHLI?LHHL\$pI[IsI_[HUATAUAVAWHhH   HEHXHpHx H H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHI6HMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUoLEHUL+I3S HHu'H HT #U T  mM B  -  IM;<       HEH;tIE3HHM4H IE3HUHMHE   H}E IE3HUHMH HD$(HM HHt[HNH9N ~H HFH<HAHFHH8 u H/u
HGHP0I;ܿ    >pL B  
zL B  H T T  HS H.u
HFHP0HtH/u
HGHP03DS .L H
#! ^6LHH.uHFHP0HEHrPHHMH=   r<t HAH;r	 H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'v HQHE'   H}E MtzIIM+IHL;v= II   r=At# IFI;r L+Is I'v LIIHM/H3CL$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx Hv H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIvHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHU_LEHUL+I
3C HHu'H HP Q O  ]I FB  -  IM;<       HEH;tIE3HHM$H IE3HUHMHE   H}E IE3HUHMH HD$(HM HHt[HNH9N ~H HFH<HAHFHH( u H/u
HGHP0I;ܿ    >pvH PB  
jH NB  H P O  HvO H.u
HFHP0HtH/u
HGHP03DO H H
 N2LHH.uHFHP0HEHrPHHMH=   r<t	 HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hs H'vr HAHE'   H}E MtzIIчM+IHL;v- II   r=At IFI;r L+Is I'v LIIHM/H33L$   I[8Is@I{HIA_A^A]A\]HUATAUAVAWHhH   HEHXHpHx Hf H3HE/WE3DH}DHE'   H}DmHE   H}@}HUHIFHMH;t$L0LuL`LeLxL}H8HxHxLeLuHMHtHUOLEHUL+I33 HHu'H HL M J  ME A  -  IM;<       HEH;tIE3HHMH IE3HUHMHE   H}E IE3HUHMHy HD$(HM HHt[HNH9N ~H HFH<HAHFHH u H/u
HGHP0I;ܿ    >pfD A  
ZD A  Hw K J  HfK H.u
HFHP0HtH/u
HGHP03DK D H
 >.LHH.uHFHP0HEHrPHHMH=   r<t HAH;r H+Hs H'v HHE   H}E HE'HrPHHMH=   r<t HAH;r H+Hso H'vb H1HE'   H}E MtzIIM+IHL;v II   r=At IFI;r L+Is I'v LIIHM/H3#L$   I[8Is@I{HIA_A^A]A\]HL$UVWATAUAVAWHH   HEH$   HE3ELeWELeLeXAAELe3 LHuI C  A CA  c  HFH; tLH; tCIHf HHuA IA    H@L   MuUqA KA    HMMMu8H H9FuL;v  HFJL;v  J\HIHAHH   HMXH]XHt
H)uHQR0HCL   HI HMtA	 HH   E3HG H_HHtgH+u
HSHR0IIOI9O ~HIGH<HAIGHI uH/ HGHP0J@ sA  |>@ pA  p2@ nA  a H   H
N LI;   HH    }      @t3H IH u}? fA  IH gG C  HF I/u
IGIP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0Lu   H.u
HFHP0MIHMHMH;t$HH]HHHMHHHML L`L`H]HMHtHULEHUL+I Ht$H HE iF D  > A  aHUHM HUHMHHM@HIȉMP HuAF F  b> A  H HxE H]DE C> H
 s(LH]MtI.u
IFIP0HMXHtH)uHAP0HHttHUH~HEH+HH;v HH=   r<t HCH;r H+Hs H'v HHH]HtsHUH&~HEH+HH;v HH=   r<tp HCH;r` H+HsP H'vC HHIH$   HĀ   A_A^A]A\_^]H\$Hl$Ht$H|$ AUAVAWH@HF LHIHE333EFJHHu'H HC D :  ^< 5@    3H;= 3H;= 3H;=D uH ؅yC :  < 7@  /  H/u
HGHP0  HB H L5B HD IIFL   MtA HHu'H HB EC =  ; L@  @  H L{I9l  HkH_  H{HHE HHH)uHAP0HH LI9   IE0HT$ A   HD$(HHl$ [HHuB =  : _@    Hm u
HEHP03H+u	IHP0    HH   ^B =  3: y@        HHu'H
 H
A "B =  l: m@    HhE3IE0HH3H IE0HF PYHHuA =  (: s@  :  H.7HFHP0(IU0H:WHHA =  9 Y@    H
F? E3HHxXHHu]A =  39 ~@    H+u
HCHP0E33H?KH/u
HGHP0H 3H@ A =  O9 @    HD A   IMHGHHu'HI HB@ @ >  
9 @    H؅y@ >  8 @    H/u
HGHP0   IM(L I;uEH
 L He H	 H H? ,@ >  v8 @  '  H.B THHu'Hz Hs? ? >  ;8 @    3H;
9 H(uH@P0  H@ H L5@ HA IIFL   MtA HHu'H H> k? @  7 @  f  H L{I9[  HsHN  H{HHHHH)uHAP0Ho LI9   IE0HT$0A   HD$8HHt$09WHHu+7 @  3  H.u
HFHP03H+u	IHP0    HH   > @  36 @  H H= H/   HGH       HHu6 @     HpE3IE0HH3H IE0HE {UHHu]6 @  hHm <HEHP0-IU0HqSHH6 @  *H
; E3HHxUHHuQ5 @  3= @  H H< HtH+u
HCHP0HtbHm u[HEHP0OH+u
HCHP0E33HMGH/u
HGHP0H H< = @  _5 @  HtH.u
HFHP0D< H
X 65 mMtI.u
IVIR03
H H H\$`Hl$hHt$pH|$xH@A_A^A]HUATAUAVAWHhH   HEHXHpHx H H3HE/HHMWEE3LeELeEAAELeELeHE'   LeDe3 LHu'H` HY; ; 3  !4 ?    Ls8IFH;9 t`H;h tWHI LHu; 3  3 ?  Z  H@L   Mu]f; 3  3 ?  1  IIܐMu8Hĺ I9FuI;^   IFH4I;^   ItHHIAHH   ILHt
H)uHQR0HFL   H/< HMtAL HH   E3H< HRHH   H.u
HVHR03IOI9O ~HIGH<HAIGHI5 u$H/HGHP0E3A   +: 3  u2 ?  E3  : 3  Y2 ?  E3  9 3  =2 ?  E3   HtfH
W LI;tQHH    }      @t3HIH u9 3  1 ?  E3M  P E3I.u
IFIP0ML}IHMjHMH;t$HH]HHHMHHHML L`L`H]HMHtHUrLEHUL+Ic Ht'HY HR8 8 4  1 ?     HUHR@HM耗HMH;t$H8H}HHHMHHHML L`L`H}HMHt5HUmoHMH+MH*HHLI?LHUC Ht'H H7 8 4  h0 ?  R  LEHUHM~b3 LHu'H_ HX7 7 5   0 ?    H]H;]  HEH;tIE3HHMH HMH}'HCMHUɶ HH   ILHt
H)uHQR0HGL   H: HMtA LH   E3H5 HzNHHtwI.u
IFIP0MIOI9O ~HIGH<HAIGHI uH/u
HGHP0H;]  6 5  . ?  u6 5  . ?  _. ?  FH H5 a6 2   . S  S  A2   H
 M. ?  )6 5  IH H5 I/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0HtH/u
HGHP0LuH]H}D5 . H
Y  4MLuH]H}MtI.u
IFIP0MtIm uIEIP0HE'HrPHHMH=   r<t˳ HAH;r H+Hs H'v HmHE'   LeE H   HUHkHMH+H*HHHH?HH
H;v9 HRHH=   r=@t HGH;r H+Hs H'v HHHt~HUHYmHEH+HHH;v HH=   r<t HCH;r H+Hsy H'vl HH8H]HtHUHlLEL+IHIHM/H3L$   I[8Is@I{HIA_A^A]A\]HA`H HA`HA`H HA`H(HI`H4 HAL   MtA~ Hu;Hb H[2 2 &  #+ ?  ?  H
 A&  H3H({HAPH HAPHAPH HAPH\$WH0HIX37HHu?H H
 A   H1 >  D2 Z* 3H\$@H0_Hu3 HL HHu\HM A   >  H;1 D1 
* H+uHCHP0D1 ) H
R 3H\$@H0_H+u
HSHR0HH\$@H0_HL$UVWATAUAVAWHl$H   HEH$   LWEE3L}L}L}L}L}]1HEL}L}L1HEAEL}wH=4 HH
=/ ' HHtH HKHHu0   ( =  =  HCL   H+ HMtA HHuJ0   ( =    H+u
HCHP0HFL   H2 HMtA HHu'Ho Hh/ /   0( =    H.u
HFHP0ILcHY I9$  HsH  H{HHHHH)uHAP0LgHҲ I9$uSHuLmA   HUHGHHuH/   ' =    H.u
HFHP0I      n LHu'H
 H
x. .   @' =    HpIIE Lh E3IH*FHHu.   ' =  e  I.u8IFIP0,IHDHHuz.   & =  '  H+u
I$HP0HGH H;   H;    HI HHus& =     H/u
HGHP0HFH   MHHMHtTA   HLHtAHH?y-   & =  k  L)&u
HFHP0I   H.u
HFHP0I?uIt@j-   % >    HOHtf~A   H H
3 H	
 
Hx&@p% =  H M-   Hy, H/  HGH  H;u
Lw H_H_LsHHIH/u
HGHP0H]LuHHM' HHEH;tJHUHRHM*HMHIHMH	HEH@L}HMHHEHHMHCHEHKH}HWHM*HEH@HEH HEH@L}H}HyIHM- HHEH;tJHUHRHM (HMHIHMH	HEH@L}HMHHEHHMHCHEHKLEMM HUHM   DBoHM~LMLEHUHMgHI%HHMYHUHtLEL+IH
. ?LHu'H H* $+   n# ,>    H@L   Hs* IMtAx HHu'HY HR* *   # .>    I.u
IFIP0HMسLHu" 1>  C  ILcH# I9$
  HsH   H{HHHHH)uHAP0LgH I9$uJHuLuA   HUHtBHHuf" E>     H.=  HFHP0.     A LHEwHu'H
N H
G) )   " U>     HpILp ME3IH@HHu! [>  8Im    IEI   IH>HH   ! >>  D)   H H( HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0HMwHt
H)uHAP0D( (! H
 X#I.u
IFIP0H+u
I$HP0LHMHt
H)uHAP0HMHtH)uHAP0LEMM HUwHM?   DBoHM=LEMM HUwHM   DBoHMHUHtLEL+IIH$   HĠ   A_A^A]A\_^]HSVWATAUAVAWH   H@HLW@E3LPD$XLt$hD$@Lt$PAAEL`LXH;Ĩ tJHtEH(HD$0H$   $u]H H& ''   q <    L$   L$   Ha H$   H$   L% L$   HH$   蒧HL$XH;t%HHL$XHHHL$`HHHL$hL0LpLpH$   HtL$   L+IB Ht'H H% _&    =    LD$XH$   IM{HL$@H;t%HHL$@HHHL$HHHHL$PL0LpLpH$   HtL$   L+IHT$@H$   觪L%) IH
F$ 0 HHtH I@HHu'H H
% %    =    HCL   H$ HMtAߦ HHu'H H$ 7%    =  ]  H+u
HCHP0H$   ;HHu'Ht Hm$ $   5 =  &  ILoHn I9E F  HwH9  LoHIE HIH)uHAP0IMH$h  Hާ H9urHt$pH\$xA   HT$pI<LHu'Hͬ H# D$    2=  j  H.u
HFHP0H+   HCH      \ LHu'H
m H
f# #   . B=  
  HpIHX E3II;LHu'H% H# #    H=     I/uUIGIIHH9LHu$Hܫ H" S#    +=  |H+uHCHP0P0L$h  H/u
IE HP0H$    \  H$   H
 H;IDH$   H$    +  E3AAAEHtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0MtI/u
IGIP0H=  HLxPL`XLh`LpPLpXLp`H$    t%H$   H;IDH$   H$   / HKPHsXH{`L{PLcXLk`Ht
H)uHAP0HtH.u
HFHP0HtH/u
HGHP0D!  H
W BMHT$@HtLD$PL+ITHT$XHtLD$hL+I8H$   HtL$   L+IIH   A_A^A]A\_^[H\$WH0LRHH HL;u   ^HuH
 H H	 >It   -H
 Ln IBLJH{ HD$ H	 3u/H
 H
       <  3H\$@H0_HHH\$@H0_HHHAUH   H E3HXHhAHxAL`LLpHAL$   L$   Ll$ L   L$   MtAi H$   HL|$xHu'H= H6     	;    HCL{H;6 I   HsH   LsHHIIH)uHAP0IFM~H; Ht$(uA   HT$(I7+H; uIF@t
HI5HI4LHu   E ;    H.u
HFHP0IH+u	IHP0I.u
IFIP0ID$IH L   MtsAtH; uE33H61H;3 uHC@t3H4H E3H5LHl;    ;     Hu'H H 	   S &;    L53! H
l IH$   K HHtH I8HHu 	   2;  f  HCHHG L   MtA HHun 	   4;     H+u
HCHP03W HHu'H H ' 	  q 7;    IL$(H;
l u0H
 H H	  	  3 ;;    H ~ HHu 	   =;  n  H@IH; t_H;M tVHM HHuu 	   C;  '  H@L   Mu%L 	   E;  
  HHMMH/uHGHP0Mu>H H9EuL;u   HEJ<HI)L;u   J|HIHAHHN  H$   H$   Ht
H)uHAP0H H HH   HKH9K ~H HCH<HAHC:HH7 &M 	   k;    IHm u
HEHP0HÛ L~II9  HnH  LvHHE IIH)uHAP0H9 M~I9  A   Hl$(HT$(H\$0I3LHu{ 	   ;  W   	   i;  >   H3H HH<t2 C 	   a;    Hm u
HEHP0IH+u
HCHP0H.u	IHP0H
: L$   .HH   HR HK  
   ;        HHu 	   ;  O  HhE3HHX II0LHu'Hޡ H U 	   ;  *  H/,HGHHH.LH 	  Y z;  
  H@HH L   MtAc HHu'HD H=  
   ;  
  H.u
HFHP03 HHu'H H t 
   ;  ^
  H$   HI(H;
 u>H
a H2 H	a H H ! 
  k ;  	  H#  HHu'Ho Hh  
  0 ;  	  H@H;L t\H;{ tSHИ HHu 
   ;  X	  H@L   Mu%} 
   ;  /	  HHMMH+uHCHP0fMu>HĖ H9EuL;e  HEJHI)L;e   J\HIHAHH   H$   H$   Ht
H)uHAP0Hz H1 HHtOHNH9N ~H HFHHAHF=HHk ) 
   ;  3  H H Z 
   ;  /  M Ht H HH     Hm u
HEHP0H LII9  HoH  LwHHE IIH)uHAP0H M~I9   A   Hl$8HT$8Ht$@I-LHuNH H | 
  
 ;  Q  Hޝ H U 
  
 ;  *  Hm u
HEHP0IH.u
HFHP0H/u	IHP0H
L Lt$ )HH   Hg H`    (
 <        HHu'H- H&  
   <  y  HhE3Hp HIII+LHug 
   <    H+,HCHHH)LHH H  
  ] ;    H@HH L   MtAg HHu'HH HA    	 <    H/u
HGHP0H9 L{II9  H{H  LsHHIIH)uHAP0H M~I9   L$   HT$HA   Ld$PIH|$Hv+LHu   I[ 2<    H/u
HGHP0IH+u	IHP0IL$   MH)uHAP0H. D9(z  H$    HH   H H    
 X<  l      HHuV   
 @<    L$   E3HxHIII$L` )LHu   Z
 F<    H.HFHP0L$   HIe'LH   I
 ,<  n  I Hu'H H    	 Y<  p  H;t7H
+ H	
 Hә H J   	 \<  4  H
t %HHu'H H  
  Y	 h<    H@HHR
 L   MtAc HHu	 j<  {  H+u
HCHP0    HHu'H H  
   m<  ^  IL~H@IHL$ L0HHCHHH I9  H~H  LvHHIIH)uHAP0Hp M~I9&  A   H|$XHT$XH\$`I>(LHu0 <    H/u
HGHP0H+u
HCHP0H.u	IHP0IMH$   L|$xL$   H$   H$   H$   H$   Ht
H)uHAP0MtI,$uID$IP0HL$ L$   Ht
H)uHAP0MtIm u
IEIP0H$   HtH(u
HPHR0IHİ   A]ù   2 HHu <  }HxE3HHX II
&LHu$H H  
   <  eHm HEHHH#LH <  ? 
  H H
 HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0HtHm u
HEHP0D
 H
  SL$   [HHPHHUH   H
 3HXHxL`DLhDLpDLxDHAH$   Hl$pHl$XL   Hl$xH$   H$(  Hl$PMtA H$   HHu'Hx Hq    9 8    HGH$   HD$`H H;e 4  HWH$   H  HwHHHHH)uHAP0H$   HFH$   HD$`H H; uA   H$   H$%H; uHF@t
H"H"HHu'H H    U 9    H$   H)uHAP0H$   H/uHD$`HH P0H.Hu
HFHP03 HH       9    H;܎ uE33H#1H;$ uHG@t3H!H E3H"HHWH H
    h 9    H$  HI(H;
\ u0H
 Ht H	 
   # 9    H n HHu
    9  c  H@H; toH;A tfHHD$h H$   Hu^
    9    H@H   HL$`Hu30
   z !9  
  HLH$   H\$hHl$`H\$hLL$   H/uHGHP0    MuHHT I9GuI;_  IGH<HHH\$h.I;_  I|HHH\$hIAHH  H$   LH$   Ht
H)uHAP0H
	 HLH;  HHHV H   IHt HH  I.u
IFIP0H* IY LH  H
 LHy  HHHr H   IHt1 H$(  LH%  I/u
IGIP0H I݇ LH  H Ml$Hl$PI9E 
  IT$HT$PH   Md$H$(  HHL$(  I$H(uH@P0HT$PH[ Ml$L$   I9E uNH$   A   H$   L$   I LH  HD$PH(u
HPHR0Hl$Px    LH  HT$PE3HPILx HHl$PLLH  Im u
IEIP0L$   'IILH  I/u
IGIP0H$(  H)uIE P0   R H$(  LH(  H
	 E3LpHLL` )LH  I/u
IGIP0HF LkH$(  I9E    HSH$(  H   L{HHIIH)uHAP0H$(  H MoI9E uQH$   A   H$   L$   IoHH  H$(  H)uHAP0H$(  r   A LH  H$(  E3Mf IIIFH$(  LHHm  I.u2IFI&IHHH  I,$uID$IP0H+u
IE HP0HNHH9N ~HHFH<HAHFHH
 !  H/H\$hLt$`L$   .HGHP0HI/u
IGIP0H$  LH$   D.  H= LH3     9  O
      e9  L      {9  6  f   L u9    J    9    1   { 9       b 9       I 9       0 9        9  ~      9  e      ^9  O     L Q9  3  f   L N9    J   L L9    .   x J9       _ G9       HC E9     HH\ HHt    H =9  X  tH  H$  HH(H;
 uAH
 H H	 Hي LH M    9    H/  HHu*H LH    Y 9       M H$   HHu/ 9  H  IE3H
 HLxHp HHu 9  H  H+u
HCHP0HFH; tZH;0 tQHI H$   LHu 9  H  H@L   Mu& 9  H  HLH$   LLH.u
HFHP0INHH$   fMu<Hd I9FuM;f
  HJ4HI(M;f  J4HIIAHH  HFHJ H;   H; t~H LH2  H.u
HFHP0IFILH   HH  IA   HH  IHS  M)>uGIFI;HNHo  H;u
H^ H~H~H_H?HHH.u
HFHP0HL$pLH|$pHt
H)uHAP0HL$XHH\$XH$  Ht
H)uHAP0IGHH;~ tKH; tBIIp HH,  H@L   Mu,2   | e:    IILL    Mu>H~ H9FuL;v   H^JHI)L;v   J\HIHAHH   HL$xH\$xHt
H)uHAP0HL$pH} HH  L$  H HHx  H+u
HCHP0HT$xLHL$pH 4  H/!HGHP0H+ Ht H} HH3  } H.u
HFHP0H$  HL$   H$   HD$XH. LH$ L   L H:  v  I.u
IFIP0LuIiHڅ LH LK   L P:  "  /   y @:        ` c:  *     G :  C   1 :  -    :      :  HH LH LH$  LHD$XLY~H
t} H A   H	>} 
HxZ +:  F   LLLLH H HtH.u
HFHP0HK  H/A  HGHP02  } Ht Hk{ HH   { I.u
IFIP0L$   IIL$   L$   L$   H$   H$   H$   MtI/u
IGIP0HL$pL$   Ht
H)uHAP0HL$XHt
H)uHAP0HL$xHt
H)uHAP0H$   HtH(u
HPHR0HH   ]; :     LLLLHB H; H$   Ht
H)uHAP0MtI.u
IFIP0HtH+u
HCHP0MtI,$uID$IP0MtI/u
IGIP0H$(  Ht
H)uHAP0HL$PHt
H)uHAP0MtIm u
IEIP0D H
N L L$   :H\$Hl$VWAVH@Ho| IHzLH\$pHM   HtH   HZH\$pHz HHu)H  H Hx HtHHD$pHH   H HHD$(LL$pH& H|$ Ly
8     H\$p   H   H   H5 H|$0HH? H?L
 HLE HHDHHD$(H HL$ LIH
z H H	vy 8  H
 H  {   A  H
 3HZHIH\$`Hl$hH@A^_^HHPHHATH   H E3HXAHpAHxLhELpEHALd$XLd$hLd$pL   L$   L$   MtA@y H$   HL$   Hu'H H
     7  ?  HGLH;
x I  HoH  LwHHE IIH)uHAP0IFM~H;z Hl$xuA   HT$xI]+H;z uIF@t
HI]
HILHu    7  	  Hm u
HEHP0IH/u	IHP0I.Iu
IFIP03v LH   H~ H ]    7  	  H;y uE33H1H;y uHG@t3HH E3He
LHN   9 7  	  H$   HI(H;
-w u&H
w H H	v  7  X  H I HHu 7  5  H@IH;t Lt$PtMH;v tDHrv HHu 7    H@H   HL$`Hux 7    HHMLd$`H/uHGHP0HD$`Hu>Hot H9EuL;u4  HEJ<HI(L;u  J|HIHHH   HL$hH|$hHt
H)uHAP0Ht Hs HH   H Hs HHtgH/u
HWHR0IOII9O ~HIGHHAIGHIs uH+HCHI 7     : 7     + 7     u HtHHs HHtWs Hm u
HEHP0H$   ML|$XyeH{ H i    7      7  IH{ H 5   I/g  IGIP0X  tIIs  3s HHu'Hp{ Hi    1 7    H$   HH(H;
%t uAH
t H} H	s H{ IH     7    Hs & HHu'Hz H V    7       s HHu'Hz H    f 8  ^  IE3H
@ HLxHX P	HHu2 	8    H/u
HGHP0HCH;>q teH;mr t\Hr HHu'Hz H     8    H@L   Lt$`Mu$ 8  {  HHLd$PMLd$`HH+u
HCHP0MuHHp H9GuH;wa  HGHHHHt$P.H;wB  H\HHHt$PHAHH  HCH|q H;+  H;4p   Hq HH  H+u
HSHR0HNIML   HAH$   MH  HA   ALHm  HAHH  L)>u
HFHP0Lt$`HL$pH$   H\$pHt
H)uHAP0H$   L$   L$   Ht
H)uHAP0L$   HM+HHR  HMH9M ~eH HEHHAHEdHKH_  H;u
Lk HCHCLhH H$   H IE H+3HCHP0$HHo    H+tH$   Ht$PH$   HCHP0H$   Ht$PH$   2 [8    H.u
HFHP0I uI c8     S8    Hw IH H$   H$   l    l8    Hv IH H$   H$   2   | j8  _  ~,H
o H A   H	n N >8    Hx 5 >8     o Ht HRm HH   m H/u
HGHP0Lt$XLL$   L$   H$   H$   H$   H$   MtI.u
IFIP0HL$hL$   Ht
H)uHAP0HL$pHt
H)uHAP0H$   HtH(u
HPHR0IH   A\> .8  IL$   M   HCu H< HtH/u
HGHP0HtHm u
HEHP0HtH+u
HCHP0H$   Ht
H)uHAP0MtIm u
IEIP0HtH.u
HFHP0Lt$XD3 H
 z H\$Hl$VWAVH@Hn IHzLH\$pHM   HtH   HZH\$pHl HHu)H  H H
k HtHHD$pHH   Hr HHD$(LL$pH H|$ |y
[7     H\$p   H   H   Her H|$0HHoy H?L
 HL% HHDHHD$(H HL$ LIH
l H H	k i7  H:s H3 	    A  H
 )3HZHIVH\$`Hl$hH@A^_^ATAWH8HAE3H EH\$XHl$`HL   MtAk Ht$0HH|$(Lt$ Hu'H}r Hv    > 6  A  HCLsH;vj I  H{H  HsHHHHH)uHAP0HFLvH;l H|$PuA   HT$PH+H;)m uHF@t
HHHH=HHu'Hq H -   w 6  P  H/u
HGHP0IH+u	IHP0H.Iu
HFHP03h HH   HFq H?     6    H;k uE33H 1H;Gl uHC@t3HH E3HHHNHp H A    6  d  HM(H;
i u&H
6j H H	6i X 6  	  H 裕 HHu5 6    H@H;Qg tLH;h tCHHh HHu 6    H@L   Mu 6    HHIMH+uHCHP0    Mu>Hf H9GuH;o   HGHHH)H;o   H\HHHAHH   ILHt
H)uHAP0H HKf HHtEHNH9N ~H HFHHAHFBHHf . 7      	7     h HtHe HHJtf@f H/u
HGHP0HLH.u
HFHP0Lt$ H|$(Ht$0Hl$`H\$XMtI/u
IWIR0IH8A_A\J 7  Hgn H`    H.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0D H
F  LHL@HPHHSVWATAUAVAWH   H@HWhE3LxD$xL`AED$`Ld$pD$HLd$XEL-< IH
r \d HHtH IHHu'H@m H9     5    HCL   H HMtAf HHu'Hl H c    5  m  H+u
HCHP0IH$H  LnHd I9E g  H^H$H  HR  H~HHHHH)uHAP0LoH?g I9E u}H$   H$8  H$   A   H$   HHHu'Hl H     6    H+u
HCHP0IH$H        d LHu'H
k H
 9    6  C  HXIH$H  H$8  H IF E3IH^HHu'Hgk H`    ( 6    I.uFIFIP0:HHBHHu'Hk H     6    H.u
IE HP0HGL   H HMtAc HHu'Hj H .   x "6     H/u
HGHP0HH$   bHHL$`jH$   HtL$   L+I葝c Ht*H7j H0     %6  M  H.u
HFHP0IHT$`H$   GfH$@  ڟ@@u5`c Ht*Hi H ;    06  MB  H$   H$   4gDLH$   H$0  HI1HHL$HiH$   HtL$   L+I膜HT$HHL$xeH
 ZHHu*Hi H     A6  M  H@L   H HMtAa LHu'Hh H 3   } C6  (  H/u
HGHP0HL$x:iHHu'Hsh Hl    4 F6    IMnHm` I9E C  I^H6  MnHIE IMH)uHAP0IMH$H  Hb H9urH\$(H|$0A   HT$(IHHu'Hg H C    Z6  8  H+u
HCHP0H/   HGH      [` LHu'H
lg H
e    - j6     HXHx E3IIHHu'H'g H      p6     I/uUIGIIHIHHu$Hf H U    S6  MH/uHGHP0P0L$H  I.   IE IP0   E3AH$H  AEMHtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0MtI.u
IFIP0MtI/u
IGIP0D  H
 
IHT$HHtLD$XL+IHT$`HtLD$pL+I HT$xHtL$   L+IH$   HtL$   L+I还HH   A_A^A]A\_^[H\$Hl$Ht$WATAUAVAWHPH=e_ E3H|$HAH\$@MHLM   LzIMt"HtH   Hz H|$HHZH\$@I] HIMtHt&MHB I[ HD$@HH   HH(  H I[ HtHHD$HHH   H IHD$(LL$@H| L|$ y
5     H|$HH\$@   HBH   H   HNHb HHL$0Hi HLL
# AHD$(IH HLd$ H
p] L9 LMH> H	\ 5  Hc H x    A  H
ݞ 蘽3Hz HZLHI~L\$PI[0Ik8Is@IA_A^A]A\_HLH L@HHVWATAUAVH   H@HXLW@H@    33D$@HXL5 IH
 Y HHtH I)HHu'Hb H )   s /5  6  HGL   Hx HMtA}[ HHu'H^b HW     15    H/u
HGHP03H|$ LcHDZ I9$M  H{H|$ H;  LsHIHIH)uHAP0MfH\ I9$uqH$   L$   A   H$   ILHu'Ha H    ^ E5  !  H/u
HGHP03H|$       6Z HHu'H
Ga H
@     S5    Hx3H|$ IE Lh E3HILHu'H` H n    Y5    H.uFHFHP0:IHLHu'H` H "   l ?5  /  H+u
I$HP0IFL   H! IMtAfY HHu)HG` H@     _5  3  I.u
IFIP0HD$0    HHL$pGXHHL$@j`HT$pHtL$   L+I^Y Ht)H_ H 9    b5  3D  H+u
HCHP03HT$@HL$X[H$   jAAu4X Ht)HT_ HM     n5  3   H$   @@u4X Ht)H_ H  ~    o5  3   HT$XHL$p~\DEHH$   HI)sW HH   H^ H    a v5  3%Lt$0H|$ IIMtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0D  H
 3HT$@HtLD$PL+I/HT$XHtLD$hL+IHH$   HĠ   A^A]A\_^H\$ UVWATAUAVAWH`H H3HD$XL5W 3H-U MHt$@HLt$HLHl$PM%  LbIMt1Ht"HtH%  Hj(Hl$PLr Lt$HHrHt$@IU HIMtHt,HtOvHn IS HD$@HH   HHo  H! IS HtLHD$HHHF  H@ IS HtHHD$PHH  H IHD$(LL$@HCu Ld$ y
4     Hl$PLt$HHt$@   HBH   H   H   HWHZ HHT$0A   H
a HLL
 HL$(   H
pU H;AMLb HHD$ H	H/ MML S 
5  H[ H a    A  H
 聵3Hj(Lr HrLMHIHL$XH3wH$   H`A_A^A]A\_^]@SUVWATAVAWHPH" H3HD$@H-; LLHH
 M33Q HHtH H)HHu q4    HCHH L   MtAS HHuO s4    H+u
HCHP0HGHHH L   MtAIS HHu'H*Z H#     v4  d  H/u
HGHP0HR 33H9Cu+H{Ht"HCHHHH H)uHAP0   HT H9CugHT$(HDEH+H|$ HLt$(L|$0Ld$8[HHuM 4     H  H/
  HGHP0   M!R HHuH
2Y H
+  4  ZHtHx3IE3HHLtEIL|EI$LdHHu~ 4  HX H C   HtH+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0D H
V D {3#H.u
HVHR0H+u
HSHR0HHL$@H3tHPA_A^A\_^][H\$Hl$Ht$WAVAWHPHP MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@InP HHHtHt+RHJ  H IrN HtHHD$@HH!  H IIN HtHHD$HHH   H IHD$(LL$@H5p Hl$ y
A4     H|$HH\$@   H   H   H   H
r Hl$0HL
 H?L HH- HHLIH
w\ HL$(H
/P HD$ H	N R4  HuV Hn D    A  H
ُ d3Hz HZLHIH\$pHl$xH$   HPA_A^_H\$Hl$Ht$H|$ ATAVAWH H5+ LHHH
 MM3L HHtH HHHuz 3    HGHH L   MtAN HHu> 3  D  H/u
HGHP0HCHH L   MtA8N HHu'HU H     3  
  H+u
HCHP0L HHu 3     H- LHK y 3     H/ MHK ya 3  jH MHK y> 3  GH MHK y 3  $H> LHHHui 3  HT H    HtH/u
HGHP0HtH+u
HSHR0DX H
  ֭3#H/u
HWHR0H+u
HSHR0HH\$@Hl$HHt$PH|$XH A_A^A\@SUVWATAVAWH`Hr H3HD$XH=+L MH-Y LH5 LrH|$@IHl$HHt$PM#  Mt1Ht"HtH/  Hr(Ht$PHj Hl$HHzH|$@IK HIMtHt1HtT{H  H8 II HtHHD$@HHl  H InI HtHHD$HHHC  H IEI HtHHD$PHH  HM IHD$(LL$@Hqk Lt$ y
3     Ht$PHl$HH|$@   M   H   H   H   HP Lt$0IHW H?L
խ HL HHHDMHD$(H HL$ LIH
K H H	I 3  HSQ HL "  y  Ay  H
 B3Hr(Hj HzLLHIHL$XH3tmH`A_A^A\_^][@UAVH(HAE3H\$@AHt$HAL|$ LL   H MtAI H|$PHHu v  N F3  D  G HHu1 H3        %I HHuH
6P H
/  J3  lILLxHH AG y׿ O3  4H+u
HCHP0H LHHHu^ Q3  HO H 5 v  H.u
HFHP0HtH/u
HGHP0HthH+ubHCHP0VH.u
HFHP0H/u
HGHP0IHH2F Hu= w   `3  H"O H D H
  LL|$ H|$PHt$HH\$@HtHm u
HUHR0IH(A^]@SH HAH/ L   MtAG Ht$8HH|$@Lt$HHu'HbN H[  s  # 2    HCLs3H;YF    H{H   HsHHHHH)uHAP0HFLvH;H H|$0uA   HT$0H+H;I uHF@t
HHHH#HHuu 3     H/u
HGHP0H+u	IHR0HLt$HH|$@Ht$8H [H;6H uE33H1H;~H uHC@t3H H' E3HHHu޼ 3  HL H r s  HtH+u	IHP0HtH/u
HWHR0DB H
K  3/AVAWHHH\$`E3Hl$hEH- Ht$pHH|$@ALl$0ALH
O 9C HHtH HHLd$8Hu o   f2  3  HCHH  L   MtAD HHuW o   h2    H+u
HCHP0HGHH2 L   MtAD HHu'H|K Hu  o  = k2    H/u
HGHP0HmC LcII9$w  H{Hj  HkHHHHE H)uHAP0HE LeI9$   A   H|$ HT$ Ll$(HHHuM o   2    H/u
HGHP0IH+u
I$HP0H
4 LHH   HqJ IHg  p  / 2       #C HHu'H
4J H
-  o   2  O  HxE3IE HHLh IHHum o   2    H.)HFHP0IHHH$ o  n y2     H}yQ 2  I   H+u
HCHP0   HEHH' L   MtA@B HHu'H!I IH  p  ߸ 2  QH E3HHHu| 2  [ p  HH Hſ HtH+u
HCHP0HtH/u
HGHP0HtH.u
HFHP0D H
 N 腢H+u
HCHP0HHE LLl$0Ld$8H|$@Ht$pHl$hH\$`MtI/u
IWIR0IHHA_A^{H\$Hl$VWAWH0H-' LH
ݽ H33> HHtH HHLt$PHux 1    HCHH L   MtA@ HHu< 1    H+u
HCHP0HGHHͽ L   MtA6@ HHu'HG H  l  ض 1    H/u
HGHP0H? Ls3I9  H{H  HkHHHHE H)uHAP0HA LuI9unA   H|$ HT$ L|$(HQHHuC 2     H/u
HGHP0H+u	IHR0HLt$PH\$XHl$`H0A__^ù   > HHuH
F H
 ٵ 2  tHxE3IHHLx 3HHu 2  7H.pHFHaIHHHMq 2  HE H  l  HtH+u
HCHP0HtH/u
HGHP0HtH.u
HVHR0D H
{  =3LUAUIHH  H
 H3H   HE3H  I[AIsAI{H HEHALD$hMcM{EL   HT$XH LMHL$PLmLmLmH\$HLl$`LmLl$pLl$xLmLmLmLmLmLmLmLmLl$8Ll$@MtA?= L$   HHu'HD H  1  ٳ *  E  HGLgH;< 5  H_H(  LwHHIIH)uHAP0IFMfH;> H]uA   HUIj+H;> uIF@t
HIjHILHu'HVC HO ͺ 1   +  fD  H+u
HCHP0IH/u
I$HP0I.Iu
IFIP0H
)= HT$hH9M  H;A  L5: H
Ӹ I9 LH   H    H;= uE33Hp1H;= uHG@t3HqHx E3HMLH6HRB HK ɹ 1   	+  bC  ILMu 3   *+  C  ID$IH L   MtA: HHuY 3   ,+  B  I,$uID$IP0H E3HLHu'HA H  3  P /+  B  H/u
HGHP0I.u
IFIP0HT$hH
+: H9M  H;j9 A   H
 PLHu*H	A LH } 5  ǰ X+  0B  H@IH` L   MtA9 HHu7 5   Z+  A  I,$uID$IP0H߶ E3HdLHu'Hm@ Hf  5  . ]+  }A  H/u
HGHP0I.u
IFIP0H
9 Ld$XL;   Lt$PIF(H;uAH
9 HLs H	8 H? LH ` 8   +  A  H Hd Hu*H? LH " 8  l +  @  I,$IHD$X   ID$P0   H
ܸ LHu*HP? LHF Ķ 9   +  w@  Lt$XII46 u 9  ݮ +  @  I,$uID$IP0t\   s6 HHu*H> LHµ @ :   +  ?  IIH@HT$XL0I.uIFP0Lt$PH
ƹ HHu*Hj> LH` ޵ ;  ( +  ?  H@HHA L   MtA27 HHu'H> H  ;  ԭ +  #?  H/u
HGHP0HCHH L   MtA6 HHu*H= LH # ;  m +  >  H+u
HCHP0IN(IH;
V6 u>H
7 H6q H	6 HN= HG Ŵ ;   +  ^>  Hw Zb HHu'H= H  ;  Ԭ +  #>  IN(H;
5 u>H
6 Hp H	5 H< H ? ;   +  =  Hɴ a HD$8LHu'H
< H
  ;  I +  =  H4 EH9Gu,LMt#HGHIHH H)uHAP0A   H7 H9G   HD$XH   H   EFAHHH+L   H   L   LHu'H; Hǲ E ;   +  <  MtI/u
IGIP0H+Mu
HCHP0I,$   ID$I   AND4 HD$@HHu'H
P; H
I ǲ ;   +  `<  MtLxMHL$XE3ALl$8HHLAFH\HAFILdLHu'H: Hٱ W ;   ,  ;  HL$@H)uHAP0H/u
HGHP0HL$XILt$XH)uHAP0LuL;5a3 uL1 Hu-He: MH[ Hֱ =    ,  ;  I.IHEuIFP0H\$PHK(H;
3 uDH
3 H3n H	2 H9 MH Hl ?   2,  S;  H _ LHu-H9 MH H+ ?  u 4,  ;  HK(H;
q2 u=H
 3 Hm H	 2  ?  I5 8,  Ll$8Ll$@U:  Hۯ v^ HHu& ?  I :,  Ll$8Ll$@:  HI1 HD$@LHu!u ?  I <,  Ll$89  I,$uID$IP0H/u
HGHP0H
 LuMLl$@HHu*H8 HH  @  K J,  9  H@HHd L   MtAU1 LHu/H68 IH,  @   L,  Ll$8>9  H/u
HGHP0ID$IH L   MtA0 HHu!N @  I O,  Ll$88  I,$uID$IP0H/ MALl$0H9Gu1LgLd$0Mt#HGHI$HH H)uHAP0   H-2 H9G   HD$XHUpHMDCHExHMpHϋHH+LehHD$@LHu! @  Iͦ a,  Ll$87  MtI,$uID$IP0MLl$0   K/ HD$8LHu!Ld$0I# @  m o,  7  HD$0Ht
ID$Ll$0HME3HT$XHILCHHITI4HD$@LHu!Ld$0I @   z,  )7  I,$uID$IP0Ld$0H/u
HGHP0I.u
IFIP0H
( Ll$@HHu!L B  I ,  Ll$86  H@HH L   MtA. HD$8LHu!Ld$0I B  ; ,  e6  H/u
HGHP0ID$IHӨ L   MtA4. HHu!Ld$0I B  ܤ ,  6  I,$uID$IP0H\$PLl$8HK(H;
- u8H
k. H<i H	k- Ld$0I1 B  { ,  5  H Y HD$8LHu!Ld$0I B  A ,  k5  HK(H;
=- u8H
- Hh H	, Ld$0I C   ,  &5  H< GY HD$0Hu*H3 IH r C   ,  5  HK(H;
, u8H
g- Hh H	g, Ld$0I- D  w ,  4  H' X HHuLd$0 D  E ,  o4  H+ MEH9Gu,LMt#HGHIHH H)uHAP0A   H- H9G   HD$0H   H   EFHD$XHH   AHH+L   L   H   HD$@LHuLd$06 B   ,  3  MtI/u
IGIP0I,$MuID$IP0HL$0H)uHAP0H+   HCH   AN#+ HHu,H
42 Ld$0H
(  B   ,  (3  MtLxMHT$XANAE3Ll$8LdHD$0HDAFHH\AFHIHTHHD$@LHu'H1 H   B  j ,  2  H.u
HFHP0H/u
HGHP03Lu( HD$@LHu-HI1 IH? I G   ,  2  H\$PHK(H;
) uDH
* He H	) H0 IH Id G   -  K2  H6 U HHu-H0 IH I# G  m -  
2  HK(H;
i) uIH
* He H	) Ha0 IHW Iҧ G   -  Ll$8f1  H bU HHu/H0 IH  G  ٟ 	-  Ll$8#1     ( HHu,H/ HҦ P G   -  Ll$80  H
u E3HHxHp 肾HHu*H/ MH  G  I -  0  H+u
HCHP0HFH;U&    H;' twHI' HHu'H"/ H  G   -  {0  H@L   LuMu8H. H ^ G   -  0  HH3DH}3H.u
HFHP0Ld$@    Mu>H% H9CuL;k  HCJ4HI)L;k  JtHIHAHH  HFHx& H;3  H;0% &  H& HD$8LH  H.u
HFHP0IFHHL$8LL   AHD$0    HHq  HL$8A   AHD$0HU  Ld$8IAH  I,$uID$IP0Ld$0LuHL$xH|$xHt
H)uHAP0HMIHEHtH)u
HAP0IHH@% HHf  Ld$@IL$I9L$ ~_H ID$H4HAID$\HNHZ  H;u
Lf H~H~LgH?HI$H.KHFHP0<HI$    H.    HFHP0E3Ab  Ld$0 G  : e-  d-  HL$8H)uHAP0HD$8    ѵuI赶Ld$0 G   m-  -  H, H  G  ɛ ]-  2-  H+ E3Hע U G   v-  -  H+ E3H + G  u t-  ,  ~H
$ H A   H	# 
HxHb+ LHX ֢ G    H-  ,  $ HtH=" HH{tZ" E3H+u
HCHP0HL$hMLeLl$@`yQH* Hݡ [ I   -  =,  H* LH 1 G  { 8-  +    H
 HHu'Hy* Hr  J  : -  +  H@HH L   MtAD# HHu'H%* H  J   -  O+  H+u
HCHP0H" IH9F   H^H   H~HHHHH)uHAP0HHĶHD$@HHu'H) H  J  Y -  *  H+u
HCHP0IH.u
HFHP0Ld$XIH|$HID$H;D     H;o!    IHE! HD$@LHujH) MH x K   -  +*  H衵HD$@HHcH( H 8 J   -  )  H@H   HE HuFH( MH|  K  D -  )  I$IIHMHE MLd$@HMMLl$8IHuFH4 I9FuI;N}  IFH4HHHM,I;N_  ItHHHMIHH  HT$`LHt$`HHt
H*uHBP03J HH  HMI HH  H@H; t[H; tRIHLt$h  HD$0H  H@L   LeMu5Ld$0 M   -  0(  HMH\$0MLl$hLmH+uHCHP0fD  MuQLd$0H I9D$u!M;t$  ID$JHILt$h6M;t$  K\HILt$hHL$0AHHf  Ld$0HMH]Ht
H)uHAP0H
 I蘲HH  H@HHN L   MtA? HD$8LHj  H/u
HGHP0ID$IHߘ L   MtA HH
  I,$uID$IP0H MALl$8MH9Gu4LgLd$8Mt&HGHI$HH H)uHAP0   DHT  H9GuhHEDAH   H   HD$PL   H@(H   HHH+HH  MtI,$uID$IP0Ll$8q LH  Mt	L`Ll$8HEE3HL$PIH KDHA(H HA(HKD 蜳HH  I/u
IGIP0MH/u
HGHP0HNIH9N ~HHFHHAHFHH #  H+Lt$hLeDHCHP05I0 Ht H& HHst  e Ld$0I,$uID$IP0HMLHuHt
H)uHAP0H
 ILH  H@IH L   MtA HHA  I,$uID$IP0H LcLl$0I9$   HSHT$0H   LsHHIIH)uHAP0HT$0H MfI9$uCHEA   HUIHUHE ƲHH
  HL$0H)uHAP0Ll$0v    HH
  HD$0E3HGHHEILl$0H HG sHH>
  H/u
HGHP0IIHwHH  H+u
I$HP0HL$pHt$pHt
H)uHAP0LuIHq IIFL   MtA HHw  H IH9CuRH{HtIHsHHHHH)uHAP0HHƮHH  H/u
HGHP0IHMHH  H+u
HCHP0Ld$`HII- Dx
AADE  H.u
HFHP0EILt$p/  IFIH L   MtA HH  HMI HHp  H LcLl$0I9$  HSHT$0H  LsHHIIH)uHAP0HT$0HX MfI9$   HU(A   HU(H}0I(HHf  HL$0H)uHAP0H/Ll$0u
HGHP0Lt$pH+u
I$HP0IHt$pLIH)uHAP0Ld$` HH  MIH   HL$xLHt$xHt
H)uHAP0HL$HIH HAL   M   A      J LH
  HD$0E3IIGILl$0I &HHr
  I/u
IGIP0MHH'HH
  H/HGHP0 HH  L`MH I9$   L{M   LsHIIIH)uHAP0Ho MfI9$u@HD$xHU8A   HE@IL}8>HH9
  I/u
IGIP0Mp    HHI
  LxE3HD$xHIMH HG HH	  H/u
HGHP0IIHHH  H+u
I$HP0H.Iu
HFHP0Lt$PIIN(H;
 2  H B HH
  H@HHÔ L   MtAl HH
  H+u
HCHP0Ha LgII9$   H_H   LwHHIIH)uHAP0H MfI9$uEHT$`A   HUPIHUHH]H覬HH  H+u
HCHP0Lt$PIw   } LH	  HXE3HD$`IIIH IG XHH  I/u
IGIP0Lt$PMHT$`HUHHp  H/u
I$HP0HMIHuLHt
H)uHAP0IN(IH;
   H A HH  IH HH  H.u
HFHP0HMLH}Ht
H)uHAP03I HH)  A   HI LH
  H.u
HFHP0II8QD
  I/u
IWIR0Et*    LH  H
R HH@HI$MI,$IML}uID$P0    HH
  HEE3H
 HH HG芩LH	  H/u
HGHP0    HH	  H@IHL8 LHI	  H/u
HGHP0HMIL}Ht
H)uHAP0Lt$`Ld$HII LH  H@IH L   MtA HH  I/u
IGIP0    LHH  HEH IG HH
  L HHˏ    LIHGHH  H/u
HGHP0I/Iu
IGIP0H.Mu
HFHP0LIII[ *  H+u
HCHP0HMIv H  HEAE:  HM   袕HH  H A   HHH\  H+u
HCHP0HIjND  H.u
HVHR0E  H
 zHH  H@HH  L   MtA! LH  H+u
HCHP0HT$`I HH  H MwI9   IH   IwIHLHH)uHAP0Hv LvI9u;A   H}XHUXH]`HKHHr  H/u
HGHP0Ir   ' LH}  HxE3HX HHIIHH<  I,$uID$IP0MLl$0,HIHHh  H+u
HCHP0Ld$0I/u	IIP0HT$`LHL$HM 
  H.u
HFHP0Ld$0MLt$@IHMHE 9Hj Hc  M  + -  z  Ld$0Í L  
 5.  7  Ld$0 L   S.    Ld$0 L  х N.    Ld$0i L   C.    Ld$0K L   #.    Ld$0- L  w  .     L  ^ .    Ld$0 M  @ .  j  Ld$0، N  " .  L  H: H3  N   .  J  Ld$0 N  ݄ .    Ld$0u O   .    Ld$0W P   .    H H 0 P  z .    Ld$0 P  \ .    Ld$0 P  > .  h  Ld$0֋ P    .  J  Ld$0 P   .  ,  Ld$0 R   (/    Ld$0| R  ƃ </    Ld$0^ R   6/    Ld$0@ S   e/    Ld$0" S  l y/    Ld$0 S  N s/  x  Ld$0 V  0 /  Z  Ld$0Ȋ [   /  <  Ld$0 [   /    Ld$0 [  ւ /     Ld$0n \    0    U \   60    H IH + \  u 00     \  IY <0    Ld$0 \  ; 0  e  Ld$0IЉ \   0  D  Ld$0I \   	0  #  Ld$0I \  ؁ 0    Ld$0p [   /    Ld$0R Y   /    Ld$04 Y  ~ /    Ld$0 Y  ` /    Ld$0 Y  B /  l  Ld$0ڈ Y  $ /  N  Ld$0 Y   /  0  Ld$0 Y   /    Ld$0 W  ʀ /    Ld$0b W   /    Ld$0D W   /    Ld$0M# W  m /    Ld$0 V  O /  y  Ld$0 V  1 /  [  Ld$0ɇ V   /  =  Ld$0 T   /    Ld$0 T   /    H
	 HPE H	 Ld$0X T   /    Ld$0: S   _/    Ld$0 S  f Q/    Ld$0 S  H O/  r  H
 	 HD H	  Ld$0Ɇ S   M/  =  Ld$0 R  ~ "/    Ld$0 R  ~ /    Ld$0Il Q  ~ 
/    Ld$0IK Q  ~ /    Ld$0- O  w~ .    Ld$0 O  Y~ .    Ld$0 O  ;~ .  e  Ld$0Ӆ N  ~ y.  G   N  ~ k.  .  H H  N  } i.  ,  z M  } -    a L  } -    T Ht H HH^    I.u
IFIP0H\$HHLHML$  L$   L$(  H$0  H$8  Ht
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HtH+u
HCHP0HL$`H$@  Ht
H)uHAP0HMHt
H)uHAP0HL$pHt
H)uHAP0HL$xHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HMHt
H)uHAP0HL$XHt
H)uHAP0HEHtH(u
HPHR0IH   H3((HH  A]]# K  m{ -    3 LHu'Hu Hn  ^  6{ d0    HHD$HHD$PMHH(H;
" u>H
 H@ H	 H H  _  z r0  x  H &0 LHu'H
 H؁ V _  z t0  =  IF HE HHu'H
 H  _  cz v0    I.u
IFIP0Ll$@MLl$0H	  @ H
 脖HHJ	  H@HH:} L   MtA+ LH  H.u
HFHP0IGIH} L   MtA HH  I/u
IGIP0I= IILHR  H AH\$0H9Fu2H^H\$0Ht$HFHHHH H)uHAP0   H5 H9F   HD$PDALuH   H   L   H@(H   HHH+L   ޘHD$@HH  HtH+u
HCHP0I/Ll$0   IGI} HHI  HD$0Ht	HCLl$0HL$PE3LuHL|MHA(H HA(HHD ILt(QHD$@HH  H+u
HCHP0H.u
HFHP0HMIH}Ht
H)uHAP0H|$PLl$@HO(H;
  G  Hi ,- HD$@HH  3HHH  H+u
HCHP0HMHLl$@H]Ht
H)uHAP0II=r     HO(H;
_    H} , HH  3H7HD$@LH^  H.u
HFHP0IH2 HH  I.u
IFIP0H+HHuuHCP0H
 HD$@LH  H@IH| L   MtA HHM  I.u
IFIP0H LsLl$@I9   L{L|$@M   H{HIHHH)uHAP0H% LwI9uAHEHUA   HEHL}HH  I/u
IGIP0Ll$@t    LH  HL$@E3HHIHEHLl$@H IG 襔HHa  I/u$IGIP0HUH諒HH  H+u	IHP0HFHH| L   MtAc HH  H.u
HFHP0HMIH]HHt
H)uHAP0H
 CHHT  H@HH)x L   MtA HH  H+u
HCHP0    HH  HX HHH HCHx H HC Hs(k HHp  H+u
HCHP0H|$HHHI~(  H.u
HFHP0IIML;e F  { `  Is 0    }{ d  Is 0  M  ^{ d  Is 0  M  ?{ d  Is 0  M  H
; H9 H	; 	{ d  IPs 0  Mj  z e  M1s 1  N  z e  s /1  5  z e  Ir )1    z f  Mr U1    }z f  Mr R1    az f  Mr G1    Ez f  Mr D1    )z f  Mpr B1    
z e  MTr 51  q  y e  M8r 1  U  y e  Ir 1  M6  y e  Iq 1  IM  y c  Iq 0  M  uy b  Iq 0  M  Vy b  Iq 0  M  H
R H{7 H	R  y b  Igq 0  M  y `  Kq 0  h  x `  2q 0  O  Ld$0x `  q 0  Ll$89  x `  Ip 0    x `  Ip 0    tx `  Ip 0    H|$HH
{ HHup `1    H@HHt L   MtA LHuWp b1  j  H+u
HCHP0H MwII9"  I_H  IIHLHH)uHAP0H LwI9uvHD$HHU A   HEHH] ΏHHuo v1     H+u
HCHP0H|$HI/u	IIP0H/HH!HGP0   t HD$@LHuYo 1  oHXE3HD$HIHIH ID$ AHHu#o 1  9I,$kID$I[HI:HHLn p1  v g  Ld$0Ll$8IH Hu MtI,$uID$IP0HtH/u
HGHP0Lt$8HtH+u
HCHP0MtI.u
IFIP0Lt$@H\$HMtI/u
IGIP0MtI.u
IFIP0HtH.u
HFHP0E3Du H
4 n ?XH\$ UVWATAUAVAWHpH H3HD$`H= MH5 HL5 LLzH|$@IHt$HLt$PH|$XMm  Mt@Ht1Ht"HtH}  Hj0Hl$XLr(Lt$PHr Ht$HHzH|$@I- HIMtHt>HtaH      H  Hl I HtHHD$@HH  Hm I HtHHD$HHHp  Hl I HtLHD$PHHG  HTl I HtHHD$XHH  H. IHD$(LL$@H L|$ y
*     Hl$XLt$PHt$HH|$@   M   H   H   H   H   H
T L|$0IL
/X H?L</ HHiV HMLIH
 HL$(H
k HD$ H	 *  H Hr k "s   A  H
/ U3&Hj0Lr(Hr HzMHl$ LHIVHL$`H3H$   HpA_A^A]A\_^]H\$Hl$Ht$ AVH HA3HMHm L   MtA H|$0HHu'H Hq Lr   j 8*         HHutj :*  sHE Hh HHuH
y H
rq Dj ?*  QHi MH y!j A*   LHHHHuyi B*  H Hq q   H.u
HFHP0HtH/u
HGHP0HtH+u
HSHR0DRq H
, i S33H.u
HFHP0H/u
HWHR0H+u
HSHR0HH|$0H\$8Hl$@Ht$HH A^H\$Hl$Ht$WAVAWHPH! MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt+RHJ  HSh I HtHHD$@HH!  H:h I HtHHD$HHH   H* IHD$(LL$@H Hl$ {y
	*     H|$HH\$@   H   H   H   H
P Hl$0HL
3T H?Lp* HHmR HHLIH
 HL$(H
o HD$ H	! *  H Hn g &o   A  H
* Q3Hz HZLHIJH\$pHl$xH$   HPA_A^_LATAVH   HS H3H$   HE3H; LI[ AIkIsAI{AMkEM{ELD$@HT$ HL$0Ld$(  3g HHu'H Hm 7n   f (  L  HD$0HH(H;
x u0H
' H@' H	' m   ?f (    Hf  HHu'H
C H
<m m   f (    H@H;  tsH;O tjHI HHu'H
 H
l hm   e (  .  H@H   HL$8Hu':m   e (    HHMLd$8H/u
HGHP0HD$8Hu>H| H9CuL;s   HCJ<HI(L;s   J|HIHHH   ILHt
H)uHAP0Hk IL;tIsxUnHMH9M ~IHEL<HAHELIH% 8;l   d (     "l   ld (      HtH HHDt9 H+u
HCHP0HL$ LHl$ H)3  HAP0'  k   c (  jL5m H
j I HHtH IWHHuc 	)   HL$ H DuEc )  9k   H Hj H5  Hm *  HEHP0  Hm u
HEHP0Et[    HHu,HP Lt$ HDj j   c )     HL$ LHT$ HH@HLt$ H=Kn H
i H HHtH HFHH   H Hi Bj   b 0)  Lt$ HtH+u
HCHP0MtIm u
IEIP0HL$(Ht
H)uHAP0HtH.u
HFHP0Di H
N$ b SLG  HCHH0e L   MtA! HHu'H Hh yi   a 2)  2H+u
HCHP0HGHH|k L   MtA HHuH Hh ia 5)    H/u
HGHP0Hl$0HM(H;
P u>H
 H" H	 HH HAh h   	a :)  xHqa T HHu'H
 Hh h   ` <)  =HM(H;
 u4H
y H" H	y H Hg ` @)  =  Hh  LHuj` B)    H IAHL$(H9Cu5HKHL$(Ht'HCHHHH H)uHAP0HL$(   H H9C   HL$HHT$PDEHHH+Lt$PH|$XLl$`HHuH Hf _ S)  lHL$(Ht
H)uHAP0H/Ld$(u
HGHP0Im    IEI   Mo HHuDY_ e)  H
v H
of f   HH/HGHP0HL$(Ht	HHLd$(IE3HHLtEH|ELlM}HHu'H He mf   ^ s)  &H.u
HFHP0H+u
HCHP0ILH)uHAP0H
i zHHu*H IH~e e    F^ )  H@HHb L   MtAP HHu*H1 MH'e e    ] )  cH+u
HCHP0HFHH` L   MtA HHu'H Hd Ae    ] )  *H.u
HFHP0H IAH9Cu+HsHt"HCHHHH H)uHAP0   H5 H9C   HD$0HT$pHD$pDGHD$@HH$   HH+Ht$hHl$x|HHu*H MHc ud    \ )  3H   H.   HFH   O LHu'H Hc d    h\ )  HtHpIHL$0E3HT$@HILGHE HIlGHITI*{HHu'H3 H,c c    [ )  hIm u
IEIP0H+u
HCHP0LL$   H$   H$   H$   H$   MtI/u
IGIP0L$   MtI.u
IVIR0IH$   H3Hĸ   A^A\H\$Hl$Ht$WAVAWHPH1 MHjHH\$@HH\$HLM   Ht"HtH   Hz H|$HHZH\$@I HHHtHt+RHJ  HcZ I HtHHD$@HH!  HJZ I HtHHD$HHH   H IHD$(LL$@H5 Hl$ ny
{(     H|$HH\$@   H   H   H   H
B Hl$0HL
CF H?LT HH}D HHLIH
 HL$(H
 HD$ H	1 (  H H` Y 6a   A  H
 C3Hz HZLHI:H\$pHl$xH$   HPA_A^_@UAWHHHb 3H\$`Ht$hH|$pH L=rb Ll$8LH
#_ Lt$0L5o] I HHtH IY{HLd$@Hu'H H_ T`   X '  }  HCHH7d L   MtA HHu'H H_  `   JX '  )  H+u
HCHP0Hz LfHI9$  H^H  LvHHIIH)uHAP0H MfI9$   A   H\$ HT$ L|$(IwLHu'H H^ M_   W '  v  H+u
HCHP0HH.u
I$HP0I.Hu
IFIP0   U LH  Hb HHX^ ^    W (        HHu'H
% H
^ ^   V '    HXE3IHILx HuLHu'H H] Q^   V '    H/
HGHP0IHsLHH H|] ]   DV '  #  IEIH IEIFIE H IE IF IEHY L   MtA0 HHuU (     H* HH9G  H_H  HwHHHHH)uHAP0HHrHHuU (  DH+u
HCHP0HH/u
HGHP0   ^ HH   DU (  Ha HZ\ \   I.u
IFIP0HtH+u
HCHP0HtH.u
HFHP0HtH/u
HGHP0D\ H
 T  ?fHqHH9T (  [H,T HH HGLw Hw(H H H HG0Hv H Hl HG8Lt$0Ll$8Ld$@H|$pHt$hH\$`MtI/u
IWIR0HHHA_]@UAVH8HBE3H; AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH; t[HHp HHu'H HZ 8[   S F'    H@L   Mu^cS H'  J  HIIMMu>Hr H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HI HHtFLHI6 tH+aHCHP0RFZ   R u'     -Z   wR s'  k# H   H
 LI;   HHD9   }      @t3H2IHV ugR c'  Y   H' H Y HtH/u
HGHP0HtH+u
HCHP0DwY H
@ Q ; = H/u
HGHP0L5 IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH HNU E3H\$0E3HHt$8H
P H|$@:HHu2H- H HX X   HE P &    HXHH
Z HU HAL   MtA HHu'H HW  X   jP &  H  H IH9C   H{H   HsHHHHH)uHAP0HHXmHHu
P &  uH/u
HGHP0IH+u
HCHP0HHue  HHu]H HV eW   O &  {HlHHuO &  H HV 'W   HtD2HX&HHubH HzV V   BO &  H+u
HCHP0HtH/u
HGHP0DV H
 	O @9&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*H} E3HsU U   ;N a&     LHu'HE H>U U   N b&  Z  IFHHHu-H
 Lj H9 H	Z M d&    HAH; tWH; tNHk HHuH
 H
T M i&  ~  H@L   MuahM k&  Q  H3E3H@ Mu>Ht H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA HHtNH+u
HSHR0IVLI3 uH/HGHP0LL &  5  =L &  &  H
- L	 H7 H	 L &      Ht H- HHz,   l H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$hILl$`H A^A\_^[K &  3H/ H(R R   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0DLR H
 J 4H\$Hl$Ht$H|$ AVH HN HH
J E3mHHuH> 7&  H   H
zI HxHH5T L5eS H-FR x HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw` H+u
HCHP0HG?&  H HP eI Q   A  H
 3H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYHtHI  HH [H [@SH HYHtH	  HH [H [H\$Ht$WH HHHIIHH)uHAP0HsHHK H)uHAP0Ht$83H{ H\$0H _H\$Hl$Ht$H|$ ATAVAWHPWMHLD$@M?  LbIMt4HtH*  HZ HzH\$HH|$@HzH\$HH|$@
H\$HH|$@I HIMtHt&DHjG I HD$@HH   HH^G Im HD$HHHtNHH  HE IHD$(LL$@H Ld$ Zy
%     H\$HH|$@   H
 H HD$0   L
L0 HD$(L Hi1 HD$    H	7 %  OHzt}HFL
0 H
W L HD$0H$1 Hy HD$(H	HD$     %  Hz HsM M   ?F A  H
n i0:HzHZ HINH)uHAP0I~HIN H)uHAP0I^ 3L\$PI[ Ik(Is0I{8IA_A^A\HL$SVWATAUAVAWH   HǄ$   HE3L|$@L|$HMHD$@L|$0L|$8MHD$0AL|$PEL|$ EL$   AEHCHu'He H^L L   &E s$     H3  LkL$   HC HD$PIE H Ll$`HD$hIL%SP IH
	K  HHtH INgHHu'H HK NL   D $  )  HCL   HG HMtA HHu'H H|K K   DD $    H+u
HCHP0HFL   HYN HMtA> HHu-H HK K   C $  MM  H.u
HFHP0IL$   LcH I9$h  HsH$   HS  LkHIE HIH)uHAP0MeHk I9$u}H$   H$   H$   A   H$   I/cHHu'HH HAJ J   	C $    H.u
HFHP0IL$          LHu'H HI eJ   B $  @  HpIL$   H$   H IF E3IIaHHu'H HI 
J   TB $    I.uFIFIP0:IHn_HHu'HG H@I I   B $    H+u
I$HP0HGHL H;1  H; $  H HHu*H HH UI   A $  MB  H/u
HGHP0IHFL   MHAHMHtlA   HALHtXHAHZy'H\ HUH H   A $    L).u
HFHP0IL$      H.u
HFHP0IZuI[H HG iH   @ %  D  HOHtU~A   H, H
2 H		 
Hx%[H HG 
H   W@ $  M  H;u
Lw H_H_LsHHIH/u
HGHP0LH$   L|$xMLt$pMHHL$ #&  HHD$@H;tTHT$@HRHL$@EHD$@H@HD$@H HD$@H@L|$HHL$@HHD$@HHL$HHCHD$HHKH|$ HWHL$ oEHD$ H@HD$ H HD$ H@L|$(H|$ HcIHL$   HHD$0H;tTHT$0HRHL$0BHD$0H@HD$0H HD$0H@L|$8HL$0HHD$0HHL$8HCHD$8HKLD$ MM HT$XHL$ [    DBoHL$ XHL$PN&u2[ Ht'H HE 6F   > %%  H    eHD$XLD$0HT$@HvH$   HAH   E3HfH H
A :]HHu'HC H<E E   > ?%     E33HOH+u
HCHP0H HD vE   = C%     H$      HD$`H$   HL$hHL$PH$   HD$ HD$pH$   H\$xHH$   LHtH+u
HCHP0HtH/u
HGHP0Ld$ L$   HtH.u
HFHP0MtI.u
IFIP0H$   DD < H
 $'AHtH/u
HGHP0HL$PHt
H)uHAP0MtI,$uID$IP0MtIm uIEIP0LD$0MM H$   HL$0   DBoHL$0LD$@MM H$   HL$@   DBoHL$@AHĠ   A_A^A]A\_^[H\$Ht$WH IHHMt-I H~HLuH\$0Ht$8H _HHHH+u
HSHR0H\$0Ht$8H _HLH L@HHSVWATAUAVAWH  H@LE3L|$`L|$hL$   L$   L|$HL|$P8CHD$HL|$8L|$@$CHD$8L$   L|$(L$   EAW$   L$   H9F HH
@  HHtH H4]HHu'H HA 4B x  ~: !  \  HGL   H= HMtA LHu'Hi HbA A x  *: !    H/u
HGHP0IFL   H?D IMtA$ HHu'H H@ |A x  9 !    I.u
IFIP0ML$P  LgH I9$X  LwL$P  MC  H_IHHHH)uHAP0LcHX I9$uuL$   L$   A   H$   H$YHHu'H= H6@ @ x  8 !    I.u
IFIP0ML$P         HHu'H H? Z@ x  8 	"    LpML$P  IE Lh E3HHWHHu'H H? @ x  P8 "  .  H.uFHFHP0:IHjUHHu'HC H<? ? x  8 !    H/u
I$HP0IHCHE H;(  H;   H LHu'H H> N? x  7 4"  ^  H+u
HCHP0IFH   MIHIHtjA   IHHtWIHPy'H^ HW> > x  7 <"    M)&u
IFIP0ML$P     I.u
IFIP0MPuIQH H= k> x  6 D"    HKHtR~A   H" H
4 H	 
Hx'QH H= > x  Y6 "    H;u
Hs H{H{HwH?HHH+u
HCHP0HHD$`H$   IHt$hH$   I  HH$   3A  H8HpLH$   (  HH$   3A(  H HH$   M   E3H= H
.9 THHu'H H< = |  K5 {"  >
  E33HFH+u
HCHP0HF H?< < |  5 "    H   E3Hk= H
8 SHHu'H H; o< ~  4 "    E33HcFH+u
HCHP0H H; +< ~  u4 "  h  H= H$`  o Hu'Hs Hl; ;   44 "  '  H$   H
; wPHHu'H0 H); ;   3 "    H@L   H; HMtA HHu'H H: S;   3 "  f  H+u
HCHP0HFH;    H;Ի t~HH$   LH HHu'Hk Hd: :   ,3 "    H@L   Mu?H4 H-: :   2 "  
  HHMMHǄ$   H.uHFHP0@ Mu?H IL|$0H9CuL;c   HCJ4L;c}zJtHI  HAHHD$0H   HtHH HHtι *H] HV9 9   2 "  I	  H+u
HCHP0H$`  LHL;
 tRH; tIMILq H H
 H	J H H8 Z9   1 #  	  HH$      HT$`HL$p  HHD$HH;tTHT$HHRHL$HL7HL$HHIHL$HH	HD$HH@L|$PHL$HHHD$HHHL$PHCHD$PHKH|$pHWHL$p6HD$pH@HD$pH HD$pH@L|$xH|$pHHT$hHL$p  HHD$8H;tTHT$8HRHL$8m4HL$8HIHL$8H	HD$8H@L|$@HL$8HHD$8HHL$@HCHD$@HKLD$pMM HT$ HL$p   DBoHL$p  ,HD$ LD$8HT$HH=LM   E3H: H
3 OHHu'H H
7 7   / P#    E33HAH+u
HCHP0Hп H6 G7   / T#    IL|$ L$h  L;%   3# HHu'H| Hu6 6   =/ q#  0  ID$H;X t~H; tuIܷ HHu*H- H&6 6   . w#  I  H@L   MuAH H5 j6   . y#  Iz  II$IH$   MHMu@H H9FuH;N   HFH<H;N   H|HHH$   HAHHD$ H9  H$   H$   Ht
H)uHAP0HGL   H7 HMtA" HH   E3H5 HLLHt~H/u
HGHP0IIH  u5I.u
IFIP0ML$P  H$   IL|$    H H4 5   O- #    Hg H`4 4   (- #    H@ H94 4   - #     HtEH HHk
ta 'H H3 g4   , #  z  H.u
HFHP0IL|$0H$   LcIu'H H3 4   `, #  S  HT$pI芃HXH+HHL$pL;t|H$   HL$pHH$   莵HL$p贴 Ht'H H3 3   + #    H$   HL$pHI%L$   H$   HI9DH$   	  Hu'H H2 3   f+ #  Y  HD$(Ht  HHu'Hi Hb2 2   *+ #    HD$(HH8H)uHAP0HD$(HX8H$   HtH
}(  HMtID$P  A: HHu'Hۺ H1 R2   * $        HHu'H H1 2   b* $  +  HXH\$(HHX   E3H$   HL$`L$   Ld$hL|$(AH|$ L$P  Ht$0  E3H$   HL$`L$   Ld$hL|$(AAL$P  Ht$0  H$   LH$   HtH)u
HAP0LIIAL   H0 IMtA HHu'H H0 1   X) "  !  ML$P  H H9G   LwL$P  MttHwIHHHH)uHAP0IH:FHHu'H H0 0   ( #     I.u
IFIP0ML$P  4HEHHu$H H/ 60   ( #  LH/HGHP0H$   HT$`E3H$   L$P  AAL|$(HT$hIHtH+u
HCHP0HtH/u
HGHP0MtI.u
IFIP0HtH.u
HFHP0D/ ' H
 IH\$(HL$`Ht
H)uHAP0HL$hHt
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0H$   Ht
H)uHAP0HtH+u
HCHP0H$   HtH)uHAP0H$   Ht(H$   HgL$   L+IHLD$8MM H$P  HL$8K   DBoHL$8HLD$HMM H$P  HL$H
   DBoHL$HHH  A_A^A]A\_^[H\$UVWAVAWH`Hw H3HD$XH5: WHt$PMHD$@Me  LzIMt3Ht"HtH[  Hr(Ht$PHB HD$HHjHl$@Hl$@I HIMtHt,HtCjH% I HD$@HH   HH% I HD$HHtwHHr  H% Im HtHHD$PHHI  H IHD$(LL$@Hy L|$ 8y
!     Ht$PHl$@  H
 H HD$0   L
, HD$(L8 Hi HD$    H	7 !  xHBH   H   HCHM
 3HD$0HL
 L HHH^ HD$(HL$ LMH

 H H	 !  HQ HJ+ + r  $ Ar  H
 @3!Hr(HB HjHD$HLD$HLHkHL$XH3nH$   H`A_A^_^]H\$Ht$WH H5* HH
) H HHtH HFHHu'H H* + p  L# D!     H H9CuHH  HHuH
A H
:* # F!  .E3HHBHHurH H
* " H!  ~* p  H/u
HGHP0HtH+u
HCHP0DR* H
 " 3H\$0Ht$8H _H/u
HWHR0H+u
HSHR0HH\$0Ht$8H _@UVWATAUAVAWHl$H0  HEH$  HIs H3HE(LHUHHL$pHME3D|$PL|$8L|$@)HD$8EL|$HL;L{)HD$P   AAAWEWMEHE   L}D}ID$H; tsH;ѩ tjIL|$XI LHD$`Hu'Hi Hb( ( i  *!      H@H   HD$hHun!      MLd$`I$L|$X3HD$hD  Hu=H I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03H 98uIE        II\ HH  H@L   H~' HMtAK HH|  H/u
HGHP0HCL   H& HMtA
 HH   H+u
HCHP0II¦ HH  H@L   H' HMtA HH  H+u
HCHP0   Z HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM譔HHMaHUHtLE L+IXWEH] HUHtLEL+Iu H  IHMHHM謲HME H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
A  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8#H]HUHK@蒒HKXHULt$`L|$XLmLeHD$hyH) H
 H	 $ j  2    33B  $ l      )  $ l        $ k         $ k         g$ k      3   L$ k      3   1$ k  {    3   $ k  `    33s H   H
x LI;   HH    }      @t3HIH;        33# i  H H" MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
 3H\$pc I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8H諓MtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+HsѠ H'vĠ HHE   HE    E HUHtLEL+IHUHtLEL+ILD$8MM HUHL$8   DBoHL$8HHM(H3H$  H0  A_A^A]A\_^]@UVWATAUAVAWHl$H0  HEH$  Hj H3HE(LHUHHL$pHME3D|$PL|$8L|$@!HD$8EL|$HL;L{w!HD$P   AAAWEWMEHE   L}D}ID$H;B tsH;q tjIL|$XI LHD$`Hu'H	 H    W       H@H   HD$hHun     MLd$`I$L|$X3HD$hD  Hu=H I9FuM;~\  IFJ<M;~H  K|HIL|$XIHH7  ILH}Ht
H)uHAP03H( 98uIE        II HH  H@L   H HMtA HH|  H/u
HGHP0HCL   He HMtA HH   H+u
HCHP0IIb HH  H@L   Hd HMtAQ HH  H+u
HCHP0    HHS  HxHp 33HL$HHD$HHtH)u
HAP0H3HHM譕HHMQHUHtLE L+IWEH] HUHtLEL+I H  IHM舣HHMLHM賩 H_  L|$8II@8w   LeLuLmfHO HUIICHqHyrH	H6MI;LBMt
  ty
I;rHH?H tI;tBHS HzHzrHHMIICH?LL;MBMt
  tx;L;s6HEHD$xLD$xHL$8LH HD$ LHUHL$8#H]HUHK@袡HKXHU蕡Lt$`L|$XLmLeHD$hyH  H
[ H	"  X      33B  k Z   @   )  R Z   ?     9 Y   -        Y  j *       Y  Q (   3    Y  6 %   3    Y   "   3    Y        33s H   H
 LI;   HH    }      @t3HIH۞       333 W  H H MtI.u
IFIP0HtH/u
HGHP0HtH+u
HCHP0HtH.u
HFHP0H
Z *H\$pc I.u
IFIP0HD$8H\$pH;t>HHRHHH@HH HH@HC    DD$0HT$8HMtIm u
IEIP0HL$HHtH)uHAP0HEHrPHHMH=   r<t HAH;r H+Hsq H'vd H3HE   HE    E HUHtLEL+IfHUHtLEL+IMLD$8MM HUHL$8C   DBoHL$8PHHM(H3AH$  H0  A_A^A]A\_^]HUVWATAUAVAWHhH   HEHX)p)xHb H3HELL3H|$PH|$X>HD$PH|$@H|$H*HD$@H}H}HE   H}@}DH|$0L;= uELU H H
 H	B H۠ H R 	   m  X  L- H Ię HHu7& HuI'H H~  	  F o  X  HHDu$ܙ Ht 	   q  I  H/u
HGHP0E,$L;= u>H H
 H	 H H j 
   ~  X  H I  HHu'H H , 
  v   W  HDu$ Ht 
  B   ?H  H/u
HGHP0El$L;=- u>H H
՘ H	ܗ H% H       8W  H~ I.  HHu'H H ^      V  HHMӛHHM藢HM0 Ht   c   `G  H/u
HGHP0IL$HEH;tIE3HU,L;=5 u>H4 H
ݗ H	 H- H&    
   @V  H I6  HHu'H H f   
   V  H H;uA   (H(Dy*   t
   qF  H/u
HGHP0E+  H
 )HHu'H_ HX  
   
   rU  H@L   H5 HMtA* LHu 
     T  H+u
HCHP0IFL   H IMtAԕ HHu'H H , 
  v   T  I.u
IFIP0E3L;=c u0H H
 H	  
  *   T  H Ir  LHu 
     S  3HL$0LkH/ I9E -  HSHT$0H  H{HHHHH)uHAP0HT$0LoH I9E uYHULuA   HUHv+HHu 
  ^   LS  HL$0H)uHAP03HL$0      4 HHu'H
E H
>  
     S  HL$0HH3HL$0Lp E3E3HH)HHuv 
  
   R  H.uEHFH9IH'HHu; 
  
   sR  I.u
IFIP0H+u
IE HP03HGH H;   H;o    H LHu 
  
 
  3C  H/u
HGHP0IFH   E3IH3HtPDnIHHt?IH2#yd 
  	   Q  M).   IFI   I.u
IFIP0E38#uI$ 
  \	   JQ  HOHtF~A   Hb H
ۑ H	 
Hx# 
  	   3B  H;u
Hw H_H_HsHHHH/u
HGHP0H]HuHHMHHL$PrLEMM HT$8HM   DBoHM(HHMLHHL$@߉LEMM HT$8HM   DBoHMIL$(HT$PvIL$8HT$@L;=0 u@Ho H
ؑ H	ߐ H( H!     X  3
P  H I/  HHu)H H _    Z  3O  H H9GuwH (=1 f.z*u(  Ht	   S \  33I@  H/u
HGHP0At$HL;=8 u@H H
 H	 H0 H)     i  3O  H_ I7  HHu)H H
 g    k  3N  HHMړHHM螚HM7 Ht    j m  33`?  H/u
HGHP0IL$XHEH;tIE3HU/L;=8 u@H H
 H	 H0 H)
 
    z  3N  H	 I7  HHu)H H g
    |  3M  HÀu(F Ht/
   y ~  33o>  H/u
HGHP0A\$xL;=` u@H H
 H	 HX HQ       3=M  H I_  HHu)H H       3L  HÀu(n HtW      33=  H/u
HGHP0A\$yL;= u@H H
0 H	7 H Hy    A   3eL  H I臹  HHu)H@ H9       3%L  H@L   HD HMtA	 HHuo      3<  H/u
HGHP0HVF Ht'H H
 !   k   K  H.u
HFHP03A\$|L;=T u>H H
 H	 HL HE
 
   
   3K  H
 IU  HHu'H H
 
      J  HHMHHM辖HM%W Ht'H H	 2
   |   J  H.u
HFHP03I$   HEH;tIE3HU@L;=I u>H  H
 H	 HA H:	 	      (J  HJ IJ  HHu'H H z	      I  HÀu2[ Ht'H H 6	      I  H.u
HFHP03A$   L;=f u>HE H
 H	 H^ HW       EI  H Ig  HHu'H  H        I  H
Q ,HHu'H H \       H  H@L   H HMtA HHu   `    Z9  H/u
HGHP0A   HH HHu       H  H.u
HFHP03H+u
HCHP03HDy      8  H/u
HGHP0E!  L;= u>H H
` H	g H H '   q   G  H I蹴  HHu'Hr Hk    3   YG  H	 H2 HHu      7  H/u
HGHP0Hr H HHuw      F  H+u
HCHP03HDu$H Ht1   {   u7  H/u
HGHP0E$   L;=c u>H H
 H	 H[ HT       BF  H Id  HHu'H H       F  H H݄ HHuc      6  H/u
HGHP0H5 H HHu"   l 	  WE  H+u
HCHP03HDu$ Ht   &    6  H/u
HGHP0E$   L;= u>He H
 H	 H H }      D  HG I  HHu'HȌ H ?      D  Hq H HHu   X   R5  H/u
HGHP0H HG HHu       D  H+u
HCHP0HGL   HL HMtA HHuw    #  4  H/u
HGHP0HP Ht9    &  nC  H+u
HCHP0A$   L;=k u>H H
 H	 Hc H\    $ 3  JC  H Il  HHu'H% H     5  C  H H HHuk    7  B  H+u
HCHP0H] H HHu*   t :  n3  H/u
HGHP0Hu$ Ht   1 =  B  H+u
HCHP0A$   L;= u>H H
 H	Ȃ H H
     J  A  HR I  HHu'HӉ H  J    L  A  H| H HHu   c N  NA  H+u
HCHP0H;  HR HHu    " Q  2  H/u
HGHP0Hau$ Ht     T  @  H+u
HCHP0A$   L;=ǁ u>H H
o H	v H H 6     a  @  H  Iȭ  HHu'H Hz    B c  h@  H* HA HHu    e  ?  H+u
HCHP0Hy H  HHu    h  0  H/u
HGHP0HϽ@@u$U Ht>    k  s?  H+u
HCHP0A$   L;=p u>Hg H
 H	 Hh Ha     ) x  O?  H  Iq  HHu'H* H#      z  ?  H  H} HHup     |  >  H+u
HCHP0H: H} HHu/    y   s/  H/u
HGHP0Hu$ Ht    6   !>  H+u
HCHP0A$   L;= u>H= H
 H	~ H H  !     =  HW I  HHu'H؅ H O !     =  H H| HHu !  h   S=  H+u
HCHP0H HW| HHu !  '   !.  H/u
HGHP0Hfu$~ Ht !     <  H+u
HCHP0A$   L;=} u>H H
t~ H	{} HĄ H ; "     <  H Iͩ  HHu'H H  "  G   m<  H/ HF{ HHu "     <  H+u
HCHP0H H{ HHu "     ,  H/u
HGHP0HԹ@@u$Z} HtC "     x;  H+u
HCHP0A$   L;=u| u>H H
} H	$| Hm Hf  #  .   T;  H Iv  HHu'H/ H(  #     ;  H Hy HHuu #     :  H+u
HCHP0H Hy HHu4 #  ~   x+  H/u
HGHP0Hz H9CusHx{ (f.z&u${ Ht #  "   
:  H+u
HCHP0A$   L;={ u>H H
{ H	z H  H w $     9  HA I	  HHu'H H 9 $     9  Hk Hx HHu $  R   =9  H+u
HCHP0H HAx HHu $     *  H/u
HGHP0HIy H9CusHz (f.z&u$z Htk $     8  H+u
HCHP0A$   L;=y u>HZ H
Cz H	Jy H H 
 %  T   z8  H I蜥  HHu'HU HN  %     <8  H Hw HHu %     7  H+u
HCHP0Hm Hv HHuZ %     (  H/u
HGHP0Hw H9CusHx (f.z&u$y Ht %  H   37  H+u
HCHP0A$   L;=.x u>H H
x H	w H& H  &     
7  Hg I/  HHu'H~ H _ &     6  H Hu HHu. &  x   c6  H+u
HCHP0H Hgu HHu &  7 	  1'  H/u
HGHP0Hu$w Ht &     5  H+u
HCHP0A$   L;=v u>H H
w H	v H} H K '     5  H Iݢ  HHu'H} H 
 '  W   }5  H? HVt HHu '  &   5  H+u
HCHP0Hv Ht HHu '      %  H/u
HGHP0Hdu$ov HtX '   #  4  H+u
HCHP0A$   L;=u u>H H
2v H	9u H| H{  (  C 0  i4  H I苡  HHu'HD| H=  (   2  +4  H Hs HHu (   4  3  H+u
HCHP0Hd Hr HHuI (   7  $  H/u
HGHP0Hu$u Ht (  P :  ;3  H+u
HCHP0A$   L;=8t u>H H
t H	s H0{ H)  )   G  3  Hq I9  HHu'Hz H i )   I  2  H Hq HHu8 )   K  m2  H+u
HCHP0H Hqq HHu )  A N  ;#  H/u
HGHP0Hyr H9CusH;s (f.z&u$s Ht )   Q  1  H+u
HCHP0A$   L;=r u>HR H
ss H	zr Hy H : *   ^  1  H I̞  HHu'Hy H~  *  F `  l1  H. HEp HHu *   b   1  H+u
HCHP0H Hp HHu *   e  !  H/u
HGHP0HCL   H	 HMtAq HHu4 *  ~ h  i0  H+u
HCHP03H[D
r Ht *  = k  7!  H/u
HGHP0E$   L;=%q u>HԞ H
q H	p Hx H  +   x  0  H^ I&  HHu'Hw H V +   z  /  H Hn HHu% +  o |  i   H/u
HGHP0H H^n HHu +  .   /  H+u
HCHP03Hdo H9GuwH&p (f.z&u$p Ht +       H/u
HGHP0A$  L;=o u>H H
^p H	eo Hv H % ,  o   .  H I跛  HHu'Hpv Hi  ,  1   W.  H H0m HHu ,        H/u
HGHP0Hx Hl HHuu ,     -  H+u
HCHP03Hm H9GuwHn (f.z&u$.o Ht ,  a   [  H/u
HGHP0A$  L;=Gn u>HF H
n H	m H?u H8  -      &-  H IH  HHu'Hu H x -     ,  H Hk HHuG -       H/u
HGHP0H Hk HHu -  P   ;,  H+u
HCHP0H
`  HHu -     
  H@L   H HMtAm HHu -       H+u
HCHP0A   HHl HHu@ -       H/u
HGHP0H.u
HFHP03Hwy -  A   ,+  H+u
HCHP0g  L;=)l u>HP H
l H	k H!s H  .     +  Hb I*  HHu'Hr H Z .     *  H Hi HHu) .  s   ^*  H+u
HCHP0H Hbi HHu'Hcr H\  .  $   J*  H.u
HFHP03Hau$k Ht .     )  H+u
HCHP0A$  :*  L;=j u>H H
jk H	qj Hq H 1 /  {   )  H IÖ  HHu'H|q Hu  /  =   c)  H% H<h HHu /     (  H+u
HCHP0H Hg HHu'Hp H s /     (  H.u
HFHP0H
 HHu6 /     k(  H@L   H HMtAi HHu /  :   %(  H.u
HFHP0A   HHh HHu /       H+u
HCHP03H/u
HGHP0Hy'Ho H V /     '  H.u
HFHP03'  L;=h u>H H
.i H	5h H~o Hw  0  ?   e'  H I臔  HHu'H@o H9  0     ''  H H f HHu'Ho H x 0   	  &  H.u
HFHP0H He HHu7 0     {  H/u
HGHP0Hf H9FuvH{g (f.z4u2g Ht'HVn HO  0     =&  H.u
HFHP0A$   p&  L;=f u>H H
g H	f Hm H g 1   0  %  H I  HHu'Hm H ) 1  s 2  %  H
 HHu'Hwm Hp  1  8 4  ^%  H@L   HE HMtABf HHu 1   6    H/u
HGHP0A   HH7e HHue 1   9  $  H.u
HFHP03H+u
HCHP03H蚢Dy 1  c <  ]  H/u
HGHP0E  L;=Je u>H H
e H	d HBl H;  2   I  )$  H IK  HHu'Hl H { 2   K  #  H5 Hb HHuJ 2   M    H/u
HGHP0H Hb HHu	 2  S P  >#  H+u
HCHP03HDu$d Ht 2  
 S    H/u
HGHP0E$   L;=c u>H H
d H	c Hj H d 3   `  "  H. I  HHu'Hj H & 3  p b  "  H Hoa HHu 3  ? d  9  H/u
HGHP0H H.a HHu 3   g  !  H+u
HCHP03H;Du$c Htn 3   j    H/u
HGHP0E$   L;=b u>H H
Hc H	Ob Hi H  4  Y w  !  H I衎  HHu'HZi HS  4   y  A!  H H` HHu 4   {    H/u
HGHP0Hj H_ HHu_ 4   ~     H+u
HCHP0HGL   H HMtAa HHu	 4  S   M  H/u
HGHP0HRa Ht 4         H+u
HCHP0A$   L;=` u>H< H
a H	` Hg H l 5       H6 I  HHu'Hg H . 5  x     H Hw^ HHu 5  G   2  H+u
HCHP0H/ H6^ HHu 5        H/u
HGHP0H@@u$` Htt 5       H+u
HCHP0A$   L;=_ u>H
 H
N` H	U_ Hf H  6  _     H I觋  HHu'H`f HY  6  !   G  H H ] HHu 6       H+u
HCHP0H8 H\ HHue 6       H/u
HGHP0H] H9CusH^ (f.z&u$ _ Ht	 6  S   >  H+u
HCHP0A$   L;=9^ u>Hȍ H
^ H	] H1e H*  7       Hr I:  HHu'Hd H j 7       H$ H[ HHu9 7     n  H+u
HCHP0H Hr[ HHu 7  B   <
  H/u
HGHP0Hz\ H9CusH<] (f.z&u$] Ht 7       H+u
HCHP0A$   L;=\ u>H H
t] H	{\ Hc H ; 8       H I͈  HHu'Hc H  8  G   m  H HFZ HHu 8       H+u
HCHP0H. HZ HHu 8       H/u
HGHP0H
[ H9CusH[ (f.z&u$F\ Ht/ 8  y   d  H+u
HCHP0A$   L;=_[ u>H> H
\ H	[ HWb HP  9     >  H I`  HHu'Hb H  9        HJ HX HHu_ 9       H+u
HCHP0H HX HHu 9  h   b
  H/u
HGHP0HY H9CusHbZ (f.z&u$Z Ht 9       H+u
HCHP0A$   L;=Y u>H H
Z H	Y H` H a :       H+ I  HHu'H` H # :  m     H HlW HHu :  <   '  H+u
HCHP0H H+W HHu :       H/u
HGHP0H3X H9CusHX (f.z&u$lY HtU :       H+u
HCHP0A$   L;=X u>H H
-Y H	4X H}_ Hv  ;  >   d  H I膄  HHu'H?_ H8  ;      &  Hp HU HHu ;       H+u
HCHP0HW HU HHuD ;   "    H/u
HGHP0HV H9CusHW (f.z&u$W Ht ;  2 %    H+u
HCHP0A$   L;=W u>Ho H
W H	V H^ H	  <   2    HQ I  HHu'H] H I <   4    H HT HHu <  b 6  M  H+u
HCHP0H HQT HHu <  ! 9    H/u
HGHP0H`u$V Ht <   <    H+u
HCHP0A$   9  L;=U u>H@ H
iV H	pU H\ H 0 =  z S    HR I  HHu'H{\ Ht  =  < U  b  H
 HHu =   W    H@L   H HMtAU HHu =   Y    H/u
HGHP0A   HHT HHu< =   \  q  H+u
HCHP03H.u
HFHP03HqDy =  : _  4  H/u
HGHP0E  L;=!T u>HȄ H
T H	S H[ H  >   l     HZ I"  HHu'HZ H R >   n    HL HQ HHu! >  k p  e  H/u
HGHP0H HZQ HHu'H[Z HT  >   s  B  H.u
HFHP03HRR H9GuwHS (f.z&u$S Htt >   v    H/u
HGHP0A$   L;=R u>Hs H
LS H	SR HY H  ?  ]     H I~  HHu'H^Y HW  ?     E  H HP HHu ?       H/u
HGHP0HV HO HHu'HX H U ?       H.u
HFHP03HP H9GuwHQ (f.z&u$R Ht ?  A   ;  H/u
HGHP0A$     L;="Q u>H H
Q H	P HX H  @       H I#}  HHu'HW H S @       H

 HHuz   mH@L   H HMtAP HHuA   4H.u
HFHP0A   HHO HHuG    @  E3HW H H  H/  HGHP0  H/u
HGHP0H+u
HCHP0H؅y'HV H 4 @  ~     H.u
HFHP03  L;=dO u>H H
P H	O H\V HU  A     C  H Ie{  HHu'HV H  A       H HL HHu'HU H V A     
  H.u
HFHP0H  HL HHu A  _   J
  H+u
HCHP0HFL   H HMtAYN HHu'H:U H3  A     !
  H.u
HFHP03HN Htq A       H+u
HCHP0A$   L;=M u>H~ H
KN H	RM HT H  B  \     H Iy  HHu'H]T HV  B     D  H HK HHu B       H+u
HCHP0H] HJ HHu'HS H T B       H.u
HFHP03H۫u$&M Ht B  Y   D  H+u
HCHP0A$   L;=AL u>H} H
L H	K H9S H2  C        Hz IBx  HHu'HR H r C     
  Ht HI HHuA C     v
  H+u
HCHP0H{ HzI HHu'H{R Ht  C  <   b
  H.u
HFHP03Hyu$K Ht C     	  H+u
HCHP0A$   L;=J u>Hv| H
K H	J HQ H N D     	  H Iv  HHu'HQ H  D  Z   	  H HYH HHu D  ) 	  	  H+u
HCHP0H	 HH HHu'HQ H  D      	  H.u
HFHP03Hu$bJ HtK D       H+u
HCHP0A$   L;=}I u>H<{ H
%J H	,I HuP Hn  E  6   \  H I~u  HHu'H7P H0  E       H HF HHu} E  ǿ      H+u
HCHP0H HF HHu'HO H . E  x #    H.u
HFHP03H赧u$ I Ht E  3 &    H+u
HCHP0A$   L;=H u>Hz H
H H	G HO H  F  Ծ 3    HT It  HHu'HN H L F   5    HN HE HHu F  e 7  P  H+u
HCHP0H- HTE HHu'HUN HN  F   :  <  H.u
HFHP03HSu$G Ht F  ѽ =    H+u
HCHP0A$   L;=F u>Hx H
aG H	hF HM H ( G  r J    H Ir  HHu'HsM Hl  G  4 L  Z  H H3D HHu G   N    H+u
HCHP0Hs HC HHu'HL H j G   Q    H.u
HFHP03HD H9CusHE (f.z&u$#F Ht G  V T  A  H+u
HCHP0A$   L;=<E u>Hsw H
E H	D H4L H-  H   a    Hu I=q  HHu'HK H m H   c    Ho HB HHu< H   e  q  H+u
HCHP0HF HuB HHu'HvK Ho  H  7 h  ]  H.u
HFHP03H4@@u$D Ht H   k    H+u
HCHP0A$   L;=C u>H4v H
}D H	C HJ H D I   x    H Io  HHu'HJ H  I  P z  v  H HOA HHu I   |  
  H+u
HCHP0H HA HHu'HJ H  I  й     H.u
HFHP03HB H9CusHB (f.z&u$?C Ht( I  r   ]  H+u
HCHP0A$   L;=XB u>Ht H
 C H	B HPI HI  J     7  H IYn  HHu'HI H  J  Ӹ      H H? HHu      H+u
HCHP0H H? HHu'HH H  J  ]      H.u
HFHP03H蚠   A H       J  E3H*H H# HtH+u
HCHP0MtI.u
IFIP0HL$0Ht
H)uHAP0HtH.u
HFHP0H
~s )H+u
HCHP0A$   HMHt
H)uHAP0HMHtH)uHAP0HMJLD$@MM HT$8HL$@x   DBoHL$@oLD$PMM HT$8HL$Py   DBoHL$PoHMH3cL$   I[PA(sA({IA_A^A]A\_^]HUVHhH8  3HXHxL`LLhDLpDLxDHt$xHt$8HuHt$(= Hu'H{F Ht     <     LHD$0}= Hu'HAF H:          A$H؉MXHD$ |> HHu'HE H t     (  M     > HHuH     *  ><  HxE3H
< HHHu    [ /  &>  H+u
HCHP0HC LI< yѼ     2  ;  H/u
HGHP0AL$M`= HHu,H
E H\$ H     ɴ <  X  H! LI
< yO     >  E;  H/u
HGHP0IL$DHHu,HD H\$ H     K H    H LI; yѻ     J  :  H/u
HGHP0AD$H< HHu,HD H\$ H     ʳ T  Y  H LI; yP     V  F:  H/u
HGHP0A8t$PtH= H H== H; H H=; Hu,HrC H\$ Hf     . `    H LIr: y     b  9  H/u
HGHP0A8t$xtH/= H H=%= H$; H H=; Hu,HB H\$ Hʹ H     l  !  Hj LI9 y    b n  9  H/u
HGHP0A8t$yt~IL$XBHHu,HQB H\$ HE ù    
     H} LIQ9 y    ݱ   8  H/u
HGHP0A8$      I$   BHHu,HA H\$ H 4    ~   
  H^ LI8 y    N   7  H/u
HGHP0H
 HHu,HBA H\$ H6          AL$|Mh_: LHu'H
 A H
 w       9  H9 LkHt$(I9E   HSHT$(H  H{HHHHH)uHAP0HT$(Hk; LoI9E   HUA   HUL}H;HHuٷ    #   8  HL$(H)uHAP0Ht$(I/u
IGIP0H+u
IE HP0H
\ LH|$x/HH=  H? Hݶ [       H\$ LLl$0HL$(Ht
H)uHAP0MtI.u
IFIP0D H
Jb X 菙$     G8 LHu'H
X? H
Q ϶       7  HL$(E3HHILx HHt$(LHHu    ծ   7  I.IFIIHHHE       Z7  H@HH L   MtA7 HHu    I   4  H/u
HGHP0A   HI6 HHu       6  H+u
HCHP0Ht؅y    ϭ   u4  H/u
HGHP0  IFIH L   MtA6 Ll$0HHu/H= LH\$ H     V   H. LI4 yܴ    &   3  H/u
HGHP0A$   L$@s6 HHu/H= LH\$ H     ͬ   0HM LI4 yS       C3  H/u
HGHP0A$   L$H5 HHu/H< LH\$ H|     D   H LI3 yʳ       2  H/u
HGHP0A$   L$Pa5 HHu/H< LH\$ H q     (  H LI2 yA     *  12  H/u
HGHP0A$   L$X4 HHu/Hy; LH\$ Hj     2 4  Hʮ LIv2 y     6  1  H/u
HGHP0LB3 IH 22 y/H: LH\$ H ^     @  A8$   tH4 H H=4 H2 H H=2 H\$ Hu*H: LH~     F I  H LH1 y̱    L K  L0  H/u
HGHP0A$   2 HHu*H : LH t     U  !H LH1 yD    L W  L90  H/u
HGHP0A$   G2 HHu*Hx9 LHn     6 a  H LHz0 y    L c  L/  H/u
HGHP0A$   1 HHu*H8 LH d     m  HF LH/ y4    L{ o  L)/  H/u
HGHP0A$   L$`0 HHu*Hf8 LH\ گ    $ y  H̰ LHh/ y    L {  L.  H/u
HGHP0A$   L$h[0 HHu*H7 LHҮ P       H LH. y     Lg   L.  H/u
HGHP0A$   L$p/ HHu*HR7 LHH Ʈ       sH LHT. y    Lݦ   L-  H/u
HGHP0A$   / HHu*H6 LH >       H LH- y    LU   L-  H/u
HGHP0A$  / HHu*HB6 LH8         cH@ LHD- y    Lͥ   L{,  H/u
HGHP0A$  . HHu*H5 LH .    x   H  LH, y    LE   L+  H/u
HGHP0H
R }HHu/H65 LH\$ H'        RA$   MM. LLHup       -  H, LkI9E Z  L{MM  H{HIHHH)uHAP0Hs/ LoI9E    A   L}HULuHCHHu    +   ,  I/u
IGIP0LI.u
IFIP0H+u
IE HP0HGHH L   M   A      , HD$(HuZ       o,  LxE3Lp HHLLHHu    g   2,  HL$(H)uHAP0Ht$(CIHwHHѪ       +  D, HHu       )  H/u
HGHP0Ll$0LH< I#* ye       w+  HLH\$8HHu
HCHP0H
 ݾHHu*H2 LH 
    T   B+  H@HHM L   MtA^+ HHuĩ       *  H+u
HCHP0A   HIS* HHu    ˡ   t(  H/u
HGHP0HgyJ     	  \*  H+u
HCHP0tyA$  M* HHu*H1 LHu     =   +*  H LHL$ (          )  H
' RHHu*H1 LH     ɠ *  )  H@HHj L   MtA) HHu9     ,  K)  H+u
HCHP0A   HI( HHu    @ /  &  H/u
HGHP0H?fy    	 1  (  H+u
HCHP0txA$   ( HHu*H/ LH i     <  (  Hۣ LHL$ &   3    } >  E(  H
 ȻHHu*H/ LHw     ? R  -(  H@HH L   MtAI( HHu     T  '  H+u
HCHP0A   HI>' HHul     W  _%  H/u
HGHP0Hdy7     Y  I'  H+u
HCHP0H
 輺HHu*Hu. LHk     3 q  !'  H@HH L   MtA=' HHu     s  &  H+u
HCHP0A   HI2& HHu`     v  S$  H/u
HGHP0Hcy)    s x  ;&  H+u
HCHP0L9	  H
 裹HHu'H\- HU Ӥ       &  A$   M{& HD$(LHu       #  H&% LgI9$W  LwMJ  H_HIHHH)uHAP0H' LcI9$   A   LuHULmHoHHu
    W   #  I.u
IFIP0LIm u
IEIP0H/u
I$HP0HCHH L   M   A      $ LHu    ћ   }"  LpE3ILh HHt$(L躺HHuH       >"  I/u
IGIP0LGIH覸HH     J   !  s$ HHu٢    #   Ht$(#  H+u
HCHP0H
n LH}RHHu,H+ H     ̚   Ht$(#  H@HH L   MtA# HHu7       Ht$((!  H/u
HGHP0A   HI" HHu    9   Ht$("  H+u
HCHP0H3`؅y       Ht$(   H/u
HGHP0)  H\$ L HH ! y,H) HѠ O       Ht$("  Ll$0H IN  HHu,H) H     Q   Ht$(?"  H H! HHuѠ       Ht$(  H/u
HGHP0Hf LIJ  y    ֘   Ht$(!  H+u
HCHP0Ht$(  H
 HHu,H( H 2    |   Ht$(e!  H@HH L   MtA! HHu    1   Ht$(   H+u
HCHP0A   HIq  HHu       Ht$(  H/u
HGHP0H]yc       Ht$(s   H+u
HCHP0-  H\$ LӢ HHY  y,H' H     I   Ht$(7   Ll$0H IL  HHu,H@' H9        Ht$(  H H HHu    ˖   Ht$(  H+u
HCHP0H LI y<       Ht$(-  H/HGHP0Ht$(D  H
Ý 讲HHu,Hg& H` ޝ    ( *  Ht$(  H@HH$ L   MtA- HHu    ݕ ,  Ht$(  H/u
HGHP0A   HI HHuK     /  Ht$([  H+u
HCHP0H[؅y    Y 1  Ht$(   H/u
HGHP0Ht$(  H\$ L HH  r y,H/% H(      <  Ht$(  Ll$0HF I.J  HHu,H$ H ^     E  Ht$(  H HJ HHu(    r G  Ht$(  H/u
HGHP0H LI qߛ    ) J  Ht$(  Ll$0H\$ IHW L^ i	  H$ H     ؓ g    H
H #HHu'H# H՚ S     z  H@HH6 L   MtA HHu
    W |    H+u
HCHP0A   HI HHuʚ         H/u
HGHP0HYy    ݒ     H+u
HCHP0  IFIH L   MtA Ll$0HHu/H" LH\$ H     d   H< LI y    4     H+u
HCHP0A$   L$p HHu/H"" LH\$ H     ۑ   >H[ LI ya       p  H+u
HCHP0A$   L$h HHu/H! LH\$ H     R   HR LI yؘ    "     H+u
HCHP0A$   L$`o HHu/H! LH\$ H     ɐ   ,H LI
 yO       ^  H+u
HCHP0A$   L$X HHu/H  LH\$ Hx     @   H8 LI yƗ         H+u
HCHP0A$   L$P] HHu/H LH\$ H m       H LI y=       L  H+u
HCHP0A$   F HHu/Hw LH\$ Hh     0   H LIt y          H+u
HCHP0A8$   tH. H H$ H# H H Hu/H LH\$ Hƕ D       H^ LI y    ^   #  H+u
HCHP0A$   L$H HHu/HL LH\$ H=        hHU LII y    Ս     H+u
HCHP0A$    HHu/H LH\$ H 4    ~   Hf LI y    N     H+u
HCHP0H
 艩HHu/HB LH\$ H3        ^A$   MY LHu    Ɍ   r  H	 LgHt$(I9$b  LoLl$(MP  H_HIE HHH)uHAP0Hw LcI9$   A   LmHUL}HGHHu    /     Im u
IEIP0Ht$(I/u
IGIP0H/u
I$HP0HCHH H\$8L   M   A       LHuX     *  N  Lx E3ILhHHt$(L苪HHu    c 0    I.PIFIAIHyHHӒ         F Ll$0HHu/H" LH\$ H     ۊ @  >Hk LI ya     B  p  H+u
HCHP0H\$ IE IL$  L$  L$(  H$0  MtIm u
IEIP0L$   HtH+u
HCHP0HL$xH$P  Ht
H)uHAP0HL$8Ht
H)uHAP0HEHtH(u
HPHR0HH8  ^]H
P +HHu'H Hݐ [     V  H@HH L   MtA HHu    _ X  $  H+u
HCHP0A   HI HHuҐ     [    H/u
HGHP0HOy     ]    H+u
HCHP0  IFIH L   MtA Ll$0HHu/H LH\$ H "    l h  HD LI y    < j    H+u
HCHP0A$   L$@ HHu/H* LH\$ H      t  FHc LI' yi     v  x  H+u
HCHP0A$   M HHu/H LH\$ H     [   H LI y    +     H+u
HCHP0A8$   tHY H HO HN H HD Hu/H  LH\$ H o       H LI
 y?       N  H+u
HCHP0H
 ĢHHu/H} LH\$ Hn     6   A$   M LLHu         HA LoI9E b  LMU  H_HIHHH)uHAP0H LkI9E    A   L}HULu H芥HHu(    r     I/u
IGIP0LI.u
IFIP0H/u
IE HP0HCLH0 HH\$8L   M   A       HD$(Hu         LxE3Lp HHLLΣHHu\       R  HL$(H)uHAP0Ht$(;IH趡HH    Z     
 HHu*Hd LHZ ؋    "   
  Ll$0LH Ia y         H+u
HCHP0H
 (HHu*H LH׊ U         H@HH  L   MtA HHu    Y   !  H+u
HCHP0A   HI HHu̊       	  H/u
HGHP0HIy    ߂     H+u
HCHP0,H
߅ HHu*H LH ?       w  H@HHz L   MtA HHu    C     H+u
HCHP0A   HI
 HHu          H/u
HGHP0HGy    Ɂ   
  H+u
HCHP0  A$   
 HHu*H LH %    o   ]
  Hǅ LI y    ?   
  H+u
HCHP0A$   	 HHu*H/ LH%        	  H% LI1 ys       	  H+u
HCHP0A$   |	 HHu*H LH !    k   Y	  H˅ LI y    ;    	  H+u
HCHP0A$    HHu*H+ LH!      *    H LI- yo     ,    H+u
HCHP0A$   x HHu*H LH     g 6  U  HO LI y    7 8    H+u
HCHP0A$    HHu*H' LH     ~ B    H} LI) yk    ~ D  }  H+u
HCHP0A$   t HHu*H LH     c~ N  Q  HÆ LI     /~ P    H
G zHHu*H3 LH)     } d    H@HHڈ L   MtA HHua    } f  s  H+u
HCHP0A   HI HHu    h} i    H/u
HGHP0HgCy    1} k    H+u
HCHP0~A$    HHu*H
 LH     | v    H/ LI y]    | x  o  H+u
HCHP0A$   f HHu*H LH     U|   C  H LI yۃ    %|     H+u
HCHP0A$    HHu*H LH     {     H3 LI yY    {   k  H+u
HCHP0A$   b HHu*H LH     Q{   ?  Hy LI yׂ    !{     H+u
HCHP0A$    HHu*H LH     z     H LI yU    z   g  H+u
HCHP0A$   ^ HHu*H
 LH     Mz   ;  H LI ρ    z     H
 dHHu'H
 H     y   4H@HH~ L   MtA HHuN    y   ]  H+u
HCHP0A   HI HHuO    Uy   LLH\$ Hg	 H` H+  H/!  HGHP0  H/u
HGHP0H?y    x     H+u
HCHP0Ll$00L{ IH   y/H LH\$ H 7    x   L IH'   y/H~ LH\$ Ho     7x   A$    HHu/H7 LH\$ H(     w   SH|$ LH8 H/  yq    w      H+u
HCHP0A$   z  HHu-H LH~ H    fw   H LH  yd~    6w   LLHM HF~ HtH+u
HCHP0H\$ MbI/XIGIP0IH+u
HCHP0H{ HLI  'H LH} I~    v   HUATAUAVAWHhH@  HEHXHpHx H H3HE8L3HL$XHL$`HL$hHL$pHE0   HM(MHE   HMMDDDE3H+z H
lu HHu'H H} } y   u o  	  HHL$XL`hA$AAD$AIL$zHHu'H H| *} }   tu   	  LHL;
  t;MIL+" Hl' H

  H	  | }   ,u     HKH)uHAP0HsIL$ HHu'H H| | ~   t   		  LHL;
  t;MIL" H& H
w  H	.  L| ~   t   N  HK H)uHAP0Hs AD$8C(3$  Hu'H Hy{ {    At   l  HHD$`I\$@I;\$H4  IE3ff     HCH+HHHD$xHLL$@D$8  DL$0HD$(LL$ A   LD$xAQHqt HH  H   HHHD$hHt
H)uHAP0LGHG HE3AL;AL9G tHHGJ4I@HGHH  tE3HI;\$H,NH[ HTz z    s 	  G  H4 H-z z    r      3  HHu'H Hy tz    r     I\$XI;\$`   D  HEH;tIE3HHMBH IE3HUHMlBHE   LmDmIE3HUHMHBH  HD$(HM(  HHteHVH9V ~H HNHHJHNHH  uH/u
HGHP0I;\$`A2y    q '    ly    q %  n  Ht$pH
y HHu'H Hx ,y    vq 4    H@L   H+{ HMtA  LHu'Ha HZx x    "q 6    H/u
HGHP0     HHu'H Hx x    p 9    HHpHD$`H HG E3HH
z 躏LHu'H
  H
w :x    p A  Z  H/u
HGHP03IvH  H9.  I~H!  I^HHILH)uHAP0HsH(  H9u`H}L}A   HUHHHu'H  Hw w    o V    H/u
HGHP03        LHu'H
  H
v @w    o f  `  Hx3Lx E3E3IHvHHu'H  Hxv v    @o l  +  Im uSIEIGII\HHu'H5  H.v v    n O    I/u
IGIP0I.u	HIP0E3L|$XIO0H)uHAP0I_0I$  HHu-H  Hu 4v    ~n   E3E3N  IO@H)uHAP0I_@A$  AGHI$  HMIH
  HL$(H#  HHu-H>  H7u u    m   E3E3  IOPH)uHAP0I_PI$  HHu-H  Ht ^u    m   E3E3x  IOXH)uHAP0I_X3<  HHu-H  Ht u    Vm   E3E3&  I$  I;$    HEH;tIE3HHM=H IE3HUHM<HE   HE    E IE3HUHM<Hu  HD$(HM"  LHt^HNH9N ~H HFL4HAHFIH  u#I.u
IFIP0I;$  :   _l   
Sl   E3E3s    H`  HYs H.u
HFHP0HtH/u
HGHP0MtI.u
IFIP0MtI/u
IGIP0MtIm u
IEIP0Dus k H
 U3L|$XIO`H)uHAP0Iw`IIMtI/u
IGIP0HL$`Ht
H)uHAP0HL$hHt
H)uHAP0HL$pHtH)uHAP0HEHrPHHMH=   r<tH  HAH;r8  H+Hs(  H'v  HHE   HE    E HM=HHM8H3NL$@  I[8Is@I{HIA_A^A]A\]@SH H  HH HI`H)uHAP0He  HC`3H [@SH HC  HH HI`H)uHAP0H%  HC`3H [H\$WH LJHL;
  HtrH;  tiH
  L4 MIH H	@  H  Hp Pq [   i     H
* A[   SH\$0H _HHI`H)uHAP0H_`3H\$0H _;HA`H HA`HA`H HA`@SH H  HH HIXH)uHAP0H  HCX3H [@SH H  HH HIXH)uHAP0H  HCX3H [H\$WH HHHIXHH)uHAP0H_X3H\$0H _H\$WH HHHIXHH)uHAP0H_X3H\$0H _HAXH HAXHAXH HAX@SH H  HH HIPH)uHAP0H  HCP3H [@SH Hs  HH HIPH)uHAP0HU  HCP3H [H\$WH HHHIPHH)uHAP0H_P3H\$0H _H\$WH HHHIPHH)uHAP0H_P3H\$0H _HAPH HAPHAPH HAP@SH0H  H)t$ H9BurHu  (f.5ڏ zTuR  HtGHL  HEm m X   
f     H

 AX   2P(t$ H0[sH3(t$ H0[KH(AH  Hu;H  Hl 4m X   ~e     H
 AX   O3H(H(AH)  Hu;H]  HVl l X   e     H
 AX   CO3H(@SH H  HH HI@H)uHAP0H  HC@3H [@SH H  HH HI@H)uHAP0H  HC@3H [H\$WH HHHI@HH)uHAP0H_@3H\$0H _H\$WH HHHI@HH)uHAP0H_@3H\$0H _HA@H HA@HA@H HA@@SH H  HH HI8H)uHAP0H  HC83H [@SH Hs  HH HI8H)uHAP0HU  HC83H [H\$WH LJHL;
  HtrH;  tiH
  L MIHY H	p  H	  Hj j V   b A  A  H
 AV   LH\$0H _HHI8H)uHAP0H_83H\$0H _;HA8H HA8HA8H HA8@SH H#  HH HI0H)uHAP0H  HC03H [@SH H  HH HI0H)uHAP0H  HC03H [H\$WH HHHI0HH)uHAP0H_03H\$0H _H\$WH HHHI0HH)uHAP0H_03H\$0H _HA0H HA0HA0H HA0@SH0H+  H)t$ H9BurH  (f.5J zTuRX  HtGH  Hg 3h T   }`     H
 AT   J(t$ H0[s(3(t$ H0[KH(A(  Hu;H-  H&g g T   _ z  z  H
 AT   J3H(H(A(  Hu;H  Hf Dg T   _ z  z  H
. AT   I3H(@SH Hc  HH HI H)uHAP0HE  HC 3H [@SH H#  HH HI H)uHAP0H  HC 3H [H\$WH LJHL;
  HtrH;  tiH
{  L	 MIHY H	   H  He 0f S   z^ -  -  H
j AS   HH\$0H _HHI H)uHAP0H_ 3H\$0H _;HA H HA HA H HA @SH H  HH HIH)uHAP0H  HC3H [@SH H  HH HIH)uHAP0Hu  HC3H [H\$WH LJHL;
h  HtrH;<  tiH
  L MIH H	  H)  H"d d R   \ 
  
  H
*
 AR   GH\$0H _HHIH)uHAP0H_3H\$0H _;HAH HAHAH HAH\$WH E3HH;  AE3H;+  A3H;n  DEuH  DEEtR  HtGH  Hb yc Q   [ 
  
  H
 AQ   EH\$0H _È_3H\$0H _;H(y tH  H H  H  H H  Hu;H^  HWb b Q   [ \
  \
  H
 AQ   DE3H({H\$WH HH+C؃uOv  HtDH  Ha Qb P   Z 3
  3
  DCQH
 DH\$0H _É_3H\$0H _kH(IL$0  Hu;HK  HDa a P   Z 
  
  H
 AP   1D3H(H(IL$0G  Hu;H  H` ba P   Y 
  
  H
, AP   C3H(H\$Hl$Ht$WH H] HH
  E333_xHHu'Hh  Ha` ` q   )Y   O  HCHH\ L   MtA3  HHuX      H-  H9C  H{H  HsHHHHH)uHAP0HHuHHuH
  H
_ X   QH/u
HGHP03H+u
HCHP0   W  HH   =X   HZ  HS_ _ q   Hm u
HEHP0HtH.u
HFHP0HtH+u
HCHP0HtH/u
HWHR0Dz_ H
 W A3cHtHH6W   XH
W HHHHh Hp(H
  HH
z  HH0H
o  HH
e  HH8H\$0Hl$8Ht$@H _@UAVH8HBE3H;:  AH\$PAHt$XH|$`Ld$0LLl$(LL|$ tdH;?  t[HH  HHu'H  H] X^ m   V ;    H@L   Mu^V =  J  HIIMMu>H  H9GuH;w  H_HHH)H;wk  H\HHHAHH   HHHt
H)uHQR0HI
  HHtFLHIV  tH+aHCHP0Rf] n   U j     M] n   U h  kC  H   H
  LI;   HHD9   }      @t3H6IHv  ug4U X  \ m   HG  H@\ HtH/u
HGHP0HtH+u
HCHP0D\ H
  T ? ]  H/u
HGHP0L5  IL|$ Ll$(Ld$0H|$`Ht$XH\$PHtHm u
HUHR0IH8A^];Hl$ AVH HnX E3H\$0E3HHt$8H
S H|$@
HHu2H-  H,  H%[ [ f   HE S     HXHH
^ HX HAL   MtA  HHu'H  HZ @[ h   S   H  H  IH9C   H{H   HsHHHHH)uHAP0HHxpHHu*S   uH/u
HGHP0IH+u
HCHP0HHue  HHu]H  HZ Z i   R   {HoHHuR   H  HY GZ h   HtD2Hx)HHubH  HY Z i   bR   H+u
HCHP0HtH/u
HGHP0DY H
[  )R `<&H+u
HCHP0HLH.u
HVHR0Hm H|$@Ht$8H\$0u
HUHR0IHl$HH A^HT$SVWATAVH Lq333L9Yht3H A^A\_^[Hl$PLl$`L|$hMu*H  E3HX Y i   [Q V      LHu'He  H^X X i   &Q W  Z  IFHHHu-H
	  L  H< H	z  P Y    HAH;  tWH;7  tNH  HHuH
  H
W P ^  ~  H@L   MuaP `  Q  H3E3H@ Mu>H  H9FuH;nX  HFHHH)H;n>  H\HHHAHH   INI^Ht
H)uHAP0IF3HHH   HHIVHB      tHAL   MtA  HHtNH+u
HSHR0IVLI3  uH/HGHP0lO   5  ]O   &  H
M  L  H: H	  0O        Ht HM  HH/     H.u
HFHP0LL$XMD$0IT$(ID$ IIhIYpIyxL|$hHl$PIAhIQpMAxHt
H)uHAP0HtH+u
HCHP0HtH/u
HGHP0IID$0    ID$(    ID$     AD$hILl$`H A^A\_^[4N {  3HO  HHU U i   Im u
IEIP0E3HtH.u
HFHP0HtH+u
HCHP0HtH/u
HGHP0DlU H
m  M 7H\$Hl$Ht$H|$ AVH HQ HH
%N E3=HHuH^  ,  H   H
L HxHH5W L5V H-fU   HHtvHIH_HG3HGl GhHG@HGHHG HG(HG0HG8MtILwXHtHE HoPHtHHHw`  H+u
HCHP0HG4  H  HS L 'T i   Ai   H
*  6H+u
HCHP03H\$0Hl$8Ht$@H|$HH A^@SH HYhHtHI  HH [ H [@SH HYhHtH	  HH [H [H(HB      tHAL   MtA  Hu;H  HR S `   NK 
  
  H
~  A`   s53H({H   HD$   Ht
33P
HĈ   H(HHH  ȅx3H(@SH H  HuJ>  Hu7HӍH}  HHt#H
  HH	  H+u
HSHR03H [H H [@WH@HD$ H\$XH] H3HD$0HHL$(LL$xHAHyrH	HH;}HH339  E3MtA4  HH1HHL$0H3AH\$XH@_LAL9A ~HHAJI@HA3H%  LYE3HA EHL;AL9Y AEtHHAJICHA3H%  HAL   MtIH%.    HUHhH   HEHXHpHx H H3HEGHHM3u8E   HE   Hu@uDFHd  HMCHE   Hu@uDFH  HMHuHE   Hu@uIE3HUHM%HE7   Hu/@uIE3HUHM HUH   ϷHMeHM\HEHrPHHMH=   r<t  HAH;r  H+Hs  H'v  HHE   HuE HEHrPHHMH=   r<t  HAH;ru  H+Hse  H'vX  H'HE   HuE A   H  HMHE   HuE A   H  HME-   E-   HE   HuE IE3HUHMHE7   Hu/E IE3HUHMrHUH   AHMHMHMHMHHMGH3L$   I[Is I{(I]HT$WH0HD$(H\$@Ht$PHH3t$ HRH+H'HCH+HHt$D  HHЉHHCH+HH;rHHt}HCH+HHH;v  H    H=   r<t  HAH;ru  H+Hse  H'vX  H'H3HsHsHH\$@Ht$PH0_@SH H H;MHHq  ,MHH MHHF >QHHTSV  H HLHH=  LHHz LHH'F PHHS
  Hg HLHH	  LHH. LHH{E PHHRH [H%  H(H  @LHHRH(H%  @UVWATAUAVAWH$H@  Hǅx  H$  HӔ H3H8  LD$pHT$PHMH  L  ML  MLt$hHMWD$83H|$H3H\$0LmL}M+IHL$@Ht$8M  IfD  M94<  HD$0H;   HD$0H;   Lt$0L+IH;uuHH+HHseH+HIH+H   HQH+HHHIH+HE3H;LCL;ICHL$8.H|$HHL$@Ht$8IHtJHLt$h~H;uqHH+HHsaH+HIH+HrHQH+HHHIH+HE3H;LCL;ICHL$8-H|$HHL$@Ht$8IHtHHHL$@HH\$0I;s!H
   H
 u  3MtD  M$HI;r3H+HHtfD  HI    HH;rIHM3H]Mt`IrAfoFk IHfHnflfHAfHnflfLHH;rI;s     HHI;rL%m L  HEH  Hǅ0     Hǅ(      ƅ   IE3L|$pIH  H{ H  H  HD$pL  HD$PH  Hǅ      Hǅ      ƅ   IE3IH  "Hz H   L   L  L   L   HUH   L   H   H   H   H   HE3AL}H   H   HMI+HL   H;vdM9s
HH;rbHW  HD$x3HEHEH	 HD$XD$`HUHL$X  H HD$xHM HL$xH
   Hm HE Lu(Le0HEH+HHE8HUHM@LE0HU8HMXHU8H   RILuHU8H   HMI+HLE(H;vdM9s
HH;rbHj  HD$x3HEHEH HD$XD$`HUHL$X  H, HD$xHL HL$xH
   L%x  LeHT$hHULmH  HEWD$PWM LmLD$PHM   HHD$PH  HD$pH  HEHH  HD$hH@  HD$0HD$xH  L  HEH  HEH  HEH  HU H  +H H  HE(H  HE0H  HE8H  HU@H  H  HD$XL% L  HE`H   HEhH  HEpH  HUxH  _H   H0  H HH  H   HP  H   HX  H   H`  H   Hh  ?H  HD$XL  H   H  H   H  H   H  H  H  论H   H  H H@  HH  HD$XL% LH  H  HP  Hǅp     Lh  ƅX   IE3H  HX  Ld$xH  HEHE   LmE IE3H  HMhH  HD$(H  HD$ LH  L@  HT$xHHHU HtLEL+IH   Ht%L   L+IhWf   L   HMXmHU@HtLEPL+I4WfE@LmPL%ٯ Le H   Ht%L0  L+IWf   L0  H    H   Ht%L   L+IWf   L   L   L-ѳ L  H  L  L  L  H  }L  MtLEM+IINHtH+HLH6MtLEM+IIHH8  H3;H$  H@  A_A^A]A\_^]@SH HU HD$0H+oU H
U HH\$0H;sSHsU HT$0H;wBH\$0H+HH;
fU u   H
HU H
DU H5U Ht9HH)H;
0U u   H
U UH
U Ht
HH
T H@X HD$0H+,X HHH
T H
U H\$0H;sSHT HT$0H;wBH\$0H+HH;
T u   H
T H
T HT Ht9HH)H;
T u   H
T H
T Ht
HH
yT HW HD$0H+W HHH
WT H
V H\$0H;sSHV HT$0H;wBH\$0H+HH;
zV u   H
\V H
XV HIV Ht9HH)H;
DV u   H
&V H
"V Ht
HH
V HH8T H
V H
BT H.T H
GT "HT H
LT H [
HXH5S H9&S    HRH
R H\$PH<S H
EV H-R HRĲH-S LV H
^U IHlV H+HHYH;s>@ HHtH   LFV H7V IHH+HH;rH
U HQMH-T H\$PHX"H  D$(HD$0HT$83HL$ HD$8HD$@H  HD$   HG HpG HD$0HL$07HXHQ H9Q    HQ LzU HkU HQ HU HU IH+H\$PH3Ht;     HHtH   L&U HU IHH+HH;rHQ H\$PHT HQ     HHQ HQ H HHQ HXH  D$(HD$0HT$83HL$ HD$8HD$@H~  HD$ c  H H5F HD$0HL$0H\$WH H      ?HAH
P H9
P HsP u	H=bP HIHH+RP HHkHH<H;sfD  HKHHPH;wH\$0H _H	P H+O H
P HH+AHO H9O @WH H
  ս  HHu H
ν  H  H	F  H _H  H\$0H  H/Hu
HWHR0Hu%H
  H  H	  H\$0H _H  H9Ct9H
  H  H	ǻ  H+  HCHP0H\$0H _3Hʺ  H+H_3 uHCHP0HL3 Hu%H
(  HY  H	`  H\$0H _=	  H3 tA	  H[  %  
H2 s4  A
   H  H
  DH	  H\$0H _  u	H  t%H  H
}  H	l  H\$0H _3H\$0H _3H%  H(Hu      ŷ     H(HtIw  3H(3HtIv   "     "   H(H(MA8HI
      H(@SEHALA LtA@McPLHcL#IcJHCHHKAt
ALL3I[oHHXHhHpHx AVH IY8HMHIHILClE$fظ   EADDCtLMHHH\$0Hl$8Ht$@H|$HH A^ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H̃=!      Hh)|$@)t$Pf( f(r fYf(% f(
n f\V ff(fXf~Ё  fYf@  fY fff\Lt      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfXt fX\ fYfYfYfXfX4 ffXfY(t$P(|$@Hhf     ??f\f(> fsA~$ D$ T$$D$ T$$D$(T$0D$(T$0L f(5 f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5~ ffXfYf( ff- ff(5 ff5 fffffff fsA~   fA   ffs4ffYA~  fA  fYff(=~ ff=a fA~   fA   ff(5M ff50  A~0  fA0  fff(5l ffffYf(t$P(|$@Hh     HH)|$ )t$0f( f( fYff(% f(
i fXf:	 f(f~Ё  fYf@  fY* fff\L      ??f\f( fsA~$@     f( f(fYfs4fA$fYfYfX fXn fYfYfYfXfXF ffXfY(t$0(|$ HHfff     ??f\f(N fsA~$ L f(5! f(fYfs4fA$fYfYfX5 fX fYfYfYfXfX5 ffXfYf(J ff] ff(51 ff54 fffffff fsA~   fA   ffs4ffYA~  fA  fYff(= ff= fA~   fA   ff(5} ff5`  A~0  fA0  fff(5 ffffYf(t$0(|$ HH     %  %  %ή  %X  %  %T  %V  %X  %Z  %\  %^  %`  %b  %d  %  ff     @UH HE t
e HMPмH ]@UH HE t
e HMp蠼H ]@UH HE t
e HMPzH ]Hp  tHp  XHp  \Hp  @HH   Hp   8Hp  Hp   Hp  H`   H`   HH`   HH`   H(锢H`   H@锞H`   HXtHH   tH@   4HH   (H(   d@UH HE t
e HMHH ]@UH HE t
e HMHH ]H8   $@UH HE te H   ݤH ]HP   HP  騺H`   dH`   HTH`   HHDH`   H`4H`   Hx$HP   dH@   TH`   DHX   4H   D"@UH HE te HM`H     H ]H`   HH%   H`   #HP  騹H@   H  鈹H@  |H`  pH@   tH`  XH@  LHx   4HX   (H8   H   D!H   H4!H   (!H   H!H0   !H0    HP    H     H@   4HH   H   DAH    H    HP    HP   t H@   h H@   \ H(   H(   H(   鴞HP  ԷH0  H0  鼷H0  H0  餷H0  阷H0   H0  逷H0  tHP  dH0  XH0  \H0  PH0  4H0   8H0  H0  H`   DHP   H4H`   (HP   HH`   Hh   H`   HHh   H`   HHh   H`   H0H(   THH   HH(   <HH   0H`   ^Hp   XH`   H@HH@  @UH HE te HM@H     H ]H@   H H%ĥ  H0   H%n  H@   H@  鎵HT$UH HLE0H HMH:LO HHMh<HMHAHEhH   HCEhH
  HMH3HMPHMXHE0E8HUPHM05  H HEHA   Hm HMH<HH   ״Hh   ˴HH   /HT$UH HLE H HM8/:LG HHMX;HM8qHEXH}pHCEXH
Į  HM83HM@HMHHE E(HU@HM h  H HE8A  H HM8;H8   
HX   H8   bHT$UH HLE H HM8o9L HHMX;HM8豳HEXH}pHCEXH
  HM83HM@HMHHE E(HU@HM   H HE8A  H HM8';H8   JHX   >H8   Hp   $HP   HT$SUH(HHMHHHPHH;uHAH8 HHEHLE0I H H   _8L HHMP:LHHMp9HMP葲H   脲HEpH   HCEpH
Ԭ  HMP3HMXHM`H   ƅ   HUXH   o  H HEPA@  H HMP9H   HP   Hp   HP   ]H   H   HH   HH   H(tH   H@tH   HXTH   qH   <Hh   @H8   $zH   HH   Hh    H8   dzH   H0   H(   4H(   (HP   H   @UH HE0te0H   H ]H   鏰H   郰H   wH`   ;H   _HT$SUH8HHǅ      Hǅ       ƅ    A4   Hw H   kH]8HH   HP@H   Hǅ      Hǅ       ƅ    A   HW H   HH   HP@H   襯H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   6H  HEH3HEPHEXH HE8E@HUPHM84  H HEHHB4 HMHH   ܮH   ЮH   Į@UH HE0te0H   H ]H   鋮H   H   sHH   7H   [Hx   HT$SUH8HHǅ      Hǅ       ƅ    A*   H H   [H]8HH   HP@H   Hǅ      Hǅ       ƅ    A   HG H   HH   HP@H   蕭H   HPHǅ      Hǅ       ƅ    8 uE3IIB<  uHH   HH   HP@H   &H  HE`3HEhHEpH HE8E@HUhHM8$  H HE`H22 HM`H   ̬H   H   鴬Hp   餬HP   阬Hp   錬HP   逬HT$UH HHǅ      Hǅ       Ep A/   Ht HMpHM HHUpP@HMp*H  HE03HE8HE@H HE E(HU8HM (  H HE0H61 HM0Hp   ЫHP   īHp   鸫HT$UH HHEh   HE`    EP A/   H HMPHM HHUPP@HMPhHɥ  HE03HE8HE@H HE E(HU8HM f  H HE0Ht0 HM0HP   H(   HP  H0  تH0  ̪H0  H0  鴪H0  騪HP  霪HP  鐪HP  鄪H0  H0  |H0   pHP  TH`   锏H   RH   hH   H@XH0  H0   H0  H(   ԩH(   ȩH(   鼩H(   鰩H(   餩H(   阩H(   錩Hp  tHP  hH  \H  PH  DH  8HP  ,Hp   HP  Hp  HP   HX   H8   بHx   ̨HX   H8   鴨HX   館H8   阨HX   錨H8   逨Hx   tHX   hH8   \HX   PHx   DH   tH   hH   \HP   DHX   8HP   $HP   HH@   H@   H    H    H   锧H@   鈧H`   |H   dHH   XHh   LHH   4H   (Hp   HH   H   H@   8H   |HH   H@   HP   H   H   H@   H@   HHh   hHH   \H   PHh   DHH   8HH   ,Hh    H`   H   H@   H`   H@   H0   H0   H    
H    
H@   餥H`   阥H   錥HH   tHh   hH   \H   DH   8H   ,H    H   H@   H
HH   H@   XH8   LHX   HP   4H0   H    H0   HH0   H8\H0   HpH0   H   H    H@   tHH   hH@   TH@   H HH   8H@   H8@UH HE$t
e$HMPH ]H   龣HX   HX   H@   H    騀H`  |H@  pH@  dH@  XH@  LH@  @H@   H@   0H@   H0H@   HHԉH@   HhH@   H   鱉H@   H   ތH@   H   
Hh   鄅HP   hH  錢H  逢H  tH0   8H  \H  PH  DH  8H0   H   H  H  H  H  H  H0   騈H  ̡H  H  鴡H  騡H  霡H  鐡H  鄡H  xH0   <H  `H  TH  HH  <H  0H  $H0   H  H   H  H  H  ܠH  РH  ĠH  鸠H0   |H  頠H  锠H  鈠H  |H0   @H  dH  XH  LH  @H  4H  (H0   H  H  H  H  H  H  ԟH  ȟH  鼟H  鰟H  餟H0   hH  錟H  速H  tH  hH0   ,H  PH  DH  8H  ,H   H  H0   ؅H   H  H  $H   ؞H  ̞H  H   鴞H0   xH  霞H  鐞H   鄞H  xH   lH  `H   TH  HH   <HT$UH0HH   LH   S H   H`   ĄH`   qHH   鬄H@  鰀H0  ĝH  鸝H  鬝HP  頝H  锝H0  XHT$UH0HHǅ(     Hǅ       ƅ   A   H H  H8  HPLH  H  $HH  H H  H  H  H  ٜH  ͜H  HP  鵜H  驜H0  mHT$UH0HHǅ(     Hǅ       ƅ   A   H H  H0  HPLH  H  #HH  H H  H  H  H  H  HP  ֛H  ʛH  龛HP  鲛H  馛H0  jH0  ^HT$UH0HHǅ       Hǅ(      E33H  A#   H H  H  HPLH  H  }"HHX  H HX  H  H  H  ՚H  ɚH  齚HP  鱚H  饚H  iHT$UH0HHǅ       Hǅ(      E33H  %A'   H H  H(  HPLH  H  !HH  訿H H  H  H  H  H  ԙH  șH  鼙HP  鰙H  餙H  阙H  \H  PHT$SUH8HHӼ H  诚HH   HRLHH   HHp  轾H Hp   H  
H  H(   H(   H(   ܘH(   ИH(   ĘH(   鸘H0   HP  阘H0  錘Hp  逘H0  tH  hH0  \H  PH0  DH0  8H0  ,H0   H0  H0   HP  H0  Hp  H0  ԗH  ȗH0  鼗H  鰗H0  餗H0  阗H0  錗H@   H@~H@   H 0~H@   H@`H@   HXpH@   H0H@   H(@UH HE t
e HMH0H ]HT$UH0HHM8HPH
:  HMh3HMpHMxHE@EHHUpHM@އ  H HEhHt HMhyH   T}HP   H}H   |H  `H8   4y@UH HE4te4H   }H ]H   |HH   |H   H  H0   xHh   |@UH HE@t
e@HMx|H ]H   H  钕HH   fxH`   H8   Hx@UH HE0te0H   |H ]H`   4H`   HpT.H`   H@  1H`   HX  uH`   Hx  H`   H  tH`   H  {H`   H  wH`   H  鿉H@   餉H    阉HH   \@UH HHU@HMHZH ]@UH HHU@HMH>H ]HT$SUH8HH]PHHtJHS?HKH+H*HHLI?LHsH    HC    HC    33艿HT$SUH8HH]PHHtJHSCHKH+H*HHLI?LHH    HC    HC    33HT$SUH8HH]PHHt3HSM@HLCL+IH    HC    HC    33HT$SUH8HH]PHHt3HS?HLCL+I:H    HC    HC    33`H`   d@UH HEhtehHMPH     H ]HP   H H%0  HX   H%ڂ  @UH HEPtePHM@H     H ]H@   H H%  H8   tHT$SUH8HH]PHHtJHS<HKH+H*HHLI?LH#H    HC    HC    339HP   tHP   H D{H(   wHT$SUH8HH]`HHtJHS}AHKH+H*HHLI?LH胭H    HC    HC    33虼H@   餐H(   ĶH@   H%J  HT$UH HHUhHUhHSHExH[H ]HT$SUH(HH]`HCHr\HHHvۂ  H=   r<tǂ  HAH;r  H+Hs  H'v  HiHC   HC    H{rH 33虻H(   tH(   HT$UH HHUpHHcHHA   7~  HH ]H(   $H(   HT$UH HHUpHHcHHA   }  H|H ]H(   H(   HHT$UH HHUpHHcHHA   }  H[	H ]Hh   鴎HH   騎@UH HE0te0HMPH   H  H ]HP   HH%~  HP   dH  HH@  <H`  0Hh   dH`   XHh   LH`   H<Hh   0H`   H( H(   H(   ȤHT$UH HHUPHHcHHA   g|  HYH ]H(   @UH HE t
e HM@`H ]H   $H   H
 鰧Hh   HH   H(   @H   H   H   ܌H   HP   tH   鸌H   鬌@UH HE0te0HMPH   H}  H ]HP   H H%p|  H@   H%}  HP   VH  :Hp  .HP  "HT$UH0HH'H0]HT$UH0HH'H0]HT$UH0HH'H0]HT$UH0HH'H0]HT$UH0HH
(H0]HT$UH0HH*(H0]HT$UH0HHJ(H0]HT$UH0HHj(H0]HT$UH0HH(H0]HT$UH0HH(H0]HT$UH0HH(H0]HT$UH0HH(H0]HT$UH0HH
)H0]H  H   rH  rH  rH0  THP  8H  \H  H  Tu@UH Hp   H  蒪H ]H8  H  ,H    H   pHP  H   |pHP  ~Hh  ~H   鈉H   |H  pH   4pHp  (pHP  LH  @H0  4H0  8Hp  H0   sHp  4~H  Hp  rH0  oHP  oH8   oH   جHT$UH0Hf33胴H8   ToH   阬HT$UH0H&33CH8   oH   XHT$UH0H33H8   nH   HT$UH0H覾33óH  4H  (H@   |nH  H  HX   XnH  H   @nH  dH  XH  nH(  @H  4H  (HT$UH HH   诪LH   ?H   @UH HE t
e HM0 |H ]H8   龆HH   p@UH HE te H   fH ]H0   OiH0   Ci@UH HH   H   gH ]@UH HH   H   EH ]HH   H(   H`   H%t  HP   H%t  @UH HEPtePHM@HPH ]@UH HE0te0HMPH   Hv  H ]HP   H H%pu  H@   H%v  HP   VH  :HP  .Hp  "H@   H`   H8   HX   @UH Hꋅ   t   HM(HPH ]@UH HX   HM@1H ]HT$SUH8HH]PHHtJHS4HKH+H*HHLI?LHH    HC    HC    33	@UH H0   H   螤H ]@UH Hꋅ   t   HM(s  H ]H   H%s  @UH HEHteHHM@H   ht  H ]H@   H H%s  HP   H%:t  H8   ԧ@UH HEPtePHM@HP茿H ]H@   zHT$SUH(HH] HKt  HK t  HK(t  33ͮHT$SUH8HHU0HM80LE@HU8X33蕮@UH HE0te0HMPH   Hs  H ]HP   HH%r  HP   dH  H@UH HE0te0H@  H   r  H ]H@  HH%Er  H@  	H  H0  HP  ՁHp  Ɂ@UH HE0te0HM`H   hr  H ]H`   HH%q  HP   H%:r  H`   vH  Z@UH HE0te0HP  H   q  H ]HP  HH%Wq  HP   H%q  HP  
H  H@  H`  ـHP   H   d@UH HE te HM0HPH ]H0   .H8  "nH0  nH0   zQH
 ښ@UH HX   H@  ̠H ]@UH HE te H@  HPWH ]H   H顽H   t@UH HE te HM0HPH ]H0   >H8  RmH0  FmH0   ZQH
 
@UH HX   H@  H ]@UH HE te H@  HP臻H ]H   HѼH0   4_@UH HE te HM`H   o  H ]H`   H H%n  HP   H%o  H`   ʱH`  ~H`   taHH   XeH   |~HP   Da@UH HE@te@H   eH ]H   aHx   dH  HT$SUHHHHǅ     Hǅ      ƅ   E3Hy  H  H   HH  HP H  }Hǅ     Hǅ      ƅ   An   H<  H  HH  HP H  R}H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  QHH  HP H  |Hǅ     Hǅ      ƅ   A   H  H  HH  HP H  |Hǅ     Hǅ      ƅ   Ah   HE  H  詷HH  HP H  ;| E@HηHH][H  |H  |H  {H  {H  {H  HH   pH  {H  bH  鷮H   髮H  _bH  铮H   T^H`   8bH  lH  PH  H(  
QH   qH  MH  )H@   =pH  {H   aH  H  zH  H  zH  aH  齭H  qaH  饭H  zH  }zH  qzH  ezH   4]H`   aH  LH  PH  HH  OH   QH  LH  	H@   oH  yH   `H  ٬H  yH  H  yH  i`H  靬H  Q`H  酬H  iyH  ]yH  QyH  EyH  \H   _H  H   PH   DH   Hx   nH   H   ԳHP  [Hp   x_H   H   pKH  d[Hp   H_H   H   @oHP  4[Hp   _H   H   `KH  [Hp   ^H   |H   hH   ZH   ^HX   mH   wHx   Hx   Hh   ěHh   鸛H   \^HP   P^Hh   锛H8   8^H@  \wH   PwHp   ^H`  8wH@  ,wH    wH  $H  wH@  vH`  vH   ]H  vH  vH  vH  vH`  vHT$UH HH  /LH  H  BH   鄚H   xH   ]HP   ]H8   ]H@  (vH   vHh   \H`  vH@  uH   uH  H  uH@  uH`  uH   \H  uH  uH  uH  uH`  tuHT$UH HH  LH  H  HX   $uH8   uHT$UH HHU HMP633ӠHT$UH HHU HMP633裠@UH HHUPHMX躘H ]HT$UH HHUPHMh$33W@UH HE0te0HMPH   e  H ]HP   HH%pd  HP   4H`  tH@  tH   kH   kH  sHx   鸏H  sH  H  sH`   hZH  lVH@   PZ@UH HE\te\H   H   %d  H ]H   H H%Mc  H  H%c  H   3H  sH  H  H  rHX   rH8   rHx   rH   rH8   rHX   rH   rHx   rH8   rHX   xrH8   lrHX   `rH(   TrH(   HrH(   <rHp   H   TH(   rH(   qH(   qH(   qH(   qH   DH  8H0  ,H   H   H   H   Hx   Hh   Hh   H   H   xH   $qH  qH  qH    qH   pH  pH  pH   pH   pH  pH   霌H   鐌H@   tH  pH  |pH  `H  TH  HH  <H  0H  DH  VH  pH  pH  pH  oHp  oH  oH  oH  oHp  oHT$UH@HHǅ     Hǅ      ƅ   AB   H
 H  Hǅ     Hǅ      ƅp   A?   H Hp  芪Hǅ     Hǅ      ƅ    MA"H H  IHǅ      Hǅ      ƅ   E3Hw} H  H  HD$ L  Hp  H  *H  nHp  nH  ynH  mnH   QH   EH  InHp  =nHT$UH@HH   dH[H@]H  Hp  H  Hp  ՉH  ɉHT$UH@H$ EpHH@]Hp  鵠Hp  mHp  靠Hp  mH  umHp  imH  ]mH  QmH  5H0  4mH  (mH   mHP  mH0  mH  lH   lHP  lH0  lH  lH   鬈H   須H@   H  lH  lH   pH  dH   XH  LH   @H  TH  SH   ,lH    lH   lH   lH  kH  kH  kH   kH  kHT$UH@HHǅ     Hǅ       ƅ   AB   H H  ѦHǅ     Hǅ      ƅ   A?   H H  蚦Hǅ     Hǅ      ƅ   
 MA"H H  YHǅ8     Hǅ0      ƅ    E3Hy H   %H   HD$ L  H  H  &H  jH  jH  jH   }jH   aH   UH  YjH  MjHT$UH@HH   mH+H@]H  	H  H  H  H  مHT$UH@H4  EpHH@]H  ŜH  iH  魜H  iH  iH  yiH  miH   aiH  EHT$UH0HL   HU8#H      H   HH(HoH0]H0   H0  hH  $H  H  H   H0  4H   H   H   HT$UH HL   H   33MH@   HH@   HH@   H(pH@   H8`H@   HHPH@   HX@H@   H   gH   NHH   dHX   =H0   HH   HH   @UH HEPtePHM@HP謣H ]H@   @UH HEPtePHM@HPlH ]H@   @UH HEPtePHM@HP,H ]H@   [H   fHh   fHH   fH   fHH   fHh   xfH@   H@   @UH HE0te0H   H   V  H ]H   H H%%V  Hh   H%V  H   H  eH  eH   eH  eHT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   H. H   Hǅ     Hǅ      ƅ    A    Hǘ H   苠Hǅ     Hǅ      ƅ   A!   Hh H  THǅ     Hǅ      ƅ    MA"H H  H  HD$ L   LCH  H  hrHH8][H  |dH   pdH  ddH  XdH@   H@   x@UH HE0te0H   H   T  H ]H   H H%T  Hh   H%T  H   H  cH  cH   cH  cHT$SUH8HM8M8H]X;K  Hǅ     Hǅ      ƅ   AE   H H  袞Hǅ     Hǅ      ƅ    A    H H   kHǅ     Hǅ      ƅ   A!   HH H  4Hǅ     Hǅ      ƅ   ߕ MA"Hϕ H  H  HD$ L   LCH  H  HpHH8][H  \bH   PbH  DbH  8bHT$SUH8HH   H{  t'HM8HPHHK HH$&R  H'H8][Hh   H`   Hh   H`   H Hh   H`   H0H   TH   DDH@   (HHX   ,DHX    D@UH HHU0HM8JH ]@UH HH   HM8+H ]@UH HE4te4H   GH ]H   CHx   UH   H  ǋ@UH HE4te4H   H   LQ  H ]H   H H%tP  HX   H%Q  H   ZHT$SUH8HH  H   lHx H  `H]8tHH   HPH   HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  HH  HP H  _33fH  s_@UH HE4te4H   H   P  H ]H   H H%@O  HX   H%O  H   &HT$SUH8HH  H   kHx H  ^H]8tHH   HPHǅ     Hǅ      ƅ   A   H  H  HH  HP H  u^Hǅ     Hǅ      ƅ   A<   Hs  H  菙HH  HP H  !^H  HHPHH;uHAHLl HHEHHǅ     Hǅ      ƅ   : uE3I IB< uH  HH  HP H  ]HD5H8][H  p]H  d]H  X]HT$SUH8HH  H   iHx H  #]H]8tHH   HPHǅ     Hǅ      ƅ   AH   H  H  %HH  HP H  \H   HPHǅ     Hǅ      ƅ   8 uE3IIB<  uHH  趗HH  HP H  H\33%H  2\H  &\H  \H  \H  \H  H  BHT$SUH8HH  H  hHx H  [H]8tHH  HPH  HPHǅ     Hǅ      ƅ   8 uE3ID  IB<  uHH  藖HH  HP H  )[33H  [H  [H  ZH  ZH  ZH  H  ۍH  ZH  ZH  ZH  ZH  韍H  ZH  鄍HH   8AH  \ZH   AH  DZH  HH  ,ZH   ZH  ZH  H  Y@UH HEDteDH   H   J  H ]H   H H%I  H   H%sJ  H   鯌H   YH   T@H  }H  }H8   0@H  }HP   @H  <YH  0YHp   ?H  YH  YH   YH  XH  XH  ?Hp  XHP  XH0  XH  XH  XHT$UH HH   '|LH   跺H   :H@   $?H   ?HX   |HX   pH0   dH0   XHp   >HT$UH0HO    HyOH0]H(   MH   dH(   LH@   L@UH HꋅH  tH  HM@H   BH  H ]H@   H H%jG  H0   H%H  H@   PH@  Hx  :H   =Hp   LHT$UHpHHrZHp]H   UH   )H   9H   =Hx   HT$UHpHH_Hp]H   H   H   
Hx  49H   =Hp   |HT$UHpHHcHp]H   H   H   8H   <Hx   HT$UHpHHhHp]H   %H   YH   MHp   ĽHp   鸽H   H   JHT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  lH   HH0  HP H0  TH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  HH0  HP H0  THppHx][H0  lTH0  `THx   锼Hx   鈼H   Hh  7H   :Hp   LHT$UHpHH3tHp]H   UH   H   6H   :Hx   HT$UHpHHyHp]H   H   H   MHx  46H   :Hp   |HT$UHpHHd}Hp]H   H   yH   5H   9Hx   HT$UHpHHHp]H   %H   H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  蜍H   HH0  HP H0  'RH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  &HH0  HP H0  QHHx][H0  QH0  QHx   ĹHx   鸹H   H   TQH`   HQH@   <QH8   PuH   dH0   $HT$SUH(HH0  HM0]HXH0  PHtHM HHU0P33|H  PH@  PH`  PH  PH@  PH`  xPH`   鬸H`   頸HH   锸HH   鈸H   |H   pH   dH   XHx   LHx   @H   H   OH  OHT$UH0HMpMpp  ;|~U8H^ H   PH H`  PHނ H@  PHB H  PH   HD$ L`  LE8H@  H  ]HH0]H    OH`  OH@  OH  NH(   5H@   1H  NH   NH@  NH  NH   NH@  NH   鼶H   鰶H8   餶H8   阶H`   錶H`   逶Hp   tHp   hH   \H   PH   H   MH`  MHT$UH0Hꋍ      0  ;|~U4Hh H   NH$ H@  NH H   NH H  NH   HD$ L@  LE4H   H  [HH0]H   *MH@  MH   MH  MH   @UH HHEXD HUPHM(pH ]@UH HEPtePHM@H`H ]H@   HLH    rH8   hL@UH HE t
e HMXH ]H@   H   H   DH(   4H(   (HH   H   @UH Hꋅ   t   HM(H`H ]@UH Hh   HM@lH ]@UH HEPtePHM@HP蜇H ]H@   :H8   dH8   XH(   LH`   tH  $H  H  H   H0  4H   H   ܲH   в@UH HEPtePHM@H`輆H ]H@   :H   DJH  8JH8  ,JHX   JH0   nH   ,H   IH  IH0   LnH   )H(   H(   HP  tHP  H>HP  H 3HP  H8D0HP  HPt3H@   >HX   0H    ,H   0H  mH  mH@   /H  tmHX   /H  HH  HHp   /H  HH  HH  HH  HH  HH  \/Hp  HHP  tHH0  hHH  \HH  PHHT$UH HH   kLH   gH   HP   .H8   .H@   .H`   H   zHT$SUHHHH  H   kTHx H  GH]XtHKHH   PHMxHPHǅ     Hǅ      ƅ   8 uE3If     IB<  uHH  wHKHH  P H  GHbHH][H  FHT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  H   HH0  HP H0  wFH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  vHH0  HP H0  FHCgHx][H0  EH0  EHx   Hx   H   \HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  輀H   HH0  HP H0  GEH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  FHH0  HP H0  DH#kHx][H0  DH0  DHx   Hx   جH   ,HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  H   HH0  HP H0  DH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  HH0  HP H0  CHoHx][H0  CH0  CHx   鴫Hx   騫H   HT$SUHxHHǅH     Hǅ@      ƅ0   A!   H  H0  \~H   HH0  HP H0  BH(  HPHǅH     Hǅ@      ƅ0   8 uE3IIB<  uHH0  }HH0  HP H0  xBHrHx][H0  \BH0  PBHx   鄪Hx   xH   HT$SUH8HH]PHHtJHS}HKH+H*HHLI?LH^H    HC    HC    33mHT$SUH8HH]PHHt3HSHLCL+IoH    HC    HC    33@mH
 [HX   8AHX   ,AHX    AHx   AH   AHX   @Hx   @H   @H
 `[H8   dHh   @Hh   @Hh   @H   @H   @H   @H   t@Hh   h@H@   霨H
 ZHX   8@HX   ,@HX    @Hx   @H   @HX   ?Hx   ?H   ?H
 `ZH    cHh   ?Hh   ?Hh   ?H   ?H   ?Hh   ?H@   鴧Hh   8&H
M YH0   hcH   <?H   0?H   $?H   ?H   ?H    ?H@   鄪@UH HHU`HMPbH ]HT$UH HHU`HMh33j@UH HHU`HMPbH ]HT$UH HHU`HMh33WjHT$SUWH0HH   HO@!HO H>H^33j@UH HHUXHMP:bH ]HT$UH HHMh^33iHT$SUWH0HH   HO@HO =HP^33i@UH HHU`HMPaH ]HT$UH HHU`HMh33Wi@UH HHUHHMPzaH ]HT$UH HHM@]33i@UH HHUHHMP:aH ]HT$UH HHM@]33hH
y pWHP   <Hp   <H   <HP   <H   <Hp   <HP   <HP   <H(   鴤H(   騤H   |`HT$UH Hq33'hH   ԧH0   H%,  HT$UH HH^H ]H`   "HH   "Hx   HX   HP   H@   nH0   `H   騂H   霂HT$UH HHMHHt
H   33-gHT$UH HHMHHt
H   33fH
} UH8   :H8   :H8   :HX   :Hx   :H8   :HX   :Hx   :H
  UH8   :H8   |:H8   p:HX   d:Hx   X:HX   L:Hx   @:H8   4:H
A TH8   :H8   :H8    :HX   9Hx   9H8   9HX   9Hx   9H
 @THP   9HP   9HP   9Hp   9H   x9HP   l9Hp   0 HP   $ H
- SHP   89HP   ,9HP    9Hp   9H   9H   8Hp   8HP   8HT$SUWH0HH   HO@HO 8H@Y33dHT$SUWH0HH   HO@HO x8H Y33Md@UH HHE(D HUxHM0b\H ]HT$SUWH HH]pH   H;t-Hf     HK)  H)  H[(HCH;u33cH  t:@UH HEPtePHM@HPsH ]H@   @UH HEPtePHM@HPsH ]H@   ZH   9H   tH   HdH8   HP   Hh   5@UH HEPtePHM@HPsH ]H@   HH   H   HԞH@   6HH   XH@   d6HH   (@UH HEPtePHM@HP|rH ]H@   :}H   6H  5H8  5HX  5H0   DZH   ~H   3Hh  H8H@   3H8   $8H   鴝H(   8Hh   锝Hh   鈝H   L3@UHH3Ɂ8  ]@UH HM@H ]T@UH HSM8H ]T@UH0HHHL$(T$ L
ULEpUhHM`?RH0]HH   @UH HE te H   H ]H0   OH`   CH0   7@UH HE te H   H ]H    R)@UH HE8t
e8HMX2)H ]H`   3H   3@UH HE te H   H ]HX   H@   sH   gH0   k@UH HE te H   HH ]@UH HE te H   H ]HX   H@   H   H0   @UH HE te H   H ]H0   @UH HE te H   H ]@UH HE t
e HM@2H ]HP   'H   m2Hx   a2HP   'H   I2Hx   =2H(   QH@   EH(   9H@   -HP   1'H   1Hx   1HP   
'H   1Hx   1HP   &H   1Hx   1HH   &H0   &Hp   &H@   &H    H   Y1Hh   H0   1mH    UmH   HX   H@   HT$UH@HoRH-  H    a 
=  H,H@]H   Hx   H`   {HH   oHT$UH HQH.-  H'     56  HH ]HX   !H@   HT$UH HQH,  Hͣ K    t5  H1H ]H@   kH0   l@UH H  HMXlPH ]HT$UH H,QH],  HV ԣ    *%  Hi^H ]HH   pkH8   kH   $@UH H  H   OH ]HT$UH HPH+  HТ N y   W"  H,sH ]@UH H(  H   OH ]HT$UH HDPHu+  Hn  z  6 f"  HrH ]@UH H  HM %OH ]HT$UH HOH+  H    ך ;#  HpH ]HT$UH HOH*  H͡ K    #  HFpH ]H8   j@UH HEPtePH   iH ]H   H   -H8   i@UH HEPtePH   wiH ]H   H   i-HP   MiH@   qiHx   E-H  9-H   --HT$UH HHM(HPHH
"  H	["  HNH ]HT$UH HHM0HPHH
#  H	""  HYNH ]HT$UH HHM8HPHH
"  H	!  H NH ]HT$UH HHM@HHPHPH;uHAH: HHEHH
f!  H	!  HMH ]HT$UH HHMHHHPHPH;uHAHG: HHEHH
!  H	1!  HhMH ]HT$UH HHMPHPHH
!  H	   H/MH ]HT$UH HHMXHHPL I;uHAH9 HHEHH
"  H	   HLH ]HT$UH HHM`HHPHOH;uHAHV9 HHEHH
  H	@   HwLH ]HT$UH HHMhHHPL I;uHAH8 HHEHH
  H	  HLH ]HT$UH HHMpHHPL I;uHAH8 HHEHH
1  H	  HKH ]HT$UH HHMxHPHH
   H	O  HKH ]HT$UH HH|?  H
  H	  HSKH ]H(   )@UH HE t
e HM0YH ]HX   w)H8   k)H   H[)H   oH8   C)HX   7)H   H')H   ;HH   H   H8   H   H  mH  CmH  lHp   lH  qH  lH  H cH  H8wH  HpCH  tH   lH   H H   H8KwH   HpH   tH   ClH   o@UH H꺸  HMPHH ]Hp   lHp   oH   kH   H HX   kH   H8vH   sHh   kHh   H BHX   kHh   H8fvHh   sH0   nkHX   bkH0   oH  JkH(H= r_H
 KH HH=   r<t  HAH;r  H+Hsq  H'vd  H3GHP    H=     &  H(JH(H= r_H
 vJH HH=   r<t  HAH;r  H+Hs  H'v  HFHP    H=     &  H(IH(H= r_H
 IH HH=   r<tQ  HAH;rA  H+Hs1  H'v$  HEHP    H=     &  H(]IH(H= r_H
ۓ 6IH HH=   r<t  HAH;r  H+Hs  H'v  HSEH    H}     f  H(HH(H= r_H
ے HH HH=   r<t  HAH;r  H+Hs  H'v  HDH    H}     f  H(HH(H= r_H
k GHw HH=   r<tq  HAH;ra  H+HsQ  H'vD  HDH     H
       H(}GH
 `H
i `H
 $#H(H=L  t:-G(GLI H2 L+IRWH(      H(H(H=  t:FFL H L+IRWH     p H(H(H=,  t:FFL) H L+I>RWH      H(wH(H=l  t:-F(FLi HR L+IQWHH     0 H(H(H=ĭ  t:EEL H L+IQWH      H(H(H=  t:EEL	 H L+I>QWH     Щ H(H
q ^H
 ^H
I !H
  H
٨  H
ɪ  H
  H
9  H
  H
i  H
)  H
 t H
9 d H(H   H B8H
 HuH(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   £     ڣ                         0     B     V     p                    Ҥ                    0     F     \     v                                 ʖ          J          ڗ               6                         ސ          N     z               ڑ               N     t          Β               D               *          >     V     :                         v     P               ء               J          Ơ          B               l     .               ^          Н          @                v     0               j     .               h               <     И          X     n             Х     ڥ                         $     :     `          x                    ة                  8     H                            Ҧ                  L                         "     *     0     8     >     D                       Ԩ     ʨ                    l     J     0               ħ     `             ʦ                    t     j          V                                           
             ܦ     ~                  ̍                    x     f     N     @     *               ތ     Ќ                         p     `     R     8     (                         ̋                    z     Z     L     :     "               ڊ     Ċ                    ~     n     ^     L     <     $          *               Ɖ                    p     `     L     4     "     
               Έ                    ~     j     N     :     &                    ؇     ȇ                    n     ^     H     4                    چ     Ɔ     @          R     b     v                              p     ؎                         X     "     6     H     \     p               F     *          ď     ڏ                    ,     <     P     d                         
               ҅               |     j     X     >     *                    Ԅ                  `    @5           H         `             @    `                        0            P                      `                                                           0                                                                               "   8'             6            k e r n e l 3 2 . d l l         InitializeConditionVariable     SleepConditionVariableCS        WakeAllConditionVariable        0
              X    Y   
           x
           
          bad array new length    
   	   м
   9   `    `    8   `    P
   p`              OrderedDict optim   ret sample_file fit sample_file_flag    data_r  update  HMC StanFit4Model.stansummary (line 633)    decode  permuted    close   eta _get_samples    append_samples  warmup  algorithm   sum tol_grad        inc_warmup  T   save_warmup n   cline_in_traceback  get eval_elbo   data_i  F   Format string allocated too short.  plot    ascii   dtypes  PY2 holderptr   n_save  np  `            ctrl    tol_obj mean_lp__   astype  zip mean_pars   numpy   diag_e  2   dense_e test_grad   logger  17  ImportError 0   __getstate__.<locals>.genexpr   reshape misc    num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names adaptation_info __main__    value   vars_r  2   pars_oi sampler_param_names 17  iter_save   Newton  0   diagnostic_file_flag    enable_random_init  #   sampling_metric_t   encode  end asarray iter    Stan model {} is of mode 'test_grad';
sampling is not conducted.    shape   UNIT_E  get pystan._compat  iter_save_wo_warmup upar        adapt_window       data sim model_name model_pars par_dims mode inits stan_args stanmodel date get init_alpha  b   stan_args_method_t  B   unknown dtype code in numpy.pxd (%d)    max_treedepth   ValueError  h   warmup2 __str__ traceplot   method  H   int_time    range   fitptr  i   pystan.plots    _summary    NUTS    lp__    array   append  I   (dense_e)   pystan  l   stansummary L   AttributeError  gradient    order   DIAG_E  q   sampling_algo_t pars    data_args   unit_e  Q   ndarray is not C contiguous f   adapt_t0    error   vars_i  d   pars_oi_bytes   epsilon adapt_iter  g   handler tol_rel_obj user    probs   chains  Zf  warnings    index   metric  Zd  __import__  Zg  collections O   stepsize    split   holder  par extract (diag_e)    OPTIM   dstack  sim grad_samples    _get_kept_samples   format  s   _pars_total_indexes s   chain_id    utf-8   double  end ndarray is not Fortran contiguous   chains  end model_code  '   TEST_GRADIENT   Couldn't allocate space for StanArgs.   tol_history_size    plots   'char'  s   Couldn't allocate space for StanHolder. stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200 _verify_has_samples name    LBFGS   'long'  s   Metropolis  %s  output_samples  dims_oi samples pystan.constants    throw   int _check_pars =   string_types    _remove_empty_pars  #   _call_sampler_star  =   adapt_kappa keys    send    flush   #   row_stack   =   SAMPLING    start   #   MemoryError =   squeeze seed    init_list   #   variational =   save_iterations `inc_warmup` ignored when `permuted` is True.   data    
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
          #   tol_rel_grad    BFGS    init_radius =   __test__    tuple   #   `dtypes` ignored when `permuted` is False.  =   sampling    inits   #   adjust_transform    value   =   _split_data #   RuntimeError    __getstate__    VARIATIONAL =   genexpr Format string allocated too short, see comment in numpy.pxd #   elbo_samples    variational_algo_t  =   tol_param   thin    inits   #   DENSE_E refresh adapt_term_buffer       Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. =   newaxis flatnames   flat    dtype   #   getLogger   =   Variable name must be bytes.    Stan model {} does not contain samples. optim_algo_t    args    Couldn't allocate space for stan_fit.   init    sampler_params  pystan.misc warn    numpy   #   digits_summary  numpy.core.multiarray failed to import  column_stack    adapt_delta =   stepsize_jitter fnames_oi   #   sampler_t   =   control random_seed #   numpy.core.umath failed to import   =   handlers    numpy   #   (unit_e)    numpy   =   logging adapt_init_buffer   #   Non-native byte order not supported =   diagnostic_file argsptr adapt_engaged   numpy.core.multiarray   C:\Users\appveyor\AppData\Local\Temp\1\tmp9ez__5da\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.pyx  adapt_gamma #   history_size    _call_sampler   numpy.core.multiarray failed to import  _ARRAY_API  =   _ARRAY_API not found    _ARRAY_API is not PyCapsule object  #   _ARRAY_API is NULL pointer      numpy.core.umath        module compiled against ABI version %x but this version of numpy is %x  numpy.core.umath failed to import       module compiled against API version %x but this version of numpy is %x  FATAL: module compiled as unknown endian        _UFUNC_API      _UFUNC_API not found    FATAL: module compiled as little endian, but detected different endianness at runtime   _UFUNC_API is not PyCapsule object  =   _UFUNC_API is NULL pointer  #   SSE, SSE2   =   empty_nested() must be true before calling recover_memory()     empty_nested() must be false before calling recover_memory_nested() self        empty_nested() must be false before calling set_zero_all_adjoints_nested()  #   stan_version_major  =   stan_version_minor  #   stan_version_patch  =   unkown file name    numpy   #   unkown file name        C:\Users\appveyor\AppData\Local\Temp\1\tmp9ez__5da\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.cpp  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.pyx =   __init__.pxd    stringsource    type.pxd    ufunc   #   Unknown exception       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.__getitem__        attr_names      genexpr stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.__getstate__.genexpr       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.__getstate__   list        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.__setstate__       Expected %.16s, got %.200s  list        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.__reduce__ stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.num_failed.__get__ dict    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.num_failed.__set__ list    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.test_grad.__get__  list    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.test_grad.__set__  list    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.inits.__set__  =   Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.par.__set__        Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.value.__get__      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.value.__set__      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.args.__set__       Expected %.16s, got %.200s      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.mean_lp__.__get__  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.mean_lp__.__set__  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder.sampler_param_names.__set__    numpy   #   Expected %.16s, got %.200s  =   Expected %.16s, got %.200s      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._pystanholder_from_stanholder   'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._dict_from_stanargs #   'NoneType' object has no attribute '%.30s'  =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  _call_sampler_star      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._set_stanargs_from_dict stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._dict_to_vars_r dict    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._dict_to_vars_i self    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._call_sampler_star  #   _call_sampler   _call_sampler   _call_sampler   _call_sampler   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._call_sampler   Expected %.16s, got %.200s      genexpr stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200._call_sampler   __cinit__       attr_names  plot        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__cinit__ __init__    'int'   =   __init__    throw   #   __init__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__init__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__getstate__.genexpr      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__getstate__  plot        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__setstate__      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__reduce__        'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.plot  =   'NoneType' object is not subscriptable  extract stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.plot  #   traceplot   =   traceplot       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.traceplot stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.traceplot extract 'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.extract   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range summary stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.extract   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__unicode__       stansummary upar        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__str__   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__repr__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.__getitem__   #   stansummary args        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.stansummary       summary stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.stansummary       grad_log_prob   'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.summary   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.summary   log_prob    throw   =   log_prob        grad_log_prob   get_logposterior        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.log_prob  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.log_prob  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.grad_log_prob dict        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.grad_log_prob args        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_adaptation_info   #   get_logposterior        'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_logposterior  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_logposterior  get_sampler_params  =   get_sampler_params      'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_sampler_params    close   #   'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_sampler_params    %d.%d   =   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_posterior_mean        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.constrain_pars    'NoneType' object is not iterable       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.unconstrain_pars  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_seed  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.get_stancode      numpy.ndarray.__getbuffer__ plot        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.flatnames.__get__ 'NoneType' object has no attribute '%.30s'      numpy.PyArray_MultiIterNew1 data        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._verify_has_samples       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._update_param_oi  numpy._util_dtypestring stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._get_param_names  numpy.import_array      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._get_param_fnames_oi      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._get_param_names_oi       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._get_param_dims   numpy.import_array      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._get_param_dims_oi        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.constrained_param_names   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.unconstrained_param_names stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model._call_sampler #   Expected %.16s, got %.200s      numpy.PyArray_MultiIterNew2 mode        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model.sim.__set__   =   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 =   numpy.PyArray_MultiIterNew5 #   Expected %.16s, got %.200s  =   numpy.import_umath  #   numpy.import_umath  =   numpy.import_ufunc  #   numpy.import_ufunc  #   vector.to_py.__pyx_convert_vector_to_py_double  vector.from_py.__pyx_convert_vector_from_py_double      string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string    #   string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string  vector.from_py.__pyx_convert_vector_from_py_size_t      string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___   #   string.from_py.__pyx_convert_string_from_py_std__in_string      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   __del__ pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ date        vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__  #   num_failed  # 
 test_grad   #   mean_pars   #   mean_lp__   1.0 adaptation_info sampler_params  sampler_param_names     stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.PyStanHolder    extract Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  1.0 traceplot   1.0 __unicode__ 1.0 stansummary 1.0 summary log_prob    [   grad_log_prob   get_adaptation_info ,   get_logposterior    ]   get_sampler_params  #   get_posterior_mean  #   constrain_pars  unconstrain_pars    #   get_seed    #   get_inits   .   get_stancode    get_stanmodel   _verify_has_samples .   _update_param_oi        _get_param_names        _get_param_fnames_oi    _get_param_names_oi     _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames       random_seed     model_name      model_pars      par_dims        stan_args       stanmodel       cython_runtime  type    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.StanFit4Model   ndarray Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.__pyx_scope_struct____getstate__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.__pyx_scope_struct_1_genexpr    StanFit4Model    while calling a Python object  need more than %zd value%.1s to unpack  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.__pyx_scope_struct_2___getstate__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.__pyx_scope_struct_3_genexpr     while calling a Python object  at most stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200 builtins        __builtins__    __name__        PyStanHolder     while calling a Python object  exactly stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200 %s() got multiple values for keyword argument '%U'      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200 builtins        flatiter        broadcast       NULL result without error in PyObject_Call      %.200s() takes %.8s %zd positional argument%.1s (%zd given) send        init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200    init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200    name '%U' is not defined        free variable '%s' referenced before assignment in enclosing scope      NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        at least        %.200s() keywords must be strings       %s() got an unexpected keyword argument '%U'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      exception causes must derive from BaseException %.200s() keywords must be strings       calling %R should have returned an instance of BaseException, not %R    %s() got an unexpected keyword argument '%U'    '%.200s' object is unsliceable  Missing type object     Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      buffer dtype    'signed char'   'unsigned char' 'short' Does not understand character buffer dtype format string ('%c') Unexpected format string character: '%c'        'unsigned short'        'unsigned int'  'unsigned long' 'long long'     'unsigned long long'    'complex float' 'float' 'complex double'        'double'        'complex long double'   'long double'   a struct        Python object   a pointer       a string        unparseable format string       Buffer dtype mismatch, expected %s%s%s but got %s       Python does not define a standard format string size for long double ('g')..    Buffer dtype mismatch, expected '%s' but got %s in '%s.%s'      Expected a dimension of size %zu, got %zu       Expected %d dimensions, got %d  Buffer dtype mismatch; next field is at offset %zd but %zd expected     Cannot handle repeated arrays in format string  Expected a dimension of size %zu, got %d        Expected a comma in format string, got '%c'     Expected %d dimension(s), got %d    1.0 Unexpected end of format string, expected ')'   Little-endian buffer not supported on big-endian compiler   1.0 Big-endian buffer not supported on little-endian compiler   1.0 Buffer acquisition: Expected '{' after 'T'  1.0 Buffer has wrong number of dimensions (expected %d, got %d)     Item size of buffer (%zd byte%s) does not match size of '%s' (%zd byte%s)   1.0 'NoneType' object is not iterable   1.0 Missing type object     Cannot convert %.200s to %.200s stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200 cannot import name %S   %s (%s:%d)      value too large to convert to int   ,   can't convert negative value to int  /  value too large to convert to unsigned int  %]  can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t    error    [  can't convert negative value to pystan::stan_args_method_t  %1% value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t   :   value too large to convert to pystan::optim_algo_t  %1% can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t    model   %1% can't convert negative value to pystan::variational_algo_t  :   value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long  %1% can't convert negative value to long    _cython_0_27_1  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing :   can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object %1% _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   collections.abc close() -> raise GeneratorExit inside generator.        if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections :   Cython module failed to register with collections.abc module    Cython module failed to register with collections module    value   %1% backports_abc   send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.       throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    0.1e1   nan gi_running  NAN gi_yieldfrom    object being iterated by 'yield from', or None  __name__    0.1e1   %1% name of the generator   __qualname__    qualified name of the generator generator       %.200s.%.200s is not a type object      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200 an integer is required  compiletime version %s of module '%.100s' does not match runtime version %s     %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __int__ returned non-int (type %.200s).  The ability to return an instance of a strict subclass of int is deprecated, and may be removed in a future version of Python. __%.4s__ returned non-%.4s (type %.200s)    0.1e1   :   boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.   %1% grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1    %1% Argument n out of range: got %1%    :   boost::math::prime<%1%> is not converging   %1% grad_reg_inc_gamma  %1% is not converging   :   grad_reg_inc_gamma  1.0  iterations, gamma function gradient did not converge.  exceeded    0.0 k (internal counter)    grad_reg_inc_gamma  1.0 grad_2F1        exceeded        k (internal counter)     iterations, hypergeometric function gradient did not converge. grad_2F1        Must use algorithm="Fixed_param" for model that has no parameters.  1.0 Output generated by Stan (test_grad)    Point Estimate Generated by Stan    0.1e1   1.0 Sample generated by Stan    0.1e1   1.0 Sample generated by Stan (Variational Bayes)    Output generated by Stan (test_grad)    Point Estimate Generated by Stan    0.1e1   0.0 Sample generated by Stan    1.0 Sample generated by Stan (Variational Bayes)    user    stepsize__  0.0 treedepth__ 1.0 n_leapfrog__    divergent__ 0.0 energy__    1.0 stepsize__  1.0 int_time__  1.0 energy__    1.0 # Adaptation    Elapsed Time:   seconds seconds (Sampling)  lp__    1.0 boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.    1.0 boost::math::cbrt<%1%>(%1%) 1.0 0.003379167095512573896158903121545171688   1.0 0.0834305892146531832907    0.0 -0.338165134459360935041    1.0 -0.0509990735146777432841   0.0 -0.00772758345802133288487  1.0 -0.000322780120964605683831 %1% 0.455004033050794024546 0.0875222600142252549554    :   0.00858571925074406212772   %1% 0.000370900071787748000569  %1% -0.098090592216281240205    :   0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578    %1% 0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  TEST GRADIENT MODE      C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/exception/detail/exception_ptr.hpp     class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)   Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,  Initial log joint probability =         but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.    lp__        . Improved by    Log joint probability =        Iteration       Initial log joint probability =     lp__        Optimization terminated normally:           Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated with error:     Initial log joint probability =     lp__        Optimization terminated normally:           Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes      Optimization terminated with error:     lp__    lp__    0.003379167095512573896158903121545171688       0.0834305892146531832907        -0.338165134459360935041        -0.0509990735146777432841       -0.00772758345802133288487      -0.000322780120964605683831     0.455004033050794024546 0.0875222600142252549554        0.00858571925074406212772       0.000370900071787748000569      -0.098090592216281240205        0.178114665841120341155 0.191003695796775433986 0.0888900368967884466578        0.0195049001251218801359        0.00180424538297014223957       1.84759070983002217845  1.42628004845511324508  0.578052804889902404909 0.12385097467900864233  0.0113385233577001411017        0.337511472483094676155e-5      -0.0243500476207698441272       0.0386540375035707201728        0.04394818964209516296  0.0175679436311802092299        0.00323962406290842133584       0.000235839115596880717416      1.53991494948552447182  0.982403709157920235114 0.325732924782444448493 0.0563921837420478160373        0.00410369723978904575884       0.00295276716530971662634       0.0137384425896355332126        0.00840807615555585383007       0.00212825620914618649141       0.000250269961544794627958      0.113212406648847561139e-4      1.04217814166938418171  0.442597659481563127003 0.0958492726301061423444        0.0105982906484876531489        0.000479411269521714493907      0.00628057170626964891937       0.0175389834052493308818        -0.212652252872804219852        -0.687717681153649930619        -2.5518551727311523996  -3.22729451764143718517 -2.8175401114513378771  2.79257750980575282228  11.0567237927800161565  15.930646027911794143   22.9367376522880577224  13.5064170191802889145  5.48409182238641741584  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%)     Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      0.9016312093258695918615325266959189453125e-19  0.25479851061131551     Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   -0.32555031186804491    -0.65031853770896507    -0.28919126444774784    -0.045251321448739056   -0.0020713321167745952  2.0767117023730469      1.4606242909763515      0.43593529692665969     0.054151797245674225    0.0021284987017821144   -0.55789841321675513e-6 ibeta_derivative<%1%>(%1%,%1%,%1%)      boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument a to the incomplete beta function must be greater than zero (got a=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)    Stan can't start sampling from this initial value.    The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Adjust your expectations accordingly!   Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::gamma_p_derivative<%1%>(%1%, %1%)  Initialization failed.  Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::digamma<%1%>(%1%)   Log probability=       Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::digamma<%1%>(%1%)  Rejecting initial value:          Error evaluating the log probability at the initial value.      Log probability evaluates to log(0), i.e. negative infinity.  Exception initializing step size.       Unrecoverable error evaluating the log probability at the initial value.        Rejecting initial value:        Rejecting initial value:          Gradient evaluated at the initial value is not finite.         seconds        Gradient evaluation took         seconds.        per transition would take      1000 transitions using 10 leapfrog steps         attempts.      ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   finite diff     param idx       Iteration:       (Warmup)        (Sampling)     Exception initializing step size.       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is denormalized.       Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)  The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%)  Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).        boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Result of tgamma is denormalized.       The argument a to the incomplete beta function must be >= zero (got a=%1%).     The argument b to the incomplete beta function must be >= zero (got b=%1%).     The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.  Evaluation of tgamma at a negative integer %1%. Unknown function operating on type %1%  The argument a to the incomplete beta function must be greater than zero (got a=%1%).   Error in function       The argument b to the incomplete beta function must be greater than zero (got b=%1%).   Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Result of tgamma is too large to represent.     Result of tgamma is too small to represent.     Result of tgamma is too large to represent.     Result of tgamma is too large to represent.     Cause unknown: error caused by bad argument with value %1%      Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   -0.180355685678449379109e-1     0.25126649619989678683e-1       0.494103151567532234274e-1      0.172491608709613993966e-1      -0.259453563205438108893e-3     -0.541009869215204396339e-3     -0.324588649825948492091e-4     0.196202987197795200688e1       0.148019669424231326694e1       0.541391432071720958364e0       0.988504251128010129477e-1      0.82130967464889339326e-2       0.224936291922115757597e-3      -0.223352763208617092964e-6     0.490622454069039543534e-1      -0.969117530159521214579e-1     -0.414983358359495381969e0      -0.406567124211938417342e0      -0.158413586390692192217e0      -0.240149820648571559892e-1     -0.100346687696279557415e-2     0.302349829846463038743e1       0.348739585360723852576e1       0.191415588274426679201e1       0.507137738614363510846e0       0.577039722690451849648e-1      0.195768102601107189171e-2      -0.292329721830270012337e-1     0.144216267757192309184e0       -0.142440390738631274135e0      0.542809694055053558157e-1      -0.850535976868336437746e-2     0.431171342679297331241e-3      -0.150169356054485044494e1      0.846973248876495016101e0       -0.220095151814995745555e0      0.25582797155975869989e-1       -0.100666795539143372762e-2     -0.827193521891290553639e-6     boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   boost::math::bessel_ik<%1%>(%1%,%1%)    boost::math::bessel_kn<%1%>(%1%,%1%)    Got x = %1% but real argument x must be non-negative, complex number result not supported.      Got x = %1%, but argument x must be non-negative, complex number result not supported.  normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_lpdf Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_lpdf     Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::log1p<%1%>(%1%)    log1p(x) requires x > -1, but got x = %1%.      boost::math::expm1<%1%>(%1%)    -4.1298668500990866786e+11      2.7282507878605942706e+10       -6.2140700423540120665e+08      6.6302997904833794242e+06       -3.6629814655107086448e+04      1.0344222815443188943e+02       -1.2117036164593528341e-01      2.3883787996332290397e+12       2.6328198300859648632e+10       1.3985097372263433271e+08       4.5612696224219938200e+05       9.3614022392337710626e+02       -1.8319397969392084011e+03      -1.2254078161378989535e+04      -7.2879702464464618998e+03      1.0341910641583726701e+04       1.1725046279757103576e+04       4.4176707025325087628e+03       7.4321196680624245801e+02       4.8591703355916499363e+01       -3.5783478026152301072e+05      2.4599102262586308984e+05       -8.4055062591169562211e+04      1.8680990008359188352e+04       -2.9458766545509337327e+03      3.3307310774649071172e+02       -2.5258076240801555057e+01      2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03     1.4130e+03      5.46860286310649596604e-04      -1.4258509801366645672e+11      6.6781041261492395835e+09       -1.1548696764841276794e+08      9.8062904098958257677e+05       -4.4615792982775076130e+03      1.0650724020080236441e+01       -1.0767857011487300348e-02      4.1868604460820175290e+12       4.2091902282580133541e+10       2.0228375140097033958e+08       5.9117614494174794095e+05       1.0742272239517380498e+03       -1.7527881995806511112e+16      1.6608531731299018674e+15       -3.6658018905416665164e+13      3.5580665670910619166e+11       -1.8113931269860667829e+09      5.0793266148011179143e+06       -7.5023342220781607561e+03      4.6179191852758252278e+00       1.7253905888447681194e+18       1.7128800897135812012e+16       8.4899346165481429307e+13       2.7622777286244082666e+11       6.4872502899596389593e+08       1.1267125065029138050e+06       1.3886978985861357615e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) boost::math::bessel_y0<%1%>(%1%,%1%)    1.0723538782003176831e+11       -8.3716255451260504098e+09      2.0422274357376619816e+08       -2.1287548474401797963e+06      1.0102532948020907590e+04       -1.8402381979244993524e+01      5.8873865738997033405e+11       8.1617187777290363573e+09       5.5662956624278251596e+07       2.3889393209447253406e+05       6.6475986689240190091e+02       -2.2213976967566192242e+13      -5.5107435206722644429e+11      4.3600098638603061642e+10       -6.9590439394619619534e+08      4.6905288611678631510e+06       -1.4566865832663635920e+04      1.7427031242901594547e+01       4.3386146580707264428e+14       5.4266824419412347550e+12       3.4015103849971240096e+10       1.3960202770986831075e+08       4.0669982352539552018e+05       8.3030857612070288823e+02       -8.0728726905150210443e+15      6.7016641869173237784e+14       -1.2829912364088687306e+11      -1.9363051266772083678e+11      2.1958827170518100757e+09       -1.0085539923498211426e+07      2.1363534169313901632e+04       -1.7439661319197499338e+01      3.4563724628846457519e+17       3.9272425569640309819e+15       2.2598377924042897629e+13       8.6926121104209825246e+10       2.4727219475672302327e+08       5.3924739209768057030e+05       8.7903362168128450017e+02       2.2779090197304684302e+04       4.1345386639580765797e+04       2.1170523380864944322e+04       3.4806486443249270347e+03       1.5376201909008354296e+02       8.8961548424210455236e-01       2.2779090197304684318e+04       4.1370412495510416640e+04       2.1215350561880115730e+04       3.5028735138235608207e+03       1.5711159858080893649e+02       -8.9226600200800094098e+01      -1.8591953644342993800e+02      -1.1183429920482737611e+02      -2.2300261666214198472e+01      -1.2441026745835638459e+00      -8.8033303048680751817e-03      5.7105024128512061905e+03       1.1951131543434613647e+04       7.2642780169211018836e+03       1.4887231232283756582e+03       9.0593769594993125859e+01       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       -3.7595974497819597599e+11      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%)     Got x = %1% but x must be non-negative, complex result not supported.   4.0535726612579544093e+13       5.4708611716525426053e+12       7.2144548214502560419e+09       -5.9157479997408395984e+07      2.2157953222280260820e+05       -3.1714424660046133456e+02      3.0737873921079286084e+14       4.1272286200406461981e+12       2.7800352738690585613e+10       1.2250435122182963220e+08       3.8136470753052572164e+05       8.2079908168393867438e+02       1.1514276357909013326e+19       -5.6808094574724204577e+18      -2.3638408497043134724e+16      4.0686275289804744814e+15       -5.9530713129741981618e+13      3.7453673962438488783e+11       -1.1957961912070617006e+09      1.9153806858264202986e+06       -1.2337180442012953128e+03      5.3321844313316185697e+20       5.6968198822857178911e+18       3.0837179548112881950e+16       1.1187010065856971027e+14       3.0221766852960403645e+11       6.3550318087088919566e+08       1.0453748201934079734e+06       1.2855164849321609336e+03       -4.4357578167941278571e+06      -9.9422465050776411957e+06      -6.6033732483649391093e+06      -1.5235293511811373833e+06      -1.0982405543459346727e+05      -1.6116166443246101165e+03      -4.4357578167941278568e+06      -9.9341243899345856590e+06      -6.5853394797230870728e+06      -1.5118095066341608816e+06      -1.0726385991103820119e+05      -1.4550094401904961825e+03      3.3220913409857223519e+04       8.5145160675335701966e+04       6.6178836581270835179e+04       1.8494262873223866797e+04       1.7063754290207680021e+03       3.5265133846636032186e+01       7.0871281941028743574e+05       1.8194580422439972989e+06       1.4194606696037208929e+06       4.0029443582266975117e+05       3.7890229745772202641e+04       8.6383677696049909675e+02       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      Unknown function operating on type %1%  The binomial coefficient is undefined for k > n, but got k = %1%.       Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       "   C            C (          "   DD            TD (          "   D            D P          "   hE            E           "   E             F (          "   LF            lF           "   F            F (          "   4G            DG (          "   G            G 8          "   I            J h          "   pJ            J h          "   J            J            "   (K            8K            "   K            K h          "   L             L h          "   L            L h          "   L            M (          "   tM         	   M           "   N         
   DN           "   N    N    O          "   Q    R    4R           "   R    S 
   8S           "   W    W    $X           "   X    |Y     Z           "   [         
   [           "   p\         
   \           "    ]            8] p          "   <^            L^           "   a    (a    ,b            "   c            c            "	   8d            d (          "    e            (e (          "%   xe         '   f x                               
   T    V    h
         0         p   :      @         ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx 
          `
   `    
         0         p   :      @   @
           
    M    `    
   pe   5    p
   ]   
                      &   ,      @       8   >   
    %                             
            0   @            
    	          @
      
       8
          
   @/       (
      J   D            0      
           
   `             
   A   `    `       `    
      X
   `         `      p   :   `   @      
         
   X
    Y    X    
   @	       (
   a      ؠ
                 
   0c    
   e       H
          
   0f       
           
   -    &    '    @)    @'    0*    *    +    `,    (
           @
              Mb`MbPMbP?Mb`?ػ
   `        `    
    B   `    `       `    
   P   r   0   `r      p   :    r   @   @
   8   h	      0
   Щ    u   0    w       p   :   v      
            `      p   :   `   @      x
   :   :   :   `    `    ش
           p
   /       0
   0    `    `    `    `    `    `    `    `    `    `    
      `   @            @      &   ,             `              UUUUUU?UUUUUUUUUUUU?UUUUUU
   $	      	   Ȩ
   P         0       p   :            0
           
           0
            0
       `
    t    s    
   -    &    '    @)    @'    0*    *    +    `,    
         /          `
          
   l   
               (
   6    `    `    `    `     
            `      p   :   `   @         @
         t	   И
   p      0         p   :      @   E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        ؕ
   	   x   0	                         X
      p
   /       /          
   ~       `    `    `    `    `    X
    C    ?    ?    @@    7    7    7    @    7    h
           
   T     v     
   	         
           X
   
   
          
   `      `
      	   \   
   `    0    (
   T     U    
   0=        
      
      P                 &   ,          2   8   >   
   p7    07     7    6    6    P
   `       
               
   
                 Н
         .    
   ~    ~    `    `    `    `    `    (
   P   
                @   }      0}   8
           
      `
           
   	       
   5    5                                     
 
                     	               	               
                                              
   ,
       Ы
      Pw   0    w       p   :   v      
   Ъ               p   :   `   @      x
    %    7    7    7    7    7    7    7    7    @
           H
         /          
   ,   8
   0a      
         `    `        p   :         
      
   p      `    `       p   :   `   @   
   	   P
   `      
   P   r   0   `r      p   :    r   @   
       
          _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?
   `    (
   Ъ               p   :   `   @      
          p
   5    1    0     2    1    2    2    3    3    4    4    
       z            p   :   `   @      X
                           
    8   `    `    7   `    
      
                           
          
   Pb   
   {       |             
   `            h
      D   L	           ?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?
   `~     
   	   x
   \	          ?   =
?   @33?   =
?      ?   ?    ?ț
   	   X
                                  h
           P
      $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?
   @   0         @              
   	   
            0       p   :                   
   N   0     
      
    
   
           
           
      Pw   0    w       p   :   v         h
   0?   =   `>   =   =   0
   `    
   T    `T    
   @>    p8    8    :     8    9    ;     =    =    
   `        `            gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?                ]d!@~)@qQ@{H
@染@/P@rKmg@sz@s<J@QG׹@bf7@aN@^'T@D@I@Y+=@|ɠ@³@*DugxV@C@H]x1@N@V@.b@C@nb@JPg@*@`	n;@NP
@;o
@8'k1
@@B@A>@wKT@^vґ@P]@
@E؂3
@ꆭh
@;LC%K
@xI>V

@$:	@Ќ	@*4O	@DuZ	@6;@[i΅@Bsh9h@þ,0@n@v}G@qkҐ@q<]@\}*@%@{/e@HJ@2`Og@.{$U8@y
@d@8a@aDL@Z1W@q+@O@'{0@L]@2Ә@,[@B3@/@ޭ@zD@CQ4@Vr@e;L@Ч*'@eY&Y@p-|@QE@+SB@as@;@P@POR3.@@p3@Z*xa@ x
@o@ąEe@+:oD@Jj$@f@P @o  @3s @:ω @&h @$kJ @94, @z7 @	
?ƥ?^Qk?n0?h[?xvJk?#O?R|K?P&7?5J7?
S?Cl?0AM5?q탫?l\?##_?ꂲ\?-BNS'?-@?&x?O2{?B%T?n ?ʝ(?ze?2?V5S?-YЊ!?Qܨ?]}?@9?5X?s\'??`H?T.?aYc?*ߺ3?wr?}k?
$v?0w1s?aC?PS?Y$?<~ ?E?\X?.s*?&V?5[?Nk=?'o1Aq?,gC? ف?E?k?ă<?lq_?lF2?	O?m3?L?F?R?v|
&?!?];d!?͋tɠ?;t?)³MH?'?ĩ?R=?#=	?wl?}po0@?9R?f/z |?7q?r K?vre?b
]9?<
?e?W+Fl??bA?Dσe?1|?WBju?k^??Z+?pW?Y???Ly_N?$D?aҖS%?JBD?u,?8Bޑ?DS8?*P?+/w?S*?r~|o?sy#nt?yy?DbS?hm-a?.ǘ?=?Mox)J?k?5_\?Hgp(.?b!S?mm?K&?h#ឪ?.8eG?I>&?K?I?GH?XujvK?	2h]?O_?Zsxf?6|M=??{_?ģݥ}?R]ȗ?7"U?o`TY??+@?J?!?n=?3&ڐ?p$p?<\I;?m?̷y8?zP?s*J"?[5?+M[Iֺ?A]X?                        K2=?
O?%>T+Y?$ka?f?ḰXl?C@Wi=q?"Ηs? 67w?6H#z?]tQW}?_)N?qvi?boQ?n?t4?h?-BU؊?W'n?ǉ?	RD?__rTE>?2:;?]1%<?QA?Q=I?w@rT?1c?gS(u?H*g?N梚?pXP?3Tݜ?htQz?$?
Y&?Q|z?S?_?V#??~#?G?k&_?Ŗ< ?U?A&E?Ry??k9:9?mwn?L|{ʎ?8G;?j»?پz?!dJ?Jy?X1Iα?.g?4D?viׯ?I?;?PV?SuFe?@oű?,Q&?pa?эv?SN?w?%d?\C}?)ِ?6YJ?>?\? 0܍?H?<W[?׀sǷ?;,`4?;SZ?t刯?pk3G?(FM?8=]a?eTeCӺ?He5TF?&qW?..?Wk[?M??az?̹F?<Ã?fu?˦?nz6?Pu?/T{i? ?/q 3?xyt?f1 o?e=?x{8?@`r*{?4
?n}g?BE?Ք&?w?j8?-ɰY?0?<X?Imb.?x.BTv?T	ξ?1j?0U^Q?(ڦ^w?c?9(Q1?F}?j?PR?c?bPޱ?y%d ?O?#>䠟??\*A?I<Kܒ?[B/?>ܸ$8?r|?5D9g?]4?Ox?8?1 7?>?9O"H?/֎@?@Y H??~>\O?TLҫ?jG>?,|y2?Ґ]b?>N?3Sn?lR?i"?ބS??Z?	{^?~/?vG}rO?)vEW(?b"FS?pB9 ?5$1!?(V?}G?0H?N0Z?A1?ﾀ+	j?ڋ?&?ލ?磽!O?:l?l1&?vX#?'HB>?
Ə{?%۹?d>[?ꍰ07?r^sSw?Ɲҷ?Yζi?8aD:??}?9]?]T?I?{	?7Zi?!u v?@je?ָ?_(4?oTC?Qi?8?*?`x?@?~?z}k?!?7u?Q}6Ei?K=?MBц?ſ-r?vE!=?$`?HeC?};1s?*T[?++?J9?3;?omo?%;?{s?>?P"K?2m?$O?^E#?cE#;?z?Dܻ?+?%ᨯC?ij?Qf?x?sڂl?uLi=?f?\Omg?I?cK[!?~	n?&1$-?x]?/v?9U1T?mU?bv?*!?'{{ ?P?7E?      ?                1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@г
   @Y       
           (
         	   '
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        
            0       p   :            P
   0e   5    H
    Y     o   X
           8
      
   	   @
          
           
      `p   0   `r      p   :    r   @   
   `      `    `       p   :   `   @   Unknown exception       bad exception   bad allocation  bad cast        bad typeid  *   :   int ; base type=    ; variable name=        ; processing stage=     int variable contained non-int values   variable does not exist ; dims declared=        mismatch in number dimensions declared and found in context     ; dims found=   ; position=     mismatch in dimension declared and found in context     bad lexical cast: source type value could not be interpreted as target  invalid alignment to 8 bytes, ptr=      uninitialized   double  long double      and    expecting index to be between    out of range;  index   : accessing element out of range.       ; dimension size expression =   must have a positive size, but is       ; index position =      ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration   v2  v1  dot_product x   to_matrix(array)        vector size     rows * columns  .   y   m   k   T   Y   A       variance    lp__        accept_stat__   Adaptation terminated    Elapsed Time:   seconds (Warm-up)       seconds (Sampling)      seconds (Total)    p_  g_      Elements of inverse mass matrix:    ,    beyond array dimension range   value   C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\src\stan/io/dump.hpp        unsigned __int64 __cdecl stan::io::dump_reader::scan_dim(void)   beyond int range       int __cdecl stan::io::dump_reader::get_int(void)         beyond numeric range   double __cdecl stan::io::dump_reader::scan_double(void) Inf inity   NaN integer Dim     structure       syntax error    bool __cdecl stan::io::dump_reader::next(void)      data        inv_metric <- structure(c(  1.0 ))      ),.Dim=c(       vector_d        inv_metric      read diag inv metric    Cannot get inverse Euclidean metric from input file.    Caught exception:       Initialization failure  matrix  read dense inv metric   Cannot get inverse metric from input file.      check_finite    check_positive  Inverse Euclidean metric not positive definite. check_pos_definite       estimation is  WARNING: No              performed for num_warmup < 20  WARNING: There aren't enough warmup iterations to fit the        configured.             three stages of adaptation as currently                 Reducing each adaptation stage to 15%/75%/10% of                the given number of warmup iterations:            init_buffer =                   adapt_window =                  term_buffer =        covariance      Diagonal elements of inverse mass matrix:       ------------------------------------------------------------    EXPERIMENTAL ALGORITHM:           This procedure has not been thoroughly tested and may be unstable       or buggy. The interface is subject to change. stan::variational::print_progress       Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   /  %]   [   (Adaptation)   Mean vector     Dimension of current vector     Dimension of input vector       Cholesky factor Dimension of Cholesky factor    Dimension of mean vector        stan::variational::normal_fullrank      stan::variational::set_mu       stan::variational::set_L_chol   stan::variational::normal_fullrank::operator=   Dimension of rhs        Dimension of lhs        stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  stan::variational::normal_fullrank::transform   Input vector    stan::variational::normal_meanfield     Dimension of log std vector     Log std vector  stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/= stan::variational::normal_meanfield::transform  vector provided does not match the parameter length init        enable_random_init  seed        chain_id    iter        grad_samples    elbo_samples    output_samples  eval_elbo   eta tol_rel_obj     meanfield       algorithm       fullrank    warmup      save_warmup thin        refresh stepsize        stepsize_jitter adapt_engaged   adapt_gamma     adapt_delta     adapt_kappa     adapt_t0        max_treedepth   NUTS(unit_e)    sampler_t       NUTS(diag_e)    NUTS(dense_e)   HMC     int_time        Metropolis      Fixed_param     save_iterations Newton  BFGS    init_alpha      tol_obj tol_grad        tol_param       tol_rel_grad    LBFGS   history_size    sample_file     diagnostic_file append_samples  )   (   trace() argument target must be greater than 1  ERROR: UNINITIALIZED    start   restart end     include ran beyond end of program in trace()    Exception:        Found before start of program.        ' at line         (in ' ; included from '       bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type   ] =             anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97      data initialization K   t   S   t_change    X   sigmas  tau delta   beta        variable k missing      initialization  Error transforming variable k:  variable m missing      Error transforming variable m:  variable delta missing  Error transforming variable delta:      sigma_obs       variable sigma_obs missing      Error transforming variable sigma_obs:  variable beta missing   Error transforming variable beta:   gamma       Something went wrong after call_sampler.    ).   vs     Number of unconstrained parameters does not match that of the model (   ]        [origin:       filter is looking for elements out of range     invalid vector<T> subscript     vector<T> too long      string too long invalid string position ,       log1p(x) requires x > -1, but got x = %1%.      log1p<%1%>(%1%) size of         boost::math::expm1<%1%>(%1%)    ) must match in size     (  ) and       boost::math::digamma<%1%>(%1%)  boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)        columns of      Expecting a square matrix; rows of  [   is not symmetric.   , but   rows        is not positive definite.   ]=  is not lower triangular;        Lower bounded variable  lb_free , but must be greater than or equal to  is      , but must not be nan!  , but must be > 0!      , but must be finite!   C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      double __cdecl stan::io::reader<double>::scalar(void)   no more scalars to read multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         has dimension =         Overflow Error  boost::math::lgamma<%1%>(%1%)   boost::math::trunc<%1%>(%1%)    boost::math::owens_t<%1%>(%1%,%1%)      Undefined transformed parameter: gamma  []      iter,time_in_seconds,ELBO       Stepsize adaptation complete.   eta =    from the approximate posterior...      Drawing a sample of size        COMPLETED.      stan::variational::advi Number of Monte Carlo samples for gradients     Number of Monte Carlo samples for ELBO  Evaluate ELBO at every eval_elbo iteration      Number of posterior samples for output  stepsize__      int_time__      energy__        treedepth__     n_leapfrog__    divergent__     LS failed, Hessian reset        Successful step completed               Convergence detected: absolute change in objective function was below tolerance Convergence detected: relative change in objective function was below tolerance Convergence detected: gradient norm is below tolerance          Convergence detected: relative gradient magnitude is below tolerance            Convergence detected: absolute parameter change was below tolerance     Maximum number of iterations hit, may not be at an optima               Line search failed to achieve a sufficient decrease, no more progress can be made       Unknown termination code                class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     stan::variational::advi::stochastic_gradient_ascent     Eta stepsize    Relative objective function tolerance   Maximum iterations      Begin stochastic gradient ascent.         iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes       MEAN ELBO CONVERGED     MEDIAN ELBO CONVERGED           MAY BE DIVERGING... INSPECT ELBO             Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!               This variational approximation may not have converged to a good optimum.        Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation is not guaranteed to be meaningful.      stan::variational::advi::adapt_eta      Number of adaptation iterations Begin eta adaptation.           Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.       Found best value [eta =        Success!         earlier than expected. ].      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.      Step size =     stan::variational::advi::calc_ELBO_grad Dimension of variational q      Dimension of elbo_grad  Dimension of variables in model stan::variational::advi::calc_ELBO      log_prob        The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.           Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        circular_buffer Error evaluating initial BFGS point.    Error evaluating model log probability: Non-finite gradient.    Non-finite function evaluation. Error evaluating model log probability:         numeric overflow        Value %1% can not be represented in the target integer type.    Evaluation of function at pole %1%      map/set<T> too long     stan::variational::normal_meanfield::calc_grad  Gradient of mu  stan::variational::normal_fullrank::calc_grad   Posterior is improper. Please check your model. No acceptably small step size could be found. Perhaps the posterior is not continuous?  normal_rng      Location parameter      Scale parameter boost::math::itrunc<%1%>(%1%)   C:\bld\fbprophet_1508468596464\_b_env\lib\site-packages\pystan\stan\lib\stan_math\lib\boost_1.64.0\boost/math/special_functions/owens_t.hpp     long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed   "   p             5 `          "   
            4           "   
            4           "   v            @4            "   42            P2 `          "   D1            P1            "                1            "   0            0           "   x0            0 0          "   8*            .            "   -            - x          "   0-            @-          "   ,            ,            "   
            +           "   
            +           "   *            + X          "   l            *          "   8*            H*            "   %             *            "   8'            )            "   hn            p)            "   8n            H)            "   )            )            "   (            (            "   D&            (            "   j            `(            "   &             &           "   %            %            "   8'            %            "               H%            "               %            "   8'            $            "   8'            $            "   hn            $            "   8n            h$            "   8'            @$            "   l            # 8          "   8'            #            "   D&            X#            "   j            (#            "                p" @          "                " @          "   8'                         "   p             x  `          "   
            0            "   l             0          "   
             8          "   	            h (          "               P X          "                @          "   l            x          "                            "                           "   8'            h            "   8'            @            "   hn                        "   8n                        "   8'                        "   8'                        "   hn            x            "   8n            P            "   l              8          "   l             8          "   l             8          "   l            ` 8          "   m              0          "   x                        "   8'                        "   8'                        "   D&            `            "   j            0            "   D&                        "   j                        "   l            x          "                          "   D    \                "   <          8          "   <    <    h 8          "
               p @          "
               @ H          "               0 0          "   D
            
 0          "                0          "   <    d                "   <    
                "   (
            P
 X          "   	            	 (          "   ,            h	 X          "                           "   ,            H @          "                           "               h            "   
            8            "   
                         "   
                        "        	                "       4 
   `            "	                p H          "           (            "   L    d                "                          "   <    ,     X  0          "                       "   <        8 0          "   \    t                "                        "
                8          "   `             8          "                P          "               0 0          "   4             P          "   <         0          "   <    8    ` 0          "   0    p               "       P               "       0    `           "           @           "             p          "   `            p 0          "   
                        "   d    D -   p           "   t         
              "                           "                X          "   ,            h X          "                           "   |              p         "   ث                        "               p           "   |             p         "   ث            (            "                0          "   T            p            "                           "                           "               `           "   l              8          "   8'                        "   8'                        "   p            x            "   @            H            "
                p         "                H          "                           "               p (          "
                p         "   ,            8 (          "                (          "                          "               @ (          "                8          "                (          "   
                        "                 0          "                0          "   8'            P            "   8'            (            "   hn                         "   8n                        "   8'                        "   8'                        "   D&            P            "   j                         "                           "   D&                        "                           "   X            `            "   (            8            "       | +              "   P            `            "        +             "       0    X (          "                         "   8         	   ` 0          "                0          "           P           "                       "             `         "   t                   "   `         `         "   <    |               "                         "                      "   d         `         "   D                   "   $    \     p         "                8          "               0            "                           "	   t                   "        -              "                x          "+       l Y               "   <            p (          "                           "   x
            P P          "   x
             P          "   x
             P          "                           "   `p                        "   <         0          "   `p            p            "                           "           д           "             
    @          "   ̱    L               "             
   0 @          "   
            Ȱ            "                           "               Я            "   t                        "               0           "               Ȯ            "                           "   8            @           "   |         	               "   <        0            "   <             p         "   ث                        "   <    H    p 0          "!   ħ    ̨ :   P           "   <         1              "!        :             "            1   П           "   `p                        "   p            h            "   m            0 0          "   l             8          "   8'                        "   hn            h            "   8n            @            "   8'                        "   hn                        "   8n            Ȝ            "   8'                        "   hn            x            "   8n            P            "                          "                          "
                x         "                           "   H            P (          "                          "               (            "               Ж           "                0          "               p           "   tk         	   p 8          "   j            (            "   j                         "   D&            ؒ            "   j                        "   `                        "                H @          "   x
            А P          "           (            "   <        Ў (          "   <    0    X (          "                0          "       ԋ .               "   \    $ 0   P           "               Ї           "               @           "   x                      "                @         "   P                       "                          "   P            H           "                          "                         "                  @         "   P            ȃ           "                          "   P            X           "                          "   D                      "            -              "   }         -   `~           "   x{    | %   0|           "   {             { H          "   z            z x          "    z            0z H          "   x            y           "   w            w           "   x
            v P          "   v            v (          "   u             v X          "   S            8u @          "   U            u            "   x
            t P          "   lr            t @          "   x
            ps P          "   lr            r @          "   
            r 8          "   <    q    q H          "   <     q    (q (          "   p            p            "   `p            hp            "   8'            8p            "   o            o            "   xo            o            "   <    n     o 0          "   8'            n            "   8'            n            "   hn            pn            "   8n            @n            "   l            n 8          "   8'            m            "   l            m 8          "   m            `m 0          "   m             m 0          "   l            l 8          "   l            l 8          "   tk         	    l 8          "   tk         	   k 8          "   8'            8k            "   8'            j            "   D&            j            "   j            j            "   i            i            "   i            i            "   0i            @i            "   Lh            h (          "   g            h (          "   e    tf &   f           "   e    4e    `e 0          "   Ld    ld    d 0          "   |c    c 	   c 0          "   b    b 	    c 0          "$   h_         ?   `          "   $
             _ 0          "   <    ^    ^ 0          "   <    8^    `^ 0          "   <    ]    ] 0          "   <    h]    ] 0          "   <     ]    (] 0          "   <    \    \ 0          "   <    0\    X\ 0          "   <    [    [ 0          "   <    `[    [ 0          "   <    Z     [ 0          "   <    Z    Z 0          "   <    (Z    PZ 0          "   <    Y    Y 0          "   S            xY @          "   X         	   Y 8          "   XS            X @          "   S            (X @          "   XW         
   W @          "   V         	   V @          "   U            xV P          "   (V            HV            "   U             V (          "   U            U (          "   U            U            "   T    T 
    U            "   4T            pT            "   S            S @          "   XS            hS @          "   x
            S P          "   Q    (R    PR            "   Q    HQ    pQ            "   0P    `P    P            "   XN    xN    N            "                   8N            "   A            M            "   0M            8M            "   L            L            "   L            L 8          "   8'            K            "                   K            "   8'            K            "   8'            hK            "   <    J    J 0          "    J            8J            "   <    I    I 0          "   hI            pI 0          "   8'            0I            "   TH            hH            "   G            H            "                   G            "   DG            G X          "   DG            PG X          "                   F            "   <    E    E 0          "   <    0E    XE 0          "   A            D            "   8'            D            "   8'            D            "   8'            @D            "   8'            D            "                   C            "   A            C            "   <    C    8C 0          "   <    A    B 0          "   A            A            "   @            A 8          "	   $@            p@ (          "   ?            ? P          "   <            ? (          "   <            h? (          "   >             ? p          "   @>            p>           "   =            =           "   <    =    0= 0          "   <            < (          "   <            <            "   $<            H<            "
   :            `;            "
   9             :            "   
            H9            "   8         
   8            "<   (2    4 n   4          "b   (    +    +           "   '         	   0(            "   8'            '            "   8'            '            "   8'            p'            "   8'            @'            "   D&            '            "   D&            &            "   D&            &            "   D&            &            "   D&            P&            "   x%            % 8          "   $         
    % H          "   
            $            "   ,$            P$            "   #            #            "   #         
   p# (          "               " (          "               " (          "   <            `" (          "   x            0"            "   <             " (          "   P!         
   ! P          "                  @          "                x  8          "                   8          "   0                       "   0            P           "                8          "                 8          "	               @ 8          "                           "               P            "                (          "                (          "   <             (          "   x                        "   <            H (          "   p             8          "                @          "               P 8          "                8          "                           "                            "   @            P            "                            "                           "	                0          "                0          "
                 H          "                           "               h            "                            "                           "                           "
                            "   L            X            "   `         H          "   `
    
    
 H          "
       P               "   p
    
                "   
             
 @          "   	            	 (          "   @                       "
        p     @          "       <    p 0          "   D    t     0          "            @          "                (          "                            "   $             P             "   
            
            "   
            8
            "   ,
            p
            "	   
            p
            "   
            
            "   
            
            "   <
            P
            "   X
         
   
 0         "   
            
            "   
            
            "   H
            
            "   
            (
           "   \
            
            "   
             
           "   \
            
            "   
            
 0          "   
            
 H          "   H
            `
 0          "   
             
 8          "   x
            
 P          "   8
            @
            "   
            
            "   
            
            "   
            
            "   H
            P
            "   
            
            "   4
            `
            "   
            
 H          "   
            
 (          "   $
            `
 0          "   $
            0
 0          "   
            
 (          "   
            
 (          "   L
            X
 (          "   
            
 (          "   
            
            "   
            
            "   
            h
            "   
            8
            "   
            
            "                   
            "   l
            
            "   
            
 (          "   
            @
            "	    
            P
 `          "   
            
 (          "   ,
            8
 (          "                   
                          Jz5e;ؗҜ<      <      <-q=|=   n?= 
   >      >:0yE>      P>      >H P>{>6;
>!?oN8?Mb@?MA?ȅeA?ȏD?i4E?MbP?!]?kr	`?=Ը.h?#6k?      p?{Gz?ʇƅ?ђ
cՇ?      ??    ͜??4W'?f2	A??333333?    X?m0_?      ?Q63E?    ?    ?D?      ?    7?Vph?    ?    dL?    d?mBP
?ox?q=
ףp?;f?      ??Ը.??      ?333333?    ??      ?)\(?    6s?    ?      ?      ?  @cb?      ?      ?kﴑ[?       @CԾ@      @@.=@      @      @-DT!	@AmG|@      @	ouU@VMS@      @      @      @      @      @.N@Eĵ@      @E.,[@   @33@      @  E@-DT!@      @Pr@!X@~)@       @      $@      (@      .@fQm1@      <@      Y@     @e@     l@     @@     @     @@     (@     @     @@     @     @     @     @     X@     @    cA  A  A      C                  PHO1~ʉa۾=E6`,7Z'5JQ5 ZpP&GVWMu
fT            DNxR-DT!	      4NsFF      }Ô%I                                 ?                       ʫy>ʫy>_6.>_6.>2Lf0?O~x>K͉ ?K͉ ?Mj?/ēr.?4`BkA<?~}?[sS/k??i?{]?@8?kFoa?,aȹ?

oa?9d?9d?رo߬?HS 	p? BN?f/Ҁ?ng?S(c?ҍ?ئ8?Zf0h?Ų"?]OL? Lé?A!y?ą@?u`v`?DbjT?`w̺?~,?~,?:8TEvʣ?      ??}
|;¿ʫ?P=x:?[}`?K_n!r?tiY?0"S?rJ󓉸? 
   >???      ???ȼu?8<
w\v?t	?t	?Io??0ɗ^?6(]?      ?`<?      ?      ?R?S?0?Uh?    @.?    @.??      ?ub8c@Zw?      ?      ?/R V@      ?W/7c@      ?o5Ƅ@      ?mqDx@      ?,h-A@      ?UFeȐ@      ?Mʲ@      ?HB9      ?      ?7¬?+eG?+eG?      ?Ж}?      ?^бF?/@{R=a?      ?׹^oyd?       @       @      ?AMg @      ?`I2W@      ?V;0@MUNRοx@      ?      $@      Y@      $@TLm+M%@P	6@oI+@^ʥ
&@"ܢ}/@wp@.A@1%9@#LKH@O)QwMY@M1Ds+t@"~+@"~+@FAd@=JKAw@@ZG@{@c/Am@,G`@hcjzB@t@L1@oַ@14=]@~@xB)A@4bw>F2@ N@Nj֐W@
b-(@6Ґ@%_ q_L\?>@t>@WY_,0@t>@)3M3@O:8@M @A?_5[A\AdˊActo)
Ao+wV.8AC&kĨ5AFLHnA!q髠AVA3q&zAt AK5A5J
"AÈ)*-A{aUA,811AžѠ%A
B;A@ͷQ9=AXG`SA!GJYA)ÊBO'|5A-խBskPAfdQBLyo&ANՎ]@Ic⃼At<U@4W=A
q"aB"gAՉp³`BHps!B(z-	X|l!hB$vB)꾙#BIB5X3=4B[MB7oTPBUF1TB1I¢FUBxB+EhB
胩BTB1nB,o"B5c[CmbgoBM%<<ã:C3"O÷J
&C+/C~Ӝ+CeawT/-U,CZCbzsFmNCt<DvAC              UQ{-?IWV 1QAt`2?ʐ|E~Px<rc.+7%l`AAp?qaICcUUUUUU?=4
z|?YY!ezFĿT*baƯ?1i5ϸ]g?ۆ,̿Z)nh俿ҿxIiN?/AԿж)[?I`տ2s"\ڿp2ڿUUUUUU?^^^^^^ܿ4c08˿      ?~vx3j	o}/@D뤍p1"7D@d[ag2}(e[L6 NV` l=gW6}+W6}+2/u	`b qw.  ZI+1
_7QAϚnswȳYƲ76O0YYI?7%/bXAyxl=@ZFtPXzbZFtP)Мbn[P\AL}<c4jM$BDT")8BM/
C9=D
F144?gx	`]CT    hY    
   p  4
 4
                                                                                                               P   X                                   ]            0             X
 0
                            p
         
                          @   X
                         Д
 
                            
         
 X
 Ȫ
                                 @   Д
                        8
                	   
          .            @   
                      P. 
 
                 p
            @   p
                `      ` x
 ؕ
                  >             @   
                        P h
 (
                            p
 p
 P
                            8 
 x
                            
 
                            
         P-            @   
                        H 
 
                 h
 
 
 
 @
 
 
 
 @
 
                                                           h
                   T P
 
                              @   
             L            @   (
                         @   
                (       0= X
 @
                             
 h
                            P 
 
                 
 
                            " 
 И
                 V            @   
             
  
 
 
                         
 `
 Ȫ
                                P 
 h
                            
                    
         
            @   
                        
          
 
 
 Ц
 Ȫ
 
 
                                               N 
 @
                      (       @   
             81            @   
                        `? 0
 
                            ' 
 
                 P             @   h
                         @   
             
 0
                            
         <            @   0
                       
                   H 
 ț
                            
         
 
 P
 
                                   `
                    7 x
 H
                 
 0
 `
 Ȫ
 
                             
 
 Ȫ
                                 @   
                (        G 
 
                             8
 
                 @8            @   
                P       
 `
                 8
 `
 Ȫ
                     0$            @    
                         
 Н
                            
                    / 
 
                              @   
             
                         
                     & 
 
                             
 
                 
 ؿ
 
 
                                     @    
                        
                  P      P   
             H
 
                 
 
 `
 Ȫ
 
                                        0M 
 
                            
                    Q 
 
                 '             @   
                        H
 
 @
                 
 
                           . 
 
                           x
                     
                    p+  
 ؠ
                 /            @   
                        и
                   PL 
 @
                            `U 
 h
                  
                        
                   0: (
 
                            V 
 
                            
                    h
                    4 У
 8
                            @F 
 `
                 
 
                              @   
             x1            @   
             `?            @   0
                        а
         <             @   
                        @3 h
 X
                           L (
 
                 PA            @   
                        H
         X
 Ȫ
                 
             PL            @   
                          8
 8
                 
 
                    (       `  
 x
                 p            @   X
                        H
                    
                    Ь
                    F 
 
                 
 Ц
 Ȫ
 
                                    
                   P
                    p
         `
 `
                             P
 
                 p             @   8
                         
 
                 (            @   
             P
 h
 
 Ц
 Ȫ
 
 
                                                h
                    0
         H
            @   
                        0* 
 
                            
         
 
 0
                               / 
 X
                 
 p
                 `U            @   
                        P 
 
                 `
 
                 p            @   8
             
 `
 Ȫ
 
                                     
            P      L (
 h
                 
 P
 
                                
                    N 
 Ȩ
                        
   0
                     
 
                  
 Ȣ
 Ȫ
                                P
         
 
 Ц
 Ȫ
 
 
                                 T            @   P
                       p
         %               @   
                       (
          	           @    
             0
 `
 Ȫ
                     P 	           @   
                        % 
 
                 ȗ
             P             @   
             F            @   
                        J 
 
                    P      / 
 @
                            p
                    
         (
 
 
                                
                    0$  
 Ы
                            0
                    81 
 
                            
 8
                  -             @   
             H
 
 
                                   @    
             
 @
 P
 
                                    = 
 
                 (
 
 Ȫ
                                
         H            @   
             1            @   
             @'            @   ȩ
             
 Ȫ
                 -            @   
                        
 0
 
                 X
 
                              @   
             @
 
                            
         @
 
                            (
         8
                        P 
 
                 ?            @   
             
 
 @
 
                         -            @   
                        
         
 Ц
 Ȫ
                     
 (
 
 
                                   
                     @   
                          
 (
                            P h
 P
                            @   
              
 
                 `
 Ȫ
                 P
 
                 P            @   
             A            @   P
                        8
         
            @   0
                        
                    0
                      @   P
                        H
                     @    
             x%            @   
             xH             @    
                        
          
 
 @
 P
 
 
 ط
                                               
         0
 
 H
 
 
 
 P
                                     
 
                            
 
 (
                             
                    
                    `7 
 
                  E           @   Ȗ
                        T P
 г
                  !            @   (
             0            @   P
                        A P
 H
                 P            @   
                        , 
 
                            
                      Ⱦ
 ش
                 P.            @   
                       
         E            @   
             H
 Ц
 Ȫ
                                 S (
 
                            p; 
 
                              @   x
                        P
                    
                    1 
 0
                 Ȣ
 Ȫ
                 Ȫ
                (       @' ȩ
 
                           в
         
 
 @
 
                         
 
 Ц
 Ȫ
 
                                        h
                    X
          
 
                            H Ȥ
 `
                             
 
                 0U            @   H
             p            @   8
             
 8
                 H            @   
             ,            @   
             P
 
                             
 
                 8
                       
         
                        I 
 
                     (       @   
             H            @   Ȥ
                         > 
 X
                 
 
  
 
 
 x
 p
                                     p
 
 
 P
 
 @
 @
                                     A            @   P
             0
                        
                    ` x
 P
                            0U H
 x
                             
                     E Ȗ
 
                 
 X
 Ȫ
                                 5 8
  
                             ! (
 (
                 ?            @   
             (
                         @   
             R            @   `
                         $ 
 ػ
                 XI            @   
                        
                    4 @
 @
                 @B            @   p
                        
         8            @   
                        hG @
 м
                 
 
 
                                
                    8
         (            @   
                         
 p
                            ( 
 
                            `( 
 
                            H
                   8
         
 
                            `
         hG            @   @
                        p 8
 p
                           
                    
                    H
         G            @   X
                P      P- 
 
                            A P
 0
                            
                    . 
 p
                 
 
                 4            @   @
             1            @   
                        x
                    
         N             @   
                       7 x
 X
                             @   
                       @8 
 
                 X
 
 ؿ
 
 
 
  
                                                ؞
                   `( 
 (
                           H
                    (
         '            @    
                        1 
 
                 
 8
                 
 
 
                              @      P   
                        P- 
 0
                 07            @   0
                        
                    
         I           @   
              G            @   
                       
 0
  
                              @   8
             (            @   @
                       
                     @   8
                        F 
 
                            xH  
 
                 
 
                 HH            @   б
             H            @   @
             8
 
                            p
          S            @   (
                        5 8
 
                            
                    
         
 
                 PS            @   h
                          
 `
                 I            @   
             p
             8
 
 
 `
 Ȫ
 
 
                                     h
 
                            ` x
 
                 h
                          
 P
                 P
 ȗ
  
 
                                     . 
 
                           (
         p            @   8
             
 Ȣ
 Ȫ
                     
 
                    P      T P
 @
                 
 
                            @Q  
 
                 
                        5 
 
                 
 
                            N 
 
                 H    (       @   
             
 P
 
 
                         P
                        @   
              
 `
 Ȫ
                                h
         
 
                 `(            @   
                        8 ؟
  
                 (
 
                  
 
 
                               " 
 
                            F 
 
                 `
                         
 
                 %             @   
                         
 0
                 N            @   
                         @   
                        
         
 ص
                           
                    Э
                   x
                    
                     @   x
                         @   
              5            @   8
                        
         J            @   
                        @
                    x
         @
 P
 
                                h
                    # 
 X
                 pE            @   
             
 `
                 
 
 
 @
 
 
 
 @
 
                                                        X
                     
 (
                 `             @   
                        H 
 x
                 p+            @    
             `
 
                  
 
 
 
 @
 
 
 
 @
 
                                                            
                     
         .            @   
                        E 
 
                 h
 
 Ц
 Ȫ
 
                             F             @   
                        PL 
 
                           p
                    
                    x1 
 h
                            
         x%             @   
             /            @   h
             `            @   x
                        @8 
  
                 x
 Ц
 Ȫ
                     
 P
 ȗ
  
 
 
                                            ( 
 
                            
                      @   
                        
                    @' ȩ
  
                            h
                   I 
 `
                            
                    
         %            @   
             
             
                         
  
                 `5            @    
              
 
 0
                     0:            @   (
                         @   
                         
 
                            
 
                            0= X
 
                             
                     
 P
                 4            @   У
             ؿ
 
 
                                
                     @   
             I            @   
             
 
 ȗ
 
 
 
                                 F            @   
                        
                    
         
 H
 
 
                         
 Ȫ
                            0: (
 
                 
 8
 `
 Ȫ
 
                             
 
 0
 `
 Ȫ
 
 
                                                8E 0
 
                 0
             `            @   x
             
 0
                 
 
 (
 
 
 
 @
                                     
 
 `
 Ȫ
 
 
                                           H
                    PA 
 
                            / h
 
                 
 
                    (       ` x
  
                            ' 
 (
                 
 
 `
                     p            @   8
                         
         Ц
 Ȫ
                 
 `
 
                     =               P   
                P      @8 
 
                             G 
 8
                 
 
                            x
         =             @   
             P
 8
 
                     C             @   (
             
 
                 P     (       @   
                        h
                   
                      @   
                        
         
 x
  
 Ȣ
 Ȫ
 h
 @
                                     /            @   
                        ? `
 
                  E           @   Ȗ
             Q             @   
             @            @   H
                        
         '            @   
             P            @   h
             
             
             5            @   
                        x
                     @   P
             
                         x
 
                            
                    
                    - 
 
                             
         Q            @   
                        
         0
 
                            (
         
 8
                 @F            @   
                P      7 x
  
                           h
          
 (
                 
 Ц
 Ȫ
                     
 `
                           
                    `
                    XI 
 
                            
         p;            @   
                         @   8
             P            @   
             
 h
 
                     
 
 8
 `
 Ȫ
 
 
                                      E            @   Ȗ
                    
   
         ص
             @3             @   h
             p            @   8
             0=            @   X
                          @   Ⱦ
             
             #            @   
                        
            (       P- 
 
                                @   8
                        
         8
  
                 =            @   
                      P 
 
                 8E            @   0
                        07 0
 
                 
                        p X
 H
                 
 ȗ
 
 
                         E           @   
             E           @   
              $             @   
                        
            P      
 0
 (
                            `
         
             P
 
 
                     
 0
                 %            @   
                        R `
 
                            H
                    
         "            @   
                         
 X
                            @
         
 
 ص
                     ?            @   `
                        Q 
 
                 7            @   x
                P       G 
 0
                            ( @
 X
                           
                     
 
                            
                    L (
 
                            X
         
 
                              
 0
                            `
                      P
 p
                            8
                    H @
 
                            خ
         @Q            @    
                        `5  
 
                            h
                    / 
 X
                           x
         8            @   ؟
             x
  
 Ȣ
 Ȫ
 h
                                        
                    '  
 
                 p
 
                 
  
 
                     
 
 
                     `	             @   P
                        `  
 
                 `7            @   
                        0 P
  
                 
 Ȫ
                 p            @   8
              
 
 
 @
 
                             0*            @   
             0M             @   
              &            @   
                         @   
         GCTL   `  .text$di    `   .text$mn    05     .text$mn$00 P5   .text$x 0   .text$yd      P
  .idata$5    P    .00cfg  `    .CRT$XCA    h    .CRT$XCL    p   .CRT$XCU        .CRT$XCZ        .CRT$XIA        .CRT$XIC        .CRT$XIZ        .CRT$XLA        .CRT$XLZ        .CRT$XPA        .CRT$XPZ        .CRT$XTA        .CRT$XTZ     8 .rdata  
 (   .rdata$T    0
 U  .rdata$r    4
 t  .rdata$zzzdbg   
    .rtc$IAA    
    .rtc$IZZ    
    .rtc$TAA    
    .rtc$TZZ    
 H| .xdata  i   .xdata$x    x    .edata  |y    .idata$2    Xz    .idata$3    pz P
  .idata$4     %  .idata$6      X  .data    `O  .data$r W &  .bss      k  .pdata    <   .gfids$y          .tls         .tls$        .tls$ZZZ         _RDATA     `   .rsrc$01    `     .rsrc$02                                                 20
 
4 
2p B   R0
 b   
     p  * d 4 p- x
 r   P5               Q         2P1	 T 4  p`  - P
    5     5             &     
        
 d
 T	 4 2p2  	p`0P- (
   5     5 5    5  6    6    6    $6    06                  X            J                     +"     "     "     #     5$  
 
4 
Rp d	 4 Rp 4 R
p`P  
 @6     L6    \6    l6    |6    6                 %  %      %     %     %     %     &     
&     4&     J&     q&     &   d T 4 2 T 4 2`% %t !d T 4 
	 ؂
 6 '  (      (  
 d T 4
 Rp
  d
 T	 4 R d 4 2p
 
4 
2p d 4
 Rp 
 6     6           .  .      /     "/     3/      w/     /   4 Rp 
     /   0- `
 J   6     1  B1      _1   0- 8
 J        2  22      O2   0- 
 J       2  "3      ?3   0- 
 J       3  4      /4   0- 
 J       4  5      5   d T 4 p 
 6     8  9      9  ,9      9   d T 4 p p
 7     9   :      %:  <:      :   d T 4 p H
     :  0;      5;  L;      ;   d T 4 p  
     ;  @<      E<  \<      <   4 p 
 @7      =  6=      \=   4 p Ѐ
     =  =      =   d	 T R( (d $T  4 
p 
 P7      A  1A      $ 	0 0  - 
 r  7     7 `C  C      C     DD  m md
 h4 
rp 4
 rp X
 7     7    7    7    7     F   G      DG     }G     G     G     G  ! t L  WL  
 !   L  WL  
  h r0 0
 7 0M  zM      M      
4	 
2px-    * *x h r0 Rp`P0 t d
 4	 R 
  8 U  U      V   h d 4
 rp 
 8     @V  V      V   h d 4
 rp 
     `W  W      W   h d 4
 rp 
  8      X  X      X   4 
p	`P h
 08 Y  Y      ]Z  / 1 	p`0P- @
 r  @8     n8 8    8 Z  Z      [     J[     [     & 6 p`0  - 
   8     8    8    8     \  \      .]     ]     ]     . 47 2 p`P  - ~
   8     8    8 ]  L^      ^     ^     ^  & 0 p`0  - ~
 r       _  Z_      _     .  4  p`P  - ~
     9     9    9 0a  a      a     a     a     Yb      b   h b  +
 +h &4 
p`P x~
 09 <9    L9    X9     e  2f      f     f     g     g   t 4 P' 't# #d" 4!  P   P~
 p9 |9    9     i  Yi      j     j     ?k     k    p  !  
T 4 l  <l  0
 ! d <l  l  <
 !   <l  l  <
 !   l  <l  0
 !     T  4 l  <l  0
 " "h 	p`0P (~
     m  m      fn     un     n     o  ' 't #d 4  P    ~
 9     @p  p      5q   p! 4 r  r  @
 ! d r  r  H
 !   r  r  H
 !   r  r  @
  d
 4	 Rp }
 0t  t      t   4	 
Rp }
 9     @u  ru      u   4 Rp }
 9     @v  v      v  *
 *x &h "42 , 
p`P   `}
 9     9    9    9     :    :           :         v  
w      Fw     tw     }w     x     x     z     z     z     z     z      z  6
 6x h d 4 rp( d 4
 p- 8}
 J   0: <:      |  V|      }  }     9~   d 4 2p 0- }
 J         `      o   d T 4
 rp |
 P:               8	 'x8 #h9 4v t P  - |
 r  `:     l:    x:    :    :    :    :    :    :               X      n               (     \                    r          ׅ     I     W          Ն           	  6	 %x8 !h9 t p0P  - |
 r  :     :     :    :     ;    ;    ;    $;             B     T           
     :     f     ߉          @     ߊ          R     f              4 Rp`P p|
 0; <;    L;    X;    h; 0  i                     ǌ       $
 $T 4 R
	p` H|
 ; ;    ;    ;    ;    ;    K      g     {               ύ       0
 !4 
p`P-  |
 j   ;     ; ;    <             `  ;      l     ͐      ؐ               [                      Ƒ  R
 R T
 4	 2p`$
 $T 4
 R
	p` {
 <     <     (< 0  b           ѕ     -   4 p`P!  P    8 !   P    8 ;
 -t7 )d6 %44 . 
P  - {
 b  @< L<    z<    < <    <                        Ø                           j       ! t Л     
 !   t Л     
 
 d T
 4 2p$ 	 0  - {
               ]=    i=    i=    u=                	   XI    < 8   О          <     <    <    <    F=    
 
2P {
 "  - {
               *>    6>    6>    B>                	   XI x   = 8       p          =     =    =    =    >    
 
2P {
 , h	 	 0  - X{
               >    >    >    ?               P 	   XI x   P> 8                         P>     ]>    r>    >    >    
 
2P X{
 
 h 4 R
p`P
 
4 
2p R! t d 4	      !" "T
    M   !     M   !     T
   M   !      M   !     t  d  4	       RP!  t 4	   Ǩ  | !# #d
  Ǩ     !   Ǩ     !     d
 Ǩ     !    Ǩ     !       t  4	   Ǩ  | ! t P    
 ! d   ϫ   !     ϫ   !   t P    
 !   t  d P    
 
 
B0P  ! t
 d	   ʭ  x !9 9  t
  d	   ʭ  x !     t
  d	   ʭ  x ! 4	 @    | !  t 	d
  4	 @    | $ 	 0  - 0{
            ?    ?        #@    /@    ;@    ;@    ;@    G@        	       	   H H   (? H             ϴ           n       (?     6?    ?    ?    ?    ?    @ 	    BP0   0{
 :
 ,t9 (d8 $47 0 
P  - {
 r  `@     l@    |@    @    @    @    @    @    @    @ 	   @    @    A    A 
   A                      3     B     Q     `          ն          .  	   >  
     	   G     $     M     Z     i       
        ڹ  
             D     f  	        Ⱥ     Һ   	  d* T) 4( & p   z
 0A   '        $ $d0  T/ 4. * p   z
 @A LA    XA     0  n      ǽ                 - " p`0  - z
   |A     pA            A    A    A    A    A            XC    dC    pC             
 	   P    A X           P                   Ŀ          3     h     v               C          Z     q           A    &B 	   ;B    ~B 
   B    B    B     bP0   z
 , # p`0- hz
   C            C    C    C    C    C    C    C         	   hE 	   tE 	   E             d 	   P    C X             E      l                         9     b          ^                          C 	   6D 
   KD 	   D    D 	   D    E 	    bP0   hz
 ) 4  p  - @z
            E    E     E    E        dF              
 	   (    E 8      Q      y               $                     a        E     E    E    
F    
 
2P @z
 $ 	 0  - z
            pF    |F        &G               	   (    F 8           K                     l  F     F    F    F    
 
2P z
 *
 * x h 
4 
p( d
 4 rp- y
 2   @G             2  7	 &dv "4u p pP  - y
 r  PG     \G hG tG G G    G G G G 	   G 
   G    G                  
             )         {            :     H                       	   @  
   t                 
     	      4
 p y
 G                Bp0  !  

 T    P   ! d	 P     !   P     !      P    4 
	p` xy
  H     H     H        L      k             d 4 p6 (t3 $d2  40 , P  - Py
 R  0H <H    HH    g      u       A     O        4
 p (y
     @          
 
4 
 p  ! d      !        ) t 4
 	P-  y
 J   `H lH xH H H H H            s                            .         ;     I         4	 < 	p`0P  - x
   H     H    H    H H    H               I    I  I 
   ,I 8I                                !     G        A              	          B  
   y       
            2	 $4  p`P  - x
    PI     \I hI    tI    I                c                                              )  p`0P  - x
    I     I I    I I    I    I I    I p                   v       ,     =       (     O                           I     Z     d  +
 +h &4 
p`P `x
  J J    J         X     k     *     -  ! !d
 4 R
p 8x
 0J     <J     P             m      u   4 
R	p` x
 PJ     \J         )     U   T 4 p` 4 p`P! h      !        !       !        & &d "4  	pP   w
 pJ |J    J    J                   L     ]     h  & &d "4  	pP   w
                       i     z       4 &d "4  	pP  - w
    J     J    J         4     d                \  .  4  p`P  - pw
                 .     P           $ .  4  p`P  - Hw
    J     J    J       >    n             d 
 
4 
P
 
4 
P+ +h d 4
 p!$ $ x T    !      )  p`0P  -  w
     K     K    K $K    0K <K    HK         	 /
     S
    
    
         z     ,    =      
    T
          4 
Rp v
 `K     `        d 4
 
Rp v
 pK       ^  4 
Rp v
             4 
Rp v
 K             4 
Rp Xv
     @ f     z " "h 	p`0P 0v
           f    u          	p`P0 v
 K     K   k              # )  p`0P  - u
    K     K    K    K    K    K    K    L    L         @              )    Y    }        Q                ~        0    A    K    U .  4  p`P  - u
     L     ,L    8L DL    PL                   .    Q         %             R .  4  p`P  - u
                      .    Q         %             R %
 %h t d 4 P"	 "d 4  pP   hu
 `L lL    xL    L ! E!     !    !    "    "    " "	 "d 4  pP   @u
 " #     #    #    Y$    j$    u$ 0	 "d 4  pP  - u
    L     L    L     $ $      %    P%    s%    %     G& .  4  p`P  - t
     ( z(     (    (    (    Z)     ) .  4  p`P  - t
    L     L    L @+ +     +    +    ,    z,     ,  r04 &h "4/ & 
p`P  - t
   L     L    M M     M ,M P1 1     1    2    72    2     3 3    3    3    84 4    5  4 
Rp xt
     5 5     5  d 4
 
Rp Pt
  6 p6     6  4 
Rp (t
     6 6     6  4 
Rp  t
      7 F7     Z7  4 
Rp s
     7 7     7    )	 
	p`P0  - s
 b   @M     LM    XM    dM    pM    |M    M    M    M    M 	   M 
   M             P; ;    ;    <    <    )< 	   9< 
   E<    u<    <    <    <     <  
R0 s
 M     M  @ 6@     I@    @  4
 
Rp `s
 N     N    ,N    8N     @ @     @    @    'A    5A # 4
 p- 8s
 J   N @O     NO 6 (4   
p`P  - s
    PN     vN    N    N         O "P     P    R    R    bS    oS    yS     S    &T     = ,4A 8 
p`P  - r
   N     N     N    N    N    N    N    N         T T     (U    UV     V    V    V    6W    ^W    W    W    W    X    [     4	 
Rp r
  O      \ @\     \  4	 
Rp r
     \ \     ]  4	 
Rp pr
      ] `]     ]  4	 
Rp Hr
     ] 0^     q^  4	 
Rp  r
     _ _     `  R0 q
  a +b     Fb  4 Rp q
     Pb b     b  R0 q
 b c     &c  4 Rp q
     0c rc     c  
R0 Xq
 O     O    ,O    <O    LO    _O    rO         d d     d    d    d    e    )e    7e    @e =
 +h# &dQ "4P H 
p  - 0q
 #  O     O           O    O    O    O    O    O    O 	   O 
   P    P     P 
   ,P    8P    DP    PP    \P    hP    tP    P    P    P    P    P    P    P    P    P    P    P    Q     Q !   Q    (Q    4Q $   @Q    LQ &   XQ    dQ (   pQ )   |Q *   Q    Q ,   Q    Q .   Q    Q    Q    Q 2   Q    Q 4    R 5   R 6   R    $R 8   0R    <R    HR ;   TR    `R =   lR    xR ?   R @   R A   R    R C   R    R E   R    R    R    R I   R    S K   S L    S M   ,S    8S O   DS    PS    \S    hS S   tS T   S U   S    S    S X   S    S Z   S    S \   S    S ^   S        `   .T    _   a      + 	   P    T H       Pe e     e    e    %f    Zf    ef    f    f    2g    g    Mh    h    i    Ki 	   i 
   i    i 
   i 	   i    i    <j    j    j 
   k    6k 
   Dk    k    k    k    l    +l    Tl    bl    pl    l    l    
m    m    m    n    n    /o    No    \o    o    o    p    p    Cp    lp    zp    p    p    q    .q    <q    q    (r    s    [s     s !   s "   s !   s      t    t    [t #   t    u $   Bu %   au $   ou    u &   u '   v &   #v    mv (   v )   v *   v +    w *   Iw )   Ww (   ew    w ,   w -   x ,   x    cx .   x /   x .   x    y 0   Qy    y 1   y    -{ 2   h{ 3   { 2   {    { 4   | 5   Y| 6   h| 7   | 6   | 5   | 4   |    } 8   Z} 9   y} 8   }    *~ :   v~    q ;    <    ;       % =   b >    =       ܀ ?    @   V A   h B    A    @   Ł ?   Ӂ     C   Z D   y C       т E    F   , E   :    t G        H   d     I    J    I   ͅ     K    L    M   ' N   M M   X L   f K   t     O    P   Ɇ O   ׆     Q       8 R   l    I S   ^ T   s U   ~ V    U    T    S   ˈ     W   #    f X   { Y    X       ى Z    [    Z       [ \   p ]    \       Ԋ ^    _    ^       +     6 T     T `   T a   
 
RP 0q
 9 'h( R 
p`0  - q
 s  @T LT    XT    dT    pT    |T    T    T    T    T                  CU    OU    [U    gU    sU    U    U    U                  .V    :V    FV    RV    ^V    jV    vV    V    V    V    V                 "   GW #   SW     _W     kW     wW '   W (   W )   W                 ,   <X -   HX     TX     `X     lX 1   xX     X 3   X 4   X 5   X     X 7       7       9   'Y :   3Y 
   
   
      l4             4 !   !   $      4 +   +   .      4 8   8   ;      4 	   P 8  T H   	   P 0  U H   	   P   V H   	   P (  W H   	   P    X X     U                                     P         	                   # 
   3    j        1        В        >    L    r            Ó    ߓ        &    <        H        ŕ            6    m            ܖ            -    n      !         %         &        f '    (    )    *    )   I (   W '   e      +        њ /         0        F 1    2    1         3   7 4   t 5    6    5    4    3        ; 7   u 8    7        Ş             T     T    T     U 
   U     U    U    V    V     V "    W #   $W $   W     W ,   W -   X .   X     X 9   X :   Y ;   
 
RP q
  bP0   q
 .  t d 4 	P- p
 J   @Y LY XY dY pY |Y             P      [ ܠ         ġ      1    > n    { $
 $t d 4
 
rP p
       4 @
 /tE +dD '4B < 
P  - p
   Y     Y     Y     Y     Y     Y     Y     Y     Y     Y     Z     Z      Z             p ɧ    ڧ              a    o                       H    T         ȩ                	   .     l 
   x                        < +tC 'dB #4@ < P  - hp
   0Z     <Z     HZ     TZ     `Z     lZ     xZ     Z     Z     Z     Z                 `          ޫ         E    S     s                  3    ?              ӭ    ߭      	        \ 
   h       4	 
Rp @p
 Z     Z    Z    Z     `                    d 4
 
Rp p
  [     [ 0 o         ܲ  
R0 o
  [ P f        o
                       = 	   P 8   P[ H   ` s      P[     ][    
 
RP o
 3	 < 	p`0P  - o
   [     [    [    [    [    [       @     P    ^        ۷    2    g        Ƹ         9 (h $4D < 
p`P  - xo
    \     ,\    8\    D\    P\    \\ 0 {                 Z            ں            2    [     w & 6 p`0  - Po
   p\     \    \     \     л      @        	     &    B      
R0 (o
        
R0  o
 н         d 4  p   n
 \     \    \       I     _    m             * *d %T  4
 R
p n
 ]     ]    ,]    ?]    R]    e]    x]    ]    ]                        Y    m                
 0
 "d 4 	pP- n
 j   ]     ]    ]     0 j     t        :           h R0! t
 @  @A !   @  @A  
4 
px- `    4
 Rp `n
 ] ^        <    J # #t
 d 4 r 8n
                B @           0^ X        %     8 0^     >^     bP0   8n
  4 2! d t  a TB !   t  a TB !    a TB  d 4 2! t `  B !   `  B ! d   H
 !     H
  d 4 
rp n
                C @           ^ X       P        ^     ^     bP0   n
  4
 Rp m
       # F    T  2p! 4 p  C !   p  C  R0 m
       4 Rp m
     0 O     x  4	 Rp pm
             d T 4 2p d
 4	 Rp 4 Rp Hm
         4	 Rp  m
            G  4
 Rp l
     @           #  d 4 
rp l
               DE @           _ X   @ D     W _     _     bP0   l
 ! d @ X H
 !   @ X H
  d 4 
rp l
               E @           p_ X    B     U p_     ~_     bP0   l
 ! d    H
 !      H
 ! d t @  TB !   t @  TB !   @  TB ! t   B !     B ! d ` x H
 !   ` x H
  4 Rp l
   t	 d 4 2 d	 T 4 2p0	 "d 4  pP  - Xl
    _            ! t @ n 
 !   t @ n 
 0	 "d 4  pP  - 0l
                R0 l
   R
p`0 k
 _     `     `                I        4	 Rp k
 0`     ^`                  (  0  ! t  ( H !    ( H + +d 4 p   BP0  ! t	 P  H !  

 d  t	 P  H !   
  t	 P  H 
 b   k
     @	 M	     	 #	 p
`P0   hk
 p` 	 *
       d 4 
rp @k
               I @           ` X    M     ` `     `     bP0   @k
 " "d
 T 4 
rp k
 `     `    a   %     I            J ! !d 4
 r
p j
               J @            a X             5  a     .a     bP0   j
  T 4
 2
`! 	 t    J !      J ! 	 t    J !      J  4	 Rp j
     P           4	 Rp j
     @! p!     ! 
 b   xj
 0&  R0 Pj
 & &     & >
 >t
 9d	 04 
2P t  T
 4
 R
` t d 4 2< <t T 4 2` t T 4 2`d
 dt d	 T 4 2, d 4 pP- (j
 b   a  4 4     6  2p`0 4
 rp  j
 a  7 !8     Q8    u8  
4 
px- H    4	 Rp i
 a ; ;     < 
 t d
 T	 4 R
 	 T d 4
 Rp 4
 Rp i
     PF F     F F    G  d 
4 
2p T d 4 2p T	 4 2p`
 d T	 4 2p d
 T	 4 Rp
 b   i
     X ! bp`0   `i
                                     N             N @           a 8   @           a H           X X     AY a     a    a    a     a    
 
2P `i
  BP0   `i
 
  ` St
 6 
B`P0   T 4 2`! t ^ C^ TO !   ^ C^ TO  4  d T 2p! 4 b b O !   b b O !   4 b b O ! 4 d d O !   d d O !   4 d d O $
 $d  4 r
p 8i
 b b                                tP @           b 8            g g     g    h    h    h    h    i b     b    b     
 
2P 8i
 $
 $d  4 r
p i
 b b                                \Q @           b 8   @i i     i    j    j    j    j    +k b     c    "c     
 
2P i
 $
 $d  4 r
p h
 0c <c                                <R @           Hc 8   Pk k     l    !l    l    l    m    Gm Hc     Uc    rc     
 
2P h
  T	 4 2! t d @n fn R !   @n fn R / 1 	p`0P- h
 r   o ao     o    o    !p    *  	p`P0  - h
    c     c p p     q    Yq     q 0 6 p`0P  - ph
   c     c c    c    c    d Pr r     r    
s    as    s    s     4 R
p`P Hh
 d d    (d    4d    Dd    Pd             `t t     t    u    u    Cu    _u    ou  d
 4 
rp  h
 `d ld                            U @           xd 8           `v v     v    v     w    !w    \w xd     d    d     
 
2P  h
 
    g
 d pw w     w " "d T
 4	 
Rp g
 d     w x      4	 
Rp g
     y .y      4" 	  p   g
 d     d             z Az     dz    ! 	0- Xg
 r       z {     {  	 0  x-    -	  	p`0P  - 0g
    e e    (e 4e         | l}     } }    ~    &~    ~ ~     * " p`0P  - g
   @e Le    Xe de    pe pe    |e    e           `     {     5    N [    i         B    f     0 6 p`0P  - f
    C     b            D    o    ' 
 p`0  - f
                  M      = ,4B 8 
p`P  - f
   e     e    e e    e    f    f         @      2    p            V         0 6 p`0P  - hf
    D     c            D    o    
    @f
               Y @            f H               
 
RP @f
 
    f
               <Z @           @f H   Ѝ ݍ            
 
RP f
 
    e
               Z @           `f H         > @     
 
RP e
 
    e
               [ @           f H   P ]     ~      
 
RP e
 
    e
               t[ @           f H               
 
RP e
 
    xe
               [ @           f H   Ў ݎ            
 
RP xe
 
    Pe
               D\ @           f H         > @     
 
RP Pe
 
    (e
               \ @            g H   P ]     ~      
 
RP (e
 
     e
               ] @            g H               
 
RP  e
 
    d
               |] @           @g H   Џ ݏ            
 
RP d
 
    d
               ] @           `g H         > @     
 
RP d
 
    d
               L^ @           g H   P ]     ~      
 
RP d
 
    `d
               ^ @           g H               
 
RP `d
 $ $d  T 4 
p 8d
      b      F 5u 0xv ,hw  
	p`0P- d
 B  g     g    g    g    g    g    h    h    h     h 	   ,h 	   Lh    Xh    dh 
   ph    |h    h    h    h    h    h    h    h    h    h    h     i    i    i    i    $i    0i    <i    Hi !   Ti "   `i         ` e     p    }            
    Z     	   
 
     	   S    }     
       [ 
   u            Ӛ        (    =    ߛ    D    n    ӝ    ڢ    ?    ҧ            R    o    d    t                    ë    $    V                Ӭ        ׭     +     !   9 "   ʯ #    "   9 !   Y         	       /    I    V    c % %h !t d 4 
	 c
         pi    |i                  b 	   P P   i H                ѱ         1    F    E      i     i    
 
RP c
 % %h !t d 4 
	 c
         i    i                  c 	   P P   i H                !     6                  i     i    
 
RP c
 ) )h %t !d 4 
	 c
 i     i                             d    P P   j H               @          6         ȸ j     j    
 
RP c
 ) )h %t !d 4 
	 pc
 0j     <j                             He    P P   Hj H       p      E    f     һ     Hj     Uj    
 
RP pc
 O =% 8& 3' .x( *h) &d\ "4[ T 
p  - Hc
 K  pj |j j    j    j    j    j    j           j 	   j    j    j     k 
   k           Bk             f 	   P    k 8        ~           D    n                ;                ( H    \     	    
    	       K        ; 
        
           C    n             	    0 k     %k    2k    
 
2P Hc
 ' d 4 p-  c
 Z   Pk     vk                    ! 
	p`0P b
 k     k    k    k    k    k     0 W     j            T                        v      d 4
 2
p! T	 0  h !   0  h & 4 p- b
 j   0l     <l   t              ,  4 rp`P b
 Pl `      M  d
 4 rp b
 `l p      a  
4 
px- @   ! 4 `  
 !   `  
 !   4 `  
 	 	2`0! 
 t	 T   $j !     $j !   
  t	  T   $j  
R0 Xb
 pl       _  d 4
 
Rp 0b
 p        d T
 4	 Rp b
      D     o        4 Rp a
       .     I 9	 (4A 8 p`P  - a
   l     l    l l    l    m    m      7     S                $    Q    m 9	 (4A 8 p`P  - a
        +     G                    A    ] . 4  p`P  - ha
     m     ,m  _          . 4  p`P  - @a
               # p`0- a
 z   @m     Lm  q          + 4 p`P- `
 z        z          . 4  p`P  - `
                R0 `
   G     b &  p`0  - x`
         
     9    W  
  P`
 `m         R0 (`
 m   A     P  R0  `
 p        R0 _
  7     R # #t
 d 4 r _
               o @           m X        %     8 m     m     bP0   _
  d 4  p   _
  n     @n    mn @n 0 s                   4 R
p `_
 n     n    n               H      4 Rp 8_
                _
 n        " "d 4	 Rp ^
 n     
o  T     b      t T
 4	 R`2	  d 4  p  - ^
                  q @            o H     b     7  o     .o     BP0   ^
 f
 fd <t 	 4 2% %4 p` ^
               q @           `o X              `o     no     bP0   ^
 ' 7 p`P0- p^
   P          k         6
 ] 
	p`0P- H^
   o     o o    o    o    )p    ;p    Gp    Sp    _p 	   kp               v                     -    b            J 	    
   : : &  x 	h   / 1 	p`0P-  ^
 r        q                1      h 0!  x  T s !     T s !     x  T s 6
 ] 
	p`0P- ]
   
 &     E    }                    s         	   L
 
   / 1 	p`0P- ]
 r  
 
          :        ] ] U  
	p`0P! h
    t !      t     ]
       . 7 p`0P- ]
         z             +    x        = ,4e Z 
p`P  - X]
   p     p    p p    p    p    q    )q    7q    Cq 	   Oq 
   [q                   C    Z                ?    [     	   G 
        &
 &d
 !T 4 R
p 0]
 pq   G      / 1 	p`0P- ]
 r                 A    , ,4)  
p`P   \
 q     q    q    q    q             q    q    q 	   r    ?r                             %                        L    [         	    
   1    H    b                $      }  
                  , ,4)  
p`P   \
 Pr     \r    r    r    r             r    r    r 	   r    s                         _!     u!    !    "    -"    C"    `"    "    "    #     # 	   6# 
   #    #    #    #    $    ?$    t$     $ 
   $     $ %    % = ,4= 2 
p`P  - \
    s     ,s    Zs    ls     zs    s @% %     $&    A&    &    &    '    (    (     (    ( 6 (4   
p`P  - h\
    s     s    s P) R*     z*    *    *    7+     `+  
0 @\
 s     s + +     +    
,     L :c 2d -e (xf $hg  
p`0  - \
 #  t     t           (t           !v    -v    9v    Ev    Qv    ]v 
   iv    uv    v 
   v    v    v    v       	      | 	   P    4t h   @, `-     -    -    -    -    . 
   W.    .    30    0 
   0    {1 
   1    2    2    E3    S3    4    (4    J4 
   4    4     4 4t     Bt    vt    t    t    t    @u    Qu    u    u    u 	   u    v      P0   \
 A 0x ,h (4<2
p`P  - [
 b	  v     v    v    v    v    w    w    w    'w    3w    ?w 
   Kw    Ww    cw    ow    {w    w    w    w    w    w    w    w             05 #6     R6    _6    s6    6    6    O7    Y7    7    *8    ]8 	   9    T: 
   a:    ; 
   ;    ;    ;    }< 
   Z@    @    .A    UA    bA    B    *B    vB    B    1C    KC    C    C    C    C    D    #D    1D    >D    KD    D    D    D    D     D A 0x ,h (4@6
p`P  - [
 	  w     w    w    x    x    #x    /x    ;x    Gx    Sx    _x 
   kx    wx    x    x    x    x    x    x    x    x    x    x PE CF     rF    F    F    F    F    oG    yG     H    ]H    H 	   1J    J 
   J    6K 
   PK    K    K    L 
   P    Q    ^Q    Q    Q    @R    ZR    R    R    aS    {S    S    S    
T    T    <T    ST    aT    nT    {T    T    T    T     U     )U / /h +/ 't. #d- 4, ( P   [
  y     y    y    $y    0y    <y    Hy     U 9V     yV    V    V    V    RW    `W    W    .Y    =Y    GY    UY     Y "	 "d( T' 4& $ p   x[
 `y  Z <Z     [ "	 "d. T- 4, * p   P[
 py @[ |[     \ "	 "d( T' 4& $ p   ([
 \ ,]     ^ "	 "d. T- 4, * p    [
 0^ l^     _ #	 #t3 d2 41 . P   Z
 y     y    y    y _ `     a    va    a    Zb    b     b 1
 1x -h )tC %dB !4A > P   Z
 y     y    y    y         b c     d    zd    e    f    [f     vf "	 "d( T' 4& $ p   Z
 f f     g "	 "d. T- 4, * p   `Z
 g h     hi "	 "d( T' 4& $ p   8Z
 i i     j "	 "d. T- 4, * p   Z
 j k     Xl #	 #d4 43 . pP   Y
 y     y    y    z l km     m    n    =n    n    8o     So 0
 0x ,h (dB $4A < pP   Y
 z     z    (z    4z         po np     p    q    q    r    r     s 7
 )h %42 ( 
p`P  - Y
 "  @z     Lz    Xz    dz    pz    |z     0s t     Gt    Ut    zt    v    v    9w    w    w    x     %x 7
 )h %42 ( 
p`P  - pY
 "      `x My     wy    y    y    ?{    {    i|    |    |    ;}     U} <
 *hA &d "4  
p  - HY
   z z z           z    z    z    z    z    z 	   z 
   {    { 	    { 
   ,{ 	   8{    D{ 	   P{    \{    h{    t{    {    {           {             8 	   P   { 8       } ~     8~ a~    y~ ~    	        B            2    Q    _    { 	   P 
           %    3 
   A 	    
   υ    D 	       Æ         	       ,    c        щ        3    A    O    ]    k     	   ݋        5    Q    | {     {    {    
 
2P HY
 <
 *hA &d "4  
p  -  Y
   { { {           {            |    |    |    $| 	   0| 
   <|    H| 	   T| 
   `| 	   l|    x| 	   |    |    |    |    |    |           |              	   P   | 8        g          ̍     d    V    f            ʑ     	    
       .         
    	    
   ?     	       3    R    ` 	           ӗ    
    A    x                ͙    ۙ    + 	   M    v             |     |    |    
 
2P  Y
 # p`0- X
 z   }     } @      ʛ         c  4 2p!
 
d T p  Ѝ !   p  Ѝ !   d  T p  Ѝ $ Rp`0 X
               D @           0} 8   @      Ӟ 0}     =}    
 
2P X
 $ Rp`0 X
                @           `} 8        >     s `}     m}    
 
2P X
  2
p!
 
d 4    !      !   d  4    !
 
d 4 @ N  !   @ N  !   d  4 @ N  !
 
d 4    !      !   d  4     R
p`0 X
         }                   @           } 8       `                }     }    
 
2P X
 !
 
d T  Ӣ Ѝ !    Ӣ Ѝ !   d  T  Ӣ Ѝ / 1 	p`0P- XX
 r  У 1     P            = ,4< 2 
p`P  - 0X
   }     } ~    ~    (~ P ˥         #    j        	 t d T 4    d 4 
p  !
 
 T  H  !    H      zx dh &% p`P0!  
  ` ̑ !  	 	
 `   !   `   !    ` ̑  	  0   X
 @~     L~              6     ]     
R0 W
  I       d 4
 
Rp W
       K  
R0 W
         
R0 hW
 0 i      9	 (4A 8 p`P  - @W
               P          A    U                 =
 ,hP (4  
p`P  - W
   `~ l~    x~    ~    ~    ~    ~    ~    ~    ~ 	               ) 
   5 
   A             P      7         	    v                B                 	   * 
   =             
   g     
        
                       4 4 &d  "4  	pP  - V
    P     \    h    t                    
                  4    `                              4    > n     	         
       . 
   8 =
 ,hP (4  
p`P  - V
               p      W         )                ;    b                 	   J 
   ]             
       = 
        
                   8    T 
 
d	 
Rp! 4    !      .  t d 4 	P- V
 J      0      1     ]      < < 7x
 3h /t' +d& '4$  
P   xV
       `     K , ,x $h d T
 4 p h	 	 0   h	 
4 
 p   T
 4	 R`! h t  -  !    -   d 4 p PV
   @ t      	 	 0      d 4 p h d
 4	 Rp.  t d 4 	P- (V
 J   0 < H T `                B         * Z    g      ] ]+ U, M- E. =/ 80 3x1 /h2 +4o f 
p`P    V
 p     |                        Ā    Ѐ    ܀                                   J         	   G                    "    J    i      / / *x &h % 
	p`0P U
             :     ?    ;     F / / *x &h % 
	p`0P U
                      0 U
 @ t       R0 `U
 0 Q     `  R0 8U
         0 U
   T       R0 T
  1     @  R0 T
 `        
  T
   4       R0 pT
         R0 HT
  Q     l  0x- `   ! t    !      &  p`0  -  T
    P           # p`0- S
 z   @           " "d 4	 Rp S
           @     S
 P       { j5 b6 Z7 R8 J9 B: :; 2< -x= )h>  
	p`0P- S
 B           (    4 @    L    X    d p    |  
                   ā    Ё    ܁                         $    0    <           
    M    ~         #         1    d               	   4     A  _  
   q          *! 
   ;!    z!    !    !    !    -"    a"    n"    "    "    #    #    7#    $    &    <)    M)    )    )    )    )    @*    Q*    *    *    *    	+ 
   + <
 *xC %hD  
p`0  - XS
 +  P     \    h    t                      	   ǃ Ӄ    ߃     
                     +    7    C    O    [                                      ˄    ׄ               
      Ȣ             ܢ              	   (    X   	   (    X   	   (    g X               + ;,     |,    ,    ,    -     - 5.    G. .     / /    */    / 
   0    H0 
   V0    d0    }0    0    0    1    a1    r1    1    1    ,2    82    U2    x2    2    2    3    3    3    4    4    4    4    5     
5    e5    5    5    6    <6    Y6          Ђ        H 	   | 
                 t         
 
rP XS
 { j8 b9 Z: R; J< B= :> 2? -x@ )hA  
	p`0P- 0S
 r                $ 0    <    H    T `    l x 
                           ̅    ؅                             ,     6 7     7    
8    >8    j8     8 v9    9    9    $:    P:    ]: :    : 	   :    ; ; 
   1;    ;    ; 
   ;    :<    K<    <    <    <    !=    .=    I=    =    =    =    =    m?    A    D    D    UD    fD    sD    D    	E    E    VE    gE    E    E 
   E <
 *xG %hH  
p`0  - S
 c  @     L    X    d p                     	    Ç    χ    ۇ 
                         '    3    ?    K                                          ǈ    ӈ    ߈       
                                0 	   ( H  | X   	   ( P   X   	   ( X  W X               `F F     <G    yG    G    G     \H H    I I    I I    I    J 
   J    K 
   K    $K    =K    K    K    K    !L    2L    OL    L    L    L    M    8M    LM    M    QN    cN    uN    N    LO    ^O    pO    O     O    %P    \P    P    P    P    Q |                 8 	   l 
             
     d    q     
 
rP S
   
p`0   R
               \ 	   P 8    H   @R `R     R          "     
 
RP R
  0. h 42 . p  - R
 R  0     < @U U     U    U     %V = = 8 3x /h +4> 8 p`P   R
 P \    h    t                     pV Y     Y    Z    Z    X[    t[    \    %]    ^    ^    ^    ^    _  p`0 hR
                @            8       @_ _     *`          
 
2P hR
  4
 
Rp @R
                        0    @            @` h`     p`    x`    `    `    `    `    a  0+
 +t# 'd" #4!  
P   R
 ` b Rb     f 4 4 /	 *x
 &h "d 4  pP   Q
 p `f g     g  d 4 p Q
  i i     j > > 9 4x 0h ,5 (t4 $d3  42 . P   Q
            j k     m    m    n     
o  4	 Rp xQ
           Po o     o    o  4	 Rp PQ
       *      p Ap     Op    p " "d 4	 Rp (Q
 @     j p p     q    Pq ' 'x h 	   4 r
p`P!  r >s H !   r >s H ! h 
t t p !   
t t p ( (h $d  T 4 
p  Q
 pu u     Zw +  	p`0P- P
                       w Ox     tx    x    x    1y     y z    Cz    tz    z    {    p{ D 2# -$ (x% $h& N 
p`0  - P
 +  Ћ ܋                   +    9    E    Q    ] 	   i               č 
   Ѝ    ܍    
         ` 	   (    u X               | |     |    `}    }    }    }    ~        B     	    
               k     u         ό     
   =    ~          bP0   P
 +  	p`0P- P
                 o         ł        Q      <    c            &     D 2# -$ (x% $h& N 
p`0  - `P
 +                  9    K    Y    e    q    } 	              ؏     
           
          	   (     X               0      Ն            ·        =    !    b     	    
   !                              & 
   ]        ɏ      bP0   `P
 & 4 p`P- 8P
 J   0       )    7     ƍ G    U ӎ     
 t	 d T 4 2
 
4 
2`! t @ U 0 !   @ U 0     P
 0        t d 4 P! t  % 
 !    % 
 ( (h $d  4 
p O
                	   P 8    X        )     N          S      bP0   O
 ! t  Ș 
 !    Ș 
     O
 `      ș  4 R
p`P O
 p |                     0 o         ؚ            $    ; 	 	2P0! 
 t	 d P g 0 !   P g 0  4	 2`! t  C h !    C h / 1 	p`0P- pO
 r             Z        !  x    s !       s !     x    s )
 ) x h 4 p2	 2 , x h    h b   x 
 !C
 C 0 '   p ~ ` ! h	 ~  l !   ~  l !   p ~ ` * 0 p`0P  - HO
 r       	     (    b    ̮    = = *  x h   * 0 p`0P  -  O
 r       	     (    b    ̱    % %4) %  p`P  !& & 
 x h 0  x !   0  x !     
  x  h 0  x    N
            !     0 0h ,4  p
`P N
 А     ܐ                             7     F    ~        2    Ϻ    ݺ                      <
 *x %h 
p`0  - N
   @     i    u                ʑ    ܑ                   
       ͒     
                         Ĕ    Д    ܔ                &    2    >    J                  !    -    9    E    Q    ] #   i $   u $    $            )    	   	                                    	   P     X      (   * X      P     X   	   P   V X           м &                 '    T    w         	               =    ` 
           x                .    r                                            ?     Q     !                       4    v "        #    $    %    $    &    $   4 '   F $   T #   p                              (        )    *    )                 
        
   *     8                                     l    }    ە        V     d             bP0   N
 B 1xS -hT )4  
p`P  - N
 "       ̗    ؗ                             , 	   8 	   D    u     	                      S    p                K            @    Q            o 	    
    	            
       r         	       )    C    _     y Q ?* :+ 5, 0x- +h. &df "4e ^ 
p  - XN
                                 Ș    Ԙ                	    
    	        
   (    4                  @    L    X    d    p    |                    ʙ              	   P     8                K            e    z        ]    r     	   ( 
   _    ~ 
    	       { 
       &    ?    M 
   [                #    B    {                             ,    :    H         	                G              
 
2P XN
 @ @
 ; 6x 2h ## p`0 0N
                          (                               P    4 H                     )    e        	    (            X    d    p      `            [                 e 4     A    Q     
 
RP 0N
  d 4
 rp N
 `  D       T 4 	p` M
 p     |                       N          D Dx @h <4> /6 !p`P   M
      Ԛ                  &    d    y          $ $h d> 4= 8 p   M
          (                  O    [             p 	   (   4                              b        ?    #                        4     
 
P M
 :
 (x* $h+ X 
p`0  - hM
   p     |                              Ǜ              	   (            P     ~            x                    )     K O    [     }      
 
P hM
 $ $h d< 4; 6 p   @M
                                +              	   (                                 Z        ,        u                         
 
P @M
 :
 (x( $h) T 
p`0  - M
 {  @     L    X                                        	   ( p  d           @     n    w        B            L                  (     J d     
 
P M
 : : 5h 142 %( p`P   L
      Ȝ Ȝ    Ԝ                       =    	 <
 * %h 0 
p`0  - L
 S             ȝ    ԝ                       	   P (                  `	 	     
 
        !              %    =                  P0   L
 . .x )h $t?  d> 4= 8 	   L
          (                  O    [              	   (   4    p z             0                I    U     w {          4     
 
P L
 :
 (x* $h+ X 
p`0  - xL
   p     |                              Ǟ              	   (            ,     Z    k        T            X             $ (    4     V      
 
P xL
 )
 )x $h d> 4= 8 p   PL
                                +              	   (                             <                J    V     x |               
 
P PL
 :
 (x( $h) T 
p`0  - (L
 {  @     L    X                                        	   ( p  d         ,     Z    c        /    f        7!    !    !     " "    "     5" d     
 
P (L
 <
 * %h 0 
p`0  -  L
 S                       Ƞ Ƞ               0 	   P (                  p" #     # 
$    $    1%    !'              
    k    |          P0    L
 # p`0- K
 z       ' '     
(    G(     ( )  p`0P  - K
                       @) )     )    )    )    d*     * W+    u+ ! t + + 0 !   + + 0  t d
 T	 4 2 T r
p! h 
d
 4 . .  !   . .  ! h 
d
 4 / /  !   / /  Z Z T @ : +x #h  r r j b Z R J B = 8x 4h 04B $8 p
`P   K
           P2 3     R5    Z5     t6 * , p`0  - `K
 [                                D    P P  , H   6 .7    Z7     7 ,     :     BP0   `K
 @
 .x/ )h0 b 
p	`0  - 8K
                      ȡ ԡ         	    	            
   ( 
   4           @    L    X                    ,    8              	   P   d H            8 8     
9    K9    z9    9     v: ;    F;    ;    ;    5<    < <    =    =    b> 	   r> 
   B?    R?    "@ 
   /@    A    A    A    B    B    B    B    D    D    TH 
   `H    oH 	   ~H    H d     q            Ǣ    ۢ         
 
RP 8K
 + +h ' #t d 4 P K
 P     \ H I     J    J     gK @
 .x+ )h, Z 
p	`0  - J
   p     |               ģ    У    ܣ 	    	             
    
   $           0    <    H           
        "    .              	   P   T H                L L     L    %M    TM    M     PN N     O    aO    O    P    P P    Q    Q    R 	   R 
   S    S    T 
   T    bU    V    %V    V    ,W    GW    UW    Y    Y    ] 
   ]    *] 	   6]    B] T     a                Ѥ         
 
RP J
    J
 @     ] ]      R0 J
 P ] h^     ^  
R0 pJ
  ^ 	_     O_  d 4
 
Rp HJ
 `_ _     `  4	 
Rp  J
      c oc     c  
R0 I
 c d     _d  d 4
 
Rp I
 pd d     e  4 Rp I
     pe e     e  4 Rp I
     0f ^f     yf  
  XI
 f f     3g  R0 0I
 Pg qg     g  R0 I
 g h     h  R0 H
 @h gh     h * T 4 p`- H
 Z            ̥                 h i     i    Vi    Hj    Sj     wj * T 4 p`- H
 Z   j k     k    [k    Ml    Xl     |l 
 
t 4 # #t d
 4	 R hH
 @o o     Ep &
 &d
 !T 4
 R
p @H
  `p p     / /x +h	 'T #4  
	p`   H
      r 5s     t &
 &d
 !T 4
 R
p G
  u /u     = / *x &h % 
	p`0P- G
      Pw w     y    T 4
 
R	p` G
      z Iz      d
 T r! x h 
t 4
 0} N}  !   0} N}     4  p`P   xG
 0     } ~     ~  h 
4 
p  a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P   PG
      ǃ     ؃            
    8    _        
     	   G            "    -    8    `             T 4
 
R	p` (G
      9     #
 #h d T 4 p  G
 @ L    X   U     t        ݏ     "	 "T 4  	p`   F
 p           U       
 x-    a a+ Y, Q- I. A/ <0 7x1 3h2 /4q  f 
p	`P   F
              G     X    f    w            ߖ            ? 	   ɜ                                 )  
  F
   Ğ       R0 `F
  0 Q     `  R0 8F
         R0 F
   G     b &  p`0  - E
         
     <    Z J J B
 = 8 3x /h +t- 'd, #4+ $ 
P   E
        " "d 4	 Rp E
  ĥ     ҥ      	 	B  ! 4   9 C !     9 C " "d 4	 Rp pE
 Ц           T     b     / /h
 + 't #d 4  P   HE
      (       `     }             S S
 K C >
 9 4x 0h ,t+ (d* $4) " 
P    E
 @           0 . h 42 . p  - D
 R   ߵ         %      = = 8 3x /h +4> 8 p`P   D
 P \    h    t                     ж      4    T                Z    e    V    
        7    B V H @ 8 3 .x *h &44 * 
p`P  - D
     ^      . h 42 . p  - D
 R  @               ( = = 8 3x /h +4> 8 p`P   XD
     p                  8    T                             " "d 4	 Rp 0D
      ڧ   d     r      t d 4 	 4H @ 
p`P  ! G P   !   P   3	 %46 0 p`P  - D
 z                        ,                              m    |    6 (t/ $d.  4, ( P  - C
 :  @     L    X    d              1             h R00	 0 & x 	h   !    $ !     $ !      $ / / & x h 4 p!  P  t !   P  t !    P  t 8 8 & x h 4 p"
 "4 
p	`P C
 p |     `           R R J B
 = 8x 4h 04- !" p`P   C
                  ̨    ܨ                                                        b        d     Q ?* :+ 5, 0x- +h. &df "4e ^ 
p  - hC
                                      $    0           < 	   H 
   T 	   `    l 
   x                                          ̩    ة                             X 	   P     8       0     1    F                        g 	    
   *    N 
   \ 	   x    K 
                  
   +                             K                                
        e     	                          
    
 
2P hC
 2 2 -x )h %t !d T 4 
	 @C
        0 0x ,h (d $T  4  
p   C
 0     < p 	     5	    l
     
 3	 !4= 6 	p`  - B
   P     \    h                  H               	   P x   t h                     v
    
    
        3     8    T     ` t             ,    9      P0   B
 <
 * %h 0 
p`0  - B
 S             H    T ` l    x x               , 	   P (  `     A     ! J        q    d `     n                ,    9      P0   B
 <
 * %h 0 
p`0  - B
 S             x                          D 	   P (               Q     1 Z    '        t          լ        K    \    i      P0   B
 <
 * %h 0 
p`0  - xB
 S                   ̮    خ خ               d 	   P (               a     A j    7              έ            {              P0   xB
 <
 * %h 0 
p`0  - PB
 S             د                           	   P (               q     Q z    G          "          5    M            ɯ      P0   PB
 " "4
 rp (B
               L @             X   " #     #       .     bP0   (B
 " "4
 rp  B
                @            X   # ($     >$           bP0    B
 +  	p`0P- A
                    , 8    D    P 	       
                     	                            	                                        P$ $      % 3%    G% w%    % %    %    &    /& _&    &    &    & 9 +x
 'h  
	p`0P- A
    ` l x                   ̱ 	       
                     	                            ر     `' '     ( f(    z( (    ( (    !)    H)    i)    }) )    )    ) 	   *    $*    .* g*    	+ F+    V+ 3
 %h  	p`0P- A
                    , 8    D    P 	       
                     	                            	                                        + ,     H, {,    , ,    , -    7-    ^-    - -    -    .    . 8 *h
  
	p`0P- `A
    ` l x                          	       
           ̲ . //     l/ /    / /    0 A0    U0 0    0    0    @1    J1    T1 k1    1 
   R2    k2 2    2 9 +x 'h % 
	p`0P- 8A
             (    4               	       
       @     2 p3     3 4    4 I4    ]4 4    4 4    4    5    ~5    5    5 5    6 6    6  R
p`0 A
         P                   @           l 8        7 H7     R7    c7     r7 l     y    
 
2P A
  R
p`0 @
                            @            8       7 7     7    7     7          
 
2P @
 % % !t d 4 
	 @
                 @           г X       P8 8     : :     ߳     RpP0 @
  R
p`0 @
                            @           , 8   ; @;     N;    ; ,     9    
 
2P @
 % % !t d 4 
	 p@
               @  @           P X       ; ;     #> I>     _     RpP0 p@
    4 Rp` H@
                             @            8       p> >     >    >     >          
 
2P H@
  4 Rp  @
         д                  x @            8       ? :?     H?    V?          
 
2P  @
  4 Rp ?
                            @           , 8       p? ?     ?    ? ,     9    
 
2P ?
  T 2`! 	 t 4 ? ? h !   ? ? h  d 2p! T 4  A :A  !    A :A  ! T 4 PB jB  !   PB jB  /	 !h 4   p`P  - ?
    P \    h    t                    @C C     C +D    mD    D    D 7E    yE    E    E CF    XF F    F ! 
   
  k ] C ;x 1h #t0 #d/ #4. #( P   T 4 p`!    O ^O 0 !    O ^O 0 
 d T 4 p!  Q  R l !   Q  R l  h
   v l ^ F + x	 d T 4  p  ( (h $d  4 
p ?
              ̵    ص                  H 	   P      8       pW W     W    W    %X    7X    >Y     HY          
 
2P ?
  4& $ p   ?
                                   	   (	      8   pY Y     Y    Z    mZ     yZ Z     Z      
 
2P ?
  d	 4 RpY Yh  0  ' 'h "d T 4
 
rp X?
     0^ _     _ ' 'h "d T 4
 
rp 0?
     _ 'a     Ma #
 #h t
 d 4 r ?
 a Hb     rb " "d 4	 Rp >
 d $e     2e    e " "d 4	 Rp >
 e e     e    @f " - 	p`x- @  !C
 Ch 8, &4 T3 42 h h  !   h h  	 d T 4  p   >
 @     L    X     l Fl     l    l    m    m     n    T
 4 
R	p` h>
 p |     n n     @o    Po )  	p`0Px-   !/
 /< &x= h> ~ Ԉ po p  !   po p  ! 
  <  x=  h>  ~  Ԉ po p  3	 %49 0 p`P  - @>
 z  0{ {     {    "|    >}    ~    ~     4* 	( p   >
  ~      W !    $ !     $ !      $  x h 
-  =
                          P +     - Æ     ֆ        # <      k 
	`P!*
 *2 x3 h4 tj 4s `  
 !   `  
  4
 
Rp =
                 @           ж 8             ގ ж     ݶ    
 
2P =
  4
 
Rp =
               x @             8             >       
    
 
2P =
 1	 #h
  p`0P  - x=
    0 < H T    `    l x                	       
                     
                                                             P Ǐ      7    K {                 3 c            ő 7
 )x
 %h !4!  
p`P  - P=
       ķ    з    ܷ                  	       
                     
                         P ̒      O    c      ד    	    0    Q    e                      2 $x
  h  	p`0P  - (=
      ( 4    @    L X    d    p        	       
                     
                                                  h      ؖ         0 `            ܗ     3    d    n ; -x )h
 %4'  
p`P  -  =
                ȸ                      	       Ը      y      	     M    a      ՚        #             ޛ            ќ 6
 (x $h
  
	p`0P  - <
                , 8    D    P        	       
                  0       @    T      Ȟ        "    C s            &    0    : ! t  / 
 !    / 
 $
 $d  4 r
p <
               P @           ` X        
     o     RpP0 <
 ! t   
 !     
 $
 $d  4 r
p <
                @            X    ݨ          RpP0 <
  
p`0   `<
                           p @            H             A    Z                2pP0 `<
  `  ! T    ! t 4  T    !   t  T  4       ! 4  @ T ( !   @ T ( ! 4   Ѯ ( !    Ѯ ( !
 
t d   ( H !     ( H !
 
t  4 `  ( !   `  ( !
 
t d @ h H !   @ h H . .4= 4 
p`P   8<
       5      UeDx  =h! 6tL /dK (4J cD 
P- <
   `           t ! 4   
 !     
 !   4   
  
R0 ;
 P        d 4
 
Rp ;
  .       
R0 ;
       ?  d 4
 
Rp p;
 P        4 Rp H;
     `        4 Rp  ;
       N     i  d 4
 
Rp :
       ' & 4 p- :
 z    y          . 4  p`P  - :
              	 - d 4  p  - :
    0          A . 4  p`P  - X:
    p (     W    } &  p`0  - 0:
         $     S    q  
  :
       C  R0 9
 `        R0 9
       ,  R0 9
 P w       
  h9
       3  R0 @9
 P q       R0 9
         R0 8
 @ g      s st 
 ! 4  :  !    :  " "d 4	 Rp 8
 p       T     b     " "d 4	 Rp 8
      ں       "    p Pe?h 841 &c!& p`P- x8
               ' 'd #T 4  
p   P8
                X     t    Z } }  x 0! h  ]  !    ]  3	 %40 ( p`P  - (8
 :                5    D     @ `0P  ! I H tF p  x !   p  x !   I  H  tF p  x  "p0  !    d T
    !       d 4 p! t d 4   
 !     
  4* 	( p    8
   3     w = = 8 * %   x h 4  p  V V H 3 + # x h 4  p  : : $ x h 
4 
p, ,     !  x @   !   @   * * h  !  ` J 0 !   x J  @ !   J  @ !   ` J 0 @
 @ , "   ! x 0   !   )  ! h )   !   )   !    )  !   0   9 9 !x 
 !  h  E  !  E   $ !     < !      < !   E   $ !    E  9 9 &x h 
  !     !     !      !        0  ' 7 p`P0- 7
    8             >    m ' 't #d 4 
P 7
       ,                    +  d Rp! T	 p   ! h 
 4    !      !   p   /
 /t" +d! '4   
P   7
     P      S )
 )h
 $t  d T 4     `7
 @  E      ! T   x
 !     x
  d
 T	 4 Rp 87
        -     I !" "t  d 
T 4   G ( !     G ( ! t  
d 4     ( !       ( !" "t  d 
T 4 `" " ( !   `" " (  Bp
`  !$
 $  
 
T	 4  $ $ ! !    $ $ ! ! t  
d 4 $ $ ( !   $ $ ( 6
 3 
	p`0P- 7
        & t&     &    &    '    g'    6
 3 
	p`0P- 6
       ' (     !(    Y(    (    (     2pP!
     
d 4	 ) N) " !   ) N) "   P!   t d 4 + , " !   + , "  
R0 6
 - -     /.  d 4
 
Rp 6
 @. .     .  4 Rp p6
     / /     / . 4  p`P  - H6
    p5 $6     S6    y6  @ 
	`P  ! > t? 4F 6 6 # !   6 6 #  " P   R0  6
     `9 9     9  
  5
 9 9     C:  R0 5
 `: :     :  R0 5
 : ;     ,;  R0 5
 P; w;     ; " "d 4	 Rp X5
 ; ;     <    P< " "d 4	 Rp 05
 p< <     <    =  4 Rp 5
     0= ^=     y= " "d 4	 Rp 4
 P     z = =     >    P> IE;h 7t! 0d  )4 C 
P- 4
      p> >      ?    @ W
 Wx 8h  4J B 
p	`P  ! I @ GA @& !   @ GA @& U U K = 4 & ! x h	  K K : 1 ) "x h d 4 p x
   | r l ^ F +	 h d T 4  p  ! 4   L %L ( !    L %L ( !  t d pN N H !   pN N H !  t d O O H !   O O H  p  ! 4 R R ' !' '  d R S ' !   R S ' !   R R '  . `P  !p ph :* /+ $, t- 44 PT ~T ' !   h  *  +  ,  t-  44 PT ~T '  
R0 4
     V 	W     OW  d 4
 
Rp h4
 `W W     X  d 4
 
Rp @4
        X pX     X    X  d 4
 
Rp 4
 л     ܻ X  Y     Y    $Y  
  3
 [ [     \  R0 3
 0\ Q\     `\  R0 3
 \ \     \  T 4 `  ! t  ] {] ) !    ] {] ) " "d 4	 Rp x3
     ^ ^     ^     _ " "d 4	 Rp P3
       @_ _     _    _ Pe?h 841 &c!& p`P- (3
        ` a     9d 3	 %49 0 p`P  -  3
 z  0     <    H    T    `    l            d e     Ge    re    f    g    h    0
E"h t d 4 C
P  x- `   /
 /t" +d! '4   
P   2
 m m     n /
 /t" +d! '4   
P   2
 o p     p O O G ? 7 2 *x  $h!  4O  D 
p	`P  i i2 a3 Y4 Q5 I6 A7 98 29 *x: $h;  4  x 
p	`P  !" "t  d 
T 4 p{ { ( !   p{ { ( ! t  d 
T 4 } =} ( !   } =} ( " "4 
p	`P 2
   9     C Ne=h 6t< /d; (4: c4 
P- `2
          d         ?     V  	  h d 4  p   82
   7     k  t d 4  t T 4 ! d P  - !   P  - " "d 4	 Rp 2
     `            
 ) 
	p`P0! 
  ^ U
 L @ 3 ' x h   ō 0. !     ō 0. 	 	2p0!  
d	 T P q . ! 
 q  . !   q  . !   P q . !" "t  d 
T 4   ( !     (  T `  !
 
t 4   < / !     < / ! t   0 !     0 9 9 "% p`P0!{ {	 m
 X I =
 1   x h  5 t/ !    5 t/ !   	  
      
      x  h  5 t/ 
 
0!,
 ,  ( t d T 0 z 0 !   0 z 0 <5.h *t #d 4 3
P  - 1
 R              ) )d: %49 2 	pP   1
              d 4
 rp 1
       ޼     -	%t d
 4 #P  - p1
 B   м             , ,1 pP!I Ih :+ ', #- . 
d/ 40 0 \ h1 !   0 \ h1 L L 7 " p`P0!| | g C 9 	 x
 h `  1 !   `  1 1
 1h -4# ! p
`P   H1
           P          *         p
 ph hd+   
p0P  !  t d   H !     H !d d	 [
 O B 9
 0 $ x h   t/ !     t/ !   	  
      
      x  h   t/ ! !dK !4J !B pP  ! h  I   D3 !   h    D3 !     D3 '
 'tK 'dJ '4I 'B P  !* * ! x h   R 3 !    R 3 !  t d   H !     H      T 4 
R	p`  1
      H       T p  !
 
d 4  - X4 !    - X4 /
 /t0 +d/ '4. ( 
P   0
      N     ) /
 /t0 +d/ '4. ( 
P   0
         9 
0P! 5 6 t7 d8 P  5 !   P  5 !   6  t7  d8 P  5  	  h
 d 4  p   0
     0        BE1h *+ #* d) 4( C	& Px-      ! t d 4  H 5 !    H 5  d
 T	 4 Rp  8
 Y
     
    	 "           P  
 
4
 
rP t	 d 4 2     $       d 4 2p      3     	 4 rp`    A  O  	 	b   rp`0 4  P   t 4 2P
 
4	 
2P       M M ? 3x "h 5 p
`P!    47 !. . 	  )  T7 !	 	 )  W  h7 !   )  W  h7 !    )  T7 != =2 *3 4 4= i# # 7 !     47  20 R0
 
4 
2p 20%	 4- $ 
p`P  x-   " "t 20 % x-    B   B  
 
4 
Rp 20
 t d
 T	 4 R B   B   20! 	 t 
d T 0. C. 8 !   0. C. 8  20
 
4 
2p d 4 2p 4 p R
pP0! d
 1 1 8 !   d
 1 1 8 !   d
 1 1 8 !   d
 1 1 8 
 
4 
2p! d p4 4 T9 !   p4 4 T9  20 d	 T 4 2! t @6 6 9 !   @6 6 9  20
 
4 
2p 20u ut 
4 
2`
 
4 
2p 4 2
p`P 4  d 4 2p
 
4 
2p B  ! 4  A A 4: ! t  4  A A 4:  B  ! 4  B YB h: ! t  4  B YB h: !    B YB h:  B  ! 4 B 9C : ! t  4 B 9C : !   B 9C :  B  ! 4 C D : ! t  4 C D : !   C D :  B  ! 4 D D 4; ! t  4 D D 4; !   D D 4;  B  ! 4 E E x; ! t  4 E E x; !   E E x;  B  ! 4 `F F ; ! t  4 `F F ;  B  ! 4  G yG ; ! t  4  G yG ; !    G yG ;  B   B   B   B   B   B   B   B  C
 CT	 >4 d
 2
p d T 4 p T	 4 2p!  d `K K < !   `K K <  2p 4  2p`P! 4 M M < !   M M < 
 
4 
2p T 4 Rp`! 
 @O O $= !   @O O $=  T 4 R
p`
 
4 
2P!
 
t d `R R p= !   `R R p= !   t  d `R R p= !   t  d `R R p= 
 
4 
2p
 
4 
 p   4 2
p`P
 t	 d T 4 2 B0  !  \ \ > !    \ \ > !H
 HT : 5t
 0d	   \ \ >  b   B   B   B   B   B   20 b   d 4 2p B  
 
4 
2p T 4 Rp`
 
d 
2p! 4 k Zl > !   k Zl >  t 20 d 4 2p! T m ~n $? !   m ~n $? 
 
20 d	 T 4 2p!  p p `? !   p p `? !    p p `? !   p p `?  4 Rp
`P    t d
 T	 4 2
 
4 
2p B  
 
4 
2P! t d x x @ !   t x x @ !   x x @  t 20 20 20	 	B   d 4 2p d 4 2p d T 4 2p
 d T 4 p
 t	 d T 4 2
 
4 
2p d 4 2p B     B   d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20 d 4 2p
 
4 
2p 20 20 d 4 2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p 20
 
4 
2p
 
4 
2p
 
4 
2p 20 d 4 2p 20! t	 p  PB !   p  PB  d 4 2p 20
 
4 
2p
 
4 
2p B   B  
 
4 
2p 20
 
4 
2p B   B   20 20 B   B   B  
 
4 
2p 20 d 4 2p 20! t	  ' 8C !    ' 8C  B  
 d
 T	 4 2p T
 4 2p`. .t *d &4 
P P          Ž    ѽ @ t             g    t        %      2P'
 '4 
p`P x      ݽ   -     A          2P6 (4   
p`P  -              D        P                                                         2P, ,4"  
p`P   ȿ \              `                                2P'
 '4 
p`P        0 ]     q    .      2P, ,4"  
p`P    ޾                    )    2    >        6    P      2P'
 '4 
p`P @ 7     +                 2P- -x )h %4 
p	`P h l     ` 0 c     w    a      2P' d 4 p-  j      -      2P
 d
 T	 4 2p B  
 t	 d T 4 2 2	p`P0 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p\ \T rp`0x- 8   
 
4 
Rp9
 +t! 'd  #4  
P  -          ǿ    ӿ 	 	     -	    =	    ;	    	     	 9
 +t! 'd  #4  
P  -     ߿          	 *		     =		    M		    K	    	     	  d 4 p        	 
	     
	    
	     9	  d 4 p 0      ' 	 	     	    	     	 9
 +t! 'd  #4  
P  - X    3     ?    K P	 	     	    	    	    %	     	 9
 +t! 'd  #4  
P  -     W     c    o `	 	     	    	    	    5	     	 9
 +t! 'd  #4  
P  -     {          p	 	     	    	    	    E	     	 *
 *4 
p`P        	 	     	     	     E!	  t d T
 4 r9
 +t! 'd  #4  
P  -                   )	 ?*	     X*	    a*	    q*	    	1	    s1	    2	     2	  B  
 
4 
Rp, ,4  
p`P                           05	 n5	     5	    5	    9	    :	    #:	    K:	    o:	    :	    =	    $>	     N>	 	 $ 
p`0   H          #                           O @           / X   >	 >	     >	    >	     @	    @	    D	    D	     D	 /     <    c     
 
rP H 
 
4 
Rp  	  !e e ]d   t T 4  F	 :F	 O !     F	 :F	 O !    F	 :F	 O !         t  d  T  4  F	 :F	 O    P  !u ud #    
t 4 X	 X	  P !    X	 X	  P !   X	 X	  P !           t  d  4 X	 X	  P  T
 4 rp`  
  !m m bT   t d 4 @n	 ^n	 P !    @n	 ^n	 P !   @n	 ^n	 P !         t  d  T  4 @n	 ^n	 P  T
 4 rp` b  !6
 6 1t )d 
T 4 |	 )|	 XQ !   |	 )|	 XQ ! 
    t  d  T  4 |	 )|	 XQ )	 ! p`0   p q     }                                    R @            8    	 A	     N	    _	    j	    G	    	    	    	    1	     P	               
 
2P p  d T 4 p*	 *4  p`                                    $S @            8   	 	     	    	    /	    	     	          /     
 
2P  #
 4 
p`Px- X    	p`P0x- @   
 d T 4 p t d
 T	 4 2 	p`P0x- X    BP  !; ;t
  
d	 4 	 	 $T !   	 	 $T : :	 5t -d 20   !\ \ , $t d 
T
 4 `	 h	 tT !   `	 h	 tT M
 M
 T 4 Rp`% I Px-    ! 4H 	 	 T !
 D #C E tF dG 	 	 T !   	 	 T !   	 	 T !   C  D  E  tF  dG  4H 	 	 T #
 4 
p`Px- `   D
 Dt d	 T 4 2
 d T 4 p   x-    !$ $  t d T 4 	 	 U !    	 	 U !   	 	 U 
 d T 4 p P  !^ ^ 1 " t 
d
 4 
 
 ,V !   
 
 ,V  bP  !' '   t 
d 4
 

 

 pV !   

 

 pV  T	 2! t d 4 
 
 V !   
 
 V  2
p`0! 
 
 T
  
 P
 V !     
 P
 V !   
    T
  
 P
 V 
 t	 d T 4 2 20 20 d 4 2p t d T 4 #	  
p`0    =     I                       U                    X @           r 8    
 =
     Q
    
    
    3
    `
    
    
    I 
    X 
    k 
    :"
     k"
 r               2P
 
2P   d 4 2p)	 !" p`0                                          :                                                                Y             Y    
         Y             Z @            8   @           Z 8   @            8   @            8   P#
 #
     #
    #
    (
    (
    (
    )
    0)
    Q-
 	   -
    -
 
   -
     .
    2.
    .
    .
 
   .
    3
    *3
    7
    7
     8
          ,     g                      /      2P
 
2P   2P
 
2P   2P
 
2P  
 
2P   4 
p`Px- X    d 4 2p6 (40 & 
p`P  -  *  I     =    r    ~     <
 <
     <
    2=
    B=
    wC
    C
    C
    QD
    D
      2P6 (40 & 
p`P  - 8 *                    D
 5E
     UE
    E
    E
    K
    L
    CL
    L
    L
      2P; -x )h %4*   
p`P  - `              PM
 M
     M
    M
    n
    x
     
  ' `P! 4* 
 "
 p] !
 " # $ 
% t& "
 &
 |] !   $ "
 &
 |] !   "
 &
 |] !   
 "
 p] !   "  #  $  %  t&  4* 
 "
 p] 9
 +t1 'd0 #4/ ( 
P  -  :        @
 
     
    
     
  20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p h R0 B   B   20 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p B  
 
4 
2p B   B   d T 4 2p bP  !' '   t 
d 4
    ` !      `  T	 2! t d 4 p
 
 D` !   p
 
 D`  2
p`0! 
 
 T
  
 0
 |` !     
 0
 |` !   
    T
  
 0
 |` 
 t	 d T 4 2 20 20 B                            <a 	   H (    8   	   x1 0   L 8   	   # 8    8   	   ( @    8   	   H H    8   	   (	 P   v 8   	   A X    8   	   8E `    8   	   H h   g 8   	   4 p    8   	   P x    8   @           X 8                    >     Y    w                       '    h                           Y     t                  ,    J     e    }     
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P  
 
2P   B   20# 4 rp-  2           1	 #t! d  4  P  -                                    	           N    s                    O             *    O    `    s    }      2P d
 4 
Rp ( %       /  20 B  ? .4  
p`P  - P :  1     =    I    U    a    m    y             	    
            
                   !    -    9    V    b    n    z                                      !         #      w                 >    X         	    
   	     
                              -!    f!    !    !    !    "    R"    ^"    "    " !   " "   !# $   Y#    #    #    $    $    $    $    $     $  2P 20   ! 4
 ' ' g !   ' ' g    ! 4
  ) H) h !    ) H) h 
 
4 
2p 2p! 4  + b+ Lh !   4  + b+ Lh !   4  + b+ Lh !   4  + b+ Lh !   4  + b+ Lh !   4  + b+ Lh  B  
 t	 d T 4 2        h 	x    h 	x       P            p                       `i                    i n i                                 d                 p
         8   \                 `     m                    k l j r i v m                                    H (          K                  V     Xw                     `     x                     XI         (   0`                      Hu                     4             /                      Hn                    o 8r i                      (          ]                 G         X   0                `         h   ^                      l                    pt u 8r i s u                                             ]                  5         @                         hn                     P         8    ]                q q `r 8r i s u                                     0=         P   `_                       q                    s w i                           (k                     `          @   @                i r i                    n i                      P         0                 -     pv                    
         X   -                l l i                    pk  v t Hk t u                                       (u                     H            @`                 H            K                  H             _                T         X   V                       m                     `7         8    \                 H         @   `W                (v i                @8         X   c                o xx s w i s u                                           Xt                          o                    r w i                          k                           (s                     .         @   @.                 `(         @   P                 #            ^                P-         X                          v                    `s w i                    /         X                          s                           @w                     H
            0                  8E            ^                 x1            06                  (            s                          X   P                           8   ]                n w i                    r i                 A            \                               P:                o n i                           Hs                             (   c                 c     p                     0     w                    w i                L         X                    P (          p                           (   c                 ^     i                            w                    u 8r i                    v @l n w i s u                                              @   p                      @         0                 4            @_                 @'         @                    
         8   _                       8m                     n p j 8r i s u                                    7         X                   `r 8r i                      (       (   c                 s @q i                    8r i                8o o w i s u                                       p                      .            PY                 r Px r w i s u                                    hq xm t 0j t u                                           @                    PL         @   pd                 gY    x          x x x  -y   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200.cp35-win_amd64.pyd PyInit_stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1133315588165816200             @{         v  pz            }          h            x~                    .           N p ~         p 0            `~                                             £     ڣ                         0     B     V     p                    Ҥ                    0     F     \     v                                 ʖ          J          ڗ               6                         ސ          N     z               ڑ               N     t          Β               D               *          >     V     :                         v     P               ء               J          Ơ          B               l     .               ^          Н          @                v     0               j     .               h               <     И          X     n             Х     ڥ                         $     :     `          x                    ة                  8     H                            Ҧ                  L                         "     *     0     8     >     D                       Ԩ     ʨ                    l     J     0               ħ     `             ʦ                    t     j          V                                           
             ܦ     ~                  ̍                    x     f     N     @     *               ތ     Ќ                         p     `     R     8     (                         ̋                    z     Z     L     :     "               ڊ     Ċ                    ~     n     ^     L     <     $          *               Ɖ                    p     `     L     4     "     
               Έ                    ~     j     N     :     &                    ؇     ȇ                    n     ^     H     4                    چ     Ɔ     @          R     b     v                              p     ؎                         X     "     6     H     \     p               F     *          ď     ڏ                    ,     <     P     d                         
               ҅               |     j     X     >     *                    Ԅ                   PyBaseObject_Type kPyObject_SetAttr  PyUnicode_InternFromString  < PyCFunction_Type  .PyOS_snprintf PyThreadState_Get _Py_CheckRecursionLimit  PyExc_Exception  PyErr_SetObject  PyErr_GivenExceptionMatches v_PyObject_CallFunction_SizeT  PyLong_AsUnsignedLong  PyErr_WarnEx  PyExc_RuntimeWarning   PyErr_PrintEx VPyFunction_Type EPyFrame_New  PyExc_DeprecationWarning  PyExc_KeyError  uPyImport_ImportModule wPyImport_ImportModuleLevelObject   PyErr_NormalizeException  KPyUnicode_AsUnicode iPyObject_SelfIter  PyErr_Occurred  PyLong_FromSsize_t  kPyUnicode_DecodeUTF8  MPyObject_GenericGetAttr PyTraceBack_Here  PyExc_RuntimeError   PyExc_IOError lPyObject_SetAttrString  PyLong_FromLong LPyObject_GC_UnTrack PyUnicode_FromUnicode YPyObject_Hash  PyErr_SetNone PyExc_MemoryError  PyDict_GetItemWithError Py_GetVersion RPyObject_GetAttr  4PyFloat_AsDouble  PyLong_AsUnsignedLongLong PyRun_StringFlags ' PyBytes_AsStringAndSize #_Py_NoneStruct  
PyTuple_New PySequence_Contains  PyDict_SetItemString   PyDict_Size 7PyFloat_FromDouble   PyExc_AttributeError   PyErr_SetString  PyErr_WriteUnraisable VPyObject_GetIter  PyNumber_Add   PyErr_WarnFormat   PyEval_EvalCodeEx $PyExc_ValueError  _Py_CheckRecursiveCall  PyLong_FromUnsignedLong  PyDict_Next  PyErr_Format   PyDict_Type  PyExc_ArithmeticError gPyObject_RichCompare  PyTuple_Type  _Py_FalseStruct <PyFloat_Type  PyMethod_Type PyLong_Type PyType_IsSubtype  PyNumber_Subtract  PyErr_Restore 
PyExc_OverflowError qPyImport_GetModuleDict  PyModule_GetDict   PyErr_ExceptionMatches  C PyCapsule_GetPointer  JPyObject_GC_Del  PyErr_Fetch =PyObject_CallFunctionObjArgs  PyLong_AsLong CPyObject_ClearWeakRefs  cPyObject_Not  PyUnicode_FromFormat  TPyObject_GetBuffer  PyList_New  PyModule_Create2  PySlice_New dPyImport_AddModule  PyType_Ready  SPyObject_GetAttrString   PyErr_Clear PyList_Append 3 PyBytes_Type  YPyUnicode_Decode  T PyCode_New  -PyException_SetTraceback   PyDict_SetItem   PyDict_New  PyUnicode_Type  ;PyObject_CallFinalizerFromDealloc ]PyObject_IsInstance PyExc_StopIteration PyList_Type  PyDict_GetItemString   PyDict_GetItem  UPyObject_GetItem  @PyObject_CallObject  PyErr_CheckSignals  KPyObject_GC_Track 0 PyBytes_FromStringAndSize rPyImport_Import PyExc_NotImplementedError SPyUnicode_Compare ^PyObject_IsSubclass PyExc_TypeError PyMem_Realloc ; PyCFunction_NewEx K PyCapsule_Type  _PyObject_IsTrue PyExc_NameError PyTuple_Pack  _PyByteArray_empty_string Py_OptimizeFlag _PyUnicode_Ready  PyMem_Malloc   PyExc_IndexError   PyExc_ImportError *_Py_TrueStruct  
 PyArg_UnpackTuple PyExc_SystemError  PyExc_AssertionError  mPyObject_SetItem  _PyObject_GC_New  PyTraceBack_Type   PyExc_GeneratorExit  PyEval_EvalFrameEx  PyUnicode_FromString  nPyObject_Size  PyBuffer_Release  9PyObject_Call $ PyByteArray_Type  PySequence_Tuple  PyUnicode_FromStringAndSize _PyObject_GetDictPtr  python35.dll   ??1_Lockit@std@@QEAA@XZ m ??0_Lockit@std@@QEAA@H@Z  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z  ?classic@locale@std@@SAAEBV12@XZ  ?uncaught_exception@std@@YA_NXZ ?_Xbad_alloc@std@@YAXXZ ?_Xout_of_range@std@@YAXPEBD@Z  ?_BADOFF@std@@3_JB  ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ?id@?$numpunct@D@std@@2V0locale@2@A ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A ?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z  ?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z ?_Xlength_error@std@@YAXPEBD@Z  ?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z   ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z 
??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z a?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z  ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z  4?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z  ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  / ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ ?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ ?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z  D?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ h?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ '?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z  ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ   ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z % ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z  ??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z  ?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z  3?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z l??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  } ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ  ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ (?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ 8?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z ;?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  ?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ   ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ C?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z F?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z  ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  v?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ q?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z D?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ  ?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z   ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z   ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z   ??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ  \?exceptions@ios_base@std@@QEAAXH@Z  ?always_noconv@codecvt_base@std@@QEBA_NXZ  ??1facet@locale@std@@MEAA@XZ  u ??0facet@locale@std@@IEAA@_K@Z  ?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ ?_Incref@facet@locale@std@@UEAAXXZ  1??Bid@locale@std@@QEAA_KXZ  ?_Gettrue@_Locinfo@std@@QEBAPEBDXZ  ?_Getfalse@_Locinfo@std@@QEBAPEBDXZ ?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ  ?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ  ??1_Locinfo@std@@QEAA@XZ  l ??0_Locinfo@std@@QEAA@PEBD@Z  MSVCP140.dll   CloseHandle 1EnterCriticalSection  LeaveCriticalSection  
DeleteCriticalSection SetEvent  ResetEvent  WaitForSingleObjectEx  CreateEventW  vGetModuleHandleW  GetProcAddress  RtlCaptureContext RtlLookupFunctionEntry  RtlVirtualUnwind  UnhandledExceptionFilter  iSetUnhandledExceptionFilter GetCurrentProcess TerminateProcess  ~IsProcessorFeaturePresent wIsDebuggerPresent AQueryPerformanceCounter GetCurrentProcessId GetCurrentThreadId  GetSystemTimeAsFileTime DisableThreadLibraryCalls aInitializeSListHead KERNEL32.dll  " __std_exception_destroy = memmove ! __std_exception_copy  6 _purecall : memchr  # __std_terminate @ strchr   __CxxFrameHandler3  0 __vcrt_InitializeCriticalSectionEx   __C_specific_handler  > memset   _CxxThrowException  % __std_type_info_destroy_list  VCRUNTIME140.dll   fputc  calloc  E clock  toupper w fflush  t fclose   log1p e isalpha x fgetc 8 _invalid_parameter_noinfo $ _unlock_file   _lock_file   fwrite  ! _errno  y fgetpos  setvbuf 0 _time64  free   ungetc  n isspace  fsetpos h isdigit / _fseeki64 9 _invalid_parameter_noinfo_noreturn  9 _get_stream_buffer_pointers  malloc   _callnewh ? _seh_filter_dll  _configure_narrow_argv  3 _initialize_narrow_environment  4 _initialize_onexit_table  < _register_onexit_function " _execute_onexit_table  _crt_atexit  _cexit  6 _initterm 7 _initterm_e api-ms-win-crt-stdio-l1-1-0.dll api-ms-win-crt-heap-l1-1-0.dll  api-ms-win-crt-time-l1-1-0.dll  api-ms-win-crt-string-l1-1-0.dll  api-ms-win-crt-math-l1-1-0.dll  api-ms-win-crt-runtime-l1-1-0.dll api-ms-win-crt-filesystem-l1-1-0.dll   __RTDynamicCast ; memcmp  < memcpy  T atan  U atan2 | ceil   cos  exp  floor  log  log10  pow sin sqrt  tan                                                                                                                                                                                                                                                                                                                                                                                                                                                  2-+  ] f      /                              Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       
        Summary statistic table.

        Parameters
        ----------
        fit : StanFit4Model object
        pars : str or sequence of str, optional
            Parameter names. By default use all parameters
        probs : sequence of float, optional
            Quantiles. By default, (0.025, 0.25, 0.5, 0.75, 0.975)
        digits_summary : int, optional
            Number of significant digits. By default, 2
        Returns
        -------
        summary : string
            Table includes mean, se_mean, sd, probs_0, ..., probs_n, n_eff and Rhat.

        Examples
        --------
        >>> model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        >>> m = StanModel(model_code=model_code, model_name="example_model")
        >>> fit = m.sampling()
        >>> print(fit.stansummary())
        Inference for Stan model: example_model.
        4 chains, each with iter=2000; warmup=1000; thin=1; 
        post-warmup draws per chain=1000, total post-warmup draws=4000.

               mean se_mean     sd   2.5%    25%    50%    75%  97.5%  n_eff   Rhat
        y      0.01    0.03    1.0  -2.01  -0.68   0.02   0.72   1.97   1330    1.0
        lp__   -0.5    0.02   0.68  -2.44  -0.66  -0.24  -0.05-5.5e-4   1555    1.0

        Samples were drawn using NUTS at Thu Aug 17 00:52:25 2017.
        For each parameter, n_eff is a crude measure of effective sample size,
        and Rhat is the potential scale reduction factor on split chains (at 
        convergence, Rhat=1).
              Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              8B                              1   Я   P                   HB   0                      |      @                   XB                          hB                          xB      `                   6   @                                                B                          B   `                      <      @                                                                   Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.
                                      
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
                                 @                                                           0	                   8\          l                      H\          H              X\                                              <
                          I   P7          `[   <)    1          [   -   p4          8Y                                   Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

                                                      G           @_                                                                                                                       Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.
            If np.int is specified, the histogram will be visualized, not but
            kde.

        Note
        ----
        This is currently an alias for the `traceplot` method.
                                  \   p               .                                                                                                                   @             `0                   8               5      p                                                                                                                                              0.   H=                         X=      P                      0                      T      p                   ,      к                         0                   +                         h=                          x=                         =   `                      =      @                   =       ж                                                                   \   .   -   \           \   -   -   \                                                            @   
                  @   
                   @   

                  1   
             0@   	             >   	             @@   Щ	                  P@   	          б   `@   Ж	                  h@   @	          @   x@   	          p   @   	             @   `z	          @   @   l	          @   @   X	          0   @   @E	             @   >	             A    5	                   A    4	                  0A   3	                  @A   03	                  PA   )	                  hA   !	                  A   p	                  A   `	                  A   P	                  A   @	                  A   	                  A   	                  B   	                  (B   	                                                  Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

                                     E                                                                                                                                       @                                                                                                                                                                                                                           Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
           parameter (or quantile) name(s). If `permuted` is False,
           `pars` is ignored.
        permuted : bool
           If True, returned samples are permuted. All chains are
           merged and warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are
           discarded. If `permuted` is True, `inc_warmup` is ignored.
        dtypes : dict
            datatype of parameter(s).
            If nothing is passed, np.float will be used for all parameters.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

                                         B   p               p                                   P	              P                   	                            D      C   `   p                                   @                                                      
           @                                                                                                                                                                         R                                          F                   P                                                                                                                    @                                                                                                                                                                                                                                               G                   @                                                                                                                    @                                                                                                                                                                                                                               p8
             Transform parameters from unconstrained space to defined support                                       `E                                                                                                                                        @                0                                                                                                                                                                                                      Transform parameters from defined support to unconstrained space                                       =   p                                                                      P                                                    D      >                                                     p                                                           p                                                                                   =                     (=   `
                  8=                                                     Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                     b                            i                           (g   `                         @h      (                      a   8   &                      a       &                      a                           h   $                        Hf                           Xe      <                      Pa      #                      xj                           h   p                        h                           a                           b   (                        i                           8j                            h      $                      g   l                        h   `                        e                           0h   0                         i   H   
                     Pb       	                      d      %                      Xg   @    (                      e      A                      h                           f   L                        c   (                        e   <                        pb   h                        g   @                        j                              d   (                        a   8                        (b                           xg                            g                           hh                           8c      	                     0c                           pa   x   
                     hg   (                        H^                           `a       
                     hf                           b                           _   x                         (d   0                         e                           e                           g                           a   $                        f                            hi                           (h      	                     `b                           i   x                        Pe   `                        8b                            g   (                        @j      
                     c   h                        Ph                           ^                           b   H   
                     h                           h                           h      L                      i                           (j   P                        b      
                      j   D                        ha   `   	                      f                            c                           ^                            g   H                        b   t                        ^                           xh      +                      f      
                     Xi                           g                            j                           Hg                           Pj                           b   x   
                     Xa   X                        Pg                           He                           e                           f      
                     (f                           e   H   
                     g                           g   x                        b   t                        h       
                     a                           b      
                     b   X   
                      h                           f      
                     ^      	                     e                           xf      	                     c      
                     i   L                        e      
                     f                           ^   @                        0i   h   .                      8f                           hc                            (c                           (i   8   
                      e                           b   x   	                     Pc                           `e   x   
                     (e   X                        @b                           f   d                        Pf                           e                           e   8   	                     Hj   0                        b      
                     Pi   0   
                     e   l                        f                           a                           `g                           e   \                        Xf                           d                           `j   `                         d      "                       b                           i                           i      x                      g   <                        h       '                      f      "                      @c   l                        a   h    
                     8e                           d   8                        x^   @                        8_   X                         i                           b                           p_      	                     a                            c   t                        _                           0j                           h   H                        pg   X                        d                            d      
                     ^   p                        `i                           hb                           h                           b                           i   t                        b      
                     @f   x                        Hi                           d   `                        d                            0b   X   
                     h   P                        h       	                     f   0                        0f                           c   X                        Hd   P                        g   0                        b                           f   4                        c   D                         i   8                        e   (                        @d                           8i      H                     xe                           j   8   	                     Xc   8                        i   X                        `h      
                     e   ,                        b      	                     pe      	                     j   X   
                     e                           `c   l                        i   0   	                     0g   `                        0d                           f      
                     hj      
                     i                           a   `   
                      j   T                        @i      	                      Ha      %                      h^   l                        Hh                           a                            Xb                             f   D                        b   H                        0e                           h                            b   L                         f                           a                           he   P                        pj                            Hc      	                     xa   ,                                                                        ^   _   8_           x^   p_   ^   ^                   h^   H^                   ^   ^                   x^   ^                   h^   H^   ^           ^           x^   _                   x^   ^                   x^   _   ^           ^           u                         .?AVtype_info@@            .?AVbad_array_new_length@std@@             .?AV?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@            .?AVfailure@ios_base@std@@                         .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AU?$located_exception@Vexception@std@@@lang@stan@@               .?AVsp_counted_base@detail@boost@@                 .N                         .?AV?$basic_filebuf@DU?$char_traits@D@std@@@std@@                          .?AV?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@               .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@            .?AVruntime_error@std@@            .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@                        .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@                     .?AV?$basic_fstream@DU?$char_traits@D@std@@@std@@                          .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@              .?AVbad_alloc@std@@                .?AVstream_logger@callbacks@stan@@                 .?AVadd_vd_vari@?A0xb25e4b0d@math@stan@@                           .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@                   .?AVexception@boost@@              .?AVlogger@callbacks@stan@@                        .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@                   .?AV?$dot_product_vari@NVvar@math@stan@@@?A0xb25e4b0d@math@stan@@                          .?AV?$basic_stringbuf@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                       .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AVstream_writer@callbacks@stan@@                 .?AVios_base@std@@                         .?AV?$adapt_dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             .?AVrange_error@std@@              ._K                .?AVstepsize_adapter@mcmc@stan@@                   .?AV?$unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVlength_error@std@@             .?AVdomain_error@std@@             .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVcovar_adaptation@mcmc@stan@@                           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVbase_adapter@mcmc@stan@@               .?AVclone_base@exception_detail@boost@@            .H                 .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                .?AV?$basic_iostream@DU?$char_traits@D@std@@@std@@                         .?AV?$adapt_unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVbad_exception@std@@            .?AVunit_e_point@mcmc@stan@@               .?AVrandom_var_context@io@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@                        .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AUbad_alloc_@exception_detail@boost@@            .?AV_Facet_base@std@@              .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@                     .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AV?$adapt_unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              .?AVbad_typeid@std@@               .?AVps_point@mcmc@stan@@                   .?AV?$dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AU_Crt_new_delete@std@@                  .?AV?$_Iosb@H@std@@                .?AVpy_var_context@io@pystan@@             .?AV?$diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AUbad_exception_@exception_detail@boost@@                .?AV?$numpunct@D@std@@             .?AVvari@math@stan@@               .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                     .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@                   .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AV?$diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AVdump@io@stan@@                         .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@                        .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@             .?AVmultiply_vd_vari@?A0xb25e4b0d@math@stan@@              .?AVop_v_vari@math@stan@@                  .?AVlogic_error@std@@                      .?AV?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                   .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@            .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@            .?AVprecomputed_gradients_vari@math@stan@@                 .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVadd_vv_vari@?A0xb25e4b0d@math@stan@@                   .?AVbad_cast@std@@                 .?AVvar_adaptation@mcmc@stan@@             .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                       .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVrounding_error@math@boost@@            .?AVunderflow_error@std@@                          .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@                 .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@                       .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                  .?AVsum_v_vari@math@stan@@                 .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@                       .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@                          .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@              .?AVempty_var_context@io@stan@@            .?AV?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AV?$adapt_diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                .?AV?$basic_istream@DU?$char_traits@D@std@@@std@@                  .?AVbase_adaptation@mcmc@stan@@                    .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@               .?AVvar_context@io@stan@@                  .?AV?$basic_ios@DU?$char_traits@D@std@@@std@@              .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                   .?AVchained_var_context@io@stan@@                  .?AVfacet@locale@std@@             .?AVdiag_e_point@mcmc@stan@@               .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                  .?AVfixed_param_sampler@mcmc@stan@@                .?AVout_of_range@std@@             .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@                         .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                 .?AVstepsize_var_adapter@mcmc@stan@@               .?AVoverflow_error@std@@                           .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@            .?AVstepsize_covar_adapter@mcmc@stan@@             .?AVbase_mcmc@mcmc@stan@@                  .?AVexp_vari@?A0xb25e4b0d@math@stan@@                      .?AUPyErr_CheckSignals_Functor@?A0xb25e4b0d@pystan@@               .?AVdense_e_point@mcmc@stan@@                      .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@                 .?AVsum_values@pystan@@            .?AVop_vd_vari@math@stan@@                 .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@                  .?AVinvalid_argument@std@@                 .?AVop_vv_vari@math@stan@@                 .?AVinterrupt@callbacks@stan@@                     .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@                      .?AV?$basic_ostream@DU?$char_traits@D@std@@@std@@                  .?AVbad_lexical_cast@boost@@                       .?AV?$adapt_diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                      .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                        .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@                     .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@             .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AVprob_grad@model@stan@@                         .?AV?$adapt_dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                           .?AVanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@            .?AVwriter@callbacks@stan@@                .?AVpystan_sample_writer@pystan@@                  .?AVexception@std@@                .?AVsample@mcmc@stan@@             .?AVstepsize_adaptation@mcmc@stan@@                        .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                 .?AVwindowed_adaptation@mcmc@stan@@                .?AVvalue@pystan@@                         .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@                   .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@               .?AVcomment_writer@pystan@@                .?AV?$unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@            .?AV?$dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                                         V  
 `    
     
    >  
 @  ^  
     
     
   
  
 0    
     
   F  
 P    
     
     
      
    V  
 `    
     
     
      
      
     
     
     
   &  
 0  F  
 p    
   3  
 `    
   %  
 0  p  
 p    
   y  
     h
 p    
    m$  
 $  $  
 $  %  
  %  K%  
 P%  t%  
 %  &  
 &  2'  
 @'  '  
 '  4)  
 @)  )*  
 0*  *   
 *  +   
 +  T,  8
 `,  -  8
 -  D-  
 P-  %.  H
 0.  Y.  
 `.  .  
 .  .  
 .  /  T
 /  /  
 /  [0  
 0  0  
 0  0  
 0  1  
 1  1  
 1  1  
  2  2   
 2  2  
 2  3  P
 3  3  
 3  4  
 4  4  
 4  5  
 5  5  
 5  #6  
 06  p6  
 6  6  
 6  6  
  7  &7  
 07  g7  
 p7  7  
 7  8  
  8  g8  
 p8  8  
 8  9  
 9  :  0
 :  ;  
 ;  <  
  =  =  
 =  1>  H
 @>  k>  
 p>  ?  8
 ?  ?  
 ?  @@  x
 @@  @  x
 @  @  
  A  C  
  C  TC  
 `C  ]D  
 `D  F  
 F  G   
 G  5K  
 K  L  
 L  WL  
 WL  L  
 L  L  
  M  .M  
 0M  M  
 M  M  
 M  P  
 P  R  
  R  _T  
 T  U  
 U  2V  ,
 @V  V  h
 `W  X  
  X  X  
  Y  NY  
 PY  Y  
 Y  xZ   
 Z  F\  X
 P\  t\  
 \  \  
 \  ]  
 ]  _  (
  _  6`  
 @`  `  
 0a  Rc  
  e  e  0
 e  g  <
 g  i  
 i  l  
 l  <l  0
 <l  l  <
 l  l  X
 l  m  l
 m  m  |
 m  m  
 m  o  
  o  >p  
 @p  r  
 r  r  @
 r  r  H
 r  Ps  \
 Ps  s  p
 s  s  
 s  s  
  t  .t  
 0t  t  
 @u  u  
 @v  v  
 v  {  0
  {  L{  
 P{  {  
  |  `~   
 `~  ~  
 ~  ~  
 ~    
      x
     
   ހ  
   ނ  
     
   $  
 0    
      p
   ]  
 `         $    0  G    P    8     H     \     l     
   ]  
 `  ě  H
 Л     
      0   Ҝ  D     
     X О    p   g  
 p    0   4   @  Τ   Ф            M   M  ڦ   ڦ  j    j    0   է  H է        {  \   Ǩ  | Ǩ            3   3  j   j            L   P    
   ϫ   ϫ    (   	  < 	  >  L >    `   ʭ  x ʭ  خ   خ       1   @    |   H   H       ?  
 @  y  
     
   ֳ  
     
             r  
     
   (  	 0  E  	 P    P
           D
     H        Z  0   {  p         P   P       V  8 V  z  L z    \     
       l          1   @    P        {   {         
                m   p    h   L  h P       f  ( p  Z   `    p                       ~            X         0     Y  `       i	 $ i	 	 @ 	 - P 0 R 
 `  (  q `     ;  @      0   1  @ r   s   s x  !  ! "  " $  $ (   ( @+ X  @+ c.   p. /  / 0  0 B1  ! P1 5 (! 5 6 !  6 6 " 6 7 H"  7 {7 x" 7 7 " 7 8 
  8 8 
 8 8 
 8 9 " 9 9 
  : P: 
 P: : 
 : ; 
 ; A; 
 P; 
= " = r= 
 = = 
 = R> 
 `> > 
 > -? 
 0? d? 
 p? @ 8
  @ @ # @ CA $ PA A 
 A A 
  B 4B 
 @B N 8
 N O $ O NT $ `T T 
 T [ P%  \ \ 0& \ ] h&  ] ] & ] ] 
 ] ^ & ^ ^ 
 ^  _ 
  _ @_ 
 @_ _ 
 _ ` & ` f` 
 p` ` 
 ` &a 
 0a a 
 a a 
 a Lb (' Pb b X' b ,c ' 0c c ' c d 
 d d 
 d Ie ' Pe r x(   8
   N  2 P  d8  f (9 p [ `9 `  :   
   װ 8
  T H
 ` # < 0  x<   
   O 8
 P  <  ɵ 
 е  
   ) 
 0 Y 
 `  <   * h= 0 ˻ > л | >  Ƚ X? н  x?   ־ ?  *  @ 0 : @ @  @A   LA   `A  r 
   
   pA   V 
 `  pA   
   T pA `  
   pA   6 
 @  pA  Z A `  
   8
  W A `  
   
  a TB a  `B   xB   B   T 
 `  B    B    B    
   "  t "   
  D 
 P  
   
   
  F 
 P  
   H
  8 B 8 F B P  B    
  d tC p  C   C   C  " C 0  C   (D    XD  z lD   |D   f D p > XD @ 3 D @ 4 
 @ p E p  
  @ 
 @ X H
 X  E   E  h E p  
    H
  e 4F e s HF   
 @  TB  2 XF 2 | pF |  F   B  0 F 0 D F P  
  f 
 p \ 
 ` x H
 x  F   F  + 
 0 { 
   
  Z 
 `  
  7 8
 @  
   F   
   
  ` 
 `  
  	 
   F    G  =  G @ n 
 n  hG   |G   
  < G   G   # 
 0  
    G   6 @H @ c 
 p  
  ( H (  H   H    H P  H  F H F h H h  I   
  D 
 P  8
   8
  7	 
 @	 	 I 	 I
 HI P
  
    
  b 
 p 8 C @  
  s I   
    
   
   b J p  
   
  $ 
 0  
  I hJ P  C    J    K   K    J   (K   @K  O  
 P  :! PK @! *" K 0" " 
 " 2# 
 @# # 
 # 4$ 
 @$ $ 
 $ 3% 
 @% % 
 % '& 
 0& & K & & K  ' ' 8
 ' ( K ( ) 8
 ) + L + , 
 , - 8
 - . 8
 . / $L / 0 8L 0 22 LL @2 [3 `L `3 3 
  4 6 xL 6 57 L @7 7 8
 7 8 L 8 Q9 
 `9 9 
 9 ; M ; '< M 0< < 
 < < 
 A B 
 B B 
 B C 
 C C PM C D hM  E rE 
 E KF PM PF G M  G G 
 G  H XD  H H 
 H I M I fJ M pJ J XD J K 
  L M hM  M M 
 M 5R M @R V M V yW N W X 
 X aX $N pX X 
 X Z @N  Z ^ 4O ^ C^ TO C^ _ dO _ _ xO  _ _ O _ ` O  ` ` 
 ` a PM b b O b =d O =d Md O Md d O d d O d mf O mf }f O }f f O f g 
  g 7i P @i Ik P Pk dm Q pm m 
 m ;n $L @n fn R fn n R n n R  o {p R p Ir 8S Pr s S  t Qt 
 `t u T u v XD v `v 
 `v ow T pw w U w x U x y 
 y y U y z 
 z z V z { `V { d| V p| | 
 |  V    8W  ۂ 
   X  : `X @ ؈ X   XY   
  N 
 P  
   
  f 
 p ƌ 
 Ќ & 
 0  
  ƍ Y Ѝ  Z  F Z P  Z  Ǝ P[ Ў  [  F  \ P  \  Ə \ Џ  X]  F ] P  (^  Ɛ ^  W ^ `  8_   b  6 Xc @ p (d p  d  v e  * g 0 & 0h 0  h   h   i    i   8
   W 8
 ` h hi p  i  Y i `  
   i    j   j   $j  F 0j F R Lj R _ \j `  8
   8
   
  h xj p . j @ l 
   
   j   
   ~  k   Pk   k   hl   l   l   @m   m   | m  r m   (n   j Xn p  n  l n  W n p , N 0  \o    8
   o    p  K 
 P r 
   Pp   p  O XD P  
  \ N `  p   g p p 	 dq  5 
 @  
   
  J |q P  q    Hr    0s    Ls  T s T  s   s  
 s 
 t
 s 
  pt    t  , t , g t p  
   t    u   pu    pv    v    v   9% hx @% I) y P) + z + 2,  { @, 05 @{ 05 HE l} PE xU  U Y   Z :[  @[ \ 0 \ *^ p 0^ _  _ b  b f ` f g  g i ( i j ` j l  l mo Ѕ po *s P 0s Vx  `x }  } Ҍ 0  ?  @   p  Ѝ   ܍     9  @ ޞ   ~          (  5 8 @ N  N R P R S h S  x     (  ( )  ) E  `  Џ  Ӣ Ѝ Ӣ e p e f  f   У M  P ئ   + 8
 0  x  H  H Ϫ  Ϫ    ` ̑ `        ,   <  | L   
   
     ^  `  
     / 
 0     
   
   l 
 p  
   
   ? 
 @  
   
   
   
   
  A 
 P C @ P }   l ` p     
     6 ̗ 6 D  P  
  ' 
 0     `   
   
   z 
       Ԙ      -  - n  n ~     
  6 
 @ $ 0 0  h  = t   
  V | `        H   z    
  :  @ * @ 0 z h      
   Z  `      0   X           P ̝ P 8 ܝ @     O  S P p  
  \ 
 `  
  L 
 P    +  + 6 X 6 ]F  `F nQ  pQ 5R O @R S 0 S S  S VT 
 `T :U  @U iV  pV 6_  @_ 2`  @` a h a 
b  b Uf  `f h X  i i  i j  j Po  Po o `  p p  p cq  pq r 8 r >s H >s 
t \ 
t t p t Mu  Mu nu  pu w  w 
|  | 	   - T 0 )  0 T  `  
  ?  @ U 0 U  <   P  , 
 0  `     p ҕ 
   
  % 
 %          Ș 
 Ș . T . U h ` ߙ x  / t 0 O  P g 0 g  <   X  C h C  t          s  8  8 [  [ ?  @ 3 $ @  <  f T p ~ ` ~  l  e  e       & Ĺ 0    & , 0  x  d  d    ۵ ĺ ۵     @  @ _ 
 `  
  ʼ  м           H         h          @     X  S	  `	 d  p  4   H   p  m"  p" t'  ' =)  @) +  + + 0 + ,  , %,  0, .  . .  . 0/  0/ v/  / /  / / $ / 60 @ @0 A2 P P2 6 p 6  8   8 H  H K (  L ]  ] ]  ] ^ H ^ ^ 
 ^ X_ x `_ !`  0` ` 
 ` a p a a 
 a Fb 
 Pb b 
 b c 
 c c  c c 
 c hd  pd .e 8 0e oe 
 pe e h e /f 
 0f f  f Eg  Pg g  g 6h  @h h @ h j h j l   l n X @o ^p d `p wq  q r 
 `r r 
 r t   u v    v v 
  w Gw 
 Pw z P  z z  z { 
 { |   | &}  0} N}  N} }  } }   } ~     P  4 `   
      h  ֌ P  t 
                * P @  0   . 
 0     @  % 0 0 z `      |   u   {    3 x @  
  6 
 @     9 C 9 q  q w    
  D 
 P Ʃ 
 Щ  
   
  Ī 
 Ъ F 
 P  
   
  ì    O   6 ( @  
     ̶  ж v P   
  9 0 @ l  p      p  j 8 p ^  `  
  < 
 @     E 
 P           8
            $  i < i  P  O ` P  t        #  0 < $ @  
   
   Q  `     
    
   / 8 0  (  c  p  0              "  " # $ # I$  P$ X'  `' + h + .  . 2 8 2 7 x  7 }7  7 7 H 7 P8 8
 P8 	;  ; ; t ; i>   p> ?   ? d? 8 p? ?  ? ? h ? A t A A   A :A  :A A  A A  PB jB  jB C  C C   C ?C 
 @C F  F L  L O   O ^O 0 ^O P D P Q \ Q  R l  R 0S  0S  T   T cW  pW lY  pY Z  Z V[ x `[ [ 
 [ [ 
  ] ]  ] %^ 
 0^ _  _ qa  a b  b d O d e P e Sf  `f f 
 f Sg 
 `g g 
 g rh  h h  h k  k l  l n  n fo  po p  p y  y y 	 y '{  	 0{ ~ D	 ~  	   $  i 	 i  	  O 	 P T 
 `  
  o 
 o  
   
  L P P C  P  
   `  "  0    / 
 / e  e ף   ۥ    
  5  5        ,        ̬  ̬ J  J   @ T ( T  0   D  Ѯ ( Ѯ i T i  h   ( H (  x  [  `  (  V  V   @ h H h           8   
        %  0 O 
 P        
  H   P  H   _ 
 `  x   
      :  @  O     , @ 0 f  p        U @ `  h  F  P    E  P    6 0 @  X  :  :         O   
         @  z   ]  ]       c ( p  x                 >  @     
   $   @    P   
  / 
 0  
   
   
 `    D  P ;  @    A  A U   ` J 0 J  @   T   p  0  0    )  )    \  \ b  b y  y    E  E   $    <   P   d   t  t         	  	 
  
 v   $
    
      H     A O P k $L p       6  6 E  E F  P      H    x
  _   _ r    a   p  O   G ( G         !     (   u! (! u! " D! `" " ( " E# T! E#  $ t!  $ $ ! $ $ ! $ $ ! $ $ ( $ S% ! S% % !  & ' ! ' ) H" ) N) " N) 5+ " 5+ + " + , " , L- " L- - # - - 
 - 8. # @. . @#  / @/ 
 @/ / 
 / / p#  0 
3 x 3 l5 X p5 6 # 6 6 # 6 {8 # {8 8 $ 8 W9  $ `9 9 ,$ 9 U: X$ `: : $ : F; $ P; ; $ ; c< $ p< #= 0% 0= = h% = c> % p> @ % @ GA @& GA BB `& BB ,D t& 0D D 
 D D 
 D EF & PF 5G & @G G 
 `H -I X 0I K &  L %L ( %L L ' L M ,' pN N H N \O <' \O O X' O O H O P h' P P ' R R ' R S ' S S ' S CT ' CT ET ' PT ~T ' ~T V ' V V $( V V 
 V XW L( `W X x(  X X ( X 7Y ( @Y Y 
 Y [ O [ %\ 8) 0\ z\ `) \ ] )  ] {] ) {] 3^ ) 3^ ~^ ) ^ 3_ ) @_ _  *  ` |d h* d +h * 0h Oh 
 Ph oh 
 l xm H+ m o p+ o q + q u + u z (, p{ { ( { U| l, U| } , } =} ( =} ~ , ~ ~ ,    ,    -   h-   X   J - P  -   -  [ - `  -   ō 0. ō  H.  E . P q . q  .  & . & m . m v .   (  e . e   /   < / < t (/ t { @/   0   P/   d/  5 t/ 5 Z / Z Ӧ / Ӧ a / a + / 0 z 0 z P 0 P  80   O   H0  A 0   0  
 0  +  1 0 \ h1 \ P t1 P Q 1 `  1   1  D 1 P  2   2   H  | 2 |  2   t/   2  K  3 K  3    3   D3   `3   x3   3  R 3 R d 3 d  3   H   3   4 0  `  
 4  
  4  - X4 -   d4    |4   4  K 4 P  5  H  5 H  @5  # P5 0 P l5 P  5  H 5 H  5   5    X 8
 
 6 
 
 
 `  86   8
   
   
  \
 
 \
 
 
 
  
    8
   
  - 
 0 d 
 d y 
 |  
   
   XD   P 
 P d 
 d  
  y d6 |  <6  < 
 < g 
 h  
   
   
  \ 
 \  p6  
 6   6  X XD X  8
   
   6   6  a  7 d  
   
  < 
 < \ 
 \ " 7 8   7   
 4 O 
 X  8
   8
   47  )  T7 )  W  h7 W    7   $! 7 $! Z! 7 Z! i# 7 i# # 7 # ?$ 7 P$ $ 7  % % 7 % [&  8 p& 
( 8 ( Y( (8 `( J) 48 P) ) D8 ) * L8 * + T8  , w, `8 , , h8 - o- 8 - - 8 0. C. 8 C. . 8 . . 8 . Q/ 8 `/ L0 8 `0 0 8  1 1 8 1 1 8 1 2 9 2 <3 9 <3 3 ,9 3 c4 @9 p4 4 T9 4 4 `9 4 5 t9 5 56 9 @6 6 9 6 7 9 7 A7 9 P7 8 9  8 8 9 8 8 9 8 0: 9 : ; 9  ; = 9 = = : = > : > G? (:  A A 4: A A <: A A P:  B YB h: YB xB p: xB B : B B : B 9C : 9C XC : XC C : C C : C D : D 8D : 8D hD ; hD D $; D D 4; D E <; E HE P; HE lE h; E E x; E E ; E (F ; (F LF ; `F F ; F F ; F G ;  G yG ; yG G ; G G < G G $<  H H 4<  H /H << @H OH D< `H oH L< H H T< H H \< H H d< H H l<  I J t< 0J SK < `K K < K L < L L < L M <  M M < M M < M jN < jN N = N ,O = @O O $= O P 8= P WP L= `P Q \= `R R p= R S |= S S = S xS = xS S = S S = PT U =  V RZ = `Z t\  > \ \ > \ %] $> %] V] 8> V] u_ L> _ *` p> 0` a x> a a > a b > b c > c d > f :g > 0h h > h i > i j > 0j j > j k > k Zl > Zl l > l l ? l m ? m ~n $? ~n n 4? n o H? o pp X? p p `? p p t? p q ? q tr ? tr r ? r u ? u Fv ? Pv uw ? w x ? 0x tx  @ x x @ x Ay @ Ay Vy ,@ Vy cy @@ y z P@ z { \@  { T{ d@  | R| l@ `| | t@ | } @ } ~ @ ~  @    @ P  @   @  a @ p џ @  ӡ A  . A @ ۢ A  k (A   0A  > 8A P  HA   { TA  ޥ \A   lA   xA 0  A   A    A  + A @  A  M A   A    A  - A ` ͬ A   m A  
  B @  B   B P   B   \ ,B p Z 8B ` ` @B p  PB  2 XB 2 8 lB @  |B ж  B @  B  M B   B   B    B   B 0  B к  B  d B p  B  & B P  B  Ѽ C  6 C @  C    C   ޿ (C  ' 8C ' d @C d j TC p ^ dC p  lC  8 C @  C    $D  Q |D ` ( DE 0  E   (F   F 0  G    lG   G 0  G   G   G   G   G  E H P  H   H  G $H P  ,H   8H  G DH P  LH   TH   `H P  lH   tH   |H  E H   H   H  E H P  H   H  G H P  H   H  G H P  H   H    I P  I   I   I  E (I   4I   <I   DI   W PI `  XI   `I   	 lI ` 	  	 xI  	  	 I  	 	 I  	 U	 I 	 	 I 	 	 I 	 	 I 	 	 DJ 	 	 J 	 9	 K P	 >	 `K `	 N	 K p	 ^	 XL 	 !	 L  "	 )	 ,M )	 2	 HM P3	 3	 M  4	 5	 M 05	 >	 M >	 0E	 N @E	 
F	 O  F	 :F	 O :F	 W	 O W	 >W	 O >W	 W	 O W	 X	 O X	 X	  P X	 j	 ,P j	 k	 XP k	 k	 lP k	 l	 |P l	 -n	 P @n	 ^n	 P ^n	 y	 P y	 .y	 P .y	 |y	 Q |y	 Tz	 Q `z	 {	 DQ |	 )|	 XQ )|	 T	 dQ T	 p	 Q p	 	 Q  	 	 Q 	 	 R 	 8	 R @	 œ	 S Г	 Ȗ	 S Ж	 Ҙ	 S 	 p	 S 	 	 T 	 	 $T 	 	 0T 	  	 PT @	 G	 `T `	 h	 tT h	 	 T 	 ئ	 T 	 ʩ	 T 	 	 T 	 	 T 	 	 T 	 	 U 	 C	 ,U C	 	 <U 	 	 dU 	 	 U 	 	 U 	 	 U 	 &
 U &
 C
 U C
 r
 V 
 
 V 
 
 ,V 
 

 8V 

 

 `V 

 

 pV 

 P
 |V P
 l
 V 
 
 V 
 
 V 
 
 V  
 P
 V P
 /
 V /
 
 W 
 ;
 ,W P
 
 HW 
 
 `W  
 /
 hW @
 
 pW 
 
 W  
 "
 W "
 <#
 X P#
 _8
 X p8
 ;
 t[ ;
 u<
 [ <
 D
 [ D
 ;M
 H\ PM
 
 \ 
 "
 p] "
 &
 |] &
 _
 ] _
 }
 ] }
 
 ] 
 
 ] 
 6
 ] @
 3
 ^ @
 w
 t^ 
 
 |^ 
 t
 ^ 
 
 ^ 
 G
 ^ P
 
 ^ 
 
 ^ 
 G
 ^ P
 
 ^ 
 
 ^ 
 
 ^ P
 
 ^ 
 d
 ^ p
 
 ^ 
 
 ^ 
 G
 _ P
 
 _ 
 
 _ 
 G
 $_ P
 
 ,_ 
 D
 4_ 
 
 @_ 
 
 H_  
 U
 P_ `
 
 \_ 
 ~
 h_ 
 
 t_  
 T
 |_ `
 
 _ 
 
 _ 
   _   ' _ 0 g _ p $ _  6 _ P  _  [ _   _  6 _ @  _    `  0
 ` 0
 L
 4` p
 
 D` 
  P`   l`  
 0
 |` 0
  `   `   ` 0  `   `   `     a   a   c    c  * c   d   e   @e   He   @% Pe P% ' g ' ' g ' ( g ( ( h  ) H) h H) ) h ) +* 0h @* * @h  + b+ Lh b+ + Th + + hh + F, |h F, , h , , h , , h - w- h x- - 
 - - H - s. h . . h /  2 h  2 4 i @5 B5 07 P5 v5 `
 5 5 `
 5 5 `
 6 7 `
 7 67 `
 P7 y7 `
 @8 n8 `
 L< z< `
 < ]=   = *>  P> >  (? #@   |A A `
 A XC  C C `
 C hE 0
 E dF 8 F &G  PN vN `
 T .T 1 T CU @8 U .V @8 V GW @8 W <X @8 X 'Y P8  [ F[ `
 P[ [ X= [ \ `
 p\ \ `
 \ ] `
 ] ^ `
 ^ (^ `
 0^ ^ @B ^ _ `C _ g_ E p_ _  F _ ` `
 0` ^` `
 ` ` I  a a J a a O a b  O b b P b 0c Q Hc c R c c `
 xd d pU d d `
 e e `
  f ;f Z @f [f pZ `f {f Z f f @[ f f [ f f \ f f x\  g g \  g ;g H] @g [g ] `g {g ^ g g ^ g g ^ ,h Lh `
 i i Hc i i d j $j d Hj dj e k Bk g Pk vk `
 k k `
 k k `
 k !l `
 pl l `
 l l `
 `m m `
 m m `
 m n Ho  n @n `
 @n mn `
 n n `
 n 
o `
  o Zo Pq `o o q o o `
 o )p `
 p p `
 p q `
 q q `
 q r `
 r ?r `
 \r r `
 r r `
 r s `
 ,s Zs `
 s t `
 4t !v X} { { Њ | | p 0} T}  `} }  } } `
 } } ` } } `
 ~ ~ `
     +  g   |        W     0   ډ X   `
   * `
 @ j `
   `
 u  @  9 `
  ؏   b @    `
  ; `
 @ i `
  ʑ `
    ͒  `
 * Ĕ     V !  D u `
  ʙ 8 4 _   Ԛ `
 4 O    0   H d  p  ȝ   4 O 8   `   x d      , w  d   T 
  P t `
   `
   `
   `
  ͦ `
 Ц  `
  ڧ `
    t H  ` H   x      د          P l `
 l  8   `
  г  г 
 `  , `
 , L  P      `
  д ( д  `
     , `
 , L X      5 h ж  @   *  `    ڹ    `
  Z  p  `
  ں `
 P z `
   `
   \6  3 `
 3 O `
 O  |  Ž D   tD  D <E \  E  ޾  F ޾  F 7 ` G l  dG   G / q |O   R  = S U r X r  X   [  : $[ : Z 4[ Z  <[   L[   T[  = d[ I r @\   \  L c L  c   ,c   <c  v Lc v  \c   lc  g |c g  c   c  X c X  c    e 9 V g 0  
  c 
 p  
   
  C 
 P  
   m 
 p  
  
 
   m 
 p  
  
 
   
                                                                                                                                                                                                                                                             1   0   
   b      6   G   J   N   P   N   W   N   ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=      8      8              B.?  B.?+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                        aw>,  tӰY  țuE  lX  2  Q[ -B {Q}<r uo[ h1 ֌b; 8bunz8 |eEk  䦅 1
 d< ˩:7q 4ۧ "4L *.!
 -a`N < '*6ڿ ,v OV+4 '6Go )TH H!o U:~$ %"U8b ;f /e< t_u gBV_ s bN6 L% Dh ۠*B 6w Ͱ77	 PNޟ}	 𣂑	 e]{f
 ]%>U
 yUk
 Z
 O3 G^v K Rݛ KW.g i  |J-
 X
 2
 _{3
 ?.P ڐ 'Za @En[vP ؐ 8             pL      p3                                 ?      ?b?b?UUUU?UUUU?:?:?wLYU?wLYU?v<y59=v<y59=              B.?  B.?      8C      8C+eGW@+eGW@                  @      @      @      @                                                                                                                                                                                                                                                                      0                 	  H   `                     <?xml version='1.0' encoding='UTF-8' standalone='yes'?>
<assembly xmlns='urn:schemas-microsoft-com:asm.v1' manifestVersion='1.0'>
</assembly>
                                                                                                                                                                                                                                                                                    PXhpxȪЪت  (08@HPX`hpxxȬЬج  (08@HP            ȤФؤX`hpxȪЪت  (08@HPX`hpxȫЫث  (08HPX`hpxȬЬج  (08@HPX`hpxȭЭح  (08@HPX`hpxȮЮخ  PX`hpxȯЯد  \    (08@HPX`hpxȠРؠ  (08@HPX`hpxȡСء (08@HPX`hpxȢТآ  (08@HPX`hpxȣУأ  (08@HPX`pxȤФؤȥ  (08@HPX`hpxȦЦئ  (08@HPX`hpxȧЧا  (08@HPX`hpx  (08@HPX`hpxȩЩة   (08@HPX`hpxȫЫث  (08@HPX`hpxȬЬج  (08@HPX`hpxȭ8@HPX`hpxȮЮخ  (08@HPX`hpxȯЯد       (08@HPX`hpxȠР  (08@HX`hpx  (08@HPX`hpxȣУأ  (08@HP`hpxȤФؤ      \     (  (08@HPX`hpxȯЯد  
 ,     (08@HPX`hpx 
    ȣ     p   Шب  (0HPXpxȩЩ 8@HXXp(08HPXh    8PȣУأhpxȤФ 8@H`hpإ (08ȦЦئ @H`hȧا  (8@H`hxȨب  (8@HX`hȩ  (@H`hȪ     P   8PآXȨ 8`hpة@ȪhpXpxЭحXp x    h  8PРؠXСءȣУ @Hhp08X`Хإ  (HPpxȦ8@`hا (0PXxȨШ @Hhp08X`Ъت  (HPpxȫ8@`hج (0PXxȭЭ @Hhp08X`Яد        (HPpxȠ8@`hء (0PXxȢТ @Hhp08X`Фؤ  (HPpxȥ8@`hئ (0PXxȧЧ @Hhp08X`Щة  (HPpxȪ8@`hث (0PXxȬЬ @Hhp08X`Юخ  (HPpxȯ       8@`hؠ (0PXxȡС @Hhp08X`Уأ  (HPpxȤ8@`hإ (0PXxȦЦ (0@HPXpxЧا  (@HP`Ш(`@`HpP    P    HpPȢ pУ0Х Hp (Ppث@Э(`     H   ` أ 0xХ @Ч`0pЬ P PЯ   0 @   8xС@Ȥ `0`@0p0 ` @ D   P@ 8pإ@Ȧ hHxXP0 P $   @ P0`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ub.